﻿USE sofia;
DROP TABLE IF EXISTS sofia.rifl_vpl;
CREATE TABLE rifl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rifl_vpl WRITE;
INSERT INTO rifl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Deg umezwaru ixřeq-dd AREBBI ijenwan d temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tuɣa tammurt texřa, am mammec war tt ittḥidi ḥed u x wudem n waman ihewřen taǧest, u Arruḥ n AREBBI tuɣa ittraḥ ittas-dd x wudem n waman. ");
INSERT INTO rifl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Uca inna AREBBI: “Ad tiři tfawt”, uca tusa-dd tfawt! ");
INSERT INTO rifl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Iẓra AREBBI belli tafawt teṣbeḥ uca ibḍa AREBBI jar tfawt d taǧest. ");
INSERT INTO rifl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Iřaɣa AREBBI tafawt ‘aziř’ u ‘taǧest’ iřaɣa as ‘ǧiřet’. Tedweř d tameddit u idweř d ṣṣbeḥ: d ass amezwaru. ");
INSERT INTO rifl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Uca inna AREBBI: “Ad tiři ict n řqubbet di řwesṭ n waman, ad tebḍa aman x waman!” ");
INSERT INTO rifl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","AREBBI igga řqubbet n ujenna uca ibḍa aman i iǧan swadday i řqubbet x waman i iǧan sennej i řqubbet. Uca ammu i temsar. ");
INSERT INTO rifl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Iřaɣa AREBBI i řqubbet ‘ajenna’. Uca tedweř d tameddit u idweř d ṣṣbeḥ: d ass wiss tnayen. ");
INSERT INTO rifl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Uca inna AREBBI: “Ad munen waman i iǧan swadday i ujenna ɣar ijj n wemcan maḥend ad dd-iban řbarr!” Uca ammu i temsar. ");
INSERT INTO rifl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Iřaɣa AREBBI i řbarr ‘tammurt’ u amuni n waman iřaɣa as ‘řebḥur’. Uca iẓra AREBBI belli man aya iṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Uca inna AREBBI: “Ad dd-tesseɣmi temmurt aɣemmuy aziza: afsu aziza i izarrɛen zzariɛet d tcejjura s fruta i dd itticen frutat ɛlaḥsab marka nsent s zzariɛet nsent dayes x wudem n temmurt!” Uca ammu i temsar. ");
INSERT INTO rifl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tesseɣmi-dd temmurt aɣemmuy aziza: afsu aziza i izarrɛen zzariɛet ɛlaḥsab marka nnes d tcejjura i dd itticen řɣiǧet ɛlaḥsab marka nsent s zzariɛet nsent dayes. Uca iẓra AREBBI belli man aya iṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Uca tedweř d tameddit u idweř d ṣṣbeḥ: d ass wiss třata. ");
INSERT INTO rifl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Uca inna AREBBI: “Ad din iřint tfawin di řqubbet n ujenna ḥima ad bḍant jar wass d ǧiřet, ad iřint d řimarat, d wussan ittwaggen, d wussan, d iseggʷusa ");
INSERT INTO rifl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","uca ad iřint d tifawin di řqubbet n ujenna ḥima ad wcent tafawt x temmurt!” Uca ammu i temsar. ");
INSERT INTO rifl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Igga AREBBI tnayen n tifawin mɣarent, tafawt tameqqrant, ḥima ad teḥkem x uziř, u tafawt tameẓyant ḥima ad teḥkem x ǧiřet, uca uřa d itran. ");
INSERT INTO rifl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Issars i-tent AREBBI di řqubbet n ujenna ḥima ad wcent tafawt x temmurt ");
INSERT INTO rifl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","u ḥima ad ḥekment x wass d ǧiřet u ḥima ad bḍant jar tfawt d taǧest. Uca iẓra AREBBI belli man aya iṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Uca tedweř d tameddit u idweř d ṣṣbeḥ: d ass wiss arebɛa. ");
INSERT INTO rifl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Uca inna AREBBI: “Ad dd-ssefyen waman s waṭṭas n marra min di iǧa buḥbeř iddaren uca ad ḍwen ijḍaḍ sennej i temmurt ɣar mani teǧa řqubbet n ujenna!” ");
INSERT INTO rifl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ixřeq-dd AREBBI imuddaren imeqqranen di řebḥar u marra buḥbeř iddaren ittenhezzan, inni zi dd-ssefyen waman, ɛlaḥsab marka nsen uca marra ijḍaḍ s wafriwen ɛlaḥsab marka nsen. Uca iẓra AREBBI belli man aya iṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ibark i-ten AREBBI, inna: “Jjem-dd řɣiǧet, ktarem, ɛemmarem aman n řebḥur, uca ad ktaren ijḍaḍ di temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Uca tedweř d tameddit u idweř d ṣṣbeḥ: d ass wiss xemsa. ");
INSERT INTO rifl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Uca inna AREBBI: “Ejj temmurt ad tessuffeɣ marra min ɣares buḥbeř iddaren ɛlaḥsab marka nnes: řebhayem d imuddaren nni ittbuɛen d řmař n řexřa ɛlaḥsab marka nsen!” Uca ammu i temsar. ");
INSERT INTO rifl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Igga AREBBI řmař n řexřa n temmurt ɛlaḥsab marka nsen, u řebhayem ɛlaḥsab marka nsent u marra imuddaren nni ittbuɛen x wudem n temmurt ɛlaḥsab marka nsen. Uca iẓra AREBBI belli man aya iṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Uca inna AREBBI: “Ejj aneɣ ad negg Adam, bnadem di ṣṣifet nneɣ, deg warwas nneɣ, uca ad ɣares yiři jjehd x iseřman n řebḥar u x ijḍaḍ n ujenna u x řebhayem u x marra tammurt u x marra imuddaren nni ittbuɛen x temmurt!” ");
INSERT INTO rifl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ixřeq-dd AREBBI Adam di ṣṣifet nnes. Ixřeq i-t-i-dd di ṣṣifet n AREBBI, ixřeq i-ten-dd awtem d tewtemt. ");
INSERT INTO rifl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ibark i-ten AREBBI uca inna asen AREBBI: “Jjem-dd řɣiǧet, ktarem, ɛemmarem tammurt uca arrem tt sadu ufus nwem, ḥekmem x iseřman n řebḥar u x ijḍaḍ n ujenna u x marra imuddaren nni ittbuɛen x temmurt!” ");
INSERT INTO rifl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Inna AREBBI: “Xzarem, ad awem wceɣ marra afsu aziza i izarrɛen zzariɛet x marra wudem n temmurt, uřa d marra ticejjura s řɣiǧet nni izarrɛen zzariɛet. Man aya ad awem yiři d macca.    ");
INSERT INTO rifl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","U i marra řmař n řexřa n temmurt, u i marra ijḍaḍ n ujenna u i marra min ittbuɛen x temmurt i di iǧa buḥbeř iddaren, ad asen yiři marra afsu aziza d macca i nitni.” Uca ammu i temsar. ");
INSERT INTO rifl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Uca iẓra AREBBI marra min igga, u xzar, tuɣa iṣbeḥ aṭṭas. Tedweř d tameddit u idweř d ṣṣbeḥ: d ass wiss setta. ");
INSERT INTO rifl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ammu i ttwakemmřen ijenwan d temmurt d qaɛ řɛeskar nsen. ");
INSERT INTO rifl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Deg wass wiss sebɛa ikemmeř AREBBI řxedmet nnes i igga uca yareyyeḥ deg wass wiss sebɛa zi marra řxedmet nnes i igga. ");
INSERT INTO rifl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ibarek AREBBI ass wiss sebɛa uca issqeddes i-t, minzi dayes i yareyyeḥ zi marra řxedmet nnes, řxedmet i dd-ixřeq AREBBI maḥend ad tt igg amenni. Ina d imezruyen n wexřaq n ujenna d temmurt řami dd-ttwaxeřqen. ");
INSERT INTO rifl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Deg wass i igga SIDI AREBBI tammurt d ijenwan ");
INSERT INTO rifl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","- qbeř tuɣi din marra cbarq di temmurt u qbeř dd-iɣmi wefsu n yeyyar, minzi SIDI AREBBI war ijji anẓar ad iwwet ɛad x temmurt - uca war tuɣi din Adam ɛad ḥima ad ixdem tammurt, ");
INSERT INTO rifl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","tgeɛɛed-dd tayyut zi temmurt, tessu marra udem n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Uca ikewwen SIDI AREBBI Adam zi tɛejjajt n ucař uca isuḍ řeɛwin n tudart deg wenzaren nnes. Ammu i idweř Adam d ijj n nnefs iddar. ");
INSERT INTO rifl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Xenni iẓẓu SIDI AREBBI jjennet di Ɛadn, jjihet n ccarq, uca issars din Adam i igga. ");
INSERT INTO rifl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Uca isseɣmi-dd SIDI AREBBI zi temmurt kuř tacejjart, tecna i řxeẓrat u tmiẓidt i macca, uca isseɣmi-dd řa d tacejjart n tudart di řwesṭ n jjennet uřa d tacejjart n tussna n řxar d řɣar. ");
INSERT INTO rifl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Iffeɣ-dd ijj n iɣzar zi Ɛadn, ḥima ad issuw jjennet u ssenni immsebḍa x arebɛa n izeǧifen i iggin tiseǧyawin. ");
INSERT INTO rifl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Isem n yeɣzar amezwaru d Ficun. Netta i innḍen i marra tammurt n Ḥawila mani iǧa wureɣ. ");
INSERT INTO rifl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ureɣ n temmurt nni iṣbeḥ. Aqa din aserɣaɣ acemřař qqaren as ‘bᵉdula’, d weẓru n ‘uniks’. ");
INSERT INTO rifl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Isem n iɣzar wiss tnayen d Jiḥun i tuɣa innḍen i marra tammurt n Kuc. ");
INSERT INTO rifl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Isem n iɣzar wiss třata d Ḥiddaqil. Netta ittazzeř ɣar ccarq n Accur. U iɣzar wiss arebɛa d Lfuraṭ. ");
INSERT INTO rifl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Iksi SIDI AREBBI Adam uca issars i-t di jjennet n Ɛadn, ḥima ad tt ixdem u ad tt iḥḍa. ");
INSERT INTO rifl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","SIDI AREBBI iweṣṣa Adam, inna: “Zi marra ticejjura n jjennet ad tecced macca, ");
INSERT INTO rifl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","maca zi tcejjart n tussna n řxar d řɣar war ttᵉtted ca zzayes, minzi deg wass i zzayes ɣa tecced, řmewt i ɣa temmted!” ");
INSERT INTO rifl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Inna SIDI AREBBI: “War iɛeddeř ad yiři Adam weḥḥdes. Ad as ggeɣ wi t ɣa iɛawnen, am netta qibač nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tuɣa SIDI AREBBI igga zeg ucař marra řmař n řexřa u marra ijḍaḍ n ujenna, uca indeh i-ten ɣar Adam, ḥima ad iẓar mammec i ten ɣa isemma. Mammec i ɣa isemma Adam kuř nnefs iddaren d wa d isem nnes. ");
INSERT INTO rifl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Igga Adam ismawen i marra řebhayem d yejḍaḍ n ujenna u i marra řmař n řexřa, maca i Adam war yufi wi t ɣa iɛawnen d wi ɣa yiřin am netta qibač nnes. ");
INSERT INTO rifl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Issehwa-dd SIDI AREBBI ijj n yiḍeṣ yuǧeɣ x Adam uca iṭṭeṣ. Xenni iksi icten zi tɣezdisin nnes uca iqqen amcan yarezmen nni s weysum. ");
INSERT INTO rifl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yarra SIDI AREBBI taɣezdist tenni i iksi zi Adam d tamɣart uca yiwyi tt-i-dd ɣar Adam. ");
INSERT INTO rifl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Xenni inna Adam: “Twařa-ya tanita aqa-tt d iɣes zeg iɣsan inu d aysum zeg weysum inu. Tanita ad tᵉttwasemma ‘taryazt’, ixs ad yini ‘tamɣart’, minzi nettat tᵉttwaksi-dd zeg weryaz.” ");
INSERT INTO rifl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","X uya ad ismeḥ weryaz di babas d yemmas, ad iqqen ɣar temɣart nnes uca ad iřin d ict n ddat.    ");
INSERT INTO rifl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tuɣa-ten s tnayen idsen d iɛaryanen, Adam d temɣart nnes, maca tuɣa war din ca n řeḥya jar asen. ");
INSERT INTO rifl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tuɣa afiɣar d aḥraymi x marra řmař n řexřa i igga SIDI AREBBI. Inna i temɣart: “Ma d tidett inna AREBBI: ‘Ɣarwem war ttᵉttem ca zi marra ticejjura n jjennet’?” ");
INSERT INTO rifl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tenna temɣart i ufiɣar: “Zi řɣiǧet n tcejjura n jjennet nzemmar ad necc, ");
INSERT INTO rifl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","maca zi řɣiǧet n tcejjart di řwesṭ n jjennet, inna AREBBI: ‘War zzayes ttᵉttem, war tt ttḥadam, ḥima war tᵉttmettim.’” ");
INSERT INTO rifl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Inna ufiɣar i temɣart: “Kenniw war tᵉttmettim ca s řmewt qaɛ, ");
INSERT INTO rifl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","maca AREBBI issen belli ass nni di zzayes i ɣa teccem, ad arzment tiṭṭawin nwem uca ad tiřim am AREBBI, ad tessnem řxar zi řɣar.” ");
INSERT INTO rifl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Teẓra temɣart belli tacejjart teṣbeḥ i macca uca teɛjeb asent i tiṭṭawin, aqa tacejjart tegga dayes meẓri maḥend ad zzayes tedweř d tamiɣist. Xenni teksi zi řɣiǧet nnes, tecca uca tewca ɛawed i weryaz nnes i tuɣa akides, uca netta icca. ");
INSERT INTO rifl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nnarzment tiṭṭawin nsen uca ufin ixef nsen d iɛaryanen. Xenni xeyyḍen tifray n wartu, uca ggin zzaysent tibantiwin i yixef nsen. ");
INSERT INTO rifl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Xenni sřin nitni tmijja n SIDI AREBBI iggur di jjennet ɣar uweṭṭu n tmeddit, uca iffar Adam d temɣart nnes zeg wudem n SIDI AREBBI jar tcejjura n jjennet. ");
INSERT INTO rifl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Uca iřaɣa SIDI AREBBI Adam, inna as: “Mani teǧid?” ");
INSERT INTO rifl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Netta inna: “Sřiɣ i tmijja nnec di jjennet uca ggʷedeɣ minzi necc d aɛaryan, xenni ffareɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Inna as Netta: “Wi d ac innan belli cek d aɛaryan? Ma teccid zi tcejjart nni x cek weṣṣiɣ ‘Aqa ad zzayes tecced?” ");
INSERT INTO rifl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Inna Adam: “Tamɣart nni d ayi tewcid, nettat tewca ayi zi tcejjart uca cciɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Inna as SIDI AREBBI i temɣart: “Manawya i teggid?” Tenna as temɣart: “Iɣarra ayi ufiɣar uca cciɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Inna SIDI AREBBI i ufiɣar: “Řami teggid aya, aqa ac d amenɛuř jar marra řebhayem u jar marra řmař n řexřa. X uɛeddis nnec ad tmurded, uca ad tecced ucař marra ussan n tudart nnec. ");
INSERT INTO rifl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ad ggeɣ řeɛdawat jar ac d temɣart, jar zzariɛet nnec d zzariɛet nnes. D tenni nnes ad teřbez azeǧif nnec, u cek ad as třebzed anirz nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Inna i temɣart: “Aṭṭas i ɣa arniɣ řeḥriq d řewjeɛ n tarwa nnem. S řeḥriq ad dd-tarwed iḥenjiren, uca ɣar weryaz nnem ad temmeẓred, maca netta ad xam iḥkem.” ");
INSERT INTO rifl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Uca inna i Adam: “Minzi tesřid ɣar tmijja n temɣart nnec u teccid zi tcejjart tenni x cek weṣṣiɣ: ‘Aqa ad zzayes tecced!’, ad tiři temmurt d nneɛřet x ssibbet nnec. S tamara ad zzayes tecced, marra ussan n tudart nnec. ");
INSERT INTO rifl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isennanen d tzeggʷart i d ac dd ɣa tesseɣmi, uca ad tecced afsu n yeyyar. ");
INSERT INTO rifl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","S tidi n uɣembub nnec ad tecced aɣrum ař dd ɣa tdewřed ɣar temmurt i zi temmeksid, minzi cek d acař uca ɣar ucař i ɣa dd-tdewřed.” ");
INSERT INTO rifl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Iřaɣa Adam isem n temɣart nnes Ḥawwa minzi nettat d yemmas n marra inni iddaren. ");
INSERT INTO rifl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Igga SIDI AREBBI i Adam d temɣart nnes arruḍ s yiřem uca yarḍ asen t. ");
INSERT INTO rifl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Inna SIDI AREBBI: “Xzar, Adam wa, aqa idweř am yijjen zzayneɣ, issen řxar d řɣar. Řexxu, ejj i-t war isswaẓẓaḍ afus nnes maḥend ad iksi zi Tcejjart n Tudart ɛawed, ad yecc u xenni ad iddar i řebda.” ");
INSERT INTO rifl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Uca issuffuɣ i-t SIDI AREBBI zi jjennet n Ɛadn ḥima ad ixdem tammurt i zi tuɣa immeksi. ");
INSERT INTO rifl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yuẓẓeř x Adam uca igga ikiruben ccarq i jjennet n Ɛadn d yijj n ssif itteḥduduq, ittecḍiḍiḥ ssa d ssa i uɛessi x webrid n tcejjart n tudart. ");
INSERT INTO rifl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Issen Adam Ḥawwa, tamɣart nnes, uca teysi s ddeyset uca turuw-dd Qayin, tenna “Jjiɣ-dd aryaz, d SIDI!” ");
INSERT INTO rifl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Xenni ɛawed turuw-dd umas Habil. Tuɣa Habil d ameksaw n wuǧi u Qayin iruḥ ixeddem tammurt. ");
INSERT INTO rifl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Uca awarni ussan imsar belli Qayin iqeddem ict n tewhibt zi řɣiǧet n wudem n temmurt i SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Iqeddem Habil ɛawed ict n tewhibt zeg imenza n wuǧi nnes, zeg inni ɣar iǧa tadunt aṭṭas. Ixzar SIDI ɣar Habil d tewhibt nnes, ");
INSERT INTO rifl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","maca ɣar Qayin d tewhibt nnes war d as yarri ca taynit. Uca ixeyyeq Qayin aṭṭas, inneqřeb as uɣembub. ");
INSERT INTO rifl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Inna SIDI i Qayin: “Mayemmi txeyyqed? Mayemmi d ac inneqřeb uɣembub? ");
INSERT INTO rifl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mařa teggid mliḥ, ma war din ittiři usgeɛɛed, u mařa war teggid mliḥ, ddenb aqa-t izzeř ɣar tewwart? Meẓri nnes ɣarek, maca ittxeṣṣa cek ad xas tseǧḍed.” ");
INSERT INTO rifl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Issiweř Qayin ak-d Habil umas. Uca imsar am ǧan nitni deg iyyar, belli Qayin ikkar ɣar umas Habil uca inɣa i-t. ");
INSERT INTO rifl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Xenni inna SIDI i Qayin: “Mani iǧa umac Habil?” Inna: “War ssineɣ. Ma necc d ameḥḍay x uma?” ");
INSERT INTO rifl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Uca inna Netta: “Min teggid? Aqa tmijja n idammen n umac sɣuyyun-dd ɣari zi temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Řexxu, aqa cek d menɛuř zi temmurt, tenni yarezmen aqemmum nnes, ḥima ad teqbeř idammen n umac zeg ifassen nnec. ");
INSERT INTO rifl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Xmi ɣa txedmed x temmurt, war ttᵉdikkʷiř ad ac tewc marra jjehd nnes uca cek ad tiřid d amennejru d ametluɛ di temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Xenni inna Qayin i SIDI: “Lɛiqab inu imɣar aṭṭas x tzemmar inu. ");
INSERT INTO rifl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aqa Cek ass-a tuẓẓřed xafi zeg uɣembub n temmurt-a uca zeg uɣembub nnec ad ttwaffare. Ad iřiɣ d amennejru d ametluɛ di temmurt uca ad yiři marra wenni d ayi ɣa yafen ad ayi ineɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Xenni inna as SIDI: “S uya marra wenni i ɣa inɣen Qayin, ad zzayes xeřfen sebɛa n twařawin.” Uca igga SIDI řeɛřamet i Qayin belli marra wenni t ɣa yafen war t ineqq. ");
INSERT INTO rifl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Xenni iffeɣ-dd Qayin zeg wudem n SIDI uca iruḥ izeddeɣ di temmurt n Nud, ccarq n Ɛadn. ");
INSERT INTO rifl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Issen Qayin tamɣart nnes uca teysi s ddeyset uca turuw as-dd Ḥanux. Tuɣa Qayen ibna ict n tendint uca iřaɣa as i tendint am yisem n mmis Ḥanux. ");
INSERT INTO rifl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ḥanux ijja-dd Ɛirad, u Ɛirad ijja-dd Miḥuya’il u Miḥuya’il ijja-dd Matuca’il u Matuca’il ijja-dd Lamak. ");
INSERT INTO rifl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Imřec Lamak tnayen n temɣarin. Icten qqaren as Ɛada, tenneɣni qqaren as Ṣilla. ");
INSERT INTO rifl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Turuw-dd Ɛada Yabal. Netta idweř d babatsen i imezdaɣ n iqiḍan u i imeksawen n řebhayem. ");
INSERT INTO rifl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Isem n umas tuɣa d Yubal wenni tuɣa d babatsen i marra inni ittiraren řgambri d temja. ");
INSERT INTO rifl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ṣilla turuw-dd ɛawed Tubal-Qayin, amziř n imziřen n marra inni ixeddmen s nnḥas d wuzzař. Učmas n Tubal-Qayin tuɣa d Naɛma. ");
INSERT INTO rifl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Inna Lamak i temɣarin nnes, Ɛada d Ṣilla: “Sřent i tmijja inu, a timɣarin n Lamak! Sřent ɣar min ɣa iniɣ. Aqa nɣiɣ aryaz i uyezzim inu d uḥenjir i uyeddim inu! ");
INSERT INTO rifl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Aqa ad xeřfen zi Qayin sebɛa n twařawin, maca zi Lamak sebɛa u-sebɛin n twařawin.” ");
INSERT INTO rifl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Yudef Adam ɛawed x tamɣart nnes uca turuw-dd nettat aḥenjir. Třaɣa as Cit, minzi tenna: “AREBBI iwca ayi zzariɛet nneɣni deg wemcan n Habil, minzi Qayin inɣa i-t.” ");
INSERT INTO rifl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Uřa i Cit ittwaxřeq-dd useymi, uca igga as Anuc. Řexdenni ibda bnadem s uřaɣi x Yisem n SIDI. Wa d adlis ittwanḍen n imezruyen n yinni dd-ittwaxeřqen zi Adam. ");
INSERT INTO rifl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ass min di igga AREBBI Adam, igga i-t di ṣṣifet n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Awtem d tewtemt ixřeq i-ten-dd. Ibark i-ten uca iřaɣa asen s yisem ‘Adam’, bnadem, deg wass i di ten dd-ixřeq.    ");
INSERT INTO rifl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Awarni řami iddar Adam mya u-třatin n iseggʷusa, ijja-dd aḥenjir deg warwas nnes u di ṣṣifet nnes uca iřaɣa as Cit. ");
INSERT INTO rifl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Awarni řami dd-ijja Cit, iddar Adam ɛad temn-mya n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ammu i iddar Adam tesɛa-mya u-třatin n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Awarni řami iddar Cit mya u-xemsa n iseggʷusa, ijja-dd Anuc. ");
INSERT INTO rifl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Awarni řami dd-ijja Anuc, iddar Cit ɛad temn-mya u-sebɛa n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ammu i iddar Cit tesɛa-mya u-tenɛac n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Awarni řami iddar Anuc tesɛin n iseggʷusa, ijja-dd Qinan.    ");
INSERT INTO rifl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Awarni řami dd-ijja Qinan, iddar Anuc ɛad temn-mya u-xemmesṭac n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ammu i iddar Anuc tesɛa-mya u-xemsa n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Awarni řami iddar Qinan sebɛin n iseggʷusa, ijja-dd Mahalal-Il. ");
INSERT INTO rifl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Awarni řami dd-ijja Mahalal-Il, iddar Qinan ɛad temn-mya u-rebɛin n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ammu i iddar Qinan tesɛa-mya u-ɛecra n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Awarni řami iddar Mahalal-Il xemsa u-settin n iseggʷusa, ijja-dd Yarad. ");
INSERT INTO rifl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Awarni řami dd-ijja Yarad, iddar Mahalal-Il ɛad temn-mya u-třatin n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ammu i iddar Mahalal-Il temn-mya u-xemsa u-tesɛin n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Awarni řami iddar Yarad mya u-tnayen u-settin n iseggʷusa, ijja-dd Ḥanux.    ");
INSERT INTO rifl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Awarni řami dd-ijja Ḥanux, iddar Yarad ɛad temn-mya n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ammu i iddar Yarad tesɛa-mya u-tnayen u-settin n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Awarni řami iddar Ḥanux xemsa u-settin n iseggʷusa, ijja-dd Matucalaḥ.    ");
INSERT INTO rifl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Awarni řami dd-ijja Matucalaḥ, yuyur Ḥanux ak-d AREBBI teřt-mya n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ammu i iddar Ḥanux teřt-mya u-xemsa u-settin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Yuyur Ḥanux ak-d AREBBI uca war ittwif ɛad minzi AREBBI iksi i-t. ");
INSERT INTO rifl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Awarni řami iddar Matucalaḥ mya u-sebɛa u-tmanyin n iseggʷusa, ijja-dd Lamak. ");
INSERT INTO rifl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Awarni řami dd-ijja Lamak, iddar Matucalaḥ ɛad sebɛa-mya u-tnayen u-tmanyin n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ammu i iddar Matucalaḥ tesɛa-mya u-tesɛa u-settin n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Awarni řami iddar Lamak mya u-tnayen u-tmanyin n iseggʷusa, ijja-dd ijj n uḥenjir. ");
INSERT INTO rifl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Iřaɣa isem nnes Nuḥ, inna: “Wa ad aneɣ issfewwej x řxedmet nneɣ d tamara n ifassen nneɣ, minzi SIDI aqa inɛeř tammurt!” ");
INSERT INTO rifl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Awarni řami dd-ijja Nuḥ, iddar Lamak ɛad xemsa-mya u-xemsa u-tesɛin n iseggʷusa, ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ammu i iddar Lamak sebɛa-mya u-sebɛa u-sebɛin n iseggʷusa uca immut. ");
INSERT INTO rifl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Awarni řami iddar Nuḥ xemsa-mya n iseggʷusa, Nuḥ ijja-dd Cam d Ḥam d Yafat. ");
INSERT INTO rifl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Řami bdan iwdan ad ktaren di temmurt uca urwent asen-dd yessitsen, ");
INSERT INTO rifl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","aqa ẓrin arrawen n AREBBI belli yessis n bnadem cnant, uca ksin timɣarin i yixef nsen zi marra tinni ixḍaren nitni.    ");
INSERT INTO rifl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Xenni inna SIDI: “War ittɣimi Arruḥ inu řebda di bnadem, aqa-t d ddat zi ssibbet n uweddar nnes. Ad iřin wussan n tudart nnes mya u-ɛicrin n iseggʷusa.” ");
INSERT INTO rifl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Deg wussan nni tuɣa ‘inifilim’, ixs ad yini ‘inni iwḍan’, di temmurt uca awarni man aya ɛawed, umi dd-udfen arraw n AREBBI ɣar yessis n iwdan uca urwent asen-dd. Nitni d ‘jjwaheř’ n zzman nni, d iryazen s yisem. ");
INSERT INTO rifl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Iẓra SIDI belli řɣar n bnadem d aṭṭas x temmurt uca marra řemwayař n uxarreṣ n wuř nnes d aɛeffan kuř ass. ");
INSERT INTO rifl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Uca indem SIDI umi igga bnadem di temmurt uca iqqes as wuř nnes. ");
INSERT INTO rifl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Inna SIDI: “Ad mḥiɣ x wudem n temmurt bnadem i dd-xeřqeɣ, bnadem ak-d řebhayem d imuddaren ittbuɛen uřa d ijḍaḍ n ujenna, minzi nedmeɣ umi ten ggiɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Maca Nuḥ yufa arḍa di tiṭṭawin n SIDI. Ina d imezruyen n yinni dd-ittwaxeřqen zi Nuḥ. ");
INSERT INTO rifl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Tuɣa Nuḥ d aryaz d amsegged ikmeř jar marra jjiřat nni iddaren akides. Yuyur Nuḥ ak-d AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Uca ijja-dd Nuḥ třata n iḥenjiren: Cam d Ḥam d Yafat. ");
INSERT INTO rifl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tuɣa tammurt d ict n řxarbet di tiṭṭawin n AREBBI u tuɣa tammurt teccur s lɛunf. ");
INSERT INTO rifl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ixzar AREBBI ɣar temmurt, u xzar, aqa-tt d řxarbet, maɣar marra imeddaren s arrimet n weysum tuɣa xarrben abrid nsen x temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Inna AREBBI i Nuḥ: “Aneggar n marra imeddaren s arrimet n weysum aqa-t zzat i wudem inu, minzi tammurt teccur s lɛunf zzaysen. Aqa ad ten teḥḥiɣ ak-d temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Egg i yixef nnec ijj n uɣarrabu s ukeccuḍ n umerzi uca egg ixxamen i marra řmař deg uɣarrabu. Ɣeǧef aɣarrabu zi daxeř u zi barra s tizeft. ");
INSERT INTO rifl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ammu ittxeṣṣa ad t tegged: tuzzeggart n uɣarrabu ad tiři teřt-mya n iɣaǧen u tiru n uɣarrabu ad tiři xemsin n iɣaǧen u řuɛřa nnes ad yiři třatin n iɣaǧen. ");
INSERT INTO rifl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ittxeṣṣa ad tegged ict n tburjet i tfawt deg uɣarrabu uca ad tt tkemmřed anect n ijj n uɣiř zi sennej. Ad tegged tawwart n uɣarrabu deg uɣezdis nnes. Ad tegged ṭṭebqet n wadday d ṭṭebqet wiss tnayen di řwesṭ d ṭṭebqet wiss třata sennej. ");
INSERT INTO rifl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Aqa Necc ad ssekkeɣ sseḥřet n waman x temmurt, ḥima ad teḥḥiɣ sadu ujenna marra imeddaren s arrimet n weysum i di iǧa arruḥ n tudart. Marra min iǧan di temmurt ad iḍřeq i buḥbeř. ");
INSERT INTO rifl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Maca ad ssbeddeɣ Řɛahd inu akidek uca cek ad tadfed ɣar uɣarrabu, cek d iḥenjiren nnec d temɣart nnec d temɣarin n iḥenjiren nnec akidek. ");
INSERT INTO rifl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Uca zi marra min iddaren, zi marra imeddaren s arrimet n weysum ad tessidfed tyuya ɣar uɣarrabu ḥima ad ddaren akidek: ittxeṣṣa ad yiři d awtem d tewtemt. ");
INSERT INTO rifl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ad ɣarek dd-tas tyuya zi marra, ḥima ad teḥḍid tudart nsen: zeg ijḍaḍ ɛlaḥsab markat nsen, zi řebhayem ɛlaḥsab markat nsent u zi marra imuddaren nni ittbuɛen x temmurt ɛlaḥsab markat nsen. ");
INSERT INTO rifl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Uca cek, ksi i yixef nnec zi marra macca i ittwaccan uca smun i-tt ɣarek, ḥima ad ac yiři d macca uca uřa i nitni.” ");
INSERT INTO rifl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Uca igga Nuḥ am mammec marra i xef t iweṣṣa AREBBI, ammu i t igga. ");
INSERT INTO rifl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Inna SIDI i Nuḥ: “Adef cek d marra řaǧ n taddart nnec ɣar uɣarrabu, minzi ẓriɣ cek d amsegged zzat i wudem inu di jjiř-a. ");
INSERT INTO rifl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Zi marra řebhayem n řeḥřař ad ɣarek teksid sebɛa, sebɛa, awtem d tewtemt nnes, u zi řebhayem n řeḥram tyuya, awtem d tewtemt nnes. ");
INSERT INTO rifl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Uřa zeg ijḍaḍ n ujenna ittxeṣṣa ad teksid sebɛa n tiyuyawin, awtem d tewtemt, ḥima ad teḥḍid zzariɛet nsen i tudart di marra tammurt, ");
INSERT INTO rifl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","minzi xmi ɣa ɛdun ɛad sebɛa n wussan Necc ad jjeɣ anẓar ad iwwet x temmurt arebɛin n wussan d arebɛin n ǧyaři, uca ad teḥḥiɣ zeg wudem n temmurt marra min iǧan, d min ggiɣ Necc.” ");
INSERT INTO rifl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Uca igga Nuḥ am mammec kuřci i xef t iweṣṣa SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tuɣa Nuḥ d mmis n setta-mya n iseggʷusa řami dd-tusa sseḥřet n waman x temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Uca yudef Nuḥ ɣar uɣarrabu di ssibbet n waman n sseḥřet, netta d iḥenjiren nnes d temɣart nnes d temɣarin n iḥenjiren nnes akides. ");
INSERT INTO rifl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Zi řebhayem n řeḥřař u zi řebhayem n řeḥram u zeg ijḍaḍ u zi marra min ittbuɛen x wudem n temmurt ");
INSERT INTO rifl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","tudef tyuya s tyuya ɣar Nuḥ ɣar uɣarrabu, awtem d tewtemt am mammec iweṣṣa AREBBI i Nuḥ. ");
INSERT INTO rifl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Awarni sebɛa n wussan imsar belli aman n sseḥřet usin-dd x temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Deg useggʷas wiss setta-mya zi tudart n Nuḥ, deg uyur wiss tnayen, deg wass wiss sbeɛṭac n uyur nni, deg wass-a nnit, tuɣa ssefyen-dd marra řɛunṣarat n waman ihewřen uca ttwarezment tburjatin n ujenna. ");
INSERT INTO rifl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tuɣa anẓar iqqim iccat s jjehd x temmurt arebɛin n wussan d arebɛin n ǧyaři. ");
INSERT INTO rifl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Deg wass nni nnit tuɣa Nuḥ yudef ɣar uɣarrabu ak-d Cam d Ḥam d Yafat, ayt n Nuḥ, uřa ak-d tamɣart n Nuḥ u ak-d třata n temɣarin n iḥenjiren nnes akidsen, ");
INSERT INTO rifl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","nitni d marra markat n řmař n řexřa d marra markat n řebhayem d marra markat n imuddaren nni ittbuɛen x temmurt d marra markat n ijḍaḍ, marra ajḍiḍ, d marra min ɣar iǧa afriwen. ");
INSERT INTO rifl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Zi marra imeddaren s arrimet n weysum i di iǧa arruḥ n tudart, tusa-dd tyuya s tyuya ɣar Nuḥ ɣar uɣarrabu. ");
INSERT INTO rifl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","U zi marra imeddaren s arrimet n weysum i dd-yusin, yudef ijj n wewtem d ict n tewtemt am mammec t yumur AREBBI, uca iqqen SIDI tawwart awarni as. ");
INSERT INTO rifl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tuɣa sseḥřet x temmurt arebɛin n wussan uca geɛɛden waman uca ssgeɛɛden aɣarrabu ařami igeɛɛed sennej i wudem n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Geɛɛden waman uca mmarenyen-dd aṭṭas sennej i temmurt uca yuyur uɣarrabu x wudem n waman. ");
INSERT INTO rifl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Geɛɛden aman aṭṭas s waṭṭas, ařami marra idurar yuɛřan i din iǧan sadu marra ajenna, dewřen dřin. ");
INSERT INTO rifl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Uřyen waman xemmesṭac n iɣaǧen sennej i idurar uca dřin idurar. ");
INSERT INTO rifl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Marra imeddaren s arrimet n weysum i ittenhezzan x temmurt iḍřeq i buḥbeř nnes, ijḍaḍ d řebhayem, řmař n řexřa, marra imuddaren ittbuɛen, inni ittbuɛen x wudem n temmurt uřa d marra iwdan. ");
INSERT INTO rifl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Marra min di iǧa řeɛwin n arruḥ n tudart ɣarsen deg wenzaren nsen zi marra min din iǧan x řbarr, immut. ");
INSERT INTO rifl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Uca marra min din iǧan x wudem n temmurt ittwamḥa, zi bnadem ař řmař d imuddaren inni ittbuɛen d ijḍaḍ n ujenna. Ina ttwateḥḥan zi temmurt. Nuḥ weḥḥdes i iqqimen d marra min kides i iǧan deg uɣarrabu. ");
INSERT INTO rifl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Geɛɛden waman x temmurt mya u-xemsin n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Uca ixarreṣ AREBBI di Nuḥ u di marra řmař n řexřa d marra řebhayem i tuɣa akides deg uɣarrabu. Igga AREBBI ad yekk ijj n usemmiḍ x temmurt ařami arsan waman. ");
INSERT INTO rifl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Bellɛent řɛunṣarat n waman ihewřen d tburjatin n ujenna uca ibedd wenẓar zeg ujenna. ");
INSERT INTO rifl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Uca, am dd-ttasen ttraḥen, dewřen-dd waman zi temmurt. Awarni mya u-xemsin n wussan neqṣen waman. ");
INSERT INTO rifl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Deg uyur wiss sebɛa, deg wass wiss sbeɛṭac n uyur nni, yarsa uɣarrabu x idurar n Ararat. ");
INSERT INTO rifl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Qqimen waman neqqṣen ař ayur wiss ɛecra. Deg uyur wiss ɛecra, deg wass amezwaru n uyur, ḍharent-i-dd tqiccatin n idurar. ");
INSERT INTO rifl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Awarni řami ɛdun arebɛin n wussan, yarzem Nuḥ taburjet n uɣarrabu nni dayes tuɣa igga, ");
INSERT INTO rifl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","uca issekk abaɣeř. Wanita iffeɣ, iqqim ittraḥ ittas-dd ařami bdan waman ttaẓɣen x temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Xenni issekk ssenni tadbirt, ḥima ad iẓar, ma aman neqṣen x wudem n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Maca war tufi tedbirt mani ɣa tessars tařeqqa n uḍar nnes uca teɛqeb-dd ɣares ɣar uɣarrabu, minzi aman tuɣa aten ɛad x wudem n marra tammurt. Isswiẓẓeḍ afus nnes, iṭṭef i-tt uca issidef i-tt-i-dd ɣares deg uɣarrabu. ");
INSERT INTO rifl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Iraja ɛad sebɛa n wussan nneɣni, xenni issekk tadbirt ɛawed zeg uɣarrabu. ");
INSERT INTO rifl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Uca tadbirt teɛqeb-dd ɣares ɣar tmeddit, u xzar, aqa afar n zzitun deg uqemmum nnes. Xenni ifhem Nuḥ belli aman neqṣen zi temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Iraja ɛad sebɛa n wussan, xenni issekk tadbirt ɛawed uca nettat war ɣares dd-teɛqib ɛad. ");
INSERT INTO rifl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Deg useggʷas wiss setta-mya u-waḥit n Nuḥ, deg uyur amezwaru, deg wass amezwaru n uyur nni, uẓɣen waman x temmurt. Iksi Nuḥ tawwart n useqqaf n uɣarrabu, ixzar ɣar barra, uca xzar, udem n temmurt aqa yuẓeɣ. ");
INSERT INTO rifl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Deg uyur wiss tnayen, deg wass wiss sebɛa u-ɛicrin n uyur nni, tuẓeɣ temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Xenni issiweř AREBBI ak-d Nuḥ, inna: ");
INSERT INTO rifl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ffeɣ zeg uɣarrabu, cek d temɣart nnec d iḥenjiren nnec d temɣarin n iḥenjiren nnec akidek. ");
INSERT INTO rifl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Marra min iddaren i iǧan akidek, zi marra min ɣarsen arrimet n weysum, zeg ijḍaḍ, zi řmař u zi marra imuddaren nni ittbuɛen x temmurt, ejj i-ten ad ffɣen akidek, ejj i-ten ad mṭarracen x temmurt, ad arren řɣiǧet uca ad mmarenyen x temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Iffeɣ Nuḥ d iḥenjiren nnes d temɣart nnes d temɣarin n iḥenjiren nnes akides. ");
INSERT INTO rifl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Marra řmař n řexřa, marra min ittbuɛen, d marra ijḍaḍ, d marra min ittenhezzan x temmurt ffɣen zeg uɣarrabu ɛlaḥṣab řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ibna Nuḥ ijj n uɛalṭar i SIDI uca iksi zi marra řmař n řeḥřař u zi marra ijḍaḍ n řeḥřař uca iqeddem tiɣarṣa n wecmaḍ x uɛalṭar.    ");
INSERT INTO rifl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Uca icemm SIDI řefwaḥet ittfuḥen uca inna SIDI deg wuř nnes: “War ttɛiqqibeɣ ɛad ad neɛřeɣ tammurt x ssibbet n bnadem, minzi min dd-itteffɣen zeg wuř n bnadem d aɛeffan waha zi temẓi nnes. War ttɛiqqibeɣ ɛad ad wteɣ marra min iddaren am mammec ggiɣ. ");
INSERT INTO rifl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Marra ussan i ɣa teqqim temmurt teǧa, ad tiři tyarza d tmeyra, teṣmeḍ d řeḥmu, anebdu d řmecta uca ass d ǧiřet war ttbeddin ɛemmarṣ.”    ");
INSERT INTO rifl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Xenni ibarek AREBBI Nuḥ d iḥenjiren nnes uca inna asen: “Jjem-dd řɣiǧet, marenyem u ɛemmarem tammurt! ");
INSERT INTO rifl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tiggʷudi d řɛurret zi kenniw ad iřint x marra řmař n řexřa, x marra ijḍaḍ n ujenna u x marra min ittbuɛen x temmurt u x marra iseřman di řebḥar: aqa mmewcen deg ufus nwem. ");
INSERT INTO rifl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Marra min ittbuɛen, min iddaren, ad awem yiři d macca. Necc ad awem t wceɣ marra, am d awem wciɣ afsu aziza, ");
INSERT INTO rifl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","maca aysum ak-d buḥbeř nnes i iǧan d idammen nnes, war ten ttᵉttem. ");
INSERT INTO rifl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","D tidett ad ttareɣ idammen nwem n řeɛmur nwem, ad ten ttareɣ zeg ifassen n marra imuddaren, uřa zeg ifassen n bnadem, u zeg ifassen n umas n kuř ijjen ad ttareɣ řeɛmar n bnadem. ");
INSERT INTO rifl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wi ɣa issizzřen idammen n bnadem, idammen nnes ad ten ssizzřen s ufus n bnadem, minzi AREBBI igga bnadem di ṣṣifet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","U kenniw, jjem-dd řɣiǧet, dewřem deg waṭṭas, mṭarrcem di temmurt uca dewřem deg waṭṭas xas.” ");
INSERT INTO rifl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Uca issiweř AREBBI ak-d Nuḥ d iḥenjiren nnes nni ɣares, inna: ");
INSERT INTO rifl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Necc, xzar, Necc tteggeɣ Řɛahd inu akidwem u ak-d zzariɛet nwem awarni awem, ");
INSERT INTO rifl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","u ak-d marra buḥbeř iddaren nni iǧan akidwem, ak-d ijḍaḍ, ak-d řmař u ak-d marra řmař n řexřa x temmurt inni akidwem, wah, ak-d marra min dd-iffɣen zeg uɣarrabu ař marra min iddaren x temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ad ggeɣ Řɛahd inu akidwem, aqa marra imeddaren s arrimet n weysum war ttwakessin ɛad s waman n sseḥřet, u war din tᵉttiři ɛad sseḥřet i ɣa yareddǧen tammurt.” ");
INSERT INTO rifl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Xenni inna AREBBI: “D ta ad tiři d řeɛřamet n Řɛahd tenni i ɣa ggeɣ jar ayi d kenniw d marra řeɛmar iddaren akidwem, i marra jjiřat i řebda: ");
INSERT INTO rifl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ad ggeɣ řqews inu deg iseynuten wenni i ɣa yiřin d řeɛřamet n Řɛahd jar ayi d temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Xmi ɣa bḍiɣ iseynuten x temmurt, xenni ad imsar belli řqews-a ad dd-iḍhar deg iseynuten. ");
INSERT INTO rifl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Xenni ad idareɣ Řɛahd inu jar ayi d kenniw d marra řeɛmar iddaren n marra imeddaren s arrimet n weysum. War dd-ddikkʷiřen waman d sseḥřet ɛawed, maḥend ad ssɣarqen marra imeddaren s arrimet n weysum. ");
INSERT INTO rifl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ad dd-iḍhar řqews deg iseynuten, uca Necc ad t ẓareɣ ḥima ad idareɣ Řɛahd i řebda jar AREBBI d marra řeɛmar iddaren di marra imeddaren s arrimet n weysum i iǧan x temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Uca inna AREBBI i Nuḥ: “D ta d řeɛřamet n Řɛahd inu wenni i ɣa ggeɣ jar ayi d marra imeddaren s arrimet n weysum i iǧan x temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Tarwa n Nuḥ inni dd-iffɣen zeg uɣarrabu tuɣa aten d Cam d Ḥam d Yafat. Ḥam tuɣa d babas n Kenɛan.    ");
INSERT INTO rifl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ina d třata n iḥenjiren n Nuḥ. Zzaysen ttwabezzɛen iwdan di marra tammurt. ");
INSERT INTO rifl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ibda Nuḥ ixeddem am ufeǧaḥ, iẓẓu tizayarin deg umarjeɛ n uḍiř. ");
INSERT INTO rifl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Umi iswa binu, iscar uca iɛarra ixef nnes di řwesṭ n uqiḍun nnes. ");
INSERT INTO rifl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Iẓra Ḥam, babas n Kenɛan, tuɛɛaryent n babas uca inna t i tnayen n aytmas di barra. ");
INSERT INTO rifl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ksin Cam d Yafat ca n werruḍ, ssarsen t x tɣarḍin n tnayen idsen nsen uca uyuren ɣar ḍeffar, dřin tuɛɛaryent n babatsen. Arrin aɣembub nsen ɣar ḍeffar, war ẓrin ca tuɛɛaryent n babatsen. ");
INSERT INTO rifl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ifaq-dd Nuḥ zi ssekra nnes uca idweř yargeb x min d as igga mmis amaẓuẓ. ");
INSERT INTO rifl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Inna: “D amenɛuř i yeǧa Kenɛan! Ad yiři d amsexxar qaɛ n imsexxaren i aytmas!” ");
INSERT INTO rifl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Uca inna: “Ad ittwabarek SIDI, AREBBI n Cam. Kenɛan ad yiři d amsexxar i nitni. ");
INSERT INTO rifl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Zeɛma ad iwesseɛ AREBBI tazeddiɣt i Yafat, ad izdeɣ deg iqiḍan n Cam, u Kenɛan ad asen yiři d amsexxar.” ");
INSERT INTO rifl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Awarni sseḥřet iddar Nuḥ ɛad teřt-mya u-xemsin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ammu i iddar Nuḥ tesɛa-mya u-xemsin n iseggʷusa, xenni immut. Ina d imezruyen n yinni dd-ittwaxeřqen zeg ayt n Nuḥ: Cam, Ḥam d Yafat. ");
INSERT INTO rifl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ttwarwen asen-dd iḥenjiren awarni i sseḥřet.   * ");
INSERT INTO rifl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ayt n Yafat tuɣa aten d Jumar, Majuj, Maday, Yawan, Tubal, Macik d Tiras.    ");
INSERT INTO rifl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Iḥenjiren n Jumar, tuɣa aten d Ackanaz, Rifat d Tujarma. ");
INSERT INTO rifl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Iḥenjiren n Yawan tuɣa aten d Ilica, Tarcic d Ikittiyyen d Idudaniyyen. ");
INSERT INTO rifl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Zzaysen i ttwabḍant tegzirin n řegnus di temmura nsen, kuř ijjen ɛlaḥsab iřes nnes uca marra ɛlaḥsab řaǧ nsen u di řegnus nsen. ");
INSERT INTO rifl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ayt n Ḥam tuɣa aten d Kuc, Miṣrayim, Fuṭ d Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Iḥenjiren n Kuc tuɣa aten d Seba, Ḥawila, Sabta, Raɛama d Sabtaka. Iḥenjiren n Raɛama tuɣa aten d Caba d Dadan. ");
INSERT INTO rifl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuc ijja-dd Nimrud. Wanita ibda ad yiři d jjiheř di temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wa tuɣa d anegmar d ameqqran zzat i wudem n SIDI. X uya qqaren: ‘Anegmar ameqqran am Nimrud zzat i wudem n SIDI.’ ");
INSERT INTO rifl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Amezwar n tgeldit nnes tuɣa atent d tineddam n Babil d Irix d Akkad d Kalna di temmurt n Cinɛar. ");
INSERT INTO rifl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Zi temmurt nni dd-iffeɣ ɣar Accur uca ibna din Ninwa, Riḥubut-Ɛir d Kalaḥ ");
INSERT INTO rifl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","d Risin jar Ninwa d Kalaḥ, nettat d tandint tameqqrant. ");
INSERT INTO rifl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Miṣrayim ijja-dd Iludiyyen, Iɛanamiyyen, Ilahabiyyen, Inaftuḥiyyen, ");
INSERT INTO rifl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Ifatrusiyyen, Ikasluḥiyyen, inni zi dd-iqqarṣen Ifilisṭiniyyen, uřa d Ikafturiyyen. ");
INSERT INTO rifl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenɛan ijja-dd Ṣidun, amenzu nnes, d Ḥit ");
INSERT INTO rifl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","d Uyabusi d Umuri d Ujirjaci ");
INSERT INTO rifl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","d Uḥiwi d Uɛarqi d Usini ");
INSERT INTO rifl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","d Urwadi d Uṣamari d Uḥamati. Awarni as mbezzɛent marra řaǧat n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tuɣa aymir n ayt n Kenɛan zi Ṣidun ɣar Xirar ař Ɣazza u ssenni ɣar Sadum d Ɛamurra d Adma d Ṣabuyim ař Lacaɛ. ");
INSERT INTO rifl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ina d ayt n Ḥam ɛlaḥsab řaǧat nsen, ɛlaḥsab iřsawen nsen, di timmura nsen u ak-d řegnus nsen. ");
INSERT INTO rifl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","I Cam, wenni d jedd n marra ayt n Ɛabir, umas n Yafat, ameqqran, ttwarwen as-dd ɛawed iḥenjiren. ");
INSERT INTO rifl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Iḥenjiren n Cam tuɣa aten d Ɛilam, Accur, Arfakcad, Lud d Aram. ");
INSERT INTO rifl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Iḥenjiren n Aram tuɣa aten d Ɛuṣ d Ḥul d Jatir d Mac. ");
INSERT INTO rifl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfakcad ijja-dd Calaḥ u Calaḥ ijja-dd Ɛabir. ");
INSERT INTO rifl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ttwarwen-dd i Ɛabir tnayen n iḥenjiren. Ijjen qqaren as Falaj, minzi deg wussan nnes tᵉttwafeǧeq temmurt, u qqaren as i umas Yuqṭan. ");
INSERT INTO rifl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yuqṭan ijja-dd Almudad, Calaf, Haḍarmawt, Yaraḥ, ");
INSERT INTO rifl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Haduram, Uzal, Diqla, ");
INSERT INTO rifl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ɛubal, Abimayil, Caba, ");
INSERT INTO rifl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ufir, Ḥawila d Yubab. Marra ina tuɣa aten d iḥenjiren n Yuqṭan. ");
INSERT INTO rifl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tammurt mani tuɣa zeddɣen tuɣa-tt zi Mica ař Safar, adrar n ccarq. ");
INSERT INTO rifl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ina d ayt n Cam ɛlaḥsab řaǧat nsen u ɛlaḥsab iřsawen nsen, di temmura nsen u ak-d řegnus nsen. ");
INSERT INTO rifl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Tina d řaǧat n iḥenjiren n Nuḥ, ɛlaḥsab mammec dd-xeřqen, ak-d řegnus nsen. Zzaysen i zi ttwabḍan řegnus di temmurt awarni i sseḥřet. * ");
INSERT INTO rifl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tuɣa marra tammurt s yiřes d ijjen u s řhard d ijjen. ");
INSERT INTO rifl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Imsar řami fesyen iqiḍan nsen uca ffɣen-dd zi ccarq, ufin ijj n řewḍa di temmurt n Cinɛar, uca qqimen zeddɣen dinni. ");
INSERT INTO rifl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nitni nnan, kuř ijj i wenneɣni: “Araḥem-dd, ad negg iẓra zi třaxt, ad ten nesseḥma!” Ammu i d asen tedweř třaxt d aẓru u acarmuḍ idweř ɣarsen d tarrist. ");
INSERT INTO rifl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Xas uca nnan: “Zid, ad nebna ict n tendint d ict n ṣṣumɛet, taqiccat nnes ad dd-taweḍ ɣar ujenna, u jjem aneɣ ad negg ijj n yisem i neccin, ḥima war nᵉttemsebḍi ca x wudem n marra tammurt.” ");
INSERT INTO rifl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Xenni ihwa-dd SIDI, ḥima ad iẓar tandint d ṣṣumɛet nni bnan tarwa n bnadem. ");
INSERT INTO rifl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Inna SIDI: “Xzar, aqa aten d řgens d ijjen u marra ina ɣarsen ijj n yiřes. Wa d beddu n min ɣa ggen. Řexxu war din min ten i ɣa issbedden x webrid nsen nni nwan ad ggen. ");
INSERT INTO rifl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Araḥem-dd, ad nehwa uca ad nessxarweḍ iřes nsen, ḥima kuř ijjen war ifehhem ɛad iřes n wenni t yudsen.” ");
INSERT INTO rifl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ammu i ten izzuzar SIDI ssenni x wudem n marra tammurt uca ssbedden řebni n tendint. ");
INSERT INTO rifl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","X uya i d as řaɣan i tendint nni s yisem n ‘Babil’, minzi din issxarweḍ SIDI iřes n marra tammurt u ssenni i ten izzuzar SIDI x wudem n marra tammurt. Ina d imezruyen n yinni dd-ittwaxeřqen zi Cam. ");
INSERT INTO rifl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Umi tuɣa ɣar Cam mya n iseggʷusa, ijja-dd Arfakcad, tnayen n iseggʷusa awarni i sseḥřet.    ");
INSERT INTO rifl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Awarni řami dd-ijja Arfakcad, iddar Cam ɛad xemsa-mya n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Iddar Arfakcad xemsa u-třatin n iseggʷusa, xenni ijja-dd Calaḥ. ");
INSERT INTO rifl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Awarni řami dd-ijja Arfakcad Calaḥ, iddar ɛad arebɛa-mya u-třata n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Iddar Calaḥ třatin n iseggʷusa, xenni ijja-dd Ɛabir. ");
INSERT INTO rifl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Awarni řami dd-ijja Calaḥ Ɛabir, iddar ɛad arebɛa-mya u-třata n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Iddar Ɛabir arebɛa u-třatin n iseggʷusa, xenni ijja-dd Falaj. ");
INSERT INTO rifl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Awarni řami dd-ijja Falaj, iddar Ɛabir ɛad arebɛa-mya u-třatin n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Iddar Falaj třatin n iseggʷusa, xenni ijja-dd Raɛuw.    ");
INSERT INTO rifl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Awarni řami dd-ijja Raɛuw, iddar Falaj ɛad mitayen u-tesɛa n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Iddar Raɛuw tnayen u-třatin n iseggʷusa, xenni ijja-dd Saruj. ");
INSERT INTO rifl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Awarni řami dd-ijja Saruj, iddar Raɛuw ɛad mitayen u-sebɛa n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Iddar Saruj třatin n iseggʷusa, xenni ijja-dd Naḥur. ");
INSERT INTO rifl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Awarni řami dd-ijja Naḥur, iddar Saruj ɛad mitayen n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Iddar Naḥur tesɛa u-ɛicrin n iseggʷusa, xenni ijja-dd Taraḥ. ");
INSERT INTO rifl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Awarni řami dd-ijja Naḥur Taraḥ, iddar ɛad mya u-tesɛaṭac n iseggʷusa, uca ijja-dd iḥenjiren d tḥenjirin. ");
INSERT INTO rifl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Iddar Taraḥ sebɛin n iseggʷusa, xenni ijja-dd Abram, Naḥur d Haran. Ina d imezruyen n yinni dd-ittwaxeřqen zi Taraḥ. ");
INSERT INTO rifl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taraḥ ijja-dd Abram, Naḥur d Haran, u Haran ijja-dd Luṭ. ");
INSERT INTO rifl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Immut Haran zzat i babas Taraḥ di temmurt mani dd-ixřeq netta, di Ur n Ikaldaniyyen. ");
INSERT INTO rifl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Uca ksin Abram d Naḥur i yixef nsen timɣarin. Isem n temɣart n Abram tuɣa-t d Saray u isem n temɣart n Naḥur d Milka, yeǧis n Haran, babas n Milka d Yiska. ");
INSERT INTO rifl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray tuɣa-tt war dd-tᵉttiruw, tuɣa war ɣares bu uḥenjir. ");
INSERT INTO rifl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Uca iksi Taraḥ Abram, mmis, d Luṭ mmis n Haran, mmis n mmis, d Saray, tasřit nnes, tamɣart n mmis Abram, uca nitni ffɣen jmiɛ zi Ur n Ikaldaniyyen, ḥima ad raḥen ɣar temmurt n Kenɛan. Iwḍen ɣar Ḥaran uca zeddɣen dinni.    ");
INSERT INTO rifl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Umi tegga Taraḥ mitayen u-xemsa n iseggʷusa, immut Taraḥ di Ḥaran. ");
INSERT INTO rifl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Inna SIDI i Abram: “Ffeɣ zi temmurt nnec, zi temmurt mani dd-txeřqed u zi taddart n babac, ruḥ ɣar temmurt i d ac ɣa ssecneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ad zzayek dd-ssuffɣeɣ ijj n řgens imɣar, ad cek barkeɣ u ad ssemɣareɣ isem nnec uca iři d cek ɛawed d lbaraka. ");
INSERT INTO rifl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ad barkeɣ wenni cek i ɣa ibarken d wenni cek i ɣa ineɛřen, ad t neɛřeɣ. Dayek i ɣa ttwabarkent marra řaǧat n temmurt.”   * ");
INSERT INTO rifl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Uca iruḥ Abram am mammec d as inna SIDI, uca iruḥ Lut akides. Tuɣa Abram ɣares xemsa u-sebɛin n iseggʷusa umi dd-iffeɣ zi Ḥaran. ");
INSERT INTO rifl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Uca indeh Abram Saray tamɣart nnes, d Luṭ mmis n umas, d marra agřa i yarebḥen, d iwdan d řmař nni dd-kesben di Ḥaran. Ffɣen zi Ḥaran ḥima ad raḥen ɣar temmurt n Kenɛan uca iwḍen ɣar temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Iẓwa Abram zi temmurt nni ɣar wemcan n Cakim ař tacejjart n yigg n Mura. Di řweqt nni tuɣa ayt n Kenɛan zeddɣen di temmurt.    ");
INSERT INTO rifl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Iban-dd SIDI i Abram, inna as: “I zzariɛet nnec umi i ɣa wceɣ tammurt-a.” Uca ibna din ijj n uɛalṭar min xef issars taɣarṣt i SIDI, wenni d as dd-ibanen.    ");
INSERT INTO rifl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Xenni iɛdu ssenni ɣar idurar i iǧan x ccarq n Bayt-Il uca iwta dinni iqiḍan nnes, ijja Bayt-Il x jjihet n řɣarb u Ɛay x ccarq. Din ibna ijj n uɛalṭar i SIDI uca iřaɣa Isem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Awarni man aya ifsi Abram iqiḍan nnes, immuṭṭi zeg wemcan ɣar wemcan, ɣar Temmurt n Ljanub. ");
INSERT INTO rifl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Idweř řaẓ di temmurt uca ikemmeř Abram x webrid nnes, ihwa ɣar Miṣra, ḥima ad izdeɣ din am ubarrani, minzi tuɣa řaẓ imɣar di temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Řami dd-tiweḍ řweqt nni umi i ɣa yudef ɣar Miṣra, inna i Saray, tamɣart nnes: “Xzar, aqa ssneɣ belli cem d tamɣart dayes aẓri. ");
INSERT INTO rifl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Xmi cem i ɣa ẓaren Imiṣriyyen, zemmaren ad inin: ‘Ta d tamɣart nnes!’, ad ayi nɣen uca ad cem jjen di tudart. ");
INSERT INTO rifl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ini, aqa cem d učma, ḥima ad ayi yiři řxir di ṭṭweɛ nnem uca ad iqqim řeɛmar inu iddar i cem.” ");
INSERT INTO rifl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Imsar umi yudef Abram ɣar Miṣra, ẓrin Imiṣriyyen belli tamɣart teṣbeḥ aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Uřa d řḥukkam n firɛun, ajeǧid, ẓrin tt uca ssemɣaren tt ɣar Firɛun uca iwyen tt ɣar taddart n firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Uca imṣuref Firɛun mlih ak-d Abram di ṭṭweɛ nnes. Ammu i iksi uǧi d ifunasen d tfunasin d yeɣyař d isemɣan d tiyya d teɣyař d iřeɣman. ");
INSERT INTO rifl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Maca SIDI iwta firɛun d aytbab n taddart nnes s jjrayeḥ mɣarent di řesbab n Saray, tamɣart n Abram. ");
INSERT INTO rifl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Xenni firɛun iřaɣa-dd i Abram, inna as: “Manawaya i dayi teggid? Maɣar war d ayi tennid belli nettat d tamɣart nnec? ");
INSERT INTO rifl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mayemmi tennid: ‘Nettat d učma!’, ařami tt ggiɣ necc d tamɣart i yixef inu? Řexxu xzar, aqa ac tamɣart nnec, ksi tt, tbeɛɛded!” ");
INSERT INTO rifl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Yumur firɛun iryazen nnes xas uca ssqebbḍen t ak-d temɣart nnes u ak-d marra min tuɣa ɣares. ");
INSERT INTO rifl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ammu i yuyur Abram zi Miṣra ɣar Temmurt n Ljanub n Kenɛan, netta d temɣart nnes, ak-d marra min ɣares, d Luṭ akides. ");
INSERT INTO rifl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram tuɣa ɣares aṭṭas n wagřa d řebhayem d nnuqart d wureɣ. ");
INSERT INTO rifl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Uca immuṭṭi zeg wemcan ɣar wemcan zi Temmurt n Ljanub ɣar Bayt-Il ař amcan mani tuɣa iǧa uqiḍun nnes qbeř, jar Bayt-Il d Ɛay, ");
INSERT INTO rifl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ař amcan n uɛalṭar i tuɣa igga qbeř, min xef issars tiɣarṣa d tewhibin, uca dinni iřaɣa Abram Isem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Uca Luṭ, wenni yuyuren ak-d Abram, tuɣa ɣares ɛawed uǧi d ifunasen d tfunasin d iqiḍan. ");
INSERT INTO rifl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tammurt war d asen tiriw ḥima ad qqimen zeddɣen jmiɛ, minzi agřa nsen imɣar aṭṭas ař war zemmaren ad din zedɣen jmiɛ. ");
INSERT INTO rifl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Uca imsar umcubbec jar imeksawen n řebhayem n Abram d imeksawen n řebhayem n Luṭ. Tuɣa ayt n Kenɛan d Ifiriziyyen zeddɣen řexdenni di temmurt.    ");
INSERT INTO rifl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Inna Abram i Luṭ: “War ittiři ɛad umcubbec jar ayi d cek, jar imeksawen inu d imeksawen nnec, minzi neccin d iryazen awmaten. ");
INSERT INTO rifl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ma war tarzem temmurt zzatec? Ttzawgeɣ cek ad xafi tebḍiḍ, ma x uzeřmaḍ, niɣ x yefus! Mařa cek truḥed x yefus, necc ad raḥeɣ x uzeřmaḍ.” ");
INSERT INTO rifl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Issgeɛɛed Luṭ tamuɣři nnes uca iẓra adewwar n yeɣzar n L’Urdun tuɣa marra iswa. Qbeř areddeǧ zi SIDI tuɣa Sadum d Ɛamurra am jjennet n SIDI, am temmurt n Miṣra xmi dd ɣa tased ɣar Ṣuɣar. ");
INSERT INTO rifl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Uca ixḍar Luṭ i yixef nnes marra adewwar n yeɣzar n L’Urdun u ifsi Luṭ iqiḍan nnes uca yuyur ɣar ccarq. Ammu i mmsebḍan nitni ijjen x wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram izdeɣ di temmurt n Kenɛan, maca Luṭ izdeɣ di tneddam n udewwar n L’Urdun, iwta iqiḍan nnes ař Sadum. ");
INSERT INTO rifl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Iryazen n Sadum tuɣa aten d iɛeffanen d imednab ak-d SIDI ař ṭṭarf. ");
INSERT INTO rifl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Awarni řami xas immsebḍa Luṭ, inna SIDI i Abram: “Sarreḥ řexxu tiṭṭawin nnec, texzared zeg wemcan mani teǧid ɣar ccamal, ɣar ljanub, ɣar ccarq u ɣar řɣarb, ");
INSERT INTO rifl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","minzi marra tammurt i tᵉttwařid, ad ac tt wceɣ, i cek d zzariɛet nnec i řebda. ");
INSERT INTO rifl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ad ggeɣ zzariɛet nnec am tɛejjajt n temmurt, ḥima, mařa izemmar ḥed ad iḥseb taɛejjajt n temmurt, uřa d zzariɛet nnec tzemmar ɛawed ad tᵉttwaḥseb. ");
INSERT INTO rifl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kkar, cuq di temmurt di tuzzeggart nnes d tiru nnes, minzi i cek umi tt i ɣa wceɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Xenni ikkes Abram iqiḍan nnes uca yuyur ad izdeɣ ɣar tcejjura n yigg n Mamri, inni iǧan di Ḥabrun. Dinni ibna ijj n uɛalṭar i SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Deg wussan n Amrafil, ajeǧid n Cinɛar, d Ariyuc, ajeǧid n Illasar, d Kidurlaɛumer, ajeǧid n Ɛilam, d Tidal, ajeǧid n řegnus, imsar belli ");
INSERT INTO rifl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ina ggin řbaruḍ ak-d Bira, ajeǧid n Sadum u ak-d Bircaɛ, ajeǧid n Ɛamurra, u ak-d Cinab, ajeǧid n Adma, u ak-d Cim’ibar, ajeǧid n Ṣabuyim, u ak-d ujeǧid n Bilaɛ, wenni iǧan d Ṣuɣar. ");
INSERT INTO rifl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Marra ina munen di řewḍa n teɣzurt n Siddim, aqa d Řebḥar Ameǧaḥ. ");
INSERT INTO rifl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tuɣa xeddmen tenɛac n iseggʷusa i Kidurlaɛumir, maca ɣar useggʷas wiss třeṭṭac ɣewwɣen. ");
INSERT INTO rifl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Uca deg useggʷas wiss arbeɛṭac yusa-dd Kidurlaɛumir d ijeǧiden i yeǧan akides uca ɣeřben x Irafawiyyen di Actirut-Qarnaym, x Izuziyyen di Ham, x Imitiyyen di Cawa-Qaryatayim    ");
INSERT INTO rifl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","u x Ixuriyyen deg idurar nsen n Saɛir ař Faran, wenni iǧan zzat i řexřa. ");
INSERT INTO rifl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Awarni aya dewřen-dd, usin-dd ɣar Ɛayn-Micfat, wenni d Qadac, uca ɣeřben x yewdan nni izeddɣen di marra tammurt n ayt n Ɛamaliq u ɛawed x Imuriyyen inni izeddɣen di Haṣṣun-Tamar. ");
INSERT INTO rifl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Xenni iffeɣ ujeǧid n Sadum d ujeǧid n Ɛamurra d ujeǧid n Adma d ujeǧid n Ṣabuyim d ujeǧid n Bilaɛ, aqa-tt d Ṣuɣar. Ruḥen nitni ɣar řewḍa n teɣzurt n Siddim, maḥend ad mmenɣen ");
INSERT INTO rifl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ak-d Kidurlaɛumir, ajeǧid n Ɛilam d Tidɛal, ajeǧid n řegnus, d Amrafil, ajeǧid n Cinɛar, d Aryuk, ajeǧid n Illasar: arebɛa n ijeǧiden ggin řbaruḍ ak-d xemsa. ");
INSERT INTO rifl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tuɣa řewḍa n teɣzurt n Siddim teccur s wanuten n tizeft. Uca arewřen ijeǧiden n Sadum d Ɛamurra uca wḍan daysen, u inni iqqimen arewřen ɣar idurar. ");
INSERT INTO rifl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ksin marra agřa n Sadum d Ɛamurra d marra macca i xeznen uca uyuren. ");
INSERT INTO rifl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ksin ɛawed Luṭ, mmis n umas n Abram, d wagřa nnes uca ruḥen. Netta tuɣa izeddeɣ di Sadum. ");
INSERT INTO rifl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Xenni yusa-dd ijjen zeg inni yarewřen, inna man aya i Abram, Aɛibrani, wenni tuɣa izeddɣen ɣar tcejjura n yigg n Mamri, aryaz d Amuriy, umas n Ackul d Ɛanir. Nitni d arfiqen di řɛahd n Abram.    ");
INSERT INTO rifl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Řami isřa Abram belli umas ṭṭfen t d ameḥbus, yiwi iryazen inni idarrben i umenɣi, inni dd-ittwaxeřqen di taddart nnes, di teřt-mya u-tmenṭac, uca iḍfar i-ten ař Dan. ");
INSERT INTO rifl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","S ǧiret bḍan xasen nitni, ggin terfiqin, netta d imsexxaren nnes, uca iɣřeb xasen uca iḍfar i-ten ɣar tendint n Ḥuba, tenni iǧan x uzeřmaḍ n Dimacq. ");
INSERT INTO rifl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yarra-dd marra agřa uřa d umas Luṭ d wagřa nnes uřa d timɣarin d řgens. ");
INSERT INTO rifl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Umi dd-iɛqeb, awarni řami iɣřeb netta x Kidurlaɛumir u x ijeǧiden nni tuɣa akides, iffeɣ ujeǧid n Sadum ḥima ad t iřqa di Řewḍa n Teɣzurt n Cawa, tenni iǧan d Taɣzurt n Ujeǧid. ");
INSERT INTO rifl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","U Malkiṣadiq, ajeǧid n Calim, yiwi-dd aɣrum d binu. Netta tuɣa d akehhan n Arebbi, Amɛuǧi x kuřci.    ");
INSERT INTO rifl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ibark i-t, inna as: “Ad ittwabarek Abram zi Arebbi, Amɛuǧi x kuřci, wenni iggin ijenwan d temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ad ittwabarek Arebbi, Amɛuǧi x kuřci, wenni isellmen iɣrimen nnec deg ifassen nnec!” Uca Abram iwca as řeɛcur n marra. ");
INSERT INTO rifl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Uca inna ujeǧid n Sadum i Abram: “Ewc ayi marra min iddaren, maca ksi agřa i yixef nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Maca Abram yarra-dd x ujeǧid n Sadum: “Aqa ssgeɛɛdeɣ afus inu ɣar SIDI Arebbi, Amɛuǧi x kuřci, wenni iggin ajenna d temmurt, jjuǧeɣ ");
INSERT INTO rifl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","maḥend war kessiɣ afiřu niɣ taḥezzemt n sandaliyat uřa ca n řḥajjet zi marra min iǧan nnec, ḥima war teqqared: ‘Necc sstejjareɣ Abram!’ ");
INSERT INTO rifl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","War ɣari dayes bu tasɣart! Mɣir min ccin imsexxaren d tesɣart n iryazen nni kidi iruḥen, Anir d Ickul d Mamri, ejj i-ten ad ksin tasɣart nsen!” ");
INSERT INTO rifl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Awarni man aya yusa-dd wawař n SIDI ɣar Abram deg ijj n řewḥiy. Inna as “War tteggʷed ca, Abram, Necc d aseřqi i cek, řmunet nnec temɣar aṭṭas d Necc.” ");
INSERT INTO rifl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Uca inna Abram: “Sidi inu, SIDI, min d ayi ɣa tewced, maɣar necc ad raḥeɣ ammu břa mmi u Aliɛazir zi Dimacq ad yiři amecnaw mmi x wagřa n taddart inu?” ");
INSERT INTO rifl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Inna Abram ɛawed: “Xzar, war d ayi tewcid zzariɛet, s uyenni, wenni iǧan am mmi n taddart inu, ad yiři d awrit inu!” ");
INSERT INTO rifl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Uca xzar, awař n SIDI yusa-dd ɣares, inna: “War cek iwarret ca wa, maca wenni i ɣa iffɣen zzayek ad yiři d awrit nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Issuffeɣ i-t ɣar barra, inna: “Xzar ɣar ujenna, tḥesbed itran, mařa tzemmared ad ten tḥesbed!” Uca inna as: “Ammu i ɣa tiři zzariɛet nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Uca netta yumen di SIDI uca iḥseb as t-i-dd d tasegda.    ");
INSERT INTO rifl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Inna as ɛawed: “Necc d SIDI, wenni cek dd-yiwyen zi Ur n Ikaldaniyyen, ḥima ad ac wceɣ tammurt-a d řwart.” ");
INSERT INTO rifl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Xenni netta inna: “A Sidi inu, SIDI, s minzi i ɣa ssneɣ, belli ad tt warteɣ?” ");
INSERT INTO rifl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Inna as Netta: “Awi ayi-dd ict n tɛejmit n třata n iseggʷusa d ijj n iɣayḍ n třata iseggʷusa d ijj n icarri n třata iseggʷusa d ict n tejlilleḥt d ijj n wedbir d ameẓyan.” ");
INSERT INTO rifl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Netta yiwi-dd ɣares marra man aya, ibḍa ten x wezyen u igga kuř azyen qibač i wenneɣni, maca war ibḍi ca ijḍaḍ. ");
INSERT INTO rifl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Hwan-dd ijḍaḍ ittkeccaḍen x imurḍas, maca Abram yuẓẓeř xasen. ");
INSERT INTO rifl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ɣar uɣeǧay n tfuct, imsar aqa yusa as-dd i Abram ijj n yiḍeṣ yuǧeɣ, uca xzar, tiggʷudi d taǧest iḥedqen wḍan-dd xas. ");
INSERT INTO rifl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Xenni inna i Abram: “Ssen s tidett aqa zzariɛet nnec ad tiři d tabarranect deg ict n temmurt i war iǧin nnes uca ad asen xedmen am isemɣan u nitni ad xasen ggen aɣiř arebɛa-mya n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Maca řgens umi ɣa xedmen am isemɣan, ad xasen ḥekmeɣ ɛawed, uca awarni man aya ad ffɣen s wagřa imɣar. ");
INSERT INTO rifl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ad tᵉttwassmuned ɣar řejdud nnec s řehna uca ad cek neḍřen am umeccaybu iweqqar. ");
INSERT INTO rifl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Jjiř wiss arebɛa ad dd-iɛqeb danita, minzi řqedd n řmuɛṣiyyet n Imuriyyen ɛad war ikemmeř.” ");
INSERT INTO rifl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Řami teɣři tfuct uca tedweř d taǧest, tuɣa din afarran iddexxnen u iɛdu ijj n weṣfeḍ n tmessi jar izeynan nni. ");
INSERT INTO rifl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Deg wass nni nnit igga SIDI ijj n Řɛahd ak-d Abram, inna: “I zzariɛet nnec umi wciɣ tammurt-a zeg iɣzar n Miṣra ař iɣzar ameqqran, iɣzar n Lfuraṭ: ");
INSERT INTO rifl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","tammurt n Iqiniyyen, Iqeniziyyen, Iqadmiyyen, ");
INSERT INTO rifl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Iḥittiyyen, Ifirziyyen, Irafawiyyen, ");
INSERT INTO rifl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Imuriyyen, ayt n Kenɛan, Igirgaciyyen d Iyibusiyyen.” ");
INSERT INTO rifl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saray, tamɣart n Abram, war d as dd-tiruw ca. Tuɣa ɣares ict n tayya zi Miṣra qqarent as Hajar. ");
INSERT INTO rifl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tenna Saray i Abram: “Aqa teẓrid belli SIDI iṭṭef xafi tarwa. Adef x tayya inu, balak ad zzayes ksiɣ tarwa.” Abram tuɣa issḥessa ɣar Saray. ");
INSERT INTO rifl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Awarni řami izdeɣ Abram ɛecra n iseggʷusa di temmurt n Kenɛan, tiwi-dd Saray, tamɣart n Abram, tayya nnes Hajar, tenni zi Miṣra, uca tewca as-dd i Abram, aryaz nnes, d tamɣart nnes. ");
INSERT INTO rifl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Yudef x Hajar uca nettat teksi ddeyset. Umi teẓra belli teksi ddeyset, xenni tedweř lallas tᵉttwasseḥqar di tiṭṭawin nnes. ");
INSERT INTO rifl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tenna Saray i Abram: “Zi ssibbet nnec ggin dayi řmunkar. Necc ggiɣ tayya inu deg weḥsin nnec. Umi teẓra belli teksi ddeyset, dewřeɣ d tameḥguret di tiṭṭawin nnes. Ejj ad iḥkem SIDI jar ayi d cek!” ");
INSERT INTO rifl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Inna Abram i Saray: “Xzar, tayya nnem deg ifassen nnem. Egg zzayes min tᵉttwařid cem mliḥ di tiṭṭawin nnem.” Uca Saray tqemmeɛ i-tt u xenni nettat tarweř zzayes. ");
INSERT INTO rifl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Uca lmalak n SIDI iřqa i-tt ɣar tařa n waman di řexřa, ɣar tařa deg webrid ittawyen ɣar Cur. ");
INSERT INTO rifl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Inna: “Hajar, tayya n Saray, manis dd-tusid u mani ɣa traḥed?” Nettat tenna: “Ttrakkwařeɣ zeg wudem n lalla Saray!” ");
INSERT INTO rifl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Xenni inna as lmalak n SIDI: “Dweř ɣar lallam, uḍar sadu ifassen nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Inna as ɛawed lmalak n SIDI: “Ad kettareɣ aṭṭas zzariɛet nnem, ař war izemmar ad tᵉttwaḥseb řami i ɣa tiři deg waṭṭas.” ");
INSERT INTO rifl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Inna as lmalak n SIDI ɛawed: “Aqa řexxu, teksid ddeyset uca ad tarwed aseymi. Ad as tegged Ismaɛil, minzi SIDI isřa am di řemḥayen nnem. ");
INSERT INTO rifl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Uca netta ad yiři d ijj n bnadem amecnaw asnus n řexřa. Afus nnes ad yiři x marra, u afus n marra ad yiři xas. Ad izdeɣ arendad n marra aytmas.” ");
INSERT INTO rifl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","U nettat třaɣa x Yisem n SIDI i ɣares-dd issiwřen, tenna: “Cek d Arebbi i ittwařan!”, minzi tenna: “Ma war da ẓriɣ wenni d ayi ittwařan?” ");
INSERT INTO rifl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","X uya semman anu nni: anu ‘Laḥay-Ru’i’. Xzar, aqa-t jar Qadac d Barad.    ");
INSERT INTO rifl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Uca turuw-dd Hajar i Abram aseymi. Igga as Abram isem n mmis nni i d as dd-turuw Hajar ‘Ismaɛil’. ");
INSERT INTO rifl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram tuɣa ɣares setta u-tmanyin n iseggʷusa, umi dd-turuw Hajar Ismaɛil i Abram. ");
INSERT INTO rifl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Řami tuɣa ɣares ɣar Abram tesɛa u-tesɛin n iseggʷusa, iban as-dd SIDI i Abram, inna as: “Necc d Arebbi Amzemmar x kuřci! Uyur zzat i wudem inu uca iři d bnadem ikemmřen!    ");
INSERT INTO rifl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Necc ad ggeɣ Řɛahd inu jar ayi d cek uca ad cek sskettareɣ s yijj n cckel imɣar.” ");
INSERT INTO rifl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Xenni iwḍa Abram x uɣembub nnes uca issiweř AREBBI akides, inna as: ");
INSERT INTO rifl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Xzar, Necc ad ggeɣ Řɛahd inu akidek uca cek ad tiřid d babatsen n waṭṭas n řegnus. ");
INSERT INTO rifl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","War ittiři isem nnec ɛad ‘Abram’ maca ‘Ibrahim’, minzi Necc ggiɣ cek d babatsen n waṭṭas n řegnus. ");
INSERT INTO rifl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Uca Necc ad cek arreɣ ad tegged řɣiǧet aṭṭas s waṭṭas u ad cek arreɣ d řegnus, uca ijeǧiden ad zzayek dd-ffɣen. ");
INSERT INTO rifl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ad ggeɣ Řɛahd inu jar ayi d cek d zzariɛet nnec awarni ac di marra jjiřat nsen, am yijj n Řɛahd i řebda, ḥima ad iřiɣ d AREBBI i cek u i zzariɛet nnec awarni ac. ");
INSERT INTO rifl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ad ac wceɣ, i cek u i zzariɛet nnec awarni ac, tammurt mani tzeddɣed am ubarrani, marra tammurt n Kenɛan d agřa i řebda. Necc ad iřiɣ d AREBBI i nitni.” ");
INSERT INTO rifl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Inna AREBBI ɛawed i Ibrahim: “Cek ad teḥḍid Řɛahd inu, cek d zzariɛet nnec awarni ac, di marra jjiřat nsen. ");
INSERT INTO rifl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","D wa d Řɛahd inu wenni i ɣa teḥḍam jar ayi-dd d kenniw d zzariɛet nnec awarni ac: ittxeṣṣa ad ixten zzaywem marra min iǧan d awtem. ");
INSERT INTO rifl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kenniw ad txetnem aysum n řeɛdařyet nwem uca man aya ad tiři d řeɛřamet n Řɛahd jar ayi-dd d kenniw. ");
INSERT INTO rifl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mmis n tmenya n wussan ad ixten jar awem, mkuř awtem di marra jjiřat nwem, am wenni dd-ixeřqen di taddart nnec am wenni ittwasɣen s nnuqart zi kuř abarrani u war iǧin zi zzariɛet nnec. ");
INSERT INTO rifl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Am wenni dd-ixeřqen di taddart nnec, am wenni tesɣid s nnuqart, ittxeṣṣa as ad ixten. Ammu i ɣa yiři Řɛahd inu deg weysum nwem d Řɛahd i řebda. ");
INSERT INTO rifl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Aryaz war ixtinen, wenni řeɛdařyet nnes war tt xtin, aryaz nni ittxeṣṣa ad t qessen zi řgens nnes, aqa yarẓa Řɛahd inu.” ");
INSERT INTO rifl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Inna AREBBI ɛawed i Ibrahim: “I Saray tamɣart nnec war d as třiɣid ɛad ‘Saray’, maca ‘Sara’ d wa i ɣa yiřin isem nnes. ");
INSERT INTO rifl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Minzi ad tt barkeɣ u zzayes ad ac wceɣ mmic. Wah, ad tt barkeɣ uca nettat ad tedweř d řegnus u ijeǧiden n řegnus ad zzayes dd-ffɣen!” ");
INSERT INTO rifl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Xenni iwḍa Ibrahim x uɣembub nnes uca iḍḥec, inna deg wuř nnes: “Aryaz n mya n iseggʷusa ma ad as dd-ittwaxřeq mmis? U Sara, tenni ɣar iǧa tesɛin n iseggʷusa, ma ɛad ad dd-taruw?” ");
INSERT INTO rifl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Inna Ibrahim i AREBBI: “Mři Ismaɛil iddar qibač i wudem nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Maca AREBBI inna: “Lla, ɛad Sara, tamɣart nnec, d tenni d ac dd ɣa yarwen aseymi, uca cek ad as třaɣid Isḥaq. Necc ad ggeɣ Řɛahd inu akides d Řɛahd i řebda, i zzariɛet nnes awarni as.   ");
INSERT INTO rifl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Zi jjihet n Ismaɛil, aqa seǧeɣ ac. Xzar, Necc barkeɣ t uca ad t arreɣ ittaruw řɣiǧet u ad t arreɣ d aṭṭas. Tenɛac n řḥukkam i dd ɣa yejj, ad t ggeɣ d ijj n řgens imɣar. ");
INSERT INTO rifl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Maca ad ggeɣ Řɛahd inu ak-d Isḥaq, wenni i d ac dd ɣa taruw Sara di řweqt-a, deg useggʷas i dd ɣa yasen.” ");
INSERT INTO rifl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Umi ikemmeř awař nnes akides, igeɛɛed AREBBI, iggʷej x Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Iksi Ibrahim mmis Ismaɛil d marra isemɣan i dd-ittwaxeřqen di taddart nnes d marra inni immesɣen s nnuqart, marra min iǧan d awtem jar aytbab n taddart n Ibrahim uca ixten řeɛdařyet nsen deg wass nni am mammec d as inna AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tuɣa ɣar Ibrahim tesɛa u-tesɛin n iseggʷusa umi ixten deg weysum n řeɛdařyet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Igga mmis Ismaɛil třeṭṭac n iseggʷusa, umi t xetnen deg weysum n řeɛdařyet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ixten Ibrahim d mmis Ismaɛil deg wass d ijjen. ");
INSERT INTO rifl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Xetnen akides marra iryazen n taddart nnes, inni dd-ittwaxeřqen di taddart nnes uřa d inni immesɣen s nnuqart zeg ubarrani. ");
INSERT INTO rifl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Uca iḍhar SIDI i Ibrahim ɣar tcejjura n yigg n Mamri umi tuɣa yareyyeḥ ɣar wadaf n uqiḍun nnes di ṭṭḥa n uziř. ");
INSERT INTO rifl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Issgeɛɛed tamuɣři nnes, iẓra, aqa din třata n yeryazen qibač nnes. Umi ten iẓra, ikkar ittazzeř ɣarsen zi wadaf n uqiḍun. Uca ibendeq s uɣembub nnes ɣar temmurt,    ");
INSERT INTO rifl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","inna: “A Sidi inu, mařa řexxu ufiɣ arḍa di tiṭṭawin nnec, ttzawageɣ cek, war ɛeddu x umsexxar nnec. ");
INSERT INTO rifl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ejj imsexxaren inu ad dd-awyen cwayt n waman uca sirdem iḍaren nwem uca zzřem cwayt sadu tcejjart-a. ");
INSERT INTO rifl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ad dd-awyeɣ ařeqquz n weɣrum ḥima ad ttwaneɛcen wuřawen nwem, xenni ad teɛdum. Aqa x uya i dd-tekkim zzat i umsexxar nwem!” Nitni nnan: “Egg am mammec tennid.” ");
INSERT INTO rifl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Iruḥ Ibrahim deɣya ɣar uqiḍun ɣar Sara, inna: “Deɣyat, ksi třata n řeqyas n waren azdad, eggw i-ten uca egg zzayes tifḍirin.” ");
INSERT INTO rifl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Xas uca yuzzeř Ibrahim ɣar ifunasen uca iṭṭef-dd ijj n umeẓyan n ufunas igma d lemliḥ, iwca i-t i ubřiɣ, uca wa iqeǧeq, ḥima ad t issewjed. ");
INSERT INTO rifl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Netta iksi ɛawed ddhen d uɣi d umeẓyan n ufunas nni issewjed, uca issars i-t zzatsen, u netta tuɣa ibedd qibač nsen sadu tcejjart, uca ccin. ");
INSERT INTO rifl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Xenni nnan as: “Mani teǧa Sara tamɣart nnec?” Yarra-dd xasen: “Aqa-tt din deg uqiḍun.” ");
INSERT INTO rifl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Uca Netta inna: “D tidett ad ɣarek dd-dewřeɣ ɣar řweqt n tudart u xzar, ad ɣares yiři uḥenjir ɣar Sara, tamɣart nnec.” U Sara tesřa ɣar wadaf n uqiḍun nni iǧan awarni as. ");
INSERT INTO rifl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibrahim d Sara tuɣa wsaren, uyuren deg wussan, uca Sara tuɣa tbedd as tubbart n temɣarin. ");
INSERT INTO rifl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Uca teḍḥec Sara deg wuř nnes, tenna: “Awarni tewsar inu, ma ad ɣari yiři řxir-a d lemliḥ qaɛ, am iǧa sidi inu uřa d netta iwsar?” ");
INSERT INTO rifl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Inna SIDI i Ibrahim: “Maɣar teḍḥec Sara, tenna: ‘Ma zemmareɣ ad arweɣ am wsareɣ řexxu?’ ");
INSERT INTO rifl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ma aqa din ca n řḥajjet x SIDI tewɛar? Ad ɣarek dd-ɛeqbeɣ di řweqt i negga, ɣar řweqt n tudart uca ad yiři ɣar Sara mmis!” ");
INSERT INTO rifl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara tenkar, tenna: “War ḍeḥceɣ ca!”, minzi tuɣa teggʷed. Netta inna as: “Lla, aqa cem tḍeḥced!” ");
INSERT INTO rifl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Xenni kkaren iryazen nni ssenni, sewḍen ɣar Sadum, uca iruḥ Ibrahim akidsen, issqebbeḍ i-ten. ");
INSERT INTO rifl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Uca inna SIDI: “Ma ad ffareɣ Necc x Ibrahim min i ɣa ggeɣ? ");
INSERT INTO rifl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ad yiři Ibrahim zeɛma d ijj n řgens imɣar ijhed, aqa ad dayes ttwabarken marra řegnus n ddunect. ");
INSERT INTO rifl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Minzi Necc qqneɣ ixef inu akides, ḥima ad isseřmed iḥenjiren nnes uřa d taddart nnes awarni as, maḥend ad ḥḍan abrid n SIDI, ad ggen tasegda d řḥeqq, ḥima SIDI ad dd-yawi i Ibrahim min tuɣa xas inna.” ");
INSERT INTO rifl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Xenni inna SIDI: “Tɣuyyit n Sadum d Ɛamurra temɣar aṭṭas u ddnub nsen deqřen. ");
INSERT INTO rifl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ad dd-hwiɣ, ad ẓareɣ ma ggin nican am tɣuyyit nsen i ɣari dd-yusin niɣ lla, ad ssneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Xenni dewřen iryazen ssenni uca ṭṭfen abrid ɣar Sadum. Maca Ibrahim tuɣa iqqim ɛad ibedd zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Uca iqarreb-dd Ibrahim, inna: “Ma s tidett ad taredǧed ɛawed amsegged ak-d uɛeffan? ");
INSERT INTO rifl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Aqa dinni balak xemsin n imseggaden daxeř i tendint. Ma s tidett ad ten taredǧed, u war tsemmḥed deg wemcan nni di ṭṭweɛ n xemsin n imseggaden i dayes iǧan? ");
INSERT INTO rifl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Iggʷej xak ad tegged aya, ad tenɣed amsegged ak-d uɛeffan, wah, iggʷej xak ad yiři umsegged meḥsub am uɛeffan. Aqa řqaḍi n ddunect ma war ittegg s řḥeqq?” ");
INSERT INTO rifl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Řexdenni inna as SIDI: “Mařa ufiɣ di Sadum xemsin n imseggaden daxeř i tendint, ad semḥeɣ i wemcan di ṭṭweɛ nsen.” ");
INSERT INTO rifl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibrahim yarra-dd, inna: “Xzar řexxu, bdiɣ zeɛɛmeɣ ad ssiwřeɣ ak-d Sidi inu, waxxa necc d cař d yiɣɣeḍ. ");
INSERT INTO rifl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ad taɣ neqṣen zi xemsin n imseggaden xemsa, ma ad taredǧed x xemsa nni marra tandint?” Inna: “War tt ttaredǧeɣ mařa ufiɣ din xemsa u-rebɛin.” ");
INSERT INTO rifl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Yarni deg wawař akides, inna as: “Ad taɣ ad yiři ad ittwaf din arebɛin!” Yarra-dd Netta: “War tt tteggeɣ ca di ṭṭweɛ n arebɛin nni.” ");
INSERT INTO rifl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Xas uca inna: “War ttxeyyiq řexxu Sidi inu, xmi ɣa ssiwřeɣ ɛawed. Ad taɣ ad yiři din třatin!” Yarra-dd: “War tt ttaredǧeɣ mařa ufiɣ din třatin.” ");
INSERT INTO rifl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Inna ɛawed: “Xzar řexxu, bdiɣ zeɛmeɣ ad ssiwřeɣ ak-d Sidi inu. Ad taɣ ad yiři din mɣir ɛicrin!” Yarra-dd: “War tt ttaredǧeɣ ca di ṭṭweɛ n ɛicrin nni.” ");
INSERT INTO rifl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Xenni inna: “War ttxeyyiq řexxu Sidi inu, xmi ɣa ssiwřeɣ ɛawed. Ad taɣ ad yiři din mɣir ɛecra!” Yarra-dd: “War tt ttaredǧeɣ di ṭṭweɛ n ɛecra nni.” ");
INSERT INTO rifl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Xenni iruḥ SIDI awarni řami ikemmeř awař nnes ak-d Ibrahim uca Ibrahim idweř-dd ɣar wemcan n tzeddiɣt nnes. ");
INSERT INTO rifl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Uca iwḍent xenni tnayen n lmalakat nni ɣar Sadum s ǧiřet. Tuɣa Luṭ iqqim ɣar tewwart n Sadum. Umi ten iẓra Luṭ, ikkar maḥend ad ten iřqa uca ibendeq s uɣembub nnes ɣar temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Inna: “Xzar, a isiditen inu, ttzawageɣ kenniw ad dd-tasem ɣar taddart n umsexxar nwem uca ad dayes tessensem, ad tessirdem iḍaren nwem. Xenni ad tfaqem zic, ad tkemmřem x webrid nwem.” Maca nitni nnan: “Lla, aqa deg wazzay ad neqqim ad nessens.” ");
INSERT INTO rifl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Maca netta ikellef xasen aṭṭas ařami akides ruḥen, udfen ɣar taddart nnes uca igga asen amensi, iggʷa aɣrum břa antun uca ccin. ");
INSERT INTO rifl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aqa qbeř i ɣa ṭṭṣen, qewwaren i taddart iryazen n tendint, iryazen n Sadum, zeg umeẓyan ař awessar, marra iwdan zi marra imucan iṭṭurfen n tendint. ");
INSERT INTO rifl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nitni řaɣan i Luṭ, nnan as: “Mani ǧan iryazen inni ɣarek dd-yusin ǧiret-a? Suffeɣ i-ten-dd, ḥima ad ten nessen.” ");
INSERT INTO rifl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Iffeɣ-dd ɣarsen Luṭ, ɣar tewwart, uca iqqen tawwart awarni as. ");
INSERT INTO rifl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Inna: “Ttzawgeɣ, a aytma inu, war tteggem qaɛ řɣar! ");
INSERT INTO rifl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Xzar, ɣari tnayen n yessi, tinni ɛad war issinen aryaz. Ejj ayi ad awem tent i-dd-ssuffɣeɣ barra uca ggem daysent min tᵉttwařam mliḥ di tiṭṭawin nwem. Mɣir i iryazen-a war daysen tteggem walu, aqa x uya dd-usin nitni swadday n tiři n tzeqqa inu ɣar tmensiwt.” ");
INSERT INTO rifl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nitni nnan: “Aggʷej diha!” Uca nnan ɛawed: “Aqa wanita yusa-dd da d abarrani uca ixs ad xaneɣ iḥkem am řqaḍi! Řexxu ad cek nḍarr ktar zzaysen.” Uca ggin aṭṭas n uɣiř x weryaz nni, x Luṭ, uca qarrben-dd ḥima ad arẓen tawwart. ");
INSERT INTO rifl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Maca iryazen nni sswiẓẓḍen afus nsen, ssidfen Luṭ ɣar taddart akidsen uca bellɛen tawwart. ");
INSERT INTO rifl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Nitni wtin iryazen nni tuɣa ibedden ɣar tewwart n taddart s tuddarɣeč, am umeẓyan am umeqqran, ařami ssihřen nitni ixef nsen di tarezzut x tewwart. ");
INSERT INTO rifl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Xenni nnan iryazen nni i Luṭ: “Wi ɣarek da ɛad? Ma aḍeggʷař niɣ iḥenjiren niɣ tḥenjirin, marra inni ɣarek di tendint, ejj i-ten ad ffɣen zeg wemcan-a. ");
INSERT INTO rifl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Aqa ad nareddeǧ amcan-a, minzi tɣuyyit nnes temɣar zzat i wudem n SIDI, u SIDI issekk aneɣ-dd, ḥima ad tt nareddeǧ.” ");
INSERT INTO rifl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Iffeɣ Luṭ uca issiweř ak-d iḍeggʷařen nnes, inni iggin ad meřcen yessis, inna: “Kkarem, ffɣem zeg wemcan-a, minzi SIDI ad yareddeǧ tandint-a.” Maca iban-dd ittqeṣṣar di tiṭṭawin n iḍeggʷařen nnes. ");
INSERT INTO rifl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Umi iṣbeḥ řhař, ssqeǧqent lmalakat Luṭ, nnant: “Kkar, teksid tamɣart nnec d tnayen n yessic, tinni akidek, ḥima war thelliked ca di řmuɛṣiyyet n tendint-a.” ");
INSERT INTO rifl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Maca netta war izɛim. Xenni ṭṭfen iryazen nni afus nnes d ufus n temɣart nnes d ifassen n tnayen n yessis, minzi SIDI tuɣa ixs ad xas iḥinn. Nitni ssuffɣen t ɣar barra, nedhen t barra i tendint. ");
INSERT INTO rifl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ařami ten ssuffɣen barra, inna Netta: “Senjem ixef nnec! War xezzar awarni ac, war ttbeddi di jjihet-a am tekmeř. Arweř ɣar idurar, ḥima war tᵉttwateḥḥid ca.” ");
INSERT INTO rifl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Inna asen Luṭ: “Lla, ttzawageɣ, a Sidi inu! ");
INSERT INTO rifl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Xzar, amsexxar nnec yufa arḍa di tiṭṭawin nnec, wah tessemɣared tamexsiwt nnec icewwaren, tenni kidi teggid umi d ayi tejjid ddareɣ. Maca war zemmareɣ ad arewřeɣ ɣar idurar qbeř d ayi ɣa iṭṭef řɣar uca ad mmteɣ! ");
INSERT INTO rifl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Xzar řexxu, tandint-a aqa tudes-dd aṭṭas, aqa zemmareɣ ad dinni arewřeɣ. Nettat d tameɛnanuct. Ejj ayi ad arewřeɣ řexxu dinni. Ma war teǧi d ict n tendint d tameɛnanuct? Xenni zemmareɣ ad qqimeɣ ddareɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yarra-dd xas: “Xzar, tiweḍ ayi-dd ɛawed tzawegt nnec x uya, war ttareddǧeɣ ca tandint min xef tessiwřed. ");
INSERT INTO rifl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Qeǧeq, arweř din, minzi war zemmareɣ ad ggeɣ walu ař dd ɣa tawḍed ɣar dinni.” X uya semman isem n tendint nni Ṣuɣar. ");
INSERT INTO rifl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ařami yiweḍ Luṭ ɣar Ṣuɣar, tenqar-dd tfuct x temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ijja SIDI ad iwwet wenẓar x Sadum u x Ɛamurra, d řecbareyyet d tmessi zeg ujenna zi ɣar SIDI.    ");
INSERT INTO rifl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yareddeǧ Netta tineddam nni d marra adewwar nni, ak-d marra imezdaɣ n tneddam nni uřa d aɣemmuy n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tamɣart nnes, tenni tuyur ɣar ḍeffar nnes, texzar awarni as uca tedweř d ijj n uqellij n tmeǧaḥt. ");
INSERT INTO rifl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ɣar ṣṣbeḥ zic ikkar Ibrahim, yuyur ɣar wemcan mani tuɣa ibedd zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Isweḍ ɣar Sadum d Ɛamurra u ɣar marra tammurt n udewwar nni, uca iẓra belli ddexxan ittgeɛɛad zi temmurt am ddexxan n ict n tefqunt. ");
INSERT INTO rifl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ařami yareddeǧ AREBBI tineddam n udewwar nni, ifekkar AREBBI di Ibrahim uca issekk Luṭ barra zi řwesṭ n uceřwaw, umi iqřeb tineddam i di izdeɣ Luṭ. ");
INSERT INTO rifl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Igeɛɛed Luṭ zi Ṣuɣar uca iruḥ izdeɣ ak-d tnayen n yessis deg idurar, minzi iggʷed ad iqqim izeddeɣ di Ṣuɣar. Uca izdeɣ deg ifri ak-d tnayen n yessis. ");
INSERT INTO rifl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tenna tmenzut i tmaẓuẓt: “Babatneɣ d awessar, war iqqim uɛezri di temmurt ad xaneɣ dd-yadef am mammec teggur di marra ddunect. ");
INSERT INTO rifl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Zid, ejj aneɣ ad newc binu i babatneɣ ad issu uca ad kis nezzeř, maḥend ad newc tudart i zzariɛet n babatneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Di ǧiřet nni wcint binu i babatsent, iswa. Xenni tudef tmenzut, tᵉṭṭeṣ ak-d babas, maca netta war yuci ca belli tezzeř akides niɣ tekkar ɛawed. ");
INSERT INTO rifl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tiwecca nnes tenna tmenzut i tmaẓuẓt: “Aqa necc zzřeɣ ǧiret iɛdun ak-d baba, ad as newc ad issu binu ɛawed ǧiret-a. Xenni ad tadfed cem ad kides tezzřed, maḥend ad dd-nejj jjiř ad iqqim iddar zi ẓẓariɛet n babatneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Wcint binu i babatsent ɛawed di ǧiret nni, iswa. Xenni tekkar tmaẓuẓt uca tᵉṭṭeṣ ak-d babas. Maca netta war yuci ca belli tezzeř akides niɣ tekkar ɛawed. ");
INSERT INTO rifl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ammu ksint tnayen n yessis n Luṭ s ddeyset zi babatsent. ");
INSERT INTO rifl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Uca turuw-dd tmenzut aseymi, třaɣa isem nnes Mu’ab. Wa d babatsent n ayt n Mu’ab ɣar ass-a. ");
INSERT INTO rifl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tamaẓuẓt ɛawed turuw-dd aseymi uca třaɣa isem nnes Ben-Ɛammi. Netta d babatsen n iḥenjiren n Ɛammun ɣar ass-a. ");
INSERT INTO rifl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ssenni issmuṭṭiy Ibrahim iqiḍan nnes, yuyur ɣar Temmurt n Ljanub. Izdeɣ netta jar Qadac d Cur uca iqqim am ubarrani di Jirar. ");
INSERT INTO rifl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Umi inna Ibrahim x Sara tamɣart nnes: “Nettat d učma i teǧa!”, issekk Abimalik, ajeǧid n Jirar, yiwi akis Sara.    ");
INSERT INTO rifl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Maca iḍhar-dd AREBBI i Abimalik di tarjit n ǧiret, inna as: “Aqa řexxu ad temmted di ssibbet n temɣart, tenni dd-tiwyed akidek, minzi nettat temřec ak-d weryaz.” ");
INSERT INTO rifl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Maca Abimalik tuɣa war ɣares dd-iqarreb, inna: “A Sidi inu, ma xenni ad tawḍed ad tenɣed ijj n řgens iseggden? ");
INSERT INTO rifl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ma war d ayi inni netta: ‘Nettat d učma i teǧa!’, u nettat s yixef nnes tenna ɛawed: ‘Netta d uma i yeǧa!’ S tidett n wuř u s ifassen izdigen i ggiɣ aya.” ");
INSERT INTO rifl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Inna as AREBBI di tarjit: “Necc ssneɣ ɛad belli teggid man aya s tidett n wuř, x uya ḥḍiɣ cek ḥima war xafi txeṭṭiḍ u war cek jjiɣ ad tt tḥadid. ");
INSERT INTO rifl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Řexxu, arr tamɣart ɣar weryaz nnes, minzi netta d anabi uca netta ad xak iẓẓaǧ, ḥima ad teddared. Maca mařa war tt tarrid ca, ssen belli aqa ad temmted, cek d marra min iǧan nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ikkar Abimalik zic ɣar ṣṣbeḥ. Iřaɣa i marra imsexxaren nnes, inna marra awařen-a deg imezzuɣen nsen uca iryazen nni dewřen ggʷeden aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Xenni iřaɣa Abimalik x Ibrahim uca inna as: “Min d aneɣ teggid d min di xḍiɣ akidek umi tɣeḍred xafi u x tgeldit inu ddenb ameqqran? Cek teggid akidi min war icuwwaren ad t tegged.” ");
INSERT INTO rifl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Uca yarni inna Abimalik i Ibrahim: “Min cek yejjin řami teggid man aya?” ");
INSERT INTO rifl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Inna Ibrahim: “Minzi nwiɣ: ‘Nican war dinni tiggʷudi zi AREBBI deg wemcan-a uca ad ayi nɣen di ssibbet n temɣart inu.’ ");
INSERT INTO rifl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Uca s tidett nettat ɛawed d učma. Nettat d yeǧis n baba, maca war teǧi d yeǧis n yemma uca tedweř d tamɣart inu. ");
INSERT INTO rifl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Umi d ayi issetleɛ AREBBI zi taddart n baba, nniɣ as: ‘Ad yiři wa d řeɛřamet n tmexsiwt nnec icewwaren i necc, aqa ad tinid di marra imucan mani ɣa naweḍ: Netta aqa d uma!’” ");
INSERT INTO rifl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Xenni iksi Abimaliki uǧi d ifunasen d tfunasin d isemɣan d tiyya uca iwca i-ten i Ibrahim uca yarr as Sara, tamɣart nnes. ");
INSERT INTO rifl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Inna Abimalik: “Xzar, tammurt inu aqa-tt qibač nnec. Zdeɣ mani i d ac dd-iḍhar mliḥ di tiṭṭawin nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","I Sara inna: “Xzar, wciɣ ařef n uqiyyat n nnuqart i umam. Aqa atent d ařeḥḥaf x tiṭṭawin i kuřci inni kidem iǧan, wah, i kuřci idweř am-dd d ttiqart.” ");
INSERT INTO rifl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Iẓẓuǧ Ibrahim i AREBBI uca AREBBI issgenfa Abimalik d temɣart nnes d temsexxarin nnes uca urwent. ");
INSERT INTO rifl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Minzi tuɣa SIDI ibelleɛ qaɛ marra řemřawat n temɣarin di taddart n Abimalik di ssibbet n Sara, tamɣart n Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Uca yarzef SIDI ɣar Sara, am mammec t inna, uca ikemmeř SIDI awař i inna i Sara. ");
INSERT INTO rifl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Teksi Sara s ddeyset uca turuw-dd ijj n useymi i Ibrahim x tewsar nnes, di řmijar nni i d as inna AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Uca iřaɣa Ibrahim i mmis aseymi, wenni d as dd-turuw Sara, Isḥaq. ");
INSERT INTO rifl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ibrahim ixten i mmis Isḥaq umi tuɣa ɣares tmenya n wussan, am mammec d as yumur AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Tuɣa ɣar Ibrahim mya n iseggʷusa, ařami ɣares dd-ixřeq mmis Isḥaq. ");
INSERT INTO rifl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tenna Sara: “Isseḍḥec ayi AREBBI u kuř ijj wenni i ɣa isřan i man aya, ad iḍḥec ɛawed akidi.” ");
INSERT INTO rifl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tenna ɛawed: “Man wen izeɛmen ad yini i Ibrahim, aqa Sara ad tessuṭṭeḍ iseyman? Aqa urweɣ as-dd aḥenjir x tewsar nnes!” ");
INSERT INTO rifl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Igma useymi uca ittwakkes as uṭṭuḍ. Deg wass i d as kksen uṭṭuḍ i Isḥaq, issewjed Ibrahim ict n zzardet temɣar. ");
INSERT INTO rifl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Umi teẓra Sara mmis n Tmiṣrect Hajar, wenni dd-turuw Hajar i Ibrahim, iqeṣṣar xas, ");
INSERT INTO rifl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","tenna i Ibrahim: “Aẓẓeř x tayya-ya d mmis, minzi mmis n tayya-ya war iwarret ca ak-d mmi, ak-d Isḥaq.” ");
INSERT INTO rifl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Awař-a iban-dd d aɛeffan aṭṭas di tiṭṭawin n Ibrahim di ssibbet n mmis. ");
INSERT INTO rifl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Maca inna AREBBI i Ibrahim: “War ttejji aḥenjir d tayya nnec ad iřin d tisineft di tiṭṭawin nnec. Seř ɣar marra min i d ac ɣa tini Sara, minzi di Isḥaq ad ac tiři zzariɛet.    ");
INSERT INTO rifl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ad ggeɣ ɛawed ijj n řgens zi mmis n tayya-ya, minzi uřa d netta d zzariɛet nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Xenni ikkar Ibrahim zic uca iksi aɣrum d ict n tecyart n waman, iwca i-ten i Hajar, issars as ten x teɣruḍt. Iwca as ɛawed aḥenjir uca issqebbeḍ i-tt. Uca nettat truḥ, tennejru di řexřa n Bi’r-Sebɛa. ");
INSERT INTO rifl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Řami neqṣen waman zi tecyart, tenḍar aḥenjir sadu ijj n cbarq, ");
INSERT INTO rifl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","uca truḥ teqqim qibač nnes řaggʷaj n tecti n řqews, minzi tenna: “War zemmareɣ ad ẓareɣ meřmi i ɣa immet uḥenjir.” Ammu i teqqim qibač nnes uca tessgeɛɛed tmijja nnes, tesɣuyyu. ");
INSERT INTO rifl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Isřa AREBBI ɣar tmijja n uḥenjir uca lmalak n AREBBI iřaɣa i Hajar zeg ujenna, inna as: “Min cem yuɣin, Hajar? War tteggʷed ca, minzi AREBBI isřa řḥess n uḥenjir, din mani iǧa. ");
INSERT INTO rifl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kkar, sgeɛɛed aḥenjir uca ṭṭef as deg ufus nnem, minzi ad zzayes ggeɣ ijj n řgens imɣar.” ");
INSERT INTO rifl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Uca yarzem AREBBI tiṭṭawin nnes, teẓra řɛunṣar n waman. Truḥ, tɛemmar tacyart s waman, tewca as i uḥenjir, ad isu. ");
INSERT INTO rifl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tuɣa AREBBI ak-d uḥenjir, iyma, izdeɣ di řexřa u tuɣa-t d amjebbad n řqews. ");
INSERT INTO rifl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tuɣa izeddeɣ di řexřa n Faran uca teksi as-dd yemmas tamɣart zi temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Di řweqt nni d ict imsar, belli Abimalik ak-d Fikul, akumandar n řɛeskar nnes, issiweř ak-d Ibrahim, inna: “AREBBI aqa-t akidek di marra min tᵉttegged. ");
INSERT INTO rifl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Řexxu, jaǧ ayi ɣar AREBBI, aqa war tᵉttɣeccid iḥenjiren inu uřa d ayyawen inu! Maca s muxas tamexsiwt icewwaren i kik ggiɣ qbeř, ad zzayes tegged cek akidi u ak-d temmurt mani teqqimed am ubarrani.” ");
INSERT INTO rifl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Inna Ibrahim: “Necc ad jjaǧeɣ!” ");
INSERT INTO rifl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Xas uca iɛeyyeb Ibrahim Abimalik x řɛunṣar n waman nni iṭṭfen zzayes imsexxaren n Abimalik s uɣiř. ");
INSERT INTO rifl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Xenni inna Abimalik: “Necc war ssineɣ wi iggin man aya u cek war d ayi t tennid ca qbeř. Aqa ař řexxu i zzayek t sřiɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Iksi Ibrahim uǧi d ifunasen d tfunasin uca iwca as ten i Abimalik uca nitni s tnayen idsen ggin ijj n řɛahd jar asen. ");
INSERT INTO rifl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Maca issars Ibrahim sebɛa n txeswin zeg wuǧi ɣar uɣezdis. ");
INSERT INTO rifl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Xenni inna Abimalik i Ibrahim: “Min ɛnant sebɛa n txeswin nni teggid ɣar uɣezdis?” ");
INSERT INTO rifl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Inna netta: “Ksi zeɛma sebɛa aya n txeswin zeg ifassen inu, ḥima ad iřint d cchadet di ṭṭweɛ inu belli necc i iɣzin anu-ya.” ");
INSERT INTO rifl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","X uya semman amcan nni Bi’r-Sebɛa, minzi nitni s tnayen idsen tuɣa jjuǧen din. ");
INSERT INTO rifl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ammu i ggin řɛahd di Bi’r-Sebɛa. Awarni man aya ikkar Abimalik ak-d Fikul, akumandar n řɛeskar nnes, iɛqeb ɣar temmurt n Ifilisṭiniyyen. ");
INSERT INTO rifl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iẓẓu Ibrahim ict n tcejjart n tmarist di Bi’r-Sebɛa uca iřaɣa din isem n SIDI, Arebbi n řebda.    ");
INSERT INTO rifl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Izdeɣ Ibrahim am ubarrani di temmurt n Ifilisṭiniyyen aṭṭas n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Awarni man aya temsar, aqa ijarreb AREBBI Ibrahim, inna as: “Ibrahim!” Uca inna as: “Xzar, necc aqa ayi da!” ");
INSERT INTO rifl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Inna as Netta: “Ksi ayenni n mmic, wenni texsed, Isḥaq, uca ruḥ ɣar temmurt n Muriya uca tqeddmed t din d taɣraṣt x yijj n wedrar jar idurar i d ac ɣa iniɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ikkar Ibrahim zic, iḥezzem i weɣyuř nnes uca iksi akides tnayen n imsexxaren nnes d mmis Isḥaq. Iqess akeccuḍ i tewhibt n tɣarṣt, ikkar, iruḥ deg webrid ɣar wemcan i d as inna AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Deg wass wiss třata issgeɛɛed Ibrahim tamuɣři nnes uca iẓra amcan zi řaggʷaj. ");
INSERT INTO rifl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Inna Ibrahim i imsexxaren nnes: “Rajam da ak-d weɣyuř, necc d uḥenjir ad nraḥ diha, ad nesjed. Awarni as ad ɣarwem dd-neɛqeb.” ");
INSERT INTO rifl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iksi Ibrahim akeccuḍ i wecmaḍ n tɣarṣt, issars i-t x mmis Isḥaq u netta s yixef nnes iksi s ufus nnes timessi d txedmect, uca ammu i ruḥen nitni s tnayen idsen. ");
INSERT INTO rifl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Xenni issiweř Isḥaq ak-d Ibrahim babas, inna: “Baba inu!” Inna netta: “Xzar, necc aqa ayi da, mmi!” Uca inna netta: “Xzar, aqa da timessi d ukeccuḍ, maca mani iǧa izmar i tɣarṣt?” ");
INSERT INTO rifl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Inna Ibrahim: “AREBBI Simant nnes ad issarzeq s yezmar i tɣarṣt, a mmi!” Uca ammu i ruḥen s tnayen idsen ");
INSERT INTO rifl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","uca iwḍen ɣar wemcan nni i d as inna AREBBI. Din i ibna Ibrahim ijj n uɛalṭar uca iɛdeř akeccuḍ, icarf mmis Isḥaq uca issars i-t x uɛalṭar x ikecwaḍ. ");
INSERT INTO rifl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Xas uca isswiẓẓeḍ Ibrahim afus nnes uca iksi-dd taxedmect, ḥima ad iɣarṣ i mmis. ");
INSERT INTO rifl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Maca lmalak n SIDI iřaɣa as-dd zeg ujenna, inna as: “Ibrahim, Ibrahim!” Netta inna: “Necc aqa ayi da!” ");
INSERT INTO rifl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Xenni inna as: “War swiẓẓiḍ afus nnec ɣar uḥenjir. war d ttegg ca, minzi řexxu aqa ssneɣ belli tᵉtteggʷeded AREBBI u war xafi tessɛizzed ayenni n mmic.” ");
INSERT INTO rifl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Issgeɛɛed Ibrahim tiṭṭawin nnes, u xzar, aqa awarni as tuɣa ijj n icarri iqqen ɣar cbarq zeg waccawen nnes. Yuyur Ibrahim dinni, iṭṭef icarri uca igga-i-t d taɣarṣt deg wemcan n mmis. ");
INSERT INTO rifl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iřaɣa Ibrahim isem n wemcan nni: “SIDI ad issarzeq!” S uyenni iqqar bnadem ař ass-a: “Deg wedrar n SIDI ad yiři yarzeq!” ");
INSERT INTO rifl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Iřaɣa-dd lmalak n SIDI wiss martayen zeg ujenna x Ibrahim, ");
INSERT INTO rifl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","inna: “Minzi teggid man aya uca war xafi tᵉṭṭifed ayenni n mmic, ad jjaǧeɣ x Simant inu, iqqar SIDI, ");
INSERT INTO rifl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","aqa ad cek barkeɣ aṭṭas uca ad kettareɣ zzariɛet nnec aṭṭas am yitran n ujenna u am yijdi x tma n řebḥar. Zzariɛet nnec ad tᵉṭṭef tawwart n řɛedyan nnes d řwart ");
INSERT INTO rifl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","u di zzariɛet nnec ad ttwabarken marra řegnus n temmurt, minzi tesřid i tmijja inu.” ");
INSERT INTO rifl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Xenni iɛqeb-dd Ibrahim ɣar imsexxaren nnes. Nitni kkaren uca ruḥen jmiɛ deg webrid ɣar Bi’r-Sebɛa, uca igga Ibrahim ad izdeɣ di Bi’r-Sebɛa. ");
INSERT INTO rifl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Awarni man aya imsar aqa xebbaren Ibrahim, nnan as: “Xzar, ɛawed Milka turuw-dd iḥenjiren i Naḥur umac: ");
INSERT INTO rifl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ɛuṣ, amenzu nnes, d Buz umas, d Qamuwil wenni d babas n Aram, ");
INSERT INTO rifl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","d Kasad d Ḥazu d Fildac d Yidlaf d Bituwil.” ");
INSERT INTO rifl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bituwil ijja-dd Rifqa. Tmenya aya i dd-turuw Milka i Naḥur, umas n Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","U tayya nnes, tenni umi qqaren Riɛuma, turuw as-dd ɛawed Ṭabaḥ d Jaḥam d Taḥac d Maɛka. ");
INSERT INTO rifl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Tuɣa ɣar Sara mya u-sebɛa u-ɛicrin n iseggʷusa. Man aya d řmijař n iseggʷusa n tudart n Sara. ");
INSERT INTO rifl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Uca temmut Sara di Qaryat-Arbaɛ, ixs ad yini Ḥabrun, di temmurt n Kenɛan. Uca yudef-dd Ibrahim ɣar uqiḍun, icḍen x Sara, isɣuy xas. ");
INSERT INTO rifl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Xas uca ikkar Ibrahim ṭṭarf i umettin nnes, uca issiweř ak-d tarwa n Ḥit, inna: ");
INSERT INTO rifl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Necc d abarrani d amɛezzeb ɣar awem. Wcem ayi mɣir anḍeř d agřa jar awem, ḥima ad neḍřeɣ amettin inu zi zzat inu.” ");
INSERT INTO rifl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Arrin-dd tarwa n Ḥit x Ibrahim, nnan as: ");
INSERT INTO rifl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Seř ɣarneɣ, a sidi inu! Cek d řḥakem n AREBBI jar aneɣ. Nḍeř amettin nnec deg wenḍeř nneɣ iṣebḥen. Uřa d ijj zzayneɣ ad cek iṭṭef x wenḍeř nnes, ḥima ad dayes tneḍřed amettin nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Xenni ikkar Ibrahim, ibendeq zzat i řgens n temmurt, zzat i tarwa n Ḥit ");
INSERT INTO rifl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","uca issiweř akidsen, inna: “Mařa kenniw s array nwem ad neḍřeɣ amettin inu zi zzat inu, sřem ɣari uca zawgem di ṭṭweɛ inu ɣar Ɛifrun, mmis n Zuhar, ");
INSERT INTO rifl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","maḥend ad ayi iwc ifri n Makfila, d wenni nnes, ɣar ṭṭarf n yeyyar nnes. Ejj i-t ad ayi t iwc s ttaman nnes ikmeř. Ad yiři d anḍeř inu i ɣa mellkeɣ jar awem.” ");
INSERT INTO rifl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ɛifrun tuɣa iqqim jar tarwa n Ḥit uca Ɛifrun, Aḥitti, yarra-dd x Ibrahim deg imejjan n tarwa n Ḥit d marra inni yudfen ɣar tewwart n tendint nnes, inna: ");
INSERT INTO rifl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Lla, a sidi inu, seř-dd ɣari! Necc ad ac wceɣ iyyar uřa d ifri nni dayes iǧan. Zzat i tiṭṭawin n tarwa n řgens inu ad ac t wceɣ, nḍeř amettin nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Xenni ibendeq Ibrahim s uɣembub nnes ɣar temmurt zzat i řgens n temmurt ");
INSERT INTO rifl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","uca issiweř ak-d Ɛifrun deg imezzuɣen n řgens n temmurt, inna: “Ttzawgeɣ, mařa texsed, seř-dd ɣari. Ad ac wceɣ nnuqart n yeyyar, qbeř i-tt zzayi, xenni ad dayes neḍřeɣ amettin inu.” ");
INSERT INTO rifl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Yarra-dd Ɛifrun x Ibrahim, inna as: ");
INSERT INTO rifl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sidi inu, seř-dd ɣari! Min ixs ad yini iyyar isekkwan arebɛa-mya ciqlu n nnuqart jar ayi d cek? Nḍeř amettin nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Isřa Ibrahim i Ɛifrun uca iwzen Ibrahim i Ɛifrun tmenyat n nnuqart i xef issiweř deg imezzuɣen n tarwa n Ḥit: arebɛa-mya ciqlu n nnuqart, am tt nnumen isebbaben. ");
INSERT INTO rifl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ammu i idweř yeyyar n Ɛifrun, wenni iǧan di Makfila arendad n Mamri, iyyar d ifri wenni dayes iǧan d marra ticejjura inni deg iyyar ɣar iymiren nnes i d as dd-innḍen,    ");
INSERT INTO rifl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","d agřa n Ibrahim zzat i tarwa n Ḥit d marra inni yudfen ɣar tewwart n tendint. ");
INSERT INTO rifl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Awarni aya inḍeř Ibrahim Sara, tamɣart nnes, deg ifri n yeyyar n Makfila qibač i Mamri, wenni iǧan d Ḥabrun di temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ammu i idweř iyyar ak-d yefri i dayes iǧan zi tarwa n Ḥit ɣar Ibrahim am wenḍeř nnes. ");
INSERT INTO rifl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahim tuɣa iwsar u imɣar deg wussan uca SIDI ibarek Ibrahim di kuřci. ");
INSERT INTO rifl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Xenni inna Ibrahim i umsexxar nnes awessar nni iǧan x taddart nnes, awkiř n marra min ɣares: “Egg řexxu afus nnec sadu tmeṣṣaḍt inu, ");
INSERT INTO rifl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ad ac ssjjaǧeɣ s SIDI, AREBBI n ijenwan d AREBBI n temmurt, belli war dd-tᵉttiwyed tamɣart i mmi zi tḥenjirin n ayt n Kenɛan mani zeddɣeɣ necc jar asen, ");
INSERT INTO rifl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","maca ad traḥed ɣar temmurt i zi dd-usiɣ, ɣar raǧ inu, maḥend ad dd-tawyed tamɣart i mmi Isḥaq.” ");
INSERT INTO rifl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Inna as umsexxar: “Balak war tᵉttexs temɣart ad ayi dd-teḍfar ɣar temmurt-a. Ma ittxeṣṣa ad arreɣ mmic ɣar temmurt nni manis dd-tusid?” ");
INSERT INTO rifl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Inna as Ibrahim: “Ḥḍat, war dd-ttarri ca mmi dinni! ");
INSERT INTO rifl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","SIDI, AREBBI n ijenwan wenni d ayi iṭṭfen zi taddart n baba u zi temmurt n raǧ inu, wenni ɣari issiwřen, ijjuǧ ayi umi d ayi inna: ‘I zzariɛet nnec ad wceɣ tammurt-a!’, d Netta i ɣa issekken lmalak nnes zzat i wudem nnec, maḥend ad tawyed ssenni tamɣart i mmi. ");
INSERT INTO rifl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mařa tamɣart war tᵉttexs ad cek dd-teḍfar, ad tiřid třellid zi tjaǧit-a, mɣir war dd-ttarri din mmi.” ");
INSERT INTO rifl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Issars umsexxar afus nnes sadu tmeṣṣaḍt n sidis Ibrahim ijjuǧ as x man aya. ");
INSERT INTO rifl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Iksi umsexxar ɛecra n iřeɣman zeg iřeɣman n sidis, iruḥ. Tuɣa ɣares ɛřam kuř agřa iɣřan n sidis. Ikkar uca iṭṭef abrid ɣar temmurt n Aram-Nahrayn, aqa-tt d Misuputamya, ɣar tendint n Naḥur. ");
INSERT INTO rifl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ɣar uxecci n tmeddit ijja iřeɣman ad jjnen barra i tendint zzat i řɛunṣar n waman, ɣar tsaɛɛet i di dd-ffɣent temɣarin, maḥend ad ayment aman. ");
INSERT INTO rifl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Xenni inna: “SIDI, AREBBI n sidi inu Ibrahim, ttzawageɣ Cek ad ayi tɛawned ass-a uca scen tamexsiwt nnec icewwaren i sidi inu Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Aqa ayi ɣar řɛunṣar n waman d tḥenjirin n yeryazen n tendint ad dd-ffɣent maḥend ad ayment aman. ");
INSERT INTO rifl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ejj tabřiɣt nni umi ɣa iniɣ: ‘Sehwa-dd aqbuc nnem, mařa texsed, ad sweɣ!’, uca xenni ad tini: ‘Su, ad wardeɣ uřa d iřeɣman nnec!’, aqa d nettat i teggid i umsexxar nnec Isḥaq, u s uya ad ssneɣ aqa tessecned tamexsiwt nnec icewwaren i sidi inu.” ");
INSERT INTO rifl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Uca ɛad qbeř i ɣa ikemmer awař, iẓra Rifqa, tenni i dd-yurwen i Bituwil, mmis n Milka, tamɣart n Naḥur umas n Ibrahim, teffeɣ-dd zi tendint s weqbuc nnes x teɣruḍt. ");
INSERT INTO rifl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Tabřiɣt tuɣa dayes aẓri imɣar, d taɛzarect, war tt issin weryaz. Nettat tehwa-dd ɣar řɛunṣar, teccur aqbuc nnes uca tgeɛɛed ɛawed. ");
INSERT INTO rifl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yuzzeř ɣares umsexxar nni, inna: “Ttzawgeɣ cem ad ayi tewced ad sweɣ cwayt n waman zeg weqbuc nnem!” ");
INSERT INTO rifl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nettat tenna: “Su, a sidi inu!” Tqeǧeq tessehwa aqbuc nnes x ufus nnes, tewca as ad isu. ");
INSERT INTO rifl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Řami d as tewca iswa mliḥ, tenna: “Ad aymeɣ aman ɛawed i iřeɣman nnec, ař ɣarsen i ɣa yiři s zzyada.” ");
INSERT INTO rifl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tqeǧeq tᵉssexwa aqbuc di tarya, tuzzeř ɛawed ɣar řɛunṣar, ḥima ad tayem aman, uca tuyem asen-dd aman i iřeɣman nnes marra. ");
INSERT INTO rifl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Waxxa itebhet dayes weryaz, isqar, ḥima ad issen ma SIDI issehwen xas abrid nnes niɣ lla. ");
INSERT INTO rifl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Umi jjiwnen iřeɣman tisessi, iksi weryaz deg ijj n umur ict n txadent n wureɣ, tenni iweznen azyen ciqlu, d tnayen n tmeqyasin i ifassen nnes, tinni iweznen ɛecra ciqlu n wureɣ, ");
INSERT INTO rifl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","inna: “Ini ayi, umi teggid d yeǧis? Ma aqa din amcan di taddart n babam mani nzemmar ad nessens?” ");
INSERT INTO rifl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nettat tenna as: “Necc d yeǧis n Bituwil, mmis n Milka, wenni i-tt-i-dd-yurwen i Naḥur.” ");
INSERT INTO rifl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Uca tarni tenna as: “Aqa ɛawed ɣarneɣ aṭṭas n uřum d iɣeǧ, u ɣarneɣ ɛawed amcan i tmensiwt.” ");
INSERT INTO rifl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Uca yuḍar weryaz uca ibendeq i SIDI, ");
INSERT INTO rifl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","inna: “Ad ittwabarek SIDI, AREBBI n sidi inu Ibrahim, wenni war ikkisen tamexsiwt nnes icewwaren d řaman nnes zi sidi inu. Indeh ayi SIDI deg webrid ɣar taddart n wawmaten n sidi inu.” ");
INSERT INTO rifl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tuzzeř tebřiɣt, tɛawed timesřayin-a i yemmas di taddart. ");
INSERT INTO rifl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Uca Rifqa tuɣa ɣares umas, qqaren as Laban, uca Laban yuzzeř ɣar weryaz nni tuɣa din di barra ɣar řɛunṣar. ");
INSERT INTO rifl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Tuɣa iẓra taxadent d tnayen n tmeqyasin deg ifassen n učmas uca isřa i wawařen i tuɣa teqqar učmas Rifqa, tenna: “Ammu i kidi issiweř weryaz nni.” Uca yuyur ɣar weryaz. Xzar, ibedd diha zzat i iřeɣman, ɣar řɛunṣar. ");
INSERT INTO rifl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Inna: “Araḥ-dd, a cek d amimun n SIDI! Mayemmi teqqimed di barra, necc aqa sswejdeɣ taddart d wemcan i iřeɣman.” ");
INSERT INTO rifl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Iruḥ weryaz akides ɣar taddart u netta iḍřeq i iseɣwan n iřeɣman. Netta iwca asen řum d macca, uca iksi aman, ḥima ad issird iḍaren nnes uřa d iḍaren n iryazen nni kides iǧan. ");
INSERT INTO rifl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Issars zzates min ɣa yecc. Uca netta inna: “War ttᵉtteɣ qbeř i ɣa iniɣ tabrat inu.” Netta inna as: “Siweř!” ");
INSERT INTO rifl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Xenni inna: “Necc d amsexxar n Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","SIDI ibark sidi inu aṭṭas s waṭṭas uca ccan nnes imɣar aṭṭas. Aqa iwca as uǧi d ifunasen d tfunasin, nnuqart d wureɣ, isemɣan d tiyya, iřeɣman d yeɣyař. ");
INSERT INTO rifl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","D Sara, tamɣart n sidi inu, turuw-dd aḥenjir i sidi inu awarni umi tewsar u netta iwca as marra min ɣares. ");
INSERT INTO rifl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Uca sidi inu ijja ayi jjuǧeɣ, inna: ‘War dd-ttawi tamɣart i mmi zi tḥenjirin n ayt n Kenɛan inni mani zedɣeɣ di temmurt nsen. ");
INSERT INTO rifl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Uct xak mařa war ttriḥed ɣar taddart n baba, ɣar raǧ inu uca ad dd-tawyed tamɣart i mmi ssenni.’ ");
INSERT INTO rifl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Xenni necc nniɣ i sidi inu: ‘Balak tamɣart war d ayi dd-tḍeffar.’ ");
INSERT INTO rifl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Uca netta inna ayi: ‘SIDI i umi uyureɣ zzat i wudem nnes, aqa Netta ad dd-issekk lmalak nnes akidek uca ad xak issehwen abrid nnec ař dd ɣa tawyed i mmi ict n temɣart zi řaǧ inu u zi taddart n baba. ");
INSERT INTO rifl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ad tiřid tfekked zi tjaǧit i d ayi tejjuǧed, xmi ɣa traḥed ɣar řaǧ inu u nitni war d ac tt tticen, xenni ad cek ssuffɣeɣ zi tjaǧit nnec i tuɣa tejjuǧed.’ ");
INSERT INTO rifl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ass-a usiɣ-dd ɣar řɛunṣar uca nniɣ: ‘A SIDI, AREBBI n sidi inu Ibrahim, ttzawageɣ ad tᵉsshewned řexxu abrid i di ggureɣ. ");
INSERT INTO rifl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Aqa ayi da zzat i řɛunṣar n waman. Ejj ad tiři ammu, aqa taɛzarect, tenni dd ɣa iffɣen, maḥend ad tayem aman u i tenni umi ɣa iniɣ: Ewc ayi ad sweɣ cwayt n waman zeg uqbuc nnem! ");
INSERT INTO rifl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","uca xenni nettat ad ayi tini: Su cek u necc ad aymeɣ ɛawed i iřeɣman nnec!, d ta ad tiři d tamɣart nni d issewjed SIDI i mmis n sidi inu.’ ");
INSERT INTO rifl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Uca qbeř i ɣa kemmřeɣ taẓaǧit-a deg wuř inu, xzar, Rifqa teffeɣ-dd s uqbuc nnes x teɣruḍt nnes, tehwa ɣar řɛunṣar uca tuyem-dd aman. Nniɣ as: ‘Ttzawgeɣ cem ad ayi tewced ad sweɣ!’ ");
INSERT INTO rifl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Deɣya tessehwa aqbuc nnes, tenna: ‘Su u necc ad ssesweɣ ɛawed iřeɣman nnec!’ Swiɣ uca nettat tewca ɛawed i iřeɣman ad swen. ");
INSERT INTO rifl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Sseqsiɣ tt, nniɣ: ‘Umi teggid d yeǧis?’ Nettat tarra: ‘Necc d yeǧis n Bituwil, mmis n Naḥur wenni d as dd-yurwen Milka.’ Xenni ggiɣ as taxadent di tinzart nnes d tmeqyasin deg ifassen nnes. ");
INSERT INTO rifl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Xas uca uḍareɣ, bendqeɣ i SIDI uca barkeɣ SIDI, AREBBI n sidi inu Ibrahim, wenni d ayi inedhen nican deg webrid, ḥima ad dd-awyeɣ iǧis n umas n sidi inu d temɣart i mmis. ");
INSERT INTO rifl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Xenni řexxu, mařa kenniw texsem ad tessecnem tamexsiwt icewwaren d řaman i sidi inu, ini ayi t, mařa lla, ini ayi t ɛawed, xenni ad kkeɣ yefus niɣ uzeřmaḍ.” ");
INSERT INTO rifl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Xenni Laban d Bituwil arrin-dd, nnan: “Zi SIDI i dd-iffeɣ uya, war nzemmar ad dayek nini řɣar niɣ řxar. ");
INSERT INTO rifl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Xzar, Rifqa qibač nnec, ksi tt uca truḥed. Ad tiři nettat d tamɣart n mmis n sidi nnec, am mammec inna SIDI!” ");
INSERT INTO rifl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Umi isřa umsexxar n Ibrahim awařen nsen, ibendeq ɣar temmurt zzat i SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Uca issuffeɣ-dd umsexxar řeqcuɛ n nnuqart d řeqcuɛ n wureɣ d warruḍen, iwca i-ten i Rifqa. Ɛawed iwca tirzifin iɣřan i umas d yemmas. ");
INSERT INTO rifl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ccin, swin, netta d yeryazen inni kis dd-yusin. Ssensen din uca faqen ɣar ṣṣbeḥ. Xenni inna: “Samḥem ayi ad raḥeɣ řexxu ɣar sidi inu!” ");
INSERT INTO rifl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Arrin-dd umas d yemmas: “Ejj tabřiɣt akidneɣ waxxa mɣir ɛecra n wussan, awarni as ad tuyured.” ");
INSERT INTO rifl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Maca netta inna asen: “War dayi tᵉṭṭifem ɛad umi SIDI issehwen abrid inu! Mɣir ejj ayi ad raḥeɣ ɣar sidi inu.” ");
INSERT INTO rifl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nitni arrin-dd řexdenni: “Ejj aneɣ ad nřaɣa i tebřiɣt, ad nseř i min ɣa tini zeg uqemmum nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Řaɣan i Rifqa uca nnan as: “Ma ad traḥed cem ak-d weryaz-a?” Uca nettat tarra-dd: “Wah, ad raḥeɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Xenni ssqebbḍen nitni Rifqa, učmatsen, ak-d tmeṭṭaḍt nnes, uca ssqebbḍen ɛawed amsexxar n Ibrahim d iryazen nnes. ");
INSERT INTO rifl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Uca barken Rifqa, nnan as: “A učmatneɣ, ad tawḍed ad temɣared d řuřuf n ɛecra n řuřuf uca zzariɛet nnem ad tᵉṭṭef tawwart n yinni tt icarrhen!” ");
INSERT INTO rifl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tekkar Rifqa d temsexxarin nnes timeẓyanin, nyint x iřeɣman, ḍfarent aryaz. Ammu i dd-yiwi umsexxar Rifqa uca iruḥ. ");
INSERT INTO rifl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aqa iffeɣ-dd Isḥaq zeg wanu n Laḥay-Ru’i. Tuɣa izeddeɣ di Temmurt n Ljanub. ");
INSERT INTO rifl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Iffeɣ-dd Isḥaq maḥend ad iẓẓaǧ deg iyyar. Tuɣa-tt ɣar uweṭṭu n tmeddit. Netta issgeɛɛed tamuɣři nnes, iqceɛ, u xzar, iřeɣman ttqarraben-dd! ");
INSERT INTO rifl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rifqa ɛawed tessgeɛɛed tiṭṭawin nnes, teẓra Isḥaq. Nettat tejja ixef nnes ad tḍar deɣya x weřɣem ");
INSERT INTO rifl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","uca tenna i umsexxar: “Min iɛna weryaz nni dd-yusin deg iyyar ɣarneɣ?” Uca inna umsexxar: “Wa d sidi inu!” Xenni teksi takenbuct uca třeḥḥef. ");
INSERT INTO rifl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Uca iɛawed umsexxar i Isḥaq marra min igga. ");
INSERT INTO rifl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Igewwed i-tt Isḥaq ɣar uqiḍun n yemmas Sara, yiwi Rifqa uca nettat tedweř d tamɣart nnes u netta tuɣa ittexs i-tt. Ammu i ifewwej Isḥaq awarni řmewt n yemmas. ");
INSERT INTO rifl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Iksi Ibrahim tamɣart nneɣni, qqaren as Qatura.    ");
INSERT INTO rifl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Netta turuw as-dd Zimran, Yaqcan, Midyan, Yicbaq d Cuḥa. ");
INSERT INTO rifl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yuqcan ijja-dd Caba d Dadan. Uca arrawen n Dadan tuɣa aten d Iccuriyyen d Ilituciyyen d Iliyumiyyen. ");
INSERT INTO rifl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Iḥenjiren n Midyan tuɣa aten d Ɛiyfa, Ɛifar, Ḥanux, Abidaɛ d Aldaɛa. Marra ina tuɣa aten d iḥenjiren n Qaṭura. ");
INSERT INTO rifl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahim iwca marra min ɣares i Isḥaq. ");
INSERT INTO rifl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Maca i iḥenjiren n tiyya i tuɣa ɣar Ibrahim, iwca asen Ibrahim arriɣalut uca, am t tuɣa ɛad iddar, issekk i-ten ssenni ɣar ccarq, ɣar temmurt n ccarq, issiggʷej i-ten x Isḥaq mmis. ");
INSERT INTO rifl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahim tuɣa iddar mya u-xemsa u-sebɛin n iseggʷusa, wa d řmijař n tudart nnes. ");
INSERT INTO rifl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Iḍřeq Ibrahim i buḥbeř nnes uca immut di ccib isegged, di tewsar d tyawant. Uca immarni ɣar řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isḥaq d Ismaɛil, iḥenjiren nnes, neḍřen t deg ifri n Makfila deg iyyar n Ɛifrun, mmis n Ṣuḥar, Aḥitti, iyyar i iǧan qibač i Mamri. ");
INSERT INTO rifl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ittwanḍeř Ibrahim d temɣart nnes Sara deg iyyar nni isɣa Ibrahim zi tarwa n Ḥit. ");
INSERT INTO rifl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Awarni i řmewt n Ibrahim ibarek AREBBI mmis Isḥaq. Uca izdeɣ Isḥaq zzat i wanu n Laḥay-Ru’i. ");
INSERT INTO rifl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ina d imezruyen n yinni dd-ittwaxeřqen zi Ismaɛil, mmis n Ibrahim, inni dd-tejja Hajar, tayya n Sara zi Miṣra, i Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","D yina d ismawen n iḥenjiren n Ismaɛil, s ismawen nsen ɛlaḥsab axřaq nsen. Amenzu n Ismaɛil tuɣa-t d Nabayut, xenni Qidar, Adbiyil, Mibsam, ");
INSERT INTO rifl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO rifl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ḥadar, Tayma, Yaṭur, Nafic d Qidma. ");
INSERT INTO rifl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","D yina d iḥenjiren n Ismaɛil s ismawen nsen, s dcurat nsen d řmarageḥ nsen: tenɛac n řḥukkam s řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Tuɣa iddar Ismaɛil mya u-sebɛa u-třatin n iseggʷusa. Xenni iḍřeq Ismaɛil i buḥbeř nnes, immut uca immarni ɣar řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nitni zeddɣen zi Ḥawila ɣar Cur, wenni iǧan arendad n Miṣra, am tᵉṭṭfed abrid ɣar Accur. Netta izdeɣ arendad n marra aytmas. Ina d imezruyen n yinni dd-ittwaxeřqen zi Isḥaq, mmis n Ibrahim. ");
INSERT INTO rifl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ibrahim ijja-dd Isḥaq. ");
INSERT INTO rifl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tuɣa ɣar Isḥaq arebɛin n iseggʷusa umi yiwi Rifqa d tamɣart. Nettat d yeǧis n Bituwil, Aramiyu zi Faddan-Aram, učmas n Laban, Aramiyu. ");
INSERT INTO rifl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Iḥeccem Isḥaq SIDI di ṭṭweɛ n temɣart nnes, tenni tuɣa war ittirwen ca, uca istajeb as SIDI s tẓaǧit nnes yuǧɣen, ařami teksi temɣart nnes, Rifqa, ddeyset. ");
INSERT INTO rifl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Uca mmdeḥsen iḥenjiren deg uɛeddis nnes. Xenni tenna: “Manawya ɛawed, mayemmi d ayi ittemsar man aya?”, uca truḥ ad tesseqsa SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Inna as SIDI: “Aqa din tnayen n řegnus di ddeyset nnem u tnayen n ccuɛub ad mmsebḍan zi dwaxeř nnem. Ijj n cceɛb ad yiři ijhed x cceɛb nneɣni u wenni d amenzu ad ixdem i umaẓuẓ.” ");
INSERT INTO rifl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ařami dd-iwḍen wussan nnes ad taru, xzar, aqa da deg uɛeddis nnes acniwen. ");
INSERT INTO rifl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Iffeɣ-dd umezwar. Tuɣa-t d azeggʷaɣ, iceɛɛar qaɛ am yict n thiḍurt. S uyenni ggin as Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Awarni as iffeɣ-dd umas. Iṭṭef afus nnes deg unirz n Ɛisu. S uya semman t s yisem Yaɛqub. Tuɣa ɣar Isḥaq settin n iseggʷusa ɣar wexřaq nsen. ");
INSERT INTO rifl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Řami gman iḥenjiren, idweř Ɛisu d ijj n weryaz issen aneymar, ijj n weryaz n barra, maca Yaɛqub idweř d ijj n weryaz yarsa, wenni izeddɣen deg iqiḍan. ");
INSERT INTO rifl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isḥaq tuɣa ittexs Ɛisu, minzi iɛjeb as ad yecc aysum n řmař n řexřa, u Rifqa tuɣa tᵉttexs Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Uca issnenni Yaɛqub ict n macca, umi dd-iɛqeb Ɛisu zi řexřa, yuḥeř. ");
INSERT INTO rifl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Inna Ɛisu i Yaɛqub: “Ttzawgeɣ cek ad ayi tewced ad cceɣ zeg uzeggʷaɣ, azeggʷaɣ nni diha, maɣar aqa fniɣ s ufadi.” X uya qqaren as ‘Idum’. ");
INSERT INTO rifl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Řexdenni inna Yaɛqub: “Zenz ayi ass-a řḥeqq nnec n umenzu.” ");
INSERT INTO rifl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Inna Ɛisu: “Xzar, aqa necc ad mmteɣ, min ɣa ggeɣ s řḥeqq n umenzu?” ");
INSERT INTO rifl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Xenni inna Yaɛqub: “Jaǧ ayi řexxu!” Uca ijjuǧ as, izzenz i Yaɛqub řḥeqq n umenzu nnes. ");
INSERT INTO rifl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Xas uca iwca Yaɛqub i Ɛisu aɣrum d umecři n řeɛdes, u Ɛisu icca, iswa, ikkar, iruḥ. Ammu isseḥqar Ɛisu řḥeqq n umenzu nnes. ");
INSERT INTO rifl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tuɣa iǧa řaẓ di temmurt, ijj n řaẓ nneɣni x umezwar nni tuɣa iǧan deg wussan n Ibrahim. S uya iruḥ Isḥaq ɣar Abimalik, ajeǧid n Ifilisṭiniyyen, ɣar jjwayeh n Jirar. ");
INSERT INTO rifl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Dinni iban as-dd SIDI, inna: “War hekkwi ca ɣar Miṣra. Zdeɣ di temmurt i d ac ɣa iniɣ. ");
INSERT INTO rifl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Zdeɣ di temmurt-a am ubarrani u Necc ad kik iřiɣ, ad cek barkeɣ, minzi i cek u i zzariɛet nnec umi ɣa wceɣ marra timmura-ya uca ad kemmřeɣ tjaǧit i jjuǧeɣ i Ibrahim babac. ");
INSERT INTO rifl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ad kettareɣ zzariɛet nnec am yitran n ujenna uca ad wceɣ i zzariɛet nnec marra timmura-ya. Marra řegnus n ddunect ad ttwabarken di zzariɛet nnec, ");
INSERT INTO rifl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","minzi isřa Ibrahim i wawař inu uca iḥḍa min d as wciɣ maḥend ad iḥḍa: řumurat inu, tiweṣṣa inu d izerfan inu.” ");
INSERT INTO rifl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ammu i iqqim Isḥaq izeddeɣ di Jirar. ");
INSERT INTO rifl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Řami t sseqsan iryazen n wemcan nni x temɣart nnes, inna asen: “Nettat d učma!”, minzi iggʷed ad yini: “D tamɣart inu!”. Maɣar inna deg yixef nnes: “Mařa war nniɣ amenni ad ayi nɣen iryazen n wemcan-a di ṭṭweɛ n Rifqa, minzi aqa dayes aẓri.” ");
INSERT INTO rifl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Řami din izdeɣ aṭṭas n wussan, imsar belli Abimalik, ajeǧid n Ifilisṭiniyyen, ixzar-dd zi řkazi, iẓra Isḥaq ittɛatab Rifqa, tamɣart nnes. ");
INSERT INTO rifl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Uca iřaɣa Abimalik x Isḥaq, inna as: “Xzar, ta s tidett d tamɣart nnec! Mammec teggid tennid aneɣ d učma?” Isḥaq inna as: “S minzi nniɣ i yixef inu: ‘Aqa tiři ad ayi nɣen x ssibbet nnes.’” ");
INSERT INTO rifl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimalik inna: “Maɣar d aneɣ teggid aya? X drus ad yiři iṭṭeṣ ca n ijj zi řgens ak-d temɣart nnec uca ad tiři teggid ddenb x yiři nneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Yumur Abimalik marra řgens, inna: “Wenni i ɣa iḥadan aryaz-a niɣ tamɣart nnes, ad t nɣen nican!” ");
INSERT INTO rifl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izarɛ Isḥaq di temmurt nni uca iksi aseggʷas nni mya n imuren n zzyada, minzi ibark i-t SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Temmarni ccenɛet n weryaz nni uca netta iqqim imeqqar, ařami tedweř ccenɛet nnes d tameqqrant aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tuɣa ɣares uǧi u ɣares ɛawed ifunasen d tfunasin d waṭṭas n isemɣan, ařami zzayes usmen Ifilisṭiniyyen. ");
INSERT INTO rifl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Marra anuten nni ɣzan imsexxaren deg wussan n Ibrahim babas, netyen ten Ifilisṭiniyyen uca ccuren ten s ucař. ");
INSERT INTO rifl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Xenni inna Abimalik i Isḥaq: “Beɛɛed xaneɣ, minzi tdewřed tjehded xaneɣ s waṭṭas.” ");
INSERT INTO rifl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isḥaq iruḥ ssenni, iwta iqiḍan nnes di teɣzurt n Jirar uca izdeɣ dinni. ");
INSERT INTO rifl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Uca idweř Isḥaq iɣza anuten n waman inni tuɣa ɣzin deg wussan n Ibrahim babas, inni netyen Ifilisṭiniyyen awarni i řmewt n Ibrahim. Isemma ten s ismawen inni d asen iřaɣa babas. ");
INSERT INTO rifl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Uca imsexxaren n Isḥaq ɣzan di teɣzurt nni uca ufin din řɛunṣar n waman ddaren. ");
INSERT INTO rifl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Xenni qacḥen imeksawen n Jirar ak-d imeksawen n Isḥaq, nnan: “Aman nneɣ!” S uyenni řaɣan isem n řɛunṣar nni ‘Ɛisiq’, minzi tuɣa ttqacaḥen xas. ");
INSERT INTO rifl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Xenni ɣzan ijj n řɛunṣar nneɣni uca mmennɣen xas ɛawed. S uyenni d as igga isem n ‘Sitna’. ");
INSERT INTO rifl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Uca ibeɛɛed ssenni, iɣza ijj n řɛunṣar nneɣni, war xas qicḥen ca uca ggin as isem nnes ‘Raḥubut’, inna: “Řexxu SIDI iwca aneɣ ttasiɛ uca ad ɣarneɣ tiři řɣiǧet di temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Uca igeɛɛed ssenni ɣar Bi’r-Sebɛa. ");
INSERT INTO rifl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Iban as-dd SIDI di ǧiret nni, inna as: “Necc d AREBBI n Ibrahim babac! War tteggʷed ca, aqa Necc akidek u Necc ad cek barkeɣ, ad kettareɣ zzariɛet nnec di ṭṭweɛ n umsexxar inu Ibrahim.” ");
INSERT INTO rifl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Xenni ibna din ijj n uɛalṭar min xef igga taɣarṣt, uca iřaɣa Isem n SIDI. Iwta din aqiḍun nnes uca ɣzin din imsexxaren n Isḥaq ijj n wanu. ");
INSERT INTO rifl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimalik yusa-dd ɣares zi Jirar, ak-d Aḥuzzat, ameddukkeř nnes, d Fikul, akumandar n řɛeskar nnes. ");
INSERT INTO rifl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Inna asen Isḥaq: “Maɣar ɣari dd-tusim, waxxa kenniw tcarrhem ayi uca tessuffɣem ayi xawem?” ");
INSERT INTO rifl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nitni nnan: “Aqa neẓra belli SIDI akidek. S uya nenna, ad din tiři řexxu ict n tjaǧit jaraneɣ, jaraneɣ d cek, uca ejj aneɣ ad kik negg ijj n řɛahd, ");
INSERT INTO rifl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ḥima cek war d aneɣ tᵉttegged řɣar, am mammec uřa d neccin war cek nḥidi ca uca aqa nemṣurref akidek mliḥ uca nessekk i cek di řaman. Aqa cek řexxu d amimun n SIDI!” ");
INSERT INTO rifl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Xenni igga asen ict n zzardet uca ccin, swin. ");
INSERT INTO rifl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kkaren zic uca jjuǧen ijjen i wenneɣni. Xas uca issqebbeḍ i-ten Isḥaq uca ruḥen nitni zi ɣares di řehna. ");
INSERT INTO rifl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Deg wass nni d ijj usin-dd imsexxaren n Isḥaq, xebbaren t x wanu i iɣzan uca nnan as: “D aman i nufa.” ");
INSERT INTO rifl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isemma anu-ya Sebɛa. X uya i iǧa yisem n tendint nni Bi’r-Sebɛa, ař ass-a. ");
INSERT INTO rifl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Umi tuɣa ɣar Ɛisu arebɛin n iseggʷusa, yiwi Yudit, yeǧis n Biri, Aḥitti, d tamɣart, uřa d Basmat, yeǧis n Ilun, Aḥitti. ");
INSERT INTO rifl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tuɣa atent d tarzugi n wuř i Isḥaq d Rifqa. ");
INSERT INTO rifl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Řami idweř Isḥaq d awessar u tiṭṭawin nnes ɛemcent ařami ɛřaḥař war ittwiři, iřaɣa Ɛisu, mmis amenzu, inna as: “Mmi!” Uca netta inna as: “Aqa ayi da!” ");
INSERT INTO rifl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Uca inna: “Aqa necc wsareɣ, war ssineɣ ass i di ɣa mmteɣ. ");
INSERT INTO rifl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Řexxu, ksi řesnaḥ nnec d weqrab nnec n fřitcat d řqews nnec, teffɣed ɣar řexřa uca gmar ayi-dd taymart i macca. ");
INSERT INTO rifl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Sewjed ayi-dd ict n macca icnan i d ayi ɣa iɛejben uca tewced ayi tt-i-dd, ad tt cceɣ, ḥima ad cek barkeɣ qbeř ma ad mmteɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rifqa tuɣa tesřa umi issiweř Isḥaq ak-d mmis Ɛisu. Uca iruḥ Ɛisu ɣar řexřa ḥima ad iymar timeyra, maḥend ad tt-i-dd-yawi. ");
INSERT INTO rifl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Xenni tessiweř Rifqa ak-d Yaɛqub mmis, tenna as: “Xzar, necc sřiɣ babac issawař ak-d Ɛisu umac, inna as: ");
INSERT INTO rifl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Awi ayi-dd ict n teymart uca sewjed ayi ict n macca lemliḥ, maḥend ad tt cceɣ, ḥima necc ad ac barkeɣ qibač i wudem n SIDI qbeř i ɣa mmteɣ.’ ");
INSERT INTO rifl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Řexxu, mmi, seř-dd ɣari min zi cek ɣa umureɣ. ");
INSERT INTO rifl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Řuh ɣar tḥimart uca awi ayi-dd tnayen n iɣayḍen imeẓyanen zeg iɣayḍen. Necc ad zzaysen sswejdeɣ ict n macca icnan i babac, am mammec d as ittaɛjib ");
INSERT INTO rifl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","u ittxeṣṣa cek ad t tawyed i babac, ad yecc, ḥima ad cek ibarek qbeř řmewt nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Xenni inna Yaɛqub i Rifqa, yemmas: “Xzar, Ɛisu uma d aryaz bu-cɛar u necc d aryaz d ařeqqaɣ. ");
INSERT INTO rifl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Balak ad ayi iḥada baba uca ad iřiɣ amecnaw aɣeccac di tiṭṭawin nnes. Xenni ad ksiɣ ict n nneɛřet xafi, war kessiɣ lbaraka.” ");
INSERT INTO rifl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yemmas tenna as: “Nneɛřet nnec ad tiři xafi, a mmi! Ṭaɛ i wawař inu waha, awyi ten-dd ɣari.” ");
INSERT INTO rifl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Xenni netta iruḥ, iksi ten uca yiwyi ten i yemmas. Uca yemmas tegga ict n macca icnan am mammec d as ittaɛjib i babas. ");
INSERT INTO rifl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Teksi Rifqa arruḍ ifeccḥen aṭṭas i tuɣa ɣares di taddart zeg warruḍ n Ɛisu, mmis amenzu, uca tarḍ i-t Yaɛqub, mmis amaẓuẓ. ");
INSERT INTO rifl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Tegga as iřem n iɣayḍen imeẓyanen zeg iɣayḍen x ifassen nnes u x yiri nnes ařeqqaɣ. ");
INSERT INTO rifl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tewca macca-ya icnan ak-d weɣrum nni tenggʷa deg ifassen n mmis Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Netta yusa-dd ɣar babas, inna: “A Baba!” Netta inna: “Aqa ayi da! Min teɛnid cek, a mmi?” ");
INSERT INTO rifl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Inna Yaɛqub i babas: “Necc d Ɛisu, amenzu nnec. Ggiɣ min d ayi tennid. Kkar řexxu, qqim, ecc zi tmeyra inu, ḥima ad ayi ibarek řeɛmar nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Xenni inna Isḥaq i mmis: “Mammec teggid tufid tt deɣya, a mmi?” Inna: “Maɣar SIDI, AREBBI nnec, igga i-tt deg webrid inu.” ");
INSERT INTO rifl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isḥaq inna i Yaɛqub: “Qarreb-dd řexxu, ḥima ad cek ḥadiɣ, a mmi, ma cek d mmi Ɛisu niɣ lla.” ");
INSERT INTO rifl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Řami dd-iqarreb Yaɛqub ɣar babas Isḥaq, iḥada t uca inna: “Tmijja d tmijja n Yaɛqub, maca ifassen d ifassen n Ɛisu.” ");
INSERT INTO rifl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Netta war t iɛqiř, minzi ifassen nnes tuɣa ceɛɛaren amecnaw ifassen n Ɛisu uca ibark i-t. ");
INSERT INTO rifl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Inna: “Ma d cek d mmi Ɛisu?” Netta inna: “D necc!” ");
INSERT INTO rifl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Xenni inna: “Sqarreb ayi tt-i-dd zzati, ḥima ad cceɣ zi tmeyra n mmi, ḥima necc ad cek barkeɣ.” Issars i-tt-i-dd zzates uca icca. Yiwi as-dd ɛawed binu uca iswa. ");
INSERT INTO rifl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Inna as babas Isḥaq: “Qarreb-dd ɣari řexxu, sudem ayi, a mmi!” ");
INSERT INTO rifl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Uca iqarreb-dd ɣares, issudem i-t. Icemm Isḥaq arriḥet n warruḍ nnes uca ibark i-t, inna: “Xzar, řefwaḥet n mmi am řefwaḥet n yeyyar i ibarek SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ad ac iwc AREBBI zi nnda n ujenna u zi řeydam n temmurt uřa d waṭṭas n imendi d binu n jdid. ");
INSERT INTO rifl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ad ac xedmen řegnus uca ccuɛub ad ac bendqen. Ḥkem x aytmac u ejj iḥenjiren n yemmac ad ac bendqen! Inni cek i ɣa ineɛřen, ad ttwaneɛřen, u inni cek ɣa ibarken, ad ttwabarken.” ");
INSERT INTO rifl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Awarni řami ikemmeř Isḥaq lbaraka i Yaɛqub uca am dd-iffeɣ Yaɛqub ɛad x babas Isḥaq, iɛqeb-dd Ɛisu, umas, zi teymart nnes. ");
INSERT INTO rifl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Issewjed xenni ict n macca icnan uca iksi tt ɣar babas, inna as: “Ttzawgeɣ, baba, kkar tecced zi teymart n mmic, ḥima cek ad ayi tbarked.” ");
INSERT INTO rifl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Inna as Isḥaq, babas: “Min teɛnid cek?” Netta inna: “Necc d mmic, amenzu nnec, Ɛisu.” ");
INSERT INTO rifl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Uca innexřeɛ Isḥaq, inna: “Min iɛna wanita i dd-yusin da, iṭṭef taymart uca yiwi ayi tt-i-dd? Cciɣ zi marra man aya qbeř dd-tusid uca necc barkeɣ t u ad ittwabarek ɛawed.” ");
INSERT INTO rifl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Umi isřa Ɛisu awařen n babas, isɣuy s yijj n řeɛyad ijhed yarzeg, inna i babas: “Barek ayi uřa d necc, a baba!” ");
INSERT INTO rifl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Inna: “Yusa-dd umac s teḥraymect, iksi lbaraka nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Xenni inna: “Ma war iǧi isem nnes s řḥeqq Yaɛqub? Aqa icmet ayi tnayen n twařawin. Iksi řḥeqq n umenzu inu uca aqa řexxu iksi ɛawed lbaraka inu.” Xenni inna: “Ma war ɣarek teqqim ca n lbaraka i necc?” ");
INSERT INTO rifl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Xenni yarra-dd Isḥaq, inna i Ɛisu: “Xzar, necc ggiɣ t d řḥakem xak uca wciɣ as aytmas d imsexxaren, uřa s imendi d binu n jdid ɛewwřeɣ t. Min din ɛad, ad ac wceɣ řexxu, a mmi?” ");
INSERT INTO rifl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Inna Ɛisu i babas: “Ma ɣarek mɣir lbaraka-ya waha, a baba? Barek ayi ɛawed, uřa d necc, a baba!” Uca issgeɛɛed Ɛisu tmijja nnes, isɣuy. ");
INSERT INTO rifl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Xenni yarra-dd Isḥaq x babas, inna as: “Xzar, ad tiři tzeddiɣt nnec iggʷejjen x řeydam n temmurt u x nnda n ujenna sennej. ");
INSERT INTO rifl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","S ssif nnec i ɣa teqqimed teddared u ad txedmed i umac. Maca xmi ɣa teqqimed ad tenhezzed, ad imsar ad tawḍed ad tekksed zayřu nnes x yiri nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Uca icarh Ɛisu Yaɛqub di ssibbet n lbaraka i zi t ibarek babas, uca inna Ɛisu deg wuř nnes: “Ad awḍen wussan n uɛezzi n baba, xenni ad nɣeɣ uma Yaɛqub.” ");
INSERT INTO rifl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Umi nnan i Rifqa awařen n Ɛisu, mmis amenzu, tᵉssekk ijjen ad iřaɣa i Yaɛqub, mmis amaẓuẓ, tenna as: “Xzar, Ɛisu umac yarezzu mammec zzayek i ɣa ixřef, netta ixs ad cek ineɣ. ");
INSERT INTO rifl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Řexxu, a mmi, ṭaɛ i wawař inu. Kkar uca tarewřed ɣar Ḥaran ɣar uma Laban. ");
INSERT INTO rifl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Zdeɣ akides ca n wussan ař ɣa yarsa wesɛar n umac. ");
INSERT INTO rifl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Xmi ɣa ixsi uxeyyeq n umac uca ad ittu min d as teggid, necc ad ssekkeɣ ijjen, maḥend ad cek dd-yawi ssenni. Mayemmi i zzaywem ɣa ttwaḥarrmeɣ s tnayen idwem deg ijj n wass?” ");
INSERT INTO rifl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Tenna Rifqa i Isḥaq: “Carrheɣ tudart inu di ssibbet n yessis n Ḥit. Mařa Yaɛqub yiwi tamɣart zi tebřiɣin n Ḥit, am tnayen-a, zi tḥenjirin n temmurt-a, man lqima i ɣa yiřin ɣar tudart inu?” ");
INSERT INTO rifl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Iřaɣa Isḥaq i Yaɛqub, ibarek i-t uca issekk i-t, inna as: “War ttawi tamɣart zi yessis n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kkar, ruḥ ɣar Fadan-Aram, ɣar taddart n Bituwil, babas n yemmac, uca awi-dd ssenni tamɣart i cek zeg yessis n Laban, umas n yemmac. ");
INSERT INTO rifl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Arebbi, Amzemmar x kuřci, ad cek ibarek u ad ac iwc řɣiǧet uca ad cek ikettar ař ɣa tdewřed d ijj n wegraw n řegnus. ");
INSERT INTO rifl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Iři Netta ad ac iwc lbaraka n Ibrahim, i cek u i zzariɛet nnec akidek, ḥima ad twarted tammurt nni di tzeddɣed am ubarrani, tenni iwca AREBBI i Ibrahim.” ");
INSERT INTO rifl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Xenni issekk Isḥaq Yaɛqub. Uca netta iruḥ ɣar Faddan-Aram, ɣar Laban, mmis n Bituwil, Aramiyu, umas n Rifqa, yemmas n Yaɛqub d Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Umi iẓra Ɛisu belli Isḥaq ibarek Yaɛqub uca issekk i-t-i-dd ɣar Faddan-Aram ḥima ad yawi i yixef nnes tamɣart ssenni, u řami t ibarek, yumur i-t, inna as: “War kessi tamɣart zeg yessis n Kenɛan!”, ");
INSERT INTO rifl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","uca iẓra ɛawed belli Yaɛqub iṭaɛ babas d yemmas, iruḥ ɣar Faddan-Aram, ");
INSERT INTO rifl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","xenni itwařa Ɛisu belli yessis n Kenɛan d tiɛeffanin di tiṭṭawin n babas Isḥaq. ");
INSERT INTO rifl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Xenni iruḥ Ɛisu ɣar Ismaɛil uca yiwi Maḥalat d tamɣart i yixef nnes, yarni tt-i-dd ɣar temɣarin nneɣni. Nettat tuɣa-tt d yeǧis n Ismaɛil, mmis n Ibrahim, učmas n Nabayut. ");
INSERT INTO rifl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Uca iffeɣ Yaɛqub zi Bi’r-Sebɛa, iruḥ ɣar Ḥaran. ");
INSERT INTO rifl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yiweḍ ɣar ijj n wemcan mani yensa, minzi tuɣa tafuct teɣri. Iksi zeg yeẓra n wemcan nni, issars i-ten sadu uzeǧif nnes uca iwḍa iṭṭeṣ deg wemcan nni. ");
INSERT INTO rifl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yurja, aqa ijj n ddruj ibedd x temmurt uca ittḥada ixef n ddruj ajenna, u xzar, lmalakat n AREBBI ttařyent hekkwant zzayes. ");
INSERT INTO rifl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","U xzar, SIDI ibedd xas, inna: “Necc d SIDI, AREBBI n babac Ibrahim, d AREBBI n Isḥaq. Tammurt i xef tᵉṭṭṣed ad ac tt wceɣ i cek u i zzariɛet nnec. ");
INSERT INTO rifl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ad tiři zzariɛet nnec am ucař n temmurt uca ad tiriwed ɣar řɣarb d ccarq, ɣar ccamal d ljanub. Dayek u di zzariɛet nnec ad ttwabarkent marra řaǧat n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aqa ayi Necc akidek u Necc ad cek ḥḍiɣ qaɛ mani i ɣa traḥed, ad cek arreɣ ɣar temmurt-a, minzi Necc war cek ttejjiɣ ař ɣa kemmřeɣ min d ac nniɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Řami dd-ifaq Yaɛqub zeg yiḍeṣ nnes, inna: “S tidett, SIDI aqa-t deg wemcan-a u necc war ssineɣ!” ");
INSERT INTO rifl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tuɣa iggʷed aṭṭas, inna: “Mecḥař issaggʷad wemcan-a! Aqa ta mɣir d Taddart n AREBBI u tanita d tawwart n ujenna!” ");
INSERT INTO rifl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ikkar Yaɛqub uca iksi aẓru nni tuɣa issars sadu uzeǧif nnes, igga i-t am yijj n weẓru n řidaret uca ifarreɣ zzect x uzeǧif n weẓru. ");
INSERT INTO rifl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Igga amcan nni Bayt-Il, maca zeg umezwaru tuɣa isem n wemcan nni Luz. ");
INSERT INTO rifl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Uca iwaɛd Yaɛqub, inna: “Mařa AREBBI aqa-t akidi uca ad ayi iḥḍa deg webrid i ɣa uyureɣ, ad ayi iwc aɣrum ḥima ad cceɣ, d warruḍ ḥima ad arḍeɣ ");
INSERT INTO rifl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","u mařa dewřeɣ ɣar taddart n baba di řaman, xenni SIDI ad yiři d AREBBI i necc. ");
INSERT INTO rifl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Uc aẓru-ya i ggiɣ d aẓru n řidaret, ad yiři d Taddart n AREBBI u zi marra min d ayi ɣa tewced, ad ac wceɣ řeɛcur!” ");
INSERT INTO rifl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iksi Yaɛqub deg iḍaren nnes, iruḥ ɣar temmurt n ayt n ccarq. ");
INSERT INTO rifl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ixzar uca iẓra ijj n wanu deg iyyar u tuɣa din třata n tḥimriwin n wuǧi jnint zzates, minzi zeg wanu nni warrden nitni tiḥimriwin. Tuɣa din ijj n weẓru x uqemmum n wanu. ");
INSERT INTO rifl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ssmunen din marra tiḥimriwin. Xas uca kksen aẓru x uqemmum n wanu uca warden uǧi. Awarni as arrin aẓru ɛawed x uqemmum n wanu. ");
INSERT INTO rifl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Inna asen Yaɛqub: “Aytma inu, manis kenniw?” Nitni arrin-dd: “Zi Ḥaran i neǧa.” ");
INSERT INTO rifl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Netta inna asen: “Ma tessnem Laban, mmis n Naḥur?” Nitni arrin-dd: “Wah, nessen i-t.” ");
INSERT INTO rifl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Inna asen netta: “Mammec iǧa?” Arrin-dd: “Aqa-t mliḥ, aqa da yeǧis Raḥil tusa-dd ak-d wuǧi.” ");
INSERT INTO rifl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Inna as: “Aqa da aziř ɛad imɣar, war yeǧi bu řweqt ḥima ad nendeh řebhayem. Wardem uǧi uca ruḥem, maḥend ad ten tarewsem.” ");
INSERT INTO rifl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nitni arrin-dd: “War nzemmar ad t negg ař dd ɣa munent marra tiḥimriwin. Xenni ad sseḥřuǧden aẓru x uqemmum n wanu, ḥima ad nwared uǧi.” ");
INSERT INTO rifl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Řami tuɣa ɛad issawař akidsen, tusa-dd Raḥil s wuǧi n babas, minzi nettat tuɣa-tt d tameksawt. ");
INSERT INTO rifl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Řami iẓra Yaɛqub Raḥil, yeǧis n Laban, umas n yemmas, ak-d wuǧi n Laban, umas n yemmas, ixecc-dd Yaɛqub uca isseḥřuǧed aẓru x uqemmum n wanu, iward uǧi n Laban, umas n yemmas. ");
INSERT INTO rifl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Issudem Yaɛqub Raḥil, issgeɛɛed tmijja nnes uca isɣuy. ");
INSERT INTO rifl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Inna Yaɛqub i Raḥil aqa netta zi řaǧ n babas i iǧa, uřa d mmis n Rifqa. Uca nettat tuzzeř, txebbar babas. ");
INSERT INTO rifl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Umi isřa Laban řexbar x Yaɛqub, mmis n učmas, yuzzeř ad t iřqa uca idarreɛ as, issudem i-t, indeh i-t ɣar taddart nnes. Uca netta iɛawed marra timesřayin-a i Laban. ");
INSERT INTO rifl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Inna as Laban: “D tidett cek d iɣes inu d aysum inu i teǧid.” Uca iqqim ɣares řqedd n ijj n uyur ikmeř. ");
INSERT INTO rifl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Řexdenni inna Laban i Yaɛqub: “Umi cek d uma i teǧid, ma ad ɣari txedmed baṭeř? Ini ayi min i ɣa tiři řmunet nnec?” ");
INSERT INTO rifl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ɣares tnayen n yessis. Isem n tmenzut d Liya u isem n tmaẓuẓt, Raḥil. ");
INSERT INTO rifl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Tiṭṭawin n Liya tuɣa kecɛent, maca Raḥil tuɣa dayes aẓři n waddud u n řxezrat. ");
INSERT INTO rifl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaɛqub ixs Raḥil. Inna: “Necc ad ɣarek xedmeɣ sebɛa n iseggʷusa x Raḥil yeǧis tmaẓuẓt.” ");
INSERT INTO rifl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban yarra-dd: “Xar ad ac tt wceɣ i cek niɣ ad tt wceɣ i weryaz nneɣni. Qqim akidi.” ");
INSERT INTO rifl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ammu i ixdem Yaɛqub x Raḥil sebɛa n iseggʷusa maca ḍharen as-dd iseggʷusa nni amecnaw ca n wussan, minzi tuɣa ittexs i-tt. ");
INSERT INTO rifl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Inna Yaɛqub i Laban: “Ewc ayi řexxu tamɣart inu, minzi aqa kemmřen wussan n řmijař inu, ařami xas i ɣa yadfeɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Xenni issmun Laban marra iryazen n wemcan nni, igga urar. ");
INSERT INTO rifl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ɣar tmeddit iksi yeǧis Liya uca issiweḍ i-tt ɣares uca yudef xas Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Iwca Laban tayya nnes Zilpa i yeǧis Liya d tayya. ");
INSERT INTO rifl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tiwecca nnes iẓra Yaɛqub belli d Liya. Xenni inna i Laban: “Min d ayi teggid? Ma war d ac xdimeɣ x Raḥil? Maɣar d ayi tcemted?” ");
INSERT INTO rifl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban inna: “War ittiři uya di temmurt nneɣ ad nessizzar tamaẓuẓt x tmenzut. ");
INSERT INTO rifl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kemmeř ssimana-ya n wurar n ta, xenni ad ac newc ɛawed tin x řxedmet i ɣa tegged ssa tsawent akidi ɛad sebɛa n iseggʷusa nneɣni.” ");
INSERT INTO rifl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Igga Yaɛqub amenni, ikemmeř ssimana-ya n wurar. Xenni iwca as yeǧis Raḥil d tamɣart ");
INSERT INTO rifl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","uca iwca Laban tayya nnes Bilha i yeǧis Raḥil maḥend ad tiři d tayya nnes. ");
INSERT INTO rifl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yudef Yaɛqub ɛawed x Raḥil uca ixs Raḥil ɛad ktar x Liya. Uca isexxar as ɛawed sebɛa n iseggʷusa nneɣni. ");
INSERT INTO rifl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Umi iẓra SIDI belli Liya tuɣa tᵉttwasseḥqar, yarzem řemřawet nnes, maca Raḥil tuɣa war dd-tᵉttiruw ca. ");
INSERT INTO rifl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Teksi Liya s ddeyset uca turuw-dd aḥenjir, igga as Rubin, minzi tenna: “Aqa SIDI ixzar ɣar řemḥayem inu. Řexxu ad ayi ixs weryaz inu.” ");
INSERT INTO rifl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Teksi ɛawed s ddeyset, turuw-dd aḥenjir, tenna: “Umi isřa SIDI belli necc ttwasseḥqareɣ, iwca ayi ɛawed wa.” Uca tegga as Cimɛun. ");
INSERT INTO rifl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Teksi ɛawed s ddeyset, turuw-dd aḥenjir, tenna: “Řexxu twařa-ya ad imun weryaz inu akidi, minzi urweɣ as-dd třata n iḥenjiren.” X uya netta igga as Lawi. ");
INSERT INTO rifl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Teksi twařa nneɣni s ddeyset, turuw-dd aḥenjir uca tenna: “Twařa-ya ad qadiɣ SIDI.” X uya tegga as Yahuda. Awarni man aya tessbedd tarwa. ");
INSERT INTO rifl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Umi teẓra Raḥil belli war dd-tiruw i Yaɛqub, tusem zeg učmas, tenna i Yaɛqub: “Ewc ayi tarwa! Mařa war teqbiřed, xenni ad mmteɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ixeyyeq Yaɛqub x Raḥil, inna: “Ma aqa ayi necc deg wemcan n AREBBI, wenni xam iṭṭfen řɣiǧet n uɛeddis nnem?” ");
INSERT INTO rifl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tenna: “Aqa da tayya inu Bilha. Adef xas, ḥima ad dd-taruw x ifadden inu maḥend uřa d necc ad ɣari tiři tarrawt zzayes.” ");
INSERT INTO rifl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tewca as Bilha, tayya nnes, d tamɣart uca yudef xas Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Teksi Bilha s ddeyset uca turuw-dd aḥenjir i Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tenna Raḥil: “Iwca ayi AREBBI tasɣart uca isřa ɛawed ɣari. Iwca ayi mmi.” X uya tegga as Dan. ");
INSERT INTO rifl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Teksi Bilha, tayya n Raḥil, twařa nneɣni s ddeyset uca turuw-dd i Yaɛqub aḥenjir wiss tnayen. ");
INSERT INTO rifl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tenna Raḥil: “S imenɣan n AREBBI menɣeɣ ak-d učma uca ɣeřbeɣ.” Tegga as Naftali. ");
INSERT INTO rifl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Umi teẓra Liya tessbedd tarwa, teksi Zilpa, tayya nnes, tewca i-tt i Yaɛqub d tamɣart, ");
INSERT INTO rifl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","uca Zilpa, tayya n Liya, turuw-dd aḥenjir i Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Tenna Liya: “Mana řxir-a!” uca tegga as Jad. ");
INSERT INTO rifl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Uca turuw-dd Zilpa, tayya n Liya, aḥenjir wiss tnayen i Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Uca tenna Liya: “A sseɛd inu!”, minzi tibřiɣin ad ayi ḥesbent d sseɛd!” Uca tegga as Acir. ");
INSERT INTO rifl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Deg wussan n tmeyra n irden iffeɣ Rubin uca yufa ‘titeffaḥin n tayri’ deg iyyar uca netta yiwy i-tent i Liya, yemmas. Xenni tenna Raḥil i Liya: “Ttzawgeɣ cem ad ayi tewced zi ‘tteffaḥin n tayri’ n mmim.” ");
INSERT INTO rifl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Maca Liya tenna as: “Ma war iǧi drus ařami tiwyed aryaz inu, umi texsed ɛawed ad dd-tawyed ‘titeffaḥin n tayri’ n mmi?” Tenna Raḥil: “S uya ad iṭṭeṣ akidem ǧiřet-a x ‘tteffaḥin n tayri’ n mmim.” ");
INSERT INTO rifl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Umi dd-iɛqeb Yaɛqub zeg iyyar s tmeddit, teffeɣ-dd Liya ɣares tenna as: “Ad xafi tadfed, minzi nican criɣ cek s ‘tteffaḥin n tayri’ n mmi.” Uca ammu i iṭṭeṣ akides ǧiret nni. ");
INSERT INTO rifl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Isřa AREBBI i Liya uca teksi s ddeyset uca turuw-dd aḥenjir wiss xemsa i Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tenna Liya: “AREBBI iwca ayi řmunet inu x umi wciɣ tayya inu i weryaz inu!” Uca tegga as Issakar. ");
INSERT INTO rifl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Teksi Liya ɛawed s ddeyset uca turuw-dd aḥenjir wiss setta i Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Uca tenna Liya: “AREBBI iwca ayi ict n lbaraka tecna. Řexxu ad kidi izdeɣ weryaz inu, minzi urweɣ as-dd setta n iḥenjiren.” Uca tegga as Zabulun. ");
INSERT INTO rifl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Awarni as turuw-dd taḥenjirt. Tegga as Dina. ");
INSERT INTO rifl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Xenni idar AREBBI Raḥil uca isřa as AREBBI uca yarzem řemřawřet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Teksi s ddeyset uca turuw-dd aḥenjir, tenna: “Ikkes AREBBI řḥegra inu!” ");
INSERT INTO rifl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Uca tegga as Yusuf, tenna: “Ad ayi yarni SIDI aḥenjir nneɣni.” ");
INSERT INTO rifl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Řami dd-turuw Raḥil Yusuf, inna Yaɛqub i Laban: “Sekk ayi uca ad raḥeɣ ɣar dcar inu d temmurt inu. ");
INSERT INTO rifl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ewc ayi timɣarin inu d iḥenjiren inu min zi ɣarek xedmeɣ. Xenni ad ffɣeɣ. Aqa cek tessned řxedmet i zi tuɣa d ac ttsexxareɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Inna as Laban: “Mři ufiɣ řexxu arḍa di tiṭṭawin nnec. Aqa ẓriɣ s ijj n řeɛjeb belli SIDI ibarek ayi di ṭṭweɛ nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Yarni inna: “Ini ayi zeɛma man řmunet i texsed, uca ad ac tt wceɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Xenni inna as: “Cek tessned mammec d ac xedmeɣ d mammec uyureɣ ak-d řebhayem nnec zeg wami kic ǧiɣ. ");
INSERT INTO rifl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Minzi drust i tuɣa ɣarek řexdenni qbeř i dd-usiɣ, aqa idweř deg waṭṭas, uca ibarek i cek SIDI deg iṣuraf inu. Xenni řexxu, meřmi zemmareɣ ad xedmeɣ i taddart inu?” ");
INSERT INTO rifl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Inna as: “Min d ac i ɣa wceɣ?” Yarra-dd Yaɛqub: “War d ayi ttic walu, maca samḥ ayi aya waha, xenni ad dd-dewřeɣ ad arewseɣ uǧi nnec ɛawed uca ad ten ḥḍiɣ. ");
INSERT INTO rifl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ass-a ad ɛduɣ x marra taḥimart n wuǧi nnec. Egg cek x uɣezdis zzayes marra uǧi ibeqqḍen d iqarqacen, marra uǧi abarcan jar iḥuřiyyen d min iǧan d aqarqac niɣ s ibeqqiḍen jar iɣayḍen. Man aya ad yiři d řmunet inu. ");
INSERT INTO rifl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Xmi dd ɣa tased deg ijj n wass n yimař maḥens ad tẓared řmunet inu, ad tban tsegda inu zzat i wudem nnec ammu nican: min war iǧin ibeqqeḍ niɣ min war iǧin iqqarqec jar iɣayḍen d min war iǧin d abarcan jar iḥuřiyyen, aqa ad ittwaḥseb ittwacar jar min iǧan inu.” ");
INSERT INTO rifl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Xenni inna Laban: “Xzar, aqa ad yiři am mammec i d ayi tennid!” ");
INSERT INTO rifl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Deg wass nni ifarq iwetman n iɣayḍen icarḍen d iqarqacen uřa d marra tiɣayḍtin ibeqqḍen d iqarqacen, d marra inni di teǧa temřeř, uřa d marra min iǧan d abarcan jar iḥuřiyyen, uca issars i-ten deg ufus n iḥenjiren nnes. ");
INSERT INTO rifl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Xenni igga třata n wussan n webrid jar ixef nnes d Yaɛqub. Uca yarwes Yaɛqub uǧi iqqimen n Laban. ");
INSERT INTO rifl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Xenni iksi Yaɛqub tiseḍwin n ṣṣefṣaf u zi tcejjart n ǧuz u zi tcejjart n dulb. Netta iqeccar i-tent d iceṭṭiḍen d icemřařen umi iɛarra x ucemřař n tseḍwin. ");
INSERT INTO rifl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Issars tiseḍwin-a iqeccaren qibač i wuǧi di taryiwin d řeqwareb mani dd-usin wuǧi maḥend ad swent uca dewřent ttweḥḥament xmi dd-tasent ad wardent. ");
INSERT INTO rifl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Xmi i ɣa iweḥḥem wuǧi ɣar tseḍwin, urwent-i-dd tɣarṭin min icarḍen d min ibeqqḍen d min iqarqacen. ");
INSERT INTO rifl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Xenni tuɣa ibeṭṭa Yaɛqub iḥuřiyyen uca yarra uǧi s uzeǧif nsen ɣar min icarḍen d min iǧan d abarcan jar wuǧi n Laban. Uca igga tiḥimriwin nnes ɣar uɣezdis, war tent iggi ak-d wuǧi n Laban. ");
INSERT INTO rifl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kuř amuř xmi ttweḥḥament tinni ijehden zeg wuǧi, ittegg Yaɛqub tiseḍwin qibač i wuǧi di taryiwin, ḥima ad weḥḥment ɣar tseḍwin. ");
INSERT INTO rifl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Maca war tent issars ca ak-d tenni iḍeɛfen jar wuǧi. Ammu tuɣa tinni iḍeɛfen i Laban u tinni ijehden i Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Uca imɣar wagřa n weryaz-a břa qeṭṭu. Tuɣa ɣares aṭṭas n wuǧi d tiyya d isemɣan d iřeɣman d yeɣyař. ");
INSERT INTO rifl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Uca isřa Yaɛqub awařen n iḥenjiren n Laban, nnan: “Yaɛqub iksi marra min tuɣa n babatneɣ u s min tuɣa n babatneɣ aqa ikseb marra aɛuǧi-ya.” ");
INSERT INTO rifl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ixzar Yaɛqub ɣar uɣembub n Laban. Xzar, war kides iǧi am iḍennaḍ d fariḍennaḍ. ");
INSERT INTO rifl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Inna SIDI i Yaɛqub: “Dweř ɣar temmurt n řejdud nnec u ɣar řaǧ nnec. Aqa Necc ad iřiɣ akidek.” ");
INSERT INTO rifl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Isekk Yaɛqub uca iřaɣa-dd x Raḥil d Liya ɣar yeyyar, ɣar wuǧi nnes. ");
INSERT INTO rifl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Inna asent: “Ttwařiɣ belli aɣembub n babatkent war kidi iǧi am iḍennaḍ d fariḍennaḍ. Maca AREBBI n řejdud inu aqa-t akidi. ");
INSERT INTO rifl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kennint tessnent belli aqa xedmeɣ i babatkent s marra min ɣari d jjehd. ");
INSERT INTO rifl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Maca babatkent iɣecc ayi, ibeddeř řmunet inu ɛecra n twařawin, maca AREBBI war d as isemmeḥ ḥima ad ayi igg řɣar. ");
INSERT INTO rifl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mařa netta inna: ‘Ibeqqiḍen ad iřin d řmunet nnec!’, řexdenni marra uǧi urwent-i-dd uǧi s ibeqqiḍen, mařa inna: ‘Inni s icariḍen ad iřin d řmunet nnec!’, řexdenni marra uǧi urwent-i-dd uǧi s icariḍen. ");
INSERT INTO rifl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ammu ikkes AREBBI řebhayem n babatkent uca iwca ayi tent i necc. ");
INSERT INTO rifl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Imsar ɣar řweqt umi weḥḥment uǧi, ssgeɛɛdeɣ tamuɣři inu uca ẓriɣ di tarjit, aqa da iɣayḍen nni ineggzen x wuǧi, tuɣa aten s icariḍen d ibeqqiḍen d iqarqacen. ");
INSERT INTO rifl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Inna ayi lmalak n AREBBI di tarjit ‘Yaɛqub!’ Necc nniɣ ‘Aqa ayi da!’ ");
INSERT INTO rifl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Inna: ‘Nḍar tiṭṭawin nnec, xzar, marra iɣayḍen, inni ineggzen x wuǧi, aqa aten s icariḍen d ibeqqiḍen d iqarqacen, minzi Necc ẓriɣ marra min d ac ittegg Laban. ");
INSERT INTO rifl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Necc d Arebbi n Bayt-Il, mani tdehned aẓru n řidaret u mani d ayi tewcid awař. Kkar řexxu, ffeɣ zi temmurt-a, ɛqeb ɣar temmurt mani txeřqed.’” ");
INSERT INTO rifl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Xenni arrint-i-dd Raḥil d Liya, nnant as: “Ma din ɛad ca n tesɣart niɣ ict n řwart i neccin di taddart n babatneɣ? ");
INSERT INTO rifl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ma war nettwiḥsib am tbarraniyyin? Aqa netta izzenz aneɣ u netta aqa iqeṭṭa marra nnuqart nneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Minzi marra agřa nni ikkes AREBBI i babatneɣ, nneɣ i iǧa u n iḥenjiren nneɣ. Řexxu ɛad, egg marra min d ac inna AREBBI.” ");
INSERT INTO rifl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Xenni ikkar Yaɛqub uca issgeɛɛed iḥenjiren nnes d temɣarin nnes x iřeɣman. ");
INSERT INTO rifl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Igga deg webrid marra řebhayem nnes d marra agřa nnes nni dd-ikseb, aqa řebhayem nni iṭṭef, inni dd-ikseb di Fadan-Aram, ḥima ad dd-iɛqeb ɣar Isḥaq, babas, di temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Umi iruḥ Laban ɣar tiřsa n wuǧi nnes, tucar Raḥil řexyařat timeẓyanin n l’aṣnam n babas. ");
INSERT INTO rifl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaɛqub ixdeɛ Laban, Aramiyu, řami war d as iɛřim aqa ad yarweř. ");
INSERT INTO rifl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yarweř s marra min ɣares. Ikkar, iẓwa iɣzar n Lfuraṭ uca yarra azeǧif nnes ɣar idurar n Jilɛad. ");
INSERT INTO rifl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Deg wass wiss třata xebbaren Laban, aqa yarweř Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Xenni yiwi aytmas akides, iruḥ awarni as ticři n sebɛa n wussan, ixecc xas deg idurar n Jilɛad. ");
INSERT INTO rifl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Uca yusa-dd AREBBI ɣar Laban, Aramiyu, di tarjit di ǧiret, inna as: “Ɣarek ad tessiwřed s řxar niɣ s řɣar ak-d Yaɛqub.” ");
INSERT INTO rifl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ireḥḥeg xenni Laban x Yaɛqub. Yaɛqub tuɣa iwta aqiḍun nnes deg idurar. Laban ɛawed iwta iqiḍan nnes ak-d aytmas deg idurar n Jilɛad. ");
INSERT INTO rifl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Xenni inna Laban i Yaɛqub: “Min teggid, teẓwid ayi uř uca tiwyid-dd yessi am tmeḥbas n garra? ");
INSERT INTO rifl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mayemmi tarewřed s tnuffra u tucared ayi u mayemmi war d ayi txebbared, ḥima ad cek ssqebbḍeɣ s řefraḥet, s řeɣnuj, s ubendir u s řgambri? ");
INSERT INTO rifl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","War d ayi tejjid ad ssudmeɣ iḥenjiren inu d tḥenjirin inu. Řexxu d tubbuheřya i teggid. ");
INSERT INTO rifl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ɣari tizemmar deg ifassen inu, ḥima ad cek ḍarreɣ, maca AREBBI n babatwem issiweř akidi ǧiret-a, inna: ‘Ɣarek ad tessiwřed s řxar niɣ s řɣar ak-d Yaɛqub.’ ");
INSERT INTO rifl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Uca řexxu tuyured, umi zeɛma tweḥḥced taddart n babac. Maca maɣar i d ayi tucared irebbiten inu?” ");
INSERT INTO rifl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yarra-dd Yaɛqub, inna i Laban: “Minzi tuɣa ggʷedeɣ, nniɣ ak-d yixef inu ad taɣ ad ayi tekksed yessic s uɣiř! ");
INSERT INTO rifl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ɣar wenni i ɣa tafed l’aṣnam nnec, ejj i-t war iddar ɛad! Qibač i wawmaten nneɣ ad tmeyyzed min iǧan nnec jar min iǧan ɣari uca awyi t akidek.” Maɣar Yaɛqub war issin belli Raḥil i ten yucaren. ");
INSERT INTO rifl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Uca yudef Laban ɣar uqiḍun n Yaɛqub, ɣar uqiḍun n Liya, ɣar uqiḍun n tnayen n tiyya uca war yufi walu. Řami dd-iffeɣ zeg uqiḍun n Liya, yudef ɣar uqiḍun n Raḥil. ");
INSERT INTO rifl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Maca teksi Raḥil řexyařat timeẓyanin n l’aṣnam, tegga i-tent deg iɣaynen n weřɣem uca teqqim xasen. Yarzu Laban deg uqiḍun am ikmeř, maca war yufi walu. ");
INSERT INTO rifl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tenna i babas: “War ittiři aya d řɣar di tiṭṭawin n sidi inu, minzi war zemmareɣ ad kkareɣ qibač nnec, maɣar aqa ayi s tnamit n temɣarin.” Uca yarzu, maca war yufi řexyařat timeẓyanin n l’aṣnam. ");
INSERT INTO rifl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Xenni ixeyyeq Yaɛqub uca imcubbec ak-d Laban. Yaɛqub iṭṭef deg wawař, inna i Laban: “Mani iǧa uxeṭṭu inu? Man wen iǧan d ddenb inu, umi d ayi dd-teḍfared s zzɛaf? ");
INSERT INTO rifl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Cek tbeqced marra řqecc inu. Min tufid zi marra řeḥwayej n taddart nnec? Egg i-t da zzat n yaytma d aytmac uca ejj i-ten ad ḥekmen jar aneɣ s tnayen. ");
INSERT INTO rifl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ɛicrin n iseggʷusa i kik kkiɣ. Tixeswin nnec d tɣayḍin nnec ɛemmarṣ ssutment niɣ ɛemmarṣ cciɣ icarriyen n wuǧi nnec. ");
INSERT INTO rifl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","War d ac iwyeɣ min ittwamezzqen, maca xeṭṣeɣ t simant inu. Min ittwacaren zzayi deg wass niɣ di ǧiret, aqa zeg ifassen inu tᵉttared t. ");
INSERT INTO rifl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","S uziř ittett ayi řeḥmu yuẓɣen tiřmect u s ǧiret ttejmideɣ zi sqiɛ, ařami yarweř iḍeṣ zi ɣari. ");
INSERT INTO rifl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ammu i d ayi tuɣa di taddart nnec ɛicrin n iseggʷusa. Xedmeɣ ɣarek arbeɛṭac n iseggʷusa x tnayen n yessic d setta n iseggʷusa x wuǧi uca tbeddřed řmunet inu ɛecra n twařawin. ");
INSERT INTO rifl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mařa AREBBI n baba, AREBBI n Ibrahim d tiggʷudi n Isḥaq, iři war kidi iǧi, d ṣṣeḥ iři ad ayi tessqaded řexxu s ifassen xwan! Iẓra AREBBI tamara d tumar n ifassen inu uca ideqmar i cek ǧiřet n iḍennaḍ.” ");
INSERT INTO rifl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yarra-dd Laban uca inna i Yaɛqub: “Tiḥenjirin-a d yessi u iḥenjiren-a d iḥenjiren inu, u uǧi-ya d uǧi inu, u marra min tᵉttwařid aqa inu. Min zemmareɣ xenni ad ggeɣ řexxu s yessi niɣ s iḥenjiren nsent nni urwent? ");
INSERT INTO rifl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ɣawer ɛad řexxu, ad negg ijj n řɛahd, necc d cek, ad yiři Netta d cchadet jar ayi d cek!” ");
INSERT INTO rifl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Uca iksi Yaɛqub aẓru, issgeɛɛed i-t am weẓru n řidaret. ");
INSERT INTO rifl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Uca inna Yaɛqub i yaytmas: “Smunem iẓra!” Ksin iẓra uca ggin taɛurrict uca ccin din x tɛurrict nni. ");
INSERT INTO rifl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Uca igga Laban i uɛurric n iẓra nni ‘Jigar-Sahaduta’, maca Yaɛqub igga as ‘Jilɛad’. ");
INSERT INTO rifl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Xenni inna Laban: “Taɛurrict-a ad tiři d cchadet ass-a jar ayi d cek!” X uya tegga as Jilɛad ");
INSERT INTO rifl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","d Miṣfa, minzi netta inna: “Iři SIDI ad iḥḍa jar ayi d cek, xmi ɣa niři am nᵉnuffar ijjen zeg wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Mařa tesseḥqared yessi niɣ ad tmeřced timɣarin nneɣni x yessi, am war din iǧi ḥed akidneɣ ḥima ad yiři d acehhad, aqa AREBBI ad yiři d acehhad jar ayi d cek!” ");
INSERT INTO rifl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Inna ɛawed Laban i Yaɛqub: “Xzar, taɛurrict-a n yeẓra, xzar, aẓru n řidaret nni ssbeddeɣ jar ayi d cek. ");
INSERT INTO rifl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Taɛurrict-a n yeẓra d weẓru-ya n řidaret ad cehden belli necc war ɣarek dd-ẓekkʷiɣ ca x tɛurrict-a uca uřa d cek war ɣari dd-tẓekkʷwid ca i řɣar x tɛurrict-a uřa x weẓru-ya n řidaret! ");
INSERT INTO rifl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","AREBBI n Ibrahim d AREBBI n Naḥur, aqa AREBBI n babatsen, ejj i-t ad iḥkem jar aneɣ!” Maca Yaɛqub ijjuǧ s ‘Tiggʷudi n Isḥaq babas’. ");
INSERT INTO rifl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Xenni iɣarṣ Yaɛqub i yict n tɣarṣt deg idurar uca iřaɣa i yaytmas ad ccen aɣrum. Uca ccin aɣrum, senssen ǧiret nni deg idurar. ");
INSERT INTO rifl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ikkar Laban ɣar tuffut n ṣṣbeḥ, issudem iḥenjiren nnes d yessis, ibark i-ten. Xenni iruḥ Laban, iɛqeb ɣar wemcan nnes. ");
INSERT INTO rifl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Uca iṭṭef Yaɛqub ɛawed abrid nnes uca usint-i-dd lmalakat n AREBBI, řqant t-i-dd. ");
INSERT INTO rifl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Inna Yaɛqub umi ten iẓra: “Řmargeḥ n řɛeskar n AREBBI d wa!”, uca iřaɣa isem n wemcan nni Maḥanayim. ");
INSERT INTO rifl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Issekk Yaɛqub ireqqasen ɣar zzat, ɣar Ɛisu umas ɣar temmurt n Saɛir, aqa-tt d jjihet n Idum. ");
INSERT INTO rifl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Uca iweṣṣa i-ten, inna asen: “Ammu i ɣa tinim i sidi inu Ɛisu: ‘Ammu i iqqar umsexxar nnec Yaɛqub: Tuɣa zeddɣeɣ ak-d Laban am ubarrani uca qqimeɣ din ař i řexxu. ");
INSERT INTO rifl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ɣari ifunasen d yeɣyař d wuǧi d isemɣan d tiyya uca ssekkeɣ ireqqasen, maḥend ad t iniɣ i sidi inu, maḥend ad afeɣ arḍa di tiṭṭawin nnec.’” ");
INSERT INTO rifl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ireqqasen dewřen-dd ɣar Yaɛqub, nnan: “Nruḥ ɣar umac Ɛisu, u netta ɛawed yusa-dd ad cek iřqa u aqa din arebɛa-mya n yeryazen akides.” ");
INSERT INTO rifl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Xenni Yaɛqub tudef i-t tiggʷudi temɣar uca issqenḍ i-t řḥař. Netta ibḍa iwdan, inni akides d wuǧi d ifunasen d tfunasin d iřeɣman x tnayen n řemrageḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Inna: “Mařa yusa-dd Ɛisu ɣar ijj n řmargeḥ n řɛeskar, ad xas iɣřeb, xenni ad yarweř řmargeḥ n řɛeskar i iqqimen.” ");
INSERT INTO rifl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Uca inna Yaɛqub: “A AREBBI n baba Ibrahim d AREBBI n baba Isḥaq, a SIDI, Cek wenni d ayi innan: ‘Dweř ɣar temmurt nnec d raǧ nnec uca Necc ad ac ggeɣ min icnan!’ ");
INSERT INTO rifl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Aqa ayi qell x marra timegga n tmexsiwt icewwaren d marra řaman i tessecned i umsexxar nnec, minzi ẓwiɣ L’Urdun s teɣɣarct inu řami dd-ffɣeɣ uca řexxu dewřeɣ-dd d tnayen n řemrageḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Fekk ayi řexxu zeg ufus n Ɛisu uma, minzi tteggʷedeɣ balak ad dd-yas uca ad ineɣ uřa d tiyemmatin ak-d iḥenjiren! ");
INSERT INTO rifl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Uca Cek tennid: ‘Necc ad kik ggeɣ mliḥ, ad ggeɣ zzariɛet nnec am yijdi n řebḥar i war izemmar ad ittwaḥseb zi ssibbet n ubarru nnes!’” ");
INSERT INTO rifl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Issens din ǧiřet nni uca iksi zi min dd-yusin deg ifassen nnes d agřa, maḥend ad t yewc d arriɣalu i umas Ɛisu: ");
INSERT INTO rifl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","mitayen n tɣayḍin d ɛicrin n imuyan d mitayen n txeswin d ɛicrin n icarriyyen ");
INSERT INTO rifl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","d třatin n třeɣmin issuṭṭuḍen ak-d tarwa nsent, arebɛin n tfunasin timeẓyanin, ɛecra n ifunasen imeẓyanen d ɛicrin n teɣyař d ɛecra n yeɣyař imeẓyanin. ");
INSERT INTO rifl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Isseɛdu ten ɣar ifassen n imsexxaren nnes, kuř taḥimart weḥḥdes, uca inna i imsexxaren nnes: “Ɛdum kenniw řexxu zzat inu, ggem ttasiɛ jar tḥimart d tḥimart.” ");
INSERT INTO rifl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Xenni yumur umezwar, inna as: “Mařa yusa-dd Ɛisu i umsagar akidek uca isseqsa ac, inna: ‘Wi cek yiřan d mani ɣa traḥed?’ u ‘Umi tina i iǧan zzatek?’, ");
INSERT INTO rifl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","řexdenni ad tinid: ‘D arriɣalu i yeǧa n umsexxar nnec Yaɛqub, wenni dd-issekk i sidi inu Ɛisu. Xzar, netta ɛawed yusa-dd awarni aneɣ!’” ");
INSERT INTO rifl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yumur ɛawed wenni wiss tnayen d wiss třata inni igguren awarni i tḥimriwin, inna: “Siwřem awařen-a d ijjen ak-d Ɛisu, xmi t ɣa teřqam. ");
INSERT INTO rifl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kenniw ɛawed ad tinim: ‘Xzar, amsexxar nnec Yaɛqub yusa-dd awarni aneɣ!’” Minzi inna: “Ad t ssareyyḥeɣ s arriɣalu-ya i dd-yusin zzat inu. Xenni awarni man aya ad ẓareɣ aɣembub nnes, balak ad iqbeř aɣembub inu zzates.” ");
INSERT INTO rifl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ammu i issizzar arriɣalu zzates ɣar ujemmaḍ am issens netta ǧiret nni di řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ikkar ǧiřet nni uca iksi tnayen n temɣarin nnes d tnayen n tiyya nnes d ḥiṭac n iḥenjiren nnes, iẓwa amcan n uẓekkwu n yeɣzar n Yabbuq. ");
INSERT INTO rifl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yiwyi i-ten uca isseẓwa ten i teɣzurt u marra min ɣares isseɛdu t ɣar ujemmaḍ. ");
INSERT INTO rifl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Maca iqqim Yaɛqub weḥḥdes u netta immuɣzeř ak-d ijj n Weryaz ařmi d tuffut n řefjar. ");
INSERT INTO rifl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Umi iẓra Wanita aqa war xas iqedd ca, iḥada t ɣar wemcan n temqiqqect n tmeṣṣaḍt nnes, maḥend ad dd-tenxuxer tamqiqqect n tmeṣṣaḍt n Yaɛqub umi kides tuɣa ittmuɣzuř. ");
INSERT INTO rifl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Inna: “Ejj ayi ad raḥeɣ, aqa iṣbeḥ řḥař.” Maca netta inna: “War Cek ttejjiɣ, mɣir mařa tbarked ayi.” ");
INSERT INTO rifl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Uca Netta inna as: “Mammec d ac qqaren?” Yarra-dd xas: “Yaɛqub.” ");
INSERT INTO rifl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Xenni inna as: “War d ac qqaren ɛad Yaɛqub, maca Israil, minzi temmenɣed ak-d AREBBI d iwdan, uca cek tɣeřbed.”    ");
INSERT INTO rifl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Isseqsa Yaɛqub xenni, inna: “Ini ayi řexxu Isem nnec!” Yarra-dd xas: “Maɣar tesseqsid x Yisem inu?” Uca ibark i-t din. ");
INSERT INTO rifl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Uca isemma Yaɛqub amcan nni Fanuwil, inna: “Minzi ẓriɣ AREBBI aɣembub deg uɣembub uca injem řeɛmar inu.” ");
INSERT INTO rifl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tenqar-dd xas tfuct umi tuɣa iɛdu x Fanuwil, uca yuyur ittzeḥḥef zi tmeṣṣaḍt nnes. ");
INSERT INTO rifl_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","X uya war ttᵉtten ayt n Israil ař ass-a zeg weẓwar igdaren i ittekken x temqiqqect n tmeṣṣaḍt, minzi iḥada tameṣṣaḍt n Yaɛqub ɣar mani iǧa weẓwar igdaren. ");
INSERT INTO rifl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Issgeɛɛed Yaɛqub tamuɣři nnes uca iẓra Ɛisu d arebɛa-mya n yeryazen akides xeccen-dd. Ifarq Yaɛqub iḥenjiren x Liya d Raḥil d tnayen n tiyya. ");
INSERT INTO rifl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Igga tiyya d tarwa nsent ɣar zzat, awarni asent Liya d tarwa nnes u Raḥil d Yusuf d ineggura. ");
INSERT INTO rifl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Umi iɛdu zzat i tiṭṭawin nsen, ibendeq ɣar temmurt sebɛa n twařawin ařami dd-yiweḍ ɣar umas. ");
INSERT INTO rifl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ɛisu yuzzeř-dd ḥima ad t iřqa, idarreɛ as, ingez as x yiri nnes, issudem i-t uca run s tnayen. ");
INSERT INTO rifl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Xas uca issgeɛɛed tiṭṭawin nnes, iẓra timɣarin d iḥenjiren nni uca inna: “Min ɛnan ina inni akidek?” Netta yarra-dd xas: “D tarwa nni iwca AREBBI zeg arḍa nnes i umsexxar nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Uca reḥḥgent-i-dd tiyya, nitenti d tarwa nsent, uca bendqent. ");
INSERT INTO rifl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Treḥḥeg-dd ɛawed Liya d iḥenjiren nnes uca bendqen. Řexdenni iqarreb-dd Yusuf d Raḥil uca bendqen. ");
INSERT INTO rifl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Inna as: “Min texsed ak-d ubarru-ya n řɛeskar nni řqiɣ?” Netta inna: “Necc ssekkeɣ t, maḥend ad afeɣ arḍa di tiṭṭawin n sidi inu!” ");
INSERT INTO rifl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Inna Ɛisu: “Aqa ɣari aṭṭas, uma inu! Ad yiři i cek min iǧan nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Xas uca inna Yaɛqub: “Lla, ttzawageɣ cek! Mařa ufiɣ řexxu arḍa di tiṭṭawin nnec, ksi arriɣalu inu zeg ifassen inu, maɣar ẓriɣ udem nnec axmi ẓriɣ udem n AREBBI uca tqebřed xafi s řemřaḥet. ");
INSERT INTO rifl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ttzawgeɣ cek, ksi lbaraka inu i d ac dd-iwyeɣ, minzi AREBBI imṣurruf akidi s arḍa uca necc ɣari kuřci.” Ikellef i-t uca iksi t. ");
INSERT INTO rifl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Netta inna: “Ejj aneɣ ad nefsi iqiḍan nneɣ, ad nraḥ. Necc ad raḥeɣ zzatec.” ");
INSERT INTO rifl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Maca netta inna as: “Sidi inu issen, aqa iḥenjiren-a arehfen u aqa ɣari uǧi d tfunasin urwent ssuṭṭuḍent. Mařa bnadem izeyyar xasent aṭṭas, waxxa mɣir i yijj n wass, ad immet wuǧi marra. ");
INSERT INTO rifl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ad iɛdu řexxu sidi inu zzat i uɣembub n umsexxar nnes u necc ad dd-aseɣ cwayt cwayt ak-d iṣuraf n řeksibet i iǧan zzati uřa ak-d iṣuraf n iḥenjiren, ař dd ɣa awḍeɣ ɣar sidi inu di Saɛir.” ");
INSERT INTO rifl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Inna Ɛisu: “Ad jjeɣ řexxu akidek ca n iwdan inni iǧan akidi.” Maca netta inna: “Umi ddegga? Ejj ayi ad afeɣ arḍa di tiṭṭawin n sidi inu!” ");
INSERT INTO rifl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Iɛqeb-dd Ɛisu deg wass nni x webrid ɣar Saɛir. ");
INSERT INTO rifl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Uca ifsi Yaɛqub iqiḍan nnes, yuyur ɣar Sukkut, ibna din taddart i yixef nnes uca igga iɛuccuten n tseṭṭa i řebhayem nnes. X uya iřaɣa isem n wemcan nni Sukkut, ixs ad yini ‘Iɛuccuten’. ");
INSERT INTO rifl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Umi dd-iɛqeb Yaɛqub zi Fadan-Aram, yusa-dd ɣar Calim, ict n tendint n Cakim, tenni iǧan di temmurt n Kenɛan, uca iwta iqiḍan nnes zzat i tendint. ");
INSERT INTO rifl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Isɣa ṭṭarf n yeyyar mani iwta iqiḍan nnes, zeg ifassen n iḥenjiren n Ḥamur, babas n Cakim, s mya n iziynat n nnuqart iweznen. ");
INSERT INTO rifl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Issgeɛɛed din ijj n uɛalṭar min xef temmars tɣarṣt uca iřaɣa as: ‘Arebbi d AREBBI n Israil!’ ");
INSERT INTO rifl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, yeǧis n Liya, tenni dd-turuw i Yaɛqub, teffeɣ, ḥima ad temmeřqa ak-d yessis n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Cakim, mmis n Ḥamur Aḥiwi, řḥakem n temmurt nni, iẓra i-tt, iksi tt uca iṭṭeṣ akides, issexsar i-tt. ");
INSERT INTO rifl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Iṭṭarbeṭ di Dina, yeǧis n Yaɛqub, u netta ixs tabřiɣt uca issiweř ɣar wuř n tebřiɣt. ");
INSERT INTO rifl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Issiweř Cakim ɣar Ḥamur babas, inna as: “Awyi ayi-dd tabřiɣt-a d tamɣart.” ");
INSERT INTO rifl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Řami isřa Yaɛqub belli Cakim iḍeyyeɛ ccaraf n yeǧis Dina, tuɣa iḥenjiren nnes ak-d řebhayem deg iyyar. Issusem Yaɛqub ařami dd-ɛeqben nitni. ");
INSERT INTO rifl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Iruḥ Ḥamur, babas n Cakim ɣar Yaɛqub, ḥima ad kis issiweř. ");
INSERT INTO rifl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tarwa n Yaɛqub dewřen-dd zeg iyyar uca areggben x řexbar. Xeyyqen x man aya deg wuř u ffugmen aṭṭas, minzi igga řefḍiḥet-a di Israil umi iṭṭeṣ ak-d yeǧis n Yaɛqub. man aya war icuwwar ad t yegg. ");
INSERT INTO rifl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Issiweř Ḥamur akidsen, inna: “Řeɛmar n mmi Cakim iqqen ɣar yeǧitwem, ttzawageɣ, ad as tt tewcem d tamɣart, ");
INSERT INTO rifl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","uca ad nemḍeggwař. Ad aneɣ tewcem yeǧitwem, kenniw ad teksim yessitneɣ i yixef nwem. ");
INSERT INTO rifl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Zedɣem akidneɣ, minzi tammurt aqa-tt zzatwem. Zedɣem u uyurem dayes uca ṭṭfem dayes agřa i kenniw.” ");
INSERT INTO rifl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Uca inna Cakim ɛawed i babas d aytmas: “Ejj ayi ad afeɣ arḍa di tiṭṭawin nwem uca ad wceɣ min d ayi ɣa tinim. ");
INSERT INTO rifl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Waxxa ad tessḍeqřem xafi řeḥmeř aṭṭas n ṣṣadaq d ssunan, aqa necc ad wceɣ mecḥař ma d ayi ɣa tinim. Wcem ayi mɣir tabřiɣt d tamɣart.” ");
INSERT INTO rifl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Arrin-dd iḥenjiren n Yaɛqub x Cakim d Ḥamur, babas, s ict n teḥraymect, minzi aqa issexsar Dina, učmatsen. ");
INSERT INTO rifl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Nitni ssiwřen, nnan asen: “War nzemmar ad negg ammu, ad newc učmatneɣ i weryaz nni ɛad s řeɛdařyet. Degga d řɛar xaneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mɣir s umtawi-ya waha ad kenniw nseɛɛef, mařa teggim am neccin, ad tᵉttwaxetnem marra iwetman nwem. ");
INSERT INTO rifl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Xenni ad awem newc yeǧitneɣ uca ad neksi yessitwem, ad kidwen nezdeɣ, ad niři d ijj n řgens. ");
INSERT INTO rifl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Maca mařa war d aneɣ tesřim di tmesřact n wextan, xenni ad neksi yeǧitneɣ uca ad nuyur.” ");
INSERT INTO rifl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Banen wawařen nsen mliḥ deg imezzuɣen n Ḥamur u deg imejjan n Cakim, mmis n Ḥamur. ");
INSERT INTO rifl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Aɛezri war d as icqi ad igg man aya, minzi netta ittexs aṭṭas yeǧis n Yaɛqub u netta tuɣa-t qaɛ mweqqar di marra taddart n babas. ");
INSERT INTO rifl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Uca usin-dd Ḥamur d mmis Cakim ɣar tewwart n tendint nnes, ssiwřen ak-d yeryazen n tendint, nnan: ");
INSERT INTO rifl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Iryazen-a d imhudnen akidneɣ. Ejj aneɣ ad ten nejj ad zedɣen di temmurt-a uca ad dayes uyuren. Xzar, tammurt tewseɛ i nitni ɣar marra iɣezdisen nnes. Neccin ad neksi yessitsen d timɣarin, ad asen newc yessitneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Maca s umtawi-ya waha ad seɛɛfen yeryazen-a, ḥima ad kidneɣ zedɣen u ḥima ad dewřen d ijj n řgens akidneɣ, mařa marra iryazen i iǧan jar aneɣ ad ttwaxetnen am mammec ttwaxetnen nitni. ");
INSERT INTO rifl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Řebhayem nsen d agřa nsen d marra řmař nsen, ma war ttiřin nneɣ? Ejj aneɣ ad ten nseɛɛef, xenni ad zedɣen akidneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Marra inni dd-yusin ɣar tewwart n tendint nnes sřin i Ḥamur d mmis Cakim uca marra iryazen inni dd-yusin ɣar tewwart n tendint nnes, ttwaxetnen. ");
INSERT INTO rifl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Umi tuɣa ɛad daysen řehriq deg wass wiss třata, temsar belli iḥenjiren n Yaɛqub, Cimɛun d Lawi, aytmas n Dina, aqa kuř ijj zzaysen iksi ssif nnes uca ruḥen ɣar tendint mani d asen ittɣiř aqa dayes řaman uca nɣin marra iryazen. ");
INSERT INTO rifl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Nɣin Ḥamur d mmis Cakim s řeqḍeɛ n ssif uca ksin Dina zi taddart n Cakim, ffɣen. ");
INSERT INTO rifl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tarwa n Yaɛqub usin-dd ɣar yinni ittwanɣen uca keccḍen tandint, minzi nitni ssexsaren učmatsen. ");
INSERT INTO rifl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ksin uǧi nsen d ifunasen d tfunasin nsen d yeɣyař nsen d marra min tuɣa di tendint u deg iyyar. ");
INSERT INTO rifl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ksin marra agřa nnes uca iwyen-dd marra iḥenjiren d temɣarin nsen d imeḥbas uca ucaren marra min tuɣa di tudrin. ");
INSERT INTO rifl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Xenni inna Yaɛqub i Cimɛun d Lawi: “Kenniw tessidfem ayi deg imxumbar ařami d ayi tessarzgem ɣar imezdaɣ n temmurt-a, ɣar ayt n Kenɛan d Ifiriziyyen. D necc ɣari ijj n wuru n yeryazen waha. Mařa ad munen x uzeřmaḍ inu, ad ayi qeẓẓren, ad iřiɣ areyyteɣ, necc d taddart inu.” ");
INSERT INTO rifl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Nitni nnan: “Ma iɛeddeř xenni ad iḥseb učmatneɣ amecnaw ict n lfasda?” ");
INSERT INTO rifl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Uca inna AREBBI i Yaɛqub: “Kkar, geɛɛed ɣar Bayt-Il uca qqim din. Egg din ijj n uɛalṭar min xef i ɣa tessarsed taɣarṣt i Arebbi, wenni d ac dd-ibanen umi dd-tarewřed zeg uɣembub n umac Ɛisu.” ");
INSERT INTO rifl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Xenni inna Yaɛqub i řwacun n taddart nnes u i marra inni tuɣa akides: “Kksem irebbiten iɣriben nni iǧan jar awem, sizedgem ixef nwem uca beddřem arruḍ nwem. ");
INSERT INTO rifl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ad nekkar, ad ngeɛɛed ɣar Bayt-Il. Necc ad ggeɣ din ijj n uɛalṭar i Arebbi nni xafi dd-yarrin deg wass n řeḥṣaret inu, d wenni tuɣa akidi deg webrid nni uyureɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Uca wcin i Yaɛqub marra irebbiten iɣriben nni tuɣa ɣarsen uřa d tixrazin deg imezzuɣen nsen uca iffar i-ten Yaɛqub sadu tcejjart n yigg i tuɣa zzat i Cakim. ");
INSERT INTO rifl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Řami fesyen iqiḍan, uyuren ssenni, tuɣa tiggʷudi n AREBBI x tneddam nni tuɣa di jjwayeh i d asen dd-innḍen, ařami nitni war ḍeffaren iḥenjiren n Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ammu i yiweḍ Yaɛqub ɣar Luz di temmurt n Kenɛan, aqa-tt d Bayt-Il, netta d marra řgens i tuɣa akides. ");
INSERT INTO rifl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ibna din ijj n uɛalṭar uca iřaɣa i wemcan nni Il-Bayt-Il, minzi dinni i d as dd-iḍhar AREBBI, umi dd-yarweř zeg uɣembub n umas. ");
INSERT INTO rifl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Temmut Dibura, tamesseṭṭaḍt n Rifqa uca neḍřen tt swadday i Bayt-Il, sadu tabeǧuḍt uca iřaɣa isem nnes ‘Allun-Bakut’, aqa-tt d ‘tabeǧuḍt n imeṭṭawen’. ");
INSERT INTO rifl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iḍhar as-dd ɛawed AREBBI i Yaɛqub umi dd-idweř zi Fadan-Aram uca ibark i-t. ");
INSERT INTO rifl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Inna as AREBBI: “Isem nnec d Yaɛqub. Zi ssa d tsawent war tteggen ɛad isem nnec ‘Yaɛqub’, maca ‘Israil’, d wa i ɣa yiřin d isem nnec.” Uca isemma t Israil. ");
INSERT INTO rifl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Inna as AREBBI: “Necc d Arebbi, Amzemmar x kuřci! Egg řɣiǧet, mmarniy! Zzayek i ɣa iffeɣ ijj n řgens, wah, d ijj n wegraw n řegnus ad ffɣen zzayek u ijeǧiden ad ffɣen zi tejɛinna nnec. ");
INSERT INTO rifl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Uca tammurt-a i wciɣ i Ibrahim d Isḥaq, i cek umi tt i ɣa wceɣ uca uřa i zzariɛet nnec awarni ac ad wceɣ tammurt.” ");
INSERT INTO rifl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Xas uca igeɛɛed AREBBI sennej zeg wemcan mani kides issiweř. ");
INSERT INTO rifl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaɛqub issgeɛɛed ijj n weẓru n řidaret deg wemcan mani kis issiweř, ijj n weẓru n řidaret. Iseyyeb xas ict n tewhibt n useyyeb uca ifarreɣ zzect x uzeǧif nnes. ");
INSERT INTO rifl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Igga Yaɛqub isem n wemcan mani kides issiweř AREBBI ‘Bayt-Il!’ ");
INSERT INTO rifl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Fesyen nitni iqiḍan nsen, ffɣen zi Bayt-Il uca umi tuɣa tteggwijen mɣir cwayt x Ifrata, xenni turuw-dd Raḥil u teɛdu xas tarwa teqseḥ. ");
INSERT INTO rifl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Imsar, umi teɣɣuḍed di tarwa nnes, tenna as řqabřa: “War tteggʷed, aqa wa ɛawed ad yiři d mmim!” ");
INSERT INTO rifl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Řami teḍřeq i buḥbeř am temmut din, aqa třaɣa as Bin-Uni, isem-a ixs ad yini ‘mmis n řeḥriq inu’, maca babas iřaɣa as Binyamin, ixs ad yini ‘mmis n zzhar inu’. ");
INSERT INTO rifl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ammu i temmut Raḥil uca neḍřent tt deg webrid ɣar Ifrata, ixs ad yini Bayt-Laḥm. ");
INSERT INTO rifl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Uca igga Yaɛqub ijj n weẓru n řidaret x wenḍeř nnes. D wa d aẓru n řidaret n Raḥil x wenḍeř n Raḥil ař ass-a. ");
INSERT INTO rifl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Xas uca ifsi Israil iqiḍan uca iwta aqiḍun nnes x uɛeddu n Majdal-Ɛidr. ");
INSERT INTO rifl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Umi izdeɣ Israil di temmurt nni, imsar belli Rubin iruḥ iṭṭeṣ ak-d Bilha, tayya n babas, uca yiweḍ ad t ifhem Israil. Aqa řexxu iwḍen ayt n Yaɛqub tenɛac. ");
INSERT INTO rifl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Tarwa n Liya tuɣa aten: Rubin, amenzu n Yaɛqub d Cimɛun d Lawi d Yahuda d Issakar d Zabulun. ");
INSERT INTO rifl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Tarwa n Raḥil tuɣa aten: Yusuf d Binyamin. ");
INSERT INTO rifl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Tarwa n Bilha, tayya n Raḥil, tuɣa aten: Dan d Naftali. ");
INSERT INTO rifl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Tarwa n Zilpa, tayya n Liya, tuɣa aten: Jad d Acir. Ina tuɣa aten d iḥenjiren n Yaɛqub inni d as dd-ittwaxeřqen di Fadan-Aram. ");
INSERT INTO rifl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Uca yusa-dd Yaɛqub ɣar babas Isḥaq di Mamri, di tendint n Arbaɛ, tenni iǧan d tandint n Ḥabrun, mani tuɣa Ibrahim izeddeɣ am ubarrani, uca Isḥaq amenni awarni as. ");
INSERT INTO rifl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Iddar Isḥaq mya u-tmanyin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Iḍřeq Isḥaq i buḥbeř, immut uca immarni ɣar řgens nnes, iwsar, ijjiwen zi tudart, uca Ɛisu d Yaɛqub, iḥenjiren nnes, neḍřen t. ");
INSERT INTO rifl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ina d imezruyen n yinni dd-ittwaxeřqen zi Ɛisu, wenni iǧan d Idum. ");
INSERT INTO rifl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ɛisu iksi timɣarin nnes zeg yessis n Kenɛan: Ɛada, yeǧis n Ilun, Aḥitti, d Ahulibama, yeǧis n Ɛana, yeǧis n Ṣabɛun, Aḥiwi, ");
INSERT INTO rifl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","d Basmat, yeǧis n Ismaɛil, učmas n Nabayut. ");
INSERT INTO rifl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ɛada turuw-dd Ilifaz i Ɛisu uca Basmat turuw as-dd Raɛuwil. ");
INSERT INTO rifl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ahulibama turuw-dd Yaɛus d Yaɛlam d Quraḥ. Ina tuɣa aten d iḥenjiren n Ɛisu, inni d as dd-yurwen di temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Uca iksi Ɛisu timɣarin nnes d iḥenjiren nnes d yessis d marra aytbab n taddart nnes uřa d řebhayem nnes d marra řmař nnes d marra agřa nnes nni tuɣa dd-ikseb zi temmurt n Kenɛan uca iruḥ ɣar temmurt nneɣni i iggʷejen x uɣembub n umas Yaɛqub, ");
INSERT INTO rifl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","minzi agřa nsen tuɣa imɣar ařami war zemmaren ad zedɣen jmiɛ, uca tammurt mani tuɣa zeddɣen am řbarrani, war tqedd i řebhayem nsen. ");
INSERT INTO rifl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Xenni izdeɣ Ɛisu deg idurar n Saɛir. Ɛisu, netta d Idum. ");
INSERT INTO rifl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ina d imezruyen n yinni dd-ittwaxeřqen zi Ɛisu, babas n Idum, deg idurar n Saɛir. ");
INSERT INTO rifl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ina tuɣa aten d ismawen n iḥenjiren n Ɛisu: Ilifaz, mmis n Ɛada tenni d tamɣart n Ɛisu, Raɛuwil, mmis n Basmat, tenni d tamɣart n Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Iḥenjiren n Ilifaz tuɣa aten d Tayman, Umar, Ṣafu, Jaɛtam d Qanaz. ");
INSERT INTO rifl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timnaɛ tedweř d tayya n Ilifaz, mmis n Ɛisu, u nettat turuw-dd Ɛamaliq i Ilifaz. Ina tuɣa aten d iḥenjiren n Ɛada, tamɣart n Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ina tuɣa aten d iḥenjiren n Raɛuwil: Naḥat, Zaraḥ, Camma d Mizza. Ina tuɣa aten d iḥenjiren n Basmat, tenni d tamɣart n Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ina tuɣa aten d iḥenjiren n Ahulibama, tenni d tamɣart n Ɛisu, yeǧis n Ɛana, tenni d yeǧis n Zibyun. Nettat turuw-dd Yaɛuc, Jaɛlam d Quraḥ i Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ina tuɣa aten d imɣaren n tqebbař n ayt n Ɛisu. Iḥenjiren n Ilifaz, amenzu n Ɛisu: amɣar Timan d umɣar Umar d umɣar Ṣafu d umɣar Qinaz, ");
INSERT INTO rifl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","d umɣar Quraḥ, d umɣar Gatam, d umɣar Ɛamaliq. Ina tuɣa aten d imɣaren n Ilifaz di temmurt n Idum, ina tuɣa aten d iḥenjiren n Ɛada. ");
INSERT INTO rifl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ina tuɣa aten d iḥenjiren n Raɛuwil, mmis n Ɛisu: amɣar Naḥat d umɣar Zaraḥ d umɣar Samma d umɣar Mizza. Ina tuɣa aten d imɣaren n Raɛuwil di temmurt n Idum, d ina tuɣa aten d iḥenjiren n Basmat, tamɣart n Ɛisu. ");
INSERT INTO rifl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ina tuɣa aten d ayt n Ahulibama, tamɣart n Ɛisu: amɣar Yaɛuc d umɣar Yaɛlam d umɣar Quraḥ. Ina tuɣa aten d imɣaren n Ahulibama, tamɣart n Ɛisu, yeǧis n Ɛana. ");
INSERT INTO rifl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ina tuɣa aten d iḥenjiren n Ɛisu d ina tuɣa aten d imɣaren n tqebbař nsen, nitni d Idum. ");
INSERT INTO rifl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ina tuɣa aten d iḥenjiren n Saɛir, Axuri, inni d imezdaɣ n temmurt nni: Luṭan, Cubal, Ṣabɛun, Ɛana, ");
INSERT INTO rifl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dicun, Iṣar d Dican. Ina tuɣa aten d imɣaren n tqebbař n Ixuriyyen, ayt n Saɛir di temmurt n Idum. ");
INSERT INTO rifl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Iḥenjiren n Luṭan tuɣa aten d Axuri d Haymam uca tuɣa Timnaɛ d učmas n Luṭan. ");
INSERT INTO rifl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ina tuɣa aten d iḥenjiren n Cubal: Ɛalwan, Manaḥat, Ɛibal, Cafu d Unam. ");
INSERT INTO rifl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ina tuɣa aten d iḥenjiren n Ṣabɛun: Aya d Ɛana. D Ɛana wanita d wenni d yufin řɛunṣarat s waman iḥman di řexřa, umi yarwes iɣyař n Zibiyun babas. ");
INSERT INTO rifl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ina tuɣa aten d iḥenjiren n Ɛana: mɣir Dicun, d Ahulibama, yeǧis n Ɛana. ");
INSERT INTO rifl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ina tuɣa aten d iḥenjiren n Dican: Ḥamdan d Ahban d Yitran d Karan. ");
INSERT INTO rifl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ina tuɣa aten d iḥenjiren n Iṣar: Bilhan, Zaɛwan d Ɛaqan. ");
INSERT INTO rifl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ina tuɣa aten d iḥenjiren n Dican: Ɛuṣ d Aran. ");
INSERT INTO rifl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ina tuɣa aten d imɣaren n tqebbař n Ixuriyyen: amɣar Luṭan d umɣar Cubal d umɣar Ṣabɛun d umɣar Ɛana ");
INSERT INTO rifl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","d umɣar Dicun d umɣar Iṣar d umɣar Dican. Ina tuɣa aten d imɣaren n Ixuriyyen ɛlaḥsab imɣaren nsen di temmurt n Saɛir. ");
INSERT INTO rifl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ina tuɣa aten d ijeǧiden nni iḥekmen di temmurt n Idum qbeř ma ad iḥkem ujeǧid x ayt n Israil: ");
INSERT INTO rifl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bilaɛ, mmis n Baɛur, iḥkem di Idum uca isem n tendint nnes tuɣa-t d Dinhaba. ");
INSERT INTO rifl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Immut Bilaɛ uca Yubab, mmis n Zaraḥ zi Buṣra idweř d ajeǧid deg wemcan nnes. ");
INSERT INTO rifl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yubab immut uca Ḥucam, zi temmurt n Itaymaniyyen, idweř d ajeǧid deg wemcan nnes. ");
INSERT INTO rifl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Immut Ḥucam uca Hadad, mmis n Badad, wenni iɣeřben x Midyan deg iyyar n Mu’ab, idweř d ajeǧid deg wemcan nnes. Isem n tendint nnes qqaren as Ɛawit. ");
INSERT INTO rifl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Immut Hadad uca Samla zi Masriqa idweř d ajeǧid deg wemcan nnes. ");
INSERT INTO rifl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Immut Samla uca Cawul, zi Raḥubut ɣar yeɣzar n Lfuraṭ, idweř d ajeǧid deg wemcan nnes. ");
INSERT INTO rifl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Immut Cawul uca Baɛl-Ḥanan, mmis n Ɛakbur, idweř d ajeǧid deg wemcan nnes. ");
INSERT INTO rifl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Immut Baɛl-Ḥanan, mmis n Ɛakbur, uca Hadar idweř d ajeǧid deg wemcan nnes. Tandint nnes qqaren as Faɛu u tamɣart nnes qqaren as Mahiṭab’il, yeǧis n Maṭrid, yeǧis n Ma-Dahab. ");
INSERT INTO rifl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ina tuɣa aten d ismawen n imɣaren n tqebbař n Ɛisu ɛlaḥsab řaǧat nsen d imucan nsen d ismawen nsen: amɣar Timnaɛ d umɣar Ɛalwa d umɣar Yatit ");
INSERT INTO rifl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","d umɣar Ahulibama d umɣar Ila d umɣar Finun ");
INSERT INTO rifl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","d umɣar Qanaz d umɣar Tayman d umɣar Mibṣar ");
INSERT INTO rifl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","d umɣar Majdiyil d umɣar Ɛiram. Ina tuɣa aten d imɣaren n Idum ɛlaḥsab imucan nsen, di temmurt n řmelk nsen. Wanita d Idum, wenni d babas n Idumiyyen. ");
INSERT INTO rifl_vpl VALUES ("GN36_44","002_36_44","GEN","36","44","44","Uca izdeɣ Yaɛqub di temmurt n Kenɛan mani tuɣa izeddeɣ babas am ubarrani. Ina d imezruyen n yinni dd-ittwaxeřqen zi Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Řami tuɣa ɣar Yusuf sbeɛṭac n iseggʷusa, yarwes uǧi n babas ak-d aytmas. Tuɣa Yusuf d amsexxar ɣar iḥenjiren n Bilha d iḥenjiren n Zilpa, timɣarin n babas uca issiweḍ Yusuf awařen nsen iɛeffanen i babatsen. ");
INSERT INTO rifl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Uca ixs Israil Yusuf qaɛ x marra iḥenjiren nnes, minzi tuɣa-t ɣares d mmis x tewsar nnes uca igga as arruḍ s ifassen d iziraren. ");
INSERT INTO rifl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Řami ẓrin aytmas belli babas ittexs i-t qaɛ xasen, carhen t uca war zemmaren akides ssiwřen ɛad s řehna. ");
INSERT INTO rifl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Uca yurja Yusuf ict n tarjit, iɛawd i-tt i yaytmas. S uya nitni dewřen carhen t ɛad ktar. ");
INSERT INTO rifl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Inna asen: “Sřem řexxu tarjit-a nni urjiɣ. ");
INSERT INTO rifl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Xzar, tuɣa nettcedda tiqebbiḍin n imendi di řwesṭ n yeyyar. U xzar, taqebbiḍt inu tbedd, teqqim tbedd u tiqebbiḍin nwem nni tuɣa d as dd-innḍent, bendqen i tqebbiḍt inu.” ");
INSERT INTO rifl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Arrin-dd xas aytmas: “Ma ad tḥekmed zeɛma nican xaneɣ am ujeǧid niɣ ad xaneɣ tseǧḍed d aseǧeḍ?” Uca carhen t ɛad ktar di ssibbet n tirja nnes d wawařen nnes. ");
INSERT INTO rifl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Uca yurja ɛad tarjit nneɣni, iɛawd i-tt i yaytmas, inna: “Xzar, arjiɣ ɛad tarjit nneɣni. Xzar tafuct d uyur d ḥiṭac n itran bendqen ayi.” ");
INSERT INTO rifl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Iɛawed i-tt i babas d aytmas uca iwebbex i-t babas, inna as: “Mana tarjit-a i tarjid? Ma ad dd-nas jmiɛ, necc d yemmac d aytmac, ad ac nbendeq ɣar temmurt?” ");
INSERT INTO rifl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Aytmas usmen zzayes. Maca babas iɛqeř x wawařen-a. ");
INSERT INTO rifl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Uca ruḥen aytmas, ḥima ad arewsen uǧi n babatsen ɣar Cakim. ");
INSERT INTO rifl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Xenni inna Israil i Yusuf: “Ma war arewsen aytmac uǧi ɣar Cakim? Zid, ad cek ɣarsen ssekkeɣ.” Uca yarra-dd xas: “Aqa ayi da!” ");
INSERT INTO rifl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Uca inna as: “Ruḥ cek, xzar muxas ǧan aytmac d muxas ǧan wuǧi uca awi ayi-dd řexbar ɛawed.” Ammu i-t issekk zi řewḍa n teɣzurt n Ḥabrun uca netta yiweḍ-dd ɣar Cakim. ");
INSERT INTO rifl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yufa i-t ijj n weryaz umi iweddar deg iyyar. Isseqsa t weryaz, inna: “Min tarezzud?” ");
INSERT INTO rifl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Inna: “Arezzuɣ x aytma. Ttzawgeɣ cek, ini ayi mani arewsen.” ");
INSERT INTO rifl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Aryaz yarra-dd: “Aqa muṭṭiyen iqiḍan nsen ssa, necc sřiɣ asen qqaren: ‘Ejj aneɣ ad nraḥ ɣar Dutan.’” Řexdenni iruḥ Yusuf awarni aytmas uca yufa i-ten di Dutan. ");
INSERT INTO rifl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Umi t ẓrin zi řaggʷaj, qbeř ma ad ɣarsen dd-iqarreb, mɛahaden ḍidd nnes ḥima ad t nɣen, ");
INSERT INTO rifl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","nnan ijj i wenneɣni: “Xzar, yusa-dd bu-tirja nni! ");
INSERT INTO rifl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Zid řexxu, ejj aneɣ ad t nᵉnneɣ uca ad t nenḍar deg wanu, ad nini: ‘Ca n řweḥc yewɛar icca i-t!’, uca xenni ad nẓar min ɣa iřint tirja nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Isřa Rubin man aya uca ifekk i-t zeg ifassen nsen, inna: “War t nneqq ca!” ");
INSERT INTO rifl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Inna asen ɛawed Rubin: “War sizziřem idammen! Nḍarem t deg wanu-ya da di řexřa. War xas tteggem afus!”. Inna ammu ḥima ad t ifekk zeg ifassen nsen uca ad t yarr ɣar babas. ");
INSERT INTO rifl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Uca imsar, umi dd-yiweḍ Yusuf ɣar aytmas, kksen nitni arruḍ x Yusuf, arruḍ s ifassen d iziraren nni xas tuɣa, ");
INSERT INTO rifl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","uca ṭṭfen t, nḍaren t deg wanu. Maca anu tuɣa ixwa, war dayes tuɣi ca aman. ");
INSERT INTO rifl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Awarni man aya qqimen maḥend ad ccen aɣrum, uca řami ssgeɛɛden nitni tiṭṭawin nsen, zřin ijj n ukaravan n Ismaɛiliyyen i dd-yusin zi Jilɛad. Iřeɣman nsen arbun řeɛṭur d řefwah n balsam d mirru, gguren ad t awyen ɣar Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Xenni inna Yahuda i yaytmas: “Man řefḍeř mařa nenɣa umatneɣ uca ad neffar idammen nnes? ");
INSERT INTO rifl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ɣawrem, ad t nezzenz i Ismaɛiliyyen, war ittiři ufus nneɣ xas, aqa d umatneɣ d aysum nneɣ.” Uca sřin aytmas ɣares. ");
INSERT INTO rifl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Am dd-ɛdun tujjar n Midyan, ssgeɛɛden-dd Yusuf zeg wanu uca zzenzen t s ɛicrin n uqiyyat n nnuqart i Ismaɛiliyyen, inni dd-yiwyen Yusuf ɣar Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Řami dd-idweř Rubin ɣar wanu, war din yufi Yusuf ɛad deg wanu. Xenni icarreg arruḍ nnes. ");
INSERT INTO rifl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Idweř ɣar aytmas uca inna: “Aḥenjir war din iǧi ɛad. I necc, mani ɣa raḥeɣ?” ");
INSERT INTO rifl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Xenni ksin arruḍ n Yusuf uca ɣarṣen i yijj n umyan zeg iɣayḍen uca marɣen arruḍ s idammen. ");
INSERT INTO rifl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ssekken ijjen s arruḍ d lemliḥ s ifassen d iziraren, jjin t ad t yawi ɣar babatsen, nnan: “D wa i nufa. Xzar řexxu, ma wah niɣ lla arruḍ n mmic?” ");
INSERT INTO rifl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Uca netta iɛeqř i-t, inna: “Arruḍ n mmi i yeǧa! Ca n řweḥc yewɛar icca i-t. Yusuf s tidett bettqen t!” ");
INSERT INTO rifl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Icarreg Yaɛqub arruḍ nnes uca yarḍ ict n txancet n wecḍan x tejɛinna nnes, icḍen x mmis aṭṭas n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kkaren marra iḥenjiren nnes d marra tiḥenjirin nnes maḥend ad t ɛezzan, ɛad netta war ixs ad ittwaɛezza, inna: “Lla, ad dd-hwiɣ nnuryeɣ ɣar řaxart.” Uca isɣuy xas babas. ");
INSERT INTO rifl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Imidiyaniyyen zzenzen t di Miṣra i Putifar, amsexxar amcenneɛ n firɛun, řqebṭan n iɛessasen n arrimet. ");
INSERT INTO rifl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Di řweqt d ict ihwa Yahuda, iffeɣ x aytmas, uca iwta iqiḍan nnes ɣar yijj n weryaz d Adullamiti wenni umi qqaren Ḥira. ");
INSERT INTO rifl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Uca iẓra din Yahuda yeǧis n yijj n weryaz d Akenɛani wenni umi qqaren Cuɛa. Uca Yahuda yiwi yeǧis n Cuɛa d tamɣart, uca yudef xas. ");
INSERT INTO rifl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nettat teksi s ddeyset uca turuw-dd aḥenjir uca Yahuda iřaɣa as Ɛir. ");
INSERT INTO rifl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Uca teksi ɛawed s ddeyset, turuw-dd aḥenjir uca třaɣa as Unan. ");
INSERT INTO rifl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Uca turuw-dd ɛawed aḥenjir uca třaɣa as Cayla. Netta tuɣa-t di Kazib umi d as t-i-dd-turuw. ");
INSERT INTO rifl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahuda iksi tamɣart i Ɛir, amenzu nnes. Tamɣart-a qqarent as Tamar. ");
INSERT INTO rifl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ɛir, amenzu n Yahuda, tuɣa-t d aɛeffan di tiṭṭawin n SIDI uca inɣa i-t SIDI. ");
INSERT INTO rifl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Xenni inna Yahuda i Unan: “Adef x temɣart n umac, mřec akides deg wemcan n umac, tejjed-dd zzariɛet i umac.” ");
INSERT INTO rifl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Maca Unan issen belli zzariɛet war tᵉttiři nnes. Uca ammu imsar, umi yudef x temɣart n umas, inɣeř zzariɛet nnes di temmurt, ḥima war ittic zzariɛet i umas. ");
INSERT INTO rifl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Min igga tuɣa d aɛeffan di tiṭṭawin n SIDI uca inɣa i-t uřa d netta. ");
INSERT INTO rifl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Xenni inna Yahuda i Tamar, tasřit nnes: “Qqim am tajjač di taddart n babam, ař ɣa imɣar mmi Cayla!”, minzi inna: “Aqa war ittmetti uřa d wa am yaytmas.” Uca truḥ Tamar, tezdeɣ di taddart n babas. ");
INSERT INTO rifl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ɛdun wussan aṭṭas, xenni temmut yeǧis n Cuɛa, tamɣart n Yahuda. Yahuda yarezzu ad ittwaɛezza uca igeɛɛed ɣar tḥimart n wuǧi nnes ɣar Timnata, netta d Ḥira, ameddukkeř nnes zi Adullam. ");
INSERT INTO rifl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ɛeřmen t i Tamar, nnan: “Xzar, aḍeggʷař nnem igeɛɛed ɣar Timnata, ad iřs uǧi nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Xenni tekkes xas arruḍ n tajjač, třeḥḥef s tkenbuct, tesřeḥhef ixef nnes zzayes, uca truḥ ad teqqim ɣar wadaf n Ɛaynayim, wenni iǧan deg webrid ɣar Timnata, minzi teẓra Cayla imɣar, u nettat tuɣa war d as temmewc d tamɣart. ");
INSERT INTO rifl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Uca iẓra i-tt Yahuda, iḥesb i-tt d lfasda, minzi tuɣa-tt třeḥḥef i uɣembub nnes. ");
INSERT INTO rifl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Uca imeyyeř ɣares ɣar webrid, inna as: “Ejj ayi ad xam adfeɣ!”, minzi netta tuɣa war issin, belli nettat d tasřit nnes. Nettat tenna: “Min d ayi ɣa tewced, ḥima ad xafi tadfed?” ");
INSERT INTO rifl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yarra-dd: “Necc ad am-dd ssekkeɣ ijj n iɣayḍ d ameẓyan zeg iɣayḍen, zeg wuǧi.” Tenna as: “Mɣir ewc ayi ijj n warhan ař d ayi t-i-dd tᵉssekked.” ");
INSERT INTO rifl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Inna: “Man aḍman i d am i ɣa wceɣ?” Nettat tenna: “Taxadent nnec n ucemmiɛ d ttesbiḥ nnec d taɣɣarct i ɣarek deg ufus.” Uca iwca as ten, yudef xas uca teksi zzayes ddeyset. ");
INSERT INTO rifl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Uca tekkar, truḥ, tekkes xas takenbuct nnes uca tyarḍ arruḍ nnes n tajjač. ");
INSERT INTO rifl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Uca issekk Yahuda iɣayḍ d ameẓyan zeg iɣayḍen x ufus n umeddukkeř nnes Adullami, ḥima ad iṭṭef ɛawed aḍman zeg ufus n temɣart, maca war tt yufi. ");
INSERT INTO rifl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Isseqsa iryazen x wemcan nnes, inna: “ Mani teǧa temɣart n farq-ccɣeř nni tuɣa iqqimen x webrid ɣar Ɛanayim?” Nitni arrin-dd xas: “War da tuɣi qaɛ ca n temɣart n farq-ccɣeř ɣar zzawect.” ");
INSERT INTO rifl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Xenni iɛqeb-dd ɣar Yahuda, inna: “War tt ufiɣ ca, uřa d iryazen n wemcan nni nnan: ‘War da tuɣi qaɛ ca n temɣart n farq-ccɣeř ɣar zzawect.’” ");
INSERT INTO rifl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Uca inna Yahuda: “Ejj i-tt ad tᵉṭṭef aḍman ɣares, ḥima war nettiři d řɛar. Xzar, necc aqa ssekkeɣ iɣayḍ-a d ameẓyan, maca cek war tt tufid.” ");
INSERT INTO rifl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ɛřaḥař awarni třata n iyuren temsar, aqa xebbaren Yahuda, nnan: “Tamar, tasřit nnec, aqa tessefsed ixef nnes uca řexxu nettat aqa-tt s ddeyset s farq-ccɣeř nnes.” Xenni inna Yahuda: “Suffɣem tt-i-dd, ad tecmeḍ!” ");
INSERT INTO rifl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Umi tt-i-dd-yiwyen ɣar barra, tessekk-dd ijjen ɣar uḍeggʷař nnes, maḥend ad yini: “Zeg weryaz n řeḥwayej-a, aqa ksiɣ s ddeyset.” Tenna ɛad: “Arzu xenni wi iřan taxadent-a n ucemmiɛ d ttesbiḥin-a d taɣɣarct-a.” ");
INSERT INTO rifl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda iɛeqř i-tent, inna: “Aqa-tt d nican xafi, minzi war tt wciɣ d tamɣart i Cayla mmi.” War iqqim issen i-tt ɛad. ");
INSERT INTO rifl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Di řweqt umi dd-tiweḍ ad dd-taruw, aqa da acniwen deg uɛeddis nnes. ");
INSERT INTO rifl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Imsar umi dd-turuw, issuffeɣ-dd ijjen afus uca teksi t řqabřa uca tcedd i-t ɣar ufus nnes s ufiřu d azeggʷaɣ, tenna: “Wa i dd-iffɣen d amezwar.” ");
INSERT INTO rifl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Řami dd yarra afus nnes, iban-dd umas, uca tenna: “Mammec teggid tazzit. Ad tiřid d bu-ittareẓẓan!” Uca semman t Fariṣ.    ");
INSERT INTO rifl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Awarni man aya iffeɣ-dd umas, wenni ɣar iǧa ufiřu azeggʷaɣ deg ufus nnes uca isemma t Zaraḥ. ");
INSERT INTO rifl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nedhen xenni Yusuf ɣar Miṣra. Putifar, amsexxar amcenneɛ n firɛun, řqebṭan n iɛessasen n arrimet, ijj n Umiṣri, isɣa i-t zeg ufus n Ismaɛiliyyen, inni din t yiwyen. ");
INSERT INTO rifl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tuɣa SIDI ak-d Yusuf. Tuɣa netta d aryaz ifřeḥ uca tuɣa-t di taddart n sidis, Amiṣri. ");
INSERT INTO rifl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Iẓra sidis belli SIDI tuɣa-t akides u belli SIDI issekkwaḍ s ufus nnes marra min tuɣa ittegg. ");
INSERT INTO rifl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ammu i yufa Yusuf arḍa di tiṭṭawin nnes, isexxar as. Uca igga i-t Putifar d ameḥḍay x taddart nnes uca igga as deg ufus nnes marra min ɣares. ");
INSERT INTO rifl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Zeg wass min di t igga x taddart nnes u x marra min ɣares, ibark SIDI taddart n Umiṣri di ṭṭweɛ n Yusuf. Tuɣa lbaraka n SIDI x marra min ɣares, am daxeř n taddart, am barra deg iyyar. ");
INSERT INTO rifl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Marra min ɣares, ijja i-t deg ifassen n Yusuf, ař war issin netta ca ktar mɣir aɣrum i ittett. Tuɣa Yusuf icna deg waddud u udem nnes dayes aẓri. ");
INSERT INTO rifl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Imsar awarni man aya, aqa tamɣart n sidis tenḍar tiṭṭawin nnes di Yusuf, tenna: “Zid, ṭṭeṣ akidi.” ");
INSERT INTO rifl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maca netta yugi, inna i temɣart n sides: “Xzar, sidi inu war issin min iǧan di taddart řami da akides ǧiɣ. Marra min ɣares, igga i-t deg ufus inu. ");
INSERT INTO rifl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Netta war iǧi sennej inu di taddart-a, war d ayi iṭṭif s walu mɣir cem, umi teǧid d tamɣart nnes. Mammec i ɣa ggeɣ ljarima-ya tameqqrant am tanita uca ad ggeɣ ddenb ak-d AREBBI!” ");
INSERT INTO rifl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tuɣa tessawař ak-d Yusuf kuř ass, war ɣares ittesři, ḥima ad iṭṭeṣ ṭṭarf nnes u ḥima ad akides yiři. ");
INSERT INTO rifl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Deg ijj n wass temsar, umi dd-yudef ɣar taddart, ḥima ad igg řxedmet nnes, war tuɣi din uřa d ijj zeg yeryazen n taddart. ");
INSERT INTO rifl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Xenni tᵉṭṭeff i-t zeg warruḍ nnes, tenna: “Araḥ-dd zzeř akidi!” Řexdenni ijja as netta arruḍ nnes deg ufus, yarweř, iffeɣ barra. ");
INSERT INTO rifl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Umi teẓra belli ijja as arruḍ nnes deg ufus nnes, yarweř ɣar barra, ");
INSERT INTO rifl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","třaɣa i aytbab n taddart, tenna asen: “Xzarem, aqa netta yiwy aneɣ-dd aryaz Aɛibrani, ḥima ad xaneɣ iḍḥec. Yusa-dd ɣari, ḥima akidi iṭṭeṣ uca necc sɣuyeɣ s jjehd. ");
INSERT INTO rifl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Umi isřa belli ssgeɛɛdeɣ tmijja inu uca sɣuyeɣ, ijja ɣari arruḍ nnes, yarweř, iffeɣ barra.” ");
INSERT INTO rifl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Uca nettat tegga arruḍ nnes zzates, ař dd ɣa yas sidis ɣar taddart. ");
INSERT INTO rifl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Xenni tessiweř akides s wawařen nni d ijjen, tenna: “Amsexxar Aɛibrani wenni dd-tiwyed ɣarneɣ, yusa-dd ɣari ḥima ad ayi issɛurra. ");
INSERT INTO rifl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Umi ssgeɛɛdeɣ tmijja inu, sɣuyeɣ, ijja arruḍ nnes ɣari uca yarweř barra.” ");
INSERT INTO rifl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Sides isřa i wawařen inni d as tenna temɣart nnes, tenna: “Ammu i d ayi igga umsexxar nnec!”, uca ixeyyeq aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Iṭṭef i-t sidi n Yusuf, igga i-t di řeḥbes, mani tuɣa imeḥbas n ujeǧid. Ammu i iqqim di řeḥbes. ");
INSERT INTO rifl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Maca SIDI tuɣa-t ak-d Yusuf uca isswiẓẓeḍ ɣares s tmexsiwt nnes icewwaren uca iwca as arḍa nnes di tiṭṭawin n umeqqran n řeḥbes. ");
INSERT INTO rifl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Uca ameqqran n řeḥbes yarra marra imeḥbas nni tuɣa di řeḥbes sadu ufus n Yusuf. Marra min tuɣa tteggen din tuɣa ittekk x ufus nnes. ");
INSERT INTO rifl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ameqqran n řeḥbes war d as iqqim min xef ɣa innehweř zi min tuɣa sadu ufus nnes, minzi SIDI tuɣa ak-d Yusuf. Min ma tuɣa ittegg netta, SIDI issekkwaḍ i-t. ");
INSERT INTO rifl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Imsar awarni man aya belli awarrad n ujeǧid n Miṣra d uxebbaz dennben ḍidd i siditsen, ajeǧid n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Iffugem firɛun x tnayen n imsexxaren icennɛen nnes, x umeqqran n iwarraden u x umeqqran n ixebbazen. ");
INSERT INTO rifl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Igga i-ten deg uḥeṭṭu di taddart n řqebṭan n iɛessasen n arrimet, di taddart n tɛessast, mani iḥebbes Yusuf. ");
INSERT INTO rifl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Řqebṭan n iɛessasen n arrimet igga Yusuf d ameḥḍay nsen, uca netta tuɣa ittsexxar xasen. Ammu tuɣa aten ussan d iziraren di řeḥbes. ");
INSERT INTO rifl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Urjin tarjit s tnayen idsen nsen, kuř ijjen zzaysen yurja di ǧiřet nni tarjit nnes s řmeɛna nnes, am uwarrad am uxebbaz n ujeǧid n Miṣra, inni tuɣa ittwaḥebbsen di taddart n tɛessast. ");
INSERT INTO rifl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Uca yusa-dd ɣarsen Yusuf x ṣṣbeḥ, ixzar daysen uca iẓra i-ten ttqellqen. ");
INSERT INTO rifl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Řexdenni isseqsa netta imsexxaren icennɛen n firɛun, inni tuɣa akides di řeḥbes di taddart n sidis, inna: “Maɣar barecnen udmawen nwem ass-a qaɛ ammu?” ");
INSERT INTO rifl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nitni nnan: “Aqa nurja tarjit, war da wi tt ɣa ifekken.” Inna asen Yusuf: “Ma war ǧin ca ifessaren zi AREBBI? Iwa, ɛawdem ayi tent řexxu!” ");
INSERT INTO rifl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Xenni iɛawed umeqqran n iwarraden tarjit nnes i Yusuf, inna as: “Necc di tarjit inu ẓriɣ tazayart zzati tbedd. ");
INSERT INTO rifl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tazayart nni ɣares třata n tseḍwin. Xmi tessendiy, ittgeɛɛad nnuwwar nnes u ɣar izekkunen nnes iban-dd řḥebb n uḍiř yiweḍ. ");
INSERT INTO rifl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Uca řkas n firɛun tuɣa-t ɣari deg ufus inu uca ksiɣ aḍiř nni uca ɛessareɣ t di řkas n firɛun uca sseɛduɣ řkas ɣar ufus n firɛun.” ");
INSERT INTO rifl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Inna as Yusuf: “D wa d afessar nnes: třata n tiseḍwin, aqa d třata n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ɛad třata n wussan xenni ad ac issgeɛɛed firɛun azeǧif nnec uca ad cek yarr ɣar tsexxart nnec, ad tesseɛdud řkas i firɛun deg ufus nnes, am mammec tuɣa tasɣart nnec zic řami cek tuɣa d awarrad nnes. ");
INSERT INTO rifl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Maca ɛqeř xafi xmi d ac dd ɣa yas řxar, ttzawageɣ cek ad kidi tegged s tmexsiwt icewwaren uca ejj firɛun ad xafi iɛqeř uca fekk ayi-dd zi taddart-a. ");
INSERT INTO rifl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Minzi ucaren ayi zi temmurt n Iɛibraniyyen u da war ggiɣ x min xef dayi i ɣa ggen deg weḥfur n imeḥbas.” ");
INSERT INTO rifl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Řami iẓra umeqqran n ixebbazen belli ifessar as mliḥ, inna i Yusuf: “Uřa d necc ẓriɣ di tarjit inu třata n tsuǧatin s weɣrum d acemřař x uzeǧif inu. ");
INSERT INTO rifl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Di tsuǧet n sennej tuɣa dayes aṭṭas n macca i firɛun i igga uxebbaz u ijḍaḍ ttᵉtten zi tsuǧet i iǧan x uzeǧif inu.” ");
INSERT INTO rifl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yarra-dd xas Yusuf, inna: “D wa d afessar nnes. Třata n tsuǧatin d třata n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ɛad třata n wussan xenni ad xak issgeɛɛed firɛun azeǧif nnec jmiɛ akik uca ad cek yayeř x ict n tcejjart u ijḍaḍ ad ccen aysum nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Deg wass wiss třata, ass n wexřaq n firɛun, imsar belli issewjed ict n zzardet i marra imsexxaren nnes uca issgeɛɛed azeǧif n umeqqran n iwarraden u azeǧif n umeqqran n ixebbazen tuɣa-t jar imsexxaren nnes. ");
INSERT INTO rifl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Uca netta yarra ameqqran n iwarraden ɣar řxedmet nnes n uwarrad, ařami wanita iwca ɛawed řkas deg ufus n firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Maca ameqqran n ixebbazen yuyeř i-t, am mammec d as ifessar Yusuf. ");
INSERT INTO rifl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Maca ameqqran n iwarraden war ifekkar ca ɛad di Yusuf, ittu t. ");
INSERT INTO rifl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Awarni řami ɛdun tnayen n iseggʷusa yurja firɛun aqa netta zeɛma ibedd x yeɣzar n Nil. ");
INSERT INTO rifl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Xzar, geɛɛdent-i-dd sebɛa n tfunasin zeg iɣzar, ṣebḥent i řxezrat u ɛemmarent s weysum, heddant jar weḥtic n uɣanim. ");
INSERT INTO rifl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","U xzar, sebɛa n tfunasin nneɣni geɛɛdent-i-dd awarni asent zeg iɣzar. Nitenti war ḥřint i řxezrat, aqa kkuccḍent uca beddent zzat i tfunasin nneɣni ɣar tma n iɣzar. ");
INSERT INTO rifl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tifunasin i war iḥřin i řxeẓrat, tinni ikuccḍen, ṣarḍent sebɛa n tfunasin iṣebḥen i řxezrat, tinni iṣeḥḥen. Uca ifaq-dd firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Iṭṭeṣ ɛawed uca yurja twařa nneɣni, u xzar, zeg ict n tseṭṭa geɛɛdent sebɛa n tidrin ccurent, cnant. ");
INSERT INTO rifl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","U xzar, ɣemyent-i-dd sebɛa n tidrin qqusbaren awarni asent, isscemḍ i-tent usemmiḍ acarqi. ");
INSERT INTO rifl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sebɛa n tidrin qqusbarent ṣarḍent sebɛa n tidrin iyman d iccuren. Uca ifaq-dd firɛun, u xzar, aqa d ict n terjit. ");
INSERT INTO rifl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ɣar ṣṣbeḥ iban-dd belli buḥbeř nnes innehweř uca issekk maḥend ad dd-řaɣan i marra tarwa n tseḥḥart n Miṣra u i marra imiɣisen. Iɛawd asen firɛun tarjit nnes, maca war din tuɣi ḥed izemmar ad tt ifessar i firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Issiweř umeqqran n iwarraden ak-d firɛun, inna: “Deg wass-a ad ttwasɛeqřeɣ x ddnub inu. ");
INSERT INTO rifl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Umi iffugem firɛun x imsexxaren nnes, igga ayi di řeḥbes di taddart n řqebṭan n iɛessasen n arrimet, am necc am umeqqran n ixebbazen. ");
INSERT INTO rifl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Necc d netta nurja ict n tarjit di ǧiret d ict. Kuř ijj zzayneɣ yurja tarjit nnes s řmeɛna nnes. ");
INSERT INTO rifl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tuɣa din akidneɣ ijj n ubřiɣ d Aɛibrani. Tuɣa-t d amsexxar n řqebṭan n iɛessasen n arrimet. Nḥaja as tirja nneɣ uca ifessar aneɣ tent. I kuř ijj zzayneɣ ifessar as tarjit nnes. ");
INSERT INTO rifl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Am mammec tent ifessar, amenni i imsar. Aqa Firɛun yarra ayi necc ɣar řxedmet inu u wenneɣni yuyeř i-t.” ");
INSERT INTO rifl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Issekk firɛun ḥima ad dd-řaɣan x Yusuf uca ssuffɣen t-i-dd deɣya zeg weḥfur n imeḥbas. Iḥeff acuwwaf, ibeddeř arruḍ uca ammu i yudef ɣar firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Inna firɛun i Yusuf: “Necc urjiɣ ict n tarjit, war iǧi wi tt ɣa ifessaren. Maca aqa sřiɣ xak belli cek, xmi i ɣa tesřid i tarjit, tzemmared ad tt tfessared.” ");
INSERT INTO rifl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yarra-dd Yusuf x firɛun, inna: “War iǧi ca zzayi, maca AREBBI ad dd-yarr x mammec ɣa idweř umeddur n firɛun.” ");
INSERT INTO rifl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Inna firɛun i Yusuf: “Di tarjit inu ẓriɣ ixef inu beddeɣ x tma n iɣzar. ");
INSERT INTO rifl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Aqa geɛɛdent-i-dd sebɛa n tfunasin zeg iɣzar, ṣeḥḥent u ṣebḥent i řxezrat, heddant jar weḥtic n uɣanim. ");
INSERT INTO rifl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Awarni asent sebɛa n tfunasin nneɣni geɛɛdent-i-dd. Tuɣa kkuccḍent u war ḥřint deg wudem, uẓɣent. Ammu war ḥřint, ɛemmarṣ war tent ẓriɣ di temmurt n Miṣra am tekmeř. ");
INSERT INTO rifl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tifunasin yuẓɣen, war iḥřin, sarḍent sebɛa n tyenduzin timezwura iṣeḥḥen. ");
INSERT INTO rifl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Umi udfent tina deg uɛeddis nsent, ɛad war issin ḥed, belli aqa udfent deg uɛeddis nsent, aqa qqiment war ḥřint i řxezrat am qbeř. Xenni faqeɣ. ");
INSERT INTO rifl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ɛawed ẓriɣ di tarjit inu, xzar, zeg ict n tseṭṭa ffɣent-i-dd sebɛa n tidrin ccurent u cnant. ");
INSERT INTO rifl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Xzar, ẓriɣ, geɛɛdent-i-dd sebɛa n tidrin qqusbarent, uẓɣent, isscemḍ i-tent usemmiḍ acarqi. ");
INSERT INTO rifl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","U sebɛa n tidrin yuẓɣen, ṣarḍent sebɛa n tidrin nni icnan. Nniɣ tarjit i tarwa n tseḥḥart, maca war din tuɣi ḥed i izemmaren ad ifessar tarjit-a.” ");
INSERT INTO rifl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Xenni inna Yusuf i firɛun: “Tarjit n firɛun d ict. AREBBI ibeyyen i firɛun min i ɣa yegg Netta. ");
INSERT INTO rifl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sebɛa n tfunasin cnant aqa atent d sebɛa n iseggʷusa. Uca tidrin cnant aqa d sebɛa n iseggʷusa. D tarjit d ict. ");
INSERT INTO rifl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sebɛa n tfunasin uẓɣent war iḥřin tinni dd-yuřyen awarni asent, aqa d sebɛa n iseggʷusa, u sebɛa n tidrin qqusbarent, tinni isscemḍ usemmiḍ acarqi, aqa atent d sebɛa n iseggʷusa i di ɣa yiři řaẓ. ");
INSERT INTO rifl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","D wa d awař i nniɣ i firɛun. Min ɣa yegg AREBBI, aqa isscen i-t i firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Xzar, di sebɛa n iseggʷusa i dd-igguren ad tiři tyawant tameqqrant x marra tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Awarni asen ad dd-asen sebɛa n iseggʷusa n řaẓ. Di marra tammurt n Miṣra ad ttun marra tyawant uca řaẓ ad iteḥḥa tammurt. ");
INSERT INTO rifl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Uca tyawant war tᵉttiři tᵉttwassen ɛad zi ssibbet n řaẓ i tt-i-dd-iḍfaren, maɣar řḥař ad yiři iqseḥ aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ɛlaḥsab ṭṭbiɛet n tnayen n wudmawen n tarjit n firɛun, aqa tnayen n tseqqar, aqa man aya s minzi yura tt AREBBI nican u AREBBI aqa ad tt yegg deɣya. ");
INSERT INTO rifl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ejj firɛun řexxu ad yarzu x ijj n weryaz s řefhamet d tiɣit, maḥend ad t igg x temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ejj firɛun ad igg ammu: ejj i-t ad igg iweqqafen x temmurt, maḥend ad ksin řexmus n řɣiǧet n temmurt n Miṣra di sebɛa n iseggʷusa n tyawant. ");
INSERT INTO rifl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ejj i-ten ad ssmunen marra řeɛweč deg iseggʷusa iṣebḥen i dd ɣa yasen uca ad xemmřen řḥebb n yirden sadu ufus n firɛun, maḥend ad t xemmřen d macca di tneddam. ");
INSERT INTO rifl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ad yiři d řexzen n macca i temmurt i sebɛa n iseggʷusa n řaẓ nni dd ɣa iwḍan x temmurt n Miṣra, ḥima tammurt war tᵉttmetti ca s řaẓ.” ");
INSERT INTO rifl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Awařen-a banen-dd d lemliḥ i firɛun d marra imsexxaren nnes. ");
INSERT INTO rifl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Xenni inna firɛun i imsexxaren nnes: “Ma izemmar ad ittwaf ca n weryaz am wa i di izeddeɣ Arruḥ n AREBBI?” ");
INSERT INTO rifl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Uca inna firɛun i Yusuf: “Umi AREBBI immeř ac-dd marra aya, x uya war din yeǧi wenni ɣar teǧa řefhamet d tiɣit am cek. ");
INSERT INTO rifl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Cek ad tiřid x taddart inu u i wawař nnec ad iṭaɛ řgens inu marra. Mɣir x řɛarc waha ad iřiɣ necc d ameqqran xak.” ");
INSERT INTO rifl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Yarni inna firɛun i Yusuf: “Xzar, ggiɣ cek x marra tammurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Uca ikkes firɛun taxadent nnes zeg ufus nnes, igga i-tt deg ufus n Yusuf uca issyarḍ as arruḍ n řeqṭen azdad uca igga as taseddect n wureɣ deg yiri nnes. ");
INSERT INTO rifl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Issenya i-t di tkarrut wiss tnayen i tuɣa ɣares uca řaɣan am gguren zzates: “Qews!” Ammu i t igga x marra tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Inna firɛun i Yusuf: “Necc d firɛun, břa cek uřa d ijj ad igeɛɛed afus nnes niɣ aḍar nnes di marra tammurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Iřaɣa firɛun i Yusuf s yisem n Ṣafnat-Faɛniḥ uca iwca as Asnat d tamɣart, tenni d yeǧis n Futi-Faraɛ, akehhan n Un. Uca ijuř Yusuf di temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tuɣa Yusuf d mmis n třatin n iseggʷusa řami ibedd netta zzat i firɛun, ajeǧid n Miṣra, uca iffeɣ Yusuf zzat i firɛun uca ijuř x marra tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Uca tesseɣmi-dd temmurt di sebɛa n iseggʷusa s tyawant. ");
INSERT INTO rifl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Issmun marra macca n sebɛa n iseggʷusa n tyawant, inni tuɣa di temmurt n Miṣra, uca ixemmeř macca di tneddam. Macca n iyyaren i d as dd-innḍen i kuř tandint, ixemmeř i-tt dayes daxeř di tendint. ");
INSERT INTO rifl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusuf ixemmeř řḥebb n irden aṭṭas, anect n ijdi n řebḥar, ařami war izemmar ad ittwaḥseb, minzi tuɣa-t břa řeḥsab. ");
INSERT INTO rifl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Qbeř i dd-yusa useggʷas amezwaru n řaẓ, mmarenyen-dd ɣar Yusuf tnayen n iḥenjiren, inni d as dd-turuw Asnat, yeǧis n Futi-Faraɛ, akehhan n Un. ");
INSERT INTO rifl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Isemma Yusuf amenzu Manassa, minzi inna: “AREBBI aqa issettu ayi marra tamara inu d marra taddart n baba.” ");
INSERT INTO rifl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Wiss tnayen isemma i-t Ifrayim, minzi inna: “AREBBI igga ayi s řɣiǧet di temmurt n řeḥṣaret inu.” ");
INSERT INTO rifl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Xenni kemmřen sebɛa n iseggʷusa n ufeyyeḍ n řɣiǧet nni ikkin x temmurt n Miṣra, ");
INSERT INTO rifl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","uca bdan ad dd-asen sebɛa n iseggʷusa n řaẓ, am mammec xas issiweř Yusuf. Tuɣa řaẓ di marra timmura, maca di marra tammurt n Miṣra tuɣa dayes ɛad aɣrum. ");
INSERT INTO rifl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ařami tuɣa řaẓ di marra tammurt n Miṣra, isɣuy řgens ɣar firɛun x weɣrum. Uca inna firɛun i marra Imiṣriyyen: “Ruḥem ɣar Yusuf, ggem min d awem ɣa yini!” ");
INSERT INTO rifl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tuɣa řaẓ izeǧeɛ x marra tammurt uca yarzem Yusuf x marra min tuɣa ixemmeř, uca izzenz i-t i Imiṣriyyen, minzi tuɣa řaẓ idweř imɣar aṭṭas di temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Zi marra timmura usin-dd iwdan ɣar Miṣra ɣar Yusuf ḥima ad sɣen, minzi di marra timmura tuɣa řaẓ imɣar aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Řami iẓra Yaɛqub belli aqa din řḥebb n yirden di Miṣra, xenni inna i iḥenjiren nnes “Maɣar teqqimem txezzarem ijjen deg wenneɣni?” ");
INSERT INTO rifl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Inna: “Aqa necc sřiɣ belli din imendi di Miṣra. Ruḥem dinni uca sɣem aneɣ-dd ssenni řḥebb, ḥima ad neqqim neddar uca war nettmetti ca.” ");
INSERT INTO rifl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Hwan ɛecra n wawmaten n Yusuf, maḥend ad raḥen ad sɣen imendi zi Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Maca Yaɛqub war issekk Binyamin, umas n Yusuf, ak-d aytmas, minzi inna: “Ḥima war d as ittemsar ca n řḥajjet d taɛeffant.” ");
INSERT INTO rifl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Jar inni dd-yusin dinni, usin-dd ɛawed ayt n Israil, maḥend ad sɣen macca, minzi tuɣa din řaẓ di temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tuɣa Yusuf d řḥakem x temmurt uca izzenz imendi i marra řgens n temmurt. Umi dd-iwḍen aytmas n Yusuf, bendqen as s uɣembub nsen ɣar temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Umi iẓra Yusuf aytmas, iɛqeř i-ten, maca igga ixef nnes axmi war ten issin uca issiweř akidsen s řeqsaḥet, inna asen: “Manis dd-tusim?” Nnan: “Zi temmurt n Kenɛan, maḥend ad nseɣ macca.” ");
INSERT INTO rifl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusuf iɛeqř aytmas, maca nitni war t ɛqiřen ca. ");
INSERT INTO rifl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ifekkar Yusuf di tirja nni tuɣa xasen yurja, inna asen: “Kenniw d ibergagen i teǧam, tusim-dd, ḥima ad tẓarem mani war tᵉttwaḥḍi temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Arrin-dd xas: “Lla, a sidi inu, ɛad imsexxaren nnec usin-dd, maḥend ad sɣen macca. ");
INSERT INTO rifl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Marra neccin aqa aneɣ d tarwa n ijj n weryaz. Aqa aneɣ d iryazen d imtiqqan, imsexxaren nnec war ǧin ca d ibergagen.” ");
INSERT INTO rifl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Netta yarra-dd xasen: “Lla, kenniw tusim-dd maḥend ad tẓarem tuɛɛaryent n temmurt.” ");
INSERT INTO rifl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nnan nitni: “Neccin d imsexxaren nnec, aqa aneɣ di tenɛac n wawmaten, tarwa n ijj n weryaz di temmurt n Kenɛan. Aqa amaẓuẓ aqa-t ak-d babatneɣ u wenneɣni war iǧi ɛad.” ");
INSERT INTO rifl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Inna asen Yusuf: “Ma war d awem t nniɣ umi nniɣ: ‘Aqa kenniw d ibergagen!’ ");
INSERT INTO rifl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","S uya tᵉttwaqeǧbem. S tidett am iddar firɛun, kenniw war dd-tteffɣem ssa, mɣir xmi dd ɣa yas umatwem amaẓuẓ danita! ");
INSERT INTO rifl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sekkem ijj n zzaywem, maḥend ad dd-yawi umatwem. Xenni kenniw ad tᵉttwaḥebbsem uca awařen nwem ad ttwaqeǧben, ma daywem řaman. Mařa lla, s tidett am iddar firɛun, aqa kenniw d ibergagen!” ");
INSERT INTO rifl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Uca igga i-ten třata n wussan di řeḥbes. ");
INSERT INTO rifl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Deg wass wiss třata inna asen Yusuf: “Ggem aya, ḥima ad teqqimem teddarem, necc tteggʷdeɣ AREBBI. ");
INSERT INTO rifl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mařa kenniw d iryazen d imtiqqan, jjem xenni ijj n umatwem ad iqqim icarf di taddart mani tᵉttwaḥebbsem kenniw, xenni ruḥem, ksim imendi i řaẓ n aytbab n taddart nwem. ");
INSERT INTO rifl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Awyem-dd xenni umatwem, amaẓuẓ, maḥend ad ttwaqeǧben wawařen nwem, war tᵉttmettim ca.” Uca nitni ggin amenni. ");
INSERT INTO rifl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nnan i wayawya: “S tidett aqa ittxeṣṣa aneɣ ad dd-narr ddeyyet n umatneɣ, aqa neẓra řḥeṣran n řeɛmar nnes umi d aneɣ ittar aḥinni, maca war d as nesři ca! X uya dd-yusa řḥeṣran-a xaneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Yarra-dd xasen Rubin, inna: “Ma war d awem t nniɣ, umi nniɣ: ‘War xeṭṭim ca ak-d uḥenjir!’, maca kenniw war tesřim ca. Xzar, idammen nnes ttwattaren řexxu!” ");
INSERT INTO rifl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nitni war ssinen belli ifhem asen Yusuf, minzi tuɣa aturjman jar asen. ");
INSERT INTO rifl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Inneqřeb xasen uca isɣuy. Awarni as inneqřeb-dd ɛawed ɣarsen, issiweř akidsen, iksi zzaysen Cimɛun uca iḥebbes i-t zzat i tiṭṭawin nsen. ");
INSERT INTO rifl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yumur Yusuf maḥend ad ccuren tixuncay nsen s imendi u ad ggen tmenyat n nnuqart di kuř ict n txancet nsen uca wcin asen macca i webrid. U ammu i kidsen ggin. ");
INSERT INTO rifl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ssarbun imendi nsen x yeɣyař nsen uca ffɣen ssenni. ");
INSERT INTO rifl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Umi yarzem ijjen zzaysen taxancet nnes, ḥima ad issecc aɣyuř nnes ɣar mani ɣa ssensen, iẓra nnuqart nnes deg arzam n uqemmum n txancet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Inna i yaytmas: “Nnuqart inu tedweř ayi-dd. Xzar, aqa-tt da di txancet inu!” Řexdenni ibedd asen wuř, arjijen uca nnan i wayawya: “Manawya i d aneɣ ittegg AREBBI?” ");
INSERT INTO rifl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Uca reḥḥgen ɣar babatsen Yaɛqub di temmurt n Kenɛan uca ɛawden as marra min xasen ikkin, nnan: ");
INSERT INTO rifl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Aryaz, bab n temmurt, issiweř akidneɣ s řeqsaḥet, iḥesb aneɣ d ibergagen n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Maca nenna as: ‘Neccin d iryazen d imtiqqan, ɛemmarṣ war neǧi d ibergagen. ");
INSERT INTO rifl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Aqa aneɣ di tenɛac n wawmaten, iḥenjiren n babatneɣ. Ijjen war iqqim, amaẓuẓ aqa-t ass-a ak-d babatneɣ di temmurt n Kenɛan.’ ");
INSERT INTO rifl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","U aryaz nni, bab n temmurt, inna aneɣ: ‘S uya ad ssneɣ, ma aqa kenniw d imtiqqan. Ad kidi tejjem ijjen zeg aytmatwem uca ad teksim macca i řaẓ nni din ɣar aytbab n taddart nwem, xenni ffɣem. ");
INSERT INTO rifl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Awyem-dd da umatwem, amaẓuẓ, xenni ad ssneɣ belli war teǧim d ibergagen, maca d imtiqqan uca ad awem dd-arxuɣ i wamatwem nwem uca ad traḥem ad tjuřem di temmurt.’” ");
INSERT INTO rifl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Umi ssexwan tixuncay nsen, ḥekkaren belli di txancet n kuř ijjen, aqa dayes tacyart s nnuqart nnes. Ẓrin nitni d babatsen ticyar s nnuqart nsen uca tudef i-ten tiggʷudi. ");
INSERT INTO rifl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Inna asen babatsen Yaɛqub: “Aqa tḥarrmem ayi zeg iḥenjiren inu! Yusuf war dd-iḍhar ɛad uřa d Cimɛun, uca řexxu tᵉttexsem ad tnedhem Binyamin. Marra man aya ittemsaren di řeɛkes inu!” ");
INSERT INTO rifl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Xenni issiweř Rubin ɣar babas, inna: “Ad tenɣed tnayen n iḥenjiren inu, mařa war d ac t-i-dd-arriɣ. Ewc ayi t deg ufus inu, necc aqa ad ac t-i-dd-arreɣ!” ");
INSERT INTO rifl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Maca netta inna as: “Mmi war ittriḥ ca akidwem, minzi umas immut u netta weḥḥdes i d ayi iqqimen. Mařa iřqef i-t ca n řɣar deg webrid nni i ɣa tekkem, ad tessehwam ccib inu s wecḍan ɣar řaxart.” ");
INSERT INTO rifl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Maca řaẓ tuɣa imɣar aṭṭas di temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Řami kemmřen ccin řḥebb n yirden nni kidsen dd-iwyen zi Miṣra, inna asen babatsen: “Dewřem-dd ɛawed uca sɣem aneɣ-dd cwayt n macca.” ");
INSERT INTO rifl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Xenni issiweř Yahuda, inna: “Aqa aryaz nni inna aneɣ s urekkez: “War tẓarrem ɛad udem inu, mɣir mařa tiwyem-dd umatwem akidwem.” ");
INSERT INTO rifl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mařa tessekked umatneɣ akidneɣ, ad nraḥ din uca ad ac dd-nseɣ macca, ");
INSERT INTO rifl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","maca mařa war t tᵉssekkid akidneɣ, xenni war dinni nettraḥ, minzi aryaz nni inna aneɣ: ‘War tẓarrem ɛad udem inu mɣir mařa yusa-dd umatwem akidwem.’” ");
INSERT INTO rifl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Inna Israil: “Maɣar d ayi teggim řɣar uca tennam i weryaz nni belli aqa ɣarwem ɛad umatwem nneɣni?” ");
INSERT INTO rifl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nitni nnan: “Aryaz nni isseqsa xaneɣ nican, u x temmurt mani nexřeq, inna: ‘Ma iddar ɛad babatwem? Ma ɣarwem ca n umatwem nneɣni?’ Xenni nɛawed as t. Ma nzemmar zeg wawařen-a ad dd-nejbed illa ad nessen zeɛma ad yini: ‘Awyem-dd umatwem?’” ");
INSERT INTO rifl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Uca inna Yahuda i babas Israil: “Sekk akidi aḥenjir uca ad nekkar ad nraḥ, ḥima ad neddar u war nᵉttmetti ca neccin d cek d tarwa nneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Necc ad as iřiɣ d aḍman u zeg ufus inu ad t tᵉttared ɛawed. Mařa war d ac t-i-dd-arriɣ, ad t ssbeddeɣ zzatek, ad yiři xḍiɣ akidek i řebda! ");
INSERT INTO rifl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Meɛlik war neqqim nettraja aṭṭas, tiři řexxu nedweř-dd tnayen n twařawin.” ");
INSERT INTO rifl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Uca yarra-dd xasen Israil, babatsen: “Mařa ammu i yeǧa s tidett, ggem ammu uca ksim min icnan aṭṭas n temmurt di txuncay nwem, hwam-dd maḥend ad t tiwyem d arriɣalu i weryaz nni: cwayt n balsam d cwayt n tamment, řeɛṭur d mirru d teɣyact n pistac d ǧuz. ");
INSERT INTO rifl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ksim tnayen n tseqqar n tenɛacin n nnuqart akidwem uca arrem s ufus nwem nnuqart i dd-iɛeqben di txuncay nwem. Ad taɣ tuɣa d ca n lɣalaṭ. ");
INSERT INTO rifl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Awyem-dd ɛawed umatwem akidwem, kkarem, ɛeqbem ɣar weryaz nni. ");
INSERT INTO rifl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Uca aqa Arebbi, Amzemmar x kuřci, ad awem iwc arreḥmet zzat i wudem n weryaz nni uca ad yarxu i umatwem nneɣni d Binyamin. U min d ayi iqqimen necc, mařa ttwaḥarrmeɣ zeg iḥenjiren inu, aqa ad zzaysen ttwaḥarrmeɣ!” ");
INSERT INTO rifl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Xenni iwyen iryazen arriɣalu uca ksin deg ufus nsen tnayen n tseqqar n tmenyat n nnuqart uřa d Binyamin uca kkaren, hwan ɣar Miṣra uca bedden zzat i wudem n Yusuf. ");
INSERT INTO rifl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Umi iẓra Yusuf Binyamin akidsen, inna i wenni tuɣa x taddart nnes: “Sidef iryazen-a ɣar taddart, tɣarṣed i ca min iǧan i tɣarṣt, sewjed i-tt, minzi iryazen-a ad kidi ccen ɣar wezyen n wass.” ");
INSERT INTO rifl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Igga weryaz am mammec d as inna Yusuf uca yiwi iryazen ɣar taddart n Yusuf. ");
INSERT INTO rifl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Xenni dewřen yeryazen nni ggʷeden aṭṭas, umi ten ssidfen di taddart n Yusuf uca nitni nnan: “X tmenyat n nnuqart i d aneɣ dd-idewřen di txuncay nneɣ twařa tamezwarut iwyen aneɣ-dd da ḥima xenni ɛawed ad xaneɣ ɛefsen uca ad xaneɣ ɛeddan, xenni ad aneɣ ksin d isemɣan ak-d yeɣyař nneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Qarrben-dd ɣar weryaz nni igga Yusuf x taddart uca ssiwřen akides ɣar wadaf n taddart, ");
INSERT INTO rifl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","nnan: “A sidi inu, neccin aqa nican nehwa-dd d amezwar, maḥend ad nseɣ macca. ");
INSERT INTO rifl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Imsar umi dd-niweḍ ɣar řemraḥ uca narzem tixuncay nneɣ, neẓra nnuqart n kuř ijj ɣar werzam n uqemmum n txancet nnes, nnuqart nneɣ s řmizan nnes nican. Aqa narra i-tt-i-dd s ifassen nneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ɛawed niwi-dd deg ifassen nneɣ nnuqart nneɣni, ḥima ad nseɣ macca. Neccin war nessin wi iggin nnuqart di txuncay nneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yarra-dd xasen: “Sřam xawem, war tteggʷedem ca! AREBBI nwem d AREBBI n babatwem iwca awem ict n txabect di txuncay nwem. Aqa nnuqart nwem ṭṭfeɣ tt.” Uca issuffeɣ-dd ɣarsen Cimɛun. ");
INSERT INTO rifl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Xenni issidef weryaz iryazen nni ɣar taddart n Yusuf, iwca asen aman uca sirden iḍaren nsen. Iwca asen ɛawed řeɛřef i yeɣyař nsen. ");
INSERT INTO rifl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","U nitni sswejden arriɣalu i Yusuf, wenni igguren ad dd-yas ɣar wezyen n wass, minzi nitni sřin aqa ad ccen dinni. ");
INSERT INTO rifl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Řami dd- yudef Yusuf ɣar taddart, wcin as-dd di taddart arriɣalu nni dd-iwyen akidsen, uca bendqen as ɣar temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Isseqsa ten x mammec ǧan uca inna: “Mammec iǧa babatwem awessar i xef tessiwřem? Ma aqa ɛad iddar?” ");
INSERT INTO rifl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nitni arrin: “Mlih i yeǧa umsexxar nnec, babatneɣ, netta ɛad iddar.” Uḍaren nitni uca netta ibendeq. ");
INSERT INTO rifl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Řami netta issgeɛɛed tiṭṭawin nnes uca iẓra Binyamin, umas, mmis n yemmas, inna: “Ma d wa d umatwem, amaẓuẓ, min xef d ayi tessiwřem?” Xenni inna: “Ad xak iḥinn AREBBI, a mmi!” ");
INSERT INTO rifl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf iffeɣ xenni deɣya, minzi taḥnunect nnes x umas tuɣa temɣar. Yarzu x mani ɣa iru uca yudef ɣar ijj n wexxam uca iru din. ");
INSERT INTO rifl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Issird udem nnes uca iffeɣ-dd ɣar barra, iṭṭef deg ixef nnes, inna: “Qedmem-dd macca.” ");
INSERT INTO rifl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nitni sswejden as i netta weḥḥdes u i nitni weḥḥedsen uřa i Imiṣriyyen inni akides ccin weḥḥedsen, minzi Imiṣriyyen war zemmaren ad ccen aɣrum ak-d Iɛibraniyyen, minzi d man aya d jjɛifect ɣar Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Uca nitni qqimen zzat i wudem nnes: amenzu deg wemcan nnes ɛlaḥsab tasɣart n tmenzut nnes uca amaẓuẓ deg wemcan nnes ɛlaḥsab temẓi nnes. Tuɣa iryazen ttbehaten, xezzaren ijjen deg wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Uca netta iqeddem asen-dd zi min tuɣa iǧan zzates, maca tasɣart n Binyamin tuɣa-tt xemsa n tseqqar ktar zi tseqqar n marra idsen. Uca swin nitni, ssenni dewřen farḥen akides. ");
INSERT INTO rifl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Issekk Yusuf ɣar umsexxar nni tuɣa x taddart nnes, inna as: “Ɛemmar tixuncay n yeryazen nni s macca, marra min zemmaren ad ksin. Egg nnuqart n kuř ijj deg warzam n uqemmum n txancet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Sars řkas inu, řkas n nnuqart, deg warzam n uqemmum n txancet n umaẓuẓ ak-d tmenyat n nnuqart n řḥebb nnes n yirden.” Uca igga am mammec d as inna Yusuf. ");
INSERT INTO rifl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ɣar ṣṣbeḥ umi dd-yeffu řhař, jjin iryazen ad uyuren, nitni ak-d yeɣyař nsen. ");
INSERT INTO rifl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Umi ffɣen nitni zi tendint, tuɣa ɛad war ggʷijen ca, inna Yusuf i wenni tuɣa x taddart nnes: “Kkar, ḍfar iryazen nni uca, xmi xasen ɣa teɛdud, ini asen: ‘Maɣar dd-tarram řxar s řɣar? ");
INSERT INTO rifl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ma war iǧi d wa d řkas i zi isess sidi inu u ma war iǧi s wa i zi ɣa ikacef min ɣa imsaren tiwecca? Aqa teggim řɣar umi teggim amya.’” ");
INSERT INTO rifl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Am ten iɛdu, inna asen awařen-a simant nsen. ");
INSERT INTO rifl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nitni arrin-dd xas: “Mayemmi iqqar sidi inu awařen-a? Iggʷej x imsexxaren nnec ad ggen man aya. ");
INSERT INTO rifl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Xzar, nnuqart i nufa deg warzam n uqemmum n txuncay nneɣ, aqa narr ac tt-i-dd zi temmurt n Kenɛan. Mammec ɛad i ɣa negg ad nacar nnuqart niɣ ureɣ zi taddart n sidi nnec? ");
INSERT INTO rifl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Wi zeg imsexxaren nnec i ɣar i ɣa ittwaf řkas, ad immet, uca neccin ɛawed ad niři d isemɣan n sidi inu!” ");
INSERT INTO rifl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Netta inna: “Xenni řexxu ad yiři am mammec tennam kenniw. Wenni ɣar t ɣa naf, d netta ad yiři d ismeɣ inu, maca kenniw ad tiřim d ifurra.” ");
INSERT INTO rifl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Uca kuř ijj zzaysen iqeǧeq ad issars taxancet nnes di temmurt uca kuř ijj yarzem taxancet. ");
INSERT INTO rifl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Uca netta ifettec i-tent, ibda zeg umeqqran, ikemmeř zeg umeẓyan, uca ufin řkas di txancet n Binyamin. ");
INSERT INTO rifl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Xenni carrgen arruḍ nsen, uca kuř ijj issarbu ɛawed x weɣyuř nnes uca ɛeqben nitni ɣar tendint. ");
INSERT INTO rifl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Uca yiweḍ Yahuda ak-d aytmas ɣar taddart n Yusuf, wenni tuɣa din ɛad, uca wḍan zzates ɣar temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Inna asen Yusuf: “Mana cɣeř-a i teggim? Ma war tefhimem ca belli ijj n weryaz am necc, iggur ad xas ikacef nican?” ");
INSERT INTO rifl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Inna Yahuda: “Min ɣa nini i sidi inu d mammec i ɣa nessiweř niɣ s min zi ɣa nsegged ixef nneɣ? AREBBI iqeǧeb ddenb n imsexxaren nnec, xzar, neccin d imsexxaren n sidi inu, neccin d wi ɣar ufin řkas.” ");
INSERT INTO rifl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Maca netta yarra: “Iggʷej xafi ad ggeɣ aya! Aryaz nni ɣar ufin řkas, netta ad yiři d ismeɣ inu, maca kenniw ruḥem di řehna ɣar babatwem.” ");
INSERT INTO rifl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Xenni yiweḍ-dd Yahuda ɣares, inna: “A sidi inu, ejj ad issiweř umsexxar nnec ijj n wawař deg umezzuɣ n sidi inu, war yareqq uxeyyeq nnec x umsexxar nnec, minzi aqa cek am firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Sidi inu isseqsa imsexxaren nnes, inna: ‘Ma ɣarwem ɛad babatwem niɣ tawmat?’ ");
INSERT INTO rifl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Uca neccin narra x sidi inu: ‘Aqa ɣarneɣ babatneɣ d awessar d yijj n uḥenjir, wenni d as dd-ittwaxeřqen x tewsar nnes, d amaẓuẓ ɛad. Umas immut, netta waha i iqqimen zeg iḥenjiren n yemmas, u babas ittexs i-t.’ ");
INSERT INTO rifl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Xas uca tennid cek i imsexxaren nnec: ‘Awyem t-i-dd da ɣari, ḥima ad t ẓareɣ s tiṭṭawin inu.’ ");
INSERT INTO rifl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Uca neccin nenna i sidi inu: ‘War izemmar uḥenjir ad yejj babas, minzi mařa ijja i-t, babas ad immet.’ ");
INSERT INTO rifl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Xenni tennid i imsexxaren nnec: ‘Mařa umatwem amaẓuẓ war dd-yusi akidwem, war tẓarrem ɛad udem inu.’ ");
INSERT INTO rifl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Řami ngeɛɛed ɣar baba, amsexxar nnec, nesseɛdu as awařen n sidi inu. ");
INSERT INTO rifl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Uca babatneɣ inna: ‘Ɛeqbem ɛawed maḥend ad tesɣem cwayt n macca i neccin.’ ");
INSERT INTO rifl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Xenni narra-dd: ‘War nzemmar ad nraḥ. Maca mařa umatneɣ, amaẓuẓ, iruḥ akidneɣ, ad nraḥ, minzi war nzemmar ad nẓar udem n weryaz nni, mɣir mařa aqa akidneɣ umatneɣ amaẓuẓ.’ ");
INSERT INTO rifl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Xenni inna aneɣ umsexxar nnec, babatneɣ: ‘Kenniw tessnem belli tnayen n iḥenjiren i d ayi dd-turuw temɣart inu. ");
INSERT INTO rifl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Iffeɣ ijjen zi ɣari uca nniɣ: Aqa s tidett ittwabetteq! U ař řexxu ɛad war t ẓriɣ. ");
INSERT INTO rifl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mařa ɛawed tekksem ayi wa uca imsar ca n řɣar, ad tessehwam ccib inu s wecḍan ɣar řaxart!’ ");
INSERT INTO rifl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Řexxu xenni, mařa ruḥeɣ necc ɣar umsexxar nnec, baba, uca aḥenjir war kidi iǧi - řeɛmar nnes iřṣeq ɣar řeɛmar n babas - ");
INSERT INTO rifl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","aqa ad immet xmi ɣa iẓar aḥenjir war iǧi, uca imsexxaren nnec ad ssehwan ccib n umsexxar nnec, babatneɣ, s wecḍan ɣar řaxart. ");
INSERT INTO rifl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Aqa zeɛma amsexxar nnec d aḍman i uḥenjir-a ɣar baba umi inna: ‘Mařa war d ac t-i-dd-arriɣ, řexdenni necc ad iřiɣ d amednub i baba i řebda!’ ");
INSERT INTO rifl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Iwa řexxu, ejj amsexxar nnec ad iqqim deg wemcan n uḥenjir-a am yismeɣ ɣar sidi inu, uca ejj aḥenjir ad iraḥ ak-d aytmas! ");
INSERT INTO rifl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Maɣar mammec ɣa ggeɣ ad geɛɛdeɣ ɣar baba, břa aḥenjir-a akidi? Mammec i ɣa ẓareɣ řemḥayen i dd ɣa iwḍan x baba?” ");
INSERT INTO rifl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Xenni war izemmar ɛad Yusuf ad iṭṭef ixef nnes zzat i yinni akides marra uca iřaɣa: “Suffɣem marra inni akidi da!” War iqqim ḥed akides řami isscen Yusuf i yaytmas min iɛna. ");
INSERT INTO rifl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Řexdenni yarxu tmijja nnes s iɣuyyan, ařami d as sřin Imiṣriyyen, uca uřa d taddart n firɛun tesřa aya. ");
INSERT INTO rifl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Inna Yusuf i yaytmas: “Necc d Yusuf! Ma iddar ɛad baba?” Aytmas war zemmaren ad xas dd-arren, minzi tuɣa ggʷeden zzayes. ");
INSERT INTO rifl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Inna Yusuf i yaytmas: “Qarrbem-dd řexxu ɣari!” Uca nitni qarrben ɣares. Inna xenni: “Necc d Yusuf umatwem, wenni tezzenzem i Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Řexxu, war kessim s wemnus u war t ttejjim ad yiři d axeyyeq di tiṭṭawin nwem umi d ayi tezzenzem danita i Miṣra, aqa AREBBI issekk ayi-dd, maḥend ad kenniw jjeɣ teddarem. ");
INSERT INTO rifl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Aqa řexxu ɛad tnayen n iseggʷusa n řaẓ di temmurt uca qqim ɛad xemsa n iseggʷusa war daysen ittiři tyarza niɣ tameyra. ");
INSERT INTO rifl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Maca AREBBI issekk ayi-dd zzatwem, ḥima ad awem ggeɣ min iqqimen x temmurt u ḥima ad ḥḍiɣ tudart nwem i yijj n usenjem imɣar. ");
INSERT INTO rifl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Xenni řexxu, kenniw war d ayi dd-tessekkem ca da, maca AREBBI d wenni d ayi iggin d babas i firɛun d sidi x marra taddart nnes d řḥakem x marra tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Qeǧqem deɣya, sgeɛɛdem ɣar baba, inim as: ‘Ammu i iqqar mmic Yusuf: AREBBI igga ayi d sidi n marra Miṣra. Araḥ-dd ɣari, war tteɛgiz. ");
INSERT INTO rifl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ad tzedɣed di temmurt n Jucan, ad tiřid zzati, cek d iḥenjiren nnec, d iḥenjiren n iḥenjiren nnec, d wuǧi d ifunasen d tfunasin uřa d marra min ɣarek. ");
INSERT INTO rifl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ad ac ggeɣ arzeq din, minzi ad dd-asen ɛad xemsa n iseggʷusa n řaẓ, ḥima war tᵉtteḍɛifed, cek lla, taddart nnec lla, uřa d marra min ɣarek lla! ");
INSERT INTO rifl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Xzar, tiṭṭawin nwem ẓrint, uřa d tiṭṭawin n uma Binyamin, aqa d necc i kidwem issawařen. ");
INSERT INTO rifl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ɛeřmem i baba x marra aɛuǧi inu di Miṣra u x marra min teẓrim. Qeǧqem deɣya, tiwyem-dd baba da.” ");
INSERT INTO rifl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Uca ingez x yiri n Binyamin umas, iru, uca Binyamin iru x yiri nnes. ");
INSERT INTO rifl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Issudem marra aytmas, iru xasen. Awarni man aya ssiwřen akides aytmas. ");
INSERT INTO rifl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Řami tesřa taddart n firɛun řexbar-a, nnan: “Aytmas n Yusuf usin-dd!”. Tuɣa-t d řexbar aṣebḥan di tiṭṭawin n firɛun d imsexxaren nnes. ");
INSERT INTO rifl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Inna firɛun i Yusuf: “Ini i aytmac: ‘Ggem aya: sarbum zwayeř nwem uca geɛɛdem, ruḥem ɣar temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ksim-dd babatwem d raǧ nwem, tusim-dd ɣari. Aqa ad awem wceɣ lemliḥ n temmurt n Miṣra uca ad teccem zi min icnan n temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Aqa ttwaggent tiweṣṣa di ṭṭweɛ nnek. Ggem aya: Ksim zi temmurt n Miṣra ikarruten i iḥenjiren nwem u i temɣarin nwem, awyem-dd zzayes babatwem uca asem-dd da. ");
INSERT INTO rifl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","War ttejjim tiṭṭawin nwem ad ssḥissfent i řqecc nwem, minzi lemliḥ n temmurt n Miṣra ad yiři nwem.’” ");
INSERT INTO rifl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Uca ammu i ggin ayt n Israil. Iwca asen Yusuf ikarruten x řumur n firɛun uca iwca asen ɛawed macca i webrid. ");
INSERT INTO rifl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Iwca i kuř ijj zzaysen weḥḥdes arruḍ n jdid, maca i Binyamin iwca as teřt-mya n uqiyyat n nnuqart d xemsa n warruḍ d jdid. ");
INSERT INTO rifl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","U ammu ɛawed issekk i babas ɛecra n yeɣyař ccuren s min ifarzen n Miṣra u ɛecra n teɣyař ccurent s imendi d weɣrum d macca i babas umi ɣa yiři netta deg webrid. ");
INSERT INTO rifl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Iqebbeḍ aytmas uca ruḥen. Inna asen netta: “War ttmenɣim ca deg webrid.” ");
INSERT INTO rifl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Geɛɛden zi Miṣra, iwḍen ɣar temmurt n Kenɛan ɣar Yaɛqub, babatsen. ");
INSERT INTO rifl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wcin as řexbar, nnan: “Yusuf aqa iddar ɛad, wah, aqa-t d řḥakem n marra tammurt n Miṣra!” Xenni isxef wuř nnes, minzi war ten yumin ca. ");
INSERT INTO rifl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Umi d as ɛawden marra awařen n Yusuf inni d asen inna u řami iẓra ikarruten inni dd-issekk Yusuf ḥima ad t awyen, iɛqeb-dd buḥbeř n babatsen Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Uca inna Israil: “Kfa! Yusuf mmi aqa iddar! Ad raḥeɣ uca ad t ẓarɣ qbeř i ɣa mmteɣ!” ");
INSERT INTO rifl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ifsi Israil iqiḍan nnes ssenni, yuyur s marra min ɣares uca yiweḍ ɣar Bi’r-Sebɛa. Iqeddem din tiɣarṣa i AREBBI n babas Isḥaq. ");
INSERT INTO rifl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Uca issiweř AREBBI ak-d Israil di iweḥḥan di ǧiřet, inna: “Yaɛqub, Yaɛqub!” uca inna netta: “Aqa ayi da!” ");
INSERT INTO rifl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Xenni inna: “Necc d Arebbi, AREBBI n babac. War tteggʷed, maḥend ad tehwid ɣar Miṣra, minzi Necc ad cek ggeɣ din d ijj n řgens imɣar. ");
INSERT INTO rifl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ad kidek hwiɣ ɣar Miṣra uca Necc ad cek ssgeɛɛdeɣ ɛawed u Yusuf ad xak issars ifassen nnes x tiṭṭawin nnec.” ");
INSERT INTO rifl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ikkar Yaɛqub, iffeɣ zi Bi’r-Sebɛa. Ksin ayt n Israil babatsen Yaɛqub d iḥenjiren nsen d temɣarin nsen deg ikarruten nni dd-issekk firɛun maḥend ad t yawi. ");
INSERT INTO rifl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ksin řebhayem nsen d wagřa i yarebḥen di temmurt n Kenɛan uca iwḍen ɣar Miṣra, Yaɛqub d marra iḥenjiren nnes akides: ");
INSERT INTO rifl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","iḥenjiren nnes d iḥenjiren n iḥenjiren nnes jmiɛ akides, uřa d yessis d yessitsen n iḥenjiren nnes, aqa yiwi akides marra tarwa nnes ɣar Miṣra. ");
INSERT INTO rifl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ina d ismawen n ayt n Israil, inni yudfen ɣar Miṣra: Yaɛqub d iḥenjiren nnes. Amenzu n Yaɛqub: Rubin. ");
INSERT INTO rifl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Tarwa n Rubin: Ḥanuk d Fallu d Ḥaṣrun d Karmi. ");
INSERT INTO rifl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Tarwa n Cimɛun: Yamuyil d Yamin d Uhad d Yakin d Ṣuḥar d Cawul, mmis n temɣart Takenɛanit. ");
INSERT INTO rifl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Tarwa n Lawi: Jarcun d Qahat d Marari. ");
INSERT INTO rifl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Tarwa n Yahuda: Ɛir d Unan d Cayla d Fariṣ d Zaraḥ. Maca Ɛir d Unan mmuten di temmurt n Kenɛan. Tarwa n Fariṣ tuɣa aten Ḥaṣrun d Ḥamul. ");
INSERT INTO rifl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Tarwa n Issakar: Tulaɛ d Fawwa d Yub d Cimrun. ");
INSERT INTO rifl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Tarwa n Zabulun: Sarad d Ilun d Yaḥliyil. ");
INSERT INTO rifl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ina tuɣa aten d iḥenjiren n Liya inni d as dd-turuw i Yaɛqub di Fadan-Aram, uca ɛawed yeǧis Dina. Marra řeɛmur n iḥenjiren nnes d tḥenjirin tuɣa aten di třata u-třatin. ");
INSERT INTO rifl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Tarwa n Jad: Ṣifyun d Ḥajji d Cuni d Aṣbun d Ɛiri d Arudi d Arwili. ");
INSERT INTO rifl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Iḥenjiren n Acir: Yimna d Yiswi d Bariɛa d učmatsen Caraḥ. D iḥenjiren n Bariɛa: Ḥabir d Malkiyil. ");
INSERT INTO rifl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ina tuɣa aten d iḥenjiren n Zilpa tenni iwca Laban i yeǧis Liya. Nettat turuw-dd ina i Yaɛqub, ina seṭṭac d arruḥ. ");
INSERT INTO rifl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Tarwa n Raḥil, tamɣart n Yaɛqub: Yusuf d Binyamin. ");
INSERT INTO rifl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ttwaxeřqen-dd i Yusuf di temmurt n Miṣra Manassa d Ifrayim, inni d as dd-turuw Asnat, yeǧis n Fuṭi-Faraɛ, akehhan n Un. ");
INSERT INTO rifl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Tarwa n Binyamin: Bilaɛ d Bakir d Acbil d Jira d Naɛman d Iḥi d Ruc d Muffim d Ḥuffim d Ard. ");
INSERT INTO rifl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ina tuɣa aten d iḥenjiren n Raḥil, inni dd-ittwawarwen i Yaɛqub, marra arbeɛṭac d arruḥ. ");
INSERT INTO rifl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tarwa n Dan: mɣir Ḥucim. ");
INSERT INTO rifl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Tarwa n Naftali: Yaḥaṣwil d Juni d Yiṣru d Cillim. ");
INSERT INTO rifl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ina tuɣa aten d iḥenjiren n Bilha, tenni i d as iwca Laban i Raḥil yeǧis. Turuw as-dd ina i Yaɛqub, ina marra tuɣa aten sebɛa d arruḥ. ");
INSERT INTO rifl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Marra řeɛmur nni dd-yusin ɣar Miṣra ak-d Yaɛqub, inni dd-iffɣen zeg uɣezdis nnes, břa timɣarin n iḥenjiren n Yaɛqub, ina marra tuɣa aten di setta u-settin řeɛmur. ");
INSERT INTO rifl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tarwa n Yusuf inni d as dd-ittwaxeřqen di Miṣra, aqa tnayen n řeɛmur. Marra řeɛmur n taddart n Yaɛqub nni dd-yusin ɣar Miṣra, tuɣa aten di sebɛin. ");
INSERT INTO rifl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Uca netta issekk Yahuda zzates ɣar Yusuf, ḥima ad isscen abrid zzates ɣar Jucan uca iwḍen ɣar temmurt n Jucan. ");
INSERT INTO rifl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Indeh Yusuf ɛawed akarru nnes uca igeɛɛed ɣar Jucan, maḥend ad iřqa Israil, babas. Umi d as immeř ixef nnes, ingez as x yiri, iqqim ittru x yiri nnes aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Inna Israil i Yusuf: “Řexxu zemmareɣ necc ad mmteɣ, řexxu umi ẓriɣ aɣembub nnec, zeɛma aqa ɛad teddared!” ");
INSERT INTO rifl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Xenni inna Yusuf i yaytmas u i aytbab n taddart n babas: “Ad geɛɛdeɣ ad xebbareɣ firɛun, ad iniɣ: ‘Aytma d taddart n baba, inni iǧan di temmurt n Kenɛan, aqa usin-dd ɣari. ");
INSERT INTO rifl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Iryazen d imeksawen n wuǧi, tuɣa ceɣřen ixef nsen ak d řebhayem. Aqa iwyen-dd uǧi nsen d ifunasen d tfunasin nsen d marra min ɣarsen.’ ");
INSERT INTO rifl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mařa imsar ad awem dd-iřaɣa firɛun uca ad awem yini: ‘Min teɛna řxedmet i tᵉtteggem?’, ");
INSERT INTO rifl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ad tinim: ‘Imsexxaren nnec d iryazen inni iceɣřen ak-d řebhayem zi temẓi nsen ař i řexxu, neccin uřa d řejdud nneɣ!’, ḥima ad ɣarwem yiři ttesriḥ maḥend ad tzedɣem di temmurt n Jucan, minzi kuř ameksaw n wuǧi, aqa-t d jjɛifect i Imiṣriyyen.” ");
INSERT INTO rifl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Řami dd-yusa Yusuf, ixebbar firɛun, inna as: “Baba d aytma d wuǧi nsen d ifunasen d tfunasin nsen d marra min ɣarsen, aqa usin-dd zi temmurt n Kenɛan. Xzar, aqa aten di temmurt n Jucan.” ");
INSERT INTO rifl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Uca zi jar marra aytmas yiwi xemsa n yeryazen, iqeddem as ten i firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Xenni inna firɛun i yaytmas: “Min teɛna řxedmet i tᵉtteggem?” Nitni arrin-dd x firɛun: “Imsexxaren nnec d imeksawen n wuǧi, am neccin am řejdud nneɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nnan ɛawed i firɛun: “I tzeddiɣt di temmurt-a am ibarraniyyen i dd-nusa, minzi war yeǧi wefsu i wuǧi n imsexxaren nnec, minzi řaẓ iqseḥ di temmurt n Kenɛan. Xenni řexxu, nettzaweg i cek, ejj imsexxaren nnec ad zedɣen di temmurt n Jucan!” ");
INSERT INTO rifl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Uca issiweř firɛun ak-d Yusuf, inna: “Babac d aytmac usin-dd ɣarek. ");
INSERT INTO rifl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tammurt n Miṣra aqa-tt nnec marra. Ejj babac d aytmac ad zedɣen di temmurt iṣebḥen, ejj i-ten ad zedɣen di temmurt n Jucan uca mařa tḥekkared belli aqa jar asen iryazen iwengiten, ggem ten d imeḥḍayen x řebhayem inu.” ");
INSERT INTO rifl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Uca indeh Yusuf babas, iqeddem i-t i firɛun uca Yaɛqub ibarek firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Inna firɛun i Yaɛqub: “Mechař ɣarek n iseggʷusa?” ");
INSERT INTO rifl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaɛqub yarra-dd x firɛun: “Mya u-třatin n iseggʷusa i ddareɣ d abarrani. Ussan n iseggʷusa n tudart inu yuqřiřen u ccuren s řɣar. War iwiḍen ca wussan n iseggʷusa n tudart n řejdud inu deg wussan n lɣurba nsen.” ");
INSERT INTO rifl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Xenni Yaɛqub ibark firɛun uca iffeɣ ssenni zzat i wudem n firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Isscen Yusuf tazeddiɣt i babas d aytmas, iwca asen tasɣart di temmurt n Miṣra, zi lemliḥ n temmurt, di temmurt n Raɛamsis am mammec t iweṣṣa firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Iɛewweř Yusuf babas d aytmas d marra taddart n babas. Iɛewweř uřa d macca i iḥenjiren imeẓyanen. ");
INSERT INTO rifl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aɣrum tuɣa war iǧi di temmurt marra, minzi řaẓ tuɣa iqseḥ aṭṭas, ařami tiweḍ temmurt n Miṣra d temmurt n Kenɛan fennant s řaẓ. ");
INSERT INTO rifl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Xenni iyru Yusuf marra nnuqart nni ittwafen di temmurt n Miṣra u di temmurt n Kenɛan deg ubeddeř n imendi i isɣin. Igga Yusuf nnuqart nni di taddart n firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Umi teqḍa nnuqart zi temmurt n Miṣra d temmurt n Kenɛan, usin-dd marra Imiṣriyyen ɣar Yusuf nnan: “Ewc aneɣ aɣrum, maɣar mayemmi ɣa nemmet zzatek? War din ɛad ca nnuqart.” ");
INSERT INTO rifl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusuf inna: “Mařa war ɣarwem bu nnuqart ɛad, wcem xenni řebhayem nwem u necc ad awem wceɣ macca deg ubeddeř n řebhayem nwem.” ");
INSERT INTO rifl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nitni iwyen-dd řebhayem nsen ɣar Yusuf uca iwca asen Yusuf aɣrum deg wemcan n iysan d wuǧi d ifunasen d tfunasin d yeɣyař nsen uca issecc i-ten s weɣrum deg wemcan n marra řebhayem nsen deg useggʷas nni. ");
INSERT INTO rifl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Umi iɛdu useggʷas nni, usin-dd ɣares deg useggʷas wiss tnayen uca nnan as: “War nᵉtteffar ca x sidi inu belli aqa nnuqart nneɣ teqḍa uca řebhayem aqa atent deg ufus n sidi inu. War iqqim walu zzat i wudem n sidi inu, mɣir arrimet nneɣ d iyyaren nneɣ. ");
INSERT INTO rifl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mayemmi ɣa nemmet zzat i tiṭṭawin nnec, uřa d neccin uřa d iyyaren nneɣ? Seɣ aneɣ, tesɣed tammurt nneɣ i weɣrum uca neccin d temmurt nneɣ ad niři d imsexxaren n firɛun. Ewc aneɣ zzariɛet ḥima ad neddar war nettmetti ca uca tammurt war tᵉddikkwiř d amessuci!” ");
INSERT INTO rifl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Xenni isɣa Yusuf marra tammurt n Miṣra i firɛun, minzi Imiṣriyyen zzenzen marra iyyar nsen, minzi tuɣa řaẓ iqseḥ xasen. U ammu i tedweř temmurt d agřa n firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Uca issmuṭṭiy řgens zeg uneggaru n weymir ař aneggaru nneɣni n weymir n Miṣra ɣar tneddam. ");
INSERT INTO rifl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mɣir tammurt n ikehhanen war tt isɣi ca. Aqa ikehhanen ɣarsen ict n řmunet zi firɛun, nitni ttᵉtten tasɣart nsen, tenni i d asen iwca firɛun. X uya war zzenzen ca tammurt nsen. ");
INSERT INTO rifl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Xenni inna Yusuf i řgens: “Xzar, ass-a necc sɣiɣ kenniw uřa d tammurt nwem i firɛun. Xzarem, aqa da zzariɛet nwem. Zarɛem zzayes tammurt! ");
INSERT INTO rifl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Zi řɣiǧet ad tewcem tasɣart texmusect i firɛun u arebɛa n tseqqar i iqqimen ad iřint i yixef nwem d zzariɛet i yeyyar uca ad iřint, maḥend ad zzaysent teccem kenniw ak-d aytbab n taddart nwem u ɛawed, maḥend ad zzaysent ccen iḥenjiren imeẓyanen nwem.” ");
INSERT INTO rifl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nitni nnan: “Cek teḥḍid tudart nneɣ. Ejj aneɣ ad naf arḍa di tiṭṭawin n sidi inu uca neccin ad niři d imsexxaren i firɛun.” ");
INSERT INTO rifl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Igga Yusuf man aya d tawṣeyyet i din iǧan ař ass-a, belli ict n tesɣart n texmusect n řɣiǧet n temmurt n Miṣra ad tiři i firɛun. Mɣir iyyaren n ikehhanen qqimen d agřa nsen, war ddikkwiřen ca d agřa n firɛun. ");
INSERT INTO rifl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ammu i izdeɣ Israil di temmurt n Miṣra, di temmurt n Jucan, mellken dayes uca wcin řɣiǧet uca ktaren s yijj n cckel imɣar. ");
INSERT INTO rifl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iddar Yaɛqub di temmurt n Miṣra sbeɛṭac n iseggʷusa uca tuɣa ussan n Yaɛqub, iseggʷusa n tudart nnes, mya u-sebɛa u-rebɛin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Umi dd-iwḍen wussan i Israil ad immet, iřaɣa-dd x Yusuf mmis, inna as: “Mařa ufiɣ arḍa di tiṭṭawin nnec, ttzawageɣ cek, ad tegged afus nnec sadu tmeṣṣaḍt inu uca egg akidi s tmexsiwt icewwaren d řaman u war d ayi neṭṭeř ca di Miṣra, ");
INSERT INTO rifl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","maca xmi ɣa ggeɣ ad areyyḥeɣ jar řejdud inu, xenni awi ayi zi Miṣra uca nḍeř ayi deg wenḍeř nsen. Yarra-dd xas: “Necc ad ggeɣ min tennid!” ");
INSERT INTO rifl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Xas uca inna as: “Jaǧ ayi!”, uca ijjuǧ as. Řexdenni yuḍar Israil x uzeǧif n qama. ");
INSERT INTO rifl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Awarni man aya imsar, ittwanna i Yusuf: “Xzar, aqa babac iḥřec!” Xenni iksi akides tnayen n iḥenjiren nnes Manassa d Ifrayim. ");
INSERT INTO rifl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Xebbaren Yaɛqub, nnan: “Xzar, aqa mmic Yusuf ad ɣarek dd-yas!” Xenni igga Israil uř deg ixef nnes uca ikkar iqqim x qama. ");
INSERT INTO rifl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Xenni inna Yaɛqub i Yusuf: “Arebbi, Amzemmar x kuřci, aqa iban ayi-dd di Luz, di temmurt n Kenɛan, u aqa Netta ibark ayi. ");
INSERT INTO rifl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","U aqa Netta inna ayi: “Xzar, ad cek arreɣ ad tegged řɣiǧet uca ad cek kettareɣ, ad cek ggeɣ d ijj n wegraw n řegnus, ad ac wceɣ tammurt-a d agřa i řebda u i zzariɛet nnec awarni ac. ");
INSERT INTO rifl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Uca řexxu, aqa tnayen n iḥenjiren nnec, Ifrayim d Manassa, inni d ac dd-ittwaxeřqen di temmurt n Miṣra qbeř i ɣarek dd-usiɣ di temmurt n Miṣra, aqa aten inu, am Rubin d Cimɛun i iǧan inu. ");
INSERT INTO rifl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Maca inni d ac dd-ittwaxeřqen awarni asen, ad iřin nnec. Ad ttwasemman x yisem n aytmatsen di řwart nsen. ");
INSERT INTO rifl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Umi dd-usiɣ zi Fadan-Aram, temmut Raḥil zzati di temmurt n Kenɛan deg webrid, řami tuɣa ɛad war tiggʷij x Ifrata. Neḍřeɣ tt din deg webrid ɣar Ifrata!”, aqa-tt d Bayt-Laḥm. ");
INSERT INTO rifl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Iẓra Israil iḥenjiren n Yusuf, inna: “Min ɛnan ina?” ");
INSERT INTO rifl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yarra-dd Yusuf x babas: “D iḥenjiren inu i d ayi iwca AREBBI danita.” Inna as: “Sqarrbem ten-dd ɣari uca ad ten barkeɣ!” ");
INSERT INTO rifl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tuɣa tiṭṭawin n Israil uẓɣent s tewsar, war iqqim ittwařa. Issqarreb as ten-dd, xenni issudem i-ten, idarreɛ asen. ");
INSERT INTO rifl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Inna Israil i Yusuf: “War d ayi ittɣiř ad ẓareɣ ɛad udem nnec. Xzar, AREBBI igga ayi ad ẓareɣ ɛad tarwa nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Xenni issḍar i-ten Yusuf x ifadden nnes uca ibendeq s wudem nnes ɣar temmurt. ");
INSERT INTO rifl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Uca iksi i-ten Yusuf s tnayen idsen, Ifrayim s ufusi nnes arendad n uzeřmaḍ n Israil u Manassa s uzeřmaḍ nnes arendad n ufusi n Israil uca issqarreb as ten-dd. ");
INSERT INTO rifl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Isswiẓẓeḍ Israil yefus nnes, issars i-t x uzeǧif n Ifrayim, waxxa tuɣa-t d amaẓuẓ, d azeřmaḍ nnes x uzeǧif n Manassa. Issars ammu ifassen nnes mammec nneɣni neɛmada, waxxa Manassa tuɣa-t d amenzu. ");
INSERT INTO rifl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Israil ibark Yusuf, inna: “D AREBBI, wenni umi řejdud inu, Ibrahim d Isḥaq, uyuren zzates, AREBBI, wenni iǧan d Ameksaw inu zeg wami ǧiɣ ař ass-a,    ");
INSERT INTO rifl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","lmalak nni d ayi ifdin zi marra tuɛeffna, iři netta ad ibark iḥenjiren-a u iři ad ittwařaɣa isem inu daysen uřa d isem n řejdud inu, Ibrahim d Isḥaq. Iři ad mmarenyen ař ɣa dewřen d ijj n ubarru am iseřman deg waman di řwesṭ n temmurt!”    ");
INSERT INTO rifl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Umi iẓra Yusuf, belli babas igga afus afusi nnes x uzeǧif n Ifrayim, tuɣa-tt d ict n řeɛřamet war teḥḥři ɣares di tiṭṭawin nnes uca iṭṭef afus n babas, ḥima ad t ibeddeř zeg uzeǧif n Ifrayim ɣar uzeǧif n Manassa. ");
INSERT INTO rifl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Inna Yusuf i babas: “War ttegg ca ammu, a baba, minzi d wa d amenzu, egg afusi nnec x uzeǧif nnes.” ");
INSERT INTO rifl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Maca babas war ixs ca, inna: “Ssneɣ, a mmi, ssneɣ. Ɛawed netta ad idweř d ijj n řgens, ad imɣar ɛawed, maca umas amaẓuẓ ad yiři ktar zzayes, zzariɛet nnes ad tedweř d tacurret n řegnus.” ");
INSERT INTO rifl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Uca ammu i ten ibarek deg wass nni, inna: “Dayek, deg yisem nnek, a Yusuf ad ibarek řgens Israil, ad inin: ‘Ad kenniw yarr AREBBI am Ifrayim d Manassa!’” Uca yarra Ifrayim ad ibedd zzat i Manassa. ");
INSERT INTO rifl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Awarni as inna Israil i Yusuf: “Xzar, ad mmteɣ, maca AREBBI ad yiři akidwem, ad kenniw issmuṭṭiy ɣar temmurt n řejdud nwem. ");
INSERT INTO rifl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Aqa wciɣ ac ict n tesɣart n idurar x min wciɣ i yaytmac, tenni ksiɣ necc zeg ifassen n Imuriyyen s ssif d řqews inu.” ");
INSERT INTO rifl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Iřaɣa Yaɛqub x iḥenjiren nnes, inna: “Smunem-dd ixef nwem, ad awem iniɣ min d awem ɣa imsaren deg uneggar n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Smunem-dd ixef nwem uca sřem, a tarwa n Yaɛqub, sřem i Israil, babatwem. ");
INSERT INTO rifl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubin, cek d amenzu inu, jjehd inu, d amezwar n teryast inu, aqa cek d amseḍfar inu di řuɛřa, d amseḍfar inu di řɛezz. ");
INSERT INTO rifl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Cek amecnaw aman ittneqřaben, war dd ayi tḍeffared, aqa cek tgeɛɛded ɣar řectu n řemřac n babac, řexdenni tessfeḍḥed t, aqa ɣar řectu inu igeɛɛed. ");
INSERT INTO rifl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Cimɛun d Lawi d awmaten! Řemwas nsen d řesnaḥ n lɛunf. ");
INSERT INTO rifl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Di tmeɛmuč nsen war ittidef řeɛmar inu deg wegraw nsen war icarrec wuř inu. Aqa deg uxeyyeq nsen nɣin ijj n weryaz uca iɛjeb asen ad qessen iẓewran n iḍaren n ufunas. ");
INSERT INTO rifl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","D amenɛuř axeyyeq nsen, minzi wanita ijhed aṭṭas, uřa d aduqqez n ufugem nsen, minzi iqseḥ. Necc ad ten bḍiɣ x Yaɛqub, ad ten ssuyuseɣ di Israil. ");
INSERT INTO rifl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda, aytmac ad cek ssemɣaren. Afus nnec ad yiři x yiri n řɛedyan nnec u iḥenjiren n babac ad ac bendqen. ");
INSERT INTO rifl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuda d ijj n mmis n wayrad. Zi zzardet i tuřyed, a mmi. Iqwes amecnaw ayrad u amecmaw tayradt. Wi izeɛɛemen ad t-dd-issfaq? ");
INSERT INTO rifl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Taɣɣarct n řḥakem war ittwakkes x Yahuda uřa d azeǧaḍ n ṣṣulṭa zi jar iḍaren nnes, ař dd ɣa yas wenni i ɣa iwcen arraḥet uca ad as ṭaɛen řegnus. ");
INSERT INTO rifl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iqqen ɣar tzayart asnus nnes d mmis nnes n teɣyuč ɣar tzayart icennɛen aṭṭas, issird arruḍ nnes di binu u arruḍ nnes deg idammen n uḍiř. ");
INSERT INTO rifl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Tiṭṭawin nnes d tibarcanin s binu u tiɣmas nnes d ticemřařin s uɣi. ");
INSERT INTO rifl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulun ad izdeɣ ɣar tma n řebḥar, ad yiři d řmuyyi i iɣarruba. Aɣezdis nnes ad yareyyeḥ x Ṣidun. ");
INSERT INTO rifl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar d ijj n weɣyuř iqseḥ, izzeř jar tnayen n řmedwat. ");
INSERT INTO rifl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Umi iẓra arraḥet d lemliḥ u tammurt aqa tarecceq, iqwes, igga tiɣarḍin nnes maḥend ad yarbu arrmeḥ uca ammu i idweř sadu azayřu n ismeɣ. ");
INSERT INTO rifl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan ad iḥkem řgens nnes am yict zi tqebbař n Israil. ");
INSERT INTO rifl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ad yiři Dan d afiɣar deg webrid, tařefsa deg umesruq, wenni izeɛɛfen deg inirzawen n uyis, ař ɣa iwḍa wenni xas inyin ɣar ḍeffar. ");
INSERT INTO rifl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Asenjem nnec i ttrajiɣ, a SIDI! ");
INSERT INTO rifl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Jad, ad xas ḥejment bandiyyat, maca ad xasen idarrec. ");
INSERT INTO rifl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Acir, aɣrum nnes ad yiři d aɣrum ismen, netta ad iqeddem macca yiziden igellden. ");
INSERT INTO rifl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali d ict n tudadt ittwaḍeřqen, issuffuɣ awařen cnan. ");
INSERT INTO rifl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf d mmis n tcejjart itticen řɣiǧet, mmis n tcejjart itticen řɣiǧet ɣar tařa. Yessis ggurent x weɣbar. ");
INSERT INTO rifl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nitni ssarezgen xas tudart, neyycen xas, wah imjebbaden n řqews ḍfaren t, ");
INSERT INTO rifl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","maca řqews nnes iqqim imḥeḍ u iɣaǧen n ifassen nnes qqimen arxun s ifassen n Umzemmar n Yaɛqub - x uya Netta d Ameksaw d taṣḍart n Israil - ");
INSERT INTO rifl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","s Arebbi n babac wenni cek i ɣa iɛawnen, Amzemmar x kuřci, wenni cek i ɣa ibarken s lbarakat n ujenna sennej, s lbarakat n waman ihewřen i din iǧan swadday, s lbarakat n tubbect d řemřawet. ");
INSERT INTO rifl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Lbarakat n babac d timeqqranin uɛřant x lbarakat n yinni d ayi dd-yejjin uca ttakkwaḍent ɣar tqiccatin n tewririn n řebda. Ad iřint x uzeǧif n Yusuf, x tuccent n ucuwwaf n wenni yarebbu ttaj n weɛzar jar aytmas . ");
INSERT INTO rifl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamin d ijj n wuccen ittmezzaq. Ɣar ṣṣbeḥ ad isarḍ zzardet u s ǧiřet ibeṭṭa takeccaḍt.” ");
INSERT INTO rifl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Marra ina d tenɛac n tqebbař n Israil. D man aya min d asen inna babatsen uca ibark i-ten, wah, ibark i-ten, kuř ijj s lbaraka nnes. ");
INSERT INTO rifl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yumur i-ten, inna asen: “Ad mmarenyeɣ ɣar řgens inu. Neḍřem ayi ak-d řejdud inu deg ifri wenni iǧan deg iyyar n Ifrun, Aḥitti, ");
INSERT INTO rifl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","deg ifri wenni iǧan deg iyyar n Makfila i iǧan zzat i Mamri di temmurt n Kenɛan, tenni isɣa Ibrahim ak-d yeyyar zi Ifrun, Aḥitti, ḥima ad yiři d anḍeř nnes. ");
INSERT INTO rifl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Dinni i neḍřen Ibrahim d Sara tamɣart nnes. Dinni i neḍřen Isḥaq d temɣart nnes Rifqa. U necc neḍřeɣ din Liya. ");
INSERT INTO rifl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Iyyar s ifri i tuɣa dayes iǧan immseɣ x tarwa n Ḥit.” ");
INSERT INTO rifl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Umi ikemmeř Yaɛqub ad iweṣṣa iḥenjiren nnes, ikemmec iḍaren nnes di qama, iffeɣ i-t buḥbeř uca immarni ɣar řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Xenni ingez Yusuf x uɣembub n babas, iru xas uca issudem i-t. ");
INSERT INTO rifl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yumur Yusuf i imsexxaren nnes, iḍbiben, ad ḥennḍen babas uca iḍbiben ḥennḍen Israil. ");
INSERT INTO rifl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Arebɛin n wussan i dayes kkin, minzi ḥdajen ussan nni maḥend ad kemmřen aḥenneṭ uca run marra Imiṣriyyen sebɛin n wussan di ssibbet nnes. ");
INSERT INTO rifl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Umi ɛdun wussan n řeɛzat xas, issiweř Yusuf ak-d yenni n taddart n firɛun, inna: “Mařa ufiɣ řexxu arḍa di tiṭṭawin nwem, ttzawageɣ kenniw, ad tessiwřem deg imejjan n firɛun, inim: ");
INSERT INTO rifl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Baba inu ijja ayi ad jjaǧeɣ uca inna: ‘Aqa ttmettiɣ. Ittxeṣṣa ad ayi tneḍřed deg wenḍeř nni neqceɣ i yixef inu di temmurt n Kenɛan!’ Xenni, ttzawageɣ, ejj ayi ad raḥeɣ řexxu ad neḍřeɣ baba uca awarni man aya ad dd-ɛeqbeɣ.” ");
INSERT INTO rifl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Uca inna firɛun: “Ruḥ, nḍeř babac, am mammec yarra cek ad as tejjuǧed.” ");
INSERT INTO rifl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Uca igeɛɛed Yusuf ḥima ad inḍeř babas uca geɛɛden marra imsexxaren n firɛun akides, imɣaren n taddart nnes d marra imɣaren n temmurt n Miṣra, ");
INSERT INTO rifl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","uřa d marra taddart n Yusuf d aytmas nnes d taddart n babas. Mɣir iḥenjiren imeẓyanen nsen d wuǧi nsen d ifunasen d tfunasin nsen jjin ten di temmurt n Jucan. ");
INSERT INTO rifl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Geɛɛden akides ikarruten d yinni inyin x yeysan uca ggin ijj n uqarru n řɛeskar imɣar. ");
INSERT INTO rifl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Umi iwḍen ɣar unedrar n Atad, wenni iǧan x ujemmaḍ n L’Urdun, ssgeɛɛden din ict n tɣuyyit temɣar, tejhed aṭṭas uca igga Yusuf din ijj n wecḍan x babas i yijj n řmijař n sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ẓrin imezdaɣ n temmurt, ayt n Kenɛan, acḍan deg unedrar n Atad, nnan: “Wa d acḍan imɣar n Imiṣriyyen.” X uya řaɣan isem nnes Abal-Miṣrayim, wenni iǧan x ujemmaḍ n L’Urdun. ");
INSERT INTO rifl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ggin as iḥenjiren nnes am mammec ten iweṣṣa. ");
INSERT INTO rifl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Arbun t iḥenjiren nnes ɣar temmurt n Kenɛan, neḍřen t deg ifri deg iyyar n Makfila nni isɣa Ibrahim ak-d yeyyar zi Ifrun, Aḥitti, arendad n Mamri, maḥend ad yiři d anḍeř nnes. ");
INSERT INTO rifl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Awarni řami inḍeř babas, iɛqeb Yusuf ɣar Miṣra, netta d yaytmas d marra inni akides dd-igeɛɛden, maḥend ad neḍřen babas. ");
INSERT INTO rifl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Umi ẓrin aytmas n Yusuf babatsen immut, nnan: “Mařa icarh aneɣ Yusuf, ad aneɣ ixeǧeṣ nican marra řɣar nni dayes negga.” ");
INSERT INTO rifl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","S uyenni ssekken ad xebbaren Yusuf s man aya, nnan: “Babac iweṣṣa qbeř řmewt nnes, inna: ");
INSERT INTO rifl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ammu i ɣa tinim i Yusuf: Ttzawgeɣ cek, ɣfar řexxu axeṭṭu n aytmac d ddenb nsen d řɣar i d ac ggin. Ɣfar řexxu axeṭṭu n imsexxaren n AREBBI n babac!’” Uca isɣuy Yusuf am kis ssiwřen ammu. ");
INSERT INTO rifl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Xenni usin-dd ɛawed aytmas s yixef nsen, wḍan as zzat i uɣembub nnes, nnan: “Aqa-neɣ da d imsexxaren nnec!” ");
INSERT INTO rifl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yarra-dd xasen Yusuf: “War tteggʷdem ca! Ma aqa ayi necc deg wemcan n AREBBI? ");
INSERT INTO rifl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Waxxa kenniw txarrṣem dayi s řɣar, aqa AREBBI inwa zzayes řxar, ḥima ad yegg am mammec i teǧa ass-a, ad yejj di tudart ijj n řgens d ameqqran. ");
INSERT INTO rifl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Řexxu, war tteggʷdem ca! Necc ad kenniw ɛewwřeɣ, kenniw d iḥenjiren imeẓyanen nwem.” Ammu ten issfewwej uca issiweř akidsen ɣar wuřawen nsen. ");
INSERT INTO rifl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Tuɣa Yusuf izeddeɣ di Miṣra, netta d taddart n babas, uca iddar Yusuf mya u-ɛecra n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iẓra Yusuf iḥenjiren n Ifrayim ař jjiř wiss třata. Aqa ttwarwen-dd iḥenjiren n Makir, mmis n Manassa, ɛawed x ifadden n Yusuf. ");
INSERT INTO rifl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Uca inna Yusuf i yaytmas: “Necc ad mmteɣ, maca AREBBI ad kenniw yarzef s tidett uca ad kenniw issgeɛɛed zi temmurt-a ɣar temmurt i iwaɛd s tjaǧit i Ibrahim d Isḥaq d Yaɛqub.” ");
INSERT INTO rifl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Xas uca issjjuǧ Yusuf ayt n Israil, inna: “AREBBI ad kenniw yarzef s tidett uca xenni ad teksim ssa iɣsan inu!” ");
INSERT INTO rifl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Immut Yusuf umi tuɣa ɣares mya u-ɛecra n iseggʷusa. Ḥennḍen t uca ssarsen t di řmeḥmeř n umettin di Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ina d ismawen n ayt n Israil i dd-yiwḍen ak-d Yaɛqub ɣar Miṣra. Yusa-dd kuř ijj zzaysen ak-d aytbab n taddart nnes:    ");
INSERT INTO rifl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubin, Cimɛun, Lawi d Yahuda, ");
INSERT INTO rifl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zabulun d Binyamin, ");
INSERT INTO rifl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan d Naftali, Jad d Acir. ");
INSERT INTO rifl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Marra řeɛmur nni dd-iffɣen zi tmeṣṣaḍt n Yaɛqub, tuɣa aten di sebɛin. Yusuf tuɣa-t di Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Immut Yusuf d marra aytmas, d jjiř nni marra. ");
INSERT INTO rifl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mmarenyen ayt n Israil u jjin-dd řɣiǧet ařami zzaysen tesfuffi temmurt uca ttwaktaren uca dewřen jehden aṭṭas, minzi teccur zzaysen temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Iffeɣ-dd xenni ijj n ujeǧid d jdid iḥekkem x Miṣra, wenni tuɣa war issin Yusuf. ");
INSERT INTO rifl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Inna i řgens nnes: “Xzar, řgens n ayt n Israil imɣar u ijhed xaneɣ. ");
INSERT INTO rifl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Řexxu, aqa ad xas neḥkem s řeɛqeř, ḥima war ittmarni řgens ktar, uca, mařa imsar ikkar ca n řbaruḍ, ad idweř ak-d řɛedyan nneɣ, ad yegg řḥarb akidneɣ uca xenni ad iffeɣ zi temmurt.” ");
INSERT INTO rifl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nitni ggin xasen imeḥḍayen x warbar n tesmuɣi, ḥima ad ssdeǧen řgens s ddquřat i xasen ssarebbun. Bnan i firɛun, ajeǧid, tineddam n řexzen: Fitum d Raɛamsis. ");
INSERT INTO rifl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Maca mecḥař ma deǧen nitni řgens, amenni i igma u ibezzeɛ řgens, ařami iwḍen nitni ad carhen ayt n Israil aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Uca arrin Imiṣriyyen ayt n Israil d isemɣan s uɣiř ");
INSERT INTO rifl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","uca ssarezgen tudart nsen s tesmuɣi iqesḥen deg ubeǧaɛ d llajur uřa di marra tesmuɣi deg iyyaren. Marra tasmuɣi i ggin nitni di řwest nsen, tuɣa tt s uɣiř. ");
INSERT INTO rifl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Issiweř ujeǧiḍ n Miṣra ak-d řqabřat tiɛibraniyyin, icten zzaysent qqaren as Sifra, u tenneɣni qqaren as Fuɛat. ");
INSERT INTO rifl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Inna: “Xmi ɣa tɛawnent timɣarin tiɛibraniyyin ad arwent, uca ad texzarent xmi ttɣimant x iẓra maḥend ad arwent, ittxeṣṣa kennint ad nɣent aḥenjir mařa d mmis, maca mařa d yeǧis, jjent tt ad teddar!” ");
INSERT INTO rifl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Maca řqabřat tuɣa tteggʷedent AREBBI, war ggint muxas tent yumur ujeǧid n Miṣra, maca ḥḍant tudart n iḥenjiren. ");
INSERT INTO rifl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Xenni iřaɣa ujeǧid n Miṣra i řqabřat, inna asent: “Maɣar teggint aya, aqa teḥḍant tudart n iḥenjiren?” ");
INSERT INTO rifl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Řqabřat arrint x firɛun: “Tiɛibraniyyin war ǧint am Timiṣriyyin, minzi nitenti jehdent, ttarwent qbeř ma ad ɣarsent dd-tas řqabřa.” ");
INSERT INTO rifl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Uca AREBBI igga mliḥ i řqabřat uca immarni řgens, dewřen jehden s waṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Minzi řqabřat ggʷedent AREBBI, imsar, aqa yarzeq i-tent-i-dd s tudrin ak-d řwacun. ");
INSERT INTO rifl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Řexdenni yumur firɛun marra řgens nnes, inna: “Kuř aḥenjir i dd ɣa ixeřqen ad t tenḍarem deg iɣzar u marra taḥenjirt i dd ɣa ixeřqen ad tt tejjem ad teddar.”   * ");
INSERT INTO rifl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Uca iffeɣ ijj n weryaz zi raǧ n taddart n Lawi, yiwi ict n tḥenjirt n Lawi d tamɣart. ");
INSERT INTO rifl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Teksi temɣart s ddeyset uca turuw-dd aḥenjir. Umi teẓra belli iṣbeḥ uḥenjir, teffar i-t třata n iyuren.    ");
INSERT INTO rifl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Umi war tezmar ɛad ad t teffar, teksi as-dd ict n tsenduqt n uɣanim, tebra i-tt s ucarmuḍ d tizeft uca tessars dayes aḥenjir, tegga tasenduqt nni jar uɣanim x tma n iɣzar. ");
INSERT INTO rifl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tbedd wučmas ɣar řaggʷaj, maḥend ad tẓar min zzayes ɣa ggen. ");
INSERT INTO rifl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","U xzar, tehwa yeǧis n firɛun, maḥend ad tessird ixef nnes deg iɣzar. Tuɣa timsexxarin tibřiɣin nnes ggurent x tma n iɣzar. Nettat teẓra tasenduqt deg uɣanim uca tessekk tismeɣt nnes uca teksi tt-i-dd. ");
INSERT INTO rifl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ařami tt tarzem, teẓra aḥenjir nni, uca xzar, aḥenjir tuɣa ittru. Yudef i-tt uziǧez, tenna: “Wa d ijj zeg iḥenjiren n Iɛibraniyyen!” ");
INSERT INTO rifl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Řexdenni tenna učmas i yeǧis n firɛun: “Ma ad raḥeɣ ad řaɣiɣ x ict n temsuḍeḍt zi Tɛibraniyyin maḥend ad am tessuṭṭeḍ aḥenjir?” ");
INSERT INTO rifl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Tenna as yeǧis n firɛun: “Ruḥ!” Truḥ teɛzarect, třaɣa i yemmas n uḥenjir. ");
INSERT INTO rifl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Řexdenni tenna as yeǧis n firɛun: “Awi-dd aḥenjir-a, tessuṭṭeḍ i-t i necc u necc ad cem xeǧṣeɣ.” Teksi temɣart aḥenjir uca tessuṭṭeḍ i-t. ");
INSERT INTO rifl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Umi igma uḥenjir, tiwyi i-t ɣar yeǧis n firɛun, idweř as am mmis uca tegga as Musa, tenna: “Aqa jebdeɣ t-i-dd zeg waman.” ");
INSERT INTO rifl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Deg wussan nni imsar, umi igma Musa, aqa iffeɣ-dd ɣar aytmas, uca iẓra ddquřat i xasen ssarebbun. Iẓra ijj n Umiṣri iccat ijj n Uɛibrani, ijjen zeg aytmas. ");
INSERT INTO rifl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ixzar da d diha, iẓra belli war din ḥed, xenni inɣa Amiṣri nni uca issnuffar i-t deg ijdi. ");
INSERT INTO rifl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Umi dd-iffeɣ tiwecca nnes, iẓra tnayen n yeryazen Iɛibraniyyen ttmenɣan. Inna Musa i uɛeffan nni ittɛeddan: “Maɣar teccated jjar nnec?” ");
INSERT INTO rifl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Inna netta: “Wi i cek iggin d řḥakem d řqaḍi xaneɣ? Ma cek teqqared aya umi cek tenwid ad ayi tenɣed am mammec tenɣid Amiṣri?” Řexdenni iggʷed Musa, inna: “S tidett tamesřact tᵉttwassen!” ");
INSERT INTO rifl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Umi isřa firɛun man aya, yarzu ad ineɣ Musa. Maca Musa yarweř zi firɛun uca izdeɣ di temmurt n Midyan uca iqqim din ɣar ijj n wanu. ");
INSERT INTO rifl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Akehhan n Midyan tuɣa ɣares sebɛa n yessis, tinni i dd-yusin ad ayment aman din uca ccurent sswarej, ḥima ad wardent uǧi n babatsent. ");
INSERT INTO rifl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Usin-dd imeksawen uca uẓẓřen xasent. Ikkar Musa řexdenni, ifekk i-tent, iward uǧi nsent. ");
INSERT INTO rifl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Umi dewřent ɣar babatsent umi qqaren Raɛuyil, inna asent: “Mayemmi dd-ttɛeqbent ass-a deɣya?” ");
INSERT INTO rifl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nitenti arrint-i-dd xas: “Ijj n weryaz d Amiṣri ifekk aneɣ zeg ifassen n imeksawen uca ɛawed yuyem aneɣ-dd aṭṭas n waman uca iward uǧi.” ");
INSERT INTO rifl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Inna i yessis: “I mani yeǧa? Mayemmi tejjint aryaz nni din? Ruḥent řaɣant-i-dd xas ḥima ad icc aɣrum!” ");
INSERT INTO rifl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Uca iqbeř Musa ad izdeɣ ak-d weryaz nni uca netta iwca as i Musa yeǧis Ṣaffura d tamɣart. ");
INSERT INTO rifl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Tejja as-dd aḥenjir, igga as Jarcum, minzi inna: “Necc tuɣa ayi d aɣrib deg ict n temmurt d taɣribt xafi.”    ");
INSERT INTO rifl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Řami teɛdu waṭṭas n řweqt, immut ujeǧid n Miṣra uca weḥweḥen ayt n Israil di tesmuɣi i di tuɣa ddaren, ssɣuyen uca iɣuyyan nsen geɛɛden ɣar AREBBI zi tesmuɣi nsen. ");
INSERT INTO rifl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Uca issḥess AREBBI i tɣuyyit nsen uca ixarreṣ AREBBI di Řɛahd nnes ak-d Ibrahim u ak-d Isḥaq u ak-d Yaɛqub. ");
INSERT INTO rifl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ixzar AREBBI ɣar ayt n Israil uca yargeb AREBBI x řeɣben nsen. ");
INSERT INTO rifl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Yarwes Musa uǧi n Yitru, aḍeggʷař nnes, akehhan n Midyan. Indeh uǧi awarni i řexřa uca yiwiḍ-dd ɣar wedrar n AREBBI, ɣar Ḥurib. ");
INSERT INTO rifl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Iban as-dd lmalak n SIDI deg ijj n uceɛɛuř di řwesṭ n ijj n cbarq ak-d isennanen, u xzar, netta iẓra belli cbarq ak-d isennanen tuɣa tekkar dayes tmessi, maca cbarq war ittwacmeḍ ca. ");
INSERT INTO rifl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Inna Musa: “Ejj ayi ad qewseɣ cwayt, maḥend ad ẓareɣ tameẓriwt nni tameqqrant, mayemmi cbarq ak-d isennanen war icemmeḍ ca.” ");
INSERT INTO rifl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Řami iẓra AREBBI belli ijja abrid, maḥend ad iẓar man aya, iřaɣa-dd xas AREBBI zi řwesṭ n cbarq ak-d isennanen, inna: “Musa, Musa!” Netta yarra: “Aqa ayi da!” ");
INSERT INTO rifl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Xenni inna Netta: “War dd-ttqarrab ca danita! Kkes tisiřa nnec zeg iḍaren nnec, minzi amcan i xef tbedded, aqa-t d tammurt tqeddes.” ");
INSERT INTO rifl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Inna ɛawed: “Necc d AREBBI n babac, AREBBI n Ibrahim, AREBBI n Isḥaq d AREBBI n Yaɛqub.” Řexdenni issduriy Musa aɣembub nnes, minzi iggʷed ad isweḍ di AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Inna SIDI: “Aqa ẓriɣ řmeḥnet i di iddar řgens inu i iǧan di Miṣra uca sřiɣ iɣuyyan nsen zzat i imzeyyaren nsen, aqa ssneɣ tamara nsen. ");
INSERT INTO rifl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hwiɣ-dd ḥima ad fekkeɣ řgens zeg ifassen n Imiṣriyyen, ad t ssuffɣeɣ zi temmurt nni ɣar ict n temmurt teṣbeḥ d tmiriwt, ɣar ict n temmurt ifeyyḍen s uɣi d tamment, ɣar wemcan n ayt n Kenɛan d Iḥittiyyen d Imuriyyen d Ifiriziyyen d Iḥiwiyyen d Iyibusiyyen. ");
INSERT INTO rifl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Xzar řexxu, aqa tiweḍ-dd ɣari tɣuyyit n ayt n Israil uca ɛawed ẓriɣ ddeǧ nsen i zi ten deǧen Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Řexxu xenni, ruḥ, Necc ad cek ssekkeɣ ɣar firɛun u cek ad tsuffɣed řgens inu, ayt n Israil, zi Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Xenni inna Musa i AREBBI: “Min ɛniɣ necc ařami ɣa raḥeɣ ɣar firɛun, ad ssuffɣeɣ ayt n Israil zi Misra?” ");
INSERT INTO rifl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Netta inna as: “Necc ad kik iřiɣ u tanita ad ac tiři d řeɛřamet, belli Necc ssekkeɣ-dd cek: x minni i ɣa tessuffɣed řgens-a zi Miṣra, ad tɛebdem AREBBI x wedrar-a.” ");
INSERT INTO rifl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Xenni inna Musa i AREBBI: “Xzar, xmi dd ɣa awḍeɣ necc ɣar ayt n Israil, ad asen iniɣ: ‘AREBBI n řejdud nwem issekk ayi-dd ɣarwem!’, uca nitni ad ayi sseqsan: ‘Mammec d as qqaren?’, min d asen ɣa iniɣ xenni?” ");
INSERT INTO rifl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Inna AREBBI i Musa: “NECC d NECC i ǧiɣ”. Uca inna ɛawed: “Ammu i ɣa tinid i ayt n Israil: NECC d NECC i ǧiɣ! aqa Netta d Wenni d ayi dd-issekken ɣarwem.” ");
INSERT INTO rifl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Inna AREBBI ɛawed i Musa: “Ammu i ɣa tinid i ayt n Israil: ‘SIDI, AREBBI n řejdud nwem, AREBBI n Ibrahim d AREBBI n Isḥaq d AREBBI n Yaɛqub, issekk ayi-dd ɣarwem. D wa d Isem inu i řebda u Yisem wanita ad yiři i řidaret dayi zi jjiř ař jjiř.’ ");
INSERT INTO rifl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ruḥ, tessmuned imɣaren n Israil, ini asen: ‘SIDI, AREBBI n řejdud nwem, AREBBI n Ibrahim d Isḥaq d Yaɛqub iban ayi-dd, inna: ‘Aqa xawem ḥinneɣ uca ẓriɣ min xawem sseɛdun di Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nniɣ: Necc ad kenniw ssuffɣeɣ zi řmeḥnet di Miṣra ɣar temmurt n ayt n Kenɛan d Iḥittiyyen d Imuriyyen d Ifiriziyyen d Iḥiwiyyen d Iyibusiyyen, ɣar ict n temmurt ifeyyḍen s uɣi d tamment.’ ");
INSERT INTO rifl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ad sřen i tmijja nnec, uca ad traḥed, cek d imɣaren n Israil, ɣar ujeǧid n Miṣra, ad as tinim: ‘SIDI, AREBBI n Iɛibraniyyen, imsagar akidneɣ. Xenni řexxu, ejj aneɣ ad neṭṭef abrid ticři n třata n wussan di řexřa, ḥima ad nqeddem tiɣarṣa i SIDI, AREBBI nneɣ.’ ");
INSERT INTO rifl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Maca Necc ssneɣ belli ajeǧid n Miṣra war kenniw ittejji ad traḥem uřa s ufus ijehden. ");
INSERT INTO rifl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Xenni ad sswiẓẓḍeɣ afus inu, ad wteɣ Miṣra s marra lmuɛjizat inu i dayes i ɣa ggeɣ di řwesṭ nnes, uca awarni i man aya, netta ad kenniw yejj ad traḥem. ");
INSERT INTO rifl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ad ḥinneɣ x řgens-a zzat i tiṭṭawin n Imiṣriyyen uca ad imsar, xmi ɣa traḥem, war tᵉtteffɣem ca s ifassen xwan. ");
INSERT INTO rifl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ad tᵉttar kuř tamɣart zi tajjart nnes u zi tbarranit nni akides izeddɣen di taddart, řeqcuɛ n nnuqart d wureɣ d warruḍ, uca kenniw ad ten teggem x iḥenjiren d tḥenjirin nwem, uca ammu i ɣa tkeccḍem Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Xenni yarra-dd Musa, inna: “Xzar, nitni war dayi ttimnen ca uca war ttesřin ca i wawař inu, minzi ad inin: ‘SIDI war d ac dd-iban ca!’” ");
INSERT INTO rifl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Xenni inna as SIDI: “Min ɣarek deg ufus nnec?” Uca yarra-dd: “D taɣɣarct.” ");
INSERT INTO rifl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Inna: “Nḍar i-tt x temmurt!” Inḍar i-tt x temmurt, tedweř d ijj ufiɣar uca yarweř Musa zzayes. ");
INSERT INTO rifl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Řexdenni inna SIDI i Musa: “Swiẓẓeḍ afus nnec, ṭṭef i-tt zeg unewwar nnes ...” - uca isswiẓẓeḍ Musa afus nnes, iṭṭef i-tt uca tedweř ɛawed d taɣɣarct deg ufus nnes - ");
INSERT INTO rifl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“... ḥima ad amnen belli aqa iban ac-dd SIDI, AREBBI n řejdud nsen, AREBBI n Ibrahim, AREBBI n Isḥaq d AREBBI n Yaɛqub.” ");
INSERT INTO rifl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Inna as SIDI ɛawed: “Sidef afus nnec deg weḥsin nnec.” Uca issidef afus nnes deg weḥsin uca umi t-i-dd-ikkes, xzar, afus nnes ibarṣ am wedfeř. ");
INSERT INTO rifl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Uca inna: “Arr afus nnec ɛawed deg weḥsin!” Yarra afus nnes deg weḥsin uca iɛqeb issuffeɣ i-t-i-dd ɛawed zeg weḥsin, uca xzar, idweř ɛawed am min iqqimen n arrimet nnes. ");
INSERT INTO rifl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Mařa war zzayek uminen ca u war ɣarek dd-ttesřin i min d asen i ɣa tini řeɛřamet tamezwarut, xenni ad amnen di min d asen ɣa tini řeɛřamet taneggarut. ");
INSERT INTO rifl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Mařa nitni war uminen ca di tnayen n řeɛřamat-a u war d ac sřin ca, xenni ksi aman n iɣzar uca farreɣ i-ten x řaẓaɣ u aman nni teksid zeg iɣzar ad dewřen d idammen x řaẓaɣ.” ");
INSERT INTO rifl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Řexdenni inna Musa i SIDI: “A Sidi inu!, necc war ǧiɣ ca d aryaz n bu-tawařin, iḍennaḍ lla, uřa d fariḍennaḍ lla u zeg wami tebdid ad tessiwřed ak-d umsexxar nnec lla, minzi necc ɣari aqemmum ideqřen d iřes ideqřen.” ");
INSERT INTO rifl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Inna as SIDI: “Wi iwcin aqemmum i bnadem? Niɣ wi iggin ḥed d aziynun niɣ d adehcur niɣ d wenni ittwařan niɣ d adarɣař? Ma war iǧi d Necc, SIDI? ");
INSERT INTO rifl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Řexxu, ruḥ din, ad iřiɣ ak-d uqemmum nnec, ad ac ssecneɣ mliḥ min ɣa tinid.” ");
INSERT INTO rifl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Maca netta inna: “A Sidi inu, sekk s ufus nnec man wen i texsed ad tessekked.” ");
INSERT INTO rifl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Řexdenni ittwassarɣ weɣḍab n SIDI x Musa, inna: “Ma war iǧi Harun, Alawi, d umac? Necc ssneɣ, aqa netta issen ad issiweř. Xzar, aqa ad kic imsagar u xmi cek ɣa iẓar, ad ifarḥ wuř nnes. ");
INSERT INTO rifl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Uca cek ad kis tessiwřed, ad as tegged awařen deg uqemmum nnes. Ggur ad iřiɣ ak-d uqemmum nnec d uqemmum nnes, ad awem ssɣareɣ min ɣa tinim. ");
INSERT INTO rifl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Netta ad issiweř ak-d řgens deg wemcan nnec. Ad imsar ammu: netta ad ac yiři amecnaw aqemmum nnec u cek ad tiřid i netta amecnaw AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ad teksid taɣɣarct-a i zi ɣa tegged řeɛřamat deg ufus nnec.” ");
INSERT INTO rifl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Iruḥ Musa uca idweř ɣar uḍeggʷař nnes Yitru, inna as: “Ejj ayi ad raḥeɣ, ad ɛeqbeɣ ɣar aytma nni iǧan di Miṣra, ḥima ad ẓareɣ, ma ɛad ddaren.” Inna Yitru i Musa: “Ruḥ di řehna.” ");
INSERT INTO rifl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Inna SIDI ɛawed i Musa di Midyan: “Řuḥ, tdewřed ɣar Miṣra, minzi aqa mmuten marra inni tuɣa yarezzun řmewt nnec.” ");
INSERT INTO rifl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Iksi Musa tamɣart nnes d iḥenjiren nnes uca issenya i-ten x weɣyuř, idweř-dd ɣar temmurt n Miṣra uca iksi Musa taɣɣarct n AREBBI deg ufus nnes. ");
INSERT INTO rifl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Inna SIDI i Musa: “Xmi ɣa traḥed, ad dd-tdewřed ɛawed ɣar Miṣra, xzar ad tegged i firɛun marra lmuɛjizat nni d ac ggiɣ deg ufus nnec. Maca Necc ad ssqesḥeɣ uř nnes, řami war ixs ad iḍřeq i řgens. ");
INSERT INTO rifl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Xenni ad tinid i firɛun: ‘Ammu i iqqar SIDI: Israil d mmi d amenzu inu. ");
INSERT INTO rifl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Aqa nniɣ ac: Ejj ad iffeɣ mmi ad ayi iɛbed! Maca cek tugid ad t tejjed. Xzar, Necc ad nɣeɣ mmic, amenzu nnec.’” ");
INSERT INTO rifl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Imsar deg webrid, deg ijj n wemcan mani ɣa ssensen, immeřqa SIDI akides u Netta tuɣa ixs ad t ineɣ. ");
INSERT INTO rifl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Řexdenni teksi Ṣaffura ict n txedmect n weẓru, texten řeɛdařyet n mmis uca teřqef as iḍaren nnes, tenna: “S tidett cek teǧid am yijj n yesři n idammen i necc” ");
INSERT INTO rifl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ijja i-t xenni. Řexḍenni tenna: “Cek d isři n idammen i teǧid!”, di ssibbet n ixtanen. ");
INSERT INTO rifl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Inna SIDI i Harun: “Ruḥ ad teřqid Musa di řexřa!” Uca iruḥ, imsagar akides ɣar wedrar n AREBBI, issudem i-t. ");
INSERT INTO rifl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ixebbar Musa Harun x marra awařen i d as inna SIDI wenni i-t-i-dd-issekken uřa x marra řeɛřamat i d as yumur ad igg. ");
INSERT INTO rifl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Xenni iruḥ Musa d Harun, ssmunen marra imɣaren n ayt n Israil, ");
INSERT INTO rifl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","uca issiweř Harun s marra awařen i tuɣa inna SIDI i Musa uca igga řeɛřamat qibač i tiṭṭawin n řgens. ");
INSERT INTO rifl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Uca yumen zzaysen řgens, sřin belli SIDI izziǧez as ayt n Israil umi iẓra řmeḥnet i di ǧan, uḍaren uca bendqen as. ");
INSERT INTO rifl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Awarni man aya yudef Musa d Harun ɣar Firɛun, nnan as: “Ammu i iqqar SIDI, AREBBI n Israil: ‘Ejj ad iraḥ řgens inu, ḥima ad ayi iɛeyyed di řexřa!’” ");
INSERT INTO rifl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Maca firɛun inna: “Min iɛna SIDI umi ɣa sřeɣ i wawař nnes uca ad jjeɣ Israil ad iffeɣ. Necc war ssineɣ SIDI u war ttejjiɣ ad iraḥ Israil.”    ");
INSERT INTO rifl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nitni nnan: “AREBBI n Iɛibraniyyen imsagar akidneɣ, ejj aneɣ xenni ad nraḥ ticři n třata n wussan di řexřa, ad nqeddem taɣarṣt i SIDI, AREBBI nneɣ, ḥima war d aneɣ iřeqqef s ṭṭaɛun niɣ s ssif.” ");
INSERT INTO rifl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Řexdenni inna asen ujeǧid n Miṣra: “Mayemmi, a kenniw, Musa d Harun, tessbeddem řgens x řxedmet nnes? Ruḥem kenniw, dewřem ɣar ddquřat i xawem iǧan!” ");
INSERT INTO rifl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Inna firɛun: “Xzar, aqa řexxu řgens n temmurt d aṭṭas u kenniw texsem ad ten tessbeddem x warbar n ddquřat i xasen ttwaggent.” ");
INSERT INTO rifl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Yumur firɛun deg wass nni i imzeyyaren n řgens u i iweqqafen nsen, inna: ");
INSERT INTO rifl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Zi ssa d tsawent war tticem ɛad řum i řgens maḥend ad zzayes ggen llajur am yiḍennaḍ d fariḍennaḍ. Jjem ten ad raḥen nitni, ad yrun řum i yixef nsen. ");
INSERT INTO rifl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Řqedd n llajur i ggin iḍennaḍ d fariḍennaḍ ad xasen t teggem ɛawed, war zzayes tessneqqisem walu, minzi nitni d ifinyanen. X uya sɣuyyun ammu, qqaren: ‘Ejj aneɣ ad nraḥ ad nqeddem taɣarṣt i AREBBI nneɣ.’ ");
INSERT INTO rifl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ittxeṣṣa řxedmet ad tiři tedqeř x iryazen-a, ḥima ad dayes řhan ammu uca war tticen ɛad taynit i wawařen ixarriqen.” ");
INSERT INTO rifl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Řexdenni ruḥen imzeyyaren n řgens d iweqqafen nsen ggʷejen x Firɛun uca ssiwřen ak-d řgens, nnan: “Ammu i iqqar firɛun: ‘Necc war d awem tticeɣ ca ɛad řum.’ ");
INSERT INTO rifl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ruḥem kenniw ad tyarwem řum mani t ɣa tafem, maɣar war xawem tᵉttwakkes walu zi řxedmet nwem.” ");
INSERT INTO rifl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Řexdenni imbezzeɛ řgens x marra tammurt n Miṣra, ḥima ad yrun iɣeǧ deg wemcan n uřum. ");
INSERT INTO rifl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Imzeyyaren ziyyaren xasen, nnan: “Kemmřem řxedmet nwem, kuř ass min dd-ittasen i kuř ass, am mammec tuɣa din řexdenni řum.” ");
INSERT INTO rifl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ttwafarcen iweqqafen n ayt n Israil, inni xasen ggin imzeyyaren n firɛun, nnan asen: “Mayemmi war tkemmřem tasɣart nwem n llajur am řebda, iḍennaḍ lla u ɛawed ass-a lla?” ");
INSERT INTO rifl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Řexdenni usin-dd iweqqafen n ayt n Israil, sɣuyen ɣar firɛun, nnan: “Mayemmi tᵉttegged ammu ak-d isemɣan nnec? ");
INSERT INTO rifl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","War ittmewci bu uřum i isemɣan nnec, waxxa qqaren aneɣ: ‘Ggem llajur!’ U xzar, aqa isemɣan nnec ttᵉtten aɛmud, waxxa řɛib aqa-t di řgens nnec!” ");
INSERT INTO rifl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Netta yarra-dd: “Kenniw d ifinyanen, d ifinyanen aṭṭas. X uya teqqarem: ‘Jjem aneɣ ad nraḥ maḥend ad nqeddem taɣarṣt i SIDI.’ ");
INSERT INTO rifl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ruḥem řexxu ad txedmem. War d awem tticen ɛad ařum, waxxa ittxeṣṣa kenniw ad teqqimem tsebbřem řeɛbar n llajur!” ");
INSERT INTO rifl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Řexdenni ẓrin iweqqafen n ayt n Israil, aqa-ten ḥařa, minzi ittwanna: “Kenniw war ssneqṣem walu zi llajur i dd-ittasen i kuř ass.” ");
INSERT INTO rifl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Umi dd-ffɣen x firɛun, mmṣadafen ak-d Musa d Harun, inni tuɣa din ibedden ḥima ad ten rajan. ");
INSERT INTO rifl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Nnan asen: “D SIDI, d wenni kenniw ittwařan, d wenni xawem i ɣa iḥekmen, minzi kenniw aqa tessarzgem aneɣ ɣar firɛun d imsexxaren nnes umi d asen teggim ssif deg ifassen nsen maḥend ad aneɣ nɣen.” ");
INSERT INTO rifl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Řexdenni idweř Musa ɣar SIDI, inna: “A Sidi inu, mayemmi tegged řɣar di řgens-a, mayemmi d ayi tessqaded xenni? ");
INSERT INTO rifl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Zeg wami udfeɣ ɣar firɛun ḥima ad ssiwřeɣ s Yisem nnec, ideǧ firɛun řgens-a u Cek qaɛ war tfekkid ca řgens nnec.” ");
INSERT INTO rifl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Řexdenni inna SIDI i Musa: “Řexxu ad tẓared min ɣa ggeɣ i firɛun, minzi s ufus ijehden ad ten yejj ad raḥen, wah, s ufus ijehden ad xasen yaẓẓeř zi temmurt nnes.” ");
INSERT INTO rifl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Issiweř AREBBI ɣar Musa, inna as: “Necc d SIDI, ");
INSERT INTO rifl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Necc baneɣ-dd i Ibrahim, d Isḥaq d Yaɛqub am Arebbi, Amzemmar x kuřci, maca s Yisem inu ‘SIDI’, tuɣa war ɣarsen ttwassneɣ ca. ");
INSERT INTO rifl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ɛawed ssgeɛɛdeɣ Řɛahd inu akidsen aqa ad asen wceɣ tammurt n Kenɛan, tammurt n unewji nsen mani ten tuɣa am yibarraniyyen. ");
INSERT INTO rifl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ɛawed Necc sřiɣ anixses n ayt n Israil, inni ittwaggen d isemɣan zeg Imiṣriyyen, aqa xarrṣeɣ di Řɛahd inu. ");
INSERT INTO rifl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","S uya ad tinid i ayt n Israil: Necc aqa ayi d SIDI u Necc ad kenniw ssuffɣeɣ zi sadu zayřu n Imiṣriyyen. Necc ad kenniw fekkeɣ zi tesmuɣi nsen, ad kenniw fdiɣ s uɣiř isswiẓẓḍen d řeḥkamat imɣaren. ");
INSERT INTO rifl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ad kenniw qebřeɣ d řgens inu uca ad awem iřiɣ d AREBBI u kenniw ad tessnem belli Necc d SIDI, AREBBI nwem, d wenni tuɣa kenniw issuffuɣen zi sadu zayřu n Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ad kenniw ssidfeɣ ɣar temmurt mixef ssgeɛɛdeɣ afus inu maḥend ad tt wceɣ i Ibrahim d Isḥaq d Yaɛqub u Necc ad awem tt wceɣ d řwart, Necc d SIDI!” ");
INSERT INTO rifl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ammu i issiweř Musa ak-d ayt n Israil, maca nitni war sřin ca ɣar Musa zi ssibbet n řeḥṣaret n tnefsect d tasmuɣi iqesḥen. ");
INSERT INTO rifl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Uca issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Adef ɣar firɛun, ajeǧid n Miṣra, tinid as ad iḍřeq i ayt n Israil maḥend ad ffɣen zi temmurt nnes.” ");
INSERT INTO rifl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Maca Musa issiweř zzat i SIDI, inna: “Xzar, ayt n Israil war ɣari dd-sřin, mammec i d ayi ɣa iseř firɛun u necc aqa ɣari iyencicen war ittwaxetnen.” ");
INSERT INTO rifl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Řexdenni issiweř SIDI ɣar Musa d Harun uca yumur i-ten ad uyuren ɣar ayt n Israil d firɛun, ajeǧid n Miṣra, ḥima ad issuffeɣ ayt n Israil zi temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ina d izeǧifen x řaǧat zi tudrin n ibabaten nsen. Ayt n Rubin, amenzu n Israil, nitni d Hanuk d Fallu, Ḥaṣrun d Karmi. D yina d řaǧat n Rubin. ");
INSERT INTO rifl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ayt n Cimɛun tuɣa aten d Yamuyil d Yamin d Uhad d Yakin d Ṣuḥar d Cawul, mmi n ict n temɣart Takenɛanit. Ina d řaǧat n Cimɛun. ");
INSERT INTO rifl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ina d ismawen n ayt n Lawi ɛlaḥsab asettef n wexřaq nsen: Jarcum d Qahat d Marari. Tuɣa řmijař n tudart n Lawi mya u-sebɛa u-třatin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ayt n Jarcum tuɣa aten d Libna d Cimɛi ɛlaḥsab řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ayt n Qahat tuɣa aten d Ɛamram d Yiṣhar d Ḥabrun d Ɛuzziyil. Tuɣa řmijař n tudart n Qahat mya u-třata u-třatin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ayt n Marari tuɣa aten d Maḥli d Muci. Ina d řaǧat n Lawi ɛlaḥsab asettef n wexřaq nsen. ");
INSERT INTO rifl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Uca Ɛamram iksi Yukabad, ɛentis, d tamɣart i yixef nnes u nettat turuw as-dd Harun d Musa. Tuɣa řmijař n tudart n Ɛamram mya u-sebɛa u-třatin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ayt n Yiṣhar tuɣa aten d Quraḥ d Nafaj d Dikri. ");
INSERT INTO rifl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ayt n Ɛuzziyil tuɣa aten d Micayil d Alṣafan d Sitri. ");
INSERT INTO rifl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Uca iksi Harun Ilicabaɛ, yeǧis n Ɛamminadab, učmas n Naḥcun, d tamɣart i yixef nnes u nettat turuw as-dd Nadab d Abihu d Aliɛazar d Itamar. ");
INSERT INTO rifl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ayt n Quraḥ tuɣa aten d Assir d Alqana d Abiyasaf. Ina d řaǧat n Iquraḥiyyen. ");
INSERT INTO rifl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Uca Aliɛazar, mmis n Harun, iksi icten zeg yessis n Futiyil d tamɣart i yixef nnes uca nettat turuw as-dd Finaḥas. Ina d izeǧifen n tudrin n ibabaten n Ilawiyyen ɛlaḥsab řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aqa wa d Harun d Musa i umi inna SIDI: “Suffɣem ayt n Israil zi temmurt n Miṣra am ttwasettfen nitni ɛlaḥsab iseddiyyen n řɛeskar nsen.” ");
INSERT INTO rifl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ina d inni issiwřen ak-d firɛun, ajeǧid n Miṣra, ḥima ad ssuffɣen ayt n Israil zi Miṣra, Musa d Harun, nitni d ina. ");
INSERT INTO rifl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Imsar deg wass i issiweř SIDI ak-d Musa di temmurt n Miṣra, ");
INSERT INTO rifl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","aqa issiweř SIDI ak-d Musa, inna: “Necc d SIDI i ǧiɣ! Marra min d ac qqareɣ, ini t i firɛun, ajeǧid n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Xenni inna Musa zzat i SIDI: “Aqa ɣari necc iyencicen war ittwaxetnen, mammec ɣa yegg xenni ad ɣari iseǧ firɛun?”    ");
INSERT INTO rifl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Inna SIDI i Musa: “Xzar, Necc aqa ggiɣ cek d AREBBI i firɛun d umac Harun ad ac yiři d anabi i cek. ");
INSERT INTO rifl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Cek ad tinid marra min zi cek ɣa umureɣ uca Harun, umac, ad issiweř ak-d firɛun, ḥima ad yejj ad ffɣen ayt n Israil zi temmurt nnes. ");
INSERT INTO rifl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Maca Necc ad ssqesḥeɣ uř n firɛun uca ad kettareɣ řeɛřamat d lmuɛjizat inu di temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Maca firɛun war ɣarwem-dd issḥessi u Necc ad ggeɣ afus inu x Miṣra uca ad ssuffɣeɣ řɛeskarat inu, řgens inu, ayt n Israil, zi temmurt n Miṣra s řeḥkamat imɣaren. ");
INSERT INTO rifl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Řexdenni ad ssnen Imiṣriyyen belli Necc d SIDI i ǧiɣ xmi ɣa sswiẓẓḍeɣ afus inu x Miṣra uca ad ssuffɣeɣ ayt n Israil zi řwesṭ nsen.” ");
INSERT INTO rifl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Uca ggin Musa d Harun am mammec ten yumur SIDI, wah, amenni i ggin. ");
INSERT INTO rifl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tuɣa Musa d ijj n bnadem n tmenyin n iseggʷusa u tuɣa Harun d ijj n bnadem n třata u-tmenyin n iseggʷusa, řami ssiwřen ak-d firɛun. ");
INSERT INTO rifl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Uca issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Mařa issiweř akidwem firɛun, ad yini: ‘Secnem, aqa kenniw tzemmarem ad teggem ict n lmuɛjiza!’, xenni ad tinid i Harun: ‘Ṭṭef taɣɣarct nnec uca nḍar i-tt zzat i firɛun!’, xenni ad tedweř d ict n řhaycet.” ");
INSERT INTO rifl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Udfen xenni Musa d Harun ɣar firɛun uca ggin mammec i d asen yumur SIDI. Inḍar Harun taɣɣarct nnes zzat i firɛun d imsexxaren nnes uca tedweř d ict n řhaycet. ");
INSERT INTO rifl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Řexdenni iřaɣa-dd ɛawed firɛun x imiɣisen d iseḥḥaren, uca tarwa n tseḥḥart n Miṣra ggin ɛawed amenni s tmegga nsen n swadday swadday d ict. ");
INSERT INTO rifl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Inḍar kuř ijjen taɣɣarct nnes uca dewřent tiɣɣaryen nni d řhaycat. Maca taɣɣarct n Harun tsarḍ tiɣɣaryen nsen. ");
INSERT INTO rifl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Uř n firɛun idweř iqseḥ uca war ɣarsen isři ca, am mammec tuɣa i d asen inna SIDI qbeř. ");
INSERT INTO rifl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Řexdenni inna SIDI i Musa: “Uř n firɛun idweř iqseḥ. War ixs ad yejj ad iffeɣ řgens. ");
INSERT INTO rifl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ruḥ tiwecca ɣar ṣṣbeḥ ɣar firɛun. Xzar, netta ad iffeɣ ɣar waman. Cek raja din ɣar tma n yiɣzar uca ksi-dd taɣɣarct nni idewřen d afiɣar deg ufus nnec. ");
INSERT INTO rifl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ad as tinid: ‘SIDI, AREBBI n Iɛibraniyyen issekk ayi-dd ɣarek, inna: Ejj ad iraḥ řgens inu, ḥima ad ayi iɛbed di řexřa! Xzar, ař řexxu war texsed ad tseǧed. ");
INSERT INTO rifl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ammu i iqqar SIDI: ‘S man aya ad tessned belli Necc d SIDI!’ Xzar, Necc ad wteɣ aman i iǧan deg iɣzar s teɣɣarct i ɣari deg ufus inu uca ad dewřen d idammen. ");
INSERT INTO rifl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Iseřman i iǧan deg iɣzar ad mmten ař ɣa yurṣuḍ iɣzar n Nil, ad ɛiffen Imiṣriyyen ad swen aman n iɣzar n Nil.’” ");
INSERT INTO rifl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Inna SIDI ɛawed i Musa: “Ini i Harun: ‘Ksi taɣɣarct nnec, swiẓẓeḍ afus nnec x waman n Miṣra, x iɣezran nsen, x tɣezratin nsen, x iyeřmamen nsen x marra imucan manis ttmunan waman uca ad dewřen d idammen. Ad dewřen d idammen x marra tammurt n Miṣra, uřa di řeqcuɛ n ukeccuḍ d weẓru.’” ");
INSERT INTO rifl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa d Harun ggin am mammec i d asen yumur SIDI. Issgeɛɛed Harun taɣɣarct, iwta aman nni tuɣa deg iɣzar qibač i tiṭṭawin n firɛun d imsexxaren nnes uca marra aman nni tuɣa deg iɣzar dewřen d idammen. ");
INSERT INTO rifl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Mmuten iseřman inni tuɣa deg iɣzar uca yurṣuḍ yeɣzar ařami dewřen Imiṣriyyen war zemmaren ad zzayes swen aman uca dewřen waman d idammen di marra tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Maca tarwa n tseḥḥart n Miṣra ggin amenni s tmegga nsen n swadday swadday ařami uř n firɛun idweř iqseḥ, u netta war ɣarsen issḥess ca, am mammec d asen tuɣa inna SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Inneqřeb firɛun uca yudef ɣar taddart nnes uca war iggi uř nnes ɛad di man aya. ");
INSERT INTO rifl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Marra Imiṣriyyen ɣzan x tma n iɣzar n Nil maḥend ad afen aman n tessit, minzi war zemmaren ad swen aman n iɣzar n Nil. ");
INSERT INTO rifl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ammu i ɛdun sebɛa ussan awarni řami iwta SIDI iɣzar n Nil. ");
INSERT INTO rifl_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Xenni inna SIDI i Musa: “Adef ɣar firɛun, ini as: ‘Ammu i iqqar SIDI: Ejj ad iffeɣ řgens inu ḥima ad ayi iɛbed. ");
INSERT INTO rifl_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Mařa tugid ad ten tejjed ad raḥen, aqa ad wteɣ marra tammurt nnec s iqarqriwen ");
INSERT INTO rifl_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","uca iɣzar n Nil ad dd-iseffiy x iqarqriwen, ad zzayes-dd geɛɛden, ad adfen ɣar taddart nnec u ɣar wexxam nnec n yiḍeṣ, ad dd-asen x qama nnec uřa di taddart n imsexxaren nnec u jar řgens nnec, u ɛad deg ifarranen nnec u di tbeqyin nnec. ");
INSERT INTO rifl_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Ad xak dd-geɛɛden iqarqriwen uřa x řgens nnec u x marra imsexxaren nnec.’” ");
INSERT INTO rifl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Inna SIDI ɛawed i Musa: “Ini i Harun: ‘Swiẓẓeḍ afus nnec s teɣɣarct nnec x iɣezran, x tɣezratin uřa x iyeřmamen, sgeɛɛed iqarqriwen x temmurt n Miṣra.’” ");
INSERT INTO rifl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Uca isswiẓẓeḍ Harun afus nnes x waman n Miṣra uca geɛɛden-dd iqarqriwen uca dřin tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Uca uřa d tarwa n tseḥḥart ggin amenni s tmegga nsen n swadday swadday d ict, uca ssgeɛɛden-dd ɛawed iqarqriwen x temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Iřaɣa-dd firɛun x Musa d Harun, inna asen: “Ẓaǧem s řaǧaɣ i SIDI ḥima ad xafi iksi iqarqriwen u x řgens inu, uca xenni ad jjeɣ ad iffeɣ řgens, maḥend ad qeddmen tiɣarṣa i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Inna Musa i firɛun: “Ṭṭef xafi řḥurmet meřmi d ayi ɣa tinid ad xak ẓẓaǧeɣ u x imsexxaren nnec u x řgens nnec, maḥend ad xak qeḍɛeɣ iqarqriwen u x tudrin nnec, ad qqimen deg iɣzar waha.” ");
INSERT INTO rifl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Yarra-dd xas: “Tiwecca!” Inna Musa: “Ad yiři am mammec tennid ḥima ad tessned belli war din iǧi ḥed am SIDI, AREBBI nneɣ. ");
INSERT INTO rifl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Uca iqarqriwen ad mmeksin xak u x tudrin nnec uřa x imsexxaren nnec u x řgens nnec, ad qqimen deg iɣzar waha.” ");
INSERT INTO rifl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Řexdenni iffeɣ Musa d Harun x firɛun uca iřaɣa Musa i SIDI di ssibbet n jjriḥect n iqarqriwen nni tuɣa igga x firɛun. ");
INSERT INTO rifl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Uca igga SIDI am mammec dd-ittas ak-d wawař n Musa uca mmuten iqarqriwen uca weddaren zi tudrin, zi řemraḥat u zeg iyyaren. ");
INSERT INTO rifl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Uca ssmunen ten d iɛurrac uca turṣuḍ zzaysen temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Řami iẓra firɛun belli aqa bnadem izemmar ad yarr nnefs, isseqseḥ uř nnes uca war ɣarsen issḥess, am mammec tuɣa inna SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Řexdenni inna SIDI i Musa: “Ini i Harun: ‘Swiẓẓeḍ taɣɣarct nnec, tewted zzayes acař n temmurt. Xenni ad idweř d nnamus x marra tammurt n Miṣra.’” ");
INSERT INTO rifl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Uca ammu i ggin nitni. Isswiẓẓeḍ Harun afus nnes s teɣɣarct nnes i dayes, iwta acař n temmurt. Uca yusa-dd nnamus am x iwdan am x řmař. Marra acař n temmurt idweř d nnamus di marra tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tarwa n tseḥḥart ggin tizemmar nsen amenni ɛawed s tmegga nsen n swadday swadday, maḥend ad ssuffɣen nnamus, maca war zemmaren. Uca tuɣa nnamus x iwdan d řmař. ");
INSERT INTO rifl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Řexdenni nnan tarwa n tseḥḥart i firɛun: “Man aya d aḍaḍ n AREBBI!” Maca isseqseḥ uř n firɛun uca war dd ɣarsen iseǧ ca, am mammec tuɣa inna SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Uca inna SIDI i Musa: “Tiwecca kkar zic, ad tbedded zzat i firɛun. Xzar, netta ad iffeɣ ɣar tma n waman, ad as tinid: ‘Ammu i iqqar SIDI: Ejj ad iraḥ řgens inu, ḥima ad ayi iɛbed! ");
INSERT INTO rifl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Minzi mařa war tejjid řgens inu ad iraḥ, xzar, Necc ad xak ssekkeɣ iyřafen n ibeɛɛac, x imsexxaren nnec, x řgens nnec, x tudrin nnec, ař ɣa ttwaccurent tudrin n Imiṣriyyen s iyřafen n ibeɛɛac uca amenni uřa d tammurt mani zeddɣen. ");
INSERT INTO rifl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Deg wass nni ad ssḥuzeɣ tammurt n Jucan mani izeddeɣ řgens inu, ḥima war din ttiřin weyřafen n ibeɛɛac ḥima ad tessned belli Necc d SIDI di řwesṭ n temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Uca ad ggeɣ ijj n ttaman n weṣřaḥ jar řgens inu d wenni nnec. Tiwecca ad tiři řeɛřamet-a.’” ");
INSERT INTO rifl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Uca ammu i igga SIDI. Usin-dd iyřafen imeqqranen n ibeɛɛac x taddart n firɛun, x tudrin n imsexxaren nnes u x marra tammurt n Miṣra uca tᵉttwaxarreb temmurt s iyřafen n ibeɛɛac. ");
INSERT INTO rifl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Řexdenni iřaɣa firɛun i Musa d Harun, inna asen: “Ruḥem, tqeddmem taɣarṣt i AREBBI nwem di temmurt-a.” ");
INSERT INTO rifl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Inna Musa: “War dd-yusi ad negg ammu, minzi ad nqeddem taɣarṣt i SIDI, AREBBi nneɣ, min iǧan d ict n jjɛifect ɣar Imiṣriyyen. Xzar, mařa nqeddem d taɣarṣt zzat i tiṭṭawin n Imiṣriyyen min d asen ittɣiř d jjɛifect, ma war d aneɣ tarejjmen ca? ");
INSERT INTO rifl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ejj aneɣ ad nraḥ ticři n třata n wussan di řexřa, ḥima ad nqeddem taɣarṣt i SIDI, AREBBI nneɣ, am mammec d aneɣ yumur Netta.” ");
INSERT INTO rifl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Xenni inna firɛun: “Necc ad kenniw jjeɣ ad traḥem uca ad tqeddmem taɣarṣt i SIDI, AREBBI nwem, di řexřa, maca war iɛeddeř ad tiggʷijem aṭṭas. Ẓaǧem uřa xafi.” ");
INSERT INTO rifl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musa inna: “Aqa ad xak ffɣeɣ, ad ẓẓaǧeɣ i SIDI, ḥima ad ikkes tiwecca iyřafen n ibeɛɛac x firɛun, x imsexxaren nnes uřa x řgens nnes. Maca ittxeṣṣa firɛun war ixeddeɛ twařa nneɣni, war ittejji ad iraḥ řgens, maḥend ad iqeddem taɣarṣt i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Řexdenni iffeɣ Musa x firɛun uca iẓẓuǧ i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Igga SIDI ɛlaḥsab awař i inna Musa uca ikkes iyřafen n ibeɛɛac x firɛun, x imsexxaren nnes, uřa x řgens nnes. War iqqim uřa d ijj n ubeɛɛuc. ");
INSERT INTO rifl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Maca firɛun isseqseḥ uř nnes twařa-ya ɛawed, war ijji ad iraḥ řgens. ");
INSERT INTO rifl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Řexdenni inna SIDI i Musa: “Adef ɣar firɛun, ini as: ‘SIDI, AREBBI n Iɛibraniyyen iqqar ammu: Ejj ad iraḥ řgens inu, maḥend ad ayi iɛbed. ");
INSERT INTO rifl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Minzi mařa tugid ad ten tejjed ad raḥen uca ad ten tᵉṭṭfed ɛad ktar, ");
INSERT INTO rifl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","xzar, afus n SIDI ad yiři x řmař nnec nni iǧan deg iyyar, x iysan d yeɣyař d yiřeɣman d ifunasen d tfunasin uřa x wuǧi s yijj n ṭṭaɛun iqesḥen aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ad ifarz SIDI jar řebhayem n ayt n Israil d řebhayem n Imiṣriyyen, ḥima war ittmetti walu zi marra min iǧan n ayt n Israil.’” ");
INSERT INTO rifl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Uca ineyyec SIDI ict n řweqt umi inna: “Tiwecca ad yegg SIDI man aya di temmurt.” ");
INSERT INTO rifl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Tiwecca nnes igga SIDI ddeqq nni uca mmuten marra řebhayem n Miṣra, maca zi řebhayem n ayt n Israil war temmut uřa d ict zzaysent. ");
INSERT INTO rifl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Uca issekk firɛun ijjen, uca aqa da, war temmut uřa d ict zi řebhayem n ayt n Israil. Maca uř n firɛun idweř iqseḥ uca war yejji ad iffeɣ řgens. ");
INSERT INTO rifl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Řexdenni inna SIDI i Musa d Harun: “Ɛemmar uru n ifassen nwem s iɣɣeḍ zi tefqunt uca ejj Musa ad t izzuzar deg ujenna qibač i tiṭṭawin n firɛun. ");
INSERT INTO rifl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ad idweř iɣɣeḍ d taɛejjajt ifsusen x marra tammurt n Miṣra uca taɛejjact ad tedweř d tiḥebba s řewɛi x bnadem u x řmař di marra tammurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Uca ksin iɣɣeḍ zi tefqunt am tuɣa bedden zzat i firɛun uca izzuzar i-t Musa deg ujenna uca idweř d tiḥebba s řewɛi am deg iwdan am di řmař, ");
INSERT INTO rifl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ařami tarwa n tseḥḥart war zemmaren ad qqimen bedden zzat i Musa di ssibbet n tḥebba, minzi tiḥebba ḥekment iseḥḥaren d marra Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Maca SIDI isseqseḥ uř n firɛun, ařami war d asen iseǧ ca, am mammec tuɣa inna SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Řexdenni inna SIDI i Musa: “Tiwecca kkar zic, tbedded zzat i wudem n firɛun uca ini as: ‘Ammu i iqqar SIDI, AREBBI n Iɛibraniyyen: Ejj ad iraḥ řgens inu, maḥend ad ayi iɛbed. ");
INSERT INTO rifl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Minzi twařa-ya Necc ad cek řeqfeɣ deg wuř s marra jjrayeḥ inu uca uřa d imsexxaren nnec d řgens nnec, ḥima ad tessned belli war iǧi ḥed am Necc di marra tammurt. ");
INSERT INTO rifl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Minzi ɛad řexxu tuɣa zemmareɣ ad sswiẓẓḍeɣ afus inu, ḥima ad cek wteɣ uřa d řgens nnec s ṭṭaɛun uca tuɣa izemmar ad tᵉttwateḥḥid zi temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Maca s tidett Necc ssbeddeɣ cek ḥima ad ac ssecneɣ jjehd inu u ḥima ad ittwacenneɛ Isem inu di marra tammurt. ");
INSERT INTO rifl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ma tᵉttegged ɛad tiɛinkrifin ḍidd i řgens inu, ḥima war ten tejjid ad raḥen? ");
INSERT INTO rifl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Xzar, tiwecca ɣar tsaɛɛet-a Necc ad arreɣ tabrurri iddeqřen ad tewwet, tabrurri i war tuɣi ɛemmarṣ di Miṣra zeg wass i di tᵉttwabna ař i řexxu. ");
INSERT INTO rifl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Xenni sekk řexxu imsexxaren nnek, maḥend ad ssidfen řebhayem d marra min ɣarek deg iyyar ɣar daxeř. Kuř bnadem niɣ d řmař nni i ɣa ittwafen deg iyyar, war t ssidfen ɣar daxeř n taddart, ad xas dd-tewḍa tebrurri uca nitni ad mmten.’” ");
INSERT INTO rifl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wenni iggʷeden awař n SIDI zeg imsexxaren n firɛun, ijja imsexxaren nsen d řebhayem nsen arewřen ɣar daxeř di tudrin. ");
INSERT INTO rifl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Maca wenni war ittiqqen awař n SIDI s wuř nnes, aqa ijja imsexxaren nnes d řebhayem nnes deg iyyar. ");
INSERT INTO rifl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Xenni inna SIDI i Musa: “Swiẓẓeḍ afus nnec ɣar ujenna uca ad tiři tebrurri x marra tammurt n Miṣra, x iwdan, x řmař u x marra afsu deg iyyaren di temmurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Xenni isswiẓẓeḍ Musa taɣɣarct nnes ɣar ujenna uca SIDI igga ajjaj d tebrurri uca tesswiẓẓeḍ tmessi ɣar temmurt. Ammu i igga SIDI maḥend ad tewwet tebrurri x temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tuɣa din tabrurri d tmessi ixeǧḍen ak-d tebrurri. Tuɣa tejhed aṭṭas, war tt tuɣi ɛemmarṣ di marra tammurt n Miṣra zeg wami tuɣa tedweř d ijj n řgens. ");
INSERT INTO rifl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Uca tewta tebrurri x marra tammurt n Miṣra, x marra min tuɣa deg iyyar, x iwdan d řmař. Tewta tebrurri ɛawed x marra afsu deg iyyar uca ttwarẓent marra tcejjura n řexřa. ");
INSERT INTO rifl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mɣir di tammurt n Jucan, mani ǧan ayt n Israil, war tewti tebrurri. ");
INSERT INTO rifl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Řexdenni issekk firɛun ad řaɣan i Musa d Harun uca inna asen: “Necc xḍiɣ twařa-ya. SIDI, aqa-t d Amsegged uca necc d řgens inu d iɛeffanen! ");
INSERT INTO rifl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ẓaǧem s řaǧaɣ i SIDI, minzi cfa, aqa ajjajen n AREBBI d aṭṭas uřa d tabrurri. Necc ad kenniw jjeɣ ad traḥem, war kenniw ttᵉṭṭfeɣ ca ɛad danita.” ");
INSERT INTO rifl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Xenni inna as Musa: “Meřmi ɣa ffɣeɣ zi tendint ad sswiẓẓḍeɣ ifassen inu ɣar SIDI uca ad bedden wajjajen, war tᵉttiři ɛad tebrurri, maḥend ad tessned belli tammurt aqa-tt n SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Maca xak d x imsexxaren nnec, aqa ssneɣ mazal war teggʷedem ca zi SIDI AREBBI.” ");
INSERT INTO rifl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tiffest d imendi tuɣa ttwařeqfen, minzi imendi tuɣa-t s tidrin d tiffest tnewwar. ");
INSERT INTO rifl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Maca irden d karṣana war ttwařeqfen ca, minzi tuɣa aten war dd-ffiɣen ɛad. ");
INSERT INTO rifl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Xenni yuyur Musa zi firɛun, iffeɣ zi tendint uca iksi ifassen nnes ɣar SIDI. Řexdenni bedden wajjajen d tebrurri uřa d ibuda n wenẓar x temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Umi iẓra firɛun belli anẓar d tebrurri d wajjajen bedden, ixḍa ɛad ktar uca isseqseḥ uř nnes, netta d imsexxaren nnes. ");
INSERT INTO rifl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Uř n firɛun yarni di řeqsaḥet, war ijji ad iraḥ ayt n Israil, am mammec tuɣa inna SIDI s tsexxart n Musa. ");
INSERT INTO rifl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Xenni inna SIDI i Musa: “Adef ɣar firɛun, minzi Necc ssqesḥeɣ uř nnes d wuř n imsexxaren nnes, ḥima ad ssecneɣ řeɛřamat inu di řwesṭ n temmurt nnes, ");
INSERT INTO rifl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","u ḥima ad tɛawded deg imezzuɣen n mmic d mmis n mmic min ggiɣ ak-d Miṣra, u ad tɛawded x řeɛřamat i ggiɣ jar asen, maḥend ad tessnem belli Necc d SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Řexdenni yudef Musa d Harun ɣar firɛun, nnan as: “SIDI, AREBBI n Iɛibraniyyen inna: ‘Mecḥař ɣa tekked tugid ad tehwid ɣar wudem inu? Ejj ad iraḥ řgens inu ḥima ad ayi iɛbed. ");
INSERT INTO rifl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Minzi mařa tugid ad tejjed ad iraḥ řgens inu, aqa ad ssiwḍeɣ tiwecca tmurɣi x temmurt nnec. ");
INSERT INTO rifl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ad dřen udem n temmurt ař war izemmar ḥed ad itwařa tammurt ɛad uca ad ccen min iqqimen i ittwanejmen, min d awem iqqimen ɛad awarni i tebrurri. Ad tecc tmuɣri ɛawed marra ticejjura i d awem dd-iɣemmyen deg iyyar. ");
INSERT INTO rifl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Uca ad ccurent tudrin nnec d tudrin n imsexxaren nnec d tudrin n marra Imiṣriyyen. Ammu war tt ẓrin ɛemmarṣ ibabaten nnec d řejdud n ibabaten nnec zeg wami ten tuɣa x temmurt ɣar wass-a.’” Uca idweř-dd netta, ismeḥ di firɛun. ");
INSERT INTO rifl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Nnan as imsexxaren n firɛun: “Ař meřmi i d aneɣ ɣa yiři wanita d řfex? Ejj ad raḥen iryazen nni, maḥend ad ɛebden SIDI AREBBI nsen! Ma war tessined ɛad belli Miṣra aqa tᵉttwaxarreb?” ");
INSERT INTO rifl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Řexdenni ssiwḍen imsexxaren n firɛun Musa d Harun ɛawed ɣar firɛun. Netta inna asen: “Ruḥem, ɛebdem SIDI, AREBBI nwem! Ini ayi, min ɛnan inni ixsen ad raḥen?” ");
INSERT INTO rifl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Inna Musa: “Ad nraḥ ak-d iḥramen nneɣ d iwessura nneɣ, s iḥenjiren nneɣ d tḥenjirin nneɣ, s wuǧi nneɣ d ifunasen d tfunasin nneɣ, minzi ɣarneɣ ijj n Řɛid i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Xenni yarra-dd xasen: “Xenni ittxeṣṣa ad yiři SIDI aṭṭaṣ akidwem mařa ad jjeɣ ad traḥem kenniw d iḥenjiren imeẓyanen nwem. Xzarem, aqa kenniw tenwim řɣar! ");
INSERT INTO rifl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","War ittiři amenni. Jjem ad ɛebden iryazen ijehden i SIDI, minzi d man aya i tᵉttexsem.” Uca uẓẓřen xasen zi qibač n wudem n firɛun. ");
INSERT INTO rifl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Xenni inna SIDI i Musa: “Swiẓẓeḍ afus nnec x temmurt n Miṣra, ḥima tamurɣi ad tgeɛɛed x temmurt n Miṣra, maḥend ad tecc marra afsu aziza n temmurt, marra min iceṭṭen x tebrurri.” ");
INSERT INTO rifl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Isswiẓẓeḍ Musa ɣar teɣɣarct nnes x temmurt n Miṣra uca igga SIDI ad dd-isuḍ ijj n usemmiḍ i dd-yusin zi ccarq x temmurt war iqeṭṭin marra ass nni d marra ǧiřet nni. Ɣar ṣṣbeḥ yiwi-dd usemmiḍ tamurɣi. ");
INSERT INTO rifl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tgeɛɛed-dd tmurɣi x marra tammurt n Miṣra, tṣeyyeḥ x marra jjwayeh n Miṣra. Aqa tuɣa řḥař yewɛar aṭṭas. Tamurɣi am tanita war tt tuɣi qbeř uca war tᵉttiři ɛemmarṣ zi ssa ɣar zzat. ");
INSERT INTO rifl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Aqa dřint udem n marra tammurt ařami tessutem temmurt. Nitenti ccint marra afsu n temmurt d marra řɣiǧet n tcejjura i tuɣa iqqimen zi tebrurri. Di marra tammurt n Miṣra war iqqim walu zi marra tuzzizewt di tcejjura niɣ deg wefsu n iyyar. ");
INSERT INTO rifl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Řexdenni iřaɣa firɛun deɣya i Musa d Harun, inna: “Aqa xḍiɣ ak-d SIDI, AREBBI nwem, uřa akidwem. ");
INSERT INTO rifl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ttzawgeɣ řexxu ad ayi tsamḥem x uxeṭṭu inu twařa-ya. Ẓaǧem s řaǧaɣ i SIDI, AREBBI nwem, ḥima ad xafi ikkes řmewt-a waha.” ");
INSERT INTO rifl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Uca iffeɣ x firɛun uca iẓẓuǧ s řaǧaɣ ɣar SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Xenni ijja SIDI ad dd-iɛqeb usemmiḍ i dd-yusin zi ccarq ɣar řɣarb, issjehd i-t aṭṭas, uca ikkes usemmiḍ tamurɣi, inḍar i-tt di Řebḥar n Telga. War teqqim uřa d ict n tmurɣi di marra jjwayeh n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Maca isseqseḥ SIDI uř n firɛun umi war ijji ayt n Israil ad raḥen. ");
INSERT INTO rifl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Xenni inna SIDI i Musa: “Swiẓẓeḍ afus nnec ɣar ujenna, xenni ad tiři taǧest x temmurt n Miṣra ař ɣa tafed tzemmared ad tḥadid taǧest.” ");
INSERT INTO rifl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Isswiẓẓeḍ Musa afus nnes ɣar ujenna uca tehwa-dd taǧest tejhed x marra tammurt n Miṣra, třata n wussan.    ");
INSERT INTO rifl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Uřa d ijj war itwiři wenneɣni. Uřa d ijj war ikkar zeg wemcan nnes třata n wussan. Maca marra ayt n Israil tuɣa ɣarsen tafawt deg imucan mani tuɣa zeddɣen. ");
INSERT INTO rifl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Řexdenni iřaɣa firɛun i Musa, inna: “Ruḥem, tɛebdem SIDI! Jjem waha ad iqqim wuǧi nwem d ifunasen d tfunasin nwem. Maca tzemmarem ad dd-tawyem iḥenjiren imeẓyanen akidwem.” ");
INSERT INTO rifl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Yarra-dd xas Musa: “Ittxeṣṣa cek ɛawed ad aneɣ tewced deg ufus tiɣarṣa uřa d tiɣarṣa n wecmaḍ. Ad tent nessewjed d tɣarṣṭ i SIDI, AREBBI nneɣ. ");
INSERT INTO rifl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Uřa d řebhayem nneɣ ittxeṣṣa ad kidneɣ raḥent, war ittɣimi uřa d ijj n ucekrud, minzi zzaysent i ɣa neksi, ḥima ad neɛbed SIDI, AREBBI nneɣ, minzi war nessin s minzi ɣa neɛbed SIDI, AREBBI nneɣ, ař din ɣa naweḍ.” ");
INSERT INTO rifl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Maca SIDI isseqseḥ uř n firɛun uca yugi ad ten yejj ad raḥen. ");
INSERT INTO rifl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Inna as firɛun: “Aggʷej xafi! Ḥḍa, ḥima war tẓarred ɛad udem inu, minzi ass i di ɣa tẓared udem inu, ad temmted!” ");
INSERT INTO rifl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Inna Musa: “Ad yiři am mammec i tennid: war ẓarreɣ ɛad udem nnec!” ");
INSERT INTO rifl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Inna SIDI i Musa: “Ad řeqfeɣ ɛad mɣir s yicten jjriḥect x firɛun d Miṣra. Awarni ta ad kenniw issekk ssa. Ɣar uneggar xmi kenniw ɣa yejj ad truḥem marra, ad xawem yaẓẓeř ssa s tidett. ");
INSERT INTO rifl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Siweř xenni deg imezzuɣen n řgens maḥend ad ittar kuř aryaz zeg wajjar nnes u kuř tamɣart zi tajjart nnes řeqcuɛ n nnuqart d wureɣ.” ");
INSERT INTO rifl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","SIDI iwca as i řgens arḍa di tiṭṭawin n Imiṣriyyen. Ɛawed tuɣa Musa d ijj weryaz s ccan ameqqran di temmurt n Miṣra di tiṭṭawin n řgens u di tiṭṭawin n imsexxaren n firɛun. ");
INSERT INTO rifl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Inna Musa: “Ammu i inna SIDI: ‘Ɣar wezyen n ǧiřet Necc ad ɛduɣ di řwesṭ n Miṣra ");
INSERT INTO rifl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","uca ad immet kuř amenzu di temmurt n Miṣra, zeg umenzu n firɛun, wenni iqqimen x řɛarc n tgeldit, ař amenzu n tayya, tenni iqqimen awarni i tsirt tḥarri imendi, uřa d kuř amenzu zi řebhayem. ");
INSERT INTO rifl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ad din tiři ict n tɣuyyit d tameqqrant x marra tammurt n Miṣra i war tuɣi ɛemmarṣ niɣ ɛemmarṣ ɛad ad tiři. ");
INSERT INTO rifl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Maca ɣar marra ayt n Israil, war ittẓu uřa d ijj n weqzin x iwdan uřa x řmař, maḥend ad tessnem, belli SIDI ittegg řfarz jar Imiṣriyyen d Israil.’ ");
INSERT INTO rifl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Xenni ad ɣari dd-hwan marra imsexxaren nnec, ad ayi bendqen, ad inin: ‘Ffeɣ cek d marra řgens i cek iḍeffaren deg iṣuraf nnec!’ Awarni man aya necc ad ffɣeɣ.’” Uca iffeɣ x firɛun, tekkar dayes tmessi s uxeyyeq. ");
INSERT INTO rifl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Aqa inna SIDI i Musa: “Firɛun war d awem ittesři ca, ḥima ad mɣarent řeɛřamat inu di temmurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Aqa Musa d Harun ggin marra řeɛřamat-a zzat i wudem n firɛun, maca SIDI tuɣa isseqseḥ uř n firɛun ařami war ijji ad ffɣen ayt n Israil zi temmurt nnes. ");
INSERT INTO rifl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Issiweř SIDI ak-d Musa d Harun di temmurt n Miṣra, inna: ");
INSERT INTO rifl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ayur-a ad awem yiři d azeǧif n iyuren. Ad awem yiři wa i kenniw d amezwaru n iyuren n useggʷas. ");
INSERT INTO rifl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Siweř ɣar marra tamesmunt n Israil, ini: ‘Deg wass wiss ɛecra ad iksi kuř ijj i yixef nnes ijj n yezmar x marra řaǧ n taddart i dd-iqqarṣen zeg ibabaten, ijj n yezmar x ict n taddart. ");
INSERT INTO rifl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Maca mařa raǧ n taddart tuɣa imẓi i yezmar, xenni ittxeṣṣa ad iksi ak-d wajjar nnes yudsen ɣar taddart nnes ɛlaḥsab řqedd n iwdan. Zi jjihet n yezmar ad tewtem řeḥsab i min ɣa yecc kuř ijjen. ");
INSERT INTO rifl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ad yiři d izmar icnan qaɛ, awtem n ijj n useggʷas. Ad t teksim zeg iḥuřiyyen niɣ zeg iɣayḍen. ");
INSERT INTO rifl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ad t txemmřem ař ass arbeɛṭac zeg uyur-a uca ad as iɣarṣ marra agraw n tmesmunt n Israil jar beddu n wezyen n wass ař dd-tewḍa tmeddit. ");
INSERT INTO rifl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ad ksin ca zeg idammen uca ad t ggen x tnayen n řeḍruf i iǧan ɣar uɣezdis n tewwart u x tnebdat sennej i tewwart n tudrin mani t ɣa ccen. ");
INSERT INTO rifl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ad ccen aysum di ǧiřet nni, aysum icennfen ɣar tmessi ak-d weɣrum břa antun. Ad t ccen s řebzar yarzeg. ");
INSERT INTO rifl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","War t ttᵉttem ca d aziza niɣ yenwan deg waman, maca mɣir mařa ittwacennef di tmessi, ak-d uzeǧif nnes d iḍaren nnes d wadan nnes. ");
INSERT INTO rifl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","War zzayes ttejjim walu ɣar ṣṣbeḥ, maca min zzayes ɣa iqqimen ɣar ṣṣbeḥ, ittxeṣṣa kenniw ad t tcemḍem di tmessi. ");
INSERT INTO rifl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ammu i d awem ittxeṣṣa ad t teccem: tajɛinna nwem ad tiři tebyes, sandaliyat nwem deg iḍaren nwem u taɣɣarct nwem deg ufus nwem uca ad t teccem deɣya. Aqa-t d Taɣarṣt n Useɛdu n SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Minzi di ǧiřet-a, Necc ad ɛduɣ x temmurt n Miṣra uca ad wteɣ kuř amenzu di temmurt n Miṣra, ammu deg iwdan uřa di řmař, uca ad ssiwḍeɣ řeḥkamat inu x marra irebbiten n Miṣra, Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Uca idammen ad awem iřin d ict n řeɛřamet x tudrin mani tzeddɣem kenniw. Mařa ẓriɣ idammen, ad xawem ɛduɣ. War tᵉttiři jjriḥect ineqqen jar awem, xmi ɣa wteɣ tammurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ass-a ad awem yiři d ijj n wass i řidaret uca ad zzayes tɛeyydem i SIDI. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem, ḥima ad zzayes tɛeyydem. ");
INSERT INTO rifl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Sebɛa n wussan ad teccem aɣrum břa antun. Nican deg wass amezwaru ad tessuffɣem antun zi tudrin nwem, minzi man wen i ɣa iccen ca s wentun, zeg wass amezwaru ař ass wiss sebɛa, bnadem nni ad ittwaqess zi Israil. ");
INSERT INTO rifl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Deg wass amezwaru ad yiři ijj n umuni iqeddsen uca ɛawed deg wass wiss sebɛa ad din yiři ijj n umuni iqeddsen. Uřa d ict n řxedmet war tᵉttwagg ca deg wussan nni. Mɣir min ɣa yecc kuř ijj, d man aya waha iɛeddeř ad zzaywem ittwassewjed. ");
INSERT INTO rifl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ad teḥḍam Řɛid n Weɣrum břa Antun, minzi deg wass nni aqa ssuffɣeɣ-dd kenniw zi temmurt n Miṣra. Ad teḥḍam ass-a di marra jjiřat nwem, aqa-tt d ict n tewṣeyyet i řebda. ");
INSERT INTO rifl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Deg uyur amezwaru, deg wass wiss arbeɛṭac n uyur, di ǧiřet, ad teccem aɣrum břa antun ař ǧiřet n wass waḥit u-ɛicrin zeg uyur. ");
INSERT INTO rifl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sebɛa n wussan war ittwiffi wentun di tudrin nwem, minzi man wen i ɣa iccen zi min iǧan s wentun, ma d abarrani niɣ d mmis n temmurt, bnadem nni ad ittwaqess zi tmesmunt n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","War ttᵉttem walu zi min iǧan s wentun. Di marra tizeddaɣ nwem ad teccem aɣrum břa antun.’” ");
INSERT INTO rifl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Iřaɣa Musa i marra imɣaren n Israil, inna asen: “Ṭṭfem, ksim ijjen zeg wuǧi i yixef nwem, i řaǧat nwem u ɣarṣem t i Tɣarṣt n Useɛdu. ");
INSERT INTO rifl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ṭṭfem ict n tqebbiḍt n tɛelǧet, sɣeḍsem tt deg idammen nni iǧan di ṭṭebṣi, ɣemsen xenni zeg idammen i iǧan di ṭṭebṣi x tnebdat sennej i tewwart u x tnayen n řeḍruf ɣar uɣezdis n tewwart. Ař ṣṣbeḥ war itteffeɣ uřa d ijjen zzaywem zi tewwart n taddart nnes. ");
INSERT INTO rifl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","SIDI ad iẓwa x temmurt, maḥend ad iwwet Imiṣriyyen, maca xmi ɣa iẓar idammen x tnebdat n nnej u x tnayen n řeḍruf ɣar uɣezdis n tewwart, xenni ad iɛdu SIDI tawwart nni, war ittejji amteḥḥay ad yadef ɣar tudrin nwem, ḥima ad iwwet. ");
INSERT INTO rifl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ḥḍam awař-a i nniɣ, aqa d tewṣeyyet i cek u i iḥenjiren nnec i řebda. ");
INSERT INTO rifl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ad yiři, xmi ɣa tadfem ɣar temmurt tenni d awem ɣa yewc SIDI, am mammec inna Netta, ad teḥḍam aɛbad-a n řidaret. ");
INSERT INTO rifl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Uca x minni d awem ɣa inin iḥenjiren nwem: ‘Min ixs ad yini weɛbad-a n řidaret i kenniw?’, ");
INSERT INTO rifl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","xenni ad tinim: ‘Aqa d Taɣarṣt n Useɛdu i SIDI wenni iɛdun x tudrin n ayt n Israil di Miṣra, umi iwta Imiṣriyyen uca ifekk tudrin nneɣ.’” Řexdenni yuḍar řgens uca bendqen nitni. ");
INSERT INTO rifl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ruḥen ayt n Israil uca ggin am mammec ten yumur SIDI i Musa d Harun u ammu i tt ggin. ");
INSERT INTO rifl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Tuɣa ɣar wezyen n ǧiřet umi iwta SIDI marra imenza di temmurt n Miṣra s řmewt, zeg umenzu n firɛun, wenni iqqimen x řɛarc nnes, ař amenzu n umeḥbus i iǧan di řeḥbes, uřa d marra imenza n řebhayem.    ");
INSERT INTO rifl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ikkar firɛun di ǧiřet nni, netta d marra imsexxaren nnes d marra Imiṣriyyen uca tuɣa din ict n tɣuyyit temɣar minzi war tuɣi uřa d ict n taddart mani war iǧi umettin. ");
INSERT INTO rifl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Uca iřaɣa-dd i Musa d Harun s ǧiřet, inna: “Kkarem, teffɣem zi řwesṭ n řgens inu, kenniw jmiɛ ak-d ayt n Israil, ruḥem, tɛebdem SIDI, am mammec tennam kenniw. ");
INSERT INTO rifl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Awyem uǧi nwem d ifunasen d tfunasin nwem, am mammec tennam. Ruḥem, maca ttzawgeɣ kenniw, barkem ayi necc ɛawed!” ");
INSERT INTO rifl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Zeyyaren Imiṣriyyen aṭṭas x řgens, maḥend nitni ad ffɣen s uqeǧeq zi temmurt, minzi Imiṣriyyen nnan: “Aqa neccin marra d imettan!” ");
INSERT INTO rifl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Uca yiwi řgens arecti nnes qbeř ma ɣa inḍu uca tibeqyin nnḍen tent jar warruḍ nsen x ṭɣarḍin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ayt n Israil ggin ɛlaḥsab awař i d asen inna Musa, ttaren řeqcuɛ n nnuqart d wureɣ d warruḍ zeg Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","SIDI iwca řgens arḍa di tiṭṭawin n Imiṣriyyen, wcin asen min ttaren, u ammu i keccḍen nitni Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Fesyen ayt n Israil iqiḍan nsen, uyuren zi Raɛamsis ɣar Sukkut, tuɣa aten ɛřaḥař di setta-myat-ařef x iḍaren, ttwaḥesben iryazen waha, břa iḥenjiren. ");
INSERT INTO rifl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Igeɛɛed akidsen ijj n ubarru d ameqqran n ɛřam kuř iwdan, xenni ɛawed uǧi d ifunasen d tfunasin, aqa-tt d ict n tḥimart temɣar aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","S warecti i kidsen dd-iwyen zi Miṣra ggʷin tifḍirin břa antun, minzi tuɣa ɛad war ismim, minzi uẓẓřen xasen-dd zi Miṣra u war zemmaren ad bedden maḥend ad areyyḥen u war sswejden macca i webrid i yixef nsen. ");
INSERT INTO rifl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tuɣa řmijař n tzeddiɣt n ayt n Israil di Miṣra, řmijar i din izedɣen, arebɛa-mya u-třatin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ɣar uneggar n arebɛa-mya u-třatin n iseggʷusa, deg wass nni simant nnes, ffɣen marra řɛeskar n SIDI zi temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tanita aqa-tt d ict n ǧiret ittxeṣṣa ad tᵉttwaḥḍa i řewqar i SIDI, maɣar Netta indeh i-ten zi temmurt n Miṣra. Ǧiřet-a tanita, aqa-tt i SIDI. Ittxeṣṣa ad tᵉttwaḥda zi marra ayt n Israil, di marra jjiřat nsen. ");
INSERT INTO rifl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Inna SIDI i Musa d Harun: “D ta d tawṣeyyet x Tɣarṣt n Useɛdu: war zzayes ittett mmis n ubarrani, ");
INSERT INTO rifl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","maca kuř ismeɣ immesɣen zeg ijj n weryaz s nnuqart, izemmar ad zzayes yecc, mařa txetned as. ");
INSERT INTO rifl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Amɛezzeb d ucewwař war zzayes ttᵉtten ca. ");
INSERT INTO rifl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ad ittwacc di taddart d ict u war itteffeɣ walu zeg weysum nni ɣar barra n taddart uca war zzayes ittareẓẓi uřa d ijj n yiɣes. ");
INSERT INTO rifl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Marra tamesmunt n Israil ad tegg amenni. ");
INSERT INTO rifl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mařa ca n ubarrani innewjew-dd ɣarek uca ixs ad issewjed Taɣarṣt n Useɛdu i SIDI, ittxeṣṣa ad ittwaxten kuř aryaz nni ɣares iǧan. Řexdenni ad dd-iqarreb, ad tt issewjed, uca ad yiři am wenni dd-ixeřqen di temmurt. Maca uřa d ijj zeg inni war ixtinen war izemmar ad zzayes yecc. ");
INSERT INTO rifl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ad din yiři ijj n uzerf i wenni dd-ixeřqen di temmurt u i ubarran i izeddɣen jar awem am ubarrani.” ");
INSERT INTO rifl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Uca marra ayt n Israil ggin am mammec d asen yumur Musa d Harun, ammu i tt ggin. ");
INSERT INTO rifl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Uca imsar deg wass nni simant nnes issuffuɣ SIDI ayt n Israil zi temmurt n Miṣra am ttwasettfen nitni ɛlaḥsab iseddiyyen n řɛeskar nsen. ");
INSERT INTO rifl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Sqeddes ayi kuř amenzu, wenni zi jar ayt n Israil yarezmen řemřawet d amezwaru, am zeg iwdan am zi řebhayem. Netta aqa inu.” ");
INSERT INTO rifl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Inna Musa i řgens: “Idarem ass-a min di teffɣem zi Miṣra, zi taddart n tesmuɣi, minzi SIDI issuffeɣ-dd kenniw zzayes s ufus ijehden. Deg wass-a war tᵉttettem walu min di iǧa wentun. ");
INSERT INTO rifl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ass-a ad teffɣem, deg uyur n Abib. ");
INSERT INTO rifl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mařa SIDI issidef i cek ɣar temmurt n ayt n Kenɛan d Iḥittiyyen d Imuriyyen d Iḥiwiyyen d Iyabusiyyen, x tenni ijjuǧ i řejdud nwem ad ac tt iwc, tammurt ifeyyḍen s uɣi d tamment, xenni ad teḥḍam aɛbad-a n řidaret deg uyur-a. ");
INSERT INTO rifl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sebɛa n wussan ad tecced aɣrum břa antun uca deg wass wiss sebɛa ad din yiři ijj n Řɛid i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Sebɛa n wussan ad ittwacc weɣrum břa antun uca war ɣarek ittwiffi min ixemmren. Di marra jjwayeh nnec war ittwifi wentun ɣarek. ");
INSERT INTO rifl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Deg wass nni ad tḥajid i mmic, ad as tinid: Man aya di ṭṭweɛ n min d ayi igga SIDI umi dd-ffɣeɣ zi Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ad ac yiři am yijj n uceyyar x ufus nnec u i řidaret jar tiṭṭawin nnec, maḥend Ccariɛa n SIDI ad tiři deg uqemmum nnec, minzi s ufus ijehden issuffeɣ SIDI i kenniw zi Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","S uya i ɣa teḥḍid tawsiyyet-a di řweqt nnes i d as ittwaggen, zeg useggʷas ɣar useggʷas. ");
INSERT INTO rifl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ad yiři xmi cek ɣa issidef SIDI di temmurt n ayt n Kenɛan, am mammec i d ac ijjuǧ uřa i řejdud nnec, uca iwca ac tt, ");
INSERT INTO rifl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","xenni ad tesseɛdud ɣar SIDI kuř amenzu i yarezmen řemřawet d amezwaru uřa d kuř amenzu n řebhayem i yarezmen řemřawet d amezwaru: iwetman ad iřin i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Maca kuř amenzu i yarezmen řemřawřet n weɣyuř d amezwaru, ad t tefdid s yijj zeg wuǧi. Mařa war t tefdid, ad as tarẓed iri. Kuř amenzu n bnadem zeg iḥenjiren nnec ad t tefdid. ");
INSERT INTO rifl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Uca ad imsar, xmi cek ɣa isseqsa mmic tiwecca, ad yini: ‘Manawya?’, ad as tinid: ‘Aqa issuffuɣ aneɣ-dd SIDI zi Miṣra s ufus ijehden, zi taddart n tesmuɣi. ");
INSERT INTO rifl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Řami d aneɣ ibedd firɛun deg webrid i wuffuɣ nneɣ, imsar aqa SIDI inɣa marra imenza di temmurt n Miṣra, zeg umenzu n bnadem ař amenzu n řebhimet. X uya qeddmeɣ kuř amenzu i yarezmen řemřawet d amezwaru d taɣraṣt i SIDI, maca kuř amenzu jar iḥenjiren inu, ad t fdiɣ. ");
INSERT INTO rifl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ad yiři d aceyyar x ufus nnec d ijj n ufiřu n useggem jar tiṭṭawin nnec, minzi SIDI aqa issuffeɣ aneɣ-dd zi Miṣra s ufus ijehden.’” ");
INSERT INTO rifl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Umi ijja firɛun řgens ad iraḥ, war ten indih AREBBI ɣar webrid n temmurt n Ifilisṭiniyyen, waxxa nettat tudes, minzi AREBBI inna: “Maḥend war ittendemmi řgens xmi ɣa iẓar řbaruḍ uca ad dd-idweř ɣar Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Indeh AREBBI řgens, maḥend ad ikk x webrid n řexřa ɣar Řebḥar n Telga. Uca geɛɛden ayt n Israil zi Miṣra wejden i umenɣi. ");
INSERT INTO rifl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Iksi Musa akides iɣsan n Yusuf, minzi netta issjuǧ ayt n Israil s ict n tẓaǧit, inna: “S tidett ad ɣarwem dd-yarzef AREBBI, uca ad tessgeɛɛdem iɣsan inu ssa akidwem!” ");
INSERT INTO rifl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Uca fesyen iqiḍan nsen, ggʷejen x Sukkut uca wtin iqiḍan nsen di Itam, ɣar ṭṭarf n řexřa. ");
INSERT INTO rifl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","SIDI izwar i tiṭṭawin nsen deg uẓiř deg ijj n uqellij n useynu, maḥend ad ten igewwed deg webrid, u di ǧiřet deg ijj n uqellij n tmessi, ḥima ad ɣarsen igg tafawt, ḥima ad taf zemmaren ad uyuren ass d ǧiřet. ");
INSERT INTO rifl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Deg wass war dd-ikkis aqellij n useynu zzat i uɣembub n řgens uřa di ǧiřet war dd-ikkis aqellij n tmessi. ");
INSERT INTO rifl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Xenni issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Siweř ak-d ayt n Israil, maḥend ad dd-dewřen uca ad wten iqiḍan nsen zzat i Fi-Haxirut, jar Migdul d řebḥar, qibač i Baɛal-Ṣafun. Arendad nnes ad tewtem iqiḍan nwem x tma n řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Xenni ad yini firɛun x ayt n Israil: ‘Aqa nitni weddaren di temmurt, aqa řexřa iḥṣar i-ten.’ ");
INSERT INTO rifl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Uca Necc ad ssqesḥeɣ uř n firɛun, ḥima ad ten iḍfar u Necc ad ttwassɛuǧiɣ x firɛun u x marra řɛeskar nnes uca ad ssnen Imiṣriyyen belli Necc d SIDI.” Uca ammu i tt ggin nitni. ");
INSERT INTO rifl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Uca xebbaren i ujeǧiḍ n Miṣra belli řgens yarweř. Xenni ibeddeř wuř n firɛun d imsexxaren nnes x řgens uca nnan: “Mammec i negga aya, nessekk Israil zi tesmuɣi i iggin i neccin?” ");
INSERT INTO rifl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Uca iḥezzem Firɛun akarru nnes, iksi akides řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Iksi akides setta-mya n ikarruten icewwaren d marra ikarruten n Miṣra uca igga acewwar n ineɣrafen zi řɛeskar nnes x kuř ijj zzaysen. ");
INSERT INTO rifl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Aqa isseqseḥ SIDI uř n firɛun, ajeǧid n Miṣra, uca yardef netta ayt n Israil, maca ayt n Israil tuɣa ffɣen s yijj n ufus ittwassgeɛɛden. ");
INSERT INTO rifl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Aredfen ten Imiṣriyyen uca iwḍen ɣarsen s marra iysan d ikarruten n firɛun d imnayen nnes d řɛeskar nnes, ɣar Fi-Haxarut, ɣar ujemmaḍ n Baɛal-Ṣafun, mani wtin iqiḍan nsen ɣar řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Řami ten dd-yudes firɛun, ssgeɛɛden ayt n Israil tamuɣři nsen, ẓrin belli Imiṣriyyen ḍfaren ten-dd uca nitni ggʷeden aṭṭas. Xenni sɣuyen ayt n Israil ɣar SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nnan i Musa: “Ma war ǧin ɛad imeḍřan di Miṣra ař d aneɣ dd-tawyed, maḥend ad nemmet di řexřa-ya? Maɣar teggid ammu, tessuffɣed aneɣ-dd zi Miṣra? ");
INSERT INTO rifl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ma war kidek nessiweř marra awařen-a di Miṣra, nenna: ‘Ejj aneɣ ad nexdem i Imiṣriyyen’? Xar mařa tuɣa neqqim nexdem i Imiṣriyyen x mařa nemmut di řexřa.” ");
INSERT INTO rifl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Xenni inna Musa i řgens: “War tteggʷedem, beddem, texzarem asenjem n SIDI i d awem ɣa yewc ass-a, minzi Imiṣriyyen nni tᵉttwařam ass-a, ɛemmarṣ ad ten tẓarem ɛad i řebda. ");
INSERT INTO rifl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","SIDI ad xawem immneɣ uca kenniw ad tseɣdem waha.” ");
INSERT INTO rifl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Inna SIDI i Musa: “Mayemmi ɣari tᵉttřaɣid? Ini i ayt n Israil ḥima ad fesyen iqiḍan nsen. ");
INSERT INTO rifl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Sgeɛɛed taɣɣarct nnec, swiẓẓeḍ afus nnec x řebḥar uca farq i-t, ḥima ad iẓwa ayt n Israil x řbarr di řwesṭ n řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Xzar, Necc ad ssqesḥeɣ uř n Imiṣriyyen, maḥend ad ten aredfen di řebḥar u Necc ad ssɛuǧiɣ Ixef inu s firɛun u s marra řɛeskar nnes, ikarruten nnes d imnayen nnes n iysan. ");
INSERT INTO rifl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ad ssnen Imiṣriyyen belli Necc d SIDI, xmi ɣa ttwassɛuǧiɣ s firɛun, s ikarruten nnes d imnayen nnes n iysan.” ");
INSERT INTO rifl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Xenni immuṭṭi lmalak n AREBBI nni yuyuren zzat i řɛeskar n Israil uca idweř ɣar ḍeffar nsen: aqellij n useynu immuṭṭi zi zzat i wudem nsen uca ibedd ɣar ḍeffar nsen. ");
INSERT INTO rifl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Yudef uqellij jar řɛeskar n Imiṣriyyen d řɛeskar n Israil. Tuɣa aseynu d taǧest ɣar uɣezdis-a u issiɣ i uɣezdis nneɣni s ǧiřet u war dd-iqarreb ijjen ɣar wenneɣni ǧiřet tekmeř. ");
INSERT INTO rifl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Uca isswiẓẓeḍ Musa afus nnes x řebḥar uca iɛarn SIDI xenni řebḥar ɣar uɣezdis s yijj n usemmiḍ d acarqi ijhed, marra ǧiřet nni, uca yarra řebḥar ad ijeffef. Ammu i ttwammsebḍan waman. ");
INSERT INTO rifl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Uyuren ayt n Israil x min yuẓɣen di řwesṭ n řebḥar uca aman ggin amecnaw řḥiḍ x yefus nsen d uzeřmaḍ nsen. ");
INSERT INTO rifl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Aredfen ten Imiṣriyyen, ruḥen awarni asen di řwesṭ n řebḥar s marra iysan n firɛun d ikarruten nnes d imnayen nnes n yiysan. ");
INSERT INTO rifl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Řami d yeffu řḥař, imsar belli SIDI iṣweḍ ɣar řɛeskar n Imiṣriyyen zeg uqellij n tmessi d iseynuten uca issxarweḍ řɛeskar n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ijja tijarrarin n ikarruten nsen ad fesxent, ařami idweř iwɛar xasen ad uyuren ɣar zzat. Řexdenni nnan Imiṣriyyen, kuř ijjen zzaysen i yixef nnes: “Ittxeṣṣa ayi ad arewřeɣ zi zzat n tiṭṭawin n Israil, minzi SIDI immneɣ di ṭṭweɛ nsen ḍidd i Imiṣriyyen.” ");
INSERT INTO rifl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Inna SIDI i Musa: “Swiẓẓeḍ afus nnec x řebḥar, ḥima ad dewřen waman x Imiṣriyyen, x ikarruten nsen u x imnayen nsen n iysan.” ");
INSERT INTO rifl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Xenni isswiẓẓeḍ Musa afus nnes x řebḥar u ɣar řefjar n ṣṣbeḥ idweř řebḥar ɣar mani t tuɣa qbeř uca arewřen Imiṣriyyen nican ḍidd nnes uca iɣḍeř SIDI Imiṣriyyen di řwesṭ n řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Dewřen-dd waman uca ttwaneḍřen ikarruten d imnayen n iysan n marra řɛeskar n firɛun i tuɣa yudef awarni asen ɣar řebḥar. War zzaysen iqqim uřa d ijjen. ");
INSERT INTO rifl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Maca ayt n Israil uyuren x min yuẓɣen di řwesṭ n řebḥar u aman tuɣa ggin amecnaw řḥiḍ ɣar yefus nsen d uzeřmaḍ nsen. ");
INSERT INTO rifl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ammu i issenjem SIDI Israil deg wass nni zeg ufus n Imiṣriyyen uca Israil iẓra Imiṣriyyen i immuten x tma n řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Iẓra Israil afus imɣaren i igga SIDI deg Imiṣriyyen uca iggʷed řgens zi SIDI, uca umnen nitni di SIDI u di Musa, amsexxar nnes. ");
INSERT INTO rifl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Řexdenni izehhed Musa jmiɛ ak-d ayt n Israil zhid-a i SIDI, nnan: “Ad zehhdeɣ i SIDI, minzi Netta yuɛřa di řuɛřa! Ayis d wenni xas yenyin inḍar i-ten di řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","SIDi d jjehd inu d azehhed inu. Netta idweř d asenjem inu. Wa d Arebbi inu, necc ad t ssemɣareɣ. Netta d AREBBI n baba, necc ad t ssɛuǧeɣ! ");
INSERT INTO rifl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","SIDI d aryaz n umenɣi, SIDI d Isem nnes! ");
INSERT INTO rifl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ikarruten n firɛun d řɛeskar nnes inḍar i-ten di řebḥar u acewwar n ineɣrafen nnes n řɛeskar ɣarqen di Řebḥar n Telga. ");
INSERT INTO rifl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Aman ihewřen dřin i-ten. Amecnaw aẓru, hwan ɣar řaǧaɣ. ");
INSERT INTO rifl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","A SIDI, afus afusi nnec ittwaɛezz s jjehd, afus afusi nnec, a SIDI, aqa iřbez řeɛdu. ");
INSERT INTO rifl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","S řemɣaret n uɛuǧi nnec tᵉteḥḥid inni kik ittemɛařan. Mařa tessekked řḥaduq n weɣḍab nnec, ad ten yecc wanita amecnaw iɣeǧ. ");
INSERT INTO rifl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","S usuḍi n wenzaren nnec ɛurrcen waman, ttwassbedden tseǧya am weɣbar, aman ihewřen jemden di řwesṭ n řebḥar. ");
INSERT INTO rifl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Inna řeɛdu: ‘Ad ten aredfeɣ, ad ten ɛduɣ, ad bḍiɣ řmur, řeɛmar inu ad zzaysen ijjiwen, ad dd-jebdeɣ ssif inu, afus inu ad zzaysen ikkes řwart nsen.’ ");
INSERT INTO rifl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tsuḍed s nnefs nnec uca ideř i-ten řebḥar. Nitni hwan-dd am řexfif deg waman imɣaren. ");
INSERT INTO rifl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","A SIDI, man wen i iǧan am Cek jar irebbiten? Wi iǧan am Cek, d wenni ittwassɛuǧen di tqeddast, amweqqar deg izřan n uṣebbeḥ, man wen itteggen řeɛjayeb am Cek? ");
INSERT INTO rifl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tesswiẓẓḍed afus afusi nnec, tsarḍ i-ten temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Cek tgewwded řgens-a s tmexsiwt nnec icuwwaren, aqa tefdid t, s jjehd nnec tnedhed ten ɣar Tzeddiɣt Iqeddsen nnec. ");
INSERT INTO rifl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Řegnus sřin x uya uca arjijen. Teṭṭef teggʷudi deg imezdaɣ n Filicit. ");
INSERT INTO rifl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Řexdenni imeqqranen n tqebbař n Idum ttbehten, inni ɣar teǧa ṣṣulṭa di Mu’ab ttarjijen, u marra imezdaɣ n Kenɛan aqa fesyen! ");
INSERT INTO rifl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Tewḍa xasen řɛurret d tiggʷudi. S řemɣaret n uɣiř nnec seɣden am weẓru, ařami iẓwa řgens nnec, a SIDI, ařami iẓwa řgens-a i tkesbed i Yixef nnec. ");
INSERT INTO rifl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Cek ad ten tnedhed uca ad ten teẓẓud x wedrar n řwart nnec, amcan i teggid d Tazeddiɣt nnec, a SIDI, Zzawect Iqeddsen i iggin ifassen nnec, a Sidi inu. ");
INSERT INTO rifl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","SIDI ad iḥkem i řebda qaɛ! ");
INSERT INTO rifl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Minzi ayis n firɛun yudef ɣar řebḥar s ikarruten nnes d imnayen nnes uca iqřeb xasen SIDI ɛawed aman n řebḥar. Maca ayt n Israil ẓwan x řaẓaɣ di řwesṭ n řebḥar.” ");
INSERT INTO rifl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","U Maryam, tanabit, učmas n Harun, teksi aǧun deg ufus nnes u marra timeṭṭa ffɣent awarni as s ibendiren d ccḍiḥ s nnubtat. ");
INSERT INTO rifl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Xenni tarra-dd xasen Maryam snnubet nnes: “Ɣennjem i SIDI, minzi aqa Netta yuɛřan aṭṭas! Inḍar ayis ak-d wenni xas yenyin di řebḥar.” ");
INSERT INTO rifl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Xenni ijja Musa řgens n Israil ad ifsi iqiḍan nsen, inni iǧan x tma n Řebḥar n Telga, uca ruḥen di řexřa n Cur, uyuren třata n wussan di řexřa břa ad afen aman. ");
INSERT INTO rifl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Uca iwḍen ɣar Mara, maca war zemmaren ad swen aman n Mara, minzi tuɣa aten d imerzagen. X uya ggin as i wemcan nni ‘Mara’. ");
INSERT INTO rifl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Innedqem řgens x Musa, inna: “Min ɣa nsu?” ");
INSERT INTO rifl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Netta iřaɣa i SIDI uca SIDI immeř as ijj n ukeccuḍ uca inḍar i-t daxeř deg waman uca dewřen waman d imiẓiden. Din i d as igga i řgens ict n tewṣeyyet d ict n lfariḍa u dinni i-ten iqeǧeb. ");
INSERT INTO rifl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Inna: “Mařa tesřid mliḥ i wawař n SIDI, AREBBI nnec, teggid min iǧan nican di tiṭṭawin nnes, ad tesřed i řumarat nnes, ad teḥḍid marra tiweṣṣa nnes, xenni Necc war d awem-dd ssekkiɣ řehřac i dd-ssekkeɣ x Miṣra, minzi Necc d SIDI, Amesgenfi nnec!” ");
INSERT INTO rifl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Řexdenni iwḍen ɣar Ilim, mani tuɣa tenɛac n řɛunṣarat n waman, d sebɛin n tcejjura n tini uca wtin iqiḍan nsen dinni zzat i waman. ");
INSERT INTO rifl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Uca fesyen iqiḍan nsen, uyuren zi Ilim, u marra tamesmunt n ayt n Israil tiweḍ ɣar řexřa n Sin i iǧan jar Ilim d Sina. Tuɣa man aya deg wass xemmesṭac n uyur wiss tnayen awarni řami dd-ffɣen zi temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Marra tamesmunt n ayt n Israil tennedqem zi Musa d Harun di řexřa. ");
INSERT INTO rifl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Nnan asen ayt n Israil: “Mři nemmut s ufus n SIDI di temmurt n Miṣra umi tuɣa neqqim ɣar ṭṭbaṣi n weysum, necca aɣrum ařami nejjiwen! Minzi kenniw tessuffɣem aneɣ-dd ɣar řexřa-ya maḥend ad tenɣem marra agraw aya s řaẓ.” ");
INSERT INTO rifl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Xenni inna SIDI i Musa: “Xzar, ad jjeɣ aɣrum ad xawem dd-iwḍa zeg ujenna am wenẓar. Xenni ad iffeɣ řgens, ad ksin min ḥdajen i wass deg wass nni, ḥima ad ten qeǧbeɣ, ma gguren di tɣuri n Ccariɛa inu, niɣ lla. ");
INSERT INTO rifl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ad yiři deg wass wiss setta, ad sswejden min dd-iwyen ɣar daxeř. Man aya ad yiři d tnayen n tseqqar x min ɣa ssmunen kuř ass.” ");
INSERT INTO rifl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Řexdenni inna Musa d Harun i marra ayt n Israil: “Ɣar uɛecci ad tessnem belli SIDI i kenniw dd-issuffɣen zi temmurt n Miṣra, ");
INSERT INTO rifl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","u ɣar ṣṣbeḥ ad tẓarem aɛuǧi n SIDI, minzi aqa Netta isřa anedqem nwem x SIDI. Ma neccin, min neɛna, ḥima kenniw ad xaneɣ tenndeqmem?” ");
INSERT INTO rifl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Inna Musa: “Řami d awem iwca SIDI aysum i macca deg uɛecci u aɣrum di tyawant di ṣṣbeḥ, aqa isřa SIDI anedqem nwem i zi xas tᵉttnedqamem. I neccin, min neɛna? Kenniw war xaneɣ tᵉttnedqamem, maca x SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Inna Musa i Harun: “Ini i tmesmunt n ayt n Israil marra: ‘Reḥḥgem-dd ɣar zzat i wudem n SIDI, minzi aqa isřa i unedqem nwem.’” ");
INSERT INTO rifl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Am issiweř Harun ak-d tmesmunt n ayt n Israil marra, tuɣa xezzaren ɣar řexřa uca xzar, aɛuǧi n SIDI iḍhar-dd deg useynu. ");
INSERT INTO rifl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Necc sřiɣ i unedqem n ayt n Israil. Siweř akidsen uca ini: Jar beddu n wezyen n wass ař dd-tewḍa tmeddit ad teccem aysum, ɣar ṣṣbeḥ ad tejjiwnem s weɣrum uca ad tessnem belli Necc d SIDI, AREBBI nwem.” ");
INSERT INTO rifl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ɣar uɛecci uřyent i-dd ijḍaḍ qqaren as ‘tsalwa’ uca dřint řmargeḥ n řɛeskar u ɣar ṣṣbeḥ tuɣa nnda inneḍ-dd i řmargeḥ. ");
INSERT INTO rifl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Řami dd-igeɛɛed nnda, aqa da, ict n řḥajjet d tazdat am teqcurt, d tazdat am nnda igarsen, tᵉttwaf x wudem n řexřa, x temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ẓrin tt ayt n Israil, nnan ijjen i wenneɣni: “Manawya?”, minzi war ssinen min iɛna. Řexdenni inna asen Musa: “Wa d aɣrum nni d awem iwca SIDI, ḥima ad teccem. ");
INSERT INTO rifl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Wa d awař i d awem yumur SIDI: ‘Ejj ad zzayes iksi kuř ijj ɛlaḥsab min iḥdaj, řeqyas n ijj n uɛumir, ɛřaḥař tnayen litru, i ijjen bnadem. Kuř aryaz ad iksi ɛlaḥsab řqedd n iwdan i ɣares deg uqiḍun.’” ");
INSERT INTO rifl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Uca ammu i ggin ayt n Israil. Yrun zzayes, ijjen aṭṭas, wenneɣni drus. ");
INSERT INTO rifl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Weznen aya s řeqyas n uɛumir. Wenni yrun aṭṭas war ɣares zzyada d wenni yrun drus, war d as ittxeṣṣi ɛad. Kuř ijj iyru macca nnes ɛlaḥsab min iḥdaj. ");
INSERT INTO rifl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Inna asen Musa: “Uřa d ijj ad zzayes yejj ař ṣṣbeḥ.” ");
INSERT INTO rifl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Maca nitni war sřin ca i Musa u ca n yeryazen xemmřen ca zzayes ař ṣṣbeḥ. Xenni udfen dayes ikeccawen uca ibda ad igg ccum. Uca iffugem xasen Musa aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kuř ṣṣbeḥ yrun t, kuř ijj ɛlaḥsab izemmar ad icc netta, minzi mařa teḥma tfuct, tuɣa ittfessi. ");
INSERT INTO rifl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Deg wass wiss setta yrun tnayen n tseqqar n weɣrum, řeqyas n tnayen n iɛumiren i kuř azeǧif. Uca usin-dd marra řḥukkam n tmesmunt uca xebbaren Musa. ");
INSERT INTO rifl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Netta inna asen: “D man aya min xef issiweř SIDI: ‘Tiwecca d ijj n wass n arraḥet, ijj n wass n ssebt d amqeddas i SIDI. Sengʷem min texsem ad tᵉssengʷem, snennam min texsem ad tᵉssennam uca marra min ɣa iqqimen, xemmřem t ař ṣṣbeḥ.’” ");
INSERT INTO rifl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Nitni xemmřen t ař ṣṣbeḥ am mammec ten yumur Musa uca war yarṣuḍ u war dayes tuɣi tkecca. ");
INSERT INTO rifl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Xenni inna Musa: “Ccem aya ass-a, minzi ass-a d ass n ssebt n SIDI. Ass-a war t tᵉttifem deg iyyar. ");
INSERT INTO rifl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Setta n wussan ad teyrum, maca deg wass wiss sebɛa aqa d ssebt, war ittiři walu.” ");
INSERT INTO rifl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Deg wass wiss sebɛa imsar belli ffɣen ca zi řgens, maḥend ad yrun ca, maca war ufin walu. ");
INSERT INTO rifl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Inna SIDI i Musa: “Ař meřmi tugim ad teḥḍam řumurat inu d izerfan inu? ");
INSERT INTO rifl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Xzarem, minzi SIDI iwca awem ass n ssebt, x uya iwca awem deg wass wiss setta aɣrum i tnayen n wussan. Kuř ijj zzaywem ad iqqim deg wemcan nnes! Deg wass wiss sebɛa war dd-itteffiɣ uřa d ijj zeg wemcan nnes!” ");
INSERT INTO rifl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Uca yareyyeḥ řgens deg wass n ssebt. ");
INSERT INTO rifl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Taddart n Israil třaɣa as ‘manna’. Tuɣa-tt d tacemřařt am zzariɛet n řqeṣbur uca aředdi nnes amecnaw tifḍirin n tamment. ");
INSERT INTO rifl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Xenni inna Musa: “Ddegga d awař i zi yumur SIDI: ‘Ccurem zzayes řeqyas n yijj n uɛumir uca xemmeř i-t i marra jjiřat nwem i dd ɣa yasen, ḥima ad ẓaren aɣrum min zi kenniw ssecceɣ di řexřa, umi kenniw ssuffɣeɣ zi temmurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Inna Musa i Harun: “Ksi ijj n uzenbiř uca ɛemmar i-t s yijj n uɛumir n ‘manna’ uca egg i-t zzat i wudem n SIDI, ḥima ad ittwaxemmeř i marra jjiřat nwem.” ");
INSERT INTO rifl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Uca igga i-tt Harun zzat i Cchadet, ḥima ad tᵉttwaxemmeř am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ammu i ccin ayt n Israil ‘manna’ arebɛin n iseggʷusa, ařami iwḍen ɣar temmurt mani ɣa raḥen ad zedɣen. Ccin manna ařami iwḍen ɣar weymir n temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ijj n uɛumir d ɛecra di tesɣart n ijj n ifa. ");
INSERT INTO rifl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Uca fesyen marra tamesmunt n ayt n Israil iqiḍan nsen, uyuren zi řexřa n Sin, am mammec d asen yumur SIDI uca wtin iqiḍan nsen di Rafidim. War din tuɣi aman, ḥima ad issu řgens. ");
INSERT INTO rifl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Xenni imcubbec řgens ak-d Musa, nitni nnan: “Ewc aneɣ aman, ḥima ad nsu!” Musa inna asen: “Mayemmi tᵉttexsem ad kidi temcubbucem? Mayemmi tᵉttqeǧabem SIDI?” ");
INSERT INTO rifl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tuɣa řgens iffud aṭṭas ɣar waman uca nndeqmen zi Musa, nnan: “Maɣar d aneɣ tessgeɛɛded zi Miṣra? Ma ḥima ad ayi thellked s ufadi uřa d tarwa inu d řebhayem inu?” ");
INSERT INTO rifl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Řexdenni isɣuy Musa ɣar SIDI, inna: “Min ɣa ggeɣ ak-d řgens-a? Mɣir cwayt uca ad ayi arejmen.” ");
INSERT INTO rifl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Inna SIDI i Musa: “Ekk zzat i řgens uca ksi akidek ca zeg imɣaren n Israil uca ksi ɛawed deg ufus nnec taɣɣarct nni zi tewtid iɣzar uca ruḥ. ");
INSERT INTO rifl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Xzar, Necc ad beddeɣ din zzatek x teṣḍart ɣar Ḥurib, ad tewted taṣḍart, ad zzayes dd-ffɣen waman uca ad issu řgens.” Igga Musa amenni zzat i tiṭṭawin n imɣaren n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Uca iřaɣa isem n wemcan nni Massa d Mariba, minzi ayt n Israil mmcubbcen din u minzi nitni qeǧben SIDI, nnan: “Ma SIDI aqa-t řexxu di řwesṭ nneɣ niɣ lla?” ");
INSERT INTO rifl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Xenni yusa-dd Ɛamaliq uca immneɣ ak-d Israil di Rafidim. ");
INSERT INTO rifl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Inna Musa i Yacuwa: “Ejj aneɣ ad nixḍar iryazen uca ad neffeɣ, maḥend ad nemmneɣ ak-d Ɛamaliq. Tiwecca ad beddeɣ sennej x tqiccat n tewrirt uca taɣɣarct n AREBBI ad tiři deg ufus inu.” ");
INSERT INTO rifl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Igga Yacuwa am mammec d as inna Musa, immneɣ ak-d Ɛamaliq, maca Musa d Harun d Ḥur uřyen ɣar tqiccat n tewrirt. ");
INSERT INTO rifl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Uca imsar řami issgeɛɛed Musa afus nnes, řexdenni tuɣa Israil tɣeǧeb, maca xmi ittejja afus nnes ad ihwa, řexdenni ɣeǧben ayt n Ɛamaliq. ");
INSERT INTO rifl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ifassen n Musa dewřen ddeqřen. Xenni ksin ijj n weẓru uca ggin t sadu Musa uca iqqim xas uca Harun d Ḥur sennden ifassen nnes, ijj zeg uɣezdis-a, wenneɣni zeg uɣezdis nneɣni. Ammu i iqqimen ifassen nnes geɛɛden ařami teɣři tfuct. ");
INSERT INTO rifl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Uca iɣřeb Yacuwa x Ɛamaliq d řgens nnes s řeqḍeɛ n ssif. ");
INSERT INTO rifl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Xenni inna SIDI i Musa: “Ari aya deg ijj n wedlis ittwannḍen i řidaret dayes uca egg i-t deg imejjan n Yacuwa, belli aqa Necc ad mḥiɣ qaɛ řidaret di Ɛamaliq sadu ujenna.” ");
INSERT INTO rifl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ibna Musa ijj n uɛalṭar uca iřaɣa as s yisem: “SIDI d taɛeǧant inu!” ");
INSERT INTO rifl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Uca inna: “Afus tuɣa x řɛarc n SIDi. SIDI ad yegg garra x Ɛamaliq zi jjiř ař jjiř.” ");
INSERT INTO rifl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Isřa Yitrun, akehhan n Midyan, aḍeggʷař n Musa, marra min igga AREBBI ak-d Musa u ak-d řgens nnes Israil, aqa issuffeɣ-dd SIDI Israil zi Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Iṭṭef Yitrun, aḍeggʷař n Musa, Ṣaffura, tamɣart n Musa, awarni řami d as iwca tirzifin nnes n tesřit, ");
INSERT INTO rifl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","uřa d tnayen n iḥenjiren nnes, ijjen qqaren as Jarcum, minzi tuɣa inna: “Tuɣa ayi d abarrani di temmurt d tabarranect!”, ");
INSERT INTO rifl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","u wenneɣni qqaren as Aliɛazir, minzi tuɣa inna: “AREBBI n baba iɛawen ayi uca ifekk ayi zi ssif n firɛun.” ");
INSERT INTO rifl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yitrun aḍeggʷař n Musa, ak-d iḥenjiren nnes d tmeṭṭut nnes, iwḍen ɣar Musa di řexřa, ɣar mani iwta iqiḍan, ɣar wedrar n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Uca netta ijja ad inin i Musa: “Necc, aḍeggʷař nnec Yitrun, usiɣ-dd ɣarek s temɣart nnec d tnayen n iḥenjiren nnes akides.” ");
INSERT INTO rifl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Xenni iffeɣ Musa ad iřqa aḍeggʷař nnes, ibendeq uca issudem i-t. Ijjen isseqsa wenneɣni x umeddur nnes uca udfen ɣar uqiḍun. ");
INSERT INTO rifl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa iḥaja i uḍeggʷař nnes marra min igga SIDI ak-d firɛun u ak-d Imiṣriyyen di ṭṭweɛ n Israil u x marra tamara nni xasen ikkin deg webrid d mammec ten ifekk SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ifarḥ Yitrun zi marra řxir nni igga SIDI i Israil, umi t ifekk zeg ufus n Imiṣriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Inna Yitrun: “Ad ittwabarek SIDI d wenni kenniw ifekken zeg ufus n Imiṣriyyen u zeg ufus n firɛun, d wenni ifekken řgens zeg ufus n Imiṣriyyen! ");
INSERT INTO rifl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Řexxu ssneɣ belli SIDI imɣar aṭṭas x marra irebbiten, aqa di tmesřact nni dessaren xasen.” ");
INSERT INTO rifl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Xenni iksi Yitrun, aḍeggʷař n Musa, taɣarṣt n wecmaḍ d tiɣarṣa i AREBBI uca yusa-dd Harun jmiɛ ak-d marra imɣaren n ayt n Israil, maḥend ad yecc aɣrum jmiɛ ak-d uḍeggʷař n Musa zzat i wudem n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Tiwecca nnes tuɣa Musa ittɣima x řkursi, maḥend ad iḥkem řgens. Tuɣa řgens ibedd zzat i Musa zi ṣṣbeḥ zic ař ǧiřet. ");
INSERT INTO rifl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Iẓra uḍeggʷař n Musa marra min tuɣa ittegg Musa i řgens, inna: “Manawaya i teggid cek i řgens? Mayemmi tᵉttɣimid cek weḥḥdek u marra řgens ibedd zzatek zi ṣṣbeḥ zic ař ǧiřet?” ");
INSERT INTO rifl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Yarra-dd Musa x uḍeggʷař nnes: “Minzi řgens ittas-dd ɣari ḥima ad ittar ccwar n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","X minni ɣarsen tᵉttiři ca n tmesřact, ttasen-dd ɣari s man aya uca necc ad carrɛeɣ jar ijj d wenneɣni, ssecaneɣ asen tiweṣṣa d izerfan n AREBBI.” ");
INSERT INTO rifl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Řexdenni inna as uḍeggʷař n Musa: “Min teggid war iǧi ca mliḥ. ");
INSERT INTO rifl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ammu i ɣa taḥřed aṭṭas, cek d řgens-a i kik iǧan, minzi man aya idqeř xak aṭṭas, war d as tzemmared ad t tegged weḥḥdek. ");
INSERT INTO rifl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Seř řexxu i wawař inu, necc ad cek neṣḥeɣ uca AREBBI ad kik yiři. Iři cek d aweṣṣay x řgens zzat i AREBBI uca qeddem ddɛawi zzat i AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Scen asen tiweṣṣa d izerfan uca scen asen abrid i ten ittxeṣṣan ad uyuren u řxedmet i d asen ittxeṣṣan ad tt ggen. ");
INSERT INTO rifl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ɛawed xzar cek, ad tarzud jar marra řgens x iryazen izeɛɛamen, inni itteggʷeden AREBBI, iryazen iṣdiqen, inni icarrhen tarezzut x arbeḥ. Egg i-ten d imeqqranen x wařef, d imeqqranen x mya, d imeqqranen x xemsin d imeqqranen x ɛecra. ");
INSERT INTO rifl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ejj i-ten ad carrɛen jar řgens řebda. Ejj i-ten ad qeddmen marra ddɛawi iwɛaren zzatek, maca marra ddɛawi timeẓyanin ad xasent carrɛen s yixef nsen. Egg i-t tefsus x yixef nnec uca ejj i-ten ad tt arbun akidek. ");
INSERT INTO rifl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Mařa teggid aya, u AREBBI i cek yumuren, tzemmared ad teqqimed tbedded uca marra řgens aya ad yaweḍ ɛawed di řehna ɣar wemcan i d asen ittwagg.” ");
INSERT INTO rifl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Isřa Musa ɣar wawař n uḍeggʷař nnes, igga marra min d as inna. ");
INSERT INTO rifl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ixḍar Musa iryazen izeɛɛamen zi marra Israil uca igga i-ten d izeǧifen x řgens: imeqqranen x wařef, imeqqranen x mya, imeqqranen x xemsin d imeqqranen x ɛecra. ");
INSERT INTO rifl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Uca nitni tuɣa ttcarrɛen řgens řebda uca ddɛawi iwɛaren qedmen tent ɣar Musa, maca marra ddɛawi timeẓyanin carrɛen tent s yixef nsen. ");
INSERT INTO rifl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Iqebbeḍ Musa aḍeggʷař nnes uca iɛqeb netta ɣar temmurt nnes. ");
INSERT INTO rifl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Deg uyur wiss třata awarni i wuffuɣ n ayt n Israil zi temmurt n Miṣra, deg wass nni nnit, iwḍen-dd ɣar řexřa n Sina. ");
INSERT INTO rifl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Aqa fesyen iqiḍan nsen, uyuren zi Rafidim uca iwḍen ɣar řexřa n Sina uca wtin iqiḍan nsen di řexřa. Iwta Israil iqiḍan nnes qibač i wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Yuři Musa ɣar AREBBI uca iřaɣa as-dd SIDI zeg wedrar, inna as: “Ammu i ɣa tessiwřed ak-d taddart n Yaɛqub u ammu i ɣa tinid i ayt n Israil: ");
INSERT INTO rifl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Kenniw teẓrim min ggiɣ ak-d Imiṣriyyen u mammec kenniw ksiɣ x wafriwen n ugider uca iwyeɣ-dd kenniw ɣari.    ");
INSERT INTO rifl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Xenni řexxu, mařa tesřim mliḥ ɣar wawař inu u ad teḥḍam Řɛahd inu, ad ɣari tiřim kenniw tiɣřam x marra řegnus, minzi marra tammurt aqa-tt inu. ");
INSERT INTO rifl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kenniw ad ayi tiřim d ict n tgeldit n ikehhanen d ijj n řgens amqeddas.’ Ina d awařen nni d ac ittxeṣṣan ad ten tinid i ayt n Israil.” ");
INSERT INTO rifl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ihwa-dd Musa uca iřaɣa-dd x imɣaren n řgens uca ibarreḥ asen marra awařen-a i d as yumur SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Uca yarra-dd marra řgens, nnan: “Marra min issiweř SIDI, ad t negg!” Uca issiweḍ Musa awařen n řgens ɛawed i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Inna SIDI i Musa: “Xzar, Necc ad ɣarek dd-aseɣ deg ijj n useynu d abarcan, ḥima ad iseř řgens xmi Necc kik ɣa ssiwřeɣ uca ɛawed ad zzayek amnen i řebda.” Minzi Musa ixebbar awařen n SIDI i řgens. ");
INSERT INTO rifl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","SIDI inna i Musa: “Ruḥ ɣar řgens uca sqeddes i-ten ass-a d tiwecca, ejj i-ten ad ssirden arruḍ nsen ");
INSERT INTO rifl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","uca ad iřin wejden i wass wiss třata, minzi deg wass wiss třata ad dd-ihwa SIDI ɣar wedrar n Sina zzat i tiṭṭawin n marra řgens. ");
INSERT INTO rifl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Egg iymiren i řgens deg wenneḍ n wedrar, ini: ‘Ɣarwem, war tiřyem ɣar wedrar niɣ ad tḥadam ṭṭarf nnes. Man wen i ɣa iḥadan adrar, ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","War t ittḥidi ḥed s ufus, minzi xenni ad ittwarjem niɣ ad ittwawwet nican s fřitcat min ma iɛna, řebhimet niɣ d bnadem, war ittɣimi iddar. Mařa ad din yiři ijj n usuḍi deg uyicc n usřiwřew d azirar, zemmaren nitni ad ařyen adrar.’” ");
INSERT INTO rifl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Xenni ihwa-dd Musa zeg wedrar ɣar řgens, issqeddes řgens uca ssirden arruḍ nsen. ");
INSERT INTO rifl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Inna i řgens: “Iřim ttwejdem i wass wiss třata, war dd-ttqarrabem ɣar temɣart.” ");
INSERT INTO rifl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Di ṣṣbeḥ n wass wiss třata usin-dd wajjajen d wassamen. Aqa yarsa ijj n useynu iddeqřen x wedrar u řḥess n usuḍi deg uyicc n icarri idweř ijhed aṭṭas. Marra řgens di řmargeḥ n řɛeskar yarjij. ");
INSERT INTO rifl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa indeh řgens zi řmargeḥ n řɛeskar, maḥend ad iřqa AREBBI uca bedden nitni swadday i wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Marra adrar n Sina iddexxen, minzi SIDI tuɣa ihwa-dd xas di tmessi. Ddexxan nnes yuři-dd am ddexxan n ufarran uca marra adrar inhezz aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Am idweř usuḍi deg uyicc n icarri ijhed aṭṭas, issiweř Musa uca yarra-dd xas AREBBI s yijj n řḥess ijhed. ");
INSERT INTO rifl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Uca ihwa-dd SIDI x wedrar n Sina, x tqiccet n wedrar, uca iřaɣa SIDI i Musa ɣar tqiccet n wedrar. Xenni igeɛɛed Musa. ");
INSERT INTO rifl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Inna SIDI i Musa: “Hwa-dd, ɛřem i řgens, maḥend war ttcuqin di SIDI, maḥend ad t ẓaren uca xenni balak ad ttwahellken aṭṭas zzaysen. ");
INSERT INTO rifl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ejj ɛawed ikehhanen, inni i dd ɣa iqarrben ɣar SIDI, ad ssqeddsen ixef nsen, ḥima SIDI war xasen iseɛɛar ca.” ");
INSERT INTO rifl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Inna Musa i SIDI: “Řgens war izemmar ad igeɛɛed adrar n Sina, minzi Cek tɛeřmed aneɣ tennid: ‘Egg iymiren x wedrar uca sqeddes i-t.’” ");
INSERT INTO rifl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Inna as SIDI: “Ruḥ, hwa! Ad tgeɛɛded cek d Harun akidek, maca ikehhanen d řgens war zemmaren ad cuqen, ḥima ad geɛɛden ɣar SIDI, ḥima Netta war xasen iseɛɛar ca.” ");
INSERT INTO rifl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Řexdenni ihwa-dd Musa ɣar řgens uca inna asen marra aya. ");
INSERT INTO rifl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Issiweř AREBBI marra awařen-a, inna: ");
INSERT INTO rifl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Necc d SIDI, AREBBI nnec, wenni cek dd-issuffɣen zi temmurt n Miṣra, zi taddart n tesmuɣi. ");
INSERT INTO rifl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","War ɣarek ttiřin irebbiten nneɣni zzat i wudem inu. ");
INSERT INTO rifl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","War ttegg i yixef nnec řexyař ineqcen niɣ ca n řḥajjet tarwes di min iǧan sennej deg ujenna niɣ di ca da swadday di temmurt niɣ di ca deg waman i iǧan sadu temmurt. ");
INSERT INTO rifl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","War d asen ttbendiq uřa ad xasen tsexxared, minzi Necc, SIDI, AREBBI nnec, d ijj n Arebbi ittasmen, wenni dd-yarezfen řmuɛṣiyyet n ibabaten di tarwa ař jjiř wiss třata d wiss arebɛa n yinni d ayi icarrhen, ");
INSERT INTO rifl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","d wenni isscanen tamexsiwt nnes icewwaren i řuřuf n yinni d ayi ittexsen u ḥeṭṭan řumurat inu. ");
INSERT INTO rifl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","War neṭṭeq s Yisem n SIDI, AREBBI nnec, di řbaṭeř, minzi war ittbarri SIDI i wenni i ɣa ineṭqen s Yisem nnes di řbaṭeř. ");
INSERT INTO rifl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Idar ass n ssebt, ḥima ad t tessqeddsed. ");
INSERT INTO rifl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Setta n wussan i ɣa txedmed, ad tegged marra řxedmet nnec. ");
INSERT INTO rifl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ass wiss sebɛa d wass n ssebt n SIDI, AREBBI nnec. War dayes ttegg uřa d ict n řxedmet, cek lla, uřa d mmic lla, d yeǧic lla, d ismeɣ nnec lla, d tayya nnec lla, d řebhimet nnec lla, uřa d abarrani nni akidek iǧan daxeř i tewwura nnec lla. ");
INSERT INTO rifl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Minzi di setta n wussan igga SIDI ijenwan d temmurt, řebḥar d marra min dayes uca yareyyeḥ deg wass wiss sebɛa. X uya ibarek SIDI ass n ssebt uca issqeddes i-t. ");
INSERT INTO rifl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Weqqar babac d yemmac, maḥend ussan n tudart nnec zemmaren ad zzuggarten di temmurt i d ac ɣa yewc SIDI, AREBBI nnec. ");
INSERT INTO rifl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","War neqq. ");
INSERT INTO rifl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","War zenna. ");
INSERT INTO rifl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","War ttacar. ");
INSERT INTO rifl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","War cehhed s ẓur ḍidd i jjar nnec. ");
INSERT INTO rifl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","War meẓri di ca, taddart n jjar nnec war dayes meẓri. War meẓri di tamɣart n jjar nnec, niɣ deg yismeɣ nnes, niɣ di tayya nnes, niɣ deg ufunas nnes, niɣ deg weɣyuř nnes uřa deg ict n řḥajjet i iǧan n jjar nnec.” ");
INSERT INTO rifl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Marra řgens iẓra u isřa i wajjajen d wassamen d ddriz n usuḍi deg uyicc n icarri d wedrar idduxxunen. Umi iẓra řgens man aya, xenni arjijen uca beɛɛden nitni ɣar řaggʷaj. ");
INSERT INTO rifl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Nnan i Musa: “Siweř cek akidneɣ uca ad nseř. Maca ittxeṣṣa AREBBI war kidneɣ issiwiř, ḥima war nettmetti!” ");
INSERT INTO rifl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Inna Musa i řgens: “War teggʷedem ca, aqa yusa-dd AREBBI, ḥima ad kenniw iqeǧeb u ḥima ad zzayes teggʷedem maḥend war txeṭṭim ca.” ");
INSERT INTO rifl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ibedd řgens zi řaggʷaj, maca Musa iqarreb-dd ɣar useynu ibbumbsen mani tuɣa AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Inna SIDI i Musa: “Ammu ittxeṣṣa ad tinid i ayt n Israil: ‘Kenniw teẓrim belli ssiwřeɣ-dd akidwem zeg ujenna. ");
INSERT INTO rifl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","War kidi tteggem irebbiten n nnuqart u war tteggem irebbiten n wureɣ i yixef nwem. ");
INSERT INTO rifl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Egg ayi ijj n uɛalṭar s ucař, qeddem xas tiɣarṣa nnec n wecmaḍ d tiɣarṣa nnec n řehna, uǧi nnec d ifunasen d tfunasin nnec. Di kuř amcan mani ɣa ggeɣ řidaret n Yisem inu, ad ɣarek dd-aseɣ uca ad ac barkeɣ. ");
INSERT INTO rifl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mařa teggid ayi ijj n uɛalṭar n iẓra, war t tbennid s tṣuḍar ittwassuydan, minzi mařa teddzed s uřeyzim nnec, iři ad t tessɛiǧted. ");
INSERT INTO rifl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","War ttgiɛɛid ɣar uɛalṭar inu s yijj n ddruj, ḥima war ittbin useḍḥi nnec.” ");
INSERT INTO rifl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Tina i iǧan d lfarayiḍ nni d asen ɣa tessiwḍed. ");
INSERT INTO rifl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Mařa tesɣid ismeɣ d Aɛibrani, xenni netta ad ac isexxar setta n iseggʷusa, maca deg useggʷas wiss sebɛa ad iffeɣ d aḥurri baṭeř. ");
INSERT INTO rifl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Mařa yudef weḥḥdes, weḥḥdes i ɣa iffeɣ, mařa ɣares tamɣart, ad iffeɣ netta d temɣart nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mařa sidis iwca as tamɣart uca nettat tejja as-dd iḥenjiren d tḥenjirin, xenni tamɣart d tarwa nnes ad iřin n sidis, u xenni netta ad iffeɣ s iman nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Maca mařa ismeɣ inna nican: ‘Necc xseɣ sidi inu d temɣart inu d tarwa inu, war xseɣ ad ffɣeɣ d aḥurri!’, ");
INSERT INTO rifl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","řexdenni sidis ad t issbedd zzat i AREBBI. Ad t yawi ɣar tewwart niɣ ɣar tefřawt ɣar uɣezdis n tewwart uca sidis ad as issnuqqeb amejjun nnes s yict n tsineft uca netta ad as isexxar i řebda. ");
INSERT INTO rifl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Mařa izzenz ḥed yeǧis d tayya, war itteffiɣ am muxas tteffɣen isemɣan. ");
INSERT INTO rifl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Mařa war teɛjib i tiṭṭawin n sidis u netta tuɣa ixḍeb i-tt, ad tt yejj ad tᵉttwafdi. War izemmar ad tt izzenz i yijj n řgens n barra minzi netta iɣdar zzayes s min igga. ");
INSERT INTO rifl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Mařa ixḍeb i-tt i mmis, ad kides yegg ɛlaḥsab lfariḍa zi jjhet n yeǧis. ");
INSERT INTO rifl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Mařa iksi tamɣart nneɣni i yixef nnes, war ineqqeṣ řɛuč n weysum nnes, niɣ arruḍ nnes, niɣ řɛacart nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Mařa netta war d as iggi třata-ya, xenni nettat ad teffeɣ baṭeř, břa řexraṣ.” ");
INSERT INTO rifl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Wenni i ɣa iwten ḥed ař ɣa immet, ad t nɣen nican. ");
INSERT INTO rifl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mařa war t iggi neɛmada, maca AREBBI igga as-dd deg ufus nnes, řexdenni Necc ad ac ssecneɣ amcan mani izemmar ad yarweř. ");
INSERT INTO rifl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Maca mařa yuff ḥed x wajjar nnes uca inɣa i-t s řeɣdaret, xenni ad t teksid ɣar uɛalṭar inu, maḥend ad t nɣen. ");
INSERT INTO rifl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wenni iwtin babas niɣ yemmas, ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wenni yucaren bnadem uca izzenz i-t, niɣ ittwaf ɛad ɣares, ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wenni i ɣa ineɛřen babas niɣ yemmas, ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Mařa iryazen mmcubbcen uca ijjen iwta wenneɣni s weẓru niɣ s řpuniyyet, uca wanita war immut, maca iwḍa di tassut, ");
INSERT INTO rifl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","xenni, mařa wanita ikkar ɛawed uca yuyur ɣar barra x teɣɣarct, ad yiři wenni t iwtin d amezdag. Ad as ixeǧeṣ mɣir min yareyyeḥ uca ad t yejj ad iggenfa mliḥ. ");
INSERT INTO rifl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Mařa iwta ḥed ismeɣ nnes niɣ tayya nnes s weɛmud uca immut sadu ufus nnes, xenni ittxeṣṣa ad as yaɣ x tesɣart nnes nican. ");
INSERT INTO rifl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Maca mařa iqqim ibedd ijj niɣ tnayen n wussan, war d as yuɣi tasɣart, minzi netta d tamenyat n nnuqart nnes i yeǧa. ");
INSERT INTO rifl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Mařa iryazen mmenɣen uca wtin ict n temɣart s ddeyset uca iwḍa as-dd uɛeddis nnes, maca war iǧi ca d ayezzim, xenni netta ad ixeǧeṣ nican ijj n multa ɛlaḥsab min d as ɣa ittar weryaz n temɣart uca ad tt iwc i řquḍat. ");
INSERT INTO rifl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mařa imsar ca n uyezzim d aɛeffan, řexdenni ad tewced tudart s tudart, ");
INSERT INTO rifl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","tiṭṭ s tiṭṭ, tiɣmest s teɣmest, afus s ufus, aḍar s uḍar, ");
INSERT INTO rifl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","acmaḍ s wecmaḍ, ayezzim s uyezzim, ticti s tecti. ");
INSERT INTO rifl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Mařa iřqef ḥed tiṭṭ n ismeɣ nnes niɣ tiṭṭ n tayya nnes, iḍeyyeɛ i-tt, xenni ad t yejj ad yuyur amenni zi ssibbet n tiṭṭ nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Mařa s tecti ittekkes tiɣmest n ismeɣ nnes, niɣ tiɣmest n tayya nnes, xenni ad as yejj ad yuyur amenni zi ssibbet n teɣmest nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Mařa afunas ibarrez aryaz niɣ tamɣart, u wanita immut, xenni ad arjmen afunas u aysum nnes war zzayes ttᵉtten. Bab n ufunas ad yiři d afurri. ");
INSERT INTO rifl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Maca mařa afunas tuɣa d abarrez iḍennaḍ d fariḍennaḍ uca bab nnes tuɣa issen uca war t iḥḍi uca inɣa aryaz niɣ tamɣart, xenni ad arjmen afunas uca ɛawed ad nɣen bab nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mařa ggin xas ddeyyet, řexdenni ad iwc marra min xas ggin d ttaman n ufekki i tudart nnes, ");
INSERT INTO rifl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","niɣ mařa afunas ibarrez aḥenjir niɣ taḥenjirt. Ad as ggen ɛlaḥsab lfariḍa-ya. ");
INSERT INTO rifl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Mařa afunas ibarrez ismeɣ niɣ tayya, ad wcen třatin ciqlu n nnuqart i sidis, uca afunas ad t arjmen. ");
INSERT INTO rifl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Mařa yarzem ḥed anu niɣ mařa iɣza ḥed anu uca war t idři, uca iwḍa dayes ufunas niɣ aɣyuř, ");
INSERT INTO rifl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","xenni bab n wanu ad ixeǧeṣ. Ad yarr nnuqart i bab nnes uca řebhimet immuten ad tiři nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Mařa afunas iyzem afunas n wajjar nnes ařami immut, řexdenni ad zzenzen afunas iddaren, ad bḍan tamenyat-a jar asen uca ad bḍan ɛawed afunas amettin. ");
INSERT INTO rifl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Maca mařa issen belli afunas ibarrez iḍennaḍ d fariḍennaḍ, uca bab nnes war t iḥḍi, ad ixeǧeṣ afunas s ufunas uca afunas amettin ad yiři nnes. ");
INSERT INTO rifl_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Mařa yucar ḥed afunas niɣ ijjen zeg wuǧi uca iɣarṣ as niɣ izzenz i-t, xenni ad ixeǧeṣ xemsa n ifunasen x yijj n ufunas u arebɛa n wuǧi x yijjen n wuǧi.” ");
INSERT INTO rifl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Mařa ittwaf uceffar ɛad am ittacar, uca iwta i-t uca immut, war ttiřin idammen x wenni t yufin. ");
INSERT INTO rifl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Mařa tenqar-dd xas tfuct, ad xas iřin idammen di ssibbet-a. Ad as ixeǧeṣ uceffar marra. Mařa war ɣares ca, ad immenz di ssibbet n tucceffra nnes. ");
INSERT INTO rifl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Mařa tᵉttwaf tucceffart teddar deg ufus nnes, ma d afunas i tt tuɣa niɣ d aɣyuř niɣ d ijjen zeg wuǧi, ittxeṣṣa as ad ixeǧeṣ tnayen n tseqqar. ");
INSERT INTO rifl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Mařa ijja ḥed ad heddan řmař iyyar niɣ amarjeɛ n uḍiř uca yarwes dayes taḥimart nnes uca ad asen iḍřeq ařami ad heddan di temmurt n wenneɣni, xenni ad tt ixeǧeṣ zi řemxeyyer n yeyyar nnes u zi řemxeyyer n umarjeɛ n uḍiř nnes. ");
INSERT INTO rifl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Mařa teffeɣ-dd tmessi uca teřqef asennan uca tecca tiqebbiḍin n imendi niɣ imendi ibedden niɣ iyyar, xenni wenni iqqden timessi ad ixeǧeṣ marra min ittwacemḍen. ");
INSERT INTO rifl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Mařa iḥḍa ḥed i wajjar nnes nnuqart niɣ řeqcuɛ u man aya ittwacar as zi taddart n weryaz nni, xenni aceffar, mařa ufin t, ad ixeǧeṣ tnayen n tseqqar. ");
INSERT INTO rifl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Mařa war ittwif uceffar, řexdenni ad ssqarrben bab n taddart ɣar AREBBI maḥend ad ssnen ma war isswiẓẓeḍ ufus nnes ɣar wagřa n wajjar nnes. ");
INSERT INTO rifl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Kuř aɛeddi zi jjihet n ufunas niɣ n weɣyuř niɣ n ijj zeg wuǧi niɣ n warruḍ niɣ n min iweddaren i zzayes inna ḥed: ‘Aqa-t d wa!’, ad dd-tas tmesřact i iǧan jar asen s tnayen zzat i řquḍat uca wenni ad xas ḥekmen řquḍat ad ixeǧeṣ i wajjar nnes tnayen n tseqqar. ");
INSERT INTO rifl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Mařa iwca ḥed i wajjar nnes aɣyuř niɣ afunas niɣ ijj n zeg wuǧi, niɣ mammec ma tegga řebhimet, ḥima ad t iḥḍa uca immut niɣ yarreẓ niɣ ucaren t, am war iẓri ḥed, ");
INSERT INTO rifl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","xenni ad tiři tjaǧit ɣar SIDI jar asen s tnayen belli war isswiẓẓeḍ afus nnes ɣar wagřa n wajjar nnes. Bab nnes ad iqbeř tajaǧit nnes uca ad taf břa ma ad t ittxeǧeṣ wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Maca mařa ittwacar nican zzayes, di lḥala-ya ad ixeǧeṣ i bab nnes. ");
INSERT INTO rifl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mařa iban aqa ittwamezzeq nican, ad t yawi d burhan uca war ittxeǧiṣ min ittwamezzqen. ");
INSERT INTO rifl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Mařa yarḍeř ḥed ca x wajjar nnes uca tarreẓ niɣ temmut di řɣayeb n bab nnes, ittxeṣṣa as ad tt ixeǧeṣ marra. ");
INSERT INTO rifl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Maca mařa bab nnes tuɣa iḥḍar, war tt ittxiǧaṣ. Mařa tuɣa icra tt xas, ad dd-yas x řexřaṣ nnes.” ");
INSERT INTO rifl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","“Uca mařa immarḍen ḥed x ca n teɛzařect, tuɣa war tt ixḍib ḥed ɛad, uca iṭṭeṣ akides, ittxeṣṣa as ad as iwc ṣṣadaq imun maḥend ad tt yawi d tamɣart. ");
INSERT INTO rifl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Mařa babas war ixs ad as tt iwc, ad as iwzen ɛad ṣṣadaq n teɛzuray s nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","War ttejji taseḥḥart ad teddar. ");
INSERT INTO rifl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Man wen i ɣa iṭṭṣen ak-d ijj n řmař, ad t nɣen nican. ");
INSERT INTO rifl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Wenni i ɣa iwehhben ca n tɣarṣt i irebbiten, war iǧi mɣir i SIDI waha, ittxeṣṣa ad ittwaḥarrem i uteḥḥi. ");
INSERT INTO rifl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","War ddeǧem abarrani u war xas ttzeyyarem, minzi tuɣa uřa d kenniw d ibarraniyyen di temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","War ttdeǧi ca ict n tajjač niɣ ijj n uyujiř. ");
INSERT INTO rifl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mařa tiwḍed ad t tesseḥqared aṭṭas uca netta isɣuy-dd ɣari, aqa Necc s uɣiř ad sřeɣ i tɣuyyit nnes. ");
INSERT INTO rifl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ad yareɣ weɣḍab inu uca Necc ad kenniw nɣeɣ s ssif, timeṭṭa nwem ad dewřent d tijjař d tarrawt nwem d iyujiřen. ");
INSERT INTO rifl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mařa tareḍřed nnuqart i řgens inu, i umezřuḍ i din ɣarek, xenni war kides ttegged am ittegg bab n umarwas: war xas ttegg ca arriba. ");
INSERT INTO rifl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Mařa teksid arruḍ n wajjar nnec d aḍman, arr as t qbeř ma ad teɣři tfuct. ");
INSERT INTO rifl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Minzi war ɣares mɣir ařeḥḥaf wanita, aqa-t d arruḍ x teřmect nnes. Min di ɣa iṭṭeṣ xenni? Xmi ɣari dd ɣa isɣuy, řexdenni ad as sřeɣ, minzi Necc aqa d aḥnin! ");
INSERT INTO rifl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","War ttceqqif di AREBBI u war ttekkʷar řḥakem n řgens nnec. ");
INSERT INTO rifl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","War sɛeṭṭařa taccuret n tmeyra nnec niɣ aḥřay n teysart nnec. Ad ayi tewced uřa d amenzu n iḥenjiren nnec. ");
INSERT INTO rifl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ammu i ɣa tegged ɛawed s ifunasen nnec d wuǧi nnec. Sebɛa n wussan ad iřin ak-d yemmatsen uca ɣar wass wiss tmenya ad ayi ten tewced. ");
INSERT INTO rifl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ad ayi tiřim d imqeddasen u war ttᵉttem aysum i ittwamezzqen di řexřa. Ad t tenḍarem i yiṭan.”    ");
INSERT INTO rifl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“War ssuffuɣ řexbar issxarriqen. War ttic afus nnec i uɛeffan, maḥend ad tiřid d acehhad n ddeǧ. ");
INSERT INTO rifl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","War areddef azyen ameqqran di řɣar u war dd-ttarri di ddeɛwet ař ɣa tmeyyřed teggʷejed x řḥeqq awarni i waṭṭas, ad tfarɣed řḥeqq. ");
INSERT INTO rifl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Di ddeɛwet nnes war ttriḥ ca ak-d řmeskin. ");
INSERT INTO rifl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Mařa teřqid afunas niɣ aɣyuř iweddar n řeɛdu nnec, ittxeṣṣa ad as t tarred nican. ");
INSERT INTO rifl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Mařa teẓrid aɣyuř n wenni tcarrhed iwḍa s ddqeř nnes, ittxeṣṣa cek ad teḥḍid ixef nnec ad tejjed tamesřact i netta waha, maca cek d netta jmiɛ ad tfekkem aɣyuř qaɛ. ");
INSERT INTO rifl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","War sfarraɣ tasɣart n umezřuḍ i din ɣarek di ddeɛwet nnes. ");
INSERT INTO rifl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Beɛɛed x tmesřact iɣeccen. War neqq afurri niɣ amsegged, minzi Necc war ttbarriɣ aɛeffan. ");
INSERT INTO rifl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","War kessi tarzeft, minzi tarzeft tessdarɣař tiṭṭawin yarezmen u tessfarraɣ awařen n imseggden. ");
INSERT INTO rifl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","War tzeyyarem x ubarrani. Aqa kenniw tessnem nnefs n ubarrani, minzi tuɣa kenniw d ibarraniyyen di temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Setta n iseggʷusa ad tzarɛed tammurt nnec uca ad tessmuned řɣiǧet nnes. ");
INSERT INTO rifl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Deg useggʷas wiss sebɛa ad tt tejjed ad tareyyḥed uca ad as tarxud, ḥima ad zzayes ccen imezřaḍ n řgens nnec. Uca min ɣa jjen nitni ad zzayes ccen řmař n řexřa. Ammu i ɣa tegged ɛawed s umarjeɛ n uḍiř nnec d zzitun nnec. ");
INSERT INTO rifl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Di setta n wussan ad tegged řxedmet nnec u deg wass wiss sebɛa ad tareyyḥed, maḥend ad yareyyeḥ ufunas nnec d weɣyuř nnec u ad yarr nnefs mmis n tayya nnec d ubarrani.” ");
INSERT INTO rifl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Di marra min d awem nniɣ, ḥḍam t. War ttidarem isem n irebbiten nneɣni. War ttesřan isem nnes zeg uqemmum nnec. ");
INSERT INTO rifl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Třata n twařawin deg useggʷas ad ayi tɛeyydem ijj n řɛid. ");
INSERT INTO rifl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Řɛid n Weɣrum břa Antun ad t teḥḍam. Sebɛa n wussan ad tecced aɣrum břa antun, am mammec kenniw umureɣ Necc, di řweqt ittwaggen deg uyur Abib, minzi dayes i dd-teffɣed zi Miṣra. War dd-ttusim s ifassen xwan zzat i wudem inu. ");
INSERT INTO rifl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ḥḍam ɛawed Řɛid n Tmeyra, Řɛid n Tmenzut n řxedmet nnec i tzarɛed deg iyyar, u Řɛid n Usmuni n ṣṣabet deg uneggar n useggʷas, xmi ɣa tessmuned řɣiǧet n řxedmet nnec zeg iyyar. ");
INSERT INTO rifl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Třata n twařawin deg useggʷas ad ḍharen marra iryazen n řgens nnec i wudem n Sidi, SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","War ttqeddam idammen n tɣarṣt inu ak-d min ixemmaren, u tadunt n tɣarṣt n řɛid inu war ttnusi ǧiřet tekmeř ař ṣṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tamezwarut n tmenzut zeg wudem n temmurt nnec ad tt tawyed ɣar Taddart n SIDI, AREBBI nnec. War snenni iɣayḍ d ameẓyan s uɣi n yemmas. ");
INSERT INTO rifl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Xzar, ad ssekkeɣ ijj n lmalak zzat i wudem nnec, ḥima ad cek iḥḍa deg webrid uca ad cek yawi ɣar wemcan nni sswejdeɣ. ");
INSERT INTO rifl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ḥḍa arendad i wudem nnes uca seř i wawař nnes, war xas ssarzig ca řeɛmar, minzi netta war ittekkes iɛeddiyen nwem, minzi Isem inu aqa-t dayes. ");
INSERT INTO rifl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Maca mařa s tidett ad tesřed i wawař nnes, ad tegged marra min d ac ɣa iniɣ, ad iřiɣ d řeɛdu i řɛedyan nnec uca ad ḥṣareɣ inni cek iḥeṣṣaren. ");
INSERT INTO rifl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Minzi lmalak inu ad yiři zzatek, ad cek ssidfeɣ di temmurt n Imuriyyen d Iḥittiyyen d Ifiriziyyen d ayt n Kenɛan d Iḥiwiyyen d Iyabusiyyen, u Necc ad ten teḥḥiɣ. ");
INSERT INTO rifl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","War ttbendiq i irebbiten nsen niɣ ad ten tɛebded niɣ ad tegged am tteggen nitni, maca ad ten tᵉteḥḥid qaɛ uca ad tarẓed marra imayḍuten nsen iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ad tɛebdem SIDI, AREBBI nwem, u Netta ad ibarek aɣrum nnec d waman nnec. Necc ad kkseɣ řehřacat zi řwesṭ nnec. ");
INSERT INTO rifl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","War ttiři temɣart nni umi iwḍa uɛeddis niɣ war ittirwen di temmurt nnec. Necc ad kemmřeɣ řqedd n wussan nnec. ");
INSERT INTO rifl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ad ssekkeɣ anexřiɛ zzat i uɣembub nnec, ad ssxarewḍeɣ marra řgens i ɣa tafed deg webrid nnec uca ad arreɣ marra řɛedyan nnec ad xak arewřen. ");
INSERT INTO rifl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Necc ad ssekkeɣ irezzan zzat i uɣembub nnec, inni ɣa yaẓẓřen x Iḥiwiyyen d ayt n Kenɛan d Iḥittiyyen zzat i wudem nnec. ");
INSERT INTO rifl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","War xasen ttaẓẓřeɣ zi zzat nwem deg ijj n useggʷas, maḥend war tᵉttɣimi temmurt d řexřa u řmař n řexřa war xak ttmarnin aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","S cway cway ad xasen aẓẓřeɣ zi zzat necc, ař ɣa temmarenyed deg waṭṭas uca ad tzemmared ad teksid tammurt d řwart. ");
INSERT INTO rifl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Necc ad ggeɣ iymiren zi Řebḥar n Telga ař řebḥar n Ifilisṭiniyyen u zi řexřa ař iɣzar n Lfuraṭ, minzi ad arreɣ imezdaɣ n temmurt deg ufus nnec uca ad cek arreɣ ad xasen taẓẓřed zi zzat nnec. ");
INSERT INTO rifl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","War kidsen ttegg řɛahd niɣ ak-d irebbiten nsen. ");
INSERT INTO rifl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","War iɛeddeř ad zedɣen di temmurt nnec, ḥima war cek ttarrin ad akidi texḍid. Mařa tɛebded i irebbiten nsen, ad ac yiři man aya d řfex i cek.” ");
INSERT INTO rifl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Uca inna Netta i Musa: “Geɛɛed ɣar SIDI, cek d Harun d Nadab d Abihu, d sebɛin n imɣaren n Israil, uca bendqem zi řaggʷaj. ");
INSERT INTO rifl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa weḥḥdes ad dd-iqarreb ɣar SIDI, maca war iɛeddeř ad qarrben nitni. Uřa d řgens war kides ittgiɛɛid ca.” ");
INSERT INTO rifl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa iɛqeb-dd uca ixebbar řgens x marra awařen n SIDI u x marra lfarayiḍ. Marra řgens yarra-dd s yijj n wawař, nnan: “Marra awařen i inna SIDI ad zzaysen negg.”    ");
INSERT INTO rifl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa yura marra awařen n SIDI. Ɣar ṣṣbeḥ zic ikkar uca ibna ijj n uɛalṭar ɣar iḍaren n wedrar uca igga tenɛac n imayḍuten n weẓru, ɛlaḥsab řqedd n tenɛac n tqebbař n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Issekk iḥudriyyen zeg ayt n Israil, inni issbexxaren tiɣarṣi n wecmaḍ u qeddmen tiɣarṣi n řehna zeg ifunasen imeẓyanen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Iksi Musa azyen n idammen, igga i-t di ṭṭbaṣi uca azyen nneɣni n idammen izeǧeɛ i-ten x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Iksi adlis ittwannḍen n Řɛahd, iɣra i-t x imezzuɣen n řgens uca nitni nnan: “Marra min d aneɣ inna SIDI, ad t negg, ad t nṭaɛ.” ");
INSERT INTO rifl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Iksi Musa idammen, irucc i-ten x řgens, inna: “Xzar, ina d idammen n Řɛahd nni igga SIDI akidwem x marra awařen-a.” ");
INSERT INTO rifl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Igeɛɛed Musa ak-d Harun d Nadab d Abihu d sebɛin n imɣaren n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ẓrin AREBBI n Israil. Tuɣa sadu iḍaren nnes am tisi n zzellij i ittwaggen n ṣaffir aziza, iṣfa am ujenna simant nnes. ");
INSERT INTO rifl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","War isswiẓẓeḍ afus nnes x imcennɛen n ayt n Israil uca nitni xzaren ɣar AREBBI, ccin, swin. ");
INSERT INTO rifl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Inna SIDI i Musa: “Geɛɛed-dd ɣari ɣar wedrar uca qqim din uca Necc ad ac wceɣ tiřwiḥin n weẓru, Ccariɛa d řumarat tinni uriɣ x teřwiḥin, ḥima ad asen tent tessřemded.” ");
INSERT INTO rifl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ikkar Musa ak-d Yacuwa, amsexxar nnes, uca igeɛɛed Musa ɣar wedrar n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Inna i imɣaren: “Rajam aneɣ danita ař dd ɣarwem i ɣa nedweř. Xzar, Harun d Ḥur akidwem. Mařa din ḥed ɣares ddɛawi, ittxeṣṣa as ad ɣarsen iraḥ.” ");
INSERT INTO rifl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Xenni igeɛɛed Musa ɣar wedrar, uca ijj n useynu idřa adrar. ");
INSERT INTO rifl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Aɛuǧi n SIDI tuɣa izeddeɣ deg wedrar n Sina u aseynu idřa i-t setta n wussan uca deg wass wiss sebɛa iřaɣa-dd Netta x Musa zi řwesṭ n useynu. ");
INSERT INTO rifl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ascan n uɛuǧi n SIDI tuɣa-t di tiṭṭawin n ayt n Israil am tmessi ittetten x tqiccat n wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Yudef Musa ɣar řwesṭ n useynu uca igeɛɛed adrar. Tuɣa Musa iqqim arebɛin n wussan d arebɛin n ǧyaři deg wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ini i ayt n Israil ad ayi dd-ssgaɛɛden tawhibt. Zi kuř aryaz nni d as iɛarren wuř nnes, ad zzayes teksim tawhibt n usgaɛɛed i Necc. ");
INSERT INTO rifl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ta d tawhibt n usgeɛɛed, tenni i ɣa teksid zzaysen: ureɣ d nnuqart d nnḥas, ");
INSERT INTO rifl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","d ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen d řeqṭen azdad d ccɛar n iɣayḍen, ");
INSERT INTO rifl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","d iřmawen izeggʷaɣen n icarriyyen, d iřmawen n ddenfiřat, d ukeccuḍ n tcejjart n ukasiya, ");
INSERT INTO rifl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","zzect i tfawt n řqendiř, řeɛṭur i zzect n wedhan u i řebxur ittfuḥen, ");
INSERT INTO rifl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","iẓra n uniks d iẓra iɣřan nneɣni, maḥend ad ten ggen x upalṭu u x tajmect. ");
INSERT INTO rifl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ad ayi ggen ict n Zzawect Iqeddsen, ḥima ad zedɣeɣ di řwesṭ nsen. ");
INSERT INTO rifl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ad t tegged am marra min d ac ɣa ssecneɣ, ɛlaḥsab amedya n Tzeddiɣt u ɛlaḥsab amedya n marra řeqcuɛ i dayes iǧan. ");
INSERT INTO rifl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ad ggen ɛawed ict n Ttabut n ukeccuḍ n tcejjart n ukasiya. Ad tiři tuzzeggart nnes tnayen n iɣaǧen d wezyen u tiru nnes ijj n uɣiř d wezyen u řuɛřa nnes ijj n uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ad t ttcelled s wureɣ iṣfan, zi daxeř u zi barra ad tt tcelled, uca ɣar sennej ad as tennḍed ijj n zzwaq n wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ad as tessfesyed arebɛa n texrazin n wureɣ. Ad tent tcedded ɣar arebɛa n tyarsawin nnes. Tnayen n texrazin ad iřint ɣar yijj n uɣezdis u tnayen n texrazin i uɣezdis nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ad tegged iɛumad i trebbut zeg ukeccuḍ n tcejjart n ukasiya uca ad ten tedřed s wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Sidfem iɛumad di texrazin nni iǧan ɣar iɣezdisen n Ttabut, ḥima ad zzaysen arbun Ttabut. ");
INSERT INTO rifl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Iɛumad ad iřin di texrazin n Ttabut, war zzaysent ten ttekksen ca. ");
INSERT INTO rifl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ad tessarsed Cchadet, tenni i d ac ɣa wceɣ, di Ttabut. ");
INSERT INTO rifl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ad tegged ɛawed ict n tqebbart n weṣřaḥ n wureɣ iṣfan s yict n tuzzeggart n tnayen n iɣaǧen d wezyen u s ict n tiru n ijj n uɣiř d wezyen.    ");
INSERT INTO rifl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ad tegged ɛawed tnayen n ikiruben n wureɣ iɛdeř s wefḍis, ařami i ɣa ffɣen ikiruben zi tnayen n ixfawen n tqebbart n weṣřaḥ.    ");
INSERT INTO rifl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ad tegged ijj n ukirub ɣar ijj n yixef u ijj n ukirub nneɣni ɣar yixef nneɣni. Ad teggem ikiruben zi tqebbart n weṣřaḥ ɣar tnayen n ixfawen nnes. ");
INSERT INTO rifl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ad bezzɛen ikiruben afriwen nsen sennej nsen uca ad dřen taqebbart n weṣřaḥ s wafriwen nsen. Udmawen nsen ad iřin ijj qibač i wenneɣni uca ad ẓaren udmawen n ikiruben ɣar tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ad tegged taqebbart n weṣřaḥ x Ttabut uca ad tessarsed Cchadet i d ac ɣa wceɣ di Ttabut. ");
INSERT INTO rifl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Dinni i kic ɣa mmeřqiɣ uca ad kik ssiwřeɣ zi sennej i tqebbart n weṣřaḥ, zi jar tnayen n ikiruben nni iǧan sennej i Ttabut n Cchadet, x marra min d ac ɣa umureɣ i ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ad tegged ict n tzewḍa n ukeccuḍ n tcejjart n ukasiya, ad ɣares tiři ict n tuzzeggart n tnayen n iɣaǧen d ict n tiru n ijjen uɣiř d ijj n řuɛřa n ijjen uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ad tt tedřed s wureɣ iṣfan uca ad as tegged ɣar tma nnes ijj zzwaq n wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ad tegged ict n tma i d as dd-innḍen n ijj n cbar n ufus u ɣar tma i d as dd-innḍen ad tegged ijj n zzwaq n wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ad tegged arebɛa n texrazin n wureɣ uca ad tent tcedded ɣar arebɛa n tɣemmura nni iǧan ɣar arebɛa n iḍaren nsen. ");
INSERT INTO rifl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Tixrazin ad iřint udsent i tma, maḥend ad daysent ttwaṭṭfen iɛumad i tarebbut n tzewḍa. ");
INSERT INTO rifl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ad tegged iɛumad i tarebbut zeg ukeccuḍ n tcejjart n ukasiya, ad ten tɣeǧfed s wureɣ uca ad zzaysen arbun tazewḍa. ");
INSERT INTO rifl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ad tegged ɛawed ṭṭbaṣi nnes d tɣenjayin nnes d iɣarrafen nnes d řkisan nnes i zi ɣa farrɣen. Ad ten tegged s wureɣ iṣfan. ");
INSERT INTO rifl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","X tzewḍa ad tegged aɣrum n wescan řebda zzat i wudem inu. ");
INSERT INTO rifl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ad tegged řqendiř s wureɣ iṣfan. Ad tegged řqendiř s wefḍis n wemziř. Afud ak-d uḍar nnes d iɣaǧen nnes uřa d řkisan nnes d tɛebbuzin nnes i dd-ittasen ak-d nnuwwarat nnes ad iřin d aɣezdis d ijj. ");
INSERT INTO rifl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Setta n iɣaǧen ad dd-ffɣen zeg iɣezdisen nnes, třata n iɣaǧen zeg ijj n uɣezdis n řqendiř d třata n iɣaǧen zeg uɣezdis nneɣni n řqendiř. ");
INSERT INTO rifl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Třata n řkisan ad iřin deg ijj n uɣiř di furma n nnuwwarat n ǧewz ak-d tɛebbuzt d nnewwac, uca ɛawed ɣar uɣiř nneɣni třata n řkisan di furma n nnuwwarat n ǧewz ak-d tɛebbuzt d nnewwac. Ammu i ɣa ggen marra setta n iɣaǧen nni dd-iffɣen zi řqendiř. ");
INSERT INTO rifl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ɣar řqendiř simant nnes ad din iřin arebɛa n řkisan di furma n nnuwwarat n ǧewz, ak-d tɛebbuzin nsen i dd-ittasen ak-d nnuwwarat nsen. ");
INSERT INTO rifl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ad din tiři ict n tɛebbuzt sadu tyuya n iɣaǧen i zzayes dd-iffɣen u ict n tɛebbuzt sadu tyuya n iɣaǧen i zzayes dd-iffɣen awarni as, u ɛawed ict n tɛebbuzt sadu tyuya n iɣaǧen i zzayes dd-iffɣen awarni as. Ammu i ɣa yiři i setta n iɣaǧen i dd-iffɣen zi řqendiř. ");
INSERT INTO rifl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tiɛebbuzin nsen d iɣaǧen nsen ad zzayes-dd ffɣen uca marra aya ad yiři d ict n řqecɛet tᵉttwaɛdeř s wefḍis n wemziř s wureɣ iṣfan. ");
INSERT INTO rifl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ad tegged setta n řefnarat nnes uca ad ssarsen řefnarat nnes x řqendiř, maḥend ad wcent tfawt ɣar ṭṭarf n ujemmaḍ. ");
INSERT INTO rifl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tijeqqaḍin n teftič nnes d tmejmarin nnes ad iřint s wureɣ iṣfan. ");
INSERT INTO rifl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ad ittwagg řqendiř zeg ict n talint n wureɣ iṣfan s marra řeqcuɛ-a akides. ");
INSERT INTO rifl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Uca xzar, ad t tegged am umedya nnes, wenni i d ac ittwamřen deg wedrar.”   * ");
INSERT INTO rifl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ad tegged Tazeddiɣt s ɛecra n tjartiřin s řeqṭen azdad imuden u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen, ak-d ikiruben. Ad ten tegged am řxedmet n ufennan. ");
INSERT INTO rifl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tuzzeggart n yict n tjartiřt ad tiři tmenya u-ɛicrin n iɣaǧen u tiru n yict n tjartiřt arebɛa n iɣaǧen. Marra tijartiřin ad ɣarsent yiři řeɛbar d ijj. ");
INSERT INTO rifl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Xemsa n tjartiřin ad tent ssmunen ict ak-d tenneɣni u ɛawed xemsa n tjartiřin ad tent ssmunen ict ak-d tenneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ɣar tma n yict n tjartiřt ɣar ṭṭarf mani tt ɣa ssmunen, ad tegged tisarawin tideḥmanin. Ammu i tent ɣa tegged ɛawed ɣar tma n tjartiřt nneɣni ɣar ṭṭarf i ɣar iǧa useřqi nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Xemsin n tsarawin i ɣa tegged deg ict n tjartiřt u xemsin n tsarawin ɣar ṭṭarf n tjartiřt nni ɣar iǧa useřqi nneɣni, maḥend tisarawin ad mmeřqant ict ak-d tenneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ad tegged ɛawed xemsin n tsennarin n wureɣ uca ad tessmuned tijartiřin ict ak-d tenneɣni s tsennarin, maḥend ad tedweř d ict n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ad tegged ɛawed tijařtiřin s ccɛar n iɣayḍen, maḥend ad iřint d ijj n uqiḍun x Tzeddiɣt. Ad tegged ḥiṭac n tjartiřin. ");
INSERT INTO rifl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tuzzeggart n ict n tjartiřt ad tiři třatin n iɣaǧen u tiru n ict n tjartiřt ad tiři arebɛa n iɣaǧen. Ḥiṭɛac n tjartiřin ad ɣarsent yiři řeɛbar d ijj. ");
INSERT INTO rifl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ad tessmuned xemsa n tjartiřin weḥḥedsent d setta n tjartiřin ɛawed weḥḥedsent. Tajartiřt wiss setta ad tt tḍefṣed zzat i wudem n Uqiḍun. ");
INSERT INTO rifl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ad tegged xemsin n tsarawin ɣar tma n yict n tjartiřt ɣar ṭṭarf ɣar useřqi, uca xemsin n tsarawin x tma n tjartiřt ɣar useřqi nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ad tegged xemsin n tsennarin n nnḥas uca ad tent tessidfed di tsarawin uca ad tessmuned Aqiḍun, maḥend ad yiři d ijjen. ");
INSERT INTO rifl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Min iceṭṭen n tjartiřin n uqiḍun, azyen n tjartiřt nni iceṭṭen ad yayeř ɣar ḍeffar n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Zi min iceṭṭen di tuzzeggart n tjartiřin, ijj n uɣiř ad yayeř ɣar yijj n ṭṭarf d ijj n uɣiř ɣar ṭṭarf nneɣni, ɣar tnayen n iɣezdisen n Tzeddiɣt, maḥend ad as iřeḥḥef i yijj n uɣezdis u i uɣezdis nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ad tegged i Uqiḍun ɛawed ict n tseqqaft n iřmawen izeggʷaɣen n icarriyyen u sennej i man aya ict n tseqqaft n iřmawen n ddenfiřat. ");
INSERT INTO rifl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ad tegged i Tzeddiɣt tifeřwin n ukeccuḍ n tcejjart n ukasiya nni ibedden nican. ");
INSERT INTO rifl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Řeɛbar n tuzzeggart n ict n tefřawt dayes ɛecra n iɣaǧen u řeɛbar n tiru n ict n tefřawt dayes ijj n uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","I kuř tafřawt ad ɣares iřin tnayen n iḍaren, inni issmeřqan twečmatin ict ak-d tenneɣnit, ammu i ɣa tegged i marra tifeřwin n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ad tegged i Tzeddiɣt tifeřwin, ɛicrin n tfeřwin ɣar jjihet n ljanub, ɣar yefus. ");
INSERT INTO rifl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ad tegged arebɛin n tyarsawin n nnuqart maḥend ad tent ssarsen sadu ɛicrin n tfeřwin, tnayen n tyarsawin sadu ict n tefřawt i tnayen n iḍaren nnes, d tnayen n tyarsawin sadu tafřawt nneɣni i tnayen n iḍaren nnes. ");
INSERT INTO rifl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ɛawed ad tegged ɛicrin n tfeřwin i uɣezdis nneɣni n Tzeddiɣt, ɣar jjihet n ccamal, ");
INSERT INTO rifl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","s arebɛin n tyarsawin nsen n nnuqart: tnayen n tyarsawin i kuř tafřawt d tnayen n tyarsawin sadu tafřawt nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","U ɣar uɣezdis n řɣarb n Tzeddiɣt ad as tegged setta n tfeřwin. ");
INSERT INTO rifl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ad tegged tnayen n tfeřwin i tɣemmura n Tzeddiɣt i iǧan ɣar tnayen n iɣezdisen n ḍeffar. ");
INSERT INTO rifl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Zi swadday ad iřint ṣqent am wacniwen uca ammu i ɣa iřint nican d icten ař ɣa awḍent sennej deg ict n texrazt. Ammu i ɣa yiři i tnayen n tfeřwin ɣar tnayen n tɣemmura. ");
INSERT INTO rifl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ad din iřint tmenya n tfeřwin ak-d tyarsawin nsent n nnuqart. Xenni seṭṭac n tyarsawin, tnayen n tyarsawin sadu ict n tefřawt d tnayen n tyarsawin sadu tafřawt nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ad tegged tiḥenya n uɛarreḍ zeg ukeccuḍ n tcejjart n ukasiya, inni ɣa iɛdun x tfeřwin, xemsa i tfeřwin n ijj n uɣezdis n Tzeddiɣt ");
INSERT INTO rifl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","u xemsa n tḥenya n uɛarreḍ i tfeřwin ɣar uɣezdis nneɣni n Tzeddiɣt u xemsa n tḥenya n uɛarreḍ i tfeřwin n uɣezdis n Tzeddiɣt ɣar uɣezdis n řɣarb ɣar tnayen n iɣezdisen n ḍeffar. ");
INSERT INTO rifl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Taḥnact n uɛarreḍ di řwesṭ ad teɛdu x tfeřwin di řwesṭ, zeg ijj n yixef ɣar wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ad tɣeǧfed tifeřwin s wureɣ uca ad tegged tixrazin nsen n wureɣ, maḥend ad daysent ssidfen tiḥenya n uɛarreḍ. Ad tedřed ɛawed tiḥenya n uɛarreḍ s wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ad tessgeɛɛded Tazeddiɣt ɛlaḥsab amedya n řebni nni d ac ittwamřen x wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ad teggeḍ ijj n uřeḥḥaf s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden, ad t ggen am řxedmet n ufennan, uca ikiruben ad xas iřin. ");
INSERT INTO rifl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ad t tayřed x arebɛa n ipilaren n ukeccuḍ n tcejjart n ukasiya i idřin s wureɣ. Tisennarin nsen ad iřint n wureɣ uca ipilaren nni ad bedden x arebɛa n tyarsawin n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ad tayřed ařeḥḥaf ɣar wadday n tsennarin uca ad tessidfed Ttabut n Cchadet daxeř i uřeḥḥaf uca ařeḥḥaf ad ibḍa jar Uqeddas d Weqdas x Uqeddas. ");
INSERT INTO rifl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ad tessarsed taqebbart n weṣřaḥ x Ttabut n Cchadet deg Weqdas x Uqeddas. ");
INSERT INTO rifl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ad tegged tazewḍa barra i uřeḥḥaf uca ad tessarsed řqendiř qibač i tzewḍa ɣar uɣezdis n Tzeddiɣt ɣar jjihet n ljanub u ad tegged tazewḍa ɣar uɣezdis ɣar jjihet n ccamal. ");
INSERT INTO rifl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ad tegged arwaq s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden i wadaf n Uqiḍun, am ijj n umudi n uxeyyaḍ. ");
INSERT INTO rifl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Uca ad tegged i arwaq xemsa n ipilaren n ukeccuḍ n tcejjart n ukasiya uca ad ten tcelled s wureɣ. Tisennarin nsen ad iřint n wureɣ u i ipilaren nni ad asen tfesyed xemsa n tyarsawin n nnḥas.” * ");
INSERT INTO rifl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ad tegged aɛalṭar n ukeccuḍ n ukasiya n xemsa n iɣaǧen di tuzzeggart d xemsa n iɣaǧen di tiru. Ad yiři s arebɛa n tɣemmura u řuɛřa nnes ad yiři třata n iɣaǧen. ");
INSERT INTO rifl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ɣar arebɛa n tɣemmura ad tegged accawen nnes. Accawen nnes ad dewřen d ijjen akides uca ad t třeḥḥfed s nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ad tegged tiydurin nnes, ḥima ad daysent tenḍared iɣɣeḍ n min iqqimen n tadunt nnes ittwacemḍen uca ad tegged ɛawed iɣenjayen nnes d ṭṭawyat nnes i urucci d furcayat nnes d tmejmarin nnes. Ad tegged marra řeqcuɛ nnes s nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ad tegged ict n tracca, ict n umudi n nnḥas, uca ad tegged arebɛa n texrazin n nnḥas i umudi nni, ɣar arebɛa n tɣemmura nnes. ");
INSERT INTO rifl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ad t tzeyyared sadu i tma n uɛalṭar, swadday, maḥend ad yiři umudi n nnḥas nni ɣar wezyen n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ad tegged iɛumad i tarebbut i uɛalṭar, iɛumad n ukeccuḍ n ukasiya uca ad ten třeḥḥfed s nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Iɛumad nnes ad ttwassidfen di texrazin. Ad iřin iɛumad i tarebbut ɣar tnayen n iɣezdisen n uɛalṭar xmi t ɣa arbun. ");
INSERT INTO rifl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ad tegged ijj n řxawi ɣar daxeř n tfeřwin. Am mammec i d ac imřa x wedrar, ammu i t ɣa ggen nitni. ");
INSERT INTO rifl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ad tegged řemraḥ n Tzeddiɣt. Ɣar jjihet n ljanub, ɣar yefus, ad tegged řizarat s řeqṭen azdad imuden, kuř ict zzaysent n mya n iɣaǧen di tuzzeggart i yijj n uɣezdis. ");
INSERT INTO rifl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ɛicrin n ipilaren nnes d ɛicrin n tyarsawin nnes ad iřin n nnḥas. Tisennarin n ipilaren d iqeḍban nsen i useřqi ad iřin n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ammu ɣar jjihet n ccamal, di tuzzeggart, ad din iřint řizarat n mya iɣaǧen. Ad iřin ɛicrin n ipilaren nsent d ɛicrin n tyarsawin nsen n nnḥas. Tisennarin n ipilaren d iqeḍban nsen i useřqi ad iřin n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Di tiru n řemrah, ɣar uɣezdis n řɣarb, ad din iřint řizarat n xemsin n iɣaǧen di tuzzeggart ak-d ɛecra n ipilaren nsent d ɛecra n tyarsawin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Tiru n řemraḥ ɣar uɣezdis n ccarq, zi manis dd-tneqqar tfuct, ad tiři xemsin iɣaǧen. ");
INSERT INTO rifl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Řizarat ɣar yijj n uɣezdis n zzat ad iřint xemmesṭac n iɣaǧen di tuzzeggart, ak-d třata n ipilaren nsent d třata n tyarsawin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ɣar uɣezdis n zzat nneɣni ad din iřint ɛawed řizarat n xemmesṭac n iɣaǧen di tuzzeggart ak-d třata n ipilaren nsent d třata n tyarsawin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ɣar wadaf n řemraḥ ad din yiři ijj n arwaq n ɛicrin n iɣaǧen, ggin t s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden, ijj n umudi n uxeyyaḍ, ak-d arebɛa n ipilaren nnes d arebɛa n tyarsawin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Marra ipilaren i d as dd-innḍen i řemraḥ ad iřin s iqeḍban n nnuqart i useřqi uca tisennarin nsen ad iřint n nnuqart d tyarsawin nsen n nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Tuzzeggart n řemraḥ ad tiři mya n iɣaǧen u tiru ad tiři xemsin n iɣaǧen d xemsin ɛawed uca řuɛřa ad yiři xemsa n iɣaǧen, marra s řeqṭen azdad imuden uca tyarsawin nsen ad iřint n nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Marra řeqcuɛ n Tzeddiɣt i iǧan i marra tasexxart nnes uřa d marra řewtad nnes d marra řewtad n řemraḥ ad iřin n nnḥas. * ");
INSERT INTO rifl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ad tumured ayt n Israil, ḥima ad ac dd-awyen zzect teṣfa teddez zi zzitun i tfawt, ḥima ad tareɣ tfawt řebda. ");
INSERT INTO rifl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Harun d warraw nnes ad ḥḍan man aya zi ǧiřet ař ṣṣbeḥ zzat i wudem n SIDI deg Uqiḍun n Umsagar zzat i uřeḥḥaf i iǧan zzat i Cchadet. D man aya ad yiři d ict n tewṣeyyet i řebda nni ittxeṣṣa ad tᵉttwaḥḍa zi jjihet n ayt n Israil di marra jjiřat nsen.” ");
INSERT INTO rifl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Uca cek ad ɣarek dd-tessqarrbed Harun, umac, d warraw nnes akides zi řwesṭ n ayt n Israil, ḥima ad ayi ɛebden am yikehhanen, Harun, Nadab, Abihu, Aliɛazar d Itamar, zeg warraw n Harun. ");
INSERT INTO rifl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ad tegged arruḍ iqeddsen i Harun, umac, ad as yiři i uɛuǧi d telwizt. ");
INSERT INTO rifl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ad tessiwřed ɣar marra inni iǧan d imiɣisen n wuř, inni ccureɣ s arruḥ n tiɣit, maḥend ad ggen arruḍ i Harun, ḥima ad as ssqeddsen d akehhan i Necc. ");
INSERT INTO rifl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ina d arruḍ i ɣa ggen: ict n tejmect d ijj n upalṭu d ijj n useřham d ict tcamir imuden am ijj n ureqqam n ufennan, d ict n areẓẓet d ict n tḥezzamt. Ad ggen arruḍ iqeddsen i Harun, umac, u i warraw nnes, ḥima ad ayi sexxaren am ukehhan. ");
INSERT INTO rifl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Nitni ad ksin ifiřan n wureɣ d afiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen d řeqṭen azdad, ");
INSERT INTO rifl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","uca ad ggen apalṭu s ifiřan n wureɣ u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden, ad yiři am řxedmet n ufennan. ");
INSERT INTO rifl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ad ɣares yiři tnayen n tɣarḍin immseřsaqen ɣar tnayen n ṭṭrufa nnes i zi ɣa ittwassmun upalṭu. ");
INSERT INTO rifl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Taḥezzamt izewwqen, wenni iǧan x upalṭu nnes n ukehhan, ad zzayes tᵉttwagg d icten akides, s ifiřan n wureɣ u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden. ");
INSERT INTO rifl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ad teksid tnayen n iẓra n uniks uca ad xasen tneqced ismawen n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Setta n ismawen x yijj n weẓru d setta n ismawen nneɣni x weẓru nneɣni ɛlaḥsab asettef n wexřaq nsen. ");
INSERT INTO rifl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","D man aya d ict n ṣṣenɛet n uneqqac n weẓru iɣřan. Am ict n txadent n ucemmiɛ, ammu i ɣa ttwaneqcen tnayen n yeẓra s ismawen n ayt n Israil. Ad asen tegged ticuyar n wureɣ i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ad tegged iẓra nni x tɣarḍin n upalṭu, aqa aten d iẓra n řidaret i ayt n Israil. Harun ad yarbu ismawen nsen i řidaret zzat i wudem n SIDI x tnayen tɣarḍin nnes. ");
INSERT INTO rifl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ad tegged ticuyar n wureɣ ");
INSERT INTO rifl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","uca ɛawed tnayen n ssnaseř n wureɣ iṣfan. Ad ten tegged amecnaw ifiřan, amecnaw ict n řxedmet n umudi. Ad tcedded ssnaseř imuden ɣar tcuyar. ");
INSERT INTO rifl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Ad tegged tajmect i řeḥkam. Ad tt tegged am řxedmet n ufennan, am upalṭu n ukehhan. Ad tt tegged s ifiřan n wureɣ u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden. ");
INSERT INTO rifl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tajmect ad tiři s arebɛa n tɣemmura, tᵉttwaḍfeṣ. Tuzzeggart nnes ad tiři d ijj n wezyen n uɣiř, u tiru nnes d ijj n wezyen n uɣiř. ");
INSERT INTO rifl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ad xas tegged iẓra, arebɛa n řeṣfuf n iẓra. Ijj n ṣṣef ad yiři s yijj n řeɛqiq d azeggwaɣ d ict n tyaqut d ict n smaraxt. Wa d ṣṣef amezwaru. ");
INSERT INTO rifl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ṣṣef wiss tnayen ad yiři s yijj n karbunkel d yijj n ṣaffir aziza d yijj n diamanti. ");
INSERT INTO rifl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ṣṣef wiss třata ad yiři s yijj n weẓru n yasintu d yijj n axat d yijj n umatist. ");
INSERT INTO rifl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","U ṣṣef wiss arebɛa ad yiři s yict n texrisulit d yijj n uniks d yijj n yaspis. Ina ad ttwaṭṭfen deg wureɣ di tcuyar nsen. ");
INSERT INTO rifl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Iẓra ad xasen iřin ismawen n ayt n Israil, tenɛac n yeẓra ɛlaḥsab ismawen nsen, s ineqqacen n txadent n ucemmiɛ, kuř aneqqic ɛlaḥsab isem nnes i d as dd-yusin. Aqa aten i tenɛac n tqebbař. ");
INSERT INTO rifl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ad tegged ssnaseř x tejmect, ifiřan imuden n wureɣ iṣfan. ");
INSERT INTO rifl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ad tegged tnayen n texrazin n wureɣ ɣar tejmect uca ad tcedded tnayen n texrazin nni ɣar tnayen n ṭṭrufa n tejmect. ");
INSERT INTO rifl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ad tcedded tnayen n ssnaseř n wureɣ imuden ɣar tnayen n texrazin ɣar řeḍruf n tejmect. ");
INSERT INTO rifl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ad tcedded tnayen n ixfawen n tnayen n ssnaseř imuden ɣar tnayen n tcuyar uca ad tent tcedded ɣar tɣarḍin i iǧan ɣar uɣezdis n zzat n upalṭu n ukehhan. ");
INSERT INTO rifl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ad tegged ɛawed tnayen n texrazin n wureɣ uca ad tent tegged ɣar tnayen n ixfawen n tejmect ɣar swadday, x tma nsen nni iǧan ɣar upalṭu, ɣar daxeř. ");
INSERT INTO rifl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ad tegged tnayen n texrazin n wureɣ, tinni i ɣa tcedned x tnayen n tɣarḍin n upalṭu n ukehhan, swadday, ɣar zzat, qibač i useřqi nnes ɣar sennej i tḥezzamt izewwqen n upalṭu. ");
INSERT INTO rifl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ad tessmuned tajmect s texrazin nnes ɣar texrazin n upalṭu ak-d ijj n ufiřu imuden adeḥmi, maḥend ad tiři tejmect sennej i tḥezzamt izewwqen n upalṭu uca war tᵉttbeṭṭi tejmect x upalṭu. ");
INSERT INTO rifl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ammu i ɣa yawi Harun ismawen n ayt n Israil di tejmect n řeḥkam x wuř nnes x minni i ɣa yadef ɣar Uqeddas, ařami i ɣa qqimen i řidaret zzat i wudem n SIDI i řebda. ");
INSERT INTO rifl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ad tessarsed iẓra n ‘Urim’ d ‘Tummim’ di tejmect n řeḥkam, maḥend ad iřin x wuř n Harun x minni i ɣa yadef zzat i wudem n SIDI. Ammu i ɣa yarbu Harun řebda řeḥkam n ayt n Israil x wuř nnes zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ad tegged aseřham n upalṭu n ukehhan marra zeg ufiřu adeḥmi. ");
INSERT INTO rifl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ad yiři warzam i uzeǧif nnes di řwesṭ nnes. Ɣar tma n warzam ad din tiři ict n tma imuden, tenni i ɣa yiřin am warzam i yiri deg ijj n warruḍ n wuzzař n uɛeskari, war tᵉttcarrig. ");
INSERT INTO rifl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ɣar tmuwwa nnes ad tegged tiremmanin n ifiřan adeḥmi d urjuwani d uzeggʷaɣ iḥedqen, ɣar tmuwwa nnes i d as dd-innḍen, u jar asent ad tegged nnwaqes n wureɣ i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ijj awarni i wenneɣni, ijj n nnaqus n wureɣ d ict n tremmant, uca ɛawed ijj awarni i wenneɣni, ijj n nnaqus n wureɣ d ict n tremmant, ammu i ɣa iřin ɣar tmuwwa n useřham u deg wenneḍ nnes. ");
INSERT INTO rifl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harun ad t yarḍ xmi ittssexxar netta, ařami i ɣa ittwaseř ddriz nnes x minni i ɣa yadef ɣar Zzawect Iqeddsen zzat i wudem n SIDI u xmi ɣa iffeɣ ɛawed, ḥima war ittmetti. ");
INSERT INTO rifl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ad tegged ict n teřwiḥt s nnuwwar n wureɣ iṣfan uca ad xas tneqced awařen-a am mammec neqqcen taxadent n ucemmiɛ: “AMQEDDAS i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ad tt tcedded ɣar yijj n ufiřu adeḥmi x areẓẓet. Ad tiři teřwiḥt ɣar zzat n ureẓẓet. ");
INSERT INTO rifl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ad tiři teřwiḥt x tenyart n Harun, ḥima Harun ad yarbu řmuɛṣiyyet i iǧan di tmesřayin iqeddsen nni i ɣa ssqeddsen ayt n Israil ak-d marra tiwhibin n tmesřayin nsen iqeddsen. Ad tiři řebda x tenyart nnes, ḥima ad iřint tmesřayin nni arḍant zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ad tegged tcamir s řeqṭen azdad. Ad tegged areẓẓet ɛawed s řeqṭen azdad. Taḥezzamt ad tt tegged am ijj n umudi n uxeyyaḍ.”* ");
INSERT INTO rifl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“I warraw n Harun ad tegged tcamir u ad asen tegged tiḥezzamin u ad asen tegged ticuccay, maḥend ad asen iřin i uɛuǧi d telwizt. ");
INSERT INTO rifl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ad tessyarḍed Harun, umac, d warraw nnes i kides iǧan, uca cek ad ten tdehned, ad ten třeqqmed u ad ten tessqeddsed, ḥima ad ayi xedmen am yikehhanen. ");
INSERT INTO rifl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Egg asen ssraweř n řeqṭen, ḥima ad dřen aysum n useḍḥi nsen. Ad iřin zi tejɛinna uca ad awḍen ɣar ifadden. ");
INSERT INTO rifl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ssřaweř nni ad iřin x arrimet n Harun d warraw nnes xmi ɣa yadfen ɣar Uqiḍun n Umsagar niɣ xmi dd ɣa qarrben ɣar uɛalṭar maḥend ad sexxaren di Zzawect Iqeddsen, ḥima war dd-ttiwyen řmuɛṣiyyet uca ad mmten. Ta ad tiři d ict n tewṣeyyet i řebda i netta u i zzariɛet nnes awarni as.” ");
INSERT INTO rifl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“D man aya i d asen ɣa tegged, ḥima ad ten tessqeddsed, maḥend ad ayi iřin d ikehhanen. Ksi ijj n ufunas - ameẓyan n ufunas - d tnayen n wacraren icnan qaɛ, ");
INSERT INTO rifl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","u ɛawed aɣrum břa antun d řemsemnat břa antun ixeǧḍen s zzect d teřfaf břa antun ttwadehnent s zzect, tinni i ɣa tegged marra s waren azdad n yirden. ");
INSERT INTO rifl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ad tent tegged deg ict n tsuǧet uca ad tent tawyed di tsuǧet jmiɛ ak-d ufunas ameẓyan d tnayen n icarriyyen. ");
INSERT INTO rifl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ad dd-tessqarrbed Harun d warraw nnes ɣar wadaf n Uqiḍun n Umsagar uca ad ten tessirded s waman. ");
INSERT INTO rifl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ad teksid arruḍ, ad tyarḍed Harun tcamir d useřḥam i upalṭu d upalṭu simant nnes d tejmect uca ad as tbeysed s tḥezzamt izewwqen n upalṭu. ");
INSERT INTO rifl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ad tessarsed areẓẓet x uzeǧif nnes u x areẓẓet ad tegged ttaj iqeddsen n weɛzař. ");
INSERT INTO rifl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ad teksid zzect i wedhan uca ad tt tzeǧɛed x uzeǧif nnes uca ad t tdehned. ");
INSERT INTO rifl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Xenni ad tawyed iḥenjiren nnes, ad asen tyarḍed tcamirat. ");
INSERT INTO rifl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ad asen tbeysed s tḥezzamt, i Harun d warraw nnes, uca ad asen tarekkbed ticuccay. Ad ɣarsen tiři tukehhant ɛlaḥsab ict n tewṣeyyet i řebda. Ad tařeqqmed Harun d warraw nnes. ");
INSERT INTO rifl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Xenni ad tawyed afunas ameẓyan zzat i Uqiḍun n Umsagar u Harun d warraw nnes ad ssarsen ifassen nsen x uzeǧif n ufunas ameẓyan. ");
INSERT INTO rifl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ad tɣarṣed i ufunas ameẓyan zzat i wudem n SIDI, ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Xenni ad teksid idammen n ufunas ameẓyan uca ad ten tegged s uḍaḍ nnec x waccawen n uɛalṭar uca ad tzeǧɛed marra idammen iqqimen ɣar iḍaren n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ad teksid ɛawed marra tadunt nni idřin adan d min yuyřen ɣar tsa, d tnayen n tiẓẓař ak-d tadunt i xasent iǧan uca ad tessbexxared aya x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maca aysum n ufunas ameẓyan d yiřem nnes d umessař nnes ad ten tesscemḍed s tmessi barra i řmargeḥ n řɛeskar, aqa d taɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Xenni ad teksid ijj n ucarri uca Harun d warraw nnes ad ssarsen ifassen nsen x uzeǧif n icarri. ");
INSERT INTO rifl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ad tɣarṣed i icarri uca ad teksid idammen nnes, ad ten tzeǧɛed x uɛalṭar zi marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ad tebḍid icarri d iceǧiqen, ad tessirded adan nnes d icekrad nnes uca ad ten tegged x iceǧiqen nnes u x uzeǧif nnes. ");
INSERT INTO rifl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ad tessiɣed i icarri am ikmeř x uɛalṭar, aqa d taɣarṣt n wecmaḍ i SIDI, ict n řefwaḥet ittfuḥen, aqa d ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Xenni ad teksid icarri nneɣni uca Harun d warraw nnes ad ssarsen ifassen nsen x uzeǧif n icarri. ");
INSERT INTO rifl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ad tɣarṣed i icarri uca ad teksid zeg idammen nnes uca ad tegged man aya x iɣes n umezzuɣ afusi n Harun u x iɣes n umezzuɣ afusi n warraw nnes u ɛawed x uḍaḍ n yimez n ufus nsen afusi u x uḍaḍ n yimez n uḍar nsen afusi uca ad tzeǧɛed iḍammen iqqimen x uɛalṭar zi kuř jjihet. ");
INSERT INTO rifl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Xenni ad teksid zeg idammen nni iǧan x uɛalṭar u zi zzect i wedhan uca ad zzaysen trucced Harun d warruḍ nnes uca ad trucced ɛawed arraw nnes d arruḍ n warraw nnes akides, ḥima ad yiři ittwaqeddes, netta d arruḍ nnes, uřa d tarwa nnes d arruḍ n tarwa nnes akides. ");
INSERT INTO rifl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ad teksid tadunt n icarri řa d tadunt ɣar unewwar řa tadunt nni idřin adan, uřa min yuyřen ɣar tsa d tnayen n tiẓẓař s tadunt i xasent iǧan d acekrud afusi, minzi wa d icarri i udeccen n ikehhanen. ");
INSERT INTO rifl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ksi ɛawed ict n tecnift n weɣrum d ict n temsemment n weɣrum ittwasswejden s zzect d ict n teřfeft zi tsuǧet n weɣrum břa antun i iǧan zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Sars man aya marra x ifassen n Harun u x ifassen n warraw nnes uca ad ten tessenhezzed zi ssa ɣar da am ict n tewhibt n wenhezzi zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Awarni as ad tt teksid zeg ifassen nsen uca ad tt tessbexxared x uɛalṭar, x tɣarṣt n wecmaḍ, ad tiři d ict n řefwaḥet ittfuḥen zzat i wudem n SIDI. Aqa-tt d ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ad teksid idmaren n icarri i udeccen n Harun uca ad ten tᵉssenhezzed zi ssa ɣar da am ict n tewhibt n wenhezzi zzat i wudem n SIDI. Tanita ad tiři d tasɣart nnec. ");
INSERT INTO rifl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ad tessqeddsed idmaren n tewhibt n wenhezzi i ittwanhezzen zi ssa ɣar da, uřa d ucekrud i ittwanhezzen zi ssa ɣar da d wenni ittwassgeɛɛden. Aqa-ten zeg icarri n udeccen, am zeg wenni i yeǧan i Harun am zeg wenni i yeǧan i warraw nnes. ");
INSERT INTO rifl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Aya ad yiři i Harun d warraw nnes d ict n tewṣeyyet i řebda zi jjihet n ayt n Israil, minzi d tawhibt n usgeɛɛed i teǧa. Ad tiři d ict n tewhibt i ɣa ssgeɛɛden ayt n Israil zi tɣarṣa nsen n řehna. Aqa d tawhibt nsen n usgeɛɛed i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Arruḍ iqeddsen n Harun ad yiři i warraw nnes awarni as, maḥend ad ten dehnen u ad ten ařeqmen dayes. ");
INSERT INTO rifl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Man wen zeg iḥenjiren nnes i ɣa yiřin d akehhan deg wemcan nnes uca ad yadef ɣar Uqiḍun n Umsagar, maḥend ad isexxar di Zzawect Iqeddsen, ad t yarḍ sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ad teksid icarri i udeccen uca ad tᵉssengwed aysum nnes deg ijj n wemcan iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harun d warraw nnes ad ccen aysum n icarri d weɣrum i iǧan di tsuǧet ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ad ccen zi min zi ittwagg wesřaḥ, ḥima ad ten řeqqmen u ad ten ssqeddsen. Maca ijj n ubarrani war zzayes ittett, minzi aqa d ict n řḥajjet d tamqeddest. ");
INSERT INTO rifl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Mařa iceṭṭ ca zeg weysum n tɣarṣa i udeccen niɣ zeg weɣrum ař ṣṣbeḥ, ad tesscemḍed min iceṭṭen di tmessi. Ittxeṣṣa war t ittett ḥed, minzi d ict n řḥajjet iqeddsen i yeǧa. ");
INSERT INTO rifl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ammu i ɣa tegged ak-d Harun u ak-d warraw nnes, ad tegged ɛlaḥsab marra min d ac weṣṣiɣ. Ad ten tařeqqmed sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kuř ass ad tesswejded afunas ameẓyan d taɣarṣt n ddenb i weṣřaḥ uca ad tekksed ddenb x uɛalṭar umi xas ɣa tessiwḍed aṣřaḥ, uca xenni ad t tdehned, maḥend ad t tessqeddsed. ");
INSERT INTO rifl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sebɛa n wussan ad tegged aṣřaḥ x uɛalṭar uca ad t tessqeddsed, xenni ad yiři d amqeddas qaɛ. Wenni i ɣa iḥadan aɛalṭar, ad yiři d amqeddas. ");
INSERT INTO rifl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","D man aya i ɣa tesswejded x uɛalṭar: tnayen n izmaren n ijj n useggʷas, kuř ass řebda. ");
INSERT INTO rifl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ad tesswejded ijj n yezmar di ṣṣbeḥ u izmar nneɣni ad t tesswejded jar beddu n wezyen n wass ař dd-tewḍa tmeddit. ");
INSERT INTO rifl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","I yijj n yezmar ad teksid ɛecra di tesɣart n ijj n ifa n waren azdad ixeǧḍen s zzect ddzen tt-i-dd zi zzitun, u arebɛa di tesɣart n ijj n uhinu n binu d tawhibt n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ad tɣarṣed i yezmar nneɣni jar beddu n wezyen n wass ař dd-tewḍa tmeddit. Ad ɣares tarnid tawhibt n řɣiǧet am mammec tenni n ṣṣbeḥ u ɛawed tawhibt nnes n useyyeb. Aqa d řefwaḥet ittfuḥen. Aqa d tawhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ad tiři d taɣarṣt n wecmaḍ řebda di marra jjiřat nwem ɣar wadaf n Uqiḍun n Umsagar zzat i wudem n SIDI, mani ɣa ssmuneɣ akidwem, maḥend ad kidek ssiwřeɣ din. ");
INSERT INTO rifl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ad mmsagareɣ din ak-d ayt n Israil, u Aqiḍun ad ittwaqeddes s uɛuǧi inu. ");
INSERT INTO rifl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ad ssqeddseɣ Aqiḍun n Umsagar d uɛalṭar. Ad ssqeddseɣ ɛawed Harun d warraw nnes, ḥima ad ayi iřin d ikehhanen. ");
INSERT INTO rifl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ad zedɣeɣ di řwesṭ n ayt n Israil, ad asen iřiɣ d AREBBI ");
INSERT INTO rifl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","uca ad ssnen belli Necc d SIDI, AREBBI nsen, wenni ten issuffɣen zi temmurt n Miṣra, maḥend ad zedɣeɣ di řwesṭ nsen. Necc d SIDI, AREBBI nsen.” ");
INSERT INTO rifl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ad tegged ɛawed aɛalṭar n řebxur. Ad t tegged zeg ukeccuḍ n tcejjart n ukasiya. ");
INSERT INTO rifl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Tuzzeggart ad tiři d ijjen uɣiř, u tiru ɛawed d ijjen uɣiř. Ad yiři uɛalṭar s arebɛa n tɣemmura. Řuɛřa nnes ad yiři d tnayen n iɣaǧen u accawen nnes ad iřin d ijjen akides. ");
INSERT INTO rifl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ad t tɣeǧfed s wureɣ iṣfan, udem nnes n sennej d iɣezdisen nnes i d as dd-innḍen d waccawen nnes. Ad as tegged ijj n zzwaq n wureɣ i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ad as tegged tnayen n texrazin n wureɣ sadu zzwaq nnes. Ad tent tegged ɣar tnayen n iɣezdisen nnes, ɣar tnayen n tɣemmar nnes. Ad iřint i iɛumad, ḥima ad zzaysen arbun aɛalṭar n řebxur. ");
INSERT INTO rifl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ad tegged tnayen n iɛumad i tarebbut zeg ukeccuḍ n ukasiya uca ad ten tɣeǧfed s wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ad t tessarsed zzat i uřeḥḥaf i iǧan zzat i Ttabut n Cchadet, zzat i tqebbart n weṣřaḥ tenni iǧan x Cchadet, mani kik i ɣa mmsagareɣ. ");
INSERT INTO rifl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ad issbexxar Harun řebxur ittfuḥen kuř ṣṣbeḥ. Awarni řami iɛdeř tiftiřin, ad issbexxar. ");
INSERT INTO rifl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Meřmi i ɣa issireɣ Harun tiftiřin jar beddu n wezyen n wass ař dd-tewḍa tmeddit, ad yejj řebxur ad ibexxar. Ad yiři d ijj n řebxur i řebda zzat i wudem n SIDI i marra jjiřat nwem. ");
INSERT INTO rifl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kenniw war xas tessgeɛɛdem ca řebxur d aɣrib, niɣ taɣarṣt n wecmaḍ niɣ tawhibt n řɣiǧet u war xas ttzeǧaɛem tawhibt n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Harun ad igg aṣřaḥ x waccawen nnes ict n twařa deg useggʷas s idammen n tɣarṣa n ddenb i weṣřaḥ. Ad t isseṣřeḥ ict n twařa deg useggʷas i marra jjiřat nwem. Aqa-t d amqeddas qaɛ i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Xmi ɣa teksid řqedd n ayt n Israil, řqedd n yinni ittwaḥesben, xenni nitni ad wcen, kuř ijj i yixef nnes, ttaman n weṣřaḥ i SIDI ɣar useddi nsen, ḥima war tᵉttiři jjriḥect jar asen x minni ten ɣa tḥesbed. ");
INSERT INTO rifl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","D man aya i ɣa wcen nitni, kuř ijj zeg inni ɣa iẓwan ɣar yinni ittwaḥesben: azyen ciqlu ɛlaḥsab ciqlu n Zzawect Iqeddsen - ciqlu-ya d ɛicrin jira - azyen ciqlu-ya ad yiři d tawhibt n usgeɛɛed i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kuř ijj zeg inni ɣa iẓwan ɣar yinni ittwaḥesben, zi ɛicrin iseggʷusa sennej, ad issgeɛɛed tawhibt i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Bu-wagřa war ittic ktar u amezřuḍ war issenqis zeg wezyen ciqlu, xmi ɣa tessgeɛɛdem tawhibt n SIDI i weṣřaḥ n řeɛmur nwem. ");
INSERT INTO rifl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ad teksid nnuqart i weṣřaḥ n ayt n Israil uca ad tt tfarzed i tsexxart n Uqiḍun n Umsagar. Ad tiři d řidaret i ayt n Israil zzat i wudem n SIDI i weṣřaḥ n řeɛmur nwem.” ");
INSERT INTO rifl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Issiweř SIDi ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Ad tegged ɛawed tbanyut n nnḥas i usird, ak-d uḍar n nnuqart nnes i x tt ɣa ssarsen, maḥend ad ssirden ixef nsen. Ad tt tessarsed jar Uqiḍun n Umsagar d uɛalṭar uca ad dayes tegged aman, ");
INSERT INTO rifl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","maḥend Harun d warraw nnes ad zzayes ssirden ifassen nsen d iḍaren nsen. ");
INSERT INTO rifl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Xmi ɣa yadfen ɣar Uqiḍun n Umsagar ad ssirden s waman ḥima war ttmettin ca, uřa xmi dd ɣa qarrben ɣar uɛalṭar, maḥend ad sexxaren xmi ɣa ssbexxaren tawhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Xenni ad ssirden ifassen nsen d iḍaren nsen ḥima war ttmettin ca. Man aya ad asen yiři d ict n tewṣeyyet i řebda, i netta u i zzariɛet nnes, i marra jjiřat nsen.” ");
INSERT INTO rifl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Cek, ksi řexxu ɣarek řeɛṭur icnan aṭṭas: xems-mya ciqlu n mirru yuzzřen ak-d řqedd n wezyen n manawenni, aqa-t d mitayen u-xemsin ciqlu zi řqarfa ittfuḥen u mitayen u-xemsin ciqlu zeg uɣanim uḥemmum ittfuḥen, ");
INSERT INTO rifl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","xemsa-mya ciqlu n qassiya iwezznen ɛlaḥsab ciqlu n Zzawect Iqeddsen, d ijj n uhinu n zzect n zzitun. ");
INSERT INTO rifl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Egg zzaysen ict n zzect tamqeddast i wedhan, ijj n řeɛṭur ixeǧḍen ɛlaḥsab ṣṣenɛet n uɛeṭṭar. Aya ad yiři d ict n zzect tamqeddest i wedhan. ");
INSERT INTO rifl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","S man aya ad tdehned Aqiḍun n Umsagar, Ttabut n Cchadet, ");
INSERT INTO rifl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tazewḍa ak-d marra řeqcuɛ nnes d řqendiř ak-d marra řeqcuɛ nnes d uɛalṭar n řebxur, ");
INSERT INTO rifl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","d uɛalṭar n wecmaḍ ak-d marra řeqcuɛ nnes d tbanyut ak-d uḍar nnes. ");
INSERT INTO rifl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ad tessqeddsed marra aya, ḥima ad yiři d amqeddas qaɛ. Marra wi ɣa iḥadan zi man aya, ad ittwaqeddes. ");
INSERT INTO rifl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ad tdehned Harun d warraw nnes uca ad ten tessqeddsed, ḥima ad ayi iřin d ikehhanen. ");
INSERT INTO rifl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ad tessiwřed ak-d ayt n Israil uca ad tinid: ‘Ta ad tiři d ict n zzect tamqeddast i wedhan i Necc di marra jjiřat nwem. ");
INSERT INTO rifl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","War iɛeddeř ad tt farrɣen x arrimet n bnadem, u mammec teǧa war zzayes tteggem učmas. Tamqeddast i teǧa uca ad tiři d tamqeddast i kenniw. ");
INSERT INTO rifl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Wenni i ɣa isswejden s řebzar ict n zzect n wedhan am tanita uca ad zzayes tmesḥed x yijj n ubarrani, ad ittwaqess zi řgens nnes.’” ");
INSERT INTO rifl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Inna SIDI i Musa: “Ksi i yixef nnec řebzar ittfuḥen: tuddimin n userɣaɣ d weqcur n tcejjart n řqarfa d ɣalba, řebzar ittfuḥen d jjawi iṣfan. Ad yiři řqedd nnes am řqedd n wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Egg zzayes ijj n řeɛṭur, ijj n uxeǧeḍ am tenni igga uɛeṭṭar: ittwameǧed, iṣfa, iqeddes. ");
INSERT INTO rifl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ḥri-dd zzayes taneɣda tazdadt uca sars ca zzayes zzat i Cchadet deg Uqiḍun n Umsagar mani akidek ɣa msagareɣ. Ad awem tiři d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Řeɛtur nni i ɣa tegged, war t tteggem s uxeǧeḍ d ijjen akides i yixef nwem. Ad yiři d amqeddas i cek, ad yiři i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Wenni i iggin ca am wanita uca ad t icemm, ad ittwaqess zi řgens nnes.” ");
INSERT INTO rifl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Xzar, Necc řaɣiɣ-dd x Baṣaliyil, mmis n Uri, mmis n Ḥur, zi teqbič n Yahuda s yisem nnes. ");
INSERT INTO rifl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ccureɣ t s Arruḥ n AREBBI, s tiɣit, s řeɛqeř, s tussna u s marra min ittxeṣṣan n tzemmar n ṣṣnayeɛ, ");
INSERT INTO rifl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ḥima ad ixemmem ireqqamen s lfenn, maḥend ad ten tteggen s wureɣ d nnuqart d nnḥas, ");
INSERT INTO rifl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","u ḥima ad neqcen iẓra iɣřan maḥend ad ten ggen di tcuyar nsen, u ḥima ad neqcen akeccuḍ, ḥima ammu i ɣa ggen marra řxedmet. ");
INSERT INTO rifl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Aqa Necc ggiɣ akides Ahuliyab, mmis n Axisamak, zi řaǧ n Dan. Deg wuř n marra inni ɣar iǧa wuř d amiɣis, ggiɣ tiɣit. Nitni ad ggen marra min xef weṣṣiɣ: ");
INSERT INTO rifl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Aqiḍun n Umsagar, Ttabut n Cchadet, taqebbart n weṣřaḥ nni xas iǧan, u marra řeqcuɛ n Uqiḍun: ");
INSERT INTO rifl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tazewḍa ak-d marra řeqcuɛ nnes, d řqendiř iṣfan s marra řeqcuɛ nnes d uɛalṭar n řebxur, ");
INSERT INTO rifl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","aɛalṭar n wecmaḍ ak-d marra řeqcuɛ nnes d tbanyut s uḍar nnes, ");
INSERT INTO rifl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","arruḍ n tsexxart d warruḍ iqeddsen n Harun, akehhan, d warruḍ n warraw nnes, maḥend ad sexxaren am ukehhan, ");
INSERT INTO rifl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","d zzect i wedhan, d řebxur ittfuḥen i Zzawect Iqeddsen. Ɛlaḥsab marra minzi cek umureɣ ad ggen marra aya.” ");
INSERT INTO rifl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Cek, siweř ak-d ayt n Israil, ini: ‘Ad teḥḍam ussan n ssebt inu, minzi ssebt d řeɛřamet jar ayi d kenniw, i marra jjiřat nwem, ḥima ad tessnem belli Necc d SIDI, wenni kenniw issqeddsen. ");
INSERT INTO rifl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ḥḍam ass n ssebt, minzi iqeddes i iǧa i kenniw! Wenni t ɣa issfesden, ad t nɣen nican, minzi man wen i dayes ɣa iggin ca n řxedmet, ad ittwaqḍeɛ zi řwesṭ n řgens nnes.    ");
INSERT INTO rifl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Setta n wussan ad tegged řxedmet uca deg wass wiss sebɛa ad yiři d ssebt, arraḥet tmun, tqeddes i teǧa i SIDI! Kuř ijj, wenni iggin ca n řxedmet deg wass n ssebt, ad t nɣen nican. ");
INSERT INTO rifl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ayt n Israil ad ḥḍan ass n ssebt, ad ḥḍan ssebt di marra jjiřat nsen am ijj n Řɛahd i řebda. ");
INSERT INTO rifl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ad tiři d ict n řeɛřamet jar ayi d ayt n Israil, minzi di setta n wussan igga SIDI ajenna d temmurt u deg wass wiss sebɛa yareyyeḥ, yarra nnefs.” ");
INSERT INTO rifl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Řami ikemmeř SIDI awař i kides issiwřen x wedrar n Sina, iwca i Musa tnayen n teřwiḥin n Cchadet. Tuɣa tiřwiḥin nni zeg weẓru, ttwarint s uḍaḍ n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Řami iẓra řgens belli Musa iɛeṭṭař, war dd-ihwi ɛad zeg wedrar, inneyru-dd řgens ɣar Harun, nnan as: “Kkar, egg aneɣ irebbiten, inni i ɣa yuyuren zzatneɣ, minzi Musa aya, aryaz nni d aneɣ dd-issuffɣen zi Miṣra, war nessin min t yuɣin.” ");
INSERT INTO rifl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harun inna asen: “Qeřɛem tixrazin n wureɣ nni iǧan deg imejjan n temɣarin nwem u n iḥenjiren nwem uřa n yessitwem, awyem tent-i-dd ɣari.” ");
INSERT INTO rifl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ikkes marra řgens tixrazin n wureɣ nni iǧan deg imejjan nsen uca iwyen as tent-i-dd ɣar Harun. ");
INSERT INTO rifl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Netta iksi tent zeg ifassen nsen uca icekkeř i-tent s imeydi, igga zzaysent ijj n uɛejmi n ufessi. Řexdenni nnan: “A Israil, wa d arebbi nnec, wenni cek dd-issuffɣen zi temmurt n Miṣra.” ");
INSERT INTO rifl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Řami iẓra Harun aya, ibna ijj n uɛalṭar zzat i uɛejmi uca iřaɣa Harun, inna: “Tiwecca ad yiři d řɛid i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tiwecca nnes kkaren zic uca ssbexxaren tiɣarṣa n wecmaḍ uca qeddmen akidsent ɛawed tiɣarṣa n řehna. Xenni iqqim řgens, icca, iswa, ikkar, maḥend ad yegg řefrayej. ");
INSERT INTO rifl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Xas uca issiweř SIDI ak-d Musa: “Uyur, hwa, minzi řgens nnec, wenni dd-tessuffɣed zi temmurt n Miṣra, aqa igga min war iḥřin. ");
INSERT INTO rifl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Aqa ffɣen deɣya x webrid nni x ten weṣṣiɣ. Ggin ijj n uɛejmi n ufessi i yixef nsen uca bendqen as, qeddmen as tiɣarṣa uca nnan: ‘A Israil, wanita d arebbi nnec, wenni cek dd-issuffɣen zi temmurt n Miṣra.’” ");
INSERT INTO rifl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Inna SIDI i Musa: “Necc ẓriɣ řgens-a, xzar, aqa-t d ijj n řgens iqseḥ! ");
INSERT INTO rifl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Řexxu ejj ayi ad raḥeɣ, ad areɣ aɣḍab inu xasen uca ad ten teḥḥiɣ, u Necc ad cek arreɣ d ijj n řgens imɣar.” ");
INSERT INTO rifl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Maca Musa izawg zzat i wudem n SIDI, AREBBI nnes, inna: “A SIDI, mayemmi ɣa yareɣ weɣḍab nnec x řgens nnec, wenni dd-tessuffɣed zi temmurt n Miṣra s yijj n jjehd imɣar u s ufus ijehden? ");
INSERT INTO rifl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mayemmi ssawařen Imiṣriyyen jar asen, qqaren: ‘Netta issuffeɣ i-ten s nneyyet taɛeffant, maḥend ad ten ineɣ x idurar u maḥend ad ten iteḥḥa zeg wudem n temmurt?’ Dweř x řḥaduq n weɣḍab nnec uca ndem x tuɛeffna i texsed ad tarred x řgens nnec. ");
INSERT INTO rifl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Fekkar di Ibrahim d Isḥaq d Israil, imsexxaren nnec, inni umi tejjuǧed s Yixef nnec u tessiwřed akidsen: ‘Necc ad arniɣ zzariɛet nwem am yitran n ujenna uca ad wceɣ marra tammurt-a i xef ssiwřeɣ i zzariɛet nnec uca nitni ad tt ṭṭfen d ict n řwart i řebda.” ");
INSERT INTO rifl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Xenni indem SIDI x tuɛeffna i tuɣa inna ad tt yegg x řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Uca idweř-dd Musa, ihwa-dd zeg wedrar s tnayen n teřwiḥin n Cchadet deg ufus nnes. Tiřwiḥin-a ttwarint x tnayen n iɣezdisen nsent: ttwarint x yijj n uɣezdis u x uɣezdis nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tiřwiḥin tuɣa atent d řxedmet n AREBBI uca tira nni ineqcen di teřwiḥin d tira n AREBBI. ");
INSERT INTO rifl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Isřa Yacuwa i řḥess n řgens isɣuyyu uca inna i Musa: “Aqa da, řḥess n umenɣi di řmargeḥ n řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Maca netta inna: “War iǧi d řḥess n usřewřiw ɣar řeɣřeb niɣ d řḥess n usɣuyyi ɣar txessart, maca min ttesřiɣ d řḥess n iɣuyyan war iḥřin.” ");
INSERT INTO rifl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Uca imsar, am dd-ireḥḥeg ɣar řmargeḥ n řɛeskar uca iẓra aɛejmi d ccḍiḥ s nnubtat, yarɣa weɣḍab n Musa uca inḍar tiřwiḥin zeg ifassen nnes, yarẓa i-tent ɣar iḍaren n wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Iṭṭef uɛejmi nni ggin, isscemḍ i-t di tmessi, ařami idweř d iɣɣeḍ uca izzuzar i-t x wudem n waman uca yarra ayt n Israil ad t swen. ");
INSERT INTO rifl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Inna Musa i Harun: “Min zzayek igga řgens-a ařami d as dd-tiwyed ijj n ddenb d ameqqran aṭṭas?” ");
INSERT INTO rifl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harun inna: “War yareqq weɣḍab n sidi inu! Cek tessned řgens-a, aqa-t di řɣar. ");
INSERT INTO rifl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Nnan ayi: ‘Egg aneɣ irebbiten nni ɣa yuyuren zzat i uɣembub nneɣ, minzi Musa wanita, aryaz wenni d aneɣ dd-issuffɣen zi temmurt n Miṣra, war nessin min t yuɣin.’ ");
INSERT INTO rifl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Xenni nniɣ asen: ‘Wi ɣar iǧa ureɣ, ad t-i-dd-ikkes, uca ad ayi t yewc!’ Uca nḍareɣ t di tmessi uca iffeɣ-dd uɛejmi-ya.” ");
INSERT INTO rifl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Umi iẓra Musa, aqa řgens idweř d imfelles, minzi Harun ijja afelles nsen ad idweř d taḍeḥḥact jar řɛedyan nsen, ");
INSERT INTO rifl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ibedd Musa ɣar wadaf n řmargeḥ, inna: “Man wen i iǧan i SIDI, as-dd da ɣari!” Uca munen-dd ɣares marra iḥenjiren n Lawi. ");
INSERT INTO rifl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Inna asen: “Ammu i iqqar SIDI, AREBBI n Israil! Sarsem kuř ijj ssif nnes x tmeṣṣaḍt nnes, ɛdum uca ɛeqbem x řmargeḥ zeg wadaf ɣar wadaf nneɣni uca ad ineɣ kuř ijj umas d kuř ijj umeddukkeř nnes d kuř ijj jjar nnes!” ");
INSERT INTO rifl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tarwa n Lawi ggin ɛlaḥsab awař n Musa. Deg wass nni wḍan ɛřaḥař teřt-ařaf n yeryazen n řgens. ");
INSERT INTO rifl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa inna: “Ksim ifassen nwem ass-a ɣar SIDI, kuř ijj x mmis u x umas. Meɛlik ufiɣ Netta ad ibarek i kenniw ammu ass-a!” ");
INSERT INTO rifl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Tiwecca nnes inna Musa i řgens: “Kenniw teggim ijj n ddenb imɣar. Ɛad necc ad ařyeɣ řexxu ɣar SIDI, balak ad ufiɣ aṣřaḥ x ddenb nwem.” ");
INSERT INTO rifl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Idweř-dd Musa ɣar SIDI uca inna as: “Wayyaw, řgens-a igga ijj n ddenb imɣar, minzi ggin ijj n arebbi n wureɣ i yixef nsen. ");
INSERT INTO rifl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Řexxu, ɣfar asen i ddenb nsen! Niɣ mḥa ayi zeg wedlis nnec ittwannḍen nni turid.” ");
INSERT INTO rifl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Inna SIDI i Musa: “Wenni xafi ixḍan, d wa i ɣa mḥiɣ zeg wedlis inu ittwannḍen. ");
INSERT INTO rifl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ruḥ řexxu, awi řgens-a ɣar mani d ac nniɣ. Aqa lmalak inu ad iraḥ zzat nnec! Deg wass n uxeǧeṣ inu ad asen xeǧṣeɣ ddnub nsen!” ");
INSERT INTO rifl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ammu i iwta SIDI řgens, minzi ggin aɛejmi nni igga Harun. ");
INSERT INTO rifl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Issiweř SIDI ak-d Musa: “Ruḥ, geɛɛed ssa, cek d řgens nni dd-tessuffɣed zi temmurt n Miṣra, ɣar temmurt nni x jjuǧeɣ i Ibrahim d Isḥaq d Yaɛqub, nniɣ: ‘I zzariɛet nnec ad tt wceɣ!’ ");
INSERT INTO rifl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Necc ad ssekkeɣ zzat i uɣembub nnec lmalak, uca ad aẓẓřeɣ x ayt n Kenɛan d Imuriyyen d Iḥittiyyen d Ifiriziyyen d Iḥiwiyyen d Iyibusiyyen ");
INSERT INTO rifl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","deg webrid nwem ɣar ict n temmurt ifeyyḍen s uɣi d tamment. Necc s imant inu war ttgiɛɛideɣ akidwem, ḥima war kenniw tᵉtteḥḥiɣ deg webrid, minzi kenniw d ijj n řgens iqseḥ.” ");
INSERT INTO rifl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Umi isřa řgens awař-a aɛeffan, ceḍnen uca uřa d ijj igga ɛad řehzuṭ nnes. ");
INSERT INTO rifl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Aqa inna SIDI i Musa: “Ini i ayt n Israil: ‘Kenniw d ijj n řgens iqseḥ. Mařa geɛɛdeɣ jar awem mɣir ijj n wermac, ad kenniw teḥḥiɣ. Xenni řexxu kksem řehzuṭ nwem, aqa Necc ad ssneɣ min d ac ɣa ggeɣ.’” ");
INSERT INTO rifl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kksen ayt n Israil řehzuṭ nsen zeg wedrar n Hurib. ");
INSERT INTO rifl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Iksi Musa Aqiḍun uca iwta Aqiḍun barra i řmargeḥ n řɛeskar, iggʷej aṭṭas x řmargeḥ, uca iřaɣa as ‘Aqiḍun n Umsagar’. Kuř ijj wenni tuɣa yarezzun SIDI, iffeɣ ɣar Uqiḍun n Umsagar, wenni iǧan barra i řmargeḥ. ");
INSERT INTO rifl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Umi iffeɣ Musa ɣar Uqiḍun, ikkar marra řgens, bedden barra, kuř ijj ɣar wadaf n uqiḍun nnes, uca nitni xzaren ɣares am tiṭṭawin nsen ḍeffaren Musa ařami yudef ɣar Uqiḍun. ");
INSERT INTO rifl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Umi yudef Musa ɣar Uqiḍun, aqa aqellij n useynu ihwa, ibedd ɣar wadaf n Uqiḍun uca Netta issiweř ak-d Musa. ");
INSERT INTO rifl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Uca marra řgens iẓra aqellij n useynu ibedd ɣar wadaf n Uqiḍun, xenni ikkar marra řgens uca ibendeq kuř ijj ɣar wadaf n uqiḍun nnes. ");
INSERT INTO rifl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Issiweř SIDI ak-d Musa aɣembub deg uɣembub, am mammec issiweř bnadem ak-d umeddukkeř nnes. Xenni iɛqeb-dd ɣar řmargeḥ n řɛeskar, maca amsexxar nnes Yacuwa, mmis n Nun, wenni ɛad d aḥudri, ɛemmarṣ war ibeɛɛed x řwesṭ n Uqiḍun. ");
INSERT INTO rifl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Inna Musa i SIDI: “Xzar, Cek tennid ayi: ‘Ndeh řgens-a!’, maca Cek war d ayi tessecned wi kidi i ɣa tessekked. Cek tennid: ‘Necc ssneɣ cek s yisem nnec!’ uřa: ‘Tufid arḍa di tiṭṭawin inu!’ ");
INSERT INTO rifl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Řexxu xenni, mařa ufiɣ arḍa di tiṭṭawin nnec, zawgeɣ Cek ad ayi tessecned abrid nnec, ḥima ad Cek ssneɣ, maḥend ad afeɣ arḍa di tiṭṭawin nnec. Xzar, cceɛb-a d řgens nnec!” ");
INSERT INTO rifl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Inna: “Lmalak n wudem inu ad yuyur akidek u Necc ad cek ssareyyḥeɣ.” ");
INSERT INTO rifl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Xenni yarra-dd xas: “Mařa udem nnec war kidneɣ ittriḥ, war ttejji xenni ad ngeɛɛed ssa! ");
INSERT INTO rifl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mammec ɣa ssnen belli aqa ufiɣ arḍa di tiṭṭawin nnec, necc d řgens nnec? Ma war iǧi minzi Cek truḥed akidneɣ, aqa neccin, necc d řgens nnec, nfarrez x kuř řgens i iǧan x wudem n temmurt?” ");
INSERT INTO rifl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Inna SIDI i Musa: “Ɛawed ad ggeɣ awař-a i tennid umi tufid arḍa di tiṭṭawin inu uca ssneɣ cek s yisem nnec.” ");
INSERT INTO rifl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Xas uca inna Musa: “Zawgeɣ Cek, scen ayi aɛuǧi nnec!” ");
INSERT INTO rifl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Inna: “Necc ad sseɛduɣ marra tcuni inu zzatek uca ad ɛeyydeɣ Isem n SIDI zzat i uɣembub nnec uca ad ḥinneɣ x wi ɣa ḥinneɣ, ad areḥmeɣ x wi ɣa areḥmeɣ.” ");
INSERT INTO rifl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Inna ɛawed: “Cek war tzemmared ad tẓared udem inu, minzi war d ayi iẓarr bnadem uca ad iqqim iddar.” ");
INSERT INTO rifl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Xas uca inna SIDI: “Xzar, zzat inu amcan mani ɣa tbedded x teṣḍart. ");
INSERT INTO rifl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Xmi ɣa iɛdu uɛuǧi inu, ad cek ggeɣ deg ijj n ufeǧiq n teṣḍart uca ad cek dřeɣ s třeqqa n ufus inu ař dd-ẓwiɣ. ");
INSERT INTO rifl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","U xmi ɣa kkseɣ afus inu, xenni ad ayi tẓared zi ḍeffar, maca war tẓarred udem inu!” ");
INSERT INTO rifl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","SIDI inna i Musa: “Qess i yixef nnec tnayen n teřwiḥin n weẓru am tmezwura, uca Necc ad ariɣ x teřwiḥin nni awařen d ijjen i tuɣa di teřwiḥin timezwura i tarẓid. ");
INSERT INTO rifl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sewjed i ṣṣbeḥ uca geɛɛed di ṣṣbeḥ ɣar wedrar n Sina uca bedd din zzati x tqiccet n wedrar. ");
INSERT INTO rifl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","War iɛeddeř ad igeɛɛed uřa d ijj n bnadem akidek, niɣ ad iban ḥed deg wedrar am ikmeř. Uřa d uǧi d ifunasen d tfunasin war zemmaren ad arewsen ṭṭarf i wedrar.”    ");
INSERT INTO rifl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Xenni iqess tnayen n teřwiḥin n weẓru am tmezwura, uca ikkar Musa di ṣṣbeḥ zic uca igeɛɛed ɣar wedrar n Sina am mammec t iweṣṣa SIDI uca yiwi akis deg ufus nnes tnayen n teřwiḥin n weẓru. ");
INSERT INTO rifl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ihwa-dd SIDI deg useynu, ibedd akides din uca iřaɣa s Yisem n ‘SIDI’. ");
INSERT INTO rifl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Iẓwa SIDI zzat i uɣembub nnes uca iɛeyyed: “SIDI, SIDI, Arebbi, d wenni iccuren s arreḥmet d teḥnunect, ɣares ttasiɛ n řxaḍar, dayes aṭṭas n tmexsiwt icewwaren d řaman, ");
INSERT INTO rifl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","d wenni iḥeṭṭan tamexsiwt nnes icewwaren i řuřuf, d wenni iɣeffaren řmuɛṣiyyet d xeṭṭu d ddnub, d wenni war ittbarrin wenni itteggen ddenb, d wenni dd-yarezfen řmuɛṣiyyet n ibabaten deg iḥenjiren u deg iḥenjiren n iḥenjiren nsen ař jjiř wiss třata d wiss arebɛa.” ");
INSERT INTO rifl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa yuḍar s wudem nnes ɣar temmurt uca ibendeq. ");
INSERT INTO rifl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Inna: “A Sidi inu, mařa ufiɣ xenni arḍa di tiṭṭawin nnec, ad yuyur xenni Sidi inu di řwesṭ nneɣ, minzi řgens iqseḥ. Ɣfar aneɣ řmuɛṣiyyet nneɣ u qbeř aneɣ d řwart nnec!” ");
INSERT INTO rifl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Netta inna: “Xzar, Necc ad ggeɣ Řɛahd. Zzat i marra řgens nnek, ad ggeɣ řeɛjayeb war ittwaggen ca di marra tammurt u jar marra řegnus, ařami marra řgens di řwesṭ nnes i zi teǧid, ad iẓar min igga SIDI, minzi min ɣa ggeɣ akidek ad isseggʷed aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ḥḍa min x cek weṣṣiɣ ass-a! Xzar, ad aẓẓřeɣ zzat i uɣembub nnec x Imuriyyen d ayt n Kenɛan d Iḥittiyyen d Ifiriziyyen d Iḥiwiyyen d Iyibusiyyen. ");
INSERT INTO rifl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ɣarek ad tegged řɛahd ak-d umezduɣ n temmurt mani ɣa tadfed, ḥima netta war d ac ittiři d řfex di řwesṭ nnec. ");
INSERT INTO rifl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ittxeṣṣa awem ad tɣeḍřem iɛalṭaren nsen u ad tarẓam imayḍuten nsen iqeddsen u ad thedmem tirebbin nsen n cwarti. ");
INSERT INTO rifl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","War ttbendiq i arebbi nneɣni, minzi SIDI, wenni umi qqaren ‘Anessam’, aqa-t d ijj n Arebbi ittasmen.    ");
INSERT INTO rifl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ɣarek ad tegged řɛahd ak-d imezdaɣ n temmurt, uca xenni ad ssfesden nitni ixef nsen umi ɣa dewřen awarni i irebbiten nsen, ad qeddmen tiɣarṣa i irebbiten nsen, uca ad cek ɛarḍen i macca n tɣarṣa nsen. ");
INSERT INTO rifl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ad teksid tiḥenjirin nsen d timɣarin i iḥenjiren nnec, maca ad ssfesdent tḥenjirin nsen ixef nsent umi ɣa dewřen awarni i irebbiten nsent uca ad arrent iḥenjiren nnec ad dewřen awarni i irebbiten nsent. ");
INSERT INTO rifl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","War ttegg i yixef nnec irebbitten n ufessay. ");
INSERT INTO rifl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ad teḥḍiḍ Řɛid n Weɣrum břa Antun: sebɛa n wussan ad tecced aɣrum břa antun, di řweqt ittwaggen deg uyur Abib, am mammec cek weṣṣiɣ, minzi deg uyur Abib i dd-teffɣed zi Miṣra. ");
INSERT INTO rifl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Marra min yarezzmen řemřawet d amezwaru Inu, marra iwetman n řebhayem nnec i ɣa yarzzmen řemřawet d amezwaru, am wenni n ufunas, am wenni n wuǧi. ");
INSERT INTO rifl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mařa amenzu n weɣyuř yarzem řemřawrat d amezwaru, ad t tefdid s yijj zeg wuǧi. Mařa war t tefdid, ad as tarẓed iri. Ad tefdid marra imenza n iḥenjiren nnec. War iɛeddeř ad ḍharen s ifassen xwan zzat i wudem inu. ");
INSERT INTO rifl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Setta n wussan ad txedmed, maca deg wass wiss sebɛa ad tareyyḥed. Uřa di řweqt n tyarza d tmeyra ad tareyyḥed. ");
INSERT INTO rifl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ad tegged Řɛid n Simanat, aqa-t d Řɛid n Tmenzut n tmeyra n yirden, uřa d Řɛid n Usmuni ɣar uneggar n useggʷas. ");
INSERT INTO rifl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Kuř aryaz ad dd-iban třata n twařawin deg useggʷas zzat i wudem n Sidi, SIDI, AREBBI n Israil, ");
INSERT INTO rifl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","minzi zzat i uɣembub nnec ad kkseɣ tasɣart n řwart x řegnus uca ad sswesɛeɣ iymiren nnec uca uřa d ijjen ad immeẓri ad yacar tammurt nnec, xmi ɣa tgeɛɛded třata n twařawin deg useggʷas, ḥima ad tbaned zzat i wudem n SIDI, AREBBI nnec. ");
INSERT INTO rifl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","War ttqeddem idammen n tɣarṣt inu ak-d min ixemmaren. Taɣarṣt n Řɛid n Tɣarṣt n Useɛdu war ttnusi ǧiřet ař ṣṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Tamezwarut n tmenzut n wudem n temmurt nnec ad tt-i-dd-tawyed ɣar Taddart n SIDI, AREBBI nnec. War snenni iɣayḍ d ameẓyan s uɣi n yemmas.” ");
INSERT INTO rifl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Inna SIDI i Musa: “Ari awařen-a i yixef nnec, minzi am mammec qqaren wawařen-a, aqa ggiɣ Řɛahd akidek u ak-d Israil.” ");
INSERT INTO rifl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Uca Musa tuɣa din ak-d SIDI arebɛin n wussan d arebɛin n ǧyaři. War icci aɣrum niɣ iswa aman. Uca yura di teřwiḥin awařen n Řɛahd, Ɛecra n Wawařen. ");
INSERT INTO rifl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Řami dd-ihwa Musa zeg wedrar n Sina, am tuɣa tnayen n teřwiḥin n Cchadet deg ifassen n Musa am dd-ihwa zeg wedrar, imsar aqa war issin Musa belli tiřmect n uɣembub nnes tareqq minzi tuɣa akides issawař. ");
INSERT INTO rifl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Harun d marra ayt n Israil ṣewḍen ɣar Musa, u xzar, tiřmect n wudem nnes tuɣa tareqq, ggʷeden ad ɣares dd-qarrben. ");
INSERT INTO rifl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Iřaɣa-dd xasen Musa uca idweř-dd Harun d marra řḥukkam n tmesmunt ɣares uca issiweř Musa akidsen. ");
INSERT INTO rifl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Awarni as qarrben-dd marra ayt n Israil uca netta yumur i-ten marra min xef issiweř SIDI akides deg wedrar n Sina. ");
INSERT INTO rifl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Řami ikemmeř Musa awař nnes akidsen, igga ařeḥḥaf x wudem nnes. ");
INSERT INTO rifl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Xmi i ɣa yiři Musa zzat i wudem n SIDI ḥima ad kides issiweř, ikkes ařeḥḥaf, ař dd-iffeɣ ɛawed. U řami dd-iffeɣ ɣar barra, issiweř ak-d ayt n Israil min d as yumur SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Uca ẓrin ayt n Israil aɣembub n Musa, aqa tiřmect n wudem nnes tareqq, xenni yarra Musa ařeḥḥaf x wudem nnes, ař dd-yudef ɛawed, ḥima akides issiweř. ");
INSERT INTO rifl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa issmun marra tamesmunt n ayt n Israil uca inna asen: “Ina d awařen nni yumur SIDI, ḥima ad ten teggem. ");
INSERT INTO rifl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Setta n wussan ad tegged řxedmet u ass wiss sebɛa ad awem yiři iqeddes, aqa d ssebt, arraḥet tmun i SIDI. Kuř ijj, wenni dayes iggin ca n řxedmet, ad ittwaneɣ. ");
INSERT INTO rifl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","War tessruɣim kenniw timessi di marra tizeddiɣin nwem deg wass n ssebt.” ");
INSERT INTO rifl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Issiweř Musa ak-d marra tamesmunt n ayt n Israil, inna: “D wa d min iweṣṣa SIDI, umi inna: ");
INSERT INTO rifl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Ksim zi min ɣarwem ict n tewhibt n usgeɛɛed i SIDI. Kuř ijj, wenni umi yennurzem wuř nnes, ad tt yawi, aqa-tt d tawhibt n usgeɛɛed i SIDI: ureɣ d nnuqart d nnḥas, ");
INSERT INTO rifl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","afiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen d řeqṭen azdad d ccɛar n iɣayḍen, ");
INSERT INTO rifl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","iřmawen izeggʷaɣen n icarriyyen d iřmawen n ddenfiřat d ukeccuḍ n ukasiya, ");
INSERT INTO rifl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","zzect i tfawt, řeɛṭur i zzect n wedhan u i řebxur ittfuḥen, ");
INSERT INTO rifl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","iẓra n uniks d iẓra iɣřan nneɣni, maḥend ad ten ggen x upalṭu u x tejmect. ");
INSERT INTO rifl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Marra inni iǧan jar awem s wuř d amiɣis, ad dd-asen ad ggen marra min yumur SIDI: ");
INSERT INTO rifl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Tazeddiɣt, Aqiḍun nnes d tseqqaft nnes d tsennarin nnes d tfeřwin nnes d tḥenya nnes n uɛarreḍ d ipilaren nnes d tyarsawin nnes, ");
INSERT INTO rifl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","d Ttabut ak-d iɛumad nnes i tarebbut d tqebbart n weṣřaḥ d uřeḥḥaf i dduri, ");
INSERT INTO rifl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","d tzewḍa ak-d iɛumad nnes i tarebbut d marra řeqcuɛ nnes d weɣrum n wescan, ");
INSERT INTO rifl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","d řqendiř i tfawt d řeqcuɛ nnes d teftiřin nnes d zzect i tfawt ");
INSERT INTO rifl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","d uɛalṭar n řebxur ak-d iɛumad nnes i tarebbut d zzect i wedhan d řebxur ittfuḥen d arwaq n wadaf ɣar wadaf n Tzeddiɣt, ");
INSERT INTO rifl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","d uɛalṭar n wecmaḍ d tracca nnes n nnḥas d iɛumad nnes i tarebbut d marra řeqcuɛ nnes d tbanyut s uḍar nnes, ");
INSERT INTO rifl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","d řizarat n řemraḥ, ipilaren nnes ak-d tyarsawin nsen d arwaq i wadaf n řemraḥ, ");
INSERT INTO rifl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","d řewtad n Tzeddiɣt d řewtad n řemraḥ d ifiřan nsen, ");
INSERT INTO rifl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","arruḍ i řxedmet deg Uqeddas, arruḍ iqeddsen n ukehhan Harun d warruḍ n warraw nnes, maḥend ad xedmen am yikehhanen.’” ");
INSERT INTO rifl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Xenni ffɣen nitni, marra tamesmunt n ayt n Israil, ggʷejen zi zzat n uɣembub n Musa. ");
INSERT INTO rifl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Xenni yusa-dd kuř ijj, wenni umi inhezz wuř nnes, u marra wenni umi innurzem buḥbeř nnes, uca iwyen-dd nitni tawhibt n usgeɛɛed, tenni ssgeɛɛden nitni ɣar SIDI, d tenni i ɣa yiřin i Uqiḍun n Umsagar u i tsexxart i dayes u i warruḍ iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ammu dd-usin iryazen jmiɛ ak-d temɣarin, marra inni umi innurzem wuř nsen uca iwyen-dd timessakin d texrazin n umezzuɣ d tinzar d txudan n ucemmiɛ d tseddiyin s wedmam n wureɣ d marra řeqcuɛ n wureɣ, wah, kuř ijjen yiwi ict n tewhibt n wenhezzi n wureɣ i SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Marra wi ɣar ittwaf afiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen niɣ řeqṭen azdad niɣ ccɛar n iɣayḍen niɣ iřmawen izeggʷaɣen n icarriyyen niɣ iřmawen n ddenfiřat, iwyen-dd man aya. ");
INSERT INTO rifl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Marra wi issgeɛɛden tawhibt n nnuqart niɣ n nnḥas, iwyen tawhibt-a n usgeɛɛed ɣar SIDI, d marra wi ɣar ittwaf ukeccuḍ n ukasiya i marra řxedmet n tsexxart, iwyen man aya. ");
INSERT INTO rifl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Marra timɣarin s wuř amiɣis ttqarḍcent s ifassen nsent uca nitenti iwyent-i-dd min qareḍcent: afiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen d řeqṭen azdad.    ");
INSERT INTO rifl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Marra timɣarin nni umi inhezz wuř nsent s tiɣit, qareḍcent ccɛar n iɣayḍen. ");
INSERT INTO rifl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Řḥukkam iwyen-dd iẓra n uniks d iẓra iɣřan nneɣni, ḥima ad ten ggen x upalṭu u x tejmect, ");
INSERT INTO rifl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","řeɛṭur d zzect i tfawt d zzect i wedhan u i řebxur ittfuḥen. ");
INSERT INTO rifl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ayt n Israil wcin s řxaḍar i SIDI, marra iryazen d temɣarin, inni umi inhezz wuř nsen, maḥend ad wcen s řxaḍar i marra řxedmet nni yumur SIDI, ḥima ad tᵉttwagg s tsexxart n Musa. ");
INSERT INTO rifl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Xenni inna Musa i ayt n Israil: “Xzarem, SIDI iřaɣa-dd i Baṣaliyil, mmis n Uri, mmis n Ḥur, zi řaǧ n Yahuda, s yisem nnes. ");
INSERT INTO rifl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Iccur i-t Arruḥ n AREBBI s tiɣit d řeɛqeř d tussna u s marra min ittxeṣṣan n tzemmar n ṣṣnayeɛ ");
INSERT INTO rifl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","i uxemmem n ɛřam kuř ireqqamen, ḥima ad ten yegg s wureɣ d nnuqart d nnḥas, ");
INSERT INTO rifl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","u i uneqqac n iẓra iɣřan d usarsi nsen, u i uneqqac n ukeccuḍ u ḥima ad igg marra ireqqamen s lfenn. ");
INSERT INTO rifl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Igga Arebbi deg wuř nnes tawengit i useřmed, deg wuř nnes u deg wuř n Ahuliyab, mmis n Axisamak, zi řaǧ n Dan. ");
INSERT INTO rifl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Iccur i-ten s tiɣit n wuř, maḥend ad ggen marra řxedmet: řxedmet n taneqqact d warcam d umudi s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen d řeqṭen azdad uřa d řxedmet n uxeyyaḍ.” Nitni ggin kuř řxedmet u ttsaqaren arcamen s lfenn. ");
INSERT INTO rifl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Baṣaliyil d Ahuliyab d kuř aryaz s wuř amiɣis i umi iwca SIDI tiɣit d řeɛqeř, maḥend ad ssnen mammec ɣa ggen marra řxedmet i tsexxart n Zzawect Iqeddsen, ggin marra am mammec ten yumur SIDI. ");
INSERT INTO rifl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa iřaɣa-dd i Baṣaliyil d Ahuliyab d kuř aryaz s wuř amiɣis, umi igga SIDI tiɣit deg wuř nnes, uřa marra wenni umi inhezz wuř nnes, maḥend ad dd-yas ɣar řxedmet uca ad tt igg. ");
INSERT INTO rifl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Nitni ksin zi zzat n wudem n Musa marra tawhibt nni ssgeɛɛden ayt n Israil i řxedmet di ṭṭweɛ ni tsexxart n Zzawect Iqeddsen, maḥend ad ggen řxedmet nni. Uca aqa ɛad ggin ad as dd-awyen kuř ṣṣbeḥ tiwhibin s řxaḍar. ");
INSERT INTO rifl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Xenni usin-dd marra iryazen imiɣisen, inni tuɣa iceɣřen x marra řxedmet n Zzawect Iqeddsen, ijj ijj dewřen-dd zi řxedmet nni ggin nitni, ");
INSERT INTO rifl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","uca ssiwřen ak-d Musa, nnan: “Řgens yiwi-dd ktar zi min ittxeṣṣan di ṭṭweɛ n řxedmet nni i d aneɣ yumur SIDI, ḥima ad tt negg.” ");
INSERT INTO rifl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Xas uca yumur Musa, ḥima ad barrḥen di řmargeḥ n řɛeskar, ad inin: “War ttejji aryaz niɣ tamɣart ɛad ad yegg ca n řxedmet nni i ɣa issgeɛɛed d tawhibt i Zzawect Iqeddsen!” Ammu i issbedd Musa řgens ad yawi ɛad ktar, ");
INSERT INTO rifl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","minzi cfa timesřayin nni d iwyen i marra řxedmet i ɣa ggen, aqa tceṭṭ ɛad ktar. ");
INSERT INTO rifl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Jar yinni ɣar tuɣa řxedmet, aqa marra imiɣisen n wuř ggin Tazeddiɣt zi ɛecra n tjartiřin n řeqṭen azdad imuden u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen ak-d ikiruben nni xasent igga am yijj n warcam n ufennan. ");
INSERT INTO rifl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Tuzzeggart n ict n tjartiřt tuɣa-tt tmenya u-ɛecrin n iɣaǧen u tiru n ict n tjartiřt tuɣa-t arebɛa n iɣaǧen u marra tijartiřin ɣarsent d řeɛbar d ijj. ");
INSERT INTO rifl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Issmun xemsa n tjartiřin ict ak-d tenneɣni uca xemsa n tjartiřin issmun i-tent ɛawed ict ak-d tenneɣnit. ");
INSERT INTO rifl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Xenni igga tisarawin ideḥmaniyyen di tma n yict n tjartiřt ɣar ṭṭarf ɣar useřqi uca amenni i tent igga ɛawed di tma n tjartiřt nneɣni ɣar ṭṭarf, ɣar mani iǧa useřqi nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Igga xemsin n tsarawin x tma n yict n tjartiřt d xemsin n tsarawin ɣar ṭṭarf n tjartiřt nneɣni ɣar useřqi nneɣni. Tisarawin ṭṭfent nican ict di tenneɣnit. ");
INSERT INTO rifl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Igga ɛawed xemsin n tsennarin n wureɣ uca issmun tijartiřin ict i tenneɣni s tsennarin uca ammu tedweř Tzeddiɣt d ict. ");
INSERT INTO rifl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Igga ɛawed tijařtiřin n ccɛar n iɣayḍen, ad iřint d Aqiḍun x Tzeddiɣt. Igga ḥiṭac n tjartiřin. ");
INSERT INTO rifl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tuzzeggart n ict n tjartiřt tuɣa-tt třatin n iɣaǧen u tiru n ict n tjartiřt d arebɛa n iɣaǧen. Ḥiṭɛac n tjartiřin ɣarsent řeɛbar d ijj. ");
INSERT INTO rifl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Netta issmun xemsa n tjartiřin weḥḥedsent u ɛawed setta n tjartiřin weḥḥedsent. ");
INSERT INTO rifl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Igga xemsin n tsarawin x tma n tjartiřt taneggarut ɣar ṭṭarf n useřqi ak-d tenneɣni uca igga ɛawed xemsin n tsarawin x tma n tjartiřt ɣar ṭṭarf n useřqi nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Igga ɛawed xemsin n tsennarin n nnḥas, ḥima ad issmun Aqiḍun maḥend ad t yarr d ijjen. ");
INSERT INTO rifl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Igga ɛawed ict n tseqqaft n iřmawen izeggʷaɣen n icarriyyen i Uqiḍun uca sennej i man aya ict n tseqqaft n iřmawen n ddenfiřat. ");
INSERT INTO rifl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Igga tifeřwin i Tzeddiɣt s ukeccuḍ n ukasiya nni ibedden nican. ");
INSERT INTO rifl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Tuzzeggart n ict n tefřawt tuɣa-tt ɛecra n iɣaǧen u tiru n yict n tefřawt d ijj n uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kuř tafřewt ɣares tnayen n iḍaren, inni issmeřqan ict ak-d tenneɣnit am twečmatin Ammu i igga s marra tifeřwin n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Igga tifeřwin i Tzeddiɣt, ɛicrin n tfeřwin ɣar jjihet n ljanub, ɣar yefus. ");
INSERT INTO rifl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Igga ɛawed arebɛin n tyarsawin n nnuqart sadu ɛicrin n tfeřwin, tnayen n tyarsawin sadu ict n tefřawt i tnayen n iḍaren nnes, uřa d tnayen n tyarsawin sadu tafřawt nneɣni i tnayen n iḍaren nnes. ");
INSERT INTO rifl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Igga ɛawed ɛicrin n tfeřwin i uɣezdis nneɣni n Tzeddiɣt, ɣar uɣezdis n ccamal, ");
INSERT INTO rifl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","s arebɛin n tyarsawin nnes n nnuqart: tnayen n tyarsawin sadu ict n tefřawt d tnayen n tyarsawin sadu tafřawt nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","I iɣezdisen n ḍeffar n Tzeddiɣt, ɣar uɣezdis n řɣarb, igga setta n tfeřwin. ");
INSERT INTO rifl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Igga tnayen n tfeřwin d tifeřwin i tɣemmura n Tzeddiɣt ɣar tnayen n iɣezdisen ɣar ḍeffar. ");
INSERT INTO rifl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Zi swadday tuɣa řeṣqent am wacniwen uca ammu i tent tuɣa d icten ař dd-awḍent sennej deg ict n texrazt. Ammu i igga s tnayen n tfeřwin i tnayen n tɣemmura. ");
INSERT INTO rifl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ammu i din tuɣa tmenya n tfeřwin s tyarsawin nsent n nnuqart, aqa atent d seṭṭac n tyarsawin, tnayen n tyarsawin sadu kuř tafřewt. ");
INSERT INTO rifl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Igga ɛawed tiḥenya n uɛarreḍ zeg ukeccuḍ n ukasiya, xemsa n tfeřwin ɣar ijj n uɣezdis n Tzeddiɣt, ");
INSERT INTO rifl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","u xemsa n tḥenya n uɛarreḍ i tfeřwin ɣar uɣezdis nneɣni n Tzeddiɣt d xemsa n tḥenya n uɛarreḍ i tfeřwin n Tzeddiɣt ɣar tnayen n tɣemmura n ḍeffar ɣar řɣarb. ");
INSERT INTO rifl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Taḥnact n uɛarreḍ di řwesṭ igga i-tt ad teẓwa zi řwesṭ n tfeřwin zeg ixef ař wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Iɣeǧef tifeřwin s wureɣ uca igga tixrazin nsent n wureɣ, maḥend ad daysent ssidfen tiḥenya n uɛarreḍ uca uřa d tiḥenya n uɛarreḍ icellel i-tent s wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Igga ijj n uřeḥḥaf s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden, igga i-t d ijj n warcam n ufennan ak-d ikiruben xas. ");
INSERT INTO rifl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Igga as arebɛa n ipilaren n ukeccuḍ n ukasiya uca iɣeǧef i-ten s wureɣ. Tisennarin nsen tuɣa atent n wureɣ. Issefsi i ipilaren arebɛa n tyarsawin nsent n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Igga ijj n arwaq i wadaf n Uqiḍun s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden, igga i-t d ijj n umudi n uxeyyaḍ, ");
INSERT INTO rifl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","s xemsa n ipilaren nnes d tsennarin nnes. Iɣeǧef tizeǧifin nsen d iqeḍban nsen i useřqi s wureɣ. Tiyarsawin nsen tuɣa atent n nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Igga Baṣaliyil Ttabut n ukeccuḍ n tcejjart n ukasiya. Tuzzeggart nnes tuɣa-tt tnayen n iɣaǧen d wezyen u tiru nnes ijj n uɣiř d wezyen uca řuɛřa nnes ijj n uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Iɣeǧef i-t zi daxeř d barra s wureɣ iṣfan uca igga as ijj n zzwaq n wureɣ i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Issefsi as arebɛa n texrazin i arebɛa n tɣemmura nnes: tnayen n texrazin ɣar yijj n uɣezdis d tnayen n texrazin ɣar uɣezdis nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Igga iɛumad i tarebbut zeg ukeccuḍ n ukasiya uca iɣeǧef i-ten s wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Igga iɛumad i tarebbut di texrazin ɣar tnayen n iɣezdisen n Ttabut, maḥend ad zzaysen arbun Ttabut. ");
INSERT INTO rifl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Igga taqebbart n weṣřaḥ n wureɣ iṣfan s tuzzeggart nnes n tnayen n iɣaǧen d wezyen u tiru nnes n ijj n uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Igga tnayen n ikiruben n wureɣ. Iɛdeř i-ten am řxedmet n wemziř i dd-itteffɣen zi tnayen n ixfawen n tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ijj n ukirub iffeɣ zeg ijj n ixef ɣar uɣezdis-a u akirub nneɣni zeg ixef nneɣni ɣar uɣezdis nneɣni. Igga ikiruben zi tnayen n ixfawen n tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ikiruben sswiẓẓḍen afriwen nsen sennej uca s wafriwen nsen dřin taqebbart n weṣřaḥ. Iɣembab nsen tuɣa ijjen qibač i wenneɣni uca di řweqt d icten tuɣa iɣembab n ikiruben ɣar tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Igga tazewḍa n ukeccuḍ n tcejjart n ukasiya. Tuɣa tuzzeggart nnes tnayen n iɣaǧen u tiru nnes ijj n uɣiř d řuɛřa nnes ijj n uɣiř d wezyen. ");
INSERT INTO rifl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Iɣeǧef i-tt s wureɣ iṣfan uca igga as ijj n zzwaq n wureɣ i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Igga ɛawed ict n tma i d as dd-innḍen n ijj n cbar n ufus uca igga ijj n zzwaq n wureɣ ɣar tmewwa nnes i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Issefsi as arebɛa n texrazin n wureɣ uca igga tixrazin ɣar arebɛa n tɣemmura nni iǧan ɣar arebɛa n iḍaren nnes. ");
INSERT INTO rifl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Tuɣa tixrazin zzat n tma, maḥend ad daysent ssidfen iɛumad i tarebbut, ḥima ad zzaysen arbun tazewḍa. ");
INSERT INTO rifl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Igga iɛumad i tarebbut zeg ukeccuḍ n ukasiya uca iɣeǧef i-ten s wureɣ, maḥend ad zzaysen arbun tazewḍa. ");
INSERT INTO rifl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Igga řeqcuɛ i ɣa yiřin x tzewḍa s wureɣ iṣfan: ṭṭbaṣi nnes d tɣenjayin nnes d řkisan nnes d iɣarrafen, maḥend ad zzaysen kebben. ");
INSERT INTO rifl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Igga řqendiř n wureɣ iṣfan. Iɛdeř řqendiř s wefḍis n wemziř: afud x uḍar nnes d iɣaǧen nnes d řkisan nnes d tɛebbuzin nnes i dd-ittasen ak-d nnuwarat nnes, aqa-ten marra tuɣa zzayes dd-itteffɣen. ");
INSERT INTO rifl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Zeg iɣezdisen nnes ffɣen-dd setta n iɣaǧen, třata n iɣaǧen n řqendiř zeg ijj n uɣezdis d třata n iɣaǧen n řqendiř zeg uɣezdis nneɣni. ");
INSERT INTO rifl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ɣar ijj n uɣiř tuɣa din třata n řkisan am nnewwac n ǧewz s tɛebbuzt d nnewwac uca x uɣiř nneɣni ɛawed třata n řkisan am nnewwac n ǧewz s ict n tɛebbuzt i dd-ittasen ak-d ijj n nnewwac. Ammu i yeǧan marra setta n iɣaǧen nni dd-itteffɣen zi řqendiř. ");
INSERT INTO rifl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ɣar řqendiř simant nnes tuɣa din arebɛa n řkisan am nnuwarat n ǧewz ak-d tɛebbuzin nsen i dd-ittasen ak-d nnuwarat nsen. ");
INSERT INTO rifl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Sadu tyuya n iɣaǧen i zzayes dd-iffɣen d amezwaru aqa din ict n tɛebbuzt uca amenni i din ict n tɛebbuzt sadu tyuya n iɣaǧen i zzayes dd-iffɣen awarni as uca ɛawed din ict n tɛebbuzt sadu tyuya n iɣaǧen i zzayes dd-iffɣen d aneggaru. Man aya iǧa amenni i setta n iɣaǧen i zzayes dd-iffɣen. ");
INSERT INTO rifl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Tuɣa tiɛebbuzin nsen d iɣaǧen nsen ffɣen-dd zzayes. Marra aya tuɣa d ict n řxedmet n wemziř s wureɣ iṣfan. ");
INSERT INTO rifl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Igga setta n řefnarat nnes ak-d tjeqqaḍin n teftič nnes d tmejmarin nnes, marra s wureɣ iṣfan.    ");
INSERT INTO rifl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Igga řqendiř ak-d marra řeqcuɛ nnes zeg ict n talint n wureɣ iṣfan. ");
INSERT INTO rifl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Igga aɛalṭar n řebxur zeg ukeccuḍ n tcejjart n ukasiya s tuzzeggart nnes n ijj uɣiř u tiru nnes n ijj n uɣiř. Tuɣa-t s arebɛa n tɣemmura. Řuɛřa nnes tuɣa-t tnayen n iɣaǧen. Zzayes tuɣa accawen nnes d ijj akides.    ");
INSERT INTO rifl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Iɣeǧef i-t s wureɣ iṣfan, udem nnes n sennej d iɣezdisen nnes i d as dd-innḍen u ɛawed accawen nnes. Igga as ijj n zzwaq n wureɣ i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Igga as tnayen n texrazin n wureɣ sadu zzwaq nnes i tnayen n tɣemmura nnes, ɣar tnayen n iɣezdisen nnes, ḥima ad daysent ssidfen iɛumad, maḥend ad zzaysen arbun aɛalṭar n řebxur. ");
INSERT INTO rifl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Igga iɛumad i tarebbut zeg ukeccuḍ n ukasiya uca iɣeǧef i-ten s wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Igga ɛawed zzect tamqeddest i wedhan d řebxur iṣfan ittfuḥen, ɛlaḥsab ṣṣenɛet n uɛeṭṭař. ");
INSERT INTO rifl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Igga aɛalṭar n wecmaḍ s ukeccuḍ n ukasiya. Tuzzeggart nnes tuɣa-tt xemsa n iɣaǧen u tiru nnes xemsa n iɣaǧen, tuɣa-t s arebɛa n tɣemmura, u řuɛřa nnes tuɣa-t třata n iɣaǧen. ");
INSERT INTO rifl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ɣar arebɛa n tɣemmura igga accawen nnes. Accawen nnes tuɣa aten d ijjen akides. Iɣeǧef i-t s nnḥas.    ");
INSERT INTO rifl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Igga marra řeqcuɛ i uɛalṭar: tiydurin d iɣenjayen d ṭṭawyat i urucci d furcayat d tmejmarin, marra řeqcuɛ-a igga i-ten s nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Igga ict n tracca i uɛalṭar, ijj n umudi n nnḥas sadu tma nnes, swadday ɣar wezyen n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Issefsi arebɛa n texrazin i arebɛa n ixfawen n tracca n nnḥas maḥend ad daysent ssidfen iɛumad i tarebbut. ");
INSERT INTO rifl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Igga iɛumad i tarebbut zeg ukeccuḍ n ukasiya uca iɣeǧef i-ten s nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Igga iɛumad i tarebbut di texrazin ɣar iɣezdisen n uɛalṭar, maḥend ad zzaysen t arbun. Igga i-t s tfeřwin ak-d řxawi di daxeř nsent. ");
INSERT INTO rifl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Igga tabanyut n nnḥas s uḍar nnes n nnḥas zi tisitin n terbiɛin n temɣarin nni xedment ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Igga řemraḥ. Ɣar jjihet n ljanub, ɣar yefus, tuɣa tuzzeggart n řizarat n řemraḥ mya n iɣaǧen n řeqṭen azdad imuden. ");
INSERT INTO rifl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ɛicrin n ipilaren nnes d ɛicrin n tyarsawin nsen tuɣa aten n nnḥas. Tisennarin n ipilaren d iqeḍban nsen i useřqi tuɣa aten n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ɣar uɣezdis n ccamal tuɣa din řizarat s ict n tuzzeggart n mya n iɣaǧen ak-d ɛicrin n ipilaren nsent u ak-d ɛicrin n tyarsawin nsen n nnḥas. Tisennarin n ipilaren d iqeḍban nsen i useřqi tuɣa aten n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ɣar uɣezdis n řɣarb tuɣa din řizarat n xemsin n iɣaǧen ak-d ɛecra n ipilaren nsent d ɛecra n tyarsawin nsen. Tisennarin n ipilaren d iqeḍban nsen i useřqi tuɣa aten n nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ɣar uɣezdis n ccarq, ɣar jjihet n wenqar n tfuct, tuɣa din řizarat n xemsin n iɣaǧen. ");
INSERT INTO rifl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Tuɣa řizarat ɣar ijj n uɣezdis n zzat xemmesṭac n iɣaǧen di tuzzeggart ak-d třata n ipilaren nsent d třata n tyarsawin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ɣar uɣezdis n zzat nneɣni n wadaf n řemraḥ, ɣar uɣezdis-a d uɣezdis nni, tuɣa řizarat daysent xemmesṭac n iɣaǧen di tuzzeggart, ak-d třata n ipilaren nsent d třata n tyarsawin nsen. ");
INSERT INTO rifl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Marra řizarat nni d as dd-innḍen i řemraḥ tuɣa atent n řeqṭen azdad imuden. ");
INSERT INTO rifl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tiyarsawin n ipilaren tuɣa atent n nnḥas d tsennarin n ipilaren d iqeḍban nsen i useřqi tuɣa aten s nnuqart uca takursit x tzeǧifin nsen tuɣa-tt zi nnuqart d marra ipilaren n řemraḥ tuɣa ɣarsen iqeḍban n nnuqart i useřqi. ");
INSERT INTO rifl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Arwaq ɣar wadaf n řemraḥ ggin t d ijj n umudi n uxeyyaḍ s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden. Tuzzeggart nnes tuɣa ɛicrin n iɣaǧen u řuɛřa x marra tiru n řemraḥ xemsa n iɣaǧen, am řizarat n řemraḥ. ");
INSERT INTO rifl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Arebɛa n ipilaren d arebɛa n tyarsawin nsen tuɣa aten s nnḥas d tsennarin nsen s nnuqart uca takursit x tzeǧifin nsen uřa d iqeḍban nsen i useřqi tuɣa aten s nnuqart. ");
INSERT INTO rifl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Marra řewtad n Tzeddiɣt d řemraḥ i d as dd-innḍen tuɣa aten s nnḥas. ");
INSERT INTO rifl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Man aya d min ssuffɣen nitni i Tzeddiɣt, Tazeddiɣt n Cchadet, uca zemmen t s řumur n Musa s tsexxart n Ilawiyyen, s ufus n Itamar, mmis n Harun, akehhan. ");
INSERT INTO rifl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Baṣaliyil mmis n Uri, mmis n Ḥur, zi teqbič n Yahuda, igga marra min d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Tuɣa akides Ahuliyab, mmis n Axisamak, zi teqbič n Dan. Tuɣa-t d aneqqac d bu-ṣṣenɛet, axeyyaḍ n ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen d řeqṭen azdad. ");
INSERT INTO rifl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Marra ureɣ i ssxedmen nitni i řxedmet ɣar marra řxedmet i iggin di Zzawect Iqeddsen, ixs ad yini ureɣ n tewhibin n wenhezzi, tuɣa: tesɛa u-ɛicrin talint u sebɛa-mya u-třatin ciqlu ɛlaḥsab ciqlu iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Nnuqart n yinni ittwaḥesben n tmesmunt tuɣa-tt mya talint d ařef u-sebɛa-mya u-xemsa u-sebɛin ciqlu, ɛlaḥsab ciqlu iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ijj n wezyen i yijj n bnadem, aqa-t d azyen ciqlu ɛlaḥsab min dd-ittawi ciqlu iqeddsen, zi marra wi iɛdun ɣar yinni ittwaḥesben zi ɛicrin n iseggʷusa sennej, d man aya i setta-mya u-teřt-ařaf u-xemsa-mya u-xemsin n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Mya talint n nnuqart nni tuɣa atent ḥima ad zzaysent ssfesyen tyarsawin n Zzawect Iqeddsen d tyarsawin n uřeḥḥaf: mya n tyarsawin zi mya talint, ixs ad yini ict n talint i yict n tyarsa. ");
INSERT INTO rifl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Zeg wařef u-sebɛa-mya u-xemsa u-sebɛin ciqlu igga tisennarin i ipilaren. Iɣeǧef tizeǧifin nsen uca icedd ɣarsen iqeḍban i useřqi. ");
INSERT INTO rifl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Nnḥas n tewhibin n wenhezzi tuɣa-t sebɛin talint d ařfayen u-arebɛa-mya ciqlu. ");
INSERT INTO rifl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","S man aya igga tyarsawin i wadaf n Uqiḍun n Umsagar d uɛalṭar n nnḥas d tracca nnes n nnḥas d marra řeqcuɛ n uɛalṭar ");
INSERT INTO rifl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","d tyarsawin n ipilaren n řemraḥ i d as dd-innḍen d tyarsawin n wadaf n řemraḥ d marra řewtad n Tzeddiɣt d marra řewtad n ipilaren i d as dd-innḍen i řemraḥ. ");
INSERT INTO rifl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ggin ɛawed arruḍ i tsexxart s ufiři adeḥmi d urjuwani d uzeggʷaɣ iḥedqen, ḥima ad zzayes sexxaren ikehhanen di Zzawect Iqeddsen. Ɛawed ggin arruḍ iqeddsen i Harun, am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Igga apalṭu n ukehhan s ifiřan n wureɣ u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden. ");
INSERT INTO rifl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nitni bezzɛen tiřwiḥin n wureɣ uca qessen zzaysent ifiřan, ḥima ad ten xeyyḍen jar ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u jar řeqṭen azdad, d man aya tuɣa d ict n řxedmet am tt ittegg ufennan. ");
INSERT INTO rifl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ggin as tiɣarḍin imseřsaqen uca ssmunen apalṭu ɣar tnayen n ixfawen nnes. ");
INSERT INTO rifl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Taḥezzamt izewwqen i tuɣa ɣar upalṭu nnes, tuɣa teřseq dayes, tedweř d ict akides. Tᵉttwagg tḥezzamt s webrid d ijjen ak-d upalṭu s ifiřan n wureɣ u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Nitni ggin ɛawed iẓra n uniks, inni ittwaṭṭfen di tcuyar n wureɣ, neqcen ten am yijj n wenqac n txadent n ucemmiɛ s ismawen n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Igga i-ten x tɣarḍin n upalṭu, am iẓra n řidaret i ayt n Israil, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Igga tajmect, ict n řxedmet am tt ittegg ufennan, am mammec igga apalṭu, s ifiřan n wureɣ u s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen u s řeqṭen azdad imuden. ");
INSERT INTO rifl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Tuɣa-tt s arebɛa n tɣemmura. Ḍefsen tajmect. Tuɣa tuzzeggart nnes d ijj n wezyen n uɣiř, uca uřa d tiru nnes d ijj n wezyen n uɣiř. Tuɣa iḍfes x tnayen. ");
INSERT INTO rifl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Settfen dayes arebɛa n řeṣfuf n yeẓra: ijj n ṣṣef s yijj n řeɛqiq d azeggwaɣ d ict n tyaqut d yict n smaraxt. D wa d ṣṣef amezwar. ");
INSERT INTO rifl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ṣṣef wiss tnayen s yijj n karbunkel d yijj n ṣaffir aziza d yijj n diamanti. ");
INSERT INTO rifl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ṣṣef wiss třata s yijj n weẓru n yasintu d yijj n axat d yijj umatist. ");
INSERT INTO rifl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ṣṣef wiss arebɛa s yict n texrisulit d yijj n uniks d yijj n yaspis. Tuɣa ttwaṭṭfen di tcuyar nsen n wureɣ. ");
INSERT INTO rifl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Iẓra tuɣa xasen ismawen n ayt n Israil, tenɛac n yeẓra ɛlaḥsab ismawen nsen, s ineqqacen n ijj n ucemmiɛ, kuř aneqqac ak-d yisem nnes i d as dd-yusin. Aqa aten i tenɛac n tqebbař. ");
INSERT INTO rifl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ɣar ixfawen n tejmect ggin tiseddyin s wureɣ iṣfan, tinni imuden am yijj n ufiřu. ");
INSERT INTO rifl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ggin tnayen n tcuyar n wureɣ d tnayen n texrazin n wureɣ uca cedden tnayen n texrazin ɣar tnayen n ixfawen n tejmect. ");
INSERT INTO rifl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Cedden tnayen n ssnaseř imuden n wureɣ ɣar tnayen n texrazin ɣar ixfawen n tejmect. ");
INSERT INTO rifl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Tnayen n ixfawen nneɣni n tnayen n ssnaseř imuden, cedden ten ɣar tnayen n tcuyar uca wcin ten x ṭɣarḍin n upalṭu, deg wudem n zzat. ");
INSERT INTO rifl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ggin ɛawed tnayen n texrazin n wureɣ, cedden tent ɣar tnayen n ixfawen nneɣni n tejmect, di tma nnes nni qibač i upalṭu, ɣar daxeř. ");
INSERT INTO rifl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ggin ɛawed tnayen n texrazin n wureɣ, cedden tent x tnayen n tɣarḍin n upalṭu n ukehhan, swadday, ɣar zzat, qibač i useřqi nnes ɣar sennej i tḥezzamt izewwqen n upalṭu. ");
INSERT INTO rifl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Uca cedden tajmect s texrazin nnes ɣar texrazin n upalṭu n ukehhan ak-d ijj n ufiřu adeḥmi ařami idweř sennej i tḥezzamt izewwqen n upalṭu, uca xenni war tbeṭṭi tejmect x upalṭu, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Igga ɛawed aseřham n upalṭu n ukehhan am mammec t ittegg uxeyyaḍ, tuɣa-t d adeḥmi marra. ");
INSERT INTO rifl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Arzam n useřham tuɣa-t di řwesṭ nnes am mammec ggin arzam n yiri n warruḍ n wuzzař n uɛeskari. Deg wenneḍ n warzam tuɣa din ict n tma, ḥima war ittcarrig. ");
INSERT INTO rifl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ɣar tmuwwa n wadday n useřham ggin tiremmanin s ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen zeg ifiřan imuden. ");
INSERT INTO rifl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ggin ɛawed nnwaqes n wureɣ iṣfan uca ssarsen nnwaqes nni jar tremmanin ɣar tmuwwa n wadday n useřham, deg wenneḍ jar tremmanin. ");
INSERT INTO rifl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ijj n nnaqus d ict n tremmant, xenni ɛawed ijj n nnaqus d ict n tremmant ɣar tmuwwa n wadday n useřham deg wenneḍ, maḥend ad dayes ggen tasexxart nsen, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ggin tcamir i Harun d warraw nnes s řeqṭen azdad, am mammec t ittegg uxeyyaḍ, ");
INSERT INTO rifl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","areẓẓet n řeqṭen azdad d tcuccay izewwqen n řeqṭen azdad d ssraweř n řeqṭen s řeqṭen azdad imuden ");
INSERT INTO rifl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","u tuɣa taḥezzamt n řeqṭen azdad imuden u n ufiřu adeḥmi d urjuwani d uzeggʷaɣ iḥedqen, aqa-tt d ijj n umudi n uxeyyaḍ, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ggin tařwiḥt s nnuwar n ttaj iqeddsen n weɛzař s wureɣ iṣfan uca neqcen dayes tira-ya: “AMQEDDAS i SIDI!”, am mammec neqcen taxadent n ucemmiɛ. ");
INSERT INTO rifl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Uca cedden as ijj n ufiřu imuden adeḥmi, ḥima ad tt ayřen sennej i areẓẓet, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ammu i tkemmeř marra řxedmet n Tzeddiɣt, Aqiḍun n Umsagar. Ayt n Israil aqa ggin tt am mammec yumur SIDI i Musa, ammu i tt ggin. ");
INSERT INTO rifl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ksin Tazeddiɣt ɣar Musa, Aqiḍun d marra řeqcuɛ nnes d tsennarin nnes d tfeřwin nnes d tḥenya nnes n uɛarreḍ d ipilaren nnes d tyarsawin nnes ");
INSERT INTO rifl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","d tseqqaft n iřmawen izeggʷaɣen n icarriyyen d tseqqaft n iřmawen n ddenfiřat d uřeḥḥaf i dduri, ");
INSERT INTO rifl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Ttabut n Cchadet d iɛumad nnes i tarebbut d tqebbart n weṣřaḥ ");
INSERT INTO rifl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","d tazewḍa ak-d marra řeqcuɛ nnes d weɣrum n wescan ");
INSERT INTO rifl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","d řqendiř n wureɣ iṣfan d řefnarat nnes - řefnarat nni tuɣa ittxeṣṣa ad ttwasswejdent, d marra řeqcuɛ nnes d zzect i tfawt - ");
INSERT INTO rifl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","d uɛalṭar n wureɣ d zzect i wedhan d řebxur ittfuḥen d arwaq i wadaf n Uqiḍun ");
INSERT INTO rifl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","d uɛalṭar n nnḥas s tracca n nnḥas d iɛumad nnes i tarebbut d marra řeqcuɛ nnes d tbanyut ak-d uḍar nnes ");
INSERT INTO rifl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","d řizarat n řemraḥ ak-d ipilaren nsent d tyarsawin nsen, uřa d arwaq n wadaf n řemraḥ d ifiřan nnes d řewtad nnes d marra řeqcuɛ i tsexxart n Tzeddiɣt, i Uqiḍun n Umsagar ");
INSERT INTO rifl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","uřa d arruḍ i tsexxart, ḥima ad zzayes sexxaren ikehhanen di Zzawect Iqeddsen, arruḍ iqeddsen i ukehhan Harun d arruḍ i warraw nnes, ḥima ad sexxaren d ikehhanen. ");
INSERT INTO rifl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ggin ayt n Israil marra řxedmet am mammec marra i yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ixzar Musa ɣar marra řxedmet uca iẓra belli tᵉttwagg am mammec yumur SIDI, wah, ammu i-tt ggin. Uca ibark i-ten Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Deg wass amezwaru n uyur amezwaru ad tessgeɛɛded Tazeddiɣt, Aqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ad dayes tegged Ttabut n Cchadet uca ad tedřed Ttabut s uřeḥḥaf. ");
INSERT INTO rifl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ad tessidfed tazewḍa uca ad tt tsettfed asettef nnes. Ad tessidfed řqendiř uca ad tessiɣed řefnarat nnes. ");
INSERT INTO rifl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ad tessarsed aɛalṭar n wureɣ i řebxur zzat i Ttabut n Cchadet uca ad tegged arwaq n wadaf zzat n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ad tessarsed aɛalṭar n wecmaḍ zzat i wadaf n Tzeddiɣt, Aqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ad tessarsed tabanyut jar Uqiḍun n Umsagar d uɛalṭar uca ad dayes tegged aman. ");
INSERT INTO rifl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ad tessbedded řemraḥ ɣar marra iɣezdisen nnes uca ad tayřed arwaq n wadaf n řemraḥ. ");
INSERT INTO rifl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ad teksid zzect i wedhan uca ad tdehned Tazeddiɣt d marra min dayes iǧan. Ad tt tessqeddsed ak-d marra řeqcuɛ nnes. Ad tiři nettat d tamqeddast. ");
INSERT INTO rifl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ad tdehned aɛalṭar n wecmaḍ s marra řeqcuɛ nnes. Ad tessqeddsed aɛalṭar. Aɛalṭar ad yiři d amqeddas qaɛ. ");
INSERT INTO rifl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ad tdehned tabanyut d uḍar nnes uca ad tt tessqeddsed. ");
INSERT INTO rifl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ad dd-tessqarrbed Harun d warraw nnes ɣar wadaf n Uqiḍun n Umsagar uca ad ten tessirded s waman. ");
INSERT INTO rifl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ad tessyarḍed i Harun arruḍ iqeddsen uca ad t tdehned uca ad t tessqeddsed, maḥend ad ayi yiři d akehhan i Necc. ");
INSERT INTO rifl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Xenni ad dd-tessqarrbed iḥenjiren nnes uca ad asen tyarḍed tcamirat. ");
INSERT INTO rifl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ad ten tdehned am mammec tdehned babatsen, maḥend ad ayi sexxaren am yikehhanen. Ad yiři wedhan nsen i nitni d ict n tukehhant i řebda i marra jjiřat nsen.” ");
INSERT INTO rifl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Igga Musa marra am mammec yumur SIDI, wah, ammu i t igga. ");
INSERT INTO rifl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Imsar deg uyur amezwaru n useggʷas wiss tnayen, deg wass amezwaru n uyur, aqa ssgeɛɛden Tazeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa issgeɛɛed Tazeddiɣt, issars tiyarsawin nnes, igga daysent tifeřwin, igga xasent tiḥenya n uɛarreḍ tinni xasent iẓwan, uca issbedd ipilaren nnes. ");
INSERT INTO rifl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ibezzeɛ Aqiḍun x Tzeddiɣt uca issars xas taseqqaft n Uqiḍun am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Iksi Cchadet uca issars i-tt daxeř di Ttabut uca icedd iɛumad i tarebbut ɣar Ttabut uca issars taqebbart n weṣřaḥ x Ttabut. ");
INSERT INTO rifl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Issidef Ttabut di Tzeddiɣt uca yuyeř ařeḥḥaf am dduri uca issduriy Ttabut n Cchadet am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Issars tazewḍa deg Uqiḍun n Umsagar, ɣar uɣezdis n ccamal n Tzeddiɣt, ɣar barra n uřeḥḥaf. ");
INSERT INTO rifl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Isettef xas aɣrum zzat i wudem n SIDI, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Issars řqendiř deg Uqiḍun n Umsagar, nican deg urendad n tzewḍa, ɣar jjihet n ljanub n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Issars xas tiftiřin zzat i wudem n SIDI, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Iwca amcan i uɛalṭar n wureɣ deg Uqiḍun n Umsagar zzat i uřeḥḥaf. ");
INSERT INTO rifl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Issbexxar xas řebxur ittfuḥen am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Yuyeř arwaq ɣar wadaf n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Iwca amcan i uɛalṭar n wecmaḍ ɣar wadaf n Tzeddiɣt, Aqiḍun n Umsagar. Issbexxar xas taɣarṣt n wecmaḍ d tewhibt n řɣiǧet, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Issars tabanyut jar Uqiḍun n Umsagar d uɛalṭar. Igga dayes aman i usird. ");
INSERT INTO rifl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa d Harun d warraw nnes ssirden zzayes ifassen d iḍaren nsen. ");
INSERT INTO rifl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Řami tuɣa ttadfen ɣar Uqiḍun n Umsagar u řami dd-ttqarraben ɣar uɛalṭar, ssirden ixef nsen am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ɣar marra iɣezdisen n Tzeddiɣt d uɛalṭar ittwagg as-dd řemraḥ uca yuyeř netta arwaq n wadaf n řemraḥ. Ammu i ikemmeř Musa řxedmet. ");
INSERT INTO rifl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Xenni idřa useynu Aqiḍun n Umsagar uca aɛuǧi n SIDI iccur Tazeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","War izemmar Musa ad yadef ɣar Uqiḍun n Umsagar, minzi aseynu yarsa xas u aɛuǧi n SIDI iccur Tazeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Řami dd-igeɛɛed useynu zi sennej n Tzeddiɣt, fesyen ayt n Israil iqiḍan nsen uca ammu muṭṭyen zeg wemcan ɣar wemcan. ");
INSERT INTO rifl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mařa war dd-igeɛɛed useynu, war fesyen iqiḍan nsen ař ass i di tuɣa ittgeɛɛed. ");
INSERT INTO rifl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Minzi aseynu n SIDI tuɣa yarsa x Tzeddiɣt s uziř uca di ǧiřet tuɣa timessi zzat i tiṭṭawin n marra taddart n Israil deg imuṭṭuyen nsen zeg wemcan ɣar wemcan. ");
INSERT INTO rifl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Iřaɣa i Musa uca issiweř SIDI akides zeg Uqiḍun n Umsagar, inna: ");
INSERT INTO rifl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Siweř ak-d ayt n Israil uca ini asen: ‘Mařa issqarreb ijj n bnadem zzaywem tawhibt i SIDI, xenni ad dd-tessqarrbem tawhibt nwem zi řebhayem, zeg ifunasen d tfunasin niɣ zeg wuǧi. ");
INSERT INTO rifl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Mařa tawhibt nnes d taɣarṣt n wecmaḍ zeg ifunasen d tfunasin, xenni ad dd-issqarreb ijj n uwtem icnan qaɛ. Ad t yiwi ɣar wadaf n Uqiḍun n Umsagar, maḥend ad yaf arḍa zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ad yegg afus nnes x uzeǧif n tɣarṣt n wecmaḍ uca ammu i ɣa tᵉttwaqbeř tɣarṣt s arḍa di ṭṭweɛ nnes, maḥend ad yiři i weṣřaḥ nnes. ");
INSERT INTO rifl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ad iɣarṣ i umeẓyan n ufunas zzat i wudem n SIDI uca arraw n Harun, ikehhanen, ad dd-iwyen idammen, ad zeǧɛen idammen ɣar marra iɣezdisen x uɛalṭar nni iǧan ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ad ikkes tiřmect n tɣarṣt n wecmaḍ uca ad ibḍa afunas d iceǧiqen. ");
INSERT INTO rifl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Arraw n akehhan Harun ad ssarɣen timessi x uɛalṭar uca ad settfen akeccuḍ x tmessi. ");
INSERT INTO rifl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Arraw n Harun, ikehhanen, ad settfen iceǧiqen d uzeǧif d tadunt x ukeccuḍ nni iǧan x tmessi i iǧan x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Netta ad issird adan nnes d iḍaren nnes s waman. Akehhan ad issbexxar man aya marra x uɛalṭar, aqa d taɣarṣt n wecmaḍ, d tawhibt n tmessi, d ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Mařa tawhibt nnes d taɣarṣt n wecmaḍ zeg wuǧi, zeg iḥuřiyyen niɣ zeg iɣayḍen, xenni ittxeṣṣa ad dd-issqarreb awtem icnan qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ad as iɣarṣ zzat i wudem n SIDI ɣar uɣezdis n ccamal n uɛalṭar uca arraw n Harun, ikehhanen, ad zeǧɛen idammen nnes x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ad t ibḍa d iceǧiqen, ak-d azeǧif nnes d tadunt nnes, uca akehhan ad ten isettef x ukeccuḍ nni iǧan x tmessi i iǧan x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ad issird adan nnes d icekraden nnes s waman. Akehhan ad yawi man aya marra u ad t issbexxar x uɛalṭar. Aqa d ict n tɣarṣt n wecmaḍ, ict n tewhibt n tmessi, ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Mařa tawhibt nnes d taɣarṣt n wecmaḍ zeg ijḍaḍ i SIDI, xenni ad yawi tawhibt nnes zi tejlilliḥin niɣ zeg idbiren imeẓyanen. ");
INSERT INTO rifl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Akehhan ad t yawi ɣar uɛalṭar, ad as ikkes azeǧif uca ad t issbexxar x uɛalṭar. Ad iẓemm idammen nnes x uɣezdis n uɛalṭar ");
INSERT INTO rifl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","uca ad as ikkes aseyru ak-d min dayes iqqimen u ad inḍar aya zzat i uɛalṭar ɣar uɣezdis n ccarq x wemcan n iɣɣeḍ n min iqqimen n tadunt ");
INSERT INTO rifl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ad t icarreg ɣar wefriwen, maca war t ibeṭṭi ca qaɛ, uca akehhan ad t issbexxar x uɛalṭar, x ukeccuḍ nni iǧan x tmessi. Aqa d ict n tɣarṣt n wecmaḍ, d ict n tewhibt n tmessi, d ict n řefwaḥet ittfuḥen i SIDI.’” ");
INSERT INTO rifl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Mařa iqeddem ḥed tawhibt n řɣiǧet ɣar SIDI, ad tiři tewhibt nnes n waren azdad uca ad xas iseyyeb zzect uca ad xas issars jjawi. ");
INSERT INTO rifl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ad tt yawi ɣar warraw n Harun, ikehhanen, uca ad zzayes iksi ukehhan ijj n wuru iccur zeg waren azdad nni u zi zzect nni ak-d marra jjawi, uca akehhan ad issbexxar aya x uɛalṭar i řidaret i tewhibt nni, aqa d ict n tewhibt n tmessi d ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Min iqqimen n tewhibt n řɣiǧet ad yiři i Harun u i warraw nnes. Aqa d amqeddas qaɛ zi marra tiwhibin n tmessi n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Mařa tqeddmed tawhibt i iǧan d tawhibt n řɣiǧet darḥen tt di tefqunt, xenni ad tiři d řemsemnat břa antun, ixeǧḍen s zzect, uřa d tiřfaf břa antun ttwadehnent s zzect, marra zeg waren azdad. ");
INSERT INTO rifl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Mařa tawhibt nnec d tawhibt n řɣiǧet ggʷin tt x wexdim, ad tiři n waren azdad ixeǧḍen s zzect, wardayes bu wentun. ");
INSERT INTO rifl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ad ten tarẓed d ifetwiten uca ad xas tseyybed zzect. Aqa-tt d ict n tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Mařa tawhibt nnec d tawhibt n řɣiǧet ggʷin tt di ṭṭajjin, ad tiři tewjed s waren azdad ak-d zzect. ");
INSERT INTO rifl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tawhibt n řɣiǧet i zzaysen iwejden, ad tt tawyed ɣar SIDI. Bnadem ad zzayes dd-iqarreb ɣar ukehhan uca wanita ad tt yawi ɣar uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ad iksi ukehhan zi tewhibt n řɣiǧet ict n řidaret uca ad tt issbexxar x uɛalṭar, aqa d tawhibt n tmessi, d řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Min iqqimen n tewhibt n řɣiǧet ad yiři i Harun u i warraw nnes. Aqa-t d amqeddas qaɛ zi tewhibin n tmessi n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","War iɛeddeř i uřa d ict n tewhibt n řɣiǧet i ɣa tqeddmem i SIDI ad tiři tewjed s wentun. Maɣar zi min ma n wentun d zi min ma tamment war zzayes tessbexxaram ca uřa d ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ad tiwyem tawhibt n usuffeɣ amezwaru n ṣṣabet ɣar SIDI, maca nitni war zemmaren ad ssbexxaren tawhibt-a x uɛalṭar am řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kuř tawhibt n tewhibt n řɣiǧet nnec ad tiři tmeǧḥed s tmeǧaḥṭ. Tameǧaḥt n Řɛahd n AREBBI nnec war tzemmar ad tenqeṣ ɣar tewhibt n řɣiǧet nnec. Ad tqeddmed tameǧaḥt ɣar kuř tawhibt nnec. ");
INSERT INTO rifl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Mařa tiwyed ict n tewhibt n řɣiǧet n tmenzut, ad tiwyed tidrin yiwḍen, tinni ittwafaren x tmessi, ak-d řḥebb aziza ibaryen am tewhibt n řɣiǧet zi tmenzut nnec. ");
INSERT INTO rifl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ad xas tseyybed zzect u ad xas tessarsed jjawi, aqa d tawhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Xenni ad issbexxar ukehhan ijj n wezyen zi řḥebb ibaryen u zi zzect nnes ak-d marra jjawi nnes i xas iǧan am tewhibt n řidaret di man aya. Aqa d tawhibt n tmessi i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Mařa tawhibt nnes d taɣarṣt n řehna, ittxeṣṣa, mařa xenni issqarreb-dd amuddar, ad yiři d awtem niɣ d tawtemt n ifunasen d tfunasin, ad dd-issqarreb ijj n umuddar icnan qaɛ zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ad issars afus nnes x uzeǧif n tewhibt nnes uca ad as iɣarṣ qibač i wadaf n Uqiḍun n Umsagar uca arraw n Harun, ikehhanen, ad zeǧɛen idammen nnes x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Zi tewhibt n řehna ad iqeddem ict tewhibt n tmessi i SIDI, ixs ad yini tadunt i idřin adan d marra tadunt i iǧan x wadan. ");
INSERT INTO rifl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Ad ikkes tnayen n tiẓẓař ak-d tadunt i xasent iǧan ɣar tejɛinna uřa d min yuyřen ɣar tsa u yarsa x tiẓẓař. ");
INSERT INTO rifl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Arraw n Harun ad ssbexxaren aya x uɛalṭar x tɣarṣt n wecmaḍ i iǧan x ukeccuḍ i din iǧan x tmessi. Aqa-t d tawhibt n tmessi, d ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Mařa tawhibt nnes d taɣarṣt n řehna i SIDI, awtem niɣ d tawtemt n wuǧi, xenni ad dd-issqarreb ijj n umudar icnan qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Mařa d uḥuři i dd-issqarreb d taɣarṣt, xenni ad t-i-dd issqarreb zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Netta ad issars afus nnes x uzeǧif n tewhibt nnes uca ad as iɣarṣ zzat i Uqiḍun n Umsagar, uca arraw n Harun ad zeǧɛen idammen nnes x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ad iqeddem tadunt n tɣarṣt n řehna am yict n tewhibt n tmessi i SIDI: marra tanewwart n tadunt nni yudsen abeɛṣuṣ ad tt ikkes, uřa d tadunt i idřin adan d marra tadunt i iǧan x wadan ");
INSERT INTO rifl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","uca ad ikkes uřa d tnayen n tiẓẓař ak-d tadunt i xasent iǧan ɣar tejɛinna d min yuyřen ɣar tsa u yarsa x tiẓẓař. ");
INSERT INTO rifl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Akehhan ad issbexxar aya x uɛalṭar. Aqa d macca, ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Mařa tawhibt nnes d iɣayḍ, xenni ad t-i-dd-issqarreb zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ad issars afus nnes x uzeǧif nnes uca ad as iɣarṣ zzat i Uqiḍun n Umsagar, uca arraw n Harun ad zeǧɛen cwayt n idammen nnes x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ad zzayes iqeddem tawhibt nnes, ixs ad yini tadunt i idřin adan, u marra tadunt i iǧan x wadan, am tewhibt n tmessi i SIDI ");
INSERT INTO rifl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","uca ad ikkes uřa d tnayen n tiẓẓař ak-d tadunt i xasent iǧan ɣar tejɛinna uřa d min yuyřen ɣar tsa u yarsa x tiẓẓař. ");
INSERT INTO rifl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Akehhan ad issbexxar aya x uɛalṭar, aqa d macca n tewhibt n tmessi s ict n řefwaḥet ittfuḥen. Marra tadunt ad tiři i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ta d tawṣeyyet i řebda i marra jjiřat nwem, mani ma i ɣa tzedɣem: marra tadunt d marra idammen war ten ttᵉttem.” ");
INSERT INTO rifl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Siweř ak-d ayt n Israil, ini: ‘Mařa ca n yijjen ixḍa am iweddar x marra tiweṣṣa n SIDI, min war ittxeṣṣi ad ittwagg, u netta ixḍa deg ict zzaysent, xenni ad tiři tmesřact ammu: ");
INSERT INTO rifl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Mařa akehhan amedhun ixḍa, ařami idweř řgens ixḍa, ad dd-issqarreb ijj n ufunas. - ameẓyan icnan qaɛ n ict n tfunast - am tɣarṣt n ddenb i SIDI di ṭṭweɛ n ddenb nnes i igga. ");
INSERT INTO rifl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ad yawi afunas nni ameẓyan ɣar wadaf n Uqiḍun n Umsagar, zzat i wudem n SIDI, uca netta ad issars afus nnes x uzeǧif n ufunas ameẓyan uca ad as iɣarṣ i ufunas ameẓyan zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Xenni akehhan amedhun ad iksi ca zeg idammen n ufunas ameẓyan uca ad t yawi ɣar Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ad issuf ukehhan aḍaḍ nnes deg idammen uca ad irucc ca zeg idammen nni sebɛa n twařawin zzat i wudem n SIDI, zzat i uřeḥḥaf n Zzawect Iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ad igg ukehhan cwayt n idammen x waccawen n uɛalṭar i řebxur ittfuḥen i din zzat i wudem n SIDI deg Uqiḍun n Umsagar. Netta ad ifarreɣ marra idammen i iqqimen n ufunas ameẓyan ɣar uḍar n uɛalṭar n wecmaḍ ɣar wadaf n Uqiḍun n Umsagar.    ");
INSERT INTO rifl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ad ikkes marra tadunt n ufunas ameẓyan n tɣarṣt: tadunt i idřin adan d marra tadunt i iǧan x wadan    ");
INSERT INTO rifl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","uca ad ikkes tnayen n tiẓẓař ak-d tadunt i xasent iǧan ɣar tejɛinna uřa d min yuyřen ɣar tsa u yarsa x tiẓẓař, ");
INSERT INTO rifl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","am mammec ikkes man aya x ufunas n tɣarṣi n řehna, uca akehhan ad issbexxar aya x uɛalṭar n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Iřem n ufunas ameẓyan d marra aysum nnes ak-d uzeǧif d icekrad nnes d wadan nnes d umessař nnes i dayes, ");
INSERT INTO rifl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","aqa marra afunas ameẓyan ad t issuffeɣ barra i řmargeḥ n řɛeskar ɣar ijj n wemcan iṣfa mani tteggen iɣɣeḍ i iqqimen n tadunt uca ad t issecmeḍ s tmessi x ukeccuḍ. Ad t cemḍen mani zeǧɛen iɣɣeḍ. ");
INSERT INTO rifl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Mařa teffeɣ tmesmunt n Israil marra zeg webrid uca teffar tmesřact x tiṭṭawin n wegraw n řgens, uca nitni ggin ict n řḥajjet nni iffɣen x marra tiweṣṣa n SIDI, zi jjihet n min war ittxeṣṣi ad yegg, uca idweř daysen umarwas, ");
INSERT INTO rifl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","uca iban-dd ddenb i zi iffɣen x webrid n řumurat, xenni ad dd-issqarreb wegraw n řgens ijj n ufunas - ameẓyan n tfunast - d taɣarṣt i ddenb, uca ad t awyen zzat i Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Imɣaren n tmesmunt ad ssarsen ifassen nsen x uzeǧif n ufunas ameẓyan zzat i wudem n SIDI uca netta ad as iɣarṣ i ufunas nni ameẓyan zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Akehhan amedhun ad yawi cwayt zeg idammen n ufunas ameẓyan ɣar Uqiḍun n Umsagar, ");
INSERT INTO rifl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","uca ad issuf ukehhan aḍaḍ nnes deg idammen uca ad irucc s idammen nni sebɛa n twařawin zzat i wudem n SIDI, zzat i uřeḥḥaf. ");
INSERT INTO rifl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Netta ad igg cwayt zeg idammen nni x waccawen n uɛalṭar nni iǧan zzat i wudem n SIDI deg Uqiḍun n Umsagar. Xenni ad ifarreɣ marra idammen iceṭṭen ɣar uḍar n uɛalṭar n wecmad i din zzat i wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ad xas ikkes marra tadunt uca ad tt issbexxar x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Uca ad igg s ufunas ameẓyan am mammec igga s ufunas ameẓyan n tɣarṣt n ddenb, ammu i ɣa yegg. Akehhan ad xasen igg aṣřaḥ uca ad asen ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Xenni ad issuffeɣ afunas ameẓyan barra i řmargeḥ n řɛeskar uca ad t issecmeḍ am mammec issecmeḍ afunas amezwaru. Aqa-tt d taɣarṣt n ddenb n wegraw n řgens. ");
INSERT INTO rifl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Mařa ijj n řḥakem ixḍa, uca s uweddar igga ict n řḥajjet nni itteffɣen x webrid n marra tiweṣṣa n SIDI, AREBBI nnes, i war ittcuwwaren ad ittwagg, uca idweř dayes umarwas, ");
INSERT INTO rifl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","niɣ mařa ittwassargeb as uxeṭṭu nnes i igga ḍidd i řumur, ad tiři tewhibt nnes, tenni i ɣa iqeddem, d ijj n umyan zeg iɣayḍen, ijj n wewtem icnan qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ad issars afus nnes x uzeǧif n umyan uca ad as iɣarṣ deg wemcan mani ɣarṣen i taɣarṣt n wecmaḍ zzat i wudem n SIDI. Aqa d taɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Xenni ad iksi ukehhan s uḍaḍ nnes cwayt zeg idammen n tɣarṣt n ddenb uca ad ten igg x waccawen n uɛalṭar n wecmaḍ uca xenni ad ifarreɣ idammen iceṭṭen ɣar uḍar n uɛalṭar n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ad issbexxar marra tadunt nnes x uɛalṭar, am mammec d as igga i tadunt n tɣarṣt n řehna. Akehhan ad xas igg aṣřaḥ di ṭṭweɛ n ddenb nnes uca ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Mařa ijjen bnadem zi řgens n temmurt ixḍa s uweddar am igga mɣir ict n řḥajjet nni itteffɣen x icten n tweṣṣa n SIDI, min war ittcuwwar ad ittwagg, uca idweř dayes umarwas, ");
INSERT INTO rifl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","niɣ ittwassargeb as uxeṭṭu nnes i igga, xenni ad tiři tewhibt nnes nni i ɣa iqeddem d ict n tɣayḍet, ict n tewtemt icnan qaɛ, d taɣarṣt x ddenb i igga. ");
INSERT INTO rifl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ad issars afus nnes x uzeǧif n tɣarṣt n ddenb uca ad as iɣarṣ i tɣarṣt n ddenb deg wemcan n tɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Xenni ad iksi ukehhan s uḍaḍ nnes cwayt zeg idammen uca ad t igg ɣar waccawen n uɛalṭar n tɣarṣt n wecmaḍ uca ad ifarreɣ marra idammen iceṭṭen ɣar uḍar n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ad xas ikkes marra tadunt nnes am mammec kksen tadunt n tɣarṣt n řehna uca akehhan ad tt issbexxar x uɛalṭar, ad tiři d ict n řefwaḥet ittfuḥen i SIDI. Uca akehhan ad xas igg aṣřaḥ uca ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Mařa iqeddem ijj n izmar d tawhibt i tɣarṣt n ddenb, xenni ad iqeddem ict n tawtemt icnan qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ad issars afus nnes x uzeǧif n tɣarṣt n ddenb uca ad as iɣarṣ i tɣarṣt n ddenb deg wemcan mani ɣarṣen i tɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Xenni ad iksi ukehhan s uḍaḍ nnes cwayt zeg idammen n tɣarṣt n ddenb uca ad t igg x waccawen n uɛalṭar n wecmaḍ uca ad ifarreɣ marra idammen nnes iceṭṭen ɣar uḍar n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ad xas ikkes marra tadunt nnes, am mammec ikkes tadunt n uḥuři n tɣarṣt n řehna, uca akehhan ad tt issbexxar x uɛalṭar, x tewhibin n tmessi i SIDI uca akehhan ad xas igg aṣřaḥ x ddenb i igga, uca ad as ittwaɣfar.’” ");
INSERT INTO rifl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Mařa ixḍa ḥed umi isřa ahejji n ict n nneɛřet uca netta d acehhad xas, niɣ iẓra i-t niɣ issen i-t: mařa war xas iqqar walu, xenni ad yarbu řmuɛṣiyyet nnes. ");
INSERT INTO rifl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Niɣ mařa iḥada ḥed min ma zi tmesřact ixemjen, řxecbet n řmař ixmej, niɣ řxecbet n řebhimet ixemjen, niɣ řxecbet n umuddar ixmej ittbuɛen, uca netta war issin aya, aqa ixmej u dayes amarwas. ");
INSERT INTO rifl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Niɣ mařa iḥada ca n řexmej n bnadem, min ma zi řexmej nnes i zi idweř netta ixmej, mařa tennuffar xas uca issen it awarni as, aqa dayes amarwas. ");
INSERT INTO rifl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Niɣ mařa iẓẓuǧ ḥed s tcarfayeḥ nnes, maḥend ad igg řɣar niɣ ad igg řxar, niɣ min ma izemmar bnadem ad inṭeq amenni waha s ict n tjaǧit, am war tt issin, maca issen i-t awarni man aya, aqa dayes amarwas di ssibbet n ict zi tmesřayin-a. ");
INSERT INTO rifl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Xenni ad imsar, mařa dayes amarwas di ssibbet n icten zi tmesřayin-a, ad inɛem x min tuɣa ixḍa. ");
INSERT INTO rifl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","X ddenb i igga, ittxeṣṣa as ad iqeddem ict n tewtemt n wuǧi d taɣarṣt n umarwas, ict n texsi niɣ ict n tɣayḍet, d taɣarṣt n ddenb i SIDI, uca akehhan ad xas igg aṣřaḥ di ssibbet n ddenb nnes. ");
INSERT INTO rifl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Maca mařa afus nnes war ɣares min iqedden i yijj zeg wuǧi, xenni ad yawi i SIDI i tɣarṣt n umarwas x ddenb i igga, tnayen n tejlilliḥin niɣ tnayen n idbiren imeẓyanen, ijjen i tɣarṣt n ddenb u ijjen i tɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ad ten yawi ɣar ukehhan, wenni dd ɣa yawyen d amezwaru tajlilliḥt niɣ aḍbir i iǧan i tɣarṣt n ddenb uca ad ikkes azeǧif nnes zi cwayt awarni yiri nnes, maca war t ibeṭṭi marra. ");
INSERT INTO rifl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ad irucc cwayt n idammen ɣar uɣezdis n uɛalṭar uca min iceṭṭen zeg idammen, ad t iẓemm ɣar uḍar n uɛalṭar. Aqa-tt d taɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ad issewjed ameddar nneɣni am tɣarṣt n wecmaḍ ɛlaḥsab lfariḍa uca ammu i xas i ɣa yegg ukehhan aṣřaḥ x ddenb nnes i igga uca ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Mařa afus nnes war ɣares min iqedden i tnayen n tejlilliḥin niɣ i tnayen n idbiren imeẓyanen, xenni wenni ixḍan, ad yawi am tewhibt nnes taɛcart n ijj n ifa n waren azdad d tawhibt n ddenb. War xas ittegg zzect uřa war xas issrusi jjawi, minzi aqa-tt d taɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ad tt yawi ɣar ukehhan uca akehhan ad zzayes iksi ijj n wuru iccur uca ad issbexxar aya am řidaret dayes x uɛalṭar, x tewhibin n tmessi i SIDI. Aqa-tt d taɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ammu i xas ɣa yegg ukehhan aṣřaḥ x ddenb nnes nni igga zi jjihet n icten zi tmesřayin-a uca ad as ittwaɣfar. Min iceṭṭen ad yiři i ikehhanen am mammec i yeǧan ak-d tewhibt n řɣiǧet.” ");
INSERT INTO rifl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Mařa igga ḥed s řeɣdar uca ixḍa s uweddar di tmesřayin iqeddsen n SIDI, ittxeṣṣa ad yawi icarri icnan qaɛ zeg wuǧi d taɣarṣt n umarwas i SIDI. Ad tiři řqimet nnes ɛlaḥsab řqimet i tqeddared cek deg iciqluten n nnuqart ɛlaḥsab ciqlu n Zzawect Iqeddsen. Aqa d taɣarṣt n umarwas. ");
INSERT INTO rifl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Zi tmesřayin iqeddsen ad yarr di min di ixḍa qbeř, uca ad dayes yarni řexmus. Uca ad iwc man aya i ukehhan uca akehhan ad t isseṣřeḥ s icarri n tɣarṣt n umarwas uca ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Mařa ixḍa ḥed uca igga ict n tmesřact i war tᵉttcuwwar ad tᵉttwagg, am dd-iffeɣ deg ict n tmesřact zi tweṣṣa n SIDI, uca tuɣa tnuffar xas, ad dayes yiři umarwas uca ad yarbu řmuɛṣiyyet nnes. ");
INSERT INTO rifl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ad yawi ijj n icarri icnan qaɛ zeg wuǧi ɣar ukehhan i tɣarṣt n umarwas, ad tiři řqimet nnes ɛlaḥsab řqimet i tqeddared cek uca ad t isseṣřeḥ ukehhan x uweddar nnes i di iweddar am war t issin uca ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Aqa d taɣarṣt n umarwas. S tidett tuɣa dayes amarwas zzat i SIDI.” ");
INSERT INTO rifl_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","“Mařa ixḍa ḥed uca iɣdar SIDI am issxarriq x jjar nnes x min d as immewcen, maḥend ad t iḥḍa, niɣ x min ijja deg ufus nnes, niɣ x min xas yucaren, niɣ x ca n ubeɛɛej i igga i jjar nnes, ");
INSERT INTO rifl_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","niɣ am issxarriq x ca min iweddaren i ca n yijjen u ittwaf zzayes uca xenni netta ijjuǧ ẓur, wah, am issxarriq netta x icten zi marra timesřayin nni ittegg bnadem ařami ixeṭṭa s man aya, ");
INSERT INTO rifl_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","xenni ittxeṣṣa, umi ixḍa uca idweř dayes umarwas, aqa netta ad dd-yarr tuceffart nni yucar, niɣ min ittwakksen nni iksi netta s uɣiř, niɣ min tuɣa iḥḍa nni d as immewcen maḥend ad tt iḥḍa, niɣ min iweddaren nni yufa. ");
INSERT INTO rifl_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Uca marra min xef ijjuǧ ẓur, ad dd-yarr řqimet nnes tmun uca ad yarni řexmus. Netta ad t iwc i wenni umi dd-tusa deg wass n tɣarṣt nnes n umarwas. ");
INSERT INTO rifl_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Netta ad yawi taɣarṣt nnes n umarwas ɣar SIDI, ijj n icarri icnan qaɛ zeg wuǧi, wenni řqimet nnes ad tiři ɛlaḥsab řqimet i tqeddared cek, ad tiři d taɣarṣt n umarwas, uca ad t yawi ɣar ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Xenni akehhan ad xas igg asřaḥ zzat i wudem n SIDI uca ad as ittwaɣfar x min igga, mařa idweř dayes amarwas s ict n tmesřact zi marra timesřayin-a.” ");
INSERT INTO rifl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Umur Harun d warraw nnes, ini asen: ‘Wa d azerf i tɣarṣt n wecmaḍ. Taɣarṣt n wecmaḍ x ukeccuḍ x uɛalṭar ad teqqim tareqq ǧiřet tekmeř ař ṣṣbeḥ u ittxeṣṣa timessi n uɛalṭar ad teqqim ad tecmeḍ dayes. ");
INSERT INTO rifl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Akehhan ad yarḍ aseřham nnes n řeqṭen, ad ibyes ssarwař nnes n řeqṭen x arrimet nnes, uca ad iksi iɣɣeḍ n min iqqimen n tadunt n tɣarṣt n wecmaḍ, tenni tecca tmessi, uca ad t issars zzat i uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Xenni ad ikkes arruḍ nnes uca ad yarḍ arruḍ nneɣni, ad yawi iɣɣeḍ n min iqqimen n tadunt barra i řmargeḥ n řɛeskar ɣar yijj n wemcan iṣfa. ");
INSERT INTO rifl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ittxeṣṣa ad teqqim tmessi tareqq x uɛalṭar, ittxeṣṣa war txessi ca. Akehhan ad xas issarɣ akeccuḍ kuř ṣṣbeḥ uca ad xas isettef taɣarṣt n wecmaḍ uca ad xas issbexxar tadunt n tɣarṣa n řehna. ");
INSERT INTO rifl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Timessi x uɛalṭar ad teqqim tareqq řebda, war txessi.’” ");
INSERT INTO rifl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","“Wa d azerf i tewhibt n řɣiǧet. Arraw n Harun ad tt awyen zzat i wudem n SIDI zzat i uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Netta ad zzayes iksi ijj n wuru zeg waren azdad n tewhibt n řɣiǧet ak-d ca n zzect nnes d marra jjawi i iǧan x tewhibt n řɣiǧet. Ad issbexxar aya x uɛalṭar. Aqa d ict n řefwaḥet ittfuḥen, ict n řidaret dayes i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Harun d warraw nnes ad ccen min zzayes iceṭṭen. Ittxeṣṣa ad t ccen břa antun deg wemcan amqeddas. Ad t ccen di řemraḥ n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","War iɛeddeř ad t ggʷen s wentun. Ta d taɣarṣt nsen nni wciɣ Necc zi tewhibin inu n tmessi. Aqa-tt d tamqeddast qaɛ am tɣarṣt n ddenb d tɣarṣt n umarwas. ");
INSERT INTO rifl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Marra iwetman jar warraw n Harun ad zzayes ccen. Aqa-tt d ict n tewṣeyyet i řebda x tewhibin n tmessi n SIDI i marra jjiřat nwem. Marra wi tt ɣa iḥadan, ad ittwaqeddes.” ");
INSERT INTO rifl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","“Ta d tawhibt n Harun d warraw nnes i zi dd ɣa qarrben ɣar SIDI deg wass min di i ɣa ittwadhen Harun: taɛcart n ijj n ifa n waren azdad am ict n tewhibt n řɣiǧet i řebda, azyen nnes di ṣṣbeḥ d wezyen nnes nneɣni ɣar uɛecci. ");
INSERT INTO rifl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Deg ijj n uxdim ad tessewjed aya s zzect n zzitun uca ad t tawyed d tawhibt awarni t txeǧḍed. Ad tqeddmed iřeqqwaz ttwarẓan n tewhibt n řɣiǧet am ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Akehhan nni ɣa dehnen deg wemcan nnes zeg iḥenjiren nnes, ad tt issewjed. Aqa-tt d tawṣeyyet i řebda. Tawhibt-a ad tᵉttwabexxar i SIDI marra. ");
INSERT INTO rifl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Marra tawhibt n řɣiǧet n ukehhan ad tiři tekmeř. War zzayes ttᵉtten ca.” ");
INSERT INTO rifl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","“Siweř ak-d Harun d warraw nnes, ini asen: ‘Wa d azerf i tɣarṣt n ddenb: deg wemcan mani tᵉttwaɣarṣ taɣarṣt n wecmaḍ, ad tᵉttwaɣarṣ ɛawed taɣarṣt n ddenb zzat i wudem n SIDI. Aqa-tt d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Akehhan nni tt ɣa iqeddmen d taɣarṣt ad zzayes yecc. Ittxeṣṣa ad tᵉttwacc deg ijj n wemcan amqeddas di řemraḥ n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Marra wi ɣa iḥadan aysum nnes ad zzayes ittwaqeddes. Mařa ingez cwayt zeg idammen x yijj n warruḍ, xenni ittxeṣṣa ad tessirded min xas ibeqqḍen deg ijj n wemcan amqeddas. ");
INSERT INTO rifl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Uca řqecɛet n třaxt i di tt ssnennan, ad tᵉttwarẓ, maca mařa ssenwen tt deg ict n řqecɛet n nnḥas, xenni ittxeṣṣa ad ḥekken u ad ssřiřen řqecɛet s waman. ");
INSERT INTO rifl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Marra wi iǧan d awtem jar ikehhanen ad zzayes yecc. Aqa-tt d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Maca uřa d ict n tɣarṣt n ddenb i zi ttwaqeddmen idammen nnes deg Uqiḍun n Umsagar, maḥend ad iřin i weṣřaḥ di Zzawect Iqeddsen, war zzayes ittwacc ca. Ad tᵉttwacmeḍ s tmessi.’” ");
INSERT INTO rifl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Wa d azerf i tɣarṣt n umwarwas. Aqa d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Deg wemcan mani ɣarrṣen i tɣarṣt n wecmaḍ, ad ɣarṣen i tɣarṣt n umarwas. Ad izeǧeɛ idammen nnes x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ad yawi marra tadunt nnes: anewwar n tadunt d tadunt nni idřin adan, ");
INSERT INTO rifl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","uca ad ikkes tnayen n tiẓẓař ak-d tadunt i xasent iǧan ɣar tejɛinna, uřa d min yuyřen ɣar tsa uca yarsa x tiẓẓař, ");
INSERT INTO rifl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","uca akehhan ad issbexxar aya x uɛalṭar am yict n tewhibt n tmessi i SIDI. Aqa-tt d taɣarṣt n umarwas. ");
INSERT INTO rifl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Marra awtem jar ikehhanen ad zzayes yecc. Ad ittwacc deg ijj n wemcan amqeddas, aqa-tt d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ad yiři ijj n uzerf am i tɣarṣt n ddenb am i tɣarṣt n umwarwas. Ad yiři weysum n tɣarṣt i ukehhan, wenni tuɣa zzayes igg aṣřaḥ x ca n yijjen. ");
INSERT INTO rifl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Akehhan nni i ɣa iqeddmen taɣarṣt n wecmaḍ n ca n ijjen, i ukehhan nni ad tiři teřmect n tɣarṣt n tmessi nni dd-iqeddem, tiřmect ad tiři i netta. ");
INSERT INTO rifl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kuř tawhibt n řɣiǧet nni ḍarrḥen nitni di tefqunt uřa d marra min ittwasswejden di ṭṭajjin niɣ deg wexdim, d man aya ad yiři i ukehhan nni t iqeddmen, ad yiři i netta. ");
INSERT INTO rifl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kuř tawhibt n řɣiǧet i ittwaxeǧḍen s zzect n zzitun niɣ yuẓɣen, ad tiři i marra arraw n Harun, am i yijj am i wenneɣni.” ");
INSERT INTO rifl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Wa d azerf i tɣarṣt n řehna tenni i ɣa iqeddem bnadem i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Mařa ad tt iqeddem i uqadi, xenni ad iqeddem ak-d tewhibt n uqadi uřa d řemsemnat břa antun ixeǧḍen s zzect d teřfaf břa antun ttwadehnent s zzect d řemsemnat n waren azdad ttwaxeǧḍent s zzect. ");
INSERT INTO rifl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ad iqeddem tawhibt nnes ak-d řemsemnat n weɣrum s wentun, jmiɛ ak-d tewhibt n uqadi, tenni iǧan zi tewhibin nnes n řehna. ");
INSERT INTO rifl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Zi kuř ddarb n tawhibt ad iqeddem icten zzayes am tewhibt n usgeɛɛed i SIDI. Ad tiři i ukehhan nni i ɣa izeǧɛen idammen n tɣarṣa n řehna x uɛalṭar ɣar marra iɣezdisen nnes, ad tiři i netta. ");
INSERT INTO rifl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Aysum n tewhibt n uqadi, tenni iǧan zi tewhibin nnes n řehna, ad ittwacc deg wass i di ɣa iqeddem tawhibt nnes. War ittejji zzayes walu ař ṣṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Mařa tawhibt nnes tusa-dd ak-d ijj n lwaɛd niɣ teǧa d ict n tewhibt s řxaḍar, ad tᵉttwacc deg wass i di i ɣa iqeddem taɣarṣt nnes uca min zzayes iceṭṭen ad ittwacc deg wass i-t-i-dd-iḍfaren. ");
INSERT INTO rifl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Min iceṭṭen ɛad zeg weysum n tɣarṣt ad ittwacmeḍ s tmessi deg wass wiss třata. ");
INSERT INTO rifl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Mařa ittwacc ɛad zeg weysum n tɣarṣt nnes n řehna deg wass wiss třata, xenni wenni tt iqeddmen war ittiři i arḍa n SIDI u taɣarṣt nnes war d as tᵉttwiḥsib ca d taɣarṣt n řehna. Ad tiři d ict n jjɛifect uca wenni zzayes ɣa iccen ad yarbu řmuɛṣiyyet nnes. ");
INSERT INTO rifl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Aysum nni iḥadan ca n tmesřact ixemjen, war zzayes ttᵉttem. Ad t sscemḍen s tmessi. Zi min iceṭṭen n weysum, izemmar ad zzayes yecc marra wenni izedgen. ");
INSERT INTO rifl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","D wenni i ɣa iccen zeg weysum n tɣarṣt n řehna, tenni iǧan i SIDI, am xas yarsa řexmej nnes, řeɛmar nni ad ittwaqess zi řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mařa iḥada ḥed ca n tmesřact ixmej, amecnaw řexmej n bnadem niɣ řexmej n yict n řebhimet ixemjen niɣ ca n tmesřact i iǧan d nnɛi n řexmej, uca xenni ad yecc zeg weysum n tɣarṣin n řehna i SIDI, řeɛmar nni ad ittwaqess zi řgens nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Siweř ak-d ayt n Israil, ini: ‘Kenniw war ttᵉttem ca qaɛ tadunt n ufunas niɣ n izmar niɣ n iɣayḍ. ");
INSERT INTO rifl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Tadunt n ict n řxecbet d tadunt n ijj n umuddar mezzqen t, tɛeddeř ad tᵉttwagg i mammec ma tegga řxedmet, maca kenniw war zzayes ttᵉttem walu. ");
INSERT INTO rifl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Man wen i ɣa iccen tadunt n yict n řebhimet i zi dd ɣa ssqarrben ict n tewhibt n tmessi i SIDI, řeɛmar nni zzayes i ɣa iccen, ad ittwaqess zi řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Di marra tizeddiɣin nwem war ttᵉttem uřa d ca zeg idammen, am zeg ijḍaḍ am zi řebhayem. ");
INSERT INTO rifl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kuř ijj n řeɛmar nni i ɣa iccen mɣir ca zeg idammen, řeɛmar nni ad ittwaqess zi řgens nnes.’” ");
INSERT INTO rifl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Siweř ak-d ayt n Israil, ini: ‘Wi i dd ɣa issqarrben tɣarṣt nnes n řehna i SIDI, ad iqeddem tawhibt nnes i SIDI zi tɣarṣt n řehna nnes. ");
INSERT INTO rifl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","S ifassen nnes ad yawi tiwhibin n tmessi zzat i SIDI. Tadunt i iǧan x idmaren ad tt yawi ak-d idmaren nni, maḥend ad tt issenhezz zi ssa ɣar da am yict n tewhibt n wenhezzi zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Akehhan ad issbexxar tadunt x uɛalṭar, maca idmaren ad iřin i Harun d warraw nnes. ");
INSERT INTO rifl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Zi tɣarṣa nwem n řehna ad tqeddmem i ukehhan ɛawed acekrud afusi d tawhibt n usgeɛɛed. ");
INSERT INTO rifl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Acekrud afusi ad yiři d tasɣart n wenni zeg warraw n Harun i ɣa iqeddmen idammen n tɣarṣi n řehna d tadunt nsent. ");
INSERT INTO rifl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Minzi Necc ksiɣ idmaren n wenhezzi d ucekrud i dd-ittwassgeɛɛden d tawhibt zi tɣarṣi n řehna n ayt n Israil u wciɣ ten i ukehhan Harun u i warraw nnes am yict n lfariḍa i řebda, zi jjihet n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ta d tasɣart ittwassdehnen n Harun d tesɣart ittwassdehnen n warraw nnes zi tewhibin n tmessi n SIDI deg wass i ten dd-issqarreb, maḥend ad iřin d ikehhanen i SIDI, ");
INSERT INTO rifl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","tasɣart nni iwca SIDI i ayt n Israil deg wass i ten idhen. Aqa d ict n tewṣeyyet i řebda i marra jjiřat nsen.’” ");
INSERT INTO rifl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Wa d azerf i tɣarṣt n wecmaḍ d tewhibt n řɣiǧet d tɣarṣt n ddenb d tɣarṣt n umarwas d tɣarṣa i udeccen d tɣarṣa n řehna, ");
INSERT INTO rifl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","azerf i iweṣṣa SIDI i Musa deg wedrar n Sina, ass min di iweṣṣa ayt n Israil ad qeddmen tiwhibin nsen i SIDI di řexřa n Sina. ");
INSERT INTO rifl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ksi Harun jmiɛ ak-d warraw nnes d warruḍ d zzect i wedhan d ufunas ameẓyan n tɣarṣt n ddenb d tnayen n icarriyyen d tsuǧet s weɣrum břa antun, ");
INSERT INTO rifl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","u řaɣa i marra tamesmunt ɣar wadaf n Uqiḍun n Umsagar.” ");
INSERT INTO rifl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Igga Musa am mammec d as iweṣṣa SIDI uca tmun tmesmunt ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Inna Musa i tmesmunt: “Wa d min iweṣṣa SIDI ad ittwagg.” ");
INSERT INTO rifl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Musa issqarreb-dd Harun d warraw nnes uca issird i-ten s waman. ");
INSERT INTO rifl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Issars xas tcamir, ibyes as s tḥezzamt, issyarḍ as aseřham. Igga xas apalṭu uca ibyes as s tḥezzamt izewwqen n upalṭu uca iqqen as zzayes apaltu. ");
INSERT INTO rifl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Issemten xas tajmect uca igga iẓra n ‘Urim’ d ‘Tumim’ di tajmect. ");
INSERT INTO rifl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Igga areẓẓet x uzeǧif nnes uca ɣar zzat x areẓẓet igga tařwiḥt s nnuwwar n wureɣ n ttaj iqeddsen n weɛzař, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Xenni iksi Musa zzect i wedhan uca idhen Tazeddiɣt d marra min dayes iǧan uca issqeddes marra aya. ");
INSERT INTO rifl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Irucc zzayes x uɛalṭar sebɛa n twařawin uca idhen ɛawed aɛalṭar d marra řeqcuɛ nnes uřa d tabanyut ak-d uḍar nnes maḥend ad ten issqeddes. ");
INSERT INTO rifl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Iseyyeb zzect i wedhan x uzeǧif n Harun uca idhen i-t, ḥima ad t issqeddes. ");
INSERT INTO rifl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Issqarreb-dd Musa arraw n Harun uca yarḍ asen tcamirat uca ibyes asen s tḥezzamin uca inneḍ asen ticuccay am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Issqarreb-dd afunas ameẓyan n tɣarṣt n ddenb uca Harun d warraw nnes ssarsen ifassen nsen x uzeǧif n ufunas ameẓyan n tɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Iɣarṣ as uca iksi Musa idammen uca igga cwayt zzaysen s uḍaḍ nnes x waccawen n uɛalṭar i iǧan ɣar marra iɣezdisen nnes uca ammu i issizdeg aɛalṭar. Xenni iseyyeb idammen ɣar uḍar n uɛalṭar. Ammu i issqeddes i-t i weṣřaḥ xas. ");
INSERT INTO rifl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Iksi marra tadunt nni iǧan x wadan d min yuyřen ɣar tsa d tnayen n tiẓẓař d tadunt nsent uca Musa issbexxar aya x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Maca afunas ameẓyan d yiřem nnes d weysum nnes d amessař nnes, issarɣ i-ten barra i řmargeḥ n řɛeskar, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Issqarreb-dd Musa icarri n tɣarṣt n wecmaḍ uca Harun d warraw nnes ssarsen ifassen nsen x uzeǧif n icarri. ");
INSERT INTO rifl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Iɣarṣ i icarri uca izeǧeɛ Musa idammen x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ibḍa icarri d iceǧiqen nnes uca issbexxar Musa azeǧif d iceǧiqen d tadunt. ");
INSERT INTO rifl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Issird adan d iḍaren s waman uca issbexxar Musa marra icarri x uɛalṭar, aqa d taɣarṣt n wecmaḍ s yict n řefwaḥet ittfuḥen, aqa d tawhibt n tmessi i SIDI, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Issqarreb-dd xenni icarri nneɣni, icarri i udeccen, uca Harun d warraw nnes ssarsen ifassen nsen x uzeǧif n icarri. ");
INSERT INTO rifl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Uca iɣarṣ as uca iksi Musa cwayt zeg idammen uca igga i-ten x iɣes n umezzuɣ afusi n Harun u x uḍaḍ n yimez n ufus nnes afusi u x uḍaḍ n yimez n uḍar nnes afusi. ");
INSERT INTO rifl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Issqarreb-dd ɛawed arraw n Harun uca igga Musa cwayt zeg idammen x iɣes n umezzuɣ nsen afusi u x uḍaḍ n yimez n ufus nsen afusi u x uḍaḍ n yimez n uḍar nsen afusi uca izeǧeɛ Musa idammen iqqimen x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Iksi tadunt d unewwar s tadunt d marra tadunt tenni iǧan x wadan d min yuyřen ɣar tsa d tnayen n tiẓẓař ak-d tadunt nsent uřa d acekrud afusi. ");
INSERT INTO rifl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Zi tsuǧet s weɣrum břa antun, tenni tuɣa zzat i wudem n SIDI, iksi ijj n řemsemmem břa antun d yict n temsemmemt isswejden s zzect d ict n teřfeft uca issars i-ten x tadunt u x ucekrud afusi. ");
INSERT INTO rifl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Igga marra man aya deg ifassen n Harun u deg ifassen n warraw nnes uca issenhezz aya am yict n tewhibt n wenhezzi zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Awarni as iksi ten Musa ɛawed zeg ifassen nsen uca issbexxar i-ten x uɛalṭar, x tɣarṣt n wecmaḍ. Aqa d tiɣarṣa i udeccen s yict n řefwaḥet ittfuḥen, aqa d tawhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Iksi Musa idmaren uca issenhezz i-ten am yict n tewhibt n wenhezzi zzat i wudem n SIDI. Man aya d tasɣart n ucarri i udeccen, tenni iǧan i Musa, am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Iksi Musa cwayt n zzect i wedhan u n idammen i iǧan x uɛalṭar uca irucc man aya x Harun u x warruḍ nnes, x warraw nnes u x warruḍ n warraw nnes, inni akides iǧan. Ammu i issqeddes Harun d warruḍ nnes d warraw nnes d warruḍ n warraw nnes akides. ");
INSERT INTO rifl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Inna Musa i Harun u i warraw nnes: “Senwem aysum nni ɣar wadaf n Uqiḍun n Umsagar uca teccem t dinni s weɣrum nni iǧan di tsuǧet n tɣarṣa i udeccen, am mammec weṣṣiɣ necc, nniɣ: ‘Harun d warraw nnes ad t ccen.’ ");
INSERT INTO rifl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Min iceṭṭen n weysum d weɣrum, ad t tesscemḍen s tmessi. ");
INSERT INTO rifl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Zeg wadaf n Uqiḍun n Umsagar war zzayes dd-tᵉtteffɣem ca sebɛa n wussan, ař ass min di i ɣa kemmřen wussan n uřeqqem nwem, minzi netta ad kenniw yařeqqem sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Am mammec igga marra deg wass-a, ammu i iweṣṣa SIDI, maḥend ad xawem igg aṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ad teqqimem ɣar wadaf n Uqiḍun n Umsagar, ass d ǧiřet, sebɛa n wussan uca ad tᵉṭṭfem aḥeṭṭu i SIDI, ḥima war tᵉttmettim ca, minzi ammu i t ttweṣṣiɣ necc.” ");
INSERT INTO rifl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Harun d warraw nnes ggin marra min d asen iweṣṣa SIDI s tsexxart n Musa. ");
INSERT INTO rifl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Deg wass wiss tmenya imsar, aqa Musa iřaɣa i Harun d warraw nnes d imɣaren n Israil ");
INSERT INTO rifl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","uca inna i Harun: “Ksi ɣarek ijj n uɛejmi, ameẓyan n ufunas, am tɣarṣt n ddenb, uřa d ijj n icarri am tɣarṣt n wecmaḍ, aqa ad iřin cnan qaɛ, uca ejj i-ten ad dd-qarrben ɣar wudem n SIDI.    ");
INSERT INTO rifl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Siweř ak-d ayt n Israil uca ini: “Ksim ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb u ksi ijj n uɛejmi d ijj n yezmar, aqa ad iřin imuddaren cnan qaɛ n ijj n useggʷas, i tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","uca ksi ɛawed ijj n ufunas d ijj n ucarri am tɣarṣa n řehna, maḥend ad ten qeddmen d ddbiḥet i SIDI, uřa d ict n tewhibt n řɣiǧet ixeǧḍen s zzect, minzi ass-a ad awem dd-iban SIDI.” ");
INSERT INTO rifl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Xenni awyen min xef iweṣṣa Musa ɣar zzat n Uqiḍun n Umsagar uca tamesmunt tqarreb-dd uca bedden nitni zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Uca Musa inna: “D man aya min xef iweṣṣa SIDI maḥend ad t teggem. Uca xenni ad awem dd-iban uɛuǧi n SIDI.” ");
INSERT INTO rifl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Inna Musa i Harun: “Qarreb-dd ɣar uɛalṭar uca sewjed taɣarṣt nnec n ddenb d tɣarṣt nnec n wecmaḍ uca egg aṣřaḥ x yixef nnec u x řgens. Sewjed ɛawed tawhibt n řgens uca egg xasen aṣřaḥ am mammec t iweṣṣa SIDI.” ");
INSERT INTO rifl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Xenni iqarreb-dd Harun ɣar uɛalṭar uca iɣarṣ i uɛejmi n tɣarṣt n ddenb i iǧan i yixef nnes. ");
INSERT INTO rifl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Arraw n Harun iwyen as-dd idammen uca netta issuf aḍaḍ nnes deg idammen uca igga i-ten x waccawen n uɛalṭar. Min iceṭṭen n idammen iseyyeb i-ten ɣar uḍar n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Issbexxar tadunt d tiẓẓař d min yuyřen ɣar tsa n tɣarṣt n ddenb x uɛalṭar am mammec yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Issecmeḍ aysum d yiřem s tmessi barra i řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Iɣarṣ taɣarṣt n wecmaḍ uca arraw n Harun qeddmen as idammen uca netta izeǧeɛ i-ten x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Xenni qeddmen as taɣarṣt n wecmaḍ i ttwabḍan d iceǧiqen, uřa d azeǧif, uca netta issbexxar i-tt x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Issird adan d iḍaren uca issbexxar i-ten x tɣarṣt n wecmaḍ i iǧan x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Awarni as issqarreb-dd tawhibt n řgens. Netta iksi amyan n tɣarṣt n ddenb i řgens uca iɣarṣ as uca issewjed i-t d taɣarṣt n ddenb am mammec issewjed icarri amezwaru. ");
INSERT INTO rifl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Issqarreb-dd taɣarṣt n wecmaḍ uca issewjed i-tt ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Iqeddem tawhibt n řɣiǧet uca iksi zzayes ijj n wuru iccur uca issbexxar aya x uɛalṭar, zzat i tɣarṣt n wecmaḍ n ṣṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Iɣarṣ ɛawed i ufunas u i yicarri n tɣarṣt n řehna di ṭṭweɛ n řgens, uca arraw n Harun qeddmen as idammen uca izeǧeɛ i-ten x uɛalṭar ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","X tadunt n ufunas u n icarri: anewwar s tadunt nnes d min idřin aḍan d tiẓẓař d min yuyřen ɣar tsa, ");
INSERT INTO rifl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","aqa ssarsen tadunt nni x idmaren uca netta issbexxar tadunt x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Maca idmaren d ucekrud afusi issenhezz i-ten Harun amecnaw ict n tewhibt n wenhezzi zzat i wudem n SIDI, am mammec t iweṣṣa Musa. ");
INSERT INTO rifl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Xenni issgeɛɛed Harun ifassen nnes ɣar řgens uca ibarek i-ten uca ihwa awarni řami iqeddem taɣarṣt n ddenb d tɣarṣt n wecmaḍ d tɣarṣt n řehna. ");
INSERT INTO rifl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Uca yudef Musa ak-d Harun ɣar Uqiḍun n Umsagar uca nitni ffɣen zzayes ɛawed uca barken řgens uca iban uɛuǧi n SIDI i marra řgens ");
INSERT INTO rifl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","uca teffeɣ-dd tmessi zi zzat i wudem n SIDI, tecca taɣarṣt n wecmaḍ x uɛalṭar uřa d tadunt. Umi iẓra řgens man aya, sřiweřwen uca wḍan ɣar temmurt x uɣembub nsen. ");
INSERT INTO rifl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadab d Abihu, arraw n Harun, ksin kuř ijj řmejmar nnes uca ggin dayes řebxur uca ammu i yiwyen nitni timessi teɣrib zzat i wudem n SIDI, min war d asen iweṣṣa Netta. ");
INSERT INTO rifl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Teffeɣ-dd tmessi zi zzat i wudem n SIDI, tecc i-ten uca mmuten zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Inna Musa i Harun: “D man aya x min xef issiweř SIDI umi inna: ‘S yinni i ɣari dd ɣa iqarrben ad ttwaqeddseɣ uca zzat i wudem n marra řgens ad ttwassɛuǧeɣ.’” Uca isqar Harun. ");
INSERT INTO rifl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Iřaɣa Musa i Micayil d i Ilṣafan, arraw n Ɛuzziyil, ɛemmis n Harun, uca inna asen: “Qarrbem-dd, tarbum aytmatwem zi qibač n Zzawect Iqeddsen, awyi ten barra i řmargeḥ n řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Qarrben-dd nitni uca arbun ten di tcamirat nsen barra i řmargeḥ n řɛeskar, am mammec t inna Musa. ");
INSERT INTO rifl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Xenni inna Musa i Harun u i Aliɛazar d Itamar, arraw nnes: “War ḍeǧqem i ucuwwaf x izeǧifen nwem niɣ ttcarrgem arruḍ nwem i wecḍan, ḥima war tᵉttmettim uca ad yiři uduqqez n weɣḍab x marra tamesmunt. Maca aytmatwem, marra taddart n Israil, ad run x tmessi-ya, tenni issecmeḍ SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","War dd-tteffɣem ca zi wadaf n Uqiḍun n Umsagar, ḥima war tᵉttmettim ca, minzi zzect n wedhan n SIDI aqa tt xawem.” Uca nitni ṭṭaɛen i wawař n Musa. ");
INSERT INTO rifl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Issiweř SIDI ak-d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“War iɛeddeř ad tsessed binu niɣ ccrab ijehden xmi ɣa tadfem ɣar Uqiḍun n Umsagar, cek lla uřa d iḥenjiren nnec nni akidek lla, ḥima war tᵉttmettim ca. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem, ");
INSERT INTO rifl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ḥima ad af tzemmarem ad tfarzem jar min iǧan iqeddsen d min war iǧin iqeddsen u jar min iṣfan d min war iṣfin, ");
INSERT INTO rifl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","u ḥima ad tessřemdem i ayt n Israil marra tiweṣṣa nni ɣarsen issiweř SIDI s tsexxart n Musa.” ");
INSERT INTO rifl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Uca issiweř Musa ak-d Harun u ak-d Aliɛazar d Itamar, arraw nnes iqqimen: “Ksim tawhibt n řɣiǧet nni iceṭṭen zi tewhibin n tmessi i SIDI uca ccem tt břa antun zzat i uɛalṭar, minzi aqa-tt d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ad tt teccem deg ijj n wemcam iqeddsen, minzi ta d taɣarṣt i cek u i iḥenjiren nnec zi tewhibin n tmessi n SIDI, minzi ammu i d ayi ittwaweṣṣa. ");
INSERT INTO rifl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Deg ijj n wemcan iṣfa ad teccem ɛawed idmaren n wenhezzi d ucekrud n tewhibt i dd-ittwassgeɛɛden, cek d iḥenjiren nnec d tḥenjirin nnec akidek, minzi d man aya d tasɣart nnec d tasɣart n tarwa nnec zi tɣarṣa n řehna n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ad awyen acekrud n tewhibt i dd-ittwassgeɛɛden uřa d idmaren n wenhezzi ak-d tewhibin n tmessi n tadunt, maḥend ad ten ssenhezzen zzat i wudem n SIDI am tewhibt n wenhezzi. Aqa d ict n tewṣeyyet i řebda i cek u i iḥenjiren nnec akidek, am mammec t iweṣṣa SIDI.” ");
INSERT INTO rifl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Uca Musa yarzu s cḍaret x umyan n tɣarṣt n ddenb, maca xzar, icemḍ. Xenni iffugem x Aliɛazar d Itamar, arraw iqqimen n Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Mayemmi war teccim taɣarṣt n ddenb deg wemcan iqeddsen? Minzi aqa-tt d tamqeddast qaɛ uca netta iwca awem tt-i-dd ḥima kenniw ad tarbum řmuɛṣiyyet n tmesmunt, maḥend ad xasen teggem aṣřaḥ zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Xzarem, ḥdam war ssidfen walu zeg idammen daxeř i Zzawect Iqeddsen. Tuɣa ittxeṣṣa kenniw ad tt teccem di Zzawect Iqeddsen am mammec d awem weṣṣiɣ necc.” ");
INSERT INTO rifl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Xenni issiweř Harun ak-d Musa: “Xzar, ass-a aqa qeddmen taɣarṣt n ddenb d tɣarṣt n wecmaḍ zzat i wudem n SIDI. Mařa necc, awarni řami xafi kkent tmesřayin-a, aqa cciɣ zi tɣarṣt n ddenb ass-a, ma xenni man aya icna di tiṭṭawin n SIDI?” ");
INSERT INTO rifl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Umi isřa Musa aya, iban as-dd man aya d lemliḥ di tiṭṭawin nnes. ");
INSERT INTO rifl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Issiweř SIDI ak-d Musa d Harun, inna asen: ");
INSERT INTO rifl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Siweř ak-d ayt n Israil uca inim: ‘Ina aqa aten d řmař, inni umi iɛeddeř ad teccem zi jar marra řmař nni din x temmurt. ");
INSERT INTO rifl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Iɛeddeř ad teccem zi marra řmař i ɣar teǧa tecḍect immsebḍan, aqa farqa n tecḍect imssebḍan qaɛ, u sennej i man aya ttarran ifeẓ. ");
INSERT INTO rifl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Maca zeg inni ittarran ifeẓ d yinni ɣar teǧa tecḍect immsebḍan, war ttᵉttem ina: ařɣem, minzi itteffeẓ, maca war ɣares bu tecḍect immsebḍan, s uyenni aqa ixmej i kenniw, ");
INSERT INTO rifl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","akawka n teṣḍart, minzi ittarra ifeẓ, maca tacḍect war temmsebḍi, u s uyenni aqa ixmej i kenniw, ");
INSERT INTO rifl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","amenni ayarziz, minzi ittarra ifeẓ, maca war ɣares tacḍect immsebḍan, s uyenni aqa ixmej i kenniw, ");
INSERT INTO rifl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ɛaweḍ iřef, minzi ɣares tacḍect immsebḍan uca aqa farqa n tecḍect immsebḍan qaɛ, maca war ittarri ifeẓ, s uyenni aqa ixmej i kenniw. ");
INSERT INTO rifl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Zeg weysum nsen war zzayes ttᵉttem niɣ ad tḥadam řxecbat nsen, aqa xemjen i kenniw.’” ");
INSERT INTO rifl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Ina iɛeddeř ad ten teccem zi jar marra imuddaren nni iddaren deg waman: marra wi ɣar iǧa wafriwen d teqcurt deg waman u di řebḥur u di tɣezratin, ina iɛeddeř ad ten teccem, ");
INSERT INTO rifl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","maca marra wi war ɣar yeǧi ifriwen niɣ taqcurt di řebḥur u di tɣezratin, zi jar marra i zi sseffyen aman uřa zi jar marra min iddaren deg waman, ad awem yiři d nnɛi. ");
INSERT INTO rifl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Wah ad awem yiři d nnɛi. War iɛeddeř ad teccem zeg weysum nsen u řxecbat nsen ad ɣarwem iřint d nnɛi. ");
INSERT INTO rifl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Marra min iǧan deg waman břa ifriwen d teqcurt, ad ɣarwem yiři d nnɛi.” ");
INSERT INTO rifl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Zeg ijḍaḍ ad ɣarwem iřin ina d nnɛi, war zzaysen ttᵉttem ca, aqa aten d nnɛi: agider, isɣi, agider n řebḥar, ");
INSERT INTO rifl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","aceffar iṭṭawen s tazřa, amessɣuy amuqḍiɛ n tiṭṭawin ak-d marra markat nnes, ");
INSERT INTO rifl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","marra markat n ubaɣeř, ");
INSERT INTO rifl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","yeǧis n tɣuyyit, aɛennaf, ajḍiḍ n řebḥar, řbaz ak-d markat nnes, ");
INSERT INTO rifl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","aḥemmař n řkas, bu-tcararrut, bu-usuḍi n řmewt, ");
INSERT INTO rifl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bu-yuntaḥ, bu-uɛuqqi, bu-uḥawar, ");
INSERT INTO rifl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","abellarj, bu-usuḍi iɛeffnen ak-d marra markat nnes, dundun d řweḍwaḍ.” ");
INSERT INTO rifl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Marra wi ɣar iǧa afriwen i ittbuɛen u igguren x arebɛa n iḍaren, ad ɣarwem yiři d nnɛi. ");
INSERT INTO rifl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Maca zi marra inni ittbuɛen am ɣarsen afriwen u gguren x arebɛa n iḍaren, iɛeddeř i kenniw ad teccem inni ɣar iǧa iḍaren i wengaz sennej i iḍaren nsen i tecři, ḥima ad zzaysen negzen x temmurt. ");
INSERT INTO rifl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ina tzemmarem ad zzaysen teccem: tamurɣi n weyřaf ak-d markat nnes, tamuɣri n teṣḍart ak-d markat nnes, tamuɣri ineggzen ak-d markat nnes d tamuɣri iřeḥḥfen ak-d markat nnes. ");
INSERT INTO rifl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Marra wi ɣar iǧa afriwen i ittbuɛen u ɣares arebɛa n iḍaren, ad ɣarwem yiři d nnɛi.” ");
INSERT INTO rifl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“S imuddaren-a i ɣa tᵉttwaxemjem. Marra wi ɣa iḥadan řxecbat nsen, ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Manwen yiwyen ca zi řxecbat nsen, ad issird arruḍ nnes uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Marra řebhayem, inni ɣar teǧa tecḍect immsebḍan i zi farqa n tecḍect war tfarq qaɛ, uřa war ttarran ifeẓ, ad ɣarwem iřin xemjen. Marra wi ten i ɣa iḥadan, ad yiři ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Kuř amuddar jar imuddaren i igguren x arebɛa n třeqqa n iḍaren nsen, ad ɣarwem yiři ixmej. Marra wi ɣa iḥadan řxecbat nsen, ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Wi yiwyen ca n řxecbat nsen, ad issird arruḍ nnes uca ad yiři ixmej ař tmeddit. Ad awem iřin xemjen.” ");
INSERT INTO rifl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Zi jar imuddaren ittbuɛen, inni ittbuɛen x temmurt, d ina ad xawem iřin xemjen i kenniw: ajarbuɛ, aɣerda, icfar ak-d markat nnes, ");
INSERT INTO rifl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","iqqli, taknakart, azermummuy, aḥdiḍ d tata. ");
INSERT INTO rifl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ina ad ɣarwem iřin xemjen zi jar marra imuddaren nni ittbuɛen x temmurt. Marra wi ten i ɣa iḥadan awarni řmewt nsen, ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Marra min xef iwḍa ca zi řxecbat nsen ad yiři ixmej, niɣ ict n řqecɛet n tefřawt, niɣ arruḍ, niɣ tiřmect, niɣ taxancet, niɣ min ma řqecɛet i xef iwḍa ca zzaysent, ittxeṣṣa ad ittwassars deg waman, ad yiři ixmej ař tameddit u awarni aya ad yiři izdig. ");
INSERT INTO rifl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Marra řqecɛet n třaxt, tenni umi di iwḍa cwayt zzayes, aqa marra min dayes iǧan ad yiři ixmej uca ittxeṣṣa i kenniw ad tarẓem ṭṭebṣi. ");
INSERT INTO rifl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Marra macca nni ttnuman iwdan ad ccen, tenni x wḍan waman nni, ad tiři texmej, u marra tissit nni ttnuman iwdan ad swen, mammec ma tegga řqecɛet i di teǧa macca niɣ tissit, ad tiři texmej. ");
INSERT INTO rifl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Marra min xef iwḍa ca n řxecbat nsen, ad yiři ixmej. Afarnu d tzewḍa ad ttwarẓen, aqa xemjen uca ad ɣarwem iřin xemjen. ");
INSERT INTO rifl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Maca řɛunṣar niɣ d anu mani ɣar ssizzřen aman, ad yiři izdeg. Maca wi ɣa iḥadan řxecbat nsen, ad yiři ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Uca mařa iwḍa ca zi řxecbat nsen x ca n zzariɛet i uzarɛ, tenni ittxeṣṣa ɛad ad zarɛen, xenni ad tiři tizdeg. ");
INSERT INTO rifl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Maca mařa seyyben aman x zzariɛet uca iwḍa xas ca zi řxecbat nsen, xenni ad ɣarwem tiři zzariɛet nni texmej. ");
INSERT INTO rifl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Uca mařa immut ijj zi jar řmař nni teccim, xenni wi ɣa iḥaḍan řxecbet nnes, ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Wenni iccen zi řxecbet nnes, ad issird arruḍ nnes uca ad yiři ixmej ař tameddit. Wenni yarbun ca zi řxecbet nnes, ad issird arruḍ nnes uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Kuř amuddar ittbuɛen x temmurt, aqa-t d nnɛi. War iɛeddeř ad ittwacc. ");
INSERT INTO rifl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Zi jar marra imuddaren ittbuɛen, inni ittbuɛen x wudem n temmurt, war ttᵉttem ca marra min igguren x uɛeddis niɣ marra min igguren x arebɛa n iḍaren ař marra min igguren x waṭṭas n iḍaren, minzi aqa aten d nnɛi. ");
INSERT INTO rifl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","War tteggem nnɛi i řeɛmur nwem s marra imuddaren ittbuɛen nni din ittbuɛen x wudem n temmurt, war zzayes ssxemmajem ixef nwem ařami ad zzaysen txemjem. ");
INSERT INTO rifl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Minzi Necc d SIDI, AREBBI nwem. Kenniw ad tessqedsem ixef nwem uca ad tiřim d imqeddasen, minzi Necc aqa d amqeddas. War ssxemmajem řeɛmur nwem s marra immudaren ittbuɛen, inni ittbuɛen x wudem n temmurt. ");
INSERT INTO rifl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Minzi Necc D SIDI, wenni kenniw dd-issgeɛɛden zi temmurt n Miṣra, ḥima ad iřiɣ d AREBBI nwem. Iřim d imqeddasen, maɣar aqa Necc d amqeddas.” ");
INSERT INTO rifl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Wa d azerf x řmař, x ijḍaḍ u x marra imuddaren nni zzaysen issefyen waman uca x marra imuddaren nni ittbuɛen x temmurt, ");
INSERT INTO rifl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ḥima ad ittwagg řfarq jar min ixemjen d min izdigen u jar imuddaren inni iɛeddřen i macca d imuddaren inni war iɛeddřen i macca. ");
INSERT INTO rifl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Siweř ak-d ayt n Israil, ini: ‘Mařa teksi ict n temɣart ddeyset uca turuw-dd aḥenjir, ad tiři texmej sebɛa n wussan. Ad tiři texmej am deg wussan n weɛzař xmi xas idammen. ");
INSERT INTO rifl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Deg wass wiss tmenya ittxeṣṣa ad ittwaxten aysum n řeɛdařyet nnes. ");
INSERT INTO rifl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Awarni man aya ad teqqim třata u-třatin n wussan deg idammen n usizdeg nnes. War tᵉttḥidi walu zi min iǧan iqeddes u war tᵉttraḥ ɣar Zzawect Iqeddsen ař ɣa kemmřen wussan n usizdeg nnes. ");
INSERT INTO rifl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Mařa turuw d taḥenjirt, ad tiři texmej tnayen n ssimanat, am deg wussan n weɛzař nnes. Awarni man aya ad teqqim setta u-settin n wussan deg idammen n usizdeg nnes. ");
INSERT INTO rifl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Xmi ɣa kemmřen wussan n usizdeg n mmis niɣ n yeǧis, xenni ad tawi ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ niɣ ijj n wedbir d ameẓyan niɣ ict n tejlilliḥt am tɣarṣt n ddenb ɣar ukehhan ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","D netta ad yawi man aya zzat i wudem n SIDI uca ad xas igg aṣřaḥ. Xenni ad tiři tizdeg zi řɛunṣar n idammen nnes. Wa d azerf i tenni i ɣa yarwen ijj n mmis niɣ ict n yeǧis. ");
INSERT INTO rifl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mařa war tiwiḍ ad tawi ijj zeg wuǧi, xenni ad tᵉṭṭef tnayen n tejlilliḥin niɣ tnayen n idbiren imeẓyanen, ijj i tɣarṣt n wecmaḍ u ijj i tɣarṣt n ddenb, uca akehhan ad xas igg aṣřaḥ. Xenni ad tiři tizdeg.’” ");
INSERT INTO rifl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Mařa ijj n bnadem ɣares di teřmect n arrimet nnes aɛebbuz niɣ ict n tḥebbuct niɣ ijj n wengaz iccemřeř, uca wanita izemmar ad idweř d uḍun n řbarṣ di teřmect n arrimet nnes, ad t awyen ɣar Harun, akehhan, niɣ ɣar yijjen zeg warraw nnes, ɣar ikehhanen. ");
INSERT INTO rifl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Akehhan ad ixzar ɣar wuḍun di teřmect n arrimet nnes uca mařa iẓra aqa iẓuṭṭan deg wemcan n wuḍun dewřen d icemřařen uca iban wuḍun ɛad yuǧeɣ x teřmect n arrimet nnes, aqa xenni d uḍun n řbarṣ. Xmi t ɣa iẓar ukehhan, ad t ibarreḥ d amexmuj. ");
INSERT INTO rifl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Maca mařa angaz iccemřeř di teřmect n arrimet nnes d acemřař u war yuǧiɣ x teřmect u iẓeṭṭan war dwiřen d icemřařen, xenni ad ibelleɛ ukehhan x wenni di iǧa uḍun nni sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Mařa iẓra i-t ukehhan deg wass wiss sebɛa uca iẓra aqa uḍun amenni iqqim, war imɣir wuḍun di teřmect, xenni ad t ibelleɛ ukehhan ɛawed sebɛa n wussan nneɣni. ");
INSERT INTO rifl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Deg wass wiss sebɛa ad t iẓar ukehhan ɛawed uca mařa iban aqa uḍun yarsa uca war imɣir ɛad ktar x teřmect, xenni akehhan ad t ibarreḥ d amezdag. Tuɣa-tt d ict n tfuriy. Ad issird arruḍ nnes uca ad yiři izdig. ");
INSERT INTO rifl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Maca mařa imɣar wuḍun aṭṭas x teřmect awarni řami t iẓra ukehhan di ṭṭweɛ n usizdeg nnes, ittxeṣṣa ad isscen ixef nnes i ukehhan twařa nneɣni. ");
INSERT INTO rifl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mařa iẓra ukehhan, aqa řehřac imɣar x teřmect, ad t ibarreḥ d amexmuj. Aqa-t d řehřac n řbarṣ i iǧa. ");
INSERT INTO rifl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Xmi uḍun n řbarṣ aqa-t deg ijj n bnadem, ad t awyen ɣar ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mařa iẓra ukehhan, aqa iban ijj n uɛebbuz d acemřař di teřmect, u iẓeṭṭan dewřen d icemřařen u iban-dd weysum iddar deg uɛebbuz, ");
INSERT INTO rifl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","aqa-t d řbars aqdim di teřmect n arrimet nnes uca akehhan ad zzayes ibarreḥ d amexmuj. War xas ittbelliɛ ca, minzi netta aqa ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Mařa yuyur řbarṣ x tiřmect marra uca idřa řbarṣ marra tiřmect n wenni ɣar iǧa uḍun zeg uzeǧif nnes ař iḍaren nnes, ař mani izemmar ad iẓar ukehhan s tiṭṭawin nnes, ");
INSERT INTO rifl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","uca iẓra i-t ukehhan, iẓra řbars idřa marra arrimet nnes, xenni netta ad ibarreḥ d amezdag i wenni di iǧa wuḍun. Tiřmect aqa-tt d tacemřač qaɛ. Netta aqa izdig. ");
INSERT INTO rifl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Maca deg wass mani dayes i ɣa dd-iban weysum iddar, ad yiři ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mařa iẓra ukehhan aysum nni iddar, ad t ibarreḥ d amexmuj. Aysum iddaren ixmej, aqa-t d řehřac n řbarṣ. ");
INSERT INTO rifl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Maca mařa ibeddeř weysum iddaren u idweř d acemřař, ittxeṣṣa as ad dd-yas ɣar ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Mařa iẓra i-t ukehhan uca aqa amcan n uḍun idweř d acemřař, ad ibarreḥ ukehhan wenni di iǧa řehřac d amezdag. Netta aqa izdig. ");
INSERT INTO rifl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Mařa din x teřmect n weysum ict n tḥebbuct u tᵉttwassgenfa tanita, ");
INSERT INTO rifl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","maca deg wemcan n tḥebbuct idweř d ijj n uɛebbuz imřeř niɣ d ijj n wengaz iccemřeř, acemřař iruḥ ɣar tezweɣ, xenni ad iẓar ukehhan man aya. ");
INSERT INTO rifl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Xmi ɣares i ɣa ixzar ukehhan uca iẓra aqa-t sadu teřmect uca iẓeṭṭan nnes d icemřařen, xenni akehhan ad t ibarreḥ d amexmuj, aqa-t d uḍun n řbarṣ wenni yuyuren s tḥebbuct. ");
INSERT INTO rifl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Maca mařa iẓra i-t ukehhan uca war dayes yufi uřa d ijj n uẓeṭṭu d acemřař uca war idwiř yuǧeɣ x teřmect, maca idweř yarsa, xenni ad xas ibelleɛ ukehhan sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mařa tuyur x teřmect marra, xenni akehhan ad t ibarreḥ d amexmuj. Aqa-t d uḍun n řbarṣ. ");
INSERT INTO rifl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Maca mařa angaz iccemřeř n teřmect iqqim deg wemcan nnes, war imɣir ca, aqa-t d ccamet n tḥebbuct uca akehhan ad t ibarreḥ d amezdag. ");
INSERT INTO rifl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Niɣ mařa idweř di teřmect n arrimet ijj n uyezzim n wecmaḍ uca aysum iddaren n uyezzim n wecmaḍ idweř d ijj n wengaz iccemřeř, acemřař iruḥ ɣar tezweɣ niɣ d acemřař, ");
INSERT INTO rifl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","uca iẓra ukehhan man aya, uca xzar, iẓeṭṭan i iǧan deg wengaz iccemřeř aqa dewřen d icemřařen, uca iban aqa amcan n wengaz yuǧeɣ di teřmect, aqa-t d řbarṣ nni dd-iffɣen zeg uyezzim n wecmaḍ. Akehhan ad t ibarreḥ d amexmuj. Aqa-t d uḍun n řbarṣ. ");
INSERT INTO rifl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Maca mařa akehhan iẓra man aya uca war ittwiři iẓeṭṭan icemřařen deg wengaz iccemřeř uca iẓra angaz war yuǧiɣ x teřmect uca yarsa, xenni ad xas ibelleɛ ukehhan sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Deg wass wiss sebɛa ad t iẓar ukehhan uca mařa imɣar wengaz ktar x teřmect, akehhan ad t ibarreḥ d amexmuj. Aqa-t d uḍun n řbarṣ. ");
INSERT INTO rifl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Maca mařa angaz iccemřeř iqqim deg wemcan nnes, war imɣir x teřmect uca yarsa, aqa-t d aɛebbuz n wecmaḍ. Akehhan ad t ibarreḥ d amezdag, minzi aqa-tt d ccamet n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Mařa ijj n weryaz niɣ ict n temɣart dayes uḍun deg uzeǧif niɣ di tmart, ");
INSERT INTO rifl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","uca ixzar ukehhan ɣar uḍun, u xzar, aqa ittban yuǧeɣ di teřmect uca dayes iẓeṭṭan iwarɣen d izdaden, xenni akehhan ad t ibarreḥ d amexmuj. Aqa-tt d tfuri n yiřem, aqa-t d řbarṣ n uzeǧif niɣ n tmart. ");
INSERT INTO rifl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Maca mařa iẓra ukehhan uḍun n tfuri n yiřem, iẓra aqa war yuǧiɣ di teřmect uca war dayes iẓeṭṭan ibarcanen, xenni ad xas ibelleɛ ukehhan x wenni di iǧa wuḍun n tfuri n yiřem i yijj n řmijař n sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ad iẓar ukehhan uḍun deg wass wiss sebɛa uca mařa iẓra, aqa tfuri n yiřem war temɣir, war dayes yufi iẓeṭṭan iwarɣen uca tfuri n yiřem war tuǧiɣ x teřmect, ");
INSERT INTO rifl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","xenni netta ad iḥeff i yixef nnes, maca amcan n tfuri n yiřem war t ittḥeffi ca uca akehhan ad ibelleɛ x wenni di iǧa tfuri n yiřem ɛad ict n twařa nneɣni i yijj n řmijař n sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Deg wass wiss sebɛa ad iẓar ukehhan amcan n tfuri n yiřem. Mařa iẓra aqa tfuri n yiřem war temɣir ca, war tuǧiɣ x teřmect, xenni akehhan ad t ibarreh d amezdag. Ad issird arruḍ nnes uca ad yiři izdig. ");
INSERT INTO rifl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Maca mařa tfuri n yiřem temɣar aṭṭas x teřmect awarni i usizdeg nnes, ");
INSERT INTO rifl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","uca iẓra i-t ukehhan uca iẓra tfuri n yiřem temɣar x teřmect, xenni war yarezzu ukehhan x iẓeṭṭan iwarɣen ɛad, netta aqa ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Maca mařa tfuri n yiřem aqa tban-dd tbedd di tiṭṭawin nnes, uca ffɣen-dd zzayes iẓeṭṭan ibarcanen, xenni aqa tᵉggenfa tfuri n yiřem uca netta aqa izdeg. Akehhan ad t ibarreḥ d amezdag. ");
INSERT INTO rifl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Mařa banen-dd imucan ccemřeřen, iccemřeřen d icemřařen, di teřmect n ijj n weryaz niɣ n ict n temɣart, ");
INSERT INTO rifl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","uca iẓra ukehhan man aya uca iẓra aqa di teřmect n arrimet banen-dd imucan arsan, icemřařen, xenni aqa-tt d ict n tfuri n teřmect, netta aqa izdeg. ");
INSERT INTO rifl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Mařa iwḍa ucuwwaf n uzeǧif n ijj n weryaz, aqa d aqeccar, xenni netta aqa izdig. ");
INSERT INTO rifl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Mařa tanyart n ca n yijj ad tedweř tařeqqaɣt, aqa tanyart nnes tqeccar waha, netta aqa izdig. ");
INSERT INTO rifl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Maca mařa din ijj n uḍun imřeř iruḥ ɣar tezweɣ x uzeǧif aqeccar niɣ x tenyart taqeccart, aqa-t d řbarṣ nni dd-iffɣen x uzeǧif nnes aqeccar niɣ x tenyart nnes taqeccart. ");
INSERT INTO rifl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mařa iẓra i-t ukehhan uca iẓra aqa aɛebbuz n wuḍun imřeř, iruḥ ɣar tezweɣ x uzeǧif nnes aqeccar niɣ x tenyart nnes taqeccart, iban-dd am řbarṣ n teřmect n arrimet, ");
INSERT INTO rifl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","xenni aqa aryaz d bu-řbarṣ i iǧa, netta aqa ixmej. Akehhan ad t ibarreḥ d amexmuj, uḍun aqa-t x uzeǧif nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Ittxeṣṣa ad ittwacarreg warruḍ n bu-řbarṣ i di iǧa wuḍun uca ad iḍřeq i ucuwwaf x uzeǧif nnes, ad iřeḥḥef acřaɣem ɣar uyencic, ad iřaɣa: ‘Amexmuj! Amexmuj!’ ");
INSERT INTO rifl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Marra ussan i dayes i ɣa yiři wuḍun, ad yiři ixmej. Netta d amexmuj. Netta ad izdeɣ weḥḥdes uca tzeddiɣt nnes ad tiři barra i řmargeḥ n řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Mařa uḍun n řbarṣ deg ijj n warruḍ, deg ijj n warruḍ n taḍuft niɣ deg ijj n warruḍ n řeqṭen, ");
INSERT INTO rifl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","niɣ deg wecḍaḍ ixeyyḍen niɣ deg ufiřu immuden, niɣ n řeqṭen niɣ n taḍuft, niɣ ɣar yiřem, niɣ ɣar mammec ma řqecɛet n yiřem, ");
INSERT INTO rifl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","u ticti ittwawten deg warruḍ niɣ deg yiřem, niɣ ɣar wecḍaḍ ixeyyḍen niɣ ɣar ufiřu immuden, niɣ di mammec ma n řqecɛet nni tteggen s yiřem, tezzizu niɣ tezweɣ, aqa-t d uḍun n řbarṣ. Ad ittwasscen aya i ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Akehhan ad ixzar ɣar wemcan n uḍun uca min iḍnen ad t ibelleɛ sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Deg wass wiss sebɛa ad ixzar ɣar wuḍun. Mařa imɣar uḍun deg warruḍ, niɣ ɣar wecḍaḍ ixeyyḍen niɣ ɣar ufiřu immuden, niɣ deg yiřem n mammec ma řqecɛet nni tteggen s yiřem, aqa uḍun d řbars iqesḥen i yeǧa, aqa ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ad issecmeḍ arruḍ niɣ afiřu d azirar niɣ afiřu immuden, niɣ n taḍuft niɣ n řeqṭen i iǧa, niɣ mammec ma řqecɛet nni tteggen s yiřem i dayes tuɣa uḍun, minzi aqa-t d řbarṣ iqesḥen. Ittxeṣṣa ad ittwassecmeḍ s tmessi. ");
INSERT INTO rifl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Maca mařa iẓra ukehhan man aya uca aqa uḍun war imɣir ca deg warruḍ, niɣ deg wecḍaḍ ixeyyḍen niɣ deg ufiřu immuden, niɣ di mammec ma řqecɛet nni tteggen s yiřem, ");
INSERT INTO rifl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","xenni ad yumur ukehhan maḥend ad ssirden min di yeǧa wuḍun, uca awarni i man aya ad xas ibelleɛ twařa nneɣni řqedd n sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mařa iẓra ukehhan uḍun awarni i usird, uca iẓra uḍun war ibeddiř ca uca uḍun war imɣir, aqa arruḍ nni ixmej. Ittxeṣṣa ad t tessecmeḍed s tmessi. Aqa uḍun idweř yuǧeɣ ittᵉtt ɣar ḍeffar niɣ ɣar zzat. ");
INSERT INTO rifl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Maca mařa iẓra ukehhan man aya uca iẓra belli uḍun yarsa awarni i usird, xenni ad t iqess zeg warruḍ, niɣ zeg yiřem, niɣ zeg wecḍaḍ ixeyyḍen niɣ zeg ufiřu immuden. ");
INSERT INTO rifl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Maca mařa iban wuḍun twařa nneɣni deg warruḍ, niɣ ɣar wecḍaḍ ixeyyḍen niɣ ɣar ufiřu immuden, niɣ di mammec ma řqecɛet nni tteggen s yiřem, aqa idduqqez řbarṣ. Ittxeṣṣa ad tessecmeḍ s tmessi min dayes i iǧan uḍun. ");
INSERT INTO rifl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Arruḍ, niɣ afiřu d azirar niɣ afiřu immuden niɣ mammec ma řqecɛet nni tteggen s yiřem, wenni tessirded uca iruḥ xas wuḍun, ad t tessirded twařa nneɣni uca xenni ad yiři izdig.” ");
INSERT INTO rifl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Wa d azerf n wuḍun n řbarṣ n warruḍ n taḍuft niɣ n řeqṭen, niɣ n wecḍaḍ ixeyyḍen niɣ n ufiřu immuden, niɣ n mammec ma řqecɛet nni tteggen s yiřem, maḥend xenni ad barrḥen s tezdeg nnes niɣ s řexmej nnes. ");
INSERT INTO rifl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Wa d azerf n bu-řbarṣ i wass n usizdeg nnes. Ittxeṣṣa ad t nedhen ɣar ukehhan, ");
INSERT INTO rifl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","uca ad iffeɣ ukehhan ɣar barra i řmargeḥ n řɛeskar. Xmi ɣares i ɣa ixzar ukehhan uca iẓra aqa iggenfa wuḍun n řbarṣ n bu-řbarṣ, ");
INSERT INTO rifl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ad yumur ukehhan, maḥend ad ksin i wenni i ɣa ittwassizedgen tnayen n ijḍaḍ iddaren izdigen, uřa d akeccuḍ n tcejjart n tengelt, d uzeggʷaɣ iḥedqen, d tɛelǧet. ");
INSERT INTO rifl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ad yumur ukehhan maḥend ad ɣarṣen i yijj n wejḍiḍ deg ict n řqecɛet n třaxt, sennej i waman ittazzřen. ");
INSERT INTO rifl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Xenni ad iksi ajḍiḍ iddaren d ukeccuḍ n tcejjart n tengelt d uzeggʷaɣ iḥedqen d tɛelǧet uca ad ten issuf ak-d wejḍiḍ iddaren deg idammen n wejḍiḍ i ittwaɣarṣen sennej i waman ittazzřen. ");
INSERT INTO rifl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ad irucc sebɛa n twařawin x wenni ittwassizedgen zi řbarṣ. Xenni ad t ibarreḥ d amezdag uca ad yarxu i wejḍiḍ iddaren maḥend ad iḍew sennej i wudem n yeyyar. ");
INSERT INTO rifl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Uca wenni ittwassizedgen ad iṣebben arruḍ nnes uca ad iḥeff marra acuwwaf nnes, ad issird ixef nnes s waman. Xenni ad yiři izdeg. Awarni as ad yadef ɣar řmargeḥ n řɛeskar uca ad izdeɣ barra i uqiḍun nnes ɛad sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Deg wass wiss sebɛa ad iḥeff marra acuwwaf n uzeǧif nnes d tmart nnes d temmiwin n tiṭṭawin nnes, wah, ad iḥeff marra acuwwaf nnes, ad iṣebben arruḍ nnes uca ad issird arrimet nnes s waman, xenni ad yiři izdeg. ");
INSERT INTO rifl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Deg wass wiss tmenya ad iksi tnayen n izmaren kemmřen d icten texsi icnan qaɛ n ijjen useggʷas ak-d třata zi ɛecra n ijjen ifa n waren azdad am tewhibt n řɣiǧet ixeǧḍen s zzect, u ɛawed ijjen ulux n zzect. ");
INSERT INTO rifl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Akehhan, wenni t issizedgen, ad yarr aryaz nni ittxeṣṣa ad ittwassizdeg, ak-d marra aya zzat i wudem n SIDI ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ad iksi ukehhan izmar nni uca ad t-i-dd-issqarreb am tɣarṣt n umarwas ak-d ulux n zzect, uca ad t issenhezz am tewhibt n wenhezzi zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Xenni ad iɣarṣ i yezmar nni deg wemcan mani ɣarrṣen taɣarṣt n ddenb d tɣarṣt n wecmaḍ, deg wemcan amqeddas. Minzi taɣarṣt n umarwas, am tɣarṣt n ddenb, i ukehhan i teǧa, aqa-tt d tamqeddast qaɛ. ");
INSERT INTO rifl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ad iksi ukehhan cwayt zeg idammen n tɣarṣt n umarwas uca akehhan ad ten igg x iɣes n umezzuɣ afusi n wenni i ɣa ittwassizedgen uřa x yimez n ufus nnes afusi u x yimez n uḍar nnes afusi. ");
INSERT INTO rifl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Amenni i ɣa iksi ukehhan ca zeg ulux n zzect uca ad tt inɣeř x třeqqa n ufus nnes azeřmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ad issuf ukehhan aḍaḍ nnes afusi s zzect nni ɣares deg ufus nnes azeřmaḍ uca ammu i ɣa irucc s uḍaḍ nnes cwayt zi zzect sebɛa n twařawin zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Uca min iqqimen zi zzect nni ɣares deg ufus nnes, ad tt igg ukehhan x iɣes n umezzuɣ afusi n wenni i ɣa ittwassizedgen, uřa x yimez n ufus nnes afusi u x yimez n uḍar nnes afusi, tiwa n idammen n tɣarṣt n umarwas i xasen igga qbeř. ");
INSERT INTO rifl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Min iqqimen n zzect nni iǧan ɣar ukehhan di třeqqa n ufus nnes, ad t inɣeř x uzeǧif n wenni i ɣa ittwassizedgen uca ammu i t ɣa isseṣřeḥ ukehhan zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ad issewjed ukehhan xenni taɣarṣt n ddenb uca ad isseṣřeḥ wenni ittwassizedgen zi řexmej nnes. Awarni as ad iɣarṣ i tɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ad issbexxar ukehhan taɣarṣt n wecmaḍ d tewhibt n řɣiǧet x uɛalṭar. Ammu i t ɣa isseṣřeḥ ukehhan uca ad yiři izdeg. ");
INSERT INTO rifl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mařa netta iẓřeḍ uca afus nnes war t issiweḍ, xenni ad iksi ijj n yizmar am tɣarṣt n umarwas maḥend ad xas igg aṣřaḥ am igga izmar d tewhibt n wenhezzi. Ad iksi řa d ict n teɛcart n ijj n ifa n waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet, uřa d ijj n ulux n zzect ");
INSERT INTO rifl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","d tnayen n tejlilliḥin niɣ tnayen n idbiren imeẓyanin, anect izemmar ufus nnes ad issiweḍ. Ict ad tiři d taɣarṣt n ddenb u tenneɣni ad tiři d taɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Deg wass wiss tmenya ad ten yawi di ṭṭweɛ n usizdeg nnes ɣar ukehhan, ɣar wadaf n Uqiḍun n Umsagar, zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ad iksi ukehhan izmar n tɣarṣt n umarwas d ulux nni n zzect uca akehhan ad ten issenhezz am tewhibt n wenhezzi zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Xenni ad iɣarṣ i izmar n tɣarṣt n umarwas uca akehhan ad iksi cwayt zeg idammen n tɣarṣt n umarwas, ad ten yarr x iɣes n umezzuɣ afusi n wenni ittwassizedgen uřa x yimez n ufus nnes afusi u x yimez n uḍar nnes afusi. ");
INSERT INTO rifl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ad ifarreɣ ukehhan ca n zzect x třeqqa n ufus aẓeřmaḍ n yixef nnes. ");
INSERT INTO rifl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","S uḍaḍ nnes afusi ad irucc ukehhan s zzect nni ɣares deg ufus nnes aẓeřmaḍ sebɛa n twařawin zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Akehhan ad igg cwayt zi zzect nni ɣares iǧan deg ufus nnes x iɣes n umezzuɣ afusi n wenni ittwassizedgen uřa x yimez n ufus nnes afusi u x yimez n uḍar nnes afusi, deg wemcan nnit mani ttwaggen idammen n tɣarṣṭ n umarwas qbeř. ");
INSERT INTO rifl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Min iqqimen zi zzect nni ɣar ukehhan deg ufus nnes, ad t igg x uzeǧif n wenni ittwassizedgen, maḥend ad xas igg aṣřaḥ zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Xenni ad issewjed ijj zi tnayen n tejlilliḥin niɣ zeg idbiren imeẓyanen, anect umi izemmar ufus nnes ad issiweḍ. ");
INSERT INTO rifl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Zi min d as ɣa issiweḍ ufus nnes, ad yiři ijj i tɣarṣt n ddenb u wenneɣni i tɣarṣt n wecmaḍ, sennej i tewhibt n řɣiǧet. Akehhan ad igg aṣřaḥ x wenni ittwassizedgen zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Wa d azerf i wenni di iǧa wuḍun n řbarṣ uca afus nnes war izemmar ad issiweḍ i usizdeg nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Xmi ɣa tadfem ɣar temmurt n Kenɛan, tenni d awem ɣa wceɣ d agřa, uca mařa ggiɣ Necc uḍun n řbarṣ x ca n taddart n temmurt nni ɣarwem d agřa, ");
INSERT INTO rifl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ad dd-yas xenni wenni ɣar teǧa taddart nni, ad ixebbar akehhan, ad yini: ‘Ittɣiř ayi-dd axmi din ca n wuḍun di taddart.’ ");
INSERT INTO rifl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Xenni akehhan ad issekk, maḥend ad ssexwan taddart qbeř i dd ɣa yas ukehhan s yixef nnes, ḥima ad ixemm uḍun, ḥima war ittwassexmij marra min iǧan di taddart. Awarni as ad dd-yas ukehhan, maḥend ad ixemmem taddart. ");
INSERT INTO rifl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Mařa ixzar ɣar uḍun uca iẓra aqa uḍun n řeḥyuḍ n taddart banen-dd dayes iḥufar zzizwen niɣ zewɣen, uǧɣen x wudem n řḥiḍ, ");
INSERT INTO rifl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","xenni ad iffeɣ ukehhan zi taddart nni zi wadaf n taddart uca ad iqqen taddart sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Deg wass wiss sebɛa ad dd-idweř ukehhan uca mařa iẓra aqa uḍun ibezzeɛ x řeḥyuḍ n taddart, ");
INSERT INTO rifl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","xenni ad iweṣṣa ukehhan, maḥend ad kksen iẓra mani iřseq wuḍun u ad ten nḍaren deg ijj n wemcan ixemjen barra i tendint. ");
INSERT INTO rifl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ad yejj ad qeccaren daxeř n taddart ɣar marra iɣezdisen nnes, uca ad zeǧɛen abeǧaɛ i qeccaren barra i tendint deg ijj n wemcan d amexmuj. ");
INSERT INTO rifl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Xenni ad ksin iẓra nneɣni, ad ten ggen deg wemcan n iẓra nni iheřcen uca ad ksin abeǧaɛ nneɣni maḥend ad zzayes ḥenncen taddart. ");
INSERT INTO rifl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Mařa uḍun idweř-dd uca issfuffi ɛawed di taddart awarni řami kksen iẓra u qeccaren taddart awarni řami tt ḥenncen, ");
INSERT INTO rifl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","xenni ad dd-yas ukehhan ad tt iqeǧeb. Mařa iẓra, aqa uḍun ibezzeɛ di taddart, xenni aqa din ijj n řbarṣ iqesḥen di taddart. Aqa-tt texmej. ");
INSERT INTO rifl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ad hedmen taddart, iẓra nnes d tḥenya nnes d marra tarrist n taddart uca ad ssiggʷejen aya barra i tendint ɣar ijj n wemcan d amexmuj. ");
INSERT INTO rifl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Wi ɣa yadfen ɣar taddart deg ijj n wass zeg wussan awarni řami bellɛen taddart, netta ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Wi ɣa iṭṭṣen di taddart, ad iṣebben arruḍ nnes u wi ɣa iccen di taddart, ad issird arruḍ nnes. ");
INSERT INTO rifl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mařa yudef ukehhan, maḥend ad tt iqeǧeb uca iẓra aqa uḍun war imɣir di taddart, awarni řami ḥenncen taddart, xenni ad ibarreḥ ukehhan belli taddart tezdeg, minzi uḍun ittwassgenfa. ");
INSERT INTO rifl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ad iksi tnayen n ijḍaḍ d ukeccuḍ n tcejjart n tengelt d uzeggʷaɣ iḥedqen d tɛelǧet, maḥend ad zzaysen ikkes ddenb x taddart. ");
INSERT INTO rifl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ad iɣarṣ i yijj n wejḍiḍ deg ict n řqecɛet n třaxt, sennej i waman iddaren. ");
INSERT INTO rifl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ad iksi akeccuḍ n tcejjart n tengelt d tɛelǧet d uzeggʷaɣ iḥedqen uřa d ajḍiḍ iddaren uca ad issuf marra aya deg idammen n wejḍiḍ ittwaɣarṣen u deg waman iddaren uca ad irucc taddart sebɛa n twařawin. ");
INSERT INTO rifl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ammu i ɣa ikkes ddenb x taddart s idammen n wejḍiḍ, s waman iddaren d wejḍiḍ iddaren d ukeccuḍ n tcejjart n tengelt d tɛelǧet d uzeggʷaɣ iḥedqen. ");
INSERT INTO rifl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ad yejj ajḍiḍ iddaren ad iḍwa barra i tendint sennej i wudem n yeyyar. Ammu i ɣa igg aṣřaḥ x taddart nni uca ad tiři tizdig.” ");
INSERT INTO rifl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Wa d azerf x marra řehřacat n řbarṣ u x tfuri n yiřem, ");
INSERT INTO rifl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","x řbarṣ n arruḍ u n taddart, ");
INSERT INTO rifl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","x ijj n uɛebbuz, x ict n tḥebbuct u x ijj n wengaz iccemřeř n teřmect. ");
INSERT INTO rifl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Azerf-a aqa i tɣuri deg wass i di ɣa yiři ḥed ixmej niɣ deg wass i di ɣa yiři ḥed izdeg. Wa d azerf n řbarṣ.” ");
INSERT INTO rifl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Siweř ak-d ayt n Israil, inim asen: ‘Mařa aryaz ɣares ijj n useyyeř zi arrimet nnes, xenni ad yiři ixmej zi ssibbet n useyyeř. ");
INSERT INTO rifl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Wa ad yiři d řexmej nnes zi ssibbet n useyyeř nnes: mařa arrimet nnes tᵉttejja aseyyeř nnes niɣ arrimet nnes tessbedda aseyyeř nnes, aqa-t d řexmej nnes. ");
INSERT INTO rifl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kuř qama min xef ɣa iṭṭeṣ wenni di iǧa useyyeř, ad yiři ixmej u kuř řqecɛet i xef ɣa iqqim, ad tiři texmej. ");
INSERT INTO rifl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Marra wi ɣa iḥadan qama nnes, ad iṣebben arruḍ nnes, ad issird ixef nnes ɛawed s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Wenni i ɣa iqqimen x ca x min xef tuɣa iqqim wenni di iǧa useyyeř, ad iṣebben arruḍ nnes, ad issird ixef nnes ɛawed s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wenni i ɣa iḥadan arrimet n wenni di iǧa useyyeř, ad iṣebben arruḍ nnes uca netta simant nnes ad issird s waman, uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Mařa wi di iǧa useyyeř issusef x ijj n umezdag, aqa wa ad iṣebben arruḍ nnes, ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kuř trict min xef iqqim wenni di iǧa useyyeř, ad tiři texmej. ");
INSERT INTO rifl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Marra wi ɣa iḥadan mammec ma řqecɛet nni iǧan sadu nnes, ad yiři ixmej ař tameddit uca wi tt ɣa iksin, ad iṣebben arruḍ nnes, ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Marra wi ɣa ittwaḥadan zeg wenni di iǧa useyyeř břa ma ad issird wa ifassen nnes amezwaru, ad iṣebben arruḍ nnes, ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ṭṭebṣi n třaxt nni iḥada wenni di iǧa useyyeř, ittxeṣṣa ad ittwarẓ, maca marra řqecɛet n tefřawt ad tt sirden s waman. ");
INSERT INTO rifl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Xmi wenni di iǧa useyyeř ad ittwassizdeg zeg useyyeř nnes, ittxeṣṣa as simant nnes ad iḥseb i sebɛa n wussan. Xenni ad iṣebben arruḍ nnes, ad issird arrimet nnes s waman iddaren uca ad yiři izdig. ");
INSERT INTO rifl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Deg wass wiss tmenya ad iksi tnayen n tejlilliḥin niɣ tnayen n idbiren imeẓyanen uca ad dd-yas zzat i wudem n SIDI ɣar wadaf n Uqiḍun n Umsagar uca ad ten iwc i ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Akehhan ad issewjed ict n tɣarṣt n ddenb d ict n tɣarṣt n wecmaḍ. Akehhan ad xas igg aṣřaḥ zzat i wudem n SIDI x useyyeř nnes.’” ");
INSERT INTO rifl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Mařa iffeɣ-dd useyyeř n waǧu zeg weryaz, ad issird arrimet nnes marra s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kuř arruḍ d kuř iřem i xef iǧa useyyeř n waǧu, ittxeṣṣa ad t sirden s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Mařa iṭṭeṣ yijj weryaz ak-d temɣart uca inḍar dayes netta, xenni ad ssirden s tnayen idsen s waman uca ad iřin xemjen ař tameddit.” ");
INSERT INTO rifl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Mařa tamɣart tuɣa-tt tseyyeř, aqa xas idammen di arrimet nnes, xenni ad teɛzeř sebɛa n wussan. Marra wi tt ɣa iḥadan ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Marra min xef tuɣa tᵉṭṭeṣ deg weɛzař nnes, ad yiři ixmej uca marra min xef tuɣa teqqim, ad yiři ixmej. ");
INSERT INTO rifl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Marra wi ɣa iḥadan qama nnes, ad issird arruḍ nnes, ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Marra wi ɣa iḥadan ca n řqecɛet min xef tuɣa tᵉttɣima, ad iṣebben arruḍ nnes, ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Niɣ mařa iqqim x qama niɣ x řqecɛet i xef tuɣa teqqim nettat, umi iḥada aya ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Mařa iṭṭeṣ akides ijj n weryaz uca yusa-dd xas weɛzař nnes, xenni ad yiři ixmej sebɛa n wussan. Kuř qama i x tuɣa iṭṭeṣ, ad tiři texmej. ");
INSERT INTO rifl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Mařa usin-dd idammen x ict n temɣart aṭṭas n wussan barra i řmijař n weɛzař nnes niɣ mařa tuɣa aseyyeř ktar x řmijař n weɛzař nnes, xenni ad tiři texmej marra ussan n useyyeř i dd-yusin ak-d řexmej nnes, am deg wussan n weɛzař nnes. ");
INSERT INTO rifl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kuř qama min xef tᵉṭṭeṣ marra ussan n useyyeř nnes, ad as tiři am qama n weɛzař nnes u marra řqecɛet min xef teqqim, ad tiři texmej amecnaw řexmej n weɛzař nnes. ");
INSERT INTO rifl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Marra wi ɣa iḥadan timesřayin nni, ad yiři ixmej. Ad iṣebben arruḍ nnes uca ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Mařa tᵉttwassizdeg zeg useyyeř nnes, ittxeṣṣa ad teḥseb i yixef nnes sebɛa n wussan, awarni as ad tiři tezdeg. ");
INSERT INTO rifl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Deg wass wiss tmenya ad teksi i yixef nnes tnayen n tejlilliḥin niɣ tnayen n idbiren imeẓyanen uca ad ten tawi ɣar ukehhan ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Akehhan ad issewjed ict n tɣarṣt n ddenb d ict n tɣarṣt n wecmaḍ uca akehhan ad xas igg aṣřaḥ di tmesřact n useyyeř n řexmej nnes zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ammu i ɣa tɛezřed ayt n Israil x řexmej nsen, ḥima war ttᵉmettin di řexmej nsen, umi ssxemmajen Tazeddiɣt inu nni iǧan di řwesṭ nsen.” ");
INSERT INTO rifl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Wa d azerf i wenni ɣar iǧa useyyeř u i wenni zi ɣa iffeɣ waǧu nnes uca xenni ad yiři ixmej ");
INSERT INTO rifl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","u ɛawed i tenni min xef iǧa idammen uca xenni teɛzeř ixef nnes u ɛawed i wi di tuɣa aseyyeř, i weryaz uřa i temɣart, u ɛawed i weryaz i tuɣa iṭṭṣen ak-d tenni iǧan texmej. ");
INSERT INTO rifl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Issiweř SIDI ak-d Musa awarni i řmewt n tnayen n warraw n Harun, awarni řami dd-qarrben nitni zzat i wudem n SIDI uca mmuten. ");
INSERT INTO rifl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","SIDI inna i Musa: “Siweř ak-d Harun, umac, ḥima war ittidef řebda ɣar Uqeddas daxeř i uřeḥḥaf zzat i tqebbart n weṣřaḥ nni iǧan x Ttabut, ḥima war ittmetti ca, minzi Necc ttbaneɣ-dd deg ijj n useynu sennej i tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","S uya ad yadef Harun ɣar Uqeddas: s ijj n ufunas, ameẓyan n tfunast, i tɣarṣt n ddenb, u s yijj n icarri i tɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ad yarḍ tcamir iqeddsen n řeqṭen uca ssarwař n řeqṭen ad yiři x arrimet nnes. Ad ibyes taḥezzamt n řeqṭen uca ad yarekkeb areẓẓet n řeqṭen. Aqa man aya d arruḍ iqeddsen. Mařa ad ten yarḍ, ittxeṣṣa as ad issird arrimet nnes s waman d amezwaru. ");
INSERT INTO rifl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ad iksi zi tmesmunt n ayt n Israil tnayen n imyanen zeg iɣayḍen i tɣarṣt n ddenb d ijj n icarri i tɣarṣt n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ad dd-issqarreb Harun afunas ameẓyan n tɣarṣt n wecmaḍ, wenni iǧan i yixef nnes, uca ad igg aṣřaḥ i yixef nnes u i taddart nnes.    ");
INSERT INTO rifl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ad iksi tnayen n imyanen uca ad ten igg zzat i wudem n SIDI ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ad inḍar Harun taqedduḥt x tnayen n imyanen: ict n tqedduḥt x SIDI u ict n tqedduḥt x iɣayḍ innufsřen, qqaren as ‘Ɛazazil’. ");
INSERT INTO rifl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ad dd-issqarreb Harun amyan nni x dd-tewḍa taqedduḥt i SIDI uca ad t issewjed d tɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Amyan i x dd-tewḍa taqedduḥt n iɣayḍ innufsřen, ad t igg iddar zzat i wudem n SIDI, maḥend ad zzayes igg aṣřaḥ uca xenni ad t issekk am yiɣayḍ innufsřen ɣar řexřa. ");
INSERT INTO rifl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ad dd-issqarreb Harun afunas ameẓyan n tɣarṣt n ddenb, wenni tuɣa i yixef nnes, uca ad igg aṣřaḥ i yixef nnes u i aytbab n taddart nnes uca ad iɣarṣ i ufunas ameẓyan n tɣarṣt n ddenb, wenni iǧan i yixef nnes. ");
INSERT INTO rifl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ad iksi ɛawed ijj n řmejmar iccur s řefḥem itteḥduduqen n uɛalṭar zzat i wudem n SIDI uca ad iccur tnayen n ifassen nnes s řebxur azdad ittfuḥen, uca ad yawi marra aya daxeř i uřeḥḥaf. ");
INSERT INTO rifl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ad igg řebxur x tmessi zzat i wudem n SIDI, ḥima aseynu n řefwar n řebxur ad ideř taqebbart n weṣřaḥ i iǧan x Cchadet, uca war ittmetti ca. ");
INSERT INTO rifl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ad iksi cwayt zeg idammen n ufunas ameẓyan uca ad ten irucc s uḍaḍ nnes x wudem n tqebbart n weṣřaḥ ɣar uɣezdis n ccarq uca ɛawed ad irucc cwayt zeg idammen sebɛa n twařawin s uḍaḍ nnes zzat i tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Xenni ad iɣarṣ i umyan n tɣarṣt n ddenb, wenni iǧan i řgens uca ad yawi idammen ɣar daxeř i uřeḥḥaf uca ad igg s idammen nnes am mammec igga s idammen n ufunas ameẓyan: ad ten irucc x tqebbart n weṣřaḥ u zzat i tqebbart n weṣřaḥ. ");
INSERT INTO rifl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ammu i i ɣa igg aṣřaḥ x Uqeddas i řḥajjat ixemjen n ayt n Israil u i ixeṭṭan nsen i dd-ittasen ak-d marra ddnub nsen. Ammu i ɣa yegg di ssibbet n Uqiḍun n Umsagar, wenni iǧan akidsen di řwesṭ n marra timesřayin ixemjen nsen. ");
INSERT INTO rifl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Uřa d ijj n bnadem ad yiři ɛad deg Uqiḍun n Umsagar zeg wami i ɣa yadef maḥend ad igg aṣřaḥ deg Uqeddas ař ɣa iffeɣ ɛawed. Ammu i ɣa igg aṣřaḥ i yixef nnes u i marra agraw n řgens n Israil. ");
INSERT INTO rifl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ad iffeɣ ař uɛalṭar i iǧan zzat i wudem n SIDI uca ad igg asřaḥ x uɛalṭar. Ad iksi cwayt zeg idammen n ufunas ameẓyan u cwayt zeg idammen n umyan uca ad issars aya x waccawen n uɛalṭar deg wenneḍ nnes. ");
INSERT INTO rifl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Sebɛa n twařawin ad xas irucc s uḍaḍ nnes cwayt zeg idammen uca ad t issizdeg u ad t issqeddes zi řexmej n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Awarni řami ikemmeř aṣřaḥ n Uqeddas d Uqiḍun n Umsagar d uɛalṭar, ad dd-issqarreb xenni amyan iddaren. ");
INSERT INTO rifl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ad issars Harun tnayen n ifassen nnes x uzeǧif n umyan iddaren uca ammu i ɣa inɛem Harun sennej i uzeǧif n umyan x marra řmuɛṣiyyet n ayt n Israil d marra ixeṭṭan nsen i dd-yusin ak-d marra ddnub nsen uca ad ten issars x uzeǧif n umyan uca ad t issekk ɣar řexřa s ufus n ijj n weryaz wenni isswejden i ddegga. ");
INSERT INTO rifl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Uca iɣayḍ ad yawi ak-d ixef nnes marra řmuɛṣiyyet nsen ɣar ict n jjihet texřa. Netta ad issekk amyan ɣar řexřa. ");
INSERT INTO rifl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Xenni ad yadef Harun ɣar Uqiḍun n Umsagar uca ad ikkes arruḍ n řeqṭen nni yarḍ, umi yudef ɣar Uqeddas uca ad t yejj din. ");
INSERT INTO rifl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Ad issird arrimet nnes s waman deg wemcan amqeddas uca ad yarḍ arruḍ nnes. Xenni ad iffeɣ, ad issewjed taɣarṣt n wecmaḍ nnes d tɣarṣt n řgens uca ad igg aṣřaḥ i yixef nnes u i řgens. ");
INSERT INTO rifl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ad issbexxar tadunt n tɣarṣt n ddenb x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Wi dd-isekken amyan am umyan innufsřen, ad iṣebben arruḍ nnes, ad issird arrimet nnes s waman. Awarni as ad yadef ɣar řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Afunas ameẓyan n tɣarṣt n ddenb d umyan n ṭɣarṣt n ddenb i zi ttwassidfen idammen nsen, maḥend ad zzaysen ittwagg aṣřaḥ deg Uqeddas, ad ten ssuffɣen barra i řmargeḥ n řɛeskar uca ad zzaysen sscemḍen iřmawen nsen d weysum nsen d umessař nsen s tmessi. ");
INSERT INTO rifl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Wi ten ɣa isscemḍen, ad iṣebben arruḍ nnes, ad issird arrimet nnes s waman. Awarni as ad yadef ɣar řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ta d ict n tewṣeyyet i řebda i kenniw. Deg uyur wiss sebɛa, deg wass wiss ɛecra n uyur, ad tesswaḍɛem ixef nwem uca war tteggem uřa d ict n řxedmet, niɣ wenni dd-ixeřqen di temmurt niɣ ubarrani nni izeddɣen di řwest nwem. ");
INSERT INTO rifl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Minzi deg wass nni ad ittwagg weṣřaḥ i kenniw, maḥend ad tᵉttwassizedgem. Kenniw marra ad tᵉttwassizedgem zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ass nni ad yiři d ijj wass n ssebt, arraḥet tmun i kenniw. Ad tesswaḍɛem ixef nwem, aqa-tt d ict n tewṣeyyet i řebda. ");
INSERT INTO rifl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Akehhan, wenni dehnen u řeqqmen nitni deg wemcan n babas, maḥend ad yiři d akehhan, ad igg aṣřaḥ uca ad yarḍ arruḍ n řeqṭen, arruḍ iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ad igg aṣřaḥ x Zzawect Iqeddsen u x Tqiḍunt n Umsagar u x uɛalṭar. Ad igg aṣřaḥ ɛawed x marra ikehhanen u x marra řgens n wegraw. ");
INSERT INTO rifl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ta d ict n tewṣeyyet i řebda i kenniw, ḥima ad ittwagg weṣřaḥ x marra ayt n Israil i marra ddnub nsen, ict n twařa deg useggʷas.” Uca igga am mammec iweṣṣa SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Siweř ak-d Harun d warraw nnes u ak-d marra ayt n Israil, ini asen: ‘Wa d awař i iweṣṣa SIDI, iqqar: ");
INSERT INTO rifl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Kuř aryaz zi taddart n Israil, wenni iɣarṣen i ufunas niɣ i yezmar niɣ i iɣayḍ di řmargeḥ niɣ wenni t iɣarṣen barra i řmargeḥ, ");
INSERT INTO rifl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","maca war t yiwi d tawhibt ɣar wadaf n Uqiḍun n Umsagar, maḥend ad t-i-dd-issqarreb d tawhibt ɣar SIDI zzat n Tzeddiɣt n SIDI, ad as dd-ittwaḥseb idammen nni. Netta issizzeř idammen, s uyenni ad ittwaqes weryaz nni zi řgens nnes, ");
INSERT INTO rifl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","maḥend, xmi ɣa qeddmen ayt n Israil tiɣarṣa nsen, tinni nnumen ɣarrṣen barra deg iyyar, nitni ad tent awyen ɣar SIDI, ɣar ukehhan ɣar wadaf n Uqiḍun n Umsagar, maḥend ad tent qeddmen din am tɣarṣa n řehna i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Akehhan ad izeǧeɛ idammen x uɛalṭar n SIDI ɣar wadaf n Uqiḍun n Umsagar u netta ad issbexxar tadunt am yict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","War ttqeddamen ɛad tiɣarṣa nsen i imuyan ijennin, inni ḍeffaren nitni am ayt n farq-ccɣeř. Ta d ict n tewṣeyyet i řebda i nitni i marra jjiřat nsen.’ ");
INSERT INTO rifl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ad asen tinid ɛawed: ‘Kuř aryaz n ayt n Israil u n ibarraniyyen, inni iǧan di řwesṭ nsen, wenni ixsen ad issbexxar ict n tɣarṣt n wecmaḍ niɣ ca n ṭaɣarṣt i ɣares, ");
INSERT INTO rifl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","maca war tt-i-dd-yiwi ɣar wadaf n Uqiḍun n Umsagar, ḥima ad tt issewjed i SIDI, aryaz nni ad ittwaqess zi řgens nnes.’” ");
INSERT INTO rifl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Kuř ijj zi taddart n Israil niɣ zeg ibarraniyyen, inni izeddɣen di řwesṭ nsen, wenni i ɣa iccen idammen mammec ma ggin, Necc ad qeřbeɣ udem inu x řeɛmar nni iccen idammen nni, uca ad t qeḍɛeɣ zi řwesṭ n řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Minzi řeɛmar n arrimet deg idammen uca Necc wciɣ awem idammen x uɛalṭar, maḥend ad zzaysen ittwagg weṣřaḥ i řeɛmur nwem, minzi idammen d ina i ɣa iwyen aṣřaḥ i řeɛmar. ");
INSERT INTO rifl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","X uya aqa nniɣ i ayt n Israil: Uřa d ijj zzaywem war ittett zeg idammen, uřa d abarrani i izeddɣen di řwesṭ nwem war ittett idammen. ");
INSERT INTO rifl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Kuř ijj zeg ayt n Israil u zeg ibarraniyyen i izeddɣen di řwesṭ nwem, wenni iymaren ijj n umuddar niɣ ijj n wejḍiḍ nni izemmar ad ittwacc, ad issizzeř idammen nnes uca ad ten issduriy s ucař. ");
INSERT INTO rifl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Minzi řeɛmar n kuř aysum d idammen nnes, aqa aten d ijjen ak-d řeɛmar nnes. S uyenni nniɣ i ayt n Israil: ‘War ttᵉttem zeg idammen n mammec ma igga weysum!’, minzi řeɛmar n marra aysum d idammen nnes. Wenni zzaysen ɣa iccen, ad ittwaqess zi řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Marra wenni i ɣa iccen zeg ict n řxecbet niɣ zeg ijj n umuddar imezzqen, ma netta zi tarwa n temmurt niɣ netta d ijj n ubarrani, ad iṣebben arruḍ nnes uca ad issird ixef nnes s waman uca ad yiři ixmej ař tameddit. Awarni aya ad yiři izdeg. ");
INSERT INTO rifl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mařa war issird arruḍ u war issird arrimet nnes, xenni ad yarbu řmuɛṣiyyet nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Siweř ak-d ayt n Israil uca ini asen: ‘Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","War tteggem am mammec tteggen di temmurt n Miṣra mani tuɣa tzeddɣem kenniw, u war tᵉtteggem am mammec tteggen di temmurt n Kenɛan mani kenniw ɣa nedheɣ, u war tᵉtteggem ɛlaḥsab tiweṣṣa nsen. ");
INSERT INTO rifl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ad teggem lfarayiḍ inu uca ad teḥḍam tiweṣṣa inu, maḥend ad daysen tuyurem: Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ad teḥḍam tiweṣṣa inu d lfarayiḍ inu: bnadem nni tent itteggen, ad zzaysent iddar, Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Uřa d ijj ad dd-iqarreb ɣar ca n yijjen zi raǧ nnes, ḥima ad issɛarra řɛar nnes: Necc d SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","War ttessɛarri ca řɛar n babac d řɛar n yemmac. Aqa-tt d yemmac, war ttessɛarri ca řɛar nnes. ");
INSERT INTO rifl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Řɛar n temɣart n babac war t ttessɛarri ca. Aqa-t d řɛar n babac. ");
INSERT INTO rifl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","X řɛar n učmac, yeǧis n babac niɣ yeǧis n yemmac, niɣ nettat tᵉttwaxřeq-dd di taddart niɣ barra i taddart, aqa řɛar nnes war t tessɛarri ca. ");
INSERT INTO rifl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","X řɛar n yeǧis n mmic niɣ n yeǧis n yeǧic, war ttessɛarri ca řɛar nsen minzi aqa d řɛar nnec. ");
INSERT INTO rifl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","War ttessɛarri ca řɛar n yeǧis n temɣart n babac, tenni dd-ittwaxeřqen i babac. Aqa-tt d učmac. ");
INSERT INTO rifl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","War ttessɛarri ca řɛar n učmas n babac. Aqa-tt d raǧ n babac. ");
INSERT INTO rifl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","War ttessɛarri ca řɛar n učmas n yemmac, minzi nettat d raǧ n yemmac. ");
INSERT INTO rifl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","War ttessɛarri ca řɛar n umas n babac u war dd-ttqarrabed ɣar temɣart nnes, aqa-tt d ɛentic. ");
INSERT INTO rifl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","War ttessɛarri ca řɛar n temɣart n mmic, aqa-tt d tamɣart n mmic. War ttessɛarri ca řɛar nnes. ");
INSERT INTO rifl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","War ttessɛarri ca řɛar n temɣart n umac, aqa-t d řɛar n umac. ");
INSERT INTO rifl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","War tessɛarri ca řɛar n temɣart d yeǧis. War dd-ttawi ca yeǧis n mmis niɣ yeǧis n yeǧis, maḥend ad tessɛarrid řɛar nnes. Aqa atent d raǧ nnec, aqa-tt d ict n tmeɛmuč ifesden. ");
INSERT INTO rifl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","War dd-ttawi tamɣart d tacna ak-d učmas maḥend ad tt tɣenned ammu, xmi ɣa tessɛarrid řɛar nnes am ɛad teddar. ");
INSERT INTO rifl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","War dd-ttqarrab ca ɣar ict n temɣart xmi ɣa teɛzeř ixef nnes zi ssibbet n řexmej nnes ḥima ad tessɛarrid řɛar nnes. ");
INSERT INTO rifl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","War ttᵉṭṭeṣ ak-d temɣart n jjar nnec, maɣar ammu i ɣa tfesded ixef nnec zzayes. ");
INSERT INTO rifl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","War ttejji arraw nnec ad ẓwan ɣar Mulak, war ssexsara Isem n AREBBI nnec, Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","War ttᵉṭṭeṣ ca ak-d ca n weryaz am tᵉṭṭeṣed ak-d temɣart. Aqa-tt d jjɛifect. ");
INSERT INTO rifl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","War fessed ca ixef nnec ak-d ca n řebhimet am tfeḥḥřed ixef nnec akides, u tamɣart war tᵉttbeddi zzat i řebhimet maḥend ad tfesded ixef nnes zzayes. Aqa d ijj n uxeǧeḍ ifesden. ");
INSERT INTO rifl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","War fessdem ca ixef nwem s marra timesřayin-a, minzi řegnus nni i ɣa ssuffɣeɣ zzat i uɣembub nwem, tuɣa fessden ixef nsen s marra timesřayin-a. ");
INSERT INTO rifl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","S uyenni tedweř temmurt tefsed uca Necc ad as xeǧṣeɣ řmuɛṣiyyet nnes, uca ad tɛuqq temmurt imezdaɣ nnes. ");
INSERT INTO rifl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Maca kenniw ad teḥḍam tiweṣṣa d lfarayiḍ inu, war tteggem uřa d ict n řḥajjet zi marra jjɛayef-a, niɣ wenni zi tarwa n temmurt uřa d abarrani nni izeddɣen di řwesṭ nwem. ");
INSERT INTO rifl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Minzi iryazen n temmurt, inni tuɣa qbeř nwem, aqa ggin marra jjɛayef-a uca ammu i tedweř temmurt tefsed. ");
INSERT INTO rifl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","War ttejji tammurt ad kenniw tɛuqq umi tt tfessdem, am mammec tɛuqq temmurt řgens nni tuɣa din qbeř nwem. ");
INSERT INTO rifl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Minzi marra inni iggin ca zi marra jjɛayef-a, aqa řeɛmur i ɣa iggin ammu, ad ttwaqeḍɛen zi řgens nsen. ");
INSERT INTO rifl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ad teḥḍam min d awem umureɣ, maḥend war tḍeffarem tiweṣṣa yurṣuḍen am mammec tt ggin řegnus qbeř nwem. War zzaysent tfessdem ixef nwem, Necc d SIDI, AREBBI nwem!’” ");
INSERT INTO rifl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Issiweř SIDI ɣar Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Siweř ak-d marra tamesmunt n ayt n Israil uca ini asen: ‘Ittxeṣṣa ad tiřim d imqeddasen, minzi Necc d SIDI, AREBBI nwem, aqa ayi d amqeddas! ");
INSERT INTO rifl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Kuř ijj ad iweqqar yemmas d babas uca ussan inu n ssebt ad ten teḥḍam, Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","War ddikkʷiřem ɣar l’aṣnam u war tteggem i yixef nwem řexyařat ifesyen d irebbiten. Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Xmi ɣa tqeddmen taɣarṣt n řehna i SIDI, xenni ad tt tqeddmem s ijj n webrid i zi ɣa tᵉttwaqebřem s arḍa. ");
INSERT INTO rifl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ittxeṣṣa ad tᵉttwacc deg wass n tɣarṣt nwem uřa di tiwecca awarni as. Min iqqimen ař wass wiss třata ad ittwassecmeḍ s tmessi. ");
INSERT INTO rifl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Mařa tᵉttwacc ɛad deg wass wiss třata, ad tiři d jjɛifect, war tᵉttwaqebbeř s arḍa. ");
INSERT INTO rifl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Wi zzayes ɣa iccen ad yarbu řmuɛṣiyyet nnes, minzi issexsara min iǧan d amqeddas n SIDI uca xenni ad ittwaqess bnadem nni zi řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Mařa temjarem ṣṣabet n temmurt nwem, war mejjar cek iyyar nnec ař aɣezdis aneggar niɣ ad tjemɛed min iqqimen awarni tameyra nnec. ");
INSERT INTO rifl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","War řeqqeḍ uḍiř n umarjeɛ nnec kuřci, war ḥruw marra min din iqqimen di temmurt deg umarjeɛ nnec n uḍiř. Ad tejjed aya i umezřuḍ u i ubarrani, Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","War ttacar u war ssxarriq, uřa d ijj ad icmet jjar nnes. ");
INSERT INTO rifl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","War ttjaǧam ẓur s Yisem inu. War ssexsara Isem n AREBBI nnec. Necc d SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","War ssḥissif jjar nnec niɣ ad t tacared. War ttᵉṭṭef řmunet n icewwařen zi ǧiřet ař tiwecca.    ");
INSERT INTO rifl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","War ttekkʷar adehcur u war ttegg ca min di ɣa inqareḍ udarɣař, maca ittxeṣṣa ad teggʷeded AREBBI, Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ɣar weḥkam war ttɣeccim. War sɛizzi amezřuḍ u war sɛeddu ɣar bu-txuba. Ittxeṣṣa ad tḥekmed x jjar nnec s usegged. ");
INSERT INTO rifl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","War ggur jar řgens nnec s unemmem, war ttbeddi x idammen n jjar nnec, Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","War carreh umac deg wuř nnec. Ad tɛeřmed aɛřam i jjar nnec u war tkessid ddenb xak zi ssibbet nnes. ");
INSERT INTO rifl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","War ttentiqim niɣ ad txemmřed antaqem x tarwa n řgens nnec. Ad texsed jjar nnec amecnaw ixef nnec, Necc d SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Ad teḥḍam tiweṣṣa inu. War ttřeqqam ca řebhimet nnec ak-d ijj n marka nneɣni. War zarreɛ tnayen n markat n zzariɛet deg iyyar nnec u war yarreḍ arruḍ ittwaggen s tnayen n markat n ukettan. ");
INSERT INTO rifl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Mařa aryaz iṭṭeṣ ak-d ict n temɣart, ict n tayya ixḍeb i-tt yijj n weryaz nneɣni, maca war ittwaxeǧeṣ ɛad ttaman nnes n ufekki niɣ temmewc as třelli, xenni ad yiři řeḥsab, maca war ttwaneqqen ca, minzi nettat tuɣa ɛad war tᵉttwaḥar ca. ");
INSERT INTO rifl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Netta ad yawi taɣarṣt n umarwas nnes i SIDI ɣar wadaf n Uqiḍun n Umsagar, ijj n icarri am tɣarṣt n umarwas. ");
INSERT INTO rifl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Akehhan ad xas igg aṣřaḥ s icarri n tɣarṣt n umarwas zzat i wudem n SIDI i ddenb nnes i igga uca ddenb nnes i igga ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Xmi ɣa tawḍem di temmurt uca teẓẓum ɛřam kuř ticejjura, maḥend ad zzaysent teccem, xenni war txettnem ‘řeɛdařyet nnes’, tenni d řɣiǧet nnes. Třata n iseggʷusa war tent txettnem, war zzaysent ttettem ca. ");
INSERT INTO rifl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Deg useggʷas wiss arebɛa ad tiři marra řɣiǧet nnes tqeddes, i usemɣar i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Deg useggʷas wiss xemsa ad teccem řɣiǧet nnes uca ṣṣabet nnes ad tt tewcem i yixef nwem. Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","War ttettem ca ak-d idammen. War iɛeddeř ad tgezznem niɣ ad tceɣřem ixef nwem s tbezgiwt. ");
INSERT INTO rifl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","War ttḥeffim acuwwaf n uzeǧif nwem deg wenneḍ nnes u war ttḍeyyiɛem ca tma n tmart nwem. ");
INSERT INTO rifl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","War iɛeddeř ad tcarḍem arrimet nwem zi ssibbet n yijj n umettin niɣ ad tarecmem tiggaz di arrimet nwem. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","War sdeǧi yeǧic, ad tt tarred d tamɣart n farq-ccɣeř, ḥima war tweṭṭi temmurt di farq-ccɣeř uca xenni ad teccur temmurt s řefḍiḥet. ");
INSERT INTO rifl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ad teḥḍam ussan inu n ssebt uca ad tweqqarem Zzawect inu Iqeddsen. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","War ttdikkwiřem ɣar yinni issawařan ak-d imettan u ɣar igezzanen, war ɣarsen arezzfem, ḥima ad zzaysen tᵉttwaxemjem. Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ad tekkared i wenni ɣar iǧa ucuwwaf icab uca ad tweqqared udem n iwessura uca ad teggʷeded AREBBI nnec. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Xmi kidek ɣa izdeɣ ijj n ubarrani di temmurt nwem, war t ttḍeǧmem. ");
INSERT INTO rifl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Abarrani, wenni ɣarwem izeddɣen, ad awem yiři am yijjen zi tarwa n temmurt nwem. Ad t texsed am yixef nnec, minzi tuɣa kenniw d ibarraniyyen di temmurt n Miṣra. Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Xmi ɣa tiřim ɣar weḥkam war ttɣeccem ca s řeɛbar n tuzzeggart niɣ n ddqeř niɣ s řeɛbar n min dayes. ");
INSERT INTO rifl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ad ɣarwem yiři d ijj n řmizan nican d iẓra n řmizan nican uřa d ijj n ifa nican d ijj n uhinu nican, Necc d SIDI, AREBBI nwem, wenni kenniw dd-issuffɣen zi temmurt n Miṣra. ");
INSERT INTO rifl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ad teḥḍam marra tiweṣṣa d řumur inu uca ad ten teggem. Necc d SIDI!’” ");
INSERT INTO rifl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ad tinid i ayt n Israil: ‘Kuř ijjen zeg ayt n Israil niɣ zeg ibarraniyyen, wenni i ɣa iwcin zeg iḥenjiren nnes i Mulak, ad ittwaneɣ nican. Řgens n temmurt ad t yarjem.    ");
INSERT INTO rifl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Necc ad qeřbeɣ udem inu x weryaz nni uca ad t qeḍɛeɣ zi řgens nnes, minzi netta aqa iwca zi zzariɛet nnes i Mulak. S uyenni tuɣa issexmej Zzawect inu Iqeddsen uca issexsar Isem amqeddas inu. ");
INSERT INTO rifl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Mařa tarwa n temmurt qqnen tiṭṭawin nsen x weryaz nni, xmi ɣa iwc netta zi zzariɛet nnes i Mulak, uca nitni war t neqqen, ");
INSERT INTO rifl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","xenni Necc ad qeřbeɣ udem inu x weryaz nni u x řaǧ nnes uca ad t qeḍɛeɣ zi jar řgens nnes, netta d marra inni issefsaden ixef nsen am ddekkwařen awarni as maḥend ad ssfesden ixef nsen ak-d Mulak.’” ");
INSERT INTO rifl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Bnadem nni i ɣa iqeřben ixef nnes ɣar yinni issawařan ak-d imettan d igezzanen, maḥend ad dewřen awarni asen am ssfesden ixef nsen, Necc ad qeřbeɣ udem inu x bnadem nni uca ad t qeḍɛeɣ zi jar řgens nnes.”   ");
INSERT INTO rifl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Sqeddsem ixef nwem, iřim d imqeddasen, minzi Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ḥḍam tiweṣṣa inu uca ggem zzaysent. Necc d SIDI, wenni kenniw issqeddsen.” ");
INSERT INTO rifl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Maɣar kuř aryaz nni i ɣa ineɛřen x babas niɣ x yemmas, ad ittwaneɣ nican. Inɛeř x babas niɣ x yemmas, idammen nnes aqa aten xas. ");
INSERT INTO rifl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Mařa ijj n weryaz izna ak-d temɣart n weryaz nneɣni, xenni wenni tuɣa izennan ak-d temɣart n jjar nnes ad ittwaneɣ nican, wenni iznan d tenni iznan. ");
INSERT INTO rifl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Mařa ijj n weryaz, am iṭṭeṣ ak-d temɣart n babas, aqa issɛurri řɛar n babas, xenni nitni s tnayen ad ttwanɣen nican. Idammen nsen aqa aten xasen.    ");
INSERT INTO rifl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Mařa ijj n weryaz iṭṭeṣ ak-d temɣart n mmis, xenni nitni s tnayen ad ttwanɣen nican. Aqa ggin ijj n uxeǧeḍ ifesden. Idammen nsen aqa aten xasen.    ");
INSERT INTO rifl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Mařa ijj n weryaz iṭṭeṣ ak-d ijj n weryaz nneɣni am mammec itteṭṭeṣ weryaz ak-d ict n temɣart, xenni aqa nitni s tnayen idsen ggin ict n řefḍiḥet temɣar. Ad ttwanɣen nican. Idammen nsen aqa aten xasen. ");
INSERT INTO rifl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Mařa imeřc ijj n weryaz ca n temɣart uřa d yemmas, aqa-tt d řefḍiḥet. Ad t sscemḍen s tmessi, netta d nitenti s tnayen, ḥima xenni war tᵉttiři ɛad d řefḍiḥet di řwesṭ nwem. ");
INSERT INTO rifl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Mařa ijj n weryaz iṣṣur ixef nnes ak-d ict n řebhimet, xenni ittxeṣṣa ad ittwaneɣ nican. Ittxeṣṣa ɛawed ad tenɣem řebhimet. ");
INSERT INTO rifl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Mařa ca n temɣart tqarreb-dd ɣar ca n řebhimet mammec ma tegga, maḥend ad kides tfeḥḥeř, xenni ad tenɣed tamɣart d řebhimet. Ad ttwanɣen nican. Idammen nsen aqa aten xasen. ");
INSERT INTO rifl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Mařa ijj n weryaz iṭṭef učmas, yeǧis n babas niɣ yeǧis n yemmas, uca iẓra řɛar nnes uca nettat teẓra řɛar nnes, aqa-tt d řefḍiḥet. Ad ttwanɣen s tnayen zzat i tiṭṭawin n tarwa n řgens nsen. Aqa issɛurri řɛar n učmas, ad yarbu řmuɛṣiyyet nnes. ");
INSERT INTO rifl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Mařa ijj n weryaz iṭṭeṣ ak-d ict n temɣart tenni x iǧa idammen uca aqa issɛurri řɛar nnes, issɛurri anu n idammen nnes, uca nettat simant nnes tessɛurri anu n idammen nnes, xenni ad ttwaqeḍɛen s tnayen zi řwesṭ n řgens nsen. ");
INSERT INTO rifl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","War sɛarri ca učmas n yemmac niɣ učmas n babac, minzi xenni issfeṭṭaḥ bnadem řɛar n raǧ nnes. Nitni ad arbun řmuɛṣiyyet nsen. ");
INSERT INTO rifl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Mařa ijj n weryaz, wenni ittᵉṭṭṣen ak-d ɛentis, aqa issɛurri řɛar n ɛemmis, ad arbun nitni řmuɛṣiyyet nsen. Ad mmten břa tarwa.    ");
INSERT INTO rifl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Mařa ijj n weryaz yiwi tamɣart n umas, aqa man aya d aɛeddi x weɛzař n temɣart. Aqa issɛurri řɛar n umas. Ad iřin břa iḥenjiren.’” ");
INSERT INTO rifl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Ḥḍam marra tiweṣṣa inu d marra lfarayiḍ inu uca ggem tent, maḥend war kenniw tᵉttɛuqqi temmurt mani kenniw i ɣa nedheɣ, ḥima ad dayes tzedɣem. ");
INSERT INTO rifl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","War ggurem x tebridt n tweṣṣa n řgens nni ɣa ssuffɣeɣ zzat i wudem nwem, minzi nitni ggin marra timesřayin-a u s uya carrheɣ ten. ");
INSERT INTO rifl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Necc nniɣ awem: Kenniw ad twartem tammurt nsen uca ad awem tt-i-dd wceɣ d řwart, ict n temmurt ifeyyḍen s uɣi d tamment. Necc d SIDI, AREBBI nwem, wenni kenniw ifarzen zi jar řegnus. ");
INSERT INTO rifl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","X uya kenniw ad tmeyyzem jar řebhayem n řeḥřař d yinni ixemjen u jar ijḍaḍ ixemjen d yinni n řeḥřař. War ssexsaram řeɛmuř nwem ak-d ca n řebhimet niɣ ak-d ca n wejḍiḍ niɣ ak-d ca zi marra min ittbuɛen x temmurt, marra min d awem ḥarrmeɣ, ḥima ad t tḥesbem d řexmej.” ");
INSERT INTO rifl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","“Aqa kenniw ad ayi tiřim d imqeddasen, minzi Necc d SIDI d amqeddas uca Necc farzeɣ kenniw zi řegnus, ḥima ad tiřim inu. ");
INSERT INTO rifl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Mařa ijj n weryaz niɣ ict n temɣart ɣares buḥbeř n uɛezzem n imettan niɣ n tgezzant, xenni ad ttwanɣen nican. Ad ten arejmen. Idammen nsen aqa aten xasen.” ");
INSERT INTO rifl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Inna SIDI i Musa: “Siweř ak-d ikehhanen, arraw n Harun, uca ini asen: ‘War iɛeddeř i uřa d ijj zzaywem ad issexmej ixef nnes s ijj n umettin jar řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","mɣir s raǧ nnes yudsen, s yemmas niɣ s babas niɣ s mmis niɣ s yeǧis niɣ s umas. ");
INSERT INTO rifl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Uřa s učmas nni d taɛzarct, tenni d řaǧ nnes yudsen u war ɣares tuɣi weryaz, aqa iɛeddeř ad zzayes issexmej ixef nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Bab n taddart war issxemmaj ixef nnes jar řgens nnes. S uya ittwaf issexsar ixef nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“War tteggen ca n wemcan iquccar x izeǧif nsen, u war ttḥeffin ṭṭarf n tmart nsen u war carrḍen acarreḍ deg weysum nsen. ");
INSERT INTO rifl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ad iřin d imqeddasen i AREBBI nsen uca war feṭṭḥen Isem n AREBBI nsen, minzi aqa d nitni i ittawyen tiwhibin n tmessi ɣar AREBBI, tinni d macca n AREBBI nsen. S uya ad iřin d imqeddasen. ");
INSERT INTO rifl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","War iɛeddeř ad awyen tamɣart nni iǧan d lfasda niɣ icten tᵉttwaɣṣeb. Uřa d ict n temɣart nni ittwaǧfen zeg weryaz nnes, war tt ttiwyen, minzi akehhan d amqeddas i AREBBI nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ad t tḥesbed d amqeddas, minzi netta ittawi macca n AREBBI nnec. Ad yiři d amqeddas i cek, minzi Necc d amqeddas, Necc d SIDI wenni kenniw issqeddsen.” ");
INSERT INTO rifl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Mařa yeǧis n ijj n weryaz nni iǧan d akehhan tessefḍeḥ ixef nnes s farq-ccɣeř nnes, xenni aqa tessefḍeḥ babas uca ittxeṣṣa as ad tᵉttwassecmeḍ s tmessi.” ");
INSERT INTO rifl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Arrays n ikehhanen jar aytmas, wenni x uzeǧif nnes tᵉttwafarreɣ zzect n wedhan u wenni ittwařeqqmen, maḥend ad yarḍ arruḍ n ukehhan, netta war izemmar ad iḍřeq i ucuwwaf x uzeǧif nnes niɣ ad icarreg arruḍ nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","War iɛeddeř ad dd-iqarreb ɣar ijj n umettin, ɛad s babas d yemmas war iɛeddeř ad issexmej ixef nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","War itteffeɣ zi Zzawect Iqeddsen, ḥima war issexsara Zzawect Iqeddsen n AREBBI, minzi ttaj n weɛzař n zzect n wedhan n AREBBI nnes aqa-t xas. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ad yawi ict n teɛzarect d tamɣart. ");
INSERT INTO rifl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","War ittiwi tajjač niɣ taneǧaft niɣ tenni ittwaɣeṣben d tamɣart, maca ad yawi ict n teɛzarect zi řgens nnes d tamɣart. ");
INSERT INTO rifl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","War issexsara zzariɛet nnes jar řgens nnes, minzi Necc d SIDI, wenni t issqeddsen.” ");
INSERT INTO rifl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Siweř ak-d Harun, ini: ‘Uřa d ijj zi zzariɛet nnec di marra jjiřat nsen i di iǧa ca n uneɛḍab, ad dd-iqarreb, ḥima ad yawi macca n tewhibt n AREBBI nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Minzi uřa d ijj n weryaz war dd-ittqarrib ca s yijj n řɛib, ma d adarɣař i iǧa niɣ d aqidar niɣ s ca war iḥři niɣ ɣares ṣṣifet tfarɣ ");
INSERT INTO rifl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","niɣ ijj n weryaz yarẓ as uḍar niɣ afus ");
INSERT INTO rifl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","niɣ bu-teɛrurt niɣ ḥed yařwes di ca n yijj n ttejjař niɣ s ict n tiṭṭ tuff niɣ s jdam niɣ s ict n ccamet texsar niɣ s iqeǧařen idgedgen. ");
INSERT INTO rifl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","War iɛeddeř i uřa d ijj n weryaz zi zzariɛet n ukehhan Harun, wenni di iǧa ca n řɛib, ad ireḥḥeg, maḥend ad iqeddem tiwhibin n tmessi n SIDI. Aqa dayes aneɛḍab, war izemmar ad iffeɣ maḥend ad iqeddem macca n tewhibt n AREBBI nnes. ");
INSERT INTO rifl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Zi macca n tewhibt n AREBBI nnes iɛeddeř ad zzayes yecc, am zi min iǧan iqeddsen qaɛ am zi min iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Maca war iɛeddeř ad dd-iqarreb ɣar uřeḥḥaf uřa ɣar uɛalṭar, minzi dayes ict n uneɛḍab, ḥima war issexsara Tizawiyyin Iqeddsen inu, minzi Necc d SIDI wenni ten issqeddsen.’” ");
INSERT INTO rifl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ammu i issiweř Musa ak-d Harun u ak-d warraw nnes u ak-d marra ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Siweř ak-d Harun u ak-d warraw nnes, maḥend, mařa ittxeṣṣa, war ttakkwaḍen ɣar tewhibin iqeddsen n ayt n Israil tinni d ayi ssqeddsen, ḥima war ssexsaran Isem amqeddas inu. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ini asen: ‘Marra aryaz zi zzariɛet nwem di marra jjiřat nwem, wenni dd ɣa iqarrben ɣar tewhibin iqeddsen, tinni ssqeddsen ayt n Israil i SIDI, am ixmej netta, aqa ad ittwaqess řeɛmar nni zi zzat i wudem inu. Necc d SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Uřa d ijjen zi zzariɛet n Harun nni di iǧa řbarṣ niɣ wenni ɣar iǧa useyyeř, war ittett zi tewhibin iqeddsen ař ɣa yiři izdig. Wenni iḥadan ca zi min ittwassxemjen s ijj n umettin niɣ s ijj n weryaz nni tuɣa s useyyeř n waǧu, ");
INSERT INTO rifl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","niɣ s ijj n weryaz nni iḥadan ca min ittbuɛen i zi idweř ixmej, niɣ iḥada ijj n bnadem i zi idweř ixmej s mammec ma tegga texmuji nnes, ");
INSERT INTO rifl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","řeɛmar nni iḥadan tmesřact niɣ bnadem nni ad yiři ixmej ař tameddit, war ittett zi tewhibin iqeddsen, mɣir awarni i ɣa issird arrimet nnes s waman. ");
INSERT INTO rifl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Xmi dd ɣa teɣři tfuct, ad yiři izdig. Awarni aya ad yecc zi tewhibin iqeddsen, minzi aqa atent d macca nnes. ");
INSERT INTO rifl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","War ittett zeg ict n řxecbet niɣ zeg ijj n umuddar imezzqen, minzi zzayes i ɣa issexmej ixef nnes, Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ad ḥḍan min xef ten weṣṣiɣ, ḥima war ssarebbun x yixef nsen ddenb u xenni ad zzayes mmten, xmi ɣa ssɛiǧten aya. Necc d SIDI wenni ten issqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Uřa d ijj n ubarrani war ittett zi tewhibt iqeddsen. Amɛezzeb i izeddɣen jar ikehhanen uřa d acewwař war ttᵉtten zi tewhibt iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Maca mařa akehhan isɣa ijj n bnadem s nnuqart nnes, aqa iɛeddeř i wa maḥend ad yecc zi macca n tewhibt nnes, uřa i yinni dd-ittwaxeřqen di taddart nnes. ");
INSERT INTO rifl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Mařa yeǧis n ukehhan tedweř d tamɣart n ijj n ubarrani, war tᵉttett ca zi tewhibt i dd-ittwassgeɛɛden zi tewhibin iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Maca mařa yeǧis n ukehhan aqa-tt d tajjač niɣ tᵉttwaǧef zeg weryaz nnes uca war ɣares aḥenjir uca tedweř-dd ɣar taddart n babas, am di temẓi nnes, xenni ad tecc zi macca n tewhibt n babas, maca uřa d ijj n ubarrani ad zzayes yecc. ");
INSERT INTO rifl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Mařa ca n yijjen icca zi tewhibt iqeddsen s uweddar, xenni ad ɣares yarni tasɣart n texmusect uca ad yarr tawhibt iqeddsen ɣar ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","War iɛeddeř ad ssexsaren tiwhibin iqeddsen n ayt n Israil, tinni ssgeɛɛden nitni ɣar SIDI, ");
INSERT INTO rifl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ařami i ɣa ssarbun amarwas n řmuɛṣiyyet x ayt n Israyil, umi ɣa ccen nitni zi tewhibin nsen iqeddsen i d yawyen nitni s yixef nsen, minzi Necc d SIDI, wenni ten issqeddsen.’” ");
INSERT INTO rifl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Issiweř SIDI ak-d Musa inna: ");
INSERT INTO rifl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Siweř ak-d Harun d warraw nnes u ak-d marra ayt n Israil uca ini asen: ‘D man aya iggur i kuř ijjen zi taddart n Israil u i ibarraniyyen di Israil, wenni i ɣa yiwyen tawhibt nnes tenni dd-yusin ak-d marra řewɛud nsen d marra tiwhibin nsen nni wcin s řxaḍar, tenni qeddmen nitni d taɣarṣt n wecmaḍ i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Maḥend ad kenniw yarr ad tiřim tᵉttwaqebbřem ittxeṣṣa ad tiři tewhibt d ijj n wewtem icnan qaɛ zeg ifunasen niɣ zeg izmaren niɣ zeg icarriyyen. ");
INSERT INTO rifl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","War iɛeddeř ad tqeddmem ca n řmař dayes aneɛḍab, minzi aya war kenniw dd-ittarri ad daywem ittwaf arḍa. ");
INSERT INTO rifl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Mařa ijj n weryaz iqeddem ict n tɣarṣt n řehna ɣar SIDI, maḥend ad ikemmeř ijj n lwaɛd niɣ am yict n tewhibt s řxaḍar, xenni ad tiři taɣarṣt d ijj n umuddar icnan qaɛ zi řebhayem niɣ zeg wuǧi, ḥima ad dayes ittwaf arḍa. War iɛeddeř ad dayes yiři uřa d ijj n řɛib. ");
INSERT INTO rifl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Min iǧan d adarɣař niɣ min ittwarẓen niɣ min di iǧan ijj n uyezzim yarezmen niɣ min di ǧant tfiḍřiwin niɣ jdam niɣ ccamet texsar war t-i-dd-tessqarrabem ca ɣar SIDI uca war zzayes ttiwyem tawhibt n tmessi i SIDI x uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Maca ijj n ufunas niɣ ijjen zeg wuǧi i iqebḥen zi ssibbet n tuzzeggart niɣ tuquḍeḍt aṭṭas, iɛeddeř ad t-i-dd-tesswejded am yict n tewhibt s řxaḍar, maca war dayes ittwaf arḍa i yijj n lwaɛd. ");
INSERT INTO rifl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Min idgeddgen, min iřebzen, min imezzqen, min ittwaqessen war t ttiwyem ɣar SIDI, war tteggem aya di temmurt nwem. ");
INSERT INTO rifl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Zeg ufus n mmis n ubarrani war ttqeddamem ca zi marra man aya uřa d ict n tewhibt d macca i AREBBI, minzi dayes řɣecc nsen uřa d nneqṣan nnes, man aya war ittwaqebbiř ca di ṭṭweɛ nwem.’” ");
INSERT INTO rifl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Xmi dd-ixeǧeq ufunas niɣ izmar niɣ iɣayḍ, xenni ad yiři sadu ḥeṭṭu n yemmas sebɛa n wussan. Zeg wass wiss tmenya u awarni as ad iṣřeḥ i yarḍa am tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","War iɛeddeř ad tɣarṣed i ufunas niɣ i yijjen zeg wuǧi ak-d mmis deg wass d ijj. ");
INSERT INTO rifl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","X minni texsem ad tqeddmem tawhibt n uqadi i SIDI, qeddem xenni min iṣeřḥen i yarḍa nwem. ");
INSERT INTO rifl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ad tᵉttwacc deg wass nni nnit. War zzayes ttejjim ca ař ṣṣbeḥ. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Ad teḥḍam tiweṣṣa inu uca ad zzaysent teggem. Necc d SIDI! ");
INSERT INTO rifl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","War ssexsaram Isem inu iqeddsen, ḥima Necc ad ttwaqeddseɣ di řwest n ayt n Israil. Necc d SIDI, wenni kenniw issqeddsen, ");
INSERT INTO rifl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","d wenni kenniw dd-issuffɣen zi temmurt n Miṣra, ḥima ad iřiɣ d AREBBI i kenniw. Necc d SIDI!’” ");
INSERT INTO rifl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Siweř ak-d ayt n Israil uca ini asen: ‘Řeɛyudat ittwaggen n SIDI, inni x ɣa tbarrḥem, ad iřin d imuniten iqeddsen, aqa atent d řeɛyudat inu ittwaggen. ");
INSERT INTO rifl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Setta n wussan ad txedmem, maca deg wass wiss sebɛa ad yiři d ssebt, arraḥet imun, ijj n umuni iqeddsen. Ittxeṣṣa war dayes txeddmem. Aqa d ssebt i SIDI di marra tizeddiɣin nwem. ");
INSERT INTO rifl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Aqa d ina d řeɛyudat ittwaggen n SIDI, imuniten iqeddsen, inni i ɣa tbarrḥem deg wussan nsen ittwaggen. ");
INSERT INTO rifl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Deg uyur amezwaru, deg wass wiss arbeɛṭac n uyur, jar beddu n wezyen n wass ař dd-tewḍa tmeddit, ad tiři d Tɣarṣt n Useɛdu n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Deg wass wiss xemmesṭac n uyur nnit, ad yiři d Řɛid n Weɣrum břa Antun i SIDI. Sebɛa n wussan ad teccem aɣrum břa antun. ");
INSERT INTO rifl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ass amezwar ad teggem ijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Sebɛa n wussan kemmřen ad tawyem ict n tewhibt n tmessi i SIDI uca deg wass wiss sebɛa ad din yiři ijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg.’” ");
INSERT INTO rifl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Siweř ak-d ayt n Israil, ini asen: ‘Mařa tiwḍem ɣar temmurt nni d awem ɣa wceɣ uca ad temjarem ṣṣabet nnes, xenni ad tawyem ict n tqebbiḍt zi tmezwarut n ṣṣabet nwem ɣar ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Uca netta ad issenhezz taqebbiḍt nni zi ssa ɣar da zzat i wudem n SIDI, maḥend ad tᵉttwaqebřem s arḍa. Di tuffut awarni ssebt ad tt issenhezz ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Deg wass min di i ɣa tenhezzem taqebbiḍt, ad tesswejdem ɛawed ijj n izmar icnan qaɛ n ijj n useggʷas am yict n tɣarṣt n wecmaḍ i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ad tiři tewhibt n řɣiǧet zi tnayen n teɛcuray n ijj n ifa n waren azdad ixeǧḍen s zzect, aqa-tt d ict n tewhibt n tmessi s ict n řefwaḥet ittfuḥen i SIDI, u tawhibt nnes n useyyeb ad tiři d binu, ijj n arbeɛ zeg ijj n uhinu. ");
INSERT INTO rifl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","War ttᵉttem aɣrum uřa d tidrin yurfen niɣ tizizawin ař ass min di dd-tiwyem tawhibt nwem ɣar AREBBI. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem mani ma tzeddɣem. ");
INSERT INTO rifl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Awarni as ad tḥesbem s řmeqřub i yixef nwem zi ṣṣbeḥ awarni i ssebt, zeg wass min di dd-tiwyem taqebbiḍt n tewhibt n wenhezzi: ittxeṣṣa ad iřin sebɛa n wussan n ssebt kemmřen. ");
INSERT INTO rifl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ad tḥessbem xemsin n wussan ař tuffut n ssebt wiss sebɛa. Xenni ad tawyem ict n tewhibt n řɣiǧet n jdid i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ad dd-tawyem tnayen n tecnifin n weɣrum i wenhezzi zeg imucan mani tzeddɣem. Ad iřint zi tnayen n teɛcuray n yijj n ifa n waren azdad, ggwint s wentun. Aqa atent d timenza i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kenniw ad dd-tessqarrbem ak-d weɣrum ɛawed sebɛa n izmaren cnan qaɛ n ijj n useggʷas d ijj n ufunas - ameẓyan n tfunast - d tnayen n icarriyyen. Ad iřin i tɣarṣt n wecmaḍ i SIDI ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb, aqa d ict n tewhibt n tmessi s ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ad tesswejdem ɛawed ijj n umyan zeg iɣayḍen d taɣarṣt n ddenb u tnayen n izmaren n ijj n useggʷas d tɣarṣt n řehna. ");
INSERT INTO rifl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Ad ten issenhezz ukehhan ak-d weɣrum n tamenzut zi ssa ɣar da am yict n tewhibt n wenhezzi zzat i wudem n SIDI, uřa d tnayen n izmaren. Ad iřin qeddsen i SIDI, i ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Deg wass nnit ad tbarrḥem i yijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. Aqa-tt d ict n tewṣeyyet i řebda mani ma i ɣa tzedɣem i marra jjiřat nwem. ");
INSERT INTO rifl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Xmi ɣa temjarem řɣiǧet n temmurt nwem, war mejjar ař aneggar n ṭṭarf n yeyyar nnec, u min iqqimen n řɣiǧet nnec war t tkessed ca. Ittxeṣṣa ad tejjem cwayt i umezřuḍ u i ubarrani. Necc d SIDI, AREBBI nwem!’” ");
INSERT INTO rifl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Siweř ak-d ayt n Israil, ini asen: ‘Deg uyur wiss sebɛa, deg wass amezwaru n uyur, ad yiři d ssebt i kenniw, ijj n wass n řidaret ak-d usuḍi s wesruddeḥ deg uyicc n icarri, ijj n umuni iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. Ad dd-tesqarrbem ict n tewhibt n tmessi i SIDI.’” ");
INSERT INTO rifl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Deg wass wiss ɛecra n uyur wiss sebɛa ad yiři d Ass n Weṣřaḥ. Ad teggem ijj n umuni iqeddsen i kenniw. Ad tesswaḍɛem ixef nwem uca ad tqeddmem ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","War tteggem uřa d ict n řxedmet deg wass nni nnit, minzi aqa-t d Ass n Weṣřaḥ, maḥend ad ittwagg weṣřaḥ i kenniw zzat i wudem n SIDI, AREBBI nwem. ");
INSERT INTO rifl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Minzi marra bnadem nni war isswaḍɛen ixef nnes deg wass nni nnit, ad ittwaqess zi řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kuř bnadem nni i ɣa iggin ca n řxedmet deg wass nni nnit, Necc ad teḥḥiɣ bnadem nni zi řwesṭ n řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","War tteggem uřa d ict n řxedmet. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem mani ma i ɣa tzedɣem. ");
INSERT INTO rifl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ad yiři d ijj n ssebt n arraḥet tmun i kenniw. Ad iřin řeɛmur nwem ḥṣaren. Deg wass wiss tesɛa n uyur, di ǧiřet, zeg uɛecci ɣar uɛecci nneɣni ad teḥḍam arraḥet nwem n ssebt.” ");
INSERT INTO rifl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Siweř ak-d ayt n Israil uca ini: ‘Deg wass wiss xemmesṭac n uyur wiss sebɛa ad yiři d Řɛid n Iɛuccuten i SIDI, sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Deg wass amezwaru ad yiři yijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sebɛa n wussan ad tqeddmem tiwhibin n tmessi ɣar SIDI. Deg wass wiss tmenya ad din yiři yijj n umuni iqeddsen uca ad tawyem ict n tewhibt n tmessi i SIDI. Aqa d ijj n umuni ifarzen d amqeddes, war tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Tina d řeɛyudat ittwaggen n SIDI, tinni zi ɣa tbarrḥem d imuniten iqeddsen, maḥend ad tqeddmem ict n tewhibt n tmessi ɣar SIDI, ict n tɣarṣt n wecmaḍ d ict n tewhibt n řɣiǧet, ict n tewhibt i tɣarṣt d tewhibin n useyyeb, kuř ass min ittwaggen i wass nni, ");
INSERT INTO rifl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","barra i tɣarṣa nwem n wussan n ssebt n SIDI d tewhibin nwem n lwuɛud nwem d tewhibin nwem s řxaḍar, inni tᵉttnumem ad tent tewcem i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Maca deg wass wiss xemmesṭac n uyur wiss sebɛa, xmi ɣa tessmunem řɣiǧet n temmurt, xenni ad tɛeyydem Řɛid n SIDI, sebɛa n wussan. Deg wass amezwaru ad yiři yijj n wass n ssebt uřa deg wass wiss tmenya ad din yiři yijj n wass n ssebt. ");
INSERT INTO rifl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Deg wass amezwaru ad teksim řɣiǧet n tcejjura icewwaren: tiseḍwin n tini d tiseḍwin n tcejjura s tefray aṭṭas d tseḍwin n tcejjart n tnemřač n tɣezratin. Sebɛa n wussan ad tfarḥem zzat i wudem n SIDI, AREBBI nwem. ");
INSERT INTO rifl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ad tɛeyydem Řɛid n Iɛuccuten sebɛa n wussan deg useggʷas i SIDI. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem. Ad t tɛeyydem deg uyur wiss sebɛa. ");
INSERT INTO rifl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ad tzedɣem sebɛa n wussan deg iɛuccuten. Marra inni dd-ittwaxeřqen di Israil ad zedɣen deg iɛuccuten, ");
INSERT INTO rifl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ḥima ad ssnen marra jjiřat nwem, belli Necc ggiɣ ad zedɣen ayt n Israil deg iɛuccuten, umi ten ssuffɣeɣ zi temmurt n Miṣra. Necc d SIDI, AREBBI nwem!’” ");
INSERT INTO rifl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ammu i issiweř Musa ak-d ayt n Israil x řeɛyudat ittwaggen n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Umur ayt n Israil maḥend ad ac dd-awyen i tfawt zzect iṣfan ttwaddzen tt-i-dd zi zzitun, ḥima ad tejjem tafawt tareqq řebda. ");
INSERT INTO rifl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Harun ad tt isettef řebda zzat i wudem n SIDI zi ǧiřet ař ṣṣbeḥ zzat n uřeḥḥaf n Cchadet deg Uqiḍun n Umsagar. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem. ");
INSERT INTO rifl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ittxeṣṣa as ad isettef řebda tiftiřin n tfawin i iǧan x řqendiř izdigen zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ad teksid waren azdad uca ad zzayes tᵉssenggʷed tenɛac n řemsemnat. Ict n temsemmemt ad tiři zi tnayen n teɛcurin n yijj n ifa n waren azdad. ");
INSERT INTO rifl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ad tent tegged di tnayen n isettifen, setta deg ijj n usettif x tzewḍa izdigen zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ad tegged x kuř asettif jjawi iṣfan nni ɣa yiři i řidaret ak-d weɣrum. Aqa-tt d ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Di kuř ass n ssebt ad isettef aya řebda zzat i wudem n SIDI di ṭṭweɛ n ayt n Israil. Aqa-t d ijj n Řɛahd i řebda. ");
INSERT INTO rifl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ad yiři weɣrum i Harun d warraw nnes, inni t ɣa iccen deg wemcan amqeddas, minzi i netta i iǧa uya d amqeddas qaɛ zi tewhibin n tmessi n SIDI. Aqa-tt d ict n tewṣeyyet i řebda.” ");
INSERT INTO rifl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Mmis n ict n temɣart Tisra’ilect teffeɣ ɣar barra. Netta tuɣa-t d mmis n ijj n weryaz d Amiṣri izeddɣen jar ayt n Israil. Mmis n temɣart-a Tisra’ilect u ijj n weryaz Israyili mmenɣen ak-d wayawya di řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mmis n temɣart Tisra’ilect iceqqef deg Yisem uca ikkʷar. Xenni iwyen t ɣar Musa. Yemmas, qqaren as Cilumiya, yeǧis n Dibri, zi teqbič n Dan. ");
INSERT INTO rifl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ggin ad xas ḥḍan ařami d asen i ɣa immeř min i ɣa ggen zeg uqemmum n SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Uca issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Suffeɣ wenni ineɛřen barra i řmargeḥ n řɛeskar uca ejj marra inni d as isřin ad ssarsen ifassen nsen x uzeǧif nnes. Xenni ad t tarjem tmesmunt am tekmeř. ");
INSERT INTO rifl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ad tessiwřed ak-d marra ayt n Israil uca ad asen tinid: ‘Kuř aryaz i ɣa ineɛřen AREBBI, ad yarbu ddenb nnes. ");
INSERT INTO rifl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Wenni ittceqqafen deg Yisem n SIDI, ad ittwaneɣ nican!’ Marra tamesmunt ad t tarjem. Ad ittwaneɣ ubarrani uřa d wenni dd-ittwaxeřqen di temmurt mařa ittceqqef deg Yisem.” ");
INSERT INTO rifl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Mařa ijj n weryaz inɣa řeɛmar n ca n bnadem nneɣni, xenni ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Maca wenni inɣin řeɛmar n ict n řebhimet, ad yarr řeɛmar s řeɛmar. ");
INSERT INTO rifl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Mařa ijj n weryaz issyizem jjar nnes, xenni ad zzayes ggen am mammec igga netta: ");
INSERT INTO rifl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","tareẓẓit s tareẓẓit, tiṭṭ s tiṭṭ, tiɣmest s teɣmest. Anect issyizzem netta ijj n bnadem, ammu i d as ɣa ggen ɛawed. ");
INSERT INTO rifl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Wenni inɣin ict n řebhimet, ad tt yarr, u wenni inɣin ijj n bnadem, ad ittwaneɣ simant nnes. ");
INSERT INTO rifl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ad ɣarwem yiři d ijj n uzerf i ubarrani am i wenni dd-ixeřqen di temmurt, minzi Necc d SIDI, AREBBI nwem!” ");
INSERT INTO rifl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Xenni inna Musa i ayt n Israil ad ssuffɣen wenni tuɣa ineɛɛřen barra i řmargeḥ n řɛeskar, ḥima ad t arejmen. Uca ayt n Israil ggin am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Issiweř SIDI ak-d Musa x wedrar n Sina, inna: ");
INSERT INTO rifl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Siweř ak-d ayt n Israil uca ini asen: ‘Xmi ɣa tawḍem ɣar temmurt nni d awem ɣa wceɣ, xenni ad tareyyeḥ temmurt, ijj n wareyyeḥ n ssebt i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Setta n iseggʷusa ad tzarɛed iyyar nnec uca setta n iseggʷusa ad tezbared tizayarin n umarjeɛ nnec uca ad tessmuned řɣiǧet nnes, ");
INSERT INTO rifl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","maca deg useggʷas wiss sebɛa ad tiři ict n arraḥet n ssebt i temmurt, ijj n ssebt i SIDI. War tzarrɛed ca iyyar nnec u war tzebbared ca tizayarin n umarjeɛ nnec. ");
INSERT INTO rifl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Min dd-iɣemmyen amenni waha, war t mejjarem u aḍiř war t zebbarem zi tzayart nnec i war ittwiḥidin. Ad yiři d ijj n useggʷas n ssebt i temmurt. ");
INSERT INTO rifl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ṣṣabet n arraḥet n ssebt n temmurt nnec ad awem tiři d macca, i cek, i yismeɣ nnec, i tayya nnec, i ucewwař nnec uřa i umɛezzeb nnec, inni akidek izeddɣen am yibarraniyyen. ");
INSERT INTO rifl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ṣṣabet nnes marra ad tiři d macca i řebhayem u i řmař nni iǧan di temmurt nnec.’” ");
INSERT INTO rifl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Ad tḥessbem kenniw ɛawed sebɛa n ssimanat n iseggʷusa, sebɛa wwet i-tt di sebɛa n iseggʷusa, maḥend ad awḍen wussan n sebɛa n simanat n iseggʷusa munen ɣar tesɛa u-rebɛin n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Xenni deg uyur wiss sebɛa, deg wass wiss ɛecra n uyur, ad tejjed asuḍi deg uyicc n icarri ad ittekk x temmurt nwem s wesruddeḥ. Deg Wass n Weṣřaḥ ad tejjem ad ittekk usuḍi deg uyicc n icarri x marra tammurt nwem. ");
INSERT INTO rifl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ad tessqeddsem aseggʷas n useggʷas wiss xemsin. Ad tbarrḥem s třelli i marra imezdaɣ di marra tammurt. Ad yiři d ijj n useggʷas n usřiwřew i kenniw uca ad dd-iɛqeb kuř aryaz ɣar wagřa nnes u ɣar raǧ nnes. ");
INSERT INTO rifl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Aseggʷas n useggʷas wiss xemsin ad awem yiři d ijj n useggʷas n usřiwřew. War tzarrɛem u war tmejjarem min dd-iɣemmyen amenni waha, u war tzebbarem ca zi tzayart war ittwiḥidin, ");
INSERT INTO rifl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","minzi aqa d aseggʷas n usřiwřew! Aqa tzemmarem ad teccem řɣiǧet n yeyyar. ");
INSERT INTO rifl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Deg useggʷas-a n usřiwřew ad dd-iɛqeb kuř ijjen ɣar wagřa nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“Meřmi cek ɣa tezzenzed ca i jjar nnec niɣ mařa tesɣid ca zeg ufus n jjar nnec, war iɛeddeř uřa d ijjen ad iɣebben wenneɣni. ");
INSERT INTO rifl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ɛlaḥsab řqedd n iseggʷusa zeg wami iǧa useggʷas n usřiwřew ad tesɣed tammurt zi jjar nnec u ɛlaḥsab řqedd n iseggʷusa n ṣṣabet ad kik yegg tamenziwt. ");
INSERT INTO rifl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ma aqa dinni ɛad aṭṭas n iseggʷusa ɣar zzat, xenni ad tarnid di ttaman n tmesɣiwt nnes u mařa aqa dinni ɛad drus n iseggʷusa ɣar zzat, xenni ad tessneqṣem di ttaman n tmesɣiwt nnes, minzi netta ad ac tt izzenz ɛlaḥsab řqedd n iseggʷusa n ṣṣabet. ");
INSERT INTO rifl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","War ittɣebbi ḥed jjar nnes. Ggʷed AREBBI nnec, minzi aqa Necc d SIDI, AREBBI nwem!” ");
INSERT INTO rifl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Ḍfarem tiweṣṣa inu, ḥḍam lfarayiḍ inu uca ggem zzaysent, ad tzedɣem xenni di temmurt di řaman. ");
INSERT INTO rifl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tammurt ad tewc řɣiǧet nnes u kenniw ad zzayes teccem ař ɣa tejjiwnem uca ad din tzedɣem di řaman. ");
INSERT INTO rifl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Uca mařa tennim: ‘Min ɣa necc deg useggʷas wiss sebɛa? Xzar, war nzemmar ad nzarreɛ u war nzemmar ad nessmuni ṣṣabet nneɣ!’, ");
INSERT INTO rifl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","xenni deg useggʷas wiss setta Necc ad awem dd-ssekkeɣ lbaraka inu ḥima tammurt ad tewc rɣiǧet i třata n iseggʷusa. ");
INSERT INTO rifl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Deg useggʷas wiss tmenya ad tzarɛem ɛawed. Uca ad teccem zi ṣṣabet taqdimt ař aseggʷas wiss tesɛa. Ař i ɣa tiři ṣṣabet nnes n jdid, ad teccem ɛad zi ṣṣabet taqdimt.” ");
INSERT INTO rifl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Tammurt war tᵉttmenzi i řebda, minzi tammurt aqa-tt Inu uca kenniw xenni d ibarraniyyen d imeɛzab ɣari. ");
INSERT INTO rifl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","S uya ittxeṣṣa kenniw ad tewcem ttesriḥ maḥend ad ifdi tammurt di marra tammurt i ɣarwem iǧan d wagřa. ");
INSERT INTO rifl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Mařa umac iẓřeḍ uca izzenz ca zeg wagřa nnes, ad dd-yas umefdi nnes, řaǧ nnes yudsen, maḥend ad ifdi min izzenz umas. ");
INSERT INTO rifl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Mařa aryaz war ɣares bu umefdi, maca afus nnes izemmar ad yaf min icfan, maḥend ad t ifdi, ");
INSERT INTO rifl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","xenni ad iḥseb iseggʷusa zeg wami tᵉttwammenz temmurt uca ad ixeǧeṣ min iqqimen i weryaz umi tt izzenz uca ad tt-i-dd-yarr ɣar wagřa nnes. ");
INSERT INTO rifl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mařa afus nnes war yufi řqedd, ḥima ad as dd-yarr min tuɣa izzenz, xenni min tuɣa izzenz ad iqqim deg ufus n wenni t isɣin ař aseggʷas n usřiwřew. Maca deg useggʷas n usřiwřew ad ittwafekk man aya uca ad t-i-dd-yarr ɣar wagřa nnes.” ");
INSERT INTO rifl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Mařa ca n yijjen izzenz taddart nnes deg ict n tendint umi dd-nnḍen s weɣbar xenni iɛeddeř ad yiři ufekki nnes ař d iɛdu ijj n useggʷas am ikmeř zi tmenziwt nnes. Marra ussan nni iɛeddeř ad tt ifdi. ");
INSERT INTO rifl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Maca mařa war tᵉttwafdi di řmijař n ijj n useggʷas, xenni taddart di tendint nni dd-innḍen s weɣbar, ad tiři řebda i wenni tt isɣin, i marra jjiřat nnes. War tᵉttwafekk deg useggʷas n usřiwřew. ");
INSERT INTO rifl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Maca tudrin nni n ředcur i umi war dd-inniḍ řeɣbar ad ttwaḥesbent am yijj n yeyyar n temmurt. Danita izemmar ad yiři řḥeqq n ufekki uca ad ittwafekk yeyyar deg useggʷas n usřiwřew. ");
INSERT INTO rifl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","X tneddam n Ilawiyyen, tudrin di tneddam n wagřa nsen, aqa Ilawiyyen ɣarsen řḥeqq i řebda ḥima ad tent fdin. ");
INSERT INTO rifl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Mařa ca n yijjen ifda i-tt zeg ufus n Ilawiyyen, xenni ad tᵉttwafekk taddart i immenzen i ijjen i war iǧin zeg Ilawiyyen, tenni iǧan di tendint n wagřa nnes, deg useggʷas n usřiwřew, minzi tudrin n tneddam n Ilawiyyen aqa atent d agřa nsen di řwesṭ n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Iyyar nni iqqnen ɣar tneddam, war ittmenzi, minzi aqa-t d agřa nsen i řebda.” ");
INSERT INTO rifl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Mařa umac iẓřeḍ uca ifassen nnes bdan ad arjijen din ɣarek, xenni ittxeṣṣa ad t-i-dd-tsennded maḥend ad ibedd, uřa d abarrani niɣ d amɛezzeb, maḥend ad iqqim ad ɣarek iddar. ");
INSERT INTO rifl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","War zzayes tkessid arriba uřa d arbeḥ, maca ad teggʷded AREBBI nnec, ḥima umac i din ɣarek ad iqqim iddar.    ");
INSERT INTO rifl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","War d as ttic tmenyat n nnuqart s arriba u war d as ttic macca s warbeḥ. ");
INSERT INTO rifl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Aqa Necc d SIDI, AREBBI nwem, wenni kenniw dd-issuffɣen zi temmurt n Miṣra, ḥima ad awem wceɣ tammurt n Kenɛan u ḥima ad iřiɣ d AREBBI i kenniw.” ");
INSERT INTO rifl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Mařa umac iẓřeḍ am kik iǧa uca immenz ac i cek, war t tᵉttarrid ad ixdem am yismeɣ. ");
INSERT INTO rifl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ad kik izdeɣ amecnaw acewwař, amecnaw ijj n umɛezzeb, uca ad ɣarek ixdem ař aseggʷas n usřiwřew. ");
INSERT INTO rifl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Xenni ad xak iffeɣ, netta simant nnes ak-d tarwa nnes, uca ad idweř ɣar řaǧ nnes u ad idweř ɣar wagřa n řejdud nnes. ");
INSERT INTO rifl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Minzi aqa aten d imsexarren inu inni ssuffɣeɣ Necc zi temmurt n Miṣra. War ttmenzin am mammec ittmenza ijj n ismeɣ. ");
INSERT INTO rifl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","War xas ttṣeǧeḍ s řeqsaḥet, maca ad teggʷded AREBBI nnec. ");
INSERT INTO rifl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","X ismeɣ nnec niɣ x tayya nnec, inni ɣarek ɣa yiřin, ad iřin zi řegnus i d ac dd-innḍen. Zzaysen ad tesɣed isemɣan d teyyawin. ");
INSERT INTO rifl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Tzemmarem ad ten tesɣem zeg iḥenjiren n imeɛzab nni izeddɣen jar awem am yibarraniyyen u zi řaǧat nsen, inni akidwem iǧan, inni ten dd-ijjin di temmurt nwem. Nitni ad dewřen d agřa nwem. ");
INSERT INTO rifl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Uca ad ten tejjed d řwart i iḥenjiren nwem awarni awem. Tzemmarem ad ten tarrem ad awem sexxaren řebda, maca x aytmatwem, ayt n Israil, war ttṣellṭem kuř ijj x wenneɣni s řeqsaḥet.” ");
INSERT INTO rifl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Mařa yiweḍ ufus n ijj n ubarrani niɣ n ijj n umɛezzeb i izeddɣen jar awem, uca umac i ɣares izeddɣen idweř iẓřeḍ uca ad izzenz ixef nnes i ubarrani nni izeddɣen ɣarek niɣ i yijjen zi jjadira n řaǧ n ubarrani nni, ");
INSERT INTO rifl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","xenni iɛeddeř, awarni ma izzenz ixef nnes, ad ittwafdi. Ijjen zeg aytmas ad t ifdi. ");
INSERT INTO rifl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Iɛeddeř i ɛemmis niɣ i mmis n ɛemmis ad t ifdi niɣ ijjen zi raǧ nnes i-t-i-dd-yudsen, zi řwacun nnes, ad t ifdi, niɣ mařa ɣares s min zi, xenni iɛeddeř ad ifdi ixef nnes. ");
INSERT INTO rifl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ad igg řeḥsab ak-d wenni t isɣin zeg useggʷas min di izzenz ixef nnes ař aseggʷas n usřiwřew u ttaman n tmenziwt s nnuqart ad yiři ɛlaḥsab řqedd n iseggʷusa, inni i ɣa ittwaḥesben am wussan n ijj n ucewwař ixeddmen akides. ");
INSERT INTO rifl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Mařa aqa din ɛad aṭṭas n iseggʷusa ɣar zzat, ad ixeǧeṣ maḥend ad ittwafdi anect n tesɣart n ttaman s tmenyat n nnuqart i zi ittwaseɣ. ");
INSERT INTO rifl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Mařa ɛad drus i iqqimen n iseggʷusa ař aseggʷas n usřiwřew, xenni ad igg i yixef nnes ijj n řeḥsab uca ad ixeǧeṣ ttaman n ufekki nnes ɛlaḥsab iseggʷusa i din iqqimen. ");
INSERT INTO rifl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Am yijj n ucewwař ad ɣares iqqim zeg useggʷas ař aseggʷas. War iɛeddeř ad xas ṣellṭen s řeqsaḥet zzat i tiṭṭawin nnec. ");
INSERT INTO rifl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Mařa war ittwafdi s marra aya, xenni ad ifekk deg useggʷas n usřiwřew, netta d tarwa nnes akides. ");
INSERT INTO rifl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Minzi ayt n Israil aqa aten d imsexxaren inu, inni ssuffɣeɣ zi temmurt n Miṣra. Aqa Necc d SIDI, AREBBI nwem.” ");
INSERT INTO rifl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“War tteggem i yixef nwem l’aṣnam, war sbeddam řexyař ineqcen uřa d umayḍu iqeddsen, war ssrusam řexyař n weẓru di temmurt nwem, ḥima ad as tbendqem, minzi Necc d SIDI, AREBBI nwem! ");
INSERT INTO rifl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ad teḥḍam ussan n ssebt inu uca ad awem iqarr ijj n uweqqar yuǧɣen i Zzawect inu Iqeddsen, aqa Necc d SIDI!” ");
INSERT INTO rifl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Mařa ad tuyurem di tweṣṣa inu uca ad tᵉṭṭfem di tweṣṣa inu uca ad zzaysent teggem, ");
INSERT INTO rifl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","xenni Necc ad awem wceɣ anẓar di řweqt nnes, uca tammurt ad dd-tawi ṣṣabet nnes, uca ticejjura n yeyyar ad wcent řɣiǧet nsent. ");
INSERT INTO rifl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ad yiři usarwet ař ařqaḍ n uḍiř uca ařqaḍ n uḍiř ad yiři ař řweqt n uzarreɛ uca ad teccem ař ɣa tejjiwnem uca ad tzedɣem di řaman di temmurt nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Necc ad ggeɣ řehna di temmurt. Mařa tᵉṭṭṣem, war ittiři wi kenniw i ɣa issiggʷden. Necc ad mḥiɣ řewḥuc iwɛaren zi temmurt uca ssif war dd-iẓekkʷi x temmurt nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ad teḍfarem řɛedyan nwem uca nitni ad wḍan s ssif nwem zzat i tiṭṭawin nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Xemsa n yeryazen zzaywem ad ḍfaren mya uca mya zzaywem ad ḍfaren ɛecra-ařaf uca řɛedyan nwem ad wḍan s řeqḍeɛ n ssif zzat i tiṭṭawin nwem.    ");
INSERT INTO rifl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Minzi Necc ad ɣarwem dd-dewřeɣ uca ad awem dd-jjeɣ řɣiǧet uca ad kenniw arniɣ uca ad ssmetneɣ Řɛahd inu akidwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Am i ɣa teccem ɛad zi zzad nni txeznem, ad tekksem deɣya zzad aqdim, maḥend ad tejjem amcan i jdid. ");
INSERT INTO rifl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Necc ad ggeɣ Tazeddiɣt inu di řwest nwem uca řeɛmar inu war zzaywem ittɛiffi ca ɛad. ");
INSERT INTO rifl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ad uyureɣ jar awem, Necc ad iřiɣ d AREBBI nwem uca kenniw ad ayi tiřim d řgens inu. ");
INSERT INTO rifl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Necc d SIDI, AREBBI nwem, wenni kenniw dd-issuffɣen zi temmurt n Miṣra, ḥima war tᵉttiřim ɛad d isemɣan nsen. Necc arẓiɣ imqeǧaḍen n uzayřu nwem uca nedheɣ kenniw s wudem yuři.” ");
INSERT INTO rifl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Maca mařa war d ayi tesřim niɣ war tᵉtteggim marra min zi kenniw weṣṣiɣ, ");
INSERT INTO rifl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","uca mařa tesseḥqarem tiweṣṣa inu u řeɛmar nwem ad iɛiff zi lfarayiḍ inu, ař ɣa tawḍem war tᵉtteggem ɛad marra tiweṣṣa inu, uca ammu i ɣa tarẓem Řɛahd inu, ");
INSERT INTO rifl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","xenni Necc ad awem ggeɣ aya: ad xawem dd-ssehwiɣ arjef d bu-deǧis d tmessi n arwaḥ nni i ɣa iteḥḥan tiṭṭawin uca ad ɛeddben řeɛmar. Ad tzarɛem zzariɛet nwem baṭeř, minzi řɛedyan nwem ad tt ccen. ");
INSERT INTO rifl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ad ggeɣ udem inu ḍidd nwem ařami i ɣa ttwassexsarem zzat i wudem n řɛedyan nwem uca inni kenniw icarrhen ad xawem ṣellṭen uca kenniw ad tarewřem břa ad yiři wi kenniw iraran.” ");
INSERT INTO rifl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“U mařa awarni man aya ɛad war ɣari tesřim, Necc ad ɣares arniɣ sebɛa n twařawin, maḥend ad kenniw webbxeɣ x ddnub nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Necc ad arẓeɣ aɛeffar n jjehd nwem, Necc ad arreɣ ajenna nwem am wuzzař d temmurt nwem am nnḥaṣ. ");
INSERT INTO rifl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ad tḍeyyɛem jjehd nwem baṭeř, minzi tammurt nwem war tᵉttic ṣṣabet nnes u ticejjura n temmurt war tticent řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Mařa temɛařam kidi uca war tᵉttexsem ad ayi tesřim, xenni Necc ad xawem dd-ssehwiɣ ɛad sebɛa n jjrayeḥ anect n ddnub nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ad ɣarwem dd-ssekkeɣ řewḥuc n řexřa, maḥend ad awem xeḍfen tarwa nwem, ad sshellken řebhayem nwem, uca ad ssneqṣen lɛadad nwem, ařami ibriden nwem ad dewřen d ddmani.” ");
INSERT INTO rifl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Mařa s man aya kenniw war ɣari dd-ttesřim, maca teqqimem tᵉttemɛařam akidi, ");
INSERT INTO rifl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","xenni uřa d Necc ad qqimeɣ ttemɛařaɣ akidwem uca ad xawem dd-ssehwiɣ ɛad sebɛa n jjrayeḥ x ddnub nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ad xawem ssekkeɣ ijj n ssif nni i ɣa issekkaren antaqem n Řɛahd inu ař ɣa tᵉttwassmunem di tneddam nwem. Xenni Necc ad ssekkeɣ ṭṭaɛun di řwesṭ nwem uca kenniw ad tᵉttwasellmem deg ufus n řeɛdu nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Xmi ɣa arẓeɣ řeɛweč n weɣrum nwem, xenni ɛecra n temɣarin ad ssenggʷent aɣrum nwem di tefqunt d ict, uca awarni i ɣa weznent aɣrum ad t i-dd-arrent uca kenniw ad t teccem, maca war tᵉttjiwinem. ");
INSERT INTO rifl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Mařa ɛad s man aya war ɣari dd-tᵉttesřim, maca ad teqqimem ad temɛařam akidi, ");
INSERT INTO rifl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","xenni Necc ad xawem sɛareɣ u ad kenniw arebbiɣ, wah sebɛa n imuren Necc ad kenniw arebbiɣ di ssibbet n ddnub nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ad teccem aysum n iḥenjiren nwem uřa d aysum n tḥenjirin nwem ad t teccem. ");
INSERT INTO rifl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ad areddǧeɣ řegɛudi mani tᵉttwehhabem ddbayeḥ nwem, ad nḍareɣ ipilaren nwem n arebbi n tfuct, ad arreɣ řxecbat nwem x řxecbat n imeyḍa n l’aṣnam nwem uca řeɛmar inu ad zzaywem iɛiff. ");
INSERT INTO rifl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ad arreɣ tineddam nwem d řxarbet uca ad areddǧeɣ tizawiyyin iqeddsen nwem uca war ttexseɣ ad cemmeɣ ɛad řefwaḥet ittfuḥen nwem. ");
INSERT INTO rifl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Wah, Necc ad areddǧeɣ tammurt uca řɛedyan nwem, inni dayes izeddɣen, ad zzayes nnxeřɛen.” ");
INSERT INTO rifl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","“Ad kenniw zuzzareɣ jar řegnus uca ad kseɣ ssif awarni awem uca tammurt nwem ad tedweř d řexřa uca tineddam nwem ad iřint d řxarbet. ");
INSERT INTO rifl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Xenni tammurt ad xas arḍan wussan n ssebt nnes, marra ussan n wareddeǧ n temmurt, umi i ɣa tiřim di temmurt n řɛedyan nwem. Xenni ad tareyyeḥ temmurt u ad tegg tcuni x wussan n ssebt nnes. ");
INSERT INTO rifl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Mařa ussan n wareddeǧ ad ɣares yiři wareyyeḥ, minzi tammurt war tareyyiḥ ca deg wussan n ssebt nwem řami tuɣa kenniw tzeddɣem dinni.” ");
INSERT INTO rifl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Ad ggeɣ tiggʷudi deg wuřawen n yinni zzaywem i ɣa iqqimen di temmura n řɛedyan nsen, ařami řḥess n ict n tfarect i yiwi usemmiḍ ad xasen yaẓẓeř u ad ten yarr ad arewřen am mammec ittarekkwař bnadem zi ssif. Nitni ad wḍan, waxxa war xasen ittiẓẓeř ḥed. ");
INSERT INTO rifl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ad nqarḍen ijjen deg wenneɣni am xmi ẓrin řeqdeɛ n yijj n ssif, waxxa war xawem ittiẓẓeř ḥed. Kenniw war tzemmaren ad teqqimem tbeddem zzat i tiṭṭawin n řɛedyan nwem, ");
INSERT INTO rifl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","maca kenniw ad tᵉttwahellkem jar řegnus uca tammurt n řɛedyan nwem ad kenniw tecc.” ");
INSERT INTO rifl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","“Inni zzaywem i ɣa iqqimen ad isřawen di temmura n řɛedyan nwem di ssibbet n řmuɛṣiyyet nsen. Uřa di ssibbet n řmuɛṣiyyet n řejdud nsen ad sřawen nitni jmiɛ akidsen. ");
INSERT INTO rifl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Maca mařa neɛmen x řmuɛṣiyyet nsen d řmuɛṣiyyet n ibabaten nsen zi ssibbet n řeɣdar nsen i zi d ayi ɣdaren uca ɛawed mmɛařan akidi ");
INSERT INTO rifl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","- uca xenni uřa d Necc mmɛařiɣ akidsen u iwyeɣ ten ɣar temmurt n řɛedyan nsen, maḥend ad taɣ uř nsen war ixtinen ad yaḍar uca ad qebřen řexřaṣ i řmuɛṣiyyet nsen - ");
INSERT INTO rifl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","xenni Necc ad xarrṣeɣ ɛawed di Řɛahd inu ak-d Yaɛqub uca ɛawed di Řɛahd inu ak-d Isḥaq uca ad xarrṣeɣ di Řɛahd inu ak-d Ibrahim uca ad xarrṣeɣ ɛawed di temmurt. ");
INSERT INTO rifl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Tammurt ad tᵉttwajj zzaysen uca ad xas arḍan wussan n ssebt nnes umi ɣa teqqim d ict n řxarbet xmi war dayes zeddɣen ɛad, uca nitni ad řemden ad qebřen lɛiqab n řmuɛṣiyyet nsen, minzi nḍaren lfarayiḍ inu u minzi řeɛmar nsen iɛiff zi tweṣṣa inu.” ");
INSERT INTO rifl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Sennej i uya, aqa d man aya: mařa aqa aten di temmurt n řeɛdyan nsen, Necc war ten neṭṭareɣ ca u war ten ttɛiffiɣ ař ten ɣa teḥḥiɣ u ad mḥiɣ Řɛahd inu akidsen minzi Necc d SIDI, AREBBI nsen! ");
INSERT INTO rifl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Maca di ṭṭweɛ nsen ad ɛeqřeɣ x Řɛahd inu ak-d imezwura, inni nedheɣ zi temmurt n Miṣra zzat i tiṭṭawin n řegnus, maḥend ad iřiɣ d AREBBI i nitni, Necc d SIDI!” ");
INSERT INTO rifl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tina d tiweṣṣa d lfarayiḍ d izerfan nni igga SIDI jar as d jar ayt n Israil deg wedrar n Sina s tsexxart n Musa. ");
INSERT INTO rifl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Siweř ak-d ayt n Israil uca ini asen, aqa mařa ixs ḥed ad igg ijj n lwaɛd i AREBBI, ad yiři ttaman n ufekki n řeɛmur ittwassqeddsen i SIDI ɛlaḥsab řqimet i tqeddared cek. ");
INSERT INTO rifl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Mařa řqimet i tqeddared cek aqa d řqedd n ijj n weryaz zi ɛicrin ař settin n iseggʷusa, xenni ad tiři řqimet i tqeddared xemsin ciqlu n nnuqart ɛlaḥsab ciqlu n Zzawect Iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Mařa d ict n temɣart, xenni ad tiři řqimet i tqeddared třatin ciqlu.” ");
INSERT INTO rifl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","“Uca mařa d ijj n ubřiɣ zi xemsa ař ɛicrin n iseggʷusa, xenni ad tiři řqimet i tqeddared i yijj n weryaz ɛicrin ciqlu u i yict n temɣart ɛecra ciqlu.” ");
INSERT INTO rifl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“Mařa d ijj n uḥenjir zeg yijj n uyur ař xemsa n iseggʷusa, xenni ad tiři řqimet i tqeddared i yijj n weryaz xemsa ciqlu n nnuqart u i yict n temɣart třata ciqlu n nnuqart.” ");
INSERT INTO rifl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","“Mařa d ijj n mmis n bnadem zi settin iseggʷusa niɣ sennej, xenni, mařa netta d aryaz, ad tiři řqimet i tqeddared xemmesṭac ciqlu u mařa d tamɣart ad tiři řqimet i tqeddared ɛecra n ciqlu.” ");
INSERT INTO rifl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Mařa tuɣa iẓřeḍ aṭṭas u war izemmar ad iwc řqimet i tqeddared cek, xenni ad t ssbedden zzat i wudem n ukehhan uca xenni ad iqeddar ukehhan řqimet nnes. Ad t iqeddar ukehhan ɛlaḥsab min izemmar ad issmun ufus n wenni iwcin awař, ammu i t ɣa iqeddar ukehhan.” ");
INSERT INTO rifl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Mařa d řebhayem i zi ɣa qeddmen tawhibt i SIDI, xenni marra min zzaysen ɣa iwc netta i SIDI, ad yiři iqeddes. ");
INSERT INTO rifl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","War ittbeddiř u war ixeǧef amuddar icnan x wenni iqebḥen niɣ amuddar iqebḥen x wenni icnan. Mařa ibeddeř ɛad ict n řebhimet s ict n řebhimet nneɣni, xenni ta d tenni i x tt ibeddeř ad iřint qeddsent. ");
INSERT INTO rifl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Mařa teǧa d ict n řebhimet texmej, war iɛeddeř ad tt qeddmen d tawhibt i SIDI, xenni ad yarr řebhimet nni ad tbedd zzat i wudem n ukehhan. ");
INSERT INTO rifl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Akehhan ad iqeddar řqimet nnes jar min icnan d min war iḥřin. Uca am mammec i tt ɣa tqeddared cek, am ukehhan, ammu i ɣa tiři. ");
INSERT INTO rifl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mařa netta ixs ɛad ad tt ifdi, ad xas yarni ict n tesɣart n texmusect n řqimet i tqeddared cek.” ");
INSERT INTO rifl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Mařa ca n yijjen issqeddes taddart nnes, maḥend ad tiři tqeddes i SIDI, xenni ad iqeddar ukehhan řqimet nnes jar min icnan d min iqebḥen. Am mammec iqeddar ukehhan řqimet nnes, ammu i ɣa tiři. ");
INSERT INTO rifl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mařa wenni tt issqeddsen ixs ad ifdi taddart nnes, xenni netta ad xas yarni ict n tesɣart n texmusect n řqimet ittwaggen s nnuqart uca ad tiři nnes ɛawed.” ");
INSERT INTO rifl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Mařa ca n yijjen issqeddes i SIDI ca n tesɣart n yeyyar nni ɣares iǧan, xenni ad tqeddared řqimet nnes ɛlaḥsab zzariɛet nnes. Zzariɛet n ijj n uḥumir n imendi ad as ggen xemsin ciqlu. ");
INSERT INTO rifl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Mařa tuɣa issqeddes iyyar nnes zeg useggʷas n usřiwřew, xenni ad tedweř řqimet n yeyyar tbedd ɛlaḥsab řqimet i tqeddared. ");
INSERT INTO rifl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mařa tuɣa issqeddes iyyar nnes awarni i useggʷas n usřiwřew, xenni akehhan ad as ihṣeb řqimet s nnuqart n iseggʷusa iqqimen ař aseggʷas n usřiwřew i dd ɣa yasen u xenni ad tiři řqimet qell x řqimet tmun i tuɣa tqeddared cek. ");
INSERT INTO rifl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Mařa wenni issqeddsen iyyar, ixs ad t ifdi nican, xenni ad yarni ict n tesɣart n texmusect di nnuqart x řqimet i tqeddared cek uca xenni ad as yiři ɛawed.” ");
INSERT INTO rifl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","“Mařa war ixs ad ifdi iyyar nni niɣ mařa izzenz iyyar i yijj n weryaz nneɣni, xenni war izemmar ad ittwafdi ɛad yeyyar. ");
INSERT INTO rifl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Awarni řami dd-iffeɣ deg useggʷas n usřiwřew, ad yiři iyyar iqeddes i SIDI am yijj n yeyyar ittwaḥarrmen qaɛ. Ad yiři d agřa n ukehhan.” ");
INSERT INTO rifl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Mařa ca n yijjen issqeddes ijj n yeyyar nni isɣa i SIDI, maca war iǧi yeyyar n wagřa nnes, ");
INSERT INTO rifl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","xenni akehhan ad as iḥseb ttaman n řqimet i tqeddared cek ař aseggʷas n usřiwřew uca netta ad ixeǧeṣ řqimet i tqeddared deg wass nni d ijj am ict n tmesřact tqeddes i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Deg useggʷas n usřiwřew ad dd-iɛqeb yeyyar ɛawed i wenni x t isɣa, i wenni tuɣa ɣar teǧa temmurt d agřa. ");
INSERT INTO rifl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Aqeddar ad yiři ɛlaḥsab ciqlu n Zzawect Iqeddsen. Ad yiři ciqlu ɛicrin jira.” ");
INSERT INTO rifl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Maca amenzu, wenni ifarzen i SIDI zi řebhayem am umenzu, war iɛeddeř ad t issqeddes uřa d ijjen, niɣ d afunas i iǧa niɣ d ijjen zeg wuǧi, aqa-t i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Maca mařa tuɣa-t zeg ict n řebhimet ixemjen, izemmar ad tt ifdi ɛlaḥṣab řqimet i tqeddared cek uca ad xas yarni ict n tesɣart n texmusect. Mařa war tᵉttwafeddi, xenni ad temmenz ɛlaḥsab řqedd i tqeddared cek.” ");
INSERT INTO rifl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Maca uřa d ict n řḥajjet nni ittwaḥarrmen zeg ijj n weryaz i SIDI zi marra min ɣares iǧan n iwdan d řebhayem d iyyaren, war iɛeddeř ad temmenz niɣ ad tᵉttwafdi. Marra min ittwaḥarrmen, ad yiři d amqeddas qaɛ i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Marra min ittwaḥarrmen qaɛ i uteḥḥi, min ittwaḥarrmen zeg iwdan, war iɛeddeř ad ittwafdi, maca ittxeṣṣa ad ittwaneɣ nican.” ");
INSERT INTO rifl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Marra tiɛcuray n temmurt, zi zzariɛet n temmurt u zi řɣiǧet n tcejjura, ad iřint i SIDI, aqa atent qeddsent i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Mařa ca n yijjen ixs ad ifdi ca zi řeɛcur nnes, xenni ad xas yarni ict n tesɣart di xemsa. ");
INSERT INTO rifl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","X marra tiɛcuray zeg ifunasen d tfunasin d wuǧi, zi marra min ikkin sadu uzeǧaḍ n umeksaw, ad yiři umuddar wiss ɛecra iqeddes i SIDI. ");
INSERT INTO rifl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","War iɛeddeř ad yarzu mammec tecna niɣ mammec war teḥři i teǧa, uřa war t ittbeddiř ca, maca mařa ibeddeř i-t, xenni amuddar nni d wenni zi t i ɣa ibeddeř ad iřin qeddsen. War iɛeddeř ad ittwafdi.” ");
INSERT INTO rifl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Aqa tina d tiweṣṣa nni i zi iweṣṣa SIDI i Musa u i ayt n Israil deg wedrar n Sina. ");
INSERT INTO rifl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Issiweř SIDI ak-d Musa di řexřa n Sina, deg Uqiḍun n Umsagar, deg wass amezwaru n uyur wiss tnayen, deg useggʷas wiss tnayen awarni řami dd-ffɣen zi temmurt n Miṣra, inna: ");
INSERT INTO rifl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Ksim řqedd n ismawen n marra iryazen n marra tamesmunt n ayt n Israil, azeǧif azeǧif, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen. ");
INSERT INTO rifl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Ittxeṣṣa cek d Harun ad tḥesbem kuř ijj di Israil zi ɛicrin n iseggʷusa sennej, marra inni dd-iffɣen ak-d řɛeskar, ɛlaḥsab tirbiɛin n řɛeskar nsen. ");
INSERT INTO rifl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ad awem iwc afus ijj n weryaz zi kuř taqbič, aryaz i iǧan d azeǧif n taddart n babas. ");
INSERT INTO rifl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Aqa d ina d ismawen n yeryazen nni d awem ɣa iwcen afus: I Rubin, Iliṣur mmis n Cadayur, ");
INSERT INTO rifl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","i Cimɛun, Calumiyil, mmis n Ṣuriycadday, ");
INSERT INTO rifl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","i Yahuda, Naḥcun, mmis n Ɛamminadab, ");
INSERT INTO rifl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","i Issakar, Natanayil, mmis n Ṣuɣar. ");
INSERT INTO rifl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","i Zabulun, Iliyab, mmis n Ḥilun, ");
INSERT INTO rifl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","i ayt n Yusuf: i Ifrayim, Ilicamaɛ, mmis n Ammihud, i Manassa, Jamliyil, mmis n Fadahṣur, ");
INSERT INTO rifl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","i Binyamin, Abidan mmis n Jidɛuni, ");
INSERT INTO rifl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","i Dan, Axiɛazar, mmis n Ɛammicadday, ");
INSERT INTO rifl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","i Acir, Fajɛiyil, mmis n Ɛukran, ");
INSERT INTO rifl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","i Jad, Iliyasaf, mmis n Daɛuyil, ");
INSERT INTO rifl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","i Naftali, Axiraɛ, mmis n Ɛinan.” ");
INSERT INTO rifl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ina tuɣa d inni ittwařaɣan zi tmesmunt, nitni d řḥukkam n tqebbař n ibabaten nsen, izeǧifen x řuřuf n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ksin Musa d Harun iryazen nni tuɣa ittwarecmen s ismawen nsen ");
INSERT INTO rifl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","uca ssmunen tamesmunt marra deg wass amezwaru n uyur wiss tnayen uca nitni xebbaren jjdira nsen, ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, am ttwazemmemen ismawen n yinni ɣar iǧa ɛicrin n iseggʷusa sennej, azeǧif azeǧif. ");
INSERT INTO rifl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Am mammec d as yumur SIDI i Musa, aqa iḥseb i-ten di řexřa n Sina. ");
INSERT INTO rifl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ayt n Rubin, amenzu n Israil: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen - inni zzayes ittwaḥesben ɛlaḥsab ismawen nsen azeǧif azeǧif, kuř aryaz zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","wah, inni ittwaḥesben ammu i teqbič n Rubin, tuɣa aten di setta u-rebɛin-ařef u-xemsa mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ayt n Cimɛun: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen - inni zzayes ittwaḥesben ɛlaḥsab lɛadad n ismawen nsen, azeǧif azeǧif, kuř aryaz zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","wah, inni ittwaḥesben ammu i teqbič n Cimɛun tuɣa aten di tesɛa u-xemsin-ařef u-teřt-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ayt n Jad: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen - inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","wah, inni ittwaḥesben ammu i teqbič n Jad tuɣa aten di xemsa u-rebɛin-ařef u-setta-mya u-xemsin. ");
INSERT INTO rifl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ayt n Yahuda: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen - inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, kuř ijjen i dd-itteffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","wah, inni ittwaḥesben ammu i teqbič n Yahuda tuɣa aten di arebɛa u-sebɛin-ařef u-setta-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ayt n Issakar: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen - inni zzayes ittwaḥesben ɛlaḥṣab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","wah, inni ittwaḥesben ammu i teqbič n Issakar tuɣa aten di arebɛa u-xemsin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ayt n Zabulun: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen - inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","wah, inni ittwaḥesben ammu i teqbič n Zabulun tuɣa aten di sebɛa u-xemsin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ayt n Yusuf: Ayt n Ifrayim: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","wah, inni ittwaḥesben ammu i teqbič n Ifrayim tuɣa aten di arebɛin-ařef u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ayt n Manassa: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","wah, inni ittwaḥesben ammu i teqbič n Manassa tuɣa aten di tnayen u-třatin-ařef u-mitayen. ");
INSERT INTO rifl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ayt n Binyamin: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","wah, inni ittwaḥesben ammu i teqbič n Binyamin tuɣa aten di xemsa u-třatin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ayt n Dan: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","wah, inni ittwaḥesben ammu i teqbič n Dan tuɣa ten di tnayen u-settin-ařef u-sebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ayt n Acir: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","wah, inni ittwaḥesben ammu i teqbič n Acir tuɣa ten di waḥit u-rebɛin-ařef u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ayt n Naftali: tarwa nsen - ttwasettfen ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, inni zzayes ittwaḥesben ɛlaḥsab ismawen n marra iryazen zi ɛicrin iseggʷusa sennej, marra wenni i ɣa iffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","wah, inni ittwaḥesben ammu i teqbič n Naftali tuɣa aten di třata u-xemsin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ina d inni ittwaḥesben, inni ttwaḥesben s ufus n Musa d Harun d řḥukkam n Israil, tenɛac n yeryazen, ijjen weryaz i taddart n babas. ");
INSERT INTO rifl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Marra inni ittwaḥesben zeg ayt n Israil - am ttwasettfen nitni ɛlaḥsab taddart n ibabaten nsen - marra inni ɣar iǧa ɛicrin n iseggʷusa sennej, kuř ijj wenni dd-itteffɣen ak-d řɛeskar, ");
INSERT INTO rifl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","wah, marra inni ittwaḥesben tuɣa aten di setta-mya u-ṭeřt-ařaf u-xemsa-mya u-xemsin. ");
INSERT INTO rifl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ilawiyyen war carcen ca jar asen di řeḥsab di ṭṭweɛ n teqbič n ibabaten nsen, ");
INSERT INTO rifl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","minzi SIDI tuɣa issiweř ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Mɣir taqbič n Lawi war tt ttᵉḥseb ca u war tt zemmi ca azeǧif azeǧif jar ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Maca ittxeṣṣa cek s yixef nnec, ad tegged Ilawiyyen x Tzeddiɣt n Cchadet u x marra řeqcuɛ nnes u x marra min d as dd-yusin. Nitni ad arbun Tazeddiɣt ak-d řeqcuɛ nnes marra, uca ad dayes sexxaren. Ittxeṣṣa ad wten iqiḍan nsen min dd-innḍen i Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Mařa ad tᵉttwafsi Tzeddiɣt, ad tt hedmen Ilawiyyen uca mařa tiweḍ Tzeddiɣt ɣar řmargeh aneḍfar, xenni ad tt ssbedden Ilawiyyen ɛawed. Mařa dd-iqarreb ca n ubarrani, xenni netta ad ittwaneɣ. ");
INSERT INTO rifl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ayt n Israil ad wten iqiḍan n řmargeḥ nsen, kuř ijj ɣar tɛeǧant nnes, am ttwasettfen nitni ɛlaḥsab tirbiɛin n řɛeskar nsen. ");
INSERT INTO rifl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ilawiyyen ad wten iqiḍan nsen ɣar kuř jjihet n Tzeddiɣt n Cchadet, ḥima war ittiři uduqqez n weɣḍab x tmesmunt n ayt n Israil. Ittxeṣṣa i Ilawiyyen ad ḥḍan x Tzeddiɣt n Cchadet.” ");
INSERT INTO rifl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Uca ggin ayt n Israil s marra min yumur SIDI i Musa, wah, ammu i-t ggin. ");
INSERT INTO rifl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ayt n Israil ad wten iqiḍan nsen kuř ijj ɣar tɛeǧant nnes, ɣar řeɛřamat n taddart n ibabaten nsen. Ad wten iqiḍan nsen cwayt ɣar řaggʷaj ɣar marra iɣezdisen n Uqiḍun n Umsagar.” ");
INSERT INTO rifl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Inni iǧan sadu n tɛeǧant n řmargeḥ n řɛeskar n Yahuda ad wten iqiḍan nsen, am ttwasettfen nitni ɛlaḥsab tirbiɛin n řɛeskar nsen ɣar ccarq, ɣar manis dd-tneqqar tfuct. Naḥcun, mmis n Ɛamminadab, ad yiři d řḥakem n ayt n Yahuda. ");
INSERT INTO rifl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di arebɛa u-sebɛin-ařef u-setta-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Zzates ad tewwet teqbič n Issakar iqiḍan nnes. Natanayil, mmis n Ṣuɣar, ad yiři d řḥakem n ayt n Issakar. ");
INSERT INTO rifl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di arebɛa u-xemsin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Xenni taqbič n Zabulun. Iliyab, mmis n Hilun, ad yiři d řḥakem n ayt n Zabulun. ");
INSERT INTO rifl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di sebɛa u-xemsin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Inni ittwaḥesben i řmargeḥ n řɛeskar n Yahuda tuɣa aten marra jmiɛ di mya u-setta u-tmanin-ařef u-arebɛa-mya n yeryazen, ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Nitni ad fesyen iqiḍan nsen amezwaru. ");
INSERT INTO rifl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ɣar ljanub ad tiři tɛeǧant n řmargeḥ n řɛeskar n Rubin. Nitni ad iřin ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Iliṣur, mmis n Cadayyur, ad yiři d řḥakem n ayt n Rubin. ");
INSERT INTO rifl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di setta u-rebɛin-ařef u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Zzates ad tewwet teqbič n Cimɛun iqiḍan nnes. Calumiyil, mmis n Ṣuriycadday, ad yiři d řḥakem n ayt n Cimɛun. ");
INSERT INTO rifl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di tesɛa u-xemsin-ařef u-teřt-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Xenni taqbič n Jad. Ilyasaf, mmis n Raɛuyil, ad yiři d řḥakem n ayt n Jad. ");
INSERT INTO rifl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di xemsa u-rebɛin-ařef u-setta-mya u-xemsin. ");
INSERT INTO rifl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Inni ittwaḥesben i řmargeḥ n řɛeskar n Rubin, tuɣa aten marra di mya u-waḥit u-xemsin-ařef u-arebɛa-mya u-xemsin n yeryazen, ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Nitni ad fesyen iqiḍan nsen wiss tnayen. ");
INSERT INTO rifl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Xenni ad ittwafsi Uqiḍun n Umsagar ak-d řmargeḥ n Ilawiyyen, di řwesṭ n marra řɛeskar. Am mammec ɣa wten iqiḍan nsen, ammu ittxeṣṣa ad mmuṭṭiyen ɛawed, kuř ijj deg wemcan nnes, am ttwasettfen nitni ɛlaḥsab tiɛeǧanin nsen. ");
INSERT INTO rifl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ɣar řɣarb ad tiři tɛeǧant n řmargeḥ n řɛeskar n Ifrayim. Nitni ad iřin ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Ilicamaɛ, mmis n Ɛammihud, ad yiři d řḥakem n ayt n Ifrayim. ");
INSERT INTO rifl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di arebɛin-ařef u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Zzates ad tiři teqbič n Manassa. Jamliyil, mmis n Fadahṣur ad yiři d řḥakem n ayt n Manassa. ");
INSERT INTO rifl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di tnayen u-třatin-ařef u-mitayn. ");
INSERT INTO rifl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Xenni taqbič n Binyamin. Abidan, mmis n Jidɛuni, ad yiři d řeḥkam n ayt n Binyamin. ");
INSERT INTO rifl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di xemsa u-ṭřatin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Inni ittwaḥesben i řmargeḥ n řɛeskar n Ifrayim, tuɣa aten di mya u-tmenya-ařef u-mya n yeryazen, ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Nitni ad fesyen iqiḍan nsen wiss třata. ");
INSERT INTO rifl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ɣar ccmal ad tiři tɛeǧant n řmargeḥ n řɛeskar n Dan. Nitni ad iřin ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Axiɛazar, mmis n Ɛammicadday, ad yiři d řḥakem n ayt n Dan. ");
INSERT INTO rifl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di tnayen u-settin-ařef u-sebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Zzates ad tewwet teqbič n Acir iqiḍan nnes. Fajɛiyil, mmis n Ɛukran, ad yiři d řḥakem n ayt n Acir. ");
INSERT INTO rifl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di waḥit u-rebɛin-ařef u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Xenni taqbič n Naftali. Axiraɛ, mmis n Ɛinan, ad yiři d řḥakem n ayt n Naftali. ");
INSERT INTO rifl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Inni ittwaḥesben i řɛeskar nnes, tuɣa aten di třata u-xemsin-ařef u-arebɛa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Inni ittwaḥesben i řmargeḥ n řɛeskar n Dan, tuɣa aten di mya u-sebɛa u-xemsin-ařef u-setta-mya n yeryazen. Nitni ad fesyen iqiḍan nsen d aneggaru, am ttwasettfen nitni ɛlaḥsab tiɛeǧanin nsen. ");
INSERT INTO rifl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ina d inni ittwaḥesben n ayt n Israil, am ttwasettfen nitni ɛlaḥsab taddart n ibabaten nsen. Marra inni ittwaḥesben di řemrageḥ n řɛeskar, am ttwasettfen nitni ɛlaḥsab tirbiɛin n řɛeskar nsen, tuɣa aten di setta-mya u-teřt-ařaf u-xemsa-mya u-xemsin n yeryazen.” ");
INSERT INTO rifl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ilawiyyen jar ayt n Israil war ttwaḥesben ca, nican am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Uca ggin ayt n Israil am mammec marra min d as yumur SIDI i Musa: am mammec wtin iqiḍan nsen s usettef ɣar tɛeǧanin nsen, ammu i ɣa fesyen iqiḍan nsen ɛawed, kuř ijjen ittwasettef ɛlaḥsab řaǧat nnes, ɣar taddart n ibabaten nnes. ");
INSERT INTO rifl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Aqa ina d tarwa n Harun d Musa deg wussan nni issiweř SIDI ak-d Musa x wedrar n Sina. ");
INSERT INTO rifl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aqa ina d ismawen n warraw n Harun: Nadab d amenzu, xenni Abihu, Aliɛazar d Itamar. ");
INSERT INTO rifl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aqa ina d ismawen n warraw n Harun, ikehhanen inni ittwadehnen u inni ittwařeqqmen am yikehhanen. ");
INSERT INTO rifl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Maca Nadab d Abihu mmuten zzat i wudem n SIDI, umi qeddmen timessi tařɣibt zzat i wudem n SIDI di řexřa n Sina. War tuɣi ɣarsen arraw. S uya tuɣa Aliɛazar d Itamar sexxaren am ukehhan zzat i wudem n babatsen Harun. ");
INSERT INTO rifl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Sqarreb-dd taqbič n Lawi uca egg i-ten zzat i wudem n ukehhan Harun, ḥima ad xas sexxaren. ");
INSERT INTO rifl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ejj i-ten ad řhan tasexxart nnes d tsexxart n marra tamesmunt zzat i Uqiḍun n Umsagar, maḥend ad kemmřen řxedmet n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ad ḥḍan x marra řeqcuɛ n Uqiḍun n Umsagar uca ad ṭṭfen aḥeṭṭu n ayt n Israil maḥend ad sexxaren di tsexxart n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Cek ad tewced Ilawiyyen i Harun u i warrawen nnes. Aqa d yina i d as immewcen i netta waha zeg ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ad třeqqmed Harun d warraw nnes maḥend ad ḥḍan x tukehhant. Abarrani nni i dd ɣa iqarrben ad ittwaneɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Xzar, Necc ksiɣ Ilawiyyen zi řwesṭ n ayt n Israil deg wemcan n imenza, marra inni yarezmen řemřawet d amezwaru jar ayt n Israil. Ilawiyyen ad iřin inu, ");
INSERT INTO rifl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","minzi kuř amenzu aqa inu. Deg wass min di wtiɣ marra imenza di temmurt n Miṣra, aqa ssqeddseɣ i Yixef inu marra imenza di Israil, zi bnadem ař řmař. Nitni ad iřin inu, Necc d SIDI!” ");
INSERT INTO rifl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Issiweř SIDI ak-d Musa di řexřa n Sina, inna: ");
INSERT INTO rifl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Ḥseb ayt n Lawi, am ttwasettfen nitni ɛlaḥsab tudrin n ibabaten nsen, ɛlaḥsab řaǧat nsen. Marra iwetman nni iǧan d ijj n uyur sennej, ad ten teḥseb.” ");
INSERT INTO rifl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Uca Musa iḥseb i-ten x řumur n SIDI, am mammec d as iweṣṣa. ");
INSERT INTO rifl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Tuɣa ina d ayt n Lawi ak-d ismawen nsen: Jarcun, d Qahat d Marari. ");
INSERT INTO rifl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Tuɣa ina d ismawen n ayt n Jarcun, ɛlaḥsab řaǧat nsen: Libni d Cimɛi. ");
INSERT INTO rifl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ayt n Qahat, ɛlaḥsab řaǧat nsen: Ɛamram d Yiṣhar d Ḥabrun d Ɛuzziyil. ");
INSERT INTO rifl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ayt n Marari, ɛlaḥsab řaǧat nsen: Maḥli d Muci. Tuɣa ina d řaǧat n Ilawiyyen, ttwasettfen ɛlaḥsab tudrin n ibabaten nsen. ");
INSERT INTO rifl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ɣar Jarcun tuɣa teǧa řaǧ n Ilibniyyen d řaǧ n Icimɛiyyen. Tuɣa tina d řaǧat n Ijarcuniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Řqedd n yinni zzaysen ittwaḥesben, n marra iwetman zeg ijj n uyur sennej, aqa řqedd nni n yinni zzaysen ittwaḥesben tuɣa di sebɛa-ařaf u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Wtint řaǧat n Ijarcuniyyen iqiḍan nsen ɣar ḍeffar n Tzeddiɣt, ɣar řɣarb. ");
INSERT INTO rifl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Tuɣa Ilyasaf, mmis n Layil, d řḥakem n taddart n babatsen n Ijarcuniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Zi jjihet n Uqiḍun n Umsagar ḥḍan ayt n Jarcun x Tzeddiɣt, x Uqiḍun ak-d tseqqafin nnes, x warwaq ɣar wadaf n Uqiḍun n Umsagar, ");
INSERT INTO rifl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","x řizarat n řemraḥ d warwaq ɣar wadaf n řemraḥ i zi tᵉttwanneḍ Tzeddiɣt d uɛalṭar, u x ifiřan nnes, uřa x marra min dd-ittasen ak-d tsexxart nni. ");
INSERT INTO rifl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Zi Qahat tuɣa iqqarṣ-dd řaǧ n Iɛamramiyyen d řaǧ n Iṣhariyyen d řaǧ n Iḥibruniyyen d řaǧ n Iɛaziyiliyyen. Tuɣa tina d řaǧat n Iqahatiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Tuɣa řqedd n marra iwetman zeg ijj n uyur sennej temn-ařaf u-setta-mya. Nitni ḥḍan x Zzawect Iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Wtint řaǧat n ayt n Qahat iqiḍan nsen ɣar uɣezdis n Tzeddiɣt, ɣar ljanub. ");
INSERT INTO rifl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Iliṣafan, mmis n Ɛuzziyil, tuɣa d řḥakem n taddart n babatsen n řaǧat n Iquhatiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Nitni tuɣa ḥeṭṭan x Ttabut d tzewḍa d řqendiř d iɛalṭaren u x řeqcuɛ n Zzawect Iqeddsen i ssxedmen u x uřeḥḥaf, wah, x marra i dd-ittasen ak-d tsexxart nni. ");
INSERT INTO rifl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Tuɣa Aliɛazar, mmis n ukehhan Harun, d řḥakem amezwaru qaɛ x marra řḥukkam n Lawi. Netta iṭṭef acbar x yinni tuɣa iḥeṭṭan x Zzawect Iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Zi Marari tuɣa iqqarṣ řaǧ n Imaḥliyyen d řaǧ n Imuciyyen. Tuɣa tina d řaǧat n Marari. ");
INSERT INTO rifl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Tuɣa řqedd n yinni zzaysen ittwaḥesben, n marra iwetman zeg ijj n uyur sennej, di setta-ařaf u-mitayn. ");
INSERT INTO rifl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Tuɣa Suriyil, mmis n Abixayil, d řḥakem n taddart n babatsen n řaǧat n Marari. Nitni wtin iqiḍan nsen ɣar uɣezdis n Tzeddiɣt, ɣar ccamal. ");
INSERT INTO rifl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ayt n Marari tuɣa tᵉṭṭfen acbar maḥend ad wcen taynit i marra tifeřwin n Tzeddiɣt, i tḥenya n uɛarreḍ, i ipilaren nnes, i tyarsawin nnes u i marra řeqcuɛ nnes, wah. i marra min dd-ittasen ak-d tsexxart nni, ");
INSERT INTO rifl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","uřa i ipilaren nni dd-innḍen i řemraḥ ak-d tyarsawin nsen d řewtad nsen d ifiřan nsen. ");
INSERT INTO rifl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa d Harun ak-d warraw nnes wtin iqiḍan nsen zzat i wudem n Tzeddiɣt, zzat i wudem n Uqiḍun n Umsagar, ɣar ccarq manis dd-tneqqar tfuct. Nitni ḥḍan x Zzawect Iqeddsen di ṭṭweɛ n ayt n Israil. Abarrani nni dd-iqarrben, tuɣa ittxeṣṣa ad ittwaneɣ. ");
INSERT INTO rifl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Marra inni ittwaḥesben n Ilawiyyen, inni iḥseb Musa ak-d Harun ɛlaḥsab řumur n SIDI, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, marra iwetman zeg ijj n uyur sennej, tuɣa aten di tnayen u-ɛicrin-ařef. ");
INSERT INTO rifl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Inna SIDI i Musa: “Ḥseb marra imenza n iwetman n ayt n Israil, zeg ijj n uyur sennej, uca ksi řqedd n ismawen nsen. ");
INSERT INTO rifl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ad teksid Ilawiyyen i Necc - Necc d SIDI! - deg wemcan n marra imenza jar ayt n Israil uřa d řebhayem n Ilawiyyen deg wemcan n marra imenza jar řebhayem n ayt n Israil.” ");
INSERT INTO rifl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Uca iḥseb Musa marra imenza jar ayt n Israil am mammec d as yumur SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Řqedd n ismawen n marra imenza iwetman n ijj n uyur sennej, n yinni zzaysen ittwaḥesben, tuɣa aten di tnayen u-ɛicrin-ařef u-mitayn u-třata u-sebɛin. ");
INSERT INTO rifl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ksi Ilawiyyen deg wemcan n marra imenza jar ayt n Israil uřa d řebhayem n Ilawiyyen deg wemcan n řebhayem nsen, minzi Ilawiyyen ad iřin inu. Aqa Necc d SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Zi jjihet n mitayen u-třata u-sebɛin, inni ittxeṣṣa ad ttwafdin, maɣar nitni qqimen sennej i Ilawiyyen n imenza n ayt n Israil, ");
INSERT INTO rifl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ittxeṣṣa ad teksid xemsa ciqlu i kuř ijj n uzeǧif. Ad t teksid anect n ciqlu n Zzawect Iqeddsen. Ciqlu wanita aqa dayes ɛicrin jira. ");
INSERT INTO rifl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ad tewced nnuqart nni i Harun u i warraw nnes, aqa-tt i ttaman n ufekki n yinni iqqimen sennej i řqedd n Ilawiyyen.” ");
INSERT INTO rifl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Xenni iksi Musa nnuqart n ttaman n ufekki n yinni iqqimen sennej n yinni ittwafdin s Ilawiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Uca iṭṭef nnuqart nni zeg imenza n ayt n Israil: ařef u-teřt-mya u-xemsa u-settin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","U Musa iwca nnuqart n yinni iwcin ttaman n ufekki i Harun u i warraw nnes, ɛlaḥsab awař n uqemmum n SIDI, am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Ḥseb ayt n Qahat azeǧif azeǧif jar ayt n Lawi, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, ");
INSERT INTO rifl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","zi třatin n iseggʷusa sennej ař xemsin n iseggʷusa, marra wenni i ɣa yadfen ɣar řɛeskar maḥend ad yegg řxedmet deg Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","D ta i ɣa yiřin d tasexxart n ayt n Qahat deg Uqiḍun n Umsagar: aḥeṭṭu x Weqdas x Uqeddas. ");
INSERT INTO rifl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Xmi dd ɣa fesyen řmargeḥ, ad dd-yas Harun d warraw nnes uca ad kksen ařeḥḥaf i iǧan i dduri uca ad zzayes ssduryen Ttabut n Cchadet. ");
INSERT INTO rifl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ittxeṣṣa ad xas ggen ijj n dduri n iřmawen n ddenfiřat uca ad xas bezzɛen ijj n dduri marra d adeḥmi uca ad as ggen iɛumad nnes i tarebbut. ");
INSERT INTO rifl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ad bezzɛen ict n tjartiřṭ tadeḥmit x tzewḍa i weɣrum n wescan uca ad xas ggen ṭṭbaṣi, tiɣenjayin d řkisan d iɣarrafen s inni i ɣa kebben. Uca ittxeṣṣa ad xas yiři weɣrum n řebda. ");
INSERT INTO rifl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Awarni uya ad xas bezzɛen ijj n dduri azeggʷaɣ iḥedqen uca ad tt dřen ɛawed s ijj n dduri n iřmawen n ddenfiřat uca ad as ggen iɛumad nnes i tarebbut. ");
INSERT INTO rifl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Xenni ad ksin ict n tjartiřt tadeḥmanit uca ad zzayes dřen řqendiř i tfawt uřa d řefnarat nnes d tjeqqaḍin n teftič nnes d tmejmarin nnes d marra řeqcuɛ nnes i zzect di ṭṭweɛ n tsexxart i řqendiř. ");
INSERT INTO rifl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ad ggen řqendiř-a d marra řeqcuɛ nnes deg ijj n dduri n iřmawen n ddenfiřat uca ad t ssarsen x ǧuḥ n tkessit. ");
INSERT INTO rifl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ad bezzɛen ijj n dduri adeḥmani x uɛalṭar n řebxur uca ad t dřen ɛawed s yijj n dduri n iřmawen n ddenfiřat uca ad as ggen iɛumad nnes i tarebbut. ");
INSERT INTO rifl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Uca ad ksin marra řeqcuɛ i tsexxart i ssxeddmen di Zzawect Iqeddsen uca ad ten ggen deg ijj n dduri adeḥmani uca ad t dřen s yijj n dduri n iřmawen n ddenfiřat, xenni ad ssarsen aya x ǧuḥ n tkessit. ");
INSERT INTO rifl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ad kksen min iqqimen n tadunt n uɛalṭar uca ad xas bezzɛen ict n tjartiřt tarjuwanit. ");
INSERT INTO rifl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ad xas ssarsen marra řeqcuɛ i ssxedmen i tsexxart: timejmarin, furcayat, iɣenjayen, ṭṭawyat i urucci d marra dduzan n uɛalṭar. Tiwwa nnes ad bezzɛen ijj n dduri n iřmawen n ddenfiřat uca ad as ggen iɛumad nnes i tarebbut. ");
INSERT INTO rifl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Xmi ɣa ikemmeř Harun d warraw nnes dduri n Zzawect Iqeddsen d marra řeqcuɛ n Zzawect Iqeddsen xmi ɣa fesyen iqiḍan n řmargeḥ n řɛeskar, xenni ad dd-asen warraw n Quhat ḥima ad arbun marra, maca ittxeṣṣa war ttḥidin min iǧan iqeddsen, minzi mařa lla ad mmten. Man aya d min ittxeṣṣa ad arbun warraw n Qahat di tmesřact n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Aliɛazar, mmis n ukehhan Harun, ad iṭṭef acbar x zzect i tfawt d řebxur ittfuḥen d tewhibt n řɣiǧet n řebda d zzect i wedhan, wah, Harun ad iṭṭef acbar x Tzeddiɣt marra u x marra min dayes, řa x min iǧan di Zzawect Iqeddsen uřa x řeqcuɛ nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Ɣarwem ad tqeḍɛem taqbič n řaǧat n Iqahatiyyen zi řwesṭ n Ilawiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ggem kisen ammu ḥima ad ddaren, war ttmettin xmi dd ɣa qarrben ɣar Weqdas x Uqeddas: ittxeṣṣa as i Harun d warraw nnes ad dd-adfen uca ad ggen kuř aryaz di řxedmet nnes u di ddqeř i ittxeṣṣa ad yarbu. ");
INSERT INTO rifl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","War iɛeddeř ad adfen maḥend ad ẓaren Zzawect Iqeddsen, mɣir i yict n wermac n wabřiwen waha, maɣar xenni ad mmten.” ");
INSERT INTO rifl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Ḥseb ɛawed ayt n Jarcun azeǧif azeǧif, am ttwasettfen nitni ɛlaḥsab tudrin n ibabaten nsen, ɛlaḥsab řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ad ten tḥesbed zi třatin n iseggʷusa sennej, ař xemsin n iseggʷusa, kuř ijj i ɣa yadfen ɣar řɛeskar ḥima ad yegg tasexxart deg Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","D ta d tasexxart n řaǧat n Jarcun di tmesřact n tsexxart d tarebbut. ");
INSERT INTO rifl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ad arbun tijartiřin n Tzeddiɣt d Uqiḍun n Umsagar: taseqqaft nnes d tseqqaft nnes n iřmawen n ddenfiřat nni i ɣa yiřin tiwwa nnes, d warwaq n wadaf n Uqiḍun n Umsagar, ");
INSERT INTO rifl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","d řizarat n řemraḥ d arwaq i tewwart n wadaf ɣar řemraḥ i dd-innḍen i Tzeddiɣt d uɛalṭar d marra ifiřan nsen d marra řeqcuɛ i dd-ittasen ak-d tsexxart nsen u marra min d as ṣennɛen, d man aya ad tiři řxedmet nsen. ");
INSERT INTO rifl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Marra řxedmet n ayt n Jarcun di tmesřact n marra tarebbut d marra tasexxart nsen, ad tiři ɛlaḥsab řumur n Harun d warraw nnes. Ittxeṣṣa awem ad ten tessecnem s uḥeṭṭu marra min ittxeṣṣa ad arbun. ");
INSERT INTO rifl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ta d tasexxart n řaǧat n ayt n Jarcun deg Uqiḍun n Umsagar. Nitni ad ksin amnus i uya sadu ufus n Itamar, mmis n Harun, akehhan. ");
INSERT INTO rifl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ad tḥesbed ayt n Marari, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen. ");
INSERT INTO rifl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ad ten tḥesbed zi třatin n iseggʷusa sennej, ař xemsin n iseggʷusa, marra wenni i ɣa yadfen ɣar řɛeskar maḥend ad isexxar di tsexxart n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","D ta d tasɣart nsen di trebbut ɣar marra tasexxart nsen deg Uqiḍun n Umsagar: tifeřwin n Tzeddiɣt d tḥenya n uɛarreḍ d ipilaren nnes d tyarsawin nnes, ");
INSERT INTO rifl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","d ipilaren n řemraḥ i d as dd-innḍen ak-d tyarsawin nsen d řewtad nsen d iseɣwan nsen, aqa d ta d tasɣart nsen di trebbut n marra řeqcuɛ nsen u di marra tasexxart i dd-ittasen ak-d marra man aya. Řeqcuɛ i ittxeṣṣa ad ten arbun, ittxeṣṣa kenniw ad ten tzemmed s ismawen nsen. ");
INSERT INTO rifl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","D ta d tasexxart n řaǧat n ayt n Marari ɣar marra tasexxart nsen deg Uqiḍun n Umsagar sadu ufus n Itamar, mmis n Harun, akehhan.” ");
INSERT INTO rifl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa d Harun d řḥukkam n tmesmunt ḥesben ayt n Qahat, am ttwasettfen nitni ɛlaḥsab řaǧat nsen u ɛlaḥsab tudrin n ibabaten nsen, ");
INSERT INTO rifl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","zeg wenni ɣar iǧa třatin n iseggʷusa sennej, ař wenni ɣar iǧa xemsin n iseggʷusa, kuř ijj i ɣa yadfen maḥend ad isexxar deg Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Inni zzaysen ittwaḥesben, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, tuɣa aten di ařfayen u-sebɛa-mya u-xemsin. ");
INSERT INTO rifl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ina d inni ittwaḥesben zi řaǧat n Iqahatiyyen, marra wi ittsexxaren deg Uqiḍun n Umsagar, inni ḥesben Musa d Harun x řumur n SIDI sadu ufus n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Inni ittwaḥesben zeg ayt n Jarcun, am ttwasettfen nitni ɛlaḥsab řaǧat nsen u ɛlaḥsab tudrin n ibabaten nsen, ");
INSERT INTO rifl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","zeg wenni ɣar iǧa třatin n iseggʷusa sennej, ař wenni ɣar iǧa xemsin n iseggʷusa, kuř ijj i ɣa yadfen maḥend ad isexxar deg Uqiḍun n Umsagar, ");
INSERT INTO rifl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","aqa inni zzaysen ittwaḥesben, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, tuɣa aten di ařfayen u-setta-mya u-třatin, ");
INSERT INTO rifl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ina d inni ittwaḥesben n řaǧat n ayt n Jarcun, marra wi ittsexxaren deg Uqiḍun n Umsagar, inni ḥesben Musa d Harun x řumur n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ina d inni ittwaḥesben n řaǧat n ayt n Marari, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, ɛlaḥsab tudrin n ibabaten nsen, ");
INSERT INTO rifl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","zeg wenni ɣar iǧa třatin n iseggʷusa sennej, ař wenni ɣar iǧa xemsin n iseggʷusa, kuř ijj i ɣa yadfen di řɛeskar maḥend ad isexxar deg Uqiḍun n Umsagar, ");
INSERT INTO rifl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","aqa inni zzaysen ittwaḥesben, am ttwasettfen nitni ɛlaḥsab řaǧat nsen, tuɣa aten di teřt-ařaf u-mitayen. ");
INSERT INTO rifl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ina d inni ittwaḥesben n řaǧat n Marari, inni ḥesben Musa d Harun x řumur n SIDI sadu ufus n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Marra inni ittwaḥesben, inni ḥesben Musa d Harun d řḥukkam n Israil zeg Ilawiyyen, am ttwasettfen nitni ɛlaḥsab řaǧat nsen u ɛlaḥsab tudrin n ibabaten nsen, ");
INSERT INTO rifl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","zeg wenni ɣar iǧa třatin n iseggʷusa sennej ař wenni ɣar iǧa xemsin n iseggʷusa, marra wenni i ɣa yadfen maḥend ad igg řxedmet n tsexxart u řxedmet n trebbut n ddquřat deg Uqiḍun n Umsagar, ");
INSERT INTO rifl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","aqa inni zzaysen ittwaḥesben tuɣa aten di temn-ařaf u-xemsa-mya u-tmanin. ");
INSERT INTO rifl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Nitni ttwaḥesben x řumur n SIDI sadu ufus n Musa, kuř aryaz ittwařeqqem di tsexxart nnes u x ddqeř nnes. Nitni ttwaḥesben zzayes am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Umur ayt n Israil ad ssuffɣen marra ayt n řbarṣ zi řmargeḥ n řɛeskar, uřa d marra inni ɣar iǧa useyyeř d marra inni ittwassxemjen zeg ict n řxecbet. ");
INSERT INTO rifl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ad ten tessuffɣem, am yeryazen am temɣarin. Kenniw ad ten tessuffɣem barra i řmargeḥ n řɛeskar ḥima war ssxemmajen řemrageḥ nsen mani zeddɣeɣ Necc di řwesṭ nsen.” ");
INSERT INTO rifl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Uca ggin ayt n Israil ammu. Nitni ssuffɣen ten barra i řmargeḥ n řɛeskar. Ayt n Israil ggin am mammec i inna SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Siweř ak-d ayt n Israil: ‘Mařa ijj n weryaz niɣ ict n temɣart i iggin ca n ddenb n bnadem i zi iɣdar di SIDI, xenni ad yiři řeɛmar nni d bu-umarwas. ");
INSERT INTO rifl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ad neɛmen x ddenb nsen i ggin. Netta ad ixeǧeṣ amarwas nnes marra u ad as yarni ict n tesɣart texmusect uca ad iwc aya i wenni idewřen itturs as netta. ");
INSERT INTO rifl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Maca mařa war din iǧi umefdi i weryaz nni, maḥend ad as ixeǧeṣ amarwas, xenni ad yiři umarwas, i ittxeṣṣa ad ixeǧeṣ i SIDI, i ukehhan, ak-d d icarri n weṣřaḥ i zzayes t ɣa isseṣřeḥ.    ");
INSERT INTO rifl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kuř tawhibt nni ssgeɛɛden ayt n Israil n tewhibin iqeddsen nni dd-ittawyen ɣar ukehhan ad tiři nnes. ");
INSERT INTO rifl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Marra tiwhibin iqeddsen n ca n weryaz ad iřint i netta, min ma i ɣa iwc ijj n weryaz i ukehhan, d man aya ad yiři i netta.’” ");
INSERT INTO rifl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Siweř ak-d ayt n Israil uca ini asen: ‘Mařa tamɣart n ca n weryaz teffeɣ u teɣdar i-t, ");
INSERT INTO rifl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","u ca n weryaz issen i-tt, uca man aya innufaren i tiṭṭawin n weryaz nnes u nettat tessnuffar i-t uca ammu tessexmej ixef nnes u war din wi xas ɣa icehden u nettat ɛemmarṣ war tᵉttwaṭṭef, ");
INSERT INTO rifl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","uca xenni yusa-dd xas buḥbeř n tusmi uca yusem x temɣart nnes umi nettat tᵉttwassexmej, niɣ yusa-dd xas buḥbeř n tusmi uca yusem x temɣart nnes umi nettat war tᵉttwassexmij ca, ");
INSERT INTO rifl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","xenni aryaz ad yawi tamɣart nnes ɣar ukehhan uca ad yawi tawhibt nnes i nettat, aqa-tt d taɛcart n ijj n ifa n waren n imendi. War xas ifarreɣ zzect niɣ ad xas issars jjawi, minzi aqa-tt d tawhibt n řɣiǧet di ssibbet n tusmi, ict n tewhibt n řɣiǧet i řidaret, tenni dd ɣa yawyen axarreṣ di řmuɛṣiyyet. ");
INSERT INTO rifl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ad tt-i-dd-issqarreb ukehhan uca ad tt issars zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ad iksi ukehhan aman iqeddsen deg ict n řqecɛet n třaxt uca ad iksi ca zeg ucař i iǧan di temmurt n Tzeddiɣt, ad yegg aya deg waman. ");
INSERT INTO rifl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Xenni ad igg ukehhan tamɣart nni zzat i wudem n SIDI, ad ifekk acuwwaf n uzeǧif n temɣart uca ad igg tawhibt n řɣiǧet i řidaret deg ifassen nnes, aqa d tawhibt n řɣiǧet n tusmi. Akehhan ad iṭṭef deg ufus nnes aman imerzagen nni dd-ittawyen nneɛřet. ");
INSERT INTO rifl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Akehhan ad tt yejj ad tejjaǧ uca ad yini i temɣart: Mařa war kim iṭṭiṣ ḥed u war tewḍid zeg weryaz nnem di texmuji, aqa ad tiřid tᵉttwaṣfid zeg waman-a imerzagen inni dd-ittawyen nneɛřet. ");
INSERT INTO rifl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Maca uct xam, mařa tewḍid zeg weryaz nnem uca tᵉttwassxemjed uca ijj n weryaz mɣir aryaz nnem iṭṭeṣ akim! ");
INSERT INTO rifl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Xenni ad yejj ukehhan tamɣart ad tejjaǧ tajaǧit n nneɛřet. Ad yini ukehhan i temɣart: SIDI ad cem yarr d ijj n umedya n nneɛřet-a d tjaǧit-a di řwesṭ n řgens nnem, xmi ɣa yejj SIDI ad iwḍa umeṣṣaḍ nnem uca ad yarr aɛeddis nnem yuff, ");
INSERT INTO rifl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","uca aman-a i dd-ittawyen nneɛřet ad adfen ɣar wadan nnem maḥend ad ssuffen aɛeddis nnem uca ad ssɣeḍřen ameṣṣaḍ nnem! Uca ad tini temɣart: Amin Amin! ");
INSERT INTO rifl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ad yari ukehhan nnɛaři-ya x ict n tewriqt ittwannḍen uca xenni ad tent imḥa deg waman imerzagen. ");
INSERT INTO rifl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ad iwc aman imerzagen i dd-ittawyen nneɛřet i temɣart u nettat ad tsu ařami aman i dd-ittawyen nneɛřet ad dayes adfen daxeř uca ad dewřen d imerzagen. ");
INSERT INTO rifl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Akehhan ad iksi tawhibt n řɣiǧet n tusmi zeg ufus n temɣart uca ad issenhezz tawhibt n řɣiǧet zzat i wudem n SIDI uca ad tt-i-dd issqarreb ɣar uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ad iksi ukehhan ijj n wuru zi tewhibt n řɣiǧet, aqa-tt d tawhibt n řidaret, uca ad issbexxar aya x uɛalṭar uca xenni ad iwc aman i temɣart ad tsu. ");
INSERT INTO rifl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Mařa iwca as aman ad tsu, xenni, mařa tᵉttwassexmej uca nettat teɣdar aryaz nnes, aman i dd-ittawyen nneɛřet ad dayes dewřen d imerzagen uca aɛeddis nnes ad yuff uca ameṣṣaḍ nnes ad ittwaɣḍeř u tamɣart ad tedweř d nneɛřet di řwesṭ n řgens nnes. ");
INSERT INTO rifl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Maca mařa war texmij ca temɣart, maca tezdeg, xenni ad tiři war xas ca, ad tiři tᵉttaru.’” ");
INSERT INTO rifl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Wa d azerf zi jjihet n tusmi, xmi tewḍa ict n temɣart zeg weryaz nnes uca tᵉttwassexmej ");
INSERT INTO rifl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","niɣ xmi dd yusa buḥbeř n tusmi x weryaz uca netta yusem x temɣart nnes. Xenni ad yarra tamɣart ad tbedd zzat i wudem n SIDI u akehhan ad as ikemmeř marra azerf-a wa. ");
INSERT INTO rifl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Aryaz ad yiři d amezdag zi ssibbet n řmuɛṣiyyet, tamɣart-a ad tarbu řmuɛṣiyyet nnes. ");
INSERT INTO rifl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Siweř ak-d ayt n Israil uca ini asen: ‘Mařa ijj n weryaz niɣ ict n temɣart i iwejden maḥend ad iwc awař n ttaj n ucuwwaf n lwaɛd, maḥend ad iɛzeř ixef nnes s ttaj nni i SIDI, ");
INSERT INTO rifl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","xenni ad iggʷej x binu d ccrab. War isess řxeǧ zi binu niɣ řxeǧ zi ccrab u war isess aman n uḍiř, u war ittett zeg uḍiř azeyza niɣ zeg uḍiř yuẓɣen. ");
INSERT INTO rifl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Marra ussan n ttaj nnes n weɛzař war ittett ca min dd-iffɣen zi tzayart, zeg uɛeqqa nnes ař taqcurt nnes.’” ");
INSERT INTO rifl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Marra ussan n wawař i dd ttasen ak-d ttaj nnes n weɛzař war ittekk řmus x uzeǧif nnes ař ɣa kemmřen wussan nni iɛzeř i SIDI uca ad yiři iqeddes uca ad yejj iɛeyyacen n ucuwwaf n uzeǧif nnes ad mɣaren. ");
INSERT INTO rifl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Marra ussan i issḥuzz i SIDI, war dd-ittqarrib ca ɣar řeɛmar n ijj n umettin. ");
INSERT INTO rifl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","War issxemmij ixef nnes x babas niɣ x yemmas niɣ x umas niɣ x učmas mařa gguren ad mmten, minzi ttaj n weɛzař n AREBBI nnes aqa-tt x uzeǧif nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","“Marra ussan n ttaj nnes n weɛzař ad yiři iqeddes i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Mařa wenni ittmettan ad immet deɣya deg wermac n wabřiwen uca issexmej azeǧif nnes s ttaj nnes n weɛzař, xenni ad iḥeff azeǧif nnes deg wass n usizdeg nnes. Deg wass wiss sebɛa ittxeṣṣa ad t iḥeff. ");
INSERT INTO rifl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Deg wass wiss tmenya ad yawi tnayen n tejlilliḥin niɣ tnayen n iḍbiren ɣar ukehhan ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Akehhan ad issewjed ict d taɣarṣt n ddenb d ict d taɣarṣt n wecmaḍ uca ad t isseṣřeḥ, minzi netta aqa ixḍa di ssibbet n umettin. Netta ad issqeddes azeǧif nnes ɛawed deg wass nni ");
INSERT INTO rifl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","uca twařa nneɣni ad ineyyec netta ussan n ttaj nnes n weɛzař i SIDI uca ad iqeddem ijj n izmar n ijj n useggʷas d taɣarṣt n umarwas. Ussan iɛdun ad iřin wḍan minzi aqa tᵉttwassexmej ttaj nnes n weɛzař.” ");
INSERT INTO rifl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Wa d azerf n wenni yarebbun ttaj n weɛzař: deg wass min di ttwakemmřen wussan n ttaj nnes n weɛzař, ad t awyen ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Xenni ad dd-issqarreb tawhibt nnes ɣar SIDI, ijj n izmar icnan qaɛ n ijj n useggʷas am tɣarṣt n wecmaḍ d ict n texsi icnan qaɛ n ijj n useggʷas am tɣarṣt n ddenb d ijj n icarri icnan qaɛ am tɣarṣt n řehna ");
INSERT INTO rifl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","d ict n tsuǧet ak-d weɣrum břa antun d řemsemnat n waren azdad ixeǧḍen s zzect d teřfaf n weɣrum břa antun ttwadehnent s zzect uřa d tawhibt nnes n řɣiǧet d tewhibin nnes n useyyeb.” ");
INSERT INTO rifl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Akehhan ad yawi man aya zzat i wudem n SIDI uca ad issewjed taɣarṣt nnes n ddenb d tɣarṣt nnes n wecmaḍ. ");
INSERT INTO rifl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ad issewjed icarri am tɣarṣt n řehna i SIDI uřa d tasuǧet ak-d tecnifin břa antun uca akehhan ad issewjed ɛawed tawhibt n řɣiǧet nnes d tewhibin n useyyeb nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Xenni wenni yarebbun ttaj n weɛzař ad iḥeff azeǧif n ttaj nnes n weɛzař ɣar wadaf n Uqiḍun n Umsagar uca ad iksi acuwwaf n uzeǧif n ttaj nnes n weɛzař uca ad yegg aya x tmessi i iǧan sadu tɣarṣt n řehna. ");
INSERT INTO rifl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Xenni ad iksi ukehhan tameṣṣaḍt n zzat yenggʷan n icarri d ict n temsemment břa antun zi tsuǧet d ict n teřfeft břa antun uca ad tent issars x ifassen n wenni yarebbun ttaj n weɛzař awarni ma iḥeff ttaj nnes n weɛzař. ");
INSERT INTO rifl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Akehhan ad tent issenhezz zi ssa ɣar da zzat i wudem n SIDI. Aqa-tt d ict n tmesřact tamqeddast i ukehhan, ak-d idmaren n wenhezzi u ak-d ucekrud n tewhibt ittwassgeɛɛden. Awarni aya iɛeddeř i wenni yarebbun ttaj n weɛzař maḥend ad isu binu.” ");
INSERT INTO rifl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Wa d azerf n wenni yarebbun ttaj n weɛzař, wenni tuɣa iwaɛden i SIDI tawhibt nnes di ssibbet n ttaj n weɛzař nnes, barra min izemmar ufus nnes ɛad ad issiweḍ. Ittxeṣṣa as ad yegg ɛlaḥsab awař i iwcin, ɛlaḥsab azerf n ttaj n weɛzař nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Siweř ak-d Harun d warraw nnes uca ini: ‘Ammu ad tbarkem ayt n Israil uca ad asen tinim: ");
INSERT INTO rifl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","SIDI ad ac ibarek uca ad cek iḥḍa! ");
INSERT INTO rifl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","SIDI ad yarr udem nnes ad xak yegg tfawt uca ad xak iḥinn. ");
INSERT INTO rifl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","SIDI ad ɣarek dd-inneqřeb udem nnes uca ad ac iwc řehna!’ ");
INSERT INTO rifl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ad ssiwḍen Isem inu x ayt n Israil u Necc ad ten barkeɣ.’” ");
INSERT INTO rifl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Imsar deg wass min di ikemmeř Musa asbeddi n Tzeddiɣt, idhen u issqeddes i-tt ak-d řeqcuɛ nnes uřa d marra aɛalṭar ak-d řeqcuɛ nnes. Aqa idhen i-ten uca issqeddes i-ten. ");
INSERT INTO rifl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Xenni qarrben-dd řḥukkam n Israil, izeǧifen n tudrin n řejdud nsen. Nitni d řḥukkam n tqebbař, nitni tuɣa x yinni ittwaḥesben. ");
INSERT INTO rifl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Nitni iwyen-dd tawhibt nsen zzat i wudem n SIDI: setta n ikarruten ak-d tseqqift d tenɛac n ifunasen, aqa d ijj n ukarru i tnayen n řḥukkam d ijj n ufunas i kuř ijj n řḥakem uca iwyen ten zzat i wudem n Tzeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ksi aya zzaysen, ḥima ad iřin i řxedmet n tsexxart n Uqiḍun n Umsagar. Ittxeṣṣa ad ten tewced i Ilawiyyen, i kuř aryaz am mammec dd-ittas ak-d tsexxart nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Uca Musa iṭṭef ikarruten d ifunasen uca iwca i-ten i Ilawiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Tnayen n ikarruten d arebɛa n ifunasen i iwca i ayt n Jarcun, am mammec dd-ittas ak-d tsexxart nsen, ");
INSERT INTO rifl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","u i ayt n Marari iwca asen arebɛa n ikarruten d tmenya n ifunasen, am mammec dd-ittas ak-d tsexxart nsen sadu ufus n Itamar, mmis n ukehhan Harun. ");
INSERT INTO rifl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","I ayt n Qahat war d asen iwci walu, minzi tuɣa xasen tasexxart n Zzawect Iqeddsen, nitni arbun Zzawect x tɣarwaḍ nsen. ");
INSERT INTO rifl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Xenni qarrben-dd řḥukkam ak-d tewhibt i udeccen n uɛalṭar deg wass min di ittwadhen uɛalṭar. Iwyen řḥukkam tiwhibin nsen zzat i wudem n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Inna SIDI i Musa: “Ijj n řḥakem deg ijj n wass, xenni ɛawed ijj n řḥakem deg wass awarni as, ammu i ɣa qeddmen nitni tiwhibin nsen i udeccen n uɛalṭar.” ");
INSERT INTO rifl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Deg wass amezwaru iqeddem Naḥcun, mmis n Ɛamminadab, zi teqbič n Yahuda, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ijj n ufunas - ameẓyan n tfunast - ijj n icarri, ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","u i tɣarṣt n řehna: tnayen n ifunasen d xemsa n icarriyyen d xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Naḥcun, mmis n Ɛamminadab. ");
INSERT INTO rifl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Deg wass wiss tnayen iqeddem Natanayil, mmis n Ṣuɣar, wenni d řḥakem n Issakar, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Natanayil, mmis n Ṣuɣar. ");
INSERT INTO rifl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Deg wass wiss třata iqeddem řḥakem n ayt n Zabulun, Iliyab, mmis n Ḥilun, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Iliyab, mmis n Ḥilun. ");
INSERT INTO rifl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Deg wass wiss arebɛa iqeddem řḥakem n ayt n Rubin, Aliṣur, mmis n Cadayyur, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Aliṣur, mmis n Cadayyur. ");
INSERT INTO rifl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Deg wass wiss xemsa iqeddem řḥakem n ayt n Cimɛun, Calumiyil, mmis n Ṣuricadday, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Calumiyil, mmis n Ṣuricadday. ");
INSERT INTO rifl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Deg wass wiss setta iqeddem řḥakem n ayt n Jad, Aliyasaf, mmis n Daɛuyil, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Aliyasaf, mmis n Daɛuyil. ");
INSERT INTO rifl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Deg wass wiss sebɛa iqeddem řḥakem n ayt n Ifrayim, Ilicamaɛ, mmis n Ɛammihud, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Ilicamaɛ, mmis n Ɛammihud. ");
INSERT INTO rifl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Deg wass wiss tmenya iqeddem řḥakem n ayt n Manassa, Jamaliyil, mmis n Fadahṣur, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Jamaliyil, mmis n Fadahṣur. ");
INSERT INTO rifl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Deg wass wiss tesɛa iqeddem řḥakem n ayt n Binyamin, Abidan, mmis n Jidɛuni, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Abidan, mmis n Jidɛuni. ");
INSERT INTO rifl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Deg wass wiss ɛecra iqeddem řḥakem n ayt n Dan, Axiɛazar, mmis n Ɛamicadday, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Axiɛazar, mmis n Ɛamicadday. ");
INSERT INTO rifl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Deg wass wiss ḥiṭac iqeddem řḥakem n ayt n Acir, Fajɛiyil, mmis n Ɛukran, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Fajɛiyil, mmis n Ɛukran. ");
INSERT INTO rifl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Deg wass wiss tenɛac iqeddem řḥakem n ayt n Naftali, Axiraɛ, mmis n Ɛiynan, tawhibt nnes. ");
INSERT INTO rifl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Tuɣa-tt tawhibt nnes: ijjen ṭṭebṣi n nnuqart n mya u-třatin ciqlu n ddqeř, d icten ṭṭawya i urucci n nnuqart n sebɛin ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Tuɣa-ten s tnayen ccuren s waren azdad ixeǧḍen s zzect am tewhibt n řɣiǧet. ");
INSERT INTO rifl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Xenni ict n tɣenjact n wureɣ n ɛecra ciqlu teccur s řebxur, ");
INSERT INTO rifl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ijj n ufunas - ameẓyan n tfunast - ijj n icarri d ijj n izmar n ijj n useggʷas am tɣarṣt n wecmaḍ, ");
INSERT INTO rifl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ijj n umyan zeg iɣayḍen i tɣarṣt n ddenb ");
INSERT INTO rifl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","u i tɣarṣt n řehna: tnayen n ifunasen, xemsa n icarriyyen, xemsa n iɣayḍen d xemsa n izmaren n ijj n useggʷas. Aqa ta d tawhibt n Axiraɛ, mmis n Ɛiynan. ");
INSERT INTO rifl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Tuɣa ta d tawhibt i udeccen n uɛalṭar zi řḥukkam n Israil deg wass nni di ittwadhen uɛalṭar: tenɛac n ṭṭbaṣi n nnuqart d tenɛac n ṭṭawyat i urucci n nnuqart d tenɛac n tɣenjayin n wureɣ. ");
INSERT INTO rifl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ijjen ṭṭebṣi n nnuqart iwzen mya u-třatin ciqlu d icten ṭṭawya i urucci iwzen sebɛin ciqlu. Marra nnuqart n řeqcuɛ nni tewzen ařfayen u-arebɛa-mya ciqlu ɛlaḥsab ciqlu n Zzawect Iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tenɛac n tɣenjayin n wureɣ ccurent s řebxur. Kuř taɣenjayt tewzen ɛecra ciqlu, ɛlaḥsab ciqlu n Zzawect Iqeddsen. Marra ureɣ n tɣenjayin iwzen mya u-ɛicrin ciqlu. ");
INSERT INTO rifl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Marra řebhayem i tɣarṣt n wecmaḍ aqa daysent tenɛac n ifunasen imeẓyanen, tenɛac n icarriyyen, tenɛac n izmaren n ijj n useggʷas ak-d tewhibt n řɣiǧet nsen, u tenɛac imyanen zeg iɣayḍen i tɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Marra řebhayem n tɣarṣt n řehna aqa daysent arebɛa u-ɛicrin n ifunasen imeẓyanen, settin n icarriyyen d settin n iɣayḍen d settin n izmaren n ijj n useggʷas. Man aya d tawhibt i udeccen n uɛalṭar awarni ittwadhen. ");
INSERT INTO rifl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Umi yudef Musa ɣar Uqiḍun n Umsagar, ḥima ad kides issiweř, isřa Tmijja tessiweř akides zi sennej n tqebbart n weṣřaḥ i iǧan x Ttabut n Cchadet, zi jar tnayen n ikiruben. Ammu i issiweř SIDI akides. ");
INSERT INTO rifl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Siweř ak-d Harun, ini as: ‘Xmi ɣa tessarsed tifawin x řqendiř, ittxeṣṣa sebɛa n tfawin ad wcent tafawt ɣar zzat n řqendiř.’” ");
INSERT INTO rifl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Uca ammu i igga Harun. Issars tifawin nnes ɣar zzat n řqendiř, am mammec d as yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Tuɣa řqendiř d ict n ṣṣenɛet n wureɣ yeɛdeř s wefḍis. Zeg ufuḍ x uḍar nnes ař nnuwwarat nnes tuɣa ittwagg s wefḍis. Ɛlaḥsab amedya i d as isccen SIDI, ammu i iṣenneɛ řqendiř. ");
INSERT INTO rifl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ksi Ilawiyyen zi jar řwesṭ n ayt n Israil uca sizdeg i-ten. ");
INSERT INTO rifl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ammu i d asen ɣa tegged ḥima ad ten tessizedged: Rucc i-ten s waman n usizdeg. Ittxeṣṣa asen ad ḥeffen marra arrimet nsen uca ad ssirden arruḍ nsen uca ad ssizdegen ixef nsen. ");
INSERT INTO rifl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Xenni ad ksin ijj n ufunas, ameẓyan n tfunast, ak-d tewhibt n řɣiǧet nnes n waren azdad ixeǧḍen s zzect u ɛawed ijj n ufunas wiss tnayen, ameẓyan n tfunast, am tɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ad tawyed Ilawiyyen zzat i Uqiḍun n Umsagar uca ad tessmuned marra tamesmunt n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ad dd-tessqarrbed Ilawiyyen zzat i wudem n SIDI uca ayt n Israil ad ssarsen ifassen nsen x Ilawiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ad yejj Harun ad hezzen Ilawiyyen zi ssa ɣar da zzat i wudem n SIDI am yict n tewhibt n wenhezzi di ṭṭweɛ n ayt n Israil. Nitni ad dewřen ttsexxaren di tsexxart n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ilawiyyen ad ssarsen ifassen nsen x izeǧifen n ifunasen imeẓyanen uca ad tesswejded ijj i tɣarṣt n ddenb d yijj i tɣarṣt n wecmaḍ i SIDI, ḥima ad zzaysen ittwagg weṣřaḥ i Ilawiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ad tegged Ilawiyyen ad bedden zzat i wudem n Harun u zzat i wudem n warraw nnes uca ad ten tarred ad hezzen zi ssa ɣar da am yict n tewhibt n wenhezzi zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ammu i ɣa tḥuzzed Ilawiyyen zi řwesṭ n ayt n Israil ḥima Ilawiyyen ad iřin inu. ");
INSERT INTO rifl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Awarni man aya ad dd-asen Ilawiyyen ḥima ad sexxaren deg Uqiḍun n Umsagar. Ad ten tessizedged uca ad ten tarred ad hezzen zi ssa ɣar da am yict n tewhibt n wenhezzi, ");
INSERT INTO rifl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","minzi nitni ttwammewcen ayi nican zi řwesṭ n ayt n Israil, uca Necc ksiɣ ten i Yixef inu deg wemcan n marra min yarezmen řemřawet d amezwaru, deg wemcan n umenzu n marra ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Minzi marra amenzu jar ayt n Israil aqa-t inu, zeg iwdan, ammu zi řmař, zeg wass i di nɣiɣ Necc marra imenza di temmurt n Miṣra, ssqeddseɣ ten i Necc. ");
INSERT INTO rifl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Necc ksiɣ Ilawiyyen deg wemcan n marra imenza jar ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Necc wciɣ Ilawiyyen i Harun u i warraw nnes am yijj n uriɣalu zi řwesṭ n ayt n Israil, maḥend ad ggen tasexxart n ayt n Israil deg Uqiḍun n Umsagar u maḥend ad ittwagg weṣřaḥ di ṭṭweɛ n ayt n Israil, ḥima war tᵉttiři jjriḥect x ayt n Israil xmi dd ɣa qarrben ayt n Israil ɣar Zzawect Iqeddsen.” ");
INSERT INTO rifl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa d Harun d marra tamesmunt n ayt n Israil ggin ak-d Ilawiyyen ɛlaḥsab marra min d as yumur SIDI i Musa zi jjihet n Ilawiyyen, ammu i ggin ayt n Israil akidsen. ");
INSERT INTO rifl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ilawiyyen ssizdigen ixef nsen zi ddenb nsen uca ṣebbnen arruḍ nsen uca Harun yarra i-ten ad nhezzen zi ssa ɣar da am yict n tewhibt n wenhezzi zzat i wudem n SIDI uca Harun isseṣřeḥ i-ten i usizdeg nsen. ");
INSERT INTO rifl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Awarni man aya usin-dd Ilawiyyen ḥima ad sexxaren deg Uqiḍun n Umsagar zzat i wudem n Harun u zzat i wudem n warraw nnes am mammec d as yumur SIDI i Musa zi jjihet n Ilawiyyen, ammu i kidsen ggin. ");
INSERT INTO rifl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ta zi jjihet n Ilawiyyen: aqa ittxeṣṣa i kuř mmis n xemsa u-ɛicrin n iseggʷusa sennej ad dd-yas, ḥima ad isexxar di ṭṭweɛ n tsexxart n Uqiḍun n Umsagar ");
INSERT INTO rifl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","u xmi i ɣa yiweḍ ɣar xemsin n iseggʷusa ad iffeɣ zi řɛeskar n tsexxart u war iqqim ittsexxar ɛad ktar. ");
INSERT INTO rifl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ad iwc afus i yaytmas deg Uqiḍun n Umsagar ḥima ad xas ḥḍan, maca netta s yixef nnes war izemmar ad isexxar. Ammu i ɣa tegged ak-d Ilawiyyen zi jjihet n uḥeṭṭu i xasen ittwaggen.” ");
INSERT INTO rifl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Issiweř SIDI ak-d Musa di řexřa n Sina deg useggʷas wiss tnayen awarni řami dd-ffɣen zi temmurt n Miṣra, deg uyur amezwaru, inna: ");
INSERT INTO rifl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Jjem ayt n Israil ad sswejden Taɣarṣt n Useɛdu di řweqt nnes ittwaggen. ");
INSERT INTO rifl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Deg wass wiss arbeɛṭac n uyur-a, jar beddu n wezyen n wass ař dd-tewḍa tmeddit, ittxeṣṣa ad tt tesswejdem di řweqt nnes ittwaggen. Ittxeṣṣa ad tt tesswejdem ɛlaḥsab marra tiweṣṣa d lfarayiḍ nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Issiweř Musa ak-d ayt n Israil, inna ittxeṣṣa asen ad sswejden Taɣarṣt n Useɛdu. ");
INSERT INTO rifl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Uca nitni sswejden Taɣarṣt n Useɛdu deg wass wiss arbeɛṭac n uyur amezwaru di řexřa n Sina, jar beddu n wezyen n wass ař dd-tewḍa tmeddit, ɛlaḥsab marra min d as yumur SIDI i Musa, ammu i tt sswejden ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ca n yeryazen ttwassxemjen s řxecbet n ijj n bnadem immuten uca war zemmaren ad sswejden Taɣarṣt n Useɛdu. X uya qarrben-dd nitni deg wass nni zzat i wudem n Musa u zzat i wudem n Harun ");
INSERT INTO rifl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","uca nnan as yeryazen nni: “Neccin nexmej s řxecbet n ijj n bnadem immuten. Mayemmi i nettwassbedd ařami war nzemmar ad dd-nessqarreb tawhibt n SIDI deg wass nnes ittwaggen di řwesṭ n ayt n Israil?” ");
INSERT INTO rifl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa inna asen: “Qqimem tbeddem, ḥima ad sřeɣ min d awem ɣa iweṣṣa SIDI.” ");
INSERT INTO rifl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Siweř ak-d ayt n Israil uca ini: ‘Mařa ḥed zzaywem niɣ zi jjiřat nwem i dd ɣa yasen ittwassexmej zi řxecbet n yijj n umettin, niɣ netta deg webrid d azirar, xenni ad issewjed ɛad Taɣarṣt n Useɛdu i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Deg uyur wiss tnayen, deg wass wiss arbeɛṭac, jar beddu n wezyen n wass ař dd-tewḍa tmeddit, ad tt sswejden. Xenni ad tt ccen ak-d weɣrum břa antun u ak-d řebzar yarezgen. ");
INSERT INTO rifl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","War ttejjin zzayes walu ař ṣṣbeḥ uca war zzayes ttareẓẓan iɣes. Ittxeṣṣa ad tt sswejden ɛlaḥsab marra tiweṣṣa n Tɣarṣt n Useɛdu.’” ");
INSERT INTO rifl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Mařa ijj n weryaz d amezdag i war iǧin deg webrid, ad yejj ad issewjed Taɣarṣt n Useɛdu, xenni ad ittwaqess řeɛmar nni zi řgens nnes, minzi netta war dd-issqarreb ca tawhibt n SIDI di řweqt nnes ittwaggen. Aryaz nni ad yarbu ddenb nnes. ");
INSERT INTO rifl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Mařa izdeɣ akidwem ijj n ubarrani, wenni i ɣa isswejden Taɣarṣt n Useɛdu n SIDI, xenni ad issewjed Taɣarṣt n Useɛdu ɛlaḥsab tawṣeyyet n Taɣarṣt n Useɛdu u ɛlaḥsab lfarayiḍ nnes. Ad din tiři ict n tewṣeyyet i kenniw, i ubarrani ammu i wenni dd-ixeřqen di temmurt.” ");
INSERT INTO rifl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Deg wass min di tᵉttwassgeɛɛed Tzeddiɣt, idřa useynu Tazeddiɣt ak-d Uqiḍun n Cchadet u di ǧiřet iḍhar-dd x Tzeddiɣt am tmessi ař ṣṣbeḥ. ");
INSERT INTO rifl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ammu i tuɣa řebda, aseynu idřa i-tt u di ǧiřet iḍhar-dd am tmessi. ");
INSERT INTO rifl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Řami dd-igeɛɛed useynu zi sennej n Uqiḍun, xenni awarni aya fesyen ayt n Israil iqiḍan nsen u deg wemcan mani tuɣa dd-ibedd useynu, din i wtin ayt n Israil iqiḍan nsen. ");
INSERT INTO rifl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Fesyen ayt n Israil iqiḍan nsen ɛlaḥsab řumur n SIDI uca x řumur n SIDI wtin iqiḍan nsen. Marra ussan tuɣa aseynu iqqim sennej i Tzeddiɣt, qqimen nitni zeddɣen din. ");
INSERT INTO rifl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Řami dd-ibedd useynu aṭṭas n wussan sennej i Tzeddiɣt, ḥḍan ayt n Israil tasexxart n SIDI uca war fesyen ca iqiḍan nsen. ");
INSERT INTO rifl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Umi iqqim useynu cwayt n wussan sennej i Tzeddiɣt, xenni wtin nitni iqiḍan nsen ɛlaḥsab řumur n SIDI u x řumur n SIDI fesyen iqiḍan nsen ɛawed. ");
INSERT INTO rifl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Mařa imsar belli aseynu ibedd din zi ǧiřet ař ṣṣbeḥ uca igeɛɛed useynu di ṣṣbeḥ, xenni fesyen nitni iqiḍan nsen. Ma deg wass i iǧa niɣ di ǧiřet, xmi dd-igeɛɛed useynu, fesyen nitni iqiḍan nsen. ");
INSERT INTO rifl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Uca mařa iqqim useynu ibedd sennej i Tzeddiɣt tnayen n wussan, niɣ ijj n uyur, niɣ aṭṭas n wussan, ařami xas ɣa yarsa, xenni qqimen ayt n Israil ttxeyymen dinni, war fesyen ca iqiḍan nsen. Mařa igeɛɛed useynu, xenni fesyen nitni iqiḍan nsen. ");
INSERT INTO rifl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","X řumur n SIDI wtin iqiḍan nsen u x řumur n SIDI fesyen iqiḍan nsen. Aqa ḥḍan min d asen yumur SIDI, x řumur n SIDI, s tsexxart n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Egg i yixef nnec tnayen n řebwaq iziraren n nnuqart, s yijj n umarsu s wefḍis ad ten tegged uca ad iřin i ubarreḥ n tmesmunt u i usmuṭṭi n řemrageḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Xmi daysen ɣa suḍen, ad ɣarek tmun tmesmunt marra ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Xmi ɣa suḍen deg ijj zi tnayen nni, xenni mɣir řḥukkam, izeǧifen x řuřuf n Israil, i xak dd ɣa imunen. ");
INSERT INTO rifl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Xmi ɣa tsuḍem s wesruddeḥ di řbuq, xenni ad mmuṭṭiyent řemrageḥ nni immarsen ɣar ccarq. ");
INSERT INTO rifl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Xmi ɣa tsuḍem s wesruddeḥ di řbuq tnayen n twařawin, xenni ad mmuṭṭiyent řemrageḥ nni immarsen ɣar uɣezdis n ljanub. Ad suḍen s wesruddeḥ umi ɣa muṭṭiyen zeg wemcan ɣar wemcan nneɣni. ");
INSERT INTO rifl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","I tmesmunt n wegraw n řgens ittxeṣṣa ad tsuḍem di řebwaq, maca břa asruddeḥ. ");
INSERT INTO rifl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ad suḍen warraw n Harun, ikehhanen, di řebwaq. Ad tiři d ict n tewṣeyyet i řebda i marra jjiřat nwem.” ");
INSERT INTO rifl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Xmi dd ɣa teffɣem ɣar garra di temmurt nwem, ḥima ad tmenɣem ak-d weɣrim nni kenniw dd-ihekkweřen, xenni ad tsuḍem s wesruddeḥ di řebwaq uca kenniw ad tᵉttwatidarem zzat i wudem n SIDI, AREBBI nwem, uca ad tnejmem zi řɛedyan nwem. ");
INSERT INTO rifl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ammu di kuř ijj n wass n řefraḥet u di řeɛyudat ittwaggen u deg umezwaru n iyuren nwem ad tsuḍem di řebwaq xmi ɣa tawyem tiɣarṣa n wecmaḍ nwem d tɣarṣa n uqadi nwem uca ammu i ɣa iřint di ṭṭweɛ nwem i řidaret zzat i wudem n AREBBI, Necc d SIDI, AREBBI nwem.” ");
INSERT INTO rifl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Imsar deg useggʷas wiss tnayen, deg uyur wiss tnayen, deg wass wiss ɛicrin n uyur, aqa ittwassgeɛɛed useynu zi sennej n Tzeddiɣt n Cchadet. ");
INSERT INTO rifl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Uca fesyen ayt n Israil iqiḍan nsen, mmuṭṭiyen zeg wemcan ɣar wemcan zi řexřa n Sina uca ibedd-dd useynu di řexřa n Faran. ");
INSERT INTO rifl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ammu fesyen iqiḍan nsen twařa tamezwarut, x řumur n SIDI, x ufus n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","D amezwaru tᵉttwakkes tɛeǧant n řmargeḥ n řɛeskar n ayt n Yahuda, uyuren am ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Naḥcun, mmis n Ɛamminadab, tuɣa d azeǧif x řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Natanayil, mmis n Ṣuɣar, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Issakar. ");
INSERT INTO rifl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Iliyab, mmis n Ḥilun, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Zibulun. ");
INSERT INTO rifl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Awarni man aya hedmen Tzeddiɣt uca fesyen ayt n Jarcun d ayt n Marari iqiḍan nsen uca arbun Tazeddiɣt. ");
INSERT INTO rifl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Xenni tᵉttwakkes tɛeǧant n řmargeḥ n řɛeskar n Rubin uyuren, ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Iliṣur, mmis n Cadayur, tuɣa d azeǧif x řɛeskar nnes. ");
INSERT INTO rifl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Calumiyil, mmis n Ṣuricadday, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Cimɛun. ");
INSERT INTO rifl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ilyasaf, mmis n Daɛuyil, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Jad. ");
INSERT INTO rifl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Xenni fesyen ayt n Qahat iqiḍan nsen, arbun Zzawect Iqeddsen. Uca ayt n Jarcun d ayt n Marari bnan Tazeddiɣt qbeř twasit nsen. ");
INSERT INTO rifl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Awarni as tᵉttwakkes tɛeǧant n řmargeḥ n řɛeskar n ayt n Ifrayim, uyuren, ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Ilicamaɛ, mmis n Ɛammihud, tuɣa d azeǧif x řɛeskar nnes. ");
INSERT INTO rifl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Jamaliyil, mmis n Fadahṣur, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Manassa. ");
INSERT INTO rifl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidun, mmis n Jidɛuni, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Binyamin. ");
INSERT INTO rifl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Xenni tᵉttwakkes tɛeǧant n řmargeḥ n řɛeskar n ayt n Dan, am uɣezdis uneggar n marra řemrageḥ, uca uyuren, ttwasettfen ɛlaḥsab tirbiɛin n řɛeskar nsen. Axiɛazar, mmis n Ɛammicadday, tuɣa d azeǧif x řɛeskar nnes. ");
INSERT INTO rifl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Fajɛiyil, mmis n Ɛukran, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Acir. ");
INSERT INTO rifl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Axiraɛ, mmis n Ɛinan, tuɣa d azeǧif x řɛeskar n teqbič n ayt n Zibulun. ");
INSERT INTO rifl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ammu i ssmuṭṭiyen ayt n Israil iqiḍan nsen zeg wemcan ɣar wemcan, am ttwasettfen nitni ɛlaḥsab řɛeskarat nsen, ammu i fesyen nitni iqiḍan nsen. ");
INSERT INTO rifl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Inna Musa i Ḥubab, mmis n Raɛuyil, Amidyani, aḍeggʷař n Musa: “Neccin ad nemmuṭṭi ɣar wemcan i d aneɣ inna SIDI: ‘Necc ad awem t-i-dd wceɣ!’ As-dd akidneɣ, ad ac negg tcuni, minzi SIDI issiweř x Israil s řxir.” ");
INSERT INTO rifl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Netta inna as: “Necc war ttriḥeɣ, maɣar ad uyureɣ ɣar temmurt inu u ɣar řaǧ inu.” ");
INSERT INTO rifl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Uca netta inna as: “Ttzawgeɣ cek, war d aneɣ ttejji, minzi cek tessned mammec icuwwar ad newwet iqiḍan nneɣ. Cek aqa tdewřed aneɣ - am mammec neqqar - am tiṭṭawin. ");
INSERT INTO rifl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Xmi ɣa traḥed akidneɣ uca ad aneɣ dd-yas řxir i dayneɣ ɣa igg SIDI, aqa neccin ad ac negg tcuni ɛawed.” ");
INSERT INTO rifl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Uca fesyen iqiḍan nsen, uyuren zeg wedrar n SIDI ticři n třata n wussan. Ttabut n Řɛahd tuyur zzat i wudem nsen ticři n třata n wussan, ḥima ad yarzu x ijj n wemcan i arraḥet. ");
INSERT INTO rifl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Deg uziř tuɣa aseynu n SIDI sennej nsen umi kksen iqiḍan nsen zi řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Řami tᵉttwassmuṭṭi Ttabut, temsar řebda belli Musa inna: “Kkar, a SIDI, ejj řeɛdyan nnec ad mmzeǧaɛen u inni kenniw icarrhen ad arewřen zeg wudem nnec!” ");
INSERT INTO rifl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ɣar ubeddi n Ttabut, inna: “Dweř-dd, a SIDI, ɣar ɛecra n řuřuf n řuřuf n Israil!” ");
INSERT INTO rifl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Imsar umi idweř řgens am yijj n ubarru ittcetcan, tuɣa man aya d řeḥriq i imezzuɣen n SIDI. Řami isřa SIDI aya, yarɣa weɣḍab nnes u timessi n SIDI tarɣa di řwesṭ nsen uca tecca řeḍruf n řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Xenni iřaɣa-dd řgens x Musa uca Musa iẓẓuǧ i SIDI uca texsi tmessi. ");
INSERT INTO rifl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Uca iřaɣa as i wemcan nni ‘Tabɛira’, minzi timessi n SIDI tuɣa tarɣa di řwesṭ nsen. ");
INSERT INTO rifl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Abarru imxeǧaḍen n ibarraniyyen nni iǧan di řwesṭ nsen, dewřen curren s umeẓri u bdan ayt n Israil ɛawed ad cettcan, nnan: “Wi d aneɣ ɣa iwcin aysum? ");
INSERT INTO rifl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nɛeqqeř ɛad x iseřman nni necca di Miṣra baṭeř u x řexyar d ddellaɛ d řebṣeř yuẓɣen d řebṣeř d ticcart. ");
INSERT INTO rifl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Řexxu řeɛmur nneɣ uẓɣen uca war din walu mɣir ‘manna’-ya zzat i tiṭṭawin nneɣ!” ");
INSERT INTO rifl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Tuɣa ‘manna’ ittemcabeh di zzariɛet n řqeṣbur uca ccuf nnes amecnaw ccuf n userɣaɣ acemřař qqaren as ‘bᵉdula’. ");
INSERT INTO rifl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Řgens iffeɣ, immsebḍa uca yrun tt uca ḥaryen tt sadu tsirt niɣ ddzen tt s wezduz uca xenni ssenggʷen tt di arwa uca ggin zzayes tifḍirin. Tuɣa aředdi nnes am min inggʷan s zzect. ");
INSERT INTO rifl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Xmi dd-ihekkwa nnda x řmargeḥ n řɛeskar, xenni thekkʷa-dd xas ‘manna’ ɛawed. ");
INSERT INTO rifl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Uca isřa Musa aqa řgens isɣuy, řaǧ awarni inneɣni, kuř ijj ɣar wadaf n uqiḍun nnes. Yarɣa weɣḍab n SIDI aṭṭas, uca tuɣa man aya uřa d tuɛeffna di tiṭṭawin n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Inna Musa i SIDI: “Mayemmi teggid řɣar deg umsexxar nnec u mayemmi war ufiɣ řxaḍar di tiṭṭawin nnec, umi xafi dd-tessarsed ddqeř n marra řgens-a? ");
INSERT INTO rifl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ma necc deyseɣ balak s marra řgens-a? Niɣ necc i-t-i-dd yurwen, maḥend tzemmared ad ayi tinid: ‘Awyi t deg wecyun nnec!’, am wenni issuṭṭuḍen yarebbu aseymi, ɣar temmurt min xef tejjuǧed Cek i řejdud nnes. ");
INSERT INTO rifl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Zi manis d asen-dd ɣa yawyeɣ aysum i ɣa wceɣ d macca i marra řgens-a? Minzi nitni sɣuyyun-dd ɣari, qqaren: ‘Ewc aneɣ aysum i ɣa necc!’ ");
INSERT INTO rifl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Necc weḥḥdi war zemmareɣ ad arbuɣ řgens-a marra, aqa man aya idqeř xafi aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Mařa dayi teggid ammu, necc ttzawageɣ ad ayi tenɣed ḥsen, mařa ufiɣ arḍa di tiṭṭawin nnec, xenni necc war ẓarreɣ řeɣben inu ɛad ktar!” ");
INSERT INTO rifl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Xenni inna SIDI i Musa: “Smun ayi-dd sebɛin n yeryazen zeg imɣaren n Israil, inni tessned cek d imɣaren n řgens u d imeḥḍayen. Awyi ten-dd ɣar Uqiḍun n Umsagar uca ejj iten ad din bedden zzatek. ");
INSERT INTO rifl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Xenni Necc ad hwiɣ uca ad kik ssiwřeɣ. Ad ksiɣ zi Arruḥ i xak iǧan uca ad xasen t ssarseɣ. Ammu i kik ɣa arbun ddqeř n řgens-a, maḥend war t tarebbud ca weḥḥdek. ");
INSERT INTO rifl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ad tinid i řgens: ‘Sqeddsem ixef nwem i tiwecca, xenni ad teccem aysum, minzi aqa trum deg imezzuɣen n SIDI, tennam: Wi d aneɣ ɣa iwcen ad necc aysum? Tuɣa-neɣ mliḥ di Miṣra! S uya i d awem ɣa iwc SIDI aysum ad teccem. ");
INSERT INTO rifl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","War t tᵉttettem ijj n wass waha uřa d tnayen n wussan, niɣ xemsa n wussan, niɣ ɛecra n wussan, niɣ ɛicrin n wussan, ");
INSERT INTO rifl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","maca marra ussan n uyur ař d awem dd-iffeɣ zeg wenzaren nwem uca ad zzayes tɛiffem, umi tenḍarem SIDI wenni iǧan di řwesṭ nwem, uca trum zzat i uɣembub nnes, tennam: Mayemmi ɛad dd-neffeɣ zi Miṣra?’” ");
INSERT INTO rifl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Uca Musa inna: “Řgens-ya, di řwesṭ nsen i ǧiɣ, aqa-t di setta-ařaf n yeryazen x iḍaren uca Cek teqqared: ‘Ad asen wceɣ aysum uca ad zzayes ccen ijj n uyur amen ikmeř!’ ");
INSERT INTO rifl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Mařa ɣarṣen asen i marra wuǧi d ifunasen, ma ad yiři cfa asen? Niɣ mařa ssmunen asen marra iseřman n řebḥar, ma ad yiři cfa asen?” ");
INSERT INTO rifl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Inna SIDI i Musa: “Ma xenni yebri ufus n SIDI? Řexxu xenni, ad tẓared ma ad iqfeř awař nnes niɣ lla!” ");
INSERT INTO rifl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Iffeɣ-dd Musa uca inna awařen n SIDI i řgens uca issmun sebɛin n yeryazen zeg imɣaren n řgens uca issbedd i-ten am dd-nnḍen i Uqiḍun. ");
INSERT INTO rifl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Xenni ihwa-dd SIDI deg useynu uca issiweř akides uca iksi zi Arruḥ nni tuɣa xas uca issars i-t x sebɛin n yeryazen, x imɣaren. Uca imsar, umi tuɣa xasen Arruḥ, bdan ad nebban, maca awarni i uya war iqqim ɛad. ");
INSERT INTO rifl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Uca qqimen tnayen n yeryazen di řmargeḥ n řɛeskar, ijjen qqaren as Ildad u wenneɣni qqaren as Midad uca Arruḥ n SIDI tuɣa-t xasen, minzi nitni aqa aten zeg inni yuran, maca war dd-ffiɣen ɣar Uqiḍun uca tuɣa ttnebban di řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Yuzzeř-dd ijj n uḥenjir uca ixebbar man aya i Musa, inna: “Ildad d Midad ttnebban di řmargeḥ n řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yarra-dd Yacuwa, mmis n Nun, ijjen zeg ibřiɣen ittfarzen, inna: “Sidi inu, Musa, ḥarrem i-ten!” ");
INSERT INTO rifl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Inna as Musa: “Ma cek tecḍared di ṭṭweɛ inu? Mři marra řgens n SIDI tuɣa-t marra d inabiyyen, iři igga xasen SIDI Arruḥ nnes!” ");
INSERT INTO rifl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Idweř-dd Musa ɣar řmargeḥ n řɛeskar, netta d imɣaren n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Xenni yusa-dd ijj n usemmiḍ, issekkar i-t SIDI, indeh-dd ijḍaḍ qqaren as ‘tsalwa’ zi řebḥar uca inḍar i-tent x řmargeḥ n řɛeskar, ticři n webrid n ijj n wass ɣar ijj n tma d ticři n webrid ɣar tma nneɣni, deg wenneḍ n řmargeḥ n řɛeskar, ař ɛřayen tnayen n iɣaǧen x wudem n temmurt. ");
INSERT INTO rifl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ikkar řgens uca ass nni ikmeř d ǧiřet nni tekmeř d marra ass i t-i-dd iḍfaren yrun nitni ijḍaḍ qqaren as ‘tsalwa’. Wenni ɣares drus, iksi ɛecra iḥumiren. Bezzɛen tent qibač nsen x tiru i innḍen i řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mintra aysum ɛad jar teɣmas nsen, qbeř ma ad t ffẓen, yarɣa weɣḍab n SIDI x řgens uca SIDI iwta řgens s ict n tecti temɣar aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Isemma Musa amcan nni ‘Qabarut-Hata’awat’, minzi dinni i neḍřen řgens i tuɣa immeẓren ammu. ");
INSERT INTO rifl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Zi Qabarut-Hata’awat ifsi řgens iqiḍan nnes, uyuren ɣar Ḥaḍayrut uca qqimen di Ḥaḍayrut. ");
INSERT INTO rifl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Tessiweř Maryam ak-d Harun x Musa di ssibbet n temɣart Takucit nni tuɣa dd-yiwi, minzi netta yiwi-dd ict n temɣart Takucit. ");
INSERT INTO rifl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Uca nnan: “Ma issiweř SIDI zi Musa waha? Ma war zzayneɣ issiweř ɛawed?” Uca isřa SIDI man aya. ");
INSERT INTO rifl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Tuɣa Musa d aryaz amwaḍeɛ aṭṭas, ktar zi marra iwdan i iddaren x temmurt. ");
INSERT INTO rifl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Deɣya issiweř SIDI ak-d Musa d Harun d Maryam: “Ffɣem kenniw s třata, uyurem ɣar Uqiḍun n Umsagar!” Uca ffɣen-dd s třata. ");
INSERT INTO rifl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Xenni ihwa-dd SIDI deg uqellij n useynu uca ibedd ɣar wadaf n Uqiḍun, iřaɣa i Harun d Maryam. Ffɣen-dd nitni s tnayen. ");
INSERT INTO rifl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Uca inna asen Netta: “Sřem xenni i wawařen inu! Mařa din jar awem ijj n unabi, ad as ssecneɣ Ixef inu, Necc, SIDI, s ij n řewḥiy uca ad kis ssiwřeɣ s ict n tarjit. ");
INSERT INTO rifl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Maca war tteggeɣ amenni s umsexxar inu Musa, aqa netta d amtiqqi di taddart inu tekmeř. ");
INSERT INTO rifl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Necc ssiwřeɣ akides zeg uqemmum ɣar uqemmum, war iǧi s řemɛani innufaren. Aqa iẓra addud n SIDI. Mayemmi war teggʷidem zeg umsexxar inu u mayemmi i tessiwřem ammu x Musa?” ");
INSERT INTO rifl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Xenni yarɣa xasen weɣḍab n SIDI uca iruḥ. ");
INSERT INTO rifl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Uca aseynu iffeɣ x Uqiḍun, uca xzar, Maryam dayes řehřac n řbarṣ, aqa-tt d tacemřařt am wedfeř. Uca Harun inneqřeb-dd ɣar Maryam, u xzar, aqa nettat dayes řbarṣ. ");
INSERT INTO rifl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Uca inna Harun i Musa: “A, sidi inu, war xaneɣ srussi ddenb i negga s tefɣuri umi dayes nexḍa! ");
INSERT INTO rifl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","War tt ttejji ad tedweř am umettin i zi ittwacc wezyen n arrimet nnes am dd-teffeɣ zi řemřawet n yemmas.” ");
INSERT INTO rifl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Iřaɣa Musa i SIDI, inna: “A Arebbi, ttzawageɣ ad tt tessgenfid!” ");
INSERT INTO rifl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Inna SIDI i Musa: “Ma mařa babas aqa inxar deg wudem nnes, ma war tᵉseḍḥi sebɛa n wussan? Ejj i-tt ad tᵉttwassuffeɣ zi řmargeḥ n řɛeskar sebɛa n wussan uca awarni as ad tᵉttwaqbeř ɛawed.” ");
INSERT INTO rifl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tᵉttwassuffeɣ Maryam sebɛa n wussan barra i řmargeḥ n řɛeskar uca řgens war ikkis iqiḍan nnes ařami tᵉttwaqbeř Maryam ɛawed. ");
INSERT INTO rifl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Awarni man aya ifsi řgens iqiḍan nnes, yuyur zi Ḥaḍayrut uca wtin iqiḍan nsen di řexřa n Faran. ");
INSERT INTO rifl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Sekk iryazen zzatek ḥima ad bergagen tammurt n Kenɛan, tenni i ɣa wceɣ i ayt n Israil. I kuř taqbič n řejdud ad tessekkem ijj n weryaz, kuř ijj ad yiři d řḥakem jar asen.” ");
INSERT INTO rifl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa issekk i-ten zi řexřa n Faran, x řumur n SIDI. Tuɣa marra iryazen nni d izeǧifen n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Aqa d ina d ismawen nsen: zi teqbič n Rubin, Cammuɛ, mmis n Zakkur, ");
INSERT INTO rifl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","zi teqbič n Cimɛun, Cafat, mmis n Axuri, ");
INSERT INTO rifl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","zi teqbič n Yahuda, Kalib, mmis n Yafunni, ");
INSERT INTO rifl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","zi teqbič n Issakar, Yijɛal, mmis n Yusuf, ");
INSERT INTO rifl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","zi teqbič n Ifrayim, Hucaɛ, mmis n Nun, ");
INSERT INTO rifl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","zi teqbič n Binyamin, Falṭi, mmis n Rafu, ");
INSERT INTO rifl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","zi teqbič n Zabulun, Jaddiyil, mmis n Sudi, ");
INSERT INTO rifl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","zi teqbič n Yusuf, i teqbič n Manassa, Jaddi, mmis n Susi, ");
INSERT INTO rifl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","zi teqbič n Dan, Ɛammiyil, mmis n Jamalli, ");
INSERT INTO rifl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","zi teqbič n Acir, Satur, mmis n Mixayil, ");
INSERT INTO rifl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","zi teqbič n Naftali, Naḥbi, mmis n Wafsi, ");
INSERT INTO rifl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","zi teqbič n Jad, Ja’uyil, mmis n Maki. ");
INSERT INTO rifl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Aqa ina d ismawen n yeryazen nni issekk Musa ḥima ad bergagen tammurt uca Musa iřaɣa i Huciɛa, mmis n Nun, s yisem n Yacuwa. ");
INSERT INTO rifl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Issekk i-ten Musa ḥima ad bergagen tammurt n Kenɛan, inna asen: “Ařyem ssiha ař Tammurt n Ljanub uca ařyem xenni ɣar idurar, ");
INSERT INTO rifl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","uca xzarem mammec teǧa temmurt d řgens i dayes izeddɣen, ma ijhed niɣ iḍɛef i yeǧa, ma aqa din drus niɣ aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Xzarem ɛawed mammec teǧa temmurt i di izeddeɣ řgens, ma tammurt d taṣebḥant niɣ d taɛeffant i teǧa, u mammec ǧant tneddam i di izeddeɣ řgens, ma zeddɣen di řemrageḥ n iqiḍan niɣ di tneddam ifaryen s iɣebřawen. ");
INSERT INTO rifl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","U ɛawed mammec teǧa temmurt, ma tessɣemmi niɣ tuẓeɣ, ma aqa din ticejjura niɣ lla. Ggem taryast uca ksim ca zi řɣiǧet n temmurt. Ussan nni tuɣa aten d ussan n tmenzut n uḍiř.” ");
INSERT INTO rifl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Uca nitni geɛɛden uca bergagen tammurt zi řexřa n Ṣin ař Raḥub, mani ɣa tiwḍed ɣar Ḥamat. ");
INSERT INTO rifl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Geɛɛden ɛad ktar ɣar Temmurt n Ljanub uca iwḍen ɣar Ḥabrun. Dinni i tuɣa Aximan, Cicay d Talmay, nitni d iḥenjiren n Ɛanaq. Ḥabrun tuɣa tᵉttwabna sebɛa n iseggʷusa qbeř Ṣuɛan di Miṣra. ");
INSERT INTO rifl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Xenni iwḍen ař taɣzurt n Ackul uca ssenni kksen ict n tezremt s yijj n uzekkun n uḍiř wenni dd-iwyen s tnayen s yijj n uzeǧaḍ n trebbut. Kksen ɛawed zeg aremmam u zi tazart. ");
INSERT INTO rifl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Qqaren as i wemcan nni taɣzurt n Ickul, isem wanita ixs ad yini ‘taɣzurt n Uzekkun’, di ssibbet n uzekkun n uḍiř nni qessen ayt n Israil din. ");
INSERT INTO rifl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Umi kemmřen arebɛin n wussan, dewřen-dd zeg ubergag n temmurt. ");
INSERT INTO rifl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ɛeqben nitni uca usin-dd ɣar Musa d Harun u ɣar marra tamesmunt n ayt n Israil di řexřa n Faran, ɣar Qadac, uca wcin řexbar i marra tamesmunt uca ssecnen asen řɣiǧet n temmurt. ");
INSERT INTO rifl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ḥajan as, nnan: “Aqa nudef ɣar temmurt nni mani d aneɣ tessekked. S tidett tfeyyeḍ s uɣi d tamment u tanita d řɣiǧet nnes. ");
INSERT INTO rifl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Maca řgens, wenni izeddɣen di temmurt, ijhed u tineddam ɣarsent iɣebrawen mɣarent aṭṭas, u neẓra ɛawed arrawen n Ɛanaq. ");
INSERT INTO rifl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ayt n Ɛamaliq zeddɣen di Temmurt n Ljanub, u Iḥittiyyen d Iyabusiyyen d Imuriyyen zeddɣen deg idurar u ayt n Kenɛan zeddɣen ɣar řebḥar u x tma n L’Urdun.” ");
INSERT INTO rifl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Xenni issesqar Kalib řgens zzat i Musa, inna: “Ejj aneɣ ad ngeɛɛed s jjehd uca ad tt neṭṭef d řwart, minzi nzemmar as neccin!” ");
INSERT INTO rifl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Maca iryazen nni geɛɛden akides, nnan: “War nzemmar ad ngeɛɛed ḍidd i řgens nni, minzi aqa ijhed xaneɣ aṭṭas.” ");
INSERT INTO rifl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ammu i dd-iwyen ijj n řexbar war iḥřin i ayt n Israil x temmurt nni x tuɣa ttbergagen, nnan: “Tammurt x manis nekka ḥima ad tt nbergeg, aqa d ict n temmurt tsarreḍ imezdaɣ nnes uca marra iwdan nni neẓra, aqa aten d iryazen n waddad imɣar. ");
INSERT INTO rifl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Aqa neẓra din ‘nifilim’, ixs ad yini ‘jjwaheř iwḍan’, ayt n Ɛanaq, arrasa n jjwaheř iwḍan. Tuɣa neccin di tiṭṭawin nneɣ amecnaw tamurɣi uca ammu i dd asen nettban di tiṭṭawin nsen.” ");
INSERT INTO rifl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Marra tamesmunt tebda tesɣuyyu s jjehd uca řgens iru marra ǧiřet nni. ");
INSERT INTO rifl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Marra ayt n Israil tuɣa ttnedqamen ḍidd i Musa u ḍidd i Harun uca tenna as marra tmesmunt: “Meɛlik qaɛ nemmut di temmurt n Miṣra!” niɣ: “Meɛlik qaɛ nemmut di řexřa-ya!” ");
INSERT INTO rifl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","“Mayemmi d aneɣ dd-yiwi SIDI ɣar temmurt-a ḥima ad newḍa s ssif u xenni ad dewřent temɣarin nneɣ d tarwa nneɣ d takeccaḍt? Ma war yeǧi ḥsen zeɛma ad neɛqeb ɣar Miṣra?” ");
INSERT INTO rifl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Uca nnan ijj i wenneɣni: “Ejj aneɣ ad negg ijj d azeǧif xaneɣ uca ad neɛqeb ɣar Miṣra!” ");
INSERT INTO rifl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Řexdenni wḍan Musa d Harun x uɣembub nsen zzat i wudem n marra agraw n tmesmunt n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yacuwa, mmis n Nun, d Kalib, mmis n Yafunni, inni tuɣa zeg inni tuɣa ittbergagen x temmurt, carrgen arruḍ nsen. ");
INSERT INTO rifl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nitni ssiwřen ɣar marra tamesmunt n ayt n Israil, nnan: “Tammurt nni x nekka maḥend ad tt nbergeg, aqa-tt d ict n temmurt mliḥ aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Mařa SIDI issfarnen ɣarneɣ, Netta ad aneɣ dd-yawi ɣar temmurt-a uca ad aneɣ tt iwc, ict n temmurt ifeyyḍen s uɣi d tamment. ");
INSERT INTO rifl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Maca war ttiřim d imɣewwɣen ḍidd i SIDI uca war tteggʷedem ca zi řgens n temmurt-a, minzi aqa aten d aɣrum nneɣ. Tiři nsen teffeɣ-dd sennej nsen, aqa SIDI akidneɣ, war zzaysen tteggʷdem ca!” ");
INSERT INTO rifl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Maca řami tessiweř marra tamesmunt belli ittxeṣṣa ad ten arejmen, iban-dd uɛuǧi n SIDI deg Uqiḍun n Umsagar zzat i marra ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Inna SIDI i Musa: “Ař meřmi d ayi ɣa isɛar řgens-a? Ař meřmi war d ayi ttimnen s marra řeɛřamat nni ggiɣ di řwesṭ nsen? ");
INSERT INTO rifl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Necc ad ten wteɣ s ṭṭaɛun uca ad xasen kkseɣ řwart uca ad cek ggeɣ d ijj n řgens d ameqqran, ijhed xasen.” ");
INSERT INTO rifl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Inna Musa i SIDI: “Ad sřen Imiṣriyyen man aya, minzi Cek tessuffɣed řgens-a s jjehd nnec zi řwesṭ nsen. ");
INSERT INTO rifl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","uca ad t inin i imezdaɣ n temmurt-a, inni isřin belli Cek, a SIDI, di řwesṭ n řgens-a, belli Cek, a SIDI, tbaned-dd amecnaw udem deg wudem, belli aseynu nnec ittbedda sennej nsen u belli Cek teggured zzat i wudem nsen deg ijj n uqellij n useynu s uziř uca s ǧiřet deg ijj n uqellij n tmessi.    ");
INSERT INTO rifl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Mařa tenɣid řgens-a am yijj n weryaz, xenni řegnus nni isřin x usemɣar nnec ad ssiwřen ad inin: ");
INSERT INTO rifl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Minzi SIDI war izemmar ad issidef řgens-a di temmurt nni x ijjuǧ ad asen tt iwc, aqa s uyenni d asen iɣarṣ di řexřa!’ ");
INSERT INTO rifl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Řexxu xenni, ejj ad yiři jjehd n Sidi inu imɣar am mammec tuɣa tessiwřed, tennid: ");
INSERT INTO rifl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘SIDI ɣares ttasiɛ n řxaḍar uřa d aṭṭas n tmexsiwt icewwaren. Aqa yarebbu řmuɛṣiyyet d uxeṭṭu nneɣ u Netta war ittbarri wenni itteggen ddenb u isseɛɛdu řmuɛṣiyyet n ibabaten ɣar iḥenjiren nnes ař jjiř wiss třata d jjiř wiss arebɛa.’ ");
INSERT INTO rifl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ɣfar i řgens-a řmuɛṣiyyet nnes ɛlaḥsab řemɣaret n tmexsiwt nnec icewwaren u am mammec themřed ak-d řgens-a zi temmurt n Miṣra ař danita!” ");
INSERT INTO rifl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Inna SIDI: “Necc ɣfareɣ asen ɛlaḥsab awař nnec. ");
INSERT INTO rifl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","S tidett am ddareɣ Necc, aqa marra tammurt ad tᵉttwaccur s uɛuǧi n SIDI! ");
INSERT INTO rifl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Minzi marra iryazen nni iẓrin aɛuǧi inu d řeɛřamat inu i ggiɣ di Miṣra u di řexřa, d yinni d ayi iqeǧben di řexřa ɛad ɛecra n twařawin u war sřin i tmijja inu, ");
INSERT INTO rifl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","war ẓarren tammurt nni x jjuǧeɣ i řejdud nsen ad asen tt wceɣ, wah, marra inni d ayi issdduqqzen ammu, war tt ẓarren. ");
INSERT INTO rifl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Maca ad ssiwḍeɣ amsexxar inu Kalib ɣar temmurt mani tuɣa yudef qbeř uca ad tt warten tarwa nnes, minzi tuɣa akides ijj n arruḥ nneɣni uca netta iḍfar ayi nican. ");
INSERT INTO rifl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Aqa ayt n Ɛamaliq d ayt n Kenɛan zeddɣen di řewḍa n teɣzurt. Ad dd-tdewřem tiwecca uca ad tekksem iqiḍan nwem ssa, ffɣem ɣar řexřa, uyurem deg webrid ɣar Řebḥar n Telga.” ");
INSERT INTO rifl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ař meřmi ɣa teqqim tmesmunt-a taɛeffant tᵉttnedqam xafi? Anedqem n ayt n Israil i zi xafi ttnedqamen, aqa sřiɣ t. ");
INSERT INTO rifl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ini asen: ‘S tidett am ddareɣ Necc, iqqar SIDI, mařa war d awem tteggeɣ am mammec d awem sřiɣ s imezzuɣen inu min tennam kenniw. ");
INSERT INTO rifl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Řxecbat nwem ad wḍant di řexřa-ya, řxecbat n marra inni ittwaḥesben n řgens, marra řqedd n iḥenjiren nwem zi ɛicřin iseggʷusa sennej i tuɣa xafi ittnedqamen. ");
INSERT INTO rifl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kenniw war tᵉttidfem ca ɣar temmurt min xef ssgeɛɛdeɣ afus inu maḥend ad jjaǧeɣ ad kenniw ggeɣ ad dayes tzedɣem, mɣir Kalib, mmis n Yafunni, d Yacuwa, mmis n Nun. ");
INSERT INTO rifl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Tarwa nwem i xef tennam: ‘Ad ttwakeccḍen!’, Necc ad ten ssidfeɣ dayes uca nitni ad ssnen tammurt nni tenḍarem kenniw ammu s useḥqar. ");
INSERT INTO rifl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Maca řxecbat nwem, wah, kenniw simant nwem, ad tewḍam di řexřa-ya, ");
INSERT INTO rifl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","uca iḥenjiren nwem ad tellɛen di řexřa-ya řmijař n arebɛin n iseggʷusa uca kenniw ad kiwem tarbum farq-ccɣeř nwem ař ɣa fnant řxecbat nwem di řexřa. ");
INSERT INTO rifl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Anect i řqedd n wussan i tuɣa tᵉttbergagem tammurt, iqqar arebɛin n wussan - aqa ijj n wass d ijj n useggʷas - ad tarbum řmuɛṣiyyet nwem, řmijař n arebɛin n iseggʷusa. Kenniw ad tessnem aqa Necc beɛɛdeɣ xawem. ");
INSERT INTO rifl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Necc d SIDI ssiwřeɣ: Mařa war tteggeɣ ammu ak-d marra tamesmunt-a taɛeffant tenni ikksen awař xafi: ad mmten di řexřa-ya, ad mmten din!” ");
INSERT INTO rifl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Iryazen nni issekk Musa maḥend ad bergagen tammurt, řami dd-dewřen, tamesmunt am tekmeř tedweř ḍidd nnes umi nitni ssiwřen s řɣar x tammurt, ");
INSERT INTO rifl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","aqa iryazen nni ibehdřen tammurt, mmuten s ict n jjriḥect zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Maca Yacuwa, mmis n Nun, d Kalib, mmis n Yafunni, qqimen ddaren jar iryazen nni iruḥen ad bergagen tammurt. ");
INSERT INTO rifl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Issiweř Musa awařen-a ɣar marra ayt n Israil. Iḥzen xenni řgens aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Uca nitni kkaren zic uca uřyen ař taqiccat n wedrar, nnan: “Aqa-neɣ da uca ad ngeɛɛed ɣar wemcan min xef issiweř SIDI, minzi neccin aqa nexḍa!” ");
INSERT INTO rifl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Maca Musa inna: “Mayemmi tᵉttɛeddam ammu řumur n SIDI? Man aya war iɛeddu! ");
INSERT INTO rifl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","War ttgeɛɛidem ca minzi SIDI war ittiři di řwesṭ nwem. War ttejjim ixef nwem ad texsarem zzat i wudem n řɛedyan nwem. ");
INSERT INTO rifl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Minzi ayt n Ɛamaliq d ayt n Kenɛan aqa aten din zzat nwem uca ad tewḍam kenniw s ssif minzi kenniw tiggʷejem x SIDI. S uya SIDI war kiwem ittiři.” ");
INSERT INTO rifl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Maca nitni tuɣa ttuffen maḥend ad dd-ařyen ař taqiccat n wedrar. Maca Ttabut n Řɛahd n SIDI d Musa war ffiɣen zi řwesṭ n řmargeḥ n řɛeskar. ");
INSERT INTO rifl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Xenni hwan-dd ayt n Ɛamaliq d ayt n Kenɛan nni tuɣa izeddɣen deg wedrar nni uca arenyen ten u řebzen ten ař Ḥurma. ");
INSERT INTO rifl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Siweř ak-d ayt n Israil, ini asen: ‘Xmi ɣa tadfem ɣar temmurt mani ɣa tzeddɣem, tammurt nni d awem ɣa wceɣ, ");
INSERT INTO rifl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","uca ad tesswejdem din ict n tewhibt n tmessi i SIDI, ict n tɣarṣt n wecmaḍ niɣ ict n tewhibt i tɣarṣt i ukemmeř n ijj n lwaɛd niɣ ict n tewhibt s řxaḍar niɣ ict n tewhibt i řeɛyudat nwem ittwaggen, maḥend ad tiři d ict n řefwaḥet ittfuḥen i SIDI, zi řebhayem niɣ zeg wuǧi, ");
INSERT INTO rifl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","xenni wenni dd ɣa iqeddmen tawhibt nnes i SIDI, ad yawi ɛawed ict n tewhibt n řɣiǧet zeg ict n teɛcart n yijj n ifa n waren azdad ixeǧḍen s yijj n arbeɛ n ijj n uhinu n zzect. ");
INSERT INTO rifl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ad tesswejded ak-d man aya ijj n arbeɛ n ijj n uhinu n binu am tewhibt n useyyeb i kuř ijj n izmar, maḥend ad tiři x tɣarṣt n wecmaḍ niɣ x tewhibt i tɣarṣt, ");
INSERT INTO rifl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","niɣ, mařa ad tiři i yijj n icarri, xenni ittxeṣṣa ad tesswejded ict n tewhibt n řɣiǧet zi tnayen n teɛcuray n ijj n ifa n waren azdad ixeǧḍen s ict n ttuřut n ijj n uhinu n zzect, ");
INSERT INTO rifl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","uca ad tqeddmed ɛawed ict n ttuřut n ijj n uhinu n binu am tewhibt n useyyeb, am yict n řefwaḥet ittfuḥen i SIDI.’” ");
INSERT INTO rifl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Xmi ɣa tesswejded ameẓyan n ufunas am tɣarṣt n wecmaḍ niɣ am tewhibt i tɣarṣt maḥend ad yiři i ukemmeř n ijj n lwaɛd niɣ am tɣarṣt n řehna i SIDI, ");
INSERT INTO rifl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","xenni ittxeṣṣa ad tqeddmed ak-d umeẓyan n ufunas ɛawed ict n tewhibt n řɣiǧet n třata n teɛcuray n ijj n ifa n waren azdad ixeǧḍen deg wezyen n uhinu n zzect, ");
INSERT INTO rifl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","uca ittxeṣṣa ɛawed ad dd-tawyed azyen n uhinu n binu am tewhibt n useyyeb, am tewhibt n tmessi, ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ammu i ittxeṣṣa ad ggen i kuř afunas, niɣ i kuř icarri, niɣ i kuř ijj zeg wuǧi, zeg iḥuřiyyen niɣ zeg iɣayḍen. ");
INSERT INTO rifl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ɛlaḥsab řqedd n imuddaren i tɣarṣt i ɣa tesswejdem, ad teggem ammu i kuř ijj n umuddar, ɛlaḥsab řqedd ikemmřen n imuddaren. ");
INSERT INTO rifl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Marra inni dd-ittwaxeřqen di temmurt ad ggen timesřayin-a ammu, xmi dd ɣa qeddmen nitni ict n tewhibt n tmessi, ict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Xmi ɣa tafed jar marra jjiřat nwem ijj n ubarrani i iqqimen akidwem, niɣ ijjen wenni izeddɣen di řwesṭ nwem, aqa netta ad issewjed ict n tewhibt n tmessi, ict n řefwaḥet ittfuḥen i SIDI, xenni ad tt igg am mammec tt tᵉtteggem kenniw.” ");
INSERT INTO rifl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ay, agraw n řgens, ad din tiři ict n tewṣeyyet, ict n tewṣeyyet i řebda i kenniw u i ubarrani nni akidwem iqqimen i marra jjiřat nwem. Ad yiři ubarrani am mammec teǧam kenniw zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ad yiři ijj n uzerf d ict n lfariḍa i kenniw u i ubarrani nni akidwem iqqimen.” ");
INSERT INTO rifl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Siweř ak-d ayt n Israil uca ini asen: ‘Xmi ɣa tadfem ɣar tammurt mani kenniw ɣa yawyeɣ, ");
INSERT INTO rifl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","xenni ad imsar, umi ɣa teccem aɣrum zi řɣiǧet n temmurt, aqa kenniw ad tessgeɛɛdem ict n tewhibt n usgeɛɛed i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Zi tmezwarut n warecti nwem ad tessgeɛɛdem ict n temsemment am tewhibt n usgeɛɛed. Ad tt tessgeɛɛdem am mammec tessgeɛɛdem tawhibt n usgeɛɛed n unedrar. ");
INSERT INTO rifl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Zi tmezwarut n warecti nwem ad tqeddmem ict n tewhibt n usgeɛɛed i SIDI di marra jjiřat nwem.’” ");
INSERT INTO rifl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Mařa tweddarem u war tᵉtteggem marra řumurat-a i tuɣa issawař SIDI ak-d Musa ");
INSERT INTO rifl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","- marra min d awem yumur SIDI s tsexxart n Musa zeg wass min zi t yumur SIDI, ssenni d tsawent, di marra rejyuř nwem - ");
INSERT INTO rifl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","xenni ad imsar, mařa ittwagg s uweddar barra i tiṭṭawin n tmesmunt, aqa tamesmunt marra ad tessewjed ijj n ufunas, ameẓyan n tfunast, am tɣarṣt n wecmaḍ, am ict n řefwaḥet ittfuḥen i SIDI ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb ɛlaḥsab lfariḍa u ak-d yijj n umyan zeg iɣayḍen am tɣarṣt n ddenb. ");
INSERT INTO rifl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Xenni ad igg ukehhan asřaḥ i marra tamesmunt n ayt n Israil uca ad asen ittwaɣfar, minzi man aya imsar zeg uweddar, uca nitni qeddmen tawhibt nsen, ict n tewhibt n tmessi i SIDI, uřa d taɣarṣt nsen n ddenb, zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Marra tamesmunt n ayt n Israil ad tᵉttwaɣfar, uřa d abarrani nni izeddɣen di řwesṭ nwem, x umi imsar am iweddar marra řgens.” ");
INSERT INTO rifl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Mařa ijjen bnadem ixḍa am netta iweddar, xenni ad dd-issqarreb ict n tɣayḍet n ijj n useggʷas am tɣarṣt n ddenb.    ");
INSERT INTO rifl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Akehhan ad igg aṣřaḥ zzat i wudem n SIDI x bnadem nni tuɣa iweddar, am tuɣa ixḍa s uweddar zzat i wudem n SIDI, am xas i ɣa yegg asřaḥ uca xenni ad as ittwaɣfar. ");
INSERT INTO rifl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ad din yiři ijj n uzerf i wenni iggin ca s uweddar, i wenni dd-ixeřqen di temmurt uřa i ubarrani nni izeddɣen di řwesṭ nwem.” ");
INSERT INTO rifl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Maca bnadem nni iggin ca s ufus igeɛɛden, ma netta ittwaxřeq-dd di temmurt niɣ netta d abarrani, aqa netta iceqqef di SIDI uca bnadem nni ad ittwaqess zi řwesṭ n řgens nnes, ");
INSERT INTO rifl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","umi isseḥqar awař n SIDI u yarẓa řumur nnes. Bnadem nni ad ittwaqess qaɛ zi řgens nnes, řmuɛṣiyyet nnes ad tiři xas.” ");
INSERT INTO rifl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Řami tuɣa ayt n Israil di řexřa, ufin ijj n weryaz ittḥarwac akeccuḍ deg wass n ssebt. ");
INSERT INTO rifl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Inni t yufin am tuɣa ittḥarwac akeccuḍ, iwyen t ɣar Musa d Harun d marra tamesmunt. ");
INSERT INTO rifl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ggin t di tḥeṭṭut, minzi tuɣa war dd-ibin min zzayes ɣa ggen. ");
INSERT INTO rifl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Xenni inna SIDI i Musa: “Aryaz nni ad ittwaneɣ nican. Marra tamesmunt ad t tarjem barra i řmargeḥ n řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Xenni tessuffeɣ i-t marra tmesmunt barra i řmargeḥ n řɛeskar uca nitni arejmen t ařami immut, am mammec t yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Siweř ak-d ayt n Israil uca ini asen, ad ggen i yixef nsen ticarcifa ɣar tɣemmura n warruḍ nsen di marra jjiřat nsen uca ad ggen ijj n ufiřu d adeḥmi ɣar tcarcifa, tinni ɣar tɣemmura. ");
INSERT INTO rifl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ad yiři ufiřu ɣar tcarcift, ḥima ad twařam afiřu nni uca ad tidarem di marra řumurat n SIDI uca ad tent teggem u war tḍeffarem ccehwat n wuřawen nwem d tiṭṭawin nwem, inni awarni asent tennumem ad tessefsedem ixef nwem, ");
INSERT INTO rifl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","u ḥima ad txarrṣem di řumurat inu, ad zzaysent teggem, maḥend ad tiřim tᵉttwaqeddsem zzat i AREBBI nwem. ");
INSERT INTO rifl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Necc d SIDI, AREBBI nwem wenni kenniw dd-issuffɣen zi temmurt n Miṣra ḥima ad iřiɣ d AREBBI nwem. Necc d SIDI, AREBBI nwem!” ");
INSERT INTO rifl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Quraḥ, mmis n Yiṣhar, mmis n Qahat, mmis n Lawi, ak-d Datan d Abiram, tnayen n iḥenjiren n Iliyab, d Un, mmis n Falat, iḥenjiren n Rubin, iwyen iryazen, ");
INSERT INTO rifl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","uca kkaren ḍidd i Musa, jmiɛ ak-d iryazen nneɣni zeg ayt n Israil, mitayen u-xemsin n řḥukkam n tmesmunt, aqa aten zeg inni dd-ittwařaɣan ɣar umuni, iryazen s ccan. ");
INSERT INTO rifl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Nitni munen ḍidd i Musa d Harun, nnan asen: “Cfa awem kenniw! Minzi marra tamesmunt, wah, marra nitni d imqeddasen uca SIDI di řwesṭ nsen. Mayemmi tessuɛřam ixef nwem sennej i wegraw n řgens n SIDI?” ");
INSERT INTO rifl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Umi isřa Musa i man aya, iwḍa x wudem nnes. ");
INSERT INTO rifl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Uca issiweř ak-d Quraḥ d marra abarru nnes, inna: “Tiwecca ad isscen SIDI wenni iǧan nnes d wenni iǧan d amqeddas d wenni i ɣares dd ɣa issqarreb. Wenni ifarz Netta, d wenni i dd ɣa issqarreb Netta ɣares. ");
INSERT INTO rifl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ggem aya! Ejj Quraḥ d marra abarru nnes ad awyen timejmarin. ");
INSERT INTO rifl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Tiwecca ggem xasent řefḥem i tmessi, sarsem xas řebxur zzat i wudem n SIDI. Xenni ad imsar belli aryaz nni ixḍar SIDI, ad yiři d amqeddas. Aqa truḥem tiggʷijem, ayt n Lawi!” ");
INSERT INTO rifl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Inna Musa i Quraḥ: “Sřem řexxu, ttzawageɣ, kenniw, ayt n Lawi! ");
INSERT INTO rifl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ma war xawem icfi umi kenniw issfarz AREBBI n Israil x tmesmunt n Israil maḥend ad kenniw ɣares dd-issqarreb, ḥima ad tsexxarem di Tzeddiɣt n SIDI uca ḥima ad tbeddem zzat i wudem n tmesmunt maḥend ad ten tsexxarem? ");
INSERT INTO rifl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Netta issqarreb i cek-dd ɣares, cek d marra aytmac, ayt n Lawi, jmiɛ akidek. Ma tarezzum řexxu ɛawed tukehhant? ");
INSERT INTO rifl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","S uya, cek d marra abarru nnec, aqa kenniw tmunem ḍidd n SIDI, minzi min iɛna Harun, min iɛna ḥima ad xas tennedqem?” ");
INSERT INTO rifl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Uca issekk Musa ad řaɣan x Datan d Abiram, iḥenjiren n Iliyab, maca nitni nnan: “War dd-nettis ca!” ");
INSERT INTO rifl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ma war iǧi icfa awem umi d aneɣ dd-tssuffɣem zeg ict n temmurt ifeyyḍen s uɣi d tamment, ḥima ad aneɣ tesshelleked di řexřa uca xenni ɛawed tegged ixef nnec d řḥakem xaneɣ? ");
INSERT INTO rifl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Uřa d cek war d aneɣ dd-tessidfed ca deg ict n temmurt ifeyyḍen s uɣi d tamment, u war d aneɣ tewcid iyyaren d imarjaɛen n uḍiř d řwart. Ma ittɣiř ac tzemmared ad tessdaɣřed tiṭṭawin n yeryazen-a? Neccin war dd-nettis ca!” ");
INSERT INTO rifl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Xenni ittwassarɣ ufugem n Musa, inna i SIDI: “War xezzar ɣar tewhibt nsen! Necc war zzaysen kessiɣ qaɛ ijj n uɣyuř uca war ggiɣ řɣar uřa i yijj zzaysen.” ");
INSERT INTO rifl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Inna Musa i Quraḥ: “Cek d marra abarru nnec, asem-dd tiwecca zzat i wudem n SIDI, cek d nitni, d Harun. ");
INSERT INTO rifl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ksim kuř ijj zzaywem ijj n řmejmar, ggem dayes řebxur uca qarrbem-dd akides zzat i wudem n SIDI. Kuř aryaz ak-d řmejmar nnes, mitayen u-xemsin n tmejmarin, uca ɛawed cek d Harun, kuř ijj ak-d řmejmar nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Iksi kuř ijj řmejmar nnes uca ggin dayes timessi u ssarsen xas řebxur uca uyuren ad bedden zzat i wadaf n Uqiḍun n Umsagar, uřa d Musa d Harun. ");
INSERT INTO rifl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Quraḥ iɣewweɣ xasen marra abarru nnes ɣar wadaf n Uqiḍun n Umsagar. Řexdenni iban-dd uɛuǧi n SIDI ɣar marra tamesmunt. ");
INSERT INTO rifl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Ḥeydem ixef nwem zeg ubarru-ya, xenni ad ten hellkeɣ deg wermac n wabřiwen!” ");
INSERT INTO rifl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Maca nitni wḍan x wudem nsen, nnan: “A Arebbi, AREBBI n marra buḥbeřat n marra ddat! Mařa ixḍa ijj n weryaz, ma xenni ad tegged aɣḍab nnec ad idduqqez x marra tamesmunt?” ");
INSERT INTO rifl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Siweř ak-d tmesmunt, ini: ‘Beɛɛdem x tzeddiɣt n Quraḥ d Datan d Abiram d min d as dd-innḍen.’” ");
INSERT INTO rifl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Xenni Musa ikkar uca iruḥ ɣar Datan d Abiram uca uyuren imɣaren n Israil awarni as. ");
INSERT INTO rifl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Uca issiweř netta ak-d tmesmunt, inna: “Ttzawgeɣ, beɛɛdem x iqiḍan n yeryazen-a iqejḥen u war ttḥadam uřa d ict n řḥajjet n min iǧan nsen, ḥima kenniw war tᵉttwahellikem ca s ddnub nsen!” ");
INSERT INTO rifl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kkaren nitni uca beɛɛden x iqiḍan n Quraḥ d Datan d Abiram d min d as dd-innḍen. Datan d Abiram ffɣen-dd, bedden ɣar wadaf n iqiḍan nsen ak-d temɣarin nsen d iḥenjiren nsen d iḥenjiren nsen imeẓyanen. ");
INSERT INTO rifl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Xenni inna Musa: “S man aya i ɣa tessnem belli SIDI issekk ayi-dd, ḥima ad ggeɣ marra timegga-ya, minzi war dd-ffiɣent ca zeg wuř inu. ");
INSERT INTO rifl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Mařa ina ad mmten am mammec mmuten iwdan marra u ad ten iřqef min iřeqfen marra iwdan, xenni ad taf SIDI war d ayi dd-issekk. ");
INSERT INTO rifl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Maca mařa SIDI ixřeq-dd ca n řḥajjet d tamaynut qaɛ uca tammurt ad tarzem aqemmum nnes, ad ten tsarḍ ak-d marra min iǧan nsen uca ad hwan ddaren di řaxart, xenni i ɣa tessnem belli iryazen-a aqa ssduqqzen SIDI.” ");
INSERT INTO rifl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Uca imsar, umi ikemmeř awařen-a, tfeǧeq temmurt nni swadday nsen. ");
INSERT INTO rifl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Tarzem temmurt aqemmum nnes uca tsarḍ i-ten ak-d aytbab n taddart nsen u ak-d marra iwdan n Quraḥ d marra agřa nsen. ");
INSERT INTO rifl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Hwan-dd ddaren di řaxart ak-d marra min iǧan nsen uca tammurt tessduriy i-ten u ttwateḥḥan zi řwesṭ n wegraw n řgens. ");
INSERT INTO rifl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Marra Israil, inni tuɣa dd-innḍen, arewřen umi sřin i tɣuyyit nsen, minzi nnan: “Niɣ ad taf uřa d neccin ad aneɣ tṣarḍ temmurt.” ");
INSERT INTO rifl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Uca teffeɣ-dd tmessi zi SIDI, tecca mitayen u-xemsin n yeryazen nni dd-yiwyen řebxur. ");
INSERT INTO rifl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ini i Aliɛazar, mmis n ukehhan Harun, belli ad iksi timejmarin zeg uḥaduq n tmessi uca ad issuyes min iqqimen n tmessi di řaggʷaj, minzi aqa timejmarin nni, qeddsent i ǧant! ");
INSERT INTO rifl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Jjem ten ad ggen zi tmejmarin n yeryazen-a, inni tuɣa ixeṭṭan ḍidd i řeɛmur nsen, tiřwiḥin d tizirarin i dduri i uɛalṭar, minzi iwyen tent zzat i wudem n SIDI, s uya ttwaqeddsent tina. Ad iřint d ijj n uceyyar i ayt n Israil.” ");
INSERT INTO rifl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Xenni iksi ukehhan Aliɛazar timejmarin n nnḥas nni dd-iwyen yinni ittwacemḍen i tewhibt, uca tketken tent ḥima ad zzaysent dřent aɛalṭar ");
INSERT INTO rifl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","i řidaret i ayt n Israil, ḥima uřa d ijj n weryaz war iǧin zi zzariɛet n Harun, war dd-ittqarrib ca břa ttesriḥ zzat i wudem n SIDI, ḥima ad issbexxar řebxur, maḥend war d as iřqef min iřeqfen Quraḥ d ubarru nnes, am mammec tuɣa issiweř SIDI s uqemmum n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Tiwecca nnes tuɣa marra tamesmunt n ayt n Israil tᵉttnedqam ḍidd i Musa d Harun, nnan: “Kenniw tenɣim řgens n SIDI!” ");
INSERT INTO rifl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Uca umi tmun tmesmunt ḍidd i Musa d Harun uca bdan nitni gguren ɣar Uqiḍun n Umsagar, xzar, aqa din aseynu nni t idřin uca iban-dd uɛuǧi n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Yusa-dd Musa ak-d Harun, bedden zzat i Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","“Kkarem, aggʷejem zi řwesṭ n tmesmunt u Necc ad ten mḥiɣ deg ijj n wermac n wabřiwen!” Xenni wḍan x wudem nsen. ");
INSERT INTO rifl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Inna Musa i Harun: “Ksi deɣya ijj n řmejmar, egg xas timessi n uɛalṭar uca sars xas řebxur. Azzeř ɣar tmesmunt uca egg aṣřaḥ di ṭṭweɛ nsen, minzi iffeɣ-dd uduqqez n weɣḍab zi zzat i wudem n SIDI. Aqa da jjriḥect am tebda ɛad.” ");
INSERT INTO rifl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Iksi Harun řmejmar, am mammec inna Musa, uca yuzzeř ɣar řwesṭ n wegraw n řgens, uca xzar, jjriḥect tuɣa am tebda ɛad jar řgens, uca netta issars dayes řebxur uca igga aṣřaḥ di ṭṭweɛ n řgens. ");
INSERT INTO rifl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tuɣa ibedd jar imettan d imuddaren uca tᵉttwassbedd jjriḥect. ");
INSERT INTO rifl_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Wi immuten zi jjriḥect tuɣa aten di arbeɛṭac-ařef u-sebɛa-mya, břa inni immuten di ssibbet n Quraḥ. ");
INSERT INTO rifl_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Idweř Harun ɣar Musa ɣar wadaf n Uqiḍun n Umsagar. Aqa tᵉttwassbedd jjriḥect. ");
INSERT INTO rifl_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","“Siweř ak-d ayt n Israil uca ksi zzaysen ict n teɣɣarct i kuř taddart n ibabaten nsen, zi marra řḥukkam nsen, ɛlaḥsab lɛadad n tudrin n ibabaten nsen, tenɛac n tᵉɣɣaryen. Ittxeṣṣa ad tarid isem n kuř ijj zzaysen x teɣɣarct nnes. ");
INSERT INTO rifl_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Ad tarid isem n Harun x teɣɣarct n Lawi, minzi ad din tiři ict n teɣɣarct i yijj n uzeǧif n taddart n řejdud nsen. ");
INSERT INTO rifl_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Ad tent tegged deg Uqiḍun n Umsagar, zzat i Cchadet, mani kidwem ɣa msagareɣ. ");
INSERT INTO rifl_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Xenni ad imsar, aqa ad tnuwwar teɣɣarct n weryaz nni ixḍareɣ Necc uca ad ssbeddeɣ anedqem ḍidd inu i zi xawem nndeqmen ayt n Israil.” ");
INSERT INTO rifl_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Issiweř Musa ak-d ayt n Israil, uca marra řḥukkam nsen wcin ict n teɣɣarct i mkuř ijj n řḥakem, ɛlaḥsab řqedd n tudrin n ibabaten nsen, tenɛac n teɣɣaryen. Uca taɣɣarct n Harun tuɣa-t jar tᵉɣɣaryen nsen. ");
INSERT INTO rifl_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Musa issars tiɣɣaryen nni zzat i wudem n SIDI deg Uqiḍun n Cchadet. ");
INSERT INTO rifl_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Tiwecca nnes yudef Musa ɣar Uqiḍun n Cchadet, uca xzar, taɣɣarct n Harun di ṭṭweɛ n taddart n Lawi tuɣa tegga tacřařt uca taɛebbuzt tessuffeɣ-dd uca nnuwwar nnes yarzem uca yiwi-dd ǧuz yiwḍen. ");
INSERT INTO rifl_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Xenni issuffeɣ Musa marra tiɣɣaryen zi zzat i wudem n SIDI ɣar marra ayt n Israil. Ẓrin aya uca ṭṭfen kuř ijj taɣɣarct nnes. ");
INSERT INTO rifl_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Xenni inna SIDI i Musa: “Arr taɣɣarct n Harun zzat i Cchadet, ad tt teḥḍid am yijj n uceyyar ḍidd i yinni iɣewwɣen. Ammu i ɣa tessbedded anedqem nsen ḍidd inu maḥend nitni war ttmettin ca.” ");
INSERT INTO rifl_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Uca igga Musa am mammec d as yumur SIDI, ammu i igga netta. ");
INSERT INTO rifl_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Xenni ssiwřen ayt n Israil ak-d Musa, nnan: “Xzar, ad zzayneɣ iffeɣ buḥbeř, ad nettwahellek, ad nettwahellek marra neccin! ");
INSERT INTO rifl_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Man wen ma i dd ɣa iqarrben ɣar Uqiḍun n SIDI, ad immet. Ma ad nettwateḥḥa ař zzayneɣ iffeɣ buḥbeř?” ");
INSERT INTO rifl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Inna SIDI i Harun: “Cek d warraw nnec d taddart n babac akidek, ad tarbum řmuɛṣiyyet n Zzawect Iqeddsen nwem. Cek d warraw nnec akidek ad arbun řmuɛṣiyyet n tukehhant nwem. ");
INSERT INTO rifl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ad dd-tiwyed akidek uřa d aytmac, taqbič n Lawi, taqbič n babac. Nitni ad dd-mmarenyen ɣarek, ad ac sexxaren, maca cek, jmiɛ ak-d iḥenjiren nnec, ad tsexxared zzat i wudem n Uqiḍun n Cchadet. ");
INSERT INTO rifl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ad ṭṭfen acbar nnec uca ad ḥḍan x marra Aqiḍun, maca war zemmaren ad dd-qarrben ɣar řeqcuɛ n Zzawect Iqeddsen u ɣar uɛalṭar ḥima war ttᵉttmettin, war iǧi řa d nitni uřa d kenniw. ");
INSERT INTO rifl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ittxeṣṣa asen ad mmarenyen ɣarek uca ad ṭṭfen acbar x Uqiḍun n Umsagar u x marra tasexxart n Uqiḍun. Wenni war ɣar iǧi ttesriḥ war izemmar ad ɣarwem dd-iqarreb. ");
INSERT INTO rifl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ad tᵉṭṭfem acbar x Zzawect Iqeddsen uřa x uɛalṭar, ḥima war dd-ittis ɛad uduqqez n weɣḍab x ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Necc, aqa da Necc, ksiɣ awmaten nwem, Ilawiyyen, zi jar řwesṭ n ayt n Israil. Aqa nitni am yict n tewhibt i kenniw tenni ittxeṣṣa ad twehhbem i SIDI maḥend ad sexxaren nitni deg Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Maca cek d iḥenjiren nnec akidek ad tᵉṭṭfem tukehhant nwem di marra min iqqnen ak-d uɛalṭar d min iǧan daxeř i uřeḥḥaf uca ammu ad tsexxarem kenniw. Necc ad awem wceɣ tukehhant d tsexxart am yict n terzeft. Abarrani nni dd ɣa iqarrben, ad ittwaneɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Issiweř SIDI ak-d Harun: “Necc, xzar, aqa d Necc i d ac iwcin aḥeṭṭu x tewhibin n usgeɛɛed i qeddmen nitni i Necc. Necc wciɣ tent ak-d marra tiwhibin iqeddsen n ayt n Israil am tesɣart i x ittwagg wedhan, i cek u i warraw nnec, am yict n tewṣeyyet i řebda. ");
INSERT INTO rifl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Zi tewhibin iqeddsen ad iřint iziynat i war yudifen ɣar tmessi i cek: marra tiwhibin nsen ak-d marra tiwhibin nsen n řɣiǧet, ak-d marra tiɣarṣa nsen n ddenb u ak-d marra tiɣarṣa nsen n umarwas nni d ayi dd ɣa yarren am texriṣt. Man aya marra ad yiři d amqeddas qaɛ i cek u i iḥenjiren nnec. ");
INSERT INTO rifl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ad tecced aya deg ijj n wemcan iqeddsen qaɛ. Kuř awtem ad zzayes yecc. Aya ad yiři d amqeddas i kenniw.” ");
INSERT INTO rifl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Ɛawed d man aya ad yiři i cek: tawhibt n usgeɛɛed n tewhibt nsen ak-d marra tiwhibin n wenhezzi n ayt n Israil. Wciɣ tent i cek u i warrawen nnec d tarrawin nnec nni kidek iǧan. Aqa-tt d ict n tewṣeyyet i řebda. Kuř ijjen di taddart nnec nni iǧan d amezdag, ad zzaysent yecc.” ");
INSERT INTO rifl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Min iǧan řemxeyyar n zzect d min iǧan řemxeyyar n binu n jdid u zeg irden, aqa d tamezwarut i zzaysen ad wcen i SIDI, aqa wciɣ ac tt. ");
INSERT INTO rifl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Tamenzut n marra min iǧan x temmurt nsen, nni dd ɣa yawyen ɣar SIDI, aqa marra man aya ad yiři i cek. Kuř ijjen wenni iǧan d amezdag di taddart nnec, izemmar ad zzayes yecc.” ");
INSERT INTO rifl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Marra min ittwaḥarrmen di Israil, ad yiři nnec. ");
INSERT INTO rifl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Marra min yarezmen řemřawat d amezwaru jar marra aysum i ɣa qeddmen i SIDI, zi bnadem niɣ zi řebhimet, ad yiři nnec. Maca ad tefdid qaɛ amenzu n iwdan uca ittxeṣṣa ɛawed ad tefdid amenzu n řebhayem ixemjen. ");
INSERT INTO rifl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Wi zzaysen ɣa ttwafdin nitni, ad ttwafdin d mmis n ijj n uyur ɛlaḥsab řqimet i tqeddared cek di nnuqart, xemsa ciqlu ɛlaḥsab ciqlu n Zzawect Iqeddsen, wenni iǧan ɛicrin jira. ");
INSERT INTO rifl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Maca amenzu n ufunas d umenzu n uḥuři d umenzu n iɣayḍ, war t tfeddim ca. Aqa aten qeddsen i ǧan. Ad tzeǧɛed idammen nsen x uɛalṭar u tadunt nsen ad tt tessbexxared am tewhibt n tmessi, am yict n řefwaḥet ittfuḥen i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Aysum nnes ad yiři nnec, am yidmaren n wenhezzi am ucekrud afusi ad iřin nnec. ");
INSERT INTO rifl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Marra tiwhibin n usgeɛɛed zi tewhibin iqeddsen nni ɣa ssgeɛɛden ayt n Israil i SIDI, wciɣ tent i cek u i iḥenjiren nnec d tḥenjirin nnec inni akidek iǧan. Aqa d ict n tewṣeyyet i řebda, ad yiři d ijj n řɛahd s řemřaḥet i řebda zzat i wudem n SIDI, i cek u i zzariɛet nnec nni akidek iǧan.” ");
INSERT INTO rifl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Inna SIDI i Harun: “War tᵉttᵉṭṭfed řwart di temmurt nsen u war ɣarek tᵉttiři bu tesɣart di řwesṭ nsen. Necc d tasɣart nnec d řwart nnec di řwesṭ n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Xzar, Necc wciɣ i ayt n Lawi marra řeɛcur di Israil d řwart di ṭṭweɛ n tsexxart nni ggin nitni, tasexxart n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ayt n Israil war dd-ttqarriben ɛad ɣar Uqiḍun n Umsagar, ḥima war dd-ttiwyen ammu ddenb x yixef nsen uca ad mmten. ");
INSERT INTO rifl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Maca Ilawiyyen ad sexxaren di tsexxart n Uqiḍun n Umsagar uca ad arbun řmuɛṣiyyet nsen. Aqa-tt d ict n tewṣeyyet i řebda i marra jjiřat nwem, aqa nitni war ttᵉṭṭfen řwart di řwesṭ n ayt n Israil, ");
INSERT INTO rifl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","minzi řeɛcur n ayt n Israil nni ssgeɛɛden nitni i SIDI am tewhibt n usgeɛɛed, wciɣ ten i Ilawiyyen. X uya nniɣ asen: War warrten di řwesṭ n ayt n Israil!” ");
INSERT INTO rifl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ammu i ɣa tessiwřed ak-d Ilawiyyen uca ad asen tinid: ‘Xmi teksim řeɛcur n ayt n Israil nni wciɣ kenniw d řwart, xenni ad zzaysen tessgeɛɛdem ict n tewhibt n usgeɛɛed i SIDI, řeɛcur zi řeɛcur. ");
INSERT INTO rifl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ad awem dd-tᵉttwaḥseb am tewhibt n usgeɛɛed, am yirden n unedrar u am teccuret n tsirt n uḍiř. ");
INSERT INTO rifl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ammu i d awem ittxeṣṣa ad tessgeɛɛdem ict n tewhibt n usgeɛɛed i SIDI zi marra řeɛcur nwem nni ɣa teksim zeg ayt n Israil. Ittxeṣṣa ad tewcem tawhibt, tenni tessgeɛɛdem zzaysen i SIDI, ɣar ukehhan Harun. ");
INSERT INTO rifl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Zi marra min d awem ɣa wcen, ad tessgeɛɛdem tawhibt n usgeɛɛed tmun i SIDI, zi řemxeyyar nnes, tasɣart nnes iqeddsen zzayes.’ ");
INSERT INTO rifl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Uca ittxeṣṣa ac ad asen tinim: ‘Mařa teksim zzayes řemxeyyar nnes, aqa aya ad dd-ittwaḥseb d řɣiǧet n unedrar d řɣiǧet n tsirt n uḍiř i Ilawiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ad teccem aya di kuř amcan, kenniw d aytbab n taddart nwem, minzi ta d řmunet i tsexxart nwem deg Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Mařa ad zzayes teksim min iǧan ḥsen, xenni war xawem tarebbum ddenb. War iɛeddeř ad tfesdem tiwhibin iqeddsen n ayt n Israil, ḥima war tᵉttmettim ca.’” ");
INSERT INTO rifl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Issiweř SIDI ak-d Musa d Harun, inna: ");
INSERT INTO rifl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ta d tawṣeyyet n CCariɛa nni yumur SIDI, umi inna: ‘Siweř ak-d ayt n Israil ad ac dd-awyen ict n tfunast tazeggʷaɣt, tenni icnan u tenni war di iǧi uneɛḍab uca war xas ssarsen ɛad azayřu. ");
INSERT INTO rifl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ad tt tewcem i ukehhan Aliɛazar u netta ad tt issuffeɣ barra i řmargeḥ n řɛeskar u ad as ɣarṣen zzat i wudem nnes. ");
INSERT INTO rifl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Akehhan Aliɛazar ad iksi cwayt n idammen nnes s uḍaḍ nnes uca ad irucc sebɛa n twařawin cwayt zeg idammen nnes jjihet n wudem n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ad sscemḍen tafunast zzat i tiṭṭawin nnes. Tiřmect nnes, aysum nnes d idammen nnes ad ten sscemḍen jmiɛ ak-d umessař nnes. ");
INSERT INTO rifl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ad iksi ukehhan akeccuḍ n tcejjart n tengelt d tɛelǧet d uzeggʷaɣ iḥedqen uca ad inḍar aya di řwesṭ n tmessi i di tᵉttwacmeḍ tfunast. ");
INSERT INTO rifl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Xenni ad iṣebben ukehhan arruḍ nnes, ad issird arrimet nnes deg waman, uca awarni as ad yadef ɣar řmargeḥ. Akehhan ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","D wenni tt isscemḍen, ad iṣebben ɛawed arruḍ nnes deg waman uca ad issird arrimet nnes s waman. Netta ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Aryaz amezdag ad iyru iɣɣeḍ n tfunast uca ad ten igg barra i řmargeḥ deg ijj n wemcan izdig. Aqa x tmesmunt n ayt n Israil maḥend ad teḥḍa x waman n weɛzař, aqa aten i usizdeg n ddenb. ");
INSERT INTO rifl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Wenni iyrun iɣɣeḍ n tfunast ad iṣebben arruḍ nnes uca ad yiři ixmej ař tameddit. Aqa d ict n tewṣeyyet i řebda i ayt n Israil u i ubarrani nni izeddɣen di řwesṭ nsen.’” ");
INSERT INTO rifl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Wi ɣa iḥadan ca n umettin, mammec ma tegga ca n řxecbet n bnadem, ad yiři ixmej sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Deg wass wiss třata ad ikkes ddenb x yixef nnes s waman n weɛzař. Xenni ad yiři izdig deg wass wiss sebɛa. Mařa war ikkis ddenb x yixef nnes deg wass wiss třata, war ittiři izdig deg wass wiss sebɛa. ");
INSERT INTO rifl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Marra wi iḥadan ijj n umettin, řeɛmar n ijj n bnadem immut, uca war ikkis ddenb x yixef nnes, aqa issexmej Tazeddiɣt n SIDI. Řeɛmar nni ad ittwaqess zi Israil. Minzi war xas zzuzaren ca aman n weɛzař, ad yiři ixmej. Řexmej nnes aqa-t xas ɛad.” ");
INSERT INTO rifl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Wa d azerf x ijj n bnadem nni immuten deg ijj n uqiḍun. Marra wi ɣa yadfen ɣar uqiḍun nni u marra wi ɣa iqqimen deg uqiḍun nni, ad yiři ixmej sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ɛawed kuř řqecɛet yarezmen, war xas taqebbart teqqen s tesɣunt, ad tiři texmej, ");
INSERT INTO rifl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Marra wi iḥadan ḥed ittwassnuqqben s ssif deg iyyar, niɣ ca n umettin niɣ iɣsan n ijj n bnadem, niɣ ijj n wenḍeř, ad yiři ixmej sebɛa n wussan. ");
INSERT INTO rifl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","I yijj n umexmuj ittxeṣṣa ad ksin cwayt n iɣɣeḍ n tɣarṣt n ddenb icemḍen uca ad xas ssfarrɣen aman iddaren deg ict n řqecɛet. ");
INSERT INTO rifl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ijj n weryaz d amezdag ad iksi tɛelǧet, ad tt issuf deg waman uca xenni ad tt irucc x uqiḍun u x marra řeqcuɛ u x řeɛmur nni tuɣa din iǧan, uca ammu ɛawed x wi iḥadan iɣsan niɣ ca n yijjen nni ittwassnuqqben niɣ ca n umettin niɣ ca n wenḍeř. ");
INSERT INTO rifl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Amezdag ad irucc x umexmuj deg wass wiss třata u deg wass wiss sebɛa ad xas irucc u deg wass wiss sebɛa ad xas ikkes ddenb. Ad iṣebben arruḍ nnes ad issird ixef nnes s waman uca ad yiři izdeg ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Aryaz ixemjen i war ittejjin ad ikkes ddenb x yixef nnes, řeɛmar nni ad ittwaqess zi řwesṭ n wegraw n řgens, minzi aqa issexmej Zzawect Iqeddsen n SIDI. War xas ruccen aman n weɛzař, aqa ixmej. ");
INSERT INTO rifl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ta d ict n tewṣeyyet i řebda i nitni. Wenni iruccen aman n weɛzař ad iṣebben arruḍ nnes u wi ɣa iḥadan aman n weɛzař, ad yiři ixmej ař tameddit. ");
INSERT INTO rifl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Marra min ittwaḥadan zeg umexmuj, ad yiři ixmej, uca bnadem nni i ɣa iḥadan aya, ad yiři ixmej ař tameddit.” ");
INSERT INTO rifl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Deg uyur amezwaru tiweḍ marra tamesmunt n ayt n Israil ɣar řexřa n Ṣin. Řgens iqqim di Qadac. Din i temmut Maryam uca neḍřen tt din. ");
INSERT INTO rifl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","War tuɣi din ca aman i tmesmunt. Xenni munen ḍidd i Musa d Harun. ");
INSERT INTO rifl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Tuɣa řgens imcubbec ak-d Musa, nnan: “Mři tuɣa zzayneɣ iffeɣ buḥbeř umi tuɣa iffeɣ buḥbeř zeg aytmatneɣ zzat i wudem n SIDI! ");
INSERT INTO rifl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Mayemmi tessidfem wegraw n řgens n SIDI di řexřa-ya maḥend ad mmten din, neccin d řebhayem nneɣ? ");
INSERT INTO rifl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","U mayemmi d aneɣ dd-tessiřyem zi Miṣra ḥima ad aneɣ tessiwḍem ɣar wemcan-a aɛeffan? Deg wemcan-a war din zzariɛet niɣ tazart niɣ tzayart niɣ aremmam u war din ɛad aman ḥima ad nsu.” ");
INSERT INTO rifl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Xenni yiweḍ Musa ak-d Harun zi zzat n wudem n wegraw n řgens ɣar wadaf n Uqiḍun n Umsagar uca wḍan x wudmawen nsen uca iban asen-dd uɛuǧi n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ksi taɣɣarct uca smun tamesmunt, cek d Harun, umac. Ittxeṣṣa ad tessiwřem ak-d teṣḍart zzat i tiṭṭawin nsen uca xenni ad tewc aman nnes. Ammu i ɣa tessuffɣem aman i nitni zi teṣḍart uca ad tᵉssessud tamesmunt d řebhayem.” ");
INSERT INTO rifl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Xenni iksi Musa taɣɣarct zi zzat n wudem n SIDI am mammec d as yumur Netta, ");
INSERT INTO rifl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","uca issmun Musa d Harun agraw n řgens zzat i wudem n teṣḍart. Netta inna asen: “Sřem řexxu, a kenniw inni iɣewwɣen, ma ittxeṣṣa aneɣ ad dd-nessuffeɣ aman zi teṣḍart-a?” ");
INSERT INTO rifl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Uca issgeɛɛed Musa afus nnes uca iwta taṣḍart tnayen n twařawin s taɣɣarct nnes uca ffɣen-dd zzayes aṭṭas n waman uca teswa tmesmunt d řebhayem nsen. ");
INSERT INTO rifl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Xenni inna SIDI i Musa d Harun: “Minzi kenniw war d ayi tᵉttecřem zzat i tiṭṭawin n ayt n Israil ařami d ayi tweqqarem s uweqqar iqeddsen, s uya war tessidifem agraw-a n řgens di temmurt nni d asen wciɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ina aqa d aman n Mariba min xef arezzun ayt n Israil ad mcubbcen ak-d SIDI u mani Netta iban-dd d Amqeddes jar asen. ");
INSERT INTO rifl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Issekk Musa ireqqasen zi Qadac ɣar ujeǧid n Idum, nnan: “Ammu i iqqar Israil, umac: ‘Cek tessned marra tamara nni xaneɣ ikkin, ");
INSERT INTO rifl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","aqa řejdud nneɣ hwan-dd ɣar Miṣra u tuɣa nzeddeɣ aṭṭas n iseggʷusa di Miṣra u Imiṣriyyen ggin dayneɣ u di řejdud nneɣ aṭṭas n řɣar. ");
INSERT INTO rifl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nřaɣa x SIDI uca Netta isřa tmijja nneɣ uca issekk-dd lmalak uca issuffeɣ aneɣ-dd zi Miṣra. Xzar, aqa aneɣ di Qadac, ict n tendint ɣar ṭṭarf n jjihet nnec. ");
INSERT INTO rifl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ejj aneɣ, mařa texsed, ad neẓwa x temmurt nnec. War nẓekkwi x iyyaren niɣ x imarjaɛen nnec n uḍiř u war nᵉsess aman zeg wanuten. X webrid igellden ad neɛdu břa ma ad nḥeyyed ɣar yefus uřa ɣar uzeřmaḍ, ař ɣa neɛdu ɛawed iymiren n temmurt nnec.’” ");
INSERT INTO rifl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Inna as Idum: “War ttẓekkʷid xafi, niɣ ak kic mmsagareɣ s ssif balak!” ");
INSERT INTO rifl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Xenni nnan as ayt n Israil: “Ad neḍfar abrid ameqqran u mařa ad sweɣ aman nnec, necc d řebhayem inu, ad ten xeǧṣeɣ. Ad ẓwiɣ tammurt x iḍaren d wenni netta waha.” ");
INSERT INTO rifl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Maca netta inna: “War xas tẓekkʷid!” Uca iffeɣ Idum maḥend ad kis imsagar s yijj n ubarru d ameqqran d ufus ijehden. ");
INSERT INTO rifl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ammu yugi Idum ad iwc ttesriḥ i Israil maḥend ad iẓwa aymir nnes. S uyenni i ijja Israil abrid di ssibbet nnes. ");
INSERT INTO rifl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Fesyen iqiḍan nsen, ffɣen zi Qadac, uca xenni iwḍen ayt n Israil ɣar wedrar n Hur, tamesmunt marra. ");
INSERT INTO rifl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Issiweř SIDI ak-d Musa d Harun ɣar wedrar n Hur, ɣar weymir n temmurt n Idum, inna: ");
INSERT INTO rifl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Ad immarni Harun ɣar řgens nnes, minzi war ittidef ɣar temmurt nni wciɣ i ayt n Israil, minzi kenniw tɣennanem x řumur inu ɣar waman n Mariba. ");
INSERT INTO rifl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ksi Harun d Aliɛazar, mmis, uca arr i-ten ad geɛɛden x wedrar n Hur. ");
INSERT INTO rifl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ɛarra Harun zeg warruḍ nnes uca syarḍ i-t i Aliɛazar, mmis. Xenni ad ittwaksi Harun uca ad immet din.” ");
INSERT INTO rifl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa igga am mammec d as yumur SIDI. Uřyen adrar n Hur zzat i tiṭṭawin n marra tamesmunt. ");
INSERT INTO rifl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa iɛarra Harun zeg warruḍ nnes uca issyarḍ i-t i Aliɛazar, mmis. Uca immut Harun din x tqiccat n wedrar. Xenni ihwa-dd Musa zeg wedrar ak-d Aliɛazar. ");
INSERT INTO rifl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Marra tamesmunt teẓra belli Harun iḍřeq i buḥbeř nnes uca run třatin n wussan di ssibbet n Harun, marra taddart n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Umi isřa Akenɛani, ajeǧid n Ɛarad nni izeddɣen di Temmurt n Ljanub, belli yusa-dd Israil x webrid n ibergagen, immneɣ ḍidd i Israil uca iṭṭef ca zzaysen d imeḥbas. ");
INSERT INTO rifl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Xenni iwca Israil ijj n wawař i SIDI uca inna: “Mařa d tidett tɛarrned řgens-a deg ufus inu, necc ad ḥarrmeɣ tineddam nsen i uteḥḥi.” ");
INSERT INTO rifl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","SIDI istajeb i Israil uca isellem as ayt n Kenɛan uca nitni ḥarrmen i-ten i uteḥḥi uřa d marra tineddam nsen uca iřaɣa amcan nni s yisem n Ḥurma. ");
INSERT INTO rifl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Xenni fesyen iqiḍan nsen zeg wedrar n Hur, ruḥen x webrid ɣar Řebḥar n Telga uca s man aya tuɣa ittxeṣṣa ad nnḍen i temmurt n Idum. Uca řgens war iṣbir deg webrid. ");
INSERT INTO rifl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Aqa iqaceḥ řgens ḍidd i AREBBI d Musa: “Mayemmi d aneɣ dd-tessuffɣem zi Miṣra, maḥend ad nemmet di řexřa-ya? War da iǧi weɣrum uřa d aman. Řeɛmar nneɣ iɛiff zeg weɣrum-a i war isekkwin!” ");
INSERT INTO rifl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Xenni iḍřeq SIDI ifiɣran yareqqen jar řgens, inni izeɛfen řgens uca immut waṭṭas n řgens n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Yusa-dd řgens ɣar Musa, nnan: “Aqa nexḍa, minzi nqaceḥ ak-d SIDI u akidek. Ẓaǧ i SIDI maḥend ad xaneɣ ikkes ifiɣran-a.” Xenni iẓuǧ Musa di ṭṭweɛ n řgens. ");
INSERT INTO rifl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Inna SIDI i Musa: “Egg ijj n ufiɣar yareqqen uca sars i-t x ict n teḥnact uca man wen ma ittwazeɛfen u ad ɣares ixzar, ad iddar.” ");
INSERT INTO rifl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Uca igga Musa ijj n ufiɣar n nnḥas uca issars i-t x teḥnact uca xmi izeɛɛef ca n ufiɣar ca n yijjen, uca wanita ixezzar ɣar ufiɣar n nnḥas, xenni ad iqqim iddar. ");
INSERT INTO rifl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Xenni fesyen ayt n Israil iqiḍan nsen uca wtin iqiḍan nsen di Ubut. ");
INSERT INTO rifl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Xenni kksen iqiḍan nsen zi Ubut, wtin iqiḍan nsen ɣar arwinat n Ɛabarim di řexřa i iǧan zzat i wudem n Mu’ab manis dd-tneqqar tfuct. ");
INSERT INTO rifl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ssenni kksen iqiḍan nsen uca wtin iqiḍan nsen di teɣzurt n Zarad. ");
INSERT INTO rifl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ssenni kksen iqiḍan nsen uca wtin iqiḍan nsen x ujemmaḍ n yeɣzar n Arnun, wenni issizřen di řexřa, iffeɣ zi jjihet n weymir n Imuriyyen, minzi aqa Arnun d aymir ak-d Mu’ab, jar Mu’ab d Imuriyyen. ");
INSERT INTO rifl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","X uya qqaren deg wedlis ittwannḍen n garrat n SIDI: “Wahib di Sufa d tɣezratin n Arnun, ");
INSERT INTO rifl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","u tiɣezratin i dd-ihekkwan, ařami meyyřent ɣar tzeddiɣt n Ɛar, d tenni isennden x weymir n Mu’ab.” ");
INSERT INTO rifl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ssenni ruḥen ɣar Bi’r, ‘Anu’. Wa aqa d anu min xef inna SIDI i Musa: “Smun řgens, xenni ad asen wceɣ aman.” ");
INSERT INTO rifl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Xenni iɣennej Israil izři-ya: “Ngez, a anu!” Arrim-dd xas s ijj n izři: ");
INSERT INTO rifl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","“Cek anu, wenni ɣzin řḥukkam, wenni ineqcen tarwa n taṣiřet n řgens ak-d umgewwad nsen s izeǧaḍen nsen n řeḥkamet.” Zi řexřa ruḥen ɣar Mattana, ");
INSERT INTO rifl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","uca zi Mattana ɣar Naḥliyil, zi Naḥliyil ɣar Bamut, ");
INSERT INTO rifl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","uca zi Bamut ɣar teɣzurt nni iǧan deg iyyar n Mu’ab, x tqiccat n Fisja nni ittsijjan ɣar tnezruft. ");
INSERT INTO rifl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Xenni issekk Israil ireqqasen ɣar Siḥun, ajeǧid n Imuriyyen, inna: ");
INSERT INTO rifl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Ejj ayi ad cuqeɣ di temmurt nnec. War nettmeyyiř ca ɣar iyyaren niɣ ɣar imarjaɛen nnec n uḍiř u war nsess aman zeg wanuten. Ad neɛdu x webrid igellden, ař ɣa neɛdu x temmurt nnec.” ");
INSERT INTO rifl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Maca Siḥun war yejji ad iẓwa Israil x jjwayeh nnes. Issmun Siḥun marra řgens nnes uca iffeɣ, ḥima ad imsagar ak-d Israil, ɣar řexřa, uca yusa-dd di Yahaṣ uca immneɣ ak-d Israil. ");
INSERT INTO rifl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Uca Israil iwta i-t s řeqḍeɛ n ssif uca iksi temmurt nnes d řwart, zi Arnun ař Yabbuq, ař ayt n Ɛammun, minzi jjihet n ayt n Ɛammun aqa-t d ijj n lburj ijehden. ");
INSERT INTO rifl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Iksi Israil marra tineddam-a uca izdeɣ Israil di marra tineddam n Imuriyyen, di Ḥacbun u di marra tneddam i ɣares dd-iqqnen. ");
INSERT INTO rifl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Minzi Ḥacbun tuɣa d tandint n Siḥun, ajeǧid n Imuriyyen, uca netta tuɣa immneɣ ak-d ujeǧid i d as dd-izwaren n Mu’ab uca iksi zzayes marra tammurt nnes ař Arnun. ");
INSERT INTO rifl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","X uya qqaren inni issawařen s wawařen iweznen: “Asem-dd ɣar Ḥacbun, ad tᵉttwabna u ad tᵉttwaɛdeř tendint n Siḥun! ");
INSERT INTO rifl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Minzi teffeɣ-dd tmessi zi Ḥacbun d ijj n uɛeccař zi tendint n Siḥun, aceɛɛař nni icca Ɛar n ayt n Mu’ab řḥukkam n řuɛřat n Arnun. ");
INSERT INTO rifl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Uct xak, Mu’ab! Aqa ittwahellek řgens n Kamuc. Iḥenjiren nnes i tuɣa yarewřen d tḥenjirin nnes, aqa isellem i-ten d imeḥbas i Siḥun, ajeǧid n Imuriyyen. ");
INSERT INTO rifl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Aqa newwet i-ten s fřitcat. Ḥacbun ittwahellek ař Dibun. Nareddeǧ i-ten ař Nufaḥ tenni iǧan ař Midaba.” ");
INSERT INTO rifl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ammu i idweř Israil ad izdeɣ di temmurt n Imuriyyen. ");
INSERT INTO rifl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Uca issekk Musa ibergagen ɣar Yaɛzir uca ksin tineddam i ɣares dd-iqqnen uca kksen tasɣart n Imuriyyem nni tuɣa din izeddɣen. ");
INSERT INTO rifl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Xenni meyyřen zeg webrid nsen, uřyen abrid ɣar Bacan. Xenni iffeɣ-dd Ɛuj, ajeǧid n Bacan, netta d marra řgens nnes, maḥend ad kidsen imsagar i umenɣi di Idraɛi. ");
INSERT INTO rifl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Inna SIDI i Musa: “War zzayes tteggʷed ca, minzi Necc ggiɣ t deg ufus nnec, ak-d marra řgens nnes d temmurt nnes uca ad zzayes tegged am mammec teggid zi Siḥun ajeǧid n Imuriyyen, wenni tuɣa izeddɣen di Ḥacbun.” ");
INSERT INTO rifl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Uca areddǧen t, netta d iḥenjiren nnes d marra řgens nnes, ař mani war iqqim uřa d ijj n umařwar zzayes uca ksin tammurt nnes d řwart. ");
INSERT INTO rifl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Xenni fesyen ayt n Israil iqiḍan nsen uca wtin iqiḍan nsen di řewḍat n Mu’ab, arendad n Ariḥa nni iǧan x ujemmaḍ n L’Urdun. ");
INSERT INTO rifl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Uca iẓra Balaq, mmis n Ṣiffur, marra min igga Israil deg Imuriyyen. ");
INSERT INTO rifl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mu’ab tuɣa itteggʷed aṭṭas zi řgens-a, minzi tuɣa aten deg waṭṭas. Mu’ab tuɣa ittnexřaɛ zeg ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Xenni inna Mu’ab i imɣaren n Midyan: “Řexxu řɣaci-ya ad iřseḥ marra min d aneɣ-dd innḍen, am mammec iřesseḥ ufunas taziyzawt n yeyyar.” Tuɣa Balaq, mmis n Ṣiffur, ajeǧid n Mu’ab. ");
INSERT INTO rifl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Issekk ireqqasen ɣar Balɛam, mmis n Baɛur, ɣar tendint n Fatur ɣar yeɣzar n Lfuraṭ, di temmurt n ayt n řgens nnes, maḥend ad as dd-řaɣan uca netta inna: “Xzar, iffeɣ-dd ijj n řgens zi Miṣra uca xzar, aqa idřa udem n temmurt uca aqa nitni zeddɣen nican arendad inu. ");
INSERT INTO rifl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","As-dd řexxu, nɛeř řgens di ṭṭweɛ inu, minzi aqa ijhed xafi. Ad taɣ necc zemmareɣ ad t ɣeřbeɣ niɣ ad t ssuffɣeɣ zi temmurt, minzi necc ssneɣ belli wi ɣa tbarked cek, ad ittwabarek u wi ɣa tneɛřed, ad ittwanɛeř.” ");
INSERT INTO rifl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Xenni ruḥen imɣaren n Mu’ab d imɣaren n Midyan ak-d řmunet n uɛezzem deg ufus nsen, iwḍen ɣar Balɛam uca ssiwřen akides s wawařen n Balak. ");
INSERT INTO rifl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Netta inna asen: “Sensem da ǧiřet-a, xenni necc ad xawem dd-arreɣ am mammec ɣari ɣa issiweř SIDI.” Xenni qqimen řḥukkam n Mu’ab ɣar Balɛam. ");
INSERT INTO rifl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Yusa-dd AREBBI ɣar Balɛam, inna: “Min ɛnan iryazen nni iǧan akidek?” ");
INSERT INTO rifl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Inna Balɛam i AREBBI: “Balak, mmis n Ṣiffur, ajeǧid n Mu’ab, issekk i-ten-dd ɣari, inna: ");
INSERT INTO rifl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Xzar, ijj n řgens iffeɣ-dd zi Miṣra u aqa idřa udem n temmurt. As-dd, nɛeř i-t di ṭṭweɛ inu. Ad taɣ zemmareɣ xenni ad kisen menɣeɣ niɣ ad ten ssuffɣeɣ.’” ");
INSERT INTO rifl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Inna AREBBI i Balɛam: “War ttriḥ kisen niɣ ad tneɛřed řgens nni, minzi řgens aqa ittwabarek.” ");
INSERT INTO rifl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Xenni ikkar Balɛam di ṣṣbeḥ uca inna i řḥukkam n Balak: “Dewřem-dd ɣar temmurt nwem, minzi SIDI war d ayi ismiḥ ḥima ad raḥeɣ akidwem.” ");
INSERT INTO rifl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Xenni kkaren řḥukkam n Mu’ab uca dewřen-dd ɣar Balak uca nnan: “Balɛam yugi ad dd-yas akidneɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Issekk Balak ɛawed řḥukkam, ɛad ktar u ɛad wenni icennɛen ktar x yina imezwura. ");
INSERT INTO rifl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Usin-dd ɣar Balɛam, nnan: “Ammu i iqqar Balak, mmis n Ṣiffur: ‘Ttzawgeɣ cek, war ttejji ixef nnec maḥend war ɣari dd-ttased, ");
INSERT INTO rifl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","minzi ad cek karrmeɣ s waṭṭas uca ad ggeɣ marra min d ayi ɣa tinid. Ttzawgeɣ cek, as-dd uca nɛeř řgens-a di ṭṭweɛ inu!” ");
INSERT INTO rifl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Yarra-dd Balɛam uca inna i imsexxaren n Balak: “Waxxa Balak ad ayi iwc taddart nnes teccur s nnuqart d wureɣ, ɛad war zmireɣ ad ffɣeɣ x řumur n SIDI, AREBBI inu, maḥend ad ggeɣ ca n řḥajjet d tameẓyant niɣ ca n řḥajjet d tameqqrant. ");
INSERT INTO rifl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Xenni řexxu, ttzawageɣ kenniw, qqimem danita ǧiřet-a ḥima ad ssneɣ min d ayi ɣa yini SIDI ɛad ktar.” ");
INSERT INTO rifl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Di ǧiřet yusa-dd AREBBI ɣar Balɛam, inna as: “Mařa dewřen-dd yeryazen nni maḥend ad ac dd-řaɣan, kkar xenni uca ruḥ akidsen. Maca war ttegg mɣir min d ac ɣa iniɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ikkar Balɛam ɣar ṣṣbeḥ uca iḥezzem i teɣyuč nnes uca yuyur ak-d řḥukkam n Mu’ab. ");
INSERT INTO rifl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Xenni yarɣa weɣḍab n AREBBI, minzi netta iruḥ uca lmalak n SIDI ibedd deg webrid am cciṭan ḍidd nnes. Netta inya x teɣyuč nnes uca tnayen n imsexxaren tuɣa aten akides. ");
INSERT INTO rifl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Uca taɣyuč teẓra lmalak n SIDI ibedd deg webrid s ssif nnes ittwajebden deg ufus nnes. S uyenni teřḥem teɣyuč zeg webrid uca tuyur deg iyyar. Xenni iwta Balɛam taɣyuč ḥima ad tt yarr ɣar webrid. ");
INSERT INTO rifl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Maca lmalak n SIDI ibedd deg ict n tebridt teḥṣar jar imarjaɛen n uḍiř s yijj n weɣbar ɣar ṭṭarf d ijj n weɣbar ɣar ṭṭarf nneɣnit. ");
INSERT INTO rifl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Umi teẓra teɣyuč lmalak n SIDI, teřṣeq ɣar weɣbar uca ittwaḥṣar uḍar n Balɛam ak-d weɣbar uca netta iqqim iccat i-tt. ");
INSERT INTO rifl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Uca iruḥ lmalak n SIDI ɣar zzat uca ibedd deg ijj n wemcan iḥṣar aṭṭas ař mani war ittwif ttasiɛ maḥend ad iḥeyyed ɣar yefus uřa ɣar uzeřmaḍ. ");
INSERT INTO rifl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Umi teẓra teɣyuč lmalak n SIDI, tbarc sadu Balɛam uca Balɛam ixeyyeq aṭṭas uca ifarc taɣyuč s yijj n ukeccuḍ. ");
INSERT INTO rifl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Xenni yarzem SIDI aqemmum n teɣyuč uca tenna i Balɛam: “Min d ac ggiɣ umi d ayi tfarced řexxu ɛad třata n imuren?” ");
INSERT INTO rifl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Xenni inna Balɛam i teɣyuč: “Minzi cem tbuṣared xafi. Mři ɣari ssif deg ufus inu, ad tiři xenni nɣiɣ cem!” ");
INSERT INTO rifl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Tenna teɣyuč i Balɛam: “Ma war ǧiɣ necc taɣyuč nnec i xef tenyid zeg wami necc ɣarek ǧiɣ ař ass-a? Ma aqa necc nnumeɣ tteggeɣ ak kik ammu?” Uca yarra-dd xas: “Lla!” ");
INSERT INTO rifl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Xenni yarzem SIDI tiṭṭawin n Balɛam ařami iẓra lmalak n SIDI ibedd deg webrid s ssif nnes ittwajebden deg ufus nnes. Xenni yuḍar Balɛam, ibendeq s uɣembub nnes ɣar temmurt. ");
INSERT INTO rifl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Inna as lmalak n SIDI: “Mayemmi tewtid taɣyuč nnec třata n imuren? Xzar, aqa Necc ffɣeɣ-dd am ijj n weɣrim, minzi abrid-a ittḍarra ayi Necc nican. ");
INSERT INTO rifl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Teẓra ayi teɣyuč uca teřḥem xenni zi zzat i wudem inu třata n imuren. Mařa war teřḥim zi zzat i wudem inu, xenni Necc ad yiři aqa řexxu nɣiɣ cek u nettat ad tt jjeɣ ad teddar.” ");
INSERT INTO rifl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Xenni inna Balɛam i lmalak n SIDI: “Aqa necc xḍiɣ, minzi war ssineɣ belli Cek tbedded zzati deg webrid. Ɛad řexxu, mařa aya d řɛib di tiṭṭawin nnec, necc ad dd-dewřeɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Inna lmalak n SIDI i Balɛam: “Ruḥ ak-d iwdan-a, maca siweř waha min d ac ɣa iniɣ Necc.” Ammu iruḥ Balɛam ak-d řḥukkam n Balak. ");
INSERT INTO rifl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Umi Balak isřa, aqa Balɛam yusa-dd, iruḥ ḥima ad t immeřqa ɣar tandint n Mu’ab i iǧan ɣar jjihet n weymir n Arnun, ɣar ṭṭarf n jjihet n weymir. ");
INSERT INTO rifl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Uca Balak inna i Balɛam: “Ma war ssekkeɣ necc iwdan ad ac dd-řaɣan? Mayemmi war ɣari dd-tusid? Ma war zemmareɣ necc ad cek karmeɣ?” ");
INSERT INTO rifl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Xenni yarra-dd Balɛam x Balak: “Xzar, necc usiɣ-dd ɣarek, maca ma zemmareɣ necc řexxu ad ssiwřeɣ x ca? Awař nni i ɣa yegg SIDI deg uqemmum inu, ad t iniɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Uca iruḥ Balɛam ak-d Balak uca usin-dd ɣar Qaryat-Ḥaṣut. ");
INSERT INTO rifl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Xenni iɣarṣ Balak i ifunasen d wuǧi, issekk zzaysen ɣar Balɛam u ɣar řḥukkam nni tuɣa akides. ");
INSERT INTO rifl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ɣar ṣṣbeḥ imsar belli Balak yiwi akis Balɛam uca issiři i-t x řuɛřat n Baɛl mani tuɣa izemmar ad iẓar řgens ař ṭṭarf iggʷejen qaɛ. ");
INSERT INTO rifl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Xenni inna Balɛam i Balak: “Bna sebɛa n iɛalṭaren danita i necc uca sewjed ayi sebɛa n ifunasen imeẓyanen d sebɛa n icarriyyen.” ");
INSERT INTO rifl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak igga am mammec d as inna Balɛam uca Balak d Balɛam qeddmen ijj n ufunas ameẓyan d ijj n icarri x kuř ijj n uɛalṭar. ");
INSERT INTO rifl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Xenni Balɛam inna i Balak: “Bedd din zzat i tɣarṣt n wecmaḍ nnec, xenni necc ad raḥeɣ. Ad taɣ ad kidi imsagar SIDI uca mammec ma igga wawař nni d ayi ɣa isscen, necc ad ac t-i-dd-ssargbeɣ.” Xenni iruḥ Balɛam ɣar tqiccat d taqeccart n wedrar. ");
INSERT INTO rifl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","U immeřqa AREBBI ak-d Balɛam uca netta inna as: “Aqa sswejdeɣ sebɛa n iɛalṭaren uca qeddmeɣ ijj n ufunas ameẓyan d ijj n icarri x kuř ijj n uɛalṭar.” ");
INSERT INTO rifl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Xenni igga SIDI ijj n wawař deg uqemmum n Balɛam uca inna: “Dweř ɣar Balak uca siweř akides ammu.” ");
INSERT INTO rifl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Uca umi ɣares-dd idweř, xzar, ibedd zzat i tɣarṣt n wecmaḍ nnes, jmiɛ ak-d marra řḥukkam n Mu’ab. ");
INSERT INTO rifl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Xenni ibda iqqar awař nnes iweznen, inna: “Zi Aram indeh ayi-dd Balak, ajeǧid n Mu’ab, zeg idurar n ccarq, inna: ‘As-dd, nɛeř ayi Yaɛqub, as-dd, zawar Israil!’ ");
INSERT INTO rifl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Maca mammec ɣa neɛřeɣ, wenni war ittwaneɛřen zi Arebbi, u mammec ɣa zawareɣ wenni war izawar SIDI? ");
INSERT INTO rifl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Minzi zi tqiccat n tṣuḍar twařiɣ t, uca zi tiwririn xezzareɣ dayes. Aqa wa d ijj n řgens izeddɣen weḥḥdes u war iḥesseb ixef nnes jar řegnus. ");
INSERT INTO rifl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Wi ɣa iḥesben acař n Yaɛqub niɣ wi i ɣa iḥesben řqedd n ijj n arbeɛ zi Israil? Ejj ad immet řeɛmar inu řmewt n imseggaden u ejj ɛawed ad yiři uneggar n tudart inu ad imqudda akides!” ");
INSERT INTO rifl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Xenni inna Balak i Balɛam: “Min d ayi teggid? Necc iwyeɣ cek ḥima ad tneɛřed řɛedyan inu, maca xzar, aqa nican tbarked i-ten!” ");
INSERT INTO rifl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Netta yarra-dd, inna: “Ma war ittxeṣṣi ad ḥḍiɣ maḥend ad ssiwřeɣ min igga SIDI deg uqemmum inu?” ");
INSERT INTO rifl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Xenni inna Balak: “Ttzawgeɣ cek ad dd-tased akidi ɣar ijj n wemcan nneɣni zi manis ɣa tẓared řgens ɛawed. Ad tẓared ṭṭrufa nnes waha, war t tẓarred marra. Ssenni ad t tneɛřed di ṭṭweɛ inu!” ");
INSERT INTO rifl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Uca yiwyi i-t ɣar řewḍa n Ṣufim x tqiccat n Fisja uca ibna din sebɛa n iɛalṭaren uca x kuř ijj n uɛalṭar iqeddem ijj n ufunas ameẓyan d ijj n icarri. ");
INSERT INTO rifl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Netta inna i Balak: “Mařa cek ad tbedded da zzat i tɣarṣt nnec n wecmaḍ, xenni necc ad kis mmsagareɣ din.” ");
INSERT INTO rifl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Uca imsagar SIDI ak-d Balɛam uca igga ijj n wawař deg uqemmum nnes, inna: “Dweř ɣar Balak uca ini as ammu.” ");
INSERT INTO rifl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Uca netta yusa-dd ɣares, u xzar, netta tuɣa ibedd zzat i tɣarṣt n wecmaḍ nnes uca řḥukkam n Mu’ab bedden zzates. Inna as Balak: “Min inna SIDI?” ");
INSERT INTO rifl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Xenni ibda netta awař nnes iweznen, inna: “Kkar, Balak, sḥess! Seř ɣari, cek, mmis n Ṣiffur! ");
INSERT INTO rifl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Arebbi war iǧi d mmis n bnadem, maḥend zeɛma ad issxarriq, niɣ d mmis n bnadem maḥend zeɛma ad t iřqef wendam. Ma ad yini uca war tt ittegg, niɣ ad issiweř uca war tt ittkemmiř? ");
INSERT INTO rifl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Xzar, aqa ṭṭfeɣ řumur ḥima ad barkeɣ. Umi ibarek Netta, necc war zemmareɣ ad dd-arreɣ aya. ");
INSERT INTO rifl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","War ittwiři řmuɛṣiyyet n Yaɛqub u řeɣben n Israil war t iẓar. SIDI, AREBBI nnes, aqa-t akides uca asuḍi s wesruddeḥ di řbuq di ṭṭweɛ n Ujeǧid aqa-t dayes. ");
INSERT INTO rifl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Arebbi issuffeɣ i-ten-dd zi Miṣra. Netta i nitni am waccawen iziraren n iɣayḍ n řexřa. ");
INSERT INTO rifl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Aqa zeɛma war din aɛezzem di Yaɛqub u war din tagezzant di Israil. Ta d řweqt i di tᵉttwanna x Yaɛqub d Israil: ‘Aqa xzar, min igga Arebbi!’ ");
INSERT INTO rifl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Aqa da, řgens ad ikkar am teyradt u ad dd-igeɛɛed am weyrad. War issezzeř ixef nnes ař ɣa yecc taymart nnes uca ad issu idammen n min imezzeq.” ");
INSERT INTO rifl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Xenni inna Balak i Balɛam: “Mařa xenni war texsed qaɛ ad t tneɛřed, war t ttbarak ca ɛawed.” ");
INSERT INTO rifl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balɛam yarra-dd, inna i Balak: “Ma war d ac nniɣ: ‘Marra min d ayi ɣa yini SIDI, ad t ggeɣ?’” ");
INSERT INTO rifl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Xenni inna Balak i Balɛam: “Ttzawgeɣ cek ad dd-tased, ad cek awyeɣ ɣar ijj n wemcan nneɣni. Ad taɣ ad yiři nican di tiṭṭawin n AREBBI mařa ad t tneɛřed ssenni di ṭṭweɛ inu.” ");
INSERT INTO rifl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Uca Balak indeh Balɛam ɣar tqiccat n Faɣur nni ixezzaren ɣar tnezruft. ");
INSERT INTO rifl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Xenni inna Balɛam i Balak: “Bna danita sebɛa n iɛalṭaren uca sewjed ayi danita sebɛa n ifunasen imeẓyanen d sebɛa n icarriyyen.” ");
INSERT INTO rifl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak igga am mammec d as inna Balɛam uca x kuř ijj n uɛalṭar iqeddem din ijj n ufunas ameẓyan d ijj n icarri. ");
INSERT INTO rifl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Iẓra Balɛam belli aqa yarḍa i tiṭṭawin n SIDI umi ibarek Israil uca xenni war yarezzu, am umur amezwaru d umur wiss tnayen, ḥima ad iɛezzem s ifiɣran, maca yarra udem nnes ɣar řexřa. ");
INSERT INTO rifl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Umi issgeɛɛed tamuɣři nnes, iẓra Israil izdeɣ din, tᵉttwasettef ɛlaḥsab tiqebbař nnes, xenni yusa-dd Arruḥ n AREBBI xas. ");
INSERT INTO rifl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ibda netta awař nnes iweznen, inna: “Awař n Balɛam, mmis n Baɛur, awař n weryaz ijehden, wenni umi teqqen tiṭṭ, ");
INSERT INTO rifl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ijj n wawař n wenni isřin awařen n Arebbi, d wenni ixezzaren řewḥiy n Umzemmar x kuřci, am dd-iwḍa s tiṭṭawin yarezmen. ");
INSERT INTO rifl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","A Yaɛqub, mecḥař ṣebḥen iqiḍan nnec, d tzeddiɣin nnec, a Israil!, ");
INSERT INTO rifl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","aqa sswiẓẓaḍen amecnaw tiɣzurin, amecnaw aɣemmuy icewwaren ak-d yeɣzar, amecnaw acfiř nni iẓẓu SIDI, amecnaw ticejjura n tengelt zzat i waman. ");
INSERT INTO rifl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Zeg ibuqařen nnes ad ssizzřen waman uca zzariɛet nnes ad tiři di tuffet. Ajeǧid nnes ad ittwassgeɛɛed x Ajaj u tageldit nnes ad tᵉttwassuɛřa. ");
INSERT INTO rifl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Arebbi issuffeɣ i-t-i-dd zi Miṣra. Jjehd nnes am waccawen iziraren n iɣayḍ n řexřa. Ad yecc řegnus, iɣrimen nnes, ad iřbez iɣussan nsen uca ad ten issnuqqeb s fřitcat nnes. ");
INSERT INTO rifl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Aqa iɣnes, issezzeř ixef nnes am weyrad, am teyradt. Wi t i dd ɣa issekkaren? Wenni cek ittbarken, ad ittwabarek u wenni cek ineɛɛřen, ad yiři ittwanɛeř!’” ");
INSERT INTO rifl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Xenni yarɣa uxeyyeq n Balak x Balɛam. Iwta netta deg ifassen nnes uca Balak inna i Balɛam: “Aqa řaɣiɣ-dd cek maḥend ad tneɛřed řɛedyan inu, maca xzar, aqa tbarked i-ten ɛad nican třata n imuren! ");
INSERT INTO rifl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Xenni řexxu, arweř ɣar wemcan mani tzeddɣed! Necc nniɣ ac t, ad cek cenɛeɣ aṭṭas, maca xzar, SIDI imneɛ xak ccenɛet nni!” ");
INSERT INTO rifl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Xenni inna Balɛam i Balak: “Ma war ssiwřeɣ ak-d ireqqasen nni d ayi dd-tᵉssekked uca nniɣ: ");
INSERT INTO rifl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Waxxa Balak ad ayi iwc taddart nnes teccur s nnuqart d wureɣ, xenni necc ɛad war zmireɣ ad ɛeddiɣ x řumur n SIDI, maḥend ad ggeɣ ca n řḥajjet n řxar niɣ n řɣar i dd-itteffɣen zeg wuř inu. Min ɣa yini SIDi, ad t iniɣ.’ ");
INSERT INTO rifl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Řexxu xenni, xzar, necc ad dd-dewřeɣ ɣar řgens inu. As-dd, necc ad cek ssaregbeɣ x řefhamet uca ad ac iniɣ min d ac ɣa yegg řgens-a deg uneggar n wussan.” ");
INSERT INTO rifl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Xenni ibda netta awař iweznen nnes, inna: “Awař n Balɛam, mmis n Baɛur, awař n weryaz ijehden, wenni umi teqqen tiṭṭ! ");
INSERT INTO rifl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Tawařt n wenni isřin awařen n Arebbi, d wenni issnen zi tussna n wenni d Amɛuǧi x kuřci, d wenni ixezzaren řewḥiy n Umzemmar x kuřci, am dd-iwḍa s tiṭṭawin yarezmen. ");
INSERT INTO rifl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ad t ẓarɣ, war iǧi řexxu, ad t twařiɣ, maca war iǧi zi řadaset. Ad dd-iffeɣ itri zi Yaɛqub uca ad tekkar uzeǧaḍ n řḥakem zi Israil, wenni i ɣa iřebzen lḥenkat n uzeǧif n Mu’ab uca ad iřbez marra tarwa n ssdeɛ ");
INSERT INTO rifl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","uca ad ittwaṭṭef Idum d řwart u Saɛir, wenni d řeɛdu nnes, ad t ṭṭfen d řwart ɛawed, uca ammu i ɣa yegg Israil s taryast. ");
INSERT INTO rifl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","U wenni i dd ɣa iffɣen zi Yaɛqub ad iḥkem u netta ad isshellek wenni yarewřen zi tendint.” ");
INSERT INTO rifl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Umi netta iẓra Ɛamaliq, ibda awař iweznen nnes, inna: “Ɛamaliq d amezwaru n řegnus, maca aneggaru nnes ad idweř d ahellek!” ");
INSERT INTO rifl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Řami iẓra Iqiniyyen, ibda netta awař iweznen nnes, inna: “Tazeddiɣt nnec temten uca teggid řɛucc nnec di teṣḍart. ");
INSERT INTO rifl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ɛad Qayin ad ittwassecmeḍ. Ař meřmi izemmar Accur ad ac dd-yawi d ameḥbus?” ");
INSERT INTO rifl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Uca ibda netta awař iweznen nnes, inna: “Ay, wi ɣa iqqimen iddaren xmi xas i ɣa issars Arebbi man aya? ");
INSERT INTO rifl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Iɣarruba zi jjwayeh n Kittim ad ɣezzan Accur uca ad ɣezzan ɛawed Ɛabir u netta ad ittwateḥḥa.” ");
INSERT INTO rifl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ikkar Balɛam, yuyur uca idweř ɣar wemcan nnes n tzeddiɣt. Uřa d Balak iṭṭef abrid nnes. ");
INSERT INTO rifl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Izdeɣ Israil di Ciṭṭim uca ibda řgens ad issefsed ixef nnes ak-d yessis n Mu’ab. ");
INSERT INTO rifl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ɛarḍen-dd řgens ɣar tɣarṣi n irebbiten nsent uca řgens icca zzaysent, uca nitni bendqen i irebbiten nsent. ");
INSERT INTO rifl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ammu imun řgens ak-d Baɛl-Faɣur uca yarɣa weɣḍab n SIDI x Israil. ");
INSERT INTO rifl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Inna SIDI i Musa: “Ksi marra iryazen nni iǧan d izeǧifen n řgens uca ayeř i-ten zzat i SIDI di tfuct iḥarren, xenni ad iggʷej řḥaduq n weɣḍab n SIDI x Israil.” ");
INSERT INTO rifl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Xenni inna Musa i řquḍat n Israil: “Ejj kuř ijj ad ineɣ inni zi jar yeryazen nnes i imunen ak-d Baɛl-Faɣur!” ");
INSERT INTO rifl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Uca xzar, ijj n weryaz zeg ayt n Israil yusa-dd uca netta yiwi-dd ict n temɣart Tmidiyanect ɣar aytmas zzat i tiṭṭawin n Musa u zzat i tiṭṭawin n marra tamesmunt n ayt n Israil, am ttrun nitni ɣar wadaf n Uqiḍun n Umsagar. ");
INSERT INTO rifl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Iẓra i-t Finaḥas, mmis n Aliɛazar, mmis n Harun. Netta ikkar zi řwesṭ n tmesmunt, iksi ijj n uḥric deg ufus nnes ");
INSERT INTO rifl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","uca iruḥ awarni i weryaz zi Israil ɣar uqiḍun s řqubbet uca issnuqqeb i-ten s tnayen, am weryaz nni zi Israil, am temɣart s uɛeddis nnes. Xenni tbedd jjriḥect x ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Uca mmuten di jjriḥect arebɛa u-ɛicrin-ařef n iwdan. ");
INSERT INTO rifl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Fineḥas, mmis n Aliɛazar, mmis n Harun, akehhan, isseggwej asɛar inu x ayt n Israil, minzi netta tuɣa imḥeḍ aṭṭas di řwesṭ nsen di ṭṭweɛ n tusmi inu iqeddsen, ařami Necc war hdijeɣ ɛad ad teḥḥiɣ ayt n Israil di řweqt n tusmi inu iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","S uya ini: ‘Xẓar, Necc ad as wceɣ Řɛahd inu n řehna. ");
INSERT INTO rifl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","I netta u i zzariɛet nnes awarni as ad ɣarsen yiři Řɛahd n tukehhant i řebda, minzi netta tuɣa imḥeḍ di ṭṭweɛ n AREBBI nnes uca igga aṣřaḥ di ṭṭweɛ n ayt n Israil.’” ");
INSERT INTO rifl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isem n weryaz n Israil nni inɣa Fineḥas, i tuɣa ittwaneɣ jmiɛ ak-d temɣart Tamidyanect, tuɣa-t d Zimri, mmis n Salu, ijj n řḥakem x taddart n babatsen, x Icimɛuniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Isem n temɣart Tamidyanict i tuɣa ittwanɣen tuɣa-tt Kuzbi, yeǧis n Ṣur, wenni d ijj n uzeǧif x tqebbařt n taddart n ijj n tbabat n Imidyaniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Ḥṣarem x Imidyaniyyen uca ɣellbem xasen, ");
INSERT INTO rifl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","minzi nitni ḥṣaren kenniw s teḥraymect nsen s minzi kenniw zeřɣen zi jjihet n Faɣur d Kuzbi, yeǧis n řḥakem n Midyan, učmatsen, tenni ittwanɣen deg wass n jjriḥect di ssibbet n Faɣur.” ");
INSERT INTO rifl_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","Uca awarni i jjriḥect imsar min dd-igguren. ");
INSERT INTO rifl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Issiweř SIDI ak-d Musa d Aliɛazar, mmis n Harun, akehhan, inna: ");
INSERT INTO rifl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Ḥesbem marra tamesmunt n ayt n Israil, azeǧif azeǧif, zi ɛicřin n iseggʷusa sennej, am ttwasettfen nitni ɛlaḥsab taddart n ibabaten nsen, marra wenni dd-itteffɣen di Israil ak-d řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa d Aliɛazar, akehhan, ssiwřen akidsen di řewḍat n Mu’ab, ɣar L’Urdun arendad n Ariḥa uca nnan: ");
INSERT INTO rifl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Zi ɛicřin n iseggʷusa sennej!” am mammec t yumur SIDI i Musa. Ina d ayt n Israil nni tuɣa dd-iffɣen zi temmurt n Miṣra: ");
INSERT INTO rifl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubin tuɣa d amenzu n Israil. Aqa ina d iḥenjiren n Rubin: zi Ḥanuk řaǧ n Iḥanukiyyen, zi Fallu řaǧ n Ifalluwiyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","zi Ḥaṣrun řaǧ n Iḥaṣruniyyen, zi Karmi řaǧ n Ikarmiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Tina tuɣa d řaǧat n Irubiniyyen uca inni zzaysen ittwaḥesben tuɣa aten di třata u-rebɛin-ařef u-sebɛa-mya u-třatin n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Tarwa n Fallu tuɣa aten: mɣir Iliyab. ");
INSERT INTO rifl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Tuɣa arraw n Iliyab: Nimuyil, Datan d Abiram. Ina, Datan d Abiram, tuɣa aten d imřaɣan n tmesmunt inni iɣewwɣen ḍidd i Musa d Harun, jmiɛ ak-d ubarru n Quraḥ, umi ɣewwɣen ḍidd i SIDI.    ");
INSERT INTO rifl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Tammurt tarzem aqemmum nnes uca tsarḍ i-ten, jmiɛ ak-d Quraḥ, řami immut ubarru nni umi timessi tecca mitayen u-xemsin n yeryazen. Dewřen nitni d ijj n weɛřam issiggwiden. ");
INSERT INTO rifl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Maca iḥenjiren n Quraḥ war mmuten ca. ");
INSERT INTO rifl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ina tuɣa d iḥenjiren n Cimɛun ɛlaḥsab řaǧat nsen: zi Nimuyil iqqarṣ řaǧ n Inimuyiliyyen, zi Yamin řaǧ n Iyaminiyyen, zi Yakin řaǧ n Iyakiniyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","zi Zaraḥ řaǧ n Izaraḥiyyen, zi Cawul řaǧ n Icawuliyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Tina tuɣa d řaǧat n Icimɛuniyyen: tnayen u-ɛicrin-ařef u-mitayn n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ina tuɣa d iḥenjiren n Jad ɛlaḥsab řaǧat nsen: zi Ṣifun iqqarṣ řaǧ n Iṣifuniyyen, zi Ḥajji řaǧ n Iḥajjiwiyyen, zi Cuni řaǧ n Icuniyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","zi Uzni řaǧ n Iyuzniyyen, zi Ɛiri řaǧ n Iɛiriyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","zi Arud řaǧ n Irudiyyen, zi Ariyili řaǧ n Iriyiliyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Tina tuɣa atent d řaǧat n Jad uca inni zzaysen ittwaḥesben tuɣa aten di arebɛin-ařef u-xemsa-mya. ");
INSERT INTO rifl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Ayt n Yahuda tuɣa aten d Ɛir d Unan. Maca mmuten Ɛir d Unan di temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ina tuɣa aten d iḥenjiren n Yahuda ɛlaḥsab řaǧat nsen: zi Cayla iqqarṣ řaǧ n Icilayyen, zi Fariṣ řaǧ n Ifaraṣiyyen, zi Zaraḥ řaǧ n Izaraḥiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ina tuɣa aten d iḥenjiren n Fariṣ: zi Ḥaṣrun iqqarṣ řaǧ n Iḥaṣruniyyen, zi Ḥamul řaǧ n Iḥamuliyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Tina tuɣa atent d řaǧat n Yahuda uca inni zzaysen ittwaḥesben tuɣa aten di setta u-sebɛin-ařef u-xemsa-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ina tuɣa aten d iḥenjiren n Issakar ɛlaḥsab řaǧat nsen: zi Tulaɛ iqqarṣ řaǧ n Itulaɛiyyen, zi Puwa řaǧ n Ipuwaniyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","zi Yacub řaǧ n Iyacubiyyen, zi Cimrun řaǧ n Icimruniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Tina tuɣa atent d řaǧat n Issakar uca inni zzaysen ittwaḥesben tuɣa aten di arebɛa u-settin-ařef u-teřt-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ina tuɣa aten d iḥenjiren n Zabulun ɛlaḥsab řaǧat nsen: zi Sarid iqqarṣ řaǧ n Isaridiyyen, zi Ilun řaǧ n Iluniyyen, zi Yaḥliyil řaǧ n Iyaḥliyiliyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Tina tuɣa atent d řaǧat n Izabuluniyyen uca inni zzaysen ittwaḥesben tuɣa aten di settin-ařef u-xemsa-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ina tuɣa aten d iḥenjiren n Yusuf ɛlaḥsab řaǧat nsen: Manassa d Ifrayim. ");
INSERT INTO rifl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ina tuɣa aten d iḥenjiren n Manassa: zi Makir iqqarṣ řaǧ n Imakiriyyen. Makir yejj-dd Jilɛad. Zi Jilɛad iqqarṣ řaǧ n Ijilɛadiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ina tuɣa aten d iḥenjiren n Jilɛad: zi Iɛazar iqqarṣ řaǧ n Iɛazariyyen, zi Ḥalaq řaǧ n Iḥalaqiyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","zi Asriyil řaǧ n Isriyiliyyen, zi Cakam řaǧ n Icakamiyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","zi Cimidaɛ řaǧ n Icimdaɛiyyen, zi Ḥafar řaǧ n Iḥafariyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ṣalufḥad, mmis n Ḥafar, war tuɣi ɣares ca iḥenjiren, mɣir tiḥenjirin. Ina tuɣa aten d ismawen n yessis n Ṣalufḥad: Maḥla, Nuɛa, Ḥujla, Milka d Tirṣa. ");
INSERT INTO rifl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Tina tuɣa atent d řaǧat n Manassa uca inni zzaysen ittwaḥesben tuɣa aten di tnayen u-xemsin-ařef u-sebɛa-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ina tuɣa aten d iḥenjiren n Ifrayim, ɛlaḥsab řaǧat nsen: zi Cutalaḥ iqqarṣ řaǧ n Icutalaḥiyyen, zi Bakar řaǧ n Ibakariyyen, zi Taḥan řaǧ n Itaḥaniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ina tuɣa aten d iḥenjiren n Cutalaḥ: zi Ɛiran řaǧ n Iɛiraniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Tina tuɣa atent d řaǧat n warrawen n Ifrayim uca inni zzaysen ittwaḥesben tuɣa aten di tnayen u-třatin-ařef u-xemsa-mya n yeryazen. Ina tuɣa aten d arrawen n Yusuf, ttwasettfen ɛlaḥsab řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ina tuɣa aten d iḥenjiren n Binyamin ɛlaḥsab řaǧat nsen: zi Bilaɛ iqqarṣ řaǧ n Ibilaɛiyyen, zi Acbil řaǧ n Icbiliyyen, zi Aḥiram řaǧ n Iḥiramiyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","zi Cafufam řaǧ n Icafufamiyyen, zi Ḥufam řaǧ n Iḥufamiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ina tuɣa aten d iḥenjiren n Balaɛ: Ard d Nuɛman. Zi Ard iqqarṣ řaǧ n Irdiyyen, zi Nuɛman řaǧ n Inuɛmaniyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ina tuɣa aten d iḥenjiren n Binyamin, ɛlaḥsab řaǧat nsen uca inni zzaysen ittwaḥesben tuɣa aten di xemsa u-rebɛin-ařef u-setta-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ina tuɣa aten d iḥenjiren n Dan ɛlaḥsab řaǧat nsen: zi Cuḥam iqqarṣ řaǧ n Icuḥamiyyen. Tina tuɣa d řaǧat n Dan, ttwasettfent ɛlaḥsab řaǧat nsen. ");
INSERT INTO rifl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Marra řaǧat n Icuḥamiyyen, aqa inni zzaysen ittwaḥesben tuɣa aten di arebɛa u-settin-ařef u-arebɛa-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ina tuɣa aten d iḥenjiren n Acir ɛlaḥsab řaǧat nsen: zi Yimna iqqarṣ řaǧ n Iyimniyyen, zi Yicwi řaǧ n Iyicwiyyen, zi Beriɛa řaǧ n Ibariɛiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ina tuɣa aten d iḥenjiren n Beriɛa: zi Ḥabir iqqarṣ řaǧ n Iḥabiriyyen, zi Malkiyil řaǧ n Imalkiyiliyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Isem n yeǧis n Acir tuɣa-tt d Saraḥ. ");
INSERT INTO rifl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ina tuɣa aten d iḥenjiren n Acir uca inni zzaysen ittwaḥesben tuɣa aten di třata u-xemsin-ařef u-arebɛa-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ina tuɣa aten d iḥenjiren n Naftali ɛlaḥsab řaǧat nsen: zi Yaḥasyil iqqarṣ řaǧ n Iyaḥasliyyen, zi Juni řaǧ n Ijuniyyen, ");
INSERT INTO rifl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","zi Yaṣir řaǧ n Iyaṣiriyyen, zi Cillim řaǧ n Icillimiyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Tina tuɣa atent d řaǧat n Naftali, ɛlaḥsab řaǧat nsen uca inni zzaysen ittwaḥesben tuɣa aten di xemsa u-rebɛin ařaf u-arebɛa-mya n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ina d inni ittwaḥesben zeg ayt n Israil: setta-mya u-waḥit-ařef u-sebɛa-mya u-třatin n yeryazen. ");
INSERT INTO rifl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Jar ina ad tᵉttwabḍa temmurt d řwart, ɛlaḥsab řqedd n ismawen nsen. ");
INSERT INTO rifl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","I wenni umi ɣar iǧa aṭṭas n iwdan, ad tewced ktar d řwart uca i wenni umi ɣar iǧa drus n iwdan, ad tewced qell d řwart. Kuř ijjen ɛlaḥsab inni ittwaḥesben ad as temmewc tasɣart nnes. ");
INSERT INTO rifl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Tammurt ad tᵉttwabḍa s tqedduḥt. Nitni ad warten ɛlaḥsab ismawen n tqebbař n řejdud nsen. ");
INSERT INTO rifl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ad tᵉttwabḍa tesɣart n kuř ijj s tqedduḥt jar inni iǧan s waṭṭas d inni iǧan drus.” ");
INSERT INTO rifl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ina tuɣa aten d inni ittwaḥesben zi Lawi ɛlaḥsab řaǧat nsen: zi Jarcun řaǧ n Ijarcuniyyen, zi Qahat řaǧ n Iqahatiyyen, zi Marari řaǧ n Imarariyyen. ");
INSERT INTO rifl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Tuɣa tina d řaǧat n Ilawiyyen: řaǧ n Ilibniyyen, řaǧ n Iḥibruniyyen, řaǧ n Imahliyyen, řaǧ n Imuciyyen, řaǧ n Iquraḥiyyen. Uca Qahat yejj-dd Ɛamram. ");
INSERT INTO rifl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Tamɣart n Ɛamram qqarent as Jukabad, yeǧis n Lawi, tenni dd-ittwarwen i Lawi di Miṣra. D nettat turuw-dd Harun d Musa d Maryam, učmatsen, i Ɛamram. ");
INSERT INTO rifl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","I Harun ttwarwen as-dd Nadab d Abihu, Aliɛazar d Itamar. ");
INSERT INTO rifl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Maca Nadab d Abihu mmuten, umi dd-iwyen timessi taɣribt zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Inni zzaysen ittwaḥesben, zeg Ilawiyyen, marra iwetman n ijj n uyur sennej, tuɣa aten di třata u-ɛicrin-ařef. Ina maca war ttwaḥesben ca ak-d ayt n Israil, minzi war d asen temmewc tesɣart d řwart jar ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ina tuɣa aten d inni ittwaḥesben s ufus n Musa d Aliɛazar, akehhan. Nitni ḥesben ayt n Israil di řewḍat n Mu’ab, ɣar L’Urdun arendad n Ariḥa. ");
INSERT INTO rifl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","War tuɣi jar asen uřa d ijj zeg inni ittwaḥesben n Musa d Harun, akehhan, umi ḥesben nitni ayt n Israil di řexřa n Sina. ");
INSERT INTO rifl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","minzi xasen tuɣa inna SIDI ad mmten s tidett di řexřa. War zzaysen iqqim uřa d ijj, mɣir Kalib, mmis n Yafunni, d Yacuwa, mmis n Nun. ");
INSERT INTO rifl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Xenni usint-i-dd yessis n Ṣalufḥad, mmis n Ḥafar, mmis n Jilɛad, mmis n Makir, mmis n Manassa, inni iǧan n řaǧat n Manassa, mmis n Yusuf. Ina d ismawen n yessis: Maḥla, Nuɛa, Ḥujla, Milka d Tirṣa. ");
INSERT INTO rifl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Tuɣa beddent zzat i wudem n Musa u zzat i wudem n Aliɛazar, akehhan, u zzat i wudem n řḥukkam u zzat i wudem n marra tamesmunt ɣar wadaf n Uqiḍun n Umsagar, nnant: ");
INSERT INTO rifl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Babatneɣ immut di řexřa u war t tuɣi jar ubarru n yinni imunen ḍidd i SIDI, deg ubarru n Quraḥ war din t tuɣi netta, minzi immut di ddnub nnes u war ɣares tuɣi iḥenjiren.    ");
INSERT INTO rifl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Mayemmi ɣa ikkes isem n babatneɣ zi jar řaǧ nnes, ma minzi war ɣares tuɣi bu uḥenjir? Ewc aneɣ agřa di řwesṭ n aytmas n babatneɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa yiwi ddeɛwa nsent zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Aqa aya am mammec t nnant yessis n Ṣalufḥad. Ittxeṣṣa ad asent tewced tasɣart n řwart di  řwest n aytmas n babatsen uca ad xasent tesseɛdud řwart n babatsent. ");
INSERT INTO rifl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Uca ad tessiwřed ak-d ayt n Israil, ad tinid: ‘Mařa ca n yijjen immut břa mmis, xenni ad tesseɛdum řwart nnes ɣar yeǧis, ");
INSERT INTO rifl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","u mařa war ɣares yeǧis, ad tewcem řwart nnes i yaytmas. ");
INSERT INTO rifl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Mařa war ɣares aytmas ɛawed, ad tewcem řwart nnes i yaytmas n babas. ");
INSERT INTO rifl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Mařa babas war ɣares aytmas ɛawed, ad tewcem řwart nnes i raǧ nnes, i wenni i d as dd-yudsen zi řaǧ nnes, ḥima ad tt iwart netta.’ Man aya ad tiři d ict n tewṣeyyet n uzerf i řebda i ayt n Israil, am mammec t yumur SIDI i Musa.” ");
INSERT INTO rifl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Xenni inna SIDI i Musa: “Geɛɛed-dd adrar-a Abarim uca xzar tammurt nni wciɣ i ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Xmi tt ɣa tẓared, ad tᵉmmarnid ɣar řgens nnec, uřa d cek, am mammec uřa d umac Harun immarni ɣar řgens nnes, ");
INSERT INTO rifl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","minzi kenniw tɣewwɣem zzat i tiṭṭawin nsen ḍidd i řumur inu maḥend ad ayi tessqeddsem di řexřa n Ṣin, řami din tuɣa amcubbec di tmesmunt. Aqa d ina d aman n Mariba, ɣar Qadac di řexřa n Ṣin.” ");
INSERT INTO rifl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Issiweř Musa ak-d SIDI, inna: ");
INSERT INTO rifl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ad igg SIDI, AREBBI n buḥbeřat n marra ddat, aḥeṭṭu x tmesmunt deg ufus n ijj n weryaz, ");
INSERT INTO rifl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ḥima netta ad iffeɣ zzat i wudem nsen uca ad yadef zzat i wudem nsen uca ad ten indeh ɣar barra, ad ten issidef ɣar daxeř, maḥend tamesmunt n SIDI war tᵉttiři am wuǧi břa ameksaw.”    ");
INSERT INTO rifl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Xenni inna SIDI i Musa: “Ksi Yacuwa, mmis n Nun, ijj n weryaz i di iǧa Arruḥ, uca sars xas afus nnec ");
INSERT INTO rifl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","uca ad t tegged zzat i wudem n ukehhan Aliɛazar u zzat i marra tamesmunt, ad as tewced řumur zzat i tiṭṭawin nsen. ");
INSERT INTO rifl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ewc as ca zeg uweqqar nnec ḥima ad as tseř marra tamesmunt n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Netta ad ibedd zzat i ukehhan Aliɛazar, wenni i ɣa icawar zzat i wudem n SIDI ɛlaḥsab řeḥkam n Urim. X řumur nnes ad dd-ffɣen ɣar barra u x řumur nnes ad adfen ɣar daxeř, netta d marra ayt n Israil uřa d marra tamesmunt.” ");
INSERT INTO rifl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Uca Musa igga am mammec d as yumur SIDI. Yiwi Yacuwa uca issbedd i-t zzat i ukehhan Aliɛazar u zzat i wudem n marra tamesmunt. ");
INSERT INTO rifl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Issars xas ifassen nnes uca isseɛdu as řumur am mammec d as inna SIDI s tsexxart n Musa. ");
INSERT INTO rifl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Umur ayt n Israil, ini asen: ‘Ittxeṣṣa kenniw ad teḥḍam x tɣarṣṭ inu, macca inu i tewhibin inu n tmessi, ict n řefwaḥet ittfuḥen i Necc, maḥend ad ayi tent tqeddmem di řweqt nnes ittwaggen.’ ");
INSERT INTO rifl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ad asen tinid: ‘Aqa ta d tawhibt n tmessi i ittxeṣṣan ad tqeddmem: tnayen n izmaren icnan n ijj n useggʷas, am tɣarṣt n wecmaḍ řebda. ");
INSERT INTO rifl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ijj n izmar ad t tesswejded di ṣṣbeḥ uca izmar nneɣni ad t tesswejded jar beddu n wezyen n wass ař dd-tewḍa tmeddit ");
INSERT INTO rifl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","uca ak-d man aya am tewhibt n řɣiǧet ict n teɛcart n yijj n ifa n waren azdad ixeǧḍen s yijj n arbeɛ n ijj n uhinu n zzect, ttwaddzen t-i-dd zi zzitun. ");
INSERT INTO rifl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Aqa-tt d taɣarṣṭ n wecmaḍ n řebda, tenni tuɣa ittwaggen deg wedrar n Sina am yict n řefwaḥet ittfuḥen, aqa-tt d ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Tawhibt nnes n useyyeb ad tiři d ijj n arbeɛ n ijj n uhinu i yijj n izmar. Seyyeb tawhibt n useyyeb n ccrab di Zzawect Iqeddsen zzat i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ad tesswejded izmar nneɣni jar beddu n wezyen n wass ař dd-tewḍa tmeddit. Ad t tesswejded am mammec tesswejded tawhibt n řɣiǧet di ṣṣbeḥ u am mammec tesswejded tawhibt n useyyeb nnes, am ict n tewhibt n tmessi, ict n řefwaḥet ittfuḥen i SIDI.’” ");
INSERT INTO rifl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Deg wass n ssebt ad tesswejded tnayen n izmaren icnan n ijj n useggʷas d tnayen n teɛcurin n yijj n ifa n waren azdad am tewhibt n řɣiǧet ixeǧḍen s zzect ak-d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Aqa-tt d taɣarṣṭ n wecmaḍ n ssebt i mkuř ssebt, ad tt tarnid i tɣarṣt n wecmaḍ n řebda d tewhibt nnes n useyyeb.” ");
INSERT INTO rifl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Deg umezwar n kuř ijj n iyuren nwem ittxeṣṣa ad tqeddmem ict n tɣarṣt n wecmaḍ i SIDI: tnayen n ifunasen - imeẓyanen n ict n tfunast - ijj n icarri, sebɛa n izmaren icnan qaɛ n ijj n useggʷas ");
INSERT INTO rifl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","uca ak-d man aya třata n teɛcurin n ijj n ifa n waren azdad am tewhibt n řɣiǧet ixeǧḍen s zzect i yijj n ufunas ameẓyan u tnayen n teɛcurin n yijj n ifa n waren azdad am tewhibt n řɣiǧet ixeǧḍen s zzect i yijj n icarri ");
INSERT INTO rifl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","uca arni ict n teɛcart n yijj n ifa n waren azdad am tewhibt n řɣiǧet ixeǧḍen s zzect i yijj n izmar. Aqa-tt d taɣarṣt n wecmaḍ s ict n řefwaḥet ittfuḥen, aqa-tt d ict n tewhibt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Tiwhibin nsen n useyyeb ad iřint d azyen n uhinu n binu ak-d ufunas ameẓyan d ict n ttuřut n ijj n uhinu ak-d icarri d yijj n arbeɛ n ijj n uhinu ak-d izmar. Ta d taɣarṣt n wecmaḍ n kuř ayur, i kuř ayur zeg iyuren n useggʷas. ");
INSERT INTO rifl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ittxeṣṣa ad tesswejded ijj n umyan zeg iɣayḍen d taɣarṣt n ddenb i SIDI, ad tt tarnid i tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n useyyeb.” ");
INSERT INTO rifl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Deg uyur amezwaru, deg wass wiss arbeɛṭac n uyur, ad tiři Tɣarṣt n Useɛdu n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Deg wass wiss xemmesṭac n simant n uyur ad yiři Řɛid. Sebɛa n wussan ad ccen aɣrum břa antun. ");
INSERT INTO rifl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Deg wass amezwaru n Řɛid ad yiři yijj n umuni iqeddsen. War tteggem uřa d ict řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ad tqeddmem ict n tewhibt n tmessi am tɣarṣt n wecmaḍ i SIDI: tnayen n ifunasen imeẓyanen d ijj n icarri d sebɛa n izmaren n ijj n useggʷas. Ittxeṣṣa ad iřin cnan qaɛ. ");
INSERT INTO rifl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ad tiři tewhibt n řɣiǧet n waren azdad ixeǧḍen s zzect. Ad zzayes tesswejdem třata n teɛcurin n yijj n ifa i yijj n ufunas ameẓyan d tnayen n teɛcurin n yijj n ifa i yijj n icarri. ");
INSERT INTO rifl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Ad tesswejded ict n teɛcart n yijj n ifa i yijj n izmar, uca ammu i marra sebɛa n izmaren nni. ");
INSERT INTO rifl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Sewjed ɛawed ijj n umyan zeg iɣayḍen d taɣarṣt n ddenb maḥend ad ittwagg weṣřaḥ i kenniw. ");
INSERT INTO rifl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ad tesswejdem man aya sennej i usewjed n tɣarṣt wecmaḍ di ṣṣbeḥ nni iǧan d ict n tɣarṣt n wecmaḍ i řebda. ");
INSERT INTO rifl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Am mammec uya ad tesswejdem macca n tewhibin n tmessi sebɛa n wussan, di kuř ass zzaysen, am ict n řefwaḥet ittfuḥen i SIDI. Ad ittwassewjed sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Deg wass wiss sebɛa ad teggem ijj n umuni iqeddsen. War tteggem uřa d ict řxedmet i ittxeṣṣan ad tᵉttwagg.” ");
INSERT INTO rifl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Deg wass n tmenzut n ṣṣabet di Řɛid n Ssimanat, xmi dd ɣa tqeddmem ict n tewhibt n řɣiǧet n jdid ɣar SIDI, ad teggem ijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ad tqeddmem ict n tɣarṣt n wecmaḍ am yict n řefwaḥet ittfuḥen i SIDI: tnayen n ifunasen imeẓyanen i yijj n icarri d sebɛa n izmaren n ijj n useggʷas ");
INSERT INTO rifl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ak-d tewhibt nnes n řɣiǧet n waren azdad ixeǧḍen s zzect: třata n teɛcurin n yijj n ifa i yijj n ufunas ameẓyan d tnayen n teɛcurin n yijj n ifa i yijj n icarri ");
INSERT INTO rifl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","uřa d ict n teɛcart n yijj n ifa i kuř izmar, uca ammu i marra sebɛa n izmaren nni. ");
INSERT INTO rifl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb maḥend ad ittwagg weṣřaḥ i kenniw. ");
INSERT INTO rifl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ad ten tesswejdem sennej i usewjed n tɣarṣt n wecmaḍ n řebda d tewhibt nnes n řɣiǧet. Ad iřin cnan qaɛ i kenniw ak-d tewhibin nsen n useyyeb.” ");
INSERT INTO rifl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Deg uyur wiss sebɛa, deg wass amezwaru n uyur, ad teggem ijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. Ad awem yiři d ijj n wass n usuḍi s wesruddeḥ deg uyicc n icarri. ");
INSERT INTO rifl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ad tesswejdem ict n tɣarṣt n wecmaḍ am yict n řefwaḥet ittfuḥen i SIDI: ijj n ufunas - ameẓyan n ict n tfunast - d yijj n icarri d sebɛa n izmaren icnan qaɛ n ijj n useggʷas ");
INSERT INTO rifl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ak-d tewhibt nsen n řɣiǧet zeg waren azdad ixeǧḍen s zzect: třata n teɛcurin n yijj n ifa i ufunas ameẓyan d tnayen n teɛcurin n yijj n ifa i icarri ");
INSERT INTO rifl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ak-d ict n teɛcart n yijj n ifa i kuř izmar, uca ammu i sebɛa n izmaren marra. ");
INSERT INTO rifl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb maḥend ad ittwagg weṣřaḥ i kenniw. ");
INSERT INTO rifl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","sennej i usewjed n tɣarṣt n wecmaḍ ak-d tewhibt nnes n řɣiǧet d sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibin nsen n useyyeb, ɛlaḥsab lfariḍa nsent, am yict n řefwaḥet ittfuḥen, ict n tɣarṣt n tmessi i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Deg wass wiss ɛecra ad teggem ijj n umuni iqeddsen uca ad tesswaḍɛem ixef nwem. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Ad tqeddmem ict n tɣarṣt n wecmaḍ am yict n řefwaḥet ittfuḥen i SIDI: ijj n ufunas ameẓyan d yijj n icarri d sebɛa n izmaren icnan qaɛ n ijj n useggʷas. Ittxeṣṣa ad awem iřin cnan aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ɛawed tawhibt nsen n řɣiǧet n waren azdad ixeǧḍen s zzect: třata n teɛcurin n yijj n ifa i yijj n ufunas ameẓyan, tnayen n teɛcurin n yijj n ifa i yijj n icarri ");
INSERT INTO rifl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","u ict n teɛcart n yijj n ifa i kuř izmar, uca ammu i sebɛa n izmaren marra. ");
INSERT INTO rifl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n ddenb i zi tᵉttwagg weṣřaḥ uca uřa d taɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibin nsen n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Deg wass wiss xemmesṭac n uyur wiss sebɛa ad teggem ijj n umuni iqeddsen. War tteggem uřa d ict n řxedmet i ittxeṣṣan ad tᵉttwagg. Sebɛa n wussan ad tɛeyydem řɛid i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ad tqeddmem ict n tɣarṣt n wecmaḍ am tewhibt n tmessi, am ict n řefwaḥet ittfuḥen i SIDI: třeṭṭac n ifunasen - imeẓyanen n ict n tfunast - tnayen n icarriyyen u arbeɛṭac n izmaren n ijj n useggʷas. Ittxeṣṣa ad iřin cnan qaɛ. ");
INSERT INTO rifl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Ɛawed tawhibt nsen n řɣiǧet n waren azdad ixeǧḍen s zzect: třata n teɛcurin n yijj n ifa i yijj n ufunas ameẓyan, i marra třeṭṭac n ifunasen imeẓyanen, u tnayen n teɛcurin n yijj n ifa i yijj n ucarri, i tnayen n icarriyyen nni ");
INSERT INTO rifl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","uřa d ict n teɛcart n yijj n ifa i kuř izmar, uca ammu i marra arbeɛṭac n izmaren nni. ");
INSERT INTO rifl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Swejdem ɛawed ijj n ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Deg wass wiss tnayen: tenɛac n ifunasen imeẓyanen d tnayen n icarriyyen d arbeɛṭac n izmaren icnan n ijj n useggʷas, ");
INSERT INTO rifl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ifunasen imeẓyanen, i icarriyyen u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibin nsen n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Deg wass wiss třata: ḥiṭac n ifunasen imeẓyanen d tnayen n icarriyyen d arbeɛṭac n izmaren n ijj n useggʷas, ican qaɛ, ");
INSERT INTO rifl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ifunasen imeẓyanen, i icarriyyen u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Deg wass wiss arebɛa: ɛecra n ifunasen imeẓyanen d tnayen n icarriyyen d arbeɛṭac n izmaren icnan n ijj n useggʷas, ");
INSERT INTO rifl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ifunasen imeẓyanen, i icarriyyen u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Deg wass wiss xemsa: tesɛa n ifunasen imeẓyanen d tnayen n icarriyyen d arbeɛṭac n izmaren icnan n ijj n useggʷas, ");
INSERT INTO rifl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ifunasen imeẓyanen, i icarriyyen u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Deg wass wiss setta: tmenya n ifunasen imeẓyanen d tnayen n icarriyyen d arbeɛṭac n izmaren icnan n ijj n useggʷas, ");
INSERT INTO rifl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ifunasen imeẓyanen, i icarriyyen u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibin nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Deg wass wiss sebɛa: sebɛa n ifunasen imeẓyanen d tnayen n icarriyyen d arbeɛṭac n izmaren icnan n ijj n useggʷas, ");
INSERT INTO rifl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ifunasen imeẓyanen, i icarriyyen u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Deg wass wiss tmenya ad teggem ijj n umuni ifarzen. War tteggem uřa d ict řxedmet i ittxeṣṣan ad tᵉttwagg. ");
INSERT INTO rifl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ad tqeddmem ict n tɣarṣt n wecmaḍ am tewhibt n tmessi, am ict n řefwaḥet ittfuḥen i SIDI: ijj n ufunas ameẓyan d yijj n icarri d sebɛa n izmaren icnan n ijj n useggʷas ");
INSERT INTO rifl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ak-d tewhibt nsen n řɣiǧet d tewhibin nsen n useyyeb i ufunas ameẓyan, i icarri u i izmaren, ɛlaḥsab řqedd nsen, ɛlaḥsab lfariḍa. ");
INSERT INTO rifl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Swejdem ɛawed ijj n umyan zeg iɣayḍen am tɣarṣt n ddenb, sennej i usewjed n tɣarṣt n wecmaḍ n řebda ak-d tewhibt nnes n řɣiǧet d tewhibt nnes n useyyeb. ");
INSERT INTO rifl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ad teggem timesřayin-a i SIDI di řeɛyudat nwem ittwaggen sennej i tewhibin n řewɛud nwem d tewhibin nwem s řxaḍar i ittraḥen ak-d tɣarṣa n wecmaḍ nwem d tewhibin nwem n řɣiǧet d tewhibin nwem n useyyeb d tewhibin nwem n řehna.” ");
INSERT INTO rifl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Uca issiweř Musa ak-d ayt n Israil ɛlaḥsab marra min yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Issiweř Musa ak-d izeǧifen n tqebbař n ayt n Israil, inna: “Aqa d ta min xef yumur SIDI: ");
INSERT INTO rifl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","‘Xmi ɣa tafed ijj n weryaz iwca awař niɣ ijjuǧ ict n tjaǧit ḥima ad iqqen ixef nnes s yijj n řɛahd, xenni war ittareẓẓi awař nnes. Ittxeṣṣa as ad igg ɛlaḥsab min dd-iffɣen zeg uqemmum nnes. ");
INSERT INTO rifl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Xmi ɣa tafed ict n temɣart tewca awař nnes i SIDI uca ad teqqen ixef nnes s yijj n řɛahd di temẓi nnes di taddart n babas, ");
INSERT INTO rifl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","uca babas isřa i wawař n lwaɛd nnes d řɛahd nnes i zi teqqen ixef nnes, uca babas isqar zzates, xenni marra lwuɛud nnes ad iřin ṣeřḥen d kuř aqqan nnes ad yiři iṣřeḥ. ");
INSERT INTO rifl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Maca mařa babas issbedd i-tt zi man aya deg wass nni di isřa aya, xenni uřa d ijj zi lwuɛud nnes u uřa d ijj zeg waqqan nnes i zi teqqen ixef nnes, war iṣeǧeḥ ca. SIDI ad as iɣfar, minzi babas issbedd i-tt x man aya. ");
INSERT INTO rifl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Mařa tuɣa-tt temřec ak-d yijj n weryaz uca xas lwuɛud niɣ nettat tuɣa teqqen ixef nnes s yijj n wawař iffeɣ-dd s tcarfayeḥ zeg iyencicen nnes, ");
INSERT INTO rifl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","uca aryaz nnes isřa as uca isqar zzates deg wass i di isřa aya, xenni ad seřḥen lwuɛud nnes d kuř aqqan nnes ad yiři iṣřeḥ. ");
INSERT INTO rifl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Maca mařa aryaz nnes deg wass nni di isřa aya, inhar i-tt, xenni netta issebḍeř lwaɛd nni xas uřa d awař s tcarfayeḥ zeg iyencicen nnes i zi tuɣa teqqen ixef nnes uca AREBBI ad as iɣfar aya.’” ");
INSERT INTO rifl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“X lwaɛd n tajjač niɣ n tenni ittwaǧfen: marra min zi tuɣa teqqen ixef nnes, ad yiři iṣeǧeḥ. ");
INSERT INTO rifl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Mařa tuɣa tewca awař niɣ teqqen ixef nnes s ict n tjaǧit i yijj n řɛahd di taddart n weryaz nnes, ");
INSERT INTO rifl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","uca aryaz nnes isřa i uya uca isqar zzates uca war tt issbedd x man aya, xenni ad ṣeřḥen marra lwuɛud nnes u kuř aqqan nnes i zi tuɣa teqqen ixef nnes ad yiři iṣřeḥ. ");
INSERT INTO rifl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Maca mařa aryaz nnes issebḍeř aya qaɛ deg wass i di isřa, xenni war ittiři iṣeǧeḥ ca qaɛ zi min dd-iffɣen zeg iyencicen nnes n lwuɛud niɣ n waqqan. Aryaz nnes issebḍeř aya uca AREBBI ad as iɣfar. ");
INSERT INTO rifl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Kuř lwaɛd d kuř aqqan s ict n tjaǧit i umi ɣa tesswaḍeɛ ixef nnes, aryaz nnes izemmar ad t issemten niɣ aryaz nnes izemmar ad t issebḍeř. ");
INSERT INTO rifl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mařa aryaz nnes isqar qaɛ zeg wass x wass, xenni issemten marra lwuɛud nnes niɣ kuř aqqan nnes i xas iǧan. Aqa issemten i-ten minzi isqar zzates deg wass i di ten isřa. ");
INSERT INTO rifl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Mařa netta, awarni řami d asen isřa, ad ten issebḍeř, xenni ad yarbu netta řmuɛṣiyyet n temɣart nnes.” ");
INSERT INTO rifl_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Aqa d tina d tiweṣṣa i zi yumur SIDI i Musa, i iǧan jar weryaz d temɣart, jar babas d yessis, tenni iqqimen di taddart n babas di temẓi nnes. ");
INSERT INTO rifl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Ntaqem di ṭṭweɛ n ayt n Israil x Imidyaniyyen. Awarni as ad tᵉmmarnid ɣar řgens nnec.” ");
INSERT INTO rifl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Issiweř Musa ak-d řgens, inna: “Swejdem zi ɣarwem iryazen i umenɣi ḍidd i Midyan u nitni ad iřin ḍidd i Midyan maḥend ad ssiwḍen nneqmet n SIDI x Midyan. ");
INSERT INTO rifl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Ittxeṣṣa awem ad tessekkem ařef n yeryazen zi kuř taqbič ɣar umenɣi, zi kuř ict zi marra tiqebbař n Israil.” ");
INSERT INTO rifl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ammu i ttwafarzen zi řuřuf n Israil ařef n yeryazen zi kuř taqbič, aqa aten jmiɛ tenɛac-n-řuřuf n yerazen iwejden i umenɣi. ");
INSERT INTO rifl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa issekk i-ten ɣar umenɣi, ařef n yeryazen zi kuř taqbič. Netta issekk i-ten ɣar umenɣi ak-d Finaḥas, mmis n ukehhan Aliɛazar, u netta ɣares řeqcuɛ iqeddsen d řebwaq i usuḍi s wesruddeḥ i umenɣi deg ufus nnes ");
INSERT INTO rifl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","uca mmenɣen ḍidd i Imidyaniyyen, am mammec t yumur SIDI i Musa uca nɣin marra min iǧan d awtem. ");
INSERT INTO rifl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Sennej i yinni zzaysen ittwassnuqqben, nɣin ɛawed ijeǧiden n Midyan: Iwi, Raqim, Ṣur, Ḥur d Rabaɛ, xemsa n ijeǧiden n Midyan, uřa Balɛam, mmis n Baɛur, nɣin t s ssif. ");
INSERT INTO rifl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ayt n Israil ḥebbsen timɣarin n Midyan d tarwa nsen, u keccḍen řebhayem nsen d tḥimriwin nsen d marra min ɣarsen. ");
INSERT INTO rifl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Sscemḍen s tmessi marra tineddam nsen mani tuɣa zeddɣen d marra lqelɛat nsen. ");
INSERT INTO rifl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ksin marra min keccḍen, marra takeccaḍt n iwdan d řebhayem ");
INSERT INTO rifl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","uca iwyen-dd imeḥbas d marra takeccaḍt ɣar Musa u ɣar ukehhan Aliɛazar u ɣar tmesmunt n ayt n Israil, di řmargeḥ n řɛeskar, di řewḍat n Mu’ab, ɣar L’Urdun, arendad n Ariḥa. ");
INSERT INTO rifl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Uca iffeɣ-dd Musa ak-d ukehhan Aliɛazar d marra řḥukkam n tmesmunt barra i řmargeḥ n řɛeskar maḥend ad ten mmsagaren. ");
INSERT INTO rifl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Iffugem Musa aṭṭas x imgewwaden n řɛeskar, x imeqqranen x wařef u x imeqqranen x mya, inni dd-iɛeqben zeg umenɣi. ");
INSERT INTO rifl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Inna asen Musa: “Ma tejjim marra min iǧan d tawtent iddar? ");
INSERT INTO rifl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Xzar, s wescan n Balɛam, timɣarin-a tuɣa atent d řesbab aqa ayt n Israil ɣdaren SIDI di tmesřact n Faɣur uca tewḍa-dd jjriḥect x tmesmunt n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Řexxu xenni, nɣem marra iwetman nni jar iḥenjiren imeẓyanen uca nɣem marra tamɣart nni imunen ak-d ijj n weryaz am tᵉṭṭeṣ nettat ak-d ijj n weryaz. ");
INSERT INTO rifl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Maca marra tiḥenjirin jar temɣarin nni war imunen ak-d ijj n weryaz am akides ṭṭṣent, jjem tent i yixef nwem ad ddarent. ");
INSERT INTO rifl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Ittxeṣṣa awem ad tewtem iqiḍan nwem barra i řmargeḥ n řɛeskar řmijař n sebɛa n wussan. Kuř ijjen, wenni inɣin ijj n řeɛmar n bnadem, u kuř ijjen, wenni iḥadan ijjen i ittwassnuqqben, ad yejj ad kksen ddenb x yixef nnes deg wass wiss třata u deg wass wis sebɛa, ammu i ɣa teggem kenniw uřa d imeḥbas nwem. ");
INSERT INTO rifl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Ittxeṣṣa ad tekksem ddenb ɛawed x marra arruḍ d marra řeqcuɛ n iřmawen d marra min ittwaggen s thiḍurt n iɣayḍ d marra řeqcuɛ n ukeccuḍ.” ");
INSERT INTO rifl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Aliɛazar, akehhan, inna i iɛeskariyyen nni dd-iffɣen ɣar umenɣi: “Ta d tawṣeyyet zi Ccariɛa nni yumur SIDI i Musa: ");
INSERT INTO rifl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Mɣir ureɣ d nnuqart d nnḥas d uzzař d istanyu d řexfif, ");
INSERT INTO rifl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","marra min izemmaren i tmessi, x tmessi ad t tessekkem, xenni ad yiři izdig, maca ittxeṣṣa ad zzayes tekksem ddenb s waman n weɛzař. Marra min war izemmaren i tmessi, ad t tessekkem x waman. ");
INSERT INTO rifl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Deg wass wiss sebɛa ad tṣebbnem arruḍ nwem, xenni ad tiřim d imezdagen. Awarni uya tzemmarem ad tadfem ɣar řmargeḥ n řɛeskar.” ");
INSERT INTO rifl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ṭṭef řeɛbar n tkeccaḍt n iwdan d řebhayem nni tᵉttwaḥebbes, cek jmiɛ ak-d ukehhan Aliɛazar u ak-d izeǧifen n tudrin n ibabaten n tmesmunt. ");
INSERT INTO rifl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Bḍa takeccaḍt x tnayen jar inni icarcen deg umenɣi d yinni iffɣen ak-d řɛeskar zeg ict n jjihet d marra tamesmunt zi jjihet nneɣnit. ");
INSERT INTO rifl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Sgeɛɛdet ict n ṣṣedqet i SIDI zeg iɛeskariyyen nni dd-iffɣen ɣar umenɣi ak-d řɛeskar: ijj n řeɛmar zi xemsa mya n iwdan uca amenni zeg ifunasen d tfunasin u zeg iɣyař u zeg wuǧi. ");
INSERT INTO rifl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Zeg wezyen nsen n tkeccaḍt ad teksid ṣṣedqet-a uca ad tt tewced i ukehhan Aliɛazar am ict n tewhibt n usgeɛɛed i SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Zeg wezyen n tkeccaḍt n ayt n Israil ad teksid ijj zi kuř xemsin: zeg iwdan, zeg ifunasen d tfunasin, zeg iɣyař u zeg wuǧi, wah, zi marra řebhayem. Ad tewced aya i Ilawiyyen nni iṭṭfen acbar x Tzeddiɣt n SIDI.” ");
INSERT INTO rifl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Uca igga Musa d ukehhan Aliɛazar am mammec t yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Awarni as tuɣa řeksibet nni iqqimen n tkeccaḍt nni ikecceḍ řgens n řɛeskar setta-mya u-xemsa u-sebɛin-ařef n wuǧi. ");
INSERT INTO rifl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","tnayen u-sebɛin-ařef n ifunasen d tfunasin, ");
INSERT INTO rifl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","waḥit u-settin-ařef n iɣyař ");
INSERT INTO rifl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","uca zi jjihet n řeɛmar n bnadem, zi temɣarin nni war iṭṭiṣen di qama ak-d ijj n weryaz, aqa atent marra tnayen u-třatin-ařef. ");
INSERT INTO rifl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ijj n wezyen, tasɣart n yinni dd-iffɣen ak-d řɛeskar, aqa-t di teřt-mya u-sebɛa u-třatin-ařef n wuǧi. ");
INSERT INTO rifl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Ṣṣedqet i SIDI n wuǧi tuɣa-tt di setta-mya u-xemsa u-sebɛin. ");
INSERT INTO rifl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Uca tuɣa din setta u-třatin-ařef n ifunasen d tfunasin uca ṣṣedqet zzaysen i SIDI tuɣa-tt di tnayen u-sebɛin. ");
INSERT INTO rifl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Uca tuɣa din třatin-ařef u-xemsa-mya n iɣyař uca ṣṣedqen zzaysen i SIDI, waḥit u-settin. ");
INSERT INTO rifl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Uca zi jjihet n řeɛmur n bnadem tuɣa din seṭṭac-ařef n temɣarin u aṣeddeq zzaysent i SIDI aqa tnayen u-třatin n temɣarin. ");
INSERT INTO rifl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Iwca Musa ṣṣedqet, tenni d tawhibt n usgeɛɛed i SIDI, i ukehhan Aliɛazar, am mammec t yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Zeg wezyen nneɣni i ayt n Israil, wenni ifarz Musa di ṭṭweɛ nsen zeg yeryazen nni tuɣa immenɣen, ");
INSERT INTO rifl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","- azyen nni n tesɣart i tmesmunt tuɣa-t di teřt-mya u-sebɛa u-třatin-ařef u-xemsa mya n wuǧi, ");
INSERT INTO rifl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","setta u-třatin-ařef n ifunasen d tfunasin, ");
INSERT INTO rifl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","třatin-ařef u-xemsa-mya n yeɣyař ");
INSERT INTO rifl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","uca seṭṭac-ařef n řeɛmur n iwdan - ");
INSERT INTO rifl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","zeg wezyen nni i ayt n Israil iksi Musa ijj zi kuř xemsin, ammu zeg iwdan am zi řebhayem, uca iwca aya i Ilawiyyen, inni iṭṭfen acbar x Tzeddiɣt n SIDI, am mammec t yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Xenni usin-dd ikumandaren x řuřuf n řɛeskar, imeqqranen x wařef d imeqqranen x mya, ɣar Musa, ");
INSERT INTO rifl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","nnan i Musa: “Imsexxaren nnec aqa ḥesben marra iɛeskariyyen nni sadu ufus nneɣ u war d aneɣ iruḥ uřa d ijj n weryaz. ");
INSERT INTO rifl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","S uya niwi tawhibt n SIDI, kuř ijj min yufa: ict n řqecɛet n wureɣ, ict n txeřxařt, ict n tmeqyast, ict n txatent n ucemmiɛ, ict n texrazt niɣ ict n tseddect s wedmam n wureɣ, ḥima ad zzaysent ittwagg weṣřaḥ x řeɛmur nneɣ zzat i wudem n SIDI.” ");
INSERT INTO rifl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa d ukehhan Aliɛazar ksin zzaysen ureɣ nsen, marra řeqcuɛ i ggin s lfenn. ");
INSERT INTO rifl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Marra ureɣ n tewhibt nni ssgeɛɛden i SIDI zeg imeqqranen x wařef u zeg imeqqranen x mya tuɣa di seṭṭac-ařef u-sebɛa-mya u-xemsin ciqlu. ");
INSERT INTO rifl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Iɛeskariyyen aqa keccḍen kuř ijj i yixef nnes min xsen. ");
INSERT INTO rifl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa d ukehhan Aliɛazar ṭṭfen ureɣ nni n imeqqranen x wařef u x mya uca iwyen t ɣar Uqiḍun n Umsagar, am yict n řidaret i ayt n Israil zzat i wuden n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ayt n Rubin ɣarsen aṭṭas n řebhayem u ayt n Jad ɣarsen aṭṭas s waṭṭas n řebhayem uca nitni ẓrin tammurt n Yaɛzir d temmurt n Jilɛad, uca xzar, jjihet nni tecna i řebhayem. ");
INSERT INTO rifl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Usin-dd ayt n Jad u ayt n Rubin, ssiwřen ak-d Musa d ukehhan Aliɛazar u ak-d řḥukkam n tmesmunt, nnan: ");
INSERT INTO rifl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ɛaṭarut, Dibun, Yaɛzir, Nimra, Ḥacbun, Aliɛala, Cabam, Nabu d Baɛun, ");
INSERT INTO rifl_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","tammurt nni x iɣřeb SIDI zzat i wudem n tmesmunt n Israil, aqa-tt d ict n temmurt tecna i řebhayem u neccin, imsexxaren nnec ɣarsen řebhayem.” ");
INSERT INTO rifl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Nnan: “Mařa nufa arḍa di tiṭṭawin nnec, ma zeɛma ad temmewc temmurt-a d agřa i imsexxaren nnec u war d aneɣ ttejji ad neẓwa L’Urdun.” ");
INSERT INTO rifl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Yarra-dd Musa x ayt n Jad u x ayt n Rubin: “Mařa aytmatwem ad dd-ffɣen ɣar garra, ma xenni kenniw ad teqqimem da? ");
INSERT INTO rifl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Mayemmi ɣa tessɛegzem uř n ayt n Israil maḥend war ẓekkʷin ɣar temmurt i d asen iwca SIDI? ");
INSERT INTO rifl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ammu i ggin řejdud nwem umi ten ssekkeɣ zi Qadac-Barniɛ ḥima xenni ad ẓaren tammurt. ");
INSERT INTO rifl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Iwḍen nitni ɣar teɣzurt n teɣzart n Ickul uca ẓrin tammurt uca qeřben uřawen n ayt n Israil, maḥend war ttidfen ca di temmurt i d asen iwca SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Deg wass nni yarɣa weɣḍab n SIDI uca ijjuǧ, inna: ");
INSERT INTO rifl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Iryazen nni dd-iffɣen zi Miṣra, zi ɛicrin iseggʷusa sennej, war ẓarren tammurt nni x jjuǧeɣ ad tt wceɣ i Ibrahim d Isḥaq d Yaɛqub, minzi nitni war d ayi ḍfaren nican, ");
INSERT INTO rifl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","mɣir Kalib, mmis n Yafunni, Aqinizi, d Yacuwa, mmis n Nun, minzi nitni ḍfaren nican i SIDI.’ ");
INSERT INTO rifl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Uca ammu yarɣa weɣdab n SIDI x Israil uca igga i-ten ad tellɛen di řexřa arebɛin n iseggʷusa, ařami ifna marra jjiř nni iggin řɣar di tiṭṭawin n SIDI, ");
INSERT INTO rifl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Uca xzar, kenniw tɣewwɣem am řejdud nwem, kenniw d ijj n ubarru n yeryazen d imednab, uca ammu i ɣa tarnim ɛad řḥaduq n weɣḍab n SIDI x Israil. ");
INSERT INTO rifl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Mařa tdewřem-dd kenniw zi ḍeffar nnes, Netta ad yejj řgens di řexřa ɛawed uca ammu i ɣa tejjem marra řgens aya ad ihellek.” ");
INSERT INTO rifl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Xenni qarrben-dd ɣares, nnan: “Ad nebna da řkuriyyat i wuǧi nneɣ u tineddam i iḥenjiren nneɣ, ");
INSERT INTO rifl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","maca neccin ad dd-neffeɣ newjed i umenɣi zzat i wudem n ayt n Israil s řesnaḥ nneɣ, ařami ten nessiweḍ ɣar wemcan nsen. Iḥenjiren nneɣ ad qqimen di tneddam ifaryen zi ssibbet n imezdaɣ n temmurt. ");
INSERT INTO rifl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","War nᵉddekkwiř ɣar tudrin nneɣ ař i ɣa temmewc tesɣart n řwart i kuř ijj zeg ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Minzi war nteṭṭef di řwart akidsen ɣar tma nneɣni n L’Urdun uřa ɣar zzat, minzi tasɣart i d aneɣ dd-ittasen aqa-tt ɣar tma-ya tanita n L’Urdun, ɣar ccarq.” ");
INSERT INTO rifl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Xenni inna asen Musa: “Mařa teggim ammu, mařa tesswejdem ixef nwem i umenɣi zzat i wudem n SIDI, ");
INSERT INTO rifl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","u kuř ijj, wenni isswejden ixef nnes i umenɣi, ad iẓwa L’Urdun zzat i wudem n SIDI, ař Netta ad yaẓẓeř x řɛedyan nnes zzat i wudem nnes zi tesɣart nsen n řwart, ");
INSERT INTO rifl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","u ad tiři temmurt tᵉttwaxḍeɛ zzat i wudem n SIDI, xenni iɛeddeř ad dd-tdewřem u ad tiřim tbeddem zzat i SIDI u zzat i Israil břa amarwas u ad tiři temmurt-a d agřa nwem zzat i wudem n SIDI. ");
INSERT INTO rifl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Maca mařa war teggim ammu, xenni aqa texḍam ḍidd i SIDI uca ad tessnem aqa ddenb nwem ad kenniw yaf. ");
INSERT INTO rifl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bnam tineddam i iḥenjiren nwem d řkuriyyat i wuǧi nwem uca ggem min dd-iffɣen zeg uqemmum nwem.” ");
INSERT INTO rifl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Xenni ssiwřen ayt n Jad d ayt n Rubin ak-d Musa, nnan: “Imsexxaren nnec ad ggen am mammec ten yumur sidi inu. ");
INSERT INTO rifl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Tarwa nneɣ, timɣarin nneɣ, řeksibet nneɣ d marra řebhayem nneɣ ad qqimen di tneddam n Jilɛad, ");
INSERT INTO rifl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","maca imsexxaren nnec ad ẓwan i umenɣi zzat i wudem n SIDI, marra inni isswejden ixef nsen i umenɣi, am mammec issiweř sidi inu.” ");
INSERT INTO rifl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Uca yumur xasen Musa i ukehhan Aliɛazar u i Yacuwa, mmis n Nun, u i izeǧifen n tudrin n ibabaten n tqebbař n ayt n Israil, ");
INSERT INTO rifl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","inna asen Musa: “Mařa ayt n Jad d ayt n Rubin ad kiwem ẓwan L’Urdun, kuř ijj wenni isswejden ixef nnes i umenɣi zzat i wudem n SIDI, u mařa xenni tammurt ad tiři tᵉttwaxḍeɛ zzat i wudem nwem, ad taf ad asen tewcem tammurt n Jilɛad d agřa. ");
INSERT INTO rifl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Maca mařa war kiwem ẓekkʷim wejden i umenɣi, xenni ad ṭṭfen agřa di řwesṭ nwem di temmurt n Kenɛan.” ");
INSERT INTO rifl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ayt n Jad d ayt n Rubin arrin-dd, nnan: “Am mammec issiweř SIDI ak-d imsexxaren nnec, ammu i ɣa negg. ");
INSERT INTO rifl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Neccin ad neẓwa ɣar temmurt n Kenɛan ad niři newjed i umenɣi zzat i wudem n SIDI, maca tasɣart nneɣ n řwart ad tiři ɣar tma-ya wanita n L’Urdun.” ");
INSERT INTO rifl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","U iwca asen Musa, i ayt n Jad u i ayt n Rubin u i wezyen n teqbič n Manassa, mmis n Yusuf, tageldit n Siḥun, ajeǧid n Imuriyyen, d tgeldit n Ɛuj, ajeǧid n Bacan, tammurt s tneddam nnes nni iǧan di jjwayeh nnes uřa d tineddam di temmurt i d as dd-innḍen. ");
INSERT INTO rifl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Ayt n Jad bnan Dibun, Ɛaṭarut, Ɛaruɛir, ");
INSERT INTO rifl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Ɛaṭrut-Cufan, Yaɛzir, Yujbaha, ");
INSERT INTO rifl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bayt-Nimra d Bayt-Haran, tineddam ifaryen d řkuriyyat i wuǧi. ");
INSERT INTO rifl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ayt n Rubin bnan Ḥacbun, Aliɛala, Qaryatayim, ");
INSERT INTO rifl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nabu, Baɛl-Maɛun, tenni zi ittwabeddeř isem nsen, d Sibma, uca řaɣan ismawen n tneddam i bnan ɛawed s yisem nneɣni. ");
INSERT INTO rifl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Ayt n Makir, mmis n Manassa, ruḥen ɣar Jilɛad uca ṭṭfen tt uca uẓẓřen x Imuriyyen nni din iǧan zi řwart nsen. ");
INSERT INTO rifl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Uca Musa iwca Jilɛad i Makir, mmis n Manassa, uca iruḥ netta ad izdeɣ din. ");
INSERT INTO rifl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Uca Ya’ir, mmis n Manassa, iruḥ uca iṭṭef dcurat nnes uca iřaɣa asent dcurat n Ya’ir. ");
INSERT INTO rifl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Amenni iruḥ Nubaḥ uca iṭṭef Qinat d tneddam i ɣares dd-iqqnen uca isemma as Nubaḥ s yisem nnes. ");
INSERT INTO rifl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ammu i ssmmuṭṭiyen ayt n Israil inni dd-iffɣen zi temmurt n Miṣra, zeg wemcan ɣar wemcan, am ttwasettfen nitni ɛlaḥsab tirbiɛin n řɛeskar nsen, s ufus n Musa d Harun. ");
INSERT INTO rifl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","X řumur n SIDI yura Musa imucan manis dd-ffɣen ak-d ireḥḥalen nsen. Ina d ireḥḥalen nsen ak-d imucan manis dd-ffɣen. ");
INSERT INTO rifl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Fesyen iqiḍan nsen, ffɣen zi Raɛamsis deg uyur amezwaru, deg wass wiss xemmesṭac n uyur amezwaru. Di ṣṣbeḥ, deɣya awarni i Tɣarṣt n Useɛdu ffɣen-dd ayt n Israil s yijj n ufus ittwassgeɛɛden zzat i tiṭṭawin n marra Imiṣriyyen, ");
INSERT INTO rifl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","umi tuɣa ceɣřen Imiṣriyyen neṭṭřen marra imenza nsen, inni iwta SIDI s řmewt jar asen. Ɛawed issiweḍ SIDI řeḥkam nnes x irebbiten nsen. ");
INSERT INTO rifl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Fesyen ayt n Israil iqiḍan nsen, ffɣen zi Raɛamsis uca wtin iqiḍan nsen di Sukkut. ");
INSERT INTO rifl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Fesyen iqiḍan nsen, ffɣen zi Sukkut uca wtin iqiḍan nsen di Itam ɣar tma n řexřa. ");
INSERT INTO rifl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Fesyen iqiḍan nsen, ffɣen zi Itam uca dewřen-dd ɣar Pi-Haḥirut nni iǧan arendad n Baɛl-Ṣafun uca wtin iqiḍan nsen zzat i wudem n Majdal. ");
INSERT INTO rifl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Fesyen iqiḍan nsen, ffɣen zi Pi-Haḥirut uca cukken di řwesṭ n řebḥar ɣar řexřa uca uyuren ticři n třata n wussan di řexřa n Itam, xenni wtin iqiḍan nsen di Mara. ");
INSERT INTO rifl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Fesyen iqiḍan nsen, ffɣen zi Mara uca iwḍen ɣar Ilim, mani iǧa tenɛac n iɣbaluten n waman d sebɛin n tcejjura n tini uca wtin iqiḍan nsen din. ");
INSERT INTO rifl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Fesyen iqiḍan nsen, ffɣen zi Ilim uca wtin iqiḍan nsen ɣar Řebḥar n Telga. ");
INSERT INTO rifl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Fesyen iqiḍan nsen, ffɣen zi Řebḥar n Telga uca wtin iqiḍan nsen di řexřa n Sin. ");
INSERT INTO rifl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Fesyen iqiḍan nsen, ffɣen zi řexřa n Sin uca wtin iqiḍan nsen di Dufqa. ");
INSERT INTO rifl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Fesyen iqiḍan nsen, ffɣen zi Dufqa uca wtin iqiḍan nsen di Aluc. ");
INSERT INTO rifl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Fesyen iqiḍan nsen, ffɣen zi Aluc uca wtin iqiḍan nsen di Rafidim, mani war yufi aman i řgens maḥend ad swen. ");
INSERT INTO rifl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Fesyen iqiḍan nsen, ffɣen zi Rafidim uca wtin iqiḍan nsen di řexřa n Sina. ");
INSERT INTO rifl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Fesyen iqiḍan nsen, ffɣen zi řexřa n Sina uca wtin iqiḍan nsen di Qabarut-Hata’awat. ");
INSERT INTO rifl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Fesyen iqiḍan nsen, ffɣen zi Qabarut-Hata’awat uca wtin iqiḍan nsen di Ḥaḍayrut. ");
INSERT INTO rifl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Fesyen iqiḍan nsen, ffɣen zi Ḥaḍayrut uca wtin iqiḍan nsen di Ritma. ");
INSERT INTO rifl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Fesyen iqiḍan nsen, ffɣen zi Ritma uca wtin iqiḍan nsen di Rimmun-Fariṣ. ");
INSERT INTO rifl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Fesyen iqiḍan nsen, ffɣen zi Rimmun-Fariṣ uca wtin iqiḍan nsen di Libna. ");
INSERT INTO rifl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Fesyen iqiḍan nsen, ffɣen zi Libna uca wtin iqiḍan nsen di Rissa. ");
INSERT INTO rifl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Fesyen iqiḍan nsen, ffɣen zi Rissa uca wtin iqiḍan nsen di Qihaylata. ");
INSERT INTO rifl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Fesyen iqiḍan nsen, ffɣen zi Qihaylata uca wtin iqiḍan nsen di wedrar n Cafar. ");
INSERT INTO rifl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Fesyen iqiḍan nsen, ffɣen zeg wedrar n Cafar uca wtin iqiḍan nsen di Ḥarada. ");
INSERT INTO rifl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Fesyen iqiḍan nsen, ffɣen zi Ḥarada uca wtin iqiḍan nsen di Maqhaylut. ");
INSERT INTO rifl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Fesyen iqiḍan nsen, ffɣen zi Maqhaylut uca wtin iqiḍan nsen di Taḥat. ");
INSERT INTO rifl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Fesyen iqiḍan nsen, ffɣen zi Taḥat uca wtin iqiḍan nsen di Taraḥ. ");
INSERT INTO rifl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Fesyen iqiḍan nsen, ffɣen zi Taraḥ uca wtin iqiḍan nsen di Mitqa. ");
INSERT INTO rifl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Fesyen iqiḍan nsen, ffɣen zi Mitqa uca wtin iqiḍan nsen di Ḥacmuna. ");
INSERT INTO rifl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Fesyen iqiḍan nsen, ffɣen zi Ḥacmuna uca wtin iqiḍan nsen di Musirut. ");
INSERT INTO rifl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Fesyen iqiḍan nsen, ffɣen zi Musirut uca wtin iqiḍan nsen di Bani-Yaɛqan. ");
INSERT INTO rifl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Fesyen iqiḍan nsen, ffɣen zi Bani-Yaɛqan uca wtin iqiḍan nsen di Ḥur-Jidjad. ");
INSERT INTO rifl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Fesyen iqiḍan nsen, ffɣen zi zi Hur-Jidjad uca wtin iqiḍan nsen di Yutbat. ");
INSERT INTO rifl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Fesyen iqiḍan nsen, ffɣen zi zi Yutbat uca wtin iqiḍan nsen di Ɛabruna. ");
INSERT INTO rifl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Fesyen iqiḍan nsen, ffɣen zi zi Ɛabruna uca wtin iqiḍan nsen di Ɛiṣyun-Jabar. ");
INSERT INTO rifl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Fesyen iqiḍan nsen, ffɣen zi zi Ɛiṣyun-Jabar uca uca wtin iqiḍan nsen di řexřa n Ṣin nni yeǧa Qadac. ");
INSERT INTO rifl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Fesyen iqiḍan nsen, ffɣen zi Qadac uca wtin iqiḍan nsen ɣar wedrar n Hur, ɣar tma n temmurt n Idum. ");
INSERT INTO rifl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Yuři ukehhan Harun adrar n Hur am mammec d as inna SIDI uca immut din deg useggʷas wiss arebɛin awarni i uffuɣ n ayt n Israil zi temmurt n Miṣra, deg uyur wiss xemsa, deg wass amezwaru n uyur. ");
INSERT INTO rifl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Tuɣa Harun ɣares mya u-třata u-ɛicrin n iseggʷusa umi immut deg wedrar n Hur. ");
INSERT INTO rifl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Uca Akenɛani, ajeǧid n Ɛarad, wenni tuɣa izeddɣen di ljanub n temmurt n Kenɛan, isřa s twasit n ayt n Israil. ");
INSERT INTO rifl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Fesyen iqiḍan nsen, ffɣen zeg wedrar n Hur uca wtin iqiḍan nsen di Ṣalmuna. ");
INSERT INTO rifl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Fesyen iqiḍan nsen, ffɣen zi Ṣalmuna uca wtin iqiḍan nsen di Funun. ");
INSERT INTO rifl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Fesyen iqiḍan nsen, ffɣen zi Funun uca wtin iqiḍan nsen di Ubut. ");
INSERT INTO rifl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Fesyen iqiḍan nsen, ffɣen zi Ubut uca wtin iqiḍan nsen di řxirbat n Ɛabarim di jjwayeh n weymir ak-d Mu’ab. ");
INSERT INTO rifl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Fesyen iqiḍan nsen, ffɣen zi řxirbat n Ɛabarim uca wtin iqiḍan nsen di Dibun-Jad. ");
INSERT INTO rifl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Fesyen iqiḍan nsen, ffɣen zi Dibun-Jad uca wtin iqiḍan nsen di Ɛalmun-Diblatayim. ");
INSERT INTO rifl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Fesyen iqiḍan nsen, ffɣen zi Ɛalmun-Diblatayim uca wtin iqiḍan nsen deg idurar n Ɛabarim zzat i wudem n wedrar n Nabu. ");
INSERT INTO rifl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Fesyen iqiḍan nsen, ffɣen zeg idurar n Ɛabarim uca wtin iqiḍan nsen di řewḍat n Mu’ab ɣar L’Urdun arendad i Ariḥa. ");
INSERT INTO rifl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Nitni wtin iqiḍan nsen ɣar L’Urdun zi Bayt-Yacimut ař Abal-Ciṭṭim di řewḍat n Mu’ab. ");
INSERT INTO rifl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Issiweř SIDI ak-d Musa di řewḍat n Mu’ab ɣar L’Urdun arendad n Ariḥa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Siweř ak-d ayt n Israil uca ini asen: ‘Xmi i ɣa teẓwam L’Urdun ɣar temmurt n Kenɛan, ");
INSERT INTO rifl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","xenni ittxeṣṣa kenniw ad tessuffɣem marra imezdaɣ n temmurt zzat i uɣembub nwem d marra řexyařat nsen ineqcen ad tent taredǧem. Ɛawed ittxeṣṣa kenniw ad tᵉteḥḥam marra řexyařat ifesyen nsen d marra řegɛudi nsen. ");
INSERT INTO rifl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Ad tᵉṭṭfem tammurt d řwart uca ad dayes tzedɣem, minzi Necc wciɣ awem tammurt nni d agřa. ");
INSERT INTO rifl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Ad tebḍam tammurt s tqedduḥt am řwart x řaǧat nwem. Wi ɣar iǧa aṭṭas, ad as tewcem aṭṭas, u wenni ɣar iǧa drus, ad as tewcem drus. Mani d as dd-tusa tqedduḥt, ad yiři nnes. Ɛlaḥsab tiqebbař n řejdud nwem ad twartem tasɣart nwem. ");
INSERT INTO rifl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Maca mařa kenniw war tessuffuɣem ca imezdaɣ n temmurt zzat i wudem nwem, xenni ad imsar aqa inni i ɣa tejjem ad qqimen, ad dewřen d isennanen di tiṭṭawin nwem d iwezwizen deg iɣezdisen nwem uca nitni ad kenniw ḥṣaren di temmurt nni mani tzeddɣem. ");
INSERT INTO rifl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Uca xenni ad imsar ad awem ggeɣ am mammec tuɣa xarrṣeɣ ad akidsen ggeɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Umur ayt n Israil uca ini asen: ‘Xmi ɣa tadfem tammurt n Kenɛan, xenni ta d tammurt i d awem ɣa yiřin d řwart, tammurt n Kenɛan ak-d iymiren nnes ad tiři ammu: ");
INSERT INTO rifl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Jjihet n ljanub ad ɣarwem tiři zi řexřa n Ṣin ař aymir n Idum uca aymir n ljanub ad ɣarwem yiři zi ṭṭarf aneggaru n Řebḥar Ameǧaḥ di ccarq ");
INSERT INTO rifl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","uca aymir ad imeyyeř zi ljanub ɣar Tsunta n Tɣarḍmiwin uca ad iɛdu ɣar Ṣin uca ṭṭrufa nnes ad dd-awḍen jjihet n ljanub n Qadac-Barniɛ uca ad iɛdu ɣar Ḥaṣar-Addar uca ad iẓwa ɣar Aṣmun. ");
INSERT INTO rifl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Ad inneḍ weymir zi Aṣmun ɣar Teɣzart n Miṣra uca ṭṭrufa nnes ad awḍen ař řebḥar. ");
INSERT INTO rifl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Uca aymir n řɣarb ad awem yiři Řebḥar Ameqqran. Wa ad awem yiři d aymir n řɣarb.” ");
INSERT INTO rifl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Wa ad awem yiři d aymir n ccamal: ad t tarcmem i yixef nwem zeg Řebḥar Ameqqran ař adrar n Hur. ");
INSERT INTO rifl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Zeg wedrar n Hur ad t tarcmem ař mani ɣa tawḍed ɣar Ḥamat uca ṭṭrufa n weymir ad awḍen ař Ṣadad. ");
INSERT INTO rifl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Ad yeɛdu weymir ař Zifrun uca ṭṭrufa nnes ad awḍen ař Ḥaṣar-Ɛinan. Wa ad awem yiři d aymir n ccamal. ");
INSERT INTO rifl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Ad tarcmem aymir nwem n ccarq zi Ḥaṣar-Ɛinan ɣar Cafam ");
INSERT INTO rifl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","uca ad dd-ihwa weymir zi Cfam ař Ribla, ccarq n Ɛayn. Xenni ad dd-ihwa weymir ɛad ktar uca ad imun ak-d tma n ccarq n Řebḥar n Kinnarat. ");
INSERT INTO rifl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Xenni ad dd-ihwa weymir ɣar L’Urdun uca ṭṭrufa nnes ad awḍen ař Řebḥar Ameǧaḥ. Ta ad awem tiři d tammurt ak-d iymiren nnes i d as dd-innḍen.” ");
INSERT INTO rifl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Uca Musa yumur ayt n Israil, inna: “Ta d tammurt nni i ɣa tebḍam jar awem s tqedduḥt, tenni x yumur SIDI ad temmewc i tesɛa n tqebbař u i wezyen n teqbič n Manassa. ");
INSERT INTO rifl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Minzi taqbič n ayt n Rubin tᵉttwasettef ɛlaḥsab taddart n ibabaten nsen u taqbič n Jad tᵉttwasettef ɛlaḥṣab taddart n ibabaten nsen, aqa nitni ṭṭfen ɛad tasɣart nsen, u azyen n teqbič n Manassa tᵉṭṭef uřa d nettat tasɣart nnes n řwart. ");
INSERT INTO rifl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Tnayen n tqebbař d wezyen aqa ṭṭfent řwart nsent ɣar ujemmaḍ n L’Urdun, zi Ariḥa ɣar ccarq ɣar manis dd-tneqqar tfuct.” ");
INSERT INTO rifl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Ina d ismawen n yeryazen inni i ɣa ibḍan tammurt jar awem: Akehhan Aliɛazar d Yacuwa, mmis n Nun. ");
INSERT INTO rifl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Ad teksim ɛawed ijj n řḥakem zi kuř taqbič maḥend ad tebḍam tammurt. ");
INSERT INTO rifl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ina d ismawen n yeryazen: i teqbič n Yahuda, Kalib, mmis n Yafunni ");
INSERT INTO rifl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","i teqbič n ayt n Cimɛun, Cimuwil, mmis n Ɛammihud, ");
INSERT INTO rifl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","i teqbič n Binyamin, Ilidad, mmis n Kaslun, ");
INSERT INTO rifl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","i teqbič n ayt n Dan, řḥakem Buqqi, mmis n Yujli, ");
INSERT INTO rifl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","i teqbič n ayt n Yusuf: i teqbič n ayt n Manassa, řḥakem Ḥanniyil, mmis n Ifud, ");
INSERT INTO rifl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","i teqbič n ayt n Ifrayim, řḥakem Qimuyil, mmis n Cifṭan, ");
INSERT INTO rifl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","i teqbič n ayt n Zabulun, řḥakem Iliṣafan, mmis n Farnax, ");
INSERT INTO rifl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","i teqbič n ayt n Issakar, řḥakem Falṭiyil, mmis n Ɛazzan, ");
INSERT INTO rifl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","i teqbič n ayt n Acir, řḥakem Axihud, mmis n Calumi, ");
INSERT INTO rifl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","i teqbič n ayt n Naftali, řḥakem Fadahyil, mmis n Ɛammihud.” ");
INSERT INTO rifl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ina d inni x yumur SIDI ad bḍan řwart i ayt n Israil di temmurt n Kenɛan. ");
INSERT INTO rifl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Issiweř SIDI ak-d Musa di řewḍat n Mu’ab ɣar L’Urdun arendad n Ariḥa uca inna: ");
INSERT INTO rifl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Umur ayt n Israil ḥima ad wcen, zi řwart nsen i ṭṭfen, tineddam i Ilawiyyen maḥend ad daysent zedɣen. Ad tewcem i Ilawiyyen ɛawed ddmani n tarewsa, inni d asen dd-innḍen i tneddam. ");
INSERT INTO rifl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Tineddam-a ad iřint maḥend ad daysent zedɣen, uca ddmani n tarewsa ad iřin i řebhayem nsen u i wagřa nsen u i marra imuddaren nsen. ");
INSERT INTO rifl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Uca ddmani n tarewsa i iǧan ɣar tneddam nni i ɣa tewcem i Ilawiyyen, ad iřin zeg weɣbar n tendint ɣar barra ařef n iɣaǧen uca amenni ɣar marra iɣezdisen nnes. ");
INSERT INTO rifl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Barra n tendint ɣar ccarq ad tɛebbarem ařfayen n iɣaǧen u ɣar ljanub ařfayen n iɣaǧen u ɣar řɣarb ařfayen n iɣaǧen u ɣar ccamal ařfayen n iɣaǧen uca tandint ad tiři di řwesṭ. Ina ad asen iřin d ddmani n tarewsa n tneddam. ");
INSERT INTO rifl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Tineddam i ɣa tewcem i Ilawiyyen ad iřint setta n tneddam n tarewřa. Ad tent tewcem maḥend ad din yarweř uqettař. Sennej i man aya ad tent tewcem ɛad tnayen u-rebɛin n tneddam. ");
INSERT INTO rifl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Marra tineddam i ɣa tewcem i Ilawiyyen, ad iřint tmenya u-rebɛin n tneddam, tina simant nsent d ddmani nsent n tarewsa. ");
INSERT INTO rifl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","X tneddam i ɣa tewcem zeg wagřa n ayt n Israil, ad tent teksim ktar zeg wenni ɣar iǧa waṭṭas u zeg wenni ɣar iǧa drus, ad teksid drus. Kuř ijj ad iwc zi tneddam nnes i Ilawiyyen ɛlaḥsab řqedd n tesɣart nnes zi řwart i iṭṭef.” ");
INSERT INTO rifl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Issiweř SIDI ak-d Musa, inna: ");
INSERT INTO rifl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Siweř ak-d ayt n Israil uca ini asen: ‘Xmi ɣa teẓwam L’Urdun ɣar temmurt n Kenɛan, ");
INSERT INTO rifl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ad tneyycem i yixef nwem tineddam nni d awem i ɣa iřint d tineddam n tarewřa, ḥima aqettař, wenni inɣin ḥed zeg uweddar, izemmar ad din yarweř. ");
INSERT INTO rifl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Tineddam-a ad awem iřint i tarewřa zeg uneqqam n idammen, ḥima war ittmetti uqettař qbeř ma ad ibedd zzat i wudem n tmesmunt i řḥukm. ");
INSERT INTO rifl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Zi tneddam i ɣa tewcem, ad zzaysent iřint setta d tineddam n tarewřa i kenniw. ");
INSERT INTO rifl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Třata n tneddam ad tent tewcem ɣar ujemmaḍ n L’Urdun u třata n tneddam ad tent tewcem di temmurt n Kenɛan. Ad iřint d tineddam n tarewřa. ");
INSERT INTO rifl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Setta n tneddam-a ad iřint i tarewřa i ayt n Israil uřa i ubarrani d umɛezzeb di řwesṭ nsen, ḥima wenni inɣin ḥed zeg uweddar, izemmar ad din yarweř. ");
INSERT INTO rifl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Mařa iwwet i-t s ict n řqecɛet n wuzzař uca immut, xenni aqa netta d aqettař. Aqettař ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Mařa iwwet i-t s ijj n weẓru deg ufus i zi izemmar ad immet uca xenni immut, aqa netta d aneqqam. Aneqqam ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Niɣ mařa iwwet i-t s ict n řqecɛet n ukeccuḍ deg ufus i zi izemmar ad immet uca xenni immut, aqa netta d aqettař. Aqettař ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Aneqqam n idammen ad ineɣ aqettař. Mařa ad t iřqa, ad t ineɣ. ");
INSERT INTO rifl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","U mařa iɛarn i-t s wecrah, niɣ inḍar ɣares ca s neɛmada ařami zzayes immut, ");
INSERT INTO rifl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","niɣ iwwet i-t s řeɛdawet s ufus nnes, ařami zzayes immut, xenni wenni t inɣin ad ittwaneɣ nican. Aqa-t d aqettař. Aneqqam n idammen ad ineɣ aqettař xmi t ɣa iřqa. ");
INSERT INTO rifl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Maca mařa tuɣa iɛarren i-t amenni deg wermac n wabřiwen břa řeɛdawet, niɣ inḍar ɣares ca n řqecɛet am iweddar, ");
INSERT INTO rifl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","niɣ am war t iẓri, igga ad xas dd-iwḍa ca n weẓru i zi izemmar ad immet, uca xenni immut am war tuɣi d řeɛdu nnes u netta tuɣa war d as yarezzu řɣar, ");
INSERT INTO rifl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","xenni tamesmunt ad teḥkem jar uqettař d uneqqam n idammen ɛlaḥsab lfarayiḍ-a. ");
INSERT INTO rifl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Tamesmunt ad tfekk aqettař zeg ufus n uneqqam n idammen uca tamesmunt ad tejj netta ad iɛqeb ɣar tendint nnes n tarewřa. Ad din iqqim ař řmewt n arrays n ikehhanen, wenni dehnen nitni s zzect iqeddsen. ");
INSERT INTO rifl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Maca mařa aqettař iffeɣ barra n iymiren n tendint n tarewřa mani yarweř, ");
INSERT INTO rifl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","uca aneqqam n idammen yufa i-t barra n iymiren n tendint n tarewřa uca aneqqam n idammen inɣa wenni inɣin, war xas ca idammen xenni. ");
INSERT INTO rifl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Minzi tuɣa xas ad iqqim di tendint nnes n tarewřa ař řmewt n arrays n ikehhanen. Maca awarni řmewt n arrays n ikehhanen izemmar ad iɛqeb uqettař ɣar temmurt nni iǧan nnes. ");
INSERT INTO rifl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Aya ad awem tiři d tawṣeyyet n řḥeqq i marra jjiřat nwem mani ma ɣa tzedɣem. ");
INSERT INTO rifl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Kuř ijj, wenni inɣin ḥed, aqa aqettař ad ittwaneɣ ɛlaḥsab aqemmum n řechud, maca ijj n ucehhad waha, war izemmar ad iched x ict n nnefs s řmewt. ");
INSERT INTO rifl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","War kessim ddeyyet x řeɛmar n uqettař nni x ittwaḥkem s řmewt, maɣar ittxeṣṣa ad ittwaneɣ nican. ");
INSERT INTO rifl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","War kessim ddeyyet x wenni yarewřen ɣar tendint nnes n tarewřa di ṭṭweɛ n weɛqab nnes, maḥend ad izdeɣ di temmurt qbeř řmewt n arrays n ikehhanen. ");
INSERT INTO rifl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","War iɛeddeř ad tessexsarem tammurt mani teǧam, minzi idammen ssexsaran tammurt uca war izemmar ad ittwagg weṣřaḥ i temmurt di ṭṭweɛ n idammen i dayes ittwassizřen, mɣir s idammen n wenni ten issizzřen. ");
INSERT INTO rifl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","War sxemmijem tammurt mani ɣa tzedɣem kenniw, di řwesṭ nnes i ɣa zedɣeɣ Necc, minzi Necc d SIDI, wenni izeddɣen di řwesṭ n ayt n Israil.” ");
INSERT INTO rifl_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Zi řaǧat n iḥenjiren n Yusuf qarrben-dd izeǧifen jar ibabaten n řaǧ n iḥenjiren n Jilɛad, mmis n Makir, mmis n Manassa uca nitni ssiwřen zzat i wudem n Musa u zzat i wudem n řḥukkam, izeǧifen nneɣni x ibabaten n řaǧat n ayt n Israil ");
INSERT INTO rifl_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","uca nitni nnan: “SIDI yumur sidi inu maḥend ad iwc tammurt s tqedduḥt i ayt n Israil d řwart. Uca yumur SIDI i sidi inu ad iwc tasɣart n řwart n umatneɣ Ṣalufḥad i yessis. ");
INSERT INTO rifl_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Mařa dewřent nitenti d tinemřač ak-d ijjen zeg iḥenjiren n tqebbař nneɣni n ayt n Israil, xenni ad tᵉttwakkes tesɣart nsent di řwart n řejdud nneɣ uca ad tᵉttwarni tasɣart nsent i tesɣart n teqbič i ɣar ɣa munent uca ammu ad ittwassemẓi min iǧan d tasɣart nneɣ s tqedduḥt. ");
INSERT INTO rifl_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Xmi dd ɣa yas useggʷas n usřiwřew i ayt n Israil, xenni ad tᵉttwamarni tesɣart nsent i tesɣart n teqbič ak-d wi ɣa munent. Ammu i ɣa tᵉttwakkes xenni tesɣart nsent di řwart n teqbič n řejdud nneɣ.” ");
INSERT INTO rifl_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Xenni yumur Musa i ayt n Israil ɛlaḥsab řumur n SIDI, inna: “Aqa d tidett am mammec tessiweř teqbič n ayt n Yusuf. ");
INSERT INTO rifl_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Wa d awař i zi yumur SIDI x yessis n Ṣalufḥad, iqqar: ‘Ejj i-tent ad meřcent ak-d wenni d asent yarecqen. Ittxeṣṣa mɣir ad meřcent di řaǧ n teqbič n babatsent. ");
INSERT INTO rifl_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","War iɛeddeř ad traḥ tesɣart n ayt n Israil zi teqbič ɣar teqbič nneɣni, minzi kuř aryaz n ayt n Israil ad iqqim iṭṭef di tesɣart n teqbič n řejdud nnes. ");
INSERT INTO rifl_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Yeǧis n kuř ijj i ɣa iṭṭfen ict n tesɣart zeg ayt n Israil, ittxeṣṣa as ad temřec ak-d ijj zeg ijj n řaǧ zi teqbič n babas, ḥima kuř ijj zeg ayt n Israil ad iwart tasɣart n řejdud nnes. ");
INSERT INTO rifl_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","War iɛeddeř ad traḥ tesɣart n ict n teqbič ɣar teqbič nneɣni, minzi ittxeṣṣa i kuř ict zi tqebbař n ayt n Israil ad iqqim iṭṭef di tesɣart nnes.’” ");
INSERT INTO rifl_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Yessis n Ṣalufḥad ggint am mammec t yumur SIDI i Musa. ");
INSERT INTO rifl_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Maḥla, Tirṣa, Ḥujla, Milka d Nuɛa, yessis n Ṣalufḥad, dewřent d tinemřač ak-d iḥenjiren n ɛemmitsent. ");
INSERT INTO rifl_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Dewřent d tinemřač di řaǧat n ayt n Manassa, mmis n Yusuf. Ammu i teqqim tesɣart nsent di teqbič n babatsent. ");
INSERT INTO rifl_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Tina d tiweṣṣa d lfarayiḍ nni yumur SIDI s tsexxart n Musa i ayt n Israil di řewḍat n Mu’ab, ɣar L’Urdun arendad n Ariḥa. ");
INSERT INTO rifl_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ina d awařen nni issiweř Musa i marra Israil x ujemmaḍ n L’Urdun, di řexřa, di Řewḍa arendad n Ṣuf, jar Faran d Tufal d Laban d Ḥaḍayrut d Di-Dahab. ");
INSERT INTO rifl_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Zi Ḥurib x webrid n idurar n Saɛir ař Qadac-Barniɛ aqa-tt d ict n ticti n ḥiṭac n wussan. ");
INSERT INTO rifl_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Imsar deg useggʷas wiss arebɛin, deg uyur wiss ḥiṭac, deg wass amezwaru n uyur, issiweř Musa ak-d ayt n Israil ɛlaḥsab marra min d as iweṣṣa SIDI zi jjihet nsen, ");
INSERT INTO rifl_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","awarni umi iɣřeb di Idraɛi x Siḥun, ajeǧid n Imuriyyen wenni tuɣa izeddɣen di Ḥacbun, u x Ɛuj, ajeǧid n Bacan, wenni tuɣa izeddɣen di Ɛactarut. ");
INSERT INTO rifl_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","X ujemmaḍ n L’Urdun, di temmurt n Mu’ab, ibda Musa ad ifessar Ccariɛa-ya, inna: ");
INSERT INTO rifl_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“SIDI, AREBBI nneɣ, issiweř akidneɣ ɣar Ḥurib, inna: ‘Kenniw teqqimen aṭṭas ɣar wedrar-a, aqa d aṭṭas. ");
INSERT INTO rifl_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Dewřem, kksem iqiḍan nwem uca adfem ɣar idurar n Imuriyyen u ɣar marra imucan yudsen di Řewḍa, di Temmurt n Idurar, di Temmurt Iwaṭan, di Temmurt n Ljanub u ɣar tma n řebḥar, tammurt n ayt n Kenɛan, d Lubnan ař iɣzar ameqqran, iɣzar n Lfuraṭ. ");
INSERT INTO rifl_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Xzar, Necc wciɣ awem tammurt i iǧan zzat i wudem nwem. Adfem ɣares, tᵉṭṭfem tammurt nni x ijjuǧ SIDI ad tt iwc i řejdud nwem, i Ibrahim, Isḥaq d Yaɛqub, u i zzariɛet nsen awarni asen.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Di řweqt nni ssiwřeɣ necc akidwem, nniɣ: ‘Necc waha war zemmareɣ ad arbuɣ amnus i kenniw. ");
INSERT INTO rifl_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","SIDI, AREBBI nwem, igga kenniw d aṭṭas, uca xzar, kenniw řexxu d aṭṭas am yitran n ujenna. ");
INSERT INTO rifl_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Ad taf ad daywem immarni SIDI, AREBBI n řejdud nwem, am mammec kenniw teǧam řexxu ařef n twařawin uca ad taf ad kenniw ibarek am mammec tuɣa ɣarwem dd-issiweř. ");
INSERT INTO rifl_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Mammec zemmareɣ necc weḥḥdi waha ad arbuɣ isḥessifen nwem d ddquřat nwem d imcubbecen nwem? ");
INSERT INTO rifl_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ksim zi jar teqbič nwem iryazen imiɣisen, ifehhmen, inni ittwassnen icnan, ḥima ad ten ggeɣ d izeǧifen xawem.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Xenni kenniw tarrim-dd xafi, tennam ayi: ‘Awař i tessiwřed, aqa iban-dd icna, ḥima ad t negg.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Uca ksiɣ izeǧifen n teqbič nwem, iryazen imiɣisen, ifehhmen, inni ittwassnen icnan, uca ggiɣ ten d izeǧifen xawem, am imeqqranen x wařef, imeqqranen x mya, imeqqranen x xemsin d imeqqranen x ɛecra, u am imeḥḍayen x tqebbař nwem. ");
INSERT INTO rifl_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Di řweqt nni umureɣ i řquḍat nwem uca nniɣ: ‘Sřem ɣar aytmatwem uca ḥekmem s yijj n řḥukm iseggden jar weryaz d umas d ubarrani nni kides iǧan.    ");
INSERT INTO rifl_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","War tteggem s wudmawen di řeḥkam. Ad tesřem ɣar umeẓyan d umeqqran. War teggʷdem zeg wudem n ca n yijjen, minzi řeḥkam ɣar AREBBI. Tamesřact nni tewɛar xawem, awyem tt-i-dd ɣari uca necc ad tt sřeɣ.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Ammu i kenniw umureɣ di řweqt nni marra timesřayin nni xawem ad tent teggem.” ");
INSERT INTO rifl_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Xenni nefsi iqiḍan nneɣ uca neffeɣ zi Ḥurib uca neẓwa marra řexřa ameqqran issaggʷaden nni teẓrim, nuyur deg webrid n idurar n Imuriyyen am mammec d aneɣ yumur SIDI, AREBBI nneɣ, uca niweḍ ɣar Qadac-Barniɛ. ");
INSERT INTO rifl_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Xenni nniɣ awem: ‘Aqa tiwḍem ɣar idurar n Imuriyyen nni i d aneɣ ɣa iwc SIDI, AREBBI nneɣ. ");
INSERT INTO rifl_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Xzar, SIDI, AREBBI nnec, aqa iwca as tammurt i din iǧan zzat i wudem nnec. Geɛɛed, ṭṭef i-tt, am mammec ɣarek issiweř SIDI, AREBBI n řejdud nwem. War tteggʷed u war ttejji ad iɛgez wuř nnec.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Tusim-dd ɣari marra kenniw, tennam: ‘Ejj aneɣ ad nessekk iryazen zzat i wudem nneɣ ḥima ad bergagen tammurt maḥend ad aneɣ xebbaren x man abrid i zi ɣa ngeɛɛed di tammurt u mammec ǧant tneddam i ɣar dd ɣa nas.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Tuɣa awař-a d lemliḥ i necc uca ksiɣ tenɛac n yeryazen zi řwest nwem, zi kuř taqbič ijj n weryaz. ");
INSERT INTO rifl_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Nnḍen nitni uca uyuren x webrid ɣar idurar uca usin-dd ɣar teɣzurt n Ickul uca bergagen temmurt. ");
INSERT INTO rifl_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ksin s ifassen nsen řɣiǧet n temmurt uca hwan-dd ɣarneɣ. Iwyen aneɣ-dd řexbar, nnan: ‘Tammurt i d aneɣ ɣa iwc SIDI, AREBBI nneɣ, teṣbeḥ.’” ");
INSERT INTO rifl_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Qaɛ amenni, war texsem ad tgeɛɛdem uca tɣewwɣem ḍidd i řumur n SIDI, AREBBI nwem. ");
INSERT INTO rifl_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Uca tnedqem-dd deg iqiḍan nwem, tennam: ‘Deg weqřab nnes xaneɣ, aqa issuffeɣ aneɣ SIDI zi temmurt n Miṣra maḥend ad aneɣ yarr ɣar ifassen n Imuriyyen maḥend ad aneɣ yareddeǧ. ");
INSERT INTO rifl_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Mani xenni i ɣa ngeɛɛed? Aytmatneɣ ssfessyen uřawen nneɣ, nnan: Řgens imɣar uca zzugaren xaneɣ. Tineddam mɣarent uca ttwafaryent ař ajenna uca neẓra din uřa d ayt n Ɛanaq.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Necc nniɣ awem: ‘War tarjijem ca u war zzaysen tteggʷdem. ");
INSERT INTO rifl_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","SIDI, AREBBI nwem, wenni igguren zzatwem, ad immneɣ di ṭṭweɛ nwem, ammu nican am mammec igga zzat i tiṭṭawin nwem di ṭṭweɛ nwem di Miṣra ");
INSERT INTO rifl_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","uřa di rexřa, mani teẓrid mammec tuɣa cek yarebbu SIDI, AREBBI nnec, marra abrid nni tuyured, am yijj n weryaz yarebbun mmis, ařami dd-tiwḍem ɣar wemcan-a.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Maca kenniw ɛad war tuminem ca s wawař-a di SIDI, AREBBI nwem, ");
INSERT INTO rifl_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","wenni tuɣa igguren zzat i wudem nwem deg webrid, ḥima ad awem yarzu mani ɣa tewtem iqiḍan nwem, u wenni tuɣa igguren, s ǧiřet di tmessi, maḥend ad awem isscen abrid mani kenniw ittxeṣṣa ad tuyurem, u s uziř deg ijj n useynu. ");
INSERT INTO rifl_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","SIDI isřa řḥess n wawařen nwem uca ijja aɣḍab nnes ad idduqqez, ijjuǧ, inna: ");
INSERT INTO rifl_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Uřa d ijj zeg yeryazen-a n jjiř-a aɛeffan war iẓarr tammurt icnan nni x jjuǧeɣ maḥend ad tt wceɣ i řejdud nwem, ");
INSERT INTO rifl_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","mɣir Kalib, mmis n Yafunni, netta ad tt iẓar uca i netta d iḥenjiren nnes ad wceɣ tammurt nni x igga iḍaren nnes, minzi netta tuɣa iḍeffar SIDI nican.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Isɛar xafi SIDI di ssibbet nwem, inna: ‘Uřa d cek war ɣares ttidfed ca! ");
INSERT INTO rifl_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Yacuwa, mmis n Nun, wenni ibedden zzat i wudem nnec, ad ɣares yadef. Sjehd i-t, minzi netta d wenni tt ɣa iwcen d řwart i Israil. ");
INSERT INTO rifl_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Uca tarwa nwem i x tennam: Ad dewřen d teymart!, iḥenjiren nwem nni war ssinen ɛad řxar niɣ řɣar, nitni ad ɣares adfen uca Necc ad asen tt-i-dd-wceɣ uca nitni ad tt warten. ");
INSERT INTO rifl_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Maca kenniw ad dd-tdewřem, ad tekksem iqiḍan nwem ssa uca ad tuyurem ɣar řexřa ɣar Řebḥar n Telga.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Kenniw tarrim-dd, tennam ayi: ‘Aqa nexḍa ak-d SIDI. Ad ngeɛɛed uca ad nemmneɣ qaɛ am mammec d aneɣ yumur SIDI, AREBBI nneɣ.’ Xenni tbeysem, kuř ijj s řesnaḥ nnes n garra u kenniw s zzɛamet nwem tbeddem ad tgeɛɛdem ɣar wedrar. ");
INSERT INTO rifl_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Xenni inna ayi SIDI: ‘Ini asen: War ttgeɛɛdem, war ttmenɣim, minzi Necc war ǧiɣ di řwesṭ nwem, ḥima war txeṣṣarem zzat i wudem n řɛedyan nwem.’ ");
INSERT INTO rifl_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ammu i kiwem ssiwřeɣ, maca kenniw war ttesřim uca tɣewwɣem ḍidd i řumur n SIDI uca teggim s tuffet, tgeɛɛdem ɣar idurar. ");
INSERT INTO rifl_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Uca ffɣen Imuriyyen nni tuɣa izeddɣen deg idurar uca uẓẓřen xawem, am tteggent tzizwa, uca řebzen kenniw di Ṣaɛir ař Ḥurma. ");
INSERT INTO rifl_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Tdewřem-dd, tessɣuyem zzat i wudem n SIDI. SIDI war isři i tmijja nwem, war d awem iwci amezzuɣ, ");
INSERT INTO rifl_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","uca teqqimem di Qadac ict n řweqt d azirar, ussan aṭṭas i dinni teqqimem.” ");
INSERT INTO rifl_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“Xenni nedweř-dd uca nefsi iqiḍan uca nuyur ɣar řexřa, deg webrid ɣar Řebḥar n Telga, am mammec d ayi inna SIDI uca nenneḍ aṭṭas n wussan i idurar n Saɛir. ");
INSERT INTO rifl_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Xenni issiweř SIDI akidi, inna: ");
INSERT INTO rifl_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Aṭṭas i tennḍem i wedrar-a, aqa cfa. Arrem azeǧif ɣar ccamal ");
INSERT INTO rifl_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","uca umur řgens, ini: Ad tekkem kenniw x weymir n aytmatwem, ayt n Ɛisu, inni izeddɣen di Saɛir. Nitni ad zzaywem ggʷeden, maca ittxeṣṣa kenniw ad teḥḍam ixef nwem aṭṭas. ");
INSERT INTO rifl_vpl