﻿USE sofia;
DROP TABLE IF EXISTS sofia.rifa_vpl;
CREATE TABLE rifa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rifa_vpl WRITE;
INSERT INTO rifa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ذڭْ ؤُمزْوَارُو إِخْڒقْ-د أَربِّي إِجنْوَانْ ذ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ثُوغَا ثَامُّورْثْ ثخْڒَا، أَمْ مَامّشْ وَارْ ت إِتّْحِيذِي حذْ ؤُ خْ وُوذمْ ن وَامَانْ إِهوْڒنْ ثَادْجسْثْ، ؤُ أَرُّوحْ ن أَربِّي ثُوغَا إِتّْرَاحْ إِتَّاسْ-د خْ وُوذمْ ن وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ؤُشَا إِنَّا أَربِّي: ”أَذْ ثِيڒِي ثْفَاوْثْ“، ؤُشَا ثُوسَا-د ثْفَاوْثْ! ");
INSERT INTO rifa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","إِژْرَا أَربِّي بلِّي ثَافَاوْثْ ثصْبحْ ؤُشَا إِبْضَا أَربِّي جَارْ ثْفَاوْثْ ذ ثَادْجسْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","إِڒَاغَا أَربِّي ثَافَاوْثْ ’أَزِيڒْ‘ ؤُ ’ثَادْجسْثْ‘ إِڒَاغَا أَسْ ’دْجِيڒثْ‘. ثذْوڒْ ذ ثَامذِّيثْ ؤُ إِذْوڒْ ذ صّْبحْ: ذ أَسّْ أَمزْوَارُو. ");
INSERT INTO rifa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ؤُشَا إِنَّا أَربِّي: ”أَذْ ثِيڒِي إِشْثْ ن ڒْقُوبّثْ ذِي ڒْوسْطْ ن وَامَانْ، أَذْ ثبْضَا أَمَانْ خْ وَامَانْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","أَربِّي إِڭَّا ڒْقُوبّثْ ن ؤُجنَّا ؤُشَا إِبْضَا أَمَانْ إِ إِدْجَانْ سْوَادَّايْ إِ ڒْقُوبّثْ خْ وَامَانْ إِ إِدْجَانْ سنّجْ إِ ڒْقُوبّثْ. ؤُشَا أَمُّو إِ ثمْسَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","إِڒَاغَا أَربِّي إِ ڒْقُوبّثْ ’أَجنَّا‘. ؤُشَا ثذْوڒْ ذ ثَامذِّيثْ ؤُ إِذْوڒْ ذ صّْبحْ: ذ أَسّْ وِيسّْ ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ؤُشَا إِنَّا أَربِّي: ”أَذْ مُوننْ وَامَانْ إِ إِدْجَانْ سْوَادَّايْ إِ ؤُجنَّا غَارْ إِجّْ ن ومْشَانْ مَاحنْذْ أَذْ د-إِبَانْ ڒْبَارّْ!“ ؤُشَا أَمُّو إِ ثمْسَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","إِڒَاغَا أَربِّي إِ ڒْبَارّْ ’ثَامُّورْثْ‘ ؤُ أَمُونِي ن وَامَانْ إِڒَاغَا أَسْ ’ڒبْحُورْ‘. ؤُشَا إِژْرَا أَربِّي بلِّي مَانْ أَيَا إِصْبحْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ؤُشَا إِنَّا أَربِّي: ”أَذْ د-ثسّغْمِي ثمُّورْثْ أَغمُّويْ أَزِيزَا: أَفْسُو أَزِيزَا إِ إِزَارّْعنْ زَّارِيعثْ ذ ثْشجُّورَا س فْرُوثَا إِ د إِتِّيشنْ فْرُوثَاثْ عْلَاحْسَابْ مَارْكَا نْسنْثْ س زَّارِيعثْ نْسنْثْ ذَايسْ خْ وُوذمْ ن ثمُّورْثْ!“ ؤُشَا أَمُّو إِ ثمْسَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ثسّغْمِي-د ثمُّورْثْ أَغمُّويْ أَزِيزَا: أَفْسُو أَزِيزَا إِ إِزَارّْعنْ زَّارِيعثْ عْلَاحْسَابْ مَارْكَا نّسْ ذ ثْشجُّورَا إِ د إِتِّيشنْ ڒْغِيدْجثْ عْلَاحْسَابْ مَارْكَا نْسنْثْ س زَّارِيعثْ نْسنْثْ ذَايسْ. ؤُشَا إِژْرَا أَربِّي بلِّي مَانْ أَيَا إِصْبحْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ؤُشَا ثذْوڒْ ذ ثَامذِّيثْ ؤُ إِذْوڒْ ذ صّْبحْ: ذ أَسّْ وِيسّْ ثْڒَاثَا. ");
INSERT INTO rifa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ؤُشَا إِنَّا أَربِّي: ”أَذْ ذِينْ إِڒِينْثْ ثْفَاوِينْ ذِي ڒْقُوبّثْ ن ؤُجنَّا حِيمَا أَذْ بْضَانْثْ جَارْ وَاسّْ ذ دْجِيڒثْ، أَذْ إِڒِينْثْ ذ ڒِْيمَارَاثْ، ذ وُوسَّانْ إِتّْوَاڭّنْ، ذ وُوسَّانْ، ذ إِسڭّْوُوسَا ");
INSERT INTO rifa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ؤُشَا أَذْ إِڒِينْثْ ذ ثِيفَاوِينْ ذِي ڒْقُوبّثْ ن ؤُجنَّا حِيمَا أَذْ وْشنْثْ ثَافَاوْثْ خْ ثمُّورْثْ!“ ؤُشَا أَمُّو إِ ثمْسَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","إِڭَّا أَربِّي ثْنَاينْ ن ثِيفَاوِينْ مْغَارنْثْ، ثَافَاوْثْ ثَامقّْرَانْثْ، حِيمَا أَذْ ثحْكمْ خْ ؤُزِيڒْ، ؤُ ثَافَاوْثْ ثَامژْيَانْثْ حِيمَا أَذْ ثحْكمْ خْ دْجِيڒثْ، ؤُشَا ؤُڒَا ذ إِثْرَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","إِسَّارْسْ إِ-ثنْثْ أَربِّي ذِي ڒْقُوبّثْ ن ؤُجنَّا حِيمَا أَذْ وْشنْثْ ثَافَاوْثْ خْ ثمُّورْثْ ");
INSERT INTO rifa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ؤُ حِيمَا أَذْ حكْمنْثْ خْ وَاسّْ ذ دْجِيڒثْ ؤُ حِيمَا أَذْ بْضَانْثْ جَارْ ثْفَاوْثْ ذ ثَادْجسْثْ. ؤُشَا إِژْرَا أَربِّي بلِّي مَانْ أَيَا إِصْبحْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ؤُشَا ثذْوڒْ ذ ثَامذِّيثْ ؤُ إِذْوڒْ ذ صّْبحْ: ذ أَسّْ وِيسّْ أَربْعَا. ");
INSERT INTO rifa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ؤُشَا إِنَّا أَربِّي: ”أَذْ د-سّفْينْ وَامَانْ س وَاطَّاسْ ن مَارَّا مِينْ ذِي إِدْجَا بُوحْبڒْ إِدَّارنْ ؤُشَا أَذْ ضْونْ إِجْضَاضْ سنّجْ إِ ثمُّورْثْ غَارْ مَانِي ثدْجَا ڒْقُوبّثْ ن ؤُجنَّا!“ ");
INSERT INTO rifa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","إِخْڒقْ-د أَربِّي إِمُودَّارنْ إِمقّْرَاننْ ذِي ڒبْحَارْ ؤُ مَارَّا بُوحْبڒْ إِدَّارنْ إِتّنْهزَّانْ، إِنِّي زِي د-سّفْينْ وَامَانْ، عْلَاحْسَابْ مَارْكَا نْسنْ ؤُشَا مَارَّا إِجْضَاضْ س وَافْرِيونْ عْلَاحْسَابْ مَارْكَا نْسنْ. ؤُشَا إِژْرَا أَربِّي بلِّي مَانْ أَيَا إِصْبحْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","إِبَارْكْ إِ-ثنْ أَربِّي، إِنَّا: ”جّمْ-د ڒْغِيدْجثْ، كْثَارمْ، عمَّارمْ أَمَانْ ن ڒبْحُورْ ؤُشَا أَذْ كْثَارنْ إِجْضَاضْ ذِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ؤُشَا ثذْوڒْ ذ ثَامذِّيثْ ؤُ إِذْوڒْ ذ صّْبحْ: ذ أَسّْ وِيسّْ خمْسَا. ");
INSERT INTO rifa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ؤُشَا إِنَّا أَربِّي: ”أجّْ ثمُّورْثْ أَذْ ثسُّوفّغْ مَارَّا مِينْ غَارسْ بُوحْبڒْ إِدَّارنْ عْلَاحْسَابْ مَارْكَا نّسْ: ڒبْهَايمْ ذ إِمُودَّارنْ نِّي إِتّْبُوعنْ ذ ڒْمَاڒْ نْ ڒخْڒَا عْلَاحْسَابْ مَارْكَا نْسنْ!“ ؤُشَا أَمُّو إِ ثمْسَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","إِڭَّا أَربِّي ڒْمَاڒْ ن ڒخْڒَا ن ثمُّورْثْ عْلَاحْسَابْ مَارْكَا نْسنْ، ؤُ ڒبْهَايمْ عْلَاحْسَابْ مَارْكَا نْسنْثْ ؤُ مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ وُوذمْ ن ثمُّورْثْ عْلَاحْسَابْ مَارْكَا نْسنْ. ؤُشَا إِژْرَا أَربِّي بلِّي مَانْ أَيَا إِصْبحْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ؤُشَا إِنَّا أَربِّي: ”أجّْ أَنغْ أَذْ نڭّْ أَذَامْ، بْنَاذمْ ذِي صِّيفثْ نّغْ، ذڭْ وَارْوَاسْ نّغْ، ؤُشَا أَذْ غَارسْ يِيڒِي جّهْذْ خْ إِسڒْمَانْ ن ڒبْحَارْ ؤُ خْ إِجْضَاضْ ن ؤُجنَّا ؤُ خْ ڒبْهَايمْ ؤُ خْ مَارَّا ثَامُّورْثْ ؤُ خْ مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","إِخْڒقْ-د أَربِّي أَذَامْ ذِي صِّيفثْ نّسْ. إِخْڒقْ إِ-ث-إِ-د ذِي صِّيفثْ ن أَربِّي، إِخْڒقْ إِ-ثنْ-د أَوْثمْ ذ ثوْثمْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","إِبَارْكْ إِ-ثنْ أَربِّي ؤُشَا إِنَّا أَسنْ أَربِّي: ”جّمْ-د ڒْغِيدْجثْ، كْثَارمْ، عمَّارمْ ثَامُّورْثْ ؤُشَا أَرّمْ ت سَاذُو ؤُفُوسْ نْومْ، حكْممْ خْ إِسڒْمَانْ ن ڒبْحَارْ ؤُ خْ إِجْضَاضْ ن ؤُجنَّا ؤُ خْ مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","إِنَّا أَربِّي: ”خْزَارمْ، أَذْ أَومْ وْشغْ مَارَّا أَفْسُو أَزِيزَا إِ إِزَارّْعنْ زَّارِيعثْ خْ مَارَّا وُوذمْ ن ثمُّورْثْ ؤُڒَا ذ مَارَّا ثِيشجُّورَا س ڒْغِيدْجثْ نِّي إِزَارّْعنْ زَّارِيعثْ. مَانْ أَيَا أَذْ أَومْ يِيڒِي ذ مَاشَّا.    ");
INSERT INTO rifa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ؤُ إِ مَارَّا ڒْمَاڒْ ن ڒخْڒَا ن ثمُّورْثْ، ؤُ إِ مَارَّا إِجْضَاضْ ن ؤُجنَّا ؤُ إِ مَارَّا مِينْ إِتّْبُوعنْ خْ ثمُّورْثْ إِ ذِي إِدْجَا بُوحْبڒْ إِدَّارنْ، أَذْ أَسنْ يِيڒِي مَارَّا أَفْسُو أَزِيزَا ذ مَاشَّا إِ نِيثْنِي.“ ؤُشَا أَمُّو إِ ثمْسَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ؤُشَا إِژْرَا أَربِّي مَارَّا مِينْ إِڭَّا، ؤُ خْزَارْ، ثُوغَا إِصْبحْ أَطَّاسْ. ثذْوڒْ ذ ثَامذِّيثْ ؤُ إِذْوڒْ ذ صّْبحْ: ذ أَسّْ وِيسّْ ستَّا. ");
INSERT INTO rifa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","أَمُّو إِ تّْوَاكمّْڒنْ إِجنْوَانْ ذ ثمُّورْثْ ذ قَاعْ ڒْعسْكَارْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ذڭْ وَاسّْ وِيسّْ سبْعَا إِكمّڒْ أَربِّي ڒْخذْمثْ نّسْ إِ إِڭَّا ؤُشَا يَاريّحْ ذڭْ وَاسّْ وِيسّْ سبْعَا زِي مَارَّا ڒْخذْمثْ نّسْ إِ إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","إِبَاركْ أَربِّي أَسّْ وِيسّْ سبْعَا ؤُشَا إِسّْقدّسْ إِ-ث، مِينْزِي ذَايسْ إِ يَاريّحْ زِي مَارَّا ڒْخذْمثْ نّسْ، ڒْخذْمثْ إِ د-إِخْڒقْ أَربِّي مَاحنْذْ أَذْ ت إِڭّْ أَمنِّي. إِنَا ذ إِمزْرُوينْ ن وخْڒَاقْ ن ؤُجنَّا ذ ثمُّورْثْ ڒَامِي د-تّْوَاخڒْقنْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ذڭْ وَاسّْ إِ إِڭَّا سِيذِي أَربِّي ثَامُّورْثْ ذ إِجنْوَانْ ");
INSERT INTO rifa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","- قْبڒْ ثُوغِي ذِينْ مَارَّا شْبَارْقْ ذِي ثمُّورْثْ ؤُ قْبڒْ د-إِغْمِي وفْسُو ن ييَّارْ، مِينْزِي سِيذِي أَربِّي وَارْ إِجِّي أَنْژَارْ أَذْ إِوّثْ عَاذْ خْ ثمُّورْثْ - ؤُشَا وَارْ ثُوغِي ذِينْ أَذَامْ عَاذْ حِيمَا أَذْ إِخْذمْ ثَامُّورْثْ، ");
INSERT INTO rifa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ثْڭعّذْ-د ثَايُّوثْ زِي ثمُّورْثْ، ثسُّو مَارَّا ؤُذمْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ؤُشَا إِكوّنْ سِيذِي أَربِّي أَذَامْ زِي ثْعجَّاجْثْ ن ؤُشَاڒْ ؤُشَا إِسُوضْ ڒعْوِينْ ن ثُوذَارْثْ ذڭْ ونْزَارنْ نّسْ. أَمُّو إِ إِذْوڒْ أَذَامْ ذ إِجّْ ن نّفْسْ إِدَّارْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","خنِّي إِژُّو سِيذِي أَربِّي جّنّثْ ذِي عَاذْنْ، جِّيهثْ ن شَّارْقْ، ؤُشَا إِسَّارْسْ ذِينْ أَذَامْ إِ إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ؤُشَا إِسّغْمِي-د سِيذِي أَربِّي زِي ثمُّورْثْ كُوڒْ ثَاشجَّارْثْ، ثشْنَا إِ ڒْخژْرَاثْ ؤُ ثْمِيژِيذْثْ إِ مَاشَّا، ؤُشَا إِسّغْمِي-د ڒَا ذ ثَاشجَّارْثْ ن ثُوذَارْثْ ذِي ڒْوسْطْ ن جّنّثْ ؤُڒَا ذ ثَاشجَّارْثْ ن ثُوسّْنَا ن ڒْخَارْ ذ ڒْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","إِفّغْ-د إِجّْ ن إِغْزَارْ زِي عَاذْنْ، حِيمَا أَذْ إِسُّووْ جّنّثْ ؤُ سّنِّي إِمّْسبْضَا خْ أَربْعَا ن إِزدْجِيفنْ إِ إِڭِّينْ ثِيسدْجْيَاوِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","إِسمْ ن يغْزَارْ أَمزْوَارُو ذ فِيشُونْ. نتَّا إِ إِنّْضنْ إِ مَارَّا ثَامُّورْثْ ن حَاوِيلَا مَانِي إِدْجَا وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ؤُرغْ ن ثمُّورْثْ نِّي إِصْبحْ. أَقَا ذِينْ أَسرْغَاغْ أَشمْڒَاڒْ قَّارنْ أَسْ ’بذُولَا‘، ذ وژْرُو ن ’ؤُنِيكْسْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","إِسمْ ن إِغْزَارْ وِيسّْ ثْنَاينْ ذ جِيحُونْ إِ ثُوغَا إِنّْضنْ إِ مَارَّا ثَامُّورْثْ ن كُوشْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","إِسمْ ن إِغْزَارْ وِيسّْ ثْڒَاثَا ذ حِيدَّاقِيلْ. نتَّا إِتَّازّڒْ غَارْ شَّارْقْ ن أَشُّورْ. ؤُ إِغْزَارْ وِيسّْ أَربْعَا ذ لْفُورَاطْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","إِكْسِي سِيذِي أَربِّي أَذَامْ ؤُشَا إِسَّارْسْ إِ-ث ذِي جّنّثْ ن عَاذْنْ، حِيمَا أَذْ ت إِخْذمْ ؤُ أَذْ ت إِحْضَا. ");
INSERT INTO rifa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","سِيذِي أَربِّي إِوصَّا أَذَامْ، إِنَّا: ”زِي مَارَّا ثِيشجُّورَا ن جّنّثْ أَذْ ثشّذْ مَاشَّا، ");
INSERT INTO rifa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","مَاشَا زِي ثْشجَّارْثْ ن ثُوسّْنَا ن ڒْخَارْ ذ ڒْغَارْ وَارْ تّتّذْ شَا زَّايسْ، مِينْزِي ذڭْ وَاسّْ إِ زَّايسْ غَا ثشّذْ، ڒْموْثْ إِ غَا ثمّْثذْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","إِنَّا سِيذِي أَربِّي: ”وَارْ إِعدّڒْ أَذْ يِيڒِي أَذَامْ وحّْذسْ. أَذْ أَسْ ڭّغْ وِي ث غَا إِعَاوْننْ، أَمْ نتَّا قِيبَاتْشْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ثُوغَا سِيذِي أَربِّي إِڭَّا زڭْ ؤُشَاڒْ مَارَّا ڒْمَاڒْ ن ڒخْڒَا ؤُ مَارَّا إِجْضَاضْ ن ؤُجنَّا، ؤُشَا إِنْذهْ إِ-ثنْ غَارْ أَذَامْ، حِيمَا أَذْ إِژَارْ مَامّشْ إِ ثنْ غَا إِسمَّا. مَامّشْ إِ غَا إِسمَّا أَذَامْ كُوڒْ نّفْسْ إِدَّارنْ ذ وَا ذ إِسمْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","إِڭَّا أَذَامْ إِسْمَاونْ إِ مَارَّا ڒبْهَايمْ ذ يجْضَاضْ ن ؤُجنَّا ؤُ إِ مَارَّا ڒْمَاڒْ ن ڒخْڒَا، مَاشَا إِ أَذَامْ وَارْ يُوفِي وِي ث غَا إِعَاوْننْ ذ وِي غَا يِيڒِينْ أَمْ نتَّا قِيبَاتْشْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","إِسّهْوَا-د سِيذِي أَربِّي إِجّْ ن يِيضصْ يُودْجغْ خْ أَذَامْ ؤُشَا إِطّصْ. خنِّي إِكْسِي إِشْثنْ زِي ثْغزْذِيسِينْ نّسْ ؤُشَا إِقّنْ أَمْشَانْ يَارزْمنْ نِّي س ويْسُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","يَارَّا سِيذِي أَربِّي ثَاغزْذِيسْثْ ثنِّي إِ إِكْسِي زِي أَذَامْ ذ ثَامْغَارْثْ ؤُشَا يِيوْيِي ت-إِ-د غَارْ أَذَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","خنِّي إِنَّا أَذَامْ: ”ثْوَاڒَا-يَا ثَانِيثَا أَقَا-ت ذ إِغسْ زڭْ إِغْسَانْ إِنُو ذ أَيْسُومْ زڭْ ويْسُومْ إِنُو. ثَانِيثَا أَذْ ثتّْوَاسمَّا ’ثَارْيَازْثْ‘، إِخْسْ أَذْ يِينِي ’ثَامْغَارْثْ‘، مِينْزِي نتَّاثْ ثتّْوَاكْسِي-د زڭْ ورْيَازْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","خْ ؤُيَا أَذْ إِسْمحْ ورْيَازْ ذِي بَابَاسْ ذ يمَّاسْ، أَذْ إِقّنْ غَارْ ثمْغَارْثْ نّسْ ؤُشَا أَذْ إِڒِينْ ذ إِشْثْ ن دَّاثْ.    ");
INSERT INTO rifa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ثُوغَا-ثنْ س ثْنَاينْ إِذْسنْ ذ إِعَارْيَاننْ، أَذَامْ ذ ثمْغَارْثْ نّسْ، مَاشَا ثُوغَا وَارْ ذِينْ شَا ن ڒحْيَا جَارْ أَسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ثُوغَا أَفِيغَارْ ذ أَحْرَايْمِي خْ مَارَّا ڒْمَاڒْ ن ڒخْڒَا إِ إِڭَّا سِيذِي أَربِّي. إِنَّا إِ ثمْغَارْثْ: ”مَا ذ ثِيذتّْ إِنَّا أَربِّي: ’غَارْومْ وَارْ تّتّمْ شَا زِي مَارَّا ثِيشجُّورَا ن جّنّثْ‘؟“ ");
INSERT INTO rifa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ثنَّا ثمْغَارْثْ إِ ؤُفِيغَارْ: ”زِي ڒْغِيدْجثْ ن ثْشجُّورَا ن جّنّثْ نْزمَّارْ أَذْ نشّْ، ");
INSERT INTO rifa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","مَاشَا زِي ڒْغِيدْجثْ ن ثْشجَّارْثْ ذِي ڒْوسْطْ ن جّنّثْ، إِنَّا أَربِّي: ’وَارْ زَّايسْ تّتّمْ، وَارْ ت تّْحَاذَامْ، حِيمَا وَارْ ثتّْمتِّيمْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","إِنَّا ؤُفِيغَارْ إِ ثمْغَارْثْ: ”كنِّيوْ وَارْ ثتّْمتِّيمْ شَا س ڒْموْثْ قَاعْ، ");
INSERT INTO rifa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","مَاشَا أَربِّي إِسّنْ بلِّي أَسّْ نِّي ذِي زَّايسْ إِ غَا ثشّمْ، أَذْ أَرْزْمنْثْ ثِيطَّاوِينْ نْومْ ؤُشَا أَذْ ثِيڒِيمْ أَمْ أَربِّي، أَذْ ثسّْنمْ ڒْخَارْ زِي ڒْغَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ثژْرَا ثمْغَارْثْ بلِّي ثَاشجَّارْثْ ثصْبحْ إِ مَاشَّا ؤُشَا ثعْجبْ أَسنْثْ إِ ثِيطَّاوِينْ، أَقَا ثَاشجَّارْثْ ثڭَّا ذَايسْ مژْرِي مَاحنْذْ أَذْ زَّايسْ ثذْوڒْ ذ ثَامِيغِيسْثْ. خنِّي ثكْسِي زِي ڒْغِيدْجثْ نّسْ، ثشَّا ؤُشَا ثوْشَا عَاوذْ إِ ورْيَازْ نّسْ إِ ثُوغَا أَكِيذسْ، ؤُشَا نتَّا إِشَّا. ");
INSERT INTO rifa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","نَّارْزْمنْثْ ثِيطَّاوِينْ نْسنْ ؤُشَا ؤُفِينْ إِخفْ نْسنْ ذ إِعَارْيَاننْ. خنِّي خيّْضنْ ثِيفْرَايْ ن وَارْثُو، ؤُشَا ڭِّينْ زَّايْسنْثْ ثِيبَانْثِيوِينْ إِ يِيخفْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","خنِّي سْڒِينْ نِيثْنِي ثْمِيجَّا ن سِيذِي أَربِّي إِڭُّورْ ذِي جّنّثْ غَارْ ؤُوطُّو ن ثْمذِّيثْ، ؤُشَا إِفَّارْ أَذَامْ ذ ثمْغَارْثْ نّسْ زڭْ وُوذمْ ن سِيذِي أَربِّي جَارْ ثْشجُّورَا ن جّنّثْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ؤُشَا إِڒَاغَا سِيذِي أَربِّي أَذَامْ، إِنَّا أَسْ: ”مَانِي ثدْجِيذْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","نتَّا إِنَّا: ”سْڒِيغْ إِ ثْمِيجَّا نّشْ ذِي جّنّثْ ؤُشَا ڭّْوذغْ مِينْزِي نشّْ ذ أَعَارْيَانْ، خنِّي فَّارغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","إِنَّا أَسْ نتَّا: ”وِي ذ أَشْ إِنَّانْ بلِّي شكْ ذ أَعَارْيَانْ؟ مَا ثشِّيذْ زِي ثْشجَّارْثْ نِّي خْ شكْ وصِّيغْ ’أَقَا أَذْ زَّايسْ ثشّذْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","إِنَّا أَذَامْ: ”ثَامْغَارْثْ نِّي ذ أَيِي ثوْشِيذْ، نتَّاثْ ثوْشَا أَيِي زِي ثْشجَّارْثْ ؤُشَا شِّيغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","إِنَّا أَسْ سِيذِي أَربِّي إِ ثمْغَارْثْ: ”مَانَاوْيَا إِ ثڭِّيذْ؟“ ثنَّا أَسْ ثمْغَارْثْ: ”إِغَارَّا أَيِي ؤُفِيغَارْ ؤُشَا شِّيغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","إِنَّا سِيذِي أَربِّي إِ ؤُفِيغَارْ: ”ڒَْامِي ثڭِّيذْ أَيَا، أَقَا أَشْ ذ أَمنْعُوڒْ جَارْ مَارَّا ڒبْهَايمْ ؤُ جَارْ مَارَّا ڒْمَاڒْ ن ڒخْڒَا. خْ ؤُعذِّيسْ نّشْ أَذْ ثْمُورْذذْ، ؤُشَا أَذْ ثشّذْ ؤُشَاڒْ مَارَّا ؤُسَّانْ ن ثُوذَارْثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","أَذْ ڭّغْ ڒعْذَاوَاثْ جَارْ أَشْ ذ ثمْغَارْثْ، جَارْ زَّارِيعثْ نّشْ ذ زَّارِيعثْ نّسْ. ذ ثنِّي نّسْ أَذْ ثڒْبزْ أَزدْجِيفْ نّشْ، ؤُ شكْ أَذْ أَسْ ثْڒبْزذْ أَنِيرْزْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","إِنَّا إِ ثمْغَارْثْ: ”أَطَّاسْ إِ غَا أَرْنِيغْ ڒحْرِيقْ ذ ڒوْجعْ ن ثَارْوَا نّمْ. س ڒحْرِيقْ أَذْ د-ثَارْوذْ إِحنْجِيرنْ، ؤُشَا غَارْ ورْيَازْ نّمْ أَذْ ثمّژْرذْ، مَاشَا نتَّا أَذْ خَامْ إِحْكمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ؤُشَا إِنَّا إِ أَذَامْ: ”مِينْزِي ثسْڒِيذْ غَارْ ثْمِيجَّا ن ثمْغَارْثْ نّشْ ؤُ ثشِّيذْ زِي ثْشجَّارْثْ ثنِّي خْ شكْ وصِّيغْ: ’أَقَا أَذْ زَّايسْ ثشّذْ!‘، أَذْ ثِيڒِي ثمُّورْثْ ذ نّعْڒثْ خْ سِّيبّثْ نّشْ. س ثَامَارَا أَذْ زَّايسْ ثشّذْ، مَارَّا ؤُسَّانْ ن ثُوذَارْثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","إِسنَّاننْ ذ ثْزڭّْوَارْثْ إِ ذ أَشْ د غَا ثسّغْمِي، ؤُشَا أَذْ ثشّذْ أَفْسُو ن ييَّارْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","س ثِيذِي ن ؤُغمْبُوبْ نّشْ أَذْ ثشّذْ أَغْرُومْ أَڒْ د غَا ثْذوْڒذْ غَارْ ثمُّورْثْ إِ زِي ثمّكْسِيذْ، مِينْزِي شكْ ذ أَشَاڒْ ؤُشَا غَارْ ؤُشَاڒْ إِ غَا د-ثْذوْڒذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","إِڒَاغَا أَذَامْ إِسمْ ن ثمْغَارْثْ نّسْ حَاوَّا مِينْزِي نتَّاثْ ذ يمَّاسْ ن مَارَّا إِنِّي إِدَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","إِڭَّا سِيذِي أَربِّي إِ أَذَامْ ذ ثمْغَارْثْ نّسْ أَرُّوضْ س يِيڒمْ ؤُشَا يَارْضْ أَسنْ ث. ");
INSERT INTO rifa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","إِنَّا سِيذِي أَربِّي: ”خْزَارْ، أَذَامْ وَا، أَقَا إِذْوڒْ أَمْ يِيجّنْ زَّايْنغْ، إِسّنْ ڒْخَارْ ذ ڒْغَارْ. ڒخُّو، أجّْ إِ-ث وَارْ إِسّْوَاژَّاضْ أَفُوسْ نّسْ مَاحنْذْ أَذْ إِكْسِي زِي ثْشجَّارْثْ ن ثُوذَارْثْ عَاوذْ، أَذْ يشّْ ؤُ خنِّي أَذْ إِدَّارْ إِ ڒبْذَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ؤُشَا إِسُّوفُّوغْ إِ-ث سِيذِي أَربِّي زِي جّنّثْ ن عَاذْنْ حِيمَا أَذْ إِخْذمْ ثَامُّورْثْ إِ زِي ثُوغَا إِمّكْسِي. ");
INSERT INTO rifa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","يُوژّڒْ خْ أَذَامْ ؤُشَا إِڭَّا إِكِيرُوبنْ شَّارْقْ إِ جّنّثْ ن عَاذْنْ ذ يِيجّْ ن سِّيفْ إِتّحْذُوذُوقْ، إِتّشْضِيضِيحْ سَّا ذ سَّا إِ ؤُعسِّي خْ وبْرِيذْ ن ثْشجَّارْثْ ن ثُوذَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","إِسّنْ أَذَامْ حَاوَّا، ثَامْغَارْثْ نّسْ، ؤُشَا ثيْسِي س دّيْسثْ ؤُشَا ثُورُووْ-د قَايِينْ، ثنَّا ”جِّيغْ-د أَرْيَازْ، ذ سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","خنِّي عَاوذْ ثُورُووْ-د ؤُمَاسْ هَابِيلْ. ثُوغَا هَابِيلْ ذ أَمكْسَاوْ ن وُودْجِي ؤُ قَايِينْ إِرُوحْ إِخدّمْ ثَامُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ؤُشَا أَوَارْنِي ؤُسَّانْ إِمْسَارْ بلِّي قَايِينْ إِقدّمْ إِشْثْ ن ثوْهِيبْثْ زِي ڒْغِيدْجثْ ن وُوذمْ ن ثمُّورْثْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","إِقدّمْ هَابِيلْ عَاوذْ إِشْثْ ن ثوْهِيبْثْ زڭْ إِمنْزَا ن وُودْجِي نّسْ، زڭْ إِنِّي غَارْ إِدْجَا ثَاذُونْثْ أَطَّاسْ. إِخْزَارْ سِيذِي غَارْ هَابِيلْ ذ ثوْهِيبْثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","مَاشَا غَارْ قَايِينْ ذ ثوْهِيبْثْ نّسْ وَارْ ذ أَسْ يَارِّي شَا ثَايْنِيثْ. ؤُشَا إِخيّقْ قَايِينْ أَطَّاسْ، إِنّقْڒبْ أَسْ ؤُغمْبُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","إِنَّا سِيذِي إِ قَايِينْ: ”مَايمِّي ثْخيّْقذْ؟ مَايمِّي ذ أَشْ إِنّقْڒبْ ؤُغمْبُوبْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","مَاڒَا ثڭِّيذْ مْلِيحْ، مَا وَارْ ذِينْ إِتِّيڒِي ؤُسْڭعّذْ، ؤُ مَاڒَا وَارْ ثڭِّيذْ مْلِيحْ، دّنْبْ أَقَا-ث إِزّڒْ غَارْ ثوَّارْثْ؟ مژْرِي نّسْ غَاركْ، مَاشَا إِتّْخصَّا شكْ أَذْ خَاسْ ثْسدْجْضذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","إِسِّيوڒْ قَايِينْ أَكْ-ذ هَابِيلْ ؤُمَاسْ. ؤُشَا إِمْسَارْ أَمْ دْجَانْ نِيثْنِي ذڭْ إِيَّارْ، بلِّي قَايِينْ إِكَّارْ غَارْ ؤُمَاسْ هَابِيلْ ؤُشَا إِنْغَا إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","خنِّي إِنَّا سِيذِي إِ قَايِينْ: ”مَانِي إِدْجَا ؤُمَاشْ هَابِيلْ؟“ إِنَّا: ”وَارْ سِّينغْ. مَا نشّْ ذ أَمحْضَايْ خْ ؤُمَا؟“ ");
INSERT INTO rifa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ؤُشَا إِنَّا نتَّا: ”مِينْ ثڭِّيذْ؟ أَقَا ثْمِيجَّا ن إِذَامّنْ ن ؤُمَاشْ سْغُويُّونْ-د غَارِي زِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ڒخُّو، أَقَا شكْ ذ منْعُوڒْ زِي ثمُّورْثْ، ثنِّي يَارزْمنْ أَقمُّومْ نّسْ، حِيمَا أَذْ ثقْبڒْ إِذَامّنْ ن ؤُمَاشْ زڭْ إِفَاسّنْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","خْمِي غَا ثْخذْمذْ خْ ثمُّورْثْ، وَارْ تّذِيكّْوِيڒْ أَذْ أَشْ ثوْشْ مَارَّا جّهْذْ نّسْ ؤُشَا شكْ أَذْ ثِيڒِيذْ ذ أَمنّجْرُو ذ أَمثْلُوعْ ذِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","خنِّي إِنَّا قَايِينْ إِ سِيذِي: ”لْعِيقَابْ إِنُو إِمْغَارْ أَطَّاسْ خْ ثْزمَّارْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","أَقَا شكْ أَسّْ-أَ ثُوژّْڒذْ خَافِي زڭْ ؤُغمْبُوبْ ن ثمُّورْثْ-أَ ؤُشَا زڭْ ؤُغمْبُوبْ نّشْ أَذْ تّْوَافَّار. أَذْ إِڒِيغْ ذ أَمنّجْرُو ذ أَمثْلُوعْ ذِي ثمُّورْثْ ؤُشَا أَذْ يِيڒِي مَارَّا ونِّي ذ أَيِي غَا يَافنْ أَذْ أَيِي إِنغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","خنِّي إِنَّا أَسْ سِيذِي: ”س ؤُيَا مَارَّا ونِّي إِ غَا إِنْغنْ قَايِينْ، أَذْ زَّايسْ خڒْفنْ سبْعَا ن ثْوَاڒَاوِينْ.“ ؤُشَا إِڭَّا سِيذِي ڒعْڒَامثْ إِ قَايِينْ بلِّي مَارَّا ونِّي ث غَا يَافنْ وَارْ ث إِنقّْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","خنِّي إِفّغْ-د قَايِينْ زڭْ وُوذمْ ن سِيذِي ؤُشَا إِرُوحْ إِزدّغْ ذِي ثمُّورْثْ ن نُوذْ، شَّارْقْ ن عَاذْنْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","إِسّنْ قَايِينْ ثَامْغَارْثْ نّسْ ؤُشَا ثيْسِي س دّيْسثْ ؤُشَا ثُورُووْ أَسْ-د حَانُوخْ. ثُوغَا قَاينْ إِبْنَا إِشْثْ ن ثنْذِينْثْ ؤُشَا إِڒَاغَا أَسْ إِ ثنْذِينْثْ أَمْ يِيسمْ ن مِّيسْ حَانُوخْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","حَانُوخْ إِجَّا-د عِيرَاذْ، ؤُ عِيرَاذْ إِجَّا-د محُويَائِيلْ ؤُ محُويَائِيلْ إِجَّا-د مَاتُوشَائِيلْ ؤُ مَاتُوشَائِيلْ إِجَّا-د لَامَاكْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","إِمْڒشْ لَامَاكْ ثْنَاينْ ن ثمْغَارِينْ. إِشْثنْ قَّارنْ أَسْ عَاذَا، ثنّغْنِي قَّارنْ أَسْ صِيلَّا. ");
INSERT INTO rifa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ثُورُووْ-د عَاذَا يَابَالْ. نتَّا إِذْوڒْ ذ بَابَاثْسنْ إِ إِمزْذَاغْ ن إِقِيضَانْ ؤُ إِ إِمكْسَاونْ ن ڒبْهَايمْ. ");
INSERT INTO rifa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","إِسمْ ن ؤُمَاسْ ثُوغَا ذ يُوبَالْ ونِّي ثُوغَا ذ بَابَاثْسنْ إِ مَارَّا إِنِّي إِتِّيرَارنْ ڒْڭَامْبْرِي ذ ثمْجَا. ");
INSERT INTO rifa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","صِيلَّا ثُورُووْ-د عَاوذْ ثُوبَالْ-قَايِينْ، أَمْزِيڒْ ن إِمْزِيڒنْ ن مَارَّا إِنِّي إِخدّْمنْ س نّْحَاسْ ذ وُوزَّاڒْ. ؤُتْشْمَاسْ ن ثُوبَالْ-قَايِينْ ثُوغَا ذ نَاعْمَا. ");
INSERT INTO rifa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","إِنَّا لَامَاكْ إِ ثمْغَارِينْ نّسْ، عَاذَا ذ صِيلَّا: ”سْڒنْثْ إِ ثْمِيجَّا إِنُو، أَ ثِيمْغَارِينْ ن لَامَاكْ! سْڒنْثْ غَارْ مِينْ غَا إِنِيغْ. أَقَا نْغِيغْ أَرْيَازْ إِ ؤُيزِّيمْ إِنُو ذ ؤُحنْجِيرْ إِ ؤُيذِّيمْ إِنُو! ");
INSERT INTO rifa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","أَقَا أَذْ خڒْفنْ زِي قَايِينْ سبْعَا ن ثْوَاڒَاوِينْ، مَاشَا زِي لَامَاكْ سبْعَا ؤُ-سبْعِينْ ن ثْوَاڒَاوِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","يُوذفْ أَذَامْ عَاوذْ خْ ثَامْغَارْثْ نّسْ ؤُشَا ثُورُووْ-د نتَّاثْ أَحنْجِيرْ. ثْڒَاغَا أَسْ شِيثْ، مِينْزِي ثنَّا: ”أَربِّي إِوْشَا أَيِي زَّارِيعثْ نّغْنِي ذڭْ ومْشَانْ ن هَابِيلْ، مِينْزِي قَايِينْ إِنْغَا إِ-ث.“ ");
INSERT INTO rifa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ؤُڒَا إِ شِيثْ إِتّْوَاخْڒقْ-د ؤُسيْمِي، ؤُشَا إِڭَّا أَسْ أَنُوشْ. ڒخْذنِّي إِبْذَا بْنَاذمْ س ؤُڒَاغِي خْ يِيسمْ ن سِيذِي. وَا ذ أَذْلِيسْ إِتّْوَانْضنْ ن إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي أَذَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","أَسّْ مِينْ ذِي إِڭَّا أَربِّي أَذَامْ، إِڭَّا إِ-ث ذِي صِّيفثْ ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","أَوْثمْ ذ ثوْثمْثْ إِخْڒقْ إِ-ثنْ-د. إِبَارْكْ إِ-ثنْ ؤُشَا إِڒَاغَا أَسنْ س يِيسمْ ’أَذَامْ‘، بْنَاذمْ، ذڭْ وَاسّْ إِ ذِي ثنْ د-إِخْڒقْ.    ");
INSERT INTO rifa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","أَوَارْنِي ڒَامِي إِدَّارْ أَذَامْ مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، إِجَّا-د أَحنْجِيرْ ذڭْ وَارْوَاسْ نّسْ ؤُ ذِي صِّيفثْ نّسْ ؤُشَا إِڒَاغَا أَسْ شِيثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","أَوَارْنِي ڒَامِي د-إِجَّا شِيثْ، إِدَّارْ أَذَامْ عَاذْ ثمْنْ-مْيَا ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","أَمُّو إِ إِدَّارْ أَذَامْ ثسْعَا-مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","أَوَارْنِي ڒَامِي إِدَّارْ شِيثْ مْيَا ؤُ-خمْسَا ن إِسڭّْوُوسَا، إِجَّا-د أَنُوشْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","أَوَارْنِي ڒَامِي د-إِجَّا أَنُوشْ، إِدَّارْ شِيثْ عَاذْ ثمْنْ-مْيَا ؤُ-سبْعَا ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","أَمُّو إِ إِدَّارْ شِيثْ ثسْعَا-مْيَا ؤُ-ثنْعَاشْ ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","أَوَارْنِي ڒَامِي إِدَّارْ أَنُوشْ ثسْعِينْ ن إِسڭّْوُوسَا، إِجَّا-د قِينَانْ.    ");
INSERT INTO rifa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","أَوَارْنِي ڒَامِي د-إِجَّا قِينَانْ، إِدَّارْ أَنُوشْ عَاذْ ثمْنْ-مْيَا ؤُ-خمّسْطَاشْ ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","أَمُّو إِ إِدَّارْ أَنُوشْ ثسْعَا-مْيَا ؤُ-خمْسَا ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","أَوَارْنِي ڒَامِي إِدَّارْ قِينَانْ سبْعِينْ ن إِسڭّْوُوسَا، إِجَّا-د مَاهَالَالْ-إِلْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","أَوَارْنِي ڒَامِي د-إِجَّا مَاهَالَالْ-إِلْ، إِدَّارْ قِينَانْ عَاذْ ثمْنْ-مْيَا ؤُ-ربْعِينْ ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","أَمُّو إِ إِدَّارْ قِينَانْ ثسْعَا-مْيَا ؤُ -عشْرَا ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","أَوَارْنِي ڒَامِي إِدَّارْ مَاهَالَالْ-إِلْ خمْسَا ؤُ-ستِّينْ ن إِسڭّْوُوسَا، إِجَّا-د يَارَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","أَوَارْنِي ڒَامِي د-إِجَّا يَارَاذْ، إِدَّارْ مَاهَالَالْ-إِلْ عَاذْ ثمْنْ-مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","أَمُّو إِ إِدَّارْ مَاهَالَالْ-إِلْ ثمْنْ-مْيَا ؤُ-خمْسَا ؤُ-ثسْعِينْ ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","أَوَارْنِي ڒَامِي إِدَّارْ يَارَاذْ مْيَا ؤُ-ثْنَاينْ ؤُ-ستِّينْ ن إِسڭّْوُوسَا، إِجَّا-د حَانُوخْ.    ");
INSERT INTO rifa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","أَوَارْنِي ڒَامِي د-إِجَّا حَانُوخْ، إِدَّارْ يَارَاذْ عَاذْ ثمْنْ-مْيَا ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","أَمُّو إِ إِدَّارْ يَارَاذْ ثسْعَا-مْيَا ؤُ-ثْنَاينْ ؤُ-ستِّينْ ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","أَوَارْنِي ڒَامِي إِدَّارْ حَانُوخْ خمْسَا ؤُ-ستِّينْ ن إِسڭّْوُوسَا، إِجَّا-د مَاثُوشَالَاحْ.    ");
INSERT INTO rifa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","أَوَارْنِي ڒَامِي د-إِجَّا مَاثُوشَالَاحْ، يُويُورْ حَانُوخْ أَكْ-ذ أَربِّي ثڒْثْ-مْيَا ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","أَمُّو إِ إِدَّارْ حَانُوخْ ثڒْثْ-مْيَا ؤُ-خمْسَا ؤُ-ستِّينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","يُويُورْ حَانُوخْ أَكْ-ذ أَربِّي ؤُشَا وَارْ إِتّْوِيفْ عَاذْ مِينْزِي أَربِّي إِكْسِي إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","أَوَارْنِي ڒَامِي إِدَّارْ مَاثُوشَالَاحْ مْيَا ؤُ-سبْعَا ؤُ-ثْمَانْيِينْ ن إِسڭّْوُوسَا، إِجَّا-د لَامَاكْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","أَوَارْنِي ڒَامِي د-إِجَّا لَامَاكْ، إِدَّارْ مَاثُوشَالَاحْ عَاذْ سبْعَا-مْيَا ؤُ-ثْنَاينْ ؤُ-ثْمَانْيِينْ ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","أَمُّو إِ إِدَّارْ مَاثُوشَالَاحْ ثسْعَا-مْيَا ؤُ-ثسْعَا ؤُ-ستِّينْ ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","أَوَارْنِي ڒَامِي إِدَّارْ لَامَاكْ مْيَا ؤُ-ثْنَاينْ ؤُ-ثْمَانْيِينْ ن إِسڭّْوُوسَا، إِجَّا-د إِجّْ ن ؤُحنْجِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","إِڒَاغَا إِسمْ نّسْ نُوحْ، إِنَّا: ”وَا أَذْ أَنغْ إِسّْفوّجْ خْ ڒْخذْمثْ نّغْ ذ ثَامَارَا ن إِفَاسّنْ نّغْ، مِينْزِي سِيذِي أَقَا إِنْعڒْ ثَامُّورْثْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","أَوَارْنِي ڒَامِي د-إِجَّا نُوحْ، إِدَّارْ لَامَاكْ عَاذْ خمْسَا-مْيَا ؤُ-خمْسَا ؤُ-ثسْعِينْ ن إِسڭّْوُوسَا، إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","أَمُّو إِ إِدَّارْ لَامَاكْ سبْعَا-مْيَا ؤُ-سبْعَا ؤُ-سبْعِينْ ن إِسڭّْوُوسَا ؤُشَا إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","أَوَارْنِي ڒَامِي إِدَّارْ نُوحْ خمْسَا-مْيَا ن إِسڭّْوُوسَا، نُوحْ إِجَّا-د شَامْ ذ حَامْ ذ يَافَاثْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ڒَامِي بْذَانْ إِوْذَانْ أَذْ كْثَارنْ ذِي ثمُّورْثْ ؤُشَا ؤُرْونْثْ أَسنْ-د يسِّيثْسنْ، ");
INSERT INTO rifa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","أَقَا ژْرِينْ أَرَّاونْ ن أَربِّي بلِّي يسِّيسْ ن بْنَاذمْ شْنَانْثْ، ؤُشَا كْسِينْ ثِيمْغَارِينْ إِ يِيخفْ نْسنْ زِي مَارَّا ثِينِّي إِخْضَارنْ نِيثْنِي.    ");
INSERT INTO rifa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","خنِّي إِنَّا سِيذِي: ”وَارْ إِتّْغِيمِي أَرُّوحْ إِنُو ڒبْذَا ذِي بْنَاذمْ، أَقَا-ث ذ دَّاثْ زِي سِّيبّثْ ن ؤُودَّارْ نّسْ. أَذْ إِڒِينْ وُوسَّانْ ن ثُوذَارْثْ نّسْ مْيَا ؤُ-عِيشْرِينْ ن إِسڭّْوُوسَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ذڭْ وُوسَّانْ نِّي ثُوغَا ’إِنِيفِيلِيمْ‘، إِخْسْ أَذْ يِينِي ’إِنِّي إِوْضَانْ‘، ذِي ثمُّورْثْ ؤُشَا أَوَارْنِي مَانْ أَيَا عَاوذْ، ؤُمِي د-ؤُذْفنْ أَرَّاوْ ن أَربِّي غَارْ يسِّيسْ ن إِوْذَانْ ؤُشَا ؤُرْونْثْ أَسنْ-د. نِيثْنِي ذ ’جّْوَاهڒْ‘ ن زّْمَانْ نِّي، ذ إِرْيَازنْ س يِيسمْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","إِژْرَا سِيذِي بلِّي ڒْغَارْ ن بْنَاذمْ ذ أَطَّاسْ خْ ثمُّورْثْ ؤُشَا مَارَّا ڒمْوَايَاڒْ ن ؤُخَارّصْ ن وُوڒْ نّسْ ذ أَعفَّانْ كُوڒْ أَسّْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ؤُشَا إِنْذمْ سِيذِي ؤُمِي إِڭَّا بْنَاذمْ ذِي ثمُّورْثْ ؤُشَا إِقّسْ أَسْ وُوڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","إِنَّا سِيذِي: ”أَذْ مْحِيغْ خْ وُوذمْ ن ثمُّورْثْ بْنَاذمْ إِ د-خڒْقغْ، بْنَاذمْ أَكْ-ذ ڒبْهَايمْ ذ إِمُودَّارنْ إِتّْبُوعنْ ؤُڒَا ذ إِجْضَاضْ ن ؤُجنَّا، مِينْزِي نذْمغْ ؤُمِي ثنْ ڭِّيغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","مَاشَا نُوحْ يُوفَا أَرْضَا ذِي ثِيطَّاوِينْ ن سِيذِي. إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي نُوحْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ثُوغَا نُوحْ ذ أَرْيَازْ ذ أَمْسڭّذْ إِكْمڒْ جَارْ مَارَّا جِّيڒَاثْ نِّي إِدَّارنْ أَكِيذسْ. يُويُورْ نُوحْ أَكْ-ذ أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ؤُشَا إِجَّا-د نُوحْ ثْڒَاثَا ن إِحنْجِيرنْ: شَامْ ذ حَامْ ذ يَافَاثْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ثُوغَا ثَامُّورْثْ ذ إِشْثْ ن ڒْخَارْبثْ ذِي ثِيطَّاوِينْ ن أَربِّي ؤُ ثُوغَا ثَامُّورْثْ ثشُّورْ س لْعُونْفْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","إِخْزَارْ أَربِّي غَارْ ثمُّورْثْ، ؤُ خْزَارْ، أَقَا-ت ذ ڒْخَارْبثْ، مَاغَارْ مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ ثُوغَا خَارّْبنْ أَبْرِيذْ نْسنْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","إِنَّا أَربِّي إِ نُوحْ: ”أَنڭَّارْ ن مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ أَقَا-ث زَّاثْ إِ وُوذمْ إِنُو، مِينْزِي ثَامُّورْثْ ثشُّورْ س لْعُونْفْ زَّايْسنْ. أَقَا أَذْ ثنْ ثحِّيغْ أَكْ-ذ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","أڭّْ إِ يِيخفْ نّشْ إِجّْ ن ؤُغَارَّابُو س ؤُكشُّوضْ ن ؤُمرْزِي ؤُشَا أڭّْ إِخَّامنْ إِ مَارَّا ڒْمَاڒْ ذڭْ ؤُغَارَّابُو. غدْجفْ أَغَارَّابُو زِي ذَاخڒْ ؤُ زِي بَارَّا س ثِيزفْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","أَمُّو إِتّْخصَّا أَذْ ث ثڭّذْ: ثُوزّڭَّارْثْ ن ؤُغَارَّابُو أَذْ ثِيڒِي ثڒْثْ-مْيَا ن إِغَادْجنْ ؤُ ثِيرُو ن ؤُغَارَّابُو أَذْ ثِيڒِي خمْسِينْ ن إِغَادْجنْ ؤُ ڒُوعْڒَا نّسْ أَذْ يِيڒِي ثْڒَاثِينْ ن إِغَادْجنْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","إِتّْخصَّا أَذْ ثڭّذْ إِشْثْ ن ثْبُورْجثْ إِ ثْفَاوْثْ ذڭْ ؤُغَارَّابُو ؤُشَا أَذْ ت ثْكمّْڒذْ أَنشْثْ ن إِجّْ ن ؤُغِيڒْ زِي سنّجْ. أَذْ ثڭّذْ ثَاوَّارْثْ ن ؤُغَارَّابُو ذڭْ ؤُغزْذِيسْ نّسْ. أَذْ ثڭّذْ طّبْقثْ ن وَادَّايْ ذ طّبْقثْ وِيسّْ ثْنَاينْ ذِي ڒْوسْطْ ذ طّبْقثْ وِيسّْ ثْڒَاثَا سنّجْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","أَقَا نشّْ أَذْ سّكّغْ سّحْڒثْ ن وَامَانْ خْ ثمُّورْثْ، حِيمَا أَذْ ثحِّيغْ سَاذُو ؤُجنَّا مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ إِ ذِي إِدْجَا أَرُّوحْ ن ثُوذَارْثْ. مَارَّا مِينْ إِدْجَانْ ذِي ثمُّورْثْ أَذْ إِضْڒقْ إِ بُوحْبڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","مَاشَا أَذْ سّْبدّغْ ڒْعَاهْذْ إِنُو أَكِيذكْ ؤُشَا شكْ أَذْ ثَاذْفذْ غَارْ ؤُغَارَّابُو، شكْ ذ إِحنْجِيرنْ نّشْ ذ ثمْغَارْثْ نّشْ ذ ثمْغَارِينْ ن إِحنْجِيرنْ نّشْ أَكِيذكْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ؤُشَا زِي مَارَّا مِينْ إِدَّارنْ، زِي مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ أَذْ ثسِّيذْفذْ ثْيُويَا، غَارْ ؤُغَارَّابُو حِيمَا أَذْ دَّارنْ أَكِيذكْ: إِتّْخصَّا أَذْ يِيڒِي ذ أَوْثمْ ذ ثوْثمْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","أَذْ غَاركْ د-ثَاسْ ثْيُويَا زِي مَارَّا، حِيمَا أَذْ ثحْضِيذْ ثُوذَارْثْ نْسنْ: زڭْ إِجْضَاضْ عْلَاحْسَابْ مَارْكَاثْ نْسنْ، زِي ڒبْهَايمْ عْلَاحْسَابْ مَارْكَاثْ نْسنْثْ ؤُ زِي مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ عْلَاحْسَابْ مَارْكَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ؤُشَا شكْ، كْسِي إِ يِيخفْ نّشْ زِي مَارَّا مَاشَّا إِ إِتّْوَاشَّانْ ؤُشَا سْمُونْ إِ-ت غَاركْ، حِيمَا أَذْ أَشْ يِيڒِي ذ مَاشَّا ؤُشَا ؤُڒَا إِ نِيثْنِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ؤُشَا إِڭَّا نُوحْ أَمْ مَامّشْ مَارَّا إِ خفْ ث إِوصَّا أَربِّي، أَمُّو إِ ث إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","إِنَّا سِيذِي إِ نُوحْ: ”أَذفْ شكْ ذ مَارَّا ڒَْادْجْ ن ثَادَّارْثْ نّشْ غَارْ ؤُغَارَّابُو، مِينْزِي ژْرِيغْ شكْ ذ أَمْسڭّذْ زَّاثْ إِ وُوذمْ إِنُو ذِي جِّيڒْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","زِي مَارَّا ڒبْهَايمْ ن ڒحْڒَاڒْ أَذْ غَاركْ ثكْسِيذْ سبْعَا، سبْعَا، أَوْثمْ ذ ثوْثمْثْ نّسْ، ؤُ زِي ڒبْهَايمْ ن ڒحْرَامْ ثْيُويَا، أَوْثمْ ذ ثوْثمْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ؤُڒَا زڭْ إِجْضَاضْ ن ؤُجنَّا إِتّْخصَّا أَذْ ثكْسِيذْ سبْعَا ن ثِييُويَاوِينْ، أَوْثمْ ذ ثوْثمْثْ، حِيمَا أَذْ ثحْضِيذْ زَّارِيعثْ نْسنْ إِ ثُوذَارْثْ ذِي مَارَّا ثَامُّورْثْ، ");
INSERT INTO rifa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","مِينْزِي خْمِي غَا عْذُونْ عَاذْ سبْعَا ن وُوسَّانْ نشّْ أَذْ جّغْ أَنْژَارْ أَذْ إِوّثْ خْ ثمُّورْثْ أَربْعِينْ ن وُوسَّانْ ذ أَربْعِينْ ن دْجْيَاڒِي، ؤُشَا أَذْ ثحِّيغْ زڭْ وُوذمْ ن ثمُّورْثْ مَارَّا مِينْ إِدْجَانْ، ذ مِينْ ڭِّيغْ نشّْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ؤُشَا إِڭَّا نُوحْ أَمْ مَامّشْ كُوڒْشِي إِ خفْ ث إِوصَّا سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ثُوغَا نُوحْ ذ مِّيسْ ن ستَّا-مْيَا ن إِسڭّْوُوسَا ڒَامِي د-ثُوسَا سّحْڒثْ ن وَامَانْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ؤُشَا يُوذفْ نُوحْ غَارْ ؤُغَارَّابُو ذِي سِّيبّثْ ن وَامَانْ ن سّحْڒثْ، نتَّا ذ إِحنْجِيرنْ نّسْ ذ ثمْغَارْثْ نّسْ ذ ثمْغَارِينْ ن إِحنْجِيرنْ نّسْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","زِي ڒبْهَايمْ ن ڒحْڒَاڒْ ؤُ زِي ڒبْهَايمْ ن ڒحْرَامْ ؤُ زڭْ إِجْضَاضْ ؤُ زِي مَارَّا مِينْ إِتّْبُوعنْ خْ وُوذمْ ن ثمُّورْثْ ");
INSERT INTO rifa_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ثُوذفْ ثْيُويَا س ثْيُويَا غَارْ نُوحْ غَارْ ؤُغَارَّابُو، أَوْثمْ ذ ثوْثمْثْ أَمْ مَامّشْ إِوصَّا أَربِّي إِ نُوحْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","أَوَارْنِي سبْعَا ن وُوسَّانْ إِمْسَارْ بلِّي أَمَانْ ن سّحْڒثْ ؤُسِينْ-د خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ذڭْ ؤُسڭّْوَاسْ وِيسّْ ستَّا-مْيَا زِي ثُوذَارْثْ ن نُوحْ، ذڭْ ؤُيُورْ وِيسّْ ثْنَاينْ، ذڭْ وَاسّْ وِيسّْ سْبعْطَاشْ ن ؤُيُورْ نِّي، ذڭْ وَاسّْ-أَ نِّيثْ، ثُوغَا سّفْينْ-د مَارَّا ڒْعُونْصَارَاثْ ن وَامَانْ إِهوْڒنْ ؤُشَا تّْوَارزْمنْثْ ثْبُورْجَاثِينْ ن ؤُجنَّا. ");
INSERT INTO rifa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ثُوغَا أَنْژَارْ إِقِّيمْ إِشَّاثْ س جّهْذْ خْ ثمُّورْثْ أَربْعِينْ ن وُوسَّانْ ذ أَربْعِينْ ن دْجْيَاڒِي. ");
INSERT INTO rifa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ذڭْ وَاسّْ نِّي نِّيثْ ثُوغَا نُوحْ يُوذفْ غَارْ ؤُغَارَّابُو أَكْ-ذ شَامْ ذ حَامْ ذ يَافَاثْ، أَيْثْ ن نُوحْ، ؤُڒَا أَكْ-ذ ثَامْغَارْثْ ن نُوحْ ؤُ أَكْ-ذ ثْڒَاثَا ن ثمْغَارِينْ ن إِحنْجِيرنْ نّسْ أَكِيذْسنْ، ");
INSERT INTO rifa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","نِيثْنِي ذ مَارَّا مَارْكَاثْ ن ڒْمَاڒْ ن ڒخْڒَا ذ مَارَّا مَارْكَاثْ ن ڒبْهَايمْ ذ مَارَّا مَارْكَاثْ ن إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ ذ مَارَّا مَارْكَاثْ ن إِجْضَاضْ، مَارَّا أَجْضِيضْ، ذ مَارَّا مِينْ غَارْ إِدْجَا أَفْرِيونْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","زِي مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ إِ ذِي إِدْجَا أَرُّوحْ ن ثُوذَارْثْ، ثُوسَا-د ثْيُويَا س ثْيُويَا غَارْ نُوحْ غَارْ ؤُغَارَّابُو. ");
INSERT INTO rifa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ؤُ زِي مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ إِ د-يُوسِينْ، يُوذفْ إِجّْ ن ووْثمْ ذ إِشْثْ ن ثوْثمْثْ أَمْ مَامّشْ ث يُومُورْ أَربِّي، ؤُشَا إِقّنْ سِيذِي ثَاوَّارْثْ أَوَارْنِي أَسْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ثُوغَا سّحْڒثْ خْ ثمُّورْثْ أَربْعِينْ ن وُوسَّانْ ؤُشَا ڭعّْذنْ وَامَانْ ؤُشَا سّْڭعّْذنْ أَغَارَّابُو أَڒَامِي إِڭعّذْ سنّجْ إِ وُوذمْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ڭعّْذنْ وَامَانْ ؤُشَا مَّارنْينْ-د أَطَّاسْ سنّجْ إِ ثمُّورْثْ ؤُشَا يُويُورْ ؤُغَارَّابُو خْ وُوذمْ ن وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ڭعّْذنْ أَمَانْ أَطَّاسْ س وَاطَّاسْ، أَڒَامِي مَارَّا إِذُورَارْ يُوعْڒَانْ إِ ذِينْ إِدْجَانْ سَاذُو مَارَّا أَجنَّا، ذوْڒنْ ذْڒِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ؤُڒْينْ وَامَانْ خمّسْطَاشْ ن إِغَادْجنْ سنّجْ إِ إِذُورَارْ ؤُشَا ذْڒِينْ إِذُورَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ إِ إِتّنْهزَّانْ خْ ثمُّورْثْ إِضْڒقْ إِ بُوحْبڒْ نّسْ، إِجْضَاضْ ذ ڒبْهَايمْ، ڒْمَاڒْ ن ڒخْڒَا، مَارَّا إِمُودَّارنْ إِتّْبُوعنْ، إِنِّي إِتّْبُوعنْ خْ وُوذمْ ن ثمُّورْثْ ؤُڒَا ذ مَارَّا إِوْذَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","مَارَّا مِينْ ذِي إِدْجَا ڒعْوِينْ ن أَرُّوحْ ن ثُوذَارْثْ غَارْسنْ ذڭْ ونْزَارنْ نْسنْ زِي مَارَّا مِينْ ذِينْ إِدْجَانْ خْ ڒْبَارّْ، إِمُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ؤُشَا مَارَّا مِينْ ذِينْ إِدْجَانْ خْ وُوذمْ ن ثمُّورْثْ إِتّْوَامْحَا، زِي بْنَاذمْ أَڒْ ڒْمَاڒْ ذ إِمُودَّارنْ إِنِّي إِتّْبُوعنْ ذ إِجْضَاضْ ن ؤُجنَّا. إِنَا تّْوَاثحَّانْ زِي ثمُّورْثْ. نُوحْ وحّْذسْ إِ إِقِّيمنْ ذ مَارَّا مِينْ كِيذسْ إِ إِدْجَانْ ذڭْ ؤُغَارَّابُو. ");
INSERT INTO rifa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ڭعّْذنْ وَامَانْ خْ ثمُّورْثْ مْيَا ؤُ-خمْسِينْ ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ؤُشَا إِخَارّصْ أَربِّي ذِي نُوحْ ؤُ ذِي مَارَّا ڒْمَاڒْ ن ڒخْڒَا ذ مَارَّا ڒبْهَايمْ إِ ثُوغَا أَكِيذسْ ذڭْ ؤُغَارَّابُو. إِڭَّا أَربِّي أَذْ يكّْ إِجّْ ن ؤُسمِّيضْ خْ ثمُّورْثْ أَڒَامِي أَرْسَانْ وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","بلّْعنْثْ ڒْعُونْصَارَاثْ ن وَامَانْ إِهوْڒنْ ذ ثْبُورْجَاثِينْ ن ؤُجنَّا ؤُشَا إِبدّْ ونْژَارْ زڭْ ؤُجنَّا. ");
INSERT INTO rifa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ؤُشَا، أَمْ د-تَّاسنْ تّْرَاحنْ، ذوْڒنْ-د وَامَانْ زِي ثمُّورْثْ. أَوَارْنِي مْيَا ؤُ-خمْسِينْ ن وُوسَّانْ نقْصنْ وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ذڭْ ؤُيُورْ وِيسّْ سبْعَا، ذڭْ وَاسّْ وِيسّْ سْبعْطَاشْ ن ؤُيُورْ نِّي، يَارْسَا ؤُغَارَّابُو خْ إِذُورَارْ ن أَرَارَاثْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","قِّيمنْ وَامَانْ نقّْصنْ أَڒْ أَيُورْ وِيسّْعشْرَا. ذڭْ ؤُيُورْ وِيسّْعشْرَا، ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ، ضْهَارنْثْ-إِ-د ثْقِيشَّاثِينْ ن إِذُورَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","أَوَارْنِي ڒَامِي عْذُونْ أَربْعِينْ ن وُوسَّانْ، يَارْزمْ نُوحْ ثابُورْجثْ ن ؤُغَارَّابُو نِّي ذَايسْ ثُوغَا إِڭَّا، ");
INSERT INTO rifa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ؤُشَا إِسّكّْ أَبَاغڒْ. وَانِيثَا إِفّغْ، إِقِّيمْ إِتّْرَاحْ إِتَّاسْ-د أَڒَامِي بْذَانْ وَامَانْ تَّاژْغنْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","خنِّي إِسّكّْ سّنِّي ثَاذْبِيرْثْ، حِيمَا أَذْ إِژَارْ، مَا أَمَانْ نقْصنْ خْ وُوذمْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","مَاشَا وَارْ ثُوفِي ثذْبِيرْثْ مَانِي غَا ثسَّارْسْ ثَاڒقَّا ن ؤُضَارْ نّسْ ؤُشَا ثعْقبْ-د غَارسْ غَارْ ؤُغَارَّابُو، مِينْزِي أَمَانْ ثُوغَا أَثنْ عَاذْ خْ وُوذمْ ن مَارَّا ثَامُّورْثْ. إِسّْوِيژّضْ أَفُوسْ نّسْ، إِطّفْ إِ-ت ؤُشَا إِسِّيذفْ إِ-ت-إِ-د غَارسْ ذڭْ ؤُغَارَّابُو. ");
INSERT INTO rifa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","إِرَاجَا عَاذْ سبْعَا ن وُوسَّانْ نّغْنِي، خنِّي إِسّكّْ ثَاذْبِيرْثْ عَاوذْ زڭْ ؤُغَارَّابُو. ");
INSERT INTO rifa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ؤُشَا ثَاذْبِيرْثْ ثعْقبْ-د غَارسْ غَارْ ثْمذِّيثْ، ؤُ خْزَارْ، أَقَا أَفَارْ ن زِّيثُونْ ذڭْ ؤُقمُّومْ نّسْ. خنِّي إِفْهمْ نُوحْ بلِّي أَمَانْ نقْصنْ زِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","إِرَاجَا عَاذْ سبْعَا ن وُوسَّانْ، خنِّي إِسّكّْ ثَاذْبِيرْثْ عَاوذْ ؤُشَا نتَّاثْ وَارْ غَارسْ د-ثعْقِيبْ عَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ذڭْ ؤُسڭّْوَاسْ وِيسّْ ستَّا-مْيَا ؤُ-وَاحِيثْ ن نُوحْ، ذڭْ ؤُيُورْ أَمزْوَارُو، ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ نِّي، ؤُژْغنْ وَامَانْ خْ ثمُّورْثْ. إِكْسِي نُوحْ ثَاوَّارْثْ ن ؤُسقَّافْ ن ؤُغَارَّابُو، إِخْزَارْ غَارْ بَارَّا، ؤُشَا خْزَارْ، ؤُذمْ ن ثمُّورْثْ أَقَا يُوژغْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ذڭْ ؤُيُورْ وِيسّْ ثْنَاينْ، ذڭْ وَاسّْ وِيسّْ سبْعَا ؤُ-عِيشْرِينْ ن ؤُيُورْ نِّي، ثُوژغْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","خنِّي إِسِّيوڒْ أَربِّي أَكْ-ذ نُوحْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","”فّغْ زڭْ ؤُغَارَّابُو، شكْ ذ ثمْغَارْثْ نّشْ ذ إِحنْجِيرنْ نّشْ ذ ثمْغَارِينْ ن إِحنْجِيرنْ نّشْ أَكِيذكْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","مَارَّا مِينْ إِدَّارنْ إِ إِدْجَانْ أَكِيذكْ، زِي مَارَّا مِينْ غَارْسنْ أَرِّيمثْ ن ويْسُومْ، زڭْ إِجْضَاضْ، زِي ڒْمَاڒْ ؤُ زِي مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ، أجّْ إِ-ثنْ أَذْ فّْغنْ أَكِيذكْ، أجّْ إِ-ثنْ أَذْ مْطَارَّاشنْ خْ ثمُّورْثْ، أَذْ أَرّنْ ڒْغِيدْجثْ ؤُشَا أَذْ مَّارنْينْ خْ ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","إِفّغْ نُوحْ ذ إِحنْجِيرنْ نّسْ ذ ثمْغَارْثْ نّسْ ذ ثمْغَارِينْ ن إِحنْجِيرنْ نّسْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","مَارَّا ڒْمَاڒْ ن ڒخْڒَا، مَارَّا مِينْ إِتّْبُوعنْ، ذ مَارَّا إِجْضَاضْ، ذ مَارَّا مِينْ إِتّنْهزَّانْ خْ ثمُّورْثْ فّْغنْ زڭْ ؤُغَارَّابُو عْلَاحْصَابْ ڒَادْجَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","إِبْنَا نُوحْ إِجّْ ن ؤُعَالْطَارْ إِ سِيذِي ؤُشَا إِكْسِي زِي مَارَّا ڒْمَاڒْ ن ڒحْڒَاڒْ ؤُ زِي مَارَّا إِجْضَاضْ ن ڒحْڒَاڒْ ؤُشَا إِقدّمْ ثِيغَارْصَا ن وشْمَاضْ خْ ؤُعَالْطَارْ.    ");
INSERT INTO rifa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ؤُشَا إِشمّْ سِيذِي ڒفْوَاحثْ إِتّْفُوحنْ ؤُشَا إِنَّا سِيذِي ذڭْ وُوڒْ نّسْ: ”وَارْ تّْعِيقِّيبغْ عَاذْ أَذْ نعْڒغْ ثَامُّورْثْ خْ سِّيبّثْ ن بْنَاذمْ، مِينْزِي مِينْ د-إِتّفّْغنْ زڭْ وُوڒْ ن بْنَاذمْ ذ أَعفَّانْ وَاهَا زِي ثمْژِي نّسْ. وَارْ تّْعِيقِّيبغْ عَاذْ أَذْ وْثغْ مَارَّا مِينْ إِدَّارنْ أَمْ مَامّشْ ڭِّيغْ. ");
INSERT INTO rifa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","مَارَّا ؤُسَّانْ إِ غَا ثقِّيمْ ثمُّورْثْ ثدْجَا، أَذْ ثِيڒِي ثْيَارْزَا ذ ثْميْرَا، ثصْمضْ ذ ڒحْمُو، أَنبْذُو ذ ڒْمشْثَا ؤُشَا أَسّْ ذ دْجِيڒثْ وَارْ تّْبذِّينْ عمَّارْصْ.“    ");
INSERT INTO rifa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","خنِّي إِبَاركْ أَربِّي نُوحْ ذ إِحنْجِيرنْ نّسْ ؤُشَا إِنَّا أَسنْ: ”جّمْ-د ڒْغِيدْجثْ، مَارنْيمْ ؤُعمَّارمْ ثَامُّورْثْ! ");
INSERT INTO rifa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ثِيڭّْوُوذِي ذ ڒْعُورّثْ زِي كنِّيوْ أَذْ إِڒِينْثْ خْ مَارَّا ڒْمَاڒْ ن ڒخْڒَا، خْ مَارَّا إِجْضَاضْ ن ؤُجنَّا ؤُ خْ مَارَّا مِينْ إِتّْبُوعنْ خْ ثمُّورْثْ ؤُ خْ مَارَّا إِسڒْمَانْ ذِي ڒبْحَارْ: أَقَا مّوْشنْ ذڭْ ؤُفُوسْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","مَارَّا مِينْ إِتّْبُوعنْ، مِينْ إِدَّارنْ، أَذْ أَومْ يِيڒِي ذ مَاشَّا. نشّْ أَذْ أَومْ ث وْشغْ مَارَّا، أَمْ ذ أَومْ وْشِيغْ أَفْسُو أَزِيزَا، ");
INSERT INTO rifa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","مَاشَا أَيْسُومْ أَكْ-ذ بُوحْبڒْ نّسْ إِ إِدْجَانْ ذ إِذَامّنْ نّسْ، وَارْ ثنْ تّتّمْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ذ ثِيذتّْ أَذْ تَّارغْ إِذَامّنْ نْومْ ن ڒعْمُورْ نْومْ، أَذْ ثنْ تَّارغْ زڭْ إِفَاسّنْ ن مَارَّا إِمُودَّارنْ، ؤُڒَا زڭْ إِفَاسّنْ ن بْنَاذمْ، ؤُ زڭْ إِفَاسّنْ ن ؤُمَاسْ ن كُوڒْ إِجّنْ أَذْ تَّارغْ ڒعْمَارْ ن بْنَاذمْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","وِي غَا إِسِّيزّْڒنْ إِذَامّنْ ن بْنَاذمْ، إِذَامّنْ نّسْ أَذْ ثنْ سِّيزّْڒنْ س ؤُفُوسْ ن بْنَاذمْ، مِينْزِي أَربِّي إِڭَّا بْنَاذمْ ذِي صِّيفثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ؤُ كنِّيوْ، جّمْ-د ڒْغِيدْجثْ، ذوْڒمْ ذڭْ وَاطَّاسْ، مْطَارّْشمْ ذِي ثمُّورْثْ ؤُشَا ذوْڒمْ ذڭْ وَاطَّاسْ خَاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ؤُشَا إِسِّيوڒْ أَربِّي أَكْ-ذ نُوحْ ذ إِحنْجِيرنْ نّسْ نِّي غَارسْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","”نشّْ، خْزَارْ، نشّْ تّڭّغْ ڒْعَاهْذْ إِنُو أَكِيذْومْ ؤُ أَكْ-ذ زَّارِيعثْ نْومْ أَوَارْنِي أَومْ، ");
INSERT INTO rifa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ؤُ أَكْ-ذ مَارَّا بُوحْبڒْ إِدَّارنْ نِّي إِدْجَانْ أَكِيذْومْ، أَكْ-ذ إِجْضَاضْ، أَكْ-ذ ڒْمَاڒْ ؤُ أَكْ-ذ مَارَّا ڒْمَاڒْ ن ڒخْڒَا خْ ثمُّورْثْ إِنِّي أَكِيذْومْ، وَاهْ، أَكْ-ذ مَارَّا مِينْ د-إِفّْغنْ زڭْ ؤُغَارَّابُو أَڒْ مَارَّا مِينْ إِدَّارنْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","أَذْ ڭّغْ ڒْعَاهْذْ إِنُو أَكِيذْومْ، أَقَا مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ وَارْ تّْوَاكسِّينْ عَاذْ س وَامَانْ ن سّحْڒثْ، ؤُ وَارْ ذِينْ ثتِّيڒِي عَاذْ سّحْڒثْ إِ غَا يَاردّْدْجنْ ثَامُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","خنِّي إِنَّا أَربِّي: ”ذ ثَا أَذْ ثِيڒِي ذ ڒعْڒَامثْ ن ڒْعَاهْذْ ثنِّي إِ غَا ڭّغْ جَارْ أَيِي ذ كنِّيوْ ذ مَارَّا ڒعْمَارْ إِدَّارنْ أَكِيذْومْ، إِ مَارَّا جِّيڒَاثْ إِ ڒبْذَا: ");
INSERT INTO rifa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","أَذْ ڭّغْ ڒْقوْسْ إِنُو ذڭْ إِسيْنُوثنْ ونِّي إِ غَا يِيڒِينْ ذ ڒعْڒَامثْ ن ڒْعَاهْذْ جَارْ أَيِي ذ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","خْمِي غَا بْضِيغْ إِسيْنُوثنْ خْ ثمُّورْثْ، خنِّي أَذْ إِمْسَارْ بلِّي ڒْقوْسْ-أَ أَذْ د-إِضْهَارْ ذڭْ إِسيْنُوثنْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","خنِّي أَذْ إِذَارغْ ڒْعَاهْذْ إِنُو جَارْ أَيِي ذ كنِّيوْ ذ مَارَّا ڒعْمَارْ إِدَّارنْ ن مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ. وَارْ د-دِّيكّْوِيڒنْ وَامَانْ ذ سّحْڒثْ عَاوذْ، مَاحنْذْ أَذْ سّْغَارْقنْ مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","أَذْ د-إِضْهَارْ ڒْقوْسْ ذڭْ إِسيْنُوثنْ، ؤُشَا نشّْ أَذْ ث ژَترغْ حِيمَا أَذْ إِذَارغْ ڒْعَاهْذْ إِ ڒبْذَا جَارْ أَربِّي ذ مَارَّا ڒعْمَارْ إِدَّارنْ ذِي مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ إِ إِدْجَانْ خْ ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ؤُشَا إِنَّا أَربِّي إِ نُوحْ: ”ذ ثَا ذ ڒعْڒَامثْ ن ڒْعَاهْذْ إِنُو ونِّي إِ غَا ڭّغْ جَارْ أَيِي ذ مَارَّا إِمدَّارنْ س أَرِّيمثْ ن ويْسُومْ إِ إِدْجَانْ خْ ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ثَارْوَا ن نُوحْ إِنِّي د-إِفّْغنْ زڭْ ؤُغَارَّابُو ثُوغَا أَثنْ ذ شَامْ ذ حَامْ ذ يَافَاثْ. حَامْ ثُوغَا ذ بَابَاسْ ن كنْعَانْ.    ");
INSERT INTO rifa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","إِنَا ذ ثْڒَاثَا ن إِحنْجِيرنْ ن نُوحْ. زَّايْسنْ تّْوَابزّْعنْ إِوْذَانْ ذِي مَارَّا ثَامُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","إِبْذَا نُوحْ إِخدّمْ أَمْ ؤُفدْجَاحْ، إِژُّو ثِيزَايَارِينْ ذڭْ ؤُمَارْجعْ ن ؤُضِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ؤُمِي إِسْوَا بِينُو، إِسْشَارْ ؤُشَا إِعَارَّا إِخفْ نّسْ ذِي ڒْوسْطْ ن ؤُقِيضُونْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","إِژْرَا حَامْ، بَابَاسْ ن كنْعَانْ، ثُوعَّارْينْثْ ن بَابَاسْ ؤُشَا إِنَّا ث إِ ثْنَاينْ ن أَيْثْمَاسْ ذِي بَارَّا. ");
INSERT INTO rifa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","كْسِينْ شَامْ ذ يَافَاثْ شَا ن ورُّوضْ، سَّارْسنْ ث خْ ثْغَارْضِينْ ن ثْنَاينْ إِذْسنْ نْسنْ ؤُشَا ؤُيُورنْ غَارْ ضفَّارْ، ذْڒِينْ ثُوعَّارْينْثْ ن بَابَاثْسنْ. أَرِّينْ أَغمْبُوبْ نْسنْ غَارْ ضفَّارْ، وَارْ ژْرِينْ شَا ثُوعَّارْينْثْ ن بَابَاثْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","إِفَاقْ-د نُوحْ زِي سّكْرَا نّسْ ؤُشَا إِذْوڒْ يَارْڭبْ خْ مِينْ ذ أَسْ إِڭَّا مِّيسْ أَمَاژُوژْ. ");
INSERT INTO rifa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","إِنَّا: ”ذ أَمنْعُوڒْ إِ يدْجَا كنْعَانْ! أَذْ يِيڒِي ذ أَمْسخَّارْ قَاعْ ن إِمْسخَّارنْ إِ أَيْثْمَاسْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ؤُشَا إِنَّا: ”أَذْ إِتّْوَابَاركْ سِيذِي، أَربِّي ن شَامْ. كنْعَانْ أَذْ يِيڒِي ذ أَمْسخَّارْ إِ نِيثْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","زعْمَا أَذْ إِوسّعْ أَربِّي ثَازذِّيغْثْ إِ يَافَاثْ، أَذْ إِزْذغْ ذڭْ إِقِيضَانْ ن شَامْ، ؤُ كنْعَانْ أَذْ أَسنْ يِيڒِي ذ أَمْسخَّارْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","أَوَارْنِي سّحْڒثْ إِدَّارْ نُوحْ عَاذْ ثڒْثْ-مْيَا ؤُ-خمْسِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","أَمُّو إِ إِدَّارْ نُوحْ ثسْعَا-مْيَا ؤُ-خمْسِينْ ن إِسڭّْوُوسَا، خنِّي إِمُّوثْ. إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زڭْ أَيْثْ ن نُوحْ: شَامْ، حَامْ ذ يَافَاثْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","تّْوَارْونْ أَسنْ-د إِحنْجِيرنْ أَوَارْنِي إِ سّحْڒثْ.   * ");
INSERT INTO rifa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","أَيْثْ ن يَافَاثْ ثُوغَا أَثنْ ذ جُومَارْ، مَاجُوجْ، مَاذَايْ، يَاوَانْ، ثُوبَالْ، مَاشِيكْ ذ ثِيرَاسْ.    ");
INSERT INTO rifa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","إِحنْجِيرنْ ن جُومَارْ، ثُوغَا أَثنْ ذ أَشْكَانَازْ، رِيفَاثْ ذ ثُوجَارْمَا. ");
INSERT INTO rifa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","إِحنْجِيرنْ ن يَاوَانْ ثُوغَا أَثنْ ذ إِلِيشَا، ثَارْشِيشْ ذ إِكِيتِّييّنْ ذ إِذُوذَانِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","زَّايْسنْ إِ تّْوَابْضَانْثْ ثڭْزِيرِينْ ن ڒڭْنُوسْ ذِي ثمُّورَا نْسنْ، كُوڒْ إِجّنْ عْلَاحْسَابْ إِڒسْ نّسْ ؤُشَا مَارَّا عْلَاحْسَابْ ڒَادْجْ نْسنْ ؤُ ذِي ڒڭْنُوسْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","أَيْثْ ن حَامْ ثُوغَا أَثنْ ذ كُوشْ، مِيصْرَايِيمْ، فُوطْ ذ كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","إِحنْجِيرنْ ن كُوشْ ثُوغَا أَثنْ ذ سبَا، حَاوِيلَا، سَابْثَا، رَاعَامَا ذ سَابْثَاكَا. إِحنْجِيرنْ ن رَاعَامَا ثُوغَا أَثنْ ذ شَابَا ذ ذَاذَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","كُوشْ إِجَّا-د نِيمْرُوذْ. وَانِيثَا إِبْذَا أَذْ يِيڒِي ذ جِّيهڒْ ذِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","وَا ثُوغَا ذ أَنڭْمَارْ ذ أَمقّْرَانْ زَّاثْ إِ وُوذمْ ن سِيذِي. خْ ؤُيَا قَّارنْ: ’أَنڭْمَارْ أَمقّْرَانْ أَمْ نِيمْرُوذْ زَّاثْ إِ وُوذمْ ن سِيذِي.‘ ");
INSERT INTO rifa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","أَمزْوَارْ ن ثْڭلْذِيثْ نّسْ ثُوغَا أَثنْثْ ذ ثِيندَّامْ ن بَابِيلْ ذ إِرِيخْ ذ أَكَّاذْ ذ كَالْنَا ذِي ثمُّورْثْ ن شِينْعَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","زِي ثمُّورْثْ نِّي د-إِفّغْ غَارْ أَشُّورْ ؤُشَا إِبْنَا ذِينْ نِينْوَا، رِيحُوبُوثْ-عِيرْ ذ كَالَاحْ ");
INSERT INTO rifa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ذ رِيسِينْ جَارْ نِينْوَا ذ كَالَاحْ، نتَّاثْ ذ ثَانْذِينْثْ ثَامقّْرَانْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","مِيصْرَايِيمْ إِجَّا-د إِلُوذِييّنْ، إِعَانَامِييّنْ، إِلَاهَابِييّنْ، إِنَافْثُوحِييّنْ، ");
INSERT INTO rifa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","إِفَاثْرُوسِييّنْ، إِكَاسْلُوحِييّنْ، إِنِّي زِي د-إِقَّارْصنْ إِفِيلِيسْطِينِييّنْ، ؤُڒَا ذ إِكَافْثُورِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","كنْعَانْ إِجَّا-د صِيذُونْ، أَمنْزُو نّسْ، ذ حِيثْ ");
INSERT INTO rifa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ذ ؤُيابُوسِي ذ ؤُمُورِي ذ ؤُجِيرْجَاشِي ");
INSERT INTO rifa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ذ ؤُحِيوِي ذ ؤُعَارْقِي ذ ؤُسِينِي ");
INSERT INTO rifa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ذ ؤُرْوَاذِي ذ ؤُصَامَارِي ذ ؤُحَامَاثِي. أَوَارْنِي أَسْ مْبزّْعنْثْ مَارَّا ڒَادْجَاثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ثُوغَا أَيْمِيرْ ن أَيْثْ ن كنْعَانْ زِي صِيذُونْ غَارْ خِيرَارْ أَڒْ غَازَّا ؤُ سّنِّي غَارْ سَاذُومْ ذ عَامُورَّا ذ أَذْمَا ذ صابُويِيمْ أَڒْ لَاشَاعْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","إِنَا ذ أَيْثْ ن حَامْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ إِڒْسَاونْ نْسنْ، ذِي ثِيمُّورَا نْسنْ ؤُ أَكْ-ذ ڒڭْنُوسْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","إِ شَامْ، ونِّي ذ جدّْ ن مَارَّا أَيْثْ ن عَابِيرْ، ؤُمَاسْ ن يَافَاثْ، أَمقّْرَانْ، تّْوَارْونْ أَسْ-د عَاوذْ إِحنْجِيرنْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","إِحنْجِيرنْ ن شَامْ ثُوغَا أَثنْ ذ عِيلَامْ، أَشُّورْ، أَرْفَاكْشَاذْ، لُوذْ ذ أَرَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","إِحنْجِيرنْ ن أَرَامْ ثُوغَا أَثنْ ذ عُوصْ ذ حُولْ ذ جَاثِيرْ ذ مَاشْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","أَرْفَاكْشَاذْ إِجَّا-د شَالَاحْ ؤُ شَالَاحْ إِجَّا-د عَابِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","تّْوَارْونْ-د إِ عَابِيرْ ثْنَاينْ ن إِحنْجِيرنْ. إِجّنْ قَّارنْ أَسْ فَالَاجْ، مِينْزِي ذڭْ وُوسَّانْ نّسْ ثتّْوَافدْجقْ ثمُّورْثْ، ؤُ قَّارنْ أَسْ إِ ؤُمَاسْ يُوقْطَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","يُوقْطَانْ إِجَّا-د أَلْمُوذَاذْ، شَالَافْ، هَاضَارْمَاوْثْ، يَارَاحْ، ");
INSERT INTO rifa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","هَاذُورَامْ، ؤُزَالْ، ذِيقْلَا، ");
INSERT INTO rifa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","عُوبَالْ، أَبِيمَايِيلْ، شَابَا، ");
INSERT INTO rifa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ؤُفِيرْ، حَاوِيلَا ذ يُوبَابْ. مَارَّا إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن يُوقْطَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ثَامُّورْثْ مَانِي ثُوغَا زدّْغنْ ثُوغَا-ت زِي مِيشَا أَڒْ سَافَارْ، أَذْرَارْ ن شَّارْقْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","إِنَا ذ أَيْثْ ن شَامْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ ؤُ عْلَاحْسَابْ إِڒْسَاونْ نْسنْ، ذِي ثمُّورَا نْسنْ ؤُ أَكْ-ذ ڒڭْنُوسْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ثِينَا ذ ڒَادْجَاثْ ن إِحنْجِيرنْ ن نُوحْ، عْلَاحْسَابْ مَامّشْ د-خڒْقنْ، أَكْ-ذ ڒڭْنُوسْ نْسنْ. زَّايْسنْ إِ زِي تّْوَابْضَانْ ڒڭْنُوسْ ذِي ثمُّورْثْ أَوَارْنِي إِ سّحْڒثْ. * ");
INSERT INTO rifa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ثُوغَا مَارَّا ثَامُّورْثْ س يِيڒسْ ذ إِجّنْ ؤُ س ڒْهَارْذْ ذ إِجّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","إِمْسَارْ ڒَامِي فسْينْ إِقِيضَانْ نْسنْ ؤُشَا فّْغنْ-د زِي شَّارْقْ، ؤُفِينْ إِجّْ ن ڒوْضَا ذِي ثمُّورْثْ ن شِينْعَارْ، ؤُشَا قِّيمنْ زدّْغنْ ذِينِّي. ");
INSERT INTO rifa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","نِيثْنِي نَّانْ، كُوڒْ إِجّْ إِ ونّغْنِي: ”أَرَاحمْ-د، أَذْ نڭّْ إِژْرَا زِي ثْڒَاخْثْ، أَذْ ثنْ نسّحْمَا!“ أَمُّو إِ ذ أَسنْ ثذْوڒْ ثْڒَاخْثْ ذ أَژْرُو ؤُ أَشَارْمُوضْ إِذْوڒْ غَارْسنْ ذ ثَارِّيسْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","خَاسْ ؤُشَا نَّانْ: ”زِيذْ، أَذْ نبْنَا إِشْثْ ن ثنْذِينْثْ ذ إِشْثْ ن صُّومْعثْ، ثَاقِيشَّاثْ نّسْ أَذْ د-ثَاوضْ غَارْ ؤُجنَّا، ؤُ جّمْ أَنغْ أَذْ نڭّْ إِجّْ ن يِيسمْ إِ نشِّينْ، حِيمَا وَارْ نتّمْسبْضِي شَا خْ وُوذمْ ن مَارَّا ثَامُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","خنِّي إِهْوَا-د سِيذِي، حِيمَا أَذْ إِژَارْ ثَانْذِينْثْ ذ صُّومْعثْ نِّي بْنَانْ ثَارْوَا ن بْنَاذمْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","إِنَّا سِيذِي: ”خْزَارْ، أَقَا أَثنْ ذ ڒْڭنْسْ ذ إِجّنْ ؤُ مَارَّا إِنَا غَارْسنْ إِجّْ ن يِيڒسْ. وَا ذ بدُّو ن مِينْ غَا ڭّنْ. ڒخُّو وَارْ ذِينْ مِينْ ثنْ إِ غَا إِسّْبدّنْ خْ وبْرِيذْ نْسنْ نِّي نْوَانْ أَذْ ڭّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","أَرَاحمْ-د، أَذْ نهْوَا ؤُشَا أَذْ نسّْخَارْوضْ إِڒسْ نْسنْ، حِيمَا كُوڒْ إِجّنْ وَارْ إِفهّمْ عَاذْ إِڒسْ ن ونِّي ث يُوذْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","أَمُّو إِ ثنْ إِزُّوزَارْ سِيذِي سّنِّي خْ وُوذمْ ن مَارَّا ثَامُّورْثْ ؤُشَا سّْبدّنْ ڒبْنِي ن ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","خْ ؤُيَا إِ ذ أَسْ ڒَاغَانْ إِ ثنْذِينْثْ نِّي س يِيسمْ ن ’بَابِيلْ‘، مِينْزِي ذِينْ إِسّْخَارْوضْ سِيذِي إِڒسْ ن مَارَّا ثَامُّورْثْ ؤُ سّنِّي إِ ثنْ إِزُّوزَارْ سِيذِي خْ وُوذمْ ن مَارَّا ثَامُّورْثْ. إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي شَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ؤُمِي ثُوغَا غَارْ شَامْ مْيَا ن إِسڭّْوُوسَا، إِجَّا-د أَرْفَاكْشَاذْ، ثْنَاينْ ن إِسڭّْوُوسَا أَوَارْنِي إِ سّحْڒثْ.    ");
INSERT INTO rifa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","أَوَارْنِي ڒَامِي د-إِجَّا أَرْفَاكْشَاذْ، إِدَّارْ شَامْ عَاذْ خمْسَا-مْيَا ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","إِدَّارْ أَرْفَاكْشَاذْ خمْسَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د شَالَاحْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","أَوَارْنِي ڒَامِي د-إِجَّا أَرْفَاكْشَاذْ شَالَاحْ، إِدَّارْ عَاذْ أَربْعَا-مْيَا ؤُ-ثْڒَاثَا ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","إِدَّارْ شَالَاحْ ثْڒَاثِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د عَابِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","أَوَارْنِي ڒَامِي د-إِجَّا شَالَاحْ عَابِيرْ، إِدَّارْ عَاذْ أَربْعَا-مْيَا ؤُ-ثْڒَاثَا ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","إِدَّارْ عَابِيرْ أَربْعَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د فَالَاجْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","أَوَارْنِي ڒَامِي د-إِجَّا فَالَاجْ، إِدَّارْ عَابِيرْ عَاذْ أَربْعَا-مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","إِدَّارْ فَالَاجْ ثْڒَاثِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د رَاعُووْ.    ");
INSERT INTO rifa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","أَوَارْنِي ڒَامِي د-إِجَّا رَاعُووْ، إِدَّارْ فَالَاجْ عَاذْ مِيثَاينْ ؤُ-ثسْعَا ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","إِدَّارْ رَاعُووْ ثْنَاينْ ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د سَارُوجْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","أَوَارْنِي ڒَامِي د-إِجَّا سَارُوجْ، إِدَّارْ رَاعُووْ عَاذْ مِيثَاينْ ؤُ-سبْعَا ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","إِدَّارْ سَارُوجْ ثْڒَاثِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د نَاحُورْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","أَوَارْنِي ڒَامِي د-إِجَّا نَاحُورْ، إِدَّارْ سَارُوجْ عَاذْ مِيثَاينْ ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","إِدَّارْ نَاحُورْ ثسْعَا ؤُ-عِيشْرِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د ثَارَاحْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","أَوَارْنِي ڒَامِي د-إِجَّا نَاحُورْ ثَارَاحْ، إِدَّارْ عَاذْ مْيَا ؤُ-ثسْعَاطَاشْ ن إِسڭّْوُوسَا، ؤُشَا إِجَّا-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","إِدَّارْ ثَارَاحْ سبْعِينْ ن إِسڭّْوُوسَا، خنِّي إِجَّا-د أَبْرَامْ، نَاحُورْ ذ هَارَانْ. إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي ثَارَاحْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ثَارَاحْ إِجَّا-د أَبْرَامْ، نَاحُورْ ذ هَارَانْ، ؤُ هَارَانْ إِجَّا-د لُوطْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","إِمُّوثْ هَارَانْ زَّاثْ إِ بَابَاسْ ثَارَاحْ ذِي ثمُّورْثْ مَانِي د-إِخْڒقْ نتَّا، ذِي ؤُرْ ن إِكَالْذَانِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ؤُشَا كْسِينْ أَبْرَامْ ذ نَاحُورْ إِ يِيخفْ نْسنْ ثِيمْغَارِينْ. إِسمْ ن ثمْغَارْثْ ن أَبْرَامْ ثُوغَا-ث ذ سَارَايْ ؤُ إِسمْ ن ثمْغَارْثْ ن نَاحُورْ ذ مِيلْكَا، يدْجِيسْ ن هَارَانْ، بَابَاسْ ن مِيلْكَا ذ يِيسْكَا. ");
INSERT INTO rifa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","سَارَايْ ثُوغَا-ت وَارْ د-ثتِّيرُووْ، ثُوغَا وَارْ غَارسْ بُو ؤُحنْجِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ؤُشَا إِكْسِي ثَارَاحْ أَبْرَامْ، مِّيسْ، ذ لُوطْ مِّيسْ ن هَارَانْ، مِّيسْ ن مِّيسْ، ذ سَارَايْ، ثَاسْڒِيثْ نّسْ، ثَامْغَارْثْ ن مِّيسْ أَبْرَامْ، ؤُشَا نِيثْنِي فّْغنْ جْمِيعْ زِي ؤُرْ ن إِكَالْذَانِييّنْ، حِيمَا أَذْ رَاحنْ غَارْ ثمُّورْثْ ن كنْعَانْ. إِوْضنْ غَارْ حَارَانْ ؤُشَا زدّْغنْ ذِينِّي.    ");
INSERT INTO rifa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ؤُمِي ثڭَّا ثَارَاحْ مِيثَاينْ ؤُ-خمْسَا ن إِسڭّْوُوسَا، إِمُّوثْ ثَارَاحْ ذِي حَارَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","إِنَّا سِيذِي إِ أَبْرَامْ: ”فّغْ زِي ثمُّورْثْ نّشْ، زِي ثمُّورْثْ مَانِي د-ثْخڒْقذْ ؤُ زِي ثَادَّارْثْ ن بَابَاشْ، رُوحْ غَارْ ثمُّورْثْ إِ ذ أَشْ غَا سّشْنغْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","أَذْ زَّايكْ د-سُّوفّْغغْ إِجّْ ن ڒْڭنْسْ إِمْغَارْ، أَذْ شكْ بَارْكغْ ؤُ أَذْ سّمْغَارغْ إِسمْ نّشْ ؤُشَا إِڒِي ذ شكْ عَاوذْ ذ لْبَارَاكَا. ");
INSERT INTO rifa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","أَذْ بَارْكغْ ونِّي شكْ إِ غَا إِبَارْكنْ ذ ونِّي شكْ إِ غَا إِنعْڒنْ، أَذْ ث نعْڒغْ. ذَايكْ إِ غَا تّْوَابَارْكنْثْ مَارَّا ڒَادْجَاثْ ن ثمُّورْثْ.“   * ");
INSERT INTO rifa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ؤُشَا إِرُوحْ أَبْرَامْ أَمْ مَامّشْ ذ أَسْ إِنَّا سِيذِي، ؤُشَا إِرُوحْ لُوثْ أَكِيذسْ. ثُوغَا أَبْرَامْ غَارسْ خمْسَا ؤُ-سبْعِينْ ن إِسڭّْوُوسَا ؤُمِي د-إِفّغْ زِي حَارَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ؤُشَا إِنْذهْ أَبْرَامْ سَارَايْ ثَامْغَارْثْ نّسْ، ذ لُوطْ مِّيسْ ن ؤُمَاسْ، ذ مَارَّا أَڭْڒَا إِ يَاربْحنْ، ذ إِوْذَانْ ذ ڒْمَاڒْ نِّي د-كسْبنْ ذِي حَارَانْ. فّْغنْ زِي حَارَانْ حِيمَا أَذْ رَاحنْ غَارْ ثمُّورْثْ ن كنْعَانْ ؤُشَا إِوْضنْ غَارْ ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","إِژْوَا أَبْرَامْ زِي ثمُّورْثْ نِّي غَارْ ومْشَانْ ن شَاكِيمْ أَڒْ ثَاشجَّارْثْ ن يِيڭّْ ن مُورَا. ذِي ڒْوقْثْ نِّي ثُوغَا أَيْثْ ن كنْعَانْ زدّْغنْ ذِي ثمُّورْثْ.    ");
INSERT INTO rifa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","إِبَانْ-د سِيذِي إِ أَبْرَامْ، إِنَّا أَسْ: ”إِ زَّارِيعثْ نّشْ ؤُمِي إِ غَا وْشغْ ثَامُّورْثْ-أَ.“ ؤُشَا إِبْنَا ذِينْ إِجّْ ن ؤُعَالْطَارْ مِينْ خفْ إِسَّارْسْ ثَاغَارْصْثْ إِ سِيذِي، ونِّي ذ أَسْ د-إِبَاننْ.    ");
INSERT INTO rifa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","خنِّي إِعْذُو سّنِّي غَارْ إِذُورَارْ إِ إِدْجَانْ خْ شَّارْقْ ن بَايْثْ-إِلْ ؤُشَا إِوْثَا ذِينِّي إِقِيضَانْ نّسْ، إِجَّا بَايْثْ-إِلْ خْ جِّيهثْ ن ڒْغَارْبْ ؤُ عَايْ خْ شَّارْقْ. ذِينْ إِبْنَا إِجّْ ن ؤُعَالْطَارْ إِ سِيذِي ؤُشَا إِڒَاغَا إِسمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","أَوَارْنِي مَانْ أَيَا إِفْسِي أَبْرَامْ إِقِيضَانْ نّسْ، إِمُّوطِّي زڭْ ومْشَانْ غَارْ ومْشَانْ، غَارْ ثمُّورْثْ ن لْجَانُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","إِذْوڒْ ڒَاژْ ذِي ثمُّورْثْ ؤُشَا إِكمّڒْ أَبْرَامْ خْ وبْرِيذْ نّسْ، إِهْوَا غَارْ مِيصْرَا، حِيمَا أَذْ إِزْذغْ ذِينْ أَمْ ؤُبَارَّانِي، مِينْزِي ثُوغَا ڒَاژْ إِمْغَارْ ذِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ڒَامِي د-ثِيوضْ ڒْوقْثْ نِّي ؤُمِي إِ غَا يُوذفْ غَارْ مِيصْرَا، إِنَّا إِ سَارَايْ، ثَامْغَارْثْ نّسْ: ”خْزَارْ، أَقَا سّْنغْ بلِّي شمْ ذ ثَامْغَارْثْ ذَايسْ أَژْرِي. ");
INSERT INTO rifa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","خْمِي شمْ إِ غَا ژَترنْ إِمِيصْرِييّنْ، زمَّارنْ أَذْ إِنِينْ: ’ثَا ذ ثَامْغَارْثْ نّسْ!‘، أَذْ أَيِي نْغنْ ؤُشَا أَذْ شمْ جّنْ ذِي ثُوذَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","إِنِي، أَقَا شمْ ذ ؤُتْشْمَا، حِيمَا أَذْ أَيِي يِيڒِي ڒْخِيرْ ذِي طّْوعْ نّمْ ؤُشَا أَذْ إِقِّيمْ ڒعْمَارْ إِنُو إِدَّارْ إِ شمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","إِمْسَارْ ؤُمِي يُوذفْ أَبْرَامْ غَارْ مِيصْرَا، ژْرِينْ إِمِيصْرِييّنْ بلِّي ثَامْغَارْثْ ثصْبحْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ؤُڒَا ذ ڒْحُوكَّامْ ن فِيرْعُونْ، أَجدْجِيذْ، ژْرِينْ ت ؤُشَا سّمْغَارنْ ت غَارْ فِيرْعُونْ ؤُشَا إِوْينْ ت غَارْ ثَادَّارْثْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ؤُشَا إِمْصُورفْ فِيرْعُونْ مْلِيهْ أَكْ-ذ أَبْرَامْ ذِي طّْوعْ نّسْ. أَمُّو إِ إِكْسِي ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ يغْيَاڒْ ذ إِسمْغَانْ ذ ثِييَّا ذ ثغْيَاڒْ ذ إِڒغْمَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","مَاشَا سِيذِي إِوْثَا فِيرْعُونْ ذ أَيْثْبَابْ ن ثَادَّارْثْ نّسْ س جّْرَايحْ مْغَارنْثْ ذِي ڒسْبَابْ ن سَارَايْ، ثَامْغَارْثْ ن أَبْرَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","خنِّي فِيرْعُونْ إِڒَاغَا-د إِ أَبْرَامْ، إِنَّا أَسْ: ”مَانَاوَايَا إِ ذَايِي ثڭِّيذْ؟ مَاغَارْ وَارْ ذ أَيِي ثنِّيذْ بلِّي نتَّاثْ ذ ثَامْغَارْثْ نّشْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","مَايمِّي ثنِّيذْ: ’نتَّاثْ ذ ؤُتْشْمَا!‘، أَڒَامِي ت ڭِّيغْ نشّْ ذ ثَامْغَارْثْ إِ يِيخفْ إِنُو؟ ڒخُّو خْزَارْ، أَقَا أَشْ ثَامْغَارْثْ نّشْ، كْسِي ت، ثْبعّْذذْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","يُومُورْ فِيرْعُونْ إِرْيَازنْ نّسْ خَاسْ ؤُشَا سّْقبّْضنْ ث أَكْ-ذ ثمْغَارْثْ نّسْ ؤُ أَكْ-ذ مَارَّا مِينْ ثُوغَا غَارسْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","أَمُّو إِ يُويُورْ أَبْرَامْ زِي مِيصْرَا غَارْ ثمُّورْثْ ن لْجَانُوبْ ن كنْعَانْ، نتَّا ذ ثمْغَارْثْ نّسْ، أَكْ-ذ مَارَّا مِينْ غَارسْ، ذ لُوطْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","أَبْرَامْ ثُوغَا غَارسْ أَطَّاسْ ن وَاڭْڒَا ذ ڒبْهَايمْ ذ نُّوقَارْثْ ذ وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ؤُشَا إِمُّوطِّي زڭْ ومْشَانْ غَارْ ومْشَانْ زِي ثمُّورْثْ ن لْجَانُوبْ غَارْ بَايْثْ-إِلْ أَڒْ أَمْشَانْ مَانِي ثُوغَا إِدْجَا ؤُقِيضُونْ نّسْ قْبڒْ، جَارْ بَايْثْ-إِلْ ذ عَايْ، ");
INSERT INTO rifa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","أَڒْ أَمْشَانْ ن ؤُعَالْطَارْ إِ ثُوغَا إِڭَّا قْبڒْ، مِينْ خفْ إِسَّارْسْ ثِيغَارْصَا ذ ثوْهِيبِينْ، ؤُشَا ذِينِّي إِڒَاغَا أَبْرَامْ إِسمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ؤُشَا لُوطْ، ونِّي يُويُورنْ أَكْ-ذ أَبْرَامْ، ثُوغَا غَارسْ عَاوذْ ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ إِقِيضَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ثَامُّورْثْ وَارْ ذ أَسنْ ثِيرِيوْ حِيمَا أَذْ قِّيمنْ زدّْغنْ جْمِيعْ، مِينْزِي أَڭْڒَا نْسنْ إِمْغَارْ أَطَّاسْ أَڒْ وَارْ زمَّارنْ أَذْ ذِينْ زذْغنْ جْمِيعْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ؤُشَا إِمْسَارْ ؤُمْشُوبّشْ جَارْ إِمكْسَاونْ ن ڒبْهَايمْ ن أَبْرَامْ ذ إِمكْسَاونْ ن ڒبْهَايمْ ن لُوطْ. ثُوغَا أَيْثْ ن كنْعَانْ ذ إِفِيرِيزِييّنْ زدّْغنْ ڒخْذنِّي ذِي ثمُّورْثْ.    ");
INSERT INTO rifa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","إِنَّا أَبْرَامْ إِ لُوطْ: ”وَارْ إِتِّيڒِي عَاذْ ؤُمْشُوبّشْ جَارْ أَيِي ذ شكْ، جَارْ إِمكْسَاونْ إِنُو ذ إِمكْسَاونْ نّشْ، مِينْزِي نشِّينْ ذ إِرْيَازنْ أَوْمَاثنْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","مَا وَارْ ثَارْزمْ ثمُّورْثْ زَّاثشْ؟ تّْزَاوْڭغْ شكْ أَذْ خَافِي ثبْضِيضْ، مَا خْ ؤُزڒْمَاضْ، نِيغْ خْ يفُوسْ! مَاڒَا شكْ ثْرُوحذْ خْ يفُوسْ، نشّْ أَذْ رَاحغْ خْ ؤُزڒْمَاضْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","إِسّْڭعّذْ لُوطْ ثَامُوغْڒِي نّسْ ؤُشَا إِژْرَا أَذوَّارْ ن يغْزَارْ ن لْ-ؤُرْذُونْ ثُوغَا مَارَّا إِسْوَا. قْبڒْ أَردّدْجْ زِي سِيذِي ثُوغَا سَاذُومْ ذ عَامُورَّا أَمْ جّنّثْ ن سِيذِي، أَمْ ثمُّورْثْ ن مِيصْرَا خْمِي د غَا ثَاسذْ غَارْ صُوغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ؤُشَا إِخْضَارْ لُوطْ إِ يِيخفْ نّسْ مَارَّا أَذوَّارْ ن يغْزَارْ ن لْ-ؤُرْذُونْ ؤُ إِفْسِي لُوطْ إِقِيضَانْ نّسْ ؤُشَا يُويُورْ غَارْ شَّارْقْ. أَمُّو إِ مّْسبْضَانْ نِيثْنِي إِجّنْ خْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","أَبْرَامْ إِزْذغْ ذِي ثمُّورْثْ ن كنْعَانْ، مَاشَا لُوطْ إِزْذغْ ذِي ثْندَّامْ ن ؤُذوَّارْ ن لْ-ؤُرْذُونْ، إِوْثَا إِقِيضَانْ نّسْ أَڒْ سَاذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","إِرْيَازنْ ن سَاذُومْ ثُوغَا أَثنْ ذ إِعفَّاننْ ذ إِمذْنَابْ أَكْ-ذ سِيذِي أَڒْ طَّارْفْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","أَوَارْنِي ڒَامِي خَاسْ إِمّْسبْضَا لُوطْ، إِنَّا سِيذِي إِ أَبْرَامْ: ”سَارّحْ ڒخُّو ثِيطَّاوِينْ نّشْ، ثخْزَارذْ زڭْ ومْشَانْ مَانِي ثدْجِيذْ غَارْ شَّامَالْ، غَارْ لْجَانُوبْ، غَارْ شَّارْقْ ؤُ غَارْ ڒْغَارْبْ، ");
INSERT INTO rifa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","مِينْزِي مَارَّا ثَامُّورْثْ إِ ثتّْوَاڒِيذْ، أَذْ أَشْ ت وْشغْ، إِ شكْ ذ زَّارِيعثْ نّشْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","أَذْ ڭّغْ زَّارِيعثْ نّشْ أَمْ ثْعجَّاجْثْ ن ثمُّورْثْ، حِيمَا، مَاڒَا إِزمَّارْ حذْ أَذْ إِحْسبْ ثَاعجَّاجْثْ ن ثمُّورْثْ، ؤُڒَا ذ زَّارِيعثْ نّشْ ثْزمَّارْ عَاوذْ أَذْ ثتّْوَاحْسبْ. ");
INSERT INTO rifa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","كَّارْ، شُوقْ ذِي ثمُّورْثْ ذِي ثُوزّڭَّارْثْ نّسْ ذ ثِيرُو نّسْ، مِينْزِي إِ شكْ ؤُمِي ت إِ غَا وْشغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","خنِّي إِكّسْ أَبْرَامْ إِقِيضَانْ نّسْ ؤُشَا يُويُورْ أَذْ إِزْذغْ غَارْ ثْشجُّورَا ن يِيڭّْ ن مَامْرِي، إِنِّي إِدْجَانْ ذِي حَابْرُونْ. ذِينِّي إِبْنَا إِجّْ ن ؤُعَالْطَارْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ذڭْ وُوسَّانْ ن أَمْرَافِيلْ، أَجدْجِيذْ ن شِينْعَارْ، ذ أَرِييُوشْ، أَجدْجِيذْ ن إِلَّاسَارْ، ذ كِيذُورْلَاعُومرْ، أَجدْجِيذْ ن عِيلَامْ، ذ ثِيذَالْ، أَجدْجِيذْ ن ڒڭْنُوسْ، إِمْسَارْ بلِّي ");
INSERT INTO rifa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","إِنَا ڭِّينْ ڒْبَارُوضْ أَكْ-ذ بِيرَا، أَجدْجِيذْ ن سَاذُومْ ؤُ أَكْ-ذ بِيرْشَاعْ، أَجدْجِيذْ ن عَامُورَّا، ؤُ أَكْ-ذ شِينَابْ، أَجدْجِيذْ ن أَذْمَا، ؤُ أَكْ-ذ شِيمْ‘إِبَارْ، أَجدْجِيذْ ن صابُويِيمْ، ؤُ أَكْ-ذ ؤُجدْجِيذْ ن بِيلَاعْ، ونِّي إِدْجَانْ ذ صُوغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","مَارَّا إِنَا مُوننْ ذِي ڒوْضَا ن ثغْزُورْثْ ن سِيذِّيمْ، أَقَا ذ ڒبْحَارْ أَمدْجَاحْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ثُوغَا خدّْمنْ ثنْعَاشْ ن إِسڭّْوُوسَا إِ كِيذُورْلَاعُومِيرْ، مَاشَا غَارْ ؤُسڭّْوَاسْ وِيسّْ ثْڒطَّاشْغوّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ؤُشَا ذڭْ ؤُسڭّْوَاسْ وِيسّْ أَرْبعْطَاشْ يُوسَا-د كِيذُورْلَاعُومِيرْ ذ إِجدْجِيذنْ إِ يدْجَانْ أَكِيذسْ ؤُشَاغڒْبنْ خْ إِرَافَاوِييّنْ ذِي أَشْثِيرُوثْ-قَارْنَايْمْ، خْ إِزُوزِييّنْ ذِي هَامْ، خْ إِمِيثِييّنْ ذِي شَاوَا-قَارْيَاثَايِيمْ    ");
INSERT INTO rifa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ؤُ خْ إِخُورِييّنْ ذڭْ إِذُورَارْ نْسنْ ن سَاعِيرْ أَڒْ فَارَانْ، ونِّي إِدْجَانْ زَّاثْ إِ ڒخْڒَا. ");
INSERT INTO rifa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","أَوَارْنِي أَيَا ذوْڒنْ-د، ؤُسِينْ-د غَارْ عَايْنْ-مِيشْفَاثْ، ونِّي ذ قَاذَاشْ، ؤُشَاغڒْبنْ خْ يوْذَانْ نِّي إِزدّْغنْ ذِي مَارَّا ثَامُّورْثْ ن أَيْثْ ن عَامَالِيقْ ؤُ عَاوذْ خْ إِمُورِييّنْ إِنِّي إِزدّْغنْ ذِي هَاصُّونْ-ثَامَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","خنِّي إِفّغْ ؤُجدْجِيذْ ن سَاذُومْ ذ ؤُجدْجِيذْ ن عَامُورَّا ذ ؤُجدْجِيذْ ن أَذْمَا ذ ؤُجدْجِيذْ ن صابُويِيمْ ذ ؤُجدْجِيذْ ن بِيلَاعْ، أَقَا-ت ذ صُوغَارْ. رُوحنْ نِيثْنِي غَارْ ڒوْضَا ن ثغْزُورْثْ ن سِيذِّيمْ، مَاحنْذْ أَذْ مّنْغنْ ");
INSERT INTO rifa_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","أَكْ-ذ كِيذُورْلَاعُومِيرْ، أَجدْجِيذْ ن عِيلَامْ ذ ثِيذْعَالْ، أَجدْجِيذْ ن ڒڭْنُوسْ، ذ أَمْرَافِيلْ، أَجدْجِيذْ ن شِينْعَارْ، ذ أَرْيُوكْ، أَجدْجِيذْ ن إِلَّاسَارْ: أَربْعَا ن إِجدْجِيذنْ ڭِّينْ ڒْبَارُوضْ أَكْ-ذ خمْسَا. ");
INSERT INTO rifa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ثُوغَا ڒوْضَا ن ثغْزُورْثْ ن سِيذِّيمْ ثشُّورْ س وَانُوثنْ ن ثِيزفْثْ. ؤُشَا أَروْڒنْ إِجدْجِيذنْ ن سَاذُومْ ذ عَامُورَّا ؤُشَا وْضَانْ ذَايْسنْ، ؤُ إِنِّي إِقِّيمنْ أَروْڒنْ غَارْ إِذُورَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","كْسِينْ مَارَّا أَڭْڒَا ن سَاذُومْ ذ عَامُورَّا ذ مَارَّا مَاشَّا إِ خزْننْ ؤُشَا ؤُيُورنْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","كْسِينْ عَاوذْ لُوطْ، مِّيسْ ن ؤُمَاسْ ن أَبْرَامْ، ذ وَاڭْڒَا نّسْ ؤُشَا رُوحنْ. نتَّا ثُوغَا إِزدّغْ ذِي سَاذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","خنِّي يُوسَا-د إِجّنْ زڭْ إِنِّي يَاروْڒنْ، إِنَّا مَانْ أَيَا إِ أَبْرَامْ، أَعِيبْرَانِي، ونِّي ثُوغَا إِزدّْغنْ غَارْ ثْشجُّورَا ن يِيڭّْ ن مَامْرِي، أَرْيَازْ ذ أَمُورِييْ، ؤُمَاسْ ن أَشْكُولْ ذ عَانِيرْ. نِيثْنِي ذ أَرْفِيقنْ ذِي ڒْعَاهْذْ ن أَبْرَامْ.    ");
INSERT INTO rifa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ڒَْامِي إِسْڒَا أَبْرَامْ بلِّي ؤُمَاسْ طّْفنْ ث ذ أَمحْبُوسْ، يِيوِي إِرْيَازنْ إِنِّي إِذَارّْبنْ إِ ؤُمنْغِي، إِنِّي د-إِتّْوَاخڒْقنْ ذِي ثَادَّارْثْ نّسْ، ذِي ثڒْثْ-مْيَا ؤُ-ثْمنْطَاشْ، ؤُشَا إِضْفَارْ إِ-ثنْ أَڒْ دَان. ");
INSERT INTO rifa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","س دْجِيرثْ بْضَانْ خَاسنْ نِيثْنِي، ڭِّينْ ثرْفِيقِينْ، نتَّا ذ إِمْسخَّارنْ نّسْ، ؤُشَا إِغْڒبْ خَاسنْ ؤُشَا إِضْفَارْ إِ-ثنْ غَارْ ثنْذِينْثْ ن حُوبَا، ثنِّي إِدْجَانْ خْ ؤُزڒْمَاضْ ن ذِيمَاشْقْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","يَارَّا-د مَارَّا أَڭْڒَا ؤُڒَا ذ ؤُمَاسْ لُوطْ ذ وَاڭْڒَا نّسْ ؤُڒَا ذ ثِيمْغَارِينْ ذ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ؤُمِي د-إِعْقبْ، أَوَارْنِي ڒَامِي إِغْڒبْ نتَّا خْ كِيذُورْلَاعُومِيرْ ؤُ خْ إِجدْجِيذنْ نِّي ثُوغَا أَكِيذسْ، إِفّغْ ؤُجدْجِيذْ ن سَاذُومْ حِيمَا أَذْ ث إِڒْقَا ذِي ڒوْضَا ن ثغْزُورْثْ ن شَاوَا، ثنِّي إِدْجَانْ ذ ثَاغْزُورْثْ ن ؤُجدْجِيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ؤُ مَالْكِيصَاذِيقْ، أَجدْجِيذْ ن شَالِيمْ، يِيوِي-د أَغْرُومْ ذ بِينُو. نتَّا ثُوغَا ذ أَكهَّانْ ن أَربِّي، أَمْعُودْجِي خْ كُوڒْشِي.    ");
INSERT INTO rifa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","إِبَارْكْ إِ-ث، إِنَّا أَسْ: ”أَذْ إِتّْوَابَاركْ أَبْرَامْ زِي أَربِّي، أَمْعُودْجِي خْ كُوڒْشِي، ونِّي إِڭِّينْ إِجنْوَانْ ذ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","أَذْ إِتّْوَابَاركْ أَربِّي، أَمْعُودْجِي خْ كُوڒْشِي، ونِّي إِسلّْمنْ إِغْرِيمنْ نّشْ ذڭْ إِفَاسّنْ نّشْ!“ ؤُشَا أَبْرَامْ إِوْشَا أَسْ ڒعْشُورْ ن مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ؤُشَا إِنَّا ؤُجدْجِيذْ ن سَاذُومْ إِ أَبْرَامْ: ”أوْشْ أَيِي مَارَّا مِينْ إِدَّارنْ، مَاشَا كْسِي أَڭْڒَا إِ يِيخفْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","مَاشَا أَبْرَامْ يَارَّا-د خْ ؤُجدْجِيذْ ن سَاذُومْ: ”أَقَا سّْڭعّْذغْ أَفُوسْ إِنُو غَارْ سِيذِي أَربِّي، أَمْعُودْجِي خْ كُوڒْشِي، ونِّي إِڭِّينْ أَجنَّا ذ ثمُّورْثْ، جُّودْجغْ ");
INSERT INTO rifa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","مَاحنْذْ وَارْ كسِّيغْ أَفِيڒُو نِيغْ ثَاحزّمْثْ ن سَانْذَالِييَاثْ ؤُڒَا شَا ن ڒْحَاجّثْ زِي مَارَّا مِينْ إِدْجَانْ نّشْ، حِيمَا وَارْ ثقَّارذْ: ’نشّْ سّْثجَّارغْ أَبْرَامْ!‘ ");
INSERT INTO rifa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","وَارْ غَارِي ذَايسْ بُو ثَاسْغَارْثْ! مْغِيرْ مِينْ شِّينْ إِمْسخَّارنْ ذ ثسْغَارْثْ ن إِرْيَازنْ نِّي كِيذِي إِرُوحنْ، أَنِيرْ ذ إِشْكُولْ ذ مَامْرِي، أجّْ إِ-ثنْ أَذْ كْسِينْ ثَاسْغَارْثْ نْسنْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","أَوَارْنِي مَانْ أَيَا يُوسَا-د وَاوَاڒْ ن سِيذِي غَارْ أَبْرَامْ ذڭْ إِجّْ ن ڒوْحِييْ. إِنَّا أَسْ ”وَارْ تّڭّْوذْ شَا، أَبْرَامْ، نشّْ ذ أَسڒْقِي إِ شكْ، ڒْمُونثْ نّشْ ثمْغَارْ أَطَّاسْ ذ نشّْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ؤُشَا إِنَّا أَبْرَامْ: ”سِيذِي إِنُو، سِيذِي، مِينْ ذ أَيِي غَا ثوْشذْ، مَاغَارْ نشّْ أَذْ رَاحغْ أَمُّو بْڒَا مِّي ؤُ أَلِيعَازِيرْ زِي ذِيمَاشْقْ أَذْ يِيڒِي أَمشْنَاوْ مِّي خْ وَاڭْڒَا ن ثَادَّارْثْ إِنُو؟“ ");
INSERT INTO rifa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","إِنَّا أَبْرَامْ عَاوذْ: ”خْزَارْ، وَارْ ذ أَيِي ثوْشِيذْ زَّارِيعثْ، س ؤُينِّي، ونِّي إِدْجَانْ أَمْ مِّي ن ثَادَّارْثْ إِنُو، أَذْ يِيڒِي ذ أَوْرِيثْ إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ؤُشَا خْزَارْ، أَوَاڒْ ن سِيذِي يُوسَا-د غَارسْ، إِنَّا: ”وَارْ شكْ إِوَارّثْ شَا وَا، مَاشَا ونِّي إِ غَا إِفّْغنْ زَّايكْ أَذْ يِيڒِي ذ أَوْرِيثْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","إِسُّوفّغْ إِ-ث غَارْ بَارَّا، إِنَّا: ”خْزَارْ غَارْ ؤُجنَّا، ثْحسْبذْ إِثْرَانْ، مَاڒَا ثْزمَّارذْ أَذْ ثنْ ثْحسْبذْ!“ ؤُشَا إِنَّا أَسْ: ”أَمُّو إِ غَا ثِيڒِي زَّارِيعثْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ؤُشَا نتَّا يُومنْ ذِي سِيذِي ؤُشَا إِحْسبْ أَسْ ث-إِ-د ذ ثَاسڭْذَا.    ");
INSERT INTO rifa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","إِنَّا أَسْ عَاوذْ: ”نشّْ ذ سِيذِي، ونِّي شكْ د-يِيوْينْ زِي ؤُرْ ن إِكَالْذَانِييّنْ، حِيمَا أَذْ أَشْ وْشغْ ثَامُّورْثْ-أَ ذ ڒْوَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","خنِّي نتَّا إِنَّا: ”أَ سِيذِي إِنُو، سِيذِي، س مِينْزِي إِ غَا سّْنغْ، بلِّي أَذْ ت وَارْثغْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","إِنَّا أَسْ نتَّا: ”أَوِي أَيِي-د إِشْثْ ن ثْعجْمِيثْ ن ثْڒَاثَا ن إِسڭّْوُوسَا ذ إِجّْ ن إِغَايْضْ ن ثْڒَاثَا إِسڭّْوُوسَا ذ إِجّْ ن إِشَارِّي ن ثْڒَاثَا إِسڭّْوُوسَا ذ إِشْثْ ن ثجْلِيلّحْثْ ذ إِجّْ ن وذْبِيرْ ذ أَمژْيَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","نتَّا يِيوِي-د غَارسْ مَارَّا مَانْ أَيَا، إِبْضَا ثنْ خْ وزْينْ ؤُ إِڭَّا كُوڒْ أَزْينْ قِيبَاتْشْ إِ ونّغْنِي، مَاشَا وَارْ إِبْضِي شَا إِجْضَاضْ. ");
INSERT INTO rifa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","هْوَانْ-د إِجْضَاضْ إِتّْكشَّاضنْ خْ إِمُورْضَاسْ، مَاشَا أَبْرَامْ يُوژّڒْ خَاسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","غَارْ ؤُغدْجَايْ ن ثْفُوشْثْ، إِمْسَارْ أَقَا يُوسَا أَسْ-د إِ أَبْرَامْ إِجّْ ن يِيضصْ يُودْجغْ، ؤُشَا خْزَارْ، ثِيڭّْوُوذِي ذ ثَادْجسْثْ إِحذْقنْ وْضَانْ-د خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","خنِّي إِنَّا إِ أَبْرَامْ: ”سّنْ س ثِيذتّْ أَقَا زَّارِيعثْ نّشْ أَذْ ثِيڒِي ذ ثَابَارَّانشْثْ ذڭْ إِشْثْ ن ثمُّورْثْ إِ وَارْ إِدْجِينْ نّسْ ؤُشَا أَذْ أَسنْ خذْمنْ أَمْ إِسمْغَانْ ؤُ نِيثْنِي أَذْ خَاسنْ ڭّنْ أَغِيڒْ أَربْعَا-مْيَا ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","مَاشَا ڒْڭنْسْ ؤُمِي غَا خذْمنْ أَمْ إِسمْغَانْ، أَذْ خَاسنْ حكْمغْ عَاوذْ، ؤُشَا أَوَارْنِي مَانْ أَيَا أَذْ فّْغنْ س وَاڭْڒَا إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","أَذْ ثتّْوَاسّْمُونذْ غَارْ ڒجْذُوذْ نّشْ س ڒهْنَا ؤُشَا أَذْ شكْ نضْڒنْ أَمْ ؤُمشَّايْبُو إِوقَّارْ. ");
INSERT INTO rifa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","جِّيڒْ وِيسّْ أَربْعَا أَذْ د-إِعْقبْ ذَانِيثَا، مِينْزِي ڒْقدّْ ن ڒْمُوعْصِييّثْ ن إِمُورِييّنْ عَاذْ وَارْ إِكمّڒْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ڒَامِي ثغْڒِي ثْفُوشْثْ ؤُشَا ثذْوڒْ ذ ثَادْجسْثْ، ثُوغَا ذِينْ أَفَارَّانْ إِدّخّْننْ ؤُ إِعْذُو إِجّْ ن وصْفضْ ن ثْمسِّي جَارْ إِزيْنَانْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ذڭْ وَاسّْ نِّي نِّيثْ إِڭَّا سِيذِي إِجّْ ن ڒْعَاهْذْ أَكْ-ذ أَبْرَامْ، إِنَّا: ”إِ زَّارِيعثْ نّشْ ؤُمِي وْشِيغْ ثَامُّورْثْ-أَ زڭْ إِغْزَارْ ن مِيصْرَا أَڒْ إِغْزَارْ أَمقّْرَانْ، إِغْزَارْ ن لْفُورَاطْ: ");
INSERT INTO rifa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ثَامُّورْثْ ن إِقِينِييْينْ، إِقنِيزِييْينْ، إِقَاذْمِييْينْ، ");
INSERT INTO rifa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","إِحِيتِّييْينْ، إِفِيرْزِييْينْ، إِرَافَاوِييّنْ، ");
INSERT INTO rifa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","إِمُورِييْينْ، أَيْثْ ن كنْعَانْ، إِڭِيرْڭَاشِييْينْ ذ إِيِيبُوسِييْينْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","سَارَايْ، ثَامْغَارْثْ ن أَبْرَامْ، وَارْ ذ أَسْ د-ثِيرُووْ شَا. ثُوغَا غَارسْ إِشْثْ ن ثَايَّا زِي مِيصْرَا قَّارنْثْ أَسْ هَاجَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ثنَّا سَارَايْ إِ أَبْرَامْ: ”أَقَا ثژْرِيذْ بلِّي سِيذِي إِطّفْ خَافِي ثَارْوَا. أَذفْ خْ ثَايَّا إِنُو، بَالَاكْ أَذْ زَّايسْ كْسِيغْ ثَارْوَا.“ أَبْرَامْ ثُوغَا إِسّْحسَّا غَارْ سَارَايْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","أَوَارْنِي ڒَامِي إِزْذغْ أَبْرَامْعشْرَا ن إِسڭّْوُوسَا ذِي ثمُّورْثْ ن كنْعَانْ، ثِيوِي-د سَارَايْ، ثَامْغَارْثْ ن أَبْرَامْ، ثَايَّا نّسْ هَاجَارْ، ثنِّي زِي مِيصْرَا، ؤُشَا ثوْشَا أَسْ-د إِ أَبْرَامْ، أَرْيَازْ نّسْ، ذ ثَامْغَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","يُوذفْ خْ هَاجَارْ ؤُشَا نتَّاثْ ثكْسِي دّيْسثْ. ؤُمِي ثژْرَا بلِّي ثكْسِي دّيْسثْ، خنِّي ثذْوڒْ لَالَّاسْ ثتّْوَاسّحْقَارْ ذِي ثِيطَّاوِينْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ثنَّا سَارَايْ إِ أَبْرَامْ: ”زِي سِّيبّثْ نّشْ ڭِّينْ ذَايِي ڒْمُونْكَارْ. نشّْ ڭِّيغْ ثَايَّا إِنُو ذڭْ وحْسِينْ نّشْ. ؤُمِي ثژْرَا بلِّي ثكْسِي دّيْسثْ، ذوْڒغْ ذ ثَامحْڭُورثْ ذِي ثِيطَّاوِينْ نّسْ. أجّْ أَذْ إِحْكمْ سِيذِي جَارْ أَيِي ذ شكْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","إِنَّا أَبْرَامْ إِ سَارَايْ: ”خْزَارْ، ثَايَّا نّمْ ذڭْ إِفَاسّنْ نّمْ. أڭّْ زَّايسْ مِينْ ثتّْوَاڒِيذْ شمْ مْلِيحْ ذِي ثِيطَّاوِينْ نّمْ.“ ؤُشَا سَارَايْ ثْقمّعْ إِ-ت ؤُ خنِّي نتَّاثْ ثَارْوڒْ زَّايسْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ؤُشَا لْمَالَاكْ ن سِيذِي إِڒْقَا إِ-ت غَارْ ثَاڒَا ن وَامَانْ ذِي ڒخْڒَا، غَارْ ثَاڒَا ذڭْ وبْرِيذْ إِتَّاوْينْ غَارْ شُورْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","إِنَّا: ”هَاجَارْ، ثَايَّا ن سَارَايْ، مَانِيسْ د-ثُوسِيذْ ؤُ مَانِي غَا ثْرَاحذْ؟“ نتَّاثْ ثنَّا: ”تّْرَاكّْوَاڒغْ زڭْ وُوذمْ ن لَالَّا سَارَايْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","خنِّي إِنَّا أَسْ لْمَالَاكْ ن سِيذِي: ”ذْوڒْ غَارْ لَالَّامْ، ؤُضَارْ سَاذُو إِفَاسّنْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","إِنَّا أَسْ عَاوذْ لْمَالَاكْ ن سِيذِي: ”أَذْ كتَّارغْ أَطَّاسْ زَّارِيعثْ نّمْ، أَڒْ وَارْ إِزمَّارْ أَذْ ثتّْوَاحْسبْ ڒَامِي إِ غَا ثِيڒِي ذڭْ وَاطَّاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","إِنَّا أَسْ لْمَالَاكْ ن سِيذِي عَاوذْ: ”أَقَا ڒخُّو، ثكْسِيذْ دّيْسثْ ؤُشَا أَذْ ثَارْوذْ أَسيْمِي. أَذْ أَسْ ثڭّذْ إِسْمَاعِيلْ، مِينْزِي سِيذِي إِسْڒَا أَمْ ذِي ڒمْحَاينْ نّمْ. ");
INSERT INTO rifa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ؤُشَا نتَّا أَذْ يِيڒِي ذ إِجّْ ن بْنَاذمْ أَمشْنَاوْ أَسْنُوسْ ن ڒخْڒَا. أَفُوسْ نّسْ أَذْ يِيڒِي خْ مَارَّا، ؤُ أَفُوسْ ن مَارَّا أَذْ يِيڒِي خَاسْ. أَذْ إِزْذغْ أَرنْذَاذْ ن مَارَّا أَيْثْمَاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ؤُ نتَّاثْ ثْڒَاغَا خْ يِيسمْ ن سِيذِي إِ غَارسْ-د إِسِّيوْڒنْ، ثنَّا: ”شكْ ذ أَربِّي إِ إِتّْوَاڒَانْ!“، مِينْزِي ثنَّا: ”مَا وَارْ ذَا ژْرِيغْ ونِّي ذ أَيِي إِتّْوَاڒَانْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","خْ ؤُيَا سمَّانْ أَنُو نِّي: أَنُو ’لَاحَايْ-رُوئِي‘. خْزَارْ، أَقَا-ث جَارْ قَاذَاشْ ذ بَارَاذْ.    ");
INSERT INTO rifa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ؤُشَا ثُورُووْ-د هَاجَارْ إِ أَبْرَامْ أَسيْمِي. إِڭَّا أَسْ أَبْرَامْ إِسمْ ن مِّيسْ نِّي إِ ذ أَسْ د-ثُورُووْ هَاجَارْ ’إِسْمَاعِيلْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","أَبْرَامْ ثُوغَا غَارسْ ستَّا ؤُ-ثْمَانْيِينْ ن إِسڭّْوُوسَا، ؤُمِي د-ثُورُووْ هَاجَارْ إِسْمَاعِيلْ إِ أَبْرَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ڒَْامِي ثُوغَا غَارسْ غَارْ أَبْرَامْ ثسْعَا ؤُ-ثسْعِينْ ن إِسڭّْوُوسَا، إِبَانْ أَسْ-د سِيذِي إِ أَبْرَامْ، إِنَّا أَسْ: ”نشّْ ذ أَربِّي أَمْزمَّارْ خْ كُوڒْشِي! ؤُيُورْ زَّاثْ إِ وُوذمْ إِنُو ؤُشَا إِڒِي ذ بْنَاذمْ إِكمّْڒنْ!    ");
INSERT INTO rifa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","نشّْ أَذْ ڭّغْ ڒْعَاهْذْ إِنُو جَارْ أَيِي ذ شكْ ؤُشَا أَذْ شكْ سّْكتَّارغْ س يِيجّْ ن شّْكلْ إِمْغَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","خنِّي إِوْضَا أَبْرَامْ خْ ؤُغمْبُوبْ نّسْ ؤُشَا إِسِّيوڒْ أَربِّي أَكِيذسْ، إِنَّا أَسْ: ");
INSERT INTO rifa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","”خْزَارْ، نشّْ أَذْ ڭّغْ ڒْعَاهْذْ إِنُو أَكِيذكْ ؤُشَا شكْ أَذْ ثِيڒِيذْ ذ بَابَاثْسنْ ن وَاطَّاسْ ن ڒڭْنُوسْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","وَارْ إِتِّيڒِي إِسمْ نّشْ عَاذْ ’أَبْرَامْ‘ مَاشَا ’إِبْرَاهِيمْ‘، مِينْزِي نشّْ ڭِّيغْ شكْ ذ بَابَاثْسنْ ن وَاطَّاسْ ن ڒڭْنُوسْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ؤُشَا نشّْ أَذْ شكْ أَرّغْ أَذْ ثڭّذْ ڒْغِيدْجثْ أَطَّاسْ س وَاطَّاسْ ؤُ أَذْ شكْ أَرّغْ ذ ڒڭْنُوسْ، ؤُشَا إِجدْجِيذنْ أَذْ زَّايكْ د-فّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","أَذْ ڭّغْ ڒْعَاهْذْ إِنُو جَارْ أَيِي ذ شكْ ذ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ ذِي مَارَّا جِّيڒَاثْ نْسنْ، أَمْ يِيجّْ ن ڒْعَاهْذْ إِ ڒبْذَا، حِيمَا أَذْ إِڒِيغْ ذ أَربِّي إِ شكْ ؤُ إِ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","أَذْ أَشْ وْشغْ، إِ شكْ ؤُ إِ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ، ثَامُّورْثْ مَانِي ثْزدّْغذْ أَمْ ؤُبَارَّانِي، مَارَّا ثَامُّورْثْ ن كنْعَانْ ذ أَڭْڒَا إِ ڒبْذَا. نشّْ أَذْ إِڒِيغْ ذ أَربِّي إِ نِيثْنِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","إِنَّا أَربِّي عَاوذْ إِ إِبْرَاهِيمْ: ”شكْ أَذْ ثحْضِيذْ ڒْعَاهْذْ إِنُو، شكْ ذ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ، ذِي مَارَّا جِّيڒَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ذ وَا ذ ڒْعَاهْذْ إِنُو ونِّي إِ غَا ثحْضَامْ جَارْ أَيِي-د ذ كنِّيوْ ذ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ: إِتّْخصَّا أَذْ إِخْثنْ زَّايْومْ مَارَّا مِينْ إِدْجَانْ ذ أَوْثمْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","كنِّيوْ أَذْ ثْخثْنمْ أَيْسُومْ ن ڒعْذَاڒْيثْ نْومْ ؤُشَا مَانْ أَيَا أَذْ ثِيڒِي ذ ڒعْڒَامثْ ن ڒْعَاهْذْ جَارْ أَيِي-د ذ كنِّيوْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","مِّيسْ ن ثْمنْيَا ن وُوسَّانْ أَذْ إِخْثنْ جَارْ أَومْ، مْكُوڒْ أَوْثمْ ذِي مَارَّا جِّيڒَاثْ نْومْ، أَمْ ونِّي د-إِخڒْقنْ ذِي ثَادَّارْثْ نّشْ أَمْ ونِّي إِتّْوَاسْغنْ س نُّوقَارْثْ زِي كُوڒْ أَبَارَّانِي ؤُ وَارْ إِدْجِينْ زِي زَّارِيعثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","أَمْ ونِّي د-إِخڒْقنْ ذِي ثَادَّارْثْ نّشْ، أَمْ ونِّي ثسْغِيذْ س نُّوقَارْثْ، إِتّْخصَّا أَسْ أَذْ إِخْثنْ. أَمُّو إِ غَا يِيڒِي ڒْعَاهْذْ إِنُو ذڭْ ويْسُومْ نْومْ ذ ڒْعَاهْذْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","أَرْيَازْ وَارْ إِخْثِيننْ، ونِّي ڒعْذَاڒْيثْ نّسْ وَارْ ت خْثِينْ، أَرْيَازْ نِّي إِتّْخصَّا أَذْ ث قسّنْ زِي ڒْڭنْسْ نّسْ، أَقَا يَارْژَا ڒْعَاهْذْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","إِنَّا أَربِّي عَاوذْ إِ إِبْرَاهِيمْ: ”إِ سَارَايْ ثَامْغَارْثْ نّشْ وَارْ ذ أَسْ ثْڒِيغِيذْ عَاذْ ’سَارَايْ‘، مَاشَا ’سَارَا‘ ذ وَا إِ غَا يِيڒِينْ إِسمْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","مِينْزِي أَذْ ت بَارْكغْ ؤُ زَّايسْ أَذْ أَشْ وْشغْ مِّيشْ. وَاهْ، أَذْ ت بَارْكغْ ؤُشَا نتَّاثْ أَذْ ثذْوڒْ ذ ڒڭْنُوسْ ؤُ إِجدْجِيذنْ ن ڒڭْنُوسْ أَذْ زَّايسْ د-فّْغنْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","خنِّي إِوْضَا إِبْرَاهِيمْ خْ ؤُغمْبُوبْ نّسْ ؤُشَا إِضْحشْ، إِنَّا ذڭْ وُوڒْ نّسْ: ”أَرْيَازْ ن مْيَا ن إِسڭّْوُوسَا مَا أَذْ أَسْ د-إِتّْوَاخْڒقْ مِّيسْ؟ ؤُ سَارَا، ثنِّي غَارْ إِدْجَا ثسْعِينْ ن إِسڭّْوُوسَا، مَا عَاذْ أَذْ د-ثَارُووْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","إِنَّا إِبْرَاهِيمْ إِ أَربِّي: ”مْڒِي إِسْمَاعِيلْ إِدَّارْ قِيبَاتْشْ إِ وُوذمْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","مَاشَا أَربِّي إِنَّا: ”لَّ، عَاذْ سَارَا، ثَامْغَارْثْ نّشْ، ذ ثنِّي ذ أَشْ د غَا يَارْونْ أَسيْمِي، ؤُشَا شكْ أَذْ أَسْ ثْڒَاغِيذْ إِسْحَاقْ. نشّْ أَذْ ڭّغْ ڒْعَاهْذْ إِنُو أَكِيذسْ ذ ڒْعَاهْذْ إِ ڒبْذَا، إِ زَّارِيعثْ نّسْ أَوَارْنِي أَسْ.   ");
INSERT INTO rifa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","زِي جِّيهثْ ن إِسْمَاعِيلْ، أَقَا سدْجغْ أَشْ. خْزَارْ، نشّْ بَارْكغْ ث ؤُشَا أَذْ ث أَرّغْ إِتَّارُووْ ڒْغِيدْجثْ ؤُ أَذْ ث أَرّغْ ذ أَطَّاسْ. ثنْعَاشْ ن ڒْحُوكَّامْ إِ د غَا يجّْ، أَذْ ث ڭّغْ ذ إِجّْ ن ڒْڭنْسْ إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","مَاشَا أَذْ ڭّغْ ڒْعَاهْذْ إِنُو أَكْ-ذ إِسْحَاقْ، ونِّي إِ ذ أَشْ د غَا ثَارُووْ سَارَا ذِي ڒْوقْثْ-أَ، ذڭْ ؤُسڭّْوَاسْ إِ د غَا يَاسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ؤُمِي إِكمّڒْ أَوَاڒْ نّسْ أَكِيذسْ، إِڭعّذْ أَربِّي، إِڭّْوجْ خْ إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","إِكْسِي إِبْرَاهِيمْ مِّيسْ إِسْمَاعِيلْ ذ مَارَّا إِسمْغَانْ إِ د-إِتّْوَاخڒْقنْ ذِي ثَادَّارْثْ نّسْ ذ مَارَّا إِنِّي إِمّسْغنْ س نُّوقَارْثْ، مَارَّا مِينْ إِدْجَانْ ذ أَوْثمْ جَارْ أَيْثْبَابْ ن ثَادَّارْثْ ن إِبْرَاهِيمْ ؤُشَا إِخْثنْ ڒعْذَاڒْيثْ نْسنْ ذڭْ وَاسّْ نِّي أَمْ مَامّشْ ذ أَسْ إِنَّا أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ثُوغَا غَارْ إِبْرَاهِيمْ ثسْعَا ؤُ-ثسْعِينْ ن إِسڭّْوُوسَا ؤُمِي إِخْثنْ ذڭْ ويْسُومْ ن ڒعْذَاڒْيثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","إِڭَّا مِّيسْ إِسْمَاعِيلْ ثْڒطَّاشْ ن إِسڭّْوُوسَا، ؤُمِي ث خثْننْ ذڭْ ويْسُومْ ن ڒعْذَاڒْيثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","إِخْثنْ إِبْرَاهِيمْ ذ مِّيسْ إِسْمَاعِيلْ ذڭْ وَاسّْ ذ إِجّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","خثْننْ أَكِيذسْ مَارَّا إِرْيَازنْ ن ثَادَّارْثْ نّسْ، إِنِّي د-إِتّْوَاخڒْقنْ ذِي ثَادَّارْثْ نّسْ ؤُڒَا ذ إِنِّي إِمّسْغنْ س نُّوقَارْثْ زڭْ ؤُبَارَّانِي. ");
INSERT INTO rifa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ؤُشَا إِضْهَارْ سِيذِي إِ إِبْرَاهِيمْ غَارْ ثْشجُّورَا ن يِيڭّْ ن مَامْرِي ؤُمِي ثُوغَا يَاريّحْ غَارْ وَاذَافْ ن ؤُقِيضُونْ نّسْ ذِي طّْحَا ن ؤُزِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","إِسّْڭعّذْ ثَامُوغْڒِي نّسْ، إِژْرَا، أَقَا ذِينْ ثْڒَاثَا ن يرْيَازنْ قِيبَاتْشْ نّسْ. ؤُمِي ثنْ إِژْرَا، إِكَّارْ إِتَّازّڒْ غَارْسنْ زِي وَاذَافْ ن ؤُقِيضُونْ. ؤُشَا إِبنْذقْ س ؤُغمْبُوبْ نّسْ غَارْ ثمُّورْثْ،    ");
INSERT INTO rifa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","إِنَّا: ”أَ سِيذِي إِنُو، مَاڒَا ڒخُّو ؤُفِيغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، تّْزَاوَاڭغْ شكْ، وَارْعدُّو خْ ؤُمْسخَّارْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","أجّْ إِمْسخَّارنْ إِنُو أَذْ د-أَوْينْ شْوَايْثْ ن وَامَانْ ؤُشَا سِيرْذمْ إِضَارنْ نْومْ ؤُشَا زّْڒمْ شْوَايْثْ سَاذُو ثْشجَّارْثْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","أَذْ د-أَوْيغْ أَڒقُّوزْ ن وغْرُومْ حِيمَا أَذْ تّْوَانعْشنْ وُوڒَاونْ نْومْ، خنِّي أَذْ ثعْذُومْ. أَقَا خْ ؤُيَا إِ د-ثكِّيمْ زَّاثْ إِ ؤُمْسخَّارْ نْومْ!“ نِيثْنِي نَّانْ: ”أڭّْ أَمْ مَامّشْ ثنِّيذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","إِرُوحْ إِبْرَاهِيمْ ذغْيَا غَارْ ؤُقِيضُونْ غَارْ سَارَا، إِنَّا: ”ذغْيَاثْ، كْسِي ثْڒَاثَا ن ڒقْيَاسْ ن وَارنْ أَزْذَاذْ، أڭّْوْ إِ-ثنْ ؤُشَا أڭّْ زَّايسْ ثِيفْضِيرِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","خَاسْ ؤُشَا يُوزّڒْ إِبْرَاهِيمْ غَارْ إِفُونَاسنْ ؤُشَا إِطّفْ-د إِجّْ ن ؤُمژْيَانْ ن ؤُفُونَاسْ إِڭْمَا ذ لمْلِيحْ، إِوْشَا إِ-ث إِ ؤُبْڒِيغْ، ؤُشَا وَا إِقدْجقْ، حِيمَا أَذْ ث إِسّوْجذْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","نتَّا إِكْسِي عَاوذْ دّْهنْ ذ ؤُغِي ذ ؤُمژْيَانْ ن ؤُفُونَاسْ نِّي إِسّوْجذْ، ؤُشَا إِسَّارْسْ إِ-ث زَّاثْسنْ، ؤُ نتَّا ثُوغَا إِبدّْ قِيبَاتْشْ نْسنْ سَاذُو ثْشجَّارْثْ، ؤُشَا شِّينْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","خنِّي نَّانْ أَسْ: ”مَانِي ثدْجَا سَارَا ثَامْغَارْثْ نّشْ؟“ يَارَّا-د خَاسنْ: ”أَقَا-ت ذِينْ ذڭْ ؤُقِيضُونْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ؤُشَا نتَّا إِنَّا: ”ذ ثِيذتّْ أَذْ غَاركْ د-ذوْڒغْ غَارْ ڒْوقْثْ ن ثُوذَارْثْ ؤُ خْزَارْ، أَذْ غَارسْ يِيڒِي ؤُحنْجِيرْ غَارْ سَارَا، ثَامْغَارْثْ نّشْ.“ ؤُ سَارَا ثسْڒَا غَارْ وَاذَافْ ن ؤُقِيضُونْ نِّي إِدْجَانْ أَوَارْنِي أَسْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","إِبْرَاهِيمْ ذ سَارَا ثُوغَا وْسَارنْ، ؤُيُورنْ ذڭْ وُوسَّانْ، ؤُشَا سَارَا ثُوغَا ثْبدّْ أَسْ ثُوبَّارْثْ ن ثمْغَارِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ؤُشَا ثضْحشْ سَارَا ذڭْ وُوڒْ نّسْ، ثنَّا: ”أَوَارْنِي ثوْسَارْ إِنُو، مَا أَذْ غَارِي يِيڒِي ڒْخِيرْ-أَ ذ لمْلِيحْ قَاعْ، أَمْ إِدْجَا سِيذِي إِنُو ؤُڒَا ذ نتَّا إِوْسَارْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","إِنَّا سِيذِي إِ إِبْرَاهِيمْ: ”مَاغَارْ ثضْحشْ سَارَا، ثنَّا: ’مَا زمَّارغْ أَذْ أَرْوغْ أَمْ وْسَارغْ ڒخُّو؟‘ ");
INSERT INTO rifa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","مَا أَقَا ذِينْ شَا ن ڒْحَاجّثْ خْ سِيذِي ثوْعَارْ؟ أَذْ غَاركْ د -عقْبغْ ذِي ڒْوقْثْ إِ نڭَّا، غَارْ ڒْوقْثْ ن ثُوذَارْثْ ؤُشَا أَذْ يِيڒِي غَارْ سَارَا مِّيسْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","سَارَا ثنْكَارْ، ثنَّا: ”وَارْ ضحْشغْ شَا!“، مِينْزِي ثُوغَا ثڭّْوذْ. نتَّا إِنَّا أَسْ: ”لَّ، أَقَا شمْ ثْضحْشذْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","خنِّي كَّارنْ إِرْيَازنْ نِّي سّنِّي، سوْضنْ غَارْ سَاذُومْ، ؤُشَا إِرُوحْ إِبْرَاهِيمْ أَكِيذْسنْ، إِسّْقبّضْ إِ-ثنْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ؤُشَا إِنَّا سِيذِي: ”مَا أَذْ فَّارغْ نشّْ خْ إِبْرَاهِيمْ مِينْ إِ غَا ڭّغْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","أَذْ يِيڒِي إِبْرَاهِيمْ زعْمَا ذ إِجّْ ن ڒْڭنْسْ إِمْغَارْ إِجْهذْ، أَقَا أَذْ ذَايسْ تّْوَابَارْكنْ مَارَّا ڒڭْنُوسْ ن دُّونشْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","مِينْزِي نشّْ قّْنغْ إِخفْ إِنُو أَكِيذسْ، حِيمَا أَذْ إِسّڒْمذْ إِحنْجِيرنْ نّسْ ؤُڒَا ذ ثَادَّارْثْ نّسْ أَوَارْنِي أَسْ، مَاحنْذْ أَذْ حْضَانْ أَبْرِيذْ ن سِيذِي، أَذْ ڭّنْ ثَاسڭْذَا ذ ڒْحقّْ، حِيمَا سِيذِي أَذْ د-يَاوِي إِ إِبْرَاهِيمْ مِينْ ثُوغَا خَاسْ إِنَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","خنِّي إِنَّا سِيذِي: ”ثْغُويِّيثْ ن سَاذُومْ ذ عَامُورَّا ثمْغَارْ أَطَّاسْ ؤُ دّْنُوبْ نْسنْ ذقْڒنْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","أَذْ د-هْوِيغْ، أَذْ ژَترغْ مَا ڭِّينْ نِيشَانْ أَمْ ثْغُويِّيثْ نْسنْ إِ غَارِي د-يُوسِينْ نِيغْ لَّا، أَذْ سّْنغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","خنِّي ذوْڒنْ إِرْيَازنْ سّنِّي ؤُشَا طّْفنْ أَبْرِيذْ غَارْ سَاذُومْ. مَاشَا إِبْرَاهِيمْ ثُوغَا إِقِّيمْ عَاذْ إِبدّْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ؤُشَا إِقَارّبْ-د إِبْرَاهِيمْ، إِنَّا: ”مَا س ثِيذتّْ أَذْ ثَارذْدْجذْ عَاوذْ أَمْسڭّذْ أَكْ-ذ ؤُعفَّانْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","أَقَا ذِينِّي بَالَاكْ خمْسِينْ ن إِمْسڭَّاذنْ ذَاخڒْ إِ ثنْذِينْثْ. مَا س ثِيذتّْ أَذْ ثنْ ثَارذْدْجذْ، ؤُ وَارْ ثْسمّْحذْ ذڭْ ومْشَانْ نِّي ذِي طّْوعْ ن خمْسِينْ ن إِمْسڭَّاذنْ إِ ذَايسْ إِدْجَانْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","إِڭّْوجْ خَاكْ أَذْ ثڭّذْ أَيَا، أَذْ ثنْغذْ أَمْسڭّذْ أَكْ-ذ ؤُعفَّانْ، وَاهْ، إِڭّْوجْ خَاكْ أَذْ يِيڒِي ؤُمْسڭّذْ محْسُوبْ أَمْ ؤُعفَّانْ. أَقَا ڒْقَاضِي ن دُّونشْثْ مَا وَارْ إِتّڭّْ س ڒْحقّْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ڒخْذنِّي إِنَّا أَسْ سِيذِي: ”مَاڒَا ؤُفِيغْ ذِي سَاذُومْ خمْسِينْ ن إِمْسڭَّاذنْ ذَاخڒْ إِ ثنْذِينْثْ، أَذْ سمْحغْ إِ ومْشَانْ ذِي طّْوعْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","إِبْرَاهِيمْ يَارَّا-د، إِنَّا: ”خْزَارْ ڒخُّو، بْذِيغْ زعّْمغْ أَذْ سِّيوْڒغْ أَكْ-ذ سِيذِي إِنُو، وَاخَّا نشّْ ذ شَاڒْ ذ يِيغّضْ. ");
INSERT INTO rifa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","أَذْ ثَاغْ نقْصنْ زِي خمْسِينْ ن إِمْسڭَّاذنْ خمْسَا، مَا أَذْ ثَارذْدْجذْ خْ خمْسَا نِّي مَارَّا ثَانْذِينْثْ؟“ إِنَّا: ”وَارْ ت تَّارذْدْجغْ مَاڒَا ؤُفِيغْ ذِينْ خمْسَا ؤُ-ربْعِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","يَارْنِي ذڭْ وَاوَاڒْ أَكِيذسْ، إِنَّا أَسْ: ”أَذْ ثَاغْ أَذْ يِيڒِي أَذْ إِتّْوَافْ ذِينْ أَربْعِينْ!“ يَارَّا-د نتَّا: ”وَارْ ت تّڭّغْ شَا ذِي طّْوعْ ن أَربْعِينْ نِّي.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","خَاسْ ؤُشَا إِنَّا: ”وَارْ تّْخيِّيقْ ڒخُّو سِيذِي إِنُو، خْمِي غَا سِّيوْڒغْ عَاوذْ. أَذْ ثَاغْ أَذْ يِيڒِي ذِينْ ثْڒَاثِينْ!“ يَارَّا-د: ”وَارْ ت تَّارذْدْجغْ مَاڒَا ؤُفِيغْ ذِينْ ثْڒَاثِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","إِنَّا عَاوذْ: ”خْزَارْ ڒخُّو، بْذِيغْ زعْمغْ أَذْ سِّيوْڒغْ أَكْ-ذ سِيذِي إِنُو. أَذْ ثَاغْ أَذْ يِيڒِي ذِينْ مْغِيرْ عِيشْرِينْ!“ يَارَّا-د: ”وَارْ ت تَّارذْدْجغْ شَا ذِي طّْوعْ ن عِيشْرِينْ نِّي.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","خنِّي إِنَّا: ”وَارْ تّْخيِّيقْ ڒخُّو سِيذِي إِنُو، خْمِي غَا سِّيوْڒغْ عَاوذْ. أَذْ ثَاغْ أَذْ يِيڒِي ذِينْ مْغِيرْعشْرَا!“ يَارَّا-د: ”وَارْ ت تَّارذْدْجغْ ذِي طّْوعْ نعشْرَا نِّي.“ ");
INSERT INTO rifa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","خنِّي إِرُوحْ سِيذِي أَوَارْنِي ڒَامِي إِكمّڒْ أَوَاڒْ نّسْ أَكْ-ذ إِبْرَاهِيمْ ؤُشَا إِبْرَاهِيمْ إِذْوڒْ-د غَارْ ومْشَانْ ن ثْزذِّيغْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ؤُشَا إِوْضنْثْ خنِّي ثْنَاينْ ن لْمَالَاكَاثْ نِّي غَارْ سَاذُومْ س دْجِيڒثْ. ثُوغَا لُوطْ إِقِّيمْ غَارْ ثوَّارْثْ ن سَاذُومْ. ؤُمِي ثنْ إِژْرَا لُوطْ، إِكَّارْ مَاحنْذْ أَذْ ثنْ إِڒْقَا ؤُشَا إِبنْذقْ س ؤُغمْبُوبْ نّسْ غَارْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","إِنَّا: ”خْزَارْ، أَ إِسِيذِيثنْ إِنُو، تّْزَاوَاڭغْ كنِّيوْ أَذْ د-ثَاسمْ غَارْ ثَادَّارْثْ ن ؤُمْسخَّارْ نْومْ ؤُشَا أَذْ ذَايسْ ثسّنْسمْ، أَذْ ثسِّيرْذمْ إِضَارنْ نْومْ. خنِّي أَذْ ثْفَاقمْ زِيشْ، أَذْ ثْكمّْڒمْ خْ وبْرِيذْ نْومْ.“ مَاشَا نِيثْنِي نَّانْ: ”لَّ، أَقَا ذڭْ وَازَّايْ أَذْ نقِّيمْ أَذْ نسّنْسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","مَاشَا نتَّا إِكلّفْ خَاسنْ أَطَّاسْ أَڒَامِي أَكِيذسْ رُوحنْ، ؤُذْفنْ غَارْ ثَادَّارْثْ نّسْ ؤُشَا إِڭَّا أَسنْ أَمنْسِي، إِڭّْوَا أَغْرُومْ بْڒَا أَنْثُونْ ؤُشَا شِّينْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","أَقَا قْبڒْ إِ غَا طّْصنْ، قوَّارنْ إِ ثَادَّارْثْ إِرْيَازنْ ن ثنْذِينْثْ، إِرْيَازنْ ن سَاذُومْ، زڭْ ؤُمژْيَانْ أَڒْ أَوسَّارْ، مَارَّا إِوْذَانْ زِي مَارَّا إِمُوشَانْ إِطُّورْفنْ ن ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","نِيثْنِي ڒَاغَانْ إِ لُوطْ، نَّانْ أَسْ: ”مَانِي دْجَانْ إِرْيَازنْ إِنِّي غَاركْ د-يُوسِينْ دْجِيرثْ-أَ؟ سُوفّغْ إِ-ثنْ-د، حِيمَا أَذْ ثنْ نسّنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","إِفّغْ-د غَارْسنْ لُوطْ، غَارْ ثوَّارْثْ، ؤُشَا إِقّنْ ثَاوَّارْثْ أَوَارْنِي أَسْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","إِنَّا: ”تّْزَاوْڭغْ، أَ أَيْثْمَا إِنُو، وَارْ تّڭّمْ قَاعْ ڒْغَارْ! ");
INSERT INTO rifa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","خْزَارْ، غَارِي ثْنَاينْ ن يسِّي، ثِينِّي عَاذْ وَارْ إِسِّيننْ أَرْيَازْ. أجّْ أَيِي أَذْ أَومْ ثنْثْ إِ-د-سُّوفّْغغْ بَارَّا ؤُشَا ڭّمْ ذَايْسنْثْ مِينْ ثتّْوَاڒَامْ مْلِيحْ ذِي ثِيطَّاوِينْ نْومْ. مْغِيرْ إِ إِرْيَازنْ-أَ وَارْ ذَايْسنْ تّڭّمْ وَالُو، أَقَا خْ ؤُيَا د-ؤُسِينْ نِيثْنِي سْوَادَّايْ ن ثِيڒِي ن ثْزقَّا إِنُو غَارْ ثْمنْسِيوْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","نِيثْنِي نَّانْ: ”أَڭّْوجْ ذِيهَا!“ ؤُشَا نَّانْ عَاوذْ: ”أَقَا وَانِيثَا يُوسَا-د ذَا ذ أَبَارَّانِي ؤُشَا إِخْسْ أَذْ خَانغْ إِحْكمْ أَمْ ڒْقَاضِي! ڒخُّو أَذْ شكْ نْضَارّْ كْثَارْ زَّايْسنْ.“ ؤُشَا ڭِّينْ أَطَّاسْ ن ؤُغِيڒْ خْ ورْيَازْ نِّي، خْ لُوطْ، ؤُشَا قَارّْبنْ-د حِيمَا أَذْ أَرْژنْ ثَاوَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","مَاشَا إِرْيَازنْ نِّي سّْوِيژّْضنْ أَفُوسْ نْسنْ، سِّيذْفنْ لُوطْ غَارْ ثَادَّارْثْ أَكِيذْسنْ ؤُشَا بلّْعنْ ثَاوَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","نِيثْنِي وْثِينْ إِرْيَازنْ نِّي ثُوغَا إِبدّنْ غَارْ ثوَّارْثْ ن ثَادَّارْثْ س ثُودَّارْغتْشْ، أَمْ ؤُمژْيَانْ أَمْ ؤُمقّْرَانْ، أَڒَامِي سِّيهْڒنْ نِيثْنِي إِخفْ نْسنْ ذِي ثَارزُّوثْ خْ ثوَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","خنِّي نَّانْ إِرْيَازنْ نِّي إِ لُوطْ: ”وِي غَاركْ ذَا عَاذْ؟ مَا أَضڭّْوَاڒْ نِيغْ إِحنْجِيرنْ نِيغْ ثْحنْجِيرِينْ، مَارَّا إِنِّي غَاركْ ذِي ثنْذِينْثْ، أجّْ إِ-ثنْ أَذْ فّْغنْ زڭْ ومْشَانْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","أَقَا أَذْ نَاردّدْجْ أَمْشَانْ-أَ، مِينْزِي ثْغُويِّيثْ نّسْ ثمْغَارْ زَّاثْ إِ وُوذمْ ن سِيذِي، ؤُ سِيذِي إِسّكّْ أَنغْ-د، حِيمَا أَذْ ت نَاردّدْجْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","إِفّغْ لُوطْ ؤُشَا إِسِّيوڒْ أَكْ-ذ إِضڭّْوَاڒنْ نّسْ، إِنِّي إِڭِّينْ أَذْ مڒْشنْ يسِّيسْ، إِنَّا: ”كَّارمْ، فّْغمْ زڭْ ومْشَانْ-أَ، مِينْزِي سِيذِي أَذْ يَاردّدْجْ ثَانْذِينْثْ-أَ.“ مَاشَا إِبَانْ-د إِتّْقصَّارْ ذِي ثِيطَّاوِينْ ن إِضڭّْوَاڒنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ؤُمِي إِصْبحْ ڒْهَاڒْ، سّْقدْجْقنْثْ لْمَالَاكَاثْ لُوطْ، نَّانْثْ: ”كَّارْ، ثكْسِيذْ ثَامْغَارْثْ نّشْ ذ ثْنَاينْ ن يسِّيشْ، ثِينِّي أَكِيذكْ، حِيمَا وَارْ ثْهلِّيكذْ شَا ذِي ڒْمُوعْصِييّثْ ن ثنْذِينْثْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","مَاشَا نتَّا وَارْ إِزْعِيمْ. خنِّي طّْفنْ إِرْيَازنْ نِّي أَفُوسْ نّسْ ذ ؤُفُوسْ ن ثمْغَارْثْ نّسْ ذ إِفَاسّنْ ن ثْنَاينْ ن يسِّيسْ، مِينْزِي سِيذِي ثُوغَا إِخْسْ أَذْ خَاسْ إِحِينّْ. نِيثْنِي سُّوفّْغنْ ث غَارْ بَارَّا، نذْهنْ ث بَارَّا إِ ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","أَڒَامِي ثنْ سُّوفّْغنْ بَارَّا، إِنَّا نتَّا: ”سنْجمْ إِخفْ نّشْ! وَارْ خزَّارْ أَوَارْنِي أَشْ، وَارْ تّْبذِّي ذِي جِّيهثْ-أَ أَمْ ثكْمڒْ. أَرْوڒْ غَارْ إِذُورَارْ، حِيمَا وَارْ ثتّْوَاثحِّيذْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","إِنَّا أَسنْ لُوطْ: ”لَّ، تّْزَاوَاڭغْ، أَ سِيذِي إِنُو! ");
INSERT INTO rifa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","خْزَارْ، أَمْسخَّارْ نّشْ يُوفَا أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، وَاهْ ثسّمْغَارذْ ثَامخْسِيوْثْ نّشْ إِشوَّارنْ، ثنِّي كِيذِي ثڭِّيذْ ؤُمِي ذ أَيِي ثجِّيذْ دَّارغْ. مَاشَا وَارْ زمَّارغْ أَذْ أَروْڒغْ غَارْ إِذُورَارْ قْبڒْ ذ أَيِي غَا إِطّفْ ڒْغَارْ ؤُشَا أَذْ مّْثغْ! ");
INSERT INTO rifa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","خْزَارْ ڒخُّو، ثَانْذِينْثْ-أَ أَقَا ثُوذسْ-د أَطَّاسْ، أَقَا زمَّارغْ أَذْ ذِينِّي أَروْڒغْ. نتَّاثْ ذ ثَامعْنَانُوشْثْ. أجّْ أَيِي أَذْ أَروْڒغْ ڒخُّو ذِينِّي. مَا وَارْ ثدْجِي ذ إِشْثْ ن ثنْذِينْثْ ذ ثَامعْنَانُوشْثْ؟ خنِّي زمَّارغْ أَذْ قِّيمغْ دَّارغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","يَارَّا-د خَاسْ: ”خْزَارْ، ثِيوضْ أَيِي-د عَاوذْ ثْزَاوڭْثْ نّشْ خْ ؤُيَا، وَارْ تَّاردّْدْجغْ شَا ثَانْذِينْثْ مِينْ خفْ ثسِّيوْڒذْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","قدْجقْ، أَرْوڒْ ذِينْ، مِينْزِي وَارْ زمَّارغْ أَذْ ڭّغْ وَالُو أَڒْ د غَا ثَاوْضذْ غَارْ ذِينِّي.“ خْ ؤُيَا سمَّانْ إِسمْ ن ثنْذِينْثْ نِّي صُوغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","أَڒَامِي يِيوضْ لُوطْ غَارْ صُوغَارْ، ثنْقَارْ-د ثْفُوشْثْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","إِجَّا سِيذِي أَذْ إِوّثْ ونْژَارْ خْ سَاذُومْ ؤُ خْ عَامُورَّا، ذ ڒشْبَاريّثْ ذ ثْمسِّي زڭْ ؤُجنَّا زِي غَارْ سِيذِي.    ");
INSERT INTO rifa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","يَاردّدْجْ نتَّا ثِيندَّامْ نِّي ذ مَارَّا أَذوَّارْ نِّي، أَكْ-ذ مَارَّا إِمزْذَاغْ ن ثْندَّامْ نِّي ؤُڒَا ذ أَغمُّويْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ثَامْغَارْثْ نّسْ، ثنِّي ثُويُورْ غَارْ ضفَّارْ نّسْ، ثخْزَارْ أَوَارْنِي أَسْ ؤُشَا ثذْوڒْ ذ إِجّْ ن ؤُقلِّيجْ ن ثْمدْجَاحْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","غَارْ صّْبحْ زِيشْ إِكَّارْ إِبْرَاهِيمْ، يُويُورْ غَارْ ومْشَانْ مَانِي ثُوغَا إِبدّْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","إِسْوضْ غَارْ سَاذُومْ ذ عَامُورَّا ؤُ غَارْ مَارَّا ثَامُّورْثْ ن ؤُذوَّارْ نِّي، ؤُشَا إِژْرَا بلِّي دّخَّانْ إِتّْڭعَّاذْ زِي ثمُّورْثْ أَمْ دّخَّانْ ن إِشْثْ ن ثفْقُونْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","أَڒَامِي يَاردّدْجْ أَربِّي ثِيندَّامْ ن ؤُذوَّارْ نِّي، إِفكَّارْ أَربِّي ذِي إِبْرَاهِيمْ ؤُشَا إِسّكّْ لُوطْ بَارَّا زِي ڒْوسْطْ ن ؤُشڒْوَاوْ، ؤُمِي إِقْڒبْ ثِيندَّامْ إِ ذِي إِزْذغْ لُوطْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","إِڭعّذْ لُوطْ زِي صُوغَارْ ؤُشَا إِرُوحْ إِزْذغْ أَكْ-ذ ثْنَاينْ ن يسِّيسْ ذڭْ إِذُورَارْ، مِينْزِي إِڭّْوذْ أَذْ إِقِّيمْ إِزدّغْ ذِي صُوغَارْ. ؤُشَا إِزْذغْ ذڭْ إِفْرِي أَكْ-ذ ثْنَاينْ ن يسِّيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ثنَّا ثْمنْزُوثْ إِ ثْمَاژُوژْثْ: ”بَابَاثْنغْ ذ أَوسَّارْ، وَارْ إِقِّيمْ ؤُعزْرِي ذِي ثمُّورْثْ أَذْ خَانغْ د-يَاذفْ أَمْ مَامّشْ ثڭُّورْ ذِي مَارَّا دُّونشْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","زِيذْ، أجّْ أَنغْ أَذْ نوْشْ بِينُو إِ بَابَاثْنغْ أَذْ إِسُّو ؤُشَا أَذْ كِيسْ نزّڒْ، مَاحنْذْ أَذْ نوْشْ ثُوذَارْثْ إِ زَّارِيعثْ ن بَابَاثْنغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ذِي دْجِيڒثْ نِّي وْشِينْثْ بِينُو إِ بَابَاثْسنْثْ، إِسْوَا. خنِّي ثُوذفْ ثْمنْزُوثْ، ثطّصْ أَكْ-ذ بَابَاسْ، مَاشَا نتَّا وَارْ يُوشِي شَا بلِّي ثزّڒْ أَكِيذسْ نِيغْ ثكَّارْ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ثِيوشَّا نّسْ ثنَّا ثْمنْزُوثْ إِ ثْمَاژُوژْثْ: ”أَقَا نشّْ زّْڒغْ دْجِيرثْ إِعْذُونْ أَكْ-ذ بَابَا، أَذْ أَسْ نوْشْ أَذْ إِسُّو بِينُو عَاوذْ دْجِيرثْ-أَ. خنِّي أَذْ ثَاذْفذْ شمْ أَذْ كِيذسْ ثزّْڒذْ، مَاحنْذْ أَذْ د-نجّْ جِّيڒْ أَذْ إِقِّيمْ إِدَّارْ زِي ژَّارِيعثْ ن بَابَاثْنغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","وْشِينْثْ بِينُو إِ بَابَاثْسنْثْ عَاوذْ ذِي دْجِيرثْ نِّي، إِسْوَا. خنِّي ثكَّارْ ثْمَاژُوژْثْ ؤُشَا ثطّصْ أَكْ-ذ بَابَاسْ. مَاشَا نتَّا وَارْ يُوشِي شَا بلِّي ثزّڒْ أَكِيذسْ نِيغْ ثكَّارْ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","أَمُّو كْسِينْثْ ثْنَاينْ ن يسِّيسْ ن لُوطْ س دّيْسثْ زِي بَابَاثْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ؤُشَا ثُورُووْ-د ثْمنْزُوثْ أَسيْمِي، ثْڒَاغَا إِسمْ نّسْ مُوآبَ. وَا ذ بَابَاثْسنْثْ ن أَيْثْ ن مُوآبَ غَارْ أَسّْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ثَامَاژُوژْثْ عَاوذْ ثُورُووْ-د أَسيْمِي ؤُشَا ثْڒَاغَا إِسمْ نّسْ بنْ-عَامِّي. نتَّا ذ بَابَاثْسنْ ن إِحنْجِيرنْ ن عَامُّونْ غَارْ أَسّْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","سّنِّي إِسّْمُوطِّييْ إِبْرَاهِيمْ إِقِيضَانْ نّسْ، يُويُورْ غَارْ ثمُّورْثْ ن لْجَانُوبْ. إِزْذغْ نتَّا جَارْ قَاذَاشْ ذ شُورْ ؤُشَا إِقِّيمْ أَمْ ؤُبَارَّانِي ذِي جِيرَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ؤُمِي إِنَّا إِبْرَاهِيمْ خْ سَارَا ثَامْغَارْثْ نّسْ: ”نتَّاثْ ذ ؤُتْشْمَا إِ ثدْجَا!“، إِسّكّْ أَبِيمَالِيكْ، أَجدْجِيذْ ن جِيرَارْ، يِيوِي أَكِيسْ سَارَا.    ");
INSERT INTO rifa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","مَاشَا إِضْهَارْ-د أَربِّي إِ أَبِيمَالِيكْ ذِي ثَارْجِيثْ ن دْجِيرثْ، إِنَّا أَسْ: ”أَقَا ڒخُّو أَذْ ثمّْثذْ ذِي سِّيبّثْ ن ثمْغَارْثْ، ثنِّي د-ثِيوْيذْ أَكِيذكْ، مِينْزِي نتَّاثْ ثمْڒشْ أَكْ-ذ ورْيَازْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","مَاشَا أَبِيمَالِيكْ ثُوغَا وَارْ غَارسْ د-إِقَارّبْ، إِنَّا: ”أَ سِيذِي إِنُو، مَا خنِّي أَذْ ثَاوْضذْ أَذْ ثنْغذْ إِجّْ ن ڒْڭنْسْ إِسڭّْذنْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","مَا وَارْ ذ أَيِي إِنِّي نتَّا: ’نتَّاثْ ذ ؤُتْشْمَا إِ ثدْجَا!‘، ؤُ نتَّاثْ س يِيخفْ نّسْ ثنَّا عَاوذْ: ’نتَّا ذ ؤُمَا إِ يدْجَا!‘ س ثِيذتّْ ن وُوڒْ ؤُ س إِفَاسّنْ إِزْذِيڭنْ إِ ڭِّيغْ أَيَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","إِنَّا أَسْ أَربِّي ذِي ثَارْجِيثْ: ”نشّْ سّْنغْ عَاذْ بلِّي ثڭِّيذْ مَانْ أَيَا س ثِيذتّْ ن وُوڒْ، خْ ؤُيَا حْضِيغْ شكْ حِيمَا وَارْ خَافِي ثْخطِّيضْ ؤُ وَارْ شكْ جِّيغْ أَذْ ت ثْحَاذِيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ڒخُّو، أَرّْ ثَامْغَارْثْ غَارْ ورْيَازْ نّسْ، مِينْزِي نتَّا ذ أَنَابِي ؤُشَا نتَّا أَذْ خَاكْ إِژَّادْجْ، حِيمَا أَذْ ثدَّارذْ. مَاشَا مَاڒَا وَارْ ت ثَارِّيذْ شَا، سّنْ بلِّي أَقَا أَذْ ثمّْثذْ، شكْ ذ مَارَّا مِينْ إِدْجَانْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","إِكَّارْ أَبِيمَالِيكْ زِيشْ غَارْ صّْبحْ. إِڒَاغَا إِ مَارَّا إِمْسخَّارنْ نّسْ، إِنَّا مَارَّا أَوَاڒنْ-أَ ذڭْ إِمزُّوغنْ نْسنْ ؤُشَا إِرْيَازنْ نِّي ذوْڒنْ ڭّْوذنْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","خنِّي إِڒَاغَا أَبِيمَالِيكْ خْ إِبْرَاهِيمْ ؤُشَا إِنَّا أَسْ: ”مِينْ ذ أَنغْ ثڭِّيذْ ذ مِينْ ذِي خْضِيغْ أَكِيذكْ ؤُمِي ثْغضْرذْ خَافِي ؤُ خْ ثْڭلْذِيثْ إِنُو دّنْبْ أَمقّْرَانْ؟ شكْ ثڭِّيذْ أَكِيذِي مِينْ وَارْ إِشُووَّارنْ أَذْ ث ثڭّذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ؤُشَا يَارْنِي إِنَّا أَبِيمَالِيكْ إِ إِبْرَاهِيمْ: ”مِينْ شكْ يجِّينْ ڒَامِي ثڭِّيذْ مَانْ أَيَا؟“ ");
INSERT INTO rifa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","إِنَّا إِبْرَاهِيمْ: ”مِينْزِي نْوِيغْ: ’نِيشَانْ وَارْ ذِينِّي ثِيڭّْوُوذِي زِي أَربِّي ذڭْ ومْشَانْ-أَ ؤُشَا أَذْ أَيِي نْغنْ ذِي سِّيبّثْ ن ثمْغَارْثْ إِنُو.‘ ");
INSERT INTO rifa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ؤُشَا س ثِيذتّْ نتَّاثْ عَاوذْ ذ ؤُتْشْمَا. نتَّاثْ ذ يدْجِيسْ ن بَابَا، مَاشَا وَارْ ثدْجِي ذ يدْجِيسْ ن يمَّا ؤُشَا ثذْوڒْ ذ ثَامْغَارْثْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ؤُمِي ذ أَيِي إِسّثْلعْ أَربِّي زِي ثَادَّارْثْ ن بَابَا، نِّيغْ أَسْ: ’أَذْ يِيڒِي وَا ذ ڒعْڒَامثْ ن ثْمخْسِيوْثْ نّشْ إِشوَّارنْ إِ نشّْ، أَقَا أَذْ ثِينِيذْ ذِي مَارَّا إِمُوشَانْ مَانِي غَا نَاوضْ: نتَّا أَقَا ذ ؤُمَا!‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","خنِّي إِكْسِي أَبِيمَالِيكِي ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ إِسمْغَانْ ذ ثِييَّا ؤُشَا إِوْشَا إِ-ثنْ إِ إِبْرَاهِيمْ ؤُشَا يَارّْ أَسْ سَارَا، ثَامْغَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","إِنَّا أَبِيمَالِيكْ: ”خْزَارْ، ثَامُّورْثْ إِنُو أَقَا-ت قِيبَاتْشْ نّشْ. زْذغْ مَانِي إِ ذ أَشْ د-إِضْهَارْ مْلِيحْ ذِي ثِيطَّاوِينْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","إِ سَارَا إِنَّا: ”خْزَارْ، وْشِيغْ أَڒفْ ن ؤُقِييَّاثْ ن نُّوقَارْثْ إِ ؤُمَامْ. أَقَا أَثنْثْ ذ أَڒحَّافْ خْ ثِيطَّاوِينْ إِ كُوڒْشِي إِنِّي كِيذمْ إِدْجَانْ، وَاهْ، إِ كُوڒْشِي إِذْوڒْ أَمْ-د ذ تِّيقَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","إِژُّودْجْ إِبْرَاهِيمْ إِ أَربِّي ؤُشَا أَربِّي إِسّْڭنْفَا أَبِيمَالِيكْ ذ ثمْغَارْثْ نّسْ ذ ثمْسخَّارِينْ نّسْ ؤُشَا ؤُرْونْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","مِينْزِي ثُوغَا سِيذِي إِبلّعْ قَاعْ مَارَّا ڒمْڒَاوَاثْ ن ثمْغَارِينْ ذِي ثَادَّارْثْ ن أَبِيمَالِيكْ ذِي سِّيبّثْ ن سَارَا، ثَامْغَارْثْ ن إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ؤُشَا يَارْزفْ سِيذِي غَارْ سَارَا، أَمْ مَامّشْ ث إِنَّا، ؤُشَا إِكمّڒْ سِيذِي أَوَاڒْ إِ إِنَّا إِ سَارَا. ");
INSERT INTO rifa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ثكْسِي سَارَا س دّيْسثْ ؤُشَا ثُورُووْ-د إِجّْ ن ؤُسيْمِي إِ إِبْرَاهِيمْ خْ ثوْسَارْ نّسْ، ذِي ڒْمِيجَارْ نِّي إِ ذ أَسْ إِنَّا أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ؤُشَا إِڒَاغَا إِبْرَاهِيمْ إِ مِّيسْ أَسيْمِي، ونِّي ذ أَسْ د-ثُورُووْ سَارَا، إِسْحَاقْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","إِبْرَاهِيمْ إِخْثنْ إِ مِّيسْ إِسْحَاقْ ؤُمِي ثُوغَا غَارسْ ثْمنْيَا ن وُوسَّانْ، أَمْ مَامّشْ ذ أَسْ يُومُورْ أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ثُوغَا غَارْ إِبْرَاهِيمْ مْيَا ن إِسڭّْوُوسَا، أَڒَامِي غَارسْ د-إِخْڒقْ مِّيسْ إِسْحَاقْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ثنَّا سَارَا: ”إِسّضْحشْ أَيِي أَربِّي ؤُ كُوڒْ إِجّْ ونِّي إِ غَا إِسْڒَانْ إِ مَانْ أَيَا، أَذْ إِضْحشْ عَاوذْ أَكِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ثنَّا عَاوذْ: ”مَانْ ونْ إِزعْمنْ أَذْ يِينِي إِ إِبْرَاهِيمْ، أَقَا سَارَا أَذْ ثسُّوطّضْ إِسيْمَانْ؟ أَقَا ؤُرْوغْ أَسْ-د أَحنْجِيرْ خْ ثوْسَارْ نّسْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","إِڭْمَا ؤُسيْمِي ؤُشَا إِتّْوَاكّسْ أَسْ ؤُطُّوضْ. ذڭْ وَاسّْ إِ ذ أَسْ كّْسنْ ؤُطُّوضْ إِ إِسْحَاقْ، إِسّوْجذْ إِبْرَاهِيمْ إِشْثْ ن زَّارْذثْ ثمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ؤُمِي ثژْرَا سَارَا مِّيسْ ن ثْمِيصْرشْثْ هَاجَارْ، ونِّي د-ثُورُووْ هَاجَارْ إِ إِبْرَاهِيمْ، إِقصَّارْ خَاسْ، ");
INSERT INTO rifa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ثنَّا إِ إِبْرَاهِيمْ: ”أَژّڒْ خْ ثَايَّا-يَا ذ مِّيسْ، مِينْزِي مِّيسْ ن ثَايَّا-يَا وَارْ إِوَارّثْ شَا أَكْ-ذ مِّي، أَكْ-ذ إِسْحَاقْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","أَوَاڒْ-أَ إِبَانْ-د ذ أَعفَّانْ أَطَّاسْ ذِي ثِيطَّاوِينْ ن إِبْرَاهِيمْ ذِي سِّيبّثْ ن مِّيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","مَاشَا إِنَّا أَربِّي إِ إِبْرَاهِيمْ: ”وَارْ تّجِّي أَحنْجِيرْ ذ ثَايَّا نّشْ أَذْ إِڒِينْ ذ ثِيسِينفْثْ ذِي ثِيطَّاوِينْ نّشْ. سڒْ غَارْ مَارَّا مِينْ إِ ذ أَشْ غَا ثِينِي سَارَا، مِينْزِي ذِي إِسْحَاقْ أَذْ أَشْ ثِيڒِي زَّارِيعثْ.    ");
INSERT INTO rifa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","أَذْ ڭّغْ عَاوذْ إِجّْ ن ڒْڭنْسْ زِي مِّيسْ ن ثَايَّا-يَا، مِينْزِي ؤُڒَا ذ نتَّا ذ زَّارِيعثْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","خنِّي إِكَّارْ إِبْرَاهِيمْ زِيشْ ؤُشَا إِكْسِي أَغْرُومْ ذ إِشْثْ ن ثشْيَارْثْ ن وَامَانْ، إِوْشَا إِ-ثنْ إِ هَاجَارْ، إِسَّارْسْ أَسْ ثنْ خْ ثغْرُوضْثْ. إِوْشَا أَسْ عَاوذْ أَحنْجِيرْ ؤُشَا إِسّْقبّضْ إِ-ت. ؤُشَا نتَّاثْ ثْرُوحْ، ثنّجْرُو ذِي ڒخْڒَا ن بِئرْ-سبْعَا. ");
INSERT INTO rifa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ڒَْامِي نقْصنْ وَامَانْ زِي ثشْيَارْثْ، ثنْضَارْ أَحنْجِيرْ سَاذُو إِجّْ ن شْبَارْقْ، ");
INSERT INTO rifa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ؤُشَا ثْرُوحْ ثقِّيمْ قِيبَاتْشْ نّسْ ڒَاڭّْوَاجْ ن ثشْثِي ن ڒْقوْسْ، مِينْزِي ثنَّا: ”وَارْ زمَّارغْ أَذْ ژَترغْ مڒْمِي إِ غَا إِمّثْ ؤُحنْجِيرْ.“ أَمُّو إِ ثقِّيمْ قِيبَاتْشْ نّسْ ؤُشَا ثسّْڭعّذْ ثْمِيجَّا نّسْ، ثسْغُويُّو. ");
INSERT INTO rifa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","إِسْڒَا أَربِّي غَارْ ثْمِيجَّا ن ؤُحنْجِيرْ ؤُشَا لْمَالَاكْ ن أَربِّي إِڒَاغَا إِ هَاجَارْ زڭْ ؤُجنَّا، إِنَّا أَسْ: ”مِينْ شمْ يُوغِينْ، هَاجَارْ؟ وَارْ تّڭّْوذْ شَا، مِينْزِي أَربِّي إِسْڒَا ڒْحسّْ ن ؤُحنْجِيرْ، ذِينْ مَانِي إِدْجَا. ");
INSERT INTO rifa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","كَّارْ، سْڭعّذْ أَحنْجِيرْ ؤُشَا طّفْ أَسْ ذڭْ ؤُفُوسْ نّمْ، مِينْزِي أَذْ زَّايسْ ڭّغْ إِجّْ ن ڒْڭنْسْ إِمْغَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ؤُشَا يَارْزمْ أَربِّي ثِيطَّاوِينْ نّسْ، ثژْرَا ڒْعُونْصَارْ ن وَامَانْ. ثْرُوحْ، ثْعمَّارْ ثَاشْيَارْثْ س وَامَانْ، ثوْشَا أَسْ إِ ؤُحنْجِيرْ، أَذْ إِسُو. ");
INSERT INTO rifa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ثُوغَا أَربِّي أَكْ-ذ ؤُحنْجِيرْ، إِيْمَا، إِزْذغْ ذِي ڒخْڒَا ؤُ ثُوغَا-ث ذ أَمْجبَّاذْ نْ ڒْقوْسْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ثُوغَا إِزدّغْ ذِي ڒخْڒَا ن فَارَانْ ؤُشَا ثكْسِي أَسْ-د يمَّاسْ ثَامْغَارْثْ زِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ذِي ڒْوقْثْ نِّي ذ إِشْثْ إِمْسَارْ، بلِّي أَبِيمَالِيكْ أَكْ-ذ فِيكُولْ، أَكُومَانْذَارْ ن ڒْعسْكَارْ نّسْ، إِسِّيوڒْ أَكْ-ذ إِبْرَاهِيمْ، إِنَّا: ”أَربِّي أَقَا-ث أَكِيذكْ ذِي مَارَّا مِينْ ثتّڭّذْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ڒخُّو، جَادْجْ أَيِي غَارْ أَربِّي، أَقَا وَارْ ثتّْغشِّيذْ إِحنْجِيرنْ إِنُو ؤُڒَا ذ أَيَّاونْ إِنُو! مَاشَا س مُوخَاسْ ثَامخْسِيوْثْ إِشوَّارنْ إِ كِيكْ ڭِّيغْ قْبڒْ، أَذْ زَّايسْ ثڭّذْ شكْ أَكِيذِي ؤُ أَكْ-ذ ثمُّورْثْ مَانِي ثقِّيمذْ أَمْ ؤُبَارَّانِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","إِنَّا إِبْرَاهِيمْ: ”نشّْ أَذْ جَّادْجغْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","خَاسْ ؤُشَا إِعيّبْ إِبْرَاهِيمْ أَبِيمَالِيكْ خْ ڒْعُونْصَارْ ن وَامَانْ نِّي إِطّْفنْ زَّايسْ إِمْسخَّارنْ ن أَبِيمَالِيكْ س ؤُغِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","خنِّي إِنَّا أَبِيمَالِيكْ: ”نشّْ وَارْ سِّينغْ وِي إِڭِّينْ مَانْ أَيَا ؤُ شكْ وَارْ ذ أَيِي ث ثنِّيذْ شَا قْبڒْ. أَقَا أَڒْ ڒخُّو إِ زَّايكْ ث سْڒِيغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","إِكْسِي إِبْرَاهِيمْ ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ؤُشَا إِوْشَا أَسْ ثنْ إِ أَبِيمَالِيكْ ؤُشَا نِيثْنِي س ثْنَاينْ إِذْسنْ ڭِّينْ إِجّْ ن ڒْعَاهْذْ جَارْ أَسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","مَاشَا إِسَّارْسْ إِبْرَاهِيمْ سبْعَا ن ثْخسْوِينْ زڭْ وُودْجِي غَارْ ؤُغزْذِيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","خنِّي إِنَّا أَبِيمَالِيكْ إِ إِبْرَاهِيمْ: ”مِينْ عْنَانْثْ سبْعَا ن ثْخسْوِينْ نِّي ثڭِّيذْ غَارْ ؤُغزْذِيسْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","إِنَّا نتَّا: ”كْسِي زعْمَا سبْعَا أَيَا ن ثْخسْوِينْ زڭْ إِفَاسّنْ إِنُو، حِيمَا أَذْ إِڒِينْثْ ذ شّْهَاذثْ ذِي طّْوعْ إِنُو بلِّي نشّْ إِ إِغْزِينْ أَنُو-يَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","خْ ؤُيَا سمَّانْ أَمْشَانْ نِّي بِئرْ-سبْعَا، مِينْزِي نِيثْنِي س ثْنَاينْ إِذْسنْ ثُوغَا جُّودْجنْ ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","أَمُّو إِ ڭِّينْ ڒْعَاهْذْ ذِي بِئرْ-سبْعَا. أَوَارْنِي مَانْ أَيَا إِكَّارْ أَبِيمَالِيكْ أَكْ-ذ فِيكُولْ، أَكُومَانْذَارْ ن ڒْعسْكَارْ نّسْ، إِعْقبْ غَارْ ثمُّورْثْ ن إِفِيلِيسْطِينِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","إِژُّو إِبْرَاهِيمْ إِشْثْ ن ثْشجَّارْثْ ن ثْمَارِيسْثْ ذِي بِئرْ-سبْعَا ؤُشَا إِڒَاغَا ذِينْ إِسمْ ن سِيذِي، أَربِّي ن ڒبْذَا.    ");
INSERT INTO rifa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","إِزْذغْ إِبْرَاهِيمْ أَمْ ؤُبَارَّانِي ذِي ثمُّورْثْ ن إِفِيلِيسْطِينِييّنْ أَطَّاسْ ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","أَوَارْنِي مَانْ أَيَا ثمْسَارْ، أَقَا إِجَارّبْ أَربِّي إِبْرَاهِيمْ، إِنَّا أَسْ: ”إِبْرَاهِيمْ!“ ؤُشَا إِنَّا أَسْ: ”خْزَارْ، نشّْ أَقَا أَيِي ذَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","إِنَّا أَسْ نتَّا: ”كْسِي أَينِّي ن مِّيشْ، ونِّي ثخْسذْ، إِسْحَاقْ، ؤُشَا رُوحْ غَارْ ثمُّورْثْ ن مُورِييَا ؤُشَا ثْقدّْمذْ ث ذِينْ ذ ثَاغْرَاصْثْ خْ يِيجّْ ن وذْرَارْ جَارْ إِذُورَارْ إِ ذ أَشْ غَا إِنِيغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","إِكَّارْ إِبْرَاهِيمْ زِيشْ، إِحزّمْ إِ وغْيُوڒْ نّسْ ؤُشَا إِكْسِي أَكِيذسْ ثْنَاينْ ن إِمْسخَّارنْ نّسْ ذ مِّيسْ إِسْحَاقْ. إِقسّْ أَكشُّوضْ إِ ثوْهِيبْثْ ن ثْغَارْصْثْ، إِكَّارْ، إِرُوحْ ذڭْ وبْرِيذْ غَارْ ومْشَانْ إِ ذ أَسْ إِنَّا أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا إِسّْڭعّذْ إِبْرَاهِيمْ ثَامُوغْڒِي نّسْ ؤُشَا إِژْرَا أَمْشَانْ زِي ڒَاڭّْوَاجْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","إِنَّا إِبْرَاهِيمْ إِ إِمْسخَّارنْ نّسْ: ”رَاجَامْ ذَا أَكْ-ذ وغْيُوڒْ، نشّْ ذ ؤُحنْجِيرْ أَذْ نْرَاحْ ذِيهَا، أَذْ نسْجذْ. أَوَارْنِي أَسْ أَذْ غَارْومْ د-نعْقبْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","إِكْسِي إِبْرَاهِيمْ أَكشُّوضْ إِ وشْمَاضْ ن ثْغَارْصْثْ، إِسَّارْسْ إِ-ث خْ مِّيسْ إِسْحَاقْ ؤُ نتَّا س يِيخفْ نّسْ إِكْسِي س ؤُفُوسْ نّسْ ثِيمسِّي ذ ثْخذْمشْثْ، ؤُشَا أَمُّو إِ رُوحنْ نِيثْنِي س ثْنَاينْ إِذْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","خنِّي إِسِّيوڒْ إِسْحَاقْ أَكْ-ذ إِبْرَاهِيمْ بَابَاسْ، إِنَّا: ”بَابَا إِنُو!“ إِنَّا نتَّا: ”خْزَارْ، نشّْ أَقَا أَيِي ذَا، مِّي!“ ؤُشَا إِنَّا نتَّا: ”خْزَارْ، أَقَا ذَا ثِيمسِّي ذ ؤُكشُّوضْ، مَاشَا مَانِي إِدْجَا إِزْمَارْ إِ ثْغَارْصْثْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","إِنَّا إِبْرَاهِيمْ: ”أَربِّي سِيمَانْثْ نّسْ أَذْ إِسَّارْزقْ س يزْمَارْ إِ ثْغَارْصْثْ، أَ مِّي!“ ؤُشَا أَمُّو إِ رُوحنْ س ثْنَاينْ إِذْسنْ ");
INSERT INTO rifa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ؤُشَا إِوْضنْ غَارْ ومْشَانْ نِّي إِ ذ أَسْ إِنَّا أَربِّي. ذِينْ إِ إِبْنَا إِبْرَاهِيمْ إِجّْ ن ؤُعَالْطَارْ ؤُشَا إِعْذڒْ أَكشُّوضْ، إِشَارْفْ مِّيسْ إِسْحَاقْ ؤُشَا إِسَّارْسْ إِ-ث خْ ؤُعَالْطَارْ خْ إِكشْوَاضْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","خَاسْ ؤُشَا إِسّْوِيژّضْ إِبْرَاهِيمْ أَفُوسْ نّسْ ؤُشَا إِكْسِي-د ثَاخذْمشْثْ، حِيمَا أَذْ إِغَارْصْ إِ مِّيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","مَاشَا لْمَالَاكْ ن سِيذِي إِڒَاغَا أَسْ-د زڭْ ؤُجنَّا، إِنَّا أَسْ: ”إِبْرَاهِيمْ، إِبْرَاهِيمْ!“ نتَّا إِنَّا: ”نشّْ أَقَا أَيِي ذَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","خنِّي إِنَّا أَسْ: ”وَارْ سْوِيژِّيضْ أَفُوسْ نّشْ غَارْ ؤُحنْجِيرْ. وَارْ ذ تّڭّْ شَا، مِينْزِي ڒخُّو أَقَا سّْنغْ بلِّي ثتّڭّْوذذْ أَربِّي ؤُ وَارْ خَافِي ثسّْعِيزّذْ أَينِّي ن مِّيشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","إِسّْڭعّذْ إِبْرَاهِيمْ ثِيطَّاوِينْ نّسْ، ؤُ خْزَارْ، أَقَا أَوَارْنِي أَسْ ثُوغَا إِجّْ ن إِشَارِّي إِقّنْ غَارْ شْبَارْقْ زڭْ وَاشَّاونْ نّسْ. يُويُورْ إِبْرَاهِيمْ ذِينِّي، إِطّفْ إِشَارِّي ؤُشَا إِڭَّا-إِ-ث ذ ثَاغَارْصْثْ ذڭْ ومْشَانْ ن مِّيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","إِڒَاغَا إِبْرَاهِيمْ إِسمْ ن ومْشَانْ نِّي: ”سِيذِي أَذْ إِسَّارْزقْ!“ س ؤُينِّي إِقَّارْ بْنَاذمْ أَڒْ أَسّْ-أَ: ”ذڭْ وذْرَارْ ن سِيذِي أَذْ يِيڒِي يَارْزقْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","إِڒَاغَا-د لْمَالَاكْ ن سِيذِي وِيسّْ مَارْثَاينْ زڭْ ؤُجنَّا خْ إِبْرَاهِيمْ، ");
INSERT INTO rifa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","إِنَّا: ”مِينْزِي ثڭِّيذْ مَانْ أَيَا ؤُشَا وَارْ خَافِي ثطِّيفذْ أَينِّي ن مِّيشْ، أَذْ جَّادْجغْ خْ سِيمَانْثْ إِنُو، إِقَّارْ سِيذِي، ");
INSERT INTO rifa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","أَقَا أَذْ شكْ بَارْكغْ أَطَّاسْ ؤُشَا أَذْ كتَّارغْ زَّارِيعثْ نّشْ أَطَّاسْ أَمْ يِيثْرَانْ ن ؤُجنَّا ؤُ أَمْ يِيجْذِي خْ ثْمَا ن ڒبْحَارْ. زَّارِيعثْ نّشْ أَذْ ثطّفْ ثَاوَّارْثْ ن ڒْعذْيَانْ نّسْ ذ ڒْوَارْثْ ");
INSERT INTO rifa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ؤُ ذِي زَّارِيعثْ نّشْ أَذْ تّْوَابَارْكنْ مَارَّا ڒڭْنُوسْ ن ثمُّورْثْ، مِينْزِي ثسْڒِيذْ إِ ثْمِيجَّا إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","خنِّي إِعْقبْ-د إِبْرَاهِيمْ غَارْ إِمْسخَّارنْ نّسْ. نِيثْنِي كَّارنْ ؤُشَا رُوحنْ جْمِيعْ ذڭْ وبْرِيذْ غَارْ بِئرْ-سبْعَا، ؤُشَا إِڭَّا إِبْرَاهِيمْ أَذْ إِزْذغْ ذِي بِئرْ-سبْعَا. ");
INSERT INTO rifa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","أَوَارْنِي مَانْ أَيَا إِمْسَارْ أَقَا خبَّارنْ إِبْرَاهِيمْ، نَّانْ أَسْ: ”خْزَارْ، عَاوذْ مِيلْكَا ثُورُووْ-د إِحنْجِيرنْ إِ نَاحُورْ ؤُمَاشْ: ");
INSERT INTO rifa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عُوصْ، أَمنْزُو نّسْ، ذ بُوزْ ؤُمَاسْ، ذ قَامُووِيلْ ونِّي ذ بَابَاسْ ن أَرَامْ، ");
INSERT INTO rifa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ذ كَاسَاذْ ذ حَازُو ذ فِيلْذَاشْ ذ يِيذْلَافْ ذ بِيثُووِيلْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","بِيثُووِيلْ إِجَّا-د رِيفْقَا. ثْمنْيَا أَيَا إِ د-ثُورُووْ مِيلْكَا إِ نَاحُورْ، ؤُمَاسْ ن إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ؤُ ثَايَّا نّسْ، ثنِّي ؤُمِي قَّارنْ رِيعُومَا، ثُورُووْ أَسْ-د عَاوذْ طَابَاحْ ذ جَاحَامْ ذ ثَاحَاشْ ذ مَاعْكَا. ");
INSERT INTO rifa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ثُوغَا غَارْ سَارَا مْيَا ؤُ-سبْعَا ؤُ-عِيشْرِينْ ن إِسڭّْوُوسَا. مَانْ أَيَا ذ ڒْمِيجَاڒْ ن إِسڭّْوُوسَا ن ثُوذَارْثْ ن سَارَا. ");
INSERT INTO rifa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ؤُشَا ثمُّوثْ سَارَا ذِي قَارْيَاثْ-أَرْبَاعْ، إِخْسْ أَذْ يِينِي حَابْرُونْ، ذِي ثمُّورْثْ ن كنْعَانْ. ؤُشَا يُوذفْ-د إِبْرَاهِيمْ غَارْ ؤُقِيضُونْ، إِشْضنْ خْ سَارَا، إِسْغُويْ خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","خَاسْ ؤُشَا إِكَّارْ إِبْرَاهِيمْ طَّارْفْ إِ ؤُمتِّينْ نّسْ، ؤُشَا إِسِّيوڒْ أَكْ-ذ ثَارْوَا ن حِيثْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","”نشّْ ذ أَبَارَّانِي ذ أَمْعزّبْ غَارْ أَومْ. وْشمْ أَيِي مْغِيرْ أَنْضڒْ ذ أَڭْڒَا جَارْ أَومْ، حِيمَا أَذْ نضْڒغْ أَمتِّينْ إِنُو زِي زَّاثْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","أَرِّينْ-د ثَارْوَا ن حِيثْ خْ إِبْرَاهِيمْ، نَّانْ أَسْ: ");
INSERT INTO rifa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","”سڒْ غَارْنغْ، أَ سِيذِي إِنُو! شكْ ذ ڒْحَاكمْ ن أَربِّي جَارْ أَنغْ. نْضڒْ أَمتِّينْ نّشْ ذڭْ ونْضڒْ نّغْ إِصبْحنْ. ؤُڒَا ذ إِجّْ زَّايْنغْ أَذْ شكْ إِطّفْ خْ ونْضڒْ نّسْ، حِيمَا أَذْ ذَايسْ ثْنضْڒذْ أَمتِّينْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","خنِّي إِكَّارْ إِبْرَاهِيمْ، إِبنْذقْ زَّاثْ إِ ڒْڭنْسْ ن ثمُّورْثْ، زَّاثْ إِ ثَارْوَا ن حِيثْ ");
INSERT INTO rifa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ؤُشَا إِسِّيوڒْ أَكِيذْسنْ، إِنَّا: ”مَاڒَا كنِّيوْ س أَرَّايْ نْومْ أَذْ نضْڒغْ أَمتِّينْ إِنُو زِي زَّاثْ إِنُو، سْڒمْ غَارِي ؤُشَا زَاوْڭمْ ذِي طّْوعْ إِنُو غَارْ عِيفْرُونْ، مِّيسْ ن زُوهَارْ، ");
INSERT INTO rifa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","مَاحنْذْ أَذْ أَيِي إِوْشْ إِفْرِي ن مَاكْفِيلَا، ذ ونِّي نّسْ، غَارْ طَّارْفْ ن ييَّارْ نّسْ. أجّْ إِ-ث أَذْ أَيِي ث إِوْشْ س تَّامَانْ نّسْ إِكْمڒْ. أَذْ يِيڒِي ذ أَنْضڒْ إِنُو إِ غَا ملّْكغْ جَارْ أَومْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","عِيفْرُونْ ثُوغَا إِقِّيمْ جَارْ ثَارْوَا ن حِيثْ ؤُشَا عِيفْرُونْ، أَحِيتِّي، يَارَّا-د خْ إِبْرَاهِيمْ ذڭْ إِمجَّانْ ن ثَارْوَا ن حِيثْ ذ مَارَّا إِنِّي يُوذْفنْ غَارْ ثوَّارْثْ ن ثنْذِينْثْ نّسْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","”لَّ، أَ سِيذِي إِنُو، سڒْ-د غَارِي! نشّْ أَذْ أَشْ وْشغْ إِيَّارْ ؤُڒَا ذ إِفْرِي نِّي ذَايسْ إِدْجَانْ. زَّاثْ إِ ثِيطَّاوِينْ ن ثَارْوَا ن ڒْڭنْسْ إِنُو أَذْ أَشْ ث وْشغْ، نْضڒْ أَمتِّينْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","خنِّي إِبنْذقْ إِبْرَاهِيمْ س ؤُغمْبُوبْ نّسْ غَارْ ثمُّورْثْ زَّاثْ إِ ڒْڭنْسْ ن ثمُّورْثْ ");
INSERT INTO rifa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ؤُشَا إِسِّيوڒْ أَكْ-ذ عِيفْرُونْ ذڭْ إِمزُّوغنْ ن ڒْڭنْسْ ن ثمُّورْثْ، إِنَّا: ”تّْزَاوْڭغْ، مَاڒَا ثخْسذْ، سڒْ-د غَارِي. أَذْ أَشْ وْشغْ نُّوقَارْثْ ن ييَّارْ، قْبڒْ إِ-ت زَّايِي، خنِّي أَذْ ذَايسْ نضْڒغْ أَمتِّينْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","يَارَّا-د عِيفْرُونْ خْ إِبْرَاهِيمْ، إِنَّا أَسْ: ");
INSERT INTO rifa_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","”سِيذِي إِنُو، سڒْ-د غَارِي! مِينْ إِخْسْ أَذْ يِينِي إِيَّارْ إِسكّْوَانْ أَربْعَا-مْيَا شِيقْلُو ن نُّوقَارْثْ جَارْ أَيِي ذ شكْ؟ نْضڒْ أَمتِّينْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","إِسْڒَا إِبْرَاهِيمْ إِ عِيفْرُونْ ؤُشَا إِوْزنْ إِبْرَاهِيمْ إِ عِيفْرُونْ ثْمنْيَاثْ ن نُّوقَارْثْ إِ خفْ إِسِّيوڒْ ذڭْ إِمزُّوغنْ ن ثَارْوَا ن حِيثْ: أَربْعَا-مْيَا شِيقْلُو ن نُّوقَارْثْ، أَمْ ت نُّومنْ إِسبَّابنْ. ");
INSERT INTO rifa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","أَمُّو إِ إِذْوڒْ ييَّارْ ن عِيفْرُونْ، ونِّي إِدْجَانْ ذِي مَاكْفِيلَا أَرنْذَاذْ ن مَامْرِي، إِيَّارْ ذ إِفْرِي ونِّي ذَايسْ إِدْجَانْ ذ مَارَّا ثِيشجُّورَا إِنِّي ذڭْ إِيَّارْ غَارْ إِيْمِيرنْ نّسْ إِ ذ أَسْ د-إِنّْضنْ،    ");
INSERT INTO rifa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ذ أَڭْڒَا ن إِبْرَاهِيمْ زَّاثْ إِ ثَارْوَا ن حِيثْ ذ مَارَّا إِنِّي يُوذْفنْ غَارْ ثوَّارْثْ ن ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","أَوَارْنِي أَيَا إِنْضڒْ إِبْرَاهِيمْ سَارَا، ثَامْغَارْثْ نّسْ، ذڭْ إِفْرِي ن ييَّارْ ن مَاكْفِيلَا قِيبَاتْشْ إِ مَامْرِي، ونِّي إِدْجَانْ ذ حَابْرُونْ ذِي ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","أَمُّو إِ إِذْوڒْ إِيَّارْ أَكْ-ذ يفْرِي إِ ذَايسْ إِدْجَانْ زِي ثَارْوَا ن حِيثْ غَارْ إِبْرَاهِيمْ أَمْ ونْضڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","إِبْرَاهِيمْ ثُوغَا إِوْسَارْ ؤُ إِمْغَارْ ذڭْ وُوسَّانْ ؤُشَا سِيذِي إِبَاركْ إِبْرَاهِيمْ ذِي كُوڒْشِي. ");
INSERT INTO rifa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","خنِّي إِنَّا إِبْرَاهِيمْ إِ ؤُمْسخَّارْ نّسْ أَوسَّارْ نِّي إِدْجَانْ خْ ثَادَّارْثْ نّسْ، أَوْكِيڒْ ن مَارَّا مِينْ غَارسْ: ”أڭّْ ڒخُّو أَفُوسْ نّشْ سَاذُو ثْمصَّاضْثْ إِنُو، ");
INSERT INTO rifa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","أَذْ أَشْ سّْجَّادْجغْ س سِيذِي، أَربِّي ن إِجنْوَانْ ذ أَربِّي ن ثمُّورْثْ، بلِّي وَارْ د-ثتِّيوْيذْ ثَامْغَارْثْ إِ مِّي زِي ثْحنْجِيرِينْ ن أَيْثْ ن كنْعَانْ مَانِي زدّْغغْ نشّْ جَارْ أَسنْ، ");
INSERT INTO rifa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","مَاشَا أَذْ ثْرَاحذْ غَارْ ثمُّورْثْ إِ زِي د-ؤُسِيغْ، غَارْ رَادْجْ إِنُو، مَاحنْذْ أَذْ د-ثَاوْيذْ ثَامْغَارْثْ إِ مِّي إِسْحَاقْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","إِنَّا أَسْ ؤُمْسخَّارْ: ”بَالَاكْ وَارْ ثتّخْسْ ثمْغَارْثْ أَذْ أَيِي د-ثضْفَارْ غَارْ ثمُّورْثْ-أَ. مَا إِتّْخصَّا أَذْ أَرّغْ مِّيشْ غَارْ ثمُّورْثْ نِّي مَانِيسْ د-ثُوسِيذْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","إِنَّا أَسْ إِبْرَاهِيمْ: ”حْضَاثْ، وَارْ د-تَّارِّي شَا مِّي ذِينِّي! ");
INSERT INTO rifa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","سِيذِي، أَربِّي ن إِجنْوَانْ ونِّي ذ أَيِي إِطّْفنْ زِي ثَادَّارْثْ ن بَابَا ؤُ زِي ثمُّورْثْ ن رَادْجْ إِنُو، ونِّي غَارِي إِسِّيوْڒنْ، إِجُّودْجْ أَيِي ؤُمِي ذ أَيِي إِنَّا: ’إِ زَّارِيعثْ نّشْ أَذْ وْشغْ ثَامُّورْثْ-أَ!‘، ذ نتَّا إِ غَا إِسّكّنْ لْمَالَاكْ نّسْ زَّاثْ إِ وُوذمْ نّشْ، مَاحنْذْ أَذْ ثَاوْيذْ سّنِّي ثَامْغَارْثْ إِ مِّي. ");
INSERT INTO rifa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","مَاڒَا ثَامْغَارْثْ وَارْ ثتّخْسْ أَذْ شكْ د-ثضْفَارْ، أَذْ ثِيڒِيذْ ثْڒلِّيذْ زِي ثْجَادْجِيثْ-أَ، مْغِيرْ وَارْ د-تَّارِّي ذِينْ مِّي.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","إِسَّارْسْ ؤُمْسخَّارْ أَفُوسْ نّسْ سَاذُو ثْمصَّاضْثْ ن سِيذِيسْ إِبْرَاهِيمْ إِجُّودْجْ أَسْ خْ مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","إِكْسِي ؤُمْسخَّارْعشْرَا ن إِڒغْمَانْ زڭْ إِڒغْمَانْ ن سِيذِيسْ، إِرُوحْ. ثُوغَا غَارسْ عْڒَامْ كُوڒْ أَڭْڒَا إِغْڒَانْ ن سِيذِيسْ. إِكَّارْ ؤُشَا إِطّفْ أَبْرِيذْ غَارْ ثمُّورْثْ ن أَرَامْ-نَاهْرَايْنْ، أَقَا-ت ذ مِيسُوپُوثَامْيَا، غَارْ ثنْذِينْثْ ن نَاحُورْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","غَارْ ؤُخشِّي ن ثْمذِّيثْ إِجَّا إِڒغْمَانْ أَذْ جّْننْ بَارَّا إِ ثنْذِينْثْ زَّاثْ إِ ڒْعُونْصَارْ ن وَامَانْ، غَارْ ثْسَاعّثْ إِ ذِي د-فّْغنْثْ ثمْغَارِينْ، مَاحنْذْ أَذْ أَيْمنْثْ أَمَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","خنِّي إِنَّا: ”سِيذِي، أَربِّي ن سِيذِي إِنُو إِبْرَاهِيمْ، تّْزَاوَاڭغْ شكْ أَذْ أَيِي ثْعَاوْنذْ أَسّْ-أَ ؤُشَا سْشنْ ثَامخْسِيوْثْ نّشْ إِشوَّارنْ إِ سِيذِي إِنُو إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","أَقَا أَيِي غَارْ ڒْعُونْصَارْ ن وَامَانْ ذ ثْحنْجِيرِينْ ن يرْيَازنْ ن ثنْذِينْثْ أَذْ د-فّْغنْثْ مَاحنْذْ أَذْ أَيْمنْثْ أَمَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","أجّْ ثَابْڒِيغْثْ نِّي ؤُمِي غَا إِنِيغْ: ’سهْوَا-د أَقْبُوشْ نّمْ، مَاڒَا ثخْسذْ، أَذْ سْوغْ!‘، ؤُشَا خنِّي أَذْ ثِينِي: ’سُو، أَذْ وَارْذغْ ؤُڒَا ذ إِڒغْمَانْ نّشْ!‘، أَقَا ذ نتَّاثْ إِ ثڭِّيذْ إِ ؤُمْسخَّارْ نّشْ إِسْحَاقْ، ؤُ س ؤُيَا أَذْ سّْنغْ أَقَا ثسّشْنذْ ثَامخْسِيوْثْ نّشْ إِشوَّارنْ إِ سِيذِي إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ؤُشَا عَاذْ قْبڒْ إِ غَا إِكمّرْ أَوَاڒْ، إِژْرَا رِيفْقَا، ثنِّي إِ د-يُورْونْ إِ بِيثُووِيلْ، مِّيسْ ن مِيلْكَا، ثَامْغَارْثْ ن نَاحُورْ ؤُمَاسْ ن إِبْرَاهِيمْ، ثفّغْ-د زِي ثنْذِينْثْ س وقْبُوشْ نّسْ خْ ثغْرُوضْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ثَابْڒِيغْثْ ثُوغَا ذَايسْ أَژْرِي إِمْغَارْ، ذ ثَاعْزَارشْثْ، وَارْ ت إِسِّينْ ورْيَازْ. نتَّاثْ ثهْوَا-د غَارْ ڒْعُونْصَارْ، ثشُّورْ أَقْبُوشْ نّسْ ؤُشَا ثْڭعّذْ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","يُوزّڒْ غَارسْ ؤُمْسخَّارْ نِّي، إِنَّا: ”تّْزَاوْڭغْ شمْ أَذْ أَيِي ثوْشذْ أَذْ سْوغْ شْوَايْثْ ن وَامَانْ زڭْ وقْبُوشْ نّمْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","نتَّاثْ ثنَّا: ”سُو، أَ سِيذِي إِنُو!“ ثْقدْجقْ ثسّهْوَا أَقْبُوشْ نّسْ خْ ؤُفُوسْ نّسْ، ثوْشَا أَسْ أَذْ إِسُو. ");
INSERT INTO rifa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ڒَْامِي ذ أَسْ ثوْشَا إِسْوَا مْلِيحْ، ثنَّا: ”أَذْ أَيْمغْ أَمَانْ عَاوذْ إِ إِڒغْمَانْ نّشْ، أَڒْ غَارْسنْ إِ غَا يِيڒِي س زّْيَاذَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ثْقدْجقْ ثسّخْوَا أَقْبُوشْ ذِي ثَارْيَا، ثُوزّڒْ عَاوذْ غَارْ ڒْعُونْصَارْ، حِيمَا أَذْ ثَايمْ أَمَانْ، ؤُشَا ثُويمْ أَسنْ-د أَمَانْ إِ إِڒغْمَانْ نّسْ مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","وَاخَّا إِثبْهثْ ذَايسْ ورْيَازْ، إِسْقَارْ، حِيمَا أَذْ إِسّنْ مَا سِيذِي إِسّهْونْ خَاسْ أَبْرِيذْ نّسْ نِيغْ لَّا. ");
INSERT INTO rifa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ؤُمِي جِّيوْننْ إِڒغْمَانْ ثِيسسِّي، إِكْسِي ورْيَازْ ذڭْ إِجّْ ن ؤُمُورْ إِشْثْ ن ثْخَاذنْثْ ن وُورغْ، ثنِّي إِوزْننْ أَزْينْ شِيقْلُو، ذ ثْنَاينْ ن ثْمقْيَاسِينْ إِ إِفَاسّنْ نّسْ، ثِينِّي إِوزْننْعشْرَا شِيقْلُو ن وُورغْ، ");
INSERT INTO rifa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","إِنَّا: ”إِنِي أَيِي، ؤُمِي ثڭِّيذْ ذ يدْجِيسْ؟ مَا أَقَا ذِينْ أَمْشَانْ ذِي ثَادَّارْثْ ن بَابَامْ مَانِي نْزمَّارْ أَذْ نسّنْسْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","نتَّاثْ ثنَّا أَسْ: ”نشّْ ذ يدْجِيسْ ن بِيثُووِيلْ، مِّيسْ ن مِيلْكَا، ونِّي إِ-ت-إِ-د-يُورْونْ إِ نَاحُورْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ؤُشَا ثَارْنِي ثنَّا أَسْ: ”أَقَا عَاوذْ غَارْنغْ أَطَّاسْ ن ؤُڒُومْ ذ إِغدْجْ، ؤُ غَارْنغْ عَاوذْ أَمْشَانْ إِ ثْمنْسِيوْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ؤُشَا يُوضَارْ ورْيَازْ ؤُشَا إِبنْذقْ إِ سِيذِي، ");
INSERT INTO rifa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","إِنَّا: ”أَذْ إِتّْوَابَاركْ سِيذِي، أَربِّي ن سِيذِي إِنُو إِبْرَاهِيمْ، ونِّي وَارْ إِكِّيسنْ ثَامخْسِيوْثْ نّسْ إِشوَّارنْ ذ ڒَامَانْ نّسْ زِي سِيذِي إِنُو. إِنْذهْ أَيِي سِيذِي ذڭْ وبْرِيذْ غَارْ ثَادَّارْثْ ن وَاوْمَاثنْ ن سِيذِي إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ثُوزّڒْ ثبْڒِيغْثْ، ثْعَاوذْ ثِيمسْڒَايِينْ-أَ إِ يمَّاسْ ذِي ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ؤُشَا رِيفْقَا ثُوغَا غَارسْ ؤُمَاسْ، قَّارنْ أَسْ لَابَانْ، ؤُشَا لَابَانْ يُوزّڒْ غَارْ ورْيَازْ نِّي ثُوغَا ذِينْ ذِي بَارَّا غَارْ ڒْعُونْصَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ثُوغَا إِژْرَا ثَاخَاذنْثْ ذ ثْنَاينْ ن ثْمقْيَاسِينْ ذڭْ إِفَاسّنْ ن ؤُتْشْمَاسْ ؤُشَا إِسْڒَا إِ وَاوَاڒنْ إِ ثُوغَا ثقَّارْ ؤُتْشْمَاسْ رِيفْقَا، ثنَّا: ”أَمُّو إِ كِيذِي إِسِّيوڒْ ورْيَازْ نِّي.“ ؤُشَا يُويُورْ غَارْ ورْيَازْ. خْزَارْ، إِبدّْ ذِيهَا زَّاثْ إِ إِڒغْمَانْ، غَارْ ڒْعُونْصَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","إِنَّا: ”أَرَاحْ-د، أَ شكْ ذ أَمِيمُونْ ن سِيذِي! مَايمِّي ثقِّيمذْ ذِي بَارَّا، نشّْ أَقَا سّْوجْذغْ ثَادَّارْثْ ذ ومْشَانْ إِ إِڒغْمَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","إِرُوحْ ورْيَازْ أَكِيذسْ غَارْ ثَادَّارْثْ ؤُ نتَّا إِضْڒقْ إِ إِسغْوَانْ ن إِڒغْمَانْ. نتَّا إِوْشَا أَسنْ ڒُومْ ذ مَاشَّا، ؤُشَا إِكْسِي أَمَانْ، حِيمَا أَذْ إِسِّيرْذْ إِضَارنْ نّسْ ؤُڒَا ذ إِضَارنْ ن إِرْيَازنْ نِّي كِيذسْ إِدْجَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","إِسَّارْسْ زَّاثسْ مِينْ غَا يشّْ. ؤُشَا نتَّا إِنَّا: ”وَارْ تّتّغْ قْبڒْ إِ غَا إِنِيغْ ثَابْرَاثْ إِنُو.“ نتَّا إِنَّا أَسْ: ”سِيوڒْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","خنِّي إِنَّا: ”نشّْ ذ أَمْسخَّارْ ن إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","سِيذِي إِبَارْكْ سِيذِي إِنُو أَطَّاسْ س وَاطَّاسْ ؤُشَا شَّانْ نّسْ إِمْغَارْ أَطَّاسْ. أَقَا إِوْشَا أَسْ ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ، نُّوقَارْثْ ذ وُورغْ، إِسمْغَانْ ذ ثِييَّا، إِڒغْمَانْ ذ يغْيَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ذ سَارَا، ثَامْغَارْثْ ن سِيذِي إِنُو، ثُورُووْ-د أَحنْجِيرْ إِ سِيذِي إِنُو أَوَارْنِي ؤُمِي ثوْسَارْ ؤُ نتَّا إِوْشَا أَسْ مَارَّا مِينْ غَارسْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ؤُشَا سِيذِي إِنُو إِجَّا أَيِي جُّودْجغْ، إِنَّا: ’وَارْ د-تَّاوِي ثَامْغَارْثْ إِ مِّي زِي ثْحنْجِيرِينْ ن أَيْثْ ن كنْعَانْ إِنِّي مَانِي زذْغغْ ذِي ثمُّورْثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ؤُشْثْ خَاكْ مَاڒَا وَارْ تّْرِيحذْ غَارْ ثَادَّارْثْ ن بَابَا، غَارْ رَادْجْ إِنُو ؤُشَا أَذْ د-ثَاوْيذْ ثَامْغَارْثْ إِ مِّي سّنِّي.‘ ");
INSERT INTO rifa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","خنِّي نشّْ نِّيغْ إِ سِيذِي إِنُو: ’بَالَاكْ ثَامْغَارْثْ وَارْ ذ أَيِي د-ثْضفَّارْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ؤُشَا نتَّا إِنَّا أَيِي: ’سِيذِي إِ ؤُمِي ؤُيُورغْ زَّاثْ إِ وُوذمْ نّسْ، أَقَا نتَّا أَذْ د-إِسّكّْ لْمَالَاكْ نّسْ أَكِيذكْ ؤُشَا أَذْ خَاكْ إِسّهْونْ أَبْرِيذْ نّشْ أَڒْ د غَا ثَاوْيذْ إِ مِّي إِشْثْ ن ثمْغَارْثْ زِي ڒَادْجْ إِنُو ؤُ زِي ثَادَّارْثْ ن بَابَا. ");
INSERT INTO rifa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","أَذْ ثِيڒِيذْ ثْفكّذْ زِي ثْجَادْجِيثْ إِ ذ أَيِي ثجُّودْجذْ، خْمِي غَا ثْرَاحذْ غَارْ ڒَادْجْ إِنُو ؤُ نِيثْنِي وَارْ ذ أَشْ ت تِّيشنْ، خنِّي أَذْ شكْ سُّوفّْغغْ زِي ثْجَادْجِيثْ نّشْ إِ ثُوغَا ثجُّودْجذْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","أَسّْ-أَ ؤُسِيغْ-د غَارْ ڒْعُونْصَارْ ؤُشَا نِّيغْ: ’أَ سِيذِي، أَربِّي ن سِيذِي إِنُو إِبْرَاهِيمْ، تّْزَاوَاڭغْ أَذْ ثسّْهوْنذْ ڒخُّو أَبْرِيذْ إِ ذِي ڭُّورغْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","أَقَا أَيِي ذَا زَّاثْ إِ ڒْعُونْصَارْ ن وَامَانْ. أجّْ أَذْ ثِيڒِي أَمُّو، أَقَا ثَاعْزَارشْثْ، ثنِّي د غَا إِفّْغنْ، مَاحنْذْ أَذْ ثَايمْ أَمَانْ ؤُ إِ ثنِّي ؤُمِي غَا إِنِيغْ: أوْشْ أَيِي أَذْ سْوغْ شْوَايْثْ ن وَامَانْ زڭْ ؤُقْبُوشْ نّمْ! ");
INSERT INTO rifa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ؤُشَا خنِّي نتَّاثْ أَذْ أَيِي ثِينِي: سُو شكْ ؤُ نشّْ أَذْ أَيْمغْ عَاوذْ إِ إِڒغْمَانْ نّشْ!، ذ ثَا أَذْ ثِيڒِي ذ ثَامْغَارْثْ نِّي ذ إِسّوْجذْ سِيذِي إِ مِّيسْ ن سِيذِي إِنُو.‘ ");
INSERT INTO rifa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ؤُشَا قْبڒْ إِ غَا كمّْڒغْ ثَاژَادْجِيثْ-أَ ذڭْ وُوڒْ إِنُو، خْزَارْ، رِيفْقَا ثفّغْ-د س ؤُقْبُوشْ نّسْ خْ ثغْرُوضْثْ نّسْ، ثهْوَا غَارْ ڒْعُونْصَارْ ؤُشَا ثُويمْ-د أَمَانْ. نِّيغْ أَسْ: ’تّْزَاوْڭغْ شمْ أَذْ أَيِي ثوْشذْ أَذْ سْوغْ!‘ ");
INSERT INTO rifa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ذغْيَا ثسّهْوَا أَقْبُوشْ نّسْ، ثنَّا: ’سُو ؤُ نشّْ أَذْ سّسْوغْ عَاوذْ إِڒغْمَانْ نّشْ!‘ سْوِيغْ ؤُشَا نتَّاثْ ثوْشَا عَاوذْ إِ إِڒغْمَانْ أَذْ سْونْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","سّقْسِيغْ ت، نِّيغْ: ’ؤُمِي ثڭِّيذْ ذ يدْجِيسْ؟‘ نتَّاثْ ثَارَّا: ’نشّْ ذ يدْجِيسْ ن بِيثُووِيلْ، مِّيسْ ن نَاحُورْ ونِّي ذ أَسْ د-يُورْونْ مِيلْكَا.‘ خنِّي ڭِّيغْ أَسْ ثَاخَاذنْثْ ذِي ثِينْزَارْثْ نّسْ ذ ثْمقْيَاسِينْ ذڭْ إِفَاسّنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","خَاسْ ؤُشَا ؤُضَارغْ، بنْذْقغْ إِ سِيذِي ؤُشَا بَارْكغْ سِيذِي، أَربِّي ن سِيذِي إِنُو إِبْرَاهِيمْ، ونِّي ذ أَيِي إِنذْهنْ نِيشَانْ ذڭْ وبْرِيذْ، حِيمَا أَذْ د-أَوْيغْ إِدْجِيسْ ن ؤُمَاسْ ن سِيذِي إِنُو ذ ثمْغَارْثْ إِ مِّيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","خنِّي ڒخُّو، مَاڒَا كنِّيوْ ثخْسمْ أَذْ ثسّشْنمْ ثَامخْسِيوْثْ إِشوَّارنْ ذ ڒَامَانْ إِ سِيذِي إِنُو، إِنِي أَيِي ث، مَاڒَا لَّا، إِنِي أَيِي ث عَاوذْ، خنِّي أَذْ كّغْ يفُوسْ نِيغْ ؤُزڒْمَاضْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","خنِّي لَابَانْ ذ بِيثُووِيلْ أَرِّينْ-د، نَّانْ: ”زِي سِيذِي إِ د-إِفّغْ ؤُيَا، وَارْ نْزمَّارْ أَذْ ذَايكْ نِينِي ڒْغَارْ نِيغْ ڒْخَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","خْزَارْ، رِيفْقَا قِيبَاتْشْ نّشْ، كْسِي ت ؤُشَا ثْرُوحذْ. أَذْ ثِيڒِي نتَّاثْ ذ ثَامْغَارْثْ ن مِّيسْ ن سِيذِي نّشْ، أَمْ مَامّشْ إِنَّا سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ؤُمِي إِسْڒَا ؤُمْسخَّارْ ن إِبْرَاهِيمْ أَوَاڒنْ نْسنْ، إِبنْذقْ غَارْ ثمُّورْثْ زَّاثْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ؤُشَا إِسُّوفّغْ-د ؤُمْسخَّارْ ڒقْشُوعْ ن نُّوقَارْثْ ذ ڒقْشُوعْ ن وُورغْ ذ وَارُّوضنْ، إِوْشَا إِ-ثنْ إِ رِيفْقَا. عَاوذْ إِوْشَا ثِيرْزِيفِينْ إِغْڒَانْ إِ ؤُمَاسْ ذ يمَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","شِّينْ، سْوِينْ، نتَّا ذ يرْيَازنْ إِنِّي كِيسْ د-يُوسِينْ. سّنْسنْ ذِينْ ؤُشَا فَاقنْ غَارْ ضّْبحْ. خنِّي إِنَّا: ”سَامْحمْ أَيِي أَذْ رَاحغْ ڒخُّو غَارْ سِيذِي إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","أَرِّينْ-د ؤُمَاسْ ذ يمَّاسْ: ”أجّْ ثَابْڒِيغْثْ أَكِيذْنغْ وَاخَّا مْغِيرْعشْرَا ن وُوسَّانْ، أَوَارْنِي أَسْ أَذْ ثُويُورذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","مَاشَا نتَّا إِنَّا أَسنْ: ”وَارْ ذَايِي ثطِّيفمْ عَاذْ ؤُمِي سِيذِي إِسّهْونْ أَبْرِيذْ إِنُو! مْغِيرْ أجّْ أَيِي أَذْ رَاحغْ غَارْ سِيذِي إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","نِيثْنِي أَرِّينْ-د ڒخْذنِّي: ”أجّْ أَنغْ أَذْ نْڒَاغَا إِ ثبْڒِيغْثْ، أَذْ نْسڒْ إِ مِينْ غَا ثِينِي زڭْ ؤُقمُّومْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ڒَاغَانْ إِ رِيفْقَا ؤُشَا نَّانْ أَسْ: ”مَا أَذْ ثْرَاحذْ شمْ أَكْ-ذ ورْيَازْ-أَ؟“ ؤُشَا نتَّاثْ ثَارَّا-د: ”وَاهْ، أَذْ رَاحغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","خنِّي سّْقبّْضنْ نِيثْنِي رِيفْقَا، ؤُتْشْمَاثْسنْ، أَكْ-ذ ثْمطَّاضْثْ نّسْ، ؤُشَا سّْقبّْضنْ عَاوذْ أَمْسخَّارْ ن إِبْرَاهِيمْ ذ إِرْيَازنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ؤُشَا بَارْكنْ رِيفْقَا، نَّانْ أَسْ: ”أَ ؤُتْشْمَاثْنغْ، أَذْ ثَاوْضذْ أَذْ ثمْغَارذْ ذ ڒُوڒُوفْ نعشْرَا ن ڒُوڒُوفْ ؤُشَا زَّارِيعثْ نّمْ أَذْ ثطّفْ ثَاوَّارْثْ ن يِينِّي ت إِشَارّْهنْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ثكَّارْ رِيفْقَا ذ ثمْسخَّارِينْ نّسْ ثِيمژْيَانِينْ، نْيِينْثْ خْ إِڒغْمَانْ، ضْفَارنْثْ أَرْيَازْ. أَمُّو إِ د-يِيوِي ؤُمْسخَّارْ رِيفْقَا ؤُشَا إِرُوحْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","أَقَا إِفّغْ-د إِسْحَاقْ زڭْ وَانُو ن لَاحَايْ-رُوئِي. ثُوغَا إِزدّغْ ذِي ثمُّورْثْ ن لْجَانُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","إِفّغْ-د إِسْحَاقْ مَاحنْذْ أَذْ إِژَّادْجْ ذڭْ إِيَّارْ. ثُوغَا-ت غَارْ ؤُوطُّو ن ثْمذِّيثْ. نتَّا إِسّْڭعّذْ ثَامُوغْڒِي نّسْ، إِقْشعْ، ؤُ خْزَارْ، إِڒغْمَانْ تّْقَارَّابنْ-د! ");
INSERT INTO rifa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","رِيفْقَا عَاوذْ ثسّْڭعّذْ ثِيطَّاوِينْ نّسْ، ثژْرَا إِسْحَاقْ. نتَّاثْ ثجَّا إِخفْ نّسْ أَذْ ثْضَارْ ذغْيَا خْ وڒْغمْ ");
INSERT INTO rifa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ؤُشَا ثنَّا إِ ؤُمْسخَّارْ: ”مِينْ إِعْنَا ورْيَازْ نِّي د-يُوسِينْ ذڭْ إِيَّارْ غَارْنغْ؟“ ؤُشَا إِنَّا ؤُمْسخَّارْ: ”وَا ذ سِيذِي إِنُو!“ خنِّي ثكْسِي ثَاكنْبُوشْثْ ؤُشَا ثْڒحّفْ. ");
INSERT INTO rifa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ؤُشَا إِعَاوذْ ؤُمْسخَّارْ إِ إِسْحَاقْ مَارَّا مِينْ إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","إِڭوّذْ إِ-ت إِسْحَاقْ غَارْ ؤُقِيضُونْ ن يمَّاسْ سَارَا، يِيوِي رِيفْقَا ؤُشَا نتَّاثْ ثذْوڒْ ذ ثَامْغَارْثْ نّسْ ؤُ نتَّا ثُوغَا إِتّخْسْ إِ-ت. أَمُّو إِ إِفوّجْ إِسْحَاقْ أَوَارْنِي ڒْْموْثْ ن يمَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","إِكْسِي إِبْرَاهِيمْ ثَامْغَارْثْ نّغْنِي، قَّارنْ أَسْ قَاثُورَا.    ");
INSERT INTO rifa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","نتَّا ثُورُووْ أَسْ-د زِيمْرَانْ، يَاقْشَانْ، مِيذْيَانْ، يِيشْبَاقْ ذ شُوحَا. ");
INSERT INTO rifa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","يُوقْشَانْ إِجَّا-د شَابَا ذ ذَاذَانْ. ؤُشَا أَرَّاونْ ن ذَاذَانْ ثُوغَا أَثنْ ذ إِشُّورِييّنْ ذ إِلِيثُوشِييّنْ ذ إِلِييُومِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","إِحنْجِيرنْ ن مِيذْيَانْ ثُوغَا أَثنْ ذ عِييْفَا، عِيفَارْ، حَانُوخْ، أَبِيذَاعْ ذ أَلْذَاعَا. مَارَّا إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن قَاطُورَا. ");
INSERT INTO rifa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","إِبْرَاهِيمْ إِوْشَا مَارَّا مِينْ غَارسْ إِ إِسْحَاقْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","مَاشَا إِ إِحنْجِيرنْ ن ثِييَّا إِ ثُوغَا غَارْ إِبْرَاهِيمْ، إِوْشَا أَسنْ إِبْرَاهِيمْ أَرِّيغَالُوثْ ؤُشَا، أَمْ ث ثُوغَا عَاذْ إِدَّارْ، إِسّكّْ إِ-ثنْ سّنِّي غَارْ شَّارْقْ، غَارْ ثمُّورْثْ ن شَّارْقْ، إِسِّيڭّْوجْ إِ-ثنْ خْ إِسْحَاقْ مِّيسْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","إِبْرَاهِيمْ ثُوغَا إِدَّارْ مْيَا ؤُ-خمْسَا ؤُ-سبْعِينْ ن إِسڭّْوُوسَا، وَا ذ ڒْمِيجَاڒْ ن ثُوذَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","إِضْڒقْ إِبْرَاهِيمْ إِ بُوحْبڒْ نّسْ ؤُشَا إِمُّوثْ ذِي شِّيبْ إِسڭّذْ، ذِي ثوْسَارْ ذ ثْيَاوَانْثْ. ؤُشَا إِمَّارْنِي غَارْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","إِسْحَاقْ ذ إِسْمَاعِيلْ، إِحنْجِيرنْ نّسْ، نضْڒنْ ث ذڭْ إِفْرِي ن مَاكْفِيلَا ذڭْ إِيَّارْ ن عِيفْرُونْ، مِّيسْ ن صُوحَارْ، أَحِيتِّي، إِيَّارْ إِ إِدْجَانْ قِيبَاتْشْ إِ مَامْرِي. ");
INSERT INTO rifa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","إِتّْوَانْضڒْ إِبْرَاهِيمْ ذ ثمْغَارْثْ نّسْ سَارَا ذڭْ إِيَّارْ نِّي إِسْغَا إِبْرَاهِيمْ زِي ثَارْوَا ن حِيثْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","أَوَارْنِي إِ ڒْموْثْ ن إِبْرَاهِيمْ إِبَاركْ أَربِّي مِّيسْ إِسْحَاقْ. ؤُشَا إِزْذغْ إِسْحَاقْ زَّاثْ إِ وَانُو ن لَاحَايْ-رُوئِي. ");
INSERT INTO rifa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي إِسْمَاعِيلْ، مِّيسْ ن إِبْرَاهِيمْ، إِنِّي د-ثجَّا هَاجَارْ، ثَايَّا ن سَارَا زِي مِيصْرَا، إِ إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ذ يِينَا ذ إِسْمَاونْ ن إِحنْجِيرنْ ن إِسْمَاعِيلْ، س إِسْمَاونْ نْسنْ عْلَاحْسَابْ أَخْڒَاقْ نْسنْ. أَمنْزُو ن إِسْمَاعِيلْ ثُوغَا-ث ذ نَابَايُوثْ، خنِّي قِيذَارْ، أَذْبِييِيلْ، مِيبْسَامْ، ");
INSERT INTO rifa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","مِيسْمَا، ذُومَا، مَاسَّا، ");
INSERT INTO rifa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","حَاذَارْ، ثَايْمَا، يَاطُورْ، نَافِيشْ ذ قِيذْمَا. ");
INSERT INTO rifa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ذ يِينَا ذ إِحنْجِيرنْ ن إِسْمَاعِيلْ س إِسْمَاونْ نْسنْ، س ذْشُورَاثْ نْسنْ ذ ڒْمَارَاڭحْ نْسنْ: ثنْعَاشْ ن ڒْحُوكَّامْ س ڒَادْجَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ثُوغَا إِدَّارْ إِسْمَاعِيلْ مْيَا ؤُ-سبْعَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا. خنِّي إِضْڒقْ إِسْمَاعِيلْ إِ بُوحْبڒْ نّسْ، إِمُّوثْ ؤُشَا إِمَّارْنِي غَارْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","نِيثْنِي زدّْغنْ زِي حَاوِيلَا غَارْ شُورْ، ونِّي إِدْجَانْ أَرنْذَاذْ ن مِيصْرَا، أَمْ ثطّْفذْ أَبْرِيذْ غَارْ أَشُّورْ. نتَّا إِزْذغْ أَرنْذَاذْ ن مَارَّا أَيْثْمَاسْ. إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي إِسْحَاقْ، مِّيسْ ن إِبْرَاهِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","إِبْرَاهِيمْ إِجَّا-د إِسْحَاقْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ثُوغَا غَارْ إِسْحَاقْ أَربْعِينْ ن إِسڭّْوُوسَا ؤُمِي يِيوِي رِيفْقَا ذ ثَامْغَارْثْ. نتَّاثْ ذ يدْجِيسْ ن بِيثُووِيلْ، أَرَامِييُو زِي فَادَّانْ-أَرَامْ، ؤُتْشْمَاسْ ن لَابَانْ، أَرَامِييُو. ");
INSERT INTO rifa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","إِحشّمْ إِسْحَاقْ سِيذِي ذِي طّْوعْ ن ثمْغَارْثْ نّسْ، ثنِّي ثُوغَا وَارْ إِتِّيرْونْ شَا، ؤُشَا إِسْثَاجبْ أَسْ سِيذِي س ثْژَادْجِيثْ نّسْ يُودْجْغنْ، أَڒَامِي ثكْسِي ثمْغَارْثْ نّسْ، رِيفْقَا، دّيْسثْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ؤُشَا مّْذحْسنْ إِحنْجِيرنْ ذڭْ ؤُعذِّيسْ نّسْ. خنِّي ثنَّا: ”مَانَاوْيَا عَاوذْ، مَايمِّي ذ أَيِي إِتّمْسَارْ مَانْ أَيَا؟“، ؤُشَا ثْرُوحْ أَذْ ثسّقْسَا سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","إِنَّا أَسْ سِيذِي: ”أَقَا ذِينْ ثْنَاينْ ن ڒڭْنُوسْ ذِي دّيْسثْ نّمْ ؤُ ثْنَاينْ ن شُّوعُوبْ أَذْ مّْسبْضَانْ زِي ذْوَاخڒْ نّمْ. إِجّْ ن شّعْبْ أَذْ يِيڒِي إِجْهذْ خْ شّعْبْ نّغْنِي ؤُ ونِّي ذ أَمنْزُو أَذْ إِخْذمْ إِ ؤُمَاژُوژْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","أَڒَامِي د-إِوْضنْ وُوسَّانْ نّسْ أَذْ ثَارُو، خْزَارْ، أَقَا ذَا ذڭْ ؤُعذِّيسْ نّسْ أَشْنِيونْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","إِفّغْ-د ؤُمزْوَارْ. ثُوغَا-ث ذ أَزڭّْوَاغْ، إِشعَّارْ قَاعْ أَمْ يِيشْثْ ن ثْهِيضُورْثْ. س ؤُينِّي ڭِّينْ أَسْ عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","أَوَارْنِي أَسْ إِفّغْ-د ؤُمَاسْ. إِطّفْ أَفُوسْ نّسْ ذڭْ ؤُنِيرْزْ ن عِيسُو. س ؤُيَا سمَّانْ ث س يِيسمْ يَاعْقُوبْ. ثُوغَا غَارْ إِسْحَاقْ ستِّينْ ن إِسڭّْوُوسَا غَارْ وخْڒَاقْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ڒَْامِي ڭْمَانْ إِحنْجِيرنْ، إِذْوڒْ عِيسُو ذ إِجّْ ن ورْيَازْ إِسّنْ أَنيْمَارْ، إِجّْ ن ورْيَازْ ن بَارَّا، مَاشَا يَاعْقُوبْ إِذْوڒْ ذ إِجّْ ن ورْيَازْ يَارْسَا، ونِّي إِزدّْغنْ ذڭْ إِقِيضَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","إِسْحَاقْ ثُوغَا إِتّخْسْ عِيسُو، مِينْزِي إِعْجبْ أَسْ أَذْ يشّْ أَيْسُومْ ن ڒْمَاڒْ ن ڒخْڒَا، ؤُ رِيفْقَا ثُوغَا ثتّخْسْ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ؤُشَا إِسّْننِّي يَاعْقُوبْ إِشْثْ ن مَاشَّا، ؤُمِي د-إِعْقبْ عِيسُو زِي ڒخْڒَا، يُوحڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","إِنَّا عِيسُو إِ يَاعْقُوبْ: ”تّْزَاوْڭغْ شكْ أَذْ أَيِي ثوْشذْ أَذْ شّغْ زڭْ ؤُزڭّْوَاغْ، أَزڭّْوَاغْ نِّي ذِيهَا، مَاغَارْ أَقَا فْنِيغْ س ؤُفَاذِي.“ خْ ؤُيَا قَّارنْ أَسْ ’إِذُومْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ڒخْذنِّي إِنَّا يَاعْقُوبْ: ”زنْزْ أَيِي أَسّْ-أَ ڒْْحقّْ نّشْ ن ؤُمنْزُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","إِنَّا عِيسُو: ”خْزَارْ، أَقَا نشّْ أَذْ مّْثغْ، مِينْ غَا ڭّغْ س ڒْْحقّْ ن ؤُمنْزُو؟“ ");
INSERT INTO rifa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","خنِّي إِنَّا يَاعْقُوبْ: ”جَادْجْ أَيِي ڒخُّو!“ ؤُشَا إِجُّودْجْ أَسْ، إِزّنْزْ إِ يَاعْقُوبْ ڒْْحقّْ ن ؤُمنْزُو نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","خَاسْ ؤُشَا إِوْشَا يَاعْقُوبْ إِ عِيسُو أَغْرُومْ ذ ؤُمشْڒِي ن ڒعْذسْ، ؤُ عِيسُو إِشَّا، إِسْوَا، إِكَّارْ، إِرُوحْ. أَمُّو إِسّحْقَارْ عِيسُو ڒْْحقّْ ن ؤُمنْزُو نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ثُوغَا إِدْجَا ڒَاژْ ذِي ثمُّورْثْ، إِجّْ ن ڒَاژْ نّغْنِي خْ ؤُمزْوَارْ نِّي ثُوغَا إِدْجَانْ ذڭْ وُوسَّانْ ن إِبْرَاهِيمْ. س ؤُيَا إِرُوحْ إِسْحَاقْ غَارْ أَبِيمَالِيكْ، أَجدْجِيذْ ن إِفِيلِيسْطِينِييّنْ، غَارْ جّْوَايهْ ن جِيرَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ذِينِّي إِبَانْ أَسْ-د سِيذِي، إِنَّا: ”وَارْ هكّْوِي شَا غَارْ مِيصْرَا. زْذغْ ذِي ثمُّورْثْ إِ ذ أَشْ غَا إِنِيغْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","زْذغْ ذِي ثمُّورْثْ-أَ أَمْ ؤُبَارَّانِي ؤُ نشّْ أَذْ كِيكْ إِڒِيغْ، أَذْ شكْ بَارْكغْ، مِينْزِي إِ شكْ ؤُ إِ زَّارِيعثْ نّشْ ؤُمِي غَا وْشغْ مَارَّا ثِيمُّورَا-يَا ؤُشَا أَذْ كمّْڒغْ ثْجَادْجِيثْ إِ جُّودْجغْ إِ إِبْرَاهِيمْ بَابَاشْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","أَذْ كتَّارغْ زَّارِيعثْ نّشْ أَمْ يِيثْرَانْ ن ؤُجنَّا ؤُشَا أَذْ وْشغْ إِ زَّارِيعثْ نّشْ مَارَّا ثِيمُّورَا-يَا. مَارَّا ڒڭْنُوسْ ن دُّونشْثْ أَذْ تّْوَابَارْكنْ ذِي زَّارِيعثْ نّشْ، ");
INSERT INTO rifa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","مِينْزِي إِسْڒَا إِبْرَاهِيمْ إِ وَاوَاڒْ إِنُو ؤُشَا إِحْضَا مِينْ ذ أَسْ وْشِيغْ مَاحنْذْ أَذْ إِحْضَا: ڒُومُورَاثْ إِنُو، ثِيوصَّا إِنُو ذ إِزرْفَانْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","أَمُّو إِ إِقِّيمْ إِسْحَاقْ إِزدّغْ ذِي جِيرَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ڒَْامِي ث سّقْسَانْ إِرْيَازنْ ن ومْشَانْ نِّي خْ ثمْغَارْثْ نّسْ، إِنَّا أَسنْ: ”نتَّاثْ ذ ؤُتْشْمَا!“، مِينْزِي إِڭّْوذْ أَذْ يِينِي: ”ذ ثَامْغَارْثْ إِنُو!“. مَاغَارْ إِنَّا ذڭْ يِيخفْ نّسْ: ”مَاڒَا وَارْ نِّيغْ أَمنِّي أَذْ أَيِي نْغنْ إِرْيَازنْ ن ومْشَانْ-أَ ذِي طّْوعْ ن رِيفْقَا، مِينْزِي أَقَا ذَايسْ أَژْرِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ڒَامِي ذِينْ إِزْذغْ أَطَّاسْ ن وُوسَّانْ، إِمْسَارْ بلِّي أَبِيمَالِيكْ، أَجدْجِيذْ ن إِفِيلِيسْطِينِييّنْ، إِخْزَارْ-د زِي ڒْكَازِي، إِژْرَا إِسْحَاقْ إِتّْعَاثَابْ رِيفْقَا، ثَامْغَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ؤُشَا إِڒَاغَا أَبِيمَالِيكْ خْ إِسْحَاقْ، إِنَّا أَسْ: ”خْزَارْ، ثَا س ثِيذتّْ ذ ثَامْغَارْثْ نّشْ! مَامّشْ ثڭِّيذْ ثنِّيذْ أَنغْ ذ ؤُتْشْمَا؟“ إِسْحَاقْ إِنَّا أَسْ: ”س مِينْزِي نِّيغْ إِ يِيخفْ إِنُو: ’أَقَا ثِيڒِي أَذْ أَيِي نْغنْ خْ سِّيبّثْ نّسْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","أَبِيمَالِيكْ إِنَّا: ”مَاغَارْ ذ أَنغْ ثڭِّيذْ أَيَا؟ خْ ذْرُوسْ أَذْ يِيڒِي إِطّصْ شَا ن إِجّْ زِي ڒْڭنْسْ أَكْ-ذ ثمْغَارْثْ نّشْ ؤُشَا أَذْ ثِيڒِي ثڭِّيذْ دّنْبْ خْ يِيڒِي نّغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","يُومُورْ أَبِيمَالِيكْ مَارَّا ڒْڭنْسْ، إِنَّا: ”ونِّي إِ غَا إِحَاذَانْ أَرْيَازْ-أَ نِيغْ ثَامْغَارْثْ نّسْ، أَذْ ث نْغنْ نِيشَانْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","إِزَارْعْ إِسْحَاقْ ذِي ثمُّورْثْ نِّي ؤُشَا إِكْسِي أَسڭّْوَاسْ نِّي مْيَا ن إِمُورنْ ن زّْيَاذَا، مِينْزِي إِبَارْكْ إِ-ث سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ثمَّارْنِي شّنْعثْ ن ورْيَازْ نِّي ؤُشَا نتَّا إِقِّيمْ إِمقَّارْ، أَڒَامِي ثذْوڒْ شّنْعثْ نّسْ ذ ثَامقّْرَانْثْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ثُوغَا غَارسْ ؤُدْجِي ؤُ غَارسْ عَاوذْ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ وَاطَّاسْ ن إِسمْغَانْ، أَڒَامِي زَّايسْ ؤُسْمنْ إِفِيلِيسْطِينِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","مَارَّا أَنُوثنْ نِّي غْزَانْ إِمْسخَّارنْ ذڭْ وُوسَّانْ ن إِبْرَاهِيمْ بَابَاسْ، نثْينْ ثنْ إِفِيلِيسْطِينِييّنْ ؤُشَا شُّورنْ ثنْ س ؤُشَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","خنِّي إِنَّا أَبِيمَالِيكْ إِ إِسْحَاقْ: ”بعّذْ خَانغْ، مِينْزِي ثْذوْڒذْ ثْجهْذذْ خَانغْ س وَاطَّاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","إِسْحَاقْ إِرُوحْ سّنِّي، إِوْثَا إِقِيضَانْ نّسْ ذِي ثغْزُورْثْ ن جِيرَارْ ؤُشَا إِزْذغْ ذِينِّي. ");
INSERT INTO rifa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ؤُشَا إِذْوڒْ إِسْحَاقْ إِغْزَا أَنُوثنْ ن وَامَانْ إِنِّي ثُوغَا غْزِينْ ذڭْ وُوسَّانْ ن إِبْرَاهِيمْ بَابَاسْ، إِنِّي نثْينْ إِفِيلِيسْطِينِييّنْ أَوَارْنِي إِ ڒْموْثْ ن إِبْرَاهِيمْ. إِسمَّا ثنْ س إِسْمَاونْ إِنِّي ذ أَسنْ إِڒَاغَا بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ؤُشَا إِمْسخَّارنْ ن إِسْحَاقْ غْزَانْ ذِي ثغْزُورْثْ نِّي ؤُشَا ؤُفِينْ ذِينْ ڒْعُونْصَارْ ن وَامَانْ دَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","خنِّي قَاشْحنْ إِمكْسَاونْ ن جِيرَارْ أَكْ-ذ إِمكْسَاونْ ن إِسْحَاقْ، نَّانْ: ”أَمَانْ نّغْ!“ س ؤُينِّي ڒَاغَانْ إِسمْ ن ڒْعُونْصَارْ نِّي ’عِيسِيقْ‘، مِينْزِي ثُوغَا تّْقَاشَاحنْ خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","خنِّي غْزَانْ إِجّْ ن ڒْعُونْصَارْ نّغْنِي ؤُشَا مّنّْغنْ خَاسْ عَاوذْ. س ؤُينِّي ذ أَسْ إِڭَّا إِسمْ ن ’سِيثْنَا‘. ");
INSERT INTO rifa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ؤُشَا إِبعّذْ سّنِّي، إِغْزَا إِجّْ ن ڒْعُونْصَارْ نّغْنِي، وَارْ خَاسْ قِيشْحنْ شَا ؤُشَا ڭِّينْ أَسْ إِسمْ نّسْ ’رِيحُوبُوثْ‘، إِنَّا: ”ڒخُّو سِيذِي إِوْشَا أَنغْ تَّاسِيعْ ؤُشَا أَذْ غَارْنغْ ثِيڒِي ڒْغِيدْجثْ ذِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ؤُشَا إِڭعّذْ سّنِّي غَارْ بِئرْ-سبْعَا. ");
INSERT INTO rifa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","إِبَانْ أَسْ-د سِيذِي ذِي دْجِيرثْ نِّي، إِنَّا أَسْ: ”نشّْ ذ أَربِّي ن إِبْرَاهِيمْ بَابَاشْ! وَارْ تّڭّْوذْ شَا، أَقَا نشّْ أَكِيذكْ ؤُ نشّْ أَذْ شكْ بَارْكغْ، أَذْ كتَّارغْ زَّارِيعثْ نّشْ ذِي طّْوعْ ن ؤُمْسخَّارْ إِنُو إِبْرَاهِيمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","خنِّي إِبْنَا ذِينْ إِجّْ ن ؤُعَالْطَارْ مِينْ خفْ إِڭَّا ثَاغَارْصْثْ، ؤُشَا إِڒَاغَا إِسمْ ن سِيذِي. إِوْثَا ذِينْ أَقِيضُونْ نّسْ ؤُشَا غْزِينْ ذِينْ إِمْسخَّارنْ ن إِسْحَاقْ إِجّْ ن وَانُو. ");
INSERT INTO rifa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","أَبِيمَالِيكْ يُوسَا-د غَارسْ زِي جِيرَارْ، أَكْ-ذ أَحُوزَّاثْ، أَمدُّوكّڒْ نّسْ، ذ فِيكُولْ، أَكُومَانْذَارْ ن ڒْعسْكَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","إِنَّا أَسنْ إِسْحَاقْ: ”مَاغَارْ غَارِي د-ثُوسِيمْ، وَاخَّا كنِّيوْ ثْشَارّْهمْ أَيِي ؤُشَا ثسُّوفّْغمْ أَيِي خَاومْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","نِيثْنِي نَّانْ: ”أَقَا نژْرَا بلِّي سِيذِي أَكِيذكْ. س ؤُيَا ننَّا، أَذْ ذِينْ ثِيڒِي ڒخُّو إِشْثْ ن ثْجَادْجِيثْ جَارَانغْ، جَارَانغْ ذ شكْ، ؤُشَا أجّْ أَنغْ أَذْ كِيكْ نڭّْ إِجّْ ن ڒْعَاهْذْ، ");
INSERT INTO rifa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","حِيمَا شكْ وَارْ ذ أَنغْ ثتّڭّذْ ڒْغَارْ، أَمْ مَامّشْ ؤُڒَا ذ نشِّينْ وَارْ شكْ نْحِيذِي شَا ؤُشَا أَقَا نمْصُورّفْ أَكِيذكْ مْلِيحْ ؤُشَا نسّكّْ إِ شكْ ذِي ڒَامَانْ. أَقَا شكْ ڒخُّو ذ أَمِيمُونْ ن سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","خنِّي إِڭَّا أَسنْ إِشْثْ ن زَّارْذثْ ؤُشَا شِّينْ، سْوِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","كَّارنْ زِيشْ ؤُشَا جُّودْجنْ إِجّنْ إِ ونّغْنِي. خَاسْ ؤُشَا إِسّْقبّضْ إِ-ثنْ إِسْحَاقْ ؤُشَا رُوحنْ نِيثْنِي زِي غَارسْ ذِي ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ذڭْ وَاسّْ نِّي ذ إِجّْ ؤُسِينْ-د إِمْسخَّارنْ ن إِسْحَاقْ، خبَّارنْ ث خْ وَانُو إِ إِغْزَانْ ؤُشَا نَّانْ أَسْ: ”ذ أَمَانْ إِ نُوفَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","إِسمَّا أَنُو-يَا سبْعَا. خْ ؤُيَا إِ إِدْجَا يِيسمْ ن ثنْذِينْثْ نِّي بِئرْ-سبْعَا، أَڒْ أَسّْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ؤُمِي ثُوغَا غَارْ عِيسُو أَربْعِينْ ن إِسڭّْوُوسَا، يِيوِي يُوذِيثْ، يدْجِيسْ ن بِيرِي، أَحِيتِّي، ذ ثَامْغَارْثْ، ؤُڒَا ذ بَاسْمَاثْ، يدْجِيسْ ن إِلُونْ، أَحِيتِّي. ");
INSERT INTO rifa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ثُوغَا أَثنْثْ ذ ثَارْزُوڭِي ن وُوڒْ إِ إِسْحَاقْ ذ رِيفْقَا. ");
INSERT INTO rifa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ڒَامِي إِذْوڒْ إِسْحَاقْ ذ أَوسَّارْ ؤُ ثِيطَّاوِينْ نّسْعمْشنْثْ أَڒَامِي عْڒَاحَاڒْ وَارْ إِتّْوِيڒِي، إِڒَاغَا عِيسُو، مِّيسْ أَمنْزُو، إِنَّا أَسْ: ”مِّي!“ ؤُشَا نتَّا إِنَّا أَسْ: ”أَقَا أَيِي ذَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ؤُشَا إِنَّا: ”أَقَا نشّْ وْسَارغْ، وَارْ سِّينغْ أَسّْ إِ ذِي غَا مّْثغْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ڒخُّو، كْسِي ڒسْنَاحْ نّشْ ذ وقْرَابْ نّشْ ن فْڒِيثْشَاثْ ذ ڒْقوْسْ نّشْ، ثفّْغذْ غَارْ ڒخْڒَا ؤُشَا ڭْمَارْ أَيِي-د ثَايْمَارْثْ إِ مَاشَّا. ");
INSERT INTO rifa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","سوْجذْ أَيِي-د إِشْثْ ن مَاشَّا إِشْنَانْ إِ ذ أَيِي غَا إِعجْبنْ ؤُشَا ثوْشذْ أَيِي ت-إِ-د، أَذْ ت شّغْ، حِيمَا أَذْ شكْ بَارْكغْ قْبڒْ مَا أَذْ مّْثغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","رِيفْقَا ثُوغَا ثسْڒَا ؤُمِي إِسِّيوڒْ إِسْحَاقْ أَكْ-ذ مِّيسْ عِيسُو. ؤُشَا إِرُوحْ عِيسُو غَارْ ڒخْڒَا حِيمَا أَذْ إِيْمَارْ ثِيميْرَا، مَاحنْذْ أَذْ ت-إِ-د-يَاوِي. ");
INSERT INTO rifa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","خنِّي ثسِّيوڒْ رِيفْقَا أَكْ-ذ يَاعْقُوبْ مِّيسْ، ثنَّا أَسْ: ”خْزَارْ، نشّْ سْڒِيغْ بَابَاشْ إِسَّاوَاڒْ أَكْ-ذ عِيسُو ؤُمَاشْ، إِنَّا أَسْ: ");
INSERT INTO rifa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","’أَوِي أَيِي-د إِشْثْ ن ثيْمَارْثْ ؤُشَا سوْجذْ أَيِي إِشْثْ ن مَاشَّا لمْلِيحْ، مَاحنْذْ أَذْ ت شّغْ، حِيمَا نشّْ أَذْ أَشْ بَارْكغْ قِيبَاتْشْ إِ وُوذمْ ن سِيذِي قْبڒْ إِ غَا مّْثغْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ڒخُّو، مِّي، سڒْ-د غَارِي مِينْ زِي شكْ غَا ؤُمُورغْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ڒُْوهْ غَارْ ثْحِيمَارْثْ ؤُشَا أَوِي أَيِي-د ثْنَاينْ ن إِغَايْضنْ إِمژْيَاننْ زڭْ إِغَايْضنْ. نشّْ أَذْ زَّايْسنْ سّْوجْذغْ إِشْثْ ن مَاشَّا إِشْنَانْ إِ بَابَاشْ، أَمْ مَامّشْ ذ أَسْ إِتَّاعْجِيبْ ");
INSERT INTO rifa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ؤُ إِتّْخصَّا شكْ أَذْ ث ثَاوْيذْ إِ بَابَاشْ، أَذْ يشّْ، حِيمَا أَذْ شكْ إِبَاركْ قْبڒْ ڒْموْثْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","خنِّي إِنَّا يَاعْقُوبْ إِ رِيفْقَا، يمَّاسْ: ”خْزَارْ، عِيسُو ؤُمَا ذ أَرْيَازْ بُو-شْعَارْ ؤُ نشّْ ذ أَرْيَازْ ذ أَڒقَّاغْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","بَالَاكْ أَذْ أَيِي إِحَاذَا بَابَا ؤُشَا أَذْ إِڒِيغْ أَمشْنَاوْ أَغشَّاشْ ذِي ثِيطَّاوِينْ نّسْ. خنِّي أَذْ كْسِيغْ إِشْثْ ن نّعْڒثْ خَافِي، وَارْ كسِّيغْ لْبَارَاكَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","يمَّاسْ ثنَّا أَسْ: ”نّعْڒثْ نّشْ أَذْ ثِيڒِي خَافِي، أَ مِّي! طَاعْ إِ وَاوَاڒْ إِنُو وَاهَا، أَوْيِي ثنْ-د غَارِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","خنِّي نتَّا إِرُوحْ، إِكْسِي ثنْ ؤُشَا يِيوْيِي ثنْ إِ يمَّاسْ. ؤُشَا يمَّاسْ ثڭَّا إِشْثْ ن مَاشَّا إِشْنَانْ أَمْ مَامّشْ ذ أَسْ إِتَّاعْجِيبْ إِ بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ثكْسِي رِيفْقَا أَرُّوضْ إِفشّْحنْ أَطَّاسْ إِ ثُوغَا غَارسْ ذِي ثَادَّارْثْ زڭْ وَارُّوضْ ن عِيسُو، مِّيسْ أَمنْزُو، ؤُشَا ثَارْضْ إِ-ث يَاعْقُوبْ، مِّيسْ أَمَاژُوژْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ثڭَّا أَسْ إِڒمْ ن إِغَايْضنْ إِمژْيَاننْ زڭْ إِغَايْضنْ خْ إِفَاسّنْ نّسْ ؤُ خْ يِيرِي نّسْ أَڒقَّاغْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ثوْشَا مَاشَّا-يَا إِشْنَانْ أَكْ-ذ وغْرُومْ نِّي ثنْڭّْوَا ذڭْ إِفَاسّنْ ن مِّيسْ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","نتَّا يُوسَا-د غَارْ بَابَاسْ، إِنَّا: ”أَ بَابَا!“ نتَّا إِنَّا: ”أَقَا أَيِي ذَا! مِينْ ثعْنِيذْ شكْ، أَ مِّي؟“ ");
INSERT INTO rifa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","إِنَّا يَاعْقُوبْ إِ بَابَاسْ: ”نشّْ ذ عِيسُو، أَمنْزُو نّشْ. ڭِّيغْ مِينْ ذ أَيِي ثنِّيذْ. كَّارْ ڒخُّو، قِّيمْ، أشّْ زِي ثْميْرَا إِنُو، حِيمَا أَذْ أَيِي إِبَاركْ ڒعْمَارْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","خنِّي إِنَّا إِسْحَاقْ إِ مِّيسْ: ”مَامّشْ ثڭِّيذْ ثُوفِيذْ ت ذغْيَا، أَ مِّي؟“ إِنَّا: ”مَاغَارْ سِيذِي، أَربِّي نّشْ، إِڭَّا إِ-ت ذڭْ وبْرِيذْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","إِسْحَاقْ إِنَّا إِ يَاعْقُوبْ: ”قَارّبْ-د ڒخُّو، حِيمَا أَذْ شكْ حَاذِيغْ، أَ مِّي، مَا شكْ ذ مِّي عِيسُو نِيغْ لَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ڒَْامِي د-إِقَارّبْ يَاعْقُوبْ غَارْ بَابَاسْ إِسْحَاقْ، إِحَاذَا ث ؤُشَا إِنَّا: ”ثْمِيجَّا ذ ثْمِيجَّا ن يَاعْقُوبْ، مَاشَا إِفَاسّنْ ذ إِفَاسّنْ ن عِيسُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","نتَّا وَارْ ث إِعْقِيڒْ، مِينْزِي إِفَاسّنْ نّسْ ثُوغَا شعَّارنْ أَمشْنَاوْ إِفَاسّنْ ن عِيسُو ؤُشَا إِبَارْكْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","إِنَّا: ”مَا ذ شكْ ذ مِّي عِيسُو؟“ نتَّا إِنَّا: ”ذ نشّْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","خنِّي إِنَّا: ”سْقَارّبْ أَيِي ت-إِ-د زَّاثِي، حِيمَا أَذْ شّغْ زِي ثْميْرَا ن مِّي، حِيمَا نشّْ أَذْ شكْ بَارْكغْ.“ إِسَّارْسْ إِ-ت-إِ-د زَّاثسْ ؤُشَا إِشَّا. يِيوِي أَسْ-د عَاوذْ بِينُو ؤُشَا إِسْوَا. ");
INSERT INTO rifa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","إِنَّا أَسْ بَابَاسْ إِسْحَاقْ: ”قَارّبْ-د غَارِي ڒخُّو، سُوذمْ أَيِي، أَ مِّي!“ ");
INSERT INTO rifa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ؤُشَا إِقَارّبْ-د غَارسْ، إِسُّوذمْ إِ-ث. إِشمّْ إِسْحَاقْ أَرِّيحثْ ن وَارُّوضْ نّسْ ؤُشَا إِبَارْكْ إِ-ث، إِنَّا: ”خْزَارْ، ڒفْوَاحثْ ن مِّي أَمْ ڒفْوَاحثْ ن ييَّارْ إِ إِبَاركْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","أَذْ أَشْ إِوْشْ أَربِّي زِي نّْذَا ن ؤُجنَّا ؤُ زِي ڒيْذَامْ ن ثمُّورْثْ ؤُڒَا ذ وَاطَّاسْ ن إِمنْذِي ذ بِينُو ن جْذِيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","أَذْ أَشْ خذْمنْ ڒڭْنُوسْ ؤُشَا شُّوعُوبْ أَذْ أَشْ بنْذْقنْ. حْكمْ خْ أَيْثْمَاشْ ؤُ أجّْ إِحنْجِيرنْ ن يمَّاشْ أَذْ أَشْ بنْذْقنْ! إِنِّي شكْ إِ غَا إِنعْڒنْ، أَذْ تّْوَانعْڒنْ، ؤُ إِنِّي شكْ غَا إِبَارْكنْ، أَذْ تّْوَابَارْكنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","أَوَارْنِي ڒَامِي إِكمّڒْ إِسْحَاقْ لْبَارَاكَا إِ يَاعْقُوبْ ؤُشَا أَمْ د-إِفّغْ يَاعْقُوبْ عَاذْ خْ بَابَاسْ إِسْحَاقْ، إِعْقبْ-د عِيسُو، ؤُمَاسْ، زِي ثيْمَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","إِسّوْجذْ خنِّي إِشْثْ ن مَاشَّا إِشْنَانْ ؤُشَا إِكْسِي ت غَارْ بَابَاسْ، إِنَّا أَسْ: ”تّْزَاوْڭغْ، بَابَا، كَّارْ ثشّذْ زِي ثيْمَارْثْ ن مِّيشْ، حِيمَا شكْ أَذْ أَيِي ثْبَارْكذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","إِنَّا أَسْ إِسْحَاقْ، بَابَاسْ: ”مِينْ ثعْنِيذْ شكْ؟“ نتَّا إِنَّا: ”نشّْ ذ مِّيشْ، أَمنْزُو نّشْ، عِيسُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ؤُشَا إِنّخْڒعْ إِسْحَاقْ، إِنَّا: ”مِينْ إِعْنَا وَانِيثَا إِ د-يُوسِينْ ذَا، إِطّفْ ثَايْمَارْثْ ؤُشَا يِيوِي أَيِي ت-إِ-د؟ شِّيغْ زِي مَارَّا مَانْ أَيَا قْبڒْ د-ثُوسِيذْ ؤُشَا نشّْ بَارْكغْ ث ؤُ أَذْ إِتّْوَابَاركْ عَاوذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ؤُمِي إِسْڒَا عِيسُو أَوَاڒنْ ن بَابَاسْ، إِسْغُويْ س يِيجّْ ن ڒعْيَاذْ إِجْهذْ يَارْزڭْ، إِنَّا إِ بَابَاسْ: ”بَاركْ أَيِي ؤُڒَا ذ نشّْ، أَ بَابَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","إِنَّا: ”يُوسَا-د ؤُمَاشْ س ثحْرَايْمشْثْ، إِكْسِي لْبَارَاكَا نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","خنِّي إِنَّا: ”مَا وَارْ إِدْجِي إِسمْ نّسْ س ڒْحقّْ يَاعْقُوبْ؟ أَقَا إِشْمثْ أَيِي ثْنَاينْ ن ثْوَاڒَاوِينْ. إِكْسِي ڒْحقّْ ن ؤُمنْزُو إِنُو ؤُشَا أَقَا ڒخُّو إِكْسِي عَاوذْ لْبَارَاكَا إِنُو.“ خنِّي إِنَّا: ”مَا وَارْ غَاركْ ثقِّيمْ شَا ن لْبَارَاكَا إِ نشّْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","خنِّي يَارَّا-د إِسْحَاقْ، إِنَّا إِ عِيسُو: ”خْزَارْ، نشّْ ڭِّيغْ ث ذ ڒْحَاكمْ خَاكْ ؤُشَا وْشِيغْ أَسْ أَيْثْمَاسْ ذ إِمْسخَّارنْ، ؤُڒَا س إِمنْذِي ذ بِينُو ن جْذِيذْعوّْڒغْ ث. مِينْ ذِينْ عَاذْ، أَذْ أَشْ وْشغْ ڒخُّو، أَ مِّي؟“ ");
INSERT INTO rifa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","إِنَّا عِيسُو إِ بَابَاسْ: ”مَا غَاركْ مْغِيرْ لْبَارَاكَا-يَا وَاهَا، أَ بَابَا؟ بَاركْ أَيِي عَاوذْ، ؤُڒَا ذ نشّْ، أَ بَابَا!“ ؤُشَا إِسّْڭعّذْ عِيسُو ثْمِيجَّا نّسْ، إِسْغُويْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","خنِّي يَارَّا-د إِسْحَاقْ خْ بَابَاسْ، إِنَّا أَسْ: ”خْزَارْ، أَذْ ثِيڒِي ثْزذِّيغْثْ نّشْ إِڭّْوجّنْ خْ ڒيْذَامْ ن ثمُّورْثْ ؤُ خْ نّْذَا ن ؤُجنَّا سنّجْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","س سِّيفْ نّشْ إِ غَا ثقِّيمذْ ثدَّارذْ ؤُ أَذْ ثْخذْمذْ إِ ؤُمَاشْ. مَاشَا خْمِي غَا ثقِّيمذْ أَذْ ثنْهزّذْ، أَذْ إِمْسَارْ أَذْ ثَاوْضذْ أَذْ ثكّْسذْ زَايْڒُو نّسْ خْ يِيرِي نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ؤُشَا إِشَارْهْ عِيسُو يَاعْقُوبْ ذِي سِّيبّثْ ن لْبَارَاكَا إِ زِي ث إِبَاركْ بَابَاسْ، ؤُشَا إِنَّا عِيسُو ذڭْ وُوڒْ نّسْ: ”أَذْ أَوْضنْ وُوسَّانْ ن ؤُعزِّي ن بَابَا، خنِّي أَذْ نْغغْ ؤُمَا يَاعْقُوبْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ؤُمِي نَّانْ إِ رِيفْقَا أَوَاڒنْ ن عِيسُو، مِّيسْ أَمنْزُو، ثسّكّْ إِجّنْ أَذْ إِڒَاغَا إِ يَاعْقُوبْ، مِّيسْ أَمَاژُوژْ، ثنَّا أَسْ: ”خْزَارْ، عِيسُو ؤُمَاشْ يَارزُّو مَامّشْ زَّايكْ إِ غَا إِخْڒفْ، نتَّا إِخْسْ أَذْ شكْ إِنغْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ڒخُّو، أَ مِّي، طَاعْ إِ وَاوَاڒْ إِنُو. كَّارْ ؤُشَا ثَاروْڒذْ غَارْ حَارَانْ غَارْ ؤُمَا لَابَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","زْذغْ أَكِيذسْ شَا ن وُوسَّانْ أَڒْ غَا يَارْسَا وسْعَارْ ن ؤُمَاشْ. ");
INSERT INTO rifa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","خْمِي غَا إِخْسِي ؤُخيّقْ ن ؤُمَاشْ ؤُشَا أَذْ إِتُّو مِينْ ذ أَسْ ثڭِّيذْ، نشّْ أَذْ سّكّغْ إِجّنْ، مَاحنْذْ أَذْ شكْ د-يَاوِي سّنِّي. مَايمِّي إِ زَّايْومْ غَا تّْوَاحَارّْمغْ س ثْنَاينْ إِذْومْ ذڭْ إِجّْ ن وَاسّْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ثنَّا رِيفْقَا إِ إِسْحَاقْ: ”شَارّْهغْ ثُوذَارْثْ إِنُو ذِي سِّيبّثْ ن يسِّيسْ ن حِيثْ. مَاڒَا يَاعْقُوبْ يِيوِي ثَامْغَارْثْ زِي ثبْڒِيغِينْ ن حِيثْ، أَمْ ثْنَاينْ-أَ، زِي ثْحنْجِيرِينْ ن ثمُّورْثْ-أَ، مَانْ لْقِيمَا إِ غَا يِيڒِينْ غَارْ ثُوذَارْثْ إِنُو؟“ ");
INSERT INTO rifa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","إِڒَاغَا إِسْحَاقْ إِ يَاعْقُوبْ، إِبَاركْ إِ-ث ؤُشَا إِسّكّْ إِ-ث، إِنَّا أَسْ: ”وَارْ تَّاوِي ثَامْغَارْثْ زِي يسِّيسْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","كَّارْ، رُوحْ غَارْ فَاذَانْ-أَرَامْ، غَارْ ثَادَّارْثْ ن بِيثُووِيلْ، بَابَاسْ ن يمَّاشْ، ؤُشَا أَوِي-د سّنِّي ثَامْغَارْثْ إِ شكْ زڭْ يسِّيسْ ن لَابَانْ، ؤُمَاسْ ن يمَّاشْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","أَربِّي، أَمْزمَّارْ خْ كُوڒْشِي، أَذْ شكْ إِبَاركْ ؤُ أَذْ أَشْ إِوْشْ ڒْغِيدْجثْ ؤُشَا أَذْ شكْ إِكتَّارْ أَڒْ غَا ثْذوْڒذْ ذ إِجّْ ن وڭْرَاوْ ن ڒڭْنُوسْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","إِڒِي نتَّا أَذْ أَشْ إِوْشْ لْبَارَاكَا ن إِبْرَاهِيمْ، إِ شكْ ؤُ إِ زَّارِيعثْ نّشْ أَكِيذكْ، حِيمَا أَذْ ثْوَارْثذْ ثَامُّورْثْ نِّي ذِي ثْزدّْغذْ أَمْ ؤُبَارَّانِي، ثنِّي إِوْشَا أَربِّي إِ إِبْرَاهِيمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","خنِّي إِسّكّْ إِسْحَاقْ يَاعْقُوبْ. ؤُشَا نتَّا إِرُوحْ غَارْ فَادَّانْ-أَرَامْ، غَارْ لَابَانْ، مِّيسْ ن بِيثُووِيلْ، أَرَامِييُو، ؤُمَاسْ ن رِيفْقَا، يمَّاسْ ن يَاعْقُوبْ ذ عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ؤُمِي إِژْرَا عِيسُو بلِّي إِسْحَاقْ إِبَاركْ يَاعْقُوبْ ؤُشَا إِسّكّْ إِ-ث-إِ-د غَارْ فَادَّانْ-أَرَامْ حِيمَا أَذْ يَاوِي إِ يِيخفْ نّسْ ثَامْغَارْثْ سّنِّي، ؤُ ڒَامِي ث إِبَاركْ، يُومُورْ إِ-ث، إِنَّا أَسْ: ”وَارْ كسِّي ثَامْغَارْثْ زڭْ يسِّيسْ ن كنْعَانْ!“، ");
INSERT INTO rifa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ؤُشَا إِژْرَا عَاوذْ بلِّي يَاعْقُوبْ إِطَاعْ بَابَاسْ ذ يمَّاسْ، إِرُوحْ غَارْ فَادَّانْ-أَرَامْ، ");
INSERT INTO rifa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","خنِّي إِثْوَاڒَا عِيسُو بلِّي يسِّيسْ ن كنْعَانْ ذ ثِيعفَّانِينْ ذِي ثِيطَّاوِينْ ن بَابَاسْ إِسْحَاقْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","خنِّي إِرُوحْ عِيسُو غَارْ إِسْمَاعِيلْ ؤُشَا يِيوِي مَاحَالَاثْ ذ ثَامْغَارْثْ إِ يِيخفْ نّسْ، يَارْنِي ت-إِ-د غَارْ ثمْغَارِينْ نّغْنِي. نتَّاثْ ثُوغَا-ت ذ يدْجِيسْ ن إِسْمَاعِيلْ، مِّيسْ ن إِبْرَاهِيمْ، ؤُتْشْمَاسْ ن نَابَايُوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ؤُشَا إِفّغْ يَاعْقُوبْ زِي بِئرْ-سبْعَا، إِرُوحْ غَارْ حَارَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","يِيوضْ غَارْ إِجّْ ن ومْشَانْ مَانِي ينْسَا، مِينْزِي ثُوغَا ثَافُوشْثْ ثغْرِي. إِكْسِي زڭْ يژْرَا ن ومْشَانْ نِّي، إِسَّارْسْ إِ-ثنْ سَاذُو ؤُزدْجِيفْ نّسْ ؤُشَا إِوْضَا إِطّصْ ذڭْ ومْشَانْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","يُورْجَا، أَقَا إِجّْ ن دّْرُوجْ إِبدّْ خْ ثمُّورْثْ ؤُشَا إِتّْحَاذَا إِخفْ ن دّْرُوجْ أَجنَّا، ؤُ خْزَارْ، لْمَالَاكَاثْ ن أَربِّي تَّاڒْينْثْ هكّْوَانْثْ زَّايسْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ؤُ خْزَارْ، سِيذِي إِبدّْ خَاسْ، إِنَّا: ”نشّْ ذ سِيذِي، أَربِّي ن بَابَاشْ إِبْرَاهِيمْ، ذ أَربِّي ن إِسْحَاقْ. ثَامُّورْثْ إِ خفْ ثطّْصذْ أَذْ أَشْ ت وْشغْ إِ شكْ ؤُ إِ زَّارِيعثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","أَذْ ثِيڒِي زَّارِيعثْ نّشْ أَمْ ؤُشَاڒْ ن ثمُّورْثْ ؤُشَا أَذْ ثِيرِيوذْ غَارْ ڒْغَارْبْ ذ شَّارْقْ، غَارْ شَّامَالْ ذ لْجَانُوبْ. ذَايكْ ؤُ ذِي زَّارِيعثْ نّشْ أَذْ تّْوَابَارْكنْثْ مَارَّا ڒَادْجَاثْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","أَقَا أَيِي نشّْ أَكِيذكْ ؤُ نشّْ أَذْ شكْ حْضِيغْ قَاعْ مَانِي إِ غَا ثْرَاحذْ، أَذْ شكْ أَرّغْ غَارْ ثمُّورْثْ-أَ، مِينْزِي نشّْ وَارْ شكْ تّجِّيغْ أَڒْ غَا كمّْڒغْ مِينْ ذ أَشْ نِّيغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ڒَامِي د-إِفَاقْ يَاعْقُوبْ زڭْ يِيضصْ نّسْ، إِنَّا: ”س ثِيذتّْ، سِيذِي أَقَا-ث ذڭْ ومْشَانْ-أَ ؤُ نشّْ وَارْ سِّينغْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ثُوغَا إِڭّْوذْ أَطَّاسْ، إِنَّا: ”مشْحَاڒْ إِسَّاڭّْوَاذْ ومْشَانْ-أَ! أَقَا ثَا مْغِيرْ ذ ثَادَّارْثْ ن أَربِّي ؤُ ثَانِيثَا ذ ثَاوَّارْثْ ن ؤُجنَّا!“ ");
INSERT INTO rifa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","إِكَّارْ يَاعْقُوبْ ؤُشَا إِكْسِي أَژْرُو نِّي ثُوغَا إِسَّارْسْ سَاذُو ؤُزدْجِيفْ نّسْ، إِڭَّا إِ-ث أَمْ يِيجّْ ن وژْرُو ن ڒِيذَارثْ ؤُشَا إِفَارّغْ زّشْثْ خْ ؤُزدْجِيفْ ن وژْرُو. ");
INSERT INTO rifa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","إِڭَّا أَمْشَانْ نِّي بَايْثْ-إِلْ، مَاشَا زڭْ ؤُمزْوَارُو ثُوغَا إِسمْ ن ومْشَانْ نِّي لُوزْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ؤُشَا إِوَاعْذْ يَاعْقُوبْ، إِنَّا: ”مَاڒَا أَربِّي أَقَا-ث أَكِيذِي ؤُشَا أَذْ أَيِي إِحْضَا ذڭْ وبْرِيذْ إِ غَا ؤُيُورغْ، أَذْ أَيِي إِوْشْ أَغْرُومْ حِيمَا أَذْ شّغْ، ذ وَارُّوضْ حِيمَا أَذْ أَرْضغْ ");
INSERT INTO rifa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ؤُ مَاڒَا ذوْڒغْ غَارْ ثَادَّارْثْ ن بَابَا ذِي ڒَامَانْ، خنِّي سِيذِي أَذْ يِيڒِي ذ أَربِّي إِ نشّْ. ");
INSERT INTO rifa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ؤُشْ أَژْرُو-يَا إِ ڭِّيغْ ذ أَژْرُو ن ڒِيذَارثْ، أَذْ يِيڒِي ذ ثَادَّارْثْ ن أَربِّي ؤُ زِي مَارَّا مِينْ ذ أَيِي غَا ثوْشذْ، أَذْ أَشْ وْشغْ ڒعْشُورْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","إِكْسِي يَاعْقُوبْ ذڭْ إِضَارنْ نّسْ، إِرُوحْ غَارْ ثمُّورْثْ ن أَيْثْ ن شَّارْقْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","إِخْزَارْ ؤُشَا إِژْرَا إِجّْ ن وَانُو ذڭْ إِيَّارْ ؤُ ثُوغَا ذِينْ ثْڒَاثَا ن ثْحِيمْرِيوِينْ ن وُودْجِي جْنِينْثْ زَّاثسْ، مِينْزِي زڭْ وَانُو نِّي وَارّْذنْ نِيثْنِي ثِيحِيمْرِيوِينْ. ثُوغَا ذِينْ إِجّْ ن وژْرُو خْ ؤُقمُّومْ ن وَانُو. ");
INSERT INTO rifa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","سّْمُوننْ ذِينْ مَارَّا ثِيحِيمْرِيوِينْ. خَاسْ ؤُشَا كّْسنْ أَژْرُو خْ ؤُقمُّومْ ن وَانُو ؤُشَا وَارْذنْ ؤُدْجِي. أَوَارْنِي أَسْ أَرِّينْ أَژْرُو عَاوذْ خْ ؤُقمُّومْ ن وَانُو. ");
INSERT INTO rifa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","إِنَّا أَسنْ يَاعْقُوبْ: ”أَيْثْمَا إِنُو، مَانِيسْ كنِّيوْ؟“ نِيثْنِي أَرِّينْ-د: ”زِي حَارَانْ إِ ندْجْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","نتَّا إِنَّا أَسنْ: ”مَا ثسّْنمْ لَابَانْ، مِّيسْ ن نَاحُورْ؟“ نِيثْنِي أَرِّينْ-د: ”وَاهْ، نسّنْ إِ-ث.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","إِنَّا أَسنْ نتَّا: ”مَامّشْ إِدْجَا؟“ أَرِّينْ-د: ”أَقَا-ث مْلِيحْ، أَقَا ذَا يدْجِيسْ رَاحِيلْ ثُوسَا-د أَكْ-ذ وُودْجِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","إِنَّا أَسْ: ”أَقَا ذَا أَزِيڒْ عَاذْ إِمْغَارْ، وَارْ يدْجِي بُو ڒْوقْثْ حِيمَا أَذْ ننْذهْ ڒبْهَايمْ. وَارْذمْ ؤُدْجِي ؤُشَا رُوحمْ، مَاحنْذْ أَذْ ثنْ ثَاروْسمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","نِيثْنِي أَرِّينْ-د: ”وَارْ نْزمَّارْ أَذْ ث نڭّْ أَڒْ د غَا مُوننْثْ مَارَّا ثِيحِيمْرِيوِينْ. خنِّي أَذْ سّحْڒُودْجْذنْ أَژْرُو خْ ؤُقمُّومْ ن وَانُو، حِيمَا أَذْ نْوَارذْ ؤُدْجِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ڒَامِي ثُوغَا عَاذْ إِسَّاوَاڒْ أَكِيذْسنْ، ثُوسَا-د رَاحِيلْ س وُودْجِي ن بَابَاسْ، مِينْزِي نتَّاثْ ثُوغَا-ت ذ ثَامكْسَاوْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ڒَامِي إِژْرَا يَاعْقُوبْ رَاحِيلْ، يدْجِيسْ ن لَابَانْ، ؤُمَاسْ ن يمَّاسْ، أَكْ-ذ وُودْجِي ن لَابَانْ، ؤُمَاسْ ن يمَّاسْ، إِخشّْ-د يَاعْقُوبْ ؤُشَا إِسّحْڒُودْجذْ أَژْرُو خْ ؤُقمُّومْ ن وَانُو، إِوَارْذْ ؤُدْجِي ن لَابَانْ، ؤُمَاسْ ن يمَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","إِسُّوذمْ يَاعْقُوبْ رَاحِيلْ، إِسّْڭعّذْ ثْمِيجَّا نّسْ ؤُشَا إِسْغُويْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","إِنَّا يَاعْقُوبْ إِ رَاحِيلْ أَقَا نتَّا زِي ڒَادْجْ ن بَابَاسْ إِ إِدْجَا، ؤُڒَا ذ مِّيسْ ن رِيفْقَا. ؤُشَا نتَّاثْ ثُوزّڒْ، ثْخبَّارْ بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ؤُمِي إِسْڒَا لَابَانْ ڒخْبَارْ خْ يَاعْقُوبْ، مِّيسْ ن ؤُتْشْمَاسْ، يُوزّڒْ أَذْ ث إِڒْقَا ؤُشَا إِذَارّعْ أَسْ، إِسُّوذمْ إِ-ث، إِنْذهْ إِ-ث غَارْ ثَادَّارْثْ نّسْ. ؤُشَا نتَّا إِعَاوذْ مَارَّا ثِيمسْڒَايِينْ-أَ إِ لَابَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","إِنَّا أَسْ لَابَانْ: ”ذ ثِيذتّْ شكْ ذ إِغسْ إِنُو ذ أَيْسُومْ إِنُو إِ ثدْجِيذْ.“ ؤُشَا إِقِّيمْ غَارسْ ڒْقدّْ ن إِجّْ ن ؤُيُورْ إِكْمڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ڒخْذنِّي إِنَّا لَابَانْ إِ يَاعْقُوبْ: ”ؤُمِي شكْ ذ ؤُمَا إِ ثدْجِيذْ، مَا أَذْ غَارِي ثْخذْمذْ بَاطڒْ؟ إِنِي أَيِي مِينْ إِ غَا ثِيڒِي ڒْمُونثْ نّشْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","لَابَانْ غَارسْ ثْنَاينْ ن يسِّيسْ. إِسمْ ن ثْمنْزُوثْ ذ لِييَا ؤُ إِسمْ ن ثْمَاژُوژْثْ، رَاحِيلْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ثِيطَّاوِينْ ن لِييَا ثُوغَا كشْعنْثْ، مَاشَا رَاحِيلْ ثُوغَا ذَايسْ أَژْڒِي ن وَادُّوذْ ؤُ ن ڒْخزْرَاثْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","يَاعْقُوبْ إِخْسْ رَاحِيلْ. إِنَّا: ”نشّْ أَذْ غَاركْ خذْمغْ سبْعَا ن إِسڭّْوُوسَا خْ رَاحِيلْ يدْجِيسْ ثْمَاژُوژْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لَابَانْ يَارَّا-د: ”خَارْ أَذْ أَشْ ت وْشغْ إِ شكْ نِيغْ أَذْ ت وْشغْ إِ ورْيَازْ نّغْنِي. قِّيمْ أَكِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","أَمُّو إِ إِخْذمْ يَاعْقُوبْ خْ رَاحِيلْ سبْعَا ن إِسڭّْوُوسَا مَاشَا ضْهَارنْ أَسْ-د إِسڭّْوُوسَا نِّي أَمشْنَاوْ شَا ن وُوسَّانْ، مِينْزِي ثُوغَا إِتّخْسْ إِ-ت. ");
INSERT INTO rifa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","إِنَّا يَاعْقُوبْ إِ لَابَانْ: ”أوْشْ أَيِي ڒخُّو ثَامْغَارْثْ إِنُو، مِينْزِي أَقَا كمّْڒنْ وُوسَّانْ ن ڒْمِيجَاڒْ إِنُو، أَڒَامِي خَاسْ إِ غَا يَاذْفغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","خنِّي إِسّْمُونْ لَابَانْ مَارَّا إِرْيَازنْ ن ومْشَانْ نِّي، إِڭَّا ؤُرَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","غَارْ ثْمذِّيثْ إِكْسِي يدْجِيسْ لِييَا ؤُشَا إِسِّيوضْ إِ-ت غَارسْ ؤُشَا يُوذفْ خَاسْ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","إِوْشَا لَابَانْ ثَايَّا نّسْ زِيلْپَا إِ يدْجِيسْ لِييَا ذ ثَايَّا. ");
INSERT INTO rifa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ثِيوشَّا نّسْ إِژْرَا يَاعْقُوبْ بلِّي ذ لِييَا. خنِّي إِنَّا إِ لَابَانْ: ”مِينْ ذ أَيِي ثڭِّيذْ؟ مَا وَارْ ذ أَشْ خْذِيمغْ خْ رَاحِيلْ؟ مَاغَارْ ذ أَيِي ثْشمْثذْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لَابَانْ إِنَّا: ”وَارْ إِتِّيڒِي ؤُيَا ذِي ثمُّورْثْ نّغْ أَذْ نسِّيزَّارْ ثَامَاژُوژْثْ خْ ثْمنْزُوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","كمّڒْ سِّيمَانَا-يَا ن وُورَارْ ن ثَا، خنِّي أَذْ أَشْ نوْشْ عَاوذْ ثِينْ خْ ڒْخذْمثْ إِ غَا ثڭّذْ سَّا ثْسَاونْثْ أَكِيذِي عَاذْ سبْعَا ن إِسڭّْوُوسَا نّغْنِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","إِڭَّا يَاعْقُوبْ أَمنِّي، إِكمّڒْ سِّيمَانَا-يَا ن وُورَارْ. خنِّي إِوْشَا أَسْ يدْجِيسْ رَاحِيلْ ذ ثَامْغَارْثْ ");
INSERT INTO rifa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ؤُشَا إِوْشَا لَابَانْ ثَايَّا نّسْ بِيلْهَا إِ يدْجِيسْ رَاحِيلْ مَاحنْذْ أَذْ ثِيڒِي ذ ثَايَّا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","يُوذفْ يَاعْقُوبْ عَاوذْ خْ رَاحِيلْ ؤُشَا إِخْسْ رَاحِيلْ عَاذْ كْثَارْ خْ لِييَا. ؤُشَا إِسخَّارْ أَسْ عَاوذْ سبْعَا ن إِسڭّْوُوسَا نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ؤُمِي إِژْرَا سِيذِي بلِّي لِييَا ثُوغَا ثتّْوَاسّحْقَارْ، يَارْزمْ ڒمْڒَاوثْ نّسْ، مَاشَا رَاحِيلْ ثُوغَا وَارْ د-ثتِّيرُووْ شَا. ");
INSERT INTO rifa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ثكْسِي لِييَا س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ، إِڭَّا أَسْ رُوبِينْ، مِينْزِي ثنَّا: ”أَقَا سِيذِي إِخْزَارْ غَارْ ڒمْحَايمْ إِنُو. ڒخُّو أَذْ أَيِي إِخْسْ ورْيَازْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ثكْسِي عَاوذْ س دّيْسثْ، ثُورُووْ-د أَحنْجِيرْ، ثنَّا: ”ؤُمِي إِسْڒَا سِيذِي بلِّي نشّْ تّْوَاسّحْقَارغْ، إِوْشَا أَيِي عَاوذْ وَا.“ ؤُشَا ثڭَّا أَسْ شِيمْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ثكْسِي عَاوذْ س دّيْسثْ، ثُورُووْ-د أَحنْجِيرْ، ثنَّا: ”ڒخُّو ثْوَاڒَا-يَا أَذْ إِمُونْ ورْيَازْ إِنُو أَكِيذِي، مِينْزِي ؤُرْوغْ أَسْ-د ثْڒَاثَا ن إِحنْجِيرنْ.“ خْ ؤُيَا نتَّا إِڭَّا أَسْ لَاوِي. ");
INSERT INTO rifa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ثكْسِي ثْوَاڒَا نّغْنِي س دّيْسثْ، ثُورُووْ-د أَحنْجِيرْ ؤُشَا ثنَّا: ”ثْوَاڒَا-يَا أَذْ قَاذِيغْ سِيذِي.“ خْ ؤُيَا ثڭَّا أَسْ يَاهُوذَا. أَوَارْنِي مَانْ أَيَا ثسّْبدّْ ثَارْوَا. ");
INSERT INTO rifa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ؤُمِي ثژْرَا رَاحِيلْ بلِّي وَارْ د-ثِيرُووْ إِ يَاعْقُوبْ، ثُوسمْ زڭْ ؤُتْشْمَاسْ، ثنَّا إِ يَاعْقُوبْ: ”أوْشْ أَيِي ثَارْوَا! مَاڒَا وَارْ ثقْبِيڒذْ، خنِّي أَذْ مّْثغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","إِخيّقْ يَاعْقُوبْ خْ رَاحِيلْ، إِنَّا: ”مَا أَقَا أَيِي نشّْ ذڭْ ومْشَانْ ن أَربِّي، ونِّي خَامْ إِطّْفنْ ڒْغِيدْجثْ ن ؤُعذِّيسْ نّمْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ثنَّا: ”أَقَا ذَا ثَايَّا إِنُو بِيلْهَا. أَذفْ خَاسْ، حِيمَا أَذْ د-ثَارُووْ خْ إِفَادّنْ إِنُو مَاحنْذْ ؤُڒَا ذ نشّْ أَذْ غَارِي ثِيڒِي ثَارَّاوْثْ زَّايسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ثوْشَا أَسْ بِيلْهَا، ثَايَّا نّسْ، ذ ثَامْغَارْثْ ؤُشَا يُوذفْ خَاسْ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ثكْسِي بِيلْهَا س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ إِ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ثنَّا رَاحِيلْ: ”إِوْشَا أَيِي أَربِّي ثَاسْغَارْثْ ؤُشَا إِسْڒَا عَاوذْ غَارِي. إِوْشَا أَيِي مِّي.“ خْ ؤُيَا ثڭَّا أَسْ دَان. ");
INSERT INTO rifa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ثكْسِي بِيلْهَا، ثَايَّا ن رَاحِيلْ، ثْوَاڒَا نّغْنِي س دّيْسثْ ؤُشَا ثُورُووْ-د إِ يَاعْقُوبْ أَحنْجِيرْ وِيسّْ ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ثنَّا رَاحِيلْ: ”س إِمنْغَانْ ن أَربِّي منْغغْ أَكْ-ذ ؤُتْشْمَا ؤُشَاغڒْبغْ.“ ثڭَّا أَسْ نَافْثَالِي. ");
INSERT INTO rifa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ؤُمِي ثژْرَا لِييَا ثسّْبدّْ ثَارْوَا، ثكْسِي زِيلْپَا، ثَايَّا نّسْ، ثوْشَا إِ-ت إِ يَاعْقُوبْ ذ ثَامْغَارْثْ، ");
INSERT INTO rifa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ؤُشَا زِيلْپَا، ثَايَّا ن لِييَا، ثُورُووْ-د أَحنْجِيرْ إِ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ثنَّا لِييَا: ”مَانَا ڒْخِيرْ-أَ!“ ؤُشَا ثڭَّا أَسْ جَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ؤُشَا ثُورُووْ-د زِيلْپَا، ثَايَّا ن لِييَا، أَحنْجِيرْ وِيسّْ ثْنَاينْ إِ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ؤُشَا ثنَّا لِييَا: ”أَ سّعْذْ إِنُو!“، مِينْزِي ثِيبْڒِيغِينْ أَذْ أَيِي حسْبنْثْ ذ سّعْذْ!“ ؤُشَا ثڭَّا أَسْ أَشِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ذڭْ وُوسَّانْ ن ثْميْرَا ن إِرْذنْ إِفّغْ رُوبِينْ ؤُشَا يُوفَا ’ثِيثفَّاحِينْ ن ثَايْرِي‘ ذڭْ إِيَّارْ ؤُشَا نتَّا يِيوْيْ إِ-ثنْثْ إِ لِييَا، يمَّاسْ. خنِّي ثنَّا رَاحِيلْ إِ لِييَا: ”تّْزَاوْڭغْ شمْ أَذْ أَيِي ثوْشذْ زِي ’تّفَّاحِينْ ن ثَايْرِي‘ ن مِّيمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","مَاشَا لِييَا ثنَّا أَسْ: ”مَا وَارْ إِدْجِي ذْرُوسْ أَڒَامِي ثِيوْيذْ أَرْيَازْ إِنُو، ؤُمِي ثخْسذْ عَاوذْ أَذْ د-ثَاوْيذْ ’ثِيثفَّاحِينْ ن ثَايْرِي‘ ن مِّي؟“ ثنَّا رَاحِيلْ: ”س ؤُيَا أَذْ إِطّصْ أَكِيذمْ دْجِيڒثْ-أَ خْ ’تّفَّاحِينْ ن ثَايْرِي‘ ن مِّيمْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ؤُمِي د-إِعْقبْ يَاعْقُوبْ زڭْ إِيَّارْ س ثْمذِّيثْ، ثفّغْ-د لِييَا غَارسْ ثنَّا أَسْ: ”أَذْ خَافِي ثَاذْفذْ، مِينْزِي نِيشَانْ شْرِيغْ شكْ س ’تّفَّاحِينْ ن ثَايْرِي‘ ن مِّي.“ ؤُشَا أَمُّو إِ إِطّصْ أَكِيذسْ دْجِيرثْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","إِسْڒَا أَربِّي إِ لِييَا ؤُشَا ثكْسِي س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ وِيسّْ خمْسَا إِ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ثنَّا لِييَا: ”أَربِّي إِوْشَا أَيِي ڒْمُونثْ إِنُو خْ ؤُمِي وْشِيغْ ثَايَّا إِنُو إِ ورْيَازْ إِنُو!“ ؤُشَا ثڭَّا أَسْ إِسَّاكَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ثكْسِي لِييَا عَاوذْ س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ وِيسّْ ستَّا إِ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ؤُشَا ثنَّا لِييَا: ”أَربِّي إِوْشَا أَيِي إِشْثْ ن لْبَارَاكَا ثشْنَا. ڒخُّو أَذْ كِيذِي إِزْذغْ ورْيَازْ إِنُو، مِينْزِي ؤُرْوغْ أَسْ-د ستَّا ن إِحنْجِيرنْ.“ ؤُشَا ثڭَّا أَسْ زابُولُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","أَوَارْنِي أَسْ ثُورُووْ-د ثَاحنْجِيرْثْ. ثڭَّا أَسْ ذِينَا. ");
INSERT INTO rifa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","خنِّي إِذَارْ أَربِّي رَاحِيلْ ؤُشَا إِسْڒَا أَسْ أَربِّي ؤُشَا يَارْزمْ ڒمْڒَاوْڒثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ثكْسِي س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ، ثنَّا: ”إِكّسْ أَربِّي ڒْحڭْرَا إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ؤُشَا ثڭَّا أَسْ يُوسُوفْ، ثنَّا: ”أَذْ أَيِي يَارْنِي سِيذِي أَحنْجِيرْ نّغْنِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ڒَامِي د-ثُورُووْ رَاحِيلْ يُوسُوفْ، إِنَّا يَاعْقُوبْ إِ لَابَانْ: ”سكّْ أَيِي ؤُشَا أَذْ رَاحغْ غَارْ ذْشَارْ إِنُو ذ ثمُّورْثْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","أوْشْ أَيِي ثِيمْغَارِينْ إِنُو ذ إِحنْجِيرنْ إِنُو مِينْ زِي غَاركْ خذْمغْ. خنِّي أَذْ فّْغغْ. أَقَا شكْ ثسّْنذْ ڒْخذْمثْ إِ زِي ثُوغَا ذ أَشْ تّْسخَّارغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","إِنَّا أَسْ لَابَانْ: ”مْڒِي ؤُفِيغْ ڒخُّو أَرْضَا ذِي ثِيطَّاوِينْ نّشْ. أَقَا ژْرِيغْ س إِجّْ ن ڒعْجبْ بلِّي سِيذِي إِبَاركْ أَيِي ذِي طّْوعْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","يَارْنِي إِنَّا: ”إِنِي أَيِي زعْمَا مَانْ ڒْمُونثْ إِ ثخْسذْ، ؤُشَا أَذْ أَشْ ت وْشغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","خنِّي إِنَّا أَسْ: ”شكْ ثسّْنذْ مَامّشْ ذ أَشْ خذْمغْ ذ مَامّشْ ؤُيُورغْ أَكْ-ذ ڒبْهَايمْ نّشْ زڭْ وَامِي كِيشْ دْجِيغْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","مِينْزِي ذْرُوسْثْ إِ ثُوغَا غَاركْ ڒخْذنِّي قْبڒْ إِ د-ؤُسِيغْ، أَقَا إِذْوڒْ ذڭْ وَاطَّاسْ، ؤُشَا إِبَاركْ إِ شكْ سِيذِي ذڭْ إِصُورَافْ إِنُو. خنِّي ڒخُّو، مڒْمِي زمَّارغْ أَذْ خذْمغْ إِ ثَادَّارْثْ إِنُو؟“ ");
INSERT INTO rifa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","إِنَّا أَسْ: ”مِينْ ذ أَشْ إِ غَا وْشغْ؟“ يَارَّا-د يَاعْقُوبْ: ”وَارْ ذ أَيِي تِّيشْ وَالُو، مَاشَا سَامْحْ أَيِي أَيَا وَاهَا، خنِّي أَذْ د-ذوْڒغْ أَذْ أَروْسغْ ؤُدْجِي نّشْ عَاوذْ ؤُشَا أَذْ ثنْ حْضِيغْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","أَسّْ-أَ أَذْ عْذُوغْ خْ مَارَّا ثَاحِيمَارْثْ ن وُودْجِي نّشْ. أڭّْ شكْ خْ ؤُغزْذِيسْ زَّايسْ مَارَّا ؤُدْجِي إِبقّْضنْ ذ إِقَارْقَاشنْ، مَارَّا ؤُدْجِي أَبَارْشَانْ جَارْ إِحُوڒِييّنْ ذ مِينْ إِدْجَانْ ذ أَقَارْقَاشْ نِيغْ س إِبقِّيضنْ جَارْ إِغَايْضنْ. مَانْ أَيَا أَذْ يِيڒِي ذ ڒْمُونثْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","خْمِي د غَا ثَاسذْ ذڭْ إِجّْ ن وَاسّْ ن يِيمَاڒْ مَاحنْسْ أَذْ ثْژَارذْ ڒْمُونثْ إِنُو، أَذْ ثْبَانْ ثْسڭْذَا إِنُو زَّاثْ إِ وُوذمْ نّشْ أَمُّو نِيشَانْ: مِينْ وَارْ إِدْجِينْ إِبقّضْ نِيغْ مِينْ وَارْ إِدْجِينْ إِقَّارْقشْ جَارْ إِغَايْضنْ ذ مِينْ وَارْ إِدْجِينْ ذ أَبَارْشَانْ جَارْ إِحُوڒِييّنْ، أَقَا أَذْ إِتّْوَاحْسبْ إِتّْوَاشَارْ جَارْ مِينْ إِدْجَانْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","خنِّي إِنَّا لَابَانْ: ”خْزَارْ، أَقَا أَذْ يِيڒِي أَمْ مَامّشْ إِ ذ أَيِي ثنِّيذْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ذڭْ وَاسّْ نِّي إِفَارْقْ إِوثْمَانْ ن إِغَايْضنْ إِشَارْضنْ ذ إِقَارْقَاشنْ ؤُڒَا ذ مَارَّا ثِيغَايْضْثِينْ إِبقّْضنْ ذ إِقَارْقَاشنْ، ذ مَارَّا إِنِّي ذِي ثدْجَا ثمْڒڒْ، ؤُڒَا ذ مَارَّا مِينْ إِدْجَانْ ذ أَبَارْشَانْ جَارْ إِحُوڒِييّنْ، ؤُشَا إِسَّارْسْ إِ-ثنْ ذڭْ ؤُفُوسْ ن إِحنْجِيرنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","خنِّي إِڭَّا ثْڒَاثَا ن وُوسَّانْ ن وبْرِيذْ جَارْ إِخفْ نّسْ ذ يَاعْقُوبْ. ؤُشَا يَارْوسْ يَاعْقُوبْ ؤُدْجِي إِقِّيمنْ ن لَابَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","خنِّي إِكْسِي يَاعْقُوبْ ثِيسضْوِينْ ن صّفْصَافْ ؤُ زِي ثْشجَّارْثْ ن دْجُوزْ ؤُ زِي ثْشجَّارْثْ ن ذُولْبْ. نتَّا إِقشَّارْ إِ-ثنْثْ ذ إِشطِّيضنْ ذ إِشمْڒَاڒنْ ؤُمِي إِعَارَّا خْ ؤُشمْڒَاڒْ ن ثْسضْوِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","إِسَّارْسْ ثِيسضْوِينْ-أَ إِقشَّارنْ قِيبَاتْشْ إِ وُودْجِي ذِي ثَارْيِيوِينْ ذ ڒقْوَاربْ مَانِي د-ؤُسِينْ وُودْجِي مَاحنْذْ أَذْ سْونْثْ ؤُشَا ذوْڒنْثْ تّْوحَّامنْثْ خْمِي د-ثَاسنْثْ أَذْ وَارْذنْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","خْمِي إِ غَا إِوحّمْ وُودْجِي غَارْ ثْسضْوِينْ، ؤُرْونْثْ-إِ-د ثْغَارْطِينْ مِينْ إِشَارْضنْ ذ مِينْ إِبقّْضنْ ذ مِينْ إِقَارْقَاشنْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","خنِّي ثُوغَا إِبطَّا يَاعْقُوبْ إِحُوڒِييّنْ ؤُشَا يَارَّا ؤُدْجِي س ؤُزدْجِيفْ نْسنْ غَارْ مِينْ إِشَارْضنْ ذ مِينْ إِدْجَانْ ذ أَبَارْشَانْ جَارْ وُودْجِي ن لَابَانْ. ؤُشَا إِڭَّا ثِيحِيمْرِيوِينْ نّسْ غَارْ ؤُغزْذِيسْ، وَارْ ثنْثْ إِڭِّي أَكْ-ذ وُودْجِي ن لَابَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","كُوڒْ أَمُوڒْ خْمِي تّْوحَّامنْثْ ثِينِّي إِجهْذنْ زڭْ وُودْجِي، إِتّڭّْ يَاعْقُوبْ ثِيسضْوِينْ قِيبَاتْشْ إِ وُودْجِي ذِي ثَارْيِيوِينْ، حِيمَا أَذْ وحّْمنْثْ غَارْ ثْسضْوِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","مَاشَا وَارْ ثنْثْ إِسَّارْسْ شَا أَكْ-ذ ثنِّي إِضعْفنْ جَارْ وُودْجِي. أَمُّو ثُوغَا ثِينِّي إِضعْفنْ إِ لَابَانْ ؤُ ثِينِّي إِجهْذنْ إِ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ؤُشَا إِمْغَارْ وَاڭْڒَا ن ورْيَازْ-أَ بْڒَا قطُّو. ثُوغَا غَارسْ أَطَّاسْ ن وُودْجِي ذ ثِييَّا ذ إِسمْغَانْ ذ إِڒغْمَانْ ذ يغْيَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ؤُشَا إِسْڒَا يَاعْقُوبْ أَوَاڒنْ ن إِحنْجِيرنْ ن لَابَانْ، نَّانْ: ”يَاعْقُوبْ إِكْسِي مَارَّا مِينْ ثُوغَا ن بَابَاثْنغْ ؤُ س مِينْ ثُوغَا ن بَابَاثْنغْ أَقَا إِكْسبْ مَارَّا أَعُودْجِي-يَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","إِخْزَارْ يَاعْقُوبْ غَارْ ؤُغمْبُوبْ ن لَابَانْ. خْزَارْ، وَارْ كِيذسْ إِدْجِي أَمْ إِضنَّاضْ ذ فَارِيضنَّاضْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","إِنَّا سِيذِي إِ يَاعْقُوبْ: ”ذْوڒْ غَارْ ثمُّورْثْ ن ڒجْذُوذْ نّشْ ؤُ غَارْ ڒَادْجْ نّشْ. أَقَا نشّْ أَذْ إِڒِيغْ أَكِيذكْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","إِسكّْ يَاعْقُوبْ ؤُشَا إِڒَاغَا-د خْ رَاحِيلْ ذ لِييَا غَارْ ييَّارْ، غَارْ وُودْجِي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","إِنَّا أَسنْثْ: ”تّْوَاڒِيغْ بلِّي أَغمْبُوبْ ن بَابَاثْكنْثْ وَارْ كِيذِي إِدْجِي أَمْ إِضنَّاضْ ذ فَارِيضنَّاضْ. مَاشَا أَربِّي ن ڒجْذُوذْ إِنُو أَقَا-ث أَكِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","كنِّينْثْ ثسّْننْثْ بلِّي أَقَا خذْمغْ إِ بَابَاثْكنْثْ س مَارَّا مِينْ غَارِي ذ جّهْذْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","مَاشَا بَابَاثْكنْثْ إِغشّْ أَيِي، إِبدّڒْ ڒْمُونثْ إِنُوعشْرَا ن ثْوَاڒَاوِينْ، مَاشَا أَربِّي وَارْ ذ أَسْ إِسمّحْ حِيمَا أَذْ أَيِي إِڭّْ ڒْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","مَاڒَا نتَّا إِنَّا: ’إِبقِّيضنْ أَذْ إِڒِينْ ذ ڒْمُونثْ نّشْ!‘، ڒخْذنِّي مَارَّا ؤُدْجِي ؤُرْونْثْ-إِ-د ؤُدْجِي س إِبقِّيضنْ، مَاڒَا إِنَّا: ’إِنِّي س إِشَارِيضنْ أَذْ إِڒِينْ ذ ڒْمُونثْ نّشْ!‘، ڒخْذنِّي مَارَّا ؤُدْجِي ؤُرْونْثْ-إِ-د ؤُدْجِي س إِشَارِيضنْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","أَمُّو إِكّسْ أَربِّي ڒبْهَايمْ ن بَابَاثْكنْثْ ؤُشَا إِوْشَا أَيِي ثنْثْ إِ نشّْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","إِمْسَارْ غَارْ ڒْوقْثْ ؤُمِي وحّْمنْثْ ؤُدْجِي، سّْڭعّْذغْ ثَامُوغْڒِي إِنُو ؤُشَا ژْرِيغْ ذِي ثَارْجِيثْ، أَقَا ذَا إِغَايْضنْ نِّي إِنڭّْزنْ خْ وُودْجِي، ثُوغَا أَثنْ س إِشَارِيضنْ ذ إِبقِّيضنْ ذ إِقَارْقَاشنْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","إِنَّا أَيِي لْمَالَاكْ ن أَربِّي ذِي ثَارْجِيثْ ’يَاعْقُوبْ!‘ نشّْ نِّيغْ ’أَقَا أَيِي ذَا!‘ ");
INSERT INTO rifa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","إِنَّا: ’نْضَارْ ثِيطَّاوِينْ نّشْ، خْزَارْ، مَارَّا إِغَايْضنْ، إِنِّي إِنڭّْزنْ خْ وُودْجِي، أَقَا أَثنْ س إِشَارِيضنْ ذ إِبقِّيضنْ ذ إِقَارْقَاشنْ، مِينْزِي نشّْ ژْرِيغْ مَارَّا مِينْ ذ أَشْ إِتّڭّْ لَابَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","نشّْ ذ أَربِّي ن بَايْثْ-إِلْ، مَانِي ثْذهْنذْ أَژْرُو ن ڒِيذَارثْ ؤُ مَانِي ذ أَيِي ثوْشِيذْ أَوَاڒْ. كَّارْ ڒخُّو، فّغْ زِي ثمُّورْثْ-أَ، عْقبْ غَارْ ثمُّورْثْ مَانِي ثْخڒْقذْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","خنِّي أَرِّينْثْ-إِ-د رَاحِيلْ ذ لِييَا، نَّانْثْ أَسْ: ”مَا ذِينْ عَاذْ شَا ن ثسْغَارْثْ نِيغْ إِشْثْ ن ڒْوَارْثْ إِ نشِّينْ ذِي ثَادَّارْثْ ن بَابَاثْنغْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","مَا وَارْ نتّْوِيحْسِيبْ أَمْ ثْبَارَّانِييِّينْ؟ أَقَا نتَّا إِزّنْزْ أَنغْ ؤُ نتَّا أَقَا إِقطَّا مَارَّا نُّوقَارْثْ نّغْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","مِينْزِي مَارَّا أَڭْڒَا نِّي إِكّسْ أَربِّي إِ بَابَاثْنغْ، نّغْ إِ إِدْجَا ؤُ ن إِحنْجِيرنْ نّغْ. ڒخُّو عَاذْ، أڭّْ مَارَّا مِينْ ذ أَشْ إِنَّا أَربِّي.“ ");
INSERT INTO rifa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","خنِّي إِكَّارْ يَاعْقُوبْ ؤُشَا إِسّْڭعّذْ إِحنْجِيرنْ نّسْ ذ ثمْغَارِينْ نّسْ خْ إِڒغْمَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","إِڭَّا ذڭْ وبْرِيذْ مَارَّا ڒبْهَايمْ نّسْ ذ مَارَّا أَڭْڒَا نّسْ نِّي د-إِكْسبْ، أَقَا ڒبْهَايمْ نِّي إِطّفْ، إِنِّي د-إِكْسبْ ذِي فَاذَانْ-أَرَامْ، حِيمَا أَذْ د-إِعْقبْ غَارْ إِسْحَاقْ، بَابَاسْ، ذِي ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ؤُمِي إِرُوحْ لَابَانْ غَارْ ثِيڒْسَا ن وُودْجِي نّسْ، ثُوشَارْ رَاحِيلْ ڒخْيَاڒَاثْ ثِيمژْيَانِينْ ن لْ-أَصْنَامْ ن بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","يَاعْقُوبْ إِخْذعْ لَابَانْ، أَرَامِييُو، ڒَامِي وَارْ ذ أَسْ إِعْڒِيمْ أَقَا أَذْ يَارْوڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","يَارْوڒْ س مَارَّا مِينْ غَارسْ. إِكَّارْ، إِژْوَا إِغْزَارْ ن لْفُورَاطْ ؤُشَا يَارَّا أَزدْجِيفْ نّسْ غَارْ إِذُورَارْ ن جِيلْعَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا خبَّارنْ لَابَانْ، أَقَا يَارْوڒْ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","خنِّي يِيوِي أَيْثْمَاسْ أَكِيذسْ، إِرُوحْ أَوَارْنِي أَسْ ثِيشْڒِي ن سبْعَا ن وُوسَّانْ، إِخشّْ خَاسْ ذڭْ إِذُورَارْ ن جِيلْعَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ؤُشَا يُوسَا-د أَربِّي غَارْ لَابَانْ، أَرَامِييُو، ذِي ثَارْجِيثْ ذِي دْجِيرثْ، إِنَّا أَسْ: ”غَاركْ أَذْ ثسِّيوْڒذْ س ڒْخَارْ نِيغْ س ڒْغَارْ أَكْ-ذ يَاعْقُوبْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","إِرحّڭْ خنِّي لَابَانْ خْ يَاعْقُوبْ. يَاعْقُوبْ ثُوغَا إِوْثَا أَقِيضُونْ نّسْ ذڭْ إِذُورَارْ. لَابَانْ عَاوذْ إِوْثَا إِقِيضَانْ نّسْ أَكْ-ذ أَيْثْمَاسْ ذڭْ إِذُورَارْ ن جِيلْعَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","خنِّي إِنَّا لَابَانْ إِ يَاعْقُوبْ: ”مِينْ ثڭِّيذْ، ثژْوِيذْ أَيِي ؤُڒْ ؤُشَا ثِيوْيِيذْ-د يسِّي أَمْ ثْمحْبَاسْ ن ڭَارَّا؟ ");
INSERT INTO rifa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","مَايمِّي ثَاروْڒذْ س ثْنُوفّْرَا ؤُ ثُوشَارذْ أَيِي ؤُ مَايمِّي وَارْ ذ أَيِي ثْخبَّارذْ، حِيمَا أَذْ شكْ سّْقبّْضغْ س ڒفْرَاحثْ، س ڒغْنُوجْ، س ؤُبنْذِيرْ ؤُ س ڒْڭَامْبْرِي؟ ");
INSERT INTO rifa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","وَارْ ذ أَيِي ثجِّيذْ أَذْ سُّوذْمغْ إِحنْجِيرنْ إِنُو ذ ثْحنْجِيرِينْ إِنُو. ڒخُّو ذ ثُوبُّوهڒْيَا إِ ثڭِّيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","غَارِي ثِيزمَّارْ ذڭْ إِفَاسّنْ إِنُو، حِيمَا أَذْ شكْ ضَارّغْ، مَاشَا أَربِّي ن بَابَاثْومْ إِسِّيوڒْ أَكِيذِي دْجِيرثْ-أَ، إِنَّا: ’غَاركْ أَذْ ثسِّيوْڒذْ س ڒْخَارْ نِيغْ س ڒْغَارْ أَكْ-ذ يَاعْقُوبْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ؤُشَا ڒخُّو ثُويُورذْ، ؤُمِي زعْمَا ثْوحّْشذْ ثَادَّارْثْ ن بَابَاشْ. مَاشَا مَاغَارْ إِ ذ أَيِي ثُوشَارذْ إِربِّيثنْ إِنُو؟“ ");
INSERT INTO rifa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","يَارَّا-د يَاعْقُوبْ، إِنَّا إِ لَابَانْ: ”مِينْزِي ثُوغَا ڭّْوذغْ، نِّيغْ أَكْ-ذ يِيخفْ إِنُو أَذْ ثَاغْ أَذْ أَيِي ثكّْسذْ يسِّيشْ س ؤُغِيڒْ! ");
INSERT INTO rifa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","غَارْ ونِّي إِ غَا ثَافذْ لْ-أَصْنَامْ نّشْ، أجّْ إِ-ث وَارْ إِدَّارْ عَاذْ! قِيبَاتْشْ إِ وَاوْمَاثنْ نّغْ أَذْ ثْميّْزذْ مِينْ إِدْجَانْ نّشْ جَارْ مِينْ إِدْجَانْ غَارِي ؤُشَا أَوْيِي ث أَكِيذكْ.“ مَاغَارْ يَاعْقُوبْ وَارْ إِسِّينْ بلِّي رَاحِيلْ إِ ثنْ يُوشَارنْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ؤُشَا يُوذفْ لَابَانْ غَارْ ؤُقِيضُونْ ن يَاعْقُوبْ، غَارْ ؤُقِيضُونْ ن لِييَا، غَارْ ؤُقِيضُونْ ن ثْنَاينْ ن ثِييَّا ؤُشَا وَارْ يُوفِي وَالُو. ڒَْامِي د-إِفّغْ زڭْ ؤُقِيضُونْ ن لِييَا، يُوذفْ غَارْ ؤُقِيضُونْ ن رَاحِيلْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","مَاشَا ثكْسِي رَاحِيلْ ڒخْيَاڒَاثْ ثِيمژْيَانِينْ ن لْ-أَصْنَامْ، ثڭَّا إِ-ثنْثْ ذڭْ إِغَايْننْ ن وڒْغمْ ؤُشَا ثقِّيمْ خَاسنْ. يَارْزُو لَابَانْ ذڭْ ؤُقِيضُونْ أَمْ إِكْمڒْ، مَاشَا وَارْ يُوفِي وَالُو. ");
INSERT INTO rifa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ثنَّا إِ بَابَاسْ: ”وَارْ إِتِّيڒِي أَيَا ذ ڒْغَارْ ذِي ثِيطَّاوِينْ ن سِيذِي إِنُو، مِينْزِي وَارْ زمَّارغْ أَذْ كَّارغْ قِيبَاتْشْ نّشْ، مَاغَارْ أَقَا أَيِي س ثْنَامِيثْ ن ثمْغَارِينْ.“ ؤُشَا يَارْزُو، مَاشَا وَارْ يُوفِي ڒخْيَاڒَاثْ ثِيمژْيَانِينْ ن لْ-أَصْنَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","خنِّي إِخيّقْ يَاعْقُوبْ ؤُشَا إِمْشُوبّشْ أَكْ-ذ لَابَانْ. يَاعْقُوبْ إِطّفْ ذڭْ وَاوَاڒْ، إِنَّا إِ لَابَانْ: ”مَانِي إِدْجَا ؤُخطُّو إِنُو؟ مَانْ ونْ إِدْجَانْ ذ دّنْبْ إِنُو، ؤُمِي ذ أَيِي د-ثضْفَارذْ س زّْعَافْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","شكْ ثْبقْشذْ مَارَّا ڒْقشّْ إِنُو. مِينْ ثُوفِيذْ زِي مَارَّا ڒحْوَايجْ ن ثَادَّارْثْ نّشْ؟ أڭّْ إِ-ث ذَا زَّاثْ ن يَايْثْمَا ذ أَيْثْمَاشْ ؤُشَا أجّْ إِ-ثنْ أَذْ حكْمنْ جَارْ أَنغْ س ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","عِيشْرِينْ ن إِسڭّْوُوسَا إِ كِيكْ كِّيغْ. ثِيخسْوِينْ نّشْ ذ ثْغَايْضِينْ نّشْعمَّارْصْ سُّوثْمنْثْ نِيغْعمَّارْصْ شِّيغْ إِشَارِّيينْ ن وُودْجِي نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","وَارْ ذ أَشْ إِوْيغْ مِينْ إِتّْوَامزّْقنْ، مَاشَا خطْصغْ ث سِيمَانْثْ إِنُو. مِينْ إِتّْوَاشَارنْ زَّايِي ذڭْ وَاسّْ نِيغْ ذِي دْجِيرثْ، أَقَا زڭْ إِفَاسّنْ إِنُو ثتَّارذْ ث. ");
INSERT INTO rifa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","س ؤُزِيڒْ إِتّتّْ أَيِي ڒحْمُو يُوژْغنْ ثِيڒْمشْثْ ؤُ س دْجِيرثْ تّجْمِيذغْ زِي سْقِيعْ، أَڒَامِي يَارْوڒْ إِضصْ زِي غَارِي. ");
INSERT INTO rifa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","أَمُّو إِ ذ أَيِي ثُوغَا ذِي ثَادَّارْثْ نّشْ عِيشْرِينْ ن إِسڭّْوُوسَا. خذْمغْ غَاركْ أَرْبعْطَاشْ ن إِسڭّْوُوسَا خْ ثْنَاينْ ن يسِّيشْ ذ ستَّا ن إِسڭّْوُوسَا خْ وُودْجِي ؤُشَا ثْبدّْڒذْ ڒْمُونثْ إِنُوعشْرَا ن ثْوَاڒَاوِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","مَاڒَا أَربِّي ن بَابَا، أَربِّي ن إِبْرَاهِيمْ ذ ثِيڭّْوُوذِي ن إِسْحَاقْ، إِڒِي وَارْ كِيذِي إِدْجِي، ذ صّحْ إِڒِي أَذْ أَيِي ثسّْقَاذذْ ڒخُّو س إِفَاسّنْ خْوَانْ! إِژْرَا أَربِّي ثَامَارَا ذ ثُومَارْ ن إِفَاسّنْ إِنُو ؤُشَا إِذقْمَارْ إِ شكْ دْجِيڒثْ ن إِضنَّاضْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","يَارَّا-د لَابَانْ ؤُشَا إِنَّا إِ يَاعْقُوبْ: ”ثِيحنْجِيرِينْ-أَ ذ يسِّي ؤُ إِحنْجِيرنْ-أَ ذ إِحنْجِيرنْ إِنُو، ؤُ ؤُدْجِي-يَا ذ ؤُدْجِي إِنُو، ؤُ مَارَّا مِينْ ثتّْوَاڒِيذْ أَقَا إِنُو. مِينْ زمَّارغْ خنِّي أَذْ ڭّغْ ڒخُّو س يسِّي نِيغْ س إِحنْجِيرنْ نْسنْثْ نِّي ؤُرْونْثْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","غَاورْ عَاذْ ڒخُّو، أَذْ نڭّْ إِجّْ ن ڒْعَاهْذْ، نشّْ ذ شكْ، أَذْ يِيڒِي نتَّا ذ شّْهَاذثْ جَارْ أَيِي ذ شكْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ؤُشَا إِكْسِي يَاعْقُوبْ أَژْرُو، إِسّْڭعّذْ إِ-ث أَمْ وژْرُو ن ڒِيذَارثْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ؤُشَا إِنَّا يَاعْقُوبْ إِ يَايْثْمَاسْ: ”سْمُونمْ إِژْرَا!“ كْسِينْ إِژْرَا ؤُشَا ڭِّينْ ثَاعُورِّيشْثْ ؤُشَا شِّينْ ذِينْ خْ ثْعُورِّيشْثْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ؤُشَا إِڭَّا لَابَانْ إِ ؤُعُورِّيشْ ن إِژْرَا نِّي ’جِيڭَارْ-سَاهَاذُوثَا‘، مَاشَا يَاعْقُوبْ إِڭَّا أَسْ ’جِيلْعَاذْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","خنِّي إِنَّا لَابَانْ: ”ثَاعُورِّيشْثْ-أَ أَذْ ثِيڒِي ذ شّْهَاذثْ أَسّْ-أَ جَارْ أَيِي ذ شكْ!“ خْ ؤُيَا ثڭَّا أَسْ جِيلْعَاذْ ");
INSERT INTO rifa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ذ مِيصْفَا، مِينْزِي نتَّا إِنَّا: ”إِڒِي سِيذِي أَذْ إِحْضَا جَارْ أَيِي ذ شكْ، خْمِي غَا نِيڒِي أَمْ ننُوفَّارْ إِجّنْ زڭْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","مَاڒَا ثسّحْقَارذْ يسِّي نِيغْ أَذْ ثْمڒْشذْ ثِيمْغَارِينْ نّغْنِي خْ يسِّي، أَمْ وَارْ ذِينْ إِدْجِي حذْ أَكِيذْنغْ حِيمَا أَذْ يِيڒِي ذ أَشهَّاذْ، أَقَا أَربِّي أَذْ يِيڒِي ذ أَشهَّاذْ جَارْ أَيِي ذ شكْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","إِنَّا عَاوذْ لَابَانْ إِ يَاعْقُوبْ: ”خْزَارْ، ثَاعُورِّيشْثْ-أَ ن يژْرَا، خْزَارْ، أَژْرُو ن ڒِيذَارثْ نِّي سّْبدّغْ جَارْ أَيِي ذ شكْ. ");
INSERT INTO rifa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ثَاعُورِّيشْثْ-أَ ن يژْرَا ذ وژْرُو-يَا ن ڒِيذَارثْ أَذْ شهْذنْ بلِّي نشّْ وَارْ غَاركْ د-ژكّْوِيغْ شَا خْ ثْعُورِّيشْثْ-أَ ؤُشَا ؤُڒَا ذ شكْ وَارْ غَارِي د-ثْژكّْوِّيذْ شَا إِ ڒْغَارْ خْ ثْعُورِّيشْثْ-أَ ؤُڒَا خْ وژْرُو-يَا ن ڒِيذَارثْ! ");
INSERT INTO rifa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","أَربِّي ن إِبْرَاهِيمْ ذ أَربِّي ن نَاحُورْ، أَقَا أَربِّي ن بَابَاثْسنْ، أجّْ إِ-ث أَذْ إِحْكمْ جَارْ أَنغْ!“ مَاشَا يَاعْقُوبْ إِجُّودْجْ س ’ثِيڭّْوُوذِي ن إِسْحَاقْ بَابَاسْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","خنِّي إِغَارْصْ يَاعْقُوبْ إِ يِيشْثْ ن ثْغَارْصْثْ ذڭْ إِذُورَارْ ؤُشَا إِڒَاغَا إِ يَايْثْمَاسْ أَذْ شّنْ أَغْرُومْ. ؤُشَا شِّينْ أَغْرُومْ، سنْسّنْ دْجِيرثْ نِّي ذڭْ إِذُورَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","إِكَّارْ لَابَانْ غَارْ ثُوفُّوثْ ن صّْبحْ، إِسُّوذمْ إِحنْجِيرنْ نّسْ ذ يسِّيسْ، إِبَارْكْ إِ-ثنْ. خنِّي إِرُوحْ لَابَانْ، إِعْقبْ غَارْ ومْشَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ؤُشَا إِطّفْ يَاعْقُوبْ عَاوذْ أَبْرِيذْ نّسْ ؤُشَا ؤُسِينْثْ-إِ-د لْمَالَاكَاثْ ن أَربِّي، ڒْقَانْثْ ث-إِ-د. ");
INSERT INTO rifa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","إِنَّا يَاعْقُوبْ ؤُمِي ثنْ إِژْرَا: ”ڒْمَارْڭحْ ن ڒْعسْكَارْ ن أَربِّي ذ وَا!“، ؤُشَا إِڒَاغَا إِسمْ ن ومْشَانْ نِّي مَاحَانَايِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","إِسّكّْ يَاعْقُوبْ إِرقَّاسنْ غَارْ زَّاثْ، غَارْ عِيسُو ؤُمَاسْ غَارْ ثمُّورْثْ ن سَاعِيرْ، أَقَا-ت ذ جِّيهثْ ن إِذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ؤُشَا إِوصَّا إِ-ثنْ، إِنَّا أَسنْ: ”أَمُّو إِ غَا ثِينِيمْ إِ سِيذِي إِنُو عِيسُو: ’أَمُّو إِ إِقَّارْ ؤُمْسخَّارْ نّشْ يَاعْقُوبْ: ثُوغَا زدّْغغْ أَكْ-ذ لَابَانْ أَمْ ؤُبَارَّانِي ؤُشَا قِّيمغْ ذِينْ أَڒْ إِ ڒخُّو. ");
INSERT INTO rifa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","غَارِي إِفُونَاسنْ ذ يغْيَاڒْ ذ وُودْجِي ذ إِسمْغَانْ ذ ثِييَّا ؤُشَا سّكّغْ إِرقَّاسنْ، مَاحنْذْ أَذْ ث إِنِيغْ إِ سِيذِي إِنُو، مَاحنْذْ أَذْ أَفغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","إِرقَّاسنْ ذوْڒنْ-د غَارْ يَاعْقُوبْ، نَّانْ: ”نْرُوحْ غَارْ ؤُمَاشْ عِيسُو، ؤُ نتَّا عَاوذْ يُوسَا-د أَذْ شكْ إِڒْقَا ؤُ أَقَا ذِينْ أَربْعَا-مْيَا ن يرْيَازنْ أَكِيذسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","خنِّي يَاعْقُوبْ ثُوذفْ إِ-ث ثِيڭّْوُوذِي ثمْغَارْ ؤُشَا إِسّْقنْضْ إِ-ث ڒْحَاڒْ. نتَّا إِبْضَا إِوْذَانْ، إِنِّي أَكِيذسْ ذ وُودْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ إِڒغْمَانْ خْ ثْنَاينْ ن ڒمْرَاڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","إِنَّا: ”مَاڒَا يُوسَا-د عِيسُو غَارْ إِجّْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ، أَذْ خَاسْ إِغْڒبْ، خنِّي أَذْ يَارْوڒْ ڒْمَارْڭحْ ن ڒْعسْكَارْ إِ إِقِّيمنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ؤُشَا إِنَّا يَاعْقُوبْ: ”أَ أَربِّي ن بَابَا إِبْرَاهِيمْ ذ أَربِّي ن بَابَا إِسْحَاقْ، أَ سِيذِي، شكْ ونِّي ذ أَيِي إِنَّانْ: ’ذْوڒْ غَارْ ثمُّورْثْ نّشْ ذ رَادْجْ نّشْ ؤُشَا نشّْ أَذْ أَشْ ڭّغْ مِينْ إِشْنَانْ!‘ ");
INSERT INTO rifa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","أَقَا أَيِي قلّْ خْ مَارَّا ثِيمڭَّا ن ثْمخْسِيوْثْ إِشوَّارنْ ذ مَارَّا ڒَامَانْ إِ ثسّشْنذْ إِ ؤُمْسخَّارْ نّشْ، مِينْزِي ژْوِيغْ لْ-ؤُرْذُونْ س ثغَّارْشْثْ إِنُو ڒَامِي د-فّْغغْ ؤُشَا ڒخُّو ذوْڒغْ-د ذ ثْنَاينْ ن ڒمْرَاڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","فكّْ أَيِي ڒخُّو زڭْ ؤُفُوسْ ن عِيسُو ؤُمَا، مِينْزِي تّڭّْوذغْ بَالَاكْ أَذْ د-يَاسْ ؤُشَا أَذْ إِنغْ ؤُڒَا ذ ثِييمَّاثِينْ أَكْ-ذ إِحنْجِيرنْ! ");
INSERT INTO rifa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ؤُشَا شكْ ثنِّيذْ: ’نشّْ أَذْ كِيكْ ڭّغْ مْلِيحْ، أَذْ ڭّغْ زَّارِيعثْ نّشْ أَمْ يِيجْذِي ن ڒبْحَارْ إِ وَارْ إِزمَّارْ أَذْ إِتّْوَاحْسبْ زِي سِّيبّثْ ن ؤُبَارُّو نّسْ!‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","إِسّنْسْ ذِينْ دْجِيڒثْ نِّي ؤُشَا إِكْسِي زِي مِينْ د-يُوسِينْ ذڭْ إِفَاسّنْ نّسْ ذ أَڭْڒَا، مَاحنْذْ أَذْ ث يوْشْ ذ أَرِّيغَالُو إِ ؤُمَاسْ عِيسُو: ");
INSERT INTO rifa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","مِيثَاينْ ن ثْغَايْضِينْ ذ عِيشْرِينْ ن إِمُويَانْ ذ مِيثَاينْ ن ثْخسْوِينْ ذ عِيشْرِينْ ن إِشَارِّييّنْ ");
INSERT INTO rifa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ذ ثْڒَاثِينْ ن ثْڒغْمِينْ إِسُّوطُّوضنْ أَكْ-ذ ثَارْوَا نْسنْثْ، أَربْعِينْ ن ثْفُونَاسِينْ ثِيمژْيَانِينْ،عشْرَا ن إِفُونَاسنْ إِمژْيَاننْ ذ عِيشْرِينْ ن ثغْيَاڒْ ذعشْرَا ن يغْيَاڒْ إِمژْيَانِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","إِسّعْذُو ثنْ غَارْ إِفَاسّنْ ن إِمْسخَّارنْ نّسْ، كُوڒْ ثَاحِيمَارْثْ وحّْذسْ، ؤُشَا إِنَّا إِ إِمْسخَّارنْ نّسْ: ”عْذُومْ كنِّيوْ ڒخُّو زَّاثْ إِنُو، ڭّمْ تَّاسِيعْ جَارْ ثْحِيمَارْثْ ذ ثْحِيمَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","خنِّي يُومُورْ ؤُمزْوَارْ، إِنَّا أَسْ: ”مَاڒَا يُوسَا-د عِيسُو إِ ؤُمْسَاڭَارْ أَكِيذكْ ؤُشَا إِسّقْسَا أَشْ، إِنَّا: ’وِي شكْ يِيڒَانْ ذ مَانِي غَا ثْرَاحذْ؟‘ ؤُ ’ؤُمِي ثِينَا إِ إِدْجَانْ زَّاثكْ؟‘، ");
INSERT INTO rifa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ڒخْذنِّي أَذْ ثِينِيذْ: ’ذ أَرِّيغَالُو إِ يدْجَا ن ؤُمْسخَّارْ نّشْ يَاعْقُوبْ، ونِّي د-إِسّكّْ إِ سِيذِي إِنُو عِيسُو. خْزَارْ، نتَّا عَاوذْ يُوسَا-د أَوَارْنِي أَنغْ!‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","يُومُورْ عَاوذْ ونِّي وِيسّْ ثْنَاينْ ذ وِيسّْ ثْڒَاثَا إِنِّي إِڭُّورنْ أَوَارْنِي إِ ثْحِيمْرِيوِينْ، إِنَّا: ”سِيوْڒمْ أَوَاڒنْ-أَ ذ إِجّنْ أَكْ-ذ عِيسُو، خْمِي ث غَا ثڒْقَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","كنِّيوْ عَاوذْ أَذْ ثِينِيمْ: ’خْزَارْ، أَمْسخَّارْ نّشْ يَاعْقُوبْ يُوسَا-د أَوَارْنِي أَنغْ!‘ “ مِينْزِي إِنَّا: ”أَذْ ث سَّاريّْحغْ س أَرِّيغَالُو-يَا إِ د-يُوسِينْ زَّاثْ إِنُو. خنِّي أَوَارْنِي مَانْ أَيَا أَذْ ژَترغْ أَغمْبُوبْ نّسْ، بَالَاكْ أَذْ إِقْبڒْ أَغمْبُوبْ إِنُو زَّاثسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","أَمُّو إِ إِسِّيزَّارْ أَرِّيغَالُو زَّاثسْ غَارْ ؤُجمَّاضْ أَمْ إِسّنْسْ نتَّا دْجِيرثْ نِّي ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","إِكَّارْ دْجِيڒثْ نِّي ؤُشَا إِكْسِي ثْنَاينْ ن ثمْغَارِينْ نّسْ ذ ثْنَاينْ ن ثِييَّا نّسْ ذ حِيطَاشْ ن إِحنْجِيرنْ نّسْ، إِژْوَا أَمْشَانْ ن ؤُژكّْوُو ن يغْزَارْ ن يَابُّوقْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","يِيوْيِي إِ-ثنْ ؤُشَا إِسّژْوَا ثنْ إِ ثغْزُورْثْ ؤُ مَارَّا مِينْ غَارسْ إِسّعْذُو ث غَارْ ؤُجمَّاضْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","مَاشَا إِقِّيمْ يَاعْقُوبْ وحّْذسْ ؤُ نتَّا إِمُّوغْزڒْ أَكْ-ذ إِجّْ ن ورْيَازْ أَڒْمِي ذ ثُوفُّوثْ ن ڒفْجَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ؤُمِي إِژْرَا وَانِيثَا أَقَا وَارْ خَاسْ إِقدّْ شَا، إِحَاذَا ث غَارْ ومْشَانْ ن ثمْقِيقّشْثْ ن ثْمصَّاضْثْ نّسْ، مَاحنْذْ أَذْ د-ثنْخُوخرْ ثَامْقِيقّشْثْ ن ثْمصَّاضْثْ ن يَاعْقُوبْ ؤُمِي كِيذسْ ثُوغَا إِتّْمُوغْزُوڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","إِنَّا: ”أجّْ أَيِي أَذْ رَاحغْ، أَقَا إِصْبحْ ڒْحَاڒْ.“ مَاشَا نتَّا إِنَّا: ”وَارْ شكْ تّجِّيغْ، مْغِيرْ مَاڒَا ثْبَارْكذْ أَيِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ؤُشَا نتَّا إِنَّا أَسْ: ”مَامّشْ ذ أَشْ قَّارنْ؟“ يَارَّا-د خَاسْ: ”يَاعْقُوبْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","خنِّي إِنَّا أَسْ: ”وَارْ ذ أَشْ قَّارنْ عَاذْ يَاعْقُوبْ، مَاشَا إِسْرَائِيل، مِينْزِي ثمّنْغذْ أَكْ-ذ أَربِّي ذ إِوْذَانْ، ؤُشَا شكْ ثْغڒْبذْ.“    ");
INSERT INTO rifa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","إِسّقْسَا يَاعْقُوبْ خنِّي، إِنَّا: ”إِنِي أَيِي ڒخُّو إِسمْ نّشْ!“ يَارَّا-د خَاسْ: ”مَاغَارْ ثسّقْسِيذْ خْ يِيسمْ إِنُو؟“ ؤُشَا إِبَارْكْ إِ-ث ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ؤُشَا إِسمَّا يَاعْقُوبْ أَمْشَانْ نِّي فَانُووِيلْ، إِنَّا: ”مِينْزِي ژْرِيغْ أَربِّي أَغمْبُوبْ ذڭْ ؤُغمْبُوبْ ؤُشَا إِنْجمْ ڒعْمَارْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ثنْقَارْ-د خَاسْ ثْفُوشْثْ ؤُمِي ثُوغَا إِعْذُو خْ فَانُووِيلْ، ؤُشَا يُويُورْ إِتّْزحّفْ زِي ثْمصَّاضْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","خْ ؤُيَا وَارْ تّتّنْ أَيْثْ ن إِسْرَائِيل أَڒْ أَسّْ-أَ زڭْ وژْوَارْ إِڭْذَارنْ إِ إِتّكّنْ خْ ثمْقِيقّشْثْ ن ثْمصَّاضْثْ، مِينْزِي إِحَاذَا ثَامصَّاضْثْ ن يَاعْقُوبْ غَارْ مَانِي إِدْجَا وژْوَارْ إِڭْذَارنْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","إِسّْڭعّذْ يَاعْقُوبْ ثَامُوغْڒِي نّسْ ؤُشَا إِژْرَا عِيسُو ذ أَربْعَا-مْيَا ن يرْيَازنْ أَكِيذسْ خشّنْ-د. إِفَارْقْ يَاعْقُوبْ إِحنْجِيرنْ خْ لِييَا ذ رَاحِيلْ ذ ثْنَاينْ ن ثِييَّا. ");
INSERT INTO rifa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","إِڭَّا ثِييَّا ذ ثَارْوَا نْسنْثْ غَارْ زَّاثْ، أَوَارْنِي أَسنْثْ لِييَا ذ ثَارْوَا نّسْ ؤُ رَاحِيلْ ذ يُوسُوفْ ذ إِنڭُّورَا. ");
INSERT INTO rifa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ؤُمِي إِعْذُو زَّاثْ إِ ثِيطَّاوِينْ نْسنْ، إِبنْذقْ غَارْ ثمُّورْثْ سبْعَا ن ثْوَاڒَاوِينْ أَڒَامِي د-يِيوضْ غَارْ ؤُمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","عِيسُو يُوزّڒْ-د حِيمَا أَذْ ث إِڒْقَا، إِذَارّعْ أَسْ، إِنْڭزْ أَسْ خْ يِيرِي نّسْ، إِسُّوذمْ إِ-ث ؤُشَا رُونْ س ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","خَاسْ ؤُشَا إِسّْڭعّذْ ثِيطَّاوِينْ نّسْ، إِژْرَا ثِيمْغَارِينْ ذ إِحنْجِيرنْ نِّي ؤُشَا إِنَّا: ”مِينْ عْنَانْ إِنَا إِنِّي أَكِيذكْ؟“ نتَّا يَارَّا-د خَاسْ: ”ذ ثَارْوَا نِّي إِوْشَا أَربِّي زڭْ أَرْضَا نّسْ إِ ؤُمْسخَّارْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ؤُشَا رحّْڭنْثْ-إِ-د ثِييَّا، نِيثنْثِي ذ ثَارْوَا نْسنْثْ، ؤُشَا بنْذْقنْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ثْرحّڭْ-د عَاوذْ لِييَا ذ إِحنْجِيرنْ نّسْ ؤُشَا بنْذْقنْ. ڒخْذنِّي إِقَارّبْ-د يُوسُوفْ ذ رَاحِيلْ ؤُشَا بنْذْقنْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","إِنَّا أَسْ: ”مِينْ ثخْسذْ أَكْ-ذ ؤُبَارُّو-يَا ن ڒْعسْكَارْ نِّي ڒْقِيغْ؟“ نتَّا إِنَّا: ”نشّْ سّكّغْ ث، مَاحنْذْ أَذْ أَفغْ أَرْضَا ذِي ثِيطَّاوِينْ ن سِيذِي إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","إِنَّا عِيسُو: ”أَقَا غَارِي أَطَّاسْ، ؤُمَا إِنُو! أَذْ يِيڒِي إِ شكْ مِينْ إِدْجَانْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","خَاسْ ؤُشَا إِنَّا يَاعْقُوبْ: ”لَّ، تّْزَاوَاڭغْ شكْ! مَاڒَا ؤُفِيغْ ڒخُّو أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، كْسِي أَرِّيغَالُو إِنُو زڭْ إِفَاسّنْ إِنُو، مَاغَارْ ژْرِيغْ ؤُذمْ نّشْ أَخْمِي ژْرِيغْ ؤُذمْ ن أَربِّي ؤُشَا ثْقبْڒذْ خَافِي س ڒمْڒَاحثْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","تّْزَاوْڭغْ شكْ، كْسِي لْبَارَاكَا إِنُو إِ ذ أَشْ د-إِوْيغْ، مِينْزِي أَربِّي إِمْصُورُّوفْ أَكِيذِي س أَرْضَا ؤُشَا نشّْ غَارِي كُوڒْشِي.“ إِكلّفْ إِ-ث ؤُشَا إِكْسِي ث. ");
INSERT INTO rifa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","نتَّا إِنَّا: ”أجّْ أَنغْ أَذْ نفْسِي إِقِيضَانْ نّغْ، أَذْ نْرَاحْ. نشّْ أَذْ رَاحغْ زَّاثشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","مَاشَا نتَّا إِنَّا أَسْ: ”سِيذِي إِنُو إِسّنْ، أَقَا إِحنْجِيرنْ-أَ أَرهْفنْ ؤُ أَقَا غَارِي ؤُدْجِي ذ ثْفُونَاسِينْ ؤُرْونْثْ سُّوطُّوضنْثْ. مَاڒَا بْنَاذمْ إِزيَّارْ خَاسنْثْ أَطَّاسْ، وَاخَّا مْغِيرْ إِ يِيجّْ ن وَاسّْ، أَذْ إِمّثْ وُودْجِي مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","أَذْ إِعْذُو ڒخُّو سِيذِي إِنُو زَّاثْ إِ ؤُغمْبُوبْ ن ؤُمْسخَّارْ نّسْ ؤُ نشّْ أَذْ د-أَسغْ شْوَايْثْ شْوَايْثْ أَكْ-ذ إِصُورَافْ ن ڒكْسِيبثْ إِ إِدْجَانْ زَّاثِي ؤُڒَا أَكْ-ذ إِصُورَافْ ن إِحنْجِيرنْ، أَڒْ د غَا أَوْضغْ غَارْ سِيذِي إِنُو ذِي سَاعِيرْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","إِنَّا عِيسُو: ”أَذْ جّغْ ڒخُّو أَكِيذكْ شَا ن إِوْذَانْ إِنِّي إِدْجَانْ أَكِيذِي.“ مَاشَا نتَّا إِنَّا: ”ؤُمِي دّڭَّا؟ أجّْ أَيِي أَذْ أَفغْ أَرْضَا ذِي ثِيطَّاوِينْ ن سِيذِي إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","إِعْقبْ-د عِيسُو ذڭْ وَاسّْ نِّي خْ وبْرِيذْ غَارْ سَاعِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ؤُشَا إِفْسِي يَاعْقُوبْ إِقِيضَانْ نّسْ، يُويُورْ غَارْ سُوكُّوثْ، إِبْنَا ذِينْ ثَادَّارْثْ إِ يِيخفْ نّسْ ؤُشَا إِڭَّا إِعُوشُّوثنْ ن ثْسطَّا إِ ڒبْهَايمْ نّسْ. خْ ؤُيَا إِڒَاغَا إِسمْ ن ومْشَانْ نِّي سُوكُّوثْ، إِخْسْ أَذْ يِينِي ’إِعُوشُّوثنْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ؤُمِي د-إِعْقبْ يَاعْقُوبْ زِي فَاذَانْ-أَرَامْ، يُوسَا-د غَارْ شَالِيمْ، إِشْثْ ن ثنْذِينْثْ ن شَاكِيمْ، ثنِّي إِدْجَانْ ذِي ثمُّورْثْ ن كنْعَانْ، ؤُشَا إِوْثَا إِقِيضَانْ نّسْ زَّاثْ إِ ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","إِسْغَا طَّارْفْ ن ييَّارْ مَانِي إِوْثَا إِقِيضَانْ نّسْ، زڭْ إِفَاسّنْ ن إِحنْجِيرنْ ن حَامُورْ، بَابَاسْ ن شَاكِيمْ، س مْيَا ن إِزِييْنَاثْ ن نُّوقَارْثْ إِوزْننْ. ");
INSERT INTO rifa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","إِسّْڭعّذْ ذِينْ إِجّْ ن ؤُعَالْطَارْ مِينْ خفْ ثمَّارْسْ ثْغَارْصْثْ ؤُشَا إِڒَاغَا أَسْ: ’أَربِّي ذ أَربِّي ن إِسْرَائِيل!‘ ");
INSERT INTO rifa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ذِينَا، يدْجِيسْ ن لِييَا، ثنِّي د-ثُورُووْ إِ يَاعْقُوبْ، ثفّغْ، حِيمَا أَذْ ثمّڒْقَا أَكْ-ذ يسِّيسْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","شَاكِيمْ، مِّيسْ ن حَامُورْ أَحِيوِي، ڒْحَاكمْ ن ثمُّورْثْ نِّي، إِژْرَا إِ-ت، إِكْسِي ت ؤُشَا إِطّصْ أَكِيذسْ، إِسّخْسَارْ إِ-ت. ");
INSERT INTO rifa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","إِطَّارْبطْ ذِي ذِينَا، يدْجِيسْ ن يَاعْقُوبْ، ؤُ نتَّا إِخْسْ ثَابْڒِيغْثْ ؤُشَا إِسِّيوڒْ غَارْ وُوڒْ ن ثبْڒِيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","إِسِّيوڒْ شَاكِيمْ غَارْ حَامُورْ بَابَاسْ، إِنَّا أَسْ: ”أَوْيِي أَيِي-د ثَابْڒِيغْثْ-أَ ذ ثَامْغَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ڒَامِي إِسْڒَا يَاعْقُوبْ بلِّي شَاكِيمْ إِضيّعْ شَّارَافْ ن يدْجِيسْ ذِينَا، ثُوغَا إِحنْجِيرنْ نّسْ أَكْ-ذ ڒبْهَايمْ ذڭْ إِيَّارْ. إِسُّوسمْ يَاعْقُوبْ أَڒَامِي د -عقْبنْ نِيثْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","إِرُوحْ حَامُورْ، بَابَاسْ ن شَاكِيمْ غَارْ يَاعْقُوبْ، حِيمَا أَذْ كِيسْ إِسِّيوڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ثَارْوَا ن يَاعْقُوبْ ذوْڒنْ-د زڭْ إِيَّارْ ؤُشَا أَرڭّْبنْ خْ ڒخْبَارْ. خيّْقنْ خْ مَانْ أَيَا ذڭْ وُوڒْ ؤُ فُّوڭْمنْ أَطَّاسْ، مِينْزِي إِڭَّا ڒفْضِيحثْ-أَ ذِي إِسْرَائِيل ؤُمِي إِطّصْ أَكْ-ذ يدْجِيسْ ن يَاعْقُوبْ. مَانْ أَيَا وَارْ إِشُووَّارْ أَذْ ث يڭّْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","إِسِّيوڒْ حَامُورْ أَكِيذْسنْ، إِنَّا: ”ڒعْمَارْ ن مِّي شَاكِيمْ إِقّنْ غَارْ يدْجِيثْومْ، تّْزَاوَاڭغْ، أَذْ أَسْ ت ثوْشمْ ذ ثَامْغَارْثْ، ");
INSERT INTO rifa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ؤُشَا أَذْ نمْضڭّْوَاڒْ. أَذْ أَنغْ ثوْشمْ يدْجِيثْومْ، كنِّيوْ أَذْ ثكْسِيمْ يسِّيثْنغْ إِ يِيخفْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","زذْغمْ أَكِيذْنغْ، مِينْزِي ثَامُّورْثْ أَقَا-ت زَّاثْومْ. زذْغمْ ؤُ ؤُيُورمْ ذَايسْ ؤُشَا طّْفمْ ذَايسْ أَڭْڒَا إِ كنِّيوْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ؤُشَا إِنَّا شَاكِيمْ عَاوذْ إِ بَابَاسْ ذ أَيْثْمَاسْ: ”أجّْ أَيِي أَذْ أَفغْ أَرْضَا ذِي ثِيطَّاوِينْ نْومْ ؤُشَا أَذْ وْشغْ مِينْ ذ أَيِي غَا ثِينِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","وَاخَّا أَذْ ثسّْضقْڒمْ خَافِي ڒحْمڒْ أَطَّاسْ ن صَّاذَاقْ ذ سُّونَانْ، أَقَا نشّْ أَذْ وْشغْ مشْحَاڒْ مَا ذ أَيِي غَا ثِينِيمْ. وْشمْ أَيِي مْغِيرْ ثَابْڒِيغْثْ ذ ثَامْغَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","أَرِّينْ-د إِحنْجِيرنْ ن يَاعْقُوبْ خْ شَاكِيمْ ذ حَامُورْ، بَابَاسْ، س إِشْثْ ن ثحْرَايْمشْثْ، مِينْزِي أَقَا إِسّخْسَارْ ذِينَا، ؤُتْشْمَاثْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","نِيثْنِي سِّيوْڒنْ، نَّانْ أَسنْ: ”وَارْ نْزمَّارْ أَذْ نڭّْ أَمُّو، أَذْ نوْشْ ؤُتْشْمَاثْنغْ إِ ورْيَازْ نِّي عَاذْ س ڒعْذَاڒْيثْ. ذڭَّا ذ ڒْعَارْ خَانغْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","مْغِيرْ س ؤُمْثَاوِي-يَا وَاهَا أَذْ كنِّيوْ نْسعّفْ، مَاڒَا ثڭِّيمْ أَمْ نشِّينْ، أَذْ ثتّْوَاخثْنمْ مَارَّا إِوثْمَانْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","خنِّي أَذْ أَومْ نوْشْ يدْجِيثْنغْ ؤُشَا أَذْ نكْسِي يسِّيثْومْ، أَذْ كِيذْونْ نزْذغْ، أَذْ نِيڒِي ذ إِجّْ ن ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","مَاشَا مَاڒَا وَارْ ذ أَنغْ ثسْڒِيمْ ذِي ثْمسْڒَاشْثْ ن وخْثَانْ، خنِّي أَذْ نكْسِي يدْجِيثْنغْ ؤُشَا أَذْ نُويُورْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","بَاننْ وَاوَاڒنْ نْسنْ مْلِيحْ ذڭْ إِمزُّوغنْ ن حَامُورْ ؤُ ذڭْ إِمجَّانْ ن شَاكِيمْ، مِّيسْ ن حَامُورْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","أَعزْرِي وَارْ ذ أَسْ إِشْقِي أَذْ إِڭّْ مَانْ أَيَا، مِينْزِي نتَّا إِتّخْسْ أَطَّاسْ يدْجِيسْ ن يَاعْقُوبْ ؤُ نتَّا ثُوغَا-ث قَاعْ مْوقَّارْ ذِي مَارَّا ثَادَّارْثْ ن بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ؤُشَا ؤُسِينْ-د حَامُورْ ذ مِّيسْ شَاكِيمْ غَارْ ثوَّارْثْ ن ثنْذِينْثْ نّسْ، سِّيوْڒنْ أَكْ-ذ يرْيَازنْ ن ثنْذِينْثْ، نَّانْ: ");
INSERT INTO rifa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","”إِرْيَازنْ-أَ ذ إِمْهُوذْننْ أَكِيذْنغْ. أجّْ أَنغْ أَذْ ثنْ نجّْ أَذْ زذْغنْ ذِي ثمُّورْثْ-أَ ؤُشَا أَذْ ذَايسْ ؤُيُورنْ. خْزَارْ، ثَامُّورْثْ ثوْسعْ إِ نِيثْنِي غَارْ مَارَّا إِغزْذِيسنْ نّسْ. نشِّينْ أَذْ نكْسِي يسِّيثْسنْ ذ ثِيمْغَارِينْ، أَذْ أَسنْ نوْشْ يسِّيثْنغْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","مَاشَا س ؤُمْثَاوِي-يَا وَاهَا أَذْ سعّْفنْ يرْيَازنْ-أَ، حِيمَا أَذْ كِيذْنغْ زذْغنْ ؤُ حِيمَا أَذْ ذوْڒنْ ذ إِجّْ ن ڒْڭنْسْ أَكِيذْنغْ، مَاڒَا مَارَّا إِرْيَازنْ إِ إِدْجَانْ جَارْ أَنغْ أَذْ تّْوَاخثْننْ أَمْ مَامّشْ تّْوَاخثْننْ نِيثْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ڒبْهَايمْ نْسنْ ذ أَڭْڒَا نْسنْ ذ مَارَّا ڒْمَاڒْ نْسنْ، مَا وَارْ تِّيڒِينْ نّغْ؟ أجّْ أَنغْ أَذْ ثنْ نْسعّفْ، خنِّي أَذْ زذْغنْ أَكِيذْنغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","مَارَّا إِنِّي د-يُوسِينْ غَارْ ثوَّارْثْ ن ثنْذِينْثْ نّسْ سْڒِينْ إِ حَامُورْ ذ مِّيسْ شَاكِيمْ ؤُشَا مَارَّا إِرْيَازنْ إِنِّي د-يُوسِينْ غَارْ ثوَّارْثْ ن ثنْذِينْثْ نّسْ، تّْوَاخثْننْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ؤُمِي ثُوغَا عَاذْ ذَايْسنْ ڒهْرِيقْ ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا، ثمْسَارْ بلِّي إِحنْجِيرنْ ن يَاعْقُوبْ، شِيمْعُونْ ذ لَاوِي، أَيْثْمَاسْ ن ذِينَا، أَقَا كُوڒْ إِجّْ زَّايْسنْ إِكْسِي سِّيفْ نّسْ ؤُشَا رُوحنْ غَارْ ثنْذِينْثْ مَانِي ذ أَسنْ إِتّْغِيڒْ أَقَا ذَايسْ ڒَامَانْ ؤُشَا نْغِينْ مَارَّا إِرْيَازنْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","نْغِينْ حَامُورْ ذ مِّيسْ شَاكِيمْ س ڒقْضعْ ن سِّيفْ ؤُشَا كْسِينْ ذِينَا زِي ثَادَّارْثْ ن شَاكِيمْ، فّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ثَارْوَا ن يَاعْقُوبْ ؤُسِينْ-د غَارْ يِينِّي إِتّْوَانْغنْ ؤُشَا كشّْضنْ ثَانْذِينْثْ، مِينْزِي نِيثْنِي سّخْسَارنْ ؤُتْشْمَاثْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","كْسِينْ ؤُدْجِي نْسنْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نْسنْ ذ يغْيَاڒْ نْسنْ ذ مَارَّا مِينْ ثُوغَا ذِي ثنْذِينْثْ ؤُ ذڭْ إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","كْسِينْ مَارَّا أَڭْڒَا نّسْ ؤُشَا إِوْينْ-د مَارَّا إِحنْجِيرنْ ذ ثمْغَارِينْ نْسنْ ذ إِمحْبَاسْ ؤُشَا ؤُشَارنْ مَارَّا مِينْ ثُوغَا ذِي ثُوذْرِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","خنِّي إِنَّا يَاعْقُوبْ إِ شِيمْعُونْ ذ لَاوِي: ”كنِّيوْ ثسِّيذْفمْ أَيِي ذڭْ إِمْخُومْبَارْ أَڒَامِي ذ أَيِي ثسَّارْزْڭمْ غَارْ إِمزْذَاغْ ن ثمُّورْثْ-أَ، غَارْ أَيْثْ ن كنْعَانْ ذ إِفِيرِيزِييّنْ. ذ نشّْ غَارِي إِجّْ ن وُورُو ن يرْيَازنْ وَاهَا. مَاڒَا أَذْ مُوننْ خْ ؤُزڒْمَاضْ إِنُو، أَذْ أَيِي قژّْرنْ، أَذْ إِڒِيغْ أَريّْثغْ، نشّْ ذ ثَادَّارْثْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","نِيثْنِي نَّانْ: ”مَا إِعدّڒْ خنِّي أَذْ إِحْسبْ ؤُتْشْمَاثْنغْ أَمشْنَاوْ إِشْثْ ن لْفَاسْذَا؟“ ");
INSERT INTO rifa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ؤُشَا إِنَّا أَربِّي إِ يَاعْقُوبْ: ”كَّارْ، ڭعّذْ غَارْ بَايْثْ-إِلْ ؤُشَا قِّيمْ ذِينْ. أڭّْ ذِينْ إِجّْ ن ؤُعَالْطَارْ مِينْ خفْ إِ غَا ثسَّارْسذْ ثَاغَارْصْثْ إِ أَربِّي، ونِّي ذ أَشْ د-إِبَاننْ ؤُمِي د-ثَاروْڒذْ زڭْ ؤُغمْبُوبْ ن ؤُمَاشْ عِيسُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","خنِّي إِنَّا يَاعْقُوبْ إِ ڒْوَاشُونْ ن ثَادَّارْثْ نّسْ ؤُ إِ مَارَّا إِنِّي ثُوغَا أَكِيذسْ: ”كّْسمْ إِربِّيثنْ إِغْرِيبنْ نِّي إِدْجَانْ جَارْ أَومْ، سِيزذْڭمْ إِخفْ نْومْ ؤُشَا بدّْڒمْ أَرُّوضْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","أَذْ نكَّارْ، أَذْ نْڭعّذْ غَارْ بَايْثْ-إِلْ. نشّْ أَذْ ڭّغْ ذِينْ إِجّْ ن ؤُعَالْطَارْ إِ أَربِّي نِّي خَافِي د-يَارِّينْ ذڭْ وَاسّْ ن ڒحْصَارثْ إِنُو، ذ ونِّي ثُوغَا أَكِيذِي ذڭْ وبْرِيذْ نِّي ؤُيُورغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ؤُشَا وْشِينْ إِ يَاعْقُوبْ مَارَّا إِربِّيثنْ إِغْرِيبنْ نِّي ثُوغَا غَارْسنْ ؤُڒَا ذ ثِيخْرَازِينْ ذڭْ إِمزُّوغنْ نْسنْ ؤُشَا إِفَّارْ إِ-ثنْ يَاعْقُوبْ سَاذُو ثْشجَّارْثْ ن يِيڭّْ إِ ثُوغَا زَّاثْ إِ شَاكِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ڒَْامِي فسْينْ إِقِيضَانْ، ؤُيُورنْ سّنِّي، ثُوغَا ثِيڭّْوُوذِي ن أَربِّي خْ ثْندَّامْ نِّي ثُوغَا ذِي جّْوَايهْ إِ ذ أَسنْ د-إِنّْضنْ، أَڒَامِي نِيثْنِي وَارْ ضفَّارنْ إِحنْجِيرنْ ن يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","أَمُّو إِ يِيوضْ يَاعْقُوبْ غَارْ لُوزْ ذِي ثمُّورْثْ ن كنْعَانْ، أَقَا-ت ذ بَايْثْ-إِلْ، نتَّا ذ مَارَّا ڒْڭنْسْ إِ ثُوغَا أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","إِبْنَا ذِينْ إِجّْ ن ؤُعَالْطَارْ ؤُشَا إِڒَاغَا إِ ومْشَانْ نِّي إِلْ-بَايْثْ-إِلْ، مِينْزِي ذِينِّي إِ ذ أَسْ د-إِضْهَارْ أَربِّي، ؤُمِي د-يَارْوڒْ زڭْ ؤُغمْبُوبْ ن ؤُمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ثمُّوثْ ذِيبُورَا، ثَامسّطَّاضْثْ ن رِيفْقَا ؤُشَا نضْڒنْ ت سْوَادَّايْ إِ بَايْثْ-إِلْ، سَاذُو ثَابدْجُوضْثْ ؤُشَا إِڒَاغَا إِسمْ نّسْ ’أَلُّونْ-بَاكُوثْ‘، أَقَا-ت ذ ’ثَابدْجُوضْثْ ن إِمطَّاونْ‘. ");
INSERT INTO rifa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","إِضْهَارْ أَسْ-د عَاوذْ أَربِّي إِ يَاعْقُوبْ ؤُمِي د-إِذْوڒْ زِي فَاذَانْ-أَرَامْ ؤُشَا إِبَارْكْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","إِنَّا أَسْ أَربِّي: ”إِسمْ نّشْ ذ يَاعْقُوبْ. زِي سَّا ذ ثْسَاونْثْ وَارْ تّڭّنْ عَاذْ إِسمْ نّشْ ’يَاعْقُوبْ‘، مَاشَا ’إِسْرَائِيل‘، ذ وَا إِ غَا يِيڒِينْ ذ إِسمْ نّشْ.“ ؤُشَا إِسمَّا ث إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","إِنَّا أَسْ أَربِّي: ”نشّْ ذ أَربِّي، أَمْزمَّارْ خْ كُوڒْشِي! أڭّْ ڒْغِيدْجثْ، مَّارْنِييْ! زَّايكْ إِ غَا إِفّغْ إِجّْ ن ڒْڭنْسْ، وَاهْ، ذ إِجّْ ن وڭْرَاوْ ن ڒڭْنُوسْ أَذْ فّْغنْ زَّايكْ ؤُ إِجدْجِيذنْ أَذْ فّْغنْ زِي ثجْعِينَّا نّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ؤُشَا ثَامُّورْثْ-أَ إِ وْشِيغْ إِ إِبْرَاهِيمْ ذ إِسْحَاقْ، إِ شكْ ؤُمِي ت إِ غَا وْشغْ ؤُشَا ؤُڒَا إِ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ أَذْ وْشغْ ثَامُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","خَاسْ ؤُشَا إِڭعّذْ أَربِّي سنّجْ زڭْ ومْشَانْ مَانِي كِيذسْ إِسِّيوڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","يَاعْقُوبْ إِسّْڭعّذْ إِجّْ ن وژْرُو ن ڒِيذَارثْ ذڭْ ومْشَانْ مَانِي كِيسْ إِسِّيوڒْ، إِجّْ ن وژْرُو ن ڒِيذَارثْ. إِسيّبْ خَاسْ إِشْثْ ن ثوْهِيبْثْ ن ؤُسيّبْ ؤُشَا إِفَارّغْ زّشْثْ خْ ؤُزدْجِيفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","إِڭَّا يَاعْقُوبْ إِسمْ ن ومْشَانْ مَانِي كِيذسْ إِسِّيوڒْ أَربِّي ’بَايْثْ-إِلْ!‘ ");
INSERT INTO rifa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","فسْينْ نِيثْنِي إِقِيضَانْ نْسنْ، فّْغنْ زِي بَايْثْ-إِلْ ؤُشَا ؤُمِي ثُوغَا تّڭّْوِيجنْ مْغِيرْ شْوَايْثْ خْ إِفْرَاثَا، خنِّي ثُورُووْ-د رَاحِيلْ ؤُ ثعْذُو خَاسْ ثَارْوَا ثقْسحْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","إِمْسَارْ، ؤُمِي ثغُّوضذْ ذِي ثَارْوَا نّسْ، ثنَّا أَسْ ڒْقَابْڒَا: ”وَارْ تّڭّْوذْ، أَقَا وَا عَاوذْ أَذْ يِيڒِي ذ مِّيمْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ڒَامِي ثضْڒقْ إِ بُوحْبڒْ أَمْ ثمُّوثْ ذِينْ، أَقَا ثْڒَاغَا أَسْ بِينْ-ؤُنِي، إِسمْ-أَ إِخْسْ أَذْ يِينِي ’مِّيسْ ن ڒحْرِيقْ إِنُو‘، مَاشَا بَابَاسْ إِڒَاغَا أَسْ بِينْيَامِينْ، إِخْسْ أَذْ يِينِي ’مِّيسْ ن زّْهَارْ إِنُو‘. ");
INSERT INTO rifa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","أَمُّو إِ ثمُّوثْ رَاحِيلْ ؤُشَا نضْڒنْثْ ت ذڭْ وبْرِيذْ غَارْ إِفْرَاثَا، إِخْسْ أَذْ يِينِي بَايْثْ-لَاحْمْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ؤُشَا إِڭَّا يَاعْقُوبْ إِجّْ ن وژْرُو ن ڒِيذَارثْ خْ ونْضڒْ نّسْ. ذ وَا ذ أَژْرُو ن ڒِيذَارثْ ن رَاحِيلْ خْ ونْضڒْ ن رَاحِيلْ أَڒْ أَسّْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","خَاسْ ؤُشَا إِفْسِي إِسْرَائِيل إِقِيضَانْ ؤُشَا إِوْثَا أَقِيضُونْ نّسْ خْ ؤُعدُّو ن مَاجْذَالْ-عِيذْرْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ؤُمِي إِزْذغْ إِسْرَائِيل ذِي ثمُّورْثْ نِّي، إِمْسَارْ بلِّي رُوبِينْ إِرُوحْ إِطّصْ أَكْ-ذ بِيلْهَا، ثَايَّا ن بَابَاسْ، ؤُشَا يِيوضْ أَذْ ث إِفْهمْ إِسْرَائِيل. أَقَا ڒخُّو إِوْضنْ أَيْثْ ن يَاعْقُوبْ ثنْعَاشْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ثَارْوَا ن لِييَا ثُوغَا أَثنْ: رُوبِينْ، أَمنْزُو ن يَاعْقُوبْ ذ شِيمْعُونْ ذ لَاوِي ذ يَاهُوذَا ذ إِسَّاكَارْ ذ زابُولُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ثَارْوَا ن رَاحِيلْ ثُوغَا أَثنْ: يُوسُوفْ ذ بِينْيَامِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ثَارْوَا ن بِيلْهَا، ثَايَّا ن رَاحِيلْ، ثُوغَا أَثنْ: ذَانْ ذ نَافْثَالِي. ");
INSERT INTO rifa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ثَارْوَا ن زِيلْپَا، ثَايَّا ن لِييَا، ثُوغَا أَثنْ: جَاذْ ذ أَشِيرْ. إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن يَاعْقُوبْ إِنِّي ذ أَسْ د-إِتّْوَاخڒْقنْ ذِي فَاذَانْ-أَرَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ؤُشَا يُوسَا-د يَاعْقُوبْ غَارْ بَابَاسْ إِسْحَاقْ ذِي مَامْرِي، ذِي ثنْذِينْثْ ن أَرْبَاعْ، ثنِّي إِدْجَانْ ذ ثَانْذِينْثْ ن حَابْرُونْ، مَانِي ثُوغَا إِبْرَاهِيمْ إِزدّغْ أَمْ ؤُبَارَّانِي، ؤُشَا إِسْحَاقْ أَمنِّي أَوَارْنِي أَسْ. ");
INSERT INTO rifa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","إِدَّارْ إِسْحَاقْ مْيَا ؤُ-ثْمَانْيِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","إِضْڒقْ إِسْحَاقْ إِ بُوحْبڒْ، إِمُّوثْ ؤُشَا إِمَّارْنِي غَارْ ڒْڭنْسْ نّسْ، إِوْسَارْ، إِجِّيونْ زِي ثُوذَارْثْ، ؤُشَا عِيسُو ذ يَاعْقُوبْ، إِحنْجِيرنْ نّسْ، نضْڒنْ ث. ");
INSERT INTO rifa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي عِيسُو، ونِّي إِدْجَانْ ذ إِذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","عِيسُو إِكْسِي ثِيمْغَارِينْ نّسْ زڭْ يسِّيسْ ن كنْعَانْ: عَاذَا، يدْجِيسْ ن إِلُونْ، أَحِيتِّي، ذ أَهُولِيبَامَا، يدْجِيسْ ن عَانَا، يدْجِيسْ ن صَابْعُونْ، أَحِيوِي، ");
INSERT INTO rifa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ذ بَاسْمَاثْ، يدْجِيسْ ن إِسْمَاعِيلْ، ؤُتْشْمَاسْ ن نَابَايُوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","عَاذَا ثُورُووْ-د إِلِيفَازْ إِ عِيسُو ؤُشَا بَاسْمَاثْ ثُورُووْ أَسْ-د رَاعُووِيلْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","أَهُولِيبَامَا ثُورُووْ-د يَاعُوسْ ذ يَاعْلَامْ ذ قُورَاحْ. إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن عِيسُو، إِنِّي ذ أَسْ د-يُورْونْ ذِي ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ؤُشَا إِكْسِي عِيسُو ثِيمْغَارِينْ نّسْ ذ إِحنْجِيرنْ نّسْ ذ يسِّيسْ ذ مَارَّا أَيْثْبَابْ ن ثَادَّارْثْ نّسْ ؤُڒَا ذ ڒبْهَايمْ نّسْ ذ مَارَّا ڒْمَاڒْ نّسْ ذ مَارَّا أَڭْڒَا نّسْ نِّي ثُوغَا د-إِكْسبْ زِي ثمُّورْثْ ن كنْعَانْ ؤُشَا إِرُوحْ غَارْ ثمُّورْثْ نّغْنِي إِ إِڭّْوجنْ خْ ؤُغمْبُوبْ ن ؤُمَاسْ يَاعْقُوبْ، ");
INSERT INTO rifa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","مِينْزِي أَڭْڒَا نْسنْ ثُوغَا إِمْغَارْ أَڒَامِي وَارْ زمَّارنْ أَذْ زذْغنْ جْمِيعْ، ؤُشَا ثَامُّورْثْ مَانِي ثُوغَا زدّْغنْ أَمْ ڒْبَارَّانِي، وَارْ ثْقدّْ إِ ڒبْهَايمْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","خنِّي إِزْذغْ عِيسُو ذڭْ إِذُورَارْ ن سَاعِيرْ. عِيسُو، نتَّا ذ إِذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي عِيسُو، بَابَاسْ ن إِذُومْ، ذڭْ إِذُورَارْ ن سَاعِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","إِنَا ثُوغَا أَثنْ ذ إِسْمَاونْ ن إِحنْجِيرنْ ن عِيسُو: إِلِيفَازْ، مِّيسْ ن عَاذَا ثنِّي ذ ثَامْغَارْثْ ن عِيسُو، رَاعُووِيلْ، مِّيسْ ن بَاسْمَاثْ، ثنِّي ذ ثَامْغَارْثْ ن عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","إِحنْجِيرنْ ن إِلِيفَازْ ثُوغَا أَثنْ ذ ثَايْمَانْ، ؤُمَارْ، صَافُو، جَاعْثَامْ ذ قَانَازْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ثِيمْنَاعْ ثذْوڒْ ذ ثَايَّا ن إِلِيفَازْ، مِّيسْ ن عِيسُو، ؤُ نتَّاثْ ثُورُووْ-د عَامَالِيقْ إِ إِلِيفَازْ. إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن عَاذَا، ثَامْغَارْثْ ن عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن رَاعُووِيلْ: نَاحَاثْ، زَارَاحْ، شَامَّا ذ مِيزَّا. إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن بَاسْمَاثْ، ثنِّي ذ ثَامْغَارْثْ ن عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن أَهُولِيبَامَا، ثنِّي ذ ثَامْغَارْثْ ن عِيسُو، يدْجِيسْ ن عَانَا، ثنِّي ذ يدْجِيسْ ن زِيبْيُونْ. نتَّاثْ ثُورُووْ-د يَاعُوشْ، جَاعْلَامْ ذ قُورَاحْ إِ عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن ثْقبَّاڒْ ن أَيْثْ ن عِيسُو. إِحنْجِيرنْ ن إِلِيفَازْ، أَمنْزُو ن عِيسُو: أَمْغَارْ ثِيمَانْ ذ ؤُمْغَارْ ؤُمَارْ ذ ؤُمْغَارْ صَافُو ذ ؤُمْغَارْ قِينَازْ، ");
INSERT INTO rifa_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ذ ؤُمْغَارْ قُورَاحْ، ذ ؤُمْغَارْ ڭَاثَامْ، ذ ؤُمْغَارْ عَامَالِيقْ. إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن إِلِيفَازْ ذِي ثمُّورْثْ ن إِذُومْ، إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن عَاذَا. ");
INSERT INTO rifa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن رَاعُووِيلْ، مِّيسْ ن عِيسُو: أَمْغَارْ نَاحَاثْ ذ ؤُمْغَارْ زَارَاحْ ذ ؤُمْغَارْ سَامَّا ذ ؤُمْغَارْ مِيزَّا. إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن رَاعُووِيلْ ذِي ثمُّورْثْ ن إِذُومْ، ذ إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن بَاسْمَاثْ، ثَامْغَارْثْ ن عِيسُو. ");
INSERT INTO rifa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","إِنَا ثُوغَا أَثنْ ذ أَيْثْ ن أَهُولِيبَامَا، ثَامْغَارْثْ ن عِيسُو: أَمْغَارْ يَاعُوشْ ذ ؤُمْغَارْ يَاعْلَامْ ذ ؤُمْغَارْ قُورَاحْ. إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن أَهُولِيبَامَا، ثَامْغَارْثْ ن عِيسُو، يدْجِيسْ ن عَانَا. ");
INSERT INTO rifa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن عِيسُو ذ إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن ثْقبَّاڒْ نْسنْ، نِيثْنِي ذ إِذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن سَاعِيرْ، أَخُورِي، إِنِّي ذ إِمزْذَاغْ ن ثمُّورْثْ نِّي: لُوطَانْ، شُوبَالْ، صَابْعُونْ، عَانَا، ");
INSERT INTO rifa_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ذِيشُونْ، إِصَارْ ذ ذِيشَانْ. إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن ثْقبَّاڒْ ن إِخُورِييّنْ، أَيْثْ ن سَاعِيرْ ذِي ثمُّورْثْ ن إِذُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","إِحنْجِيرنْ ن لُوطَانْ ثُوغَا أَثنْ ذ أَخُورِي ذ هَايْمَامْ ؤُشَا ثُوغَا ثِيمْنَاعْ ذ ؤُتْشْمَاسْ ن لُوطَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن شُوبَالْ: عَالْوَانْ، مَانَاحَاثْ، عِيبَالْ، شَافُو ذ ؤُنَامْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن صَابْعُونْ: أَيَا ذ عَانَا. ذ عَانَا وَانِيثَا ذ ونِّي ذ يُوفِينْ ڒْعُونْصَارَاثْ س وَامَانْ إِحْمَانْ ذِي ڒخْڒَا، ؤُمِي يَارْوسْ إِغْيَاڒْ ن زِيبِييُونْ بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن عَانَا: مْغِيرْ ذِيشُونْ، ذ أَهُولِيبَامَا، يدْجِيسْ ن عَانَا. ");
INSERT INTO rifa_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن ذِيشَانْ: حَامْذَانْ ذ أَهْبَانْ ذ يِيثْرَانْ ذ كَارَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن إِصَارْ: بِيلْهَانْ، زَاعْوَانْ ذ عَاقَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن ذِيشَانْ: عُوصْ ذ أَرَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن ثْقبَّاڒْ ن إِخُورِييّنْ: أَمْغَارْ لُوطَانْ ذ ؤُمْغَارْ شُوبَالْ ذ ؤُمْغَارْ صَابْعُونْ ذ ؤُمْغَارْ عَانَا ");
INSERT INTO rifa_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ذ ؤُمْغَارْ ذِيشُونْ ذ ؤُمْغَارْ إِصَارْ ذ ؤُمْغَارْ ذِيشَانْ. إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن إِخُورِييّنْ عْلَاحْسَابْ إِمْغَارنْ نْسنْ ذِي ثمُّورْثْ ن سَاعِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","إِنَا ثُوغَا أَثنْ ذ إِجدْجِيذنْ نِّي إِحكْمنْ ذِي ثمُّورْثْ ن إِذُومْ قْبڒْ مَا أَذْ إِحْكمْ ؤُجدْجِيذْ خْ أَيْثْ ن إِسْرَائِيل: ");
INSERT INTO rifa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بِيلَاعْ، مِّيسْ ن بَاعُورْ، إِحْكمْ ذِي إِذُومْ ؤُشَا إِسمْ ن ثنْذِينْثْ نّسْ ثُوغَا-ث ذ ذِينْهَابَا. ");
INSERT INTO rifa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","إِمُّوثْ بِيلَاعْ ؤُشَا يُوبَابْ، مِّيسْ ن زَارَاحْ زِي بُوصْرَا إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","يُوبَابْ إِمُّوثْ ؤُشَا حُوشَامْ، زِي ثمُّورْثْ ن إِثَايْمَانِييّنْ، إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","إِمُّوثْ حُوشَامْ ؤُشَا هَاذَاذْ، مِّيسْ ن بَاذَاذْ، ونِّي إِغڒْبنْ خْ مِيذْيَانْ ذڭْ إِيَّارْ ن مُوآبَ، إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. إِسمْ ن ثنْذِينْثْ نّسْ قَّارنْ أَسْ عَاوِيثْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","إِمُّوثْ هَاذَاذْ ؤُشَا سَامْلَا زِي مَاسْرِيقَا إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","إِمُّوثْ سَامْلَا ؤُشَا شَاوُولْ، زِي رِيحُوبُوثْ غَارْ يغْزَارْ ن لْفُورَاطْ، إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","إِمُّوثْ شَاوُولْ ؤُشَا بَاعْلْ-حَانَانْ، مِّيسْ ن عَاكْبُورْ، إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","إِمُّوثْ بَاعْلْ-حَانَانْ، مِّيسْ ن عَاكْبُورْ، ؤُشَا هَاذَارْ إِذْوڒْ ذ أَجدْجِيذْ ذڭْ ومْشَانْ نّسْ. ثَانْذِينْثْ نّسْ قَّارنْ أَسْ فَاعُو ؤُ ثَامْغَارْثْ نّسْ قَّارنْ أَسْ مَاهِيطَابْ‘إِلْ، يدْجِيسْ ن مَاطْرِيذْ، يدْجِيسْ ن مَا-ذَاهَابْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","إِنَا ثُوغَا أَثنْ ذ إِسْمَاونْ ن إِمْغَارنْ ن ثْقبَّاڒْ ن عِيسُو عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ ذ إِمُوشَانْ نْسنْ ذ إِسْمَاونْ نْسنْ: أَمْغَارْ ثِيمْنَاعْ ذ ؤُمْغَارْ عَالْوَا ذ ؤُمْغَارْ يَاثِيثْ ");
INSERT INTO rifa_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ذ ؤُمْغَارْ أَهُولِيبَامَا ذ ؤُمْغَارْ إِلَا ذ ؤُمْغَارْ فِينُونْ ");
INSERT INTO rifa_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ذ ؤُمْغَارْ قَانَازْ ذ ؤُمْغَارْ ثَايْمَانْ ذ ؤُمْغَارْ مِيبْصَارْ ");
INSERT INTO rifa_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ذ ؤُمْغَارْ مَاجْذِييِيلْ ذ ؤُمْغَارْ عِيرَامْ. إِنَا ثُوغَا أَثنْ ذ إِمْغَارنْ ن إِذُومْ عْلَاحْسَابْ إِمُوشَانْ نْسنْ، ذِي ثمُّورْثْ ن ڒْملْكْ نْسنْ. وَانِيثَا ذ إِذُومْ، ونِّي ذ بَابَاسْ ن إِذُومِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN36_44","002_36_44","GEN","36","44","44","ؤُشَا إِزْذغْ يَاعْقُوبْ ذِي ثمُّورْثْ ن كنْعَانْ مَانِي ثُوغَا إِزدّغْ بَابَاسْ أَمْ ؤُبَارَّانِي. إِنَا ذ إِمزْرُوينْ ن يِينِّي د-إِتّْوَاخڒْقنْ زِي يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ڒَامِي ثُوغَا غَارْ يُوسُوفْ سْبعْطَاشْ ن إِسڭّْوُوسَا، يَارْوسْ ؤُدْجِي ن بَابَاسْ أَكْ-ذ أَيْثْمَاسْ. ثُوغَا يُوسُوفْ ذ أَمْسخَّارْ غَارْ إِحنْجِيرنْ ن بِيلْهَا ذ إِحنْجِيرنْ ن زِيلْپَا، ثِيمْغَارِينْ ن بَابَاسْ ؤُشَا إِسِّيوضْ يُوسُوفْ أَوَاڒنْ نْسنْ إِعفَّاننْ إِ بَابَاثْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ؤُشَا إِخْسْ إِسْرَائِيل يُوسُوفْ قَاعْ خْ مَارَّا إِحنْجِيرنْ نّسْ، مِينْزِي ثُوغَا-ث غَارسْ ذ مِّيسْ خْ ثوْسَارْ نّسْ ؤُشَا إِڭَّا أَسْ أَرُّوضْ س إِفَاسّنْ ذ إِزِيرَارنْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ڒَْامِي ژْرِينْ أَيْثْمَاسْ بلِّي بَابَاسْ إِتّخْسْ إِ-ث قَاعْ خَاسنْ، شَارْهنْ ث ؤُشَا وَارْ زمَّارنْ أَكِيذسْ سِّيوْڒنْ عَاذْ س ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ؤُشَا يُورْجَا يُوسُوفْ إِشْثْ ن ثَارْجِيثْ، إِعَاوْذْ إِ-ت إِ يَايْثْمَاسْ. س ؤُيَا نِيثْنِي ذوْڒنْ شَارْهنْ ث عَاذْ كْثَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","إِنَّا أَسنْ: ”سْڒمْ ڒخُّو ثَارْجِيثْ-أَ نِّي ؤُرْجِيغْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","خْزَارْ، ثُوغَا نتّْشدَّا ثِيقبِّيضِينْ ن إِمنْذِي ذِي ڒْوسْطْ ن ييَّارْ. ؤُ خْزَارْ، ثَاقبِّيضْثْ إِنُو ثْبدّْ، ثقِّيمْ ثْبدّْ ؤُ ثِيقبِّيضِينْ نْومْ نِّي ثُوغَا ذ أَسْ د-إِنّْضنْثْ، بنْذْقنْ إِ ثْقبِّيضْثْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","أَرِّينْ-د خَاسْ أَيْثْمَاسْ: ”مَا أَذْ ثْحكْمذْ زعْمَا نِيشَانْ خَانغْ أَمْ ؤُجدْجِيذْ نِيغْ أَذْ خَانغْ ثْسدْجْضذْ ذ أَسدْجضْ؟“ ؤُشَا شَارْهنْ ث عَاذْ كْثَارْ ذِي سِّيبّثْ ن ثِيرْجَا نّسْ ذ وَاوَاڒنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ؤُشَا يُورْجَا عَاذْ ثَارْجِيثْ نّغْنِي، إِعَاوْذْ إِ-ت إِ يَايْثْمَاسْ، إِنَّا: ”خْزَارْ، أَرْجِيغْ عَاذْ ثَارْجِيثْ نّغْنِي. خْزَارْ ثَافُوشْثْ ذ ؤُيُورْ ذ حِيطَاشْ ن إِثْرَانْ بنْذْقنْ أَيِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","إِعَاوذْ إِ-ت إِ بَابَاسْ ذ أَيْثْمَاسْ ؤُشَا إِوبّخْ إِ-ث بَابَاسْ، إِنَّا أَسْ: ”مَانَا ثَارْجِيثْ-أَ إِ ثَارْجِيذْ؟ مَا أَذْ د-نَاسْ جْمِيعْ، نشّْ ذ يمَّاشْ ذ أَيْثْمَاشْ، أَذْ أَشْ نْبنْذقْ غَارْ ثمُّورْثْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","أَيْثْمَاسْ ؤُسْمنْ زَّايسْ. مَاشَا بَابَاسْ إِعْقڒْ خْ وَاوَاڒنْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ؤُشَا رُوحنْ أَيْثْمَاسْ، حِيمَا أَذْ أَروْسنْ ؤُدْجِي ن بَابَاثْسنْ غَارْ شَاكِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","خنِّي إِنَّا إِسْرَائِيل إِ يُوسُوفْ: ”مَا وَارْ أَروْسنْ أَيْثْمَاشْ ؤُدْجِي غَارْ شَاكِيمْ؟ زِيذْ، أَذْ شكْ غَارْسنْ سّكّغْ.“ ؤُشَا يَارَّا-د خَاسْ: ”أَقَا أَيِي ذَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ؤُشَا إِنَّا أَسْ: ”رُوحْ شكْ، خْزَارْ مُوخَاسْ دْجَانْ أَيْثْمَاشْ ذ مُوخَاسْ دْجَانْ وُودْجِي ؤُشَا أَوِي أَيِي-د ڒخْبَارْ عَاوذْ.“ أَمُّو إِ-ث إِسّكّْ زِي ڒوْضَا ن ثغْزُورْثْ ن حَابْرُونْ ؤُشَا نتَّا يِيوضْ-د غَارْ شَاكِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","يُوفَا إِ-ث إِجّْ ن ورْيَازْ ؤُمِي إِودَّارْ ذڭْ إِيَّارْ. إِسّقْسَا ث ورْيَازْ، إِنَّا: ”مِينْ ثَارزُّوذْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","إِنَّا: ”أَرزُّوغْ خْ أَيْثْمَا. تّْزَاوْڭغْ شكْ، إِنِي أَيِي مَانِي أَروْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","أَرْيَازْ يَارَّا-د: ”أَقَا مُوطِّيينْ إِقِيضَانْ نْسنْ سَّا، نشّْ سْڒِيغْ أَسنْ قَّارنْ: ’أجّْ أَنغْ أَذْ نْرَاحْ غَارْ ذُوثَانْ.‘ “ ڒخْذنِّي إِرُوحْ يُوسُوفْ أَوَارْنِي أَيْثْمَاسْ ؤُشَا يُوفَا إِ-ثنْ ذِي ذُوثَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ؤُمِي ث ژْرِينْ زِي ڒَاڭّْوَاجْ، قْبڒْ مَا أَذْ غَارْسنْ د-إِقَارّبْ، مْعَاهَاذنْ ضِيدّْ نّسْ حِيمَا أَذْ ث نْغنْ، ");
INSERT INTO rifa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","نَّانْ إِجّْ إِ ونّغْنِي: ”خْزَارْ، يُوسَا-د بُو-ثِيرْجَا نِّي! ");
INSERT INTO rifa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","زِيذْ ڒخُّو، أجّْ أَنغْ أَذْ ث ننّغْ ؤُشَا أَذْ ث ننْضَارْ ذڭْ وَانُو، أَذْ نِينِي: ’شَا ن ڒْوحْشْ يوْعَارْ إِشَّا إِ-ث!‘، ؤُشَا خنِّي أَذْ نْژَارْ مِينْ غَا إِڒِينْثْ ثِيرْجَا نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","إِسْڒَا رُوبِينْ مَانْ أَيَا ؤُشَا إِفكّْ إِ-ث زڭْ إِفَاسّنْ نْسنْ، إِنَّا: ”وَارْ ث نّقّْ شَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","إِنَّا أَسنْ عَاوذْ رُوبِينْ: ”وَارْ سِيزِّيڒمْ إِذَامّنْ! نْضَارمْ ث ذڭْ وَانُو-يَا ذَا ذِي ڒخْڒَا. وَارْ خَاسْ تّڭّمْ أَفُوسْ!“. إِنَّا أَمُّو حِيمَا أَذْ ث إِفكّْ زڭْ إِفَاسّنْ نْسنْ ؤُشَا أَذْ ث يَارّْ غَارْ بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ؤُشَا إِمْسَارْ، ؤُمِي د-يِيوضْ يُوسُوفْ غَارْ أَيْثْمَاسْ، كّْسنْ نِيثْنِي أَرُّوضْ خْ يُوسُوفْ، أَرُّوضْ س إِفَاسّنْ ذ إِزِيرَارنْ نِّي خَاسْ ثُوغَا، ");
INSERT INTO rifa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ؤُشَا طّْفنْ ث، نْضَارنْ ث ذڭْ وَانُو. مَاشَا أَنُو ثُوغَا إِخْوَا، وَارْ ذَايسْ ثُوغِي شَا أَمَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","أَوَارْنِي مَانْ أَيَا قِّيمنْ مَاحنْذْ أَذْ شّنْ أَغْرُومْ، ؤُشَا ڒَامِي سّْڭعّْذنْ نِيثْنِي ثِيطَّاوِينْ نْسنْ، زْڒِينْ إِجّْ ن ؤُكَارَابَانْ ن إِسْمَاعِيلِييّنْ إِ د-يُوسِينْ زِي جِيلْعَاذْ. إِڒغْمَانْ نْسنْ أَرْبُونْ ڒعْطُورْ ذ ڒفْوَاهْ ن بَالْسَامْ ذ مِيرُّو، ڭُّورنْ أَذْ ث أَوْينْ غَارْ مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","خنِّي إِنَّا يَاهُوذَا إِ يَايْثْمَاسْ: ”مَانْ ڒفْضڒْ مَاڒَا ننْغَا ؤُمَاثْنغْ ؤُشَا أَذْ نفَّارْ إِذَامّنْ نّسْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","غَاوْرمْ، أَذْ ث نزّنْزْ إِ إِسْمَاعِيلِييّنْ، وَارْ إِتِّيڒِي ؤُفُوسْ نّغْ خَاسْ، أَقَا ذ ؤُمَاثْنغْ ذ أَيْسُومْ نّغْ.“ ؤُشَا سْڒِينْ أَيْثْمَاسْ غَارسْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","أَمْ د-عْذُونْ ثُوجَّارْ ن مِيذْيَانْ، سّْڭعّْذنْ-د يُوسُوفْ زڭْ وَانُو ؤُشَا زّنْزنْ ث س عِيشْرِينْ ن ؤُقِييَّاثْ ن نُّوقَارْثْ إِ إِسْمَاعِيلِييّنْ، إِنِّي د-يِيوْينْ يُوسُوفْ غَارْ مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ڒَْامِي د-إِذْوڒْ رُوبِينْ غَارْ وَانُو، وَارْ ذِينْ يُوفِي يُوسُوفْ عَاذْ ذڭْ وَانُو. خنِّي إِشَارّڭْ أَرُّوضْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","إِذْوڒْ غَارْ أَيْثْمَاسْ ؤُشَا إِنَّا: ”أَحنْجِيرْ وَارْ ذِينْ إِدْجِي عَاذْ. إِ نشّْ، مَانِي غَا رَاحغْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","خنِّي كْسِينْ أَرُّوضْ ن يُوسُوفْ ؤُشَا غَارْصنْ إِ يِيجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ ؤُشَا مَارْغنْ أَرُّوضْ س إِذَامّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","سّكّنْ إِجّنْ س أَرُّوضْ ذ لمْلِيحْ س إِفَاسّنْ ذ إِزِيرَارنْ، جِّينْ ث أَذْ ث يَاوِي غَارْ بَابَاثْسنْ، نَّانْ: ”ذ وَا إِ نُوفَا. خْزَارْ ڒخُّو، مَا وَاهْ نِيغْ لَّا أَرُّوضْ ن مِّيشْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ؤُشَا نتَّا إِعقْڒْ إِ-ث، إِنَّا: ”أَرُّوضْ ن مِّي إِ يدْجَا! شَا ن ڒْوحْشْ يوْعَارْ إِشَّا إِ-ث. يُوسُوفْ س ثِيذتّْ بتّْقنْ ث!“ ");
INSERT INTO rifa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","إِشَارّڭْ يَاعْقُوبْ أَرُّوضْ نّسْ ؤُشَا يَارْضْ إِشْثْ ن ثْخَانْشثْ ن وشْضَانْ خْ ثجْعِينَّا نّسْ، إِشْضنْ خْ مِّيسْ أَطَّاسْ ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","كَّارنْ مَارَّا إِحنْجِيرنْ نّسْ ذ مَارَّا ثِيحنْجِيرِينْ نّسْ مَاحنْذْ أَذْ ثعزَّانْ، عَاذْ نتَّا وَارْ إِخْسْ أَذْ إِتّْوَاعزَّا، إِنَّا: ”لَّ، أَذْ د-هْوِيغْ نُّورْيغْ غَارْ ڒَاخَارْثْ.“ ؤُشَا إِسْغُويْ خَاسْ بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","إِمِيذِييَانِييّنْ زّنْزنْ ث ذِي مِيصْرَا إِ بُوثِيفَارْ، أَمْسخَّارْ أَمْشنّعْ ن فِيرْعُونْ، ڒْقبْطَانْ ن إِعسَّاسنْ ن أَرِّيمثْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ذِي ڒْوقْثْ ذ إِشْثْ إِهْوَا يَاهُوذَا، إِفّغْ خْ أَيْثْمَاسْ، ؤُشَا إِوْثَا إِقِيضَانْ نّسْ غَارْ يِيجّْ ن ورْيَازْ ذ أَذُولَّامِيثِي ونِّي ؤُمِي قَّارنْ حِيرَا. ");
INSERT INTO rifa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ؤُشَا إِژْرَا ذِينْ يَاهُوذَا يدْجِيسْ ن يِيجّْ ن ورْيَازْ ذ أَكنْعَانِي ونِّي ؤُمِي قَّارنْ شُوعَا. ؤُشَا يَاهُوذَا يِيوِي يدْجِيسْ ن شُوعَا ذ ثَامْغَارْثْ، ؤُشَا يُوذفْ خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","نتَّاثْ ثكْسِي س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ ؤُشَا يَاهُوذَا إِڒَاغَا أَسْ عِيرْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ؤُشَا ثكْسِي عَاوذْ س دّيْسثْ، ثُورُووْ-د أَحنْجِيرْ ؤُشَا ثْڒَاغَا أَسْ ؤُنَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ؤُشَا ثُورُووْ-د عَاوذْ أَحنْجِيرْ ؤُشَا ثْڒَاغَا أَسْ شَايْلَا. نتَّا ثُوغَا-ث ذِي كَازِيبْ ؤُمِي ذ أَسْ ث-إِ-د-ثُورُووْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","يَاهُوذَا إِكْسِي ثَامْغَارْثْ إِ عِيرْ، أَمنْزُو نّسْ. ثَامْغَارْثْ-أَ قَّارنْثْ أَسْ ثَامَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","عِيرْ، أَمنْزُو ن يَاهُوذَا، ثُوغَا-ث ذ أَعفَّانْ ذِي ثِيطَّاوِينْ ن سِيذِي ؤُشَا إِنْغَا إِ-ث سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","خنِّي إِنَّا يَاهُوذَا إِ ؤُنَانْ: ”أَذفْ خْ ثمْغَارْثْ ن ؤُمَاشْ، مْڒشْ أَكِيذسْ ذڭْ ومْشَانْ ن ؤُمَاشْ، ثجّذْ-د زَّارِيعثْ إِ ؤُمَاشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","مَاشَا ؤُنَانْ إِسّنْ بلِّي زَّارِيعثْ وَارْ ثتِّيڒِي نّسْ. ؤُشَا أَمُّو إِمْسَارْ، ؤُمِي يُوذفْ خْ ثمْغَارْثْ ن ؤُمَاسْ، إِنْغڒْ زَّارِيعثْ نّسْ ذِي ثمُّورْثْ، حِيمَا وَارْ إِتِّيشْ زَّارِيعثْ إِ ؤُمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","مِينْ إِڭَّا ثُوغَا ذ أَعفَّانْ ذِي ثِيطَّاوِينْ ن سِيذِي ؤُشَا إِنْغَا إِ-ث ؤُڒَا ذ نتَّا. ");
INSERT INTO rifa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","خنِّي إِنَّا يَاهُوذَا إِ ثَامَارْ، ثَاسْڒِيثْ نّسْ: ”قِّيمْ أَمْ ثَاجَّاتْشْ ذِي ثَادَّارْثْ ن بَابَامْ، أَڒْ غَا إِمْغَارْ مِّي شَايْلَا!“، مِينْزِي إِنَّا: ”أَقَا وَارْ إِتّْمتِّي ؤُڒَا ذ وَا أَمْ يَايْثْمَاسْ.“ ؤُشَا ثْرُوحْ ثَامَارْ، ثزْذغْ ذِي ثَادَّارْثْ ن بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","عْذُونْ وُوسَّانْ أَطَّاسْ، خنِّي ثمُّوثْ يدْجِيسْ ن شُوعَا، ثَامْغَارْثْ ن يَاهُوذَا. يَاهُوذَا يَارزُّو أَذْ إِتّْوَاعزَّا ؤُشَا إِڭعّذْ غَارْ ثْحِيمَارْثْ ن وُودْجِي نّسْ غَارْ ثِيمْنَاثَا، نتَّا ذ حِيرَا، أَمدُّوكّڒْ نّسْ زِي أَذُولَّامْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","عڒْمنْ ث إِ ثَامَارْ، نَّانْ: ”خْزَارْ، أَضڭّْوَاڒْ نّمْ إِڭعّذْ غَارْ ثِيمْنَاثَا، أَذْ إِڒْسْ ؤُدْجِي نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","خنِّي ثكّسْ خَاسْ أَرُّوضْ ن ثَاجَّاتْشْ، ثْڒحّفْ س ثْكنْبُوشْثْ، ثسْڒحْهفْ إِخفْ نّسْ زَّايسْ، ؤُشَا ثْرُوحْ أَذْ ثقِّيمْ غَارْ وَاذَافْ ن عَايْنَايِيمْ، ونِّي إِدْجَانْ ذڭْ وبْرِيذْ غَارْ ثِيمْنَاثَا، مِينْزِي ثژْرَا شَايْلَا إِمْغَارْ، ؤُ نتَّاثْ ثُوغَا وَارْ ذ أَسْ ثمّوْشْ ذ ثَامْغَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ؤُشَا إِژْرَا إِ-ت يَاهُوذَا، إِحسْبْ إِ-ت ذ لْفَاسْذَا، مِينْزِي ثُوغَا-ت ثْڒحّفْ إِ ؤُغمْبُوبْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ؤُشَا إِميّڒْ غَارسْ غَارْ وبْرِيذْ، إِنَّا أَسْ: ”أجّْ أَيِي أَذْ خَامْ أَذْفغْ!“، مِينْزِي نتَّا ثُوغَا وَارْ إِسِّينْ، بلِّي نتَّاثْ ذ ثَاسْڒِيثْ نّسْ. نتَّاثْ ثنَّا: ”مِينْ ذ أَيِي غَا ثوْشذْ، حِيمَا أَذْ خَافِي ثَاذْفذْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","يَارَّا-د: ”نشّْ أَذْ أَمْ-د سّكّغْ إِجّْ ن إِغَايْضْ ذ أَمژْيَانْ زڭْ إِغَايْضنْ، زڭْ وُودْجِي.“ ثنَّا أَسْ: ”مْغِيرْ أوْشْ أَيِي إِجّْ ن وَارْهَانْ أَڒْ ذ أَيِي ث-إِ-د ثسّكّذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","إِنَّا: ”مَانْ أَضْمَانْ إِ ذ أَمْ إِ غَا وْشغْ؟“ نتَّاثْ ثنَّا: ”ثَاخَاذنْثْ نّشْ ن ؤُشمِّيعْ ذ تّسْبِيحْ نّشْ ذ ثَاغَّارْشْثْ إِ غَاركْ ذڭْ ؤُفُوسْ.“ ؤُشَا إِوْشَا أَسْ ثنْ، يُوذفْ خَاسْ ؤُشَا ثكْسِي زَّايسْ دّيْسثْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ؤُشَا ثكَّارْ، ثْرُوحْ، ثكّسْ خَاسْ ثَاكنْبُوشْثْ نّسْ ؤُشَا ثْيَارْضْ أَرُّوضْ نّسْ ن ثَاجَّاتْشْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ؤُشَا إِسّكّْ يَاهُوذَا إِغَايْضْ ذ أَمژْيَانْ زڭْ إِغَايْضنْ خْ ؤُفُوسْ ن ؤُمدُّوكّڒْ نّسْ أَذُولَّامِي، حِيمَا أَذْ إِطّفْ عَاوذْ أَضْمَانْ زڭْ ؤُفُوسْ ن ثمْغَارْثْ، مَاشَا وَارْ ت يُوفِي. ");
INSERT INTO rifa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","إِسّقْسَا إِرْيَازنْ خْ ومْشَانْ نّسْ، إِنَّا: ” مَانِي ثدْجَا ثمْغَارْثْ ن فَارْقْ-شّْغڒْ نِّي ثُوغَا إِقِّيمنْ خْ وبْرِيذْ غَارْ عَانَايِيمْ؟“ نِيثْنِي أَرِّينْ-د خَاسْ: ”وَارْ ذَا ثُوغِي قَاعْ شَا ن ثمْغَارْثْ ن فَارْقْ-شّْغڒْ غَارْ زَّاوشْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","خنِّي إِعْقبْ-د غَارْ يَاهُوذَا، إِنَّا: ”وَارْ ت ؤُفِيغْ شَا، ؤُڒَا ذ إِرْيَازنْ ن ومْشَانْ نِّي نَّانْ: ’وَارْ ذَا ثُوغِي قَاعْ شَا ن ثمْغَارْثْ ن فَارْقْ-شّْغڒْ غَارْ زَّاوشْثْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ؤُشَا إِنَّا يَاهُوذَا: ”أجّْ إِ-ت أَذْ ثطّفْ أَضْمَانْ غَارسْ، حِيمَا وَارْ نتِّيڒِي ذ ڒْعَارْ. خْزَارْ، نشّْ أَقَا سّكّغْ إِغَايْضْ-أَ ذ أَمژْيَانْ، مَاشَا شكْ وَارْ ت ثُوفِيذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","عْڒَاحَاڒْ أَوَارْنِي ثْڒَاثَا ن إِيُورنْ ثمْسَارْ، أَقَا خبَّارنْ يَاهُوذَا، نَّانْ: ”ثَامَارْ، ثَاسْڒِيثْ نّشْ، أَقَا ثسّفْسذْ إِخفْ نّسْ ؤُشَا ڒخُّو نتَّاثْ أَقَا-ت س دّيْسثْ س فَارْقْ-شّْغڒْ نّسْ.“ خنِّي إِنَّا يَاهُوذَا: ”سُوفّْغمْ ت-إِ-د، أَذْ ثشْمضْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ؤُمِي ت-إِ-د-يِيوْينْ غَارْ بَارَّا، ثسّكّْ-د إِجّنْ غَارْ ؤُضڭّْوَاڒْ نّسْ، مَاحنْذْ أَذْ يِينِي: ”زڭْ ورْيَازْ ن ڒحْوَايجْ-أَ، أَقَا كْسِيغْ س دّيْسثْ.“ ثنَّا عَاذْ: ”أَرْزُو خنِّي وِي إِڒَانْ ثَاخَاذنْثْ-أَ ن ؤُشمِّيعْ ذ تّسْبِيحِينْ-أَ ذ ثَاغَّارْشْثْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","يَاهُوذَا إِعقْڒْ إِ-ثنْثْ، إِنَّا: ”أَقَا-ت ذ نِيشَانْ خَافِي، مِينْزِي وَارْ ت وْشِيغْ ذ ثَامْغَارْثْ إِ شَايْلَا مِّي.“ وَارْ إِقِّيمْ إِسّنْ إِ-ت عَاذْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ذِي ڒْوقْثْ ؤُمِي د-ثِيوضْ أَذْ د-ثَارُووْ، أَقَا ذَا أَشْنِيونْ ذڭْ ؤُعذِّيسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","إِمْسَارْ ؤُمِي د-ثُورُووْ، إِسُّوفّغْ-د إِجّنْ أَفُوسْ ؤُشَا ثكْسِي ث ڒْقَابْڒَا ؤُشَا ثْشدّْ إِ-ث غَارْ ؤُفُوسْ نّسْ س ؤُفِيڒُو ذ أَزڭّْوَاغْ، ثنَّا: ”وَا إِ د-إِفّْغنْ ذ أَمزْوَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ڒَامِي د يَارَّا أَفُوسْ نّسْ، إِبَانْ-د ؤُمَاسْ، ؤُشَا ثنَّا: ”مَامّشْ ثڭِّيذْ ثَازِّيثْ. أَذْ ثِيڒِيذْ ذ بُو-إِتَّارژَّانْ!“ ؤُشَا سمَّانْ ث فَارِيصْ.    ");
INSERT INTO rifa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","أَوَارْنِي مَانْ أَيَا إِفّغْ-د ؤُمَاسْ، ونِّي غَارْ إِدْجَا ؤُفِيڒُو أَزڭّْوَاغْ ذڭْ ؤُفُوسْ نّسْ ؤُشَا إِسمَّا ث زَارَاحْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","نذْهنْ خنِّي يُوسُوفْ غَارْ مِيصْرَا. بُوثِيفَارْ، أَمْسخَّارْ أَمْشنّعْ ن فِيرْعُونْ، ڒْقبْطَانْ ن إِعسَّاسنْ ن أَرِّيمثْ، إِجّْ ن ؤُمِيصْرِي، إِسْغَا إِ-ث زڭْ ؤُفُوسْ ن إِسْمَاعِيلِييّنْ، إِنِّي ذِينْ ث يِيوْينْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ثُوغَا سِيذِي أَكْ-ذ يُوسُوفْ. ثُوغَا نتَّا ذ أَرْيَازْ إِفْڒحْ ؤُشَا ثُوغَا-ث ذِي ثَادَّارْثْ ن سِيذِيسْ، أَمِيصْرِي. ");
INSERT INTO rifa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","إِژْرَا سِيذِيسْ بلِّي سِيذِي ثُوغَا-ث أَكِيذسْ ؤُ بلِّي سِيذِي إِسّكّْوَاضْ س ؤُفُوسْ نّسْ مَارَّا مِينْ ثُوغَا إِتّڭّْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","أَمُّو إِ يُوفَا يُوسُوفْ أَرْضَا ذِي ثِيطَّاوِينْ نّسْ، إِسخَّارْ أَسْ. ؤُشَا إِڭَّا إِ-ث بُوثِيفَارْ ذ أَمحْضَايْ خْ ثَادَّارْثْ نّسْ ؤُشَا إِڭَّا أَسْ ذڭْ ؤُفُوسْ نّسْ مَارَّا مِينْ غَارسْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","زڭْ وَاسّْ مِينْ ذِي ث إِڭَّا خْ ثَادَّارْثْ نّسْ ؤُ خْ مَارَّا مِينْ غَارسْ، إِبَارْكْ سِيذِي ثَادَّارْثْ ن ؤُمِيصْرِي ذِي طّْوعْ ن يُوسُوفْ. ثُوغَا لْبَارَاكَا ن سِيذِي خْ مَارَّا مِينْ غَارسْ، أَمْ ذَاخڒْ ن ثَادَّارْثْ، أَمْ بَارَّا ذڭْ إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","مَارَّا مِينْ غَارسْ، إِجَّا إِ-ث ذڭْ إِفَاسّنْ ن يُوسُوفْ، أَڒْ وَارْ إِسِّينْ نتَّا شَا كْثَارْ مْغِيرْ أَغْرُومْ إِ إِتّتّْ. ثُوغَا يُوسُوفْ إِشْنَا ذڭْ وَادُّوذْ ؤُ ؤُذمْ نّسْ ذَايسْ أَژْرِي. ");
INSERT INTO rifa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","إِمْسَارْ أَوَارْنِي مَانْ أَيَا، أَقَا ثَامْغَارْثْ ن سِيذِيسْ ثنْضَارْ ثِيطَّاوِينْ نّسْ ذِي يُوسُوفْ، ثنَّا: ”زِيذْ، طّصْ أَكِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","مَاشَا نتَّا يُوڭِي، إِنَّا إِ ثمْغَارْثْ ن سِيذسْ: ”خْزَارْ، سِيذِي إِنُو وَارْ إِسِّينْ مِينْ إِدْجَانْ ذِي ثَادَّارْثْ ڒَامِي ذَا أَكِيذسْ دْجِيغْ. مَارَّا مِينْ غَارسْ، إِڭَّا إِ-ث ذڭْ ؤُفُوسْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","نتَّا وَارْ إِدْجِي سنّجْ إِنُو ذِي ثَادَّارْثْ-أَ، وَارْ ذ أَيِي إِطِّيفْ س وَالُو مْغِيرْ شمْ، ؤُمِي ثدْجِيذْ ذ ثَامْغَارْثْ نّسْ. مَامّشْ إِ غَا ڭّغْ لْجَارِيمَا-يَا ثَامقّْرَانْثْ أَمْ ثَانِيثَا ؤُشَا أَذْ ڭّغْ دّنْبْ أَكْ-ذ أَربِّي!“ ");
INSERT INTO rifa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ثُوغَا ثسَّاوَاڒْ أَكْ-ذ يُوسُوفْ كُوڒْ أَسّْ، وَارْ غَارسْ إِتّسْڒِي، حِيمَا أَذْ إِطّصْ طَّارْفْ نّسْ ؤُ حِيمَا أَذْ أَكِيذسْ يِيڒِي. ");
INSERT INTO rifa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ذڭْ إِجّْ ن وَاسّْ ثمْسَارْ، ؤُمِي د-يُوذفْ غَارْ ثَادَّارْثْ، حِيمَا أَذْ إِڭّْ ڒْخذْمثْ نّسْ، وَارْ ثُوغِي ذِينْ ؤُڒَا ذ إِجّْ زڭْ يرْيَازنْ ن ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","خنِّي ثطّفّْ إِ-ث زڭْ وَارُّوضْ نّسْ، ثنَّا: ”أَرَاحْ-د زّڒْ أَكِيذِي!“ ڒخْذنِّي إِجَّا أَسْ نتَّا أَرُّوضْ نّسْ ذڭْ ؤُفُوسْ، يَارْوڒْ، إِفّغْ بَارَّا. ");
INSERT INTO rifa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ؤُمِي ثژْرَا بلِّي إِجَّا أَسْ أَرُّوضْ نّسْ ذڭْ ؤُفُوسْ نّسْ، يَارْوڒْ غَارْ بَارَّا، ");
INSERT INTO rifa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ثْڒَاغَا إِ أَيْثْبَابْ ن ثَادَّارْثْ، ثنَّا أَسنْ: ”خْزَارمْ، أَقَا نتَّا يِيوْيْ أَنغْ-د أَرْيَازْ أَعِيبْرَانِي، حِيمَا أَذْ خَانغْ إِضْحشْ. يُوسَا-د غَارِي، حِيمَا أَكِيذِي إِطّصْ ؤُشَا نشّْ سْغُويغْ س جّهْذْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ؤُمِي إِسْڒَا بلِّي سّْڭعّْذغْ ثْمِيجَّا إِنُو ؤُشَا سْغُويغْ، إِجَّا غَارِي أَرُّوضْ نّسْ، يَارْوڒْ، إِفّغْ بَارَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ؤُشَا نتَّاثْ ثڭَّا أَرُّوضْ نّسْ زَّاثسْ، أَڒْ د غَا يَاسْ سِيذِيسْ غَارْ ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","خنِّي ثسِّيوڒْ أَكِيذسْ س وَاوَاڒنْ نِّي ذ إِجّنْ، ثنَّا: ”أَمْسخَّارْ أَعِيبْرَانِي ونِّي د-ثِيوْيذْ غَارْنغْ، يُوسَا-د غَارِي حِيمَا أَذْ أَيِي إِسّْعُورَّا. ");
INSERT INTO rifa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ؤُمِي سّْڭعّْذغْ ثْمِيجَّا إِنُو، سْغُويغْ، إِجَّا أَرُّوضْ نّسْ غَارِي ؤُشَا يَارْوڒْ بَارَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","سِيذسْ إِسْڒَا إِ وَاوَاڒنْ إِنِّي ذ أَسْ ثنَّا ثمْغَارْثْ نّسْ، ثنَّا: ”أَمُّو إِ ذ أَيِي إِڭَّا ؤُمْسخَّارْ نّشْ!“، ؤُشَا إِخيّقْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","إِطّفْ إِ-ث سِيذِي ن يُوسُوفْ، إِڭَّا إِ-ث ذِي ڒحْبسْ، مَانِي ثُوغَا إِمحْبَاسْ ن ؤُجدْجِيذْ. أَمُّو إِ إِقِّيمْ ذِي ڒحْبسْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","مَاشَا سِيذِي ثُوغَا-ث أَكْ-ذ يُوسُوفْ ؤُشَا إِسّْوِيژّضْ غَارسْ س ثْمخْسِيوْثْ نّسْ إِشوَّارنْ ؤُشَا إِوْشَا أَسْ أَرْضَا نّسْ ذِي ثِيطَّاوِينْ ن ؤُمقّْرَانْ ن ڒحْبسْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ؤُشَا أَمقّْرَانْ ن ڒحْبسْ يَارَّا مَارَّا إِمحْبَاسْ نِّي ثُوغَا ذِي ڒحْبسْ سَاذُو ؤُفُوسْ ن يُوسُوفْ. مَارَّا مِينْ ثُوغَا تّڭّنْ ذِينْ ثُوغَا إِتّكّْ خْ ؤُفُوسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","أَمقّْرَانْ ن ڒحْبسْ وَارْ ذ أَسْ إِقِّيمْ مِينْ خفْ غَا إِنّهْوڒْ زِي مِينْ ثُوغَا سَاذُو ؤُفُوسْ نّسْ، مِينْزِي سِيذِي ثُوغَا أَكْ-ذ يُوسُوفْ. مِينْ مَا ثُوغَا إِتّڭّْ نتَّا، سِيذِي إِسّكّْوَاضْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","إِمْسَارْ أَوَارْنِي مَانْ أَيَا بلِّي أَوَارَّاذْ ن ؤُجدْجِيذْ ن مِيصْرَا ذ ؤُخبَّازْ ذنّْبنْ ضِيدّْ إِ سِيذِيثْسنْ، أَجدْجِيذْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","إِفُّوڭمْ فِيرْعُونْ خْ ثْنَاينْ ن إِمْسخَّارنْ إِشنّْعنْ نّسْ، خْ ؤُمقّْرَانْ ن إِوَارَّاذنْ ؤُ خْ ؤُمقّْرَانْ ن إِخبَّازنْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","إِڭَّا إِ-ثنْ ذڭْ ؤُحطُّو ذِي ثَادَّارْثْ ن ڒْقبْطَانْ ن إِعسَّاسنْ ن أَرِّيمثْ، ذِي ثَادَّارْثْ ن ثْعسَّاسْثْ، مَانِي إِحبّسْ يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ڒْقبْطَانْ ن إِعسَّاسنْ ن أَرِّيمثْ إِڭَّا يُوسُوفْ ذ أَمحْضَايْ نْسنْ، ؤُشَا نتَّا ثُوغَا إِتّْسخَّارْ خَاسنْ. أَمُّو ثُوغَا أَثنْ ؤُسَّانْ ذ إِزِيرَارنْ ذِي ڒحْبسْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ؤُرْجِينْ ثَارْجِيثْ س ثْنَاينْ إِذْسنْ نْسنْ، كُوڒْ إِجّنْ زَّايْسنْ يُورْجَا ذِي دْجِيڒثْ نِّي ثَارْجِيثْ نّسْ س ڒْمعْنَا نّسْ، أَمْ ؤُوَارَّاذْ أَمْ ؤُخبَّازْ ن ؤُجدْجِيذْ ن مِيصْرَا، إِنِّي ثُوغَا إِتّْوَاحبّْسنْ ذِي ثَادَّارْثْ ن ثْعسَّاسْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ؤُشَا يُوسَا-د غَارْسنْ يُوسُوفْ خْ صّْبحْ، إِخْزَارْ ذَايْسنْ ؤُشَا إِژْرَا إِ-ثنْ تّْقلّْقنْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ڒخْذنِّي إِسّقْسَا نتَّا إِمْسخَّارنْ إِشنّْعنْ ن فِيرْعُونْ، إِنِّي ثُوغَا أَكِيذسْ ذِي ڒحْبسْ ذِي ثَادَّارْثْ ن سِيذِيسْ، إِنَّا: ”مَاغَارْ بَارشْننْ ؤُذْمَاونْ نْومْ أَسّْ-أَ قَاعْ أَمُّو؟“ ");
INSERT INTO rifa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","نِيثْنِي نَّانْ: ”أَقَا نُورْجَا ثَارْجِيثْ، وَارْ ذَا وِي ت غَا إِفكّنْ.“ إِنَّا أَسنْ يُوسُوفْ: ”مَا وَارْ دْجِينْ شَا إِفسَّارنْ زِي أَربِّي؟ إِوَا، عَاوْذمْ أَيِي ثنْثْ ڒخُّو!“ ");
INSERT INTO rifa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","خنِّي إِعَاوذْ ؤُمقّْرَانْ ن إِوَارَّاذنْ ثَارْجِيثْ نّسْ إِ يُوسُوفْ، إِنَّا أَسْ: ”نشّْ ذِي ثَارْجِيثْ إِنُو ژْرِيغْ ثَازَايَارْثْ زَّاثِي ثْبدّْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ثَازَايَارْثْ نِّي غَارسْ ثْڒَاثَا ن ثْسضْوِينْ. خْمِي ثسّنْذِييْ، إِتّْڭعَّاذْ نُّووَّارْ نّسْ ؤُ غَارْ إِزكُّوننْ نّسْ إِبَانْ-د ڒْحبّْ ن ؤُضِيڒْ يِيوضْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ؤُشَا ڒْكَاسْ ن فِيرْعُونْ ثُوغَا-ث غَارِي ذڭْ ؤُفُوسْ إِنُو ؤُشَا كْسِيغْ أَضِيڒْ نِّي ؤُشَاعسَّارغْ ث ذِي ڒْكَاسْ ن فِيرْعُونْ ؤُشَا سّعْذُوغْ ڒْكَاسْ غَارْ ؤُفُوسْ ن فِيرْعُونْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","إِنَّا أَسْ يُوسُوفْ: ”ذ وَا ذ أَفسَّارْ نّسْ: ثْڒَاثَا ن ثِيسضْوِينْ، أَقَا ذ ثْڒَاثَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","عَاذْ ثْڒَاثَا ن وُوسَّانْ خنِّي أَذْ أَشْ إِسّْڭعّذْ فِيرْعُونْ أَزدْجِيفْ نّشْ ؤُشَا أَذْ شكْ يَارّْ غَارْ ثْسخَّارْثْ نّشْ، أَذْ ثسّعْذُوذْ ڒْكَاسْ إِ فِيرْعُونْ ذڭْ ؤُفُوسْ نّسْ، أَمْ مَامّشْ ثُوغَا ثَاسْغَارْثْ نّشْ زِيشْ ڒَامِي شكْ ثُوغَا ذ أَوَارَّاذْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","مَاشَا عْقڒْ خَافِي خْمِي ذ أَشْ د غَا يَاسْ ڒْخَارْ، تّْزَاوَاڭغْ شكْ أَذْ كِيذِي ثڭّذْ س ثْمخْسِيوْثْ إِشوَّارنْ ؤُشَا أجّْ فِيرْعُونْ أَذْ خَافِي إِعْقڒْ ؤُشَا فكّْ أَيِي-د زِي ثَادَّارْثْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","مِينْزِي ؤُشَارنْ أَيِي زِي ثمُّورْثْ ن إِعِيبْرَانِييّنْ ؤُ ذَا وَارْ ڭِّيغْ خْ مِينْ خفْ ذَايِي إِ غَا ڭّنْ ذڭْ وحْفُورْ ن إِمحْبَاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ڒَْامِي إِژْرَا ؤُمقّْرَانْ ن إِخبَّازنْ بلِّي إِفسَّارْ أَسْ مْلِيحْ، إِنَّا إِ يُوسُوفْ: ”ؤُڒَا ذ نشّْ ژْرِيغْ ذِي ثَارْجِيثْ إِنُو ثْڒَاثَا ن ثْسُودْجَاثِينْ س وغْرُومْ ذ أَشمْڒَاڒْ خْ ؤُزدْجِيفْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ذِي ثْسُودْجثْ ن سنّجْ ثُوغَا ذَايسْ أَطَّاسْ ن مَاشَّا إِ فِيرْعُونْ إِ إِڭَّا ؤُخبَّازْ ؤُ إِجْضَاضْ تّتّنْ زِي ثْسُودْجثْ إِ إِدْجَانْ خْ ؤُزدْجِيفْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","يَارَّا-د خَاسْ يُوسُوفْ، إِنَّا: ”ذ وَا ذ أَفسَّارْ نّسْ. ثْڒَاثَا ن ثْسُودْجَاثِينْ ذ ثْڒَاثَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","عَاذْ ثْڒَاثَا ن وُوسَّانْ خنِّي أَذْ خَاكْ إِسّْڭعّذْ فِيرْعُونْ أَزدْجِيفْ نّشْ جْمِيعْ أَكِيكْ ؤُشَا أَذْ شكْ يَايڒْ خْ إِشْثْ ن ثْشجَّارْثْ ؤُ إِجْضَاضْ أَذْ شّنْ أَيْسُومْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا، أَسّْ ن وخْڒَاقْ ن فِيرْعُونْ، إِمْسَارْ بلِّي إِسّوْجذْ إِشْثْ ن زَّارْذثْ إِ مَارَّا إِمْسخَّارنْ نّسْ ؤُشَا إِسّْڭعّذْ أَزدْجِيفْ ن ؤُمقّْرَانْ ن إِوَارَّاذنْ ؤُ أَزدْجِيفْ ن ؤُمقّْرَانْ ن إِخبَّازنْ ثُوغَا-ث جَارْ إِمْسخَّارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ؤُشَا نتَّا يَارَّا أَمقّْرَانْ ن إِوَارَّاذنْ غَارْ ڒْخذْمثْ نّسْ ن ؤُوَارَّاذْ، أَڒَامِي وَانِيثَا إِوْشَا عَاوذْ أَغَارَّافْ ذڭْ ؤُفُوسْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","مَاشَا أَمقّْرَانْ ن إِخبَّازنْ يُويڒْ إِ-ث، أَمْ مَامّشْ ذ أَسْ إِفسَّارْ يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","مَاشَا أَمقّْرَانْ ن إِوَارَّاذنْ وَارْ إِفكَّارْ شَا عَاذْ ذِي يُوسُوفْ، إِتُّو ث. ");
INSERT INTO rifa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","أَوَارْنِي ڒَامِي عْذُونْ ثْنَاينْ ن إِسڭّْوُوسَا يُورْجَا فِيرْعُونْ أَقَا نتَّا زعْمَا إِبدّْ خْ يغْزَارْ ن نِيلْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","خْزَارْ، ڭعّْذنْثْ-إِ-د سبْعَا ن ثْفُونَاسِينْ زڭْ إِغْزَارْ، صبْحنْثْ إِ ڒْخزْرَاثْ ؤُعمَّارنْثْ س ويْسُومْ، هدَّانْثْ جَارْ وحْثِيشْ ن ؤُغَانِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ؤُ خْزَارْ، سبْعَا ن ثْفُونَاسِينْ نّغْنِي ڭعّْذنْثْ-إِ-د أَوَارْنِي أَسنْثْ زڭْ إِغْزَارْ. نِيثنْثِي وَارْ حْڒِينْثْ إِ ڒْخزْرَاثْ، أَقَا كُّوشّْضنْثْ ؤُشَا بدّنْثْ زَّاثْ إِ ثْفُونَاسِينْ نّغْنِي غَارْ ثْمَا ن إِغْزَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ثِيفُونَاسِينْ إِ وَارْ إِحْڒِينْ إِ ڒْخژْرَاثْ، ثِينِّي إِكُوشّْضنْ، صَارْضنْثْ سبْعَا ن ثْفُونَاسِينْ إِصبْحنْ إِ ڒْخزْرَاثْ، ثِينِّي إِصحّنْ. ؤُشَا إِفَاقْ-د فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","إِطّصْ عَاوذْ ؤُشَا يُورْجَا ثْوَاڒَا نّغْنِي، ؤُ خْزَارْ، زڭْ إِشْثْ ن ثْسطَّا ڭعّْذنْثْ سبْعَا ن ثِيذْرِينْ شُّورنْثْ، شْنَانْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ؤُ خْزَارْ،غمْينْثْ-إِ-د سبْعَا ن ثِيذْرِينْ قُّوسْبَارنْ أَوَارْنِي أَسنْثْ، إِسّْشمْضْ إِ-ثنْثْ ؤُسمِّيضْ أَشَارْقِي. ");
INSERT INTO rifa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","سبْعَا ن ثِيذْرِينْ قُّوسْبَارنْثْ صَارْضنْثْ سبْعَا ن ثِيذْرِينْ إِيْمَانْ ذ إِشُّورنْ. ؤُشَا إِفَاقْ-د فِيرْعُونْ، ؤُ خْزَارْ، أَقَا ذ إِشْثْ ن ثرْجِيثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","غَارْ صّْبحْ إِبَانْ-د بلِّي بُوحْبڒْ نّسْ إِنّهْوڒْ ؤُشَا إِسّكّْ مَاحنْذْ أَذْ د-ڒَْاغَانْ إِ مَارَّا ثَارْوَا ن ثْسحَّارْثْ ن مِيصْرَا ؤُ إِ مَارَّا إِمِيغِيسنْ. إِعَاوْذْ أَسنْ فِيرْعُونْ ثَارْجِيثْ نّسْ، مَاشَا وَارْ ذِينْ ثُوغِي حذْ إِزمَّارْ أَذْ ت إِفسَّارْ إِ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","إِسِّيوڒْ  ؤُمقّْرَانْ ن إِوَارَّاذنْ أَكْ-ذ فِيرْعُونْ، إِنَّا: ”ذڭْ وَاسّْ-أَ أَذْ تّْوَاسْعقْڒغْ خْ دّْنُوبْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ؤُمِي إِفُّوڭمْ فِيرْعُونْ خْ إِمْسخَّارنْ نّسْ، إِڭَّا أَيِي ذِي ڒحْبسْ ذِي ثَادَّارْثْ ن ڒْقبْطَانْ ن إِعسَّاسنْ ن أَرِّيمثْ، أَمْ نشّْ أَمْ ؤُمقّْرَانْ ن إِخبَّازنْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","نشّْ ذ نتَّا نُورْجَا إِشْثْ ن ثَارْجِيثْ ذِي دْجِيرثْ ذ إِشْثْ. كُوڒْ إِجّْ زَّايْنغْ يُورْجَا ثَارْجِيثْ نّسْ س ڒْمعْنَا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ثُوغَا ذِينْ أَكِيذْنغْ إِجّْ ن ؤُبْڒِيغْ ذ أَعِيبْرَانِي. ثُوغَا-ث ذ أَمْسخَّارْ ن ڒْقبْطَانْ ن إِعسَّاسنْ ن أَرِّيمثْ. نْحَاجَا أَسْ ثِيرْجَا نّغْ ؤُشَا إِفسَّارْ أَنغْ ثنْثْ. إِ كُوڒْ إِجّْ زَّايْنغْ إِفسَّارْ أَسْ ثَارْجِيثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","أَمْ مَامّشْ ثنْثْ إِفسَّارْ، أَمنِّي إِ إِمْسَارْ. أَقَا فِيرْعُونْ يَارَّا أَيِي نشّْ غَارْ ڒْخذْمثْ إِنُو ؤُ ونّغْنِي يُويڒْ إِ-ث.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","إِسّكّْ فِيرْعُونْ حِيمَا أَذْ د-ڒَْاغَانْ خْ يُوسُوفْ ؤُشَا سُّوفّْغنْ ث-إِ-د ذغْيَا زڭْ وحْفُورْ ن إِمحْبَاسْ. إِحفّْ أَشُوَّافْ، إِبدّڒْ أَرُّوضْ ؤُشَا أَمُّو إِ يُوذفْ غَارْ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","إِنَّا فِيرْعُونْ إِ يُوسُوفْ: ”نشّْ ؤُرْجِيغْ إِشْثْ ن ثَارْجِيثْ، وَارْ إِدْجِي وِي ت غَا إِفسَّارنْ. مَاشَا أَقَا سْڒِيغْ خَاكْ بلِّي شكْ، خْمِي إِ غَا ثسْڒِيذْ إِ ثَارْجِيثْ، ثْزمَّارذْ أَذْ ت ثْفسَّارذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","يَارَّا-د يُوسُوفْ خْ فِيرْعُونْ، إِنَّا: ”وَارْ إِدْجِي شَا زَّايِي، مَاشَا أَربِّي أَذْ د-يَارّْ خْ مَامّشْ غَا إِذْوڒْ ؤُمدُّورْ ن فِيرْعُونْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","إِنَّا فِيرْعُونْ إِ يُوسُوفْ: ”ذِي ثَارْجِيثْ إِنُو ژْرِيغْ إِخفْ إِنُو بدّغْ خْ ثْمَا ن إِغْزَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","أَقَا ڭعّْذنْثْ-إِ-د سبْعَا ن ثْفُونَاسِينْ زڭْ إِغْزَارْ، صحّنْثْ ؤُ صبْحنْثْ إِ ڒْخزْرَاثْ، هدَّانْثْ جَارْ وحْثِيشْ ن ؤُغَانِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","أَوَارْنِي أَسنْثْ سبْعَا ن ثْفُونَاسِينْ نّغْنِي ڭعّْذنْثْ-إِ-د. ثُوغَا كُّوشّْضنْثْ ؤُ وَارْ حْڒِينْثْ ذڭْ وُوذمْ، ؤُژْغنْثْ. أَمُّو وَارْ حْڒِينْثْ،عمَّارْصْ وَارْ ثنْثْ ژْرِيغْ ذِي ثمُّورْثْ ن مِيصْرَا أَمْ ثكْمڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ثِيفُونَاسِينْ يُوژْغنْ، وَارْ إِحْڒِينْ، سَارْضنْثْ سبْعَا ن ثْينْذُوزِينْ ثِيمزْوُورَا إِصحّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ؤُمِي ؤُذْفنْثْ ثِينَا ذڭْ ؤُعذِّيسْ نْسنْثْ، عَاذْ وَارْ إِسِّينْ حذْ، بلِّي أَقَا ؤُذْفنْثْ ذڭْ ؤُعذِّيسْ نْسنْثْ، أَقَا قِّيمنْثْ وَارْ حْڒِينْثْ إِ ڒْخزْرَاثْ أَمْ قْبڒْ. خنِّي فَاقغْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","عَاوذْ ژْرِيغْ ذِي ثَارْجِيثْ إِنُو، خْزَارْ، زڭْ إِشْثْ ن ثْسطَّا فّْغنْثْ-إِ-د سبْعَا ن ثِيذْرِينْ شُّورنْثْ ؤُ شْنَانْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","خْزَارْ، ژْرِيغْ، ڭعّْذنْثْ-إِ-د سبْعَا ن ثِيذْرِينْ قُّوسْبَارنْثْ، ؤُژْغنْثْ، إِسّْشمْضْ إِ-ثنْثْ ؤُسمِّيضْ أَشَارْقِي. ");
INSERT INTO rifa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ؤُ سبْعَا ن ثِيذْرِينْ يُوژْغنْ، صَارْضنْثْ سبْعَا ن ثِيذْرِينْ نِّي إِشْنَانْ. نِّيغْ ثَارْجِيثْ إِ ثَارْوَا ن ثْسحَّارْثْ، مَاشَا وَارْ ذِينْ ثُوغِي حذْ إِ إِزمَّارنْ أَذْ إِفسَّارْ ثَارْجِيثْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","خنِّي إِنَّا يُوسُوفْ إِ فِيرْعُونْ: ”ثَارْجِيثْ ن فِيرْعُونْ ذ إِشْثْ. أَربِّي إِبيّنْ إِ فِيرْعُونْ مِينْ إِ غَا يڭّْ نتَّا. ");
INSERT INTO rifa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","سبْعَا ن ثْفُونَاسِينْ شْنَانْثْ أَقَا أَثنْثْ ذ سبْعَا ن إِسڭّْوُوسَا. ؤُشَا ثِيذْرِينْ شْنَانْثْ أَقَا ذ سبْعَا ن إِسڭّْوُوسَا. ذ ثَارْجِيثْ ذ إِشْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","سبْعَا ن ثْفُونَاسِينْ ؤُژْغنْثْ وَارْ إِحْڒِينْ ثِينِّي د-يُوڒْينْ أَوَارْنِي أَسنْثْ، أَقَا ذ سبْعَا ن إِسڭّْوُوسَا، ؤُ سبْعَا ن ثِيذْرِينْ قُّوسْبَارنْثْ، ثِينِّي إِسّْشمْضْ ؤُسمِّيضْ أَشَارْقِي، أَقَا أَثنْثْ ذ سبْعَا ن إِسڭّْوُوسَا إِ ذِي غَا يِيڒِي ڒَاژْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ذ وَا ذ أَوَاڒْ إِ نِّيغْ إِ فِيرْعُونْ. مِينْ غَا يڭّْ أَربِّي، أَقَا إِسّْشنْ إِ-ث إِ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","خْزَارْ، ذِي سبْعَا ن إِسڭّْوُوسَا إِ د-إِڭُّورنْ أَذْ ثِيڒِي ثْيَاوَانْثْ ثَامقّْرَانْثْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","أَوَارْنِي أَسنْ أَذْ د-أَسنْ سبْعَا ن إِسڭّْوُوسَا ن ڒَاژْ. ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا أَذْ تُّونْ مَارَّا ثْيَاوَانْثْ ؤُشَا ڒَاژْ أَذْ إِثحَّا ثَامُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ؤُشَا ثْيَاوَانْثْ وَارْ ثتِّيڒِي ثتّْوَاسّنْ عَاذْ زِي سِّيبّثْ ن ڒَاژْ إِ ت-إِ-د-إِضْفَارنْ، مَاغَارْ ڒْحَاڒْ أَذْ يِيڒِي إِقْسحْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","عْلَاحْسَابْ طّْبِيعثْ ن ثْنَاينْ ن وُوذْمَاونْ ن ثَارْجِيثْ ن فِيرْعُونْ، أَقَا ثْنَاينْ ن ثْسقَّارْ، أَقَا مَانْ أَيَا س مِينْزِي يُورَا ت أَربِّي نِيشَانْ ؤُ أَربِّي أَقَا أَذْ ت يڭّْ ذغْيَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","أجّْ فِيرْعُونْ ڒخُّو أَذْ يَارْزُو خْ إِجّْ ن ورْيَازْ س ڒفْهَامثْ ذ ثِيغِيثْ، مَاحنْذْ أَذْ ث إِڭّْ خْ ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","أجّْ فِيرْعُونْ أَذْ إِڭّْ أَمُّو: أجّْ إِ-ث أَذْ إِڭّْ إِوقَّافنْ خْ ثمُّورْثْ، مَاحنْذْ أَذْ كْسِينْ ڒخْمُوسْ ن ڒْغِيدْجثْ ن ثمُّورْثْ ن مِيصْرَا ذِي سبْعَا ن إِسڭّْوُوسَا ن ثْيَاوَانْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","أجّْ إِ-ثنْ أَذْ سّْمُوننْ مَارَّا ڒعْوتْشْ ذڭْ إِسڭّْوُوسَا إِصبْحنْ إِ د غَا يَاسنْ ؤُشَا أَذْ خمّْڒنْ ڒْحبّْ ن يِيرْذنْ سَاذُو ؤُفُوسْ ن فِيرْعُونْ، مَاحنْذْ أَذْ ث خمّْڒنْ ذ مَاشَّا ذِي ثْندَّامْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","أَذْ يِيڒِي ذ ڒخْزنْ ن مَاشَّا إِ ثمُّورْثْ إِ سبْعَا ن إِسڭّْوُوسَا ن ڒَاژْ نِّي د غَا إِوْضَانْ خْ ثمُّورْثْ ن مِيصْرَا، حِيمَا ثَامُّورْثْ وَارْ ثتّْمتِّي شَا س ڒَاژْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","أَوَاڒنْ-أَ بَاننْ-د ذ لمْلِيحْ إِ فِيرْعُونْ ذ مَارَّا إِمْسخَّارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","خنِّي إِنَّا فِيرْعُونْ إِ إِمْسخَّارنْ نّسْ: ”مَا إِزمَّارْ أَذْ إِتّْوَافْ شَا ن ورْيَازْ أَمْ وَا إِ ذِي إِزدّغْ أَرُّوحْ ن أَربِّي؟“ ");
INSERT INTO rifa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ؤُشَا إِنَّا فِيرْعُونْ إِ يُوسُوفْ: ”ؤُمِي أَربِّي إِمّڒْ أَشْ-د مَارَّا أَيَا، خْ ؤُيَا وَارْ ذِينْ يدْجِي ونِّي غَارْ ثدْجَا ڒفْهَامثْ ذ ثِيغِيثْ أَمْ شكْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","شكْ أَذْ ثِيڒِيذْ خْ ثَادَّارْثْ إِنُو ؤُ إِ وَاوَاڒْ نّشْ أَذْ إِطَاعْ ڒْڭنْسْ إِنُو مَارَّا. مْغِيرْ خْ ڒْعَارْشْ وَاهَا أَذْ إِڒِيغْ نشّْ ذ أَمقّْرَانْ خَاكْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","يَارْنِي إِنَّا فِيرْعُونْ إِ يُوسُوفْ: ”خْزَارْ، ڭِّيغْ شكْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ؤُشَا إِكّسْ فِيرْعُونْ ثَاخَاذنْثْ نّسْ زڭْ ؤُفُوسْ نّسْ، إِڭَّا إِ-ت ذڭْ ؤُفُوسْ ن يُوسُوفْ ؤُشَا إِسّْيَارْضْ أَسْ أَرُّوضْ ن ڒقْطنْ أَزْذَاذْ ؤُشَا إِڭَّا أَسْ ثَاسدّشْثْ ن وُورغْ ذڭْ يِيرِي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","إِسّنْيَا إِ-ث ذِي ثْكَارُّوثْ وِيسّْ ثْنَاينْ إِ ثُوغَا غَارسْ ؤُشَا ڒَاغَانْ أَمْ ڭُّورنْ زَّاثسْ: ”قوْسْ!“ أَمُّو إِ ث إِڭَّا خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","إِنَّا فِيرْعُونْ إِ يُوسُوفْ: ”نشّْ ذ فِيرْعُونْ، بْڒَا شكْ ؤُڒَا ذ إِجّْ أَذْ إِڭعّذْ أَفُوسْ نّسْ نِيغْ أَضَارْ نّسْ ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","إِڒَاغَا فِيرْعُونْ إِ يُوسُوفْ س يِيسمْ ن صَافْنَاثْ-فَاعْنِيحْ ؤُشَا إِوْشَا أَسْ أَسْنَاثْ ذ ثَامْغَارْثْ، ثنِّي ذ يدْجِيسْ ن فُوثِي-فَارَاعْ، أَكهَّانْ ن ؤُنْ. ؤُشَا إِجُوڒْ يُوسُوفْ ذِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ثُوغَا يُوسُوفْ ذ مِّيسْ ن ثْڒَاثِينْ ن إِسڭّْوُوسَا ڒَامِي إِبدّْ نتَّا زَّاثْ إِ فِيرْعُونْ، أَجدْجِيذْ ن مِيصْرَا، ؤُشَا إِفّغْ يُوسُوفْ زَّاثْ إِ فِيرْعُونْ ؤُشَا إِجُوڒْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ؤُشَا ثسّغْمِي-د ثمُّورْثْ ذِي سبْعَا ن إِسڭّْوُوسَا س ثْيَاوَانْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","إِسّْمُونْ مَارَّا مَاشَّا ن سبْعَا ن إِسڭّْوُوسَا ن ثْيَاوَانْثْ، إِنِّي ثُوغَا ذِي ثمُّورْثْ ن مِيصْرَا، ؤُشَا إِخمّڒْ مَاشَّا ذِي ثْندَّامْ. مَاشَّا ن إِيَّارنْ إِ ذ أَسْ د-إِنّْضنْ إِ كُوڒْ ثَانْذِينْثْ، إِخمّڒْ إِ-ت ذَايسْ ذَاخڒْ ذِي ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","يُوسُوفْ إِخمّڒْ ڒْحبّْ ن إِرْذنْ أَطَّاسْ، أَنشْثْ ن إِجْذِي ن ڒبْحَارْ، أَڒَامِي وَارْ إِزمَّارْ أَذْ إِتّْوَاحْسبْ، مِينْزِي ثُوغَا-ث بْڒَا ڒحْسَابْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","قْبڒْ إِ د-يُوسَا ؤُسڭّْوَاسْ أَمزْوَارُو ن ڒَاژْ، مَّارنْينْ-د غَارْ يُوسُوفْ ثْنَاينْ ن إِحنْجِيرنْ، إِنِّي ذ أَسْ د-ثُورُووْ أَسْنَاثْ، يدْجِيسْ ن فُوثِي-فَارَاعْ، أَكهَّانْ ن ؤُنْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","إِسمَّا يُوسُوفْ أَمنْزُو مَانَاسَّا، مِينْزِي إِنَّا: ”أَربِّي أَقَا إِسّتُّو أَيِي مَارَّا ثَامَارَا إِنُو ذ مَارَّا ثَادَّارْثْ ن بَابَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","وِيسّْ ثْنَاينْ إِسمَّا إِ-ث إِفْرَايِيمْ، مِينْزِي إِنَّا: ”أَربِّي إِڭَّا أَيِي س ڒْغِيدْجثْ ذِي ثمُّورْثْ ن ڒحْصَارثْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","خنِّي كمّْڒنْ سبْعَا ن إِسڭّْوُوسَا ن ؤُفيّضْ ن ڒْغِيدْجثْ نِّي إِكِّينْ خْ ثمُّورْثْ ن مِيصْرَا، ");
INSERT INTO rifa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ؤُشَا بْذَانْ أَذْ د-أَسنْ سبْعَا ن إِسڭّْوُوسَا ن ڒَاژْ، أَمْ مَامّشْ خَاسْ إِسِّيوڒْ يُوسُوفْ. ثُوغَا ڒَاژْ ذِي مَارَّا ثِيمُّورَا، مَاشَا ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا ثُوغَا ذَايسْ عَاذْ أَغْرُومْ. ");
INSERT INTO rifa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","أَڒَامِي ثُوغَا ڒَاژْ ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا، إِسْغُويْ ڒْڭنْسْ غَارْ فِيرْعُونْ خْ وغْرُومْ. ؤُشَا إِنَّا فِيرْعُونْ إِ مَارَّا إِمِيصْرِييّنْ: ”رُوحمْ غَارْ يُوسُوفْ، ڭّمْ مِينْ ذ أَومْ غَا يِينِي!“ ");
INSERT INTO rifa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ثُوغَا ڒَاژْ إِزدْجعْ خْ مَارَّا ثَامُّورْثْ ؤُشَا يَارْزمْ يُوسُوفْ خْ مَارَّا مِينْ ثُوغَا إِخمّڒْ، ؤُشَا إِزّنْزْ إِ-ث إِ إِمِيصْرِييّنْ، مِينْزِي ثُوغَا ڒَاژْ إِذْوڒْ إِمْغَارْ أَطَّاسْ ذِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","زِي مَارَّا ثِيمُّورَا ؤُسِينْ-د إِوْذَانْ غَارْ مِيصْرَا غَارْ يُوسُوفْ حِيمَا أَذْ سْغنْ، مِينْزِي ذِي مَارَّا ثِيمُّورَا ثُوغَا ڒَاژْ إِمْغَارْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ڒَْامِي إِژْرَا يَاعْقُوبْ بلِّي أَقَا ذِينْ ڒْحبّْ ن يِيرْذنْ ذِي مِيصْرَا، خنِّي إِنَّا إِ إِحنْجِيرنْ نّسْ ”مَاغَارْ ثقِّيممْ ثْخزَّارمْ إِجّنْ ذڭْ ونّغْنِي؟“ ");
INSERT INTO rifa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","إِنَّا: ”أَقَا نشّْ سْڒِيغْ بلِّي ذِينْ إِمنْذِي ذِي مِيصْرَا. رُوحمْ ذِينِّي ؤُشَا سْغمْ أَنغْ-د سّنِّي ڒْْحبّْ، حِيمَا أَذْ نقِّيمْ ندَّارْ ؤُشَا وَارْ نتّْمتِّي شَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","هْوَانْعشْرَا ن وَاوْمَاثنْ ن يُوسُوفْ، مَاحنْذْ أَذْ رَاحنْ أَذْ سْغنْ إِمنْذِي زِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","مَاشَا يَاعْقُوبْ وَارْ إِسّكّْ بِينْيَامِينْ، ؤُمَاسْ ن يُوسُوفْ، أَكْ-ذ أَيْثْمَاسْ، مِينْزِي إِنَّا: ”حِيمَا وَارْ ذ أَسْ إِتّمْسَارْ شَا ن ڒْحَاجّثْ ذ ثَاعفَّانْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","جَارْ إِنِّي د-يُوسِينْ ذِينِّي، ؤُسِينْ-د عَاوذْ أَيْثْ ن إِسْرَائِيل، مَاحنْذْ أَذْ سْغنْ مَاشَّا، مِينْزِي ثُوغَا ذِينْ ڒَاژْ ذِي ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ثُوغَا يُوسُوفْ ذ ڒْحَاكمْ خْ ثمُّورْثْ ؤُشَا إِزّنْزْ إِمنْذِي إِ مَارَّا ڒْڭنْسْ ن ثمُّورْثْ. ؤُمِي د-إِوْضنْ أَيْثْمَاسْ ن يُوسُوفْ، بنْذْقنْ أَسْ س ؤُغمْبُوبْ نْسنْ غَارْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ؤُمِي إِژْرَا يُوسُوفْ أَيْثْمَاسْ، إِعْقڒْ إِ-ثنْ، مَاشَا إِڭَّا إِخفْ نّسْ أَخْمِي وَارْ ثنْ إِسِّينْ ؤُشَا إِسِّيوڒْ أَكِيذْسنْ س ڒقْسَاحثْ، إِنَّا أَسنْ: ”مَانِيسْ د-ثُوسِيمْ؟“ نَّانْ: ”زِي ثمُّورْثْ ن كنْعَانْ، مَاحنْذْ أَذْ نْسغْ مَاشَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","يُوسُوفْ إِعقْڒْ أَيْثْمَاسْ، مَاشَا نِيثْنِي وَارْ ث عْقِيڒنْ شَا. ");
INSERT INTO rifa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","إِفكَّارْ يُوسُوفْ ذِي ثِيرْجَا نِّي ثُوغَا خَاسنْ يُورْجَا، إِنَّا أَسنْ: ”كنِّيوْ ذ إِبرْڭَاڭنْ إِ ثدْجَامْ، ثُوسِيمْ-د، حِيمَا أَذْ ثْژَارمْ مَانِي وَارْ ثتّْوَاحْضِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","أَرِّينْ-د خَاسْ: ”لَّ، أَ سِيذِي إِنُو، عَاذْ إِمْسخَّارنْ نّشْ ؤُسِينْ-د، مَاحنْذْ أَذْ سْغنْ مَاشَّا. ");
INSERT INTO rifa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","مَارَّا نشِّينْ أَقَا أَنغْ ذ ثَارْوَا ن إِجّْ ن ورْيَازْ. أَقَا أَنغْ ذ إِرْيَازنْ ذ إِمْثِيقَّانْ، إِمْسخَّارنْ نّشْ وَارْ دْجِينْ شَا ذ إِبرْڭَاڭنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","نتَّا يَارَّا-د خَاسنْ: ”لَّ، كنِّيوْ ثُوسِيمْ-د مَاحنْذْ أَذْ ثْژَارمْ ثُوعَّارْينْثْ ن ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","نَّانْ نِيثْنِي: ”نشِّينْ ذ إِمْسخَّارنْ نّشْ، أَقَا أَنغْ ذِي ثنْعَاشْ ن وَاوْمَاثنْ، ثَارْوَا ن إِجّْ ن ورْيَازْ ذِي ثمُّورْثْ ن كنْعَانْ. أَقَا أَمَاژُوژْ أَقَا-ث أَكْ-ذ بَابَاثْنغْ ؤُ ونّغْنِي وَارْ إِدْجِي عَاذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","إِنَّا أَسنْ يُوسُوفْ: ”مَا وَارْ ذ أَومْ ث نِّيغْ ؤُمِي نِّيغْ: ’أَقَا كنِّيوْ ذ إِبرْڭَاڭنْ!‘ ");
INSERT INTO rifa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","س ؤُيَا ثتّْوَاقدْجْبمْ. س ثِيذتّْ أَمْ إِدَّارْ فِيرْعُونْ، كنِّيوْ وَارْ د-تّفّْغمْ سَّا، مْغِيرْ خْمِي د غَا يَاسْ ؤُمَاثْومْ أَمَاژُوژْ ذَانِيثَا! ");
INSERT INTO rifa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","سكّمْ إِجّْ ن زَّايْومْ، مَاحنْذْ أَذْ د-يَاوِي ؤُمَاثْومْ. خنِّي كنِّيوْ أَذْ ثتّْوَاحبّْسمْ ؤُشَا أَوَاڒنْ نْومْ أَذْ تّْوَاقدْجْبنْ، مَا ذَايْومْ ڒَامَانْ. مَاڒَا لَّا، س ثِيذتّْ أَمْ إِدَّارْ فِيرْعُونْ، أَقَا كنِّيوْ ذ إِبرْڭَاڭنْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ؤُشَا إِڭَّا إِ-ثنْ ثْڒَاثَا ن وُوسَّانْ ذِي ڒحْبسْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا إِنَّا أَسنْ يُوسُوفْ: ”ڭّمْ أَيَا، حِيمَا أَذْ ثقِّيممْ ثدَّارمْ، نشّْ تّڭّْوْذغْ أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","مَاڒَا كنِّيوْ ذ إِرْيَازنْ ذ إِمْثِيقَّانْ، جّمْ خنِّي إِجّْ ن ؤُمَاثْومْ أَذْ إِقِّيمْ إِشَارْفْ ذِي ثَادَّارْثْ مَانِي ثتّْوَاحبّْسمْ كنِّيوْ، خنِّي رُوحمْ، كْسِيمْ إِمنْذِي إِ ڒَاژْ ن أَيْثْبَابْ ن ثَادَّارْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","أَوْيمْ-د خنِّي ؤُمَاثْومْ، أَمَاژُوژْ، مَاحنْذْ أَذْ تّْوَاقدْجْبنْ وَاوَاڒنْ نْومْ، وَارْ ثتّْمتِّيمْ شَا.“ ؤُشَا نِيثْنِي ڭِّينْ أَمنِّي. ");
INSERT INTO rifa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","نَّانْ إِ وَايَاوْيَا: ”س ثِيذتّْ أَقَا إِتّْخصَّا أَنغْ أَذْ د-نَارّْ دّيّثْ ن ؤُمَاثْنغْ، أَقَا نژْرَا ڒْحصْرَانْ ن ڒعْمَارْ نّسْ ؤُمِي ذ أَنغْ إِتَّارْ أَحِينِّي، مَاشَا وَارْ ذ أَسْ نسْڒِي شَا! خْ ؤُيَا د-يُوسَا ڒْحصْرَانْ-أَ خَانغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","يَارَّا-د خَاسنْ رُوبِينْ، إِنَّا: ”مَا وَارْ ذ أَومْ ث نِّيغْ، ؤُمِي نِّيغْ: ’وَارْ خطِّيمْ شَا أَكْ-ذ ؤُحنْجِيرْ!‘، مَاشَا كنِّيوْ وَارْ ثسْڒِيمْ شَا. خْزَارْ، إِذَامّنْ نّسْ تّْوَاتَّارنْ ڒخُّو!“ ");
INSERT INTO rifa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","نِيثْنِي وَارْ سِّيننْ بلِّي إِفْهمْ أَسنْ يُوسُوفْ، مِينْزِي ثُوغَا أَثُورْجْمَانْ جَارْ أَسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","إِنّقْڒبْ خَاسنْ ؤُشَا إِسْغُويْ. أَوَارْنِي أَسْ إِنّقْڒبْ-د عَاوذْ غَارْسنْ، إِسِّيوڒْ أَكِيذْسنْ، إِكْسِي زَّايْسنْ شِيمْعُونْ ؤُشَا إِحبّسْ إِ-ث زَّاثْ إِ ثِيطَّاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","يُومُورْ يُوسُوفْ مَاحنْذْ أَذْ شُّورنْ ثِيخُونْشَايْ نْسنْ س إِمنْذِي ؤُ أَذْ ڭّنْ ثْمنْيَاثْ ن نُّوقَارْثْ ذِي كُوڒْ إِشْثْ ن ثْخَانْشثْ نْسنْ ؤُشَا وْشِينْ أَسنْ مَاشَّا إِ وبْرِيذْ. ؤُ أَمُّو إِ كِيذْسنْ ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","سَّارْبُونْ إِمنْذِي نْسنْ خْ يغْيَاڒْ نْسنْ ؤُشَا فّْغنْ سّنِّي. ");
INSERT INTO rifa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ؤُمِي يَارْزمْ إِجّنْ زَّايْسنْ ثَاخَانْشثْ نّسْ، حِيمَا أَذْ إِسّشّْ أَغْيُوڒْ نّسْ غَارْ مَانِي غَا سّنْسنْ، إِژْرَا نُّوقَارْثْ نّسْ ذڭْ أَرْزَامْ ن ؤُقمُّومْ ن ثْخَانْشثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","إِنَّا إِ يَايْثْمَاسْ: ”نُّوقَارْثْ إِنُو ثذْوڒْ أَيِي-د. خْزَارْ، أَقَا-ت ذَا ذِي ثْخَانْشثْ إِنُو!“ ڒخْذنِّي إِبدّْ أَسنْ وُوڒْ، أَرْجِيجنْ ؤُشَا نَّانْ إِ وَايَاوْيَا: ”مَانَاوْيَا إِ ذ أَنغْ إِتّڭّْ أَربِّي؟“ ");
INSERT INTO rifa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ؤُشَا رحّْڭنْ غَارْ بَابَاثْسنْ يَاعْقُوبْ ذِي ثمُّورْثْ ن كنْعَانْ ؤُشَا عَاوْذنْ أَسْ مَارَّا مِينْ خَاسنْ إِكِّينْ، نَّانْ: ");
INSERT INTO rifa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","”أَرْيَازْ، بَابْ ن ثمُّورْثْ، إِسِّيوڒْ أَكِيذْنغْ س ڒقْسَاحثْ، إِحسْبْ أَنغْ ذ إِبرْڭَاڭنْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","مَاشَا ننَّا أَسْ: ’نشِّينْ ذ إِرْيَازنْ ذ إِمْثِيقَّانْ، عمَّارْصْ وَارْ ندْجِي ذ إِبرْڭَاڭنْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","أَقَا أَنغْ ذِي ثنْعَاشْ ن وَاوْمَاثنْ، إِحنْجِيرنْ ن بَابَاثْنغْ. إِجّنْ وَارْ إِقِّيمْ، أَمَاژُوژْ أَقَا-ث أَسّْ-أَ أَكْ-ذ بَابَاثْنغْ ذِي ثمُّورْثْ ن كنْعَانْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ؤُ أَرْيَازْ نِّي، بَابْ ن ثمُّورْثْ، إِنَّا أَنغْ: ’س ؤُيَا أَذْ سّْنغْ، مَا أَقَا كنِّيوْ ذ إِمْثِيقَّانْ. أَذْ كِيذِي ثجّمْ إِجّنْ زڭْ أَيْثْمَاثْومْ ؤُشَا أَذْ ثكْسِيمْ مَاشَّا إِ ڒَاژْ نِّي ذِينْ غَارْ أَيْثْبَابْ ن ثَادَّارْثْ نْومْ، خنِّي فّْغمْ. ");
INSERT INTO rifa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","أَوْيمْ-د ذَا ؤُمَاثْومْ، أَمَاژُوژْ، خنِّي أَذْ سّْنغْ بلِّي وَارْ ثدْجِيمْ ذ إِبرْڭَاڭنْ، مَاشَا ذ إِمْثِيقَّانْ ؤُشَا أَذْ أَومْ د-أَرْخُوغْ إِ وَامَاثْومْ نْومْ ؤُشَا أَذْ ثْرَاحمْ أَذْ ثْجُوڒمْ ذِي ثمُّورْثْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ؤُمِي سّخْوَانْ ثِيخُونْشَايْ نْسنْ، حكَّارنْ بلِّي ذِي ثْخَانْشثْ ن كُوڒْ إِجّنْ، أَقَا ذَايسْ ثَاشْيَارْثْ س نُّوقَارْثْ نّسْ. ژْرِينْ نِيثْنِي ذ بَابَاثْسنْ ثِيشْيَارْ س نُّوقَارْثْ نْسنْ ؤُشَا ثُوذفْ إِ-ثنْ ثِيڭّْوُوذِي. ");
INSERT INTO rifa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","إِنَّا أَسنْ بَابَاثْسنْ يَاعْقُوبْ: ”أَقَا ثْحَارّْممْ أَيِي زڭْ إِحنْجِيرنْ إِنُو! يُوسُوفْ وَارْ د-إِضْهَارْ عَاذْ ؤُڒَا ذ شِيمْعُونْ، ؤُشَا ڒخُّو ثتّخْسمْ أَذْ ثْنذْهمْ بِينْيَامِينْ. مَارَّا مَانْ أَيَا إِتّمْسَارنْ ذِي ڒعْكسْ إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","خنِّي إِسِّيوڒْ رُوبِينْ غَارْ بَابَاسْ، إِنَّا: ”أَذْ ثنْغذْ ثْنَاينْ ن إِحنْجِيرنْ إِنُو، مَاڒَا وَارْ ذ أَشْ ث-إِ-د-أَرِّيغْ. أوْشْ أَيِي ث ذڭْ ؤُفُوسْ إِنُو، نشّْ أَقَا أَذْ أَشْ ث-إِ-د-أَرّغْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","مَاشَا نتَّا إِنَّا أَسْ: ”مِّي وَارْ إِتّْرِيحْ شَا أَكِيذْومْ، مِينْزِي ؤُمَاسْ إِمُّوثْ ؤُ نتَّا وحّْذسْ إِ ذ أَيِي إِقِّيمنْ. مَاڒَا إِڒْقفْ إِ-ث شَا ن ڒْغَارْ ذڭْ وبْرِيذْ نِّي إِ غَا ثكّمْ، أَذْ ثسّهْوَامْ شِّيبْ إِنُو س وشْضَانْ غَارْ ڒَاخَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","مَاشَا ڒَاژْ ثُوغَا إِمْغَارْ أَطَّاسْ ذِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ڒَْامِي كمّْڒنْ شِّينْ ڒْحبّْ ن يِيرْذنْ نِّي كِيذْسنْ د-إِوْينْ زِي مِيصْرَا، إِنَّا أَسنْ بَابَاثْسنْ: ”ذوْڒمْ-د عَاوذْ ؤُشَا سْغمْ أَنغْ-د شْوَايْثْ ن مَاشَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","خنِّي إِسِّيوڒْ يَاهُوذَا، إِنَّا: ”أَقَا أَرْيَازْ نِّي إِنَّا أَنغْ س ؤُركّزْ: ”وَارْ ثْژَارّمْ عَاذْ ؤُذمْ إِنُو، مْغِيرْ مَاڒَا ثِيوْيمْ-د ؤُمَاثْومْ أَكِيذْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","مَاڒَا ثسّكّذْ ؤُمَاثْنغْ أَكِيذْنغْ، أَذْ نْرَاحْ ذِينْ ؤُشَا أَذْ أَشْ د-نْسغْ مَاشَّا، ");
INSERT INTO rifa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","مَاشَا مَاڒَا وَارْ ث ثسّكِّيذْ أَكِيذْنغْ، خنِّي وَارْ ذِينِّي نتّْرَاحْ، مِينْزِي أَرْيَازْ نِّي إِنَّا أَنغْ: ’وَارْ ثْژَارّمْ عَاذْ ؤُذمْ إِنُو مْغِيرْ مَاڒَا يُوسَا-د ؤُمَاثْومْ أَكِيذْومْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","إِنَّا إِسْرَائِيل: ”مَاغَارْ ذ أَيِي ثڭِّيمْ ڒْغَارْ ؤُشَا ثنَّامْ إِ ورْيَازْ نِّي بلِّي أَقَا غَارْومْ عَاذْ ؤُمَاثْومْ نّغْنِي؟“ ");
INSERT INTO rifa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","نِيثْنِي نَّانْ: ”أَرْيَازْ نِّي إِسّقْسَا خَانغْ نِيشَانْ، ؤُ خْ ثمُّورْثْ مَانِي نخْڒقْ، إِنَّا: ’مَا إِدَّارْ عَاذْ بَابَاثْومْ؟ مَا غَارْومْ شَا ن ؤُمَاثْومْ نّغْنِي؟‘ خنِّي نْعَاوذْ أَسْ ث. مَا نْزمَّارْ زڭْ وَاوَاڒنْ-أَ أَذْ د-نجْبذْ إِلَّا أَذْ نسّنْ زعْمَا أَذْ يِينِي: ’أَوْيمْ-د ؤُمَاثْومْ؟‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ؤُشَا إِنَّا يَاهُوذَا إِ بَابَاسْ إِسْرَائِيل: ”سكّْ أَكِيذِي أَحنْجِيرْ ؤُشَا أَذْ نكَّارْ أَذْ نْرَاحْ، حِيمَا أَذْ ندَّارْ ؤُ وَارْ نتّْمتِّي شَا نشِّينْ ذ شكْ ذ ثَارْوَا نّغْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","نشّْ أَذْ أَسْ إِڒِيغْ ذ أَضْمَانْ ؤُ زڭْ ؤُفُوسْ إِنُو أَذْ ث ثتَّارذْ عَاوذْ. مَاڒَا وَارْ ذ أَشْ ث-إِ-د-أَرِّيغْ، أَذْ ث سّْبدّغْ زَّاثكْ، أَذْ يِيڒِي خْضِيغْ أَكِيذكْ إِ ڒبْذَا! ");
INSERT INTO rifa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","معْلِيكْ وَارْ نقِّيمْ نتّْرَاجَا أَطَّاسْ، ثِيڒِي ڒخُّو نذْوڒْ-د ثْنَاينْ ن ثْوَاڒَاوِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ؤُشَا يَارَّا-د خَاسنْ إِسْرَائِيل، بَابَاثْسنْ: ”مَاڒَا أَمُّو إِ يدْجَا س ثِيذتّْ، ڭّمْ أَمُّو ؤُشَا كْسِيمْ مِينْ إِشْنَانْ أَطَّاسْ ن ثمُّورْثْ ذِي ثْخُونْشَايْ نْومْ، هْوَامْ-د مَاحنْذْ أَذْ ث ثِيوْيمْ ذ أَرِّيغَالُو إِ ورْيَازْ نِّي: شْوَايْثْ ن بَالْسَامْ ذ شْوَايْثْ ن ثَامّنْثْ، ڒعْطُورْ ذ مِيرُّو ذ ثغْيَاشْثْ ن پِيسْثَاشْ ذ دْجُوزْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","كْسِيمْ ثْنَاينْ ن ثْسقَّارْ ن ثنْعَاشِينْ ن نُّوقَارْثْ أَكِيذْومْ ؤُشَا أَرّمْ س ؤُفُوسْ نْومْ نُّوقَارْثْ إِ د-إِعقْبنْ ذِي ثْخُونْشَايْ نْومْ. أَذْ ثَاغْ ثُوغَا ذ شَا ن لْغَالَاطْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","أَوْيمْ-د عَاوذْ ؤُمَاثْومْ أَكِيذْومْ، كَّارمْ،عقْبمْ غَارْ ورْيَازْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ؤُشَا أَقَا أَربِّي، أَمْزمَّارْ خْ كُوڒْشِي، أَذْ أَومْ إِوْشْ أَرّحْمثْ زَّاثْ إِ وُوذمْ ن ورْيَازْ نِّي ؤُشَا أَذْ يَارْخُو إِ ؤُمَاثْومْ نّغْنِي ذ بِينْيَامِينْ. ؤُ مِينْ ذ أَيِي إِقِّيمنْ نشّْ، مَاڒَا تّْوَاحَارّْمغْ زڭْ إِحنْجِيرنْ إِنُو، أَقَا أَذْ زَّايْسنْ تّْوَاحَارّْمغْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","خنِّي إِوْينْ إِرْيَازنْ أَرِّيغَالُو ؤُشَا كْسِينْ ذڭْ ؤُفُوسْ نْسنْ ثْنَاينْ ن ثْسقَّارْ ن ثْمنْيَاثْ ن نُّوقَارْثْ ؤُڒَا ذ بِينْيَامِينْ ؤُشَا كَّارنْ، هْوَانْ غَارْ مِيصْرَا ؤُشَا بدّنْ زَّاثْ إِ وُوذمْ ن يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ؤُمِي إِژْرَا يُوسُوفْ بِينْيَامِينْ أَكِيذْسنْ، إِنَّا إِ ونِّي ثُوغَا خْ ثَادَّارْثْ نّسْ: ”سِيذفْ إِرْيَازنْ-أَ غَارْ ثَادَّارْثْ، ثْغَارْصذْ إِ شَا مِينْ إِدْجَانْ إِ ثْغَارْصْثْ، سوْجذْ إِ-ت، مِينْزِي إِرْيَازنْ-أَ أَذْ كِيذِي شّنْ غَارْ وزْينْ ن وَاسّْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","إِڭَّا ورْيَازْ أَمْ مَامّشْ ذ أَسْ إِنَّا يُوسُوفْ ؤُشَا يِيوِي إِرْيَازنْ غَارْ ثَادَّارْثْ ن يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","خنِّي ذوْڒنْ يرْيَازنْ نِّي ڭّْوذنْ أَطَّاسْ، ؤُمِي ثنْ سِّيذْفنْ ذِي ثَادَّارْثْ ن يُوسُوفْ ؤُشَا نِيثْنِي نَّانْ: ”خْ ثْمنْيَاثْ ن نُّوقَارْثْ إِ ذ أَنغْ د-إِذوْڒنْ ذِي ثْخُونْشَايْ نّغْ ثْوَاڒَا ثَامزْوَارُوثْ إِوْينْ أَنغْ-د ذَا حِيمَا خنِّي عَاوذْ أَذْ خَانغْعفْسنْ ؤُشَا أَذْ خَانغْعدَّانْ، خنِّي أَذْ أَنغْ كْسِينْ ذ إِسمْغَانْ أَكْ-ذ يغْيَاڒْ نّغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","قَارّْبنْ-د غَارْ ورْيَازْ نِّي إِڭَّا يُوسُوفْ خْ ثَادَّارْثْ ؤُشَا سِّيوْڒنْ أَكِيذسْ غَارْ وَاذَافْ ن ثَادَّارْثْ، ");
INSERT INTO rifa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","نَّانْ: ”أَ سِيذِي إِنُو، نشِّينْ أَقَا نِيشَانْ نهْوَا-د ذ أَمزْوَارْ، مَاحنْذْ أَذْ نْسغْ مَاشَّا. ");
INSERT INTO rifa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","إِمْسَارْ ؤُمِي د-نِيوضْ غَارْ ڒمْرَاحْ ؤُشَا نَارْزمْ ثِيخُونْشَايْ نّغْ، نژْرَا نُّوقَارْثْ ن كُوڒْ إِجّْ غَارْ ورْزَامْ ن ؤُقمُّومْ ن ثْخَانْشثْ نّسْ، نُّوقَارْثْ نّغْ س ڒْمِيزَانْ نّسْ نِيشَانْ. أَقَا نَارَّا إِ-ت-إِ-د س إِفَاسّنْ نّغْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","عَاوذْ نِيوِي-د ذڭْ إِفَاسّنْ نّغْ نُّوقَارْثْ نّغْنِي، حِيمَا أَذْ نْسغْ مَاشَّا. نشِّينْ وَارْ نسِّينْ وِي إِڭِّينْ نُّوقَارْثْ ذِي ثْخُونْشَايْ نّغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","يَارَّا-د خَاسنْ: ”سْڒَامْ خَاومْ، وَارْ تّڭّْوذمْ شَا! أَربِّي نْومْ ذ أَربِّي ن بَابَاثْومْ إِوْشَا أَومْ إِشْثْ ن ثْخَابشْثْ ذِي ثْخُونْشَايْ نْومْ. أَقَا نُّوقَارْثْ نْومْ طّْفغْ ت.“ ؤُشَا إِسُّوفّغْ-د غَارْسنْ شِيمْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","خنِّي إِسِّيذفْ ورْيَازْ إِرْيَازنْ نِّي غَارْ ثَادَّارْثْ ن يُوسُوفْ، إِوْشَا أَسنْ أَمَانْ ؤُشَا سِيرْذنْ إِضَارنْ نْسنْ. إِوْشَا أَسنْ عَاوذْ ڒعْڒفْ إِ يغْيَاڒْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ؤُ نِيثْنِي سّْوجْذنْ أَرِّيغَالُو إِ يُوسُوفْ، ونِّي إِڭُّورنْ أَذْ د-يَاسْ غَارْ وزْينْ ن وَاسّْ، مِينْزِي نِيثْنِي سْڒِينْ أَقَا أَذْ شّنْ ذِينِّي. ");
INSERT INTO rifa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ڒَْامِي د- يُوذفْ يُوسُوفْ غَارْ ثَادَّارْثْ، وْشِينْ أَسْ-د ذِي ثَادَّارْثْ أَرِّيغَالُو نِّي د-إِوْينْ أَكِيذْسنْ، ؤُشَا بنْذْقنْ أَسْ غَارْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","إِسّقْسَا ثنْ خْ مَامّشْ دْجَانْ ؤُشَا إِنَّا: ”مَامّشْ إِدْجَا بَابَاثْومْ أَوسَّارْ إِ خفْ ثسِّيوْڒمْ؟ مَا أَقَا عَاذْ إِدَّارْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","نِيثْنِي أَرِّينْ: ”مْلِيهْ إِ يدْجَا ؤُمْسخَّارْ نّشْ، بَابَاثْنغْ، نتَّا عَاذْ إِدَّارْ.“ ؤُضَارنْ نِيثْنِي ؤُشَا نتَّا إِبنْذقْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ڒَْامِي نتَّا إِسّْڭعّذْ ثِيطَّاوِينْ نّسْ ؤُشَا إِژْرَا بِينْيَامِينْ، ؤُمَاسْ، مِّيسْ ن يمَّاسْ، إِنَّا: ”مَا ذ وَا ذ ؤُمَاثْومْ، أَمَاژُوژْ، مِينْ خفْ ذ أَيِي ثسِّيوْڒمْ؟“ خنِّي إِنَّا: ”أَذْ خَاكْ إِحِينّْ أَربِّي، أَ مِّي!“ ");
INSERT INTO rifa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","يُوسُوفْ إِفّغْ خنِّي ذغْيَا، مِينْزِي ثَاحْنُونشْثْ نّسْ خْ ؤُمَاسْ ثُوغَا ثمْغَارْ. يَارْزُو خْ مَانِي غَا إِرُو ؤُشَا يُوذفْ غَارْ إِجّْ ن وخَّامْ ؤُشَا إِرُو ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","إِسِّيرْذْ ؤُذمْ نّسْ ؤُشَا إِفّغْ-د غَارْ بَارَّا، إِطّفْ ذڭْ إِخفْ نّسْ، إِنَّا: ”قذْممْ-د مَاشَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","نِيثْنِي سّْوجْذنْ أَسْ إِ نتَّا وحّْذسْ ؤُ إِ نِيثْنِي وحّذْسنْ ؤُڒَا إِ إِمِيصْرِييّنْ إِنِّي أَكِيذسْ شِّينْ وحّذْسنْ، مِينْزِي إِمِيصْرِييّنْ وَارْ زمَّارنْ أَذْ شّنْ أَغْرُومْ أَكْ-ذ إِعِيبْرَانِييّنْ، مِينْزِي ذ مَانْ أَيَا ذ جّْعِيفشْثْ غَارْ إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ؤُشَا نِيثْنِي قِّيمنْ زَّاثْ إِ وُوذمْ نّسْ: أَمنْزُو ذڭْ ومْشَانْ نّسْ عْلَاحْسَابْ ثَاسْغَارْثْ ن ثْمنْزُوثْ نّسْ ؤُشَا أَمَاژُوژْ ذڭْ ومْشَانْ نّسْ عْلَاحْسَابْ ثمْژِي نّسْ. ثُوغَا إِرْيَازنْ تّْبهَاثنْ، خزَّارنْ إِجّنْ ذڭْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ؤُشَا نتَّا إِقدّمْ أَسنْ-د زِي مِينْ ثُوغَا إِدْجَانْ زَّاثسْ، مَاشَا ثَاسْغَارْثْ ن بِينْيَامِينْ ثُوغَا-ت خمْسَا ن ثْسقَّارْ كْثَارْ زِي ثْسقَّارْ ن مَارَّا إِذْسنْ. ؤُشَا سْوِينْ نِيثْنِي، سّنِّي ذوْڒنْ فَارْحنْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","إِسّكّْ يُوسُوفْ غَارْ ؤُمْسخَّارْ نِّي ثُوغَا خْ ثَادَّارْثْ نّسْ، إِنَّا أَسْ: &عمَّارْ ثِيخُونْشَايْ ن يرْيَازنْ نِّي س مَاشَّا، مَارَّا مِينْ زمَّارنْ أَذْ كْسِينْ. أڭّْ نُّوقَارْثْ ن كُوڒْ إِجّْ ذڭْ وَارْزَامْ ن ؤُقمُّومْ ن ثْخَانْشثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","سَارْسْ ڒْكَاسْ إِنُو، ڒْكَاسْ ن نُّوقَارْثْ، ذڭْ وَارْزَامْ ن ؤُقمُّومْ ن ثْخَانْشثْ ن ؤُمَاژُوژْ أَكْ-ذ ثْمنْيَاثْ ن نُّوقَارْثْ ن ڒْحبّْ نّسْ ن يِيرْذنْ.“ ؤُشَا إِڭَّا أَمْ مَامّشْ ذ أَسْ إِنَّا يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","غَارْ صّْبحْ ؤُمِي د-يفُّو ڒْهَاڒْ، جِّينْ إِرْيَازنْ أَذْ ؤُيُورنْ، نِيثْنِي أَكْ-ذ يغْيَاڒْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ؤُمِي فّْغنْ نِيثْنِي زِي ثنْذِينْثْ، ثُوغَا عَاذْ وَارْ ڭّْوِيجنْ شَا، إِنَّا يُوسُوفْ إِ ونِّي ثُوغَا خْ ثَادَّارْثْ نّسْ: ”كَّارْ، ضْفَارْ إِرْيَازنْ نِّي ؤُشَا، خْمِي خَاسنْ غَا ثعْذُوذْ، إِنِي أَسنْ: ’مَاغَارْ د-ثَارَّامْ ڒْخَارْ س ڒْغَارْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","مَا وَارْ إِدْجِي ذ وَا ذ ڒْكَاسْ إِ زِي إِسسّْ سِيذِي إِنُو ؤُ مَا وَارْ إِدْجِي س وَا إِ زِي غَا إِكَاشفْ مِينْ غَا إِمْسَارنْ ثِيوشَّا؟ أَقَا ثڭِّيمْ ڒْغَارْ ؤُمِي ثڭِّيمْ أَمْيَا.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","أَمْ ثنْ إِعْذُو، إِنَّا أَسنْ أَوَاڒنْ-أَ سِيمَانْثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","نِيثْنِي أَرِّينْ-د خَاسْ: ”مَايمِّي إِقَّارْ سِيذِي إِنُو أَوَاڒنْ-أَ؟ إِڭّْوجْ خْ إِمْسخَّارنْ نّشْ أَذْ ڭّنْ مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","خْزَارْ، نُّوقَارْثْ إِ نُوفَا ذڭْ وَارْزَامْ ن ؤُقمُّومْ ن ثْخُونْشَايْ نّغْ، أَقَا نَارّْ أَشْ ت-إِ-د زِي ثمُّورْثْ ن كنْعَانْ. مَامّشْ عَاذْ إِ غَا نڭّْ أَذْ نَاشَارْ نُّوقَارْثْ نِيغْ ؤُرغْ زِي ثَادَّارْثْ ن سِيذِي نّشْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","وِي زڭْ إِمْسخَّارنْ نّشْ إِ غَارْ إِ غَا إِتّْوَافْ ڒْْكَاسْ، أَذْ إِمّثْ، ؤُشَا نشِّينْ عَاوذْ أَذْ نِيڒِي ذ إِسمْغَانْ ن سِيذِي إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","نتَّا إِنَّا: ”خنِّي ڒخُّو أَذْ يِيڒِي أَمْ مَامّشْ ثنَّامْ كنِّيوْ. ونِّي غَارْ ث غَا نَافْ، ذ نتَّا أَذْ يِيڒِي ذ إِسْمغْ إِنُو، مَاشَا كنِّيوْ أَذْ ثِيڒِيمْ ذ إِفُورَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ؤُشَا كُوڒْ إِجّْ زَّايْسنْ إِقدْجقْ أَذْ إِسَّارْسْ ثَاخَانْشثْ نّسْ ذِي ثمُّورْثْ ؤُشَا كُوڒْ إِجّْ يَارْزمْ ثَاخَانْشثْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ؤُشَا نتَّا إِفتّشْ إِ-ثنْثْ، إِبْذَا زڭْ ؤُمقّْرَانْ، إِكمّڒْ زڭْ ؤُمژْيَانْ، ؤُشَا ؤُفِينْ ڒْكَاسْ ذِي ثْخَانْشثْ ن بِينْيَامِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","خنِّي شَارّْڭنْ أَرُّوضْ نْسنْ، ؤُشَا كُوڒْ إِجّْ إِسَّارْبُو عَاوذْ خْ وغْيُوڒْ نّسْ ؤُشَاعقْبنْ نِيثْنِي غَارْ ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ؤُشَا يِيوضْ يَاهُوذَا أَكْ-ذ أَيْثْمَاسْ غَارْ ثَادَّارْثْ ن يُوسُوفْ، ونِّي ثُوغَا ذِينْ عَاذْ، ؤُشَا وْضَانْ زَّاثسْ غَارْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","إِنَّا أَسنْ يُوسُوفْ: ”مَانَا شْغڒْ-أَ إِ ثڭِّيمْ؟ مَا وَارْ ثفْهِيممْ شَا بلِّي إِجّْ ن ورْيَازْ أَمْ نشّْ، إِڭُّورْ أَذْ خَاسْ إِكَاشفْ نِيشَانْ؟“ ");
INSERT INTO rifa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","إِنَّا يَاهُوذَا: ”مِينْ غَا نِينِي إِ سِيذِي إِنُو ذ مَامّشْ إِ غَا نسِّيوڒْ نِيغْ س مِينْ زِي غَا نْسڭّذْ إِخفْ نّغْ؟ أَربِّي إِقدْجبْ دّنْبْ ن إِمْسخَّارنْ نّشْ، خْزَارْ، نشِّينْ ذ إِمْسخَّارنْ ن سِيذِي إِنُو، نشِّينْ ذ وِي غَارْ ؤُفِينْ ڒْكَاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","مَاشَا نتَّا يَارَّا: ”إِڭّْوجْ خَافِي أَذْ ڭّغْ أَيَا! أَرْيَازْ نِّي غَارْ ؤُفِينْ ڒْكَاسْ، نتَّا أَذْ يِيڒِي ذ إِسْمغْ إِنُو، مَاشَا كنِّيوْ رُوحمْ ذِي ڒهْنَا غَارْ بَابَاثْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","خنِّي يِيوضْ-د يَاهُوذَا غَارسْ، إِنَّا: ”أَ سِيذِي إِنُو، أجّْ أَذْ إِسِّيوڒْ ؤُمْسخَّارْ نّشْ إِجّْ ن وَاوَاڒْ ذڭْ ؤُمزُّوغْ ن سِيذِي إِنُو، وَارْ يَارقّْ ؤُخيّقْ نّشْ خْ ؤُمْسخَّارْ نّشْ، مِينْزِي أَقَا شكْ أَمْ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","سِيذِي إِنُو إِسّقْسَا إِمْسخَّارنْ نّسْ، إِنَّا: ’مَا غَارْومْ عَاذْ بَابَاثْومْ نِيغْ ثَاوْمَاثْ؟‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ؤُشَا نشِّينْ نَارَّا خْ سِيذِي إِنُو: ’أَقَا غَارْنغْ بَابَاثْنغْ ذ أَوسَّارْ ذ يِيجّْ ن ؤُحنْجِيرْ، ونِّي ذ أَسْ د-إِتّْوَاخڒْقنْ خْ ثوْسَارْ نّسْ، ذ أَمَاژُوژْ عَاذْ. ؤُمَاسْ إِمُّوثْ، نتَّا وَاهَا إِ إِقِّيمنْ زڭْ إِحنْجِيرنْ ن يمَّاسْ، ؤُ بَابَاسْ إِتّخْسْ إِ-ث.‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","خَاسْ ؤُشَا ثنِّيذْ شكْ إِ إِمْسخَّارنْ نّشْ: ’أَوْيمْ ث-إِ-د ذَا غَارِي، حِيمَا أَذْ ث ژَترغْ س ثِيطَّاوِينْ إِنُو.‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ؤُشَا نشِّينْ ننَّا إِ سِيذِي إِنُو: ’وَارْ إِزمَّارْ ؤُحنْجِيرْ أَذْ يجّْ بَابَاسْ، مِينْزِي مَاڒَا إِجَّا إِ-ث، بَابَاسْ أَذْ إِمّثْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","خنِّي ثنِّيذْ إِ إِمْسخَّارنْ نّشْ: ’مَاڒَا ؤُمَاثْومْ أَمَاژُوژْ وَارْ د-يُوسِي أَكِيذْومْ، وَارْ ثْژَارّمْ عَاذْ ؤُذمْ إِنُو.‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ڒَامِي نْڭعّذْ غَارْ بَابَا، أَمْسخَّارْ نّشْ، نسّعْذُو أَسْ أَوَاڒنْ ن سِيذِي إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ؤُشَا بَابَاثْنغْ إِنَّا: عقْبمْ عَاوذْ مَاحنْذْ أَذْ ثسْغمْ شْوَايْثْ ن مَاشَّا إِ نشِّينْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","خنِّي نَارَّا-د: ’وَارْ نْزمَّارْ أَذْ نْرَاحْ. مَاشَا مَاڒَا ؤُمَاثْنغْ، أَمَاژُوژْ، إِرُوحْ أَكِيذْنغْ، أَذْ نْرَاحْ، مِينْزِي وَارْ نْزمَّارْ أَذْ نْژَارْ ؤُذمْ ن ورْيَازْ نِّي، مْغِيرْ مَاڒَا أَقَا أَكِيذْنغْ ؤُمَاثْنغْ أَمَاژُوژْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","خنِّي إِنَّا أَنغْ ؤُمْسخَّارْ نّشْ، بَابَاثْنغْ: ’كنِّيوْ ثسّْنمْ بلِّي ثْنَاينْ ن إِحنْجِيرنْ إِ ذ أَيِي د-ثُورُووْ ثمْغَارْثْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","إِفّغْ إِجّنْ زِي غَارِي ؤُشَا نِّيغْ: أَقَا س ثِيذتّْ إِتّْوَابتّقْ! ؤُ أَڒْ ڒخُّو عَاذْ وَارْ ث ژْرِيغْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","مَاڒَا عَاوذْ ثكّْسمْ أَيِي وَا ؤُشَا إِمْسَارْ شَا ن ڒْغَارْ، أَذْ ثسّهْوَامْ شِّيبْ إِنُو س وشْضَانْ غَارْ ڒَاخَارْثْ!‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ڒخُّو خنِّي، مَاڒَا رُوحغْ نشّْ غَارْ ؤُمْسخَّارْ نّشْ، بَابَا، ؤُشَا أَحنْجِيرْ وَارْ كِيذِي إِدْجِي - ڒعْمَارْ نّسْ إِڒْصقْ غَارْ ڒعْمَارْ ن بَابَاسْ - ");
INSERT INTO rifa_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","أَقَا أَذْ إِمّثْ خْمِي غَا إِژَارْ أَحنْجِيرْ وَارْ إِدْجِي، ؤُشَا إِمْسخَّارنْ نّشْ أَذْ سّهْوَانْ شِّيبْ ن ؤُمْسخَّارْ نّشْ، بَابَاثْنغْ، س وشْضَانْ غَارْ ڒَاخَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","أَقَا زعْمَا أَمْسخَّارْ نّشْ ذ أَضْمَانْ إِ ؤُحنْجِيرْ-أَ غَارْ بَابَا ؤُمِي إِنَّا: ’مَاڒَا وَارْ ذ أَشْ ث-إِ-د-أَرِّيغْ، ڒخْذنِّي نشّْ أَذْ إِڒِيغْ ذ أَمذْنُوبْ إِ بَابَا إِ ڒبْذَا!‘ ");
INSERT INTO rifa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","إِوَا ڒخُّو، أجّْ أَمْسخَّارْ نّشْ أَذْ إِقِّيمْ ذڭْ ومْشَانْ ن ؤُحنْجِيرْ-أَ أَمْ يِيسْمغْ غَارْ سِيذِي إِنُو، ؤُشَا أجّْ أَحنْجِيرْ أَذْ إِرَاحْ أَكْ-ذ أَيْثْمَاسْ! ");
INSERT INTO rifa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","مَاغَارْ مَامّشْ غَا ڭّغْ أَذْ ڭعّْذغْ غَارْ بَابَا، بْڒَا أَحنْجِيرْ-أَ أَكِيذِي؟ مَامّشْ إِ غَا ژَترغْ ڒمْحَاينْ إِ د غَا إِوْضَانْ خْ بَابَا؟“ ");
INSERT INTO rifa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","خنِّي وَارْ إِزمَّارْ عَاذْ يُوسُوفْ أَذْ إِطّفْ إِخفْ نّسْ زَّاثْ إِ يِينِّي أَكِيذسْ مَارَّا ؤُشَا إِڒَاغَا: ”سُوفّْغمْ مَارَّا إِنِّي أَكِيذِي ذَا!“ وَارْ إِقِّيمْ حذْ أَكِيذسْ ڒَامِي إِسّْشنْ يُوسُوفْ إِ يَايْثْمَاسْ مِينْ إِعْنَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ڒخْذنِّي يَارْخُو ثْمِيجَّا نّسْ س إِغُويَّانْ، أَڒَامِي ذ أَسْ سْڒِينْ إِمِيصْرِييّنْ، ؤُشَا ؤُڒَا ذ ثَادَّارْثْ ن فِيرْعُونْ ثسْڒَا أَيَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","إِنَّا يُوسُوفْ إِ يَايْثْمَاسْ: ”نشّْ ذ يُوسُوفْ! مَا إِدَّارْ عَاذْ بَابَا؟“ أَيْثْمَاسْ وَارْ زمَّارنْ أَذْ خَاسْ د-أَرّنْ، مِينْزِي ثُوغَا ڭّْوذنْ زَّايسْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","إِنَّا يُوسُوفْ إِ يَايْثْمَاسْ: ”قَارّْبمْ-د ڒخُّو غَارِي!“ ؤُشَا نِيثْنِي قَارّْبنْ غَارسْ. إِنَّا خنِّي: ”نشّْ ذ يُوسُوفْ ؤُمَاثْومْ، ونِّي ثزّنْزمْ إِ مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ڒخُّو، وَارْ كسِّيمْ س ومْنُوسْ ؤُ وَارْ ث تّجِّيمْ أَذْ يِيڒِي ذ أَخيّقْ ذِي ثِيطَّاوِينْ نْومْ ؤُمِي ذ أَيِي ثزّنْزمْ ذَانِيثَا إِ مِيصْرَا، أَقَا أَربِّي إِسّكّْ أَيِي-د، مَاحنْذْ أَذْ كنِّيوْ جّغْ ثدَّارمْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","أَقَا ڒخُّو عَاذْ ثْنَاينْ ن إِسڭّْوُوسَا ن ڒَاژْ ذِي ثمُّورْثْ ؤُشَا قِّيمْ عَاذْ خمْسَا ن إِسڭّْوُوسَا وَارْ ذَايْسنْ إِتِّيڒِي ثْيَارْزَا نِيغْ ثَاميْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","مَاشَا أَربِّي إِسّكّْ أَيِي-د زَّاثْومْ، حِيمَا أَذْ أَومْ ڭّغْ مِينْ إِقِّيمنْ خْ ثمُّورْثْ ؤُ حِيمَا أَذْ حْضِيغْ ثُوذَارْثْ نْومْ إِ يِيجّْ ن ؤُسنْجمْ إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","خنِّي ڒخُّو، كنِّيوْ وَارْ ذ أَيِي د-ثسّكّمْ شَا ذَا، مَاشَا أَربِّي ذ ونِّي ذ أَيِي إِڭِّينْ ذ بَابَاسْ إِ فِيرْعُونْ ذ سِيذِي خْ مَارَّا ثَادَّارْثْ نّسْ ذ ڒْحَاكمْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","قدْجْقمْ ذغْيَا، سْڭعّْذمْ غَارْ بَابَا، إِنِيمْ أَسْ: ’أَمُّو إِ إِقَّارْ مِّيشْ يُوسُوفْ: أَربِّي إِڭَّا أَيِي ذ سِيذِي ن مَارَّا مِيصْرَا. أَرَاحْ-د غَارِي، وَارْ تّعْڭِيزْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","أَذْ ثْزذْغذْ ذِي ثمُّورْثْ ن جُوشَانْ، أَذْ ثِيڒِيذْ زَّاثِي، شكْ ذ إِحنْجِيرنْ نّشْ، ذ إِحنْجِيرنْ ن إِحنْجِيرنْ نّشْ، ذ وُودْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ؤُڒَا ذ مَارَّا مِينْ غَاركْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","أَذْ أَشْ ڭّغْ أَرْزقْ ذِينْ، مِينْزِي أَذْ د-أَسنْ عَاذْ خمْسَا ن إِسڭّْوُوسَا ن ڒَاژْ، حِيمَا وَارْ ثتّضْعِيفذْ، شكْ لَّ، ثَادَّارْثْ نّشْ لَّ، ؤُڒَا ذ مَارَّا مِينْ غَاركْ لَّ! ");
INSERT INTO rifa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","خْزَارْ، ثِيطَّاوِينْ نْومْ ژْرِينْثْ، ؤُڒَا ذ ثِيطَّاوِينْ ن ؤُمَا بِينْيَامِينْ، أَقَا ذ نشّْ إِ كِيذْومْ إِسَّاوَاڒنْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","عڒْممْ إِ بَابَا خْ مَارَّا أَعُودْجِي إِنُو ذِي مِيصْرَا ؤُ خْ مَارَّا مِينْ ثژْرِيمْ. قدْجْقمْ ذغْيَا، ثِيوْيمْ-د بَابَا ذَا.“ ");
INSERT INTO rifa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ؤُشَا إِنْڭزْ خْ يِيرِي ن بِينْيَامِينْ ؤُمَاسْ، إِرُو، ؤُشَا بِينْيَامِينْ إِرُو خْ يِيرِي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","إِسُّوذمْ مَارَّا أَيْثْمَاسْ، إِرُو خَاسنْ. أَوَارْنِي مَانْ أَيَا سِّيوْڒنْ أَكِيذسْ أَيْثْمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ڒَْامِي ثسْڒَا ثَادَّارْثْ ن فِيرْعُونْ ڒخْبَارْ-أَ، نَّانْ: ”أَيْثْمَاسْ ن يُوسُوفْ ؤُسِينْ-د!“. ثُوغَا-ث ذ ڒخْبَارْ أَصبْحَانْ ذِي ثِيطَّاوِينْ ن فِيرْعُونْ ذ إِمْسخَّارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","إِنَّا فِيرْعُونْ إِ يُوسُوفْ: ”إِنِي إِ أَيْثْمَاشْ: ’ڭّمْ أَيَا: سَارْبُومْ زْوَايڒْ نْومْ ؤُشَا ڭعّْذمْ، رُوحمْ غَارْ ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","كْسِيمْ-د بَابَاثْومْ ذ رَادْجْ نْومْ، ثُوسِيمْ-د غَارِي. أَقَا أَذْ أَومْ وْشغْ لمْلِيحْ ن ثمُّورْثْ ن مِيصْرَا ؤُشَا أَذْ ثشّمْ زِي مِينْ إِشْنَانْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","أَقَا تّْوَاڭّنْثْ ثِيوصَّا ذِي طّْوعْ نّكْ. ڭّمْ أَيَا: كْسِيمْ زِي ثمُّورْثْ ن مِيصْرَا إِكَارُّوثنْ إِ إِحنْجِيرنْ نْومْ ؤُ إِ ثمْغَارِينْ نْومْ، أَوْيمْ-د زَّايسْ بَابَاثْومْ ؤُشَا أَسمْ-د ذَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","وَارْ تّجِّيمْ ثِيطَّاوِينْ نْومْ أَذْ سّْحِيسّْفنْثْ إِ ڒْقشّْ نْومْ، مِينْزِي لمْلِيحْ ن ثمُّورْثْ ن مِيصْرَا أَذْ يِيڒِي نْومْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ؤُشَا أَمُّو إِ ڭِّينْ أَيْثْ ن إِسْرَائِيل. إِوْشَا أَسنْ يُوسُوفْ إِكَارُّوثنْ خْ ڒُومُورْ ن فِيرْعُونْ ؤُشَا إِوْشَا أَسنْ عَاوذْ مَاشَّا إِ وبْرِيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","إِوْشَا إِ كُوڒْ إِجّْ زَّايْسنْ وحّْذسْ أَرُّوضْ ن جْذِيذْ، مَاشَا إِ بِينْيَامِينْ إِوْشَا أَسْ ثڒْثْ-مْيَا ن ؤُقِييَّاثْ ن نُّوقَارْثْ ذ خمْسَا ن وَارُّوضْ ذ جْذِيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ؤُ أَمُّو عَاوذْ إِسّكّْ إِ بَابَاسْعشْرَا ن يغْيَاڒْ شُّورنْ س مِينْ إِفَارْزنْ ن مِيصْرَا ؤُعشْرَا ن ثغْيَاڒْ شُّورنْثْ س إِمنْذِي ذ وغْرُومْ ذ مَاشَّا إِ بَابَاسْ ؤُمِي غَا يِيڒِي نتَّا ذڭْ وبْرِيذْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","إِقبّضْ أَيْثْمَاسْ ؤُشَا رُوحنْ. إِنَّا أَسنْ نتَّا: ”وَارْ تّْمنْغِيمْ شَا ذڭْ وبْرِيذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ڭعّْذنْ زِي مِيصْرَا، إِوْضنْ غَارْ ثمُّورْثْ ن كنْعَانْ غَارْ يَاعْقُوبْ، بَابَاثْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","وْشِينْ أَسْ ڒخْبَارْ، نَّانْ: ”يُوسُوفْ أَقَا إِدَّارْ عَاذْ، وَاهْ، أَقَا-ث ذ ڒْحَاكمْ ن مَارَّا ثَامُّورْثْ ن مِيصْرَا!“ خنِّي إِسْخفْ وُوڒْ نّسْ، مِينْزِي وَارْ ثنْ يُومِينْ شَا. ");
INSERT INTO rifa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ؤُمِي ذ أَسْ عَاوْذنْ مَارَّا أَوَاڒنْ ن يُوسُوفْ إِنِّي ذ أَسنْ إِنَّا ؤُ ڒَْامِي إِژْرَا إِكَارُّوثنْ إِنِّي د-إِسّكّْ يُوسُوفْ حِيمَا أَذْ ث أَوْينْ، إِعْقبْ-د بُوحْبڒْ ن بَابَاثْسنْ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ؤُشَا إِنَّا إِسْرَائِيل: ”كْفَا! يُوسُوفْ مِّي أَقَا إِدَّارْ! أَذْ رَاحغْ ؤُشَا أَذْ ث ژَترْغْ قْبڒْ إِ غَا مّْثغْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","إِفْسِي إِسْرَائِيل إِقِيضَانْ نّسْ سّنِّي، يُويُورْ س مَارَّا مِينْ غَارسْ ؤُشَا يِيوضْ غَارْ بِئرْ-سبْعَا. إِقدّمْ ذِينْ ثِيغَارْصَا إِ أَربِّي ن بَابَاسْ إِسْحَاقْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ؤُشَا إِسِّيوڒْ أَربِّي أَكْ-ذ إِسْرَائِيل ذِي إِوحَّانْ ذِي دْجِيڒثْ، إِنَّا: ”يَاعْقُوبْ، يَاعْقُوبْ!“ ؤُشَا إِنَّا نتَّا: ”أَقَا أَيِي ذَا!“ ");
INSERT INTO rifa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","خنِّي إِنَّا: ”نشّْ ذ أَربِّي، أَربِّي ن بَابَاشْ. وَارْ تّڭّْوذْ، مَاحنْذْ أَذْ ثهْوِيذْ غَارْ مِيصْرَا، مِينْزِي نشّْ أَذْ شكْ ڭّغْ ذِينْ ذ إِجّْ ن ڒْڭنْسْ إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","أَذْ كِيذكْ هْوِيغْ غَارْ مِيصْرَا ؤُشَا نشّْ أَذْ شكْ سّْڭعّْذغْ عَاوذْ ؤُ يُوسُوفْ أَذْ خَاكْ إِسَّارْسْ إِفَاسّنْ نّسْ خْ ثِيطَّاوِينْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","إِكَّارْ يَاعْقُوبْ، إِفّغْ زِي بِئرْ-سبْعَا. كْسِينْ أَيْثْ ن إِسْرَائِيل بَابَاثْسنْ يَاعْقُوبْ ذ إِحنْجِيرنْ نْسنْ ذ ثمْغَارِينْ نْسنْ ذڭْ إِكَارُّوثنْ نِّي د-إِسّكّْ فِيرْعُونْ مَاحنْذْ أَذْ ث يَاوِي. ");
INSERT INTO rifa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","كْسِينْ ڒبْهَايمْ نْسنْ ذ وَاڭْڒَا إِ يَاربْحنْ ذِي ثمُّورْثْ ن كنْعَانْ ؤُشَا إِوْضنْ غَارْ مِيصْرَا، يَاعْقُوبْ ذ مَارَّا إِحنْجِيرنْ نّسْ أَكِيذسْ: ");
INSERT INTO rifa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","إِحنْجِيرنْ نّسْ ذ إِحنْجِيرنْ ن إِحنْجِيرنْ نّسْ جْمِيعْ أَكِيذسْ، ؤُڒَا ذ يسِّيسْ ذ يسِّيثْسنْ ن إِحنْجِيرنْ نّسْ، أَقَا يِيوِي أَكِيذسْ مَارَّا ثَارْوَا نّسْ غَارْ مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","إِنَا ذ إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل، إِنِّي يُوذْفنْ غَارْ مِيصْرَا: يَاعْقُوبْ ذ إِحنْجِيرنْ نّسْ. أَمنْزُو ن يَاعْقُوبْ: رُوبِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ثَارْوَا ن رُوبِينْ: حَانُوكْ ذ فَالُّو ذ حَاصْرُونْ ذ كَارْمِي. ");
INSERT INTO rifa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ثَارْوَا ن شِيمْعُونْ: يَامُويِيلْ ذ يَامِينْ ذ ؤُهَاذْ ذ يَاكِينْ ذ صُوحَارْ ذ شَاوُولْ، مِّيسْ ن ثمْغَارْثْ ثَاكنْعَانِيثْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ثَارْوَا ن لَاوِي: جَارْشُونْ ذ قَاهَاثْ ذ مَارَارِي. ");
INSERT INTO rifa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ثَارْوَا ن يَاهُوذَا: عِيرْ ذ ؤُنَانْ ذ شَايْلَا ذ فَارِيصْ ذ زَارَاحْ. مَاشَا عِيرْ ذ ؤُنَانْ مُّوثنْ ذِي ثمُّورْثْ ن كنْعَانْ. ثَارْوَا ن فَارِيصْ ثُوغَا أَثنْ حَاصْرُونْ ذ حَامُولْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ثَارْوَا ن إِسَّاكَارْ: ثُولَاعْ ذ فَاوَّا ذ يُوبْ ذ شِيمْرُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ثَارْوَا ن زابُولُونْ: سَارَاذْ ذ إِلُونْ ذ يَاحْلِييِيلْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن لِييَا إِنِّي ذ أَسْ د-ثُورُووْ إِ يَاعْقُوبْ ذِي فَاذَانْ-أَرَامْ، ؤُشَا عَاوذْ يدْجِيسْ ذِينَا. مَارَّا ڒعْمُورْ ن إِحنْجِيرنْ نّسْ ذ ثْحنْجِيرِينْ ثُوغَا أَثنْ ذِي ثْڒَاثَا ؤُ-ثْڒَاثِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ثَارْوَا ن جَاذْ: صِيفْيُونْ ذ حَاجِّي ذ شُونِي ذ أَصْبُونْ ذ عِيرِي ذ أَرُوذِي ذ أَرْوِيلِي. ");
INSERT INTO rifa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","إِحنْجِيرنْ ن أَشِيرْ: يِيمْنَا ذ يِيسْوِي ذ بَارِيعَا ذ ؤُتْشْمَاثْسنْ شَارَاحْ. ذ إِحنْجِيرنْ ن بَارِيعَا: حَابِيرْ ذ مَالْكِييِيلْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن زِيلْپَا ثنِّي إِوْشَا لَابَانْ إِ يدْجِيسْ لِييَا. نتَّاثْ ثُورُووْ-د إِنَا إِ يَاعْقُوبْ، إِنَا سطَّاشْ ذ أَرُّوحْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ثَارْوَا ن رَاحِيلْ، ثَامْغَارْثْ ن يَاعْقُوبْ: يُوسُوفْ ذ بِينْيَامِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","تّْوَاخڒْقنْ-د إِ يُوسُوفْ ذِي ثمُّورْثْ ن مِيصْرَا مَانَاسَّا ذ إِفْرَايِيمْ، إِنِّي ذ أَسْ د-ثُورُووْ أَسْنَاثْ، يدْجِيسْ ن فُوطِي-فَارَاعْ، أَكهَّانْ ن ؤُنْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ثَارْوَا ن بِينْيَامِينْ: بِيلَاعْ ذ بَاكِيرْ ذ أَشْبِيلْ ذ جِيرَا ذ نَاعْمَانْ ذ إِحِي ذ رُوشْ ذ مُوفِّيمْ ذ حُوفِّيمْ ذ أَرْذْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن رَاحِيلْ، إِنِّي د-إِتّْوَاوَارْونْ إِ يَاعْقُوبْ، مَارَّا أَرْبعْطَاشْ ذ أَرُّوحْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ثَارْوَا ن ذَانْ: مْغِيرْ حُوشِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ثَارْوَا ن نَافْثَالِي: يَاحَاصْوِيلْ ذ جُونِي ذ يِيصْرُو ذ شِيلِّيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","إِنَا ثُوغَا أَثنْ ذ إِحنْجِيرنْ ن بِيلْهَا، ثنِّي إِ ذ أَسْ إِوْشَا لَابَانْ إِ رَاحِيلْ يدْجِيسْ. ثُورُووْ أَسْ-د إِنَا إِ يَاعْقُوبْ، إِنَا مَارَّا ثُوغَا أَثنْ سبْعَا ذ أَرُّوحْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","مَارَّا ڒعْمُورْ نِّي د-يُوسِينْ غَارْ مِيصْرَا أَكْ-ذ يَاعْقُوبْ، إِنِّي د-إِفّْغنْ زڭْ ؤُغزْذِيسْ نّسْ، بْڒَا ثِيمْغَارِينْ ن إِحنْجِيرنْ ن يَاعْقُوبْ، إِنَا مَارَّا ثُوغَا أَثنْ ذِي ستَّا ؤُ-ستِّينْ ڒعْمُورْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ثَارْوَا ن يُوسُوفْ إِنِّي ذ أَسْ د-إِتّْوَاخڒْقنْ ذِي مِيصْرَا، أَقَا ثْنَاينْ ن ڒعْمُورْ. مَارَّا ڒعْمُورْ ن ثَادَّارْثْ ن يَاعْقُوبْ نِّي د-يُوسِينْ غَارْ مِيصْرَا، ثُوغَا أَثنْ ذِي سبْعِينْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ؤُشَا نتَّا إِسّكّْ يَاهُوذَا زَّاثسْ غَارْ يُوسُوفْ، حِيمَا أَذْ إِسّْشنْ أَبْرِيذْ زَّاثسْ غَارْ جُوشَانْ ؤُشَا إِوْضنْ غَارْ ثمُّورْثْ ن جُوشَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","إِنْذهْ يُوسُوفْ عَاوذْ أَكَارُّو نّسْ ؤُشَا إِڭعّذْ غَارْ جُوشَانْ، مَاحنْذْ أَذْ إِڒْقَا إِسْرَائِيل، بَابَاسْ. ؤُمِي ذ أَسْ إِمّڒْ إِخفْ نّسْ، إِنْڭزْ أَسْ خْ يِيرِي، إِقِّيمْ إِتّْرُو خْ يِيرِي نّسْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","إِنَّا إِسْرَائِيل إِ يُوسُوفْ: ”ڒخُّو زمَّارغْ نشّْ أَذْ مّْثغْ، ڒخُّو ؤُمِي ژْرِيغْ أَغمْبُوبْ نّشْ، زعْمَا أَقَا عَاذْ ثدَّارذْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","خنِّي إِنَّا يُوسُوفْ إِ يَايْثْمَاسْ ؤُ إِ أَيْثْبَابْ ن ثَادَّارْثْ ن بَابَاسْ: ”أَذْ ڭعّْذغْ أَذْ خبَّارغْ فِيرْعُونْ، أَذْ إِنِيغْ: ’أَيْثْمَا ذ ثَادَّارْثْ ن بَابَا، إِنِّي إِدْجَانْ ذِي ثمُّورْثْ ن كنْعَانْ، أَقَا ؤُسِينْ-د غَارِي. ");
INSERT INTO rifa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","إِرْيَازنْ ذ إِمكْسَاونْ ن وُودْجِي، ثُوغَا شغْڒنْ إِخفْ نْسنْ أَكْ ذ ڒبْهَايمْ. أَقَا إِوْينْ-د ؤُدْجِي نْسنْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نْسنْ ذ مَارَّا مِينْ غَارْسنْ.‘ ");
INSERT INTO rifa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","مَاڒَا إِمْسَارْ أَذْ أَومْ د-إِڒَاغَا فِيرْعُونْ ؤُشَا أَذْ أَومْ يِينِي: ’مِينْ ثعْنَا ڒْخذْمثْ إِ ثتّڭّمْ؟‘، ");
INSERT INTO rifa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","أَذْ ثِينِيمْ: ’إِمْسخَّارنْ نّشْ ذ إِرْيَازنْ إِنِّي إِشغْڒنْ أَكْ-ذ ڒبْهَايمْ زِي ثمْژِي نْسنْ أَڒْ إِ ڒخُّو، نشِّينْ ؤُڒَا ذ ڒجْذُوذْ نّغْ!‘، حِيمَا أَذْ غَارْومْ يِيڒِي تّسْرِيحْ مَاحنْذْ أَذْ ثْزذْغمْ ذِي ثمُّورْثْ ن جُوشَانْ، مِينْزِي كُوڒْ أَمكْسَاوْ ن وُودْجِي، أَقَا-ث ذ جّْعِيفشْثْ إِ إِمِيصْرِييّنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ڒَْامِي د-يُوسَا يُوسُوفْ، إِخبَّارْ فِيرْعُونْ، إِنَّا أَسْ: ”بَابَا ذ أَيْثْمَا ذ وُودْجِي نْسنْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نْسنْ ذ مَارَّا مِينْ غَارْسنْ، أَقَا ؤُسِينْ-د زِي ثمُّورْثْ ن كنْعَانْ. خْزَارْ، أَقَا أَثنْ ذِي ثمُّورْثْ ن جُوشَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ؤُشَا زِي جَارْ مَارَّا أَيْثْمَاسْ يِيوِي خمْسَا ن يرْيَازنْ، إِقدّمْ أَسْ ثنْ إِ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","خنِّي إِنَّا فِيرْعُونْ إِ يَايْثْمَاسْ: ”مِينْ ثعْنَا ڒْخذْمثْ إِ ثتّڭّمْ؟“ نِيثْنِي أَرِّينْ-د خْ فِيرْعُونْ: ”إِمْسخَّارنْ نّشْ ذ إِمكْسَاونْ ن وُودْجِي، أَمْ نشِّينْ أَمْ ڒجْذُوذْ نّغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","نَّانْ عَاوذْ إِ فِيرْعُونْ: ”إِ ثْزذِّيغْثْ ذِي ثمُّورْثْ-أَ أَمْ إِبَارَّانِييّنْ إِ د-نُوسَا، مِينْزِي وَارْ يدْجِي وفْسُو إِ وُودْجِي ن إِمْسخَّارنْ نّشْ، مِينْزِي ڒَاژْ إِقْسحْ ذِي ثمُّورْثْ ن كنْعَانْ. خنِّي ڒخُّو، نتّْزَاوڭْ إِ شكْ، أجّْ إِمْسخَّارنْ نّشْ أَذْ زذْغنْ ذِي ثمُّورْثْ ن جُوشَانْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ؤُشَا إِسِّيوڒْ فِيرْعُونْ أَكْ-ذ يُوسُوفْ، إِنَّا: ”بَابَاشْ ذ أَيْثْمَاشْ ؤُسِينْ-د غَاركْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ثَامُّورْثْ ن مِيصْرَا أَقَا-ت نّشْ مَارَّا. أجّْ بَابَاشْ ذ أَيْثْمَاشْ أَذْ زذْغنْ ذِي ثمُّورْثْ إِصبْحنْ، أجّْ إِ-ثنْ أَذْ زذْغنْ ذِي ثمُّورْثْ ن جُوشَانْ ؤُشَا مَاڒَا ثْحكَّارذْ بلِّي أَقَا جَارْ أَسنْ إِرْيَازنْ إِونْڭِيثنْ، ڭّمْ ثنْ ذ إِمحْضَاينْ خْ ڒبْهَايمْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ؤُشَا إِنْذهْ يُوسُوفْ بَابَاسْ، إِقدّمْ إِ-ث إِ فِيرْعُونْ ؤُشَا يَاعْقُوبْ إِبَاركْ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","إِنَّا فِيرْعُونْ إِ يَاعْقُوبْ: ”مشْهَاڒْ غَاركْ ن إِسڭّْوُوسَا؟“ ");
INSERT INTO rifa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","يَاعْقُوبْ يَارَّا-د خْ فِيرْعُونْ: ”مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا إِ دَّارغْ ذ أَبَارَّانِي. ؤُسَّانْ ن إِسڭّْوُوسَا ن ثُوذَارْثْ إِنُو يُوقْڒِيڒنْ ؤُ شُّورنْ س ڒْغَارْ. وَارْ إِوِيضنْ شَا وُوسَّانْ ن إِسڭّْوُوسَا ن ثُوذَارْثْ ن ڒجْذُوذْ إِنُو ذڭْ وُوسَّانْ ن لْغُورْبَا نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","خنِّي يَاعْقُوبْ إِبَارْكْ فِيرْعُونْ ؤُشَا إِفّغْ سّنِّي زَّاثْ إِ وُوذمْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","إِسّْشنْ يُوسُوفْ ثَازذِّيغْثْ إِ بَابَاسْ ذ أَيْثْمَاسْ، إِوْشَا أَسنْ ثَاسْغَارْثْ ذِي ثمُّورْثْ ن مِيصْرَا، زِي لمْلِيحْ ن ثمُّورْثْ، ذِي ثمُّورْثْ ن رَاعَامْسِيسْ أَمْ مَامّشْ ث إِوصَّا فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","إِعوّڒْ يُوسُوفْ بَابَاسْ ذ أَيْثْمَاسْ ذ مَارَّا ثَادَّارْثْ ن بَابَاسْ. إِعوّڒْ ؤُڒَا ذ مَاشَّا إِ إِحنْجِيرنْ إِمژْيَاننْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","أَغْرُومْ ثُوغَا وَارْ إِدْجِي ذِي ثمُّورْثْ مَارَّا، مِينْزِي ڒَاژْ ثُوغَا إِقْسحْ أَطَّاسْ، أَڒَامِي ثِيوضْ ثمُّورْثْ ن مِيصْرَا ذ ثمُّورْثْ ن كنْعَانْ فنَّانْثْ س ڒَاژْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","خنِّي إِيْرُو يُوسُوفْ مَارَّا نُّوقَارْثْ نِّي إِتّْوَافنْ ذِي ثمُّورْثْ ن مِيصْرَا ؤُ ذِي ثمُّورْثْ ن كنْعَانْ ذڭْ ؤُبدّڒْ ن إِمنْذِي إِ إِسْغِينْ. إِڭَّا يُوسُوفْ نُّوقَارْثْ نِّي ذِي ثَادَّارْثْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ؤُمِي ثقْضَا نُّوقَارْثْ زِي ثمُّورْثْ ن مِيصْرَا ذ ثمُّورْثْ ن كنْعَانْ، ؤُسِينْ-د مَارَّا إِمِيصْرِييّنْ غَارْ يُوسُوفْ نَّانْ: ”أوْشْ أَنغْ أَغْرُومْ، مَاغَارْ مَايمِّي غَا نمّثْ زَّاثكْ؟ وَارْ ذِينْ عَاذْ شَا نُّوقَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","يُوسُوفْ إِنَّا: ”مَاڒَا وَارْ غَارْومْ بُو نُّوقَارْثْ عَاذْ، وْشمْ خنِّي ڒبْهَايمْ نْومْ ؤُ نشّْ أَذْ أَومْ وْشغْ مَاشَّا ذڭْ ؤُبدّڒْ ن ڒبْهَايمْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","نِيثْنِي إِوْينْ-د ڒبْهَايمْ نْسنْ غَارْ يُوسُوفْ ؤُشَا إِوْشَا أَسنْ يُوسُوفْ أَغْرُومْ ذڭْ ومْشَانْ ن إِيْسَانْ ذ وُودْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ يغْيَاڒْ نْسنْ ؤُشَا إِسّشّْ إِ-ثنْ س وغْرُومْ ذڭْ ومْشَانْ ن مَارَّا ڒبْهَايمْ نْسنْ ذڭْ ؤُسڭّْوَاسْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ؤُمِي إِعْذُو ؤُسڭّْوَاسْ نِّي، ؤُسِينْ-د غَارسْ ذڭْ ؤُسڭّْوَاسْ وِيسّْ ثْنَاينْ ؤُشَا نَّانْ أَسْ: ”وَارْ نتّفَّارْ شَا خْ سِيذِي إِنُو بلِّي أَقَا نُّوقَارْثْ نّغْ ثقْضَا ؤُشَا ڒبْهَايمْ أَقَا أَثنْثْ ذڭْ ؤُفُوسْ ن سِيذِي إِنُو. وَارْ إِقِّيمْ وَالُو زَّاثْ إِ وُوذمْ ن سِيذِي إِنُو، مْغِيرْ أَرِّيمثْ نّغْ ذ إِيَّارنْ نّغْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","مَايمِّي غَا نمّثْ زَّاثْ إِ ثِيطَّاوِينْ نّشْ، ؤُڒَا ذ نشِّينْ ؤُڒَا ذ إِيَّارنْ نّغْ؟ سغْ أَنغْ، ثسْغذْ ثَامُّورْثْ نّغْ إِ وغْرُومْ ؤُشَا نشِّينْ ذ ثمُّورْثْ نّغْ أَذْ نِيڒِي ذ إِمْسخَّارنْ ن فِيرْعُونْ. أوْشْ أَنغْ زَّارِيعثْ حِيمَا أَذْ ندَّارْ وَارْ نتّْمتِّي شَا ؤُشَا ثَامُّورْثْ وَارْ ثذِّيكّْوِيڒْ ذ أَمسُّوشِي!“ ");
INSERT INTO rifa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","خنِّي إِسْغَا يُوسُوفْ مَارَّا ثَامُّورْثْ ن مِيصْرَا إِ فِيرْعُونْ، مِينْزِي إِمِيصْرِييّنْ زّنْزنْ مَارَّا إِيَّارْ نْسنْ، مِينْزِي ثُوغَا ڒَاژْ إِقْسحْ خَاسنْ. ؤُ أَمُّو إِ ثذْوڒْ ثمُّورْثْ ذ أَڭْڒَا ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ؤُشَا إِسّْمُوطِّييْ ڒْڭنْسْ زڭْ ؤُنڭَّارُو ن ويْمِيرْ أَڒْ أَنڭَّارُو نّغْنِي ن ويْمِيرْ ن مِيصْرَا غَارْ ثْندَّامْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","مْغِيرْ ثَامُّورْثْ ن إِكهَّاننْ وَارْ ت إِسْغِي شَا. أَقَا إِكهَّاننْ غَارْسنْ إِشْثْ ن ڒْمُونثْ زِي فِيرْعُونْ، نِيثْنِي تّتّنْ ثَاسْغَارْثْ نْسنْ، ثنِّي إِ ذ أَسنْ إِوْشَا فِيرْعُونْ. خْ ؤُيَا وَارْ زّنْزنْ شَا ثَامُّورْثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","خنِّي إِنَّا يُوسُوفْ إِ ڒْڭنْسْ: ”خْزَارْ، أَسّْ-أَ نشّْ سْغِيغْ كنِّيوْ ؤُڒَا ذ ثَامُّورْثْ نْومْ إِ فِيرْعُونْ. خْزَارمْ، أَقَا ذَا زَّارِيعثْ نْومْ. زَارْعمْ زَّايسْ ثَامُّورْثْ! ");
INSERT INTO rifa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","زِي ڒْغِيدْجثْ أَذْ ثوْشمْ ثَاسْغَارْثْ ثخْمُوسشْثْ إِ فِيرْعُونْ ؤُ أَربْعَا ن ثْسقَّارْ إِ إِقِّيمنْ أَذْ إِڒِينْثْ إِ يِيخفْ نْومْ ذ زَّارِيعثْ إِ ييَّارْ ؤُشَا أَذْ إِڒِينْثْ، مَاحنْذْ أَذْ زَّايْسنْثْ ثشّمْ كنِّيوْ أَكْ-ذ أَيْثْبَابْ ن ثَادَّارْثْ نْومْ ؤُ عَاوذْ، مَاحنْذْ أَذْ زَّايْسنْثْ شّنْ إِحنْجِيرنْ إِمژْيَاننْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","نِيثْنِي نَّانْ: ”شكْ ثحْضِيذْ ثُوذَارْثْ نّغْ. أجّْ أَنغْ أَذْ نَافْ أَرْضَا ذِي ثِيطَّاوِينْ ن سِيذِي إِنُو ؤُشَا نشِّينْ أَذْ نِيڒِي ذ إِمْسخَّارنْ إِ فِيرْعُونْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","إِڭَّا يُوسُوفْ مَانْ أَيَا ذ ثَاوْصيّثْ إِ ذِينْ إِدْجَانْ أَڒْ أَسّْ-أَ، بلِّي إِشْثْ ن ثسْغَارْثْ ن ثخْمُوسشْثْ ن ڒْغِيدْجثْ ن ثمُّورْثْ ن مِيصْرَا أَذْ ثِيڒِي إِ فِيرْعُونْ. مْغِيرْ إِيَّارنْ ن إِكهَّاننْ قِّيمنْ ذ أَڭْڒَا نْسنْ، وَارْ دِّيكّْوِيڒنْ شَا ذ أَڭْڒَا ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","أَمُّو إِ إِزْذغْ إِسْرَائِيل ذِي ثمُّورْثْ ن مِيصْرَا، ذِي ثمُّورْثْ ن جُوشَانْ، ملّْكنْ ذَايسْ ؤُشَا وْشِينْ ڒْغِيدْجثْ ؤُشَا كْثَارنْ س يِيجّْ ن شّْكلْ إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","إِدَّارْ يَاعْقُوبْ ذِي ثمُّورْثْ ن مِيصْرَا سْبعْطَاشْ ن إِسڭّْوُوسَا ؤُشَا ثُوغَا ؤُسَّانْ ن يَاعْقُوبْ، إِسڭّْوُوسَا ن ثُوذَارْثْ نّسْ، مْيَا ؤُ-سبْعَا ؤُ-ربْعِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ؤُمِي د-إِوْضنْ وُوسَّانْ إِ إِسْرَائِيل أَذْ إِمّثْ، إِڒَاغَا-د خْ يُوسُوفْ مِّيسْ، إِنَّا أَسْ: ”مَاڒَا ؤُفِيغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، تّْزَاوَاڭغْ شكْ، أَذْ ثڭّذْ أَفُوسْ نّشْ سَاذُو ثْمصَّاضْثْ إِنُو ؤُشَا أڭّْ أَكِيذِي س ثْمخْسِيوْثْ إِشوَّارنْ ذ ڒَامَانْ ؤُ وَارْ ذ أَيِي نطّڒْ شَا ذِي مِيصْرَا، ");
INSERT INTO rifa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","مَاشَا خْمِي غَا ڭّغْ أَذْ أَريّْحغْ جَارْ ڒجْذُوذْ إِنُو، خنِّي أَوِي أَيِي زِي مِيصْرَا ؤُشَا نْضڒْ أَيِي ذڭْ ونْضڒْ نْسنْ. يَارَّا-د خَاسْ: ”نشّْ أَذْ ڭّغْ مِينْ ثنِّيذْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","خَاسْ ؤُشَا إِنَّا أَسْ: ”جَادْجْ أَيِي!“، ؤُشَا إِجُّودْجْ أَسْ. ڒخْذنِّي يُوضَارْ إِسْرَائِيل خْ ؤُزدْجِيفْ ن قَامَا. ");
INSERT INTO rifa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","أَوَارْنِي مَانْ أَيَا إِمْسَارْ، إِتّْوَانَّا إِ يُوسُوفْ: ”خْزَارْ، أَقَا بَابَاشْ إِحْڒشْ!“ خنِّي إِكْسِي أَكِيذسْ ثْنَاينْ ن إِحنْجِيرنْ نّسْ مَانَاسَّا ذ إِفْرَايِيمْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","خبَّارنْ يَاعْقُوبْ، نَّانْ: ”خْزَارْ، أَقَا مِّيشْ يُوسُوفْ أَذْ غَاركْ د-يَاسْ!“ خنِّي إِڭَّا إِسْرَائِيل ؤُڒْ ذڭْ إِخفْ نّسْ ؤُشَا إِكَّارْ إِقِّيمْ خْ قَامَا. ");
INSERT INTO rifa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","خنِّي إِنَّا يَاعْقُوبْ إِ يُوسُوفْ: ”أَربِّي، أَمْزمَّارْ خْ كُوڒْشِي، أَقَا إِبَانْ أَيِي-د ذِي لُوزْ، ذِي ثمُّورْثْ ن كنْعَانْ، ؤُ أَقَا نتَّا إِبَارْكْ أَيِي. ");
INSERT INTO rifa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ؤُ أَقَا نتَّا إِنَّا أَيِي: ”خْزَارْ، أَذْ شكْ أَرّغْ أَذْ ثڭّذْ ڒْغِيدْجثْ ؤُشَا أَذْ شكْ كتَّارغْ، أَذْ شكْ ڭّغْ ذ إِجّْ ن وڭْرَاوْ ن ڒڭْنُوسْ، أَذْ أَشْ وْشغْ ثَامُّورْثْ-أَ ذ أَڭْڒَا إِ ڒبْذَا ؤُ إِ زَّارِيعثْ نّشْ أَوَارْنِي أَشْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ؤُشَا ڒخُّو، أَقَا ثْنَاينْ ن إِحنْجِيرنْ نّشْ، إِفْرَايِيمْ ذ مَانَاسَّا، إِنِّي ذ أَشْ د-إِتّْوَاخڒْقنْ ذِي ثمُّورْثْ ن مِيصْرَا قْبڒْ إِ غَاركْ د-ؤُسِيغْ ذِي ثمُّورْثْ ن مِيصْرَا، أَقَا أَثنْ إِنُو، أَمْ رُوبِينْ ذ شِيمْعُونْ إِ إِدْجَانْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","مَاشَا إِنِّي ذ أَشْ د-إِتّْوَاخڒْقنْ أَوَارْنِي أَسنْ، أَذْ إِڒِينْ نّشْ. أَذْ تّْوَاسمَّانْ خْ يِيسمْ ن أَيْثْمَاثْسنْ ذِي ڒْوَارْثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ؤُمِي د-ؤُسِيغْ زِي فَاذَانْ-أَرَامْ، ثمُّوثْ رَاحِيلْ زَّاثِي ذِي ثمُّورْثْ ن كنْعَانْ ذڭْ وبْرِيذْ، ڒَامِي ثُوغَا عَاذْ وَارْ ثِيڭّْوِيجْ خْ إِفْرَاثَا. نضْڒغْ ت ذِينْ ذڭْ وبْرِيذْ غَارْ إِفْرَاثَا!“، أَقَا-ت ذ بَايْثْ-لَاحْمْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","إِژْرَا إِسْرَائِيل إِحنْجِيرنْ ن يُوسُوفْ، إِنَّا: ”مِينْ عْنَانْ إِنَا؟“ ");
INSERT INTO rifa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","يَارَّا-د يُوسُوفْ خْ بَابَاسْ: ”ذ إِحنْجِيرنْ إِنُو إِ ذ أَيِي إِوْشَا أَربِّي ذَانِيثَا.“ إِنَّا أَسْ: ”سْقَارّْبمْ ثنْ-د غَارِي ؤُشَا أَذْ ثنْ بَارْكغْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ثُوغَا ثِيطَّاوِينْ ن إِسْرَائِيل ؤُژْغنْثْ س ثوْسَارْ، وَارْ إِقِّيمْ إِتّْوَاڒَا. إِسّْقَارّبْ أَسْ ثنْ-د، خنِّي إِسُّوذمْ إِ-ثنْ، إِذَارّعْ أَسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","إِنَّا إِسْرَائِيل إِ يُوسُوفْ: ”وَارْ ذ أَيِي إِتّْغِيڒْ أَذْ ژَترغْ عَاذْ ؤُذمْ نّشْ. خْزَارْ، أَربِّي إِڭَّا أَيِي أَذْ ژَترغْ عَاذْ ثَارْوَا نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","خنِّي إِسّْضَارْ إِ-ثنْ يُوسُوفْ خْ إِفَادّنْ نّسْ ؤُشَا إِبنْذقْ س وُوذمْ نّسْ غَارْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ؤُشَا إِكْسِي إِ-ثنْ يُوسُوفْ س ثْنَاينْ إِذْسنْ، إِفْرَايِيمْ س ؤُفُوسِي نّسْ أَرنْذَاذْ ن ؤُزڒْمَاضْ ن إِسْرَائِيل ؤُ مَانَاسَّا س ؤُزڒْمَاضْ نّسْ أَرنْذَاذْ ن ؤُفُوسِي ن إِسْرَائِيل ؤُشَا إِسّْقَارّبْ أَسْ ثنْ-د. ");
INSERT INTO rifa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","إِسّْوِيژّضْ إِسْرَائِيل يفُوسْ نّسْ، إِسَّارْسْ إِ-ث خْ ؤُزدْجِيفْ ن إِفْرَايِيمْ، وَاخَّا ثُوغَا-ث ذ أَمَاژُوژْ، ذ أَزڒْمَاضْ نّسْ خْ ؤُزدْجِيفْ ن مَانَاسَّا. إِسَّارْسْ أَمُّو إِفَاسّنْ نّسْ مَامّشْ نّغْنِي نعْمَاذَا، وَاخَّا مَانَاسَّا ثُوغَا-ث ذ أَمنْزُو. ");
INSERT INTO rifa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","إِسْرَائِيل إِبَارْكْ يُوسُوفْ، إِنَّا: ”ذ أَربِّي، ونِّي ؤُمِي ڒجْذُوذْ إِنُو، إِبْرَاهِيمْ ذ إِسْحَاقْ، ؤُيُورنْ زَّاثسْ، أَربِّي، ونِّي إِدْجَانْ ذ أَمكْسَاوْ إِنُو زڭْ وَامِي دْجِيغْ أَڒْ أَسّْ-أَ،    ");
INSERT INTO rifa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","لْمَالَاكْ نِّي ذ أَيِي إِفْذِينْ زِي مَارَّا ثُوعفّْنَا، إِڒِي نتَّا أَذْ إِبَارْكْ إِحنْجِيرنْ-أَ ؤُ إِڒِي أَذْ إِتّْوَاڒَاغَا إِسمْ إِنُو ذَايْسنْ ؤُڒَا ذ إِسمْ ن ڒجْذُوذْ إِنُو، إِبْرَاهِيمْ ذ إِسْحَاقْ. إِڒِي أَذْ مَّارنْينْ أَڒْ غَا ذوْڒنْ ذ إِجّْ ن ؤُبَارُّو أَمْ إِسڒْمَانْ ذڭْ وَامَانْ ذِي ڒْوسْطْ ن ثمُّورْثْ!“    ");
INSERT INTO rifa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ؤُمِي إِژْرَا يُوسُوفْ، بلِّي بَابَاسْ إِڭَّا أَفُوسْ أَفُوسِي نّسْ خْ ؤُزدْجِيفْ ن إِفْرَايِيمْ، ثُوغَا-ت ذ إِشْثْ ن ڒعْڒَامثْ وَارْ ثحّْڒِي غَارسْ ذِي ثِيطَّاوِينْ نّسْ ؤُشَا إِطّفْ أَفُوسْ ن بَابَاسْ، حِيمَا أَذْ ث إِبدّڒْ زڭْ ؤُزدْجِيفْ ن إِفْرَايِيمْ غَارْ ؤُزدْجِيفْ ن مَانَاسَّا. ");
INSERT INTO rifa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","إِنَّا يُوسُوفْ إِ بَابَاسْ: ”وَارْ تّڭّْ شَا أَمُّو، أَ بَابَا، مِينْزِي ذ وَا ذ أَمنْزُو، أڭّْ أَفُوسِي نّشْ خْ ؤُزدْجِيفْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","مَاشَا بَابَاسْ وَارْ إِخْسْ شَا، إِنَّا: ”سّْنغْ، أَ مِّي، سّْنغْ. عَاوذْ نتَّا أَذْ إِذْوڒْ ذ إِجّْ ن ڒْڭنْسْ، أَذْ إِمْغَارْ عَاوذْ، مَاشَا ؤُمَاسْ أَمَاژُوژْ أَذْ يِيڒِي كْثَارْ زَّايسْ، زَّارِيعثْ نّسْ أَذْ ثذْوڒْ ذ ثَاشُورّثْ ن ڒڭْنُوسْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ؤُشَا أَمُّو إِ ثنْ إِبَاركْ ذڭْ وَاسّْ نِّي، إِنَّا: ”ذَايكْ، ذڭْ يِيسمْ نّكْ، أَ يُوسُوفْ أَذْ إِبَاركْ ڒْْڭنْسْ إِسْرَائِيل، أَذْ إِنِينْ: ’أَذْ كنِّيوْ يَارّْ أَربِّي أَمْ إِفْرَايِيمْ ذ مَانَاسَّا!‘ “ ؤُشَا يَارَّا إِفْرَايِيمْ أَذْ إِبدّْ زَّاثْ إِ مَانَاسَّا. ");
INSERT INTO rifa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","أَوَارْنِي أَسْ إِنَّا إِسْرَائِيل إِ يُوسُوفْ: ”خْزَارْ، أَذْ مّْثغْ، مَاشَا أَربِّي أَذْ يِيڒِي أَكِيذْومْ، أَذْ كنِّيوْ إِسّْمُوطِّييْ غَارْ ثمُّورْثْ ن ڒجْذُوذْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","أَقَا وْشِيغْ أَشْ إِشْثْ ن ثسْغَارْثْ ن إِذُورَارْ خْ مِينْ وْشِيغْ إِ يَايْثْمَاشْ، ثنِّي كْسِيغْ نشّْ زڭْ إِفَاسّنْ ن إِمُورِييّنْ س سِّيفْ ذ ڒْقوْسْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","إِڒَاغَا يَاعْقُوبْ خْ إِحنْجِيرنْ نّسْ، إِنَّا: ”سْمُونمْ-د إِخفْ نْومْ، أَذْ أَومْ إِنِيغْ مِينْ ذ أَومْ غَا إِمْسَارنْ ذڭْ ؤُنڭَّارْ ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","سْمُونمْ-د إِخفْ نْومْ ؤُشَا سْڒمْ، أَ ثَارْوَا ن يَاعْقُوبْ، سْڒمْ إِ إِسْرَائِيل، بَابَاثْومْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","رُوبِينْ، شكْ ذ أَمنْزُو إِنُو، جّهْذْ إِنُو، ذ أَمزْوَارْ ن ثرْيَاسْثْ إِنُو، أَقَا شكْ ذ أَمْسضْفَارْ إِنُو ذِي ڒُوعْڒَا، ذ أَمْسضْفَارْ إِنُو ذِي ڒْعزّْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","شكْ أَمشْنَاوْ أَمَانْ إِتّْنقْڒَابنْ، وَارْ د أَيِي ثْضفَّارذْ، أَقَا شكْ ثْڭعّْذذْ غَارْ ڒشْثُو ن ڒمْڒَاشْ ن بَابَاشْ، ڒخْذنِّي ثسّْفضْحذْ ث، أَقَا غَارْ ڒشْثُو إِنُو إِڭعّذْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","شِيمْعُونْ ذ لَاوِي ذ أَوْمَاثنْ! ڒمْوَاسْ نْسنْ ذ ڒسْنَاحْ ن لْعُونْفْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ذِي ثْمعْمُوتْشْ نْسنْ وَارْ إِتِّيذفْ ڒعْمَارْ إِنُو، ذڭْ وڭْرَاوْ نْسنْ وَارْ إِشَارّشْ وُوڒْ إِنُو. أَقَا ذڭْ ؤُخيّقْ نْسنْ نْغِينْ إِجّْ ن ورْيَازْ ؤُشَا إِعْجبْ أَسنْ أَذْ قسّنْ إِژوْرَانْ ن إِضَارنْ ن ؤُفُونَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ذ أَمنْعُوڒْ أَخيّقْ نْسنْ، مِينْزِي وَانِيثَا إِجْهذْ أَطَّاسْ، ؤُڒَا ذ أَذُوقّزْ ن ؤُفُوڭمْ نْسنْ، مِينْزِي إِقْسحْ. نشّْ أَذْ ثنْ بْضِيغْ خْ يَاعْقُوبْ، أَذْ ثنْ سُّويُوسغْ ذِي إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","يَاهُوذَا، أَيْثْمَاشْ أَذْ شكْ سّمْغَارنْ. أَفُوسْ نّشْ أَذْ يِيڒِي خْ يِيرِي ن ڒْعذْيَانْ نّشْ ؤُ إِحنْجِيرنْ ن بَابَاشْ أَذْ أَشْ بنْذْقنْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","يَاهُوذَا ذ إِجّْ ن مِّيسْ ن وَايْرَاذْ. زِي زَّارْذثْ إِ ثُوڒْيذْ، أَ مِّي. إِقْوسْ أَمشْنَاوْ أَيْرَاذْ ؤُ أَمشْمَاوْ ثَايْرَاذْثْ. وِي إِزعّمنْ أَذْ ث-د-إِسّْفَاقْ؟ ");
INSERT INTO rifa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ثَاغَّارْشْثْ ن ڒْحَاكمْ وَارْ إِتّْوَاكّسْ خْ يَاهُوذَا ؤُڒَا ذ أَزدْجَاضْ ن صُّولْطَا زِي جَارْ إِضَارنْ نّسْ، أَڒْ د غَا يَاسْ ونِّي إِ غَا إِوْشنْ أَرَّاحثْ ؤُشَا أَذْ أَسْ طَاعنْ ڒڭْنُوسْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","إِقّنْ غَارْ ثْزَايَارْثْ أَسْنُوسْ نّسْ ذ مِّيسْ نّسْ ن ثغْيُوتْشْ غَارْ ثْزَايَارْثْ إِشنّْعنْ أَطَّاسْ، إِسِّيرْذْ أَرُّوضْ نّسْ ذِي بِينُو ؤُ أَرُّوضْ نّسْ ذڭْ إِذَامّنْ ن ؤُضِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ثِيطَّاوِينْ نّسْ ذ ثِيبَارْشَانِينْ س بِينُو ؤُ ثِيغْمَاسْ نّسْ ذ ثِيشمْڒَاڒِينْ س ؤُغِي. ");
INSERT INTO rifa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","زابُولُونْ أَذْ إِزْذغْ غَارْ ثْمَا ن ڒبْحَارْ، أَذْ يِيڒِي ذ ڒْمُويِّي إِ إِغَارُّوبَا. أَغزْذِيسْ نّسْ أَذْ يَاريّحْ خْ صِيذُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","إِسَّاكَارْ ذ إِجّْ ن وغْيُوڒْ إِقْسحْ، إِزّڒْ جَارْ ثْنَاينْ ن ڒْمذْوَاثْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ؤُمِي إِژْرَا أَرَّاحثْ ذ لمْلِيحْ ؤُ ثَامُّورْثْ أَقَا ثَارشّقْ، إِقْوسْ، إِڭَّا ثِيغَارْضِينْ نّسْ مَاحنْذْ أَذْ يَارْبُو أَرّْمحْ ؤُشَا أَمُّو إِ إِذْوڒْ سَاذُو أَزَايْڒُو ن إِسْمغْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ذَانْ أَذْ إِحْكمْ ڒْڭنْسْ نّسْ أَمْ يِيشْثْ زِي ثْقبَّاڒْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","أَذْ يِيڒِي ذَانْ ذ أَفِيغَارْ ذڭْ وبْرِيذْ، ثَاڒفْسَا ذڭْ ؤُمسْرُوقْ، ونِّي إِزعّْفنْ ذڭْ إِنِيرْزَاونْ ن ؤُيِيسْ، أَڒْ غَا إِوْضَا ونِّي خَاسْ إِنْيِينْ غَارْ ضفَّارْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","أَسنْجمْ نّشْ إِ تّْرَاجِيغْ، أَ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","جَاذْ، أَذْ خَاسْ حجْمنْثْ بَانْذِييَّاثْ، مَاشَا أَذْ خَاسنْ إِذَارّشْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","أَشِيرْ، أَغْرُومْ نّسْ أَذْ يِيڒِي ذ أَغْرُومْ إِسْمنْ، نتَّا أَذْ إِقدّمْ مَاشَّا يِيزِيذنْ إِڭلّْذنْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نَافْثَالِي ذ إِشْثْ ن ثُوذَاذْثْ إِتّْوَاضڒْقنْ، إِسُّوفُّوغْ أَوَاڒنْ شْنَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","يُوسُوفْ ذ مِّيسْ ن ثْشجَّارْثْ إِتِّيشنْ ڒْغِيدْجثْ، مِّيسْ ن ثْشجَّارْثْ إِتِّيشنْ ڒْغِيدْجثْ غَارْ ثَاڒَا. يسِّيسْ ڭُّورنْثْ خْ وغْبَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","نِيثْنِي سَّارزْڭنْ خَاسْ ثُوذَارْثْ، نيّْشنْ خَاسْ، وَاهْ إِمْجبَّاذنْ نْ ڒْقوْسْ ضْفَارنْ ث، ");
INSERT INTO rifa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","مَاشَا ڒْقوْسْ نّسْ إِقِّيمْ إِمْحضْ ؤُ إِغَادْجنْ ن إِفَاسّنْ نّسْ قِّيمنْ أَرْخُونْ س إِفَاسّنْ ن ؤُمْزمَّارْ ن يَاعْقُوبْ - خْ ؤُيَا نتَّا ذ أَمكْسَاوْ ذ ثَاصْضَارْثْ ن إِسْرَائِيل - ");
INSERT INTO rifa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","س أَربِّي ن بَابَاشْ ونِّي شكْ إِ غَا إِعَاوْننْ، أَمْزمَّارْ خْ كُوڒْشِي، ونِّي شكْ إِ غَا إِبَارْكنْ س لْبَارَاكَاثْ ن ؤُجنَّا سنّجْ، س لْبَارَاكَاثْ ن وَامَانْ إِهوْڒنْ إِ ذِينْ إِدْجَانْ سْوَادَّايْ، س لْبَارَاكَاثْ ن ثُوبّشْثْ ذ ڒمْڒَاوثْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","لْبَارَاكَاثْ ن بَابَاشْ ذ ثِيمقّْرَانِينْ ؤُعْڒَانْثْ خْ لْبَارَاكَاثْ ن يِينِّي ذ أَيِي د-يجِّينْ ؤُشَا تَّاكّْوَاضنْثْ غَارْ ثْقِيشَّاثِينْ ن ثوْرِيرِينْ ن ڒبْذَا. أَذْ إِڒِينْثْ خْ ؤُزدْجِيفْ ن يُوسُوفْ، خْ ثُوشّنْثْ ن ؤُشُوَّافْ ن ونِّي يَاربُّو تَّاجْ ن وعْزَارْ جَارْ أَيْثْمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","بِينْيَامِينْ ذ إِجّْ ن وُوشّنْ إِتّْمزَّاقْ. غَارْ صّْبحْ أَذْ إِسَارْضْ زَّارْذثْ ؤُ س دْجِيڒثْ إِبطَّا ثَاكشَّاضْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","مَارَّا إِنَا ذ ثنْعَاشْ ن ثْقبَّاڒْ ن إِسْرَائِيل. ذ مَانْ أَيَا مِينْ ذ أَسنْ إِنَّا بَابَاثْسنْ ؤُشَا إِبَارْكْ إِ-ثنْ، وَاهْ، إِبَارْكْ إِ-ثنْ، كُوڒْ إِجّْ س لْبَارَاكَا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","يُومُورْ إِ-ثنْ، إِنَّا أَسنْ: ”أَذْ مَّارنْيغْ غَارْ ڒْڭنْسْ إِنُو. نضْڒمْ أَيِي أَكْ-ذ ڒجْذُوذْ إِنُو ذڭْ إِفْرِي ونِّي إِدْجَانْ ذڭْ إِيَّارْ ن إِفْرُونْ، أَحِيتِّي، ");
INSERT INTO rifa_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ذڭْ إِفْرِي ونِّي إِدْجَانْ ذڭْ إِيَّارْ ن مَاكْفِيلَا إِ إِدْجَانْ زَّاثْ إِ مَامْرِي ذِي ثمُّورْثْ ن كنْعَانْ، ثنِّي إِسْغَا إِبْرَاهِيمْ أَكْ-ذ ييَّارْ زِي إِفْرُونْ، أَحِيتِّي، حِيمَا أَذْ يِيڒِي ذ أَنْضڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ذِينِّي إِ نضْڒنْ إِبْرَاهِيمْ ذ سَارَا ثَامْغَارْثْ نّسْ. ذِينِّي إِ نضْڒنْ إِسْحَاقْ ذ ثمْغَارْثْ نّسْ رِيفْقَا. ؤُ نشّْ نضْڒغْ ذِينْ لِييَا. ");
INSERT INTO rifa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","إِيَّارْ س إِفْرِي إِ ثُوغَا ذَايسْ إِدْجَانْ إِمّْسغْ خْ ثَارْوَا ن حِيثْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ؤُمِي إِكمّڒْ يَاعْقُوبْ أَذْ إِوصَّا إِحنْجِيرنْ نّسْ، إِكمّشْ إِضَارنْ نّسْ ذِي قَامَا، إِفّغْ إِ-ث بُوحْبڒْ ؤُشَا إِمَّارْنِي غَارْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","خنِّي إِنْڭزْ يُوسُوفْ خْ ؤُغمْبُوبْ ن بَابَاسْ، إِرُو خَاسْ ؤُشَا إِسُّوذمْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","يُومُورْ يُوسُوفْ إِ إِمْسخَّارنْ نّسْ، إِضْبِيبنْ، أَذْ حنّْضنْ بَابَاسْ ؤُشَا إِضْبِيبنْ حنّْضنْ إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","أَربْعِينْ ن وُوسَّانْ إِ ذَايسْ كِّينْ، مِينْزِي حْذَاجنْ ؤُسَّانْ نِّي مَاحنْذْ أَذْ كمّْڒنْ أَحنّطْ ؤُشَا رُونْ مَارَّا إِمِيصْرِييّنْ سبْعِينْ ن وُوسَّانْ ذِي سِّيبّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ؤُمِي عْذُونْ وُوسَّانْ ن ڒعْزَاثْ خَاسْ، إِسِّيوڒْ يُوسُوفْ أَكْ-ذ ينِّي ن ثَادَّارْثْ ن فِيرْعُونْ، إِنَّا: ”مَاڒَا ؤُفِيغْ ڒخُّو أَرْضَا ذِي ثِيطَّاوِينْ نْومْ، تّْزَاوَاڭغْ كنِّيوْ، أَذْ ثسِّيوْڒمْ ذڭْ إِمجَّانْ ن فِيرْعُونْ، إِنِيمْ: ");
INSERT INTO rifa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","”بَابَا إِنُو إِجَّا أَيِي أَذْ جَّادْجغْ ؤُشَا إِنَّا: ’أَقَا تّْمتِّيغْ. إِتّْخصَّا أَذْ أَيِي ثْنضْڒذْ ذڭْ ونْضڒْ نِّي نقْشغْ إِ يِيخفْ إِنُو ذِي ثمُّورْثْ ن كنْعَانْ!‘ خنِّي، تّْزَاوَاڭغْ، أجّْ أَيِي أَذْ رَاحغْ ڒخُّو أَذْ نضْڒغْ بَابَا ؤُشَا أَوَارْنِي مَانْ أَيَا أَذْ د -عقْبغْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ؤُشَا إِنَّا فِيرْعُونْ: ”رُوحْ، نْضڒْ بَابَاشْ، أَمْ مَامّشْ يَارَّا شكْ أَذْ أَسْ ثجُّودْجذْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ؤُشَا إِڭعّذْ يُوسُوفْ حِيمَا أَذْ إِنْضڒْ بَابَاسْ ؤُشَا ڭعّْذنْ مَارَّا إِمْسخَّارنْ ن فِيرْعُونْ أَكِيذسْ، إِمْغَارنْ ن ثَادَّارْثْ نّسْ ذ مَارَّا إِمْغَارنْ ن ثمُّورْثْ ن مِيصْرَا، ");
INSERT INTO rifa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ؤُڒَا ذ مَارَّا ثَادَّارْثْ ن يُوسُوفْ ذ أَيْثْمَاسْ نّسْ ذ ثَادَّارْثْ ن بَابَاسْ. مْغِيرْ إِحنْجِيرنْ إِمژْيَاننْ نْسنْ ذ وُودْجِي نْسنْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نْسنْ جِّينْ ثنْ ذِي ثمُّورْثْ ن جُوشَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ڭعّْذنْ أَكِيذسْ إِكَارُّوثنْ ذ يِينِّي إِنْيِينْ خْ ييْسَانْ ؤُشَا ڭِّينْ إِجّْ ن ؤُقَارُّو ن ڒْعسْكَارْ إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ؤُمِي إِوْضنْ غَارْ ؤُنذْرَارْ ن أَثَاذْ، ونِّي إِدْجَانْ خْ ؤُجمَّاضْ ن لْ-ؤُرْذُونْ، سّْڭعّْذنْ ذِينْ إِشْثْ ن ثْغُويِّيثْ ثمْغَارْ، ثجْهذْ أَطَّاسْ ؤُشَا إِڭَّا يُوسُوفْ ذِينْ إِجّْ ن وشْضَانْ خْ بَابَاسْ إِ يِيجّْ ن ڒْمِيجَاڒْ ن سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ژْرِينْ إِمزْذَاغْ ن ثمُّورْثْ، أَيْثْ ن كنْعَانْ، أَشْضَانْ ذڭْ ؤُنذْرَارْ ن أَثَاذْ، نَّانْ: ”وَا ذ أَشْضَانْ إِمْغَارْ ن إِمِيصْرِييّنْ.“ خْ ؤُيَا ڒَاغَانْ إِسمْ نّسْ أَبَالْ-مِيصْرَايِيمْ، ونِّي إِدْجَانْ خْ ؤُجمَّاضْ ن لْ-ؤُرْذُونْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ڭِّينْ أَسْ إِحنْجِيرنْ نّسْ أَمْ مَامّشْ ثنْ إِوصَّا. ");
INSERT INTO rifa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","أَرْبُونْ ث إِحنْجِيرنْ نّسْ غَارْ ثمُّورْثْ ن كنْعَانْ، نضْڒنْ ث ذڭْ إِفْرِي ذڭْ إِيَّارْ ن مَاكْفِيلَا نِّي إِسْغَا إِبْرَاهِيمْ أَكْ-ذ ييَّارْ زِي إِفْرُونْ، أَحِيتِّي، أَرنْذَاذْ ن مَامْرِي، مَاحنْذْ أَذْ يِيڒِي ذ أَنْضڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","أَوَارْنِي ڒَامِي إِنْضڒْ بَابَاسْ، إِعْقبْ يُوسُوفْ غَارْ مِيصْرَا، نتَّا ذ يَايْثْمَاسْ ذ مَارَّا إِنِّي أَكِيذسْ د-إِڭعّْذنْ، مَاحنْذْ أَذْ نضْڒنْ بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ؤُمِي ژْرِينْ أَيْثْمَاسْ ن يُوسُوفْ بَابَاثْسنْ إِمُّوثْ، نَّانْ: ”مَاڒَا إِشَارْهْ أَنغْ يُوسُوفْ، أَذْ أَنغْ إِخدْجصْ نِيشَانْ مَارَّا ڒْغَارْ نِّي ذَايسْ نڭَّا.“ ");
INSERT INTO rifa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","س ؤُينِّي سّكّنْ أَذْ خبَّارنْ يُوسُوفْ س مَانْ أَيَا، نَّانْ: ”بَابَاشْ إِوصَّا قْبڒْ ڒْموْثْ نّسْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","’أَمُّو إِ غَا ثِينِيمْ إِ يُوسُوفْ: تّْزَاوْڭغْ شكْ، غْفَارْ ڒخُّو أَخطُّو ن أَيْثْمَاشْ ذ دّنْبْ نْسنْ ذ ڒْغَارْ إِ ذ أَشْ ڭِّينْ. غْفَارْ ڒخُّو أَخطُّو ن إِمْسخَّارنْ ن أَربِّي ن بَابَاشْ!‘ “ ؤُشَا إِسْغُويْ يُوسُوفْ أَمْ كِيسْ سِّيوْڒنْ أَمُّو. ");
INSERT INTO rifa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","خنِّي ؤُسِينْ-د عَاوذْ أَيْثْمَاسْ س يِيخفْ نْسنْ، وْضَانْ أَسْ زَّاثْ إِ ؤُغمْبُوبْ نّسْ، نَّانْ: ”أَقَا-نغْ ذَا ذ إِمْسخَّارنْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","يَارَّا-د خَاسنْ يُوسُوفْ: ”وَارْ تّڭّْوْذمْ شَا! مَا أَقَا أَيِي نشّْ ذڭْ ومْشَانْ ن أَربِّي؟ ");
INSERT INTO rifa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","وَاخَّا كنِّيوْ ثْخَارّْصمْ ذَايِي س ڒْغَارْ، أَقَا أَربِّي إِنْوَا زَّايسْ ڒْخَارْ، حِيمَا أَذْ يڭّْ أَمْ مَامّشْ إِ ثدْجَا أَسّْ-أَ، أَذْ يجّْ ذِي ثُوذَارْثْ إِجّْ ن ڒْڭنْسْ ذ أَمقّْرَانْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ڒخُّو، وَارْ تّڭّْوْذمْ شَا! نشّْ أَذْ كنِّيوْعوّْڒغْ، كنِّيوْ ذ إِحنْجِيرنْ إِمژْيَاننْ نْومْ.“ أَمُّو ثنْ إِسّْفوّجْ ؤُشَا إِسِّيوڒْ أَكِيذْسنْ غَارْ وُوڒَاونْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ثُوغَا يُوسُوفْ إِزدّغْ ذِي مِيصْرَا، نتَّا ذ ثَادَّارْثْ ن بَابَاسْ، ؤُشَا إِدَّارْ يُوسُوفْ مْيَا ؤُ -عشْرَا ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","إِژْرَا يُوسُوفْ إِحنْجِيرنْ ن إِفْرَايِيمْ أَڒْ جِّيڒْ وِيسّْ ثْڒَاثَا. أَقَا تّْوَارْونْ-د إِحنْجِيرنْ ن مَاكِيرْ، مِّيسْ ن مَانَاسَّا، عَاوذْ خْ إِفَادّنْ ن يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ؤُشَا إِنَّا يُوسُوفْ إِ يَايْثْمَاسْ: ”نشّْ أَذْ مّْثغْ، مَاشَا أَربِّي أَذْ كنِّيوْ يَارْزفْ س ثِيذتّْ ؤُشَا أَذْ كنِّيوْ إِسّْڭعّذْ زِي ثمُّورْثْ-أَ غَارْ ثمُّورْثْ إِ إِوَاعْذْ س ثْجَادْجِيثْ إِ إِبْرَاهِيمْ ذ إِسْحَاقْ ذ يَاعْقُوبْ.“ ");
INSERT INTO rifa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","خَاسْ ؤُشَا إِسّْجِّيدْجْ يُوسُوفْ أَيْثْ ن إِسْرَائِيل، إِنَّا: ”أَربِّي أَذْ كنِّيوْ يَارْزفْ س ثِيذتّْ ؤُشَا خنِّي أَذْ ثكْسِيمْ سَّا إِغْسَانْ إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","إِمُّوثْ يُوسُوفْ ؤُمِي ثُوغَا غَارسْ مْيَا ؤُ -عشْرَا ن إِسڭّْوُوسَا. حنّْضنْ ث ؤُشَا سَّارْسنْ ث ذِي ڒْمحْمڒْ ن ؤُمتِّينْ ذِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","إِنَا ذ إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل إِ د-يِيوْضنْ أَكْ-ذ يَاعْقُوبْ غَارْ مِيصْرَا. يُوسَا-د كُوڒْ إِجّْ زَّايْسنْ أَكْ-ذ أَيْثْبَابْ ن ثَادَّارْثْ نّسْ:    ");
INSERT INTO rifa_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رُوبِينْ، شِيمْعُونْ، لَاوِي ذ يَاهُوذَا، ");
INSERT INTO rifa_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","إِسَّاكَارْ، زابُولُونْ ذ بِينْيَامِينْ، ");
INSERT INTO rifa_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ذَانْ ذ نَافْثَالِي، جَاذْ ذ أَشِيرْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","مَارَّا ڒعْمُورْ نِّي د-إِفّْغنْ زِي ثْمصَّاضْثْ ن يَاعْقُوبْ، ثُوغَا أَثنْ ذِي سبْعِينْ. يُوسُوفْ ثُوغَا-ث ذِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","إِمُّوثْ يُوسُوفْ ذ مَارَّا أَيْثْمَاسْ، ذ جِّيڒْ نِّي مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","مَّارنْينْ أَيْثْ ن إِسْرَائِيل ؤُ جِّينْ-د ڒْغِيدْجثْ أَڒَامِي زَّايْسنْ ثسْفُوفِّي ثمُّورْثْ ؤُشَا تّْوَاكْثَارنْ ؤُشَا ذوْڒنْ جهْذنْ أَطَّاسْ، مِينْزِي ثشُّورْ زَّايْسنْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","إِفّغْ-د خنِّي إِجّْ ن ؤُجدْجِيذْ ذ جْذِيذْ إِحكّمْ خْ مِيصْرَا، ونِّي ثُوغَا وَارْ إِسِّينْ يُوسُوفْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","إِنَّا إِ ڒْڭنْسْ نّسْ: ”خْزَارْ، ڒْڭنْسْ ن أَيْثْ ن إِسْرَائِيل إِمْغَارْ ؤُ إِجْهذْ خَانغْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ڒخُّو، أَقَا أَذْ خَاسْ نحْكمْ س ڒعْقڒْ، حِيمَا وَارْ إِتّْمَارْنِي ڒْڭنْسْ كْثَارْ، ؤُشَا، مَاڒَا إِمْسَارْ إِكَّارْ شَا ن ڒْبَارُوضْ، أَذْ إِذْوڒْ أَكْ-ذ ڒْعذْيَانْ نّغْ، أَذْ يڭّْ ڒْحَارْبْ أَكِيذْنغْ ؤُشَا خنِّي أَذْ إِفّغْ زِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","نِيثْنِي ڭِّينْ خَاسنْ إِمحْضَاينْ خْ وَارْبَارْ ن ثسْمُوغِي، حِيمَا أَذْ سّْذدْجنْ ڒْڭنْسْ س دّْقُوڒَاثْ إِ خَاسنْ سَّاربُّونْ. بْنَانْ إِ فِيرْعُونْ، أَجدْجِيذْ، ثِيندَّامْ ن ڒخْزنْ: فِيثُومْ ذ رَاعَامْسِيسْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","مَاشَا مشْحَاڒْ مَا ذدْجنْ نِيثْنِي ڒْڭنْسْ، أَمنِّي إِ إِڭْمَا ؤُ إِبزّعْ ڒْڭنْسْ، أَڒَامِي إِوْضنْ نِيثْنِي أَذْ شَارْهنْ أَيْثْ ن إِسْرَائِيل أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ؤُشَا أَرِّينْ إِمِيصْرِييّنْ أَيْثْ ن إِسْرَائِيل ذ إِسمْغَانْ س ؤُغِيڒْ ");
INSERT INTO rifa_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ؤُشَا سَّارزْڭنْ ثُوذَارْثْ نْسنْ س ثسْمُوغِي إِقسْحنْ ذڭْ ؤُبدْجَاعْ ذ لَّاجُورْ ؤُڒَا ذِي مَارَّا ثسْمُوغِي ذڭْ إِيَّارنْ. مَارَّا ثَاسْمُوغِي إِ ڭِّينْ نِيثْنِي ذِي ڒْْوسْثْ نْسنْ، ثُوغَا ت س ؤُغِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","إِسِّيوڒْ ؤُجدْجِيضْ ن مِيصْرَا أَكْ-ذ ڒْقَابْڒَاثْ ثِيعِيبْرَانِييِّينْ، إِشْثنْ زَّايْسنْثْ قَّارنْ أَسْ سِيفْرَا، ؤُ ثنّغْنِي قَّارنْ أَسْ فُوعَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","إِنَّا: ”خْمِي غَا ثْعَاوْننْثْ ثِيمْغَارِينْ ثِيعِيبْرَانِييِّينْ أَذْ أَرْونْثْ، ؤُشَا أَذْ ثخْزَارنْثْ خْمِي تّْغِيمَانْثْ خْ إِژْرَا مَاحنْذْ أَذْ أَرْونْثْ، إِتّْخصَّا كنِّينْثْ أَذْ نْغنْثْ أَحنْجِيرْ مَاڒَا ذ مِّيسْ، مَاشَا مَاڒَا ذ يدْجِيسْ، جّنْثْ ت أَذْ ثدَّارْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","مَاشَا ڒْقَابْڒَاثْ ثُوغَا تّڭّْوذنْثْ أَربِّي، وَارْ ڭِّينْثْ مُوخَاسْ ثنْثْ يُومُورْ ؤُجدْجِيذْ ن مِيصْرَا، مَاشَا حْضَانْثْ ثُوذَارْثْ ن إِحنْجِيرنْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","خنِّي إِڒَاغَا ؤُجدْجِيذْ ن مِيصْرَا إِ ڒْقَابْڒَاثْ، إِنَّا أَسنْثْ: ”مَاغَارْ ثڭِّينْثْ أَيَا، أَقَا ثحْضَانْثْ ثُوذَارْثْ ن إِحنْجِيرنْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ڒْقَابْڒَاثْ أَرِّينْثْ خْ فِيرْعُونْ: ”ثِيعِيبْرَانِييِّينْ وَارْ دْجِينْثْ أَمْ ثِيمِيصْرِييِّينْ، مِينْزِي نِيثنْثِي جهْذنْثْ، تَّارْونْثْ قْبڒْ مَا أَذْ غَارْسنْثْ د-ثَاسْ ڒْقَابْڒَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ؤُشَا أَربِّي إِڭَّا مْلِيحْ إِ ڒْقَابْڒَاثْ ؤُشَا إِمَّارْنِي ڒْڭنْسْ، ذوْڒنْ جهْذنْ س وَاطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","مِينْزِي ڒْقَابْڒَاثْ ڭّْوذنْثْ أَربِّي، إِمْسَارْ، أَقَا يَارْزقْ إِ-ثنْثْ-إِ-د س ثُوذْرِينْ أَكْ-ذ ڒْوَاشُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ڒخْذنِّي يُومُورْ فِيرْعُونْ مَارَّا ڒْڭنْسْ نّسْ، إِنَّا: ”كُوڒْ أَحنْجِيرْ إِ د غَا إِخڒْقنْ أَذْ ث ثنْضَارمْ ذڭْ إِغْزَارْ ؤُ مَارَّا ثَاحنْجِيرْثْ إِ د غَا إِخڒْقنْ أَذْ ت ثجّمْ أَذْ ثدَّارْ.“   * ");
INSERT INTO rifa_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ؤُشَا إِفّغْ إِجّْ ن ورْيَازْ زِي رَادْجْ ن ثَادَّارْثْ ن لَاوِي، يِيوِي إِشْثْ ن ثْحنْجِيرْثْ ن لَاوِي ذ ثَامْغَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ثكْسِي ثمْغَارْثْ س دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ. ؤُمِي ثژْرَا بلِّي إِصْبحْ ؤُحنْجِيرْ، ثفَّارْ إِ-ث ثْڒَاثَا ن إِيُورنْ.    ");
INSERT INTO rifa_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ؤُمِي وَارْ ثزْمَارْ عَاذْ أَذْ ث ثفَّارْ، ثكْسِي أَسْ-د إِشْثْ ن ثْسنْذُوقْثْ ن ؤُغَانِيمْ، ثبْرَا إِ-ت س ؤُشَارْمُوضْ ذ ثِيزفْثْ ؤُشَا ثسَّارْسْ ذَايسْ أَحنْجِيرْ، ثڭَّا ثَاسنْذُوقْثْ نِّي جَارْ ؤُغَانِيمْ خْ ثْمَا ن إِغْزَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ثْبدّْ وُوتْشْمَاسْ غَارْ ڒَاڭّْوَاجْ، مَاحنْذْ أَذْ ثْژَارْ مِينْ زَّايسْ غَا ڭّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ؤُ خْزَارْ، ثهْوَا يدْجِيسْ ن فِيرْعُونْ، مَاحنْذْ أَذْ ثسِّيرْذْ إِخفْ نّسْ ذڭْ إِغْزَارْ. ثُوغَا ثِيمْسخَّارِينْ ثِيبْڒِيغِينْ نّسْ ڭُّورنْثْ خْ ثْمَا ن إِغْزَارْ. نتَّاثْ ثژْرَا ثَاسنْذُوقْثْ ذڭْ ؤُغَانِيمْ ؤُشَا ثسّكّْ ثِيسْمغْثْ نّسْ ؤُشَا ثكْسِي ت-إِ-د. ");
INSERT INTO rifa_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","أَڒَامِي ت ثَارْزمْ، ثژْرَا أَحنْجِيرْ نِّي، ؤُشَا خْزَارْ، أَحنْجِيرْ ثُوغَا إِتّْرُو. يُوذفْ إِ-ت ؤُزِيدْجزْ، ثنَّا: ”وَا ذ إِجّْ زڭْ إِحنْجِيرنْ ن إِعِيبْرَانِييّنْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ڒخْذنِّي ثنَّا ؤُتْشْمَاسْ إِ يدْجِيسْ ن فِيرْعُونْ: ”مَا أَذْ رَاحغْ أَذْ ڒَاغِيغْ خْ إِشْثْ ن ثمْسُوضضْثْ زِي ثْعِيبْرَانِييِّينْ مَاحنْذْ أَذْ أَمْ ثسُّوطّضْ أَحنْجِيرْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ثنَّا أَسْ يدْجِيسْ ن فِيرْعُونْ: ”رُوحْ!“ ثْرُوحْ ثعْزَارشْثْ، ثْڒَاغَا إِ يمَّاسْ ن ؤُحنْجِيرْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ڒخْذنِّي ثنَّا أَسْ يدْجِيسْ ن فِيرْعُونْ: ”أَوِي-د أَحنْجِيرْ-أَ، ثسُّوطّضْ إِ-ث إِ نشّْ ؤُ نشّْ أَذْ شمْ خدْجْصغْ.“ ثكْسِي ثمْغَارْثْ أَحنْجِيرْ ؤُشَا ثسُّوطّضْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ؤُمِي إِڭْمَا ؤُحنْجِيرْ، ثِيوْيِي إِ-ث غَارْ يدْجِيسْ ن فِيرْعُونْ، إِذْوڒْ أَسْ أَمْ مِّيسْ ؤُشَا ثڭَّا أَسْ مُوسَا، ثنَّا: ”أَقَا جبْذغْ ث-إِ-د زڭْ وَامَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ذڭْ وُوسَّانْ نِّي إِمْسَارْ، ؤُمِي إِڭْمَا مُوسَا، أَقَا إِفّغْ-د غَارْ أَيْثْمَاسْ، ؤُشَا إِژْرَا دّْقُوڒَاثْ إِ خَاسنْ سَّاربُّونْ. إِژْرَا إِجّْ ن ؤُمِيصْرِي إِشَّاثْ إِجّْ ن ؤُعِيبْرَانِي، إِجّنْ زڭْ أَيْثْمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","إِخْزَارْ ذَا ذ ذِيهَا، إِژْرَا بلِّي وَارْ ذِينْ حذْ، خنِّي إِنْغَا أَمِيصْرِي نِّي ؤُشَا إِسّْنُوفَّارْ إِ-ث ذڭْ إِجْذِي. ");
INSERT INTO rifa_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ؤُمِي د-إِفّغْ ثِيوشَّا نّسْ، إِژْرَا ثْنَاينْ ن يرْيَازنْ إِعِيبْرَانِييّنْ تّْمنْغَانْ. إِنَّا مُوسَا إِ ؤُعفَّانْ نِّي إِتّْعدَّانْ: ”مَاغَارْ ثشَّاثذْ جَّارْ نّشْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","إِنَّا نتَّا: ”وِي إِ شكْ إِڭِّينْ ذ ڒْحَاكمْ ذ ڒْقَاضِي خَانغْ؟ مَا شكْ ثقَّارذْ أَيَا ؤُمِي شكْ ثنْوِيذْ أَذْ أَيِي ثنْغذْ أَمْ مَامّشْ ثنْغِيذْ أَمِيصْرِي؟“ ڒخْذنِّي إِڭّْوذْ مُوسَا، إِنَّا: ”س ثِيذتّْ ثَامسْڒَاشْثْ ثتّْوَاسّنْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ؤُمِي إِسْڒَا فِيرْعُونْ مَانْ أَيَا، يَارْزُو أَذْ إِنغْ مُوسَا. مَاشَا مُوسَا يَارْوڒْ زِي فِيرْعُونْ ؤُشَا إِزْذغْ ذِي ثمُّورْثْ ن مِيذْيَانْ ؤُشَا إِقِّيمْ ذِينْ غَارْ إِجّْ ن وَانُو. ");
INSERT INTO rifa_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","أَكهَّانْ ن مِيذْيَانْ ثُوغَا غَارسْ سبْعَا ن يسِّيسْ، ثِينِّي إِ د-يُوسِينْ أَذْ أَيْمنْثْ أَمَانْ ذِينْ ؤُشَا شُّورنْثْ سّْوَارجْ، حِيمَا أَذْ وَارْذنْثْ ؤُدْجِي ن بَابَاثْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ؤُسِينْ-د إِمكْسَاونْ ؤُشَا ؤُژّْڒنْ خَاسنْثْ. إِكَّارْ مُوسَا ڒخْذنِّي، إِفكّْ إِ-ثنْثْ، إِوَارْذْ ؤُدْجِي نْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ؤُمِي ذوْڒنْثْ غَارْ بَابَاثْسنْثْ ؤُمِي قَّارنْ رَاعُويِيلْ، إِنَّا أَسنْثْ: ”مَايمِّي د-تّْعقْبنْثْ أَسّْ-أَ ذغْيَا؟“ ");
INSERT INTO rifa_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","نِيثنْثِي أَرِّينْثْ-إِ-د خَاسْ: ”إِجّْ ن ورْيَازْ ذ أَمِيصْرِي إِفكّْ أَنغْ زڭْ إِفَاسّنْ ن إِمكْسَاونْ ؤُشَا عَاوذْ يُويمْ أَنغْ-د أَطَّاسْ ن وَامَانْ ؤُشَا إِوَارْذْ ؤُدْجِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","إِنَّا إِ يسِّيسْ: ”إِ مَانِي يدْجَا؟ مَايمِّي ثجِّينْثْ أَرْيَازْ نِّي ذِينْ؟ رُوحنْثْ ڒَاغَانْثْ-إِ-د خَاسْ حِيمَا أَذْ إِشّْ أَغْرُومْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ؤُشَا إِقْبڒْ مُوسَا أَذْ إِزْذغْ أَكْ-ذ ورْيَازْ نِّي ؤُشَا نتَّا إِوْشَا أَسْ إِ مُوسَا يدْجِيسْ صَافُّورَا ذ ثَامْغَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ثجَّا أَسْ-د أَحنْجِيرْ، إِڭَّا أَسْ جَارْشُومْ، مِينْزِي إِنَّا: ”نشّْ ثُوغَا أَيِي ذ أَغْرِيبْ ذڭْ إِشْثْ ن ثمُّورْثْ ذ ثَاغْرِيبْثْ خَافِي.“    ");
INSERT INTO rifa_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ڒَامِي ثعْذُو وَاطَّاسْ ن ڒْوقْثْ، إِمُّوثْ ؤُجدْجِيذْ ن مِيصْرَا ؤُشَا وحْوحنْ أَيْثْ ن إِسْرَائِيل ذِي ثسْمُوغِي إِ ذِي ثُوغَا دَّارنْ، سّْغُوينْ ؤُشَا إِغُويَّانْ نْسنْ ڭعّْذنْ غَارْ أَربِّي زِي ثسْمُوغِي نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ؤُشَا إِسّْحسّْ أَربِّي إِ ثْغُويِّيثْ نْسنْ ؤُشَا إِخَارّصْ أَربِّي ذِي ڒْعَاهْذْ نّسْ أَكْ-ذ إِبْرَاهِيمْ ؤُ أَكْ-ذ إِسْحَاقْ ؤُ أَكْ-ذ يَاعْقُوبْ. ");
INSERT INTO rifa_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","إِخْزَارْ أَربِّي غَارْ أَيْثْ ن إِسْرَائِيل ؤُشَا يَارْڭبْ أَربِّي خْ ڒغْبنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","يَارْوسْ مُوسَا ؤُدْجِي ن يِيثْرُو، أَضڭّْوَاڒْ نّسْ، أَكهَّانْ ن مِيذْيَانْ. إِنْذهْ ؤُدْجِي أَوَارْنِي إِ ڒخْڒَا ؤُشَا يِيوِيضْ-د غَارْ وذْرَارْ ن أَربِّي، غَارْ حُورِيبْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","إِبَانْ أَسْ-د لْمَالَاكْ ن سِيذِي ذڭْ إِجّْ ن ؤُشعُّوڒْ ذِي ڒْوسْطْ ن إِجّْ ن شْبَارْقْ أَكْ-ذ إِسنَّاننْ، ؤُ خْزَارْ، نتَّا إِژْرَا بلِّي شْبَارْقْ أَكْ-ذ إِسنَّاننْ ثُوغَا ثكَّارْ ذَايسْ ثْمسِّي، مَاشَا شْبَارْقْ وَارْ إِتّْوَاشْمضْ شَا. ");
INSERT INTO rifa_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","إِنَّا مُوسَا: ”أجّْ أَيِي أَذْ قوْسغْ شْوَايْثْ، مَاحنْذْ أَذْ ژَترغْ ثَامژْرِيوْثْ نِّي ثَامقّْرَانْثْ، مَايمِّي شْبَارْقْ أَكْ-ذ إِسنَّاننْ وَارْ إِشمّضْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ڒَْامِي إِژْرَا أَربِّي بلِّي إِجَّا أَبْرِيذْ، مَاحنْذْ أَذْ إِژَارْ مَانْ أَيَا، إِڒَاغَا-د خَاسْ أَربِّي زِي ڒْوسْطْ ن شْبَارْقْ أَكْ-ذ إِسنَّاننْ، إِنَّا: ”مُوسَا، مُوسَا!“ نتَّا يَارَّا: ”أَقَا أَيِي ذَا!“ ");
INSERT INTO rifa_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","خنِّي إِنَّا نتَّا: ”وَارْ د-تّْقَارَّابْ شَا ذَانِيثَا! كّسْ ثِيسِيڒَا نّشْ زڭْ إِضَارنْ نّشْ، مِينْزِي أَمْشَانْ إِ خفْ ثْبدّذْ، أَقَا-ث ذ ثَامُّورْثْ ثْقدّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","إِنَّا عَاوذْ: ”نشّْ ذ أَربِّي ن بَابَاشْ، أَربِّي ن إِبْرَاهِيمْ، أَربِّي ن إِسْحَاقْ ذ أَربِّي ن يَاعْقُوبْ.“ ڒخْذنِّي إِسّْذُورِييْ مُوسَا أَغمْبُوبْ نّسْ، مِينْزِي إِڭّْوذْ أَذْ إِسْوضْ ذِي أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","إِنَّا سِيذِي: ”أَقَا ژْرِيغْ ڒْمحْنثْ إِ ذِي إِدَّارْ ڒْڭنْسْ إِنُو إِ إِدْجَانْ ذِي مِيصْرَا ؤُشَا سْڒِيغْ إِغُويَّانْ نْسنْ زَّاثْ إِ إِمْزيَّارنْ نْسنْ، أَقَا سّْنغْ ثَامَارَا نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","هْوِيغْ-د حِيمَا أَذْ فكّغْ ڒْْڭنْسْ زڭْ إِفَاسّنْ ن إِمِيصْرِييّنْ، أَذْ ث سُّوفّْغغْ زِي ثمُّورْثْ نِّي غَارْ إِشْثْ ن ثمُّورْثْ ثصْبحْ ذ ثْمِيرِيوْثْ، غَارْ إِشْثْ ن ثمُّورْثْ إِفيّْضنْ س ؤُغِي ذ ثَامّنْثْ، غَارْ ومْشَانْ ن أَيْثْ ن كنْعَانْ ذ إِحِيتِّييّنْ ذ إِمُورِييّنْ ذ إِفِيرِيزِييّنْ ذ إِحِيوِييّنْ ذ إِيِيبُوسِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","خْزَارْ ڒخُّو، أَقَا ثِيوضْ-د غَارِي ثْغُويِّيثْ ن أَيْثْ ن إِسْرَائِيل ؤُشَا عَاوذْ ژْرِيغْ دّدْجْ نْسنْ إِ زِي ثنْ ذدْجنْ إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ڒخُّو خنِّي، رُوحْ، نشّْ أَذْ شكْ سّكّغْ غَارْ فِيرْعُونْ ؤُ شكْ أَذْ ثْسُوفّْغذْ ڒْڭنْسْ إِنُو، أَيْثْ ن إِسْرَائِيل، زِي مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","خنِّي إِنَّا مُوسَا إِ أَربِّي: ”مِينْ عْنِيغْ نشّْ أَڒَامِي غَا رَاحغْ غَارْ فِيرْعُونْ، أَذْ سُّوفّْغغْ أَيْثْ ن إِسْرَائِيل زِي مِيسْرَا؟“ ");
INSERT INTO rifa_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","نتَّا إِنَّا أَسْ: ”نشّْ أَذْ كِيكْ إِڒِيغْ ؤُ ثَانِيثَا أَذْ أَشْ ثِيڒِي ذ ڒعْڒَامثْ، بلِّي نشّْ سّكّغْ-د شكْ: خْ مِينِّي إِ غَا ثسُّوفّْغذْ ڒْڭنْسْ-أَ زِي مِيصْرَا، أَذْ ثْعبْذمْ أَربِّي خْ وذْرَارْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","خنِّي إِنَّا مُوسَا إِ أَربِّي: ”خْزَارْ، خْمِي د غَا أَوْضغْ نشّْ غَارْ أَيْثْ ن إِسْرَائِيل، أَذْ أَسنْ إِنِيغْ: ’أَربِّي ن ڒجْذُوذْ نْومْ إِسّكّْ أَيِي-د غَارْومْ!‘، ؤُشَا نِيثْنِي أَذْ أَيِي سّقْسَانْ: ’مَامّشْ ذ أَسْ قَّارنْ؟‘، مِينْ ذ أَسنْ غَا إِنِيغْ خنِّي؟“ ");
INSERT INTO rifa_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","إِنَّا أَربِّي إِ مُوسَا: ”نشّْ ذ نشّْ إِ دْجِيغْ“. ؤُشَا إِنَّا عَاوذْ: ”أَمُّو إِ غَا ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل: نشّْ ذ نشّْ إِ دْجِيغْ! أَقَا نتَّا ذ ونِّي ذ أَيِي د-إِسّكّنْ غَارْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","إِنَّا أَربِّي عَاوذْ إِ مُوسَا: ”أَمُّو إِ غَا ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل: ’سِيذِي، أَربِّي ن ڒجْذُوذْ نْومْ، أَربِّي ن إِبْرَاهِيمْ ذ أَربِّي ن إِسْحَاقْ ذ أَربِّي ن يَاعْقُوبْ، إِسّكّْ أَيِي-د غَارْومْ. ذ وَا ذ إِسمْ إِنُو إِ ڒبْذَا ؤُ يِيسمْ وَانِيثَا أَذْ يِيڒِي إِ ڒِيذَارثْ ذَايِي زِي جِّيڒْ أَڒْ جِّيڒْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","رُوحْ، ثسّْمُونذْ إِمْغَارنْ ن إِسْرَائِيل، إِنِي أَسنْ: ’سِيذِي، أَربِّي ن ڒجْذُوذْ نْومْ، أَربِّي ن إِبْرَاهِيمْ ذ إِسْحَاقْ ذ يَاعْقُوبْ إِبَانْ أَيِي-د، إِنَّا: ’أَقَا خَاومْ حِينّغْ ؤُشَا ژْرِيغْ مِينْ خَاومْ سّعْذُونْ ذِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","نِّيغْ: نشّْ أَذْ كنِّيوْ سُّوفّْغغْ زِي ڒْمحْنثْ ذِي مِيصْرَا غَارْ ثمُّورْثْ ن أَيْثْ ن كنْعَانْ ذ إِحِيتِّييّنْ ذ إِمُورِييّنْ ذ إِفِيرِيزِييّنْ ذ إِحِيوِييّنْ ذ إِيِيبُوسِييّنْ، غَارْ إِشْثْ ن ثمُّورْثْ إِفيّْضنْ س ؤُغِي ذ ثَامّنْثْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","أَذْ سْڒنْ إِ ثْمِيجَّا نّشْ، ؤُشَا أَذْ ثْرَاحذْ، شكْ ذ إِمْغَارنْ ن إِسْرَائِيل، غَارْ ؤُجدْجِيذْ ن مِيصْرَا، أَذْ أَسْ ثِينِيمْ: ’سِيذِي، أَربِّي ن إِعِيبْرَانِييّنْ، إِمْسَاڭَارْ أَكِيذْنغْ. خنِّي ڒخُّو، أجّْ أَنغْ أَذْ نطّفْ أَبْرِيذْ ثِيشْڒِي ن ثْڒَاثَا ن وُوسَّانْ ذِي ڒخْڒَا، حِيمَا أَذْ نْقدّمْ ثِيغَارْصَا إِ سِيذِي، أَربِّي نّغْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","مَاشَا نشّْ سّْنغْ بلِّي أَجدْجِيذْ ن مِيصْرَا وَارْ كنِّيوْ إِتّجِّي أَذْ ثْرَاحمْ ؤُڒَا س ؤُفُوسْ إِجهْذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","خنِّي أَذْ سّْوِيژّْضغْ أَفُوسْ إِنُو، أَذْ وْثغْ مِيصْرَا س مَارَّا لْمُوعْجِيزَاثْ إِنُو إِ ذَايسْ إِ غَا ڭّغْ ذِي ڒْوسْطْ نّسْ، ؤُشَا أَوَارْنِي إِ مَانْ أَيَا، نتَّا أَذْ كنِّيوْ يجّْ أَذْ ثْرَاحمْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","أَذْ حِينّغْ خْ ڒْڭنْسْ-أَ زَّاثْ إِ ثِيطَّاوِينْ ن إِمِيصْرِييّنْ ؤُشَا أَذْ إِمْسَارْ، خْمِي غَا ثْرَاحمْ، وَارْ ثتّفّْغمْ شَا س إِفَاسّنْ خْوَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","أَذْ ثتَّارْ كُوڒْ ثَامْغَارْثْ زِي ثَاجَّارْثْ نّسْ ؤُ زِي ثْبَارَّانِيثْ نِّي أَكِيذسْ إِزدّْغنْ ذِي ثَادَّارْثْ، ڒقْشُوعْ ن نُّوقَارْثْ ذ وُورغْ ذ وَارُّوضْ، ؤُشَا كنِّيوْ أَذْ ثنْ ثڭّمْ خْ إِحنْجِيرنْ ذ ثْحنْجِيرِينْ نْومْ، ؤُشَا أَمُّو إِ غَا ثْكشّْضمْ مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","خنِّي يَارَّا-د مُوسَا، إِنَّا: ”خْزَارْ، نِيثْنِي وَارْ ذَايِي تِّيمْننْ شَا ؤُشَا وَارْ تّسْڒِينْ شَا إِ وَاوَاڒْ إِنُو، مِينْزِي أَذْ إِنِينْ: ’سِيذِي وَارْ ذ أَشْ د-إِبَانْ شَا!‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","خنِّي إِنَّا أَسْ سِيذِي: ”مِينْ غَاركْ ذڭْ ؤُفُوسْ نّشْ؟“ ؤُشَا يَارَّا-د: ”ذ ثَاغَّارْشْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","إِنَّا: ”نْضَارْ إِ-ت خْ ثمُّورْثْ!“ إِنْضَارْ إِ-ت خْ ثمُّورْثْ، ثذْوڒْ ذ إِجّْ ؤُفِيغَارْ ؤُشَا يَارْوڒْ مُوسَا زَّايسْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا: ”سْوِيژّضْ أَفُوسْ نّشْ، طّفْ إِ-ت زڭْ ؤُنوَّارْ نّسْ ...“ - ؤُشَا إِسّْوِيژّضْ مُوسَا أَفُوسْ نّسْ، إِطّفْ إِ-ت ؤُشَا ثذْوڒْ عَاوذْ ذ ثَاغَّارْشْثْ ذڭْ ؤُفُوسْ نّسْ - ");
INSERT INTO rifa_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","”... حِيمَا أَذْ أَمْننْ بلِّي أَقَا إِبَانْ أَشْ-د سِيذِي، أَربِّي ن ڒجْذُوذْ نْسنْ، أَربِّي ن إِبْرَاهِيمْ، أَربِّي ن إِسْحَاقْ ذ أَربِّي ن يَاعْقُوبْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","إِنَّا أَسْ سِيذِي عَاوذْ: ”سِيذفْ أَفُوسْ نّشْ ذڭْ وحْسِينْ نّشْ.“ ؤُشَا إِسِّيذفْ أَفُوسْ نّسْ ذڭْ وحْسِينْ ؤُشَا ؤُمِي ث-إِ-د-إِكّسْ، خْزَارْ، أَفُوسْ نّسْ إِبَارْصْ أَمْ وذْفڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ؤُشَا إِنَّا: ”أَرّْ أَفُوسْ نّشْ عَاوذْ ذڭْ وحْسِينْ!“ يَارَّا أَفُوسْ نّسْ ذڭْ وحْسِينْ ؤُشَا إِعْقبْ إِسُّوفّغْ إِ-ث-إِ-د عَاوذْ زڭْ وحْسِينْ، ؤُشَا خْزَارْ، إِذْوڒْ عَاوذْ أَمْ مِينْ إِقِّيمنْ ن أَرِّيمثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","”مَاڒَا وَارْ زَّايكْ ؤُمِيننْ شَا ؤُ وَارْ غَاركْ د-تّسْڒِينْ إِ مِينْ ذ أَسنْ إِ غَا ثِينِي ڒعْڒَامثْ ثَامزْوَارُوثْ، خنِّي أَذْ أَمْننْ ذِي مِينْ ذ أَسنْ غَا ثِينِي ڒعْڒَامثْ ثَانڭَّارُوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","مَاڒَا نِيثْنِي وَارْ ؤُمِيننْ شَا ذِي ثْنَاينْ ن ڒعْڒَامَاثْ-أَ ؤُ وَارْ ذ أَشْ سْڒِينْ شَا، خنِّي كْسِي أَمَانْ ن إِغْزَارْ ؤُشَا فَارّغْ إِ-ثنْ خْ ڒَاژَاغْ ؤُ أَمَانْ نِّي ثكْسِيذْ زڭْ إِغْزَارْ أَذْ ذوْڒنْ ذ إِذَامّنْ خْ ڒَاژَاغْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ڒخْذنِّي إِنَّا مُوسَا إِ سِيذِي: ”أَ سِيذِي إِنُو!، نشّْ وَارْ دْجِيغْ شَا ذ أَرْيَازْ ن بُو-ثَاوَاڒِينْ، إِضنَّاضْ لَّا، ؤُڒَا ذ فَارِيضنَّاضْ لَّا ؤُ زڭْ وَامِي ثبْذِيذْ أَذْ ثسِّيوْڒذْ أَكْ-ذ ؤُمْسخَّارْ نّشْ لَّا، مِينْزِي نشّْ غَارِي أَقمُّومْ إِذقْڒنْ ذ إِڒسْ إِذقْڒنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","إِنَّا أَسْ سِيذِي: ”وِي إِوْشِينْ أَقمُّومْ إِ بْنَاذمْ؟ نِيغْ وِي إِڭِّينْ حذْ ذ أَزِييْنُونْ نِيغْ ذ أَذهْشُورْ نِيغْ ذ ونِّي إِتّْوَاڒَانْ نِيغْ ذ أَذَارْغَاڒْ؟ مَا وَارْ إِدْجِي ذ نشّْ، سِيذِي؟ ");
INSERT INTO rifa_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ڒخُّو، رُوحْ ذِينْ، أَذْ إِڒِيغْ أَكْ-ذ ؤُقمُّومْ نّشْ، أَذْ أَشْ سّشْنغْ مْلِيحْ مِينْ غَا ثِينِيذْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","مَاشَا نتَّا إِنَّا: ”أَ سِيذِي إِنُو، سكّْ س ؤُفُوسْ نّشْ مَانْ ونْ إِ ثخْسذْ أَذْ ثسّكّذْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ڒخْذنِّي إِتّْوَاسَّارْغْ وغْضَابْ ن سِيذِي خْ مُوسَا، إِنَّا: ”مَا وَارْ إِدْجِي هَارُونْ، أَلَاوِي، ذ ؤُمَاشْ؟ نشّْ سّْنغْ، أَقَا نتَّا إِسّنْ أَذْ إِسِّيوڒْ. خْزَارْ، أَقَا أَذْ كِيشْ إِمْسَاڭَارْ ؤُ خْمِي شكْ غَا إِژَارْ، أَذْ إِفَارْحْ وُوڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ؤُشَا شكْ أَذْ كِيسْ ثسِّيوْڒذْ، أَذْ أَسْ ثڭّذْ أَوَاڒنْ ذڭْ ؤُقمُّومْ نّسْ. ڭُّورْ أَذْ إِڒِيغْ أَكْ-ذ ؤُقمُّومْ نّشْ ذ ؤُقمُّومْ نّسْ، أَذْ أَومْ سّْغَارغْ مِينْ غَا ثِينِيمْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","نتَّا أَذْ إِسِّيوڒْ أَكْ-ذ ڒْڭنْسْ ذڭْ ومْشَانْ نّشْ. أَذْ إِمْسَارْ أَمُّو: نتَّا أَذْ أَشْ يِيڒِي أَمشْنَاوْ أَقمُّومْ نّشْ ؤُ شكْ أَذْ ثِيڒِيذْ إِ نتَّا أَمشْنَاوْ أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","أَذْ ثكْسِيذْ ثَاغَّارْشْثْ-أَ إِ زِي غَا ثڭّذْ ڒعْڒَامَاثْ ذڭْ ؤُفُوسْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","إِرُوحْ مُوسَا ؤُشَا إِذْوڒْ غَارْ ؤُضڭّْوَاڒْ نّسْ يِيثْرُو، إِنَّا أَسْ: ”أجّْ أَيِي أَذْ رَاحغْ، أَذْعقْبغْ غَارْ أَيْثْمَا نِّي إِدْجَانْ ذِي مِيصْرَا، حِيمَا أَذْ ژَترغْ، مَا عَاذْ دَّارنْ.“ إِنَّا يِيثْرُو إِ مُوسَا: ”رُوحْ ذِي ڒهْنَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","إِنَّا سِيذِي عَاوذْ إِ مُوسَا ذِي مِيذْيَانْ: ”ڒُْوحْ، ثْذوْڒذْ غَارْ مِيصْرَا، مِينْزِي أَقَا مُّوثنْ مَارَّا إِنِّي ثُوغَا يَارزُّونْ ڒْموْثْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","إِكْسِي مُوسَا ثَامْغَارْثْ نّسْ ذ إِحنْجِيرنْ نّسْ ؤُشَا إِسّنْيَا إِ-ثنْ خْ وغْيُوڒْ، إِذْوڒْ-د غَارْ ثمُّورْثْ ن مِيصْرَا ؤُشَا إِكْسِي مُوسَا ثَاغَّارْشْثْ ن أَربِّي ذڭْ ؤُفُوسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","إِنَّا سِيذِي إِ مُوسَا: ”خْمِي غَا ثْرَاحذْ، أَذْ د-ثْذوْڒذْ عَاوذْ غَارْ مِيصْرَا، خْزَارْ أَذْ ثڭّذْ إِ فِيرْعُونْ مَارَّا لْمُوعْجِيزَاثْ نِّي ذ أَشْ ڭِّيغْ ذڭْ ؤُفُوسْ نّشْ. مَاشَا نشّْ أَذْ سّْقسْحغْ ؤُڒْ نّسْ، ڒَامِي وَارْ إِخْسْ أَذْ إِضْڒقْ إِ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","خنِّي أَذْ ثِينِيذْ إِ فِيرْعُونْ: ’أَمُّو إِ إِقَّارْ سِيذِي: إِسْرَائِيل ذ مِّي ذ أَمنْزُو إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","أَقَا نِّيغْ أَشْ: أجّْ أَذْ إِفّغْ مِّي أَذْ أَيِي إِعْبذْ! مَاشَا شكْ ثُوڭِيذْ أَذْ ث ثجّذْ. خْزَارْ، نشّْ أَذْ نْغغْ مِّيشْ، أَمنْزُو نّشْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","إِمْسَارْ ذڭْ وبْرِيذْ، ذڭْ إِجّْ ن ومْشَانْ مَانِي غَا سّنْسنْ، إِمّڒْقَا سِيذِي أَكِيذسْ ؤُ نتَّا ثُوغَا إِخْسْ أَذْ ث إِنغْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ڒخْذنِّي ثكْسِي صَافُّورَا إِشْثْ ن ثْخذْمشْثْ ن وژْرُو، ثخْثنْ ڒعْذَاڒْيثْ ن مِّيسْ ؤُشَا ثڒْقفْ أَسْ إِضَارنْ نّسْ، ثنَّا: ”س ثِيذتّْ شكْ ثدْجِيذْ أَمْ يِيجّْ ن يسْڒِي ن إِذَامّنْ إِ نشّْ“ ");
INSERT INTO rifa_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","إِجَّا إِ-ث خنِّي. ڒخْضنِّي ثنَّا: ”شكْ ذ إِسْڒِي ن إِذَامّنْ إِ ثدْجِيذْ!“، ذِي سِّيبّثْ ن إِخْثَاننْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","إِنَّا سِيذِي إِ هَارُونْ: ”رُوحْ أَذْ ثڒْقِيذْ مُوسَا ذِي ڒخْڒَا!“ ؤُشَا إِرُوحْ، إِمْسَاڭَارْ أَكِيذسْ غَارْ وذْرَارْ ن أَربِّي، إِسُّوذمْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","إِخبَّارْ مُوسَا هَارُونْ خْ مَارَّا أَوَاڒنْ إِ ذ أَسْ إِنَّا سِيذِي ونِّي إِ-ث-إِ-د-إِسّكّنْ ؤُڒَا خْ مَارَّا ڒعْڒَامَاثْ إِ ذ أَسْ يُومُورْ أَذْ إِڭّْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","خنِّي إِرُوحْ مُوسَا ذ هَارُونْ، سّْمُوننْ مَارَّا إِمْغَارنْ ن أَيْثْ ن إِسْرَائِيل، ");
INSERT INTO rifa_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ؤُشَا إِسِّيوڒْ هَارُونْ س مَارَّا أَوَاڒنْ إِ ثُوغَا إِنَّا سِيذِي إِ مُوسَا ؤُشَا إِڭَّا ڒعْڒَامَاثْ قِيبَاتْشْ إِ ثِيطَّاوِينْ ن ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ؤُشَا يُومنْ زَّايْسنْ ڒْڭنْسْ، سْڒِينْ بلِّي سِيذِي إِزِّيدْجزْ أَسْ أَيْثْ ن إِسْرَائِيل ؤُمِي إِژْرَا ڒْمحْنثْ إِ ذِي دْجَانْ، ؤُضَارنْ ؤُشَا بنْذْقنْ أَسْ. ");
INSERT INTO rifa_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","أَوَارْنِي مَانْ أَيَا يُوذفْ مُوسَا ذ هَارُونْ غَارْ فِيرْعُونْ، نَّانْ أَسْ: ”أَمُّو إِ إِقَّارْ سِيذِي، أَربِّي ن إِسْرَائِيل: ’أجّْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو، حِيمَا أَذْ أَيِي إِعيّذْ ذِي ڒخْڒَا!‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","مَاشَا فِيرْعُونْ إِنَّا: ”مِينْ إِعْنَا سِيذِي ؤُمِي غَا سْڒغْ إِ وَاوَاڒْ نّسْ ؤُشَا أَذْ جّغْ إِسْرَائِيل أَذْ إِفّغْ. نشّْ وَارْ سِّينغْ سِيذِي ؤُ وَارْ تّجِّيغْ أَذْ إِرَاحْ إِسْرَائِيل.“    ");
INSERT INTO rifa_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","نِيثْنِي نَّانْ: ”أَربِّي ن إِعِيبْرَانِييّنْ إِمْسَاڭَارْ أَكِيذْنغْ، أجّْ أَنغْ خنِّي أَذْ نْرَاحْ ثِيشْڒِي ن ثْڒَاثَا ن وُوسَّانْ ذِي ڒخْڒَا، أَذْ نْقدّمْ ثَاغَارْصْثْ إِ سِيذِي، أَربِّي نّغْ، حِيمَا وَارْ ذ أَنغْ إِڒقّفْ س طَّاعُونْ نِيغْ س سِّيفْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ڒخْذنِّي إِنَّا أَسنْ ؤُجدْجِيذْ ن مِيصْرَا: ”مَايمِّي، أَ كنِّيوْ، مُوسَا ذ هَارُونْ، ثسّْبدّمْ ڒْڭنْسْ خْ ڒْخذْمثْ نّسْ؟ رُوحمْ كنِّيوْ، ذوْڒمْ غَارْ دّْقُوڒَاثْ إِ خَاومْ إِدْجَانْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","إِنَّا فِيرْعُونْ: ”خْزَارْ، أَقَا ڒخُّو ڒْڭنْسْ ن ثمُّورْثْ ذ أَطَّاسْ ؤُ كنِّيوْ ثخْسمْ أَذْ ثنْ ثسّْبدّمْ خْ وَارْبَارْ ن دّْقُوڒَاثْ إِ خَاسنْ تّْوَاڭّنْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","يُومُورْ فِيرْعُونْ ذڭْ وَاسّْ نِّي إِ إِمْزيَّارنْ ن ڒْڭنْسْ ؤُ إِ إِوقَّافنْ نْسنْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","”زِي سَّا ذ ثْسَاونْثْ وَارْ تِّيشمْ عَاذْ ڒُومْ إِ ڒْڭنْسْ مَاحنْذْ أَذْ زَّايسْ ڭّنْ لَّاجُورْ أَمْ يِيضنَّاضْ ذ فَارِيضنَّاضْ. جّمْ ثنْ أَذْ رَاحنْ نِيثْنِي، أَذْ يْرُونْ ڒُومْ إِ يِيخفْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ڒْقدّْ ن لَّاجُورْ إِ ڭِّينْ إِضنَّاضْ ذ فَارِيضنَّاضْ أَذْ خَاسنْ ث ثڭّمْ عَاوذْ، وَارْ زَّايسْ ثسّْنقِّيسمْ وَالُو، مِينْزِي نِيثْنِي ذ إِفِينْيَاننْ. خْ ؤُيَا سْغُويُّونْ أَمُّو، قَّارنْ: ’أجّْ أَنغْ أَذْ نْرَاحْ أَذْ نْقدّمْ ثَاغَارْصْثْ إِ أَربِّي نّغْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","إِتّْخصَّا ڒْخذْمثْ أَذْ ثِيڒِي ثذْقڒْ خْ إِرْيَازنْ-أَ، حِيمَا أَذْ ذَايسْ ڒْهَانْ أَمُّو ؤُشَا وَارْ تِّيشنْ عَاذْ ثَايْنِيثْ إِ وَاوَاڒنْ إِخَارِّيقنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ڒخْذنِّي رُوحنْ إِمْزيَّارنْ ن ڒْڭنْسْ ذ إِوقَّافنْ نْسنْ ڭّْوجنْ خْ فِيرْعُونْ ؤُشَا سِّيوْڒنْ أَكْ-ذ ڒْڭنْسْ، نَّانْ: ”أَمُّو إِ إِقَّارْ فِيرْعُونْ: ’نشّْ وَارْ ذ أَومْ تِّيشغْ شَا عَاذْ ڒُومْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","رُوحمْ كنِّيوْ أَذْ ثْيَارْومْ ڒُومْ مَانِي ث غَا ثَافمْ، مَاغَارْ وَارْ خَاومْ ثتّْوَاكّسْ وَالُو زِي ڒْخذْمثْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ڒخْذنِّي إِمْبزّعْ ڒْڭنْسْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا، حِيمَا أَذْ يْرُونْ إِغدْجْ ذڭْ ومْشَانْ ن ؤُڒُومْ. ");
INSERT INTO rifa_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","إِمْزيَّارنْ زِييَّارنْ خَاسنْ، نَّانْ: ”كمّْڒمْ ڒْخذْمثْ نْومْ، كُوڒْ أَسّْ مِينْ د-إِتَّاسنْ إِ كُوڒْ أَسّْ، أَمْ مَامّشْ ثُوغَا ذِينْ ڒخْذنِّي ڒُومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","تّْوَافَارْشنْ إِوقَّافنْ ن أَيْثْ ن إِسْرَائِيل، إِنِّي خَاسنْ ڭِّينْ إِمْزيَّارنْ ن فِيرْعُونْ، نَّانْ أَسنْ: ”مَايمِّي وَارْ ثْكمّْڒمْ ثَاسْغَارْثْ نْومْ ن لَّاجُورْ أَمْ ڒبْذَا، إِضنَّاضْ لَّا ؤُ عَاوذْ أَسّْ-أَ لَّا؟“ ");
INSERT INTO rifa_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ڒخْذنِّي ؤُسِينْ-د إِوقَّافنْ ن أَيْثْ ن إِسْرَائِيل، سْغُوينْ غَارْ فِيرْعُونْ، نَّانْ: ”مَايمِّي ثتّڭّذْ أَمُّو أَكْ-ذ إِسمْغَانْ نّشْ؟ ");
INSERT INTO rifa_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","وَارْ إِتّْموْشِي بُو ؤُڒُومْ إِ إِسمْغَانْ نّشْ، وَاخَّا قَّارنْ أَنغْ: ’ڭّمْ لَّاجُورْ!‘ ؤُ خْزَارْ، أَقَا إِسمْغَانْ نّشْ تّتّنْ أَعْمُوذْ، وَاخَّا ڒْعِيبْ أَقَا-ث ذِي ڒْڭنْسْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","نتَّا يَارَّا-د: ”كنِّيوْ ذ إِفِينْيَاننْ، ذ إِفِينْيَاننْ أَطَّاسْ. خْ ؤُيَا ثقَّارمْ: ’جّمْ أَنغْ أَذْ نْرَاحْ مَاحنْذْ أَذْ نْقدّمْ ثَاغَارْصْثْ إِ سِيذِي.‘ ");
INSERT INTO rifa_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","رُوحمْ ڒخُّو أَذْ ثْخذْممْ. وَارْ ذ أَومْ تِّيشنْ عَاذْ أَڒُْومْ، وَاخَّا إِتّْخصَّا كنِّيوْ أَذْ ثقِّيممْ ثْسبّْڒمْ ڒعْبَارْ ن لَّاجُورْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ڒخْذنِّي ژْرِينْ إِوقَّافنْ ن أَيْثْ ن إِسْرَائِيل، أَقَا-ثنْ حَاڒَا، مِينْزِي إِتّْوَانَّا: ”كنِّيوْ وَارْ سّْنقْصمْ وَالُو زِي لَّاجُورْ إِ د-إِتَّاسنْ إِ كُوڒْ أَسّْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ؤُمِي د-فّْغنْ خْ فِيرْعُونْ، مّْصَاذَافنْ أَكْ-ذ مُوسَا ذ هَارُونْ، إِنِّي ثُوغَا ذِينْ إِبدّنْ حِيمَا أَذْ ثنْ رَاجَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","نَّانْ أَسنْ: ”ذ سِيذِي، ذ ونِّي كنِّيوْ إِتّْوَاڒَانْ، ذ ونِّي خَاومْ إِ غَا إِحكْمنْ، مِينْزِي كنِّيوْ أَقَا ثسَّارْزْڭمْ أَنغْ غَارْ فِيرْعُونْ ذ إِمْسخَّارنْ نّسْ ؤُمِي ذ أَسنْ ثڭِّيمْ سِّيفْ ذڭْ إِفَاسّنْ نْسنْ مَاحنْذْ أَذْ أَنغْ نْغنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ڒخْذنِّي إِذْوڒْ مُوسَا غَارْ سِيذِي، إِنَّا: ”أَ سِيذِي إِنُو، مَايمِّي ثڭّذْ ڒْغَارْ ذِي ڒْڭنْسْ-أَ، مَايمِّي ذ أَيِي ثسّْقَاذذْ خنِّي؟ ");
INSERT INTO rifa_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","زڭْ وَامِي ؤُذْفغْ غَارْ فِيرْعُونْ حِيمَا أَذْ سِّيوْڒغْ س يِيسمْ نّشْ، إِذدْجْ فِيرْعُونْ ڒْڭنْسْ-أَ ؤُ شكْ قَاعْ وَارْ ثْفكِّيذْ شَا ڒْڭنْسْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا: ”ڒخُّو أَذْ ثْژَارذْ مِينْ غَا ڭّغْ إِ فِيرْعُونْ، مِينْزِي س ؤُفُوسْ إِجهْذنْ أَذْ ثنْ يجّْ أَذْ رَاحنْ، وَاهْ، س ؤُفُوسْ إِجهْذنْ أَذْ خَاسنْ يَاژّڒْ زِي ثمُّورْثْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","إِسِّيوڒْ أَربِّي غَارْ مُوسَا، إِنَّا أَسْ: ”نشّْ ذ سِيذِي، ");
INSERT INTO rifa_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","نشّْ بَانغْ-د إِ إِبْرَاهِيمْ، ذ إِسْحَاقْ ذ يَاعْقُوبْ أَمْ أَربِّي، أَمْزمَّارْ خْ كُوڒْشِي، مَاشَا س يِيسمْ إِنُو ’سِيذِي‘، ثُوغَا وَارْ غَارْسنْ تّْوَاسّْنغْ شَا. ");
INSERT INTO rifa_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","عَاوذْ سّْڭعّْذغْ ڒْعَاهْذْ إِنُو أَكِيذْسنْ أَقَا أَذْ أَسنْ وْشغْ ثَامُّورْثْ ن كنْعَانْ، ثَامُّورْثْ ن ؤُنوْجِي نْسنْ مَانِي ثنْ ثُوغَا أَمْ يِيبَارَّانِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","عَاوذْ نشّْ سْڒِيغْ أَنِيخْسسْ ن أَيْثْ ن إِسْرَائِيل، إِنِّي إِتّْوَاڭّنْ ذ إِسمْغَانْ زڭْ إِمِيصْرِييّنْ، أَقَا خَارّْصغْ ذِي ڒْعَاهْذْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","س ؤُيَا أَذْ ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل: نشّْ أَقَا أَيِي ذ سِيذِي ؤُ نشّْ أَذْ كنِّيوْ سُّوفّْغغْ زِي سَاذُو زَايْڒُو ن إِمِيصْرِييّنْ. نشّْ أَذْ كنِّيوْ فكّغْ زِي ثسْمُوغِي نْسنْ، أَذْ كنِّيوْ فْذِيغْ س ؤُغِيڒْ إِسّْوِيژّْضنْ ذ ڒحْكَامَاثْ إِمْغَارنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","أَذْ كنِّيوْ قبْڒغْ ذ ڒْڭنْسْ إِنُو ؤُشَا أَذْ أَومْ إِڒِيغْ ذ أَربِّي ؤُ كنِّيوْ أَذْ ثسّْنمْ بلِّي نشّْ ذ سِيذِي، أَربِّي نْومْ، ذ ونِّي ثُوغَا كنِّيوْ إِسُّوفُّوغنْ زِي سَاذُو زَايْڒُو ن إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","أَذْ كنِّيوْ سِّيذْفغْ غَارْ ثمُّورْثْ مِيخفْ سّْڭعّْذغْ أَفُوسْ إِنُو مَاحنْذْ أَذْ ت وْشغْ إِ إِبْرَاهِيمْ ذ إِسْحَاقْ ذ يَاعْقُوبْ ؤُ نشّْ أَذْ أَومْ ت وْشغْ ذ ڒْوَارْثْ، نشّْ ذ سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","أَمُّو إِ إِسِّيوڒْ مُوسَا أَكْ-ذ أَيْثْ ن إِسْرَائِيل، مَاشَا نِيثْنِي وَارْ سْڒِينْ شَا غَارْ مُوسَا زِي سِّيبّثْ ن ڒحْصَارثْ ن ثْنفْسشْثْ ذ ثَاسْمُوغِي إِقسْحنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ؤُشَا إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","”أَذفْ غَارْ فِيرْعُونْ، أَجدْجِيذْ ن مِيصْرَا، ثِينِيذْ أَسْ أَذْ إِضْڒقْ إِ أَيْثْ ن إِسْرَائِيل مَاحنْذْ أَذْ فّْغنْ زِي ثمُّورْثْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","مَاشَا مُوسَا إِسِّيوڒْ زَّاثْ إِ سِيذِي، إِنَّا: ”خْزَارْ، أَيْثْ ن إِسْرَائِيل وَارْ غَارِي د-سْڒِينْ، مَامّشْ إِ ذ أَيِي غَا إِسڒْ فِيرْعُونْ ؤُ نشّْ أَقَا غَارِي إِينْشِيشنْ وَارْ إِتّْوَاخثْننْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ڒخْذنِّي إِسِّيوڒْ سِيذِي غَارْ مُوسَا ذ هَارُونْ ؤُشَا يُومُورْ إِ-ثنْ أَذْ ؤُيُورنْ غَارْ أَيْثْ ن إِسْرَائِيل ذ فِيرْعُونْ، أَجدْجِيذْ ن مِيصْرَا، حِيمَا أَذْ إِسُّوفّغْ أَيْثْ ن إِسْرَائِيل زِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","إِنَا ذ إِزدْجِيفنْ خْ ڒَادْجَاثْ زِي ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ. أَيْثْ ن رُوبِينْ، أَمنْزُو ن إِسْرَائِيل، نِيثْنِي ذ هَانُوكْ ذ فَالُّو، حَاصْرُونْ ذ كَارْمِي. ذ يِينَا ذ ڒَادْجَاثْ ن رُوبِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","أَيْثْ ن شِيمْعُونْ ثُوغَا أَثنْ ذ يَامُويِيلْ ذ يَامِينْ ذ ؤُهَاذْ ذ يَاكِينْ ذ صُوحَارْ ذ شَاوُولْ، مِّي ن إِشْثْ ن ثمْغَارْثْ ثَاكنْعَانِيثْ. إِنَا ذ ڒَادْجَاثْ ن شِيمْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","إِنَا ذ إِسْمَاونْ ن أَيْثْ ن لَاوِي عْلَاحْسَابْ أَستّفْ ن وخْڒَاقْ نْسنْ: جَارْشُومْ ذ قَاهَاثْ ذ مَارَارِي. ثُوغَا ڒْْمِيجَاڒْ ن ثُوذَارْثْ ن لَاوِي مْيَا ؤُ-سبْعَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","أَيْثْ ن جَارْشُومْ ثُوغَا أَثنْ ذ لِيبْنَا ذ شِيمْعِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","أَيْثْ ن قَاهَاثْ ثُوغَا أَثنْ ذ عَامْرَامْ ذ يِيصْهَارْ ذ حَابْرُونْ ذ عُوزِّييِيلْ. ثُوغَا ڒْْمِيجَاڒْ ن ثُوذَارْثْ ن قَاهَاثْ مْيَا ؤُ-ثْڒَاثَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","أَيْثْ ن مَارَارِي ثُوغَا أَثنْ ذ مَاحْلِي ذ مُوشِي. إِنَا ذ ڒَادْجَاثْ ن لَاوِي عْلَاحْسَابْ أَستّفْ ن وخْڒَاقْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ؤُشَا عَامْرَامْ إِكْسِي يُوكَابَاذْ،عنْثِيسْ، ذ ثَامْغَارْثْ إِ يِيخفْ نّسْ ؤُ نتَّاثْ ثُورُووْ أَسْ-د هَارُونْ ذ مُوسَا. ثُوغَا ڒْْمِيجَاڒْ ن ثُوذَارْثْ ن عَامْرَامْ مْيَا ؤُ-سبْعَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","أَيْثْ ن يِيصْهَارْ ثُوغَا أَثنْ ذ قُورَاحْ ذ نَافَاجْ ذ ذِيكْرِي. ");
INSERT INTO rifa_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","أَيْثْ ن عُوزِّييِيلْ ثُوغَا أَثنْ ذ مِيشَايِيلْ ذ أَلْصَافَانْ ذ سِيثْرِي. ");
INSERT INTO rifa_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ؤُشَا إِكْسِي هَارُونْ إِلِيشَابَاعْ، يدْجِيسْ ن عَامِّينَاذَابْ، ؤُتْشْمَاسْ ن نَاحْشُونْ، ذ ثَامْغَارْثْ إِ يِيخفْ نّسْ ؤُ نتَّاثْ ثُورُووْ أَسْ-د نَاذَابْ ذ أَبِيهُو ذ أَلِيعَازَارْ ذ إِثَامَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","أَيْثْ ن قُورَاحْ ثُوغَا أَثنْ ذ أَسِّيرْ ذ أَلْقَانَا ذ أَبِييَاسَافْ. إِنَا ذ ڒَادْجَاثْ ن إِقُورَاحِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ؤُشَا أَلِيعَازَارْ، مِّيسْ ن هَارُونْ، إِكْسِي إِشْثنْ زڭْ يسِّيسْ ن فُوثِييِيلْ ذ ثَامْغَارْثْ إِ يِيخفْ نّسْ ؤُشَا نتَّاثْ ثُورُووْ أَسْ-د فِينَاحَاسْ. إِنَا ذ إِزدْجِيفنْ ن ثُوذْرِينْ ن إِبَابَاثنْ ن إِلَاوِييّنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","أَقَا وَا ذ هَارُونْ ذ مُوسَا إِ ؤُمِي إِنَّا سِيذِي: ”سُوفّْغمْ أَيْثْ ن إِسْرَائِيل زِي ثمُّورْثْ ن مِيصْرَا أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ إِسذِّييّنْ ن ڒْعسْكَارْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","إِنَا ذ إِنِّي إِسِّيوْڒنْ أَكْ-ذ فِيرْعُونْ، أَجدْجِيذْ ن مِيصْرَا، حِيمَا أَذْ سُّوفّْغنْ أَيْثْ ن إِسْرَائِيل زِي مِيصْرَا، مُوسَا ذ هَارُونْ، نِيثْنِي ذ إِنَا. ");
INSERT INTO rifa_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","إِمْسَارْ ذڭْ وَاسّْ إِ إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذِي ثمُّورْثْ ن مِيصْرَا، ");
INSERT INTO rifa_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","أَقَا إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ”نشّْ ذ سِيذِي إِ دْجِيغْ! مَارَّا مِينْ ذ أَشْ قَّارغْ، إِنِي ث إِ فِيرْعُونْ، أَجدْجِيذْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","خنِّي إِنَّا مُوسَا زَّاثْ إِ سِيذِي: ”أَقَا غَارِي نشّْ إِينْشِيشنْ وَارْ إِتّْوَاخثْننْ، مَامّشْ غَا يڭّْ خنِّي أَذْ غَارِي إِسدْجْ فِيرْعُونْ؟“    ");
INSERT INTO rifa_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","إِنَّا سِيذِي إِ مُوسَا: ”خْزَارْ، نشّْ أَقَا ڭِّيغْ شكْ ذ أَربِّي إِ فِيرْعُونْ ذ ؤُمَاشْ هَارُونْ أَذْ أَشْ يِيڒِي ذ أَنَابِي إِ شكْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","شكْ أَذْ ثِينِيذْ مَارَّا مِينْ زِي شكْ غَا ؤُمُورغْ ؤُشَا هَارُونْ، ؤُمَاشْ، أَذْ إِسِّيوڒْ أَكْ-ذ فِيرْعُونْ، حِيمَا أَذْ يجّْ أَذْ فّْغنْ أَيْثْ ن إِسْرَائِيل زِي ثمُّورْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","مَاشَا نشّْ أَذْ سّْقسْحغْ ؤُڒْ ن فِيرْعُونْ ؤُشَا أَذْ كتَّارغْ ڒعْڒَامَاثْ ذ لْمُوعْجِيزَاثْ إِنُو ذِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","مَاشَا فِيرْعُونْ وَارْ غَارْومْ-د إِسّْحسِّي ؤُ نشّْ أَذْ ڭّغْ أَفُوسْ إِنُو خْ مِيصْرَا ؤُشَا أَذْ سُّوفّْغغْ ڒْعسْكَارَاثْ إِنُو، ڒْڭنْسْ إِنُو، أَيْثْ ن إِسْرَائِيل، زِي ثمُّورْثْ ن مِيصْرَا س ڒحْكَامَاثْ إِمْغَارنْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ڒخْذنِّي أَذْ سّْننْ إِمِيصْرِييّنْ بلِّي نشّْ ذ سِيذِي إِ دْجِيغْ خْمِي غَا سّْوِيژّْضغْ أَفُوسْ إِنُو خْ مِيصْرَا ؤُشَا أَذْ سُّوفّْغغْ أَيْثْ ن إِسْرَائِيل زِي ڒْوسْطْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ؤُشَا ڭِّينْ مُوسَا ذ هَارُونْ أَمْ مَامّشْ ثنْ يُومُورْ سِيذِي، وَاهْ، أَمنِّي إِ ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ثُوغَا مُوسَا ذ إِجّْ ن بْنَاذمْ ن ثْمنْيِينْ ن إِسڭّْوُوسَا ؤُ ثُوغَا هَارُونْ ذ إِجّْ ن بْنَاذمْ ن ثْڒَاثَا ؤُ-ثْمنْيِينْ ن إِسڭّْوُوسَا، ڒَامِي سِّيوْڒنْ أَكْ-ذ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ؤُشَا إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","”مَاڒَا إِسِّيوڒْ أَكِيذْومْ فِيرْعُونْ، أَذْ يِينِي: ’سشْنمْ، أَقَا كنِّيوْ ثْزمَّارمْ أَذْ ثڭّمْ إِشْثْ ن لْمُوعْجِيزَا!‘، خنِّي أَذْ ثِينِيذْ إِ هَارُونْ: ’طّفْ ثَاغَّارْشْثْ نّشْ ؤُشَا نْضَارْ إِ-ت زَّاثْ إِ فِيرْعُونْ!‘، خنِّي أَذْ ثذْوڒْ ذ إِشْثْ ن ڒْهَايْشثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ؤُذْفنْ خنِّي مُوسَا ذ هَارُونْ غَارْ فِيرْعُونْ ؤُشَا ڭِّينْ مَامّشْ إِ ذ أَسنْ يُومُورْ سِيذِي. إِنْضَارْ هَارُونْ ثَاغَّارْشْثْ نّسْ زَّاثْ إِ فِيرْعُونْ ذ إِمْسخَّارنْ نّسْ ؤُشَا ثذْوڒْ ذ إِشْثْ ن ڒْهَايْشثْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ڒخْذنِّي إِڒَاغَا-د عَاوذْ فِيرْعُونْ خْ إِمِيغِيسنْ ذ إِسحَّارنْ، ؤُشَا ثَارْوَا ن ثْسحَّارْثْ ن مِيصْرَا ڭِّينْ عَاوذْ أَمنِّي س ثْمڭَّا نْسنْ ن سْوَادَّايْ سْوَادَّايْ ذ إِشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","إِنْضَارْ كُوڒْ إِجّنْ ثَاغَّارْشْثْ نّسْ ؤُشَا ذوْڒنْثْ ثِيغَّارْينْ نِّي ذ ڒْهَايْشَاثْ. مَاشَا ثَاغَّارْشْثْ ن هَارُونْ ثْسَارْضْ ثِيغَّارْينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ؤُڒْ ن فِيرْعُونْ إِذْوڒْ إِقْسحْ ؤُشَا وَارْ غَارْسنْ إِسْڒِي شَا، أَمْ مَامّشْ ثُوغَا إِ ذ أَسنْ إِنَّا سِيذِي قْبڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا: ”ؤُڒْ ن فِيرْعُونْ إِذْوڒْ إِقْسحْ. وَارْ إِخْسْ أَذْ يجّْ أَذْ إِفّغْ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","رُوحْ ثِيوشَّا غَارْ صّْبحْ غَارْ فِيرْعُونْ. خْزَارْ، نتَّا أَذْ إِفّغْ غَارْ وَامَانْ. شكْ رَاجَا ذِينْ غَارْ ثْمَا ن يِيغْزَارْ ؤُشَا كْسِي-د ثَاغَّارْشْثْ نِّي إِذوْڒنْ ذ أَفِيغَارْ ذڭْ ؤُفُوسْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","أَذْ أَسْ ثِينِيذْ: ’سِيذِي، أَربِّي ن إِعِيبْرَانِييّنْ إِسّكّْ أَيِي-د غَاركْ، إِنَّا: أجّْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو، حِيمَا أَذْ أَيِي إِعْبذْ ذِي ڒخْڒَا! خْزَارْ، أَڒْ ڒخُّو وَارْ ثخْسذْ أَذْ ثْسدْجذْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","أَمُّو إِ إِقَّارْ سِيذِي: ’س مَانْ أَيَا أَذْ ثسّْنذْ بلِّي نشّْ ذ سِيذِي!‘ خْزَارْ، نشّْ أَذْ وْثغْ أَمَانْ إِ إِدْجَانْ ذڭْ إِغْزَارْ س ثغَّارْشْثْ إِ غَارِي ذڭْ ؤُفُوسْ إِنُو ؤُشَا أَذْ ذوْڒنْ ذ إِذَامّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","إِسڒْمَانْ إِ إِدْجَانْ ذڭْ إِغْزَارْ أَذْ مّْثنْ أَڒْ غَا يُورْصُوضْ إِغْزَارْ ن نِيلْ، أَذْ عِيفّنْ إِمِيصْرِييّنْ أَذْ سْونْ أَمَانْ ن إِغْزَارْ ن نِيلْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","إِنَّا سِيذِي عَاوذْ إِ مُوسَا: ”إِنِي إِ هَارُونْ: ’كْسِي ثَاغَّارْشْثْ نّشْ، سْوِيژّضْ أَفُوسْ نّشْ خْ وَامَانْ ن مِيصْرَا، خْ إِغزْرَانْ نْسنْ، خْ ثْغزْرَاثِينْ نْسنْ، خْ إِيڒْمَامنْ نْسنْ خْ مَارَّا إِمُوشَانْ مَانِيسْ تّْمُونَانْ وَامَانْ ؤُشَا أَذْ ذوْڒنْ ذ إِذَامّنْ. أَذْ ذوْڒنْ ذ إِذَامّنْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا، ؤُڒَا ذِي ڒقْشُوعْ ن ؤُكشُّوضْ ذ وژْرُو.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","مُوسَا ذ هَارُونْ ڭِّينْ أَمْ مَامّشْ إِ ذ أَسنْ يُومُورْ سِيذِي. إِسّْڭعّذْ هَارُونْ ثَاغَّارْشْثْ، إِوْثَا أَمَانْ نِّي ثُوغَا ذڭْ إِغْزَارْ قِيبَاتْشْ إِ ثِيطَّاوِينْ ن فِيرْعُونْ ذ إِمْسخَّارنْ نّسْ ؤُشَا مَارَّا أَمَانْ نِّي ثُوغَا ذڭْ إِغْزَارْ ذوْڒنْ ذ إِذَامّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","مُّوثنْ إِسڒْمَانْ إِنِّي ثُوغَا ذڭْ إِغْزَارْ ؤُشَا يُورْصُوضْ يغْزَارْ أَڒَامِي ذوْڒنْ إِمِيصْرِييّنْ وَارْ زمَّارنْ أَذْ زَّايسْ سْونْ أَمَانْ ؤُشَا ذوْڒنْ وَامَانْ ذ إِذَامّنْ ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","مَاشَا ثَارْوَا ن ثْسحَّارْثْ ن مِيصْرَا ڭِّينْ أَمنِّي س ثْمڭَّا نْسنْ ن سْوَادَّايْ سْوَادَّايْ أَڒَامِي ؤُڒْ ن فِيرْعُونْ إِذْوڒْ إِقْسحْ، ؤُ نتَّا وَارْ غَارْسنْ إِسّْحسّْ شَا، أَمْ مَامّشْ ذ أَسنْ ثُوغَا إِنَّا سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","إِنّقْڒبْ فِيرْعُونْ ؤُشَا يُوذفْ غَارْ ثَادَّارْثْ نّسْ ؤُشَا وَارْ إِڭِّي ؤُڒْ نّسْ عَاذْ ذِي مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","مَارَّا إِمِيصْرِييّنْ غْزَانْ خْ ثْمَا ن إِغْزَارْ ن نِيلْ مَاحنْذْ أَذْ أَفنْ أَمَانْ ن ثسِّيثْ، مِينْزِي وَارْ زمَّارنْ أَذْ سْونْ أَمَانْ ن إِغْزَارْ ن نِيلْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","أَمُّو إِ عْذُونْ سبْعَا ؤُسَّانْ أَوَارْنِي ڒَامِي إِوْثَا سِيذِي إِغْزَارْ ن نِيلْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”أَذفْ غَارْ فِيرْعُونْ، إِنِي أَسْ: ’أَمُّو إِ إِقَّارْ سِيذِي: أجّْ أَذْ إِفّغْ ڒْڭنْسْ إِنُو حِيمَا أَذْ أَيِي إِعْبذْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","مَاڒَا ثُوڭِيذْ أَذْ ثنْ ثجّذْ أَذْ رَاحنْ، أَقَا أَذْ وْثغْ مَارَّا ثَامُّورْثْ نّشْ س إِقَارْقْرِيونْ ");
INSERT INTO rifa_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","ؤُشَا إِغْزَارْ ن نِيلْ أَذْ د-إِسفِّييْ خْ إِقَارْقْرِيونْ، أَذْ زَّايسْ-د ڭعّْذنْ، أَذْ أَذْفنْ غَارْ ثَادَّارْثْ نّشْ ؤُ غَارْ وخَّامْ نّشْ ن يِيضصْ، أَذْ د-أَسنْ خْ قَامَا نّشْ ؤُڒَا ذِي ثَادَّارْثْ ن إِمْسخَّارنْ نّشْ ؤُ جَارْ ڒْڭنْسْ نّشْ، ؤُ عَاذْ ذڭْ إِفَارَّاننْ نّشْ ؤُ ذِي ثْبقْيِينْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","أَذْ خَاكْ د-ڭعّْذنْ إِقَارْقْرِيونْ ؤُڒَا خْ ڒْڭنْسْ نّشْ ؤُ خْ مَارَّا إِمْسخَّارنْ نّشْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","إِنَّا سِيذِي عَاوذْ إِ مُوسَا: ”إِنِي إِ هَارُونْ: ’سْوِيژّضْ أَفُوسْ نّشْ س ثغَّارْشْثْ نّشْ خْ إِغزْرَانْ، خْ ثْغزْرَاثِينْ ؤُڒَا خْ إِيڒْمَامنْ، سْڭعّذْ إِقَارْقْرِيونْ خْ ثمُّورْثْ ن مِيصْرَا.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ؤُشَا إِسّْوِيژّضْ هَارُونْ أَفُوسْ نّسْ خْ وَامَانْ ن مِيصْرَا ؤُشَا ڭعّْذنْ-د إِقَارْقْرِيونْ ؤُشَا ذْڒِينْ ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ؤُشَا ؤُڒَا ذ ثَارْوَا ن ثْسحَّارْثْ ڭِّينْ أَمنِّي س ثْمڭَّا نْسنْ ن سْوَادَّايْ سْوَادَّايْ ذ إِشْثْ، ؤُشَا سّْڭعّْذنْ-د عَاوذْ إِقَارْقْرِيونْ خْ ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","إِڒَاغَا-د فِيرْعُونْ خْ مُوسَا ذ هَارُونْ، إِنَّا أَسنْ: ”ژَتدْجمْ س ڒَادْجَاغْ إِ سِيذِي حِيمَا أَذْ خَافِي إِكْسِي إِقَارْقْرِيونْ ؤُ خْ ڒْڭنْسْ إِنُو، ؤُشَا خنِّي أَذْ جّغْ أَذْ إِفّغْ ڒْڭنْسْ، مَاحنْذْ أَذْ قدّْمنْ ثِيغَارْصَا إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","إِنَّا مُوسَا إِ فِيرْعُونْ: ”طّفْ خَافِي ڒْحُورْمثْ مڒْمِي ذ أَيِي غَا ثِينِيذْ أَذْ خَاكْ ژَّادْجغْ ؤُ خْ إِمْسخَّارنْ نّشْ ؤُ خْ ڒْڭنْسْ نّشْ، مَاحنْذْ أَذْ خَاكْ قضْعغْ إِقَارْقْرِيونْ ؤُ خْ ثُوذْرِينْ نّشْ، أَذْ قِّيمنْ ذڭْ إِغْزَارْ وَاهَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","يَارَّا-د خَاسْ: ”ثِيوشَّا!“ إِنَّا مُوسَا: ”أَذْ يِيڒِي أَمْ مَامّشْ ثنِّيذْ حِيمَا أَذْ ثسّْنذْ بلِّي وَارْ ذِينْ إِدْجِي حذْ أَمْ سِيذِي، أَربِّي نّغْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ؤُشَا إِقَارْقْرِيونْ أَذْ مّكْسِينْ خَاكْ ؤُ خْ ثُوذْرِينْ نّشْ ؤُڒَا خْ إِمْسخَّارنْ نّشْ ؤُ خْ ڒْڭنْسْ نّشْ، أَذْ قِّيمنْ ذڭْ إِغْزَارْ وَاهَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ڒخْذنِّي إِفّغْ مُوسَا ذ هَارُونْ خْ فِيرْعُونْ ؤُشَا إِڒَاغَا مُوسَا إِ سِيذِي ذِي سِّيبّثْ ن جّْرِيحشْثْ ن إِقَارْقْرِيونْ نِّي ثُوغَا إِڭَّا خْ فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ؤُشَا إِڭَّا سِيذِي أَمْ مَامّشْ د-إِتَّاسْ أَكْ-ذ وَاوَاڒْ ن مُوسَا ؤُشَا مُّوثنْ إِقَارْقْرِيونْ ؤُشَا ودَّارنْ زِي ثُوذْرِينْ، زِي ڒمْرَاحَاثْ ؤُ زڭْ إِيَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ؤُشَا سّْمُوننْ ثنْ ذ إِعُورَّاشْ ؤُشَا ثُورْصُوضْ زَّايْسنْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ڒَْامِي إِژْرَا فِيرْعُونْ بلِّي أَقَا بْنَاذمْ إِزمَّارْ أَذْ يَارّْ نّفْسْ، إِسّقْسحْ ؤُڒْ نّسْ ؤُشَا وَارْ غَارْسنْ إِسّْحسّْ، أَمْ مَامّشْ ثُوغَا إِنَّا سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا: ”إِنِي إِ هَارُونْ: ’سْوِيژّضْ ثَاغَّارْشْثْ نّشْ، ثوْثذْ زَّايسْ أَشَاڒْ ن ثمُّورْثْ. خنِّي أَذْ إِذْوڒْ ذ نَّامُوسْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ؤُشَا أَمُّو إِ ڭِّينْ نِيثْنِي. إِسّْوِيژّضْ هَارُونْ أَفُوسْ نّسْ س ثغَّارْشْثْ نّسْ إِ ذَايسْ، إِوْثَا أَشَاڒْ ن ثمُّورْثْ. ؤُشَا يُوسَا-د نَّامُوسْ أَمْ خْ إِوْذَانْ أَمْ خْ ڒْمَاڒْ. مَارَّا أَشَاڒْ ن ثمُّورْثْ إِذْوڒْ ذ نَّامُوسْ ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ثَارْوَا ن ثْسحَّارْثْ ڭِّينْ ثِيزمَّارْ نْسنْ أَمنِّي عَاوذْ س ثْمڭَّا نْسنْ ن سْوَادَّايْ سْوَادَّايْ، مَاحنْذْ أَذْ سُّوفّْغنْ نَّامُوسْ، مَاشَا وَارْ زمَّارنْ. ؤُشَا ثُوغَا نَّامُوسْ خْ إِوْذَانْ ذ ڒْمَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ڒخْذنِّي نَّانْ ثَارْوَا ن ثْسحَّارْثْ إِ فِيرْعُونْ: ”مَانْ أَيَا ذ أَضَاضْ ن أَربِّي!“ مَاشَا إِسّقْسحْ ؤُڒْ ن فِيرْعُونْ ؤُشَا وَارْ د غَارْسنْ إِسدْجْ شَا، أَمْ مَامّشْ ثُوغَا إِنَّا سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ؤُشَا إِنَّا سِيذِي إِ مُوسَا: ”ثِيوشَّا كَّارْ زِيشْ، أَذْ ثْبدّذْ زَّاثْ إِ فِيرْعُونْ. خْزَارْ، نتَّا أَذْ إِفّغْ غَارْ ثْمَا ن وَامَانْ، أَذْ أَسْ ثِينِيذْ: ’أَمُّو إِ إِقَّارْ سِيذِي: أجّْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو، حِيمَا أَذْ أَيِي إِعْبذْ! ");
INSERT INTO rifa_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","مِينْزِي مَاڒَا وَارْ ثجِّيذْ ڒْڭنْسْ إِنُو أَذْ إِرَاحْ، خْزَارْ، نشّْ أَذْ خَاكْ سّكّغْ إِيْڒَافنْ ن إِبعَّاشْ، خْ إِمْسخَّارنْ نّشْ، خْ ڒْڭنْسْ نّشْ، خْ ثُوذْرِينْ نّشْ، أَڒْ غَا تّْوَاشُّورنْثْ ثُوذْرِينْ ن إِمِيصْرِييّنْ س إِيْڒَافنْ ن إِبعَّاشْ ؤُشَا أَمنِّي ؤُڒَا ذ ثَامُّورْثْ مَانِي زدّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ذڭْ وَاسّْ نِّي أَذْ سّْحُوزغْ ثَامُّورْثْ ن جُوشَانْ مَانِي إِزدّغْ ڒْڭنْسْ إِنُو، حِيمَا وَارْ ذِينْ تِّيڒِينْ ويْڒَافنْ ن إِبعَّاشْ حِيمَا أَذْ ثسّْنذْ بلِّي نشّْ ذ سِيذِي ذِي ڒْوسْطْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ؤُشَا أَذْ ڭّغْ إِجّْ ن تَّامَانْ ن وصْڒَاحْ جَارْ ڒْڭنْسْ إِنُو ذ ونِّي نّشْ. ثِيوشَّا أَذْ ثِيڒِي ڒعْڒَامثْ-أَ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ؤُشَا أَمُّو إِ إِڭَّا سِيذِي. ؤُسِينْ-د إِيْڒَافنْ إِمقّْرَاننْ ن إِبعَّاشْ خْ ثَادَّارْثْ ن فِيرْعُونْ، خْ ثُوذْرِينْ ن إِمْسخَّارنْ نّسْ ؤُ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا ؤُشَا ثتّْوَاخَارّبْ ثمُّورْثْ س إِيْڒَافنْ ن إِبعَّاشْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ڒخْذنِّي إِڒَاغَا فِيرْعُونْ إِ مُوسَا ذ هَارُونْ، إِنَّا أَسنْ: ”رُوحمْ، ثْقدّْممْ ثَاغَارْصْثْ إِ أَربِّي نْومْ ذِي ثمُّورْثْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","إِنَّا مُوسَا: ”وَارْ د-يُوسِي أَذْ نڭّْ أَمُّو، مِينْزِي أَذْ نْقدّمْ ثَاغَارْصْثْ إِ سِيذِي، أَربِّي نّغْ، مِينْ إِدْجَانْ ذ إِشْثْ ن جّْعِيفشْثْ غَارْ إِمِيصْرِييّنْ. خْزَارْ، مَاڒَا نْقدّمْ ذ ثَاغَارْصْثْ زَّاثْ إِ ثِيطَّاوِينْ ن إِمِيصْرِييّنْ مِينْ ذ أَسنْ إِتّْغِيڒْ ذْ جّْعِيفشْثْ، مَا وَارْ ذ أَنغْ ثَارجّْمنْ شَا؟ ");
INSERT INTO rifa_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","أجّْ أَنغْ أَذْ نْرَاحْ ثِيشْڒِي ن ثْڒَاثَا ن وُوسَّانْ ذِي ڒخْڒَا، حِيمَا أَذْ نْقدّمْ ثَاغَارْصْثْ إِ سِيذِي، أَربِّي نّغْ، أَمْ مَامّشْ ذ أَنغْ يُومُورْ نتَّا.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","خنِّي إِنَّا فِيرْعُونْ: ”نشّْ أَذْ كنِّيوْ جّغْ أَذْ ثْرَاحمْ ؤُشَا أَذْ ثْقدّْممْ ثَاغَارْصْثْ إِ سِيذِي، أَربِّي نْومْ، ذِي ڒخْڒَا، مَاشَا وَارْ إِعدّڒْ أَذْ ثِيڭّْوِيجمْ أَطَّاسْ. ژَتدْجمْ ؤُڒَا خَافِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","مُوسَا إِنَّا: ”أَقَا أَذْ خَاكْ فّْغغْ، أَذْ ژَّادْجغْ إِ سِيذِي، حِيمَا أَذْ إِكّسْ ثِيوشَّا إِيْڒَافنْ ن إِبعَّاشْ خْ فِيرْعُونْ، خْ إِمْسخَّارنْ نّسْ ؤُڒَا خْ ڒْڭنْسْ نّسْ. مَاشَا إِتّْخصَّا فِيرْعُونْ وَارْ إِخدّعْ ثْوَاڒَا نّغْنِي، وَارْ إِتّجِّي أَذْ إِرَاحْ ڒْڭنْسْ، مَاحنْذْ أَذْ إِقدّمْ ثَاغَارْصْثْ إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ڒخْذنِّي إِفّغْ مُوسَا خْ فِيرْعُونْ ؤُشَا إِژُّودْجْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","إِڭَّا سِيذِي عْلَاحْسَابْ أَوَاڒْ إِ إِنَّا مُوسَا ؤُشَا إِكّسْ إِيْڒَافنْ ن إِبعَّاشْ خْ فِيرْعُونْ، خْ إِمْسخَّارنْ نّسْ، ؤُڒَا خْ ڒْڭنْسْ نّسْ. وَارْ إِقِّيمْ ؤُڒَا ذ إِجّْ ن ؤُبعُّوشْ. ");
INSERT INTO rifa_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","مَاشَا فِيرْعُونْ إِسّقْسحْ ؤُڒْ نّسْ ثْوَاڒَا-يَا عَاوذْ، وَارْ إِجِّي أَذْ إِرَاحْ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا: ”أَذفْ غَارْ فِيرْعُونْ، إِنِي أَسْ: ’سِيذِي، أَربِّي ن إِعِيبْرَانِييّنْ إِقَّارْ أَمُّو: أجّْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو، مَاحنْذْ أَذْ أَيِي إِعْبذْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","مِينْزِي مَاڒَا ثُوڭِيذْ أَذْ ثنْ ثجّذْ أَذْ رَاحنْ ؤُشَا أَذْ ثنْ ثطّْفذْ عَاذْ كْثَارْ، ");
INSERT INTO rifa_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","خْزَارْ، أَفُوسْ ن سِيذِي أَذْ يِيڒِي خْ ڒْمَاڒْ نّشْ نِّي إِدْجَانْ ذڭْ إِيَّارْ، خْ إِيْسَانْ ذ يغْيَاڒْ ذ يِيڒغْمَانْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ ؤُڒَا خْ وُودْجِي س يِيجّْ ن طَّاعُونْ إِقسْحنْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","أَذْ إِفَارْزْ سِيذِي جَارْ ڒبْهَايمْ ن أَيْثْ ن إِسْرَائِيل ذ ڒبْهَايمْ ن إِمِيصْرِييّنْ، حِيمَا وَارْ إِتّْمتِّي وَالُو زِي مَارَّا مِينْ إِدْجَانْ ن أَيْثْ ن إِسْرَائِيل.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ؤُشَا إِنيّشْ سِيذِي إِشْثْ ن ڒْوقْثْ ؤُمِي إِنَّا: ”ثِيوشَّا أَذْ يڭّْ سِيذِي مَانْ أَيَا ذِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ثِيوشَّا نّسْ إِڭَّا سِيذِي دّقّْ نِّي ؤُشَا مُّوثنْ مَارَّا ڒبْهَايمْ ن مِيصْرَا، مَاشَا زِي ڒبْهَايمْ ن أَيْثْ ن إِسْرَائِيل وَارْ ثمُّوثْ ؤُڒَا ذ إِشْثْ زَّايْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ؤُشَا إِسّكّْ فِيرْعُونْ إِجّنْ، ؤُشَا أَقَا ذَا، وَارْ ثمُّوثْ ؤُڒَا ذ إِشْثْ زِي ڒبْهَايمْ ن أَيْثْ ن إِسْرَائِيل. مَاشَا ؤُڒْ ن فِيرْعُونْ إِذْوڒْ إِقْسحْ ؤُشَا وَارْ يجِّي أَذْ إِفّغْ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا ذ هَارُونْ: ”عمَّارْ ؤُرُو ن إِفَاسّنْ نْومْ س إِغّضْ زِي ثفْقُونْثْ ؤُشَا أجّْ مُوسَا أَذْ ث إِزُّوزَارْ ذڭْ ؤُجنَّا قِيبَاتْشْ إِ ثِيطَّاوِينْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","أَذْ إِذْوڒْ إِغّضْ ذ ثَاعجَّاجْثْ إِفْسُوسنْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا ؤُشَا ثَاعجَّاشْثْ أَذْ ثذْوڒْ ذ ثِيحبَّا س ڒوْعِي خْ بْنَاذمْ ؤُ خْ ڒْمَاڒْ ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ؤُشَا كْسِينْ إِغّضْ زِي ثفْقُونْثْ أَمْ ثُوغَا بدّنْ زَّاثْ إِ فِيرْعُونْ ؤُشَا إِزُّوزَارْ إِ-ث مُوسَا ذڭْ ؤُجنَّا ؤُشَا إِذْوڒْ ذ ثِيحبَّا س ڒوْعِي أَمْ ذڭْ إِوْذَانْ أَمْ ذِي ڒْمَاڒْ، ");
INSERT INTO rifa_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","أَڒَامِي ثَارْوَا ن ثْسحَّارْثْ وَارْ زمَّارنْ أَذْ قِّيمنْ بدّنْ زَّاثْ إِ مُوسَا ذِي سِّيبّثْ ن ثْحبَّا، مِينْزِي ثِيحبَّا حكْمنْثْ إِسحَّارنْ ذ مَارَّا إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","مَاشَا سِيذِي إِسّقْسحْ ؤُڒْ ن فِيرْعُونْ، أَڒَامِي وَارْ ذ أَسنْ إِسدْجْ شَا، أَمْ مَامّشْ ثُوغَا إِنَّا سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ڒخْذنِّي إِنَّا سِيذِي إِ مُوسَا: ”ثِيوشَّا كَّارْ زِيشْ، ثْبدّذْ زَّاثْ إِ وُوذمْ ن فِيرْعُونْ ؤُشَا إِنِي أَسْ: ’أَمُّو إِ إِقَّارْ سِيذِي، أَربِّي ن إِعِيبْرَانِييّنْ: أجّْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو، مَاحنْذْ أَذْ أَيِي إِعْبذْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","مِينْزِي ثْوَاڒَا-يَا نشّْ أَذْ شكْ ڒقْفغْ ذڭْ وُوڒْ س مَارَّا جّْرَايحْ إِنُو ؤُشَا ؤُڒَا ذ إِمْسخَّارنْ نّشْ ذ ڒْڭنْسْ نّشْ، حِيمَا أَذْ ثسّْنذْ بلِّي وَارْ إِدْجِي حذْ أَمْ نشّْ ذِي مَارَّا ثَامُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","مِينْزِي عَاذْ ڒخُّو ثُوغَا زمَّارغْ أَذْ سّْوِيژّْضغْ أَفُوسْ إِنُو، حِيمَا أَذْ شكْ وْثغْ ؤُڒَا ذ ڒْڭنْسْ نّشْ س طَّاعُونْ ؤُشَا ثُوغَا إِزمَّارْ أَذْ ثتّْوَاثحِّيذْ زِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","مَاشَا س ثِيذتّْ نشّْ سّْبدّغْ شكْ حِيمَا أَذْ أَشْ سّشْنغْ جّهْذْ إِنُو ؤُ حِيمَا أَذْ إِتّْوَاشنّعْ إِسمْ إِنُو ذِي مَارَّا ثَامُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","مَا ثتّڭّذْ عَاذْ ثِيعِينْكْرِيفِينْ ضِيدّْ إِ ڒْڭنْسْ إِنُو، حِيمَا وَارْ ثنْ ثجِّيذْ أَذْ رَاحنْ؟ ");
INSERT INTO rifa_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","خْزَارْ، ثِيوشَّا غَارْ ثْسَاعّثْ-أَ نشّْ أَذْ أَرّغْ ثَابْرُورِّي إِدّقْڒنْ أَذْ ثوّثْ، ثَابْرُورِّي إِ وَارْ ثُوغِيعمَّارْصْ ذِي مِيصْرَا زڭْ وَاسّْ إِ ذِي ثتّْوَابْنَا أَڒْ إِ ڒخُّو. ");
INSERT INTO rifa_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","خنِّي سكّْ ڒخُّو إِمْسخَّارنْ نّكْ، مَاحنْذْ أَذْ سِّيذْفنْ ڒبْهَايمْ ذ مَارَّا مِينْ غَاركْ ذڭْ إِيَّارْ غَارْ ذَاخڒْ. كُوڒْ بْنَاذمْ نِيغْ ذ ڒْمَاڒْ نِّي إِ غَا إِتّْوَافنْ ذڭْ إِيَّارْ، وَارْ ث سِّيذْفنْ غَارْ ذَاخڒْ ن ثَادَّارْثْ، أَذْ خَاسْ د-ثوْضَا ثبْرُورِّي ؤُشَا نِيثْنِي أَذْ مّْثنْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ونِّي إِڭّْوذنْ أَوَاڒْ ن سِيذِي زڭْ إِمْسخَّارنْ ن فِيرْعُونْ، إِجَّا إِمْسخَّارنْ نْسنْ ذ ڒبْهَايمْ نْسنْ أَروْڒنْ غَارْ ذَاخڒْ ذِي ثُوذْرِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","مَاشَا ونِّي وَارْ إِتِّيقّنْ أَوَاڒْ ن سِيذِي س وُوڒْ نّسْ، أَقَا إِجَّا إِمْسخَّارنْ نّسْ ذ ڒبْهَايمْ نّسْ ذڭْ إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”سْوِيژّضْ أَفُوسْ نّشْ غَارْ ؤُجنَّا ؤُشَا أَذْ ثِيڒِي ثبْرُورِّي خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا، خْ إِوْذَانْ، خْ ڒْمَاڒْ ؤُ خْ مَارَّا أَفْسُو ذڭْ إِيَّارنْ ذِي ثمُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","خنِّي إِسّْوِيژّضْ مُوسَا ثَاغَّارْشْثْ نّسْ غَارْ ؤُجنَّا ؤُشَا سِيذِي إِڭَّا أَجَّاجْ ذ ثبْرُورِّي ؤُشَا ثسّْوِيژّضْ ثْمسِّي غَارْ ثمُّورْثْ. أَمُّو إِ إِڭَّا سِيذِي مَاحنْذْ أَذْ ثوّثْ ثبْرُورِّي خْ ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ثُوغَا ذِينْ ثَابْرُورِّي ذ ثْمسِّي إِخدْجْضنْ أَكْ-ذ ثبْرُورِّي. ثُوغَا ثجْهذْ أَطَّاسْ، وَارْ ت ثُوغِيعمَّارْصْ ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا زڭْ وَامِي ثُوغَا ثذْوڒْ ذ إِجّْ ن ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ؤُشَا ثوْثَا ثبْرُورِّي خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا، خْ مَارَّا مِينْ ثُوغَا ذڭْ إِيَّارْ، خْ إِوْذَانْ ذ ڒْمَاڒْ. ثوْثَا ثبْرُورِّي عَاوذْ خْ مَارَّا أَفْسُو ذڭْ إِيَّارْ ؤُشَا تّْوَارْژنْثْ مَارَّا ثْشجُّورَا ن ڒخْڒَا. ");
INSERT INTO rifa_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","مْغِيرْ ذِي ثَامُّورْثْ ن جُوشَانْ، مَانِي دْجَانْ أَيْثْ ن إِسْرَائِيل، وَارْ ثوْثِي ثبْرُورِّي. ");
INSERT INTO rifa_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ڒخْذنِّي إِسّكّْ فِيرْعُونْ أَذْ ڒَاغَانْ إِ مُوسَا ذ هَارُونْ ؤُشَا إِنَّا أَسنْ: ”نشّْ خْضِيغْ ثْوَاڒَا-يَا. سِيذِي، أَقَا-ث ذ أَمْسڭّذْ ؤُشَا نشّْ ذ ڒْڭنْسْ إِنُو ذ إِعفَّاننْ! ");
INSERT INTO rifa_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ژَتدْجمْ س ڒَادْجَاغْ إِ سِيذِي، مِينْزِي شْفَا، أَقَا أَجَّاجنْ ن أَربِّي ذ أَطَّاسْ ؤُڒَا ذ ثَابْرُورِّي. نشّْ أَذْ كنِّيوْ جّغْ أَذْ ثْرَاحمْ، وَارْ كنِّيوْ تّطّْفغْ شَا عَاذْ ذَانِيثَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","خنِّي إِنَّا أَسْ مُوسَا: ”مڒْمِي غَا فّْغغْ زِي ثنْذِينْثْ أَذْ سّْوِيژّْضغْ إِفَاسّنْ إِنُو غَارْ سِيذِي ؤُشَا أَذْ بدّنْ وَاجَّاجنْ، وَارْ ثتِّيڒِي عَاذْ ثبْرُورِّي، مَاحنْذْ أَذْ ثسّْنذْ بلِّي ثَامُّورْثْ أَقَا-ت ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","مَاشَا خَاكْ ذ خْ إِمْسخَّارنْ نّشْ، أَقَا سّْنغْ مَازَالْ وَارْ ثڭّْوذمْ شَا زِي سِيذِي أَربِّي.“ ");
INSERT INTO rifa_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ثِيفّسْثْ ذ إِمنْذِي ثُوغَا تّْوَاڒقْفنْ، مِينْزِي إِمنْذِي ثُوغَا-ث س ثِيذْرِينْ ذ ثِيفّسْثْ ثْنوَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","مَاشَا إِرْذنْ ذ كَارْصَانَا وَارْ تّْوَاڒقْفنْ شَا، مِينْزِي ثُوغَا أَثنْ وَارْ د-فِّيغنْ عَاذْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","خنِّي يُويُورْ مُوسَا زِي فِيرْعُونْ، إِفّغْ زِي ثنْذِينْثْ ؤُشَا إِكْسِي إِفَاسّنْ نّسْ غَارْ سِيذِي. ڒخْذنِّي بدّنْ وَاجَّاجنْ ذ ثبْرُورِّي ؤُڒَا ذ إِبُوذَا ن ونْژَارْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ؤُمِي إِژْرَا فِيرْعُونْ بلِّي أَنْژَارْ ذ ثبْرُورِّي ذ وَاجَّاجنْ بدّنْ، إِخْضَا عَاذْ كْثَارْ ؤُشَا إِسّقْسحْ ؤُڒْ نّسْ، نتَّا ذ إِمْسخَّارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ؤُڒْ ن فِيرْعُونْ يَارْنِي ذِي ڒقْسَاحثْ، وَارْ إِجِّي أَذْ إِرَاحْ أَيْثْ ن إِسْرَائِيل، أَمْ مَامّشْ ثُوغَا إِنَّا سِيذِي س ثْسخَّارْثْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”أَذفْ غَارْ فِيرْعُونْ، مِينْزِي نشّْ سّْقسْحغْ ؤُڒْ نّسْ ذ وُوڒْ ن إِمْسخَّارنْ نّسْ، حِيمَا أَذْ سّشْنغْ ڒعْڒَامَاثْ إِنُو ذِي ڒْوسْطْ ن ثمُّورْثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ؤُ حِيمَا أَذْ ثْعَاوْذذْ ذڭْ إِمزُّوغنْ ن مِّيشْ ذ مِّيسْ ن مِّيشْ مِينْ ڭِّيغْ أَكْ-ذ مِيصْرَا، ؤُ أَذْ ثْعَاوْذذْ خْ ڒعْڒَامَاثْ إِ ڭِّيغْ جَارْ أَسنْ، مَاحنْذْ أَذْ ثسّْنمْ بلِّي نشّْ ذ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ڒخْذنِّي يُوذفْ مُوسَا ذ هَارُونْ غَارْ فِيرْعُونْ، نَّانْ أَسْ: ”سِيذِي، أَربِّي ن إِعِيبْرَانِييّنْ إِنَّا: ’مشْحَاڒْ غَا ثكّذْ ثُوڭِيذْ أَذْ ثهْوِيذْ غَارْ وُوذمْ إِنُو؟ أجّْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو حِيمَا أَذْ أَيِي إِعْبذْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","مِينْزِي مَاڒَا ثُوڭِيذْ أَذْ ثجّذْ أَذْ إِرَاحْ ڒْڭنْسْ إِنُو، أَقَا أَذْ سِّيوْضغْ ثِيوشَّا ثْمُورْغِي خْ ثمُّورْثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","أَذْ ذْڒنْ ؤُذمْ ن ثمُّورْثْ أَڒْ وَارْ إِزمَّارْ حذْ أَذْ إِثْوَاڒَا ثَامُّورْثْ عَاذْ ؤُشَا أَذْ شّنْ مِينْ إِقِّيمنْ إِ إِتّْوَانجْمنْ، مِينْ ذ أَومْ إِقِّيمنْ عَاذْ أَوَارْنِي إِ ثبْرُورِّي. أَذْ ثشّْ ثْمُوغْرِي عَاوذْ مَارَّا ثِيشجُّورَا إِ ذ أَومْ د-إِغمّْينْ ذڭْ إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ؤُشَا أَذْ شُّورنْثْ ثُوذْرِينْ نّشْ ذ ثُوذْرِينْ ن إِمْسخَّارنْ نّشْ ذ ثُوذْرِينْ ن مَارَّا إِمِيصْرِييّنْ. أَمُّو وَارْ ت ژْرِينْعمَّارْصْ إِبَابَاثنْ نّشْ ذ ڒجْذُوذْ ن إِبَابَاثنْ نّشْ زڭْ وَامِي ثنْ ثُوغَا خْ ثمُّورْثْ غَارْ وَاسّْ-أَ.‘ “ ؤُشَا إِذْوڒْ-د نتَّا، إِسْمحْ ذِي فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","نَّانْ أَسْ إِمْسخَّارنْ ن فِيرْعُونْ: ”أَڒْ مڒْمِي إِ ذ أَنغْ غَا يِيڒِي وَانِيثَا ذ ڒْفخْ؟ أجّْ أَذْ رَاحنْ إِرْيَازنْ نِّي، مَاحنْذْ أَذْعبْذنْ سِيذِي أَربِّي نْسنْ! مَا وَارْ ثسِّينذْ عَاذْ بلِّي مِيصْرَا أَقَا ثتّْوَاخَارّبْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ڒخْذنِّي سِّيوْضنْ إِمْسخَّارنْ ن فِيرْعُونْ مُوسَا ذ هَارُونْ عَاوذْ غَارْ فِيرْعُونْ. نتَّا إِنَّا أَسنْ: ”رُوحمْ،عبْذمْ سِيذِي، أَربِّي نْومْ! إِنِي أَيِي، مِينْ عْنَانْ إِنِّي إِخْسنْ أَذْ رَاحنْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","إِنَّا مُوسَا: ”أَذْ نْرَاحْ أَكْ-ذ إِحْرَامنْ نّغْ ذ إِوسُّورَا نّغْ، س إِحنْجِيرنْ نّغْ ذ ثْحنْجِيرِينْ نّغْ، س وُودْجِي نّغْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نّغْ، مِينْزِي غَارْنغْ إِجّْ ن ڒْعِيذْ إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","خنِّي يَارَّا-د خَاسنْ: ”خنِّي إِتّْخصَّا أَذْ يِيڒِي سِيذِي أَطَّاصْ أَكِيذْومْ مَاڒَا أَذْ جّغْ أَذْ ثْرَاحمْ كنِّيوْ ذ إِحنْجِيرنْ إِمژْيَاننْ نْومْ. خْزَارمْ، أَقَا كنِّيوْ ثنْوِيمْ ڒْغَارْ! ");
INSERT INTO rifa_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","وَارْ إِتِّيڒِي أَمنِّي. جّمْ أَذْعبْذنْ إِرْيَازنْ إِجهْذنْ إِ سِيذِي، مِينْزِي ذ مَانْ أَيَا إِ ثتّخْسمْ.“ ؤُشَا ؤُژّْڒنْ خَاسنْ زِي قِيبَاتْشْ ن وُوذمْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”سْوِيژّضْ أَفُوسْ نّشْ خْ ثمُّورْثْ ن مِيصْرَا، حِيمَا ثَامُورْغِي أَذْ ثْڭعّذْ خْ ثمُّورْثْ ن مِيصْرَا، مَاحنْذْ أَذْ ثشّْ مَارَّا أَفْسُو أَزِيزَا ن ثمُّورْثْ، مَارَّا مِينْ إِشطّنْ خْ ثبْرُورِّي.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","إِسّْوِيژّضْ مُوسَا غَارْ ثغَّارْشْثْ نّسْ خْ ثمُّورْثْ ن مِيصْرَا ؤُشَا إِڭَّا سِيذِي أَذْ د-إِسُوضْ إِجّْ ن ؤُسمِّيضْ إِ د-يُوسِينْ زِي شَّارْقْ خْ ثمُّورْثْ وَارْ إِقطِّينْ مَارَّا أَسّْ نِّي ذ مَارَّا دْجِيڒثْ نِّي. غَارْ صّْبحْ يِيوِي-د ؤُسمِّيضْ ثَامُورْغِي. ");
INSERT INTO rifa_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ثْڭعّذْ-د ثْمُورْغِي خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا، ثْصيّحْ خْ مَارَّا جّْوَايهْ ن مِيصْرَا. أَقَا ثُوغَا ڒْحَاڒْ يوْعَارْ أَطَّاسْ. ثَامُورْغِي أَمْ ثَانِيثَا وَارْ ت ثُوغِي قْبڒْ ؤُشَا وَارْ ثتِّيڒِيعمَّارْصْ زِي سَّا غَارْ زَّاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","أَقَا ذْڒِينْثْ ؤُذمْ ن مَارَّا ثَامُّورْثْ أَڒَامِي ثسُّوثمْ ثمُّورْثْ. نِيثنْثِي شِّينْثْ مَارَّا أَفْسُو ن ثمُّورْثْ ذ مَارَّا ڒْغِيدْجثْ ن ثْشجُّورَا إِ ثُوغَا إِقِّيمنْ زِي ثبْرُورِّي. ذِي مَارَّا ثَامُّورْثْ ن مِيصْرَا وَارْ إِقِّيمْ وَالُو زِي مَارَّا ثُوزِّيزوْثْ ذِي ثْشجُّورَا نِيغْ ذڭْ وفْسُو ن إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ڒخْذنِّي إِڒَاغَا فِيرْعُونْ ذغْيَا إِ مُوسَا ذ هَارُونْ، إِنَّا: ”أَقَا خْضِيغْ أَكْ-ذ سِيذِي، أَربِّي نْومْ، ؤُڒَا أَكِيذْومْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","تّْزَاوْڭغْ ڒخُّو أَذْ أَيِي ثْسَامْحمْ خْ ؤُخطُّو إِنُو ثْوَاڒَا-يَا. ژَتدْجمْ س ڒَادْجَاغْ إِ سِيذِي، أَربِّي نْومْ، حِيمَا أَذْ خَافِي إِكّسْ ڒْموْثْ-أَ وَاهَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ؤُشَا إِفّغْ خْ فِيرْعُونْ ؤُشَا إِژُّودْجْ س ڒَادْجَاغْ غَارْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","خنِّي إِجَّا سِيذِي أَذْ د-إِعْقبْ ؤُسمِّيضْ إِ د-يُوسِينْ زِي شَّارْقْ غَارْ ڒْغَارْبْ، إِسّْجهْذْ إِ-ث أَطَّاسْ، ؤُشَا إِكّسْ ؤُسمِّيضْ ثَامُورْغِي، إِنْضَارْ إِ-ت ذِي ڒبْحَارْ ن ثلْڭَا. وَارْ ثقِّيمْ ؤُڒَا ذ إِشْثْ ن ثْمُورْغِي ذِي مَارَّا جّْوَايهْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","مَاشَا إِسّقْسحْ سِيذِي ؤُڒْ ن فِيرْعُونْ ؤُمِي وَارْ إِجِّي أَيْثْ ن إِسْرَائِيل أَذْ رَاحنْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”سْوِيژّضْ أَفُوسْ نّشْ غَارْ ؤُجنَّا، خنِّي أَذْ ثِيڒِي ثَادْجسْثْ خْ ثمُّورْثْ ن مِيصْرَا أَڒْ غَا ثَافذْ ثْزمَّارذْ أَذْ ثْحَاذِيذْ ثَادْجسْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","إِسّْوِيژّضْ مُوسَا أَفُوسْ نّسْ غَارْ ؤُجنَّا ؤُشَا ثهْوَا-د ثَادْجسْثْ ثجْهذْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا، ثْڒَاثَا ن وُوسَّانْ.    ");
INSERT INTO rifa_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ؤُڒَا ذ إِجّْ وَارْ إِثْوِيڒِي ونّغْنِي. ؤُڒَا ذ إِجّْ وَارْ إِكَّارْ زڭْ ومْشَانْ نّسْ ثْڒَاثَا ن وُوسَّانْ. مَاشَا مَارَّا أَيْثْ ن إِسْرَائِيل ثُوغَا غَارْسنْ ثَافَاوْثْ ذڭْ إِمُوشَانْ مَانِي ثُوغَا زدّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ڒخْذنِّي إِڒَاغَا فِيرْعُونْ إِ مُوسَا، إِنَّا: ”رُوحمْ، ثْعبْذمْ سِيذِي! جّمْ وَاهَا أَذْ إِقِّيمْ وُودْجِي نْومْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نْومْ. مَاشَا ثْزمَّارمْ أَذْ د-ثَاوْيمْ إِحنْجِيرنْ إِمژْيَاننْ أَكِيذْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","يَارَّا-د خَاسْ مُوسَا: ”إِتّْخصَّا شكْ عَاوذْ أَذْ أَنغْ ثوْشذْ ذڭْ ؤُفُوسْ ثِيغَارْصَا ؤُڒَا ذ ثِيغَارْصَا ن وشْمَاضْ. أَذْ ثنْثْ نسّوْجذْ ذ ثْغَارْصْطْ إِ سِيذِي، أَربِّي نّغْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ؤُڒَا ذ ڒبْهَايمْ نّغْ إِتّْخصَّا أَذْ كِيذْنغْ رَاحنْثْ، وَارْ إِتّْغِيمِي ؤُڒَا ذ إِجّْ ن ؤُشكْرُوذْ، مِينْزِي زَّايْسنْثْ إِ غَا نكْسِي، حِيمَا أَذْ نعْبذْ سِيذِي، أَربِّي نّغْ، مِينْزِي وَارْ نسِّينْ س مِينْزِي غَا نعْبذْ سِيذِي، أَربِّي نّغْ، أَڒْ ذِينْ غَا نَاوضْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","مَاشَا سِيذِي إِسّقْسحْ ؤُڒْ ن فِيرْعُونْ ؤُشَا يُوڭِي أَذْ ثنْ يجّْ أَذْ رَاحنْ. ");
INSERT INTO rifa_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","إِنَّا أَسْ فِيرْعُونْ: ”أَڭّْوجْ خَافِي! حْضَا، حِيمَا وَارْ ثْژَارّذْ عَاذْ ؤُذمْ إِنُو، مِينْزِي أَسّْ إِ ذِي غَا ثْژَارذْ ؤُذمْ إِنُو، أَذْ ثمّْثذْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","إِنَّا مُوسَا: ”أَذْ يِيڒِي أَمْ مَامّشْ إِ ثنِّيذْ: وَارْ ژَترّغْ عَاذْ ؤُذمْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","إِنَّا سِيذِي إِ مُوسَا: ”أَذْ ڒقْفغْ عَاذْ مْغِيرْ س يِيشْثنْ جّْرِيحشْثْ خْ فِيرْعُونْ ذ مِيصْرَا. أَوَارْنِي ثَا أَذْ كنِّيوْ إِسّكّْ سَّا. غَارْ ؤُنڭَّارْ خْمِي كنِّيوْ غَا يجّْ أَذْ ثْرُوحمْ مَارَّا، أَذْ خَاومْ يَاژّڒْ سَّا س ثِيذتّْ. ");
INSERT INTO rifa_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","سِيوڒْ خنِّي ذڭْ إِمزُّوغنْ ن ڒْڭنْسْ مَاحنْذْ أَذْ إِتَّارْ كُوڒْ أَرْيَازْ زڭْ وَاجَّارْ نّسْ ؤُ كُوڒْ ثَامْغَارْثْ زِي ثَاجَّارْثْ نّسْ ڒقْشُوعْ ن نُّوقَارْثْ ذ وُورغْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","سِيذِي إِوْشَا أَسْ إِ ڒْڭنْسْ أَرْضَا ذِي ثِيطَّاوِينْ ن إِمِيصْرِييّنْ. عَاوذْ ثُوغَا مُوسَا ذ إِجّْ ورْيَازْ س شَّانْ أَمقّْرَانْ ذِي ثمُّورْثْ ن مِيصْرَا ذِي ثِيطَّاوِينْ ن ڒْڭنْسْ ؤُ ذِي ثِيطَّاوِينْ ن إِمْسخَّارنْ ن فِيرْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","إِنَّا مُوسَا: ”أَمُّو إِ إِنَّا سِيذِي: ’غَارْ وزْينْ ن دْجِيڒثْ نشّْ أَذْ عْذُوغْ ذِي ڒْوسْطْ ن مِيصْرَا ");
INSERT INTO rifa_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ؤُشَا أَذْ إِمّثْ كُوڒْ أَمنْزُو ذِي ثمُّورْثْ ن مِيصْرَا، زڭْ ؤُمنْزُو ن فِيرْعُونْ، ونِّي إِقِّيمنْ خْ ڒْعَارْشْ ن ثْڭلْذِيثْ، أَڒْ أَمنْزُو ن ثَايَّا، ثنِّي إِقِّيمنْ أَوَارْنِي إِ ثْسِيرْثْ ثْحَارِّي إِمنْذِي، ؤُڒَا ذ كُوڒْ أَمنْزُو زِي ڒبْهَايمْ. ");
INSERT INTO rifa_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","أَذْ ذِينْ ثِيڒِي إِشْثْ ن ثْغُويِّيثْ ذ ثَامقّْرَانْثْ خْ مَارَّا ثَامُّورْثْ ن مِيصْرَا إِ وَارْ ثُوغِيعمَّارْصْ نِيغْعمَّارْصْ عَاذْ أَذْ ثِيڒِي. ");
INSERT INTO rifa_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","مَاشَا غَارْ مَارَّا أَيْثْ ن إِسْرَائِيل، وَارْ إِتّْژُو ؤُڒَا ذ إِجّْ ن وقْزِينْ خْ إِوْذَانْ ؤُڒَا خْ ڒْمَاڒْ، مَاحنْذْ أَذْ ثسّْنمْ، بلِّي سِيذِي إِتّڭّْ ڒْفَارْزْ جَارْ إِمِيصْرِييّنْ ذ إِسْرَائِيل.‘ ");
INSERT INTO rifa_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","خنِّي أَذْ غَارِي د-هْوَانْ مَارَّا إِمْسخَّارنْ نّشْ، أَذْ أَيِي بنْذْقنْ، أَذْ إِنِينْ: ’فّغْ شكْ ذ مَارَّا ڒْڭنْسْ إِ شكْ إِضفَّارنْ ذڭْ إِصُورَافْ نّشْ!‘ أَوَارْنِي مَانْ أَيَا نشّْ أَذْ فّْغغْ.‘ “ ؤُشَا إِفّغْ خْ فِيرْعُونْ، ثكَّارْ ذَايسْ ثْمسِّي س ؤُخيّقْ. ");
INSERT INTO rifa_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","أَقَا إِنَّا سِيذِي إِ مُوسَا: ”فِيرْعُونْ وَارْ ذ أَومْ إِتّسْڒِي شَا، حِيمَا أَذْ مْغَارنْثْ ڒعْڒَامَاثْ إِنُو ذِي ثمُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","أَقَا مُوسَا ذ هَارُونْ ڭِّينْ مَارَّا ڒعْڒَامَاثْ-أَ زَّاثْ إِ وُوذمْ ن فِيرْعُونْ، مَاشَا سِيذِي ثُوغَا إِسّقْسحْ ؤُڒْ ن فِيرْعُونْ أَڒَامِي وَارْ إِجِّي أَذْ فّْغنْ أَيْثْ ن إِسْرَائِيل زِي ثمُّورْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ ذِي ثمُّورْثْ ن مِيصْرَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","”أَيُورْ-أَ أَذْ أَومْ يِيڒِي ذ أَزدْجِيفْ ن إِيُورنْ. أَذْ أَومْ يِيڒِي وَا إِ كنِّيوْ ذ أَمزْوَارُو ن إِيُورنْ ن ؤُسڭّْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","سِيوڒْ غَارْ مَارَّا ثَامسْمُونْثْ ن إِسْرَائِيل، إِنِي: ’ذڭْ وَاسّْ وِيسّْعشْرَا أَذْ إِكْسِي كُوڒْ إِجّْ إِ يِيخفْ نّسْ إِجّْ ن يزْمَارْ خْ مَارَّا ڒَْادْجْ ن ثَادَّارْثْ إِ د-إِقَّارْصنْ زڭْ إِبَابَاثنْ، إِجّْ ن يزْمَارْ خْ إِشْثْ ن ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","مَاشَا مَاڒَا رَادْجْ ن ثَادَّارْثْ ثُوغَا إِمْژِي إِ يزْمَارْ، خنِّي إِتّْخصَّا أَذْ إِكْسِي أَكْ-ذ وَاجَّارْ نّسْ يُوذْسنْ غَارْ ثَادَّارْثْ نّسْ عْلَاحْسَابْ ڒْْقدّْ ن إِوْذَانْ. زِي جِّيهثْ ن يزْمَارْ أَذْ ثوْثمْ ڒحْسَابْ إِ مِينْ غَا يشّْ كُوڒْ إِجّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","أَذْ يِيڒِي ذ إِزْمَارْ إِشْنَانْ قَاعْ، أَوْثمْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَذْ ث ثكْسِيمْ زڭْ إِحُوڒِييّنْ نِيغْ زڭْ إِغَايْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","أَذْ ث ثْخمّْڒمْ أَڒْ أَسّْ أَرْبعْطَاشْ زڭْ ؤُيُورْ-أَ ؤُشَا أَذْ أَسْ إِغَارْصْ مَارَّا أَڭْرَاوْ ن ثْمسْمُونْثْ ن إِسْرَائِيل جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","أَذْ كْسِينْ شَا زڭْ إِذَامّنْ ؤُشَا أَذْ ث ڭّنْ خْ ثْنَاينْ ن ڒضْرُوفْ إِ إِدْجَانْ غَارْ ؤُغزْذِيسْ ن ثوَّارْثْ ؤُ خْ ثْنبْذَاثْ سنّجْ إِ ثوَّارْثْ ن ثُوذْرِينْ مَانِي ث غَا شّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","أَذْ شّنْ أَيْسُومْ ذِي دْجِيڒثْ نِّي، أَيْسُومْ إِشنّْفنْ غَارْ ثْمسِّي أَكْ-ذ وغْرُومْ بْڒَا أَنْثُونْ. أَذْ ث شّنْ س ڒبْزَارْ يَارْزڭْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","وَارْ ث تّتّمْ شَا ذ أَزِيزَا نِيغْ ينْوَانْ ذڭْ وَامَانْ، مَاشَا مْغِيرْ مَاڒَا إِتّْوَاشنّفْ ذِي ثْمسِّي، أَكْ-ذ ؤُزدْجِيفْ نّسْ ذ إِضَارنْ نّسْ ذ وَاذَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","وَارْ زَّايسْ تّجِّيمْ وَالُو غَارْ صّْبحْ، مَاشَا مِينْ زَّايسْ غَا إِقِّيمنْ غَارْ صّْبحْ، إِتّْخصَّا كنِّيوْ أَذْ ث ثْشمْضمْ ذِي ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","أَمُّو إِ ذ أَومْ إِتّْخصَّا أَذْ ث ثشّمْ: ثَاجْعِينَّا نْومْ أَذْ ثِيڒِي ثبْيسْ، سَانْذَالِييَاثْ نْومْ ذڭْ إِضَارنْ نْومْ ؤُ ثَاغَّارْشْثْ نْومْ ذڭْ ؤُفُوسْ نْومْ ؤُشَا أَذْ ث ثشّمْ ذغْيَا. أَقَا-ث ذ ثَاغَارْصْثْ ن ؤُسعْذُو ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","مِينْزِي ذِي دْجِيڒثْ-أَ، نشّْ أَذْ عْذُوغْ خْ ثمُّورْثْ ن مِيصْرَا ؤُشَا أَذْ وْثغْ كُوڒْ أَمنْزُو ذِي ثمُّورْثْ ن مِيصْرَا، أَمُّو ذڭْ إِوْذَانْ ؤُڒَا ذِي ڒْمَاڒْ، ؤُشَا أَذْ سِّيوْضغْ ڒحْكَامَاثْ إِنُو خْ مَارَّا إِربِّيثنْ ن مِيصْرَا، نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ؤُشَا إِذَامّنْ أَذْ أَومْ إِڒِينْ ذ إِشْثْ ن ڒعْڒَامثْ خْ ثُوذْرِينْ مَانِي ثْزدّْغمْ كنِّيوْ. مَاڒَا ژْرِيغْ إِذَامّنْ، أَذْ خَاومْ عْذُوغْ. وَارْ ثتِّيڒِي جّْرِيحشْثْ إِنقّنْ جَارْ أَومْ، خْمِي غَا وْثغْ ثَامُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","أَسّْ-أَ أَذْ أَومْ يِيڒِي ذ إِجّْ ن وَاسّْ إِ ڒِيذَارثْ ؤُشَا أَذْ زَّايسْ ثْعيّْذمْ إِ سِيذِي. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ، حِيمَا أَذْ زَّايسْ ثْعيّْذمْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","سبْعَا ن وُوسَّانْ أَذْ ثشّمْ أَغْرُومْ بْڒَا أَنْثُونْ. نِيشَانْ ذڭْ وَاسّْ أَمزْوَارُو أَذْ ثسُّوفّْغمْ أَنْثُونْ زِي ثُوذْرِينْ نْومْ، مِينْزِي مَانْ ونْ إِ غَا إِشّنْ شَا س ونْثُونْ، زڭْ وَاسّْ أَمزْوَارُو أَڒْ أَسّْ وِيسّْ سبْعَا، بْنَاذمْ نِّي أَذْ إِتّْوَاقسّْ زِي إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ذڭْ وَاسّْ أَمزْوَارُو أَذْ يِيڒِي إِجّْ ن ؤُمُونِي إِقدّْسنْ ؤُشَا عَاوذْ ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ذِينْ يِيڒِي إِجّْ ن ؤُمُونِي إِقدّْسنْ. ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ وَارْ ثتّْوَاڭّْ شَا ذڭْ وُوسَّانْ نِّي. مْغِيرْ مِينْ غَا يشّْ كُوڒْ إِجّْ، ذ مَانْ أَيَا وَاهَا إِعدّڒْ أَذْ زَّايْومْ إِتّْوَاسّوْجذْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","أَذْ ثحْضَامْ ڒْْعِيذْ ن وغْرُومْ بْڒَا أَنْثُونْ، مِينْزِي ذڭْ وَاسّْ نِّي أَقَا سُّوفّْغغْ-د كنِّيوْ زِي ثمُّورْثْ ن مِيصْرَا. أَذْ ثحْضَامْ أَسّْ-أَ ذِي مَارَّا جِّيڒَاثْ نْومْ، أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ذڭْ ؤُيُورْ أَمزْوَارُو، ذڭْ وَاسّْ وِيسّْ أَرْبعْطَاشْ ن ؤُيُورْ، ذِي دْجِيڒثْ، أَذْ ثشّمْ أَغْرُومْ بْڒَا أَنْثُونْ أَڒْ دْجِيڒثْ ن وَاسّْ وَاحِيثْ ؤُ-عِيشْرِينْ زڭْ ؤُيُورْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","سبْعَا ن وُوسَّانْ وَارْ إِتّْوِيفِّي ونْثُونْ ذِي ثُوذْرِينْ نْومْ، مِينْزِي مَانْ ونْ إِ غَا إِشّنْ زِي مِينْ إِدْجَانْ س ونْثُونْ، مَا ذ أَبَارَّانِي نِيغْ ذ مِّيسْ ن ثمُّورْثْ، بْنَاذمْ نِّي أَذْ إِتّْوَاقسّْ زِي ثْمسْمُونْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","وَارْ تّتّمْ وَالُو زِي مِينْ إِدْجَانْ س ونْثُونْ. ذِي مَارَّا ثِيزدَّاغْ نْومْ أَذْ ثشّمْ أَغْرُومْ بْڒَا أَنْثُونْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","إِڒَاغَا مُوسَا إِ مَارَّا إِمْغَارنْ ن إِسْرَائِيل، إِنَّا أَسنْ: ”طّْفمْ، كْسِيمْ إِجّنْ زڭْ وُودْجِي إِ يِيخفْ نْومْ، إِ ڒَادْجَاثْ نْومْ ؤُ غَارْصمْ ث إِ ثْغَارْصْثْ ن ؤُسعْذُو. ");
INSERT INTO rifa_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","طّْفمْ إِشْثْ ن ثْقبِّيضْثْ ن ثْعلْدْجثْ، سْغضْسمْ ت ذڭْ إِذَامّنْ نِّي إِدْجَانْ ذِي طّبْصِي،غمْسنْ خنِّي زڭْ إِذَامّنْ إِ إِدْجَانْ ذِي طّبْصِي خْ ثْنبْذَاثْ سنّجْ إِ ثوَّارْثْ ؤُ خْ ثْنَاينْ ن ڒضْرُوفْ غَارْ ؤُغزْذِيسْ ن ثوَّارْثْ. أَڒْ صّْبحْ وَارْ إِتّفّغْ ؤُڒَا ذ إِجّنْ زَّايْومْ زِي ثوَّارْثْ ن ثَادَّارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","سِيذِي أَذْ إِژْوَا خْ ثمُّورْثْ، مَاحنْذْ أَذْ إِوّثْ إِمِيصْرِييّنْ، مَاشَا خْمِي غَا إِژَارْ إِذَامّنْ خْ ثْنبْذَاثْ ن نّجْ ؤُ خْ ثْنَاينْ ن ڒضْرُوفْ غَارْ ؤُغزْذِيسْ ن ثوَّارْثْ، خنِّي أَذْ إِعْذُو سِيذِي ثَاوَّارْثْ نِّي، وَارْ إِتّجِّي أَمْثحَّايْ أَذْ يَاذفْ غَارْ ثُوذْرِينْ نْومْ، حِيمَا أَذْ إِوّثْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","حْضَامْ أَوَاڒْ-أَ إِ نِّيغْ، أَقَا ذ ثوْصيّثْ إِ شكْ ؤُ إِ إِحنْجِيرنْ نّشْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","أَذْ يِيڒِي، خْمِي غَا ثَاذْفمْ غَارْ ثمُّورْثْ ثنِّي ذ أَومْ غَا يوْشْ سِيذِي، أَمْ مَامّشْ إِنَّا نتَّا، أَذْ ثحْضَامْ أَعْبَاذْ-أَ ن ڒِيذَارثْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ؤُشَا خْ مِينِّي ذ أَومْ غَا إِنِينْ إِحنْجِيرنْ نْومْ: ’مِينْ إِخْسْ أَذْ يِينِي وعْبَاذْ-أَ ن ڒِيذَارثْ إِ كنِّيوْ؟‘، ");
INSERT INTO rifa_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","خنِّي أَذْ ثِينِيمْ: ’أَقَا ذ ثَاغَارْصْثْ ن ؤُسعْذُو إِ سِيذِي ونِّي إِعْذُونْ خْ ثُوذْرِينْ ن أَيْثْ ن إِسْرَائِيل ذِي مِيصْرَا، ؤُمِي إِوْثَا إِمِيصْرِييّنْ ؤُشَا إِفكّْ ثُوذْرِينْ نّغْ.‘ “ ڒخْذنِّي يُوضَارْ ڒْڭنْسْ ؤُشَا بنْذْقنْ نِيثْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","رُوحنْ أَيْثْ ن إِسْرَائِيل ؤُشَا ڭِّينْ أَمْ مَامّشْ ثنْ يُومُورْ سِيذِي إِ مُوسَا ذ هَارُونْ ؤُ أَمُّو إِ ت ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ثُوغَا غَارْ وزْينْ ن دْجِيڒثْ ؤُمِي إِوْثَا سِيذِي مَارَّا إِمنْزَا ذِي ثمُّورْثْ ن مِيصْرَا س ڒْموْثْ، زڭْ ؤُمنْزُو ن فِيرْعُونْ، ونِّي إِقِّيمنْ خْ ڒْعَارْشْ نّسْ، أَڒْ أَمنْزُو ن ؤُمحْبُوسْ إِ إِدْجَانْ ذِي ڒحْبسْ، ؤُڒَا ذ مَارَّا إِمنْزَا ن ڒبْهَايمْ.    ");
INSERT INTO rifa_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","إِكَّارْ فِيرْعُونْ ذِي دْجِيڒثْ نِّي، نتَّا ذ مَارَّا إِمْسخَّارنْ نّسْ ذ مَارَّا إِمِيصْرِييّنْ ؤُشَا ثُوغَا ذِينْ إِشْثْ ن ثْغُويِّيثْ ثمْغَارْ مِينْزِي وَارْ ثُوغِي ؤُڒَا ذ إِشْثْ ن ثَادَّارْثْ مَانِي وَارْ إِدْجِي ؤُمتِّينْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ؤُشَا إِڒَاغَا-د إِ مُوسَا ذ هَارُونْ س دْجِيڒثْ، إِنَّا: ”كَّارمْ، ثفّْغمْ زِي ڒْوسْطْ ن ڒْڭنْسْ إِنُو، كنِّيوْ جْمِيعْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، رُوحمْ، ثْعبْذمْ سِيذِي، أَمْ مَامّشْ ثنَّامْ كنِّيوْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","أَوْيمْ ؤُدْجِي نْومْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نْومْ، أَمْ مَامّشْ ثنَّامْ. رُوحمْ، مَاشَا تّْزَاوْڭغْ كنِّيوْ، بَارْكمْ أَيِي نشّْ عَاوذْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","زيَّارنْ إِمِيصْرِييّنْ أَطَّاسْ خْ ڒْڭنْسْ، مَاحنْذْ نِيثْنِي أَذْ فّْغنْ س ؤُقدْجقْ زِي ثمُّورْثْ، مِينْزِي إِمِيصْرِييّنْ نَّانْ: ”أَقَا نشِّينْ مَارَّا ذ إِمتَّانْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ؤُشَا يِيوِي ڒْڭنْسْ أَرشْثِي نّسْ قْبڒْ مَا غَا إِنْضُو ؤُشَا ثِيبقْيِينْ نّْضنْ ثنْثْ جَارْ وَارُّوضْ نْسنْ خْ طْغَارْضِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","أَيْثْ ن إِسْرَائِيل ڭِّينْ عْلَاحْسَابْ أَوَاڒْ إِ ذ أَسنْ إِنَّا مُوسَا، تَّارنْ ڒقْشُوعْ ن نُّوقَارْثْ ذ وُورغْ ذ وَارُّوضْ زڭْ إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","سِيذِي إِوْشَا ڒْڭنْسْ أَرْضَا ذِي ثِيطَّاوِينْ ن إِمِيصْرِييّنْ، وْشِينْ أَسنْ مِينْ تَّارنْ، ؤُ أَمُّو إِ كشّْضنْ نِيثْنِي إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","فسْينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ، ؤُيُورنْ زِي رَاعَامْسِيسْ غَارْ سُوكُّوثْ، ثُوغَا أَثنْ عْڒَاحَاڒْ ذِي ستَّا-مْيَاثْ-أَڒفْ خْ إِضَارنْ، تّْوَاحسْبنْ إِرْيَازنْ وَاهَا، بْڒَا إِحنْجِيرنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","إِڭعّذْ أَكِيذْسنْ إِجّْ ن ؤُبَارُّو ذ أَمقّْرَانْ ن عْڒَامْ كُوڒْ إِوْذَانْ، خنِّي عَاوذْ ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ، أَقَا-ت ذ إِشْثْ ن ثْحِيمَارْثْ ثمْغَارْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","س وَارشْثِي إِ كِيذْسنْ د-إِوْينْ زِي مِيصْرَا ڭّْوِينْ ثِيفْضِيرِينْ بْڒَا أَنْثُونْ، مِينْزِي ثُوغَا عَاذْ وَارْ إِسْمِيمْ، مِينْزِي ؤُژّْڒنْ خَاسنْ-د زِي مِيصْرَا ؤُ وَارْ زمَّارنْ أَذْ بدّنْ مَاحنْذْ أَذْ أَريّْحنْ ؤُ وَارْ سّْوجْذنْ مَاشَّا إِ وبْرِيذْ إِ يِيخفْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ثُوغَا ڒْْمِيجَاڒْ ن ثْزذِّيغْثْ ن أَيْثْ ن إِسْرَائِيل ذِي مِيصْرَا، ڒْْمِيجَارْ إِ ذِينْ إِزذْغنْ، أَربْعَا-مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","غَارْ ؤُنڭَّارْ ن أَربْعَا-مْيَا ؤُ-ثْڒَاثِينْ ن إِسڭّْوُوسَا، ذڭْ وَاسّْ نِّي سِيمَانْثْ نّسْ، فّْغنْ مَارَّا ڒْعسْكَارْ ن سِيذِي زِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ثَانِيثَا أَقَا-ت ذ إِشْثْ ن دْجِيرثْ إِتّْخصَّا أَذْ ثتّْوَاحْضَا إِ ڒوْقَارْ إِ سِيذِي، مَاغَارْ نتَّا إِنْذهْ إِ-ثنْ زِي ثمُّورْثْ ن مِيصْرَا. دْجِيڒثْ-أَ ثَانِيثَا، أَقَا-ت إِ سِيذِي. إِتّْخصَّا أَذْ ثتّْوَاحْذَا زِي مَارَّا أَيْثْ ن إِسْرَائِيل، ذِي مَارَّا جِّيڒَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","إِنَّا سِيذِي إِ مُوسَا ذ هَارُونْ: ”ذ ثَا ذ ثَاوْصيّثْ خْ ثْغَارْصْثْ ن ؤُسعْذُو: وَارْ زَّايسْ إِتّتّْ مِّيسْ ن ؤُبَارَّانِي، ");
INSERT INTO rifa_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","مَاشَا كُوڒْ إِسْمغْ إِمّسْغنْ زڭْ إِجّْ ن ورْيَازْ س نُّوقَارْثْ، إِزمَّارْ أَذْ زَّايسْ يشّْ، مَاڒَا ثْخثْنذْ أَسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","أَمْعزّبْ ذ ؤُشوَّاڒْ وَارْ زَّايسْ تّتّنْ شَا. ");
INSERT INTO rifa_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","أَذْ إِتّْوَاشّْ ذِي ثَادَّارْثْ ذ إِشْثْ ؤُ وَارْ إِتّفّغْ وَالُو زڭْ ويْسُومْ نِّي غَارْ بَارَّا ن ثَادَّارْثْ ؤُشَا وَارْ زَّايسْ إِتَّارژِّي ؤُڒَا ذ إِجّْ ن يِيغسْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","مَارَّا ثَامسْمُونْثْ ن إِسْرَائِيل أَذْ ثڭّْ أَمنِّي. ");
INSERT INTO rifa_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","مَاڒَا شَا ن ؤُبَارَّانِي إِنّوْجوْ-د غَاركْ ؤُشَا إِخْسْ أَذْ إِسّوْجذْ ثَاغَارْصْثْ ن ؤُسعْذُو إِ سِيذِي، إِتّْخصَّا أَذْ إِتّْوَاخْثنْ كُوڒْ أَرْيَازْ نِّي غَارسْ إِدْجَانْ. ڒخْذنِّي أَذْ د-إِقَارّبْ، أَذْ ت إِسّوْجذْ، ؤُشَا أَذْ يِيڒِي أَمْ ونِّي د-إِخڒْقنْ ذِي ثمُّورْثْ. مَاشَا ؤُڒَا ذ إِجّْ زڭْ إِنِّي وَارْ إِخْثِيننْ وَارْ إِزمَّارْ أَذْ زَّايسْ يشّْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","أَذْ ذِينْ يِيڒِي إِجّْ ن ؤُزرْفْ إِ ونِّي د-إِخڒْقنْ ذِي ثمُّورْثْ ؤُ إِ ؤُبَارَّانْ إِ إِزدّْغنْ جَارْ أَومْ أَمْ ؤُبَارَّانِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ؤُشَا مَارَّا أَيْثْ ن إِسْرَائِيل ڭِّينْ أَمْ مَامّشْ ذ أَسنْ يُومُورْ مُوسَا ذ هَارُونْ، أَمُّو إِ ت ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ؤُشَا إِمْسَارْ ذڭْ وَاسّْ نِّي سِيمَانْثْ نّسْ إِسُّوفُّوغْ سِيذِي أَيْثْ ن إِسْرَائِيل زِي ثمُّورْثْ ن مِيصْرَا أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ إِسذِّييّنْ ن ڒْعسْكَارْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","”سْقدّسْ أَيِي كُوڒْ أَمنْزُو، ونِّي زِي جَارْ أَيْثْ ن إِسْرَائِيل يَارزْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو، أَمْ زڭْ إِوْذَانْ أَمْ زِي ڒبْهَايمْ. نتَّا أَقَا إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","إِنَّا مُوسَا إِ ڒْڭنْسْ: ”إِذَارمْ أَسّْ-أَ مِينْ ذِي ثفّْغمْ زِي مِيصْرَا، زِي ثَادَّارْثْ ن ثسْمُوغِي، مِينْزِي سِيذِي إِسُّوفّغْ-د كنِّيوْ زَّايسْ س ؤُفُوسْ إِجهْذنْ. ذڭْ وَاسّْ-أَ وَارْ ثتّتّمْ وَالُو مِينْ ذِي إِدْجَا ونْثُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","أَسّْ-أَ أَذْ ثفّْغمْ، ذڭْ ؤُيُورْ ن أَبِيبْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","مَاڒَا سِيذِي إِسِّيذفْ إِ شكْ غَارْ ثمُّورْثْ ن أَيْثْ ن كنْعَانْ ذ إِحِيتِّييّنْ ذ إِمُورِييّنْ ذ إِحِيوِييّنْ ذ إِيابُوسِييّنْ، خْ ثنِّي إِجُّودْجْ إِ ڒجْذُوذْ نْومْ أَذْ أَشْ ت إِوْشْ، ثَامُّورْثْ إِفيّْضنْ س ؤُغِي ذ ثَامّنْثْ، خنِّي أَذْ ثحْضَامْ أَعْبَاذْ-أَ ن ڒِيذَارثْ ذڭْ ؤُيُورْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","سبْعَا ن وُوسَّانْ أَذْ ثشّذْ أَغْرُومْ بْڒَا أَنْثُونْ ؤُشَا ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ذِينْ يِيڒِي إِجّْ ن ڒْعِيذْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","سبْعَا ن وُوسَّانْ أَذْ إِتّْوَاشّْ وغْرُومْ بْڒَا أَنْثُونْ ؤُشَا وَارْ غَاركْ إِتّْوِيفِّي مِينْ إِخمّْرنْ. ذِي مَارَّا جّْوَايهْ نّشْ وَارْ إِتّْوِيفِي ونْثُونْ غَاركْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ذڭْ وَاسّْ نِّي أَذْ ثْحَاجِيذْ إِ مِّيشْ، أَذْ أَسْ ثِينِيذْ: مَانْ أَيَا ذِي طّْوعْ ن مِينْ ذ أَيِي إِڭَّا سِيذِي ؤُمِي د-فّْغغْ زِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","أَذْ أَشْ يِيڒِي أَمْ يِيجّْ ن ؤُشيَّارْ خْ ؤُفُوسْ نّشْ ؤُ إِ ڒِيذَارثْ جَارْ ثِيطَّاوِينْ نّشْ، مَاحنْذْ شَّارِيعَا ن سِيذِي أَذْ ثِيڒِي ذڭْ ؤُقمُّومْ نّشْ، مِينْزِي س ؤُفُوسْ إِجهْذنْ إِسُّوفّغْ سِيذِي إِ كنِّيوْ زِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","س ؤُيَا إِ غَا ثحْضِيذْ ثَاوْسِييّثْ-أَ ذِي ڒْوقْثْ نّسْ إِ ذ أَسْ إِتّْوَاڭّنْ، زڭْ ؤُسڭّْوَاسْ غَارْ ؤُسڭّْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","أَذْ يِيڒِي خْمِي شكْ غَا إِسِّيذفْ سِيذِي ذِي ثمُّورْثْ ن أَيْثْ ن كنْعَانْ، أَمْ مَامّشْ إِ ذ أَشْ إِجُّودْجْ ؤُڒَا إِ ڒجْذُوذْ نّشْ، ؤُشَا إِوْشَا أَشْ ت، ");
INSERT INTO rifa_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","خنِّي أَذْ ثسّعْذُوذْ غَارْ سِيذِي كُوڒْ أَمنْزُو إِ يَارزْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو ؤُڒَا ذ كُوڒْ أَمنْزُو ن ڒبْهَايمْ إِ يَارزْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو: إِوثْمَانْ أَذْ إِڒِينْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","مَاشَا كُوڒْ أَمنْزُو إِ يَارزْمنْ ڒمْڒَاوْڒثْ ن وغْيُوڒْ ذ أَمزْوَارُو، أَذْ ث ثفْذِيذْ س يِيجّْ زڭْ وُودْجِي. مَاڒَا وَارْ ث ثفْذِيذْ، أَذْ أَسْ ثَارْژذْ إِرِي. كُوڒْ أَمنْزُو ن بْنَاذمْ زڭْ إِحنْجِيرنْ نّشْ أَذْ ث ثفْذِيذْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ؤُشَا أَذْ إِمْسَارْ، خْمِي شكْ غَا إِسّقْسَا مِّيشْ ثِيوشَّا، أَذْ يِينِي: ’مَانَاوْيَا؟‘، أَذْ أَسْ ثِينِيذْ: ’أَقَا إِسُّوفُّوغْ أَنغْ-د سِيذِي زِي مِيصْرَا س ؤُفُوسْ إِجهْذنْ، زِي ثَادَّارْثْ ن ثسْمُوغِي. ");
INSERT INTO rifa_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ڒَْامِي ذ أَنغْ إِبدّْ فِيرْعُونْ ذڭْ وبْرِيذْ إِ وُوفُّوغْ نّغْ، إِمْسَارْ أَقَا سِيذِي إِنْغَا مَارَّا إِمنْزَا ذِي ثمُّورْثْ ن مِيصْرَا، زڭْ ؤُمنْزُو ن بْنَاذمْ أَڒْ أَمنْزُو ن ڒبْهِيمثْ. خْ ؤُيَا قدّْمغْ كُوڒْ أَمنْزُو إِ يَارزْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو ذ ثَاغْرَاصْثْ إِ سِيذِي، مَاشَا كُوڒْ أَمنْزُو جَارْ إِحنْجِيرنْ إِنُو، أَذْ ث فْذِيغْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","أَذْ يِيڒِي ذ أَشيَّارْ خْ ؤُفُوسْ نّشْ ذ إِجّْ ن ؤُفِيڒُو ن ؤُسڭّمْ جَارْ ثِيطَّاوِينْ نّشْ، مِينْزِي سِيذِي أَقَا إِسُّوفّغْ أَنغْ-د زِي مِيصْرَا س ؤُفُوسْ إِجهْذنْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ؤُمِي إِجَّا فِيرْعُونْ ڒْڭنْسْ أَذْ إِرَاحْ، وَارْ ثنْ إِنْذِيهْ أَربِّي غَارْ وبْرِيذْ ن ثمُّورْثْ ن إِفِيلِيسْطِينِييّنْ، وَاخَّا نتَّاثْ ثُوذسْ، مِينْزِي أَربِّي إِنَّا: ”مَاحنْذْ وَارْ إِتّنْذمِّي ڒْڭنْسْ خْمِي غَا إِژَارْ ڒْبَارُوضْ ؤُشَا أَذْ د-إِذْوڒْ غَارْ مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","إِنْذهْ أَربِّي ڒْڭنْسْ، مَاحنْذْ أَذْ إِكّْ خْ وبْرِيذْ ن ڒخْڒَا غَارْ ڒبْحَارْ ن ثلْڭَا. ؤُشَا ڭعّْذنْ أَيْثْ ن إِسْرَائِيل زِي مِيصْرَا وجْذنْ إِ ؤُمنْغِي. ");
INSERT INTO rifa_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","إِكْسِي مُوسَا أَكِيذسْ إِغْسَانْ ن يُوسُوفْ، مِينْزِي نتَّا إِسّْجُودْجْ أَيْثْ ن إِسْرَائِيل س إِشْثْ ن ثْژَادْجِيثْ، إِنَّا: ”س ثِيذتّْ أَذْ غَارْومْ د-يَارْزفْ أَربِّي، ؤُشَا أَذْ ثسّْڭعّْذمْ إِغْسَانْ إِنُو سَّا أَكِيذْومْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ؤُشَا فسْينْ إِقِيضَانْ نْسنْ، ڭّْوجنْ خْ سُوكُّوثْ ؤُشَا وْثِينْ إِقِيضَانْ نْسنْ ذِي إِثَامْ، غَارْ طَّارْفْ ن ڒخْڒَا. ");
INSERT INTO rifa_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","سِيذِي إِزْوَارْ إِ ثِيطَّاوِينْ نْسنْ ذڭْ ؤُژِيڒْ ذڭْ إِجّْ ن ؤُقلِّيجْ ن ؤُسيْنُو، مَاحنْذْ أَذْ ثنْ إِڭوّذْ ذڭْ وبْرِيذْ، ؤُ ذِي دْجِيڒثْ ذڭْ إِجّْ ن ؤُقلِّيجْ ن ثْمسِّي، حِيمَا أَذْ غَارْسنْ إِڭّْ ثَافَاوْثْ، حِيمَا أَذْ ثَافْ زمَّارنْ أَذْ ؤُيُورنْ أَسّْ ذ دْجِيڒثْ. ");
INSERT INTO rifa_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ذڭْ وَاسّْ وَارْ د-إِكِّيسْ أَقلِّيجْ ن ؤُسيْنُو زَّاثْ إِ ؤُغمْبُوبْ ن ڒْڭنْسْ ؤُڒَا ذِي دْجِيڒثْ وَارْ د-إِكِّيسْ أَقلِّيجْ ن ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","خنِّي إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، مَاحنْذْ أَذْ د-ذوْڒنْ ؤُشَا أَذْ وْثنْ إِقِيضَانْ نْسنْ زَّاثْ إِ فِي-هَاخِيرُوثْ، جَارْ مِيڭْذُولْ ذ ڒبْحَارْ، قِيبَاتْشْ إِ بَاعَالْ-صَافُونْ. أَرنْذَاذْ نّسْ أَذْ ثوْثمْ إِقِيضَانْ نْومْ خْ ثْمَا ن ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","خنِّي أَذْ يِينِي فِيرْعُونْ خْ أَيْثْ ن إِسْرَائِيل: ’أَقَا نِيثْنِي ودَّارنْ ذِي ثمُّورْثْ، أَقَا ڒخْڒَا إِحْصَارْ إِ-ثنْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ؤُشَا نشّْ أَذْ سّْقسْحغْ ؤُڒْ ن فِيرْعُونْ، حِيمَا أَذْ ثنْ إِضْفَارْ ؤُ نشّْ أَذْ تّْوَاسّْعُودْجِيغْ خْ فِيرْعُونْ ؤُ خْ مَارَّا ڒْعسْكَارْ نّسْ ؤُشَا أَذْ سّْننْ إِمِيصْرِييّنْ بلِّي نشّْ ذ سِيذِي.“ ؤُشَا أَمُّو إِ ت ڭِّينْ نِيثْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ؤُشَا خبَّارنْ إِ ؤُجدْجِيضْ ن مِيصْرَا بلِّي ڒْڭنْسْ يَارْوڒْ. خنِّي إِبدّڒْ وُوڒْ ن فِيرْعُونْ ذ إِمْسخَّارنْ نّسْ خْ ڒْڭنْسْ ؤُشَا نَّانْ: ”مَامّشْ إِ نڭَّا أَيَا، نسّكّْ إِسْرَائِيل زِي ثسْمُوغِي إِ إِڭِّينْ إِ نشِّينْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ؤُشَا إِحزّمْ فِيرْعُونْ أَكَارُّو نّسْ، إِكْسِي أَكِيذسْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","إِكْسِي أَكِيذسْ ستَّا-مْيَا ن إِكَارُّوثنْ إِشوَّارنْ ذ مَارَّا إِكَارُّوثنْ ن مِيصْرَا ؤُشَا إِڭَّا أَشوَّارْ ن إِنغْرَافنْ زِي ڒْعسْكَارْ نّسْ خْ كُوڒْ إِجّْ زَّايْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","أَقَا إِسّقْسحْ سِيذِي ؤُڒْ ن فِيرْعُونْ، أَجدْجِيذْ ن مِيصْرَا، ؤُشَا يَارْذفْ نتَّا أَيْثْ ن إِسْرَائِيل، مَاشَا أَيْثْ ن إِسْرَائِيل ثُوغَا فّْغنْ س يِيجّْ ن ؤُفُوسْ إِتّْوَاسّْڭعّْذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","أَرذْفنْ ثنْ إِمِيصْرِييّنْ ؤُشَا إِوْضنْ غَارْسنْ س مَارَّا إِيْسَانْ ذ إِكَارُّوثنْ ن فِيرْعُونْ ذ إِمْنَاينْ نّسْ ذ ڒْعسْكَارْ نّسْ، غَارْ فِي-هَاخَارُوثْ، غَارْ ؤُجمَّاضْ ن بَاعَالْ-صَافُونْ، مَانِي وْثِينْ إِقِيضَانْ نْسنْ غَارْ ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ڒَْامِي ثنْ د-يُوذسْ فِيرْعُونْ، سّْڭعّْذنْ أَيْثْ ن إِسْرَائِيل ثَامُوغْڒِي نْسنْ، ژْرِينْ بلِّي إِمِيصْرِييّنْ ضْفَارنْ ثنْ-د ؤُشَا نِيثْنِي ڭّْوذنْ أَطَّاسْ. خنِّي سْغُوينْ أَيْثْ ن إِسْرَائِيل غَارْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","نَّانْ إِ مُوسَا: ”مَا وَارْ دْجِينْ عَاذْ إِمضْڒَانْ ذِي مِيصْرَا أَڒْ ذ أَنغْ د-ثَاوْيذْ، مَاحنْذْ أَذْ نمّثْ ذِي ڒخْڒَا-يَا؟ مَاغَارْ ثڭِّيذْ أَمُّو، ثسُّوفّْغذْ أَنغْ-د زِي مِيصْرَا؟ ");
INSERT INTO rifa_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","مَا وَارْ كِيذكْ نسِّيوڒْ مَارَّا أَوَاڒنْ-أَ ذِي مِيصْرَا، ننَّا: ’أجّْ أَنغْ أَذْ نخْذمْ إِ إِمِيصْرِييّنْ‘؟ خَارْ مَاڒَا ثُوغَا نقِّيمْ نخْذمْ إِ إِمِيصْرِييّنْ خْ مَاڒَا نمُّوثْ ذِي ڒخْڒَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","خنِّي إِنَّا مُوسَا إِ ڒْڭنْسْ: ”وَارْ تّڭّْوذمْ، بدّمْ، ثخْزَارمْ أَسنْجمْ ن سِيذِي إِ ذ أَومْ غَا يوْشْ أَسّْ-أَ، مِينْزِي إِمِيصْرِييّنْ نِّي ثتّْوَاڒَامْ أَسّْ-أَ،عمَّارْصْ أَذْ ثنْ ثْژَارمْ عَاذْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","سِيذِي أَذْ خَاومْ إِمّْنغْ ؤُشَا كنِّيوْ أَذْ ثْسغْذمْ وَاهَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","إِنَّا سِيذِي إِ مُوسَا: ”مَايمِّي غَارِي ثتّْڒَاغِيذْ؟ إِنِي إِ أَيْثْ ن إِسْرَائِيل حِيمَا أَذْ فسْينْ إِقِيضَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","سْڭعّذْ ثَاغَّارْشْثْ نّشْ، سْوِيژّضْ أَفُوسْ نّشْ خْ ڒبْحَارْ ؤُشَا فَارْقْ إِ-ث، حِيمَا أَذْ إِژْوَا أَيْثْ ن إِسْرَائِيل خْ ڒْبَارّْ ذِي ڒْوسْطْ ن ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","خْزَارْ، نشّْ أَذْ سّْقسْحغْ ؤُڒْ ن إِمِيصْرِييّنْ، مَاحنْذْ أَذْ ثنْ أَرذْفنْ ذِي ڒبْحَارْ ؤُ نشّْ أَذْ سّْعُودْجِيغْ إِخفْ إِنُو س فِيرْعُونْ ؤُ س مَارَّا ڒْعسْكَارْ نّسْ، إِكَارُّوثنْ نّسْ ذ إِمْنَاينْ نّسْ ن إِيْسَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","أَذْ سّْننْ إِمِيصْرِييّنْ بلِّي نشّْ ذ سِيذِي، خْمِي غَا تّْوَاسّْعُودْجِيغْ س فِيرْعُونْ، س إِكَارُّوثنْ نّسْ ذ إِمْنَاينْ نّسْ ن إِيْسَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","خنِّي إِمُّوطِّي لْمَالَاكْ ن أَربِّي نِّي يُويُورنْ زَّاثْ إِ ڒْعسْكَارْ ن إِسْرَائِيل ؤُشَا إِذْوڒْ غَارْ ضفَّارْ نْسنْ: أَقلِّيجْ ن ؤُسيْنُو إِمُّوطِّي زِي زَّاثْ إِ وُوذمْ نْسنْ ؤُشَا إِبدّْ غَارْ ضفَّارْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","يُوذفْ ؤُقلِّيجْ جَارْ ڒْعسْكَارْ ن إِمِيصْرِييّنْ ذ ڒْعسْكَارْ ن إِسْرَائِيل. ثُوغَا أَسيْنُو ذ ثَادْجسْثْ غَارْ ؤُغزْذِيسْ-أَ ؤُ إِسِّيغْ إِ ؤُغزْذِيسْ نّغْنِي س دْجِيڒثْ ؤُ وَارْ د-إِقَارّبْ إِجّنْ غَارْ ونّغْنِي دْجِيڒثْ ثكْمڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ؤُشَا إِسّْوِيژّضْ مُوسَا أَفُوسْ نّسْ خْ ڒبْحَارْ ؤُشَا إِعَارْنْ سِيذِي خنِّي ڒبْحَارْ غَارْ ؤُغزْذِيسْ س يِيجّْ ن ؤُسمِّيضْ ذ أَشَارْقِي إِجْهذْ، مَارَّا دْجِيڒثْ نِّي، ؤُشَا يَارَّا ڒبْحَارْ أَذْ إِجفّفْ. أَمُّو إِ تّْوَامّْسبْضَانْ وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ؤُيُورنْ أَيْثْ ن إِسْرَائِيل خْ مِينْ يُوژْغنْ ذِي ڒْوسْطْ ن ڒبْحَارْ ؤُشَا أَمَانْ ڭِّينْ أَمشْنَاوْ ڒْحِيضْ خْ يفُوسْ نْسنْ ذ ؤُزڒْمَاضْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","أَرذْفنْ ثنْ إِمِيصْرِييّنْ، رُوحنْ أَوَارْنِي أَسنْ ذِي ڒْوسْطْ ن ڒبْحَارْ س مَارَّا إِيْسَانْ ن فِيرْعُونْ ذ إِكَارُّوثنْ نّسْ ذ إِمْنَاينْ نّسْ ن يِييْسَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ڒَامِي ذ يفُّو ڒْحَاڒْ، إِمْسَارْ بلِّي سِيذِي إِصْوضْ غَارْ ڒْعسْكَارْ ن إِمِيصْرِييّنْ زڭْ ؤُقلِّيجْ ن ثْمسِّي ذ إِسيْنُوثنْ ؤُشَا إِسّْخَارْوضْ ڒْعسْكَارْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","إِجَّا ثِيجَارَّارِينْ ن إِكَارُّوثنْ نْسنْ أَذْ فسْخنْثْ، أَڒَامِي إِذْوڒْ إِوْعَارْ خَاسنْ أَذْ ؤُيُورنْ غَارْ زَّاثْ. ڒخْذنِّي نَّانْ إِمِيصْرِييّنْ، كُوڒْ إِجّنْ زَّايْسنْ إِ يِيخفْ نّسْ: ”إِتّْخصَّا أَيِي أَذْ أَروْڒغْ زِي زَّاثْ ن ثِيطَّاوِينْ ن إِسْرَائِيل، مِينْزِي سِيذِي إِمّْنغْ ذِي طّْوعْ نْسنْ ضِيدّْ إِ إِمِيصْرِييّنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","إِنَّا سِيذِي إِ مُوسَا: ”سْوِيژّضْ أَفُوسْ نّشْ خْ ڒبْحَارْ، حِيمَا أَذْ ذوْڒنْ وَامَانْ خْ إِمِيصْرِييّنْ، خْ إِكَارُّوثنْ نْسنْ ؤُ خْ إِمْنَاينْ نْسنْ ن إِيْسَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","خنِّي إِسّْوِيژّضْ مُوسَا أَفُوسْ نّسْ خْ ڒبْحَارْ ؤُ غَارْ ڒفْجَارْ ن صّْبحْ إِذْوڒْ ڒبْحَارْ غَارْ مَانِي ث ثُوغَا قْبڒْ ؤُشَا أَروْڒنْ إِمِيصْرِييّنْ نِيشَانْ ضِيدّْ نّسْ ؤُشَا إِغْضڒْ سِيذِي إِمِيصْرِييّنْ ذِي ڒْوسْطْ ن ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ذوْڒنْ-د وَامَانْ ؤُشَا تّْوَانضْڒنْ إِكَارُّوثنْ ذ إِمْنَاينْ ن إِيْسَانْ ن مَارَّا ڒْعسْكَارْ ن فِيرْعُونْ إِ ثُوغَا يُوذفْ أَوَارْنِي أَسنْ غَارْ ڒبْحَارْ. وَارْ زَّايْسنْ إِقِّيمْ ؤُڒَا ذ إِجّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","مَاشَا أَيْثْ ن إِسْرَائِيل ؤُيُورنْ خْ مِينْ يُوژْغنْ ذِي ڒْوسْطْ ن ڒبْحَارْ ؤُ أَمَانْ ثُوغَا ڭِّينْ أَمشْنَاوْ ڒْحِيضْ غَارْ يفُوسْ نْسنْ ذ ؤُزڒْمَاضْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","أَمُّو إِ إِسّنْجمْ سِيذِي إِسْرَائِيل ذڭْ وَاسّْ نِّي زڭْ ؤُفُوسْ ن إِمِيصْرِييّنْ ؤُشَا إِسْرَائِيل إِژْرَا إِمِيصْرِييّنْ إِ إِمُّوثنْ خْ ثْمَا ن ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","إِژْرَا إِسْرَائِيل أَفُوسْ إِمْغَارنْ إِ إِڭَّا سِيذِي ذڭْ إِمِيصْرِييّنْ ؤُشَا إِڭّْوذْ ڒْڭنْسْ زِي سِيذِي، ؤُشَا ؤُمْننْ نِيثْنِي ذِي سِيذِي ؤُ ذِي مُوسَا، أَمْسخَّارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ڒخْذنِّي إِزهّذْ مُوسَا جْمِيعْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل زْهِيذْ-أَ إِ سِيذِي، نَّانْ: ”أَذْ زهّْذغْ إِ سِيذِي، مِينْزِي نتَّا يُوعْڒَا ذِي ڒُوعْڒَا! أَيِيسْ ذ ونِّي خَاسْ ينْيِينْ إِنْضَارْ إِ-ثنْ ذِي ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","سِيذِي ذ جّهْذْ إِنُو ذ أَزهّذْ إِنُو. نتَّا إِذْوڒْ ذ أَسنْجمْ إِنُو. وَا ذ أَربِّي إِنُو، نشّْ أَذْ ث سّمْغَارغْ. نتَّا ذ أَربِّي ن بَابَا، نشّْ أَذْ ث سّْعُودْجغْ! ");
INSERT INTO rifa_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","سِيذِي ذ أَرْيَازْ ن ؤُمنْغِي، سِيذِي ذ إِسمْ نّسْ! ");
INSERT INTO rifa_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","إِكَارُّوثنْ ن فِيرْعُونْ ذ ڒْعسْكَارْ نّسْ إِنْضَارْ إِ-ثنْ ذِي ڒبْحَارْ ؤُ أَشوَّارْ ن إِنغْرَافنْ نّسْ ن ڒْعسْكَارْ غَارْقنْ ذِي ڒبْحَارْ ن ثلْڭَا. ");
INSERT INTO rifa_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","أَمَانْ إِهوْڒنْ ذْڒِينْ إِ-ثنْ. أَمشْنَاوْ أَژْرُو، هْوَانْ غَارْ ڒَادْجَاغْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","أَ سِيذِي، أَفُوسْ أَفُوسِي نّشْ إِتّْوَاعزّْ س جّهْذْ، أَفُوسْ أَفُوسِي نّشْ، أَ سِيذِي، أَقَا إِڒْبزْ ڒعْذُو. ");
INSERT INTO rifa_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","س ڒمْغَارثْ ن ؤُعُودْجِي نّشْ ثثحِّيذْ إِنِّي كِيكْ إِتّمْعَاڒَانْ. مَاڒَا ثسّكّذْ ڒْحَاذُوقْ ن وغْضَابْ نّشْ، أَذْ ثنْ يشّْ وَانِيثَا أَمشْنَاوْ إِغدْجْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","س ؤُسُوضِي ن ونْزَارنْ نّشْ عُورّْشنْ وَامَانْ، تّْوَاسّْبدّنْ ثْسدْجْيَا أَمْ وغْبَارْ، أَمَانْ إِهوْڒنْ جمْذنْ ذِي ڒْوسْطْ ن ڒبْحَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","إِنَّا ڒعْذُو: ’أَذْ ثنْ أَرذْفغْ، أَذْ ثنْ عْذُوغْ، أَذْ بْضِيغْ ڒْمُورْ، ڒعْمَارْ إِنُو أَذْ زَّايْسنْ إِجِّيونْ، أَذْ د-جبْذغْ سِّيفْ إِنُو، أَفُوسْ إِنُو أَذْ زَّايْسنْ إِكّسْ ڒْوَارْثْ نْسنْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ثْسُوضذْ س نّفْسْ نّشْ ؤُشَا إِذڒْ إِ-ثنْ ڒبْحَارْ. نِيثْنِي هْوَانْ-د أَمْ ڒخْفِيفْ ذڭْ وَامَانْ إِمْغَارنْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","أَ سِيذِي، مَانْ ونْ إِ إِدْجَانْ أَمْ شكْ جَارْ إِربِّيثنْ؟ وِي إِدْجَانْ أَمْ شكْ، ذ ونِّي إِتّْوَاسّْعُودْجنْ ذِي ثْقدَّاسْثْ، أَمْوقَّارْ ذڭْ إِزْڒَانْ ن ؤُصبّحْ، مَانْ ونْ إِتّڭّنْ ڒعْجَايبْ أَمْ شكْ؟ ");
INSERT INTO rifa_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ثسّْوِيژّْضذْ أَفُوسْ أَفُوسِي نّشْ، ثْسَارْضْ إِ-ثنْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","شكْ ثْڭوّْذذْ ڒْڭنْسْ-أَ س ثْمخْسِيوْثْ نّشْ إِشُووَّارنْ، أَقَا ثفْذِيذْ ث، س جّهْذْ نّشْ ثْنذْهذْ ثنْ غَارْ ثْزذِّيغْثْ إِقدّْسنْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ڒڭْنُوسْ سْڒِينْ خْ ؤُيَا ؤُشَا أَرْجِيجنْ. ثطّفْ ثڭّْوُوذِي ذڭْ إِمزْذَاغْ ن فِيلِيشِيثْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ڒخْذنِّي إِمقّْرَاننْ ن ثْقبَّاڒْ ن إِذُومْ تّْبهْثنْ، إِنِّي غَارْ ثدْجَا صُّولْطَا ذِي مُوآبَ تَّارْجِيجنْ، ؤُ مَارَّا إِمزْذَاغْ ن كنْعَانْ أَقَا فسْينْ! ");
INSERT INTO rifa_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ثوْضَا خَاسنْ ڒْعُورّثْ ذ ثِيڭّْوُوذِي. س ڒمْغَارثْ ن ؤُغِيڒْ نّشْ سغْذنْ أَمْ وژْرُو، أَڒَامِي إِژْوَا ڒْڭنْسْ نّشْ، أَ سِيذِي، أَڒَامِي إِژْوَا ڒْڭنْسْ-أَ إِ ثْكسْبذْ إِ يِيخفْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","شكْ أَذْ ثنْ ثْنذْهذْ ؤُشَا أَذْ ثنْ ثژُّوذْ خْ وذْرَارْ ن ڒْوَارْثْ نّشْ، أَمْشَانْ إِ ثڭِّيذْ ذ ثَازذِّيغْثْ نّشْ، أَ سِيذِي، زَّاوشْثْ إِقدّْسنْ إِ إِڭِّينْ إِفَاسّنْ نّشْ، أَ سِيذِي إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","سِيذِي أَذْ إِحْكمْ إِ ڒبْذَا قَاعْ! ");
INSERT INTO rifa_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","مِينْزِي أَيِيسْ ن فِيرْعُونْ يُوذفْ غَارْ ڒبْحَارْ س إِكَارُّوثنْ نّسْ ذ إِمْنَاينْ نّسْ ؤُشَا إِقْڒبْ خَاسنْ سِيذِي عَاوذْ أَمَانْ ن ڒبْحَارْ. مَاشَا أَيْثْ ن إِسْرَائِيل ژْوَانْ خْ ڒَاژَاغْ ذِي ڒْوسْطْ ن ڒبْحَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ؤُ مَارْيَامْ، ثَانَابِيثْ، ؤُتْشْمَاسْ ن هَارُونْ، ثكْسِي أَدْجُونْ ذڭْ ؤُفُوسْ نّسْ ؤُ مَارَّا ثِيمطَّا فّْغنْثْ أَوَارْنِي أَسْ س إِبنْذِيرنْ ذ شّْضِيحْ س نُّوبْثَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","خنِّي ثَارَّا-د خَاسنْ مَارْيَامْ سْنُّوبثْ نّسْ: ”غنّْجمْ إِ سِيذِي، مِينْزِي أَقَا نتَّا يُوعْڒَانْ أَطَّاسْ! إِنْضَارْ أَيِيسْ أَكْ-ذ ونِّي خَاسْ ينْيِينْ ذِي ڒبْحَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","خنِّي إِجَّا مُوسَا ڒْْڭنْسْ ن إِسْرَائِيل أَذْ إِفْسِي إِقِيضَانْ نْسنْ، إِنِّي إِدْجَانْ خْ ثْمَا ن ڒبْحَارْ ن ثلْڭَا، ؤُشَا رُوحنْ ذِي ڒخْڒَا ن شُورْ، ؤُيُورنْ ثْڒَاثَا ن وُوسَّانْ ذِي ڒخْڒَا بْڒَا أَذْ أَفنْ أَمَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ؤُشَا إِوْضنْ غَارْ مَارَا، مَاشَا وَارْ زمَّارنْ أَذْ سْونْ أَمَانْ ن مَارَا، مِينْزِي ثُوغَا أَثنْ ذ إِمرْزَاڭنْ. خْ ؤُيَا ڭِّينْ أَسْ إِ ومْشَانْ نِّي ’مَارَا‘. ");
INSERT INTO rifa_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","إِنّذْقمْ ڒْڭنْسْ خْ مُوسَا، إِنَّا: ”مِينْ غَا نْسُو؟“ ");
INSERT INTO rifa_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","نتَّا إِڒَاغَا إِ سِيذِي ؤُشَا سِيذِي إِمّڒْ أَسْ إِجّْ ن ؤُكشُّوضْ ؤُشَا إِنْضَارْ إِ-ث ذَاخڒْ ذڭْ وَامَانْ ؤُشَا ذوْڒنْ وَامَانْ ذ إِمِيژِيذنْ. ذِينْ إِ ذ أَسْ إِڭَّا إِ ڒْڭنْسْ إِشْثْ ن ثوْصيّثْ ذ إِشْثْ ن لْفَارِيضَا ؤُ ذِينِّي إِ-ثنْ إِقدْجبْ. ");
INSERT INTO rifa_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","إِنَّا: ”مَاڒَا ثسْڒِيذْ مْلِيحْ إِ وَاوَاڒْ ن سِيذِي، أَربِّي نّشْ، ثڭِّيذْ مِينْ إِدْجَانْ نِيشَانْ ذِي ثِيطَّاوِينْ نّسْ، أَذْ ثسْڒذْ إِ ڒُومَارَاثْ نّسْ، أَذْ ثحْضِيذْ مَارَّا ثِيوصَّا نّسْ، خنِّي نشّْ وَارْ ذ أَومْ-د سّكِّيغْ ڒهْڒَاشْ إِ د-سّكّغْ خْ مِيصْرَا، مِينْزِي نشّْ ذ سِيذِي، أَمسْڭنْفِي نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ڒخْذنِّي إِوْضنْ غَارْ إِلِيمْ، مَانِي ثُوغَا ثنْعَاشْ ن ڒْعُونْصَارَاثْ ن وَامَانْ، ذ سبْعِينْ ن ثْشجُّورَا ن ثِينِي ؤُشَا وْثِينْ إِقِيضَانْ نْسنْ ذِينِّي زَّاثْ إِ وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ؤُشَا فسْينْ إِقِيضَانْ نْسنْ، ؤُيُورنْ زِي إِلِيمْ، ؤُ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ثِيوضْ غَارْ ڒخْڒَا ن سِينْ إِ إِدْجَانْ جَارْ إِلِيمْ ذ سِينَا. ثُوغَا مَانْ أَيَا ذڭْ وَاسّْ خمّسْطَاشْ ن ؤُيُورْ وِيسّْ ثْنَاينْ أَوَارْنِي ڒَامِي د-فّْغنْ زِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ثنّذْقمْ زِي مُوسَا ذ هَارُونْ ذِي ڒخْڒَا. ");
INSERT INTO rifa_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","نَّانْ أَسنْ أَيْثْ ن إِسْرَائِيل: ”مْڒِي نمُّوثْ س ؤُفُوسْ ن سِيذِي ذِي ثمُّورْثْ ن مِيصْرَا ؤُمِي ثُوغَا نقِّيمْ غَارْ طّْبَاصِي ن ويْسُومْ، نشَّا أَغْرُومْ أَڒَامِي نجِّيونْ! مِينْزِي كنِّيوْ ثسُّوفّْغمْ أَنغْ-د غَارْ ڒخْڒَا-يَا مَاحنْذْ أَذْ ثنْغمْ مَارَّا أَڭْرَاوْ أَيَا س ڒَاژْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”خْزَارْ، أَذْ جّغْ أَغْرُومْ أَذْ خَاومْ د-إِوْضَا زڭْ ؤُجنَّا أَمْ ونْژَارْ. خنِّي أَذْ إِفّغْ ڒْڭنْسْ، أَذْ كْسِينْ مِينْ حْذَاجنْ إِ وَاسّْ ذڭْ وَاسّْ نِّي، حِيمَا أَذْ ثنْ قدْجْبغْ، مَا ڭُّورنْ ذِي ثْغُورِي ن شَّارِيعَا إِنُو، نِيغْ لَّا. ");
INSERT INTO rifa_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","أَذْ يِيڒِي ذڭْ وَاسّْ وِيسّْ ستَّا، أَذْ سّْوجْذنْ مِينْ د-إِوْينْ غَارْ ذَاخڒْ. مَانْ أَيَا أَذْ يِيڒِي ذ ثْنَاينْ ن ثْسقَّارْ خْ مِينْ غَا سّْمُوننْ كُوڒْ أَسّْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ڒخْذنِّي إِنَّا مُوسَا ذ هَارُونْ إِ مَارَّا أَيْثْ ن إِسْرَائِيل: ”غَارْ ؤُعشِّي أَذْ ثسّْنمْ بلِّي سِيذِي إِ كنِّيوْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، ");
INSERT INTO rifa_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ؤُ غَارْ صّْبحْ أَذْ ثْژَارمْ أَعُودْجِي ن سِيذِي، مِينْزِي أَقَا نتَّا إِسْڒَا أَنذْقمْ نْومْ خْ سِيذِي. مَا نشِّينْ، مِينْ نعْنَا، حِيمَا كنِّيوْ أَذْ خَانغْ ثنّْذقْممْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","إِنَّا مُوسَا: ”ڒَْامِي ذ أَومْ إِوْشَا سِيذِي أَيْسُومْ إِ مَاشَّا ذڭْ ؤُعشِّي ؤُ أَغْرُومْ ذِي ثْيَاوَانْثْ ذِي صّْبحْ، أَقَا إِسْڒَا سِيذِي أَنذْقمْ نْومْ إِ زِي خَاسْ ثتّْنذْقَاممْ. إِ نشِّينْ، مِينْ نعْنَا؟ كنِّيوْ وَارْ خَانغْ ثتّْنذْقَاممْ، مَاشَا خْ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","إِنَّا مُوسَا إِ هَارُونْ: ”إِنِي إِ ثْمسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل مَارَّا: ’رحّْڭمْ-د غَارْ زَّاثْ إِ وُوذمْ ن سِيذِي، مِينْزِي أَقَا إِسْڒَا إِ ؤُنذْقمْ نْومْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","أَمْ إِسِّيوڒْ هَارُونْ أَكْ-ذ ثْمسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل مَارَّا، ثُوغَا خزَّارنْ غَارْ ڒخْڒَا ؤُشَا خْزَارْ، أَعُودْجِي ن سِيذِي إِضْهَارْ-د ذڭْ ؤُسيْنُو. ");
INSERT INTO rifa_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","”نشّْ سْڒِيغْ إِ ؤُنذْقمْ ن أَيْثْ ن إِسْرَائِيل. سِيوڒْ أَكِيذْسنْ ؤُشَا إِنِي: جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ أَذْ ثشّمْ أَيْسُومْ، غَارْ صّْبحْ أَذْ ثجِّيوْنمْ س وغْرُومْ ؤُشَا أَذْ ثسّْنمْ بلِّي نشّْ ذ سِيذِي، أَربِّي نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","غَارْ ؤُعشِّي ؤُڒْينْثْ إِ-د إِجْضَاضْ قَّارنْ أَسْ ’ثْسَالْوَا‘ ؤُشَا ذْڒِينْثْ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُ غَارْ صّْبحْ ثُوغَا نّْذَا إِنّضْ-د إِ ڒْمَارْڭحْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ڒَامِي د-إِڭعّذْ نّْذَا، أَقَا ذَا، إِشْثْ ن ڒْحَاجّثْ ذ ثَازْذَاثْ أَمْ ثقْشُورْثْ، ذ ثَازْذَاثْ أَمْ نّْذَا إِڭَارْسنْ، ثتّْوَافْ خْ وُوذمْ ن ڒخْڒَا، خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ژْرِينْ ت أَيْثْ ن إِسْرَائِيل، نَّانْ إِجّنْ إِ ونّغْنِي: ”مَانَاوْيَا؟“، مِينْزِي وَارْ سِّيننْ مِينْ إِعْنَا. ڒخْذنِّي إِنَّا أَسنْ مُوسَا: ”وَا ذ أَغْرُومْ نِّي ذ أَومْ إِوْشَا سِيذِي، حِيمَا أَذْ ثشّمْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","وَا ذ أَوَاڒْ إِ ذ أَومْ يُومُورْ سِيذِي: ’أجّْ أَذْ زَّايسْ إِكْسِي كُوڒْ إِجّْ عْلَاحْسَابْ مِينْ إِحْذَاجْ، ڒقْيَاسْ ن إِجّْ ن ؤُعُومِيرْ، عْڒَاحَاڒْ ثْنَاينْ لِيثْرُو، إِ إِجّنْ بْنَاذمْ. كُوڒْ أَرْيَازْ أَذْ إِكْسِي عْلَاحْسَابْ ڒْقدّْ ن إِوْذَانْ إِ غَارسْ ذڭْ ؤُقِيضُونْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ؤُشَا أَمُّو إِ ڭِّينْ أَيْثْ ن إِسْرَائِيل. يْرُونْ زَّايسْ، إِجّنْ أَطَّاسْ، ونّغْنِي ذْرُوسْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","وزْننْ أَيَا س ڒقْيَاسْ ن ؤُعُومِيرْ. ونِّي يْرُونْ أَطَّاسْ وَارْ غَارسْ زّْيَاذَا ذ ونِّي يْرُونْ ذْرُوسْ، وَارْ ذ أَسْ إِتّْخصِّي عَاذْ. كُوڒْ إِجّْ إِيْرُو مَاشَّا نّسْ عْلَاحْسَابْ مِينْ إِحْذَاجْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","إِنَّا أَسنْ مُوسَا: ”ؤُڒَا ذ إِجّْ أَذْ زَّايسْ يجّْ أَڒْ صّْبحْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","مَاشَا نِيثْنِي وَارْ سْڒِينْ شَا إِ مُوسَا ؤُ شَا ن يرْيَازنْ خمّْڒنْ شَا زَّايسْ أَڒْ صّْبحْ. خنِّي ؤُذْفنْ ذَايسْ إِكشَّاونْ ؤُشَا إِبْذَا أَذْ إِڭّْ شُّومْ. ؤُشَا إِفُّوڭمْ خَاسنْ مُوسَا أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","كُوڒْ صّْبحْ يْرُونْ ث، كُوڒْ إِجّْ عْلَاحْسَابْ إِزمَّارْ أَذْ إِشّْ نتَّا، مِينْزِي مَاڒَا ثحْمَا ثْفُوشْثْ، ثُوغَا إِتّْفسِّي. ");
INSERT INTO rifa_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ذڭْ وَاسّْ وِيسّْ ستَّا يْرُونْ ثْنَاينْ ن ثْسقَّارْ ن وغْرُومْ، ڒقْيَاسْ ن ثْنَاينْ ن إِعُومِيرنْ إِ كُوڒْ أَزدْجِيفْ. ؤُشَا ؤُسِينْ-د مَارَّا ڒْحُوكَّامْ ن ثْمسْمُونْثْ ؤُشَا خبَّارنْ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","نتَّا إِنَّا أَسنْ: ”ذ مَانْ أَيَا مِينْ خفْ إِسِّيوڒْ سِيذِي: ’ثِيوشَّا ذ إِجّْ ن وَاسّْ ن أَرَّاحثْ، إِجّْ ن وَاسّْ ن سّبْثْ ذ أَمْقدَّاسْ إِ سِيذِي. سنْڭْومْ مِينْ ثخْسمْ أَذْ ثسّنْڭْومْ، سْننَّامْ مِينْ ثخْسمْ أَذْ ثسّنَّامْ ؤُشَا مَارَّا مِينْ غَا إِقِّيمنْ، خمّْڒمْ ث أَڒْ صّْبحْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","نِيثْنِي خمّْڒنْ ث أَڒْ صّْبحْ أَمْ مَامّشْ ثنْ يُومُورْ مُوسَا ؤُشَا وَارْ يَارْصُوضْ ؤُ وَارْ ذَايسْ ثُوغِي ثْكشَّا. ");
INSERT INTO rifa_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","خنِّي إِنَّا مُوسَا: ”شّمْ أَيَا أَسّْ-أَ، مِينْزِي أَسّْ-أَ ذ أَسّْ ن سّبْثْ ن سِيذِي. أَسّْ-أَ وَارْ ث ثتِّيفمْ ذڭْ إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ستَّا ن وُوسَّانْ أَذْ ثيْرُومْ، مَاشَا ذڭْ وَاسّْ وِيسّْ سبْعَا أَقَا ذ سّبْثْ، وَارْ إِتِّيڒِي وَالُو.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ذڭْ وَاسّْ وِيسّْ سبْعَا إِمْسَارْ بلِّي فّْغنْ شَا زِي ڒْڭنْسْ، مَاحنْذْ أَذْ يْرُونْ شَا، مَاشَا وَارْ ؤُفِينْ وَالُو. ");
INSERT INTO rifa_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","إِنَّا سِيذِي إِ مُوسَا: ”أَڒْ مڒْمِي ثُوڭِيمْ أَذْ ثحْضَامْ ڒُومُورَاثْ إِنُو ذ إِزرْفَانْ إِنُو؟ ");
INSERT INTO rifa_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","خْزَارمْ، مِينْزِي سِيذِي إِوْشَا أَومْ أَسّْ ن سّبْثْ، خْ ؤُيَا إِوْشَا أَومْ ذڭْ وَاسّْ وِيسّْ ستَّا أَغْرُومْ إِ ثْنَاينْ ن وُوسَّانْ. كُوڒْ إِجّْ زَّايْومْ أَذْ إِقِّيمْ ذڭْ ومْشَانْ نّسْ! ذڭْ وَاسّْ وِيسّْ سبْعَا وَارْ د-إِتّفِّيغْ ؤُڒَا ذ إِجّْ زڭْ ومْشَانْ نّسْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ؤُشَا يَاريّحْ ڒْڭنْسْ ذڭْ وَاسّْ ن سّبْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ثَادَّارْثْ ن إِسْرَائِيل ثْڒَاغَا أَسْ ’مَانَّا‘. ثُوغَا-ت ذ ثَاشمْڒَاڒْثْ أَمْ زَّارِيعثْ ن ڒْقصْبُورْ ؤُشَا أَڒذِّي نّسْ أَمشْنَاوْ ثِيفْضِيرِينْ ن ثَامّنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","خنِّي إِنَّا مُوسَا: ”دّڭَّا ذ أَوَاڒْ إِ زِي يُومُورْ سِيذِي: ’شُّورمْ زَّايسْ ڒقْيَاسْ ن يِيجّْ ن ؤُعُومِيرْ ؤُشَا خمّڒْ إِ-ث إِ مَارَّا جِّيڒَاثْ نْومْ إِ د غَا يَاسنْ، حِيمَا أَذْ ژَترنْ أَغْرُومْ مِينْ زِي كنِّيوْ سّشّغْ ذِي ڒخْڒَا، ؤُمِي كنِّيوْ سُّوفّْغغْ زِي ثمُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","إِنَّا مُوسَا إِ هَارُونْ: ”كْسِي إِجّْ ن ؤُزنْبِيڒْ ؤُشَاعمَّارْ إِ-ث س يِيجّْ ن ؤُعُومِيرْ ن ’مَانَّا‘ ؤُشَا أڭّْ إِ-ث زَّاثْ إِ وُوذمْ ن سِيذِي، حِيمَا أَذْ إِتّْوَاخمّڒ إِ مَارَّا جِّيڒَاثْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ؤُشَا إِڭَّا إِ-ت هَارُونْ زَّاثْ إِ شّْهَاذثْ، حِيمَا أَذْ ثتّْوَاخمّڒْ أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","أَمُّو إِ شِّينْ أَيْثْ ن إِسْرَائِيل ’مَانَّا‘ أَربْعِينْ ن إِسڭّْوُوسَا، أَڒَامِي إِوْضنْ غَارْ ثمُّورْثْ مَانِي غَا رَاحنْ أَذْ زذْغنْ. شِّينْ مَانَّا أَڒَامِي إِوْضنْ غَارْ ويْمِيرْ ن ثمُّورْثْ ن كنْعَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","إِجّْ ن ؤُعُومِيرْ ذعشْرَا ذِي ثسْغَارْثْ ن إِجّْ ن إِفَا. ");
INSERT INTO rifa_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ؤُشَا فسْينْ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ، ؤُيُورنْ زِي ڒخْڒَا ن سِينْ، أَمْ مَامّشْ ذ أَسنْ يُومُورْ سِيذِي ؤُشَا وْثِينْ إِقِيضَانْ نْسنْ ذِي رَافِيذِيمْ. وَارْ ذِينْ ثُوغِي أَمَانْ، حِيمَا أَذْ إِسُّو ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","خنِّي إِمْشُوبّشْ ڒْڭنْسْ أَكْ-ذ مُوسَا، نِيثْنِي نَّانْ: ”أوْشْ أَنغْ أَمَانْ، حِيمَا أَذْ نْسُو!“ مُوسَا إِنَّا أَسنْ: ”مَايمِّي ثتّخْسمْ أَذْ كِيذِي ثمْشُوبُّوشمْ؟ مَايمِّي ثتّْقدْجَابمْ سِيذِي؟“ ");
INSERT INTO rifa_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ثُوغَا ڒْڭنْسْ إِفُّوذْ أَطَّاسْ غَارْ وَامَانْ ؤُشَا نّْذقْمنْ زِي مُوسَا، نَّانْ: ”مَاغَارْ ذ أَنغْ ثسّْڭعّْذذْ زِي مِيصْرَا؟ مَا حِيمَا أَذْ أَيِي ثْهلّْكذْ س ؤُفَاذِي ؤُڒَا ذ ثَارْوَا إِنُو ذ ڒبْهَايمْ إِنُو؟“ ");
INSERT INTO rifa_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ڒخْذنِّي إِسْغُويْ مُوسَا غَارْ سِيذِي، إِنَّا: ”مِينْ غَا ڭّغْ أَكْ-ذ ڒْڭنْسْ-أَ؟ مْغِيرْ شْوَايْثْ ؤُشَا أَذْ أَيِي أَرجْمنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","إِنَّا سِيذِي إِ مُوسَا: ”أكّْ زَّاثْ إِ ڒْڭنْسْ ؤُشَا كْسِي أَكِيذكْ شَا زڭْ إِمْغَارنْ ن إِسْرَائِيل ؤُشَا كْسِي عَاوذْ ذڭْ ؤُفُوسْ نّشْ ثَاغَّارْشْثْ نِّي زِي ثوْثِيذْ إِغْزَارْ ؤُشَا رُوحْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","خْزَارْ، نشّْ أَذْ بدّغْ ذِينْ زَّاثكْ خْ ثصْضَارْثْ غَارْ حُورِيبْ، أَذْ ثوْثذْ ثَاصْضَارْثْ، أَذْ زَّايسْ د-فّْغنْ وَامَانْ ؤُشَا أَذْ إِسُّو ڒْڭنْسْ.“ إِڭَّا مُوسَا أَمنِّي زَّاثْ إِ ثِيطَّاوِينْ ن إِمْغَارنْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ؤُشَا إِڒَاغَا إِسمْ ن ومْشَانْ نِّي مَاسَّا ذ مَارِيبَا، مِينْزِي أَيْثْ ن إِسْرَائِيل مّْشُوبّْشنْ ذِينْ ؤُ مِينْزِي نِيثْنِي قدْجْبنْ سِيذِي، نَّانْ: ”مَا سِيذِي أَقَا-ث ڒخُّو ذِي ڒْوسْطْ نّغْ نِيغْ لَّا؟“ ");
INSERT INTO rifa_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","خنِّي يُوسَا-د عَامَالِيقْ ؤُشَا إِمّْنغْ أَكْ-ذ إِسْرَائِيل ذِي رَافِيذِيمْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","إِنَّا مُوسَا إِ يَاشُووَا: ”أجّْ أَنغْ أَذْ نِيخْضَارْ إِرْيَازنْ ؤُشَا أَذْ نفّغْ، مَاحنْذْ أَذْ نمّْنغْ أَكْ-ذ عَامَالِيقْ. ثِيوشَّا أَذْ بدّغْ سنّجْ خْ ثْقِيشَّاثْ ن ثوْرِيرْثْ ؤُشَا ثَاغَّارْشْثْ ن أَربِّي أَذْ ثِيڒِي ذڭْ ؤُفُوسْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","إِڭَّا يَاشُووَا أَمْ مَامّشْ ذ أَسْ إِنَّا مُوسَا، إِمّْنغْ أَكْ-ذ عَامَالِيقْ، مَاشَا مُوسَا ذ هَارُونْ ذ حُورْ ؤُڒْينْ غَارْ ثْقِيشَّاثْ ن ثوْرِيرْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ؤُشَا إِمْسَارْ ڒَامِي إِسّْڭعّذْ مُوسَا أَفُوسْ نّسْ، ڒخْذنِّي ثُوغَا إِسْرَائِيل ثْغدْجبْ، مَاشَا خْمِي إِتّجَّا أَفُوسْ نّسْ أَذْ إِهْوَا، ڒخْذنِّيغدْجْبنْ أَيْثْ ن عَامَالِيقْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","إِفَاسّنْ ن مُوسَا ذوْڒنْ دّقْڒنْ. خنِّي كْسِينْ إِجّْ ن وژْرُو ؤُشَا ڭِّينْ ث سَاذُو مُوسَا ؤُشَا إِقِّيمْ خَاسْ ؤُشَا هَارُونْ ذ حُورْ سنّْذنْ إِفَاسّنْ نّسْ، إِجّْ زڭْ ؤُغزْذِيسْ-أَ، ونّغْنِي زڭْ ؤُغزْذِيسْ نّغْنِي. أَمُّو إِ إِقِّيمنْ إِفَاسّنْ نّسْ ڭعّْذنْ أَڒَامِي ثغْڒِي ثْفُوشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ؤُشَا إِغْڒبْ يَاشُووَا خْ عَامَالِيقْ ذ ڒْڭنْسْ نّسْ س ڒقْضعْ ن سِّيفْ. ");
INSERT INTO rifa_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”أَرِي أَيَا ذڭْ إِجّْ ن وذْلِيسْ إِتّْوَانّْضنْ إِ ڒِيذَارثْ ذَايسْ ؤُشَا أڭّْ إِ-ث ذڭْ إِمجَّانْ ن يَاشُووَا، بلِّي أَقَا نشّْ أَذْ مْحِيغْ قَاعْ ڒِيذَارثْ ذِي عَامَالِيقْ سَاذُو ؤُجنَّا.“ ");
INSERT INTO rifa_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","إِبْنَا مُوسَا إِجّْ ن ؤُعَالْطَارْ ؤُشَا إِڒَاغَا أَسْ س يِيسمْ: ”سِيذِي ذ ثَاعدْجَانْثْ إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ؤُشَا إِنَّا: ”أَفُوسْ ثُوغَا خْ ڒْعَارْشْ ن سِيذِي. سِيذِي أَذْ يڭّْ ڭَارَّا خْ عَامَالِيقْ زِي جِّيڒْ أَڒْ جِّيڒْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","إِسْڒَا يِيثْرُونْ، أَكهَّانْ ن مِيذْيَانْ، أَضڭّْوَاڒْ ن مُوسَا، مَارَّا مِينْ إِڭَّا أَربِّي أَكْ-ذ مُوسَا ؤُ أَكْ-ذ ڒْڭنْسْ نّسْ إِسْرَائِيل، أَقَا إِسُّوفّغْ-د سِيذِي إِسْرَائِيل زِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","إِطّفْ يِيثْرُونْ، أَضڭّْوَاڒْ ن مُوسَا، صَافُّورَا، ثَامْغَارْثْ ن مُوسَا، أَوَارْنِي ڒَامِي ذ أَسْ إِوْشَا ثِيرْزِيفِينْ نّسْ ن ثسْڒِيثْ، ");
INSERT INTO rifa_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ؤُڒَا ذ ثْنَاينْ ن إِحنْجِيرنْ نّسْ، إِجّنْ قَّارنْ أَسْ جَارْشُومْ، مِينْزِي ثُوغَا إِنَّا: ”ثُوغَا أَيِي ذ أَبَارَّانِي ذِي ثمُّورْثْ ذ ثَابَارَّانشْثْ!“، ");
INSERT INTO rifa_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ؤُ ونّغْنِي قَّارنْ أَسْ أَلِيعَازِيرْ، مِينْزِي ثُوغَا إِنَّا: ”أَربِّي ن بَابَا إِعَاونْ أَيِي ؤُشَا إِفكّْ أَيِي زِي سِّيفْ ن فِيرْعُونْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","يِيثْرُونْ أَضڭّْوَاڒْ ن مُوسَا، أَكْ-ذ إِحنْجِيرنْ نّسْ ذ ثْمطُّوثْ نّسْ، إِوْضنْ غَارْ مُوسَا ذِي ڒخْڒَا، غَارْ مَانِي إِوْثَا إِقِيضَانْ، غَارْ وذْرَارْ ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ؤُشَا نتَّا إِجَّا أَذْ إِنِينْ إِ مُوسَا: ”نشّْ، أَضڭّْوَاڒْ نّشْ يِيثْرُونْ، ؤُسِيغْ-د غَاركْ س ثمْغَارْثْ نّشْ ذ ثْنَاينْ ن إِحنْجِيرنْ نّسْ أَكِيذسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","خنِّي إِفّغْ مُوسَا أَذْ إِڒْقَا أَضڭّْوَاڒْ نّسْ، إِبنْذقْ ؤُشَا إِسُّوذمْ إِ-ث. إِجّنْ إِسّقْسَا ونّغْنِي خْ ؤُمدُّورْ نّسْ ؤُشَا ؤُذْفنْ غَارْ ؤُقِيضُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","مُوسَا إِحَاجَا إِ ؤُضڭّْوَاڒْ نّسْ مَارَّا مِينْ إِڭَّا سِيذِي أَكْ-ذ فِيرْعُونْ ؤُ أَكْ-ذ إِمِيصْرِييّنْ ذِي طّْوعْ ن إِسْرَائِيل ؤُ خْ مَارَّا ثَامَارَا نِّي خَاسنْ إِكِّينْ ذڭْ وبْرِيذْ ذ مَامّشْ ثنْ إِفكّْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","إِفَارْحْ يِيثْرُونْ زِي مَارَّا ڒْخِيرْ نِّي إِڭَّا سِيذِي إِ إِسْرَائِيل، ؤُمِي ث إِفكّْ زڭْ ؤُفُوسْ ن إِمِيصْرِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","إِنَّا يِيثْرُونْ: ”أَذْ إِتّْوَابَاركْ سِيذِي ذ ونِّي كنِّيوْ إِفكّنْ زڭْ ؤُفُوسْ ن إِمِيصْرِييّنْ ؤُ زڭْ ؤُفُوسْ ن فِيرْعُونْ، ذ ونِّي إِفكّنْ ڒْڭنْسْ زڭْ ؤُفُوسْ ن إِمِيصْرِييّنْ! ");
INSERT INTO rifa_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ڒخُّو سّْنغْ بلِّي سِيذِي إِمْغَارْ أَطَّاسْ خْ مَارَّا إِربِّيثنْ، أَقَا ذِي ثْمسْڒَاشْثْ نِّي ذسَّارنْ خَاسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","خنِّي إِكْسِي يِيثْرُونْ، أَضڭّْوَاڒْ ن مُوسَا، ثَاغَارْصْثْ ن وشْمَاضْ ذ ثِيغَارْصَا إِ أَربِّي ؤُشَا يُوسَا-د هَارُونْ جْمِيعْ أَكْ-ذ مَارَّا إِمْغَارنْ ن أَيْثْ ن إِسْرَائِيل، مَاحنْذْ أَذْ يشّْ أَغْرُومْ جْمِيعْ أَكْ-ذ ؤُضڭّْوَاڒْ ن مُوسَا زَّاثْ إِ وُوذمْ ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ثِيوشَّا نّسْ ثُوغَا مُوسَا إِتّْغِيمَا خْ ڒْكُورْسِي، مَاحنْذْ أَذْ إِحْكمْ ڒْڭنْسْ. ثُوغَا ڒْڭنْسْ إِبدّْ زَّاثْ إِ مُوسَا زِي صّْبحْ زِيشْ أَڒْ دْجِيڒثْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","إِژْرَا ؤُضڭّْوَاڒْ ن مُوسَا مَارَّا مِينْ ثُوغَا إِتّڭّْ مُوسَا إِ ڒْڭنْسْ، إِنَّا: ”مَانَاوَايَا إِ ثڭِّيذْ شكْ إِ ڒْڭنْسْ؟ مَايمِّي ثتّْغِيمِيذْ شكْ وحّْذكْ ؤُ مَارَّا ڒْڭنْسْ إِبدّْ زَّاثكْ زِي ضّْبحْ زِيشْ أَڒْ دْجِيڒثْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","يَارَّا-د مُوسَا خْ ؤُضڭّْوَاڒْ نّسْ: ”مِينْزِي ڒْڭنْسْ إِتَّاسْ-د غَارِي حِيمَا أَذْ إِتَّارْ شّْوَارْ ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","خْ مِينِّي غَارْسنْ ثتِّيڒِي شَا ن ثْمسْڒَاشْثْ، تَّاسنْ-د غَارِي س مَانْ أَيَا ؤُشَا نشّْ أَذْ شَارّْعغْ جَارْ إِجّْ ذ ونّغْنِي، سّشَانغْ أَسنْ ثِيوصَّا ذ إِزرْفَانْ ن أَربِّي.“ ");
INSERT INTO rifa_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ڒخْذنِّي إِنَّا أَسْ ؤُضڭّْوَاڒْ ن مُوسَا: ”مِينْ ثڭِّيذْ وَارْ إِدْجِي شَا مْلِيحْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","أَمُّو إِ غَا ثَاحْڒذْ أَطَّاسْ، شكْ ذ ڒْڭنْسْ-أَ إِ كِيكْ إِدْجَانْ، مِينْزِي مَانْ أَيَا إِذْقڒْ خَاكْ أَطَّاسْ، وَارْ ذ أَسْ ثْزمَّارذْ أَذْ ث ثڭّذْ وحّْذكْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","سڒْ ڒخُّو إِ وَاوَاڒْ إِنُو، نشّْ أَذْ شكْ نصْحغْ ؤُشَا أَربِّي أَذْ كِيكْ يِيڒِي. إِڒِي شكْ ذ أَوصَّايْ خْ ڒْڭنْسْ زَّاثْ إِ أَربِّي ؤُشَا قدّمْ دّْعَاوِي زَّاثْ إِ أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","سْشنْ أَسنْ ثِيوصَّا ذ إِزرْفَانْ ؤُشَا سْشنْ أَسنْ أَبْرِيذْ إِ ثنْ إِتّْخصَّانْ أَذْ ؤُيُورنْ ؤُ ڒْخذْمثْ إِ ذ أَسنْ إِتّْخصَّانْ أَذْ ت ڭّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","عَاوذْ خْزَارْ شكْ، أَذْ ثَارْزُوذْ جَارْ مَارَّا ڒْڭنْسْ خْ إِرْيَازنْ إِزعَّامنْ، إِنِّي إِتّڭّْوذنْ أَربِّي، إِرْيَازنْ إِصْذِيقنْ، إِنِّي إِشَارّْهنْ ثَارزُّوثْ خْ أَرْبحْ. أڭّْ إِ-ثنْ ذ إِمقّْرَاننْ خْ وَاڒفْ، ذ إِمقّْرَاننْ خْ مْيَا، ذ إِمقّْرَاننْ خْ خمْسِينْ ذ إِمقّْرَاننْ خْعشْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","أجّْ إِ-ثنْ أَذْ شَارّْعنْ جَارْ ڒْڭنْسْ ڒبْذَا. أجّْ إِ-ثنْ أَذْ قدّْمنْ مَارَّا دّْعَاوِي إِوْعَارنْ زَّاثكْ، مَاشَا مَارَّا دّْعَاوِي ثِيمژْيَانِينْ أَذْ خَاسنْثْ شَارّْعنْ س يِيخفْ نْسنْ. أڭّْ إِ-ث ثفْسُوسْ خْ يِيخفْ نّشْ ؤُشَا أجّْ إِ-ثنْ أَذْ ت أَرْبُونْ أَكِيذكْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","مَاڒَا ثڭِّيذْ أَيَا، ؤُ أَربِّي إِ شكْ يُومُورنْ، ثْزمَّارذْ أَذْ ثقِّيمذْ ثْبدّذْ ؤُشَا مَارَّا ڒْڭنْسْ أَيَا أَذْ يَاوضْ عَاوذْ ذِي ڒهْنَا غَارْ ومْشَانْ إِ ذ أَسنْ إِتّْوَاڭّْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","إِسْڒَا مُوسَا غَارْ وَاوَاڒْ ن ؤُضڭّْوَاڒْ نّسْ، إِڭَّا مَارَّا مِينْ ذ أَسْ إِنَّا. ");
INSERT INTO rifa_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","إِخْضَارْ مُوسَا إِرْيَازنْ إِزعَّامنْ زِي مَارَّا إِسْرَائِيل ؤُشَا إِڭَّا إِ-ثنْ ذ إِزدْجِيفنْ خْ ڒْڭنْسْ: إِمقّْرَاننْ خْ وَاڒفْ، إِمقّْرَاننْ خْ مْيَا، إِمقّْرَاننْ خْ خمْسِينْ ذ إِمقّْرَاننْ خْعشْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ؤُشَا نِيثْنِي ثُوغَا تّْشَارّْعنْ ڒْڭنْسْ ڒبْذَا ؤُشَا دّْعَاوِي إِوْعَارنْ قذْمنْ ثنْثْ غَارْ مُوسَا، مَاشَا مَارَّا دّْعَاوِي ثِيمژْيَانِينْ شَارّْعنْ ثنْثْ س يِيخفْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","إِقبّضْ مُوسَا أَضڭّْوَاڒْ نّسْ ؤُشَا إِعْقبْ نتَّا غَارْ ثمُّورْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ذڭْ ؤُيُورْ وِيسّْ ثْڒَاثَا أَوَارْنِي إِ وُوفُّوغْ ن أَيْثْ ن إِسْرَائِيل زِي ثمُّورْثْ ن مِيصْرَا، ذڭْ وَاسّْ نِّي نِّيثْ، إِوْضنْ-د غَارْ ڒخْڒَا ن سِينَا. ");
INSERT INTO rifa_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","أَقَا فسْينْ إِقِيضَانْ نْسنْ، ؤُيُورنْ زِي رَافِيذِيمْ ؤُشَا إِوْضنْ غَارْ ڒخْڒَا ن سِينَا ؤُشَا وْثِينْ إِقِيضَانْ نْسنْ ذِي ڒخْڒَا. إِوْثَا إِسْرَائِيل إِقِيضَانْ نّسْ قِيبَاتْشْ إِ وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","يُوڒِي مُوسَا غَارْ أَربِّي ؤُشَا إِڒَاغَا أَسْ-د سِيذِي زڭْ وذْرَارْ، إِنَّا أَسْ: ”أَمُّو إِ غَا ثسِّيوْڒذْ أَكْ-ذ ثَادَّارْثْ ن يَاعْقُوبْ ؤُ أَمُّو إِ غَا ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل: ");
INSERT INTO rifa_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","’كنِّيوْ ثژْرِيمْ مِينْ ڭِّيغْ أَكْ-ذ إِمِيصْرِييّنْ ؤُ مَامّشْ كنِّيوْ كْسِيغْ خْ وَافْرِيونْ ن ؤُڭِيذرْ ؤُشَا إِوْيغْ-د كنِّيوْ غَارِي.    ");
INSERT INTO rifa_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","خنِّي ڒخُّو، مَاڒَا ثسْڒِيمْ مْلِيحْ غَارْ وَاوَاڒْ إِنُو ؤُ أَذْ ثحْضَامْ ڒْعَاهْذْ إِنُو، أَذْ غَارِي ثِيڒِيمْ كنِّيوْ ثِيغْڒَامْ خْ مَارَّا ڒڭْنُوسْ، مِينْزِي مَارَّا ثَامُّورْثْ أَقَا-ت إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","كنِّيوْ أَذْ أَيِي ثِيڒِيمْ ذ إِشْثْ ن ثْڭلْذِيثْ ن إِكهَّاننْ ذ إِجّْ ن ڒْڭنْسْ أَمْقدَّاسْ.‘ إِنَا ذ أَوَاڒنْ نِّي ذ أَشْ إِتّْخصَّانْ أَذْ ثنْ ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل.“ ");
INSERT INTO rifa_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","إِهْوَا-د مُوسَا ؤُشَا إِڒَاغَا-د خْ إِمْغَارنْ ن ڒْڭنْسْ ؤُشَا إِبَارّحْ أَسنْ مَارَّا أَوَاڒنْ-أَ إِ ذ أَسْ يُومُورْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ؤُشَا يَارَّا-د مَارَّا ڒْڭنْسْ، نَّانْ: ”مَارَّا مِينْ إِسِّيوڒْ سِيذِي، أَذْ ث نڭّْ!“ ؤُشَا إِسِّيوضْ مُوسَا أَوَاڒنْ ن ڒْڭنْسْ عَاوذْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","إِنَّا سِيذِي إِ مُوسَا: ”خْزَارْ، نشّْ أَذْ غَاركْ د-أَسغْ ذڭْ إِجّْ ن ؤُسيْنُو ذ أَبَارْشَانْ، حِيمَا أَذْ إِسڒْ ڒْڭنْسْ خْمِي نشّْ كِيكْ غَا سِّيوْڒغْ ؤُشَا عَاوذْ أَذْ زَّايكْ أَمْننْ إِ ڒبْذَا.“ مِينْزِي مُوسَا إِخبَّارْ أَوَاڒنْ ن سِيذِي إِ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","سِيذِي إِنَّا إِ مُوسَا: ”رُوحْ غَارْ ڒْڭنْسْ ؤُشَا سْقدّسْ إِ-ثنْ أَسّْ-أَ ذ ثِيوشَّا، أجّْ إِ-ثنْ أَذْ سِّيرْذنْ أَرُّوضْ نْسنْ ");
INSERT INTO rifa_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ؤُشَا أَذْ إِڒِينْ وجْذنْ إِ وَاسّْ وِيسّْ ثْڒَاثَا، مِينْزِي ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا أَذْ د-إِهْوَا سِيذِي غَارْ وذْرَارْ ن سِينَا زَّاثْ إِ ثِيطَّاوِينْ ن مَارَّا ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","أڭّْ إِيْمِيرنْ إِ ڒْڭنْسْ ذڭْ ونّضْ ن وذْرَارْ، إِنِي: ’غَارْومْ، وَارْ ثِيڒْيمْ غَارْ وذْرَارْ نِيغْ أَذْ ثْحَاذَامْ طَّارْفْ نّسْ. مَانْ ونْ إِ غَا إِحَاذَانْ أَذْرَارْ، أَذْ إِتّْوَانغْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","وَارْ ث إِتّْحِيذِي حذْ س ؤُفُوسْ، مِينْزِي خنِّي أَذْ إِتّْوَارْجمْ نِيغْ أَذْ إِتّْوَاوّثْ نِيشَانْ س فْڒِيثْشَاثْ مِينْ مَا إِعْنَا، ڒبْهِيمثْ نِيغْ ذ بْنَاذمْ، وَارْ إِتّْغِيمِي إِدَّارْ. مَاڒَا أَذْ ذِينْ يِيڒِي إِجّْ ن ؤُسُوضِي ذڭْ ؤُيِيشّْ ن ؤُسْڒِيوْڒوْ ذ أَزِيرَارْ، زمَّارنْ نِيثْنِي أَذْ أَڒْينْ أَذْرَارْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","خنِّي إِهْوَا-د مُوسَا زڭْ وذْرَارْ غَارْ ڒْڭنْسْ، إِسّْقدّسْ ڒْڭنْسْ ؤُشَا سِّيرْذنْ أَرُّوضْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","إِنَّا إِ ڒْڭنْسْ: ”إِڒِيمْ تّْوجْذمْ إِ وَاسّْ وِيسّْ ثْڒَاثَا، وَارْ د-تّْقَارَّابمْ غَارْ ثمْغَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ذِي صّْبحْ ن وَاسّْ وِيسّْ ثْڒَاثَا ؤُسِينْ-د وَاجَّاجنْ ذ وَاسَّامنْ. أَقَا يَارْسَا إِجّْ ن ؤُسيْنُو إِدّقْڒنْ خْ وذْرَارْ ؤُ ڒْحسّْ ن ؤُسُوضِي ذڭْ ؤُيِيشّْ ن إِشَارِّي إِذْوڒْ إِجْهذْ أَطَّاسْ. مَارَّا ڒْڭنْسْ ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ يَارْجِيجْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","مُوسَا إِنْذهْ ڒْڭنْسْ زِي ڒْمَارْڭحْ ن ڒْعسْكَارْ، مَاحنْذْ أَذْ إِڒْقَا أَربِّي ؤُشَا بدّنْ نِيثْنِي سْوَادَّايْ إِ وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","مَارَّا أَذْرَارْ ن سِينَا إِدّخّنْ، مِينْزِي سِيذِي ثُوغَا إِهْوَا-د خَاسْ ذِي ثْمسِّي. دّخَّانْ نّسْ يُوڒِي-د أَمْ دّخَّانْ ن ؤُفَارَّانْ ؤُشَا مَارَّا أَذْرَارْ إِنْهزّْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","أَمْ إِذْوڒْ ؤُسُوضِي ذڭْ ؤُيِيشّْ ن إِشَارِّي إِجْهذْ أَطَّاسْ، إِسِّيوڒْ مُوسَا ؤُشَا يَارَّا-د خَاسْ أَربِّي س يِيجّْ ن ڒْحسّْ إِجْهذْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ؤُشَا إِهْوَا-د سِيذِي خْ وذْرَارْ ن سِينَا، خْ ثْقِيشّثْ ن وذْرَارْ، ؤُشَا إِڒَاغَا سِيذِي إِ مُوسَا غَارْ ثْقِيشّثْ ن وذْرَارْ. خنِّي إِڭعّذْ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","إِنَّا سِيذِي إِ مُوسَا: ”هْوَا-د، عْڒمْ إِ ڒْڭنْسْ، مَاحنْذْ وَارْ تّْشُوقِينْ ذِي سِيذِي، مَاحنْذْ أَذْ ث ژَترنْ ؤُشَا خنِّي بَالَاكْ أَذْ تّْوَاهلّْكنْ أَطَّاسْ زَّايْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","أجّْ عَاوذْ إِكهَّاننْ، إِنِّي إِ د غَا إِقَارّْبنْ غَارْ سِيذِي، أَذْ سّْقدّْسنْ إِخفْ نْسنْ، حِيمَا سِيذِي وَارْ خَاسنْ إِسعَّارْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","إِنَّا مُوسَا إِ سِيذِي: ”ڒْْڭنْسْ وَارْ إِزمَّارْ أَذْ إِڭعّذْ أَذْرَارْ ن سِينَا، مِينْزِي شكْ ثْعڒْمذْ أَنغْ ثنِّيذْ: ’أڭّْ إِيْمِيرنْ خْ وذْرَارْ ؤُشَا سْقدّسْ إِ-ث.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","إِنَّا أَسْ سِيذِي: ”رُوحْ، هْوَا! أَذْ ثْڭعّْذذْ شكْ ذ هَارُونْ أَكِيذكْ، مَاشَا إِكهَّاننْ ذ ڒْڭنْسْ وَارْ زمَّارنْ أَذْ شُوقنْ، حِيمَا أَذْ ڭعّْذنْ غَارْ سِيذِي، حِيمَا نتَّا وَارْ خَاسنْ إِسعَّارْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ڒخْذنِّي إِهْوَا-د مُوسَا غَارْ ڒْڭنْسْ ؤُشَا إِنَّا أَسنْ مَارَّا أَيَا. ");
INSERT INTO rifa_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","إِسِّيوڒْ أَربِّي مَارَّا أَوَاڒنْ-أَ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","”نشّْ ذ سِيذِي، أَربِّي نّشْ، ونِّي شكْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، زِي ثَادَّارْثْ ن ثسْمُوغِي. ");
INSERT INTO rifa_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","وَارْ غَاركْ تِّيڒِينْ إِربِّيثنْ نّغْنِي زَّاثْ إِ وُوذمْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","وَارْ تّڭّْ إِ يِيخفْ نّشْ ڒخْيَاڒْ إِنقْشنْ نِيغْ شَا ن ڒْحَاجّثْ ثَارْوسْ ذِي مِينْ إِدْجَانْ سنّجْ ذڭْ ؤُجنَّا نِيغْ ذِي شَا ذَا سْوَادَّايْ ذِي ثمُّورْثْ نِيغْ ذِي شَا ذڭْ وَامَانْ إِ إِدْجَانْ سَاذُو ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","وَارْ ذ أَسنْ تّْبنْذِيقْ ؤُڒَا أَذْ خَاسنْ ثْسخَّارذْ، مِينْزِي نشّْ، سِيذِي، أَربِّي نّشْ، ذ إِجّْ ن أَربِّي إِتَّاسْمنْ، ونِّي د-يَارزْفنْ ڒْمُوعْصِييّثْ ن إِبَابَاثنْ ذِي ثَارْوَا أَڒْ جِّيڒْ وِيسّْ ثْڒَاثَا ذ وِيسّْ أَربْعَا ن يِينِّي ذ أَيِي إِشَارّْهنْ، ");
INSERT INTO rifa_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ذ ونِّي إِسّْشَاننْ ثَامخْسِيوْثْ نّسْ إِشوَّارنْ إِ ڒُوڒُوفْ ن يِينِّي ذ أَيِي إِتّخْسنْ ؤُ حطَّانْ ڒُومُورَاثْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","وَارْ نطّقْ س يِيسمْ ن سِيذِي، أَربِّي نّشْ، ذِي ڒْبَاطڒْ، مِينْزِي وَارْ إِتّْبَارِّي سِيذِي إِ ونِّي إِ غَا إِنطْقنْ س يِيسمْ نّسْ ذِي ڒْبَاطڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","إِذَارْ أَسّْ ن سّبْثْ، حِيمَا أَذْ ث ثسّْقدّْسذْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ستَّا ن وُوسَّانْ إِ غَا ثْخذْمذْ، أَذْ ثڭّذْ مَارَّا ڒْخذْمثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","أَسّْ وِيسّْ سبْعَا ذ وَاسّْ ن سّبْثْ ن سِيذِي، أَربِّي نّشْ. وَارْ ذَايسْ تّڭّْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ، شكْ لَّا، ؤُڒَا ذ مِّيشْ لَّا، ذ يدْجِيشْ لَّا، ذ إِسْمغْ نّشْ لَّا، ذ ثَايَّا نّشْ لَّا، ذ ڒبْهِيمثْ نّشْ لَّا، ؤُڒَا ذ أَبَارَّانِي نِّي أَكِيذكْ إِدْجَانْ ذَاخڒْ إِ ثوُّورَا نّشْ لَّا. ");
INSERT INTO rifa_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","مِينْزِي ذِي ستَّا ن وُوسَّانْ إِڭَّا سِيذِي إِجنْوَانْ ذ ثمُّورْثْ، ڒبْحَارْ ذ مَارَّا مِينْ ذَايسْ ؤُشَا يَاريّحْ ذڭْ وَاسّْ وِيسّْ سبْعَا. خْ ؤُيَا إِبَاركْ سِيذِي أَسّْ ن سّبْثْ ؤُشَا إِسّْقدّسْ إِ-ث. ");
INSERT INTO rifa_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","وقَّارْ بَابَاشْ ذ يمَّاشْ، مَاحنْذْ ؤُسَّانْ ن ثُوذَارْثْ نّشْ زمَّارنْ أَذْ زُّوڭَّارْثنْ ذِي ثمُّورْثْ إِ ذ أَشْ غَا يوْشْ سِيذِي، أَربِّي نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","وَارْ نقّْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","وَارْ زنَّا. ");
INSERT INTO rifa_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","وَارْ تَّاشَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","وَارْ شهّذْ س ژُورْ ضِيدّْ إِ جَّارْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","وَارْ مژْرِي ذِي شَا، ثَادَّارْثْ ن جَّارْ نّشْ وَارْ ذَايسْ مژْرِي. وَارْ مژْرِي ذِي ثَامْغَارْثْ ن جَّارْ نّشْ، نِيغْ ذڭْ يِيسْمغْ نّسْ، نِيغْ ذِي ثَايَّا نّسْ، نِيغْ ذڭْ ؤُفُونَاسْ نّسْ، نِيغْ ذڭْ وغْيُوڒْ نّسْ ؤُڒَا ذڭْ إِشْثْ ن ڒْحَاجّثْ إِ إِدْجَانْ ن جَّارْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","مَارَّا ڒْڭنْسْ إِژْرَا ؤُ إِسْڒَا إِ وَاجَّاجنْ ذ وَاسَّامنْ ذ دّْرِيزْ ن ؤُسُوضِي ذڭْ ؤُيِيشّْ ن إِشَارِّي ذ وذْرَارْ إِدُّوخُّوننْ. ؤُمِي إِژْرَا ڒْڭنْسْ مَانْ أَيَا، خنِّي أَرْجِيجنْ ؤُشَا بعّْذنْ نِيثْنِي غَارْ ڒَاڭّْوَاجْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","نَّانْ إِ مُوسَا: ”سِيوڒْ شكْ أَكِيذْنغْ ؤُشَا أَذْ نْسڒْ. مَاشَا إِتّْخصَّا أَربِّي وَارْ كِيذْنغْ إِسِّيوِيڒْ، حِيمَا وَارْ نتّْمتِّي!“ ");
INSERT INTO rifa_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","إِنَّا مُوسَا إِ ڒْڭنْسْ: ”وَارْ ثڭّْوذمْ شَا، أَقَا يُوسَا-د أَربِّي، حِيمَا أَذْ كنِّيوْ إِقدْجبْ ؤُ حِيمَا أَذْ زَّايسْ ثڭّْوذمْ مَاحنْذْ وَارْ ثْخطِّيمْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","إِبدّْ ڒْڭنْسْ زِي ڒَاڭّْوَاجْ، مَاشَا مُوسَا إِقَارّبْ-د غَارْ ؤُسيْنُو إِبُّومْبْسنْ مَانِي ثُوغَا أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","إِنَّا سِيذِي إِ مُوسَا: ”أَمُّو إِتّْخصَّا أَذْ ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل: ’كنِّيوْ ثژْرِيمْ بلِّي سِّيوْڒغْ-د أَكِيذْومْ زڭْ ؤُجنَّا. ");
INSERT INTO rifa_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","وَارْ كِيذِي تّڭّمْ إِربِّيثنْ ن نُّوقَارْثْ ؤُ وَارْ تّڭّمْ إِربِّيثنْ ن وُورغْ إِ يِيخفْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","أڭّْ أَيِي إِجّْ ن ؤُعَالْطَارْ س ؤُشَاڒْ، قدّمْ خَاسْ ثِيغَارْصَا نّشْ ن وشْمَاضْ ذ ثِيغَارْصَا نّشْ ن ڒهْنَا، ؤُدْجِي نّشْ ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ نّشْ. ذِي كُوڒْ أَمْشَانْ مَانِي غَا ڭّغْ ڒِيذَارثْ ن يِيسمْ إِنُو، أَذْ غَاركْ د-أَسغْ ؤُشَا أَذْ أَشْ بَارْكغْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","مَاڒَا ثڭِّيذْ أَيِي إِجّْ ن ؤُعَالْطَارْ ن إِژْرَا، وَارْ ث ثْبنِّيذْ س ثْصُوضَارْ إِتّْوَاسُّويْذَانْ، مِينْزِي مَاڒَا ثدّْزذْ س ؤُڒيْزِيمْ نّشْ، إِڒِي أَذْ ث ثسّْعِيدْجْثذْ. ");
INSERT INTO rifa_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","وَارْ تّْڭِيعِّيذْ غَارْ ؤُعَالْطَارْ إِنُو س يِيجّْ ن دّْرُوجْ، حِيمَا وَارْ إِتّْبِينْ ؤُسضْحِي نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","”ثِينَا إِ إِدْجَانْ ذ لْفَارَايِيضْ نِّي ذ أَسنْ غَا ثسِّيوْضذْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","مَاڒَا ثسْغِيذْ إِسْمغْ ذ أَعِيبْرَانِي، خنِّي نتَّا أَذْ أَشْ إِسخَّارْ ستَّا ن إِسڭّْوُوسَا، مَاشَا ذڭْ ؤُسڭّْوَاسْ وِيسّْ سبْعَا أَذْ إِفّغْ ذ أَحُورِّي بَاطڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","مَاڒَا يُوذفْ وحّْذسْ، وحّْذسْ إِ غَا إِفّغْ، مَاڒَا غَارسْ ثَامْغَارْثْ، أَذْ إِفّغْ نتَّا ذ ثمْغَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","مَاڒَا سِيذِيسْ إِوْشَا أَسْ ثَامْغَارْثْ ؤُشَا نتَّاثْ ثجَّا أَسْ-د إِحنْجِيرنْ ذ ثْحنْجِيرِينْ، خنِّي ثَامْغَارْثْ ذ ثَارْوَا نّسْ أَذْ إِڒِينْ ن سِيذِيسْ، ؤُ خنِّي نتَّا أَذْ إِفّغْ س إِمَانْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","مَاشَا مَاڒَا إِسْمغْ إِنَّا نِيشَانْ: ’نشّْ خْسغْ سِيذِي إِنُو ذ ثمْغَارْثْ إِنُو ذ ثَارْوَا إِنُو، وَارْ خْسغْ أَذْ فّْغغْ ذ أَحُورِّي!‘، ");
INSERT INTO rifa_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ڒخْذنِّي سِيذِيسْ أَذْ ث إِسّْبدّْ زَّاثْ إِ أَربِّي. أَذْ ث يَاوِي غَارْ ثوَّارْثْ نِيغْ غَارْ ثفْڒَاوْثْ غَارْ ؤُغزْذِيسْ ن ثوَّارْثْ ؤُشَا سِيذِيسْ أَذْ أَسْ إِسّْنُوقّبْ أَمجِّينْ نّسْ س يِيشْثْ ن ثْسِينفْثْ ؤُشَا نتَّا أَذْ أَسْ إِسخَّارْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","مَاڒَا إِزّنْزْ حذْ يدْجِيسْ ذ ثَايَّا، وَارْ إِتّفِّيغْ أَمْ مُوخَاسْ تّفّْغنْ إِسمْغَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","مَاڒَا وَارْ ثعْجِيبْ إِ ثِيطَّاوِينْ ن سِيذِيسْ ؤُ نتَّا ثُوغَا إِخْضبْ إِ-ت، أَذْ ت يجّْ أَذْ ثتّْوَافْذِي. وَارْ إِزمَّارْ أَذْ ت إِزّنْزْ إِ يِيجّْ ن ڒْڭنْسْ ن بَارَّا مِينْزِي نتَّا إِغْذَارْ زَّايسْ س مِينْ إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","مَاڒَا إِخْضبْ إِ-ت إِ مِّيسْ، أَذْ كِيذسْ يڭّْ عْلَاحْسَابْ لْفَارِيضَا زِي جّْهثْ ن يدْجِيسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","مَاڒَا إِكْسِي ثَامْغَارْثْ نّغْنِي إِ يِيخفْ نّسْ، وَارْ إِنقّصْ ڒْعُوتْشْ ن ويْسُومْ نّسْ، نِيغْ أَرُّوضْ نّسْ، نِيغْ ڒْعَاشَارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","مَاڒَا نتَّا وَارْ ذ أَسْ إِڭِّي ثْڒَاثَا-يَا، خنِّي نتَّاثْ أَذْ ثفّغْ بَاطڒْ، بْڒَا ڒخْرَاصْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","”ونِّي إِ غَا إِوْثنْ حذْ أَڒْ غَا إِمّثْ، أَذْ ث نْغنْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","مَاڒَا وَارْ ث إِڭِّي نعْمَاذَا، مَاشَا أَربِّي إِڭَّا أَسْ-د ذڭْ ؤُفُوسْ نّسْ، ڒخْذنِّي نشّْ أَذْ أَشْ سّشْنغْ أَمْشَانْ مَانِي إِزمَّارْ أَذْ يَارْوڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","مَاشَا مَاڒَا يُوفّْ حذْ خْ وَاجَّارْ نّسْ ؤُشَا إِنْغَا إِ-ث س ڒغْذَارثْ، خنِّي أَذْ ث ثكْسِيذْ غَارْ ؤُعَالْطَارْ إِنُو، مَاحنْذْ أَذْ ث نْغنْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ونِّي إِوْثِينْ بَابَاسْ نِيغْ يمَّاسْ، أَذْ إِتّْوَانغْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ونِّي يُوشَارنْ بْنَاذمْ ؤُشَا إِزّنْزْ إِ-ث، نِيغْ إِتّْوَافْ عَاذْ غَارسْ، أَذْ إِتّْوَانغْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ونِّي إِ غَا إِنعْڒنْ بَابَاسْ نِيغْ يمَّاسْ، أَذْ إِتّْوَانغْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","مَاڒَا إِرْيَازنْ مّْشُوبّْشنْ ؤُشَا إِجّنْ إِوْثَا ونّغْنِي س وژْرُو نِيغْ س ڒْپُونِييّثْ، ؤُشَا وَانِيثَا وَارْ إِمُّوثْ، مَاشَا إِوْضَا ذِي ثَاسُّوثْ، ");
INSERT INTO rifa_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","خنِّي، مَاڒَا وَانِيثَا إِكَّارْ عَاوذْ ؤُشَا يُويُورْ غَارْ بَارَّا خْ ثغَّارْشْثْ، أَذْ يِيڒِي ونِّي ث إِوْثِينْ ذ أَمزْذَاڭْ. أَذْ أَسْ إِخدْجصْ مْغِيرْ مِينْ يَاريّحْ ؤُشَا أَذْ ث يجّْ أَذْ إِڭّنْفَا مْلِيحْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","مَاڒَا إِوْثَا حذْ إِسْمغْ نّسْ نِيغْ ثَايَّا نّسْ س وعْمُوذْ ؤُشَا إِمُّوثْ سَاذُو ؤُفُوسْ نّسْ، خنِّي إِتّْخصَّا أَذْ أَسْ يَاغْ خْ ثسْغَارْثْ نّسْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","مَاشَا مَاڒَا إِقِّيمْ إِبدّْ إِجّْ نِيغْ ثْنَاينْ ن وُوسَّانْ، وَارْ ذ أَسْ يُوغِي ثَاسْغَارْثْ، مِينْزِي نتَّا ذ ثَامنْيَاثْ ن نُّوقَارْثْ نّسْ إِ يدْجَا. ");
INSERT INTO rifa_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","مَاڒَا إِرْيَازنْ مّنْغنْ ؤُشَا وْثِينْ إِشْثْ ن ثمْغَارْثْ س دّيْسثْ ؤُشَا إِوْضَا أَسْ-د ؤُعذِّيسْ نّسْ، مَاشَا وَارْ إِدْجِي شَا ذ أَيزِّيمْ، خنِّي نتَّا أَذْ إِخدْجصْ نِيشَانْ إِجّْ ن مُولْثَا عْلَاحْسَابْ مِينْ ذ أَسْ غَا إِتَّارْ ورْيَازْ ن ثمْغَارْثْ ؤُشَا أَذْ ت إِوْشْ إِ ڒْقُوضَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","مَاڒَا إِمْسَارْ شَا ن ؤُيزِّيمْ ذ أَعفَّانْ، ڒخْذنِّي أَذْ ثوْشذْ ثُوذَارْثْ س ثُوذَارْثْ، ");
INSERT INTO rifa_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ثِيطّْ س ثِيطّْ، ثِيغْمسْثْ س ثغْمسْثْ، أَفُوسْ س ؤُفُوسْ، أَضَارْ س ؤُضَارْ، ");
INSERT INTO rifa_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","أَشْمَاضْ س وشْمَاضْ، أَيزِّيمْ س ؤُيزِّيمْ، ثِيشْثِي س ثشْثِي. ");
INSERT INTO rifa_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","مَاڒَا إِڒْقفْ حذْ ثِيطّْ ن إِسْمغْ نّسْ نِيغْ ثِيطّْ ن ثَايَّا نّسْ، إِضيّعْ إِ-ت، خنِّي أَذْ ث يجّْ أَذْ يُويُورْ أَمنِّي زِي سِّيبّثْ ن ثِيطّْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","مَاڒَا س ثشْثِي إِتّكّسْ ثِيغْمسْثْ ن إِسْمغْ نّسْ، نِيغْ ثِيغْمسْثْ ن ثَايَّا نّسْ، خنِّي أَذْ أَسْ يجّْ أَذْ يُويُورْ أَمنِّي زِي سِّيبّثْ ن ثغْمسْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","مَاڒَا أَفُونَاسْ إِبَارّزْ أَرْيَازْ نِيغْ ثَامْغَارْثْ، ؤُ وَانِيثَا إِمُّوثْ، خنِّي أَذْ أَرْجْمنْ أَفُونَاسْ ؤُ أَيْسُومْ نّسْ وَارْ زَّايسْ تّتّنْ. بَابْ ن ؤُفُونَاسْ أَذْ يِيڒِي ذ أَفُورِّي. ");
INSERT INTO rifa_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","مَاشَا مَاڒَا أَفُونَاسْ ثُوغَا ذ أَبَارّزْ إِضنَّاضْ ذ فَارِيضنَّاضْ ؤُشَا بَابْ نّسْ ثُوغَا إِسّنْ ؤُشَا وَارْ ث إِحْضِي ؤُشَا إِنْغَا أَرْيَازْ نِيغْ ثَامْغَارْثْ، خنِّي أَذْ أَرْجْمنْ أَفُونَاسْ ؤُشَا عَاوذْ أَذْ نْغنْ بَابْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","مَاڒَا ڭِّينْ خَاسْ دّيّثْ، ڒخْذنِّي أَذْ إِوْشْ مَارَّا مِينْ خَاسْ ڭِّينْ ذ تَّامَانْ ن ؤُفكِّي إِ ثُوذَارْثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","نِيغْ مَاڒَا أَفُونَاسْ إِبَارّزْ أَحنْجِيرْ نِيغْ ثَاحنْجِيرْثْ. أَذْ أَسْ ڭّنْ عْلَاحْسَابْ لْفَارِيضَا-يَا. ");
INSERT INTO rifa_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","مَاڒَا أَفُونَاسْ إِبَارّزْ إِسْمغْ نِيغْ ثَايَّا، أَذْ وْشنْ ثْڒَاثِينْ شِيقْلُو ن نُّوقَارْثْ إِ سِيذِيسْ، ؤُشَا أَفُونَاسْ أَذْ ث أَرْجْمنْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","مَاڒَا يَارْزمْ حذْ أَنُو نِيغْ مَاڒَا إِغْزَا حذْ أَنُو ؤُشَا وَارْ ث إِذْڒِي، ؤُشَا إِوْضَا ذَايسْ ؤُفُونَاسْ نِيغْ أَغْيُوڒْ، ");
INSERT INTO rifa_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","خنِّي بَابْ ن وَانُو أَذْ إِخدْجصْ. أَذْ يَارّْ نُّوقَارْثْ إِ بَابْ نّسْ ؤُشَا ڒبْهِيمثْ إِمُّوثنْ أَذْ ثِيڒِي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","مَاڒَا أَفُونَاسْ إِيْزمْ أَفُونَاسْ ن وَاجَّارْ نّسْ أَڒَامِي إِمُّوثْ، ڒخْذنِّي أَذْ زّنْزنْ أَفُونَاسْ إِدَّارنْ، أَذْ بْضَانْ ثَامنْيَاثْ-أَ جَارْ أَسنْ ؤُشَا أَذْ بْضَانْ عَاوذْ أَفُونَاسْ أَمتِّينْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","مَاشَا مَاڒَا إِسّنْ بلِّي أَفُونَاسْ إِبَارّزْ إِضنَّاضْ ذ فَارِيضنَّاضْ، ؤُشَا بَابْ نّسْ وَارْ ث إِحْضِي، أَذْ إِخدْجصْ أَفُونَاسْ س ؤُفُونَاسْ ؤُشَا أَفُونَاسْ أَمتِّينْ أَذْ يِيڒِي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","مَاڒَا يُوشَارْ حذْ أَفُونَاسْ نِيغْ إِجّنْ زڭْ وُودْجِي ؤُشَا إِغَارْصْ أَسْ نِيغْ إِزّنْزْ إِ-ث، خنِّي أَذْ إِخدْجصْ خمْسَا ن إِفُونَاسنْ خْ يِيجّْ ن ؤُفُونَاسْ ؤُ أَربْعَا ن وُودْجِي خْ يِيجّنْ ن وُودْجِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","”مَاڒَا إِتّْوَافْ ؤُشفَّارْ عَاذْ أَمْ إِتَّاشَارْ، ؤُشَا إِوْثَا إِ-ث ؤُشَا إِمُّوثْ، وَارْ تِّيڒِينْ إِذَامّنْ خْ ونِّي ث يُوفِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","مَاڒَا ثنْقَارْ-د خَاسْ ثْفُوشْثْ، أَذْ خَاسْ إِڒِينْ إِذَامّنْ ذِي سِّيبّثْ-أَ. أَذْ أَسْ إِخدْجصْ ؤُشفَّارْ مَارَّا. مَاڒَا وَارْ غَارسْ شَا، أَذْ إِمّنْزْ ذِي سِّيبّثْ ن ثُوشّفّْرَا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","مَاڒَا ثتّْوَافْ ثُوشّفَّارْثْ ثدَّارْ ذڭْ ؤُفُوسْ نّسْ، مَا ذ أَفُونَاسْ إِ ت ثُوغَا نِيغْ ذ أَغْيُوڒْ نِيغْ ذ إِجّنْ زڭْ وُودْجِي، إِتّْخصَّا أَسْ أَذْ إِخدْجصْ ثْنَاينْ ن ثْسقَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","مَاڒَا إِجَّا حذْ أَذْ هدَّانْ ڒْْمَاڒْ إِيَّارْ نِيغْ أَمَارْجعْ ن ؤُضِيڒْ ؤُشَا يَارْوسْ ذَايسْ ثَاحِيمَارْثْ نّسْ ؤُشَا أَذْ أَسنْ إِضْڒقْ أَڒَامِي أَذْ هدَّانْ ذِي ثمُّورْثْ ن ونّغْنِي، خنِّي أَذْ ت إِخدْجصْ زِي ڒمْخيّرْ ن ييَّارْ نّسْ ؤُ زِي ڒمْخيّرْ ن ؤُمَارْجعْ ن ؤُضِيڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","مَاڒَا ثفّغْ-د ثْمسِّي ؤُشَا ثڒْقفْ أَسنَّانْ ؤُشَا ثشَّا ثِيقبِّيضِينْ ن إِمنْذِي نِيغْ إِمنْذِي إِبدّنْ نِيغْ إِيَّارْ، خنِّي ونِّي إِقّْذنْ ثِيمسِّي أَذْ إِخدْجصْ مَارَّا مِينْ إِتّْوَاشمْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","مَاڒَا إِحْضَا حذْ إِ وَاجَّارْ نّسْ نُّوقَارْثْ نِيغْ ڒقْشُوعْ ؤُ مَانْ أَيَا إِتّْوَاشَارْ أَسْ زِي ثَادَّارْثْ ن ورْيَازْ نِّي، خنِّي أَشفَّارْ، مَاڒَا ؤُفِينْ ث، أَذْ إِخدْجصْ ثْنَاينْ ن ثْسقَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","مَاڒَا وَارْ إِتّْوِيفْ ؤُشفَّارْ، ڒخْذنِّي أَذْ سّْقَارّْبنْ بَابْ ن ثَادَّارْثْ غَارْ أَربِّي مَاحنْذْ أَذْ سّْننْ مَا وَارْ إِسّْوِيژّضْ ؤُفُوسْ نّسْ غَارْ وَاڭْڒَا ن وَاجَّارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","كُوڒْ أَعذِّي زِي جِّيهثْ ن ؤُفُونَاسْ نِيغْ ن وغْيُوڒْ نِيغْ ن إِجّْ زڭْ وُودْجِي نِيغْ ن وَارُّوضْ نِيغْ ن مِينْ إِودَّارنْ إِ زَّايسْ إِنَّا حذْ: ’أَقَا-ث ذ وَا!‘، أَذْ د-ثَاسْ ثْمسْڒَاشْثْ إِ إِدْجَانْ جَارْ أَسنْ س ثْنَاينْ زَّاثْ إِ ڒْقُوضَاثْ ؤُشَا ونِّي أَذْ خَاسْ حكْمنْ ڒْقُوضَاثْ أَذْ إِخدْجصْ إِ وَاجَّارْ نّسْ ثْنَاينْ ن ثْسقَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","مَاڒَا إِوْشَا حذْ إِ وَاجَّارْ نّسْ أَغْيُوڒْ نِيغْ أَفُونَاسْ نِيغْ إِجّْ ن زڭْ وُودْجِي، نِيغْ مَامّشْ مَا ثڭَّا ڒبْهِيمثْ، حِيمَا أَذْ ث إِحْضَا ؤُشَا إِمُّوثْ نِيغْ يَارّژْ نِيغْ ؤُشَارنْ ث، أَمْ وَارْ إِژْرِي حذْ، ");
INSERT INTO rifa_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","خنِّي أَذْ ثِيڒِي ثْجَادْجِيثْ غَارْ سِيذِي جَارْ أَسنْ س ثْنَاينْ بلِّي وَارْ إِسّْوِيژّضْ أَفُوسْ نّسْ غَارْ وَاڭْڒَا ن وَاجَّارْ نّسْ. بَابْ نّسْ أَذْ إِقْبڒْ ثَاجَادْجِيثْ نّسْ ؤُشَا أَذْ ثَافْ بْڒَا مَا أَذْ ث إِتّْخدْجصْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","مَاشَا مَاڒَا إِتّْوَاشَارْ نِيشَانْ زَّايسْ، ذِي لْحَالَا-يَا أَذْ إِخدْجصْ إِ بَابْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","مَاڒَا إِبَانْ أَقَا إِتّْوَامزّقْ نِيشَانْ، أَذْ ث يَاوِي ذ بُورْهَانْ ؤُشَا وَارْ إِتّْخدْجِيصْ مِينْ إِتّْوَامزّْقنْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","مَاڒَا يَارْضڒْ حذْ شَا خْ وَاجَّارْ نّسْ ؤُشَا ثَارّژْ نِيغْ ثمُّوثْ ذِي ڒْغَايبْ ن بَابْ نّسْ، إِتّْخصَّا أَسْ أَذْ ت إِخدْجصْ مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","مَاشَا مَاڒَا بَابْ نّسْ ثُوغَا إِحْضَارْ، وَارْ ت إِتّْخِيدْجَاصْ. مَاڒَا ثُوغَا إِشْرَا ت خَاسْ، أَذْ د-يَاسْ خْ ڒخْڒَاصْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","”ؤُشَا مَاڒَا إِمَّارْضنْ حذْ خْ شَا ن ثعْزَاڒشْثْ، ثُوغَا وَارْ ت إِخْضِيبْ حذْ عَاذْ، ؤُشَا إِطّصْ أَكِيذسْ، إِتّْخصَّا أَسْ أَذْ أَسْ إِوْشْ صَّاذَاقْ إِمُونْ مَاحنْذْ أَذْ ت يَاوِي ذ ثَامْغَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","مَاڒَا بَابَاسْ وَارْ إِخْسْ أَذْ أَسْ ت إِوْشْ، أَذْ أَسْ إِوْزنْ عَاذْ صَّاذَاقْ ن ثعْزُورَايْ س نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","وَارْ تّجِّي ثَاسحَّارْثْ أَذْ ثدَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","مَانْ ونْ إِ غَا إِطّْصنْ أَكْ-ذ إِجّْ ن ڒْمَاڒْ، أَذْ ث نْغنْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ونِّي إِ غَا إِوهّْبنْ شَا ن ثْغَارْصْثْ إِ إِربِّيثنْ، وَارْ إِدْجِي مْغِيرْ إِ سِيذِي وَاهَا، إِتّْخصَّا أَذْ إِتّْوَاحَارّمْ إِ ؤُثحِّي. ");
INSERT INTO rifa_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","وَارْ دّدْجمْ أَبَارَّانِي ؤُ وَارْ خَاسْ تّْزيَّارمْ، مِينْزِي ثُوغَا ؤُڒَا ذ كنِّيوْ ذ إِبَارَّانِييّنْ ذِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","وَارْ تّْذدْجِي شَا إِشْثْ ن ثَاجَّاتْشْ نِيغْ إِجّْ ن ؤُيُوجِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","مَاڒَا ثِيوْضذْ أَذْ ث ثسّحْقَارذْ أَطَّاسْ ؤُشَا نتَّا إِسْغُويْ-د غَارِي، أَقَا نشّْ س ؤُغِيڒْ أَذْ سْڒغْ إِ ثْغُويِّيثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","أَذْ يَارغْ وغْضَابْ إِنُو ؤُشَا نشّْ أَذْ كنِّيوْ نْغغْ س سِّيفْ، ثِيمطَّا نْومْ أَذْ ذوْڒنْثْ ذ ثِيجَّاڒْ ذ ثَارَّاوْثْ نْومْ ذ إِيُوجِيڒنْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","مَاڒَا ثَارضْڒذْ نُّوقَارْثْ إِ ڒْڭنْسْ إِنُو، إِ ؤُمزْڒُوضْ إِ ذِينْ غَاركْ، خنِّي وَارْ كِيذسْ تّڭّذْ أَمْ إِتّڭّْ بَابْ ن ؤُمَارْوَاسْ: وَارْ خَاسْ تّڭّْ شَا أَرِّيبَا. ");
INSERT INTO rifa_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","مَاڒَا ثكْسِيذْ أَرُّوضْ ن وَاجَّارْ نّشْ ذ أَضْمَانْ، أَرّْ أَسْ ث قْبڒْ مَا أَذْ ثغْڒِي ثْفُوشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","مِينْزِي وَارْ غَارسْ مْغِيرْ أَڒحَّافْ وَانِيثَا، أَقَا-ث ذ أَرُّوضْ خْ ثڒْمشْثْ نّسْ. مِينْ ذِي غَا إِطّصْ خنِّي؟ خْمِي غَارِي د غَا إِسْغُويْ، ڒخْذنِّي أَذْ أَسْ سْڒغْ، مِينْزِي نشّْ أَقَا ذ أَحْنِينْ! ");
INSERT INTO rifa_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","وَارْ تّْشقِّيفْ ذِي أَربِّي ؤُ وَارْ تّكّْوَارْ ڒْحَاكمْ ن ڒْڭنْسْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","وَارْ سْعطَّاڒَا ثَاشُّورثْ ن ثْميْرَا نّشْ نِيغْ أَحْڒَايْ ن ثيْسَارْثْ نّشْ. أَذْ أَيِي ثوْشذْ ؤُڒَا ذ أَمنْزُو ن إِحنْجِيرنْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","أَمُّو إِ غَا ثڭّذْ عَاوذْ س إِفُونَاسنْ نّشْ ذ وُودْجِي نّشْ. سبْعَا ن وُوسَّانْ أَذْ إِڒِينْ أَكْ-ذ يمَّاثْسنْ ؤُشَا غَارْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ أَيِي ثنْ ثوْشذْ. ");
INSERT INTO rifa_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","أَذْ أَيِي ثِيڒِيمْ ذ إِمْقدَّاسنْ ؤُ وَارْ تّتّمْ أَيْسُومْ إِ إِتّْوَامزّْقنْ ذِي ڒخْڒَا. أَذْ ث ثنْضَارمْ إِ يِيطَانْ.“    ");
INSERT INTO rifa_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","”وَارْ سُّوفُّوغْ ڒخْبَارْ إِسّْخَارِّيقنْ. وَارْ تِّيشْ أَفُوسْ نّشْ إِ ؤُعفَّانْ، مَاحنْذْ أَذْ ثِيڒِيذْ ذ أَشهَّاذْ ن دّدْجْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","وَارْ أَردّفْ أَزْينْ أَمقّْرَانْ ذِي ڒْغَارْ ؤُ وَارْ د-تَّارِّي ذِي دّعْوثْ أَڒْ غَا ثْميّْڒذْ ثڭّْوجذْ خْ ڒْحقّْ أَوَارْنِي إِ وَاطَّاسْ، أَذْ ثْفَارْغذْ ڒْحقّْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ذِي دّعْوثْ نّسْ وَارْ تّْرِيحْ شَا أَكْ-ذ ڒْمسْكِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","مَاڒَا ثڒْقِيذْ أَفُونَاسْ نِيغْ أَغْيُوڒْ إِودَّارْ ن ڒعْذُو نّشْ، إِتّْخصَّا أَذْ أَسْ ث ثَارّذْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","مَاڒَا ثژْرِيذْ أَغْيُوڒْ ن ونِّي ثْشَارّْهذْ إِوْضَا س دّْقڒْ نّسْ، إِتّْخصَّا شكْ أَذْ ثحْضِيذْ إِخفْ نّشْ أَذْ ثجّذْ ثَامسْڒَاشْثْ إِ نتَّا وَاهَا، مَاشَا شكْ ذ نتَّا جْمِيعْ أَذْ ثْفكّمْ أَغْيُوڒْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","وَارْ سْفَارَّاغْ ثَاسْغَارْثْ ن ؤُمزْڒُوضْ إِ ذِينْ غَاركْ ذِي دّعْوثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","بعّذْ خْ ثْمسْڒَاشْثْ إِغشّنْ. وَارْ نقّْ أَفُورِّي نِيغْ أَمْسڭّذْ، مِينْزِي نشّْ وَارْ تّْبَارِّيغْ أَعفَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","وَارْ كسِّي ثَارْزفْثْ، مِينْزِي ثَارْزفْثْ ثسّْذَارْغَاڒْ ثِيطَّاوِينْ يَارزْمنْ ؤُ ثسّْفَارَّاغْ أَوَاڒنْ ن إِمْسڭّْذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","وَارْ ثْزيَّارمْ خْ ؤُبَارَّانِي. أَقَا كنِّيوْ ثسّْنمْ نّفْسْ ن ؤُبَارَّانِي، مِينْزِي ثُوغَا كنِّيوْ ذ إِبَارَّانِييّنْ ذِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ستَّا ن إِسڭّْوُوسَا أَذْ ثْزَارْعذْ ثَامُّورْثْ نّشْ ؤُشَا أَذْ ثسّْمُونذْ ڒْغِيدْجثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ذڭْ ؤُسڭّْوَاسْ وِيسّْ سبْعَا أَذْ ت ثجّذْ أَذْ ثَاريّْحذْ ؤُشَا أَذْ أَسْ ثَارْخُوذْ، حِيمَا أَذْ زَّايسْ شّنْ إِمزْڒَاضْ ن ڒْڭنْسْ نّشْ. ؤُشَا مِينْ غَا جّنْ نِيثْنِي أَذْ زَّايسْ شّنْ ڒْمَاڒْ ن ڒخْڒَا. أَمُّو إِ غَا ثڭّذْ عَاوذْ س ؤُمَارْجعْ ن ؤُضِيڒْ نّشْ ذ زِّيثُونْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ذِي ستَّا ن وُوسَّانْ أَذْ ثڭّذْ ڒْخذْمثْ نّشْ ؤُ ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ثَاريّْحذْ، مَاحنْذْ أَذْ يَاريّحْ ؤُفُونَاسْ نّشْ ذ وغْيُوڒْ نّشْ ؤُ أَذْ يَارّْ نّفْسْ مِّيسْ ن ثَايَّا نّشْ ذ ؤُبَارَّانِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ذِي مَارَّا مِينْ ذ أَومْ نِّيغْ، حْضَامْ ث. وَارْ تِّيذَارمْ إِسمْ ن إِربِّيثنْ نّغْنِي. وَارْ تّسْڒَانْ إِسمْ نّسْ زڭْ ؤُقمُّومْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ثْڒَاثَا ن ثْوَاڒَاوِينْ ذڭْ ؤُسڭّْوَاسْ أَذْ أَيِي ثْعيّْذمْ إِجّْ ن ڒْعِيذْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ڒْعِيذْ ن وغْرُومْ بْڒَا أَنْثُونْ أَذْ ث ثحْضَامْ. سبْعَا ن وُوسَّانْ أَذْ ثشّذْ أَغْرُومْ بْڒَا أَنْثُونْ، أَمْ مَامّشْ كنِّيوْ ؤُمُورغْ نشّْ، ذِي ڒْوقْثْ إِتّْوَاڭّنْ ذڭْ ؤُيُورْ أَبِيبْ، مِينْزِي ذَايسْ إِ د-ثفّْغذْ زِي مِيصْرَا. وَارْ د-تُّوسِيمْ س إِفَاسّنْ خْوَانْ زَّاثْ إِ وُوذمْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","حْضَامْ عَاوذْ ڒْعِيذْ ن ثْميْرَا، ڒْعِيذْ ن ثْمنْزُوثْ ن ڒْخذْمثْ نّشْ إِ ثْزَارْعذْ ذڭْ إِيَّارْ، ؤُ ڒْعِيذْ ن ؤُسْمُونِي ن صَّابثْ ذڭْ ؤُنڭَّارْ ن ؤُسڭّْوَاسْ، خْمِي غَا ثسّْمُونذْ ڒْغِيدْجثْ ن ڒْخذْمثْ نّشْ زڭْ إِيَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ثْڒَاثَا ن ثْوَاڒَاوِينْ ذڭْ ؤُسڭّْوَاسْ أَذْ ضْهَارنْ مَارَّا إِرْيَازنْ ن ڒْڭنْسْ نّشْ إِ وُوذمْ ن سِيذِي، سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","وَارْ تّْقدَّامْ إِذَامّنْ ن ثْغَارْصْثْ إِنُو أَكْ-ذ مِينْ إِخمَّارنْ، ؤُ ثَاذُونْثْ ن ثْغَارْصْثْ ن ڒْعِيذْ إِنُو وَارْ تّْنُوسِي دْجِيڒثْ ثكْمڒْ أَڒْ صّْبحْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ثَامزْوَارُوثْ ن ثْمنْزُوثْ زڭْ وُوذمْ ن ثمُّورْثْ نّشْ أَذْ ت ثَاوْيذْ غَارْ ثَادَّارْثْ ن سِيذِي، أَربِّي نّشْ. وَارْ سْننِّي إِغَايْضْ ذ أَمژْيَانْ س ؤُغِي ن يمَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","خْزَارْ، أَذْ سّكّغْ إِجّْ ن لْمَالَاكْ زَّاثْ إِ وُوذمْ نّشْ، حِيمَا أَذْ شكْ إِحْضَا ذڭْ وبْرِيذْ ؤُشَا أَذْ شكْ يَاوِي غَارْ ومْشَانْ نِّي سّْوجْذغْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","حْضَا أَرنْذَاذْ إِ وُوذمْ نّسْ ؤُشَا سڒْ إِ وَاوَاڒْ نّسْ، وَارْ خَاسْ سَّارْزِيڭْ شَا ڒعْمَارْ، مِينْزِي نتَّا وَارْ إِتّكّسْ إِعذِّيينْ نْومْ، مِينْزِي إِسمْ إِنُو أَقَا-ث ذَايسْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","مَاشَا مَاڒَا س ثِيذتّْ أَذْ ثسْڒذْ إِ وَاوَاڒْ نّسْ، أَذْ ثڭّذْ مَارَّا مِينْ ذ أَشْ غَا إِنِيغْ، أَذْ إِڒِيغْ ذ ڒعْذُو إِ ڒْعذْيَانْ نّشْ ؤُشَا أَذْ حْصَارغْ إِنِّي شكْ إِحصَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","مِينْزِي لْمَالَاكْ إِنُو أَذْ يِيڒِي زَّاثكْ، أَذْ شكْ سِّيذْفغْ ذِي ثمُّورْثْ ن إِمُورِييّنْ ذ إِحِيتِّييّنْ ذ إِفِيرِيزِييّنْ ذ أَيْثْ ن كنْعَانْ ذ إِحِيوِييّنْ ذ إِيابُوسِييّنْ، ؤُ نشّْ أَذْ ثنْ ثحِّيغْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","وَارْ تّْبنْذِيقْ إِ إِربِّيثنْ نْسنْ نِيغْ أَذْ ثنْ ثْعبْذذْ نِيغْ أَذْ ثڭّذْ أَمْ تّڭّنْ نِيثْنِي، مَاشَا أَذْ ثنْ ثثحِّيذْ قَاعْ ؤُشَا أَذْ ثَارْژذْ مَارَّا إِمَايْضُوثنْ نْسنْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","أَذْ ثْعبْذمْ سِيذِي، أَربِّي نْومْ، ؤُ نتَّا أَذْ إِبَاركْ أَغْرُومْ نّشْ ذ وَامَانْ نّشْ. نشّْ أَذْ كّْسغْ ڒهْڒَاشَاثْ زِي ڒْوسْطْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","وَارْ تِّيڒِي ثمْغَارْثْ نِّي ؤُمِي إِوْضَا ؤُعذِّيسْ نِيغْ وَارْ إِتِّيرْونْ ذِي ثمُّورْثْ نّشْ. نشّْ أَذْ كمّْڒغْ ڒْقدّْ ن وُوسَّانْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","أَذْ سّكّغْ أَنخْڒِيعْ زَّاثْ إِ ؤُغمْبُوبْ نّشْ، أَذْ سّْخَاروْضغْ مَارَّا ڒْڭنْسْ إِ غَا ثَافذْ ذڭْ وبْرِيذْ نّشْ ؤُشَا أَذْ أَرّغْ مَارَّا ڒْعذْيَانْ نّشْ أَذْ خَاكْ أَروْڒنْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","نشّْ أَذْ سّكّغْ إِرزَّانْ زَّاثْ إِ ؤُغمْبُوبْ نّشْ، إِنِّي غَا يَاژّْڒنْ خْ إِحِيوِييّنْ ذ أَيْثْ ن كنْعَانْ ذ إِحِيتِّييّنْ زَّاثْ إِ وُوذمْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","وَارْ خَاسنْ تَّاژّْڒغْ زِي زَّاثْ نْومْ ذڭْ إِجّْ ن ؤُسڭّْوَاسْ، مَاحنْذْ وَارْ ثتّْغِيمِي ثمُّورْثْ ذ ڒخْڒَا ؤُ ڒْمَاڒْ ن ڒخْڒَا وَارْ خَاكْ تّْمَارْنِينْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","س شْوَايْ شْوَايْ أَذْ خَاسنْ أَژّْڒغْ زِي زَّاثْ نشّْ، أَڒْ غَا ثمَّارنْيذْ ذڭْ وَاطَّاسْ ؤُشَا أَذْ ثْزمَّارذْ أَذْ ثكْسِيذْ ثَامُّورْثْ ذ ڒْوَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","نشّْ أَذْ ڭّغْ إِيْمِيرنْ زِي ڒبْحَارْ ن ثلْڭَا أَڒْ ڒبْحَارْ ن إِفِيلِيسْطِينِييّنْ ؤُ زِي ڒخْڒَا أَڒْ إِغْزَارْ ن لْفُورَاطْ، مِينْزِي أَذْ أَرّغْ إِمزْذَاغْ ن ثمُّورْثْ ذڭْ ؤُفُوسْ نّشْ ؤُشَا أَذْ شكْ أَرّغْ أَذْ خَاسنْ ثَاژّْڒذْ زِي زَّاثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","وَارْ كِيذْسنْ تّڭّْ ڒْعَاهْذْ نِيغْ أَكْ-ذ إِربِّيثنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","وَارْ إِعدّڒْ أَذْ زذْغنْ ذِي ثمُّورْثْ نّشْ، حِيمَا وَارْ شكْ تَّارِّينْ أَذْ أَكِيذِي ثخْضِيذْ. مَاڒَا ثْعبْذذْ إِ إِربِّيثنْ نْسنْ، أَذْ أَشْ يِيڒِي مَانْ أَيَا ذ ڒْفخْ إِ شكْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ؤُشَا إِنَّا نتَّا إِ مُوسَا: ”ڭعّذْ غَارْ سِيذِي، شكْ ذ هَارُونْ ذ نَاذَابْ ذ أَبِيهُو، ذ سبْعِينْ ن إِمْغَارنْ ن إِسْرَائِيل، ؤُشَا بنْذْقمْ زِي ڒَاڭّْوَاجْ. ");
INSERT INTO rifa_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","مُوسَا وحّْذسْ أَذْ د-إِقَارّبْ غَارْ سِيذِي، مَاشَا وَارْ إِعدّڒْ أَذْ قَارّْبنْ نِيثْنِي. ؤُڒَا ذ ڒْڭنْسْ وَارْ كِيذسْ إِتّْڭِيعِّيذْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","مُوسَا إِعْقبْ-د ؤُشَا إِخبَّارْ ڒْڭنْسْ خْ مَارَّا أَوَاڒنْ ن سِيذِي ؤُ خْ مَارَّا لْفَارَايِيضْ. مَارَّا ڒْڭنْسْ يَارَّا-د س يِيجّْ ن وَاوَاڒْ، نَّانْ: ”مَارَّا أَوَاڒنْ إِ إِنَّا سِيذِي أَذْ زَّايْسنْ نڭّْ.“    ");
INSERT INTO rifa_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","مُوسَا يُورَا مَارَّا أَوَاڒنْ ن سِيذِي. غَارْ صّْبحْ زِيشْ إِكَّارْ ؤُشَا إِبْنَا إِجّْ ن ؤُعَالْطَارْ غَارْ إِضَارنْ ن وذْرَارْ ؤُشَا إِڭَّا ثنْعَاشْ ن إِمَايْضُوثنْ ن وژْرُو، عْلَاحْسَابْ ڒْْقدّْ ن ثنْعَاشْ ن ثْقبَّاڒْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","إِسّكّْ إِحُوذْرِييّنْ زڭْ أَيْثْ ن إِسْرَائِيل، إِنِّي إِسّْبخَّارنْ ثِيغَارْصِي ن وشْمَاضْ ؤُ قدّْمنْ ثِيغَارْصِي ن ڒهْنَا زڭْ إِفُونَاسنْ إِمژْيَاننْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","إِكْسِي مُوسَا أَزْينْ ن إِذَامّنْ، إِڭَّا إِ-ث ذِي طّْبَاصِي ؤُشَا أَزْينْ نّغْنِي ن إِذَامّنْ إِزدْجعْ إِ-ثنْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","إِكْسِي أَذْلِيسْ إِتّْوَانّْضنْ ن ڒْعَاهْذْ، إِغْرَا إِ-ث خْ إِمزُّوغنْ ن ڒْڭنْسْ ؤُشَا نِيثْنِي نَّانْ: ”مَارَّا مِينْ ذ أَنغْ إِنَّا سِيذِي، أَذْ ث نڭّْ، أَذْ ث نْطَاعْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","إِكْسِي مُوسَا إِذَامّنْ، إِرُوشّْ إِ-ثنْ خْ ڒْڭنْسْ، إِنَّا: ”خْزَارْ، إِنَا ذ إِذَامّنْ ن ڒْعَاهْذْ نِّي إِڭَّا سِيذِي أَكِيذْومْ خْ مَارَّا أَوَاڒنْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","إِڭعّذْ مُوسَا أَكْ-ذ هَارُونْ ذ نَاذَابْ ذ أَبِيهُو ذ سبْعِينْ ن إِمْغَارنْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ژْرِينْ أَربِّي ن إِسْرَائِيل. ثُوغَا سَاذُو إِضَارنْ نّسْ أَمْ ثِيسِي ن زّلِّيجْ إِ إِتّْوَاڭّنْ ن صَافِّيرْ أَزِيزَا، إِصْفَا أَمْ ؤُجنَّا سِيمَانْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","وَارْ إِسّْوِيژّضْ أَفُوسْ نّسْ خْ إِمْشنّْعنْ ن أَيْثْ ن إِسْرَائِيل ؤُشَا نِيثْنِي خْزَارنْ غَارْ أَربِّي، شِّينْ، سْوِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","إِنَّا سِيذِي إِ مُوسَا: ”ڭعّذْ-د غَارِي غَارْ وذْرَارْ ؤُشَا قِّيمْ ذِينْ ؤُشَا نشّْ أَذْ أَشْ وْشغْ ثِيڒْوِيحِينْ ن وژْرُو، شَّارِيعَا ذ ڒُومَارَاثْ ثِينِّي ؤُرِيغْ خْ ثڒْوِيحِينْ، حِيمَا أَذْ أَسنْ ثنْثْ ثسّْڒمْذذْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","إِكَّارْ مُوسَا أَكْ-ذ يَاشُووَا، أَمْسخَّارْ نّسْ، ؤُشَا إِڭعّذْ مُوسَا غَارْ وذْرَارْ ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","إِنَّا إِ إِمْغَارنْ: ”رَاجَامْ أَنغْ ذَانِيثَا أَڒْ د غَارْومْ إِ غَا نذْوڒْ. خْزَارْ، هَارُونْ ذ حُورْ أَكِيذْومْ. مَاڒَا ذِينْ حذْ غَارسْ دّْعَاوِي، إِتّْخصَّا أَسْ أَذْ غَارْسنْ إِرَاحْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","خنِّي إِڭعّذْ مُوسَا غَارْ وذْرَارْ، ؤُشَا إِجّْ ن ؤُسيْنُو إِذْڒَا أَذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","أَعُودْجِي ن سِيذِي ثُوغَا إِزدّغْ ذڭْ وذْرَارْ ن سِينَا ؤُ أَسيْنُو إِذْڒَا إِ-ث ستَّا ن وُوسَّانْ ؤُشَا ذڭْ وَاسّْ وِيسّْ سبْعَا إِڒَاغَا-د نتَّا خْ مُوسَا زِي ڒْوسْطْ ن ؤُسيْنُو. ");
INSERT INTO rifa_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","أَسْشَانْ ن ؤُعُودْجِي ن سِيذِي ثُوغَا-ث ذِي ثِيطَّاوِينْ ن أَيْثْ ن إِسْرَائِيل أَمْ ثْمسِّي إِتّتّنْ خْ ثْقِيشَّاثْ ن وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","يُوذفْ مُوسَا غَارْ ڒْوسْطْ ن ؤُسيْنُو ؤُشَا إِڭعّذْ أَذْرَارْ. ثُوغَا مُوسَا إِقِّيمْ أَربْعِينْ ن وُوسَّانْ ذ أَربْعِينْ ن دْجْيَاڒِي ذڭْ وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","”إِنِي إِ أَيْثْ ن إِسْرَائِيل أَذْ أَيِي د-سّْڭَاعّْذنْ ثَاوْهِيبْثْ. زِي كُوڒْ أَرْيَازْ نِّي ذ أَسْ إِعَارّنْ وُوڒْ نّسْ، أَذْ زَّايسْ ثكْسِيمْ ثَاوْهِيبْثْ ن ؤُسْڭَاعّذْ إِ نشّْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ثَا ذ ثَاوْهِيبْثْ ن ؤُسْڭعّذْ، ثنِّي إِ غَا ثكْسِيذْ زَّايْسنْ: ؤُرغْ ذ نُّوقَارْثْ ذ نّْحَاسْ، ");
INSERT INTO rifa_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ذ ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ڒقْطنْ أَزْذَاذْ ذ شّْعَارْ ن إِغَايْضنْ، ");
INSERT INTO rifa_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ذ إِڒْمَاونْ إِزڭّْوَاغنْ ن إِشَارِّييّنْ، ذ إِڒْمَاونْ ن دّنْفِيڒَاثْ، ذ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا، ");
INSERT INTO rifa_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","زّشْثْ إِ ثْفَاوْثْ ن ڒْقنْذِيڒْ، ڒعْطُورْ إِ زّشْثْ ن وذْهَانْ ؤُ إِ ڒبْخُورْ إِتّْفُوحنْ، ");
INSERT INTO rifa_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","إِژْرَا ن ؤُنِيكْسْ ذ إِژْرَا إِغْڒَانْ نّغْنِي، مَاحنْذْ أَذْ ثنْ ڭّنْ خْ ؤُپَالْطُو ؤُ خْ ثَاجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","أَذْ أَيِي ڭّنْ إِشْثْ ن زَّاوشْثْ إِقدّْسنْ، حِيمَا أَذْ زذْغغْ ذِي ڒْوسْطْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","أَذْ ث ثڭّذْ أَمْ مَارَّا مِينْ ذ أَشْ غَا سّشْنغْ، عْلَاحْسَابْ أَمذْيَا ن ثْزذِّيغْثْ ؤُ عْلَاحْسَابْ أَمذْيَا ن مَارَّا ڒقْشُوعْ إِ ذَايسْ إِدْجَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","أَذْ ڭّنْ عَاوذْ إِشْثْ ن تَّابُوثْ ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا. أَذْ ثِيڒِي ثُوزّڭَّارْثْ نّسْ ثْنَاينْ ن إِغَادْجنْ ذ وزْينْ ؤُ ثِيرُو نّسْ إِجّْ ن ؤُغِيڒْ ذ وزْينْ ؤُ ڒُوعْڒَا نّسْ إِجّْ ن ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","أَذْ ث تّْشلّذْ س وُورغْ إِصْفَانْ، زِي ذَاخڒْ ؤُ زِي بَارَّا أَذْ ت ثْشلّذْ، ؤُشَا غَارْ سنّجْ أَذْ أَسْ ثنّْضذْ إِجّْ ن زّْوَاقْ ن وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","أَذْ أَسْ ثسّْفسْيذْ أَربْعَا ن ثخْرَازِينْ ن وُورغْ. أَذْ ثنْثْ ثْشدّذْ غَارْ أَربْعَا ن ثْيَارْسَاوِينْ نّسْ. ثْنَاينْ ن ثخْرَازِينْ أَذْ إِڒِينْثْ غَارْ يِيجّْ ن ؤُغزْذِيسْ ؤُ ثْنَاينْ ن ثخْرَازِينْ إِ ؤُغزْذِيسْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","أَذْ ثڭّذْ إِعُومَاذْ إِ ثْربُّوثْ زڭْ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا ؤُشَا أَذْ ثنْ ثذْڒذْ س وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","سِيذْفمْ إِعُومَاذْ ذِي ثخْرَازِينْ نِّي إِدْجَانْ غَارْ إِغزْذِيسنْ ن تَّابُوثْ، حِيمَا أَذْ زَّايْسنْ أَرْبُونْ تَّابُوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","إِعُومَاذْ أَذْ إِڒِينْ ذِي ثخْرَازِينْ ن تَّابُوثْ، وَارْ زَّايْسنْثْ ثنْ تّكّْسنْ شَا. ");
INSERT INTO rifa_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","أَذْ ثسَّارْسذْ شّْهَاذثْ، ثنِّي إِ ذ أَشْ غَا وْشغْ، ذِي تَّابُوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","أَذْ ثڭّذْ عَاوذْ إِشْثْ ن ثْقبَّارْثْ ن وصْڒَاحْ ن وُورغْ إِصْفَانْ س يِيشْثْ ن ثُوزّڭَّارْثْ ن ثْنَاينْ ن إِغَادْجنْ ذ وزْينْ ؤُ س إِشْثْ ن ثِيرُو ن إِجّْ ن ؤُغِيڒْ ذ وزْينْ.    ");
INSERT INTO rifa_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","أَذْ ثڭّذْ عَاوذْ ثْنَاينْ ن إِكِيرُوبنْ ن وُورغْ إِعْذڒْ س وفْضِيسْ، أَڒَامِي إِ غَا فّْغنْ إِكِيرُوبنْ زِي ثْنَاينْ ن إِخْفَاونْ ن ثْقبَّارْثْ ن وصْڒَاحْ.    ");
INSERT INTO rifa_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","أَذْ ثڭّذْ إِجّْ ن ؤُكِيرُوبْ غَارْ إِجّْ ن يِيخفْ ؤُ إِجّْ ن ؤُكِيرُوبْ نّغْنِي غَارْ يِيخفْ نّغْنِي. أَذْ ثڭّمْ إِكِيرُوبنْ زِي ثْقبَّارْثْ ن وصْڒَاحْ غَارْ ثْنَاينْ ن إِخْفَاونْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","أَذْ بزّْعنْ إِكِيرُوبنْ أَفْرِيونْ نْسنْ سنّجْ نْسنْ ؤُشَا أَذْ ذْڒنْ ثَاقبَّارْثْ ن وصْڒَاحْ س وَافْرِيونْ نْسنْ. ؤُذْمَاونْ نْسنْ أَذْ إِڒِينْ إِجّْ قِيبَاتْشْ إِ ونّغْنِي ؤُشَا أَذْ ژَترنْ ؤُذْمَاونْ ن إِكِيرُوبنْ غَارْ ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","أَذْ ثڭّذْ ثَاقبَّارْثْ ن وصْڒَاحْ خْ تَّابُوثْ ؤُشَا أَذْ ثسَّارْسذْ شّْهَاذثْ إِ ذ أَشْ غَا وْشغْ ذِي تَّابُوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ذِينِّي إِ كِيشْ غَا مّڒْقِيغْ ؤُشَا أَذْ كِيكْ سِّيوْڒغْ زِي سنّجْ إِ ثْقبَّارْثْ ن وصْڒَاحْ، زِي جَارْ ثْنَاينْ ن إِكِيرُوبنْ نِّي إِدْجَانْ سنّجْ إِ تَّابُوثْ ن شّْهَاذثْ، خْ مَارَّا مِينْ ذ أَشْ غَا ؤُمُورغْ إِ أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","أَذْ ثڭّذْ إِشْثْ ن ثْزوْضَا ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا، أَذْ غَارسْ ثِيڒِي إِشْثْ ن ثُوزّڭَّارْثْ ن ثْنَاينْ ن إِغَادْجنْ ذ إِشْثْ ن ثِيرُو ن إِجّنْ ؤُغِيڒْ ذ إِجّْ ن ڒُوعْڒَا ن إِجّنْ ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","أَذْ ت ثذْڒذْ س وُورغْ إِصْفَانْ ؤُشَا أَذْ أَسْ ثڭّذْ غَارْ ثْمَا نّسْ إِجّْ زّْوَاقْ ن وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","أَذْ ثڭّذْ إِشْثْ ن ثْمَا إِ ذ أَسْ د-إِنّْضنْ ن إِجّنْ شْبَارْ ن ؤُفُوسْ ؤُ غَارْ ثْمَا إِ ذ أَسْ د-إِنّْضنْ أَذْ ثڭّذْ إِجّْ ن زّْوَاقْ ن وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","أَذْ ثڭّذْ أَربْعَا ن ثخْرَازِينْ ن وُورغْ ؤُشَا أَذْ ثنْثْ ثْشدّذْ غَارْ أَربْعَا ن ثْغمُّورَا نِّي إِدْجَانْ غَارْ أَربْعَا ن إِضَارنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ثِيخْرَازِينْ أَذْ إِڒِينْثْ ؤُذْسنْثْ إِ ثْمَا، مَاحنْذْ أَذْ ذَايْسنْثْ تّْوَاطّْفنْ إِعُومَاذْ إِ ثَاربُّوثْ ن ثْزوْضَا. ");
INSERT INTO rifa_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","أَذْ ثڭّذْ إِعُومَاذْ إِ ثَاربُّوثْ زڭْ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا، أَذْ ثنْ ثْغدْجْفذْ س وُورغْ ؤُشَا أَذْ زَّايْسنْ أَرْبُونْ ثَازوْضَا. ");
INSERT INTO rifa_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","أَذْ ثڭّذْ عَاوذْ طّْبَاصِي نّسْ ذ ثْغنْجَايِينْ نّسْ ذ إِغَارَّافنْ نّسْ ذ ڒْكِيسَانْ نّسْ إِ زِي غَا فَارّْغنْ. أَذْ ثنْ ثڭّذْ س وُورغْ إِصْفَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","خْ ثْزوْضَا أَذْ ثڭّذْ أَغْرُومْ ن وسْشَانْ ڒبْذَا زَّاثْ إِ وُوذمْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","أَذْ ثڭّذْ ڒْقنْذِيڒْ س وُورغْ إِصْفَانْ. أَذْ ثڭّذْ ڒْقنْذِيڒْ س وفْضِيسْ ن ومْزِيڒْ. أَفُوذْ أَكْ-ذ ؤُضَارْ نّسْ ذ إِغَادْجنْ نّسْ ؤُڒَا ذ ڒْكِيسَانْ نّسْ ذ ثْعبُّوزِينْ نّسْ إِ د-إِتَّاسنْ أَكْ-ذ نُّووَّارَاثْ نّسْ أَذْ إِڒِينْ ذ أَغزْذِيسْ ذ إِجّْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ستَّا ن إِغَادْجنْ أَذْ د-فّْغنْ زڭْ إِغزْذِيسنْ نّسْ، ثْڒَاثَا ن إِغَادْجنْ زڭْ إِجّْ ن ؤُغزْذِيسْ نْ ڒْقنْذِيڒْ ذ ثْڒَاثَا ن إِغَادْجنْ زڭْ ؤُغزْذِيسْ نّغْنِي ن ڒْقنْذِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ثْڒَاثَا ن ڒْكِيسَانْ أَذْ إِڒِينْ ذڭْ إِجّْ ن ؤُغِيڒْ ذِي فُورْمَا ن نُّووَّارَاثْ ن دْجوْزْ أَكْ-ذ ثْعبُّوزْثْ ذ نّوَّاشْ، ؤُشَا عَاوذْ غَارْ ؤُغِيڒْ نّغْنِي ثْڒَاثَا ن ڒْكِيسَانْ ذِي فُورْمَا ن نُّووَّارَاثْ ن دْجوْزْ أَكْ-ذ ثْعبُّوزْثْ ذ نّوَّاشْ. أَمُّو إِ غَا ڭّنْ مَارَّا ستَّا ن إِغَادْجنْ نِّي د-إِفّْغنْ زِي ڒْقنْذِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","غَارْ ڒْقنْذِيڒْ سِيمَانْثْ نّسْ أَذْ ذِينْ إِڒِينْ أَربْعَا ن ڒْكِيسَانْ ذِي فُورْمَا ن نُّووَّارَاثْ ن دْجوْزْ، أَكْ-ذ ثْعبُّوزِينْ نْسنْ إِ د-إِتَّاسنْ أَكْ-ذ نُّووَّارَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","أَذْ ذِينْ ثِيڒِي إِشْثْ ن ثْعبُّوزْثْ سَاذُو ثْيُويَا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ ؤُ إِشْثْ ن ثْعبُّوزْثْ سَاذُو ثْيُويَا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ أَوَارْنِي أَسْ، ؤُ عَاوذْ إِشْثْ ن ثْعبُّوزْثْ سَاذُو ثْيُويَا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ أَوَارْنِي أَسْ. أَمُّو إِ غَا يِيڒِي إِ ستَّا ن إِغَادْجنْ إِ د-إِفّْغنْ زِي ڒْقنْذِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ثِيعبُّوزِينْ نْسنْ ذ إِغَادْجنْ نْسنْ أَذْ زَّايسْ-د فّْغنْ ؤُشَا مَارَّا أَيَا أَذْ يِيڒِي ذ إِشْثْ ن ڒْقشْعثْ ثتّْوَاعْذڒْ س وفْضِيسْ ن ومْزِيڒْ س وُورغْ إِصْفَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","أَذْ ثڭّذْ ستَّا ن ڒفْنَارَاثْ نّسْ ؤُشَا أَذْ سَّارْسنْ ڒفْنَارَاثْ نّسْ خْ ڒْقنْذِيڒْ، مَاحنْذْ أَذْ وْشنْثْ ثْفَاوْثْ غَارْ طَّارْفْ ن ؤُجمَّاضْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ثِيجقَّاضِينْ ن ثفْثِيتْشْ نّسْ ذ ثْمجْمَارِينْ نّسْ أَذْ إِڒِينْثْ س وُورغْ إِصْفَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","أَذْ إِتّْوَاڭّْ ڒْْقنْذِيڒْ زڭْ إِشْثْ ن ثَالِينْثْ ن وُورغْ إِصْفَانْ س مَارَّا ڒقْشُوعْ-أَ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ؤُشَا خْزَارْ، أَذْ ث ثڭّذْ أَمْ ؤُمذْيَا نّسْ، ونِّي إِ ذ أَشْ إِتّْوَامْڒنْ ذڭْ وذْرَارْ.“   * ");
INSERT INTO rifa_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","”أَذْ ثڭّذْ ثَازذِّيغْثْ سعشْرَا ن ثْجَارْثِيڒِينْ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ، أَكْ-ذ إِكِيرُوبنْ. أَذْ ثنْ ثڭّذْ أَمْ ڒْخذْمثْ ن ؤُفنَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ثُوزّڭَّارْثْ ن يِيشْثْ ن ثْجَارْثِيڒْثْ أَذْ ثِيڒِي ثْمنْيَا ؤُ-عِيشْرِينْ ن إِغَادْجنْ ؤُ ثِيرُو ن يِيشْثْ ن ثْجَارْثِيڒْثْ أَربْعَا ن إِغَادْجنْ. مَارَّا ثِيجَارْثِيڒِينْ أَذْ غَارْسنْثْ يِيڒِي ڒعْبَارْ ذ إِجّْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","خمْسَا ن ثْجَارْثِيڒِينْ أَذْ ثنْثْ سّْمُوننْ إِشْثْ أَكْ-ذ ثنّغْنِي ؤُ عَاوذْ خمْسَا ن ثْجَارْثِيڒِينْ أَذْ ثنْثْ سّْمُوننْ إِشْثْ أَكْ-ذ ثنّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","غَارْ ثْمَا ن يِيشْثْ ن ثْجَارْثِيڒْثْ غَارْ طَّارْفْ مَانِي ت غَا سّْمُوننْ، أَذْ ثڭّذْ ثِيسَارَاوِينْ ثِيذحْمَانِينْ. أَمُّو إِ ثنْثْ غَا ثڭّذْ عَاوذْ غَارْ ثْمَا ن ثْجَارْثِيڒْثْ نّغْنِي غَارْ طَّارْفْ إِ غَارْ إِدْجَا ؤُسڒْقِي نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","خمْسِينْ ن ثْسَارَاوِينْ إِ غَا ثڭّذْ ذڭْ إِشْثْ ن ثْجَارْثِيڒْثْ ؤُ خمْسِينْ ن ثْسَارَاوِينْ غَارْ طَّارْفْ ن ثْجَارْثِيڒْثْ نِّي غَارْ إِدْجَا ؤُسڒْقِي نّغْنِي، مَاحنْذْ ثِيسَارَاوِينْ أَذْ مّڒْقَانْثْ إِشْثْ أَكْ-ذ ثنّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","أَذْ ثڭّذْ عَاوذْ خمْسِينْ ن ثْسنَّارِينْ ن وُورغْ ؤُشَا أَذْ ثسّْمُونذْ ثِيجَارْثِيڒِينْ إِشْثْ أَكْ-ذ ثنّغْنِي س ثْسنَّارِينْ، مَاحنْذْ أَذْ ثذْوڒْ ذ إِشْثْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","أَذْ ثڭّذْ عَاوذْ ثِيجَاڒْثِيڒِينْ س شّْعَارْ ن إِغَايْضنْ، مَاحنْذْ أَذْ إِڒِينْثْ ذ إِجّْ ن ؤُقِيضُونْ خْ ثْزذِّيغْثْ. أَذْ ثڭّذْ حِيطَاشْ ن ثْجَارْثِيڒِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ثُوزّڭَّارْثْ ن إِشْثْ ن ثْجَارْثِيڒْثْ أَذْ ثِيڒِي ثْڒَاثِينْ ن إِغَادْجنْ ؤُ ثِيرُو ن إِشْثْ ن ثْجَارْثِيڒْثْ أَذْ ثِيڒِي أَربْعَا ن إِغَادْجنْ. حِيطْعَاشْ ن ثْجَارْثِيڒِينْ أَذْ غَارْسنْثْ يِيڒِي ڒعْبَارْ ذ إِجّْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","أَذْ ثسّْمُونذْ خمْسَا ن ثْجَارْثِيڒِينْ وحّذْسنْثْ ذ ستَّا ن ثْجَارْثِيڒِينْ عَاوذْ وحّذْسنْثْ. ثَاجَارْثِيڒْثْ وِيسّْ ستَّا أَذْ ت ثْضفْصذْ زَّاثْ إِ وُوذمْ ن ؤُقِيضُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","أَذْ ثڭّذْ خمْسِينْ ن ثْسَارَاوِينْ غَارْ ثْمَا ن يِيشْثْ ن ثْجَارْثِيڒْثْ غَارْ طَّارْفْ غَارْ ؤُسڒْقِي، ؤُشَا خمْسِينْ ن ثْسَارَاوِينْ خْ ثْمَا ن ثْجَارْثِيڒْثْ غَارْ ؤُسڒْقِي نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","أَذْ ثڭّذْ خمْسِينْ ن ثْسنَّارِينْ ن نّْحَاسْ ؤُشَا أَذْ ثنْثْ ثسِّيذْفذْ ذِي ثْسَارَاوِينْ ؤُشَا أَذْ ثسّْمُونذْ أَقِيضُونْ، مَاحنْذْ أَذْ يِيڒِي ذ إِجّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","مِينْ إِشطّنْ ن ثْجَارْثِيڒِينْ ن ؤُقِيضُونْ، أَزْينْ ن ثْجَارْثِيڒْثْ نِّي إِشطّنْ أَذْ يَايڒْ غَارْ ضفَّارْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","زِي مِينْ إِشطّنْ ذِي ثُوزّڭَّارْثْ ن ثْجَارْثِيڒِينْ، إِجّْ ن ؤُغِيڒْ أَذْ يَايڒْ غَارْ يِيجّْ ن طَّارْفْ ذ إِجّْ ن ؤُغِيڒْ غَارْ طَّارْفْ نّغْنِي، غَارْ ثْنَاينْ ن إِغزْذِيسنْ ن ثْزذِّيغْثْ، مَاحنْذْ أَذْ أَسْ إِڒحّفْ إِ يِيجّْ ن ؤُغزْذِيسْ ؤُ إِ ؤُغزْذِيسْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","أَذْ ثڭّذْ إِ ؤُقِيضُونْ عَاوذْ إِشْثْ ن ثْسقَّافْثْ ن إِڒْمَاونْ إِزڭّْوَاغنْ ن إِشَارِّييّنْ ؤُ سنّجْ إِ مَانْ أَيَا إِشْثْ ن ثْسقَّافْثْ ن إِڒْمَاونْ ن دّنْفِيڒَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","أَذْ ثڭّذْ إِ ثْزذِّيغْثْ ثِيفڒْوِينْ ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا نِّي إِبدّنْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ڒعْبَارْ ن ثُوزّڭَّارْثْ ن إِشْثْ ن ثفْڒَاوْثْ ذَايسْعشْرَا ن إِغَادْجنْ ؤُ ڒعْبَارْ ن ثِيرُو ن إِشْثْ ن ثفْڒَاوْثْ ذَايسْ إِجّْ ن ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","إِ كُوڒْ ثَافْڒَاوْثْ أَذْ غَارسْ إِڒِينْ ثْنَاينْ ن إِضَارنْ، إِنِّي إِسّْمڒْقَانْ ثْوتْشْمَاثِينْ إِشْثْ أَكْ-ذ ثنّغْنِيثْ، أَمُّو إِ غَا ثڭّذْ إِ مَارَّا ثِيفڒْوِينْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","أَذْ ثڭّذْ إِ ثْزذِّيغْثْ ثِيفڒْوِينْ، عِيشْرِينْ ن ثْفڒْوِينْ غَارْ جِّيهثْ ن لْجَانُوبْ، غَارْ يفُوسْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","أَذْ ثڭّذْ أَربْعِينْ ن ثْيَارْسَاوِينْ ن نُّوقَارْثْ مَاحنْذْ أَذْ ثنْثْ سَّارْسنْ سَاذُو عِيشْرِينْ ن ثْفڒْوِينْ، ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو إِشْثْ ن ثفْڒَاوْثْ إِ ثْنَاينْ ن إِضَارنْ نّسْ، ذ ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو ثَافْڒَاوْثْ نّغْنِي إِ ثْنَاينْ ن إِضَارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","عَاوذْ أَذْ ثڭّذْ عِيشْرِينْ ن ثْفڒْوِينْ إِ ؤُغزْذِيسْ نّغْنِي ن ثْزذِّيغْثْ، غَارْ جِّيهثْ ن شَّامَالْ، ");
INSERT INTO rifa_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","س أَربْعِينْ ن ثْيَارْسَاوِينْ نْسنْ ن نُّوقَارْثْ: ثْنَاينْ ن ثْيَارْسَاوِينْ إِ كُوڒْ ثَافْڒَاوْثْ ذ ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو ثَافْڒَاوْثْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ؤُ غَارْ ؤُغزْذِيسْ ن ڒْغَارْبْ ن ثْزذِّيغْثْ أَذْ أَسْ ثڭّذْ ستَّا ن ثْفڒْوِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","أَذْ ثڭّذْ ثْنَاينْ ن ثْفڒْوِينْ إِ ثْغمُّورَا ن ثْزذِّيغْثْ إِ إِدْجَانْ غَارْ ثْنَاينْ ن إِغزْذِيسنْ ن ضفَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","زِي سْوَادَّايْ أَذْ إِڒِينْثْ صْقنْثْ أَمْ وَاشْنِيونْ ؤُشَا أَمُّو إِ غَا إِڒِينْثْ نِيشَانْ ذ إِشْثنْ أَڒْ غَا أَوْضنْثْ سنّجْ ذڭْ إِشْثْ ن ثخْرَازْثْ. أَمُّو إِ غَا يِيڒِي إِ ثْنَاينْ ن ثْفڒْوِينْ غَارْ ثْنَاينْ ن ثْغمُّورَا. ");
INSERT INTO rifa_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","أَذْ ذِينْ إِڒِينْثْ ثْمنْيَا ن ثْفڒْوِينْ أَكْ-ذ ثْيَارْسَاوِينْ نْسنْثْ ن نُّوقَارْثْ. خنِّي سطَّاشْ ن ثْيَارْسَاوِينْ، ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو إِشْثْ ن ثفْڒَاوْثْ ذ ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو ثَافْڒَاوْثْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","أَذْ ثڭّذْ ثِيحنْيَا ن ؤُعَارّضْ زڭْ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا، إِنِّي غَا إِعْذُونْ خْ ثْفڒْوِينْ، خمْسَا إِ ثْفڒْوِينْ ن إِجّْ ن ؤُغزْذِيسْ ن ثْزذِّيغْثْ ");
INSERT INTO rifa_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ؤُ خمْسَا ن ثْحنْيَا ن ؤُعَارّضْ إِ ثْفڒْوِينْ غَارْ ؤُغزْذِيسْ نّغْنِي ن ثْزذِّيغْثْ ؤُ خمْسَا ن ثْحنْيَا ن ؤُعَارّضْ إِ ثْفڒْوِينْ ن ؤُغزْذِيسْ ن ثْزذِّيغْثْ غَارْ ؤُغزْذِيسْ ن ڒْغَارْبْ غَارْ ثْنَاينْ ن إِغزْذِيسنْ ن ضفَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ثَاحْنَاشْثْ ن ؤُعَارّضْ ذِي ڒْوسْطْ أَذْ ثعْذُو خْ ثْفڒْوِينْ ذِي ڒْوسْطْ، زڭْ إِجّْ ن يِيخفْ غَارْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","أَذْ ثْغدْجْفذْ ثِيفڒْوِينْ س وُورغْ ؤُشَا أَذْ ثڭّذْ ثِيخْرَازِينْ نْسنْ ن وُورغْ، مَاحنْذْ أَذْ ذَايْسنْثْ سِّيذْفنْ ثِيحنْيَا ن ؤُعَارّضْ. أَذْ ثذْڒذْ عَاوذْ ثِيحنْيَا ن ؤُعَارّضْ س وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","أَذْ ثسّْڭعّْذذْ ثَازذِّيغْثْ عْلَاحْسَابْ أَمذْيَا ن ڒبْنِي نِّي ذ أَشْ إِتّْوَامْڒنْ خْ وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","أَذْ ثڭّضْ إِجّْ ن ؤُڒحَّافْ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، أَذْ ث ڭّنْ أَمْ ڒْخذْمثْ ن ؤُفنَّانْ، ؤُشَا إِكِيرُوبنْ أَذْ خَاسْ إِڒِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","أَذْ ث ثَايْڒذْ خْ أَربْعَا ن إِپِيلَارنْ ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا إِ إِذْڒِينْ س وُورغْ. ثِيسنَّارِينْ نْسنْ أَذْ إِڒِينْثْ ن وُورغْ ؤُشَا إِپِيلَارنْ نِّي أَذْ بدّنْ خْ أَربْعَا ن ثْيَارْسَاوِينْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","أَذْ ثَايْڒذْ أَڒحَّافْ غَارْ وَادَّايْ ن ثْسنَّارِينْ ؤُشَا أَذْ ثسِّيذْفذْ تَّابُوثْ ن شّْهَاذثْ ذَاخڒْ إِ ؤُڒحَّافْ ؤُشَا أَڒحَّافْ أَذْ إِبْضَا جَارْ ؤُقدَّاسْ ذ وقْذَاسْ خْ ؤُقدَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","أَذْ ثسَّارْسذْ ثَاقبَّارْثْ ن وصْڒَاحْ خْ تَّابُوثْ ن شّْهَاذثْ ذڭْ وقْذَاسْ خْ ؤُقدَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","أَذْ ثڭّذْ ثَازوْضَا بَارَّا إِ ؤُڒحَّافْ ؤُشَا أَذْ ثسَّارْسذْ ڒْقنْذِيڒْ قِيبَاتْشْ إِ ثْزوْضَا غَارْ ؤُغزْذِيسْ ن ثْزذِّيغْثْ غَارْ جِّيهثْ ن لْجَانُوبْ ؤُ أَذْ ثڭّذْ ثَازوْضَا غَارْ ؤُغزْذِيسْ غَارْ جِّيهثْ ن شَّامَالْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","أَذْ ثڭّذْ أَرْوَاقْ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ إِ وَاذَافْ ن ؤُقِيضُونْ، أَمْ إِجّْ ن ؤُمُوذِي ن ؤُخيَّاضْ. ");
INSERT INTO rifa_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ؤُشَا أَذْ ثڭّذْ إِ أَرْوَاقْ خمْسَا ن إِپِيلَارنْ ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا ؤُشَا أَذْ ثنْ ثْشلّذْ س وُورغْ. ثِيسنَّارِينْ نْسنْ أَذْ إِڒِينْثْ ن وُورغْ ؤُ إِ إِپِيلَارنْ نِّي أَذْ أَسنْ ثْفسْيذْ خمْسَا ن ثْيَارْسَاوِينْ ن نّْحَاسْ.“ * ");
INSERT INTO rifa_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","”أَذْ ثڭّذْ أَعَالْطَارْ ن ؤُكشُّوضْ ن ؤُكَاسِييَا ن خمْسَا ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ ذ خمْسَا ن إِغَادْجنْ ذِي ثِيرُو. أَذْ يِيڒِي س أَربْعَا ن ثْغمُّورَا ؤُ ڒُوعْڒَا نّسْ أَذْ يِيڒِي ثْڒَاثَا ن إِغَادْجنْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","غَارْ أَربْعَا ن ثْغمُّورَا أَذْ ثڭّذْ أَشَّاونْ نّسْ. أَشَّاونْ نّسْ أَذْ ذوْڒنْ ذ إِجّنْ أَكِيذسْ ؤُشَا أَذْ ث ثْڒحّْفذْ س نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","أَذْ ثڭّذْ ثِييْذُورِينْ نّسْ، حِيمَا أَذْ ذَايْسنْثْ ثنْضَارذْ إِغّضْ ن مِينْ إِقِّيمنْ ن ثَاذُونْثْ نّسْ إِتّْوَاشمْضنْ ؤُشَا أَذْ ثڭّذْ عَاوذْ إِغنْجَاينْ نّسْ ذ طَّاوْيَاثْ نّسْ إِ ؤُرُوشِّي ذ فُورْشَايَاثْ نّسْ ذ ثْمجْمَارِينْ نّسْ. أَذْ ثڭّذْ مَارَّا ڒقْشُوعْ نّسْ س نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","أَذْ ثڭّذْ إِشْثْ ن ثْرَاشَّا، إِشْثْ ن ؤُمُوذِي ن نّْحَاسْ، ؤُشَا أَذْ ثڭّذْ أَربْعَا ن ثخْرَازِينْ ن نّْحَاسْ إِ ؤُمُوذِي نِّي، غَارْ أَربْعَا ن ثْغمُّورَا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","أَذْ ث ثْزيَّارذْ سَاذُو إِ ثْمَا ن ؤُعَالْطَارْ، سْوَادَّايْ، مَاحنْذْ أَذْ يِيڒِي ؤُمُوذِي ن نّْحَاسْ نِّي غَارْ وزْينْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","أَذْ ثڭّذْ إِعُومَاذْ إِ ثَاربُّوثْ إِ ؤُعَالْطَارْ، إِعُومَاذْ ن ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا أَذْ ثنْ ثْڒحّْفذْ س نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","إِعُومَاذْ نّسْ أَذْ تّْوَاسِّيذْفنْ ذِي ثخْرَازِينْ. أَذْ إِڒِينْ إِعُومَاذْ إِ ثَاربُّوثْ غَارْ ثْنَاينْ ن إِغزْذِيسنْ ن ؤُعَالْطَارْ خْمِي ث غَا أَرْبُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","أَذْ ثڭّذْ إِجّْ ن ڒْخَاوِي غَارْ ذَاخڒْ ن ثْفڒْوِينْ. أَمْ مَامّشْ إِ ذ أَشْ إِمْڒَا خْ وذْرَارْ، أَمُّو إِ ث غَا ڭّنْ نِيثْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","أَذْ ثڭّذْ ڒمْرَاحْ ن ثْزذِّيغْثْ. غَارْ جِّيهثْ ن لْجَانُوبْ، غَارْ يفُوسْ، أَذْ ثڭّذْ ڒِيزَارَاثْ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، كُوڒْ إِشْثْ زَّايْسنْثْ ن مْيَا ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ إِ يِيجّْ ن ؤُغزْذِيسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","عِيشْرِينْ ن إِپِيلَارنْ نّسْ ذ عِيشْرِينْ ن ثْيَارْسَاوِينْ نّسْ أَذْ إِڒِينْ ن نّْحَاسْ. ثِيسنَّارِينْ ن إِپِيلَارنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي أَذْ إِڒِينْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","أَمُّو غَارْ جِّيهثْ ن شَّامَالْ، ذِي ثُوزّڭَّارْثْ، أَذْ ذِينْ إِڒِينْثْ ڒِيزَارَاثْ ن مْيَا إِغَادْجنْ. أَذْ إِڒِينْ عِيشْرِينْ ن إِپِيلَارنْ نْسنْثْ ذ عِيشْرِينْ ن ثْيَارْسَاوِينْ نْسنْ ن نّْحَاسْ. ثِيسنَّارِينْ ن إِپِيلَارنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي أَذْ إِڒِينْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ذِي ثِيرُو ن ڒمْرَاهْ، غَارْ ؤُغزْذِيسْ ن ڒْغَارْبْ، أَذْ ذِينْ إِڒِينْثْ ڒِيزَارَاثْ ن خمْسِينْ ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ أَكْ-ذعشْرَا ن إِپِيلَارنْ نْسنْثْ ذعشْرَا ن ثْيَارْسَاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ثِيرُو ن ڒمْرَاحْ غَارْ ؤُغزْذِيسْ ن شَّارْقْ، زِي مَانِيسْ د-ثْنقَّارْ ثْفُوشْثْ، أَذْ ثِيڒِي خمْسِينْ إِغَادْجنْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ڒِيزَارَاثْ غَارْ يِيجّْ ن ؤُغزْذِيسْ ن زَّاثْ أَذْ إِڒِينْثْ خمّسْطَاشْ ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ، أَكْ-ذ ثْڒَاثَا ن إِپِيلَارنْ نْسنْثْ ذ ثْڒَاثَا ن ثْيَارْسَاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","غَارْ ؤُغزْذِيسْ ن زَّاثْ نّغْنِي أَذْ ذِينْ إِڒِينْثْ عَاوذْ ڒِيزَارَاثْ ن خمّسْطَاشْ ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ أَكْ-ذ ثْڒَاثَا ن إِپِيلَارنْ نْسنْثْ ذ ثْڒَاثَا ن ثْيَارْسَاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","غَارْ وَاذَافْ ن ڒمْرَاحْ أَذْ ذِينْ يِيڒِي إِجّْ ن أَرْوَاقْ ن عِيشْرِينْ ن إِغَادْجنْ، ڭِّينْ ث س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، إِجّْ ن ؤُمُوذِي ن ؤُخيَّاضْ، أَكْ-ذ أَربْعَا ن إِپِيلَارنْ نّسْ ذ أَربْعَا ن ثْيَارْسَاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","مَارَّا إِپِيلَارنْ إِ ذ أَسْ د-إِنّْضنْ إِ ڒمْرَاحْ أَذْ إِڒِينْ س إِقضْبَانْ ن نُّوقَارْثْ إِ ؤُسڒْقِي ؤُشَا ثِيسنَّارِينْ نْسنْ أَذْ إِڒِينْثْ ن نُّوقَارْثْ ذ ثْيَارْسَاوِينْ نْسنْ ن نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ثُوزّڭَّارْثْ ن ڒمْرَاحْ أَذْ ثِيڒِي مْيَا ن إِغَادْجنْ ؤُ ثِيرُو أَذْ ثِيڒِي خمْسِينْ ن إِغَادْجنْ ذ خمْسِينْ عَاوذْ ؤُشَا ڒُوعْڒَا أَذْ يِيڒِي خمْسَا ن إِغَادْجنْ، مَارَّا س ڒقْطنْ أَزْذَاذْ إِمُوذنْ ؤُشَا ثْيَارْسَاوِينْ نْسنْ أَذْ إِڒِينْثْ ن نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","مَارَّا ڒقْشُوعْ ن ثْزذِّيغْثْ إِ إِدْجَانْ إِ مَارَّا ثَاسخَّارْثْ نّسْ ؤُڒَا ذ مَارَّا ڒوْثَاذْ نّسْ ذ مَارَّا ڒوْثَاذْ ن ڒمْرَاحْ أَذْ إِڒِينْ ن نّْحَاسْ. * ");
INSERT INTO rifa_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","أَذْ ثُومُورذْ أَيْثْ ن إِسْرَائِيل، حِيمَا أَذْ أَشْ د-أَوْينْ زّشْثْ ثصْفَا ثدّزْ زِي زِّيثُونْ إِ ثْفَاوْثْ، حِيمَا أَذْ ثَارغْ ثْفَاوْثْ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","هَارُونْ ذ وَارَّاوْ نّسْ أَذْ حْضَانْ مَانْ أَيَا زِي دْجِيڒثْ أَڒْ صّْبحْ زَّاثْ إِ وُوذمْ ن سِيذِي ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ زَّاثْ إِ ؤُڒحَّافْ إِ إِدْجَانْ زَّاثْ إِ شّْهَاذثْ. ذ مَانْ أَيَا أَذْ يِيڒِي ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا نِّي إِتّْخصَّا أَذْ ثتّْوَاحْضَا زِي جِّيهثْ ن أَيْثْ ن إِسْرَائِيل ذِي مَارَّا جِّيڒَاثْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","”ؤُشَا شكْ أَذْ غَاركْ د-ثسّْقَارّْبذْ هَارُونْ، ؤُمَاشْ، ذ وَارَّاوْ نّسْ أَكِيذسْ زِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل، حِيمَا أَذْ أَيِيعبْذنْ أَمْ يِيكهَّاننْ، هَارُونْ، نَاذَابْ، أَبِيهُو، أَلِيعَازَارْ ذ إِثَامَارْ، زڭْ وَارَّاوْ ن هَارُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","أَذْ ثڭّذْ أَرُّوضْ إِقدّْسنْ إِ هَارُونْ، ؤُمَاشْ، أَذْ أَسْ يِيڒِي إِ ؤُعُودْجِي ذ ثلْوِيزْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","أَذْ ثسِّيوْڒذْ غَارْ مَارَّا إِنِّي إِدْجَانْ ذ إِمِيغِيسنْ ن وُوڒْ، إِنِّي شُّورغْ س أَرُّوحْ ن ثِيغِيثْ، مَاحنْذْ أَذْ ڭّنْ أَرُّوضْ إِ هَارُونْ، حِيمَا أَذْ أَسْ سّْقدّْسنْ ذ أَكهَّانْ إِ نشّْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","إِنَا ذ أَرُّوضْ إِ غَا ڭّنْ: إِشْثْ ن ثجْمشْثْ ذ إِجّْ ن ؤُپَالْطُو ذ إِجّْ ن ؤُسڒْهَامْ ذ إِشْثْ ثْشَامِيرْ إِمُوذنْ أَمْ إِجّْ ن ؤُرقَّامْ ن ؤُفنَّانْ، ذ إِشْثْ ن أَرژّثْ ذ إِشْثْ ن ثْحزَّامْثْ. أَذْ ڭّنْ أَرُّوضْ إِقدّْسنْ إِ هَارُونْ، ؤُمَاشْ، ؤُ إِ وَارَّاوْ نّسْ، حِيمَا أَذْ أَيِي سخَّارنْ أَمْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","نِيثْنِي أَذْ كْسِينْ إِفِيڒَانْ ن وُورغْ ذ أَفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ڒقْطنْ أَزْذَاذْ، ");
INSERT INTO rifa_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ؤُشَا أَذْ ڭّنْ أَپَالْطُو س إِفِيڒَانْ ن وُورغْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، أَذْ يِيڒِي أَمْ ڒْخذْمثْ ن ؤُفنَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","أَذْ غَارسْ يِيڒِي ثْنَاينْ ن ثْغَارْضِينْ إِمّْسڒْسَاقنْ غَارْ ثْنَاينْ ن طّْرُوفَا نّسْ إِ زِي غَا إِتّْوَاسّْمُونْ ؤُپَالْطُو. ");
INSERT INTO rifa_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ثَاحزَّامْثْ إِزوّْقنْ، ونِّي إِدْجَانْ خْ ؤُپَالْطُو نّسْ ن ؤُكهَّانْ، أَذْ زَّايسْ ثتّْوَاڭّْ ذ إِشْثنْ أَكِيذسْ، س إِفِيڒَانْ ن وُورغْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","أَذْ ثكْسِيذْ ثْنَاينْ ن إِژْرَا ن ؤُنِيكْسْ ؤُشَا أَذْ خَاسنْ ثْنقْشذْ إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ستَّا ن إِسْمَاونْ خْ يِيجّْ ن وژْرُو ذ ستَّا ن إِسْمَاونْ نّغْنِي خْ وژْرُو نّغْنِي عْلَاحْسَابْ أَستّفْ ن وخْڒَاقْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ذ مَانْ أَيَا ذ إِشْثْ ن صّنْعثْ ن ؤُنقَّاشْ ن وژْرُو إِغْڒَانْ. أَمْ إِشْثْ ن ثْخَاذنْثْ ن ؤُشمِّيعْ، أَمُّو إِ غَا تّْوَانقْشنْ ثْنَاينْ ن يژْرَا س إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل. أَذْ أَسنْ ثڭّذْ ثِيشُويَارْ ن وُورغْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","أَذْ ثڭّذْ إِژْرَا نِّي خْ ثْغَارْضِينْ ن ؤُپَالْطُو، أَقَا أَثنْ ذ إِژْرَا ن ڒِيذَارثْ إِ أَيْثْ ن إِسْرَائِيل. هَارُونْ أَذْ يَارْبُو إِسْمَاونْ نْسنْ إِ ڒِيذَارثْ زَّاثْ إِ وُوذمْ ن سِيذِي خْ ثْنَاينْ ثْغَارْضِينْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","أَذْ ثڭّذْ ثِيشُويَارْ ن وُورغْ ");
INSERT INTO rifa_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ؤُشَا عَاوذْ ثْنَاينْ ن سّْنَاسڒْ ن وُورغْ إِصْفَانْ. أَذْ ثنْ ثڭّذْ أَمشْنَاوْ إِفِيڒَانْ، أَمشْنَاوْ إِشْثْ ن ڒْخذْمثْ ن ؤُمُوذِي. أَذْ ثْشدّذْ سّْنَاسڒْ إِمُوذنْ غَارْ ثْشُويَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","أَذْ ثڭّذْ ثَاجْمشْثْ إِ ڒحْكَامْ. أَذْ ت ثڭّذْ أَمْ ڒْخذْمثْ ن ؤُفنَّانْ، أَمْ ؤُپَالْطُو ن ؤُكهَّانْ. أَذْ ت ثڭّذْ س إِفِيڒَانْ ن وُورغْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ثَاجْمشْثْ أَذْ ثِيڒِي س أَربْعَا ن ثْغمُّورَا، ثتّْوَاضْفصْ. ثُوزّڭَّارْثْ نّسْ أَذْ ثِيڒِي ذ إِجّْ ن وزْينْ ن ؤُغِيڒْ، ؤُ ثِيرُو نّسْ ذ إِجّْ ن وزْينْ ن ؤُغِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","أَذْ خَاسْ ثڭّذْ إِژْرَا، أَربْعَا ن ڒصْفُوفْ ن إِژْرَا. إِجّْ ن صّفْ أَذْ يِيڒِي س يِيجّْ ن ڒعْقِيقْ ذ أَزڭّْوَاغْ ذ إِشْثْ ن ثْيَاقُوثْ ذ إِشْثْ ن سْمَارَاخْثْ. وَا ذ صّفْ أَمزْوَارُو. ");
INSERT INTO rifa_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","صّفْ وِيسّْ ثْنَاينْ أَذْ يِيڒِي س يِيجّْ ن كَارْبُونْكلْ ذ يِيجّْ ن صَافِّيرْ أَزِيزَا ذ يِيجّْ ن ذِيأَمَانْثِي. ");
INSERT INTO rifa_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","صّفْ وِيسّْ ثْڒَاثَا أَذْ يِيڒِي س يِيجّْ ن وژْرُو ن يَاسِينْثُو ذ يِيجّْ ن أَخَاثْ ذ يِيجّْ ن ؤُمَاثِيسْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ؤُ صّفْ وِيسّْ أَربْعَا أَذْ يِيڒِي س يِيشْثْ ن ثخْرِيسُولِيثْ ذ يِيجّْ ن ؤُنِيكْسْ ذ يِيجّْ ن يَاسْبِيسْ. إِنَا أَذْ تّْوَاطّْفنْ ذڭْ وُورغْ ذِي ثْشُويَارْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","إِژْرَا أَذْ خَاسنْ إِڒِينْ إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل، ثنْعَاشْ ن يژْرَا عْلَاحْسَابْ إِسْمَاونْ نْسنْ، س إِنقَّاشنْ ن ثْخَاذنْثْ ن ؤُشمِّيعْ، كُوڒْ أَنقِّيشْ عْلَاحْسَابْ إِسمْ نّسْ إِ ذ أَسْ د-يُوسِينْ. أَقَا أَثنْ إِ ثنْعَاشْ ن ثْقبَّاڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","أَذْ ثڭّذْ سّْنَاسڒْ خْ ثجْمشْثْ، إِفِيڒَانْ إِمُوذنْ ن وُورغْ إِصْفَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","أَذْ ثڭّذْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ غَارْ ثجْمشْثْ ؤُشَا أَذْ ثْشدّذْ ثْنَاينْ ن ثخْرَازِينْ نِّي غَارْ ثْنَاينْ ن طّْرُوفَا ن ثجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","أَذْ ثْشدّذْ ثْنَاينْ ن سّْنَاسڒْ ن وُورغْ إِمُوذنْ غَارْ ثْنَاينْ ن ثخْرَازِينْ غَارْ ڒضْرُوفْ ن ثجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","أَذْ ثْشدّذْ ثْنَاينْ ن إِخْفَاونْ ن ثْنَاينْ ن سّْنَاسڒْ إِمُوذنْ غَارْ ثْنَاينْ ن ثْشُويَارْ ؤُشَا أَذْ ثنْثْ ثْشدّذْ غَارْ ثْغَارْضِينْ إِ إِدْجَانْ غَارْ ؤُغزْذِيسْ ن زَّاثْ ن ؤُپَالْطُو ن ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","أَذْ ثڭّذْ عَاوذْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ ؤُشَا أَذْ ثنْثْ ثڭّذْ غَارْ ثْنَاينْ ن إِخْفَاونْ ن ثجْمشْثْ غَارْ سْوَادَّايْ، خْ ثْمَا نْسنْ نِّي إِدْجَانْ غَارْ ؤُپَالْطُو، غَارْ ذَاخڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","أَذْ ثڭّذْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ، ثِينِّي إِ غَا ثْشذْنذْ خْ ثْنَاينْ ن ثْغَارْضِينْ ن ؤُپَالْطُو ن ؤُكهَّانْ، سْوَادَّايْ، غَارْ زَّاثْ، قِيبَاتْشْ إِ ؤُسڒْقِي نّسْ غَارْ سنّجْ إِ ثْحزَّامْثْ إِزوّْقنْ ن ؤُپَالْطُو. ");
INSERT INTO rifa_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","أَذْ ثسّْمُونذْ ثَاجْمشْثْ س ثخْرَازِينْ نّسْ غَارْ ثخْرَازِينْ ن ؤُپَالْطُو أَكْ-ذ إِجّْ ن ؤُفِيڒُو إِمُوذنْ أَذحْمِي، مَاحنْذْ أَذْ ثِيڒِي ثجْمشْثْ سنّجْ إِ ثْحزَّامْثْ إِزوّْقنْ ن ؤُپَالْطُو ؤُشَا وَارْ ثتّْبطِّي ثجْمشْثْ خْ ؤُپَالْطُو. ");
INSERT INTO rifa_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","أَمُّو إِ غَا يَاوِي هَارُونْ إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل ذِي ثجْمشْثْ ن ڒحْكَامْ خْ وُوڒْ نّسْ خْ مِينِّي إِ غَا يَاذفْ غَارْ ؤُقدَّاسْ، أَڒَامِي إِ غَا قِّيمنْ إِ ڒِيذَارثْ زَّاثْ إِ وُوذمْ ن سِيذِي إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","أَذْ ثسَّارْسذْ إِژْرَا ن ’ؤُرِيمْ‘ ذ ’ثُومِّيمْ‘ ذِي ثجْمشْثْ ن ڒحْكَامْ، مَاحنْذْ أَذْ إِڒِينْ خْ وُوڒْ ن هَارُونْ خْ مِينِّي إِ غَا يَاذفْ زَّاثْ إِ وُوذمْ ن سِيذِي. أَمُّو إِ غَا يَارْبُو هَارُونْ ڒبْذَا ڒحْكَامْ ن أَيْثْ ن إِسْرَائِيل خْ وُوڒْ نّسْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","أَذْ ثڭّذْ أَسڒْهَامْ ن ؤُپَالْطُو ن ؤُكهَّانْ مَارَّا زڭْ ؤُفِيڒُو أَذحْمِي. ");
INSERT INTO rifa_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","أَذْ يِيڒِي وَارْزَامْ إِ ؤُزدْجِيفْ نّسْ ذِي ڒْوسْطْ نّسْ. غَارْ ثْمَا ن وَارْزَامْ أَذْ ذِينْ ثِيڒِي إِشْثْ ن ثْمَا إِمُوذنْ، ثنِّي إِ غَا يِيڒِينْ أَمْ وَارْزَامْ إِ يِيرِي ذڭْ إِجّْ ن وَارُّوضْ ن وُوزَّاڒْ ن ؤُعسْكَارِي، وَارْ ثتّْشَارِّيڭْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","غَارْ ثْمُووَّا نّسْ أَذْ ثڭّذْ ثِيرمَّانِينْ ن إِفِيڒَانْ أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ، غَارْ ثْمُووَّا نّسْ إِ ذ أَسْ د-إِنّْضنْ، ؤُ جَارْ أَسنْثْ أَذْ ثڭّذْ نّْوَاقسْ ن وُورغْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","إِجّْ أَوَارْنِي إِ ونّغْنِي، إِجّْ ن نَّاقُوسْ ن وُورغْ ذ إِشْثْ ن ثْرمَّانْثْ، ؤُشَا عَاوذْ إِجّْ أَوَارْنِي إِ ونّغْنِي، إِجّْ ن نَّاقُوسْ ن وُورغْ ذ إِشْثْ ن ثْرمَّانْثْ، أَمُّو إِ غَا إِڒِينْ غَارْ ثْمُووَّا ن ؤُسڒْهَامْ ؤُ ذڭْ ونّضْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","هَارُونْ أَذْ ث يَارْضْ خْمِي إِتّْسّخَّارْ نتَّا، أَڒَامِي إِ غَا إِتّْوَاسڒْ دّْرِيزْ نّسْ خْ مِينِّي إِ غَا يَاذفْ غَارْ زَّاوشْثْ إِقدّْسنْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُ خْمِي غَا إِفّغْ عَاوذْ، حِيمَا وَارْ إِتّْمتِّي. ");
INSERT INTO rifa_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","أَذْ ثڭّذْ إِشْثْ ن ثڒْوِيحْثْ س نُّووَّارْ ن وُورغْ إِصْفَانْ ؤُشَا أَذْ خَاسْ ثْنقْشذْ أَوَاڒنْ-أَ أَمْ مَامّشْ نقّْشنْ ثَاخَاذنْثْ ن ؤُشمِّيعْ: ”أَمْقدَّاسْ إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","أَذْ ت ثْشدّذْ غَارْ يِيجّْ ن ؤُفِيڒُو أَذحْمِي خْ أَرژّثْ. أَذْ ثِيڒِي ثڒْوِيحْثْ غَارْ زَّاثْ ن ؤُرژّثْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","أَذْ ثِيڒِي ثڒْوِيحْثْ خْ ثنْيَارْثْ ن هَارُونْ، حِيمَا هَارُونْ أَذْ يَارْبُو ڒْمُوعْصِييّثْ إِ إِدْجَانْ ذِي ثْمسْڒَايِينْ إِقدّْسنْ نِّي إِ غَا سّْقدّْسنْ أَيْثْ ن إِسْرَائِيل أَكْ-ذ مَارَّا ثِيوْهِيبِينْ ن ثْمسْڒَايِينْ نْسنْ إِقدّْسنْ. أَذْ ثِيڒِي ڒبْذَا خْ ثنْيَارْثْ نّسْ، حِيمَا أَذْ إِڒِينْثْ ثْمسْڒَايِينْ نِّي أَرْضَانْثْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","أَذْ ثڭّذْ ثْشَامِيرْ س ڒقْطنْ أَزْذَاذْ. أَذْ ثڭّذْ أَرژّثْ عَاوذْ س ڒقْطنْ أَزْذَاذْ. ثَاحزَّامْثْ أَذْ ت ثڭّذْ أَمْ إِجّْ ن ؤُمُوذِي ن ؤُخيَّاضْ.“* ");
INSERT INTO rifa_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","”إِ وَارَّاوْ ن هَارُونْ أَذْ ثڭّذْ ثْشَامِيرْ ؤُ أَذْ أَسنْ ثڭّذْ ثِيحزَّامِينْ ؤُ أَذْ أَسنْ ثڭّذْ ثِيشُوشَّايْ، مَاحنْذْ أَذْ أَسنْ إِڒِينْ إِ ؤُعُودْجِي ذ ثلْوِيزْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","أَذْ ثسّْيَارْضذْ هَارُونْ، ؤُمَاشْ، ذ وَارَّاوْ نّسْ إِ كِيذسْ إِدْجَانْ، ؤُشَا شكْ أَذْ ثنْ ثْذهْنذْ، أَذْ ثنْ ثْڒقّْمذْ ؤُ أَذْ ثنْ ثسّْقدّْسذْ، حِيمَا أَذْ أَيِي خذْمنْ أَمْ يِيكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","أڭّْ أَسنْ سّْرَاوڒْ ن ڒقْطنْ، حِيمَا أَذْ ذْڒنْ أَيْسُومْ ن ؤُسضْحِي نْسنْ. أَذْ إِڒِينْ زِي ثجْعِينَّا ؤُشَا أَذْ أَوْضنْ غَارْ إِفَادّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","سّْڒَاوڒْ نِّي أَذْ إِڒِينْ خْ أَرِّيمثْ ن هَارُونْ ذ وَارَّاوْ نّسْ خْمِي غَا يَاذْفنْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ نِيغْ خْمِي د غَا قَارّْبنْ غَارْ ؤُعَالْطَارْ مَاحنْذْ أَذْ سخَّارنْ ذِي زَّاوشْثْ إِقدّْسنْ، حِيمَا وَارْ د-تِّيوْينْ ڒْمُوعْصِييّثْ ؤُشَا أَذْ مّْثنْ. ثَا أَذْ ثِيڒِي ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ نتَّا ؤُ إِ زَّارِيعثْ نّسْ أَوَارْنِي أَسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","”ذ مَانْ أَيَا إِ ذ أَسنْ غَا ثڭّذْ، حِيمَا أَذْ ثنْ ثسّْقدّْسذْ، مَاحنْذْ أَذْ أَيِي إِڒِينْ ذ إِكهَّاننْ. كْسِي إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ؤُفُونَاسْ - ذ ثْنَاينْ ن وَاشْرَارنْ إِشْنَانْ قَاعْ، ");
INSERT INTO rifa_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ؤُ عَاوذْ أَغْرُومْ بْڒَا أَنْثُونْ ذ ڒمْسمْنَاثْ بْڒَا أَنْثُونْ إِخدْجْضنْ س زّشْثْ ذ ثڒْفَافْ بْڒَا أَنْثُونْ تّْوَاذهْننْثْ س زّشْثْ، ثِينِّي إِ غَا ثڭّذْ مَارَّا س وَارنْ أَزْذَاذْ ن يِيرْذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","أَذْ ثنْثْ ثڭّذْ ذڭْ إِشْثْ ن ثْسُودْجثْ ؤُشَا أَذْ ثنْثْ ثَاوْيذْ ذِي ثْسُودْجثْ جْمِيعْ أَكْ-ذ ؤُفُونَاسْ أَمژْيَانْ ذ ثْنَاينْ ن إِشَارِّييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","أَذْ د-ثسّْقَارّْبذْ هَارُونْ ذ وَارَّاوْ نّسْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ ثنْ ثسِّيرْذذْ س وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","أَذْ ثكْسِيذْ أَرُّوضْ، أَذْ ثْيَارْضذْ هَارُونْ ثْشَامِيرْ ذ ؤُسڒْحَامْ إِ ؤُپَالْطُو ذ ؤُپَالْطُو سِيمَانْثْ نّسْ ذ ثجْمشْثْ ؤُشَا أَذْ أَسْ ثْبيْسذْ س ثْحزَّامْثْ إِزوّْقنْ ن ؤُپَالْطُو. ");
INSERT INTO rifa_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","أَذْ ثسَّارْسذْ أَرژّثْ خْ ؤُزدْجِيفْ نّسْ ؤُ خْ أَرژّثْ أَذْ ثڭّذْ تَّاجْ إِقدّْسنْ ن وعْزَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","أَذْ ثكْسِيذْ زّشْثْ إِ وذْهَانْ ؤُشَا أَذْ ت ثْزدْجْعذْ خْ ؤُزدْجِيفْ نّسْ ؤُشَا أَذْ ث ثْذهْنذْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","خنِّي أَذْ ثَاوْيذْ إِحنْجِيرنْ نّسْ، أَذْ أَسنْ ثْيَارْضذْ ثْشَامِيرَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","أَذْ أَسنْ ثْبيْسذْ س ثْحزَّامْثْ، إِ هَارُونْ ذ وَارَّاوْ نّسْ، ؤُشَا أَذْ أَسنْ ثَاركّْبذْ ثِيشُوشَّايْ. أَذْ غَارْسنْ ثِيڒِي ثُوكهَّانْثْ عْلَاحْسَابْ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا. أَذْ ثَاڒقّْمذْ هَارُونْ ذ وَارَّاوْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","خنِّي أَذْ ثَاوْيذْ أَفُونَاسْ أَمژْيَانْ زَّاثْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُ هَارُونْ ذ وَارَّاوْ نّسْ أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن ؤُفُونَاسْ أَمژْيَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","أَذْ ثْغَارْصذْ إِ ؤُفُونَاسْ أَمژْيَانْ زَّاثْ إِ وُوذمْ ن سِيذِي، غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","خنِّي أَذْ ثكْسِيذْ إِذَامّنْ ن ؤُفُونَاسْ أَمژْيَانْ ؤُشَا أَذْ ثنْ ثڭّذْ س ؤُضَاضْ نّشْ خْ وَاشَّاونْ ن ؤُعَالْطَارْ ؤُشَا أَذْ ثْزدْجْعذْ مَارَّا إِذَامّنْ إِقِّيمنْ غَارْ إِضَارنْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","أَذْ ثكْسِيذْ عَاوذْ مَارَّا ثَاذُونْثْ نِّي إِذْڒِينْ أَذَانْ ذ مِينْ يُويْڒنْ غَارْ ثْسَا، ذ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ ؤُشَا أَذْ ثسّْبخَّارذْ أَيَا خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","مَاشَا أَيْسُومْ ن ؤُفُونَاسْ أَمژْيَانْ ذ يِيڒمْ نّسْ ذ ؤُمسَّاڒْ نّسْ أَذْ ثنْ ثسّْشمْضذْ س ثْمسِّي بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ، أَقَا ذ ثَاغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","خنِّي أَذْ ثكْسِيذْ إِجّْ ن ؤُشَارِّي ؤُشَا هَارُونْ ذ وَارَّاوْ نّسْ أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن إِشَارِّي. ");
INSERT INTO rifa_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","أَذْ ثْغَارْصذْ إِ إِشَارِّي ؤُشَا أَذْ ثكْسِيذْ إِذَامّنْ نّسْ، أَذْ ثنْ ثْزدْجْعذْ خْ ؤُعَالْطَارْ زِي مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","أَذْ ثبْضِيذْ إِشَارِّي ذ إِشدْجِيقنْ، أَذْ ثسِّيرْذذْ أَذَانْ نّسْ ذ إِشكْرَاذْ نّسْ ؤُشَا أَذْ ثنْ ثڭّذْ خْ إِشدْجِيقنْ نّسْ ؤُ خْ ؤُزدْجِيفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","أَذْ ثسِّيغذْ إِ إِشَارِّي أَمْ إِكْمڒْ خْ ؤُعَالْطَارْ، أَقَا ذ ثَاغَارْصْثْ ن وشْمَاضْ إِ سِيذِي، إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ، أَقَا ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","خنِّي أَذْ ثكْسِيذْ إِشَارِّي نّغْنِي ؤُشَا هَارُونْ ذ وَارَّاوْ نّسْ أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن إِشَارِّي. ");
INSERT INTO rifa_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","أَذْ ثْغَارْصذْ إِ إِشَارِّي ؤُشَا أَذْ ثكْسِيذْ زڭْ إِذَامّنْ نّسْ ؤُشَا أَذْ ثڭّذْ مَانْ أَيَا خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن هَارُونْ ؤُ خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن وَارَّاوْ نّسْ ؤُ عَاوذْ خْ ؤُضَاضْ ن يِيمزْ ن ؤُفُوسْ نْسنْ أَفُوسِي ؤُ خْ ؤُضَاضْ ن يِيمزْ ن ؤُضَارْ نْسنْ أَفُوسِي ؤُشَا أَذْ ثْزدْجْعذْ إِضَامّنْ إِقِّيمنْ خْ ؤُعَالْطَارْ زِي كُوڒْ جِّيهثْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","خنِّي أَذْ ثكْسِيذْ زڭْ إِذَامّنْ نِّي إِدْجَانْ خْ ؤُعَالْطَارْ ؤُ زِي زّشْثْ إِ وذْهَانْ ؤُشَا أَذْ زَّايْسنْ ثْرُوشّذْ هَارُونْ ذ وَارُّوضْ نّسْ ؤُشَا أَذْ ثْرُوشّذْ عَاوذْ أَرَّاوْ نّسْ ذ أَرُّوضْ ن وَارَّاوْ نّسْ أَكِيذسْ، حِيمَا أَذْ يِيڒِي إِتّْوَاقدّسْ، نتَّا ذ أَرُّوضْ نّسْ، ؤُڒَا ذ ثَارْوَا نّسْ ذ أَرُّوضْ ن ثَارْوَا نّسْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","أَذْ ثكْسِيذْ ثَاذُونْثْ ن إِشَارِّي ڒَا ذ ثَاذُونْثْ غَارْ ؤُنوَّارْ ڒَا ثَاذُونْثْ نِّي إِذْڒِينْ أَذَانْ، ؤُڒَا مِينْ يُويْڒنْ غَارْ ثْسَا ذ ثْنَاينْ ن ثِيژَّاڒْ س ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ ذ أَشكْرُوذْ أَفُوسِي، مِينْزِي وَا ذ إِشَارِّي إِ ؤُذشّنْ ن إِكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","كْسِي عَاوذْ إِشْثْ ن ثشْنِيفْثْ ن وغْرُومْ ذ إِشْثْ ن ثمْسمّنْثْ ن وغْرُومْ إِتّْوَاسّْوجْذنْ س زّشْثْ ذ إِشْثْ ن ثڒْففْثْ زِي ثْسُودْجثْ ن وغْرُومْ بْڒَا أَنْثُونْ إِ إِدْجَانْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","سَارْسْ مَانْ أَيَا مَارَّا خْ إِفَاسّنْ ن هَارُونْ ؤُ خْ إِفَاسّنْ ن وَارَّاوْ نّسْ ؤُشَا أَذْ ثنْ ثسّنْهزّذْ زِي سَّا غَارْ ذَا أَمْ إِشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","أَوَارْنِي أَسْ أَذْ ت ثكْسِيذْ زڭْ إِفَاسّنْ نْسنْ ؤُشَا أَذْ ت ثسّْبخَّارذْ خْ ؤُعَالْطَارْ، خْ ثْغَارْصْثْ ن وشْمَاضْ، أَذْ ثِيڒِي ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ زَّاثْ إِ وُوذمْ ن سِيذِي. أَقَا-ت ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","أَذْ ثكْسِيذْ إِذْمَارنْ ن إِشَارِّي إِ ؤُذشّنْ ن هَارُونْ ؤُشَا أَذْ ثنْ ثسّنْهزّذْ زِي سَّا غَارْ ذَا أَمْ إِشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ثَانِيثَا أَذْ ثِيڒِي ذ ثَاسْغَارْثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","أَذْ ثسّْقدّْسذْ إِذْمَارنْ ن ثوْهِيبْثْ ن ونْهزِّي إِ إِتّْوَانْهزّنْ زِي سَّا غَارْ ذَا، ؤُڒَا ذ ؤُشكْرُوذْ إِ إِتّْوَانْهزّنْ زِي سَّا غَارْ ذَا ذ ونِّي إِتّْوَاسّْڭعّْذنْ. أَقَا-ثنْ زڭْ إِشَارِّي ن ؤُذشّنْ، أَمْ زڭْ ونِّي إِ يدْجَانْ إِ هَارُونْ أَمْ زڭْ ونِّي إِ يدْجَانْ إِ وَارَّاوْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","أَيَا أَذْ يِيڒِي إِ هَارُونْ ذ وَارَّاوْ نّسْ ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا زِي جِّيهثْ ن أَيْثْ ن إِسْرَائِيل، مِينْزِي ذ ثَاوْهِيبْثْ ن ؤُسْڭعّذْ إِ ثدْجَا. أَذْ ثِيڒِي ذ إِشْثْ ن ثوْهِيبْثْ إِ غَا سّْڭعّْذنْ أَيْثْ ن إِسْرَائِيل زِي ثْغَارْصَا نْسنْ ن ڒهْنَا. أَقَا ذ ثَاوْهِيبْثْ نْسنْ ن ؤُسْڭعّذْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","أَرُّوضْ إِقدّْسنْ ن هَارُونْ أَذْ يِيڒِي إِ وَارَّاوْ نّسْ أَوَارْنِي أَسْ، مَاحنْذْ أَذْ ثنْ ذهْننْ ؤُ أَذْ ثنْ أَڒقْمنْ ذَايسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","مَانْ ونْ زڭْ إِحنْجِيرنْ نّسْ إِ غَا يِيڒِينْ ذ أَكهَّانْ ذڭْ ومْشَانْ نّسْ ؤُشَا أَذْ يَاذفْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مَاحنْذْ أَذْ إِسخَّارْ ذِي زَّاوشْثْ إِقدّْسنْ، أَذْ ث يَارْضْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","أَذْ ثكْسِيذْ إِشَارِّي إِ ؤُذشّنْ ؤُشَا أَذْ ثسّنْڭْوذْ أَيْسُومْ نّسْ ذڭْ إِجّْ ن ومْشَانْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","هَارُونْ ذ وَارَّاوْ نّسْ أَذْ شّنْ أَيْسُومْ ن إِشَارِّي ذ وغْرُومْ إِ إِدْجَانْ ذِي ثْسُودْجثْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","أَذْ شّنْ زِي مِينْ زِي إِتّْوَاڭّْ وسْڒَاحْ، حِيمَا أَذْ ثنْ ڒقّْمنْ ؤُ أَذْ ثنْ سّْقدّْسنْ. مَاشَا إِجّْ ن ؤُبَارَّانِي وَارْ زَّايسْ إِتّتّْ، مِينْزِي أَقَا ذ إِشْثْ ن ڒْحَاجّثْ ذ ثَامْقدّسْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","مَاڒَا إِشطّْ شَا زڭْ ويْسُومْ ن ثْغَارْصَا إِ ؤُذشّنْ نِيغْ زڭْ وغْرُومْ أَڒْ صّْبحْ، أَذْ ثسّْشمْضذْ مِينْ إِشطّنْ ذِي ثْمسِّي. إِتّْخصَّا وَارْ ث إِتّتّْ حذْ، مِينْزِي ذ إِشْثْ ن ڒْحَاجّثْ إِقدّْسنْ إِ يدْجَا. ");
INSERT INTO rifa_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","أَمُّو إِ غَا ثڭّذْ أَكْ-ذ هَارُونْ ؤُ أَكْ-ذ وَارَّاوْ نّسْ، أَذْ ثڭّذْ عْلَاحْسَابْ مَارَّا مِينْ ذ أَشْ وصِّيغْ. أَذْ ثنْ ثَاڒقّْمذْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","كُوڒْ أَسّْ أَذْ ثسّْوجْذذْ أَفُونَاسْ أَمژْيَانْ ذ ثَاغَارْصْثْ ن دّنْبْ إِ وصْڒَاحْ ؤُشَا أَذْ ثكّْسذْ دّنْبْ خْ ؤُعَالْطَارْ ؤُمِي خَاسْ غَا ثسِّيوْضذْ أَصْڒَاحْ، ؤُشَا خنِّي أَذْ ث ثْذهْنذْ، مَاحنْذْ أَذْ ث ثسّْقدّْسذْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","سبْعَا ن وُوسَّانْ أَذْ ثڭّذْ أَصْڒَاحْ خْ ؤُعَالْطَارْ ؤُشَا أَذْ ث ثسّْقدّْسذْ، خنِّي أَذْ يِيڒِي ذ أَمْقدَّاسْ قَاعْ. ونِّي إِ غَا إِحَاذَانْ أَعَالْطَارْ، أَذْ يِيڒِي ذ أَمْقدَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ذ مَانْ أَيَا إِ غَا ثسّْوجْذذْ خْ ؤُعَالْطَارْ: ثْنَاينْ ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ، كُوڒْ أَسّْ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","أَذْ ثسّْوجْذذْ إِجّْ ن يزْمَارْ ذِي صّْبحْ ؤُ إِزْمَارْ نّغْنِي أَذْ ث ثسّْوجْذذْ جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","إِ يِيجّْ ن يزْمَارْ أَذْ ثكْسِيذْعشْرَا ذِي ثسْغَارْثْ ن إِجّْ ن إِفَا ن وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ دّْزنْ ت-إِ-د زِي زِّيثُونْ، ؤُ أَربْعَا ذِي ثسْغَارْثْ ن إِجّْ ن ؤُهِينُو ن بِينُو ذ ثَاوْهِيبْثْ ن ؤُسيّبْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","أَذْ ثْغَارْصذْ إِ يزْمَارْ نّغْنِي جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ. أَذْ غَارسْ ثَارْنِيذْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ أَمْ مَامّشْ ثنِّي ن صّْبحْ ؤُ عَاوذْ ثَاوْهِيبْثْ نّسْ ن ؤُسيّبْ. أَقَا ذ ڒفْوَاحثْ إِتّْفُوحنْ. أَقَا ذ ثَاوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","أَذْ ثِيڒِي ذ ثَاغَارْصْثْ ن وشْمَاضْ ڒبْذَا ذِي مَارَّا جِّيڒَاثْ نْومْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ زَّاثْ إِ وُوذمْ ن سِيذِي، مَانِي غَا سّْمُونغْ أَكِيذْومْ، مَاحنْذْ أَذْ كِيذكْ سِّيوْڒغْ ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","أَذْ مّْسَاڭَارغْ ذِينْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، ؤُ أَقِيضُونْ أَذْ إِتّْوَاقدّسْ س ؤُعُودْجِي إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","أَذْ سّْقدّْسغْ أَقِيضُونْ ن ؤُمْسَاڭَارْ ذ ؤُعَالْطَارْ. أَذْ سّْقدّْسغْ عَاوذْ هَارُونْ ذ وَارَّاوْ نّسْ، حِيمَا أَذْ أَيِي إِڒِينْ ذ إِكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","أَذْ زذْغغْ ذِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل، أَذْ أَسنْ إِڒِيغْ ذ أَربِّي ");
INSERT INTO rifa_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ؤُشَا أَذْ سّْننْ بلِّي نشّْ ذ سِيذِي، أَربِّي نْسنْ، ونِّي ثنْ إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، مَاحنْذْ أَذْ زذْغغْ ذِي ڒْوسْطْ نْسنْ. نشّْ ذ سِيذِي، أَربِّي نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","”أَذْ ثڭّذْ عَاوذْ أَعَالْطَارْ ن ڒبْخُورْ. أَذْ ث ثڭّذْ زڭْ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا. ");
INSERT INTO rifa_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ثُوزّڭَّارْثْ أَذْ ثِيڒِي ذ إِجّنْ ؤُغِيڒْ، ؤُ ثِيرُو عَاوذْ ذ إِجّنْ ؤُغِيڒْ. أَذْ يِيڒِي ؤُعَالْطَارْ س أَربْعَا ن ثْغمُّورَا. ڒُْوعْڒَا نّسْ أَذْ يِيڒِي ذ ثْنَاينْ ن إِغَادْجنْ ؤُ أَشَّاونْ نّسْ أَذْ إِڒِينْ ذ إِجّنْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","أَذْ ث ثْغدْجْفذْ س وُورغْ إِصْفَانْ، ؤُذمْ نّسْ ن سنّجْ ذ إِغزْذِيسنْ نّسْ إِ ذ أَسْ د-إِنّْضنْ ذ وَاشَّاونْ نّسْ. أَذْ أَسْ ثڭّذْ إِجّْ ن زّْوَاقْ ن وُورغْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","أَذْ أَسْ ثڭّذْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ سَاذُو زّْوَاقْ نّسْ. أَذْ ثنْثْ ثڭّذْ غَارْ ثْنَاينْ ن إِغزْذِيسنْ نّسْ، غَارْ ثْنَاينْ ن ثْغمَّارْ نّسْ. أَذْ إِڒِينْثْ إِ إِعُومَاذْ، حِيمَا أَذْ زَّايْسنْ أَرْبُونْ أَعَالْطَارْ ن ڒبْخُورْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","أَذْ ثڭّذْ ثْنَاينْ ن إِعُومَاذْ إِ ثَاربُّوثْ زڭْ ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا أَذْ ثنْ ثْغدْجْفذْ س وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","أَذْ ث ثسَّارْسذْ زَّاثْ إِ ؤُڒحَّافْ إِ إِدْجَانْ زَّاثْ إِ تَّابُوثْ ن شّْهَاذثْ، زَّاثْ إِ ثْقبَّارْثْ ن وصْڒَاحْ ثنِّي إِدْجَانْ خْ شّْهَاذثْ، مَانِي كِيكْ إِ غَا مّْسَاڭَارغْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","أَذْ إِسّْبخَّارْ هَارُونْ ڒبْخُورْ إِتّْفُوحنْ كُوڒْ صّْبحْ. أَوَارْنِي ڒَامِي إِعْذڒْ ثِيفْثِيڒِينْ، أَذْ إِسّْبخَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","مڒْمِي إِ غَا إِسِّيرغْ هَارُونْ ثِيفْثِيڒِينْ جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ، أَذْ يجّْ ڒبْخُورْ أَذْ إِبخَّارْ. أَذْ يِيڒِي ذ إِجّْ ن ڒبْخُورْ إِ ڒبْذَا زَّاثْ إِ وُوذمْ ن سِيذِي إِ مَارَّا جِّيڒَاثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","كنِّيوْ وَارْ خَاسْ ثسّْڭعّْذمْ شَا ڒبْخُورْ ذ أَغْرِيبْ، نِيغْ ثَاغَارْصْثْ ن وشْمَاضْ نِيغْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ؤُ وَارْ خَاسْ تّْزدْجَاعمْ ثَاوْهِيبْثْ ن ؤُسيّبْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","هَارُونْ أَذْ إِڭّْ أَصْڒَاحْ خْ وَاشَّاونْ نّسْ إِشْثْ ن ثْوَاڒَا ذڭْ ؤُسڭّْوَاسْ س إِذَامّنْ ن ثْغَارْصَا ن دّنْبْ إِ وصْڒَاحْ. أَذْ ث إِسّصْڒحْ إِشْثْ ن ثْوَاڒَا ذڭْ ؤُسڭّْوَاسْ إِ مَارَّا جِّيڒَاثْ نْومْ. أَقَا-ث ذ أَمْقدَّاسْ قَاعْ إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","”خْمِي غَا ثكْسِيذْ ڒْقدّْ ن أَيْثْ ن إِسْرَائِيل، ڒْقدّْ ن يِينِّي إِتّْوَاحسْبنْ، خنِّي نِيثْنِي أَذْ وْشنْ، كُوڒْ إِجّْ إِ يِيخفْ نّسْ، تَّامَانْ ن وصْڒَاحْ إِ سِيذِي غَارْ ؤُسذِّي نْسنْ، حِيمَا وَارْ ثتِّيڒِي جّْرِيحشْثْ جَارْ أَسنْ خْ مِينِّي ثنْ غَا ثْحسْبذْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ذ مَانْ أَيَا إِ غَا وْشنْ نِيثْنِي، كُوڒْ إِجّْ زڭْ إِنِّي غَا إِژْوَانْ غَارْ يِينِّي إِتّْوَاحسْبنْ: أَزْينْ شِيقْلُو عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ - شِيقْلُو-يَا ذ عِيشْرِينْ جِيرَا - أَزْينْ شِيقْلُو-يَا أَذْ يِيڒِي ذ ثَاوْهِيبْثْ ن ؤُسْڭعّذْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","كُوڒْ إِجّْ زڭْ إِنِّي غَا إِژْوَانْ غَارْ يِينِّي إِتّْوَاحسْبنْ، زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، أَذْ إِسّْڭعّذْ ثَاوْهِيبْثْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","بُو-وَاڭْڒَا وَارْ إِتِّيشْ كْثَارْ ؤُ أَمزْڒُوضْ وَارْ إِسّنْقِيسْ زڭْ وزْينْ شِيقْلُو، خْمِي غَا ثسّْڭعّْذمْ ثَاوْهِيبْثْ ن سِيذِي إِ وصْڒَاحْ ن ڒعْمُورْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","أَذْ ثكْسِيذْ نُّوقَارْثْ إِ وصْڒَاحْ ن أَيْثْ ن إِسْرَائِيل ؤُشَا أَذْ ت ثْفَارْزذْ إِ ثْسخَّارْثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. أَذْ ثِيڒِي ذ ڒِيذَارثْ إِ أَيْثْ ن إِسْرَائِيل زَّاثْ إِ وُوذمْ ن سِيذِي إِ وصْڒَاحْ ن ڒعْمُورْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","”أَذْ ثڭّذْ عَاوذْ ثْبَانْيُوثْ ن نّْحَاسْ إِ ؤُسِيرْذْ، أَكْ-ذ ؤُضَارْ ن نُّوقَارْثْ نّسْ إِ خْ ت غَا سَّارْسنْ، مَاحنْذْ أَذْ سِّيرْذنْ إِخفْ نْسنْ. أَذْ ت ثسَّارْسذْ جَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ذ ؤُعَالْطَارْ ؤُشَا أَذْ ذَايسْ ثڭّذْ أَمَانْ، ");
INSERT INTO rifa_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","مَاحنْذْ هَارُونْ ذ وَارَّاوْ نّسْ أَذْ زَّايسْ سِّيرْذنْ إِفَاسّنْ نْسنْ ذ إِضَارنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","خْمِي غَا يَاذْفنْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ أَذْ سِّيرْذنْ س وَامَانْ حِيمَا وَارْ تّْمتِّينْ شَا، ؤُڒَا خْمِي د غَا قَارّْبنْ غَارْ ؤُعَالْطَارْ، مَاحنْذْ أَذْ سخَّارنْ خْمِي غَا سّْبخَّارنْ ثَاوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","خنِّي أَذْ سِّيرْذنْ إِفَاسّنْ نْسنْ ذ إِضَارنْ نْسنْ حِيمَا وَارْ تّْمتِّينْ شَا. مَانْ أَيَا أَذْ أَسنْ يِيڒِي ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا، إِ نتَّا ؤُ إِ زَّارِيعثْ نّسْ، إِ مَارَّا جِّيڒَاثْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","”شكْ، كْسِي ڒخُّو غَاركْ ڒعْطُورْ إِشْنَانْ أَطَّاسْ: خمْسْ-مْيَا شِيقْلُو ن مِيرُّو يُوزّْڒنْ أَكْ-ذ ڒْقدّْ ن وزْينْ ن مَانَاونِّي، أَقَا-ث ذ مِيثَاينْ ؤُ-خمْسِينْ شِيقْلُو زِي ڒْقَارْفَا إِتّْفُوحنْ ؤُ مِيثَاينْ ؤُ-خمْسِينْ شِيقْلُو زڭْ ؤُغَانِيمْ ؤُحمُّومْ إِتّْفُوحنْ، ");
INSERT INTO rifa_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","خمْسَا-مْيَا شِيقْلُو ن قَاسِّييَا إِوزّْننْ عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ، ذ إِجّْ ن ؤُهِينُو ن زّشْثْ ن زِّيثُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","أڭّْ زَّايْسنْ إِشْثْ ن زّشْثْ ثَامْقدَّاسْثْ إِ وذْهَانْ، إِجّْ ن ڒعْطُورْ إِخدْجْضنْ عْلَاحْسَابْ صّنْعثْ ن ؤُعطَّارْ. أَيَا أَذْ يِيڒِي ذ إِشْثْ ن زّشْثْ ثَامْقدّسْثْ إِ وذْهَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","س مَانْ أَيَا أَذْ ثْذهْنذْ أَقِيضُونْ ن ؤُمْسَاڭَارْ، تَّابُوثْ ن شّْهَاذثْ، ");
INSERT INTO rifa_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ثَازوْضَا أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ ذ ڒْقنْذِيڒْ أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ ذ ؤُعَالْطَارْ ن ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ذ ؤُعَالْطَارْ ن وشْمَاضْ أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ ذ ثْبَانْيُوثْ أَكْ-ذ ؤُضَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","أَذْ ثسّْقدّْسذْ مَارَّا أَيَا، حِيمَا أَذْ يِيڒِي ذ أَمْقدَّاسْ قَاعْ. مَارَّا وِي غَا إِحَاذَانْ زِي مَانْ أَيَا، أَذْ إِتّْوَاقدّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","أَذْ ثْذهْنذْ هَارُونْ ذ وَارَّاوْ نّسْ ؤُشَا أَذْ ثنْ ثسّْقدّْسذْ، حِيمَا أَذْ أَيِي إِڒِينْ ذ إِكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","أَذْ ثسِّيوْڒذْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا أَذْ ثِينِيذْ: ’ثَا أَذْ ثِيڒِي ذ إِشْثْ ن زّشْثْ ثَامْقدَّاسْثْ إِ وذْهَانْ إِ نشّْ ذِي مَارَّا جِّيڒَاثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","وَارْ إِعدّڒْ أَذْ ت فَارّْغنْ خْ أَرِّيمثْ ن بْنَاذمْ، ؤُ مَامّشْ ثدْجَا وَارْ زَّايسْ تّڭّمْ ؤُتْشْمَاسْ. ثَامْقدَّاسْثْ إِ ثدْجَا ؤُشَا أَذْ ثِيڒِي ذ ثَامْقدَّاسْثْ إِ كنِّيوْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ونِّي إِ غَا إِسّْوجْذنْ س ڒبْزَارْ إِشْثْ ن زّشْثْ ن وذْهَانْ أَمْ ثَانِيثَا ؤُشَا أَذْ زَّايسْ ثْمسْحذْ خْ يِيجّْ ن ؤُبَارَّانِي، أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","إِنَّا سِيذِي إِ مُوسَا: ”كْسِي إِ يِيخفْ نّشْ ڒبْزَارْ إِتّْفُوحنْ: ثُوذِّيمِينْ ن ؤُسرْغَاغْ ذ وقْشُورْ ن ثْشجَّارْثْ ن ڒْقَارْفَا ذ غَالْبَا، ڒبْزَارْ إِتّْفُوحنْ ذ جَّاوِي إِصْفَانْ. أَذْ يِيڒِي ڒْقدّْ نّسْ أَمْ ڒْقدّْ ن ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","أڭّْ زَّايسْ إِجّْ ن ڒعْطُورْ، إِجّْ ن ؤُخدْجضْ أَمْ ثنِّي إِڭَّا ؤُعطَّارْ: إِتّْوَامدْجذْ، إِصْفَا، إِقدّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","حْرِي-د زَّايسْ ثَانغْذَا ثَازْذَاذْثْ ؤُشَا سَارْسْ شَا زَّايسْ زَّاثْ إِ شّْهَاذثْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ مَانِي أَكِيذكْ غَا مْسَاڭَارغْ. أَذْ أَومْ ثِيڒِي ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ڒعْثُورْ نِّي إِ غَا ثڭّذْ، وَارْ ث تّڭّمْ س ؤُخدْجضْ ذ إِجّنْ أَكِيذسْ إِ يِيخفْ نْومْ. أَذْ يِيڒِي ذ أَمْقدَّاسْ إِ شكْ، أَذْ يِيڒِي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ونِّي إِ إِڭِّنْ شَا أَمْ وَانِيثَا ؤُشَا أَذْ ث إِشمّْ، أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","”خْزَارْ، نشّْ ڒَاغِيغْ-د خْ بَاصَالِييِيلْ، مِّيسْ ن ؤُرِي، مِّيسْ ن حُورْ، زِي ثقْبِيتْشْ ن يَاهُوذَا س يِيسمْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","شُّورغْ ث س أَرُّوحْ ن أَربِّي، س ثِيغِيثْ، س ڒعْقڒْ، س ثُوسّْنَا ؤُ س مَارَّا مِينْ إِتّْخصَّانْ ن ثْزمَّارْ ن صّْنَايعْ، ");
INSERT INTO rifa_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","حِيمَا أَذْ إِخمّمْ إِرقَّامنْ س لْفنّْ، مَاحنْذْ أَذْ ثنْ تّڭّنْ س وُورغْ ذ نُّوقَارْثْ ذ نّْحَاسْ، ");
INSERT INTO rifa_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ؤُ حِيمَا أَذْ نقْشنْ إِژْرَا إِغْڒَانْ مَاحنْذْ أَذْ ثنْ ڭّنْ ذِي ثْشُويَارْ نْسنْ، ؤُ حِيمَا أَذْ نقْشنْ أَكشُّوضْ، حِيمَا أَمُّو إِ غَا ڭّنْ مَارَّا ڒْخذْمثْ. ");
INSERT INTO rifa_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","أَقَا نشّْ ڭِّيغْ أَكِيذسْ أَهُولِييَابْ، مِّيسْ ن أَخِيسَامَاكْ، زِي ڒَادْجْ ن دَان. ذڭْ وُوڒْ ن مَارَّا إِنِّي غَارْ إِدْجَا وُوڒْ ذ أَمِيغِيسْ، ڭِّيغْ ثِيغِيثْ. نِيثْنِي أَذْ ڭّنْ مَارَّا مِينْ خفْ وصِّيغْ: ");
INSERT INTO rifa_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","أَقِيضُونْ ن ؤُمْسَاڭَارْ، تَّابُوثْ ن شّْهَاذثْ، ثَاقبَّارْثْ ن وصْڒَاحْ نِّي خَاسْ إِدْجَانْ، ؤُ مَارَّا ڒقْشُوعْ ن ؤُقِيضُونْ: ");
INSERT INTO rifa_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ثَازوْضَا أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ، ذ ڒْقنْذِيڒْ إِصْفَانْ س مَارَّا ڒقْشُوعْ نّسْ ذ ؤُعَالْطَارْ ن ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","أَعَالْطَارْ ن وشْمَاضْ أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ ذ ثْبَانْيُوثْ س ؤُضَارْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","أَرُّوضْ ن ثْسخَّارْثْ ذ وَارُّوضْ إِقدّْسنْ ن هَارُونْ، أَكهَّانْ، ذ وَارُّوضْ ن وَارَّاوْ نّسْ، مَاحنْذْ أَذْ سخَّارنْ أَمْ ؤُكهَّانْ، ");
INSERT INTO rifa_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ذ زّشْثْ إِ وذْهَانْ، ذ ڒبْخُورْ إِتّْفُوحنْ إِ زَّاوشْثْ إِقدّْسنْ. عْلَاحْسَابْ مَارَّا مِينْزِي شكْ ؤُمُورغْ أَذْ ڭّنْ مَارَّا أَيَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","”شكْ، سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي: ’أَذْ ثحْضَامْ ؤُسَّانْ ن سّبْثْ إِنُو، مِينْزِي سّبْثْ ذ ڒعْڒَامثْ جَارْ أَيِي ذ كنِّيوْ، إِ مَارَّا جِّيڒَاثْ نْومْ، حِيمَا أَذْ ثسّْنمْ بلِّي نشّْ ذ سِيذِي، ونِّي كنِّيوْ إِسّْقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","حْضَامْ أَسّْ ن سّبْثْ، مِينْزِي إِقدّسْ إِ إِدْجَا إِ كنِّيوْ! ونِّي ث غَا إِسّْفسْذنْ، أَذْ ث نْغنْ نِيشَانْ، مِينْزِي مَانْ ونْ إِ ذَايسْ غَا إِڭّنْ شَا ن ڒْخذْمثْ، أَذْ إِتّْوَاقْضعْ زِي ڒْوسْطْ ن ڒْڭنْسْ نّسْ.    ");
INSERT INTO rifa_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ستَّا ن وُوسَّانْ أَذْ ثڭّذْ ڒْخذْمثْ ؤُشَا ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ يِيڒِي ذ سّبْثْ، أَرَّاحثْ ثْمُونْ، ثْقدّسْ إِ ثدْجَا إِ سِيذِي! كُوڒْ إِجّْ، ونِّي إِڭِّنْ شَا ن ڒْخذْمثْ ذڭْ وَاسّْ ن سّبْثْ، أَذْ ث نْغنْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","أَيْثْ ن إِسْرَائِيل أَذْ حْضَانْ أَسّْ ن سّبْثْ، أَذْ حْضَانْ سّبْثْ ذِي مَارَّا جِّيڒَاثْ نْسنْ أَمْ إِجّْ ن ڒْعَاهْذْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","أَذْ ثِيڒِي ذ إِشْثْ ن ڒعْڒَامثْ جَارْ أَيِي ذ أَيْثْ ن إِسْرَائِيل، مِينْزِي ذِي ستَّا ن وُوسَّانْ إِڭَّا سِيذِي أَجنَّا ذ ثمُّورْثْ ؤُ ذڭْ وَاسّْ وِيسّْ سبْعَا يَاريّحْ، يَارَّا نّفْسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ڒَْامِي إِكمّڒْ سِيذِي أَوَاڒْ إِ كِيذسْ إِسِّيوْڒنْ خْ وذْرَارْ ن سِينَا، إِوْشَا إِ مُوسَا ثْنَاينْ ن ثڒْوِيحِينْ ن شّْهَاذثْ. ثُوغَا ثِيڒْوِيحِينْ نِّي زڭْ وژْرُو، تّْوَارِينْثْ س ؤُضَاضْ ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ڒَْامِي إِژْرَا ڒْڭنْسْ بلِّي مُوسَا إِعطَّاڒْ، وَارْ د-إِهْوِي عَاذْ زڭْ وذْرَارْ، إِنّيْرُو-د ڒْڭنْسْ غَارْ هَارُونْ، نَّانْ أَسْ: ”كَّارْ، أڭّْ أَنغْ إِربِّيثنْ، إِنِّي إِ غَا يُويُورنْ زَّاثْنغْ، مِينْزِي مُوسَا أَيَا، أَرْيَازْ نِّي ذ أَنغْ د-إِسُّوفّْغنْ زِي مِيصْرَا، وَارْ نسِّينْ مِينْ ث يُوغِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","هَارُونْ إِنَّا أَسنْ: ”قڒْعمْ ثِيخْرَازِينْ ن وُورغْ نِّي إِدْجَانْ ذڭْ إِمجَّانْ ن ثمْغَارِينْ نْومْ ؤُ ن إِحنْجِيرنْ نْومْ ؤُڒَا ن يسِّيثْومْ، أَوْيمْ ثنْثْ-إِ-د غَارِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","إِكّسْ مَارَّا ڒْڭنْسْ ثِيخْرَازِينْ ن وُورغْ نِّي إِدْجَانْ ذڭْ إِمجَّانْ نْسنْ ؤُشَا إِوْينْ أَسْ ثنْثْ-إِ-د غَارْ هَارُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","نتَّا إِكْسِي ثنْثْ زڭْ إِفَاسّنْ نْسنْ ؤُشَا إِشكّڒْ إِ-ثنْثْ س إِميْذِي، إِڭَّا زَّايْسنْثْ إِجّْ ن ؤُعجْمِي ن ؤُفسِّي. ڒخْذنِّي نَّانْ: ”أَ إِسْرَائِيل، وَا ذ أَربِّي نّشْ، ونِّي شكْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ڒَْامِي إِژْرَا هَارُونْ أَيَا، إِبْنَا إِجّْ ن ؤُعَالْطَارْ زَّاثْ إِ ؤُعجْمِي ؤُشَا إِڒَاغَا هَارُونْ، إِنَّا: ”ثِيوشَّا أَذْ يِيڒِي ذ ڒْعِيذْ إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ثِيوشَّا نّسْ كَّارنْ زِيشْ ؤُشَا سّْبخَّارنْ ثِيغَارْصَا ن وشْمَاضْ ؤُشَا قدّْمنْ أَكِيذْسنْثْ عَاوذْ ثِيغَارْصَا ن ڒهْنَا. خنِّي إِقِّيمْ ڒْڭنْسْ، إِشَّا، إِسْوَا، إِكَّارْ، مَاحنْذْ أَذْ يڭّْ ڒفْرَايجْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","خَاسْ ؤُشَا إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا: ”ؤُيُورْ، هْوَا، مِينْزِي ڒْڭنْسْ نّشْ، ونِّي د-ثسُّوفّْغذْ زِي ثمُّورْثْ ن مِيصْرَا، أَقَا إِڭَّا مِينْ وَارْ إِحْڒِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","أَقَا فّْغنْ ذغْيَا خْ وبْرِيذْ نِّي خْ ثنْ وصِّيغْ. ڭِّينْ إِجّْ ن ؤُعجْمِي ن ؤُفسِّي إِ يِيخفْ نْسنْ ؤُشَا بنْذْقنْ أَسْ، قدّْمنْ أَسْ ثِيغَارْصَا ؤُشَا نَّانْ: ’أَ إِسْرَائِيل، وَانِيثَا ذ أَربِّي نّشْ، ونِّي شكْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","إِنَّا سِيذِي إِ مُوسَا: ”نشّْ ژْرِيغْ ڒْڭنْسْ-أَ، خْزَارْ، أَقَا-ث ذ إِجّْ ن ڒْڭنْسْ إِقْسحْ! ");
INSERT INTO rifa_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ڒخُّو أجّْ أَيِي أَذْ رَاحغْ، أَذْ أَرغْ أَغْضَابْ إِنُو خَاسنْ ؤُشَا أَذْ ثنْ ثحِّيغْ، ؤُ نشّْ أَذْ شكْ أَرّغْ ذ إِجّْ ن ڒْڭنْسْ إِمْغَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","مَاشَا مُوسَا إِزَاوْڭْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَربِّي نّسْ، إِنَّا: ”أَ سِيذِي، مَايمِّي غَا يَارغْ وغْضَابْ نّشْ خْ ڒْڭنْسْ نّشْ، ونِّي د-ثسُّوفّْغذْ زِي ثمُّورْثْ ن مِيصْرَا س يِيجّْ ن جّهْذْ إِمْغَارْ ؤُ س ؤُفُوسْ إِجهْذنْ؟ ");
INSERT INTO rifa_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","مَايمِّي سَّاوَاڒنْ إِمِيصْرِييّنْ جَارْ أَسنْ، قَّارنْ: ’نتَّا إِسُّوفّغْ إِ-ثنْ س نّيّثْ ثَاعفَّانْثْ، مَاحنْذْ أَذْ ثنْ إِنغْ خْ إِذُورَارْ ؤُ مَاحنْذْ أَذْ ثنْ إِثحَّا زڭْ وُوذمْ ن ثمُّورْثْ؟‘ ذْوڒْ خْ ڒْحَاذُوقْ ن وغْضَابْ نّشْ ؤُشَا نْذمْ خْ ثُوعفّْنَا إِ ثخْسذْ أَذْ ثَارّذْ خْ ڒْڭنْسْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","فكَّارْ ذِي إِبْرَاهِيمْ ذ إِسْحَاقْ ذ إِسْرَائِيل، إِمْسخَّارنْ نّشْ، إِنِّي ؤُمِي ثجُّودْجذْ س يِيخفْ نّشْ ؤُ ثسِّيوْڒذْ أَكِيذْسنْ: ’نشّْ أَذْ أَرْنِيغْ زَّارِيعثْ نْومْ أَمْ يِيثْرَانْ ن ؤُجنَّا ؤُشَا أَذْ وْشغْ مَارَّا ثَامُّورْثْ-أَ إِ خفْ سِّيوْڒغْ إِ زَّارِيعثْ نّشْ ؤُشَا نِيثْنِي أَذْ ت طّْفنْ ذ إِشْثْ ن ڒْوَارْثْ إِ ڒبْذَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","خنِّي إِنْذمْ سِيذِي خْ ثُوعفّْنَا إِ ثُوغَا إِنَّا أَذْ ت يڭّْ خْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ؤُشَا إِذْوڒْ-د مُوسَا، إِهْوَا-د زڭْ وذْرَارْ س ثْنَاينْ ن ثڒْوِيحِينْ ن شّْهَاذثْ ذڭْ ؤُفُوسْ نّسْ. ثِيڒْوِيحِينْ-أَ تّْوَارِينْثْ خْ ثْنَاينْ ن إِغزْذِيسنْ نْسنْثْ: تّْوَارِينْثْ خْ يِيجّْ ن ؤُغزْذِيسْ ؤُ خْ ؤُغزْذِيسْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ثِيڒْوِيحِينْ ثُوغَا أَثنْثْ ذ ڒْخذْمثْ ن أَربِّي ؤُشَا ثِيرَا نِّي إِنقْشنْ ذِي ثڒْوِيحِينْ ذ ثِيرَا ن أَربِّي. ");
INSERT INTO rifa_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","إِسْڒَا يَاشُووَا إِ ڒْحسّْ ن ڒْڭنْسْ إِسْغُويُّو ؤُشَا إِنَّا إِ مُوسَا: ”أَقَا ذَا، ڒْحسّْ ن ؤُمنْغِي ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","مَاشَا نتَّا إِنَّا: ”وَارْ إِدْجِي ذ ڒْحسّْ ن ؤُسْڒوْڒِيوْ غَارْ ڒغْڒبْ نِيغْ ذ ڒْحسّْ ن ؤُسْغُويِّي غَارْ ثْخسَّارْثْ، مَاشَا مِينْ تّسْڒِيغْ ذ ڒْحسّْ ن إِغُويَّانْ وَارْ إِحْڒِينْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ؤُشَا إِمْسَارْ، أَمْ د-إِرحّڭْ غَارْ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُشَا إِژْرَا أَعجْمِي ذ شّْضِيحْ س نُّوبْثَاثْ، يَارْغَا وغْضَابْ ن مُوسَا ؤُشَا إِنْضَارْ ثِيڒْوِيحِينْ زڭْ إِفَاسّنْ نّسْ، يَارْژَا إِ-ثنْثْ غَارْ إِضَارنْ ن وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","إِطّفْ ؤُعجْمِي نِّي ڭِّينْ، إِسّْشمْضْ إِ-ث ذِي ثْمسِّي، أَڒَامِي إِذْوڒْ ذ إِغّضْ ؤُشَا إِزُّوزَارْ إِ-ث خْ وُوذمْ ن وَامَانْ ؤُشَا يَارَّا أَيْثْ ن إِسْرَائِيل أَذْ ث سْونْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","إِنَّا مُوسَا إِ هَارُونْ: ”مِينْ زَّايكْ إِڭَّا ڒْڭنْسْ-أَ أَڒَامِي ذ أَسْ د-ثِيوْيذْ إِجّْ ن دّنْبْ ذ أَمقّْرَانْ أَطَّاسْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","هَارُونْ إِنَّا: ”وَارْ يَارقّْ وغْضَابْ ن سِيذِي إِنُو! شكْ ثسّْنذْ ڒْڭنْسْ-أَ، أَقَا-ث ذِي ڒْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","نَّانْ أَيِي: ’أڭّْ أَنغْ إِربِّيثنْ نِّي غَا يُويُورنْ زَّاثْ إِ ؤُغمْبُوبْ نّغْ، مِينْزِي مُوسَا وَانِيثَا، أَرْيَازْ ونِّي ذ أَنغْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، وَارْ نسِّينْ مِينْ ث يُوغِينْ.‘ ");
INSERT INTO rifa_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","خنِّي نِّيغْ أَسنْ: ’وِي غَارْ إِدْجَا ؤُرغْ، أَذْ ث-إِ-د-إِكّسْ، ؤُشَا أَذْ أَيِي ث يوْشْ!‘ ؤُشَا نْضَارغْ ث ذِي ثْمسِّي ؤُشَا إِفّغْ-د ؤُعجْمِي-يَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ؤُمِي إِژْرَا مُوسَا، أَقَا ڒْڭنْسْ إِذْوڒْ ذ إِمْفلّسْ، مِينْزِي هَارُونْ إِجَّا أَفلّسْ نْسنْ أَذْ إِذْوڒْ ذ ثَاضحَّاشْثْ جَارْ ڒْعذْيَانْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","إِبدّْ مُوسَا غَارْ وَاذَافْ ن ڒْمَارْڭحْ، إِنَّا: ”مَانْ ونْ إِ إِدْجَانْ إِ سِيذِي، أَسْ-د ذَا غَارِي!“ ؤُشَا مُوننْ-د غَارسْ مَارَّا إِحنْجِيرنْ ن لَاوِي. ");
INSERT INTO rifa_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","إِنَّا أَسنْ: ”أَمُّو إِ إِقَّارْ سِيذِي، أَربِّي ن إِسْرَائِيل! سَارْسمْ كُوڒْ إِجّْ سِّيفْ نّسْ خْ ثْمصَّاضْثْ نّسْ، عْذُومْ ؤُشَاعقْبمْ خْ ڒْمَارْڭحْ زڭْ وَاذَافْ غَارْ وَاذَافْ نّغْنِي ؤُشَا أَذْ إِنغْ كُوڒْ إِجّْ ؤُمَاسْ ذ كُوڒْ إِجّْ ؤُمدُّوكّڒْ نّسْ ذ كُوڒْ إِجّْ جَّارْ نّسْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ثَارْوَا ن لَاوِي ڭِّينْ عْلَاحْسَابْ أَوَاڒْ ن مُوسَا. ذڭْ وَاسّْ نِّي وْضَانْ عْڒَاحَاڒْ ثڒْثْ-أَڒَافْ ن يرْيَازنْ ن ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","مُوسَا إِنَّا: ”كْسِيمْ إِفَاسّنْ نْومْ أَسّْ-أَ غَارْ سِيذِي، كُوڒْ إِجّْ خْ مِّيسْ ؤُ خْ ؤُمَاسْ. معْلِيكْ ؤُفِيغْ نتَّا أَذْ إِبَاركْ إِ كنِّيوْ أَمُّو أَسّْ-أَ!“ ");
INSERT INTO rifa_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ثِيوشَّا نّسْ إِنَّا مُوسَا إِ ڒْڭنْسْ: ”كنِّيوْ ثڭِّيمْ إِجّْ ن دّنْبْ إِمْغَارْ. عَاذْ نشّْ أَذْ أَڒْيغْ ڒخُّو غَارْ سِيذِي، بَالَاكْ أَذْ ؤُفِيغْ أَصْڒَاحْ خْ دّنْبْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","إِذْوڒْ-د مُوسَا غَارْ سِيذِي ؤُشَا إِنَّا أَسْ: ”وَايَّاوْ، ڒْڭنْسْ-أَ إِڭَّا إِجّْ ن دّنْبْ إِمْغَارْ، مِينْزِي ڭِّينْ إِجّْ ن أَربِّي ن وُورغْ إِ يِيخفْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ڒخُّو، غْفَارْ أَسنْ إِ دّنْبْ نْسنْ! نِيغْ مْحَا أَيِي زڭْ وذْلِيسْ نّشْ إِتّْوَانّْضنْ نِّي ثُورِيذْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","إِنَّا سِيذِي إِ مُوسَا: ”ونِّي خَافِي إِخْضَانْ، ذ وَا إِ غَا مْحِيغْ زڭْ وذْلِيسْ إِنُو إِتّْوَانّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","رُوحْ ڒخُّو، أَوِي ڒْڭنْسْ-أَ غَارْ مَانِي ذ أَشْ نِّيغْ. أَقَا لْمَالَاكْ إِنُو أَذْ إِرَاحْ زَّاثْ نّشْ! ذڭْ وَاسّْ ن ؤُخدْجصْ إِنُو أَذْ أَسنْ خدْجْصغْ دّْنُوبْ نْسنْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","أَمُّو إِ إِوْثَا سِيذِي ڒْڭنْسْ، مِينْزِي ڭِّينْ أَعجْمِي نِّي إِڭَّا هَارُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا: ”رُوحْ، ڭعّذْ سَّا، شكْ ذ ڒْڭنْسْ نِّي د-ثسُّوفّْغذْ زِي ثمُّورْثْ ن مِيصْرَا، غَارْ ثمُّورْثْ نِّي خْ جُّودْجغْ إِ إِبْرَاهِيمْ ذ إِسْحَاقْ ذ يَاعْقُوبْ، نِّيغْ: ’إِ زَّارِيعثْ نّشْ أَذْ ت وْشغْ!‘ ");
INSERT INTO rifa_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","نشّْ أَذْ سّكّغْ زَّاثْ إِ ؤُغمْبُوبْ نّشْ لْمَالَاكْ، ؤُشَا أَذْ أَژّْڒغْ خْ أَيْثْ ن كنْعَانْ ذ إِمُورِييّنْ ذ إِحِيتِّييّنْ ذ إِفِيرِيزِييّنْ ذ إِحِيوِييّنْ ذ إِيِيبُوسِييّنْ ");
INSERT INTO rifa_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ذڭْ وبْرِيذْ نْومْ غَارْ إِشْثْ ن ثمُّورْثْ إِفيّْضنْ س ؤُغِي ذ ثَامّنْثْ. نشّْ س إِمَانْثْ إِنُو وَارْ تّْڭِيعِّيذغْ أَكِيذْومْ، حِيمَا وَارْ كنِّيوْ ثتّحِّيغْ ذڭْ وبْرِيذْ، مِينْزِي كنِّيوْ ذ إِجّْ ن ڒْڭنْسْ إِقْسحْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ؤُمِي إِسْڒَا ڒْڭنْسْ أَوَاڒْ-أَ أَعفَّانْ، شضْننْ ؤُشَا ؤُڒَا ذ إِجّْ إِڭَّا عَاذْ ڒهْزُوطْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","أَقَا إِنَّا سِيذِي إِ مُوسَا: ”إِنِي إِ أَيْثْ ن إِسْرَائِيل: ’كنِّيوْ ذ إِجّْ ن ڒْڭنْسْ إِقْسحْ. مَاڒَا ڭعّْذغْ جَارْ أَومْ مْغِيرْ إِجّْ ن ورْمَاشْ، أَذْ كنِّيوْ ثحِّيغْ. خنِّي ڒخُّو كّْسمْ ڒهْزُوطْ نْومْ، أَقَا نشّْ أَذْ سّْنغْ مِينْ ذ أَشْ غَا ڭّغْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","كّْسنْ أَيْثْ ن إِسْرَائِيل ڒهْزُوطْ نْسنْ زڭْ وذْرَارْ ن هُورِيبْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","إِكْسِي مُوسَا أَقِيضُونْ ؤُشَا إِوْثَا أَقِيضُونْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ، إِڭّْوجْ أَطَّاسْ خْ ڒْمَارْڭحْ، ؤُشَا إِڒَاغَا أَسْ ’أَقِيضُونْ ن ؤُمْسَاڭَارْ‘. كُوڒْ إِجّْ ونِّي ثُوغَا يَارزُّونْ سِيذِي، إِفّغْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ونِّي إِدْجَانْ بَارَّا إِ ڒْمَارْڭحْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ؤُمِي إِفّغْ مُوسَا غَارْ ؤُقِيضُونْ، إِكَّارْ مَارَّا ڒْڭنْسْ، بدّنْ بَارَّا، كُوڒْ إِجّْ غَارْ وَاذَافْ ن ؤُقِيضُونْ نّسْ، ؤُشَا نِيثْنِي خْزَارنْ غَارسْ أَمْ ثِيطَّاوِينْ نْسنْ ضفَّارنْ مُوسَا أَڒَامِي يُوذفْ غَارْ ؤُقِيضُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ؤُمِي يُوذفْ مُوسَا غَارْ ؤُقِيضُونْ، أَقَا أَقلِّيجْ ن ؤُسيْنُو إِهْوَا، إِبدّْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ؤُشَا نتَّا إِسِّيوڒْ أَكْ-ذ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ؤُشَا مَارَّا ڒْڭنْسْ إِژْرَا أَقلِّيجْ ن ؤُسيْنُو إِبدّْ غَارْ وَاذَافْ ن ؤُقِيضُونْ، خنِّي إِكَّارْ مَارَّا ڒْڭنْسْ ؤُشَا إِبنْذقْ كُوڒْ إِجّْ غَارْ وَاذَافْ ن ؤُقِيضُونْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا أَغمْبُوبْ ذڭْ ؤُغمْبُوبْ، أَمْ مَامّشْ إِسِّيوڒْ بْنَاذمْ أَكْ-ذ ؤُمدُّوكّڒْ نّسْ. خنِّي إِعْقبْ-د غَارْ ڒْمَارْڭحْ ن ڒْعسْكَارْ، مَاشَا أَمْسخَّارْ نّسْ يَاشُووَا، مِّيسْ ن نُونْ، ونِّي عَاذْ ذ أَحُوذْرِي،عمَّارْصْ وَارْ إِبعّذْ خْ ڒْوسْطْ ن ؤُقِيضُونْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","إِنَّا مُوسَا إِ سِيذِي: ”خْزَارْ، شكْ ثنِّيذْ أَيِي: ’نْذهْ ڒْڭنْسْ-أَ!‘، مَاشَا شكْ وَارْ ذ أَيِي ثسّشْنذْ وِي كِيذِي إِ غَا ثسّكّذْ. شكْ ثنِّيذْ: ’نشّْ سّْنغْ شكْ س يِيسمْ نّشْ!‘ ؤُڒَا: ’ثُوفِيذْ أَرْضَا ذِي ثِيطَّاوِينْ إِنُو!‘ ");
INSERT INTO rifa_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ڒخُّو خنِّي، مَاڒَا ؤُفِيغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، زَاوْڭغْ شكْ أَذْ أَيِي ثسّشْنذْ أَبْرِيذْ نّشْ، حِيمَا أَذْ شكْ سّْنغْ، مَاحنْذْ أَذْ أَفغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ. خْزَارْ، شّعْبْ-أَ ذ ڒْڭنْسْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","إِنَّا: ”لْمَالَاكْ ن وُوذمْ إِنُو أَذْ يُويُورْ أَكِيذكْ ؤُ نشّْ أَذْ شكْ سَّاريّْحغْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","خنِّي يَارَّا-د خَاسْ: ”مَاڒَا ؤُذمْ نّشْ وَارْ كِيذْنغْ إِتّْرِيحْ، وَارْ تّجِّي خنِّي أَذْ نْڭعّذْ سَّا! ");
INSERT INTO rifa_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","مَامّشْ غَا سّْننْ بلِّي أَقَا ؤُفِيغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، نشّْ ذ ڒْڭنْسْ نّشْ؟ مَا وَارْ إِدْجِي مِينْزِي شكْ ثْرُوحذْ أَكِيذْنغْ، أَقَا نشِّينْ، نشّْ ذ ڒْڭنْسْ نّشْ، نْفَارّزْ خْ كُوڒْ ڒْڭنْسْ إِ إِدْجَانْ خْ وُوذمْ ن ثمُّورْثْ؟“ ");
INSERT INTO rifa_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","إِنَّا سِيذِي إِ مُوسَا: ”عَاوذْ أَذْ ڭّغْ أَوَاڒْ-أَ إِ ثنِّيذْ ؤُمِي ثُوفِيذْ أَرْضَا ذِي ثِيطَّاوِينْ إِنُو ؤُشَا سّْنغْ شكْ س يِيسمْ نّشْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","خَاسْ ؤُشَا إِنَّا مُوسَا: ”زَاوْڭغْ شكْ، سْشنْ أَيِي أَعُودْجِي نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","إِنَّا: ”نشّْ أَذْ سّعْذُوغْ مَارَّا ثْشُونِي إِنُو زَّاثكْ ؤُشَا أَذْعيّْذغْ إِسمْ ن سِيذِي زَّاثْ إِ ؤُغمْبُوبْ نّشْ ؤُشَا أَذْ حِينّغْ خْ وِي غَا حِينّغْ، أَذْ أَرحْمغْ خْ وِي غَا أَرحْمغْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","إِنَّا عَاوذْ: ”شكْ وَارْ ثْزمَّارذْ أَذْ ثْژَارذْ ؤُذمْ إِنُو، مِينْزِي وَارْ ذ أَيِي إِژَارّْ بْنَاذمْ ؤُشَا أَذْ إِقِّيمْ إِدَّارْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","خَاسْ ؤُشَا إِنَّا سِيذِي: ”خْزَارْ، زَّاثْ إِنُو أَمْشَانْ مَانِي غَا ثْبدّذْ خْ ثصْضَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","خْمِي غَا إِعْذُو ؤُعُودْجِي إِنُو، أَذْ شكْ ڭّغْ ذڭْ إِجّْ ن ؤُفدْجِيقْ ن ثصْضَارْثْ ؤُشَا أَذْ شكْ ذْڒغْ س ثْڒقَّا ن ؤُفُوسْ إِنُو أَڒْ د-ژْوِيغْ. ");
INSERT INTO rifa_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ؤُ خْمِي غَا كّْسغْ أَفُوسْ إِنُو، خنِّي أَذْ أَيِي ثْژَارذْ زِي ضفَّارْ، مَاشَا وَارْ ثْژَارّذْ ؤُذمْ إِنُو!“ ");
INSERT INTO rifa_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","سِيذِي إِنَّا إِ مُوسَا: ”قسّْ إِ يِيخفْ نّشْ ثْنَاينْ ن ثڒْوِيحِينْ ن وژْرُو أَمْ ثْمزْوُورَا، ؤُشَا نشّْ أَذْ أَرِيغْ خْ ثڒْوِيحِينْ نِّي أَوَاڒنْ ذ إِجّنْ إِ ثُوغَا ذِي ثڒْوِيحِينْ ثِيمزْوُورَا إِ ثَارْژِيذْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","سوْجذْ إِ صّْبحْ ؤُشَا ڭعّذْ ذِي صّْبحْ غَارْ وذْرَارْ ن سِينَا ؤُشَا بدّْ ذِينْ زَّاثِي خْ ثْقِيشّثْ ن وذْرَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","وَارْ إِعدّڒْ أَذْ إِڭعّذْ ؤُڒَا ذ إِجّْ ن بْنَاذمْ أَكِيذكْ، نِيغْ أَذْ إِبَانْ حذْ ذڭْ وذْرَارْ أَمْ إِكْمڒْ. ؤُڒَا ذ ؤُدْجِي ذ إِفُونَاسنْ ذ ثْفُونَاسِينْ وَارْ زمَّارنْ أَذْ أَروْسنْ طَّارْفْ إِ وذْرَارْ.“    ");
INSERT INTO rifa_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","خنِّي إِقسّْ ثْنَاينْ ن ثڒْوِيحِينْ ن وژْرُو أَمْ ثْمزْوُورَا، ؤُشَا إِكَّارْ مُوسَا ذِي صّْبحْ زِيشْ ؤُشَا إِڭعّذْ غَارْ وذْرَارْ ن سِينَا أَمْ مَامّشْ ث إِوصَّا سِيذِي ؤُشَا يِيوِي أَكِيسْ ذڭْ ؤُفُوسْ نّسْ ثْنَاينْ ن ثڒْوِيحِينْ ن وژْرُو. ");
INSERT INTO rifa_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","إِهْوَا-د سِيذِي ذڭْ ؤُسيْنُو، إِبدّْ أَكِيذسْ ذِينْ ؤُشَا إِڒَاغَا س يِيسمْ ن ’سِيذِي‘. ");
INSERT INTO rifa_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","إِژْوَا سِيذِي زَّاثْ إِ ؤُغمْبُوبْ نّسْ ؤُشَا إِعيّذْ: ”سِيذِي، سِيذِي، أَربِّي، ذ ونِّي إِشُّورنْ س أَرّحْمثْ ذ ثحْنُونشْثْ، غَارسْ تَّاسِيعْ ن ڒْخَاضَارْ، ذَايسْ أَطَّاسْ ن ثْمخْسِيوْثْ إِشوَّارنْ ذ ڒَامَانْ، ");
INSERT INTO rifa_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ذ ونِّي إِحطَّانْ ثَامخْسِيوْثْ نّسْ إِشوَّارنْ إِ ڒُوڒُوفْ، ذ ونِّي إِغفَّارنْ ڒْمُوعْصِييّثْ ذ خطُّو ذ دّْنُوبْ، ذ ونِّي وَارْ إِتّْبَارِّينْ ونِّي إِتّڭّنْ دّنْبْ، ذ ونِّي د-يَارزْفنْ ڒْمُوعْصِييّثْ ن إِبَابَاثنْ ذڭْ إِحنْجِيرنْ ؤُ ذڭْ إِحنْجِيرنْ ن إِحنْجِيرنْ نْسنْ أَڒْ جِّيڒْ وِيسّْ ثْڒَاثَا ذ وِيسّْ أَربْعَا.“ ");
INSERT INTO rifa_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","مُوسَا يُوضَارْ س وُوذمْ نّسْ غَارْ ثمُّورْثْ ؤُشَا إِبنْذقْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","إِنَّا: ”أَ سِيذِي إِنُو، مَاڒَا ؤُفِيغْ خنِّي أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، أَذْ يُويُورْ خنِّي سِيذِي إِنُو ذِي ڒْوسْطْ نّغْ، مِينْزِي ڒْڭنْسْ إِقْسحْ. غْفَارْ أَنغْ ڒْمُوعْصِييّثْ نّغْ ؤُ قْبڒْ أَنغْ ذ ڒْوَارْثْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","نتَّا إِنَّا: ”خْزَارْ، نشّْ أَذْ ڭّغْ ڒْعَاهْذْ. زَّاثْ إِ مَارَّا ڒْڭنْسْ نّكْ، أَذْ ڭّغْ ڒعْجَايبْ وَارْ إِتّْوَاڭّنْ شَا ذِي مَارَّا ثَامُّورْثْ ؤُ جَارْ مَارَّا ڒڭْنُوسْ، أَڒَامِي مَارَّا ڒْڭنْسْ ذِي ڒْوسْطْ نّسْ إِ زِي ثدْجِيذْ، أَذْ إِژَارْ مِينْ إِڭَّا سِيذِي، مِينْزِي مِينْ غَا ڭّغْ أَكِيذكْ أَذْ إِسّڭّْوذْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","حْضَا مِينْ خْ شكْ وصِّيغْ أَسّْ-أَ! خْزَارْ، أَذْ أَژّْڒغْ زَّاثْ إِ ؤُغمْبُوبْ نّشْ خْ إِمُورِييّنْ ذ أَيْثْ ن كنْعَانْ ذ إِحِيتِّييّنْ ذ إِفِيرِيزِييّنْ ذ إِحِيوِييّنْ ذ إِيِيبُوسِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","غَاركْ أَذْ ثڭّذْ ڒْعَاهْذْ أَكْ-ذ ؤُمزْذُوغْ ن ثمُّورْثْ مَانِي غَا ثَاذْفذْ، حِيمَا نتَّا وَارْ ذ أَشْ إِتِّيڒِي ذ ڒْفخْ ذِي ڒْوسْطْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","إِتّْخصَّا أَومْ أَذْ ثْغضْڒمْ إِعَالْطَارنْ نْسنْ ؤُ أَذْ ثَارْژَامْ إِمَايْضُوثنْ نْسنْ إِقدّْسنْ ؤُ أَذْ ثْهذْممْ ثِيربِّينْ نْسنْ ن شْوَارْثِي. ");
INSERT INTO rifa_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","وَارْ تّْبنْذِيقْ إِ أَربِّي نّغْنِي، مِينْزِي سِيذِي، ونِّي ؤُمِي قَّارنْ ’أَنسَّامْ‘، أَقَا-ث ذ إِجّْ ن أَربِّي إِتَّاسْمنْ.    ");
INSERT INTO rifa_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","غَاركْ أَذْ ثڭّذْ ڒْعَاهْذْ أَكْ-ذ إِمزْذَاغْ ن ثمُّورْثْ، ؤُشَا خنِّي أَذْ سّْفسْذنْ نِيثْنِي إِخفْ نْسنْ ؤُمِي غَا ذوْڒنْ أَوَارْنِي إِ إِربِّيثنْ نْسنْ، أَذْ قدّْمنْ ثِيغَارْصَا إِ إِربِّيثنْ نْسنْ، ؤُشَا أَذْ شكْ عَارْضنْ إِ مَاشَّا ن ثْغَارْصَا نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","أَذْ ثكْسِيذْ ثِيحنْجِيرِينْ نْسنْ ذ ثِيمْغَارِينْ إِ إِحنْجِيرنْ نّشْ، مَاشَا أَذْ سّْفسْذنْثْ ثْحنْجِيرِينْ نْسنْ إِخفْ نْسنْثْ ؤُمِي غَا ذوْڒنْ أَوَارْنِي إِ إِربِّيثنْ نْسنْثْ ؤُشَا أَذْ أَرّنْثْ إِحنْجِيرنْ نّشْ أَذْ ذوْڒنْ أَوَارْنِي إِ إِربِّيثنْ نْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","وَارْ تّڭّْ إِ يِيخفْ نّشْ إِربِّيتّنْ ن ؤُفسَّايْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","أَذْ ثحْضِيضْ ڒْعِيذْ ن وغْرُومْ بْڒَا أَنْثُونْ: سبْعَا ن وُوسَّانْ أَذْ ثشّذْ أَغْرُومْ بْڒَا أَنْثُونْ، ذِي ڒْوقْثْ إِتّْوَاڭّنْ ذڭْ ؤُيُورْ أَبِيبْ، أَمْ مَامّشْ شكْ وصِّيغْ، مِينْزِي ذڭْ ؤُيُورْ أَبِيبْ إِ د-ثفّْغذْ زِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","مَارَّا مِينْ يَارزّْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو إِنُو، مَارَّا إِوثْمَانْ ن ڒبْهَايمْ نّشْ إِ غَا يَارْزّْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو، أَمْ ونِّي ن ؤُفُونَاسْ، أَمْ ونِّي ن وُودْجِي. ");
INSERT INTO rifa_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","مَاڒَا أَمنْزُو ن وغْيُوڒْ يَارْزمْ ڒمْڒَاوْرَاثْ ذ أَمزْوَارُو، أَذْ ث ثفْذِيذْ س يِيجّْ زڭْ وُودْجِي. مَاڒَا وَارْ ث ثفْذِيذْ، أَذْ أَسْ ثَارْژذْ إِرِي. أَذْ ثفْذِيذْ مَارَّا إِمنْزَا ن إِحنْجِيرنْ نّشْ. وَارْ إِعدّڒْ أَذْ ضْهَارنْ س إِفَاسّنْ خْوَانْ زَّاثْ إِ وُوذمْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ستَّا ن وُوسَّانْ أَذْ ثْخذْمذْ، مَاشَا ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ثَاريّْحذْ. ؤُڒَا ذِي ڒْْوقْثْ ن ثْيَارْزَا ذ ثْميْرَا أَذْ ثَاريّْحذْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","أَذْ ثڭّذْ ڒْعِيذْ ن سِيمَانَاثْ، أَقَا-ث ذ ڒْعِيذْ ن ثْمنْزُوثْ ن ثْميْرَا ن يِيرْذنْ، ؤُڒَا ذ ڒْعِيذْ ن ؤُسْمُونِي غَارْ ؤُنڭَّارْ ن ؤُسڭّْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","كُوڒْ أَرْيَازْ أَذْ د-إِبَانْ ثْڒَاثَا ن ثْوَاڒَاوِينْ ذڭْ ؤُسڭّْوَاسْ زَّاثْ إِ وُوذمْ ن سِيذِي، سِيذِي، أَربِّي ن إِسْرَائِيل، ");
INSERT INTO rifa_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","مِينْزِي زَّاثْ إِ ؤُغمْبُوبْ نّشْ أَذْ كّْسغْ ثَاسْغَارْثْ ن ڒْوَارْثْ خْ ڒڭْنُوسْ ؤُشَا أَذْ سّْوسْعغْ إِيْمِيرنْ نّشْ ؤُشَا ؤُڒَا ذ إِجّنْ أَذْ إِمّژْرِي أَذْ يَاشَارْ ثَامُّورْثْ نّشْ، خْمِي غَا ثْڭعّْذذْ ثْڒَاثَا ن ثْوَاڒَاوِينْ ذڭْ ؤُسڭّْوَاسْ، حِيمَا أَذْ ثْبَانذْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَربِّي نّشْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","وَارْ تّْقدّمْ إِذَامّنْ ن ثْغَارْصْثْ إِنُو أَكْ-ذ مِينْ إِخمَّارنْ. ثَاغَارْصْثْ ن ڒْعِيذْ ن ثْغَارْصْثْ ن ؤُسعْذُو وَارْ تّْنُوسِي دْجِيڒثْ أَڒْ صّْبحْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ثَامزْوَارُوثْ ن ثْمنْزُوثْ ن وُوذمْ ن ثمُّورْثْ نّشْ أَذْ ت-إِ-د-ثَاوْيذْ غَارْ ثَادَّارْثْ ن سِيذِي، أَربِّي نّشْ. وَارْ سْننِّي إِغَايْضْ ذ أَمژْيَانْ س ؤُغِي ن يمَّاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","إِنَّا سِيذِي إِ مُوسَا: ”أَرِي أَوَاڒنْ-أَ إِ يِيخفْ نّشْ، مِينْزِي أَمْ مَامّشْ قَّارنْ وَاوَاڒنْ-أَ، أَقَا ڭِّيغْ ڒْعَاهْذْ أَكِيذكْ ؤُ أَكْ-ذ إِسْرَائِيل.“ ");
INSERT INTO rifa_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ؤُشَا مُوسَا ثُوغَا ذِينْ أَكْ-ذ سِيذِي أَربْعِينْ ن وُوسَّانْ ذ أَربْعِينْ ن دْجْيَاڒِي. وَارْ إِشِّي أَغْرُومْ نِيغْ إِسْوَا أَمَانْ. ؤُشَا يُورَا ذِي ثڒْوِيحِينْ أَوَاڒنْ ن ڒْعَاهْذْ،عشْرَا ن وَاوَاڒنْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ڒَْامِي د-إِهْوَا مُوسَا زڭْ وذْرَارْ ن سِينَا، أَمْ ثُوغَا ثْنَاينْ ن ثڒْوِيحِينْ ن شّْهَاذثْ ذڭْ إِفَاسّنْ ن مُوسَا أَمْ د-إِهْوَا زڭْ وذْرَارْ، إِمْسَارْ أَقَا وَارْ إِسِّينْ مُوسَا بلِّي ثِيڒْمشْثْ ن ؤُغمْبُوبْ نّسْ ثَارقّْ مِينْزِي ثُوغَا أَكِيذسْ إِسَّاوَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","هَارُونْ ذ مَارَّا أَيْثْ ن إِسْرَائِيل صوْضنْ غَارْ مُوسَا، ؤُ خْزَارْ، ثِيڒْمشْثْ ن وُوذمْ نّسْ ثُوغَا ثَارقّْ، ڭّْوذنْ أَذْ غَارسْ د-قَارّْبنْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","إِڒَاغَا-د خَاسنْ مُوسَا ؤُشَا إِذْوڒْ-د هَارُونْ ذ مَارَّا ڒْحُوكَّامْ ن ثْمسْمُونْثْ غَارسْ ؤُشَا إِسِّيوڒْ مُوسَا أَكِيذْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","أَوَارْنِي أَسْ قَارّْبنْ-د مَارَّا أَيْثْ ن إِسْرَائِيل ؤُشَا نتَّا يُومُورْ إِ-ثنْ مَارَّا مِينْ خفْ إِسِّيوڒْ سِيذِي أَكِيذسْ ذڭْ وذْرَارْ ن سِينَا. ");
INSERT INTO rifa_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ڒَْامِي إِكمّڒْ مُوسَا أَوَاڒْ نّسْ أَكِيذْسنْ، إِڭَّا أَڒحَّافْ خْ وُوذمْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","خْمِي إِ غَا يِيڒِي مُوسَا زَّاثْ إِ وُوذمْ ن سِيذِي حِيمَا أَذْ كِيذسْ إِسِّيوڒْ، إِكّسْ أَڒحَّافْ، أَڒْ د-إِفّغْ عَاوذْ. ؤُ ڒَامِي د-إِفّغْ غَارْ بَارَّا، إِسِّيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل مِينْ ذ أَسْ يُومُورْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ؤُشَا ژْرِينْ أَيْثْ ن إِسْرَائِيل أَغمْبُوبْ ن مُوسَا، أَقَا ثِيڒْمشْثْ ن وُوذمْ نّسْ ثَارقّْ، خنِّي يَارَّا مُوسَا أَڒحَّافْ خْ وُوذمْ نّسْ، أَڒْ د-يُوذفْ عَاوذْ، حِيمَا أَكِيذسْ إِسِّيوڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","مُوسَا إِسّْمُونْ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ؤُشَا إِنَّا أَسنْ: ”إِنَا ذ أَوَاڒنْ نِّي يُومُورْ سِيذِي، حِيمَا أَذْ ثنْ ثڭّمْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ستَّا ن وُوسَّانْ أَذْ ثڭّذْ ڒْخذْمثْ ؤُ أَسّْ وِيسّْ سبْعَا أَذْ أَومْ يِيڒِي إِقدّسْ، أَقَا ذ سّبْثْ، أَرَّاحثْ ثْمُونْ إِ سِيذِي. كُوڒْ إِجّْ، ونِّي ذَايسْ إِڭِّنْ شَا ن ڒْخذْمثْ، أَذْ إِتّْوَانغْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","وَارْ ثسّْرُوغِيمْ كنِّيوْ ثِيمسِّي ذِي مَارَّا ثِيزذِّيغِينْ نْومْ ذڭْ وَاسّْ ن سّبْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","إِسِّيوڒْ مُوسَا أَكْ-ذ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل، إِنَّا: ”ذ وَا ذ مِينْ إِوصَّا سِيذِي، ؤُمِي إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","’كْسِيمْ زِي مِينْ غَارْومْ إِشْثْ ن ثوْهِيبْثْ ن ؤُسْڭعّذْ إِ سِيذِي. كُوڒْ إِجّْ، ونِّي ؤُمِي ينُّورْزمْ وُوڒْ نّسْ، أَذْ ت يَاوِي، أَقَا-ت ذ ثَاوْهِيبْثْ ن ؤُسْڭعّذْ إِ سِيذِي: ؤُرغْ ذ نُّوقَارْثْ ذ نّْحَاسْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","أَفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ڒقْطنْ أَزْذَاذْ ذ شّْعَارْ ن إِغَايْضنْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","إِڒْمَاونْ إِزڭّْوَاغنْ ن إِشَارِّييّنْ ذ إِڒْمَاونْ ن دّنْفِيڒَاثْ ذ ؤُكشُّوضْ ن ؤُكَاسِييَا، ");
INSERT INTO rifa_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","زّشْثْ إِ ثْفَاوْثْ، ڒعْطُورْ إِ زّشْثْ ن وذْهَانْ ؤُ إِ ڒبْخُورْ إِتّْفُوحنْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","إِژْرَا ن ؤُنِيكْسْ ذ إِژْرَا إِغْڒَانْ نّغْنِي، مَاحنْذْ أَذْ ثنْ ڭّنْ خْ ؤُپَالْطُو ؤُ خْ ثجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","مَارَّا إِنِّي إِدْجَانْ جَارْ أَومْ س وُوڒْ ذ أَمِيغِيسْ، أَذْ د-أَسنْ أَذْ ڭّنْ مَارَّا مِينْ يُومُورْ سِيذِي: ");
INSERT INTO rifa_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ثَازذِّيغْثْ، أَقِيضُونْ نّسْ ذ ثْسقَّافْثْ نّسْ ذ ثْسنَّارِينْ نّسْ ذ ثْفڒْوِينْ نّسْ ذ ثْحنْيَا نّسْ ن ؤُعَارّضْ ذ إِپِيلَارنْ نّسْ ذ ثْيَارْسَاوِينْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ذ تَّابُوثْ أَكْ-ذ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ ذ ثْقبَّارْثْ ن وصْڒَاحْ ذ ؤُڒحَّافْ إِ دُّورِي، ");
INSERT INTO rifa_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ذ ثْزوْضَا أَكْ-ذ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ ذ مَارَّا ڒقْشُوعْ نّسْ ذ وغْرُومْ ن وسْشَانْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ذ ڒْقنْذِيڒْ إِ ثْفَاوْثْ ذ ڒقْشُوعْ نّسْ ذ ثفْثِيڒِينْ نّسْ ذ زّشْثْ إِ ثْفَاوْثْ ");
INSERT INTO rifa_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ذ ؤُعَالْطَارْ ن ڒبْخُورْ أَكْ-ذ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ ذ زّشْثْ إِ وذْهَانْ ذ ڒبْخُورْ إِتّْفُوحنْ ذ أَرْوَاقْ ن وَاذَافْ غَارْ وَاذَافْ ن ثْزذِّيغْثْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ذ ؤُعَالْطَارْ ن وشْمَاضْ ذ ثْرَاشَّا نّسْ ن نّْحَاسْ ذ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ ذ مَارَّا ڒقْشُوعْ نّسْ ذ ثْبَانْيُوثْ س ؤُضَارْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ذ ڒِيزَارَاثْ ن ڒمْرَاحْ، إِپِيلَارنْ نّسْ أَكْ-ذ ثْيَارْسَاوِينْ نْسنْ ذ أَرْوَاقْ إِ وَاذَافْ ن ڒمْرَاحْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ذ ڒوْثَاذْ ن ثْزذِّيغْثْ ذ ڒوْثَاذْ ن ڒمْرَاحْ ذ إِفِيڒَانْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","أَرُّوضْ إِ ڒْخذْمثْ ذڭْ ؤُقدَّاسْ، أَرُّوضْ إِقدّْسنْ ن ؤُكهَّانْ هَارُونْ ذ وَارُّوضْ ن وَارَّاوْ نّسْ، مَاحنْذْ أَذْ خذْمنْ أَمْ يِيكهَّاننْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","خنِّي فّْغنْ نِيثْنِي، مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل، ڭّْوجنْ زِي زَّاثْ ن ؤُغمْبُوبْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","خنِّي يُوسَا-د كُوڒْ إِجّْ، ونِّي ؤُمِي إِنْهزّْ وُوڒْ نّسْ، ؤُ مَارَّا ونِّي ؤُمِي إِنُّورْزمْ بُوحْبڒْ نّسْ، ؤُشَا إِوْينْ-د نِيثْنِي ثَاوْهِيبْثْ ن ؤُسْڭعّذْ، ثنِّي سّْڭعّْذنْ نِيثْنِي غَارْ سِيذِي، ذ ثنِّي إِ غَا يِيڒِينْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُ إِ ثْسخَّارْثْ إِ ذَايسْ ؤُ إِ وَارُّوضْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","أَمُّو د-ؤُسِينْ إِرْيَازنْ جْمِيعْ أَكْ-ذ ثمْغَارِينْ، مَارَّا إِنِّي ؤُمِي إِنُّورْزمْ وُوڒْ نْسنْ ؤُشَا إِوْينْ-د ثِيمسَّاكِينْ ذ ثخْرَازِينْ ن ؤُمزُّوغْ ذ ثِينْزَارْ ذ ثْخُوذَانْ ن ؤُشمِّيعْ ذ ثْسذِّييِينْ س وذْمَامْ ن وُورغْ ذ مَارَّا ڒقْشُوعْ ن وُورغْ، وَاهْ، كُوڒْ  إِجّنْ يِيوِي إِشْثْ ن ثوْهِيبْثْ ن ونْهزِّي ن وُورغْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","مَارَّا وِي غَارْ إِتّْوَافْ أَفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ نِيغْ ڒقْطنْ أَزْذَاذْ نِيغْ شّْعَارْ ن إِغَايْضنْ نِيغْ إِڒْمَاونْ إِزڭّْوَاغنْ ن إِشَارِّييّنْ نِيغْ إِڒْمَاونْ ن دّنْفِيڒَاثْ، إِوْينْ-د مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","مَارَّا وِي إِسّْڭعّْذنْ ثَاوْهِيبْثْ ن نُّوقَارْثْ نِيغْ ن نّْحَاسْ، إِوْينْ ثَاوْهِيبْثْ-أَ ن ؤُسْڭعّذْ غَارْ سِيذِي، ذ مَارَّا وِي غَارْ إِتّْوَافْ ؤُكشُّوضْ ن ؤُكَاسِييَا إِ مَارَّا ڒْخذْمثْ ن ثْسخَّارْثْ، إِوْينْ مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","مَارَّا ثِيمْغَارِينْ س وُوڒْ أَمِيغِيسْ تّْقَارْضْشنْثْ س إِفَاسّنْ نْسنْثْ ؤُشَا نِيثنْثِي إِوْينْثْ-إِ-د مِينْ قَارضْشنْثْ: أَفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ڒقْطنْ أَزْذَاذْ.    ");
INSERT INTO rifa_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","مَارَّا ثِيمْغَارِينْ نِّي ؤُمِي إِنْهزّْ وُوڒْ نْسنْثْ س ثِيغِيثْ، قَارضْشنْثْ شّْعَارْ ن إِغَايْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ڒْحُوكَّامْ إِوْينْ-د إِژْرَا ن ؤُنِيكْسْ ذ إِژْرَا إِغْڒَانْ نّغْنِي، حِيمَا أَذْ ثنْ ڭّنْ خْ ؤُپَالْطُو ؤُ خْ ثجْمشْثْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ڒعْطُورْ ذ زّشْثْ إِ ثْفَاوْثْ ذ زّشْثْ إِ وذْهَانْ ؤُ إِ ڒبْخُورْ إِتّْفُوحنْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","أَيْثْ ن إِسْرَائِيل وْشِينْ س ڒْخَاضَارْ إِ سِيذِي، مَارَّا إِرْيَازنْ ذ ثمْغَارِينْ، إِنِّي ؤُمِي إِنْهزّْ وُوڒْ نْسنْ، مَاحنْذْ أَذْ وْشنْ س ڒْخَاضَارْ إِ مَارَّا ڒْخذْمثْ نِّي يُومُورْ سِيذِي، حِيمَا أَذْ ثتّْوَاڭّْ س ثْسخَّارْثْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","خنِّي إِنَّا مُوسَا إِ أَيْثْ ن إِسْرَائِيل: ”خْزَارمْ، سِيذِي إِڒَاغَا-د إِ بَاصَالِييِيلْ، مِّيسْ ن ؤُرِي، مِّيسْ ن حُورْ، زِي ڒَادْجْ ن يَاهُوذَا، س يِيسمْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","إِشُّورْ إِ-ث أَرُّوحْ ن أَربِّي س ثِيغِيثْ ذ ڒعْقڒْ ذ ثُوسّْنَا ؤُ س مَارَّا مِينْ إِتّْخصَّانْ ن ثْزمَّارْ ن صّْنَايعْ ");
INSERT INTO rifa_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","إِ ؤُخمّمْ ن عْڒَامْ كُوڒْ إِرقَّامنْ، حِيمَا أَذْ ثنْ يڭّْ س وُورغْ ذ نُّوقَارْثْ ذ نّْحَاسْ، ");
INSERT INTO rifa_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ؤُ إِ ؤُنقَّاشْ ن إِژْرَا إِغْڒَانْ ذ ؤُسَارْسِي نْسنْ، ؤُ إِ ؤُنقَّاشْ ن ؤُكشُّوضْ ؤُ حِيمَا أَذْ إِڭّْ مَارَّا إِرقَّامنْ س لْفنّْ. ");
INSERT INTO rifa_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","إِڭَّا أَربِّي ذڭْ وُوڒْ نّسْ ثَاونْڭِيثْ إِ ؤُسڒْمذْ، ذڭْ وُوڒْ نّسْ ؤُ ذڭْ وُوڒْ ن أَهُولِييَابْ، مِّيسْ ن أَخِيسَامَاكْ، زِي ڒَادْجْ ن دَان. ");
INSERT INTO rifa_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","إِشُّورْ إِ-ثنْ س ثِيغِيثْ ن وُوڒْ، مَاحنْذْ أَذْ ڭّنْ مَارَّا ڒْخذْمثْ: ڒْخذْمثْ ن ثَانقَّاشْثْ ذ وَارْشَامْ ذ ؤُمُوذِي س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ڒقْطنْ أَزْذَاذْ ؤُڒَا ذ ڒْخذْمثْ ن ؤُخيَّاضْ.“ نِيثْنِي ڭِّينْ كُوڒْ ڒْخذْمثْ ؤُ تّْسَاقَارنْ أَرْشَامنْ س لْفنّْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","بَاصَالِييِيلْ ذ أَهُولِييَابْ ذ كُوڒْ أَرْيَازْ س وُوڒْ أَمِيغِيسْ إِ ؤُمِي إِوْشَا سِيذِي ثِيغِيثْ ذ ڒعْقڒْ، مَاحنْذْ أَذْ سّْننْ مَامّشْ غَا ڭّنْ مَارَّا ڒْخذْمثْ إِ ثْسخَّارْثْ ن زَّاوشْثْ إِقدّْسنْ، ڭِّينْ مَارَّا أَمْ مَامّشْ ثنْ يُومُورْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","مُوسَا إِڒَاغَا-د إِ بَاصَالِييِيلْ ذ أَهُولِييَابْ ذ كُوڒْ أَرْيَازْ س وُوڒْ أَمِيغِيسْ، ؤُمِي إِڭَّا سِيذِي ثِيغِيثْ ذڭْ وُوڒْ نّسْ، ؤُڒَا مَارَّا ونِّي ؤُمِي إِنْهزّْ وُوڒْ نّسْ، مَاحنْذْ أَذْ د-يَاسْ غَارْ ڒْخذْمثْ ؤُشَا أَذْ ت إِڭّْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","نِيثْنِي كْسِينْ زِي زَّاثْ ن وُوذمْ ن مُوسَا مَارَّا ثَاوْهِيبْثْ نِّي سّْڭعّْذنْ أَيْثْ ن إِسْرَائِيل إِ ڒْخذْمثْ ذِي طّْوعْ نِي ثْسخَّارْثْ ن زَّاوشْثْ إِقدّْسنْ، مَاحنْذْ أَذْ ڭّنْ ڒْخذْمثْ نِّي. ؤُشَا أَقَا عَاذْ ڭِّينْ أَذْ أَسْ د-أَوْينْ كُوڒْ صّْبحْ ثِيوْهِيبِينْ س ڒْخَاضَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","خنِّي ؤُسِينْ-د مَارَّا إِرْيَازنْ إِمِيغِيسنْ، إِنِّي ثُوغَا إِشغْڒنْ خْ مَارَّا ڒْخذْمثْ ن زَّاوشْثْ إِقدّْسنْ، إِجّْ إِجّْ ذوْڒنْ-د زِي ڒْخذْمثْ نِّي ڭِّينْ نِيثْنِي، ");
INSERT INTO rifa_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ؤُشَا سِّيوْڒنْ أَكْ-ذ مُوسَا، نَّانْ: ”ڒْْڭنْسْ يِيوِي-د كْثَارْ زِي مِينْ إِتّْخصَّانْ ذِي طّْوعْ نْ ڒْخذْمثْ نِّي إِ ذ أَنغْ يُومُورْ سِيذِي، حِيمَا أَذْ ت نڭّْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","خَاسْ ؤُشَا يُومُورْ مُوسَا، حِيمَا أَذْ بَارّْحنْ ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ، أَذْ إِنِينْ: ”وَارْ تّجِّي أَرْيَازْ نِيغْ ثَامْغَارْثْ عَاذْ أَذْ يڭّْ شَا ن ڒْخذْمثْ نِّي إِ غَا إِسّْڭعّذْ ذ ثَاوْهِيبْثْ إِ زَّاوشْثْ إِقدّْسنْ!“ أَمُّو إِ إِسّْبدّْ مُوسَا ڒْڭنْسْ أَذْ يَاوِي عَاذْ كْثَارْ، ");
INSERT INTO rifa_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","مِينْزِي شْفَا ثِيمسْڒَايِينْ نِّي ذ إِوْينْ إِ مَارَّا ڒْخذْمثْ إِ غَا ڭّنْ، أَقَا ثْشطّْ عَاذْ كْثَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","جَارْ يِينِّي غَارْ ثُوغَا ڒْخذْمثْ، أَقَا مَارَّا إِمِيغِيسنْ ن وُوڒْ ڭِّينْ ثَازذِّيغْثْ زِي عشْرَا ن ثْجَارْثِيڒِينْ ن ڒقْطنْ أَزْذَاذْ إِمُوذنْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ أَكْ-ذ إِكِيرُوبنْ نِّي خَاسنْثْ إِڭَّا أَمْ يِيجّْ ن وَارْشَامْ ن ؤُفنَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ثُوزّڭَّارْثْ ن إِشْثْ ن ثْجَارْثِيڒْثْ ثُوغَا-ت ثْمنْيَا ؤُ -عشْرِينْ ن إِغَادْجنْ ؤُ ثِيرُو ن إِشْثْ ن ثْجَارْثِيڒْثْ ثُوغَا-ث أَربْعَا ن إِغَادْجنْ ؤُ مَارَّا ثِيجَارْثِيڒِينْ غَارْسنْثْ ذ ڒعْبَارْ ذ إِجّْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","إِسّْمُونْ خمْسَا ن ثْجَارْثِيڒِينْ إِشْثْ أَكْ-ذ ثنّغْنِي ؤُشَا خمْسَا ن ثْجَارْثِيڒِينْ إِسّْمُونْ إِ-ثنْثْ عَاوذْ إِشْثْ أَكْ-ذ ثنّغْنِيثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","خنِّي إِڭَّا ثِيسَارَاوِينْ إِذحْمَانِييّنْ ذِي ثْمَا ن يِيشْثْ ن ثْجَارْثِيڒْثْ غَارْ طَّارْفْ غَارْ ؤُسڒْقِي ؤُشَا أَمنِّي إِ ثنْثْ إِڭَّا عَاوذْ ذِي ثْمَا ن ثْجَارْثِيڒْثْ نّغْنِي غَارْ طَّارْفْ، غَارْ مَانِي إِدْجَا ؤُسڒْقِي نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","إِڭَّا خمْسِينْ ن ثْسَارَاوِينْ خْ ثْمَا ن يِيشْثْ ن ثْجَارْثِيڒْثْ ذ خمْسِينْ ن ثْسَارَاوِينْ غَارْ طَّارْفْ ن ثْجَارْثِيڒْثْ نّغْنِي غَارْ ؤُسڒْقِي نّغْنِي. ثِيسَارَاوِينْ طّْفنْثْ نِيشَانْ إِشْثْ ذِي ثنّغْنِيثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","إِڭَّا عَاوذْ خمْسِينْ ن ثْسنَّارِينْ ن وُورغْ ؤُشَا إِسّْمُونْ ثِيجَارْثِيڒِينْ إِشْثْ إِ ثنّغْنِي س ثْسنَّارِينْ ؤُشَا أَمُّو ثذْوڒْ ثْزذِّيغْثْ ذ إِشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","إِڭَّا عَاوذْ ثِيجَاڒْثِيڒِينْ ن شّْعَارْ ن إِغَايْضنْ، أَذْ إِڒِينْثْ ذ أَقِيضُونْ خْ ثْزذِّيغْثْ. إِڭَّا حِيطَاشْ ن ثْجَارْثِيڒِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ثُوزّڭَّارْثْ ن إِشْثْ ن ثْجَارْثِيڒْثْ ثُوغَا-ت ثْڒَاثِينْ ن إِغَادْجنْ ؤُ ثِيرُو ن إِشْثْ ن ثْجَارْثِيڒْثْ ذ أَربْعَا ن إِغَادْجنْ. حِيطْعَاشْ ن ثْجَارْثِيڒِينْ غَارْسنْثْ ڒعْبَارْ ذ إِجّْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","نتَّا إِسّْمُونْ خمْسَا ن ثْجَارْثِيڒِينْ وحّذْسنْثْ ؤُ عَاوذْ ستَّا ن ثْجَارْثِيڒِينْ وحّذْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","إِڭَّا خمْسِينْ ن ثْسَارَاوِينْ خْ ثْمَا ن ثْجَارْثِيڒْثْ ثَانڭَّارُوثْ غَارْ طَّارْفْ ن ؤُسڒْقِي أَكْ-ذ ثنّغْنِي ؤُشَا إِڭَّا عَاوذْ خمْسِينْ ن ثْسَارَاوِينْ خْ ثْمَا ن ثْجَارْثِيڒْثْ غَارْ طَّارْفْ ن ؤُسڒْقِي نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","إِڭَّا عَاوذْ خمْسِينْ ن ثْسنَّارِينْ ن نّْحَاسْ، حِيمَا أَذْ إِسّْمُونْ أَقِيضُونْ مَاحنْذْ أَذْ ث يَارّْ ذ إِجّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","إِڭَّا عَاوذْ إِشْثْ ن ثْسقَّافْثْ ن إِڒْمَاونْ إِزڭّْوَاغنْ ن إِشَارِّييّنْ إِ ؤُقِيضُونْ ؤُشَا سنّجْ إِ مَانْ أَيَا إِشْثْ ن ثْسقَّافْثْ ن إِڒْمَاونْ ن دّنْفِيڒَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","إِڭَّا ثِيفڒْوِينْ إِ ثْزذِّيغْثْ س ؤُكشُّوضْ ن ؤُكَاسِييَا نِّي إِبدّنْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ثُوزّڭَّارْثْ ن إِشْثْ ن ثفْڒَاوْثْ ثُوغَا-تعشْرَا ن إِغَادْجنْ ؤُ ثِيرُو ن يِيشْثْ ن ثفْڒَاوْثْ ذ إِجّْ ن ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","كُوڒْ ثَافْڒوْثْ غَارسْ ثْنَاينْ ن إِضَارنْ، إِنِّي إِسّْمڒْقَانْ إِشْثْ أَكْ-ذ ثنّغْنِيثْ أَمْ ثْوتْشْمَاثِينْ أَمُّو إِ إِڭَّا س مَارَّا ثِيفڒْوِينْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","إِڭَّا ثِيفڒْوِينْ إِ ثْزذِّيغْثْ، عِيشْرِينْ ن ثْفڒْوِينْ غَارْ جِّيهثْ ن لْجَانُوبْ، غَارْ يفُوسْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","إِڭَّا عَاوذْ أَربْعِينْ ن ثْيَارْسَاوِينْ ن نُّوقَارْثْ سَاذُو عِيشْرِينْ ن ثْفڒْوِينْ، ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو إِشْثْ ن ثفْڒَاوْثْ إِ ثْنَاينْ ن إِضَارنْ نّسْ، ؤُڒَا ذ ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو ثَافْڒَاوْثْ نّغْنِي إِ ثْنَاينْ ن إِضَارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","إِڭَّا عَاوذْ عِيشْرِينْ ن ثْفڒْوِينْ إِ ؤُغزْذِيسْ نّغْنِي ن ثْزذِّيغْثْ، غَارْ ؤُغزْذِيسْ ن شَّامَالْ، ");
INSERT INTO rifa_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","س أَربْعِينْ ن ثْيَارْسَاوِينْ نّسْ ن نُّوقَارْثْ: ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو إِشْثْ ن ثفْڒَاوْثْ ذ ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو ثَافْڒَاوْثْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","إِ إِغزْذِيسنْ ن ضفَّارْ ن ثْزذِّيغْثْ، غَارْ ؤُغزْذِيسْ ن ڒْغَارْبْ، إِڭَّا ستَّا ن ثْفڒْوِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","إِڭَّا ثْنَاينْ ن ثْفڒْوِينْ ذ ثِيفڒْوِينْ إِ ثْغمُّورَا ن ثْزذِّيغْثْ غَارْ ثْنَاينْ ن إِغزْذِيسنْ غَارْ ضفَّارْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","زِي سْوَادَّايْ ثُوغَا ڒصْقنْثْ أَمْ وَاشْنِيونْ ؤُشَا أَمُّو إِ ثنْثْ ثُوغَا ذ إِشْثنْ أَڒْ د-أَوْضنْثْ سنّجْ ذڭْ إِشْثْ ن ثخْرَازْثْ. أَمُّو إِ إِڭَّا س ثْنَاينْ ن ثْفڒْوِينْ إِ ثْنَاينْ ن ثْغمُّورَا. ");
INSERT INTO rifa_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","أَمُّو إِ ذِينْ ثُوغَا ثْمنْيَا ن ثْفڒْوِينْ س ثْيَارْسَاوِينْ نْسنْثْ ن نُّوقَارْثْ، أَقَا أَثنْثْ ذ سطَّاشْ ن ثْيَارْسَاوِينْ، ثْنَاينْ ن ثْيَارْسَاوِينْ سَاذُو كُوڒْ ثَافْڒوْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","إِڭَّا عَاوذْ ثِيحنْيَا ن ؤُعَارّضْ زڭْ ؤُكشُّوضْ ن ؤُكَاسِييَا، خمْسَا ن ثْفڒْوِينْ غَارْ إِجّْ ن ؤُغزْذِيسْ ن ثْزذِّيغْثْ، ");
INSERT INTO rifa_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ؤُ خمْسَا ن ثْحنْيَا ن ؤُعَارّضْ إِ ثْفڒْوِينْ غَارْ ؤُغزْذِيسْ نّغْنِي ن ثْزذِّيغْثْ ذ خمْسَا ن ثْحنْيَا ن ؤُعَارّضْ إِ ثْفڒْوِينْ ن ثْزذِّيغْثْ غَارْ ثْنَاينْ ن ثْغمُّورَا نْ ضفَّارْ غَارْ ڒْغَارْبْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ثَاحْنَاشْثْ ن ؤُعَارّضْ ذِي ڒْوسْطْ إِڭَّا إِ-ت أَذْ ثژْوَا زِي ڒْوسْطْ ن ثْفڒْوِينْ زڭْ إِخفْ أَڒْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","إِغدْجفْ ثِيفڒْوِينْ س وُورغْ ؤُشَا إِڭَّا ثِيخْرَازِينْ نْسنْثْ ن وُورغْ، مَاحنْذْ أَذْ ذَايْسنْثْ سِّيذْفنْ ثِيحنْيَا ن ؤُعَارّضْ ؤُشَا ؤُڒَا ذ ثِيحنْيَا ن ؤُعَارّضْ إِشلّلْ إِ-ثنْثْ س وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","إِڭَّا إِجّْ ن ؤُڒحَّافْ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، إِڭَّا إِ-ث ذ إِجّْ ن وَارْشَامْ ن ؤُفنَّانْ أَكْ-ذ إِكِيرُوبنْ خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","إِڭَّا أَسْ أَربْعَا ن إِپِيلَارنْ ن ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا إِغدْجفْ إِ-ثنْ س وُورغْ. ثِيسنَّارِينْ نْسنْ ثُوغَا أَثنْثْ ن وُورغْ. إِسّفْسِي إِ إِپِيلَارنْ أَربْعَا ن ثْيَارْسَاوِينْ نْسنْثْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","إِڭَّا إِجّْ ن أَرْوَاقْ إِ وَاذَافْ ن ؤُقِيضُونْ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، إِڭَّا إِ-ث ذ إِجّْ ن ؤُمُوذِي ن ؤُخيَّاضْ، ");
INSERT INTO rifa_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","س خمْسَا ن إِپِيلَارنْ نّسْ ذ ثْسنَّارِينْ نّسْ. إِغدْجفْ ثِيزدْجِيفِينْ نْسنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي س وُورغْ. ثِييَارْسَاوِينْ نْسنْ ثُوغَا أَثنْثْ ن نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","إِڭَّا بَاصَالِييِيلْ تَّابُوثْ ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا. ثُوزّڭَّارْثْ نّسْ ثُوغَا-ت ثْنَاينْ ن إِغَادْجنْ ذ وزْينْ ؤُ ثِيرُو نّسْ إِجّْ ن ؤُغِيڒْ ذ وزْينْ ؤُشَا ڒُوعْڒَا نّسْ إِجّْ ن ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","إِغدْجفْ إِ-ث زِي ذَاخڒْ ذ بَارَّا س وُورغْ إِصْفَانْ ؤُشَا إِڭَّا أَسْ إِجّْ ن زّْوَاقْ ن وُورغْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","إِسّفْسِي أَسْ أَربْعَا ن ثخْرَازِينْ إِ أَربْعَا ن ثْغمُّورَا نّسْ: ثْنَاينْ ن ثخْرَازِينْ غَارْ يِيجّْ ن ؤُغزْذِيسْ ذ ثْنَاينْ ن ثخْرَازِينْ غَارْ ؤُغزْذِيسْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","إِڭَّا إِعُومَاذْ إِ ثَاربُّوثْ زڭْ ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا إِغدْجفْ إِ-ثنْ س وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","إِڭَّا إِعُومَاذْ إِ ثَاربُّوثْ ذِي ثخْرَازِينْ غَارْ ثْنَاينْ ن إِغزْذِيسنْ ن تَّابُوثْ، مَاحنْذْ أَذْ زَّايْسنْ أَرْبُونْ تَّابُوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","إِڭَّا ثَاقبَّارْثْ ن وصْڒَاحْ ن وُورغْ إِصْفَانْ س ثُوزّڭَّارْثْ نّسْ ن ثْنَاينْ ن إِغَادْجنْ ذ وزْينْ ؤُ ثِيرُو نّسْ ن إِجّْ ن ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","إِڭَّا ثْنَاينْ ن إِكِيرُوبنْ ن وُورغْ. إِعْذڒْ إِ-ثنْ أَمْ ڒْخذْمثْ ن ومْزِيڒْ إِ د-إِتّفّْغنْ زِي ثْنَاينْ ن إِخْفَاونْ ن ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","إِجّْ ن ؤُكِيرُوبْ إِفّغْ زڭْ إِجّْ ن إِخفْ غَارْ ؤُغزْذِيسْ-أَ ؤُ أَكِيرُوبْ نّغْنِي زڭْ إِخفْ نّغْنِي غَارْ ؤُغزْذِيسْ نّغْنِي. إِڭَّا إِكِيرُوبنْ زِي ثْنَاينْ ن إِخْفَاونْ ن ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","إِكِيرُوبنْ سّْوِيژّْضنْ أَفْرِيونْ نْسنْ سنّجْ ؤُشَا س وَافْرِيونْ نْسنْ ذْڒِينْ ثَاقبَّارْثْ ن وصْڒَاحْ. إِغمْبَابْ نْسنْ ثُوغَا إِجّنْ قِيبَاتْشْ إِ ونّغْنِي ؤُشَا ذِي ڒْوقْثْ ذ إِشْثنْ ثُوغَا إِغمْبَابْ ن إِكِيرُوبنْ غَارْ ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","إِڭَّا ثَازوْضَا ن ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا. ثُوغَا ثُوزّڭَّارْثْ نّسْ ثْنَاينْ ن إِغَادْجنْ ؤُ ثِيرُو نّسْ إِجّْ ن ؤُغِيڒْ ذ ڒُوعْڒَا نّسْ إِجّْ ن ؤُغِيڒْ ذ وزْينْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","إِغدْجفْ إِ-ت س وُورغْ إِصْفَانْ ؤُشَا إِڭَّا أَسْ إِجّْ ن زّْوَاقْ ن وُورغْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","إِڭَّا عَاوذْ إِشْثْ ن ثْمَا إِ ذ أَسْ د-إِنّْضنْ ن إِجّْ ن شْبَارْ ن ؤُفُوسْ ؤُشَا إِڭَّا إِجّْ ن زّْوَاقْ ن وُورغْ غَارْ ثْموَّا نّسْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","إِسّفْسِي أَسْ أَربْعَا ن ثخْرَازِينْ ن وُورغْ ؤُشَا إِڭَّا ثِيخْرَازِينْ غَارْ أَربْعَا ن ثْغمُّورَا نِّي إِدْجَانْ غَارْ أَربْعَا ن إِضَارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ثُوغَا ثِيخْرَازِينْ زَّاثْ ن ثْمَا، مَاحنْذْ أَذْ ذَايْسنْثْ سِّيذْفنْ إِعُومَاذْ إِ ثَاربُّوثْ، حِيمَا أَذْ زَّايْسنْ أَرْبُونْ ثَازوْضَا. ");
INSERT INTO rifa_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","إِڭَّا إِعُومَاذْ إِ ثَاربُّوثْ زڭْ ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا إِغدْجفْ إِ-ثنْ س وُورغْ، مَاحنْذْ أَذْ زَّايْسنْ أَرْبُونْ ثَازوْضَا. ");
INSERT INTO rifa_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","إِڭَّا ڒقْشُوعْ إِ غَا يِيڒِينْ خْ ثْزوْضَا س وُورغْ إِصْفَانْ: طّْبَاصِي نّسْ ذ ثْغنْجَايِينْ نّسْ ذ ڒْكِيسَانْ نّسْ ذ إِغَارَّافنْ، مَاحنْذْ أَذْ زَّايْسنْ كبّنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","إِڭَّا ڒْقنْذِيڒْ ن وُورغْ إِصْفَانْ. إِعْذڒْ ڒْقنْذِيڒْ س وفْضِيسْ ن ومْزِيڒْ: أَفُوذْ خْ ؤُضَارْ نّسْ ذ إِغَادْجنْ نّسْ ذ ڒْكِيسَانْ نّسْ ذ ثْعبُّوزِينْ نّسْ إِ د-إِتَّاسنْ أَكْ-ذ نُّووَارَاثْ نّسْ، أَقَا-ثنْ مَارَّا ثُوغَا زَّايسْ د-إِتّفّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","زڭْ إِغزْذِيسنْ نّسْ فّْغنْ-د ستَّا ن إِغَادْجنْ، ثْڒَاثَا ن إِغَادْجنْ ن ڒْقنْذِيڒْ زڭْ إِجّْ ن ؤُغزْذِيسْ ذ ثْڒَاثَا ن إِغَادْجنْ ن ڒْقنْذِيڒْ زڭْ ؤُغزْذِيسْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","غَارْ إِجّْ ن ؤُغِيڒْ ثُوغَا ذِينْ ثْڒَاثَا ن ڒْكِيسَانْ أَمْ نّوَّاشْ ن دْجوْزْ س ثْعبُّوزْثْ ذ نّوَّاشْ ؤُشَا خْ ؤُغِيڒْ نّغْنِي عَاوذْ ثْڒَاثَا ن ڒْكِيسَانْ أَمْ نّوَّاشْ ن دْجوْزْ س إِشْثْ ن ثْعبُّوزْثْ إِ د-إِتَّاسنْ أَكْ-ذ إِجّْ ن نّوَّاشْ. أَمُّو إِ يدْجَانْ مَارَّا ستَّا ن إِغَادْجنْ نِّي د-إِتّفّْغنْ زِي ڒْقنْذِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","غَارْ ڒْقنْذِيڒْ سِيمَانْثْ نّسْ ثُوغَا ذِينْ أَربْعَا ن ڒْكِيسَانْ أَمْ نُّووَارَاثْ ن دْجوْزْ أَكْ-ذ ثْعبُّوزِينْ نْسنْ إِ د-إِتَّاسنْ أَكْ-ذ نُّووَارَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","سَاذُو ثْيُويَا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ ذ أَمزْوَارُو أَقَا ذِينْ إِشْثْ ن ثْعبُّوزْثْ ؤُشَا أَمنِّي إِ ذِينْ إِشْثْ ن ثْعبُّوزْثْ سَاذُو ثْيُويَا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ أَوَارْنِي أَسْ ؤُشَا عَاوذْ ذِينْ إِشْثْ ن ثْعبُّوزْثْ سَاذُو ثْيُويَا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ ذ أَنڭَّارُو. مَانْ أَيَا إِدْجَا أَمنِّي إِ ستَّا ن إِغَادْجنْ إِ زَّايسْ د-إِفّْغنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ثُوغَا ثِيعبُّوزِينْ نْسنْ ذ إِغَادْجنْ نْسنْ فّْغنْ-د زَّايسْ. مَارَّا أَيَا ثُوغَا ذ إِشْثْ ن ڒْخذْمثْ ن ومْزِيڒْ س وُورغْ إِصْفَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","إِڭَّا ستَّا ن ڒفْنَارَاثْ نّسْ أَكْ-ذ ثْجقَّاضِينْ ن ثفْثِيتْشْ نّسْ ذ ثْمجْمَارِينْ نّسْ، مَارَّا س وُورغْ إِصْفَانْ.    ");
INSERT INTO rifa_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","إِڭَّا ڒْْقنْذِيڒْ أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ زڭْ إِشْثْ ن ثَالِينْثْ ن وُورغْ إِصْفَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","إِڭَّا أَعَالْطَارْ ن ڒبْخُورْ زڭْ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ؤُكَاسِييَا س ثُوزّڭَّارْثْ نّسْ ن إِجّْ ؤُغِيڒْ ؤُ ثِيرُو نّسْ ن إِجّْ ن ؤُغِيڒْ. ثُوغَا-ث س أَربْعَا ن ثْغمُّورَا. ڒُْوعْڒَا نّسْ ثُوغَا-ث ثْنَاينْ ن إِغَادْجنْ. زَّايسْ ثُوغَا أَشَّاونْ نّسْ ذ إِجّْ أَكِيذسْ.    ");
INSERT INTO rifa_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","إِغدْجفْ إِ-ث س وُورغْ إِصْفَانْ، ؤُذمْ نّسْ ن سنّجْ ذ إِغزْذِيسنْ نّسْ إِ ذ أَسْ د-إِنّْضنْ ؤُ عَاوذْ أَشَّاونْ نّسْ. إِڭَّا أَسْ إِجّْ ن زّْوَاقْ ن وُورغْ إِ ذ أَسْ د-إِنّْضنْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","إِڭَّا أَسْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ سَاذُو زّْوَاقْ نّسْ إِ ثْنَاينْ ن ثْغمُّورَا نّسْ، غَارْ ثْنَاينْ ن إِغزْذِيسنْ نّسْ، حِيمَا أَذْ ذَايْسنْثْ سِّيذْفنْ إِعُومَاذْ، مَاحنْذْ أَذْ زَّايْسنْ أَرْبُونْ أَعَالْطَارْ ن ڒبْخُورْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","إِڭَّا إِعُومَاذْ إِ ثَاربُّوثْ زڭْ ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا إِغدْجفْ إِ-ثنْ س وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","إِڭَّا عَاوذْ زّشْثْ ثَامْقدّسْثْ إِ وذْهَانْ ذ ڒبْخُورْ إِصْفَانْ إِتّْفُوحنْ، عْلَاحْسَابْ صّنْعثْ ن ؤُعطَّاڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","إِڭَّا أَعَالْطَارْ ن وشْمَاضْ س ؤُكشُّوضْ ن ؤُكَاسِييَا. ثُوزّڭَّارْثْ نّسْ ثُوغَا-ت خمْسَا ن إِغَادْجنْ ؤُ ثِيرُو نّسْ خمْسَا ن إِغَادْجنْ، ثُوغَا-ث س أَربْعَا ن ثْغمُّورَا، ؤُ ڒُوعْڒَا نّسْ ثُوغَا-ث ثْڒَاثَا ن إِغَادْجنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","غَارْ أَربْعَا ن ثْغمُّورَا إِڭَّا أَشَّاونْ نّسْ. أَشَّاونْ نّسْ ثُوغَا أَثنْ ذ إِجّنْ أَكِيذسْ. إِغدْجفْ إِ-ث س نّْحَاسْ.    ");
INSERT INTO rifa_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","إِڭَّا مَارَّا ڒقْشُوعْ إِ ؤُعَالْطَارْ: ثِييْذُورِينْ ذ إِغنْجَاينْ ذ طَّاوْيَاثْ إِ ؤُرُوشِّي ذ فُورْشَايَاثْ ذ ثْمجْمَارِينْ، مَارَّا ڒقْشُوعْ-أَ إِڭَّا إِ-ثنْ س نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","إِڭَّا إِشْثْ ن ثْرَاشَّا إِ ؤُعَالْطَارْ، إِجّْ ن ؤُمُوذِي ن نّْحَاسْ سَاذُو ثْمَا نّسْ، سْوَادَّايْ غَارْ وزْينْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","إِسّفْسِي أَربْعَا ن ثخْرَازِينْ إِ أَربْعَا ن إِخْفَاونْ ن ثْرَاشَّا ن نّْحَاسْ مَاحنْذْ أَذْ ذَايْسنْثْ سِّيذْفنْ إِعُومَاذْ إِ ثَاربُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","إِڭَّا إِعُومَاذْ إِ ثَاربُّوثْ زڭْ ؤُكشُّوضْ ن ؤُكَاسِييَا ؤُشَا إِغدْجفْ إِ-ثنْ س نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","إِڭَّا إِعُومَاذْ إِ ثَاربُّوثْ ذِي ثخْرَازِينْ غَارْ إِغزْذِيسنْ ن ؤُعَالْطَارْ، مَاحنْذْ أَذْ زَّايْسنْ ث أَرْبُونْ. إِڭَّا إِ-ث س ثْفڒْوِينْ أَكْ-ذ ڒْخَاوِي ذِي ذَاخڒْ نْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","إِڭَّا ثَابَانْيُوثْ ن نّْحَاسْ س ؤُضَارْ نّسْ ن نّْحَاسْ زِي ثِيسِيثِينْ ن ثرْبِيعِينْ ن ثمْغَارِينْ نِّي خذْمنْثْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","إِڭَّا ڒمْرَاحْ. غَارْ جِّيهثْ ن لْجَانُوبْ، غَارْ يفُوسْ، ثُوغَا ثُوزّڭَّارْثْ ن ڒِْيزَارَاثْ ن ڒمْرَاحْ مْيَا ن إِغَادْجنْ ن ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","عِيشْرِينْ ن إِپِيلَارنْ نّسْ ذ عِيشْرِينْ ن ثْيَارْسَاوِينْ نْسنْ ثُوغَا أَثنْ ن نّْحَاسْ. ثِيسنَّارِينْ ن إِپِيلَارنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي ثُوغَا أَثنْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","غَارْ ؤُغزْذِيسْ ن شَّامَالْ ثُوغَا ذِينْ ڒِيزَارَاثْ س إِشْثْ ن ثُوزّڭَّارْثْ ن مْيَا ن إِغَادْجنْ أَكْ-ذ عِيشْرِينْ ن إِپِيلَارنْ نْسنْثْ ؤُ أَكْ-ذ عِيشْرِينْ ن ثْيَارْسَاوِينْ نْسنْ ن نّْحَاسْ. ثِيسنَّارِينْ ن إِپِيلَارنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي ثُوغَا أَثنْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","غَارْ ؤُغزْذِيسْ ن ڒْغَارْبْ ثُوغَا ذِينْ ڒِيزَارَاثْ ن خمْسِينْ ن إِغَادْجنْ أَكْ-ذعشْرَا ن إِپِيلَارنْ نْسنْثْ ذعشْرَا ن ثْيَارْسَاوِينْ نْسنْ. ثِيسنَّارِينْ ن إِپِيلَارنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي ثُوغَا أَثنْ ن نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","غَارْ ؤُغزْذِيسْ ن شَّارْقْ، غَارْ جِّيهثْ ن ونْقَارْ ن ثْفُوشْثْ، ثُوغَا ذِينْ ڒِيزَارَاثْ ن خمْسِينْ ن إِغَادْجنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ثُوغَا ڒِيزَارَاثْ غَارْ إِجّْ ن ؤُغزْذِيسْ ن زَّاثْ خمّسْطَاشْ ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ أَكْ-ذ ثْڒَاثَا ن إِپِيلَارنْ نْسنْثْ ذ ثْڒَاثَا ن ثْيَارْسَاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","غَارْ ؤُغزْذِيسْ ن زَّاثْ نّغْنِي ن وَاذَافْ ن ڒمْرَاحْ، غَارْ ؤُغزْذِيسْ-أَ ذ ؤُغزْذِيسْ نِّي، ثُوغَا ڒِيزَارَاثْ ذَايْسنْثْ خمّسْطَاشْ ن إِغَادْجنْ ذِي ثُوزّڭَّارْثْ، أَكْ-ذ ثْڒَاثَا ن إِپِيلَارنْ نْسنْثْ ذ ثْڒَاثَا ن ثْيَارْسَاوِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","مَارَّا ڒِيزَارَاثْ نِّي ذ أَسْ د-إِنّْضنْ إِ ڒمْرَاحْ ثُوغَا أَثنْثْ ن ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ثِييَارْسَاوِينْ ن إِپِيلَارنْ ثُوغَا أَثنْثْ ن نّْحَاسْ ذ ثْسنَّارِينْ ن إِپِيلَارنْ ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي ثُوغَا أَثنْ س نُّوقَارْثْ ؤُشَا ثَاكُورْسِيثْ خْ ثْزدْجِيفِينْ نْسنْ ثُوغَا-ت زِي نُّوقَارْثْ ذ مَارَّا إِپِيلَارنْ ن ڒمْرَاحْ ثُوغَا غَارْسنْ إِقضْبَانْ ن نُّوقَارْثْ إِ ؤُسڒْقِي. ");
INSERT INTO rifa_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","أَرْوَاقْ غَارْ وَاذَافْ ن ڒمْرَاحْ ڭِّينْ ث ذ إِجّْ ن ؤُمُوذِي ن ؤُخيَّاضْ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ثُوزّڭَّارْثْ نّسْ ثُوغَا عِيشْرِينْ ن إِغَادْجنْ ؤُ ڒُوعْڒَا خْ مَارَّا ثِيرُو ن ڒمْرَاحْ خمْسَا ن إِغَادْجنْ، أَمْ ڒِيزَارَاثْ ن ڒمْرَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","أَربْعَا ن إِپِيلَارنْ ذ أَربْعَا ن ثْيَارْسَاوِينْ نْسنْ ثُوغَا أَثنْ س نّْحَاسْ ذ ثْسنَّارِينْ نْسنْ س نُّوقَارْثْ ؤُشَا ثَاكُورْسِيثْ خْ ثْزدْجِيفِينْ نْسنْ ؤُڒَا ذ إِقضْبَانْ نْسنْ إِ ؤُسڒْقِي ثُوغَا أَثنْ س نُّوقَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","مَارَّا ڒوْثَاذْ ن ثْزذِّيغْثْ ذ ڒمْرَاحْ إِ ذ أَسْ د-إِنّْضنْ ثُوغَا أَثنْ س نّْحَاسْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","مَانْ أَيَا ذ مِينْ سُّوفّْغنْ نِيثْنِي إِ ثْزذِّيغْثْ، ثَازذِّيغْثْ ن شّْهَاذثْ، ؤُشَا زمّنْ ث س ڒُومُورْ ن مُوسَا سْ ثْسخَّارْثْ ن إِلَاوِييّنْ، س ؤُفُوسْ ن إِثَامَارْ، مِّيسْ ن هَارُونْ، أَكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","بَاصَالِييِيلْ مِّيسْ ن ؤُرِي، مِّيسْ ن حُورْ، زِي ثقْبِيتْشْ ن يَاهُوذَا، إِڭَّا مَارَّا مِينْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ثُوغَا أَكِيذسْ أَهُولِييَابْ، مِّيسْ ن أَخِيسَامَاكْ، زِي ثقْبِيتْشْ ن دَان. ثُوغَا-ث ذ أَنقَّاشْ ذ بُو-صّنْعثْ، أَخيَّاضْ ن ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ڒقْطنْ أَزْذَاذْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","مَارَّا ؤُرغْ إِ سّْخذْمنْ نِيثْنِي إِ ڒْخذْمثْ غَارْ مَارَّا ڒْخذْمثْ إِ إِڭِّينْ ذِي زَّاوشْثْ إِقدّْسنْ، إِخْسْ أَذْ يِينِي ؤُرغْ ن ثوْهِيبِينْ ن ونْهزِّي، ثُوغَا: ثسْعَا ؤُ-عِيشْرِينْ ثَالِينْثْ ؤُ سبْعَا-مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو عْلَاحْسَابْ شِيقْلُو إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","نُّوقَارْثْ ن يِينِّي إِتّْوَاحسْبنْ ن ثْمسْمُونْثْ ثُوغَا-ت مْيَا ثَالِينْثْ ذ أَڒفْ ؤُ-سبْعَا-مْيَا ؤُ-خمْسَا ؤُ-سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","إِجّْ ن وزْينْ إِ يِيجّْ ن بْنَاذمْ، أَقَا-ث ذ أَزْينْ شِيقْلُو عْلَاحْسَابْ مِينْ د-إِتَّاوِي شِيقْلُو إِقدّْسنْ، زِي مَارَّا وِي إِعْذُونْ غَارْ يِينِّي إِتّْوَاحسْبنْ زِي عِيشْرِينْ ن إِسڭّْوُوسَا سنّجْ، ذ مَانْ أَيَا إِ ستَّا-مْيَا ؤُ-ثڒْثْ-أَڒَافْ ؤُ-خمْسَا-مْيَا ؤُ-خمْسِينْ ن يرْيَازنْ. ");
INSERT INTO rifa_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","مْيَا ثَالِينْثْ ن نُّوقَارْثْ نِّي ثُوغَا أَثنْثْ حِيمَا أَذْ زَّايْسنْثْ سّْفسْينْ ثْيَارْسَاوِينْ ن زَّاوشْثْ إِقدّْسنْ ذ ثْيَارْسَاوِينْ ن ؤُڒحَّافْ: مْيَا ن ثْيَارْسَاوِينْ زِي مْيَا ثَالِينْثْ، إِخْسْ أَذْ يِينِي إِشْثْ ن ثَالِينْثْ إِ يِيشْثْ ن ثْيَارْسَا. ");
INSERT INTO rifa_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","زڭْ وَاڒفْ ؤُ-سبْعَا-مْيَا ؤُ-خمْسَا ؤُ-سبْعِينْ شِيقْلُو إِڭَّا ثِيسنَّارِينْ إِ إِپِيلَارنْ. إِغدْجفْ ثِيزدْجِيفِينْ نْسنْ ؤُشَا إِشدّْ غَارْسنْ إِقضْبَانْ إِ ؤُسڒْقِي. ");
INSERT INTO rifa_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","نّْحَاسْ ن ثوْهِيبِينْ ن ونْهزِّي ثُوغَا-ث سبْعِينْ ثَالِينْثْ ذ أَڒْفَاينْ ؤُ-أَربْعَا-مْيَا شِيقْلُو. ");
INSERT INTO rifa_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","س مَانْ أَيَا إِڭَّا ثْيَارْسَاوِينْ إِ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ذ ؤُعَالْطَارْ ن نّْحَاسْ ذ ثْرَاشَّا نّسْ ن نّْحَاسْ ذ مَارَّا ڒقْشُوعْ ن ؤُعَالْطَارْ ");
INSERT INTO rifa_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ذ ثْيَارْسَاوِينْ ن إِپِيلَارنْ ن ڒمْرَاحْ إِ ذ أَسْ د-إِنّْضنْ ذ ثْيَارْسَاوِينْ ن وَاذَافْ ن ڒمْرَاحْ ذ مَارَّا ڒوْثَاذْ ن ثْزذِّيغْثْ ذ مَارَّا ڒوْثَاذْ ن إِپِيلَارنْ إِ ذ أَسْ د-إِنّْضنْ إِ ڒمْرَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ڭِّينْ عَاوذْ أَرُّوضْ إِ ثْسخَّارْثْ س ؤُفِيڒِي أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ، حِيمَا أَذْ زَّايسْ سخَّارنْ إِكهَّاننْ ذِي زَّاوشْثْ إِقدّْسنْ. عَاوذْ ڭِّينْ أَرُّوضْ إِقدّْسنْ إِ هَارُونْ، أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","إِڭَّا أَپَالْطُو ن ؤُكهَّانْ س إِفِيڒَانْ ن وُورغْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","نِيثْنِي بزّْعنْ ثِيڒْوِيحِينْ ن وُورغْ ؤُشَا قسّنْ زَّايْسنْثْ إِفِيڒَانْ، حِيمَا أَذْ ثنْ خيّْضنْ جَارْ ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ جَارْ ڒقْطنْ أَزْذَاذْ، ذ مَانْ أَيَا ثُوغَا ذ إِشْثْ ن ڒْخذْمثْ أَمْ ت إِتّڭّْ ؤُفنَّانْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ڭِّينْ أَسْ ثِيغَارْضِينْ إِمْسڒْسَاقنْ ؤُشَا سّْمُوننْ أَپَالْطُو غَارْ ثْنَاينْ ن إِخْفَاونْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ثَاحزَّامْثْ إِزوّْقنْ إِ ثُوغَا غَارْ ؤُپَالْطُو نّسْ، ثُوغَا ثڒْسقْ ذَايسْ، ثذْوڒْ ذ إِشْثْ أَكِيذسْ. ثتّْوَاڭّْ ثْحزَّامْثْ س وبْرِيذْ ذ إِجّنْ أَكْ-ذ ؤُپَالْطُو س إِفِيڒَانْ ن وُورغْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","نِيثْنِي ڭِّينْ عَاوذْ إِژْرَا ن ؤُنِيكْسْ، إِنِّي إِتّْوَاطّْفنْ ذِي ثْشُويَارْ ن وُورغْ، نقْشنْ ثنْ أَمْ يِيجّْ ن ونْقَاشْ ن ثْخَاذنْثْ ن ؤُشمِّيعْ س إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","إِڭَّا إِ-ثنْ خْ ثْغَارْضِينْ ن ؤُپَالْطُو، أَمْ إِژْرَا ن ڒِيذَارثْ إِ أَيْثْ ن إِسْرَائِيل، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","إِڭَّا ثَاجْمشْثْ، إِشْثْ ن ڒْخذْمثْ أَمْ ت إِتّڭّْ ؤُفنَّانْ، أَمْ مَامّشْ إِڭَّا أَپَالْطُو، س إِفِيڒَانْ ن وُورغْ ؤُ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ثُوغَا-ت س أَربْعَا ن ثْغمُّورَا. ضفْسنْ ثَاجْمشْثْ. ثُوغَا ثُوزّڭَّارْثْ نّسْ ذ إِجّْ ن وزْينْ ن ؤُغِيڒْ ؤُشَا ؤُڒَا ذ ثِيرُو نّسْ ذ إِجّْ ن وزْينْ ن ؤُغِيڒْ. ثُوغَا إِضْفسْ خْ ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ستّْفنْ ذَايسْ أَربْعَا ن ڒصْفُوفْ ن يژْرَا: إِجّْ ن صّفْ س يِيجّْ ن ڒعْقِيقْ ذ أَزڭّْوَاغْ ذ إِشْثْ ن ثْيَاقُوثْ ذ يِيشْثْ ن سْمَارَاخْثْ. ذ وَا ذ صّفْ أَمزْوَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","صّفْ وِيسّْ ثْنَاينْ س يِيجّْ ن كَارْبُونْكلْ ذ يِيجّْ ن صَافِّيرْ أَزِيزَا ذ يِيجّْ ن ذِيأَمَانْثِي. ");
INSERT INTO rifa_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","صّفْ وِيسّْ ثْڒَاثَا س يِيجّْ ن وژْرُو ن يَاسِينْثُو ذ يِيجّْ ن أَخَاثْ ذ يِيجّْ ؤُمَاثِيسْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","صّفْ وِيسّْ أَربْعَا س يِيشْثْ ن ثخْرِيسُولِيثْ ذ يِيجّْ ن ؤُنِيكْسْ ذ يِيجّْ ن يَاسْبِيسْ. ثُوغَا تّْوَاطّْفنْ ذِي ثْشُويَارْ نْسنْ ن وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","إِژْرَا ثُوغَا خَاسنْ إِسْمَاونْ ن أَيْثْ ن إِسْرَائِيل، ثنْعَاشْ ن يژْرَا عْلَاحْسَابْ إِسْمَاونْ نْسنْ، س إِنقَّاشنْ ن إِجّْ ن ؤُشمِّيعْ، كُوڒْ أَنقَّاشْ أَكْ-ذ يِيسمْ نّسْ إِ ذ أَسْ د-يُوسِينْ. أَقَا أَثنْ إِ ثنْعَاشْ ن ثْقبَّاڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","غَارْ إِخْفَاونْ ن ثجْمشْثْ ڭِّينْ ثِيسدّْيِينْ س وُورغْ إِصْفَانْ، ثِينِّي إِمُوذنْ أَمْ يِيجّْ ن ؤُفِيڒُو. ");
INSERT INTO rifa_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ڭِّينْ ثْنَاينْ ن ثْشُويَارْ ن وُورغْ ذ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ ؤُشَا شدّنْ ثْنَاينْ ن ثخْرَازِينْ غَارْ ثْنَاينْ ن إِخْفَاونْ ن ثجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","شدّنْ ثْنَاينْ ن سّْنَاسڒْ إِمُوذنْ ن وُورغْ غَارْ ثْنَاينْ ن ثخْرَازِينْ غَارْ إِخْفَاونْ ن ثجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ثْنَاينْ ن إِخْفَاونْ نّغْنِي ن ثْنَاينْ ن سّْنَاسڒْ إِمُوذنْ، شدّنْ ثنْ غَارْ ثْنَاينْ ن ثْشُويَارْ ؤُشَا وْشِينْ ثنْ خْ طْغَارْضِينْ ن ؤُپَالْطُو، ذڭْ وُوذمْ ن زَّاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ڭِّينْ عَاوذْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ، شدّنْ ثنْثْ غَارْ ثْنَاينْ ن إِخْفَاونْ نّغْنِي ن ثجْمشْثْ، ذِي ثْمَا نّسْ نِّي قِيبَاتْشْ إِ ؤُپَالْطُو، غَارْ ذَاخڒْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ڭِّينْ عَاوذْ ثْنَاينْ ن ثخْرَازِينْ ن وُورغْ، شدّنْ ثنْثْ خْ ثْنَاينْ ن ثْغَارْضِينْ ن ؤُپَالْطُو ن ؤُكهَّانْ، سْوَادَّايْ، غَارْ زَّاثْ، قِيبَاتْشْ إِ ؤُسڒْقِي نّسْ غَارْ سنّجْ إِ ثْحزَّامْثْ إِزوّْقنْ ن ؤُپَالْطُو. ");
INSERT INTO rifa_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ؤُشَا شدّنْ ثَاجْمشْثْ س ثخْرَازِينْ نّسْ غَارْ ثخْرَازِينْ ن ؤُپَالْطُو ن ؤُكهَّانْ أَكْ-ذ إِجّْ ن ؤُفِيڒُو أَذحْمِي أَڒَامِي إِذْوڒْ سنّجْ إِ ثْحزَّامْثْ إِزوّْقنْ ن ؤُپَالْطُو، ؤُشَا خنِّي وَارْ ثْبطِّي ثجْمشْثْ خْ ؤُپَالْطُو، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","إِڭَّا عَاوذْ أَسڒْهَامْ ن ؤُپَالْطُو ن ؤُكهَّانْ أَمْ مَامّشْ ث إِتّڭّْ ؤُخيَّاضْ، ثُوغَا-ث ذ أَذحْمِي مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","أَرْزَامْ ن ؤُسڒْهَامْ ثُوغَا-ث ذِي ڒْوسْطْ نّسْ أَمْ مَامّشْ ڭِّينْ أَرْزَامْ ن يِيرِي ن وَارُّوضْ ن وُوزَّاڒْ ن ؤُعسْكَارِي. ذڭْ ونّضْ ن وَارْزَامْ ثُوغَا ذِينْ إِشْثْ ن ثْمَا، حِيمَا وَارْ إِتّْشَارِّيڭْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","غَارْ ثْمُووَّا ن وَادَّايْ ن ؤُسڒْهَامْ ڭِّينْ ثِيرمَّانِينْ س ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ زڭْ إِفِيڒَانْ إِمُوذنْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ڭِّينْ عَاوذْ نّْوَاقسْ ن وُورغْ إِصْفَانْ ؤُشَا سَّارْسنْ نّْوَاقسْ نِّي جَارْ ثْرمَّانِينْ غَارْ ثْمُووَّا ن وَادَّايْ ن ؤُسڒْهَامْ، ذڭْ ونّضْ جَارْ ثْرمَّانِينْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","إِجّْ ن نَّاقُوسْ ذ إِشْثْ ن ثْرمَّانْثْ، خنِّي عَاوذْ إِجّْ ن نَّاقُوسْ ذ إِشْثْ ن ثْرمَّانْثْ غَارْ ثْمُووَّا ن وَادَّايْ ن ؤُسڒْهَامْ ذڭْ ونّضْ، مَاحنْذْ أَذْ ذَايسْ ڭّنْ ثَاسخَّارْثْ نْسنْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ڭِّينْ ثْشَامِيرْ إِ هَارُونْ ذ وَارَّاوْ نّسْ س ڒقْطنْ أَزْذَاذْ، أَمْ مَامّشْ ث إِتّڭّْ ؤُخيَّاضْ، ");
INSERT INTO rifa_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","أَرژّثْ ن ڒقْطنْ أَزْذَاذْ ذ ثْشُوشَّايْ إِزوّْقنْ ن ڒقْطنْ أَزْذَاذْ ذ سّْرَاوڒْ ن ڒقْطنْ س ڒقْطنْ أَزْذَاذْ إِمُوذنْ ");
INSERT INTO rifa_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ؤُ ثُوغَا ثَاحزَّامْثْ ن ڒقْطنْ أَزْذَاذْ إِمُوذنْ ؤُ ن ؤُفِيڒُو أَذحْمِي ذ ؤُرْجُووَانِي ذ ؤُزڭّْوَاغْ إِحذْقنْ، أَقَا-ت ذ إِجّْ ن ؤُمُوذِي ن ؤُخيَّاضْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ڭِّينْ ثَاڒْوِيحْثْ س نُّووَارْ ن تَّاجْ إِقدّْسنْ ن وعْزَاڒْ س وُورغْ إِصْفَانْ ؤُشَا نقْشنْ ذَايسْ ثِيرَا-يَا: ”أَمْقدَّاسْ إِ سِيذِي!“، أَمْ مَامّشْ نقْشنْ ثَاخَاذنْثْ ن ؤُشمِّيعْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ؤُشَا شدّنْ أَسْ إِجّْ ن ؤُفِيڒُو إِمُوذنْ أَذحْمِي، حِيمَا أَذْ ت أَيْڒنْ سنّجْ إِ أَرژّثْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","أَمُّو إِ ثْكمّڒْ مَارَّا ڒْخذْمثْ ن ثْزذِّيغْثْ، أَقِيضُونْ ن ؤُمْسَاڭَارْ. أَيْثْ ن إِسْرَائِيل أَقَا ڭِّينْ ت أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا، أَمُّو إِ ت ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","كْسِينْ ثَازذِّيغْثْ غَارْ مُوسَا، أَقِيضُونْ ذ مَارَّا ڒقْشُوعْ نّسْ ذ ثْسنَّارِينْ نّسْ ذ ثْفڒْوِينْ نّسْ ذ ثْحنْيَا نّسْ ن ؤُعَارّضْ ذ إِپِيلَارنْ نّسْ ذ ثْيَارْسَاوِينْ نّسْ ");
INSERT INTO rifa_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ذ ثْسقَّافْثْ ن إِڒْمَاونْ إِزڭّْوَاغنْ ن إِشَارِّييّنْ ذ ثْسقَّافْثْ ن إِڒْمَاونْ ن دّنْفِيڒَاثْ ذ ؤُڒحَّافْ إِ دُّورِي، ");
INSERT INTO rifa_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","تَّابُوثْ ن شّْهَاذثْ ذ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ ذ ثْقبَّارْثْ ن وصْڒَاحْ ");
INSERT INTO rifa_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ذ ثَازوْضَا أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ ذ وغْرُومْ ن وسْشَانْ ");
INSERT INTO rifa_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ذ ڒْقنْذِيڒْ ن وُورغْ إِصْفَانْ ذ ڒفْنَارَاثْ نّسْ - ڒفْنَارَاثْ نِّي ثُوغَا إِتّْخصَّا أَذْ تّْوَاسّْوجْذنْثْ، ذ مَارَّا ڒقْشُوعْ نّسْ ذ زّشْثْ إِ ثْفَاوْثْ - ");
INSERT INTO rifa_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ذ ؤُعَالْطَارْ ن وُورغْ ذ زّشْثْ إِ وذْهَانْ ذ ڒبْخُورْ إِتّْفُوحنْ ذ أَرْوَاقْ إِ وَاذَافْ ن ؤُقِيضُونْ ");
INSERT INTO rifa_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ذ ؤُعَالْطَارْ ن نّْحَاسْ س ثْرَاشَّا ن نّْحَاسْ ذ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ ذ مَارَّا ڒقْشُوعْ نّسْ ذ ثْبَانْيُوثْ أَكْ-ذ ؤُضَارْ نّسْ ");
INSERT INTO rifa_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ذ ڒِيزَارَاثْ ن ڒمْرَاحْ أَكْ-ذ إِپِيلَارنْ نْسنْثْ ذ ثْيَارْسَاوِينْ نْسنْ، ؤُڒَا ذ أَرْوَاقْ ن وَاذَافْ ن ڒمْرَاحْ ذ إِفِيڒَانْ نّسْ ذ ڒوْثَاذْ نّسْ ذ مَارَّا ڒقْشُوعْ إِ ثْسخَّارْثْ ن ثْزذِّيغْثْ، إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ");
INSERT INTO rifa_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ؤُڒَا ذ أَرُّوضْ إِ ثْسخَّارْثْ، حِيمَا أَذْ زَّايسْ سخَّارنْ إِكهَّاننْ ذِي زَّاوشْثْ إِقدّْسنْ، أَرُّوضْ إِقدّْسنْ إِ ؤُكهَّانْ هَارُونْ ذ أَرُّوضْ إِ وَارَّاوْ نّسْ، حِيمَا أَذْ سخَّارنْ ذ إِكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ڭِّينْ أَيْثْ ن إِسْرَائِيل مَارَّا ڒْخذْمثْ أَمْ مَامّشْ مَارَّا إِ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","إِخْزَارْ مُوسَا غَارْ مَارَّا ڒْخذْمثْ ؤُشَا إِژْرَا بلِّي ثتّْوَاڭّْ أَمْ مَامّشْ يُومُورْ سِيذِي، وَاهْ، أَمُّو إِ-ت ڭِّينْ. ؤُشَا إِبَارْكْ إِ-ثنْ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","”ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ أَمزْوَارُو أَذْ ثسّْڭعّْذذْ ثَازذِّيغْثْ، أَقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","أَذْ ذَايسْ ثڭّذْ تَّابُوثْ ن شّْهَاذثْ ؤُشَا أَذْ ثذْڒذْ تَّابُوثْ س ؤُڒحَّافْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","أَذْ ثسِّيذْفذْ ثَازوْضَا ؤُشَا أَذْ ت ثْستّْفذْ أَستّفْ نّسْ. أَذْ ثسِّيذْفذْ ڒْقنْذِيڒْ ؤُشَا أَذْ ثسِّيغذْ ڒفْنَارَاثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","أَذْ ثسَّارْسذْ أَعَالْطَارْ ن وُورغْ إِ ڒبْخُورْ زَّاثْ إِ تَّابُوثْ ن شّْهَاذثْ ؤُشَا أَذْ ثڭّذْ أَرْوَاقْ ن وَاذَافْ زَّاثْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","أَذْ ثسَّارْسذْ أَعَالْطَارْ ن وشْمَاضْ زَّاثْ إِ وَاذَافْ ن ثْزذِّيغْثْ، أَقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","أَذْ ثسَّارْسذْ ثَابَانْيُوثْ جَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ذ ؤُعَالْطَارْ ؤُشَا أَذْ ذَايسْ ثڭّذْ أَمَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","أَذْ ثسّْبدّذْ ڒمْرَاحْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ ؤُشَا أَذْ ثَايْڒذْ أَرْوَاقْ ن وَاذَافْ ن ڒمْرَاحْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","أَذْ ثكْسِيذْ زّشْثْ إِ وذْهَانْ ؤُشَا أَذْ ثْذهْنذْ ثَازذِّيغْثْ ذ مَارَّا مِينْ ذَايسْ إِدْجَانْ. أَذْ ت ثسّْقدّْسذْ أَكْ-ذ مَارَّا ڒقْشُوعْ نّسْ. أَذْ ثِيڒِي نتَّاثْ ذ ثَامْقدَّاسْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","أَذْ ثْذهْنذْ أَعَالْطَارْ ن وشْمَاضْ س مَارَّا ڒقْشُوعْ نّسْ. أَذْ ثسّْقدّْسذْ أَعَالْطَارْ. أَعَالْطَارْ أَذْ يِيڒِي ذ أَمْقدَّاسْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","أَذْ ثْذهْنذْ ثَابَانْيُوثْ ذ ؤُضَارْ نّسْ ؤُشَا أَذْ ت ثسّْقدّْسذْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","أَذْ د-ثسّْقَارّْبذْ هَارُونْ ذ وَارَّاوْ نّسْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ ثنْ ثسِّيرْذذْ س وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","أَذْ ثسّْيَارْضذْ إِ هَارُونْ أَرُّوضْ إِقدّْسنْ ؤُشَا أَذْ ث ثْذهْنذْ ؤُشَا أَذْ ث ثسّْقدّْسذْ، مَاحنْذْ أَذْ أَيِي يِيڒِي ذ أَكهَّانْ إِ نشّْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","خنِّي أَذْ د-ثسّْقَارّْبذْ إِحنْجِيرنْ نّسْ ؤُشَا أَذْ أَسنْ ثْيَارْضذْ ثْشَامِيرَاثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","أَذْ ثنْ ثْذهْنذْ أَمْ مَامّشْ ثْذهْنذْ بَابَاثْسنْ، مَاحنْذْ أَذْ أَيِي سخَّارنْ أَمْ يِيكهَّاننْ. أَذْ يِيڒِي وذْهَانْ نْسنْ إِ نِيثْنِي ذ إِشْثْ ن ثُوكهَّانْثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","إِڭَّا مُوسَا مَارَّا أَمْ مَامّشْ يُومُورْ سِيذِي، وَاهْ، أَمُّو إِ ث إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","إِمْسَارْ ذڭْ ؤُيُورْ أَمزْوَارُو ن ؤُسڭّْوَاسْ وِيسّْ ثْنَاينْ، ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ، أَقَا سّْڭعّْذنْ ثَازذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","مُوسَا إِسّْڭعّذْ ثَازذِّيغْثْ، إِسَّارْسْ ثِييَارْسَاوِينْ نّسْ، إِڭَّا ذَايْسنْثْ ثِيفڒْوِينْ، إِڭَّا خَاسنْثْ ثِيحنْيَا ن ؤُعَارّضْ ثِينِّي خَاسنْثْ إِژْوَانْ، ؤُشَا إِسّْبدّْ إِپِيلَارنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","إِبزّعْ أَقِيضُونْ خْ ثْزذِّيغْثْ ؤُشَا إِسَّارْسْ خَاسْ ثَاسقَّافْثْ ن ؤُقِيضُونْ أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","إِكْسِي شّْهَاذثْ ؤُشَا إِسَّارْسْ إِ-ت ذَاخڒْ ذِي تَّابُوثْ ؤُشَا إِشدّْ إِعُومَاذْ إِ ثَاربُّوثْ غَارْ تَّابُوثْ ؤُشَا إِسَّارْسْ ثَاقبَّارْثْ ن وصْڒَاحْ خْ تَّابُوثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","إِسِّيذفْ تَّابُوثْ ذِي ثْزذِّيغْثْ ؤُشَا يُويڒْ أَڒحَّافْ أَمْ دُّورِي ؤُشَا إِسّْذُورِييْ تَّابُوثْ ن شّْهَاذثْ أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","إِسَّارْسْ ثَازوْضَا ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، غَارْ ؤُغزْذِيسْ ن شَّامَالْ ن ثْزذِّيغْثْ، غَارْ بَارَّا ن ؤُڒحَّافْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","إِستّفْ خَاسْ أَغْرُومْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","إِسَّارْسْ ڒْقنْذِيڒْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، نِيشَانْ ذڭْ ؤُرنْذَاذْ ن ثْزوْضَا، غَارْ جِّيهثْ ن لْجَانُوبْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","إِسَّارْسْ خَاسْ ثِيفْثِيڒِينْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","إِوْشَا أَمْشَانْ إِ ؤُعَالْطَارْ ن وُورغْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ زَّاثْ إِ ؤُڒحَّافْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","إِسّْبخَّارْ خَاسْ ڒبْخُورْ إِتّْفُوحنْ أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","يُويڒْ أَرْوَاقْ غَارْ وَاذَافْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","إِوْشَا أَمْشَانْ إِ ؤُعَالْطَارْ ن وشْمَاضْ غَارْ وَاذَافْ ن ثْزذِّيغْثْ، أَقِيضُونْ ن ؤُمْسَاڭَارْ. إِسّْبخَّارْ خَاسْ ثَاغَارْصْثْ ن وشْمَاضْ ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","إِسَّارْسْ ثَابَانْيُوثْ جَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ذ ؤُعَالْطَارْ. إِڭَّا ذَايسْ أَمَانْ إِ ؤُسِيرْذْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","مُوسَا ذ هَارُونْ ذ وَارَّاوْ نّسْ سِّيرْذنْ زَّايسْ إِفَاسّنْ ذ إِضَارنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ڒَامِي ثُوغَا تَّاذْفنْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُ ڒَامِي د-تّْقَارَّابنْ غَارْ ؤُعَالْطَارْ، سِّيرْذنْ إِخفْ نْسنْ أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","غَارْ مَارَّا إِغزْذِيسنْ ن ثْزذِّيغْثْ ذ ؤُعَالْطَارْ إِتّْوَاڭّْ أَسْ-د ڒمْرَاحْ ؤُشَا يُويڒْ نتَّا أَرْوَاقْ ن وَاذَافْ ن ڒمْرَاحْ. أَمُّو إِ إِكمّڒْ مُوسَا ڒْخذْمثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","خنِّي إِذْڒَا ؤُسيْنُو أَقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَعُودْجِي ن سِيذِي إِشُّورْ ثَازذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","وَارْ إِزمَّارْ مُوسَا أَذْ يَاذفْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مِينْزِي أَسيْنُو يَارْسَا خَاسْ ؤُ أَعُودْجِي ن سِيذِي إِشُّورْ ثَازذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ڒَامِي د-إِڭعّذْ ؤُسيْنُو زِي سنّجْ ن ثْزذِّيغْثْ، فسْينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ ؤُشَا أَمُّو مُوطّْينْ زڭْ ومْشَانْ غَارْ ومْشَانْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","مَاڒَا وَارْ د-إِڭعّذْ ؤُسيْنُو، وَارْ فسْينْ إِقِيضَانْ نْسنْ أَڒْ أَسّْ إِ ذِي ثُوغَا إِتّْڭعّذْ. ");
INSERT INTO rifa_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","مِينْزِي أَسيْنُو ن سِيذِي ثُوغَا يَارْسَا خْ ثْزذِّيغْثْ س ؤُزِيڒْ ؤُشَا ذِي دْجِيڒثْ ثُوغَا ثِيمسِّي زَّاثْ إِ ثِيطَّاوِينْ ن مَارَّا ثَادَّارْثْ ن إِسْرَائِيل ذڭْ إِمُوطُّوينْ نْسنْ زڭْ ومْشَانْ غَارْ ومْشَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","إِڒَاغَا إِ مُوسَا ؤُشَا إِسِّيوڒْ سِيذِي أَكِيذسْ زڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’مَاڒَا إِسّْقَارّبْ إِجّْ ن بْنَاذمْ زَّايْومْ ثَاوْهِيبْثْ إِ سِيذِي، خنِّي أَذْ د-ثسّْقَارّْبمْ ثَاوْهِيبْثْ نْومْ زِي ڒبْهَايمْ، زڭْ إِفُونَاسنْ ذ ثْفُونَاسِينْ نِيغْ زڭْ وُودْجِي. ");
INSERT INTO rifa_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","مَاڒَا ثَاوْهِيبْثْ نّسْ ذ ثَاغَارْصْثْ ن وشْمَاضْ زڭْ إِفُونَاسنْ ذ ثْفُونَاسِينْ، خنِّي أَذْ د-إِسّْقَارّبْ إِجّْ ن ؤُوْثمْ إِشْنَانْ قَاعْ. أَذْ ث يِيوِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مَاحنْذْ أَذْ يَافْ أَرْضَا زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","أَذْ يڭّْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ثْغَارْصْثْ ن وشْمَاضْ ؤُشَا أَمُّو إِ غَا ثتّْوَاقْبڒْ ثْغَارْصْثْ س أَرْضَا ذِي طّْوعْ نّسْ، مَاحنْذْ أَذْ يِيڒِي إِ وصْڒَاحْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","أَذْ إِغَارْصْ إِ ؤُمژْيَانْ ن ؤُفُونَاسْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَرَّاوْ ن هَارُونْ، إِكهَّاننْ، أَذْ د-إِوْينْ إِذَامّنْ، أَذْ زدْجْعنْ إِذَامّنْ غَارْ مَارَّا إِغزْذِيسنْ خْ ؤُعَالْطَارْ نِّي إِدْجَانْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","أَذْ إِكّسْ ثِيڒْمشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ ؤُشَا أَذْ إِبْضَا أَفُونَاسْ ذ إِشدْجِيقنْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","أَرَّاوْ ن أَكهَّانْ هَارُونْ أَذْ سَّارْغنْ ثِيمسِّي خْ ؤُعَالْطَارْ ؤُشَا أَذْ ستّْفنْ أَكشُّوضْ خْ ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","أَرَّاوْ ن هَارُونْ، إِكهَّاننْ، أَذْ ستّْفنْ إِشدْجِيقنْ ذ ؤُزدْجِيفْ ذ ثَاذُونْثْ خْ ؤُكشُّوضْ نِّي إِدْجَانْ خْ ثْمسِّي إِ إِدْجَانْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","نتَّا أَذْ إِسِّيرْذْ أَذَانْ نّسْ ذ إِضَارنْ نّسْ س وَامَانْ. أَكهَّانْ أَذْ إِسّْبخَّارْ مَانْ أَيَا مَارَّا خْ ؤُعَالْطَارْ، أَقَا ذ ثَاغَارْصْثْ ن وشْمَاضْ، ذ ثَاوْهِيبْثْ ن ثْمسِّي، ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","مَاڒَا ثَاوْهِيبْثْ نّسْ ذ ثَاغَارْصْثْ ن وشْمَاضْ زڭْ وُودْجِي، زڭْ إِحُوڒِييّنْ نِيغْ زڭْ إِغَايْضنْ، خنِّي إِتّْخصَّا أَذْ د-إِسّْقَارّبْ أَوْثمْ إِشْنَانْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","أَذْ أَسْ إِغَارْصْ زَّاثْ إِ وُوذمْ ن سِيذِي غَارْ ؤُغزْذِيسْ ن شَّامَالْ ن ؤُعَالْطَارْ ؤُشَا أَرَّاوْ ن هَارُونْ، إِكهَّاننْ، أَذْ زدْجْعنْ إِذَامّنْ نّسْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","أَذْ ث إِبْضَا ذ إِشدْجِيقنْ، أَكْ-ذ أَزدْجِيفْ نّسْ ذ ثَاذُونْثْ نّسْ، ؤُشَا أَكهَّانْ أَذْ ثنْ إِستّفْ خْ ؤُكشُّوضْ نِّي إِدْجَانْ خْ ثْمسِّي إِ إِدْجَانْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","أَذْ إِسِّيرْذْ أَذَانْ نّسْ ذ إِشكْرَاذنْ نّسْ س وَامَانْ. أَكهَّانْ أَذْ يَاوِي مَانْ أَيَا مَارَّا ؤُ أَذْ ث إِسّْبخَّارْ خْ ؤُعَالْطَارْ. أَقَا ذ إِشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ، إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي، إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","مَاڒَا ثَاوْهِيبْثْ نّسْ ذ ثَاغَارْصْثْ ن وشْمَاضْ زڭْ إِجْضَاضْ إِ سِيذِي، خنِّي أَذْ يَاوِي ثَاوْهِيبْثْ نّسْ زِي ثجْلِيلِّيحِينْ نِيغْ زڭْ إِذْبِيرنْ إِمژْيَاننْ. ");
INSERT INTO rifa_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","أَكهَّانْ أَذْ ث يَاوِي غَارْ ؤُعَالْطَارْ، أَذْ أَسْ إِكّسْ أَزدْجِيفْ ؤُشَا أَذْ ث إِسّْبخَّارْ خْ ؤُعَالْطَارْ. أَذْ إِژمّْ إِذَامّنْ نّسْ خْ ؤُغزْذِيسْ ن ؤُعَالْطَارْ ");
INSERT INTO rifa_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ؤُشَا أَذْ أَسْ إِكّسْ أَسيْرُو أَكْ-ذ مِينْ ذَايسْ إِقِّيمنْ ؤُ أَذْ إِنْضَارْ أَيَا زَّاثْ إِ ؤُعَالْطَارْ غَارْ ؤُغزْذِيسْ ن شَّارْقْ خْ ومْشَانْ ن إِغّضْ ن مِينْ إِقِّيمنْ ن ثَاذُونْثْ ");
INSERT INTO rifa_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","أَذْ ث إِشَارّڭْ غَارْ وفْرِيونْ، مَاشَا وَارْ ث إِبطِّي شَا قَاعْ، ؤُشَا أَكهَّانْ أَذْ ث إِسّْبخَّارْ خْ ؤُعَالْطَارْ، خْ ؤُكشُّوضْ نِّي إِدْجَانْ خْ ثْمسِّي. أَقَا ذ إِشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ، ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي، ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","”مَاڒَا إِقدّمْ حذْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ غَارْ سِيذِي، أَذْ ثِيڒِي ثوْهِيبْثْ نّسْ ن وَارنْ أَزْذَاذْ ؤُشَا أَذْ خَاسْ إِسيّبْ زّشْثْ ؤُشَا أَذْ خَاسْ إِسَّارْسْ جَّاوِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","أَذْ ت يَاوِي غَارْ وَارَّاوْ ن هَارُونْ، إِكهَّاننْ، ؤُشَا أَذْ زَّايسْ إِكْسِي ؤُكهَّانْ إِجّْ ن وُورُو إِشُّورْ زڭْ وَارنْ أَزْذَاذْ نِّي ؤُ زِي زّشْثْ نِّي أَكْ-ذ مَارَّا جَّاوِي، ؤُشَا أَكهَّانْ أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ إِ ڒِيذَارثْ إِ ثوْهِيبْثْ نِّي، أَقَا ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","مِينْ إِقِّيمنْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ أَذْ يِيڒِي إِ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ. أَقَا ذ أَمْقدَّاسْ قَاعْ زِي مَارَّا ثِيوْهِيبِينْ ن ثْمسِّي ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","مَاڒَا ثْقدّْمذْ ثَاوْهِيبْثْ إِ إِدْجَانْ ذ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ذَارْحنْ ت ذِي ثفْقُونْثْ، خنِّي أَذْ ثِيڒِي ذ ڒمْسمْنَاثْ بْڒَا أَنْثُونْ، إِخدْجْضنْ س زّشْثْ، ؤُڒَا ذ ثِيڒْفَافْ بْڒَا أَنْثُونْ تّْوَاذهْننْثْ س زّشْثْ، مَارَّا زڭْ وَارنْ أَزْذَاذْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","مَاڒَا ثَاوْهِيبْثْ نّشْ ذ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ڭّْوِينْ ت خْ وخْذِيمْ، أَذْ ثِيڒِي ن وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ، وَارْذَايسْ بُو ونْثُونْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","أَذْ ثنْ ثَارْژذْ ذ إِفثْوِيثنْ ؤُشَا أَذْ خَاسْ ثْسيّْبذْ زّشْثْ. أَقَا-ت ذ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","مَاڒَا ثَاوْهِيبْثْ نّشْ ذ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ڭّْوِينْ ت ذِي طَّاجِّينْ، أَذْ ثِيڒِي ثوْجذْ س وَارنْ أَزْذَاذْ أَكْ-ذ زّشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ثَاوْهِيبْثْ ن ڒْغِيدْجثْ إِ زَّايْسنْ إِوجْذنْ، أَذْ ت ثَاوْيذْ غَارْ سِيذِي. بْنَاذمْ أَذْ زَّايسْ د-إِقَارّبْ غَارْ ؤُكهَّانْ ؤُشَا وَانِيثَا أَذْ ت يَاوِي غَارْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","أَذْ إِكْسِي ؤُكهَّانْ زِي ثوْهِيبْثْ ن ڒْغِيدْجثْ إِشْثْ ن ڒِيذَارثْ ؤُشَا أَذْ ت إِسّْبخَّارْ خْ ؤُعَالْطَارْ، أَقَا ذ ثَاوْهِيبْثْ ن ثْمسِّي، ذ ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","مِينْ إِقِّيمنْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ أَذْ يِيڒِي إِ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ. أَقَا-ث ذ أَمْقدَّاسْ قَاعْ زِي ثوْهِيبِينْ ن ثْمسِّي ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","وَارْ إِعدّڒْ إِ ؤُڒَا ذ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ إِ غَا ثْقدّْممْ إِ سِيذِي أَذْ ثِيڒِي ثوْجذْ س ونْثُونْ. مَاغَارْ زِي مِينْ مَا ن ونْثُونْ ذ زِي مِينْ مَا ثَامّنْثْ وَارْ زَّايسْ ثسّْبخَّارَامْ شَا ؤُڒَا ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","أَذْ ثِيوْيمْ ثَاوْهِيبْثْ ن ؤُسُوفّغْ أَمزْوَارُو ن صَّابثْ غَارْ سِيذِي، مَاشَا نِيثْنِي وَارْ زمَّارنْ أَذْ سّْبخَّارنْ ثَاوْهِيبْثْ-أَ خْ ؤُعَالْطَارْ أَمْ ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","كُوڒْ ثَاوْهِيبْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ نّشْ أَذْ ثِيڒِي ثْمدْجْحذْ س ثْمدْجَاحْطْ. ثَامدْجَاحْثْ ن ڒْعَاهْذْ ن أَربِّي نّشْ وَارْ ثْزمَّارْ أَذْ ثنْقصْ غَارْ ثوْهِيبْثْ ن ڒْغِيدْجثْ نّشْ. أَذْ ثْقدّْمذْ ثَامدْجَاحْثْ غَارْ كُوڒْ ثَاوْهِيبْثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","مَاڒَا ثِيوْيذْ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ ن ثْمنْزُوثْ، أَذْ ثِيوْيذْ ثِيذْرِينْ يِيوْضنْ، ثِينِّي إِتّْوَافَارنْ خْ ثْمسِّي، أَكْ-ذ ڒْحبّْ أَزِيزَا إِبَارْينْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ زِي ثْمنْزُوثْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","أَذْ خَاسْ ثْسيّْبذْ زّشْثْ ؤُ أَذْ خَاسْ ثسَّارْسذْ جَّاوِي، أَقَا ذ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","خنِّي أَذْ إِسّْبخَّارْ ؤُكهَّانْ إِجّْ ن وزْينْ زِي ڒْحبّْ إِبَارْينْ ؤُ زِي زّشْثْ نّسْ أَكْ-ذ مَارَّا جَّاوِي نّسْ إِ خَاسْ إِدْجَانْ أَمْ ثوْهِيبْثْ ن ڒِيذَارثْ ذِي مَانْ أَيَا. أَقَا ذ ثَاوْهِيبْثْ ن ثْمسِّي إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","”مَاڒَا ثَاوْهِيبْثْ نّسْ ذ ثَاغَارْصْثْ ن ڒهْنَا، إِتّْخصَّا، مَاڒَا خنِّي إِسّْقَارّبْ-د أَمُودَّارْ، أَذْ يِيڒِي ذ أَوْثمْ نِيغْ ذ ثَاوْثمْثْ ن إِفُونَاسنْ ذ ثْفُونَاسِينْ، أَذْ د-إِسّْقَارّبْ إِجّْ ن ؤُمُودَّارْ إِشْنَانْ قَاعْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ثوْهِيبْثْ نّسْ ؤُشَا أَذْ أَسْ إِغَارْصْ قِيبَاتْشْ إِ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَرَّاوْ ن هَارُونْ، إِكهَّاننْ، أَذْ زدْجْعنْ إِذَامّنْ نّسْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","زِي ثوْهِيبْثْ ن ڒهْنَا أَذْ إِقدّمْ إِشْثْ ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي، إِخْسْ أَذْ يِينِي ثَاذُونْثْ إِ إِذْڒِينْ أَذَانْ ذ مَارَّا ثَاذُونْثْ إِ إِدْجَانْ خْ وَاذَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","أَذْ إِكّسْ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ غَارْ ثجْعِينَّا ؤُڒَا ذ مِينْ يُويْڒنْ غَارْ ثْسَا ؤُ يَارْسَا خْ ثِيژَّاڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","أَرَّاوْ ن هَارُونْ أَذْ سّْبخَّارنْ أَيَا خْ ؤُعَالْطَارْ خْ ثْغَارْصْثْ ن وشْمَاضْ إِ إِدْجَانْ خْ ؤُكشُّوضْ إِ ذِينْ إِدْجَانْ خْ ثْمسِّي. أَقَا-ث ذ ثَاوْهِيبْثْ ن ثْمسِّي، ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","مَاڒَا ثَاوْهِيبْثْ نّسْ ذ ثَاغَارْصْثْ ن ڒهْنَا إِ سِيذِي، أَوْثمْ نِيغْ ذ ثَاوْثمْثْ ن وُودْجِي، خنِّي أَذْ د-إِسّْقَارّبْ إِجّْ ن ؤُمُوذَارْ إِشْنَانْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","مَاڒَا ذ ؤُحُوڒِي إِ د-إِسّْقَارّبْ ذ ثَاغَارْصْثْ، خنِّي أَذْ ث-إِ-د إِسّْقَارّبْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","نتَّا أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ثوْهِيبْثْ نّسْ ؤُشَا أَذْ أَسْ إِغَارْصْ زَّاثْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ؤُشَا أَرَّاوْ ن هَارُونْ أَذْ زدْجْعنْ إِذَامّنْ نّسْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","أَذْ إِقدّمْ ثَاذُونْثْ ن ثْغَارْصْثْ نْ ڒهْنَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي: مَارَّا ثَانوَّارْثْ ن ثَاذُونْثْ نِّي يُوذْسنْ أَبعْصُوصْ أَذْ ت إِكّسْ، ؤُڒَا ذ ثَاذُونْثْ إِ إِذْڒِينْ أَذَانْ ذ مَارَّا ثَاذُونْثْ إِ إِدْجَانْ خْ وَاذَانْ ");
INSERT INTO rifa_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ؤُشَا أَذْ إِكّسْ ؤُڒَا ذ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ غَارْ ثجْعِينَّا ذ مِينْ يُويْڒنْ غَارْ ثْسَا ؤُ يَارْسَا خْ ثِيژَّاڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","أَكهَّانْ أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ. أَقَا ذ مَاشَّا، إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","مَاڒَا ثَاوْهِيبْثْ نّسْ ذ إِغَايْضْ، خنِّي أَذْ ث-إِ-د-إِسّْقَارّبْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ نّسْ ؤُشَا أَذْ أَسْ إِغَارْصْ زَّاثْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ؤُشَا أَرَّاوْ ن هَارُونْ أَذْ زدْجْعنْ شْوَايْثْ ن إِذَامّنْ نّسْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","أَذْ زَّايسْ إِقدّمْ ثَاوْهِيبْثْ نّسْ، إِخْسْ أَذْ يِينِي ثَاذُونْثْ إِ إِذْڒِينْ أَذَانْ، ؤُ مَارَّا ثَاذُونْثْ إِ إِدْجَانْ خْ وَاذَانْ، أَمْ ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي ");
INSERT INTO rifa_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ؤُشَا أَذْ إِكّسْ ؤُڒَا ذ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ غَارْ ثجْعِينَّا ؤُڒَا ذ مِينْ يُويْڒنْ غَارْ ثْسَا ؤُ يَارْسَا خْ ثِيژَّاڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","أَكهَّانْ أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ، أَقَا ذ مَاشَّا ن ثوْهِيبْثْ ن ثْمسِّي س إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ. مَارَّا ثَاذُونْثْ أَذْ ثِيڒِي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ثَا ذ ثَاوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ، مَانِي مَا إِ غَا ثْزذْغمْ: مَارَّا ثَاذُونْثْ ذ مَارَّا إِذَامّنْ وَارْ ثنْ تّتّمْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي: ’مَاڒَا شَا ن يِيجّنْ إِخْضَا أَمْ إِودَّارْ خْ مَارَّا ثِيوصَّا ن سِيذِي، مِينْ وَارْ إِتّْخصِّي أَذْ إِتّْوَاڭّْ، ؤُ نتَّا إِخْضَا ذڭْ إِشْثْ زَّايْسنْثْ، خنِّي أَذْ ثِيڒِي ثْمسْڒَاشْثْ أَمُّو: ");
INSERT INTO rifa_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","مَاڒَا أَكهَّانْ أَمذْهُونْ إِخْضَا، أَڒَامِي إِذْوڒْ ڒْڭنْسْ إِخْضَا، أَذْ د-إِسّْقَارّبْ إِجّْ ن ؤُفُونَاسْ. - أَمژْيَانْ إِشْنَانْ قَاعْ ن إِشْثْ ن ثْفُونَاسْثْ - أَمْ ثْغَارْصْثْ ن دّنْبْ إِ سِيذِي ذِي طّْوعْ ن دّنْبْ نّسْ إِ إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","أَذْ يَاوِي أَفُونَاسْ نِّي أَمژْيَانْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، زَّاثْ إِ وُوذمْ ن سِيذِي، ؤُشَا نتَّا أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ؤُفُونَاسْ أَمژْيَانْ ؤُشَا أَذْ أَسْ إِغَارْصْ إِ ؤُفُونَاسْ أَمژْيَانْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","خنِّي أَكهَّانْ أَمذْهُونْ أَذْ إِكْسِي شَا زڭْ إِذَامّنْ ن ؤُفُونَاسْ أَمژْيَانْ ؤُشَا أَذْ ث يَاوِي غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","أَذْ إِسُّوفْ ؤُكهَّانْ أَضَاضْ نّسْ ذڭْ إِذَامّنْ ؤُشَا أَذْ إِرُوشّْ شَا زڭْ إِذَامّنْ نِّي سبْعَا ن ثْوَاڒَاوِينْ زَّاثْ إِ وُوذمْ ن سِيذِي، زَّاثْ إِ ؤُڒحَّافْ ن زَّاوشْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","أَذْ إِڭّْ ؤُكهَّانْ شْوَايْثْ ن إِذَامّنْ خْ وَاشَّاونْ ن ؤُعَالْطَارْ إِ ڒبْخُورْ إِتّْفُوحنْ إِ ذِينْ زَّاثْ إِ وُوذمْ ن سِيذِي ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. نتَّا أَذْ إِفَارّغْ مَارَّا إِذَامّنْ إِ إِقِّيمنْ ن ؤُفُونَاسْ أَمژْيَانْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ ن وشْمَاضْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ.    ");
INSERT INTO rifa_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","أَذْ إِكّسْ مَارَّا ثَاذُونْثْ ن ؤُفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ: ثَاذُونْثْ إِ إِذْڒِينْ أَذَانْ ذ مَارَّا ثَاذُونْثْ إِ إِدْجَانْ خْ وَاذَانْ    ");
INSERT INTO rifa_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ؤُشَا أَذْ إِكّسْ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ غَارْ ثجْعِينَّا ؤُڒَا ذ مِينْ يُويْڒنْ غَارْ ثْسَا ؤُ يَارْسَا خْ ثِيژَّاڒْ، ");
INSERT INTO rifa_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","أَمْ مَامّشْ إِكّسْ مَانْ أَيَا خْ ؤُفُونَاسْ ن ثْغَارْصِي ن ڒهْنَا، ؤُشَا أَكهَّانْ أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","إِڒمْ ن ؤُفُونَاسْ أَمژْيَانْ ذ مَارَّا أَيْسُومْ نّسْ أَكْ-ذ ؤُزدْجِيفْ ذ إِشكْرَاذْ نّسْ ذ وَاذَانْ نّسْ ذ ؤُمسَّاڒْ نّسْ إِ ذَايسْ، ");
INSERT INTO rifa_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","أَقَا مَارَّا أَفُونَاسْ أَمژْيَانْ أَذْ ث إِسُّوفّغْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ غَارْ إِجّْ ن ومْشَانْ إِصْفَا مَانِي تّڭّنْ إِغّضْ إِ إِقِّيمنْ ن ثَاذُونْثْ ؤُشَا أَذْ ث إِسّشْمضْ س ثْمسِّي خْ ؤُكشُّوضْ. أَذْ ث شمْضنْ مَانِي زدْجْعنْ إِغّضْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","مَاڒَا ثفّغْ ثْمسْمُونْثْ ن إِسْرَائِيل مَارَّا زڭْ وبْرِيذْ ؤُشَا ثفَّارْ ثْمسْڒَاشْثْ خْ ثِيطَّاوِينْ ن وڭْرَاوْ ن ڒْڭنْسْ، ؤُشَا نِيثْنِي ڭِّينْ إِشْثْ ن ڒْحَاجّثْ نِّي إِفّْغنْ خْ مَارَّا ثِيوصَّا ن سِيذِي، زِي جِّيهثْ ن مِينْ وَارْ إِتّْخصِّي أَذْ يڭّْ، ؤُشَا إِذْوڒْ ذَايْسنْ ؤُمَارْوَاسْ، ");
INSERT INTO rifa_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ؤُشَا إِبَانْ-د دّنْبْ إِ زِي إِفّْغنْ خْ وبْرِيذْ ن ڒُومُورَاثْ، خنِّي أَذْ د-إِسّْقَارّبْ وڭْرَاوْ ن ڒْڭنْسْ إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - ذ ثَاغَارْصْثْ إِ دّنْبْ، ؤُشَا أَذْ ث أَوْينْ زَّاثْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","إِمْغَارنْ ن ثْمسْمُونْثْ أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن ؤُفُونَاسْ أَمژْيَانْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا نتَّا أَذْ أَسْ إِغَارْصْ إِ ؤُفُونَاسْ نِّي أَمژْيَانْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","أَكهَّانْ أَمذْهُونْ أَذْ يَاوِي شْوَايْثْ زڭْ إِذَامّنْ ن ؤُفُونَاسْ أَمژْيَانْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ");
INSERT INTO rifa_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ؤُشَا أَذْ إِسُّوفْ ؤُكهَّانْ أَضَاضْ نّسْ ذڭْ إِذَامّنْ ؤُشَا أَذْ إِرُوشّْ س إِذَامّنْ نِّي سبْعَا ن ثْوَاڒَاوِينْ زَّاثْ إِ وُوذمْ ن سِيذِي، زَّاثْ إِ ؤُڒحَّافْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","نتَّا أَذْ إِڭّْ شْوَايْثْ زڭْ إِذَامّنْ نِّي خْ وَاشَّاونْ ن ؤُعَالْطَارْ نِّي إِدْجَانْ زَّاثْ إِ وُوذمْ ن سِيذِي ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. خنِّي أَذْ إِفَارّغْ مَارَّا إِذَامّنْ إِشطّنْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ ن وشْمَاذْ إِ ذِينْ زَّاثْ إِ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","أَذْ خَاسْ إِكّسْ مَارَّا ثَاذُونْثْ ؤُشَا أَذْ ت إِسّْبخَّارْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ؤُشَا أَذْ إِڭّْ س ؤُفُونَاسْ أَمژْيَانْ أَمْ مَامّشْ إِڭَّا س ؤُفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ، أَمُّو إِ غَا يڭّْ. أَكهَّانْ أَذْ خَاسنْ إِڭّْ أَصْڒَاحْ ؤُشَا أَذْ أَسنْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","خنِّي أَذْ إِسُّوفّغْ أَفُونَاسْ أَمژْيَانْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُشَا أَذْ ث إِسّشْمضْ أَمْ مَامّشْ إِسّشْمضْ أَفُونَاسْ أَمزْوَارُو. أَقَا-ت ذ ثَاغَارْصْثْ ن دّنْبْ ن وڭْرَاوْ ن ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","مَاڒَا إِجّْ ن ڒْحَاكمْ إِخْضَا، ؤُشَا س ؤُودَّارْ إِڭَّا إِشْثْ ن ڒْحَاجّثْ نِّي إِتّفّْغنْ خْ وبْرِيذْ ن مَارَّا ثِيوصَّا ن سِيذِي، أَربِّي نّسْ، إِ وَارْ إِتّْشُووَّارنْ أَذْ إِتّْوَاڭّْ، ؤُشَا إِذْوڒْ ذَايسْ ؤُمَارْوَاسْ، ");
INSERT INTO rifa_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","نِيغْ مَاڒَا إِتّْوَاسَّارْڭبْ أَسْ ؤُخطُّو نّسْ إِ إِڭَّا ضِيدّْ إِ ڒُْومُورْ، أَذْ ثِيڒِي ثوْهِيبْثْ نّسْ، ثنِّي إِ غَا إِقدّمْ، ذ إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ، إِجّْ ن ووْثمْ إِشْنَانْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ؤُمْيَانْ ؤُشَا أَذْ أَسْ إِغَارْصْ ذڭْ ومْشَانْ مَانِي غَارْصنْ إِ ثَاغَارْصْثْ ن وشْمَاضْ زَّاثْ إِ وُوذمْ ن سِيذِي. أَقَا ذ ثَاغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","خنِّي أَذْ إِكْسِي ؤُكهَّانْ س ؤُضَاضْ نّسْ شْوَايْثْ زڭْ إِذَامّنْ ن ثْغَارْصْثْ ن دّنْبْ ؤُشَا أَذْ ثنْ إِڭّْ خْ وَاشَّاونْ ن ؤُعَالْطَارْ ن وشْمَاضْ ؤُشَا خنِّي أَذْ إِفَارّغْ إِذَامّنْ إِشطّنْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","أَذْ إِسّْبخَّارْ مَارَّا ثَاذُونْثْ نّسْ خْ ؤُعَالْطَارْ، أَمْ مَامّشْ ذ أَسْ إِڭَّا إِ ثَاذُونْثْ ن ثْغَارْصْثْ ن ڒهْنَا. أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ ذِي طّْوعْ ن دّنْبْ نّسْ ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","مَاڒَا إِجّنْ بْنَاذمْ زِي ڒْڭنْسْ ن ثمُّورْثْ إِخْضَا س ؤُودَّارْ أَمْ إِڭَّا مْغِيرْ إِشْثْ ن ڒْحَاجّثْ نِّي إِتّفّْغنْ خْ إِشْثنْ ن ثْوصَّا ن سِيذِي، مِينْ وَارْ إِتّْشُووَّارْ أَذْ إِتّْوَاڭّْ، ؤُشَا إِذْوڒْ ذَايسْ ؤُمَارْوَاسْ، ");
INSERT INTO rifa_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","نِيغْ إِتّْوَاسَّارْڭبْ أَسْ ؤُخطُّو نّسْ إِ إِڭَّا، خنِّي أَذْ ثِيڒِي ثوْهِيبْثْ نّسْ نِّي إِ غَا إِقدّمْ ذ إِشْثْ ن ثْغَايْضثْ، إِشْثْ ن ثوْثمْثْ إِشْنَانْ قَاعْ، ذ ثَاغَارْصْثْ خْ دّنْبْ إِ إِڭَّا. ");
INSERT INTO rifa_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ثْغَارْصْثْ ن دّنْبْ ؤُشَا أَذْ أَسْ إِغَارْصْ إِ ثْغَارْصْثْ ن دّنْبْ ذڭْ ومْشَانْ ن ثْغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","خنِّي أَذْ إِكْسِي ؤُكهَّانْ س ؤُضَاضْ نّسْ شْوَايْثْ زڭْ إِذَامّنْ ؤُشَا أَذْ ث إِڭّْ غَارْ وَاشَّاونْ ن ؤُعَالْطَارْ ن ثْغَارْصْثْ ن وشْمَاضْ ؤُشَا أَذْ إِفَارّغْ مَارَّا إِذَامّنْ إِشطّنْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","أَذْ خَاسْ إِكّسْ مَارَّا ثَاذُونْثْ نّسْ أَمْ مَامّشْ كّْسنْ ثَاذُونْثْ ن ثْغَارْصْثْ ن ڒهْنَا ؤُشَا أَكهَّانْ أَذْ ت إِسّْبخَّارْ خْ ؤُعَالْطَارْ، أَذْ ثِيڒِي ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ؤُشَا أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","مَاڒَا إِقدّمْ إِجّْ ن إِزْمَارْ ذ ثَاوْهِيبْثْ إِ ثْغَارْصْثْ ن دّنْبْ، خنِّي أَذْ إِقدّمْ إِشْثْ ن ثَاوْثمْثْ إِشْنَانْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","أَذْ إِسَّارْسْ أَفُوسْ نّسْ خْ ؤُزدْجِيفْ ن ثْغَارْصْثْ ن دّنْبْ ؤُشَا أَذْ أَسْ إِغَارْصْ إِ ثْغَارْصْثْ ن دّنْبْ ذڭْ ومْشَانْ مَانِي غَارْصنْ إِ ثْغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","خنِّي أَذْ إِكْسِي ؤُكهَّانْ س ؤُضَاضْ نّسْ شْوَايْثْ زڭْ إِذَامّنْ ن ثْغَارْصْثْ ن دّنْبْ ؤُشَا أَذْ ث إِڭّْ خْ وَاشَّاونْ ن ؤُعَالْطَارْ ن وشْمَاضْ ؤُشَا أَذْ إِفَارّغْ مَارَّا إِذَامّنْ نّسْ إِشطّنْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","أَذْ خَاسْ إِكّسْ مَارَّا ثَاذُونْثْ نّسْ، أَمْ مَامّشْ إِكّسْ ثَاذُونْثْ ن ؤُحُوڒِي ن ثْغَارْصْثْ ن ڒهْنَا، ؤُشَا أَكهَّانْ أَذْ ت إِسّْبخَّارْ خْ ؤُعَالْطَارْ، خْ ثوْهِيبِينْ ن ثْمسِّي إِ سِيذِي ؤُشَا أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ خْ دّنْبْ إِ إِڭَّا، ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","”مَاڒَا إِخْضَا حذْ ؤُمِي إِسْڒَا أَهجِّي ن إِشْثْ ن نّعْڒثْ ؤُشَا نتَّا ذ أَشهَّاذْ خَاسْ، نِيغْ إِژْرَا إِ-ث نِيغْ إِسّنْ إِ-ث: مَاڒَا وَارْ خَاسْ إِقَّارْ وَالُو، خنِّي أَذْ يَارْبُو ڒْمُوعْصِييّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","نِيغْ مَاڒَا إِحَاذَا حذْ مِينْ مَا زِي ثْمسْڒَاشْثْ إِخمْجنْ، ڒْخشْبثْ ن ڒْمَاڒْ إِخْمجْ، نِيغْ ڒْخشْبثْ ن ڒبْهِيمثْ إِخمْجنْ، نِيغْ ڒْخشْبثْ ن ؤُمُودَّارْ إِخْمجْ إِتّْبُوعنْ، ؤُشَا نتَّا وَارْ إِسِّينْ أَيَا، أَقَا إِخْمجْ ؤُ ذَايسْ أَمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","نِيغْ مَاڒَا إِحَاذَا شَا ن ڒخْمجْ ن بْنَاذمْ، مِينْ مَا زِي ڒخْمجْ نّسْ إِ زِي إِذْوڒْ نتَّا إِخْمجْ، مَاڒَا ثنُّوفَّارْ خَاسْ ؤُشَا إِسّنْ إِثْ أَوَارْنِي أَسْ، أَقَا ذَايسْ أَمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","نِيغْ مَاڒَا إِژُّودْجْ حذْ س ثْشَارْفَايحْ نّسْ، مَاحنْذْ أَذْ إِڭّْ ڒْغَارْ نِيغْ أَذْ إِڭّْ ڒْخَارْ، نِيغْ مِينْ مَا إِزمَّارْ بْنَاذمْ أَذْ إِنْطقْ أَمنِّي وَاهَا س إِشْثْ ن ثْجَادْجِيثْ، أَمْ وَارْ ت إِسِّينْ، مَاشَا إِسّنْ إِ-ث أَوَارْنِي مَانْ أَيَا، أَقَا ذَايسْ أَمَارْوَاسْ ذِي سِّيبّثْ ن إِشْثْ زِي ثْمسْڒَايِينْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","خنِّي أَذْ إِمْسَارْ، مَاڒَا ذَايسْ أَمَارْوَاسْ ذِي سِّيبّثْ ن إِشْثنْ زِي ثْمسْڒَايِينْ-أَ، أَذْ إِنْعمْ خْ مِينْ ثُوغَا إِخْضَا. ");
INSERT INTO rifa_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","خْ دّنْبْ إِ إِڭَّا، إِتّْخصَّا أَسْ أَذْ إِقدّمْ إِشْثْ ن ثوْثمْثْ ن وُودْجِي ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ، إِشْثْ ن ثخْسِي نِيغْ إِشْثْ ن ثْغَايْضثْ، ذ ثَاغَارْصْثْ ن دّنْبْ إِ سِيذِي، ؤُشَا أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ ذِي سِّيبّثْ ن دّنْبْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","مَاشَا مَاڒَا أَفُوسْ نّسْ وَارْ غَارسْ مِينْ إِقدّنْ إِ يِيجّْ زڭْ وُودْجِي، خنِّي أَذْ يَاوِي إِ سِيذِي إِ ثْغَارْصْثْ ن ؤُمَارْوَاسْ خْ دّنْبْ إِ إِڭَّا، ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ ثْنَاينْ ن إِذْبِيرنْ إِمژْيَاننْ، إِجّنْ إِ ثْغَارْصْثْ ن دّنْبْ ؤُ إِجّنْ إِ ثْغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","أَذْ ثنْ يَاوِي غَارْ ؤُكهَّانْ، ونِّي د غَا يَاوْينْ ذ أَمزْوَارُو ثَاجْلِيلِّيحْثْ نِيغْ أَضْبِيرْ إِ إِدْجَانْ إِ ثْغَارْصْثْ ن دّنْبْ ؤُشَا أَذْ إِكّسْ أَزدْجِيفْ نّسْ زِي شْوَايْثْ أَوَارْنِي يِيرِي نّسْ، مَاشَا وَارْ ث إِبطِّي مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","أَذْ إِرُوشّْ شْوَايْثْ ن إِذَامّنْ غَارْ ؤُغزْذِيسْ ن ؤُعَالْطَارْ ؤُشَا مِينْ إِشطّنْ زڭْ إِذَامّنْ، أَذْ ث إِژمّْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ. أَقَا-ت ذ ثَاغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","أَذْ إِسّوْجذْ أَمدَّارْ نّغْنِي أَمْ ثْغَارْصْثْ ن وشْمَاضْ عْلَاحْسَابْ لْفَارِيضَا ؤُشَا أَمُّو إِ خَاسْ إِ غَا يڭّْ ؤُكهَّانْ أَصْڒَاحْ خْ دّنْبْ نّسْ إِ إِڭَّا ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","مَاڒَا أَفُوسْ نّسْ وَارْ غَارسْ مِينْ إِقدّنْ إِ ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ إِ ثْنَاينْ ن إِذْبِيرنْ إِمژْيَاننْ، خنِّي ونِّي إِخْضَانْ، أَذْ يَاوِي أَمْ ثوْهِيبْثْ نّسْ ثَاعْشَارْثْ ن إِجّْ ن إِفَا ن وَارنْ أَزْذَاذْ ذ ثَاوْهِيبْثْ ن دّنْبْ. وَارْ خَاسْ إِتّڭّْ زّشْثْ ؤُڒَا وَارْ خَاسْ إِسّْرُوسِي جَّاوِي، مِينْزِي أَقَا-ت ذ ثَاغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","أَذْ ت يَاوِي غَارْ ؤُكهَّانْ ؤُشَا أَكهَّانْ أَذْ زَّايسْ إِكْسِي إِجّْ ن وُورُو إِشُّورْ ؤُشَا أَذْ إِسّْبخَّارْ أَيَا أَمْ ڒِيذَارثْ ذَايسْ خْ ؤُعَالْطَارْ، خْ ثوْهِيبِينْ ن ثْمسِّي إِ سِيذِي. أَقَا-ت ذ ثَاغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","أَمُّو إِ خَاسْ غَا يڭّْ ؤُكهَّانْ أَصْڒَاحْ خْ دّنْبْ نّسْ نِّي إِڭَّا زِي جِّيهثْ ن إِشْثنْ زِي ثْمسْڒَايِينْ-أَ ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ. مِينْ إِشطّنْ أَذْ يِيڒِي إِ إِكهَّاننْ أَمْ مَامّشْ إِ يدْجَانْ أَكْ-ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","”مَاڒَا إِڭَّا حذْ س ڒغْذَارْ ؤُشَا إِخْضَا س ؤُودَّارْ ذِي ثْمسْڒَايِينْ إِقدّْسنْ ن سِيذِي، إِتّْخصَّا أَذْ يَاوِي إِشَارِّي إِشْنَانْ قَاعْ زڭْ وُودْجِي ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ إِ سِيذِي. أَذْ ثِيڒِي ڒْقِيمثْ نّسْ عْلَاحْسَابْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ ذڭْ إِشِيقْلُوثنْ ن نُّوقَارْثْ عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. أَقَا ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","زِي ثْمسْڒَايِينْ إِقدّْسنْ أَذْ يَارّْ ذِي مِينْ ذِي إِخْضَا قْبڒْ، ؤُشَا أَذْ ذَايسْ يَارْنِي ڒخْمُوسْ. ؤُشَا أَذْ إِوْشْ مَانْ أَيَا إِ ؤُكهَّانْ ؤُشَا أَكهَّانْ أَذْ ث إِسّصْڒحْ س إِشَارِّي ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","مَاڒَا إِخْضَا حذْ ؤُشَا إِڭَّا إِشْثْ ن ثْمسْڒَاشْثْ إِ وَارْ ثتّْشُووَّارْ أَذْ ثتّْوَاڭّْ، أَمْ د-إِفّغْ ذڭْ إِشْثْ ن ثْمسْڒَاشْثْ زِي ثْوصَّا ن سِيذِي، ؤُشَا ثُوغَا ثْنُوفَّارْ خَاسْ، أَذْ ذَايسْ يِيڒِي ؤُمَارْوَاسْ ؤُشَا أَذْ يَارْبُو ڒْمُوعْصِييّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","أَذْ يَاوِي إِجّْ ن إِشَارِّي إِشْنَانْ قَاعْ زڭْ وُودْجِي غَارْ ؤُكهَّانْ إِ ثْغَارْصْثْ ن ؤُمَارْوَاسْ، أَذْ ثِيڒِي ڒْقِيمثْ نّسْ عْلَاحْسَابْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ ؤُشَا أَذْ ث إِسّصْڒحْ ؤُكهَّانْ خْ ؤُودَّارْ نّسْ إِ ذِي إِودَّارْ أَمْ وَارْ ث إِسِّينْ ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","أَقَا ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ. س ثِيذتّْ ثُوغَا ذَايسْ أَمَارْوَاسْ زَّاثْ إِ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","”مَاڒَا إِخْضَا حذْ ؤُشَا إِغْذَارْ سِيذِي أَمْ إِسّْخَارِّيقْ خْ جَّارْ نّسْ خْ مِينْ ذ أَسْ إِمّوْشنْ، مَاحنْذْ أَذْ ث إِحْضَا، نِيغْ خْ مِينْ إِجَّا ذڭْ ؤُفُوسْ نّسْ، نِيغْ خْ مِينْ خَاسْ يُوشَارنْ، نِيغْ خْ شَا ن ؤُبعّجْ إِ إِڭَّا إِ جَّارْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","نِيغْ أَمْ إِسّْخَارِّيقْ خْ شَا مِينْ إِودَّارنْ إِ شَا ن يِيجّنْ ؤُ إِتّْوَافْ زَّايسْ ؤُشَا خنِّي نتَّا إِجُّودْجْ ژُورْ، وَاهْ، أَمْ إِسّْخَارِّيقْ نتَّا خْ إِشْثنْ زِي مَارَّا ثِيمسْڒَايِينْ نِّي إِتّڭّْ بْنَاذمْ أَڒَامِي إِخطَّا س مَانْ أَيَا، ");
INSERT INTO rifa_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","خنِّي إِتّْخصَّا، ؤُمِي إِخْضَا ؤُشَا إِذْوڒْ ذَايسْ ؤُمَارْوَاسْ، أَقَا نتَّا أَذْ د-يَارّْ ثُوشفَّارْثْ نِّي يُوشَارْ، نِيغْ مِينْ إِتّْوَاكّْسنْ نِّي إِكْسِي نتَّا س ؤُغِيڒْ، نِيغْ مِينْ ثُوغَا إِحْضَا نِّي ذ أَسْ إِمّوْشنْ مَاحنْذْ أَذْ ت إِحْضَا، نِيغْ مِينْ إِودَّارنْ نِّي يُوفَا. ");
INSERT INTO rifa_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ؤُشَا مَارَّا مِينْ خفْ إِجُّودْجْ ژُورْ، أَذْ د-يَارّْ ڒْقِيمثْ نّسْ ثْمُونْ ؤُشَا أَذْ يَارْنِي ڒخْمُوسْ. نتَّا أَذْ ث إِوْشْ إِ ونِّي ؤُمِي د-ثُوسَا ذڭْ وَاسّْ ن ثْغَارْصْثْ نّسْ ن ؤُمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","نتَّا أَذْ يَاوِي ثَاغَارْصْثْ نّسْ ن ؤُمَارْوَاسْ غَارْ سِيذِي، إِجّْ ن إِشَارِّي إِشْنَانْ قَاعْ زڭْ وُودْجِي، ونِّي ڒْقِيمثْ نّسْ أَذْ ثِيڒِي عْلَاحْسَابْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ، أَذْ ثِيڒِي ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ، ؤُشَا أَذْ ث يَاوِي غَارْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","خنِّي أَكهَّانْ أَذْ خَاسْ إِڭّْ أَسْڒَاحْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَذْ أَسْ إِتّْوَاغْفَارْ خْ مِينْ إِڭَّا، مَاڒَا إِذْوڒْ ذَايسْ أَمَارْوَاسْ س إِشْثْ ن ثْمسْڒَاشْثْ زِي مَارَّا ثِيمسْڒَايِينْ-أَ.“ ");
INSERT INTO rifa_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","”ؤُمُورْ هَارُونْ ذ وَارَّاوْ نّسْ، إِنِي أَسنْ: ’وَا ذ أَزرْفْ إِ ثْغَارْصْثْ ن وشْمَاضْ. ثَاغَارْصْثْ ن وشْمَاضْ خْ ؤُكشُّوضْ خْ ؤُعَالْطَارْ أَذْ ثقِّيمْ ثَارقّْ دْجِيڒثْ ثكْمڒْ أَڒْ صّْبحْ ؤُ إِتّْخصَّا ثِيمسِّي ن ؤُعَالْطَارْ أَذْ ثقِّيمْ أَذْ ثشْمضْ ذَايسْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","أَكهَّانْ أَذْ يَارْضْ أَسڒْهَامْ نّسْ ن ڒقْطنْ، أَذْ إِبْيسْ سَّارْوَاڒْ نّسْ ن ڒقْطنْ خْ أَرِّيمثْ نّسْ، ؤُشَا أَذْ إِكْسِي إِغّضْ ن مِينْ إِقِّيمنْ ن ثَاذُونْثْ ن ثْغَارْصْثْ ن وشْمَاضْ، ثنِّي ثشَّا ثْمسِّي، ؤُشَا أَذْ ث إِسَّارْسْ زَّاثْ إِ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","خنِّي أَذْ إِكّسْ أَرُّوضْ نّسْ ؤُشَا أَذْ يَارْضْ أَرُّوضْ نّغْنِي، أَذْ يَاوِي إِغّضْ ن مِينْ إِقِّيمنْ ن ثَاذُونْثْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ غَارْ يِيجّْ ن ومْشَانْ إِصْفَا. ");
INSERT INTO rifa_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","إِتّْخصَّا أَذْ ثقِّيمْ ثْمسِّي ثَارقّْ خْ ؤُعَالْطَارْ، إِتّْخصَّا وَارْ ثْخسِّي شَا. أَكهَّانْ أَذْ خَاسْ إِسَّارْغْ أَكشُّوضْ كُوڒْ صّْبحْ ؤُشَا أَذْ خَاسْ إِستّفْ ثَاغَارْصْثْ ن وشْمَاضْ ؤُشَا أَذْ خَاسْ إِسّْبخَّارْ ثَاذُونْثْ ن ثْغَارْصَا ن ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ثِيمسِّي خْ ؤُعَالْطَارْ أَذْ ثقِّيمْ ثَارقّْ ڒبْذَا، وَارْ ثْخسِّي.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","”وَا ذ أَزرْفْ إِ ثوْهِيبْثْ ن ڒْغِيدْجثْ. أَرَّاوْ ن هَارُونْ أَذْ ت أَوْينْ زَّاثْ إِ وُوذمْ ن سِيذِي زَّاثْ إِ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","نتَّا أَذْ زَّايسْ إِكْسِي إِجّْ ن وُورُو زڭْ وَارنْ أَزْذَاذْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ أَكْ-ذ شَا ن زّشْثْ نّسْ ذ مَارَّا جَّاوِي إِ إِدْجَانْ خْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ. أَقَا ذ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ، إِشْثْ ن ڒِيذَارثْ ذَايسْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","هَارُونْ ذ وَارَّاوْ نّسْ أَذْ شّنْ مِينْ زَّايسْ إِشطّنْ. إِتّْخصَّا أَذْ ث شّنْ بْڒَا أَنْثُونْ ذڭْ ومْشَانْ أَمْقدَّاسْ. أَذْ ث شّنْ ذِي ڒمْرَاحْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","وَارْ إِعدّڒْ أَذْ ث ڭّْونْ س ونْثُونْ. ثَا ذ ثَاغَارْصْثْ نْسنْ نِّي وْشِيغْ نشّْ زِي ثوْهِيبِينْ إِنُو ن ثْمسِّي. أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ أَمْ ثْغَارْصْثْ ن دّنْبْ ذ ثْغَارْصْثْ ن ؤُمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","مَارَّا إِوثْمَانْ جَارْ وَارَّاوْ ن هَارُونْ أَذْ زَّايسْ شّنْ. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا خْ ثوْهِيبِينْ ن ثْمسِّي ن سِيذِي إِ مَارَّا جِّيڒَاثْ نْومْ. مَارَّا وِي ت غَا إِحَاذَانْ، أَذْ إِتّْوَاقدّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","”ثَا ذ ثَاوْهِيبْثْ ن هَارُونْ ذ وَارَّاوْ نّسْ إِ زِي د غَا قَارّْبنْ غَارْ سِيذِي ذڭْ وَاسّْ مِينْ ذِي إِ غَا إِتّْوَاذْهنْ هَارُونْ: ثَاعْشَارْثْ ن إِجّْ ن إِفَا ن وَارنْ أَزْذَاذْ أَمْ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ إِ ڒبْذَا، أَزْينْ نّسْ ذِي صّْبحْ ذ وزْينْ نّسْ نّغْنِي غَارْ ؤُعشِّي. ");
INSERT INTO rifa_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ذڭْ إِجّْ ن ؤُخْذِيمْ أَذْ ثسّوْجذْ أَيَا س زّشْثْ ن زِّيثُونْ ؤُشَا أَذْ ث ثَاوْيذْ ذ ثَاوْهِيبْثْ أَوَارْنِي ث ثْخدْجْضذْ. أَذْ ثْقدّْمذْ إِڒقّْوَازْ تّْوَارْژَانْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ أَمْ إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","أَكهَّانْ نِّي غَا ذهْننْ ذڭْ ومْشَانْ نّسْ زڭْ إِحنْجِيرنْ نّسْ، أَذْ ت إِسّوْجذْ. أَقَا-ت ذ ثَاوْصيّثْ إِ ڒبْذَا. ثَاوْهِيبْثْ-أَ أَذْ ثتّْوَابخَّارْ إِ سِيذِي مَارَّا. ");
INSERT INTO rifa_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","مَارَّا ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ن ؤُكهَّانْ أَذْ ثِيڒِي ثكْمڒْ. وَارْ زَّايسْ تّتّنْ شَا.“ ");
INSERT INTO rifa_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","”سِيوڒْ أَكْ-ذ هَارُونْ ذ وَارَّاوْ نّسْ، إِنِي أَسنْ: ’وَا ذ أَزرْفْ إِ ثْغَارْصْثْ ن دّنْبْ: ذڭْ ومْشَانْ مَانِي ثتّْوَاغَارْصْ ثَاغَارْصْثْ ن وشْمَاضْ، أَذْ ثتّْوَاغَارْصْ عَاوذْ ثَاغَارْصْثْ ن دّنْبْ زَّاثْ إِ وُوذمْ ن سِيذِي. أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","أَكهَّانْ نِّي ت غَا إِقدّْمنْ ذ ثَاغَارْصْثْ أَذْ زَّايسْ يشّْ. إِتّْخصَّا أَذْ ثتّْوَاشّْ ذڭْ إِجّْ ن ومْشَانْ أَمْقدَّاسْ ذِي ڒمْرَاحْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","مَارَّا وِي غَا إِحَاذَانْ أَيْسُومْ نّسْ أَذْ زَّايسْ إِتّْوَاقدّسْ. مَاڒَا إِنْڭزْ شْوَايْثْ زڭْ إِذَامّنْ خْ يِيجّْ ن وَارُّوضْ، خنِّي إِتّْخصَّا أَذْ ثسِّيرْذذْ مِينْ خَاسْ إِبقّْضنْ ذڭْ إِجّْ ن ومْشَانْ أَمْقدَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ؤُشَا ڒْقشْعثْ ن ثْڒَاخْثْ إِ ذِي ت سّْننَّانْ، أَذْ ثتّْوَارْژْ، مَاشَا مَاڒَا سّنْونْ ت ذڭْ إِشْثْ ن ڒْقشْعثْ ن نّْحَاسْ، خنِّي إِتّْخصَّا أَذْ حكّنْ ؤُ أَذْ سّْڒِيڒنْ ڒْقشْعثْ س وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","مَارَّا وِي إِدْجَانْ ذ أَوْثمْ جَارْ إِكهَّاننْ أَذْ زَّايسْ يشّْ. أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","مَاشَا ؤُڒَا ذ إِشْثْ ن ثْغَارْصْثْ ن دّنْبْ إِ زِي تّْوَاقدّْمنْ إِذَامّنْ نّسْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مَاحنْذْ أَذْ إِڒِينْ إِ وصْڒَاحْ ذِي زَّاوشْثْ إِقدّْسنْ، وَارْ زَّايسْ إِتّْوَاشّْ شَا. أَذْ ثتّْوَاشْمضْ س ثْمسِّي.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","”وَا ذ أَزرْفْ إِ ثْغَارْصْثْ ن ؤُمْوَارْوَاسْ. أَقَا ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ذڭْ ومْشَانْ مَانِي غَارّْصنْ إِ ثْغَارْصْثْ ن وشْمَاضْ، أَذْ غَارْصنْ إِ ثْغَارْصْثْ ن ؤُمَارْوَاسْ. أَذْ إِزدْجعْ إِذَامّنْ نّسْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","أَذْ يَاوِي مَارَّا ثَاذُونْثْ نّسْ: أَنوَّارْ ن ثَاذُونْثْ ذ ثَاذُونْثْ نِّي إِذْڒِينْ أَذَانْ، ");
INSERT INTO rifa_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ؤُشَا أَذْ إِكّسْ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ إِ خَاسنْثْ إِدْجَانْ غَارْ ثجْعِينَّا، ؤُڒَا ذ مِينْ يُويْڒنْ غَارْ ثْسَا ؤُشَا يَارْسَا خْ ثِيژَّاڒْ، ");
INSERT INTO rifa_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ؤُشَا أَكهَّانْ أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. أَقَا-ت ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","مَارَّا أَوْثمْ جَارْ إِكهَّاننْ أَذْ زَّايسْ يشّْ. أَذْ إِتّْوَاشّْ ذڭْ إِجّْ ن ومْشَانْ أَمْقدَّاسْ، أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","أَذْ يِيڒِي إِجّْ ن ؤُزرْفْ أَمْ إِ ثْغَارْصْثْ ن دّنْبْ أَمْ إِ ثْغَارْصْثْ ن ؤُمْوَارْوَاسْ. أَذْ يِيڒِي ويْسُومْ ن ثْغَارْصْثْ إِ ؤُكهَّانْ، ونِّي ثُوغَا زَّايسْ إِڭّْ أَصْڒَاحْ خْ شَا ن يِيجّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","أَكهَّانْ نِّي إِ غَا إِقدّْمنْ ثَاغَارْصْثْ ن وشْمَاضْ ن شَا ن إِجّنْ، إِ ؤُكهَّانْ نِّي أَذْ ثِيڒِي ثڒْمشْثْ ن ثْغَارْصْثْ ن ثْمسِّي نِّي د-إِقدّمْ، ثِيڒْمشْثْ أَذْ ثِيڒِي إِ نتَّا. ");
INSERT INTO rifa_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","كُوڒْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ نِّي ضَارّْحنْ نِيثْنِي ذِي ثفْقُونْثْ ؤُڒَا ذ مَارَّا مِينْ إِتّْوَاسّْوجْذنْ ذِي طَّاجِّينْ نِيغْ ذڭْ وخْذِيمْ، ذ مَانْ أَيَا أَذْ يِيڒِي إِ ؤُكهَّانْ نِّي ث إِقدّْمنْ، أَذْ يِيڒِي إِ نتَّا. ");
INSERT INTO rifa_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","كُوڒْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ إِ إِتّْوَاخدْجْضنْ س زّشْثْ ن زِّيثُونْ نِيغْ يُوژْغنْ، أَذْ ثِيڒِي إِ مَارَّا أَرَّاوْ ن هَارُونْ، أَمْ إِ يِيجّْ أَمْ إِ ونّغْنِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","”وَا ذ أَزرْفْ إِ ثْغَارْصْثْ ن ڒهْنَا ثنِّي إِ غَا إِقدّمْ بْنَاذمْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","مَاڒَا أَذْ ت إِقدّمْ إِ ؤُقَاذِي، خنِّي أَذْ إِقدّمْ أَكْ-ذ ثوْهِيبْثْ ن ؤُقَاذِي ؤُڒَا ذ ڒمْسمْنَاثْ بْڒَا أَنْثُونْ إِخدْجْضنْ س زّشْثْ ذ ثڒْفَافْ بْڒَا أَنْثُونْ تّْوَاذهْننْثْ س زّشْثْ ذ ڒمْسمْنَاثْ ن وَارنْ أَزْذَاذْ تّْوَاخدْجْضنْثْ س زّشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","أَذْ إِقدّمْ ثَاوْهِيبْثْ نّسْ أَكْ-ذ ڒمْسمْنَاثْ ن وغْرُومْ س ونْثُونْ، جْمِيعْ أَكْ-ذ ثوْهِيبْثْ ن ؤُقَاذِي، ثنِّي إِدْجَانْ زِي ثوْهِيبِينْ نّسْ ن ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","زِي كُوڒْ دَّارْبْ ن ثَاوْهِيبْثْ أَذْ إِقدّمْ إِشْثنْ زَّايسْ أَمْ ثوْهِيبْثْ ن ؤُسْڭعّذْ إِ سِيذِي. أَذْ ثِيڒِي إِ ؤُكهَّانْ نِّي إِ غَا إِزدْجْعنْ إِذَامّنْ ن ثْغَارْصَا ن ڒهْنَا خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ، أَذْ ثِيڒِي إِ نتَّا. ");
INSERT INTO rifa_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","أَيْسُومْ ن ثوْهِيبْثْ ن ؤُقَاذِي، ثنِّي إِدْجَانْ زِي ثوْهِيبِينْ نّسْ ن ڒهْنَا، أَذْ إِتّْوَاشّْ ذڭْ وَاسّْ إِ ذِي غَا إِقدّمْ ثَاوْهِيبْثْ نّسْ. وَارْ إِتّجِّي زَّايسْ وَالُو أَڒْ صّْبحْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","مَاڒَا ثَاوْهِيبْثْ نّسْ ثُوسَا-د أَكْ-ذ إِجّْ ن لْوَاعْذْ نِيغْ ثدْجَا ذ إِشْثْ ن ثوْهِيبْثْ س ڒْخَاضَارْ، أَذْ ثتّْوَاشّْ ذڭْ وَاسّْ إِ ذِي إِ غَا إِقدّمْ ثَاغَارْصْثْ نّسْ ؤُشَا مِينْ زَّايسْ إِشطّنْ أَذْ إِتّْوَاشّْ ذڭْ وَاسّْ إِ-ث-إِ-د-إِضْفَارنْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","مِينْ إِشطّنْ عَاذْ زڭْ ويْسُومْ ن ثْغَارْصْثْ أَذْ إِتّْوَاشْمضْ س ثْمسِّي ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا. ");
INSERT INTO rifa_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","مَاڒَا إِتّْوَاشّْ عَاذْ زڭْ ويْسُومْ ن ثْغَارْصْثْ نّسْ ن ڒهْنَا ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا، خنِّي ونِّي ت إِقدّْمنْ وَارْ إِتِّيڒِي إِ أَرْضَا ن سِيذِي ؤُ ثَاغَارْصْثْ نّسْ وَارْ ذ أَسْ ثتّْوِيحْسِيبْ شَا ذ ثَاغَارْصْثْ ن ڒهْنَا. أَذْ ثِيڒِي ذ إِشْثْ ن جّْعِيفشْثْ ؤُشَا ونِّي زَّايسْ غَا إِشّنْ أَذْ يَارْبُو ڒْمُوعْصِييّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","أَيْسُومْ نِّي إِحَاذَانْ شَا ن ثْمسْڒَاشْثْ إِخمْجنْ، وَارْ زَّايسْ تّتّمْ. أَذْ ث سّْشمْضنْ س ثْمسِّي. زِي مِينْ إِشطّنْ ن ويْسُومْ، إِزمَّارْ أَذْ زَّايسْ يشّْ مَارَّا ونِّي إِزذْڭنْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ذ ونِّي إِ غَا إِشّنْ زڭْ ويْسُومْ ن ثْغَارْصْثْ ن ڒهْنَا، ثنِّي إِدْجَانْ إِ سِيذِي، أَمْ خَاسْ يَارْسَا ڒخْمجْ نّسْ، ڒعْمَارْ نِّي أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","مَاڒَا إِحَاذَا حذْ شَا ن ثْمسْڒَاشْثْ إِخْمجْ، أَمشْنَاوْ ڒخْمجْ ن بْنَاذمْ نِيغْ ڒخْمجْ ن يِيشْثْ ن ڒبْهِيمثْ إِخمْجنْ نِيغْ شَا ن ثْمسْڒَاشْثْ إِ إِدْجَانْ ذ نّْعِي ن ڒخْمجْ، ؤُشَا خنِّي أَذْ يشّْ زڭْ ويْسُومْ ن ثْغَارْصِينْ ن ڒهْنَا إِ سِيذِي، ڒعْمَارْ نِّي أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي: ’كنِّيوْ وَارْ تّتّمْ شَا قَاعْ ثَاذُونْثْ ن ؤُفُونَاسْ نِيغْ ن إِزْمَارْ نِيغْ ن إِغَايْضْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ثَاذُونْثْ ن إِشْثْ ن ڒْخشْبثْ ذ ثَاذُونْثْ ن إِجّْ ن ؤُمُودَّارْ مزّْقنْ ث، ثْعدّڒْ أَذْ ثتّْوَاڭّْ إِ مَامّشْ مَا ثڭَّا ڒْخذْمثْ، مَاشَا كنِّيوْ وَارْ زَّايسْ تّتّمْ وَالُو. ");
INSERT INTO rifa_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","مَانْ ونْ إِ غَا إِشّنْ ثَاذُونْثْ ن يِيشْثْ ن ڒبْهِيمثْ إِ زِي د غَا سّْقَارّْبنْ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي، ڒعْمَارْ نِّي زَّايسْ إِ غَا إِشّنْ، أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ذِي مَارَّا ثِيزذِّيغِينْ نْومْ وَارْ تّتّمْ ؤُڒَا ذ شَا زڭْ إِذَامّنْ، أَمْ زڭْ إِجْضَاضْ أَمْ زِي ڒبْهَايمْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","كُوڒْ إِجّْ ن ڒعْمَارْ نِّي إِ غَا إِشّنْ مْغِيرْ شَا زڭْ إِذَامّنْ، ڒعْمَارْ نِّي أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي: ’وِي إِ د غَا إِسّْقَارّْبنْ ثْغَارْصْثْ نّسْ ن ڒهْنَا إِ سِيذِي، أَذْ إِقدّمْ ثَاوْهِيبْثْ نّسْ إِ سِيذِي زِي ثْغَارْصْثْ ن ڒهْنَا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","س إِفَاسّنْ نّسْ أَذْ يَاوِي ثِيوْهِيبِينْ ن ثْمسِّي زَّاثْ إِ سِيذِي. ثَاذُونْثْ إِ إِدْجَانْ خْ إِذْمَارنْ أَذْ ت يَاوِي أَكْ-ذ إِذْمَارنْ نِّي، مَاحنْذْ أَذْ ت إِسّنْهزّْ زِي سَّا غَارْ ذَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","أَكهَّانْ أَذْ إِسّْبخَّارْ ثَاذُونْثْ خْ ؤُعَالْطَارْ، مَاشَا إِذْمَارنْ أَذْ إِڒِينْ إِ هَارُونْ ذ وَارَّاوْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","زِي ثْغَارْصَا نْومْ ن ڒهْنَا أَذْ ثْقدّْممْ إِ ؤُكهَّانْ عَاوذْ أَشكْرُوذْ أَفُوسِي ذ ثَاوْهِيبْثْ ن ؤُسْڭعّذْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","أَشكْرُوذْ أَفُوسِي أَذْ يِيڒِي ذ ثَاسْغَارْثْ ن ونِّي زڭْ وَارَّاوْ ن هَارُونْ إِ غَا إِقدّْمنْ إِذَامّنْ ن ثْغَارْصِي ن ڒهْنَا ذ ثَاذُونْثْ نْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","مِينْزِي نشّْ كْسِيغْ إِذْمَارنْ ن ونْهزِّي ذ ؤُشكْرُوذْ إِ د-إِتّْوَاسّْڭعّْذنْ ذ ثَاوْهِيبْثْ زِي ثْغَارْصِي ن ڒهْنَا ن أَيْثْ ن إِسْرَائِيل ؤُ وْشِيغْ ثنْ إِ ؤُكهَّانْ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ أَمْ يِيشْثْ ن لْفَارِيضَا إِ ڒبْذَا، زِي جِّيهثْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ثَا ذ ثَاسْغَارْثْ إِتّْوَاسّْذهْننْ ن هَارُونْ ذ ثسْغَارْثْ إِتّْوَاسّْذهْننْ ن وَارَّاوْ نّسْ زِي ثوْهِيبِينْ ن ثْمسِّي ن سِيذِي ذڭْ وَاسّْ إِ ثنْ د-إِسّْقَارّبْ، مَاحنْذْ أَذْ إِڒِينْ ذ إِكهَّاننْ إِ سِيذِي، ");
INSERT INTO rifa_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ثَاسْغَارْثْ نِّي إِوْشَا سِيذِي إِ أَيْثْ ن إِسْرَائِيل ذڭْ وَاسّْ إِ ثنْ إِذْهنْ. أَقَا ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْسنْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","وَا ذ أَزرْفْ إِ ثْغَارْصْثْ ن وشْمَاضْ ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ ذ ثْغَارْصْثْ ن دّنْبْ ذ ثْغَارْصْثْ ن ؤُمَارْوَاسْ ذ ثْغَارْصَا إِ ؤُذشّنْ ذ ثْغَارْصَا ن ڒهْنَا، ");
INSERT INTO rifa_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","أَزرْفْ إِ إِوصَّا سِيذِي إِ مُوسَا ذڭْ وذْرَارْ ن سِينَا، أَسّْ مِينْ ذِي إِوصَّا أَيْثْ ن إِسْرَائِيل أَذْ قدّْمنْ ثِيوْهِيبِينْ نْسنْ إِ سِيذِي ذِي ڒخْڒَا ن سِينَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","”كْسِي هَارُونْ جْمِيعْ أَكْ-ذ وَارَّاوْ نّسْ ذ وَارُّوضْ ذ زّشْثْ إِ وذْهَانْ ذ ؤُفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ ذ ثْنَاينْ ن إِشَارِّييّنْ ذ ثْسُودْجثْ س وغْرُومْ بْڒَا أَنْثُونْ، ");
INSERT INTO rifa_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ؤُ ڒَاغَا إِ مَارَّا ثَامسْمُونْثْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","إِڭَّا مُوسَا أَمْ مَامّشْ ذ أَسْ إِوصَّا سِيذِي ؤُشَا ثْمُونْ ثْمسْمُونْثْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","إِنَّا مُوسَا إِ ثْمسْمُونْثْ: ”وَا ذ مِينْ إِوصَّا سِيذِي أَذْ إِتّْوَاڭّْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","مُوسَا إِسّْقَارّبْ-د هَارُونْ ذ وَارَّاوْ نّسْ ؤُشَا إِسِّيرْذْ إِ-ثنْ س وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","إِسَّارْسْ خَاسْ ثْشَامِيرْ، إِبْيسْ أَسْ س ثْحزَّامْثْ، إِسّْيَارْضْ أَسْ أَسڒْهَامْ. إِڭَّا خَاسْ أَپَالْطُو ؤُشَا إِبْيسْ أَسْ س ثْحزَّامْثْ إِزوّْقنْ ن ؤُپَالْطُو ؤُشَا إِقّنْ أَسْ زَّايسْ أَبَالْثُو. ");
INSERT INTO rifa_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","إِسّمْثنْ خَاسْ ثَاجْمشْثْ ؤُشَا إِڭَّا إِژْرَا ن ’ؤُرِيمْ‘ ذ ’ثُومِيمْ‘ ذِي ثَاجْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","إِڭَّا أَرژّثْ خْ ؤُزدْجِيفْ نّسْ ؤُشَا غَارْ زَّاثْ خْ أَرژّثْ إِڭَّا ثَاڒْوِيحْثْ س نُّووَّارْ ن وُورغْ ن تَّاجْ إِقدّْسنْ ن وعْزَاڒْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","خنِّي إِكْسِي مُوسَا زّشْثْ إِ وذْهَانْ ؤُشَا إِذْهنْ ثَازذِّيغْثْ ذ مَارَّا مِينْ ذَايسْ إِدْجَانْ ؤُشَا إِسّْقدّسْ مَارَّا أَيَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","إِرُوشّْ زَّايسْ خْ ؤُعَالْطَارْ سبْعَا ن ثْوَاڒَاوِينْ ؤُشَا إِذْهنْ عَاوذْ أَعَالْطَارْ ذ مَارَّا ڒقْشُوعْ نّسْ ؤُڒَا ذ ثَابَانْيُوثْ أَكْ-ذ ؤُضَارْ نّسْ مَاحنْذْ أَذْ ثنْ إِسّْقدّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","إِسيّبْ زّشْثْ إِ وذْهَانْ خْ ؤُزدْجِيفْ ن هَارُونْ ؤُشَا إِذْهنْ إِ-ث، حِيمَا أَذْ ث إِسّْقدّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","إِسّْقَارّبْ-د مُوسَا أَرَّاوْ ن هَارُونْ ؤُشَا يَارْضْ أَسنْ ثْشَامِيرَاثْ ؤُشَا إِبْيسْ أَسنْ س ثْحزَّامِينْ ؤُشَا إِنّضْ أَسنْ ثِيشُوشَّايْ أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","إِسّْقَارّبْ-د أَفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ ؤُشَا هَارُونْ ذ وَارَّاوْ نّسْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن ؤُفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","إِغَارْصْ أَسْ ؤُشَا إِكْسِي مُوسَا إِذَامّنْ ؤُشَا إِڭَّا شْوَايْثْ زَّايْسنْ س ؤُضَاضْ نّسْ خْ وَاشَّاونْ ن ؤُعَالْطَارْ إِ إِدْجَانْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ ؤُشَا أَمُّو إِ إِسِّيزْذڭْ أَعَالْطَارْ. خنِّي إِسيّبْ إِذَامّنْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ. أَمُّو إِ إِسّْقدّسْ إِ-ث إِ وصْڒَاحْ خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","إِكْسِي مَارَّا ثَاذُونْثْ نِّي إِدْجَانْ خْ وَاذَانْ ذ مِينْ يُويْڒنْ غَارْ ثْسَا ذ ثْنَاينْ ن ثِيژَّاڒْ ذ ثَاذُونْثْ نْسنْثْ ؤُشَا مُوسَا إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","مَاشَا أَفُونَاسْ أَمژْيَانْ ذ يِيڒمْ نّسْ ذ ويْسُومْ نّسْ ذ أَمسَّاڒْ نّسْ، إِسَّارْغْ إِ-ثنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","إِسّْقَارّبْ-د مُوسَا إِشَارِّي ن ثْغَارْصْثْ ن وشْمَاضْ ؤُشَا هَارُونْ ذ وَارَّاوْ نّسْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن إِشَارِّي. ");
INSERT INTO rifa_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","إِغَارْصْ إِ إِشَارِّي ؤُشَا إِزدْجعْ مُوسَا إِذَامّنْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","إِبْضَا إِشَارِّي ذ إِشدْجِيقنْ نّسْ ؤُشَا إِسّْبخَّارْ مُوسَا أَزدْجِيفْ ذ إِشدْجِيقنْ ذ ثَاذُونْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","إِسِّيرْذْ أَذَانْ ذ إِضَارنْ س وَامَانْ ؤُشَا إِسّْبخَّارْ مُوسَا مَارَّا إِشَارِّي خْ ؤُعَالْطَارْ، أَقَا ذ ثَاغَارْصْثْ ن وشْمَاضْ س يِيشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ، أَقَا ذ ثَاوْهِيبْثْ ن ثْمسِّي إِ سِيذِي، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","إِسّْقَارّبْ-د خنِّي إِشَارِّي نّغْنِي، إِشَارِّي إِ ؤُذشّنْ، ؤُشَا هَارُونْ ذ وَارَّاوْ نّسْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ ن إِشَارِّي. ");
INSERT INTO rifa_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ؤُشَا إِغَارْصْ أَسْ ؤُشَا إِكْسِي مُوسَا شْوَايْثْ زڭْ إِذَامّنْ ؤُشَا إِڭَّا إِ-ثنْ خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن هَارُونْ ؤُ خْ ؤُضَاضْ ن يِيمزْ ن ؤُفُوسْ نّسْ أَفُوسِي ؤُ خْ ؤُضَاضْ ن يِيمزْ ن ؤُضَارْ نّسْ أَفُوسِي. ");
INSERT INTO rifa_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","إِسّْقَارّبْ-د عَاوذْ أَرَّاوْ ن هَارُونْ ؤُشَا إِڭَّا مُوسَا شْوَايْثْ زڭْ إِذَامّنْ خْ إِغسْ ن ؤُمزُّوغْ نْسنْ أَفُوسِي ؤُ خْ ؤُضَاضْ ن يِيمزْ ن ؤُفُوسْ نْسنْ أَفُوسِي ؤُ خْ ؤُضَاضْ ن يِيمزْ ن ؤُضَارْ نْسنْ أَفُوسِي ؤُشَا إِزدْجعْ مُوسَا إِذَامّنْ إِقِّيمنْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","إِكْسِي ثَاذُونْثْ ذ ؤُنوَّارْ س ثَاذُونْثْ ذ مَارَّا ثَاذُونْثْ ثنِّي إِدْجَانْ خْ وَاذَانْ ذ مِينْ يُويْڒنْ غَارْ ثْسَا ذ ثْنَاينْ ن ثِيژَّاڒْ أَكْ-ذ ثَاذُونْثْ نْسنْثْ ؤُڒَا ذ أَشكْرُوذْ أَفُوسِي. ");
INSERT INTO rifa_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","زِي ثْسُودْجثْ س وغْرُومْ بْڒَا أَنْثُونْ، ثنِّي ثُوغَا زَّاثْ إِ وُوذمْ ن سِيذِي، إِكْسِي إِجّْ ن ڒمْسمّمْ بْڒَا أَنْثُونْ ذ يِيشْثْ ن ثمْسمّمْثْ إِسّْوجْذنْ س زّشْثْ ذ إِشْثْ ن ثڒْففْثْ ؤُشَا إِسَّارْسْ إِ-ثنْ خْ ثَاذُونْثْ ؤُ خْ ؤُشكْرُوذْ أَفُوسِي. ");
INSERT INTO rifa_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","إِڭَّا مَارَّا مَانْ أَيَا ذڭْ إِفَاسّنْ ن هَارُونْ ؤُ ذڭْ إِفَاسّنْ ن وَارَّاوْ نّسْ ؤُشَا إِسّنْهزّْ أَيَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","أَوَارْنِي أَسْ إِكْسِي ثنْ مُوسَا عَاوذْ زڭْ إِفَاسّنْ نْسنْ ؤُشَا إِسّْبخَّارْ إِ-ثنْ خْ ؤُعَالْطَارْ، خْ ثْغَارْصْثْ ن وشْمَاضْ. أَقَا ذ ثِيغَارْصَا إِ ؤُذشّنْ س يِيشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ، أَقَا ذ ثَاوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","إِكْسِي مُوسَا إِذْمَارنْ ؤُشَا إِسّنْهزّْ إِ-ثنْ أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. مَانْ أَيَا ذ ثَاسْغَارْثْ ن ؤُشَارِّي إِ ؤُذشّنْ، ثنِّي إِدْجَانْ إِ مُوسَا، أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","إِكْسِي مُوسَا شْوَايْثْ ن زّشْثْ إِ وذْهَانْ ؤُ ن إِذَامّنْ إِ إِدْجَانْ خْ ؤُعَالْطَارْ ؤُشَا إِرُوشّْ مَانْ أَيَا خْ هَارُونْ ؤُ خْ وَارُّوضْ نّسْ، خْ وَارَّاوْ نّسْ ؤُ خْ وَارُّوضْ ن وَارَّاوْ نّسْ، إِنِّي أَكِيذسْ إِدْجَانْ. أَمُّو إِ إِسّْقدّسْ هَارُونْ ذ وَارُّوضْ نّسْ ذ وَارَّاوْ نّسْ ذ وَارُّوضْ ن وَارَّاوْ نّسْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","إِنَّا مُوسَا إِ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ: ”سنْومْ أَيْسُومْ نِّي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا ثشّمْ ث ذِينِّي س وغْرُومْ نِّي إِدْجَانْ ذِي ثْسُودْجثْ ن ثْغَارْصَا إِ ؤُذشّنْ، أَمْ مَامّشْ وصِّيغْ نشّْ، نِّيغْ: ’هَارُونْ ذ وَارَّاوْ نّسْ أَذْ ث شّنْ.‘ ");
INSERT INTO rifa_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","مِينْ إِشطّنْ ن ويْسُومْ ذ وغْرُومْ، أَذْ ث ثسّْشمْضنْ س ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","زڭْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ وَارْ زَّايسْ د-ثتّفّْغمْ شَا سبْعَا ن وُوسَّانْ، أَڒْ أَسّْ مِينْ ذِي إِ غَا كمّْڒنْ وُوسَّانْ ن ؤُڒقّمْ نْومْ، مِينْزِي نتَّا أَذْ كنِّيوْ يَاڒقّمْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","أَمْ مَامّشْ إِڭَّا مَارَّا ذڭْ وَاسّْ-أَ، أَمُّو إِ إِوصَّا سِيذِي، مَاحنْذْ أَذْ خَاومْ إِڭّْ أَصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","أَذْ ثقِّيممْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، أَسّْ ذ دْجِيڒثْ، سبْعَا ن وُوسَّانْ ؤُشَا أَذْ ثطّْفمْ أَحطُّو إِ سِيذِي، حِيمَا وَارْ ثتّْمتِّيمْ شَا، مِينْزِي أَمُّو إِ ث تّْوصِّيغْ نشّْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","هَارُونْ ذ وَارَّاوْ نّسْ ڭِّينْ مَارَّا مِينْ ذ أَسنْ إِوصَّا سِيذِي س ثْسخَّارْثْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا إِمْسَارْ، أَقَا مُوسَا إِڒَاغَا إِ هَارُونْ ذ وَارَّاوْ نّسْ ذ إِمْغَارنْ ن إِسْرَائِيل ");
INSERT INTO rifa_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ؤُشَا إِنَّا إِ هَارُونْ: ”كْسِي غَاركْ إِجّْ ن ؤُعجْمِي، أَمژْيَانْ ن ؤُفُونَاسْ، أَمْ ثْغَارْصْثْ ن دّنْبْ، ؤُڒَا ذ إِجّْ ن إِشَارِّي أَمْ ثْغَارْصْثْ ن وشْمَاضْ، أَقَا أَذْ إِڒِينْ شْنَانْ قَاعْ، ؤُشَا أجّْ إِ-ثنْ أَذْ د-قَارّْبنْ غَارْ وُوذمْ ن سِيذِي.    ");
INSERT INTO rifa_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي: ”كْسِيمْ إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ أَمْ ثْغَارْصْثْ ن دّنْبْ ؤُ كْسِي إِجّْ ن ؤُعجْمِي ذ إِجّْ ن يزْمَارْ، أَقَا أَذْ إِڒِينْ إِمُودَّارنْ شْنَانْ قَاعْ ن إِجّْ ن ؤُسڭّْوَاسْ، إِ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ؤُشَا كْسِي عَاوذْ إِجّْ ن ؤُفُونَاسْ ذ إِجّْ ن ؤُشَارِّي أَمْ ثْغَارْصَا ن ڒهْنَا، مَاحنْذْ أَذْ ثنْ قدّْمنْ ذ دّْبِيحثْ إِ سِيذِي، ؤُڒَا ذ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ إِخدْجْضنْ س زّشْثْ، مِينْزِي أَسّْ-أَ أَذْ أَومْ د-إِبَانْ سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","خنِّي أَوْينْ مِينْ خفْ إِوصَّا مُوسَا غَارْ زَّاثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا ثَامسْمُونْثْ ثْقَارّبْ-د ؤُشَا بدّنْ نِيثْنِي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ؤُشَا مُوسَا إِنَّا: ”ذ مَانْ أَيَا مِينْ خفْ إِوصَّا سِيذِي مَاحنْذْ أَذْ ث ثڭّمْ. ؤُشَا خنِّي أَذْ أَومْ د-إِبَانْ ؤُعُودْجِي ن سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","إِنَّا مُوسَا إِ هَارُونْ: ”قَارّبْ-د غَارْ ؤُعَالْطَارْ ؤُشَا سوْجذْ ثَاغَارْصْثْ نّشْ ن دّنْبْ ذ ثْغَارْصْثْ نّشْ ن وشْمَاضْ ؤُشَا أڭّْ أَصْڒَاحْ خْ يِيخفْ نّشْ ؤُ خْ ڒْڭنْسْ. سوْجذْ عَاوذْ ثَاوْهِيبْثْ ن ڒْڭنْسْ ؤُشَا أڭّْ خَاسنْ أَصْڒَاحْ أَمْ مَامّشْ ث إِوصَّا سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","خنِّي إِقَارّبْ-د هَارُونْ غَارْ ؤُعَالْطَارْ ؤُشَا إِغَارْصْ إِ ؤُعجْمِي ن ثْغَارْصْثْ ن دّنْبْ إِ إِدْجَانْ إِ يِيخفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","أَرَّاوْ ن هَارُونْ إِوْينْ أَسْ-د إِذَامّنْ ؤُشَا نتَّا إِسُّوفْ أَضَاضْ نّسْ ذڭْ إِذَامّنْ ؤُشَا إِڭَّا إِ-ثنْ خْ وَاشَّاونْ ن ؤُعَالْطَارْ. مِينْ إِشطّنْ ن إِذَامّنْ إِسيّبْ إِ-ثنْ غَارْ ؤُضَارْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","إِسّْبخَّارْ ثَاذُونْثْ ذ ثِيژَّاڒْ ذ مِينْ يُويْڒنْ غَارْ ثْسَا ن ثْغَارْصْثْ ن دّنْبْ خْ ؤُعَالْطَارْ أَمْ مَامّشْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","إِسّشْمضْ أَيْسُومْ ذ يِيڒمْ س ثْمسِّي بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","إِغَارْصْ ثَاغَارْصْثْ ن وشْمَاضْ ؤُشَا أَرَّاوْ نْ هَارُونْ قدّْمنْ أَسْ إِذَامّنْ ؤُشَا نتَّا إِزدْجعْ إِ-ثنْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","خنِّي قدّْمنْ أَسْ ثَاغَارْصْثْ ن وشْمَاضْ إِ تّْوَابْضَانْ ذ إِشدْجِيقنْ، ؤُڒَا ذ أَزدْجِيفْ، ؤُشَا نتَّا إِسّْبخَّارْ إِ-ت خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","إِسِّيرْذْ أَذَانْ ذ إِضَارنْ ؤُشَا إِسّْبخَّارْ إِ-ثنْ خْ ثْغَارْصْثْ ن وشْمَاضْ إِ إِدْجَانْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","أَوَارْنِي أَسْ إِسّْقَارّبْ-د ثَاوْهِيبْثْ ن ڒْڭنْسْ. نتَّا إِكْسِي أَمْيَانْ ن ثْغَارْصْثْ ن دّنْبْ إِ ڒْڭنْسْ ؤُشَا إِغَارْصْ أَسْ ؤُشَا إِسّوْجذْ إِ-ث ذ ثَاغَارْصْثْ ن دّنْبْ أَمْ مَامّشْ إِسّوْجذْ إِشَارِّي أَمزْوَارُو. ");
INSERT INTO rifa_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","إِسّْقَارّبْ-د ثَاغَارْصْثْ ن وشْمَاضْ ؤُشَا إِسّوْجذْ إِ-ت عْلَاحْسَابْ لْفَارِيضَا. ");
INSERT INTO rifa_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","إِقدّمْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ؤُشَا إِكْسِي زَّايسْ إِجّْ ن وُورُو إِشُّورْ ؤُشَا إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ، زَّاثْ إِ ثْغَارْصْثْ ن وشْمَاضْ ن صّْبحْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","إِغَارْصْ عَاوذْ إِ ؤُفُونَاسْ ؤُ إِ يِيشَارِّي ن ثْغَارْصْثْ ن ڒهْنَا ذِي طّْوعْ ن ڒْڭنْسْ، ؤُشَا أَرَّاوْ ن هَارُونْ قدّْمنْ أَسْ إِذَامّنْ ؤُشَا إِزدْجعْ إِ-ثنْ خْ ؤُعَالْطَارْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","خْ ثَاذُونْثْ ن ؤُفُونَاسْ ؤُ ن إِشَارِّي: أَنوَّارْ س ثَاذُونْثْ نّسْ ذ مِينْ إِذْڒِينْ أَضَانْ ذ ثِيژَّاڒْ ذ مِينْ يُويْڒنْ غَارْ ثْسَا، ");
INSERT INTO rifa_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","أَقَا سَّارْسنْ ثَاذُونْثْ نِّي خْ إِذْمَارنْ ؤُشَا نتَّا إِسّْبخَّارْ ثَاذُونْثْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","مَاشَا إِذْمَارنْ ذ ؤُشكْرُوذْ أَفُوسِي إِسّنْهزّْ إِ-ثنْ هَارُونْ أَمشْنَاوْ إِشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي، أَمْ مَامّشْ ث إِوصَّا مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","خنِّي إِسّْڭعّذْ هَارُونْ إِفَاسّنْ نّسْ غَارْ ڒْڭنْسْ ؤُشَا إِبَاركْ إِ-ثنْ ؤُشَا إِهْوَا أَوَارْنِي ڒَامِي إِقدّمْ ثَاغَارْصْثْ ن دّنْبْ ذ ثْغَارْصْثْ ن وشْمَاضْ ذ ثْغَارْصْثْ ن ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ؤُشَا يُوذفْ مُوسَا أَكْ-ذ هَارُونْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا نِيثْنِي فّْغنْ زَّايسْ عَاوذْ ؤُشَا بَارْكنْ ڒْڭنْسْ ؤُشَا إِبَانْ ؤُعُودْجِي ن سِيذِي إِ مَارَّا ڒْڭنْسْ ");
INSERT INTO rifa_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ؤُشَا ثفّغْ-د ثْمسِّي زِي زَّاثْ إِ وُوذمْ ن سِيذِي، ثشَّا ثَاغَارْصْثْ ن وشْمَاضْ خْ ؤُعَالْطَارْ ؤُڒَا ذ ثَاذُونْثْ. ؤُمِي إِژْرَا ڒْڭنْسْ مَانْ أَيَا، سْڒِيوڒْونْ ؤُشَا وْضَانْ غَارْ ثمُّورْثْ خْ ؤُغمْبُوبْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","نَاذَابْ ذ أَبِيهُو، أَرَّاوْ ن هَارُونْ، كْسِينْ كُوڒْ إِجّْ ڒْمجْمَارْ نّسْ ؤُشَا ڭِّينْ ذَايسْ ڒبْخُورْ ؤُشَا أَمُّو إِ يِيوْينْ نِيثْنِي ثِيمسِّي ثغْرِيبْ زَّاثْ إِ وُوذمْ ن سِيذِي، مِينْ وَارْ ذ أَسنْ إِوصَّا نتَّا. ");
INSERT INTO rifa_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ثفّغْ-د ثْمسِّي زِي زَّاثْ إِ وُوذمْ ن سِيذِي، ثشّْ إِ-ثنْ ؤُشَا مُّوثنْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","إِنَّا مُوسَا إِ هَارُونْ: ”ذ مَانْ أَيَا خْ مِينْ خفْ إِسِّيوڒْ سِيذِي ؤُمِي إِنَّا: ’س يِينِّي إِ غَارِي د غَا إِقَارّْبنْ أَذْ تّْوَاقدّْسغْ ؤُشَا زَّاثْ إِ وُوذمْ ن مَارَّا ڒْڭنْسْ أَذْ تّْوَاسّْعُودْجغْ.‘ “ ؤُشَا إِسْقَارْ هَارُونْ. ");
INSERT INTO rifa_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","إِڒَاغَا مُوسَا إِ مِيشَايِيلْ ذ إِ إِلْصَافَانْ، أَرَّاوْ ن عُوزِّييِيلْ، عمِّيسْ ن هَارُونْ، ؤُشَا إِنَّا أَسنْ: ”قَارّْبمْ-د، ثَارْبُومْ أَيْثْمَاثْومْ زِي قِيبَاتْشْ ن زَّاوشْثْ إِقدّْسنْ، أَوْيِي ثنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","قَارّْبنْ-د نِيثْنِي ؤُشَا أَرْبُونْ ثنْ ذِي ثْشَامِيرَاثْ نْسنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ، أَمْ مَامّشْ ث إِنَّا مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","خنِّي إِنَّا مُوسَا إِ هَارُونْ ؤُ إِ أَلِيعَازَارْ ذ إِثَامَارْ، أَرَّاوْ نّسْ: ”وَارْ ضدْجْقمْ إِ ؤُشُوَّافْ خْ إِزدْجِيفنْ نْومْ نِيغْ تّْشَارّْڭمْ أَرُّوضْ نْومْ إِ وشْضَانْ، حِيمَا وَارْ ثتّْمتِّيمْ ؤُشَا أَذْ يِيڒِي ؤُذُوقّزْ ن وغْضَابْ خْ مَارَّا ثَامسْمُونْثْ. مَاشَا أَيْثْمَاثْومْ، مَارَّا ثَادَّارْثْ ن إِسْرَائِيل، أَذْ رُونْ خْ ثْمسِّي-يَا، ثنِّي إِسّشْمضْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","وَارْ د-تّفّْغمْ شَا زِي وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، حِيمَا وَارْ ثتّْمتِّيمْ شَا، مِينْزِي زّشْثْ ن وذْهَانْ ن سِيذِي أَقَا ت خَاومْ.“ ؤُشَا نِيثْنِي طَّاعنْ إِ وَاوَاڒْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","إِسِّيوڒْ سِيذِي أَكْ-ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","”وَارْ إِعدّڒْ أَذْ ثْسسّذْ بِينُو نِيغْ شّْرَابْ إِجهْذنْ خْمِي غَا ثَاذْفمْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، شكْ لَّ ؤُڒَا ذ إِحنْجِيرنْ نّشْ نِّي أَكِيذكْ لَّ، حِيمَا وَارْ ثتّْمتِّيمْ شَا. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ، ");
INSERT INTO rifa_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","حِيمَا أَذْ أَفْ ثْزمَّارمْ أَذْ ثْفَارْزمْ جَارْ مِينْ إِدْجَانْ إِقدّْسنْ ذ مِينْ وَارْ إِدْجِينْ إِقدّْسنْ ؤُ جَارْ مِينْ إِصْفَانْ ذ مِينْ وَارْ إِصْفِينْ، ");
INSERT INTO rifa_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ؤُ حِيمَا أَذْ ثسّْڒمْذمْ إِ أَيْثْ ن إِسْرَائِيل مَارَّا ثِيوصَّا نِّي غَارْسنْ إِسِّيوڒْ سِيذِي س ثْسخَّارْثْ ن مُوسَا.“ ");
INSERT INTO rifa_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ؤُشَا إِسِّيوڒْ مُوسَا أَكْ-ذ هَارُونْ ؤُ أَكْ-ذ أَلِيعَازَارْ ذ إِثَامَارْ، أَرَّاوْ نّسْ إِقِّيمنْ: ”كْسِيمْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ نِّي إِشطّنْ زِي ثوْهِيبِينْ ن ثْمسِّي إِ سِيذِي ؤُشَا شّمْ ت بْڒَا أَنْثُونْ زَّاثْ إِ ؤُعَالْطَارْ، مِينْزِي أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","أَذْ ت ثشّمْ ذڭْ إِجّْ ن ومْشَامْ إِقدّْسنْ، مِينْزِي ثَا ذ ثَاغَارْصْثْ إِ شكْ ؤُ إِ إِحنْجِيرنْ نّشْ زِي ثوْهِيبِينْ ن ثْمسِّي ن سِيذِي، مِينْزِي أَمُّو إِ ذ أَيِي إِتّْوَاوصَّا. ");
INSERT INTO rifa_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ذڭْ إِجّْ ن ومْشَانْ إِصْفَا أَذْ ثشّمْ عَاوذْ إِذْمَارنْ ن ونْهزِّي ذ ؤُشكْرُوذْ ن ثوْهِيبْثْ إِ د-إِتّْوَاسّْڭعّْذنْ، شكْ ذ إِحنْجِيرنْ نّشْ ذ ثْحنْجِيرِينْ نّشْ أَكِيذكْ، مِينْزِي ذ مَانْ أَيَا ذ ثَاسْغَارْثْ نّشْ ذ ثَاسْغَارْثْ ن ثَارْوَا نّشْ زِي ثْغَارْصَا نْ ڒهْنَا ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","أَذْ أَوْينْ أَشكْرُوذْ ن ثوْهِيبْثْ إِ د-إِتّْوَاسّْڭعّْذنْ ؤُڒَا ذ إِذْمَارنْ ن ونْهزِّي أَكْ-ذ ثوْهِيبِينْ ن ثْمسِّي ن ثَاذُونْثْ، مَاحنْذْ أَذْ ثنْ سّنْهزّنْ زَّاثْ إِ وُوذمْ ن سِيذِي أَمْ ثوْهِيبْثْ ن ونْهزِّي. أَقَا ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ شكْ ؤُ إِ إِحنْجِيرنْ نّشْ أَكِيذكْ، أَمْ مَامّشْ ث إِوصَّا سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ؤُشَا مُوسَا يَارْزُو س شْضَارثْ خْ ؤُمْيَانْ ن ثْغَارْصْثْ ن دّنْبْ، مَاشَا خْزَارْ، إِشمْضْ. خنِّي إِفُّوڭمْ خْ أَلِيعَازَارْ ذ إِثَامَارْ، أَرَّاوْ إِقِّيمنْ ن هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","”مَايمِّي وَارْ ثشِّيمْ ثَاغَارْصْثْ ن دّنْبْ ذڭْ ومْشَانْ إِقدّْسنْ؟ مِينْزِي أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ ؤُشَا نتَّا إِوْشَا أَومْ ت-إِ-د حِيمَا كنِّيوْ أَذْ ثَارْبُومْ ڒْمُوعْصِييّثْ ن ثْمسْمُونْثْ، مَاحنْذْ أَذْ خَاسنْ ثڭّمْ أَصْڒَاحْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","خْزَارمْ، حْذَامْ وَارْ سِّيذْفنْ وَالُو زڭْ إِذَامّنْ ذَاخڒْ إِ زَّاوشْثْ إِقدّْسنْ. ثُوغَا إِتّْخصَّا كنِّيوْ أَذْ ت ثشّمْ ذِي زَّاوشْثْ إِقدّْسنْ أَمْ مَامّشْ ذ أَومْ وصِّيغْ نشّْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","خنِّي إِسِّيوڒْ هَارُونْ أَكْ-ذ مُوسَا: ”خْزَارْ، أَسّْ-أَ أَقَا قدّْمنْ ثَاغَارْصْثْ ن دّنْبْ ذ ثْغَارْصْثْ ن وشْمَاضْ زَّاثْ إِ وُوذمْ ن سِيذِي. مَاڒَا نشّْ، أَوَارْنِي ڒَامِي خَافِي كّنْثْ ثْمسْڒَايِينْ-أَ، أَقَا شِّيغْ زِي ثْغَارْصْثْ ن دّنْبْ أَسّْ-أَ، مَا خنِّي مَانْ أَيَا إِشْنَا ذِي ثِيطَّاوِينْ ن سِيذِي؟“ ");
INSERT INTO rifa_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ؤُمِي إِسْڒَا مُوسَا أَيَا، إِبَانْ أَسْ-د مَانْ أَيَا ذ لمْلِيحْ ذِي ثِيطَّاوِينْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا أَسنْ: ");
INSERT INTO rifa_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِيمْ: ’إِنَا أَقَا أَثنْ ذ ڒْمَاڒْ، إِنِّي ؤُمِي إِعدّڒْ أَذْ ثشّمْ زِي جَارْ مَارَّا ڒْمَاڒْ نِّي ذِينْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","إِعدّڒْ أَذْ ثشّمْ زِي مَارَّا ڒْمَاڒْ إِ غَارْ ثدْجَا ثشْضشْثْ إِمّْسبْضَانْ، أَقَا فَارْقَا ن ثشْضشْثْ إِمْسّبْضَانْ قَاعْ، ؤُ سنّجْ إِ مَانْ أَيَا تَّارَّانْ إِفژْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","مَاشَا زڭْ إِنِّي إِتَّارَّانْ إِفژْ ذ يِينِّي غَارْ ثدْجَا ثشْضشْثْ إِمّْسبْضَانْ، وَارْ تّتّمْ إِنَا: أَڒْغمْ، مِينْزِي إِتّفّژْ، مَاشَا وَارْ غَارسْ بُو ثشْضشْثْ إِمّْسبْضَانْ، س ؤُينِّي أَقَا إِخْمجْ إِ كنِّيوْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","أَكَاوْكَا ن ثصْضَارْثْ، مِينْزِي إِتَّارَّا إِفژْ، مَاشَا ثَاشْضشْثْ وَارْ ثمّْسبْضِي، ؤُ س ؤُينِّي أَقَا إِخْمجْ إِ كنِّيوْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","أَمنِّي أَيَارْزِيزْ، مِينْزِي إِتَّارَّا إِفژْ، مَاشَا وَارْ غَارسْ ثَاشْضشْثْ إِمّْسبْضَانْ، س ؤُينِّي أَقَا إِخْمجْ إِ كنِّيوْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","عَاوضْ إِڒفْ، مِينْزِي غَارسْ ثَاشْضشْثْ إِمّْسبْضَانْ ؤُشَا أَقَا فَارْقَا ن ثشْضشْثْ إِمّْسبْضَانْ قَاعْ، مَاشَا وَارْ إِتَّارِّي إِفژْ، س ؤُينِّي أَقَا إِخْمجْ إِ كنِّيوْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","زڭْ ويْسُومْ نْسنْ وَارْ زَّايسْ تّتّمْ نِيغْ أَذْ ثْحَاذَامْ ڒْخشْبَاثْ نْسنْ، أَقَا خمْجنْ إِ كنِّيوْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","”إِنَا إِعدّڒْ أَذْ ثنْ ثشّمْ زِي جَارْ مَارَّا إِمُودَّارنْ نِّي إِدَّارنْ ذڭْ وَامَانْ: مَارَّا وِي غَارْ إِدْجَا وَافْرِيونْ ذ ثقْشُورْثْ ذڭْ وَامَانْ ؤُ ذِي ڒبْحُورْ ؤُ ذِي ثْغزْرَاثِينْ، إِنَا إِعدّڒْ أَذْ ثنْ ثشّمْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","مَاشَا مَارَّا وِي وَارْ غَارْ يدْجِي إِفْرِيونْ نِيغْ ثَاقْشُورْثْ ذِي ڒبْحُورْ ؤُ ذِي ثْغزْرَاثِينْ، زِي جَارْ مَارَّا إِ زِي سّفّْينْ أَمَانْ ؤُڒَا زِي جَارْ مَارَّا مِينْ إِدَّارنْ ذڭْ وَامَانْ، أَذْ أَومْ يِيڒِي ذ نّْعِي. ");
INSERT INTO rifa_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","وَاهْ أَذْ أَومْ يِيڒِي ذ نّْعِي. وَارْ إِعدّڒْ أَذْ ثشّمْ زڭْ ويْسُومْ نْسنْ ؤُ ڒْخشْبَاثْ نْسنْ أَذْ غَارْومْ إِڒِينْثْ ذ نّْعِي. ");
INSERT INTO rifa_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","مَارَّا مِينْ إِدْجَانْ ذڭْ وَامَانْ بْڒَا إِفْرِيونْ ذ ثقْشُورْثْ، أَذْ غَارْومْ يِيڒِي ذ نّْعِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","”زڭْ إِجْضَاضْ أَذْ غَارْومْ إِڒِينْ إِنَا ذ نّْعِي، وَارْ زَّايْسنْ تّتّمْ شَا، أَقَا أَثنْ ذ نّْعِي: أَڭِيذرْ، إِسْغِي، أَڭِيذرْ ن ڒبْحَارْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","أَشفَّارْ إِطَّاونْ س ثَازْڒَا، أَمسّْغُويْ أَمُوقْضِيعْ ن ثِيطَّاوِينْ أَكْ-ذ مَارَّا مَارْكَاثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","مَارَّا مَارْكَاثْ ن ؤُبَاغڒْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","يدْجِيسْ ن ثْغُويِّيثْ، أَعنَّافْ، أَجْضِيضْ ن ڒبْحَارْ، ڒْبَازْ أَكْ-ذ مَارْكَاثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","أَحمَّاڒْ ن ڒْكَاسْ، بُو-ثْشَارَارُّوثْ، بُو-ؤُسُوضِي ن ڒْموْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","بُو-يُونْثَاحْ، بُو-ؤُعُوقِّي، بُو-ؤُحَاوَارْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","أَبلَّارْجْ، بُو-ؤُسُوضِي إِعفّْننْ أَكْ-ذ مَارَّا مَارْكَاثْ نّسْ، ذُونْذُونْ ذ ڒْوضْوَاضْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","”مَارَّا وِي غَارْ إِدْجَا أَفْرِيونْ إِ إِتّْبُوعنْ ؤُ إِڭُّورنْ خْ أَربْعَا ن إِضَارنْ، أَذْ غَارْومْ يِيڒِي ذ نّْعِي. ");
INSERT INTO rifa_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","مَاشَا زِي مَارَّا إِنِّي إِتّْبُوعنْ أَمْ غَارْسنْ أَفْرِيونْ ؤُ ڭُّورنْ خْ أَربْعَا ن إِضَارنْ، إِعدّڒْ إِ كنِّيوْ أَذْ ثشّمْ إِنِّي غَارْ إِدْجَا إِضَارنْ إِ ونْڭَازْ سنّجْ إِ إِضَارنْ نْسنْ إِ ثشْڒِي، حِيمَا أَذْ زَّايْسنْ نڭْزنْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","إِنَا ثْزمَّارمْ أَذْ زَّايْسنْ ثشّمْ: ثَامُورْغِي ن ويْڒَافْ أَكْ-ذ مَارْكَاثْ نّسْ، ثَامُوغْرِي ن ثصْضَارْثْ أَكْ-ذ مَارْكَاثْ نّسْ، ثَامُوغْرِي إِنڭّْزنْ أَكْ-ذ مَارْكَاثْ نّسْ ذ ثَامُوغْرِي إِڒحّْفنْ أَكْ-ذ مَارْكَاثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","مَارَّا وِي غَارْ إِدْجَا أَفْرِيونْ إِ إِتّْبُوعنْ ؤُ غَارسْ أَربْعَا ن إِضَارنْ، أَذْ غَارْومْ يِيڒِي ذ نّْعِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","”س إِمُودَّارنْ-أَ إِ غَا ثتّْوَاخمْجمْ. مَارَّا وِي غَا إِحَاذَانْ ڒْخشْبَاثْ نْسنْ، أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","مَانْونْ يِيوْينْ شَا زِي ڒْخشْبَاثْ نْسنْ، أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","مَارَّا ڒبْهَايمْ، إِنِّي غَارْ ثدْجَا ثشْضشْثْ إِمّْسبْضَانْ إِ زِي فَارْقَا ن ثشْضشْثْ وَارْ ثْفَارْقْ قَاعْ، ؤُڒَا وَارْ تَّارَّانْ إِفژْ، أَذْ غَارْومْ إِڒِينْ خمْجنْ. مَارَّا وِي ثنْ إِ غَا إِحَاذَانْ، أَذْ يِيڒِي إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","كُوڒْ أَمُودَّارْ جَارْ إِمُودَّارنْ إِ إِڭُّورنْ خْ أَربْعَا ن ثْڒقَّا ن إِضَارنْ نْسنْ، أَذْ غَارْومْ يِيڒِي إِخْمجْ. مَارَّا وِي غَا إِحَاذَانْ ڒْخشْبَاثْ نْسنْ، أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","وِي يِيوْينْ شَا ن ڒْخشْبَاثْ نْسنْ، أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثْمذِّيثْ. أَذْ أَومْ إِڒِينْ خمْجنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","”زِي جَارْ إِمُودَّارنْ إِتّْبُوعنْ، إِنِّي إِتّْبُوعنْ خْ ثمُّورْثْ، ذ إِنَا أَذْ خَاومْ إِڒِينْ خمْجنْ إِ كنِّيوْ: أَجَارْبُوعْ، أَغرْذَا، إِشْفَارْ أَكْ-ذ مَارْكَاثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","إِقّْلِي، ثَاكْنَاكَارْثْ، أَزرْمُومُّويْ، أَحْذِيضْ ذ ثَاثَا. ");
INSERT INTO rifa_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","إِنَا أَذْ غَارْومْ إِڒِينْ خمْجنْ زِي جَارْ مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ. مَارَّا وِي ثنْ إِ غَا إِحَاذَانْ أَوَارْنِي ڒْموْثْ نْسنْ، أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","مَارَّا مِينْ خفْ إِوْضَا شَا زِي ڒْخشْبَاثْ نْسنْ أَذْ يِيڒِي إِخْمجْ، نِيغْ إِشْثْ ن ڒْقشْعثْ ن ثفْڒَاوْثْ، نِيغْ أَرُّوضْ، نِيغْ ثِيڒْمشْثْ، نِيغْ ثَاخَانْشثْ، نِيغْ مِينْ مَا ڒْقشْعثْ إِ خفْ إِوْضَا شَا زَّايْسنْثْ، إِتّْخصَّا أَذْ إِتّْوَاسَّارْسْ ذڭْ وَامَانْ، أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ ؤُ أَوَارْنِي أَيَا أَذْ يِيڒِي إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","مَارَّا ڒْقشْعثْ ن ثْڒَاخْثْ، ثنِّي ؤُمِي ذِي إِوْضَا شْوَايْثْ زَّايسْ، أَقَا مَارَّا مِينْ ذَايسْ إِدْجَانْ أَذْ يِيڒِي إِخْمجْ ؤُشَا إِتّْخصَّا إِ كنِّيوْ أَذْ ثَارْژمْ طّبْصِي. ");
INSERT INTO rifa_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","مَارَّا مَاشَّا نِّي تّْنُومَانْ إِوْذَانْ أَذْ شّنْ، ثنِّي خْ وْضَانْ وَامَانْ نِّي، أَذْ ثِيڒِي ثخْمجْ، ؤُ مَارَّا ثِيسِّيثْ نِّي تّْنُومَانْ إِوْذَانْ أَذْ سْونْ، مَامّشْ مَا ثڭَّا ڒْقشْعثْ إِ ذِي ثدْجَا مَاشَّا نِيغْ ثِيسِّيثْ، أَذْ ثِيڒِي ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","مَارَّا مِينْ خفْ إِوْضَا شَا ن ڒْخشْبَاثْ نْسنْ، أَذْ يِيڒِي إِخْمجْ. أَفَارْنُو ذ ثْزوْضَا أَذْ تّْوَارْژنْ، أَقَا خمْجنْ ؤُشَا أَذْ غَارْومْ إِڒِينْ خمْجنْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","مَاشَا ڒْعُونْصَارْ نِيغْ ذ أَنُو مَانِي غَارْ سِّيزّْڒنْ أَمَانْ، أَذْ يِيڒِي إِزْذڭْ. مَاشَا وِي غَا إِحَاذَانْ ڒْخشْبَاثْ نْسنْ، أَذْ يِيڒِي إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ؤُشَا مَاڒَا إِوْضَا شَا زِي ڒْخشْبَاثْ نْسنْ خْ شَا ن زَّارِيعثْ إِ ؤُزَارْعْ، ثنِّي إِتّْخصَّا عَاذْ أَذْ زَارْعنْ، خنِّي أَذْ ثِيڒِي ثِيزْذڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","مَاشَا مَاڒَا سيّْبنْ أَمَانْ خْ زَّارِيعثْ ؤُشَا إِوْضَا خَاسْ شَا زِي ڒْخشْبَاثْ نْسنْ، خنِّي أَذْ غَارْومْ ثِيڒِي زَّارِيعثْ نِّي ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ؤُشَا مَاڒَا إِمُّوثْ إِجّْ زِي جَارْ ڒْمَاڒْ نِّي ثشِّيمْ، خنِّي وِي غَا إِحَاضَانْ ڒْخشْبثْ نّسْ، أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ونِّي إِشّنْ زِي ڒْخشْبثْ نّسْ، أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ونِّي يَارْبُونْ شَا زِي ڒْخشْبثْ نّسْ، أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","كُوڒْ أَمُودَّارْ إِتّْبُوعنْ خْ ثمُّورْثْ، أَقَا-ث ذ نّْعِي. وَارْ إِعدّڒْ أَذْ إِتّْوَاشّْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","زِي جَارْ مَارَّا إِمُودَّارنْ إِتّْبُوعنْ، إِنِّي إِتّْبُوعنْ خْ وُوذمْ ن ثمُّورْثْ، وَارْ تّتّمْ شَا مَارَّا مِينْ إِڭُّورنْ خْ ؤُعذِّيسْ نِيغْ مَارَّا مِينْ إِڭُّورنْ خْ أَربْعَا ن إِضَارنْ أَڒْ مَارَّا مِينْ إِڭُّورنْ خْ وَاطَّاسْ ن إِضَارنْ، مِينْزِي أَقَا أَثنْ ذ نّْعِي. ");
INSERT INTO rifa_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","وَارْ تّڭّمْ نّْعِي إِ ڒعْمُورْ نْومْ س مَارَّا إِمُودَّارنْ إِتّْبُوعنْ نِّي ذِينْ إِتّْبُوعنْ خْ وُوذمْ ن ثمُّورْثْ، وَارْ زَّايسْ سّْخمَّاجمْ إِخفْ نْومْ أَڒَامِي أَذْ زَّايْسنْ ثْخمْجمْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","مِينْزِي نشّْ ذ سِيذِي، أَربِّي نْومْ. كنِّيوْ أَذْ ثسّْقذْسمْ إِخفْ نْومْ ؤُشَا أَذْ ثِيڒِيمْ ذ إِمْقدَّاسنْ، مِينْزِي نشّْ أَقَا ذ أَمْقدَّاسْ. وَارْ سّْخمَّاجمْ ڒعْمُورْ نْومْ س مَارَّا إِمُّوذَارنْ إِتّْبُوعنْ، إِنِّي إِتّْبُوعنْ خْ وُوذمْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","مِينْزِي نشّْ ذ سِيذِي، ونِّي كنِّيوْ د-إِسّْڭعّْذنْ زِي ثمُّورْثْ ن مِيصْرَا، حِيمَا أَذْ إِڒِيغْ ذ أَربِّي نْومْ. إِڒِيمْ ذ إِمْقدَّاسنْ، مَاغَارْ أَقَا نشّْ ذ أَمْقدَّاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","وَا ذ أَزرْفْ خْ ڒْمَاڒْ، خْ إِجْضَاضْ ؤُ خْ مَارَّا إِمُودَّارنْ نِّي زَّايْسنْ إِسّفْينْ وَامَانْ ؤُشَا خْ مَارَّا إِمُودَّارنْ نِّي إِتّْبُوعنْ خْ ثمُّورْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","حِيمَا أَذْ إِتّْوَاڭّْ ڒْفَارْقْ جَارْ مِينْ إِخمْجنْ ذ مِينْ إِزْذِيڭنْ ؤُ جَارْ إِمُودَّارنْ إِنِّي إِعدّْڒنْ إِ مَاشَّا ذ إِمُودَّارنْ إِنِّي وَارْ إِعدّْڒنْ إِ مَاشَّا. ");
INSERT INTO rifa_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي: ’مَاڒَا ثكْسِي إِشْثْ ن ثمْغَارْثْ دّيْسثْ ؤُشَا ثُورُووْ-د أَحنْجِيرْ، أَذْ ثِيڒِي ثخْمجْ سبْعَا ن وُوسَّانْ. أَذْ ثِيڒِي ثخْمجْ أَمْ ذڭْ وُوسَّانْ ن وعْزَاڒْ خْمِي خَاسْ إِذَامّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا إِتّْخصَّا أَذْ إِتّْوَاخْثنْ أَيْسُومْ ن ڒعْذَاڒْيثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","أَوَارْنِي مَانْ أَيَا أَذْ ثقِّيمْ ثْڒَاثَا ؤُ-ثْڒَاثِينْ ن وُوسَّانْ ذڭْ إِذَامّنْ ن ؤُسِيزْذڭْ نّسْ. وَارْ ثتّْحِيذِي وَالُو زِي مِينْ إِدْجَانْ إِقدّسْ ؤُ وَارْ ثتّْرَاحْ غَارْ زَّاوشْثْ إِقدّْسنْ أَڒْ غَا كمّْڒنْ وُوسَّانْ ن ؤُسِيزْذڭْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","مَاڒَا ثُورُووْ ذ ثَاحنْجِيرْثْ، أَذْ ثِيڒِي ثخْمجْ ثْنَاينْ ن سِّيمَانَاثْ، أَمْ ذڭْ وُوسَّانْ ن وعْزَاڒْ نّسْ. أَوَارْنِي مَانْ أَيَا أَذْ ثقِّيمْ ستَّا ؤُ-ستِّينْ ن وُوسَّانْ ذڭْ إِذَامّنْ ن ؤُسِيزْذڭْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","خْمِي غَا كمّْڒنْ وُوسَّانْ ن ؤُسِيزْذڭْ ن مِّيسْ نِيغْ ن يدْجِيسْ، خنِّي أَذْ ثَاوِي إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ نِيغْ إِجّْ ن وذْبِيرْ ذ أَمژْيَانْ نِيغْ إِشْثْ ن ثجْلِيلِّيحْثْ أَمْ ثْغَارْصْثْ ن دّنْبْ غَارْ ؤُكهَّانْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ذ نتَّا أَذْ يَاوِي مَانْ أَيَا زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَذْ خَاسْ إِڭّْ أَصْڒَاحْ. خنِّي أَذْ ثِيڒِي ثِيزْذڭْ زِي ڒْعُونْصَارْ ن إِذَامّنْ نّسْ. وَا ذ أَزرْفْ إِ ثنِّي إِ غَا يَارْونْ إِجّْ ن مِّيسْ نِيغْ إِشْثْ ن يدْجِيسْ. ");
INSERT INTO rifa_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","مَاڒَا وَارْ ثِيوِيضْ أَذْ ثَاوِي إِجّْ زڭْ وُودْجِي، خنِّي أَذْ ثطّفْ ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ ثْنَاينْ ن إِذْبِيرنْ إِمژْيَاننْ، إِجّْ إِ ثْغَارْصْثْ ن وشْمَاضْ ؤُ إِجّْ إِ ثْغَارْصْثْ ن دّنْبْ، ؤُشَا أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ. خنِّي أَذْ ثِيڒِي ثِيزْذڭْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","”مَاڒَا إِجّْ ن بْنَاذمْ غَارسْ ذِي ثڒْمشْثْ ن أَرِّيمثْ نّسْ أَعبُّوزْ نِيغْ إِشْثْ ن ثْحبُّوشْثْ نِيغْ إِجّْ ن ونْڭَازْ إِشّمْڒڒْ، ؤُشَا وَانِيثَا إِزمَّارْ أَذْ إِذْوڒْ ذ ؤُضُونْ ن ڒْبَارْصْ ذِي ثڒْمشْثْ ن أَرِّيمثْ نّسْ، أَذْ ث أَوْينْ غَارْ هَارُونْ، أَكهَّانْ، نِيغْ غَارْ يِيجّنْ زڭْ وَارَّاوْ نّسْ، غَارْ إِكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","أَكهَّانْ أَذْ إِخْزَارْ غَارْ وُوضُونْ ذِي ثڒْمشْثْ ن أَرِّيمثْ نّسْ ؤُشَا مَاڒَا إِژْرَا أَقَا إِژُوطَّانْ ذڭْ ومْشَانْ ن وُوضُونْ ذوْڒنْ ذ إِشمْڒَاڒنْ ؤُشَا إِبَانْ وُوضُونْ عَاذْ يُودْجغْ خْ ثڒْمشْثْ ن أَرِّيمثْ نّسْ، أَقَا خنِّي ذ ؤُضُونْ ن ڒْبَارْصْ. خْمِي ث غَا إِژَارْ ؤُكهَّانْ، أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","مَاشَا مَاڒَا أَنْڭَازْ إِشّمْڒڒْ ذِي ثڒْمشْثْ ن أَرِّيمثْ نّسْ ذ أَشمْڒَاڒْ ؤُ وَارْ يُودْجِيغْ خْ ثڒْمشْثْ ؤُ إِژطَّانْ وَارْ ذْوِيڒنْ ذ إِشمْڒَاڒنْ، خنِّي أَذْ إِبلّعْ ؤُكهَّانْ خْ ونِّي ذِي إِدْجَا ؤُضُونْ نِّي سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","مَاڒَا إِژْرَا إِ-ث ؤُكهَّانْ ذڭْ وَاسّْ وِيسّْ سبْعَا ؤُشَا إِژْرَا أَقَا ؤُضُونْ أَمنِّي إِقِّيمْ، وَارْ إِمْغِيرْ وُوضُونْ ذِي ثڒْمشْثْ، خنِّي أَذْ ث إِبلّعْ ؤُكهَّانْ عَاوذْ سبْعَا ن وُوسَّانْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ث إِژَارْ ؤُكهَّانْ عَاوذْ ؤُشَا مَاڒَا إِبَانْ أَقَا ؤُضُونْ يَارْسَا ؤُشَا وَارْ إِمْغِيرْ عَاذْ كْثَارْ خْ ثڒْمشْثْ، خنِّي أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمزْذَاڭْ. ثُوغَا-ت ذ إِشْثْ ن ثْفُورِييْ. أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ ؤُشَا أَذْ يِيڒِي إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","مَاشَا مَاڒَا إِمْغَارْ وُوضُونْ أَطَّاسْ خْ ثڒْمشْثْ أَوَارْنِي ڒَامِي ث إِژْرَا ؤُكهَّانْ ذِي طّْوعْ ن ؤُسِيزْذڭْ نّسْ، إِتّْخصَّا أَذْ إِسّْشنْ إِخفْ نّسْ إِ ؤُكهَّانْ ثْوَاڒَا نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","مَاڒَا إِژْرَا ؤُكهَّانْ، أَقَا ڒهْڒَاشْ إِمْغَارْ خْ ثڒْمشْثْ، أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. أَقَا-ث ذ ڒهْڒَاشْ ن ڒْبَارْصْ إِ إِدْجَا. ");
INSERT INTO rifa_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","خْمِي ؤُضُونْ نْ ڒْبَارْصْ أَقَا-ث ذڭْ إِجّْ ن بْنَاذمْ، أَذْ ث أَوْينْ غَارْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","مَاڒَا إِژْرَا ؤُكهَّانْ، أَقَا إِبَانْ إِجّْ ن ؤُعبُّوزْ ذ أَشمْڒَاڒْ ذِي ثڒْمشْثْ، ؤُ إِژطَّانْ ذوْڒنْ ذ إِشمْڒَاڒنْ ؤُ إِبَانْ-د ويْسُومْ إِدَّارْ ذڭْ ؤُعبُّوزْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","أَقَا-ث ذ ڒْبَارْسْ أَقْذِيمْ ذِي ثڒْمشْثْ ن أَرِّيمثْ نّسْ ؤُشَا أَكهَّانْ أَذْ زَّايسْ إِبَارّحْ ذ أَمخْمُوجْ. وَارْ خَاسْ إِتّْبلِّيعْ شَا، مِينْزِي نتَّا أَقَا إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","مَاڒَا يُويُورْ ڒْبَارْصْ خْ ثِيڒْمشْثْ مَارَّا ؤُشَا إِذْڒَا ڒْبَارْصْ مَارَّا ثِيڒْمشْثْ ن ونِّي غَارْ إِدْجَا ؤُضُونْ زڭْ ؤُزدْجِيفْ نّسْ أَڒْ إِضَارنْ نّسْ، أَڒْ مَانِي إِزمَّارْ أَذْ إِژَارْ ؤُكهَّانْ س ثِيطَّاوِينْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ؤُشَا إِژْرَا إِ-ث ؤُكهَّانْ، إِژْرَا ڒْبَارْسْ إِذْڒَا مَارَّا أَرِّيمثْ نّسْ، خنِّي نتَّا أَذْ إِبَارّحْ ذ أَمزْذَاڭْ إِ ونِّي ذِي إِدْجَا وُوضُونْ. ثِيڒْمشْثْ أَقَا-ت ذ ثَاشمْڒَاتْشْ قَاعْ. نتَّا أَقَا إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","مَاشَا ذڭْ وَاسّْ مَانِي ذَايسْ إِ غَا د-إِبَانْ ويْسُومْ إِدَّارْ، أَذْ يِيڒِي إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","مَاڒَا إِژْرَا ؤُكهَّانْ أَيْسُومْ نِّي إِدَّارْ، أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. أَيْسُومْ إِدَّارنْ إِخْمجْ، أَقَا-ث ذ ڒهْڒَاشْ ن ڒْبَارْصْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","مَاشَا مَاڒَا إِبدّڒْ ويْسُومْ إِدَّارنْ ؤُ إِذْوڒْ ذ أَشمْڒَاڒْ، إِتّْخصَّا أَسْ أَذْ د-يَاسْ غَارْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","مَاڒَا إِژْرَا إِ-ث ؤُكهَّانْ ؤُشَا أَقَا أَمْشَانْ ن ؤُضُونْ إِذْوڒْ ذ أَشمْڒَاڒْ، أَذْ إِبَارّحْ ؤُكهَّانْ ونِّي ذِي إِدْجَا ڒهْڒَاشْ ذ أَمزْذَاڭْ. نتَّا أَقَا إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","مَاڒَا ذِينْ خْ ثڒْمشْثْ ن ويْسُومْ إِشْثْ ن ثْحبُّوشْثْ ؤُ ثتّْوَاسّْڭنْفَا ثَانِيثَا، ");
INSERT INTO rifa_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","مَاشَا ذڭْ ومْشَانْ ن ثْحبُّوشْثْ إِذْوڒْ ذ إِجّْ ن ؤُعبُّوزْ إِمْڒڒْ نِيغْ ذ إِجّْ ن ونْڭَازْ إِشّمْڒڒْ، أَشمْڒَاڒْ إِرُوحْ غَارْ ثزْوغْ، خنِّي أَذْ إِژَارْ ؤُكهَّانْ مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","خْمِي غَارسْ إِ غَا إِخْزَارْ ؤُكهَّانْ ؤُشَا إِژْرَا أَقَا-ث سَاذُو ثڒْمشْثْ ؤُشَا إِژطَّانْ نّسْ ذ إِشمْڒَاڒنْ، خنِّي أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ، أَقَا-ث ذ ؤُضُونْ ن ڒْبَارْصْ ونِّي يُويُورنْ س ثْحبُّوشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","مَاشَا مَاڒَا إِژْرَا إِ-ث ؤُكهَّانْ ؤُشَا وَارْ ذَايسْ يُوفِي ؤُڒَا ذ إِجّْ ن ؤُژطُّو ذ أَشمْڒَاڒْ ؤُشَا وَارْ إِذْوِيڒْ يُودْجغْ خْ ثڒْمشْثْ، مَاشَا إِذْوڒْ يَارْسَا، خنِّي أَذْ خَاسْ إِبلّعْ ؤُكهَّانْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","مَاڒَا ثُويُورْ خْ ثڒْمشْثْ مَارَّا، خنِّي أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. أَقَا-ث ذ ؤُضُونْ ن ڒْبَارْصْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","مَاشَا مَاڒَا أَنْڭَازْ إِشّمْڒڒْ ن ثڒْمشْثْ إِقِّيمْ ذڭْ ومْشَانْ نّسْ، وَارْ إِمْغِيرْ شَا، أَقَا-ث ذ شَّامثْ ن ثْحبُّوشْثْ ؤُشَا أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمزْذَاڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","نِيغْ مَاڒَا إِذْوڒْ ذِي ثڒْمشْثْ ن أَرِّيمثْ إِجّْ ن ؤُيزِّيمْ ن وشْمَاضْ ؤُشَا أَيْسُومْ إِدَّارنْ ن ؤُيزِّيمْ ن وشْمَاضْ إِذْوڒْ ذ إِجّْ ن ونْڭَازْ إِشّمْڒڒْ، أَشمْڒَاڒْ إِرُوحْ غَارْ ثزْوغْ نِيغْ ذ أَشمْڒَاڒْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ؤُشَا إِژْرَا ؤُكهَّانْ مَانْ أَيَا، ؤُشَا خْزَارْ، إِژطَّانْ إِ إِدْجَانْ ذڭْ ونْڭَازْ إِشّمْڒڒْ أَقَا ذوْڒنْ ذ إِشمْڒَاڒنْ، ؤُشَا إِبَانْ أَقَا أَمْشَانْ ن ونْڭَازْ يُودْجغْ ذِي ثڒْمشْثْ، أَقَا-ث ذ ڒْبَارْصْ نِّي د-إِفّْغنْ زڭْ ؤُيزِّيمْ ن وشْمَاضْ. أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. أَقَا-ث ذ ؤُضُونْ ن ڒْبَارْصْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","مَاشَا مَاڒَا أَكهَّانْ إِژْرَا مَانْ أَيَا ؤُشَا وَارْ إِتّْوِيڒِي إِژطَّانْ إِشمْڒَاڒنْ ذڭْ ونْڭَازْ إِشّمْڒڒْ ؤُشَا إِژْرَا أَنْڭَازْ وَارْ يُودْجِيغْ خْ ثڒْمشْثْ ؤُشَا يَارْسَا، خنِّي أَذْ خَاسْ إِبلّعْ ؤُكهَّانْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ث إِژَارْ ؤُكهَّانْ ؤُشَا مَاڒَا إِمْغَارْ ونْڭَازْ كْثَارْ خْ ثڒْمشْثْ، أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. أَقَا-ث ذ ؤُضُونْ ن ڒْبَارْصْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","مَاشَا مَاڒَا أَنْڭَازْ إِشّمْڒڒْ إِقِّيمْ ذڭْ ومْشَانْ نّسْ، وَارْ إِمْغِيرْ خْ ثڒْمشْثْ ؤُشَا يَارْسَا، أَقَا-ث ذ أَعبُّوزْ ن وشْمَاضْ. أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمزْذَاڭْ، مِينْزِي أَقَا-ت ذ شَّامثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","مَاڒَا إِجّْ ن ورْيَازْ نِيغْ إِشْثْ ن ثمْغَارْثْ ذَايسْ ؤُضُونْ ذڭْ ؤُزدْجِيفْ نِيغْ ذِي ثْمَارْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ؤُشَا إِخْزَارْ ؤُكهَّانْ غَارْ ؤُضُونْ، ؤُ خْزَارْ، أَقَا إِتّْبَانْ يُودْجغْ ذِي ثڒْمشْثْ ؤُشَا ذَايسْ إِژطَّانْ إِوَارْغنْ ذ إِزْذَاذنْ، خنِّي أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ. أَقَا-ت ذ ثْفُورِي ن يِيڒمْ، أَقَا-ث ذ ڒْبَارْصْ ن ؤُزدْجِيفْ نِيغْ ن ثْمَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","مَاشَا مَاڒَا إِژْرَا ؤُكهَّانْ ؤُضُونْ ن ثْفُورِي ن يِيڒمْ، إِژْرَا أَقَا وَارْ يُودْجِيغْ ذِي ثڒْمشْثْ ؤُشَا وَارْ ذَايسْ إِژطَّانْ إِبَارْشَاننْ، خنِّي أَذْ خَاسْ إِبلّعْ ؤُكهَّانْ خْ ونِّي ذِي إِدْجَا وُوضُونْ ن ثْفُورِي ن يِيڒمْ إِ يِيجّْ ن ڒْمِيجَاڒْ ن سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","أَذْ إِژَارْ ؤُكهَّانْ ؤُضُونْ ذڭْ وَاسّْ وِيسّْ سبْعَا ؤُشَا مَاڒَا إِژْرَا، أَقَا ثْفُورِي ن يِيڒمْ وَارْ ثمْغِيرْ، وَارْ ذَايسْ يُوفِي إِژطَّانْ إِوَارْغنْ ؤُشَا ثْفُورِي ن يِيڒمْ وَارْ ثُودْجِيغْ خْ ثڒْمشْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","خنِّي نتَّا أَذْ إِحفّْ إِ يِيخفْ نّسْ، مَاشَا أَمْشَانْ ن ثْفُورِي ن يِيڒمْ وَارْ ث إِتّْحفِّي شَا ؤُشَا أَكهَّانْ أَذْ إِبلّعْ خْ ونِّي ذِي إِدْجَا ثْفُورِي ن يِيڒمْ عَاذْ إِشْثْ ن ثْوَاڒَا نّغْنِي إِ يِيجّْ ن ڒْمِيجَاڒْ ن سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ إِژَارْ ؤُكهَّانْ أَمْشَانْ ن ثْفُورِي ن يِيڒمْ. مَاڒَا إِژْرَا أَقَا ثْفُورِي ن يِيڒمْ وَارْ ثمْغِيرْ شَا، وَارْ ثُودْجِيغْ خْ ثڒْمشْثْ، خنِّي أَكهَّانْ أَذْ ث إِبَارّهْ ذ أَمزْذَاڭْ. أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ ؤُشَا أَذْ يِيڒِي إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","مَاشَا مَاڒَا ثْفُورِي ن يِيڒمْ ثمْغَارْ أَطَّاسْ خْ ثڒْمشْثْ أَوَارْنِي إِ ؤُسِيزْذڭْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ؤُشَا إِژْرَا إِ-ث ؤُكهَّانْ ؤُشَا إِژْرَا ثْفُورِي ن يِيڒمْ ثمْغَارْ خْ ثڒْمشْثْ، خنِّي وَارْ يَارزُّو ؤُكهَّانْ خْ إِژطَّانْ إِوَارْغنْ عَاذْ، نتَّا أَقَا إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","مَاشَا مَاڒَا ثْفُورِي ن يِيڒمْ أَقَا ثْبَانْ-د ثْبدّْ ذِي ثِيطَّاوِينْ نّسْ، ؤُشَا فّْغنْ-د زَّايسْ إِژطَّانْ إِبَارْشَاننْ، خنِّي أَقَا ثڭّنْفَا ثْفُورِي ن يِيڒمْ ؤُشَا نتَّا أَقَا إِزْذڭْ. أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمزْذَاڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","مَاڒَا بَاننْ-د إِمُوشَانْ شّمْڒڒنْ، إِشّمْڒڒنْ ذ إِشمْڒَاڒنْ، ذِي ثڒْمشْثْ ن إِجّْ ن ورْيَازْ نِيغْ ن إِشْثْ ن ثمْغَارْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ؤُشَا إِژْرَا ؤُكهَّانْ مَانْ أَيَا ؤُشَا إِژْرَا أَقَا ذِي ثڒْمشْثْ ن أَرِّيمثْ بَاننْ-د إِمُوشَانْ أَرْسَانْ، إِشمْڒَاڒنْ، خنِّي أَقَا-ت ذ إِشْثْ ن ثْفُورِي ن ثڒْمشْثْ، نتَّا أَقَا إِزْذڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","مَاڒَا إِوْضَا ؤُشُوَّافْ ن ؤُزدْجِيفْ ن إِجّْ ن ورْيَازْ، أَقَا ذ أَقشَّارْ، خنِّي نتَّا أَقَا إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","مَاڒَا ثَانْيَارْثْ ن شَا ن يِيجّْ أَذْ ثذْوڒْ ثَاڒقَّاغْثْ، أَقَا ثَانْيَارْثْ نّسْ ثْقشَّارْ وَاهَا، نتَّا أَقَا إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","مَاشَا مَاڒَا ذِينْ إِجّْ ن ؤُضُونْ إِمْڒڒْ إِرُوحْ غَارْ ثزْوغْ خْ ؤُزدْجِيفْ أَقشَّارْ نِيغْ خْ ثنْيَارْثْ ثَاقشَّارْثْ، أَقَا-ث ذ ڒْبَارْصْ نِّي د-إِفّْغنْ خْ ؤُزدْجِيفْ نّسْ أَقشَّارْ نِيغْ خْ ثنْيَارْثْ نّسْ ثَاقشَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","مَاڒَا إِژْرَا إِ-ث ؤُكهَّانْ ؤُشَا إِژْرَا أَقَا أَعبُّوزْ ن وُوضُونْ إِمْڒڒْ، إِرُوحْ غَارْ ثزْوغْ خْ ؤُزدْجِيفْ نّسْ أَقشَّارْ نِيغْ خْ ثنْيَارْثْ نّسْ ثَاقشَّارْثْ، إِبَانْ-د أَمْ ڒْبَارْصْ ن ثڒْمشْثْ ن أَرِّيمثْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","خنِّي أَقَا أَرْيَازْ ذ بُو-ڒْْبَارْصْ إِ إِدْجَا، نتَّا أَقَا إِخْمجْ. أَكهَّانْ أَذْ ث إِبَارّحْ ذ أَمخْمُوجْ، ؤُضُونْ أَقَا-ث خْ ؤُزدْجِيفْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","”إِتّْخصَّا أَذْ إِتّْوَاشَارّڭْ وَارُّوضْ ن بُو-ڒْْبَارْصْ إِ ذِي إِدْجَا وُوضُونْ ؤُشَا أَذْ إِضْڒقْ إِ ؤُشُوَّافْ خْ ؤُزدْجِيفْ نّسْ، أَذْ إِڒحّفْ أَشْڒَاغمْ غَارْ ؤُينْشِيشْ، أَذْ إِڒَاغَا: ’أَمخْمُوجْ! أَمخْمُوجْ!‘ ");
INSERT INTO rifa_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","مَارَّا ؤُسَّانْ إِ ذَايسْ إِ غَا يِيڒِي وُوضُونْ، أَذْ يِيڒِي إِخْمجْ. نتَّا ذ أَمخْمُوجْ. نتَّا أَذْ إِزْذغْ وحّْذسْ ؤُشَا ثْزذِّيغْثْ نّسْ أَذْ ثِيڒِي بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","”مَاڒَا ؤُضُونْ ن ڒْْبَارْصْ ذڭْ إِجّْ ن وَارُّوضْ، ذڭْ إِجّْ ن وَارُّوضْ ن ثَاضُوفْثْ نِيغْ ذڭْ إِجّْ ن وَارُّوضْ ن ڒقْطنْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","نِيغْ ذڭْ وشْضَاضْ إِخيّْضنْ نِيغْ ذڭْ ؤُفِيڒُو إِمُّوذنْ، نِيغْ ن ڒقْطنْ نِيغْ ن ثَاضُوفْثْ، نِيغْ غَارْ يِيڒمْ، نِيغْ غَارْ مَامّشْ مَا ڒْقشْعثْ ن يِيڒمْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ؤُ ثِيشْثِي إِتّْوَاوْثنْ ذڭْ وَارُّوضْ نِيغْ ذڭْ يِيڒمْ، نِيغْ غَارْ وشْضَاضْ إِخيّْضنْ نِيغْ غَارْ ؤُفِيڒُو إِمُّوذنْ، نِيغْ ذِي مَامّشْ مَا ن ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ، ثزِّيزُو نِيغْ ثزْوغْ، أَقَا-ث ذ ؤُضُونْ ن ڒْبَارْصْ. أَذْ إِتّْوَاسّْشنْ أَيَا إِ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","أَكهَّانْ أَذْ إِخْزَارْ غَارْ ومْشَانْ ن ؤُضُونْ ؤُشَا مِينْ إِضْننْ أَذْ ث إِبلّعْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ إِخْزَارْ غَارْ وُوضُونْ. مَاڒَا إِمْغَارْ ؤُضُونْ ذڭْ وَارُّوضْ، نِيغْ غَارْ وشْضَاضْ إِخيّْضنْ نِيغْ غَارْ ؤُفِيڒُو إِمُّوذنْ، نِيغْ ذڭْ يِيڒمْ ن مَامّشْ مَا ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ، أَقَا ؤُضُونْ ذ ڒْبَارْسْ إِقسْحنْ إِ يدْجَا، أَقَا إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","أَذْ إِسّشْمضْ أَرُّوضْ نِيغْ أَفِيڒُو ذ أَزِيرَارْ نِيغْ أَفِيڒُو إِمُّوذنْ، نِيغْ ن ثَاضُوفْثْ نِيغْ ن ڒقْطنْ إِ إِدْجَا، نِيغْ مَامّشْ مَا ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ إِ ذَايسْ ثُوغَا ؤُضُونْ، مِينْزِي أَقَا-ث ذ ڒْبَارْصْ إِقسْحنْ. إِتّْخصَّا أَذْ إِتّْوَاسّشْمضْ س ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","مَاشَا مَاڒَا إِژْرَا ؤُكهَّانْ مَانْ أَيَا ؤُشَا أَقَا ؤُضُونْ وَارْ إِمْغِيرْ شَا ذڭْ وَارُّوضْ، نِيغْ ذڭْ وشْضَاضْ إِخيّْضنْ نِيغْ ذڭْ ؤُفِيڒُو إِمُّوذنْ، نِيغْ ذِي مَامّشْ مَا ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ، ");
INSERT INTO rifa_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","خنِّي أَذْ يُومُورْ ؤُكهَّانْ مَاحنْذْ أَذْ سِّيرْذنْ مِينْ ذِي يدْجَا وُوضُونْ، ؤُشَا أَوَارْنِي إِ مَانْ أَيَا أَذْ خَاسْ إِبلّعْ ثْوَاڒَا نّغْنِي ڒْقدّْ ن سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","مَاڒَا إِژْرَا ؤُكهَّانْ ؤُضُونْ أَوَارْنِي إِ ؤُسِيرْذْ، ؤُشَا إِژْرَا ؤُضُونْ وَارْ إِبذِّيڒْ شَا ؤُشَا ؤُضُونْ وَارْ إِمْغِيرْ، أَقَا أَرُّوضْ نِّي إِخْمجْ. إِتّْخصَّا أَذْ ث ثسّشْمضذْ س ثْمسِّي. أَقَا ؤُضُونْ إِذْوڒْ يُودْجغْ إِتّتّْ غَارْ ضفَّارْ نِيغْ غَارْ زَّاثْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","مَاشَا مَاڒَا إِژْرَا ؤُكهَّانْ مَانْ أَيَا ؤُشَا إِژْرَا بلِّي ؤُضُونْ يَارْسَا أَوَارْنِي إِ ؤُسِيرْذْ، خنِّي أَذْ ث إِقسّْ زڭْ وَارُّوضْ، نِيغْ زڭْ يِيڒمْ، نِيغْ زڭْ وشْضَاضْ إِخيّْضنْ نِيغْ زڭْ ؤُفِيڒُو إِمُّوذنْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","مَاشَا مَاڒَا إِبَانْ وُوضُونْ ثْوَاڒَا نّغْنِي ذڭْ وَارُّوضْ، نِيغْ غَارْ وشْضَاضْ إِخيّْضنْ نِيغْ غَارْ ؤُفِيڒُو إِمُّوذنْ، نِيغْ ذِي مَامّشْ مَا ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ، أَقَا إِدُّوقّزْ ڒْبَارْصْ. إِتّْخصَّا أَذْ ثسّشْمضْ س ثْمسِّي مِينْ ذَايسْ إِ إِدْجَانْ ؤُضُونْ. ");
INSERT INTO rifa_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","أَرُّوضْ، نِيغْ أَفِيڒُو ذ أَزِيرَارْ نِيغْ أَفِيڒُو إِمُّوذنْ نِيغْ مَامّشْ مَا ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ، ونِّي ثسِّيرْذذْ ؤُشَا إِرُوحْ خَاسْ وُوضُونْ، أَذْ ث ثسِّيرْذذْ ثْوَاڒَا نّغْنِي ؤُشَا خنِّي أَذْ يِيڒِي إِزْذِيڭْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","وَا ذ أَزرْفْ ن وُوضُونْ ن ڒْبَارْصْ ن وَارُّوضْ ن ثَاضُوفْثْ نِيغْ ن ڒقْطنْ، نِيغْ ن وشْضَاضْ إِخيّْضنْ نِيغْ ن ؤُفِيڒُو إِمُّوذنْ، نِيغْ ن مَامّشْ مَا ڒْقشْعثْ نِّي تّڭّنْ س يِيڒمْ، مَاحنْذْ خنِّي أَذْ بَارّْحنْ س ثزْذڭْ نّسْ نِيغْ س ڒخْمجْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","”وَا ذ أَزرْفْ ن بُو-ڒْْبَارْصْ إِ وَاسّْ ن ؤُسِيزْذڭْ نّسْ. إِتّْخصَّا أَذْ ث نذْهنْ غَارْ ؤُكهَّانْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ؤُشَا أَذْ إِفّغْ ؤُكهَّانْ غَارْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ. خْمِي غَارسْ إِ غَا إِخْزَارْ ؤُكهَّانْ ؤُشَا إِژْرَا أَقَا إِڭّنْفَا وُوضُونْ ن ڒْبَارْصْ ن بُو-ڒْبَارْصْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","أَذْ يُومُورْ ؤُكهَّانْ، مَاحنْذْ أَذْ كْسِينْ إِ ونِّي إِ غَا إِتّْوَاسِّيزذْڭنْ ثْنَاينْ ن إِجْضَاضْ إِدَّارنْ إِزْذِيڭنْ، ؤُڒَا ذ أَكشُّوضْ ن ثْشجَّارْثْ ن ثنْڭلْثْ، ذ ؤُزڭّْوَاغْ إِحذْقنْ، ذ ثْعلْدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","أَذْ يُومُورْ ؤُكهَّانْ مَاحنْذْ أَذْ غَارْصنْ إِ يِيجّْ ن وجْضِيضْ ذڭْ إِشْثْ ن ڒْقشْعثْ ن ثْڒَاخْثْ، سنّجْ إِ وَامَانْ إِتَّازّْڒنْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","خنِّي أَذْ إِكْسِي أَجْضِيضْ إِدَّارنْ ذ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ثنْڭلْثْ ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ثْعلْدْجثْ ؤُشَا أَذْ ثنْ إِسُّوفْ أَكْ-ذ وجْضِيضْ إِدَّارنْ ذڭْ إِذَامّنْ ن وجْضِيضْ إِ إِتّْوَاغَارْصنْ سنّجْ إِ وَامَانْ إِتَّازّْڒنْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","أَذْ إِرُوشّْ سبْعَا ن ثْوَاڒَاوِينْ خْ ونِّي إِتّْوَاسِّيزذْڭنْ زِي ڒْبَارْصْ. خنِّي أَذْ ث إِبَارّحْ ذ أَمزْذَاڭْ ؤُشَا أَذْ يَارْخُو إِ وجْضِيضْ إِدَّارنْ مَاحنْذْ أَذْ إِضوْ سنّجْ إِ وُوذمْ ن ييَّارْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ؤُشَا ونِّي إِتّْوَاسِّيزذْڭنْ أَذْ إِصبّنْ أَرُّوضْ نّسْ ؤُشَا أَذْ إِحفّْ مَارَّا أَشُوَّافْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ. خنِّي أَذْ يِيڒِي إِزْذڭْ. أَوَارْنِي أَسْ أَذْ يَاذفْ غَارْ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُشَا أَذْ إِزْذغْ بَارَّا إِ ؤُقِيضُونْ نّسْ عَاذْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ إِحفّْ مَارَّا أَشُوَّافْ ن ؤُزدْجِيفْ نّسْ ذ ثْمَارْثْ نّسْ ذ ثمِّيوِينْ ن ثِيطَّاوِينْ نّسْ، وَاهْ، أَذْ إِحفّْ مَارَّا أَشُوَّافْ نّسْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ ؤُشَا أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ، خنِّي أَذْ يِيڒِي إِزْذڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ إِكْسِي ثْنَاينْ ن إِزْمَارنْ كمّْڒنْ ذ إِشْثنْ ثخْسِي إِشْنَانْ قَاعْ ن إِجّنْ ؤُسڭّْوَاسْ أَكْ-ذ ثْڒَاثَا زِيعشْرَا ن إِجّنْ إِفَا ن وَارنْ أَزْذَاذْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ إِخدْجْضنْ س زّشْثْ، ؤُ عَاوذْ إِجّنْ ؤُلُوخْ ن زّشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","أَكهَّانْ، ونِّي ث إِسِّيزذْڭنْ، أَذْ يَارّْ أَرْيَازْ نِّي إِتّْخصَّا أَذْ إِتّْوَاسِّيزْذڭْ، أَكْ-ذ مَارَّا أَيَا زَّاثْ إِ وُوذمْ ن سِيذِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","أَذْ إِكْسِي ؤُكهَّانْ إِزْمَارْ نِّي ؤُشَا أَذْ ث-إِ-د-إِسّْقَارّبْ أَمْ ثْغَارْصْثْ ن ؤُمَارْوَاسْ أَكْ-ذ ؤُلُوخْ ن زّشْثْ، ؤُشَا أَذْ ث إِسّنْهزّْ أَمْ ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","خنِّي أَذْ إِغَارْصْ إِ يزْمَارْ نِّي ذڭْ ومْشَانْ مَانِي غَارّْصنْ ثَاغَارْصْثْ ن دّنْبْ ذ ثْغَارْصْثْ ن وشْمَاضْ، ذڭْ ومْشَانْ أَمْقدَّاسْ. مِينْزِي ثَاغَارْصْثْ ن ؤُمَارْوَاسْ، أَمْ ثْغَارْصْثْ ن دّنْبْ، إِ ؤُكهَّانْ إِ ثدْجَا، أَقَا-ت ذ ثَامْقدَّاسْثْ قَاعْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","أَذْ إِكْسِي ؤُكهَّانْ شْوَايْثْ زڭْ إِذَامّنْ ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ ؤُشَا أَكهَّانْ أَذْ ثنْ إِڭّْ خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن ونِّي إِ غَا إِتّْوَاسِّيزذْڭنْ ؤُڒَا خْ يِيمزْ ن ؤُفُوسْ نّسْ أَفُوسِي ؤُ خْ يِيمزْ ن ؤُضَارْ نّسْ أَفُوسِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","أَمنِّي إِ غَا إِكْسِي ؤُكهَّانْ شَا زڭْ ؤُلُوخْ ن زّشْثْ ؤُشَا أَذْ ت إِنْغڒْ خْ ثْڒقَّا ن ؤُفُوسْ نّسْ أَزڒْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","أَذْ إِسُّوفْ ؤُكهَّانْ أَضَاضْ نّسْ أَفُوسِي س زّشْثْ نِّي غَارسْ ذڭْ ؤُفُوسْ نّسْ أَزڒْمَاضْ ؤُشَا أَمُّو إِ غَا إِرُوشّْ س ؤُضَاضْ نّسْ شْوَايْثْ زِي زّشْثْ سبْعَا ن ثْوَاڒَاوِينْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ؤُشَا مِينْ إِقِّيمنْ زِي زّشْثْ نِّي غَارسْ ذڭْ ؤُفُوسْ نّسْ، أَذْ ت إِڭّْ ؤُكهَّانْ خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن ونِّي إِ غَا إِتّْوَاسِّيزذْڭنْ، ؤُڒَا خْ يِيمزْ ن ؤُفُوسْ نّسْ أَفُوسِي ؤُ خْ يِيمزْ ن ؤُضَارْ نّسْ أَفُوسِي، ثِيوَا ن إِذَامّنْ ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ إِ خَاسنْ إِڭَّا قْبڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","مِينْ إِقِّيمنْ ن زّشْثْ نِّي إِدْجَانْ غَارْ ؤُكهَّانْ ذِي ثْڒقَّا ن ؤُفُوسْ نّسْ، أَذْ ث إِنْغڒْ خْ ؤُزدْجِيفْ ن ونِّي إِ غَا إِتّْوَاسِّيزذْڭنْ ؤُشَا أَمُّو إِ ث غَا إِسّصْڒحْ ؤُكهَّانْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","أَذْ إِسّوْجذْ ؤُكهَّانْ خنِّي ثَاغَارْصْثْ ن دّنْبْ ؤُشَا أَذْ إِسّصْڒحْ ونِّي إِتّْوَاسِّيزذْڭنْ زِي ڒخْمجْ نّسْ. أَوَارْنِي أَسْ أَذْ إِغَارْصْ إِ ثْغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","أَذْ إِسّْبخَّارْ ؤُكهَّانْ ثَاغَارْصْثْ ن وشْمَاضْ ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ خْ ؤُعَالْطَارْ. أَمُّو إِ ث غَا إِسّصْڒحْ ؤُكهَّانْ ؤُشَا أَذْ يِيڒِي إِزْذڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","مَاڒَا نتَّا إِژْڒضْ ؤُشَا أَفُوسْ نّسْ وَارْ ث إِسِّيوضْ، خنِّي أَذْ إِكْسِي إِجّْ ن يِيزْمَارْ أَمْ ثْغَارْصْثْ ن ؤُمَارْوَاسْ مَاحنْذْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ أَمْ إِڭَّا إِزْمَارْ ذ ثوْهِيبْثْ ن ونْهزِّي. أَذْ إِكْسِي ڒَا ذ إِشْثْ ن ثعْشَارْثْ ن إِجّْ ن إِفَا ن وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ، ؤُڒَا ذ إِجّْ ن ؤُلُوخْ ن زّشْثْ ");
INSERT INTO rifa_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ذ ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ ثْنَاينْ ن إِذْبِيرنْ إِمژْيَانِينْ، أَنشْثْ إِزمَّارْ ؤُفُوسْ نّسْ أَذْ إِسِّيوضْ. إِشْثْ أَذْ ثِيڒِي ذ ثَاغَارْصْثْ ن دّنْبْ ؤُ ثنّغْنِي أَذْ ثِيڒِي ذ ثَاغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ ثنْ يَاوِي ذِي طّْوعْ ن ؤُسِيزْذڭْ نّسْ غَارْ ؤُكهَّانْ، غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","أَذْ إِكْسِي ؤُكهَّانْ إِزْمَارْ ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ ذ ؤُلُوخْ نِّي ن زّشْثْ ؤُشَا أَكهَّانْ أَذْ ثنْ إِسّنْهزّْ أَمْ ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","خنِّي أَذْ إِغَارْصْ إِ إِزْمَارْ ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ ؤُشَا أَكهَّانْ أَذْ إِكْسِي شْوَايْثْ زڭْ إِذَامّنْ ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ، أَذْ ثنْ يَارّْ خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن ونِّي إِتّْوَاسِّيزذْڭنْ ؤُڒَا خْ يِيمزْ ن ؤُفُوسْ نّسْ أَفُوسِي ؤُ خْ يِيمزْ ن ؤُضَارْ نّسْ أَفُوسِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","أَذْ إِفَارّغْ ؤُكهَّانْ شَا ن زّشْثْ خْ ثْڒقَّا ن ؤُفُوسْ أَژڒْمَاضْ ن يِيخفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","س ؤُضَاضْ نّسْ أَفُوسِي أَذْ إِرُوشّْ ؤُكهَّانْ س زّشْثْ نِّي غَارسْ ذڭْ ؤُفُوسْ نّسْ أَژڒْمَاضْ سبْعَا ن ثْوَاڒَاوِينْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","أَكهَّانْ أَذْ إِڭّْ شْوَايْثْ زِي زّشْثْ نِّي غَارسْ إِدْجَانْ ذڭْ ؤُفُوسْ نّسْ خْ إِغسْ ن ؤُمزُّوغْ أَفُوسِي ن ونِّي إِتّْوَاسِّيزذْڭنْ ؤُڒَا خْ يِيمزْ ن ؤُفُوسْ نّسْ أَفُوسِي ؤُ خْ يِيمزْ ن ؤُضَارْ نّسْ أَفُوسِي، ذڭْ ومْشَانْ نِّيثْ مَانِي تّْوَاڭّنْ إِذَامّنْ ن ثْغَارْصْطْ ن ؤُمَارْوَاسْ قْبڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","مِينْ إِقِّيمنْ زِي زّشْثْ نِّي غَارْ ؤُكهَّانْ ذڭْ ؤُفُوسْ نّسْ، أَذْ ث إِڭّْ خْ ؤُزدْجِيفْ ن ونِّي إِتّْوَاسِّيزذْڭنْ، مَاحنْذْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","خنِّي أَذْ إِسّوْجذْ إِجّْ زِي ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ زڭْ إِذْبِيرنْ إِمژْيَاننْ، أَنشْثْ ؤُمِي إِزمَّارْ ؤُفُوسْ نّسْ أَذْ إِسِّيوضْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","زِي مِينْ ذ أَسْ غَا إِسِّيوضْ ؤُفُوسْ نّسْ، أَذْ يِيڒِي إِجّْ إِ ثْغَارْصْثْ ن دّنْبْ ؤُ ونّغْنِي إِ ثْغَارْصْثْ ن وشْمَاضْ، سنّجْ إِ ثوْهِيبْثْ ن ڒْغِيدْجثْ. أَكهَّانْ أَذْ إِڭّْ أَصْڒَاحْ خْ ونِّي إِتّْوَاسِّيزذْڭنْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","وَا ذ أَزرْفْ إِ ونِّي ذِي إِدْجَا وُوضُونْ ن ڒْبَارْصْ ؤُشَا أَفُوسْ نّسْ وَارْ إِزمَّارْ أَذْ إِسِّيوضْ إِ ؤُسِيزْذڭْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","”خْمِي غَا ثَاذْفمْ غَارْ ثمُّورْثْ ن كنْعَانْ، ثنِّي ذ أَومْ غَا وْشغْ ذ أَڭْڒَا، ؤُشَا مَاڒَا ڭِّيغْ نشّْ ؤُضُونْ ن ڒْبَارْصْ خْ شَا ن ثَادَّارْثْ ن ثمُّورْثْ نِّي غَارْومْ ذ أَڭْڒَا، ");
INSERT INTO rifa_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","أَذْ د-يَاسْ خنِّي ونِّي غَارْ ثدْجَا ثَادَّارْثْ نِّي، أَذْ إِخبَّارْ أَكهَّانْ، أَذْ يِينِي: ’إِتّْغِيڒْ أَيِي-د أَخْمِي ذِينْ شَا ن وُوضُونْ ذِي ثَادَّارْثْ.‘ ");
INSERT INTO rifa_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","خنِّي أَكهَّانْ أَذْ إِسّكّْ، مَاحنْذْ أَذْ سّخْوَانْ ثَادَّارْثْ قْبڒْ إِ د غَا يَاسْ ؤُكهَّانْ س يِيخفْ نّسْ، حِيمَا أَذْ إِخمّْ ؤُضُونْ، حِيمَا وَارْ إِتّْوَاسّخْمِيجْ مَارَّا مِينْ إِدْجَانْ ذِي ثَادَّارْثْ. أَوَارْنِي أَسْ أَذْ د-يَاسْ ؤُكهَّانْ، مَاحنْذْ أَذْ إِخمّمْ ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","مَاڒَا إِخْزَارْ غَارْ ؤُضُونْ ؤُشَا إِژْرَا أَقَا ؤُضُونْ ن ڒحْيُوضْ ن ثَادَّارْثْ بَاننْ-د ذَايسْ إِحُوفَارْ زِّيزْونْ نِيغْ زوْغنْ، ؤُدْجْغنْ خْ وُوذمْ ن ڒْحِيضْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","خنِّي أَذْ إِفّغْ ؤُكهَّانْ زِي ثَادَّارْثْ نِّي زِي وَاذَافْ ن ثَادَّارْثْ ؤُشَا أَذْ إِقّنْ ثَادَّارْثْ سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ د-إِذْوڒْ ؤُكهَّانْ ؤُشَا مَاڒَا إِژْرَا أَقَا ؤُضُونْ إِبزّعْ خْ ڒحْيُوضْ ن ثَادَّارْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","خنِّي أَذْ إِوصَّا ؤُكهَّانْ، مَاحنْذْ أَذْ كّْسنْ إِژْرَا مَانِي إِڒْسقْ وُوضُونْ ؤُ أَذْ ثنْ نْضَارنْ ذڭْ إِجّْ ن ومْشَانْ إِخمْجنْ بَارَّا إِ ثنْذِينْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","أَذْ يجّْ أَذْ قشَّارنْ ذَاخڒْ ن ثَادَّارْثْ غَارْ مَارَّا إِغزْذِيسنْ نّسْ، ؤُشَا أَذْ زدْجْعنْ أَبدْجَاعْ إِ قشَّارنْ بَارَّا إِ ثنْذِينْثْ ذڭْ إِجّْ ن ومْشَانْ ذ أَمخْمُوجْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","خنِّي أَذْ كْسِينْ إِژْرَا نّغْنِي، أَذْ ثنْ ڭّنْ ذڭْ ومْشَانْ ن إِژْرَا نِّي إِهڒْشنْ ؤُشَا أَذْ كْسِينْ أَبدْجَاعْ نّغْنِي مَاحنْذْ أَذْ زَّايسْ حنّْشنْ ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","مَاڒَا ؤُضُونْ إِذْوڒْ-د ؤُشَا إِسّْفُوفِّي عَاوذْ ذِي ثَادَّارْثْ أَوَارْنِي ڒَامِي كّْسنْ إِژْرَا ؤُ قشَّارنْ ثَادَّارْثْ أَوَارْنِي ڒَامِي ت حنّْشنْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","خنِّي أَذْ د-يَاسْ ؤُكهَّانْ أَذْ ت إِقدْجبْ. مَاڒَا إِژْرَا، أَقَا ؤُضُونْ إِبزّعْ ذِي ثَادَّارْثْ، خنِّي أَقَا ذِينْ إِجّْ ن ڒْبَارْصْ إِقسْحنْ ذِي ثَادَّارْثْ. أَقَا-ت ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","أَذْ هذْمنْ ثَادَّارْثْ، إِژْرَا نّسْ ذ ثْحنْيَا نّسْ ذ مَارَّا ثَارِّيسْثْ ن ثَادَّارْثْ ؤُشَا أَذْ سِّيڭّْوجنْ أَيَا بَارَّا إِ ثنْذِينْثْ غَارْ إِجّْ ن ومْشَانْ ذ أَمخْمُوجْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","وِي غَا يَاذْفنْ غَارْ ثَادَّارْثْ ذڭْ إِجّْ ن وَاسّْ زڭْ وُوسَّانْ أَوَارْنِي ڒَامِي بلّْعنْ ثَادَّارْثْ، نتَّا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","وِي غَا إِطّْصنْ ذِي ثَادَّارْثْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ ؤُ وِي غَا إِشّنْ ذِي ثَادَّارْثْ، أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","مَاڒَا يُوذفْ ؤُكهَّانْ، مَاحنْذْ أَذْ ت إِقدْجبْ ؤُشَا إِژْرَا أَقَا ؤُضُونْ وَارْ إِمْغِيرْ ذِي ثَادَّارْثْ، أَوَارْنِي ڒَامِي حنّْشنْ ثَادَّارْثْ، خنِّي أَذْ إِبَارّحْ ؤُكهَّانْ بلِّي ثَادَّارْثْ ثزْذڭْ، مِينْزِي ؤُضُونْ إِتّْوَاسّْڭنْفَا. ");
INSERT INTO rifa_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","أَذْ إِكْسِي ثْنَاينْ ن إِجْضَاضْ ذ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ثنْڭلْثْ ذ ؤُزڭّْوَاغْ إِحذْقنْ ذ ثْعلْدْجثْ، مَاحنْذْ أَذْ زَّايْسنْ إِكّسْ دّنْبْ خْ ثَادَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","أَذْ إِغَارْصْ إِ يِيجّْ ن وجْضِيضْ ذڭْ إِشْثْ ن ڒْقشْعثْ ن ثْڒَاخْثْ، سنّجْ إِ وَامَانْ إِدَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","أَذْ إِكْسِي أَكشُّوضْ ن ثْشجَّارْثْ ن ثنْڭلْثْ ذ ثْعلْدْجثْ ذ ؤُزڭّْوَاغْ إِحذْقنْ ؤُڒَا ذ أَجْضِيضْ إِدَّارنْ ؤُشَا أَذْ إِسُّوفْ مَارَّا أَيَا ذڭْ إِذَامّنْ ن وجْضِيضْ إِتّْوَاغَارْصنْ ؤُ ذڭْ وَامَانْ إِدَّارنْ ؤُشَا أَذْ إِرُوشّْ ثَادَّارْثْ سبْعَا ن ثْوَاڒَاوِينْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","أَمُّو إِ غَا إِكّسْ دّنْبْ خْ ثَادَّارْثْ س إِذَامّنْ ن وجْضِيضْ، س وَامَانْ إِدَّارنْ ذ وجْضِيضْ إِدَّارنْ ذ ؤُكشُّوضْ ن ثْشجَّارْثْ ن ثنْڭلْثْ ذ ثْعلْدْجثْ ذ ؤُزڭّْوَاغْ إِحذْقنْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","أَذْ يجّْ أَجْضِيضْ إِدَّارنْ أَذْ إِضْوَا بَارَّا إِ ثنْذِينْثْ سنّجْ إِ وُوذمْ ن ييَّارْ. أَمُّو إِ غَا إِڭّْ أَصْڒَاحْ خْ ثَادَّارْثْ نِّي ؤُشَا أَذْ ثِيڒِي ثِيزْذِيڭْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","”وَا ذ أَزرْفْ خْ مَارَّا ڒهْڒَاشَاثْ ن ڒْبَارْصْ ؤُ خْ ثْفُورِي ن يِيڒمْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","خْ ڒْبَارْصْ ن أَرُّوضْ ؤُ ن ثَادَّارْثْ، ");
INSERT INTO rifa_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","خْ إِجّْ ن ؤُعبُّوزْ، خْ إِشْثْ ن ثْحبُّوشْثْ ؤُ خْ إِجّْ ن ونْڭَازْ إِشّمْڒڒْ ن ثڒْمشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","أَزرْفْ-أَ أَقَا إِ ثْغُورِي ذڭْ وَاسّْ إِ ذِي غَا يِيڒِي حذْ إِخْمجْ نِيغْ ذڭْ وَاسّْ إِ ذِي غَا يِيڒِي حذْ إِزْذڭْ. وَا ذ أَزرْفْ ن ڒْبَارْصْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِيمْ أَسنْ: ’مَاڒَا أَرْيَازْ غَارسْ إِجّْ ن ؤُسيّڒْ زِي أَرِّيمثْ نّسْ، خنِّي أَذْ يِيڒِي إِخْمجْ زِي سِّيبّثْ ن ؤُسيّڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","وَا أَذْ يِيڒِي ذ ڒخْمجْ نّسْ زِي سِّيبّثْ ن ؤُسيّڒْ نّسْ: مَاڒَا أَرِّيمثْ نّسْ ثتّجَّا أَسيّڒْ نّسْ نِيغْ أَرِّيمثْ نّسْ ثسّْبدَّا أَسيّڒْ نّسْ، أَقَا-ث ذ ڒخْمجْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","كُوڒْ قَامَا مِينْ خفْ غَا إِطّصْ ونِّي ذِي إِدْجَا ؤُسيّڒْ، أَذْ يِيڒِي إِخْمجْ ؤُ كُوڒْ ڒْقشْعثْ إِ خفْ غَا إِقِّيمْ، أَذْ ثِيڒِي ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","مَارَّا وِي غَا إِحَاذَانْ قَامَا نّسْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ عَاوذْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ونِّي إِ غَا إِقِّيمنْ خْ شَا خْ مِينْ خفْ ثُوغَا إِقِّيمْ ونِّي ذِي إِدْجَا ؤُسيّڒْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ عَاوذْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ونِّي إِ غَا إِحَاذَانْ أَرِّيمثْ ن ونِّي ذِي إِدْجَا ؤُسيّڒْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ ؤُشَا نتَّا سِيمَانْثْ نّسْ أَذْ إِسِّيرْذْ س وَامَانْ، ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","مَاڒَا وِي ذِي إِدْجَا ؤُسيّڒْ إِسُّوسفْ خْ إِجّْ ن ؤُمزْذَاڭْ، أَقَا وَا أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","كُوڒْ ثْرِيشْثْ مِينْ خفْ إِقِّيمْ ونِّي ذِي إِدْجَا ؤُسيّڒْ، أَذْ ثِيڒِي ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","مَارَّا وِي غَا إِحَاذَانْ مَامّشْ مَا ڒْقشْعثْ نِّي إِدْجَانْ سَاذُو نّسْ، أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ ؤُشَا وِي ت غَا إِكْسِينْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","مَارَّا وِي غَا إِتّْوَاحَاذَانْ زڭْ ونِّي ذِي إِدْجَا ؤُسيّڒْ بْڒَا مَا أَذْ إِسِّيرْذْ وَا إِفَاسّنْ نّسْ أَمزْوَارُو، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","طّبْصِي ن ثْڒَاخْثْ نِّي إِحَاذَا ونِّي ذِي إِدْجَا ؤُسيّڒْ، إِتّْخصَّا أَذْ إِتّْوَارْژْ، مَاشَا مَارَّا ڒْقشْعثْ ن ثفْڒَاوْثْ أَذْ ت سِيرْذنْ س وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","خْمِي ونِّي ذِي إِدْجَا ؤُسيّڒْ أَذْ إِتّْوَاسِّيزْذڭْ زڭْ ؤُسيّڒْ نّسْ، إِتّْخصَّا أَسْ سِيمَانْثْ نّسْ أَذْ إِحْسبْ إِ سبْعَا ن وُوسَّانْ. خنِّي أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ إِدَّارنْ ؤُشَا أَذْ يِيڒِي إِزْذِيڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ إِكْسِي ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ ثْنَاينْ ن إِذْبِيرنْ إِمژْيَاننْ ؤُشَا أَذْ د-يَاسْ زَّاثْ إِ وُوذمْ ن سِيذِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ ثنْ إِوْشْ إِ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","أَكهَّانْ أَذْ إِسّوْجذْ إِشْثْ ن ثْغَارْصْثْ ن دّنْبْ ذ إِشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ. أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ زَّاثْ إِ وُوذمْ ن سِيذِي خْ ؤُسيّڒْ نّسْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","”مَاڒَا إِفّغْ-د ؤُسيّڒْ ن وَادْجُو زڭْ ورْيَازْ، أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ مَارَّا س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","كُوڒْ أَرُّوضْ ذ كُوڒْ إِڒمْ إِ خفْ إِدْجَا ؤُسيّڒْ ن وَادْجُو، إِتّْخصَّا أَذْ ث سِيرْذنْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","مَاڒَا إِطّصْ يِيجّْ ورْيَازْ أَكْ-ذ ثمْغَارْثْ ؤُشَا إِنْضَارْ ذَايسْ نتَّا، خنِّي أَذْ سِّيرْذنْ س ثْنَاينْ إِذْسنْ س وَامَانْ ؤُشَا أَذْ إِڒِينْ خمْجنْ أَڒْ ثَامذِّيثْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","”مَاڒَا ثَامْغَارْثْ ثُوغَا-ت ثْسيّڒْ، أَقَا خَاسْ إِذَامّنْ ذِي أَرِّيمثْ نّسْ، خنِّي أَذْ ثعْزڒْ سبْعَا ن وُوسَّانْ. مَارَّا وِي ت غَا إِحَاذَانْ أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","مَارَّا مِينْ خفْ ثُوغَا ثطّصْ ذڭْ وعْزَاڒْ نّسْ، أَذْ يِيڒِي إِخْمجْ ؤُشَا مَارَّا مِينْ خفْ ثُوغَا ثقِّيمْ، أَذْ يِيڒِي إِخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","مَارَّا وِي غَا إِحَاذَانْ قَامَا نّسْ، أَذْ إِسِّيرْذْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","مَارَّا وِي غَا إِحَاذَانْ شَا ن ڒْقشْعثْ مِينْ خفْ ثُوغَا ثتّْغِيمَا، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","نِيغْ مَاڒَا إِقِّيمْ خْ قَامَا نِيغْ خْ ڒْقشْعثْ إِ خفْ ثُوغَا ثقِّيمْ نتَّاثْ، ؤُمِي إِحَاذَا أَيَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","مَاڒَا إِطّصْ أَكِيذسْ إِجّْ ن ورْيَازْ ؤُشَا يُوسَا-د خَاسْ وعْزَاڒْ نّسْ، خنِّي أَذْ يِيڒِي إِخْمجْ سبْعَا ن وُوسَّانْ. كُوڒْ قَامَا إِ خْ ثُوغَا إِطّصْ، أَذْ ثِيڒِي ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","مَاڒَا ؤُسِينْ-د إِذَامّنْ خْ إِشْثْ ن ثمْغَارْثْ أَطَّاسْ ن وُوسَّانْ بَارَّا إِ ڒْمِيجَاڒْ ن وعْزَاڒْ نّسْ نِيغْ مَاڒَا ثُوغَا أَسيّڒْ كْثَارْ خْ ڒْمِيجَاڒْ ن وعْزَاڒْ نّسْ، خنِّي أَذْ ثِيڒِي ثخْمجْ مَارَّا ؤُسَّانْ ن ؤُسيّڒْ إِ د-يُوسِينْ أَكْ-ذ ڒخْمجْ نّسْ، أَمْ ذڭْ وُوسَّانْ ن وعْزَاڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","كُوڒْ قَامَا مِينْ خفْ ثطّصْ مَارَّا ؤُسَّانْ ن ؤُسيّڒْ نّسْ، أَذْ أَسْ ثِيڒِي أَمْ قَامَا ن وعْزَاڒْ نّسْ ؤُ مَارَّا ڒْقشْعثْ مِينْ خفْ ثقِّيمْ، أَذْ ثِيڒِي ثخْمجْ أَمشْنَاوْ ڒخْمجْ ن وعْزَاڒْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","مَارَّا وِي غَا إِحَاذَانْ ثِيمسْڒَايِينْ نِّي، أَذْ يِيڒِي إِخْمجْ. أَذْ إِصبّنْ أَرُّوضْ نّسْ ؤُشَا أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","مَاڒَا ثتّْوَاسِّيزْذڭْ زڭْ ؤُسيّڒْ نّسْ، إِتّْخصَّا أَذْ ثحْسبْ إِ يِيخفْ نّسْ سبْعَا ن وُوسَّانْ، أَوَارْنِي أَسْ أَذْ ثِيڒِي ثزْذڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ ثكْسِي إِ يِيخفْ نّسْ ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ ثْنَاينْ ن إِذْبِيرنْ إِمژْيَاننْ ؤُشَا أَذْ ثنْ ثَاوِي غَارْ ؤُكهَّانْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","أَكهَّانْ أَذْ إِسّوْجذْ إِشْثْ ن ثْغَارْصْثْ ن دّنْبْ ذ إِشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ ؤُشَا أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ ذِي ثْمسْڒَاشْثْ ن ؤُسيّڒْ ن ڒخْمجْ نّسْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","أَمُّو إِ غَا ثْعزْڒذْ أَيْثْ ن إِسْرَائِيل خْ ڒخْمجْ نْسنْ، حِيمَا وَارْ تّمتِّينْ ذِي ڒخْمجْ نْسنْ، ؤُمِي سّْخمَّاجنْ ثَازذِّيغْثْ إِنُو نِّي إِدْجَانْ ذِي ڒْوسْطْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","وَا ذ أَزرْفْ إِ ونِّي غَارْ إِدْجَا ؤُسيّڒْ ؤُ إِ ونِّي زِي غَا إِفّغْ وَادْجُو نّسْ ؤُشَا خنِّي أَذْ يِيڒِي إِخْمجْ ");
INSERT INTO rifa_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ؤُ عَاوذْ إِ ثنِّي مِينْ خفْ إِدْجَا إِذَامّنْ ؤُشَا خنِّي ثعْزڒْ إِخفْ نّسْ ؤُ عَاوذْ إِ وِي ذِي ثُوغَا أَسيّڒْ، إِ ورْيَازْ ؤُڒَا إِ ثمْغَارْثْ، ؤُ عَاوذْ إِ ورْيَازْ إِ ثُوغَا إِطّْصنْ أَكْ-ذ ثنِّي إِدْجَانْ ثخْمجْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا أَوَارْنِي إِ ڒْموْثْ ن ثْنَاينْ ن وَارَّاوْ ن هَارُونْ، أَوَارْنِي ڒَامِي د-قَارّْبنْ نِيثْنِي زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا مُّوثنْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","سِيذِي إِنَّا إِ مُوسَا: ”سِيوڒْ أَكْ-ذ هَارُونْ، ؤُمَاشْ، حِيمَا وَارْ إِتِّيذفْ ڒبْذَا غَارْ ؤُقدَّاسْ ذَاخڒْ إِ ؤُڒحَّافْ زَّاثْ إِ ثْقبَّارْثْ ن وصْڒَاحْ نِّي إِدْجَانْ خْ تَّابُوثْ، حِيمَا وَارْ إِتّْمتِّي شَا، مِينْزِي نشّْ تّْبَانغْ-د ذڭْ إِجّْ ن ؤُسيْنُو سنّجْ إِ ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","س ؤُيَا أَذْ يَاذفْ هَارُونْ غَارْ ؤُقدَّاسْ: س إِجّْ ن ؤُفُونَاسْ، أَمژْيَانْ ن ثْفُونَاسْثْ، إِ ثْغَارْصْثْ ن دّنْبْ، ؤُ س يِيجّْ ن إِشَارِّي إِ ثْغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","أَذْ يَارْضْ ثْشَامِيرْ إِقدّْسنْ ن ڒقْطنْ ؤُشَا سَّارْوَاڒْ نْ ڒقْطنْ أَذْ يِيڒِي خْ أَرِّيمثْ نّسْ. أَذْ إِبْيسْ ثَاحزَّامْثْ ن ڒقْطنْ ؤُشَا أَذْ يَاركّبْ أَرژّثْ ن ڒقْطنْ. أَقَا مَانْ أَيَا ذ أَرُّوضْ إِقدّْسنْ. مَاڒَا أَذْ ثنْ يَارْضْ، إِتّْخصَّا أَسْ أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ ذ أَمزْوَارُو. ");
INSERT INTO rifa_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","أَذْ إِكْسِي زِي ثْمسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ثْنَاينْ ن إِمْيَاننْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ذ إِجّْ ن إِشَارِّي إِ ثْغَارْصْثْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","أَذْ د-إِسّْقَارّبْ هَارُونْ أَفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن وشْمَاضْ، ونِّي إِدْجَانْ إِ يِيخفْ نّسْ، ؤُشَا أَذْ إِڭّْ أَصْڒَاحْ إِ يِيخفْ نّسْ ؤُ إِ ثَادَّارْثْ نّسْ.    ");
INSERT INTO rifa_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","أَذْ إِكْسِي ثْنَاينْ ن إِمْيَاننْ ؤُشَا أَذْ ثنْ إِڭّْ زَّاثْ إِ وُوذمْ ن سِيذِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","أَذْ إِنْضَارْ هَارُونْ ثَاقدُّوحْثْ خْ ثْنَاينْ ن إِمْيَاننْ: إِشْثْ ن ثْقدُّوحْثْ خْ سِيذِي ؤُ إِشْثْ ن ثْقدُّوحْثْ خْ إِغَايْضْ إِنُّوفْسْڒنْ، قَّارنْ أَسْ ’عَازَازِيلْ‘. ");
INSERT INTO rifa_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","أَذْ د-إِسّْقَارّبْ هَارُونْ أَمْيَانْ نِّي خْ د-ثوْضَا ثَاقدُّوحْثْ إِ سِيذِي ؤُشَا أَذْ ث إِسّوْجذْ ذ ثْغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","أَمْيَانْ إِ خْ د-ثوْضَا ثَاقدُّوحْثْ ن إِغَايْضْ إِنُّوفْسْڒنْ، أَذْ ث إِڭّْ إِدَّارْ زَّاثْ إِ وُوذمْ ن سِيذِي، مَاحنْذْ أَذْ زَّايسْ إِڭّْ أَصْڒَاحْ ؤُشَا خنِّي أَذْ ث إِسّكّْ أَمْ يِيغَايْضْ إِنُّوفْسْڒنْ غَارْ ڒخْڒَا. ");
INSERT INTO rifa_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","أَذْ د-إِسّْقَارّبْ هَارُونْ أَفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ، ونِّي ثُوغَا إِ يِيخفْ نّسْ، ؤُشَا أَذْ إِڭّْ أَصْڒَاحْ إِ يِيخفْ نّسْ ؤُ إِ أَيْثْبَابْ ن ثَادَّارْثْ نّسْ ؤُشَا أَذْ إِغَارْصْ إِ ؤُفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ، ونِّي إِدْجَانْ إِ يِيخفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","أَذْ إِكْسِي عَاوذْ إِجّْ ن ڒْمجْمَارْ إِشُّورْ س ڒفْحمْ إِتّحْذُوذُوقنْ ن ؤُعَالْطَارْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَذْ إِشُّورْ ثْنَاينْ ن إِفَاسّنْ نّسْ س ڒبْخُورْ أَزْذَاذْ إِتّْفُوحنْ، ؤُشَا أَذْ يَاوِي مَارَّا أَيَا ذَاخڒْ إِ ؤُڒحَّافْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","أَذْ إِڭّْ ڒبْخُورْ خْ ثْمسِّي زَّاثْ إِ وُوذمْ ن سِيذِي، حِيمَا أَسيْنُو ن ڒفْوَارْ ن ڒبْخُورْ أَذْ إِذڒْ ثَاقبَّارْثْ ن وصْڒَاحْ إِ إِدْجَانْ خْ شّْهَاذثْ، ؤُشَا وَارْ إِتّْمتِّي شَا. ");
INSERT INTO rifa_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","أَذْ إِكْسِي شْوَايْثْ زڭْ إِذَامّنْ ن ؤُفُونَاسْ أَمژْيَانْ ؤُشَا أَذْ ثنْ إِرُوشّْ س ؤُضَاضْ نّسْ خْ وُوذمْ ن ثْقبَّارْثْ ن وصْڒَاحْ غَارْ ؤُغزْذِيسْ ن شَّارْقْ ؤُشَا عَاوذْ أَذْ إِرُوشّْ شْوَايْثْ زڭْ إِذَامّنْ سبْعَا ن ثْوَاڒَاوِينْ س ؤُضَاضْ نّسْ زَّاثْ إِ ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","خنِّي أَذْ إِغَارْصْ إِ ؤُمْيَانْ ن ثْغَارْصْثْ ن دّنْبْ، ونِّي إِدْجَانْ إِ ڒْڭنْسْ ؤُشَا أَذْ يَاوِي إِذَامّنْ غَارْ ذَاخڒْ إِ ؤُڒحَّافْ ؤُشَا أَذْ إِڭّْ س إِذَامّنْ نّسْ أَمْ مَامّشْ إِڭَّا س إِذَامّنْ ن ؤُفُونَاسْ أَمژْيَانْ: أَذْ ثنْ إِرُوشّْ خْ ثْقبَّارْثْ ن وصْڒَاحْ ؤُ زَّاثْ إِ ثْقبَّارْثْ ن وصْڒَاحْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","أَمُّو إِ إِ غَا إِڭّْ أَصْڒَاحْ خْ ؤُقدَّاسْ إِ ڒْحَاجَّاثْ إِخمْجنْ ن أَيْثْ ن إِسْرَائِيل ؤُ إِ إِخطَّانْ نْسنْ إِ د-إِتَّاسنْ أَكْ-ذ مَارَّا دّْنُوبْ نْسنْ. أَمُّو إِ غَا يڭّْ ذِي سِّيبّثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ونِّي إِدْجَانْ أَكِيذْسنْ ذِي ڒْوسْطْ ن مَارَّا ثِيمسْڒَايِينْ إِخمْجنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ؤُڒَا ذ إِجّْ ن بْنَاذمْ أَذْ يِيڒِي عَاذْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ زڭْ وَامِي إِ غَا يَاذفْ مَاحنْذْ أَذْ إِڭّْ أَصْڒَاحْ ذڭْ ؤُقدَّاسْ أَڒْ غَا إِفّغْ عَاوذْ. أَمُّو إِ غَا إِڭّْ أَصْڒَاحْ إِ يِيخفْ نّسْ ؤُ إِ مَارَّا أَڭْرَاوْ ن ڒْڭنْسْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","أَذْ إِفّغْ أَڒْ ؤُعَالْطَارْ إِ إِدْجَانْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَذْ إِڭّْ أَسْڒَاحْ خْ ؤُعَالْطَارْ. أَذْ إِكْسِي شْوَايْثْ زڭْ إِذَامّنْ ن ؤُفُونَاسْ أَمژْيَانْ ؤُ شْوَايْثْ زڭْ إِذَامّنْ ن ؤُمْيَانْ ؤُشَا أَذْ إِسَّارْسْ أَيَا خْ وَاشَّاونْ ن ؤُعَالْطَارْ ذڭْ ونّضْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","سبْعَا ن ثْوَاڒَاوِينْ أَذْ خَاسْ إِرُوشّْ س ؤُضَاضْ نّسْ شْوَايْثْ زڭْ إِذَامّنْ ؤُشَا أَذْ ث إِسِّيزْذڭْ ؤُ أَذْ ث إِسّْقدّسْ زِي ڒخْمجْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","أَوَارْنِي ڒَامِي إِكمّڒْ أَصْڒَاحْ ن ؤُقدَّاسْ ذ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ذ ؤُعَالْطَارْ، أَذْ د-إِسّْقَارّبْ خنِّي أَمْيَانْ إِدَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","أَذْ إِسَّارْسْ هَارُونْ ثْنَاينْ ن إِفَاسّنْ نّسْ خْ ؤُزدْجِيفْ ن ؤُمْيَانْ إِدَّارنْ ؤُشَا أَمُّو إِ غَا إِنْعمْ هَارُونْ سنّجْ إِ ؤُزدْجِيفْ ن ؤُمْيَانْ خْ مَارَّا ڒْمُوعْصِييّثْ ن أَيْثْ ن إِسْرَائِيل ذ مَارَّا إِخطَّانْ نْسنْ إِ د-يُوسِينْ أَكْ-ذ مَارَّا دّْنُوبْ نْسنْ ؤُشَا أَذْ ثنْ إِسَّارْسْ خْ ؤُزدْجِيفْ ن ؤُمْيَانْ ؤُشَا أَذْ ث إِسّكّْ غَارْ ڒخْڒَا س ؤُفُوسْ ن إِجّْ ن ورْيَازْ ونِّي إِسّْوجْذنْ إِ دّڭَّا. ");
INSERT INTO rifa_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ؤُشَا إِغَايْضْ أَذْ يَاوِي أَكْ-ذ إِخفْ نّسْ مَارَّا ڒْمُوعْصِييّثْ نْسنْ غَارْ إِشْثْ ن جِّيهثْ ثخْڒَا. نتَّا أَذْ إِسّكّْ أَمْيَانْ غَارْ ڒخْڒَا. ");
INSERT INTO rifa_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","خنِّي أَذْ يَاذفْ هَارُونْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ إِكّسْ أَرُّوضْ ن ڒقْطنْ نِّي يَارْضْ، ؤُمِي يُوذفْ غَارْ ؤُقدَّاسْ ؤُشَا أَذْ ث يجّْ ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ ذڭْ ومْشَانْ أَمْقدَّاسْ ؤُشَا أَذْ يَارْضْ أَرُّوضْ نّسْ. خنِّي أَذْ إِفّغْ، أَذْ إِسّوْجذْ ثَاغَارْصْثْ ن وشْمَاضْ نّسْ ذ ثْغَارْصْثْ ن ڒْڭنْسْ ؤُشَا أَذْ إِڭّْ أَصْڒَاحْ إِ يِيخفْ نّسْ ؤُ إِ ڒْڭنْسْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","أَذْ إِسّْبخَّارْ ثَاذُونْثْ ن ثْغَارْصْثْ نْ دّنْبْ خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","وِي د-إِسكّنْ أَمْيَانْ أَمْ ؤُمْيَانْ إِنُّوفْسْڒنْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ. أَوَارْنِي أَسْ أَذْ يَاذفْ غَارْ ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","أَفُونَاسْ أَمژْيَانْ ن ثْغَارْصْثْ ن دّنْبْ ذ ؤُمْيَانْ ن طْغَارْصْثْ ن دّنْبْ إِ زِي تّْوَاسِّيذْفنْ إِذَامّنْ نْسنْ، مَاحنْذْ أَذْ زَّايْسنْ إِتّْوَاڭّْ أَصْڒَاحْ ذڭْ ؤُقدَّاسْ، أَذْ ثنْ سُّوفّْغنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُشَا أَذْ زَّايْسنْ سّْشمْضنْ إِڒْمَاونْ نْسنْ ذ ويْسُومْ نْسنْ ذ ؤُمسَّاڒْ نْسنْ س ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","وِي ثنْ غَا إِسّْشمْضنْ، أَذْ إِصبّنْ أَرُّوضْ نّسْ، أَذْ إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ. أَوَارْنِي أَسْ أَذْ يَاذفْ غَارْ ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","ثَا ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ كنِّيوْ. ذڭْ ؤُيُورْ وِيسّْ سبْعَا، ذڭْ وَاسّْ وِيسّْعشْرَا ن ؤُيُورْ، أَذْ ثسّْوَاضْعمْ إِخفْ نْومْ ؤُشَا وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ، نِيغْ ونِّي د-إِخڒْقنْ ذِي ثمُّورْثْ نِيغْ ؤُبَارَّانِي نِّي إِزدّْغنْ ذِي ڒْوسْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","مِينْزِي ذڭْ وَاسّْ نِّي أَذْ إِتّْوَاڭّْ وصْڒَاحْ إِ كنِّيوْ، مَاحنْذْ أَذْ ثتّْوَاسِّيزذْڭمْ. كنِّيوْ مَارَّا أَذْ ثتّْوَاسِّيزذْڭمْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","أَسّْ نِّي أَذْ يِيڒِي ذ إِجّْ وَاسّْ ن سّبْثْ، أَرَّاحثْ ثْمُونْ إِ كنِّيوْ. أَذْ ثسّْوَاضْعمْ إِخفْ نْومْ، أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","أَكهَّانْ، ونِّي ذهْننْ ؤُ ڒقّْمنْ نِيثْنِي ذڭْ ومْشَانْ ن بَابَاسْ، مَاحنْذْ أَذْ يِيڒِي ذ أَكهَّانْ، أَذْ إِڭّْ أَصْڒَاحْ ؤُشَا أَذْ يَارْضْ أَرُّوضْ ن ڒقْطنْ، أَرُّوضْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","أَذْ إِڭّْ أَصْڒَاحْ خْ زَّاوشْثْ إِقدّْسنْ ؤُ خْ ثْقِيضُونْثْ ن ؤُمْسَاڭَارْ ؤُ خْ ؤُعَالْطَارْ. أَذْ إِڭّْ أَصْڒَاحْ عَاوذْ خْ مَارَّا إِكهَّاننْ ؤُ خْ مَارَّا ڒْڭنْسْ ن وڭْرَاوْ. ");
INSERT INTO rifa_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ثَا ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ كنِّيوْ، حِيمَا أَذْ إِتّْوَاڭّْ وصْڒَاحْ خْ مَارَّا أَيْثْ ن إِسْرَائِيل إِ مَارَّا دّْنُوبْ نْسنْ، إِشْثْ ن ثْوَاڒَا ذڭْ ؤُسڭّْوَاسْ.“ ؤُشَا إِڭَّا أَمْ مَامّشْ إِوصَّا سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","”سِيوڒْ أَكْ-ذ هَارُونْ ذ وَارَّاوْ نّسْ ؤُ أَكْ-ذ مَارَّا أَيْثْ ن إِسْرَائِيل، إِنِي أَسنْ: ’وَا ذ أَوَاڒْ إِ إِوصَّا سِيذِي، إِقَّارْ: ");
INSERT INTO rifa_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","كُوڒْ أَرْيَازْ زِي ثَادَّارْثْ ن إِسْرَائِيل، ونِّي إِغَارْصنْ إِ ؤُفُونَاسْ نِيغْ إِ يزْمَارْ نِيغْ إِ إِغَايْضْ ذِي ڒْمَارْڭحْ نِيغْ ونِّي ث إِغَارْصنْ بَارَّا إِ ڒْمَارْڭحْ، ");
INSERT INTO rifa_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","مَاشَا وَارْ ث يِيوِي ذ ثَاوْهِيبْثْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مَاحنْذْ أَذْ ث-إِ-د-إِسّْقَارّبْ ذ ثَاوْهِيبْثْ غَارْ سِيذِي زَّاثْ ن ثْزذِّيغْثْ ن سِيذِي، أَذْ أَسْ د-إِتّْوَاحْسبْ إِذَامّنْ نِّي. نتَّا إِسِّيزّڒْ إِذَامّنْ، س ؤُينِّي أَذْ إِتّْوَاقسْ ورْيَازْ نِّي زِي ڒْڭنْسْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","مَاحنْذْ، خْمِي غَا قدّْمنْ أَيْثْ ن إِسْرَائِيل ثِيغَارْصَا نْسنْ، ثِينِّي نُّومنْ غَارّْصنْ بَارَّا ذڭْ إِيَّارْ، نِيثْنِي أَذْ ثنْثْ أَوْينْ غَارْ سِيذِي، غَارْ ؤُكهَّانْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مَاحنْذْ أَذْ ثنْثْ قدّْمنْ ذِينْ أَمْ ثْغَارْصَا ن ڒهْنَا إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","أَكهَّانْ أَذْ إِزدْجعْ إِذَامّنْ خْ ؤُعَالْطَارْ ن سِيذِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُ نتَّا أَذْ إِسّْبخَّارْ ثَاذُونْثْ أَمْ يِيشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","وَارْ تّْقدَّامنْ عَاذْ ثِيغَارْصَا نْسنْ إِ إِمُويَانْ إِجنِّينْ، إِنِّي ضفَّارنْ نِيثْنِي أَمْ أَيْثْ ن فَارْقْ-شّْغڒْ. ثَا ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ نِيثْنِي إِ مَارَّا جِّيڒَاثْ نْسنْ.‘ ");
INSERT INTO rifa_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","أَذْ أَسنْ ثِينِيذْ عَاوذْ: ’كُوڒْ أَرْيَازْ ن أَيْثْ ن إِسْرَائِيل ؤُ ن إِبَارَّانِييّنْ، إِنِّي إِدْجَانْ ذِي ڒْوسْطْ نْسنْ، ونِّي إِخْسنْ أَذْ إِسّْبخَّارْ إِشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ نِيغْ شَا ن طَاغَارْصْثْ إِ غَارسْ، ");
INSERT INTO rifa_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","مَاشَا وَارْ ت-إِ-د-يِيوِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، حِيمَا أَذْ ت إِسّوْجذْ إِ سِيذِي، أَرْيَازْ نِّي أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","”كُوڒْ إِجّْ زِي ثَادَّارْثْ ن إِسْرَائِيل نِيغْ زڭْ إِبَارَّانِييّنْ، إِنِّي إِزدّْغنْ ذِي ڒْوسْطْ نْسنْ، ونِّي إِ غَا إِشّنْ إِذَامّنْ مَامّشْ مَا ڭِّينْ، نشّْ أَذْ قڒْبغْ ؤُذمْ إِنُو خْ ڒعْمَارْ نِّي إِشّنْ إِذَامّنْ نِّي، ؤُشَا أَذْ ث قضْعغْ زِي ڒْوسْطْ نْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","مِينْزِي ڒعْمَارْ ن أَرِّيمثْ ذڭْ إِذَامّنْ ؤُشَا نشّْ وْشِيغْ أَومْ إِذَامّنْ خْ ؤُعَالْطَارْ، مَاحنْذْ أَذْ زَّايْسنْ إِتّْوَاڭّْ وصْڒَاحْ إِ ڒعْمُورْ نْومْ، مِينْزِي إِذَامّنْ ذ إِنَا إِ غَا إِوْينْ أَصْڒَاحْ إِ ڒعْمَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","خْ ؤُيَا أَقَا نِّيغْ إِ أَيْثْ ن إِسْرَائِيل: ؤُڒَا ذ إِجّْ زَّايْومْ وَارْ إِتّتّْ زڭْ إِذَامّنْ، ؤُڒَا ذ أَبَارَّانِي إِ إِزدّْغنْ ذِي ڒْوسْطْ نْومْ وَارْ إِتّتّْ إِذَامّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","كُوڒْ  إِجّْ زڭْ أَيْثْ ن إِسْرَائِيل ؤُ زڭْ إِبَارَّانِييّنْ إِ إِزدّْغنْ ذِي ڒْوسْطْ نْومْ، ونِّي إِيْمَارنْ إِجّْ ن ؤُمُودَّارْ نِيغْ إِجّْ ن وجْضِيضْ نِّي إِزمَّارْ أَذْ إِتّْوَاشّْ، أَذْ إِسِّيزّڒْ إِذَامّنْ نّسْ ؤُشَا أَذْ ثنْ إِسّْذُورِييْ س ؤُشَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","مِينْزِي ڒعْمَارْ ن كُوڒْ أَيْسُومْ ذ إِذَامّنْ نّسْ، أَقَا أَثنْ ذ إِجّنْ أَكْ-ذ ڒعْمَارْ نّسْ. س ؤُينِّي نِّيغْ إِ أَيْثْ ن إِسْرَائِيل: ’وَارْ تّتّمْ زڭْ إِذَامّنْ ن مَامّشْ مَا إِڭَّا ويْسُومْ!‘، مِينْزِي ڒعْمَارْ ن مَارَّا أَيْسُومْ ذ إِذَامّنْ نّسْ. ونِّي زَّايْسنْ غَا إِشّنْ، أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","مَارَّا ونِّي إِ غَا إِشّنْ زڭْ إِشْثْ نْ ڒْخشْبثْ نِيغْ زڭْ إِجّْ ن ؤُمُودَّارْ إِمزّْقنْ، مَا نتَّا زِي ثَارْوَا ن ثمُّورْثْ نِيغْ نتَّا ذ إِجّْ ن ؤُبَارَّانِي، أَذْ إِصبّنْ أَرُّوضْ نّسْ ؤُشَا أَذْ إِسِّيرْذْ إِخفْ نّسْ س وَامَانْ ؤُشَا أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ. أَوَارْنِي أَيَا أَذْ يِيڒِي إِزْذڭْ. ");
INSERT INTO rifa_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","مَاڒَا وَارْ إِسِّيرْذْ أَرُّوضْ ؤُ وَارْ إِسِّيرْذْ أَرِّيمثْ نّسْ، خنِّي أَذْ يَارْبُو ڒْمُوعْصِييّثْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","وَارْ تّڭّمْ أَمْ مَامّشْ تّڭّنْ ذِي ثمُّورْثْ ن مِيصْرَا مَانِي ثُوغَا ثْزدّْغمْ كنِّيوْ، ؤُ وَارْ ثتّڭّمْ أَمْ مَامّشْ تّڭّنْ ذِي ثمُّورْثْ ن كنْعَانْ مَانِي كنِّيوْ غَا نذْهغْ، ؤُ وَارْ ثتّڭّمْ عْلَاحْسَابْ ثِيوصَّا نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","أَذْ ثڭّمْ لْفَارَايِيضْ إِنُو ؤُشَا أَذْ ثحْضَامْ ثِيوصَّا إِنُو، مَاحنْذْ أَذْ ذَايْسنْ ثُويُورمْ: نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","أَذْ ثحْضَامْ ثِيوصَّا إِنُو ذ لْفَارَايِيضْ إِنُو: بْنَاذمْ نِّي ثنْثْ إِتّڭّنْ، أَذْ زَّايْسنْثْ إِدَّارْ، نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ؤُڒَا ذ إِجّْ أَذْ د-إِقَارّبْ غَارْ شَا ن يِيجّنْ زِي رَادْجْ نّسْ، حِيمَا أَذْ إِسّْعَارَّا ڒْعَارْ نّسْ: نشّْ ذ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن بَابَاشْ ذ ڒْعَارْ ن يمَّاشْ. أَقَا-ت ذ يمَّاشْ، وَارْ تّسّْعَارِّي شَا ڒْعَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ڒْعَارْ ن ثمْغَارْثْ ن بَابَاشْ وَارْ ث تّسّْعَارِّي شَا. أَقَا-ث ذ ڒْعَارْ ن بَابَاشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","خْ ڒْعَارْ ن ؤُتْشْمَاشْ، يدْجِيسْ ن بَابَاشْ نِيغْ يدْجِيسْ ن يمَّاشْ، نِيغْ نتَّاثْ ثتّْوَاخْڒقْ-د ذِي ثَادَّارْثْ نِيغْ بَارَّا إِ ثَادَّارْثْ، أَقَا ڒْعَارْ نّسْ وَارْ ث ثسّْعَارِّي شَا. ");
INSERT INTO rifa_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","خْ ڒْعَارْ ن يدْجِيسْ ن مِّيشْ نِيغْ ن يدْجِيسْ ن يدْجِيشْ، وَارْ تّسّْعَارِّي شَا ڒْعَارْ نْسنْ مِينْزِي أَقَا ذ ڒْعَارْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن يدْجِيسْ ن ثمْغَارْثْ ن بَابَاشْ، ثنِّي د-إِتّْوَاخڒْقنْ إِ بَابَاشْ. أَقَا-ت ذ ؤُتْشْمَاشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن ؤُتْشْمَاسْ ن بَابَاشْ. أَقَا-ت ذ رَادْجْ ن بَابَاشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن ؤُتْشْمَاسْ ن يمَّاشْ، مِينْزِي نتَّاثْ ذ رَادْجْ ن يمَّاشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن ؤُمَاسْ ن بَابَاشْ ؤُ وَارْ د-تّْقَارَّابذْ غَارْ ثمْغَارْثْ نّسْ، أَقَا-ت ذعنْثِيشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن ثمْغَارْثْ ن مِّيشْ، أَقَا-ت ذ ثَامْغَارْثْ ن مِّيشْ. وَارْ تّسّْعَارِّي شَا ڒْعَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","وَارْ تّسّْعَارِّي شَا ڒْعَارْ ن ثمْغَارْثْ ن ؤُمَاشْ، أَقَا-ث ذ ڒْعَارْ ن ؤُمَاشْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","وَارْ ثسّْعَارِّي شَا ڒْعَارْ ن ثمْغَارْثْ ذ يدْجِيسْ. وَارْ د-تَّاوِي شَا يدْجِيسْ ن مِّيسْ نِيغْ يدْجِيسْ ن يدْجِيسْ، مَاحنْذْ أَذْ ثسّْعَارِّيذْ ڒْعَارْ نّسْ. أَقَا أَثنْثْ ذ رَادْجْ نّشْ، أَقَا-ت ذ إِشْثْ ن ثْمعْمُوتْشْ إِفسْذنْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","وَارْ د-تَّاوِي ثَامْغَارْثْ ذ ثَاشْنَا أَكْ-ذ ؤُتْشْمَاسْ مَاحنْذْ أَذْ ت ثْغنّذْ أَمُّو، خْمِي غَا ثسّْعَارِّيذْ ڒْعَارْ نّسْ أَمْ عَاذْ ثدَّارْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","وَارْ د-تّْقَارَّابْ شَا غَارْ إِشْثْ ن ثمْغَارْثْ خْمِي غَا ثعْزڒْ إِخفْ نّسْ زِي سِّيبّثْ ن ڒخْمجْ نّسْ حِيمَا أَذْ ثسّْعَارِّيذْ ڒْعَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","وَارْ تّطّصْ أَكْ-ذ ثمْغَارْثْ ن جَّارْ نّشْ، مَاغَارْ أَمُّو إِ غَا ثْفسْذذْ إِخفْ نّشْ زَّايسْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","وَارْ تّجِّي أَرَّاوْ نّشْ أَذْ ژْوَانْ غَارْ مُولَاكْ، وَارْ سّخْسَارَا إِسمْ ن أَربِّي نّشْ، نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","وَارْ تّطّصْ شَا أَكْ-ذ شَا ن ورْيَازْ أَمْ ثطّصذْ أَكْ-ذ ثمْغَارْثْ. أَقَا-ت ذ جّْعِيفشْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","وَارْ فسّذْ شَا إِخفْ نّشْ أَكْ-ذ شَا ن ڒبْهِيمثْ أَمْ ثْفحّْڒذْ إِخفْ نّشْ أَكِيذسْ، ؤُ ثَامْغَارْثْ وَارْ ثتّْبذِّي زَّاثْ إِ ڒبْهِيمثْ مَاحنْذْ أَذْ ثْفسْذذْ إِخفْ نّسْ زَّايسْ. أَقَا ذ إِجّْ ن ؤُخدْجضْ إِفسْذنْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","وَارْ فسّْذمْ شَا إِخفْ نْومْ س مَارَّا ثِيمسْڒَايِينْ-أَ، مِينْزِي ڒڭْنُوسْ نِّي إِ غَا سُّوفّْغغْ زَّاثْ إِ ؤُغمْبُوبْ نْومْ، ثُوغَا فسّْذنْ إِخفْ نْسنْ س مَارَّا ثِيمسْڒَايِينْ-أَ. ");
INSERT INTO rifa_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","س ؤُينِّي ثذْوڒْ ثمُّورْثْ ثفْسذْ ؤُشَا نشّْ أَذْ أَسْ خدْجْصغْ ڒْمُوعْصِييّثْ نّسْ، ؤُشَا أَذْ ثْعُوقّْ ثمُّورْثْ إِمزْذَاغْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","مَاشَا كنِّيوْ أَذْ ثحْضَامْ ثِيوصَّا ذ لْفَارَايِيضْ إِنُو، وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْحَاجّثْ زِي مَارَّا جّْعَايفْ-أَ، نِيغْ ونِّي زِي ثَارْوَا ن ثمُّورْثْ ؤُڒَا ذ أَبَارَّانِي نِّي إِزدّْغنْ ذِي ڒْوسْطْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","مِينْزِي إِرْيَازنْ ن ثمُّورْثْ، إِنِّي ثُوغَا قْبڒْ نْومْ، أَقَا ڭِّينْ مَارَّا جّْعَايفْ-أَ ؤُشَا أَمُّو إِ ثذْوڒْ ثمُّورْثْ ثفْسذْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","وَارْ تّجِّي ثَامُّورْثْ أَذْ كنِّيوْ ثْعُوقّْ ؤُمِي ت ثْفسّْذمْ، أَمْ مَامّشْ ثْعُوقّْ ثمُّورْثْ ڒْڭنْسْ نِّي ثُوغَا ذِينْ قْبڒْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","مِينْزِي مَارَّا إِنِّي إِڭِّينْ شَا زِي مَارَّا جّْعَايفْ-أَ، أَقَا ڒعْمُورْ إِ غَا إِڭِّينْ أَمُّو، أَذْ تّْوَاقضْعنْ زِي ڒْڭنْسْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","أَذْ ثحْضَامْ مِينْ ذ أَومْ ؤُمُورغْ، مَاحنْذْ وَارْ ثْضفَّارمْ ثِيوصَّا يُورْصُوضنْ أَمْ مَامّشْ ت ڭِّينْ ڒڭْنُوسْ قْبڒْ نْومْ. وَارْ زَّايْسنْثْ ثْفسّْذمْ إِخفْ نْومْ، نشّْ ذ سِيذِي، أَربِّي نْومْ!‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","إِسِّيوڒْ سِيذِي غَارْ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","”سِيوڒْ أَكْ-ذ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’إِتّْخصَّا أَذْ ثِيڒِيمْ ذ إِمْقدَّاسنْ، مِينْزِي نشّْ ذ سِيذِي، أَربِّي نْومْ، أَقَا أَيِي ذ أَمْقدَّاسْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","كُوڒْ إِجّْ أَذْ إِوقَّارْ يمَّاسْ ذ بَابَاسْ ؤُشَا ؤُسَّانْ إِنُو ن سّبْثْ أَذْ ثنْ ثحْضَامْ، نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","وَارْ دِّيكّْوِيڒمْ غَارْ لْ-أَصْنَامْ ؤُ وَارْ تّڭّمْ إِ يِيخفْ نْومْ ڒخْيَاڒَاثْ إِفسْينْ ذ إِربِّيثنْ. نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","خْمِي غَا ثْقدّْمنْ ثَاغَارْصْثْ ن ڒهْنَا إِ سِيذِي، خنِّي أَذْ ت ثْقدّْممْ س إِجّْ ن وبْرِيذْ إِ زِي غَا ثتّْوَاقبْڒمْ س أَرْضَا. ");
INSERT INTO rifa_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","إِتّْخصَّا أَذْ ثتّْوَاشّْ ذڭْ وَاسّْ ن ثْغَارْصْثْ نْومْ ؤُڒَا ذِي ثِيوشَّا أَوَارْنِي أَسْ. مِينْ إِقِّيمنْ أَڒْ وَاسّْ وِيسّْ ثْڒَاثَا أَذْ إِتّْوَاسّشْمضْ س ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","مَاڒَا ثتّْوَاشّْ عَاذْ ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا، أَذْ ثِيڒِي ذ جّْعِيفشْثْ، وَارْ ثتّْوَاقبّڒْ س أَرْضَا. ");
INSERT INTO rifa_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","وِي زَّايسْ غَا إِشّنْ أَذْ يَارْبُو ڒْمُوعْصِييّثْ نّسْ، مِينْزِي إِسّخْسَارَا مِينْ إِدْجَانْ ذ أَمْقدَّاسْ ن سِيذِي ؤُشَا خنِّي أَذْ إِتّْوَاقسّْ بْنَاذمْ نِّي زِي ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","مَاڒَا ثمْجَارمْ صَّابثْ ن ثمُّورْثْ نْومْ، وَارْ مجَّارْ شكْ إِيَّارْ نّشْ أَڒْ أَغزْذِيسْ أَنڭَّارْ نِيغْ أَذْ ثْجمْعذْ مِينْ إِقِّيمنْ أَوَارْنِي ثَاميْرَا نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","وَارْ ڒقّضْ ؤُضِيڒْ ن ؤُمَارْجعْ نّشْ كُوڒْشِي، وَارْ حْرُووْ مَارَّا مِينْ ذِينْ إِقِّيمنْ ذِي ثمُّورْثْ ذڭْ ؤُمَارْجعْ نّشْ ن ؤُضِيڒْ. أَذْ ثجّذْ أَيَا إِ ؤُمزْڒُوضْ ؤُ إِ ؤُبَارَّانِي، نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","وَارْ تَّاشَارْ ؤُ وَارْ سّْخَارِّيقْ، ؤُڒَا ذ إِجّْ أَذْ إِشْمثْ جَّارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","وَارْ تّْجَادْجَامْ ژُورْ س يِيسمْ إِنُو. وَارْ سّخْسَارَا إِسمْ ن أَربِّي نّشْ. نشّْ ذ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","وَارْ سّْحِيسِّيفْ جَّارْ نّشْ نِيغْ أَذْ ث ثَاشَارذْ. وَارْ تّطّفْ ڒْمُونثْ ن إِشوَّاڒنْ زِي دْجِيڒثْ أَڒْ ثِيوشَّا.    ");
INSERT INTO rifa_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","وَارْ تّكّْوَارْ أَذهْشُورْ ؤُ وَارْ تّڭّْ شَا مِينْ ذِي غَا إِنْقَارضْ ؤُذَارْغَاڒْ، مَاشَا إِتّْخصَّا أَذْ ثڭّْوذذْ أَربِّي، نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","غَارْ وحْكَامْ وَارْ تّْغشِّيمْ. وَارْ سْعِيزِّي أَمزْڒُوضْ ؤُ وَارْ سْعدُّو غَارْ بُو-ثْخُوبَا. إِتّْخصَّا أَذْ ثْحكْمذْ خْ جَّارْ نّشْ س ؤُسڭّذْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","وَارْ ڭُّورْ جَارْ ڒْڭنْسْ نّشْ س ؤُنمّمْ، وَارْ تّْبذِّي خْ إِذَامّنْ ن جَّارْ نّشْ، نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","وَارْ شَارّهْ ؤُمَاشْ ذڭْ وُوڒْ نّشْ. أَذْ ثْعڒْمذْ أَعْڒَامْ إِ جَّارْ نّشْ ؤُ وَارْ ثْكسِّيذْ دّنْبْ خَاكْ زِي سِّيبّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","وَارْ تّنْثِيقِيمْ نِيغْ أَذْ ثْخمّْڒذْ أَنْثَاقمْ خْ ثَارْوَا ن ڒْڭنْسْ نّشْ. أَذْ ثخْسذْ جَّارْ نّشْ أَمشْنَاوْ إِخفْ نّشْ، نشّْ ذ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","أَذْ ثحْضَامْ ثِيوصَّا إِنُو. وَارْ تّْڒقَّامْ شَا ڒبْهِيمثْ نّشْ أَكْ-ذ إِجّْ ن مَارْكَا نّغْنِي. وَارْ زَارّعْ ثْنَاينْ ن مَارْكَاثْ ن زَّارِيعثْ ذڭْ إِيَّارْ نّشْ ؤُ وَارْ يَارّضْ أَرُّوضْ إِتّْوَاڭّنْ س ثْنَاينْ ن مَارْكَاثْ ن ؤُكتَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","مَاڒَا أَرْيَازْ إِطّصْ أَكْ-ذ إِشْثْ ن ثمْغَارْثْ، إِشْثْ ن ثَايَّا إِخْضبْ إِ-ت يِيجّْ ن ورْيَازْ نّغْنِي، مَاشَا وَارْ إِتّْوَاخدْجصْ عَاذْ تَّامَانْ نّسْ ن ؤُفكِّي نِيغْ ثمّوْشْ أَسْ ثْڒلِّي، خنِّي أَذْ يِيڒِي ڒحْسَابْ، مَاشَا وَارْ تّْوَانقّنْ شَا، مِينْزِي نتَّاثْ ثُوغَا عَاذْ وَارْ ثتّْوَاحَارْ شَا. ");
INSERT INTO rifa_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","نتَّا أَذْ يَاوِي ثَاغَارْصْثْ ن ؤُمَارْوَاسْ نّسْ إِ سِيذِي غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، إِجّْ ن إِشَارِّي أَمْ ثْغَارْصْثْ ن ؤُمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","أَكهَّانْ أَذْ خَاسْ إِڭّْ أَصْڒَاحْ س إِشَارِّي ن ثْغَارْصْثْ ن ؤُمَارْوَاسْ زَّاثْ إِ وُوذمْ ن سِيذِي إِ دّنْبْ نّسْ إِ إِڭَّا ؤُشَا دّنْبْ نّسْ إِ إِڭَّا أَذْ أَسْ إِتّْوَاغْفَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","خْمِي غَا ثَاوْضمْ ذِي ثمُّورْثْ ؤُشَا ثژُّومْ عْڒَامْ كُوڒْ ثِيشجُّورَا، مَاحنْذْ أَذْ زَّايْسنْثْ ثشّمْ، خنِّي وَارْ ثْختّْنمْ ’ڒعْذَاڒْيثْ نّسْ‘، ثنِّي ذ ڒْغِيدْجثْ نّسْ. ثْڒَاثَا ن إِسڭّْوُوسَا وَارْ ثنْثْ ثْختّْنمْ، وَارْ زَّايْسنْثْ تّتّمْ شَا. ");
INSERT INTO rifa_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ذڭْ ؤُسڭّْوَاسْ وِيسّْ أَربْعَا أَذْ ثِيڒِي مَارَّا ڒْغِيدْجثْ نّسْ ثْقدّسْ، إِ ؤُسمْغَارْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ذڭْ ؤُسڭّْوَاسْ وِيسّْ خمْسَا أَذْ ثشّمْ ڒْغِيدْجثْ نّسْ ؤُشَا صَّابثْ نّسْ أَذْ ت ثوْشمْ إِ يِيخفْ نْومْ. نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","وَارْ تّتّمْ شَا أَكْ-ذ إِذَامّنْ. وَارْ إِعدّڒْ أَذْ ثْڭزّْنمْ نِيغْ أَذْ ثْشغْڒمْ إِخفْ نْومْ س ثْبزْڭِيوْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","وَارْ تّْحفِّيمْ أَشُوَّافْ ن ؤُزدْجِيفْ نْومْ ذڭْ ونّضْ نّسْ ؤُ وَارْ تّْضيِّيعمْ شَا ثْمَا ن ثْمَارْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","وَارْ إِعدّڒْ أَذْ ثْشَارْضمْ أَرِّيمثْ نْومْ زِي سِّيبّثْ ن يِيجّْ ن ؤُمتِّينْ نِيغْ أَذْ ثَارشْممْ ثِيڭَّازْ ذِي أَرِّيمثْ نْومْ. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","وَارْ سْذدْجِي يدْجِيشْ، أَذْ ت ثَارّذْ ذ ثَامْغَارْثْ ن فَارْقْ-شّْغڒْ، حِيمَا وَارْ ثْوطِّي ثمُّورْثْ ذِي فَارْقْ-شّْغڒْ ؤُشَا خنِّي أَذْ ثشُّورْ ثمُّورْثْ س ڒفْضِيحثْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","أَذْ ثحْضَامْ ؤُسَّانْ إِنُو ن سّبْثْ ؤُشَا أَذْ ثْوقَّارمْ زَّاوشْثْ إِنُو إِقدّْسنْ. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","وَارْ تّْذِيكّْوِيڒمْ غَارْ يِينِّي إِسَّاوَاڒَانْ أَكْ-ذ إِمتَّانْ ؤُ غَارْ إِڭزَّاننْ، وَارْ غَارْسنْ أَرزّْفمْ، حِيمَا أَذْ زَّايْسنْ ثتّْوَاخمْجمْ. نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","أَذْ ثكَّارذْ إِ ونِّي غَارْ إِدْجَا ؤُشُوَّافْ إِشَابْ ؤُشَا أَذْ ثْوقَّارذْ ؤُذمْ ن إِوسُّورَا ؤُشَا أَذْ ثڭّْوذذْ أَربِّي نّشْ. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","خْمِي كِيذكْ غَا إِزْذغْ إِجّْ ن ؤُبَارَّانِي ذِي ثمُّورْثْ نْومْ، وَارْ ث تّْضدْجْممْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","أَبَارَّانِي، ونِّي غَارْومْ إِزدّْغنْ، أَذْ أَومْ يِيڒِي أَمْ يِيجّنْ زِي ثَارْوَا ن ثمُّورْثْ نْومْ. أَذْ ث ثخْسذْ أَمْ يِيخفْ نّشْ، مِينْزِي ثُوغَا كنِّيوْ ذ إِبَارَّانِييّنْ ذِي ثمُّورْثْ ن مِيصْرَا. نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","خْمِي غَا ثِيڒِيمْ غَارْ وحْكَامْ وَارْ تّْغشّمْ شَا س ڒعْبَارْ ن ثُوزّڭَّارْثْ نِيغْ ن دّْقڒْ نِيغْ س ڒعْبَارْ ن مِينْ ذَايسْ. ");
INSERT INTO rifa_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","أَذْ غَارْومْ يِيڒِي ذ إِجّْ ن ڒْمِيزَانْ نِيشَانْ ذ إِژْرَا ن ڒْمِيزَانْ نِيشَانْ ؤُڒَا ذ إِجّْ ن إِفَا نِيشَانْ ذ إِجّْ ن ؤُهِينُو نِيشَانْ، نشّْ ذ سِيذِي، أَربِّي نْومْ، ونِّي كنِّيوْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","أَذْ ثحْضَامْ مَارَّا ثِيوصَّا ذ ڒُومُورْ إِنُو ؤُشَا أَذْ ثنْ ثڭّمْ. نشّْ ذ سِيذِي!‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","”أَذْ ثِينِيذْ إِ أَيْثْ ن إِسْرَائِيل: ’كُوڒْ إِجّنْ زڭْ أَيْثْ ن إِسْرَائِيل نِيغْ زڭْ إِبَارَّانِييّنْ، ونِّي إِ غَا إِوْشِينْ زڭْ إِحنْجِيرنْ نّسْ إِ مُولَاكْ، أَذْ إِتّْوَانغْ نِيشَانْ. ڒْڭنْسْ ن ثمُّورْثْ أَذْ ث يَارْجمْ.    ");
INSERT INTO rifa_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","نشّْ أَذْ قڒْبغْ ؤُذمْ إِنُو خْ ورْيَازْ نِّي ؤُشَا أَذْ ث قضْعغْ زِي ڒْڭنْسْ نّسْ، مِينْزِي نتَّا أَقَا إِوْشَا زِي زَّارِيعثْ نّسْ إِ مُولَاكْ. س ؤُينِّي ثُوغَا إِسّخْمجْ زَّاوشْثْ إِنُو إِقدّْسنْ ؤُشَا إِسّخْسَارْ إِسمْ أَمْقدَّاسْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","مَاڒَا ثَارْوَا ن ثمُّورْثْ قّْننْ ثِيطَّاوِينْ نْسنْ خْ ورْيَازْ نِّي، خْمِي غَا إِوْشْ نتَّا زِي زَّارِيعثْ نّسْ إِ مُولَاكْ، ؤُشَا نِيثْنِي وَارْ ث نقّنْ، ");
INSERT INTO rifa_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","خنِّي نشّْ أَذْ قڒْبغْ ؤُذمْ إِنُو خْ ورْيَازْ نِّي ؤُ خْ ڒَادْجْ نّسْ ؤُشَا أَذْ ث قضْعغْ زِي جَارْ ڒْڭنْسْ نّسْ، نتَّا ذ مَارَّا إِنِّي إِسّفْسَاذنْ إِخفْ نْسنْ أَمْ دّكّْوَاڒنْ أَوَارْنِي أَسْ مَاحنْذْ أَذْ سّْفسْذنْ إِخفْ نْسنْ أَكْ-ذ مُولَاكْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","”بْنَاذمْ نِّي إِ غَا إِقڒْبنْ إِخفْ نّسْ غَارْ يِينِّي إِسَّاوَاڒَانْ أَكْ-ذ إِمتَّانْ ذ إِڭزَّاننْ، مَاحنْذْ أَذْ ذوْڒنْ أَوَارْنِي أَسنْ أَمْ سّْفسْذنْ إِخفْ نْسنْ، نشّْ أَذْ قڒْبغْ ؤُذمْ إِنُو خْ بْنَاذمْ نِّي ؤُشَا أَذْ ث قضْعغْ زِي جَارْ ڒْڭنْسْ نّسْ.“   ");
INSERT INTO rifa_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","”سْقدّْسمْ إِخفْ نْومْ، إِڒِيمْ ذ إِمْقدَّاسنْ، مِينْزِي نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","حْضَامْ ثِيوصَّا إِنُو ؤُشَا ڭّمْ زَّايْسنْثْ. نشّْ ذ سِيذِي، ونِّي كنِّيوْ إِسّْقدّْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","”مَاغَارْ كُوڒْ أَرْيَازْ نِّي إِ غَا إِنعْڒنْ خْ بَابَاسْ نِيغْ خْ يمَّاسْ، أَذْ إِتّْوَانغْ نِيشَانْ. إِنْعڒْ خْ بَابَاسْ نِيغْ خْ يمَّاسْ، إِذَامّنْ نّسْ أَقَا أَثنْ خَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","مَاڒَا إِجّْ ن ورْيَازْ إِزْنَا أَكْ-ذ ثمْغَارْثْ ن ورْيَازْ نّغْنِي، خنِّي ونِّي ثُوغَا إِزنَّانْ أَكْ-ذ ثمْغَارْثْ ن جَّارْ نّسْ أَذْ إِتّْوَانغْ نِيشَانْ، ونِّي إِزْنَانْ ذ ثنِّي إِزْنَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","مَاڒَا إِجّْ ن ورْيَازْ، أَمْ إِطّصْ أَكْ-ذ ثمْغَارْثْ ن بَابَاسْ، أَقَا إِسّْعُورِّي ڒْعَارْ ن بَابَاسْ، خنِّي نِيثْنِي س ثْنَاينْ أَذْ تّْوَانْغنْ نِيشَانْ. إِذَامّنْ نْسنْ أَقَا أَثنْ خَاسنْ.    ");
INSERT INTO rifa_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","مَاڒَا إِجّْ ن ورْيَازْ إِطّصْ أَكْ-ذ ثمْغَارْثْ ن مِّيسْ، خنِّي نِيثْنِي س ثْنَاينْ أَذْ تّْوَانْغنْ نِيشَانْ. أَقَا ڭِّينْ إِجّْ ن ؤُخدْجضْ إِفسْذنْ. إِذَامّنْ نْسنْ أَقَا أَثنْ خَاسنْ.    ");
INSERT INTO rifa_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","مَاڒَا إِجّْ ن ورْيَازْ إِطّصْ أَكْ-ذ إِجّْ ن ورْيَازْ نّغْنِي أَمْ مَامّشْ إِتّطّصْ ورْيَازْ أَكْ-ذ إِشْثْ ن ثمْغَارْثْ، خنِّي أَقَا نِيثْنِي س ثْنَاينْ إِذْسنْ ڭِّينْ إِشْثْ ن ڒفْضِيحثْ ثمْغَارْ. أَذْ تّْوَانْغنْ نِيشَانْ. إِذَامّنْ نْسنْ أَقَا أَثنْ خَاسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","مَاڒَا إِمڒْشْ إِجّْ ن ورْيَازْ شَا ن ثمْغَارْثْ ؤُڒَا ذ يمَّاسْ، أَقَا-ت ذ ڒفْضِيحثْ. أَذْ ث سّْشمْضنْ س ثْمسِّي، نتَّا ذ نِيثنْثِي س ثْنَاينْ، حِيمَا خنِّي وَارْ ثتِّيڒِي عَاذْ ذ ڒفْضِيحثْ ذِي ڒْوسْطْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","مَاڒَا إِجّْ ن ورْيَازْ إِصُّورْ إِخفْ نّسْ أَكْ-ذ إِشْثْ ن ڒبْهِيمثْ، خنِّي إِتّْخصَّا أَذْ إِتّْوَانغْ نِيشَانْ. إِتّْخصَّا عَاوذْ أَذْ ثنْغمْ ڒبْهِيمثْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","مَاڒَا شَا ن ثمْغَارْثْ ثْقَارّبْ-د غَارْ شَا ن ڒبْهِيمثْ مَامّشْ مَا ثڭَّا، مَاحنْذْ أَذْ كِيذسْ ثْفحّڒْ، خنِّي أَذْ ثنْغذْ ثَامْغَارْثْ ذ ڒبْهِيمثْ. أَذْ تّْوَانْغنْ نِيشَانْ. إِذَامّنْ نْسنْ أَقَا أَثنْ خَاسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","مَاڒَا إِجّْ ن ورْيَازْ إِطّفْ ؤُتْشْمَاسْ، يدْجِيسْ ن بَابَاسْ نِيغْ يدْجِيسْ ن يمَّاسْ، ؤُشَا إِژْرَا ڒْعَارْ نّسْ ؤُشَا نتَّاثْ ثژْرَا ڒْعَارْ نّسْ، أَقَا-ت ذ ڒفْضِيحثْ. أَذْ تّْوَانْغنْ س ثْنَاينْ زَّاثْ إِ ثِيطَّاوِينْ ن ثَارْوَا ن ڒْڭنْسْ نْسنْ. أَقَا إِسّْعُورِّي ڒْعَارْ ن ؤُتْشْمَاسْ، أَذْ يَارْبُو ڒْمُوعْصِييّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","مَاڒَا إِجّْ ن ورْيَازْ إِطّصْ أَكْ-ذ إِشْثْ ن ثمْغَارْثْ ثنِّي خْ إِدْجَا إِذَامّنْ ؤُشَا أَقَا إِسّْعُورِّي ڒْعَارْ نّسْ، إِسّْعُورِّي أَنُو ن إِذَامّنْ نّسْ، ؤُشَا نتَّاثْ سِيمَانْثْ نّسْ ثسّْعُورِّي أَنُو ن إِذَامّنْ نّسْ، خنِّي أَذْ تّْوَاقضْعنْ س ثْنَاينْ زِي ڒْوسْطْ ن ڒْڭنْسْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","وَارْ سْعَارِّي شَا ؤُتْشْمَاسْ ن يمَّاشْ نِيغْ ؤُتْشْمَاسْ ن بَابَاشْ، مِينْزِي خنِّي إِسّْفطَّاحْ بْنَاذمْ ڒْعَارْ ن رَادْجْ نّسْ. نِيثْنِي أَذْ أَرْبُونْ ڒْمُوعْصِييّثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","مَاڒَا إِجّْ ن ورْيَازْ، ونِّي إِتّطّْصنْ أَكْ-ذعنْثِيسْ، أَقَا إِسّْعُورِّي ڒْعَارْ نعمِّيسْ، أَذْ أَرْبُونْ نِيثْنِي ڒْمُوعْصِييّثْ نْسنْ. أَذْ مّْثنْ بْڒَا ثَارْوَا.    ");
INSERT INTO rifa_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","مَاڒَا إِجّْ ن ورْيَازْ يِيوِي ثَامْغَارْثْ ن ؤُمَاسْ، أَقَا مَانْ أَيَا ذ أَعذِّي خْ وعْزَاڒْ ن ثمْغَارْثْ. أَقَا إِسّْعُورِّي ڒْعَارْ ن ؤُمَاسْ. أَذْ إِڒِينْ بْڒَا إِحنْجِيرنْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","”حْضَامْ مَارَّا ثِيوصَّا إِنُو ذ مَارَّا لْفَارَايِيضْ إِنُو ؤُشَا ڭّمْ ثنْثْ، مَاحنْذْ وَارْ كنِّيوْ ثتّْعُوقِّي ثمُّورْثْ مَانِي كنِّيوْ إِ غَا نذْهغْ، حِيمَا أَذْ ذَايسْ ثْزذْغمْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","وَارْ ڭُّورمْ خْ ثبْرِيذْثْ ن ثْوصَّا ن ڒْڭنْسْ نِّي غَا سُّوفّْغغْ زَّاثْ إِ وُوذمْ نْومْ، مِينْزِي نِيثْنِي ڭِّينْ مَارَّا ثِيمسْڒَايِينْ-أَ ؤُ س ؤُيَا شَارّْهغْ ثنْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","نشّْ نِّيغْ أَومْ: كنِّيوْ أَذْ ثْوَارْثمْ ثَامُّورْثْ نْسنْ ؤُشَا أَذْ أَومْ ت-إِ-د وْشغْ ذ ڒْوَارْثْ، إِشْثْ ن ثمُّورْثْ إِفيّْضنْ س ؤُغِي ذ ثَامّنْثْ. نشّْ ذ سِيذِي، أَربِّي نْومْ، ونِّي كنِّيوْ إِفَارْزنْ زِي جَارْ ڒڭْنُوسْ. ");
INSERT INTO rifa_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","خْ ؤُيَا كنِّيوْ أَذْ ثْميّْزمْ جَارْ ڒبْهَايمْ ن ڒحْڒَاڒْ ذ يِينِّي إِخمْجنْ ؤُ جَارْ إِجْضَاضْ إِخمْجنْ ذ يِينِّي ن ڒحْڒَاڒْ. وَارْ سّخْسَارَامْ ڒعْمُوڒْ نْومْ أَكْ-ذ شَا ن ڒبْهِيمثْ نِيغْ أَكْ-ذ شَا ن وجْضِيضْ نِيغْ أَكْ-ذ شَا زِي مَارَّا مِينْ إِتّْبُوعنْ خْ ثمُّورْثْ، مَارَّا مِينْ ذ أَومْ حَارّْمغْ، حِيمَا أَذْ ث ثْحسْبمْ ذ ڒخْمجْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","”أَقَا كنِّيوْ أَذْ أَيِي ثِيڒِيمْ ذ إِمْقدَّاسنْ، مِينْزِي نشّْ ذ سِيذِي ذ أَمْقدَّاسْ ؤُشَا نشّْ فَارْزغْ كنِّيوْ زِي ڒڭْنُوسْ، حِيمَا أَذْ ثِيڒِيمْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","مَاڒَا إِجّْ ن ورْيَازْ نِيغْ إِشْثْ ن ثمْغَارْثْ غَارسْ بُوحْبڒْ ن ؤُعزّمْ ن إِمتَّانْ نِيغْ ن ثْڭزَّانْثْ، خنِّي أَذْ تّْوَانْغنْ نِيشَانْ. أَذْ ثنْ أَرجْمنْ. إِذَامّنْ نْسنْ أَقَا أَثنْ خَاسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","إِنَّا سِيذِي إِ مُوسَا: ”سِيوڒْ أَكْ-ذ إِكهَّاننْ، أَرَّاوْ ن هَارُونْ، ؤُشَا إِنِي أَسنْ: ’وَارْ إِعدّڒْ إِ ؤُڒَا ذ إِجّْ زَّايْومْ أَذْ إِسّخْمجْ إِخفْ نّسْ س إِجّْ ن ؤُمتِّينْ جَارْ ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","مْغِيرْ س رَادْجْ نّسْ يُوذْسنْ، س يمَّاسْ نِيغْ س بَابَاسْ نِيغْ س مِّيسْ نِيغْ س يدْجِيسْ نِيغْ س ؤُمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ؤُڒَا س ؤُتْشْمَاسْ نِّي ذ ثَاعْزَارْشْثْ، ثنِّي ذ ڒَادْجْ نّسْ يُوذْسنْ ؤُ وَارْ غَارسْ ثُوغِي ورْيَازْ، أَقَا إِعدّڒْ أَذْ زَّايسْ إِسّخْمجْ إِخفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","بَابْ ن ثَادَّارْثْ وَارْ إِسّْخمَّاجْ إِخفْ نّسْ جَارْ ڒْڭنْسْ نّسْ. س ؤُيَا إِتّْوَافْ إِسّخْسَارْ إِخفْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","”وَارْ تّڭّنْ شَا ن ومْشَانْ إِقُوشَّارْ خْ إِزدْجِيفْ نْسنْ، ؤُ وَارْ تّْحفِّينْ طَّارْفْ ن ثْمَارْثْ نْسنْ ؤُ وَارْ شَارّْضنْ أَشَارّضْ ذڭْ ويْسُومْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","أَذْ إِڒِينْ ذ إِمْقدَّاسنْ إِ أَربِّي نْسنْ ؤُشَا وَارْ فطّْحنْ إِسمْ ن أَربِّي نْسنْ، مِينْزِي أَقَا ذ نِيثْنِي إِ إِتَّاوْينْ ثِيوْهِيبِينْ ن ثْمسِّي غَارْ أَربِّي، ثِينِّي ذ مَاشَّا ن أَربِّي نْسنْ. س ؤُيَا أَذْ إِڒِينْ ذ إِمْقدَّاسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","وَارْ إِعدّڒْ أَذْ أَوْينْ ثَامْغَارْثْ نِّي إِدْجَانْ ذ لْفَاسْذَا نِيغْ إِشْثنْ ثتّْوَاغْصبْ. ؤُڒَا ذ إِشْثْ ن ثمْغَارْثْ نِّي إِتّْوَادْجْفنْ زڭْ ورْيَازْ نّسْ، وَارْ ت تِّيوْينْ، مِينْزِي أَكهَّانْ ذ أَمْقدَّاسْ إِ أَربِّي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","أَذْ ث ثْحسْبذْ ذ أَمْقدَّاسْ، مِينْزِي نتَّا إِتَّاوِي مَاشَّا ن أَربِّي نّشْ. أَذْ يِيڒِي ذ أَمْقدَّاسْ إِ شكْ، مِينْزِي نشّْ ذ أَمْقدَّاسْ، نشّْ ذ سِيذِي ونِّي كنِّيوْ إِسّْقدّْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","”مَاڒَا يدْجِيسْ ن إِجّْ ن ورْيَازْ نِّي إِدْجَانْ ذ أَكهَّانْ ثسّفْضحْ إِخفْ نّسْ س فَارْقْ-شّْغڒْ نّسْ، خنِّي أَقَا ثسّفْضحْ بَابَاسْ ؤُشَا إِتّْخصَّا أَسْ أَذْ ثتّْوَاسّشْمضْ س ثْمسِّي.“ ");
INSERT INTO rifa_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","”أَرَّايْسْ ن إِكهَّاننْ جَارْ أَيْثْمَاسْ، ونِّي خْ ؤُزدْجِيفْ نّسْ ثتّْوَافَارّغْ زّشْثْ ن وذْهَانْ ؤُ ونِّي إِتّْوَاڒقّْمنْ، مَاحنْذْ أَذْ يَارْضْ أَرُّوضْ ن ؤُكهَّانْ، نتَّا وَارْ إِزمَّارْ أَذْ إِضْڒقْ إِ ؤُشُوَّافْ خْ ؤُزدْجِيفْ نّسْ نِيغْ أَذْ إِشَارّڭْ أَرُّوضْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","وَارْ إِعدّڒْ أَذْ د-إِقَارّبْ غَارْ إِجّْ ن ؤُمتِّينْ، عَاذْ س بَابَاسْ ذ يمَّاسْ وَارْ إِعدّڒْ أَذْ إِسّخْمجْ إِخفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","وَارْ إِتّفّغْ زِي زَّاوشْثْ إِقدّْسنْ، حِيمَا وَارْ إِسّخْسَارَا زَّاوشْثْ إِقدّْسنْ ن أَربِّي، مِينْزِي تَّاجْ ن وعْزَاڒْ ن زّشْثْ ن وذْهَانْ ن أَربِّي نّسْ أَقَا-ث خَاسْ. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","أَذْ يَاوِي إِشْثْ ن ثعْزَارشْثْ ذ ثَامْغَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","وَارْ إِتِّيوِي ثَاجَّاتْشْ نِيغْ ثَاندْجَافْثْ نِيغْ ثنِّي إِتّْوَاغصْبنْ ذ ثَامْغَارْثْ، مَاشَا أَذْ يَاوِي إِشْثْ ن ثعْزَارشْثْ زِي ڒْڭنْسْ نّسْ ذ ثَامْغَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","وَارْ إِسّخْسَارَا زَّارِيعثْ نّسْ جَارْ ڒْڭنْسْ نّسْ، مِينْزِي نشّْ ذ سِيذِي، ونِّي ث إِسّْقدّْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","”سِيوڒْ أَكْ-ذ هَارُونْ، إِنِي: ’ؤُڒَا ذ إِجّْ زِي زَّارِيعثْ نّشْ ذِي مَارَّا جِّيڒَاثْ نْسنْ إِ ذِي إِدْجَا شَا ن ؤُنعْضَابْ، أَذْ د-إِقَارّبْ، حِيمَا أَذْ يَاوِي مَاشَّا ن ثوْهِيبْثْ ن أَربِّي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","مِينْزِي ؤُڒَا ذ إِجّْ ن ورْيَازْ وَارْ د-إِتّْقَارِّيبْ شَا س يِيجّْ ن ڒْعِيبْ، مَا ذ أَذَارْغَاڒْ إِ إِدْجَا نِيغْ ذ أَقِيذَارْ نِيغْ س شَا وَارْ إِحْڒِي نِيغْ غَارسْ صِّيفثْ ثْفَارْغْ ");
INSERT INTO rifa_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","نِيغْ إِجّْ ن ورْيَازْ يَارْژْ أَسْ ؤُضَارْ نِيغْ أَفُوسْ ");
INSERT INTO rifa_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","نِيغْ بُو-ثعْرُورْثْ نِيغْ حذْ يَاڒْوسْ ذِي شَا ن يِيجّْ ن تّجَّاڒْ نِيغْ س إِشْثْ ن ثِيطّْ ثُوفّْ نِيغْ س جْذَامْ نِيغْ س إِشْثْ ن شَّامثْ ثخْسَارْ نِيغْ س إِقدْجَاڒنْ إِذْڭذْڭنْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","وَارْ إِعدّڒْ إِ ؤُڒَا ذ إِجّْ ن ورْيَازْ زِي زَّارِيعثْ ن ؤُكهَّانْ هَارُونْ، ونِّي ذِي إِدْجَا شَا ن ڒْعِيبْ، أَذْ إِرحّڭْ، مَاحنْذْ أَذْ إِقدّمْ ثِيوْهِيبِينْ ن ثْمسِّي ن سِيذِي. أَقَا ذَايسْ أَنعْضَابْ، وَارْ إِزمَّارْ أَذْ إِفّغْ مَاحنْذْ أَذْ إِقدّمْ مَاشَّا ن ثوْهِيبْثْ ن أَربِّي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","زِي مَاشَّا ن ثوْهِيبْثْ ن أَربِّي نّسْ إِعدّڒْ أَذْ زَّايسْ يشّْ، أَمْ زِي مِينْ إِدْجَانْ إِقدّْسنْ قَاعْ أَمْ زِي مِينْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","مَاشَا وَارْ إِعدّڒْ أَذْ د-إِقَارّبْ غَارْ ؤُڒحَّافْ ؤُڒَا غَارْ ؤُعَالْطَارْ، مِينْزِي ذَايسْ إِشْثْ ن ؤُنعْضَابْ، حِيمَا وَارْ إِسّخْسَارَا ثِيزَاوِييِّينْ إِقدّْسنْ إِنُو، مِينْزِي نشّْ ذ سِيذِي ونِّي ثنْ إِسّْقدّْسنْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","أَمُّو إِ إِسِّيوڒْ مُوسَا أَكْ-ذ هَارُونْ ؤُ أَكْ-ذ وَارَّاوْ نّسْ ؤُ أَكْ-ذ مَارَّا أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","”سِيوڒْ أَكْ-ذ هَارُونْ ؤُ أَكْ-ذ وَارَّاوْ نّسْ، مَاحنْذْ، مَاڒَا إِتّْخصَّا، وَارْ تَّاكّْوَاضنْ غَارْ ثوْهِيبِينْ إِقدّْسنْ ن أَيْثْ ن إِسْرَائِيل ثِينِّي ذ أَيِي سّْقدّْسنْ، حِيمَا وَارْ سّخْسَارَانْ إِسمْ أَمْقدَّاسْ إِنُو. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","إِنِي أَسنْ: ’مَارَّا أَرْيَازْ زِي زَّارِيعثْ نْومْ ذِي مَارَّا جِّيڒَاثْ نْومْ، ونِّي د غَا إِقَارّْبنْ غَارْ ثوْهِيبِينْ إِقدّْسنْ، ثِينِّي سّْقدّْسنْ أَيْثْ ن إِسْرَائِيل إِ سِيذِي، أَمْ إِخْمجْ نتَّا، أَقَا أَذْ إِتّْوَاقسّْ ڒعْمَارْ نِّي زِي زَّاثْ إِ وُوذمْ إِنُو. نشّْ ذ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ؤُڒَا ذ إِجّنْ زِي زَّارِيعثْ ن هَارُونْ نِّي ذِي إِدْجَا ڒْبَارْصْ نِيغْ ونِّي غَارْ إِدْجَا ؤُسيّڒْ، وَارْ إِتّتّْ زِي ثوْهِيبِينْ إِقدّْسنْ أَڒْ غَا يِيڒِي إِزْذِيڭْ. ونِّي إِحَاذَانْ شَا زِي مِينْ إِتّْوَاسّْخمْجنْ س إِجّْ ن ؤُمتِّينْ نِيغْ س إِجّْ ن ورْيَازْ نِّي ثُوغَا س ؤُسيّڒْ ن وَادْجُو، ");
INSERT INTO rifa_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","نِيغْ س إِجّْ ن ورْيَازْ نِّي إِحَاذَانْ شَا مِينْ إِتّْبُوعنْ إِ زِي إِذْوڒْ إِخْمجْ، نِيغْ إِحَاذَا إِجّْ ن بْنَاذمْ إِ زِي إِذْوڒْ إِخْمجْ س مَامّشْ مَا ثڭَّا ثخْمُوجِي نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ڒعْمَارْ نِّي إِحَاذَانْ ثْمسْڒَاشْثْ نِيغْ بْنَاذمْ نِّي أَذْ يِيڒِي إِخْمجْ أَڒْ ثَامذِّيثْ، وَارْ إِتّتّْ زِي ثوْهِيبِينْ إِقدّْسنْ، مْغِيرْ أَوَارْنِي إِ غَا إِسِّيرْذْ أَرِّيمثْ نّسْ س وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","خْمِي د غَا ثغْڒِي ثْفُوشْثْ، أَذْ يِيڒِي إِزْذِيڭْ. أَوَارْنِي أَيَا أَذْ يشّْ زِي ثوْهِيبِينْ إِقدّْسنْ، مِينْزِي أَقَا أَثنْثْ ذ مَاشَّا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","وَارْ إِتّتّْ زڭْ إِشْثْ ن ڒْخشْبثْ نِيغْ زڭْ إِجّْ ن ؤُمُودَّارْ إِمزّْقنْ، مِينْزِي زَّايسْ إِ غَا إِسّخْمجْ إِخفْ نّسْ، نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","أَذْ حْضَانْ مِينْ خفْ ثنْ وصِّيغْ، حِيمَا وَارْ سَّاربُّونْ خْ يِيخفْ نْسنْ دّنْبْ ؤُ خنِّي أَذْ زَّايسْ مّْثنْ، خْمِي غَا سّْعِيدْجْثنْ أَيَا. نشّْ ذ سِيذِي ونِّي ثنْ إِسّْقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ؤُڒَا ذ إِجّْ ن ؤُبَارَّانِي وَارْ إِتّتّْ زِي ثوْهِيبْثْ إِقدّْسنْ. أَمْعزّبْ إِ إِزدّْغنْ جَارْ إِكهَّاننْ ؤُڒَا ذ أَشوَّاڒْ وَارْ تّتّنْ زِي ثوْهِيبْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","مَاشَا مَاڒَا أَكهَّانْ إِسْغَا إِجّْ ن بْنَاذمْ س نُّوقَارْثْ نّسْ، أَقَا إِعدّڒْ إِ وَا مَاحنْذْ أَذْ يشّْ زِي مَاشَّا ن ثوْهِيبْثْ نّسْ، ؤُڒَا إِ يِينِّي د-إِتّْوَاخڒْقنْ ذِي ثَادَّارْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","مَاڒَا يدْجِيسْ ن ؤُكهَّانْ ثذْوڒْ ذ ثَامْغَارْثْ ن إِجّْ ن ؤُبَارَّانِي، وَارْ ثتّتّْ شَا زِي ثوْهِيبْثْ إِ د-إِتّْوَاسّْڭعّْذنْ زِي ثوْهِيبِينْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","مَاشَا مَاڒَا يدْجِيسْ ن ؤُكهَّانْ أَقَا-ت ذ ثَاجَّاتْشْ نِيغْ ثتّْوَادْجفْ زڭْ ورْيَازْ نّسْ ؤُشَا وَارْ غَارسْ أَحنْجِيرْ ؤُشَا ثذْوڒْ-د غَارْ ثَادَّارْثْ ن بَابَاسْ، أَمْ ذِي ثمْژِي نّسْ، خنِّي أَذْ ثشّْ زِي مَاشَّا ن ثوْهِيبْثْ ن بَابَاسْ، مَاشَا ؤُڒَا ذ إِجّْ ن ؤُبَارَّانِي أَذْ زَّايسْ يشّْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","مَاڒَا شَا ن يِيجّنْ إِشَّا زِي ثوْهِيبْثْ إِقدّْسنْ س ؤُودَّارْ، خنِّي أَذْ غَارسْ يَارْنِي ثَاسْغَارْثْ ن ثخْمُوسشْثْ ؤُشَا أَذْ يَارّْ ثَاوْهِيبْثْ إِقدّْسنْ غَارْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","وَارْ إِعدّڒْ أَذْ سّخْسَارنْ ثِيوْهِيبِينْ إِقدّْسنْ ن أَيْثْ ن إِسْرَائِيل، ثِينِّي سّْڭعّْذنْ نِيثْنِي غَارْ سِيذِي، ");
INSERT INTO rifa_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","أَڒَامِي إِ غَا سَّارْبُونْ أَمَارْوَاسْ ن ڒْمُوعْصِييّثْ خْ أَيْثْ ن إِسْرَايِيلْ، ؤُمِي غَا شّنْ نِيثْنِي زِي ثوْهِيبِينْ نْسنْ إِقدّْسنْ إِ ذ يَاوْينْ نِيثْنِي س يِيخفْ نْسنْ، مِينْزِي نشّْ ذ سِيذِي، ونِّي ثنْ إِسّْقدّْسنْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","”سِيوڒْ أَكْ-ذ هَارُونْ ذ وَارَّاوْ نّسْ ؤُ أَكْ-ذ مَارَّا أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’ذ مَانْ أَيَا إِڭُّورْ إِ كُوڒْ إِجّنْ زِي ثَادَّارْثْ ن إِسْرَائِيل ؤُ إِ إِبَارَّانِييّنْ ذِي إِسْرَائِيل، ونِّي إِ غَا يِيوْينْ ثَاوْهِيبْثْ نّسْ ثنِّي د-يُوسِينْ أَكْ-ذ مَارَّا ڒوْعُوذْ نْسنْ ذ مَارَّا ثِيوْهِيبِينْ نْسنْ نِّي وْشِينْ س ڒْخَاضَارْ، ثنِّي قدّْمنْ نِيثْنِي ذ ثَاغَارْصْثْ ن وشْمَاضْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","مَاحنْذْ أَذْ كنِّيوْ يَارّْ أَذْ ثِيڒِيمْ ثتّْوَاقبّْڒمْ إِتّْخصَّا أَذْ ثِيڒِي ثوْهِيبْثْ ذ إِجّْ ن ووْثمْ إِشْنَانْ قَاعْ زڭْ إِفُونَاسنْ نِيغْ زڭْ إِزْمَارنْ نِيغْ زڭْ إِشَارِّييّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","وَارْ إِعدّڒْ أَذْ ثْقدّْممْ شَا ن ڒْمَاڒْ ذَايسْ أَنعْضَابْ، مِينْزِي أَيَا وَارْ كنِّيوْ د-إِتَّارِّي أَذْ ذَايْومْ إِتّْوَافْ أَرْضَا. ");
INSERT INTO rifa_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","مَاڒَا إِجّْ ن ورْيَازْ إِقدّمْ إِشْثْ ن ثْغَارْصْثْ ن ڒهْنَا غَارْ سِيذِي، مَاحنْذْ أَذْ إِكمّڒْ إِجّْ ن لْوَاعْذْ نِيغْ أَمْ يِيشْثْ ن ثوْهِيبْثْ س ڒْخَاضَارْ، خنِّي أَذْ ثِيڒِي ثَاغَارْصْثْ ذ إِجّْ ن ؤُمُودَّارْ إِشْنَانْ قَاعْ زِي ڒبْهَايمْ نِيغْ زڭْ وُودْجِي، حِيمَا أَذْ ذَايسْ إِتّْوَافْ أَرْضَا. وَارْ إِعدّڒْ أَذْ ذَايسْ يِيڒِي ؤُڒَا ذ إِجّْ ن ڒْعِيبْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","مِينْ إِدْجَانْ ذ أَذَارْغَاڒْ نِيغْ مِينْ إِتّْوَارْژنْ نِيغْ مِينْ ذِي إِدْجَانْ إِجّْ ن ؤُيزِّيمْ يَارزْمنْ نِيغْ مِينْ ذِي دْجَانْثْ ثْفِيضْڒِيوِينْ نِيغْ جْذَامْ نِيغْ شَّامثْ ثخْسَارْ وَارْ ث-إِ-د-ثسّْقَارَّابمْ شَا غَارْ سِيذِي ؤُشَا وَارْ زَّايسْ تِّيوْيمْ ثَاوْهِيبْثْ ن ثْمسِّي إِ سِيذِي خْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","مَاشَا إِجّْ ن ؤُفُونَاسْ نِيغْ إِجّنْ زڭْ وُودْجِي إِ إِقبْحنْ زِي سِّيبّثْ ن ثُوزّڭَّارْثْ نِيغْ ثُوقُوضضْثْ أَطَّاسْ، إِعدّڒْ أَذْ ث-إِ-د-ثسّْوجْذذْ أَمْ يِيشْثْ ن ثوْهِيبْثْ س ڒْخَاضَارْ، مَاشَا وَارْ ذَايسْ إِتّْوَافْ أَرْضَا إِ يِيجّْ ن لْوَاعْذْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","مِينْ إِذْڭدّْڭنْ، مِينْ إِڒبْزنْ، مِينْ إِمزّْقنْ، مِينْ إِتّْوَاقسّنْ وَارْ ث تِّيوْيمْ غَارْ سِيذِي، وَارْ تّڭّمْ أَيَا ذِي ثمُّورْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","زڭْ ؤُفُوسْ ن مِّيسْ ن ؤُبَارَّانِي وَارْ تّْقدَّاممْ شَا زِي مَارَّا مَانْ أَيَا ؤُڒَا ذ إِشْثْ ن ثوْهِيبْثْ ذ مَاشَّا إِ أَربِّي، مِينْزِي ذَايسْ ڒْغشّْ نْسنْ ؤُڒَا ذ نّقْصَانْ نّسْ، مَانْ أَيَا وَارْ إِتّْوَاقبِّيڒْ شَا ذِي طّْوعْ نْومْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","”خْمِي د-إِخدْجقْ ؤُفُونَاسْ نِيغْ إِزْمَارْ نِيغْ إِغَايْضْ، خنِّي أَذْ يِيڒِي سَاذُو حطُّو ن يمَّاسْ سبْعَا ن وُوسَّانْ. زڭْ وَاسّْ وِيسّْ ثْمنْيَا ؤُ أَوَارْنِي أَسْ أَذْ إِصْڒحْ إِ يَارْضَا أَمْ ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","وَارْ إِعدّڒْ أَذْ ثْغَارْصذْ إِ ؤُفُونَاسْ نِيغْ إِ يِيجّنْ زڭْ وُودْجِي أَكْ-ذ مِّيسْ ذڭْ وَاسّْ ذ إِجّْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","خْ مِينِّي ثخْسمْ أَذْ ثْقدّْممْ ثَاوْهِيبْثْ ن ؤُقَاذِي إِ سِيذِي، قدّمْ خنِّي مِينْ إِصڒْحنْ إِ يَارْضَا نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","أَذْ ثتّْوَاشّْ ذڭْ وَاسّْ نِّي نِّيثْ. وَارْ زَّايسْ تّجِّيمْ شَا أَڒْ صّْبحْ. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","أَذْ ثحْضَامْ ثِيوصَّا إِنُو ؤُشَا أَذْ زَّايْسنْثْ ثڭّمْ. نشّْ ذ سِيذِي! ");
INSERT INTO rifa_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","وَارْ سّخْسَارَامْ إِسمْ إِنُو إِقدّْسنْ، حِيمَا نشّْ أَذْ تّْوَاقدّْسغْ ذِي ڒْوسْثْ ن أَيْثْ ن إِسْرَائِيل. نشّْ ذ سِيذِي، ونِّي كنِّيوْ إِسّْقدّْسنْ، ");
INSERT INTO rifa_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ذ ونِّي كنِّيوْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، حِيمَا أَذْ إِڒِيغْ ذ أَربِّي إِ كنِّيوْ. نشّْ ذ سِيذِي!‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’ڒعْيُوذَاثْ إِتّْوَاڭّنْ ن سِيذِي، إِنِّي خْ غَا ثْبَارّْحمْ، أَذْ إِڒِينْ ذ إِمُونِيثنْ إِقدّْسنْ، أَقَا أَثنْثْ ذ ڒعْيُوذَاثْ إِنُو إِتّْوَاڭّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ستَّا ن وُوسَّانْ أَذْ ثْخذْممْ، مَاشَا ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ يِيڒِي ذ سّبْثْ، أَرَّاحثْ إِمُونْ، إِجّْ ن ؤُمُونِي إِقدّْسنْ. إِتّْخصَّا وَارْ ذَايسْ ثْخدّْممْ. أَقَا ذ سّبْثْ إِ سِيذِي ذِي مَارَّا ثِيزذِّيغِينْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","أَقَا ذ إِنَا ذ ڒعْيُوذَاثْ إِتّْوَاڭّنْ ن سِيذِي، إِمُونِيثنْ إِقدّْسنْ، إِنِّي إِ غَا ثْبَارّْحمْ ذڭْ وُوسَّانْ نْسنْ إِتّْوَاڭّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ذڭْ ؤُيُورْ أَمزْوَارُو، ذڭْ وَاسّْ وِيسّْ أَرْبعْطَاشْ ن ؤُيُورْ، جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ، أَذْ ثِيڒِي ذ ثْغَارْصْثْ ن ؤُسعْذُو ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ذڭْ وَاسّْ وِيسّْ خمّسْطَاشْ ن ؤُيُورْ نِّيثْ، أَذْ يِيڒِي ذ ڒْْعِيذْ ن وغْرُومْ بْڒَا أَنْثُونْ إِ سِيذِي. سبْعَا ن وُوسَّانْ أَذْ ثشّمْ أَغْرُومْ بْڒَا أَنْثُونْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","أَسّْ أَمزْوَارْ أَذْ ثڭّمْ إِجّْ ن ؤُمُونِي إِقدّْسنْ. وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ إِ إِتّْخصَّانْ أَذْ ثتّْوَاڭّْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","سبْعَا ن وُوسَّانْ كمّْڒنْ أَذْ ثَاوْيمْ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي ؤُشَا ذڭْ وَاسّْ وِيسّْ سبْعَا أَذْ ذِينْ يِيڒِي إِجّْ ن ؤُمُونِي إِقدّْسنْ. وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ إِ إِتّْخصَّانْ أَذْ ثتّْوَاڭّْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي أَسنْ: ’مَاڒَا ثِيوْضمْ غَارْ ثمُّورْثْ نِّي ذ أَومْ غَا وْشغْ ؤُشَا أَذْ ثمْجَارمْ صَّابثْ نّسْ، خنِّي أَذْ ثَاوْيمْ إِشْثْ ن ثْقبِّيضْثْ زِي ثْمزْوَارُوثْ ن صَّابثْ نْومْ غَارْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ؤُشَا نتَّا أَذْ إِسّنْهزّْ ثَاقبِّيضْثْ نِّي زِي سَّا غَارْ ذَا زَّاثْ إِ وُوذمْ ن سِيذِي، مَاحنْذْ أَذْ ثتّْوَاقبْڒمْ س أَرْضَا. ذِي ثُوفُّوثْ أَوَارْنِي سّبْثْ أَذْ ت إِسّنْهزّْ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ذڭْ وَاسّْ مِينْ ذِي إِ غَا ثنْهزّمْ ثَاقبِّيضْثْ، أَذْ ثسّْوجْذمْ عَاوذْ إِجّْ ن إِزْمَارْ إِشْنَانْ قَاعْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ يِيشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","أَذْ ثِيڒِي ثوْهِيبْثْ ن ڒْغِيدْجثْ زِي ثْنَاينْ ن ثعْشُورَايْ ن إِجّْ ن إِفَا ن وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ، أَقَا-ت ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي س إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي، ؤُ ثَاوْهِيبْثْ نّسْ ن ؤُسيّبْ أَذْ ثِيڒِي ذ بِينُو، إِجّْ ن أَرْبعْ زڭْ إِجّْ ن ؤُهِينُو. ");
INSERT INTO rifa_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","وَارْ تّتّمْ أَغْرُومْ ؤُڒَا ذ ثِيذْرِينْ يُورْفنْ نِيغْ ثِيزِيزَاوِينْ أَڒْ أَسّْ مِينْ ذِي د-ثِيوْيمْ ثَاوْهِيبْثْ نْومْ غَارْ أَربِّي. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ مَانِي مَا ثْزدّْغمْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","أَوَارْنِي أَسْ أَذْ ثْحسْبمْ س ڒْمقْڒُوبْ إِ يِيخفْ نْومْ زِي صّْبحْ أَوَارْنِي إِ سّبْثْ، زڭْ وَاسّْ مِينْ ذِي د-ثِيوْيمْ ثَاقبِّيضْثْ ن ثوْهِيبْثْ ن ونْهزِّي: إِتّْخصَّا أَذْ إِڒِينْ سبْعَا ن وُوسَّانْ ن سّبْثْ كمّْڒنْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","أَذْ ثْحسّْبمْ خمْسِينْ ن وُوسَّانْ أَڒْ ثُوفُّوثْ ن سّبْثْ وِيسّْ سبْعَا. خنِّي أَذْ ثَاوْيمْ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ ن جْذِيذْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","أَذْ د-ثَاوْيمْ ثْنَاينْ ن ثشْنِيفِينْ ن وغْرُومْ إِ ونْهزِّي زڭْ إِمُوشَانْ مَانِي ثْزدّْغمْ. أَذْ إِڒِينْثْ زِي ثْنَاينْ ن ثعْشُورَايْ ن يِيجّْ ن إِفَا ن وَارنْ أَزْذَاذْ، ڭّْوِينْثْ س ونْثُونْ. أَقَا أَثنْثْ ذ ثِيمنْزَا إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","كنِّيوْ أَذْ د-ثسّْقَارّْبمْ أَكْ-ذ وغْرُومْ عَاوذْ سبْعَا ن إِزْمَارنْ شْنَانْ قَاعْ ن إِجّْ ن ؤُسڭّْوَاسْ ذ إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - ذ ثْنَاينْ ن إِشَارِّييّنْ. أَذْ إِڒِينْ إِ ثْغَارْصْثْ ن وشْمَاضْ إِ سِيذِي أَكْ-ذ ثوْهِيبْثْ نْسنْ ن ڒْغِيدْجثْ ذ ثوْهِيبِينْ نْسنْ ن ؤُسيّبْ، أَقَا ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي س إِشْثْ ن ڒفْوَاحثْ إِتّْفُوحنْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","أَذْ ثسّْوجْذمْ عَاوذْ إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ ذ ثَاغَارْصْثْ ن دّنْبْ ؤُ ثْنَاينْ ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ ذ ثْغَارْصْثْ نْ ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","أَذْ ثنْ إِسّنْهزّْ ؤُكهَّانْ أَكْ-ذ وغْرُومْ ن ثَامنْزُوثْ زِي سَّا غَارْ ذَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي، ؤُڒَا ذ ثْنَاينْ ن إِزْمَارنْ. أَذْ إِڒِينْ قدّْسنْ إِ سِيذِي، إِ ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ذڭْ وَاسّْ نِّيثْ أَذْ ثْبَارّْحمْ إِ يِيجّْ ن ؤُمُونِي إِقدّْسنْ. وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ إِ إِتّْخصَّانْ أَذْ ثتّْوَاڭّْ. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا مَانِي مَا إِ غَا ثْزذْغمْ إِ مَارَّا جِّيڒَاثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","خْمِي غَا ثمْجَارمْ ڒْغِيدْجثْ ن ثمُّورْثْ نْومْ، وَارْ مجَّارْ أَڒْ أَنڭَّارْ ن طَّارْفْ ن ييَّارْ نّشْ، ؤُ مِينْ إِقِّيمنْ ن ڒْغِيدْجثْ نّشْ وَارْ ث ثْكسّذْ شَا. إِتّْخصَّا أَذْ ثجّمْ شْوَايْثْ إِ ؤُمزْڒُوضْ ؤُ إِ ؤُبَارَّانِي. نشّْ ذ سِيذِي، أَربِّي نْومْ!‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنِي أَسنْ: ’ذڭْ ؤُيُورْ وِيسّْ سبْعَا، ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ، أَذْ يِيڒِي ذ سّبْثْ إِ كنِّيوْ، إِجّْ ن وَاسّْ ن ڒِيذَارثْ أَكْ-ذ ؤُسُوضِي س وسْرُودّحْ ذڭْ ؤُيِيشّْ ن إِشَارِّي، إِجّْ ن ؤُمُونِي إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ إِ إِتّْخصَّانْ أَذْ ثتّْوَاڭّْ. أَذْ د-ثسْقَارّْبمْ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","”ذڭْ وَاسّْ وِيسّْعشْرَا ن ؤُيُورْ وِيسّْ سبْعَا أَذْ يِيڒِي ذ أَسّْ ن وصْڒَاحْ. أَذْ ثڭّمْ إِجّْ ن ؤُمُونِي إِقدّْسنْ إِ كنِّيوْ. أَذْ ثسّْوَاضْعمْ إِخفْ نْومْ ؤُشَا أَذْ ثْقدّْممْ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ ذڭْ وَاسّْ نِّي نِّيثْ، مِينْزِي أَقَا-ث ذ أَسّْ ن وصْڒَاحْ، مَاحنْذْ أَذْ إِتّْوَاڭّْ وصْڒَاحْ إِ كنِّيوْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَربِّي نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","مِينْزِي مَارَّا بْنَاذمْ نِّي وَارْ إِسّْوَاضْعنْ إِخفْ نّسْ ذڭْ وَاسّْ نِّي نِّيثْ، أَذْ إِتّْوَاقسّْ زِي ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","كُوڒْ بْنَاذمْ نِّي إِ غَا إِڭِّينْ شَا ن ڒْخذْمثْ ذڭْ وَاسّْ نِّي نِّيثْ، نشّْ أَذْ ثحِّيغْ بْنَاذمْ نِّي زِي ڒْوسْطْ ن ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ نْ ڒْخذْمثْ. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ مَانِي مَا إِ غَا ثْزذْغمْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","أَذْ يِيڒِي ذ إِجّْ ن سّبْثْ ن أَرَّاحثْ ثْمُونْ إِ كنِّيوْ. أَذْ إِڒِينْ ڒعْمُورْ نْومْ حْصَارنْ. ذڭْ وَاسّْ وِيسّْ ثسْعَا ن ؤُيُورْ، ذِي دْجِيڒثْ، زڭْ ؤُعشِّي غَارْ ؤُعشِّي نّغْنِي أَذْ ثحْضَامْ أَرَّاحثْ نْومْ ن سّبْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي: ’ذڭْ وَاسّْ وِيسّْ خمّسْطَاشْ ن ؤُيُورْ وِيسّْ سبْعَا أَذْ يِيڒِي ذ ڒْْعِيذْ ن إِعُوشُّوثنْ إِ سِيذِي، سبْعَا ن وُوسَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ذڭْ وَاسّْ أَمزْوَارُو أَذْ يِيڒِي يِيجّْ ن ؤُمُونِي إِقدّْسنْ. وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ ن ڒْخذْمثْ إِ إِتّْخصَّانْ أَذْ ثتّْوَاڭّْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","سبْعَا ن وُوسَّانْ أَذْ ثْقدّْممْ ثِيوْهِيبِينْ ن ثْمسِّي غَارْ سِيذِي. ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ ذِينْ يِيڒِي يِيجّْ ن ؤُمُونِي إِقدّْسنْ ؤُشَا أَذْ ثَاوْيمْ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. أَقَا ذ إِجّْ ن ؤُمُونِي إِفَارْزنْ ذ أَمْقدّسْ، وَارْ تّڭّمْ ؤُڒَا ذ إِشْثْ نْ ڒْخذْمثْ إِ إِتّْخصَّانْ أَذْ ثتّْوَاڭّْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ثِينَا ذ ڒعْيُوذَاثْ إِتّْوَاڭّنْ ن سِيذِي، ثِينِّي زِي غَا ثْبَارّْحمْ ذ إِمُونِيثنْ إِقدّْسنْ، مَاحنْذْ أَذْ ثْقدّْممْ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي غَارْ سِيذِي، إِشْثْ ن ثْغَارْصْثْ ن وشْمَاضْ ذ إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ، إِشْثْ ن ثوْهِيبْثْ إِ ثْغَارْصْثْ ذ ثوْهِيبِينْ ن ؤُسيّبْ، كُوڒْ أَسّْ مِينْ إِتّْوَاڭّنْ إِ وَاسّْ نِّي، ");
INSERT INTO rifa_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","بَارَّا إِ ثْغَارْصَا نْومْ ن وُوسَّانْ ن سّبْثْ ن سِيذِي ذ ثوْهِيبِينْ نْومْ ن لْوُوعُوذْ نْومْ ذ ثوْهِيبِينْ نْومْ س ڒْخَاضَارْ، إِنِّي ثتّْنُوممْ أَذْ ثنْثْ ثوْشمْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","مَاشَا ذڭْ وَاسّْ وِيسّْ خمّسْطَاشْ ن ؤُيُورْ وِيسّْ سبْعَا، خْمِي غَا ثسّْمُونمْ ڒْغِيدْجثْ ن ثمُّورْثْ، خنِّي أَذْ ثْعيّْذمْ ڒْعِيذْ ن سِيذِي، سبْعَا ن وُوسَّانْ. ذڭْ وَاسّْ أَمزْوَارُو أَذْ يِيڒِي يِيجّْ ن وَاسّْ ن سّبْثْ ؤُڒَا ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ ذِينْ يِيڒِي يِيجّْ ن وَاسّْ ن سّبْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ذڭْ وَاسّْ أَمزْوَارُو أَذْ ثكْسِيمْ ڒْغِيدْجثْ ن ثْشجُّورَا إِشوَّارنْ: ثِيسضْوِينْ ن ثِينِي ذ ثِيسضْوِينْ ن ثْشجُّورَا س ثفْرَايْ أَطَّاسْ ذ ثْسضْوِينْ ن ثْشجَّارْثْ ن ثْنمْڒَاتْشْ ن ثْغزْرَاثِينْ. سبْعَا ن وُوسَّانْ أَذْ ثْفَارْحمْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَربِّي نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","أَذْ ثْعيّْذمْ ڒْعِيذْ ن إِعُوشُّوثنْ سبْعَا ن وُوسَّانْ ذڭْ ؤُسڭّْوَاسْ إِ سِيذِي. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ. أَذْ ث ثْعيّْذمْ ذڭْ ؤُيُورْ وِيسّْ سبْعَا. ");
INSERT INTO rifa_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","أَذْ ثْزذْغمْ سبْعَا ن وُوسَّانْ ذڭْ إِعُوشُّوثنْ. مَارَّا إِنِّي د-إِتّْوَاخڒْقنْ ذِي إِسْرَائِيل أَذْ زذْغنْ ذڭْ إِعُوشُّوثنْ، ");
INSERT INTO rifa_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","حِيمَا أَذْ سّْننْ مَارَّا جِّيڒَاثْ نْومْ، بلِّي نشّْ ڭِّيغْ أَذْ زذْغنْ أَيْثْ ن إِسْرَائِيل ذڭْ إِعُوشُّوثنْ، ؤُمِي ثنْ سُّوفّْغغْ زِي ثمُّورْثْ ن مِيصْرَا. نشّْ ذ سِيذِي، أَربِّي نْومْ!‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","أَمُّو إِ إِسِّيوڒْ مُوسَا أَكْ-ذ أَيْثْ ن إِسْرَائِيل خْ ڒعْيُوذَاثْ إِتّْوَاڭّنْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","”ؤُمُورْ أَيْثْ ن إِسْرَائِيل مَاحنْذْ أَذْ أَشْ د-أَوْينْ إِ ثْفَاوْثْ زّشْثْ إِصْفَانْ تّْوَادّْزنْ ت-إِ-د زِي زِّيثُونْ، حِيمَا أَذْ ثجّمْ ثَافَاوْثْ ثَارقّْ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","هَارُونْ أَذْ ت إِستّفْ ڒبْذَا زَّاثْ إِ وُوذمْ ن سِيذِي زِي دْجِيڒثْ أَڒْ صّْبحْ زَّاثْ ن ؤُڒحَّافْ ن شّْهَاذثْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","إِتّْخصَّا أَسْ أَذْ إِستّفْ ڒبْذَا ثِيفْثِيڒِينْ ن ثْفَاوِينْ إِ إِدْجَانْ خْ ڒْقنْذِيڒْ إِزْذِيڭنْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","أَذْ ثكْسِيذْ وَارنْ أَزْذَاذْ ؤُشَا أَذْ زَّايسْ ثسّنْڭّْوذْ ثنْعَاشْ ن ڒمْسمْنَاثْ. إِشْثْ ن ثمْسمّمْثْ أَذْ ثِيڒِي زِي ثْنَاينْ ن ثعْشُورِينْ ن يِيجّْ ن إِفَا ن وَارنْ أَزْذَاذْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","أَذْ ثنْثْ ثڭّذْ ذِي ثْنَاينْ ن إِستِّيفنْ، ستَّا ذڭْ إِجّْ ن ؤُستِّيفْ خْ ثْزوْضَا إِزْذِيڭنْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","أَذْ ثڭّذْ خْ كُوڒْ أَستِّيفْ جَّاوِي إِصْفَانْ نِّي غَا يِيڒِي إِ ڒِيذَارثْ أَكْ-ذ وغْرُومْ. أَقَا-ت ذ إِشْثْ ن ثوْهِيبْثْ ن ثْمسِّي إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ذِي كُوڒْ أَسّْ ن سّبْثْ أَذْ إِستّفْ أَيَا ڒبْذَا زَّاثْ إِ وُوذمْ ن سِيذِي ذِي طّْوعْ ن أَيْثْ ن إِسْرَائِيل. أَقَا-ث ذ إِجّْ ن ڒْعَاهْذْ إِ ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","أَذْ يِيڒِي وغْرُومْ إِ هَارُونْ ذ وَارَّاوْ نّسْ، إِنِّي ث غَا إِشّنْ ذڭْ ومْشَانْ أَمْقدَّاسْ، مِينْزِي إِ نتَّا إِ إِدْجَا ؤُيَا ذ أَمْقدَّاسْ قَاعْ زِي ثوْهِيبِينْ ن ثْمسِّي ن سِيذِي. أَقَا-ت ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا.“ ");
INSERT INTO rifa_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","مِّيسْ ن إِشْثْ ن ثمْغَارْثْ ثِيسْرَا‘إِلشْثْ ثفّغْ غَارْ بَارَّا. نتَّا ثُوغَا-ث ذ مِّيسْ ن إِجّْ ن ورْيَازْ ذ أَمِيصْرِي إِزدّْغنْ جَارْ أَيْثْ ن إِسْرَائِيل. مِّيسْ ن ثمْغَارْثْ-أَ ثِيسْرَا‘إِلشْثْ ؤُ إِجّْ ن ورْيَازْ إِسْرَايِيلِي مّنْغنْ أَكْ-ذ وَايَاوْيَا ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","مِّيسْ ن ثمْغَارْثْ ثِيسْرَا‘إِلشْثْ إِشقّفْ ذڭْ يِيسمْ ؤُشَا إِكّْوَارْ. خنِّي إِوْينْ ث غَارْ مُوسَا. يمَّاسْ، قَّارنْ أَسْ شِيلُومِييَا، يدْجِيسْ ن ذِيبْرِي، زِي ثقْبِيتْشْ ن دَان. ");
INSERT INTO rifa_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ڭِّينْ أَذْ خَاسْ حْضَانْ أَڒَامِي ذ أَسنْ إِ غَا إِمّڒْ مِينْ إِ غَا ڭّنْ زڭْ ؤُقمُّومْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ؤُشَا إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","”سُوفّغْ ونِّي إِنعْڒنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُشَا أجّْ مَارَّا إِنِّي ذ أَسْ إِسْڒِينْ أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ ؤُزدْجِيفْ نّسْ. خنِّي أَذْ ث ثَارْجمْ ثْمسْمُونْثْ أَمْ ثكْمڒْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","أَذْ ثسِّيوْڒذْ أَكْ-ذ مَارَّا أَيْثْ ن إِسْرَائِيل ؤُشَا أَذْ أَسنْ ثِينِيذْ: ’كُوڒْ أَرْيَازْ إِ غَا إِنعْڒنْ أَربِّي، أَذْ يَارْبُو دّنْبْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ونِّي إِتّْشقَّافنْ ذڭْ يِيسمْ ن سِيذِي، أَذْ إِتّْوَانغْ نِيشَانْ!‘ مَارَّا ثَامسْمُونْثْ أَذْ ث ثَارْجمْ. أَذْ إِتّْوَانغْ ؤُبَارَّانِي ؤُڒَا ذ ونِّي د-إِتّْوَاخڒْقنْ ذِي ثمُّورْثْ مَاڒَا إِتّْشقّفْ ذڭْ يِيسمْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","”مَاڒَا إِجّْ ن ورْيَازْ إِنْغَا ڒعْمَارْ ن شَا ن بْنَاذمْ نّغْنِي، خنِّي أَذْ إِتّْوَانغْ نِيشَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","مَاشَا ونِّي إِنْغِينْ ڒعْمَارْ ن إِشْثْ ن ڒبْهِيمثْ، أَذْ يَارّْ ڒعْمَارْ س ڒعْمَارْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","مَاڒَا إِجّْ ن ورْيَازْ إِسّْيِيزمْ جَّارْ نّسْ، خنِّي أَذْ زَّايسْ ڭّنْ أَمْ مَامّشْ إِڭَّا نتَّا: ");
INSERT INTO rifa_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ثَارژِّيثْ س ثَارژِّيثْ، ثِيطّْ س ثِيطّْ، ثِيغْمسْثْ س ثغْمسْثْ. أَنشْثْ إِسّْيِيزّمْ نتَّا إِجّْ ن بْنَاذمْ، أَمُّو إِ ذ أَسْ غَا ڭّنْ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ونِّي إِنْغِينْ إِشْثْ ن ڒبْهِيمثْ، أَذْ ت يَارّْ، ؤُ ونِّي إِنْغِينْ إِجّْ ن بْنَاذمْ، أَذْ إِتّْوَانغْ سِيمَانْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","أَذْ غَارْومْ يِيڒِي ذ إِجّْ ن ؤُزرْفْ إِ ؤُبَارَّانِي أَمْ إِ ونِّي د-إِخڒْقنْ ذِي ثمُّورْثْ، مِينْزِي نشّْ ذ سِيذِي، أَربِّي نْومْ!“ ");
INSERT INTO rifa_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","خنِّي إِنَّا مُوسَا إِ أَيْثْ ن إِسْرَائِيل أَذْ سُّوفّْغنْ ونِّي ثُوغَا إِنعّْڒنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ، حِيمَا أَذْ ث أَرجْمنْ. ؤُشَا أَيْثْ ن إِسْرَائِيل ڭِّينْ أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا خْ وذْرَارْ ن سِينَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’خْمِي غَا ثَاوْضمْ غَارْ ثمُّورْثْ نِّي ذ أَومْ غَا وْشغْ، خنِّي أَذْ ثَاريّحْ ثمُّورْثْ، إِجّْ ن وَاريّحْ ن سّبْثْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ستَّا ن إِسڭّْوُوسَا أَذْ ثْزَارْعذْ إِيَّارْ نّشْ ؤُشَا ستَّا ن إِسڭّْوُوسَا أَذْ ثزْبَارذْ ثِيزَايَارِينْ ن ؤُمَارْجعْ نّشْ ؤُشَا أَذْ ثسّْمُونذْ ڒْغِيدْجثْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","مَاشَا ذڭْ ؤُسڭّْوَاسْ وِيسّْ سبْعَا أَذْ ثِيڒِي إِشْثْ ن أَرَّاحثْ ن سّبْثْ إِ ثمُّورْثْ، إِجّْ ن سّبْثْ إِ سِيذِي. وَارْ ثْزَارّْعذْ شَا إِيَّارْ نّشْ ؤُ وَارْ ثْزبَّارذْ شَا ثِيزَايَارِينْ ن ؤُمَارْجعْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","مِينْ د-إِغمّْينْ أَمنِّي وَاهَا، وَارْ ث مجَّارمْ ؤُ أَضِيڒْ وَارْ ث زبَّارمْ زِي ثْزَايَارْثْ نّشْ إِ وَارْ إِتّْوِيحِيذِينْ. أَذْ يِيڒِي ذ إِجّْ ن ؤُسڭّْوَاسْ ن سّبْثْ إِ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","صَّابثْ ن أَرَّاحثْ ن سّبْثْ ن ثمُّورْثْ نّشْ أَذْ أَومْ ثِيڒِي ذ مَاشَّا، إِ شكْ، إِ يِيسْمغْ نّشْ، إِ ثَايَّا نّشْ، إِ ؤُشوَّاڒْ نّشْ ؤُڒَا إِ ؤُمْعزّبْ نّشْ، إِنِّي أَكِيذكْ إِزدّْغنْ أَمْ يِيبَارَّانِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","صَّابثْ نّسْ مَارَّا أَذْ ثِيڒِي ذ مَاشَّا إِ ڒبْهَايمْ ؤُ إِ ڒْمَاڒْ نِّي إِدْجَانْ ذِي ثمُّورْثْ نّشْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","”أَذْ ثْحسّْبمْ كنِّيوْ عَاوذْ سبْعَا ن سِّيمَانَاثْ ن إِسڭّْوُوسَا، سبْعَا وّثْ إِ-ت ذِي سبْعَا ن إِسڭّْوُوسَا، مَاحنْذْ أَذْ أَوْضنْ وُوسَّانْ ن سبْعَا ن سِيمَانَاثْ ن إِسڭّْوُوسَا مُوننْ غَارْ ثسْعَا ؤُ-ربْعِينْ ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","خنِّي ذڭْ ؤُيُورْ وِيسّْ سبْعَا، ذڭْ وَاسّْ وِيسّْعشْرَا ن ؤُيُورْ، أَذْ ثجّذْ أَسُوضِي ذڭْ ؤُيِيشّْ ن إِشَارِّي أَذْ إِتّكّْ خْ ثمُّورْثْ نْومْ س وسْرُودّحْ. ذڭْ وَاسّْ ن وصْڒَاحْ أَذْ ثجّمْ أَذْ إِتّكّْ ؤُسُوضِي ذڭْ ؤُيِيشّْ ن إِشَارِّي خْ مَارَّا ثَامُّورْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","أَذْ ثسّْقدّْسمْ أَسڭّْوَاسْ ن ؤُسڭّْوَاسْ وِيسّْ خمْسِينْ. أَذْ ثْبَارّْحمْ س ثْڒلِّي إِ مَارَّا إِمزْذَاغْ ذِي مَارَّا ثَامُّورْثْ. أَذْ يِيڒِي ذ إِجّْ ن ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ إِ كنِّيوْ ؤُشَا أَذْ د-إِعْقبْ كُوڒْ أَرْيَازْ غَارْ وَاڭْڒَا نّسْ ؤُ غَارْ رَادْجْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","أَسڭّْوَاسْ ن ؤُسڭّْوَاسْ وِيسّْ خمْسِينْ أَذْ أَومْ يِيڒِي ذ إِجّْ ن ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ. وَارْ ثْزَارّْعمْ ؤُ وَارْ ثْمجَّارمْ مِينْ د-إِغمّْينْ أَمنِّي وَاهَا، ؤُ وَارْ ثْزبَّارمْ شَا زِي ثْزَايَارْثْ وَارْ إِتّْوِيحِيذِينْ، ");
INSERT INTO rifa_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","مِينْزِي أَقَا ذ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ! أَقَا ثْزمَّارمْ أَذْ ثشّمْ ڒْغِيدْجثْ ن ييَّارْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ذڭْ ؤُسڭّْوَاسْ-أَ ن ؤُسْڒِيوْڒوْ أَذْ د-إِعْقبْ كُوڒْ  إِجّنْ غَارْ وَاڭْڒَا نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","”مڒْمِي شكْ غَا ثزّنْزذْ شَا إِ جَّارْ نّشْ نِيغْ مَاڒَا ثسْغِيذْ شَا زڭْ ؤُفُوسْ ن جَّارْ نّشْ، وَارْ إِعدّڒْ ؤُڒَا ذ إِجّنْ أَذْ إِغبّنْ ونّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","عْلَاحْسَابْ ڒْقدّْ ن إِسڭّْوُوسَا زڭْ وَامِي إِدْجَا ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ أَذْ ثسْغذْ ثَامُّورْثْ زِي جَّارْ نّشْ ؤُ عْلَاحْسَابْ ڒْقدّْ ن إِسڭّْوُوسَا ن صَّابثْ أَذْ كِيكْ يڭّْ ثَامنْزِيوْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","مَا أَقَا ذِينِّي عَاذْ أَطَّاسْ ن إِسڭّْوُوسَا غَارْ زَّاثْ، خنِّي أَذْ ثَارْنِيذْ ذِي تَّامَانْ ن ثْمسْغِيوْثْ نّسْ ؤُ مَاڒَا أَقَا ذِينِّي عَاذْ ذْرُوسْ ن إِسڭّْوُوسَا غَارْ زَّاثْ، خنِّي أَذْ ثسّْنقْصمْ ذِي تَّامَانْ ن ثْمسْغِيوْثْ نّسْ، مِينْزِي نتَّا أَذْ أَشْ ت إِزّنْزْ عْلَاحْسَابْ ڒْقدّْ ن إِسڭّْوُوسَا ن صَّابثْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","وَارْ إِتّْغبِّي حذْ جَّارْ نّسْ. ڭّْوذْ أَربِّي نّشْ، مِينْزِي أَقَا نشّْ ذ سِيذِي، أَربِّي نْومْ!“ ");
INSERT INTO rifa_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","”ضْفَارمْ ثِيوصَّا إِنُو، حْضَامْ لْفَارَايِيضْ إِنُو ؤُشَا ڭّمْ زَّايْسنْثْ، أَذْ ثْزذْغمْ خنِّي ذِي ثمُّورْثْ ذِي ڒَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ثَامُّورْثْ أَذْ ثوْشْ ڒْغِيدْجثْ نّسْ ؤُ كنِّيوْ أَذْ زَّايسْ ثشّمْ أَڒْ غَا ثجِّيوْنمْ ؤُشَا أَذْ ذِينْ ثْزذْغمْ ذِي ڒَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ؤُشَا مَاڒَا ثنِّيمْ: ’مِينْ غَا نشّْ ذڭْ ؤُسڭّْوَاسْ وِيسّْ سبْعَا؟ خْزَارْ، وَارْ نْزمَّارْ أَذْ نْزَارّعْ ؤُ وَارْ نْزمَّارْ أَذْ نسّْمُونِي صَّابثْ نّغْ!‘، ");
INSERT INTO rifa_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","خنِّي ذڭْ ؤُسڭّْوَاسْ وِيسّْ ستَّا نشّْ أَذْ أَومْ د-سّكّغْ لْبَارَاكَا إِنُو حِيمَا ثَامُّورْثْ أَذْ ثوْشْ رْغِيدْجثْ إِ ثْڒَاثَا ن إِسڭّْوُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ذڭْ ؤُسڭّْوَاسْ وِيسّْ ثْمنْيَا أَذْ ثْزَارْعمْ عَاوذْ. ؤُشَا أَذْ ثشّمْ زِي صَّابثْ ثَاقْذِيمْثْ أَڒْ أَسڭّْوَاسْ وِيسّْ ثسْعَا. أَڒْ إِ غَا ثِيڒِي صَّابثْ نّسْ ن جْذِيذْ، أَذْ ثشّمْ عَاذْ زِي صَّابثْ ثَاقْذِيمْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","”ثَامُّورْثْ وَارْ ثتّْمنْزِي إِ ڒبْذَا، مِينْزِي ثَامُّورْثْ أَقَا-ت إِنُو ؤُشَا كنِّيوْ خنِّي ذ إِبَارَّانِييّنْ ذ إِمعْزَابْ غَارِي. ");
INSERT INTO rifa_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","س ؤُيَا إِتّْخصَّا كنِّيوْ أَذْ ثوْشمْ تّسْرِيحْ مَاحنْذْ أَذْ إِفْذِي ثَامُّورْثْ ذِي مَارَّا ثَامُّورْثْ إِ غَارْومْ إِدْجَانْ ذ وَاڭْڒَا. ");
INSERT INTO rifa_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","مَاڒَا ؤُمَاشْ إِژْڒضْ ؤُشَا إِزّنْزْ شَا زڭْ وَاڭْڒَا نّسْ، أَذْ د-يَاسْ ؤُمفْذِي نّسْ، ڒَادْجْ نّسْ يُوذْسنْ، مَاحنْذْ أَذْ إِفْذِي مِينْ إِزّنْزْ ؤُمَاسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","مَاڒَا أَرْيَازْ وَارْ غَارسْ بُو ؤُمفْذِي، مَاشَا أَفُوسْ نّسْ إِزمَّارْ أَذْ يَافْ مِينْ إِشْفَانْ، مَاحنْذْ أَذْ ث إِفْذِي، ");
INSERT INTO rifa_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","خنِّي أَذْ إِحْسبْ إِسڭّْوُوسَا زڭْ وَامِي ثتّْوَامّنْزْ ثمُّورْثْ ؤُشَا أَذْ إِخدْجصْ مِينْ إِقِّيمنْ إِ ورْيَازْ ؤُمِي ت إِزّنْزْ ؤُشَا أَذْ ت-إِ-د-يَارّْ غَارْ وَاڭْڒَا نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","مَاڒَا أَفُوسْ نّسْ وَارْ يُوفِي ڒْقدّْ، حِيمَا أَذْ أَسْ د-يَارّْ مِينْ ثُوغَا إِزّنْزْ، خنِّي مِينْ ثُوغَا إِزّنْزْ أَذْ إِقِّيمْ ذڭْ ؤُفُوسْ ن ونِّي ث إِسْغِينْ أَڒْ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ. مَاشَا ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ أَذْ إِتّْوَافكّْ مَانْ أَيَا ؤُشَا أَذْ ث-إِ-د-يَارّْ غَارْ وَاڭْڒَا نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","”مَاڒَا شَا ن يِيجّنْ إِزّنْزْ ثَادَّارْثْ نّسْ ذڭْ إِشْثْ ن ثنْذِينْثْ ؤُمِي د-نّْضنْ س وغْبَارْ خنِّي إِعدّڒْ أَذْ يِيڒِي ؤُفكِّي نّسْ أَڒْ ذ إِعْذُو إِجّْ ن ؤُسڭّْوَاسْ أَمْ إِكْمڒْ زِي ثْمنْزِيوْثْ نّسْ. مَارَّا ؤُسَّانْ نِّي إِعدّڒْ أَذْ ت إِفْذِي. ");
INSERT INTO rifa_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","مَاشَا مَاڒَا وَارْ ثتّْوَافْذِي ذِي ڒْمِيجَاڒْ ن إِجّْ ن ؤُسڭّْوَاسْ، خنِّي ثَادَّارْثْ ذِي ثنْذِينْثْ نِّي د-إِنّْضنْ س وغْبَارْ، أَذْ ثِيڒِي ڒبْذَا إِ ونِّي ت إِسْغِينْ، إِ مَارَّا جِّيڒَاثْ نّسْ. وَارْ ثتّْوَافكّْ ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","مَاشَا ثُوذْرِينْ نِّي ن ڒذْشُورْ إِ ؤُمِي وَارْ د-إِنِّيضْ ڒغْبَارْ أَذْ تّْوَاحسْبنْثْ أَمْ يِيجّْ ن ييَّارْ ن ثمُّورْثْ. ذَانِيثَا إِزمَّارْ أَذْ يِيڒِي ڒْحقّْ ن ؤُفكِّي ؤُشَا أَذْ إِتّْوَافكّْ ييَّارْ ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","خْ ثْندَّامْ ن إِلَاوِييّنْ، ثُوذْرِينْ ذِي ثْندَّامْ ن وَاڭْڒَا نْسنْ، أَقَا إِلَاوِييّنْ غَارْسنْ ڒْحقّْ إِ ڒبْذَا حِيمَا أَذْ ثنْثْ فْذِينْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","مَاڒَا شَا ن يِيجّنْ إِفْذَا إِ-ت زڭْ ؤُفُوسْ ن إِلَاوِييّنْ، خنِّي أَذْ ثتّْوَافكّْ ثَادَّارْثْ إِ إِمّنْزنْ إِ إِجّنْ إِ وَارْ إِدْجِينْ زڭْ إِلَاوِييّنْ، ثنِّي إِدْجَانْ ذِي ثنْذِينْثْ ن وَاڭْڒَا نّسْ، ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ، مِينْزِي ثُوذْرِينْ ن ثْندَّامْ ن إِلَاوِييّنْ أَقَا أَثنْثْ ذ أَڭْڒَا نْسنْ ذِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","إِيَّارْ نِّي إِقّْننْ غَارْ ثْندَّامْ، وَارْ إِتّْمنْزِي، مِينْزِي أَقَا-ث ذ أَڭْڒَا نْسنْ إِ ڒبْذَا.“ ");
INSERT INTO rifa_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","”مَاڒَا ؤُمَاشْ إِژْڒضْ ؤُشَا إِفَاسّنْ نّسْ بْذَانْ أَذْ أَرْجِيجنْ ذِينْ غَاركْ، خنِّي إِتّْخصَّا أَذْ ث-إِ-د-ثْسنّْذذْ مَاحنْذْ أَذْ إِبدّْ، ؤُڒَا ذ أَبَارَّانِي نِيغْ ذ أَمْعزّبْ، مَاحنْذْ أَذْ إِقِّيمْ أَذْ غَاركْ إِدَّارْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","وَارْ زَّايسْ ثْكسِّيذْ أَرِّيبَا ؤُڒَا ذ أَرْبحْ، مَاشَا أَذْ ثڭّْوْذذْ أَربِّي نّشْ، حِيمَا ؤُمَاشْ إِ ذِينْ غَاركْ أَذْ إِقِّيمْ إِدَّارْ.    ");
INSERT INTO rifa_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","وَارْ ذ أَسْ تِّيشْ ثْمنْيَاثْ ن نُّوقَارْثْ س أَرِّيبَا ؤُ وَارْ ذ أَسْ تِّيشْ مَاشَّا س وَارْبحْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","أَقَا نشّْ ذ سِيذِي، أَربِّي نْومْ، ونِّي كنِّيوْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، حِيمَا أَذْ أَومْ وْشغْ ثَامُّورْثْ ن كنْعَانْ ؤُ حِيمَا أَذْ إِڒِيغْ ذ أَربِّي إِ كنِّيوْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","”مَاڒَا ؤُمَاشْ إِژْڒضْ أَمْ كِيكْ إِدْجَا ؤُشَا إِمّنْزْ أَشْ إِ شكْ، وَارْ ث ثتَّارِّيذْ أَذْ إِخْذمْ أَمْ يِيسْمغْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","أَذْ كِيكْ إِزْذغْ أَمشْنَاوْ أَشوَّاڒْ، أَمشْنَاوْ إِجّْ ن ؤُمْعزّبْ، ؤُشَا أَذْ غَاركْ إِخْذمْ أَڒْ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","خنِّي أَذْ خَاكْ إِفّغْ، نتَّا سِيمَانْثْ نّسْ أَكْ-ذ ثَارْوَا نّسْ، ؤُشَا أَذْ إِذْوڒْ غَارْ ڒَادْجْ نّسْ ؤُ أَذْ إِذْوڒْ غَارْ وَاڭْڒَا ن ڒجْذُوذْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","مِينْزِي أَقَا أَثنْ ذ إِمْسخَارّنْ إِنُو إِنِّي سُّوفّْغغْ نشّْ زِي ثمُّورْثْ ن مِيصْرَا. وَارْ تّْمنْزِينْ أَمْ مَامّشْ إِتّْمنْزَا إِجّْ ن إِسْمغْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","وَارْ خَاسْ تّْصدْجضْ س ڒقْسَاحثْ، مَاشَا أَذْ ثڭّْوْذذْ أَربِّي نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","خْ إِسْمغْ نّشْ نِيغْ خْ ثَايَّا نّشْ، إِنِّي غَاركْ غَا يِيڒِينْ، أَذْ إِڒِينْ زِي ڒڭْنُوسْ إِ ذ أَشْ د-إِنّْضنْ. زَّايْسنْ أَذْ ثسْغذْ إِسمْغَانْ ذ ثيَّاوِينْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ثْزمَّارمْ أَذْ ثنْ ثسْغمْ زڭْ إِحنْجِيرنْ ن إِمعْزَابْ نِّي إِزدّْغنْ جَارْ أَومْ أَمْ يِيبَارَّانِييّنْ ؤُ زِي ڒَادْجَاثْ نْسنْ، إِنِّي أَكِيذْومْ إِدْجَانْ، إِنِّي ثنْ د-إِجِّينْ ذِي ثمُّورْثْ نْومْ. نِيثْنِي أَذْ ذوْڒنْ ذ أَڭْڒَا نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ؤُشَا أَذْ ثنْ ثجّذْ ذ ڒْوَارْثْ إِ إِحنْجِيرنْ نْومْ أَوَارْنِي أَومْ. ثْزمَّارمْ أَذْ ثنْ ثَارّمْ أَذْ أَومْ سخَّارنْ ڒبْذَا، مَاشَا خْ أَيْثْمَاثْومْ، أَيْثْ ن إِسْرَائِيل، وَارْ تّْصلّْطمْ كُوڒْ إِجّْ خْ ونّغْنِي س ڒقْسَاحثْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","”مَاڒَا يِيوضْ ؤُفُوسْ ن إِجّْ ن ؤُبَارَّانِي نِيغْ ن إِجّْ ن ؤُمْعزّبْ إِ إِزدّْغنْ جَارْ أَومْ، ؤُشَا ؤُمَاشْ إِ غَارسْ إِزدّْغنْ إِذْوڒْ إِژْڒضْ ؤُشَا أَذْ إِزّنْزْ إِخفْ نّسْ إِ ؤُبَارَّانِي نِّي إِزدّْغنْ غَاركْ نِيغْ إِ يِيجّنْ زِي جَّاذِيرَا ن ڒَادْجْ ن ؤُبَارَّانِي نِّي، ");
INSERT INTO rifa_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","خنِّي إِعدّڒْ، أَوَارْنِي مَا إِزّنْزْ إِخفْ نّسْ، أَذْ إِتّْوَافْذِي. إِجّنْ زڭْ أَيْثْمَاسْ أَذْ ث إِفْذِي. ");
INSERT INTO rifa_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","إِعدّڒْ إِعمِّيسْ نِيغْ إِ مِّيسْ نعمِّيسْ أَذْ ث إِفْذِي نِيغْ إِجّنْ زِي رَادْجْ نّسْ إِ-ث-إِ-د-يُوذْسنْ، زِي ڒْوَاشُونْ نّسْ، أَذْ ث إِفْذِي، نِيغْ مَاڒَا غَارسْ س مِينْ زِي، خنِّي إِعدّڒْ أَذْ إِفْذِي إِخفْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","أَذْ إِڭّْ ڒحْسَابْ أَكْ-ذ ونِّي ث إِسْغِينْ زڭْ ؤُسڭّْوَاسْ مِينْ ذِي إِزّنْزْ إِخفْ نّسْ أَڒْ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ ؤُ تَّامَانْ ن ثْمنْزِيوْثْ س نُّوقَارْثْ أَذْ يِيڒِي عْلَاحْسَابْ ڒْقدّْ ن إِسڭّْوُوسَا، إِنِّي إِ غَا إِتّْوَاحسْبنْ أَمْ وُوسَّانْ ن إِجّْ ن ؤُشوَّاڒْ إِخدّْمنْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","مَاڒَا أَقَا ذِينْ عَاذْ أَطَّاسْ ن إِسڭّْوُوسَا غَارْ زَّاثْ، أَذْ إِخدْجصْ مَاحنْذْ أَذْ إِتّْوَافْذِي أَنشْثْ ن ثسْغَارْثْ ن تَّامَانْ س ثْمنْيَاثْ ن نُّوقَارْثْ إِ زِي إِتّْوَاسغْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","مَاڒَا عَاذْ ذْرُوسْ إِ إِقِّيمنْ ن إِسڭّْوُوسَا أَڒْ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ، خنِّي أَذْ إِڭّْ إِ يِيخفْ نّسْ إِجّْ ن ڒحْسَابْ ؤُشَا أَذْ إِخدْجصْ تَّامَانْ ن ؤُفكِّي نّسْ عْلَاحْسَابْ إِسڭّْوُوسَا إِ ذِينْ إِقِّيمنْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","أَمْ يِيجّْ ن ؤُشوَّاڒْ أَذْ غَارسْ إِقِّيمْ زڭْ ؤُسڭّْوَاسْ أَڒْ أَسڭّْوَاسْ. وَارْ إِعدّڒْ أَذْ خَاسْ صلّْطنْ س ڒقْسَاحثْ زَّاثْ إِ ثِيطَّاوِينْ نّشْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","مَاڒَا وَارْ إِتّْوَافْذِي س مَارَّا أَيَا، خنِّي أَذْ إِفكّْ ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ، نتَّا ذ ثَارْوَا نّسْ أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","مِينْزِي أَيْثْ ن إِسْرَائِيل أَقَا أَثنْ ذ إِمْسخَّارنْ إِنُو، إِنِّي سُّوفّْغغْ زِي ثمُّورْثْ ن مِيصْرَا. أَقَا نشّْ ذ سِيذِي، أَربِّي نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","”وَارْ تّڭّمْ إِ يِيخفْ نْومْ لْ-أَصْنَامْ، وَارْ سْبدَّامْ ڒخْيَاڒْ إِنقْشنْ ؤُڒَا ذ ؤُمَايْضُو إِقدّْسنْ، وَارْ سّْرُوسَامْ ڒخْيَاڒْ ن وژْرُو ذِي ثمُّورْثْ نْومْ، حِيمَا أَذْ أَسْ ثْبنْذْقمْ، مِينْزِي نشّْ ذ سِيذِي، أَربِّي نْومْ! ");
INSERT INTO rifa_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","أَذْ ثحْضَامْ ؤُسَّانْ ن سّبْثْ إِنُو ؤُشَا أَذْ أَومْ إِقَارّْ إِجّْ ن ؤُوقَّارْ يُودْجْغنْ إِ زَّاوشْثْ إِنُو إِقدّْسنْ، أَقَا نشّْ ذ سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","”مَاڒَا أَذْ ثُويُورمْ ذِي ثْوصَّا إِنُو ؤُشَا أَذْ ثطّْفمْ ذِي ثْوصَّا إِنُو ؤُشَا أَذْ زَّايْسنْثْ ثڭّمْ، ");
INSERT INTO rifa_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","خنِّي نشّْ أَذْ أَومْ وْشغْ أَنْژَارْ ذِي ڒْوقْثْ نّسْ، ؤُشَا ثَامُّورْثْ أَذْ د-ثَاوِي صَّابثْ نّسْ، ؤُشَا ثِيشجُّورَا ن ييَّارْ أَذْ وْشنْثْ ڒْغِيدْجثْ نْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","أَذْ يِيڒِي ؤُسَارْوثْ أَڒْ أَڒْقَاضْ ن ؤُضِيڒْ ؤُشَا أَڒْقَاضْ ن ؤُضِيڒْ أَذْ يِيڒِي أَڒْ ڒْْوقْثْ ن ؤُزَارّعْ ؤُشَا أَذْ ثشّمْ أَڒْ غَا ثجِّيوْنمْ ؤُشَا أَذْ ثْزذْغمْ ذِي ڒَامَانْ ذِي ثمُّورْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","نشّْ أَذْ ڭّغْ ڒهْنَا ذِي ثمُّورْثْ. مَاڒَا ثطّْصمْ، وَارْ إِتِّيڒِي وِي كنِّيوْ إِ غَا إِسِّيڭّْوْذنْ. نشّْ أَذْ مْحِيغْ ڒوْحُوشْ إِوْعَارنْ زِي ثمُّورْثْ ؤُشَا سِّيفْ وَارْ د-إِژكّْوِي خْ ثمُّورْثْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","أَذْ ثضْفَارمْ ڒْعذْيَانْ نْومْ ؤُشَا نِيثْنِي أَذْ وْضَانْ س سِّيفْ نْومْ زَّاثْ إِ ثِيطَّاوِينْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","خمْسَا ن يرْيَازنْ زَّايْومْ أَذْ ضْفَارنْ مْيَا ؤُشَا مْيَا زَّايْومْ أَذْ ضْفَارنْعشْرَا-أَڒَافْ ؤُشَا ڒْعذْيَانْ نْومْ أَذْ وْضَانْ س ڒقْضعْ ن سِّيفْ زَّاثْ إِ ثِيطَّاوِينْ نْومْ.    ");
INSERT INTO rifa_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","مِينْزِي نشّْ أَذْ غَارْومْ د-ذوْڒغْ ؤُشَا أَذْ أَومْ د-جّغْ ڒْغِيدْجثْ ؤُشَا أَذْ كنِّيوْ أَرْنِيغْ ؤُشَا أَذْ سّْمثْنغْ ڒْعَاهْذْ إِنُو أَكِيذْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","أَمْ إِ غَا ثشّمْ عَاذْ زِي زَّاذْ نِّي ثْخزْنمْ، أَذْ ثكّْسمْ ذغْيَا زَّاذْ أَقْذِيمْ، مَاحنْذْ أَذْ ثجّمْ أَمْشَانْ إِ جْذِيذْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","نشّْ أَذْ ڭّغْ ثَازذِّيغْثْ إِنُو ذِي ڒْوسْثْ نْومْ ؤُشَا ڒعْمَارْ إِنُو وَارْ زَّايْومْ إِتّْعِيفِّي شَا عَاذْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","أَذْ ؤُيُورغْ جَارْ أَومْ، نشّْ أَذْ إِڒِيغْ ذ أَربِّي نْومْ ؤُشَا كنِّيوْ أَذْ أَيِي ثِيڒِيمْ ذ ڒْڭنْسْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","نشّْ ذ سِيذِي، أَربِّي نْومْ، ونِّي كنِّيوْ د-إِسُّوفّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، حِيمَا وَارْ ثتِّيڒِيمْ عَاذْ ذ إِسمْغَانْ نْسنْ. نشّْ أَرْژِيغْ إِمْقدْجَاضنْ ن ؤُزَايْڒُو نْومْ ؤُشَا نذْهغْ كنِّيوْ س وُوذمْ يُوڒِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","”مَاشَا مَاڒَا وَارْ ذ أَيِي ثسْڒِيمْ نِيغْ وَارْ ثتّڭِّيمْ مَارَّا مِينْ زِي كنِّيوْ وصِّيغْ، ");
INSERT INTO rifa_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ؤُشَا مَاڒَا ثسّحْقَارمْ ثِيوصَّا إِنُو ؤُ ڒعْمَارْ نْومْ أَذْ إِعِيفّْ زِي لْفَارَايِيضْ إِنُو، أَڒْ غَا ثَاوْضمْ وَارْ ثتّڭّمْ عَاذْ مَارَّا ثِيوصَّا إِنُو، ؤُشَا أَمُّو إِ غَا ثَارْژمْ ڒْعَاهْذْ إِنُو، ");
INSERT INTO rifa_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","خنِّي نشّْ أَذْ أَومْ ڭّغْ أَيَا: أَذْ خَاومْ د-سّهْوِيغْ أَرْجفْ ذ بُو-ذدْجِيسْ ذ ثْمسِّي ن أَرْوَاحْ نِّي إِ غَا إِثحَّانْ ثِيطَّاوِينْ ؤُشَا أَذْعدّْبنْ ڒعْمَارْ. أَذْ ثْزَارْعمْ زَّارِيعثْ نْومْ بَاطڒْ، مِينْزِي ڒْعذْيَانْ نْومْ أَذْ ت شّنْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","أَذْ ڭّغْ ؤُذمْ إِنُو ضِيدّْ نْومْ أَڒَامِي إِ غَا تّْوَاسّخْسَارمْ زَّاثْ إِ وُوذمْ ن ڒْعذْيَانْ نْومْ ؤُشَا إِنِّي كنِّيوْ إِشَارّْهنْ أَذْ خَاومْ صلّْطنْ ؤُشَا كنِّيوْ أَذْ ثَاروْڒمْ بْڒَا أَذْ يِيڒِي وِي كنِّيوْ إِرَارَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","”ؤُ مَاڒَا أَوَارْنِي مَانْ أَيَا عَاذْ وَارْ غَارِي ثسْڒِيمْ، نشّْ أَذْ غَارسْ أَرْنِيغْ سبْعَا ن ثْوَاڒَاوِينْ، مَاحنْذْ أَذْ كنِّيوْ وبّْخغْ خْ دّْنُوبْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","نشّْ أَذْ أَرْژغْ أَعفَّارْ ن جّهْذْ نْومْ، نشّْ أَذْ أَرّغْ أَجنَّا نْومْ أَمْ وُوزَّاڒْ ذ ثمُّورْثْ نْومْ أَمْ نّْحَاصْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","أَذْ ثْضيّْعمْ جّهْذْ نْومْ بَاطڒْ، مِينْزِي ثَامُّورْثْ نْومْ وَارْ ثتِّيشْ صَّابثْ نّسْ ؤُ ثِيشجُّورَا ن ثمُّورْثْ وَارْ تِّيشنْثْ ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","مَاڒَا ثمْعَاڒَامْ كِيذِي ؤُشَا وَارْ ثتّخْسمْ أَذْ أَيِي ثسْڒِيمْ، خنِّي نشّْ أَذْ خَاومْ د-سّهْوِيغْ عَاذْ سبْعَا ن جّْرَايحْ أَنشْثْ ن دّْنُوبْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","أَذْ غَارْومْ د-سّكّغْ ڒوْحُوشْ ن ڒخْڒَا، مَاحنْذْ أَذْ أَومْ خضْفنْ ثَارْوَا نْومْ، أَذْ سّْهلّْكنْ ڒبْهَايمْ نْومْ، ؤُشَا أَذْ سّْنقْصنْ لْعَاذَاذْ نْومْ، أَڒَامِي إِبْرِيذنْ نْومْ أَذْ ذوْڒنْ ذ دّْمَانِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","”مَاڒَا س مَانْ أَيَا كنِّيوْ وَارْ غَارِي د-تّسْڒِيمْ، مَاشَا ثقِّيممْ ثتّمْعَاڒَامْ أَكِيذِي، ");
INSERT INTO rifa_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","خنِّي ؤُڒَا ذ نشّْ أَذْ قِّيمغْ تّمْعَاڒَاغْ أَكِيذْومْ ؤُشَا أَذْ خَاومْ د-سّهْوِيغْ عَاذْ سبْعَا ن جّْرَايحْ خْ دّْنُوبْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","أَذْ خَاومْ سّكّغْ إِجّْ ن سِّيفْ نِّي إِ غَا إِسّكَّارنْ أَنْثَاقمْ ن ڒْعَاهْذْ إِنُو أَڒْ غَا ثتّْوَاسّْمُونمْ ذِي ثْندَّامْ نْومْ. خنِّي نشّْ أَذْ سّكّغْ طَّاعُونْ ذِي ڒْوسْطْ نْومْ ؤُشَا كنِّيوْ أَذْ ثتّْوَاسلّْممْ ذڭْ ؤُفُوسْ ن ڒعْذُو نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","خْمِي غَا أَرْژغْ ڒعْوتْشْ ن وغْرُومْ نْومْ، خنِّيعشْرَا ن ثمْغَارِينْ أَذْ سّنْڭّْونْثْ أَغْرُومْ نْومْ ذِي ثفْقُونْثْ ذ إِشْثْ، ؤُشَا أَوَارْنِي إِ غَا وزْننْثْ أَغْرُومْ أَذْ ث إِ-د-أَرّنْثْ ؤُشَا كنِّيوْ أَذْ ث ثشّمْ، مَاشَا وَارْ ثتّْجِيوِينمْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","مَاڒَا عَاذْ س مَانْ أَيَا وَارْ غَارِي د-ثتّسْڒِيمْ، مَاشَا أَذْ ثقِّيممْ أَذْ ثمْعَاڒَامْ أَكِيذِي، ");
INSERT INTO rifa_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","خنِّي نشّْ أَذْ خَاومْ سْعَارغْ ؤُ أَذْ كنِّيوْ أَربِّيغْ، وَاهْ سبْعَا ن إِمُورنْ نشّْ أَذْ كنِّيوْ أَربِّيغْ ذِي سِّيبّثْ ن دّْنُوبْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","أَذْ ثشّمْ أَيْسُومْ ن إِحنْجِيرنْ نْومْ ؤُڒَا ذ أَيْسُومْ ن ثْحنْجِيرِينْ نْومْ أَذْ ث ثشّمْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","أَذْ أَردّْدْجغْ ڒڭْعُوذِي مَانِي ثتّْوهَّابمْ دّْبَايحْ نْومْ، أَذْ نْضَارغْ إِپِيلَارنْ نْومْ ن أَربِّي ن ثْفُوشْثْ، أَذْ أَرّغْ ڒْخشْبَاثْ نْومْ خْ ڒْخشْبَاثْ ن إِميْضَا ن لْ-أَصْنَامْ نْومْ ؤُشَا ڒعْمَارْ إِنُو أَذْ زَّايْومْ إِعِيفّْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","أَذْ أَرّغْ ثِيندَّامْ نْومْ ذ ڒْخَارْبثْ ؤُشَا أَذْ أَردّْدْجغْ ثِيزَاوِييِّينْ إِقدّْسنْ نْومْ ؤُشَا وَارْ تّخْسغْ أَذْ شمّغْ عَاذْ ڒفْوَاحثْ إِتّْفُوحنْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","وَاهْ، نشّْ أَذْ أَردّْدْجغْ ثَامُّورْثْ ؤُشَا ڒْعذْيَانْ نْومْ، إِنِّي ذَايسْ إِزدّْغنْ، أَذْ زَّايسْ نّْخڒْعنْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","”أَذْ كنِّيوْ زُوزَّارغْ جَارْ ڒڭْنُوسْ ؤُشَا أَذْ كْسغْ سِّيفْ أَوَارْنِي أَومْ ؤُشَا ثَامُّورْثْ نْومْ أَذْ ثذْوڒْ ذ ڒخْڒَا ؤُشَا ثِيندَّامْ نْومْ أَذْ إِڒِينْثْ ذ ڒْخَارْبثْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","خنِّي ثَامُّورْثْ أَذْ خَاسْ أَرْضَانْ وُوسَّانْ ن سّبْثْ نّسْ، مَارَّا ؤُسَّانْ ن وَاردّدْجْ ن ثمُّورْثْ، ؤُمِي إِ غَا ثِيڒِيمْ ذِي ثمُّورْثْ ن ڒْعذْيَانْ نْومْ. خنِّي أَذْ ثَاريّحْ ثمُّورْثْ ؤُ أَذْ ثڭّْ ثْشُونِي خْ وُوسَّانْ ن سّبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","مَاڒَا ؤُسَّانْ ن وَاردّدْجْ أَذْ غَارسْ يِيڒِي وَاريّحْ، مِينْزِي ثَامُّورْثْ وَارْ ثَاريِّيحْ شَا ذڭْ وُوسَّانْ ن سّبْثْ نْومْ ڒَامِي ثُوغَا كنِّيوْ ثْزدّْغمْ ذِينِّي.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","”أَذْ ڭّغْ ثِيڭّْوُوذِي ذڭْ وُوڒَاونْ ن يِينِّي زَّايْومْ إِ غَا إِقِّيمنْ ذِي ثمُّورَا ن ڒْعذْيَانْ نْسنْ، أَڒَامِي ڒْحسّْ ن إِشْثْ ن ثْفَارشْثْ إِ يِيوِي ؤُسمِّيضْ أَذْ خَاسنْ يَاژّڒْ ؤُ أَذْ ثنْ يَارّْ أَذْ أَروْڒنْ أَمْ مَامّشْ إِتَّاركّْوَاڒْ بْنَاذمْ زِي سِّيفْ. نِيثْنِي أَذْ وْضَانْ، وَاخَّا وَارْ خَاسنْ إِتِّيژّڒْ حذْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","أَذْ نْقَارْضنْ إِجّنْ ذڭْ ونّغْنِي أَمْ خْمِي ژْرِينْ ڒقْذعْ ن يِيجّْ ن سِّيفْ، وَاخَّا وَارْ خَاومْ إِتِّيژّڒْ حذْ. كنِّيوْ وَارْ ثْزمَّارنْ أَذْ ثقِّيممْ ثْبدّمْ زَّاثْ إِ ثِيطَّاوِينْ ن ڒْعذْيَانْ نْومْ، ");
INSERT INTO rifa_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","مَاشَا كنِّيوْ أَذْ ثتّْوَاهلّْكمْ جَارْ ڒڭْنُوسْ ؤُشَا ثَامُّورْثْ ن ڒْعذْيَانْ نْومْ أَذْ كنِّيوْ ثشّْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","”إِنِّي زَّايْومْ إِ غَا إِقِّيمنْ أَذْ إِسْڒَاونْ ذِي ثمُّورَا ن ڒْعذْيَانْ نْومْ ذِي سِّيبّثْ ن ڒْمُوعْصِييّثْ نْسنْ. ؤُڒَا ذِي سِّيبّثْ ن ڒْمُوعْصِييّثْ ن ڒجْذُوذْ نْسنْ أَذْ سْڒَاونْ نِيثْنِي جْمِيعْ أَكِيذْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","مَاشَا مَاڒَا نعْمنْ خْ ڒْمُوعْصِييّثْ نْسنْ ذ ڒْمُوعْصِييّثْ ن إِبَابَاثنْ نْسنْ زِي سِّيبّثْ ن ڒغْذَارْ نْسنْ إِ زِي ذ أَيِي غْذَارنْ ؤُشَا عَاوذْ مّْعَاڒَانْ أَكِيذِي ");
INSERT INTO rifa_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","- ؤُشَا خنِّي ؤُڒَا ذ نشّْ مّْعَاڒِيغْ أَكِيذْسنْ ؤُ إِوْيغْ ثنْ غَارْ ثمُّورْثْ ن ڒْعذْيَانْ نْسنْ، مَاحنْذْ أَذْ ثَاغْ ؤُڒْ نْسنْ وَارْ إِخْثِيننْ أَذْ يَاضَارْ ؤُشَا أَذْ قبْڒنْ ڒخْڒَاصْ إِ ڒْمُوعْصِييّثْ نْسنْ - ");
INSERT INTO rifa_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","خنِّي نشّْ أَذْ خَارّْصغْ عَاوذْ ذِي ڒْعَاهْذْ إِنُو أَكْ-ذ يَاعْقُوبْ ؤُشَا عَاوذْ ذِي ڒْعَاهْذْ إِنُو أَكْ-ذ إِسْحَاقْ ؤُشَا أَذْ خَارّْصغْ ذِي ڒْعَاهْذْ إِنُو أَكْ-ذ إِبْرَاهِيمْ ؤُشَا أَذْ خَارّْصغْ عَاوذْ ذِي ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ثَامُّورْثْ أَذْ ثتّْوَاجّْ زَّايْسنْ ؤُشَا أَذْ خَاسْ أَرْضَانْ وُوسَّانْ ن سّبْثْ نّسْ ؤُمِي غَا ثقِّيمْ ذ إِشْثْ ن ڒْخَارْبثْ خْمِي وَارْ ذَايسْ زدّْغنْ عَاذْ، ؤُشَا نِيثْنِي أَذْ ڒمْذنْ أَذْ قبْڒنْ لْعِيقَابْ ن ڒْمُوعْصِييّثْ نْسنْ، مِينْزِي نْضَارنْ لْفَارَايِيضْ إِنُو ؤُ مِينْزِي ڒعْمَارْ نْسنْ إِعِيفّْ زِي ثْوصَّا إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","”سنّجْ إِ ؤُيَا، أَقَا ذ مَانْ أَيَا: مَاڒَا أَقَا أَثنْ ذِي ثمُّورْثْ نْ ڒعْذْيَانْ نْسنْ، نشّْ وَارْ ثنْ نطَّارغْ شَا ؤُ وَارْ ثنْ تّْعِيفِّيغْ أَڒْ ثنْ غَا ثحِّيغْ ؤُ أَذْ مْحِيغْ ڒْعَاهْذْ إِنُو أَكِيذْسنْ مِينْزِي نشّْ ذ سِيذِي، أَربِّي نْسنْ! ");
INSERT INTO rifa_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","مَاشَا ذِي طّْوعْ نْسنْ أَذْعقْڒغْ خْ ڒْعَاهْذْ إِنُو أَكْ-ذ إِمزْوُورَا، إِنِّي نذْهغْ زِي ثمُّورْثْ ن مِيصْرَا زَّاثْ إِ ثِيطَّاوِينْ ن ڒڭْنُوسْ، مَاحنْذْ أَذْ إِڒِيغْ ذ أَربِّي إِ نِيثْنِي، نشّْ ذ سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ثِينَا ذ ثِيوصَّا ذ لْفَارَايِيضْ ذ إِزرْفَانْ نِّي إِڭَّا سِيذِي جَارْ أَسْ ذ جَارْ أَيْثْ ن إِسْرَائِيل ذڭْ وذْرَارْ ن سِينَا س ثْسخَّارْثْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ، أَقَا مَاڒَا إِخْسْ حذْ أَذْ إِڭّْ إِجّْ ن لْوَاعْذْ إِ أَربِّي، أَذْ يِيڒِي تَّامَانْ ن ؤُفكِّي ن ڒعْمُورْ إِتّْوَاسّْقدّْسنْ إِ سِيذِي عْلَاحْسَابْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","مَاڒَا ڒْقِيمثْ إِ ثْقدَّارذْ شكْ أَقَا ذ ڒْقدّْ ن إِجّْ ن ورْيَازْ زِي عِيشْرِينْ أَڒْ ستِّينْ ن إِسڭّْوُوسَا، خنِّي أَذْ ثِيڒِي ڒْقِيمثْ إِ ثْقدَّارذْ خمْسِينْ شِيقْلُو ن نُّوقَارْثْ عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","مَاڒَا ذ إِشْثْ ن ثمْغَارْثْ، خنِّي أَذْ ثِيڒِي ڒْقِيمثْ إِ ثْقدَّارذْ ثْڒَاثِينْ شِيقْلُو.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","”ؤُشَا مَاڒَا ذ إِجّْ ن ؤُبْڒِيغْ زِي خمْسَا أَڒْ عِيشْرِينْ ن إِسڭّْوُوسَا، خنِّي أَذْ ثِيڒِي ڒْقِيمثْ إِ ثْقدَّارذْ إِ يِيجّْ ن ورْيَازْ عِيشْرِينْ شِيقْلُو ؤُ إِ يِيشْثْ ن ثمْغَارْثْعشْرَا شِيقْلُو.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","”مَاڒَا ذ إِجّْ ن ؤُحنْجِيرْ زڭْ يِيجّْ ن ؤُيُورْ أَڒْ خمْسَا ن إِسڭّْوُوسَا، خنِّي أَذْ ثِيڒِي ڒْقِيمثْ إِ ثْقدَّارذْ إِ يِيجّْ ن ورْيَازْ خمْسَا شِيقْلُو ن نُّوقَارْثْ ؤُ إِ يِيشْثْ ن ثمْغَارْثْ ثْڒَاثَا شِيقْلُو ن نُّوقَارْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","”مَاڒَا ذ إِجّْ ن مِّيسْ ن بْنَاذمْ زِي ستِّينْ إِسڭّْوُوسَا نِيغْ سنّجْ، خنِّي، مَاڒَا نتَّا ذ أَرْيَازْ، أَذْ ثِيڒِي ڒْقِيمثْ إِ ثْقدَّارذْ خمّسْطَاشْ شِيقْلُو ؤُ مَاڒَا ذ ثَامْغَارْثْ أَذْ ثِيڒِي ڒْقِيمثْ إِ ثْقدَّارذْعشْرَا ن شِيقْلُو.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","”مَاڒَا ثُوغَا إِژْڒضْ أَطَّاسْ ؤُ وَارْ إِزمَّارْ أَذْ إِوْشْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ، خنِّي أَذْ ث سّْبدّنْ زَّاثْ إِ وُوذمْ ن ؤُكهَّانْ ؤُشَا خنِّي أَذْ إِقدَّارْ ؤُكهَّانْ ڒْقِيمثْ نّسْ. أَذْ ث إِقدَّارْ ؤُكهَّانْ عْلَاحْسَابْ مِينْ إِزمَّارْ أَذْ إِسّْمُونْ ؤُفُوسْ ن ونِّي إِوْشِينْ أَوَاڒْ، أَمُّو إِ ث غَا إِقدَّارْ ؤُكهَّانْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","”مَاڒَا ذ ڒبْهَايمْ إِ زِي غَا قدّْمنْ ثَاوْهِيبْثْ إِ سِيذِي، خنِّي مَارَّا مِينْ زَّايْسنْ غَا إِوْشْ نتَّا إِ سِيذِي، أَذْ يِيڒِي إِقدّسْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","وَارْ إِتّْبذِّيڒْ ؤُ وَارْ إِخدْجفْ أَمُودَّارْ إِشْنَانْ خْ ونِّي إِقبْحنْ نِيغْ أَمُودَّارْ إِقبْحنْ خْ ونِّي إِشْنَانْ. مَاڒَا إِبدّڒْ عَاذْ إِشْثْ ن ڒبْهِيمثْ س إِشْثْ ن ڒبْهِيمثْ نّغْنِي، خنِّي ثَا ذ ثنِّي إِ خْ ت إِبدّڒْ أَذْ إِڒِينْثْ قدّْسنْثْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","مَاڒَا ثدْجَا ذ إِشْثْ ن ڒبْهِيمثْ ثخْمجْ، وَارْ إِعدّڒْ أَذْ ت قدّْمنْ ذ ثَاوْهِيبْثْ إِ سِيذِي، خنِّي أَذْ يَارّْ ڒبْهِيمثْ نِّي أَذْ ثْبدّْ زَّاثْ إِ وُوذمْ ن ؤُكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","أَكهَّانْ أَذْ إِقدَّارْ ڒْقِيمثْ نّسْ جَارْ مِينْ إِشْنَانْ ذ مِينْ وَارْ إِحْڒِينْ. ؤُشَا أَمْ مَامّشْ إِ ت غَا ثْقدَّارذْ شكْ، أَمْ ؤُكهَّانْ، أَمُّو إِ غَا ثِيڒِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","مَاڒَا نتَّا إِخْسْ عَاذْ أَذْ ت إِفْذِي، أَذْ خَاسْ يَارْنِي إِشْثْ ن ثسْغَارْثْ ن ثخْمُوسشْثْ نْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","”مَاڒَا شَا ن يِيجّنْ إِسّْقدّسْ ثَادَّارْثْ نّسْ، مَاحنْذْ أَذْ ثِيڒِي ثْقدّسْ إِ سِيذِي، خنِّي أَذْ إِقدَّارْ ؤُكهَّانْ ڒْقِيمثْ نّسْ جَارْ مِينْ إِشْنَانْ ذ مِينْ إِقبْحنْ. أَمْ مَامّشْ إِقدَّارْ ؤُكهَّانْ ڒْقِيمثْ نّسْ، أَمُّو إِ غَا ثِيڒِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","مَاڒَا ونِّي ت إِسّْقدّْسنْ إِخْسْ أَذْ إِفْذِي ثَادَّارْثْ نّسْ، خنِّي نتَّا أَذْ خَاسْ يَارْنِي إِشْثْ ن ثسْغَارْثْ ن ثخْمُوسشْثْ ن ڒْقِيمثْ إِتّْوَاڭّنْ س نُّوقَارْثْ ؤُشَا أَذْ ثِيڒِي نّسْ عَاوذْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","”مَاڒَا شَا ن يِيجّنْ إِسّْقدّسْ إِ سِيذِي شَا ن ثسْغَارْثْ ن ييَّارْ نِّي غَارسْ إِدْجَانْ، خنِّي أَذْ ثْقدَّارذْ ڒْقِيمثْ نّسْ عْلَاحْسَابْ زَّارِيعثْ نّسْ. زَّارِيعثْ ن إِجّْ ن ؤُحُومِيرْ ن إِمنْذِي أَذْ أَسْ ڭّنْ خمْسِينْ شِيقْلُو. ");
INSERT INTO rifa_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","مَاڒَا ثُوغَا إِسّْقدّسْ إِيَّارْ نّسْ زڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ، خنِّي أَذْ ثذْوڒْ ڒْقِيمثْ ن ييَّارْ ثْبدّْ عْلَاحْسَابْ ڒْقِيمثْ إِ ثْقدَّارذْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","مَاڒَا ثُوغَا إِسّْقدّسْ إِيَّارْ نّسْ أَوَارْنِي إِ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ، خنِّي أَكهَّانْ أَذْ أَسْ إِهْصبْ ڒْقِيمثْ س نُّوقَارْثْ ن إِسڭّْوُوسَا إِقِّيمنْ أَڒْ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ إِ د غَا يَاسنْ ؤُ خنِّي أَذْ ثِيڒِي ڒْقِيمثْ قلّْ خْ ڒْقِيمثْ ثْمُونْ إِ ثُوغَا ثْقدَّارذْ شكْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","مَاڒَا ونِّي إِسّْقدّْسنْ إِيَّارْ، إِخْسْ أَذْ ث إِفْذِي نِيشَانْ، خنِّي أَذْ يَارْنِي إِشْثْ ن ثسْغَارْثْ ن ثخْمُوسشْثْ ذِي نُّوقَارْثْ خْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ ؤُشَا خنِّي أَذْ أَسْ يِيڒِي عَاوذْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","”مَاڒَا وَارْ إِخْسْ أَذْ إِفْذِي إِيَّارْ نِّي نِيغْ مَاڒَا إِزّنْزْ إِيَّارْ إِ يِيجّْ ن ورْيَازْ نّغْنِي، خنِّي وَارْ إِزمَّارْ أَذْ إِتّْوَافْذِي عَاذْ ييَّارْ. ");
INSERT INTO rifa_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","أَوَارْنِي ڒَامِي د-إِفّغْ ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ، أَذْ يِيڒِي إِيَّارْ إِقدّسْ إِ سِيذِي أَمْ يِيجّْ ن ييَّارْ إِتّْوَاحَارّْمنْ قَاعْ. أَذْ يِيڒِي ذ أَڭْڒَا ن ؤُكهَّانْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","”مَاڒَا شَا ن يِيجّنْ إِسّْقدّسْ إِجّْ ن ييَّارْ نِّي إِسْغَا إِ سِيذِي، مَاشَا وَارْ إِدْجِي ييَّارْ ن وَاڭْڒَا نّسْ، ");
INSERT INTO rifa_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","خنِّي أَكهَّانْ أَذْ أَسْ إِحْسبْ تَّامَانْ ن ڒْقِيمثْ إِ ثْقدَّارذْ شكْ أَڒْ أَسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ ؤُشَا نتَّا أَذْ إِخدْجصْ ڒْقِيمثْ إِ ثْقدَّارذْ ذڭْ وَاسّْ نِّي ذ إِجّْ أَمْ إِشْثْ ن ثْمسْڒَاشْثْ ثْقدّسْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ذڭْ ؤُسڭّْوَاسْ ن ؤُسْڒِيوْڒوْ أَذْ د-إِعْقبْ ييَّارْ عَاوذْ إِ ونِّي خْ ث إِسْغَا، إِ ونِّي ثُوغَا غَارْ ثدْجَا ثمُّورْثْ ذ أَڭْڒَا. ");
INSERT INTO rifa_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","أَقدَّارْ أَذْ يِيڒِي عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. أَذْ يِيڒِي شِيقْلُو عِيشْرِينْ جِيرَا.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","”مَاشَا أَمنْزُو، ونِّي إِفَارْزنْ إِ سِيذِي زِي ڒبْهَايمْ أَمْ ؤُمنْزُو، وَارْ إِعدّڒْ أَذْ ث إِسّْقدّسْ ؤُڒَا ذ إِجّنْ، نِيغْ ذ أَفُونَاسْ إِ إِدْجَا نِيغْ ذ إِجّنْ زڭْ وُودْجِي، أَقَا-ث إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","مَاشَا مَاڒَا ثُوغَا-ث زڭْ إِشْثْ ن ڒبْهِيمثْ إِخمْجنْ، إِزمَّارْ أَذْ ت إِفْذِي عْلَاحْصَابْ ڒْقِيمثْ إِ ثْقدَّارذْ شكْ ؤُشَا أَذْ خَاسْ يَارْنِي إِشْثْ ن ثسْغَارْثْ ن ثخْمُوسشْثْ. مَاڒَا وَارْ ثتّْوَافذِّي، خنِّي أَذْ ثمّنْزْ عْلَاحْسَابْ ڒْقدّْ إِ ثْقدَّارذْ شكْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","”مَاشَا ؤُڒَا ذ إِشْثْ ن ڒْحَاجّثْ نِّي إِتّْوَاحَارّْمنْ زڭْ إِجّْ ن ورْيَازْ إِ سِيذِي زِي مَارَّا مِينْ غَارسْ إِدْجَانْ ن إِوْذَانْ ذ ڒبْهَايمْ ذ إِيَّارنْ، وَارْ إِعدّڒْ أَذْ ثمّنْزْ نِيغْ أَذْ ثتّْوَافْذِي. مَارَّا مِينْ إِتّْوَاحَارّْمنْ، أَذْ يِيڒِي ذ أَمْقدَّاسْ قَاعْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","مَارَّا مِينْ إِتّْوَاحَارّْمنْ قَاعْ إِ ؤُثحِّي، مِينْ إِتّْوَاحَارّْمنْ زڭْ إِوْذَانْ، وَارْ إِعدّڒْ أَذْ إِتّْوَافْذِي، مَاشَا إِتّْخصَّا أَذْ إِتّْوَانغْ نِيشَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","”مَارَّا ثِيعْشُورَايْ ن ثمُّورْثْ، زِي زَّارِيعثْ ن ثمُّورْثْ ؤُ زِي ڒْغِيدْجثْ ن ثْشجُّورَا، أَذْ إِڒِينْثْ إِ سِيذِي، أَقَا أَثنْثْ قدّْسنْثْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","مَاڒَا شَا ن يِيجّنْ إِخْسْ أَذْ إِفْذِي شَا زِي ڒعْشُورْ نّسْ، خنِّي أَذْ خَاسْ يَارْنِي إِشْثْ ن ثسْغَارْثْ ذِي خمْسَا. ");
INSERT INTO rifa_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","خْ مَارَّا ثِيعْشُورَايْ زڭْ إِفُونَاسنْ ذ ثْفُونَاسِينْ ذ وُودْجِي، زِي مَارَّا مِينْ إِكِّينْ سَاذُو ؤُزدْجَاضْ ن ؤُمكْسَاوْ، أَذْ يِيڒِي ؤُمُودَّارْ وِيسّْعشْرَا إِقدّسْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","وَارْ إِعدّڒْ أَذْ يَارْزُو مَامّشْ ثشْنَا نِيغْ مَامّشْ وَارْ ثحْڒِي إِ ثدْجَا، ؤُڒَا وَارْ ث إِتّْبذِّيڒْ شَا، مَاشَا مَاڒَا إِبدّڒْ إِ-ث، خنِّي أَمُودَّارْ نِّي ذ ونِّي زِي ث إِ غَا إِبدّڒْ أَذْ إِڒِينْ قدّْسنْ. وَارْ إِعدّڒْ أَذْ إِتّْوَافْذِي.“ ");
INSERT INTO rifa_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","أَقَا ثِينَا ذ ثِيوصَّا نِّي إِ زِي إِوصَّا سِيذِي إِ مُوسَا ؤُ إِ أَيْثْ ن إِسْرَائِيل ذڭْ وذْرَارْ ن سِينَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذِي ڒخْڒَا ن سِينَا، ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ وِيسّْ ثْنَاينْ، ذڭْ ؤُسڭّْوَاسْ وِيسّْ ثْنَاينْ أَوَارْنِي ڒَامِي د-فّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","”كْسِيمْ ڒْقدّْ ن إِسْمَاونْ ن مَارَّا إِرْيَازنْ ن مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل، أَزدْجِيفْ أَزدْجِيفْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","إِتّْخصَّا شكْ ذ هَارُونْ أَذْ ثْحسْبمْ كُوڒْ إِجّْ ذِي إِسْرَائِيل زِي عِيشْرِينْ ن إِسڭّْوُوسَا سنّجْ، مَارَّا إِنِّي د-إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","أَذْ أَومْ إِوْشْ أَفُوسْ إِجّْ ن ورْيَازْ زِي كُوڒْ ثَاقْبِيتْشْ، أَرْيَازْ إِ إِدْجَانْ ذ أَزدْجِيفْ ن ثَادَّارْثْ ن بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","أَقَا ذ إِنَا ذ إِسْمَاونْ ن يرْيَازنْ نِّي ذ أَومْ غَا إِوْشنْ أَفُوسْ: إِ رُوبِينْ، إِلِيصُورْ مِّيسْ ن شَاذَايُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","إِ شِيمْعُونْ، شَالُومِييِيلْ، مِّيسْ ن صُورِييْشَادَّايْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","إِ يَاهُوذَا، نَاحْشُونْ، مِّيسْ ن عَامِّينَاذَابْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","إِ إِسَّاكَارْ، نَاثَانَايِيلْ، مِّيسْ ن صُوغَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","إِ زابُولُونْ، إِلِييَابْ، مِّيسْ ن حِيلُونْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","إِ أَيْثْ ن يُوسُوفْ: إِ إِفْرَايِيمْ، إِلِيشَامَاعْ، مِّيسْ ن أَمِّيهُوذْ، إِ مَانَاسَّا، جَامْلِييِيلْ، مِّيسْ ن فَاذَاهْصُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","إِ بِينْيَامِينْ، أَبِيذَانْ مِّيسْ ن جِيذْعُونِي، ");
INSERT INTO rifa_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","إِ ذَانْ، أَخِيعَازَارْ، مِّيسْ ن عَامِّيشَادَّايْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","إِ أَشِيرْ، فَاجْعِييِيلْ، مِّيسْ ن عُوكْرَانْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","إِ جَاذْ، إِلِييَاسَافْ، مِّيسْ ن ذَاعُويِيلْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","إِ نَافْثَالِي، أَخِيرَاعْ، مِّيسْ ن عِينَانْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","إِنَا ثُوغَا ذ إِنِّي إِتّْوَاڒَاغَانْ زِي ثْمسْمُونْثْ، نِيثْنِي ذ ڒْحُوكَّامْ ن ثْقبَّاڒْ ن إِبَابَاثنْ نْسنْ، إِزدْجِيفنْ خْ ڒُوڒُوفْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","كْسِينْ مُوسَا ذ هَارُونْ إِرْيَازنْ نِّي ثُوغَا إِتّْوَارشْمنْ س إِسْمَاونْ نْسنْ ");
INSERT INTO rifa_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ؤُشَا سّْمُوننْ ثَامسْمُونْثْ مَارَّا ذڭْ وَاسّْ أَمزْوَارُو ن ؤُيُورْ وِيسّْ ثْنَاينْ ؤُشَا نِيثْنِي خبَّارنْ جّْذِيرَا نْسنْ، عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، أَمْ تّْوَازمّمنْ إِسْمَاونْ ن يِينِّي غَارْ إِدْجَا عِيشْرِينْ ن إِسڭّْوُوسَا سنّجْ، أَزدْجِيفْ أَزدْجِيفْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا، أَقَا إِحْسبْ إِ-ثنْ ذِي ڒخْڒَا ن سِينَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","أَيْثْ ن رُوبِينْ، أَمنْزُو ن إِسْرَائِيل: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ - إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ نْسنْ أَزدْجِيفْ أَزدْجِيفْ، كُوڒْ أَرْيَازْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن رُوبِينْ، ثُوغَا أَثنْ ذِي ستَّا ؤُ-ربْعِينْ-أَڒفْ ؤُ-خمْسَا مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","أَيْثْ ن شِيمْعُونْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ - إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ لْعَاذَاذْ ن إِسْمَاونْ نْسنْ، أَزدْجِيفْ أَزدْجِيفْ، كُوڒْ أَرْيَازْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن شِيمْعُونْ ثُوغَا أَثنْ ذِي ثسْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-ثڒْثْ-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","أَيْثْ ن جَاذْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ - إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن جَاذْ ثُوغَا أَثنْ ذِي خمْسَا ؤُ-ربْعِينْ-أَڒفْ ؤُ-ستَّا-مْيَا ؤُ-خمْسِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","أَيْثْ ن يَاهُوذَا: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ - إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، كُوڒْ إِجّنْ إِ د-إِتّفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن يَاهُوذَا ثُوغَا أَثنْ ذِي أَربْعَا ؤُ-سبْعِينْ-أَڒفْ ؤُ-ستَّا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","أَيْثْ ن إِسَّاكَارْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ - إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْصَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن إِسَّاكَارْ ثُوغَا أَثنْ ذِي أَربْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","أَيْثْ ن زابُولُونْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ - إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن زابُولُونْ ثُوغَا أَثنْ ذِي سبْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","أَيْثْ ن يُوسُوفْ: أَيْثْ ن إِفْرَايِيمْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن إِفْرَايِيمْ ثُوغَا أَثنْ ذِي أَربْعِينْ-أَڒفْ ؤُ-خمْسَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","أَيْثْ ن مَانَاسَّا: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن مَانَاسَّا ثُوغَا أَثنْ ذِي ثْنَاينْ ؤُ-ثْڒَاثِينْ-أَڒفْ ؤُ-مِيثَاينْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","أَيْثْ ن بِينْيَامِينْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن بِينْيَامِينْ ثُوغَا أَثنْ ذِي خمْسَا ؤُ-ثْڒَاثِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","أَيْثْ ن ذَانْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن ذَانْ ثُوغَا ثنْ ذِي ثْنَاينْ ؤُ-ستِّينْ-أَڒفْ ؤُ-سبْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","أَيْثْ ن أَشِيرْ: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن أَشِيرْ ثُوغَا ثنْ ذِي وَاحِيثْ ؤُ-ربْعِينْ-أَڒفْ ؤُ-خمْسَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","أَيْثْ ن نَافْثَالِي: ثَارْوَا نْسنْ - تّْوَاستّْفنْ عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، إِنِّي زَّايسْ إِتّْوَاحسْبنْ عْلَاحْسَابْ إِسْمَاونْ ن مَارَّا إِرْيَازنْ زِي عِيشْرِينْ إِسڭّْوُوسَا سنّجْ، مَارَّا ونِّي إِ غَا إِفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","وَاهْ، إِنِّي إِتّْوَاحسْبنْ أَمُّو إِ ثقْبِيتْشْ ن نَافْثَالِي ثُوغَا أَثنْ ذِي ثْڒَاثَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","إِنَا ذ إِنِّي إِتّْوَاحسْبنْ، إِنِّي تّْوَاحسْبنْ س ؤُفُوسْ ن مُوسَا ذ هَارُونْ ذ ڒْحُوكَّامْ ن إِسْرَائِيل، ثنْعَاشْ ن يرْيَازنْ، إِجّنْ ورْيَازْ إِ ثَادَّارْثْ ن بَابَاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","مَارَّا إِنِّي إِتّْوَاحسْبنْ زڭْ أَيْثْ ن إِسْرَائِيل - أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثَادَّارْثْ ن إِبَابَاثنْ نْسنْ - مَارَّا إِنِّي غَارْ إِدْجَا عِيشْرِينْ ن إِسڭّْوُوسَا سنّجْ، كُوڒْ  إِجّْ ونِّي د-إِتّفّْغنْ أَكْ-ذ ڒْعسْكَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","وَاهْ، مَارَّا إِنِّي إِتّْوَاحسْبنْ ثُوغَا أَثنْ ذِي ستَّا-مْيَا ؤُ-طڒْثْ-أَڒَافْ ؤُ-خمْسَا-مْيَا ؤُ-خمْسِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","إِلَاوِييّنْ وَارْ شَارْشنْ شَا جَارْ أَسنْ ذِي ڒحْسَابْ ذِي طّْوعْ ن ثقْبِيتْشْ ن إِبَابَاثنْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","مِينْزِي سِيذِي ثُوغَا إِسِّيوڒْ أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","”مْغِيرْ ثَاقْبِيتْشْ ن لَاوِي وَارْ ت تّحْسبْ شَا ؤُ وَارْ ت زمِّي شَا أَزدْجِيفْ أَزدْجِيفْ جَارْ أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","مَاشَا إِتّْخصَّا شكْ س يِيخفْ نّشْ، أَذْ ثڭّذْ إِلَاوِييّنْ خْ ثْزذِّيغْثْ ن شّْهَاذثْ ؤُ خْ مَارَّا ڒقْشُوعْ نّسْ ؤُ خْ مَارَّا مِينْ ذ أَسْ د-يُوسِينْ. نِيثْنِي أَذْ أَرْبُونْ ثَازذِّيغْثْ أَكْ-ذ ڒقْشُوعْ نّسْ مَارَّا، ؤُشَا أَذْ ذَايسْ سخَّارنْ. إِتّْخصَّا أَذْ وْثنْ إِقِيضَانْ نْسنْ مِينْ د-إِنّْضنْ إِ ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","مَاڒَا أَذْ ثتّْوَافْسِي ثْزذِّيغْثْ، أَذْ ت هذْمنْ إِلَاوِييّنْ ؤُشَا مَاڒَا ثِيوضْ ثْزذِّيغْثْ غَارْ ڒْمَارْڭهْ أَنضْفَارْ، خنِّي أَذْ ت سّْبدّنْ إِلَاوِييّنْ عَاوذْ. مَاڒَا د-إِقَارّبْ شَا ن ؤُبَارَّانِي، خنِّي نتَّا أَذْ إِتّْوَانغْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","أَيْثْ ن إِسْرَائِيل أَذْ وْثنْ إِقِيضَانْ ن ڒْمَارْڭحْ نْسنْ، كُوڒْ إِجّْ غَارْ ثْعدْجَانْثْ نّسْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","إِلَاوِييّنْ أَذْ وْثنْ إِقِيضَانْ نْسنْ غَارْ كُوڒْ جِّيهثْ ن ثْزذِّيغْثْ ن شّْهَاذثْ، حِيمَا وَارْ إِتِّيڒِي ؤُذُوقّزْ ن وغْضَابْ خْ ثْمسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل. إِتّْخصَّا إِ إِلَاوِييّنْ أَذْ حْضَانْ خْ ثْزذِّيغْثْ ن شّْهَاذثْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ؤُشَا ڭِّينْ أَيْثْ ن إِسْرَائِيل س مَارَّا مِينْ يُومُورْ سِيذِي إِ مُوسَا، وَاهْ، أَمُّو إِ-ث ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","”أَيْثْ ن إِسْرَائِيل أَذْ وْثنْ إِقِيضَانْ نْسنْ كُوڒْ إِجّْ غَارْ ثْعدْجَانْثْ نّسْ، غَارْ ڒعْڒَامَاثْ ن ثَادَّارْثْ ن إِبَابَاثنْ نْسنْ. أَذْ وْثنْ إِقِيضَانْ نْسنْ شْوَايْثْ غَارْ ڒَاڭّْوَاجْ غَارْ مَارَّا إِغزْذِيسنْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","إِنِّي إِدْجَانْ سَاذُو ن ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن يَاهُوذَا أَذْ وْثنْ إِقِيضَانْ نْسنْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ غَارْ شَّارْقْ، غَارْ مَانِيسْ د-ثْنقَّارْ ثْفُوشْثْ. نَاحْشُونْ، مِّيسْ ن عَامِّينَاذَابْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن يَاهُوذَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي أَربْعَا ؤُ-سبْعِينْ-أَڒفْ ؤُ-ستَّا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","زَّاثسْ أَذْ ثوّثْ ثقْبِيتْشْ ن إِسَّاكَارْ إِقِيضَانْ نّسْ. نَاثَانَايِيلْ، مِّيسْ ن صُوغَارْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن إِسَّاكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي أَربْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","خنِّي ثَاقْبِيتْشْ ن زابُولُونْ. إِلِييَابْ، مِّيسْ ن هِيلُونْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن زابُولُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي سبْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","إِنِّي إِتّْوَاحسْبنْ إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ن يَاهُوذَا ثُوغَا أَثنْ مَارَّا جْمِيعْ ذِي مْيَا ؤُ-ستَّا ؤُ-ثْمَانِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا ن يرْيَازنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. نِيثْنِي أَذْ فسْينْ إِقِيضَانْ نْسنْ أَمزْوَارُو. ");
INSERT INTO rifa_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","غَارْ لْجَانُوبْ أَذْ ثِيڒِي ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن رُوبِينْ. نِيثْنِي أَذْ إِڒِينْ تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. إِلِيصُورْ، مِّيسْ ن شَاذَايُّورْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن رُوبِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي ستَّا ؤُ-ربْعِينْ-أَڒفْ ؤُ-خمْسَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","زَّاثسْ أَذْ ثوّثْ ثقْبِيتْشْ ن شِيمْعُونْ إِقِيضَانْ نّسْ. شَالُومِييِيلْ، مِّيسْ ن صُورِييْشَادَّايْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن شِيمْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي ثسْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-ثڒْثْ-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","خنِّي ثَاقْبِيتْشْ ن جَاذْ. إِلْيَاسَافْ، مِّيسْ ن رَاعُويِيلْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن جَاذْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي خمْسَا ؤُ-ربْعِينْ-أَڒفْ ؤُ-ستَّا-مْيَا ؤُ-خمْسِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","إِنِّي إِتّْوَاحسْبنْ إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ن رُوبِينْ، ثُوغَا أَثنْ مَارَّا ذِي مْيَا ؤُ-وَاحِيثْ ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا ؤُ-خمْسِينْ ن يرْيَازنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. نِيثْنِي أَذْ فسْينْ إِقِيضَانْ نْسنْ وِيسّْ ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","خنِّي أَذْ إِتّْوَافْسِي ؤُقِيضُونْ ن ؤُمْسَاڭَارْ أَكْ-ذ ڒْمَارْڭحْ ن إِلَاوِييّنْ، ذِي ڒْوسْطْ ن مَارَّا ڒْعسْكَارْ. أَمْ مَامّشْ غَا وْثنْ إِقِيضَانْ نْسنْ، أَمُّو إِتّْخصَّا أَذْ مُّوطِّيينْ عَاوذْ، كُوڒْ إِجّْ ذڭْ ومْشَانْ نّسْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثِيعدْجَانِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","غَارْ ڒْغَارْبْ أَذْ ثِيڒِي ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن إِفْرَايِيمْ. نِيثْنِي أَذْ إِڒِينْ تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. إِلِيشَامَاعْ، مِّيسْ ن عَامِّيهُوذْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن إِفْرَايِيمْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي أَربْعِينْ-أَڒفْ ؤُ-خمْسَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","زَّاثسْ أَذْ ثِيڒِي ثقْبِيتْشْ ن مَانَاسَّا. جَامْلِييِيلْ، مِّيسْ ن فَاذَاهْصُورْ أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن مَانَاسَّا. ");
INSERT INTO rifa_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي ثْنَاينْ ؤُ-ثْڒَاثِينْ-أَڒفْ ؤُ-مِيثَايْنْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","خنِّي ثَاقْبِيتْشْ ن بِينْيَامِينْ. أَبِيذَانْ، مِّيسْ ن جِيذْعُونِي، أَذْ يِيڒِي ذ ڒْحْكامْ ن أَيْثْ ن بِينْيَامِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي خمْسَا ؤُ-طْڒَاثِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","إِنِّي إِتّْوَاحسْبنْ إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ن إِفْرَايِيمْ، ثُوغَا أَثنْ ذِي مْيَا ؤُ-ثْمنْيَا-أَڒفْ ؤُ-مْيَا ن يرْيَازنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. نِيثْنِي أَذْ فسْينْ إِقِيضَانْ نْسنْ وِيسّْ ثْڒَاثَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","غَارْ شّْمَالْ أَذْ ثِيڒِي ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن ذَانْ. نِيثْنِي أَذْ إِڒِينْ تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. أَخِيعَازَارْ، مِّيسْ ن عَامِّيشَادَّايْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن دَان. ");
INSERT INTO rifa_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي ثْنَاينْ ؤُ-ستِّينْ-أَڒفْ ؤُ-سبْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","زَّاثسْ أَذْ ثوّثْ ثقْبِيتْشْ ن أَشِيرْ إِقِيضَانْ نّسْ. فَاجْعِييِيلْ، مِّيسْ ن عُوكْرَانْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن أَشِيرْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي وَاحِيثْ ؤُ-ربْعِينْ-أَڒفْ ؤُ-خمْسَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","خنِّي ثَاقْبِيتْشْ ن نَافْثَالِي. أَخِيرَاعْ، مِّيسْ ن عِينَانْ، أَذْ يِيڒِي ذ ڒْحَاكمْ ن أَيْثْ ن نَافْثَالِي. ");
INSERT INTO rifa_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","إِنِّي إِتّْوَاحسْبنْ إِ ڒْعسْكَارْ نّسْ، ثُوغَا أَثنْ ذِي ثْڒَاثَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-أَربْعَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","إِنِّي إِتّْوَاحسْبنْ إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ن ذَانْ، ثُوغَا أَثنْ ذِي مْيَا ؤُ-سبْعَا ؤُ-خمْسِينْ-أَڒفْ ؤُ-ستَّا-مْيَا ن يرْيَازنْ. نِيثْنِي أَذْ فسْينْ إِقِيضَانْ نْسنْ ذ أَنڭَّارُو، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثِيعدْجَانِينْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","إِنَا ذ إِنِّي إِتّْوَاحسْبنْ ن أَيْثْ ن إِسْرَائِيل، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثَادَّارْثْ ن إِبَابَاثنْ نْسنْ. مَارَّا إِنِّي إِتّْوَاحسْبنْ ذِي ڒمْرَاڭحْ ن ڒْعسْكَارْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ، ثُوغَا أَثنْ ذِي ستَّا-مْيَا ؤُ-ثڒْثْ-أَڒَافْ ؤُ-خمْسَا-مْيَا ؤُ-خمْسِينْ ن يرْيَازنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","إِلَاوِييّنْ جَارْ أَيْثْ ن إِسْرَائِيل وَارْ تّْوَاحسْبنْ شَا، نِيشَانْ أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ؤُشَا ڭِّينْ أَيْثْ ن إِسْرَائِيل أَمْ مَامّشْ مَارَّا مِينْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا: أَمْ مَامّشْ وْثِينْ إِقِيضَانْ نْسنْ س ؤُستّفْ غَارْ ثْعدْجَانِينْ نْسنْ، أَمُّو إِ غَا فسْينْ إِقِيضَانْ نْسنْ عَاوذْ، كُوڒْ إِجّنْ إِتّْوَاستّفْ عْلَاحْسَابْ ڒَادْجَاثْ نّسْ، غَارْ ثَادَّارْثْ ن إِبَابَاثنْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","أَقَا إِنَا ذ ثَارْوَا ن هَارُونْ ذ مُوسَا ذڭْ وُوسَّانْ نِّي إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا خْ وذْرَارْ ن سِينَا. ");
INSERT INTO rifa_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","أَقَا إِنَا ذ إِسْمَاونْ ن وَارَّاوْ ن هَارُونْ: نَاذَابْ ذ أَمنْزُو، خنِّي أَبِيهُو، أَلِيعَازَارْ ذ إِثَامَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","أَقَا إِنَا ذ إِسْمَاونْ ن وَارَّاوْ ن هَارُونْ، إِكهَّاننْ إِنِّي إِتّْوَاذهْننْ ؤُ إِنِّي إِتّْوَاڒقّْمنْ أَمْ يِيكهَّاننْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","مَاشَا نَاذَابْ ذ أَبِيهُو مُّوثنْ زَّاثْ إِ وُوذمْ ن سِيذِي، ؤُمِي قدّْمنْ ثِيمسِّي ثَاڒْغِيبْثْ زَّاثْ إِ وُوذمْ ن سِيذِي ذِي ڒخْڒَا ن سِينَا. وَارْ ثُوغِي غَارْسنْ أَرَّاوْ. س ؤُيَا ثُوغَا أَلِيعَازَارْ ذ إِثَامَارْ سخَّارنْ أَمْ ؤُكهَّانْ زَّاثْ إِ وُوذمْ ن بَابَاثْسنْ هَارُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","”سْقَارّبْ-د ثَاقْبِيتْشْ ن لَاوِي ؤُشَا أڭّْ إِ-ثنْ زَّاثْ إِ وُوذمْ ن ؤُكهَّانْ هَارُونْ، حِيمَا أَذْ خَاسْ سخَّارنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","أجّْ إِ-ثنْ أَذْ ڒْهَانْ ثَاسخَّارْثْ نّسْ ذ ثْسخَّارْثْ ن مَارَّا ثَامسْمُونْثْ زَّاثْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، مَاحنْذْ أَذْ كمّْڒنْ ڒْخذْمثْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","أَذْ حْضَانْ خْ مَارَّا ڒقْشُوعْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ طّْفنْ أَحطُّو ن أَيْثْ ن إِسْرَائِيل مَاحنْذْ أَذْ سخَّارنْ ذِي ثْسخَّارْثْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","شكْ أَذْ ثوْشذْ إِلَاوِييّنْ إِ هَارُونْ ؤُ إِ وَارَّاونْ نّسْ. أَقَا ذ يِينَا إِ ذ أَسْ إِمّوْشنْ إِ نتَّا وَاهَا زڭْ أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","أَذْ ثْڒقّْمذْ هَارُونْ ذ وَارَّاوْ نّسْ مَاحنْذْ أَذْ حْضَانْ خْ ثُوكهَّانْثْ. أَبَارَّانِي نِّي إِ دّْ غَا إِقَارّْبنْ أَذْ إِتّْوَانغْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","”خْزَارْ، نشّْ كْسِيغْ إِلَاوِييّنْ زِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل ذڭْ ومْشَانْ ن إِمنْزَا، مَارَّا إِنِّي يَارزْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو جَارْ أَيْثْ ن إِسْرَائِيل. إِلَاوِييّنْ أَذْ إِڒِينْ إِنُو، ");
INSERT INTO rifa_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","مِينْزِي كُوڒْ أَمنْزُو أَقَا إِنُو. ذڭْ وَاسّْ مِينْ ذِي وْثِيغْ مَارَّا إِمنْزَا ذِي ثمُّورْثْ ن مِيصْرَا، أَقَا سّْقدّْسغْ إِ يِيخفْ إِنُو مَارَّا إِمنْزَا ذِي إِسْرَائِيل، زِي بْنَاذمْ أَڒْ ڒْمَاڒْ. نِيثْنِي أَذْ إِڒِينْ إِنُو، نشّْ ذ سِيذِي!“ ");
INSERT INTO rifa_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذِي ڒخْڒَا ن سِينَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","”حْسبْ أَيْثْ ن لَاوِي، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ. مَارَّا إِوثْمَانْ نِّي إِدْجَانْ ذ إِجّْ ن ؤُيُورْ سنّجْ، أَذْ ثنْ ثحْسبْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ؤُشَا مُوسَا إِحْسبْ إِ-ثنْ خْ ڒُومُورْ ن سِيذِي، أَمْ مَامّشْ ذ أَسْ إِوصَّا. ");
INSERT INTO rifa_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ثُوغَا إِنَا ذ أَيْثْ ن لَاوِي أَكْ-ذ إِسْمَاونْ نْسنْ: جَارْشُونْ، ذ قَاهَاثْ ذ مَارَارِي. ");
INSERT INTO rifa_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ثُوغَا إِنَا ذ إِسْمَاونْ ن أَيْثْ ن جَارْشُونْ، عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ: لِيبْنِي ذ شِيمْعِي. ");
INSERT INTO rifa_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","أَيْثْ ن قَاهَاثْ، عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ: عَامْرَامْ ذ يِيصْهَارْ ذ حَابْرُونْ ذ عُوزِّييِيلْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","أَيْثْ ن مَارَارِي، عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ: مَاحْلِي ذ مُوشِي. ثُوغَا إِنَا ذ ڒَادْجَاثْ ن إِلَاوِييّنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","غَارْ جَارْشُونْ ثُوغَا ثدْجَا ڒَادْجْ ن إِلِيبْنِييّنْ ذ ڒَادْجْ ن إِشِيمْعِييّنْ. ثُوغَا ثِينَا ذ ڒَادْجَاثْ ن إِجَارْشُونِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ڒْقدّْ ن يِينِّي زَّايْسنْ إِتّْوَاحسْبنْ، ن مَارَّا إِوثْمَانْ زڭْ إِجّْ ن ؤُيُورْ سنّجْ، أَقَا ڒْقدّْ نِّي ن يِينِّي زَّايْسنْ إِتّْوَاحسْبنْ ثُوغَا ذِي سبْعَا-أَڒَافْ ؤُ-خمْسَا-مْيَا. ");
INSERT INTO rifa_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","وْثِينْثْ ڒَادْجَاثْ ن إِجَارْشُونِييّنْ إِقِيضَانْ نْسنْ غَارْ ضفَّارْ ن ثْزذِّيغْثْ، غَارْ ڒْغَارْبْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ثُوغَا إِلْيَاسَافْ، مِّيسْ ن لَايِيلْ، ذ ڒْحَاكمْ ن ثَادَّارْثْ ن بَابَاثْسنْ ن إِجَارْشُونِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","زِي جِّيهثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ حْضَانْ أَيْثْ ن جَارْشُونْ خْ ثْزذِّيغْثْ، خْ ؤُقِيضُونْ أَكْ-ذ ثْسقَّافِينْ نّسْ، خْ وَارْوَاقْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","خْ ڒِيزَارَاثْ ن ڒمْرَاحْ ذ وَارْوَاقْ غَارْ وَاذَافْ ن ڒمْرَاحْ إِ زِي ثتّْوَانّضْ ثْزذِّيغْثْ ذ ؤُعَالْطَارْ، ؤُ خْ إِفِيڒَانْ نّسْ، ؤُڒَا خْ مَارَّا مِينْ د-إِتَّاسنْ أَكْ-ذ ثْسخَّارْثْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","زِي قَاهَاثْ ثُوغَا إِقَّارْصْ-د ڒَادْجْ ن إِعَامْرَامِييّنْ ذ ڒَادْجْ ن إِصْهَارِييّنْ ذ ڒَادْجْ ن إِحِيبْرُونِييّنْ ذ ڒَادْجْ ن إِعَازِييِيلِييّنْ. ثُوغَا ثِينَا ذ ڒَادْجَاثْ ن إِقَاهَاثِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ثُوغَا ڒْقدّْ ن مَارَّا إِوثْمَانْ زڭْ إِجّْ ن ؤُيُورْ سنّجْ ثمْنْ-أَڒَافْ ؤُ-ستَّا-مْيَا. نِيثْنِي حْضَانْ خْ زَّاوشْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","وْثِينْثْ ڒَادْجَاثْ ن أَيْثْ ن قَاهَاثْ إِقِيضَانْ نْسنْ غَارْ ؤُغزْذِيسْ ن ثْزذِّيغْثْ، غَارْ لْجَانُوبْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","إِلِيصَافَانْ، مِّيسْ ن عُوزِّييِيلْ، ثُوغَا ذ ڒْحَاكمْ ن ثَادَّارْثْ ن بَابَاثْسنْ ن ڒَادْجَاثْ ن إِقُوهَاثِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","نِيثْنِي ثُوغَا حطَّانْ خْ تَّابُوثْ ذ ثْزوْضَا ذ ڒْقنْذِيڒْ ذ إِعَالْطَارنْ ؤُ خْ ڒقْشُوعْ ن زَّاوشْثْ إِقدّْسنْ إِ سّْخذْمنْ ؤُ خْ ؤُڒحَّافْ، وَاهْ، خْ مَارَّا إِ د-إِتَّاسنْ أَكْ-ذ ثْسخَّارْثْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ثُوغَا أَلِيعَازَارْ، مِّيسْ ن ؤُكهَّانْ هَارُونْ، ذ ڒْحَاكمْ أَمزْوَارُو قَاعْ خْ مَارَّا ڒْحُوكَّامْ ن لَاوِي. نتَّا إِطّفْ أَشْبَارْ خْ يِينِّي ثُوغَا إِحطَّانْ خْ زَّاوشْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","زِي مَارَارِي ثُوغَا إِقَّارْصْ ڒَادْجْ ن إِمَاحْلِييّنْ ذ ڒَادْجْ ن إِمُوشِييّنْ. ثُوغَا ثِينَا ذ ڒَادْجَاثْ ن مَارَارِي. ");
INSERT INTO rifa_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ثُوغَا ڒْقدّْ ن يِينِّي زَّايْسنْ إِتّْوَاحسْبنْ، ن مَارَّا إِوثْمَانْ زڭْ إِجّْ ن ؤُيُورْ سنّجْ، ذِي ستَّا-أَڒَافْ ؤُ-مِيثَايْنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ثُوغَا سُورِييِيلْ، مِّيسْ ن أَبِيخَايِيلْ، ذ ڒْحَاكمْ ن ثَادَّارْثْ ن بَابَاثْسنْ ن ڒَادْجَاثْ ن مَارَارِي. نِيثْنِي وْثِينْ إِقِيضَانْ نْسنْ غَارْ ؤُغزْذِيسْ ن ثْزذِّيغْثْ، غَارْ شَّامَالْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","أَيْثْ ن مَارَارِي ثُوغَا ثطّْفنْ أَشْبَارْ مَاحنْذْ أَذْ وْشنْ ثَايْنِيثْ إِ مَارَّا ثِيفڒْوِينْ ن ثْزذِّيغْثْ، إِ ثْحنْيَا ن ؤُعَارّضْ، إِ إِپِيلَارنْ نّسْ، إِ ثْيَارْسَاوِينْ نّسْ ؤُ إِ مَارَّا ڒقْشُوعْ نّسْ، وَاهْ. إِ مَارَّا مِينْ د-إِتَّاسنْ أَكْ-ذ ثْسخَّارْثْ نِّي، ");
INSERT INTO rifa_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ؤُڒَا إِ إِپِيلَارنْ نِّي د-إِنّْضنْ إِ ڒمْرَاحْ أَكْ-ذ ثْيَارْسَاوِينْ نْسنْ ذ ڒوْثَاذْ نْسنْ ذ إِفِيڒَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","مُوسَا ذ هَارُونْ أَكْ-ذ وَارَّاوْ نّسْ وْثِينْ إِقِيضَانْ نْسنْ زَّاثْ إِ وُوذمْ ن ثْزذِّيغْثْ، زَّاثْ إِ وُوذمْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، غَارْ شَّارْقْ مَانِيسْ د-ثْنقَّارْ ثْفُوشْثْ. نِيثْنِي حْضَانْ خْ زَّاوشْثْ إِقدّْسنْ ذِي طّْوعْ ن أَيْثْ ن إِسْرَائِيل. أَبَارَّانِي نِّي د-إِقَارّْبنْ، ثُوغَا إِتّْخصَّا أَذْ إِتّْوَانغْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","مَارَّا إِنِّي إِتّْوَاحسْبنْ ن إِلَاوِييّنْ، إِنِّي إِحْسبْ مُوسَا أَكْ-ذ هَارُونْ عْلَاحْسَابْ ڒُومُورْ ن سِيذِي، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، مَارَّا إِوثْمَانْ زڭْ إِجّْ ن ؤُيُورْ سنّجْ، ثُوغَا أَثنْ ذِي ثْنَاينْ ؤُ-عِيشْرِينْ-أَڒفْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","إِنَّا سِيذِي إِ مُوسَا: ”حْسبْ مَارَّا إِمنْزَا ن إِوثْمَانْ ن أَيْثْ ن إِسْرَائِيل، زڭْ إِجّْ ن ؤُيُورْ سنّجْ، ؤُشَا كْسِي ڒْقدّْ ن إِسْمَاونْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","أَذْ ثكْسِيذْ إِلَاوِييّنْ إِ نشّْ - نشّْ ذ سِيذِي! - ذڭْ ومْشَانْ ن مَارَّا إِمنْزَا جَارْ أَيْثْ ن إِسْرَائِيل ؤُڒَا ذ ڒبْهَايمْ ن إِلَاوِييّنْ ذڭْ ومْشَانْ ن مَارَّا إِمنْزَا جَارْ ڒبْهَايمْ ن أَيْثْ ن إِسْرَائِيل.“ ");
INSERT INTO rifa_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ؤُشَا إِحْسبْ مُوسَا مَارَّا إِمنْزَا جَارْ أَيْثْ ن إِسْرَائِيل أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ڒْقدّْ ن إِسْمَاونْ ن مَارَّا إِمنْزَا إِوثْمَانْ ن إِجّْ ن ؤُيُورْ سنّجْ، ن يِينِّي زَّايْسنْ إِتّْوَاحسْبنْ، ثُوغَا أَثنْ ذِي ثْنَاينْ ؤُ-عِيشْرِينْ-أَڒفْ ؤُ-مِيثَايْنْ ؤُ-ثْڒَاثَا ؤُ-سبْعِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","”كْسِي إِلَاوِييّنْ ذڭْ ومْشَانْ ن مَارَّا إِمنْزَا جَارْ أَيْثْ ن إِسْرَائِيل ؤُڒَا ذ ڒبْهَايمْ ن إِلَاوِييّنْ ذڭْ ومْشَانْ ن ڒبْهَايمْ نْسنْ، مِينْزِي إِلَاوِييّنْ أَذْ إِڒِينْ إِنُو. أَقَا نشّْ ذ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","زِي جِّيهثْ ن مِيثَاينْ ؤُ-ثْڒَاثَا ؤُ-سبْعِينْ، إِنِّي إِتّْخصَّا أَذْ تّْوَافْذِينْ، مَاغَارْ نِيثْنِي قِّيمنْ سنّجْ إِ إِلَاوِييّنْ ن إِمنْزَا ن أَيْثْ ن إِسْرَائِيل، ");
INSERT INTO rifa_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","إِتّْخصَّا أَذْ ثكْسِيذْ خمْسَا شِيقْلُو إِ كُوڒْ إِجّْ ن ؤُزدْجِيفْ. أَذْ ث ثكْسِيذْ أَنشْثْ ن شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. شِيقْلُو وَانِيثَا أَقَا ذَايسْ عِيشْرِينْ جِيرَا. ");
INSERT INTO rifa_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","أَذْ ثوْشذْ نُّوقَارْثْ نِّي إِ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ، أَقَا-ت إِ تَّامَانْ ن ؤُفكِّي ن يِينِّي إِقِّيمنْ سنّجْ إِ ڒْقدّْ ن إِلَاوِييّنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","خنِّي إِكْسِي مُوسَا نُّوقَارْثْ ن تَّامَانْ ن ؤُفكِّي ن يِينِّي إِقِّيمنْ سنّجْ ن يِينِّي إِتّْوَافْذِينْ س إِلَاوِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ؤُشَا إِطّفْ نُّوقَارْثْ نِّي زڭْ إِمنْزَا ن أَيْثْ ن إِسْرَائِيل: أَڒفْ ؤُ-ثڒْثْ-مْيَا ؤُ-خمْسَا ؤُ-ستِّينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ؤُ مُوسَا إِوْشَا نُّوقَارْثْ ن يِينِّي إِوْشِينْ تَّامَانْ ن ؤُفكِّي إِ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ، عْلَاحْسَابْ أَوَاڒْ ن ؤُقمُّومْ ن سِيذِي، أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","”حْسبْ أَيْثْ ن قَاهَاثْ أَزدْجِيفْ أَزدْجِيفْ جَارْ أَيْثْ ن لَاوِي، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","زِي ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ أَڒْ خمْسِينْ ن إِسڭّْوُوسَا، مَارَّا ونِّي إِ غَا يَاذْفنْ غَارْ ڒْعسْكَارْ مَاحنْذْ أَذْ يڭّْ ڒْخذْمثْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ذ ثَا إِ غَا يِيڒِينْ ذ ثَاسخَّارْثْ ن أَيْثْ ن قَاهَاثْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ: أَحطُّو خْ وقْذَاسْ خْ ؤُقدَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","خْمِي د غَا فسْينْ ڒْمَارْڭحْ، أَذْ د-يَاسْ هَارُونْ ذ وَارَّاوْ نّسْ ؤُشَا أَذْ كّْسنْ أَڒحَّافْ إِ إِدْجَانْ إِ دُّورِي ؤُشَا أَذْ زَّايسْ سّْذُورْينْ تَّابُوثْ ن شّْهَاذثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","إِتّْخصَّا أَذْ خَاسْ ڭّنْ إِجّْ ن دُّورِي ن إِڒْمَاونْ ن دّنْفِيڒَاثْ ؤُشَا أَذْ خَاسْ بزّْعنْ إِجّْ ن دُّورِي مَارَّا ذ أَذحْمِي ؤُشَا أَذْ أَسْ ڭّنْ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","أَذْ بزّْعنْ إِشْثْ ن ثْجَارْثِيڒْطْ ثَاذحْمِيثْ خْ ثْزوْضَا إِ وغْرُومْ ن وسْشَانْ ؤُشَا أَذْ خَاسْ ڭّنْ طّْبَاصِي، ثِيغنْجَايِينْ ذ ڒْكِيسَانْ ذ إِغَارَّافنْ س إِنِّي إِ غَا كبّنْ. ؤُشَا إِتّْخصَّا أَذْ خَاسْ يِيڒِي وغْرُومْ ن ڒبْذَا. ");
INSERT INTO rifa_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","أَوَارْنِي ؤُيَا أَذْ خَاسْ بزّْعنْ إِجّْ ن دُّورِي أَزڭّْوَاغْ إِحذْقنْ ؤُشَا أَذْ ت ذْڒنْ عَاوذْ س إِجّْ ن دُّورِي ن إِڒْمَاونْ ن دّنْفِيڒَاثْ ؤُشَا أَذْ أَسْ ڭّنْ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","خنِّي أَذْ كْسِينْ إِشْثْ ن ثْجَارْثِيڒْثْ ثَاذحْمَانِيثْ ؤُشَا أَذْ زَّايسْ ذْڒنْ ڒْقنْذِيڒْ إِ ثْفَاوْثْ ؤُڒَا ذ ڒفْنَارَاثْ نّسْ ذ ثْجقَّاضِينْ ن ثفْثِيتْشْ نّسْ ذ ثْمجْمَارِينْ نّسْ ذ مَارَّا ڒقْشُوعْ نّسْ إِ زّشْثْ ذِي طّْوعْ ن ثْسخَّارْثْ إِ ڒْقنْذِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","أَذْ ڭّنْ ڒْْقنْذِيڒْ-أَ ذ مَارَّا ڒقْشُوعْ نّسْ ذڭْ إِجّْ ن دُّورِي ن إِڒْمَاونْ ن دّنْفِيڒَاثْ ؤُشَا أَذْ ث سَّارْسنْ خْ دْجُوحْ ن ثْكسِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","أَذْ بزّْعنْ إِجّْ ن دُّورِي أَذحْمَانِي خْ ؤُعَالْطَارْ ن ڒبْخُورْ ؤُشَا أَذْ ث ذْڒنْ عَاوذْ س يِيجّْ ن دُّورِي ن إِڒْمَاونْ ن دّنْفِيڒَاثْ ؤُشَا أَذْ أَسْ ڭّنْ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ؤُشَا أَذْ كْسِينْ مَارَّا ڒقْشُوعْ إِ ثْسخَّارْثْ إِ سّْخدّْمنْ ذِي زَّاوشْثْ إِقدّْسنْ ؤُشَا أَذْ ثنْ ڭّنْ ذڭْ إِجّْ ن دُّورِي أَذحْمَانِي ؤُشَا أَذْ ث ذْڒنْ س يِيجّْ ن دُّورِي ن إِڒْمَاونْ ن دّنْفِيڒَاثْ، خنِّي أَذْ سَّارْسنْ أَيَا خْ دْجُوحْ ن ثْكسِّيثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","أَذْ كّْسنْ مِينْ إِقِّيمنْ ن ثَاذُونْثْ ن ؤُعَالْطَارْ ؤُشَا أَذْ خَاسْ بزّْعنْ إِشْثْ ن ثْجَارْثِيڒْثْ ثَارْجُووَانِيثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","أَذْ خَاسْ سَّارْسنْ مَارَّا ڒقْشُوعْ إِ سّْخذْمنْ إِ ثْسخَّارْثْ: ثِيمجْمَارِينْ، فُورْشَايَاثْ، إِغنْجَاينْ، طَّاوْيَاثْ إِ ؤُرُوشِّي ذ مَارَّا دُّوزَانْ ن ؤُعَالْطَارْ. ثِيوَّا نّسْ أَذْ بزّْعنْ إِجّْ ن دُّورِي ن إِڒْمَاونْ ن دّنْفِيڒَاثْ ؤُشَا أَذْ أَسْ ڭّنْ إِعُومَاذْ نّسْ إِ ثَاربُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","خْمِي غَا إِكمّڒْ هَارُونْ ذ وَارَّاوْ نّسْ دُّورِي ن زَّاوشْثْ إِقدّْسنْ ذ مَارَّا ڒقْشُوعْ ن زَّاوشْثْ إِقدّْسنْ خْمِي غَا فسْينْ إِقِيضَانْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ، خنِّي أَذْ د-أَسنْ وَارَّاوْ ن قُوهَاثْ حِيمَا أَذْ أَرْبُونْ مَارَّا، مَاشَا إِتّْخصَّا وَارْ تّْحِيذِينْ مِينْ إِدْجَانْ إِقدّْسنْ، مِينْزِي مَاڒَا لَّا أَذْ مّْثنْ. مَانْ أَيَا ذ مِينْ إِتّْخصَّا أَذْ أَرْبُونْ وَارَّاوْ ن قَاهَاثْ ذِي ثْمسْڒَاشْثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","أَلِيعَازَارْ، مِّيسْ ن ؤُكهَّانْ هَارُونْ، أَذْ إِطّفْ أَشْبَارْ خْ زّشْثْ إِ ثْفَاوْثْ ذ ڒبْخُورْ إِتّْفُوحنْ ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ ن ڒبْذَا ذ زّشْثْ إِ وذْهَانْ، وَاهْ، هَارُونْ أَذْ إِطّفْ أَشْبَارْ خْ ثْزذِّيغْثْ مَارَّا ؤُ خْ مَارَّا مِينْ ذَايسْ، ڒَا خْ مِينْ إِدْجَانْ ذِي زَّاوشْثْ إِقدّْسنْ ؤُڒَا خْ ڒقْشُوعْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","”غَارْومْ أَذْ ثْقضْعمْ ثَاقْبِيتْشْ ن ڒَادْجَاثْ ن إِقَاهَاثِييّنْ زِي ڒْوسْطْ ن إِلَاوِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ڭّمْ كِيسنْ أَمُّو حِيمَا أَذْ دَّارنْ، وَارْ تّْمتِّينْ خْمِي د غَا قَارّْبنْ غَارْ وقْذَاسْ خْ ؤُقدَّاسْ: إِتّْخصَّا أَسْ إِ هَارُونْ ذ وَارَّاوْ نّسْ أَذْ د-أَذْفنْ ؤُشَا أَذْ ڭّنْ كُوڒْ أَرْيَازْ ذِي ڒْخذْمثْ نّسْ ؤُ ذِي دّْقڒْ إِ إِتّْخصَّا أَذْ يَارْبُو. ");
INSERT INTO rifa_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","وَارْ إِعدّڒْ أَذْ أَذْفنْ مَاحنْذْ أَذْ ژَترنْ زَّاوشْثْ إِقدّْسنْ، مْغِيرْ إِ يِيشْثْ ن ورْمَاشْ ن وَابْڒِيونْ وَاهَا، مَاغَارْ خنِّي أَذْ مّْثنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","”حْسبْ عَاوذْ أَيْثْ ن جَارْشُونْ أَزدْجِيفْ أَزدْجِيفْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","أَذْ ثنْ ثْحسْبذْ زِي ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ، أَڒْ خمْسِينْ ن إِسڭّْوُوسَا، كُوڒْ إِجّْ إِ غَا يَاذْفنْ غَارْ ڒْعسْكَارْ حِيمَا أَذْ يڭّْ ثَاسخَّارْثْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ذ ثَا ذ ثَاسخَّارْثْ ن ڒَادْجَاثْ ن جَارْشُونْ ذِي ثْمسْڒَاشْثْ ن ثْسخَّارْثْ ذ ثَاربُّوثْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","أَذْ أَرْبُونْ ثِيجَارْثِيڒِينْ ن ثْزذِّيغْثْ ذ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ: ثَاسقَّافْثْ نّسْ ذ ثْسقَّافْثْ نّسْ ن إِڒْمَاونْ ن دّنْفِيڒَاثْ نِّي إِ غَا يِيڒِينْ ثِيوَّا نّسْ، ذ وَارْوَاقْ ن وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ذ ڒِيزَارَاثْ ن ڒمْرَاحْ ذ أَرْوَاقْ إِ ثوَّارْثْ ن وَاذَافْ غَارْ ڒمْرَاحْ إِ د-إِنّْضنْ إِ ثْزذِّيغْثْ ذ ؤُعَالْطَارْ ذ مَارَّا إِفِيڒَانْ نْسنْ ذ مَارَّا ڒقْشُوعْ إِ د-إِتَّاسنْ أَكْ-ذ ثْسخَّارْثْ نْسنْ ؤُ مَارَّا مِينْ ذ أَسْ صنّْعنْ، ذ مَانْ أَيَا أَذْ ثِيڒِي ڒْخذْمثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","مَارَّا ڒْخذْمثْ ن أَيْثْ ن جَارْشُونْ ذِي ثْمسْڒَاشْثْ ن مَارَّا ثَاربُّوثْ ذ مَارَّا ثَاسخَّارْثْ نْسنْ، أَذْ ثِيڒِي عْلَاحْسَابْ ڒُومُورْ ن هَارُونْ ذ وَارَّاوْ نّسْ. إِتّْخصَّا أَومْ أَذْ ثنْ ثسّشْنمْ س ؤُحطُّو مَارَّا مِينْ إِتّْخصَّا أَذْ أَرْبُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ثَا ذ ثَاسخَّارْثْ ن ڒَادْجَاثْ ن أَيْثْ ن جَارْشُونْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. نِيثْنِي أَذْ كْسِينْ أَمْنُوسْ إِ ؤُيَا سَاذُو ؤُفُوسْ ن إِثَامَارْ، مِّيسْ ن هَارُونْ، أَكهَّانْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","أَذْ ثْحسْبذْ أَيْثْ ن مَارَارِي، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","أَذْ ثنْ ثْحسْبذْ زِي ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ، أَڒْ خمْسِينْ ن إِسڭّْوُوسَا، مَارَّا ونِّي إِ غَا يَاذْفنْ غَارْ ڒْعسْكَارْ مَاحنْذْ أَذْ إِسخَّارْ ذِي ثْسخَّارْثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ذ ثَا ذ ثَاسْغَارْثْ نْسنْ ذِي ثْربُّوثْ غَارْ مَارَّا ثَاسخَّارْثْ نْسنْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ: ثِيفڒْوِينْ ن ثْزذِّيغْثْ ذ ثْحنْيَا ن ؤُعَارّضْ ذ إِپِيلَارنْ نّسْ ذ ثْيَارْسَاوِينْ نّسْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ذ إِپِيلَارنْ ن ڒمْرَاحْ إِ ذ أَسْ د-إِنّْضنْ أَكْ-ذ ثْيَارْسَاوِينْ نْسنْ ذ ڒوْثَاذْ نْسنْ ذ إِسغْوَانْ نْسنْ، أَقَا ذ ثَا ذ ثَاسْغَارْثْ نْسنْ ذِي ثْربُّوثْ ن مَارَّا ڒقْشُوعْ نْسنْ ؤُ ذِي مَارَّا ثَاسخَّارْثْ إِ د-إِتَّاسنْ أَكْ-ذ مَارَّا مَانْ أَيَا. ڒقْشُوعْ إِ إِتّْخصَّا أَذْ ثنْ أَرْبُونْ، إِتّْخصَّا كنِّيوْ أَذْ ثنْ ثْزمّذْ س إِسْمَاونْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ذ ثَا ذ ثَاسخَّارْثْ ن ڒَادْجَاثْ ن أَيْثْ ن مَارَارِي غَارْ مَارَّا ثَاسخَّارْثْ نْسنْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ سَاذُو ؤُفُوسْ ن إِثَامَارْ، مِّيسْ ن هَارُونْ، أَكهَّانْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","مُوسَا ذ هَارُونْ ذ ڒْحُوكَّامْ ن ثْمسْمُونْثْ حسْبنْ أَيْثْ ن قَاهَاثْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ ؤُ عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","زڭْ ونِّي غَارْ إِدْجَا ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ، أَڒْ ونِّي غَارْ إِدْجَا خمْسِينْ ن إِسڭّْوُوسَا، كُوڒْ إِجّْ إِ غَا يَاذْفنْ مَاحنْذْ أَذْ إِسخَّارْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","إِنِّي زَّايْسنْ إِتّْوَاحسْبنْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، ثُوغَا أَثنْ ذِي أَڒْفَاينْ ؤُ-سبْعَا-مْيَا ؤُ-خمْسِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","إِنَا ذ إِنِّي إِتّْوَاحسْبنْ زِي ڒَادْجَاثْ ن إِقَاهَاثِييّنْ، مَارَّا وِي إِتّْسخَّارنْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، إِنِّي حسْبنْ مُوسَا ذ هَارُونْ خْ ڒُومُورْ ن سِيذِي سَاذُو ؤُفُوسْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","إِنِّي إِتّْوَاحسْبنْ زڭْ أَيْثْ ن جَارْشُونْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ ؤُ عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","زڭْ ونِّي غَارْ إِدْجَا ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ، أَڒْ ونِّي غَارْ إِدْجَا خمْسِينْ ن إِسڭّْوُوسَا، كُوڒْ إِجّْ إِ غَا يَاذْفنْ مَاحنْذْ أَذْ إِسخَّارْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","أَقَا إِنِّي زَّايْسنْ إِتّْوَاحسْبنْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، ثُوغَا أَثنْ ذِي أَڒْفَاينْ ؤُ-ستَّا-مْيَا ؤُ-ثْڒَاثِينْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","إِنَا ذ إِنِّي إِتّْوَاحسْبنْ ن ڒَادْجَاثْ ن أَيْثْ ن جَارْشُونْ، مَارَّا وِي إِتّْسخَّارنْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، إِنِّي حسْبنْ مُوسَا ذ هَارُونْ خْ ڒُومُورْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","إِنَا ذ إِنِّي إِتّْوَاحسْبنْ ن ڒَادْجَاثْ ن أَيْثْ ن مَارَارِي، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","زڭْ ونِّي غَارْ إِدْجَا ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ، أَڒْ ونِّي غَارْ إِدْجَا خمْسِينْ ن إِسڭّْوُوسَا، كُوڒْ إِجّْ إِ غَا يَاذْفنْ ذِي ڒْعسْكَارْ مَاحنْذْ أَذْ إِسخَّارْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","أَقَا إِنِّي زَّايْسنْ إِتّْوَاحسْبنْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ، ثُوغَا أَثنْ ذِي ثڒْثْ-أَڒَافْ ؤُ-مِيثَاينْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","إِنَا ذ إِنِّي إِتّْوَاحسْبنْ ن ڒَادْجَاثْ ن مَارَارِي، إِنِّي حسْبنْ مُوسَا ذ هَارُونْ خْ ڒُومُورْ ن سِيذِي سَاذُو ؤُفُوسْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","مَارَّا إِنِّي إِتّْوَاحسْبنْ، إِنِّي حسْبنْ مُوسَا ذ هَارُونْ ذ ڒْحُوكَّامْ ن إِسْرَائِيل زڭْ إِلَاوِييّنْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒَادْجَاثْ نْسنْ ؤُ عْلَاحْسَابْ ثُوذْرِينْ ن إِبَابَاثنْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","زڭْ ونِّي غَارْ إِدْجَا ثْڒَاثِينْ ن إِسڭّْوُوسَا سنّجْ أَڒْ ونِّي غَارْ إِدْجَا خمْسِينْ ن إِسڭّْوُوسَا، مَارَّا ونِّي إِ غَا يَاذْفنْ مَاحنْذْ أَذْ إِڭّْ ڒْخذْمثْ ن ثْسخَّارْثْ ؤُ ڒْخذْمثْ ن ثْربُّوثْ ن دّْقُوڒَاثْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","أَقَا إِنِّي زَّايْسنْ إِتّْوَاحسْبنْ ثُوغَا أَثنْ ذِي ثمْنْ-أَڒَافْ ؤُ-خمْسَا-مْيَا ؤُ-ثْمَانِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","نِيثْنِي تّْوَاحسْبنْ خْ ڒُومُورْ ن سِيذِي سَاذُو ؤُفُوسْ ن مُوسَا، كُوڒْ أَرْيَازْ إِتّْوَاڒقّمْ ذِي ثْسخَّارْثْ نّسْ ؤُ خْ دّْقڒْ نّسْ. نِيثْنِي تّْوَاحسْبنْ زَّايسْ أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","”ؤُمُورْ أَيْثْ ن إِسْرَائِيل أَذْ سُّوفّْغنْ مَارَّا أَيْثْ ن ڒْبَارْصْ زِي ڒْمَارْڭحْ ن ڒْعسْكَارْ، ؤُڒَا ذ مَارَّا إِنِّي غَارْ إِدْجَا ؤُسيّڒْ ذ مَارَّا إِنِّي إِتّْوَاسّْخمْجنْ زڭْ إِشْثْ ن ڒْخشْبثْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","أَذْ ثنْ ثسُّوفّْغمْ، أَمْ يرْيَازنْ أَمْ ثمْغَارِينْ. كنِّيوْ أَذْ ثنْ ثسُّوفّْغمْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ حِيمَا وَارْ سّْخمَّاجنْ ڒمْرَاڭحْ نْسنْ مَانِي زدّْغغْ نشّْ ذِي ڒْوسْطْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ؤُشَا ڭِّينْ أَيْثْ ن إِسْرَائِيل أَمُّو. نِيثْنِي سُّوفّْغنْ ثنْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ. أَيْثْ ن إِسْرَائِيل ڭِّينْ أَمْ مَامّشْ إِ إِنَّا سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل: ’مَاڒَا إِجّْ ن ورْيَازْ نِيغْ إِشْثْ ن ثمْغَارْثْ إِ إِڭِّينْ شَا ن دّنْبْ ن بْنَاذمْ إِ زِي إِغْذَارْ ذِي سِيذِي، خنِّي أَذْ يِيڒِي ڒعْمَارْ نِّي ذ بُو-ؤُمَارْوَاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","أَذْ نعْمنْ خْ دّنْبْ نْسنْ إِ ڭِّينْ. نتَّا أَذْ إِخدْجصْ أَمَارْوَاسْ نّسْ مَارَّا ؤُ أَذْ أَسْ يَارْنِي إِشْثْ ن ثسْغَارْثْ ثخْمُوسشْثْ ؤُشَا أَذْ إِوْشْ أَيَا إِ ونِّي إِذوْڒنْ إِتُّورْسْ أَسْ نتَّا. ");
INSERT INTO rifa_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","مَاشَا مَاڒَا وَارْ ذِينْ إِدْجِي ؤُمفْذِي إِ ورْيَازْ نِّي، مَاحنْذْ أَذْ أَسْ إِخدْجصْ أَمَارْوَاسْ، خنِّي أَذْ يِيڒِي ؤُمَارْوَاسْ، إِ إِتّْخصَّا أَذْ إِخدْجصْ إِ سِيذِي، إِ ؤُكهَّانْ، أَكْ-ذ ذْ إِشَارِّي ن وصْڒَاحْ إِ زَّايسْ ث غَا إِسّصْڒحْ.    ");
INSERT INTO rifa_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","كُوڒْ ثَاوْهِيبْثْ نِّي سّْڭعّْذنْ أَيْثْ ن إِسْرَائِيل ن ثوْهِيبِينْ إِقدّْسنْ نِّي د-إِتَّاوْينْ غَارْ ؤُكهَّانْ أَذْ ثِيڒِي نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","مَارَّا ثِيوْهِيبِينْ إِقدّْسنْ ن شَا ن ورْيَازْ أَذْ إِڒِينْثْ إِ نتَّا، مِينْ مَا إِ غَا إِوْشْ إِجّْ ن ورْيَازْ إِ ؤُكهَّانْ، ذ مَانْ أَيَا أَذْ يِيڒِي إِ نتَّا.‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’مَاڒَا ثَامْغَارْثْ ن شَا ن ورْيَازْ ثفّغْ ؤُ ثغْذَارْ إِ-ث، ");
INSERT INTO rifa_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ؤُ شَا ن ورْيَازْ إِسّنْ إِ-ت، ؤُشَا مَانْ أَيَا إِنُّوفَارنْ إِ ثِيطَّاوِينْ ن ورْيَازْ نّسْ ؤُ نتَّاثْ ثسّْنُوفَّارْ إِ-ث ؤُشَا أَمُّو ثسّخْمجْ إِخفْ نّسْ ؤُ وَارْ ذِينْ وِي خَاسْ غَا إِشهْذنْ ؤُ نتَّاثْ عمَّارْصْ وَارْ ثتّْوَاطّفْ، ");
INSERT INTO rifa_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ؤُشَا خنِّي يُوسَا-د خَاسْ بُوحْبڒْ ن ثُوسْمِي ؤُشَا يُوسمْ خْ ثمْغَارْثْ نّسْ ؤُمِي نتَّاثْ ثتّْوَاسّخْمجْ، نِيغْ يُوسَا-د خَاسْ بُوحْبڒْ ن ثُوسْمِي ؤُشَا يُوسمْ خْ ثمْغَارْثْ نّسْ ؤُمِي نتَّاثْ وَارْ ثتّْوَاسّخْمِيجْ شَا، ");
INSERT INTO rifa_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","خنِّي أَرْيَازْ أَذْ يَاوِي ثَامْغَارْثْ نّسْ غَارْ ؤُكهَّانْ ؤُشَا أَذْ يَاوِي ثَاوْهِيبْثْ نّسْ إِ نتَّاثْ، أَقَا-ت ذ ثَاعْشَارْثْ ن إِجّْ ن إِفَا ن وَارنْ ن إِمنْذِي. وَارْ خَاسْ إِفَارّغْ زّشْثْ نِيغْ أَذْ خَاسْ إِسَّارْسْ جَّاوِي، مِينْزِي أَقَا-ت ذ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ذِي سِّيبّثْ ن ثُوسْمِي، إِشْثْ ن ثوْهِيبْثْ ن ڒْغِيدْجثْ إِ ڒِيذَارثْ، ثنِّي د غَا يَاوْينْ أَخَارّصْ ذِي ڒْمُوعْصِييّثْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","أَذْ ت-إِ-د-إِسّْقَارّبْ ؤُكهَّانْ ؤُشَا أَذْ ت إِسَّارْسْ زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","أَذْ إِكْسِي ؤُكهَّانْ أَمَانْ إِقدّْسنْ ذڭْ إِشْثْ ن ڒْقشْعثْ ن ثْڒَاخْثْ ؤُشَا أَذْ إِكْسِي شَا زڭْ ؤُشَاڒْ إِ إِدْجَانْ ذِي ثمُّورْثْ ن ثْزذِّيغْثْ، أَذْ يڭّْ أَيَا ذڭْ وَامَانْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","خنِّي أَذْ إِڭّْ ؤُكهَّانْ ثَامْغَارْثْ نِّي زَّاثْ إِ وُوذمْ ن سِيذِي، أَذْ إِفكّْ أَشُوَّافْ ن ؤُزدْجِيفْ ن ثمْغَارْثْ ؤُشَا أَذْ إِڭّْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ إِ ڒِيذَارثْ ذڭْ إِفَاسّنْ نّسْ، أَقَا ذ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ن ثُوسْمِي. أَكهَّانْ أَذْ إِطّفْ ذڭْ ؤُفُوسْ نّسْ أَمَانْ إِمرْزَاڭنْ نِّي د-إِتَّاوْينْ نّعْڒثْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","أَكهَّانْ أَذْ ت يجّْ أَذْ ثجَّادْجْ ؤُشَا أَذْ يِينِي إِ ثمْغَارْثْ: مَاڒَا وَارْ كِيمْ إِطِّيصْ حذْ ؤُ وَارْ ثوْضِيذْ زڭْ ورْيَازْ نّمْ ذِي ثخْمُوجِي، أَقَا أَذْ ثِيڒِيذْ ثتّْوَاصْفِيذْ زڭْ وَامَانْ-أَ إِمرْزَاڭنْ إِنِّي د-إِتَّاوْينْ نّعْڒثْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","مَاشَا ؤُشْثْ خَامْ، مَاڒَا ثوْضِيذْ زڭْ ورْيَازْ نّمْ ؤُشَا ثتّْوَاسّْخمْجذْ ؤُشَا إِجّْ ن ورْيَازْ مْغِيرْ أَرْيَازْ نّمْ إِطّصْ أَكِيمْ! ");
INSERT INTO rifa_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","خنِّي أَذْ يجّْ ؤُكهَّانْ ثَامْغَارْثْ أَذْ ثجَّادْجْ ثَاجَادْجِيثْ ن نّعْڒثْ. أَذْ يِينِي ؤُكهَّانْ إِ ثمْغَارْثْ: سِيذِي أَذْ شمْ يَارّْ ذ إِجّْ ن ؤُمذْيَا ن نّعْڒثْ-أَ ذ ثْجَادْجِيثْ-أَ ذِي ڒْوسْطْ ن ڒْڭنْسْ نّمْ، خْمِي غَا يجّْ سِيذِي أَذْ إِوْضَا ؤُمصَّاضْ نّمْ ؤُشَا أَذْ يَارّْ أَعذِّيسْ نّمْ يُوفّْ، ");
INSERT INTO rifa_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ؤُشَا أَمَانْ-أَ إِ د-إِتَّاوْينْ نّعْڒثْ أَذْ أَذْفنْ غَارْ وَاذَانْ نّمْ مَاحنْذْ أَذْ سُّوفّنْ أَعذِّيسْ نّمْ ؤُشَا أَذْ سّْغضْڒنْ أَمصَّاضْ نّمْ! ؤُشَا أَذْ ثِينِي ثمْغَارْثْ: أَمِينْ أَمِينْ! ");
INSERT INTO rifa_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","أَذْ يَارِي ؤُكهَّانْ نّْعَاڒِي-يَا خْ إِشْثْ ن ثوْرِيقْثْ إِتّْوَانّْضنْ ؤُشَا خنِّي أَذْ ثنْثْ إِمْحَا ذڭْ وَامَانْ إِمرْزَاڭنْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","أَذْ إِوْشْ أَمَانْ إِمرْزَاڭنْ إِ د-إِتَّاوْينْ نّعْڒثْ إِ ثمْغَارْثْ ؤُ نتَّاثْ أَذْ ثْسُو أَڒَامِي أَمَانْ إِ د-إِتَّاوْينْ نّعْڒثْ أَذْ ذَايسْ أَذْفنْ ذَاخڒْ ؤُشَا أَذْ ذوْڒنْ ذ إِمرْزَاڭنْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","أَكهَّانْ أَذْ إِكْسِي ثَاوْهِيبْثْ ن ڒْغِيدْجثْ ن ثُوسْمِي زڭْ ؤُفُوسْ ن ثمْغَارْثْ ؤُشَا أَذْ إِسّنْهزّْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَذْ ت-إِ-د إِسّْقَارّبْ غَارْ ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","أَذْ إِكْسِي ؤُكهَّانْ إِجّْ ن وُورُو زِي ثوْهِيبْثْ ن ڒْغِيدْجثْ، أَقَا-ت ذ ثَاوْهِيبْثْ نْ ڒِيذَارثْ، ؤُشَا أَذْ إِسّْبخَّارْ أَيَا خْ ؤُعَالْطَارْ ؤُشَا خنِّي أَذْ إِوْشْ أَمَانْ إِ ثمْغَارْثْ أَذْ ثْسُو. ");
INSERT INTO rifa_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","مَاڒَا إِوْشَا أَسْ أَمَانْ أَذْ ثْسُو، خنِّي، مَاڒَا ثتّْوَاسّخْمجْ ؤُشَا نتَّاثْ ثغْذَارْ أَرْيَازْ نّسْ، أَمَانْ إِ د-إِتَّاوْينْ نّعْڒثْ أَذْ ذَايسْ ذوْڒنْ ذ إِمرْزَاڭنْ ؤُشَا أَعذِّيسْ نّسْ أَذْ يُوفّْ ؤُشَا أَمصَّاضْ نّسْ أَذْ إِتّْوَاغْضڒْ ؤُ ثَامْغَارْثْ أَذْ ثذْوڒْ ذ نّعْڒثْ ذِي ڒْوسْطْ ن ڒْڭنْسْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","مَاشَا مَاڒَا وَارْ ثخْمِيجْ شَا ثمْغَارْثْ، مَاشَا ثزْذڭْ، خنِّي أَذْ ثِيڒِي وَارْ خَاسْ شَا، أَذْ ثِيڒِي ثتَّارُو.‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","وَا ذ أَزرْفْ زِي جِّيهثْ ن ثُوسْمِي، خْمِي ثوْضَا إِشْثْ ن ثمْغَارْثْ زڭْ ورْيَازْ نّسْ ؤُشَا ثتّْوَاسّخْمجْ ");
INSERT INTO rifa_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","نِيغْ خْمِي د يُوسَا بُوحْبڒْ ن ثُوسْمِي خْ ورْيَازْ ؤُشَا نتَّا يُوسمْ خْ ثمْغَارْثْ نّسْ. خنِّي أَذْ يَارَّا ثَامْغَارْثْ أَذْ ثْبدّْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُ أَكهَّانْ أَذْ أَسْ إِكمّڒْ مَارَّا أَزرْفْ-أَ وَا. ");
INSERT INTO rifa_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","أَرْيَازْ أَذْ يِيڒِي ذ أَمزْذَاڭْ زِي سِّيبّثْ ن ڒْمُوعْصِييّثْ، ثَامْغَارْثْ-أَ أَذْ ثَارْبُو ڒْمُوعْصِييّثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي أَسنْ: ’مَاڒَا إِجّْ ن ورْيَازْ نِيغْ إِشْثْ ن ثمْغَارْثْ إِ إِوجْذنْ مَاحنْذْ أَذْ إِوْشْ أَوَاڒْ ن تَّاجْ ن ؤُشُوَّافْ ن لْوَاعْذْ، مَاحنْذْ أَذْ إِعْزڒْ إِخفْ نّسْ س تَّاجْ نِّي إِ سِيذِي، ");
INSERT INTO rifa_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","خنِّي أَذْ إِڭّْوجْ خْ بِينُو ذ شّْرَابْ. وَارْ إِسسّْ ڒْخدْجْ زِي بِينُو نِيغْ ڒْخدْجْ زِي شّْرَابْ ؤُ وَارْ إِسسّْ أَمَانْ ن ؤُضِيڒْ، ؤُ وَارْ إِتّتّْ زڭْ ؤُضِيڒْ أَزيْزَا نِيغْ زڭْ ؤُضِيڒْ يُوژْغنْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","مَارَّا ؤُسَّانْ ن تَّاجْ نّسْ ن وعْزَاڒْ وَارْ إِتّتّْ شَا مِينْ د-إِفّْغنْ زِي ثْزَايَارْثْ، زڭْ ؤُعقَّا نّسْ أَڒْ ثَاقْشُورْثْ نّسْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","”مَارَّا ؤُسَّانْ ن وَاوَاڒْ إِ د تَّاسنْ أَكْ-ذ تَّاجْ نّسْ ن وعْزَاڒْ وَارْ إِتّكّْ ڒْمُوسْ خْ ؤُزدْجِيفْ نّسْ أَڒْ غَا كمّْڒنْ وُوسَّانْ نِّي إِعْزڒْ إِ سِيذِي ؤُشَا أَذْ يِيڒِي إِقدّسْ ؤُشَا أَذْ يجّْ إِعيَّاشنْ ن ؤُشُوَّافْ ن ؤُزدْجِيفْ نّسْ أَذْ مْغَارنْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","مَارَّا ؤُسَّانْ إِ إِسّْحُوزّْ إِ سِيذِي، وَارْ د-إِتّْقَارِّيبْ شَا غَارْ ڒعْمَارْ ن إِجّْ ن ؤُمتِّينْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","وَارْ إِسّْخمِّيجْ إِخفْ نّسْ خْ بَابَاسْ نِيغْ خْ يمَّاسْ نِيغْ خْ ؤُمَاسْ نِيغْ خْ ؤُتْشْمَاسْ مَاڒَا ڭُّورنْ أَذْ مّْثنْ، مِينْزِي تَّاجْ ن وعْزَاڒْ ن أَربِّي نّسْ أَقَا-ت خْ ؤُزدْجِيفْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","”مَارَّا ؤُسَّانْ ن تَّاجْ نّسْ ن وعْزَاڒْ أَذْ يِيڒِي إِقدّسْ إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","مَاڒَا ونِّي إِتّْمتَّانْ أَذْ إِمّثْ ذغْيَا ذڭْ ورْمَاشْ ن وَابْڒِيونْ ؤُشَا إِسّخْمجْ أَزدْجِيفْ نّسْ س تَّاجْ نّسْ ن وعْزَاڒْ، خنِّي أَذْ إِحفّْ أَزدْجِيفْ نّسْ ذڭْ وَاسّْ ن ؤُسِيزْذڭْ نّسْ. ذڭْ وَاسّْ وِيسّْ سبْعَا إِتّْخصَّا أَذْ ث إِحفّْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا أَذْ يَاوِي ثْنَاينْ ن ثجْلِيلِّيحِينْ نِيغْ ثْنَاينْ ن إِضْبِيرنْ غَارْ ؤُكهَّانْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","أَكهَّانْ أَذْ إِسّوْجذْ إِشْثْ ذ ثَاغَارْصْثْ ن دّنْبْ ذ إِشْثْ ذ ثَاغَارْصْثْ ن وشْمَاضْ ؤُشَا أَذْ ث إِسّصْڒحْ، مِينْزِي نتَّا أَقَا إِخْضَا ذِي سِّيبّثْ ن ؤُمتِّينْ. نتَّا أَذْ إِسّْقدّسْ أَزدْجِيفْ نّسْ عَاوذْ ذڭْ وَاسّْ نِّي ");
INSERT INTO rifa_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ؤُشَا ثْوَاڒَا نّغْنِي أَذْ إِنيّشْ نتَّا ؤُسَّانْ ن تَّاجْ نّسْ ن وعْزَاڒْ إِ سِيذِي ؤُشَا أَذْ إِقدّمْ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ ذ ثَاغَارْصْثْ ن ؤُمَارْوَاسْ. ؤُسَّانْ إِعْذُونْ أَذْ إِڒِينْ وْضَانْ مِينْزِي أَقَا ثتّْوَاسّخْمجْ تَّاجْ نّسْ ن وعْزَاڒْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","”وَا ذ أَزرْفْ ن ونِّي يَاربُّونْ تَّاجْ ن وعْزَاڒْ: ذڭْ وَاسّْ مِينْ ذِي تّْوَاكمّْڒنْ وُوسَّانْ ن تَّاجْ نّسْ ن وعْزَاڒْ، أَذْ ث أَوْينْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","خنِّي أَذْ د-إِسّْقَارّبْ ثَاوْهِيبْثْ نّسْ غَارْ سِيذِي، إِجّْ ن إِزْمَارْ إِشْنَانْ قَاعْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ ذ إِشْثْ ن ثخْسِي إِشْنَانْ قَاعْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن دّنْبْ ذ إِجّْ ن إِشَارِّي إِشْنَانْ قَاعْ أَمْ ثْغَارْصْثْ ن ڒهْنَا ");
INSERT INTO rifa_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ذ إِشْثْ ن ثْسُودْجثْ أَكْ-ذ وغْرُومْ بْڒَا أَنْثُونْ ذ ڒمْسمْنَاثْ ن وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ ذ ثڒْفَافْ ن وغْرُومْ بْڒَا أَنْثُونْ تّْوَاذهْننْثْ س زّشْثْ ؤُڒَا ذ ثَاوْهِيبْثْ نّسْ ن ڒْغِيدْجثْ ذ ثوْهِيبِينْ نّسْ ن ؤُسيّبْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","”أَكهَّانْ أَذْ يَاوِي مَانْ أَيَا زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَذْ إِسّوْجذْ ثَاغَارْصْثْ نّسْ ن دّنْبْ ذ ثْغَارْصْثْ نّسْ ن وشْمَاضْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","أَذْ إِسّوْجذْ إِشَارِّي أَمْ ثْغَارْصْثْ ن ڒهْنَا إِ سِيذِي ؤُڒَا ذ ثَاسُودْجثْ أَكْ-ذ ثشْنِيفِينْ بْڒَا أَنْثُونْ ؤُشَا أَكهَّانْ أَذْ إِسّوْجذْ عَاوذْ ثَاوْهِيبْثْ ن ڒْغِيدْجثْ نّسْ ذ ثوْهِيبِينْ ن ؤُسيّبْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","”خنِّي ونِّي يَاربُّونْ تَّاجْ ن وعْزَاڒْ أَذْ إِحفّْ أَزدْجِيفْ ن تَّاجْ نّسْ ن وعْزَاڒْ غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ إِكْسِي أَشُوَّافْ ن ؤُزدْجِيفْ ن تَّاجْ نّسْ ن وعْزَاڒْ ؤُشَا أَذْ يڭّْ أَيَا خْ ثْمسِّي إِ إِدْجَانْ سَاذُو ثْغَارْصْثْ ن ڒهْنَا. ");
INSERT INTO rifa_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","خنِّي أَذْ إِكْسِي ؤُكهَّانْ ثَامصَّاضْثْ ن زَّاثْ ينْڭّْوَانْ ن إِشَارِّي ذ إِشْثْ ن ثمْسمّنْثْ بْڒَا أَنْثُونْ زِي ثْسُودْجثْ ذ إِشْثْ ن ثڒْففْثْ بْڒَا أَنْثُونْ ؤُشَا أَذْ ثنْثْ إِسَّارْسْ خْ إِفَاسّنْ ن ونِّي يَاربُّونْ تَّاجْ ن وعْزَاڒْ أَوَارْنِي مَا إِحفّْ تَّاجْ نّسْ ن وعْزَاڒْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","أَكهَّانْ أَذْ ثنْثْ إِسّنْهزّْ زِي سَّا غَارْ ذَا زَّاثْ إِ وُوذمْ ن سِيذِي. أَقَا-ت ذ إِشْثْ ن ثْمسْڒَاشْثْ ثَامْقدَّاسْثْ إِ ؤُكهَّانْ، أَكْ-ذ إِذْمَارنْ ن ونْهزِّي ؤُ أَكْ-ذ ؤُشكْرُوذْ ن ثوْهِيبْثْ إِتّْوَاسّْڭعّْذنْ. أَوَارْنِي أَيَا إِعدّڒْ إِ ونِّي يَاربُّونْ تَّاجْ ن وعْزَاڒْ مَاحنْذْ أَذْ إِسُو بِينُو.“ ");
INSERT INTO rifa_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","”وَا ذ أَزرْفْ ن ونِّي يَاربُّونْ تَّاجْ ن وعْزَاڒْ، ونِّي ثُوغَا إِوَاعْذنْ إِ سِيذِي ثَاوْهِيبْثْ نّسْ ذِي سِّيبّثْ ن تَّاجْ ن وعْزَاڒْ نّسْ، بَارَّا مِينْ إِزمَّارْ ؤُفُوسْ نّسْ عَاذْ أَذْ إِسِّيوضْ. إِتّْخصَّا أَسْ أَذْ يڭّْ عْلَاحْسَابْ أَوَاڒْ إِ إِوْشِينْ، عْلَاحْسَابْ أَزرْفْ ن تَّاجْ ن وعْزَاڒْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","”سِيوڒْ أَكْ-ذ هَارُونْ ذ وَارَّاوْ نّسْ ؤُشَا إِنِي: ’أَمُّو أَذْ ثْبَارْكمْ أَيْثْ ن إِسْرَائِيل ؤُشَا أَذْ أَسنْ ثِينِيمْ: ");
INSERT INTO rifa_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","سِيذِي أَذْ أَشْ إِبَاركْ ؤُشَا أَذْ شكْ إِحْضَا! ");
INSERT INTO rifa_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","سِيذِي أَذْ يَارّْ ؤُذمْ نّسْ أَذْ خَاكْ يڭّْ ثْفَاوْثْ ؤُشَا أَذْ خَاكْ إِحِينّْ. ");
INSERT INTO rifa_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","سِيذِي أَذْ غَاركْ د-إِنّقْڒبْ ؤُذمْ نّسْ ؤُشَا أَذْ أَشْ إِوْشْ ڒهْنَا!‘ ");
INSERT INTO rifa_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","أَذْ سِّيوْضنْ إِسمْ إِنُو خْ أَيْثْ ن إِسْرَائِيل ؤُ نشّْ أَذْ ثنْ بَارْكغْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","إِمْسَارْ ذڭْ وَاسّْ مِينْ ذِي إِكمّڒْ مُوسَا أَسْبذِّي ن ثْزذِّيغْثْ، إِذْهنْ ؤُ إِسّْقدّسْ إِ-ت أَكْ-ذ ڒقْشُوعْ نّسْ ؤُڒَا ذ مَارَّا أَعَالْطَارْ أَكْ-ذ ڒقْشُوعْ نّسْ. أَقَا إِذْهنْ إِ-ثنْ ؤُشَا إِسّْقدّسْ إِ-ثنْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","خنِّي قَارّْبنْ-د ڒْحُوكَّامْ ن إِسْرَائِيل، إِزدْجِيفنْ ن ثُوذْرِينْ ن ڒجْذُوذْ نْسنْ. نِيثْنِي ذ ڒْحُوكَّامْ ن ثْقبَّاڒْ، نِيثْنِي ثُوغَا خْ يِينِّي إِتّْوَاحسْبنْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","نِيثْنِي إِوْينْ-د ثَاوْهِيبْثْ نْسنْ زَّاثْ إِ وُوذمْ ن سِيذِي: ستَّا ن إِكَارُّوثنْ أَكْ-ذ ثْسقِّيفْثْ ذ ثنْعَاشْ ن إِفُونَاسنْ، أَقَا ذ إِجّْ ن ؤُكَارُّو إِ ثْنَاينْ ن ڒْحُوكَّامْ ذ إِجّْ ن ؤُفُونَاسْ إِ كُوڒْ إِجّْ ن ڒْحَاكمْ ؤُشَا إِوْينْ ثنْ زَّاثْ إِ وُوذمْ ن ثْزذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","”كْسِي أَيَا زَّايْسنْ، حِيمَا أَذْ إِڒِينْ إِ ڒْخذْمثْ ن ثْسخَّارْثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. إِتّْخصَّا أَذْ ثنْ ثوْشذْ إِ إِلَاوِييّنْ، إِ كُوڒْ أَرْيَازْ أَمْ مَامّشْ د-إِتَّاسْ أَكْ-ذ ثْسخَّارْثْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ؤُشَا مُوسَا إِطّفْ إِكَارُّوثنْ ذ إِفُونَاسنْ ؤُشَا إِوْشَا إِ-ثنْ إِ إِلَاوِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ثْنَاينْ ن إِكَارُّوثنْ ذ أَربْعَا ن إِفُونَاسنْ إِ إِوْشَا إِ أَيْثْ ن جَارْشُونْ، أَمْ مَامّشْ د-إِتَّاسْ أَكْ-ذ ثْسخَّارْثْ نْسنْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ؤُ إِ أَيْثْ ن مَارَارِي إِوْشَا أَسنْ أَربْعَا ن إِكَارُّوثنْ ذ ثْمنْيَا ن إِفُونَاسنْ، أَمْ مَامّشْ د-إِتَّاسْ أَكْ-ذ ثْسخَّارْثْ نْسنْ سَاذُو ؤُفُوسْ ن إِثَامَارْ، مِّيسْ ن ؤُكهَّانْ هَارُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","إِ أَيْثْ ن قَاهَاثْ وَارْ ذ أَسنْ إِوْشِي وَالُو، مِينْزِي ثُوغَا خَاسنْ ثَاسخَّارْثْ ن زَّاوشْثْ إِقدّْسنْ، نِيثْنِي أَرْبُونْ زَّاوشْثْ خْ ثْغَارْوَاضْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","خنِّي قَارّْبنْ-د ڒْحُوكَّامْ أَكْ-ذ ثوْهِيبْثْ إِ ؤُذشّنْ ن ؤُعَالْطَارْ ذڭْ وَاسّْ مِينْ ذِي إِتّْوَاذْهنْ ؤُعَالْطَارْ. إِوْينْ ڒْحُوكَّامْ ثِيوْهِيبِينْ نْسنْ زَّاثْ إِ وُوذمْ ن ؤُعَالْطَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","إِنَّا سِيذِي إِ مُوسَا: ”إِجّْ ن ڒْحَاكمْ ذڭْ إِجّْ ن وَاسّْ، خنِّي عَاوذْ إِجّْ ن ڒْحَاكمْ ذڭْ وَاسّْ أَوَارْنِي أَسْ، أَمُّو إِ غَا قدّْمنْ نِيثْنِي ثِيوْهِيبِينْ نْسنْ إِ ؤُذشّنْ ن ؤُعَالْطَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ذڭْ وَاسّْ أَمزْوَارُو إِقدّمْ نَاحْشُونْ، مِّيسْ ن عَامِّينَاذَابْ، زِي ثقْبِيتْشْ ن يَاهُوذَا، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي، إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ ذ خمْسَا ن إِشَارِّييّنْ ذ خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن نَاحْشُونْ، مِّيسْ ن عَامِّينَاذَابْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ذڭْ وَاسّْ وِيسّْ ثْنَاينْ إِقدّمْ نَاثَانَايِيلْ، مِّيسْ ن صُوغَارْ، ونِّي ذ ڒْحَاكمْ ن إِسَّاكَارْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن نَاثَانَايِيلْ، مِّيسْ ن صُوغَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ذڭْ وَاسّْ وِيسّْ ثْڒَاثَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن زابُولُونْ، إِلِييَابْ، مِّيسْ ن حِيلُونْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن إِلِييَابْ، مِّيسْ ن حِيلُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ذڭْ وَاسّْ وِيسّْ أَربْعَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن رُوبِينْ، أَلِيصُورْ، مِّيسْ ن شَاذَايُّورْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن أَلِيصُورْ، مِّيسْ ن شَاذَايُّورْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ذڭْ وَاسّْ وِيسّْ خمْسَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن شِيمْعُونْ، شَالُومِييِيلْ، مِّيسْ ن صُورِيشَادَّايْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن شَالُومِييِيلْ، مِّيسْ ن صُورِيشَادَّايْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ذڭْ وَاسّْ وِيسّْ ستَّا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن جَاذْ، أَلِييَاسَافْ، مِّيسْ ن ذَاعُويِيلْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن أَلِييَاسَافْ، مِّيسْ ن ذَاعُويِيلْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ذڭْ وَاسّْ وِيسّْ سبْعَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن إِفْرَايِيمْ، إِلِيشَامَاعْ، مِّيسْ ن عَامِّيهُوذْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن إِلِيشَامَاعْ، مِّيسْ ن عَامِّيهُوذْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ذڭْ وَاسّْ وِيسّْ ثْمنْيَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن مَانَاسَّا، جَامَالِييِيلْ، مِّيسْ ن فَاذَاهْصُورْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن جَامَالِييِيلْ، مِّيسْ ن فَاذَاهْصُورْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ذڭْ وَاسّْ وِيسّْ ثسْعَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن بِينْيَامِينْ، أَبِيذَانْ، مِّيسْ ن جِيذْعُونِي، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن أَبِيذَانْ، مِّيسْ ن جِيذْعُونِي. ");
INSERT INTO rifa_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ذڭْ وَاسّْ وِيسّْعشْرَا إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن ذَانْ، أَخِيعَازَارْ، مِّيسْ ن عَامِيشَادَّايْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن أَخِيعَازَارْ، مِّيسْ ن عَامِيشَادَّايْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ذڭْ وَاسّْ وِيسّْ حِيطَاشْ إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن أَشِيرْ، فَاجْعِييِيلْ، مِّيسْ ن عُوكْرَانْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن فَاجْعِييِيلْ، مِّيسْ ن عُوكْرَانْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ذڭْ وَاسّْ وِيسّْ ثنْعَاشْ إِقدّمْ ڒْحَاكمْ ن أَيْثْ ن نَافْثَالِي، أَخِيرَاعْ، مِّيسْ ن عِييْنَانْ، ثَاوْهِيبْثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ثُوغَا-ت ثَاوْهِيبْثْ نّسْ: إِجّنْ طّبْصِي ن نُّوقَارْثْ ن مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ن دّْقڒْ، ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي ن نُّوقَارْثْ ن سبْعِينْ شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ثُوغَا-ثنْ س ثْنَاينْ شُّورنْ س وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ أَمْ ثوْهِيبْثْ ن ڒْغِيدْجثْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","خنِّي إِشْثْ ن ثْغنْجَاشْثْ ن وُورغْ نعشْرَا شِيقْلُو ثشُّورْ س ڒبْخُورْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","إِجّْ ن ؤُفُونَاسْ - أَمژْيَانْ ن ثْفُونَاسْثْ - إِجّْ ن إِشَارِّي ذ إِجّْ ن إِزْمَارْ ن إِجّْ ن ؤُسڭّْوَاسْ أَمْ ثْغَارْصْثْ ن وشْمَاضْ، ");
INSERT INTO rifa_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","إِجّْ ن ؤُمْيَانْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ ");
INSERT INTO rifa_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ؤُ إِ ثْغَارْصْثْ ن ڒهْنَا: ثْنَاينْ ن إِفُونَاسنْ، خمْسَا ن إِشَارِّييّنْ، خمْسَا ن إِغَايْضنْ ذ خمْسَا ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. أَقَا ثَا ذ ثَاوْهِيبْثْ ن أَخِيرَاعْ، مِّيسْ ن عِييْنَانْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ثُوغَا ثَا ذ ثَاوْهِيبْثْ إِ ؤُذشّنْ ن ؤُعَالْطَارْ زِي ڒْحُوكَّامْ ن إِسْرَائِيل ذڭْ وَاسّْ نِّي ذِي إِتّْوَاذْهنْ ؤُعَالْطَارْ: ثنْعَاشْ ن طّْبَاصِي ن نُّوقَارْثْ ذ ثنْعَاشْ ن طَّاوْيَاثْ إِ ؤُرُوشِّي ن نُّوقَارْثْ ذ ثنْعَاشْ ن ثْغنْجَايِينْ ن وُورغْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","إِجّنْ طّبْصِي ن نُّوقَارْثْ إِوْزنْ مْيَا ؤُ-ثْڒَاثِينْ شِيقْلُو ذ إِشْثنْ طَّاوْيَا إِ ؤُرُوشِّي إِوْزنْ سبْعِينْ شِيقْلُو. مَارَّا نُّوقَارْثْ ن ڒقْشُوعْ نِّي ثوْزنْ أَڒْفَاينْ ؤُ-أَربْعَا-مْيَا شِيقْلُو عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ثنْعَاشْ ن ثْغنْجَايِينْ ن وُورغْ شُّورنْثْ س ڒبْخُورْ. كُوڒْ ثَاغنْجَايْثْ ثوْزنْعشْرَا شِيقْلُو، عْلَاحْسَابْ شِيقْلُو ن زَّاوشْثْ إِقدّْسنْ. مَارَّا ؤُرغْ ن ثْغنْجَايِينْ إِوْزنْ مْيَا ؤُ-عِيشْرِينْ شِيقْلُو. ");
INSERT INTO rifa_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","مَارَّا ڒبْهَايمْ إِ ثْغَارْصْثْ ن وشْمَاضْ أَقَا ذَايْسنْثْ ثنْعَاشْ ن إِفُونَاسنْ إِمژْيَاننْ، ثنْعَاشْ ن إِشَارِّييّنْ، ثنْعَاشْ ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ أَكْ-ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ نْسنْ، ؤُ ثنْعَاشْ إِمْيَاننْ زڭْ إِغَايْضنْ إِ ثْغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","مَارَّا ڒبْهَايمْ ن ثْغَارْصْثْ ن ڒهْنَا أَقَا ذَايْسنْثْ أَربْعَا ؤُ-عِيشْرِينْ ن إِفُونَاسنْ إِمژْيَاننْ، ستِّينْ ن إِشَارِّييّنْ ذ ستِّينْ ن إِغَايْضنْ ذ ستِّينْ ن إِزْمَارنْ ن إِجّْ ن ؤُسڭّْوَاسْ. مَانْ أَيَا ذ ثَاوْهِيبْثْ إِ ؤُذشّنْ ن ؤُعَالْطَارْ أَوَارْنِي إِتّْوَاذْهنْ. ");
INSERT INTO rifa_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ؤُمِي يُوذفْ مُوسَا غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ، حِيمَا أَذْ كِيذسْ إِسِّيوڒْ، إِسْڒَا ثْمِيجَّا ثسِّيوڒْ أَكِيذسْ زِي سنّجْ ن ثْقبَّارْثْ ن وصْڒَاحْ إِ إِدْجَانْ خْ تَّابُوثْ ن شّْهَاذثْ، زِي جَارْ ثْنَاينْ ن إِكِيرُوبنْ. أَمُّو إِ إِسِّيوڒْ سِيذِي أَكِيذسْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","”سِيوڒْ أَكْ-ذ هَارُونْ، إِنِي أَسْ: ’خْمِي غَا ثسَّارْسذْ ثِيفَاوِينْ خْ ڒْقنْذِيڒْ، إِتّْخصَّا سبْعَا ن ثْفَاوِينْ أَذْ وْشنْثْ ثَافَاوْثْ غَارْ زَّاثْ ن ڒْقنْذِيڒْ.‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ؤُشَا أَمُّو إِ إِڭَّا هَارُونْ. إِسَّارْسْ ثِيفَاوِينْ نّسْ غَارْ زَّاثْ ن ڒْقنْذِيڒْ، أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ثُوغَا ڒْقنْذِيڒْ ذ إِشْثْ ن صّنْعثْ ن وُورغْ يعْذڒْ س وفْضِيسْ. زڭْ ؤُفُوضْ خْ ؤُضَارْ نّسْ أَڒْ نُّووَّارَاثْ نّسْ ثُوغَا إِتّْوَاڭّْ س وفْضِيسْ. عْلَاحْسَابْ أَمذْيَا إِ ذ أَسْ إِسْشّنْ سِيذِي، أَمُّو إِ إِصنّعْ ڒْقنْذِيڒْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","”كْسِي إِلَاوِييّنْ زِي جَارْ ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل ؤُشَا سِيزْذڭْ إِ-ثنْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","أَمُّو إِ ذ أَسنْ غَا ثڭّذْ حِيمَا أَذْ ثنْ ثسِّيزذْڭذْ: رُوشّْ إِ-ثنْ س وَامَانْ ن ؤُسِيزْذڭْ. إِتّْخصَّا أَسنْ أَذْ حفّنْ مَارَّا أَرِّيمثْ نْسنْ ؤُشَا أَذْ سِّيرْذنْ أَرُّوضْ نْسنْ ؤُشَا أَذْ سِّيزْذڭنْ إِخفْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","خنِّي أَذْ كْسِينْ إِجّْ ن ؤُفُونَاسْ، أَمژْيَانْ ن ثْفُونَاسْثْ، أَكْ-ذ ثوْهِيبْثْ ن ڒْغِيدْجثْ نّسْ ن وَارنْ أَزْذَاذْ إِخدْجْضنْ س زّشْثْ ؤُ عَاوذْ إِجّْ ن ؤُفُونَاسْ وِيسّْ ثْنَاينْ، أَمژْيَانْ ن ثْفُونَاسْثْ، أَمْ ثْغَارْصْثْ ن دّنْبْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","أَذْ ثَاوْيذْ إِلَاوِييّنْ زَّاثْ إِ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أَذْ ثسّْمُونذْ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","أَذْ د-ثسّْقَارّْبذْ إِلَاوِييّنْ زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا أَيْثْ ن إِسْرَائِيل أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ إِلَاوِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","أَذْ يجّْ هَارُونْ أَذْ هزّنْ إِلَاوِييّنْ زِي سَّا غَارْ ذَا زَّاثْ إِ وُوذمْ ن سِيذِي أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي ذِي طّْوعْ ن أَيْثْ ن إِسْرَائِيل. نِيثْنِي أَذْ ذوْڒنْ تّْسخَّارنْ ذِي ثْسخَّارْثْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","إِلَاوِييّنْ أَذْ سَّارْسنْ إِفَاسّنْ نْسنْ خْ إِزدْجِيفنْ ن إِفُونَاسنْ إِمژْيَاننْ ؤُشَا أَذْ ثسّْوجْذذْ إِجّْ إِ ثْغَارْصْثْ ن دّنْبْ ذ يِيجّْ إِ ثْغَارْصْثْ ن وشْمَاضْ إِ سِيذِي، حِيمَا أَذْ زَّايْسنْ إِتّْوَاڭّْ وصْڒَاحْ إِ إِلَاوِييّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","أَذْ ثڭّذْ إِلَاوِييّنْ أَذْ بدّنْ زَّاثْ إِ وُوذمْ ن هَارُونْ ؤُ زَّاثْ إِ وُوذمْ ن وَارَّاوْ نّسْ ؤُشَا أَذْ ثنْ ثَارّذْ أَذْ هزّنْ زِي سَّا غَارْ ذَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","أَمُّو إِ غَا ثْحُوزّذْ إِلَاوِييّنْ زِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل حِيمَا إِلَاوِييّنْ أَذْ إِڒِينْ إِنُو. ");
INSERT INTO rifa_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","أَوَارْنِي مَانْ أَيَا أَذْ د-أَسنْ إِلَاوِييّنْ حِيمَا أَذْ سخَّارنْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. أَذْ ثنْ ثسِّيزذْڭذْ ؤُشَا أَذْ ثنْ ثَارّذْ أَذْ هزّنْ زِي سَّا غَارْ ذَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي، ");
INSERT INTO rifa_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","مِينْزِي نِيثْنِي تّْوَامّوْشنْ أَيِي نِيشَانْ زِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل، ؤُشَا نشّْ كْسِيغْ ثنْ إِ يِيخفْ إِنُو ذڭْ ومْشَانْ ن مَارَّا مِينْ يَارزْمنْ ڒمْڒَاوثْ ذ أَمزْوَارُو، ذڭْ ومْشَانْ ن ؤُمنْزُو ن مَارَّا أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","مِينْزِي مَارَّا أَمنْزُو جَارْ أَيْثْ ن إِسْرَائِيل أَقَا-ث إِنُو، زڭْ إِوْذَانْ، أَمُّو زِي ڒْمَاڒْ، زڭْ وَاسّْ إِ ذِي نْغِيغْ نشّْ مَارَّا إِمنْزَا ذِي ثمُّورْثْ ن مِيصْرَا، سّْقدّْسغْ ثنْ إِ نشّْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","نشّْ كْسِيغْ إِلَاوِييّنْ ذڭْ ومْشَانْ ن مَارَّا إِمنْزَا جَارْ أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","نشّْ وْشِيغْ إِلَاوِييّنْ إِ هَارُونْ ؤُ إِ وَارَّاوْ نّسْ أَمْ يِيجّْ ن ؤُرِيغَالُو زِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل، مَاحنْذْ أَذْ ڭّنْ ثَاسخَّارْثْ ن أَيْثْ ن إِسْرَائِيل ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُ مَاحنْذْ أَذْ إِتّْوَاڭّْ وصْڒَاحْ ذِي طّْوعْ ن أَيْثْ ن إِسْرَائِيل، حِيمَا وَارْ ثتِّيڒِي جّْرِيحشْثْ خْ أَيْثْ ن إِسْرَائِيل خْمِي د غَا قَارّْبنْ أَيْثْ ن إِسْرَائِيل غَارْ زَّاوشْثْ إِقدّْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","مُوسَا ذ هَارُونْ ذ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ڭِّينْ أَكْ-ذ إِلَاوِييّنْ عْلَاحْسَابْ مَارَّا مِينْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا زِي جِّيهثْ ن إِلَاوِييّنْ، أَمُّو إِ ڭِّينْ أَيْثْ ن إِسْرَائِيل أَكِيذْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","إِلَاوِييّنْ سِّيزْذِيڭنْ إِخفْ نْسنْ زِي دّنْبْ نْسنْ ؤُشَا صبّْننْ أَرُّوضْ نْسنْ ؤُشَا هَارُونْ يَارَّا إِ-ثنْ أَذْ نْهزّنْ زِي سَّا غَارْ ذَا أَمْ يِيشْثْ ن ثوْهِيبْثْ ن ونْهزِّي زَّاثْ إِ وُوذمْ ن سِيذِي ؤُشَا هَارُونْ إِسّصْڒحْ إِ-ثنْ إِ ؤُسِيزْذڭْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","أَوَارْنِي مَانْ أَيَا ؤُسِينْ-د إِلَاوِييّنْ حِيمَا أَذْ سخَّارنْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ زَّاثْ إِ وُوذمْ ن هَارُونْ ؤُ زَّاثْ إِ وُوذمْ ن وَارَّاوْ نّسْ أَمْ مَامّشْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا زِي جِّيهثْ ن إِلَاوِييّنْ، أَمُّو إِ كِيذْسنْ ڭِّينْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","”ثَا زِي جِّيهثْ ن إِلَاوِييّنْ: أَقَا إِتّْخصَّا إِ كُوڒْ مِّيسْ ن خمْسَا ؤُ-عِيشْرِينْ ن إِسڭّْوُوسَا سنّجْ أَذْ د-يَاسْ، حِيمَا أَذْ إِسخَّارْ ذِي طّْوعْ ن ثْسخَّارْثْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ");
INSERT INTO rifa_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ؤُ خْمِي إِ غَا يِيوضْ غَارْ خمْسِينْ ن إِسڭّْوُوسَا أَذْ إِفّغْ زِي ڒْعسْكَارْ ن ثْسخَّارْثْ ؤُ وَارْ إِقِّيمْ إِتّْسخَّارْ عَاذْ كْثَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","أَذْ إِوْشْ أَفُوسْ إِ يَايْثْمَاسْ ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ حِيمَا أَذْ خَاسْ حْضَانْ، مَاشَا نتَّا س يِيخفْ نّسْ وَارْ إِزمَّارْ أَذْ إِسخَّارْ. أَمُّو إِ غَا ثڭّذْ أَكْ-ذ إِلَاوِييّنْ زِي جِّيهثْ ن ؤُحطُّو إِ خَاسنْ إِتّْوَاڭّنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذِي ڒخْڒَا ن سِينَا ذڭْ ؤُسڭّْوَاسْ وِيسّْ ثْنَاينْ أَوَارْنِي ڒَامِي د-فّْغنْ زِي ثمُّورْثْ ن مِيصْرَا، ذڭْ ؤُيُورْ أَمزْوَارُو، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","”جّمْ أَيْثْ ن إِسْرَائِيل أَذْ سّْوجْذنْ ثَاغَارْصْثْ ن ؤُسعْذُو ذِي ڒْوقْثْ نّسْ إِتّْوَاڭّنْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ذڭْ وَاسّْ وِيسّْ أَرْبعْطَاشْ ن ؤُيُورْ-أَ، جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ، إِتّْخصَّا أَذْ ت ثسّْوجْذمْ ذِي ڒْوقْثْ نّسْ إِتّْوَاڭّنْ. إِتّْخصَّا أَذْ ت ثسّْوجْذمْ عْلَاحْسَابْ مَارَّا ثِيوصَّا ذ لْفَارَايِيضْ نّسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","إِسِّيوڒْ مُوسَا أَكْ-ذ أَيْثْ ن إِسْرَائِيل، إِنَّا إِتّْخصَّا أَسنْ أَذْ سّْوجْذنْ ثَاغَارْصْثْ ن ؤُسعْذُو. ");
INSERT INTO rifa_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ؤُشَا نِيثْنِي سّْوجْذنْ ثَاغَارْصْثْ ن ؤُسعْذُو ذڭْ وَاسّْ وِيسّْ أَرْبعْطَاشْ ن ؤُيُورْ أَمزْوَارُو ذِي ڒخْڒَا ن سِينَا، جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ، عْلَاحْسَابْ مَارَّا مِينْ ذ أَسْ يُومُورْ سِيذِي إِ مُوسَا، أَمُّو إِ ت سّْوجْذنْ أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","شَا ن يرْيَازنْ تّْوَاسّْخمْجنْ س ڒْخشْبثْ ن إِجّْ ن بْنَاذمْ إِمُّوثنْ ؤُشَا وَارْ زمَّارنْ أَذْ سّْوجْذنْ ثَاغَارْصْثْ ن ؤُسعْذُو. خْ ؤُيَا قَارّْبنْ-د نِيثْنِي ذڭْ وَاسّْ نِّي زَّاثْ إِ وُوذمْ ن مُوسَا ؤُ زَّاثْ إِ وُوذمْ ن هَارُونْ ");
INSERT INTO rifa_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ؤُشَا نَّانْ أَسْ يرْيَازنْ نِّي: ”نشِّينْ نخْمجْ س ڒْخشْبثْ ن إِجّْ ن بْنَاذمْ إِمُّوثنْ. مَايمِّي إِ نتّْوَاسّْبدّْ أَڒَامِي وَارْ نْزمَّارْ أَذْ د-نسّْقَارّبْ ثَاوْهِيبْثْ ن سِيذِي ذڭْ وَاسّْ نّسْ إِتّْوَاڭّنْ ذِي ڒْوسْطْ ن أَيْثْ ن إِسْرَائِيل؟“ ");
INSERT INTO rifa_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","مُوسَا إِنَّا أَسنْ: ”قِّيممْ ثْبدّمْ، حِيمَا أَذْ سْڒغْ مِينْ ذ أَومْ غَا إِوصَّا سِيذِي.“ ");
INSERT INTO rifa_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","”سِيوڒْ أَكْ-ذ أَيْثْ ن إِسْرَائِيل ؤُشَا إِنِي: ’مَاڒَا حذْ زَّايْومْ نِيغْ زِي جِّيڒَاثْ نْومْ إِ د غَا يَاسنْ إِتّْوَاسّخْمجْ زِي ڒْخشْبثْ ن يِيجّْ ن ؤُمتِّينْ، نِيغْ نتَّا ذڭْ وبْرِيذْ ذ أَزِيرَارْ، خنِّي أَذْ إِسّوْجذْ عَاذْ ثَاغَارْصْثْ ن ؤُسعْذُو إِ سِيذِي. ");
INSERT INTO rifa_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ذڭْ ؤُيُورْ وِيسّْ ثْنَاينْ، ذڭْ وَاسّْ وِيسّْ أَرْبعْطَاشْ، جَارْ بدُّو ن وزْينْ ن وَاسّْ أَڒْ د-ثوْضَا ثْمذِّيثْ، أَذْ ت سّْوجْذنْ. خنِّي أَذْ ت شّنْ أَكْ-ذ وغْرُومْ بْڒَا أَنْثُونْ ؤُ أَكْ-ذ ڒبْزَارْ يَارزْڭنْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","وَارْ تّجِّينْ زَّايسْ وَالُو أَڒْ صّْبحْ ؤُشَا وَارْ زَّايسْ تَّارژَّانْ إِغسْ. إِتّْخصَّا أَذْ ت سّْوجْذنْ عْلَاحْسَابْ مَارَّا ثِيوصَّا ن ثْغَارْصْثْ ن ؤُسعْذُو.‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","”مَاڒَا إِجّْ ن ورْيَازْ ذ أَمزْذَاڭْ إِ وَارْ إِدْجِينْ ذڭْ وبْرِيذْ، أَذْ يجّْ أَذْ إِسّوْجذْ ثَاغَارْصْثْ ن ؤُسعْذُو، خنِّي أَذْ إِتّْوَاقسّْ ڒعْمَارْ نِّي زِي ڒْڭنْسْ نّسْ، مِينْزِي نتَّا وَارْ د-إِسّْقَارّبْ شَا ثَاوْهِيبْثْ ن سِيذِي ذِي ڒْوقْثْ نّسْ إِتّْوَاڭّنْ. أَرْيَازْ نِّي أَذْ يَارْبُو دّنْبْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","مَاڒَا إِزْذغْ أَكِيذْومْ إِجّْ ن ؤُبَارَّانِي، ونِّي إِ غَا إِسّْوجْذنْ ثَاغَارْصْثْ ن ؤُسعْذُو ن سِيذِي، خنِّي أَذْ إِسّوْجذْ ثَاغَارْصْثْ ن ؤُسعْذُو عْلَاحْسَابْ ثَاوْصيّثْ ن ثَاغَارْصْثْ ن ؤُسعْذُو ؤُ عْلَاحْسَابْ لْفَارَايِيضْ نّسْ. أَذْ ذِينْ ثِيڒِي إِشْثْ ن ثوْصيّثْ إِ كنِّيوْ، إِ ؤُبَارَّانِي أَمُّو إِ ونِّي د-إِخڒْقنْ ذِي ثمُّورْثْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ذڭْ وَاسّْ مِينْ ذِي ثتّْوَاسّْڭعّذْ ثْزذِّيغْثْ، إِذْڒَا ؤُسيْنُو ثَازذِّيغْثْ أَكْ-ذ ؤُقِيضُونْ ن شّْهَاذثْ ؤُ ذِي دْجِيڒثْ إِضْهَارْ-د خْ ثْزذِّيغْثْ أَمْ ثْمسِّي أَڒْ صّْبحْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","أَمُّو إِ ثُوغَا ڒبْذَا، أَسيْنُو إِذْڒَا إِ-ت ؤُ ذِي دْجِيڒثْ إِضْهَارْ-د أَمْ ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ڒَامِي د-إِڭعّذْ ؤُسيْنُو زِي سنّجْ ن ؤُقِيضُونْ، خنِّي أَوَارْنِي أَيَا فسْينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ ؤُ ذڭْ ومْشَانْ مَانِي ثُوغَا د-إِبدّْ ؤُسيْنُو، ذِينْ إِ وْثِينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","فسْينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ عْلَاحْسَابْ ڒُومُورْ ن سِيذِي ؤُشَا خْ ڒُومُورْ ن سِيذِي وْثِينْ إِقِيضَانْ نْسنْ. مَارَّا ؤُسَّانْ ثُوغَا أَسيْنُو إِقِّيمْ سنّجْ إِ ثْزذِّيغْثْ، قِّيمنْ نِيثْنِي زدّْغنْ ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ڒَامِي د-إِبدّْ ؤُسيْنُو أَطَّاسْ ن وُوسَّانْ سنّجْ إِ ثْزذِّيغْثْ، حْضَانْ أَيْثْ ن إِسْرَائِيل ثَاسخَّارْثْ ن سِيذِي ؤُشَا وَارْ فسْينْ شَا إِقِيضَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ؤُمِي إِقِّيمْ ؤُسيْنُو شْوَايْثْ ن وُوسَّانْ سنّجْ إِ ثْزذِّيغْثْ، خنِّي وْثِينْ نِيثْنِي إِقِيضَانْ نْسنْ عْلَاحْسَابْ ڒُومُورْ ن سِيذِي ؤُ خْ ڒُومُورْ ن سِيذِي فسْينْ إِقِيضَانْ نْسنْ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","مَاڒَا إِمْسَارْ بلِّي أَسيْنُو إِبدّْ ذِينْ زِي دْجِيڒثْ أَڒْ صّْبحْ ؤُشَا إِڭعّذْ ؤُسيْنُو ذِي صّْبحْ، خنِّي فسْينْ نِيثْنِي إِقِيضَانْ نْسنْ. مَا ذڭْ وَاسّْ إِ إِدْجَا نِيغْ ذِي دْجِيڒثْ، خْمِي د-إِڭعّذْ ؤُسيْنُو، فسْينْ نِيثْنِي إِقِيضَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ؤُشَا مَاڒَا إِقِّيمْ ؤُسيْنُو إِبدّْ سنّجْ إِ ثْزذِّيغْثْ ثْنَاينْ ن وُوسَّانْ، نِيغْ إِجّْ ن ؤُيُورْ، نِيغْ أَطَّاسْ ن وُوسَّانْ، أَڒَامِي خَاسْ غَا يَارْسَا، خنِّي قِّيمنْ أَيْثْ ن إِسْرَائِيل تّْخيّْمنْ ذِينِّي، وَارْ فسْينْ شَا إِقِيضَانْ نْسنْ. مَاڒَا إِڭعّذْ ؤُسيْنُو، خنِّي فسْينْ نِيثْنِي إِقِيضَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","خْ ڒُومُورْ ن سِيذِي وْثِينْ إِقِيضَانْ نْسنْ ؤُ خْ ڒُومُورْ ن سِيذِي فسْينْ إِقِيضَانْ نْسنْ. أَقَا حْضَانْ مِينْ ذ أَسنْ يُومُورْ سِيذِي، خْ ڒُومُورْ ن سِيذِي، س ثْسخَّارْثْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","”أڭّْ إِ يِيخفْ نّشْ ثْنَاينْ ن ڒبْوَاقْ إِزِيرَارنْ ن نُّوقَارْثْ، س يِيجّْ ن ؤُمَارْسُو س وفْضِيسْ أَذْ ثنْ ثڭّذْ ؤُشَا أَذْ إِڒِينْ إِ ؤُبَارّحْ ن ثْمسْمُونْثْ ؤُ إِ ؤُسْمُوطِّي ن ڒمْرَاڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","خْمِي ذَايْسنْ غَا سُوضنْ، أَذْ غَاركْ ثْمُونْ ثْمسْمُونْثْ مَارَّا غَارْ وَاذَافْ ن ؤُقِيضُونْ ن ؤُمْسَاڭَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","خْمِي غَا سُوضنْ ذڭْ إِجّْ زِي ثْنَاينْ نِّي، خنِّي مْغِيرْ ڒْحُوكَّامْ، إِزدْجِيفنْ خْ ڒُوڒُوفْ ن إِسْرَائِيل، إِ خَاكْ د غَا إِمُوننْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","خْمِي غَا ثْسُوضمْ س وسْرُودّحْ ذِي ڒْبُوقْ، خنِّي أَذْ مُّوطِّيينْثْ ڒمْرَاڭحْ نِّي إِمَّارْسنْ غَارْ شَّارْقْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","خْمِي غَا ثْسُوضمْ س وسْرُودّحْ ذِي ڒْبُوقْ ثْنَاينْ ن ثْوَاڒَاوِينْ، خنِّي أَذْ مُّوطِّيينْثْ ڒمْرَاڭحْ نِّي إِمَّارْسنْ غَارْ ؤُغزْذِيسْ ن لْجَانُوبْ. أَذْ سُوضنْ س وسْرُودّحْ ؤُمِي غَا مُوطِّيينْ زڭْ ومْشَانْ غَارْ ومْشَانْ نّغْنِي. ");
INSERT INTO rifa_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","إِ ثْمسْمُونْثْ ن وڭْرَاوْ ن ڒْڭنْسْ إِتّْخصَّا أَذْ ثْسُوضمْ ذِي ڒبْوَاقْ، مَاشَا بْڒَا أَسْرُودّحْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","أَذْ سُوضنْ وَارَّاوْ ن هَارُونْ، إِكهَّاننْ، ذِي ڒبْوَاقْ. أَذْ ثِيڒِي ذ إِشْثْ ن ثوْصيّثْ إِ ڒبْذَا إِ مَارَّا جِّيڒَاثْ نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","”خْمِي د غَا ثفّْغمْ غَارْ ڭَارَّا ذِي ثمُّورْثْ نْومْ، حِيمَا أَذْ ثْمنْغمْ أَكْ-ذ وغْرِيمْ نِّي كنِّيوْ د-إِهكّْوڒنْ، خنِّي أَذْ ثْسُوضمْ س وسْرُودّحْ ذِي ڒبْوَاقْ ؤُشَا كنِّيوْ أَذْ ثتّْوَاثِيذَارمْ زَّاثْ إِ وُوذمْ ن سِيذِي، أَربِّي نْومْ، ؤُشَا أَذْ ثْنجْممْ زِي ڒْعذْيَانْ نْومْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","أَمُّو ذِي كُوڒْ إِجّْ ن وَاسّْ ن ڒفْرَاحثْ ؤُ ذِي ڒعْيُوذَاثْ إِتّْوَاڭّنْ ؤُ ذڭْ ؤُمزْوَارُو ن إِيُورنْ نْومْ أَذْ ثْسُوضمْ ذِي ڒبْوَاقْ خْمِي غَا ثَاوْيمْ ثِيغَارْصَا ن وشْمَاضْ نْومْ ذ ثْغَارْصَا ن ؤُقَاذِي نْومْ ؤُشَا أَمُّو إِ غَا إِڒِينْثْ ذِي طّْوعْ نْومْ إِ ڒِيذَارثْ زَّاثْ إِ وُوذمْ ن أَربِّي، نشّْ ذ سِيذِي، أَربِّي نْومْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","إِمْسَارْ ذڭْ ؤُسڭّْوَاسْ وِيسّْ ثْنَاينْ، ذڭْ ؤُيُورْ وِيسّْ ثْنَاينْ، ذڭْ وَاسّْ وِيسّْ عِيشْرِينْ ن ؤُيُورْ، أَقَا إِتّْوَاسّْڭعّذْ ؤُسيْنُو زِي سنّجْ ن ثْزذِّيغْثْ ن شّْهَاذثْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ؤُشَا فسْينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ، مُّوطِّيينْ زڭْ ومْشَانْ غَارْ ومْشَانْ زِي ڒخْڒَا ن سِينَا ؤُشَا إِبدّْ-د ؤُسيْنُو ذِي ڒخْڒَا ن فَارَانْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","أَمُّو فسْينْ إِقِيضَانْ نْسنْ ثْوَاڒَا ثَامزْوَارُوثْ، خْ ڒُومُورْ ن سِيذِي، خْ ؤُفُوسْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ذ أَمزْوَارُو ثتّْوَاكّسْ ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن أَيْثْ ن يَاهُوذَا، ؤُيُورنْ أَمْ تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. نَاحْشُونْ، مِّيسْ ن عَامِّينَاذَابْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","نَاثَانَايِيلْ، مِّيسْ ن صُوغَارْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن إِسَّاكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","إِلِييَابْ، مِّيسْ ن حِيلُونْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن زِيبُولُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","أَوَارْنِي مَانْ أَيَا هذْمنْ ثْزذِّيغْثْ ؤُشَا فسْينْ أَيْثْ ن جَارْشُونْ ذ أَيْثْ ن مَارَارِي إِقِيضَانْ نْسنْ ؤُشَا أَرْبُونْ ثَازذِّيغْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","خنِّي ثتّْوَاكّسْ ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن رُوبِينْ ؤُيُورنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. إِلِيصُورْ، مِّيسْ ن شَاذَايُورْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","شَالُومِييِيلْ، مِّيسْ ن صُورِيشَادَّايْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن شِيمْعُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","إِلْيَاسَافْ، مِّيسْ ن ذَاعُويِيلْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن جَاذْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","خنِّي فسْينْ أَيْثْ ن قَاهَاثْ إِقِيضَانْ نْسنْ، أَرْبُونْ زَّاوشْثْ إِقدّْسنْ. ؤُشَا أَيْثْ ن جَارْشُونْ ذ أَيْثْ ن مَارَارِي بْنَانْ ثَازذِّيغْثْ قْبڒْ ثْوَاسِيثْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","أَوَارْنِي أَسْ ثتّْوَاكّسْ ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن أَيْثْ ن إِفْرَايِيمْ، ؤُيُورنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. إِلِيشَامَاعْ، مِّيسْ ن عَامِّيهُوذْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","جَامَالِييِيلْ، مِّيسْ ن فَاذَاهْصُورْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن مَانَاسَّا. ");
INSERT INTO rifa_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","أَبِيذُونْ، مِّيسْ ن جِيذْعُونِي، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن بِينْيَامِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","خنِّي ثتّْوَاكّسْ ثْعدْجَانْثْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ ن أَيْثْ ن ذَانْ، أَمْ ؤُغزْذِيسْ ؤُنڭَّارْ ن مَارَّا ڒمْرَاڭحْ، ؤُشَا ؤُيُورنْ، تّْوَاستّْفنْ عْلَاحْسَابْ ثِيرْبِيعِينْ ن ڒْعسْكَارْ نْسنْ. أَخِيعَازَارْ، مِّيسْ ن عَامِّيشَادَّايْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","فَاجْعِييِيلْ، مِّيسْ ن عُوكْرَانْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن أَشِيرْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","أَخِيرَاعْ، مِّيسْ ن عِينَانْ، ثُوغَا ذ أَزدْجِيفْ خْ ڒْعسْكَارْ ن ثقْبِيتْشْ ن أَيْثْ ن زِيبُولُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","أَمُّو إِ سّْمُوطِّيينْ أَيْثْ ن إِسْرَائِيل إِقِيضَانْ نْسنْ زڭْ ومْشَانْ غَارْ ومْشَانْ، أَمْ تّْوَاستّْفنْ نِيثْنِي عْلَاحْسَابْ ڒْعسْكَارَاثْ نْسنْ، أَمُّو إِ فسْينْ نِيثْنِي إِقِيضَانْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","إِنَّا مُوسَا إِ حُوبَابْ، مِّيسْ ن رَاعُويِيلْ، أَمِيذْيَانِي، أَضڭّْوَاڒْ ن مُوسَا: ”نشِّينْ أَذْ نمُّوطِّي غَارْ ومْشَانْ إِ ذ أَنغْ إِنَّا سِيذِي: ’نشّْ أَذْ أَومْ ث-إِ-د وْشغْ!‘ أَسْ-د أَكِيذْنغْ، أَذْ أَشْ نڭّْ ثْشُونِي، مِينْزِي سِيذِي إِسِّيوڒْ خْ إِسْرَائِيل س ڒْخِيرْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","نتَّا إِنَّا أَسْ: ”نشّْ وَارْ تّْرِيحغْ، مَاغَارْ أَذْ ؤُيُورغْ غَارْ ثمُّورْثْ إِنُو ؤُ غَارْ ڒَادْجْ إِنُو.“ ");
INSERT INTO rifa_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ؤُشَا نتَّا إِنَّا أَسْ: ”تّْزَاوْڭغْ شكْ، وَارْ ذ أَنغْ تّجِّي، مِينْزِي شكْ ثسّْنذْ مَامّشْ إِشُووَّارْ أَذْ نوّثْ إِقِيضَانْ نّغْ. شكْ أَقَا ثْذوْڒذْ أَنغْ - أَمْ مَامّشْ نقَّارْ - أَمْ ثِيطَّاوِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","خْمِي غَا ثْرَاحذْ أَكِيذْنغْ ؤُشَا أَذْ أَنغْ د-يَاسْ ڒْخِيرْ إِ ذَايْنغْ غَا إِڭّْ سِيذِي، أَقَا نشِّينْ أَذْ أَشْ نڭّْ ثْشُونِي عَاوذْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ؤُشَا فسْينْ إِقِيضَانْ نْسنْ، ؤُيُورنْ زڭْ وذْرَارْ ن سِيذِي ثِيشْڒِي ن ثْڒَاثَا ن وُوسَّانْ. تَّابُوثْ ن ڒْعَاهْذْ ثُويُورْ زَّاثْ إِ وُوذمْ نْسنْ ثِيشْڒِي ن ثْڒَاثَا ن وُوسَّانْ، حِيمَا أَذْ يَارْزُو خْ إِجّْ ن ومْشَانْ إِ أَرَّاحثْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ذڭْ ؤُزِيڒْ ثُوغَا أَسيْنُو ن سِيذِي سنّجْ نْسنْ ؤُمِي كّْسنْ إِقِيضَانْ نْسنْ زِي ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ڒَامِي ثتّْوَاسّْمُوطِّي تَّابُوثْ، ثمْسَارْ ڒبْذَا بلِّي مُوسَا إِنَّا: ”كَّارْ، أَ سِيذِي، أجّْ ڒعْذْيَانْ نّشْ أَذْ مّْزدْجَاعنْ ؤُ إِنِّي كنِّيوْ إِشَارّْهنْ أَذْ أَروْڒنْ زڭْ وُوذمْ نّشْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","غَارْ ؤُبذِّي ن تَّابُوثْ، إِنَّا: ”ذْوڒْ-د، أَ سِيذِي، غَارْعشْرَا ن ڒُوڒُوفْ ن ڒُوڒُوفْ ن إِسْرَائِيل!“ ");
INSERT INTO rifa_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","إِمْسَارْ ؤُمِي إِذْوڒْ ڒْڭنْسْ أَمْ يِيجّْ ن ؤُبَارُّو إِتّْشثْشَانْ، ثُوغَا مَانْ أَيَا ذ ڒحْرِيقْ إِ إِمزُّوغنْ ن سِيذِي. ڒَْامِي إِسْڒَا سِيذِي أَيَا، يَارْغَا وغْضَابْ نّسْ ؤُ ثِيمسِّي ن سِيذِي ثَارْغَا ذِي ڒْوسْطْ نْسنْ ؤُشَا ثشَّا ڒضْرُوفْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","خنِّي إِڒَاغَا-د ڒْڭنْسْ خْ مُوسَا ؤُشَا مُوسَا إِژُّودْجْ إِ سِيذِي ؤُشَا ثخْسِي ثْمسِّي. ");
INSERT INTO rifa_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ؤُشَا إِڒَاغَا أَسْ إِ ومْشَانْ نِّي ’ثَابْعِيرَا‘، مِينْزِي ثِيمسِّي ن سِيذِي ثُوغَا ثَارْغَا ذِي ڒْوسْطْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","أَبَارُّو إِمْخدْجَاضنْ ن إِبَارَّانِييّنْ نِّي إِدْجَانْ ذِي ڒْوسْطْ نْسنْ، ذوْڒنْ شُورّنْ س ؤُمژْرِي ؤُ بْذَانْ أَيْثْ ن إِسْرَائِيل عَاوذْ أَذْ شتّْشَانْ، نَّانْ: ”وِي ذ أَنغْ غَا إِوْشِينْ أَيْسُومْ؟ ");
INSERT INTO rifa_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","نْعقّڒْ عَاذْ خْ إِسڒْمَانْ نِّي نشَّا ذِي مِيصْرَا بَاطڒْ ؤُ خْ ڒخْيَارْ ذ دّلَّاعْ ذ ڒبْصڒْ يُوژْغنْ ذ ڒبْصڒْ ذ ثِيشَّارْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ڒخُّو ڒعْمُورْ نّغْ ؤُژْغنْ ؤُشَا وَارْ ذِينْ وَالُو مْغِيرْ ’مَانَّا‘-يَا زَّاثْ إِ ثِيطَّاوِينْ نّغْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ثُوغَا ’مَانَّا‘ إِتّمْشَابهْ ذِي زَّارِيعثْ ن ڒْقصْبُورْ ؤُشَا شُّوفْ نّسْ أَمشْنَاوْ شُّوفْ ن ؤُسرْغَاغْ أَشمْڒَاڒْ قَّارنْ أَسْ ’بذُولَا‘. ");
INSERT INTO rifa_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ڒْڭنْسْ إِفّغْ، إِمّْسبْضَا ؤُشَا يْرُونْ ت ؤُشَا حَارْينْ ت سَاذُو ثْسِيرْثْ نِيغْ دّْزنْ ت س وزْذُوزْ ؤُشَا خنِّي سّنْڭّْونْ ت ذِي أَرْوَا ؤُشَا ڭِّينْ زَّايسْ ثِيفْضِيرِينْ. ثُوغَا أَڒذِّي نّسْ أَمْ مِينْ إِنْڭّْوَانْ س زّشْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","خْمِي د-إِهكّْوَا نّْذَا خْ ڒْمَارْڭحْ ن ڒْعسْكَارْ، خنِّي ثْهكّْوَا-د خَاسْ ’مَانَّا‘ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ؤُشَا إِسْڒَا مُوسَا أَقَا ڒْڭنْسْ إِسْغُويْ، ڒَادْجْ أَوَارْنِي إِنّغْنِي، كُوڒْ إِجّْ غَارْ وَاذَافْ ن ؤُقِيضُونْ نّسْ. يَارْغَا وغْضَابْ ن سِيذِي أَطَّاسْ، ؤُشَا ثُوغَا مَانْ أَيَا ؤُڒَا ذ ثُوعفّْنَا ذِي ثِيطَّاوِينْ ن مُوسَا. ");
INSERT INTO rifa_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","إِنَّا مُوسَا إِ سِيذِي: ”مَايمِّي ثڭِّيذْ ڒْغَارْ ذڭْ ؤُمْسخَّارْ نّشْ ؤُ مَايمِّي وَارْ ؤُفِيغْ ڒْخَاضَارْ ذِي ثِيطَّاوِينْ نّشْ، ؤُمِي خَافِي د-ثسَّارْسذْ دّْقڒْ ن مَارَّا ڒْڭنْسْ-أَ؟ ");
INSERT INTO rifa_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","مَا نشّْ ذيْسغْ بَالَاكْ س مَارَّا ڒْڭنْسْ-أَ؟ نِيغْ نشّْ إِ-ث-إِ-د يُورْونْ، مَاحنْذْ ثْزمَّارذْ أَذْ أَيِي ثِينِيذْ: ’أَوْيِي ث ذڭْ وشْيُونْ نّشْ!‘، أَمْ ونِّي إِسُّوطُّوضنْ يَاربُّو أَسيْمِي، غَارْ ثمُّورْثْ مِينْ خفْ ثجُّودْجذْ شكْ إِ ڒجْذُوذْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","زِي مَانِيسْ ذ أَسنْ-د غَا يَاوْيغْ أَيْسُومْ إِ غَا وْشغْ ذ مَاشَّا إِ مَارَّا ڒْڭنْسْ-أَ؟ مِينْزِي نِيثْنِي سْغُويُّونْ-د غَارِي، قَّارنْ: ’أوْشْ أَنغْ أَيْسُومْ إِ غَا نشّْ!‘ ");
INSERT INTO rifa_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","نشّْ وحّْذِي وَارْ زمَّارغْ أَذْ أَرْبُوغْ ڒْڭنْسْ-أَ مَارَّا، أَقَا مَانْ أَيَا إِذْقڒْ خَافِي أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","مَاڒَا ذَايِي ثڭِّيذْ أَمُّو، نشّْ تّْزَاوَاڭغْ أَذْ أَيِي ثنْغذْ حْسنْ، مَاڒَا ؤُفِيغْ أَرْضَا ذِي ثِيطَّاوِينْ نّشْ، خنِّي نشّْ وَارْ ژَترّغْ ڒغْبنْ إِنُو عَاذْ كْثَارْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","خنِّي إِنَّا سِيذِي إِ مُوسَا: ”سْمُونْ أَيِي-د سبْعِينْ ن يرْيَازنْ زڭْ إِمْغَارنْ ن إِسْرَائِيل، إِنِّي ثسّْنذْ شكْ ذ إِمْغَارنْ ن ڒْڭنْسْ ؤُ ذ إِمحْضَاينْ. أَوْيِي ثنْ-د غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ ؤُشَا أجّْ إِثنْ أَذْ ذِينْ بدّنْ زَّاثكْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","خنِّي نشّْ أَذْ هْوِيغْ ؤُشَا أَذْ كِيكْ سِّيوْڒغْ. أَذْ كْسِيغْ زِي أَرُّوحْ إِ خَاكْ إِدْجَانْ ؤُشَا أَذْ خَاسنْ ث سَّارْسغْ. أَمُّو إِ كِيكْ غَا أَرْبُونْ دّْقڒْ ن ڒْڭنْسْ-أَ، مَاحنْذْ وَارْ ث ثَاربُّوذْ شَا وحّْذكْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","أَذْ ثِينِيذْ إِ ڒْڭنْسْ: ’سْقدّْسمْ إِخفْ نْومْ إِ ثِيوشَّا، خنِّي أَذْ ثشّمْ أَيْسُومْ، مِينْزِي أَقَا ثْرُومْ ذڭْ إِمزُّوغنْ ن سِيذِي، ثنَّامْ: وِي ذ أَنغْ غَا إِوْشنْ أَذْ نشّْ أَيْسُومْ؟ ثُوغَا-نغْ مْلِيحْ ذِي مِيصْرَا! س ؤُيَا إِ ذ أَومْ غَا إِوْشْ سِيذِي أَيْسُومْ أَذْ ثشّمْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","وَارْ ث ثتّتّمْ إِجّْ ن وَاسّْ وَاهَا ؤُڒَا ذ ثْنَاينْ ن وُوسَّانْ، نِيغْ خمْسَا ن وُوسَّانْ، نِيغْعشْرَا ن وُوسَّانْ، نِيغْ عِيشْرِينْ ن وُوسَّانْ، ");
INSERT INTO rifa_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","مَاشَا مَارَّا ؤُسَّانْ ن ؤُيُورْ أَڒْ ذ أَومْ د-إِفّغْ زڭْ ونْزَارنْ نْومْ ؤُشَا أَذْ زَّايسْ ثْعِيفّمْ، ؤُمِي ثنْضَارمْ سِيذِي ونِّي إِدْجَانْ ذِي ڒْوسْطْ نْومْ، ؤُشَا ثْرُومْ زَّاثْ إِ ؤُغمْبُوبْ نّسْ، ثنَّامْ: مَايمِّي عَاذْ د-نفّغْ زِي مِيصْرَا؟‘ “ ");
INSERT INTO rifa_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ؤُشَا مُوسَا إِنَّا: ”ڒْڭنْسْ-يَا، ذِي ڒْوسْطْ نْسنْ إِ دْجِيغْ، أَقَا-ث ذِي ستَّا-أَڒَافْ ن يرْيَازنْ خْ إِضَارنْ ؤُشَا شكْ ثقَّارذْ: ’أَذْ أَسنْ وْشغْ أَيْسُومْ ؤُشَا أَذْ زَّايسْ شّنْ إِجّْ ن ؤُيُورْ أَمنْ إِكْمڒْ!‘ ");
INSERT INTO rifa_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","مَاڒَا غَارْصنْ أَسنْ إِ مَارَّا وُودْجِي ذ إِفُونَاسنْ، مَا أَذْ يِيڒِي شْفَا أَسنْ؟ نِيغْ مَاڒَا سّْمُوننْ أَسنْ مَارَّا إِسڒْمَانْ ن ڒبْحَارْ، مَا أَذْ يِيڒِي شْفَا أَسنْ؟“ ");
INSERT INTO rifa_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","إِنَّا سِيذِي إِ مُوسَا: ”مَا خنِّي يبْرِي ؤُفُوسْ ن سِيذِي؟ ڒخُّو خنِّي، أَذْ ثْژَارذْ مَا أَذْ إِقْفڒْ أَوَاڒْ نّسْ نِيغْ لَّا!“ ");
INSERT INTO rifa_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","إِفّغْ-د مُوسَا ؤُشَا إِنَّا أَوَاڒنْ ن سِيذِي إِ ڒْڭنْسْ ؤُشَا إِسّْمُونْ سبْعِينْ ن يرْيَازنْ زڭْ إِمْغَارنْ ن ڒْڭنْسْ ؤُشَا إِسّْبدّْ إِ-ثنْ أَمْ د-نّْضنْ إِ ؤُقِيضُونْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","خنِّي إِهْوَا-د سِيذِي ذڭْ ؤُسيْنُو ؤُشَا إِسِّيوڒْ أَكِيذسْ ؤُشَا إِكْسِي زِي أَرُّوحْ نِّي ثُوغَا خَاسْ ؤُشَا إِسَّارْسْ إِ-ث خْ سبْعِينْ ن يرْيَازنْ، خْ إِمْغَارنْ. ؤُشَا إِمْسَارْ، ؤُمِي ثُوغَا خَاسنْ أَرُّوحْ، بْذَانْ أَذْ نبَّانْ، مَاشَا أَوَارْنِي إِ ؤُيَا وَارْ إِقِّيمْ عَاذْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ؤُشَا قِّيمنْ ثْنَاينْ ن يرْيَازنْ ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ، إِجّنْ قَّارنْ أَسْ إِلْذَاذْ ؤُ ونّغْنِي قَّارنْ أَسْ مِيذَاذْ ؤُشَا أَرُّوحْ ن سِيذِي ثُوغَا-ث خَاسنْ، مِينْزِي نِيثْنِي أَقَا أَثنْ زڭْ إِنِّي يُورَانْ، مَاشَا وَارْ د-فِّيغنْ غَارْ ؤُقِيضُونْ ؤُشَا ثُوغَا تّْنبَّانْ ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","يُوزّڒْ-د إِجّْ ن ؤُحنْجِيرْ ؤُشَا إِخبَّارْ مَانْ أَيَا إِ مُوسَا، إِنَّا: ”إِلْذَاذْ ذ مِيذَاذْ تّْنبَّانْ ذِي ڒْمَارْڭحْ ن ڒْعسْكَارْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","يَارَّا-د يَاشُووَا، مِّيسْ ن نُونْ، إِجّنْ زڭْ إِبْڒِيغنْ إِتّْفَارْزنْ، إِنَّا: ”سِيذِي إِنُو، مُوسَا، حَارّمْ إِ-ثنْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","إِنَّا أَسْ مُوسَا: ”مَا شكْ ثشْضَارذْ ذِي طّْوعْ إِنُو؟ مْڒِي مَارَّا ڒْڭنْسْ ن سِيذِي ثُوغَا-ث مَارَّا ذ إِنَابِييّنْ، إِڒِي إِڭَّا خَاسنْ سِيذِي أَرُّوحْ نّسْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","إِذْوڒْ-د مُوسَا غَارْ ڒْمَارْڭحْ ن ڒْعسْكَارْ، نتَّا ذ إِمْغَارنْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","خنِّي يُوسَا-د إِجّْ ن ؤُسمِّيضْ، إِسّكَّارْ إِ-ث سِيذِي، إِنْذهْ-د إِجْضَاضْ قَّارنْ أَسْ ’ثْسَالْوَا‘ زِي ڒبْحَارْ ؤُشَا إِنْضَارْ إِ-ثنْثْ خْ ڒْمَارْڭحْ ن ڒْعسْكَارْ، ثِيشْڒِي ن وبْرِيذْ ن إِجّْ ن وَاسّْ غَارْ إِجّْ ن ثْمَا ذ ثِيشْڒِي ن وبْرِيذْ غَارْ ثْمَا نّغْنِي، ذڭْ ونّضْ ن ڒْمَارْڭحْ ن ڒْعسْكَارْ، أَڒْ عْڒَاينْ ثْنَاينْ ن إِغَادْجنْ خْ وُوذمْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","إِكَّارْ ڒْڭنْسْ ؤُشَا أَسّْ نِّي إِكْمڒْ ذ دْجِيڒثْ نِّي ثكْمڒْ ذ مَارَّا أَسّْ إِ ث-إِ-د إِضْفَارنْ يْرُونْ نِيثْنِي إِجْضَاضْ قَّارنْ أَسْ ’ثْسَالْوَا‘. ونِّي غَارسْ ذْرُوسْ، إِكْسِيعشْرَا إِحُومِيرنْ. بزّْعنْ ثنْثْ قِيبَاتْشْ نْسنْ خْ ثِيرُو إِ إِنّْضنْ إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","مِينْثْرَا أَيْسُومْ عَاذْ جَارْ ثغْمَاسْ نْسنْ، قْبڒْ مَا أَذْ ث فّْژنْ، يَارْغَا وغْضَابْ ن سِيذِي خْ ڒْڭنْسْ ؤُشَا سِيذِي إِوْثَا ڒْڭنْسْ س إِشْثْ ن ثشْثِي ثمْغَارْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","إِسمَّا مُوسَا أَمْشَانْ نِّي ’قَابَارُوثْ-هَاثَاآوَاثْ‘، مِينْزِي ذِينِّي إِ نضْڒنْ ڒْڭنْسْ إِ ثُوغَا إِمّژْرنْ أَمُّو. ");
INSERT INTO rifa_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","زِي قَابَارُوثْ-هَاثَاآوَاثْ إِفْسِي ڒْڭنْسْ إِقِيضَانْ نّسْ، ؤُيُورنْ غَارْ حَاضَايْرُوثْ ؤُشَا قِّيمنْ ذِي حَاضَايْرُوثْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ثسِّيوڒْ مَارْيَامْ أَكْ-ذ هَارُونْ خْ مُوسَا ذِي سِّيبّثْ ن ثمْغَارْثْ ثَاكُوشِيثْ نِّي ثُوغَا د-يِيوِي، مِينْزِي نتَّا يِيوِي-د إِشْثْ ن ثمْغَارْثْ ثَاكُوشِيثْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ؤُشَا نَّانْ: ”مَا إِسِّيوڒْ سِيذِي زِي مُوسَا وَاهَا؟ مَا وَارْ زَّايْنغْ إِسِّيوڒْ عَاوذْ؟“ ؤُشَا إِسْڒَا سِيذِي مَانْ أَيَا. ");
INSERT INTO rifa_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ثُوغَا مُوسَا ذ أَرْيَازْ أَمْوَاضعْ أَطَّاسْ، كْثَارْ زِي مَارَّا إِوْذَانْ إِ إِدَّارنْ خْ ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ذغْيَا إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا ذ هَارُونْ ذ مَارْيَامْ: ”فّْغمْ كنِّيوْ س ثْڒَاثَا، ؤُيُورمْ غَارْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ!“ ؤُشَا فّْغنْ-د س ثْڒَاثَا. ");
INSERT INTO rifa_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","خنِّي إِهْوَا-د سِيذِي ذڭْ ؤُقلِّيجْ ن ؤُسيْنُو ؤُشَا إِبدّْ غَارْ وَاذَافْ ن ؤُقِيضُونْ، إِڒَاغَا إِ هَارُونْ ذ مَارْيَامْ. فّْغنْ-د نِيثْنِي س ثْنَاينْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ؤُشَا إِنَّا أَسنْ نتَّا: ”سْڒمْ خنِّي إِ وَاوَاڒنْ إِنُو! مَاڒَا ذِينْ جَارْ أَومْ إِجّْ ن ؤُنَابِي، أَذْ أَسْ سّشْنغْ إِخفْ إِنُو، نشّْ، سِيذِي، س إِجْ ن ڒوْحِييْ ؤُشَا أَذْ كِيسْ سِّيوْڒغْ س إِشْثْ ن ثَارْجِيثْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","مَاشَا وَارْ تّڭّغْ أَمنِّي س ؤُمْسخَّارْ إِنُو مُوسَا، أَقَا نتَّا ذ أَمْثِيقِّي ذِي ثَادَّارْثْ إِنُو ثكْمڒْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","نشّْ سِّيوْڒغْ أَكِيذسْ زڭْ ؤُقمُّومْ غَارْ ؤُقمُّومْ، وَارْ إِدْجِي س ڒمْعَانِي إِنُّوفَارنْ. أَقَا إِژْرَا أَدُّوذْ ن سِيذِي. مَايمِّي وَارْ ثڭّْوِيذمْ زڭْ ؤُمْسخَّارْ إِنُو ؤُ مَايمِّي إِ ثسِّيوْڒمْ أَمُّو خْ مُوسَا؟“ ");
INSERT INTO rifa_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","خنِّي يَارْغَا خَاسنْ وغْضَابْ ن سِيذِي ؤُشَا إِرُوحْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ؤُشَا أَسيْنُو إِفّغْ خْ ؤُقِيضُونْ، ؤُشَا خْزَارْ، مَارْيَامْ ذَايسْ ڒهْڒَاشْ ن ڒْبَارْصْ، أَقَا-ت ذ ثَاشمْڒَاڒْثْ أَمْ وذْفڒْ. ؤُشَا هَارُونْ إِنّقْڒبْ-د غَارْ مَارْيَامْ، ؤُ خْزَارْ، أَقَا نتَّاثْ ذَايسْ ڒْبَارْصْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ؤُشَا إِنَّا هَارُونْ إِ مُوسَا: ”أَ، سِيذِي إِنُو، وَارْ خَانغْ سْرُوسِّي دّنْبْ إِ نڭَّا س ثفْغُورِي ؤُمِي ذَايسْ نخْضَا! ");
INSERT INTO rifa_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","وَارْ ت تّجِّي أَذْ ثذْوڒْ أَمْ ؤُمتِّينْ إِ زِي إِتّْوَاشّْ وزْينْ ن أَرِّيمثْ نّسْ أَمْ د-ثفّغْ زِي ڒمْڒَاوثْ ن يمَّاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","إِڒَاغَا مُوسَا إِ سِيذِي، إِنَّا: ”أَ أَربِّي، تّْزَاوَاڭغْ أَذْ ت ثسّْڭنْفِيذْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","إِنَّا سِيذِي إِ مُوسَا: ”مَا مَاڒَا بَابَاسْ أَقَا إِنْخَارْ ذڭْ وُوذمْ نّسْ، مَا وَارْ ثسضْحِي سبْعَا ن وُوسَّانْ؟ أجّْ إِ-ت أَذْ ثتّْوَاسُّوفّغْ زِي ڒْمَارْڭحْ ن ڒْعسْكَارْ سبْعَا ن وُوسَّانْ ؤُشَا أَوَارْنِي أَسْ أَذْ ثتّْوَاقْبڒْ عَاوذْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ثتّْوَاسُّوفّغْ مَارْيَامْ سبْعَا ن وُوسَّانْ بَارَّا إِ ڒْمَارْڭحْ ن ڒْعسْكَارْ ؤُشَا ڒْڭنْسْ وَارْ إِكِّيسْ إِقِيضَانْ نّسْ أَڒَامِي ثتّْوَاقْبڒْ مَارْيَامْ عَاوذْ. ");
INSERT INTO rifa_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","أَوَارْنِي مَانْ أَيَا إِفْسِي ڒْڭنْسْ إِقِيضَانْ نّسْ، يُويُورْ زِي حَاضَايْرُوثْ ؤُشَا وْثِينْ إِقِيضَانْ نْسنْ ذِي ڒخْڒَا ن فَارَانْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","إِسِّيوڒْ سِيذِي أَكْ-ذ مُوسَا، إِنَّا: ");
INSERT INTO rifa_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","”سكّْ إِرْيَازنْ زَّاثكْ حِيمَا أَذْ برْڭَاڭنْ ثَامُّورْثْ ن كنْعَانْ، ثنِّي إِ غَا وْشغْ إِ أَيْثْ ن إِسْرَائِيل. إِ كُوڒْ ثَاقْبِيتْشْ ن ڒجْذُوذْ أَذْ ثسّكّمْ إِجّْ ن ورْيَازْ، كُوڒْ إِجّْ أَذْ يِيڒِي ذ ڒْحَاكمْ جَارْ أَسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","مُوسَا إِسّكّْ إِ-ثنْ زِي ڒخْڒَا ن فَارَانْ، خْ ڒُومُورْ ن سِيذِي. ثُوغَا مَارَّا إِرْيَازنْ نِّي ذ إِزدْجِيفنْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","أَقَا ذ إِنَا ذ إِسْمَاونْ نْسنْ: زِي ثقْبِيتْشْ ن رُوبِينْ، شَامُّوعْ، مِّيسْ ن زَاكُّورْ، ");
INSERT INTO rifa_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","زِي ثقْبِيتْشْ ن شِيمْعُونْ، شَافَاثْ، مِّيسْ ن أَخُورِي، ");
INSERT INTO rifa_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","زِي ثقْبِيتْشْ ن يَاهُوذَا، كَالِيبْ، مِّيسْ ن يَافُونِّي، ");
INSERT INTO rifa_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","زِي ثقْبِيتْشْ ن إِسَّاكَارْ، يِيجْعَالْ، مِّيسْ ن يُوسُوفْ، ");
INSERT INTO rifa_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","زِي ثقْبِيتْشْ ن إِفْرَايِيمْ، هُوشَاعْ، مِّيسْ ن نُونْ، ");
INSERT INTO rifa_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","زِي ثقْبِيتْشْ ن بِينْيَامِينْ، فَالْطِي، مِّيسْ ن رَافُو، ");
INSERT INTO rifa_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","زِي ثقْبِيتْشْ ن زابُولُونْ، جَاذِّييِيلْ، مِّيسْ ن سُوذِي، ");
INSERT INTO rifa_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","زِي ثقْبِيتْشْ ن يُوسُوفْ، إِ ثقْبِيتْشْ ن مَانَاسَّا، جَاذِّي، مِّيسْ ن سُوسِي، ");
INSERT INTO rifa_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","زِي ثقْبِيتْشْ ن ذَانْ، عَامِّييِيلْ، مِّيسْ ن جَامَالِّي، ");
INSERT INTO rifa_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","زِي ثقْبِيتْشْ ن أَشِيرْ، سَاثُورْ، مِّيسْ ن مِيخَايِيلْ، ");
INSERT INTO rifa_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","زِي ثقْبِيتْشْ ن نَافْثَالِي، نَاحْبِي، مِّيسْ ن وَافْسِي، ");
INSERT INTO rifa_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","زِي ثقْبِيتْشْ ن جَاذْ، جَا‘ؤُيِيلْ، مِّيسْ ن مَاكِي. ");
INSERT INTO rifa_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","أَقَا إِنَا ذ إِسْمَاونْ ن يرْيَازنْ نِّي إِسّكّْ مُوسَا حِيمَا أَذْ برْڭَاڭنْ ثَامُّورْثْ ؤُشَا مُوسَا إِڒَاغَا إِ هُوشِيعَا، مِّيسْ ن نُونْ، س يِيسمْ ن يَاشُووَا. ");
INSERT INTO rifa_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","إِسّكّْ إِ-ثنْ مُوسَا حِيمَا أَذْ برْڭَاڭنْ ثَامُّورْثْ ن كنْعَانْ، إِنَّا أَسنْ: ”أَڒْيمْ سِّيهَا أَڒْ ثَامُّورْثْ ن لْجَانُوبْ ؤُشَا أَڒْيمْ خنِّي غَارْ إِذُورَارْ، ");
INSERT INTO rifa_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ؤُشَا خْزَارمْ مَامّشْ ثدْجَا ثمُّورْثْ ذ ڒْڭنْسْ إِ ذَايسْ إِزدّْغنْ، مَا إِجْهذْ نِيغْ إِضْعفْ إِ يدْجَا، مَا أَقَا ذِينْ ذْرُوسْ نِيغْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","خْزَارمْ عَاوذْ مَامّشْ ثدْجَا ثمُّورْثْ إِ ذِي إِزدّغْ ڒْْڭنْسْ، مَا ثَامُّورْثْ ذ ثَاصبْحَانْثْ نِيغْ ذ ثَاعفَّانْثْ إِ ثدْجَا، ؤُ مَامّشْ دْجَانْثْ ثْندَّامْ إِ ذِي إِزدّغْ ڒْْڭنْسْ، مَا زدّْغنْ ذِي ڒمْرَاڭحْ ن إِقِيضَانْ نِيغْ ذِي ثْندَّامْ إِفَارْينْ س إِغبْڒَاونْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ؤُ عَاوذْ مَامّشْ ثدْجَا ثمُّورْثْ، مَا ثسّْغمِّي نِيغْ ثُوژغْ، مَا أَقَا ذِينْ ثِيشجُّورَا نِيغْ لَّا. ڭّمْ ثَارْيَاسْثْ ؤُشَا كْسِيمْ شَا زِي ڒْغِيدْجثْ ن ثمُّورْثْ. ؤُسَّانْ نِّي ثُوغَا أَثنْ ذ ؤُسَّانْ ن ثْمنْزُوثْ ن ؤُضِيڒْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ؤُشَا نِيثْنِي ڭعّْذنْ ؤُشَا برْڭَاڭنْ ثَامُّورْثْ زِي ڒخْڒَا ن صِينْ أَڒْ رَاحُوبْ، مَانِي غَا ثِيوْضذْ غَارْ حَامَاثْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ڭعّْذنْ عَاذْ كْثَارْ غَارْ ثمُّورْثْ ن لْجَانُوبْ ؤُشَا إِوْضنْ غَارْ حَابْرُونْ. ذِينِّي إِ ثُوغَا أَخِيمَانْ، شِيشَايْ ذ ثَالْمَايْ، نِيثْنِي ذ إِحنْجِيرنْ ن عَانَاقْ. حَابْرُونْ ثُوغَا ثتّْوَابْنَا سبْعَا ن إِسڭّْوُوسَا قْبڒْ صُوعَانْ ذِي مِيصْرَا. ");
INSERT INTO rifa_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","خنِّي إِوْضنْ أَڒْ ثَاغْزُورْثْ ن أَشْكُولْ ؤُشَا سّنِّي كّْسنْ إِشْثْ ن ثزْرمْثْ س يِيجّْ ن ؤُزكُّونْ ن ؤُضِيڒْ ونِّي د-إِوْينْ س ثْنَاينْ س يِيجّْ ن ؤُزدْجَاضْ ن ثْربُّوثْ. كّْسنْ عَاوذْ زڭْ أَرمَّامْ ؤُ زِي ثَازَارْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","قَّارنْ أَسْ إِ ومْشَانْ نِّي ثَاغْزُورْثْ ن إِشْكُولْ، إِسمْ وَانِيثَا إِخْسْ أَذْ يِينِي ’ثَاغْزُورْثْ ن ؤُزكُّونْ‘، ذِي سِّيبّثْ ن ؤُزكُّونْ ن ؤُضِيڒْ نِّي قسّنْ أَيْثْ ن إِسْرَائِيل ذِينْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ؤُمِي كمّْڒنْ أَربْعِينْ ن وُوسَّانْ، ذوْڒنْ-د زڭْ ؤُبرْڭَاڭْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","عقْبنْ نِيثْنِي ؤُشَا ؤُسِينْ-د غَارْ مُوسَا ذ هَارُونْ ؤُ غَارْ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل ذِي ڒخْڒَا ن فَارَانْ، غَارْ قَاذَاشْ، ؤُشَا وْشِينْ ڒخْبَارْ إِ مَارَّا ثَامسْمُونْثْ ؤُشَا سّشْننْ أَسنْ ڒْغِيدْجثْ ن ثمُّورْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","حَاجَانْ أَسْ، نَّانْ: ”أَقَا نُوذفْ غَارْ ثمُّورْثْ نِّي مَانِي ذ أَنغْ ثسّكّذْ. س ثِيذتّْ ثْفيّضْ س ؤُغِي ذ ثَامّنْثْ ؤُ ثَانِيثَا ذ ڒْغِيدْجثْ نّسْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","مَاشَا ڒْڭنْسْ، ونِّي إِزدّْغنْ ذِي ثمُّورْثْ، إِجْهذْ ؤُ ثِيندَّامْ غَارْسنْثْ إِغبْرَاونْ مْغَارنْثْ أَطَّاسْ، ؤُ نژْرَا عَاوذْ أَرَّاونْ ن عَانَاقْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","أَيْثْ ن عَامَالِيقْ زدّْغنْ ذِي ثمُّورْثْ ن لْجَانُوبْ، ؤُ إِحِيتِّييّنْ ذ إِيابُوسِييّنْ ذ إِمُورِييّنْ زدّْغنْ ذڭْ إِذُورَارْ ؤُ أَيْثْ ن كنْعَانْ زدّْغنْ غَارْ ڒبْحَارْ ؤُ خْ ثْمَا ن لْ-ؤُرْذُونْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","خنِّي إِسّسْقَارْ كَالِيبْ ڒْڭنْسْ زَّاثْ إِ مُوسَا، إِنَّا: ”أجّْ أَنغْ أَذْ نْڭعّذْ س جّهْذْ ؤُشَا أَذْ ت نطّفْ ذ ڒْوَارْثْ، مِينْزِي نْزمَّارْ أَسْ نشِّينْ!“ ");
INSERT INTO rifa_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","مَاشَا إِرْيَازنْ نِّي ڭعّْذنْ أَكِيذسْ، نَّانْ: ”وَارْ نْزمَّارْ أَذْ نْڭعّذْ ضِيدّْ إِ ڒْڭنْسْ نِّي، مِينْزِي أَقَا إِجْهذْ خَانغْ أَطَّاسْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","أَمُّو إِ د-إِوْينْ إِجّْ ن ڒخْبَارْ وَارْ إِحْڒِينْ إِ أَيْثْ ن إِسْرَائِيل خْ ثمُّورْثْ نِّي خْ ثُوغَا تّْبرْڭَاڭنْ، نَّانْ: ”ثَامُّورْثْ خْ مَانِيسْ نكَّا حِيمَا أَذْ ت نْبرْڭڭْ، أَقَا ذ إِشْثْ ن ثمُّورْثْ ثْسَارّضْ إِمزْذَاغْ نّسْ ؤُشَا مَارَّا إِوْذَانْ نِّي نژْرَا، أَقَا أَثنْ ذ إِرْيَازنْ ن وَادَّاذْ إِمْغَارْ. ");
INSERT INTO rifa_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","أَقَا نژْرَا ذِينْ ’نِيفِيلِيمْ‘، إِخْسْ أَذْ يِينِي ’جّْوَاهڒْ إِوْضَانْ‘، أَيْثْ ن عَانَاقْ، أَرَّاسَا ن جّْوَاهڒْ إِوْضَانْ. ثُوغَا نشِّينْ ذِي ثِيطَّاوِينْ نّغْ أَمشْنَاوْ ثَامُورْغِي ؤُشَا أَمُّو إِ د أَسنْ نتّْبَانْ ذِي ثِيطَّاوِينْ نْسنْ.“ ");
INSERT INTO rifa_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","مَارَّا ثَامسْمُونْثْ ثبْذَا ثسْغُويُّو س جّهْذْ ؤُشَا ڒْڭنْسْ إِرُو مَارَّا دْجِيڒثْ نِّي. ");
INSERT INTO rifa_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","مَارَّا أَيْثْ ن إِسْرَائِيل ثُوغَا تّْنذْقَامنْ ضِيدّْ إِ مُوسَا ؤُ ضِيدّْ إِ هَارُونْ ؤُشَا ثنَّا أَسْ مَارَّا ثْمسْمُونْثْ: ”معْلِيكْ قَاعْ نمُّوثْ ذِي ثمُّورْثْ ن مِيصْرَا!“ نِيغْ: ”معْلِيكْ قَاعْ نمُّوثْ ذِي ڒخْڒَا-يَا!“ ");
INSERT INTO rifa_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","”مَايمِّي ذ أَنغْ د-يِيوِي سِيذِي غَارْ ثمُّورْثْ-أَ حِيمَا أَذْ نوْضَا س سِّيفْ ؤُ خنِّي أَذْ ذوْڒنْثْ ثمْغَارِينْ نّغْ ذ ثَارْوَا نّغْ ذ ثَاكشَّاضْثْ؟ مَا وَارْ يدْجِي حْسنْ زعْمَا أَذْ نعْقبْ غَارْ مِيصْرَا؟“ ");
INSERT INTO rifa_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ؤُشَا نَّانْ إِجّْ إِ ونّغْنِي: ”أجّْ أَنغْ أَذْ نڭّْ إِجّْ ذ أَزدْجِيفْ خَانغْ ؤُشَا أَذْ نعْقبْ غَارْ مِيصْرَا!“ ");
INSERT INTO rifa_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ڒخْذنِّي وْضَانْ مُوسَا ذ هَارُونْ خْ ؤُغمْبُوبْ نْسنْ زَّاثْ إِ وُوذمْ ن مَارَّا أَڭْرَاوْ ن ثْمسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","يَاشُووَا، مِّيسْ ن نُونْ، ذ كَالِيبْ، مِّيسْ ن يَافُونِّي، إِنِّي ثُوغَا زڭْ إِنِّي ثُوغَا إِتّْبرْڭَاڭنْ خْ ثمُّورْثْ، شَارّْڭنْ أَرُّوضْ نْسنْ. ");
INSERT INTO rifa_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","نِيثْنِي سِّيوْڒنْ غَارْ مَارَّا ثَامسْمُونْثْ ن أَيْثْ ن إِسْرَائِيل، نَّانْ: ”ثَامُّورْثْ نِّي خْ نكَّا مَاحنْذْ أَذْ ت نْبرْڭڭْ، أَقَا-ت ذ إِشْثْ ن ثمُّورْثْ مْلِيحْ أَطَّاسْ. ");
INSERT INTO rifa_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","مَاڒَا سِيذِي إِسّْفَارْننْ غَارْنغْ، نتَّا أَذْ أَنغْ د-يَاوِي غَارْ ثمُّورْثْ-أَ ؤُشَا أَذْ أَنغْ ت إِوْشْ، إِشْثْ ن ثمُّورْثْ إِفيّْضنْ س ؤُغِي ذ ثَامّنْثْ. ");
INSERT INTO rifa_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","مَاشَا وَارْ تِّيڒِيمْ ذ إِمْغوّْغنْ ضِيدّْ إِ سِيذِي ؤُشَا وَارْ تّڭّْوذمْ شَا زِي ڒْڭنْسْ ن ثمُّورْثْ-أَ، مِينْزِي أَقَا أَثنْ ذ أَغْرُومْ نّغْ. ثِيڒِي نْسنْ ثفّغْ-د سنّجْ نْسنْ، أَقَا سِيذِي أَكِيذْنغْ، وَارْ زَّايْسنْ تّڭّْوْذمْ شَا!“ ");
INSERT INTO rifa_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","مَاشَا ڒَامِي ثسِّيوڒْ مَارَّا ثَامسْمُونْثْ بلِّي إِتّْخصَّا أَذْ ثنْ أَرجْمنْ، إِبَانْ-د ؤُعُودْجِي ن سِيذِي ذڭْ ؤُقِيضُونْ ن ؤُمْسَاڭَارْ زَّاثْ إِ مَارَّا أَيْثْ ن إِسْرَائِيل. ");
INSERT INTO rifa_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","إِنَّا سِيذِي إِ مُوسَا: ”أَڒْ مڒْمِي ذ أَيِي غَا إِسْعَارْ ڒْڭنْسْ-أَ؟ أَڒْ مڒْمِي وَارْ ذ أَيِي تِّيمْننْ س مَارَّا ڒعْڒَامَاثْ نِّي ڭِّيغْ ذِي ڒْوسْطْ نْسنْ؟ ");
INSERT INTO rifa_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","نشّْ أَذْ ثنْ وْثغْ س طَّاعُونْ ؤُشَا أَذْ خَاسنْ كّْسغْ ڒْوَارْثْ ؤُشَا أَذْ 