﻿USE sofia;
DROP TABLE IF EXISTS sofia.rhgc_vpl;
CREATE TABLE rhgc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rhgc_vpl WRITE;
INSERT INTO rhgc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Isá Mosih óilde Dawud or nosól or, aar Dawud óilde Ibrahím or nosól or. Isá Mosihr fissán or foriso endilla: ");
INSERT INTO rhgc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahím or fua Isahák; Isahák or fua Yakub; Yakub or fua Yohúdah edde yóggwar báiyain. ");
INSERT INTO rhgc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yohúdahr fua Fares edde Zera, aar ítarar maa accíl Tamar; Fares or fua Hisron; Hisron or fua Ram. ");
INSERT INTO rhgc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram or fua Amminadab; Amminadab or fua Nacon; Nacon or fua Sálmon. ");
INSERT INTO rhgc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sálmon or fua Boaz, yóggwar maa accíl Rahába; Boaz or fua Obed, yóggwar maa accíl Ruút; Obed or fua Jesi. ");
INSERT INTO rhgc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesir fua baáñcca Dawud. Dawud or fua Sóloman, yóggwar maa óilde Borcíba, zibá age Uriyar bou accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sóloman or fua Rehobom; Rehobom or fua Abiya; Abiyar fua Asa. ");
INSERT INTO rhgc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asar fua Jehócafat; Jehócafat or fua Joram; Joram or fua Uziya. ");
INSERT INTO rhgc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziyar fua Jotam; Jotam or fua Aház; Aház or fua Hézekiya. ");
INSERT INTO rhgc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hézekiyar fua Manasé; Manasér fua Amon; Amon or fua Josíya. ");
INSERT INTO rhgc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíyar fua Jekoníya edde yóggwar báiyain. Ítarar zormo oñtté óoil zeñtté Isráil koum ore bondi banai Babilon dec ot loizar. ");
INSERT INTO rhgc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iín óilde ítara re bondi banai Babilon ot loizai baade: Jekoníyar fua Cáltiyel, Cáltiyel or fua Zerubabel. ");
INSERT INTO rhgc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel or fua Abihúd; Abihúd or fua Eliyakím; Eliyakím or fua Azor. ");
INSERT INTO rhgc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor or fua Sádok; Sádok or fua Akim; Akim or fua Elihúd. ");
INSERT INTO rhgc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihúd or fua Eliyazar; Eliyazar or fua Matan; Matan or fua Yakub. ");
INSERT INTO rhgc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aar Yakub or fua óilde Moriyam or hócom Yusúf. Hé Moriyam ottu Isá zormo óoil, zibá re Mosih bóuli hoó. ");
INSERT INTO rhgc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Héndilla góri Ibrahím ottu lóti Dawud foijjonto soiddó fissán. Dawud ottu lóti Babilon ot bondit loiza foijjonto soiddó fissán; aar bondi banai Babilon ot loiza ttu lóti Mosih foijjonto soiddó fissán. ");
INSERT INTO rhgc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Isá Mosihr zormo endilla gori óiye: Íbar maa Moriyam or zuragatá Yusúf lói óoil, montor ítara milmilab goríbar age, Pak-Ruhr kudurute híba hámil óiye de faa giyéh. ");
INSERT INTO rhgc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Híbar hócom Yusúf forhésgar manúc accíl. Yóggwa ttu zettót Moriyam ore maincór muúntu córom díto mone no hoór, híba ttu zuitégori alok óizaytoi niyot goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yóggwa ye híyan báfer de októt, Mabud or ek fírista ye yóggwa re cóppon ot dahá dí hoór de, “Ó Dawud or nosól Yusúf, Moriyam ore biyá goitté no ḍooraiyó, kiyólla-hoilé híbar feṛot ze Fua óiye Íba Pak-Ruhr kudurute óiye deh. ");
INSERT INTO rhgc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Híba ttu éggwa Morotfua óibo, tuñí Íbar nam Isá rakíba, kiyólla-hoilé Íba ye Nizor manúc ókkol ore ítarar guná ttu basaibó.” ");
INSERT INTO rhgc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Híin beggún etollá óiye, zeéne Mabude nobir duara hoóil de yián fura ó, ");
INSERT INTO rhgc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Soó, ek kuwári mayafua hámil óibo, aar híba ttu éggwa Morotfua óibo, ítara Íbar nam rakíbo de Immanuel,” ziyán or torjuma óilde, ‘Alla añárar fúañti.’ ");
INSERT INTO rhgc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Baade Yusúfe gúm ottu uṛí undilla goijjé zendilla gorí bolla Mabud or fírista ye yóggwa re hókum díyl, yóggwa ye Moriyam ore biyá gorífelaiye, ");
INSERT INTO rhgc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","montor híba ttu Fua wa zormo nó óiyo foijjonto híba llói milmilab nó goré. Baade yóggwa ye Fua war nam Isá raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yohúdiya elakar baáñcca Hérud or hale, Betélhem cóor ot Isá zormo ói baade, fuk mikká ttu hoozzon fonḍit Jerúsalem ot aiccé, ");
INSERT INTO rhgc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","aái hoór de, “Yohúdi ókkol or Baáñcca zibá zormo óiye Íba hoṛé? Añára fuk mikká Íbar tara dekí Íba re sóida goittó aiccí deh.” ");
INSERT INTO rhgc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Híyan fúni baáñcca Hérud ferecan óigilgoi, héndilla Jerúsalem or manúc beggún óu. ");
INSERT INTO rhgc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yóggwa ye ḍoóñr imam ókkol edde alem ókkol beggún ore ekkán ot dolagorí, ítara ttu Mosih hoṛé zormo óibar asé híyan zasai goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ítara yóggwa re hoór de, “Yohúdiya elakar Betélhem ot, kiyólla-hoilé nobi ye endilla leikké: ");
INSERT INTO rhgc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ó Yohúdiya elakar Betélhem, Yohúdiyar hókumot-goróya ókkol or bútore tui honó mikká ttu cóñṛo no; kiyólla-hoilé tor bútottu eén ézzon Hókumot-goróya aibó, zibá ye Añr bonda Isráili re soraibó.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hétunot Hérude fonḍit ṭún ore aiddone matai zaniloiyé de, tara wa borabor hotúnot dahá gíyl. ");
INSERT INTO rhgc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Baade yóggwa ye ítara re eén hoói Betélhem ot difeṛáiye, “Tuáñra zai hé gura Fua wa re cúndorgori tuwogói. Íba re loot faile añré hóbor díyo, zeéne añí yó aái Íba re sóida gorí fari.” ");
INSERT INTO rhgc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ítara baáñccar hotá fúni bacá lóiye, aar ítara fuk mikká ze tara deikkíl, yíba Fua wa ziyóñt asé íñyot zai nó tíya foijjonto ítarar age-age zaat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tara wa dekí ítara ódorbaára kúci óiye. ");
INSERT INTO rhgc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ítara gór gán ot foóñsi yore, Fua wa re Íbar maa Moriyam or fúañti deikké; baade ítara meṛit fori Íba re sóida goijjé. Tarfore ítara nizor baccú gún kúli cúna, luban edde mur añtor ókkol Íba re hádiya diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aar Hérud or héṛe waafes no zaito cóppon ot Allar torfóttu úñciyari fai, ítara arek boli nizor mulluk ot fíri giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Fonḍit ṭún zaigói baade, Mabud or ek fírista ye Yusúf ore cóppon ot dahá dí hoór de, “Uṛó, Fua edde Íbar maa re looi Ijíp ot dáizogoi. Añí zetódin nó hoói hétodin foijjonto héṛe tákiyo, kiyólla-hoilé Hérude Fua wa re marifélai bolla tuwaibó.” ");
INSERT INTO rhgc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hétunot Yusúf uṛí rait tákite Fua edde Íbar maa re looi, Ijíp olla bacá lóiye, ");
INSERT INTO rhgc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","aar Hérud nó more foijjonto héṛe táikkil. Híyan etollá óiye, zeéne Mabude nobir duara hoóil de yián fura ó, “Añí Añr Fua re Ijíp ottu ḍahai ainní.” ");
INSERT INTO rhgc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hérude zeñtté Fonḍit ṭúne yóggwa re bóoñt díye de zainné, yóggwa ttu bicí guccá uiṭṭé; aar hé fonḍit ṭún ottu ze októr hotá zanilóil hé októr ísaf mozin, Betélhem ot edde híyan or atehañsór zaga ókkol ot dui bosór edde yár nisor zedún morotfuain asé, ítarar hañse manúc difeṛái ítara beggún ore marifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Híyane nobi Yarmíyahr duara hoóil de yián fura óiye, ");
INSERT INTO rhgc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá cóor ot eggwá abas fúna gíyeh, hañdanir edde bicí ferecanir. Rahéla ye nizor fuain dor lla hañder, aar tosólli kobul no gorér, kiyólla-hoilé ítara ar nái.” ");
INSERT INTO rhgc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Zeñtté Hérud morigiyói, Mabud or ek fírista ye Yusúf ore Ijíp ot cóppon ot dahádiye, ");
INSERT INTO rhgc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","aar hoór de, “Uṛó, Fua edde Íbar maa re looi Isráil mulluk ot waafes zoogói, kiyólla-hoilé zetará niki Fua wa re zane marifélaito tuwaáil ítara morigiyói.” ");
INSERT INTO rhgc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tói Yusúf uṛí, Fua edde Íbar maa re looi Isráil mulluk ot waafes aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Montor yóggwa ye zettót endilla fúinne, Arkeláyose Yohúdiyat tar baf Hérud or zagat hókumot gorér, tói yóggwa héṛe zaite ḍooraiyé. Baade cóppon ot Allar torfóttu úñciyari fai, Galil elakat giiyégoi, ");
INSERT INTO rhgc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","aar zai Nasárat nam or ekkán cóor ot bocót gorát doijje. Héndilla etollá óiye, zeéne nobi ókkol or duara hoóil de yián fura ó, “Íba re Nasári howá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ek din bápṭismadoya Yaháya aái, Yohúdiyar moidan zagat endilla hoói tobolik gorát doijje, ");
INSERT INTO rhgc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Touwá goró, kiyólla-hoilé asmani raijjo ḍáke aáigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yóggwa óilde ubá zibár baabute nobi Yesáyah ye hoóil de, “Moidan zagat ezzone guzori-guzori eén hoór, ‘Mabud or foñt toiyar goró; Íbar rasta uzu goró.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yaháya ye uñṭ or keñc loi banaiya hoor fiñdíto, aar yóggwar keeñil ot samarar duali baindá tákito. Yóggwar hána accíl de fíring edde zooñl or modú. ");
INSERT INTO rhgc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hé októt Jerúsalem ottu, tamám Yohúdiya ttu, edde Jordán hál or sairókul ttu manúc ókkol yóggwar hañse giiyé, ");
INSERT INTO rhgc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","aar nizor-nizor guná ókkol cíkar gorí, ítara Jordán hál ot yóggwa ttu bápṭisma loiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yóggwa ye zeñtté Féroci ókkol edde Sadukái ókkol boóut zone bápṭisma loito yóggwar hañse aiyér de deikké, yóggwa ye ítara re hoór de, “Ó háf or fuain ókkol! Aibár gozzob ottu dáizayboi lla tuáñra re hone úñciyari díye? ");
INSERT INTO rhgc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Touwá lói mil há de héndilla gulagala ókkol dóro, ");
INSERT INTO rhgc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","aar nizor dil ot endilla kíyal nu ainnó de ki, ‘Añára ttu toh baf ísafe Ibrahím asé.’ Añí tuáñra re hoóir, Alla ye sailé e cíl lun ottu yó Ibrahím olla fuain foida gorí fare. ");
INSERT INTO rhgc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aar ehón toh gas or gurat kuróil raká gíyeh. Hétolla, ze gas ot gom gula no dóre, yíba re haṛi ooin ot félaidiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Añí de tuáñra touwá goijjó de hétolla éna tuáñra re fanít bápṭisma díh; montor añí baade zibá aiyér, Íbar tokka añr túaro ḍoóñr. Añí Íbar cenṭár boi bolla úddwa laayek no. Íba ye tuáñra re Pak-Ruh edde ooin loi bápṭisma díbo. ");
INSERT INTO rhgc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Íbar kula Íbar át ot asé; Íba ye Nizor hóñla re cúndorgori sáf goríbo, aar Íbar giyuñ re gudam ot zoma goríbo, montor suwa gún ore Íba ye honódin no nifé de ooin ot furat difélaibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hé din ókkol ot, Isá bápṭisma loito Galil ottu Jordán hál or hañsat Yaháyar héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Montor Yaháya ye Íba re endilla hoói maná goittó kucíc goijjíl, “Añr ttu éna Tuáñr hañsóttu bápṭisma loibar zorur, aar Tuñí añr hañse aiccó dé?” ");
INSERT INTO rhgc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Montor Isá ye zuwabe yóggwa re hoór de, “Ebar yián óito dóh, kiyólla-hoilé endilla gori añára ttu, Alla ye saár de híyan fura gorár zorur.” Tói yóggwa razi óiye. ");
INSERT INTO rhgc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Isá bápṭisma loi mottor, faní ttu kul ot uiṭṭégai. Hétunot asman kúligiyoi, aar Íba ye dekér de, Allar Ruh hoitor or ḍóilla ói lami aái Íbar uore boiyér. ");
INSERT INTO rhgc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aar héñtte asman ottu éggwa abas aiccé, eén hoór de, “Ibá Añr adorja Fua, Ibá re lói Añí bicí kúci.” ");
INSERT INTO rhgc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yárbaade Pak-Ruh ye Isá re moidan zagat loigiyé, zeéne Íba re Ibilíce entán goré. ");
INSERT INTO rhgc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Salic din salic rait ruza rakí baade Íba ttu búk laiggé. ");
INSERT INTO rhgc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hé októt entán-goróya aái Íba re hoór de, “Zodi Tuñí Allar Fua de óile, e fattór gún ore ruṭi óizaytoi hókum dóh.” ");
INSERT INTO rhgc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Montor Íba ye zuwabe hoór de, “Pak-kalam ot endilla asé, ‘Manúc siríf ruṭi loi base de no, bólke Allar muk ottu neele de hárr hotá lói beh base.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tói hé Ibilíce Íba re pak cóor gán ot loizai, baitul-mukaddos or tullit tíyagaraiye, ");
INSERT INTO rhgc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","baade Íba re hoór de, “Zodi Tuñí Allar Fua de óile, nise záp maro; kiyólla-hoilé pak-kalam ot toh endilla asé, ‘Íba ye Tuáñr baabute Nizor fírista ókkol ore hókum díbo; tói ítara nizor áte Tuáñre dórifelaibo, zeéne Tuáñr ṭénge honó fattór ot duk no faa.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isá ye ítare hoór de, “Pak-kalam ot toh yián óu asé, ‘Tuñí tuáñr Mabud Alla re entán no goríba.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tarfore Ibilíce Íba re eggwá uñsol faár ot loizai, duniyair tamám raijjo ókkol edde híin or fura cáandari daháiye. ");
INSERT INTO rhgc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tói íte hoór de, “Zodi Tuñí meṛit fori añré sóida goró, añí iín beggún Tuáñre diifélaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Isá ye ítare hoór de, “Cóitan, dur ó! Pak-kalam ot endilla asé, ‘Tuñí tuáñr Mabud Alla re beh sóida goríba, aar siríf Íbar beh ebaadot goríba.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hétunot Ibilíce Íba re eri giiyégoi, aar fírista ókkol aái Íba re hédmot gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zeñtté Isá ye Yaháya re ziyól ot díye de fúinne, Íba Galil ot giiyói; ");
INSERT INTO rhgc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","aar Nasárat cóor félai, Zebulun edde Nafṭalir zagat ḍiír hañsa loi asé de Kaparnahúm cóor ot zai táikkegoi. ");
INSERT INTO rhgc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Híyan etollá óiye, zeéne nobi Yesáyahr duara hoóil de yián fura ó, ");
INSERT INTO rhgc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun or elakat edde Nafṭalir elakat, doijjar rastat, Jordán hál or okule, Beyohúdi ókkol or Galil ot, ");
INSERT INTO rhgc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ze manúc ókkol andár ot accíl, ítara ekkán ḍoóñr foór deikké, zetará moot or andárja mulluk ot accíl, ítarar hañse foór óiye.” ");
INSERT INTO rhgc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hé októt lóti Isá ye eén hoói tobolik gorát doijje, “Touwá goró, kiyólla-hoilé asmani raijjo ḍáke aáigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Isá Galil Ḍiír hañsa báy áñṛi zaar de októt, Íba ye duwá bái deikké, yáni Sáimon, zibá re Fitor ḍaikké edde íbar bái Enderiyas ore. Héñtte ítara ḍiít zal marer, kiyólla-hoilé ítara zailla accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Íba ye ítara re hoór de, “Añr fisáli doro, Añí tuáñra re manúc dóre de zailla banaiyúm.” ");
INSERT INTO rhgc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ítara éhon or bútore ítarar zal lun eri, Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Híyan ttu aró hoddúr giiyé rár, Íba ye aró dui bái deikké, yáni Zebedair fua Yakub ore edde yóggwar bái Yohánna re. Héñtte ítara noowr uore ítarar baf Zebedair fúañti zal ṭuner. Íba ye ítara re mataiyé, ");
INSERT INTO rhgc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","hétunot ítara éhon or bútore noow gán edde baf ore eri, Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isá ye Galil or agagura zai-zai Yohúdir mujilíc-hána ókkol ot taalim dito edde raijjor kúchóbor tobolik goittó, aar maincór fottí kisím or biyaram edde fottí kisím or ocúk ókkol gom goittó. ");
INSERT INTO rhgc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Íbar hóbor Siíriyar agagura fóligilgoi; aar maincé biyaraimma zetará ttu ḍoilla-boḍoilla biyaram asé edde duk faar, zetará búte-faiya, zetará ttu súañfíra asé, zetará añtur, ítara beggún ore Íbar hañse ainné, aar Íba ye ítara re gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galil ottu, Dekapólis ottu, Jerúsalem ottu, Yohúdiya ttu, edde Jordán hál or farkul ottu dol-dol manúc Íbar fisá doijjil. ");
INSERT INTO rhgc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Manúc or dol dekí Isá eggwá faár or uore uiṭṭégoi, aar Íba boiccé rár, Íbar cárit tun Íbar héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hétunot Íba ye Nizor muu kúli ítara re endilla taalim diyat doijje: ");
INSERT INTO rhgc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mubarek uitará, zetará ruúhanir gorif, kiyólla-hoilé asmani raijjo toh ítarar. ");
INSERT INTO rhgc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mubarek uitará, zetará ferecanit asé, kiyólla-hoilé ítara tosólli faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mubarek uitará, zetará cída, kiyólla-hoilé ítara toh duniyai miras faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mubarek uitará, zetará Allar moncá mozin goittó búkki edde tiráci, kiyólla-hoilé ítarar hé moncá furafuri fura óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mubarek uitará, zetará rahám dil ola, kiyólla-hoilé ítara re rahám gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mubarek uitará, zetarár dil sáf, kiyólla-hoilé ítara Alla re dekíbo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mubarek uitará, zetará sólluk goríde, kiyólla-hoilé ítara re Allar fuain howá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mubarek uitará, zetará Allar moncá mozin goróne zulúm faa, kiyólla-hoilé asmani raijjo toh ítarar.” ");
INSERT INTO rhgc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mubarek tuáñra, zeñtté maincé Añr lla bóuli tuáñra re beizzoti goré, zulúm goré, edde na hókkot tuáñrar baabute hárr ḍóilla bura-ára ókkol hoó. ");
INSERT INTO rhgc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Héñtte tuáñra kúci goijjó edde kúci óiyo, kiyólla-hoilé tuáñra lla asman ot ḍoóñr boccíc asé. Tuáñrar age ze nobi ókkol accíl ítara re yó maincé héndilla zulúm goittó. ");
INSERT INTO rhgc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Tuáñra óilade duniyair nun; montor zodi nun or dok zaagói, híin ore keéngori abar nuncá gorí fara zaybo? Híin toh ar honó ham ot nu aiyé. Híin ore baáre félaidiya zah, aar maincór úñran ot fore. ");
INSERT INTO rhgc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tuáñra óilade duniyair nur. Faár or uore bañdá gíyeh de cóor toh lukai rakí fara no zah. ");
INSERT INTO rhgc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Honó maincé serak dórai báñir or tole raké de nái, bólke boiṛónir uore beh raké, tói híyane gór ot asé de beggún ore foór déh. ");
INSERT INTO rhgc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Héndilla góri, tuáñrar foór maincór muúntu zolouk, zeéne ítara tuáñrar gom ham ókkol dekí tuáñrar asmani Baf or mohíma goré. ");
INSERT INTO rhgc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tuáñra endilla no ṭáaijjo de ki, Añí Muúsar Córiyot yáh nobi ókkol or cíkka baatel goittó aiccí. Añí híin baatel goittó aiccí de no, bólke fura goittó aiccí deh. ");
INSERT INTO rhgc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Añí tuáñra re sóiyi hoóir, zetódin asman zobin ṭiki tákibo, Córiyot óu ṭiki tákibo, héntu honó noktá yáh zer zobor no búzibo zetódin híin beggún fura nó óiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hétolla, zee niki hé hókum ókkol ottu ebbe cóñṛo ekkán hókum ore baatel goré aar oinno zon ore yó héndilla goittó cíka, ítare asmani raijjot ebbe cóñṛo howá zaybo; montor zee niki híin amól goré edde cíka, ítare asmani raijjot ḍoóñr howá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Kiyólla-hoilé Añí tuáñra re hoóir, zodi tuáñrar forhésgari alem ókkol or edde Féroci ókkol or forhésgarir túaro bicí no, tuáñra asmani raijjot bilkúl góli no faribá. ");
INSERT INTO rhgc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tuáñra fúinnila de ki, agor zobanar maincóre endilla howá gíyl, ‘Kún no goríba,zee niki kún goré, ítar ttu adalot ot zuwab diya foribó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Montor Añí tuáñra re hoóir, zee niki nizor báior uore guccá goré, ítar ttu adalot ot zuwab diya foribó. Aar zee niki nizor bái ore, ‘Tui behazor,’ hoó, ítar ttu bor adalot ot zuwab diya foribó. Aar zee niki nizor bái ore, ‘Tui bekuf’ hoó, íte zuzuk or ooin or sáñzar laayek óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Hétolla tuñí kurbani-gáñr uore kurbani peec goríbarcot, zodi tuáñr ttu monot uṛé de ki, tuáñr bái ottu tuáñr ulḍa kessú hoibár asé, ");
INSERT INTO rhgc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hétunot tuáñr kurbani hé kurbani-gáñr muúntu eri zaiyogói. Zai yore age tuáñr bái lói bonizogói, baade aái yore tuáñr kurbani diyogái. ");
INSERT INTO rhgc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tuáñr lla bisar goittó zaar de manúc lói foñt ot tákite toratori maamela hól gorífelaiyo, arnóile íte tuáñre joc or át ot gosáidibo, aar joce tuáñre fulic or át ot gosáidibo, baade tuáñre ziyól ot difélaibo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Añí tuáñre sóiyi hoóir, tuñí ahéri foicá nó doo foijjonto héntu hálas ói no faribá. ");
INSERT INTO rhgc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Tuáñra endilla howá gíyl de fúinnila, ‘Zená no goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Montor Añí tuáñra re hoóir, zodi honókiye honó mayafua re bura kíyale saá, íte nizor dile-dile híba llói zená gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Zodi tuáñr den ḍák or suké tuáñre gunár uzu ṭane, tóoile yíba neelai félaido. Kiyólla-hoilé tuáñr guñṛa gaa zuzuk ot zaar túaro, tuáñr gaar ekkán híssa no tákon tuáñr lla beétor. ");
INSERT INTO rhgc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Zodi tuáñr den áte tuáñre gunár uzu ṭane, tóoile híyan haṛi félaido. Kiyólla-hoilé tuáñr guñṛa gaa zuzuk ot zaar túaro, tuáñr gaar ekkán híssa no tákon tuáñr lla beétor. ");
INSERT INTO rhgc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Endilla yó howá gíyl, ‘Zee niki nizor bou ore sárifele, íte híba re sárhabos douk.’ ");
INSERT INTO rhgc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lekin Añí tuáñra re hoóir, zee niki nizor bou ore zenár hosúr lói bade oinno honó hosúri lói sárifele, íte híba re zená gorába; aar zee niki sárifelaiya mayafua re biyá goré, íte yó zená goré. ");
INSERT INTO rhgc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tuáñra aró fúinnila de ki, agor zobanar maincóre endilla howá gíyl, ‘Misá hosóm na háiyo, bólke tuñí ziyán olla hosóm háiyo, híyan Mabud or hañse fura goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lekin Añí tuáñra re hoóir, tuáñra bilkúl hosóm na háiyo, asman or name yó na háiyo, kiyólla-hoilé híyan toh Allar toktó. ");
INSERT INTO rhgc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Zobin or name yó na háiyo, kiyólla-hoilé híyan toh Íbar foo rakíbar banggú. Jerúsalem or name yó na háiyo, kiyólla-hoilé híyan óilde bor Baáñccar cóor. ");
INSERT INTO rhgc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nizor matá dóri yó hosóm na háiyo, kiyólla-hoilé tuñí toh ekkán sul úddwa dóla yáh hala gorí no faro. ");
INSERT INTO rhgc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Montor tuáñra baná eddúr hoiyó, óile ‘ói’ aar no óile ‘no,’ yár baáre ziín aiyé híin óilde Ibilíc or torfóttu. ");
INSERT INTO rhgc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tuáñra endilla howá gíyl de fúinnila, ‘Suk or bodol suk, aar dat or bodol dat.’ ");
INSERT INTO rhgc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Montor Añí tuáñra re hoóir, honó hóraf manúc lói mukabela no goijjó. Bólke zee niki tuáñre den ḍák or galsaba sái suwar mare, ítare oh ḍák óu fíraidiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aar zodi honókiye tuáñr kuruta loifélaito tuáñr lla mooddima goittó saá, ítare tuáñr saddor óu diifélaiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Zodi honókiye tuáñre ek mail zaito bolazuri goillé, ítar fúañti dui mail zaiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Zee niki tuáñr ttu mage, ítare diiyo; aar zee niki tuáñr ttu udár saá, ítare no fíraiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tuáñra endilla howá gíyl de fúinnila, ‘Nizor atehañsór maincóre muhábbot goríba,aar duccon ore nafórot goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Montor Añí tuáñra re hoóir, tuáñrar duccon ókkol ore muhábbot goijjó; aar zetará tuáñrar uore zulúm goré, ítara lla dua goijjó, ");
INSERT INTO rhgc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","zeéne tuáñra tuáñrar asmani Baf or fuain ṭóoro; kiyólla-hoilé Íba ye toh gom hóraf duní gún or uore Íbar beil or foór deh, aar forhésgar or uore edde kuham-goróyar uore zór difeṛá. ");
INSERT INTO rhgc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Zodi tuáñra cúdu tuáñra re muhábbot goré de ítara re muhábbot goró, tóoile súwab kiyólla faiba? Házana-tulóya ókkole úddwa kí héndilla no goré né? ");
INSERT INTO rhgc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aar zodi tuáñra cúdu tuáñrar báiyain dore sólam dóh, tóoile tuáñra oinno manúc ókkol or túaro bicí kii gorór? Beyohúdi ókkole úddwa kí héndilla no goré né? ");
INSERT INTO rhgc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hétolla tuáñrar asmani Baf zendilla furafuri sóiyi, héndilla tuáñra yó furafuri sóiyi ó.” ");
INSERT INTO rhgc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Hóboroddar, tuáñrar forhésgari ham maincór muúntu ítara re dahái bolla no goijjó; arnóile tuáñra tuáñrar asmani Baf ottu honó boccíc no faiba. ");
INSERT INTO rhgc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hétolla zeñtté tuñí sótka goró, héñtte cíañ matai elan no goijjó, zendilla munafék ókkole maincór ttu taarif fai bolla mujilíc-hána ókkol ot edde rasta-rasta goré. Añí tuáñra re sóiyi hoóir, ítara ítarar boccíc furafuri faifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Montor zeñtté tuñí sótka goró, héñtte tuáñr den áte kii gorér de híyan tuáñr ban át ore zainto no diyó, ");
INSERT INTO rhgc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","zeéne tuáñr sótka gorá aiddone ó. Tói tuáñr Baf, zibá ye aiddon ot deké, Íba ye tuáñre boccíc diibo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Zeñtté tuáñra dua goró, munafék ókkol or ḍóilla no óiyo; kiyólla-hoilé ítara maincóre dahái bolla beh mujilíc-hána ókkol ot edde rastar kuna-kuna tíyai yore dua gorá fosón goré. Añí tuáñra re sóiyi hoóir, ítara ítarar boccíc furafuri faifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Montor zeñtté tuñí dua goró, tuáñr kamárar bútore góli, duwar bañdífelai tuáñr Baf or hañse dua goríyo, zibá aiddone asé. Tói tuáñr Baf, zibá ye aiddon ot deké, Íba ye tuáñre boccíc diibo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Zeñtté tuáñra dua goró, Beyohúdi ókkol or ḍóilla behazor hotá ókkol no duaráiyo, kiyólla-hoilé ítara ṭáare de, ítarar bicí hotár zoriya ítarar dua kobul óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hétolla hoóir, tuáñra ítarar ḍóilla no óiyo; kiyólla-hoilé tuáñrar Bafe toh Íba ttu magibár age lóti tuáñrar zorurot zane. ");
INSERT INTO rhgc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hétolla tuáñra endilla dua goijjó: ‘Ó añárar asmani Baf, Tuáñr nam pak mana zouk. ");
INSERT INTO rhgc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tuáñr raijjo aiyóuk. Tuáñr moncá zendilla asman ot fura ó, héndilla duniyait óu fura óuk. ");
INSERT INTO rhgc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aijjar hána añára re aijja doo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Añárar hosúri maf goró, zendilla zetará añára llói hosúri goijjé, ítara re añára yó maf goijjí. ");
INSERT INTO rhgc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Añára re entán ot foitto no diyó, bólke Ibilíc ottu basai rakó. Kiyólla-hoilé raijjo, taakot aar mohíma toh hámica Tuáñr.’ ");
INSERT INTO rhgc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kiyólla-hoilé zodi tuáñra oinno zon or hosúri maf goró, tóoile tuáñrar asmani Bafe yó tuáñra re maf gorídibo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Montor zodi tuáñra oinno zon or hosúri maf no goró, tóoile tuáñrar Bafe yó tuáñrar hosúri maf no goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tuáñra ruza rakó de októt nakmuk hala no goijjó, zendilla munafék ókkole goré, kiyólla-hoilé ítara siyára bodole de toh ruza raikké de híyan maincóre dahái bolla. Añí tuáñra re sóiyi hoóir, ítara ítarar boccíc furafuri faifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Montor tuñí zeñtté ruza rakó, matát tel diyo, aar muk dúiyo, ");
INSERT INTO rhgc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","zeéne tuñí ruza raikkó de híyan maincé no, bólke tuáñr Bafe zane, zibá aiddon ot asé. Tói tuáñr Baf, zibá ye aiddon ot deké, Íba ye tuáñre boccíc diibo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nizor lla dón-cómbotti duniyait zoma no goijjó, zeṛé fuke edde zooñre borbad diféle, aar zeṛé sur ókkole berá haṛi sur gorífele. ");
INSERT INTO rhgc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bólke nizor lla dón-cómbotti asman ot zoma goró, zeṛé no fuke aar no zooñre nac goré, aar zeṛé sur ókkole berá haṛi sur no goré. ");
INSERT INTO rhgc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kiyólla-hoilé tuáñrar dón-cómbotti zeṛé, tuáñrar dil tákibo de yó héṛe. ");
INSERT INTO rhgc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Gaar serak óilde suk; hétolla tuáñr suk gom asé de óile, tuáñr guñṛa gaa foóre furaiya óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Montor tuáñr suk hóraf de óile, tuáñr guñṛa gaa andáre furaiya óibo. Hétolla, tuáñr bútore ze foór asé híyan zodi andár de óile, tóoile hé andár hotó guṭguiṭṭa óibo fáñllar! ");
INSERT INTO rhgc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Honókiye dui girós or hédmot gorí no fare; kiyólla-hoilé íte ezzon ore nafórot goríbo aar ar ezzon ore muhábbot goríbo; yáto ezzon loi ṭík tákibo aar ar ezzon ore hékarot goríbo. Tuáñra ekku fúañti Allar edde dón-doulot or hédmot gorí no faribá. ");
INSERT INTO rhgc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hétolla Añí tuáñra re hoóir, kii háiyum yáh kii fiíyum hoi zindigi lla sinta no goijjó; aar kii fiñdíyum hoi gaa lla sinta no goijjó. Zindigi ki hánar túaro kimoti no né, aar gaa ki hoorsuor or túaro kimoti no né? ");
INSERT INTO rhgc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Asman or faik ókkol or baabute báfiso; híine toh no cíñṛe, no daa, aar no gudam ot zoma goré, toóu tuáñrar asmani Bafe híin ore háaba. Tuáñra kí híin or túaro kimoti no né? ");
INSERT INTO rhgc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tuáñra hone sinta gorí nizor hóiyat ore ek gónḍa barái faribá de asó? ");
INSERT INTO rhgc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Hoorsuor olla kiyá sinta goró? Báfiso, moidan or fúl ókkol keéngori barí uṛé; híine toh no meénnot goré aar no fúñta haṛe. ");
INSERT INTO rhgc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Montor Añí tuáñra re hoóir, baáñcca Sólomane úddwa yóggwar tamám dón-doulot lói híin ekgwár ḍóilla nizoré háñzai faijjé de nái. ");
INSERT INTO rhgc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hétolla, zodi Alla ye moidan or kér ore héndilla góri háñza, ziín aijja asé aar hailla ooin ot félaidiya zah; tóoile ó hom biccác ola ókkol, Íba ye tuáñra re aró bicí no háñzaibo né? ");
INSERT INTO rhgc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hétolla hoóir, ‘Añára kii háiyum? Kii fiíyum?’ yáh ‘Kii fiñdíyum?’ hoói sinta no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kiyólla-hoilé Beyohúdi ókkole éna híin beggún or fisé lagi táke. Tuáñrar asmani Bafe toh zane, tuáñra ttu híin beggún lager deh. ");
INSERT INTO rhgc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Age Allar raijjor edde Íbar moncá mozin solibár talac ot táko, tói tuáñra re híin beggún óu diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Hétolla, hailla lla sinta no goijjó; kiyólla-hoilé haillar dine hailla lla sinta goríbo. Din or duk din olla kafí. ");
INSERT INTO rhgc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Hosúri no doijjo, tói tuáñrar hosúri yó dóra no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kiyólla-hoilé zendilla gori tuáñra hosúri dóro, héndilla góri tuáñrar hosúri yó dóra zaybo; aar tuáñra ze mafe diiba, tuáñra re yó hé mafe diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Tuñí tuáñr bái or suk ot asé de hál lan kiyá dekór, montor tuáñr nizor suk ot asé de hodda gán ót no gorór? ");
INSERT INTO rhgc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nizor suk ot hodda táki baade tuñí keéngori tuáñr bái ore hoór, ‘Aiyó, añí tuáñr suk ottu hál lan neelaifélai’? ");
INSERT INTO rhgc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ó munafék! Age tuáñr nizor suk ottu hodda gán neelaifélo, baade tuáñr bái or suk ottu hál lan neelai bolla sáf góri dekíba. ");
INSERT INTO rhgc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kuñir ore honó pak jiníc no diiyo, aar cúwor ókkol or muúntu tuáñrar mukta no félaiyo, arnóile híine híin ore ṭénge úñran maribó, aar fíri aái yore tuáñra re hán-hán gorífelaibo. ");
INSERT INTO rhgc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mago, tuáñra re diiya zaybo; tuwo, tuáñra faiba; duwar baijjo, tuáñra lla duwar kúla záybo. ");
INSERT INTO rhgc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kiyólla-hoilé zee niki mage, íte faa; zee niki tuwa, íte tuwai faa; aar zee niki duwar baijja, ítar lla kúla zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Tuáñrar bútore endilla manúc hon asé, nizor fua ye ruṭi magilé fattór diibo dé? ");
INSERT INTO rhgc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yáto mas magilé háf diibo dé? ");
INSERT INTO rhgc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hé ísafe, zodi tuáñra hóraf ói baade úddwa tuáñrar fuain dore gom-gom jiníc ókkol dii zano, tóoile tuáñrar asmani Bafe zetará Íba ttu mage ítara re aró hotó gom jiníc ókkol diibo fáñllar! ");
INSERT INTO rhgc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Hétolla, hárr kessút oinno zon ore uúin goró ziín tuáñra soó de ítara tuáñra re goróuk, kiyólla-hoilé híyan óilde beh Tourat or edde nobi ókkol or cíkka. ");
INSERT INTO rhgc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Siyon doroza báy gólo, kiyólla-hoilé borbadir uzu loiza de rasta fárot aar híyan or doroza coṛa; híyan báy góloya bicí asé. ");
INSERT INTO rhgc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Montor zindigir uzu loiza de rasta kutahaiṭṭa aar híyan or doroza siyon, híyan ore fooya hom. ");
INSERT INTO rhgc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Misá nobi ókkol ottu úñciyar táikko, zetará tuáñrar hañse bérasóol or sónna dóri aiyé, montor bútore ítara búka rangkuñir or ḍóilla. ");
INSERT INTO rhgc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tuáñra ítara re ítarar gulagalaye siníba. Maincé kí keñṛabon ottu anggur aar keñṛar záḍḍwa ttu ḍuñir gula fare? ");
INSERT INTO rhgc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Borabor héndilla, gom gas ot gom gula dóre, aar hóraf gas ot hóraf gula dóre. ");
INSERT INTO rhgc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gom gas ot toh hóraf gula dóri no fare, aar hóraf gas ot gom gula dóri no fare. ");
INSERT INTO rhgc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ze gas ot gom gula no dóre, yíba re toh haṛi ooin ot félaidiya zah. ");
INSERT INTO rhgc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hétolla hoóir, tuáñra ítara re ítarar gulagalaye siní faribá. ");
INSERT INTO rhgc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Zetará Añré, ‘Malik, Malik,’ ḍake, ítara hárr ekzon asmani raijjot góli faribó de héen no, montor siríf uite faribó zee niki Añr asmani Baf or moncá mozin goré. ");
INSERT INTO rhgc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hé din Añré boóut kiyé hoibó de, ‘Malik, ó Malik, añára Tuáñr name Allar kalam boiyan goijjílam de no né? Tuáñr name bút ókkol dáfailam de no né? Aar Tuáñr name boóut keramot ókkol óu goijjílam de no né?’ ");
INSERT INTO rhgc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Héñtte Añí ítara re sáf-sáf góri hoiyúm de, ‘Añí tuáñra re honó októt no sinítam; kuham-goróya ókkol, Añr héntu dur ó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Hétolla, zee niki Añr boiyan iín fúni amól goré, íte endilla ezzon buddíman manúc or ḍóilla óibo, zee niki nizor gór fattór or uore banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Baade zór aiccé, faníban óiye, aar boiyar baái hé gór gán ot dósadiye; toóu híyan fori nó zagói, kiyólla-hoilé híyan or buniyadi tohfattór ot ḍála gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Montor zee niki Añr boiyan iín fúni amól no goré, íte eén ézzon bekuf manúc or ḍóilla óibo, zee niki nizor gór balur uore banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Baade zór aiccé, faníban óiye, aar boiyar baái hé gór gán ot dósadiye; hétunot híyan fori ebbe nac óigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zeñtté Isá ttu hotá híin hoiyá óiye, Íbar hé taalim fúni manúc ókkol ammúk óigiyoi, ");
INSERT INTO rhgc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kiyólla-hoilé Íba ye ítara re ítarar alem ókkol or ḍóilla góri no bólke ezzon adíkar olar ḍóilla góri taalim dito. ");
INSERT INTO rhgc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zeñtté Isá faár or uottú laimmégai, becábicí manúc ókkol Íbar fisá doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hé októt ezzon kurus biyaraimma ye aái Íba re sóida gorí hoór de, “Ó Malik, Tuñí sailé añré pak-sáf gorí faribá.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isá ye Nizor át barái yóggwa re dóri hoór de, “Añí saái; pak-sáf óizogoi.” Tói éhon or bútore yóggwa kurus biyaram ottu pak-sáf óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Baade Isá ye yóggwa re hoór de, “Saiyó, yián honókiyo re no hoiyó; bólke zoo, nizoré imam or hañse dahógoi, aar maincór hañse gobá ó fan, Muúsa ye hókum díye de hé kurbani dogói.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zeñtté Isá Kaparnahúm cóor ot góille, hétunot ezzon cáap, zibá ek cót fóous or sóddar, aái Íba re fóriyat gorér de, ");
INSERT INTO rhgc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Malik, añr gulam añtur ói gór ot fori táikke; íte kúb duk faar.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Isá ye yóggwa re hoór de, “Añí aái ítare gom goijjúm.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Montor cáap pwá ye hoór de, “Ó Malik, Tuñí añr gór or sal or nise aibár añí laayek no. Siríf muké hoó, tói añr gulam gom óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kiyólla-hoilé añí nize yó ar ezzon or hókumot or tole así, aar fóous ókkol añr nise asé. Añí ezzon ore ‘zaa,’ hoilé, íte zaa, ar ezzon ore ‘ai,’ hoilé, íte aiyé, aar añr gulam ore ‘yián gor,’ hoilé, íte híyan goré.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Híyan fúni Isá taajup óigiyoi, aar zetará Íbar fisá dori accíl ítara re hoór de, “Añí tuáñra re sóiyi hoóir, Añí ettór ḍoóñr iman Isráili ókkol or bútore úddwa honókiyo ttu loot nó fai. ");
INSERT INTO rhgc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Añí tuáñra re hoóir, fuk edde fosím ottu boóut zon aibó, aar ítara Ibrahím, Isahák, edde Yakub or fúañti asmani raijjot háito boibó. ");
INSERT INTO rhgc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Montor zetará raijjot tákon accíl, ítara re baáre andár ot félaidiya zaybo; héṛe hañdahaṛi edde date dat kirkirani óibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Baade Isá ye cáap pwá re hoór de, “Zoogói; tuñí zeén óibo bóuli biccác goijjó, héen tuáñr lla óuk.” Borabor hétunot yóggwar gulam mwa gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yárbaade zeñtté Isá Fitor or gór ot aiccé, Íba ye dekér de, Fitor or hóuri gaatzore bisánat fori táikke. ");
INSERT INTO rhgc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Íba ye yóggwar át dóijje rár yóggwa ttu gaatzor giiyégoi; baade yóggwa uṛí Íba re meémandari gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Háñz óiye rár, maincé Íbar hañse búte-faiya boóut zon ore ainníl. Íba ye jin ókkol ore muk zobane dáfaiye, aar zetará biyaraimma accíl ítara beggún ore gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Híyan etollá óiye, zeéne nobi Yesáyahr duara hoóil de yián fura ó, “Íba ye añárar komzuri ókkol loifélaiye, aar añárar biyaram ókkol dur gorífelaiye.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zeñtté Isá ye Íbar sairókul ttu ek dol manúc deikké, Íba ye ummot ókkol ore ḍiír oh hañsat zai bolla hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hétunot ezzon alem aái Íba re hoór de, “Ustat, Tuñí zeṛé zaiba añí yó héṛe Tuáñr fisáli zaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isá ye yóggwa re hoór de “Cíyal ókkol ottu gañt asé aar faik ókkol ottu bahá asé, montor Manúc or Fua ttu Nizor matá rakí bolla úddwa honó mikká zaga nái.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ar ezzon ummote Íba re hoór de, “Malik, age añí zai añr baf ore dohón gorí aiyí.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Montor Isá ye yóggwa re hoór de, “Añr fisáli aiyó, muruda ókkole ítarar nizor muruda re dohón goróukgoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Baade zeñtté Isá ekkán noow ot uiṭṭé, Íbar ummot ókkol óu Íbar fisá doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Atíkka ḍiít eggwá eén ḍoóñr tuwán cúru óiye, zeén níki noow gán goir or bútore gólizargoi. Montor Isá gúm ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ummot tune Íbar hañse aái Íba re tulídi hoór de, “Ó Malik, añára re baso! Añára morizayrgói!” ");
INSERT INTO rhgc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Íba ye ítara re hoór de, “Ó hom biccác ola ókkol, tuáñra ḍoorór kiyá?” Tói Íba uṛí boiyar edde goir ore dóoñk díye rár, furafuri támaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Manúc ítara taajup ói hoór de, “Ibá hondilla manúc? Boiyare edde faní ye úddwa de Ibár hotá mane!” ");
INSERT INTO rhgc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Baade zeñtté Isá ḍiír okule Gadariniól or mulluk ot foóñicce, dui zon búte-faiya manúc hobor ottu neeliaité Íba llói dola óiye. Ítara eén hótara accíl, zeén níki honó manúc hé foñt báy zai no faitto. ");
INSERT INTO rhgc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Atíkka ítara guzori-guzori hoór de, “Ó Allar Fua, Tuáñr ttu añára llói kii ham asé? Októ nó óite Tuñí hóno eṛé añára re toziya dito aiccó de né?” ");
INSERT INTO rhgc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Héṛe ítarar héntu hoddúr duré ḍoóñr ek zák cúwor sorer de accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bút tune Íba re fóriyat gorér de, “Zodi Tuñí añára re neelaifélo, tóoile oh cúwor or zák kwar bútore duñraido.” ");
INSERT INTO rhgc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Íba ye híin ore hoór de, “Zoogói.” Hétunot híin neeli aái cúwor gún or bútore góillegoi; tói guñṛa zák kwa faár or haindá báy zure ḍiít duñri giiyé aar fanít ḍufí morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Soroya gún duñrdiyé, aar cóor ot zai beggún hóbor díye, fúañti-fúañti búte-faiya manúc cún or uore kii óiye de híyan óu hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tói tamám cóor or manúc ókkol Isá llói milto neeillé. Ítara Íba re deikké rár, ítarar elaka ttu zaitogói Íba re fóriyat goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isá noow ot uṛí, ḍií farái Nizor cóor ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hétunot hodún maincé bisánat neiṭṭa ek añtur manúc ore Íbar hañse ainné. Ítarar iman dekí Isá ye añtur manúc cwa re hoór de, “Ó fut, hímmot gor; tor guná maf gorídiya gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Híyan fúni hoozzon aleme dile-dile hoór de, “E Manúc cwa ye toh kuféri gorér!” ");
INSERT INTO rhgc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isá ye ítarar báfani re zani hoór de, “Tuáñra dile-dile hóraf kiyá báfor? ");
INSERT INTO rhgc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hoité hon nán aásan, ki ‘Tor guná maf gorídiya gíyeh,’ aar náki ‘Uṛí áñṭ’? ");
INSERT INTO rhgc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lekin Añr ttu tuáñra re yián zanaidito monehoór, e duniyait guná maf goríbar kémota Manúc or Fua ttu asé.” Tói Íba ye añtur manúc cwa re hoór de, “Uṭ, tor bisána tulí looi gór ot zagói.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hétunot yóggwa uṛí gór ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Híyan dekí manúc ókkol ḍooraigiyói, aar Allar taarif gorát doijje, zibá ye insán ore héndilla kémota diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Isá híyan ttu zaite-zaite dekér de, Moti nam or ezzon manúc házana tulé de gór ot boói táikke. Íba ye yóggwa re hoór de, “Añr fisáli doro.” Hétunot yóggwa uṛí Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yárbaade eén óiye, Isá zeñtté Motir gór ot hána háar, boóut zon házana-tulóya edde gunágar ókkol óu aái Isá edde Íbar ummot ókkol or fúañti háito boiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Féroci ókkole híyan dekí Íbar ummot ókkol ottu fusár gorér de, “Tuáñrar Ustate házana-tulóya ókkol or edde gunágar ókkol or fúañti kiyá hána háa?” ");
INSERT INTO rhgc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Híyan fúni Isá ye hoór de, “Araimma ókkol ottu toh ḍakṭor no lage, montor biyaraimma ókkol ottu beh lage. ");
INSERT INTO rhgc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tuáñra zai e hotár maáni kii cíkogoi, ‘Añí kurbani saái de no, bólke rahám saái deh.’Kiyólla-hoilé Añí dawot dito aiccí de forhésgar ókkol ore no, bólke gunágar ókkol ore.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hétunot Yaháyar ummot ókkol Isár hañse aái Íba ttu fusár gorér de, “Añára edde Féroci ókkole toh nitti ruza rakí, montor Tuáñr ummot ókkole kiyá ruza no raké?” ");
INSERT INTO rhgc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isá ye ítara re hoór de, “Dulá fúañti tákite kí boiraitta ókkol ferecan ói fare? Montor eén din aibó, zeñtté dulá re ítarar hañsóttu loiféla zaybo, héñtte ítara ruza rakíbo. ");
INSERT INTO rhgc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Honókiye toh furan fucák ot noya hoor tali dede nái; kiyólla-hoilé hé fucák ottu tali gán zórizayboi, aar fáṛa híyan aró ḍoóñr óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Héndilla, honókiye noya anggur or roc ore furan samarar hóillat raké de nái; zodi rakíle toh hóilla gún fáṛi roc cún golizaybói, aar hóilla gún óu borbad zayboi. Hétolla, noya anggur or roc ore noya samarar hóillat raké deh, tói duní gún héfazot táke.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Isá ye ítara re híin hoór de októt, mujilíc-hánar ézzon sóddar aái Íba re sóida gorí hoór de, “Añr zérfua wa ehón-ehón morigiyói. Montor Tuñí aái híbar uore át doogái, tói híba zinda óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hétunot Isá uṛí yóggwar fúañti zaat doijje, fúañti Íbar ummot ókkol óu giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Zaite-zaite eggwá baró bosór foijjonto kúnzari zár de mayafua Isár fisór ttu aái Íbar hoor or hañra súiye. ");
INSERT INTO rhgc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kiyólla-hoilé híba ye báippil de, “Zodi añí siríf Íbar hoor súi, añí gom óizaiyumboi.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isá ye fíri híba re dekí hoór de, “Ó zíi, hímmot gor! Tor imane toré gom goijjé.” Tói éhon or bútore mayafua wa gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Isá zeñtté sóddar gwar gór ot aái bací-bazoya ókkol ore edde maincór holholani deikké, ");
INSERT INTO rhgc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Íba ye hoór de, “Tuáñra neelogói. Zérfua morigiyói de no, bólke gúm zar deh.” Hétunot ítara Íba re lói áñcat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Montor manúc cún ore baáre neelai difélai baade, Íba bútore góli zérfua war át dóijje, tói híba uṛígiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hé hóbor híyan hé elakar agagurat fóligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Isá híyan ttu zaargói de októt, dui zon añdá manúc Íbar fisá doijje. Ítara ḍak mari-mari hoór de, “Ó Dawud or Fua, añárar uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zeñtté Isá gór ot góille, añdá manúc cún Íbar héṛe aiccé. Íba ye ítara ttu fusár gorér de, “Añí yián gorí faijjum de tuáñra biccác goró ne?” Ítara Íba re zuwab der de, “Jii Malik, gorí.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tói Íba ye ítarar suk dóri hoór de, “Tuáñrar iman mozin híyan tuáñra lla óuk.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hétunot ítarar suk kúligiyoi. Isá ye ítara re eén hoói dorógori maná goijjíl, “Saiyó, yián or baabute honókiye no zane fán.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Montor ítara zai hé elakar agagurat Íbar baabute hóbor fólaidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ítara baáre zaargói de októt, kessú maincé Isár hañse ezzon búte-faiya buk manúc ainné. ");
INSERT INTO rhgc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Isá ye bút twa dáfaiye rár, hé buk manúc cwa mati faijjé. Híyane manúc ókkol taajup óigiyoi, aar hoór de, “Endilla toh Isráil or bútore honódin dahá gíyeh de nái.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Montor Féroci ókkole hoór de, “Ibá ye bút ókkol dáfa de bút ókkol or sóddar or taakote.” ");
INSERT INTO rhgc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isá fottí cóore-cóore edde fara-fara zai Yohúdir mujilíc-hána ókkol ot taalim diyat, asmani raijjor kúchóbor tobolik gorát, edde fottí kisím or biyaram edde fottí kisím or ocúk ókkol gom gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Manúc or dol dekí Íba ttu feṭfuijjil, kiyólla-hoilé ítara soroya sára bérasóol or ḍóilla ocántit edde modot sára accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hétunot Íba ye Nizor ummot ókkol ore hoór de, “Fósol de bicí asé, montor dooiya bicí hom. ");
INSERT INTO rhgc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hétolla fósol or Malik ore fóriyat goró, Íbar fósol daito dooiya ókkol difeṛái bolla.” ");
INSERT INTO rhgc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isá ye Íbar baró zon cárit ore matai, ítara re hóraf jin ókkol dáfaibar edde fottí kisím or biyaram edde fottí kisím or ocúk gom goríbar kémota diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hé baró zon sáhabir nam óilde iín: foóila wa, Sáimon, zibá re Fitor ḍake, aar yóggwar bái Enderiyas; Zebedair fua Yakub edde yóggwar bái Yohánna; ");
INSERT INTO rhgc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filíp, Bartólomiyo, Tómas, házana-tulóya Moti, Alfáiyas or fua Yakub, Táadiyas, ");
INSERT INTO rhgc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sáimon zibá óilde Zélot, edde Yohúdah Iskáriyet, zee niki Isá re dóridil. ");
INSERT INTO rhgc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isá ye hé baró zon nún ore endilla nosíyot gorí difeṛáiye: “Beyohúdi ókkol or híkka no zaiyo, aar Samári ókkol or honó cóor ot no góillo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bólke Isráil koum áñzigiyoi de bérasóol lun or hañse zaiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Zaite-zaite endilla tobolik goríyo, ‘Asmani raijjo ḍáke aáigiyoi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Biyaraimma re gom goríyo, muruda re zinda goríyo, kurus biyaraimma re pak-sáf goríyo, aar bút ókkol dáfaiyo. Tuáñra maana faiyó, maana diiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Keeñil or zalit gori cúna, rufa, yáh tamar foicá no loizaiyó, ");
INSERT INTO rhgc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","sofór olla honó hóilla, battí hoor, cenṭár edde laṛí no loizaiyó; kiyólla-hoilé zee niki ham goré íte toh hána faibar laayek. ");
INSERT INTO rhgc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tuáñra ze cóor ot yáh farat góliba, héṛe zaga diibar laayek hon asé talac goríyo, aar cóor híyan ottu nó neelo foijjonto yóggwar gór ot tákiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gór ot gólibarcot sólam díyo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Zodi gór híyan laayek de óile, tuáñrar cánti híyan ot tákouk. Montor laayek no de óile, tuáñrar cánti tuáñrar hañse fíri aiyóuk. ");
INSERT INTO rhgc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Zodi honókiye tuáñra re kobul no goré yáto tuáñrar hotá no fúne, tóoile hé gór ottu yáh cóor ottu zaibarcót tuáñrar ṭéng or tollar dúil zárifelaiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Añí tuáñra re sóiyi hoóir, kiyamot or din hé cóor híyan ottu Sódom edde Gomórahr túaro bicí bordac gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Fúno, Añí tuáñra re bérasóol or ḍóilla góri rangkuñir ókkol or mazé difeṛáir deh. Hétolla háf or ḍóilla salák ó aar hoitor or ḍóilla maasum bono. ");
INSERT INTO rhgc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Maincór ttu úñciyar táikko; kiyólla-hoilé ítara tuáñra re adalot ot tulídibo, aar tuáñra re ítarar mujilíc-hána ókkol ot bet maribó. ");
INSERT INTO rhgc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Añr lla bóuli tuáñra re hákim ókkol or edde baáñcca ókkol or muúntu úddwa aná zaybo, zeéne ítarar edde Beyohúdi ókkol or hañse Añr gobá dí faro. ");
INSERT INTO rhgc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lekin zeñtté ítara tuáñra re dóridibo, héñtte kii hoibá yáh keéngori hoibá sinta no goijjó, kiyólla-hoilé tuáñra ttu ziín howá foribó, híin tuáñra re hétunot diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kiyólla-hoilé hoóiya toh tuáñra no, bólke tuáñrar Baf or Ruh éna, zibá ye tuáñrar duara hotá hoó. ");
INSERT INTO rhgc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Bái ye bái ore aar bafe fua re marifélai bolla dóridibo. Fuain de nizor bafmaar hélaf tíyai ítara re mariféla báibo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Añr nam olla bóuli tuáñra re beggúne nafórot goríbo; montor zee niki ahéri foijjonto bordac goríbo, yóggwa ye beh nejat faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Zeñtté ítara tuáñra re ekkán cóor ot zulúm goré, arekkán ot dái zaiyogói. Kiyólla-hoilé Añí tuáñra re sóiyi hoóir, tuáñra Isráil or fottí cóor ot zaiya nó óite Manúc or Fua aáizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Cárit nizor ustat or túaro ḍoóñr no, aar goóur nizor girós or túaro ḍoóñr no. ");
INSERT INTO rhgc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Cárit nizor ustat or ḍóilla óile aar goóur nizor girós or ḍóilla óile kafí. Ítara zodi gór or girós ore Belzebulhoiyé de óile, hé gór or maincóre aró hotó ḍoilla hoibó fáñllar! ");
INSERT INTO rhgc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hétolla ítara re no ḍooraiyó, kiyólla-hoilé zahér no óibo de héndilla honó jiníc gúijja nái, aar zana no zaybo de héndilla honó jiníc lukaiya nái. ");
INSERT INTO rhgc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Añí tuáñra re ziín andár ot hoóir, híin foór ot hoiyó; aar ziín tuáñrar han ot fúcfucai howá gíyeh, híin gór or sád or uottú elan goijjó. ");
INSERT INTO rhgc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Uitará re no ḍooraiyó zetará haiya re kotól goré montor ruh re kotól gorí no fare; bólke Ubá re ḍooro zibá ye ruh edde jisím duníyan ore zuzuk ot dónco gorífelai fare. ");
INSERT INTO rhgc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Duwá fiañijja ki bicí hom ṭiañ loi no bese né? Toóu tuáñrar Baf or ezin sára héntu eggwá yó meṛit fore de nái. ");
INSERT INTO rhgc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Becók, tuáñrar matár sul úddwa beggún Íba ttu gona asé. ");
INSERT INTO rhgc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hétolla, no ḍooraiyó, tuáñrar kimot boóut fiañijja ókkol or túaro bicí. ");
INSERT INTO rhgc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Zee kiyé Añré maincór muúntu cíkar goré, Añí yó yóggwa re Añr asmani Baf or muúntu cíkar goríyum. ");
INSERT INTO rhgc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Montor zee niki Añré maincór muúntu inkar goré, Añí yó yóggwa re Añr asmani Baf or muúntu inkar goríyum. ");
INSERT INTO rhgc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Añí duniyait cánti diito aiccí bóuli no ṭáariyo. Añí cánti diito aiccí de no, bólke toluwar solaitó aiccí deh. ");
INSERT INTO rhgc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kiyólla-hoilé Añí aiccí de, fua re baf or ulḍa gorídi bolla, zérfua re maar ulḍa gorídi bolla, aar bou wóre hóurir ulḍa gorídi bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Manúc or duccon óibo de nizor gór or manúc. ");
INSERT INTO rhgc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Zee niki Añré goré de yár túaro nizor baf ore yáh maa re muhábbot goré, yóggwa Añr laayek no; aar zee niki Añré goré de yár túaro nizor fua re yáh zérfua re muhábbot goré, yóggwa Añr laayek no. ");
INSERT INTO rhgc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Zee niki nizor kúruc no boói Añr fisáli dore, yóggwa Añr laayek no. ");
INSERT INTO rhgc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Zee niki nizor zan basaitó saá, yóggwa ye híyan háraifelaibo; montor zee niki Añr wasté nizor zan háraifele, yóggwa ye híyan faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Zee niki tuáñra re kobul goré, yóggwa ye Añré kobul goré deh; aar zee niki Añré kobul goré, yóggwa ye Añré difeṛáiye de Íba re kobul goré deh. ");
INSERT INTO rhgc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Zee niki honó nobi re nobir name kobul goré, yóggwa ye nobir boccíc faibo; aar zee niki honó forhésgar ore forhésgar or name kobul goré, yóggwa ye forhésgar or boccíc faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Honókiye itarár bútottu ebbe niróc ézzon ore Añr ummot de hétolla ek fiyala ṭánḍa faní diilé úddwa, Añí tuáñra re sóiyi hoóir, yóggwa ye hámaha nizor boccíc fai zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zeñtté Isá ttu Íbar baró zon cárit tun ore nosíyot goijjá óiye, Íba ítarar cóor ókkol ot taalim dito edde tobolik goittó héntu bacá lóiye. ");
INSERT INTO rhgc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zeñtté Yaháya ye ziyól ot tái Mosihr ham ókkol or baabute fúinne, yóggwa ye nizor ummot ókkol ore Isár hañse difeṛáiye, ");
INSERT INTO rhgc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yián fusár goittó, “Tuñí aibár hotá asé de Íba né, aar náki añára ar ezzon olla entezar goittám?” ");
INSERT INTO rhgc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isá ye ítara re zuwabe hoór de, “Zoó, tuáñra ziín fúnor edde dekór híin Yaháya re zanogói, ");
INSERT INTO rhgc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ki hoilé, añdá ye dekér, lenge áñṛer, kurus biyaraimma pak-sáf ór, náfange fúner, muruda zinda ór, edde gorif ókkol or hañse kúchóbor tobolik gorá zar. ");
INSERT INTO rhgc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mubarek ubá, zee niki Añr baabute andacá no goré.” ");
INSERT INTO rhgc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zeñtté Yaháyar ummot tun zaargói, Isá ye manúc ókkol ore Yaháyar baabute howát doijje de, “Tuáñra moidan zagat kii saitó giíla dé? Boiyare lore de hóir né? ");
INSERT INTO rhgc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Arnóile tuáñra kii saitó giíla dé? Barík hoor findá manúc né? Zetará barík hoor fiñdé ítara toh razmohól ot éna. ");
INSERT INTO rhgc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tóoile tuáñra kii saitó giíla dé? Honó nobi né? Ói, Añí tuáñra re hoóir, nobir túaro ḍoóñr ézzon ore. ");
INSERT INTO rhgc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yóggwa óilde ubá, zibár baabute pak-kalam ot endilla asé, ‘Soó, Añí Añr hóborgwa re Tuáñr age difeṛáir, zibá ye Tuáñr age Tuáñr foñt toiyar goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Añí tuáñra re sóiyi hoóir, mayafuain dor ttu zormo óiye de ítarar bútore bápṭismadoya Yaháyar túaro ḍoóñr honókiye nái; montor toóu úddwa asmani raijjot zee niki ebbe cóñṛo, íte yóggwar túaro ḍoóñr. ");
INSERT INTO rhgc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bápṭismadoya Yaháyar din ókkol ottu lóti yala foijjonto asmani raijjo ye zulúm faat asé, aar zulúmkur ókkole híyan ore bolazuri kobza goittó kucíc gorér. ");
INSERT INTO rhgc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kiyólla-hoilé tamám nobi ókkol or kitabe edde Tourate Yaháya foijjonto agun hotá hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tuáñra ttu yián kobul goittó monehoilé goró, ze Eliyas aibár hotá accíl Yaháya óilde íba. ");
INSERT INTO rhgc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Zar ttu fúnibar han asé, yóggwa ye fúno. ");
INSERT INTO rhgc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Añí e zobanar maincóre kii loi fúwan goittám? Ítara undilla fuain dor ḍóilla, zetará bazar ot boói oinno fuain dore matai hoó de, ");
INSERT INTO rhgc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuáñra lla añára bací bazaiyí, montor tuáñra nó naso; tuáñra lla añára bilak or zari gaiyí, montor tuáñra nó hañdo.’ ");
INSERT INTO rhgc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yaháya aái zettót háafiya nó goré, maincé hoó de, ‘Íba re búte faiyé.’ ");
INSERT INTO rhgc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aar Manúc or Fua aái zettót háafiya gorér, maincé hoó de, ‘Soó, ezzon fitác edde córabkur, házana-tulóya edde gunágar ókkol or dustó.’ Montor giyan sóiyi de híyan, híyan or hame sábut ó.” ");
INSERT INTO rhgc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Isá ye ze cóor gún ot beecbák keramoti ham goijjíl, híine touwá nó goré de hétolla Íba ye híin ore jéjjeṛai hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ó Korazin, tor uore afsús! Ó Betsáida, tor uore afsús! Kiyólla-hoilé ze keramoti ham ókkol tuáñrar bútore gorá gíyl híin zodi Ṭayár edde Sídon ot gorá zayto, ítara sálarcoṭ fiñdí edde sái or uore boói boóut age lóti touwá gorífelaito. ");
INSERT INTO rhgc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Montor Añí tuáñra re hoóir, kiyamot or din, hé Ṭayár edde Sídon or maincór ttu tuáñrar túaro hom bordac gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aar tui, ó Kaparnahúm, toré kí asman ot bazé fán uore tulá zaybo? Toré nise fatalfur ot éna félaidiya zaybo; kiyólla-hoilé ze keramoti ham ókkol tor bútore gorá gíyl híin zodi Sódom ot gorá zayto, híyan aij foijjonto ṭiki tákito. ");
INSERT INTO rhgc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Montor Añí tuáñra re hoóir, kiyamot or din, Sódom cóor or maincór ttu tor maincór túaro hom bordac gorá foribó.” ");
INSERT INTO rhgc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hétunot Isá ye hoór de, “Ó Baf, asman zobin or Malik, Añí Tuáñre cúkuriya gorír, kiyólla-hoilé Tuñí iín ore giyani edde buddíman ókkol ottu lukai rakí gura fuain dor ḍóilla maincór hañse zahér goijjó. ");
INSERT INTO rhgc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ói, ó Baf, kiyólla-hoilé Tuáñr ttu híyan bicí fosón laiggé. ");
INSERT INTO rhgc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Añr Bafe Añré hárr kessú diifélaiye. Fua re Bafe bade ar honókiye no zane, aar Baf ore yó Fua edde Fua ye zaré zahér goittó saá, yóggwa ye bade ar honókiye no zane. ");
INSERT INTO rhgc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tuáñra zetará óran óiyo edde bór fuñzá lói asó, beggún Añr hañse aiyó, Añí tuáñra re aram diiyum. ");
INSERT INTO rhgc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Añr zuañl tuáñrar uore loo aar Añr ttu cíko, kiyólla-hoilé Añí norom edde cída dil ola, tói tuáñrar forane aram faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kiyólla-hoilé Añr zuañl boité aásan, aar Añr fuñzá fatol.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hé októt ebaadot-or-din Isá giyuñr kuñṛá báy zaar; aar Íbar ummot ókkol ottu búk laiggé rár, ítara giyuñr túr ókkol tulí-tulí háat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Féroci ókkole híyan dekí Íba re hoór de, “Soó, ebaadot-or-din ziyán goríbar maná, híyan Tuáñr ummot ókkole gorér.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Montor Íba ye ítara re hoór de, “Tuáñra kí yián nó foró, zeñtté Dawud edde íbar sáañti ókkol ottu búk laiggíl, héñtte íba ye kii goijjíl dé? ");
INSERT INTO rhgc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Íba ye toh Allar gór ot góillegoi, aar íba ye edde íbar sáañti ókkole, Allar hañse peec goijjá ruṭi háail, ziín háibar ezazot no íba ttu accíl aar no íbar sáañti ókkol ottu accíl, bólke siríf imam ókkol ottu beh accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yáto tuáñra kí Tourat ot yián nó foró, ebaadot-or-din baitul-mukaddos ot imam ókkole ebaadot-or-din or niyom báñgile yo ítara behosúr dé? ");
INSERT INTO rhgc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Añí tuáñra re hoóir, baitul-mukaddos or túaro ḍoóñr Ekzon iñyót asé. ");
INSERT INTO rhgc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lekin zodi tuáñra e hotár maáni gán zainta, ‘Añí kurbani saái de no, bólke rahám saái deh,’tóoile behosúr ore hosúr no dita. ");
INSERT INTO rhgc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kiyólla-hoilé Manúc or Fua óilde ebaadot-or-din or Malik.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Isá héntu zaigói ítarar mujilíc-hánat giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Héṛe ezzon endilla manúc accíl, zar át fúaigiyoi. Ítara Isár uore elzam lagai fare fán Íba re súwal gorér de, “Ebaadot-or-din biyaram gom goríbar zayes asé né?” ");
INSERT INTO rhgc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Íba ye ítara re hoór de, “Tuáñrar bútore endilla hon asé, zar ttu eggwá bérasóol asé, aar yíba ebaadot-or-din gañrát forilé yíba re dóri tulí no loibo dé? ");
INSERT INTO rhgc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Insán or kimot toh bérasóol or túaro boóut bicí! Hétolla, ebaadot-or-din gom ham goríbar zayes asé.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Baade Íba ye manúc cwa re hoór de, “Tuáñr át tan baró.” Tói yóggwa ye híyan baráiye, hétunot híyan gom ói oinno gán or ḍóilla óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yárbaade Féroci ítara baáre zai sólla goijjé de, ítara Íba re kii bote marifélai faribó. ");
INSERT INTO rhgc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Montor Isá ye híyan zani fari héntu giiyégoi. Boóut manúc ókkol Íbar fisá doijjil, aar zetará biyaraimma accíl ítara beggún ore Íba ye gom goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Íba ye ítara re nicót goijjé de, Íbar baabute honókiyo re no hoitó. ");
INSERT INTO rhgc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Híyan etollá óiye, zeéne nobi Yesáyahr duara howá gíyl de yián fura ó: ");
INSERT INTO rhgc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Soó! Añr Háadem ore, zibá re Añí basíloiyi, Añr Adorja, zibá re lói Añr Ruh kúci. Añí Añr Ruh Ibár uore ḍálidiyum, aar Ibá ye Beyohúdi ókkol or hañse insáf elan goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ibá ye no hoijja dibo, no sillaibó, aar no rasta ókkol ot Ibár abas honókiye fúnibo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ibá ye insáf ore fóta nó goré foijjonto, élaiya hóir ore no báñgibo, aar dúañr de batti no nifáibo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ibár name beyohúdi ókkole acá rakíbo.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yárbaade ezzon búte-faiya manúc ore Isár hañse aná gíyeh, yóggwa añdá edde buk accíl. Isá ye yóggwa re gom goijjé rár, hé añdá edde buk manúc cwa ye mati yó faijjé edde dekí yó faijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Manúc beggúne taajup ói hoór de, “Ibá Dawud or Fua ói né?” ");
INSERT INTO rhgc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Híyan fúni Féroci ókkole hoór de, “Ibá ye bút ókkol dáfa de siríf bút ókkol or sóddar Belzebul or taakote.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Montor Isá ye ítarar báfani re zani ítara re hoór de, “Ze raijjot faáṭa-faáṭi foida ó, híyan toh fána óizagoi; aar ze cóor ot yáh gór ot faáṭa-faáṭi foida ó, híyan óu toh ṭiki no tákibo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Héndilla, zodi Cóitane Cóitan dáfa, tóoile toh íte nizor ulḍa nize bák óigiyoi; héen óile ítar raijjo keéngori ṭiki tákibo? ");
INSERT INTO rhgc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aar zodi Añí bút dáfai de Belzebul or taakote de óile, tóoile tuáñrar fuain de har taakote dáfa dé? Hétolla tuáñrar bisarhar óibo de ítara. ");
INSERT INTO rhgc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Montor zodi Añí bút dáfai de Allar Ruhr taakote de óile, tóoile toh Allar raijjo tuáñrar héṛe aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Honókiye boluwar manúc or gór ot góli yóggwar cómbotti luṭ gorí keéngori faribó, zodi age boluwar manúc yóggwa re bañdí no ere? Bañdí erilé éna yóggwar gór luṭ gorí faribó. ");
INSERT INTO rhgc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Zee niki Añr híkka no, yóggwa Añr ulḍa; aar zee niki Añr fúañti dola no goré, yóggwa ye cíñṛaciñṭṭá goré. ");
INSERT INTO rhgc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Hétolla Añí tuáñra re hoóir, insán or hárr guná edde kuféri maf gorídiya zaybo, montor Pak-Ruhr ulḍa kuféri maf gorídiya no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Honókiye Manúc or Fuar hélaf honó hotá hoilé, yóggwa re toh maf gorídiya zaybo; montor honókiye Pak-Ruhr hélaf hotá hoilé, yóggwa re maf gorídiya no zaybo, e zobanat óu no zaybo, aar aiyér de zobanat óu no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Gas gom de óile yíbar gula yó gom óibo, aar zodi gas hóraf de óile yíbar gula yó hóraf óibo; kiyólla-hoilé gas toh gulaye éna siná zah. ");
INSERT INTO rhgc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ó háf or fuain ókkol! Tuáñra hóraf ói keéngori gom hotá hoói faribá? Kiyólla-hoilé dil ziíne furaiya, muké híin beh hoó. ");
INSERT INTO rhgc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gom manúce gom zomaiya ttu gom mún neela; aar hóraf manúce hóraf zomaiya ttu hóraf fun neela. ");
INSERT INTO rhgc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Montor Añí tuáñra re hoóir, manúce no báfi hoó de fottí hotár hísaf ítara ttu kiyamot or din diya foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kiyólla-hoilé tuáñra behosúr ṭóoriba de yó tuáñrar hotáye, aar hosúrbon ṭóoriba de yó tuáñrar hotáye.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yárbaade hoozzon alem edde Féroci ókkole Isá re hoór de, “Úzur, añára Tuáñr ttu ekkán nicán saitó saái.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Íba ye ítara re zuwabe hoór de, “E zobanar hóraf edde zenákur maincé nicán dabi goré, montor ítara re nobi Yunus or nicán bade ar honó nicán diya no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kiyólla-hoilé Yunus zendilla tin din tin rait ḍoóñr mas or feṛot accíl, héndilla Manúc or Fua yó meṛir tole tin din tin rait tákibo. ");
INSERT INTO rhgc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kiyamot or din Ninivi cóor or manúc ókkol e zobanar manúc iín or fúañti tíyaibo, aar itará re hosúr díbo; kiyólla-hoilé ítara toh Yunus or elan fúni touwá goijjíl, aar soó, Yunus or túaro ḍoóñr Ekzon iñyót asé. ");
INSERT INTO rhgc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kiyamot or din Cibá mulluk or rani e zobanar manúc iín or fúañti uṛíbo, aar itará re hosúr díbo; kiyólla-hoilé híba ye toh Sóloman or buddír hotá fúni bolla duniyair céc matá ttu aiccíl, aar soó, Sóloman or túaro ḍoóñr Ekzon iñyót asé. ");
INSERT INTO rhgc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Zeñtté honó manúc ottu hóraf jin neele, héñtte hé jin nwá fúana zaga ókkol ot zai aram goittó zaga tuwa. Montor no faile, ");
INSERT INTO rhgc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nizoré nize hoó de ‘Añí añr gór ot waafes zaiyumbói, zentú añí neeliaiccí,’ Yíba zeñtté waafes aiyé, hé zaga gán háli, sáf goijjá edde ṭík goijjá lootfa. ");
INSERT INTO rhgc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Baade yíba zai aró háñt twa nizor túaro hóraf jin ané, aar híin góli héṛe táke; tói hé manúc cwar fisór hálot agor hálot or túaro bicí hóraf óizagoi. E zobanar hóraf maincór hálot óu héndilla beh óibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Isá ye manúc or dol ore híin hoór de októt, Íbar maa edde báiyain Íba llói hotá hoitó baáre tíyai táikke. ");
INSERT INTO rhgc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ezzone Íba re hoór de, “Soó, Tuáñr maa edde báiyain de Tuáñr llói hotá hoitó baáre tíyai táikke.” ");
INSERT INTO rhgc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zee niki Íba re zanaiyé, yóggwa re Isá ye hoór de, “Añr maa hon? Aar Añr báiyain hontará?” ");
INSERT INTO rhgc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Baade Íba ye ummot ókkol or uzu át barái hoór de, “Ótiya, Añr maa edde Añr báiyain. ");
INSERT INTO rhgc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kiyólla-hoilé zee niki Añr asmani Baf or moncá mozin sole, yóggwa óilde Añr bái, bóin aar maa.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hé din Isá gór or baáre neeli ḍiír hañsat zai boiccégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aar Íbar hañse becábicí manúc ókkol zoma óiye dé hétolla, Íba ekkán noow ot uṛí boiccé, aar manúc cún beggún kul or uore tíyai táikke. ");
INSERT INTO rhgc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tarfore Íba ye meésal ókkol dí ítara re boóut kessú hoiyé, ki hoilé, “Fúno, ezzon bis cíñṛoya bis cíñṭṭo neeillé. ");
INSERT INTO rhgc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yóggwa ye cíñṛer de októt, hodún bis rastarhañsat foijjíl, aar faik ókkole aái híin háifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hodún bis cíl zobin ot foijjíl, zeṛé bicí meṛi nái. Mur meṛi nu accíl ísafe híin ot hára ges aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Montor beil uiṭṭé rár híin furigiyói, aar cíñyor nó gasá ísafe híin fúaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hodún bis keñṛabon ot foijjíl, keñṛabon barí uṛí híin ore sibi raikké. ");
INSERT INTO rhgc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lekin ar hodún bis gom zobin ot foijjíl, aar híin ot fósol dóijje: kessút ek cót gun, kessút háiṭ gun, ar kessút tiríc gun. ");
INSERT INTO rhgc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Zar ttu fúnibar han asé, yóggwa ye fúno.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Baade cárit tun aái Isá re hoór de, “Tuñí maincóre meésal dí kiyá hotá hoó?” ");
INSERT INTO rhgc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Íba ye ítara re zuwabe hoór de, “Asmani raijjor gufoni re zainto tuáñra re beh diya giyéh, montor ítara re híyan diya nó zah. ");
INSERT INTO rhgc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kiyólla-hoilé zar ttu niki asé, yóggwa re aró diiya zaybo, aar yóggwa ttu ódorbaára tákibo; montor zar ttu niki nái, yóggwa ttu asé de híin úddwa loiféla zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Añí ítara re meésal dí etollá beh hoói, kiyólla-hoilé ítara sailé yo no deké, fúnile yo no fúne, aar no yó buzé. ");
INSERT INTO rhgc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ítarar híyane nobi Yesáyahr agun hotá yián fura óiye, ‘Tuáñra hane fúnat tákiba montor no buzíba, tuáñra suké saát tákiba montor no siníba. ");
INSERT INTO rhgc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kiyólla-hoilé manúc ítarar dil toh doró óigiyoi, ítarar han bór óigiyoi, aar ítara nizor suk bon gorífelaiye. Arnóile ítara nizor suké dekíto, hane fúnito, nizor dile buzí Añr hañse fíri aitó, aar Añí ítara re gom goittám.’ ");
INSERT INTO rhgc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Lekin mubarek tuáñrar suk, híine deké de hétolla; mubarek tuáñrar han, híine fúne de hétolla. ");
INSERT INTO rhgc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kiyólla-hoilé Añí tuáñra re sóiyi hoóir, boóut nobi edde forhésgar manúc ókkole tuáñra ziín dekór híin dekí bolla azzu goijjíl, montor nó deké; tuáñra ziín fúnor híin fúni bolla yó azzu goijjíl, montor nó fúne. ");
INSERT INTO rhgc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Yala bis cíñṛoyar meésal lan or maáni kii fúno. ");
INSERT INTO rhgc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Zeñtté honókiye raijjor kalam fúne montor no buzé, Ibilíce aái yóggwar dil ot ziín cíñṛa gíyeh híin harí loizagói. Manúc yóggwa óilde rastar hañsat foijjé de bis. ");
INSERT INTO rhgc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Cíl zobin ot foijjé de bis óilde ubá, zee niki kalam fúne aar éhon híin ore kúcir sáañte kobul goré; ");
INSERT INTO rhgc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","montor nizor bútore mozbut cíñyor nó gasá de hétolla híin hooddin beh táke. Zeñtté hé kalam or zoriya mosibot yáh zulúm aiyé, yóggwa éhon fissá mare. ");
INSERT INTO rhgc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Keñṛabon ot foijjé de bis óilde ubá, zee niki kalam fúne, montor duniyair sintabáfaniye edde dón-doulot or adore hé kalam ore sibi raké, hétolla híin ot gula no dóre. ");
INSERT INTO rhgc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lekin gom zobin ot foijjé de bis óilde ubá, zee niki kalam fúne edde buzé, aar gula dóra: kessú ye ek cót gun, kessú ye háiṭ gun, aar kessú ye tiríc gun.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Isá ye ítara re arekkán meésal dí hoór de, “Asmani raijjo óilde undilla manúc or ḍóilla, zee niki nizor zobin ot gom bis ókkol cíñṭṭe. ");
INSERT INTO rhgc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Montor yóggwar manúc ókkol gúm gíyeh rár, yóggwar duccon aái giyuñt mazé kérkuñṛar bis ókkol cíñṛidi giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Zeñtté giyuñr sara barí uṛí fósol dóijje, héñtte kérkuñṛa yó dahá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Tói gór or goóur ókkole girós or hañse aái hoór de, ‘Jonab, tuñí tuáñr zobin ot gom bis cíñṭṭila de nó né? Tói kérkuñṛa hontú aiccé?’ ");
INSERT INTO rhgc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Yóggwa ye ítara re hoór de, ‘Ezzon duccone híyan goijjé deh.’ Goóur gúne yóggwa re hoór de, ‘Tóoile añára zai híin háñri félaitamboi né?’ ");
INSERT INTO rhgc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Montor yóggwa ye hoór de, ‘No, no, tuáñra kérkuñṛa háñribarcot giyuñ yó háñrifelaiba. ");
INSERT INTO rhgc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Daibar ainda nú aiyé foijjonto duní gún ore fúañti baríto doh; one daibar ainda ailé añí dooiya ókkol ore hoiyúm de, furat difélai bolla age kérkuñṛa gún zoma gorífelai tara bañdífelo; baade giyuñ gún añr gudam ot zoma goró.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Isá ye ítara re aró ekkán meésal dí hoór de, “Asmani raijjo óilde eggwá hóroir danar ḍóilla, zibá re ezzon manúce looi nizor kétit lagayégoi; ");
INSERT INTO rhgc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","yíba oinno bis beggún or túaro cóñṛo de óile yo, barí uṛíle yíba kétir tamám sara ókkol or túaro ḍoóñr ói endilla eggwá gas bone, zeén níki faik ókkole aái yíbar ḍéeila ókkol ot bahá bañdé.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Isá ye ítara re aró ekkán meésal díye de ki hoilé, “Asmani raijjo óilde cúṭar or ḍóilla, ziín ore eggwá mayafua ye looi tokoriban ekkuri tin cér aṭat miyáiye, baade guñṛa hañi or dola fúli uiṭṭé.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isá ye maincóre híin beggún meésal dí beh hoiyé; meésal sára Íba ye ítara re honó kessú no hoitó. ");
INSERT INTO rhgc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Zeéne nobir duara howá gíyl de yián fura ó: “Añí meésal ókkol dí Añr muu kúliyum; Añí uúin boiyan goríyum ziín duniyair foidayecir héñtte lóti lukaiya asé.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Baade Isá manúc ókkol ore eri gór or bútore giiyé. Aar Íbar cárit tune Íbar hañse aái hoór de, “Añára re zobin or kérkuñṛar meésal lan buzáido.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Íba ye ítara re hoór de, “Zibá ye niki gom bis cíñṭṭe, Íba óilde Manúc or Fua. ");
INSERT INTO rhgc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Zobin nán óilde duniyai, gom bis sún óilde raijjor fuain, aar kérkuñṛa gún óilde Ibilíc or fuain, ");
INSERT INTO rhgc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ze duccone híin cíñṭṭe íte óilde Ibilíc, daibar ainda óilde duniyair ahérot, aar dooiya gún óilde fírista ókkol. ");
INSERT INTO rhgc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Zendilla, kérkuñṛa gún ore zoma gorífelai ooin ot furat diféle, e duniyair ahérot ot óu héndilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manúc or Fua ye Nizor fírista ókkol ore difeṛáibo, aar híine Íbar raijjor bútottu zetará oinno zon ore gunát foraba edde zetará kuham goré, ítara beggún ore ekkán ot zoma goríbo, ");
INSERT INTO rhgc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","aar ítara re zoler de ooin or fooin ot félaidibo; héṛe hañdahaṛi edde date dat kirkirani óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Héñtte forhésgar ókkol nizor Baf or raijjot mazé beil or ḍóilla somkibó. Zar ttu fúnibar han asé, yóggwa ye fúno. ");
INSERT INTO rhgc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Asmani raijjo óilde zobin ot lukai raikká dón or ḍóilla, ziín ezzon manúce fai abar lukai raikké; aar hé kúciye zai nizor ttu asé de hárr kessú besi hé zobin nán kinnégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Abar, asmani raijjo óilde undilla códor or ḍóilla, zee niki háṭi mukta ókkol or talac ot asé; ");
INSERT INTO rhgc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","zeñtté yóggwa ye eggwá bicí dami mukta faiyé, hétunot zai nizor ttu asé de hárr kessú besi yíba kinnégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Abar, asmani raijjo óilde undilla ṭana-zal or ḍóilla, ziyán fanít buwái hárr kisím or mas dóijje, ");
INSERT INTO rhgc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","aar híyan bórigiyoi rár zailla ókkole ṭani sor ot ainné. Tarfore ítara boói gom mún gom mún ḍulat bóijje, montor hóraf fun hóraf fun félaidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Duniyair ahérot ot borabor héndilla beh óibo. Fírista ókkol aibó, aái forhésgar ókkol ottu nafórman ókkol ore alok gorífelaibo, ");
INSERT INTO rhgc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","baade ítara re zoler de ooin or fooin ot félaidibo; héṛe hañdahaṛi edde date dat kirkirani óibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isá ye ítara re hoór de, “Tuáñra iín beggún buijjó né?” Ítara hoór de, “Buijjí ze.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Íba ye ítara re hoór de, “Hétolla fottí alem zetará asmani raijjor cárit bonigiyói, ítara beggún endilla ezzon gór or girós or ḍóilla zee niki nizor gudam ottu noya edde furan jiníc ókkol neela.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zeñtté Isá ttu meésal híin hoiyá óiye, Íba héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Íba Nizor wotón ot aái manúc ókkol ore ítarar mujilíc-hánat eén taalim diyat doijje, zeén níki ítara ammúke hoór de, “E Manúc cwa ye e giyan edde keramoti ham iín goríbar kémota hontú faiyé? ");
INSERT INTO rhgc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ibá kí mistírir fua no? Ibár maa Moriyam hoó de híba no né, aar Ibár báiyain Yakub, Yusúf, Sáimon edde Yohúdah no né? ");
INSERT INTO rhgc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ibár bóinain beggún añárar fúañti asé de no né? Tói Ibá ye iín beggún hontú faiyé?” ");
INSERT INTO rhgc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Héndilla hoói ítara Íba re inkar goijjé. Montor Isá ye ítara re hoór de, “Ze honó nobir izzot nizor wotón ot edde nizor gór ot bade beggúlla asé.” ");
INSERT INTO rhgc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aar ítarar nabiccác or zoriya Íba ye héṛe bicí keramot nó goré. ");
INSERT INTO rhgc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hé októt Galil elakar hókumot-goróya Hérude Isár baabute hóbor fúinne, ");
INSERT INTO rhgc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","tói yóggwa ye nizor uzir-nazir ókkol ore hoór de, “Íba óilde bápṭismadoya Yaháya, íba mora ttu zinda óiye deh; hétolla toh íba ye keramoti ham híin gorí farer.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kiyólla-hoilé Hérude nizor bái Filíp or bou Hérudias or wasté hé Yaháya re gereftar gorí bañdífelai ziyól ot díyl. ");
INSERT INTO rhgc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yaháya ye yóggwa re endilla hoitó de hétolla, “Tuáñr ttu híba re biyá goríbar zayes nái.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yóggwa ttu íba re marifélaito monehoitó, montor awam ókkol ore ḍooraitó, kiyólla-hoilé ítara Yaháya re nobi manitó. ");
INSERT INTO rhgc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lekin zeñtté Hérud or zormo-din aiccé, Hérudias or zíi ye maáfil ot nasi Hérud ore kúci goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hétolla yóggwa ye hosóm hái waada goijjé de, híba ye ziín mage híin diibo hoói. ");
INSERT INTO rhgc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nizor maa ye cíkaidiye de héndilla híba ye hoór de, “Bápṭismadoya Yaháyar holla wa re ekkán tálit góri eṛé añré doo.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Híyan fúni baáñcca ttu bicí afsús laiggé, montor toóu nizor hosóm edde meéman ókkol or zoriya yóggwa ye hókum díye de, híbar aros sán fura gorá záy bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tarfore yóggwa ye manúc difeṛái, ziyól ot Yaháyar holla haṛiféla baye. ");
INSERT INTO rhgc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Baade íbar holla wa ekkán tálit góri aní zérfua wa re diiya giyéh, aar zérfua wa ye nizor maar hañse ainné. ");
INSERT INTO rhgc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yárbaade Yaháyar ummot ókkole aái yore íbar lac cwa loizai dohón gorífelaiye; baade zai Isá re híyan zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Isá ye Yaháyar baabute fúinne rár, héntu síra ói noow ot gori ekkán bocóti-sára zagat giiyói. Aar manúc ókkole híyan fúni, cóor ókkol ottu neeli áñṛi-áñṛi Íbar fisá doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zeñtté Isá noow ttu laimmé, Íba ye ḍoóñr ek dol manúc deikké; aar ítara lla feṭfuri ítarar biyaram ókkol gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Zeñtté háñz óiye, Íbar cárit tune Íbar hañse aái hoór de, “Yián toh ekkán bocóti-sára zaga, aar beil óu giyói. Hétolla manúc cún ore duñraido, zeéne tará fara ókkol ot zai nizor lla hána kinigói fare.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Montor Isá ye ítara re hoór de, “Tará ttu zaagói no foribó; hái bolla kessú tará re tuáñra doo.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ítara Íba re hoór de, “Añára ttu eṛé fañs swá ruṭi edde duwá mas bade ar kessú nái.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Íba ye hoór de, “Híin eṛé Añr hañse anógoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Baade Íba ye manúc cún ore kér or uore boitó hókum díye, aar hé fañs swá ruṭi edde duwá mas sún looi asman or uzu saái cúkuriya goijjé. Tarfore ruṭi gún báñgi-báñgi cárit tun ore diiyé, aar cárit tune manúc cún ore baṛidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tará beggúne feṭ bóri háiye. Baade ze tukuṛa ókkol basigiyói, cárit tune híin feñṛai looi fura baró báñir bóijje. ");
INSERT INTO rhgc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Háiye de ítara beṛiyáin edde fuain bad di tokoriban fañs ázar beṛaáin. ");
INSERT INTO rhgc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Baade éhon or bútore Isá ye Nizor cárit tun ore mojbur goijjé de, Íba ye manúc cún ore bidai gorí dite-dite ítara zeéne noow ot uṛí Íbar age ḍiír okule zaagói. ");
INSERT INTO rhgc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Manúc cún ore bidai gorídi baade, Íba ekéla faár or uore dua goittó uiṭṭói. Aar háñz óiye de héñtte, Íba héṛe háliga, ");
INSERT INTO rhgc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","montor noow gán kul ottu boóut duré, aar boiyar uzan baát accíl ísafe híyan léinge éñskar. ");
INSERT INTO rhgc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Fuáñitta, Isá fanír uottú áñṛi-áñṛi ítarar héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Íba fanír uottú áñṛer de híyan cárit tune dekí bicí ḍooraigiyói, aar hoór de, “Ibá bút!” Héndilla hoói, ítara ḍoore guzoran maijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Montor Isá ye éhon-éhon ítara re hoór de, “Hímmot goró! Ibá Añí; no ḍooraiyó.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Zuwabe Fitore Íba re hoór de, “Malik, zodi Tuñí de óile, añré fanír uottú Tuáñr héṛe aitó hókum dóh.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Íba ye hoór de, “Ai.” Hétunot Fitor noow ttu lami, fanír uottú áñṛi-áñṛi Isár híkka zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Montor zeñtté tez boiyar deikké íba ḍooraigiyói, aar ḍufízargoi rár guzori hoór de, “Malik, añré baso!” ");
INSERT INTO rhgc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isá ye toratori Nizor át barái íba re dórifelai hoór de, “Ó hom biccác ola, cóok kiyá goijjós?” ");
INSERT INTO rhgc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Baade zeñtté ítara noow ot uiṭṭégai, boiyar támaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aar zetará noowr uore accíl ítara Íba re eén hoói sóida goijjé, “Becók, Tuñí óilade Allar Fua.” ");
INSERT INTO rhgc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ítara ḍií farái, Genesáret elakat foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aar hé zagar maincé Isá re sinné rár, ítara sairó ḍak or elakar agagurat hóbor foóñsai, biyaraimma ókkol beggún ore Íbar hañse ainné; ");
INSERT INTO rhgc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","baade ítara Íba re fóriyat gorát doijje de, biyaraimma gún ore siríf Íbar fucák or hañra óile súito dí bolla; aar zetó zone súiye ítara beggún gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yárbaade Jerúsalem ottu hoozzon alem edde Féroci, Isár hañse aái hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tuáñr ummot ókkole agor zobanar buzurgó ókkol or rosóm kiyá báñge? Ítara hána háibar agor ttu át no dúwe.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isá ye ítara re zuwabe hoór de, “Tuáñra nize yó kiyá tuáñrar rosóm or zoriya Allar hókum báñgo? ");
INSERT INTO rhgc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Alla ye toh endilla hoiyé, ‘Bafmaa re izzot goríba’ aar ‘Zee niki baf or yáh maar bodnam goré, ítare mariféla zaybo.’ ");
INSERT INTO rhgc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Montor tuáñra hoó de, ‘Zodi honókiye baf ore yáh maa re eén hoó, “Ze siz loi tuáñra añr ttu laf faita híyan Alla re diiféla gíyeh,” ");
INSERT INTO rhgc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","tóoile ítar ttu baf ore yáh maa re izzot gorár zorur nái.’ Héen gorí, tuáñra tuáñrar rosóm or zoriya Allar kalam ore baatel gorífelaiyo. ");
INSERT INTO rhgc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ó munafék ókkol, tuáñrar baabute nobi Yesáyah ye sóiyi hotá hoiyé, ki hoilé, ");
INSERT INTO rhgc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Manúc iíne Añré nizor muké beh izzot goré, montor tarár dil Añr ttu duré. ");
INSERT INTO rhgc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tará Añr ebaadot goréde behar; kiyólla-hoilé tará taalim ísafe cíka de óilde insán or niyom-kaanun ókkol.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Isá ye manúc ókkol ore Nizor hañse matai, ítara re hoór de, “Fúno aar buzó. ");
INSERT INTO rhgc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gal ot ziín góle manúc ore híine nafak goré de no, bólke gal ottu ziín neeliaiyé manúc ore híine beh nafak goré.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hétunot cárit tune aái Íba re hoór de, “Tuñí hoi faro né, Féroci ókkole yián fúni bezar óiye dé?” ");
INSERT INTO rhgc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Íba ye zuwabe hoór de, “Ze sara Añr asmani Bafe lagaiyé de no, híyan háñrifela zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ítarar hotá félai ero. Ítara óilde añdá ókkol or añdá foñt dahóya; zodi ek añdá ye arek añdá re foñt dahá, duní zon toh gañt ot forizaybói.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fitore Íba re hoór de, “Añára re meésal híyan buzáido.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isá ye hoór de, “Tuáñra yó aijjó obuz táigiyogoi dé? ");
INSERT INTO rhgc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tuáñra kí no buzó, ziín gal or bútore góle híin zaa de óilde feṛot, aar feikána ttu neelizagói dé? ");
INSERT INTO rhgc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Montor ziín gal ottu neeliaiyé híin aiyé de óilde dil ottu, aar manúc ore híine beh nafak goré. ");
INSERT INTO rhgc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kiyólla-hoilé dil ottu éna kukíyal, kotólakotóli, ḍoilla-boḍoilla zenákari, suri, misá gobá, edde gifot aiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Manúc ore híine beh nafak goré; montor adúiya áte hána háile manúc ore nafak goré de no.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Baade Isá hé zaga félai, Ṭayár edde Sídon cóor or elakat giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hé elakar eggwá Kánani mayafua neeli aái yore guzori-guzori Íba re hoór de, “Ó Malik, Dawud or Fua, añr uore rahám goró! Añr zérfua wa búte fai bicí duk far.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Montor Isá ye híba re honó zuwab nó deh. Hétunot Íbar cárit tune aái yore Íba re aros gorér de, “Ibáh re duñrai difélo, kiyólla-hoilé ibáh toh añárar fisé-fisé guzorat asé.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isá ye zuwabe hoór de, “Añré siríf Isráil koum or áñzigiyoi de bérasóol ókkol or hañse beh difeṛá gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Montor mayafua wa aái yore Íbar muúntu sóida fori hoór de, “Ó Malik, añré modot goró!” ");
INSERT INTO rhgc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isá ye zuwabe hoór de, “Fuain dor hána looi kuñir or muúntu félai dón gom no.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Híba ye hoór de, “Ói, Malik, montor toóu de girós or mes ottu forizagói de tukuṛa híin kuñire háa.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hétunot Isá ye híba re hoór de, “Ó mayafua, tuáñr iman bicí ḍoóñr! Tuñí ziyán soór tuáñr lla híyan gorá záybo.” Tói éhon or bútore híbar zérfua wa gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Baade Isá héntu bacá lói, Galil Ḍií báy zai eggwá faár or uore uṛí boiccégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hétunot Íbar hañse becábicí manúc ókkol aiccé, zetará fúañti leng, añdá, mazur, buk, edde aró boóut kisím or biyaraimma ókkol aní Íbar ṭéng or gurat eijjé; aar Íba ye ítara re gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Zeñtté manúc ítara buk ókkole hotá hoór de, mazur gom óiye de, lenge áñṛer de, añdá ye dekér de híin deikké, ítara taajup óigiyoi, aar ítara Boni Isráil or Allar taarif goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isá ye Nizor cárit tun ore matai hoór de, “Añr ttu manúc itará lla feṭfurer, kiyólla-hoilé itará Añr fúañti asé de tin din óiye aar itará ttu háito kessú nái. Añr ttu itará re waácca duñraidito mone no hoór, zeéne itará foñt ot matá gúrai fori no zagói.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Cárit tune Íba re hoór de, “Manúc or ettór ḍoóñr dol ore feṭ bóri hábai bolla añára e bocóti-sára elakat hédun ruṭi hoṛé faiyum?” ");
INSERT INTO rhgc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isá ye ítara re hoór de, “Tuáñra ttu ruṭi houwá asé?” Ítara hoór de, “Háñt twa, aar houggwá gura mas.” ");
INSERT INTO rhgc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Íba ye manúc cún ore meṛit boitó hoiyé; ");
INSERT INTO rhgc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","baade hé háñt twa ruṭi edde mas sún looi Alla re cúkuriya goijjé, aar híin báñgi cárit tun ore diiyé, aar cárit tune manúc cún ore diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Beggúne feṭ bóri háiye, baade ze tukuṛa ókkol basi accíl híin bóijje rár lai loi háñt lai óiye. ");
INSERT INTO rhgc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Zetará háiye ítara óilde sair ázar beṛaáin, beṛiyáin edde fuain bad dih. ");
INSERT INTO rhgc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Isá ye manúc or dol lwá re bidai gorídi baade, noow ot uṛí Magádan elakat giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ek din Féroci ókkole edde Sadukái ókkole aái Isá re entán gorí bolla Íba re hoiyé de, ítara re ekkán asmani nicán daháito. ");
INSERT INTO rhgc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Íba ye ítara re zuwabe hoiyé de, “Háñz óile tuáñra hoó de, ‘Moósum gom óibo, kiyólla-hoilé asman lal óiye.’ ");
INSERT INTO rhgc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aar biínna hoó de, ‘Aijja tuwán óibo, kiyólla-hoilé asman lal óiye edde gubbar óiye.’ Tuáñra toh asman or súrot saái moósum forók gorí zano, montor zobanar alamot ore forók gorí no faroór dé? ");
INSERT INTO rhgc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","E zobanar hóraf edde zenákur maincé nicán tuwa, montor ítara re nobi Yunus or nicán bade ar honó nicán diya no zaybo.” Tói Íba ítara re eri, giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aar Cárit tun ḍiír okule zaibarcót, fúañti ruṭi loizaitó foóraigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Isá ye ítara re hoór de, “Hóboroddar, Féroci ókkol or edde Sadukái ókkol or cúṭar ottu úñciyar táikko.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hétunot ítara afós ot howáhoi gorér de, “Íba ye híyan hoór de añára ruṭi nú aní de hétolla.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Montor Isá ye híyan zani fari, ítara ttu fusár gorér de, “Ó hom biccác ola ókkol! Tuáñra ttu ruṭi nái de híyan kiyá afós ot howáhoi gorór? ");
INSERT INTO rhgc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tuáñra aijjó nó buzó níki? Tuáñra ttu monot nái né, fañs ázar maincóre fañs swá ruṭi loi hábai baade aró ho báñir bóri loóila? ");
INSERT INTO rhgc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Héndilla, sair ázar maincóre háñt twa ruṭi loi hábai baade aró ho lai bóri loóila? ");
INSERT INTO rhgc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Añí tuáñra re ruṭir baabute hoóir de no de híyan no kiyá buzór? Féroci ókkol or edde Sadukái ókkol or cúṭar ottu úñciyar táikko.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hétunot ítara buzí faijjé de, Íba ye ítara re ruṭir cúṭar ottu úñciyar tákito hoiyé de no, bólke Féroci ókkol or edde Sadukái ókkol or taalim ottu. ");
INSERT INTO rhgc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Baade Isá zeñtté Kaisáriya Filíppi elakat aiccé, Íba ye Íbar cárit tun ottu fusár gorér de, “Maincé Manúc or Fua re hon bouli hoó?” ");
INSERT INTO rhgc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ítara zuwab der de, “Hodúne hoó de Tuñí bóle bápṭismadoya Yaháya; ar hodúne hoó de, nobi Eliyas; ar hodúne hoó de, Yarmíyah yáh oinno nobi ókkol ottu honó eggwá.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tói Íba ye ítara re hoór de, “Montor tuáñra kii hoó, Añí hon?” ");
INSERT INTO rhgc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sáimon Fitore zuwabe hoór de, “Tuñí óilade hé Mosih, zinda Allar Fua.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Isá ye íba re hoór de, “Yunus or fua Sáimon, tui mubarek, kiyólla-hoilé toré yián honó insáne zahér goijjé de no, bólke Añr asmani Bafe goijjé deh. ");
INSERT INTO rhgc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Añí yó toré hoóir, tui óilide Fitor,aar Añí e fattór or uore Añr zomát banaiyúm; híyan ore moote úddwa no zitibó. ");
INSERT INTO rhgc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Añí toré asmani raijjor sabí diiyum; tui e duniyait ziín bañdíbi híin asman ot óu bañdá zaybo, aar e duniyait ziín ezazot dibi híin asman ot óu ezazot diya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Baade Íba ye Íbar cárit tun ore horagori nicót goijjé de, Íba Mosih de híyan honókiyo re no hoitó. ");
INSERT INTO rhgc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hé októt lóti Isá ye Nizor cárit tun ore zanaidiyat doijje de, Íba ttu hámaha Jerúsalem ot zaa foribó; aar murubbi, ḍoóñr imam, edde alem ókkol or át ot boóut ḍóilla duk faa foribó; Íba re mariféla zaybo, montor tin din ot din zinda gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hétunot Fitore Íba re ekkinare loizai buzár de, “Ó Malik, híyan dur óuk. Tuáñr uore héndilla honódin no óuk.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Isá ye fíri Fitor ore hoór de, “Cóitan, Añr muúntu dur ó! Tui óilide Añr lla oñsá; kiyólla-hoilé tor díyan toh Allar gún or uzu no, bólke insán or gún or uzu.” ");
INSERT INTO rhgc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Isá ye tarfore Íbar cárit tun ore hoór de, “Zodi honókiyo ttu Añr fisáli aitó monehoó, yóggwa ttu nizoré inkar gorífela foribó, aar nizor kúruc boói Añr fisáli dora foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kiyólla-hoilé zee niki nizor zan basaitó saá, yóggwa ye híyan háraifelaibo; montor zee niki Añr wasté nizor zan háraifele, yóggwa ye híyan faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kii laf, zodi honókiye tamám duniyai faa, montor nizor zan nán háraifele? Insáne nizor zan or bodol kii dii faribó de asé? ");
INSERT INTO rhgc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kiyólla-hoilé Manúc or Fua toh Nizor Baf or mohímaye Nizor fírista ókkol ore fúañti looi aibó, tarfore fottí zon ore nizor-nizor ham mozin bodola diibo. ");
INSERT INTO rhgc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Añí tuáñra re sóiyi hoóir, eṛé endilla hodún manúc tíyaiya asé, zetará Manúc or Fua re Íbar raijjot hókumot goittó aiyér de nó dekíte no moribó.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sów din baade Isá ye siríf Fitor ore, Yakub ore, edde yóggwar bái Yohánna re looi, ítara re eggwá uñsol faár or uore loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Héṛe ítarar muúntu Íbar súrot bodoligiyói. Íbar siyára beil or ḍóilla zolat doijje, aar Íbar hoor nur or ḍóilla dúf óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hétunot ítara deikké de, Muúsa edde Eliyas Íba llói hotá hoór. ");
INSERT INTO rhgc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Fitore zuwabe Isá re hoór de, “Malik, gom óiye añára eṛé así. Zodi Tuñí soó, añí eṛé tin nán ṭambu ṭakiyúm: ekkán Tuáñr lla, ar ekkán Muúsa lla, edde ar ekkán Eliyas olla.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Fitore hotá hoór de októt, ekkán nurani miyúla ye ítara re sáifelaiye, aar hé miyúla ttu eggwá abas aiccé de, “Ibá óilde Añr adorja Fua, zibá re lói Añí bicí kúci. Ibár hotá fúno!” ");
INSERT INTO rhgc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cárit tune híyan fúinne rár, meṛit uúiñtoi foijjé, aar bicí ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Montor Isá aái ítara re súi hoór de, “Uṛó, no ḍooraiyó.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hétunot ítara suk tulí saiyé rár, siríf Isá re bade ar honókiyo re nó deké. ");
INSERT INTO rhgc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ítara faár ottu lami aiyér de októt, Isá ye ítara re hókum gorér de, “Tuáñra ziyán deikkó, híyan Manúc or Fua re mora ttu zinda gorá nó zah foijjonto honókiyo re no hoiyó.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Íbar cárit ítara Íba ttu fusár gorér de, “Tóoile alem ókkole kiyá endilla hoó, age nobi Eliyas aár zorur?” ");
INSERT INTO rhgc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isá ye zuwabe hoór de, “Becók, age Eliyas aibó aar hárr kessú zendilla ówa foitto héndilla gorídibo. ");
INSERT INTO rhgc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Montor Añí tuáñra re hoóir, Eliyas aáigiyoi. Lekin manúc ókkole íba re nó siné, bólke íba re ítara ttu zeén monehoiyé héen goijjé. Borabor héndilla, Manúc or Fua yó ítarar át ot duk faibar asé.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hétunot cárit ítara buijjé de, Íba ye ítara re bápṭismadoya Yaháyar baabute hoór deh. ");
INSERT INTO rhgc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Baade ítara zeñtté manúc or dol or héṛe aiccé, ezzon manúce Isár hañse aái añṛú félai hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ó Malik, añr fua war uore rahám goró, ítar ttu súañfíra asé, aar bicí duk faar; íte egazá ooin ot edde fanít fore. ");
INSERT INTO rhgc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Añí ítare Tuáñr cárit tun or hañse ainnílam, montor tará ítare gom gorí nó fare.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hétunot Isá ye zuwabe hoór de, “Ó iman sára edde báañra nosól, Añí tuáñrar fúañti-fúañti aró hotókkal tákitam? Hotódin Añí tuáñra re bordac goittám? Ítare eṛé Añr hañse anó.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isá ye bút twa re dómkidiye rár, yíba fua war bútottu neeligiyói, aar íte éhon-éhon gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tarfore cárit tune Isár hañse aiddone aái hoór de, “Yíba re añára kiyá neelai nó fari?” ");
INSERT INTO rhgc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Isá ye ítara re hoór de, “Tuáñrar iman or homir zoriya. Kiyólla-hoilé Añí tuáñra re sóiyi hoóir, zodi tuáñra ttu hóroir danar héttirin iman táke, tuáñra e faár gwá re eén hoói faribá, ‘Entú lori uṛé zaagói,’ tói yíba lorizaybói. Tuáñra gorí no faribá de kessú no tákibo. ");
INSERT INTO rhgc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lekin dua edde ruza sára endilla gún neelai no fare.” ");
INSERT INTO rhgc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Zeñtté cárit tun Galil ot zoma óiye, Isá ye ítara re hoór de, “Manúc or Fua re manúc ókkol or át ot gosáidiya zaybo; ");
INSERT INTO rhgc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aar ítara Íba re marifélaibo, montor Íba re tin din ot din zinda gorá zaybo.” Híyan fúni ítara ttu bicí ferecan laiggíl. ");
INSERT INTO rhgc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Isá edde Íbar cárit tun Kaparnahúm ot foóñsi baade, baitul-mukaddos or házana-tulóya ókkol Fitor or hañse aái hoór de, “Tuáñrar ustate baitul-mukaddos or házana no dee níki?” ");
INSERT INTO rhgc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Fitore hoór de, “Becók, dee.” Zeñtté Fitor gór or bútore aiccé, íba ye hoibár agor ttu Isá ye íba re hoór de, “Sáimon, tui kii báfos? Duniyair baáñcca ókkole hásil yáh házana har ttu tulé, nizor maincór ttu né náki baár or maincór ttu?” ");
INSERT INTO rhgc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Fitore hoór de, “Baár or maincór ttu.” Isá ye íba re hoór de, “Tóoile toh nizor manúc ókkol basigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Montor añára ítara re bezar no gorí fán, ḍiít zai borkí baágoi. Ze mas age foribó yíba re loibi; aar yíbar gal kúlile ekkán rufar foicá faibi ziyán kafí óibo. Híyan looi Añr lla edde tor lla híyan ítara re házana dic.” ");
INSERT INTO rhgc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hé októt cárit tune Isár hañse aái hoór de, “Tóoile asmani raijjot ebbe ḍoóñr honnwá?” ");
INSERT INTO rhgc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tói Íba ye eggwá gura fua re Íbar hañse matai ítarar mazé tíyagaraiye, ");
INSERT INTO rhgc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aar hoór de, “Añí tuáñra re sóiyi hoóir, zodi tuáñra bodoli gura fuain dor ḍóilla no bono, tóoile asmani raijjot bilkúl góli no faribá. ");
INSERT INTO rhgc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hétolla zee niki nizoré e gura fua war ḍóilla cóñṛo bana, yóggwa óilde asmani raijjot ebbe ḍoóñr. ");
INSERT INTO rhgc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aar zee niki endilla honó gura fua re Añr name kobul goré, íte Añré kobul goré deh.” ");
INSERT INTO rhgc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Zee niki Añr uore iman ainné de e cóñṛo ókkol ottu honókiyo re guná gorába, ítar lla beétor óilde, ítar golat eggwá bór cíl or sakki bañdí mur doijjat ḍufáidiya zah. ");
INSERT INTO rhgc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Duniyair uore siz uúin or zoriya afsús, ziíne gunát foraba. Kiyólla-hoilé híin toh aibár zorur, montor uitar uore afsús, zar duara niki híin aiyé.” ");
INSERT INTO rhgc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Zodi tuáñr áte yáh ṭénge tuáñre gunár uzu ṭane, tóoile híyan haṛi tuáñr héntu félaido. Dui át yáh dui ṭéng táki ofúrani ooin ot félaidiya zar túaro, ṭúñṛa yáh leng ói zindigit góla tuáñr lla beétor. ");
INSERT INTO rhgc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aar zodi tuáñr suké tuáñre gunár uzu ṭane, tóoile yíba tuáñr héntu neelai félaido. Dui suk táki zuzuk or ooin ot félaidiya zar túaro, eggwá suk loi zindigit góla tuáñr lla beétor. ");
INSERT INTO rhgc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Saiyó, e cóñṛo ókkol ottu ezzon ore yó hékarot no goijjó; kiyólla-hoilé Añí tuáñra re hoóir, tarár fírista ókkole asman ot mazé hámica Añr asmani Baf or siyára deké. ");
INSERT INTO rhgc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Manúc or Fua aiccé de áñzigiyoi de ítara re nejat di bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tuáñra kii báfo? Zodi honó manúc ottu ek cót bérasóol táke aar héntu eggwá ór óizagoi, íte nobboi-now wa re faár or uore eri, ór óigiyoi de yíba re tuwaitó no zaibo né? ");
INSERT INTO rhgc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Añí tuáñra re sóiyi hoóir, íte yíba re tuwai faile, ór nó de nobboi-now wa bérasóol lun ore lói túaro íte yíba re lói bicí kúci goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Héndilla, tuáñrar asmani Baf or moncá yián no de ki, e gura itará ttu ezzon úddwa dónco óizon. ");
INSERT INTO rhgc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Zodi tuáñr bái ye tuáñr ulḍa hosúri goré, tóoile zai aiddone ítar hosúr daháidiyo. Zodi íte tuáñr hotá dóre, tóoile tuñí tuáñr bái ore fírai faiyó. ");
INSERT INTO rhgc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Montor zodi íte tuáñr hotá no dóre, tóoile tuáñr fúañti aró ezzon yáh dui zon manúc loizaiyó, zeéne ‘ze honó maamela dui zon yáh tin zon gobár zobane sóiyi bouli sábut óizagoi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aar zodi íte ítarar hotá yó no dóre, tóoile híyan zomát ore hoiyó. Aar zodi zomát or hotá yó no dóre, tóoile íte tuáñra lla ézzon gairimandár yáh házana-tulóyar ḍóilla óuk. ");
INSERT INTO rhgc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Añí tuáñra re sóiyi hoóir, tuáñra duniyait ziín bañdíba, híin asman ot óu bañdá zaybo; aar duniyait ziín ezazot diba, híin asman ot óu ezazot diya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Añí tuáñra re yián óu hoóir, zodi duniyait tuáñrar bútottu dui zone ektofák ói dua goríle, Añr asmani Baf or torfóttu ítara lla híyan gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kiyólla-hoilé zeṛé dui zon yáh tin zon Añr name zoma ó, héṛe Añí ítarar mazé así.” ");
INSERT INTO rhgc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hétunot Fitore aái Isá re hoór de, “Malik, zodi añr bái ye añr ulḍa hosúri gorát táke, añí ítare ho bar maf goittám? Háñt bar né?” ");
INSERT INTO rhgc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isá ye íba re hoór de, “Añí toré háñt bar bóuli no hoóir, bólke hóittor gun háñt bar. ");
INSERT INTO rhgc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kiyólla-hoilé asmani raijjo óilde endilla baáñccar ḍóilla, zibá ye nizor goóur ókkol ottu ísaf loito saiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Zeñtté yóggwa ye ísaf lowa cúru goijjé, hétunot yóggwar hañse endilla ezzon ore aná gíyeh, zar ttu yóggwa ye lak-lak ṭiañ footi faar. ");
INSERT INTO rhgc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Íte zettót híin fúñzi no farer, ítar giróse hókum díye de, híin fúñzi bolla ítare, ítar bou fuain dore edde ítar ttu ziín asé híin beggún besiféla zay bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Hétolla goóur gwá ye yóggwar muúntu uúiñtoi fori hoór de, ‘Ó malik, hooddin ánik sobór goró, añí tuáñre beggún fúñzifelaiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hétunot goóur gwar girós ottu ítar lla feṭfuijje, aar footi gún maf di ítare eridiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Montor hé goóur gwá baárkule zai, nizor sáañti goóur ottu ezzon ore loot faiyé, zibá ye ítar ttu ek cót dinárṭiañ udár loóil. Íte íba re dóri gola sibi hoór de, ‘Añr footi diiféla.’ ");
INSERT INTO rhgc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Hétunot ítar sáañti goóur gwá ye ítar ṭéng ot uúiñtoi fori fóriyat gorér de, ‘Hooddin ánik sobór goró, añí tuáñre beggún fúñzifelaiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Montor íte nó mane, bólke zai ítare otókkal olla ziyól ot diyégoi, zetókkal foijjonto footi híin nó fúñze. ");
INSERT INTO rhgc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Zeñtté ítar oinno sáañti goóur ókkole híyan deikké, ítara ttu bicí ferecan laiggé, aar aái ítarar girós ore ziín óiye híin beggún zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Tói giróse ítare matai hoór de, ‘Tui toh hóraf goóur! Tui añré fóriyat goijjós de hétolla, añí toh tor footi beggún maf diyí. ");
INSERT INTO rhgc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tor ttu yó tor sáañti goóur or uore rahám gorón nu accíl né, zendilla añí tor uore rahám goijjí?’ ");
INSERT INTO rhgc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Girós ottu guccá uṛí, ítare otókkal foijjonto sáñza dí bolla ziyól or zimmadar ore gosáidiye, zetókkal ítar footi beggún fúñzi nó fele. ");
INSERT INTO rhgc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Añr asmani Bafe yó tuáñra re héndilla beh goríbo, zodi tuáñra fottíkiye nizor bái ore dil ottu maf no doh.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zeñtté Isá ttu hotá híin hoiyá óiye, Íba Galil ottu bacá lói Jordán hál or farkul or Yohúdiya elakat giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Becábicí manúc ókkol Íbar fisá doijjil, aar héṛe Íba ye ítarar biyaram gom goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Isár hañse hodún Féroci yó aiccé; ítara Íba re entán gorí bolla súwal gorér de, “Morotfua ye nizor bou wóre ze honó wajáye sárifelaibar zayes asé né?” ");
INSERT INTO rhgc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Íba ye zuwabe hoór de, “Tuáñra kí nó foró, zibá ye ítara re foida goijjé Íba ye cúrut lóti ítara re morot aar maya banaiyé deh, ");
INSERT INTO rhgc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","aar hoiyé de, ‘Híyan olla toh morotfua ye nizor bafmaa ttu zuda ói nizor bou wór fúañti tákibo, aar ítara duní zon ek jisím óizayboi’? ");
INSERT INTO rhgc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hé ísafe, ítara ar dui no, bólke ek jisím. Hétolla Alla ye zetará re zur goijjé, ítara re honó manúce síra no goróuk.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ítara Íba re hoór de, “Tóoile Muúsa ye endilla kiyá hókum díye, híba re sárhabos dii duñrai diyo?” ");
INSERT INTO rhgc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isá ye ítara re zuwab der de, “Tuáñrar dil doró de hétolla Muúsa ye tuáñra re tuáñrar bouwáin sárifelar ezazot diyé deh, montor cúrut lóti héndilla nu accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Añí tuáñra re hoóir, zee kiyé nizor bou wóre zenár hosúri lla bade ar honó wajáye sárifele aar ar eggwá re biyá goré, íte zená gorér deh.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Cárit tune Íba re hoór de, “Zodi zamai bou wór hálot héndilla ó, tóoile biyá no gorón éna beétor.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isá ye ítara re hoór de, “Hotá híyan beggúne kobul gorí no fare, montor siríf uitará beh fare zetará re híyan or toóufik diiya giyéh. ");
INSERT INTO rhgc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kiyólla-hoilé ízara ókkol or bútore hodún óilde maar feṛot lóti ízara,aar hodún ore ízara banaiyé de óilde maincé; endilla yó hodún ízara asé zetará asmani raijjor wasté biyá no goré. Zee niki híyan kobul gorí fare, íte kobul goróuk.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ek din maincé gura fuain dore Isár hañse anát doijje, zeéne Íba ye ítarar uore át dé edde ítara lla dua goré; montor cárit tune manúc cún ore bóṭboṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lekin Isá ye hoór de, “Fuain dore Añr hañse aitódo; ítara re no oóñillo, kiyólla-hoilé asmani raijjo toh ítarar ḍóilla maincé éna hásil goré.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ítarar uore át dí baade Íba héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fore ezzon manúc Isár hañse aái hoór de, “Ustat, ofúrani zindigi faite añr ttu kii gom ham gorá foribó?” ");
INSERT INTO rhgc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Íba ye yóggwa re hoór de, “Gom orbaabute tuñí Añr ttu kiyá fusár gorór? Gom toh siríf Ekzon éna asé. Montor tuáñr ttu zindigit góilto monehoilé, hókum ókkol amól goró.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yóggwa ye Íba re hoór de, “Hon nún?” Isá ye hoór de, “ ‘Kún no goríba; zená no goríba; suri no goríba; misá gobá no diba; ");
INSERT INTO rhgc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bafmaa re izzot goríba,’edde ‘nizor atehañsór maincóre nizor ḍóilla muhábbot goríba.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Juwan manúc cwa ye Íba re hoór de, “Añí híin beggún amól gorí-gorí aiyír. Añr ttu ar kii baki asé?” ");
INSERT INTO rhgc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isá ye yóggwa re hoór de, “Zodi tuáñr ttu furafuri háṭi óito monehoó, tóoile zoo, tuáñr cómbotti ókkol besi gorif ore diifélogoi, tói tuñí asman ot dón faiba; baade aái Añr fisáli óiyogai.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Montor juwan manúc cwa ye híyan fúinne rár, ferecanir sáañte giiyégoi; kiyólla-hoilé yóggwa ttu becábicí dón-cómbotti asé. ");
INSERT INTO rhgc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hétunot Isá ye Íbar cárit tun ore hoór de, “Añí tuáñra re sóiyi hoóir, tuangor manúc ottu asmani raijjot gólite bicí mockil. ");
INSERT INTO rhgc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Añí tuáñra re abar hoóir, tuangor manúc Allar raijjot gólar túaro, eggwá uñṭ fúñc or faái ttu goli zaa aró aásan.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cárit tune híyan fúinne rár bicí taajup óigiyoi, aar hoór de, “Tóoile hone nejat fai faribó?” ");
INSERT INTO rhgc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isá ye ítarar uzu saái hoór de, “Híyan insáne gorí no fare, montor Alla ye hárr kessú gorí fare.” ");
INSERT INTO rhgc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hétunot Fitore Íba re hoór de, “Soó, añára de hárr kessú eridi Tuáñr fisáli óigiyigoi. Tóoile añára kii faiyum?” ");
INSERT INTO rhgc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isá ye ítara re hoór de, “Añí tuáñra re sóiyi hoóir, tuáñra zetará Añr fisáli óiyo, noya foidayecir októt zeñtté Manúc or Fua Íbar mohímar toktót boibó, héñtte tuáñra yó baró wan toktót boói Isráil or baró háandan or bisar goríba, ");
INSERT INTO rhgc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","aar zee niki Añr wasté nizor gór, bái, bóin, baf, maa, bou, fuain, yáh zagazobin eridiyé, yóggwa ye ek cót gun bicí faibo, aar ofúrani zindigi miras faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lekin boóut zon, zetará yala age asé, ítara fisé óizayboi; aar zetará yala fisé asé, ítara age óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kiyólla-hoilé asmani raijjo toh endilla zomidar or ḍóilla, zibá ye ek din biínna sóore yóggwar anggur-bariza lla mozur dóitto giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yóggwa ye ítara re dine ek dináror dóre dii bolla razi ói, ítara re yóggwar anggur-barizat difeṛáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Yóggwa now wa báze góri baárkule giiyé rár, aró hodún manúc ham sára, bazar ot tíyai táikke de deikké. ");
INSERT INTO rhgc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yóggwa ye ítara re hoór de, ‘Tuáñra yó zai añr anggur-barizat ham gorógoi, añí tuáñra re hók motafe góri dam diiyum.’ Baade ítara giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Yóggwa abar baró wa báze edde tin nwá báze góri baárkule zai, ekí ḍóilla goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Fañs swá báze góri yóggwa baárkule giiyé rár, héṛe aró manúc ókkol tíyai táikke de deikké. Yóggwa ye ítara re hoór de, ‘Tuáñra eṛé dinbór ham sára kiyá tíyai táikko?’ ");
INSERT INTO rhgc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ítara yóggwa re hoór de, ‘Añára re honókiye ham ot nó loo de hétolla.’ “Yóggwa ye ítara re hoór de, ‘Tuáñra yó zai añr anggur-barizat ham gorógoi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Háñzinna óiye rár, anggur-barizar giróse mazí re hoór de, ‘Mozur gún ore mata, aar fisór ttu aiccé de ítare lóti cúru gorí age aiccé de ítare foijjonto dam diiféla.’ ");
INSERT INTO rhgc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Zetará re fañs swá báze ham ot laga giyéh, ítara fottíkiye aái ek dinár or dóre faiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hétolla zetará re age ham ot laga giyéh ítara aái, bicí faibo bouli ṭáaijje. Montor ítara fottí zone yó faiyé de ek dinár or dóre. ");
INSERT INTO rhgc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ítara faiyé rár, zomidar gwar ulḍa monmonat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Eén hoói, ‘Fisór manúc itará siríf ek gónḍa beh ham goijjé, montor añára de dinbór roid or gorom ot ham goijjí, toóu tuñí itará re añára llói fúwan goijjó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Hétunot yóggwa ye ítara ezzon ore zuwabe hoór de, ‘Bái, añí toré honó nainsáfi nó gorí. Tui ek dinár lói ham gorí bolla añr llói razi óilide no né? ");
INSERT INTO rhgc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tor dam looi yore zaagói. Fisé aiccé de manúc ítare yó añr ttu tor fúwan dam diito monehoór. ");
INSERT INTO rhgc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Añr nizor jiníc lói añr ttu zeén monehoó héen gorí bolla añr ttu hók nái niki? Aar náki añí gom de hétolla tor ttu ric lager dé?’ ");
INSERT INTO rhgc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Hétolla hoóir, zetará yala age asé, ítara fisé óizayboi; aar zetará yala fisé asé, ítara age óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Isá uore Jerúsalem ot zaar de októt, Íba ye baró zon cárit tun ore ekkinare loizai foñt or uore ítara re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Soó, añára uore Jerúsalem ot zairgói, héṛe Manúc or Fua re ḍoóñr imam ókkol or edde alem ókkol or hañse dóridiya zaybo; ítara Íba re moot or fótua díbo, ");
INSERT INTO rhgc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","edde Beyohúdi ókkol or hañse gosáidibo, Íba re ínca gorí bolla, coóñk mari bolla, edde kúruc ot dífelai bolla. Lekin tin din ot din Íba re zinda gorá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yárbaade Zebedair fuain dor maa ye híbar fuain looi Isár hañse aiccé, aar sóida fori Íba re ekkán aros goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Isá ye híba re hoór de, “Tuñí kii soór dé?” Híba ye Isá re hoór de, “Añré waada doo de, Tuñí añr e fua duní wa re Tuáñr raijjot buágaraiba, ezzon ore Tuáñr den ḍák ottu, ar ezzon ore Tuáñr ban ḍák ottu.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Montor Isá ye zuwabe hoór de, “Tuáñra kii magor híyan tuáñra no zano. Añí fiíyum de fiyala yíba tuáñra fií faribá né?” Ítara Íba re hoór de, “Fariyúm.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Isá ye ítara re hoór de, “Becók tuáñra Añr fiyala fiíba, montor Añr den ḍák ottu yáh ban ḍák ottu honókiyo re buágaron Añr ham no. Zaga híin óilde uitará lla zetará lla niki Añr Bafe toiyar gorí raikké.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Baki doc zon cárit tune híyan fúni, ítara duní bái lói guccá óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Montor Isá ye ítara beggún ore Nizor hañse matai hoór de, “Tuáñra toh zano, Beyohúdi ókkol or hókumot-goróya ókkole tarár uore raastri goré; aar tarár ḍoóñr sóddar ókkole ítarar uore adíkar sola. ");
INSERT INTO rhgc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Montor tuáñrar bútore héndilla ón ṭík no, bólke tuáñra ttu zee niki ḍoóñr óito saá, ítar ttu tuáñrar háadem bonar zorur; ");
INSERT INTO rhgc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","aar tuáñra ttu zee niki age óito saá, ítar ttu tuáñrar gulam bonar zorur; ");
INSERT INTO rhgc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","zendilla Manúc or Fua yó hédmot faito aiccé de no, bólke aiccé de hédmot goittó, edde boóut zon or bodol Nizor zan dito.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zeñtté ítara Jerikó cóor ottu neeler, ḍoóñr ek dol manúc Isár fisá doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dui zon añdá manúc rastar hañsat boiṛá accíl; ítara Isá hé rasta báy zaar de fúinne rár, guzori-guzori hoór de, “Ó Malik, Dawud or Fua, añárar uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Manúc cúne ítara re jéjjeṛai nizám óito hoiyé, montor ítara aró ḍoóñr góri guzori hoór de, “Ó Malik, Dawud or Fua, añárar uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hétunot Isá tíyaigiyoi, aar ítara re matai hoór de, “Tuáñra kii soó, Añí tuáñra lla kii goittám?” ");
INSERT INTO rhgc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ítara Íba re hoór de, “Malik, añára saái, añárar suk kún kúlizoggoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isá ttu ítarar uore rahám lagi ítarar suk kún súiye; ítarar suk éhon-éhon gom óigiyoi, aar ítara Íbar fisá doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zeñtté ítara Jerúsalem or ḍáke Zaitun Faár ot asé de Betfégi edde Betániya farat foóñicce, hétunot Isá ye dui zon cárit ore difeṛáiye, ");
INSERT INTO rhgc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ítara re endilla hoói, “Tuáñra muúm or fara gán ot zoo, héṛe zai mottor eggwá gadá baindá loot faiba, yíbar fúañti eggwá sóo yó faiba. Híin ore kúli Añr héṛe anógoi. ");
INSERT INTO rhgc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Zodi honókiye tuáñra re kessú hoó, tuáñra hoibá de, ‘Malik ottu iín ore lager.’ Tói yóggwa ye híin ore éhon difeṛáidibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Híyan etollá óiye, zeéne nobir duara howá gíyl de yián fura ó: ");
INSERT INTO rhgc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Síyon or zérfua re hoibá de, ‘Soó, tuáñr Baáñcca tuáñr hañse aiyér. Íba cída, Íba gadár uore gori, gadár sóor uore gori aiyér.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hé cárit ítara zai, Isá ye ítara re zendilla cíkaidiye héndilla goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ítara gadá edde gadár sóo wa re ainné, aar híin or uore nizor hoor ókkol bicáidiye, aar Isá híin or uore boiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Beec bák maincé nizor hoor ókkol rastar uore bicáidiye; argúne gas or ḍaggwa ókkol haṛi rastat bicáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zedún manúc Isár age-age edde fisé-fisé zaat accíl, ítara guzori-guzori hoór de, “Dawud or Fua re Hósana! Mubarek Ubá zibá Mabud or name aiyér. Ebbe uore asman ot Allar taarif óuk!” ");
INSERT INTO rhgc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zeñtté Isá Jerúsalem ot góille, guñṛa cóor úrussul ot forigiyói; ítara hoór de, “Ibá hon?” ");
INSERT INTO rhgc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Manúc cúne hoór de, “Ibá óilde Isá nobi, Galil or Nasárat cóor or.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Fore Isá baitul-mukaddos ot góille, aar zetará héṛe besa kina gorér ítara re loraidiyat doijje; aar baṭṭa báñgoyar ṭebíl edde hoitor besoyar boiṛóni ókkol natḍiyagarai diye. ");
INSERT INTO rhgc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Íba ye ítara re hoór de, “Pak-kalam ot endilla asé, ‘Añr gór ore munazat or gór howá zaybo,’montor tuáñra toh híyan ore ḍahañit or aḍḍa-hána banaifélaiyo.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tarfore añdá ókkol edde leng ókkol baitul-mukaddos ot Isár hañse aiccé, aar Íba ye ítara re gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lekin ḍoóñr imam ókkole edde alem ókkole zeñtté Isá ye goijjé de taajuippa ham ókkol deikké, edde baitul-mukaddos or bútore fuain de guzori-guzori, “Dawud or Fua re Hósana!” hoór de fúinne, ítara ttu bicí guccá uṛígiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ítara Íba re hoór de, “Tuñí fúnor né fuain iíne kii hoór?” Isá ye ítara re hoór de, “Fúnir, tuáñra kí yián honódin nó foró, ‘Gura fuain dor edde dud or fuain dor muk ottu Tuñí Tuáñr taarif óibar entezam goijjó?’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Baade Íba ye ítara re eri cóor or baáre Betániya farat giiyégoi, aar héṛe rait haṛaáil. ");
INSERT INTO rhgc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Biínna sóore, Isá cóor ot waafes zaibarcót, Íba ttu búk laiggé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Íba ye foñt ot eggwá ḍuñir-gas dekí, yíbar íñyot giiyé, montor yíbat fata bade ar kessú loot nó faa. Hétunot Íba ye gas swá re hoór de, “Ar honódin tor ttu gula no dórouk.” Tói éhon or bútore ḍuñir-gas swá fúaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Híyan dekí cárit tun taajup óigiyoi, aar hoór de, “Ḍuñir-gas swá eén toratori keén fúaigiyoi?” ");
INSERT INTO rhgc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isá ye ítara re zuwabe hoór de, “Añí tuáñra re sóiyi hoóir, zodi tuáñra ttu iman táke aar cók no goró, tóoile tuáñra siríf ḍuñir-gas swár uore ziyán óiye híyan gorí faribá de no, bólke zodi e faár gwá re yó hoó, ‘Uṛí doijjat forgói,’ híyan óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tuáñra duat mazé iman or sáañte ziín magibá híin beggún faiba.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Isá ye baitul-mukaddos or uṛán ot góli baade taalim der de októt, Yohúdir ḍoóñr imam ókkol edde murubbi ókkol Íbar hañse aiccé, aar hoór de, “Tuñí ham iín kii adíkare gorór? Tuáñre e adíkar hone diiyé?” ");
INSERT INTO rhgc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isá ye ítara re zuwabe hoór de, “Añí yó tuáñra ttu ekkán súwal fusár goríyum. Tuáñra Añré híyan or zuwab dilé Añí yó tuáñra re hoiyúm Añí iín kii adíkare gorír deh. ");
INSERT INTO rhgc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yaháya ye bápṭisma díbar adíkar hontú faáil? Asman ottu né náki insán ottu?” Ítara afós ot biyasana gorér de, “Zodi añára hoói ‘asman ottu,’ Íba ye añára re hoibó de, ‘Tóoile tuáñra íba re biccác kiyá nó goró?’ ");
INSERT INTO rhgc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Montor zodi hoói, ‘insán ottu,’ tóoile añára de maincóre ḍoorai, kiyólla-hoilé beggúne toh Yaháya re nobi mane.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hétolla ítara Isá re zuwabe hoór de, “Añára no zani.” Íba ye yó ítara re hoór de, “Tóoile Añí yó tuáñra re no hoiyúm Añí iín kii adíkare gorír.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tuáñrar buzá kii? Dóro, ezzon manúc ottu duwá fua asé, yóggwa ye fua ḍoóñr gwar hañse zai hoór de, ‘Ó fut, aijja anggur-barizat zai ham gorgói.’ ");
INSERT INTO rhgc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Fua ye zuwab diyé de, ‘Añí no zaiyum,’ montor íte fisór ttu mon fírai yore giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yóggwa ye fua cóñṛo war hañse yó zai ekí ḍóilla hoiyé. Íte zuwab diyé de, ‘Jii, zaiyum,’ montor íte nó zaa. ");
INSERT INTO rhgc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Fua duní wa ttu hone baf or moncá fura goijjé?” Ítara Íba re hoór de, “Ḍoóñr gwá ye.” Isá ye ítara re hoór de, “Añí tuáñra re sóiyi hoóir, házana-tulóya ókkol edde magi mayafuain ókkolAllar raijjot tuáñrar age góler. ");
INSERT INTO rhgc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kiyólla-hoilé Yaháya toh forhésgarir torika dahái bolla tuáñrar hañse aiccíl, aar tuáñra íba re ekin nó goró; montor házana-tulóya ókkole edde magi mayafuain ókkole íba re ekin goijjé; tuáñra híyan dekí baade yo mon nó fíro aar íba re ekin nó goró.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Arekkán meésal fúno: Ekgwá zomidar accíl, zibá ye ekkán anggur-bariza lagaiyé. Yóggwa ye híyan or sairó ḍák ottu gíra díye, anggur or roc neelai bolla héṛe bútore eggwá gañrá kuijjé, aar ekkán ṭongki baindé. Baade bariza gán cacá ókkol ore ṭéka dí yóggwa oinno mulluk ot giiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Zeñtté anggur or ainda aiccé, yóggwar gula yóggwa ye fai bolla nizor goóur ókkol ore cacá gún or hañse difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Montor cacá gúne yóggwar goóur híin ore dóri, eggwá re mara-dóra goijjé, ar eggwá re zane marifélaiye, ar eggwá re fattór maijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Abar yóggwa ye agor gún or túaro beecgori goóur ókkol difeṛáiye; cacá gúne ítara re yó ekí ḍóilla goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ebbe ahérit, yóggwa ye eén báfi nizorfua re ítarar héṛe difeṛáiye, ‘Ítara añr fua re izzot goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Montor cacá gúne fua wa re dekí afós ot hoór de, ‘Ite toh mirasdár; aiyó itaré marifélai itar miras loifélai.’ ");
INSERT INTO rhgc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tói ítara íba re dóri barizar baáre loizai marifélaiye.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Hé ísafe, barizar girós ailé, hé cacá gún ore kii goríbo fáñllar?” ");
INSERT INTO rhgc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ítara Íba re hoór de, “Yóggwa ye hóraf manúc híin ore sáabgori hótom gorífelaibo, aar bariza gán undilla cacá ókkol ore ṭéka dífelaibo zetará ainda ailé yóggwa re gular bák diibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isá ye ítara re hoór de, “Tuáñra pak-kalam ot yián bilkúl nó foró níki, ‘Ze fattór mistíri ye inkar gorífelaiye, yíba fattór beggún or túaro bicí zoruri wa óigiyoi. Híyan Mabud or torfóttu óiaicce, aar híyan añárar suk ot taajuippa?’ ");
INSERT INTO rhgc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hétolla Añí tuáñra re hoóir, Allar raijjo tuáñra ttu loifélai undilla eggwá koum ore diiféla zaybo, zibá ye niki híyan orgulagala dóraibo. ");
INSERT INTO rhgc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Zee niki hé fattór or uore foribó, íte báñgi hán-hán óizayboi; montor zar uore niki hé fattór foribó, íte ficí záyboi.” ");
INSERT INTO rhgc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ḍoóñr imam ókkole edde Féroci ókkole Íbar meésal lun fúni buzígiyoi de ki Íba ye ítarar baabute hoór deh. ");
INSERT INTO rhgc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ítara Íba re dórifelai bolla kucíc goijjíl, montor ítara awam ókkol ore ḍooraitó, kiyólla-hoilé ítara Íba re nobi mainto. ");
INSERT INTO rhgc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Isá ye ítara re aró ekbar meésal dí hoór de: ");
INSERT INTO rhgc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Asmani raijjo óilde undilla baáñccar ḍóilla, zibá ye nizor fuar boirat or hána goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Zetará re boiraitta hánar dawot diya giyéh,ítara re matai bolla yóggwa ye nizor goóur ókkol difeṛáiye, montor ítara aitó nó saá. ");
INSERT INTO rhgc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Yóggwa ye abar ar hodún goóur ore endilla hoói difeṛáiye, ‘Zetará re dawot diya giyéh ítara re hoibá de, yala añr ttu hána nal goijjá óiye; añr doóñra goru edde boli goru zooráiyi, yala beggún nal. Tuáñra boirat or hánat aiyó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Montor ítara éckara gorí nizor-nizor ham ot giiyégoi, kiyé nizor kétit ar kiyé nizor códorit, ");
INSERT INTO rhgc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","aar baki gúne yóggwar goóur gún ore dóri ítara re bodsólluk goijjé edde marifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lekin híyan fúni baáñcca bicí rak óigiyoi, aar nizor fóous ókkol difeṛái hé kúni ókkol ore dónco gorífelaiye, edde ítarar cóor furat difélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Baade yóggwa ye nizor goóur gún ore hoór de, ‘Boirat or hána toh nal óiye, montor zetará re dawot diya gyíl ítara aibár laayek no. ");
INSERT INTO rhgc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hétolla, cóor or rastar muáñ-muáñ zai zetó zon loot foo, ítara re boirat or hánar dawot dogói.’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tói goóur gúne baáre rastat zai zaré-zaré loot faiyé, gom hóraf beggún ore dola goijjé; baade boiraitta-hána gán meémane furaigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Montor baáñcca ye bútore meéman ókkol ore saitó aiccé de októt, héṛe boiraitta hoor afindá ezzon manúc deikké. ");
INSERT INTO rhgc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yóggwa ye ítar ttu fusár gorér de, ‘Dustó, tuñí boiraitta hoor sára eṛé bútore keéngori góillo?’ Manúc cwa ye honó zuwab di nó fare. ");
INSERT INTO rhgc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Hétunot baáñcca ye háadem ókkol ore hoór de, ‘Itar át ṭéng bañdí, itaré baáre andár ot félai dogói; héṛe hañdahaṛi edde date dat kirkirani óibo.’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Kiyólla-hoilé ḍaha toh boóut zon ore giyéh, montor hoozzon ore beh basílowa gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hétunot Féroci ókkol zai, Isá re kii bote Íbar hotá lói hol ot félai faribó híyan sólla goijjégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ítara nizor cárit tun ore Hérudiól or fúañti Íbar hañse difeṛái hoór de, “Ustat, añára zani de, Tuñí sóiyi hoó edde sóiyigori Allar rastar taalim doh. Tuñí maincé kii hoór forba no goró, kiyólla-hoilé Tuñí toh honókiyo re forók goró de nái. ");
INSERT INTO rhgc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Añára re hoósai, Tuñí kii báfo? Romi baáñcca re házana doon zayes asé né náki nái?” ");
INSERT INTO rhgc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Montor Isá ye tarár hóraf niyot ore zani hoór de, “Ó munafék ókkol, tuáñra Añré entán gorór kiyá? ");
INSERT INTO rhgc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Házana dee de héndilla ekkán Añré foicá dahó.” Tói tará Íbar re ekkán dinár aní diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Íba ye tará re hoór de, “Yián har sóbi edde har nam?” ");
INSERT INTO rhgc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tará Íba re hoór de, “Romi baáñccar.” Tói Íba ye tará re hoór de, “Tóoile ziín baáñccar híin baáñcca re diiyo, aar ziín Allar híin Alla re diiyo.” ");
INSERT INTO rhgc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Híyan fúni tará taajup óigiyoi, aar Íba re eri giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hé din Sadukái ókkol Isár hañse aiccé, Sadukái ókkole háñcor nái hoó, ítara aái Íba re ekkán súwal goijjé, ");
INSERT INTO rhgc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ki hoilé, “Ustat, Muúsa ye hoiyé de, ‘Zodi honó manúc fuain sára morizagói, tóoile ítar bái ottu ítar bou híba re biyá gorífelai nizor bái olla nosól foida gorá foribó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dóro, añárar bútore háñt zon bái accíl. Foóila wa ye biyá gorí fuain sára morigiyói, hétolla íte nizor bou wóre bái olla rakígiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Héndilla hálot dusára, tisára ebbe háñto bái foijjonto óiye. ");
INSERT INTO rhgc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ahérit, mayafua wa yó morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hé ísafe, háñcor or hale híba ítara háñto zon ottu har bou óibo? Kiyólla-hoilé híba re toh ítara beggúne biyá goijjíl.” ");
INSERT INTO rhgc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isá ye ítara re zuwabe hoiyé de, “Tuáñra gollot ot asó, kiyólla-hoilé tuáñra toh no pak-kalam zano, aar no Allar kudurut zano. ");
INSERT INTO rhgc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kiyólla-hoilé háñcor or hále manúc ókkole no biyá goríbo aar no ítara re biyá díya zaybo, bólke ítara asman ot fíristar ḍóilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mora ókkol zinda ówar baabute hoitó sailé, tuáñra kí Alla ye tuáñra re hoiyé de yián nó foró, ");
INSERT INTO rhgc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Añí óilam de Ibrahím or Alla, Isahák or Alla edde Yakub or Alla’?Alla toh mora ókkol or Alla no, bólke zinda ókkol or éna.” ");
INSERT INTO rhgc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Manúc cúne híyan fúinne rár, Íbar hé taalime taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Zeñtté Féroci ókkole fúinne de, Isá ye Sadukái ókkol ore nizám márai raikké, ítara ekkán ot zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ítara ttu Córiyot or ézzon aleme entán gorí bolla Íba re súwal gorér de, ");
INSERT INTO rhgc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ustat, Tourat Córif ot hókum hon nán ebbe ḍoóñr?” ");
INSERT INTO rhgc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isá ye yóggwa re hoór de, “ ‘Mabud tuáñrar Alla re nizor fura dile, fura zane, edde fura demake muhábbot goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Híyan óilde ebbe ḍoóñr edde ebbe zoruri hókum. ");
INSERT INTO rhgc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ebbe zoruri hókum dui nombór or gán óilde, ‘Nizor atehañsór maincóre nizor ḍóilla muhábbot goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hé hókum duníyan ot fura Córiyot edde nobi ókkol or hotá loṭkaiya.” ");
INSERT INTO rhgc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Féroci gún ekkán ot zoma asé de októt, Isá ye ítara re ekkán súwal gorér de, ");
INSERT INTO rhgc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mosihr baabute tuáñrar buzá kii? Íba har Fua?” Ítara Íba re hoór de, “Dawud or Fua.” ");
INSERT INTO rhgc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Íba ye ítara re hoór de, “Tóoile Dawude keéngori Íba re Ruhr hédaiyote ‘Malik’ ḍaikké? Íba ye toh endilla hoiyé, ");
INSERT INTO rhgc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mabude añr Malik ore hoór de, “Añr den ḍák ottu boiyó, zetókkal foijjonto Añí Tuáñr duccon ókkol ore Tuáñr foor tole gorí nó felai.” ’ ");
INSERT INTO rhgc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tói Dawude Íba re ‘Malik’ ḍaikké de óile, Íba keéngori Dawud or fua dé?” ");
INSERT INTO rhgc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Íba re honókiye ehoór óu zuwab di nó fare, aar hé din lóti Íba re ar súwal gorí bolla honókiye hímmot no goittó. ");
INSERT INTO rhgc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Baade Isá ye manúc or dol ore edde Nizor ummot ókkol ore hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Córiyot buzáidi bolla alem ókkol edde Féroci ókkol óilde Muúsar zagat. ");
INSERT INTO rhgc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hétolla, ítara tuáñra re ziín goittó hoó, híin beggún goijjó edde mainno, montor ítara goré de híin no goijjó; kiyólla-hoilé ítara ziín hoó híin toh nize no goré. ");
INSERT INTO rhgc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ítara bór-bór fuñzá ókkol bañdí maincór hañd or uore tulí déh, montor híin lari bolla ítara nize eggwá ooñl úddwa dito no saá. ");
INSERT INTO rhgc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ítara ziín goré híin maincóre dahái bolla beh goré; ítara toh pak-kalam or ayat leikká tabis ore ḍoóñr góri bana, edde nizor fucák or hañrar doói lamba goré. ");
INSERT INTO rhgc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ítara mela-cóbat barík zaga edde mujilíc-hána ókkol ot uñsol tokkar hadírat boitó fosón goré, ");
INSERT INTO rhgc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ítara aró, bazare-bazare sólam faito, edde maincé ítara re ‘Rabbí, Rabbí’ hoói ḍakilé fosón goré. ");
INSERT INTO rhgc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Montor tuáñra re ‘Rabbí’ ḍaha no baiyó; kiyólla-hoilé tuáñrar Ustat toh eggwá éna, aar tuáñra beggún óilade bái bái. ");
INSERT INTO rhgc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Duniyait honókiyo re baf no ḍakiyó; kiyólla-hoilé tuáñrar Baf toh ekgwá éna, zibá níki asman ot asé. ");
INSERT INTO rhgc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tuáñra re ‘Sóddar’ dahá no baiyó, kiyólla-hoilé tuáñrar Sóddar toh ekgwá éna, Íba óilde Mosih. ");
INSERT INTO rhgc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lekin tuáñra ttu zee niki ebbe ḍoóñr, íte tuáñrar háadem bonouk. ");
INSERT INTO rhgc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Zee niki nizoré nize ḍoóñr kúwala, ítare cóñṛo gorá zaybo; aar zee niki nizoré nize cóñṛo kúwala, ítare ḍoóñr gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh maincór ttu asmani raijjo bon gorífelo; tuáñra nize yó no gólo aar zetará bútore góilto sár ítara re yó góilto no doh. ");
INSERT INTO rhgc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé ek mikká ttu tuáñra toh rari ókkol or gór ókkol luṭ gorífelo, arek mikká ttu maincóre dahái bolla lamba-lamba dua goró. Hétolla tuáñra sáñza bicí ḍoóñr faiba. ");
INSERT INTO rhgc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh ezzon manúc ore tuáñrar dórmot aní bolla doijja-doijja edde zaga-zaga lamba sofór goró; aar zeñtté ezzon aní faro, héñtte tuáñra ítare nizor túaro dui gun zuzuki bano. ");
INSERT INTO rhgc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ó añdá foñt dahóya ókkol, tuáñrar uore afsús! Tuáñra hoó de, ‘Honókiye baitul-mukaddos or hosóm háile, kessú no; montor honókiye baitul-mukaddos or cúnar hosóm háile, híyan hámaha adai gorá foribó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ó bekuf edde añdá ókkol! Hon nán bicí ḍoóñr, cúna né náki cúna re pak-sáf goré de baitul-mukaddos? ");
INSERT INTO rhgc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tuáñra yián óu hoó de ki, ‘Honókiye kurbani-gáñr hosóm háile, kessú no; montor honókiye híyan or uore asé de kurbanir hosóm háile, híyan hámaha adai gorá foribó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ó añdá ókkol! Hon nán bicí ḍoóñr, kurbani ne náki kurbani re pak-sáf goré de kurbani-gáñ? ");
INSERT INTO rhgc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hétolla zee niki kurbani-gáñr hosóm há, íte kurbani-gáñr edde híyan or uore asé de híin beggún or beh hosóm há. ");
INSERT INTO rhgc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aar zee niki baitul-mukaddos or hosóm há, íte baitul-mukaddos or edde híyan or bútore táke de Íbar beh hosóm há. ");
INSERT INTO rhgc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Zee niki asman or hosóm há, íte Allar toktór edde híyan or uore zibá boiyé Íbar beh hosóm há. ");
INSERT INTO rhgc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh fudinar, masswá bahór or, edde zirar doc bák or ek bák doo, lekin Córiyot orbicí dami hotá re, yáni insáf, rahám edde imandari re tuáñra bad difélo. Tuáñra ttu iín óu gorón accíl aar uúin óu bad no don accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tuáñra óilade añdá ókkol, zetará oinno zon ore foñt dahó, zetará eggwá masí re úddwa sái yore félaido, montor uñṭ gilifélo. ");
INSERT INTO rhgc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh fiyalar edde tálbason or baárḍák sáf goró, montor híin or bútore de tuáñra zulúm edde lalsí gorí faiyó de híine furaiya. ");
INSERT INTO rhgc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ó añdá Féroci! Age fiyalar edde tálbason or bútor or ḍák sáf gorífelo, tói baárḍák óu sáf óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh endilla hobor or ḍóilla, ziín ore dóla gorá gíyeh. Híin baár ttu saité de cúndor, montor bútore mora maincór áñḍḍi ókkol lói edde hárr ḍóilla hoñsara loi furaiya. ");
INSERT INTO rhgc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Héndilla tuáñra re yó, maincé baár ttu saité forhésgar deké, montor tuáñrar bútore munaféki edde kuhame furaiya. ");
INSERT INTO rhgc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ó munafék alem ókkol edde Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh nobi ókkol or hobor ore banaituló, aar forhésgar manúc ókkol or hobor ore háñzo. ");
INSERT INTO rhgc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aar tuáñra hoó de, ‘Zodi añára añárar bafdada ókkol or októt tákitam, nobi ókkol ore kún gorí bolla añára ítarar fúañti córik no óitam.’ ");
INSERT INTO rhgc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Héengori tuáñra nize nizor baabute gobá dó de, tuáñra óilade nobi ókkol ore kún goijjíl de ítarar fuain. ");
INSERT INTO rhgc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yala zoo, tuáñrar bafdada ókkole ziín cúru goijjíl, tuáñra híin furussat gorífelogoi. ");
INSERT INTO rhgc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ó háf or fuain háf ókkol! Tuáñra zuzuk or hókum ottu keéngori háriba? ");
INSERT INTO rhgc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hétolla, fúno, Añí tuáñrar hañse nobi, giyani manúc, edde alem ókkol difeṛáir; tuáñra héntu hodún ore kún goríba edde kúruc ot díba, aar hodún ore tuáñrar mujilíc-hána ókkol ot coóñk maribá edde cóore-cóore loraibá. ");
INSERT INTO rhgc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hétolla duniyait zedún behosúr manúc ore kún gorá gíyeh, ítara beggún or zimmadar óiba de tuáñra, behosúr Abel or lou wóttu lóti Berekaiyos or fua Zakaríyahr lou foijjonto, zibá re tuáñra kurbani-gáñr edde baitul-mukaddos or mazémaijja kún goijjíla. ");
INSERT INTO rhgc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Añí tuáñra re sóiyi hoóir, híin beggún or zimmadar óibo de e nosól. ");
INSERT INTO rhgc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerúsalem, ó Jerúsalem, tui zee niki nobi ókkol ore kotól gorós edde zetará re tor héṛe difeṛá gíyeh ítara re cíl or dola maros. Kuúñri-kurá ye zendilla nizor sóo ókkol ore yíbar fak or bútore zoma gorí raké, héndilla tor fuain dore zoma gorí rakí bolla Añí hotó bar saiyí de asé, montor tuáñra híyan nó soó. ");
INSERT INTO rhgc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Fúno, tuáñrar gór tuáñrar suk or muúntu sáragor óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kiyólla-hoilé Añí tuáñra re hoóir, tuáñra Añré otókkal ar no dekíba zetókkal tuáñra nó hoó de, ‘Mubarek Ubá zibá Mabud or name aiyér.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Isá baitul-mukaddos ottu neeli zaargói, héñtte Íbar cárit tun Íbar hañse aiccé, Íba re baitul-mukaddos or billíng ókkol dahái bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Íba ye ítara re zuwabe hoór de, “Tuáñra iín beggún dekór né? Añí tuáñra re sóiyi hoóir, eṛé eggwá fattór or uore ar eggwá fattór no tákibo, híin fottí ekgwá re félaidiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Isá Zaitun Faár or uore boiṛá accíl de októt, cárit tune Íbar hañse aiddone aái hoór de, “Añára re hoóna, híin hoñtté óibo dé? Tuñí aibár edde duniyai ahéri óibar alamot kii óibo?” ");
INSERT INTO rhgc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isá ye ítara re zuwabe hoór de, “Saiyó, honókiye zen tuáñra re gollot ot no loiza. ");
INSERT INTO rhgc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kiyólla-hoilé boóut zone Añr name aái hoibó de, ‘Añí óilam de Mosih,’ ítara boóut zon ore gollot ot loizaybói. ");
INSERT INTO rhgc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tuáñra laráir abas edde laráir hóbora-hóbori ókkol fúniba; hóboroddar, no ḍooraibá, kiyólla-hoilé híin ówar zorur, montor híyala yó ahérot óibo de no. ");
INSERT INTO rhgc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ek koume arek koum or ulḍa edde ek raijjo ye arek raijjor ulḍa tíyaibo, aar zaga-zaga raṭ ókkol edde búsal ókkol óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lekin híin beggún óilde siríf, fua hálas óibar cúrur duk ókkol or ḍóilla. ");
INSERT INTO rhgc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Héñtte maincé tuáñra re tokolif di bolla dóridibo, aar tuáñra re marifélaibo; Añr lla bouli tuáñra re tamám koum ókkole nafórot goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Héñtte boóut zon iman ottu fissá maribó; ítara ezzon ore ezzone dóridibo, edde ezzon ore ezzone nafórot goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aar boóut misá nobi ókkol uṛí, boóut zon ore gollot ot loizaybói. ");
INSERT INTO rhgc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bedini ókkol barízayboi de hétolla, beec maincór muhábbot homi zayboi. ");
INSERT INTO rhgc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Montor zee niki ahéri foijjonto bordac gorí tákibo, íte beh nejat faibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aar tamám koum ókkol or hañse gobá ó fán asmani raijjor kúchóbor fura duniyait tobolik gorá zaybo, tói baade beh ahérot aibó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ḍániyel nobir duara hoóil de hé bicí hótara jiníc ziyáne nafak goré,híyan ore zeñtté tuáñra pak zagat tíyaiya dekíba—foróya ye buzó— ");
INSERT INTO rhgc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","héñtte zetará Yohúdiyat tákiba, ítara ttu faár ot dáizagoi foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Zee niki gór or sád or uore asé, ítar ttu nizor gór or bútottu kessú looi bolla lamat no lama foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aar zee niki kétit asé, ítar ttu nizor saddor looi bolla waafes nu aá foribó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Montor hé din ókkol ot hámil mayafuain dor lla edde dud or maa ókkol olla bicí afsús or hálot óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dua goró, zeéne tuáñra ttu cítkhale yáh ebaadot-or-din dáizagoi no fore. ");
INSERT INTO rhgc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kiyólla-hoilé héñtte ettór ḍoóñr mosibot óibo, zendilla duniyair foidayecir héñtte lóti aijjó óiye de nái, aar abar no yó óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Zodi hé din híin homaidiya no zayto, tóoile honókiye no basitó; montor Allar basíloiya bonda ókkol olla bóuli din híin homaidiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Héñtte zodi honókiye tuáñra re eén hoó, ‘Soó, Mosih eṛé asé!’ yáto ‘Uṛé asé!’ híyan ekin no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kiyólla-hoilé misá Mosih ókkol edde misá nobi ókkol uṛíbo, aar ítara ḍoóñr-ḍoóñr illayi-nicán ókkol edde taajuippa harhána ókkol daháibo, maincóre gollot ot loizai bolla, farilé Allar basíloiya bonda re úddwa. ");
INSERT INTO rhgc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Saiyó, Añí tuáñra re age lóti hoóidiyi. ");
INSERT INTO rhgc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hétolla zodi maincé tuáñra re eén hoó, ‘Soó, Íba moidan zagat asé!’ tuáñra baáre no neeillo, aar zodi eén hoó, ‘Soó, Íba bútor or kamárat asé!’ híyan ekin no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kiyólla-hoilé zendilla fuk ottu bijili somkilé fosím foijjonto foór óizagoi, Manúc or Fuar aá yó héndilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mora lac zeṛé, héṛe toh hóun ókkol zoma óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Montor hé din ókkol or mosibot fúrai mottor beil andár óizayboi, aar sane foór no dibo; asman ottu tara ókkol forizaybói, aar asmani jiníc ókkol tóttoraibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Héñtte asman ot Manúc or Fuar nicán dahá zaybo, hé októt duniyair tamám háandan ókkole ferecani zahér goríbo, aar ítara dekíbo de, Manúc or Fua kudurut edde ḍoóñr mohímar sáañte asman or miyúlar uottú aiyér. ");
INSERT INTO rhgc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aar Íba ye eggwá ḍoóñr cíañr abas diyabai Nizor fírista ókkol difeṛáibo, aar ítara duniyair ek matá ttu arek matá foijjonto zai sairómikka ttu Íbar basíloiya bonda ókkol ore ekkán ot zoma goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ḍuñir-gas ottu meésal loo: zeñtté ḍuñir-gas or ḍéeila hórot ói fata neele, tuáñra zanizogói de, hóran ḍáke. ");
INSERT INTO rhgc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Héndilla tuáñra yó, zeñtté iín beggún dekíba, héñtte buzíba de, Manúc or Fua ḍáke, ebbe dorozat. ");
INSERT INTO rhgc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Añí tuáñra re sóiyi hoóir, iín beggún fura nó óiyo foijjonto e nosól bilkúl no fúraibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Asman zobin toh zari no tákibo, montor Añr hotá hámica zari tákibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lekin hé din edde októ aibár baabute honókiye no zane, asman or fírista ókkole yó no zane, aar Fua ye yó no zane, siríf Bafe beh zane. ");
INSERT INTO rhgc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Manúc or Fua aibár októt undilla óibo zendilla nobi Nuhr din ókkol ot óoil. ");
INSERT INTO rhgc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Zendilla hé din ókkol ot tuwán óibar age, zetódin Nuh kicṭit nó uṛé hétodin foijjonto manúc ókkole háafiya gorát, biyá gorát edde, biyá diyat accíl, ");
INSERT INTO rhgc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aar tuwán aái ítara beggún ore bácai nó loiza foijjonto ítara kessú hoi nó fare, Manúc or Fua aibó de híyala yó héndilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Héñtte dui zon manúc bil ot óibo de tákibo; ítara ttu ezzon ore loiza zaybo, ar ezzon ore bad diya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duwá mayafua ye ekku fúañti sakki gúraibo de tákibo; ítara ttu ezzon ore loiza zaybo, ar ezzon ore bad diya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hétolla seton táko, kiyólla-hoilé tuáñra toh no zano tuáñrar Malik hon din aibó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lekin yián zanilo de ki, zodi gór or giróse sur raitta hotúnot aibó de zanitó, tóoile yóggwa seton tákito aar nizor gór ore báñgito no dito. ");
INSERT INTO rhgc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hétolla tuáñra yó toiyar táko, kiyólla-hoilé Manúc or Fua tuáñra no ṭáaro de októt beh aibó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Tóoile eén biccácdar edde buddíman goóur hon asé, zaré ítar giróse nizor gór or oinno goóur ókkol or uore zimmadar banaiyé, ítara re ṭaim or uore hána dii bolla? ");
INSERT INTO rhgc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mubarek goóur ubá zaré nizor giróse waafes ailé ham híin gorér de lootfa. ");
INSERT INTO rhgc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Añí tuáñra re sóiyi hoóir, yóggwa ye nizor tamám cómbottir uore ítare zimmadar banaibó. ");
INSERT INTO rhgc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lekin zodi hé goóur gwá hóraf ó, aar nizor dile-dile endilla hoó, ‘Añr girós aité boóut deri asé,’ ");
INSERT INTO rhgc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aar íte sáañti goóur ókkol ore marat dore edde nicákur ókkol or fúañti háafiya goré, ");
INSERT INTO rhgc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tóoile hé goóur gwar girós eén din ot aibó, ze din íte yóggwa aibó de no ṭáare, edde eén októt aibó, ze októt íte hoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tói yóggwa ye ítare haṛi hán-hán gorífelaibo edde munafék ókkol or héṛe cámil goríbo; héṛe hañdahaṛi edde date dat kirkirani óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Hé októt asmani raijjo undilla doc zon abiyáta mayafuain dor ḍóilla óibo, zetará nizor-nizor serak looi dulá llói milto neeillé. ");
INSERT INTO rhgc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ítarar bútore fañs zon accíl bekuf, aar fañs zon accíl salák. ");
INSERT INTO rhgc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bekuf fúne ítarar serak loigiyé, lekin fúañti battí tel nó loiza; ");
INSERT INTO rhgc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","montor salák kúne ítarar serak or fúañti foṛot gori battí tel loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Dulá aité zettót deri ór, ítara beggún zúri-zúri gúm ot forigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Adá raitta héṛe eggwá uzor fúna gíyeh de, ‘Soó, dulá aiyér; íba llói milto neelo.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Hétunot abiyáta mayafuain ítara beggún uṛí nizor-nizor serak nal gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bekuf fúne salák kún ore hoór de, ‘Tuáñra ttu añára re kessú tel doóna, kiyólla-hoilé añárar serak nifízargoi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Salák kúne zuwab der de, ‘Tel asé de híin lói añára lla edde tuáñra lla no kulaitó fare. Yárbodol zai besoya ókkol ottu tuáñra lla kini anógoi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Baade zeñtté ítara tel kinto giiyégoi, dulá foóñiccegai; tói zetará nal ói accíl, ítara íbar fúañti boirat or melat góilloi; aar duwar gán bañdífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Hotukkún baade abiyáta mayafuain uitará yó aiccé, aar hoór de, ‘Malik, ó Malik, añára lla duwar gán kúlona.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Montor íba ye zuwabe hoór de, ‘Añí tuáñra re sóiyi hoóir, añí tuáñra re no siní.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Hétolla seton táko, kiyólla-hoilé tuáñra toh hé din yáh októ no zano. ");
INSERT INTO rhgc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kiyólla-hoilé asmani raijjo toh ezzon sofór ot zaar de manúc or ḍóilla, zibá ye nizor goóur ókkol ore matai nizor cómbotti beggún ítara re gosáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yóggwa ye ítarar kabiliyot mozin, ítara ezzon ore fañs ázar ṭiañ diiyé, ar ezzon ore dui ázar ṭiañ diiyé, edde ar ezzon ore ek ázar ṭiañ diiyé. Baade yóggwa nizor sofór ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Zee niki fañs ázar ṭiañ faiyé, íte toratori zai híin lói códori gorí aró fañs ázar hamaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Héndilla zee niki dui ázar faiyé, íte yó híin lói aró dui ázar hamaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Montor zee niki ek ázar faiyé, íte zai yore meṛit gañt kurí ítar malik or hé ṭiañ lukai eijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Boóut din baade goóur gún or malik aái yore ítara ttu ísaf lowat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Zee niki fañs ázar ṭiañ faáil, íte aró fañs ázar aní hoór de, ‘Malik, tuñí añré fañs ázar diíla. Soó, añí aró fañs ázar ṭiañ hamaiyí.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Tói malike ítare hoór de, ‘Cabác, gom edde biccácdar goóur! Tui hom jiníc ot imandari daháiyos, hétolla añí toré bicí siz or uore zimmadar banaiyúm. Ai, tor malik or kúcit cámil ógai.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Héndilla zee niki dui ázar ṭiañ faáil, íte yó aái hoór de, ‘Malik, tuñí añré dui ázar ṭiañ diíla. Soó, añí aró dui ázar ṭiañ hamaiyí.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Tói malike ítare hoór de, ‘Cabác, tui gom edde biccácdar goóur! Tui hom jiníc ot imandari daháiyos, hétolla añí toré bicí siz or uore zimmadar banaiyúm. Ai, tor malik or kúcit cámil ógai.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tarfore zee niki ek ázar ṭiañ faáil, íte aái hoór de, ‘Malik, añí zani de tuñí hora manúc; tuñí toh zeṛé nó lago héntu haṛo, aar zeṛé bis nó cíñṛo héntu dola goró. ");
INSERT INTO rhgc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hétolla añí ḍoore zai yore tuáñr ṭiañ iín meṛir bútore lukai eijjílam. Soó, ótiya tuáñr ṭiañ.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ítar malike ítare zuwabe hoór de, ‘Tui hóraf edde alcíya goóur! Tui toh zainti, añí zeṛé nó lagai héntu haṛi deh, aar zeṛé bis nó cíñṛi héntu dola gorí deh. ");
INSERT INTO rhgc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tóoile tor ttu añr ṭiañ gún benggót óile rakón accíl, tói añí aái yore añr ṭiañ gún cúṭ or fúañti waafes faitam.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Tuáñra itar ttu ṭiañ gún loifélai, zar ttu niki doc ázar ṭiañ asé ítare diifélo. ");
INSERT INTO rhgc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kiyólla-hoilé zar ttu asé, yóggwa re aró diiya zaybo, aar yóggwa ttu ódorbaára tákibo; montor zar ttu nái, yóggwa ttu asé de híin úddwa loiféla zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yala e behazor goóur itaré baáre andár ot félai dogói; héṛe hañdahaṛi edde date dat kirkirani óibo. ");
INSERT INTO rhgc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Zeñtté Manúc or Fua Íbar mohímaye aibó aar fírista beggún Íbar fúañti óibo, héñtte Íba Nizor mohímar toktót boibó. ");
INSERT INTO rhgc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tamám koum ókkol ore Íbar muúntu zoma gorá zaybo; aar Íba ye manúc beggún ore dui dol goríbo, zendilla sóol soroya ye sóol ottu bérasóol ore alok gorífele. ");
INSERT INTO rhgc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Íba ye bérasóol lun ore Íbar den ḍáikka goríbo, montor sóol lun ore ban ḍáikka. ");
INSERT INTO rhgc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Baade Baáñcca ye Íbar den ḍák or gún ore hoibó de, ‘Aiyó, Añr Baf or rahámot faiya manúc ókkol, tuáñra raijjo miras loogái, ziyán duniyair foidayecir héñtte lóti tuáñra lla toiyar raká gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kiyólla-hoilé Añí búka accílam, tuáñra Añré hána diíla; Añí tiráci accílam, tuáñra Añré faní diíla; Añí forbáci accílam, tuáñra Añré zaga diíla; ");
INSERT INTO rhgc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Añí biyossor accílam, tuáñra Añré hoor diíla; Añí biyaraimma accílam, tuáñra Añré kérmos goijjíla; Añí ziyól ot accílam, tuáñra añré saitó aiccíla.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hétunot hé forhésgar gúne Íba re zuwabe hoibó de, ‘Malik, añára hoñtté Tuáñre búka dekí hána diiyí deh, yáto tiráci dekí faní diiyí dé? ");
INSERT INTO rhgc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Añára hoñtté tuáñre forbáci dekí zaga diiyí deh, yáto biyossor dekí hoor diiyí dé? ");
INSERT INTO rhgc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Añára hoñtté Tuáñre biyaraimma dekí kérmos goijjí deh, yáto ziyól ot dekí saitó giiyí dé?’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Hétunot Baáñcca ye ítara re zuwabe hoibó de, ‘Añí tuáñra re sóiyi hoóir, tuáñra Añr e báiboináin dor bútottu ebbe niróc ezzon ore úddwa ziyán goijjíla, híyan Añré beh goijjó.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Baade Íba ye Íbar ban ḍák or gún ore hoibó de, ‘Ó laánoitta manúc ókkol, tuáñra Añr héntu dur ói ofúrani ooin ot zoogói, ziín Ibilíc edde ítar fírista ókkol olla toiyar gorá gíyeh; ");
INSERT INTO rhgc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kiyólla-hoilé Añí búka accílam, montor tuáñra toh Añré hána nó doo; Añí tiráci accílam, montor tuáñra Añré faní nó doo; ");
INSERT INTO rhgc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Añí forbáci accílam, montor tuáñra Añré zaga nó doo; biyossor accílam, montor tuáñra Añré hoor nó doo; biyaraimma accílam edde ziyól ot accílam, montor tuáñra Añré saásita nó goró.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hétunot ítara yó Íba re zuwabe hoibó de, ‘Malik, añára hoñtté Tuáñre búka, tiráci, forbáci, biyossor, biyaraimma yáh ziyól ot dekí hédmot nó gorí dé?’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Íba ye ítara re zuwabe hoibó de, ‘Añí tuáñra re sóiyi hoóir, tuáñra Añr e báiboináin dor bútottu ebbe niróc cwa re úddwa ziyán nó goró, híyan Añré beh nó goró.’ ");
INSERT INTO rhgc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ítara ofúrani sáñza fai bolla zaibo, montor forhésgar gún ofúrani zindigit gólibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zeñtté Isá ttu hotá híin beggún hoiyá óiye, Íba ye Nizor cárit tun ore hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tuáñra toh zano, dui din baade Azadir-id óibo, aar Manúc or Fua re kúruc ot dí bolla dóridiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hé októt ḍoóñr imam ókkol edde manúc or murubbi ókkol, Káiyafas hoó de boro imam or mohól ot zoma óiye; ");
INSERT INTO rhgc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","aar mili sólla goijjé de, Isá re zuitégori dórifelai zane marifélai bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Montor ítara hoór de, “Id or októt no, manúc or bútore úrussul óitofare.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Isá zeñtté Betániyat máze kurus biyaraimma Sáimon or gór ot accíl, ");
INSERT INTO rhgc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","héṛe eggwá mayafua ye fúañti fattór or háñrit góri bicí moóngga añtor looi Íbar hañse aiccé, aar Isá hána háito boiccé de októt híba ye añtor gún Isár matát ḍálidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cárit tun ottu híyan dekí gom nó lage, aar hoór de, “Iín borbad kiyá diféler? ");
INSERT INTO rhgc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","E añtor gún de boóut ṭiañ di besi gorif ókkol ore diifélai faitto.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Montor Isá ye híyan zani fari ítara re hoór de, “Tuáñra mayafua wa re ferecan kiyá gorór? Ibáh ye Añr bálai éna goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gorib ókkol toh tuáñrar fúañti nitti asé,montor Añré tuáñra nitti no faiba. ");
INSERT INTO rhgc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ibáh ye Añr gaat añtor ḍálidiye de híyan óilde ibáh ye Añré dohón olla toiyar gorí bolla goijjé deh. ");
INSERT INTO rhgc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hétolla Añí tuáñra re sóiyi hoóir, fura duniyait zeṛé-zeṛé e kúchóbor tobolik gorá zaybo, e mayafua wa ye ziyán goijjé híyan ore yó ibáhr yadgari ísafe héṛe-héṛe howá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hétunot baró zon cárit tun ottu ezzon, zar nam niki Yohúdah Iskáriyet, íte ḍoóñr imam ókkol or héṛe giiyé, ");
INSERT INTO rhgc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aar hoór de, “Zodi Isá re tuáñrar át ot dóridi, tuáñra añré kii diiba?” Baade ítara ítare tiríc cwa rufar ṭiañ goni diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hé októt lóti íte Isá re dóridi bolla moukar talac ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Cúṭar-sára Ruṭir-id or foóila din, cárit tune Isár hañse aái fusár gorér de, “Tuáñr ttu hondilla monehoór, Tuñí hái faro fán añára Tuáñr lla Azadir-id or hánar toiyari hoṛé goittám?” ");
INSERT INTO rhgc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Íba ye hoór de, “Tuáñra cóor ot fólonar héṛe zoo,” yóggwa re hoibá de, “Ustate hoór de, ‘Añr októ ḍáke; Añí Añr cárit tun or fúañti tuáñr gór ot Azadir-id goríyum.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tói cárit tune Isá ye ítara re hókum díye de mozin gorí, Azadir-id or hánar toiyari goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Baade zeñtté háñz óiye, Isá baró zon cárit tun or fúañti hána háito boiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ítara háar de októt Íba ye hoór de, “Añí tuáñra re sóiyi hoóir, tuáñra ttu ezzone Añré dóridibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hétunot ítara bicí ferecan ói zonfoti Íba ttu fusár gorér de, “Malik, íte bilkúl añí no de no né?” ");
INSERT INTO rhgc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Íba ye ítara re zuwabe hoór de, “Zee Añr fúañti hoddát át ḍáler, íte óilde zee niki Añré dóridibo. ");
INSERT INTO rhgc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Manúc or Fua toh Íbar baabute zendilla leikká asé héndilla éna zaar; montor afsús manúc uitar uore zar duara Manúc or Fua dóra háibo. Manúc íte toh zormo no óito bóuli ítar lla gom accíl.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hétunot Yohúdah, zee niki Íba re dóridibo íte hoór de, “Rabbí, íte honó añí né?” Isá ye ítare hoór de, “Tui nize híyan hoóifelayos.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ítara háar de októt, Isá ye ruṭi looi Alla re cúkuriya goijjíl, aar báñgi cárit tun ore dii hoór de, “Looi hóo; yián Añr gaa.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tarfore Íba ye fiyala looi Alla re cúkuriya goijjíl, aar ítara re dii hoór de, “Tuáñra beggúne entú hóo; ");
INSERT INTO rhgc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kiyólla-hoilé iín óilde noya razinama lla Añr lou, ziín ore boóut kiyé guná maf fai bolla ḍálidiyum. ");
INSERT INTO rhgc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Añí tuáñra re hoóir, ehón ottu lóti e anggur or roc iín Añí ar na háiyum, otódin zetódin foijjonto tuáñrar fúañti Añr Baf or raijjot noya gori ná hái.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yárbaade ítara eggwá seér gaái, neeli Zaitun Faár ot giiyói. ");
INSERT INTO rhgc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tarfore Isá ye ítara re hoór de, “Aijja raitta Añr zoriya tuáñra beggún or dil ot cóok aibó aar dáibagoi; kiyólla-hoilé pak-kalam ot toh endilla asé, ‘Añí sóol soroya re marifélaiyum, tói zák or sóol beggún cíñṛaciñṭṭá óizayboi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lekin Añré zinda gorá zay baade, Añí tuáñrar age Galil ot zaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Fitore Íba re zuwabe hoór de, “Tuáñr zoriya beggúne iman ottu zailé yo, añí honódin no zaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isá ye íba re hoór de, “Añí toré sóiyi hoóir, aijja raitta ratakurá bak dibar age, tui Añré tin bar inkar goríbi.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Fitore Íba re hoór de, “Zodi añr ttu Tuáñr fúañti mora fore yó, añí Tuáñre inkar no goijjúm.” Héndilla cárit beggúne hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yárbaade Isá ítara re looi ekkán zagat giiyé, ziyán ore Getsámani hoó. Baade Íba ye cárit tun ore hoór de, “Añí woóñt zai dua goijjúmboi, tuáñra iñyót boói táko.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Íba ye fúañti Fitor ore edde Zebedair fua duní wa re loigiyé, aar héṛe Íba ttu ocánti edde bicí ferecan lagat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hétunot Íba ye ítara re hoór de, “Bicí ocántiye Añr foran neelizaytói sár. Tuáñra iñyót táki Añr fúañti seton táko.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Baade Íba héntu ekkágori muúmmikka zai, uúiñtoi fori dua gorér de, “Ó Añr Baf, zodi ói faille, e duk-mosibot or fiyala yibá Añr ttu dur óuk; montor toóu Añr moncá mozin no, bólke Tuáñr moncá mozin óuk.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Baade Íba cárit tun or héṛe aái ítara re gúm ot loot faiyé. Íba ye Fitor ore hoór de, “Tuáñra Añr fúañti ek gónḍa úddwa seton táki no faroór dé? ");
INSERT INTO rhgc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Seton táko aar dua goró, zeéne entán ot no foro; becók ruh ttu monehoór, montor jisím komzur deh.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Íba ye dusárabar zai endilla dua gorér, “Ó Añr Baf, Añí na háile zodi e fiyala yibá Añr ttu dur no, tóoile Tuáñr moncá fura óuk.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Íba aái ítara re abar gúm ot loot faiyé, kiyólla-hoilé ítarar suk gúme bór óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Íba ye ítara re abar erizai ekí ḍóilla hotá hoói tisárabar dua goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baade Íba cárit tun or héṛe aái ítara re hoór de, “Tuáñra aijjó gúm ot edde aram gorát asó dé? Soó, októ aáigiyoi, Manúc or Fua re gunágar ókkol or át ot dóridiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Uṛó, zaigói. Soó, Añré dóridoya ḍáke foóñiccegai.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Íba ye híin hoór de októt, Yohúdah foóñiccegai, zee niki baró zon cárit tun ottu ezzon. Ítar fúañti ḍoóñr ek dol manúc toluwar edde laṛí-cúṛa looi aiccé, zetará re difeṛáiye de óilde ḍoóñr imam ókkole edde manúc or murubbi ókkole. ");
INSERT INTO rhgc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zee niki Íba re dóri dér, íte tará re endilla hoói ekkán nicán díyl, “Añí zibá re appá diyum, manúc Íba; Íba re gereftar gorífelaiyo.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yohúdah éhon Isár íñyot aái hoór de, “Rabbí, assalamu alaikum!” Héen hoói Íba re appá díye. ");
INSERT INTO rhgc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isá ye ítare hoór de, “Douós, tui ziyán olla aiccós híyan gor.” Éhon ítara aái Isá re dóri gereftar gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hétunot Isár fúañti accíl de ítara ttu ezzone nizor toluwar neelaiye, aar híyan solai boro imam or gulam or han haṛifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Isá ye íba re hoór de, “Tor toluwar ḍaf ot gólai er; kiyólla-hoilé zetará oinno zon or uore toluwar sola, ítara beggún toluware beh moribó. ");
INSERT INTO rhgc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tui ki no zanos, zodi Añí Añr Baf ore aros gorí Íba ye Añré éhon-éhon ázar-ázar fírista ókkol fóous or ḍóilla góri difeṛáibo dé? ");
INSERT INTO rhgc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lekin héen óile, endilla ówa foribó hoiyé de pak-kalam or hé hotá keéngori fura óibo?” ");
INSERT INTO rhgc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hé októt Isá ye manúc or dol lwá re hoór de, “Tuáñra ḍahañit dóitto aiccó fángori toluwar edde laṛí-cúṛa lói Añré gereftar goittó neeilló dé? Añí toh fottí din baitul-mukaddos ot boói taalim ditam, aar héñtte de Añré gereftar nó goró. ");
INSERT INTO rhgc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lekin iín beggún etollá óiye, zeéne nobi ókkole leikké de pak-kalam or hotá híin fura óizagoi.” Hétunot cárit beggúne Íba re eri dái giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zetará Isá re gereftar goijjé ítara Íba re boro imam Káiyafas or hañse loigiyói, zeṛé alem ókkol edde murubbi ókkol zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Fitor duré-duré tái Íbar fisé-fisé boro imam or uṛán or héddur foijjonto giiyé, aar kii-kii ó sai bolla bútore góli faáradar ókkol or fúañti boói táikke. ");
INSERT INTO rhgc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ḍoóñr imam ókkole edde fótuayi-mujilíc ṭíya ye Isár ulḍa misá gobá tuwat accíl, zeéne ítara Íba re zane marifélai fare. ");
INSERT INTO rhgc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Boóut zone misá gobá díto muúmmikka ailé yo, toóu háṛe de héndilla honó gobá nó faa. Lekin fore dui zon manúc muúmmikka aiccé, ");
INSERT INTO rhgc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aar hoór de, “E manúc cwa ye hoiyé de, ‘Añí Allar baitul-mukaddos báñgifelai, híyan tin din or bútore abar banaidi faijjum.’” ");
INSERT INTO rhgc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hétunot boro imame tíyai Isá re hoór de, “Tuñí honó zuwab no diba? Manúc itará Tuáñr ulḍa iín kii gobá dér?” ");
INSERT INTO rhgc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Montor Isá nizám mári táikkil. Boro imame Íba re hoór de, “Tuñí añára re zinda Allar hosóm hái hoó sái, Tuñí Allar Fua Mosih de ói ne?” ");
INSERT INTO rhgc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isá ye yóggwa re hoór de, “Tuñí nize toh híyan hoóifelaiyo. Toóu Añí tuáñra re hoóir, yarbaade tuáñra dekíba, Manúc or Fua Alla Tálar den ḍák ottu boiṛá asé edde asman or miyúlar uore góri aiyér.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hétunot boro imame nizor gair or hoor fáṛi hoór de, “Ibá ye kuféri goijjé! Añára ttu ar kii gobá lager dé? Tuáñra toh ehón Ibár kuféri fúinno; ");
INSERT INTO rhgc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","tuáñrar rai kii?” Ítara zuwabe hoór de, “Ibá moot or laayek!” ");
INSERT INTO rhgc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Baade ítara Íbar muk ot sép maijjé edde Íba re gúca maijjé; ar hodúne Íba re suwar mari ");
INSERT INTO rhgc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hoór de, “Héy Mosih, añára re antas gorí hoósai, Toré hone maijjé?” ");
INSERT INTO rhgc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Héñtte Fitor baáre uṛán ot boiṛá accíl, aar eggwá bañdi mayafua aái íba re hoór de, “Tuñí yó toh Galil or Isár fúañti accíla!” ");
INSERT INTO rhgc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Montor íba ye ítara beggún or muúntu endilla hoói inkar gorídiye, “Tuñí kiyór baabute hoór añí no zani.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Zeñtté íba baáre baanḍat giiyé, ar eggwá bañdi mayafua ye íba re dekí, héṛe asé de ítara re hoór de, “E manúc cwa Isá Nasárir fúañti accíl.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Montor íba ye hosóm hái endilla hoói abar inkar gorídiye, “Añí manúc Íba re no siní.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hotún baade ḍake tíyai asé de manúc cúne aái Fitor ore hoór de, “Sóiyi tuñí yó tarár bútottu ekzon; kiyólla-hoilé tuáñr zobane úddwa tuáñre dóra dér.” ");
INSERT INTO rhgc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hétunot Fitore hosóm hái hoór de, “Añr uore laánot óuk zodi añí misá hotá hoóir de óile; añí manúc Íba re no siní!” Baade éhon-éhon ratakurá bak diyé. ");
INSERT INTO rhgc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Hétunot Fitor ottu Isá ye hoóil de hotá monot uiṭṭé, ki hoilé, “Ratakurá bak dibar age tui Añré tin bar inkar goríbi.” Baade íba baáre neeligói kúb hañdat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Zeñtté biínna óiye, ḍoóñr imam ókkol edde manúc or murubbi beggúne mili sólla goijjé de, Isá re zane marifélai bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Baade ítara Íba re bañdí loizai hákim Filat ore gosáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zeñtté Yohúdah, zee niki Isá re dóridiye, íte deikké de Íba lla moot or hókum óiye, hétunot íte bicí afsús hái tiríc cwa rufar foicá gún ḍoóñr imam ókkol ore edde murubbi ókkol ore fíraidi ");
INSERT INTO rhgc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","hoór de, “Añí behosúr manúc cwa re marifélai bolla dóridi guná goijjí.” Montor ítara hoór de, “Tóoile añárar kii óiye? Híyan tui buzós.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hétunot íte rufar foicá gún baitul-mukaddos or bútore melámari giiyégoi, aar zai nizoré nize fáñci háifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ḍoóñr imam ókkole rufar foicá gún looi hoór de, “Iín baitul-mukaddos or baccút rakón zayes no, kiyólla-hoilé iín lou wór dam.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Baade ítara biyasana gorí, bidecóitta ókkol olla hoborostán banai bolla hé rufar foicá gún lói Kuáñijjar Zobin nán kinné. ");
INSERT INTO rhgc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hétolla hé zaga gán ore aij foijjonto Lou wor Zaga hoói ḍake. ");
INSERT INTO rhgc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Híyane, nobi Yarmíyahr duara howá gíyl de yián fura óiye, “Ítara hé tiríc cwa rufar foicá gún loiyé, híin óilde Ubár dam, zibár dor Boni Isráil ókkole ṭík goijjíl; ");
INSERT INTO rhgc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aar ítara híin ore Kuáñijjar Zobin nán kinat estemal goijjé, zendilla Mabude añré hókum díye.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isá hákim Filat or muúntu tíyai accíl, hákime Íba ttu fusár gorér de, “Tuñí Yohúdi ókkol or Baáñcca níki?” Isá ye yóggwa re hoór de, “Ói, tuñí hoór de héndilla.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Montor ḍoóñr imam múne edde murubbi gúne Íba re elzam lagat accíl de októt, Íba ye honó zuwab nó déh. ");
INSERT INTO rhgc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hétunot Filate Íba re hoór de, “Tuñí no fúnor níki itará Tuáñr ulḍa hodún gobá dér?” ");
INSERT INTO rhgc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Montor Íba ye yóggwa re ekkán elzam or úddwa zuwab nó de, hétolla hákim ebbe taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hákim or niyom óilde, fottí Azadir-id or októt maincé ze hodi re hálas gorídito hoó hé hodi re hálas gorídon. ");
INSERT INTO rhgc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hé októt ítara ttu ézzon nam hóraf mocúr hodi accíl, zar nam Bárabba. ");
INSERT INTO rhgc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hétolla, zeñtté manúc ókkol zoma óiye, Filate ítara ttu fusár gorér de, “Tuáñra ttu añré haré tuáñrar hañse hálas gorídiya baitó monehoór, Bárabba re né, náki Isá re, zibá re Mosih hoó?” ");
INSERT INTO rhgc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kiyólla-hoilé Filate zainto de, Yohúdir neta ókkole Isá re yóggwar hañse hásorot góri gosáidiye deh. ");
INSERT INTO rhgc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Filat bisar or toktór uore boói accíl de októt, yóggwar bou wé yóggwar hañse hóbor foóñsaiye de, “Hé behosúr Manúc cwa re kessú no goríyo, kiyólla-hoilé gel de raitta añí cóppon ot Íbar zoriya bicí duk faiyí.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lekin ḍoóñr imam ókkole edde murubbi ókkole manúc or dol ore uskaidiyé de, Bárabba re magi bolla aar Isá re marifélaito hoi bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hákime abar ítara re hoór de, “E duní zon ottu tuáñra ttu añré haré hálas gorídiya baitó monehoór?” Ítara hoór de, “Bárabba re.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Filate ítara re hoór de, “Tóoile Isá, zibá re Mosih hoó, Íba re añí kii goittám?” Ítara beggúne hoór de, “Íba re kúruc ot dífelo!” ");
INSERT INTO rhgc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Montor yóggwa ye hoór de, “Kiyá, Íba ye kii bura goijjé dé?” Toóu ítara aró guzori-guzori endilla howát accíl, “Íba re kúruc ot dífelo!” ");
INSERT INTO rhgc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Baade Filate dekér de, yóggwa ye kessú gorí no farer, bólke úrussul cúru óizargoi, hétunot yóggwa ye faní looi manúc ókkol or muúntu nizor át dúifelai hoór de, “E Manúc cwar lou wór zimma añí no; híyan or zuwab tuáñra beh diba.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hétunot manúc beggúne zuwabe hoór de, “Íbar lou wór zimma añára edde añárar fuain óiyum!” ");
INSERT INTO rhgc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tói yóggwa ye ítarar hañse Bárabba re hálas gorídiye; montor Isá re coóñk marabai baade, kúruc ot dí bolla gosái dífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Baade hákim or fóous ókkole Isá re yóggwar mohól or bútore loigiyé, aar ṭeérang ṭíya re Íbar sairókul ttu zoma goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ítara Íbar gair or hoor kúlifelai Íba re eggwá lal rong or zubba fiñdáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ítara keñṛar eggwá tas banai baade Íbar matát diyaidiyé, aar den át ot eggwá laṛí dóradiye. Ítara Íbar muúntu añṛúr tók dí Íba re ṭátṭai gorí hoór de, “Héy Yohúdi ókkol or Baáñcca, Toré sólam!” ");
INSERT INTO rhgc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Baade ítara Íba re sép maijjé edde laṛí wa looi Íbar matá sái bari maijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ítara Íba re ṭátṭai gorí baade, Íba ttu lal rong or zubba wa kúlifelai Íbar hoor Íba re fiñdáidiye; baade kúruc ot dí bolla loigiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ítara cóor ottu baáre neeler de októt, Kureni cóor or ezzon manúc loot faiyé zibár nam Sáimon; ítara yóggwa re Isár kúruc can boói loizai bolla mojbur goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Baade ítara zeñtté Golgota nam or ekkán zagat, yáni Matár Malar Zagat foóñicce, ");
INSERT INTO rhgc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ítara Íba re tita jiníc miyáiya anggur or roc háito diiyé; montor Íba ye híin hái saái ná háa. ");
INSERT INTO rhgc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ítara Íba re kúruc ot dífelai baade, loṭári mari ítarar bútore Íbar hoorsuor ore bák goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aar héṛe boói táki ítara Íba re sooñi gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Íbar matár uottú ítara Íbar e hosúri gán sáainbúṭ maridiye, ziyán óilde, “Ibá óilde Isá, Yohúdi ókkol or baáñcca.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hé októt Íbar fúañti dui zon ḍahañit ore yó kúruc ot díyl, ezzon ore Íbar den ḍák ottu edde ar ezzon ore Íbar ban ḍák ottu. ");
INSERT INTO rhgc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aar zetará hé foñt báy zaar, ítara matá lari-lari Íba re técerai ");
INSERT INTO rhgc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hoór de, “Tui toh baitul-mukaddos báñgi tin din or bútore abar banaidoya, yala Tui Nizoré Nize basa sái! Zodi Tui Allar Fua de óile, kúruc ottu lami ai.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Héndilla góri ḍoóñr imam, alem edde murubbi ókkole yó ṭátṭai gorí hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ibá ye toh oinno zon ore basaitó; montor Nizoré Nize de basai no farer! Ibá Isráil or Baáñcca no né, yala Ibá kúruc ottu lami aiyóuk, baade añára Ibár uore iman aníyum. ");
INSERT INTO rhgc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ibá ye Allar uore bóraca raké; zodi Alla ttu monehoó, tóoile ehón Alla ye Ibá re basouk, kiyólla-hoilé Ibá ye hoitó de, ‘Añí óilam de Allar Fua.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ze ḍahañit tun ore Íbar fúañti kúruc ot díyl, ítara yó héndilla-héndilla hotá hoói Íba re beizzoti goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hé din duúñijjar baró wa báze lóti tin nwá báze fán guñṛa mulluk andár ói accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tin nwá ánik baijjé de októt, Isá ye eggwá ḍoóñr abase guzori hoór de, “Elí, Elí, lamá sabakhṭáni?” yáni, “Ó Añr Alla, ó Añr Alla, Tuñí Añré kiyólla sáridiyo?” ");
INSERT INTO rhgc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Héṛe tíyai accíl de ítara hodúne híyan fúni hoór de, “E Manúc cwa ye nobi Eliyas ore ḍaker.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ítara ttu ezzone ekkú duñre zai ekkán esfónj looi sírkat buraiyé, aar ekkán súañr matát bazáidi Isá re hái bolla diiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Montor argúne hoór de, “Tíyo, Ibá re Eliyase basaitó aiyé né saái.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Isá ye abar eggwá ḍoóñr abase guzori Íbar foran difélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hétunot baitul-mukaddos or foroda gán uottú lóti nise foijjonto fáṛi dui bák óigiyoi; aar zobin ot búsal baiyé, ḍoóñr-ḍoóñr cíl ókkol fáṛigiyoi, ");
INSERT INTO rhgc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","hobor ókkol kúligiyoi, edde Allar pak bonda ókkol zetará moot or gúm ot accíl ítara boóut zon ore zinda gorá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Isá mora ttu zinda ói baade, ítara hobor ottu neeli aáigiyoi aar pak cóor ot zai boóut maincóre dahádiye. ");
INSERT INTO rhgc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Romi cáap edde yóggwar fúañti zetará Isá re faára díyat accíl, ítara zettót búsal edde aró kii-kii ór de híin deikké, ítara bicí ḍooraigiyói aar hoór de, “Sóiyi Ibá Allar Fua accíl!” ");
INSERT INTO rhgc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Boóut beṛiyáin zetará Galil ottu lóti Isár fisá dori Íba re hédmot gorí-gorí aiccíl, ítara dur ottu góri híin saái táikkil. ");
INSERT INTO rhgc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ítarar bútore Moriyam Makdálini accíl, Yakub edde Yusúf or maa Moriyam accíl, edde Zebedair fuain dor maa accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Háñzinna óiye rár, héṛe Aramátiya cóor ottu Yusúf nam or ezzon tuangor manúc aiccé, zibá nize yó Isár éggwa ummot óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yóggwa ye Filat or hañse zai Isár lac cwa maiggé. Hétunot Filate hókum díye de, lac cwa yóggwa re diiféla zay bolla. ");
INSERT INTO rhgc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusúfe lac cwa looi, ekkán sáf hohón or hoor ot beráiye, ");
INSERT INTO rhgc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aar nizor noya hobor ot raikkégoi, zibá re yóggwa ye cíl kúñdi banaáil. Baade hobor or muk ot ekkán ḍoóñr cíl ouzaydi, giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Héñtte Moriyam Makdálini edde arek Moriyam héṛe hobor or muúntu boiṛá accíl. ");
INSERT INTO rhgc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tarfor din, zibá ebaadot-or-din accíl, ḍoóñr imam ókkol edde Féroci ókkol Filat or hañse zoma óiye, ");
INSERT INTO rhgc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","baade ítara hoór de, “Jonáb, añára ttu monot asé, hé dúkabaz Íba zinda tákite hoóil de, ‘Tin din baade Añí abar zinda óiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hétolla tin din foijjonto hobor gwá re horagori faára díya zay bolla hókum dóh; arnóile Íbar ummot ókkole aái Íbar lac cwa sur gorí loizai maincóre hoibó de, ‘Íba mora ttu zinda óigiyoi,’ tói fisór dúka agor dúkar túaro hóraf óibo.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Filate ítara re hoór de, “Faáradar ókkol loizo, zai zeddúr horagori faro héddur gorí hobor gwá re faára dógoi.” ");
INSERT INTO rhgc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Baade ítara zai cíl lan ot moór lagai edde faáradar ókkol héṛe rakí, hobor gwá re horagori faáradiye. ");
INSERT INTO rhgc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ebaadot-or-din baade, háftar foóila din fózor októt, Moriyam Makdálini ye edde arek Moriyame hobor gwá saitó giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Asimbit héṛe eggwá ḍoóñr búsal óiye, kiyólla-hoilé Mabud or ek fírista asman ottu laimmé, aar hobor gwat aái yíbar muk ot accíl de cíl lan larifélai híyan or uore boiccé. ");
INSERT INTO rhgc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Íbar súrot accíl bijilir ḍóilla, aar íbar hoor accíl borók or ḍóilla dóla. ");
INSERT INTO rhgc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Faáradar gúne íba re ḍoorai hafi uiṭṭíl aar mora manúc or ḍóilla óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Fírista wa ye beṛiyáin nún ore hoór de, “No ḍooraiyó, kiyólla-hoilé añí zani tuáñra Isá re tuwoór deh, zibá re kúruc ot dí mariféla gíyl. ");
INSERT INTO rhgc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Íba eṛé nái; Íba zinda óigiyoi, zendilla Íba ye hoóil. Aiyó, Íba re raikkíl de zaga gán soógai. ");
INSERT INTO rhgc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Yala toratori zoo, Íbar cárit tun ore hoibá de, ‘Íba mora ttu zinda óigiyoi, aar Íba tuáñrar age Galil ot zaar. Héṛe tuáñra Íba re dekíba!’ Soó, añí tuáñra re hoóidiyi.” ");
INSERT INTO rhgc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tói beṛiyáin ítara toratori hobor ottu giiyégoi; ítara ḍooraáil, toóu bicí kúci óoil, aar Isár cárit tun ore hóbor dí bolla duñri-duñri giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Atíkka Isá ítara llói millé. Íba ye hoór de, “Sólam!” Hétunot ítara Íbar hañse giiyé aar Íbar foot dóri Íba re sóida goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Isá ye ítara re hoór de, “No ḍooraiyó, zoo, Añr báiyain ókkol ore Galil ot zaito hoógoi; ítara héṛe Añré dekíbo.” ");
INSERT INTO rhgc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Beṛiyáin ítara foñt ot tákite, hodún faáradare cóor ot aái, ziín-ziín óiye híin beggún ḍoóñr imam ókkol ore zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aar ḍoóñr imam ókkole murubbi-neta ókkol lói dola ói ekkán sólla-mocuwara gorí, fóous sun ore boóut ṭiañ diiyé, ");
INSERT INTO rhgc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aar hoiyé de, “Tuáñra hoibá de, ‘Añára raitta gúm ot accílam de októt, Íbar ummot ókkol aái Íba re sur gorí loigiyégoi.’ ");
INSERT INTO rhgc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Zodi hotá yián hákim or han ot foóñse, one añára yóggwa re buzái tuáñra re hótara ttu basaiyúm.” ");
INSERT INTO rhgc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tói hé fóous suné ṭiañ gún looi, ítara re cíkaidiye de héndilla goijjé. E kaháni yián Yohúdi ókkol or bútore aij foijjonto bicígori fólaiya. ");
INSERT INTO rhgc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tarfore egaro zon cárit tun Galil or oh faár gwat giiyé, zibát zaito Isá ye ítara re hoóil. ");
INSERT INTO rhgc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ítara Íba re dekí sóida goijjíl; montor hodún ottu cóok laiggíl. ");
INSERT INTO rhgc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hétunot Isá ye ítarar hañse aái hoór de, “Asman or edde zobin or tamám kémota Añré diiféla giyéh. ");
INSERT INTO rhgc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hétolla zoo, tamám koum ókkol ore Añr ummot banogoi; ítara re Baf or, Fuar edde Pak-Ruhr name bápṭisma díyo, ");
INSERT INTO rhgc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","aar Añí tuáñra re zedún hókum díyi, híin beggún amól gorí bolla ítara re taalim diyo. Aar soó, duniyair ahéri foijjonto Añí hámica tuáñrar fúañti-fúañti así.” Aamin.");
INSERT INTO rhgc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yián óilde Allar Fua Isá Mosihr baabute kúchóbor, ");
INSERT INTO rhgc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","zendilla nobi Yesáyahr kitab ot leikká asé: “Soó, Añí Añr hóborgwa re Tuáñr age difeṛáir, zibá ye Tuáñr foñt toiyar goríbo.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Moidan zagat ezzone guzori-guzori eén hoór, ‘Mabud or foñt toiyar goró; Íbar rasta uzu goró.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bápṭismadoya Yaháya aái moidan zagat tobolik goittó de, gunár maf fai bolla touwá gorí bápṭisma loito. ");
INSERT INTO rhgc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Fura Yohúdiya elakar manúc beggún edde Jerúsalem or tamám bácinda ókkol neeli yóggwar hañse giiyé, aar nizor-nizor guná ókkol cíkar gorí Jordán hál ot yóggwa ttu bápṭisma loiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yaháya ye uñṭ or keñc loi banaiya hoor fiñdíto, aar yóggwar keeñil ot samarar duali baindá tákito. Yóggwa ye háito de óilde fíring edde zooñl or modú. ");
INSERT INTO rhgc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yóggwa ye endilla tobolik goittó, “Añí baade eén Ekzon aiyér, zibár tokka añr túaro ḍoóñr. Añí niyúri Íbar cenṭár or fíta kúli bolla úddwa laayek no. ");
INSERT INTO rhgc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Añí de tuáñra re fanít éna bápṭisma dír, montor Íba ye tuáñra re Pak-Ruh lói bápṭisma díbo.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hé din ókkol ot eén óiye, Isá Galil or fara Nasárat ottu aái yore Jordán hál ot Yaháya ttu bápṭisma loiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Isá faní ttu kul ot uiṭṭégai mottor, Íba ye dekér de, asman kúlizargoi aar Pak-Ruh hoitor or ḍóilla ói Íbar uore lamer. ");
INSERT INTO rhgc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aar héñtte asman ottu eggwá abas aiccé de, “Tuñí Añr adorja Fua, Tuáñre lói Añí bicí kúci.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Éhon or bútore Pak-Ruh ye Íba re moidan zagat difeṛáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aar héṛe moidan zagat Íba re Cóitane salic din foijjonto entán gorát accíl. Íba jonggoli januwar ókkol or fúañti tákito, aar fírista ókkole Íba re hédmot goittó. ");
INSERT INTO rhgc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yaháya re ziyól ot dí baade, Isá Galil ot aái Allar kúchóbor tobolik gorát doijje, ");
INSERT INTO rhgc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","endilla hoói, “Októ óiye, Allar raijjo ḍáke aáigiyoi. Touwá goró edde kúchóbor ore ekin goró.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Isá Galil Ḍiír hañsa báy zaar de októt, Íba ye Sáimon ore edde íbar bái Enderiyas ore deikké. Héñtte ítara ḍiít zal marer, kiyólla-hoilé ítara zailla accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isá ye ítara re hoór de, “Añr fisáli doro, Añí tuáñra re manúc dóre de zailla banaiyúm.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ítara éhon or bútore ítarar zal lun eri, Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Híyan ttu ekkágori giiyé rár, Íba ye Zebedair fua Yakub ore edde yóggwar bái Yohánna re deikké, zetará noowr uore zal ṭuner. ");
INSERT INTO rhgc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Íba ye ítara re éhon mataiyé, tói hétunot ítara nizor baf Zebedaire noow ot muzur ókkol or fúañti eri, Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tarfore ítara Kaparnahúm ot giiyé, aar ebaadot-or-din aiccé rár Isá toratori mujilíc-hánat zai taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Manúc ókkol Íbar taalime ammúk óizaytoi, kiyólla-hoilé Íba ye ítara re taalim dito de ezzon adíkar olar ḍóilla góri, alem ókkol or ḍóilla góri no. ");
INSERT INTO rhgc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Héṛe ítarar mujilíc-hánat ezzon hóraf jine-faiya manúc accíl. Yóggwa ye guzori hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ó Isá Nasári, añára llói Tuáñr kii ham asé? Tuñí añára re dónco goittó aiccó de né? Añí zani Tuñí hon, Tuñí óilade Allar Pakzon nwá.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Montor Isá ye jin nwá re jéjjeṛai hoór de, “Nizám ó, yoggwár bútottu neelizagói.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tói hé hóraf jine yóggwa re musori eggwá ḍoóñr guzoran mari yóggwar bútottu neeligiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Híyane manúc beggún eén taajup óigiyoi, ítara ezzon ore ezzone hoór de, “Yián kii? Yián toh ekkán noya taalim! Íba ye adíkare hóraf jin ókkol ore úddwa hókum déh aar híine Íbar hotá mane!” ");
INSERT INTO rhgc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Éhon or bútore Íbar hóbor Galil or sairó ḍák or elaka beggún ot fóligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yárbaade ítara mujilíc-hána ttu neeli mottor, Yakub edde Yohánnar fúañti Sáimon edde Enderiyas or gór ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Héñtte Sáimon or hóuri gaatzore bisánat fori accíl. Ítara éhon Isá re yóggwar baabute zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Íba yóggwar ḍáke aái yóggwa re át ot dóri tuillíl, tói yóggwa ttu gaatzor giiyégoi, baade yóggwa ye ítara re meémandari gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Háñzinna beil góli baade, maincé Íbar hañse biyaraimma beggún ore edde búte-faiya manúc ókkol ore ainníl. ");
INSERT INTO rhgc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aar guñṛa cóor or manúc duwar or gurat zoma óoil. ");
INSERT INTO rhgc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isá ye boóut biyaraimma ókkol gom goijjé zetará ḍoilla-boḍoilla biyarame duk faat accíl, edde boóut bút ókkol dáfaiye; montor Íba ye bút ókkol ore matitó no dito, kiyólla-hoilé híine Íba hon de siníto. ");
INSERT INTO rhgc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Baade biínna kúb sóore andár tákite, Isá uṛí gór ottu neeli ekkán bocóti-sára zagat giiyé, aar héṛe dua goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sáimon edde yóggwar sáañti ókkole Íba re tuwaitó neeillé. ");
INSERT INTO rhgc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ítara Íba re tuwai fai hoór de, “Beggúne Tuáñr talac gorér.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Íba ye ítara re hoór de, “Aiyó, añára atehañsór honó ekkán farat zai, zeéne héṛe yó Añí tobolik gorí fari, kiyólla-hoilé Añí hétolla beh neeillí.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tói Íba Galil or agagura zai-zai ítarar mujilíc-hána ókkol ot tobolik gorát accíl edde bút ókkol dáfat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ezzon kurus biyaraimma Isár hañse aái sóida gorí Íba re fóriyat gorér de, “Tuñí sailé añré pak-sáf gorí faribá.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isá ttu feṭfuri Nizor át barái yóggwa re dóijje, aar hoór de, “Añí saái; pak-sáf óizogoi.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tói éhon or bútore yóggwa ttu kurus biyaram giiyégoi, aar yóggwa pak-sáf óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Baade Isá ye yóggwa re dorógori nicót gorí éhon-éhon duñraidiyé, ");
INSERT INTO rhgc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","yóggwa re hoiyé de, “Saiyó, honókiyo re kessú no zanaiyó; bólke zoo, nizoré imam or hañse dahógoi, aar tuñí pak-sáf óiyo de híyan maincór hañse gobá ó fan, Muúsa ye hókum díye de hé kurbani dogói.” ");
INSERT INTO rhgc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lekin yóggwa baáre zaigói kúlamela góri zanai-zanai agagura hé hóbor fólat doijje, eddúr zeén níki Isá honó cóor or bútore ar kúlamela góri góli nó fare, bólke ekkán bocóti-sára zagat zai táka foijjé. Toóu agagura ttu manúc ókkol Íbar héṛe aitó. ");
INSERT INTO rhgc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hooddin baade zeñtté Isá Kaparnahúm ot waafes aiccé, fúna gíyeh de, Íba gór ot asé. ");
INSERT INTO rhgc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Baade héṛe edún manúc zoma óigiyoi, gór gán guñṛa bóri duwar or ḍáke úddwa ar zaga nu accíl. Aar Isá ítarar hañse kalam tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hé októt héṛe hodún manúc aiccé, fúañti ítara ek añtur manúc ore sair zon or áta boói Íbar hañse ainné. ");
INSERT INTO rhgc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Aar zeñtté ítara manúc or zam olla bóuli Íbar íñyot zai no farer, hétunot ítara Íbar uzu-uzu uottú sád or ṭali larifélaiye, aar hana gorífelai baade, añtur manúc cwa neiṭṭa asé de bisána wa lamaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isá ye ítarar iman dekí añtur manúc cwa re hoór de, “O fut, tor guná maf gorídiya gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Héṛe hoozzon alem boiṛá accíl, ítara dile-dile báfer de, ");
INSERT INTO rhgc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“E Manúc cwa ye endilla hotá kiyá hoór? Ibá ye toh kuféri gorér! Siríf Alla bade guná maf gorífaroya hon asé?” ");
INSERT INTO rhgc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Éhon or bútore Isá ye Nizor ruht zani faijjé de, ítara dile-dile héndilla báfer. Hétolla Íba ye ítara re hoór de, “Tuáñra dile-dile híin kiyá báfor? ");
INSERT INTO rhgc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","E añtur manúc cwa re hoité hon nán aásan, ki ‘Tor guná maf gorídiya gíyeh,’ aar náki, ‘Uṭ, tor bisána tulí looi áñṭ?’ ");
INSERT INTO rhgc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lekin Añr ttu tuáñra re yián zanaidito monehoór, e duniyait guná maf goríbar kémota Manúc or Fua ttu asé.” Tói Íba ye añtur manúc cwa re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Añí toré hoóir, uṭ, tor bisána tulí looi gór ot zaagói.” ");
INSERT INTO rhgc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hétunot yóggwa uiṭṭé, aar toratori bisána wa tulí looi ítara beggún or muúntu baárkule giiyégoi. Híyane ítara beggún taajup ói Allar taarif gorát doijje, eén hoói, “Añára endilla harbar honódin nó dekí!” ");
INSERT INTO rhgc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isá abar baáre neeli ḍiír hañsat giiyé; aar manúc beggún Íbar hañse aiccé rár, Íba ye ítara re taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Íba zaite-zaite dekér de, Alfáiyas or fua Leévi házana tulé de gór ot boói táikke. Íba ye yóggwa re hoór de, “Añr fisáli doro.” Hétunot yóggwa uṛí Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yárbaade eén óiye, Isá zeñtté Leévir gór ot hána háar, boóut zon házana-tulóya edde gunágar ókkol óu Isá edde Íbar ummot ókkol or fúañti háito boiccé, kiyólla-hoilé Íbar fisá dori accíl de boóut zon accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Férocir alem ókkole Íba re házana-tulóya edde gunágar or fúañti hána háar de dekí, Íbar ummot ókkol ore hoór de, “Ibá ye házana-tulóya edde gunágar ókkol or fúañti kiyá hána háa?” ");
INSERT INTO rhgc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Híyan fúni Isá ye ítara re hoór de, “Araimma ókkol ottu toh ḍakṭor no lage, montor biyaraimma ókkol ottu beh lage. Añí dawot dito aiccí de forhésgar ókkol ore no, bólke gunágar ókkol ore.” ");
INSERT INTO rhgc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ekbar, Yaháyar cárit ókkole edde Féroci ókkole ruza raikké, ítara aái Isá re hoór de, “Yaháyar ummot ókkole edde Férocir cárit ókkole toh ruza raké, montor Tuáñr ummot ókkole kiyá ruza no raké?” ");
INSERT INTO rhgc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isá ye ítara re hoór de, “Dulá fúañti tákite kí boiraitta ókkole ruza rakí fare? Zetó din dulá ítarar fúañti táke, hétodin toh ítara ruza rakí no fare. ");
INSERT INTO rhgc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Montor eén din aibó, zeñtté dulá re ítarar hañsóttu loiféla zaybo, one héñtte ítara ruza rakíbo. ");
INSERT INTO rhgc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Honókiye toh furan fucák ot noya hoor tali dede nái, zodi dilé toh héntu noya gán zórizayboi, aar fáṛa híyan aró ḍoóñr óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Héndilla, honókiye noya anggur or roc ore furan samarar hóillat raké de nái; zodi rakíle toh noya roc cúne hóilla gún fáṛifelaibo, tói roc óu borbad zayboi aar hóilla gún óu borbad zayboi. Hétolla, noya anggur or roc ore noya samarar hóillat raká fore.” ");
INSERT INTO rhgc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ekbar eén óiye, ebaadot-or-din Isá giyuñr kuñṛá báy zaar, zaite-zaite Íbar ummot ókkole giyuñr túr ókkol tulát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Féroci ókkole Íba re hoór de, “Soó, ebaadot-or-din ziyán goríbar maná, itará híyan kiyá gorér?” ");
INSERT INTO rhgc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Montor Íba ye ítara re hoór de, “Tuáñra kí yián honódin nó foró, zeñtté Dawud edde íbar sáañti ókkol ottu zorurot óiye edde búk laiggíl, héñtte íba ye kii goijjíl de? ");
INSERT INTO rhgc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Íba ye toh boro imam Abiyótar októt Allar gór ot góillegoi, aar Allar hañse peec goijjá ruṭi háail, ziín siríf imam ókkole bade ar honókiye háibar ezazot nái. Íba ye híin nizor sáañti ókkol ore yó diíl.” ");
INSERT INTO rhgc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tarfore Isá ye ítara re hoór de, “Ebaadot-or-din banaiyé de óilde manúc olla, manúc ore ebaadot-or-din olla banaiyé de no. ");
INSERT INTO rhgc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hé ísafe Manúc or Fua ebaadot-or-din or óu Malik.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Isá aró ekbar mujilíc-hánat góille; aar héṛe ézzon endilla manúc accíl, zar át fúaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ítara Íba ye ebaadot-or-din yóggwa re gom goré né háas nozor di saái táikke, zeéne ítara Íba re hosúr dí fare. ");
INSERT INTO rhgc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Íba ye át fúana manúc cwa re hoór de, “Uṛí eṛé muúntu aiyó.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Baade Íba ye ítara re hoór de, “Ebaadot-or-din gom ham goríbar zayes asé né náki hóraf goríbar? Foran basaibár né náki marifélaibar?” Montor ítara nizám mári táikkil. ");
INSERT INTO rhgc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Íba ye sairómikka ítarar uzu guccár sáañte saái, ítarar dil dorór zoriya bicí duk lagi manúc cwa re hoór de, “Tuáñr át tan baró.” Tói yóggwa ye híyan baráiye, hétunot yóggwar át tan agor ḍóilla gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hétunot Féroci ítara baáre zai Hérudiól lói sólla gorát doijjegoi de, ítara Íba re kii bote marifélai faribó. ");
INSERT INTO rhgc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Montor Isá ye Nizor cárit tun ore fúañti looi ḍiír hañsat giiyégoi. Ḍoóñr ek dol manúc Íbar fisá doijjil; ítara aiccé de óilde Galil ottu, Yohúdiya ttu, ");
INSERT INTO rhgc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerúsalem ottu, Idumaya ttu, Jordán hál or farkul ottu, Ṭayár edde Sídon cóor or sairó ḍák or elaka ttu. Ítara Isá ye goittó de hárr kessú fúni beh Íbar héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Manúc or dol lwár zoriya Íba ye Nizor cárit tun ore hoiyé de, Íba lla ekkán gura noow zuu gorí rakíto, zeéne maincé Íba re sibasippa no goré. ");
INSERT INTO rhgc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kiyólla-hoilé Íba ye boóut maincóre gom goijjíl de hétolla, biyaraimma ókkol beggúne Íba re súi bolla ṭélaṭeli goittó. ");
INSERT INTO rhgc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aar hóraf Jin ókkole zeñtté Íba re dekíto, Íbar muúntu meṛit fori guzori hoitó de, “Tuñí óilade Allar Fua.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Montor Íba hon de híyan honókiyo re zahér no gorí bolla Íba ye ítara re horagori nicót goittó. ");
INSERT INTO rhgc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yárbaade Isá faár or uore uiṭṭégoi, baade Nizor ttu zaré-zaré monehoiyé taré-taré mataiyé, aar ítara Íbar héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Íba ye baró zon ore basíloiye, zeéne ítara Íbar fúañti-fúañti táke, aar zeéne ítara re tobolik goittó difeṛái fare, ");
INSERT INTO rhgc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","edde ítara ttu bút dáfaibar kémota táke. ");
INSERT INTO rhgc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hé baró zon ítara óilde: Sáimon zaré Íba ye Fitor nam diyé; ");
INSERT INTO rhgc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedair fua Yakub, aar yóggwar bái Yohánna. Íba ye ítarar nam diyé de Bowanergis, maáni óilde, “Ṭáṛal or Fuain”; ");
INSERT INTO rhgc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Enderiyas, Filíp, Bartólomiyo, Moti, Tómas, Alfáiyas or fua Yakub, Táadiyas, Sáimon, zibá óilde Zélot, ");
INSERT INTO rhgc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","edde Yohúdah Iskáriyet, zee niki Isá re dóridil. ");
INSERT INTO rhgc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Baade Isá ek gór ot góille, aar ebar óu edún manúc zoma óiye, zeén níki Íba edde Íbar cárit tune hána úddwa hái nó fare. ");
INSERT INTO rhgc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Zeñtté Íbar gór or maincé híyan fúinne, ítara Íba re dóri loianí bolla neeillé; kiyólla-hoilé ítara hoór de, “Íbar matá hóraf óigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ze alem ókkol Jerúsalem ottu nise aiccé, ítara hoór de, “Ibá re Belzebule faiyé. Ibá ye bút dáfa de bút ókkol or sóddar or taakote.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hétolla Isá ye ítara re matai ekkán meésal dí hoór de, “Cóitane keéngori Cóitan dáfai fare? ");
INSERT INTO rhgc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Zodi honó raijjot faáṭa-faáṭi foida ó, híyan toh ṭiki táki no fare. ");
INSERT INTO rhgc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aar zodi honó gór ot faáṭa-faáṭi foida ó, híyan óu ṭiki táki no fare. ");
INSERT INTO rhgc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Héndilla, zodi Cóitane nizor ulḍa nize ói faáṭ-faáṭ óizagoi, íte toh ṭiki táki faribár nái, bólke íte hótom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Honókiye boluwar manúc or gór ot góli yóggwar cómbotti luṭ gorí no fare, zodi age boluwar manúc yóggwa re bañdí no ere. Bañdí erilé éna yóggwar gór luṭ gorí faribó. ");
INSERT INTO rhgc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Añí tuáñra re sóiyi hoóir, adomzat or tamám guná edde ítara goré de kuféri ókkol maf gorídiya zaybo, ");
INSERT INTO rhgc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","montor zee niki Pak-Ruhr ulḍa kuféri goré, íte bilkúl maf no faibo, bólke abadulabadi gunár hosúrbon ṭóoribo.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Isá ye hotá híin kiyólla hoiyé hoilé, alem ókkole hoiyé de, “Íba re hóraf jine faiyé.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yárbaade héṛe Isár maa edde báiyain aiccé, aar baáre tíyai táki Íba re mataitó difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Íbar sairókul ttu ek dol manúc boiṛá accíl; ítara Íba re hoór de, “Soó, Tuáñr maa edde báiyain baáre Tuáñr talac gorér.” ");
INSERT INTO rhgc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Íba ye zuwabe ítara re hoór de, “Añr maa hon? Aar Añr báiyain hontará?” ");
INSERT INTO rhgc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Baade Íba ye zetará Íbar sairókul ttu boiṛá asé, ítarar uzu saái hoór de, “Ótiya, Añr maa edde Añr báiyain. ");
INSERT INTO rhgc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kiyólla-hoilé zee niki Allar moncá mozin sole, yóggwa óilde Añr bái, bóin, aar maa.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Isá abar ḍiír hañsat taalim diyat doijje. Íbar héṛe manúc or ettór dol zoma óiye, zeén níki Íba ḍiít asé de ekkán noow ot uṛí boiccé; aar manúc cún beggún ḍiír kul or uore. ");
INSERT INTO rhgc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Íba ye ítara re meésal ókkol dí boóut kessú cíkat doijje. Íba ye taalim ot ítara re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Fúno, ezzon bis cíñṛoya bis cíñṭṭo neeillé. ");
INSERT INTO rhgc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yóggwa ye cíñṛer de októt, hodún bis rastarhañsat foijjíl, aar faik ókkole aái híin háifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hodún bis cíl zobin ot foijjíl, zeṛé bicí meṛi nái. Mur meṛi nu accíl ísafe híin ot hára ges aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Montor beil uiṭṭé rár híin furigiyói, aar cíñyor nó gasá ísafe híin fúaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hodún bis keñṛabon ot foijjíl, keñṛabon barí uṛí híin ore sibi raikké ísafe híin ot fósol nó dóre. ");
INSERT INTO rhgc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lekin ar hodún bis gom zobin ot foijjíl, híin barí uṛí ḍoóñr ói fósol dóijjil: kessút tiríc gun, kessút háiṭ gun, ar kessút ek cót gun.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tarfore Isá ye ítara re hoór de, “Zar ttu fúnibar han asé, yóggwa ye fúno.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Zeñtté Isá gaaga óigiyoi, Íbar sairókul or manúc cúne edde baró zon cárit tune Íba ttu meésal lun or baabute fusár goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Íba ye ítara re hoór de, “Allar raijjor gufoni re zainto tuáñra re beh diya giyéh; montor baárgwa maincóre meésal dí etollá howá zah, ");
INSERT INTO rhgc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","zeéne, ‘Ítara saité saibó montor no dekíbo, fúinte fúnibo montor no buzíbo, arnóile toh ítara fíri aitó aar maf faito.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tarfore Isá ye ítara ttu fusár gorér de, “Tuáñra e meésal lan or maáni nó buzó níki? Tóoile oinno meésal lun or maáni keéngori buzíba? ");
INSERT INTO rhgc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cíñṛoya ye cíñṭṭe de híin óilde Allar kalam. ");
INSERT INTO rhgc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hodún manúc rastar hañsat foijjé de bis híin or ḍóilla; ítara kalam fúnile Cóitan toratori aái ítarar bútore cíñṛa gíyeh de kalam loizagói. ");
INSERT INTO rhgc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hodún manúc cíl zobin ot foijjé de bis híin or ḍóilla, zetará kalam fúnile mottor kúcir sáañte kobul goré, ");
INSERT INTO rhgc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","montor híin ot mozbut cíñyor nó gasá de hétolla hooddin beh ṭiki táke. Zeñtté hé kalam or zoriya mosibot yáh zulúm aiyé, ítara éhon fissá mare. ");
INSERT INTO rhgc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ar hodún manúc keñṛabon ot foijjé de bis híin or ḍóilla; ítara kalam fúne, ");
INSERT INTO rhgc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","montor duniyair sintabáfaniye, dón-doulot or adore, edde oinno jiníc ókkol or lalóse hé kalam ore sibi raké, hétolla híin ot gula no dóre. ");
INSERT INTO rhgc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ar hodún manúc gom zobin ot foijjé de bis híin or ḍóilla; ítara kalam fúne edde kobul goré, aar gula dóra: kessú ye tiríc gun, kessú ye háiṭ gun, ar kessú ye ek cót gun.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Isá ye ítara re hoór de, “Serak ki báñir yáh falong or tole rakí bolla ané de né? Serak boiṛónir uore rakí bolla no né? ");
INSERT INTO rhgc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kiyólla-hoilé endilla luki asé de kessú nái ziín zahér no óibo, aar endilla lukai eijja honó kessú nái ziín kúlahala no óibo. ");
INSERT INTO rhgc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zodi honókiyo ttu fúnibar han táke, yóggwa ye fúno.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Íba ye ítara re yián óu hoiyé, “Tuáñra ziín fúnor híin or uzu díyan dóh. Tuáñra ze mafe diiba, tuáñra re yó hé mafe diiya zaybo, tuáñra re óile aró diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kiyólla-hoilé zar ttu asé yóggwa re aró diiya zaybo, montor zar ttu nái yóggwa ttu asé de híin úddwa loiféla zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isá ye aró hoór de, “Allar raijjo óilde endilla manúc or ḍóilla zee niki zobin ot bis cíñṭṭe, ");
INSERT INTO rhgc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","yóggwa raitta gúm zah aar din ot seton táke, hé bis ottu ges aái keéngori ḍoóñr óigiyoi de yóggwa nize hoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Zobine toh nizorgá nize fósol dóra: age sara, baade aga, aar agat foona fósol. ");
INSERT INTO rhgc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Zeñtté fósol fagigiyói, yóggwa ye híin toratori hañsi loi haṛat doijje, kiyólla-hoilé fósol haṛibár ainda aáigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Isá ye aró hoór de, “Añára Allar raijjo kiyór ḍóilla bóuli hoitám? Yáh kiyór meésal dí buzáitam? ");
INSERT INTO rhgc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Híyan óilde eggwá hóroir danar ḍóilla; zibá re zobin ot lagaibárcot saité zobin or tamám bis or bútore ebbe cóñṛo, ");
INSERT INTO rhgc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","toóu yíba re lagailé, yíba barí kétir gas beggún or túaro ḍoóñr ói endilla ḍoóñr-ḍoóñr ḍéeila ókkol fáṛa, zeén níki faik ókkole yíbar sábar nise bahá bañdí fare.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Héndilla boóut meésal ókkol dí Isá ye ítara buzí fare de héddur mozin Allar kalam hoitó. ");
INSERT INTO rhgc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Íba ye meésal sára ítara re hotá no hoitó; montor Nizor cárit tun ore aiddone hárr kessú buzáidito. ");
INSERT INTO rhgc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hé din háñz óiye rár, Isá ye cárit tun ore hoór de, “Aiyó, añára oh hañsat zai.” ");
INSERT INTO rhgc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Manúc or dol lwá re eri, ítara Isá ze noow ot accíl híyan ot góri Íba re fúañti loigiyé. Íbar fúañti aró noow ókkol óu giíl. ");
INSERT INTO rhgc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Asimbit héṛe eggwá ḍoóñr tuwán cúru óiye, aar eén ḍoóñr-ḍoóñr goir ókkol marat doijje, zeén níki noow gán faní lói bórizargoi. ");
INSERT INTO rhgc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Montor Isá noow or fasíl ot eggwá balúc cítan ot dí gúm ot accíl. Ítara Íba re tulídi hoór de, “Ó Ustat, añára morizayrgói de híyan ot kí Tuáñr honó díyan nái?” ");
INSERT INTO rhgc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tói Íba uṛí boiyar ore dóoñk díye, aar faní re hoór de, “Nizám ó, táma.” Hétunot boiyar bon óigiyoi, aar furafuri támaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Íba ye ítara re hoór de “Tuáñra ḍoorór kiyá? Tuáñra ttu kí aijjó iman nái?” ");
INSERT INTO rhgc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ítara bicí ḍooraigiyói aar ezzon ore ezzone hoór de, “Ibá hon? Boiyare edde faní ye úddwa de Ibár hotá mane!” ");
INSERT INTO rhgc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yárbaade ítara ḍiír okule Geraséni ókkol or mulluk ot foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zeñtté Isá noow ttu laimmé, éhon-éhon ezzon hóraf jine-faiya manúc hobor ottu neeli aái Íba llói dola óiye. ");
INSERT INTO rhgc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yóggwa tákito de óilde hobor ókkol ot; honókiye yóggwa re bañdí rakí no faitto, síyol lói úddwa no faitto. ");
INSERT INTO rhgc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yóggwa re boóut bar berí edde síyol lói bañdí raká gíyl, montor yóggwa ye síyol ókkol sírifelaito, aar berí ókkol hán-hán gorífelaito. Honókiye yóggwa re sóoñli rakí no faitto. ");
INSERT INTO rhgc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yóggwa hámica raite dine hobore-hobore edde faáre-faáre guzorat tákito, aar nizoré nize fattór lói haṛitó. ");
INSERT INTO rhgc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Zeñtté yóggwa ye Isá re dur ottu lóti deikké, duñri zai Íba re sóida goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yóggwa ye eggwá ḍoóñr abase guzori hoór de, “Ó Isá, Alla Tálar Fua, Tuáñr ttu añr llói kii ham asé? Allar wasté añré toziya no diyó.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kiyólla-hoilé Isá ye yóggwa re hoiyé de, “Héy hóraf jin, manúc cwa ttu neeliai.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Isá ye yóggwa ttu fusár gorér de, “Tor nam kii?” Yóggwa ye hoór de, “Añr nam Zák; kiyólla-hoilé añára boóut twa así.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tarfore yóggwa ye Íba re becábicí fóriyat goijjé de, híin ore hé elaka ttu duñrai no di bolla. ");
INSERT INTO rhgc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Héṛe faár or hañsat ḍoóñr ek zák cúwor sorer de accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bút tune Íba re fóriyat gorér de, “Añára re oh cúwor gún or bútore duñraido, zeéne añára híin or bútore góli fari.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Isá ye ezazot diyé rár, hóraf jin nún neeli cúwor gún or bútore góillegoi; tói zák kwa faár or haindá báy zure ḍiít duñrdiyé, aar héṛe ḍufí morigiyói. Hé zák kwat tokoriban dui ázar cúwor accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cúwor soroya gún duñrdiyé, aar cóor ot edde gang zagat híyan hóbor díye. Baade manúc ókkole kii óiye de saitó neeillé. ");
INSERT INTO rhgc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ítara Isár héṛe aiccé, aar dekér de, búte-faáil de, yáni jin or zák accíl de manúc cwa Íbar ḍáke boiṛá, hoor findá aar sóiyi úñice asé; hétunot ítara ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Zetará hé maamela gán deikké ítara búte-faáil de manúc cwar uore kii óiye de híyan manúc ítara re zanaiyé, héndilla cúwor gún or baabute yó zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Baade manúc ókkole Isá re ítarar elaka ttu zaitogói bicí aros gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Íba noow ot uṛérgoi de októt, búte-faáil de manúc cwa ye Íbar fúañti zai bolla fóriyat goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lekin Isá ye yóggwa re ezazot nó deh, bólke hoiyé de, “Tuñí tuáñr gór ot zoogói aar maincóre zanogói de, Mabude tuáñr lla hottór ḍoóñr ham goijjé, aar tuáñr uore hotó rahám goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Baade yóggwa giiyégoi, aar Isá ye yóggwa lla ze ḍoóñr ham goijjé híin Dekapólis elakat boiyan gorát doijje; híin fúnile beggúne taajup óito. ");
INSERT INTO rhgc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zeñtté Isá abar noow ot gori ḍiír oh hañsat faráiye, ḍoóñr ek dol manúc Íba re gíri zoma óiye, aar Íba ḍiír hañsat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hétunot mujilíc-hánar sóddar ézzon héṛe aiccé, zibár nam Záiras. Yóggwa ye Isá re dekí Íbar foot foijjé, ");
INSERT INTO rhgc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aar fóriyat gorér de, “Añr gura zérfua wa moron-moron óiye; meérbani góri aái Tuáñr át tan híbar uore doogái, zeéne híba gom óizagoi aar basi táke.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hétunot Isá yóggwar fúañti rowana loiyé. Ḍoóñr ek dol manúc Íbar fisá doijje aar sairókul ttu Íba re ṭélaṭeli gorér. ");
INSERT INTO rhgc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Héṛe eggwá mayafua accíl, zibá ttu kúnzari zár de baró bosór óiye. ");
INSERT INTO rhgc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Híba ye boóut ḍakṭor ókkol or hañsóttu bicí tokolif bordac goijjíl, aar nizor ttu accíl de beggún hóssa gorífelai baade yo honó fáida nó óiyo, bólke biyaram aró barígilgoi. ");
INSERT INTO rhgc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Zeñtté híba ye Isár baabute fúinne, manúc or dol lwár bútore góli Isár fisór ttu aái Íbar hoor súiye, ");
INSERT INTO rhgc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kiyólla-hoilé híba ye báippil de, “Añí siríf Íbar hoor súi faille gom óizaiyumboi.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tói éhon or bútore híbar kúnzari bon óigiyoi, aar híba biyaram ottu gom óigiyoi de híyan nizor jisím ot maásus gorí faijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aar éhon-éhon Isá ye zani faijjé de, Íba ttu kudurut neeillé. Íba ye manúc or dol or bútore sairómikka saái hoór de, “Añr hoor hone súiye?” ");
INSERT INTO rhgc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Íbar cárit tune hoór de, “Tuñí toh dekór, manúc ókkole Tuáñre ṭélaṭeli gorér de, aar Tuñí keéngori hoór de, ‘Añré hone súiye?’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lekin hé ham goijjé de híba re sai bolla Isá sairómikka saát accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Montor mayafua wa ye nizor hálot kii óiye de zani, ḍoore hafi-hafi aái Isár muúntu uúiñtoi foijjé, aar Íba re fura hákikot zanaáil. ");
INSERT INTO rhgc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Isá ye híba re hoór de, “O zíi, tor imane toré gom goijjé. Cántir sáañte zaagói, tor ttu e biyaram ar no óuk.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Íba hotá howát accíl de októt, mujilíc-hánar sóddar gwar gór ottu hoozzon manúc aái hoór de, “Tuáñr zíi zuraigiyói; Ustat ore ar kiyá ferecan gorór?” ");
INSERT INTO rhgc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Montor Isá ye ítarar hotár uzu díyan no di mujilíc-hánar sóddar gwá re hoór de, “No ḍooraiyó; siríf biccác goró.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tarfore Íba ye Fitor, Yakub, edde Yakub or bái Yohánna re bade ar honókiyo re Íbar fúañti zaito nó deh. ");
INSERT INTO rhgc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ítara zeñtté mujilíc-hánar sóddar gwar gór ot foóñicce, Íba ye dekér de, héṛe holholar, aar manúc ókkole ḍoóñr-ḍoóñr góri hañdahaṛi edde bilak gorér. ");
INSERT INTO rhgc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Íba ye bútore zai ítara re hoór de, “Tuáñra uzor edde hañdahaṛi kiyá gorór? E fua wa moijjé de no, bólke gúm zar deh.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hétunot ítara Íba re lói áñcat doijje, lekin Íba ye beggún ore neelaidi mayafuar bafmaa re edde Íbar fúañti accíl de cárit tun ore lói, fua wa asé de kamárat góille. ");
INSERT INTO rhgc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aar zérfua war át dóri híba re hoór de, “Ṭalita kum,” ziyán or torjuma óilde, “Gura futúni, Añí toré hoóir, uṭ.” ");
INSERT INTO rhgc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Éhon zérfua wa uṛí áñṛat doijje, kiyólla-hoilé híbar boc accíl baró bosór. Híyane ítara ebbe taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Íba ye ítara re horagori hókum díye de, híyan or baabute honókiyo re no zanai bolla, aar hoiyé de, háito híba re kessú dii bolla. ");
INSERT INTO rhgc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Isá héntu neeli nizor wotón ot aiccé, fúañti Íbar cárit tun óu giíl. ");
INSERT INTO rhgc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aar ebaadot-or-din aiccé rár, Íba ye mujilíc-hánat taalim diyat doijje. Íbar boiyan fúni boóut zone ammúk ói hoór de, “E Manúc cwa ye iín hontú cíkke? Ibá re diiya giyéh de híin hondilla giyan? Ibá ye gorér de híin kii keramot? ");
INSERT INTO rhgc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ibá kí mistíri no, zibá Moriyam or fua aar Yakub or, Yusúf or, Yohúdahr, edde Sáimon or bái? Ibár bóinain eṛé añárar fúañti nó ne?” Héndilla hoói ítara Íba re inkar goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hétunot Isá ye ítara re hoór de, “Ze honó nobir izzot nizor wotón ot, egana-guccít, edde nizor gór ot bade beggúlla asé.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Íba ye héṛe ar honó keramot gorí nó fare, siríf hoozzon biyaraimma re ítarar uore át dí gom gorí faijjíl deh. ");
INSERT INTO rhgc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aar ítarar nabiccácit Íba bicí taajup óigilgoi. Yárbaade Isá fara-fara zai taalim diyat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Íba ye baró zon cárit tun ore matai, dui zon dui zon gorí difeṛát doijje. Íba ye ítara re hóraf jin ókkol neelaibár kémota diíl. ");
INSERT INTO rhgc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Íba ye ítara re nosíyot gorér de, “Foñt olla laṛí bade ar kessú no loizaiyó: no ruṭi, no hóilla, no zalit gori ṭiañ. ");
INSERT INTO rhgc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cenṭár fiñdíyo, montor battí hoor no loizaiyó.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Íba ye ítara re aró hoór de, “Tuáñra ze gór ot góliba hé gór ot cóor híyan ottu neeli nó zoogói foijjonto tákiyo. ");
INSERT INTO rhgc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ze zagat tuáñra re kobul no goré yáto tuáñrar boiyan no fúne, híyan ottu zaibarcót tuáñrar ṭéng or tollar dúil zárifelaiyo, zeéne híine ítarar ulḍa gobá deh.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Baade ítara rowana loi endilla tobolik gorát doijje, touwá goró. ");
INSERT INTO rhgc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ítara boóut bút ókkol neelaiye, aar boóut zon biyaraimma re ítarar uore tel di gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Aar baáñcca Hérude Isár baabute fúinne, kiyólla-hoilé Íbar nam agagura mocúr óigilgoi. Hodúne hoór de, “Bápṭismadoya Yaháya mora ttu zinda óiye deh, hétolla toh íba ye keramoti ham híin gorí farer.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kiyé-kiyé hoór de, “Íba Eliyas.” Ar kiyé-kiyé hoór de, “Íba eggwá nobi, agor zobanar nobi ókkol or ḍóilla.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Montor Hérude híyan fúni hoór de, “Yaháya zibár holla añí haṛiféla báilam, íba mora ttu zinda óiye deh.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kiyólla-hoilé Hérud nize manúc difeṛái, nizor bái Filíp or bou Hérudias or wasté hé Yaháya re gereftar gorí ziyól ot bañdí raikkíl, kiyólla-hoilé Hérude híba re biyá gorífelail. ");
INSERT INTO rhgc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yaháya ye Hérud ore endilla hoitó de hétolla, “Tuáñr ttu nizor bái or bou wóre biyá goríbar zayes nái.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hétolla Hérudias Yaháya llói rak táigilgoi, híba ttu íba re zane marifélaito monehoitó, montor nó fare, ");
INSERT INTO rhgc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kiyólla-hoilé Hérude Yaháya re ḍooraitó, yóggwa ye zainto de, íba ézzon forhésgar edde pak manúc, aar hé ísafe yóggwa ye íba re héfazot rakíto. Yóggwa ye Yaháyar hotá fúnile bicí oulzóul ot forizaytói; toóu yóggwa ttu íbar hotá fúinte gom lagitó. ");
INSERT INTO rhgc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ahérit Hérudiase ekkán mouka faáil, zeñtté Hérude nizor zormo-din or din córkari ḍoóñr manúc ókkol, fóous or zonnal ókkol, edde Galil or ḍaiḍoóñr ókkol olla eggwá ḍoóñr hána goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hérudias or zíi nizorgá nize héṛe bútore aái, nasi yore Hérud edde yóggwar meéman ókkol ore kúci goijjé rár, baáñcca ye zérfua wa re hoór de, “Tor ttu ziyán monehoó híyan añr ttu mag, añí toré híyan diiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yóggwa ye híba re hosóm hái hoiyé de, “Tui añr ttu ziyán magos, añí toré híyan diiyum, añr raijjo ekdók óile úddwa diifélaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Baade híba neeli zai maa re hoór de, “Añí kii magitám?” Maa ye hoór de, “Bápṭismadoya Yaháyar holla wa.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Éhon híba toratori bútore baáñccar hañse aái hoór de, “Añí tuáñr ttu bápṭismadoya Yaháyar holla wa ekkán tálit góri ehón saái.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Híyan fúni baáñcca ttu bicí afsús laiggé, montor toóu nizor hosóm edde meéman nún or zoriya yóggwa ye híba re inkar goittó nó saá. ");
INSERT INTO rhgc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Baáñcca ye éhon-éhon ezzon zollat ore Yaháyar holla wa aintó hókum dí difeṛáiye. Manúc cwa ye zai, ziyól or bútore íbar holla wa haṛifelaiye, ");
INSERT INTO rhgc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","aar holla wa re ekkán tálit góri aní zérfua wa re diiyé; baade zérfua wa ye híbar maa re diiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zeñtté íbar ummot ókkole híyan fúinne, ítara aái íbar lac cwa loizai hobor ot dohón gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sáhabi gún aái Isár hañse zoma óiye, aar ítara kii-kii goijjíl edde kii-kii cíkail híin beggún Íba re zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Héñtte boóut manúc ókkol aá-zaat accíl ísafe ítara hána háito úddwa ṭaim nó faa de hétolla, Íba ye ítara re hoór de, “Tuáñra ekkán nizám zagat aái essát zirogái.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tarfore ítara noow ot gori ekkán bocóti-sára zagat giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Manúc ókkole ítara zaar de deikké, tará boóut zone ítara re siní fari tamám cóor ókkol ottu duñri-duñri héṛe giiyé, zai ítarar age héṛe foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zeñtté Isá noow ttu laimmé, Íba ye ḍoóñr ek dol manúc deikké, aar Íba ttu ítara lla feṭfuijje, kiyólla-hoilé ítara soroya sára bérasóol or ḍóilla ói accíl. Tói Íba ye ítara re boóut kessú taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zeñtté bicí háñz óigiyoi, Íbar cárit tune Íbar hañse aái hoór de, “Yián toh ekkán bocóti-sára zaga aar bicí háñz óigiyoi; ");
INSERT INTO rhgc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","tará re duñraido, zeéne tará atehañsór gang zaga ókkol ot edde fara ókkol ot zai nize hái bolla kessú kini fare.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Montor Isá ye ítara re hoór de, “Hái bolla kessú tará re tuáñra doo.” Ítara Íba re hoór de, “Tóoile añára zai dui cót dinár or ruṭi kini aní tará re hábaitam né?” ");
INSERT INTO rhgc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Montor Íba ye ítara re hoór de, “Tuáñra ttu ruṭi houwá asé? Zai soógoi.” Ítara saái baade Íba re hoór de, “Fañs swá, aar duwá mas óu asé.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Baade Íba ye ítara re, manúc cún beggún ore áil kér or uore ḍaái-ḍaái góri buágaraito hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tói tará ek cót zoinna edde fonzaic zoinna ḍaái góri-góri boiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tarfore Íba ye hé fañs swá ruṭi edde duwá mas sún looi asman or uzu saái cúkuriya goijjé, aar manúc cún ore dii bolla ruṭi gún báñgi-báñgi cárit tun ore diiyé; héndilla gorí Íba ye mas duní wa yó tará beggún ore baṛidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aar tará beggúne feṭ bóri háiye. ");
INSERT INTO rhgc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Baade ruṭir edde mas or ze tukuṛa ókkol basigiyói, cárit tune híin feñṛai looi fura baró báñir bóijje. ");
INSERT INTO rhgc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Zetará ruṭi háiye ítara óilde fañs ázar beṛaáin. ");
INSERT INTO rhgc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Éhon or bútore Isá ye Nizor cárit tun ore mojbur goijjé de, Íba ye manúc cún ore bidai gorí dite-dite ítara zeéne noow ot uṛí Íbar age okule Betsáidat zaagói. ");
INSERT INTO rhgc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Manúc cún ore bidai gorídi baade, Íba faár or uore dua goittó giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aar háñz óiye de héñtte, noow gán ḍiír mazé accíl, aar Isá háliga kul or uore. ");
INSERT INTO rhgc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Íba ye dekér de, cárit tune mockil or sáañte dar baár, kiyólla-hoilé boiyar ítarar uzan baát accíl. Fuáñitta, Íba fanír uottú áñṛi-áñṛi ítarar héṛe aiccé, aar ítara re bárai zaito saáil. ");
INSERT INTO rhgc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lekin Íba fanír uottú áñṛer de híyan cárit tune dekí, bút bóuli ṭáari guzori uiṭṭíl, ");
INSERT INTO rhgc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kiyólla-hoilé Íba re dekí ítara beggúne ḍooraáil. Montor Íba ye éhon-éhon ítara llói hotá hoiyé; ítara re hoiyé de, “Hímmot goró! Ibá Añí; no ḍooraiyó.” ");
INSERT INTO rhgc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tarfore Íba ítara asé de noow ot uiṭṭégoi, aar hétunot boiyar támaigiyoi. Híyane ítara ebbe taajup óigiyoi, ");
INSERT INTO rhgc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kiyólla-hoilé ítara ruṭir keramot tán nó buzé, bólke ítarar dil doró óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ítara ḍií farái, Genesáret elakat foóñsi noow gán bíraiye. ");
INSERT INTO rhgc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aar noow ttu laimmé mottor, maincé Isá re siní, ");
INSERT INTO rhgc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","hé elakar agagurat duñri zai biyaraimma ókkol ore bisánat góri, Íba zeṛé-zeṛé asé bóuli hóbor faiyé héṛe-héṛe anát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Íba zeṛé-zeṛé zaito, farat óuk, cóor ot óuk, yáh gang zagat óuk, héṛe maincé biyaraimma ókkol ore bazar ot aní Íba re aros goittó de, ítara re siríf Íbar fucák or hañra óile súito dí bolla; aar zetó zone súito, ítara beggún gom óizaytoi. ");
INSERT INTO rhgc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ek din Féroci ókkol edde hoozzon alem Isár hañse zoma óiye, ítara aiccé de óilde Jerúsalem ottu. ");
INSERT INTO rhgc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ítara deikké de, Isár hodún ummote nafak áte yáni adúiya áte hána háar. ");
INSERT INTO rhgc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Asóle Féroci ókkole edde tamám Yohúdi ókkole cúndorgori át no dúi hána na háa, héndilla gorí ítara agor zobanar buzurgó ókkol or rosóm dóri táke. ");
INSERT INTO rhgc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aar bazar ottu ailé nizoré no dúi honó kessú na háa. Ítara ttu aró boóut ḍoilla rosóm ókkol asé ziín ítara amól gorí bolla bouli hé buzurgó ókkol ottu faiyé, zendilla niki, fiyala dúwa, zok dúwa, edde ketúri dúwa. ");
INSERT INTO rhgc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hé Féroci edde alem múne Isá ttu fusár gorér de, “Tuáñr ummot ókkole agor zobanar buzurgó ókkol or rosóm mozin no kiyá sole, bólke nafak áte hána háa?” ");
INSERT INTO rhgc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Íba ye ítara re zuwabe hoór de, “Nobi Yesáyah ye tuáñra munafék ókkol or baabute sóiyi hotá hoiyé, zendilla leikká asé, ‘Manúc iíne Añré nizor muké beh izzot goré, montor tarár dil Añr ttu duré. ");
INSERT INTO rhgc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tará Añr ebaadot goréde behar, kiyólla-hoilé tará taalim ísafe cíka de óilde insán or niyom-kaanun ókkol.’ ");
INSERT INTO rhgc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tuáñra toh Allar hókum ore bad di, insán or rosóm ore dóri táko.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Isá ye ítara re aró hoór de, “Tuáñra toh tuáñrar rosóm amól gorí bolla Allar hókum ore bad diyat bicí salák. ");
INSERT INTO rhgc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muúsa ye hoóil de, ‘Nizor bafmaa re izzot goró,’aar ‘Zee niki baf or yáh maar bodnam goré, ítare mariféla zaybo.’ ");
INSERT INTO rhgc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lekin tuáñra hoó de, ‘Zodi honókiye baf ore yáh maa re eén hoó, ze siz loi tuáñra añr ttu laf faita híyan Korban,’ yáni, Alla re diiféla gíyeh, ");
INSERT INTO rhgc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tuáñra ítare nizor baf olla yáh maa lla ar honó kessú goittó no doh. ");
INSERT INTO rhgc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Héen gorí, tuáñra zari goijjó de rosóme Allar kalam ore baatel gorífelo; héndilla aró boóut kessú goró de asé.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Isá ye abar manúc ókkol ore Nizor hañse matai ítara re hoór de, “Beggúne Añr hotá fúno, aar buzó: ");
INSERT INTO rhgc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","baár ttu manúc or bútore góli ítare nafak gorí fare de honó kessú nái; bólke manúc or bútottu ziín neeliaiyé, ítare híine beh nafak goré. ");
INSERT INTO rhgc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Zar ttu fúnibar han asé, yóggwa ye fúno.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Baade zeñtté Isá manúc or dol eri ek gór ot góille, Íbar cárit tune Íba ttu meésal lan or maáni fusár goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hétolla Íba ye ítara re hoór de, “Tuáñra yó héndilla obuz táigiyogoi dé? Tuáñra kí no buzó, baár ttu ziín manúc or bútore góle, híine ítare nafak gorí no fare dé? ");
INSERT INTO rhgc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kiyólla-hoilé híin zaa de toh ítar dil or bútore no, bólke feṛor bútore, aar híin feikána báy neelizagói.” Héndilla hoói Isá ye hárr hána hálal bóuli hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Íba ye aró hoór de, “Ziín manúc or bútottu neeliaiyé, manúc ore híine beh nafak goré. ");
INSERT INTO rhgc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kiyólla-hoilé manúc or bútottu, yáni dil ottu éna kukíyal, zenákari, suri, kotólakotóli, ");
INSERT INTO rhgc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","oinno zon or bou loi zenákari, lalsí, burai, dúkabazi, bodmaci, ric, gifot, borái, edde bekufai aiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","E burai iín beggún bútottu neeli aái manúc ore nafak goré.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Isá uṛí hé zaga ttu Ṭayár cóor or elakat giiyé. Íba ek gór ot góillegoi, aar híyan honókiyo re zainto dito mon nu accíl; montor Íba luki táki nó fare. ");
INSERT INTO rhgc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Héṛe ek mayafua ttu hóraf jine-faiya eggwá gura zérfua accíl; híba ye Isár baabute fúni mottor aái Íbar foot foijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mayafua wa accíl ezzon Beyohúdi, híba zormo óiye de óilde Siíriya mulluk or Penicíyar elakat. Híba ye Isá re aros gorát accíl de, zérfua ttu hé bút twa neelaifélai bolla. ");
INSERT INTO rhgc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Montor Isá ye híba re hoór de, “Age fuain dore feṭ bóri háito doh, kiyólla-hoilé fuain dor hána looi kuñir or muúntu félai dón gom no.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Híba ye zuwabe hoór de, “Ói Malik, montor toóu de mes or tolor kuñire fuain dor hánar tukuṛa ókkol háa.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Isá ye híba re hoór de, “E zuwab or zoriya tuñí zaigói faribá; tuáñr zérfua ttu bút neeligiyói.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Híba gór ot waafes zai loot faiyé de, zérfua wa bisánat neiṭṭa, aar bút neeligiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tarfore Isá Ṭayár edde Sídon or elaka ttu neeli Dekapólis elakar mazór ttu Galil Ḍiít aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Héṛe maincé ezzon náfang edde túta re Íbar hañse ainné, aar Íba re fóriyat goijjé de, yóggwar uore Íbar át dito. ");
INSERT INTO rhgc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isá ye yóggwa re manúc or dol ottu ek ḍáikka loizai Íbar ooñl yóggwar duní han ot gólaidiye, aar Íbar ooñl ot sép dí yóggwar zir súiye. ");
INSERT INTO rhgc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Baade Íba ye asman or uzu saái ḍoóñr niyác félaiye, aar yóggwa re hoór de, “Effata” yáni, “Kúlizagoi.” ");
INSERT INTO rhgc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tói éhon yóggwar han nún kúligiyoi, edde zir eridiya óigiyoi, aar yóggwa sáf-sáf góri hotá howát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Híyan or baabute honókiyo re no hoitó Isá ye manúc cún ore maná goijjé; montor Íba ye zetó maná goittó, ítara héto fólat tákito. ");
INSERT INTO rhgc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ítara ebbe taajup ói hoór de, “Ibá ye ziín goijjé híin beggún gom ham goijjé. Ibá ye toh náfang ore fúnibar aar buk ore matibár toóufik dee.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hé din ókkol ot, zeñtté abar ḍoóñr ek dol manúc zoma óiye aar ítara ttu háito kessú nu accíl, Isá ye Íbar cárit tun ore matai hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Añr ttu manúc itará lla feṭfurer, kiyólla-hoilé itará Añr fúañti asé de tin din óiye aar itará ttu háito kessú nái. ");
INSERT INTO rhgc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Zodi Añí itará re gór ot waácca duñraidi, itará foñt ot matá gúrai forizaybói, kiyólla-hoilé itará ttu hodún bicí dur ottu aiccé de asé.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Íbar cárit tune zuwabe hoór de, “Montor manúc itará re feṭ bóri hábai bolla e bocóti-sára elakat hédun ruṭi hoṛé faibo?” ");
INSERT INTO rhgc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isá ye ítara ttu fusár gorér de, “Tuáñra ttu ruṭi houwá asé?” Ítara hoór de, “Háñt twa.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Íba ye manúc cún ore meṛit boitó hoiyé; baade háñt twa ruṭi gún looi Alla re cúkuriya goijjé, aar manúc cún ore dii bolla híin báñgi Nizor cárit tun ore diiyé, aar ítara manúc cún ore baṛidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ítara ttu houggwá gura mas óu accíl. Isá ye híin olla yó cúkuriya gorí yore, híin baṛidito cárit tun ore hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Manúc cúne feṭ bóri háiye, baade ze tukuṛa ókkol basi accíl híin bóijje rár ḍoóñr lai loi háñt lai óiye. ");
INSERT INTO rhgc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Héṛe sair ázar foijjonto beṛaáin accíl. Yárbaade Íba ye ítara re bidai gorídiye, ");
INSERT INTO rhgc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","aar éhon or bútore Nizor cárit tun or fúañti noow ot uṛí Dalmanuta nam or ekkán elakat giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fore Féroci ókkol neeli aái Isá llói torkatorki diyat doijje. Ítara Íba re entán goríbar niyote, Íba ttu ekkán asmani nicán dabi goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Íba ye ḍoóñr góri niyác félai hoór de, “E zobanar maincé nicán dabi kiyá goré? Añí tuáñra re sóiyi hoóir, e zobanar maincóre honó nicán dahá no zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tói Íba ítara re eri, abar noow ot uṛí ḍiír okule giiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aar cárit tun ottu ruṭi loizaité foóraigilgoi; noow ot mazé ítara ttu ekgwár túaro bicí ruṭi nu accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isá ye ítara re nicót gorér de, “Hóboroddar, Féroci ókkol or cúṭar ottu edde Hérud or cúṭar ottu úñciyar táikko.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hétunot ítara afós ot howáhoi gorér de, “Íba ye híyan hoór de añára ttu ruṭi nái de hétolla.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Montor Isá ye híyan zani fari, ítara ttu fusár gorér de, “Tuáñra ttu ruṭi nái de híyan kiyá howáhoi gorór? Tuáñra kí aijjó ót nó foh yáh nó buzó? Tuáñrar dil aijjó doró dé? ");
INSERT INTO rhgc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tuáñra suk tái no dekór dé? Aar han tái no fúnor dé? Tuáñra ttu monot nái ne, ");
INSERT INTO rhgc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","zeñtté Añí fañs ázar maincór lla fañs swá ruṭi báinggilám héñtte ruṭir tukuṛa ókkol ho báñir bóri loóila?” Ítara Íba re hoór de, “Baró báñir.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Aró, zeñtté Añí sair ázar maincór lla háñt twa ruṭi báinggilám héñtte ruṭir tukuṛa ókkol ho lai bóri loóila?” Ítara Íba re hoór de, “Háñt lai.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Baade Isá ye ítara re hoór de, “Tói tuáñra aijjó nó buzó dé?” ");
INSERT INTO rhgc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tarfore ítara Betsáida farat aiccé. Aar maincé ek añdá manúc ore Isár hañse ainné, aní Íba re fóriyat goijjé de, yóggwa re súito. ");
INSERT INTO rhgc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Íba ye añdá manúc cwa re át ot dóri farar baáre loigiyé, aar yóggwar suk ot sép dí baade Íbar duní át yóggwar uore dí fusár gorér de, “Tuñí kessú dekór né?” ");
INSERT INTO rhgc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yóggwa ye uormikká saái hoór de, “Añí manúc ókkol dekír, ítara re saité gas áñṛer fán lager.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Isá ye abar Nizor át yóggwar suk ot diyé, hétunot yóggwa ek díyane saái táikke. Yóggwa agor ḍóilla gom óigiyoi, aar hárr kessú sáf-sáf góri dekí faijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Baade Íba ye yóggwa re eén hoói gór ot duñraidiyé, “Farat úddwa no góillo.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isá ye Nizor cárit tun ore fúañti looi, Kaisáriya Filíppi elakar fara ókkol ot zaargói; foñt ot Íba ye cárit tun ottu fusár gorér de, “Maincé Añí hon bouli hoó?” ");
INSERT INTO rhgc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ítara zuwab der de, “Tuñí bóle bápṭismadoya Yaháya; ar hodúne hoó de, nobi Eliyas; ar hodúne hoó de, nobi ókkol ottu honó eggwá.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tói Íba ye ítara ttu fusár gorér de, “Lekin tuáñra kii hoó, Añí hon?” Fitore zuwabe hoór de, “Tuñí óilade hé Mosih.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hétunot Íba ye ítara re nicót goijjé de, Íbar baabute honókiyo re no hoitó. ");
INSERT INTO rhgc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yárbaade Isá ye ítara re endilla taalim diyat doijje, Manúc or Fua ttu hámaha boóut ḍóilla duk faa foribó; aar murubbi, ḍoóñr imam edde alem ókkol ottu inkar háibo; Íba re mariféla zaybo, montor tin din baade abar zinda óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Íba ye hotá híyan sáf-sáf góri hoiyé. Hétolla Fitore Íba re ekkinare loizai buzát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Montor Isá fíri Nizor cárit tun or uzu saái Fitor ore jéjjeṛai hoór de, “Cóitan, Añr muúntu dur ó; kiyólla-hoilé tor díyan toh Allar gún or uzu no, bólke insán or gún or uzu.” ");
INSERT INTO rhgc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hétunot Íba ye Nizor cárit tun ore cóo manúc or dol ore matai hoór de, “Zodi honókiyo ttu Añr fisáli aitó monehoó, yóggwa ttu nizoré inkar gorífela foribó, aar nizor kúruc boói Añr fisáli dora foribó. ");
INSERT INTO rhgc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kiyólla-hoilé zee niki nizor zan basaitó saá, yóggwa ye híyan háraifelaibo; montor zee niki Añr edde kúchóbor or wasté nizor zan háraifele, yóggwa ye híyan basaifélaibo. ");
INSERT INTO rhgc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kii laf óibo, zodi honókiye tamám duniyai faa, montor nizor zan nán háraifele? ");
INSERT INTO rhgc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Insáne nizor zan or bodol kii dii faribó de asé? ");
INSERT INTO rhgc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Zee kiyé e zenákur edde gunágar manúc or bútore Añré lói edde Añr hotá re lói córma, yóggwa re lói Manúc or Fua yó córmaibo zeñtté Íba Nizor Baf or mohímaye pak fírista ókkol ore fúañti looi aibó.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Isá ye ítara re aró hoór de, “Añí tuáñra re sóiyi hoóir, eṛé endilla hodún manúc tíyaiya asé, zetará Allar raijjo taakote aáigiyoi de nó dekíte no moribó.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sów din baade Isá ye siríf Fitor ore, Yakub ore, edde Yohánna re looi, ítara re eggwá uñsol faár or uore loigiyé. Héṛe ítarar muúntu Íbar súrot bodoligiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Íbar hoor sossohat doijje edde fúut dóla óigiyoi, eén zeén níki duniyair honó hoor dúwoya ye héndilla dóla gorí no fare. ");
INSERT INTO rhgc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hétunot ítarar hañse Eliyas edde Muúsa dahádiye, aar Isá llói hotá howát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Fitore zuwabe Isá re hoór de, “Rabbí, gom óiye añára eṛé así. Añára eṛé tin nán ṭambu ṭaki: ekkán Tuáñr lla, ekkán Muúsa lla, edde ar ekkán Eliyas olla.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ítara bicí ḍooraigiyói ísafe, íba nize kii hoór nize no zane. ");
INSERT INTO rhgc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hétunot ekkán miyúla aái ítara re sáifelaiye, aar hé miyúla ttu eggwá abas aiccé de, “Ibá óilde Añr adorja Fua, Ibár hotá fúno!” ");
INSERT INTO rhgc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Éhon ítara sairómikka saiyé rár, Isá re bade ar honókiyo re ítarar fúañti nó deké. ");
INSERT INTO rhgc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ítara faár or uottú lamer de októt Isá ye ítara re hókum goijjé de, ítara ziín deikké híin Manúc or Fua mora ttu zinda nó óiyo foijjonto honókiyo re no hoitó. ");
INSERT INTO rhgc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ítara Íbar hókum híyan yaad raikké. Montor mora ttu zinda ówa hoiyé de híyan or maáni kii afós ot toskara gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Baade ítara Íba ttu fusár gorér de, “Alem ókkole kiyá endilla hoó, age nobi Eliyas aár zorur?” ");
INSERT INTO rhgc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Isá ye ítara re zuwabe hoór de, “Becók, age Eliyas aibó aar hárr kessú zendilla ówa foitto héndilla gorídibo. Aar toóu kiyá pak-kalam ot Manúc or Fuar baabute endilla asé, Íba ttu bicí duk faa foribó edde Íba re hékarot gorá zaybo? ");
INSERT INTO rhgc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lekin Añí tuáñra re hoóir, Eliyas aáigiyoi, aar íba re ítara ttu zeén monehoiyé héen goijjé, zendilla íbar baabute leikká asé.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aar zeñtté ítara baki cárit tun or héṛe aiccé, ítara dekér de, tarár sairó ḍák ottu ḍoóñr ek dol manúc asé, aar hodún aleme tará llói barábari dér. ");
INSERT INTO rhgc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Dol ṭíya ye Isá re deikké mottor bicí taajup óigiyoi, aar Íba re sólam gorí bolla duñri-duñri zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Íba ye ítara ttu fusár gorér de, “Tuáñra ítara llói kii barábari dór dé?” ");
INSERT INTO rhgc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dol ottu ezzone Íba re zuwab der de, “Ustat, añr fua wa re Tuáñr hañse ainní, ítare buk gorífele de jine faiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Zeñtté ítare hé jine dóre, héñtte ítare meṛit añsár mare. Tói ítar gal ottu féna aiyé aar íte date dat kirkira edde doró óizagoi. Añí Tuáñr cárit tun ore hé jin nwá neelaifélaito hoóilam, montor ítara nó fare.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hétunot Isá ye zuwabe hoór de, “Ó iman sára nosól, Añí tuáñrar fúañti-fúañti aró hotókkal tákitam? Hotódin tuáñra re bordac goittám? Fua wa re Añr hañse anó.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tói ítara fua wa re Íbar hañse ainné. Jin nwá ye Íba re dekí, fua wa re toratori dórforabat doijje. Tói fua wa meṛit fori ikká-uikká goijjat doijje, aar gal ottu féna neelat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isá ye fua war baf ottu fusár gorér de, “Ite hoñtté lóti endilla óiye?” Yóggwa ye hoór de, “Gura hale lóti. ");
INSERT INTO rhgc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hóraf jin nwá ye itaré zane marifélai bolla egazá ooin ot edde fanít féla. Montor zodi Tuñí kessú gorí faille, feṭfuri añára re modot goró.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Isá ye yóggwa re hoór de, “ ‘Zodi gorí faille,’ hoó de híyan kii hotá? Zee niki biccác goré yóggwa lla hárr kessú ói fare.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Éhon fua war bafe guzori hoór de, “Añí biccác gorí, añr biccác or komzuri ṭík gorído.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Isá ye bicí manúc ókkol duñri-duñri aái zoma ór de dekí, hóraf jin nwá re dóoñk dí hoór de, “Héy náfang edde buk jin, Añí toré hókum gorír, itar ttu neeli aáizagoi, itar bútore abar no gólic!” ");
INSERT INTO rhgc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hétunot jin nwá guzoran mari, fua wa re bicí dórforabai neeli aáigiyoi. Fua wa murudar ḍóilla óigiyoi de dekí boóut zone hoór de, “Ite morigiyói.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Montor Isá ye ítare át ot dóri tuillé, tói íte uṛí tíyaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zeñtté Isá gór ot aiccé, Íbar cárit tune Íba ttu aiddone fusár gorér de, “Yíba re añára kiyá neelai nó fari?” ");
INSERT INTO rhgc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Íba ye zuwab der de, “Dua sára ar honó kessú lói endilla gún neelai no fare.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Baade ítara héntu rowana loi Galil báy zaar. Isá ttu híyan or baabute honókiyo re zainto dito mon nu accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kiyólla-hoilé Íba ye cárit tun ore taalim dito de edde hoitó de, “Manúc or Fua re manúc ókkol or át ot gosáidiya zaybo; aar ítara Íba re marifélaibo, montor Íba tin din baade zinda óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lekin ítara hotá híyan nó buzíto, aar Íba ttu fusár goitté yó ḍooraitó. ");
INSERT INTO rhgc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tarfore ítara Kaparnahúm ot aiccé. Isá gór ot oiye rár, cárit tun ottu fusár gorér de, “Tuáñra foñt ot kiyór baabute barábari díla dé?” ");
INSERT INTO rhgc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Montor ítara nizám mári táikkil, kiyólla-hoilé ítara foñt ot barábari díyl de, añárar bútore ebbe ḍoóñr honnwá hoói. ");
INSERT INTO rhgc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Boói baade, Isá ye hé baró zon cárit tun ore matai hoór de, “Zar ttu age óito monehoó, yóggwa ttu beggún or fisé ówa foribó edde beggún or háadem bona foribó.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tarfore Íba ye eggwá gura fua looi ítarar mazé tíyagaraiye, aar fua wa re hañdót félai looi ítara re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Zee kiyé endilla eggwá gura fua re Añr name kobul goré, yóggwa ye Añré kobul goré deh; aar zee kiyé Añré kobul goré, yóggwa ye Añré kobul goré de no, bólke Añré difeṛáiye de Íba re kobul goré deh.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohánna ye Íba re hoór de, “Ustat, añára deikké de, eggwá maincé Tuáñr name bút neelar; yóggwa añárar ḍaái or manúc no de hétolla, añára yóggwa re maná goijjí.” ");
INSERT INTO rhgc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lekin Isá ye hoór de, “Yóggwa re maná no goijjó, kiyólla-hoilé Añr name keramot dahái baade éhon Añr baabute hóraf hoói fare de honókiye nái. ");
INSERT INTO rhgc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kiyólla-hoilé zee niki añárar ulḍa no, yóggwa toh añárar híkka. ");
INSERT INTO rhgc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tuáñra Mosihr ummot de hétolla zee kiyé tuáñra re ek fiyala faní dee, Añí tuáñra re sóiyi hoóir, yóggwa ye hámaha nizor boccíc fai zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Zee niki Añr uore iman ainné de e cóñṛo ókkol ottu honókiyo re guná gorába, ítar lla beétor óilde, ítar golat eggwá bór cíl or sakki bañdí doijjat félaidiya zah. ");
INSERT INTO rhgc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Zodi tuáñr áte tuáñre gunár uzu ṭane, tóoile híyan haṛifélo. Dui át táki zuzuk ot, yáni honódin no nifé de ooin ot zaar túaro, túñṛa ói zindigit góla tuáñr lla beétor, ");
INSERT INTO rhgc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","hé zuzuk ot, manúc háa de log no more aar ooin no nifé. ");
INSERT INTO rhgc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Zodi tuáñr ṭénge tuáñre gunár uzu ṭane, tóoile híyan haṛifélo. Dui ṭéng táki zuzuk ot félaidiya zar túaro, leng ói zindigit góla tuáñr lla beétor, ");
INSERT INTO rhgc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","hé zuzuk ot, manúc háa de log no more aar ooin no nifé. ");
INSERT INTO rhgc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aar zodi tuáñr suké tuáñre gunár uzu ṭane, tóoile yíba neelaifélo. Dui suk táki zuzuk ot félaidiya zar túaro, eggwá suk loi Allar raijjot góla tuáñr lla beétor, ");
INSERT INTO rhgc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","hé zuzuk ot, ‘manúc háa de log no more aar ooin no nifé.’ ");
INSERT INTO rhgc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Fottí ekzon ore ooin loi pak-sáf gorá zaybo zendilla kurbani re nun loi pak-sáf gorá zah. ");
INSERT INTO rhgc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nun toh gom jiníc, montor zodi nun or dok zaagói, tóoile híin ore keéngori abar nuncá gorá zaybo? Tuáñrar bútore nun raikkó, aar ezzon loi ezzone cántit táikko.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Baade Isá híyan ttu uṛí, Yohúdiya elaka félai Jordán hál or farkule giiyé. Manúc or dol Íbar hañse abar zoma óiye, aar Íba ye Nizor niyom mozin ítara re abar taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hodún Féroci aái Íba re entán gorí bolla súwal gorér de, “Morotfua ye nizor bou wóre sárifelaibar zayes asé né?” ");
INSERT INTO rhgc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Íba ye zuwabe ítara re hoór de, “Muúsa ye tuáñra re kii hókum díye?” ");
INSERT INTO rhgc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ítara hoór de, “Muúsa ye de ekkán sárhabos lekí dí duñraidi bolla ezazot diyé.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Montor Isá ye ítara re hoór de, “Tuáñrar dil doró de hétolla íba ye tuáñrar hañse héndilla hókum leikké deh. ");
INSERT INTO rhgc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lekin foidayecir héñtte lóti Alla ye ítara re morot aar maya banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Híyan olla toh morotfua ye nizor bafmaa ttu zuda ói nizor bou wór fúañti tákibo, ");
INSERT INTO rhgc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","aar ítara duní zon ek jisím óizayboi.’Hé ísafe, ítara ar dui no, bólke ek jisím. ");
INSERT INTO rhgc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hétolla Alla ye zetará re zur goijjé, ítara re honó manúce síra no goróuk.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yárbaade ítara gór ot óiye rár, cárit tune híyan or baabute Íba ttu abar fusár goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Íba ye ítara re hoór de, “Zee kiyé nizor bou wóre sárifelai ar eggwá re biyá goré, íte nizor bou wór ulḍa zená gorér deh. ");
INSERT INTO rhgc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aar ze mayafua ye nizor zamai re sárifelai ar ezzon biyá goré, híba ye zená gorér deh.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ek din manúc ókkole gura fuain dore Isár hañse anát doijje, zeéne Íba ye ítara re súwe; montor cárit tune manúc cún ore jéjjeṛaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Montor Isá ye híyan dekí bicí naras óiye, aar ítara re hoór de, “Fuain dore Añr hañse aitódo; ítara re no oóñillo, kiyólla-hoilé Allar raijjo toh ítarar ḍóilla maincé éna hásil goré. ");
INSERT INTO rhgc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Añí tuáñra re sóiyi hoóir, zee kiyé Allar raijjo re eggwá gura fuar ḍóilla góri kobul no goré, yóggwa híyan ot bilkúl góli no faribó.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Baade Íba ye ítara re hañd ot félai loiyé, aar Íbar át ítarar uore di ítara re borhot diyé. ");
INSERT INTO rhgc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Isá sofór ot zaito neeillé de októt, ezzon manúc duñri aái Íbar muúntu añṛúr tók dí fusár gorér de, “Gom Ustat, ofúrani zindigi miras faite añr ttu kii gorá foribó?” ");
INSERT INTO rhgc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isá ye yóggwa re hoór de, “Tuñí Añré gom kiyá ḍakoór? Alla bade toh ar kiyé gom nái. ");
INSERT INTO rhgc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tuñí de hókum ókkol zano, zendilla niki, ‘Kún no goríba, zená no goríba, suri no goríba, misá gobá no diba, férokbazi no goríba, bafmaa re izzot goríba.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Manúc cwa ye Íba re hoór de, “Ustat, gurahale lóti añí híin beggún amól gorí-gorí aiyír.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isá ye yóggwar uzu saái, yóggwa re ador lagi hoór de, “Tuáñr ttu ekkán ham baki asé. Zoo, tuáñr ttu asé de híin beggún besi gorif ókkol ore diifélogoi, tói tuñí asman ot dón faiba; baade aái Añr fisáli óiyogai.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Híyan fúni yóggwa bezar óigiyoi, edde ferecanir sáañte giiyégoi, kiyólla-hoilé yóggwa ttu becábicí dón-cómbotti accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hétunot Isá ye sairómikka saái Nizor cárit tun ore hoór de, “Dón-doulot ola ókkol ottu Allar raijjot gólite hotó mockil!” ");
INSERT INTO rhgc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cárit tun Íbar hotáye ammúk óigiyoi. Montor Isá ye ítara re abar hoór de, “Ó fuain, Allar raijjot gólite hotó mockil! ");
INSERT INTO rhgc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tuangor manúc Allar raijjot gólar túaro, eggwá uñṭ fúñc or faái ttu goli zaa aró aásan.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cárit tun aró bicí ammúk óigiyoi, aar ezzon ore ezzone hoór de, “Tóoile hone nejat fai faribó?” ");
INSERT INTO rhgc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isá ye ítarar uzu saái hoór de, “Híyan insáne gorí no fare, montor Alla ye fare; kiyólla-hoilé Alla ye toh hárr kessú gorí fare.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hétunot Fitore Íba re hoór de, “Soó, añára de hárr kessú eridi Tuáñr fisáli óiyi.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isá ye hoór de, “Añí tuáñra re sóiyi hoóir, zee niki Añr wasté edde Allar kúchóbor or wasté gór, báiboináin, bafmaa, fuain, yáh zaga-zobin eridiyé, ");
INSERT INTO rhgc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yóggwa ye e zobanat ek cót gun bicí gór, báiboináin, maa, fuain edde zaga-zobin faibo, aar fúañti-fúañti zulúm óu faibo; aar aiyér de zobanat ofúrani zindigi faibo. ");
INSERT INTO rhgc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lekin boóut zon, zetará yala age asé, ítara fisé óizayboi; aar zetará yala fisé asé, ítara age óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Héñtte ítara uore Jerúsalem ot zaar de foñt ot accíl, aar Isá ítarar age-age zaat accíl. Cárit tun ammúk óigiyoi, aar zetará Íbar fisé-fisé zaat accíl ítara ḍooraigiyói. Íba ye baró zon cárit tun ore abar ekkinare loizai, Íbar uore kii-kii óibo de híin ítara re howát doijje, ");
INSERT INTO rhgc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ki hoilé, “Soó, añára uore Jerúsalem ot zair, héṛe Manúc or Fua re ḍoóñr imam ókkol or edde alem ókkol or hañse dóridiya zaybo; ítara Íba re moot or fótua díbo edde Beyohúdi ókkol or hañse gosáidibo. ");
INSERT INTO rhgc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ítara Íba re ínca goríbo, sép maribó, coóñk maribó, edde zane marifélaibo. Lekin tin din baade Íba zinda óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yárbaade Zebedair fuain Yakub edde Yohánna Isár hañse aái hoór de, “Ustat, añára saái de añára Tuáñr ttu ziyán aros gorí, híyan Tuñí añára lla goró.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Íba ye ítara ttu fusár gorér de, “Tuáñra kii soór de, Añí tuáñra lla kii goittám?” ");
INSERT INTO rhgc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ítara Íba re hoór de, “Tuñí Tuáñr mohímat máze añára ezzon ore Tuáñr den ḍák ottu edde ar ezzon ore ban ḍák ottu buágaraiyo.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Montor Isá ye ítara re hoór de, “Tuáñra kii magor híyan tuáñra no zano. Añí fiíyum de fiyala tuáñra fií faribá né? Yáto Añí loiyum de bápṭisma tuáñra loi faribá né?” ");
INSERT INTO rhgc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ítara hoór de, “Añára fariyúm.” Isá ye ítara re hoór de, “Becók, ze fiyala Añí fiíyum, yíba tuáñra fiíba; aar ze bápṭisma Añí loiyum, yíba tuáñra loiba. ");
INSERT INTO rhgc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Montor Añr den ḍák ottu yáh ban ḍák ottu honókiyo re buágaron Añr ham no. Zaga híin óilde uitará lla zetará lla toiyar gorí raká gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baki doc zon cárit tune híyan fúni, Yakub edde Yohánna llói guccá óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Montor Isá ye ítara re Nizor hañse matai hoór de, “Tuáñra toh zano, zetará re Beyohúdi ókkol or hókumot-goróya ísafe zana zah, ítara tarár uore raastri goré; aar tarár ḍoóñr sóddar ókkole tarár uore adíkar sola. ");
INSERT INTO rhgc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Montor tuáñrar bútore héndilla ón ṭík no, bólke tuáñra ttu zee niki ḍoóñr óito saá, ítar ttu tuáñrar háadem bonar zorur; ");
INSERT INTO rhgc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","aar tuáñra ttu zee niki age óito saá, ítar ttu beggún or gulam bonar zorur. ");
INSERT INTO rhgc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kiyólla-hoilé Manúc or Fua yó toh hédmot faito aiccé de no, bólke aiccé de hédmot goittó, edde boóut zon or bodol Nizor zan dito.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yárbaade ítara Jerikó cóor ot aiccé. Zeñtté Isá Nizor cárit tun lói edde ḍoóñr ek dol manúc lói Jerikó ttu neeler, hé októt Timáiyus or fua Bartimai nam or ezzon añdá manúc rastar hañsat boói hórat mager de accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yóggwa ye Íba Isá Nasári de híyan fúinne rár, endilla guzorat doijje, “Ó Dawud or Fua Isá, añr uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Boóut zone yóggwa re jéjjeṛai nizám óito hoiyé, montor yóggwa ye aró ḍoóñr góri guzori hoór de, “Ó Dawud or Fua, añr uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hétunot Isá tíyaigiyoi aar hoór de, “Yóggwa re eṛé aitó hoó.” Tói ítara añdá manúc cwa re ḍahai hoór de, “Hímmot goró, uṛó. Íba ye tuáñre matar.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hétunot yóggwa ye nizor gaar saddor ekkinare félai, fál dí uṛí Isár hañse aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aar Isá ye yóggwa ttu fusár gorér de, “Tuñí kii soó, Añí tuáñr lla kii goittám?” Añdá manúc cwa ye Íba re hoór de, “Ó Rabbí, añár ttu abar dekí faitto monehoór.” ");
INSERT INTO rhgc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Isá ye yóggwa re hoór de, “Zoo, tuáñr imane tuáñre gom goijjé.” Yóggwa éhon dekí faijjíl, aar rasta ttu Isár fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zeñtté ítara Jerúsalem or ḍáke Zaitun Faár ot asé de Betfégi edde Betániya farat foóñicce, Isá ye Nizor dui zon cárit ore difeṛáiye, ");
INSERT INTO rhgc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ítara re endilla hoói, “Tuáñra muúm or fara gán ot zoo, héṛe góli mottor eggwá gadár sóo baindá loot faiba, zibár uore aijjó honókiye nó soré. Yíba re kúli eṛé anógoi. ");
INSERT INTO rhgc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Zodi honókiye tuáñra re eén hoó, ‘Tuáñra yián kiyólla gorór?’ Hoibá de, ‘Malik ottu yibá re lager.’ Tói yóggwa ye yíba re éhon eṛé difeṛáidibo.” ");
INSERT INTO rhgc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ítara rowana loiyé, aar gadár sóo wa re baárkule rastar uore gór or dorozat baindá loot faiyé; ítara yíba re kúlifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Montor héṛe tíyai accíl de tará ttu hodúne ítara re hoiyé de, “Tuáñra kii gorór deh, gadár sóo wa re kúlor de níki?” ");
INSERT INTO rhgc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Isá ye ítara re zendilla hoitó hoóil, ítara tará re héndilla hoiyé, tói tará ítara re ezazot diyé. ");
INSERT INTO rhgc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ítara gadár sóo wa re Isár hañse ainné, aar yíbar uore nizor hoor ókkol bicáidiye, aar Isá yíbar uore boiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bicí maincé nizor hoor ókkol rastar uore bicáidiye, argúne bariza ttu fatar ḍaggwa ókkol haṛi bicáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Zetará age-age edde fisé-fisé zaat accíl, ítara guzori-guzori hoór de, “Hósana! “Mubarek Ubá zibá Mabud or name aiyér. ");
INSERT INTO rhgc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Mubarek añárar baf Dawud or raijjo ziyán aiyér. “Ebbe uore asman ot Allar taarif óuk!” ");
INSERT INTO rhgc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Isá Jerúsalem ot góli baade, baitul-mukaddos or uṛán ot giiyé; aar sairómikka beggún saái yore, háñzinna óigiyoi de ísafe baró zon cárit tun ore fúañti looi Betániyat giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tarfor din, zeñtté ítara Betániya ttu bacá lóiye, Isá ttu búk laiggé. ");
INSERT INTO rhgc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Íba ye dur ottu tái fata furaiya eggwá ḍuñir-gas dekí, yíbat gula asé né saitó giiyé; montor Íba gas swár íñyot aiccé rár, fata bade ar kessú loot nó faa, kiyólla-hoilé héñtte ḍuñir gula dóribar moósum no. ");
INSERT INTO rhgc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hétunot Íba ye gas swá re hoór de, “Ar honódin tor ttu honókiye gula hái no farouk.” Íbar cárit tune hotá híyan fúinnil. ");
INSERT INTO rhgc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Baade ítara Jerúsalem ot foóñicce. Isá baitul-mukaddos or uṛán ot góli, zetará héṛe besa kina gorér ítara re loraidiyat doijje, aar baṭṭa báñgoyar ṭebíl edde hoitor besoyar boiṛóni ókkol natḍiyagarai diyé. ");
INSERT INTO rhgc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Íba ye Baitul-mukaddos or uṛán báy honókiyo re malsáman loizaitó nó deh. ");
INSERT INTO rhgc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Íba ye taalim ot ítara re hoór de, “Pak-kalam ot ki yián nái, ‘Añr gór ore tamám koum ókkol olla munazat or gór howá zaybo’? Montor tuáñra toh híyan ore ḍahañit or aḍḍa-hána banaifélaiyo.” ");
INSERT INTO rhgc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ḍoóñr imam ókkole edde alem ókkole híyan fúni Íba re marifélaibar mouka tuwat accíl. Ítara Íba re ḍooraitó, kiyólla-hoilé manúc beggún Íbar taalime ammúk óizaytoi. ");
INSERT INTO rhgc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aar zeñtté háñzinna óiye, Isá edde Íbar cárit tun cóor or baáre giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Biínna ítara héntu zaar de októt, ḍuñir-gas swá cíñyor ottu lóti fúaigiyoi de deikké. ");
INSERT INTO rhgc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Fitor ottu monot uṛí Íba re hoór de, “Rabbí, soó, Tuñí boddua diíla de ḍuñir-gas swá fúaigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Isá ye ítara re zuwabe hoór de, “Allar uore iman rakó. ");
INSERT INTO rhgc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Añí tuáñra re sóiyi hoóir, zee kiyé e faár gwá re eén hoó, ‘Uṛí doijjat forgói,’ aar nizor dil ot honó cók no raké bólke ziyán hoiyé híyan óibo de biccác goré, tóoile yóggwa lla híyan óibo. ");
INSERT INTO rhgc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hétolla, Añí tuáñra re hoóir, tuáñra duat mazé ziín mago, híin faifelaiyo bóuli biccác goijjó, tói tuáñra re híin diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Zeñtté tuáñra tíyai dua goró, héñtte honókiyor ulḍa kessú tákile yóggwa re maf gorídiyo, zeéne tuáñrar asmani Bafe yó tuáñra re tuáñrar hosúri maf gorí deh. ");
INSERT INTO rhgc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Montor zodi maf no goró, tóoile tuáñrar asmani Bafe yó tuáñrar hosúri maf no goríbo.” ");
INSERT INTO rhgc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ítara abar Jerúsalem ot aiccé. Isá baitul-mukaddos ot gúrafíra gorér de októt, ḍoóñr imam ókkol, alem ókkol, edde murubbi ókkol Íbar hañse aiccé, ");
INSERT INTO rhgc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","aar Íba re hoór de, “Tuñí ham iín kii adíkare gorór? Iín gorí bolla Tuáñre e adíkar hone diiyé?” ");
INSERT INTO rhgc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Isá ye ítara re zuwabe hoór de, “Añí yó tuáñra ttu ekkán súwal fusár goríyum, Añré zuwab diyo, baade Añí tuáñra re hoiyúm Añí iín kii adíkare gorír deh. ");
INSERT INTO rhgc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Añré zuwab do sái, Yaháya ye bápṭisma díbar adíkar faáil de asman ottu né náki insán ottu?” ");
INSERT INTO rhgc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Baade ítara afós ot biyasana gorér de, “Zodi añára hoói, ‘asman ottu,’ Íba ye hoibó de, ‘Tóoile tuáñra íba re biccác kiyá nó goró?’ ");
INSERT INTO rhgc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Montor zodi hoói, ‘insán ottu’ tóoile?” Ítara maincóre ḍooraitó, kiyólla-hoilé beggúne Yaháya nobi de mainto. ");
INSERT INTO rhgc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hétolla ítara Isá re zuwabe hoór de, “Añára no zani.” Isá ye ítara re hoór de, “Tóoile Añí yó tuáñra re no hoiyúm Añí iín kii adíkare gorír.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Isá ye ítara re meésal ókkol dí hotá howát doijje, “Ezzon maincé ekkán anggur-bariza lagaiyé. Yóggwa ye híyan or sairó ḍák ottu gíra díye, anggur or roc neelai bolla eggwá gañrá kuijjé, edde ekkán ṭongki baindé. Baade bariza gán cacá ókkol ore ṭéka dí oinno mulluk ot giiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Aar anggur or ainda aiccé rár, yóggwa ye eggwá goóur ore cacá gún or hañse difeṛáiye, cacá ítara ttu barizar gular bák fai bolla. ");
INSERT INTO rhgc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lekin ítara taré dóri, mara-dóra gorí háli áte duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yóggwa ye abar ítarar hañse ar eggwá goóur difeṛáiye, ítara taré matá sái mari bicí beizzoti goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yóggwa ye aró éggwa difeṛáiye; ítara taré zane marifélaiye. Héndilla, ítara aró boóut twa re goijjé, hodún ore mara-dóra goijjé, hodún ore zane marifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Yala yóggwa ttu siríf ar ezzon difeṛáibar asé deh, íba óilde yóggwar adorja fua. Ahérit yóggwa ye nizorgá nize eén hoói fua wa re difeṛáiye, ‘Ítara añr fua re izzot goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Lekin cacá gúne afós ot hoór de, ‘Ite toh mirasdár; aiyó itaré marifélai, baade miras añárar óizayboi.’ ");
INSERT INTO rhgc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tói ítara íba re dóri marifélaiye, aar barizar baáre félaidiye. ");
INSERT INTO rhgc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Barizar giróse ítara re kii goríbo fáñllar? Yóggwa ye aái hé cacá gún ore marifélaibo, aar bariza gán oinno kiyó re diifélaibo. ");
INSERT INTO rhgc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tuáñra pak-kalam ot yián úddwa nó foró níki, ‘Ze fattór mistíri ye inkar gorífelaiye, yíba cíl beggún or túaro bicí zoruri wa óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Híyan Mabud or torfóttu óiaicce, aar híyan añárar suk ot taajuippa’?” ");
INSERT INTO rhgc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hétunot ítara Íba re dórifelai bolla kucíc goijjíl, kiyólla-hoilé ítara buzígiyoi de ki Isá ye hé meésal lan ítarar hélaf hoiyé deh. Montor ítara maincór ḍoore Íba re eri giílgoi. ");
INSERT INTO rhgc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fore ítara hodún Féroci edde Hérudiól ore Isár hañse difeṛáiye, zeéne tará Íba re Íbar hotá loi hol ot félai fare. ");
INSERT INTO rhgc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tará aái Íba re hoór de, “Ustat, añára zani de, Tuñí sóiyi hoó. Tuñí maincé kii hoór forba no goró, kiyólla-hoilé Tuñí toh honókiyo re forók goró de nái, bólke sóiyigori Allar rastar taalim doh. Añára re hoósai, Romi baáñcca re házana doon zayes asé ne nái? ");
INSERT INTO rhgc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Añára diitam ne náki no diitam?” Montor Íba ye tarár munaféki re zani hoór de, “Tuáñra Añré entán gorór kiyá? Sai bolla Añr hañse ekkán dinár anó.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tói tará ainné. Íba ye tará re hoór de, “Yián har sóbi edde har nam?” Tará Íba re hoór de, “Romi baáñccar.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tói Isá ye tará re hoór de, “Ziín baáñccar híin baáñcca re diiyo, aar ziín Allar híin Alla re diiyo.” Híyane tará ebbe taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Baade Sadukái ókkol Isár hañse aiccé, Sadukái ókkole háñcor nái hoó, ítara aái Íba re ekkán súwal goijjé de, ");
INSERT INTO rhgc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ustat, Muúsa ye añára lla leikké de, zodi honókiyor bái fuain sára morizagói aar ítar bou táizagoi, tóoile ítar hé bái ottu bou híba re biyá gorífelai nizor bái olla nosól foida gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dóro, háñt zon bái accíl. Foóila wa ye bou looi, fuain sára morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Baade híba re dusára wa ye biyá goijjé, aar íte yó fuain sára morigiyói; tisára war hálot óu héndilla óiye. ");
INSERT INTO rhgc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Héndilla, háñto bái ye híba re biyá gorí fuain sára morigiyói. Ahérit, mayafua wa yó morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hé ísafe, háñcor or hale híba har bou óibo? Kiyólla-hoilé híba re toh háñto zone nizor bou banaáil.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isá ye ítara re hoór de, “Tuáñra etollá éna gollot ot asó deh! Tuáñra toh no Allar pak-kalam zano, aar no Allar kudurut zano. ");
INSERT INTO rhgc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kiyólla-hoilé zeñtté ítara mora ttu zinda óibo, héñtte ítara no biyá goríbo aar no ítara re biyá diya zaybo, bólke ítara asman or fíristar ḍóilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mora ókkol zinda ówar baabute hoitó sailé, tuáñra kí Muúsar kitab ot zeṛé niki zoler de záḍḍwar zikír asé héṛe nó foró, Alla ye Muúsa re endilla hoiyé de, ‘Añí óilam de Ibrahím or Alla, Isahák or Alla, edde Yakub or Alla?’ ");
INSERT INTO rhgc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Alla toh mora ókkol or Alla no, bólke zinda ókkol or éna. Tuáñra ttu ḍoóñr gollot óiye.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ekzon alem aái ítara barábari dér de fúinne, aar Isá ye ítara re ṭík zuwab diyé de zani Íba re súwal gorér de, “Beggún or túaro hókum hon nán ḍoóñr?” ");
INSERT INTO rhgc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isá ye zuwab der de, “Ebbe ḍoóñr gán óilde, ‘Fúno, ó Isráil! Mabud añárar Alla óilde ekgwá Mabud. ");
INSERT INTO rhgc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mabud tuáñrar Alla re nizor fura dile, fura zane, fura demake, edde fura bole muhábbot goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Dui nombór or gán óilde, ‘Nizor atehañsór maincóre nizor ḍóilla muhábbot goríba.’Hé duníyan or túaro ar ḍoóñr hókum nái.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Alem mwa ye Íba re hoór de, “Cabác, Ustat! Tuñí sóiyi hoiyó, Alla ekgwá beh asé, Íba bade ar honókiye nái. ");
INSERT INTO rhgc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Íba re fura dile, fura buddíye, fura bole muhábbot goittó, aar nizor atehañsór maincóre nizor ḍóilla muhábbot goittó. Hókum hé duníyan, fura kurbani edde oinno kurbani beggún or túaro zoruri.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isá ye zettót yóggwa ye buddír sáañte zuwab diyé de deikké, Íba ye yóggwa re hoór de, “Tuñí Allar raijjo ttu duré no.” Héñtte lóti honókiyo ttu Íba re ar súwal goittó hímmote nó deh. ");
INSERT INTO rhgc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isá ye baitul-mukaddos ot taalim der de októt hoór de, “Alem ókkole keéngori hoó de Mosih Dawud or Fua? ");
INSERT INTO rhgc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kiyólla-hoilé Dawud nize toh Pak-Ruhr hédaiyote endilla hoiyé, ‘Mabude añr Malik ore hoór de, “Añr den ḍák ottu boiyó, zetókkal foijjonto Añí Tuáñr duccon ókkol ore Tuáñr foor tole gorí nó felai.” ’ ");
INSERT INTO rhgc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawud nize toh Íba re ‘Malik’ ḍaikké, tóoile Íba hon bote Dawud or fua de?” Becábicí maincé kúcir sáañte Íbar boiyan fúnat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Isá ye Nizor taalim ot hoór de, “Alem ókkol ottu úñciyar táikko, zetará lamba-lamba kuruta fiñdí gúrafíra goittó saá, aar bazare-bazare sólam faito, ");
INSERT INTO rhgc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","mujilíc-hána ókkol ot uñsol tokkar hadírat boitó edde mela-cóba ókkol ot barík zagat boitó fosón goré. ");
INSERT INTO rhgc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ek mikká ttu ítara rari ókkol or gór ókkol luṭ gorífele, arek mikká ttu maincóre dahái bolla lamba-lamba dua goré. Manúc híine sáñza bicí ḍoóñr faibo.” ");
INSERT INTO rhgc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Baade Isá baitul-mukaddos or dan-baccúr muúntu boiccé, aar dan-baccút maincé ṭiañ-foicá hondilla deer saái táikke. Boóut tuangor ókkole bicí-bicí diiyat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eggwá gorif rari aái duiyán cóñṛo foicá diiyé, yáni hoek fiyá. ");
INSERT INTO rhgc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hétunot Íba ye Nizor cárit tun ore matai hoór de, “Añí tuáñra re sóiyi hoóir, zedúne dan-baccút sótka diiyé ítara beggún or túaro e gorif rari wa ye bicí diiyé; ");
INSERT INTO rhgc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kiyólla-hoilé oinno beggúne ítarar aṭalikka dón ottu diiyé deh, montor ibáh ye toh nizor gorif hálot ot basi táki bolla ziín accíl híin beggún diifélaiye.” ");
INSERT INTO rhgc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Isá baitul-mukaddos ottu baáre zaargói de októt, Íbar ézzon cárite hoór de, “Ustat, soó, keén cúndor-cúndor fattór edde keén cúndor-cúndor billíng!” ");
INSERT INTO rhgc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isá ye íba re hoór de, “Tui e ḍoóñr-ḍoóñr billíng iín dekór de né? Eṛé eggwá fattór or uore ar eggwá fattór no tákibo, híin fottí ekgwá re félaidiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aar Isá baitul-mukaddos or muúm or Zaitun Faár ot boiṛá accíl de októt, Fitor, Yakub, Yohánna edde Enderiyase aiddone Íba ttu fusár gorér de, ");
INSERT INTO rhgc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Añára re hoóna, híin hoñtté óibo dé? Híin beggún fura óibar októ aiccé de híyan or alamot kii óibo?” ");
INSERT INTO rhgc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isá ye ítara re zuwabe howát doijje de, “Saiyó, honókiye zen tuáñra re gollot ot no loiza. ");
INSERT INTO rhgc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Boóut zone Añr name aái hoibó de, ‘Añí Íba,’ ítara boóut zon ore gollot ot loizaybói. ");
INSERT INTO rhgc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Zeñtté tuáñra laráir abas edde laráir hóbora-hóbori ókkol fúniba, no ḍooraiyó; kiyólla-hoilé híin ówar zorur, montor híyala yó ahérot óibo de no. ");
INSERT INTO rhgc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ek koume arek koum or ulḍa edde ek raijjo ye arek raijjor ulḍa tíyaibo; zaga-zaga búsal ókkol edde raṭ ókkol óibo. Montor híin óilde siríf, fua hálas óibar cúrur duk ókkol or ḍóilla. ");
INSERT INTO rhgc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Lekin tuáñra úñciyar táikko; kiyólla-hoilé maincé tuáñra re adalot ot gosáidibo, aar tuáñra re mujilíc-hánat bet mara zaybo. Añr lla bóuli tuáñra re hákim edde baáñcca ókkol or muúntu házir gorá zaybo, zeéne tuáñra ítarar hañse Añr gobá dí faro. ");
INSERT INTO rhgc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Age tamám koum ókkol or hañse Allar kúchóbor tobolik gorá zar zorur. ");
INSERT INTO rhgc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Zeñtté maincé tuáñra re dóri bisar ot tulíbo, héñtte kii hoibá age lóti sinta no goijjó, bólke hé októt tuáñra re ziín diiya zaybo híin hoiyó; kiyólla-hoilé hoóiya toh tuáñra no, bólke Pak-Ruh éna. ");
INSERT INTO rhgc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Bái ye bái ore aar bafe fua re marifélai bolla dóridibo. Fuain de nizor bafmaar hélaf tíyai ítara re mariféla báibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Añr nam olla bóuli tuáñra re beggúne nafórot goríbo; montor zee niki ahéri foijjonto bordac goríbo, yóggwa ye nejat faibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tuáñra hé bicí hótara jiníc ziyáne nafak goréhíyan ore no tákon accíl de zagat zeñtté tíyaiya dekíba—foróya ye buzó—héñtte zetará Yohúdiyat tákiba ítara ttu faár ot dáizagoi foribó. ");
INSERT INTO rhgc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Zee niki gór or sád or uore asé, ítar ttu lamat no lama foribó, nizor gór ttu kessú looi bolla bútore no zaa foribó. ");
INSERT INTO rhgc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Zee niki kétit asé, ítar ttu nizor saddor looi bolla waafes nu aá foribó. ");
INSERT INTO rhgc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Montor hé din ókkol ot hámil mayafuain dor lla edde dud or maa ókkol olla bicí afsús or hálot óibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dua goró, zeéne híin cítkhale no. ");
INSERT INTO rhgc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kiyólla-hoilé din híin eén mosibot or din óibo, zendilla Alla ye duniyai foida goijjé de héñtte lóti aijjó óiye de nái, aar abar no yó óibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Zodi Mabude hé din ókkol homai no dito, tóoile honókiye no basitó; montor Íbar basíloiya bonda ókkol olla bouli Íba ye din híin homaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Héñtte zodi honókiye tuáñra re eén hoó, ‘Soó, Mosih eṛé asé!’ yáto ‘Soó, Íba uṛé asé!’ híyan ekin no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kiyólla-hoilé misá Mosih ókkol edde misá nobi ókkol uṛíbo, aar ítara keramot ókkol edde taajuippa harhána ókkol daháibo, maincóre gollot ot loizai bolla, farilé Allar basíloiya bonda re úddwa. ");
INSERT INTO rhgc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lekin tuáñra úñciyar táikko; Añí toh tuáñra re hárr kessú age lóti hoóidiyi. ");
INSERT INTO rhgc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Montor din híin ot, hé mosibot baade, beil andár óizayboi, aar sane foór no dibo; ");
INSERT INTO rhgc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","asman ottu tara ókkol forizaybói, aar asmani jiníc ókkol tóttoraibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Héñtte ítara dekíbo de, Manúc or Fua ḍoóñr kudurut edde mohímar sáañte miyúlar bútore góri aiyér. ");
INSERT INTO rhgc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aar Íba ye fírista ókkol ore duniyair ek matá ttu arek matá foijjonto difeṛái, sairómikka ttu Nizor basíloiya bonda ókkol ore ekkán ot zoma goríbo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ḍuñir-gas ottu meésal loo: zeñtté ḍuñir-gas or ḍéeila hórot ói fata neele, tuáñra zanizogói de, hóran ḍáke. ");
INSERT INTO rhgc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Héndilla tuáñra yó, zeñtté iín ór de dekíba, héñtte buzíba de, Manúc or Fua ḍáke, ebbe dorozat. ");
INSERT INTO rhgc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Añí tuáñra re sóiyi hoóir, iín beggún fura nó óiyo foijjonto e nosól bilkúl no fúraibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asman zobin toh zari no tákibo, montor Añr hotá hámica zari tákibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lekin hé din yáto októ aibár baabute honókiye no zane, asman or fírista ókkole yó no zane, aar Fua ye yó no zane, siríf Bafe beh zane. ");
INSERT INTO rhgc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hóboroddar, seton táko edde dua goró; kiyólla-hoilé tuáñra toh no zano hé októ hoñtté aibó. ");
INSERT INTO rhgc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hé októ yíba ezzon duré sofór ot zaar de manúc or ḍóilla, zee niki nizor gór eri zaite goóur ókkol or át ot zimma ókkol dii giiyé, yáni zar-zar ham taré-taré diiyé, aar duwar sooñidar ore yó seton tákito hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Hétolla hoóir, seton táko, kiyólla-hoilé tuáñra toh no zano, gór or girós hotúnot aibó—ki háñzinna, ki adá raitta, ki fuáñitta, aar náki biínna. ");
INSERT INTO rhgc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Arnóile yóggwa asimbit ailé tuáñra re gúm ot loot faibo. ");
INSERT INTO rhgc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Añí tuáñra re ziyán hoóir, híyan beggún ore hoóir de, ‘Seton táko!’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Azadir-id edde Cúṭar-sára Ruṭir-id aité dui din asé. Aar ḍoóñr imam ókkole edde alem ókkole Isá re kii bote zuitégori dórifelai marifélai faribó de híyan or talac ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Montor ítara hoór de, “Id or októt no, manúc or bútore úrussul óitofare.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Isá Betániyat kurus biyaraimma Sáimon or gór ot tákite, Íba ye hána háar de héñtte, héṛe eggwá mayafua ye fúañti fattór or háñrit góri háṭi narḍ-gas or bicí moóngga añtor looi aiccé. Baade híba ye háñri wa báñgi añtor gún Isár matát ḍálidiye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Montor hodún ottu gom no lagi afós ot howáhoi gorér de, “E añtor gún kiyá borbad difélaiye? ");
INSERT INTO rhgc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","E añtor gún de tin cót dinár or túaro bicí dí besi ṭiañ gún gorif ókkol ore diifélai faitto.” Héndilla hoói ítara híba re bóṭboṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Montor Isá ye hoór de, “Ibáh re goittó doh; tuáñra ibáh re ferecan kiyá gorór? Ibáh ye Añr bálai éna goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gorib ókkol toh tuáñrar fúañti nitti asé,tuáñra ttu zetúnot monehoó hétunot ítarar bálai gorí faribá; montor Añré tuáñra nitti no faiba. ");
INSERT INTO rhgc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ibáh ye ziyán faijjé híyan éna goijjé. Ibáh ye Añr dohón olla Añr gaat age lóti añtor ḍálidiye deh. ");
INSERT INTO rhgc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hétolla Añí tuáñra re sóiyi hoóir, fura duniyait zeṛé-zeṛé kúchóbor tobolik gorá zaybo, e mayafua wa ye ziyán goijjé híyan ore yó ibáhr yadgari ísafe héṛe-héṛe howá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Baade Yohúdah Iskáriyet, zee accíl baró zon cárit tun ottu ezzon, íte ḍoóñr imam ókkol or hañse giiyé, Isá re ítarar át ot dóridi fare fán. ");
INSERT INTO rhgc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Híyan fúni ítara kúci óiye, aar ítare ṭiañ diibo bouli waada diyé. Tarfore íte Isá re dóridi bolla moukar talac ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Cúṭar-sára Ruṭir-id or foóila din ot, ze din Azadir-id or hána lla bérasóol or sóo kurbani goré, Isár cárit tune Íba ttu fusár gorér de, “Tuáñr ttu hondilla monehoór, Tuñí hái faro fán añára hoṛé zai Tuáñr lla Azadir-id or hánar toiyari goittám?” ");
INSERT INTO rhgc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Íba ye Nizor dui zon cárit ore endilla hoói difeṛáiye, “Tuáñra cóor ot zoo; zok ot gori faní loizar de ézzon manúce tuáñra llói milibó; íbar fisé-fisé zaiyo. ");
INSERT INTO rhgc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Íba ze gór ot góle hé gór gan or girós ore hoibá de, ‘Ustate hoór de, “Añr meéman-hána hoṛé, ziyán ot Añí Añr cárit tun or fúañti Azadir-id or hána hái faijjum?” ’ ");
INSERT INTO rhgc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hétunot yóggwa ye tuáñra re háñzaiya edde toiyar goijjá ekkán uoror ṭalar ḍoóñr kamára daháibo. Héṛe añára lla toiyar goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tói cárit tun zai cóor ot góille, aar Isá ye ítara re zendilla hoiyé héndilla faiyé; baade ítara Azadir-id or hána toiyar goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Zeñtté háñz óiye, Isá baró zon cárit tun ore fúañti looi héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ítara boói hána háar de októt, Isá ye hoór de, “Añí tuáñra re sóiyi hoóir, tuáñra ttu ezzone Añré dóridibo; íte Añr fúañti hána háar.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hétunot ítara ferecan ói zonfoti Íba ttu fusár gorér de, “Íte añí no de no né?” ");
INSERT INTO rhgc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Íba ye ítara re zuwabe hoór de, “Íte baró zon nun ottu ezzon, íte Añr fúañti hoddát ruṭi burar. ");
INSERT INTO rhgc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Manúc or Fua toh Íbar baabute zendilla leikká asé héndilla éna zaar; montor afsús manúc uitar uore, zar duara Manúc or Fua dóra háibo. Manúc íte toh zormo no óito bóuli ítar lla gom accíl.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ítara háar de októt, Isá ye ruṭi looi Alla re cúkuriya goijjíl, aar báñgi cárit tun ore dii hoór de, “Loo, yián Añr gaa.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tarfore Íba ye fiyala looi Alla re cúkuriya gorí ítara re diiyé, baade ítara beggúne héntu háiye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Íba ye ítara re hoór de, “Iín óilde noya razinama lla Añr lou, ziín ore boóut kiyór lla ḍálidiyum. ");
INSERT INTO rhgc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Añí tuáñra re sóiyi hoóir, Añí e anggur or roc iín abar na háiyum, otódin zetódin foijjonto tuáñrar fúañti Allar raijjot noya gori ná hái.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yárbaade ítara eggwá seér gaái, Zaitun Faár ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tarfore Isá ye ítara re hoór de, “Tuáñra beggún or dil ot cóok aibó aar dáibagoi, kiyólla-hoilé pak-kalam ot toh endilla asé, ‘Añí sóol soroya re marifélaiyum, tói sóol ókkol cíñṛaciñṭṭá óizayboi.’ ");
INSERT INTO rhgc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Montor Añré zinda gorá zay baade, Añí tuáñrar age Galil ot zaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Fitore Íba re hoór de, “Beggúne iman ottu zailé yo, añí no zaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isá ye íba re hoór de, “Añí toré sóiyi hoóir, aijja raitta ratakurá duibar bak dibar age, tui nize Añré tin bar inkar goríbi.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lekin Fitore aró zure hoór de, “Zodi añr ttu Tuáñr fúañti mora fore yó, añí Tuáñre inkar no goijjúm.” Héndilla ítara beggúne hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yárbaade ítara ekkán zagat aiccé, ziyán ore Getsámani hoó. Isá ye Nizor cárit tun ore hoór de, “Añí zetún dua goijjúm hétun iñyót boói táko.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Íba ye fúañti Fitor ore, Yakub ore edde Yohánna re loigiyé, aar héṛe Íba ttu ocánti edde bicí ferecani lagat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Íba ye ítara re hoór de, “Bicí ocántiye Añr foran neelizaytói sár. Tuáñra iñyót táki seton táko.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Baade Íba héntu ekkágori muúmmikka zai, meṛit fori dua gorát doijje de, zodi farilé hé dukkór októ re Íba ttu dur gorífelaito. ");
INSERT INTO rhgc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Íba ye hoór de, “Ó Abba, ó Baf, Tuñí hárr kessú gorí faro. E duk-mosibot or fiyala yibá Añr ttu dur gorífelo; montor toóu Añr moncá mozin no, bólke Tuáñr moncá mozin óuk.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Baade Íba aái ítara re gúm ot loot faiyé, aar Fitor ore hoór de, “Sáimon, tui gúm ot níki? Tui ek gónḍa úddwa seton táki no faroór dé? ");
INSERT INTO rhgc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Seton táko aar dua goró, zeéne entán ot no foro; Bécok ruh ttu monehoór, montor jisím komzur deh.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Íba abar zai ekí ḍóilla hotá hoói dua goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Íba waafes aái, ítara re abar gúm ot loot faiyé, kiyólla-hoilé ítarar suk gúme bór óigilgoi; aar ítara Íba re kii zuwab dibo hoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Íba tisárabar aái yore ítara re hoór de, “Tuáñra aijjó úddwa gúm ot edde aram gorát asó de? Óiye, októ foóñiccegai. Soó, Manúc or Fua re gunágar ókkol or át ot dóridiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uṛó, zaigói. Soó, Añré dóridoya ḍáke foóñiccegai.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Íba ye híin hoór de októt, éhon Yohúdah foóñiccegai, zee niki baró zon nún ottu ezzon. Ítar fúañti ek dol manúc toluwar edde laṛí-cúṛa looi aiccé, zetará re difeṛáiye de óilde ḍoóñr imam ókkole, alem ókkole, edde murubbi ókkole. ");
INSERT INTO rhgc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zee niki Íba re dórider, íte tará re endilla hoói ekkán nicán diíl, “Añí zibá re appá diyum, manúc Íba. Íba re gereftar gorífelaiyo aar soikkal di loizaiyogói.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yohúdah aái mottor Íbar íñyot giiyé, aar “Rabbí!” hoói Íba re appá díye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Baade éhon tará Íba re dóri gereftar gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Montor ḍáke tíyai accíl de ítara ttu ezzone nizor toluwar neelaiye, aar híyan solai boro imam or gulam or han haṛifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Isá ye tará re hoór de, “Tuáñra ḍahañit dóitto aiccó fángori toluwar edde laṛí-cúṛa lói Añré dóitto aiccó de? ");
INSERT INTO rhgc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Añí toh fottí din baitul-mukaddos ot tuáñrar fúañti táki taalim ditam, aar héñtte de Añré gereftar nó goró. Montor iín etollá óiye, zeéne pak-kalam or hotá fura óizagoi.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hétunot cárit beggúne Íba re eri dáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ezzon juwan manúc Íbar fisé-fisé zaat accíl, yóggwa ye nizor biyossor gaat kessú nó fiñdé, ekkán saddor beraiyé deh. Tará yóggwa re dóitto saiyé, ");
INSERT INTO rhgc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","montor yóggwa ye saddor gán félai biyossor duñrdiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tarfore tará Isá re boro imam or hañse loigiyói, aar tamám ḍoóñr imam, murubbi edde alem ókkol zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Fitor duré-duré tái Íbar fisé-fisé boro imam or uṛán or bútore foijjonto giiyé, aar faáradar ókkol or fúañti boói ooin fuwát accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ḍoóñr imam ókkole edde fótuayi-mujilíc ṭíya ye Isár ulḍa gobár talac ot accíl, Íba re marifélai fare fán; montor honó gobá nó faa. ");
INSERT INTO rhgc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Becók boóut zone Íbar ulḍa misá gobá díyl, montor ítarar gobá mil ná há. ");
INSERT INTO rhgc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Fore hodúne uṛí Íbar baabute endilla misá gobá díye, ");
INSERT INTO rhgc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Añára Ibá ye eén hoiyé de fúinni, ‘Añí át or banaiya baitul-mukaddos yián báñgifelai, tin din or bútore ar ekkán banaidiyum, ziyán át or banaiya no óibo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lekin ebar óu ítarar gobá mil ná há. ");
INSERT INTO rhgc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hétunot boro imame uṛí muúntu tíyai Isá ttu fusár gorér de, “Tuñí honó zuwab no diba? Manúc itará Tuáñr ulḍa iín kii gobá der?” ");
INSERT INTO rhgc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Montor Íba nizám mári táikkil, aar honó zuwab nó deh. Boro imame abar fusár gorér de, “Tuñí kí Taarifdár Allar Fua Mosih?” ");
INSERT INTO rhgc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isá ye hoór de, “Ói Añí. Tuáñra dekíba, Manúc or Fua Alla Tálar den ḍák ottu boiṛá asé edde asman or miyúlat góri aiyér.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Boro imame nizor gair or hoor fáṛi hoór de, “Añára ttu ar kii gobá lager dé? ");
INSERT INTO rhgc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tuáñra toh Ibár kuféri fúinno; tuáñrar rai kii?” Ítara beggúne Íba moot or laayek bouli fótua díye. ");
INSERT INTO rhgc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tarfore hodúne Íba re sép marat doijje, aar Íba re suk bandi gúca mari hoór de, “Hone maijjé antas gor sái!” Baade faáradar ókkole Íba re loizai suwar maijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Fitor nise uṛán ot accíl de októt, boro imam or bañdi mayafuain ókkol ottu ezzon héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aar Fitor ooin fuwár de dekí, íbar uzu saái hoór de, “Tuñí yó toh Nasári Isár fúañti accíla.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Montor íba ye endilla hoói inkar gorídiye, “Tuñí kiyór baabute hoór añí no zani aar no yó buzír.” Baade íba baáre baanḍat giiyégoi. Hétunot ratakurá bak diyé. ");
INSERT INTO rhgc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bañdi mayafua wa ye íba re abar deikké rár, ḍáke tíyai asé de ítara re hoór de, “Ibá tarár bútottu ekzon!” ");
INSERT INTO rhgc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Montor íba ye abar inkar gorídiye. Hotún baade ḍáke tíyai asé de ítara Fitor ore abar hoór de, “Sóiyi tuñí tarár bútottu ekzon, kiyólla-hoilé tuñí yó Galil or manúc.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Montor íba ye hosóm hái hoór de, “Añr uore laánot óuk zodi añí misá hotá hoóir de óile. Tuáñra ze manúc cwar hotá hoór añí Íba re no siní.” ");
INSERT INTO rhgc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Baade éhon-éhon ratakurá dusárabar bak diyé. Hétunot Fitor ottu hotá waán monot uiṭṭé ziyán Isá ye íba re hoóil, ki hoilé, “Ratakurá duibar bak dibar age tui Añré tin bar inkar goríbi.” Baade íba ye híyan monot gorí hañdat doijje. ");
INSERT INTO rhgc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Biínna kúb sóore, ḍoóñr imam ókkole murubbi ókkol, alem ókkol edde fótuayi-mujilíc ṭíya lói sólla-mocuwara goijjé; baade ítara Isá re bañdí loizai Filat ore gosáidiye. ");
INSERT INTO rhgc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Filate Isá ttu fusár gorér de, “Tuñí Yohúdi ókkol or Baáñcca níki?” Íba ye yóggwa re zuwabe hoór de, “Ói, tuñí hoór de héndilla.” ");
INSERT INTO rhgc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ḍoóñr imam múne Íbar uore boóut ḍóilla elzam ókkol lagat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Filate Íba ttu abar fusár gorér de, “Tuñí honó zuwab no diba? Soó, itará Tuáñr uore hodún elzam lagar.” ");
INSERT INTO rhgc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Montor Isá ye toóu ar honó zuwab nó deh, híyane Filat taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Azadir-id or októt manúc ókkole ze hodi re hálas gorídito aros goré, Filate hé hodi re hálas gorídito. ");
INSERT INTO rhgc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hé októt Bárabba nam or ezzon manúc ítar sáañti bagi ókkol or fúañti ziyól ot accíl, zetará bagiyai gorér de októt manúc kún goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manúc or dol aái Filat ore aros gorát doijje de, nizor niyom mozin ítara lla goittó. ");
INSERT INTO rhgc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Filate ítara re zuwabe hoór de, “Tuáñra ttu yián monehoór ne, añí tuáñrar hañse Yohúdir Baáñcca wa re hálas gorídi de híyan?” ");
INSERT INTO rhgc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kiyólla-hoilé yóggwa ye zainto de, ḍoóñr imam ókkole Isá re yóggwar hañse hásorot góri gosáidiye deh. ");
INSERT INTO rhgc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Montor ḍoóñr imam ókkole manúc or dol ore uskaidiyé, zeéne Filate Isár bodol Bárabba re hálas goríde. ");
INSERT INTO rhgc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Filate abar ítara re zuwabe hoór de, “Tóoile, zibá re tuáñra Yohúdir Baáñcca hoó Íba re añí kii goittám?” ");
INSERT INTO rhgc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ítara abar guzori hoór de, “Íba re kúruc ot dífelo!” ");
INSERT INTO rhgc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Montor Filate ítara re hoór de, “Kiyá, Íba ye kii bura goijjé dé?” Toóu ítara aró guzori-guzori hoór de, “Íba re kúruc ot dífelo!” ");
INSERT INTO rhgc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Filate manúc or dol ore kúci gorár eradaye Bárabba re ítarar hañse hálas gorídiye; aar Isá re coóñk marabai baade, kúruc ot dí bolla gosái dífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Baade fóous ókkole Isá re Praiṭoriyum hoó de razmohól or bútore loigiyé, aar ṭeérang ṭíya re ḍaki zoma goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ítara Íba re bayoinna rong or eggwá zubba fiñdáidiye, aar keñṛar eggwá tas banai Íbar matát diyaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Baade ítara Íba re endilla sólam gorát doijje, “Héy Yohúdi ókkol or Baáñcca, Toré sólam!” ");
INSERT INTO rhgc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ítara eggwá laṛí lói Íbar matá sai marat accíl edde Íba re sép maijjíl, aar añṛú félai Íba re sóida goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ítara Íba re técerai baade, Íba ttu bayoinna rong or zubba wa kúlifelai Íbar hoor Íba re fiñdáidiye; tarfore Íba re kúruc ot dí bolla baáre loigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kureni cóor or Sáimon nam or ezzon manúc gang zaga ttu aiyér de októt hé foñt báy zaar. Yóggwa accíl Alexzendar edde Rufus or baf. Isár kúruc can boói loizai bolla fóous suné yóggwa re mojbur goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Fore ítara Íba re Golgota zagat ainné, ziyán or torjuma óilde Matár Malar Zaga. ");
INSERT INTO rhgc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Héṛe ítara Íba re mur hoó de híin miyáiya anggur or roc diiyé, montor Íba ye híin ná háa. ");
INSERT INTO rhgc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baade ítara Íba re kúruc ot dífelaiye, aar Íbar hoorsuor ítarar bútore bák goijjé; har bák ot kii fore sai bolla ítara loṭári maijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Héñtte biínna now wa beh baijjíl, zeñtté ítara Íba re kúruc ot díyl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Íbar ze hosúri sáainbúṭ maridiye híyan óilde, “Yohúdi ókkol or baáñcca.” ");
INSERT INTO rhgc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Íbar fúañti ítara dui zon ḍahañit ore yó kúruc ot díyl, ezzon ore Íbar den ḍák ottu edde ar ezzon ore Íbar ban ḍák ottu. ");
INSERT INTO rhgc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Híyane pak-kalam or yián fura óiye, “Íba re hosúrbon ókkol or fúañti gona giyéh.” ");
INSERT INTO rhgc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Zetará hé foñt báy zaar, ítara matá lari-lari Íba re técerai hoór de, “Há! Tui toh baitul-mukaddos báñgi tin din or bútore abar banaidoya, ");
INSERT INTO rhgc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","yala Tui kúruc ottu lami Nizoré Nize basa sái!” ");
INSERT INTO rhgc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Héndilla góri ḍoóñr imam ókkole edde alem ókkole yó ṭátṭai gorí hoór de, “Ibá ye toh oinno zon ore basaitó, montor Nizoré Nize de basai no farer! ");
INSERT INTO rhgc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E Mosih, Isráil or Baáñcca yala kúruc ottu lami aiyóuk, zeéne añára dekí iman aní fari.” Zetará re Íbar fúañti kúruc ot díya gíyeh, ítara yó Íba re beizzoti goijjé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Baade zeñtté duúñijja baró wa baijjé, héñtte lóti tin nwá báze fán guñṛa mulluk andár ói accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tin nwá baijjé de októt Isá ye eggwá ḍoóñr abase guzori hoór de, “Elói, Elói, lamá sabakhṭáni?” ziyán or torjuma óilde, “Ó Añr Alla, ó Añr Alla, Tuñí Añré kiyólla sáridiyo?” ");
INSERT INTO rhgc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ḍáke tíyai accíl de ítara hodúne híyan fúni hoór de, “Soó, Ibá ye Eliyas ore ḍaker!” ");
INSERT INTO rhgc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hétunot ekzone duñri zai sírkat ekkán esfónj buraiye, baade ekkán súañr matát bazáidi Isá re hái bolla diiyé, aar hoór de, “Tíyo, Ibá re Eliyase basaitó aiyé né saái.” ");
INSERT INTO rhgc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Baade Isá ye eggwá ḍoóñr guzoran mari entehal óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hétunot baitul-mukaddos or foroda gán uottú lóti nise foijjonto fáṛi dui bák óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ze Romi cáap Isár muúntu tíyai accíl, yóggwa ye Isá hondilla gori entehal óigiyoi de dekí hoór de, “Sóiyi e Manúc cwa Allar Fua accíl!” ");
INSERT INTO rhgc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Héṛe hodún beṛiyáin óu dur ottu góri saái táikke de accíl. Ítarar bútore Moriyam Makdálini, cóñṛo Yakub or edde Yosés or maa Moriyam, edde Salómi yó accíl; ");
INSERT INTO rhgc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","zetará yó Isá Galil ot táite Íbar fisá dori Íba re hédmot goijjíl. Héṛe aró boóut beṛiyáin óu accíl zetará Íbar fúañti uore Jerúsalem ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hé din accíl entezam-or-din, yáni ebaadot-or-din or agor din. Hé din háñzinna óiye rár, ");
INSERT INTO rhgc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aramátiya cóor or Yusúf, zibá fótuayi-mujilíc or ézzon namdár manúc aar Allar raijjo lla entezar gorí accíl, yóggwa ye hímmot góri Filat or hañse zai Isár lac cwa maiggé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Isá morigiyói de híyane Filat taajup óigiyoi. Yóggwa ye cáap pwá re matai Isá morigiyói de ói né fusár goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yóggwa ye cáap pwá ttu fakkagori baade, Yusúf ore lac cwa diifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusúfe ekkán hohón or hoor kinné, aar lac cwa lamai hoor gán berái yore, cíl kúñdi banaiyé de eggwá hobor or bútore raikké. Baade hobor gwar muk ot ekkán cíl ouzaydiyé. ");
INSERT INTO rhgc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Isár lac cwa hoṛé rakér de híyan Moriyam Makdálini ye edde Yosés or maa Moriyame saái táikkil. ");
INSERT INTO rhgc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ebaadot-or-din fúraigiyoi rár, Moriyam Makdálini ye, Yakub or maa Moriyame, edde Salómi ye kúcbo mosólla ókkol kinné, zeéne ítara aái Isár lac ot dii fare. ");
INSERT INTO rhgc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ítara háftar foóila din biínna kúb sóore beil uṛér de októt, hobor ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ítara ezzon ore ezzone hoór de, “Añára lla hobor or muk ottu cíl lan hone laribó?” ");
INSERT INTO rhgc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Montor ítara uormikká saiyé rár dekér de, cíl lan larifelaiya. Híyan bicí ḍoóñr accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ítara hobor or bútore góille rár, dóla hoor findá ek juwan manúc den ḍák ottu boiṛá deikké, híyane ítara bicí ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Montor yóggwa ye ítara re hoór de, “No ḍooraiyó; tuáñra Isá Nasári re tuwoór deh, zibá re kúruc ot dí mariféla gíyl. Íba zinda óigiyoi; Íba eṛé nái. Íba re raikkíl de zaga gán soó. ");
INSERT INTO rhgc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yala zoo, Íbar cárit tun ore edde Fitor ore hoógoi de, ‘Íba tuáñrar age Galil ot zaar. Tuáñra Íba re héṛe dekíba, zendilla Íba ye tuáñra re hoóil.’ ” ");
INSERT INTO rhgc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ítara hafi-hafi edde ammúke hobor ottu neeli duñrdiyé. Ítara honókiyo re kessú nó hoó, kiyólla-hoilé ítara ttu kúb ḍoor láigge. ");
INSERT INTO rhgc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Háftar foóila din biínna sóore Isá mora ttu zinda óizaygoi baade, age Moriyam Makdálini re dahádiye, zibár bútottu Íba ye háñt twa bút neeláil. ");
INSERT INTO rhgc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Híba ye zai, Isár fúañti accíl de ítara re hóbor díye, héñtte ítara ferecani zahér gorát edde hañdahaṛi gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Isá zinda de edde Moriyame Íba re deikké de fúni ítara biccác nó goré. ");
INSERT INTO rhgc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yárbaade Isá ye arek ḍoilla súrote ítara ttu dui zon ore dahádiye, zeñtté tará áñṛi-áñṛi farar híkka zaat accíl. ");
INSERT INTO rhgc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tará zai badbaki gún ore hóbor díye, montor ítara tará re yó biccác nó goré. ");
INSERT INTO rhgc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Fore Isá ye egaro zon cárit tun ore dahádiye, héñtte ítara hána háat accíl. Íba ye ítara re ítarar nabiccác edde dil dorór zoriya jéjjeṛaiye, kiyólla-hoilé Íba zinda óizaygoi baade zetará Íba re deikkíl tará re ítara biccác nó goré. ");
INSERT INTO rhgc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Íba ye ítara re hoór de, “Tuáñra fura duniyait zoo, zai manúc beggún or hañse kúchóbor tobolik gorógoi. ");
INSERT INTO rhgc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Zee niki iman aní bápṭisma loh, yóggwa ye nejat faibo; montor zee niki iman nu ané, yóggwa hosúrbon ṭóoribo. ");
INSERT INTO rhgc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Zetará iman ainné, ítara re e keramot iín goríbar toóufik diiya zaybo: Añr name ítara bút ókkol dáfaibo; gabi zubane hotá hoibó; ");
INSERT INTO rhgc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ítara nizor áte háf ókkol tulí dóribo; zodi ítara moot goré de kessú háifele, ítarar honó háni no óibo; aar ítara biyaraimmar gaat át dilé, tará gom óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Malik Isá ttu ítara re híin beggún hoiyá ói baade, Íba re asman ot tulífela gíyeh, aar Allar den ḍák ottu boói táikke. ");
INSERT INTO rhgc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Baade ítara neeli zai hárr zagat tobolik goijjé. Malike ítara re lói ham gorí Íbar kalam sóiyi de híyan ítara re diiya giyéh de keramot or duara sábut gorát accíl.");
INSERT INTO rhgc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Zettót boóut zone ziín-ziín añárar dormiyan ot óiye híin or baabute lekí bolla meénnot gorát doijje, ");
INSERT INTO rhgc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","zendilla uitará añára re zanaiyé zetará foóila cúru ttu lóti nizor suké deikké edde kalam or háadem accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hétolla, ó izzotdár Tiyofílas, añí yó híin beggún ore cúru ttu lóti cúndorgori tahákit gorí baade tuáñr hañse híin ekkán-ekkán góri lekón gom óibo de báippi, ");
INSERT INTO rhgc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","zeéne tuñí ze hotá gún or taalim faiyó, híin furafuri sóiyi de zano. ");
INSERT INTO rhgc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yohúdiya elakar baáñcca Hérud or hale, Abíya dol or imam ókkol or bútore Zakaríyah nam or ézzon imam accíl. Yóggwar bou óilde Aron or nosól or mayafua, híbar nam Elízabet. ");
INSERT INTO rhgc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ítara duní zon Allar nozor ot forhésgar accíl, zetará Mabud or tamám hókum ókkol edde niyom ókkol mozin behosúr góri soilto. ");
INSERT INTO rhgc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lekin ítara ttu fuain nu accíl, kiyólla-hoilé Elízabet báz accíl, aar ítara duní zon bicí burá óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ek din zeñtté Zakaríyah ye nizor dol or háin mozin Allar muúntu imami ham goittó aiccé, ");
INSERT INTO rhgc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","imami ham or niyom mozin loṭári mari yóggwa re basílowa gíyeh, Mabud or baitul-mukaddos ot góli agórbatti zolai bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Héñtte agórbatti zolaibár októt baáre bicí manúc ókkol dua gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hétunot Mabud or ek fírista agórbattir-gáñr den ḍák ottu tíyai yóggwa re dahádiye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Íba re dekí Zakaríyah songki uiṭṭíl, edde bicí ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Montor fírista wa ye yóggwa re hoór de, “Ó Zakaríyah, no ḍooraiyó; Alla ye tuáñr dua fúinne. Tuáñr bou Elízabet ottu eggwá morotfua óibo, aar tuñí íbar nam Yaháya rakíba. ");
INSERT INTO rhgc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tuáñr ttu kúcir uore kúci tákibo, aar íbar zormoye boóut manúc ókkol kúci óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kiyólla-hoilé íba Mabud or nozor ot muhán óibo; íba ye no anggur or roc or córab háibo aar no nicá háibo, íba maar feṛot tákite lóti Pak-Ruh lói furaiya óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aar Íba ye boóut Boni Isráil ókkol ore Mabud ítarar Allar hañse fírai aníbo. ");
INSERT INTO rhgc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Íba ye Eliyas or ruh edde taakote Malik or age-age zaibo; zai baf ókkol or dil fuain dor híkka aar nafórman ókkol ore forhésgar or demak or híkka fíraibo; héndilla gorí Mabud olla nal goijjá eggwá koum toiyar goríbo.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaríyah ye fírista wa re hoór de, “Añí híyan keéngori ekin goittám? Añí de ézzon burá manúc, aar añr bou ottu yó bicí boc óigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Fírista wa ye yóggwa re zuwabe hoór de, “Añí óilam de Jibrail, zibá Allar muúntu tíyai táki; añré tuáñr llói hotá hoói bolla edde tuáñr hañse e kúcir hóbor gán foóñsai bolla difeṛá gíyeh deh. ");
INSERT INTO rhgc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aar soó, zetódin foijjonto iín fura nó óiyo, hétodin tuñí buk tákiba, aar mati no faribá, kiyólla-hoilé tuñí toh añr hotá gún ekin nó goró, ziín ṭík októ ailé fura óibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Héñtte manúc ókkole Zakaríyah lla entezar gorí táikkil, aar yóggwa baitul-mukaddos ottu aité deri ór bóuli ítara báfat forigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zeñtté yóggwa baáre aiccé, yóggwa ye ítara llói mati nó fare. Hétunot ítara zani faijjé de, yóggwa ye baitul-mukaddos ot dorcón deikké. Yóggwa ye ítara llói icára gorí-gorí hotá howát accíl, aar buk táigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zeñtté yóggwar imami ham or din fúraigiyoi, yóggwa nizor gór ot waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fore yóggwar bou Elízabet hámil óiye, aar híba ye nizoré fañs mac foijjonto aiddone raikké, endilla hoói, ");
INSERT INTO rhgc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ze din ókkol ot Mabude añr córom ore maincór ttu dur gorífelai bolla añr uzu nozor diyé, héñtte Íba ye añr lla yián goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sów mac soler de októt, Alla ye Jibrail fírista re Galil or Nasárat nam or ekkán cóor ot ");
INSERT INTO rhgc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","eggwá kuwári mayafuar hañse difeṛáiye, zibár zuragatá Dawud or nosól or Yusúf nam or ézzon manúc lói óoil. Hé kuwári mayafuar nam Moriyam. ");
INSERT INTO rhgc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fírista wa híbar hañse aái hoór de, “Tuáñre sólam, tuñí zibár uore ḍoóñr rahámot óiye. Mabud tuáñr fúañti asé.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Montor híyan fúni híba ebbe alabúlat forigiyói, aar yibá hondilla sólam hoi báfat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Fírista wa ye híba re hoór de, “Ó Moriyam, no ḍooraiyó, kiyólla-hoilé tuáñr uore Allar rahámot óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fúno, tuñí hámil óiba, aar tuáñr ttu eggwá Morotfua óibo, tuñí Íbar nam Isá rakíba. ");
INSERT INTO rhgc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Íba muhán óibo, aar Íba re Alla Tálar Fua howá zaybo. Mabud Alla ye Íba re Íbar baf Dawud or toktó diibo. ");
INSERT INTO rhgc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Íba ye Yakub or nosól or uore abadulabad hókumot goríbo, aar Íbar raijjo honódin hótom no óibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Moriyame fírista wa re hoór de, “Híyan keéne óibo? Añí de aijjó kuwári.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Fírista wa ye híba re zuwabe hoór de, “Pak-Ruh tuáñr uore aibó, aar Alla Tálar kudurut or sába tuáñr uore foribó, hétolla tuáñr ttu óibo de hé pak Fua re Allar Fua howá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Soó, tuáñr egana Elízabet ottu yó híbar burá bocót fua feṛot óiye, híba zibá re niki báz howá zayto híba ttu yala sów mac soler. ");
INSERT INTO rhgc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kiyólla-hoilé Alla ye no fare de toh kessú nái.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tói Moriyame hoór de, “Soó, añí Mabud or bañdi; añr uore tuñí zeén hoiyó héen óuk.” Baade fírista wa híbar héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yárbaade Moriyam nal ói toratori faári elakat Yohúdahr ekkán cóor ot giiyé, ");
INSERT INTO rhgc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","aar Zakaríyahr gór ot góli Elízabet ore sólam díye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Zeñtté Elízabete Moriyam or sólam fúinne, híbar feṛot fua wa fáldi uiṭṭé, aar Elízabet Pak-Ruh lói furaiya óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tarfore híba ye ḍoóñr-ḍoóñr góri hoór de, “Mayafuain dor bútore tuñí beh mubarek, aar tuáñr feṛor fua wa yó mubarek! ");
INSERT INTO rhgc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aar añr uore eén rahámot kiyá óiye, zeén níki añr Malik or maa añr héṛe aiccé? ");
INSERT INTO rhgc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kiyólla-hoilé fúno, añr hane tuáñr sólam fúinne mottor, añr feṛot fua wa kúciye fáldi uiṭṭé. ");
INSERT INTO rhgc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ubá hotó mubarek, zee niki biccác goré de, Mabude híba re ziín hoiyé híin fura óibo!” ");
INSERT INTO rhgc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Moriyame hoór de: “Añr kollófe Mabud or taarif gorér, ");
INSERT INTO rhgc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","aar Alla añr Nejatdoya re lói añr ruh kúci óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kiyólla-hoilé Íba ye toh Íbar bañdir niróc tokkar uzu nozor diyé, hétolla, soó, yala lóti añré mubarek hoibó nosól beggúne. ");
INSERT INTO rhgc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kiyólla-hoilé zibá Taakotwala Íba ye goijjé añr lla ḍoóñr-ḍoóñr ham, pak Íbar nam. ");
INSERT INTO rhgc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ḍoora zetará Íba re, Íbar rahámot zari táke ítarar nosóle-nosóle. ");
INSERT INTO rhgc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nizor ḍuwáñ lói Íba ye ḍoóñr-ḍoóñr ham goijjé, aar dile-dile zetará nizoré ḍoóñr báfe ítara re cíñṛaciñṭṭá gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Íba ye toktó ttu lamaidiyé hókumot-goróya ókkol ore, montor uoror tokkat goijjé niróc cún ore. ");
INSERT INTO rhgc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Búka ókkol ore Íba ye gom jiníc lói bóraidiye; montor tuangor ókkol ore háli áte duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Íba ye Nizor gulam Isráil ore modot goijjé, Íbar oh rahámot monot rakí yore, ");
INSERT INTO rhgc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ziyán tákibo abadulabad Ibrahím edde íbar nosól ókkol or uore, zendilla hoóil Íba ye añárar bafdada ókkol ore.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Moriyam tin mac hañsáhañsi Elízabet or fúañti táki baade nizor gór ot waafes aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Zeñtté Elízabet ottu fua zormo dibar októ aiccé, híba ttu eggwá fua óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mabude híbar uore ḍoóñr rahámot goijjé de híyan híbar atehañsór maincé edde egana-guiccí ye fúni, ítara híbar fúañti kúci goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Baade eén óiye, ítara añcṭo din ot din fua wa re ázomi goráito aiccé, aar ítara fua war nam baf or nam or ḍóilla Zakaríyah rakíto saáil. ");
INSERT INTO rhgc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Montor íbar maa ye hoór de, “No, itar nam raká zaybo de Yaháya.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ítara híba re hoór de, “Tuáñr egana-guiccír bútore de hé nam honókiyo ttu nái.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tarfore ítara baf ore icára gorí, fua war nam kii rakíto monehoór de saáil. ");
INSERT INTO rhgc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yóggwa ye ekkán lekíbar siz magai yore híyan ot leikké de, “Tar nam Yaháya.” Híyane ítara beggún taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aar éhon or bútore yóggwar muu kúligiyoi edde zir eridiya óigiyoi, baade yóggwa ye mati faijjé aar Allar taarif gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ítarar atehañsór manúc beggún ḍooraigiyói, aar Yohúdiyar faári elakar agagurat maincé híin or baabute howáhoi gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Zetará hé hotá gún fúinne ítara híin dile-dile rakí báfer de, “Tóoile e fua wa hondilla óibo?” Kiyólla-hoilé Mabud or át íbar uore accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Baade íbar baf Zakaríyah ye Pak-Ruh lói furaiya ói agun hotá hoór de: ");
INSERT INTO rhgc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Taarif óuk Isráil or Mabud Allar, kiyólla-hoilé Íba aái azad goijjé ze bonda Íbar. ");
INSERT INTO rhgc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Íba ye Nizor gulam Dawud or nosól ottu añára lla taakotwala Nejatdoya tuillé, ");
INSERT INTO rhgc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","zendilla Íba ye boóut age lóti hoóil Nizor pak nobi ókkol or muké; ");
INSERT INTO rhgc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ki hoilé, añára re basa zaybo añárar duccon ókkol ottu edde añára re nafórot-goróya beggún or át ottu; ");
INSERT INTO rhgc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","añárar bafdada ókkol or uore rahám gorí bolla edde Nizor pak razinama re yaad rakí bolla, ");
INSERT INTO rhgc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","yáni sóon waán ore ziyán Íba ye goijjíl añárar baf Ibrahím lói, ");
INSERT INTO rhgc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","añára re añárar duccon ókkol or át ottu basai honó ḍoor sára Íbar ebaadot gorá baitó, ");
INSERT INTO rhgc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Íbar muúntu paki edde forhésgarir sáañte añárar zindigibór. ");
INSERT INTO rhgc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ó añr fua, toré ḍaha zaybo de Alla Tálar nobi, kiyólla-hoilé tui Malik or rasta toiyar gorí bolla Íbar age-age zaibi, ");
INSERT INTO rhgc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","zai tui Íbar bonda ókkol ore guná maf fai yore nejat faibar zankari dibi, ");
INSERT INTO rhgc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","añárar Allar meérbani edde raháme uottú Beil or Foór aibó añárar hañse, ");
INSERT INTO rhgc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","foór dí bolla uitará re zetará andár ot edde moot or sábat asé, edde cántir rastat loizai bolla añárar ṭéng or fata re.” ");
INSERT INTO rhgc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Baade fua wa ḍoóñr óiye edde ruht mazé mozbut óiye, aar Boni Isráil ókkol or hañse kúlamela góri dahá nó dé foijjonto íba moidan elakat táikkil. ");
INSERT INTO rhgc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hé din ókkol ot eén óiye, Rom or baáñcca Agástas or torfóttu hókum zari óiye de, yóggwar fura raijjor manúc beggún or seráng gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yíba óilde foóilabar or seráng, zibá Kurinias Siíriya mulluk or hákim accíl de héñtte gorá gíyl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tói manúc beggúne nam lekái bolla zar-zar cóor ot tee-tee zaat doijjil. ");
INSERT INTO rhgc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Héndilla, Yusúf óu Galil or cóor Nasárat ottu neeli, uore Yohúdiya elakat Dawud or cóor Betélhem hoó de híyan ot giiyé, kiyólla-hoilé Yusúf óilde Dawud or háandan ottu edde nosól ottu. ");
INSERT INTO rhgc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Héṛe giiyé de, yóggwar zuijja bou Moriyam or fúañti nam lekái bolla; héñtte híba hámil accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ítara héṛe tákite, híba ttu fua hálas óibar din furafuri aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tói híba ye híbar foóila-fua morotfua zormo diyé. Híba ye Fua wa re hoor berái hánḍail ot neṛai raikkíl, kiyólla-hoilé héṛe ítara lla musáfer-hánat honó zaga nu accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hé elakat hodún sóol-soroya accíl, zetará raitta kílat táki ítarar sóol or zák sooñi gorí accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Asimbit Mabud or ek fírista ítarar muúntu tíyaiye, aar Mabud or tozolli ítarar sairókul ttu soimké. Ítara bicí hoilé bicí ḍooraigiyói, ");
INSERT INTO rhgc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","montor fírista ye ítara re hoór de, “No ḍooraiyó, kiyólla-hoilé soó, añí tuáñrar hañse kúcir hóbor ainní, ziyáne tamám manúc ókkol ore bicí kúci goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aijja Dawud or cóor ot tuáñra lla eggwá Nejatdoya zormo óiye; Íba óilde Mosih hé Malik. ");
INSERT INTO rhgc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tuáñra Íba re e nicáne siní faribá: eggwá dud or Fua re hoor beráiya, urar hánḍail ot neṛaiya loot faiba.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hétunot hé fírista war fúañti asimbit ek zák asmani fóous dahádiye, ziíne Allar taarif gorí-gorí hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ebbe uore asman ot Allar taarif óuk, aar zobin ot ze manúc ókkol lói Íba kúci, ítarar bútore cánti óuk.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Fírista gún ítarar héntu asman ot giiyói rár, sóol-soroya gúne ezzon ore ezzone hoór de, “Aiyó, añára Betélhem ot zai, aar ziyán óiye bóuli Mabude añára re zanaidiyé híyan saáigoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Baade ítara toratori aái Moriyam edde Yusúf ore deikkíl, aar Fua wa re hánḍail ot neṛaiya loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Zeñtté ítara Fua wa re deikké, ítara re Fua war baabute ziín howá gíyl híin agagura zanaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aar sóol-soroya gúne hoiyé de híin zedúne fúinne ítara beggún ammúk óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Montor Moriyame hotá híin beggún dil ot gañtí rakí híin báfi-báfi accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sóol-soroya gúne ítara re howá gíyl de mutafek beggún fúni edde dekí Allar mohíma edde taarif gorí-gorí waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Añcṭo din furaiyé rár, Fua wa re ázomi goráibar októt, Íbar nam Isá raká gíyeh, ze nam mán fírista ye Íba feṛot óibar age lóti dyíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Baade zeñtté Muúsar Córiyot mozin Yusúf edde Moriyam pak-sáf óibar din aáigiyoi, ítara Isá re Mabud or hañse peec gorí bolla uore Jerúsalem ot ainné. ");
INSERT INTO rhgc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Zendilla Mabud or Córiyot ot leikká asé de ki, “Foóila fua zodi morotfua óile, íba re Mabud olla pak gorífela foribó.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Edde kurbani di bolla oh mozin zendilla Mabud or Córiyot ot hoiyé, ki hoilé, “Ek zur hoóñl yáh duwá hoitor or basa.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hé októt héṛe Jerúsalem ot Símiyon nam or ézzon manúc accíl, forhésgar edde dindár, zibá Boni Isráil ókkol or tosóllir októr entezar ot accíl; aar yóggwar uore Pak-Ruh accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yóggwa re Pak-Ruh ye zahér goijjíl de, Mabud or Mosih re dekíbar age yóggwar moot no óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pak-Ruhr hédaiyote yóggwa baitul-mukaddos ot aiccé, aar zeñtté bafmaa ye gura Fua Isá re Córiyot or niyom mozin ziín gorá fore híin goittó bútore ainné, ");
INSERT INTO rhgc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Símiyone Isá re fatáijja kul ot looi eén hoói Allar taarif goijjé: ");
INSERT INTO rhgc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ó Malik, Tuñí Tuáñr hotá mutafek Tuáñr gulam ore yala cántir sáañte zaito dor, ");
INSERT INTO rhgc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kiyólla-hoilé añr suké Tuáñr nejat dekífelaiye, ");
INSERT INTO rhgc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ziyán Tuñí tamám manúc ókkol or cáikkat toiyar goijjó. ");
INSERT INTO rhgc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Híyan toh Beyohúdi ókkol or hañse Tuáñr moncá zahér goríbar ekkán nur, aar híyan óilde Tuáñr koum Boni Isráil or izzot.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Isár baabute ziín howá gíyeh, híin fúni Íbar bafmaa taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Baade Símiyone ítara re dua diyé, aar Íbar maa Moriyam ore hoór de, “Soó, e Fua wa re basílowa gíyeh de, Boni Isráil or boóut zon ore félai bolla edde tulí bolla, edde endilla ekkán nicán ói bolla ziyán or muhálef gorá zaybo, ");
INSERT INTO rhgc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","zeéne boóut dil or kolfona ókkol zahér óizagoi. Héñtte tuáñrar kollóf óu ekkán súri lói gañtá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Héṛe Acer or háandan or Anna nam or eggwá ambiya accíl, zibá Fanuel or zérfua. Híba ttu bicí boc óigilgoi, híba biyá gorí hócom or fúañti háñt bosór beh táikkil, ");
INSERT INTO rhgc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","baade lóti rarir zindigi haṛaité-haṛaité híbar boc ací-sair bosór óiye. Híba baitul-mukaddos ottu honó mikká no zaito, bólke ruza rakí edde dua gorí-gorí raite dine ebaadot gorát tákito. ");
INSERT INTO rhgc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hétunot híba aái Allar cúkur gorát doijje, aar uitará beggún ore Fua war baabute howát doijje zetará Jerúsalem or azadir entezar ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Baade zeñtté Yusúf edde Moriyame Mabud or Córiyot mutafek hárr kessú gorífelaiye, ítara Galil ot nizor cóor Nasárat ot waafes aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Baade Fua wa giyan or sáañte ḍoóñr ówat edde mozbut ówat accíl; aar Allar rahámot Íbar uore accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isár bafmaa fottí bosór Azadir-id olla Jerúsalem ot zaito. ");
INSERT INTO rhgc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Zeñtté Íba baró bosór óiye, ítara hé niyom mozin héṛe id ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Id fúrai baade ítara waafes aáizargoi de októt, Fua Isá Jerúsalem ot táigiyoi; montor Íbar bafmaa ye hoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bólke Isá manúc or dol or bútore asé bóuli ṭáari ítara ek din or foñt ot giiyégoi, baade ítara nizor egana-guiccí edde sinforiso maincór bútore Íba re tuwat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Zeñtté ítara Íba re tuwai nó faa, Íba re tuwai-tuwai Jerúsalem ot waafes giiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tin din baade ítara Íba re baitul-mukaddos ot alem ókkol or mazé boói ítarar hotá fúner de edde ítara re súwala-súwali gorér de loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aar zetará Íbar hotá fúinne, ítara beggún Íbar buzáye edde zuwabe taajup óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zeñtté Íbar bafmaa ye Íba re deikké, ítara ammúk óigiyoi. Maa ye Íba re hoór de, “O Fut, Tuñí añára llói héndilla kiyá goijjó? Soósai, Tuáñr baf loi añí loi sinta gorí-gorí Tuáñre tuwat así.” ");
INSERT INTO rhgc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Isá ye ítara re hoór de, “Tuáñra Añré tuwoór kiyá? Tuáñra no zano né, Añr ttu Añr Baf or gór ot tákar zorur dé?” ");
INSERT INTO rhgc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Montor Íba ye ítara re ziyán hoiyé híyan ítara nó buzé. ");
INSERT INTO rhgc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Baade Íba ítarar fúañti bacá lói nise Nasárat ot waafes aiccé, aar ítarar hotá mani soillíl. Aar Íbar maa ye hotá híin beggún nizor dil ot gañtí raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isá giyane edde gaafiṛé, Allar edde manúc or muhábbote barí uṛát accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibiriyus Káisar or hókumot fundóro bosór soler de októt, zeñtté Pontiyus Filat accíl de Yohúdiyar hákim, aar Hérud accíl de Galil or hókumot-goróya, yóggwar bái Filíp accíl de Itúriyar edde Trakonitis elakar hókumot-goróya, Laiséniyas accíl de Abilenir hókumot-goróya, ");
INSERT INTO rhgc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Boro imam accíl de Hánan edde Káiyafas, héñtte Allar kalam moidan elakat Zakaríyahr fua Yaháyar hañse nazil óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tói yóggwa Jordán hál or sairókul or elaka beggún ot zai tobolik gorér de, gunár maf fai bolla touwá gorí bápṭisma loito. ");
INSERT INTO rhgc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zendilla nobi Yesáyahr kitab ot leikká asé: “Moidan zagat ezzone guzori-guzori eén hoór, ‘Mabud or foñt toiyar goró, Íbar rasta uzu goró. ");
INSERT INTO rhgc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Fottí gúna bóra zaybo, fottí faár edde murá fúwan gorá zaybo. Behañsúra foñt ókkol uzu gorá zaybo, ṭeéilameila rasta ókkol fúwan gorá zaybo, ");
INSERT INTO rhgc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","aar fura insán zati ye Allar nejat dekíbo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hétunot yóggwa ye zetará yóggwa ttu bápṭisma loito aiccé ítara re hoór de, “Ó háf or fuain ókkol! Aibár gozzob ottu dáizayboi lla tuáñra re hone úñciyari díye? ");
INSERT INTO rhgc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Touwá lói mil há de héndilla gulagala ókkol dóro, aar nizor dil ot endilla howát no doijjo de ki, ‘Añára ttu toh baf ísafe Ibrahím asé.’ Añí tuáñra re hoóir, Alla ye sailé e cíl lun ottu yó Ibrahím olla fuain foida gorí fare. ");
INSERT INTO rhgc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aar ehón toh gas or gurat kuróil raká gíyeh. Hétolla, ze gas ot gom gula no dóre, yíba re haṛi ooin ot félaidiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Manúc cúne yóggwa ttu fusár gorér de, “Tóoile añára ttu kii gorár zorur?” ");
INSERT INTO rhgc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yóggwa ye ítara re zuwabe hoór de, “Zar ttu duwá kuruta asé, íte nái de ítare eggwá doo, aar zar ttu hána asé, íte yó héndilla goró.” ");
INSERT INTO rhgc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Házana-tulóya ókkol óu bápṭisma loito aiccé; ítara yóggwa re hoór de, “Úzur, añára ttu kii gorár zorur?” ");
INSERT INTO rhgc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yóggwa ye ítara re hoór de, “Ain ot asé de yár túaro barái no loiyo.” ");
INSERT INTO rhgc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Héndilla, fóous ókkole yó yóggwa ttu fusár gorér de, “Añára ká, añára ttu kii gorár zorur?” Yóggwa ye ítara re hoór de, “Kiyó ttu dómki dí kessú no loiyo, honókiyor uore misá elzam no lagaiyó, nizor muzuri loi kúci táikko.” ");
INSERT INTO rhgc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Zeñtté manúc cún acár hálot ot accíl, aar ítara beggúne nizor dile-dile Yaháyar baabute báfat accíl de, yóggwa Mosih ói né no, ");
INSERT INTO rhgc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","hétunot Yaháya ye zuwabe ítara beggún ore hoór de, “Añí toh tuáñra re fanít éna bápṭisma díh; montor zibár tokka añr túaro ḍoóñr Íba aiyér; añí Íbar cenṭár or fíta kúli bolla úddwa laayek no. Íba ye tuáñra re Pak-Ruh edde ooin loi bápṭisma díbo. ");
INSERT INTO rhgc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Íba ttu Nizor kula Nizor át ot asé, Nizor hóñla re cúndorgori sáf gorí bolla edde giyuñ ókkol ore dolagorí gudam ot rakí bolla; montor Íba ye suwa gún ore honódin no nifé de ooin ot furat difélaibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Héndilla aró boóut nosíyot ókkol lói Yaháya ye maincór hañse kúchóbor tobolik goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lekin hókumot-goróya Hérude nizor bái or bou Hérudias ore biyá goijjíl de hétolla edde yóggwa ye ze bura ham ókkol goijjíl híin beggún olla zeñtté Yaháya ye yóggwa re bóṭboṛáiye, ");
INSERT INTO rhgc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","tói yóggwa ye hé bura ham beggún ot aró ekkán baráiye, híyan óilde, yóggwa ye Yaháya re ziyól ot bon gorí raikké. ");
INSERT INTO rhgc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zeñtté manúc beggúne bápṭisma loiyé, Isá ye yó bápṭisma loiyé. Íba dua gorér de októt asman kúligiyoi, ");
INSERT INTO rhgc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aar Pak-Ruh hoitor or ḍóilla jisím or súrote Íbar uore lami aiccé. Aar asman ottu eggwá abas aiccé de, “Tuñí Añr adorja Fua, Añí Tuáñre lói bicí kúci.” ");
INSERT INTO rhgc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zeñtté Isá ye Allar ham gorá cúru goijjé, héñtte Íbar boc tokoriban tiríc bosór; maincé ṭáaitto de, Íba Yusúf or fua. Yusúf óilde Hélir fua. ");
INSERT INTO rhgc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Héli Mattát or fua, Mattát Leévir fua, Leévi Melkir fua, Melki Jannair fua, Jannai Yusúf or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusúf Mattatíyas or fua, Mattatíyas Ámos or fua, Ámos Nahum or fua, Nahum Esálir fua, Esáli Naggair fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai Maát or fua, Maát Mattatíyas or fua, Mattatíyas Sémiyir fua, Sémiyi Josék or fua, Josék Jodar fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda Joannar fua, Joanna Resár fua, Resá Zerubabel or fua, Zerubabel Cáltiyel or fua, Cáltiyel Nerir fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melkir fua, Melki Addir fua, Addi Kosám or fua, Kosám Elmadom or fua, Elmadom Er or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Yehócuar fua, Yehócua Eliyazar or fua, Eliyazar Jorim or fua, Jorim Mattát or fua, Mattát Leévir fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leévi Símiyon or fua, Símiyon Yohúdahr fua, Yohúdah Yusúf or fua, Yusúf Jonam or fua, Jonam Eliyakím or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakím Maleyar fua, Maleya Minnar Fua, Minna Mattátar fua, Mattáta Natan or fua, Natan Dawud or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawud Jesir fua, Jesi Obed or Fua, Obed Boaz or fua, Boaz Sálmon or fua, Sálmon Nacon or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nacon Amminadab or fua, Amminadab Admin or fua, Admin Arnir fua, Arni Hisron or fua, Hisron Fares or fua, Fares Yohúdahr fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yohúdah Yakub or fua, Yakub Isahák or fua, Isahák Ibrahím or fua, Ibrahím Térar fua, Téra Nahor or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Sérug or fua, Sérug Rau or fua, Rau Falek or fua, Falek Eber or fua, Eber Cílahr fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cílah Kéinan or fua, Kéinan Arfakcád or fua, Arfakcád Ceém or fua, Ceém Nuhr fua, Nuh Lamak or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamak Matúcilahr fua, Matúcilah Idiris or fua, Idiris Jared or fua, Jared Mahálalel or fua, Mahálalel Kéinan or fua, ");
INSERT INTO rhgc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kéinan Enoc or fua, Enoc Sét or fua, Sét Adom or fua, Adom Allar fua. ");
INSERT INTO rhgc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isá, Pak-Ruh lói furaiya ói Jordán hál ottu waafes aiccé, aar hé Ruhr hédaiyote moidan zagat gúrat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Héṛe Íba re salic din foijjonto Ibilíce entán goijjé. Hé din ókkol ot Íba ye honó kessú ná háa; híin fúrai baade Íba ttu búk laiggé. ");
INSERT INTO rhgc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibilíce Íba re hoór de, “Tuñí zodi Allar Fua de óile, e cíl lwá re ruṭi óizaytoi hókum dóh.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isá ye ítare zuwab der de, “Pak-kalam ot endilla asé, ‘Manúc siríf ruṭi loi base de no.’” ");
INSERT INTO rhgc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tarfore Ibilíce Íba re ekkán uñsol zagat loigiyé, aar éhon or bútore Íba re duniyair tamám raijjo ókkol daháiye. ");
INSERT INTO rhgc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tarfore Ibilíce Íba re hoór de, “Añí Tuáñre yián or fura adíkar edde cáan diifélaiyum, kiyólla-hoilé yián añré diiféla gíyeh, aar añí añr ttu zaré diito monehoó taré dii fari. ");
INSERT INTO rhgc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hétolla zodi Tuñí añré sóida goró, iín beggún Tuáñr óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isá ye ítare zuwab der de, “Pak-kalam ot endilla asé, ‘Tuñí tuáñr Mabud Alla re beh sóida goríba, aar siríf Íbar beh ebaadot goríba.’” ");
INSERT INTO rhgc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Baade Ibilíce Íba re Jerúsalem ot loigiyé, aar baitul-mukaddos or tullit tíyagarai Íba re hoór de, “Tuñí zodi Allar Fua de óile, entú nise záp maro, ");
INSERT INTO rhgc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kiyólla-hoilé pak-kalam ot toh endilla asé, ‘Íba ye Tuáñr baabute Nizor fírista ókkol ore hókum díbo, Tuáñre héfazot gorí bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ítara nizor áte Tuáñre dórifelaibo, zeéne Tuáñr ṭénge honó cíl ot duk no faa.’” ");
INSERT INTO rhgc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isá ye ítare zuwabe hoór de, “Pak-kalam ot endilla asé, ‘Tuñí tuáñr Mabud Alla re entán no goríba.’” ");
INSERT INTO rhgc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Zeñtté Ibilíc ottu hárr ḍóilla entán goijjá óiye, arek mouka nó faa foijjonto Íbar héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Baade Isá Pak-Ruhr kudurute furaiya ói Galil ot waafes aiccé, aar Íbar hóbor héṛiyar sairó ḍák or elakar agagura fóligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Íba ye ítarar mujilíc-hána ókkol ot taalim diyat doijje, aar beggúne Íbar taarif goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Baade Íba Nasárat ot aiccé, zeṛé Íba ḍoóñr óoil, aar Nizor niyom mutafek ebaadot-or-din mujilíc-hánat giiyé, aar telawot goittó tíyaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Íba re nobi Yesáyahr kitab diiya giyéh; aar hé boiṭṭa kitab pwá melí, e zaga gán tuwai loiyé zeṛé leikká asé de, ");
INSERT INTO rhgc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mabud or Ruh Añr uore asé, kiyólla-hoilé Íba ye Añré gorif ókkol or hañse kúchóbor boiyan gorí bolla basíloiye. Íba ye Añré difeṛáiye de, bondi ókkol ore súribar hotá, edde añdá ókkol ore dekíbar hotá elan goittó; aró, zetará zulúm faar ítara re azad goittó, ");
INSERT INTO rhgc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","edde Mabud or meérbanir bosór or elan goittó.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tarfore Íba ye kitab pwá bañdí háadem mwa re waafes diifélai baade boiccé. Aar mujilíc-hánat asé de manúc beggúne Íbar uzu suk lagaidi saái táikke, ");
INSERT INTO rhgc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","zeñtté Íba ye ítara re hoiyé, “Aijja e pak-kalam tuáñra fúnar fúañti-fúañti fura óiye.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Manúc beggúne Íbar nam gorát doijje, aar ze rahámoti hotá Íbar muk ottu neeillé híine ítara taajup óigiyoi. Ítara hoór de, “Ibá Yusúf or fua no níki?” ");
INSERT INTO rhgc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Íba ye ítara re hoór de, “Tuáñra Añré e meésal lan hámaha hoibá de ki, ‘Ḍakṭor, age nizoré gom goró. Tuñí ze ham mún Kaparnahúm ot goijjó de añára fúinni, híin eṛé Nizor farat óu gorí dahó.’” ");
INSERT INTO rhgc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Íba ye tarfore hoór de, “Añí tuáñra re sóiyi hoóir, honó nobi re nizor wotón ot gosé de nái. ");
INSERT INTO rhgc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yián sóiyi de ki, nobi Eliyas or zobanat zeñtté cáro tin bosór fán zór nó deh, edde guñṛa mulluk ot eggwá ḍoóñr raṭ óoil, héñtte Boni Isráil or bútore boóut rari ókkol accíl; ");
INSERT INTO rhgc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","toóu úddwa Eliyas ore ítara honókiyor héṛe difeṛá nó zah, bólke siríf Sídon elakar Zárefat ot asé de eggwá rari mayafuar héṛe beh difeṛá gíyl. ");
INSERT INTO rhgc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Héndilla, nobi Eliyasár zobanat Boni Isráil or bútore boóut kurus biyaraimma ókkol accíl, montor ítara honókiyo re pak-sáf gorá nó zah, bólke siríf Siíriya mulluk or Naman ore beh gom gorá gíyl.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Híin fúni, mujilíc-hánat accíl de manúc beggún guccáye bórigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ítara uṛí Íba re cóor or baárkule neelaiye, aar haindá ttu félaidi bolla Íba re faár or tullit loigiyé, zeṛé uore ítarar cóor banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Montor Íba ítarar mazór ttu neeli héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tarfore Íba nise Kaparnahúm ot giiyé, ziyán ekkán Galil or cóor, aar ebaadot-or-din manúc ókkol ore taalim diyat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Manúc ókkol Íbar taalime ammúk óizaytoi, kiyólla-hoilé Íba ye hotá hoitó de adíkar or sáañte. ");
INSERT INTO rhgc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Héṛe mujilíc-hánat endilla ezzon manúc accíl, zibá nafak bút or jine faiya. Yóggwa ye eggwá ḍoóñr abase guzori hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ó Isá Nasári, añára llói Tuáñr kii ham asé? Tuñí añára re dónco goittó aiccó de né? Añí zani Tuñí hon, Tuñí óilade Allar Pakzon nwá.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Montor Isá ye jin nwá re jéjjeṛai hoór de, “Nizám ó, yoggwár bútottu neelizagói.” Hétunot hé jine yóggwa re beggún or mazé añsár mári edde honó zohóm no gorí yóggwar bútottu neeligiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Híyane manúc beggún taajup óigiyoi, aar ezzon ore ezzone hoór de, “Iín hondilla hotá? Kiyólla-hoilé Íba ye adíkare edde taakote hóraf jin ókkol ore hókum déh aar híin neelizagói!” ");
INSERT INTO rhgc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tói Íbar hóbor hé elakar sairó ḍák or fottí zagat fóligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Baade Isá mujilíc-hána ttu neeli, Sáimon or gór ot giiyé. Héñtte Sáimon or hóuri ttu bicí gaatzor uiṭṭé. Yóggwa re gom gorí bolla ítara Isá re aros goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Íba yóggwar ḍáke tíyai yore gaatzor zaibói lla hókum díye rár, yóggwa ttu gaatzor giiyégoi. Baade yóggwa éhon or bútore uṛí ítara re meémandari gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zeñtté beil gólizargoi, zetará ttu ḍoilla-boḍoilla biyaram ola biyaraimma asé, ítara beggúne tará re Isár hañse ainné, aar Íba ye tará re fottí ekzon or uore át dídi gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Boóut zon ottu bút ókkol óu eén hoói guzori neeillé de asé, “Tuñí óilade Allar Fua!” Montor híine Íba Mosih de siné de hétolla, Íba ye híin ore dómki dí matitó no dito. ");
INSERT INTO rhgc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baade din óiye rár, Isá neeli ekkán bocóti-sára zagat giiyé; aar manúc ókkole Íba re tuwai-tuwai dóijjegai. Ítara Íba re ítarar héntu zaitogói no dito saáil; ");
INSERT INTO rhgc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","montor Íba ye ítara re hoiyé de, “Añr ttu ar cóor ókkol ot óu Allar raijjor baabute tobolik gorár zorur, kiyólla-hoilé Añré hétolla beh difeṛá gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yárbaade Íba Yohúdiyar mujilíc-hána ókkol ot tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ek din zeñtté Isá Genesáret Ḍiír kul ot tíyai accíl, manúc ókkole Íbar sairó ḍak ottu ṭélaṭeli gorí-gorí Allar kalam fúnat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Íba ye ḍiír hañsa loi duiyán noow deikké, ziín ottu zailla ókkole lami ítarar zal dúifelat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Íba héntu ekkán noow ot uiṭṭégoi, ziyán óilde Sáimon or, baade íba re noow gán kul ottu ekkágori duré loizaitó hoiyé. Tarfore Íba boói noow ttu tái manúc ókkol ore taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Zeñtté Íba ttu taalim diya óiye, Íba ye Sáimon ore hoór de, “Noow gán mur fanít loizai ekkúf mas sai bolla zal félo.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sáimone zuwabe hoór de, “Úzur, añára raitbór meénnot gorí kessú nó fai. Toóu Tuñí zettót hoór, añí zal félaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ítara zal félaiye rár, edún mas foijjé zeén níki ítarar zal fáṛi zargoi. ");
INSERT INTO rhgc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hétunot ítara ítarar ze sáañti ókkol oinno noow ot asé ítara re icára gorí mataiyé, zeéne aái ítara re modot goré. Tói tará aái duní noow eddúr bóijje, zeén níki híin ḍufóm-ḍufóm óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Híyan dekí Sáimon Fitore Isár foot fori hoór de, “Malik, añr héntu zoogói; añí toh gunágar manúc.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kiyólla-hoilé ítara hédun mas faiyé de hétolla íba edde íbar fúañti zetará accíl ítara beggún kúb taajup óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Héndilla, Zebedair fuain Yakub edde Yohánna yó, zetará accíl Sáimon or sáañti. Isá ye Sáimon ore hoór de, “No ḍoorac, ehón ottu lóti tui manúc dóribi.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tarfore ítara ítarar noow gún kul ot ainné, aar hárr kessú eri Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ekbar Isá ekkán cóor ot accíl, héṛe kuruse furaiya ezzon manúc accíl. Yóggwa ye Isá re deikké rár, uúiñtoi fori Íba re fóriyat gorér de, “Ó Malik, Tuñí sailé añré pak-sáf gorí faribá.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isá ye Nizor át barái yóggwa re dóri hoór de, “Añí saái; pak-sáf óizogoi.” Tói éhon or bútore yóggwa ttu kurus biyaram giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Baade Isá ye yóggwa re nicót goijjé de, “Yián honókiyo re no hoiyó, bólke zai nizoré imam or hañse dahógoi, aar tuñí pak-sáf óiyo de híyan maincór hañse gobá ó fan, Muúsa ye hókum díye de hé kurbani dogói.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lekin Isár hóbor aró bicígori fóligiyoi, aar becábicí manúc ókkol Íbar hotá ókkol fúni bolla edde nizor biyaram ókkol ottu gom ói bolla aát tákito. ");
INSERT INTO rhgc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Montor Íba Nize egazá-egazá bocóti-sára zagat zai dua goittó. ");
INSERT INTO rhgc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ek din zeñtté Isá ye taalim der, héṛe hoozzon Féroci edde Córiyot or alem ókkol boiṛá accíl, zetará aiccé de óilde Galil or fottí fara ttu, Yohúdiya ttu, edde Jerúsalem ottu. Aar biyaraimma ókkol ore gom gorí bolla Mabud or kudurut Isár fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hé októt hodún maincé ek añtur manúc ore bisánat góri boói ainné; ítara kucíc goijjíl de, yóggwa re gór or bútore gólai Isár muúntu eri bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Montor zeñtté ítara manúc or zam olla bóuli yóggwa re bútore loizaibár rasta nó faa, hétunot ítara gór or sád or uore uiṭṭégoi, aar sáni bay yóggwa re bisána cóo manúc ókkol or mazéhale Isár muúntu lamaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ítarar iman dekí Isá ye hoór de “Dustó, tor guná maf gorídiya gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Híyane alem ókkole edde Féroci ókkole báfat doijje de, “E Manúc cwa hon, zibá ye kuféri gorér? Siríf Alla bade guná maf gorífaroya hon asé?” ");
INSERT INTO rhgc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Isá ye ítarar báfani re zani, ítara re zuwabe hoór de, “Tuáñra dile-dile héndilla kiyá báfor? ");
INSERT INTO rhgc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hoité hon nán aásan, ki ‘Tor guná maf gorídiya gíyeh,’ aar náki, ‘Uṛí áñṭ’? ");
INSERT INTO rhgc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lekin Añr ttu tuáñra re yián zanaidito monehoór, e duniyait guná maf goríbar kémota Manúc or Fua ttu asé.” Tói Íba ye añtur manúc cwa re hoór de, “Añí toré hoóir, uṭ, tor bisána tulí looi gór ot zaagói.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yóggwa éhon or bútore ítarar muúntu uiṭṭé, aar nize neṛi accíl de bisána wa tulí looi Allar taarif gorí-gorí gór ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Híyane ítara beggún taajup óigiyoi, aar Allar taarif gorát doijje. Ítara kúb ḍooraizai hoór de, “Aijja añára harhána deikkí!” ");
INSERT INTO rhgc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yárbaade Isá baárkule zai dekér de, Leévi nam or ézzon házana-tulóya házana tulé de gór ot boói táikke. Íba ye yóggwa re hoór de, “Añr fisáli doro.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hétunot yóggwa hárr kessú eri uṛí Íbar fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Baade Leévi ye nizor gór ot Isá lla eggwá ḍoóñr hána goijjé; aar ítarar fúañti háito boiccé de héṛe házana-tulóya ókkol edde oinno manúc ókkol ḍoóñr ek dol accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Féroci ókkole edde ítarar alem ókkole Íbar ummot ókkol or hañse endilla cékayot gorát doijje, “Tuáñra házana-tulóyar edde gunágar ókkol or fúañti kiyá hána-fina hóo?” ");
INSERT INTO rhgc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isá ye ítara re zuwabe hoór de, “Araimma ókkol ottu toh ḍakṭor no lage, montor biyaraimma ókkol ottu beh lage. ");
INSERT INTO rhgc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Añí touwár dawot dito aiccí de forhésgar ókkol ore no, bólke gunágar ókkol ore.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ítara Isá re hoór de, “Yaháyar ummot ókkole toh egazá-egazá ruza raké edde dua goré, héndilla Férocir gúne yó goré, montor Tuáñr gúne toh hána-fina bad dede nái.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isá ye ítara re hoór de, “Dulá fúañti tákite kí tuáñra boiraitta re ruza rakái faribá? ");
INSERT INTO rhgc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Montor eén din aibó, zeñtté dulá re ítarar hañsóttu loiféla zaybo, héñtte ítara din híin ot ruza rakíbo.” ");
INSERT INTO rhgc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Íba ye ítara re e meésal lan óu hoiyé, “Honókiye toh noya fucák ottu ekkágori fáṛi looi furan ekgwát tali dede nái; zodi dilé toh noya wa yó fáṛi zayboi, aar noya wa ttu loiyé de tali gán óu furan nwát no háṛibo. ");
INSERT INTO rhgc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Héndilla, honókiye noya anggur or roc ore furan samarar hóillat raké de nái; zodi rakíle toh noya roc cúne hóilla gún fáṛifelai golizaybói, aar hóilla gún óu borbad zayboi. ");
INSERT INTO rhgc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hétolla, noya anggur or roc ore noya samarar hóillat raká fore. ");
INSERT INTO rhgc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Honókiye toh furan anggur or roc hái baade noya anggur or roc háito azzu goré de nái, kiyólla-hoilé tee hoó de, ‘furan nún beh beétor.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ekbar eén óiye, ebaadot-or-din Isá giyuñr kuñṛá báy zaar, aar Íbar ummot ókkole giyuñr túr ókkol tulí áte ḍoli-ḍoli háat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Montor hodún Féroci ye hoór de, “Ebaadot-or-din ziyán goríbar maná, tuáñra híyan kiyá gorór?” ");
INSERT INTO rhgc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isá ye ítara re zuwabe hoór de, “Tuáñra kí yián úddwa nó foró, zeñtté Dawud edde íbar sáañti ókkol ottu búk laiggíl, héñtte íba ye kii goijjíl dé? ");
INSERT INTO rhgc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Íba ye toh Allar gór ot góillegoi, aar Allar hañse peec goijjá ruṭi looi háail, ziín siríf imam ókkole bade ar honókiye háibar ezazot nái. Íba ye híin nizor sáañti ókkol ore yó diíl.” ");
INSERT INTO rhgc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tarfore Isá ye ítara re hoór de, “Manúc or Fua óilde ebaadot-or-din or Malik.” ");
INSERT INTO rhgc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aró éggwa ebaadot-or-din Isá mujilíc-hánat góli taalim diyat doijje; héṛe ézzon endilla manúc accíl, zar den át tan fúaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Alem ókkole edde Féroci ókkole Íba ye ebaadot-or-din gom goré né háas nozor di saái táikke, zeéne ítara Íbar uore elzam lagaibár mouka faa. ");
INSERT INTO rhgc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Montor Íba ye ítarar báfani re zani, át fúana manúc cwa re hoór de, “Uṛó, eṛé mazé tíyogai.” Tói yóggwa uṛí tíyaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tarfore Isá ye ítara re hoór de, “Añí tuáñra re ekkán súwal gorí, ebaadot-or-din gom ham goríbar zayes asé né náki hóraf goríbar? Foran basaibár né náki hálak goríbar?” ");
INSERT INTO rhgc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Íba ye sairómikka ítara beggún or uzu saái, manúc cwa re hoór de, “Tuáñr át tan baró.” Tói yóggwa ye héndilla goijjé, hétunot yóggwar át tan agor ḍóilla gom óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Montor ítara ttu bicí guccá uṛígiyoi, aar ezzon loi ezzone biyasana gorát doijjegoi de, ítara ttu Isá re kii gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hé din ókkol ot ek din, Isá dua gorí bolla eggwá faár or uore uiṭṭégoi, aar fura rait Allar hañse dua gorát haṛaiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zeñtté din óiye, Íba ye Nizor ummot ókkol ore matai ítara ttu baró zon basíloiye, zetará re Íba ye sáhabi hoi lokób diyé. ");
INSERT INTO rhgc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ítara óilde: Sáimon zaré Íba ye Fitor nam diyé, edde íbar bái Enderiyas; aar Yakub, Yohánna, Filíp, Bartólomiyo, ");
INSERT INTO rhgc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Moti, Tómas, Alfáiyas or fua Yakub, Sáimon zibá re Zélot hoó, ");
INSERT INTO rhgc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakub or fua Yohúdah, edde Yohúdah Iskáriyet zibá dóridoya óoil. ");
INSERT INTO rhgc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Isá ítarar fúañti lami aái ekkán fúainna zagat tíyaiye; héṛe Íbar ḍoóñr ek dol ummot accíl, fúañti aró becábicí manúc ókkol óu accíl zetará óilde Yohúdiyar, Jerúsalem or, Ṭayár or, edde Sídon or doijjar hañsar, ");
INSERT INTO rhgc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","zetará Íbar boiyan fúni bolla edde ítarar biyaram ottu gom ói bolla beh aiccé. Aar zetará re hóraf jine duk der, ítara re gom gorá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Manúc beggúne Íba re súibar kucíc goijjíl, kiyólla-hoilé Íba ttu taakot neeli zai beggún ore gom gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Isá ye Nizor ummot ókkol or uzu saái hoór de: “Mubarek tuáñra zetará gorif, kiyólla-hoilé Allar raijjo toh tuáñrar. ");
INSERT INTO rhgc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mubarek tuáñra zetará ehón búka, kiyólla-hoilé tuáñra re bóraidiya zaybo. Mubarek tuáñra zetará ehón hañdoór, kiyólla-hoilé tuáñra áñciba. ");
INSERT INTO rhgc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mubarek tuáñra zeñtté maincé tuáñra re Manúc or Fuar zoriya nafórot goré, maárum goré, ínca goré, edde bodnam goré. ");
INSERT INTO rhgc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Hé din kúci goijjó, edde kúciye fál maijjo, kiyólla-hoilé fúno, asman ot tuáñra lla ḍoóñr boccíc asé. Héndilla toh ítarar bafdada ókkole nobi ókkol ore yó goittó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Montor afsús tuáñrar uore zetará tuangor, kiyólla-hoilé tuáñra toh tuáñrar cúk beggún eṛé faifelaiyo. ");
INSERT INTO rhgc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Afsús tuáñrar uore zetará yala feṭ bórai faroór, kiyólla-hoilé tuáñra búka óiba. Afsús tuáñrar uore zetará yala áñcor, kiyólla-hoilé tuáñra ferecan óiba edde hañdahaṛi goríba. ");
INSERT INTO rhgc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Afsús tuáñrar uore zeñtté manúc beggúne tuáñrar nam goré, kiyólla-hoilé héndilla toh ítarar bafdada ókkole misá nobi ókkol ore yó goittó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lekin tuáñra zetará fúnor, Añí tuáñra re hoóir: nizor duccon ore muhábbot goijjó; zetará tuáñra re nafórot goré, ítara re bálai goijjó; ");
INSERT INTO rhgc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","zetará tuáñrar uore gozzob deh, ítara re borhot diyo; zetará tuáñra re bodsólluk goré, ítara lla dua goijjó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Zee niki tuáñre ek galsaba sái suwar mare, ítare oh ḍák óu fíraidiyo; zee niki tuáñr saddor loizagói, ítare tuáñr kuruta yó loizaitó maná no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Zee niki tuáñr ttu mage, ítare diiyo; aar zee niki tuáñr jiníc loizagói, ítar ttu fírai no magiyó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Maincóre undilla goró zendilla tuáñra soó de, ítara tuáñre goróuk. ");
INSERT INTO rhgc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Zodi tuáñra cúdu tuáñra re muhábbot goré de ítara re muhábbot goró, tóoile súwab kiyólla faiba? Kiyólla-hoilé gunágar ókkole úddwa toh nizoré muhábbot goré de ítara re muhábbot goré. ");
INSERT INTO rhgc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aar zodi tuáñra cúdu tuáñra re bálai goré de ítara re bálai goró, tóoile súwab kiyólla faiba? Kiyólla-hoilé gunágar ókkole úddwa toh héndilla goré. ");
INSERT INTO rhgc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Zodi tuáñra fírai faibar acá goró de hé manúc ítara re beh udár dóh, tóoile súwab kiyólla faiba? Kiyólla-hoilé gunágar ókkole úddwa toh gunágar ókkol ore udár déh, zeéne beggún fírai faa. ");
INSERT INTO rhgc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Montor tuáñra nizor duccon ore muhábbot goró, ítarar bálai goró, aar kessú fírai faibar acá no gorí udár dóh; tói tuáñra lla boccíc ḍoóñr tákibo, aar tuáñra Alla Tálar fuain ṭóoriba, kiyólla-hoilé Íba Nize yó toh nacúkur edde hóraf manúc ókkol or uore rahám goré. ");
INSERT INTO rhgc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Rahám dil ola ó, zendilla tuáñrar Baf óu rahám dil ola. ");
INSERT INTO rhgc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ar ezzon or hosúri no doijjo, tói tuáñrar hosúri yó dóra no zaybo. Ar ezzon ore hosúrbon no ṭóoraiyo, tói tuáñra re yo hosúrbon ṭóora no zaybo. Maf gorídiyo, tói tuáñra re yó maf gorídiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Diiyo, tói tuáñra re yó diiya zaybo. Sibi-sibi edde lari-lari baái fore fángori gom mafe tuáñrar kussát ḍálidiya zaybo. Kiyólla-hoilé tuáñra ze mafe doo, tuáñra re yó hé mafe beh diiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Isá ye ítara re e meésal lan óu diyé, “Ek añdá ye kí arek añdá re foñt dahái fare? Tará duní zon kí gañt ot no foribó né? ");
INSERT INTO rhgc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Cárit toh nizor ustat or túaro ḍoóñr no, lekin zar ttu niki furafuri cíkka óizagoi, íte nizor ustat or ḍóilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Tuñí tuáñr bái or suk ot asé de hál lan kiyá dekór, montor tuáñr nizor suk ot asé de hodda gán toh ót no gorór? ");
INSERT INTO rhgc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tuñí zettót tuáñr suk ot asé de hodda gán no dekór, tói tuñí tuáñr bái ore keéngori hoór de, ‘Bái, añí tuáñr suk ottu hál lan neelaifélai?’ Ó munafék! Age tuáñr nizor suk ottu hodda gán neelaifélo, baade tuáñr bái or suk ot asé de hál lan neelai bolla sáf góri dekíba. ");
INSERT INTO rhgc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kiyólla-hoilé gom gas ot toh hóraf gula dóre de nái, aar hóraf gas ot gom gula dóre de nái. ");
INSERT INTO rhgc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ze honó gas ore yíbar gulaye beh siná zah. Kiyólla-hoilé maincé toh keñṛabon ottu ḍuñir gula no fare, yáh keñṛar záli ttu anggur no fare. ");
INSERT INTO rhgc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gom manúce nizor dil or gom zomaiya ttu gom mún neela; aar hóraf manúce nizor dil or hóraf zomaiya ttu hóraf fun neela. Kiyólla-hoilé zar dil ziíne furaiya, nizor muké híin beh hoó. ");
INSERT INTO rhgc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tuáñra zettót Añí ziín hoói híin amól no goró, tói Añré kiyólla, ‘Malik, Malik,’ ḍako? ");
INSERT INTO rhgc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Zee niki Añr hañse aiyé aar Añr boiyan fúni amól goré, íte har ḍóilla de Añí tuáñra re daháir: ");
INSERT INTO rhgc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Íte óilde endilla ezzon manúc or ḍóilla, zee niki gór banaibárcot mur gori meṛi kurí cíl ot mazé buniyadi ḍáille. Zeñtté faníban aái hé gór gán ot dósadiye híyan ore lari nó fare, kiyólla-hoilé híyan toh mozbut gori bana giyéh. ");
INSERT INTO rhgc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lekin zee niki fúni amól no goré, íte óilde endilla ezzon manúc or ḍóilla, zee niki honó buniyadi no ḍáli meṛir uore ekkán gór banaiyé. Tói zeñtté faníban aái hé gór gán ot dósadiye, híyan éhon or bútore fori ebbe nac óigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Zeñtté Isá ttu manúc cún ore híin beggún boiyan goijjá óiye, Íba Kaparnahúm cóor ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Héṛe ézzon ek cót fóous or cáap or bicí adorja gulam biyarame moron-moron óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hé cáap pwá ye Isár baabute fúinne rár, Yohúdir hoozzon murubbi re Íbar hañse difeṛái Íba re aros goijjé de, aái yóggwar gulam mwa re gom goittó. ");
INSERT INTO rhgc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ítara Isár hañse aái Íba re becábicí fóriyat goijjé, eén hoói, “Hé manúc cwa Tuáñr e modot tán or laayek; ");
INSERT INTO rhgc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kiyólla-hoilé yóggwa ye añárar koum ore muhábbot goré, aar añárar mujilíc-hána gán yóggwa ye beh banaidiyé.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hétunot Isá ítarar fúañti zaat doijje, lekin Íba zeñtté gór or hañsáhañsi foóñicce, cáap pwá ye hoozzon dustó difeṛái Íba re hoór de, “Malik, Nizoré ar duk no diyó, kiyólla-hoilé Tuñí añr gór or sal or nise aibár añí laayek no; ");
INSERT INTO rhgc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","hétolla añí nizoré Tuáñr hañse aibár laayek bouli nó báfi. Siríf muké hoó, tói añr gulam gom óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kiyólla-hoilé añí nize yó ar ezzon or hókumot or tole así, aar fóous ókkol añr nise asé. Añí ezzon ore, ‘Zaa,’ hoilé, íte zaa, ar ezzon ore, ‘Ai,’ hoilé, íte aiyé, aar añr gulam ore, ‘Yián gor,’ hoilé, íte híyan goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Híyan fúni Isá taajup óigiyoi, aar zetará Íbar fisá dori accíl ítarar híkka fíri hoór de, “Añí tuáñra re hoóir, Añí ettór ḍoóñr iman Isráili ókkol or bútore úddwa loot nó fai.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Zetará re difeṛá gíyl ítara gór ot waafes aái, gulam mwa re gom óiya loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Baade eén óiye, yárbaade Isá Nain nam or ekkán farat giiyé, fúañti Íbar ummot ókkol edde ḍoóñr ek dol manúc óu giíl. ");
INSERT INTO rhgc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Íba cóor or geiṭ or ḍáke foóñicce de októt, maincé eggwá muruda baáre loizar, íte óilde ítar maar lehár ek fua, aar maa wa accíl rari. Cóor ottu ḍoóñr ek dol manúc híbar fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Malik ottu híba re dekí, híba lla feṭfuijje, baade Íba ye híba re hoór de, “No hañdiyó.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Baade Íba ḍáke aái tabut twa súiye, aar muruda boói loizar de ítara tíyaigiyoi. Íba ye hoór de “Ó nojuan, Añí toré hoóir, uṭ!” ");
INSERT INTO rhgc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hétunot muruda wa uṛí boiccé aar hotá howát doijje. Baade Isá ye ítare ítar maar hañse waafes diifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Híyane manúc beggún or bútore ḍoor góligiyoi, aar ítara Allar taarif gorát doijje, eén hoói, “Añárar bútore eggwá ḍoóñr nobi uiṭṭé. Alla ye Nizor bonda ókkol ore modot goittó aiccé.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Íbar hé hóbor híyan Yohúdiya agagurat edde sairó ḍák or elaka beggún ot fóligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yaháyar ummot ókkole yóggwa re híin beggún or baabute zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tói Yaháya ye nizor duwá ummot ore matai, ítara re Malik or hañse yián fusár goittó difeṛáiye, “Tuñí aibár hotá asé de Íba né, aar náki añára ar ezzon olla entezar goittám?” ");
INSERT INTO rhgc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Zeñtté manúc ítara Íbar hañse foóñicce, ítara hoór de, “Añára re bápṭismadoya Yaháya ye difeṛáiye deh, Tuáñr ttu yián fusár goittó, ‘Tuñí aibár hotá asé de Íba né, aar náki añára ar ezzon olla entezar goittám?’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hé októt Íba ye boóut zon ore biyaram, afot, edde hóraf jin ottu basaiyé; Íba ye boóut zon añdá re yó dekíbar toóufik diiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Íba ye ítara re zuwabe hoór de, “Zoo, tuáñra ziín deikkó edde fúinno híin Yaháya re zanogói, ki hoilé, añdá ye dekér, lenge áñṛer, kurus biyaraimma pak-sáf ór, náfange fúner, muruda zinda ór, edde gorif ókkol or hañse kúchóbor tobolik gorá zar. ");
INSERT INTO rhgc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mubarek ubá, zee niki Añr baabute andacá no goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zeñtté Yaháyar hóborgwa gún bacá lóiye, Íba ye manúc cún ore Yaháyar baabute howát doijje de, “Tuáñra moidan zagat kii saitó giíla dé? Boiyare lore de hóir né? ");
INSERT INTO rhgc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Arnóile tuáñra kii saitó giíla dé? Barík hoor findá manúc né? Zetará dami-dami hoor fiñdí rongzuingga gorí sole, ítara toh razmohól ot éna. ");
INSERT INTO rhgc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tóoile tuáñra kii saitó giíla dé? Honó nobi né? Ói, Añí tuáñra re hoóir, nobir túaro ḍoóñr ézzon ore. ");
INSERT INTO rhgc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yóggwa óilde ubá, zibár baabute pak-kalam ot endilla asé, ‘Soó, Añí Añr hóborgwa re Tuáñr age difeṛáir, zibá ye Tuáñr age Tuáñr foñt toiyar goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Añí tuáñra re hoóir, mayafuain dor ttu zormo óiye de ítarar bútore bápṭismadoya Yaháyar túaro ḍoóñr honókiye nái; montor toóu úddwa Allar raijjot zee niki ebbe cóñṛo, íte yóggwar túaro ḍoóñr.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Zeñtté tamám manúc ókkole edde házana-tulóya ókkole híyan fúinne, ítara Yaháyar hañsóttu bápṭisma loi, Alla insáfwala de maniloiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Montor Féroci ókkole edde Córiyot or alem ókkole Yaháyar hañsóttu bápṭisma no loi, Alla ttu ítara lla accíl de moksót ore inkar gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Isá ye aró hoór de, “Añí e zobanar maincóre kii loi fúwan goittám? Ítara kiyór ḍóilla? ");
INSERT INTO rhgc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ítara undilla fuain dor ḍóilla, zetará bazar ot boói ezzon ore ezzone matai hoó de, ‘Tuáñra lla añára bací bazaiyí, montor tuáñra nó naso; tuáñra lla añára bilak or zari gaiyí, montor tuáñra nó hañdo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kiyólla-hoilé bápṭismadoya Yaháya aái zettót honó ruṭi edde anggur or roc ná háa, tuáñra hoó de, ‘Íba re búte faiyé.’ ");
INSERT INTO rhgc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aar Manúc or Fua aái zettót háafiya gorér, tuáñra hoór de, ‘Soó, ezzon fitác edde córabkur, házana-tulóya edde gunágar ókkol or dustó.’ ");
INSERT INTO rhgc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lekin giyan sóiyi de híyan giyane soloya beggúne sábut goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Féroci ókkol ottu ezzone Isá re nizor fúañti hána háito dawot diyé, tói Íba hé Féroci war gór ot zai háito boiccé. ");
INSERT INTO rhgc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hé cóor gán ot eggwá hóraf mayafua accíl; Isá Féroci war gór ot hána háar de híyan híba ye zani faijjé rár, híba ye fúañti fattór or háñrit góri añtor ainné, ");
INSERT INTO rhgc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","aar Íbar fis ottu ṭéng or ḍáke tíyai, hañdi-hañdi Íbar ṭéng ore nizor suk or faní lói bízat doijje, baade nizor matár sul loi híin fuñsídiye edde Íbar ṭéng ot appá dí añtor gún ḍálidiye. ");
INSERT INTO rhgc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Íba re dawot diyé de Féroci wa ye híyan deikké rár, yóggwa ye nizoré nize hoór de, “Zodi e Manúc cwa nobi óito, tóoile toh Ibá ye zainto, Nizoré hone edde hondilla mayafua ye dórer deh; mayafua wa toh hóraf.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hétunot Isá ye yóggwa re zuwabe hoór de, “Sáimon, Añr ttu tuáñre kessú hoibár asé.” Sáimone hoór de, “ Ustat, hoói faribá.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Ezzon hozzo-dooya ttu dui zon hozzodár asé: ekzone loiyé fañs cót dinár,ar ekzone loiyé fonzaic dinár. ");
INSERT INTO rhgc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ítara zettót híin fúñzi no farer, yóggwa ye ítara duní zon or hozzo maf gorídiye. Tóoile ítara ttu yóggwa re hone bicí muhábbot goríbo?” ");
INSERT INTO rhgc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sáimone zuwabe hoór de, “Añr kíyal mozin, zar niki bicí hozzo maf gorídiya gíyeh íte.” Íba ye yóggwa re hoór de “Tuñí sóiyi kíyal goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Baade mayafua war híkka fíri Íba ye Sáimon ore hoór de, “Tuñí e mayafua wa re dekór né? Añí toh tuáñr gór ot ailám; tuñí Añré foo dúi bolla faní nó doo, montor ibáh ye nizor suk or faní lói Añr foo bízai nizor sul loi fuñsídiye. ");
INSERT INTO rhgc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tuñí toh Añré appá nó doh, montor Añí bútore góilli lóti ibáh ye Añr foot appá díya bon nó goré. ");
INSERT INTO rhgc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tuñí Añr matát tel nó doh, montor ibáh ye Añr foot añtor ḍálidiye. ");
INSERT INTO rhgc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hétolla Añí tuáñre hoóir, ibáh ttu bicí guná tákile yo, ibáhr hé guná híin maf gorídiya gíyeh, kiyólla-hoilé ibáh ye bicí muhábbot goijjé. Montor zaré hom maf gorídiya gíyeh, yóggwa ye hom muhábbot goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Baade Isá ye híba re hoór de, “Tuáñr guná maf gorídiya gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hétunot zetará Íbar fúañti hána háito boiccíl, ítara afós ot howáhoi gorér de, “Ibá hon, zibá ye guná úddwa maf goré?” ");
INSERT INTO rhgc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Lekin Íba ye mayafua wa re hoór de, “Tuáñr imane tuáñre basaiyé; cántir sáañte zoogói.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yárbaade, Isá cóore-cóore edde fara-fara zai Allar raijjor baabute kúchóbor boiyan gorát edde tobolik gorát doijje. Baró zon nún Íbar fúañti accíl, ");
INSERT INTO rhgc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hodún beṛiyáin óu accíl zetará re hóraf jin ókkol ottu edde ocúk ókkol ottu gom gorá gíyl; tará óilde: Moriyam, zibá re Makdálini ḍake, zibár bútottu háñt twa bút neeillíl; ");
INSERT INTO rhgc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna, zibá Hérud or uzir Kuzar or bou; Sosánna edde aró boóut beṛiyáin ókkol. Tará nizor cómbotti lói ítarar hédmot goittó. ");
INSERT INTO rhgc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ek din zeñtté fottí cóor ottu ḍoóñr ek dol manúc Isár hañse aái zoma óiye, Íba ye ítara re e meésal lan hoiyé: ");
INSERT INTO rhgc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ezzon bis cíñṛoya bis cíñṭṭo neeillé. Yóggwa ye cíñṛer de októt, hodún bis rastarhañsat foijjíl; híin or uore úñran foijjíl, aar faik ókkole híin háifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hodún bis cíl or uore foijjíl, híine tocá nó faa ísafe barí uṛár fúañti-fúañti fúaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hodún bis keñṛabon ot foijjíl, fúañti keñṛabon barí uṛí híin ore sibi raikké. ");
INSERT INTO rhgc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lekin ar hodún bis gom zobin ot foijjíl; híin barí uiṭṭé, aar ek cót gun fósol dóijje.” Isá ye híin hoói baade guzori hoór de, “Zar ttu fúnibar han asé, yóggwa ye fúno.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Isár ummot ókkole Íba ttu fusár gorér de, “E meésal lan or maáni kii?” ");
INSERT INTO rhgc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Íba ye hoór de, “Allar raijjor gufoni re zainto tuáñra re beh diya giyéh, montor oinno kiyó re meésal dí etollá howá zah, zeéne ‘ítara sailé yo no deké, aar fúnile yo no buzé.’ ");
INSERT INTO rhgc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Meésal lan or maáni óilde yián: bis óilde Allar kalam. ");
INSERT INTO rhgc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Rastar hañsat foijjé de híin óilde uitará zetará fúne, montor Ibilíce aái ítarar dil ottu kalam loizagói, zeéne ítara iman nu ané aar nejat no faa. ");
INSERT INTO rhgc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Cíl zobin ot foijjé de híin óilde uitará, zetará kalam fúnile kúcir sáañte kobul goré; aar mozbut cíñyor nó gasá de hétolla kessú októ lla beh iman raké, montor entán ot fore de októt fissá mare. ");
INSERT INTO rhgc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ze bis keñṛabon ot foijjé híin óilde uitará, zetará kalam fúne, montor zindigi haṛaité-haṛaité sintabáfaniye, dón-doulote, edde e zindigir ayaci-kúciye ítara re sibi raké, hétolla ítarar gula fagi no tooñre. ");
INSERT INTO rhgc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lekin ze bis gom zobin ot foijjé híin óilde uitará, zetará cúndorgori edde gom dile kalam fúne, híin ore mozbut gori dóri raké, edde sobór or sáañte gula dóra. ");
INSERT INTO rhgc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Honókiye toh serak dórai tára lói záfai no raké, yáh falong or tole yó no raké, bólke boiṛónir uore éna raké, zeéne bútore aiyé de ítara foór deké. ");
INSERT INTO rhgc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kiyólla-hoilé endilla surha kessú nái ziín zahér no óibo, aar endilla lukaiya yó kessú nái ziín zana no zaybo aar kúlahala no óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hétolla tuáñra hondilla gori fúnor úñciyar, kiyólla-hoilé zar ttu niki asé, yóggwa re aró diiya zaybo; montor zar ttu niki nái, yóggwa ye nizor ttu ziín asé bóuli báfe híin úddwa loiféla zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yárbaade Isár maa edde báiyain Íbar héṛe aiccé, montor maincór zam olla bóuli ítara Íbar íñyot foóñsi no farer. ");
INSERT INTO rhgc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ezzone Íba re hóbor díye de, “Tuáñr maa edde báiyain baáre tíyai táikke, ítara Tuáñr llói milto sar.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Montor Íba ye ítara re zuwab diyé de, “Añr maa edde báiyain óilde itará, zetará Allar kalam fúne edde híin amól goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ek din Isá edde Íbar cárit tun ekkán noow ot uiṭṭé, tarfore Íba ye ítara re hoór de, “Aiyó, añára ḍiír oh hañsat farái.” Baade ítara bacá lóiye. ");
INSERT INTO rhgc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Zaite-zaite Isá gúm ot forigiyói. Aar ḍiít eggwá ḍoóñr tuwán aiccé, hétolla noow gán faní lói bórizargoi, aar ítara hótorat foijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ítara Íbar hañse aái Íba re tulídi hoór de, “Ustat, ó Ustat, añára morizayrgói!” Tói Íba uṛí boiyar edde fanír goir ore dóoñk diyé, baade híin bon ói támaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Íba ye ítara re hoór de, “Tuáñrar iman hoṛé?” Ítara ḍooraigiyói aar taajup ói ezzon ore ezzone hoór de, “Ibá hon? Ibá ye de boiyar edde faní re úddwa hókum díle híine Ibár hotá mane!” ");
INSERT INTO rhgc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yárbaade ítara Geraséniol or mulluk ot foóñicce, ziyán Galil Ḍiír muúntu. ");
INSERT INTO rhgc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zeñtté Isá kul or uore laimmé, hé cóor or ezzon búte-faiya manúc Íba llói dola óiye. Yóggwa ye hoorsuor no fiñdér de bicí deri lóti, aar yóggwa gór ot no táki hobor ókkol ot tákito. ");
INSERT INTO rhgc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Zeñtté yóggwa ye Isá re deikké, guzori Íbar muúntu uúiñtoi forigiyói, aar eggwá ḍoóñr abase hoór de, “Ó Isá, Alla Tálar Fua, Tuáñr ttu añr llói kii ham asé? Añí Tuáñre bicí fóriyat gorír, añré toziya no diyó.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kiyólla-hoilé Isá ye hé hóraf jin nwá re yóggwar bútottu neeliai bolla hókum dífelaiye. Hé jine yóggwa re bicí faito; aar yóggwa re síyol edde berí lói bañdí faára dí raká zayto, montor híin sírifelaito, aar búte yóggwa re moidan zagat loizaitói. ");
INSERT INTO rhgc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isá ye yóggwa ttu fusár gorér de, “Tor nam kii?” Yóggwa ye hoór de, “Zák” kiyólla-hoilé yóggwar bútore boóut twa bút góli táikke. ");
INSERT INTO rhgc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Híine Isá re fóriyat gorát doijje de, híin ore oṭái gañt ot zaito hókum no di bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Héṛe faár or uore ḍoóñr ek zák cúwor sorer de accíl. Bút tune Íba re fóriyat gorér de, híin ore hé cúwor gún or bútore góiltoi ezazot di bolla. Tói Íba ye híin ore ezazot diyé. ");
INSERT INTO rhgc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hétunot hé bút tun manúc cwa ttu neeli aái cúwor gún or bútore góillegoi, tói cúwor or zák kwa faár or haindá báy zure ḍiít duñrdiyé aar ḍufí morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cúwor soroya gúne zeñtté kii óiye de deikké, ítara duñrdiyé aar cóor ot edde gang zagat híyan hóbor díye. ");
INSERT INTO rhgc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Baade kii óiye de sai bolla manúc ókkol neeillé. Manúc ítara Isár héṛe aái loot faiyé de, ze manúc cwa ttu bút neeillé yóggwa hoor findí edde sóiyi úñice Isár ṭéng or ḍáke boiṛá asé; hétunot ítara ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Zetará hé maamela gán deikké ítara búte-faáil de manúc cwa keéngori gom óigiyoi de híyan hé manúc ítara re zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hétolla Geraséniol or sairó ḍák or manúc beggúne Isá re ítarar héntu zaitogói hoiyé, kiyólla-hoilé ítara ttu bicí ḍoor laiggé; hétunot Íba noow ot uṛí waafes aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ze manúc cwa ttu bút ókkol neeillíl, yóggwa ye Íbar fúañti zai bolla Íba re fóriyat goijjíl, lekin Isá ye yóggwa re eén hoói duñraidiyé, ");
INSERT INTO rhgc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tuñí tuáñr gór ot waafes zoogói, aar Alla ye tuáñr lla ze ḍoóñr ham goijjé híin boiyan gorógoi.” Baade yóggwa giiyégoi, aar Isá ye yóggwa lla ze ḍoóñr ham goijjé híin cóor or agagura howát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zeñtté Isá waafes aiccé, manúc ókkole Íba re estekbal goijjé, kiyólla-hoilé ítara beggúne Íba lla sooñi táikkil. ");
INSERT INTO rhgc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hétunot Záiras nam or ézzon manúc héṛe aiccé, zibá mujilíc-hánar ézzon sóddar; yóggwa ye Isár foot fori Íba re fóriyat gorér de, yóggwar gór ot ai bolla; ");
INSERT INTO rhgc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kiyólla-hoilé yóggwa ttu siríf eggwá baró bosórja zérfua accíl deh, aar híba morizargói. Íba zaar de októt, manúc ókkole Íba re ṭélaṭeli gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Héṛe eggwá mayafua accíl, zibá ttu kúnzari zár de baró bosór óiye, zibá ye nizor ttu accíl de beggún ḍakṭor ókkol or hañse hóssa gorífelai baade yo honókiyor át ot gom ói nó fare; ");
INSERT INTO rhgc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","híba Isár fisór ttu aái Íbar hoor or hañra súiye, tói éhon or bútore híbar kúnzari bon óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hétunot Isá ye hoór de, “Añré hone súiye?” Beggúne inkar gorí baade Fitore hoór de, “Úzur, manúc ókkole de zam gorí Tuáñre sairó ḍák ottu ṭélaṭeli gorér.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Montor Isá ye hoór de, “Honnwággwa ye Añré súiye, kiyólla-hoilé Añr ttu kudurut neeli giiyé de Añí hoi faijjí.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hé mayafua wa ye zettót híba hári nó fare de deikké, híba hafi-hafi aái Íbar muúntu uúiñtoi foijjé, aar híba ye kiyólla Íba re súiye, edde híba keéngori éhon or bútore gom óigiyoi, híin manúc beggún or muúntu boiyan goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Isá ye híba re hoór de, “O zíi, tor imane toré gom goijjé; cántir sáañte zaagói.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Íba hotá howát accíl de októt, mujilíc-hánar sóddar gwar gór ottu ezzone aái hoór de, “Tuáñr zíi zuraigiyói; Ustat ore ar ferecan no goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Montor Isá ye híyan fúni yóggwa re hoór de, “No ḍooraiyó, siríf biccác goró, híba gom óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Íba gór ot foóñsi, Fitor, Yohánna, Yakub, edde mayafuar bafmaa re bade ar honókiyo re Íbar fúañti bútore góilto nó deh. ");
INSERT INTO rhgc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Manúc beggúne híba lla hañdahaṛi gorát edde buk kilat accíl, montor Isá ye hoór de, “No hañdiyó, ibáh moijjé de no, bólke gúm zar deh.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hétunot ítara Íba re lói áñcat doijje, kiyólla-hoilé ítara hoi fare de ki híba morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Montor Íba ye híbar át dóri ḍak mari hoór de, “O zíi, uṭ.” ");
INSERT INTO rhgc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hétunot híbar foran waafes aiccé, aar híba éhon uṛí tíyaiye. Baade háito híba re kessú dii bolla Isá ye ítara re hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Híbar bafmaa taajup óigilgoi; montor ziyán óiye híyan honókiyo re no hoi bolla Isá ye ítara re nicót goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yárbaade Isá ye baró zon cárit tun ore fúañti matai, fottí ḍoilla bút ókkol neelai bolla edde biyaram ókkol gom gorí bolla ítara re taakot edde kémota diiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tarfore ítara re Allar raijjor baabute tobolik gorí bolla edde biyaraimma ókkol ore gom gorí bolla difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Íba ye ítara re hoiyé de, “Foñt olla kessú no loizaiyó: no laṛí, no hóilla, no hána, no ṭiañ, no battí hoor. ");
INSERT INTO rhgc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tuáñra ze gór ot góliba hé gór ot cóor híyan ottu neeli nó zoogói foijjonto tákiyo. ");
INSERT INTO rhgc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ze cóor or maincé tuáñra re kobul no goré, hé cóor ottu neeli zaibarcót tuáñrar ṭéng or tollar dúil zárifelaiyo, zeéne híine ítarar ulḍa gobá déh.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Baade ítara rowana loi fara-fara zai, kúchóbor tobolik gorát edde fottí zagat biyaraimma ókkol ore gom gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galil or hókumot-goróya Hérude, ziín ór híin beggún fúinne. Yóggwa bicí oulzóul ot forigiyói, kiyólla-hoilé hodúne hoór de, Yaháya mora ttu zinda óiye deh, ");
INSERT INTO rhgc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","hodúne hoór de, Eliyas zahér óiye deh, ar hodúne hoór de, agor zobanar nobi ókkol ottu nobi eggwá zinda óiye deh. ");
INSERT INTO rhgc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Montor Hérude hoór de, “Yaháyar holla de añí nize haṛiféla báilam, montor ibá hon zar baabute añí endilla hotá ókkol fúnir?” Híya lóti yóggwa ye Isá re sai bolla kucíc gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sáhabi gún waafes aái, ítara ziín-ziín goijjíl híin Isá re zanaiyé. Tarfore Íba ye ítara re fúañti looi, Betsáida hoó de fara híyan ot zuitégori giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Montor manúc ókkole híyan hoi fari Íbar fisá doijjil. Íba ye ítara re kúcir sáañte kobul goijjé, aar ítara re Allar raijjor baabute taalim diyé edde biyaraimma zetará ttu gom óibar zorurot accíl ítara re gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zeñtté beil gólibar októ óiye, hé baró sáhabi gúne aái Isá re hoór de, “Manúc cún ore duñraido, zeéne tará atehañsór fara ókkol ot edde gang zaga ókkol ot zai kessú háibar edde tákibar zaga tuwai fare, kiyólla-hoilé añára así de yián toh ekkán bocóti-sára zaga.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Montor Íba ye ítara re hoór de, “Hái bolla kessú tará re tuáñra doo.” Ítara hoór de, “Añára ttu de fañs swá ruṭi edde duwá mas bade ar kessú nái, hétolla añára zai tará beggún olla hána kini aintámboi né?” ");
INSERT INTO rhgc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kiyólla-hoilé héṛe fañs ázar foijjonto beṛaáin accíl. Montor Isá ye Nizor cárit tun ore hoór de, “Tará re ek ḍaái ot fonzaic zon fonzaic zon gorí buágaro.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ítara héndilla gorí beggún ore buágaraiye. ");
INSERT INTO rhgc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Íba ye hé fañs swá ruṭi edde duwá mas sún looi asman or uzu saái híin ore borhot diyé, aar Íba ye híin ore báñgi-báñgi cárit tun ore diiyé, manúc ókkol ore baṛidi bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tará beggúne feṭ bóri háiye. Baade ze tukuṛa ókkol basigiyói, cárit tune híin feñṛai looi fura baró báñir bóijje. ");
INSERT INTO rhgc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ekbar zeñtté Isá háliga dua gorér, aar cárit tun Íbar fúañti accíl, Íba ye ítara ttu fusár gorér de, “Maincé Añí hon bouli hoó?” ");
INSERT INTO rhgc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ítara zuwabe hoór de, “Tuñí bóle bápṭismadoya Yaháya; ar hodúne hoó de, nobi Eliyas; ar hodúne hoó de, agor zobanar nobi ókkol ottu nobi eggwá zinda óiye deh.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tói Íba ye ítara re hoór de, “Lekin tuáñra kii hoó, Añí hon?” Fitore zuwabe hoór de, “Allar Mosih.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Isá ye ítara re horagori úñciyari díye, aar híyan honókiyo re no hoitó maná goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Íba ye hoór de, “Manúc or Fua ttu hámaha boóut ḍóilla duk faa foribó; aar murubbi, ḍoóñr imam edde alem ottu inkar háibo; Íba re mariféla zaybo, montor tin din ot din zinda gorá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Baade Íba ye ítara beggún ore hoór de, “Zodi honókiyo ttu Añr fisáli aitó monehoó, yóggwa ttu nizoré inkar gorífela foribó, aar fottí din nizor kúruc boói Añr fisáli dora foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kiyólla-hoilé zee niki nizor zan basaitó saá, yóggwa ye híyan háraifelaibo; montor zee niki Añr wasté nizor zan háraifele, yóggwa ye híyan basaifélaibo. ");
INSERT INTO rhgc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kii laf, zodi honókiye tamám duniyai faa, montor nizoré háraifele yáto lussán gorífele? ");
INSERT INTO rhgc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Zee kiyé Añré lói edde Añr hotá re lói córma, yóggwa re lói Manúc or Fua ye yó córmaibo zeñtté Íba Nizor, Baf or, edde pak fírista ókkol or mohímaye aibó. ");
INSERT INTO rhgc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Lekin Añí tuáñra re sóiyi hoóir, eṛé endilla hodún manúc tíyaiya asé, zetará Allar raijjo nó dekíte no moribó.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Híin hoói añcṭo din ánik baade, Isá ye Fitor ore, Yohánna re, edde Yakub ore looi faár or uore dua goittó uiṭṭégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Zeñtté Íba dua gorát accíl, Íbar siyárar súrot bodoligiyói, aar Íbar hoor dóla ói sossohat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Asimbit dui zon manúc Íba llói hotá hoór, ítara óilde Muúsa edde Eliyas. ");
INSERT INTO rhgc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tará mohímar sáañte dahá dí Íbar entehal or baabute hoóil, ziyán Íba ye Jerúsalem ot fura goríbar asé. ");
INSERT INTO rhgc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fitor edde íbar sáañti ókkol mur gúm ot accíl; lekin ítara támfaiye rár, Isár mohíma edde Íbar fúañti tíyai táikke de manúc duní zon ore deikké. ");
INSERT INTO rhgc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Baade hé manúc duní zon Íbar héntu zaargói de októt, Fitore Isá re hoór de, “Úzur, gom óiye añára eṛé así. Añára eṛé tin nán ṭambu ṭaki: ekkán Tuáñr lla, ekkán Muúsa lla, edde ar ekkán Eliyas olla.” Háleke íba nize kii hoór nize no zane. ");
INSERT INTO rhgc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fitore híyan hoór de októt, ekkán miyúla aái ítara re sáifelaiye. Ítara miyúla lói sáizargoi de októt, ḍooraáil. ");
INSERT INTO rhgc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aar hé miyúla ttu eggwá abas aiccé, ki hoilé, “Ibá óilde Añr Fua zibá re Añí basíloiyi; Ibár hotá fúno!” ");
INSERT INTO rhgc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Abas swá aiccá ói baade, ítara Isá re gaaga loot faiyé. Ítara híyan aiddone raikkíl, aar ziín deikké híin hé din ókkol ot honókiyo re nó zana. ");
INSERT INTO rhgc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tarfor din zeñtté ítara faár ottu lami aiccé, ḍoóñr ek dol manúc Íba llói dola óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dol ottu ezzone guzori hoór de, “Ustat, añí Tuáñre fóriyat gorír, añr fua wa re ekká soó, íte añr lehár ek fua. ");
INSERT INTO rhgc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ítare eggwá jine dóre, aar íte éhon guzoran mare; yíba ye ítare dórforabai gal ottu féna ané. Yíba ye ítare bicí duk di mockil or sáañte beh eride. ");
INSERT INTO rhgc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Añí Tuáñr cárit tun ore hé jin nwá neelaifélaito fóriyat goijjílam, lekin ítara nó fare.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hétunot Isá ye zuwabe hoór de, “Ó iman sára edde báañra nosól, Añí tuáñrar fúañti-fúañti aró hotókkal tákitam? Hotódin tuáñra re bordac goittám? Tuáñr fua wa re eṛé anó.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Fua wa aiyér de októt, ítare bút twa ye meṛit añsári dórforabat doijje. Montor Isá ye hé hóraf jin nwá re dóoñk dí, fua wa re gom gorífelaiye, baade ítare baf or hañse waafes diifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aar manúc beggúne Allar ḍoóñr kudurut dekí taajup óigiyoi. Ze októt ítara fottíkiye Isá ye goittó de híin beggúne taajup óiye, Íba ye Nizor cárit tun ore hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tuáñra Añr e hotá iín han ot gólai loo, ki hoilé, Manúc or Fua re manúc ókkol or át ot gosáidiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lekin ítara hotá híyan no buzíto. Ítara ttu híyan lukaiféla gíyeh, zeéne ítara buzí no fare; aar ítara Íba ttu hé hotár baabute fusár goitté yó ḍooraitó. ");
INSERT INTO rhgc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yárbaade ítarar bútore ekkán barábari cúru óiye, añárar bútore ebbe ḍoóñr honnwá hoói. ");
INSERT INTO rhgc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lekin Isá ye ítarar dil or báfani re zani, eggwá gura fua looi Íbar ḍáke góri tíyagaraiye, ");
INSERT INTO rhgc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","baade ítara re hoór de, “Zee kiyé e fua wa re Añr name kobul goré, yóggwa ye Añré kobul goré deh; aar zee kiyé Añré kobul goré, yóggwa ye Añré difeṛáiye de Íba re kobul goré deh; kiyólla-hoilé tuáñra beggún or bútore zee niki ebbe cóñṛo, yóggwa óilde ebbe ḍoóñr.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohánna ye zuwabe hoór de, “Úzur, añára deikkí de, eggwá maincé Tuáñr name bút neelar; yóggwa añárar fúañti Tuáñr fisáli nó dóre de hétolla, añára yóggwa re maná goijjí.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lekin Isá ye hoór de, “Yóggwa re maná no goijjó, kiyólla-hoilé zee niki tuáñrar ulḍa no, yóggwa toh tuáñrar híkka.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Isá asman ot uṛí zaibar din zettót ḍáke aiyér, Íba ye Jerúsalem ot zai bolla fáisela loiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Íba ye Nizor age hóborgwa ókkol difeṛáiye; ítara zai Samári ókkol or ekkán farat góille, zeéne Íba lla beggún entezam gorí fare. ");
INSERT INTO rhgc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lekin héṛiyar manúc ókkole Íba re kobul nó goré, kiyólla-hoilé Íbar sofór accíl de Jerúsalem or uzu. ");
INSERT INTO rhgc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Íbar cárit Yakub edde Yohánna ye híyan dekí hoór de, “Malik, añára hókum dí asman ottu ooin nazil gorí ítara re fúraifelaitam né?” ");
INSERT INTO rhgc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Montor Íba fíri ítara re jéjjeṛai hoór de, “Tuáñra hondilla ruhr de tuáñra no zano; ");
INSERT INTO rhgc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","kiyólla-hoilé Manúc or Fua manúc ókkol or zan dónco gorífelaito aiccé de no, bólke basaitó aiccé deh.” Baade ítara ar ekkán farat giiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Zeñtté ítara rasta báy zaar, manúc ézzone Isá re hoór de, “Tuñí zeṛé zaiba, añí yó héṛe Tuáñr fisáli zaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isá ye yóggwa re hoór de, “Cíyal ókkol ottu gañt asé aar faik ókkol ottu bahá asé, montor Manúc or Fua ttu Nizor matá rakí bolla úddwa honó mikká zaga nái.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Baade Íba ye ar ezzon ore hoór de, “Añr fisáli aiyó.” Montor yóggwa ye hoór de, “Malik, age añí zai añr baf ore dohón gorí aiyí.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Isá ye yóggwa re hoór de, “Muruda ókkole ítarar nizor muruda re dohón goróukgoi, montor tuñí zai Allar raijjor baabute tobolik gorógoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ar ekzone yó hoór de, “Malik, añí Tuáñr fisáli aiccúm, lekin age añí añr gór or manúc ottu bidai loi aiyí.” ");
INSERT INTO rhgc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Montor Isá ye yóggwa re hoór de, “Zee niki nizor át nahol ot rakí fissá saái táke, yóggwa Allar raijjor laayek no.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yárbaade, Malike oinno hóittor-dui zon ore yó basíloiye, baade ítara re dui zon dui zon gorí Nizor age oh cóor edde zaga fottí ekkán ot difeṛáiye, zeṛé-zeṛé Íba Nize zaibo. ");
INSERT INTO rhgc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Íba ye ítara re hoiyé de, “Fósol de bicí asé, montor dooiya bicí hom; hétolla fósol or Malik ore fóriyat goró, Íbar fósol daito dooiya ókkol difeṛái bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Zoo; fúno, Añí tuáñra re bérasóol-or-sóor ḍóilla góri rangkuñir or mazé difeṛáir deh. ");
INSERT INTO rhgc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Honó ṭiañr zali, hóilla, yáh cenṭár no loizaiyó; aar foñt ot honókiyo re sólam no diyó. ");
INSERT INTO rhgc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Tuáñra ze gór ot góliba, age hoibá de, ‘E gór ot cánti óuk.’ ");
INSERT INTO rhgc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Zodi héṛe cántir laayek honó manúc táke, tuáñrar cánti yóggwar uore tákibo; montor zodi no táke, tuáñrar héṛe fíri aáizayboi. ");
INSERT INTO rhgc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hé gór ot tákiyo, aar ítara ziín dee híin háiyo edde fiíyo, kiyólla-hoilé muzur toh nizor muzuri faibar laayek. Góre-góre no gúriyo. ");
INSERT INTO rhgc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Tuáñra ze cóor ot góliba, zodi héṛiyar maincé tuáñra re kobul goré, tóoile tuáñra re ziín dee híin háiyo. ");
INSERT INTO rhgc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Héṛiyar biyaraimma ókkol ore gom goijjó, aar ítara re hoibá de, ‘Allar raijjo tuáñrar ḍáke aáigiyoi.’ ");
INSERT INTO rhgc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lekin tuáñra ze cóor ot góliba, ítara zodi tuáñra re kobul no goré, tóoile híyan or goldi-goldi zai hoibá de, ");
INSERT INTO rhgc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Tuáñrar cóor or dúil ziín añárar ṭéng or tollat bazí táikke, añára híin úddwa tuáñrar ulḍa zárifelair; montor monot raikkó de ki, Allar raijjo ḍáke aáigiyoi.’ ");
INSERT INTO rhgc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Añí tuáñra re hoóir, oh dinSódom cóor or túaro hé cóor híyan ottu bicí bordac gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ó Korazin, tor uore afsús! Ó Betsáida, tor uore afsús! Kiyólla-hoilé ze keramoti ham ókkol tuáñrar bútore gorá gíyl híin zodi Ṭayár edde Sídon ot gorá zayto, ítara sálarcoṭ fiñdí edde sái or uore boói boóut age lóti touwá gorífelaito. ");
INSERT INTO rhgc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Montor kiyamot or din Ṭayár edde Sídon or maincór ttu tuáñrar túaro hom bordac gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aar tui, ó Kaparnahúm, toré kí asman ot bazé fán uore tulá zaybo? Toré toh nise fatalfur ot éna félaidiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Isá ye Nizor cárit tun ore hoór de, “Zee niki tuáñrar hotá fúne, yóggwa ye Añr hotá fúne deh; zee niki tuáñra re inkar goré, yóggwa ye Añré inkar goré deh; zee niki Añré inkar goré, yóggwa ye Añré difeṛáiye de Íba re inkar goré deh.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Baade hóittor-dui zon nún kúcir sáañte waafes aiccé, aar hoór de, “Malik, Tuáñr name toh bút ókkole úddwa añárar hotá mane!” ");
INSERT INTO rhgc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Isá ye ítara re hoór de, “Cóitan bijili somke fángori asman ottu forer de Añí deikkí. ");
INSERT INTO rhgc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Soó, Añí tuáñra re háf edde bissúr uottú áñṛibar edde duccon or hárr taakot or uore kémota diiyí; honó kessú ye tuáñra re hóti gorí no faribó. ");
INSERT INTO rhgc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lekin bút-ferot ókkole tuáñrar hotá mane de híyane kúci no óiyo, bólke etollá kúci ó, kiyólla-hoilé tuáñrar nam asman ot leikká asé.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hétunot Isá ye Pak-Ruhr kúciye furaiya ói hoór de, “Ó Baf, asman zobin or Malik, Añí Tuáñre cúkuriya gorír, kiyólla-hoilé Tuñí iín giyani edde buddíman ókkol ottu lukai rakí gura fuain dor ḍóilla maincór hañse zahér goijjó. Ói, ó Baf, kiyólla-hoilé Tuáñr ttu híyan bicí fosón laiggé. ");
INSERT INTO rhgc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Añr Bafe Añré hárr kessú diifélaiye. Fua hon de híyan Bafe bade ar honókiye no zane, aar Baf hon de híyan Fua edde Fua ye zaré zahér goittó saá, yóggwa ye bade ar honókiye no zane.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Baade Íba ye cárit tun or uzu fíri, zuitégori hoór de, “Mubarek suk uiín ziíne tuáñra dekó de híin deké. ");
INSERT INTO rhgc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kiyólla-hoilé Añí tuáñra re hoóir, boóut nobi edde baáñcca ókkole tuáñra ziín dekór híin dekí bolla azzu goijjíl, montor nó deké; tuáñra ziín fúnor híin fúni bolla yó azzu goijjíl, montor nó fúne.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ekbar, Córiyot or ézzon aleme tíyai Isá re entán gorí bolla hoór de, “Ustat, ofúrani zindigi miras faite añr ttu kii gorá foribó?” ");
INSERT INTO rhgc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Íba ye yóggwa re hoór de, “Córiyot ot kii leikká asé? Tuñí héṛe kii foijjó?” ");
INSERT INTO rhgc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yóggwa ye zuwabe hoór de, “Mabud tuáñrar Alla re nizor fura dile, fura zane, fura bole, edde fura demake muhábbot goríba, aar nizor atehañsór maincóre nizor ḍóilla muhábbot goríba.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isá ye yóggwa re hoór de, “Tuñí sóiyi zuwab diyó; héndilla gorógoi, tói tuñí basibá.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Montor nizoré sóiyi sábut goríbar kíyale, yóggwa ye Isá ttu fusár gorér de, “Añr atehañsór manúc hon?” ");
INSERT INTO rhgc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isá ye zuwabe hoór de, “Ekbar, ezzon manúc Jerúsalem ottu nise Jerikót zaar, aar héṛe ḍahañit or át ot foijjé. Ítara yóggwar hoorsuor kúlifelai mara-dóra gorí, adá mora félai giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Baade eén óiye, ezzon imam hé foñt báy zaar, íba ye manúc cwa re dekí fachaṛi giiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Héndilla, ezzon Leévi yó hé zagat aái manúc cwa re dekí, fachaṛi giiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lekin ezzon Samári sofór goitté-goitté manúc cwar íñyot foóñicce; aar íba ttu manúc cwa re dekí feṭfuijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tói íba manúc cwar hañse aái, yóggwar zohóm ókkol ot tel edde anggur or roc ḍálidi faṭṭi bañdídiye; baade yóggwa re nizor gadár uore tulí looi, ekkán musáfer-hánat loizai kérmos goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tarfor din íba ye dui dinárṭiañ neelai musáfer-hánar girós ore dii hoór de, ‘Yoggwá re kérmos goró; zodi iín or túaro bicí hóssa ó, añí ailé tuáñre fúñzifelaiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Hé ísafe, hé tiní zon ottu, ḍahañit or át ot foijjé de manúc cwar atehañsór manúc honnwá bóuli ṭáaro?” ");
INSERT INTO rhgc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Alem mwa ye zuwab der de, “Yóggwar uore rahám goijjé de íba.” Isá ye yóggwa re hoór de, “Zoo, tuñí yó héndilla gorógoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isá edde Íbar cárit tun zaite-zaite ekkán farat góille; aar héṛe Morota nam or eggwá mayafua ye Íba re nizor gór ot estekbal goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Híba ttu Moriyam nam or eggwá bóin accíl, zibá ye Malik or ṭéng or gurat boói Íbar hotá fúnat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lekin Morota meéman ókkol olla waán-yián nal goitté-goitté ferecan óigiyoi; híba ye Isár hañse aái hoór de, “Malik, Tuñí no dekór né, añr bóine hédmot or ham beggún añí ezzon ore lagaidi táikke dé? Híba re añré modot goittó hoóna.” ");
INSERT INTO rhgc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Malike híba re zuwabe hoór de, “Morota, Morota, tui boóut kessú lói sintabáfanat edde ferecanit asós, ");
INSERT INTO rhgc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lekin ekkán siz beh zoruri; Moriyame hé gom híssa gán basíloiye deh, aar híyan híba ttu loiféla no zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ekbar eén óiye, Isá ye ekkán zagat dua gorér; Íba ttu dua goijjá óiye rár, Nizor cárit tun ottu ezzone Íba re hoór de, “Malik, añára re dua gorá cíko, zendilla Yaháya ye yó nizor ummot ókkol ore cíkaiye.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Íba ye ítara re hoór de, “Zeñtté tuáñra dua goró, hoibá de: ‘Ó Baf, Tuáñr nam pak mana zouk. Tuáñr raijjo aiyóuk. ");
INSERT INTO rhgc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Añára re añárar din or hána dine doo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Añárar guná ókkol maf goró, kiyólla-hoilé añára nize yó de zetará añára llói hosúri goré ítara re maf gorí. Añára re entán ot foitto no diyó.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Baade Isá ye ítara re hoór de, “Dóro, tuáñra honó ezzon ottu eggwá dustó asé, yóggwa ye dustór hañse raitnicít zai hoór de, ‘Dustó, añré tin nwá ruṭi udár dóh; ");
INSERT INTO rhgc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kiyólla-hoilé añr ek dustó íbar sofór ot zaite-zaite añr héṛe aiccé, aar íba re hábai bolla añr ttu kessú nái.’ ");
INSERT INTO rhgc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hétunot bútottu tái dustó ye hoór de, ‘Añré ferecan no goijjó, ehón duwar bañdá, aar añr fuain edde añí bisánat. Añí uṛí tuáñre kessú dii no faijjum.’ ");
INSERT INTO rhgc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Añí tuáñra re hoóir, zodi íte nizor dustó de hétolla uṛí kessú no diilé yo, toóu yóggwar warawori magar zoriya íte uṛí yóggwa ttu zedún lager hédun diibo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Hétolla Añí tuáñra re hoóir, mago, tuáñra re diiya zaybo; tuwo, tuáñra faiba; duwar baijjo, tuáñra lla duwar kúla zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kiyólla-hoilé zee niki mage, íte faa; zee niki tuwa, íte tuwai faa; aar zee niki duwar baijja, ítar lla kúla zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Tuáñrar bútore endilla baf hon asé, nizor fua ye mas magilé, mas or bodol háf diibo dé? ");
INSERT INTO rhgc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yáto anḍa magilé, bissú diibo dé? ");
INSERT INTO rhgc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hé ísafe, zodi tuáñra hóraf ói baade úddwa tuáñrar fuain dore gom-gom jiníc ókkol dii zano, tóoile tuáñrar asmani Bafe kiyá zetará Íba ttu mage ítara re Pak-Ruh no diito?” ");
INSERT INTO rhgc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ek din Isá ye eggwá buk bút dáfar; bút twa neeligiyói rár, buk accíl de manúc cwa mati faijjé, aar híyane manúc ókkol taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lekin ítara hodúne hoór de, “Ibá ye bút ókkol dáfa de bút ókkol or sóddar Belzebul or taakote.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ar hodúne Íba re entán gorár niyote, Íba ttu ekkán asmani nicán dabi goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Montor Íba ye ítarar báfani re zani ítara re hoór de, “Ze raijjot faáṭa-faáṭi foida ó, híyan toh fána óizagoi; aar ze gór ot faáṭa-faáṭi foida ó, híyan óu toh borbad óizagoi. ");
INSERT INTO rhgc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Héndilla, zodi Cóitan nizor ulḍa nize ó, ítar raijjo keéngori ṭikibó? Kiyólla-hoilé tuáñra hoór de, Añí bút dáfai de Belzebul or taakote. ");
INSERT INTO rhgc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Toóu zodi Añí bút dáfai de Belzebul or taakote de óile, tóoile tuáñrar fuain de har taakote dáfa dé? Hétolla tuáñrar bisarhar óibo de ítara. ");
INSERT INTO rhgc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lekin zodi Añí bút dáfai de Allar taakote de óile, tóoile toh Allar raijjo tuáñrar héṛe aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Zeñtté honó boluwar manúce átiyar fiñdí nizor gór ore faáradi táke, héñtte yóggwar sáman ókkol héfazot táke. ");
INSERT INTO rhgc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Montor zeñtté yóggwar túaro boluwar ezzon aái yóggwa re hámla gorí háraifele, héñtte manúc íba ye yóggwar hé átiyar loizagói ziín or uore yóggwa ye bóraca goittó, aar ziti ziín luṭ goijjé híin baṛidiféle. ");
INSERT INTO rhgc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Zee niki Añr híkka no, yóggwa Añr ulḍa; aar zee niki Añr fúañti dola no goré, yóggwa ye cíñṛaciñṭṭá goré. ");
INSERT INTO rhgc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Zeñtté honó manúc ottu hóraf jin neele, héñtte hé jin nwá fúana zaga ókkol ot zai aram goittó zaga tuwa. Montor no faile, nizoré nize hoó de, ‘Añí añr gór ot waafes zaiyumbói, zentú añí neeliaiccí.’ ");
INSERT INTO rhgc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yíba zeñtté waafes aiyé, hé zaga gán sáf goijjá edde ṭík goijjá lootfa. ");
INSERT INTO rhgc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Baade yíba zai aró háñt twa nizor túaro hóraf jin ané, aar híin góli héṛe táke. Tói hé manúc cwar fisór hálot agor hálot or túaro bicí hóraf óizagoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Isá ye híin hoór de októt, manúc or dol ottu eggwá mayafua ye guzori Íba re hoór de, “Mubarek oh feṭ zibát Tuñí accíla, edde oh dud ziín Tuñí háaila.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hétunot Isá ye hoór de, “Montor uitará aró bicí mubarek, zetará Allar kalam fúne edde amól goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zettót bicí manúc zoma ór, Isá ye howát cúru doijje de, “E zobanar manúc ókkol hóraf; itará nicán dabi goré, montor itará re nobi Yunus or nicán bade ar honó nicán diya no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kiyólla-hoilé Yunus zendilla Ninivi cóor or maincór lla nicán óoil, héndilla Manúc or Fua yó e zobanar maincór lla nicán óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kiyamot or din Cibá mulluk or rani e zobanar manúc iín or fúañti uṛíbo, edde itará re hosúr díbo; kiyólla-hoilé híba ye toh Sóloman or buddír hotá fúni bolla duniyair céc matá ttu aiccíl, aar soó, Sóloman or túaro ḍoóñr Ekzon iñyót asé. ");
INSERT INTO rhgc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kiyamot or din Ninivi cóor or manúc ókkol e zobanar manúc iín or fúañti tíyaibo, aar itará re hosúr díbo; kiyólla-hoilé ítara toh Yunus or elan fúni touwá goijjíl, aar soó, Yunus or túaro ḍoóñr Ekzon iñyót asé. ");
INSERT INTO rhgc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Honókiye toh serak dórai lukai yáh báñir or tole raké de nái, bólke boiṛónir uore beh raké, zeéne zetará bútore aiyé ítara foór deké. ");
INSERT INTO rhgc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tuáñr gaar serak óilde tuáñr suk; hétolla tuáñr suk gom asé de óile, tuáñr guñṛa gaa foóre furaiya óibo; montor hóraf óile, tuáñr gaa yó andáre furaiya óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hétolla úñciyar, tuáñr bútore ze foór asé híyan zeéne andár no. ");
INSERT INTO rhgc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Zodi tuáñr guñṛa gaa foóre furaiya táke aar honó ekkán híssa andár ot no táke, tóoile toh híyan endilla furafuri foór ot óibo, zendilla serak dóraile tuáñre foór deh.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Isá ye híin boiyan gorér de októt, ezzon Féroci ye Íba re nizor fúañti hána háito dawot diyé; tói Íba bútore zai háito boiccé. ");
INSERT INTO rhgc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Íba ye hána háibar age át nó dúwe de dekí, Féroci wa ammúk óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Malike yóggwa re hoór de, “Tuáñra Féroci ókkole fiyalar edde tál-basón or baárḍák beh sáf goró, montor tuáñrar bútore toh lalóse edde hórafiye furaiya. ");
INSERT INTO rhgc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ó fool ókkol, baárḍák banaiyé de Alla ye ki bútor or ḍák óu nó bana né? ");
INSERT INTO rhgc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tuáñra ttu ziín asé híin sótka gorífelo, tói tuáñra lla hárr kessú pak-sáf óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ó Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh fudinar, tesfatar edde kétir hárr kisím or hák or doc bák or ek bák doo, lekin Allar insáf edde muhábbot ore bad difélo. Tuáñra ttu iín óu gorón accíl aar uúin óu bad no don accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ó Féroci ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh mujilíc-hána ókkol ot uñsol tokkar hadírat boitó fosón goró, edde bazare-bazare sólam faito soó. ");
INSERT INTO rhgc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh ót no faa de hobor or ḍóilla, ziín or uottú maincé hoi no fari áñṛe.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hétunot Córiyot or alem ókkol ottu ezzone Isá re hoór de, “Ustat, Tuñí de híin hoói añára re yó beizzoti gorór.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Íba ye hoór de, “Ó alem ókkol, tuáñrar uore yó afsús! Kiyólla-hoilé tuáñra toh maincór uore endilla fuñzá tulído, ziín boité duk, montor tuáñra nize toh fuñza híin ot eggwá ooñl úddwa no lago. ");
INSERT INTO rhgc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh nobi ókkol or hobor ore banaituló, aar ítara re marifélail de tuáñrar bafdada ókkole. ");
INSERT INTO rhgc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Héengori tuáñra gobá dó de ki, tuáñra tuáñrar bafdada ókkole goijjíl de ham ot razi asó; kiyólla-hoilé nobi ókkol ore marifélaiye de toh ítara, aar ítarar hobor ore banaituló de tuáñra. ");
INSERT INTO rhgc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hétolla toh Alla ye Nizor giyane endilla hoiyé, ‘Añí ítarar hañse nobi edde rosúl ókkol difeṛáiyum, ítara héntu hodún ore marifélaibo edde hodún ore zulúm goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hétolla duniyair foidayecir héñtte lóti zedún nobi ókkol or lou báca gíyeh, híin beggún or zimmadar óibo de e zobanar manúc ókkol, ");
INSERT INTO rhgc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel or lou wóttu lóti oh Zakaríyahr lou foijjonto, zibá re kurbani-gáñr edde pak zagar mazémaijja kún gorá gíyeh. Ói, Añí tuáñra re hoóir, híin or zimmadar óibo de e zobanar manúc ókkol.’ ");
INSERT INTO rhgc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ó Córiyot or alem ókkol, tuáñrar uore afsús! Kiyólla-hoilé tuáñra toh buddír sabí loifélaiyo; tuáñra nize yó nó gólo, aar góler de ítara re yó oóñsi raikkó.” ");
INSERT INTO rhgc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Isá héntu neeli zaargói de októt, alem edde Féroci ókkole rak gorí Íba re ḍoilla-boḍoilla súwal ókkol gorát doijje, ");
INSERT INTO rhgc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","aar héengori ítara Íba re Íbar hotá lói hol ot félaito sooñi gorí accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hé októt, zeñtté edún ázar-ázar manúc zoma óiye zeén níki ítara ezzon or uore ezzon forer, Isá ye ebbe age Nizor cárit tun ore howá cúru goijjé de ki, “Féroci ókkol or cúṭar ottu úñciyar táikko, yáni ítarar munaféki ttu. ");
INSERT INTO rhgc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kiyólla-hoilé zahér no óibo de héndilla honó jiníc gúijja nái, aar zana no zaybo de héndilla honó jiníc lukaiya nái. ");
INSERT INTO rhgc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hé ísafe, tuáñra ziín andár ot hoiyó, híin foór ot fúna zaybo; aar ziín bútor or kamára ókkol ot fúcfucaiyo, híin gór or sád or uottú elan gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ó añr dustó ókkol, Añí tuáñra re hoóir, uitará re no ḍooraiyó zetará haiya re kotól goré montor yárbaade ar kessú gorí faribár no táke. ");
INSERT INTO rhgc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lekin Añí daháidi tuáñra ttu haré ḍoora foribó: Ubá re ḍooro zibá ttu tuáñr haiya re marifélai baade zuzuk ot félaidibar kémota asé. Ói, Añí tuáñra re hoóir, Íba re beh ḍooro. ");
INSERT INTO rhgc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fañs swá fiañijja ki hom ṭiañ loi no bese né? Toóu híin or bútottu Alla ye eggwá re yó no foóra. ");
INSERT INTO rhgc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Becók tuáñrar matár sul úddwa beggún Íba ttu gona asé. No ḍooraiyó, tuáñrar kimot boóut fiañijja ókkol or túaro bicí. ");
INSERT INTO rhgc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Añí tuáñra re hoóir, zee niki Añré maincór muúntu cíkar goré, yóggwa re Manúc or Fua ye yó Allar fírista ókkol or muúntu cíkar goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Montor zee niki Añré maincór muúntu inkar goré, yóggwa re Allar fírista ókkol or muúntu inkar gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Honókiye Manúc or Fuar hélaf honó hotá hoilé, yóggwa re toh maf gorídiya zaybo; montor zee niki Pak-Ruhr kuféri goré, yóggwa re maf gorídiya no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Zeñtté maincé tuáñra re mujilíc-hána ókkol ot, edde hákim edde adikari ókkol or hañse loiza, héñtte hondilla yáh kii zuwab diba yáto kii hoibá de sinta no goijjó; ");
INSERT INTO rhgc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kiyólla-hoilé tuáñra ttu ziín howá foribó, híin tuáñra re Pak-Ruh ye hétunot cíkaidibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Manúc or dol lwá ttu ezzone Isá re hoór de, “Ustat, añr bái ore añár lói miras bák gorífelaito hoó.” ");
INSERT INTO rhgc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Montor Íba ye yóggwa re hoór de, “O miyañ, Añré tuáñrar bisarhar yáh bák gorídoya hone banaiyé?” ");
INSERT INTO rhgc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tarfore Íba ye ítara re hoór de, “Hóboroddar, hárr kisím or lalsí ttu basi táikko; kiyólla-hoilé insán or zindigi nizor ṭal-ṭal dón-cómbottir uore no.” ");
INSERT INTO rhgc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Íba ye ítara re ekkán meésal hoiyé, ki hoilé, “Ezzon dónir zobin ot bicí fósol dóijje. ");
INSERT INTO rhgc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yóggwa ye nizorgá nize báfer de, ‘Añí kii goittám, añr ttu de fósol zoma rakíbar zaga nái?’ ");
INSERT INTO rhgc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Yóggwa ye hoór de, ‘Añí endilla goijjúm: añr gudam ókkol báñgifelai ḍoóñr-ḍoóñr góri banaiyúm, aar añr fósol edde mal-sámana beggún héṛe rakíyum. ");
INSERT INTO rhgc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Baade añí añr ruh re hoiyúm de, ó ruh, tor ttu boóut bosór olla bicí kúraf asé. Yala cúk gór, háafiya gór edde kúci ták.’ ");
INSERT INTO rhgc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Montor Alla ye yóggwa re hoór de, ‘Ó fool, aijja raitta de tor zan loiféla zaybo; tói tui ziín zoma goijjós híin har óibo?’ ");
INSERT INTO rhgc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Héndilla óilde manúc ubá, zee niki nizor lla dón zoma goré, montor Allar nozor ot tuangor no.” ");
INSERT INTO rhgc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yárbaade Isá ye Íbar ummot ókkol ore hoór de, “Hétolla Añí tuáñra re hoóir, kii háiyum hoói zindigi lla sinta no goijjó, aar kii fiñdíyum hoói gaa lla sinta no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kiyólla-hoilé zindigi toh hánar túaro kimoti, aar gaa toh hoorsuor or túaro kimoti. ");
INSERT INTO rhgc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hawa ókkol or baabute báfiso; híine toh no cíñṛe, no daa, aar no híin ottu gudam yáh hañjja asé; toóu Alla ye híin ore háaba. Tuáñra toh faik ókkol or túaro bicí kimoti. ");
INSERT INTO rhgc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tuáñra hone sinta gorí nizor hóiyat ore ek gónḍa barái faribá de asó? ");
INSERT INTO rhgc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tuáñra héttirin ham mán úddwa gorí no faille, oinno siz olla kiyá sinta goró? ");
INSERT INTO rhgc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Fúl ókkol or baabute báfiso, híin keéngori barí uṛé deh; híine toh no meénnot goré, aar no fúñta haṛe; montor Añí tuáñra re hoóir, baáñcca Sólomane úddwa yóggwar tamám dón-doulot loi híin ekgwár ḍóilla nizoré háñzai faijjé de nái. ");
INSERT INTO rhgc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hétolla, zodi Alla ye moidan or kér ore héndilla góri háñza, ziín aijja asé aar hailla ooin ot félaidiya zah; tóoile ó hom biccác ola ókkol, Íba ye tuáñra re aró hotó háñzaibo fáñllar? ");
INSERT INTO rhgc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kii háiba yáh kii fiíba híin or talac ot fori no táikko; híin or baabute sinta no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kiyólla-hoilé duniyair bedini ókkole éna híin beggún or fisé lagi táke, montor tuáñra ttu híin lager de híyan tuáñrar Bafe zane. ");
INSERT INTO rhgc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yárbodol Allar raijjor talac ot táko, tói tuáñra re híin beggún óu diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ó bérasóol or gura zák, no ḍooraiyó, kiyólla-hoilé tuáñrar Baf ottu tuáñra re raijjo diiya fosón laiggé. ");
INSERT INTO rhgc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tuáñrar jiníc ókkol besi sótka gorífelo, aar nizor lla endilla ṭiañr zali toiyar goró zibá furan ói no zagói, yáni asman ot endilla dón-cómbotti zoma goró, ziín honódin no fúra, zeṛé sur ḍáke nu aiyé aar fuke nac no goré. ");
INSERT INTO rhgc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kiyólla-hoilé tuáñrar dón-cómbotti zeṛé, tuáñrar dil tákibo de yó héṛe. ");
INSERT INTO rhgc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Tuáñra guṭ doh edde serak dórai rakó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tuáñra yó undilla manúc or ḍóilla ó zetará nizor girós boirat ottu hoñtté waafes aibó de híyan or entezar ot táke, zeéne yóggwa aái duwar baijjaile mottor yóggwa re duwar kúlidi fare. ");
INSERT INTO rhgc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mubarek goóur uitará zetará re girós ailé sooñi táikka lootfa. Añí tuáñra re sóiyi hoóir, yóggwa ye keeñil bañdí hé goóur ókkol ore hána háito buágaraibo, aar ḍáke aái ítara re hána hábaibo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zodi yóggwa ye adá raitta yáh yárbaade ailé yo ítara re toiyar táikka lootfa, tóoile hé goóur ókkol toh mubarek. ");
INSERT INTO rhgc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Lekin yián zani rakó de ki, zodi gór or giróse sur hoñtté aibó de zainto, yóggwa ye nizor gór ore báñgito no dito. ");
INSERT INTO rhgc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tuáñra yó toiyar táko, kiyólla-hoilé Manúc or Fua tuáñra no ṭáaro de októt beh aibó.” ");
INSERT INTO rhgc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hétunot Fitore hoór de, “Malik, Tuñí e meésal lan añára re hoór de né náki beggún ore?” ");
INSERT INTO rhgc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Malike hoór de, “Tóoile eén biccácdaredde buddíman mazí hon asé, zaré ítar giróse nizor oinno goóur ókkol or uore zimmadar banaibó, ítara re ṭaim or uore hána baṛidi bolla? ");
INSERT INTO rhgc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mubarek goóur ubá zaré nizor giróse waafes ailé ham híin gorér de lootfa. ");
INSERT INTO rhgc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Añí tuáñra re sóiyi hoóir, yóggwa ye nizor tamám cómbottir uore ítare zimmadar banaibó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lekin zodi hé goóure nizor dile-dile endilla hoó, ‘Añr girós aité boóut deri asé,’ aar íte oinno goóur edde bañdi ókkol ore marat dore edde háafiya gorí ṭuúl óizagoi; ");
INSERT INTO rhgc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tóoile hé goóur or girós eén din ot aibó, ze din íte yóggwa aibó de no ṭáare, edde eén októt aibó, ze októt íte hoi no fare. Tói yóggwa ye ítare haṛi hán-hán gorífelaibo edde nafórman ókkol or héṛe cámil goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ze goóure girós or moncá re zane montor toiyar nó yáto yóggwar moncá mozin nó goré, íte bicí fiṛa háibo; ");
INSERT INTO rhgc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","montor zee niki no zani, fiṛa há de héndilla ham goré, íte bicí hom fiṛa háibo. Kiyólla-hoilé zaré bicí diiya giyéh, ítar ttu bicí dabi gorá zaybo; aar zaré bicí gosáidiya gíyeh, ítar ttu aró bicí maga zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Añí duniyait ooin zolaidito aiccí deh, zodi age lóti zolaiya óito, Añí keén kúci óitam! ");
INSERT INTO rhgc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lekin Añr ttu eggwá bápṭisma loibar asé, yíba nó loi foijjonto Añí keén ferecanit así! ");
INSERT INTO rhgc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Añí duniyait cánti diito aiccí bóuli ṭáaro níki? Añí tuáñra re hoóir, no, bólke faáṭa-faáṭi foida goittó aiccí deh; ");
INSERT INTO rhgc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","kiyólla-hoilé ehón ottu lóti ek gór or fañs zon manúc alok-alok óizayboi: tin zon dui zon or ulḍa, aar dui zon tin zon or ulḍa. ");
INSERT INTO rhgc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ítara endilla alok óizayboi: fuar ulḍa baf, baf or ulḍa fua, zérfuar ulḍa maa, maar ulḍa zérfua, bou wór ulḍa hóuri, aar hóurir ulḍa bou.” ");
INSERT INTO rhgc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Íba ye manúc ókkol ore yó hoór de, “Fosím ottu miyúla uṛér de dekíle tuáñra toratori hoó de, ‘Zór aibó,’ aar borabor héndilla ó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aar doóinali boiyar bailé hoó de, ‘Gorom foribó,’ aar héndilla ó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ó munafék ókkol! Tuáñra toh zobin or edde asman or súrot saái moósum forók gorí zano, montor ehón or zobana re kiyá forók gorí no zano? ");
INSERT INTO rhgc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Tuáñra nize kiyá ziyán sóiyi híyan or fáisela no goró? ");
INSERT INTO rhgc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Zeñtté tuñí tuáñr duccon or fúañti bisarhar or hañse zoo, héñtte foñt ot tákite ítar lói maamela hól gorífelaibar kucíc goijjó, arnóile íte tuáñre bisarhar or át ot gosáidibo, aar bisarhare tuáñre fulic or át ot gosáidibo, baade fulice tuáñre ziyól maribó. ");
INSERT INTO rhgc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Añí tuáñre hoóir, tuñí ahéri foicá nó doo foijjonto héntu hálas ói no faribá.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hé októt héṛe endilla hodún manúc házir accíl, zetará Isá re Galil or manúc uitarár baabute hóbor díyl zetará re baitul-mukaddos ot kurbani dibarcót Filate kotól goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isá ye ítara re zuwabe hoór de, “Galil or manúc ítarar uore hé docá gán óiye de híyan olla tuáñrar kíyal ot kí ítara Galil or oinno manúc beggún or túaro bicí gunágar accíl? ");
INSERT INTO rhgc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Añí tuáñra re hoóir, no, bólke touwá no goríle, tuáñra beggún óu héndilla hálak óizaybagoi. ");
INSERT INTO rhgc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yáh ze añṛáro zon manúc Sílom or minár fori morigiyói, tuáñrar kíyal ot kí ítara Jerúsalem ot táke de oinno manúc beggún or túaro bicí gunágar accíl? ");
INSERT INTO rhgc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Añí tuáñra re hoóir, no, bólke touwá no goríle, tuáñra beggún óu héndilla hálak óizaybagoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tarfore Isá ye e meésal lan hoiyé: “Ezzon maincé nizor bagan ot eggwá ḍuñir-gas lagaáil. Yóggwa ye gas swát gula tuwaitó aiccíl, montor eggwá yó nó faa. ");
INSERT INTO rhgc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hétolla yóggwa ye bagan sóoñloya re hoór de, ‘Saá, añí tin bosór foijjonto e ḍuñir-gas swát gula tuwaitó aiyír, montor eggwá yó nó fai. Yibá re haṛiféla, yibá ye hánnak meṛi kiyá estemal goittó?’ ");
INSERT INTO rhgc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Sóoñloya ye yóggwa re zuwabe hoór de, ‘Ó malik, yibá re e bosór óu tákito dóh, añí yibár sairókul ttu kurí fáñic díyum. ");
INSERT INTO rhgc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Baade zodi aiyér de bosór gula dóre, tóoile ṭík asé; montor zodi no dóre, haṛifelaiyo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ek ebaadot-or-din Isá ekkán mujilíc-hánat taalim der. ");
INSERT INTO rhgc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Héṛe endilla eggwá mayafua accíl zibá re eggwá hóraf jine biyaraimma banai raikké de añṛáro bosór óiye. Yóggwa guza accíl, aar bilkúl uzu ói no faitto. ");
INSERT INTO rhgc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isá ye yóggwa re dekí, ḍáke matai hoór de, “O hála, tuñí tuáñr biyaram ottu azad óiyo.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tarfore Íba ye yóggwar uore át díye, tói éhon-éhon yóggwa uzu óigiyoi aar Allar taarif gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lekin mujilíc-hánar sóddare, Isá ye ebaadot-or-din biyaraimma gom goijjé de hétolla guccá góri manúc ókkol ore hoór de, “Ham goittó sów din asé; hétolla din híin ot aái gom óiyogai, ebaadot-or-din no.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Montor Malike yóggwa re zuwabe hoór de, “Ó munafék ókkol, tuáñra fottíkiye kí ebaadot-or-din nizor doóñra goru re yáh gadá re ura ttu kúli faní hábaito no loizo né? ");
INSERT INTO rhgc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tói e mayafua, zibá Ibrahím or zérfua, zibá re Cóitane añṛáro bosór fán bañdí raikkíl, yoggwá re kí ebaadot-or-din hé bañdá ttu azad gorídiya no zah né?” ");
INSERT INTO rhgc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Íba ye híyan hoiyé rár, Íbar muhálef-goróya beggúne córom faiyé; aar Íba ye ze taajuippa ham goittó híine awam ókkol beggún kúci óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tói Isá ye hoór de, “Allar raijjo kiyór ḍóilla? Híyan ore Añí kii loi borabor goittám? ");
INSERT INTO rhgc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Híyan óilde eggwá hóroir danar ḍóilla, zibá re ézzon manúce looi nizor kétit lagayégoi; yíba barí uṛí eggwá gas boinné, aar faik ókkole yíbar ḍéeila ókkol ot bahá baindé.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Íba ye abar hoór de, “Añí Allar raijjo re kii loi borabor goittám? ");
INSERT INTO rhgc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Híyan óilde cúṭar or ḍóilla, ziín ore eggwá mayafua ye looi tokoriban ekkuri tin cér aṭat miyáiye, baade guñṛa hañi or dola fúli uiṭṭé.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Isá cóore-cóore edde fara-fara taalim di-di, Jerúsalem or uzu zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ezzone Íba re hoór de, “Malik, nejat foya hom níki?” Íba ye ítara re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Siyon doroza báy góli bolla zan-forane kucíc goró, kiyólla-hoilé Añí tuáñra re hoóir, boóut zon góilto kucíc goríbo montor no faribó. ");
INSERT INTO rhgc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Zeñtté gór or giróse uṛí duwar bañdífelaibo, tuáñra baáre tíyai duwar bajjai-bajjai endilla howát doriba, ‘Ó Malik, añára lla duwar gán kúlo.’ “Montor Íba ye tuáñra re zuwabe hoibó de, ‘Añí no zani tuáñra hoṛíyar.’ ");
INSERT INTO rhgc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Hétunot tuáñra howát doriba de, ‘Añára toh Tuáñr fúañti háafiya goijjílam, aar Tuñí añárar rasta-rasta taalim dita.’ ");
INSERT INTO rhgc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Montor Íba ye hoibó de, ‘Añí tuáñra re hoóir, Añí no zani tuáñra hoṛíyar. Kuham-goróya ókkol, tuáñra beggún Añr héntu dur ó.’ ");
INSERT INTO rhgc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Héṛe tuáñra hañdahaṛi goríba edde date dat kirkiraibá zeñtté tuáñra dekíba de, Ibrahím, Isahák, Yakub edde tamám nobi ókkol Allar raijjor bútore, montor tuáñra re baáre félaidiya gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aar manúc ókkol fuk, fosím, uttor, edde doóin ottu aái Allar raijjot háito boibó. ");
INSERT INTO rhgc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Becók, zetará ehón fisé asé, ítara age óizayboi; aar zetará ehón age asé, ítara fisé óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hé októt hoozzon Féroci ye aái Isá re hoór de, “Tuñí e zaga ttu honó mikká zoogói, kiyólla-hoilé Hérud ottu Tuáñre marifeilto monehoór.” ");
INSERT INTO rhgc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Íba ye ítara re hoór de, “Zoo, hé cíyal ore hoibá de, ‘Añí aijja edde hailla bút dáfaiyum edde biyaraimma ókkol ore gom goríyum, aar tin din ot din Añr moksót fura óibo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Zeén óibo óuk, Añr ttu aijja, hailla edde foórur uzu sofór gorá foribó; kiyólla-hoilé honó nobir moot toh Jerúsalem or baáre ói no fare. ");
INSERT INTO rhgc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerúsalem, ó Jerúsalem, tui zee niki nobi ókkol ore kotól gorós edde zetará re tor héṛe difeṛá gíyeh ítara re cíl or dola maros. Kuúñri-kurá ye zendilla nizor sóo ókkol ore yíbar fak or bútore zoma gorí raké, héndilla tor fuain dore zoma gorí rakí bolla Añí hotó bar saiyí de asé, montor tuáñra híyan nó soó. ");
INSERT INTO rhgc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Fúno, tuáñrar gór tuáñrar suk or muúntu sáragor óizayboi. Añí tuáñra re hoóir, tuáñra Añré etókkal no dekíba zetókkal tuáñra nó hoó de, ‘Mubarek Ubá zibá Mabud or name aiyér.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ekbar eén óiye, ek ebaadot-or-din zeñtté Isá Féroci ókkol or ezzon sóddar or gór ot hána háito giiyé, manúc ókkole Íbar uore háas nozor raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Héṛe Íbar muúntu endilla ezzon manúc accíl zibá ttu fúla biyaram asé. ");
INSERT INTO rhgc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isá ye alem edde Féroci ókkol ottu fusár gorér de, “Ebaadot-or-din biyaram gom goríbar zayes asé né nái?” ");
INSERT INTO rhgc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Montor ítara nizám mári táikkil. Íba ye manúc cwa re áte dóri gom goijjé, baade duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tarfore Íba ye ítara re hoór de, “Tuáñrar bútore endilla hon asó, zee niki nizor fua yáh doóñra-goru ebaadot-or-din kuwat forilé, yíba re éhon-éhon tulí no loiba de?” ");
INSERT INTO rhgc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Montor ítara híyan or honó zuwab di nó fare. ");
INSERT INTO rhgc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Isá ye zeñtté dawot faiyé de meéman ókkole hondilla gori izzoitta zaga basíloor de deikké, Íba ye ítara re ekkán meésal diyé: ");
INSERT INTO rhgc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Honókiye tuáñre boiraitta hánat dawot dilé, zai yore izzoitta zagat no boiccógoi, kiyólla-hoilé óitofare yóggwa ye tuáñr túaro izzotdár ézzon ore dawot diyé. ");
INSERT INTO rhgc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Zodi boiyó, zee niki tuáñre edde íba re dawot diyé, yóggwa ye aái tuáñre hoibó de, ‘Tuáñr zaga gán e manúc cwa re doo.’ Hétunot tuáñr ttu córom fai, nisor zagat zai buá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yárbodol, dawot faile, zai yore nisor zagat boiccógoi, zeéne zee niki tuáñre dawot diyé, yóggwa ye aái hoó de, ‘Dustó, uoror zagat zai boiyógoi.’ Hétunot tuñí tuáñr fúañti hána háar de ítara beggún or muúntu izzot faiba. ");
INSERT INTO rhgc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kiyólla-hoilé zee niki nizoré nize ḍoóñr kúwala, ítare cóñṛo gorá zaybo; aar zee niki nizoré nize cóñṛo kúwala, ítare ḍoóñr gorá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Baade Isá ye zee niki Íba re dawot diyé yóggwa re hoór de, “Tuñí duúñijjar yáh biyal or hána goríle, tuáñr dustó ókkol ore, báiyain dore, eganaguiccí re, yáh atehañsór tuangor ókkol ore dawot no diyó; zodi doh, ítara yó waafes tuáñre dawot di fúñzaydibo. ");
INSERT INTO rhgc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yár túaro, tuñí hána goríle, lulá, leng, edde añdá manúc ókkol ore dawot diyo, ");
INSERT INTO rhgc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tói tuñí borhot faiba, kiyólla-hoilé ítara toh tuáñre fúñzaidi no faribó; aar forhésgar ókkol háñcor-or-din zinda ói uṛíbo de híyala tuñí bodola faiba.” ");
INSERT INTO rhgc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Isár fúañti hána háito boiccé de ítara ttu ezzone híyan fúni hoór de, “Mubarek ubá zibá ye Allar raijjot hána háibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Íba ye yóggwa re hoór de, “Ezzon maincé eggwá ḍoóñr hána goijjé, aar boóut kiyó re dawot diyé. ");
INSERT INTO rhgc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hánar októ óiye rár, ítara re endilla hoói matai bolla yóggwa ye nizor goóur difeṛáiye, ‘Aiyó, yala beggún toiyar óiye.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Montor ítara zon-zon beggúne bahána diyat doijje. Foóilar íte hoór de, ‘Añí ekkán zaga kinní, añr ttu híyan saitó zaa foribó; meérbani góri añré maf goró.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ar ezzone hoór de, ‘Añí fañs zura doóñra-goru kinní, añí híin háṛibo né saitó zair; meérbani góri añré maf goró.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aró ézzone hoór de, ‘Añí noya-noya biyá goijjí deh; añí aái no faijjum.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tói goóur gwá aái tar girós ore híin zanaiyé. Baade gór or giróse guccá góri nizor goóur ore hoór de, ‘Toratori cóor or rasta-rasta edde goldi-goldi zai gorif, mazur, añdá edde leng ókkol ore angói.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Tarfore goóur gwá ye hoór de, ‘Malik, tuñí zeén hókum goijjó héen goijjá óiye, lekin aijjó zaga háli asé.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Giróse goóur gwá re hoór de, ‘Baáre rasta-rasta edde foñté-foñté zaa, zai manúc ókkol ore eṛé ai bolla mojbur goríc, zeéne añr gór bórizagoi. ");
INSERT INTO rhgc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kiyólla-hoilé añí tuáñra re hoóir, zetará re dawot diya giyéh, ítara honókiye añr hána hái no faribó.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ekbar zeñtté becábicí manúc Isár fúañti zaat accíl, Íba ye fíri ítara re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Zee niki Añr héṛe aiyé yóggwa ye nizor baf, maa, bou, fuain, báiyain edde bóinain ore, bólke nizor zan ore úddwa Añré goré de yár túaro hom muhábbot no goillé, yóggwa Añr ummot ói no fare. ");
INSERT INTO rhgc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Zee niki nizor kúruc no boói Añr fisáli dore, yóggwa Añr ummot ói no fare. ");
INSERT INTO rhgc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kiyólla-hoilé tuáñrar bútore endilla hon asé, ekkán minár banaitó sailé age boói nizor ttu híyan furafuri banai bolla kula de hédun ṭiañ-foicá asé né nái kiyas no goríbo dé? ");
INSERT INTO rhgc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Arnóile toh zeñtté yóggwa ye guijja gán tulí baade guñṛa tulí no fare, zetará dekíbo ítara beggúne yóggwa re téceraibo, ");
INSERT INTO rhgc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","eén hoói, ‘E manúc cwa ye bana cúru goijjíl, montor guñṛa tulí nó fare.’ ");
INSERT INTO rhgc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Yáto, endilla baáñcca hon asé, arek baáñcca llói larái goittó zaibar tákile age boói nizor doc ázar fóous lói, nizor hélaf aibó de kuri ázar fóous or mukabela gorí faribó né no faribó kiyas no goríbo dé? ");
INSERT INTO rhgc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","No faribó de óile, yóggwa ye duré tákite nomainda difeṛái, bonizaybói lla corót or aros goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Borabor héndilla, tuáñra ttu zee niki nizor hárr kessú eri no deh, yóggwa Añr ummot ói no fare. ");
INSERT INTO rhgc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nun toh gom jiníc, montor zodi nun or dok zaagói, tóoile híin ore keéngori abar nuncá gorá zaybo? ");
INSERT INTO rhgc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Híin toh no zobin olla ham aiyé aar no fáñic ísafe ham aiyé; maincé híin ore baáre félaide. “Zar ttu fúnibar han asé, yóggwa ye fúno.” ");
INSERT INTO rhgc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tamám házana-tulóya edde gunágar ókkol Isár hotá fúni bolla Íbar hañse aitó. ");
INSERT INTO rhgc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Montor Féroci ókkole edde alem ókkole endilla hoói cékayot gorát doijje, “E Manúc cwa ye gunágar ókkol lói miyáñ, aar ítarar fúañti hána háa.” ");
INSERT INTO rhgc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hétunot Íba ye ítara re e meésal lan hoiyé: ");
INSERT INTO rhgc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dóro tuáñra honó ezzon ottu ek cót bérasóol asé, zodi héntu eggwá áñzizagoi, tóoile íte kí nobboi-now wa re kílat eri, áñzigiyoi de yíba re tuwai nó faa foijjonto no tuwaibó né? ");
INSERT INTO rhgc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Íte tuwai faile toh kúciye yíba re hañd ot loibo, ");
INSERT INTO rhgc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aar gór ot aái ítar fúañijja edde atehañsór manúc ókkol ore matai hoibó de, ‘Añr fúañti kúci gorógai, kiyólla-hoilé añí añr áñzigiyoi de bérasóol lwá tuwai faiyí.’ ");
INSERT INTO rhgc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Añí tuáñra re hoóir, ṭík héndilla, touwá gorá no fore de nobboi-now zon forhésgar or túaro ezzon gunágar touwá goillé asman ot aró bicí kúci óibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yáh, dóro eggwá mayafua ttu doc cán rufar foicá asé, zodi héntu ekkán foicá áñzizagoi, tóoile híba ye kí serak dórai gór kuuñsai híyan ore tuwai nó faa foijjonto cúndorgori no tuwaibó né? ");
INSERT INTO rhgc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Híba ye tuwai faile toh nizor fúañijjani edde atehañsór manúc ókkol ore matai endilla hoibó, ‘Añr fúañti kúci gorógai, kiyólla-hoilé añí añr áñzigiyoi de foicá gán tuwai faiyí.’ ");
INSERT INTO rhgc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Añí tuáñra re hoóir, ṭík héndilla, ezzon gunágar touwá goillé Allar fírista ókkol or muúntu kúci ó.” ");
INSERT INTO rhgc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isá ye aró hoór de, “Eggwá maincór ttu duwá fua accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ítara ttu cóñṛo wa ye baf ore hoór de, ‘Abá, añr borat ot fore de cómbotti añré diifélo.’ Tói bafe nizor cómbotti ítara re borat gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Hooddin baade, fua cóñṛo wa ye nizor hárr kessú dola gorí looi ekkán durór mulluk ot giiyégoi, aar héṛe íte monzakká soli nizor cómbotti sárhar gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Zeñtté ítar ttu hárr kessú hóros gorífelaya óiye, hé mulluk ot eggwá ḍoóñr raṭ óiye, aar íte muútac ot forat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tói íte zai hé mulluk or ezzon bácinda ttu ham saiyégoi, aar yóggwa ye ítare cúwor sorai bolla nizor kílat difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cúwor gúne ze gas or sóñi ókkol háito, ítar ttu híin hái feṭ bóraito monehoitó, montor honókiye ítare no diito. ");
INSERT INTO rhgc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Fore íte buzón ot aái hoór de, ‘Añr baf or edún muzur ókkole háito becábicí hána faar, aar añí toh eṛé búkke morir! ");
INSERT INTO rhgc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Añí uṛí añr baf or héṛe zaiyumbói, zai íba re hoiyúm de: Abá, añí Allar edde tuáñr ulḍa hosúri goijjí. ");
INSERT INTO rhgc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Añré ar tuáñr fua hoibár laayek no; añré tuáñr eggwá muzur or ḍóilla góri rakó.’ ");
INSERT INTO rhgc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tói íte uṛí baf or héṛe giiyé. “Íte duré táite ítare dekí baf ottu feṭfuijje, aar duñri zai ítare añza mari appá díye. ");
INSERT INTO rhgc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Fua ye baf ore hoór de, ‘Abá, añí Allar edde tuáñr ulḍa hosúri goijjí, añré ar tuáñr fua hoibár laayek no.’ ");
INSERT INTO rhgc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Montor bafe nizor goóur ókkol ore hoór de, ‘Toratori ebbe barík zubba aní itaré fiñdáido; itar át ot oóñṛi diyaido aar ṭéng ot cenṭár fiñdáido. ");
INSERT INTO rhgc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Goru boli wa aní zooró. Añára hái kúci-áci gorí. ");
INSERT INTO rhgc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kiyólla-hoilé añr e fua wa mora accíl, montor abar zinda óiye; ite áñzigilgoi, montor yala faa giyéh.’ Tarfore ítara beggúne kúci gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Héñtte yóggwar fua ḍoóñr gwá kétit accíl; íte gór or ḍáke foóñicce rár, talbazanar edde nas or abas fúinne. ");
INSERT INTO rhgc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hétunot íte eggwá goóur ore matai, eṛé kii ór de fusár goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tee ítare hoór de, ‘Tuáñr bái waafes aiccé, aar tuáñr bafe goru boli wa zooráiye, kiyólla-hoilé yóggwa ye ítare sóiyi-sólamote fírai faiyé.’ ");
INSERT INTO rhgc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Híyan fúni íte guccá óigiyoi aar bútore góilto no sar. Montor baf baáre aái, ítare manat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lekin íte baf ore zuwabe hoór de, ‘Soó, etó bosór fán añí tuáñr gulami gorí-gorí aiyír, aar añí tuáñr hókum honódin no mani nó táki; toóu tuñí añré añr dustó ókkol or fúañti kúci-áci gorí bolla eggwá sóol or sóo úddwa honódin diiyó de nái. ");
INSERT INTO rhgc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Montor tuáñr fua ite zeñtté aiccé, zee niki tuáñr cómbotti magi ókkol lói fúraifelaiye, tuñí ítar lla goru boli wa zooráiyo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Hétunot bafe ítare hoór de, ‘O fut, tui toh añr fúañti hámica asós, aar añr ttu ziín asé híin beggún de tor. ");
INSERT INTO rhgc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Montor añára ttu yala kúci-áci edde mela gorár zorur, kiyólla-hoilé tor bái ibá mora accíl, aar abar zinda óiye; áñzigilgoi, yala faa giyéh.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isá ye cárit tun ore yó hoór de, “Ezzon tuangor manúc ottu eggwá zimmadar accíl, hé zimmadar gwá ye yóggwar dón-cómbotti sárhar gorífeler hoói yóggwar hañse hóbor foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tói yóggwa ye ítare matai fusár gorér de, ‘Añí tor baabute iín kii fúnir? Tor zimmadari ham or ísaf déh, kiyólla-hoilé tui ar zimmadar táki no faribí.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Hétunot zimmadar gwá ye nizoré nize hoór de, ‘Yaa añí kii goittám? Añr giróse de añr ttu zimmadari ham loifeler. Añr ttu de meṛi haṛitó bol nái, aar hórat magité yó córom lage. ");
INSERT INTO rhgc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Añí kii goijjúm de zani faijjí, zeéne zeñtté añr ttu zimmadari ham loiféle, maincé añré ítarar gór ot zaga dee.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tói íte zon-zon gori girós or footidár ókkol ore mataiyé, matai foóila wa re hoór de, ‘Añr giróse tuáñr ttu footi hodún faar?’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Tee hoór de, ‘Now cót gelómzaitun tel.’ “Íte hoór de, ‘Tuáñr bil lán loo, toratori boói sair-có fonzaic gelóm lekído.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Tarfore íte ar ezzon ore hoór de, ‘Tuáñr ttu hodún faar?’ “Tee hoór de, ‘Fonzaic mongiyuñ.’ “Íte taré hoór de, ‘Tuáñr bil lán loo, looi salic mon lekído.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Giróse hé beiman zimmadar or saláki ham dekí taarif goijjé; kiyólla-hoilé e duniyair manúc ókkol nizor ḍóilla manúc lói solafíra gorát, nur or manúc or túaro bicí salák. ");
INSERT INTO rhgc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Añí tuáñra re hoóir, duniyaibi dón-doulot lói nizor lla dustó bano; zeéne zeñtté híin fúraizagoi, ítara tuáñra re abadulabadi zagat kobul goré. ");
INSERT INTO rhgc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Zee niki hom ot imandari táke, yóggwa ye bicít óu imandari táke; aar zee niki hom ot beimani goré, yóggwa ye bicít óu beimani goré. ");
INSERT INTO rhgc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hé ísafe, zodi tuáñra duniyaibi dón-doulot ot imandari no táko, tóoile tuáñra re bóraca gorí asól dón hone diibo? ");
INSERT INTO rhgc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aar zodi tuáñra ar ezzon or gún ot imandari no táko, tóoile tuáñrar gún tuáñra re hone diibo? ");
INSERT INTO rhgc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Honó gulame dui girós or hédmot gorí no fare; kiyólla-hoilé íte ezzon ore nafórot goríbo aar ar ezzon ore muhábbot goríbo; yáto ezzon loi ṭík tákibo aar ar ezzon ore hékarot goríbo. Tuáñra ekku fúañti Allar edde dón-doulot or hédmot gorí no faribá.” ");
INSERT INTO rhgc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Féroci ókkole híin beggún fúni Isá re técerat doijje, kiyólla-hoilé ítara ṭiañr lalósbon accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Íba ye ítara re hoór de, “Tuáñra óilade uitará zetará maincór muúntu nizoré nize forhésgar kúwalo, montor Alla ye tuáñrar dil zane. Ziyán maincór nozor ot bicí kimoti híyan Allar nozor ot honó kimot nái. ");
INSERT INTO rhgc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tourat edde nobi ókkol or kitab, Yaháya foijjonto soillíl; yárbaade lóti Allar raijjor kúchóbor tobolik gorá zar, aar fottíkiye zuresúre híyan ot gólat asé. ");
INSERT INTO rhgc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lekin Tourat Córif or ekgwá noktá búzi zar túaro, asman zobin ofát ówa aró aásan. ");
INSERT INTO rhgc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Zee kiyé nizor bou wóre sárifelai ar eggwá re biyá goré, íte zená gorér deh; aar zee kiyé zamair sárifelaiya mayafua re biyá goré, íte yó zená gorér deh. ");
INSERT INTO rhgc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ezzon endilla tuangor manúc accíl, zibá ye bayoinna rong or edde dami-dami hoor fiñdíto, aar fottí din ayaci-kúci gorí tákito. ");
INSERT INTO rhgc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ítar geiṭ ot Lasár nam or ézzon hórat-magoya re raká záyto, yóggwa gáaye furaiya accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yóggwa ttu tuangor manúc cwar mes ottu forizaytói de hána lói feṭ bóraito monehoitó. Aar kuñir ókkole aái yóggwar gáa ókkol lekíto. ");
INSERT INTO rhgc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Fore eén óiye, hé gorif manúc cwa morigiyói aar fírista ókkole yóggwa re Ibrahím or héṛe loigiyói. Ek din tuangor manúc cwa yó morigiyói aar dohón gorá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Íte zuzuk ot azab faar de héntu uormikká saiyé rár, duré Ibrahím ore edde íbar ḍák ottu Lasár ore deikké. ");
INSERT INTO rhgc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hétunot íte guzori hoór de, ‘Ó baf Ibrahím, añr uore rahám gorí Lasár ore añr héṛe difeṛó, zeéne yóggwa ye fanít mazé nizor ooñl or matá burai añr zir ṭánḍa goré, kiyólla-hoilé añí e ooin ot bicí toziya fair.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Montor Ibrahíme hoór de, ‘O fut, ṭáar gorí saá, tui tor zindigit gom-gom jiníc ókkol lói hotó cúk goijjíli, aar Lasáre hotó duk faáil; montor yala yóggwa eṛé cánti faar, aar tui toziya foór. ");
INSERT INTO rhgc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iín beggún baade, tor edde añárar dormiyan ot ḍoóñr dumburu asé, zeéne entú tor héṛe zaito monehoó de ítara zai no fare aar héntu añárar héṛe aitó monehoó de ítara aái no fare.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Hétunot íte hoór de, ‘Ó baf, héen óile añí tuáñre fóriyat gorír, Lasár ore añr baf or gór ot difeṛó; ");
INSERT INTO rhgc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kiyólla-hoilé añr ttu fañs swá bái asé. Yóggwa ye ítara re úñciyari douk, arnóile ítara yó e azab or zagat foóñsibai.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Montor Ibrahíme hoór de, ‘Ítarar héṛe Muúsar edde nobi ókkol or kitab asé. Ítara híin or hotá fúnouk.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Íte hoór de, ‘No, no, ó baf Ibrahím, zodi mora ókkol ottu kiyé ítarar héṛe zaa, ítara touwá goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Montor Ibrahíme ítare hoór de, ‘Zodi ítara Muúsar edde nobi ókkol or hotá no fúne, tóoile mora ttu honókiye zinda ói zailé yo ítara no manibó.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isá ye Nizor ummot ókkol ore hoór de, “Gunár uzu ṭane de híin toh nu aái no tákibo; montor uitar uore afsús, zar duara niki híin aiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ítar lla beétor óilde, ítar golat eggwá cíl or sakki bañdí doijjat félaidiya zah, zodi íte e cóñṛo ókkol ottu honókiyo re guná gorába. ");
INSERT INTO rhgc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nizoré nize úñciyar. Zodi tuáñr bái ye hosúri goré, yóggwa re bóṭboṛáiyo; zodi yóggwa ye touwá goré, yóggwa re maf gorídiyo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Zodi yóggwa ye tuáñr ulḍa ek dine háñt bar hosúri goré, aar háñt óu bar tuáñr hañse aái hoó, ‘Añí touwá goijjí,’ tóoile yóggwa re maf gorídiyo.” ");
INSERT INTO rhgc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sáhabi gúne Malik ore hoór de, “Añárar iman baráido.” ");
INSERT INTO rhgc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Malike hoór de, “Zodi tuáñra ttu hóroir danar héttirin iman táke, tuáñra e tut-gas swá re eén hoói faribá, ‘Háñri zai doijjat fúṭgoi,’ gas swá ye tuáñrar hotá manibó. ");
INSERT INTO rhgc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Dóro tuáñra honókiyo ttu ál soibó lla yáh sóol sorai bolla eggwá goóur asé. Yóggwa ye kí goóur gwá bil ottu ailé ítare endilla hoibó, ‘Hára aái, háito bogái?’ ");
INSERT INTO rhgc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bólke yóggwa ye kí ítare endilla no hoibó né, ‘Añr lla hána toiyar gor, aar nizor keeñil bañdí añr ttu hána-fina háiya nó óiyo foijjonto añré hédmot gór, baade tui hána-fina hái faribí’? ");
INSERT INTO rhgc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yóggwa ye kí goóur gwá re cúkuriya goríbo, ítare ziyán hókum goijjé híyan goijjé de hétolla? Bilkúl no goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Héndilla tuáñra yó, zeñtté tuáñra ttu tuáñra re hókum gorá gíyeh de híin beggún goijjá ó, hoibá de, ‘Añára behazor goóur ókkol; añára baná añárar fóros adai goijjí deh.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Baade eén óiye, Isá Jerúsalem ot zaite Samáriar edde Galil or maz ottu zaar. ");
INSERT INTO rhgc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Íba ekkán farat gólibarcot, doc zon kurus biyaraimma Íba llói dola óiye. Ítara duré tíyaiya accíl, ");
INSERT INTO rhgc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aar guzoran mari hoór de, “Isá, ó Ustat, añárar uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Íba ye ítara re dekí hoór de, “Zoo, nizoré imam ókkol or hañse dahógoi.” Aar eén óiye, ítara zaite-zaite pak-sáf óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ítara ttu ezzone zeñtté nize gom óigiyoi de deikké, yóggwa ḍoóñr abase Allar taarif gorí-gorí fíri aiccé, ");
INSERT INTO rhgc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","aar Isár foot uúiñtoi fori Íba re cúkuriya goijjé. Yóggwa óilde ézzon Samári. ");
INSERT INTO rhgc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hétunot Isá ye fusár gorér de, “Doc zon beggún pak-sáf óiye de no né? Ar now zon hoṛé? ");
INSERT INTO rhgc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Allar taarif gorí bolla e bidecóitta wa bade ar honókiye fíri nú aiyé de níki?” ");
INSERT INTO rhgc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Baade Íba ye yóggwa re hoór de, “Uṛó, zoogói; tuáñr imane tuáñre gom goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ekbar, Féroci ókkole Isá ttu fusár goijjé de, Allar raijjo hoñtté aibó? Íba ye ítara re zuwabe hoiyé de, “Allar raijjo aité dahá zah fángori nu aibó, ");
INSERT INTO rhgc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aar maincé yó no hoibó de ki, ‘Soó, híyan eṛé asé,’ yáto, ‘Uṛé asé,’ kiyólla-hoilé Allar raijjo toh tuáñrar mazé asé.” ");
INSERT INTO rhgc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tarfore Íba ye Nizor ummot ókkol ore hoór de, “Eén din aibó zeñtté tuáñra Manúc or Fuar din ókkol ottu ek din óile sai bolla azzu goríba, montor no dekíba. ");
INSERT INTO rhgc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Maincé tuáñra re hoibó de, ‘Eṛé soó,’ yáto ‘Uṛé soó.’ Montor no zaiyo, ítarar fisá no dóijjo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kiyólla-hoilé zendilla asman or ek ḍák ottu bijili somkilé arek ḍák ot óu foor zaa, Manúc or Fua aibó de híyala yó héndilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lekin age Íba ttu boóut kessú duk faa foribó, aar e zobanar manúc ottu inkar há foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nobi Nuhr din ókkol ot zendilla óoil, héndilla Manúc or Fuar din ókkol ot óu óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Zetó din Nuh kicṭit nó uṛé aar tuwán aái manúc beggún ore hálak nó goré, hétodin foijjonto manúc ókkole háafiya gorát, biyá gorát, edde biyá diyat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Luút or din ókkol ot óu héndilla óoil; manúc ókkol háafiyat, besa kinat, kéti gorát, edde gór banat accíl; ");
INSERT INTO rhgc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","montor ze din Luút Sódom ottu neeli aáigiyoi, asman ottu ooin edde gónḍokzór fore fán fori ítara beggún ore hálak gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Manúc or Fua zahér óibo de hé din óu héndilla beh óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hé din zee niki gór or sád or uore de óibo aar nizor mal-sáman gór or bútore óibo de tákibo, ítar ttu híin looi bolla lamat no lama foribó; héndilla zee niki kétit óibo, ítar ttu waafes nu aá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Luút or bou wór hálot yaad raikkó. ");
INSERT INTO rhgc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Zee niki nizor zan basaitó saá, íte híyan háraifelaibo; aar zee niki nizor zan háraifele, íte híyan basai rakíbo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Añí tuáñra re hoóir, hé raitta dui zon manúc ek bisánat óibo de tákibo; ítara ttu ezzon ore loiza zaybo, ar ezzon ore bad diya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duwá mayafua ye ekku fúañti sakki gúraibo de tákibo; ítara ttu ezzon ore loiza zaybo, ar ekzon ore bad diya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dui zon manúc bil ot óibo de tákibo; ítara ttu ezzon ore loiza zaybo, ar ezzon ore bad diya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ítara Íba ttu fusár gorér de, “Malik, iín hoṛé óibo dé?” Íba ye ítara re hoór de, “Mora lac zeṛé, héṛe toh hóun ókkol óu zoma óibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Baade Isá ye ítara re ekkán meésal hoiyé, ítara ttu hárr októt dua gorá foribó de aar hímmot no hára foribó de híyan cíkai bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ki hoilé, “Ekkán cóor ot eggwá bisarhar accíl, zibá ye no Alla re ḍooraitó aar no honó manúc ore forba goittó. ");
INSERT INTO rhgc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aar hé cóor ot eggwá rari accíl; híba ye yóggwar hañse aái-aái hoitó de, ‘Añr duccon ókkol ottu añré insáf loido.’ ");
INSERT INTO rhgc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Yóggwa ye hooddin inkar goijjíl, montor fore nizoré nize hoór de, ‘Añí de no Alla re ḍoorai aar no honó manúc ore forba gorí, ");
INSERT INTO rhgc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","montor toóu e rari wa ye zettót añré ferecan gorát asé, añí ibáh re insáf loidiyum, arnóile ibáh ye barbár aái-aái añré óran gorífelaibo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yárbaade Malike hoór de, “Fúno, nainsáfi bisarhar gwá ye kii hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Héndilla, Alla ye ki Íbar basíloiya bonda ókkol ore insáf loi no dibo né, zetará dine raite Íbar hañse hañde? Íba ye kí ítara lla híyan goitté deri goríbo? ");
INSERT INTO rhgc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Añí tuáñra re hoóir, Íba ye ítara re toratori insáf loidibo. Lekin Manúc or Fua zeñtté aibó, Íba ye kí duniyait iman faibo?” ");
INSERT INTO rhgc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hodún manúc zetará nizoré forhésgar ṭáare aar oinno zon ore hékarot goré, Isá ye ítara re e meésal lan hoiyé, ");
INSERT INTO rhgc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dui zon manúc baitul-mukaddos ot dua goittó giiyé; ezzon óilde Féroci, ar ezzon óilde házana-tulóya. ");
INSERT INTO rhgc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Féroci wa ye tíyai nizor baabute endilla dua gorát doijje, ‘Ya Alla, añí Tuáñre cúkuriya gorír, kiyólla-hoilé añí oinno manúc or ḍóilla ḍahañit, nainsáfi, aar zenákur no; e házana-tulóya war ḍóilla úddwa no. ");
INSERT INTO rhgc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Añí háftat duibar ruza rakí; aar añr tamám amodoni ttu doc bák or ek bák Tuáñre diifélai.’ ");
INSERT INTO rhgc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lekin házana-tulóya wa ekkágori duré tíyai accíl; yóggwa ye asman or uzu sai bolla úddwa moncá no gorér, bólke buk kilai-kilai hoór de, ‘Ya Alla, añí gunágar or uore rahám goró.’ ");
INSERT INTO rhgc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Añí tuáñra re hoóir, e manúc cwa beh forhésgar ṭóori gór ot giiyé, Féroci wa nó ṭóore; kiyólla-hoilé zee niki nizoré nize ḍoóñr kúwala ítare cóñṛo gorá zaybo; aar zee niki nizoré nize cóñṛo kúwala ítare ḍoóñr gorá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ek din maincé ítarar gura fuain dore yó Isár hañse anát doijje, zeéne Íba ye ítara re súwe; montor cárit tune deikké rár, manúc cún ore bóṭboṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Montor Isá ye fuain dore Íbar hañse matai hoór de, “Fuain dore Añr hañse aitódo; ítara re no oóñillo, kiyólla-hoilé Allar raijjo toh ítarar ḍóilla maincé éna hásil goré. ");
INSERT INTO rhgc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Añí tuáñra re sóiyi hoóir, zee kiyé Allar raijjo re eggwá gura fuar ḍóilla góri kobul no goré, yóggwa híyan ot bilkúl góli no faribó.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Fore ezzon sóddare Isá ttu fusár gorér de, “Gom Ustat, ofúrani zindigi miras faite añr ttu kii gorá foribó?” ");
INSERT INTO rhgc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isá ye yóggwa re hoór de, “Tuñí Añré gom kiyá ḍakoór? Alla bade toh ar kiyé gom nái. ");
INSERT INTO rhgc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tuñí de hókum ókkol zano, zendilla niki, ‘Zená no goríba; kún no goríba; suri no goríba; misá gobá no diba; bafmaa re izzot goríba.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yóggwa ye hoór de, “Añí híin beggún gurahale lóti amól gorí-gorí aiyír.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Híyan fúni Isá ye yóggwa re hoór de, “Tuáñr ttu aijjó ekkán ham baki asé. Tuáñr ttu ziín asé híin beggún besi gorif ore baṛidogói, tói tuñí asman ot dón faiba; baade aái Añr fisáli óiyogai.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Híyan fúni yóggwa kúb bezar óigiyoi, kiyólla-hoilé yóggwa ḍoóñr dóni accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Isá ye yóggwar uzu saái hoór de, “Dón-doulot ola ókkol ottu Allar raijjot gólite hotó mockil! ");
INSERT INTO rhgc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kiyólla-hoilé tuangor manúc Allar raijjot gólar túaro, eggwá uñṭ fúñc or faái ttu goli zaa aró aásan.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Híin fúinne de ítara hoór de, “Tóoile hone nejat fai faribó?” ");
INSERT INTO rhgc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Íba ye hoór de, “Ziín insáne gorí no fare, híin Alla ye fare.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Fitore hoór de, “Soó, añára de górbari eridi Tuáñr fisáli óigiyigoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Íba ye ítara re hoór de, “Añí tuáñra re sóiyi hoóir, zee niki Allar raijjor wasté gór, bou, báiyain, bafmaa yáh fuain eridiyé, ");
INSERT INTO rhgc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yóggwa ye e zobanat híin boóut gun bicí faibo, aar aibó de zobanat ofúrani zindigi faibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yárbaade Isá ye baró zon cárit tun ore ekkinare loizai ítara re hoór de, “Soó, añára uore Jerúsalem ot zair, Manúc or Fuar baabute nobi ókkole ziín-ziín leikké híin beggún héṛe fura óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Íba re Beyohúdi ókkol or hañse gosáidiya zaybo; ítara Íba re ínca goríbo, beizzoti goríbo, edde sép maribó; ");
INSERT INTO rhgc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ítara Íba re coóñk mari baade zane marifélaibo. Lekin tin din ot din Íba zinda óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cárit tune hotá híin ekkán óu nó buzé; hé hotár maáni ítara ttu lukaiféla gíyeh, hétolla ziín hoiyé híin ítara buzí nó fare deh. ");
INSERT INTO rhgc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Isá zeñtté Jerikó cóor or ḍáke foóñicce, ezzon añdá manúc rastar hañsat boói hórat mager de accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yóggwa ye ek dol manúc ḍák ottu zaar de abas fúni, eṛé kii ór de fusár goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Maincé yóggwa re hoór de, “Isá Nasári e boli zaar deh.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hétunot yóggwa ye guzori-guzori hoór de, “Ó Dawud or Fua Isá, añr uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Zetará age-age zaar de accíl, ítara yóggwa re jéjjeṛai nizám óito hoiyé; montor yóggwa ye aró guzori-guzori hoór de, “Ó Dawud or Fua, añr uore rahám goró!” ");
INSERT INTO rhgc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hétunot Isá tíyaigiyoi aar hókum díye de, yóggwa re Íbar hañse aná zay bolla. Yóggwa ḍáke aiccé rár, Isá ye yóggwa ttu fusár gorér de, ");
INSERT INTO rhgc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Tuñí kii soó, Añí tuáñr lla kii goittám?” Yóggwa ye hoór de, “Malik, añr ttu dekí faribár toóufik faito monehoór.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isá ye yóggwa re hoór de, “Dekí faribár toóufik loo; tuáñr imane tuáñre gom goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Éhon yóggwa ye dekí faribár toóufik faiyé aar Allar taarif gorí-gorí Isár fisáli doijje. Manúc beggúne híyan dekí Allar taarif goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isá Jerikó cóor ot góli bútottu zaat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Héṛe Zakéyos nam or ézzon manúc accíl; yóggwa accíl házana-tulóya ókkol or sóddar edde tuangor manúc. ");
INSERT INTO rhgc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yóggwa ye Isá hon de híyan saitó kucíc goijjíl, montor manúc or dol or zoriya saái nó fare, kiyólla-hoilé yóggwa gaafiṛé baṛí accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hétolla yóggwa ye Isá re sai bolla muúmmikka duñri zai eggwá ḍuñir-gas ot uiṭṭégoi, kiyólla-hoilé Íba hé foñt báy zaibo. ");
INSERT INTO rhgc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zeñtté Isá hé zagat foóñicce, Íba ye uormikká saái yóggwa re hoór de, “Zakéyos, toratori lamogái, kiyólla-hoilé aijja Añr ttu tuáñr gór ot tákar zorur.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hétunot yóggwa toratori laimmégai, aar Íba re kúcir sáañte estekbal goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Híyan dekí manúc beggúne endilla cékayot gorát doijje, “Íba ezzon gunágar or gorba óito giiyé.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakéyose tíyai Malik ore hoór de, “Soó Malik, añr cómbotti ttu ekdók añí gorif ókkol ore diifélair, aar zodi añí honókiyo ttu na hókkot kessú loiyí de óile, ítare añí sair gun waafes fíraidiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Isá ye yóggwa re hoór de, “Aijja e gór ot nejat aiccé, kiyólla-hoilé yoggwá yó toh Ibrahím or fua. ");
INSERT INTO rhgc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Manúc or Fua aiccé de toh áñzigiyoi de ítara re tuwai bolla edde nejat di bolla.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ítara híin beggún fúner de októt, Isá ye ítara re ekkán meésal hoiyé, kiyólla-hoilé Íba Jerúsalem or ḍáke accíl aar ítara ṭáaijjil de Allar raijjo bicí hára zahér óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Íba ye hoór de, “Ezzon bóddoro manúc ekkán durór mulluk ot giiyé, baáñcca boni waafes ai bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Zaibar age yóggwa ye nizor goóur ókkol ottu doc zon ore matai ítara re doc cán cúnar foicádiiyé, dii ítara re hoór de, ‘Añí nú aiyí foijjonto iín lói códori gorógoi.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Lekin yóggwa re nizor decóitta ókkole nafórot goittó, hétolla ítara yóggwar fisé nomainda difeṛái hoiyé de, ‘Añára e manúc cwa ye añárar uore hókumot goré de híyan no saái.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Zeñtté yóggwa baáñcca boni waafes aiccé, yóggwa ye nizor ṭiañ dyíl de goóur gún ore mata baiyé, zeéne ítara códori gorí hodún hamaiyé de zani fare. ");
INSERT INTO rhgc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Cúrur íte aái hoór de, ‘Malik, tuáñr foicá lói añí aró doc cán foicá baráiyi.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Yóggwa ye ítare hoór de, ‘Cabác, gom goóur! Tui zettót bicí hom ot imandari táikkos, yala tui doc cán cóor or uore hókumot gór.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Dusára wa ye aái hoór de, ‘Malik, tuáñr foicá lói añí aró fañs sán foicá baráiyi.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yóggwa ye ítare yó hoór de, ‘Tui yó fañs sán cóor or uore hókumot gór.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Baade ar ezzone aái hoór de, ‘Malik, ótiya tuáñr foicá, añí yián ore ekkán fakít berái lukai raikkílam; ");
INSERT INTO rhgc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kiyólla-hoilé añí tuáñre ḍooraiyí, tuñí ézzon hora manúc; tuñí toh nize ziín nó rakó híin loifélo, aar ziín nó lago híin haṛo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yóggwa ye ítare hoór de, ‘Ó behar goóur! Tor muk or hotá loi añí tor bisar goijjúm. Tui de zainti añí ézzon hora manúc deh, añí ziín nó rakí híin loifélai, aar ziín nó lagai híin haṛi. ");
INSERT INTO rhgc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tói tui añr ṭiañ gán benggót óile kiyá nó rakós? Héndilla goittí bóuli añí ailé híyan or fúañti kessú cúṭ faitam.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Tarfore yóggwa ye íñyot házir accíl de ítara re hoór de, ‘Itar ttu foicá gán loifélai, zar ttu doc cán foicá asé ítare diifélo.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ítara yóggwa re hoór de, ‘Malik, ítar ttu de age lóti doc cán foicá asé.’ ");
INSERT INTO rhgc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“‘Añí tuáñra re hoóir, zar ttu asé, yóggwa re aró diiya zaybo; montor zar ttu nái, yóggwa ttu asé de híin úddwa loiféla zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Montor añr duccon zetará niki añí ítarar uore hókumot gorí de no saitó, ítara re iñyót aní añr cáikkat zane marifélo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Isá ye híin hoói baade, ítarar age-age Jerúsalem or uzu zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zeñtté Íba Zaitun Faár ot asé de Betfégi edde Betániya farar hañsáhañsi foóñicce, Íba ye Nizor dui zon cárit ore difeṛáiye, ");
INSERT INTO rhgc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","endilla hoói, “Tuáñra muúm or fara gán ot zoo, héṛe góli mottor eggwá gadár sóo baindá loot faiba, zibár uore aijjó honókiye nó soré. Yíba re kúli eṛé anógoi. ");
INSERT INTO rhgc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Zodi honókiye tuáñra ttu fusár goré, ‘Tuáñra yíba re kiyólla kúlor?’ Yóggwa re hoibá de, ‘Malik ottu yibá re lager.’ ” ");
INSERT INTO rhgc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tói zetará re difeṛáiye ítara rowana loiyé, aar Íba ye zeén hoiyé héen loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ítara gadár sóo wa re kúler rár, yíbar giróse ítara re hoór de, “Tuáñra gadár sóo wa re kiyólla kúlor?” ");
INSERT INTO rhgc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ítara hoór de, “Malik ottu yibá re lager.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Baade ítara yíba re Isár héṛe ainné, aar yíbar uore ítarar hoor ókkol bicáidi Isá re uore buágaraiye. ");
INSERT INTO rhgc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Íba zaar de októt, manúc ókkole nizor hoor ókkol rastat bicáidiyat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Zaite-zaite Íba Zaitun Faár or lamonir hañsáhañsi foóñicce rár, ummot ókkol or dol ṭíya ye ítara ze keramot ókkol deikkíl híin beggún olla guzori-guzori kúcir sáañte Allar taarif gorát doijje, ");
INSERT INTO rhgc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","hoór de, “Mubarek Baáñcca Ubá zibá Mabud or name aiyér. Ebbe uore asman ot cánti óuk, aar héṛe mohíma óuk!” ");
INSERT INTO rhgc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dol ottu hoozzon Féroci ye Íba re hoór de, “Ustat, Tuáñr ummot ókkol ore éggwa bóṭboṛo.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Íba ye zuwabe hoór de, “Añí tuáñra re hoóir, zodi itará nizám ói táke, fattór ókkol guzori uṛíbo!” ");
INSERT INTO rhgc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zeñtté Íba Jerúsalem or hañsáhañsi foóñicce, cóor gán dekí híyan olla haindé, ");
INSERT INTO rhgc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hoór de, “Áh, tui yó aijja zodi cánti kiyé ané de zaintiya! Montor yala de híyan tor suk or argwal óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kiyólla-hoilé tor uore eén din aibó, tor duccon ókkole tor ulḍa ḍebal tulí toré gíridoribo, aar toré hárr mikká ttu gérgwal goríbo, ");
INSERT INTO rhgc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","toré edde tor bútor or fuain dore meṛit añsáribo, aar tor bútore eggwá fattór or uore ar eggwá fattór no rakíbo, kiyólla-hoilé tui toh Alla ye toré basaitó aiccé de októ nó sinós.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Fore Isá baitul-mukaddos or uṛán ot góli, zetará héṛe besa kina gorér ítara re loraidiyat doijje; ");
INSERT INTO rhgc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ítara re hoór de, “Pak-kalam ot endilla asé, ‘Añr gór munazat or gór óibo,’montor tuáñra toh híyan ore ḍahañit or aḍḍa-hána banaifélaiyo.” ");
INSERT INTO rhgc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Íba ye baitul-mukaddos ot fottí din taalim dito. Montor ḍoóñr imam ókkole, alem ókkole, edde manúc or ḍaiḍoóñr ókkole Íba re marifélaibar kucíc ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lekin híyan gorí bolla ítara honó mouka nó faa, kiyólla-hoilé tamám manúc ókkole Íbar hotá oóñlgori fúnito. ");
INSERT INTO rhgc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ek din zeñtté Isá ye baitul-mukaddos ot manúc ókkol ore taalim der edde kúchóbor tobolik gorér, ḍoóñr imam ókkole edde alem ókkole murubbi ókkol ore fúañti looi Íbar hañse aiccé, ");
INSERT INTO rhgc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aar Íba re hoór de, “Añára re hoósai, Tuñí ham iín kii adíkare gorór? Tuáñre e adíkar diiyé de íba hon?” ");
INSERT INTO rhgc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Íba ye ítara re zuwabe hoór de, “Añí yó tuáñra ttu ekkán súwal fusár goríyum. Añré hoósai, ");
INSERT INTO rhgc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yaháya ye bápṭisma díbar adíkar faáil de asman ottu né náki insán ottu?” ");
INSERT INTO rhgc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ítara afós ot biyasana gorér de, “Zodi añára hoói ‘asman ottu,’ Íba ye hoibó de, ‘Tóoile tuáñra íba re biccác kiyá nó goró?’ ");
INSERT INTO rhgc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Montor zodi hoói, ‘insán ottu,’ tóoile manúc beggúne añára re cíl or dola maribó, kiyólla-hoilé ítara toh Yaháya eggwá nobi de biccác goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hétolla ítara zuwab der de, “Añára no zani híyan hontú.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tói Isá ye ítara re hoór de, “Tóoile Añí yó tuáñra re no hoiyúm Añí iín kii adíkare gorír.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tarfore Isá ye manúc ókkol ore e meésal lan howá cúru goijjé, “Ezzon maincé ekkán anggur-bariza lagaiyé, yóggwa ye híyan cacá ókkol ore ṭéka dí lamba ṭaim olla oinno mulluk ot giiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aar anggur or ainda aiccé rár, yóggwa ye eggwá goóur ore cacá gún or hañse difeṛáiye, zeéne ítara yóggwa re barizar gular bák dee; montor cacá gúne taré mara-dóra gorí háli áte duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yóggwa ye abar ar eggwá goóur difeṛáiye; ítara taré yó mari edde bicí beizzoti gorí háli áte duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Baade yóggwa ye tisára goóur difeṛáiye; ítara taré yó zohóm gorí baáre félaidiye. ");
INSERT INTO rhgc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tarfore barizar giróse hoór de, ‘Yala añí kii goittám? Añí añr adorja fua re difeṛáiyum; ítara íba re izzot goittó fare.’ ");
INSERT INTO rhgc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Montor cacá gúne hé fua re dekí afós ot biyasana gorér de, ‘Ite toh mirasdár; aiyó itaré marifélai, zeéne miras añárar óizagoi.’ ");
INSERT INTO rhgc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tói ítara íba re barizar baáre loizai marifélaiye. “Hé ísafe, barizar giróse ítara re kii goríbo fáñllar? ");
INSERT INTO rhgc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yóggwa ye aái hé cacá gún ore marifélaibo, aar bariza gán oinno kiyó re diifélaibo.” Ítara híyan fúni hoór de, “Alla ye héndilla no goróuk.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Montor Isá ye ítarar híkka saái hoór de, “Tóoile pak-kalam ot asé de e hotár maáni kii, ‘Ze fattór mistíri ye inkar gorífelaiye, yíba cíl beggún or túaro bicí zoruri wa óigiyoi’? ");
INSERT INTO rhgc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ze kiyé hé cíl or uore foribó íte báñgi hán-hán óizayboi, montor zar uore niki hé cíl yíba foribó, íte ficí zayboi.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hétunot ḍoóñr imam ókkole edde alem ókkole Íba re dórifelai bolla kucíc goijjíl, kiyólla-hoilé ítara buzígiyoi de ki meésal híyan ítarar hélaf hoiyé deh; montor ítara awam ókkol ore ḍooraitó. ");
INSERT INTO rhgc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ítara Isár uore háas nozor raikké, hétolla gom manúc or bét dórai gurinda ókkol difeṛáiye, zeéne ítara Íba re Nizor hotár fán ot félai fare edde Íba re hákim or hókumot ot edde adíkar ot gosáidi fare. ");
INSERT INTO rhgc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Gurinda gúne Íba re súwal gorér de, “Ustat, añára zani Tuáñr hotá edde taalim sóiyi, aar Tuñí honókiyo re forók goró de nái, bólke sóiyigori Allar rastar taalim doh. ");
INSERT INTO rhgc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Romi baáñcca re házana doon añára lla zayes asé né náki nái?” ");
INSERT INTO rhgc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Montor Íba ye tarár sail ore zani fari tará re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Añré ekkán dinár dahó. Yián har sóbi edde har nam?” Tará zuwab der de, “Romi baáñccar.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tói Íba ye tará re hoór de, “Tóoile ziín baáñccar híin baáñcca re diiyo, aar ziín Allar híin Alla re diiyo.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tará manúc or muúntu Íba re Nizor hotár fán ot félai nó fare, bólke Íbar zuwabe ammúk ói nizám óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baade hodún Sadukái Isár hañse aiccé, Sadukái ókkole háñcor nái hoi biccác goré, ítara aái Íba re ekkán súwal goijjé, ");
INSERT INTO rhgc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ki hoilé, “Ustat, Muúsa ye añára lla leikké de, zodi honókiyor biyáta bái fuain sára morizagói, tóoile ítar hé bái ottu bou híba re biyá gorífelai nizor bái olla nosól foida gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dóro, háñt zon bái accíl. Foóila wa ye bou looi, fuain sára morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Baade híba re dusára wa ye biyá goijjé, aar íte yó fuain sára morigiyói; ");
INSERT INTO rhgc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tarfore híba re tisára wa ye biyá goijjé. Héndilla, ítara háñto bái ye híba re biyá gorí fuain sára morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ahérit, mayafua wa yó morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hé ísafe, háñcor or hale híba har bou óibo? Kiyólla-hoilé híba re toh háñto zone nizor bou banaáil.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isá ye ítara re zuwab diyé de, “E zobanat maincé biyá-cádi goré edde biyá-cádi deh. ");
INSERT INTO rhgc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Montor zetará re aibó de zobanar bági óibar edde háñcor-or-din mora ttu zinda óibar laayek bouli gona zah, ítara no biyá goríbo aar no ítara re biyá díya zaybo; ");
INSERT INTO rhgc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ítara ar mori yó no faribó, kiyólla-hoilé ítara fíristar ḍóilla óizayboi; aar ítara háñcor or bági ói Allar fuain óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mora ókkol zinda ó de híyan toh Muúsa ye úddwa zoler de záḍḍwar zikír gorá gíyeh de héṛe zahér goijjé, héṛe íba ye Mabud ore Ibrahím or Alla, Isahák or Alla, edde Yakub or Alla ḍaikké. ");
INSERT INTO rhgc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kiyólla-hoilé Alla toh mora ókkol or Alla no, bólke zinda ókkol or éna, kiyólla-hoilé Íbar hañse beggún zinda.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hétunot hodún aleme Íba re zuwabe hoór de, “Ustat, Tuñí gom hoiyó.” ");
INSERT INTO rhgc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yárbaade ítara ttu Íba re ar honó súwal goittó hímmote nó deh. ");
INSERT INTO rhgc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Isá ye ítara re hoór de, “ Mosih re Dawud or fua keéngori hoó? ");
INSERT INTO rhgc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kiyólla-hoilé Dawud nize toh Zobur Córif ot endilla hoiyé, ‘Mabude añr Malik ore hoór de, “Añr den ḍák ottu boiyó, ");
INSERT INTO rhgc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","zetókkal foijjonto Añí Tuáñr duccon ókkol ore Tuáñr foor tole gorí nó felai.” ’ ");
INSERT INTO rhgc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawude toh Íba re ‘Malik’ ḍaikké, tóoile keéngori Íba Dawud or fua dé?” ");
INSERT INTO rhgc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Manúc beggúne Isár boiyan fúnat asé de októt Íba ye Nizor ummot ókkol ore hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Alem ókkol ottu úñciyar táikko, zetará lamba-lamba kuruta fiñdí gúrafíra goittó saá, aar bazare-bazare sólam faito, mujilíc-hána ókkol ot uñsol tokkar hadírat boitó edde mela-cóbat barík zagat boitó fosón goré. ");
INSERT INTO rhgc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ek mikká ttu ítara rari ókkol or gór ókkol luṭ gorífele, arek mikká ttu maincóre dahái bolla lamba-lamba dua goré. Manúc híine sáñza bicí ḍoóñr faibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Baade Isá ye suk tulí saiyé rár dekér de, tuangor ókkole ítarar sótka ókkol baitul-mukaddos or dan-baccút deer. ");
INSERT INTO rhgc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Íba ye eggwá gorif rari ye yó héṛe duiyán cóñṛo foicá deer de deikké. ");
INSERT INTO rhgc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hétunot Íba ye hoór de, “Añí tuáñra re sóiyi hoóir, e gorif rari wa ye beggún or túaro bicí diiyé; ");
INSERT INTO rhgc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kiyólla-hoilé oinno beggúne ítarar aṭalikka dón ottu diiyé deh, montor ibáh ye toh nizor gorif hálot ot basi táki bolla ziín accíl híin beggún diifélaiye.” ");
INSERT INTO rhgc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Zeñtté hodúne baitul-mukaddos or baabute endilla howáhoi gorér, híyan ore keén cúndor-cúndor fattór lói edde Alla re diiya hádiya ókkol lói háñza gíyeh, Isá ye hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tuáñra eṛé ziín dekór híin olla eén din aibó, eṛé eggwá fattór or uore ar eggwá fattór no tákibo, híin fottí ekgwá re félaidiya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ítara Íba ttu fusár gorér de, “Ustat, híin hoñtté óibo dé? Híin beggún fura óibar októ aiccé de híyan or alamot kii óibo?” ");
INSERT INTO rhgc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Íba ye zuwab der de, “Saiyó, honókiye zen tuáñra re gollot ot no loiza, kiyólla-hoilé boóut zone Añr name aái hoibó de, ‘Añí Íba,’ edde ‘Októ ḍáke.’ Montor ítarar fisáli no dóijjo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Zeñtté tuáñra larái edde úrussul or abas ókkol fúniba, no ḍooraiyó; kiyólla-hoilé age híin ówar zorur. Montor híyala yó toratori ahérot óibo de no.” ");
INSERT INTO rhgc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Íba ye ítara re aró hoór de, “Ek koume arek koum or ulḍa edde ek raijjo ye arek raijjor ulḍa tíyaibo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ḍoóñr-ḍoóñr búsal óibo, aar zaga-zaga raṭ ókkol edde ababiyaram ókkol óibo; aró, asman ottu hótara jiníc edde ḍoóñr nicán ókkol dahá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Lekin híin beggún óibar age, maincé Añr nam or wasté tuáñra re dórifelaibo edde zulúm goríbo. Ítara tuáñra re mujilíc-hánat gosáidibo edde ziyól ot díbo. Añr nam or wasté tuáñra re baáñcca edde hákim ókkol or muúntu házir gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Montor híyan tuáñra gobá díbar mouka óibo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hétolla dil ot gañtí rakó de ki, kii zuwab diba age lóti sinta gorár zorur nái; ");
INSERT INTO rhgc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kiyólla-hoilé Añí tuáñra re eén zoban edde giyan diiyum, ziín ore tuáñrar honó duccone mukabela yáh inkar gorí no faribó. ");
INSERT INTO rhgc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tuáñra re nizor bafmaa ye, báiboináin de, egana-guiccí ye edde dustó ókkole úddwa dóridibo; tuáñra hodún ore marifélaibo yó. ");
INSERT INTO rhgc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aar Añr lla bouli tuáñra re beggúne nafórot goríbo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lekin tuáñrar matár ekkán sul úddwa borbad no zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tuáñrar sobóre tuáñra nizor zan basai rakíba. ");
INSERT INTO rhgc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Tuáñra zeñtté fóous ókkole Jerúsalem ore sairókul ttu berái dóijje de dekíba, héñtte ṭáariyo de, híyan bocóti sára óibar októ ḍáke. ");
INSERT INTO rhgc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Héñtte zetará Yohúdiyat tákiba ítara ttu faár ot dáizagoi foribó, zetará cóor or bútore tákiba ítara ttu baáre neelizagói foribó, aar zetará farat tákiba ítara ttu cóor ot no góla foribó. ");
INSERT INTO rhgc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kiyólla-hoilé din híin óilde bodola loibar din, zeéne pak-kalam ot asé de híin beggún fura ó. ");
INSERT INTO rhgc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Montor hé din ókkol ot hámil mayafuain dor lla edde dud or maa ókkol olla bicí afsús or hálot óibo! Kiyólla-hoilé mulluk ot ḍoóñr mosibot óibo edde manúc ítarar uore gozzob aibó. ");
INSERT INTO rhgc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ítara re toluwar loi kotól gorífela zaybo, aar bañdí fottí koum or hañse loiza zaybo. Jerúsalem ore otókkal foijjonto Beyohúdi ókkole ṭénge úñrat tákibo, zetókkal Beyohúdi ítarar októ fura nó óiyo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aar san, beil edde tara ókkol ot taajuippa nicán ókkol dahá zaybo; duniyait koum ókkol ferecanit forizaybói, kiyólla-hoilé ítara doriyar abase edde goire súharaiya óizayboi, ");
INSERT INTO rhgc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","manúce duniyait óibo de híin or ḍoore edde báfaniye beúñic óizayboi, kiyólla-hoilé asmani jiníc ókkol tóttoraibo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Héñtte ítara dekíbo de, Manúc or Fua kudurut edde ḍoóñr mohímar sáañte ekkán miyúlat góri aiyér. ");
INSERT INTO rhgc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Montor zeñtté híin fura ówat dore, tuáñra uzu gori tíyai tuáñrar matá uormikká goríyo, kiyólla-hoilé tuáñrar rehái ḍáke.” ");
INSERT INTO rhgc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tarfore Isá ye ítara re ekkán meésal hoiyé, ki hoilé, “Ḍuñir-gas edde oinno gasgusala beggún ore soó. ");
INSERT INTO rhgc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Zeñtté híin ot fata aiyé, tuáñra híin saái nizorgá nize zanizogói de, hóran ḍáke. ");
INSERT INTO rhgc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Héndilla tuáñra yó, zeñtté iín ór de dekíba, héñtte yián buzíba de, Allar raijjo ḍáke. ");
INSERT INTO rhgc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Añí tuáñra re sóiyi hoóir, iín beggún fura nó óiyo foijjonto e nosól bilkúl no fúraibo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Asman zobin toh zari no tákibo, montor Añr hotá hámica zari tákibo. ");
INSERT INTO rhgc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Hétolla úñciyar táikko, zeéne tuáñrar dil ayaciye, nicábaziye, edde zindigir sintabáfaniye bóri no zagói, arnóile din yíba tuáñrar uore fán or ḍóilla bánggori aáizayboi; ");
INSERT INTO rhgc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kiyólla-hoilé din yíba fura duniyait asé de tamám manúc ókkol or uore héndilla góri aáizayboi. ");
INSERT INTO rhgc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hétolla tuáñra hárr októt úñciyar táikko, aar dua goríyo de, tuáñra ttu zen muúntu fura óibar asé de híin ottu basi zayboi lla bol táke aar Manúc or Fuar muúntu tíyai faro.” ");
INSERT INTO rhgc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Din ot Isá baitul-mukaddos ot taalim dito, montor háñzinna neeli Zaitun Faár hoó de yíbat zai rait haṛaitó; ");
INSERT INTO rhgc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","aar biínna sóore manúc beggúne Íbar boiyan fúni bolla baitul-mukaddos ot aitó. ");
INSERT INTO rhgc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Héñtte Yohúdi ókkol or Cúṭar-sára Ruṭir-id or din ḍáke aiccé, ze id ore Azadir-id bouli hoó. ");
INSERT INTO rhgc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aar ḍoóñr imam ókkole edde alem ókkole Isá re kii bote marifélai faribó híyan or talac ot accíl, kiyólla-hoilé ítara maincóre ḍooraitó. ");
INSERT INTO rhgc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Héñtte Yohúdah zaré Iskáriyet ḍake, ítar bútore Cóitan góille, zee accíl baró zon cárit tun ottu ezzon. ");
INSERT INTO rhgc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Íte zai ḍoóñr imam ókkol lói, alem ókkol lói, edde faáradar ókkol lói sólla goijjégoi de, íte kii bote Isá re tarár át ot dóridi faribó. ");
INSERT INTO rhgc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Híyan ot ítara kúci óiye, aar ítare ṭiañ diibo bouli hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Íte razi óiye, aar manúc or dol no táke de októt Isá re dóridi bolla moukar talac ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tarfore Cúṭar-sára Ruṭir-id or din aiccé, ze din ot Azadir-id or hána lla bérasóol or sóo kurbani gorá fóros. ");
INSERT INTO rhgc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isá ye Fitor edde Yohánna re difeṛái hoór de, “Zoo, añára hái fari fán Azadir-id or hánar toiyari gorógoi.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ítara Íba re hoór de, “Tuáñr ttu hondilla monehoór, añára hoṛé toiyar goittám?” ");
INSERT INTO rhgc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Íba ye ítara re hoór de, “Tuáñra cóor ot gólile mottor, zok ot gori faní loizar de ézzon manúc tuáñra llói milibó; íba ze gór ot gólibo hé gór ot íbar fisé-fisé zaiyo, ");
INSERT INTO rhgc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aar gór gan or girós ore hoibá de, ‘Ustate tuáñr re hoór de, “Meéman-hána hoṛé, ziyán ot Añí Añr cárit tun or fúañti Azadir-id or hána hái faijjum?” ’ ");
INSERT INTO rhgc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hétunot yóggwa ye tuáñra re háñzaiya ekkán uoror ṭalar ḍoóñr kamára daháibo; héṛe toiyar goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tói ítara zai, Isá ye ítara re zendilla hoiyé héndilla faiyé; baade Azadir-id or hánar toiyari goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Zeñtté októ aáigiyoi, Isá hána háito boiccé, Íbar fúañti sáhabi gún óu boiccé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Íba ye ítara re hoór de, “Añí duk faibar age tuáñrar fúañti e Azadir-id or hána háito bicí azzu goijjí; ");
INSERT INTO rhgc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","kiyólla-hoilé Añí tuáñra re hoóir, zetódin foijjonto yián Allar raijjot fura no, hétodin iín Añí abar na háiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Baade Íba ye fiyala looi Alla re cúkuriya gorí hoór de, “Yibá looi tuáñrar bútore borat goró. ");
INSERT INTO rhgc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kiyólla-hoilé Añí tuáñra re hoóir, ehón ottu lóti Allar raijjo nú aiyé foijjonto Añí anggur or roc na háiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tarfore Íba ye ruṭi looi Alla re cúkuriya goijjíl, aar báñgi ítara re dii hoór de, “Yián Añr gaa, ziyán tuáñra lla diiya zaybo; Añré monot gorí bolla endilla goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Héndilla ruṭi hái baade fiyala wa looi hoór de, “Añr lou loi óibo de noya razinamar nicán óilde e fiyala, ze lou tuáñra lla ḍálidiyum. ");
INSERT INTO rhgc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Montor soó, zee Añré dóridibo íte ehón Añr fúañti mes ot hána háar. ");
INSERT INTO rhgc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Becók, Alla ye fáisela goijjé de mozin Manúc or Fua moribó, montor afsús uitar uore, zee Íba re dóride.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Híyan fúni, tarár bútottu hé ham mán hone goríbo hoói ezzon ottu ezzone fusár goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ítarar bútottu haré beggún or túaro ḍoóñr mana zaybo hoói yó ekkán barábari uiṭṭíl. ");
INSERT INTO rhgc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isá ye ítara re hoór de, “Beyohúdi ókkol or baáñcca ókkole tarár uore hókumot goré, aar tarár uore zará adíkar sola, ítara ‘manúc or dustó’ bóuli dabi goré. ");
INSERT INTO rhgc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Montor tuáñra héndilla no óiyo, bólke zee niki tuáñrar bútore ebbe ḍoóñr asé, tee ebbe cóñṛo war ḍóilla óuk; aar zee niki sóddar asé, tee gulam or ḍóilla óuk. ");
INSERT INTO rhgc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kiyólla-hoilé honnwá ḍoóñr, ki mes ot hána háito boiyé de íba, aar náki hédmot goré de íba? Mes ot háito boiyé de íba no né? Lekin Añí tuáñrar bútore hédmot-goróyar ḍóilla. ");
INSERT INTO rhgc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Tuáñra óilade uitará zetará Añr dukkór októt fúañti-fúañti accíla. ");
INSERT INTO rhgc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Añr Bafe zendilla Añré ekkán raijjo diiyé, héndilla Añí yó tuáñra re ekkán raijjo diir, ");
INSERT INTO rhgc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","zeéne tuáñra Añr raijjot mazé Añr mes ot háafiya goró, edde toktót boói Isráil or baró guiccír bisar goró.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Sáimon, Sáimon, fún, Cóitane tuáñra re giyuñr ḍóilla salifélai bolla ezazot maiggé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Montor tor iman komzur no fán Añí tor lla dua goijjí, aar zeñtté tui Añr héṛe waafes aibí, tor báiyain dore mozbut goríc.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Fitore hoór de, “Malik, añí Tuáñr fúañti ziyól ot zaito edde moitto toiyar así.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isá ye hoór de, “Fitor, Añí toré hoóir, aijja ratakurá bak dibar age tui Añré no sinós hoói tin bar inkar goríbi.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tarfore Isá ye ítara re hoór de, “Zeñtté Añí tuáñra re ṭiañr zali, cenṭár edde hóilla sára difeṛáilam, héñtte tuáñra ttu kessúr homi aiccíl né?” Ítara hoór de, “Kessúr homi nu accíl.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Íba ye hoór de, “Ehón zar ttu ṭiañr zali asé tee fúañti loo, héndilla hóilla yó loo, aar zar ttu súri nái, tee nizor saddor besi ekkán kinilo. ");
INSERT INTO rhgc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pak-kalam ot toh endilla asé, ‘Íba re gunágar orfúañti gona giyéh,’Añí tuáñra re hoóir, hé hotá Añr bútore fura ówa zorur, kiyólla-hoilé Añr baabute ziín leikké híin fura ór.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ítara Íba re hoór de, “Malik, soó, eṛé duiyán súri asé.” Íba ye hoór de, “Iín óile kafí.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Isá neeli Nizor niyom mozin Zaitun Faár ot giiyé; cárit tun óu Íbar fisé-fisé giiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hé zagat foóñsi Íba ye ítara re hoór de, “Dua goró, zeéne entán ot no foro.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Íba ítarar híyan ttu eggwá cíl or dola melá máille zeddúr zaa, héddur ánik duré zai añṛúr tókdi dua gorér de, ");
INSERT INTO rhgc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ó Baf, zodi Tuñí soó, e duk-mosibot or fiyala yibá Añr ttu dur gorífelo, montor toóu Añr moncá mozin no, bólke Tuáñr moncá mozin óuk.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hétunot asman ottu eggwá fírista dahá dí Íba re bol diiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Íba ocánti ói dilmon di aró bicí dua gorát accíl, aar Íbar gám lou wór fúṛar ḍóilla ói meṛit foijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Íba zeñtté dua ttu uṛí cárit tun or héṛe aiccé, héñtte ítara ferecane óran ói gúm gíye de loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Íba ye tará re hoór de, “Tuáñra gúm zoór kiyá? Uṛó aar dua goró, zeéne entán ot no foro.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Íba ye híin hoór de októt, ek dol manúc aiccé, aar baró zon cárit tun ottu Yohúdah hoó de íte tarár age-age accíl. Íte Isá re appá dí bolla Íbar ḍáke giiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Montor Isá ye ítare hoór de, “Yohúdah, tui Manúc or Fua re appá dí dóri dór dé?” ");
INSERT INTO rhgc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zeñtté Íbar sáañti ókkole kii óibo de ót faiyé, ítara hoór de, “Malik, añára toluwar solaiyúm né?” ");
INSERT INTO rhgc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ítara ttu ezzone toluwar solai boro imam or gulam or den ḍák or han haṛifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Montor Isá ye hoór de, “Bon gor, endilla aar no goríc.” Baade Íba ye tar han dóri gom gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tarfore Isá ye ḍoóñr imam ókkol, baitul-mukaddos or sóddar ókkol, edde murubbi ókkol, zetará Íba re dóitto aiccé, tará re hoór de, “Tuáñra ḍahañiṭ dóitto aiccó fángori toluwar edde laṛí-cúṛa loi aiccó dé? ");
INSERT INTO rhgc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Añí tuáñrar fúañti fottí din baitul-mukaddos ot tákite toh tuáñra Añr uore át nó lago; lekin ehón tuáñrar októ, ze októt añdáre hókumot gorér.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tarfore tará Íba re gereftar gorífelai boro imam or gór ot loigiyói. Fitor duré-duré tái fisé-fisé zaat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tará zeñtté uṛán or mazé ooin zali fúañti gul gorí boiccé, Fitor óu tarár fúañti boiccé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ekgwá bañdi mayafua ye Fitor ore ooin or ṭal ot boiṛá dekí, gúañrai saái hoór de, “E manúc cwa yó Isár fúañti accíl.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Montor íba ye endilla hoói inkar gorídiye, “Héy mayafua, añí Íba re no siní.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hotún baade íba re ar ezzone dekí hoór de, “Tuñí yó ítarar bútottu ekzon.” Montor Fitore hoór de, “No bái, añí no.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Arek gónḍa ánik baade ar ezzon manúce yó ekin or sáañte hoór de, “Sóiyi, e manúc cwa yó Íbar fúañti accíl, kiyólla-hoilé ibá yó Galil or manúc.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Montor Fitore hoór de, “Ó bái, tuñí iín kiyór baabute hoór añí no zani.” Íba ye híyan hoór de októt, éhon-éhon ratakurá bak diyé. ");
INSERT INTO rhgc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hétunot Malike fíri Fitor or uzu saiyé. Aar Fitor ottu Malik or hotá waán monot uiṭṭé, ki hoilé, “Aijja ratakurá bak dibar age tui Añré tin bar inkar goríbi.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Baade íba baáre neeligói kúb hañdat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Zetará Isá re faáradi accíl, tará Íba re ínca gorát edde marat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tará Íbar suk bañdí fusár gorér de, “Toré hone maijjé antas gor sái?” ");
INSERT INTO rhgc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Héndilla tará Íbar hélaf bicí hotá ókkol hoói Íba re beizzoti goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Biínna foór fáiṭṭe rár, ḍoóñr imam ókkol or edde alem ókkol or, yáni Yohúdir murubbi ókkol or mujilíc óiye; ítara Isá re fótuayi-mujilíc ot aní hoór de, ");
INSERT INTO rhgc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Tuñí zodi Mosih de óile, añára re hoó.” Íba ye ítara re hoór de, “Zodi Añí tuáñra re hoói, tuáñra ekin no goríba, ");
INSERT INTO rhgc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","aar zodi Añí tuáñra ttu ekkán súwal fusár gorí, tuáñra zuwab no dibá. ");
INSERT INTO rhgc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lekin yala lóti Manúc or Fua Alla Tálar den ḍák ottu boói tákibo.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hétunot ítara beggúne fusár gorér de, “Tóoile Tuñí Allar Fua níki?” Íba ye ítara re hoór de, “Tuáñra sóiyi hoór, ói Añí.” ");
INSERT INTO rhgc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Híyane ítara hoór de, “Añára ttu ar kii gobá lager dé? Kiyólla-hoilé añára toh híyan Ibár nizor muk ottu fúinni.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tarfore mujilíc ṭíya uṛí Isá re Filat or hañse loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aar ítara Íbar uore endilla elzam ókkol lagat doijje, “Añára loot faiyí de, e Manúc cwa ye añárar koum ore gumrá gorífeler. Ibá ye Romi baáñcca re házana no diito maná goré, edde dabi goré de ki Íba Nize Mosih, Baáñcca.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Filate Isá ttu fusár gorér de, “Tuñí Yohúdi ókkol or Baáñcca níki?” Íba ye yóggwa re zuwabe hoór de, “Ói, tuñí hoór de héndilla.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tói Filate ḍoóñr imam mún ore edde manúc or dol ore hoór de, “Añí toh e Manúc cwa ttu honó hosúri no fair.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Montor ítara zit gorát accíl, ítara hoór de, “Ibá ye fura Yohúdiyat taalim di manúc ókkol ore uskai der. Ibá ye héndilla Galil ottu lóti cúru gorí e zagat foijjonto aiccé deh.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Filate híyan fúinne rár, Manúc ibá Galil or niki fusár goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yóggwa ye Isá zettót Hérud or elakar Manúc de zani faijjé, yóggwa ye Íba re Hérud or héṛe difeṛáidiye, kiyólla-hoilé hé októt Hérud óu Jerúsalem ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hérude Isá re dekí bicí kúci óiye, kiyólla-hoilé yóggwa ye bicí deri lóti Íba re dekí bolla azzu gorí accíl. Yóggwa ye Íbar baabute fúinnil de híyala lóti Íba ttu kessú keramot sai bolla acá goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yóggwa ye Isá re boóut súwala-súwali goijjíl, montor Íba ye yóggwa re honó zuwab nó deh. ");
INSERT INTO rhgc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ḍoóñr imam múne edde alem múne héṛe tíyai zuresúre Íbar uore elzam lagat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tarfore Hérude edde yóggwar fóous ókkole Isá re beizzoti edde ṭátṭai goijjíl. Ítara Íba re sosoikka eggwá zubba fiñdái Filat or hañse waafes difeṛáidiye. ");
INSERT INTO rhgc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hé din Filat edde Hérud dustó óigiyoi, age ítara ezzon loi ezzon duccon accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Filate ḍoóñr imam ókkol ore, sóddar ókkol ore edde awam ókkol ore matai zoma goijjé, ");
INSERT INTO rhgc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tói ítara re hoór de, “Tuáñra e Manúc cwa re añr hañse ainnó de, Ibá ye maincóre bagi boni bolla uskai der hoói. Montor soó, añí Ibá re tuáñrar cáikkat zerá goijjí, tuáñra e Manúc cwar uore ziín elzam lagoór, híin or baabute añí Ibá ttu honó hosúri no fair. ");
INSERT INTO rhgc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hérude yó nó faa, hétolla yóggwa ye Ibá re añárar hañse waafes difeṛáidiye deh; tuáñra dekór, moot or laayek Ibá ye honó kessú nó goré. ");
INSERT INTO rhgc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hétolla añí Ibá re sáñza dí hálas gorídiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yóggwa ttu fottí Azadir-id or din honó ek hodi re ítarar hañse hálas gorídiya foitto. ");
INSERT INTO rhgc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Montor ítara beggúne ekku fúañti guzori hoór de, “Íba re marifélo, Bárabba re añárar hañse hálas gorído.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bárabba re ziyól ot díya gyíl de, íte cóor ot bagiyai goijjíl de hétolla edde kún goijjíl de hétolla. ");
INSERT INTO rhgc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Filate Isá re hálas gorídibar niyote, ítara re ekí ḍóilla hotá abar hoóil. ");
INSERT INTO rhgc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lekin ítara guzori-guzori endilla howát accíl, “Kúruc ot dífelo, Íba re kúruc ot dífelo!” ");
INSERT INTO rhgc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Filate tisárabar ítara re hoór de, “Kiyá, e Manúc cwa ye kii bura goijjé dé? Añí toh Ibá ttu mora fore de héndilla honó hosúri nó fai; hétolla añí Ibá re sáñza dí hálas gorídiyum.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Montor ítara zit gorí guzori-guzori dabi gorát accíl de ki, Íba re kúruc ot dí mariféla záy bolla. Aar ahérit ítarar guzora kaamiyab óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tói Filate ítarar dabi mozin gorá záy bolla hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yóggwa ye ítara maiggíl de manúc cwa re hálas gorídiye, zibá re ziyól ot díya gyíl de, bagiyai edde kún goijjíl de hétolla; montor Isá re ítarar moncá mozin gorá záy bolla gosái dífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Fóous ókkole Isá re loizargói de októt, ítara Kureni cóor or Sáimon nam or ézzon manúc ore gang zaga ttu aiyér de héṛe dórifelaiye, dóri yóggwar uore kúruc can tulídiye, híyan Isár fisé-fisé boói loizai bolla. ");
INSERT INTO rhgc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ḍoóñr ek dol manúc Isár fisé-fisé zaat accíl, ítarar bútore boóut beṛiyáin óu accíl zetará Íba lla buk kilai-kilai hañdat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Isá ye ítarar híkka fíri hoór de, “Ó Jerúsalem or mayafuain, Añr lla no hañdiyó, bólke tuáñra nizor lla edde nizor fuain dor lla hañdo. ");
INSERT INTO rhgc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kiyólla-hoilé soó, eén din aiyér, ze din maincé hoibó de, ‘Mubarek báz mayafuain ókkol, zetará ttu honódin fuain nó óiyo, zetará honódin buk or dud nó háaba.’ ");
INSERT INTO rhgc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Héñtte maincé murá ókkol ore hoibó de, ‘Añárar uore for,’ aar faár ókkol ore hoibó de, ‘Añára re záfaifel.’ ");
INSERT INTO rhgc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kiyólla-hoilé manúce dargwá keeñsa tákite zodi endilla goré, fúaile kii no goríbo de asé?” ");
INSERT INTO rhgc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ítara oinno dui zon acámi re yó Íbar fúañti marifélai bolla loizar. ");
INSERT INTO rhgc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ítara zeñtté Matár Mala hoó de zaga híyan ot foóñicce, héṛe ítara Íba re edde hé acámi gún ore kúruc ot díye, ezzon ore Íbar den ḍák ottu edde ar ezzon ore Íbar ban ḍák ottu. ");
INSERT INTO rhgc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Isá ye hoór de, “Ó Baf, itará re maf goró; kiyólla-hoilé itará kii gorér de híyan itará no zane.” Baade ítara loṭári mari ítarar bútore Íbar hoorsuor ore bák goijjé. ");
INSERT INTO rhgc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Manúc ókkole tíyai saái táikkil. Yohúdir neta ókkole yó Íba re ṭátṭai gorí hoór de, “Ibá ye toh oinno zon ore basaitó; zodi Ibá Allar Baiccá Mosih wa de óile, yala Nizoré Nize basouk sái.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Fóous ókkole yó ḍáke aái Íba re ṭátṭai gorát accíl. Ítara Íba re hái bolla sírka dii ");
INSERT INTO rhgc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","hoór de, “Zodi Tui Yohúdir Baáñcca de óile, yala Nizoré Nize basa sái!” ");
INSERT INTO rhgc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Íbar matár uottú ekkán sáainbúṭ óu maridiíl, ziyán ot leikké de, “Ibá óilde Yohúdi ókkol or Baáñcca.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kúruc ot díya giyéh de acámi ttu ezzone Íba re beizzoti gorí hoór de, “Tui ki Mosih no? Nizoré edde añára re basa sená.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Montor oinno acámi wa ye ítare jéjjeṛai zuwab der de, “Tui ki Alla re úddwa no ḍooros? Tui yó de ekí ḍóilla sáñza foór. ");
INSERT INTO rhgc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Becók añárar sáñza hókkot, kiyólla-hoilé añára nizor ham olla ziyán laayek híyan fair deh, lekin e Manúc cwa ye toh honó hosúri nó goré.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tarfore yóggwa ye hoór de, “Ó Isá, Tuñí Nizor raijjot aibá de októt añré yaad raikkó.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isá ye yóggwa re hoór de, “Añí tuáñre sóiyi hoóir, aijja tuñí Añr fúañti jonnotul-férodus ot óiba.” ");
INSERT INTO rhgc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Héñtte duúñijjar baró wa ánik baijjé, héñtte lóti tin nwá báze fán guñṛa mulluk andár ói accíl, ");
INSERT INTO rhgc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kiyólla-hoilé beile foór díya bon gorífelaiye; aar baitul-mukaddos or foroda gán fáṛi dui bák óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hétunot Isá ye eggwá ḍoóñr abase guzori hoór de, “Ó Baf, Tuáñr át ot Añr ruh gosáidiyi.” Híyan hoói baade Íba entehal óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ziyán óiye híyan dekí Romi cáape Allar taarif gorí hoór de, “Sóiyi e Manúc cwa behosúr accíl!” ");
INSERT INTO rhgc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aar manúc zetará hé tooñcá saitó zoma óiye, ítara beggúne ziín óiye híin dekí buk kilai-kilai waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Montor Íbar sinforiso manúc edde beṛiyáin zetará Galil ottu lóti Íbar fisáli doijjil, ítara beggúne duré góri tíyai híin saái táikkil. ");
INSERT INTO rhgc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yusúf nam or ézzon gom edde forhésgar manúc accíl. Yóggwa fótuayi-mujilíc or membór accíl, ");
INSERT INTO rhgc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","montor yóggwa ítarar sóllat edde ham ot razi nu accíl. Yóggwa Yohúdir cóor Aramátiyat tákito, aar Allar raijjo lla entezar gorí accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yóggwa ye Filat or hañse zai Isár lac cwa maiggé, ");
INSERT INTO rhgc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","baade lac cwa lamai ekkán hohón or hoor ot beráiye, aar cíl kúñdi banaiyé de eggwá hobor or bútore raikkégoi, zibát honódin honókiyo re dohón goráil de nái. ");
INSERT INTO rhgc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hé din accíl entezam-or-din, aar ebaadot-or-din cúru óibar októ óiye. ");
INSERT INTO rhgc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galil ottu ze beṛiyáin nún Isár fúañti aiccíl ítara fisá dori, hobor gwá edde Isár lac cwa re keéngori raikké de deikkíl. ");
INSERT INTO rhgc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tarfore ítara waafes zaigói, kúcbo mosólla ókkol edde añtor ókkol toiyar goijjíl. Aar ebaadot-or-din Córiyot or hókum mozin ziraáil. ");
INSERT INTO rhgc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Háftar foóila din biínna kúb sóore, beṛiyáin núne kúcbo mosólla uúin looi hobor gwat aiccé ziín ítara toiyar goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ítara hobor or muk ottu cíl lan larifelaiya loot faáil, ");
INSERT INTO rhgc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","montor bútore góille rár, Malik Isár lac loot nó faa. ");
INSERT INTO rhgc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ítara oulzóul ot forigiyói de októt, asimbit sosoikka hoor findá duwá manúc ítarar ḍák ottu tíyaiye. ");
INSERT INTO rhgc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Beṛiyáin ítara ḍoore matá hémmikka gorífelaiye, montor manúc cúne ítara re hoór de, “Tuáñra Zindawa re mora ókkol ot máze kiyá tuwoór? ");
INSERT INTO rhgc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Íba eṛé nái, Íba zinda óigiyoi. Monot goró, Íba ye Galil ot tákite tuáñra re kii hoóil. ");
INSERT INTO rhgc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hoóil de, Manúc or Fua re gunágar ókkol or át ot gosáidiya foribó, kúruc ot dí mariféla foribó, aar tin din ot din Íba ttu abar zinda óizagoi foribó.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hétunot ítara ttu Íbar hotá monot uiṭṭíl. ");
INSERT INTO rhgc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Baade ítara hobor ottu waafes giiyégoi, aar híin beggún egaro zon nún ore edde baki manúc beggún ore zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Zetará sáhabi gún ore híin zanaiyé, ítara óilde Moriyam Makdálini, Joanna, edde Yakub or maa Moriyam; ítarar fúañti aró beṛiyáin ókkol accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Montor ítara ttu híin alṭufálṭu hotár ḍóil laiggíl, hétolla ítara beṛiyáin nún ore biccác nó goré. ");
INSERT INTO rhgc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lekin Fitor uṛí hobor ot duñrdiyé, aar niyúri saiyé rár dekér de, siríf hohón or hoor gún beh asé. Íba ye hé hálot dekí taajup ói, gór ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Soó, hé din ítara ttu dui zon manúc ekkán Émayus nam or farat zaar, ziyán Jerúsalem ottu háñt mail duré. ");
INSERT INTO rhgc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aar ítara ezzon loi ezzone, ziín óiye híin beggún or baabute gofat accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ítara gofer de edde toskara gorér de októt, Isá Nize ḍáke aái ítarar fúañti áñṛat doijje. ");
INSERT INTO rhgc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lekin ítarar suk ore Íba re siní no fare fán gorífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Íba ye ítara re hoór de, “Tuáñra áñṛi-áñṛi ezzon loi ezzone iín kiyór baabute gofór dé?” Hétunot ítara nakmuk hala gorí tíyaigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ítara ttu zar nam niki Kaleópas, yóggwa ye Isá re zuwabe hoór de, “Jerúsalem or forbáci siríf Tuñí ezzone niki e hooddin or bútore óiye de híin no zano dé?” ");
INSERT INTO rhgc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isá ye ítara re hoór de, “Kii óiye dé?” Ítara Íba re hoór de, “Isá Nasárir uore óiye de híin. Íba Allar edde tamám manúc or nozor ot hame edde hotábattaraye eggwá taakotwala nobi accíl. ");
INSERT INTO rhgc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ḍoóñr imam ókkole edde añárar sóddar ókkole Íba re moot or sáñza lla gosáidiye, aar Íba re kúruc ot dífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lekin añára ttu acá accíl de, Boni Isráil ore Íba ye beh azad goríbo. Aró hoiyúm hoilé, iín óiye de aijja tin din óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Montor añárar bútottu hoozzon beṛiyáin de añára re ammúk gorídiye. Ítara biínna kúb sóore hobor gwat gyíl, ");
INSERT INTO rhgc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","montor Íbar lac loot nó faa. Ítara aái hoiyégai de, ítara re fírista ye dahádiye aar híine ítara re hoiyé de, Íba zinda asé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hétunot añárar fúañti accíl de ítara ttu hoozzone hobor gwat giiyé rár, beṛiyáin núne hoiyé de mozin loot faiyé, montor ítara Isá re nó deké.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hétunot Isá ye ítara re hoór de, “Ó bekuf ókkol, tuáñrar dil toh nobi ókkole hoóigiye de hotá beggún biccác goitté bicí asté! ");
INSERT INTO rhgc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mosih ttu Íbar mohímat góilte duk híin faar ki zorur nu accíl?” ");
INSERT INTO rhgc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Baade Íba ye Muúsa edde tamám nobi ókkol ottu cúru gorí, fura pak-kalam ot Íbar baabute ziín asé híin ítara re buzáidiye. ");
INSERT INTO rhgc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Zaite-zaite ítara zaar de farar hañsáhañsi foóñicce rár; Íba ye aró duré zaar fán goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Montor ítara Íba re becábicí aros gorí hoór de, “Añárar fúañti táizogoi, kiyólla-hoilé háñz óizargoi, aar din fúraiyegai.” Tói Íba ítarar fúañti táki bolla bútore giiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aar eén óiye, zeñtté Íba ítarar fúañti hána háito boiccé, Íba ye ruṭi looi Alla re cúkuriya goijjíl, aar báñgi ítara re diiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hétunot ítarar suk kúligiyoi, aar ítara Íba re sinné; montor Íba ítarar nozor ottu gaib óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ítara ezzon ore ezzone hoór de, “Foñt ot zeñtté Íba ye añára llói hotá hoór aar añára re pak-kalam buzái der, héñtte añárar bútore añárar dil zolat accíl de no né?” ");
INSERT INTO rhgc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ítara éhon-éhon uṛí Jerúsalem ot waafes aáigiyoi, aar héṛe egaro zon nún ore edde ítarar sáañti ókkol ore ekkán ot zoma loot faiyé, ");
INSERT INTO rhgc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","aar hoór de, “Malik sóiyi zinda óiye; Íba ye Sáimon ore dahádiye.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tarfore ítara duní zone foñt ot kii óiye de zanaiyé, edde Isá ye ruṭi báñgibar októt Íba re ítara keéngori sinníl de híyan óu zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ítara híin hoór de októt, Isá Nize ítarar mazé aái tíyaiye, aar hoór de, “Assalamu alaikum.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Montor ítara ḍoore toddó óigiyoi, ítara ṭáaijje de bút dekér bóuli. ");
INSERT INTO rhgc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Íba ye ítara re hoór de, “Tuáñra ḍoorór kiyá? Tuáñrar dil ot cóok kiyá aiyér? ");
INSERT INTO rhgc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Añr át ṭéng soó, Ibá Añí. Añré dóri soó, kiyólla-hoilé bút ottu toh gusso edde áñḍḍi nái, zendilla Añr ttu asé de dekór.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Híyan hoói Íba ye ítara re Nizor át ṭéng daháiye. ");
INSERT INTO rhgc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ítara zettót kúciye edde taajupe biccác gorí no farer, Íba ye ítara re hoór de, “Hái bolla eṛé tuáñra ttu kessú asé né?” ");
INSERT INTO rhgc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tói ítara Íba re ek hánḍa síañt díya mas diiyé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aar Íba ye híyan looi ítarar cáikkat háiye. ");
INSERT INTO rhgc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tarfore Íba ye ítara re hoór de, “Iín óilde Añr hotá ziín tuáñra re Añí tuáñrar fúañti tákite hoóilam, ki hoilé, Añr baabute ziín Muúsar Córiyot ot, nobi ókkol or kitab ot, edde Zobur Córif ot leikká asé, híin beggún fura ówar zorur.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Baade Íba ye ítarar demak kúlidiye, zeéne ítara pak-kalam buzí fare. ");
INSERT INTO rhgc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Íba ye ítara re hoór de, “Pak-kalam ot endilla asé, Mosih ye duk faibo aar tin din ot din mora ttu zinda óizayboi, ");
INSERT INTO rhgc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","baade Jerúsalem ottu lóti cúru gorí tamám koum ókkol or hañse Íbar name guná maf faibar touwár tobolik gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tuáñra óilade iín beggún or gobá. ");
INSERT INTO rhgc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Soó, Añr Baf or waada goijjá wa re Añí tuáñrar hañse difeṛáidiyum; lekin asman ottu taakote bóri nó zogoi foijjonto e cóor ot táikko.” ");
INSERT INTO rhgc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Fore Isá ye ítara re baárkule Betániyar héddur foijjonto loigiyé, aar Íbar át tulí ítara re borhot diyé. ");
INSERT INTO rhgc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Íba ye ítara re borhot diyat accíl de októt, Íba ítara ttu alok óigiyoi, aar Íba re asman ot tulífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ítara Íba re sóida gorí baade, bicí kúcir sáañte Jerúsalem ot waafes aáigiyoi, ");
INSERT INTO rhgc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","aar baitul-mukaddos ot házir táki lagatar Allar taarif gorát accíl.");
INSERT INTO rhgc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Foóila cúrut Kalam accíl, Kalam Allar fúañti accíl, edde Kalam nize Alla accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Íba foóila cúrut Allar fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hárr kessú Íbar duara foida gorá gíyeh, aar zedún foida gorá gíyeh híin or bútore ekkán óu Íba re sára foida gorá nó zah. ");
INSERT INTO rhgc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Íbar hañse zindigi accíl, aar hé zindigi accíl insán or Nur. ");
INSERT INTO rhgc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hé Nure andár ot foór deh, montor andáre hé Nur ore ziti no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Alla ye Yaháya nam or ézzon manúc ore duniyait difeṛáil. ");
INSERT INTO rhgc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yóggwa re hé Nur or ek gobá ísafe difeṛá gíyl, zeéne beggúne yóggwar gobá fúni iman ané. ");
INSERT INTO rhgc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yóggwa nize hóno hé Nur accíl de no, bólke yóggwa hé Nur or baabute gobá díto aiccíl deh. ");
INSERT INTO rhgc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sóiyi Nur óilde Ubá zibá ye fottí maincóre foór deh, Íba duniyait aibár accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Íba duniyait accíl, aar duniyai Íbar duara foida gorá gíyeh, toóu duniyair maincé Íba re nó siné. ");
INSERT INTO rhgc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Íba Nizor maincór héṛe aiccíl, montor nizor maincé Íba re kobul nó goré. ");
INSERT INTO rhgc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lekin zetó zone Íba re kobul gorí iman ainné, ítara fottí zon ore Íba ye Allar fuain óibar hók diiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ítarar hé zormo no lou wóttu óiye, no jisím or moncáye óiye, aar no manúc or moncáye óiye, bólke Alla ttu óiye deh. ");
INSERT INTO rhgc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hé Kalam insán boinné, aar añárar fúañti táikke. Baf or lehár ek Fua ísafe Íbar ze mohíma asé hé mohíma re añára deikkí. Íba rahámote edde sóiyiye furaiya. ");
INSERT INTO rhgc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaháya ye Íbar baabute gobá díyl. Yóggwa ye guzori hoóil de, “Ibá óilde Ubá zibár baabute añí endilla hoóilam, ‘Añí baade zibá aiyér Íba añr túaro ḍoóñr, kiyólla-hoilé Íba añr age lóti asé.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Añára beggúne toh Íbar furaiya ttu rahámot or uore rahámot faiyí. ");
INSERT INTO rhgc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kiyólla-hoilé Córiyot diiya gyíl de Muúsar duara, montor rahámot edde sóiyi aiccé de Isá Mosihr duara. ");
INSERT INTO rhgc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Alla re toh honókiye honódin deikké de nái, lekin Baf or buk ot accíl de lehár ek Fua ye beh Íba re zahér goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yaháyar gobá accíl de yián, zeñtté Yohúdir neta ókkole Jerúsalem cóor ottu hoozzon imam ore edde Leéviyo re yóggwar héṛe yián fusár goittó difeṛáiye, “Tuñí hon?” ");
INSERT INTO rhgc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yóggwa ye inkar nó goré, bólke cíkar gorí hoiyé de, “Añí Mosih no.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ítara yóggwa ttu fusár goijjé de, “Tóoile tuñí hon? Tuñí hóno nobi Eliyas né?” Yóggwa ye hoiyé de, “No, añí no.” Tói ítara fusár goijjé de, “Tuñí kí aibár hotá asé de hé Nobi?” Yóggwa ye zuwab diyé de, “No.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tarfore ítara yóggwa re hoiyé de, “Tóoile tuñí hon añára re zuwab doh, zeéne zetará añára re difeṛáiye ítara re zuwab di fari. Tuñí nizor baabute kii hoó?” ");
INSERT INTO rhgc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yaháya ye nobi Yesáyahr hotá lói zuwab diyé de, “Añí óilam de ubá zibá ye moidan zagat guzori-guzori eén hoór, ‘Mabud or rasta uzu goró.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hé manúc ítara re difeṛá gíyeh de óilde Féroci fírkar torfóttu. ");
INSERT INTO rhgc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ítara Yaháya ttu fusár goijjé de, “Zodi tuñí Mosih no, Eliyas no, edde hé Nobi wa yó no, tóoile tuñí bápṭisma kiyá doh?” ");
INSERT INTO rhgc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaháya ye ítara re zuwabe hoiyé de, “Añí toh fanít éna bápṭisma dí, montor tuáñrar bútore eén Ekzon tíyai asé zibá re tuáñra no sinó. ");
INSERT INTO rhgc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Íba óilde Ubá zibá añí baade aiyér; añí Íbar cenṭár or fíta kúli bolla úddwa laayek no.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iín Jordán hál or farkule Betániyat óiye deh, zeṛé Yaháya ye bápṭisma díto. ");
INSERT INTO rhgc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tarfor din Yaháya ye Isá yóggwar uzu aiyér de dekí, hoór de, “Soó, Ubá óilde Allar Bérasóol-or-Sóo, zibá ye duniyair maincór guná loizagói. ");
INSERT INTO rhgc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Íba óilde Ubá zibár baabute añí endilla hoóilam, ‘Añí baade eén Ekzon aiyér, zibár tokka añr túaro ḍoóñr, kiyólla-hoilé Íba añr age lóti asé.’ ");
INSERT INTO rhgc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Añí Íba re no sinítam, montor Íba Isráili ókkol or hañse zahér ó fán, añí fanír bápṭisma díto aiccí deh.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tarfore Yaháya ye yián gobá díye, “Añí deikkí de, Pak-Ruh hoitor or ḍóilla ói asman ottu lami aái Íbar uore boiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Añí Íba re no sinítam, montor zibá ye añré fanír bápṭisma díto difeṛáiye, Íba ye añré hoiyé de, ‘Zibár uore Pak-Ruh lami aái boibó de dekíbi, Íba óilde Ubá zibá ye Pak-Ruh lói bápṭisma díbo.’ ");
INSERT INTO rhgc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Añí héndilla deikkí edde gobá dír de ki, Ibá óilde Allar Fua.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tarfor din abar Yaháya edde yóggwar dui zon ummot héṛe tíyai accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aar Isá híyan ttu áñṛi zaar de dekí, yóggwa ye hoór de, “Soó, Ubá óilde Allar bérasóol-or-Sóo!” ");
INSERT INTO rhgc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yóggwar hotá fúni, hé duní ummot Isár fisáli doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isá ye fissá fíri dekér de, ítara fisé-fisé aiyér; hétunot ítara re hoór de, “Tuáñra kii talac gorór dé?” Ítara zuwab der de, “Rabbí” (ziyán or maáni óilde, ustat), “Tuñí hoṛé táko dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Íba ye ítara re hoór de, “Aiyó soógai.” Tói ítara zai, Isá táke de zaga gán saiyé, aar hé din Isár fúañti táikkil. Héñtte háñzinna sair gwá baijjíl. ");
INSERT INTO rhgc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yaháyar hotá fúni ze dui zon Isár fisáli doijjil, ítara ttu ezzon accíl Sáimon Fitor or bái Enderiyas. ");
INSERT INTO rhgc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yóggwa ye age nizor bái Sáimon ore tuwai loi íba re hoór de, “Añára Mesáiya re loot faiyí” (Mesáiya maáni, Mosih). ");
INSERT INTO rhgc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yóggwa ye Sáimon ore Isár hañse ainné. Isá ye Sáimon or híkka saái hoór de, “Tui toh Yohánnar fua Sáimon, montor toré Kéfas ḍaha zaybo” (hé nam or maáni óilde, Fitor). ");
INSERT INTO rhgc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tarfor din Isá ye Galil elakat zaitogói niyot goijjé. Íba ye Filíp ore loot fai hoór de, “Añr fisáli dor.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filíp accíl de Enderiyas edde Fitor tarár cóor Betsáidar manúc. ");
INSERT INTO rhgc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filípe Natanel ore loot fai hoór de, “Añára Ubá re loot faiyí zibár baabute Muúsa ye Tourat Córif ot leikké, aar nobi ókkole yó leikké; Íba óilde Yusúf or fua Isá, Nasárat cóor or.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanele íba re hoór de, “Nasárat ottu kí kessú gom aái fare?” Filípe hoór de, “Aiyó, soógai.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Isá ye Natanel Nizor uzu aiyér de dekí yóggwar baabute hoór de, “Soó, ezzon sóiyi Isráili, zibár bútore honó dúkabazi nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanele Isá ttu fusár gorér de, “Tuñí añré keéngori sinó?” Isá ye yóggwa re zuwabe hoór de, “Tuáñre Filípe ḍahaibár age zeñtté tuñí ḍuñir-gas tala accíla, héñtte Añí tuáñre deikkí.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hétunot Natanele Íba re hoór de, “Rabbí, Tuñí óilade Allar Fua, Tuñí Boni Isráil or Baáñcca.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Isá ye yóggwa re zuwabe hoór de, “Añí tuáñre ḍuñir-gas tala deikkí hoiyí de híyan olla kí tuñí iman ainnó? Tuñí iín or túaro ḍoóñr-ḍoóñr ham ókkol dekíba.” ");
INSERT INTO rhgc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Íba ye aró hoór de, “Añí tuáñra re sóiyi-sóiyi hoóir, tuáñra endilla dekíba, asman kúla aar Allar fírista ókkol Manúc or Fuar uore uṛálama gorér.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tin din ot din Galil or Kána farat ekkán boirat óiye. Isár maa héṛe accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hé boirat ot Isá edde Íbar cárit tun ore yó dawot diyé. ");
INSERT INTO rhgc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Zeñtté héṛe anggur or roc fúraigiyoi, Isár maa ye Isá re hoór de, “Itará ttu ar anggur or roc nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Isá ye maa re hoór de, “Maá, híyan or baabute tuñí lói Añí lói kii bazá asé? Añr októ de aijjó nú aiyé.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Isár maa ye háadem ókkol ore hoór de, “Ibá ye tuáñra re ziín goittó hoó, híin goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yohúdir Córiyot mozin uzu banai bolla héṛe fattór or sów wa siyú buágaraiya accíl, híin ekgwát máze kuri ttu tiríc gelóm foijjonto faní añṛitó. ");
INSERT INTO rhgc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isá ye háadem ókkol ore hoór de, “E siyú gún ot faní bóro.” Tói ítara híin ot ṭip-ṭip faní bóijje. ");
INSERT INTO rhgc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Baade Isá ye ítara re hoór de, “Yala entú hodún looi boiraitta hánar zimmadar ore doogói.” Tói ítara loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ze faní gún anggur or roc bonigiyói, híin hé zimmadar gwá ye háisai baade dulá re mataiyé. Yóggwa ye hé anggur or roc cún hontú aiccé hoi no fare, montor goóur zetará faní ainné ítara hoi fare. ");
INSERT INTO rhgc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Yóggwa ye dulá re hoór de, “Fottí maincé de age gom anggur or roc cún hábaifela, aar meéman ókkol or mon mozin háiya óile baade yár túaro hóraf fin háaba. Montor tuñí aijjó gom anggur or roc cún rakídiyo.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galil or Kána farat illayi-nicán ísafe e foóila cúrur keramot tán gorí Isá ye Nizor mohíma zahér goijjé. Híyan dekí Íbar cárit tune Íbar uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yárbaade Isá, Isár maa, báiyain, edde cárit tun nise Kaparnahúm cóor ot giiyé; ítara héṛe hooddin táikkil. ");
INSERT INTO rhgc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yohúdi ókkol or Azadir-id zeñtté ḍáke aiccé, Isá uore Jerúsalem ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aar baitul-mukaddos or uṛán ot mazé Íba ye dekér de, maincé goru, bérasóol, edde hoitor ókkol beser, aar hodúne boói baṭṭa báñger. ");
INSERT INTO rhgc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hétunot Íba ye rosí lói ekkán coóñk banai ítara re baitul-mukaddos or uṛán ottu bérasóol edde goru ókkol lói looraidiye. Íba ye baṭṭa báñgoya ókkol or ṭebíl natḍiyagaraidi ítarar ṭiañ-foicá cíñṛaciñṭṭá gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Zetará hoitor beser, ítara re Íba ye hoór de, “Entú iín loizogói! Añr Baf or gór ore bazar no banaiyó!” ");
INSERT INTO rhgc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hétunot Íbar cárit tun ottu pak-kalam or e hotá monot uiṭṭé, “Tuáñr gór or muhábbote añré háifelaibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yohúdi ókkole Isá ttu fusár gorér de, “Tuáñr ttu iín goríbar adíkar asé de híyan, Tuñí añára re kii keramot dahái sábut gorí faribá?” ");
INSERT INTO rhgc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isá ye ítara re zuwab der de, “E baitul-mukaddos yián báñgifelo, Añí tin din or bútore banaidiyum.” ");
INSERT INTO rhgc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yohúdi ítara hoór de, “E baitul-mukaddos yián banaité salic-sów bosór laiggé, aar Tuñí tin din or bútore banai diba dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Montor Isá ye baitul-mukaddos or bazá dí Íbar Nizor gaar baabute hoiyé deh. ");
INSERT INTO rhgc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hétolla zeñtté Isá re mora ttu zinda gorá gíyeh, Íbar cárit tun ottu Íba ye hoiyé de hotá monot uiṭṭé. Tarfore ítara pak-kalam edde Isár hé hotár uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Azadir-id or októt, Isá ye Jerúsalem ot tákite ze keramot goijjíl, híin dekí bicí maincé Íbar uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lekin Isá ye ítara re bóraca nó goré, kiyólla-hoilé Íba ye manúc beggún ore bálagori siné, ");
INSERT INTO rhgc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","aar Íba ttu maincór baabute honó gobá no lage, kiyólla-hoilé maincór dil ot kii asé de híyan Íba ye zane. ");
INSERT INTO rhgc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Féroci ókkol or bútore Nikódemas nam or ézzon Yohúdi ókkol or neta accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ek din raitta yóggwa Isár héṛe aái hoór de, “Rabbí, añára zani, Tuñí ézzon ustat ísafe Allar torfóttu aiccó; kiyólla-hoilé Tuñí ze keramot ókkol goró, Alla fúañti no tákile honókiye híin gorí no fare.” ");
INSERT INTO rhgc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isá ye yóggwa re zuwabe hoór de, “Añí tuáñre sóiyi-sóiyi hoóir, noya gori zormo no óile, honókiye Allar raijjo dekí no fare.” ");
INSERT INTO rhgc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikódemase Isá ttu fusár gorér de, “Zeñtté manúc ézzon burá óizagoi, íte keéngori abar zormo loibo? Dusárabar kí íte maar feṛot góli abar zormo ói faribó?” ");
INSERT INTO rhgc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isá ye yóggwa re zuwab der de, “Añí tuáñre sóiyi-sóiyi hoóir, faní edde Ruh ttu zormo no óile, honókiye Allar raijjot góli no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Insán ottu ziín zormo ó híin insán, aar Ruh ttu ziín zormo ó híin ruh. ");
INSERT INTO rhgc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Añí ziyán tuáñre hoiyí, tuáñra ttu noya gori zormo ówa foribó, híyan lói ammúk no óiyo. ");
INSERT INTO rhgc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Boiyar toh zikká monehoó híkka baá, aar tuñí hé boiyar or abas fúno, montor hontú aiyér aar hoikká zaar híyan toh no zano. Zetará Ruh ttu zormo óiye ítara yó héndilla.” ");
INSERT INTO rhgc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikódemase Isá ttu fusár gorér de, “Iín keéngori ói fare?” ");
INSERT INTO rhgc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isá ye yóggwa re zuwabe hoór de, “Tuñí de ézzon Boni Isráil or ustat, toóu tuñí iín no buzó dé? ");
INSERT INTO rhgc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Añí tuáñre sóiyi-sóiyi hoóir, añára ziín zani híin hoói, aar ziín deikkí híin or baabute gobá díh, montor tuáñra añárar gobá re kobul no goró. ");
INSERT INTO rhgc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Añí tuáñra re duniyaibi jiníc or hotá hoilé zettót biccác no goró, tói asmani jiníc or hotá hoilé keéngori biccác goríba? ");
INSERT INTO rhgc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Zibá asman ot táke aar asman ottu lami aiccé, hé Manúc or Fua sára ar honókiye asman ot nó uṛé. ");
INSERT INTO rhgc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Muúsa ye zendilla moidan elakat háf ore uore tuillíl, héndilla Manúc or Fua re yó uore tulá zaybo, ");
INSERT INTO rhgc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","zeéne zee niki Íbar uore iman ané íte ofúrani zindigi faa. ");
INSERT INTO rhgc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kiyólla-hoilé Alla ye duniyair maincóre etó muhábbot goijjé, Íba ye Nizor lehár ek Fua dan gorífelaiye; zeéne zee kiyé hé Fuar uore iman ané yóggwa nac no, bólke ofúrani zindigi faa. ");
INSERT INTO rhgc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Alla ye toh duniyair maincór hosúri dóitto Nizor Fua re duniyait difeṛáiye de no, bólke etollá difeṛáiye, zeéne duniyair maincé hé Fuar duara nejat fa. ");
INSERT INTO rhgc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Zee niki hé Fuar uore iman ané, ítar hosúr dóra no zah; montor zee niki iman nu ané, ítar hosúr age lóti dóra gíyeh, kiyólla-hoilé íte de Allar siríf ek Fuar uore iman nú ané. ");
INSERT INTO rhgc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ítar hosúr etollá bóuli dóra gíyeh, kiyólla-hoilé duniyait Nur aiccíl, montor manúc ókkol or ham hóraf de hétolla, ítara Nur or túaro andár ore bicí fosón goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Zee niki hóraf ham goré, íte Nur ore nafórot goré aar íte Nur ot nu aiyé, kiyólla-hoilé zodi ailé ítar hórafi dahá zaybo bouli ḍoora. ");
INSERT INTO rhgc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Montor zee niki sóiyi gán gorí zindigi haṛa, íte Nur ot aiyé, zeéne ítar ham ókkol Allar moncá mozin gorá gíyeh de híyan sáf-sáf góri dahá zah.” ");
INSERT INTO rhgc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yárbaade Isá edde Íbar cárit tun Yohúdiya elakat giiyé. Héṛe Íba cárit tun or fúañti hooddin táikkil, aar manúc ókkol ore bápṭisma díyl. ");
INSERT INTO rhgc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Héñtte Sálim zagar ḍáke Ainon nam or ek farat Yaháya yó bápṭisma díyat accíl, kiyólla-hoilé hé zagat bicí faní accíl, aar manúc ókkol aái íba ttu bápṭisma lowat accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yaháya re hé októt ziyól ot díya nó zah. ");
INSERT INTO rhgc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ek din Yaháyar hoozzon ummote Yohúdi ókkol lói uzu banar baabute torkatorki diyé. ");
INSERT INTO rhgc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ítara Yaháyar hañse aái hoór de, “Rabbí, Zibá Jordán hál or farkule tuáñr fúañti accíl, Zibár baabute tuñí gobá díyla, soó, Íba ye bápṭisma der, aar manúc beggún Íbar héṛe aiyér.” ");
INSERT INTO rhgc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaháya ye zuwab der de, “Asman ottu diiya no gilé honókiye kessú fai no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tuáñra nize toh añr e hotár gobá asó, ki hoilé, ‘Añí Mosih no, montor añré Íbar age difeṛá gíyeh.’ ");
INSERT INTO rhgc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Zar át ot dulí re tulídiya gíyeh íte óilde dulá. Dulár dustó ye toh tíyai dulár hotá fúne, aar dulár abas fúni bicí kúci ó. Borabor héndilla, yala añr kúci yó fura óiye. ");
INSERT INTO rhgc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Becók Íba ttu ḍoóñr ówa foribó, aar añr ttu cóñṛo ówa foribó. ");
INSERT INTO rhgc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Zibá uottú aiccé, Íba beggún or uore; zibá duniyai ttu, íba duniyair, aar duniyaibi hotá hoó. Montor zibá asman ottu aiccé, Íba beggún or uore. ");
INSERT INTO rhgc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Íba ye ziín deikké edde fúinne híin or gobá déh, toóu honókiye Íbar gobá kobul no goré. ");
INSERT INTO rhgc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Montor zee niki kobul goijjé, íte e hotát moór lagaifélaiye de ki, Alla óilde sóiyi. ");
INSERT INTO rhgc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Zibá re Alla ye difeṛáiye, Íba ye Allar hotá hoó, kiyólla-hoilé Alla ye toh mafi-mafi Ruh no dee. ");
INSERT INTO rhgc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bafe Fua re muhábbot goré, aar hárr kessú Íbar át ot gosáidiye. ");
INSERT INTO rhgc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Zee niki hé Fuar uore iman ané, ítar ttu ofúrani zindigi asé; montor zee niki hé Fuar uore iman nu ané, íte hé zindigi no dekíbo, bólke ítar uore Allar gozzob asé.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Zeñtté Malike zani faijjé de ki, Íba ye Yaháyar túaro bicí ummot banaiyé de aar bápṭisma díye de híin Féroci ókkole fúinne, ");
INSERT INTO rhgc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","háleke Isá Nize bápṭisma no dito, bólke Íbar ummot ókkole dito deh, ");
INSERT INTO rhgc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","tói Íba Yohúdiya elaka ttu neeli abar Galil elakat zaargói. ");
INSERT INTO rhgc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Zaite Íba ttu Samária elaka báy zaa forer. ");
INSERT INTO rhgc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Zaite-zaite Íba Samáriar Súkor nam or ekkán farat foóñicce, ziyán Yakube nizor fua Yusúf ore diíl de zobin or ḍáke. ");
INSERT INTO rhgc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Héṛe Yakub or faṭ-kuwa accíl. Isá áñiṭṭe-áñiṭṭe óran ói hé faṭ-kuwa war hañsat boiccé. Héñtte beil ṭík óiye. ");
INSERT INTO rhgc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ekgwá Samáriar mayafua héṛe faní tuiltó aiccé. Isá ye híba re hoór de, “Añré ek tirác faní háaba.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kiyólla-hoilé Íbar cárit tun cóor ot hána kinto giiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hétolla hé Samári mayafua ye Isá re hoór de, “Añí de ézzon Samári mayafua, Tuñí Yohúdi ói yore keéngori añr ttu faní magor?” Híba ye e hotá etollá hoiyé, kiyólla-hoilé Yohúdi ókkol lói Samári ókkol lói honó taalukat nái. ");
INSERT INTO rhgc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isá ye híba re zuwab der de, “Tui zodi Allar hádiya re edde tor ttu hone faní maiggé hoi faitti, tóoile tui Íba ttu faní magití, aar Íba ye toré zindigi dee de faní diito.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mayafua ye hoór de, “Ustat, Tuáñr ttu de faní tulí bolla honó tára nái, aar faṭ-kuwa toh mur. Tói Tuñí hé zindigir faní hoṛé faiyó? ");
INSERT INTO rhgc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tuñí añárar baf Yakub or túaro ḍoóñr níki, zibá ye añára re e faṭ-kuwa wa diiyé, aar íba nize, íbar fuain ókkole, edde íbar gorusól ókkole yibár faní háiye?” ");
INSERT INTO rhgc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isá ye híba re zuwabe hoór de, “Zee niki e faní háa, ítar ttu abar tirác lagibó, ");
INSERT INTO rhgc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","montor zee niki Añí dii de faní háa ítar ttu ar honódin tirác no lagibó, bólke Añí diiyum de hé faní ítar dil ot zónna ttu uṛé fángori uṛíbo, aar híine ítare ofúrani zindigi diibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mayafua ye Isá re hoór de, “Ustat, tóoile añré hé faní doo, zeéne añr ttu ar tirác no lage, aar eṛé faní lla yó aá no fore.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isá ye híba re hoór de “Tóoile zaa, tor hócom ore eṛé matai angói.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mayafua ye Isá re zuwabe hoór de, “Añr ttu de honó hócom nái.” Isá ye híba re hoór de, “Tui sóiyi hoiyós, tor ttu honó hócom nái. ");
INSERT INTO rhgc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kiyólla-hoilé tor ttu yaar age fañs swá hócom óigiyoi, aar ehón zee niki tor fúañti asé, íte yó tor hócom no. Tui sóiyi hoiyós.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mayafua ye hoór de, “Ustat, añí ehón zani faijjí, Tuñí ézzon nobi. ");
INSERT INTO rhgc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Zeén óibo óuk, añárar bafdada ókkole e faár gwar uore ebaadot goittó, montor tuáñra Yohúdi ókkole hoó de, manúc ókkol ottu Jerúsalem ot ebaadot gorár fóros.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isá ye hoór de, “Mayafua, Añr hotá biccác gór, eén októ aiyér, tuáñra Baf or ebaadot no e faár or uore goríba, aar no Jerúsalem ot goríba. ");
INSERT INTO rhgc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tuáñra zibá re no sinó íbar ebaadot goró deh; montor añára zibár ebaadot gorí íba re siní, kiyólla-hoilé nejat or mouka Yohúdir bútottu éna aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lekin eén októ aiyér, ehón óilde hé októ, zeñtté sóiyi ebaadotgár ókkole ruh edde sóiyi lói Baf or ebaadot goríbo, kiyólla-hoilé Bafe yó héndilla ebaadotgár or talac gorér. ");
INSERT INTO rhgc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Alla óilde Ruh, hétolla zetará Íbar ebaadot goré ítara ttu Íbar ebaadot ruh edde sóiyi lói gorár zorur.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mayafua ye hoór de, “Añí zani Mesáiya aiyér, yáni Mosih. Íba zeñtté aibó, añára re hárr kessú zanaidibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Isá ye híba re hoór de, “Añí óilam de Íba, zibá ye tor loi hotá hoóir.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hétunot Íbar cárit tun aiccé, aar Isá ye eggwá mayafua lloi hotá hoór de dekí ítara ammúk óigiyoi; montor toóu ítara honókiye fusár nó goré de ki, “Tuñí kii tuwoór?” yáh, “Tuñí kiyólla híba llói hotá hoór?” ");
INSERT INTO rhgc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Baade mayafua wa ye nizor fanír góra wa eri, farat zai manúc ókkol ore hoór de, ");
INSERT INTO rhgc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aiyó, tuáñra eggwá Manúc ore soógai, zibá ye añí añr zindigit ziín-ziín goijjí híin beggún añré hoiyé. Tóoile Íba hóno hé Mosih né?” ");
INSERT INTO rhgc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tói manúc ókkol fara ttu neeli Íbar héṛe aát doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Héñtte Íbar cárit tune Íba re aros gorí hoór de, “Rabbí, kessú hóona.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lekin Íba ye ítara re hoór de, “Añr ttu eén háibar hána asé, ziín or baabute tuáñra no zano.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hétunot Íbar cárit tune afós ot hoór de, “Honókiye hóno Íba re hána anídiye né?” ");
INSERT INTO rhgc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isá ye ítara re hoór de, “Zibá ye Añré difeṛáiye Íbar moncá edde ham fura gorón óilde Añr hána. ");
INSERT INTO rhgc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tuáñra kí endilla no hoó né, ki hoilé, ‘Aró sair mac asé, baade fósol haṛibár ainda aibó?’ Montor Añí tuáñra re hoóir, suk tulí bil or uzu soó, fósol ókkol haṛi bolla fagigiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Fósol haṛoya ókkole ehón óu muzuri faar, aar ofúrani zindigi lla fósol ókkol zoma gorí rakér, zeéne lagoya edde haṛoya duní zone mili kúci ó. ");
INSERT INTO rhgc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","E hotá sóiyi de ki, ‘Ezzone laga, ar ezzone haṛe.’ ");
INSERT INTO rhgc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Añí tuáñra re fósol uúin haṛitó difeṛáilam ziín olla tuáñra meénnot nó goró; oinno maincé meénnot goijjé, aar tuáñra ítarar hé meénnot or fósol haiṭṭó.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hé mayafuar e hotá fúni fara híyan or bicí Samári ókkole Isár uore iman ainné, ki hoilé, “Añí añr zindigit ziín-ziín goijjí híin beggún Íba ye añré hoiyé.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Zeñtté hé Samári ókkol Isár hañse aiccé, ítara Íba re ítarar fúañti tákito aros goijjíl, tói Íba héṛe dui din táikkil. ");
INSERT INTO rhgc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Íbar hotá fúni aró bicí maincé iman ainníl. ");
INSERT INTO rhgc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ítara mayafua wa re hoiyé de, “Ehón de añára tor hotár zoriya iman ainní de no, bólke añára nize Íbar hotá fúni zani faijjí de ki, Íba óilde Ubá zibá duniyair manúc or sóiyi Nejatdoya.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dui din baade Isá héntu rowana loi Galil ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Isá Nize age hoóil de, “Ze honó nobir izzot nizor wotón ot nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hétolla Íba zeñtté Galil ot aiccé, Galil or maincé Íba re kobul goijjé, kiyólla-hoilé Isá ye Jerúsalem ot Azadir-id ot ze ham ókkol goijjíl híin beggún ítara deikkíl, kiyólla-hoilé ítara yó hé id ot giíl. ");
INSERT INTO rhgc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Baade Íba abar Galil or Kána farat giiyé, zeṛé Íba ye faní re anggur or roc banaáil. Héṛe Kaparnahúm cóor ot ek cáap or fua ttu ocúk óiye. ");
INSERT INTO rhgc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Zeñtté yóggwa ye fúinne de ki, Isá Yohúdiya ttu Galil ot aáigiyoi, hétunot yóggwa Isár hañse zai aros gorér de, yóggwar fua wa re gom goittó aitó, kiyólla-hoilé fua wa moron-moron óoil. ");
INSERT INTO rhgc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Isá ye yóggwa re hoór de, “Tuáñra toh illayi-nicán edde keramot ókkol no dekíle bilkúl iman nu aníba.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Baáñccar cáape hoór de, “Ó Malik, añr fua wa moribár age aiyó!” ");
INSERT INTO rhgc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isá ye yóggwa re hoór de, “Zoogói; tuáñr fua basibó.” Baade manúc cwa ye Isár hotá ekin gorí giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yóggwa foñt ot táite, nizor hodún gulame aái hoór de, “Tuáñr fua gom óigiyoi!” ");
INSERT INTO rhgc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tói yóggwa ye fua hoñtté gom óiye de híyan ítara ttu hóbor lóiye. Ítara yóggwa re hoór de, “Gel de hailla din or eggwá báze ítar zor giiyói.” ");
INSERT INTO rhgc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hétunot bafe zani faijjé de, sóiyi oñtté fua wa gom óiye zeñtté Isá ye hoiyé de, “Tuáñr fua basibó.” Baade yóggwa edde yóggwar gór ṭíya ye Isár uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yián óilde Isár dui nombór or keramot, ziyán Íba ye Yohúdiya ttu neeli abar Galil ot aái goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yárbaade, Yohúdir ekkán id óiye, aar Isá uore Jerúsalem ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerúsalem or Bérasóol Geiṭ hoó de híyan or ḍáke eggwá foóir asé, zibá re Hibrú zuban ot Betésda hoó, hé foóir gwat fañs sán baanḍa asé. ");
INSERT INTO rhgc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Baanḍa híin ot bicí biyaraimma ókkol fori tákito, zendilla niki, añdá, leng, mazur. Ítara beggúne fanír lorasora re sooñi gorí tákito. ");
INSERT INTO rhgc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kiyólla-hoilé Allar ek fírista ṭaime-ṭaime hé foóir gwat lami aái faní laritó, aar faní lari baade zee niki age lami fare ítar ze honó biyaram gom óizaytoi. ");
INSERT INTO rhgc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Héṛe ézzon manúc accíl, zibá tiríc-añcṭo bosórja biyaraimma. ");
INSERT INTO rhgc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Isá ye zeñtté yóggwa re héṛe fori táikke de deikké, aar yóggwa bicí deri lóti hé hálot ot asé de zani faijjé, Íba ye yóggwa ttu fusár gorér de, “Tuáñr ttu gom óito monehoór ne?” ");
INSERT INTO rhgc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Biyaraimma wa ye Íba re zuwab der de, “Ustat, faní lare de októt añré dóri foóir ot lamaidi bolla añr ttu honókiye nái. Hétolla añí foóñsite-foóñsite añr agor ttu ar ezzon lamizagói.” ");
INSERT INTO rhgc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Isá ye yóggwa re hoór de, “Uṛó, tuáñr bisána tulí looi áñṛo.” ");
INSERT INTO rhgc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Baade éhon or bútore manúc cwa gom óigiyoi, aar nizor bisána tulí looi áñṛat doijje. Hé din accíl Yohúdir ebaadot-or-din. ");
INSERT INTO rhgc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Híyan olla ze manúc cwa re gom gorá gíyeh, yóggwa re Yohúdi ókkole hoór de, “Aijja toh ebaadot-or-din; aijja bisána tulí loizon Córiyot or maná.” ");
INSERT INTO rhgc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Montor yóggwa ye ítara re hoór de, “Zibá ye añré gom goijjé Íba ye añré hoiyé de, ‘Tuáñr bisána tulí looi áñṛo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ítara yóggwa ttu fusár gorér de, “Zee niki toré tor bisána tulí looi áñṛito hoiyé Manúc Íba hon?” ");
INSERT INTO rhgc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lekin ze manúc cwa re gom gorá gíyeh, yóggwa ye Íba hon hoi no fare, kiyólla-hoilé hé zagat bicí manúc accíl, aar Isá híyan ttu gaif óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yárbaade, Isá ye yóggwa re baitul-mukaddos ot loot fai hoór de, “Soó, tuñí gom óigiyogoi. Ar guná no goijjó, zeéne tuáñr hálot agor túaro hóraf no ó.” ");
INSERT INTO rhgc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Baade manúc cwa zai Yohúdi ókkol ore hoiyé de, yóggwa re gom goijjé de Íba óilde Isá. ");
INSERT INTO rhgc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hétolla bóuli Yohúdi ókkole Isá re zalat doijje, kiyólla-hoilé Íba ye ebaadot-or-din héndilla ham ókkol goittó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lekin Isá ye ítara re hoór de, “Añr Baf aijjó foijjonto ham gorát asé, aar Añí Nize yó gorír.” ");
INSERT INTO rhgc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Isár hé hotá lla bóuli Yohúdi ókkole Íba re marifélaito aró bicí kucíc gorát accíl, kiyólla-hoilé Íba ye siríf ebaadot-or-din or niyom báñgito de no, bólke Alla Íbar Baf hoói Nizoré Alla lloi fúainna yó goittó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tarfore Isá ye ítara re hoór de, “Añí tuáñra re sóiyi-sóiyi hoóir, Fua Nizorgá Nize kessú gorí no fare. Íba ye siríf uúin goré ziín Bafe goré de deké; kiyólla-hoilé Bafe ziín goré, Fua ye yó híin éna goré. ");
INSERT INTO rhgc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bafe Nizor Fua re muhábbot goré, aar Nize ziín goré híin beggún Fua re dahá. Íba ye híin or túaro ḍoóñr-ḍoóñr ham ókkol Fua re daháibo, zeéne híin dekí tuáñra taajup ó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bafe zendilla mora ókkol ore zinda goré, héndilla Fua ye yó zaré monehoó taré zinda goré. ");
INSERT INTO rhgc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aró hoitó sailé, Bafe honókiyor bisar no goré, bólke bisar or hárr zimma Fuar át ot gosáidiye, ");
INSERT INTO rhgc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","zeéne zendilla Baf ore beggúne izzot goré, héndilla Fua re yó izzot goré. Zee niki Fua re izzot no goré, íte Fua re difeṛáiye de hé Baf ore yó izzot no goré. ");
INSERT INTO rhgc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Añí tuáñra re sóiyi-sóiyi hoóir, zee niki Añr hotá fúne aar Añré difeṛáiye de Íbar uore iman ané, ítar ttu ofúrani zindigi asé. Ítar uore honó sáñzar hókum no óibo, bólke íte mora ttu zindigit faráigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Añí tuáñra re sóiyi-sóiyi hoóir, eén októ aiyér, bólke ehón aáigiyoi, zeñtté mora ókkole Allar Fuar abas fúnibo; aar zetará fúnibo ítara zinda óibo. ");
INSERT INTO rhgc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kiyólla-hoilé zendilla Baf Nize zindigir Malik, héndilla Íba ye Fua re yó zindigir Malik banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Íba ye Fua re bisar or adíkar diiyé, kiyólla-hoilé Íba óilde Manúc or Fua. ");
INSERT INTO rhgc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Híin fúni taajup no óiyo, kiyólla-hoilé eén októ aiyér, zetará hobor or bútore asé, ítara beggúne zeñtté Íbar abas fúnibo, ");
INSERT INTO rhgc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","héñtte neeliaibó; zetará gom ham goijjé, ítara zindigi fai bolla uṛíbo; aar zetará hóraf ham goijjé, ítara sáñza fai bolla uṛíbo. ");
INSERT INTO rhgc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Añí Nizorgá Nize kessú gorí no fari. Añí zendilla fúni héndilla beh bisar gorí; aar Añr bisar sóiyi, kiyólla-hoilé Añí Nizor moncá mozin goittó no saái, bólke Ubár moncá mozin goittó saái zibá ye Añré difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Añí zodi Nizor baabute Nize gobá díh, tóoile Añr gobá sóiyi no. ");
INSERT INTO rhgc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Montor ar ezzon asé, zibá ye Añr baabute gobá déh, aar Añí zani, Íba ye Añr baabute dede gobá sóiyi. ");
INSERT INTO rhgc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Tuáñra toh Yaháya ttu fusár goittó difeṛáila, aar yóggwa ye sóiyi gán gobá díye. ");
INSERT INTO rhgc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Becók, Añí honó manúc or gobár uore bóraca no gorí, lekin Añí iín etollá hoóir, zeéne tuáñra nejat fo. ");
INSERT INTO rhgc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaháya accíl serak waán, ziyáne zoli foór deh; aar tuáñra hooddin olla yóggwar foór ot kúci goittó razi óila. ");
INSERT INTO rhgc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Lekin Yaháyar gobár túaro ḍoóñr gobá Añr ttu asé; kiyólla-hoilé Añí toh ham uúin gorír ziín fura gorí bolla Bafe Añré diiyé, aar Añí gorí de ham híine Añr baabute gobá dé de ki, Añré Bafe difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hé Baf zibá ye Añré difeṛáiye, Íba Nize Añr baabute gobá díye. Tuáñra honódin no Íbar abas fúinno, aar no Íbar siyára-súrot deikkó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tuáñrar dil ot Íbar kalam no táke, kiyólla-hoilé tuáñra de Íba ye zibá re difeṛáiye Íbar uore iman nu anó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tuáñra toh pak-kalam or duara ofúrani zindigi faiba bouli ṭáari dilmon di pak-kalam tahákit goró, montor hé pak-kalame Añr baabute éna gobá déh. ");
INSERT INTO rhgc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Toóu tuáñra zindigi fai bolla Añr hañse aitó no soó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Añí insán ottu izzot faito no saái. ");
INSERT INTO rhgc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lekin Añí tuáñra re siní, ki hoilé, tuáñrar dil ot Alla lla muhábbot nái. ");
INSERT INTO rhgc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Añí Añr Baf or name aiccí, toóu tuáñra Añré kobul no goró; montor oinno kiyé zodi nizor name ailé, tuáñra ítare kobul goríba. ");
INSERT INTO rhgc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tuáñra zetará ezzone ar ezzon or hañsóttu izzot faito soó, montor ze izzot Allar hañsóttu faa zah híyan faito kucíc no goró, tuáñra keéngori iman aníba? ");
INSERT INTO rhgc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Tuáñra no ṭáaijjo de ki, Añí Baf or muúntu tuáñra re hosúr díyum. Tuáñra re zibá ye hosúr díbo íba óilde Muúsa, zibár uore tuáñrar bóraca raikkó. ");
INSERT INTO rhgc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tuáñra zodi Muúsa re biccác goittá, tuáñra Añré yó biccác goittá, kiyólla-hoilé íba ye Añr baabute éna leikké. ");
INSERT INTO rhgc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lekin tuáñra zettót íbar leká re biccác no goró, tói tuáñra Añr hotá keéngori biccác goríba?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yárbaade, Isá Galil Ḍiír okule giiyégoi, ze ḍií re Tibiriyas Ḍií yó hoó. ");
INSERT INTO rhgc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ḍoóñr ek dol manúc Íbar fisá doijjil, kiyólla-hoilé Íba ye biyaraimma ókkol or uore goittó de keramot ókkol ítara deikkíl. ");
INSERT INTO rhgc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Baade Isá eggwá faár or uore uṛí, héṛe Nizor cárit tun or fúañti boiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Héñtte Yohúdi ókkol or Azadir-id ḍáke aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Isá ye suk tulí saiyé rár dekér de, ḍoóñr ek dol manúc Íbar héṛe aiyér, hétunot Íba ye Filíp ore hoór de “E manúc itará hái bolla añára ruṭi hontú kiniyúm?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Filíp ore entán gorí bolla Íba ye híyan hoiyé deh, lekin Nize kii goríbo de híyan Íba ye age lóti zane. ");
INSERT INTO rhgc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filípe Íba re zuwab diyé de, “Itará beggún ore hom-hom gori diilé yo, toóu dui cót dinár or ruṭi loi no kulaibó.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Íbar cárit tun ottu ezzone, yáni Sáimon Fitor or bái Enderiyase Íba re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Eṛé eggwá fua ttu fañs swá barlír ruṭi edde duwá mas asé, montor edún maincóre iíne kii óibo?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Isá ye hoór de, “Manúc cún ore buágaro.” Hé zagat bicí kér accíl. Tói beṛaáin ítara boiccé, ítara tokoriban fañs ázar. ");
INSERT INTO rhgc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tarfore Isá ye ruṭi gún looi Alla re cúkuriya goijjé, aar zetará boói accíl ítara re baṛidiyé; héndilla góri Íba ye mas óu diiyé. Ítara ttu zedún monehoiyé hédun hái faijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ítara beggúne feṭ bóri hái baade, Íba ye Nizor cárit tun ore hoór de, “Ze tukuṛa ókkol basigiyói híin dola gorífelo, zeéne kessú borbad no zah.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tói maincé hái baade, barlír ruṭi fañsó wa ttu zedún basigiyói, híin dola gorí baró báñir bóijje. ");
INSERT INTO rhgc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Manúc cúne Isá ye goijjé de keramot tán dekí hoór de, “Sóiyi Ibá óilde Nobi Ubá zibá duniyait aibár hotá asé.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tói Isá ye zani faijjé de, manúc cúne Íba re bolazuri baáñcca banai bolla dóitto aitó sár, hétolla Íba ítara ttu alok ói gaaga abar faár or uore uiṭṭégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Baade zeñtté háñz óiye, Íbar cárit tun ḍiít giiyé, ");
INSERT INTO rhgc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","aar noow ot uṛí, Kaparnahúm ot zai bolla ḍií farát doijje. Héñtte andár óigiyoi, aar híyala úddwa Isá ítarar héṛe nú aiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ekgwá tez boiyar or zoriya, ḍiít goir ókkol cúru óiye. ");
INSERT INTO rhgc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ítara noow baái-baái tin sair mail ánik zai baade dekér de, Isá fanír uottú áñṛi-áñṛi noowr uzu aiyér; híyan dekí ítara ttu ḍoor laiggé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Montor Íba ye ítara re hoór de, “Ibá Añí; no ḍooraiyó.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tói ítara Íba re noow ot tulíto razi óiye, aar ítara zeṛé zaar noow gán éhon hé zagat foóñiccegoi. ");
INSERT INTO rhgc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ḍiír okule ze manúc ókkol táikkil, ítara tarfor din ót faiyé de, héṛe ekkán noow bade ar honó noow nái, aar Isá Nizor cárit tun or fúañti hé noow ot nó uṛé, bólke siríf Íbar cárit tun giiyé deh. ");
INSERT INTO rhgc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Montor kessú noow ókkol Tibiriyas cóor ottu zaga waán or ḍáke aiccé, ziyán ot Malik Isá ye cúkuriya gorí manúc ókkole ruṭi háail. ");
INSERT INTO rhgc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Zeñtté manúc ókkole Isá edde Íbar cárit tun hé zagat nái de deikké, ítara noow ókkol lói Isá re tuwai-tuwai Kaparnahúm ot foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aar zeñtté ítara Íba re ḍiír okule loot faiyé, ítara Íba ttu fusár gorér de, “Rabbí, Tuñí eṛé hoñtté aiccó?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isá ye ítara re zuwab der de, “Añí tuáñra re sóiyi-sóiyi hoóir, tuáñra Añr keramot ókkol dekí Añré tuwoór de no, bólke feṭ bóri ruṭi hái faijjó de hétolla tuwoór deh. ");
INSERT INTO rhgc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Borbad zagói de hána lla meénnot no goijjó, bólke ze hána ofúrani zindigi foijjonto ṭiki táke híin olla meénnot goró, ziín tuáñra re Manúc or Fua ye diibo; kiyólla-hoilé Íbar uore toh Alla Bafe Nizor moór lagaidiye.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tói ítara Íba ttu fusár gorér de, “Allar ham gorí bolla añára ttu kii gorá foribó?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isá ye ítara re zuwabe hoór de, “Alla ye Zibá re difeṛáiye, Íbar uore iman aná óilde Allar ham.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Baade ítara Íba ttu fusár gorér de, “Tóoile Tuñí kii illayi-nicán daháiba, zeéne añára dekí yore Tuáñr uore iman aní fari? Tuñí kii ham goríba? ");
INSERT INTO rhgc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Añárar bafdada ókkole de moidan zagat manná háiye. Pak-kalam ot endilla asé, ‘Ítara hái bolla Alla ye asman ottu ruṭi diiyé.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Isá ye ítara re hoór de, “Añí tuáñra re sóiyi-sóiyi hoóir, tuáñra re asman ottu ruṭi Muúsa ye diiyé de no, bólke Añr Bafe diiyé deh. Íba ye tuáñra re asman ottu sóiyi ruṭi dee. ");
INSERT INTO rhgc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kiyólla-hoilé Allar ruṭi óilde toh Ubá zibá ye asman ottu nise aái duniyair maincóre zindigi dee.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tói ítara Íba re hoór de, “Malik, hé ruṭi añára re hámica doo.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isá ye ítara re hoór de, “Hé zindigir ruṭi óilam de Añí. Zee niki Añr hañse aiyé, ítar ttu honódin búk no lagibó, aar zee niki Añr uore iman ané, ítar ttu honódin tirác no lagibó. ");
INSERT INTO rhgc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lekin Añí toh tuáñra re hoóifelaiyi, ki hoilé, tuáñra Añré deikkó, montor toóu iman nu anó. ");
INSERT INTO rhgc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Zedún ore Bafe Añr át ot dee, híin beggún Añr hañse aibó, aar zee niki Añr hañse aibó, Añí ítare honódin duñrai no diyum. ");
INSERT INTO rhgc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kiyólla-hoilé Añí toh asman ottu nise aiccí de Nizor moncá mozin gorí bolla no, bólke Ubár moncá mozin gorí bolla, zibá ye Añré difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Añré difeṛáiye de Íbar moncá óilde, zedún ore Íba ye Añr át ot diiyé, Añí zen héntu honókiyo re na hárai, bólke háñcor or din ítara re zinda gorí. ");
INSERT INTO rhgc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kiyólla-hoilé Añr Baf or moncá óilde, zee niki Fua re dekí Íbar uore iman ané, íte zen ofúrani zindigi faa. Aar Añí ítare háñcor or din zinda goríyum.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Híyan fúni Yohúdi ókkole Íbar baabute fuṛafuṛi gorát doijje, kiyólla-hoilé Íba ye hoiyé de, “Ze ruṭi asman ottu nise aiccé, yíba óilam de Añí.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ítara hoór de, “Ibá Yusúf or fua Isá no níki, zibár bafmaa re añára siní? Ibá ye keéngori hoór de, Añí asman ottu nise aiccí?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Isá ye ítara re zuwabe hoór de, “Afós ot fuṛafuṛi no goijjó. ");
INSERT INTO rhgc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Añr Baf zibá ye Añré difeṛáiye, Íba ye ṭani nu aníle honókiye Añr hañse aái no fare. Aar Añí ítare háñcor or din zinda goríyum. ");
INSERT INTO rhgc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nobi ókkol or kitab ot endilla leikká asé, ‘Ítara beggúne Alla ttu taalim faibo.’Hétolla zee niki Baf ottu fúni taalim faiyé, íte Añr hañse aiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hé Baf ore toh Allar hañsóttu aiccé de Íba ye bade ar honókiye nó deké. Siríf Íba ye deikké deh. ");
INSERT INTO rhgc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Añí tuáñra re sóiyi-sóiyi hoóir, zee niki Añr uore iman ané, yóggwa ttu ofúrani zindigi asé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Zindigir ruṭi óilam de Añí. ");
INSERT INTO rhgc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tuáñrar bafdada ókkole de moidan elakat manná háiye, toóu ítara morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Montor yibá óilde asman ottu nise aiccé de hé ruṭi, zeéne honókiye hái no more. ");
INSERT INTO rhgc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Añí óilam de asman ottu nise aiccé de zindigir ruṭi yíba. Zodi honókiye e ruṭi háa, íte hámica lla basi tákibo. Duniyair manúce zindigi fai bolla Añí diiyum de hé ruṭi óilde Añr gusso.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Híin fúni Yohúdi ókkole afós ot matamati di hoór de, “E Manúc cwa ye añára re keéngori Nizor gusso hái bolla diibo?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isá ye ítara re hoór de, “Añí tuáñra re sóiyi-sóiyi hoóir, zetún foijjonto tuáñra Manúc or Fuar gusso edde lou nó hóo, hétun foijjonto tuáñra ttu zindigi nái. ");
INSERT INTO rhgc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Zee niki Añr gusso edde lou háa, ítar ttu ofúrani zindigi asé, aar Añí ítare háñcor or din zinda goríyum. ");
INSERT INTO rhgc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kiyólla-hoilé Añr gusso óilde sóiyi hána, aar Añr lou óilde sóiyi fiíbar jiníc. ");
INSERT INTO rhgc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Zee niki Añr gusso edde lou háa, íte Añr bútore zari táke, aar Añí ítar bútore zari táki. ");
INSERT INTO rhgc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Zinda Bafe zendilla Añré difeṛáiye aar Añí Íbar zoriya zinda así, héndilla zee niki Añré háibo íte yó Añr zoriya zinda tákibo. ");
INSERT INTO rhgc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yíba óilde asman ottu nise aiccé de hé ruṭi. Tuáñrar bafdada ókkole hái morigiyói de héndilla ruṭi no. Zee niki e ruṭi háibo, íte hámica lla basi tákibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Isá ye hotá híin Kaparnahúm or mujilíc-hánat taalim dibarcót hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hé taalim fúni Isár ummot ókkol ottu boóut zone Íba re hoór de, “Yián toh ekkán bicí hora taalim, hone gosí faribó?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nizor ummot ókkole fuṛafuṛi gorér de híyan zani fari Isá ye ítara re hoór de, “E taalime ki tuáñra re bezar goijjé? ");
INSERT INTO rhgc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Manúc or Fua foóila zeṛé accíl, Íba zodi héṛe uṛérgoi de dekó, tóoile tuáñra kii báfiba? ");
INSERT INTO rhgc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruh ye éna zindigi dee; jisíme toh honó fáida no dee. Añí tuáñra re ze hotá gún hoiyí, híin óilde ruh edde zindigi. ");
INSERT INTO rhgc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Montor aijjó foijjonto tuáñra hodúne iman nú anó.” Isá ye foóila cúru ttu lóti zane, hontará iman nú ané aar hone Íba re dóridibo. ");
INSERT INTO rhgc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Isá ye aró hoór de, “Hétolla toh Añí tuáñra re endilla hoóilam, honókiye Añr hañse aái no faribó, zetún foijjonto Añr Bafe ítare toóufik no dee.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hé októt lóti Íbar boóut ummot ókkol fírigiyoi, aar Íbar fúañti solafíra gorá bon gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hétolla Isá ye baró zon cárit tun ottu fusár gorér de, “Tuáñra ttu yó kí zaitogói monehoór né?” ");
INSERT INTO rhgc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sáimon Fitore Íba re zuwab der de, “Ó Malik, añára har hañse zaitam? Ofúrani zindigir hotá Tuáñr ttu éna asé. ");
INSERT INTO rhgc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Añára iman ainní aar sóiyigori zani faijjí de, Tuñí óilade Allar Pakzon.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Isá ye ítara re hoór de, “Añí kí tuáñra baró zon ore basí nó looi né? Toóu tuáñrar bútore ezzon ibilíc asé.” ");
INSERT INTO rhgc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Híyan Isá ye Sáimon or fua Yohúdah Iskáriyet or baabute hoiyé deh. Kiyólla-hoilé íte baró zon cárit tun ottu óile yo, íte Isá re dóridibo. ");
INSERT INTO rhgc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yárbaade, Isá Galil ot solafíra gorér; kiyólla-hoilé Yohúdi ókkole Íba re marifélaibar kucíc ot accíl de hétolla Íba ttu Yohúdiyat solafíra goittó mone no hoór. ");
INSERT INTO rhgc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Héñtte Yohúdi ókkol or Bañcár-id or októ ḍáke aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hétolla Isár báiyain de Íba re hoór de, “Tuñí entú Yohúdiyat zoogói, zeéne Tuñí goró de ham ókkol Tuáñr ummot ókkole yó deké. ");
INSERT INTO rhgc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kiyólla-hoilé zee niki mocúr óito saá, íte toh lukai honó kessú no goré. Tuñí zettót e ham iín gorór, tói Nizoré duniyair hañse zahér goró.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Asóle Íbar báiyain de úddwa Íbar uore iman nú ané. ");
INSERT INTO rhgc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tói Isá ye ítara re hoór de, “Añí zaibar októ aijjó nú aiyé, montor tuáñra ze honó októt zai faribá. ");
INSERT INTO rhgc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Duniyair maincé tuáñra re nafórot gorí no fare, lekin Añré nafórot goré, kiyólla-hoilé Añí toh ítarar ham ókkol hóraf bóuli gobá díh. ");
INSERT INTO rhgc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tuáñra hé id ot zoo. Añí id híyan ot ehón no zaiyum, kiyólla-hoilé Añr októ aijjó furafuri nú aiyé.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ítara re híin hoói baade, Íba Galil ot táigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lekin Íbar báiyain ókkol id ot zaigói baade, Íba Nize yó giiyé; kúlamela góri nó, bólke lukai ore giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Id ot Yohúdi ókkole Íbar talac gorí-gorí fusár gorér de, “Íba hoṛé?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Manúc or ḍaái or bútore Íbar baabute suppe-suppe bicí fuṛafuṛi óiye. Hodúne hoór de, “Íba gom manúc.” Ar hodúne hoór de, “No, no, Íba ye maincóre gollot ot loizargói.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Montor toóu Yohúdi ókkol or ḍoore honókiye Íbar baabute kúlamela góri nó hoó. ");
INSERT INTO rhgc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Id ekdók ánik óiye rár, Isá uore baitul-mukaddos or uṛán ot zai taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aar Yohúdi ókkole taajup ói hoór de, “E Manúc cwa ye honó mikká ttu taalim hásil no gorí iín keéngori zane?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Isá ye ítara re zuwab der de, “Añí ziín taalim di híin Añr Nizor no, bólke Zibá ye Añré difeṛáiye Íbar. ");
INSERT INTO rhgc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Zar ttu Allar moncá mozin goittó monehoó, íte zanibó, e taalim iín kí Allar aar náki Añrgá Añí hoóir deh. ");
INSERT INTO rhgc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Zee niki nizor torfóttu hoó, íte nizor izzot tuwa. Lekin Zibá ye Difeṛóiyar izzot tuwa, Íba óilde sóiyi, aar Íbar bútore honó dúkabazi nái. ");
INSERT INTO rhgc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muúsa ye tuáñra re Córiyot diiyé de no né? Montor toóu de tuáñra honókiye hé Córiyot amól no goró. Tuáñra Añré kiyólla marifélai bolla soór?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Manúc ókkole zuwab der de, “Tuáñre búte faiyé. Tuáñre hone marifélaito sár dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isá ye ítara re zuwab der de, “Añí ekkán ham goijjí, aar tuáñra beggún taajup óigiyogoi. ");
INSERT INTO rhgc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muúsa ye tuáñra re ázomi gorí bolla hókum díye de hétolla, tuáñra toh ebaadot-or-din úddwa manúc ore ázomi goró. Háleke héndilla gorá Muúsa lóti cúru óiye de no, bólke bafdada gún ottu lóti. ");
INSERT INTO rhgc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Muúsar Córiyot no báñgi bolla zodi ebaadot-or-din manúc eggwá re ázomi gorá zah, tóoile ebaadot-or-din Añí eggwá manúc ore furafuri gom goijjí de hétolla kiyá tuáñra Añr lói guccá óiyo? ");
INSERT INTO rhgc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Uortú saái bisar no goijjó, insáf bisar goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hétunot Jerúsalem or kessú maincé hoór de, “Ibá kí Ubá no zibá re Yohúdi ókkole marifélaito sár? ");
INSERT INTO rhgc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lekin soó, Ibá ye toh kúlamela góri hotá hoór, toóu úddwa ítara Ibá re kessú no hoór. Hókumot-goróya ókkole hóno Ibá Mosih de híyan sóiyigori zani faijjé né? ");
INSERT INTO rhgc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Zeén óibo óuk, añára toh zani, Ibá hontú aiccé, montor zeñtté Mosih aibó, Íba hontú aiccé honókiye no zanibó.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Isá baitul-mukaddos ot taalim dibarcót guzori hoór de, “Ói, tuáñra Añré sinó, aar Añí hontú aiccí yó zano. Montor Añí Nizorgá Nize aiccí de no, Zibá ye Añré difeṛáiye Íba sóiyi. Tuáñra toh Íba re no sinó. ");
INSERT INTO rhgc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Lekin Añí Íba re siní, kiyólla-hoilé Añí Íbar torfóttu aiccí, Añré Íba ye difeṛáiye deh.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Híin fúni ítara Íba re gereftar gorí bolla saiyé, montor Íbar októ nú aiyé de hétolla honókiye Íbar uore át nó laga. ");
INSERT INTO rhgc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Toóu manúc or dol ottu boóut zone Íbar uore iman ainné. Ítara hoór de, “Mosih zeñtté aibó, Íba ye kí e manúc cwa ye goijjé de yár túaro bicí keramot ókkol daháibo?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Manúc or ḍaái ye Isár baabute fúcfucar de híyan Féroci ókkole fúinne. Hétolla ḍoóñr imam ókkole edde Féroci ókkole Íba re dóri aintó hodún faáradar difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Isá ye hoór de, “Añí tuáñrar fúañti ar bicí din nái, baade Añré difeṛáiye de Íbar hañse zaiyumbói. ");
INSERT INTO rhgc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tuáñra Añr talac goríba, montor Añré loot no faiba, aar zeṛé Añí tákiyum, héṛe tuáñra aái no faribá.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tói Yohúdi ókkole afós ot hoór de, “Ibá re añára tuwai no fai fán Ibá hoṛé zaito niyot gorér dé? Ze Beyohúdi ókkol or bútore añárar Yohúdi ókkol cíñṛaciñṭṭá óigiyoi, Ibá ye hóno héṛe zai hé Beyohúdi ókkol ore taalim dibo de né? ");
INSERT INTO rhgc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ibá ye e hotá lói kii hoitó sár deh, ‘Tuáñra Añr talac goríba, montor Añré loot no faiba,’ aar ‘Zeṛé Añí tákiyum, héṛe tuáñra aái no faribá?’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baade id or ahéri din or din, yáni id or ebbe ḍoóñr din ot, Isá tíyai yore guzori hoór de, “Zee niki tiráci asó, íte Añr hañse aái faní hóogai. ");
INSERT INTO rhgc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Zee niki Añr uore iman ané, pak-kalam mozin, ‘Ítar bútottu zindigi dee de faní uṛát tákibo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Isá ye híyan Pak-Ruhr baabute hoiyé de, zibá re zetará Isár uore iman ainné ítara fai zaybo. Pak-Ruh hétun foijjonto diiya nó zah, kiyólla-hoilé Isár mohíma hétun foijjonto zahér gorá nó zah. ");
INSERT INTO rhgc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Híin fúni baade kessú maincé hoór de, “Becók, Ibá óilde hé Nobi.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ar hodúne hoór de, “Ibá óilde Mosih.” Aró hodúne hoór de, “Mosih kí Galil ottu aibó né? ");
INSERT INTO rhgc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pak-kalam ot ki endilla nái, Mosih Dawud or nosól ottu edde Dawud táke de Betélhem fara ttu aibó bóuli?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Héndilla, Isár zoriya manúc ókkol or bútore faáṭa-faáṭi foida óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ítarar bútottu hodúne Íba re dóri bolla saiyé, montor honókiye Íbar uore át nó laga. ");
INSERT INTO rhgc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tarfore faáradar gún ḍoóñr imam edde Féroci ókkol or hañse waafes aiccé. Tará ítara ttu fusár gorér de, “Tuáñra Íba re nó kiyá anó?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Faáradar gúne zuwab der de, “Hé Manúc cwar ḍóilla góri honókiye honó októt hotá hoiyé de nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Féroci gúne hoór de, “Tuáñra re yó hóno gollot ot loigiyói né? ");
INSERT INTO rhgc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Honó sóddare yáh Féroci ye Íbar uore iman ainné de asé né? ");
INSERT INTO rhgc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Montor hé awam ókkole toh Córiyot no zane. Ítarar uore laánot asé.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hé Féroci gún or bútore Nikódemas óu asé, zibá yár age Isár hañse giíl. Yóggwa ye ítara ttu fusár gorér de, ");
INSERT INTO rhgc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Honó manúc or muk ottu nó fúinte aar íte kii goijjé de híyan nó zainte, ítar hosúr dóri bolla kí añárar Córiyot ot asé?” ");
INSERT INTO rhgc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ítara yóggwa re zuwabe hoór de, “Tuñí yó kí Galil or manúc? Pak-kalam tahákit gorí soó, Galil ottu honó nobi nú aiyé.” ");
INSERT INTO rhgc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Baade fottí zon zar-zar gór ot tee-tee giiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Montor Isá Zaitun Faár ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tarfor din biínna sóore Isá baitul-mukaddos ot abar aiccé, aar manúc beggún Íbar hañse zoma óiye. Baade Íba boói ítara re taalim diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Héñtte alem ókkole edde Féroci ókkole ek mayafua re Isár hañse ainné, zibá zená gorát dóra háiye. Baade híba re manúc ókkol or mazé tíyagaraiye. ");
INSERT INTO rhgc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tói ítara Isá re hoór de, “Úzur, e mayafua wa zená gorát dóra háiye. ");
INSERT INTO rhgc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Córiyot ot Muúsa ye añára re hókum díye de, endilla mayafuain dore cíl or dola mari marifélaito, montor Tuñí kii hoó?” ");
INSERT INTO rhgc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ítara Íba re hé súwal lan entán gorí bolla goijjé deh, zeéne ítara Íba re elzam dibar mouka faa. Montor Isá uñri boói ooñle meṛit lekát accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ítara zettót Íba ttu warawori fusár gorát asé, Íba uṛí ítara re hoór de, “Tuáñrar bútore zee niki guná sára asó, mayafua wa re cíl or dola íte age maro.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Baade Isá abar uñri boói meṛit lekát accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hé hotá fúni, ítara burá ttu lóti cúru gorí zon-zon neeligiyói, montor Isá ezzon táigiyoi, mayafua wa yó mazé tíyai accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Isá uṛí zeñtté mayafua wa bade ar honókiyo re nó deké, Isá ye híba re hoór de, “Mayafua, uitará hoṛé? Honókiye tor hosúri nó dóre níki?” ");
INSERT INTO rhgc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Híba ye hoór de, “Malik, honókiye nó dóre.” Isá ye hoór de, “Añí yó tor hosúri no dóri. Zaa, guná no goríc.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isá ye ítara re abar hoór de, “Añí óilam de duniyair Nur, zee niki Añr fisá dore, íte andár ot nu áñṛibo, bólke zindigir Nur faibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hétolla Féroci ókkole Íba re hoór de, “Tuñí toh Nizor gobá Nize éna dor; Tuáñr gobá sóiyi no.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isá ye ítara re zuwabe hoór de, “Añí Nizor gobá Nize dilé yo, Añr gobá sóiyi, kiyólla-hoilé Añí hontú aiccí edde hoṛé zairgói Añí zani. Montor Añí hontú aiccí aar hoṛé zairgói híyan tuáñra no zano. ");
INSERT INTO rhgc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tuáñra toh insán or niyom mozin bisar goró, montor Añí honókiyor bisar no gorí. ");
INSERT INTO rhgc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Añí zodi bisar gorí yo, Añr bisar hók, kiyólla-hoilé Añí ekéla no, Añré difeṛáiye de hé Baf Añr fúañti asé. ");
INSERT INTO rhgc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tuáñrar Córiyot ot óu leikká asé de ki, dui zone ek ḍoilla gobá dé de óile hé gobá sóiyi. ");
INSERT INTO rhgc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Añr baabute Añí Nize yó gobá díh, aar Añr baabute Añré difeṛáiye de hé Bafe yó gobá déh.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hétunot ítara Íba ttu fusár gorér de, “Tuáñr Baf hoṛé?” Isá ye ítara re zuwab der de, “Tuáñra no Añré sinó, aar no Añr Baf ore sinó. Tuáñra zodi Añré siníta, tóoile Añr Baf ore yó siníta.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isá ye hotá híin baitul-mukaddos or uṛán ot dan-baccúr ḍáke taalim dibarcót beh hoiyé. Toóu honókiye Íba re gereftar nó goré, kiyólla-hoilé Íbar októ aijjó nú aiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Isá ye ítara re abar hoór de, “Añí toh zairgói; tuáñra Añr talac goríba, aar nizor gunát nize moribá. Añí zeṛé zairgói héṛe tuáñra aái no faribá.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hétolla Yohúdi ókkole hoór de, “Íba ye hóno nizoré marifélaibo né? Kiyólla-hoilé Íba ye hoiyé de, ‘Añí zeṛé zairgói héṛe tuáñra aái no faribá.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Isá ye aró hoór de, “Tuáñra nisor ttu, aar Añí uottú. Tuáñra e duniyair; Añí toh e duniyair no. ");
INSERT INTO rhgc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hétolla Añí tuáñra re hoiyí de, tuáñra nizor gunát nize moribá. Tuáñra zodi Añí Íba de biccác no goró, tóoile nizor gunát nize moribá.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tói ítara Íba ttu fusár gorér de, “Tuñí hon?” Isá ye ítara re zuwab der de, “Añí óilam de Ubá zibár baabute Añí foóila cúrut lóti tuáñra re hoói-hoói aiyír. ");
INSERT INTO rhgc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tuáñrar baabute hoibár edde bisar goríbar Añr ttu boóut kessú asé, lekin Zibá ye Añré difeṛáiye Íba sóiyi. Añí duniyai re siríf uúin hoói ziín Íbar torfóttu fúinni.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Isá ye ítara re Baf or baabute hoór de híyan ítara nó buzé. ");
INSERT INTO rhgc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hétolla Isá ye ítara re hoór de, “Tuáñra Manúc or Fua re zeñtté uore tulíba, héñtte zanibá de, Añí óilam de Íba, aar Añí Nizorgá Nize kessú no gorí, bólke Añí uúin beh hoói ziín Bafe Añré cíkaiye. ");
INSERT INTO rhgc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Zibá ye Añré difeṛáiye Íba Añr fúañti asé. Íba ye Añré ekéla nó ere, kiyólla-hoilé Añí toh hámica ham uúin gorí ziín lói Íba kúci ó.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Isár hotá híin fúni boóut zone Íbar uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ze Yohúdi ókkole Isár uore iman ainné, ítara re Íba ye hoór de, “Zodi tuáñra Añr hotát lagi táko, tóoile sóiyi tuáñra Añr ummot, ");
INSERT INTO rhgc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","baade tuáñra sóiyi re zanibá, aar hé sóiyi ye tuáñra re azad goríbo.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ítara Íba re hoór de, “Añára óilam de Ibrahím or nosól, añára honódin honókiyor gulam óiyi de nái. Tói Tuñí keéngori hoór de, ‘Tuáñra azad faiba?’” ");
INSERT INTO rhgc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isá ye ítara re zuwab der de, “Añí tuáñra re sóiyi-sóiyi hoóir, zetará guná gorát táke ítara gunár gulam. ");
INSERT INTO rhgc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gulam toh gór ot abadulabad no táke, bólke fua beh abadulabad táke. ");
INSERT INTO rhgc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hétolla Fua ye zodi tuáñra re azad goré, tuáñra hámaha azad óiba. ");
INSERT INTO rhgc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Añí zani, tuáñra Ibrahím or nosól, toóu tuáñra Añré marifélaito soór, kiyólla-hoilé tuáñrar dil ot toh Añr hotá lla honó zaga nái. ");
INSERT INTO rhgc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Añí uúin hoói ziín Añí Añr Baf or hañse deikkí, aar tuáñra uúin goró ziín tuáñra tuáñrar baf ottu fúinno.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ítara Íba re zuwabe hoór de, “Añárar baf óilde Ibrahím.” Isá ye ítara re hoór de, “Tuáñra Ibrahím or fuain óita bóuli, tuáñra Ibrahím or ḍóilla ham goittá. ");
INSERT INTO rhgc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Añí toh Alla ttu ze sóiyi gán fúinni, híyan éna tuáñra re hoiyí, aar toóu tuáñra Añré marifélaito soór. Ibrahíme de héndilla nó goré. ");
INSERT INTO rhgc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tuáñra tuáñrar baf or gún gorór deh.” Ítara Íba re hoór de, “Añára toh zoura fuain no; añára ttu Baf ekgwá asé deh, Íba óilde Alla.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isá ye ítara re hoór de, “Sóiyi zodi Alla tuáñrar Baf óito, tuáñra Añré muhábbot goittá, kiyólla-hoilé Añí toh eṛé Allar torfóttu éna aiccí. Añí Nizorgá Nize aiccí de no, bólke Añré Íba ye beh difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tuáñra Añr hotá kiyá no buzór? Híyan etollá, kiyólla-hoilé tuáñra Añr hotá re bordac gorí no faroór. ");
INSERT INTO rhgc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tuáñra tuáñrar baf Ibilíc or, hétolla tuáñra ítar moncá ókkol fura goittó soó. Íte toh foóila cúru ttu lóti kúni, aar honódin sóiyit no táke, kiyólla-hoilé ítar bútore honó sóiyi nái. Íte zeñtté misá hotá hoó, nizor bútottu hoó, kiyólla-hoilé íte óilde misákur aar misár baf. ");
INSERT INTO rhgc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Lekin Añí toh hók hotá hoói, hétolla tuáñra Añré biccác no goró. ");
INSERT INTO rhgc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tuáñra ttu hone Añí gunágar bóuli sábut gorí faribá? Zodi Añí sóiyi hotá hoóir de óile, tuáñra Añré biccác kiyá no goró? ");
INSERT INTO rhgc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ze manúc Allar, íte Allar hotá fúne. Tuáñra híin etollá no fúno, kiyólla-hoilé tuáñra Allar no.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yohúdi ókkole Íba re zuwabe hoór de, “Añára kí sóiyi nó hoói né, Tuñí ézzon Samári, aar Tuáñre búte faiyé?” ");
INSERT INTO rhgc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isá ye zuwab der de, “Añré búte nó faa. Añí Añr Baf ore izzot gorí, montor tuáñra Añré beizzoti goró. ");
INSERT INTO rhgc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Añí Añr izzot tuwair de no. Lekin Ekzon asé zibá ye Añr izzot or kíyal raké aar Íba óilde bisarhar. ");
INSERT INTO rhgc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Añí tuáñra re sóiyi-sóiyi hoóir, zee niki Añr hotá amól goré, íte honódin no moribó.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yohúdi ókkole Íba re hoór de, “Ehón añára fakkagori zani faijjí, Tuáñre búte faiyé. Ibrahím edde nobi ókkol toh morigiyói, toóu Tuñí hoór de, ‘Zee niki Añr hotá amól goré, íte honódin no moribó.’ ");
INSERT INTO rhgc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tuñí kí añárar baf Ibrahím or túaro ḍoóñr? Íba toh morigiyói, aar nobi ókkol óu morigiyói. Tuñí Nizoré Nize kii bouli ṭáaro?” ");
INSERT INTO rhgc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isá ye ítara re zuwab der de, “Zodi Añí Nizor taarif Nize gorí, tóoile Añr taarif or honó dam nái. Añré izzot Añr Bafe éna goré, Zibá re tuáñra tuáñrar Alla bouli dabi goró. ");
INSERT INTO rhgc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tuáñra Íba re no sinó, lekin Añí Íba re siní. Zodi Añí hoói, ‘Añí Íba re no siní,’ tóoile Añí yó toh tuáñrar ḍóilla misákur ṭóoriyum, lekin Añí Íba re siní, aar Íbar hotá amól gorí. ");
INSERT INTO rhgc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tuáñrar baf Ibrahíme Añr din dekíbar acáye kúci goijjíl. Íba ye deikkíl aar kúci óoil.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tói Yohúdi ókkole Íba re hoór de, “Tuáñr boc toh aijjó fonzaic bosór úddwa nó óiyo, aar Tuñí Ibrahím ore deikkó dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isá ye ítara re hoór de, “Añí tuáñra re sóiyi-sóiyi hoóir, Ibrahím zormo óibar age lóti Añí así.” ");
INSERT INTO rhgc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hé hotá fúni ítara Íba re mari bolla cíl or dola feñṛai loiyé, montor Isá Nizoré argwal gorí baitul-mukaddos ottu neeligiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Isá rasta báy zaite-zaite, Íba ye eggwá manúc deikké, zibá zormo ttu lóti añdá. ");
INSERT INTO rhgc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Íbar cárit tune Íba ttu fusár gorér de, “Rabbí, har gunár zoriya e manúc cwa zormo ttu lóti añdá óiye dé? Ki nizor aar náki yóggwar bafmaar?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isá ye zuwab der de, “Héndilla no e manúc cwar gunár zoriya óiye, aar no yoggwár bafmaar gunár zoriya óiye, bólke etollá óiye, zeéne yoggwár zindigit Allar ham zahér ó. ");
INSERT INTO rhgc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Din tákite añára ttu Ubár ham gorífela foribó zibá ye Añré difeṛáiye. Rait aiyér zeñtté honókiye ham gorí no faribó. ");
INSERT INTO rhgc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Zetó din Añí duniyait así, Añí óilam de duniyair Nur.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Híin hoói baade, Íba ye meṛit sép félai yore fúñṭ banaiyé, aar hé fúñṭ looi añdá manúc cwar suk ot bóraidiye. ");
INSERT INTO rhgc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Baade yóggwa re hoór de, “Zoo, zai Sílom foóir gwá ttu dúifelogoi” (Sílom or torjuma óilde, “Difeṛáiye”). Tói yóggwa zai dúifelaiye, baade suké dekí waafes fíri aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hétolla yóggwar atehañsór manúc ókkole edde age zetará yóggwa re hórat magitó de deikkíl ítara hoór de, “Manúc ibá ubá no né zibá ye boói-boói hórat magitó?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Hodúne hoór de, “Ói, e manúc cwa yóggwa.” Ar hodúne hoór de, “No, montor ite yóggwar ḍóilla deh.” Lekin yóggwa ye, “Añí íba,” bóuli howát accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ítara yóggwa ttu fusár gorér de, “Tóoile tuáñr suk keéngori kúligiyoi?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yóggwa ye zuwab der de, “Isá hoó de Manúc cwa ye meṛi re fúñṭ banai añr suk ot bóraidiye, aar añré hoiyé de, ‘Zai Sílom foóir gwá ttu dúifelogoi.’ Añí zai dúifelaiyi rár suké dekí farir.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ítara yóggwa ttu fusár gorér de, “Hé Manúc cwa hoṛé?” Yóggwa ye zuwab der de, “Añí hoi no fari.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Baade ítara añdá accíl de manúc cwa re Féroci ókkol or hañse loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ze din Isá ye meṛi re fúñṭ banai yóggwar suk kúillil, hé din accíl ebaadot-or-din. ");
INSERT INTO rhgc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hétolla bóuli yóggwar suk keéngori gom óiye de híyan Féroci ókkole yóggwa ttu abar fusár goijjé. Yóggwa ye ítara re hoór de, “Íba ye añr suk ot fúñṭ bóraidiye, baade añí dúiyi rár dekí faijjí.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hétolla hodún Féroci ye hoór de, “Hé Manúc cwa Allar torfóttu no, kiyólla-hoilé Íba ye ebaadot-or-din no mane.” Montor ar hodúne hoór de, “Ezzon gunágar manúce keéngori endilla keramot gorí fare?” Héndilla ítarar bútore faáṭa-faáṭi foida óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hétunot ítara añdá accíl de manúc cwa re abar hoór de, “Íba ye tor suk kúille de híyan olla tui Íbar baabute kii hoós?” Yóggwa ye zuwab der de, “Íba eggwá nobi.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lekin yóggwa age añdá accíl aar ehón dekí farer de híyan yóggwar bafmaa re matai fusár nó loh foijjonto Yohúdi ítara biccác nó goré. ");
INSERT INTO rhgc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ítara yóggwar bafmaa ttu fusár gorér de, “Ibá tuáñrar fua ubá né, zibá re tuáñra zormo ttu lóti añdá hoóila? Héen óile yala ite keéngori dekí farer?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yóggwar bafmaa ye ítara re zuwabe hoór de, “Añára zani ibá añárar fua, aar ite añdá zormo óoil; ");
INSERT INTO rhgc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Montor yala ite keéngori dekí farer añára no zani; itar suk hone kúille yó añára no zani. Itar ttu boc óiye, tuáñra itar ttu fusár goró. Ite nizor baabute tuáñra re hoibó.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yóggwar bafmaa ye héndilla hoóil de Yohúdi ókkol or ḍoore, kiyólla-hoilé Yohúdi ókkole age lóti fáisela goijjíl de, zee niki Isá re Mosih bóuli cíkar goré, ítare ítarar mujilíc-hána ttu neelaidiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Híyan olla bóuli yóggwar bafmaa ye hoóil de, “Itar ttu boc óiye; tuáñra itar ttu fusár goró.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hétolla ítara age añdá accíl de manúc cwa re abar matai hoór de, “Hók hotá hoói Allar taarif gor. Añára zani hé Manúc cwa ézzon gunágar.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yóggwa ye zuwab der de, “Íba gunágar ói ne no añí no zani. Lekin añí yián ekkán zani, añí age añdá accílam aar yala suké dekír.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ítara yóggwa ttu fusár gorér de, “Íba ye toré kii goijjé? Íba ye tor suk keéngori kúlidiye?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yóggwa ye zuwab der de, “Añí tuáñra re hoóifelaiyi, montor tuáñra toh nó fúno. Tuáñra ttu híyan abar kiyá fúinto monehoór? Tuáñra ttu yó hóno Íbar ummot óito monehoór?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Baade ítara gail di yóggwa re hoór de, “Tui Manúc Íbar ummot, lekin añára de Muúsar ummot. ");
INSERT INTO rhgc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Añára zani Alla ye Muúsa llói hotá hoiyé, montor hé Manúc cwa hontú aiccé híyan toh añára no zani.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hétunot manúc cwa ye ítara re zuwabe hoór de, “Ki taajuippa hotá! Tuáñra Íba hontú aiccé no zano, aar toóu Íba ye añr suk kúlidiye. ");
INSERT INTO rhgc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Añára zani Alla ye gunágar ókkol or hotá no fúne, montor Íba ye ubár hotá fúne zee niki Íbar ebaadotgár edde Íbar moncá mozin goré. ");
INSERT INTO rhgc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Honókiye ezzon zormo ttu lóti añdá óiye de manúc or suk kúlidiye de toh duniyai cúru óiye lóti honódin fúna nó zah. ");
INSERT INTO rhgc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Zodi hé Manúc cwa Allar torfóttu no de óito, Íba ye toh kessú gorí no faitto.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ítara yóggwa re zuwab der de, “Tui toh furafuri gunát zormo óiyos, aar tui añára re cíkka dor dé?” Héndilla hoói ítara yóggwa re mujilíc-hána ttu neelaidiye. ");
INSERT INTO rhgc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ítara yóggwa re neelaidiye de híyan Isá ye fúinne. Íba ye yóggwa re loot fai hoór de, “Tuñí Manúc or Fuar uore iman ainnó né?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yóggwa ye zuwab der de, “Ustat, Íba hon añré hoó, zeéne añí Íbar uore iman aní fari.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isá ye yóggwa re hoór de, “Tuñí Íba re deikkó; tuáñr llói hotá hoór de Yóggwa óilde Íba.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Baade yóggwa ye hoór de, “Malik, añí iman ainní.” Héndilla hoói yóggwa ye Íba re sóida goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isá ye hoór de, “Añí e duniyait bisar gorí bolla aiccí deh, zeéne zetará no deké ítara dekí fare, aar zetará deké ítara añdá óizagoi.” ");
INSERT INTO rhgc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Isár fúañti accíl de hodún Féroci ye híin fúni Íba re hoór de, “Tóoile añára yó añdá niki?” ");
INSERT INTO rhgc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isá ye ítara re hoór de, “Zodi tuáñra añdá óita, tuáñra ttu honó guná no tákito; montor tuáñra zettót hoór, ‘Añára dekí,’ hétolla tuáñrar guná táizagoi.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Añí tuáñra re sóiyi-sóiyi hoóir, zee niki bérasóol or añrail ot duwar báy no góle, montor oinno boli farái góle, íte sur edde ḍahañit. ");
INSERT INTO rhgc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lekin zee niki duwar báy góle, yóggwa óilde bérasóol soroya. ");
INSERT INTO rhgc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yóggwa re duwar sooñidare duwar kúlide, aar bérasóol ókkole yóggwar abas fúne. Yóggwa ye nizor bérasóol ókkol ore nam dori-dori matai baáre ané. ");
INSERT INTO rhgc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Zeñtté yóggwa ttu nizor bérasóol beggún ore baáre ainná ó, yóggwa híin or age-age zaa, aar bérasóol híin yóggwar fisé-fisé aiyé, kiyólla-hoilé yóggwar abas híine siné. ");
INSERT INTO rhgc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Montor híin osin manúc or fisé-fisé bilkúl no zaibo, bólke ítar ttu dáizayboi, kiyólla-hoilé híine osin manúc or abas no siné.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isá ye ítara re e meésal lan hoiyé, montor Íba ye ítara re kii hoitó sár de híyan ítara nó buzé. ");
INSERT INTO rhgc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hétolla Isá ye ítara re abar hoór de, “Añí tuáñra re sóiyi-sóiyi hoóir, bérasóol lun or duwar óilam de Añí. ");
INSERT INTO rhgc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Añr age zetará aiccíl ítara beggún sur edde ḍahañit, montor bérasóol lune ítarar hotá nó fúne. ");
INSERT INTO rhgc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Añí óilam de duwar. Zee niki Añr dí bútore góle, íte nejat faibo. Íte bútore aibó edde baáre zaibo, aar soribár zaga faibo. ");
INSERT INTO rhgc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sur toh siríf suri, kún edde dónco gorí bolla éna aiyé. Lekin Añí aiccí de, zeéne ítara zindigi faa aar hé zindigi zen ítara ttu furafuri gori táke.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Gom bérasóol soroya óilam de Añí. Gom soroya ye toh bérasóol ókkol olla Nizor zan deh. ");
INSERT INTO rhgc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Montor zee niki muzur, íte asól soroya no, íte bérasóol or girós óu no. Íte rangkuñir aiyér de dekíle bérasóol félai dáizagoi, tói rangkuñir aái bérasóol lun ore dóri cíñṛaciñṭṭá gorífele. ");
INSERT INTO rhgc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Íte etollá dáizagoi, kiyólla-hoilé íte óilde muzur, aar ítar ttu bérasóol or baabute honó sintabáfana nái. ");
INSERT INTO rhgc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Gom bérasóol soroya óilam de Añí. Añí Añr bérasóol ókkol ore siní, aar híine yó Añré siné, ");
INSERT INTO rhgc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","zendilla Bafe Añré siné aar Añí Baf ore siní. Añí Añr bérasóol ókkol olla Nizor zan dih. ");
INSERT INTO rhgc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Añr ttu aró hodún bérasóol asé, ziín e zák ot nái. Añr ttu híin ore yó loianá foribó, aar híine yó Añr abas fúnibo. Tói eggwá zák óibo edde eggwá soroya óibo. ");
INSERT INTO rhgc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Bafe Añré etollá muhábbot goré, kiyólla-hoilé Añí Añr zan dih, zeéne híyan abar loifélai fari. ");
INSERT INTO rhgc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Honókiye híyan Añr ttu loiféla de no, bólke Añí Nize híyan di deh. Añr ttu híyan dibar óu kémota asé, aar Añr ttu híyan abar waafes loibar óu kémota asé. Héndilla goríbar hókum híyan Añí faiyí de óilde Añr Baf or torfóttu.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hotá híin or zoriya Yohúdi ókkol or bútore abar faáṭa-faáṭi foida óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ítara boóut zone hoór de, “Ibá re búte faiyé, Ibá fool. Tuáñra Ibár hotá kiyá fúnor?” ");
INSERT INTO rhgc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ar hodúne hoór de, “Montor e hotá gún toh eggwá búte-faiya manúc or hotár ḍóilla no. Búte añdár suk kúlidi fare nikí?” ");
INSERT INTO rhgc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yárbaade Jerúsalem ot Hanúka-id óiye. Héñtte cítkhal accíl, ");
INSERT INTO rhgc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","aar Isá baitul-mukaddos or bútore Sóloman or baanḍat ṭoólat accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yohúdi ókkole Íba re sairó ḍák ottu gíridori hoór de, “Tuñí añára re ar hotódin andacát rakíba? Tuñí zodi Mosih de óile, añára re sáf-sáf góri hoó.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isá ye ítara re zuwab der de, “Añí tuáñra re hoiyí, montor tuáñra toh biccác no goró. Ze ham ókkol Añí Añr Baf or name gorí, híine Añr gobá déh. ");
INSERT INTO rhgc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lekin tuáñra etollá biccác no goró, kiyólla-hoilé tuáñra Añr bérasóol lun ottu no. ");
INSERT INTO rhgc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Añr bérasóol ókkole Añr abas fúne, Añí híin ore siní, aar híin Añr fisé-fisé aiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Añí híin ore ofúrani zindigi dii; híin honódin dónco no óibo; aró Añr át ottu híin ore honókiye haríloifelai no faribó. ");
INSERT INTO rhgc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kiyólla-hoilé Añr Baf, zibá ye híin ore Añré diiyé, Íba beggún or túaro ḍoóñr. Honókiye Añr Baf or át ottu híin ore haríloifelai no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Añí edde Baf ek.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Híyan fúni Yohúdi ókkole Íba re maitto abar cíl or dola feñṛai loiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Montor Isá ye ítara re hoór de, “Añí de Baf or torfóttu tuáñra re boóut gom-gom ham ókkol daháiyi. Híin ottu hon nán olla bóuli tuáñra Añré cíl or dola maitto soór dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yohúdi ókkole zuwab der de, “Gom ham olla bóuli añára Tuáñre cíl or dola marir de no, bólke kuféri goijjó de hétolla. Tuñí manúc ói Nizoré Nize Alla dabi gorór.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isá ye ítara re hoór de, “Tuáñrar Córiyot ot leikká asé de no né, Alla ye endilla hoiyé de, ‘Tuáñra óilade kúda’? ");
INSERT INTO rhgc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Zetarár hañse Allar torfóttu kalam aiccé, ítara re toh kúda bóuli howá gíyeh. Pak-kalam or hotá toh bad di no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Baf Nize éna Añré basíloiye edde duniyait difeṛáiye. Añí zettót hoiyí, ‘Añí Allar Fua,’ tói tuáñra keéngori hoór de, ‘Tuñí Allar kuféri goijjó?’ ");
INSERT INTO rhgc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Zodi Añí Añr Baf or ham ókkol no gorí, tóoile Añré biccác no goijjó; ");
INSERT INTO rhgc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","lekin zodi híin gorí, tuáñra Añré biccác no goillé yo, ham híin ore biccác goró, zeéne tuáñra zano edde buzó de, Baf Añr bútore asé aar Añí Baf or bútore así.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hétunot Yohúdi ókkole abar Isá re gereftar goittó kucíc goijjíl, montor Íba ítarar át ottu hárigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tarfore Isá abar Jordán hál or farkule zai táikkegoi, zeṛé age Yaháya ye bápṭisma díto. ");
INSERT INTO rhgc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Boóut manúc ókkol Íbar hañse aiccíl; ítara hoitó de, “Yaháya ye honó keramot nó goré, montor toóu Yaháya ye e Manúc cwar baabute ziín-ziín hoóil híin beggún sóiyi.” ");
INSERT INTO rhgc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Héṛe boóut zone Isár uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lasár nam or ézzon manúc ocúk accíl. Yóggwa óilde Betániya farar, ziyán ot yóggwar bóin Moriyam edde Morota yó tákito. ");
INSERT INTO rhgc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hé Moriyam óilde ubá zibá ye Malik or ṭéng ot añtor ḍálidi nizor sul loi fuñsídil. Ze Lasár ocúk accíl, yóggwa óilde híbar bái. ");
INSERT INTO rhgc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hétolla yóggwar bóinain de Isár hañse hotá foóñsaiye de, “Malik, Tuñí zaré ador goró, yóggwa ttu ocúk óiye.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Híyan fúinne rár Isá ye hoór de, “Hé ocúk yóggwar moot olla óiye de no, bólke Allar mohíma lla óiye de, zeéne híyan or zoriya Allar Fuar mohíma zahér ó.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Isá ye Morota re, híbar bóin ore, edde Lasár ore ador goittó. ");
INSERT INTO rhgc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Toóu Íba ye yóggwa ocúk de fúni, Íba ze zagat accíl héṛe aró dui din táikkil. ");
INSERT INTO rhgc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Baade Íba ye cárit tun ore hoór de, “Aiyó, añára abar Yohúdiyat zai.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Cárit tune Íba re hoór de, “Rabbí, yaar hooddin age toh Yohúdi ókkole Tuáñre cíl or dola maitto saáil, toóu Tuñí héṛe abar zaito soór dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isá ye zuwab der de, “Din ot ki baró gónḍa nái ne? Honókiye zodi din ot áñṛe, íte ujáṭ na há, kiyólla-hoilé íte toh duniyair foór deké. ");
INSERT INTO rhgc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Montor honókiye zodi rait ot áñṛe, íte ujáṭ há, kiyólla-hoilé ítar bútore foór nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Híin hoói baade, Íba ye ítara re hoór de, “Añárar dustó Lasár gúm ot foijjé, montor Añí yóggwa re tulídito zair.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tói cárit tune Íba re hoór de, “Malik, yóggwa gúm ot foijjé de óile, yóggwa ṭík óizayboi.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Háleke Isá ye hoiyé de óilde yóggwar moot or baabute, montor ítara ṭáaijjil de endilla gúm or hotá hoiyé bóuli. ");
INSERT INTO rhgc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hétolla Isá ye ítara re sáf-sáf góri eén hoóifelaiye, “Lasár morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Añí héṛe nu accílam de híyan olla tuáñrar zoriya kúci, zeéne tuáñra ekin gorí faro. Aiyó, añára yóggwar héṛe zai.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hétunot Tómas, zibá re Zooñikka hoói ḍake, yóggwa ye nizor sáañti cárit tun ore hoór de, “Áñṛo, añára yó zai, zeéne añára Íbar fúañti mori fari.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Baade Isá zeñtté héṛe foóñicce, Íba ye zani faijjé de, Lasár ore hobor ot diyé de sair din óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betániya gán Jerúsalem or ḍáke accíl, siríf dui mail ánik duré deh. ");
INSERT INTO rhgc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bicí Yohúdi ókkol Morota edde Moriyam or héṛe aiccíl, ítara re ítarar bái or baabute tosólli dí bolla. ");
INSERT INTO rhgc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Zeñtté Morota ye Isá aiyér de fúinne, híba ye Isá llói milto giiyé, montor Moriyam gór ot táigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Morota ye Isá re hoór de, “Ó Malik, Tuñí zodi eṛé óita, añr bái no moritó. ");
INSERT INTO rhgc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Montor añí yián zani, Tuñí ehón óu Alla ttu ziín magibá, Alla ye híin Tuáñre diibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isá ye híba re hoór de, “Tor bái abar zinda ói uṛíbo.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Morota ye Íba re hoór de, “Añí zani háñcor or din yóggwa abar zinda ói uṛíbo.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isá ye híba re hoór de, “Háñcor edde zindigi óilam de Añí. Zee niki Añr uore iman ané, yóggwa morilé yo zinda tákibo, ");
INSERT INTO rhgc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","aar zee niki zinda asé aar Añr uore iman ané, yóggwa bilkúl no moribó. Tui híyan ekin gorós né?” ");
INSERT INTO rhgc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Híba ye zuwab der de, “Ói, Malik, añí iman ainní de, Tuñí óilade Allar Fua Mosih, zibá duniyait aibár hotá accíl.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Híyan hoói baade, híba zai nizor bóin Moriyam ore matai zuitégori hoór de, “Ustat eṛé asé, Íba ye tuáñre ḍaker.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Híyan fúni híba toratori uṛí Isár hañse giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Héñtte Isá farat nó foóñse, bólke aijjó uṛé zeṛé Morota ye Íba llói dola óoil. ");
INSERT INTO rhgc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ze Yohúdi ókkole Moriyam or fúañti gór ot tái híba re tosólli díyat accíl, ítara Moriyam toratori uṛí baárkule zaargói de dekí híbar fisá doijje. Ítara ṭáaijje de, Moriyam hobor ot hañditó zaar. ");
INSERT INTO rhgc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Zeñtté Moriyam uṛé foóñicce zeṛé Isá asé, híba ye Íba re dekí Íbar ṭéng ot fori hoór de, “Ó Malik, Tuñí zodi eṛé óita, añr bái no moritó.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Isá ye híbar edde híbar fúañti aiccé de Yohúdi ókkol or hañdani deikké rár, Nizor dil ot bicí ferecan laiggíl, edde feṭfuri uiṭṭíl. ");
INSERT INTO rhgc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Íba ye fusár gorér de, “Yóggwa re hoṛé raikkó?” Ítara Íba re hoór de, “Malik, aiyó, soógai.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Isá hañdat doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hétolla Yohúdi ókkole hoór de, “Soó, Ibá ye yóggwa re hondilla ador goittó!” ");
INSERT INTO rhgc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lekin ítara kiyé-kiyé hoór de, “E Manúc zibá ye añdár suk kúli díyl, Ibá ye saitó bóuli kí hé manúc cwa re no more fán gorí no faitto né?” ");
INSERT INTO rhgc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hétolla Isá ttu Nizor bútore abar bicí ferecan lagi, hobor or héṛe giiyé. Hobor gwá óilde eggwá kúñda, aar yíbar muk ot ekkán cíl ouzaiya accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isá ye hoór de, “Cíl lan larifélo.” Morigiyói de yóggwar bóin Morota ye Íba re hoór de, “Malik, yala héntu bac uṛíbo, kiyólla-hoilé yóggwa morigiyói de sair din óiye.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Isá ye híba re hoór de, “Añí toré hoiyí de no né, zodi ekin gorós, Allar mohíma dekíbi bóuli?” ");
INSERT INTO rhgc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tói ítara cíl lan larifélaiye. Aar Isá ye uormikká suk tulí hoór de, “Ó Baf, Tuñí Añr hotá fúinno de hétolla Añí Tuáñre cúkuriya zanair. ");
INSERT INTO rhgc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Añí zani Tuñí hámica Añr hotá fúno, montor Añr sairókul ttu ze manúc cún tíyai asé, ítarar wasté Añí yián hoóir, zeéne ítara ekin goré de, Añré Tuñí beh difeṛáiyo.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Híin hoói yore Isá ye ḍoóñr abase ḍak mari hoór de, “Lasár, neeliai!” ");
INSERT INTO rhgc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tói morigiyói de yóggwa neeli aáigiyoi, yóggwar át edde ṭéng gun hohón or hoor loi baindá, aar yóggwar muk kán ekkán hoor loi beráiya. Isá ye ítara re hoór de, “Yoggwá re kúlifelo, aar zaito doh.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yohúdi ókkol zetará Moriyam or héṛe aiccíl, ítara Isá ye ziyán goijjé híyan dekí boóut zone Íbar uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Montor ítarar bútottu hodúne zai, Isá ye ziín goijjé híin Féroci ókkol ore zanaiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tói ḍoóñr imam ókkole edde Féroci ókkole fótuayi-mujilíc ore míṭing matai hoór de, “Añára ehón kii goittám? Hé Manúc cwa ye toh boóut keramot ókkol gorér. ");
INSERT INTO rhgc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Zodi añára Íba re endilla eridi rakí, tóoile beggúne Íbar uore iman anífelaibo, aar Romi ókkole aái añárar pak zaga edde añárar koum ore kobza gorífelaibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Montor ítarar bútore Káiyafas nam or zibá hé bosór boro imam accíl, yóggwa ye ítara re hoór de, “Tuáñra toh bilkúl kessú no zano, ");
INSERT INTO rhgc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","aar tuáñra yián óu báfi no soór de ki, tuáñra lla beétor óilde fura koum dónco óizar túaro manúc beggún olla ekzon manúc moron.” ");
INSERT INTO rhgc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yóggwa ye híyan nizor bole hoiyé de no, bólke yóggwa hé bosór boro imam accíl ísafe, yóggwa ye agun hotá hoiyé de ki, Yohúdi koum olla Isá moribó; ");
INSERT INTO rhgc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","siríf hé koum olla no, bólke Allar fuain ókkol zetará ikká-uikká dorbodor óigiyoi ítara re ekkán ot zoma gorí bolla yó. ");
INSERT INTO rhgc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hé din lóti ítara Isá re marifélaito sólla gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hétolla Isá ye Yohúdi ókkol or bútore kúlamela góri ar aá-zaa no gorér, bólke héntu moidan elakar ḍáke asé de Eferaim nam or ekkán cóor ot giiyégoi, aar Nizor cárit tun ore looi héṛe tákat doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Héñtte Yohúdi ókkol or Azadir-id ḍáke aiccé, aar id or age nizoré pak-sáf gorí bolla boóut manúc fara ttu uore Jerúsalem ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ítara Isá re talac gorát accíl, aar baitul-mukaddos or uṛán ot tíyai ezzon ottu ezzone fusár gorér de, “Tuáñra kii ṭáaro? Íba id ot ebbe nu aibó níki?” ");
INSERT INTO rhgc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ḍoóñr imam ókkole edde Féroci ókkole hókum zari goijjé de, zodi honókiye Isá hoṛé asé de zane de óile íte ítara re hóbor dito, zeéne ítara Íba re gereftar gorí fare. ");
INSERT INTO rhgc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Azadir-id or sów din age, Isá Betániyat aiccé, zeṛé oh Lasár tákito, zibá re Íba ye mora ttu zinda goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Héṛe ítara Íba lla biyal or hána goijjé. Morota ye hédmot goijjíl, aar zetará Íbar fúañti háito boiccíl ítarar bútore Lasár óu accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hétunot Moriyame háṭi narḍ-gas or bicí moóngga azzér añtor looi aiccé, aar híin Isár foot ḍálidi nizor sul loi Íbar foo fuñsídiye. Hé añtor or kúcboye gór gán bórigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Montor Íbar cárit tun ottu ezzon zee niki Íba re dóridibo de asé, hé Yohúdah Iskáriyete hoór de, ");
INSERT INTO rhgc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“E añtor gún kiyá tin cót dinár dí besi ṭiañ gún gorif ókkol ore dii nó fele?” ");
INSERT INTO rhgc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Íte hotá híyan gorif ókkol olla sintabáfana táki hoiyé de no, bólke kiyólla-hoilé íte sur accíl; ṭiañr feṭi ítar héṛe tákito ísafe, yíbat ziín era zayto héntu íte sur gorífelaito. ");
INSERT INTO rhgc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Montor Isá ye hoór de, “Híba re goittó doh; híba ye iín Añr dohón or din olla beh raikké. ");
INSERT INTO rhgc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gorib ókkol toh tuáñrar fúañti nitti asé,montor Añré tuáñra nitti no faiba.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Isá Betániyat aiccé de zani fari becábicí Yohúdi ókkol héṛe aiccé. Ítara siríf Isá lla aiccé de no, bólke Lasár ore sai bolla yó, zibá re Íba ye mora ttu zinda goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lekin ḍoóñr imam ókkole Lasár ore yó marifélaibar sólla goijjé, ");
INSERT INTO rhgc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kiyólla-hoilé yóggwar zoriya boóut Yohúdi ókkole ítarar héntu zaigói Isár uore iman anér. ");
INSERT INTO rhgc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tarfor din, ze becábicí manúc ókkol id ot aiccé, ítara fúinne de, Isá Jerúsalem ot aiyér, ");
INSERT INTO rhgc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tói ítara házu-gas or ḍaggwa ókkol looi Íba llói dola óito neeillé, aar guzori-guzori hoór de, “Hósana! Mubarek Ubá zibá Mabud or name aiyér, Becók, Íba óilde Isráili ókkol or Baáñcca!” ");
INSERT INTO rhgc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Isá ye eggwá gadár sóo fai yíbar uore boiccíl; zendilla pak-kalam ot asé, ");
INSERT INTO rhgc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ó Síyon or zérfua, no ḍooraiyó; soó, tuáñr Baáñcca gadár sóor uore boói aiyér.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Isár cárit tune híin age buzí nó fare; montor zeñtté Isár mohíma zahér óiye, tói ítara ttu monot uiṭṭé de, híin Íbar baabute beh leká gíyeh, aar manúc ókkole Íba re héen-héen goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Isá ye Lasár ore hobor ottu ḍaki mora ttu zinda goijjíl de héñtte ze manúc ókkol Íbar fúañti accíl, ítara híyan or baabute gobá díyat accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hétolla bóuli yó hé manúc ítara Isá llói dola óito giíl deh, kiyólla-hoilé ítara fúinnil de, hé keramot tán Íba ye beh goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Féroci ókkole híyan olla afós ot hoór de, “Tuáñra toh dekór, añárar honó fáida no ór. Soó, fura duniyai Íbar fisáli óigiyoi.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hé id ot zetará ebaadot goittó aiccé, ítarar bútore hodún Girík manúc óu accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ítara Filíp or hañse aái hoór de, “Jonáb, añára ttu Isá re saitó monehoór.” Filíp óilde Galil or Betsáida farar manúc. ");
INSERT INTO rhgc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filípe zai híyan Enderiyas ore hoiyé, baade Enderiyase edde Filípe zai Isá re hoiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Montor Isá ye ítara re hoór de, “Manúc or Fuar mohíma zahér gorá zaybar októ aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Añí tuáñra re sóiyi-sóiyi hoóir, giyuñr bis zetún meṛit fori nó more, hétun gaaga táke; montor zodi more, yíbat boóut fósol ókkol dóre. ");
INSERT INTO rhgc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Zee niki nizor zan ore muhábbot goré, yóggwa ye híyan háraifelaibo; aar zee niki e duniyait nizor zan ore deéi no fare, yóggwa ye híyan ofúrani zindigi lla basai rakíbo. ");
INSERT INTO rhgc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Honókiye Añr hédmot goittó sailé, ítar ttu Añr fisáli dora foribó; kiyólla-hoilé Añí zeṛé, Añr háadem óu héṛe beh óibo. Zee niki Añr hédmot goré, ítare Añr Bafe izzot goríbo. ");
INSERT INTO rhgc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Yala añr ruh ferecan óigiyoi. Añí kí endilla hoitám né, ‘Ó Baf, Añré e októ ttu basai rakó’? No, Añí e októ foijjonto hétolla éna aiccí. ");
INSERT INTO rhgc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ó Baf, Tuáñr nam or mohíma zahér goró.” Hétunot asman ottu eggwá abas fúna gíyeh de, “Añí híyan zahér goijjí yó, aar abar zahér goijjúm óu.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ze manúc ókkol héṛe tíyai accíl, ítara hé abas swá fúni ḍeba maitté de bóuli hoiyé. Ar hodúne hoór de, “Íba llói honó fírista ye hotá hoiyé deh.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Isá ye zuwab der de, “Hé abas swá Añr wasté aiccé de no, bólke tuáñrar wasté. ");
INSERT INTO rhgc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yala e duniyair maincór bisar goríbar októ aáigiyoi, aar yala e duniyair sóddar ore neelaidiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Añré zeñtté zobin ottu uore tulífela zaybo, héñtte tamám manúc ókkol ore Añr hañse ṭani tulífelaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hotá híin lói Íba ye icára díye de ki, Íba hon moote moribó. ");
INSERT INTO rhgc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Manúc cúne Íba re hoór de, “Añára Córiyot ottu fúinni de, Mosih abadulabad tákibo, tói Tuñí keéngori hoór de, ‘Manúc or Fua re hámaha uore tulífela zaybo?’ Hé Manúc or Fua Íba hon?” ");
INSERT INTO rhgc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isá ye ítara re hoór de, “Nur tuáñrar dormiyan ot ar kessú októ foijjonto beh asé. Tuáñrar fúañti Nur tákite áñṛat táko, arnóile andáre tuáñra re báraizayboi. Zee niki andár ot áñṛe, íte toh hoikká zaar hoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tuáñrar fúañti Nur tákite Nur or uore iman anó, zeéne tuáñra Nur or fuain bonizogói.” Isá ye hotá híin hoói baade ítarar héntu zaigói Nizoré ítara ttu lukai raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Íba ye edún bicí keramot ítarar muúntu goríle yo, toóu ítara Íbar uore iman nú ané. ");
INSERT INTO rhgc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Héndilla etollá óiye, zeéne Yesáyah nobi ye hoóil de hotá yián fura ó, “Ó Mabud, añárar poigam hone ekin goijjé? Aar Mabud or ḍuwáñr bol har hañse zahér óiye?” ");
INSERT INTO rhgc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ítara etollá beh iman aní nó fare, zendilla hé Yesáyah ye aró hoiyé, ki hoilé, ");
INSERT INTO rhgc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Alla ye ítarar suk añdá gorídiye, aar ítarar dil doró gorídiye, zeéne ítara suké no deké, dile no buzé, aar Íba ye ítara re gom gorídi bolla Íbar hañse fíri nu aiyé.” ");
INSERT INTO rhgc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesáyah ye hotá híin Isár mohíma dekí Íbar baabute hoibárcot hoiyé deh. ");
INSERT INTO rhgc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Toóu neta ókkol ottu cóo boóut zone Íbar uore iman ainné, montor Féroci ókkole ítara re mujilíc-hána ttu neelaidibo de híyan or ḍoore ítara híyan cíkar no goittó; ");
INSERT INTO rhgc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","kiyólla-hoilé ítara Alla ttu izzot faar túaro manúc ottu izzot faa bicí fosón goittó. ");
INSERT INTO rhgc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Baade Isá ye guzori-guzori hoór de, “Zee niki Añr uore iman ané, yóggwa siríf Añr uore iman ané de no, bólke Ubár uore yó ané zibá ye Añré difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Zee niki Añré deké, yóggwa ye Añré difeṛáiye de Íba re beh deké. ");
INSERT INTO rhgc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Añí e duniyait Nur ísafe aiccí, zeéne zee kiyé Añr uore iman ané, yóggwa andár ot no táke. ");
INSERT INTO rhgc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Zodi honókiye Añr hotá fúne montor híin amól no goré, yóggwar bisar Añí no gorí, kiyólla-hoilé Añí toh duniyair maincór bisar goittó aiccí de no, bólke duniyair maincóre basaitó aiccí deh. ");
INSERT INTO rhgc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Zee niki Añré inkar goré aar Añr hotá kobul no goré, yóggwar bisarhar asé. Ze hotá Añí hoiyí, kiyamot or din híine beh yóggwar bisar goríbo. ");
INSERT INTO rhgc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kiyólla-hoilé Añí toh Nizor torfóttu kessú hoiyí de nái, montor Añré difeṛáiye de hé Baf Nize Añré hókum goijjé de, Añr ttu kii-kii howá foribó aar kii-kii boiyan gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Añí zani Íbar hókume ofúrani zindigit loiza; hétolla Añí ziín hoói híin beggún Bafe Añré zendilla hoiyé héndilla beh hoói.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Azadir-id or ekkágori agor hotá. Isá ye zainto de, Íba e duniyai ttu Baf or héṛe zaibar októ aáigiyoi. Duniyait mazé zetará Íbar Nizor manúc accíl ítara re Íba ye muhábbot goittó aar ítara re ahéri foijjonto muhábbot goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Héñtte biyal or hánar októ accíl. Íba re dóridi bolla Ibilíce Sáimon or fua Yohúdah Iskáriyet or dil ot age lóti niyot gólaidiye. ");
INSERT INTO rhgc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isá ye zainto de, Bafe Íbar át ot hárr kessú diifélaiye aar Íba Allar torfóttu aiccé edde Allar héṛe beh fíri zaar; ");
INSERT INTO rhgc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","hétolla Íba ye hána eri uiṭṭíl, aar Nizor gaar uoror hoor kúli emmikká eijjé, baade ekkán gansá looi keeñil ot baindé. ");
INSERT INTO rhgc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tarfore Íba ye gaálat faní ḍáli cárit tun or ṭéng dúwai díyat doijje, aar Íbar keeñil ot baindíl de gansá gán lói híin fuñsí díyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Baade Íba Sáimon Fitor or íñyot foóñicce. Fitore Íba re hoór de, “Malik, Tuñí añr ṭéng dúwai díba dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isá ye íba re zuwabe hoór de, “Añí kii gorír tui ehón no buzíbi, montor fore buzíbi.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Fitore Íba re hoór de, “Tuñí bilkúl añr ṭéng no dúiyo.” Isá ye íba re zuwab der de, “Añí zodi tor ṭéng no dúi, tóoile tor lloi Añr llói honó hátil nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Hétunot Sáimon Fitore Íba re hoór de, “Malik, tóoile siríf añr ṭéng no, bólke añr át tun edde matá yó dúwaido.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isá ye íba re hoór de, “Zee niki gaa dúifelaiye, ítar ttu siríf ṭéng dúwa fore deh, kiyólla-hoilé íte toh furafuri sáfsutara. Tuáñra sáf, montor beggún no.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Isá ye zane Íba re hone dóridibo deh; hétolla Íba ye hoiyé de, “Tuáñra beggún sáf no.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tói zeñtté Íba ttu ítarar ṭéng dúiya óiye, Íba ye Nizor hoor fiñdí abar boiccé. Íba ye ítara re hoór de, “Añí tuáñra re kii goijjí de buijjó né? ");
INSERT INTO rhgc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tuáñra toh Añré Ustat edde Malik ḍako, aar tuáñra híyan sóiyi hoó, kiyólla-hoilé Añí toh héndilla ói. ");
INSERT INTO rhgc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tói Añí zettót tuáñrar Malik edde Ustat ói tuáñrar ṭéng dúwai díyi, tuáñra ttu yó ezzone ar ezzon or ṭéng dúwai díyar zorur. ");
INSERT INTO rhgc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Añí gorí tuáñra re ekkán nomuna daháiyi de, zeéne Añí tuáñra re goijjí de héndilla tuáñra yó goró. ");
INSERT INTO rhgc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Añí tuáñra re sóiyi-sóiyi hoóir, gulam nizor girós or túaro ḍoóñr no, aar zibá re difeṛá gíyeh íba yó difeṛóyar túaro ḍoóñr no. ");
INSERT INTO rhgc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yala tuáñra toh iín zano, zodi amól goró tóoile tuáñra mubarek. ");
INSERT INTO rhgc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Añí tuáñra beggún or hotá hoóir de no; Añí zani Añí hontará re basíloiyi. Montor héndilla etollá ór zeéne pak-kalam or hotá yián fura ó, ‘Zee niki Añr fúañti ruṭi háa, íte Añr ulḍa latí tuillé.’ ");
INSERT INTO rhgc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Híyan óibar age Añí yala lóti tuáñra re zanaidir, zeéne híyan óile tuáñra ekin goró de, Añí óilam de Íba. ");
INSERT INTO rhgc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Añí tuáñra re sóiyi-sóiyi hoóir, zee niki Añí difeṛáide yóggwa re kobul goré, íte Añré kobul goré deh; aar zee niki Añré kobul goré, íte Añré difeṛáiye de Íba re kobul goré deh.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Isá ttu híin hoiyá ói baade, dil ot ferecan laiggé, aar hoóifelaiye de ki, “Añí tuáñra re sóiyi-sóiyi hoóir, tuáñra ezzone Añré dóri diba.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Cárit tune Isá ye har hotá hoór de buzí no fari ezzon or uzu ezzone saát doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ítara ttu ze cárit twa re Isá ye muhábbot goittó, yóggwa Isár gaat élan dí boiṛá accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sáimon Fitore hé cárit twa re icára gorí hoór de, “Íba ye har hotá hoór de fusár goró.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tói hé cárit twa Isár gaat élan dí fusár gorér de, “Malik, íte hon?” ");
INSERT INTO rhgc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isá ye zuwab der de, “Ruṭir ṭukuṛa yián burai Añí zaré diiyum, tee óilde manúc íte.” Baade Íba ye ruṭir ṭukuṛa gán burai Sáimon Iskáriyet or fua Yohúdah re diiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ruṭir ṭukuṛa gán looi baade Cóitan ítar bútore góligiyoi. Hétolla Isá ye ítare hoór de, “Tui ziyán goríbi híyan toratori gor.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Montor hána háito boiccé de ítara honókiye nó buzé de, Íba ye ítare hotá híyan kiyólla hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Hodúne ṭáaijjil de, Yohúdah ttu zettót ṭiañr feṭi accíl hétolla Isá ye ítare endilla hoiyé de, “Id olla ziín zorur híin kini angói,” arnóile gorif ókkol ore kessú deegói. ");
INSERT INTO rhgc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Íte ruṭir ṭukuṛa gán looi toratori baárkule neeligiyói. Híyala rait. ");
INSERT INTO rhgc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Íte baáre zaigói baade, Isá ye hoór de, “Yala Manúc or Fuar mohíma zahér óibar októ aiccé, aar Allar mohíma Íbar duara zahér óibo. ");
INSERT INTO rhgc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Zeñtté Íbar duara Allar mohíma zahér óibo, héñtte Alla ye yó Nizor duara hé Manúc or Fuar mohíma zahér goríbo, aar Íba ye Nizor mohíma bicí toratori zahér goríbo. ");
INSERT INTO rhgc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ó Fuain ókkol, Añí tuáñrar fúañti ar kessú októ foijjonto así deh. Tuáñra Añr talac goríba, montor Añí Yohúdi ókkol ore zendilla hoóilam, héndilla yala Añí tuáñra re yó hoóir, ‘Añí zeṛé zairgói héṛe tuáñra aái no faribá.’ ");
INSERT INTO rhgc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Añí tuáñra re ekkán noya hókum dír, ki hoilé, tuáñra ezzon ore ezzone muhábbot goró. Añí zendilla tuáñra re muhábbot goijjí, héndilla tuáñra yó ezzon ore ezzone muhábbot goró. ");
INSERT INTO rhgc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zodi tuáñra ezzon ore ezzone muhábbot goró, híyane beggúne zanibó de, tuáñra óilade Añr ummot.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sáimon Fitore Isá re hoór de, “Malik, Tuñí hoṛé zoórgoi dé?” Isá ye zuwab der de, “Añí zeṛé zairgói, héṛe tui Añr fúañti yala aái no faribí, lekin fore aái faribí.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Fitore Íba ttu fusár gorér de, “Malik, añí Tuáñr fúañti yala kiyá aái no faittam? Añí toh Tuáñr lla bóuli nizor zan úddwa difélaiyum.” ");
INSERT INTO rhgc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isá ye zuwab der de, “Tui Añr lla tor zan difélaibi dé? Añí toré sóiyi-sóiyi hoóir, ratakurá bak dibar age tui Añré tin bar inkar goríbi. ");
INSERT INTO rhgc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Tuáñrar dil ot ferecan nu ainnó. Allar uore iman rakó, Añr uore yó iman rakó. ");
INSERT INTO rhgc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Añr Baf or gór ot tákibar zaga bicí asé, zodi no tákito, Añí tuáñra re hoói dítam, kiyólla-hoilé Añí toh tuáñra lla zaga toiyar goittó zair. ");
INSERT INTO rhgc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Añí zai tuáñra lla zaga toiyar gorí waafes aiccúm, aar Añr héṛe tuáñra re loizaiyúmboi, zeéne Añí zeṛé, tuáñra yó héṛe ó. ");
INSERT INTO rhgc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tuáñra toh Añí hoṛé zair de híyan or rasta zano.” ");
INSERT INTO rhgc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tómase Íba re hoór de, “Malik, añára no zani Tuñí hoṛé zoór, tóoile rasta keéngori zaniyúm?” ");
INSERT INTO rhgc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isá ye yóggwa re hoór de, “Añí óilam de rasta, sóiyi, edde zindigi; Añr duara no zailé honókiye Baf or héṛe zai no fare. ");
INSERT INTO rhgc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","“Zodi tuáñra Añré sinnó de óile, tóoile toh Añr Baf ore yó sinnó. Yala lóti tuáñra Íba re sinó edde dekífelaiyo.” ");
INSERT INTO rhgc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filípe Íba re hoór de, “Malik, Baf ore añára re dahó, híyan añára lla kafí.” ");
INSERT INTO rhgc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isá ye yóggwa re hoór de, “Filíp, Añí toh tuáñrar fúañti etókkal así, toóu tui Añré no sinós dé? Zee niki Añré deikké íte Baf ore deikké. Tui keéngori hoór de, ‘Baf ore añára re dahó?’ ");
INSERT INTO rhgc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tui ki biccác no gorós, Añí Baf or bútore así aar Baf Añr bútore asé dé? Hotá ziín Añí tuáñra re hoói, híin Añí Nizor torfóttu hoói de no, bólke Baf zibá Añr bútore asé Íba ye Nizor ham gorér deh. ");
INSERT INTO rhgc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Añré biccác goró de, Añí Baf or bútore así aar Baf Añr bútore asé; arnóile ham mún or wasté óile Añré biccác goró. ");
INSERT INTO rhgc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Añí tuáñra re sóiyi-sóiyi hoóir, zee niki Añr uore iman raké, ze ham ókkol Añí gorí híin íte yó goríbo; íte híin or túaro ḍoóñr-ḍoóñr ham ókkol goríbo, kiyólla-hoilé Añí toh Baf or héṛe zairgói. ");
INSERT INTO rhgc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aar tuáñra Añr name ziín saibá híin Añí goríyum, zeéne Baf or mohíma Fuar duara zahér ó. ");
INSERT INTO rhgc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tuáñra Añr name Añr ttu honó kessú sailé, Añí híyan goríyum. ");
INSERT INTO rhgc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Zodi tuáñra Añré muhábbot goró, tóoile Añr hókum ókkol amól goríba. ");
INSERT INTO rhgc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Añí Baf ottu magiyúm, aar Íba ye tuáñra re ar ezzon Modotgár diibo, zeéne Íba tuáñrar fúañti abadulabad táke. ");
INSERT INTO rhgc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hé Modotgár óilde sóiyir Ruh; duniyai ye Íba re kobul gorí no fare, kiyólla-hoilé duniyai ye Íba re no yo deké aar no yo zane. Montor tuáñra toh Íba re zano, kiyólla-hoilé Íba tuáñrar fúañti-fúañti táke edde tuáñrar bútore tákibo. ");
INSERT INTO rhgc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Añí tuáñra re etim rakí no zaiyum; Añí tuáñrar héṛe waafes aiccúm. ");
INSERT INTO rhgc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hotún ánik baade duniyai ye Añré ar no dekíbo, montor tuáñra Añré dekíba, kiyólla-hoilé Añí zinda así ísafe tuáñra yó zinda tákiba. ");
INSERT INTO rhgc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hé din ailé tuáñra zani faribá de, Añí Añr Baf or bútore así, tuáñra Añr bútore asó, aar Añí tuáñrar bútore así. ");
INSERT INTO rhgc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Zee niki Añr hókum ókkol kobul goré edde amól goré, yóggwa óilde zee niki Añré muhábbot goré. Zee niki Añré muhábbot goré, yóggwa re Añr Bafe muhábbot goríbo; Añí yó yóggwa re muhábbot goríyum aar Nizoré yóggwar hañse zahér goijjúm.” ");
INSERT INTO rhgc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hétunot Iskáriyet no de hé Yohúdah ye Íba re hoór de, “Malik, kiyólla Tuñí duniyair hañse no gorí siríf añárar hañse Nizoré zahér goríba dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isá ye yóggwa re zuwabe hoór de, “Zodi kiyé Añré muhábbot goré, yóggwa Añr hotáye solibó. Añr Bafe yóggwa re muhábbot goríbo, aar Añára yóggwar hañse aiccúm edde yóggwar fúañti tákiyum. ");
INSERT INTO rhgc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Zee niki Añré muhábbot no goré, yóggwa Añr hotáye no sole. Ze hotá tuáñra fúnor híin Añr no, bólke Añré difeṛáiye de hé Baf or. ");
INSERT INTO rhgc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“E hotá iín Añí tuáñra re tuáñrar fúañti tákite hoiyí. ");
INSERT INTO rhgc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lekin Modotgár yáni Pak-Ruh, zibá re Bafe Añr name difeṛáibo, Íba ye tuáñra re hárr kessú cíkaibo, aar Añí ziín tuáñra re hoiyí híin beggún yaad goráidibo. ");
INSERT INTO rhgc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Añí tuáñra lla cánti rakí zair; Añr cánti Añí tuáñra re diir. Duniyai ye dee de héndilla gorí Añí no dii. Tuáñrar dil ot ferecan nu ainnó, edde no ḍooraiyó. ");
INSERT INTO rhgc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Añí tuáñra re yián hoiyí de toh fúinno, ‘Añí zairgói, aar tuáñrar héṛe waafes aiccúm.’ Zodi tuáñra Añré muhábbot goittá, tóoile tuáñra Añí Baf or héṛe zairgói de hétolla kúci óita, kiyólla-hoilé Añr Baf toh Añr túaro ḍoóñr. ");
INSERT INTO rhgc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Híin óibar age lóti Añí tuáñra re hoóidiyi, zeéne híin óile tuáñra biccác goró. ");
INSERT INTO rhgc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Añí tuáñra llói ar bicí hotá no hoiyúm, kiyólla-hoilé duniyair sóddar toh aáizargoi, aar ítar ttu Añr uore honó kémota nái. ");
INSERT INTO rhgc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Montor Añí Baf ore muhábbot gorí de híyan duniyai ye zane fán, Bafe Añré zendilla hókum goijjé Añí héndilla beh gorí. “Uṛó, Añára yián ttu zaigói. ");
INSERT INTO rhgc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Añí óilam dé sóiyi anggur-gas, aar Añr Baf óilde barizar cacá. ");
INSERT INTO rhgc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Añr ze ḍéeilat gula no dóre, yíba re Íba ye haṛiféle; montor ze ḍéeilat gula dóre, yíba re Íba ye cáṛi sáf raké, zeéne yíbat aró gula dóre. ");
INSERT INTO rhgc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Añí tuáñra re ze hotá ókkol hoiyí híin lói toh tuáñra age lóti pak-sáf óigiyogoi. ");
INSERT INTO rhgc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Añr llói laigga táko, aar Añí yó tuáñra llói laigga táikkum. Zendilla ḍéeila anggur-gas ot laigga no tákile nizorgá nize gula dórai no fare, héndilla tuáñra yó no faribá zodi Añr llói laigga no táko. ");
INSERT INTO rhgc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Añí óilam de anggur-gas, aar tuáñra óilade ḍéeila ókkol. Zee niki Añr llói laigga táke aar Añí ítar llói laigga táki, íte bicí gula dórai fare, kiyólla-hoilé Añí sára toh tuáñra kessú gorí no faribá. ");
INSERT INTO rhgc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Zee niki Añr llói laigga no táke, ítare ḍéeilar ḍóilla baáre félaidiya zah, aar fúaizagoi; tói maincé híin ore dolagorí ooin ot félai déh, aar híin furizagói ");
INSERT INTO rhgc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zodi tuáñra Añr llói laigga táko, aar Añr hotá tuáñra llói laigga táke, tóoile tuáñra ttu monehoó de híyan magiyó, tuáñra re híyan diiya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tuáñra bicí gula dórai Añr ummot de sábut goríle, Añr Baf or mohíma zahér ó. ");
INSERT INTO rhgc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Bafe Añré zendilla muhábbot goijjé, Añí yó tuáñra re héndilla muhábbot goijjí. Añr muhábbot ot laigga táko. ");
INSERT INTO rhgc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Zodi tuáñra Añr hókum ókkol amól goró, tóoile Añr muhábbot or bútore tákiba, zendilla Añí Añr Baf or hókum ókkol amól gorí yore Íbar muhábbot or bútore táki. ");
INSERT INTO rhgc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Hotá iín Añí tuáñra re etollá hoiyí, zeéne Añr kúci tuáñrar bútore táke, aar tuáñrar kúci zen fura óizagoi. ");
INSERT INTO rhgc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Añr hókum óilde yián, Añí tuáñra re zendilla muhábbot goijjí, tuáñra yó ezzon ore ezzone héndilla muhábbot goró. ");
INSERT INTO rhgc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ezzone nizor dustó ókkol olla nizor zan diféle de híyan or túaro toh ar ḍoóñr muhábbot nái. ");
INSERT INTO rhgc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tuáñra Añr dustó ókkol, zodi Añí tuáñra re ziín hókum díyi híin amól goró. ");
INSERT INTO rhgc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Añí tuáñra re gulam bouli ar no hoóir, kiyólla-hoilé gulame toh nizor giróse kii gorér no zane. Montor Añí tuáñra re dustó hoiyí, kiyólla-hoilé Añí toh Añr Baf ottu ziín fúinni híin beggún tuáñra re zanaidiyí. ");
INSERT INTO rhgc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tuáñra Añré basíloiyo de no, bólke Añí éna tuáñra re basíloiyi edde ham ot lagaiyí, zeéne tuáñrar zindigit gulagala dóre aar hé gulagala ṭiki táke, zeéne tuáñra Baf ottu Añr name ziín magibá híin Íba ye tuáñra re dee. ");
INSERT INTO rhgc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Añí tuáñra re hókum dír de ki, tuáñra ezzon ore ezzone muhábbot goró. ");
INSERT INTO rhgc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Zodi duniyai ye tuáñra re nafórot goré, monot raikkó de, ítara tuáñra re goríbar age Añré nafórot goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Zodi tuáñra duniyair óita, duniyai ye tuáñra re nizor ísafe muhábbot goittó; montor tuáñra zettót duniyair no aar Añí tuáñra re duniyai ttu basíloifélaiyi, hétolla beh duniyai ye tuáñra re nafórot goré. ");
INSERT INTO rhgc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Añí tuáñra re hoiyí de hotá gán monot raikkó de ki, ‘Gulam nizor girós or túaro ḍoóñr no.’Hétolla ítara zodi Añré zulúm goijjé de óile, tuáñra re yó zulúm goríbo; zodi ítara Añr hotá amól goijjé de óile, tuáñrar hotá yó amól goríbo. ");
INSERT INTO rhgc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lekin ítara híin beggún tuáñra re Añr nam or zoriya beh goríbo, kiyólla-hoilé ítara Añré difeṛáiye de Íba re no siné. ");
INSERT INTO rhgc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Zodi Añí nu aitám aar ítara re hotá ókkol no hoitám, tóoile ítara gunágar no ṭóorito; montor yala de ítara ttu nizor guná lla honó bahána nái. ");
INSERT INTO rhgc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Añré nafórot goré de íte Añr Baf ore yó nafórot goré. ");
INSERT INTO rhgc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Zodi Añí ítarar héṛe ham uúin no goittám ziín honókiye goijjé de nái, tóoile ítara gunágar no ṭóorito; montor yala toh ítara Añré edde Añr Baf ore deikké aar nafórot óu goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lekin héndilla etollá óiye, zeéne ítarar Córiyot ot leikká asé de hotá yián fura ó, ‘Ítara Añré hánnak nafórot goijjé.’ ");
INSERT INTO rhgc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Zeñtté Modotgár Ubá aibó zibá re Añí Baf or torfóttu tuáñrar héṛe difeṛáiyum, yáni sóiyir Ruh zibá Baf or torfóttu aiyé Íba re, héñtte Íba ye Añr baabute gobá díbo. ");
INSERT INTO rhgc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aar tuáñra yó Añr baabute gobá díba, kiyólla-hoilé tuáñra toh Añr fúañti-fúañti foóila cúru ttu lóti asó. ");
INSERT INTO rhgc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Añí tuáñra re hotá iín etollá hoiyí, zeéne tuáñra iman ottu no zoogói. ");
INSERT INTO rhgc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Maincé tuáñra re mujilíc-hána ttu neelaidibo; ói, eén októ aiyér, zee niki tuáñra re mariféle íte ṭáaribo de, íte Allar hédmot gorér bóuli. ");
INSERT INTO rhgc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ítara héndilla híin etollá goríbo, kiyólla-hoilé ítara no Baf ore sinné aar no Añré sinné. ");
INSERT INTO rhgc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lekin híin Añí tuáñra re hoiyí de, zeéne híin or októ ailé tuáñra ttu monot uṛé de ki, Añí tuáñra re híin or baabute hoói ráikki. Añí tuáñra re foóila lóti híin nó hoói, kiyólla-hoilé Añí toh tuáñrar fúañti-fúañti accílam. ");
INSERT INTO rhgc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Montor yala Añí Ubár héṛe zairgói zibá ye Añré difeṛáiye, aar tuáñra honókiye Añr ttu fusár no gorór de, ‘Tuñí hoṛé zoórgoi dé?’ ");
INSERT INTO rhgc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Montor Añí tuáñra re iín hoiyí de hétolla, tuáñrar dil ferecaniye bórigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lekin Añí tuáñra re sóiyi hoóir, Añí tuáñrar fáida lla zairgói deh; kiyólla-hoilé zodi Añí no zaigói, hé Modotgár tuáñrar hañse nu aibó; montor Añí zailégoi, Añí Íba re tuáñrar hañse difeṛáiyum. ");
INSERT INTO rhgc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aar Íba zeñtté aibó, duniyai re gunár, forhésgarir edde bisar or baabute hosúrbon ṭóoraibo. ");
INSERT INTO rhgc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gunár baabute ṭóoraibo de kiyólla-hoilé, manúc ókkole Añr uore iman nú ané; ");
INSERT INTO rhgc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","forhésgarir baabute ṭóoraibo de kiyólla-hoilé, Añí Baf or héṛe zairgói aar tuáñra Añré ar no dekíba; ");
INSERT INTO rhgc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","bisar or baabute ṭóoraibo de kiyólla-hoilé, duniyair sóddar or bisar óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Añr ttu tuáñra re hoibár aró boóut kessú asé, montor yala tuáñra híin bordac gorí no faribá. ");
INSERT INTO rhgc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lekin zeñtté Ubá, yáni sóiyir Ruh aibó, Íba ye tuáñra re fura sóiyir rasta daháibo; kiyólla-hoilé Íba ye toh Nizor torfóttu kessú hoibó de no, bólke ziín fúne híin beh hoibó, aar ziín óibo de asé híin tuáñra re zanaidibo. ");
INSERT INTO rhgc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Íba ye Añr gún looi tuáñra re zanaidibo; héndilla gorí Íba ye Añr mohíma zahér goríbo. ");
INSERT INTO rhgc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Baf ottu ziín asé híin beggún toh Añr; hétolla hoiyí de, Íba ye Añr gún looi tuáñra re zanaidibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Hotún baade tuáñra Añré ar no dekíba, aar abar hotún baade tuáñra Añré dekíba.” ");
INSERT INTO rhgc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Hétolla Íbar hoozzon cárite afós ot hoór de, “Ibá ye añára re iín kii hoór, ‘Hotún baade tuáñra Añré ar no dekíba, aar abar hotún baade tuáñra Añré dekíba’? Aró hoór de, ‘Kiyólla-hoilé Añí Baf or héṛe zairgói?’” ");
INSERT INTO rhgc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ítara hoór de, “Ibá ye ziyán ‘Hotún or’ hotá hoór híyan kii? Añára no zani Ibá ye kiyór hotá hoór.” ");
INSERT INTO rhgc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isá ye zani faijjé de, ítara ttu Íba re súwal goittó monehoór, hétolla Íba ye ítara re hoór de, “Tuáñra afós ot Añr hotá yián or baabute howáhoi gorór de né, ziyán Añí hoiyí de, ‘Hotún baade tuáñra Añré ar no dekíba, aar abar hotún baade tuáñra Añré dekíba?’ ");
INSERT INTO rhgc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Añí tuáñra re sóiyi-sóiyi hoóir, tuáñra hañdibá edde bilak goríba, montor duniyai ye kúci goríbo. Tuáñra ferecan óiba, lekin tuáñrar ferecani kúcit bodolizaybói. ");
INSERT INTO rhgc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Zeñtté honó mayafua ye fua zormo deh héñtte toh duk faa, kiyólla-hoilé híbar duk faibar októ aiccé; montor zeñtté fua hálas óizagoi, duniyait eggwá fua foida óiye de kúciye hé duk ore ar monot no raké. ");
INSERT INTO rhgc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Héndilla, tuáñra yó yala ferecanit asó; montor tuáñra llói Añí abar miliyúm, héñtte tuáñrar dil kúci óibo, aar tuáñrar kúci re tuáñra ttu honókiye looi no felaibo. ");
INSERT INTO rhgc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hé din tuáñra Añr ttu honó kessú fusár goríba de nái. Añí tuáñra re sóiyi-sóiyi hoóir, zodi tuáñra Añr name Baf ottu kessú mago, Íba ye tuáñra re diibo. ");
INSERT INTO rhgc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Aijjó foijjonto tuáñra Añr name kessú maiggó de nái. Mago, tuáñra faiba, zeéne tuáñrar kúci fura óizagoi. ");
INSERT INTO rhgc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Hotá iín Añí tuáñra re meésal dí beh hoiyí, lekin eén októ aiyér, Añí tuáñra re meésal dí ar no hoiyúm, bólke sáf-sáf góri tuáñra re Baf or baabute hoiyúm. ");
INSERT INTO rhgc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hé din tuáñra Añr name magibá; aar Añí tuáñra re eén no hoóir de, Añí Baf or hañse tuáñra lla aros goijjúm. ");
INSERT INTO rhgc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Baf Nize toh tuáñra re muhábbot goré, kiyólla-hoilé tuáñra Añré muhábbot goijjó aar biccác goijjó de, Añí Allar torfóttu aiccí deh. ");
INSERT INTO rhgc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Añí Baf or héntu aái e duniyait aiccí; abar Añí e duniyai eri Baf or héṛe zairgói.” ");
INSERT INTO rhgc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hétunot Íbar cárit tune hoór de, “Soó, yala Tuñí sáf-sáf góri hoór, honó meésal dí no. ");
INSERT INTO rhgc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yala añára zani faijjí de, Tuñí hárr kessú zano, aar Tuáñr ttu honókiye súwal goríbar zorur nái; híyane añára biccác gorí de, Tuñí Allar torfóttu aiccó deh.” ");
INSERT INTO rhgc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isá ye ítara re hoór de, “Tuáñra yala biccác goró né? ");
INSERT INTO rhgc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Soó, eén októ aiyér, becók aáigiyoi, tuáñra beggún dorbodor ói zar-zar zagat tee-tee zaibagói, aar Añré háliga eribá. Toóu Añí háliga no, kiyólla-hoilé Baf toh Añr fúañti asé. ");
INSERT INTO rhgc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Añí tuáñra re hotá iín etollá hoiyí, zeéne tuáñra Añr bútore cánti foo. Duniyait mazé tuáñra duk-mosibot ot tákiba; montor hímmot na háraiyo, Añí duniyai re ziti aiccí.” ");
INSERT INTO rhgc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Isá ye híin hoói baade asman or uzu saái hoór de, “Ó Baf, októ aáigiyoi. Tuáñr Fuar mohíma zahér goró, zeéne Fua ye yó Tuáñr mohíma zahér goré, ");
INSERT INTO rhgc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kiyólla-hoilé Tuñí toh Íba re fura insán-zatir uore adíkar diiyó, zeéne Tuñí zetará re Íbar át ot diiyó, ítara beggún ore Íba ye ofúrani zindigi dee. ");
INSERT INTO rhgc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aar ofúrani zindigi óilde yián, ítara zen Tuñí siríf sóiyi Alla re edde Tuñí difeṛáiyo de Isá Mosih re zane. ");
INSERT INTO rhgc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tuñí Añré ze ham gorí bolla diiyó, híyan fúrai Añí e duniyait Tuáñr mohíma zahér goijjí. ");
INSERT INTO rhgc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aar yala, ó Baf, Tuñí zeṛé asó héṛe Añré mohímawala banaifélo, oh mohímaye ze mohíma duniyai foida goríbar age lóti Tuáñr fúañti Añr ttu accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Añí Tuáñr nam manúc uitarár hañse zahér goijjí zetará re Tuñí duniyai ttu Añr át ot diiyó. Ítara toh Tuáñr accíl; Tuñí ítara re Añr át ot diiyó aar ítara Tuáñr hotá amól goijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yala ítara zainné de, zedún Tuñí Añré diiyó, híin beggún Tuáñr torfóttu; ");
INSERT INTO rhgc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kiyólla-hoilé ze hotá Tuñí Añré hoitó hoiyó, Añí híin ítara re hoiyí, aar ítara híin kobul goijjé. Ítara fakkafakki gori zainné de, Añí Tuáñr héntu aiccí deh, aar biccác goijjé de, Añré Tuñí beh difeṛáiyo. ");
INSERT INTO rhgc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Añí ítara lla beh dua gorír. Añí duniyai lla dua gorír de no, bólke zetará re Tuñí Añr át ot diiyó ítara lla, kiyólla-hoilé ítara toh Tuáñr. ");
INSERT INTO rhgc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ziín Añr híin beggún Tuáñr, aar ziín Tuáñr híin beggún Añr. Añr mohíma híin or duara zahér óiye. ");
INSERT INTO rhgc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Añí duniyait ar no tákiyum, montor ítara toh duniyait asé, aar Añí Tuáñr héṛe aáizairgoi. Ó pak Baf, ze nam Tuñí Añré diiyó Tuáñr hé name Tuñí ítara re héfazot rakó, zeéne ítara undilla ek óizagoi zendilla Añára ek. ");
INSERT INTO rhgc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Añí zetókkal foijjonto ítarar fúañti accílam, Añí ítara re Tuáñr oh name héfazot raikkí, ziyán Tuñí Añré diiyó. Añí ítara re faára dí ráikki, aar ítara ttu honókiye borbad nó óiyo, siríf uite beh óiye zee niki borbad óibar accíl, zeéne pak-kalam fura ó. ");
INSERT INTO rhgc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Lekin yala toh Añí Tuáñr héṛe aáizairgoi, aar Añí duniyait tákite iín etollá hoóir, zeéne ítara ttu Añr kúci furafuri gori táke. ");
INSERT INTO rhgc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Añí ítarar hañse Tuáñr kalam foóñsaiyi, aar duniyai ye ítara re nafórot goijjé, kiyólla-hoilé zendilla Añí duniyair no, héndilla ítara yó toh duniyair no. ");
INSERT INTO rhgc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Añr dua endilla no de ki, Tuñí ítara re duniyai ttu loizogói, bólke Añr dua óilde, Tuñí ítara re Ibilíc ottu héfazot rakó. ");
INSERT INTO rhgc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Zendilla Añí duniyair no, héndilla ítara yó toh duniyair no. ");
INSERT INTO rhgc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ítara re sóiyi lói pak-sáf goró. Tuáñr kalam óilde hé sóiyi. ");
INSERT INTO rhgc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Zendilla Tuñí Añré duniyait difeṛáiyo, héndilla Añí yó ítara re duniyait difeṛáiyi. ");
INSERT INTO rhgc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Añí ítara lla Nizoré háas gorí rakír, zeéne ítara re yó sóiyi lói háasgori raká zah. ");
INSERT INTO rhgc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Añí siríf ítara lla dua gorír de no, bólke uitará lla yó gorír zetará ítarar hotá fúni Añr uore iman aníbo; ");
INSERT INTO rhgc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","zeéne ítara beggún ek óizagoi, zendilla, ó Baf, Tuñí Añr bútore asó, aar Añí Tuáñr bútore así, héndilla ítara yó zen Añárar bútore ó, zeéne duniyai ye biccác goré de, Añré Tuñí beh difeṛáiyo. ");
INSERT INTO rhgc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tuñí Añré ze mohíma diiyó híyan Añí ítara re yó diiyí, zeéne ítara undilla ek óizagoi zendilla Añára ek. ");
INSERT INTO rhgc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Añí ítarar bútore así aar Tuñí Añr bútore asó, zeéne ítara furafuri ek óizagoi, zeéne duniyai ye zane de, Añré Tuñí beh difeṛáiyo, aar Tuñí ítara re undilla muhábbot goijjó zendilla Añré muhábbot goijjó. ");
INSERT INTO rhgc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ó Baf, Añí sái, zetará re Tuñí Añr át ot diiyó, ítara yó zen Añí zeṛé táki héṛe Añr fúañti táke, zeéne Tuñí Añré diiyó de Añr hé mohíma ítara deké, kiyólla-hoilé Tuñí toh Añré duniyair foidayecir age lóti muhábbot goijjó. ");
INSERT INTO rhgc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ó insáfwala Baf, duniyai ye toh Tuáñre no siné, montor Añí Tuáñre siní; aar itará zainné de, Añré Tuñí beh difeṛáiyo. ");
INSERT INTO rhgc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Añí itarár hañse Tuáñr nam zahér goijjí, aar híyan aró zahér gorát tákiyum, zeéne ze muhábbote Tuñí Añré muhábbot goijjó hé muhábbot itarár bútore táke aar Añí itarár bútore táki.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Isá ye hotá híin hoói baade, Nizor cárit tun ore looi Kídron zúra farái okule giiyé. Héṛe ekkán bagan accíl, aar Íba edde Íbar cárit tun híyan ot góille. ");
INSERT INTO rhgc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Íba re dóridiye de Yohúdah ye yó hé zaga gán zainto, kiyólla-hoilé Isá egazá-egazá héṛe Nizor cárit tun lói militó. ");
INSERT INTO rhgc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hétolla Yohúdah ye ḍoóñr imam ókkol ottu edde Féroci ókkol ottu ek dol Romi fóous edde hodún faáradar ókkol ore fúañti looi fánoc, uzal, edde átiyar ókkol lói héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Isá ye Íbar uore ziín óibo híin beggún zane ísafe, baáre neeli ítara ttu fusár gorér de, “Tuáñra haré tuwoór dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ítara Íba re zuwab der de, “Isá Nasári re.” Isá ye ítara re hoór de, “Añí Íba.” Íba re dórider de Yohúdah yó ítarar fúañti tíyai asé. ");
INSERT INTO rhgc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zeñtté Isá ye ítara re yián hoiyé, “Añí Íba,” hétunot ítara fissá zai meṛit forigiyói. ");
INSERT INTO rhgc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Íba ye ítara ttu abar fusár gorér de, “Tuáñra haré tuwoór dé?” Ítara hoór de, “Isá Nasári re.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isá ye zuwab der de, “Añí Íba de híyan toh tuáñra re hoóifelaiyi. Hétolla zodi tuáñra Añré tuwoór de óile, tóoile itará zoggói.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Híyan etollá óiye, zeéne Íba ye hoóil de e hotá fura ó, “Zetará re Tuñí Añr át ot diiyó, Añí ítara ttu ezzon ore úddwa nó áñzai.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sáimon Fitor ottu ekkán toluwar accíl ísafe, yóggwa ye híyan neelai boro imam or gulam or uore solai ítar den ḍák or han nán haṛifélaiye. Hé gulam mwar nam Malkus. ");
INSERT INTO rhgc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Hétolla Isá ye Fitor ore hoór de, “Toluwar ḍaf ot gólai er. Ze fiyala Bafe Añré diiyé, Añí hé fiyala no fiítam né?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tói hé fóous suné, ítarar zonnale, edde Yohúdir faáradar gúne Isá re gereftar gorí bañdífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Baade Íba re age Hánan or héṛe loigiyé, kiyólla-hoilé ze Káiyafas hé bosór boro imam accíl, yóggwar hóour óilde Hánan. ");
INSERT INTO rhgc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hé Káiyafas óilde ubá zee niki Yohúdi ókkol ore mocuwara dyíl de, beétor óilde fura koum olla ekzon manúc moron. ");
INSERT INTO rhgc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sáimon Fitor edde ar ezzon cárit Isár kure-kure zaat accíl. Hé cárit twa re boro imame siníto ísafe, yóggwa Isár fuñde-fuñde boro imam or uṛán ot góillegoi, ");
INSERT INTO rhgc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","lekin Fitor baáre duwar ot tíyai táikkil. Hétolla ze cárit twa re boro imame siníto, yóggwa ye baáre neeli duwar sooñidar gwá re hoói Fitor ore bútore ainné. ");
INSERT INTO rhgc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Duwar sooñidar bañdi mayafua wa ye Fitor ore hoór de, “Tuñí yó hóno e Manúc cwar cárit ottu né?” Yóggwa ye zuwab der de, “Añí no.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Héñtte cítkhal de hétolla gulam ókkole edde faáradar ókkole aañra loi ooin dórai íñyot tíyai ooin fuwát accíl; aar Fitor nize yó ítarar fúañti tíyai ooin fuwát accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Héñtte boro imame Isá ttu Íbar ummot ókkol or edde Íbar taalim or baabute súwal gorér. ");
INSERT INTO rhgc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isá ye yóggwa re zuwab der de, “Añí duniyair hañse kúlamela góri hotá hoiyí. Añí hámica mujilíc-hána ókkol ot edde baitul-mukaddos ot zeṛé tamám Yohúdi ókkol zoma ó héṛe taalim diyí, aar Añí toh lukai kessú hoiyí de nái. ");
INSERT INTO rhgc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tuñí Añr ttu kiyá fusár gorór? Fúinne de ítara ttu fusár goróna Añí ítara re kii hoiyí. Becók Añí ziín hoiyí híin ítara zane.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Isá ye híin hoiyé rár, héṛe ḍáke tíyai accíl de faáradar ottu ezzone Íba re suwar mari hoór de, “Boro imam ore héndilla góri zuwab dede niki?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isá ye ítare zuwab der de, “Zodi Añí honó gollot hoiyí de óile, gollot híyan daháide; montor zodi sóiyi hoiyí de óile, Añré marór kiyá?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Baade Hánane Isá re baindá hálote, boro imam Káiyafas or héṛe difeṛáidiye. ");
INSERT INTO rhgc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sáimon Fitor aijjó foijjonto tíyai ooin fuwát accíl. Maincé yóggwa re hoór de, “Tuñí yó hóno Íbar cárit tun or bútottu né?” Yóggwa ye inkar gorí hoór de, “Añí no.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Boro imam or gulam ottu ezzon zee niki Fitore han haṛifelail de ítar egana, íte hoór de, “Añí toré Íbar fúañti bagan ot nó dekí niki?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Fitore abar inkar goijjíl; aar éhon-éhon ratakurá bak diyé. ");
INSERT INTO rhgc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yárbaade Yohúdir neta ókkole Isá re Káiyafas or héntu Romi razmohól ot loigiyé, héñtte biínna sóore accíl. Ítara nize hé mohól ot nó góle, zeéne ítara nafak ói no zagói, bólke Azadir-id or hána hái fare. ");
INSERT INTO rhgc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hétolla Filat baáre neeli ítarar héṛe aiccé aar hoór de, “Tuáñra e Manúc cwar ulḍa kii hosúri ainnó dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ítara yóggwa re zuwabe hoór de, “Zodi Íba acámi no óito, añára Íba re tuáñr hañse gosái no ditam.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Filate ítara re hoór de, “Tuáñra Íba re loizai tuáñrar córiyot mozin bisar gorógoi.” Hé Yohúdi gúne yóggwa re hoór de, “Añára ttu honókiyo re zane marifélaibar ezazot nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Híyan etollá óiye, zeéne Isár oh hotá fura ó, ziyán Íba ye Íba hondilla mora moribó de híyan or icáraye hoóil. ");
INSERT INTO rhgc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tarfore Filat abar razmohól or bútore góille, aar Isá re matai hoór de, “Tuñí Yohúdir Baáñcca niki?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isá ye yóggwa re zuwab der de, “Tuñí hotá yián nizor torfóttu hoór de né, náki ar honókiye tuáñre Añr baabute hoiyé dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Filate zuwab der de, “Añí Yohúdi níki? Tuáñr nizor koume edde ḍoóñr imam múne éna Tuáñre añr hañse gosáidiye. Tuñí kii goijjó dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isá ye zuwab der de, “Añr raijjo e duniyair no. Zodi Añr raijjo e duniyair óito, Añr gulam ókkole maramari goittó, zeéne Añré Yohúdi ókkol or hañse gosáidiya no zah. Montor Añr raijjo toh eṛíyar no.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Híyan olla Filate Íba re hoór de, “Tóoile Tuñí baáñcca níki?” Isá ye zuwab der de, “Tuñí sóiyi hoór, Añí baáñcca. Aní etollá zormo óiyi aar etollá duniyait aiccí, kiyólla-hoilé: sóiyir uzu gobá dí bolla. Zee niki sóiyir, yóggwa ye Añr hotá fúne.” ");
INSERT INTO rhgc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Filate Isá re hoór de, “Sóiyi kii?” Híyan hoói baade yóggwa abar baáre neeli Yohúdi gún or héṛe aiccé, aar ítara re hoór de, “Añí Íba ttu honó hosúri no fair. ");
INSERT INTO rhgc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Lekin tuáñra ttu toh ekkán niyom asé, ki hoilé, Azadir-id or októt añr ttu tuáñrar hañse honó ek hodi re hálas gorídiyar zorur. Hétolla tuáñra ttu añré Yohúdir Baáñcca wa re hálas gorídiya baitó monehoór né?” ");
INSERT INTO rhgc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hétunot ítara beggúne abar guzori hoór de, “Hé Manúc cwa re no, bólke Bárabba re!” Hé Bárabba ézzon bagi accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Baade Filate Isá re loizai soóñk mara baáil. ");
INSERT INTO rhgc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aar fóous ókkole keñṛar eggwá tas banai Íbar matát diyaidil, aar Íba re bayoinna rong or eggwá zubba fiñdáidil. ");
INSERT INTO rhgc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tarfore ítara Íbar hañse aái-aái hoór de, “Ó Yohúdir Baáñcca, márhaba!” Héen hoói-hoói ítara Íba re suwar maijjé. ");
INSERT INTO rhgc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Filat abar baáre neeli aái Yohúdi gún ore hoór de, “Soó, añí Íba re baáre tuáñrar hañse anáir, zeéne tuáñra zano de, añí Íba ttu honó hosúri no fair.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tarfore keñṛar tas edde bayoinna rong or zubba findá hálote Isá baáre aiccé. Aar Filate ítara re hoór de, “Soó hé Manúc cwa!” ");
INSERT INTO rhgc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Zeñtté ḍoóñr imam múne edde faáradar gúne Íba re deikké, ítara guzori-guzori hoór de, “Kúruc ot difélo, Ibá re kúruc ot dífelo!” Filate ítara re hoór de, “Añí toh Ibá ttu honó hosúri no fair, hétolla Ibá re tuáñra loizai kúruc ot dógoi.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yohúdi gúne yóggwa re zuwab der de, “Añára ttu ekkán córiyot asé, aar hé córiyot mozin Ibá ttu morar zorur, kiyólla-hoilé Ibá ye Nizoré Nize Allar Fua dabi goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Zeñtté Filate hotá híyan fúinne, yóggwa aró ḍooraigiyói, ");
INSERT INTO rhgc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","aar razmohól or bútore abar góli Isá re hoór de, “Tuñí hoṛíyar?” Montor Isá ye yóggwa re honó zuwab nó déh. ");
INSERT INTO rhgc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hétolla Filate Íba re hoór de, “Tuñí añr llói hotá no hoibá níki? Tuñí kí no zano, añr ttu Tuáñre eridibar óu kémota asé deh, aar kúruc ot díbar óu kémota asé dé?” ");
INSERT INTO rhgc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isá ye yóggwa re zuwab der de, “Zodi tuáñre uottú kémota diiya no zayto, tóoile Añr uore tuáñr honó kémota no tákito. Hétolla zee niki Añré tuáñr hañse gosáidiye ítar guná aró ḍoóñr.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hé októt lóti Filate Isá re eridibar kucíc goijjíl, montor Yohúdi gúne guzori-guzori howát accíl de, “Tuñí zodi e Manúc cwa re erido, tóoile tuñí Káisar or dustó no. Zee niki nizoré nize baáñcca dabi goré, íte toh Káisar or duccon.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hétolla, zeñtté Filate híyan fúinne, yóggwa ye Isá re baáre ainné, baade ze zaga gán ore Fattór-or-Uṛán hoó, aar Hibrú zuban ot Gabbata bouli hoó, híyan ot bisar or toktót boiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hé din nwá accíl Azadir-id or toiyarir din, aar héñtte din or duúñijja ánik óiye. Filate Yohúdi gún ore hoór de, “Soó, tuáñrar Baáñcca!” ");
INSERT INTO rhgc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Montor ítara guzori-guzori hoór de, “Dur goró, dur goró, Ibá re kúruc ot dífelo!” Filate ítara ttu fusár gorér de, “Tuáñrar Baáñcca re añí kúruc ot dífelaitam?” Ḍoóñr imam ókkole zuwab der de, “Añára ttu Káisar bade ar honó baáñcca nái.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tói kúruc ot dí marifélai bolla Filate Isá re ítarar hañse gosáidiye. Baade ítara Isá re loigiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Isá ye Nizor kúruc Nize hañd ot looi baáre Matár-Mala hoó de zaga foijjonto loigiyé, ziyán ore Hibrú zuban ot Golgota bouli hoó. ");
INSERT INTO rhgc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Héṛe ítara Íba re edde Íbar fúañti ar dui zon manúc ore kúruc ot díye, ezzon ore ek kultú ek kultú, aar Isá re mazé. ");
INSERT INTO rhgc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Filate ekkán sáainbúṭ óu lekí Isár kúruc ot maridíl. Híyan ot leikkíl de: Isá Nasári, Yohúdi ókkol or Baáñcca. ");
INSERT INTO rhgc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Boóut Yohúdi ókkole hé sáainbúṭ ṭán foijjíl, kiyólla-hoilé ze zaga gán ot Isá re kúruc ot díyl híyan cóor or ḍáke; aar sáainbúṭ ṭán Hibrú, Girík edde Leṭín zuban ot leikkíl. ");
INSERT INTO rhgc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Híyan dekí Yohúdir ḍoóñr imam múne Filat ore hoiyé de, “‘Yohúdi ókkol or Baáñcca’ no lekíyo, bólke endilla lekó, ‘Ibá ye hoitó de, Añí óilam de Yohúdi ókkol or Baáñcca.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Filate zuwab diyé de, “Añí leikkí de híyan añí leikkí.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Fóous ókkole Isá re kúruc ot dí baade, ítara Íbar uoror hoor kúli looi sair bák goijjé, ek fóous olla ek bák or dóre; ítara Íbar zubba wa yó loiyé. Hé zubba wa honó zuradiya sára, aar uottú lóti nise foijjonto ek hoor. ");
INSERT INTO rhgc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ítara ezzon ore ezzone hoór de, “Añára e zubba wa no fáṛi, bólke loṭári mari saái yibá har héṛe fore.” Híyan etollá óiye, zeéne pak-kalam or yián fura ó, “Ítarar bútore añr hoor ore borat goijjé, aar ítara añr hoor olla loṭári maijjé.” Fóous súne héndilla híin hétolla goijjé deh. ");
INSERT INTO rhgc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Isár kúruc or ḍáke Íbar maa, Íbar maar bóin, aar Klopas or bou Moriyam edde Moriyam Makdálini tíyai accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Zeñtté Isá ye Nizor maa re edde Nize ador goittó de cárit twa re ḍáke tíyaiya deikké, Íba ye maa re hoór de, “Ó maa, soó tuáñr fua óilde ibá.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Baade hé cárit twa re hoór de, “Soó, tuáñr maa óilde ibáh.” Héñtte lóti hé cárit twa ye híba re yóggwar nizor gór ot loigílgoi. ");
INSERT INTO rhgc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yárbaade, Isá ye hárr kessú goijjá óigiyoi de híyan hoi fari, pak-kalam fura ói bolla hoór de, “Añr ttu tirác laiggé.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hé zagat eggwá sírkar tára buágaraiya accíl; ítara híbat ekkán esfónj burai yore hísop-gas or eggwá ḍéeilar matát bazáidi Isár gal ot diiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zeñtté Isá ttu hé sírka háiya óiye, Íba ye hoór de, “Goijjá óigiyoi.” Tarfore matá re hémmikka gorí Íbar foran difélaiye. ");
INSERT INTO rhgc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hé din nwá zettót ebaadot-or-din or toiyarir din accíl, ebaadot-or-din kúruc ot honó lac no táke fán Yohúdi ókkole Filat ore aros goijjé de, zetará kúruc ot asé ítarar ṭéng gún báñgidi ítarar lac lamaifélai bolla, kiyólla-hoilé ebaadot-or-din nwá háas accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tói fóous ókkol aái, Isár fúañti kúruc ot díya gíyl de ítarar ṭéng gún báñgidil, age ezzon or, baade ar ezzon or. ");
INSERT INTO rhgc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lekin zeñtté ítara Isár íñyot aái Íba morigiyói de deikké, ítara Íbar ṭéng nó báñge. ");
INSERT INTO rhgc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Montor eggwá fóouse Isár gaar ḍák bay sél maijjé, aar éhon héntu lou edde faní neeliaiccíl. ");
INSERT INTO rhgc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nizor suké deikké de yóggwa ye beh híyan gobá díye, aar yóggwar gobá sóiyi; yóggwa ye zane de yóggwa sóiyi gán hoór de, zeéne tuáñra yó ekin goró. ");
INSERT INTO rhgc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Híin etollá óiye, zeéne pak-kalam or yián fura ó, “Íbar ekkán áñḍḍi úddwa báñga no zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pak-kalam ot yián óu asé, “Ítara zibá re gañitté Íbar híkka ítara saái tákibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Híin baade, Aramátiya cóor or Yusúfe Isár lac loizaitói Filat ottu ezazot maiggíl. Yusúf accíl de Isár ézzon lukaiya ummot, kiyólla-hoilé yóggwa ye Yohúdir neta ókkol ore ḍooraitó. Filat or ezazot fai yore yóggwa aái Isár lac loigiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Fúañti Nikódemas zee niki age raitta Isár héṛe giíl, yóggwa yó aiccé; yóggwa ye mur añtor edde alóh-gas miyái banaiya tiríc tin cér ánik kúcbor guri ainníl. ");
INSERT INTO rhgc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tarfore ítara Isár lac cwa loizai kúcbo gún dii fúñtar hoor lói hohón solaiyé, zendilla Yohúdi ókkol ottu dohón gorár niyom asé. ");
INSERT INTO rhgc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ze zagat Isá re kúruc ot díyl héṛe ekkán bagan accíl, aar hé bagan ot eggwá noya hobor accíl, zibát honódin honókiyo re dohón goráil de nái. ");
INSERT INTO rhgc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hé din nwá Yohúdir ebaadot-or-din or toiyarir din ísafe, hé hobor gwá zettót ḍáke, ítara Isá re yíbat dohón gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Háftar foóila din fózor októt andár tákite, Moriyam Makdálini hobor gwat giiyé, aar deikké de, hobor or muk ottu cíl lan larifelaiya. ");
INSERT INTO rhgc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hétunot híba duñri Sáimon Fitor edde oinno cárit zibá re Isá ye muhábbot goittó, ítarar héṛe giiyé, zai ítara re hoór de, “Maincé Malik ore hobor ottu loigiyégoi; ítara Íba re hoṛé eijjégoi añára no zani.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hétunot Fitor edde hé oinno cárit twa neeli hobor ot zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ítara duní zon ekku fúañti duñrat accíl, montor oinno cárit twa Fitor ore bárai zai hobor ot age foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yóggwa ye niyúri bútormíkka saiyé rár, hohón or hoor gún asé de deikké, montor yóggwa bútore nó zah. ");
INSERT INTO rhgc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tarfore Sáimon Fitor óu yóggwar fisé-fisé aái foóñicce, aar hobor gwar bútore góille; yóggwa ye yó hohón or hoor gún asé de deikké, ");
INSERT INTO rhgc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aar ze hoor gán Isár matát beráidil híyan hohón or hoor or fúañti nái, bólke alok gori ekkán ot boiṭṭa. ");
INSERT INTO rhgc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hétunot ze oinno cárit twa hobor ot age foóñiccil, yóggwa yó bútore góille, aar dekí biccác goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kiyólla-hoilé hétun foijjonto toh ítara Isá ttu mora ttu zinda ówar zorur de pak-kalam or hé hotá nó buzé. ");
INSERT INTO rhgc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tarfore hé cárit tun nizor gór ot waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lekin Moriyam hobor or baárkule tíyai hañdat accíl; híba hañdi-hañdi niyúri hobor gwar bútormíkka saiyé, ");
INSERT INTO rhgc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","aar deikké de, Isár lac ziyóñt raká gíyl híyoñt dóla hoor findá duwá fírista boói táikke, eggwá cítan ottu, ar eggwá foitán ottu. ");
INSERT INTO rhgc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Híine híba re hoór de, “Ó Mayafua, tui hañdoór kiyá?” Híba ye híin ore hoór de, “Maincé añr Malik ore loigiyégoi; ítara Íba re hoṛé eijjégoi añí no zani.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Híyan hoói baade híba ye fissá fíri dekér de, Isá tíyaiya; montor Íba Isá de híyan híba ye nó siné. ");
INSERT INTO rhgc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Isá ye híba re hoór de, “Ó mayafua, tui hañdoór kiyá? Tui haré tuwoór dé?” Moriyame Isá re bagan sóoñloya bouli ṭáari Íba re hoór de, “Jonáb, Íba re zodi tuñí loigiyó de óile, Íba re hoṛé eijjógoi de añré hoó, añí Íba re loizayúmboi.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isá ye híba re hoór de, “Moriyam!” Moriyame fíri Hibrú zubane Íba re hoór de, “Rabbúni!” ziyán or maáni, Ustat. ");
INSERT INTO rhgc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Isá ye híba re hoór de, “Añré dóri no rakíc, kiyólla-hoilé Añí toh aijjó uore Baf or héṛe nó zaigói; bólke Añr báiyain nún or héṛe zai hoógoi de, ‘Zibá Añr edde tuáñrar Baf, zibá Añr edde tuáñrar Alla, Añí uore Íbar héṛe beh zairgói.’ ” ");
INSERT INTO rhgc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tói Moriyam Makdálini aái cárit tun ore zanaiyé de, híba ye Malik ore deikké, aar híba re hotá híin Íba ye hoiyé deh. ");
INSERT INTO rhgc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hé din or, yáni háftar foóila din or háñzinna, zeñtté Yohúdi ókkol or ḍoore cárit tun zeṛé zoma ói táikke héṛiyar duwar ókkol bañdá accíl, Isá aái ítarar mazé tíyaiye, aar ítara re hoór de, “Assalamu alaikum.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Híyan hoói baade, Íba ye ítara re Íbar duní át edde Íbar gaar ḍák daháiye. Cárit tune Malik ore dekí bicí kúci óiye. ");
INSERT INTO rhgc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Isá ye ítara re abar hoór de, “Assalamu alaikum. Bafe zendilla Añré difeṛáiye, héndilla Añí yó tuáñra re difeṛáir.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Híyan hoói, Íba ye ítarar uore fúu dí hoór de, “Pak-Ruh loo. ");
INSERT INTO rhgc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tuáñra zetarár guná maf goríba, ítarar guná maf óibo; aar zetarár guná maf no goríba, ítarar guná maf no óibo.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Montor Tómas, zibá baró zon cárit tun ottu ezzon, zibá re Zooñikka ḍake, yóggwa Isá aiccíl de héñtte ítarar fúañti nu accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hétolla oinno cárit tune yóggwa re hoór de, “Añára Malik ore deikkí.” Montor yóggwa ye ítara re hoór de, “Zetún añí Íbar duní át ot zoloir dak nó dekí aar zoloir zaga híyan ot añr ooñl gólai nó dí edde Íbar ḍák ot añr át gólaidi nó saái, hétun añí biccác no goijjúm.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yár añcṭo din baade, Íbar cárit tun abar gór or bútore zoma óiye, aar Tómas óu ítarar fúañti accíl. Duwar ókkol bañdá de óile yo, Isá aái ítarar mazé tíyaiye, aar hoór de, “Assalamu alaikum.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Baade Íba ye Tómas ore hoór de, “Tor ooñl eṛé an, aar Añr át saá; tor át Añr ḍák ot gólaide. Nabiccác no goríc, bólke biccác gór.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tómase zuwabe Íba re hoór de, “Ó añr Malik, añr Alla!” ");
INSERT INTO rhgc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isá ye yóggwa re hoór de, “Tómas, tui toh Añré deikkós de hétolla éna iman ainnós. Mubarek uitará zetará Añré no dekíle yo toóu iman ané.” ");
INSERT INTO rhgc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Becók, Isá ye Nizor cárit tun or muúntu aró boóut keramot ókkol goijjíl, ziín ore e síyarat leká nó zah; ");
INSERT INTO rhgc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","montor iín ore etollá leká gíyeh zeéne tuáñra iman anó de, Isá óilde Mosih, Allar Fua; aar héndilla iman aní tuáñra zen Íbar name zindigi hásil goró. ");
INSERT INTO rhgc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yárbaade, Tibiriyas Ḍiír hañsat Isá ye abar Nizoré cárit tun or hañse dahádiye. Íba ye Nizoré dahádiye de endilla gori: ");
INSERT INTO rhgc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sáimon Fitor, Zooñikka ḍake de Tómas, Galil or Kána farar Natanel, Zebedair fuain, edde Íbar ar dui zon cárit ekkán ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sáimon Fitore ítara re hoór de, “Añí mas saitó zair.” Ítara íba re hoór de, “Tuáñr fúañti añára yó zaiyum.” Tói ítara neeli zai noow ot uiṭṭégoi, montor hé raitta ítara honó mas nó faa. ");
INSERT INTO rhgc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Biínna zeñtté fózor fáṛer, Isá aái ḍiír hañsat tíyai táikke, montor cárit tune Íba Isá de nó siné. ");
INSERT INTO rhgc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Isá ye ítara re hoór de, “Fuain, hái bolla honó mas faiyó né?” Ítara zuwab der de, “Nó fai.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Íba ye ítara re hoór de, “Noowr den ḍák ottu zal félo, kessú mas faiba.” Tói ítara zal félaiye, aar bicí mas foijjé de hétolla ítara zal lan ar ṭani tulí no farer. ");
INSERT INTO rhgc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hétolla, Isá ye muhábbot goittó de cárit twa ye Fitor ore hoór de, “Ibá toh Malik!” Sáimon Fitore Íba Malik de híyan fúinne rár, nizor gaar uoror hoor gán berái fanít záp maijjé. Íba ye híyan ham gorí bolla kúli eijjíl deh. ");
INSERT INTO rhgc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ítara kul ottu bicí duré nu accíl, siríf dui cót át ánik beh duré, hétolla oinno cárit tune mas furaiya zal lan ṭani-ṭani hé gura noow gán ot góri kul ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tarfore zeñtté ítara kul or uore laimmé, deikké de, eggwá ooin or hoilar ṭal, yíbar uore mas edde ruṭi asé. ");
INSERT INTO rhgc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Isá ye ítara re hoór de, “Ehón dóijjo de héntu hooggwá mas anó.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tói Sáimon Fitore noow ot uṛí zal lan ṭani kul or uore ainné. Zal lan ek cóo fonzaic tin nwá ḍoóñr mase furaiya, montor hédun de óile yo zal lan nó fáṛe. ");
INSERT INTO rhgc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isá ye ítara re hoór de, “Aiyó, hána hóogai.” Cárit ítara honó ezzon ottu hímmote nó dede Íba ttu fusár goittó, “Tuñí hon?” Kiyólla-hoilé ítara Íba Malik de híyan zainto. ");
INSERT INTO rhgc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Baade Isá aái, ruṭi looi ítara re diiyé, héndilla, mas óu diiyé. ");
INSERT INTO rhgc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Isá re mora ttu zinda gorázai baade Íba ye cárit tun or hañse Nizoré dahá díyl de ebar óilde tisárabar. ");
INSERT INTO rhgc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aar zeñtté ítara ttu hána háiya óiye, Isá ye Sáimon Fitor ore hoór de, “Yohánnar fua Sáimon, tui Añré itarár túaro muhábbot gorós né?” Íba ye hoór de, “Ói, Malik; Tuñí toh zano, añí Tuáñre ador gorí.” Isá ye íba re hoór de, “Tóoile Añr bérasóol-or-sóo gún sora.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Isá ye íba re dusárabar hoór de, “Yohánnar fua Sáimon, tui Añré muhábbot gorós né?” Íba ye hoór de, “Ói, Malik; Tuñí toh zano, añí Tuáñre ador gorí.” Isá ye íba re hoór de, “Tóoile Añr bérasóol lun ore saásita gór.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Isá ye íba re tisárabar hoór de, “Yohánnar fua Sáimon, tui Añré ador gorós né?” Fitor ebar guccá óigiyoi, kiyólla-hoilé Íba ye e tisárabar óu fusár goijjé de, “Tui Añré ador gorós né?” Fitore Íba re hoór de, “Malik, Tuñí toh hárr kessú zano; Tuñí zano añí Tuáñre ador gorí deh.” Isá ye íba re hoór de, “Añr bérasóol lun sora. ");
INSERT INTO rhgc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Añí toré sóiyi-sóiyi hoóir, zeñtté tui juwan accíli, héñtte toh tui nizor keeñil bañdí zeṛé monehoó héṛe zaiti; montor zeñtté tui burá óibi, héñtte tui tor át ṭani dibi, aar oinno zone tor keeñil bañdí tor ttu zeṛé mone no hoó héṛe toré loizaibó.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Allar mohíma zahér ói bolla Fitor hondilla moote moribó de híyan buzái bolla beh Isá ye hé hotá hoiyé. Híyan hoói baade Isá ye íba re hoór de, “Añr fuñde-fuñde ai.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Fitore fissá fíri dekér de, Isá ye muhábbot goré de cárit twa fuñde-fuñde aiyér, yóggwa óilde ubá zee niki hána háibarcot Isár gaat élandi fusár goijjíl de, “Malik, Tuáñre dóridibo de íba hon?” ");
INSERT INTO rhgc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yóggwa re dekí Fitore Isá re hoór de, “Malik, manúc ubár hálot kii óibo?” ");
INSERT INTO rhgc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isá ye Fitor ore hoór de, “Zodi Añr ttu monehoó, Añí waafes nú aiyí foijjonto íba basi tákouk, tóoile híyan tor loi kii bazá? Tui Añr fuñde-fuñde ai.” ");
INSERT INTO rhgc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hétolla bóuli imandár báiyain dor bútore fóligiyoi de, hé cárit twa no moribó. Lekin Isá ye yóggwa no moribó bóuli nó hoó, bólke siríf hoiyé de, “Zodi Añr ttu monehoó, Añí waafes nú aiyí foijjonto íba basi tákouk, tóoile híyan tor loi kii bazá?” ");
INSERT INTO rhgc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hé cárit twa óilde ibá zee niki edún iín beggún or gobá der, edde iín leikké. Añára zani, yóggwar gobá sóiyi. ");
INSERT INTO rhgc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isá ye aró boóut kessú goijjé de asé, zodi híin ore ekkán-ekkán góri leká zayto, tóoile añr kíyal mozin, odún kitab leká zayto, ziín fura duniyait úddwa nu añṛitó.");
INSERT INTO rhgc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ó jonáb Tiyofílas, añr agor kitab ot añí uúin beggún or baabute beh leikkí, ziín Isá ye cúru ttu lóti goijjíl edde taalim dyíl, ");
INSERT INTO rhgc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","oh din foijjonto ze din Íba re asman ot tulífela gíyeh. Zaibar age Íba ye Nizor basíloiya sáhabi gún ore Pak-Ruhr duara hédaiyot ókkol diíl. ");
INSERT INTO rhgc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Íba ye duk fai baade ítarar hañse Nizoré zahér goijjíl, aar Íba zinda asé de híyan biccác gorá zah de héndilla boóut sábut ókkol diíl. Íba ye ítara re salic din foijjonto dahá dídi Allar raijjor baabute howát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ítarar fúañti tákite, Íba ye ítara re e hókum man dyíl, “Tuáñra Jerúsalem sári no zaiyogói, bólke Baf or waada goijjá hádiyar entezar goró, ziyán or baabute tuáñra Añr ttu fúinno. ");
INSERT INTO rhgc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kiyólla-hoilé Yaháya ye toh fanít éna bápṭisma díye, montor yaar hooddin or bútore tuáñra re Pak-Ruh lói bápṭisma díya zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hétolla zeñtté ítara ekkán ot zoma óiye, ítara Isá ttu fusár gorér de, “Malik, Tuñí e októt Boni Isráil ore raijjo waafes loidiba niki?” ");
INSERT INTO rhgc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Íba ye ítara re zuwab der de, “Ze októ edde tarík Bafe Nizor adíkare ṭík gorí raikké, híin zanon tuáñrar ham no. ");
INSERT INTO rhgc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Montor zeñtté tuáñrar uore Pak-Ruh aibó, tuáñra bol faiba; aar Jerúsalem ot, Yohúdiyar edde Samáriar agagurat, edde duniyair céc matá foijjonto tuáñra Añr gobá óiba.” ");
INSERT INTO rhgc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Híin hoói baade, ítarar suk or muúntu Íba re tulífela gíyeh, aar ekkán miyúla ye Íba re ítarar nozor ottu argwal gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Íba zaargói de híyala ítara asman or uzu suk lagaidi saái táikke de októt, asimbit dui zon dóla hoor findá manúc ítarar ḍák ottu tíyaiye, ");
INSERT INTO rhgc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","aar hoór de, “Ó Galil or manúc ókkol, tuáñra tíyai asman or uzu kiyá saái táikko? E Isá, zibá re tuáñrar hañsóttu asman ot tulífela gíyeh, Íba zendilla gori asman ot zaargói de deikkó héndilla góri waafes aibó.” ");
INSERT INTO rhgc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yárbaade, sáhabi gún Zaitun Faár hoó de yíba ttu Jerúsalem ot waafes giiyégoi. Hé faár gwá cóor ottu tokoriban adá mail duré accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ítara cóor ot foóñsi uoror ṭalar kamárat giiyé, zeṛé ítara tákito. Ítara óilde: Fitor, Yohánna, Yakub, Enderiyas, Filíp, Tómas, Bartólomiyo, Moti, Alfáiyas or fua Yakub, Sáimon zibá ézzon Zélot, edde Yakub or fua Yohúdah. ");
INSERT INTO rhgc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ítara beggúne Isár maa Moriyam, oinno hoozzon mayafuain, edde Isár báiyain dor fúañti ek mone nitti dua goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hé din ókkol ot zeñtté tokoriban ek-có kuri zon imandár zoma óiye, Fitor uṛí ítara re hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Báiboináin ókkol, Isá re gereftar-goróya ókkol or foñt daháidoya accíl de Yohúdahr baabute Pak-Ruh ye Dawud or duara hoóil de pak-kalam or hotá híin fura ówar zorur accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kiyólla-hoilé íte toh añárar ḍaái or accíl, aar íte e ham goríbar híssa faáil.” ");
INSERT INTO rhgc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Manúc íte nizor kuham or dam loi ekkán zobin kinné, aar héṛe íte matá hémmikka góri fori ítar feṭ fáṛi yore añtigíla beggún neeligiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Híyan Jerúsalem or manúc beggúne fúinne, hétolla zaga híyan ore ítarar zuban ot Akeldama nam diyé, ziyán or maáni óilde, Lou wor Zobin. ");
INSERT INTO rhgc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Fitore hotá howá zari raikkíl, “Híyan or baabute Zobur Córif ot endilla leikká asé, ‘Ítar bíṛa háli óizoggoi, honókiye híyan ot no tákouk.’ Aró leikká asé, ‘Ítar zimmadari ar ezzone loifelouk.’ ");
INSERT INTO rhgc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Hétolla, añára ttu ar ezzon manúc ore gobá ísafe basílowar zorur. Íba endilla manúc ottu ówa foribó zetará hárr októt añárar fúañti-fúañti sofór gorát accíl, oñtté zeñtté Malik Isá añárar fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yáni zetará Yaháyar bápṭisma ttu lóti cúru gorí Isá re añárar hañsóttu tulífela gíyeh de októ foijjonto accíl, ítara ttu ekzon manúc añárar fúañti gobá bona foribó, Isá mora ttu zinda óiye de híyan or gobá dí bolla.” ");
INSERT INTO rhgc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tói ítara dui zon manúc or baabute mocuwara diyé, ezzon óilde Yusúf, zibá re Barsába ḍake, íba re Yustus óu ḍakitó; aar ar ezzon óilde Mattíyas. ");
INSERT INTO rhgc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Baade ítara dua gorér de, “Ó Malik, Tuñí toh hárr ekzon or dil zano. Tuñí añára re dahó, Tuñí itará dui zon ottu haré basíloiyo, ");
INSERT INTO rhgc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","zeéne yóggwa ye sáhabiham gorí fare, ze ham Yohúdah ye eri zaga waán ot giiyégoi ziyán ot íte zaibar laayek accíl.” ");
INSERT INTO rhgc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Baade ítara tará lla loṭári maijjé rár, Mattíyas or name loṭári foijjíl; tói yóggwa re egaro zon sáhabi gún ot cámil gorá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Zeñtté Penṭikos id or din aiccé, ítara beggún ek zagat zoma accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aar asimbit asman ottu ḍoóñr tuwán or ḍóilla góri eggwá abas aiccé, aar ítara ze gór ot boiṛá accíl híyan hé abase bórigiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ítara ooin or zilhar ḍóilla kessú deikké, ziyán zir or súrot. Híyan bák-bák ói ítara fottí ekzon or uore boiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ítara beggún Pak-Ruh lói furaiya óiye, aar hé Ruhr diiya toóufike alok-alok zubane hotá howát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Héñtte duniyair hárr dec or dindár Yohúdi ókkol Jerúsalem ot tákito. ");
INSERT INTO rhgc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Zeñtté hé abas swá fúna gíyeh, manúc ókkol ekkán ot zoma óigiyoi, aar tarár nizor-nizor zubane imandár ókkole hotá hoór de fúni, tará buddí háraiya óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tará ammúk edde taajup ói hoór de, “Soó, hotá hoór de ítara beggún Galil or manúc de nó né? ");
INSERT INTO rhgc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tói añára fottíkiye kiyá ítara añárar maayi zubane hotá hoór de fúnir? ");
INSERT INTO rhgc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Añára toh Partiyi, Mediyi, edde Elami ókkol, aar Mesopóṭomiyar, Yohúdiyar, Kappadókiyar, Pontus or, edde Ecíyar bácinda ókkol, ");
INSERT INTO rhgc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","aró, Fergiyar, Pampúliyar, Ijíp or, edde Kurenir ḍákor Liíbiyar atehañsór bácinda ókkol. Aar Rom ottu yó hodún así. ");
INSERT INTO rhgc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Eṛé Yohúdi ókkol óu asé aar Yohúdir dórmot faráiye de Beyohúdi ókkol óu asé. Héndilla, Kereti edde Arob koum óu asé. Añára beggúne de ítara añárar nizor-nizor zubane Allar bicí ḍoóñr-ḍoóñr harhána ókkol or baabute hoór de fúnir!” ");
INSERT INTO rhgc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tará beggún ammúk edde buddí háraiya ói ezzon ore ezzone hoór de, “Iín kiyólla óitofare?” ");
INSERT INTO rhgc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Montor hodúne técerai hoór de, “Itará córab hái ṭuúl óigiyoi deh!” ");
INSERT INTO rhgc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Montor Fitore baki egaro zon sáhabi gún lói tíyai guzori-guzori manúc ókkol ore boiyan gorér de, “Ó Yohúdiyar manúc edde Jerúsalem ot táko de tamám manúc ókkol, híyan añí tuáñra re buzái díh; añr hotá gún díyan dí fúno. ");
INSERT INTO rhgc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tuáñra ṭáaror de héndilla itará nicá hái ṭuúl óiye de no, kiyólla-hoilé aijjó toh biínnar now wa éna baijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bólke yián óilde waán, ziyán nobi Yoél or áta howá gíyl, ki hoilé ");
INSERT INTO rhgc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Alla ye fórmar de, Añí ahéri zobanat endilla goijjúm: Añí Añr Ruh fottí insán or uore ḍálidiyum. Tuáñrar morotfuain de edde zérfuain de Añr kalam boiyan goríbo, tuáñrar juwan maincé dorcón dekíbo, aar tuáñrar burá maincé cóppon dekíbo. ");
INSERT INTO rhgc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Añr gulam edde bañdi ókkol or uore yó hé din ókkol ot Añr Ruh ḍálidiyum, aar ítara Añr kalam boiyan goríbo. ");
INSERT INTO rhgc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aar Añí uore asman ot taajuippa harhána ókkol daháiyum, aar nise zobin ot illayi-nicán ókkol daháiyum. Yáni lou, ooin edde dúañr miyúla ókkol daháiyum. ");
INSERT INTO rhgc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mabud or hé ḍoóñr edde mohíma ola din aibár age, beil andár óizayboi, aar san lou wór ḍóilla óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aar eén óibo, zee niki Mabud or nam loibo, íte nejat faibo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ó Boni Isráil ókkol, hotá iín fúno: Isá Nasári, Zibár duara Alla ye tuáñrar hañse keramot, taajuippa harhána edde illayi-nicán ókkol dahái sábut goijjé de, Íba óilde Allar torfóttu; tuáñra nize toh híyan zano. ");
INSERT INTO rhgc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Alla, zibá ye muúmor hálot zane, Íba ye age lóti fáisela goijjé de, Isá re tuáñrar át ot gosáidi bolla. Aar tuáñra toh Íba re bedini ókkol or áta kúruc ot dí mariféla báila. ");
INSERT INTO rhgc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Montor Alla ye Íba re moot or duk ottu azad gorí abar zinda goijjé, kiyólla-hoilé moote Íba re nizor kobzat rakí nó fare. ");
INSERT INTO rhgc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Íbar baabute Dawude toh endilla hoóil, ki hoilé, ‘Añí Malik ore añr muúntu hámica dekítam, kiyólla-hoilé Íba añr den ḍák ottu asé, zeéne añí no hafi. ");
INSERT INTO rhgc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hétolla añr dil kúci óiye, aar añr zire kúcir hotá hoór. Añr gaar haiya yó acáye basi tákibo, ");
INSERT INTO rhgc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kiyólla-hoilé Tuñí añr ruh re fatalfur ot félai no rakíba, aar Tuñí Tuáñr Pakzon or gaar haiya re foñsitó no diba. ");
INSERT INTO rhgc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tuñí añré zindigir rasta daháiyo; Tuñí añré Tuáñr háziri lói furafuri kúci goríba.’ ");
INSERT INTO rhgc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Báiyain, añí tuáñra re bafdada Dawud or baabute sáf-sáf góri hoói faijjum de ki, íba morigiyói, aar íba re dohón gorífela gíyl; íbar hobor aijjó foijjonto añárar fúañti eṛé asé. ");
INSERT INTO rhgc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Íba toh éggwa nobi accíl; íba ye zainto de, Alla ye hosóm hái íba llói waada goijjíl de ki, íbar nosól ottu ekzon ore íbar toktót buágaraibo. ");
INSERT INTO rhgc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Muúntu kii óibo de híyan dekí fari íba ye Mosih zinda ówar baabute endilla hoiyé, ‘Íba re no fatalfur ot félaidiya gíyeh, aar no Íbar haiya foñiccé.’ ");
INSERT INTO rhgc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Alla ye hé Isá re zinda goijjé, añára beggún híyan or gobá así. ");
INSERT INTO rhgc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hétolla Íba re Allar den ḍák ottu boibár tokka diiya giyéh, aar Íba ye Baf or torfóttu waada goijjá Pak-Ruh faáil; yala tuáñra ziín dekór edde fúnor híin Íba ye ḍálidiye deh. ");
INSERT INTO rhgc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kiyólla-hoilé Dawud nize toh asman ot nó uṛé, montor toóu íba nize hoiyé de, ‘Mabude añr Malik ore hoór de, Añr den ḍák ottu boiyó, ");
INSERT INTO rhgc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","zetukkún foijjonto Añí Tuáñr duccon ókkol ore Tuáñr foor tole gorí nó felai.’ ");
INSERT INTO rhgc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hétolla tamám Boni Isráil ókkole yián fakkagori zanilo de ki, tuáñra kúruc ot dí marifélaila de hé Isá re Alla ye Malik edde Mosih banaiyé.” ");
INSERT INTO rhgc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Híyan fúni manúc ókkol ottu dil ot sél maijje fán laiggé; ítara Fitor ore edde oinno sáhabi gún ore hoór de, “Báiyain, añára kii goittám?” ");
INSERT INTO rhgc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Fitore ítara re zuwab der de, “Tuáñra fottíkiye touwá goró, aar gunár maf fai bolla Isá Mosihr name bápṭisma loh; tói tuáñra hádiya ísafe Pak-Ruh faiba. ");
INSERT INTO rhgc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kiyólla-hoilé hé waada toh tuáñra lla, tuáñrar fuain dor lla, edde zetará duré asé ítara lla—zetó zon ore añárar Mabud Alla ye Nizor híkka ḍakibó.” ");
INSERT INTO rhgc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Fitore ítara re aró boóut hotá ókkol hoói nosíyot goijjíl, aar aros gorér de, “E zobanar báañra manúc ókkol ottu nizoré basai rakíyo.” ");
INSERT INTO rhgc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Zedúne íbar boiyan kobul goijjé, ítara bápṭisma loiyé; hé din ítarar dol ot tokoriban tin ázar manúc cámil gorá gíyl. ");
INSERT INTO rhgc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tará sáhabi gún ottu hámica taalim fúinto, ar ítara llói bóng góri ruṭi háito edde dua goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Manúc beggúne ḍooraitó, kiyólla-hoilé sáhabi gúne boóut taajuippa harhána ókkol edde illayi-nicán ókkol daháito. ");
INSERT INTO rhgc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tamám imandár ókkol ek zagat tákito, aar hárr kessú milizúli estemal goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ítara nizor malsámana edde dón-cómbotti ókkol besi yore fottí zon ore zorurot mozin baṛidito. ");
INSERT INTO rhgc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aar fottí din baitul-mukaddos ot ekku fúañti zoma óito, aar góre-góre ruṭi báñgi kúcir sáañte edde dil or ehélase hána háito. ");
INSERT INTO rhgc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ítara Allar taarif gorát tákito, aar manúc beggún lói boni tákito. Zará nejat faito, tará re Malike fottí din ítarar dol ot cámil goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ek din Fitor edde Yohánna duar októt, yáni tin nwá báze, uore baitul-mukaddos ot zaar. ");
INSERT INTO rhgc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Héṛe ézzon zormo ttu lóti leng manúc ore maincé baitul-mukaddos or Cúndor nam or dorozat aní fottí din buágarai rakíto, zeéne yóggwa ye baitul-mukaddos ot góle de ítara ttu hórat magi fare. ");
INSERT INTO rhgc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yóggwa ye zeñtté Fitor edde Yohánna re baitul-mukaddos or bútore góler de deikké, yóggwa ye ítara ttu hórat maiggé. ");
INSERT INTO rhgc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Fitor edde Yohánna ye yóggwar uzu díyan dóri saái hoór de, “Añárar híkka soó!” ");
INSERT INTO rhgc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hétunot yóggwa ye ítara ttu kessú faibar acáye ítarar uzu díyan dóri saái táikkil. ");
INSERT INTO rhgc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Montor Fitore yóggwa re hoór de, “Añr ttu toh cúna-cañdi nái, montor ziyán asé híyan tuáñre diir. Nasári Isá Mosihr name uṛí áñṛo!” ");
INSERT INTO rhgc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Baade íba ye yóggwar den át tan dóri yóggwa re tuillé, aar éhon or bútore yóggwar ṭénge edde sulgirá ye bol faiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yóggwa fál mari tíyai áñṛat doijje, aar áñṛi-áñṛi edde fál mari-mari Allar taarif gorí-gorí ítarar fúañti baitul-mukaddos ot góillegoi. ");
INSERT INTO rhgc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tamám manúc ókkole yóggwa áñṛer de edde Allar taarif gorér de dekí, ");
INSERT INTO rhgc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","zani faijjé de, yóggwa óilde ubá zibá ye baitul-mukaddos or Cúndor nam or dorozat boói hórat magitó. Yóggwar uore ziyán óiye híyan dekí ítara bicí taajup edde ammúk óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yóggwa aijjó foijjonto Fitor edde Yohánnar fisá dóri accíl. Manúc beggúne taajup ói ítarar íñyot duñri giiyé, ze zaga gán ore Sóloman or baanḍa hoó. ");
INSERT INTO rhgc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Híyan dekí Fitore manúc ókkol ore hoór de, “Ó Boni Isráil ókkol, tuáñra yián or uore taajup kiyá óiyo? Añára yoggwá re añárar taakote yáh dindáriye áñṛair fángori kiyá tuáñra añárar híkka suk ḍoóñr gorí saái táikko? ");
INSERT INTO rhgc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ibrahím or, Isahák or, edde Yakub or Alla ye, yáni añárar bafdada ókkol or Alla ye Íbar Gulam Isá re mohíma diiyé. Tuáñra de Íba re marifélai bolla dóri díla, aar Filate Íba re eridi bolla fáisela gorí baade yo tuáñra yóggwar muúntu Íba re inkar goijjíla. ");
INSERT INTO rhgc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tuáñra hé Pak edde Insáfwala wa re inkar gorí ezzon kúnire tuáñrar hañse eridi bolla aros goijjíla. ");
INSERT INTO rhgc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tuáñra zindigir Malik ore marifélaila, lekin Alla ye Íba re mora ttu zinda goijjé. Añára híyan or gobá así. ");
INSERT INTO rhgc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Isár nam or uore iman ainné de hétolla e manúc cwa ye bol faiyé, zibá re tuáñra dekór aar sinó. Isár usílaye ze iman aiyé híyane yoggwá re furafuri gom goijjé, zendilla tuáñra dekór. ");
INSERT INTO rhgc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yala, ó báiyain, añí zani tuáñra yó tuáñrar sóddar ókkol or ḍóilla no buzí híyan goijjíla. ");
INSERT INTO rhgc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Montor Alla ye híyan lói waán fura goijjé, ziyán Íba ye tamám nobi ókkol or muké age lóti boiyan goijjíl, ki hoilé, Íbar Mosih ye duk faibo. ");
INSERT INTO rhgc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hétolla touwá goró, aar Allar uzu fíro, zeéne tuáñrar guná fuñsífela zah. Tói Mabud or torfóttu foṭfoiṭṭa goríbar októ aibó, ");
INSERT INTO rhgc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","aar Íba ye Isá re, yáni Mosih re difeṛáibo, zibá re tuáñra lla age lóti basílowa gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hárr kessú noya gori banaibár októ nú aiyé foijjonto Isá ttu asman ot táka foribó, zendilla Alla ye Nizor pak nobi ókkol or muké boóut age lóti hoóil. ");
INSERT INTO rhgc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muúsa ye hoóil de, ‘Tuáñrar Mabud Alla ye tuáñrar báiyain dor bútottu tuáñra lla añr ḍóilla ézzon nobi tulíbo; íba ye tuáñra re ziín hoó híin beggún fúna foribó. ");
INSERT INTO rhgc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Aar eén óibo, zee niki hé nobir hotá no fúnibo, ítare Allar Nizor bonda ttu ekkuware dónco gorífela zaybo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Becók, Sémuel ottu lóti cúru gorí zedún nobi ókkole kalam hoiyé, ítara beggúne e din ókkol or baabute yó boiyan goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tuáñra toh nobi ókkol or edde Alla ye añárar bafdada ókkol lói ze razinama goijjíl híyan or fuain. Alla ye Ibrahím ore hoóil de, ‘Tor nosól or duara duniyair tamám koum ókkole rahámot faibo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hétolla Alla ye Nizor Gulam Isá re basí, agor ttu tuáñrar hañse difeṛáiye, zeéne Íba ye tuáñra fottíkiyo re nizor-nizor burair rasta ttu fírai rahámot dee.” ");
INSERT INTO rhgc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Fitor edde Yohánna ye manúc ókkol ore boiyan gorér de októt, imam ókkol, baitul-mukaddos or sóddar, edde Sadukái ókkol ítarar héṛe aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tará bicí bezar óiye, kiyólla-hoilé sáhabi gúne maincóre taalim der, aar Isá mora ttu zinda óiye de híyan tobolik gorér. ");
INSERT INTO rhgc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tói tará ítara re gereftar gorí tarfor din foijjonto ziyól ot raikkíl, kiyólla-hoilé híyala háñz óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Montor boiyan fúinne de héntu boóut zone iman ainníl, aar imandár ókkol bicí ói tokoriban fañs ázar óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tarfor din, Yohúdir neta ókkol, murubbi ókkol edde alem ókkol Jerúsalem ot zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Héṛe boro imam Hánan accíl, héndilla Káiyafas, Yohánna, edde Alexzendar óu accíl, aar boro imam ókkol or oinno egana-guiccí ókkol óu accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tará ítara re mazé tíyagarai fusár gorér de, “Tuáñra ham yián kiyór taakote yáh har name goijjó dé?” ");
INSERT INTO rhgc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hétunot Fitore Pak-Ruh lói furaiya ói ítara re zuwab der de, “Ó manúc or sóddar ókkol edde murubbi ókkol, ");
INSERT INTO rhgc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","añára ek leng manúc ore bálai goijjí de hétolla zettót yóggwa keéne gom óiye hoói añára re zerá gorá zar, ");
INSERT INTO rhgc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tói tuáñra edde tamám Boni Isráil ókkole yián zanilo de ki, Isá Mosih Nasári, zibá re tuáñra kúruc ot dí marifélaila montor Alla ye mora ttu zinda goijjé, Íbar name beh e manúc cwa furafuri gom ói eṛé tuáñrar muúntu tíyai asé. ");
INSERT INTO rhgc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Íba óilde Ubá zibár baabute pak-kalam ot endilla asé, ‘Ze fattór tuáñra mistíri ókkole inkar goijjíla, yíba beggún or túaro bicí zoruri fattór óiaicce.’ ");
INSERT INTO rhgc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nejat ar honókiyor hañse faa no zah, kiyólla-hoilé asman or nise insán ore ar honó nam diiya nó zah ziyán or usílaye añára nejat fai faittam.” ");
INSERT INTO rhgc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Zeñtté tará Fitor edde Yohánnar hímmot deikké, aar ítara be-elómdar edde torbiyot sára manúc de zani faijjé, tará ammúk óigiyoi; tarfore tará ót faiyé de, ítara Isár fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aar ze manúc cwa re gom gorá gíyl, yóggwa re zettót tará Fitor edde Yohánnar fúañti tíyaiya dekér, tará ttu ítarar hélaf hoibár honó hotá nu accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Montor ítara re fótuayi-mujilíc ottu baáre neeli zai bolla hókum dí yore tará ezzon loi ezzone biyasana gorát doijje, ");
INSERT INTO rhgc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","hoór de, “Añára e manúc itará re lói kii goittám? Kiyólla-hoilé itará ze ḍoóñr keramoti ham goijjé, híyan Jerúsalem or manúc beggúne zane, aar añára toh híyan inkar gorí no faijjum. ");
INSERT INTO rhgc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Montor híyan or baabute maincór bútore ar no fóle fán, e name honókiyo re ar honó hotá no hoi bolla añára itará re horagori úñciyari díh.” ");
INSERT INTO rhgc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Baade tará ítara re matai hókum díye de, Isár name ar bilkúl kessú no hoitó edde honó taalim no dito. ");
INSERT INTO rhgc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Montor Fitor edde Yohánna ye tará re zuwabe hoór de, “Tuáñra nize fáisela goró, Allar nozor ot hon nán sóiyi, tuáñrar hotá fúna né náki Allar hotá fúna? ");
INSERT INTO rhgc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kiyólla-hoilé añára ziín deikkí edde fúinni híin or baabute howá bon gorí no faijjum.” ");
INSERT INTO rhgc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tarfore ítara tará re aró dómki ókkol di baade eridifélaiye. Manúc olla bóuli tará ítara re sáñza díbar fáisela gorí nó fare, kiyólla-hoilé ziyán gorá gíyeh híyan or zoriya manúc beggúne Allar taarif gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kiyólla-hoilé ze manúc cwar uore gom goré de keramot tan gorá gíyeh, yóggwa ttu salic bosór or túaro bicí boc óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fitor edde Yohánna re eridiyé mottor, ítara nizor sáañti ókkol or héṛe waafes giiyégoi, aar ḍoóñr imam ókkole edde murubbi ókkole ítara re ziín hoiyé híin beggún zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Híyan fúni ítara ektofák ói Allar hañse abas tulí dua gorér de, “Ya Malik, asman, zobin, doriya edde híin or bútore ziín asé híin beggún Tuñí éna foida goijjó. ");
INSERT INTO rhgc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tuñí Tuáñr gulam añárar baf Dawud or muké Pak-Ruhr duara hoóila de, ‘Beyohúdi ókkol kiyá rak óiye? Manúc ókkole behar sail kiyá gorér? ");
INSERT INTO rhgc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Duniyair baáñcca ókkol toiyar óiye, aar hákim ókkol fúañti mili zoma óiye Mabud edde Íbar Mosihr ulḍa.’ ");
INSERT INTO rhgc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tuáñr pak Gulam Isá, zibá re Tuñí basíloila, Íbar ulḍa Hérude edde Pontiyus Filate Beyohúdi edde Boni Isráil or fúañti e cóor ot zoma óoil, ");
INSERT INTO rhgc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","uúin gorí bolla ziín óibar fáisela Tuñí age lóti Nizor kudurute edde moncáye gorí raikkíla. ");
INSERT INTO rhgc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yala, ó Mabud, ítarar dómki re soó, aar Tuáñr gulam ókkol ore endilla toóufik doo de ki, ítara zen furafuri hímmot or sáañte Tuáñr kalam hoói fare. ");
INSERT INTO rhgc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tuáñr át baró, zeéne Tuáñr pak Gulam Isár name ítara biyaram ókkol gom gorí fare, aar illayi-nicán ókkol edde taajuippa harhána ókkol dahái fare.” ");
INSERT INTO rhgc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ítara ttu dua goijjá óiye rár, ítara ze zaga gán ot zoma accíl híyan hafi uiṭṭé. Ítara beggún Pak-Ruh lói furaiya óiye, aar hímmot or sáañte Allar kalam howát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tamám imandár ókkol dile mone ek accíl. Ítara honókiye nizor siz ore nizor bouli dabi no goittó, bólke hárr kessú milizúli estemal goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aar sáhabi gúne Malik Isá mora ttu zinda óiye de híyan or baabute ḍoóñr kudurut or sáañte gobá díyat accíl, aar Allar rahámot ítara beggún or uore ódorbaára accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ítarar bútore ezzon óu muútac ot nu accíl, kiyólla-hoilé zetará zaga-zobin or yáh gór or girós accíl, ítara híin besi yore ṭiañ-foicá faito de híin aintó, ");
INSERT INTO rhgc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aar aní yore sáhabi gún or ṭéng or gurat rakíto, baade fottíkiyo re zorurot mozin baṛidiya zayto. ");
INSERT INTO rhgc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Héṛe Leévir háandan ottu Yusúf nam or ézzon manúc accíl, zibá Sáifrus ḍiyat zormo óoil, zibár nam sáhabi gúne Bárnabas díye ziyán or torjuma óilde, Josba-dooya. ");
INSERT INTO rhgc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yóggwa ye nizor zaga ekkán besi, ṭiañ gún aní sáhabi gún or ṭéng or gurat raikkégai. ");
INSERT INTO rhgc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lekin Ananiyas nam or ezzon manúce yó nizor bou Safíra llói ekkán zaga beiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yóggwa ye besar dam ottu kessú ṭiañ nizor lla rakídiye, ziyán or baabute yóggwar bou wé yó furafuri zane, baade argún aní sáhabi gún or ṭéng or gurat raikkégai. ");
INSERT INTO rhgc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Montor Fitore hoór de, “Ananiyas, Cóitane tuáñr dil eéngori kiyá kobza gorífelaiye, zeén níki tuáñre Pak-Ruhr hañse misá hotá howá baiyé, aar zaga besar dam ottu kessú ṭiañ nizor lla rakídiya baiyé? ");
INSERT INTO rhgc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Zaga híyan besibár age yó kí tuáñr nizor nu accíl né? Aar híyan besi baade yo kí ṭiañ gún tuáñr át ot nu accíl né? Tuñí e ham gorí bolla kiyá tuáñr dil ot niyot goijjó? Tuñí insán ore misá hotá hoiyó de no, bólke Alla re.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hotá híin fúni mottor Ananiyas dorótgori fori morigiyói. Aar zetará hé hálot tan fúinne ítara beggún bicí ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tarfore juwan fuain ókkol uṛí aái yóggwar gaat hohón solaiyé, aar baáre loizai dohón gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tin gónḍa ánik baade yóggwar bou Safíra bútore aiccé, montor ziín óiye híin híba ye no zane. ");
INSERT INTO rhgc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fitore híba ttu fusár gorér de, “Añré hoósai, tuñí edde tuáñr hócome zaga gán e dore beiccó de né?” Híba ye zuwab der de, “Jii, hé dore beiccí deh.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tói Fitore híba re hoór de, “Mabud or Ruh re entán gorí bolla kiyá tuáñra ezzon loi ezzon razi óiyo? Soó, tuáñr hócom ore dohón gorí aiccé de ítara duwar or ḍáke tíyai asé, aar ítara tuáñre yó tulí baáre loizaybói.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Híba éhon or bútore Fitor or ṭéng ot dorótgori fori morigiyói. Aar juwan fuain núne bútore aái dekér de, híba mora, tói híba re baáre loizai hócom or ḍáke góri dohón gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hétolla fura zomát ot edde zetará híin fúinne ítara beggún or bútore ḍoor góligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sáhabi gúne manúc ókkol or bútore boóut illayi-nicán edde taajuippa harhána ókkol daháito, aar imandár ókkol beggún ekku fúañti Sóloman or baanḍat zoma óito. ");
INSERT INTO rhgc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Maincé ítara re bicí izzot goittó, montor ítarar dol ot cámil ói bolla ar honókiye hímmot no goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Toóu Malik or uore iman ainné de aró boóut mayafuain edde morotfuain loi ítarar dol lagatar barát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sáhabi gúne gorér de ham or zoriya, manúc ókkole biyaraimma ókkol ore aní rasta-rasta gadir uore edde háiṭṭar uore neṛai rakíto, zeéne Fitor hé boli zailé íbar sába ítara kessú manúc or uore fore. ");
INSERT INTO rhgc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerúsalem or atehañsór cóor ókkol ottu yó maincé fúañti biyaraimma edde hóraf jine faiya manúc ókkol ore aintó, aar ítara beggún ore gom gorá zayto. ");
INSERT INTO rhgc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Baade boro imam edde yóggwar sáañti ókkol, zetará Sadukái fírkar manúc, ítara beggún ricé furaiya óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ítara sáhabi gún ore gereftar gorí córkari ziyól ot díye. ");
INSERT INTO rhgc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Montor raitta Mabud or ek fírista ye ziyól or doroza kúli ítara re baáre neelai aní hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Zoo, baitul-mukaddos ot tíyai manúc ókkol ore e noya zindigir hotá beggún boiyan gorógoi.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Híyan fúni ítara biínna sóore baitul-mukaddos ot góli taalim diyat doijje. Boro imame edde yóggwar sáañti ókkole héṛe foóñsi, fótuayi-mujilíc ṭíya re míṭing gorí bolla ḍaikké, yáni Boni Isráil or murubbi beggún ore. Tarfore sáhabi gún ore ziyól ottu tarár hañse aná zay bolla hókum foóñsaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lekin baitul-mukaddos or faáradar ókkol héṛe aái, sáhabi gún ore ziyól-hánat loot nó faa. Hétolla ítara waafes zai hóbor díye de, ");
INSERT INTO rhgc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Añára ziyól-hána gán mozbut gori ṭala maijja edde doroza ókkol ot faáradar ókkol tíyai táikka loot faiyí, montor doroza kúilli rár, bútore honókiyo re loot nó fai.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Híyan fúni baitul-mukaddos or faáradar ókkol or mazí ye edde ḍoóñr imam ókkole yaa kii óibo hoi buddí háraiya óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hétunot ezzone aái tará re hoór de, “Soó, ze manúc cún ore tuáñra ziyól ot díla, ítara baitul-mukaddos ot tíyai maincóre taalim der.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tói hé mazí wa ye faáradar ókkol loizai sáhabi gún ore waafes ainné, lekin bolazuri gorí no, kiyólla-hoilé tará maincé cíl or dola maribó bóuli ḍooraáil. ");
INSERT INTO rhgc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tará ítara re aní, fótuayi-mujilíc or muúntu tíyagaraiye. Boro imame ítara ttu fusár gorér de, ");
INSERT INTO rhgc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Añára toh tuáñra re e name taalim no di bolla horagori úñciyari dílam, montor toóu úddwa deh tuáñrar taalim loi Jerúsalem bóraifelaiyo, aar tuáñra añára re e Manúc cwar lou wór hosúrbon ṭóoraito soór.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hétunot Fitore edde oinno sáhabi gúne zuwab der de, “Añára ttu insán or hókum manar túaro Allar hókum manon fóros. ");
INSERT INTO rhgc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Añárar bafdada ókkol or Alla ye Isá re zinda goijjé, zibá re tuáñra kúruc ot ṭaki marifélaila. ");
INSERT INTO rhgc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Íba re Alla ye Sóddar edde Nejatdoya ísafe Nizor den ḍák ottu boibár tokka diiyé, zeéne Íba ye Isráili ókkol ore touwá goríbar edde guná maf faibar mouka dii fare. ");
INSERT INTO rhgc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Añára nize híin or gobá así aar Pak-Ruh yó asé, zibá re Alla ye uitará re diiyé zetará Íbar hókum ókkol amól goré.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Híyan fúni tará ttu bicí guccá uiṭṭé, aar ítara re marifélaito monehoóil. ");
INSERT INTO rhgc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Montor Gamaliel nam or ezzon Féroci zibá Córiyot or alem aar manúc beggúne izzot goittó, yóggwa ye fótuayi-mujilíc ot tíyai hókum díye de, sáhabi gún ore essát olla baáre neelai rakíto. ");
INSERT INTO rhgc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Baade yóggwa ye tará re hoór de, “Ó Boni Isráil ókkol, tuáñra e manúc itará re ziyán goittó soór híyan úñciyare goijjó. ");
INSERT INTO rhgc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kiyólla-hoilé yaar hooddin age Teyúdas hoó de íte uṛí, nize eggwá sóddar hoi dabi goijjíl; aar tokoriban sair cót manúc ítar bóng ot córik óoil. Montor ítare mariféla gíyeh aar ítar llói bóng óoil de ítara beggún dorbodor óigilgoi aar kessú ói nó fare. ");
INSERT INTO rhgc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Íte baade, Galil or Yohúdah ye manúc seráng gorá zar de októt uṛí bicí manúc nizor híkka gorífelail. Ítare yó mariféla gíyeh, aar ítar manúc beggún óu dorbodor óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hétolla bóuli ehón añí tuáñra re hoóir, tuáñra e manúc itará ttu duré táikko; itará zoggói; kiyólla-hoilé zodi itarár erada edde ham insán or torfóttu de ó, tóoile híin toh nac óizayboi. ");
INSERT INTO rhgc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Montor zodi Allar torfóttu de ó, tuáñra itará re bon gorí no faribá. Zodi goró, tuáñra Allar ulḍa larái-goróya ṭóoriba de baná.” ");
INSERT INTO rhgc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tará Gamaliel or buddí dóijje, aar sáhabi gún ore bútore matai yore soóñk mara baiyé. Baade ítara re hókum díye de, Isár name honó hotá no hoitó, tarfore ítara re eridifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ítara fótuayi-mujilíc ottu zaibarcót bicí kúci accíl, kiyólla-hoilé Alla ye ítara re Isár wasté beizzot óibar laayek goinné. ");
INSERT INTO rhgc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aar ítara fottí din baitul-mukaddos ot edde góre-góre zai-zai lagatar taalim diyat edde tobolik gorát accíl de ki, Isá óilde Mosih. ");
INSERT INTO rhgc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hé din ókkol ot zeñtté ummot ókkol bicí ór, ítarar bútottu ze Yohúdi ókkole Girík zubane hotá hoitó ítara Hibrú zubane hotá hoitó de Yohúdi ókkol or ulḍa cékayot gorát doijje, kiyólla-hoilé fottí din hána baṛidibarcót ítarar rari ókkole no faito. ");
INSERT INTO rhgc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tói baró zon sáhabi gúne ummot ókkol beggún ore ekkán ot zoma gorí hoór de, “Allar kalam tobolik gorár ham bad di hána baṛidiyat lagi tákon añára lla ṭík no. ");
INSERT INTO rhgc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hétolla, ó báiyain, tuáñrar bútottu háñt zon izzotdár manúc basó, zetará Pak-Ruh lói edde buddí lói furaiya. Añára ítara re e ham or zimma gán gosáidiyum, ");
INSERT INTO rhgc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","aar añára dua gorát edde kalam tobolik gorát lagi tákiyum.” ");
INSERT INTO rhgc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zomát or manúc beggún hé hotát razi óiye. Baade ítara Esṭífen ore basíloiye, zibá imane edde Pak-Ruh lói furaiya, aró Filíp ore, Porokóras ore, Nikáno ore, Timon ore, Parménas ore, edde Enṭiyok or Nikólas ore. Hé Nikólas ézzon Beyohúdi de óile yo Yohúdir dórmo mainto. ");
INSERT INTO rhgc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ítara tará re sáhabi gún or muúntu házir goijjé, aar sáhabi gúne dua gorí tarár uore át díye. ");
INSERT INTO rhgc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Allar kalam fólat accíl. Jerúsalem ot ummot ókkol or dol bicígori barát accíl, aar imam ókkol ottu yó boóut zone hé iman kobul goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esṭífen hoó de yóggwa Allar rahámote edde taakote furaiya aiccíl, yóggwa ye manúc ókkol or bútore ḍoóñr-ḍoóñr taajuippa harhána ókkol edde illayi-nicán ókkol daháito. ");
INSERT INTO rhgc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lekin ek din, Azad-Faiya-Maincór Mujilíc-hána hoó de híyan or hoozzon maincé Esṭífen or ulḍa ói yóggwa llói torkatorki diyat doijje. Ítara accíl de, Kurenir, Alexzendariyar, Kilicíyar edde Ecíya elakar Yohúdi ókkol. ");
INSERT INTO rhgc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Montor yóggwa ye Pak-Ruhr diiya giyane hoiyé de hotá re ítara ziti nó fare. ");
INSERT INTO rhgc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hétolla honókiye no zane fán gorí ítara hodún maincóre eén hoi bolla bíraiye, ki hoilé, “Añára Esṭífene Allar edde Muúsar ulḍa kuféri hotá ókkol hoór de fúinni.” ");
INSERT INTO rhgc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Héndilla gorí ítara awam ókkol ore, murubbi ókkol ore, edde alem ókkol ore uskaidiyé, aar ítara Esṭífen or hañse aái yóggwa re dóri fótuayi-mujilíc or muúntu ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ítara zetará re misá gobá tíyagaraiye ítara hoór de, “E manúc cwa ye nitti e pak zagar edde Córiyot or hélaf hotá ókkol hoó. ");
INSERT INTO rhgc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Añára yoggwá ye endilla hoór de fúinni, Isá Nasári ye e zaga yián ore dónco gorífelaibo, aar Muúsa ye añára re diíl de rosóm ókkol bodolifélaibo.” ");
INSERT INTO rhgc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Héñtte fótuayi-mujilíc ot boiṛá accíl de ítara beggúne yóggwar híkka díyan dóri saiyé rár dekér de, yóggwar siyára fíristar siyárar ḍóilla óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Hétunot boro imame Esṭífen ottu fusár gorér de, “Iín sóiyi ói né?” ");
INSERT INTO rhgc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esṭífene zuwab der de, “Ó báiyain aar bafáin, añr hotá fúno. Añárar baf Ibrahím Háran cóor ot tákibar age Mesopóṭomiyat accíl de októt mohímar Alla ye yóggwa re dahá díyl, ");
INSERT INTO rhgc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","aar hoóil de, ‘Tor mulluk edde tor egana-guiccí ókkol eri oh mulluk ot zaa ziyán Añí toré daháiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Hétunot yóggwa Kasdiyo ókkol or mulluk eri Háran ot zai táikkegoi. Aar yóggwar baf morizaygói baade, Alla ye yóggwa re e mulluk yián ot lori aá baiyé, ziyán ot yala tuáñra tákor. ");
INSERT INTO rhgc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Montor Íba ye yóggwa re e mulluk yián or honó híssa miras nó dee, ṭéng rakí fare de héttor úddwa nó dee; lekin yóggwa ttu fua nu accíl de októt úddwa Íba ye yóggwa llói waada goijjíl de ki, e mulluk yián yóggwar edde yóggwa zai yóggwar ze nosól ókkol tákibo ítarar kobzat gorídibo. ");
INSERT INTO rhgc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Alla ye yóggwa re endilla hoóil, ‘Tor nosól ókkol for or mulluk ot tór sára boni tákibo; héṛe ítara re gulamit rakíbo, aar sair cót bosór foijjonto zulúm háibo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Alla ye aró hoóil de, ‘Montor ítara ze koum or gulami goríbo, Añí hé koum ore sáñza díyum, yárbaade ítara hé mulluk ottu neeli aái e zagat Añr ebaadot goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tarfore Íba ye Nizor razinamar nicán ísafe yóggwa re ázomi gorár niyom diíl. Tói zeñtté Ibrahím ottu Isahák zormo óiye, yóggwa ye íba re añcṭo din ot din ázomi goráiye; baade Isahák ottu Yakub zormo óoil, aar Yakub ottu baró háandan or bafdada gún zormo óoil. ");
INSERT INTO rhgc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Hé bafdada gúne Yusúf ore ricé Ijíp ot besifélail, montor Alla íbar fúañti accíl, ");
INSERT INTO rhgc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aar íba re tamám mosibot ókkol ottu basaáil. Alla ye íba re Ijíp or baáñcca Féruan ottu meérbani faabáil aar buddíman banaáil, baade íte íba re Ijíp or edde ítar razmohól guñṛar hákim banaáil. ");
INSERT INTO rhgc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Yárbaade, guñṛa Ijíp ot edde Kánan ot eggwá raṭ óoil, zibá ye bicí duk ainné, aar añárar bafdada gúne hái bolla hána nó faa. ");
INSERT INTO rhgc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Montor Yakube zettót Ijíp ot hána asé bóuli fúinnil, íba ye añárar bafdada gún ore foóila bar héṛe difeṛáil. ");
INSERT INTO rhgc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dusárabar ot héṛe giiyé rár, Yusúfe íbar báiyain dore nizor foriso dyíl, baade Féruane Yusúf or foribar or baabute zani faijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tarfore Yusúfe íbar baf Yakub ore edde íbar tamám egana-guiccí ókkol ore aitó hóbor foóñsaiye. Ítara kulehale hóittor fañs zon accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Baade Yakub Ijíp ot giíl; héṛe íba edde añárar bafdada gún entehal óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aar ítarar muruda ókkol ore Cekém ot loizai hobor ot diya giyéh; hoborostán waán ot ziyán Ibrahíme Cekém cóor ot Hamor or fuain dor ttu ṭiañ dii kinilóil. ");
INSERT INTO rhgc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Montor Alla ye Ibrahím lói goijjíl de waada fura goríbar októ zettót ḍáke aiyér, Ijíp ot añárar koum barí bicí óigilgoi, ");
INSERT INTO rhgc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yárbaade, Ijíp ot ar eggwá baáñcca uiṭṭíl, zee niki Yusúf or baabute kessú no zainto. ");
INSERT INTO rhgc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Íte añárar koum loi saláki goijjíl, aar añárar bafdada ókkol ore eddúr zulúm goijjíl zeén níki ítara ttu nizor dud or fuain dore baáre félaidiya fore, zeéne híin morizagói. ");
INSERT INTO rhgc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Hé októt Muúsa zormo óoil. Íba bicí cúndor accíl, aar íba re tin mac foijjonto baf or gór ot fala gyíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Baade íba re zettót baáre félaidiya gíyeh, Féruan or zíi ye íba re loizai nizor fuar ḍóilla góri faillíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muúsa ye Ijípi ókkol or tamám cíkkar elóm faiyé, aar íba hotát edde ham ot taakotwala accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Baade Muúsa salic bosór óiye rár, nizor koum Boni Isráil or hálot saitó zaito demak ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Íba ye dekér de, ezzon Ijípi maincé eggwá Isráilir uore zulúm gorér. Tói íba zai yore Isráili wa re basai Ijíp or manúc cwa re marifélai bodola loiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muúsa ye báippil de, Alla ye ítara re rehái gorí bolla íba re estemal gorér de híyan íbar koumi báiyain de buzíbo, montor ítara nó buzé. ");
INSERT INTO rhgc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tarfor din íba ye dekér de, dui zon Isráili ye maramari der. Íba ye ítara re cántir sáañte bonaidibar kucíce hoór de, ‘Ekí, tuáñra toh bái bái, tuáñra kiyá ezzon loi ezzone maramari dor?’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Montor zee niki oinno wa re zulúm gorér, yóggwa ye Muúsa re ḍéikka mari hoór de, ‘Toré hone añárar hákim edde bisarhar banaiyé?’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Tui ki añré yó marifélaibi zendilla gel de hailla ezzon Ijípi re marifélaiyos?’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Híyan fúni Muúsa dáigiyegoi, aar Miídiyan mulluk ot ezzon bidecóitta ísafe táikkil. Héṛe íba ttu duwá fua zormo óoil. ");
INSERT INTO rhgc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Salic bosór guzori zaigói baade, Kuútor Faár or moidan zagat ek fírista ye eggwá zoler de ooin or záḍḍwat Muúsa re dahádiye. ");
INSERT INTO rhgc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Híyan dekí Muúsa taajup óigilgoi, aar cúndorgori sai bolla aró ḍáke giiyé rár, Mabude eén hoór de abas fúinne, ");
INSERT INTO rhgc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Añí óilam de tor bafdada ókkol or Alla, yáni Ibrahím or, Isahák or edde Yakub or Alla.’ Hétunot Muúsa ḍoore hafat dóijjil aar saibár hímmot nó goré. ");
INSERT INTO rhgc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mabude íba re hoór de, ‘Tor ṭéng or cenṭár kúlifela, kiyólla-hoilé tui ze zagat tíyaiyos híyan pak zaga. ");
INSERT INTO rhgc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Becók, Añí Añr bonda ókkol zetará Ijíp ot asé ítarar uore ze zulúm ókkol ór híin deikkí. Añí ítarar dukkór hañdani fúni ítara re basailoibo lla nise aiccí deh. Yala ai, Añí toré Ijíp ot difeṛáiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ibá óilde oh Muúsa, zibá re ítara endilla hoói inkar gorídil, ‘Toré hone hákim edde bisarhar banaiyé?’ Ze fírista ye zoler de záḍḍwat Muúsa re dahá díyl hé fíristar duara Alla Nize íba re hákim edde rehái-goróya banai difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Íba ye Boni Isráil ókkol ore Ijíp ottu neelai ainníl, aar Ijíp ot, Nil Doriyat, edde moidan zagat salic bosór fán taajuippa harhána ókkol edde illayi-nicán ókkol daháiye. ");
INSERT INTO rhgc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ibá óilde oh Muúsa, zibá ye Boni Isráil ókkol ore hoóil de, ‘Alla ye tuáñrar báiyain dor bútottu tuáñra lla añr ḍóilla ézzon nobi tulíbo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Íba óilde úba, zibá moidan zagat añárar koum zoma óoil de ítarar fúañti accíl; héṛe añárar bafdada ókkol edde íba llói Kuútor Faár or uore hotá hoóil de fírista wa yó accíl, aar añárar hañse foóñsai bolla íba ye zinda kalam faáil. ");
INSERT INTO rhgc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Montor añárar bafdada ókkole íbar hotá mainto nó saá, bólke ítara íba re inkar goijjíl, aar Ijíp ot waafes zai bolla dile-dile mon gorí, ");
INSERT INTO rhgc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aron ore hoóil de, ‘Añárar age-age zai bolla añára lla debota ókkol bano, kiyólla-hoilé añára re Ijíp dec ottu neelai ainné de Muúsar hálot kii óigiyoi añára no zani.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tói hétunot ítara gorur-sóor ḍóilla eggwá mutti banai yíbar hañse kurbani peec goijjé, aar ítara nizor át or banaiya siz or uore kúci-áci goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Montor Alla ye ítara ttu muk fíraifelaiye, aar ítara re asman or tara ókkol fuñzitó eridifélaiye, nobi ókkol or kitab ot zendilla leikká asé, ‘Ó Boni Isráil ókkol, tuáñra moidan zagat salic bosór foijjonto Añr hañse januwar kurbani edde oinno kurbani peec goijjíla níki? ");
INSERT INTO rhgc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tuáñra toh Molek debotar ṭambu edde tuáñrar Rifan debotar sóbi éna tulí looi fúañti-fúañti loizaitá, ziín tuáñra fuñza gorí bolla banaáila. Hétolla Añí tuáñra re Babilon or okul or zagat bondit difeṛáiyum.’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Moidan zagat añárar bafdada ókkol ottu Allar Házirir Ṭambu accíl; híyan ore undilla nomuna mozin bana gyíl, zendilla gori banai bolla Alla ye Muúsa re daháidi hókum goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ṭambu híyan fai baade, añárar bafdada ókkole Yehócuar sóddarir tole tákite híyan ore nizor fúañti añárar e mulluk ot ainníl. Héñtte Alla ye ítarar muúntu oinno koum ókkol ore neelai dyíl. Híyan Dawud or zobana foijjonto e mulluk ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawude Allar rahámot fai yore Yakub or Alla táki bolla ékkan zaga banaibár ezazot maiggíl. ");
INSERT INTO rhgc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Montor Íba lla gór Sólomane éna banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Háleke, Alla Tála insán or át or banaiya gór ot no táke. Nobi ye endilla hoór, ");
INSERT INTO rhgc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mabude fórmar de, ‘Asman óilde Añr toktó, aar zobin óilde Añr foo rakíbar banggú. Tui Añr lla hon kisím or gór banaibí? Añí aram goríbar zaga hoṛé óibo? ");
INSERT INTO rhgc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iín beggún Añr Nizor áte banaiyí de no né?’ ");
INSERT INTO rhgc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ó uzzoti manúc ókkol! Tuáñrar dil edde han toh bedini ókkol or híin or ḍóilla. Tuáñra hámica Pak-Ruh re oóñli rakó, zendilla tuáñrar bafdada ókkole goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tuáñrar bafdada ókkole hon nobi wa re zulúm nó goré de asé? Ítara toh uitará re yó marifélail zetará Insáfwala wa aibár agun hotá hoóil. Aar yala tuáñra yó Íba re dóridi marifélaiyo. ");
INSERT INTO rhgc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tuáñra toh fírista ókkol or áta diiya Córiyot faáila, montor toóu híin amól nó goró.” ");
INSERT INTO rhgc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Híin fúni fótuayi-mujilíc or membór ókkol bicí rak óigiyoi, aar yóggwar ulḍa date-dat kirkirat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Montor yóggwa Pak-Ruh lói furaiya ói yore asman or uzu díyan dóri saiyé rár Allar mohíma deikké. Aró deikké de, Isá Allar den ḍák ottu tíyaiya asé. ");
INSERT INTO rhgc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yóggwa ye hoór de, “Soó, añí dekír de, asman kúla aar Manúc or Fua Allar den ḍák ottu tíyaiya asé.” ");
INSERT INTO rhgc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hétunot ítara nizor han bon gorífelaiye, aar eggwá ḍoóñr guzoran mari beggúne ekku fúañti yóggwar uore záp maijje. ");
INSERT INTO rhgc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ítara yóggwa re cóor or baáre loizai cíl or dola marat doijje; aar gobá gúne nizor hoorsuor kúlifelai Sául nam or ézzon juwan manúc or ṭéng or gurat raikké. ");
INSERT INTO rhgc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ítara Esṭífen ore cíl or dola marat accíl de októt, yóggwa ye endilla hoói dua gorér, “Ó Malik Isá, añr ruh re kobul goró.” ");
INSERT INTO rhgc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Baade yóggwa ye añṛú félai eggwá ḍoóñr abase guzori hoór de, “Ó Malik, itarár e guná no dóijjo.” Híyan hoói yóggwa moot or gúm ot foijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Esṭífen ore marifélaiye de híyan ot Sául furafuri razi accíl. Hé din, Jerúsalem ot accíl de zomát or uore eggwá ḍoóñr zulúm cúru óiye, aar sáhabi gún bade argún beggún Yohúdiya edde Samária elakar agagurat dorbodor óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Hodún dindár manúce Esṭífen ore dohón gorífelaiye, ítara bilak gorí-gorí yóggwa lla bicí haindé. ");
INSERT INTO rhgc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ar Sáule zomát ore dónco gorár kucíce, góre-góre góli morotfuain edde mayafuain ókkol ore ṭani aní ziyól ot díyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ze imandár ókkol dorbodor óigiyegoi, ítara zaga-zaga zai kúchóbor tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Aar Filípe nise Samáriar ekkán cóor ot zai, maincóre Mosihr baabute tobolik gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Manúc ókkole Filíp or boiyan fúni edde íba ye daháito de illayi-nicán ókkol dekí íbar hotá aró díyan or sáañte fúinto. ");
INSERT INTO rhgc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kiyólla-hoilé bicí manúc ottu hóraf jin ókkol ḍoóñr abase guzoran mari neeillíl, aar boóut zon mazur edde leng gom óoil. ");
INSERT INTO rhgc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hétolla hé cóor ot bicí kúci accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yár age hé cóor ot Sáimon nam or ézzon manúc accíl, zibá ye jadu dahái Samáriar manúc ókkol ore taajup gorí rakíto, aar dabi goittó de, añí yó ézzon ḍoóñr manúc. ");
INSERT INTO rhgc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Gorib tuangor beggúne yóggwar hotá díyan dí fúinto aar hoitó de, “E manúc cwa óilde Allar oh kudurut, ziyán ore Ḍoóñr Kudurut bouli zana zah.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ítara yóggwar hotát etollá díyan dito, kiyólla-hoilé yóggwa ye ítara re jadu dahái bicí deri lóti taajup gorí raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Montor ítara zeñtté Filípe Allar raijjor edde Isá Mosihr baabute kúchóbor tobolik goijjé de híin or uore iman ainné, ítara morotfuain mayafuain duní gúne bápṭisma loiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sáimon nize yó iman aní bápṭisma loiyé. Yóggwa Filíp or fúañti-fúañti zaito, aar íba ye daháito de illayi-nicán ókkol edde ḍoóñr-ḍoóñr keramot ókkol dekí yóggwa taajup óizaytoi. ");
INSERT INTO rhgc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerúsalem ot asé de sáhabi gúne zettót Samáriar maincé Allar kalam kobul goijjé de fúinne, ítara Fitor ore edde Yohánna re tarár hañse difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ítara duní zon foóñsi yore tará lla dua goijjé, zeéne tará Pak-Ruh faa; ");
INSERT INTO rhgc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kiyólla-hoilé tarár uore Pak-Ruh hétun foijjonto nú aiyé; tará cúdu Malik Isár name bápṭisma lóil deh. ");
INSERT INTO rhgc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Baade Fitor edde Yohánna ye tarár uore át díye, tói tará Pak-Ruh faiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sáimone dekér de, sáhabi gúne át dile Pak-Ruh miler, tói yóggwa ye tará re ṭiañ dii ");
INSERT INTO rhgc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","hoór de, “Añré yó e kémota gán doo, zeéne añí zar uore át dí yóggwa ye Pak-Ruh faa.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Montor Fitore yóggwa re hoór de, “Tuáñr ṭiañ tuáñr fúañti dónco óizoggoi, kiyólla-hoilé tuñí toh Allar hádiya ṭiañ dii kina zah bouli ṭáaijjo. ");
INSERT INTO rhgc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ham yián ot no tuáñr honó híssa asé aar no honó borat asé, kiyólla-hoilé Allar nozor ot tuáñr dil sóiyi no. ");
INSERT INTO rhgc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hétolla tuñí tuáñr e hórafi ttu touwá goró, aar Malik or hañse dua goró, óitofare Íba ye tuáñr dil or e hóraf báfani maf gorídibo. ");
INSERT INTO rhgc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kiyólla-hoilé añí dekír de, tuñí lalóse bóra aar gunár kobzat asó.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hétunot Sáimone zuwabe hoór de, “Añr lla Malik or hañse dua goró, zeéne tuñí hoiyó de héntu ekkán úddwa añr uore no.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tarfore Malik or kalam tobolik gorí edde Isár baabute gobá dí baade, Fitor edde Yohánna Jerúsalem or uzu rowana loiyé, aar foñt ot Samári ókkol or boóut tan farat kúchóbor tobolik goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ek din, Mabud or ek fírista ye Filíp ore hoór de, “Tuñí uṛí doóin míkka rasta ubát zoo, zibá Jerúsalem ottu Gaza cóor ot foijjé.” Hé rasta wa moidan zagat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hétunot íba uṛí rowana loiyé, aar zaite-zaite foñt ot máze Itúpiya dec or Kandes ranir ek ḍoóñr uzir loi dola óiye, yóggwa accíl ízara, aar ranir tamám dón-doulot or zimmadar. Yóggwa Jerúsalem ot aiccíl de Allar ebaadot gorí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yóggwa nizor gúra-garít boói gór ot waafes zaargói de foñt ot nobi Yesáyahr kitab telawot gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Hétunot Pak-Ruh ye Filíp ore hoór de, “Hé gúra-garí gán or ḍáke zai híyan or fúañti-fúañti zaat dóro.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tói Filíp duñri gúra-garír ḍáke giiyé rár fúner de, manúc cwa ye nobi Yesáyahr kitab telawot gorér. Íba ye yóggwa ttu fusár gorér de, “Tuñí ziín telawot gorór híin buzór né?” ");
INSERT INTO rhgc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yóggwa ye zuwab der de, “Honókiye buzái no dilé añí keéngori buzí faijjum?” Tói yóggwa ye Filíp ore uore uṛí yóggwar fúañti boitó aros goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Manúc cwa ye pak-kalam or ze híssa gán telawot gorér híyan óilde yián, “Zoorái bolla bérasóol ore zendilla gori loiza zah, Íba re héndilla góri loiza giyéh; aar nizor keñc haṛoyar muúntu bérasóol or sóo ye zendilla nizám ói táke, héndilla Íba ye yó Nizor muk nó kúle. ");
INSERT INTO rhgc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Íba re beizzoti goijjíl de híyan or honó bisar nó faa. Hone Íbar nosól or baabute hoói faribó? Kiyólla-hoilé duniyai ttu Íbar zan loifélagil.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hé uzir gwá ye Filíp ottu fusár gorér de, “Meérbani góri añré hoó, nobi ye iín har baabute hoór deh, nizor né náki oinno zon or?” ");
INSERT INTO rhgc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hétunot Filípe hotá howá sáat goijjé, aar pak-kalam or hé híssa gán lói cúru gorí yóggwa re Isár baabute kúchóbor tobolik goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ítara rasta báy zaite-zaite faní asé de ekkán zagat foóñicce. Uzir gwá ye hoór de, “Soó, eṛé faní asé, yala bápṭisma lowa ttu añré kiyé oóñli faribó?” ");
INSERT INTO rhgc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filípe yóggwa re hoór de, “Zodi tuñí fura dile Isár uore iman ainnó de óile, loi faribá.” Yóggwa ye hoór de, “Añí iman aní de, Isá Mosih óilde Allar Fua.” ");
INSERT INTO rhgc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Baade yóggwa ye gúra-garí tíyagaraito hókum díye, tarfore Filíp edde hé uzir, tará duní zon fanít laimmé, aar Filípe yóggwa re bápṭisma díye. ");
INSERT INTO rhgc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Zeñtté ítara faní ttu uiṭṭégai, Malik or Ruh ye bánggori Filíp ore loigiyégoi. Hé uzir gwá ye Filíp ore ar nó deké, lekin kúci gorí-gorí nizor sofór zari raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Montor Filípe nizoré Asdod cóor ot loot faiyé, íba héntu lóti Kaisáriyat foóñse foijjonto cóor beggún ot kúchóbor tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Hé hale, Sáule Malik or ummot ókkol ore dómki diyat edde zulúm gorát accíl. Íba boro imam or hañse giiyé, ");
INSERT INTO rhgc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aar Damáskas cóor or mujilíc-hána ókkol ot dii bolla ceñṛí maiggé, zeéne íba ye zaré-zaré Malik or Torikat asé de lootfa, ítara beggún ore bañdí Jerúsalem ot aní fare, ítara morotfuain óuk yáh mayafuain. ");
INSERT INTO rhgc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Zaite-zaite íba zeñtté Damáskas or hañsáhañsi foóñicce, atíkka asman ottu eggwá foór íbar sairó ḍák ottu soimké, ");
INSERT INTO rhgc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","baade íba meṛit forigilgói, aar endilla hoór de eggwá abas fúinne, “Sául, Sául, tui Añré zulúm gorór kiyá?” ");
INSERT INTO rhgc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sáule fusár gorér de, “Malik, Tuñí hon?” Íba ye zuwab der de, “Añí Isá, zibá re tui zulúm gorór. ");
INSERT INTO rhgc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yala tui uṛí cóor or bútore zaa, tor ttu kii gorá foribó de híyan héṛe toré howá zaybo.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Oinno manúc zetará Sául or fúañti zaar, ítara ammúk ói tíyai táikkil, kiyólla-hoilé ítara abas swá fúner montor honókiyo re no dekér. ");
INSERT INTO rhgc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tarfore Sául meṛi ttu uiṭṭé, lekin suk kúille rár kessú no dekér. Baade ítara íba re át ot dóri Damáskas ot loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Íba tin din foijjonto añdá accíl, aar honó hána-fina ná háa. ");
INSERT INTO rhgc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damáskas ot Ananiyas nam or ezzon ummot accíl, Malike yóggwa re ekkán dorcón ot hoór de, “Ó Ananiyas.” Yóggwa ye zuwab der de, “Jii Malik, añí eṛé así.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Baade Malike yóggwa re hoór de, “Uṭ, Uzu hoó de rasta yíbat zaa, aar Yohúdahr gór ot Sául nam or ézzon Tarsús cóor or manúc or talac gorgói. Íba ehón dua gorér. ");
INSERT INTO rhgc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Íba ye ekkán dorcón ot deikké de, ezzon Ananiyas nam or manúce aái íbar uore át díye, zeéne íba ye abar dekí fare.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyase hoór de, “Malik, manúc íbar baabute añí boóut maincór ttu fúinni, íba ye Jerúsalem ot Tuáñr pak bonda ókkol ore hotó duk diyé deh, ");
INSERT INTO rhgc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","aar íba eṛé Tuáñr ebaadot goré de ítara beggún ore gereftar gorí bolla ḍoóñr imam ókkol ottu adíkar fai aiccé deh.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Montor Malike yóggwa re hoór de, “Tui zaa, kiyólla-hoilé íba óilde Añr basíloiya usíla, Beyohúdi ókkol or, baáñcca ókkol or, edde Boni Isráil ókkol or muúntu Añr nam foóñsai bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Añr nam or wasté íba ttu hodún duk faa foribó Añí íba re daháiyum.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tói Ananiyas zai hé gór gán ot góille, aar Sául or uore át dí hoór de, “Bái Sául, Malik Isá, zibá ye tuáñre eṛé aibárcot rastat dahá díyl, añré tuáñr hañse Íba ye difeṛáiye deh, zeéne tuñí abar dekí faro aar Pak-Ruh lói furaiya ó.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Baade éhon or bútore Sául or suk ottu oóñc or ḍóilla kessú foijjé, aar íba ye abar dekí faijjé. Tarfore íba uṛí bápṭisma loiyé, ");
INSERT INTO rhgc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","aar hána háiye rár abar bol faiyé. Íba ummot ókkol or fúañti Damáskas ot hooddin táikkil, ");
INSERT INTO rhgc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","aar honó deri no gorí mujilíc-hána ókkol ot Isár baabute tobolik gorát doijje de ki hoilé, Isá óilde Allar Fua. ");
INSERT INTO rhgc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Zetará íbar boiyan fúinto ítara beggúne taajup ói hoitó de, “Manúc ibá kí ubá no, zibá ye Jerúsalem ot Isár ebaadotgár ókkol ore zulúm goittó? Ibá eṛé yó héndilla goré de ítara re gereftar gorí ḍoóñr imam ókkol or hañse loizaibár niyote aiccé de no né?” ");
INSERT INTO rhgc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Montor Sául dinbodin mozbut ówat accíl, aar Isá óilde Mosih de híyan or eén dolil ókkol diyat accíl, zeén níki Damáskas ot táke de Yohúdi ókkol toddó óizaytoi. ");
INSERT INTO rhgc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Boóut din guzori zaigói baade, Yohúdi ókkole íba re marifélai bolla ekkán sail gúraiye, ");
INSERT INTO rhgc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","montor Sáule ítarar hé sail or baabute zani faijjé. Ítara íba re marifélai bolla dine raite cóor or geiṭ ókkol ot faára díyat accíl, ");
INSERT INTO rhgc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","montor íbar cárit ókkole raitta eggwá ḍoóñr lai ot gori íba re ḍebal or ekkán zanála báy nise lamaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Baade Sául Jerúsalem ot giiyégoi. Héṛe íba ye ummot ókkol lói bóng óito kucíc goijjíl; montor ítara beggúne íba re ḍooraitó, kiyólla-hoilé íba sóiyi-sóiyi ummot bonigiyói de híyan ítara biccác no goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Montor Bárnabase íba re sáhabi gún or hañse ainné. Yóggwa ye ítara re zanaiyé de, Sáule sofór ot zaibarcót rastar uore Malik ore hondilla gori deikkíl, Malike íba llói keéngori hotá hoóil, edde íba ye Damáskas ot Isár name keén hímmot or sáañte tobolik goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tarfore Sául ítarar fúañti táikkil, aar kúlamela góri Jerúsalem or agagurat zai hímmot or sáañte Malik or name tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Íba ye Yohúdi zetarár zuban Girík ítara llói hotá hoitó edde barábari díto; montor ítara íba re marifélaito kucíc goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Zeñtté imandár báiyain de híyan or baabute zainné, ítara íba re nise Kaisáriyat aní Tarsús ot duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Héñtte fura Yohúdiyar, Galil or, edde Samáriar zomát ókkol ot cánti accíl, aar híin torki ówat accíl. Ítara Malik ore ḍooraitó aar Pak-Ruhr tosólliye solitó; héndilla góri ítarar dol barát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fitor hárr zagat sofór goitté-goitté, ek dinná íba Liídiya farat Allar ze pak bonda ókkol asé ítarar hañse yó aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Héṛe íba ye Ainiyas nam or ezzon manúc loot faiyé, zibá añtur de hétolla añcṭo bosór fán bisánat fori asé. ");
INSERT INTO rhgc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fitore yóggwa re hoór de, “Ainiyas, Isá Mosih ye tuáñre gom goijjé; uṛó, tuáñr bisána boṛi loo.” Baade yóggwa éhon uṛí tíyaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aar yóggwa re dekí Liídiyar edde Cáron elakar manúc beggún Malik or uzu fíjje. ");
INSERT INTO rhgc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa cóor ot Tabita nam or eggwá mayafua ummot accíl; Girík zuban ot híbar nam Dorkas, ziyán or torjuma “Óroin.” Híba ye hámica bálai goittó aar gorif ókkol ore modot goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Héñtte híba biyaram ói morigílgoi, aar manúc ókkole híba re dúwaidai baade uoror ṭalar ekkán kamárat raikké. ");
INSERT INTO rhgc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liídiya fara gán Joppar ḍáke accíl. Ummot ókkole zettót Fitor héṛe asé de fúinne ítara dui zon manúc difeṛái íba re aros gorér de, “Tuñí añárar héṛe aité deri no goijjó.” ");
INSERT INTO rhgc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hétunot Fitor uṛí ítarar fúañti giiyé. Zeñtté íba héṛe foóñicce, ítara íba re uoror ṭalar kamára gán ot ainné. Rari mayafuain beggún Fitor or sairó ḍák ottu tíyai táikke, aar Dorkase zinda tákite zedún kuruta edde hoorsuor ókkol banaáil híin beggún íba re hañdi-hañdi dahát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Montor Fitore ítara beggún ore baáre neelaidi añṛú félai dua goijjé. Íba ye lac cwar uzu fíri hoór de, “Tabita, uṭ.” Tói híba ye suk kúille, aar Fitor ore deikké rár uṛí boiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Baade Fitore híba re át ot dóri tuillé, aar rari mayafuain cóo imandár beggún ore matai híba re zinda gosáidiye. ");
INSERT INTO rhgc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Hé hóbor gán Joppa agagurat fóligilgoi, aar boóut maincé Malik or uore iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Fitor boóut din foijjonto Joppat maze Sáimon nam or ézzon samarar ham-goróyar fúañti táikkil. ");
INSERT INTO rhgc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisáriya cóor ot Korneliyas nam or ezzon manúc accíl, yóggwa accíl Iṭaliyo Ṭeérang hoó de yíbar ek cót fóous or cáap. ");
INSERT INTO rhgc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yóggwa edde yóggwar gór ṭíya dindár accíl aar Alla re ḍooraitó; yóggwa ye gorif ókkol ore bicí hórat diito, aar Allar hañse nitti dua goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ekbar din or tin nwá báze yóggwa ye ekkán dorcón deikké, ziyán ot sáf-sáf góri dekér de, Allar ek fírista aái yóggwa re hoór de, “Korneliyas.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yóggwa ye ḍoore fíristar uzu suk ḍoóñr gorí saái hoór de, “Malik, hoóna?” Baade fírista ye hoór de, “Tuáñr duaye edde hórat doone Alla kúci óiye aar Íba ye híin monot raikké. ");
INSERT INTO rhgc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yala tuñí Joppat manúc difeṛó, aar Sáimon zibá re Fitor óu ḍake, íba re matai anó. ");
INSERT INTO rhgc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Íba samarar ham-goróya Sáimon or gór ot meéman ísafe asé, zar gór gán doijjar hañsat.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yóggwa llói hotá hoóil de fírista wa zaigói baade, yóggwa ye nizor gór or dui zon gulam ore edde yóggwa re hámica hédmot goittó de ítarar bútottu eggwá dindár fóous ore mataiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aar ziín-ziín óiye híin beggún ítara re buzái yore Joppat difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tarfor din ítara zaite-zaite cóor gán or hañsáhañsi foóñser de októt, din or duúñijja Fitor gór or sád or uore dua goittó uiṭṭégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Íba ttu búk laiggíl, aar kessú háito monehoóil, montor hána toiyar ór de októt, íba ye ekkán dorcón deikké, ");
INSERT INTO rhgc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ziyán ot dekér de, asman kúla aar ḍoóñr saddor or ḍóilla ekkán siz ore sair kuna ttu dóri zobin ot lamaidiya zar. ");
INSERT INTO rhgc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Híyan or bútore hárr kisím or sair ṭéingga januwar, buke áñṛe de zandár, edde faik ókkol asé. ");
INSERT INTO rhgc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Baade íbar hañse eggwá abas aiccé de, “Fitor, uṭ, iín ore marifélai háa.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Montor Fitore hoór de, “No, no, Malik; añí toh honódin kessú nafak yáh háram háiyi de nái.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hétunot íbar hañse abar eggwá abas aiccé de, “Alla ye ziyán ore pak-sáf goijjé híyan ore nafak bouli no hoóic.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Héndilla tin bar óiye, baade saddor gán atíkka asman ot waafes tulífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Zeñtté Fitore deikkíl de dorcón or maáni kii hoói báfer, Korneliyase difeṛáil de manúc cún Sáimon or gór gán hoṛé asé de talac gorí fai yore híyan or geiṭ ot aái tíyai táikke. ");
INSERT INTO rhgc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ítara ḍak mari fusár gorér de, “Sáimon, zibá re Fitor óu ḍake, íba eṛé asé né?” ");
INSERT INTO rhgc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Fitore dorcón híyan or baabute báfat accíl de októt, Pak-Ruh ye íba re hoór de, “Saá, tin zon maincé tor talac gorér. ");
INSERT INTO rhgc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hétolla uṭ, nise zaa, aar honó cók-cubá sára ítarar fúañti zaa, kiyólla-hoilé ítara re Añí difeṛáiyi deh.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hétunot Fitor nise zai manúc cún ore hoór de, “Tuáñra zar talac gorór, íba óilam de añí. Tuáñra kiyólla aiccó dé?” ");
INSERT INTO rhgc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ítara zuwab der de, “Añára re cáap Korneliyase difeṛáiye deh. Yóggwa ézzon forhésgar edde Alla re ḍoora de manúc. Tamám Yohúdi ókkole yóggwar nam goré. Yóggwa re pak fírista eggwá ye hoiyé de, tuáñre yóggwar gór ot matai bolla, zeéne yóggwa ye tuáñr ttu kalam fúni fare.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hétunot Fitore ítara re bútore matai aní meémandari goijjé. Tarfor din Fitor ítarar fúañti rowana loiyé. Íbar fúañti Joppa ttu hoozzon imandár báiyain óu giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Zaite-zaite ek din baade ítara Kaisáriyat foóñicce. Korneliyase nizor egana-guiccí edde háas dustó ókkol zoma gorí ítarar entezar ot accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Fitor gór ot gólibarcot Korneliyase íba re estekbal goijjíl, aar íbar ṭéng ot uúiñtoi fori sóida goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Montor Fitore yóggwa re eén hoói tulíloiye, “Uṛó, añí yó toh ézzon insán.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Yóggwa llói hotá hoói-hoói Fitor bútore góille rár dekér de, héṛe boóut manúc zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Íba ye ítara re hoór de, “Tuáñra toh zano, ek Yohúdi ye honó Beyohúdi llói sákbak rakón yáh ítarar héṛe beraitó zoon añárar córiyot or maná. Montor honókiyo re háram yáh nafak no hoi bolla Alla ye añré daháidiye. ");
INSERT INTO rhgc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hétolla tuáñra añré mataitó difeṛáiyo rár, añí honó bazá no di aiccí deh. Yala añí fusár gorí faijjum né tuáñra añré kiyólla mataitó difeṛáiyo dé?” ");
INSERT INTO rhgc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyase zuwab der de, “Yar sair din age, etún ot din or tin nwá báze añí añr gór ot dua gorír de októt, somoikka hoor findá ézzon manúc asimbit añr muúntu tíyaiye, ");
INSERT INTO rhgc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","aar hoór de, ‘Korneliyas, Alla ye tuáñr dua fúinne edde tuáñr hórat diiya monot raikké. ");
INSERT INTO rhgc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hétolla honókiyo re Joppat difeṛó, aar Sáimon zibá re Fitor óu ḍake, íba re matai anó, íba samarar ham-goróya Sáimon or gór ot meéman ísafe asé, zar gór gán doijjar hañsat.’ ");
INSERT INTO rhgc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hétolla añí tuáñre matai bolla éhon or bútore manúc difeṛáiyi deh. Gom óiye tuñí aiccó. Yala añára beggún eṛé Allar muúntu házir óiyi de, Malike tuáñre añára re ziín hoi bolla hókum díye híin beggún fúni bolla.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Baade Fitore hotá howá cúru gorí hoór de, “Ehón añí sóiyi-sóiyi zani faijjí, Alla ye ektorfía no goré, ");
INSERT INTO rhgc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","bólke hárr koum ottu zee-zee Íba re ḍoora aar sóiyi ham goré, taré-taré Íba ye kobul goré. ");
INSERT INTO rhgc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tuáñra toh oh kúchóbor zano ziyán Alla ye Boni Isráil ókkol or hañse foóñsaiye, ki hoilé, Isá Mosih zibá beggún or Malik, Íbar duara cánti faa zah. ");
INSERT INTO rhgc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tuáñra nize zano, Yaháya ye bápṭismar baabute tobolik gorí baade Galil ottu lóti cúru gorí guñṛa Yohúdiyat kii óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tuáñra yián óu zano, Alla ye Nasárat or Isá re Pak-Ruh loi edde kudurute furaiya gorí basíloil. Íba ye zaga-zaga zai bálai goittó, aar zetará re Ibilíce duk de ítara beggún ore gom goittó, kiyólla-hoilé Alla toh Íbar fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Íba ye Yohúdi ókkol or mulluk ot edde Jerúsalem ot zedún ham ókkol goijjé, añára híin beggún or gobá así. Manúc ókkole Íba re kúruc ot ṭaki marifélail. ");
INSERT INTO rhgc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Montor Alla ye Íba re tin din ot din zinda goijjé, aar Íba re zahér ówa baiyé, ");
INSERT INTO rhgc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","beggún or hañse no, bólke siríf Alla ye age lóti basí raikké de gobá ókkol or hañse, yáni añárar hañse, zetará Íba mora ttu zinda ói baade Íbar fúañti háafiya goijjílam. ");
INSERT INTO rhgc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Íba ye añára re hókum díye de, manúc ókkol or hañse tobolik gorí bolla edde yián gobá dí bolla, ki hoilé, Íba óilde Ubá zibá re Alla ye zinda edde mora ókkol or bisarhar banaiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tamám nobi ókkole yó Íbar baabute endilla gobá díye de ki, zee niki Íbar uore iman ané íte Íbar name gunár maf faa.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fitore híin boiyan gorér de októt, fúner de ítara beggún or uore Pak-Ruh lami aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Joppa ttu ze ázomi goijjá imandár ókkol Fitor or fúañti aiccíl ítara taajup óigilgoi, kiyólla-hoilé Beyohúdi ókkol or uore yó hádiya ísafe Pak-Ruh ḍálidiya giyéh. ");
INSERT INTO rhgc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ítara dekér de, Beyohúdi ókkole gabi zubane hotá hoór edde bicígori Allar taarif gorér. Hétunot Fitore hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yala toh itará re fanír bápṭisma lowa ttu honókiye oóñsi no faribó, kiyólla-hoilé añárar ḍóilla itará yó de Pak-Ruh faiyé.” ");
INSERT INTO rhgc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tói íba ye ítara re Isá Mosihr name bápṭisma díya zay bolla hókum díye. Yárbaade ítara Fitor ore hooddin fúañti tákito aros goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sáhabi gúne edde Yohúdiyar agagurat asé de imandár báiyain de fúinne de, Beyohúdi ókkole yó Allar kalam kobul goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hétolla Fitor zeñtté uore Jerúsalem ot giiyé, ázomi goijjá imandár ókkole íba re hosúr díye, ");
INSERT INTO rhgc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ítara hoór de, “Tuñí be-ázomi goijjá maincór gór ot giiyó, aar ítarar fúañti hána yó háiyo.” ");
INSERT INTO rhgc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tói Fitore ítara re ekku ttu lóti beggún buzái hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Añí Joppa cóor ot dua gorír de októt ekkán dorcón deikkí, ziyán ot deikkílam de, ḍoóñr saddor or ḍóilla ekkán siz ore sair kuna ttu dóri asman ottu lamaidiya zar; híyan laimte-laimte añí ziyóñt así híñyot foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Añí saddor gán or uzu díyan dóri saiyí rár deikkí de, híyan or bútore zobin or sair ṭéingga januwar, jonggoli januwar, buke áñṛe de zandár, edde faik ókkol asé. ");
INSERT INTO rhgc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Baade eggwá abase añré endilla yó hoór de fúinni, ‘Fitor, uṭ, iín ore marifélai háa.’ ");
INSERT INTO rhgc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Montor añí hoiyí de, ‘No, no, Malik; añí toh honódin kessú nafak yáh háram hána gal ot diyí de nái.’ ");
INSERT INTO rhgc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Hétunot dusárabar asman ottu eggwá abas aái hoór de, ‘Alla ye ziyán ore pak-sáf goijjé híyan ore nafak bouli no hoóic.’ ");
INSERT INTO rhgc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Héndilla tin bar foijjonto óiye, baade híin beggún ore asman ot waafes tulífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Hétukkun ot tin zon manúc zetará re añr hañse Kaisáriya ttu difeṛá gíyeh, ítara añára ze gór gán ot accílam híyan ot foóñicce. ");
INSERT INTO rhgc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pak-Ruh ye añré honó cók-cubá sára ítarar fúañti zaito hoiyé. E sów zon báiyain itará yó añr fúañti giíl. Baade añára manúc cwar gór ot góilligoi. ");
INSERT INTO rhgc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yóggwa ye añára re hoiyé de, yóggwa ye yóggwar gór ot eggwá fírista deikké, zibá ye hoiyé de, ‘Honókiyo re Joppat difeṛó, aar Sáimon zibá re Fitor óu ḍake, íba re matai anó. ");
INSERT INTO rhgc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Íba ye tuáñre endilla hotá ókkol hoibó, ziíne tuñí edde tuáñr gór ṭíya ye nejat faiba.’ ");
INSERT INTO rhgc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Baade añí zettót boiyan gorá cúru goijjí, ítarar uore Pak-Ruh lami aiccé, zendilla foóila cúrut añárar uore aiccíl. ");
INSERT INTO rhgc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hétunot añr ttu hotá waán monot uiṭṭíl ziyán Malike hoóil, ki hoilé, ‘Yaháya ye toh fanít éna bápṭisma díye, montor tuáñra re Pak-Ruh lói bápṭisma díya zaybo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hétolla Alla ye zettót ítara re ekku ḍoilla hádiya diiyé, zendilla añára re diíl zeñtté añára Malik Isá Mosihr uore iman ainní, tói añí hon abar Alla re oóñlitam?” ");
INSERT INTO rhgc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ítara híin fúni nizám ói táikkil aar Allar taarif gorí hoór de, “Tóoile toh Alla ye Beyohúdi ókkol ore yó touwá gorí ofúrani zindigi faibar toóufik diiyé.” ");
INSERT INTO rhgc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Esṭífen or uore lóti cúru óiye de zulúm or zoriya ze imandár ókkol dorbodor óigilgoi, ítara zaite-zaite Fonikcíya elakat, Sáifrus ḍiyat, edde Enṭiyok ot foijjonto foóñiccegoi. Ítara Yohúdi ókkol ore bade ar honókiyor hañse kalam tobolik no goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Montor ítarar bútore Sáifrus or edde Kurenir hoozzon manúc accíl, zetará Enṭiyok ot zai Girík manúc ókkol ore yó Malik Isár baabute kúchóbor tobolik goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Malik or át ítarar uore accíl de hétolla becábicí manúc ókkole iman aní Malik or uzu fíjjil. ");
INSERT INTO rhgc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Hé hóbor híyan Jerúsalem ot asé de zomát or hañse foóñicce rár, ítara Bárnabas ore Enṭiyok ot difeṛáiye. ");
INSERT INTO rhgc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yóggwa zeñtté héṛe foóñicce, Alla ye ítara re rahámot goijjé de dekí bicí kúci óiye, aar ítara re nosíyot goijjé de, fura dile Malik loi laigga táki bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Hé Bárnabas ézzon nekkar bonda accíl, zibá Pak-Ruh lói edde imane furaiya. Héñtte bicí manúc ókkol ore Malik or hañse aná gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yárbaade Sául ore tuwaitó Bárnabas Tarsús ot giiyé, ");
INSERT INTO rhgc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","aar íba re tuwai fai Enṭiyok ot ainné. Héṛe ítara duní zon zomát or manúc ókkol or fúañti fura ek bosór táikkil aar bicí manúc ore taalim dyíl. Enṭiyok óilde foóila zaga, ziyán ot ummot ókkol ore Isáyi hoói ḍaka giyéh. ");
INSERT INTO rhgc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Hé októt Jerúsalem ottu hoozzon nobi héṛe Enṭiyok ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ítara ttu ezzon or nam accíl Agabos, zibá ye tíyai yore Pak-Ruhr hédaiyote agun hotá hoiyé de ki, fura duniyait eggwá ḍoóñr raṭ óibo. Hotá híyan baáñcca Kalediyus or hókumot or októt fura óoil. ");
INSERT INTO rhgc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Héñtte ummot ókkole zee zedún dii fare hédun dii, Yohúdiyat asé de imandár báiboináin dor hañse modot foóñsaibar fáisela goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ítara hé modot tun Yohúdiyar zomát or murubbi-neta ókkol or hañse Bárnabas edde Sául or áta foóñsail. ");
INSERT INTO rhgc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hé din ókkol ot baáñcca Hérude zomát or kessú maincóre gereftar gorí-gorí zulúm gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hé sílsila loi yóggwa ye Yohánnar bái Yakub ore toluwar loi kotól gorá baiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yóggwa ye zettót Yohúdi ókkol ottu híyan fosón laiggé de deikké, Fitor ore yó gereftar goijjé. Hé góṭana gán Cúṭar-sára Ruṭir-id or októt óoil. ");
INSERT INTO rhgc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Yóggwa ye Fitor ore gereftar gorí ziyól ot raikkíl, aar sair zon sair zon gorí sair ḍaái fóous faára díyl. Yóggwar erada accíl de, Azadir-id baade íba re awam ókkol or muúntu peec gorí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hétolla bouli Fitor ore ziyól ot raikkíl deh, montor zomát or manúc ókkole íba lla Allar hañse dilmon di lagatar dua gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ze din Hérude Fitor ore baáre neelai aníbo, hé din raitta íba duiyán síyol lói baindá accíl aar dui zon fóous or mazé gúm ot accíl, aar faáradar ókkole ziyól or dorozat faára dí táikkil. ");
INSERT INTO rhgc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Atíkka Mabud or ek fírista dahádiye, aar hétunot kamárat eggwá foór zoli uiṭṭé. Fírista ye Fitor ore ḍák sai lari seton gorídi hoór de, “Hára uṛó!” Hétunot íbar duní át ottu síyol lun kúli forigiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Baade fírista ye íba re hoór de, “Keeñil bañdó, aar tuáñr cenṭár fiñdó.” Tói íba ye héndilla goijjé. Fírista ye íba re aró hoór de, “Tuáñr saddor gán gaat berái añr fisé-fisé aiyó.” ");
INSERT INTO rhgc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Fitor neeli fisé-fisé zaat doijje; montor fírista ye ziyán gorér híyan fottón ot de Fitore hoi no fare. Íba ye ṭáaijjil de dorcón dekér bóuli. ");
INSERT INTO rhgc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baade ítara foóila edde dusára faáradar ore bárai zai luwár geiṭ or íñyot aiccé, ziyán báy cóor or bútore góli fare. Hé geiṭ ṭan ítara lla nizebaze kúligiyoi, aar ítara híyan báy neeli eggwá rasta báy zaat accíl. Zaite-zaite atíkka hé fírista wa Fitor ore eri giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hétunot Fitor úñic ói nizoré nize hoór de, “Yala añí sóiyigori zani faijjí, Malike Nizor fírista difeṛái añré Hérud or át ottu edde Yohúdi ókkole ziyán or acá gorí táikkil híyan ottu basaiyé.” ");
INSERT INTO rhgc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Híyan buzí fari íba Yohánnar maa Moriyam or gór ot giiyé. Hé Yohánna re Markus hoói yó ḍake. Gór híyan ot bicí manúc zoma ói dua gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Fitore geiṭ or doroza gán baijjaiye rár, Roḍá nam or eggwá bañdi mayafua ye kúlidito aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Híba ye zettót Fitor or abas ót faiyé, kúciye geiṭ no kúli duñri bútore zai hoór de, “Fitor dorozat tíyai táikke!” ");
INSERT INTO rhgc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ítara híba re hoór de, “Tor matá hóraf óigiyoi!” Montor híba ye zettót híyan sóiyi bóuli howát accíl, ítara hoór de, “Tóoile íba Fitor or fírista óibo deh.” ");
INSERT INTO rhgc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Montor Fitor warawori doroza baijjat accíl. Aar ítara doroza gán kúille rár, Fitor ore dekí taajup óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Fitore áte icára gorí ítara re nizám óito hoiyé, aar Malike íba re ziyól ottu keéngori neelai ainné de híyan ítara re buzáiye. Íba ye aró hoiyé de, “Tuáñra e hóbor yián Yakub edde oinno imandár báiboináin dore yó zanaidiyo.” Baade íba héntu neeli ar ekkán zagat giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Biínna óiye rár, Fitor hoṛé giiyói hoi ziyól or fóous ókkol or bútore ḍoóñr úrussul óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hérude zettót Fitor ore tuwai loot nó faa, yóggwa ye hókum díye de, faáradar gún ore zerá gorí mariféla zay bolla. Baade yóggwa Yohúdiya ttu nise Kaisáriyat zai yore hooddin táikkegoi. ");
INSERT INTO rhgc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hé októt yóggwa Ṭayár edde Sídon cóor or manúc ókkol lói bicí guccát accíl. Montor ítara beggún ek mon ói Balatái ore manaiyé, zibá razmohól or zimmadar accíl, zeéne íte ítara re modot goré. Baade ítara Hérud or hañse aái cánti magat doijje, kiyólla-hoilé ítarar mulluk ore hé baáñccar mulluke hána lói solaitó. ");
INSERT INTO rhgc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hétunot Hérude ítara re tarík díye, aar hé tarík mozin yóggwa ye razfucák fiñdí nizor toktót boói ítara re bácon diyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yóggwar hotá fúni awam ókkole guzori hoór de, “Ibá toh debotar abas, insán or no!” ");
INSERT INTO rhgc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hérude Allar taarif nó goré de hétolla Mabud or ek fírista ye yóggwa re éhon agáṭ goijjé. Baade yóggwa re logé háifelaiye aar morigiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Montor Allar kalam fólat accíl aar imandár ókkol bicí ówat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bárnabas edde Sául ottu tobolik or ham goijjá ói baade, Yohánna re fúañti looi Jerúsalem ottu waafes giiyégoi. Hé Yohánna re Markus hoói yó ḍakitó. ");
INSERT INTO rhgc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Enṭiyok or zomát ot hoozzon nobi edde ustat accíl. Ítara óilde Bárnabas, Símiyon zibá re Halaiya ḍake, Kureni cóor or Lukiyus, hókumot-goróya Hérud or falok bái Manain, edde Sául. ");
INSERT INTO rhgc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ítara zeñtté ruza rakí Malik or ebaadot gorér, Pak-Ruh ye ítara re hoór de, “Bárnabas edde Sául ore oh ham olla háas gorí rakó, ze ham olla Añí ítara re ḍahaiyí.” ");
INSERT INTO rhgc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tói ítara ruza rakí edde dua gorí baade, hé duní zon or uore át dí ítara re bidai gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tói Bárnabas edde Sául ore Pak-Ruhr torfóttu difeṛá gíyeh. Baade ítara Selukíyat giiyé, aar héntu zaáñs ot góri Sáifrus ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ítara Salamis cóor ot foóñsi mottor Yohúdir mujilíc-hána ókkol ot Allar kalam tobolik gorát doijje. Ítarar fúañti modotgár ísafe Yohánna accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Guñṛa ḍiya báy zai ítara Pafós cóor foijjonto giiyé. Héṛe ítara eggwá Yohúdi jadugor edde misá nobi loot faáil zibár nam Bar-Isá. ");
INSERT INTO rhgc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Íte accíl hókumot-goróya Sergiyus Pául or dustó. Sergiyus ezzon buddíman manúc accíl, zibá ye Bárnabas edde Sául ore mataitó difeṛáil, aar ítara ttu Allar kalam fúinto saáil. ");
INSERT INTO rhgc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Montor jadugor Elumase (Yián óilde Girík zuban ot Bar-Isár dusára nam) ítarar muhálef goijjíl, aar hókumot-goróya re iman ottu larifelaito saáil. ");
INSERT INTO rhgc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Montor Sául zibá re Pául óu ḍake, íba Pak-Ruh lói furaiya ói ítar uzu suk lagaidi saái hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Tui Ibilíc or fua, tui hárr kisím or dúka edde férokbazi lói furaiya, aar hárr gom ham or duccon. Tui Malik or uzu rasta re behañ gorá bilkúl bon no goríbi níki? ");
INSERT INTO rhgc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Saá, Malik tor ulḍa tíyaiye. Tui añdá ói hooddin fán beil or foór úddwa no dekíbi.” Ebbe hétunot ítar uore kúwa edde andár aái foijjé; aar ítare át ot dóri loizai fare fán íte manúc átat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ziín óiye híin dekí hókumot-goróya wa ye iman ainné, kiyólla-hoilé yóggwa ye Malik or baabute ze taalim faiyé híin lói taajup óigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Baade Pául edde íbar sáañti ókkol, Pafós ottu zaáñs ot góri Pampúliyat asé de Perga cóor ot aiccé, montor Yohánna ye ítara re eri Jerúsalem ot waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lekin ítara Perga ttu zai Pisídiyat asé de Enṭiyok ot aiccé, aar ebaadot-or-din mujilíc-hánat zai boiccégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tourat edde nobi ókkol or kitab ottu telawot goijjá ói baade, mujilíc-hánar sóddar ókkole ítarar hañse hotá difeṛáiye de ki, “Báiyain, zodi tuáñra ttu honó nosíyoti hotá táke, tóoile boiyan goró.” ");
INSERT INTO rhgc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hétunot Páule tíyai, áte icára gorí hoór de, “Ó Boni Isráil ókkol, tuáñra zetará Alla re ḍooro, añr hotá fúno: ");
INSERT INTO rhgc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Boni Isráil or Alla ye añárar bafdada gún ore basíloil, aar ítara re Ijíp dec ot táite ḍoóñr koum banaidíl, aar Íbar kudurutir áte ítara re héntu neelai ainníl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Salic bosór foijjonto Íba ye moidan zagat ítarar adot ókkol ore bordac gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Yárbaade Íba ye Kánan mulluk or háñt twa zati re dónco gorífelai Nizor bonda ókkol ore ítarar mulluk híyan miras diiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Iín beggún óite tokoriban sair-có fonzaic bosór laiggé. “Yárbaade nobi Sémuel or októ foijjonto Alla ye ítara re bisarhar ókkol diiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Baade ítara eggwá baáñcca maiggé rár, Alla ye ítara re Binyamin or háandan ottu Kic or fua Sául ore diíl, zibá ye salic bosór foijjonto hókumot goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Alla ye Sául ore baáñccagiri ttu félaidi baade Dawud ore ítarar baáñcca banaáil, zibár baabute Íba ye yó gobá díye de ki, ‘Añí Añr mon or manúc ísafe Jesir fua Dawud ore faiyí, zibá ye Añr moncá beggún fura goríbo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Hé manúc cwar nosól ottu Alla ye Nizor waada mozin Boni Isráil ókkol olla eggwá Nejatdoya difeṛáiye, Íba óilde Isá. ");
INSERT INTO rhgc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Íba aibár age Yaháya ye tamám Boni Isráil ókkol or hañse touwár bápṭismar tobolik goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yaháya ye íbar tobolik or ham furussat goijjá óibarcot hoóil de, ‘Tuáñra añí hon bóuli ṭáaro? Tuáñra Zibár talac gorór Íba añí no. Montor soó, añí baade eén Ekzon aiyér zibár ṭéng or cenṭár or fíta kúli bolla úddwa añí laayek no.’ ");
INSERT INTO rhgc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ó báiyain, Ibrahím or fuain edde Alla re ḍooroya Beyohúdi ókkol, nejat or e hóbor añárar hañse foóñsa gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerúsalem or bácinda ókkole edde ítarar sóddar ókkole Isá re nó siné, aar hárr ebaadot-or-din nobi ókkol or ze boiyan ókkol telawot gorá zah, híin óu nó buzé, hétolla ítara Íba re fótua dí híin fura goijjé deh. ");
INSERT INTO rhgc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ítara Íba re mariféla fore de héndilla honó hosúri no faile yo, toóu Íba re marifélaito Filat ore aros goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Zeñtté ítara ttu Íbar baabute pak-kalam ot ziín asé híin beggún fura goijjá óiye, Íba re kúruc ottu lamai eggwá hobor ot raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Montor Alla ye Íba re mora ttu zinda goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aar Íba boóut din foijjonto uitarár hañse dahádiye, zetará Íbar fúañti Galil ottu Jerúsalem ot aiccíl. Ítara yala añárar koum or hañse Íbar gobá óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Añára tuáñrar hañse e kúcir hóbor gán boiyan gorír, ki hoilé, Alla ye añárar bafdada ókkol lói ze waada goijjíl, ");
INSERT INTO rhgc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","híyan Íba ye Isá re mora ttu zinda gorí ítarar fuain dor hañse, yáni añárar hañse fura goijjé. Zobur Córif or dui nombór rukút endilla asé, ‘Tuñí óilade Añr Fua, aijja Añí Tuáñr Baf óiyi.’ ");
INSERT INTO rhgc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Alla ye Íba re mora ttu zinda goijjé, hétolla Íbar haiya honódin no foñsibó. Alla ye endilla hoiyé, ‘Añí tuáñra re pak edde sóiyi niyamot diiyum, ziín Añí Dawud ore waada goijjílam.’ ");
INSERT INTO rhgc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hétolla Íba ye Zobur Córif or arek zagat óu hoiyé de, ‘Tuñí Tuáñr Pakzon or gaar haiya re foñsitó no diba.’ ");
INSERT INTO rhgc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawud toh íbar zobanat Allar moksót or hédmot gorí baade moot or gúm ot forigiyói. Íba re nizor bafdada ókkol or fúañti dohón gorá gíyl, aar íbar haiya foñsigílgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Montor Alla ye Zibá re mora ttu zinda goijjé Íbar haiya toh nó foñse. ");
INSERT INTO rhgc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Hétolla, ó báiyain, añr ttu tuáñra re yián zanaidito monehoór, ki hoilé, Isár duara guná maf faibar hotá tuáñrar hañse tobolik gorá zar. ");
INSERT INTO rhgc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tuáñra Muúsar Córiyot or duara ze guná ttu azad nó foo, híin beggún ottu uite azad faa zee niki Íbar uore iman ané. ");
INSERT INTO rhgc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hétolla úñciyar táikko, zeéne nobi ókkole boiyan goijjé de híin tuáñrar uore no, ki hoilé, ");
INSERT INTO rhgc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ó tooñcábazi-goróya ókkol, soó, taajup ó aar dónco óizogoi, kiyólla-hoilé Añí tuáñrar din ot endilla ekkán ham gorír, ziyán tuáñra re honókiye buzáidile yo ekin goittá no.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pául edde Bárnabas mujilíc-hána ttu neeli zaargói de októt, manúc ókkole aros gorát doijje de, ítara re e hotá iín aibó de ebaadot-or-din aró boiyan goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mujilíc fúrai baade boóut zon Yohúdi edde Yohúdir dórmot faráiye de boóut zon Beyohúdi, Pául edde Bárnabas or fisá doijje. Tará duní zone ítara llói hotábattara hoiyé, aar Allar rahámot ot lagi táki bolla ítara re tuaijjo diyé. ");
INSERT INTO rhgc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tarfo ebaadot-or-din cóor or beecbák manúc, Malik or kalam fúni bolla zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Montor manúc or dol dekí Yohúdi ókkol hásorote furaigiyói, aar ítara Páule hoór de hotár ulḍa hotá ókkol hoói yore íba re beizzoti goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hétunot Pául edde Bárnabase hímmot or sáañte hoór de, “Añára ttu Allar kalam ebbe age tuáñrar hañse tobolik gorár zorur accíl. Tuáñra zettót híin inkar goijjó aar nizoré ofúrani zindigir laayek no bóuli ṭáaijjo, yala añára Beyohúdi ókkol or híkka fírir. ");
INSERT INTO rhgc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kiyólla-hoilé Malike añára re endilla hókum díye de ki, ‘Añí tuáñra re Beyohúdi ókkol olla nur banaiyí, zeéne duniyair manúc beggúne nejat fa.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Híyan fúni Beyohúdi ókkol bicí kúci óiye aar Malik or kalam or taarif gorát doijje; aar zetará re ofúrani zindigi lla basílowa gíyl ítara beggúne iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Héndilla góri Malik or kalam hé elakar agagurat fóligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Montor Yohúdi ókkole ebaadotgár mocúr mayafuain ókkol ore edde cóor or sóddar ókkol ore uskaidiyé. Héengori ítara Pául edde Bárnabas or uore zulúm cúru gorá bay duní zon ore hé elaka ttu neelaidiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tói tará duní zone ítarar ulḍa ṭéng or tollar dúil zárifelai Ikóniya cóor ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Héṛiyar ummot ókkol kúciye edde Pak-Ruh lói furaiya ówat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikóniyat Pául edde Bárnabas Yohúdi ókkol or mujilíc-hánat giiyé. Héṛe tará eéngori tobolik goijjé, zeén níki Yohúdi edde Beyohúdi becábicí ye iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Montor ze Yohúdi ókkole iman nú ané ítara Beyohúdi ókkol ore uskaidi yore imandár báiyain dor ulḍa matá hóraf gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Toóu Pául edde Bárnabas héṛe boóut din táikkil; tará hímmot or sáañte Malik or baabute taalim dito, aar Malike tarár áta illayi-nicán ókkol edde taajuippa harhána ókkol dahái Íbar rahámot or hotá sóiyi dé sábut goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Montor cóor or manúc ókkol faáṭ-faáṭ óigilgoi; kessú Yohúdi ókkol or híkka, aar kessú sáhabi gún or híkka. ");
INSERT INTO rhgc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hétolla hodún Beyohúdi ye edde Yohúdi ye ítarar sóddar ókkol lói mili sólla goijjé de, Pául edde Bárnabas ore cíl or dola mari bolla edde beizzoti gorí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Montor tará híyan zani faijjé rár, héntu Lukáyoniya elakar cóor Lusítarat edde Darbit edde híin or atehañsór zaga ókkol ot dáigiyegoi, ");
INSERT INTO rhgc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","aar héṛe lagatar kúchóbor tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lusítarat ézzon leng manúc boói tákito. Íba héndilla zormo óoil, aar honódin áñṛi faijjé de nái. ");
INSERT INTO rhgc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hé manúc cwa Pául or boiyan fúnat accíl. Páule yóggwar uzu díyan dóri saiyé rár dekér de, yóggwa ttu gom ói bolla iman asé, ");
INSERT INTO rhgc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","hétolla íba ye eggwá ḍoóñr abase ḍak mari hoór de, “Tuáñr ṭénge uzu gorí tíyo.” Hétunot yóggwa fál mari tíyaiye aar áñṛat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Páule goijjé de ham mán dekí manúc ókkole guzori Lukáyoniya zubane hoór de, “Añárar hañse insán or súrote debota ókkol lami aiccé!” ");
INSERT INTO rhgc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ítara Bárnabas or nam dyíl Zeyus, aar Pául or nam dyíl Harmis, kiyólla-hoilé íba ye kalam or hotá bicí hoitó. ");
INSERT INTO rhgc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeyus debotar mondir gán cóor or ekkágori baáre accíl. Híyan or imame cóor or geiṭ ot biríc goru ókkol edde golar mala ókkol ainníl, kiyólla-hoilé ítar ttu edde manúc or dol ottu Pául edde Bárnabas or hañse kurbani peec goittó mon accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Montor sáhabi Bárnabase edde Páule híyan fúinne rár, nizor gair or hoor fáṛifelaiye, aar manúc or dol lwát duñri zai guzori-guzori hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ó dustó ókkol, tuáñra iín kiyólla gorór? Añára yó de tuáñrar ḍóilla insán. Añára tuáñrar hañse kúchóbor tobolik gorír de ki hoilé, tuáñra e behar siz iín ottu zinda Allar uzu fíro, zibá ye asman, zobin, doriya, edde híin or bútore ziín asé híin beggún foida goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Agor zobanat Íba ye tamám koum ókkol ore nizor-nizor mon mozin soilto dyíl. ");
INSERT INTO rhgc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Toóu Íba ye tuáñrar hañse endilla siz ókkol dii raikké ziíne Íbar gobá déh. Íbar meérbani iíne zahér ó, ki hoilé, Íba ye tuáñra re asman ottu zór dee edde moósum mozin fósol ókkol dee; Íba ye tuáñra re hána dee edde tuáñrar dil kúciye furaide.” ");
INSERT INTO rhgc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hotá híin hoói baade yo, manúc ókkol ore bicí mockil or sáañte tarár hañse kurbani peec gorá ttu bon gorá foijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lekin Enṭiyok ottu edde Ikóniya ttu hoozzon Yohúdi héṛe aái manúc ókkol ore nizor híkka gorífelaiye. Baade ítara Pául ore cíl or dola maijjíl, aar íba morigiyói bóuli ṭáari señsai-señsai cóor or baáre loigiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Montor ummot ókkol íbar sairókul ttu zoma ói baade, íba uṛí cóor or bútore waafes giiyégoi. Aar tarfor din íba Bárnabas or fúañti Darbi cóor ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tará Darbit kúchóbor tobolik gorí becábicí ummot ókkol banaiyé. Baade tará abar Lusítarat, Ikóniyat, edde Enṭiyok ot fírigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Héṛe tará ummot ókkol or dil ore mozbut goijjíl, aar iman ot lagi tákito nosíyot gorí hoiyé de, “Allar raijjot góilte añára ttu hámaha bicí mosibot ókkol bordac gorá foribó.” ");
INSERT INTO rhgc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Páule edde Bárnabase hárr zomát ot murubbi-neta ókkol tuillé, aar ruza rakí edde dua gorí ítara re Malik or át ot gosáidiye, zibár uore ítara iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tarfore tará Pisídiya elaka báy zai Pampúliyat aiccé, ");
INSERT INTO rhgc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","aar Perga cóor ot kúchóbor tobolik gorí Attaliya cóor ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Baade héntu zaáñs ot góri waafes Enṭiyok olla rowana loiyé, zeṛé tará re ham uúin goittó Allar rahámot or át ot gosáidiya gíyl ziín tará ttu fura goijjá óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tará héṛe foóñsi baade zomát or manúc beggún ore zoma goijjé, aar Alla ye tarár áta ziín-ziín goijjé híin beggún ítarar hañse boiyan goijjé, aró boiyan goijjé de, Alla ye Beyohúdi ókkol olla yó iman or duwar kúille. ");
INSERT INTO rhgc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Baade tará héṛe ummot ókkol or fúañti boóut din táikke. ");
INSERT INTO rhgc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yohúdiya ttu kessú manúc nise aái imandár báiyain dore endilla taalim diyat doijje de, “Zodi Muúsar Córiyot mozin ázomi no goró, tuáñra nejat fai no faribá.” ");
INSERT INTO rhgc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Híyan ot Páule edde Bárnabase ítara llói doró torkatorki edde barábari díye. Ahérit zomáte fáisela lóiye de, Pául, Bárnabas edde ítarar bútottu hoozzon manúc uore Jerúsalem zai sáhabi gún lói edde buzurgó ókkol lói e mosólar baabute mocuwara gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Baade zomáte tará re difeṛáiye; tará Fonikcíyar edde Samáriar bútottu zaite-zaite héṛe imandár báiyain dore zanaiyé de, Beyohúdi ókkol keéngori Allar uzu fírer; híyane ítara beggún or hañse bicí kúci ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tará zeñtté Jerúsalem ot foóñicce, zomát or maincé, sáhabi gúne edde buzurgó ókkole tará re estekbal goijjé, baade Alla ye tarár áta ziín-ziín goijjé híin beggún ítarar hañse boiyan goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Montor Féroci fírka ttu imandár boinné de hoozzone uṛí hoór de, “Beyohúdi ókkol ottu ázomi gorár zorur aar ítara re Muúsar Córiyot amól gorí bolla hókum díyar zorur.” ");
INSERT INTO rhgc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hétunot sáhabi gúne edde buzurgó ókkole hé mosóla gán or uore báfi bolla zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Héṛe boóut torkatorki ói baade Fitore uṛí ítara re hoór de, “Ó báiyain, tuáñra toh zano, boóut din age Alla ye añré tuáñrar héntu basíloiye, zeéne añr muk ottu Beyohúdi ókkole kúchóbor or hotá fúni iman ané. ");
INSERT INTO rhgc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Aar Alla, zibá ye fottí ekzon or dil zane, Íba ye Beyohúdi ókkol ore yó kobul goré de híyan ítara re Pak-Ruh dii yore sábut goijjé, zendilla Íba ye añára re yó diíl. ");
INSERT INTO rhgc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Íba ye añárar edde ítarar bútore honó forók nó goré, kiyólla-hoilé Íba ye toh ítara iman anóne ítarar dil ore yó sáf goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tói yala, ze zuañl añárar bafdada ókkole boói nó fare aar añára yó nó fari, yíba ummot ókkol or hañd ot tulídi Alla re kiyólla entán gorór? ");
INSERT INTO rhgc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Añára biccác gorí de, añára nejat faiyí de Malik Isár rahámote, zendilla ítara yó faiyé.” ");
INSERT INTO rhgc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Hétunot manúc beggún nizám mári táikkil, aar Pául edde Bárnabas or áta Alla ye Beyohúdi ókkol or hañse ze illayi-nicán ókkol edde taajuippa harhána ókkol daháil híin tará ttu fúnat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tará ttu hotá hoiyá ói baade, Yakube hoór de, “Báiyain, añr hotá fúno. ");
INSERT INTO rhgc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sáimone añára re buzáidiye, Alla ye Beyohúdi ókkol or bútottu Nizor lla eggwá koum basíloito cúrut hondilla gori ítarar uzu nozor diyé deh. ");
INSERT INTO rhgc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Hotá híyan lói nobi ókkol or hotá yó mil há; pak-kalam ot endilla asé, ");
INSERT INTO rhgc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Híin baade Añí waafes aiccúm, aar Dawud or raijjo re agor ḍóilla banai felaiyum. Híyan or báñgasúra ókkol hónggori yore abar doró goríyum, ");
INSERT INTO rhgc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","zeéne ar baki insán beggúne Mabud ore tuwa, tamám Beyohúdi ókkole úddwa, zetará re Añr bonda ói bolla ḍaha giyéh. Mabude héndilla fórmaiye, zibá ye híin ");
INSERT INTO rhgc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","boóut age lóti zanaidi di aiyér.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakube aró hoór de, “Hétolla añr rai óilde, Beyohúdi zetará Allar uzu fírer ítara re añára tokolif no dih, ");
INSERT INTO rhgc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","bólke añára ítarar hañse endilla lekí, ítara zen muttir hañse kurbani diya nafak hána na háa, zená no goré, gola sibi marifélaiya januwar or gusso na háa, edde lou na háa. ");
INSERT INTO rhgc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kiyólla-hoilé Muúsar Córiyot toh agor zobana ttu lóti fottí cóore-cóore tobolik gorá zar, aar fottí ebaadot-or-din mujilíc-hána ókkol ot telawot gorá zar.” ");
INSERT INTO rhgc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Baade sáhabi gúne edde buzurgó ókkole zomát or manúc beggún lói mili fáisela goijjé de, ítarar bútottu hoozzon manúc basíloi Pául edde Bárnabas or fúañti Enṭiyok ot difeṛáibo. Ítara basíloiye de óilde, imandár báiyain dor bútore sóddar accíl de Yohúdah re, zibá re Barsába bóuli hoó, edde Sílas ore. ");
INSERT INTO rhgc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tarár áta ítara e ceñṛí gán difeṛáil: “Enṭiyok ot, Siíriyat, Kilicíyat asó de Beyohúdi imandár báiyain, tuáñrar báiyain añára sáhabi gún or edde buzurgó ókkol or torfóttu tuáñra re sólam. ");
INSERT INTO rhgc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Añára fúinni de, añárar héntu hoozzon manúc añárar honó hókum sára aái tuáñra re tarár hotá lói ferecan goijjé, aar tuáñrar dil ot duk diyé. ");
INSERT INTO rhgc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hétolla añára beggúne razirobbot ói fáisela goijjí de, hoozzon manúc basíloi tuáñrar héṛe añárar adorja Bárnabas edde Pául or fúañti difeṛái bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bárnabas edde Pául óilde endilla manúc zetará añárar Malik Isá Mosihr nam or wasté nizor zan hótarat félaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Añára Yohúdah re edde Sílas ore tuáñrar hañse difeṛáir, zetará nizor muké tuáñra re añára leikkí de híin forí fúnaibo. ");
INSERT INTO rhgc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pak-Ruh ttu edde añára ttu gom laiggé de, e zoruri hotá gún baade tuáñrar uore ar honó fuñzá tulí no di bolla, ");
INSERT INTO rhgc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ki hoilé, tuáñra muttir hañse kurbani diya hána ókkol na háiyo, lou na háiyo, gola sibi marifélaiya januwar or gusso na háiyo, edde zená no goríyo. Zodi tuáñra híin gorá ttu basi táko, bála óibo. Kúda háfiz.” ");
INSERT INTO rhgc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Baade tará re difeṛá gíyeh, aar tará nise Enṭiyok ot giiyé. Héṛe tará zomát or manúc beggún ore zoma gorí ceñṛí gán diiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Manúc ókkole ceñṛí gán forí nosíyoti hotá loot faiyé rár, bicí kúci óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yohúdah edde Sílas, zetará nize nobi, tará imandár báiyain dore boóut hotá lói nosíyot goijjíl edde mozbut goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tará héṛe boóut din táki baade, imandár báiyain de tará re cántir dua loi bidai diyé, zeéne zetará tará re difeṛáiye ítarar héṛe tará waafes zaigói fare. ");
INSERT INTO rhgc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lekin Sílas ottu héṛe táaiza gom laiggíl. ");
INSERT INTO rhgc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pául edde Bárnabas óu Enṭiyok ot aró táikkil, aar héṛe tará aró bicí maincór fúañti manúc ókkol ore Malik or kalam or taalim diyat edde tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hooddin baade Páule Bárnabas ore hoór de, “Aiyó, añára ze cóor gún ot Malik or kalam tobolik goijjílam híin ot waafes zai imandár báiyain ókkol keén asé saáigoi.” ");
INSERT INTO rhgc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bárnabase Yohánna re fúañti loizaitó saáil. Hé Yohánna re Markus hoói yó ḍake. ");
INSERT INTO rhgc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Montor Páule íba re loizon gom no óibo bouli báippil, kiyólla-hoilé yár age íba ye ítara re Pampúliyat félai zai ítarar fúañti ham ar nó goré. ");
INSERT INTO rhgc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Híyan olla ítarar bútore eén torkatorki óiye zeén níki ítara ezzon ottu ezzon síra óigiyoi. Baade Bárnabase Markus ore fúañti looi zaáñs ot góri Sáifrus olla bacá lóiye. ");
INSERT INTO rhgc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Montor Páule Sílas ore baiccé, aar imandár báiyain de ítara re Malik or rahámot or át ot gosáidi baade ítara rowana loiyé, ");
INSERT INTO rhgc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","aar zomát or manúc ókkol ore iman ot mozbut gorái-gorái Siíriya edde Kilicíya báy zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Zaite-zaite Pául Darbi cóor ot foóñicce, baade Lusítara cóor ot. Héṛe Timóti nam or ezzon ummot accíl. Yóggwar maa óilde ezzon Yohúdi zibá imandár boinné, montor yóggwar baf accíl de Girík koum. ");
INSERT INTO rhgc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lusítarat edde Ikóniyat asé de imandár báiyain de yóggwar nam goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pául ottu yóggwa re fúañti loizaitó monehoiyé, hétolla yóggwa re héṛiyar Yohúdi ókkol or zoriya ázomi goráil, kiyólla-hoilé yóggwar baf Girík koum de híyan ítara beggúne zainto. ");
INSERT INTO rhgc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tará cóore-cóore zai hookkán niyom uúin mani bolla zanaidíl ziín Jerúsalem or sáhabi gúne edde buzurgó gúne zari goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Héndilla góri zomát or manúc ókkol iman ot mozbut ówat accíl, aar ítarar dol dinbodin barát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pául edde íbar sáañti ókkol Fergiya edde Galatíyar elaka báy zaat doijje, kiyólla-hoilé Pak-Ruh ye tará re Ecíyat tobolik no goittó maná goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tará Misíya elakar címat foóñsi baade Bitúniya zilár bútore zai bolla kucíc goijjíl, montor Isár Ruh ye tará re zaito nó deh. ");
INSERT INTO rhgc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hétolla tará Misíya báy zai nise Toras cóor ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Héṛe Páule raitta ekkán dorcón ot dekér de, Makedóniyar ézzon manúce tíyai yore íba re bicí aros gorí hoór de, “Makedóniyat aái yore añára re modot gorógai.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Páule dorcón nán dekí baade, añára Makedóniyat zai bolla éhon toiyar óigiyigoi, kiyólla-hoilé añára buzí faijjí de, ítarar hañse kúchóbor tobolik gorí bolla Alla ye añára re ḍaikké. ");
INSERT INTO rhgc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hétolla añára Toras ottu zaáñs ot góri ruúru Samotarak ḍiyat giílam, aar tarfor din Niyapúlis cóor ot. ");
INSERT INTO rhgc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Baade héntu Filíppi cóor ot giiyí, ziyán Makedóniyar meén cóor aar Romi ókkol táke de zaga. Añára héṛe hooddin táikkilam. ");
INSERT INTO rhgc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ebaadot-or-din añára cóor or geiṭ or baáre hál or hañsat giiyí, ṭáaijjilam de héṛe dua goittó ekkán zaga faiyum. Añára boói yore hodún beṛiyáin lói hotá hoóilam zetará héṛe zoma óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Fúner de ítarar bútore Tuatíra cóor or Liídiya nam or eggwá mayafua accíl, zibá ye bayoinna rong or hoor besitó. Híba Allar ebaadotgár accíl. Pául or boiyan díyan dí fúni bolla Malike híbar dil kúlidil. ");
INSERT INTO rhgc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Zeñtté híba ye edde híbar gór ṭíya ye bápṭisma loiyé, híba ye añára re eén hoói nizor gór ot dawot dyíl, “Zodi tuáñra añré Malik or imandár bóuli ṭáaro, tóoile aái añr gór ot tákogai.” Héndilla hoói híba ye añára re mojbur goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ek din añára duar zagat zair de októt eén óiye, añára re ek bañdi ye loot faiyé zibá re eggwá gonot bonar jine faiyé. Híba ye agun hotá hoói-hoói nizor girós ókkol olla bicí ṭiañ-foicá hamaitó. ");
INSERT INTO rhgc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Híba ye Pául or edde añárar fisé-fisé aái guzori hoór de, “Manúc itará óilde Alla Tálar gulam, zetará tuáñrar hañse nejat or rastar hotá boiyan gorér.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Híba ye héndilla boóut din fán gorát accíl. Ahérit Pául ottu bezar laiggíl, aar fíri hé jin nwá re hoór de, “Añí toré Isá Mosihr name hókum dír, tui ibáhr bútottu neelizagói.” Hétunot jin nwá híbar bútottu neeligiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Montor hé bañdir girós ókkole dekér de, ítara ṭiañ hamai faribár acá ar nái, hétunot ítara Pául edde Sílas ore dóri somónit adikari ókkol or hañse ṭani-ṭani loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ítara tará re Romi bisarhar ókkol or hañse aní hoór de, “Manúc iíne añárar cóor ot úrussul foida gorér; itará óilde Yohúdi; ");
INSERT INTO rhgc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","itará eén rosóm ókkol cíkar ziín añára Romi ókkol olla gosón yáh manon zayes no.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Awam ókkol óu Pául edde Sílas or hélaf ítarar bóng ot góille. Tói bisarhar gúne hókum díye de, tarár gair or hoor fáṛifelai tará re bet mari bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ítara tará re bicígori mari baade ziyól ot díyl, aar tará re mozbut gori faáradi bolla ziyól or zimmadar ore hókum díyl. ");
INSERT INTO rhgc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tói zimmadar gwá ye hé hókum fai yore tará re ziyól or ebbere bútor or kamárat raikké, aar tarár ṭéng gun berít gólaidiye. ");
INSERT INTO rhgc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Baade tokoriban adá raitta Pául edde Sílas dua gorér edde Allar taarif or seér gaár, aar baki hodi ókkole híin fúnat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Atíkka héṛe eggwá ettór ḍoóñr búsal aiccé, zeén níki ziyól-hánar guijja úddwa tóttoraiye. Hétukkun ot ziyól or doroza beggún edde hodir síyol lun kúligiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Zeñtté ziyól or zimmadar gwá gúm ottu tám faiyé, yóggwa ye ziyól or doroza gún kúla deikké rár súri neelai nizoré nize marifélaito saiyé, kiyólla-hoilé yóggwa ye ṭáaijjil de, hodi ókkol dáigiyegoi. ");
INSERT INTO rhgc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Montor Páule eggwá ḍoóñr abase ḍák mari hoór de, “Nizoré hóti no goijjó; añára beggún eṛé así.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hétunot yóggwa ye batti magai duñri bútore giiyé, aar hafi-hafi Pául edde Sílas or ṭéng or gurat foijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Baade yóggwa ye tará re baáre aní fusár gorér de, “Jii, nejat faite añr ttu kii gorá foribó?” ");
INSERT INTO rhgc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tará zuwab der de, “Malik Isár uore iman anó, tói tuñí edde tuáñr gór ṭíya ye nejat faiba.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tarfore tará yóggwa re edde yóggwar gór or beggún ore Malik or kalam fúnaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hé rait or hé októt ziyól or zimmadar gwá ye tará re loizai tarár zohóm ókkol dúifelaiye, baade yóggwa ye edde yóggwar gór ṭíya ye éhon bápṭisma loiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tarfore yóggwa ye tará re nizor gór ot aní hána diiyé. Allar uore iman aní yóggwa edde yóggwar gór ṭíya bicí kúci óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tarfor din biínna óiye rár, bisarhar gúne ziyól or zimmadar or hañse fulic ókkol difeṛái hoór de, “Manúc cún ore hálas gorí doh.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Hétunot ziyól or zimmadar gwá ye Pául ore hoór de, “Tuáñra duní zon ore hálas gorídi bolla bisarhar ókkole hókum díye. Tuáñra yala zaigói faribá; cántir sáañte zoogói.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Montor Páule fulic cún ore hoór de, “Añára hódun Romi manúc ói baade yo ítara añára re bisar ot no tulí beggún or muúntu bet mari ziyól ot díye, aar ehón ítara añára re nizám or sáañte hálas gorí dér de níki? Héndilla bilkúl ói no faribó; ítara nizebaze aái añára re hálas goróukgai.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Baade fulic cúne hotá híin bisarhar gún ore zanaiyé, aar Pául edde Sílas Romi manúc de fúni ítara ḍooraigiyói. ");
INSERT INTO rhgc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ítara aái tará ttu maf saiyé, aar tará re ziyól or baáre aní aros gorér de, “Meérbani góri cóor gán ottu zoogói.” ");
INSERT INTO rhgc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tará ziyól ottu hálas ói baade Liídiyar gór ot giiyé; héṛe tará imandár báiboináin ókkol lói dola óiye, aar ítara re hímmot díye. Tarfore tará héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tará Amfipolis edde Apoloníya cóor báy zai Tisólonika cóor ot aiccé, zeṛé Yohúdir ekkán mujilíc-hána accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Páule nizor niyom mozin mujilíc-hánat giiyé, aar lagatar tin ebaadot-or-din foijjonto ítara llói pak-kalam ottu toskara ókkol goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Íba ye toskara gorí buzár de edde dolil der de ki, Mosih ttu duk faibar edde mora ttu zinda ówar zorur accíl. Íba ye hoiyé de, “Añí tuáñra re ze Isár baabute boiyan gorír, Íba óilde hé Mosih.” ");
INSERT INTO rhgc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ítara hoozzone iman aní Pául edde Sílas lói bóng óiye, héndilla ḍoóñr ek dol Girík dindár manúc edde boóut zon mocúr mayafuain óu bóng óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Montor ar baki Yohúdi ókkol ottu gairot lagi bazar ottu hodún hóraf manúc lói eggwá ḍaái baindé aar cóor ot úrussul foida goijjé. Ítara Jason or gór ore hámla gorí Pául edde Sílas ore tuwaiyé, zeéne tará re awam ókkol or muúntu aní fare. ");
INSERT INTO rhgc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Montor tará re zettót tuwai nó faa, ítara Jason edde kessú imandár báiyain dore ṭani-ṭani cóor or adikari ókkol or muúntu ainné, aar guzori hoór de, “Manúc itará fura duniyait ferecani foida gorí yala eṛé yó aiccé, ");
INSERT INTO rhgc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aar Jasone itará re nizor gór ot zaga diiyé. Itará beggúne baáñcca Káisar or hókum or ulḍa goré, aar hoó de, Káisar bade aró ekgwá baáñcca asé, zibár nam Isá.” ");
INSERT INTO rhgc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Héndilla hoói ítara awam ókkol or edde cóor or adikari ókkol or matá hóraf góridiye. ");
INSERT INTO rhgc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Montor Jason edde oinno manúc ókkol tará lla zabin óiye rár, sóddar ókkole tará re eridiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hé din raitta imandár báiyain de toratori Pául edde Sílas ore Beriyat duñraidiyé. Héṛe foóñsi yore tará Yohúdir mujilíc-hánat giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Héṛiyar Yohúdi híin Tisólonika cóor or Yohúdi ókkol or túaro cáda-cída accíl, kiyólla-hoilé ítara ḍoóñr azzuye kalam fúni kobul goijjíl. Ítara Páule ziín hoitó híin fottí din pak-kalam tahákit gorí sóiyi né na sóiyi saitó. ");
INSERT INTO rhgc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hétolla ítara ttu boóut zone iman ainné; héndilla boóut zon Girík mocúr mayafuain edde morotfuain de yó iman ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Montor Tisólonikar Yohúdi ókkole zeñtté Páule Beriyat óu Allar kalam tobolik gorér de fúinne, ítara héṛe yó zai manúc ókkol ore uskaidi oulzóul foida goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hétolla imandár báiyain de toratori Pául ore doijjar hañsat duñraidiyé, montor Sílas edde Timóti héṛe táigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Zetará Pául ore baráidito giíl ítara íba re Aten cóor foijjonto foóñsaidiye, aar Sílas edde Timóti zendilla fare héndilla hára Pául or hañse ai bolla hókum fai yore ítara waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Páule Aten cóor ot Sílas olla edde Timóti lla entezar gorér de októt, hé cóor gán mutti loi furaiya de dekí íba ttu dil ot bicí ferecan laiggíl. ");
INSERT INTO rhgc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hétolla íba ye mujilíc-hánat Yohúdi edde dindár Beyohúdi ókkol lói toskara ókkol goittó, héndilla somónit zai zetará re lootfa ítara llói yó fottí din goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ipíkuri edde Stoiki fírkar hoozzon úzure yó íba llói barábari díyat doijje, hodúne hoór de, “E fálṭu ite kii hoitó sár dé?” Ar hodúne hoór de, “Ite toh eggwá bidecí debotar baabute taalim der fán lager.” Ítara e hotá etollá hoiyé, kiyólla-hoilé Páule Isár baabute edde mora ttu zinda ówar baabute kúchóbor tobolik gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ítara Pául ore Ariyopagus mujilíc or héṛe aní fusár gorér de, “Tui ze noya taalim ekkán doór híyan kii añára zani faijjum né? ");
INSERT INTO rhgc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kiyólla-hoilé tui toh añárar han ot endilla hotá ókkol anór, ziín honódin fúna nó zah, hétolla añára ttu híin or sóiyi maáni zainto monehoór.” ");
INSERT INTO rhgc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tamám Ateni ókkol edde bidecóitta ókkol zetará hé cóor ot tákito, ítara siríf noya-noya hotá ókkol howát edde fúnat ṭaim haṛaitó. ");
INSERT INTO rhgc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Páule Ariyopagus mujilíc ot tíyai hoór de, “Ó Ateni ókkol! Añí dekír de, tuáñra hárr mikká ttu bicí dindár. ");
INSERT INTO rhgc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kiyólla-hoilé añí berai-berai tuáñra fuñza goró de jiníc ókkol díyan dóri saáir de októt, añí endilla ekkán kurbani-gáñ yó deikkí ziyán ot leikká asé de, ‘OSIN KÚDAR HAÑSE.’ Hétolla tuáñra no zani zibár fuñza gorór, añí íbar baabute boiyan gorír deh. ");
INSERT INTO rhgc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ze Alla ye duniyai re edde híyan ot asé de híin beggún foida goijjé, Íba zettót asman zobin or Malik, Íba insán or áte banaiya mondir ókkol ot no táke. ");
INSERT INTO rhgc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Íba honó kessúr muútac ot no fore, hétolla Íba ttu insán or át or honó hédmot or zorur nái, kiyólla-hoilé Íba Nize fottíkiyo re zindigi dee, niyác dee edde beggún dee. ");
INSERT INTO rhgc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ekzon manúc ottu Íba ye fura duniyait táki bolla tamám koum ókkol foida goijjé, aar ítara hoñtté hon zagat tákibo híin óu Íba ye age lóti fáisela gorí raikké. ");
INSERT INTO rhgc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Alla ye héndilla etollá goijjé, zeéne ítara átai-átai tuwai faibar acáye Íbar talac goré, montor háleke Íba añára honókiyo ttu duré de no. ");
INSERT INTO rhgc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kiyólla-hoilé añára toh Íbar bútore zindigi haṛai, solafíra gorí edde zinda así. Tuáñrar kessú cáir ókkole úddwa endilla hoiyé, ‘Añára yó Íbar fuain.’ ");
INSERT INTO rhgc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Hétolla, añára zettót Allar fuain, añára ttu endilla kíyal nu aná foribó de ki, Kúdayi hoó de híyan cúna, sañdi, yáh fattór or ḍóilla ekkán sóbi, ziyán or cokól insán or añka edde báfani lói bana giyéh. ");
INSERT INTO rhgc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Agor zobanat manúc ókkole Alla re no zainto de híyan Íba ye dekíle yo nó deké fángori tákito, montor yala Íba ye hárr zagar manúc beggún ore touwá gorí bolla hókum der. ");
INSERT INTO rhgc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kiyólla-hoilé Íba ye ekgwá din ṭík gorí raikké, ze din ot Íba ye Nizor basíloiya Manúc cwar áta insáf lói duniyair bisar goríbo. Íba ye híyan Íba re mora ttu zinda gorí manúc beggún or hañse sábut goijjé.” ");
INSERT INTO rhgc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Zeñtté ítara mora ttu zinda ói uṛár baabute fúinne, hoozzone Pául ore téceraiye, montor ar hodúne hoór de, “Añára yián or baabute tuáñr ttu arek motto fúniyum.” ");
INSERT INTO rhgc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Baade Pául hé mujilíc ottu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Hoozzon manúc íba llói bóng díye aar iman ainné. Imandár ítarar bútore mujilíc híyan or membór Diyonísiyus accíl, Damari nam or eggwá mayafua accíl, fúañti aró hoozzon accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yárbaade Pául Aten cóor ottu bacá lói Kórin cóor ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Héṛe íba ye Ekúila nam or ézzon Yohúdi loot faiyé, zibá Pontus ot zormo óoil. Baáñcca Kalediyuse Yohúdi beggún ore Rom sári zaitogói hókum díyl de hétolla, yóggwa kessú ṭaim age yóggwar bou Prisíla re looi Iṭali ttu aáigilgoi. Páule ítara re saitó giiyé, ");
INSERT INTO rhgc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","aar íba yó zettót ítarar ḍóilla ṭambu-ṭakoya, íba ítarar fúañti táki ham goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Íba ye fottí ebaadot-or-din mujilíc-hánat toskara ókkol gorí-gorí Yohúdi ókkol ore edde Girík ókkol ore boṛai aníbar kucíc goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Zeñtté Sílas edde Timóti Makedóniya ttu aiccé, Páule kalam tobolik gorát furafuri lagi táka cúru goijjé. Íba ye Yohúdi ókkol or hañse gobá díto de, Isá óilde Mosih. ");
INSERT INTO rhgc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Montor Yohúdi ókkole zettót Pául or muhálefi edde beizzoti gorér, íba ye ítarar ulḍa nizor gair or hoor zárifelai hoór de, “Tuáñrar lou wór zimma tuáñrar matár uore óuk! Añí behosúr. Añí ehón ottu lóti Beyohúdi ókkol or héṛe zaiyumbói.” ");
INSERT INTO rhgc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yárbaade Pául mujilíc-hána sári ek manúc or gór ot giiyé, zibár nam Titus Yustus. Yóggwa Allar ebaadotgár accíl, aar yóggwar gór gán mujilíc-hánar ḍáke accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mujilíc-hánar sóddar Krispuse edde yóggwar gór ṭíya ye Malik or uore iman ainníl, héndilla Pául or boiyan fúni boóut Kórintióle yó iman ainníl aar bápṭisma lóil. ");
INSERT INTO rhgc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ek din raitta Malike Pául ore ekkán dorcón ot hoór de, “No ḍooraic, bólke howát ták, nizám ói no tákic, ");
INSERT INTO rhgc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kiyólla-hoilé Añí tor fúañti-fúañti así. Tor hóti gorí bolla toré honókiye hámla no goríbo, kiyólla-hoilé e cóor ot Añr ttu bicí manúc asé.” ");
INSERT INTO rhgc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tói Pául der-bosór foijjonto Kórin ot táki maincóre Allar kalam or taalim dyíl. ");
INSERT INTO rhgc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Montor Galiyo zeñtté Akaya elakar hókumot-goróya accíl, Yohúdi ókkol ektofák ói Pául or hélaf tíyaiye aar íba re adalot ot ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ítara hoór de, “Manúc ibá ye maincóre Allar ebaadot endilla torikaye goittó uskaider, ziyán Córiyot or ulḍa.” ");
INSERT INTO rhgc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Páule hotá howá cúru goitté, Galiyo ye Yohúdi ókkol ore hoór de, “Ó Yohúdi ókkol, zodi tuáñrar elzam yián honó sóiyi hosúrir yáh gollot ham or baabute óito, tóoile tuáñrar hotá fúnon añr lla hazor óito. ");
INSERT INTO rhgc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Montor yián ot zettót taalim, nam edde tuáñrar nizor córiyot or baabute súwal gólaiya asé, yián ore tuáñra nizebaze hól gorógoi; añí endilla maamelar bisarhar óito no saáir.” ");
INSERT INTO rhgc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Héen hoói yóggwa ye ítara re adalot ottu duñraidiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hétunot ítara beggúne mujilíc-hánar sóddar Sostin ore dóri yore adalot or muúntu mara-dóra goijjé. Montor Galiyo ye híin or híkka honó díyan nó deh. ");
INSERT INTO rhgc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pául Kórin ot boóut din táki baade, imandár báiboináin dor ttu bidai loi zaáñs ot góri Siíriya mulluk ot zai bolla rowana óiye; fúañti Prisíla edde Ekúila yó accíl. Kinkíriya cóor ot táite íba ye nizor sul haṛifelail, kiyólla-hoilé íba ekkán manoc or tole accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tará Ífisas cóor ot foóñsi baade Páule Prisíla edde Ekúila re héṛe raikké. Baade íba nize mujilíc-hánat zai yore Yohúdi ókkol lói toskara gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yohúdi ókkole íba re aró hooddin ítarar fúañti táki bolla aros goijjíl, montor íba razi nó. ");
INSERT INTO rhgc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bólke zaibarcót ítara re hoór de, “Alla ye sailé añí tuáñrar hañse abar aiccúm.” Baade íba zaáñs ot góri Ífisas ottu rowana óiye, ");
INSERT INTO rhgc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","aar Kaisáriyat lami baade uore Jerúsalem ot giiyé. Tarfore héṛiyar zomát or manúc ókkol ore sólam zanai Enṭiyok ot giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Héṛe hooddin táki baade íba Galatíya edde Fergiya elakar agagurat zai-zai ummot ókkol or iman mozbut gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Hé októt Apólos nam or ézzon Yohúdi Ífisas ot aiccíl, zibá Alexzendariya cóor ot zormo óoil. Yóggwa ye cúndorgori waáz goittó, aar pak-kalam furafuri zainto. ");
INSERT INTO rhgc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yóggwa ye Malik or torikar baabute taalim faáil, aar bicí josbar sáañte Isár baabute sóiyigori taalim dito edde cíkka díto, montor yóggwa ye zainto de siríf Yaháyar bápṭismar baabute. ");
INSERT INTO rhgc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yóggwa ye hímmot or sáañte mujilíc-hánat waáz gorát doijje, montor Prisíla ye edde Ekúila ye zeñtté yóggwar hotá fúinne, ítara yóggwa re ítarar gór ot loizai Allar rastar baabute aró cúndorgori buzáiye. ");
INSERT INTO rhgc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apólos ottu Akaya elakat zaito monehoiyé rár, Ífisas or imandár báiboináin ókkole yóggwa re hímmot díye, aar yóggwa re estekbal gorí bolla héṛiyar ummot ókkol or hañse ekkán ceñṛí leikké. Aar zetará Allar rahámote iman ainné ítara re yóggwa ye héṛe foóñsi baade bicí modot goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kiyólla-hoilé yóggwa ye Isá óilde Mosih de híyan pak-kalam ottu dolil diyat accíl, aar héndilla gorí yóggwa ye manúc ókkol or muúntu Yohúdi ókkol ore zuresúre gollot sábut goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apólos Kórin ot tákite, Pául Ecíya elaka báy sofór gorí Ífisas ot aiccé. Héṛe íba ye hoozzon ummot loot faáil. ");
INSERT INTO rhgc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Íba ye ítara ttu fusár gorér de, “Tuáñra iman ainnó de októt Pak-Ruh faáila né?” Ítara zuwab der de, “Nó fai, añára toh Pak-Ruh asé bóuli úddwa nó fúni.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Hétunot Páule fusár gorér de, “Tóoile tuáñra har bápṭisma loiyó dé?” Ítara zuwab der de, “Yaháyar bápṭisma.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Páule hoór de, “Becók Yaháya ye touwár bápṭisma díye. Montor íba ye toh manúc ókkol ore endilla hoóil, ‘Añí baade aibó de Íbar uore iman aníyo, yáni Isár uore.’” ");
INSERT INTO rhgc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hotá híyan fúni ítara Malik Isár name bápṭisma loiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Aar Páule ítarar uore át díye rár, ítarar uore Pak-Ruh aiccé, baade ítara gabi zubane hotá howát doijje, aar Allar kalam boiyan gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ítara tokoriban baró zon beṛaáin accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Yárbaade Pául mujilíc-hánat zai tin mac hímmot or sáañte tobolik goijjíl, aar Allar raijjor baabute toskara ókkol gorí ítara re boṛaibár kucíc goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Montor ítara hoozzon or dil doró óigilgoi, aar ítara iman nu aní maincór muúntu Malik or Torikar baabute gifot ókkol gorát doijje. Hétolla Pául ítara ttu síra óigilgoi aar ummot ókkol ore fúañti loizai Turanus nam or ezzon manúc or morkos ot fottí din toskara goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Héndilla dui bosór fán ówat accíl, hétolla Ecíyat tákito de Yohúdi edde Girík beggúne Malik or kalam fúni faijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Alla ye Pául or duara endilla taajuippa keramot ókkol goittó, ");
INSERT INTO rhgc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","zeén níki íbar nummal edde gaar uoror hoor ókkol íbar gaat bazái biyaraimmar hañse loizailé, ítarar biyaram ókkol gom óizaytoi aar hóraf jin ókkol neelizaytói. ");
INSERT INTO rhgc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Hoozzon Yohúdi zetará zaga-zaga zai manúc ókkol ottu hóraf jin ókkol dáfaito, ítara Malik Isár nam estemal gorí yó héndilla goríbar kucíc goijjíl. Ítara hoiyé de, “Añára toré Isár name neeliai bolla hókum dír, Zibár baabute Páule tobolik goré.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sekiva nam or ézzon Yohúdir ḍoóñr imam or háñt twa fua ye yó héndilla goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ekbar hóraf jine ítara re hoór de, “Isá re toh añí siní, aar Pául ore yó siní, montor tuáñra hon?” ");
INSERT INTO rhgc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Hétunot ze manúc cwa re hóraf jine faiyé íte ítara háñt óu zon or uore záp maijje, aar ítara beggún ore ziti eén hámla goijjé, zeén níki ítara zohóm fai gór gán ottu biyossor dáigiyegoi. ");
INSERT INTO rhgc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Tói Ífisas ot tákoya Yohúdi edde Girík beggúne zettót e hóbor yián faiyé, ítara beggún ḍooraigiyói, aar Malik Isár nam or mohíma óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iman ainné de ítara boóut zone aái nizor-nizor hórafi ókkol cíkar gorí zahér goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Aar ítarar bútottu boóut zon zetará age jadugor accíl, ítara nizor-nizor kitab ókkol aní yore ekkán ot zoma gorí beggún or muúntu furat difélaiye. Ítara hé kitab pún or dam hísaf goijjé rár dekér de, muṭmaṭ fonzaic ázar dinár óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Héndilla góri Malik or kalam bicígori fólat accíl, aar manúc ókkol or dil zitat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Híin beggún ói baade, Páule Makedóniya edde Akaya elaka báy Jerúsalem ot zaito niyot goijjé. Íba ye hoiyé de, “Héṛe zai baade añr ttu Rom cóor ot óu zaa foribó.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tói íba ye nizor dui zon modotgár ore, yáni Timóti re edde Erastus ore íbar age Makedóniyat difeṛáiye, montor íba Ecíya elakat hooddin táigilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Hé októt Malik or Torikar baabute ḍoóñr hánggama uiṭṭé. ");
INSERT INTO rhgc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kiyólla-hoilé héṛe Dimiteriyus nam or ezzon rufar bainna accíl, zee niki devi Artemis or gura-gura mondir ókkol banaitó, aar hé hame mistíri ókkol olla bicí fáidai aintó. ");
INSERT INTO rhgc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yóggwa ye ítara re edde héndilla ham or oinno mistíri ókkol ore fúañti matai hoór de, “Báiyain, tuáñra toh zano, añára e ham or zoriya bála amodoni fair. ");
INSERT INTO rhgc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tuáñra yián óu dekór edde fúnor, Páule siríf Ífisas ot no bólke fura Ecíyar bicí maincóre úddwa bíraifelaiye deh. Íba ye hoó de, át or banaiya debota ókkol kessú no. ");
INSERT INTO rhgc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Híyan or zoriya siríf añárar ham or uore bodnam aibó de no, bólke muhán devi Artemis or mondir or izzot or háni yó óibo aar híbar muhángiri yó nac óizayboi, zibá re Ecíyar edde fura duniyair maincé fuñza goré.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Híyan fúni ítara ttu bicí guccá uiṭṭé, aar guzori-guzori hoór de “Íficiól or devi Artemis muhán.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Éhon or bútore guñṛa cóor gán oulzóul ot forigiyói. Manúc ókkole Gayus edde Aristarkus nam or ze dui zon Makedóniol Pául or fúañti sofór ot zaar ítara re dórifelai fúañti ekku duñre, mujilíc goré de zaga gán ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Montor Pául manúc or ḍaái or muúntu zaito saiyé rár, íba re ummot ókkole zaito nó deh. ");
INSERT INTO rhgc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ecíyar hoozzon elakayi zimmadar ókkol zetará Pául or dustó, ítara yó íbar hañse ekkán hóbor foóñsai bicí aros goijjíl de, íba zen mujilíc goré de zaga gán ot no zaa. ");
INSERT INTO rhgc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Héṛe manúc ókkol guzorat accíl, hodúne yián hoói guzorer aar hodúne waán hoói guzorer. Boóut zone ítara héṛe kiyólla zoma óiye de úddwa hoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Hodún Yohúdi ye Alexzendar ore manúc or ḍaái war bútottu neelai ítarar muúntu díye; yóggwa ye manúc ókkol ore áte icára gorí nizám óito hoiyé, zeéne yóggwa ye mujilíc or muúntu sófai dí fare. ");
INSERT INTO rhgc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Montor ítara zettót yóggwa Yohúdi de híyan ót faiyé, ítara beggúne ek abase dui gónḍa foijjonto endilla guzorat accíl, “Íficiól or devi Artemis muhán.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Baade ahérit, cóor or kerani ye manúc ókkol ore nizám márai hoór de, “Ó Íficiól, e hotá yián toh beggúne zane, Ífisas óilde muhán devi Artemis or mondir or edde sóbi waán or sóoñloya, ziyán asman ottu foijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hétolla, iín zettót inkar gorí no fare de héndilla hákikot ókkol, tuáñra ttu nizám ón sáa, aar bánggori kessú no gorón sáa. ");
INSERT INTO rhgc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kiyólla-hoilé tuáñra e manúc ziín ore eṛé ainnó, ítara no mondir ottu ḍahañiti goijjé aar no añárar devir kuféri goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Hétolla, zodi Dimiteriyus ottu edde yóggwar sáañti mistíri ókkol ottu honókiyor ulḍa cékayot táke, adalot ókkol toh kúla asé, aar hákim ókkol óu asé. Héṛe zai ítara ezzon olla ezzone mooddima goróukgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Montor zodi tuáñra yaar túaro kessú goittó soó, tóoile híyan kaanuni mujilíc ot fáisela gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Aijja óiye de hánggamar zoriya añárar uore elzam foribár ḍoor asé. Zodi fore, añára e hánggamar honó wajá dahái no faijjum, kiyólla-hoilé yián or toh honó gom wajá nái.” ");
INSERT INTO rhgc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Híyan hoói baade yóggwa ye mujilíc hótom gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hánggama bon óizaygoi baade, Páule ummot ókkol ore mata baiyé, aar ítara re hímmot dí baade ítara ttu bidai loi Makedóniyat zai bolla bacá lóiye. ");
INSERT INTO rhgc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Héṛe foóñsi baade, héṛiyar elaka ókkol ot zai-zai imandár báiyain dore becábicí hímmot dí baade Giris ot aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Íba héṛe tin mac táikkil, aar zaáñs ot góri Siíriya mulluk ot zaibar age Yohúdi ókkole íbar hélaf sail gúraiye de hétolla, íba Makedóniya báy waafes zaitogói fáisela goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pául or fúañti hoozzon sáañti accíl, ítara óilde, Beriya ttu Purus or fua Sopétar, Tisólonika ttu Aristarkus edde Sékundus, Darbiya ttu Gayus, Timóti, Ecíya ttu Tukikus edde Torofímos. ");
INSERT INTO rhgc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ítara age neeli zai Toras ot añára lla entezar gorí táikkil. ");
INSERT INTO rhgc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Cúṭar-sára Ruṭir-id baade añára zaáñs ot góri Filíppi ttu bacá lóiyí, aar fañs din or bútore ítarar héṛe Toras ot foóñicci; héṛe añára háñt din táikkilam. ");
INSERT INTO rhgc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Háftar foóila din, zeñtté añára fúañti hána hái bolla zoma óiyi, Páule manúc ókkol ore waáz gorát doijje, aar tarfor din rowana óibar niyote adá rait foijjonto gorát accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Añára uoror ṭalar ze kamárat fúañti zoma óiyi, héṛe bicí serak ókkol zolat accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ezzon juwan manúc zanálar ḍáke góri boiṛá accíl. Yóggwar nam óilde Etukus. Pául or waáz zetó lamba ór, manúc cwa héto gúm ot forat accíl. Ahérit mur gúm ot fori yóggwa tin ṭalar uottú meṛit forigiyói, aar yóggwa re tuillé rár mora loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pául nise zai yóggwar uore fori añza mari dóri hoór de, “No ḍooraiyó, yoggwá ttu aijjó foran asé.” ");
INSERT INTO rhgc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Baade Pául abar uoror ṭalat zai ruṭi báñgi háiye, aar fózor fáṛe foijjonto hotábattara hoói baade héntu giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Manúc ókkole juwan fua wa re gór ot zinda loigiyé, aar ítara añiṭṭa nó kúci óiye deh. ");
INSERT INTO rhgc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Añára age neeli zai zaáñs ot uṛí Asos cóor ot zai bolla rowana óiyi, zentú Pául ore tulí loiyum hoói niyot goijjí. Íba ye héndilla entezam etollá goijjé, kiyólla-hoilé íba héṛe áñṛi-áñṛi zaibar niyot goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Zeñtté íba ye añára re Asos ot loot faiyé, añára íba re zaáñs ot tulí looi Mitulen cóor ot aiccí. ");
INSERT INTO rhgc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Aar héntu zaáñs ot góri zai tarfor din Kiyos ḍiyar muúntu foóñicci, yár tarfor din Sámos ḍiyat aiccí, baade yár tarfor din Miletus cóor ot foóñicci. ");
INSERT INTO rhgc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kiyólla-hoilé Páule age lóti fáisela goijjíl de, zaáñs ot góri zaibarcót Ífisas ot no gólibo, zeéne íba ttu Ecíyat ṭaim haṛa no fore, kiyólla-hoilé íba ye Jerúsalem ot foóñsi bolla duadi goijjíl, farilé, Penṭikos or din. ");
INSERT INTO rhgc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus ottu Páule Ífisas ot hóbor difeṛái zomát or murubbi-neta ókkol ore mataiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ítara zeñtté íbar héṛe aiccé, íba ye ítara re hoór de, “Tuáñra nize toh zano, añí Ecíyat aiccí de foóila din lóti tuáñrar fúañti hárr októ keéngori haṛaáilam. ");
INSERT INTO rhgc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yohúdi ókkol or sail or zoriya añr uore ze mosibot ókkol aiccíl, híin añí furafuri norom or sáañte edde suk or faní bácai-bácai bordac gorí Malik or hédmot goijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tuáñra toh zano, añí tuáñra lla fáida ó de héndilla honó hotá tuáñra ttu lukai nó rakí, bólke tuáñra re kúlamela góri edde góre-góre taalim diyí. ");
INSERT INTO rhgc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Añí Yohúdi ókkol ore edde Girík ókkol ore horagori zanaidiyí de, ítara ttu touwá gorí Allar uzu fíra foribó, aar añárar Malik Isár uore iman aná foribó. ");
INSERT INTO rhgc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Aar ehón, Pak-Ruhr hotá mozin añí Jerúsalem ot zair, héṛe añr uore kii guzoribó añí hoi no fari. ");
INSERT INTO rhgc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Añí siríf yián zani, Pak-Ruh ye añré fottí cóor ot zanaider de ki, ziyól edde mosibot añár lla entezar gorí asé. ");
INSERT INTO rhgc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Háir! Añí añr zan ore nizor lla honó muillo bouli no ṭáari; añr siríf niyot óilde, tobolik or ham edde ze zimmadari Malik Isá ttu añí faiyí híyan adai gorón, yáni Allar rahámot or kúchóbor or gobá dón. ");
INSERT INTO rhgc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Yala añí zani, tuáñra zetarár hañse añí Allar raijjor tobolik goijjí, tuáñra añr muk ar no dekíba. ");
INSERT INTO rhgc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hétolla aijja añí tuáñra re hoóir, tuáñra honókiyor lou wór zimma añí no. ");
INSERT INTO rhgc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kiyólla-hoilé añí toh Allar furafuri moncá re tuáñrar hañse boiyan goitté fissá nó mari. ");
INSERT INTO rhgc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Hétolla nizoré nize úñciyar aar Pak-Ruh ye tuáñra re bérasóol or zák zibár saásita-goróya banaiyé yíba guñṛa re lói yó úñciyar. Allar zomát or soroya bono, ziyán Íba ye Nizor Fuar lou loi kinné. ");
INSERT INTO rhgc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Añí zani, añí zaigói baade tuáñrar bútore hótarnak rangkuñir ókkol aibó, aar bérasóol or zák ore hóti goríbo. ");
INSERT INTO rhgc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ebbe tuáñrar bútottu úddwa kessú manúc uṛí báañra-báañra hotá ókkol hoibó, zeéne ummot ókkol ore ítarar híkka gorífelai fare. ");
INSERT INTO rhgc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hétolla úñciyar táikko! Monot rakíyo de, tin bosór foijjonto añí raite dine suk or faní bácai-bácai tuáñra re nicót gorá bon nó gorí. ");
INSERT INTO rhgc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Yala añí tuáñra re Allar át ot edde Íbar rahámoti kalam ot gosáidir. Hé kalame tuáñrar ruúhani torki gorí faribó, aar pak gorá gíyeh de ítarar bútore cámil gorí miras dii faribó. ");
INSERT INTO rhgc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Añí toh honókiyor cúna-cañdir, yáh hoorsuor or lalós nó gorí. ");
INSERT INTO rhgc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Tuáñra nize de zano, añr e át iíne ham gorí añr edde añr sáañti ókkol or zorurot ókkol fura goijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Añí goijjí de hárr kessú loi tuáñra re daháiyi de ki, héndilla dorómoro meénnot gorí-gorí añára ttu komzur ókkol ore modot gorár zorur, aar Malik Isár e hotá monot raká foribó, ziyán Íba Nize hoiyé, ki hoilé, ‘Lowar túaro diiya bicí mubarek.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Híin hoiyá ói baade, Páule añṛú félai ítara beggún or fúañti dua goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Baade ítara beggúne Pául ore sibi dóri bicí haindé, aar íba re appá díye. ");
INSERT INTO rhgc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Háasgori íba ye ítara re íbar muk ar no dekíbo hoiyé de híyane ítara bicí ferecan óiye. Tarfore ítara íba re zaáñs or héddur foijjonto baráidiye. ");
INSERT INTO rhgc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Añára ítarar héntu zaigói baade, zaáñs ot góri ruúru Kos ḍiyat giiyí. Tarfor din Rodes ḍiyat, aar héntu Patara cóor ot. ");
INSERT INTO rhgc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Fonikcíyat zaar de ekkán zaáñs loot fai, añára híyan ot uṛí rowana óiyi. ");
INSERT INTO rhgc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Aar Sáifrus ḍiya wa deikkí rár, yíbar doóin míkka báy zai Siíriya mulluk or Ṭayár ot laimmí, zeṛé zaáñs or malsámana ókkol lamaibár hotá accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Héṛe ummot ókkol tuwai fai yore añára ítarar fúañti ek háfta táikki. Pak-Ruhr hédaiyote ítara Pául ore maná goijjíl de, Jerúsalem ot no zaito. ");
INSERT INTO rhgc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Zeñtté añára rowana óibar októ óiye, añára héntu bacá lói añárar sofór ot zaa cúru goijjí. Ítara bou fuain cóo beggúne añára re cóor or baáre foijjonto baráidiye. Héṛe añára doijjar hañsat añṛú félai dua goijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Baade ezzon ottu ezzone bidai loi añára zaáñs ot uiṭṭígoi, aar ítara nizor gór ot waafes giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ṭayár ottu zaáñs lói sofór gorí Patolomis cóor ot foóñicci, aar héṛiyar imandár báiboináin dore sólam zanai ítarar fúañti ek din táikki. ");
INSERT INTO rhgc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tarfor din añára rowana ói Kaisáriyat foóñicci, aar kúchóbor tobolik-goróya Filíp or gór ot táikki. Hé Filíp accíl Jerúsalem ot háñt zon modotgár basíloil de ítarar bútottu ekzon. ");
INSERT INTO rhgc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yóggwa ttu sair gwá abiyáta zérfua accíl, zetará nobi ísafe Allar kalam hoitó. ");
INSERT INTO rhgc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Añára héṛe boóut din tákar baade, Yohúdiya ttu Agabos nam or ezzon nobi aiccíl. ");
INSERT INTO rhgc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yóggwa añárar hañse aái Pául or duali looi nizor át ṭéng bañdífelai hoór de, “Pak-Ruh ye fórmar de, ‘Jerúsalem ot Yohúdi ókkole e dualir girós ore endilla gori bañdíbo, aar íba re Beyohúdi ókkol or át ot gosáidibo.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Híyan fúni añára edde héṛiyar manúc ókkole Pául ore Jerúsalem ot no zaito fóriyat goijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Montor Páule zuwab diyé de, “Tuáñra hañdahaṛi gorí añr dil báñgifelor kiyá? Añí toh Jerúsalem ot Malik Isár nam or wasté siríf bañdá hái bolla toiyar así de no, bólke mori bolla úddwa toiyar así.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Íba re zettót añára manai no farir, añára yián hoói nizám mári táikki, “Malik or moncá fura óuk.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Hé din ókkol baade añára toiyar ói uore Jerúsalem ot zai bolla rowana loiyí. ");
INSERT INTO rhgc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Añárar fúañti Kaisáriya ttu hoozzon ummot óu giíl; ítara añára re Sáifrus ḍiyar Manason nam or ezzon manúc or gór ot loigiyé, zeṛé añára tákibar hotá accíl. Hé manúc cwa accíl agor ummot ókkol ottu ezzon. ");
INSERT INTO rhgc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Zeñtté añára Jerúsalem ot foóñicci, imandár báiboináin de añára re kúcir sáañte estekbal goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tarfor din Páule añára re fúañti looi Yakub ore saitó giiyé. Héṛe zomát or buzurgó beggún házir accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Páule ítara re sólam zanai baade, íbar tobolik or ham or duara Alla ye Beyohúdi ókkol or dormiyan ot ziín-ziín goijjé híin ekkán-ekkán boiyan gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Híin fúni ítara Allar taarif goijjé, aar Pául ore hoiyé de, “Bái, tuñí toh dekór, hotó ázar Yohúdi ókkole iman ainné, aar ítara beggún ottu Córiyot olla jus asé. ");
INSERT INTO rhgc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ítara re tuáñr baabute howá gíyeh de ki, tuñí Beyohúdi ókkol or bútore ze Yohúdi ókkol asé ítara beggún ore Muúsar Córiyot bad di soli bolla taalim doh. Tuñí bóle ítara re hoiyó de, ítarar fuain dore ázomi gorá no foribó, aar añárar rosóm ókkol mozin sola no foribó. ");
INSERT INTO rhgc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tóoile kii gorá zaybo? Manúc ókkole de tuñí eṛé aiccó de híyan hámaha fúnibo. ");
INSERT INTO rhgc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Hétolla añára hoóir de híyan goró. Añára ttu sair zon manúc asé, zetará manoc or tole. ");
INSERT INTO rhgc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ítara re tuáñr fúañti loizo, aar nizoré ítarar fúañti pak-sáf gorógoi. Ítara nizor matá eñraifélai fare fán ítara re hóssa diiyo. Tói manúc beggúne zanibó de, ítarar hañse tuáñr baabute ziín howá gíyeh híin or bútore honó sóiyi nái, bólke tuñí nize yó Córiyot mozin zindigi haṛo. ");
INSERT INTO rhgc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Montor ze Beyohúdi ókkole iman ainné, ítarar hañse añára fáisela gorí e hotá hoói ceñṛí leikkí, ki hoilé, tuáñra muttir hañse kurbani diya hána ókkol na háiyo, lou na háiyo, gola sibi marifélaiya januwar or gusso na háiyo, edde zená no goríyo.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tarfor din Páule manúc ítara re fúañti loigiyé, aar ítarar fúañti nizoré pak-sáf goijjé. Baade baitul-mukaddos ot zai zanaidiyé de, pak-sáf ówar din hoñtté céc óibo aar ítara fottí ekzon olla hoñtté kurbani diya zaybo. ");
INSERT INTO rhgc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Háñt din fura óibar kessú ṭaim age, Ecíyar Yohúdi ókkole Pául ore baitul-mukaddos or bútore deikké rár, manúc ókkol ore uskaidi íba re dórifelaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ítara guzoran mari hoór de, “Ó Boni Isráil ókkol, añára re modot gorógai! E manúc ibá óilde ubá zibá ye agagura fottíkiyo re añárar koum or, añárar Córiyot or, edde e zagar hélaf taalim deh. Aar híin baade yo, ibá ye Girík ókkol ore baitul-mukaddos ot aní e pak zaga re nafak gorífelaiye.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ítara héndilla kiyólla hoiyé hoilé, yár age ítara Ífici manúc Torofímos ore íbar fúañti cóor or bútore deikkíl, aar ṭáaijjil de, Páule yóggwa re baitul-mukaddos ot ainné. ");
INSERT INTO rhgc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tarfore guñṛa cóor ot hánggama foida óigiyoi, aar manúc ókkole fúañti ekkú duñre aái Pául ore dórifelaiye, baade íba re baitul-mukaddos ottu ṭani baáre aní, éhon geiṭ ṭún bon gorífelaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ítara íba re marifélaito kucíc gorér de októt, Romi ṭeérang or zonnal or hañse ekkán hóbor foóñicce de ki, “Fura Jerúsalem ot úrussul soler.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Híyan fúni mottor hé zonnale hoozzon fóous edde cáap fúañti looi duñri manúc or dol lwát giiyé. Manúc ókkole zonnal lwá re edde fóous ókkol ore deikké rár, Pául ore mara-dóra bon goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tói zonnal lwá ḍáke aái Pául ore gereftar gorífelaiye, aar íba re duiyán síyol lói bañdá zay bolla hókum díye. Tarfore yóggwa ye fusár gorér de, “Manúc ibá hon? Ibá ye kii goijjé dé?” ");
INSERT INTO rhgc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Montor manúc or ḍaái war bútottu hodúne yián hoói guzorer aar hodúne waán hoói guzorer. Zonnal lwá ye zettót úrussul or zoriya hákikot zani no farer, Pául ore gáñṭit loiza zay bolla hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pául círir tók foijjonto foóñicce rár, fóous ókkol ottu íba re boói loiza foijjé, kiyólla-hoilé manúc or dol lwá hótara accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Manúc ítara íbar fisé-fisé zaat accíl, aar guzori-guzori howát accíl de, “Ibá re marifélo.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pául ore gáñṭit gólaibar októt, íba ye zonnal lwá ttu fusár gorér de, “Añí tuáñre kessú hoói faijjum né?” Zonnal lwá ye zuwab der de, “Tui Girík zuban zanos nikí? ");
INSERT INTO rhgc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tóoile kí tui Ijípi uite no, zee niki yaar hooddin age bagiyai gorái sair ázar kúni re moidan zagat loigílgoi?” ");
INSERT INTO rhgc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Montor Páule zuwab der de, “Añí ézzon Yohúdi, Kilicíya elakar Tarsús or manúc, añí aamfám cóor or manúc no. Meérbani góri añré manúc cún ore hotá hoibár ezin doh.” ");
INSERT INTO rhgc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Zonnal lwár ezin fai yore, Pául círir tók ot tíyai manúc ókkol ore áte icára goijjé. Ítara beggún nizám óiye rár, íba ye Hibrú zubane hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ó báiyain aar bafáin, ehón añí añr sófai díyum, fúno.” ");
INSERT INTO rhgc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Manúc ókkole íba ye Hibrú zubane hotá hoór de fúni aró nizám ói táikkil. Tói Páule hoór de, ");
INSERT INTO rhgc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Añí ézzon Yohúdi, añí Kilicíyar Tarsús ot zormo óiyi, montor ḍoóñr óiyi de e cóor ot; añí Gamaliel ottu cíkka faiyí, zibá ye añré añárar bafdada ókkol or Córiyot or baabute furafuri cíkaiye. Aijkal zendilla tuáñra beggún ottu Alla lla jus asé héndilla añr ttu yó héñtte jus accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Hétolla añí e Torikat soilto de ítarar uore more fán zulúm goittám, aar beṛaáin beṛiyáin duní gún ore gereftar gorí ziyól ot dítam. ");
INSERT INTO rhgc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Boro imam edde fótuayi-mujilíc or murubbi beggún híyan or gobá asé. Añí tará ttu Damáskas ot asé de Yohúdi báiyain dor hañse loizai bolla ceñṛí fai yore héṛe giílam, zeéne añí héṛe zai yore yó manúc ítara re Jerúsalem ot sáñza dí bolla bañdí aní fari. ");
INSERT INTO rhgc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Montor eén óiye, añí zaite-zaite duúñijja góri Damáskas ot foóñsir de októt, atíkka asman ottu eggwá ḍoóñr foór añr sairó ḍák ottu soimké. ");
INSERT INTO rhgc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Añí meṛit forigiyígoi, aar añré endilla hoór de eggwá abas fúinni, ‘Sául, Sául, tui añré kiyólla zulúm gorór?’ ");
INSERT INTO rhgc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Tói añí fusár goijjí de, ‘Malik, Tuñí hon?’ “Íba ye añré zuwab diyé de, ‘Añí óilam de Isá Nasári, zibá re tui zulúm gorór.’ ");
INSERT INTO rhgc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Zetará añr fúañti accíl ítara yó hé foór gwá deikkíl, montor añr llói hotá hoór de Íbar abas ítara nó fúne. ");
INSERT INTO rhgc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Añí fusár goijjí de, ‘Malik, añr ttu kii gorá foribó?’ “Malike zuwab diyé de, ‘Uṭ, Damáskas ot zaa, tor lla ziín ṭík gorí raká gíyeh híin beggún héṛe toré howá zaybo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Añí zettót hé foór or tozolliye kessú no dekír, añr fúañti accíl de manúc cúne añré át ot dóri Damáskas ot loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Héṛe Ananiyas nam or ezzon dindár manúc accíl, zibá ye Córiyot díyan or sáañte amól goittó, aar héṛiyar Yohúdi beggúne yóggwa re bicí izzot goittó. ");
INSERT INTO rhgc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yóggwa añr héṛe aiccé, aar añr ḍák ottu tíyai añré hoór de, ‘Bái Sául, tuáñr dekíbar toóufik fíri aiyóuk.’ Hétunot añí yóggwa re dekí faijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Baade Yóggwa ye hoór de, ‘Añárar bafdada ókkol or Alla ye tuáñre basíloiye, Íbar moncá zani bolla, aar Insáfwala wa re dekí bolla, edde Íbar muk or hotá fúni bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kiyólla-hoilé tuñí ziín deikkó edde fúinno híin or baabute tamám manúc ókkol or hañse tuñí Íbar gobá óiba. ");
INSERT INTO rhgc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ehón aar deri kiyá gorór? Uṛó, bápṭisma loh aar Íbar nam ḍaki tuáñr guná ókkol dúifelo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Baade eén óiye, zeñtté añí Jerúsalem ot waafes aái baitul-mukaddos or bútore dua gorír, añí ekkán dorcón deikkí, ");
INSERT INTO rhgc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ziyán ot Malike añré hoór de, ‘Toratori gor! Ehón-ehón Jerúsalem sári zaagói, kiyólla-hoilé eṛíyar maincé Añr baabute tor gobá no gosíbo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Hétunot añí hoóir de, ‘Malik, manúc ítara toh zane, añí fottí mujilíc-hánat zai-zai, Tuáñr uore iman ané de ítara re ziyól ot dítam edde mara-dóra goittám deh. ");
INSERT INTO rhgc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tuáñr gobá Esṭífen ore mariféla zar de októt óu añí ḍáke tíyai accílam. Añí ham híyan ot furafuri razi accílam, aar zetará yóggwa re marifélar ítarar hoorsuor ókkol sooñi accílam.’ ");
INSERT INTO rhgc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Hétunot Malike añré hoór de, ‘Zaa, Añí toré duré Beyohúdi ókkol or héṛe difeṛáiyum.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Manúc ókkole Pául or hotá hétukkun foijjonto fúnat accíl. Baade ítara guzoran mari hoór de, “Itaré duniyai ttu fúraifelo! Ite zinda tákibar laayek no.” ");
INSERT INTO rhgc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ítara zettót guzori-guzori nizor hoorsuor melá márer, aar boiyar ot dúil urar, ");
INSERT INTO rhgc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","zonnal lwá ye hókum díye de, Pául ore gáñṭit aná zay bolla, aar hoiyé de, manúc ókkole íbar hélaf endilla gori kiyólla guzorer de híyan zani fare fán Pául ore soóñk mari zerá gorí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ítara íba re soóñk mari bolla baindé de októt, Páule ḍáke tíyai accíl de cáap pwá re hoór de, “Honó hosúri faa nó zah de héndilla ézzon Romi manúc ore soóñk maron kí tuáñra lla kaanuni ham?” ");
INSERT INTO rhgc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Cáap pwá ye híyan fúinne rár, zonnal lwár hañse zai hoór de, “Tuñí iín kii goittó soór? Ibá toh Romi manúc.” ");
INSERT INTO rhgc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Hétunot zonnal lwá aái Pául ottu fusár gorér de, “Añré hoósai, tui Romi manúc níki?” Íba ye zuwab der de, “Jii, ói.” ");
INSERT INTO rhgc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Zonnale íba re hoór de, “Añr ttu Rom or nagorita óite boóut ṭiañ-foicá diiya foijjé.” Páule hoór de, “Montor añí de zormo ttu lóti Romi.” ");
INSERT INTO rhgc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Zetará íba re zerá goittó aiccíl ítara híyan fúinne mottor íba ttu fisságiyoi, aar íba Romi manúc de híyan zani fari zonnal lwá yó ḍooraigiyói, kiyólla-hoilé yóggwa ye Pául ore bañdí raikkíl. ");
INSERT INTO rhgc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yohúdi ókkole Pául ore kiyólla elzam der de híyan zonnal lwá ttu fakkagori zainto monehoór de hétolla, tarfor din yóggwa ye Pául ore kúlidiye, aar hókum díye de, ḍoóñr imam edde fótuayi-mujilíc or membór beggún dola óito. Baade yóggwa ye Pául ore nise aní ítarar muúntu tíyagaraiye. ");
INSERT INTO rhgc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Páule fótuayi-mujilíc or membór ókkol or uzu díyan dóri saái hoór de, “Báiyain, añí aij foijjonto furafuri sáf hélome Allar cáikkat zindigi haṛaiyí.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hétunot boro imam Ananiyase manúc zetará Pául or ḍáke tíyai accíl ítara re hókum díye de, íba re gal sái maitto. ");
INSERT INTO rhgc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Montor Páule íba re hoór de, “Héy munafék! Alla ye toré maribó. Tui eṛé Córiyot mozin éna añr bisar goittó boiccós, montor añré mari bolla hókum dí tui nize toh Córiyot báñgor.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Zetará Pául or ḍáke tíyai accíl ítara hoór de, “Allar boro imam ore beizzoti gorí bolla tor kii hímmot!” ");
INSERT INTO rhgc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Páule zuwab der de, “Báiyain, ibá boro imam de añí no zani, arnóile endilla lofzó estemal no goittám. Kiyólla-hoilé pak-kalam ot toh endilla asé, ‘Nizor koum or sóddar or baabute bura no hoiyó.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Montor Páule zettót ek ḍaái Sadukái de aar arek ḍaái Féroci de ót faiyé, íba ye fótuayi-mujilíc ot guzori hoór de, “Ó báiyain, añí ézzon Féroci aar Férocir fua; añré bisar gorá zar de kiyólla-hoilé, añí acá gorí de, mora ókkol zinda ói uṛíbo.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Íba ye héndilla hoiyé mottor, Féroci edde Sadukái ókkol or bútore hoijja cúru óigiyoi, aar mujilíc bák óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kiyólla-hoilé Sadukái ókkole hoó de, mora ókkol zinda ói no uṛíbo, ítara aró hoó de, fírista yó nái, ruh yó nái; montor Féroci ókkole híin beggún asé de biccác goré. ");
INSERT INTO rhgc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Hétunot héṛe eggwá ḍoóñr hánggama óiye. Féroci fírkar hoozzon aleme tíyai guccár sáañte eén hoói barábari díyat doijje, “Añára e manúc cwa ttu honó hosúri nó fai. Honó ruh ye yáh fírista ye ibá llói hotá hoilé yo kí no fare né?” ");
INSERT INTO rhgc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hoijja zettót bicí ḍoóñr óigiyoi, ítara Pául ore ṭukuṛa-ṭukuṛa gorífelaibo bouli zonnal lwá ye ḍooraiyé, hétolla yóggwa ye fóous ókkol ore hókum díye de, nise zai Pául ore manúc ókkol ottu bolazuri gáñṭit loianí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Tarfor din raitta Malike Pául or ḍáke tíyai hoór de, “Hímmot gór; tui zendilla Jerúsalem ot Añr baabute gobá díyos, héndilla tor ttu Rom cóor ot óu gobá díya foribó.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Tarfor din biínna hodún Yohúdi ye ekkán sail gúrai hosóm háiye de, ítara zetódin Pául ore marifélai nó fare hétodin hána-fina na háibo. ");
INSERT INTO rhgc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Sail híyan ot salic zon or túaro bicí beṛaáin cámil accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ítara ḍoóñr imam ókkol or edde murubbi ókkol or hañse zai hoór de, “Añára Pául ore marifélai nó fari foijjonto hána-fina na háiyum hoói dorómoro hosóm háiyi. ");
INSERT INTO rhgc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hétolla yala, tuáñra edde fótuayi-mujilíce íbar mooddima aró bálagori tahákit gorá forer hoói íba re nise tuáñrar muúntu aní bolla zonnal ore hóbor dóh. Añára íba eṛé foóñsibar age marifélai bolla toiyar así.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Montor Pául or báaina ye ítarar sail or baabute fúinne rár, gáñṭir bútore góli Pául ore híin zanaiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Hétunot Páule Romi cáap ókkol ottu ezzon ore matai hoór de, “E juwan fua wa re zonnal lwár hañse loizo, itar ttu yóggwa re kessú hoibár asé.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tói hé cáap pwá ye ítare zonnal or héṛe aní hoór de, “Hodi Páule añré matai e juwan fua wa re tuáñr héṛe aní bolla hoiyé, kiyólla-hoilé itar ttu bóle tuáñre kessú hoibár asé.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Hétunot zonnale ítare át ot dóri ekkinare loizai fusár gorér de, “Tor ttu añré kii hoibár asé dé?” ");
INSERT INTO rhgc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Íte hoór de, “Hodún Yohúdi ye Pául or baabute aró bálagori tahákit gorá forer hoói hailla íba re nise fótuayi-mujilíc ot aní bolla tuáñre aros goittó ek óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Montor tuñí ítarar hotá no fúinno, kiyólla-hoilé ítara salic zon or túaro bicí manúc luki táki Pául or entezar gorér; ítara íba re zetódin marifélai nó fare hétodin hána-fina na háibo hoói hosóm háiye. Yala ítara toiyar óiye, siríf tuáñr razirobbot olla entezar gorér deh.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Zonnale juwan fua wa re endilla hókum dí duñraidiyé, “Tui añré iín zanaidiyós bóuli honókiyo re no hoóic.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Baade hé zonnal lwá ye cáap ókkol ottu dui zon ore matai hoór de, “Rait or now wa báze Kaisáriyat zai bolla dui cót fóous, hóittor zon gúra-soloinna fóous edde dui cót folóuwan toiyar gorí raikkó. ");
INSERT INTO rhgc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pául olla yó gúra ókkol toiyar raikkó, zeéne íba sóiyi sólamote hákim Fílix or héṛe foóñsegoi.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tarfore yóggwa ye endilla ekkán ceñṛí leikké: ");
INSERT INTO rhgc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Añí Kalediya Laisíyas or torfóttu bicí izzotdár hákim Fílix ore sólam. ");
INSERT INTO rhgc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","E manúc cwa re Yohúdi ókkole dórifelail ar marifélaito saáil, montor añí zeñtté ibá ézzon Romi manúc de zani faijjí, añí añr fóous ókkol lói zai ibá re basailoiyí. ");
INSERT INTO rhgc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aar ítara ibá re kiyólla elzam der de híyan añr ttu zainto monehoiyé rár, añí ibá re ítarar fótuayi-mujilíc ot loigiyí; ");
INSERT INTO rhgc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","baade añí zani faijjí de, ítara ibá re ítarar Córiyot or baabute elzam lagar deh; montor ibá ttu mora fore de yáto ziyól haṛa fore de héndilla honó hosúri nái. ");
INSERT INTO rhgc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Zeñtté añré hóbor díya gíyeh de ki, e manúc cwa re marifélaibar sail gúraiye; añí ibá re éhon or bútore tuáñr hañse difeṛáiyi deh. Zetará ibá re elzam lagar, añí ítara re hókum díyi de, ítara ttu ibár ulḍa ze elzam ókkol asé híin tuáñr muúntu peec gorí bolla.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tói hókum mozin fóous ókkole hé raitta Pául ore Entipateris cóor ot loigiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tarfor din, ítara gúra-soloinna fóous sun ore Pául or fúañti duñraidi gáñṭit waafes aáigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Gúra-soloinna fóous sun Kaisáriyat foóñicce rár, hákim ore ceñṛí gán diiyé, aar Pául ore yó íbar át ot gosáidiye. ");
INSERT INTO rhgc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Hákime ceñṛí gán forí, Pául ottu fusár gorér de, “Tui hon zagar?” Páule zuwab der de, “Kilicíyar.” ");
INSERT INTO rhgc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Hákime hoór de, “Tor elzam lagoya ókkol eṛé foóñsile añí tor mooddimar baabute fúniyum.” Baade yóggwa ye hókum díye de, Pául ore Hérud or razmohól ot faára dí raká zay bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Fañs din baade boro imam Ananiyase hoozzon murubbi looi edde Tartuliyas nam or ezzon ukil looi nise Kaisáriyat giiyé, baade ítara hákim or hañse Pául or ulḍa elzam ókkol peec goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pául ore bútore mata bay baade, Tartuliyase hákim or hañsé elzam ókkol peec gorát doijje, hoór de, “Tuáñr hókum or tole añára boóut deri lóti bicí cántit así, aar tuáñr bála nozoriyar zoriya e koum or uore boóut ḍóilla torki aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ó izzotdár Fílix, añára híyan hárr ḍóillat, hárr zagat furafuri cúkuriyar sáañte kobul gorí. ");
INSERT INTO rhgc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Montor añr ttu tuáñr ṭaim ar borbad dito mone no hoór, hétolla añí tuáñre fóriyat gorír, meérbani góri añárar hotá gún fúno. Añára hookkán hotát beggún fúrai díyum. ");
INSERT INTO rhgc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Añára loot faiyí de, e manúc cwa óilde ekkán bifot; ibá ye fura duniyair Yohúdi beggún or bútore hánggama foida goré. Ibá óilde Nasári nam or dol or eggwá sóddar. ");
INSERT INTO rhgc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ibá ye baitul-mukaddos úddwa nafak goittó kucíc goijjé, añára ibá re hétolla gereftar goijjí deh. ");
INSERT INTO rhgc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Montor zonnal Laisíyas aái yore ibá re ádoma gorí añárar át ottu loigiyégoi, ");
INSERT INTO rhgc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","aró ibár mooddima-goróya ókkol ore hókum díye de, tuáñr muúntu ai bolla. Tuñí nizebaze ibá re iín beggún or baabute zerá goillé zani faribá, añára ibá re kiyólla hosúr dír.” ");
INSERT INTO rhgc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yohúdi ókkol óu elzam lagat córik ói híin beggún sóiyi bóuli hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Baade hákime Pául ore hotá hoitó icára goijjé rár, Páule hoór de, “Añí zani, tuñí boóut bosór lóti e koum or joc. Hétolla añí kúcir sáañte añr sófai dír. ");
INSERT INTO rhgc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tuñí zasai goillé sóiyigori zani faribá, añí uore Jerúsalem ot ebaadot goittó giiyí de aijjó baró din or túaro bicí nó óiyo. ");
INSERT INTO rhgc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Añr uore zetará elzam lagar ítara añré no baitul-mukaddos ot honó manúc lói barábari dír de loot faiyé, aar no mujilíc-hánat yáh cóor or honó mikká hánggama foida gorír de loot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Itará añr uore ze elzam ókkol lagar, híin or tuáñre honó sábut dí no faribó. ");
INSERT INTO rhgc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Montor añí tuáñr hañse yián cíkar gorír, ki hoilé, ze Torika re itará gollot dol bouli hoór, hé Torika re mani añí añárar bafdada ókkol or Allar ebaadot gorí. Añí ze hotá ókkol Tourat ot edde nobi ókkol or kitab ot leikká asé híin beggún ekin gorí. ");
INSERT INTO rhgc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Añr ttu Allar uore acá asé, zendilla itará ttu yó asé, híyan óilde, forhésgar edde hóraf manúc beggún ore mora ttu zinda gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Hétolla añí furafuri kucíc gorí de, Allar edde insán or muúntu hámica sóiyi hélome táki bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Yala boóut bosór baade, añí Jerúsalem ot añr koum or hañse hórat foóñsai bolla edde januwar kurbani di bolla aiccí. ");
INSERT INTO rhgc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tói Ecíyar hoozzon Yohúdi ye añré baitul-mukaddos ot pak-sáf ói añí hé ham gorír de loot faiyé. Héṛe añr fúañti no manúc or dol accíl aar no añí honó hánggamat cámil accílam. ");
INSERT INTO rhgc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Montor zodi ítara ttu añr ulḍa honó kessú hoibár táke, tóoile ítara ttu tuáñr muúntu aiyón accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Arnóile eṛé asé de itará nize hoóuk, añí fótuayi-mujilíc or muúntu tíyai accílam de híyala añr ttu kii hosúri faiyé deh. ");
INSERT INTO rhgc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Itará añré siríf yián ekkán or hosúr dí faribó, ziyán añí ítarar muúntu tíyai accílam de híyala guzori hoóilam, ki hoilé, ‘Mora ókkol zinda ói uṛár mosóla loi beh aijja añré bisar gorá zar.’ ” ");
INSERT INTO rhgc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Montor Fílix ottu hé Torikar baabute sóiyi zana asé de hétolla, yóggwa ye bisar gorá bon gorí hoór de, “Zonnal Laisíyas nise ailé, añí tor mooddimar fáisela goijjúm.” ");
INSERT INTO rhgc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Baade íba ye cáap ore hókum díye de, Pául ore gañrat ot rakí bolla, kessú azadi di bolla, aar Pául or dustó ókkole íba re hédmot goittó ailé ítara re maná no gorí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hooddin baade, Fílixe nizor bou Durusila re fúañti looi aiccé, híba ézzon Yohúdi accíl. Yóggwa ye Pául ore mataitó difeṛáiye, baade Pául ottu Mosih Isár uore iman or baabute boiyan fúinne. ");
INSERT INTO rhgc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Páule zettót forhésgarir, nizoré sóoñli rakár, edde aibó de kiyamot or baabute boiyan gorér, Fílix ḍooraigiyói, aar hoór de, “Tui ettar zaagói, one mouka faile añí toré mataitó difeṛáiyum.” ");
INSERT INTO rhgc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Fúañti-fúañti yóggwa ye Pául ottu gúc faibar óu acá goijjíl, hétolla yóggwa ye Pául ore egazá-egazá matai íba llói hotá hoitó. ");
INSERT INTO rhgc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dui bosór guzori zaigói baade, Fílix or zagat Forkiyus Fistas aiccé. Montor Fílix ottu Yohúdi ókkol or nozor ot bála ṭóoitto monehoiyé de hétolla, yóggwa ye Pául ore ziyól ot rakígilgoi. ");
INSERT INTO rhgc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fistas hé mulluk ot aái tin din baade Kaisáriya ttu uore Jerúsalem ot giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Héṛe ḍoóñr imam ókkole edde Yohúdir neta ókkole Pául or ulḍa elzam ókkol ainné, aar aros gorí ");
INSERT INTO rhgc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Pául or ulḍa ekkán meérbani saiyé, zeéne íba ye Pául ore Jerúsalem ot difeṛáide. Kiyólla-hoilé, ítara Pául ore foñt ot máze luki táki marifélaito sólla goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Montor Fistase hoór de, “Pául ore Kaisáriyat máze gañrat ot raká gíyeh, aar añí nize héṛe hára zaiyum. ");
INSERT INTO rhgc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tuáñrar hoozzon sóddar añr fúañti aiyóuk. Zodi hé manúc cwar honó hosúri táke, tóoile ítara héṛe íbar hosúr ókkol daháidouk.” ");
INSERT INTO rhgc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fistas ítarar fúañti añcṭo-doc din táki baade nise Kaisáriyat giiyé. Tarfor din yóggwa ye bisar or toktót boiccé, aar Pául ore aná zay bolla hókum díye. ");
INSERT INTO rhgc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pául foóñicce rár, ze Yohúdi ókkol Jerúsalem ottu aiccíl, ítara íbar sairókul ttu tíyai íbar uore bicí hótara-hótara elzam ókkol lagat doijje, montor híin sábut gorí nó fare. ");
INSERT INTO rhgc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Hétunot Páule eén hoói nizor sófai díye, “Añí no Yohúdir Córiyot or ulḍa hosúri goijjí, no baitul-mukaddos or ulḍa goijjí, aar no Káisar or ulḍa goijjí.” ");
INSERT INTO rhgc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Montor Fistase Yohúdi ókkol or nozor ot bála ṭóori bolla Pául ore hoór de, “Tui Jerúsalem ot zai e mooddimar bisar olla añr muúntu tíyaito soós né?” ");
INSERT INTO rhgc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Páule zuwab der de, “Añí toh yala Káisar or adalot ot éna tíyai así; añr bisar or fáisela eṛé gorá foribó. Añí Yohúdi ókkol or ulḍa honó hosúri nó gorí, híyan de tuñí yó bála zano. ");
INSERT INTO rhgc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Zodi toóu añí mora fore de héndilla honó kessúr hosúrbon de óile, añí mori bolla razi así. Montor e Yohúdi itará añr uore ziín elzam lagar híin zodi ekkán óu sóiyi no, tóoile honókiyo ttu añré itarár át ot gosáidibar hók nái. Añí Káisar ore apíl gorír.” ");
INSERT INTO rhgc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Baade Fistase uzirnazir ókkol lói mocuwara gorí hoór de, “Tui zettót Káisar ore apíl goijjós, hétolla tui Káisar or héṛe zaibi.” ");
INSERT INTO rhgc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hooddin guzori zaigói baade, baáñcca Ageripa ye edde Barnise Fistas ore sólam zanaitó Kaisáriyat aiccé. ");
INSERT INTO rhgc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ítara héṛe boóut din haṛai baade, Fistase Pául or mooddimar baabute baáñcca re zanaiyé. Yóggwa ye hoór de “Fílixe manúc ézzon ore eṛé hodi ísafe rakígiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Zeñtté añí Jerúsalem ot giílam, Yohúdir ḍoóñr imam ókkole edde murubbi ókkole íbar hosúri ókkol añr hañse peec gorí hoiyé de, íba re sáñza dí bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Montor añí ítara re hoiyí de, ‘Yián Romi niyom no de ki, honó manúc ore sáñza lla gosáidon, zetún foijjonto íba ye nizor mooddima-goróya ókkol lói muámuikka dola nó óiyo edde nizor ulḍa ze elzam ókkol laga giyéh híin or sófai dí bolla íba re mouka diiya nó zah.’ ");
INSERT INTO rhgc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Hétolla hé Yohúdi gún eṛé zoma óiye rár, añí deri no gorí tarfor din bisar or toktót boiccí, aar manúc cwa re aná zay bolla hókum díyi. ");
INSERT INTO rhgc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mooddima-goróya ókkol zeñtté hotá hoi bolla tíyaiye, ítara añí ṭáaijjilam de héndilla honó gollot ham or hosúri nó deh. ");
INSERT INTO rhgc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Montor íba llói ítara ttu nizor dórmor edde mora manúc Isár baabute kessú obonaboni accíl, Zibá zinda asé hoi Páule dabi goré. ");
INSERT INTO rhgc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Añí hé maamela gún or baabute hondilla gori tahákit goríyum no zani ísafe, fusár goijjí de, íba ttu Jerúsalem ot zai híin or bisar olla tíyaito monehoór né. ");
INSERT INTO rhgc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Montor Páule zettót Káisar or fáisela lla íba re gañrat ot raká zay bolla apíl goijjé, añí hókum díyi de, íba re Káisar or héṛe nó difeṛái foijjonto gañrat ot raká zay bolla.” ");
INSERT INTO rhgc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ageripa ye Fistas ore hoór de, “Añí nizor ttu yó hé manúc cwar hotá fúinto monehoór.” Yóggwa ye hoór de, “Hailla fúni faribá.” ");
INSERT INTO rhgc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tói tarfor din baáñcca Ageripa edde Barnis, bicí ḍók or sáañte ḍoóñr zonnal ókkol edde cóor or ḍaiḍoóñr ókkol ore loi boiṛók-hánat góille. Fistas or hókum mozin Pául ore bútore aná gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fistase hoór de, “Ó baáñcca Ageripa edde eṛé añárar fúañti házir asó de tamám manúc ókkol, tuáñra e manúc cwa re soó, zibár baabute Yohúdi beggúne Jerúsalem ot edde eṛé añré apíl gorí guzori hoóil de, e manúc cwa ar basi tákibar laayek no. ");
INSERT INTO rhgc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Montor añí zani faijjí de, ibá ye moot or laayek honó hosúri nó goré. Aar ibá ye zettót Káisar ore apíl goijjé, añí ibá re héṛe difeṛáibar fáisela goijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Montor ibár baabute añr muhán baáñccar hañse lekí bolla añí honó sóiyi hosúri nó fai. Hétolla añí ibá re tuáñrar muúntu ainní, háasgori tuñí baáñcca Ageripar muúntu, zeéne zerá gorí baade añr ttu kessú lekíbar táke. ");
INSERT INTO rhgc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kiyólla-hoilé añr ttu lager de, hosúri ókkol dahái no dí honó hodi re héṛe difeṛái don sóiyi no.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ageripa ye Pául ore hoór de, “Toré nizor sófai díbar ezazot diya giyéh.” Hétunot Páule át barái nizor sófai díyat doijje de: ");
INSERT INTO rhgc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ó baáñcca Ageripa, aijja añí tuáñr muúntu Yohúdi ókkole añr uore ze elzam lagar híin beggún or ulḍa añr sófai dí farir de híyan añí bággitta bóuli ṭáarir. ");
INSERT INTO rhgc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Háasgori kiyólla-hoilé, añí zani, tuñí Yohúdi ókkol or rosóm or edde torkatorkir súwal ókkol or baabute bicígori zano. Hétolla añí tuáñre fóriyat gorír, sobór or sáañte añr hotá gún fúno.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Tamám Yohúdi ókkole toh zane, añr nizor koum or dormiyan ot edde Jerúsalem ot añr zindigir solasol cúru ttu lóti hondilla accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ítara añré bicí deri lóti siné, zodi ítara ttu gobá díto monehoó, di faribó, ki hoilé, añí añárar dórmor ebbe hora fírka Féroci mozin zindigi haṛaiyí. ");
INSERT INTO rhgc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Aar yala añré etollá bisar gorá zar, kiyólla-hoilé Alla ye añárar bafdada ókkol lói ze waada goijjíl hé waadar uore añí acá rakí. ");
INSERT INTO rhgc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Añárar baró háandan or manúce toh hé waada re faibar acáye dilmon di raite dine Allar ebaadot goittó. Ó baáñcca, añré Yohúdi ókkole hé acár zoriya elzam der deh. ");
INSERT INTO rhgc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Alla ye mora re zinda goré de híyan kiyá tuáñra ttu biccác no lager? ");
INSERT INTO rhgc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Age añí nize yó ṭáaittam de, zeéne fari héene añr ttu Isá Nasárir nam or ulḍa gorón fóros. ");
INSERT INTO rhgc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Héndilla añí Jerúsalem ot goijjí yó. Ḍoóñr imam ókkol ottu kémota fai yore Allar pak bonda boóut zon ore ziyól ot dílam, aar ítara re zeñtté marifélaito fáisela goré héñtte añí yó búṭ dítam. ");
INSERT INTO rhgc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Bicí ṭaim ot añí ítara re sáñza dí bolla fottí mujilíc-hánat zaitam, aar ítara re bolazuri kuféri gorá baitó kucíc goittám. Añí ítara llói bicí rak accílam de hétolla oinno mulluk or cóor ókkol ot úddwa zai-zai ítarar uore zulúm goittám. ");
INSERT INTO rhgc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Héñtte ek din añí ḍoóñr imam ókkol ottu adíkar edde hókum fai yore Damáskas ot zair de októt, ");
INSERT INTO rhgc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","óu baáñcca, duúñijja góri añí foñt ot máze asman ottu eggwá foór deikkí, zibá beil or túaro foór, yíba añr edde añr sáañti ókkol or sairómikka ttu somkat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Zeñtté añára beggún meṛit forigiyígoi, añré Hibrú zubane endilla hoór de eggwá abas fúinni, ‘Sául, Sául, tui Añré kiyólla zulúm gorór? Áilla súañr ulḍa latí mara tor lla aásan no.’ ");
INSERT INTO rhgc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Hétunot añí fusár goijjí de, ‘Malik, Tuñí hon?’ Malike zuwab diyé de, ‘Añí óilam de Isá, zibá re tui zulúm gorór. ");
INSERT INTO rhgc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ehón uṭ, tor ṭénge tíya. Añí tor hañse zahér óiyi de, toré háadem edde gobá banai bolla; siríf ziín deikkós híin olla no bólke muúntu Añí toré ziín daháiyum híin olla yó. ");
INSERT INTO rhgc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Añí toré tor koum ottu basai rakíyum, aar ze Beyohúdi ókkol or hañse Añí toré difeṛáir, ítara ttu yó basai rakíyum. ");
INSERT INTO rhgc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tui ítarar suk kúlidibi, zeéne ítara andár ottu foór or uzu fíri aiyé, edde Cóitan or kobza ttu Allar hañse aiyé. Tói ítara gunár maf faibo, aar zará Añr uore iman aní pak-sáf óiye tarár bútore zaga faibo.’ ");
INSERT INTO rhgc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Hétolla, ó baáñcca Ageripa, asman ottu dorcón or duara añré ziín howá gíyeh, añí híin or nafórmani nó gorí. ");
INSERT INTO rhgc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Sáat ot zetará Damáskas ot asé ítara re, baade Jerúsalem ot edde Yohúdiyar agagurat, aar Beyohúdi ókkol or hañse yó endilla hoói añí tobolik goijjí de ki, ítara ttu touwá gorí Allar uzu fíra foribó, aar touwár laayek ham ókkol gorá foribó. ");
INSERT INTO rhgc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Híyan olla bóuli hodún Yohúdi ye añré baitul-mukaddos ottu dórifelail aar marifélaito kucíc goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Montor aij foijjonto Alla ye añré modot goijjé, hétolla añí tíyai ḍoóñr-cóñṛo beggún or hañse gobá ókkol dir. Nobi ókkole edde Muúsa ye ziín fura óibo bóuli hoiyé híin or baáre añí honó kessú hoiyí de nái; ");
INSERT INTO rhgc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ki hoilé, Mosih ttu duk faa foribó, aar mora ttu zinda óiye de foóila zon ói yore Yohúdi edde Beyohúdi ókkol or hañse nur or hóbor díya foribó.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Páule zettót héndilla góri nizor sófai dér, Fistase gozgosai hoór de, “Héy Pául, tui fool óigiyosgoi! Bicí elóm hásil goróne toré fool banaifélar.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Montor Páule hoór de, “Ó izzotdár Fistas, añí fool nó ói, añí ziín hoóir híin sóiyi aar buzón or hotá. ");
INSERT INTO rhgc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Baáñcca ye toh iín or baabute zane, hétolla añí íbar muúntu hímmot góri hotá hoói farir deh. Añí biccác gorí de, e hotá iín ekkán óu íba ye no zane de nái, kiyólla-hoilé iín toh honó ek kunat óiye de no. ");
INSERT INTO rhgc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ó baáñcca Ageripa, tuñí nobi ókkol ore biccác goró né? Añí zani tuñí goró.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Hétunot Ageripa ye Pául ore hoór de, “Tui añré ebbe hom ṭaim or bútore Isáyi banai faribí bóuli ṭáaijjos níki?” ");
INSERT INTO rhgc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Páule hoór de, “Hom ṭaim ot óuk yáh lamba ṭaim ot, añí Allar hañse dua gorí de, siríf tuñí no bólke zetará aijja añr hotá fúner ítara beggún óu zen añr ḍóilla ó, montor e síyol sára.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hétunot baáñcca uṛígiyoi aar íbar fúañti hákim, Barnis, edde zetará ítarar fúañti boiṛók ot accíl ítara yó uṛígiyoi. ");
INSERT INTO rhgc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ítara héntu neeli zaigói baade ezzon ore ezzone hoór de, “E manúc cwa ye mora fore de sáñzar laayek yáh ziyól haṛa fore de héndilla honó kessú nó goré.” ");
INSERT INTO rhgc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ageripa ye Fistas ore hoór de, “E manúc cwa ye Káisar ore apíl no goittó bóuli, ibá re eridiya zayto.” ");
INSERT INTO rhgc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Zeñtté añára re zaáñs ot góri Iṭalit loiza foribó bóuli fáisela óigiyoi, Pául ore edde ar hoozzon hodi re Baáñccar Ṭeérang hoó de yíbar ek cáap or át ot diiya giyéh, zibár nam Julius. ");
INSERT INTO rhgc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Añára Aderamitiya cóor or ekkán zaáñs ot uṛí zaat doijji, ziyán Ecíya elakar alok-alok gáñṭ ókkol ot zai bolla toiyar accíl. Aar Makedóniya elakar Tisólonika cóor or Aristarkus añárar fúañti accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tarfor din añára Sídon ot foóñicci, aar Juliuse Pául ore meérbani gorí nizor dustó ókkol or héṛe zaibar ezazot diyé, zeéne íbar dustó ókkole íbar zorurot ókkol fura gorí fare. ");
INSERT INTO rhgc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Añára héntu bacá lóiyí, aar boiyar añárar ulḍa baár de hétolla Sáifrus or ze boli boiyar no baár hé boli giiyí. ");
INSERT INTO rhgc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Baade Kilicíyar edde Pampúliyar doijja báy zaite-zaite añára Lusíya elakar Mira cóor ot laimmí. ");
INSERT INTO rhgc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Héṛe hé cáap pwá ye Alexzendariya cóor or ekkán zaáñs faáil ziyán Iṭali dec ot zaar. Íba ye añára re híyan ot tuillé. ");
INSERT INTO rhgc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Añárar zaáñs boóut din fán asté-asté soli baade bicí dukkór sáañte Kanidas cóor ot foóñicci. Boiyare zettót añára re aar muúmmikka zaito no der, añára Sálmon cóor or muúntu Keret ḍiyar ze boli boiyar no baár hé boli giiyí. ");
INSERT INTO rhgc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Aar doijjar hañsa dóri dukkór sáañte soli-soli ekkán zagat foóñicci ziyán or nam óilde Héfazoti Gáñṭ Ókkol. Híyan Lasíya ṭoón or ḍáke accíl. ");
INSERT INTO rhgc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Héndilla góri boóut din guzori zaigói baade, zaáñs ot góri zaibar sofór hótara óiaicce, aar Koffarar Din óu zettót faráigiyoi, Páule ítara re eén hoói úñciyari díye, ");
INSERT INTO rhgc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Manúc ókkol, añí dekír de age zai añárar e sofór hótara óibo, aar bicí hóti ókkol óibo, siríf malsámana edde zaáñs no, bólke añárar zan úddwa.” ");
INSERT INTO rhgc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Montor cáape Pául or hotár túaro zaáñs-soloyar edde híyan or girós or hotá fúinnil. ");
INSERT INTO rhgc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Hé zaáñs gáñṭ ṭan cítkhal haṛaité cúuida no de hétolla, ítara bicí zone fáisela goijjé de, héntu zai honó bote Fonis gáñṛot foóñsi cítkhal haṛai bolla. Hé gáñṭ ṭan óilde Keret ḍiyar zaáñs gáñṭ, ziyán or muu gán doóinali fosím edde uttorali fosím míkka. ");
INSERT INTO rhgc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Zeñtté doóinali boiyar asté-asté baát doijje, ítara báfer de ítarar niyot fura gorí faribó; hétolla ítara zaáñs or nogol tulífelai Keret ḍiyar sor báy giiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Montor hotún ánik baade, hé zaga ttu eggwá ḍoóñr tuwáni boiyar cúru óiye, zibá re Yorakilo ḍake. ");
INSERT INTO rhgc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Zaáñs sán ore zettót hé boiyare faiyé aar híyan boiyar or zoriya muúmmikka zai no farer, añára kucíc gorá bon gorí boiyar zikká baár híkka zaáñs sán zaito diyí. ");
INSERT INTO rhgc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Aar zaite-zaite eggwá Kawuda nam or gura ḍiyar ze boli boiyar no baár hé bouli giiyí, aar bicí mockil or sáañte añára zaáñs or noow gán basai faijjí. ");
INSERT INTO rhgc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Manúc ókkole noow gán zaáñs or uore tulí yore rosí lói zaáñs or sairókul ttu berái bañdí eijjé, aar ítara zaáñs sán Sartis or meṛir sor ot bazíbo bóuli ḍoore zaáñs or cór gán lamaifélai boiyar zikká baár híkka zaáñs sán zaito diyé. ");
INSERT INTO rhgc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Baade tuwán or zoriya zettót añára bicí éñska háir, ítara tarfor din zaáñs or malsámana ókkol félaidiyat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Tisára din ítara zaáñs sola de sáisamana ókkol nizor áte félaidiye. ");
INSERT INTO rhgc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Boóut din lóti zettót beil óu dahá no zar, tara ókkol óu dahá no zar, aar lagatar zuresúre tuwán óu baát accíl, tói añára basibár acá félaidiyi. ");
INSERT INTO rhgc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Zaáñs or manúc ókkol boóut din foijjonto waácca de hétolla, Páule ítarar mazé tíyai hoór de, “Manúc ókkol, tuáñra ttu añr buddí gán dóri Keret ḍiya ttu zaáñs lói nu aiyón accíl, tói e mosibot edde hóti ttu basitá. ");
INSERT INTO rhgc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Montor yala añí tuáñra re fóriyat gorír, tuáñra hímmot goró, kiyólla-hoilé tuáñra honókiyor zan no zaybo; siríf zaáñs san hóti óibo deh. ");
INSERT INTO rhgc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Añí Zibár manúc edde Zibár ebaadot gorí, hé Allar ek fírista ye gel de raitta añr ḍák ottu tíyai yore ");
INSERT INTO rhgc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","hoiyé de, ‘Pául, no ḍooraiyó, tuáñr ttu Káisar or muúntu hámaha tíya foribó. Aar zetará tuáñr fúañti zaáñs ot góri zaar, Alla ye tuáñr wasté meérbani gorí ítara beggún or zan basai raikké.’ ");
INSERT INTO rhgc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hétolla, manúc ókkol, hímmot goró, kiyólla-hoilé añr ttu Allar uore iman asé de, añré zeén hoiyé héen óibo. ");
INSERT INTO rhgc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lekin añára ttu honó ḍiyat oozagói foribó.” ");
INSERT INTO rhgc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tuwán or soiddó din ot din adá raitta, añára zaáñs lói báai Aderiya Doijjar héṛe aiccí rár, zaáñs or manúc cúne ṭáaijje de, ítara kul or ḍáke foóñser bóuli. ");
INSERT INTO rhgc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ítara fanír tola maippé rár ací át mur loot faáil, yár hotún baade abar maippé rár háiṭ át mur loot faáil. ");
INSERT INTO rhgc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ítara zaáñs sán cíl ot dúc háibo bóuli ḍoore zaáñs or fasíl ottu sair gwá nogol maijjé aar din or foór fáṛi bolla dua gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Tarfore séraingga gúne zaáñs ottu dáizai bolla kucíce, agil ottu nogol mare fán gorí zaáñs or uottú noow gán doijjat lamaifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Hétunot Páule cáap ore edde fóous ókkol ore hoór de, “Zodi manúc itará zaáñs or uore no táke, tuáñra basi no faribá.” ");
INSERT INTO rhgc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tói fóous ókkole noowr rosí gún haṛidiyé, zeéne híyan fanít forizagói. ");
INSERT INTO rhgc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Biínna foór fáṛibar ekkágori age, Páule ítara beggún ore hána hái bolla eén hoói aros goijjé, “Tuáñra kessú na hái lagatar entezar ot asó de aijja soiddó din óiye. ");
INSERT INTO rhgc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Hétolla añí tuáñra re fóriyat gorír, zane basi táki bolla tuáñra kessú hána hóo, kiyólla-hoilé tuáñra honókiyor matár ekkán sul úddwa no foribó.” ");
INSERT INTO rhgc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Hotá híyan hoói baade, Páule ruṭi looi ítara beggún or muúntu Alla re cúkuriya goijjé, aar baade báñgi háat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hétunot ítara beggúne hímmot faiyé, aar ítara nize yó hána háiye. ");
INSERT INTO rhgc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Zaáñs or uore añára kulehale dui cóo hóittor-sów zon accílam. ");
INSERT INTO rhgc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Beggúne feṭ bóri hái baade, ítara giyuñ ókkol doijjat félaidi zaáñs or uzón hom gorát doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Biínna foór fáiṭṭe rár, ítara zaga gán siní nó fare, montor ítara doijjar eén ekkán atari deikkíl, ziyán or sor balu ola. Baade ítara fáisela goijjé de, zodi faille zaáñs sán héṛe uore tulídi bolla. ");
INSERT INTO rhgc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Hétolla ítara nogol lun haṛi doijjat félaidiye, fúañti-fúañti súwan or rosí gún óu kúlifelaiye. Ítara zaáñs or cór gán boiyar ot tulídiye, baade zaáñs sán hé sor or híkka zaat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Montor zaáñs sán zaite-zaite dui doriyar mudar meṛir sor or uore uiṭṭégoi, aar zaáñs or agil eén bazígiyoi, ebbe no lorer, aar goir or zoriya fasíl ottu báñgi gurigara óizat doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Fóous súne hodi ókkol ore marifélaibar niyot goijjé, zeéne ítara honókiye háñsuri dáizaigoi no fare. ");
INSERT INTO rhgc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Montor cáap ottu Pául or zan basaitó monehoóil, hétolla íba ye fóous sun ore ítarar moncá mozin goittó nó déh. Íba ye hókum díye de, zetará háñsuri fare age ítara fanít záp mari kul or uore zai bolla, ");
INSERT INTO rhgc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aar baki gúne tottá yáh zaáñs or báñgasúra ókkol dóri yore héṛe zaiboi lla. Tói héndilla gorí héfazot or sáañte beggún kul ot foóñicci. ");
INSERT INTO rhgc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Zeñtté añára héfazot or sáañte kul or uore foóñicci, añára zani faijjí de, hé ḍiya war nam óilde Meliti. ");
INSERT INTO rhgc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Hé ḍiyar bácinda ókkole añára re ódorbaára meérbani goijjíl. Híyala zór dér de edde ṭánḍa accíl ísafe, ítara ooin zolai añára beggún ore estekbal goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Páule zettót ek tara fúana dargwá dola gorí ooin ot diyé, tói gorome eggwá bic ola háf neeli aái íbar át sái hooñri doijje. ");
INSERT INTO rhgc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Héṛiyar bácinda ókkole zettót Pául or át ot háf fwa loṭki táikke de deikké, ítara ezzon ore ezzone hoór de, “Becók, e manúc cwa kúni; ibá doriya ttu basilé yo Insáfi nam or debota ye ibá re basitó no dér.” ");
INSERT INTO rhgc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lekin Páule háf fwa zári ooin ot félaidiye, aar íbar honó hóti nó. ");
INSERT INTO rhgc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Manúc cúne ṭáaijje de, íbar gaa fúlizayboi, arnóile atíkka fori morizaybói, montor ítara boóut hotún entezar gorí baade dekér de, íba ttu kessú no ór, hétunot ítara nizor mon bodoli hoór de, “Íba eggwá debota!” ");
INSERT INTO rhgc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Hé zagar ḍáke hé ḍiyar ebbe ḍoóñr manúc or zobin ókkol accíl. Manúc íbar nam óilde Fubili. Íba ye añára re estekbal goijjé, aar tin din fán añára re becábicí meémandari goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aar eén óiye, hé októt Fubilir baf gaatzore edde gaalamaniye bisánat fori accíl. Páule íba re saitó bútore giiyé, aar dua gorí baade íbar uore át dí íba re gom goijjé. ");
INSERT INTO rhgc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yárbaade, hé ḍiyat accíl de baki biyaraimma beggún Pául or hañse aiccé, aar ítara re yó gom gorá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ítara añára re boóut ḍóilla torikaye izzot goijjé; aar añára héntu bacá lói bolla toiyar óiyi de októt, añára ttu sofór olla lage de híin beggún ítara zaáñs ot bóridiye. ");
INSERT INTO rhgc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tin mac baade añára Alexzendariya cóor or zaáñs ot góri bacá lóiyí, ziyán fura cítkhal foijjonto hé ḍiyat accíl. Hé zaáñs sán ore “Zooñikka Debota,” bouli hoitó. ");
INSERT INTO rhgc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Aar Sirakusa cóor ot zaáñs sán bañdí yore héṛe tin din táikki. ");
INSERT INTO rhgc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Añára héntu zaáñs ot góri bacá lói Regiyon cóor ot foóñicci. Ek din baade doóinali boiyar baát doijje, aar tarfor din Puteli ṭoón ot foóñicci. ");
INSERT INTO rhgc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Héṛe añára hoozzon imandár báiboináin loot faiyí, zetará añára re ítarar fúañti ek háfta tákito dawot dyíl. Héengori añára Rom ot foóñiccigoi. ");
INSERT INTO rhgc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Héṛiyar imandár báiboináin ókkole zettót añára aiyír de fúinne, ítara añára llói milto hodún Appiyus or Bazar hoó de híyan or héddur aiccé, ar hodún Tinboóṛing hoó de híyan or héddur aiccé. Páule ítara re dekí Alla re cúkuriya goijjé, aar hímmot faiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Añára Rom ot foóñsi baade Pául ore nizor ttu monehoó de héṛe táki bolla ezazot diya giyéh. Íba re ezzon fóouse faára díto. ");
INSERT INTO rhgc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tin din baade, Páule Yohúdir neta ókkol ore ekkán ot mataiyé, aar ítara zeñtté zoma óiye, Páule ítara re hoór de, “Ó báiyain, zodi añí añárar koum or edde añárar bafdada ókkol or rosóm ókkol or ulḍa kessú no goillé yo, toóu añré hodir ḍóilla góri Jerúsalem ottu Romi ókkol or át ot gosáidiya gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romi ókkol ottu añré zerá gorí baade eridito monehoóil, kiyólla-hoilé ítara añr ttu mora fore de héndilla honó hosúri nó faa. ");
INSERT INTO rhgc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Montor Yohúdi ókkole zettót híyan ot bazá díye, añí mojbur ói Káisar ore apíl goijjí, háleke híyan or maáni añr ttu nizor koum or ulḍa elzam lagaibár niyot accíl de no. ");
INSERT INTO rhgc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Hétolla bóuli añí tuáñra re sai bolla edde tuáñra llói hotá hoi bolla tuáñra re mataiyí deh, kiyólla-hoilé Boni Isráil ókkole ze acá raké hé acár zoriya añré e síyol lói bañdá gíyeh.” ");
INSERT INTO rhgc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Hétunot ítara íba re hoór de, “Añára tuáñr baabute Yohúdiya ttu honó ceñṛí nó fai, aar héntu ze báiyain eṛé aiccíl ítara ttu yó honókiye tuáñr baabute no honó hóbor díye, aar no honó hóraf hoiyé. ");
INSERT INTO rhgc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Montor añára ttu tuáñr rai ókkol fúinto monehoór, kiyólla-hoilé añára zani de, fottí zagar maincé e fírkar ulḍa hotá ókkol hoó.” ");
INSERT INTO rhgc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tói ítara Pául lói mili bolla eggwá din ṭík goijjé, aar ítara edde aró bicí manúc íba táke de zaga híyan ot aiccé. Tarfore Páule ítara re biínna ttu lóti háñzinna foijjonto Allar raijjor baabute buzáil edde gobá díyl, aar Muúsar Córiyot edde nobi ókkol or kitab ottu dahái dídi ítara re Isár baabute iman aná baitó kucíc goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Íbar boiyan fúni kiyé-kiyé iman ainné, montor argúne ekin nó goré. ");
INSERT INTO rhgc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ítarar bútore zettót obonaboni foida óiye, Pául or e hotá fúni ítara zaat doijje, ki hoilé, “Pak-Ruh ye nobi Yesáyahr áta tuáñrar bafdada ókkol ore sóiyi hotá hoiyé, ki hoilé, ");
INSERT INTO rhgc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","E manúc cún or hañse zai hoógoi de, ‘Tuáñra hane fúnat tákiba montor no buzíba, tuáñra suké saát tákiba montor no siníba. ");
INSERT INTO rhgc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kiyólla-hoilé manúc ítarar dil toh doró óigiyoi, ítarar han bór óigiyoi, aar ítara nizor suk bon gorífelaiye. Arnóile ítara nizor suké dekíto, hane fúnito, nizor dile buzí Añr hañse fíri aitó, aar Añí ítara re gom goittám.’ ");
INSERT INTO rhgc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Hétolla añr ttu tuáñra re yián zanaidito monehoór de ki, Allar e nejat or hóbor Beyohúdi ókkol or hañse foóñsa gíyeh, aar ítara fúnibo.” ");
INSERT INTO rhgc_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Páule hotá híin hoiyé rár, Yohúdi ókkole afós ot bicí barábari dí giiyégoi. ");
INSERT INTO rhgc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pául fura dui bosór foijjonto nizor bára gór ot táikkil, aar zetó zon íbar hañse aitó ítara beggún ore íba ye estekbal gorí, ");
INSERT INTO rhgc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","furafuri hímmot or sáañte honó bazá sára Allar raijjor baabute tobolik goittó edde Malik Isá Mosihr baabute taalim dito.");
INSERT INTO rhgc_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Añí Pául, Mosih Isár éggwa gulam, zibá re sáhabi ói bolla ḍaka giyéh edde Allar kúchóbor or tobolik olla basílowa gíyeh, ");
INSERT INTO rhgc_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ze kúchóbor or waada Alla ye age lóti Nizor nobi ókkol or duara pak-kalam ot mazé goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Hé kúchóbor óilde Íbar Fuar baabute, zibá insán or hé rúwate Dawud or nosól ottu zormo óoil, ");
INSERT INTO rhgc_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","aar pakir Ruhr hé rúwate mora ttu zinda gorá gíyeh de hétolla kudurut or sáañte Allar Fua de dahá gíyeh. Íba óilde Isá Mosih añárar Malik, ");
INSERT INTO rhgc_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","zibár duara añára rahámot edde sáhabigiri faiyí, zeéne Íbar nam ói bolla tamám koum ókkol ore iman ottu foida ó de fórmadarir héṛe aní; ");
INSERT INTO rhgc_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","zetará re Isá Mosihr ói bolla ḍaka giyéh, ítarar bútore tuáñra yó asó. ");
INSERT INTO rhgc_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Tuáñra zetará Rom cóor ot Allar adorbon asó, zetará re níki Alla ye Nizor pak bonda ói bolla ḍaikké, tuáñra beggún or hañse lekír: Tuáñrar uore añárar Baf Allar edde Malik Isá Mosihr torfóttu rahámot edde cánti nazil óuk. ");
INSERT INTO rhgc_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ebbe age, añí tuáñra beggún olla Isá Mosihr duara añr Alla re cúkuriya gorír, kiyólla-hoilé tuáñrar iman or baabute toh duniyair agagura howá zar. ");
INSERT INTO rhgc_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ze Allar Fuar baabute kúchóbor tobolik gorí-gorí añí fura dile Allar hédmot gorí, Íba añr gobá asé de ki, añí honó bad sára tuáñra re yaad gorí yore ");
INSERT INTO rhgc_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","duat hámica magi de, Alla ye sailé añí zen ebarot óile honó bote tuáñrar hañse aibár rasta fai. ");
INSERT INTO rhgc_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kiyólla-hoilé añr ttu tuáñra llói milto kúb monehoór, zeéne añí aái tuáñra re ruúhanir kessú niyamot dii fari, ziíne tuáñra re mozbut goríbo; ");
INSERT INTO rhgc_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","yáni, tuáñrar héṛe táki, tuáñra ttu edde añr ttu asé de imane ezzon ore ezzone josba di faijjum. ");
INSERT INTO rhgc_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Báiboináin ókkol, añr ttu tuáñra re zanaidito monehoór de ki, añí tuáñrar hañse ai bolla boóut bar niyot goijjílam de asé, montor etókkal foijjonto aái no faillam. Añí aitó saáilam de kiyólla-hoilé zeéne añí tuáñra ttu yó kessú fólfola fai, zendilla oinno koum ókkol ottu faiyí. ");
INSERT INTO rhgc_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Añr ttu manúc beggún or uore zimmadari asé, ítara Girík manúc óuk yáh gañiya óuk, elómdar óuk yáh be-elómdar óuk. ");
INSERT INTO rhgc_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Hétolla bóuli tuáñra zetará Rom ot asó, añr ttu tuáñrar hañse yó kúchóbor tobolik goittó bicí azzu asé. ");
INSERT INTO rhgc_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Añí toh kúchóbor loi no córmai, kiyólla-hoilé híyan toh iman anóya fottíkiyo re nejat di bolla Allar kudurut, age Yohúdi re yárbaade Beyohúdi re. ");
INSERT INTO rhgc_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kiyólla-hoilé hé kúchóbor ot toh Allar oh forhésgari zahér ó, ziyán manúce siríf imane hásil gorí faijjíl edde faribó, zendilla pak-kalam ot asé, “Forhésgar manúc imane beh basi tákibo.” ");
INSERT INTO rhgc_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Montor asman ottu Allar gozzob manúc uitarár hárr bedini edde kuham or ulḍa zahér ó, zetará sóiyi re kuham lói záfai raké, ");
INSERT INTO rhgc_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","kiyólla-hoilé Allar baabute ziín zani fara zah híin toh ítarar hañse sáf zahér, kiyólla-hoilé Alla ye híin ítarar hañse sáf zahér goijjé. ");
INSERT INTO rhgc_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Duniyair foidayecir héñtte lóti toh Íbar dekí fara no zah de sifót ókkol sáf-sáf góri dahá zar, yáni Íbar ofúrani kudurut edde Kúdayi re; híin Íbar banaiya mohóluk ókkol ottu ót faa zah, hétolla manúc ítara ttu honó bahána nái. ");
INSERT INTO rhgc_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ítara Alla re zani baade yo toh Íba re Alla ísafe izzot nó goré aar cúkuriya yó nó zana, bólke ítarar báfani behar óigiyoi aar ítarar obuz dil andáre bórigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ítara giyani bouli dabi goillé yo, ítara bekuf óigiyoi; ");
INSERT INTO rhgc_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","aar ítara fána no ó de hé Allar ebaadot bad di endilla mutti ókkol or fuñza goijjé ziín fána óizagoi de insán or, faik or, sair-ṭéingga januwar or edde buke áñṛe de zandár or súrote banaiya. ");
INSERT INTO rhgc_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Hétolla Alla ye ítara re ítarar dil or azzur nafak ham ókkol gorí bolla eridifélaiye, híyan olla bóuli ítara ezzon or jisím lói ezzone córmor ham goré. ");
INSERT INTO rhgc_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ítara misá ekkán olla Allar háñsa re bad difélaiye, aar Foida-goróya re no ói mohóluk or ebaadot edde hédmot goijjé. Montor Foida-goróyar taarif abadulabad ówat tákibo! Aamin. ");
INSERT INTO rhgc_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Alla ye hétolla toh ítara re córomi ham or azzut eridifélaiye; ítarar beṛiyáin de úddwa ziyán milmilab or niyom asé híyan ore ulḍat bodolifélaiye. ");
INSERT INTO rhgc_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Héndilla, beṛaáin de yó beṛiyáin lói ziyán milmilab or niyom asé híyan bad di, oinno zon loi córmor ham goittó fool óigiyoi, yáni beṛaáin de beṛaáin lói córmor ham gorí bolla; hétolla ítara nizor uore ítarar hóraf ham or laayek zoribana ané. ");
INSERT INTO rhgc_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Aró, ítara zettót Allar baabute zankari rakíto nó saá, Alla ye ítara re hóraf mon rakí bolla eridifélaiye, zeéne ítara ham uiín goré ziín gorón ṭík no; ");
INSERT INTO rhgc_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ítara hárr kuham, burai, lalós edde hórafe furaiya; ítara hásorot, kún, hoijja, férokbazi edde ducconir kíyale bóraiya; ítara gifot-goróya, ");
INSERT INTO rhgc_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","bodnam-goróya, Alla re nafórot goróya, biyadof, anaṛi, edde fohór ola; ítara hóraf ham or rasta kúle, aar bafmaar nafórman ókkol; ");
INSERT INTO rhgc_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ítara obuz, beiman, zaalem, edde berahám; ");
INSERT INTO rhgc_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ítara Allar e hókum zane, ki hoilé, zetará héndilla ham híin goré ítara moot or laayek, montor toóu ítara siríf híin gorát táke de no, bólke aar zetará híin goré ítarar sáañt óu deh. ");
INSERT INTO rhgc_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Hétolla, ó moniccó, tui zee niki oinno zon or hosúri dóros, tor ttu honó bahána nái; kiyólla-hoilé tui ziyán olla ar ezzon or hosúri dóros, híyan toh tui nize yó gorí nizorgá nize hosúrbon de sábut gorós. ");
INSERT INTO rhgc_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Añára toh zani, zetará héndilla ham goré ítara re Alla ye sóiyir uore bisar goré. ");
INSERT INTO rhgc_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lekin, ó moniccó, tui zee niki ekí ham uúin gorós ziín olla ar ezzon or hosúr dóros, tui Allar sáñza ttu hári zabigoi bóuli ṭáaros níki? ");
INSERT INTO rhgc_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Aar náki tui Íbar oti meérbani, bordac, edde sobór ore oggarájja gorór dé? Tui zanos de no né, Allar meérbanir moksót óilde toré touwá gorár uzu loizon dé? ");
INSERT INTO rhgc_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Montor tor dil toh doró, tor ttu touwá goríbar dil nái; héndilla gorí tui nizor lla gozzob zoma gorór, oh din olla ze din Allar gozzob nazil óibo edde Íbar hók bisar zahér óibo. ");
INSERT INTO rhgc_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Íba ye toh fottíkiyo re nizor-nizor ham mozin bodola dibo: ");
INSERT INTO rhgc_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","zetará sobór or sáañte gom ham gorí-gorí mohíma, izzot edde fána no ó de zindigi faibar talac goré, ítara re Íba ye ofúrani zindigi diibo; ");
INSERT INTO rhgc_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","montor zetará siríf nizor fáida tuwa aar sóiyi gán no mane bólke kuham fisá dore, ítarar uore Íba ye gozzob edde laánot nazil goríbo. ");
INSERT INTO rhgc_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kuham goré de fottí insán or uore mosibot edde ocánti aibó, age Yohúdir uore yárbaade Beyohúdir uore; ");
INSERT INTO rhgc_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","montor gom ham goré de ítara fottí ekzone mohíma, izzot, edde cánti faibo, age Yohúdi ye yárbaade Beyohúdi ye. ");
INSERT INTO rhgc_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kiyólla-hoilé Alla ye toh ektorfía no goré. ");
INSERT INTO rhgc_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Zedúne Córiyot no fai guná goijjé, ítara dónco óibo de yó Córiyot sára; aar zedúne Córiyot fai guná goijjé, ítara re Córiyot lói beh bisar gorá zaybo; ");
INSERT INTO rhgc_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","kiyólla-hoilé Allar nozor ot forhésgar toh Córiyot or boiyan fúne de ítara no, bólke Córiyot amól goré de ítara re beh forhésgar bóuli kobul gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Becók, Córiyot nái de Beyohúdi ókkole zeñtté nizor fítorote ham uúin goré ziín Córiyot ot asé, ítara ttu Córiyot no tákile yo héñtte ítara nizor lla nize córiyot. ");
INSERT INTO rhgc_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Híyane ítara sábut goré de, Córiyot or corót ókkol ítarar dil ot leikká asé. Héndilla bóuli ítarar hélome yó gobá déh, kiyólla-hoilé ítarar báfani ye táitai ítarar hosúr deh aar táitai ítarar sófai deh. ");
INSERT INTO rhgc_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Híin oh din óibo ze din Alla ye Isá Mosihr áta insán or gufoni ókkol or bisar goríbo. Hé baabute añí tobolik gorí de kúchóbor ot asé. ");
INSERT INTO rhgc_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Becók tui toh nizoré nize Yohúdi hoós, aar Córiyot or uore bóraca gorós edde Allar háas bonda bouli fohórai gorós; ");
INSERT INTO rhgc_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","tui Córiyot ottu taalim faiyós ísafe Íbar moncá zanos, aar sóiyi gán basí zanos; ");
INSERT INTO rhgc_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","tui furafuri ṭáaros de, tui óilide añdá ókkol or foñt dahóya, andár ot asé de ítara lla ekkán foór, ");
INSERT INTO rhgc_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","fool ókkol or ézzon torbiyotdoya, aar nabalok ókkol or ézzon ustat; kiyólla-hoilé tor báfa óilde, Córiyot ot hárr kessúr zankari edde sóiyi asé. ");
INSERT INTO rhgc_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Tóoile, tui zee niki ar ezzon ore cíkka dos, tui nizoré cíkka dos né? Tui zee niki suri no goijjó hoói waáz gorós, tui hóno suri gorós né? ");
INSERT INTO rhgc_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Tui zee niki zená no goittó hoós, tui hóno zená gorós né? Tui zee niki mutti ókkol ore nafórot gorós, tui hóno mondir ottu suri gorós né? ");
INSERT INTO rhgc_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tui zee niki Córiyot lói borái gorós, tui hóno Córiyot báñgi Alla re beizzoti gorós né? ");
INSERT INTO rhgc_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Pak-kalam ot toh endilla asé, “Tuáñrar solasol dekí Beyohúdi ókkole Allar nam or kuféri gorér.” ");
INSERT INTO rhgc_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kiyólla-hoilé, becók tor ázomir kimot asé zodi tui Córiyot amól gorós, montor zodi tui Córiyot báñgoya de óile, tóoile toh tor ázomi gorá ázomi nó gorós fán óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Hétolla, zodi ázomi goijjá honó manúce Córiyot or dabi-dawa ókkol amól goré, ítare kí Alla ye ázomi goijjá bóuli no gonibó né? ");
INSERT INTO rhgc_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Tuáñra Yohúdi ókkol ore Beyohúdi ókkole hosúr díbo, kiyólla-hoilé tuáñra ttu leikká Córiyot táki aar tuáñra ázomi goijjá manúc ói baade úddwa tuáñra Córiyot báñgo, montor ítara toh jisím ot ázomi no goré de óile yo Córiyot amól goré. ");
INSERT INTO rhgc_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kiyólla-hoilé asól Yohúdi toh uite no zee niki siríf Yohúdi kúwala, aar asól ázomi toh waán no ziyán jisím haṛi baár ttu gorá zah. ");
INSERT INTO rhgc_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Bólke asól Yohúdi óilde uite zee niki dil ottu Yohúdi; aar asól ázomi óilde waán ziyán Allar Ruhr duara dil ot gorá zah, leikká Córiyot or duara no. Héndilla manúce taarif faa de insán or torfóttu no, bólke Allar torfóttu. ");
INSERT INTO rhgc_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Héen óile, Yohúdi ókkol ottu kii fáida asé? Ázomi gorár kii kimot asé? ");
INSERT INTO rhgc_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Becók, hárr mikká ttu bicí fáida asé. Ebbe agor gán óilde, Alla ye ítarar hañse Íbar kalam nazil gorí bolla ítara re bóraca goijjíl. ");
INSERT INTO rhgc_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ítara kessú ye beimani goijjé de óile yo kii óiye? Ítara beimani goijjé bóuli kí Alla ye yó beimani goríbo né? ");
INSERT INTO rhgc_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bilkúl no! Bólke fottí manúc misá ṭóorile yo, Alla sóiyi ṭóorar zorur, zendilla pak-kalam ot asé, “Tuáñr hotá ye sábut goré de, Tuñí hámica sóiyi táko, aar Tuáñre elzam laga zah de októt Tuñí ziti aiyó.” ");
INSERT INTO rhgc_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Montor añárar kuhame zodi Allar hók bisar zahér ó, tóoile añára kii hoitám? Alla ye añára re sáñza dé de híyan nainsáfi no ór ne? Becók híyan óilde insán or ekkán nozoriya. ");
INSERT INTO rhgc_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Héndilla bilkúl no! Arnóile Alla ye duniyair bisar keéngori gorí faribó? ");
INSERT INTO rhgc_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Hodúne endilla hoibó, “Añr misá hotáye zodi Alla hámica sóiyi táke de híyan zahér ó aar híyane Íbar mohíma ó, tóoile Íba ye añré gunágar ísafe kiyá bisar goré?” ");
INSERT INTO rhgc_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Héndilla hoó de ítara endilla yó hoibó, ziyán añára hoói bóuli hoói hodúne añárar bodnam goré, ki hoilé, “Aiyó, añára burai gorígoi, kiyólla-hoilé zetó burai gorí fare héto gom.” Hé bodnam-goróya ókkole ítarar laayek sáñza hámaha fai zaybo. ");
INSERT INTO rhgc_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yala añára kii hoitám? Añára Yohúdi ókkol kí Beyohúdi ókkol or túaro beétor? Bilkúl no; añára toh age yó hoóilam, tamám Yohúdi ókkol edde Beyohúdi ókkol gunár kobzat asé. ");
INSERT INTO rhgc_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Zendilla pak-kalam ot asé, “Forhésgar honókiye nái, ekzon úddwa nái; ");
INSERT INTO rhgc_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","buz ola kiyé nái, honókiye Allar talac no goré. ");
INSERT INTO rhgc_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Beggún manúc sóiyi ttu lorigiyói, beggún ekku fúañti bigiṛigiyoi; gom ham goré de honókiye nái, ekzon úddwa nái.” ");
INSERT INTO rhgc_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Ítarar muk fooñsa lac or kúla hobor or ḍóilla; ítara nizor zire férokbazi goré,” “Ítarar uñṭ ot háf or bic asé.” ");
INSERT INTO rhgc_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Ítarar muk gozzobe furaiya; ítarar hotát honó miṛá nái.” ");
INSERT INTO rhgc_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Kún gorí bolla ítara duñri zaa; ");
INSERT INTO rhgc_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ítara zeṛé zaa héṛe dónco edde mosibot foida goré. ");
INSERT INTO rhgc_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Cánti góri tákar rasta ítara no siné.” ");
INSERT INTO rhgc_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Ítarar dil ot Allar honó ḍoor nái.” ");
INSERT INTO rhgc_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Yala añára zani de, Córiyote ziín hoó híin uitará re beh hoó zetará Córiyot or tole asé; zeéne honó insán ottu hoibár kessú no táke, aar fura duniyai ttu Allar hañse ísafkitab diya fore, ");
INSERT INTO rhgc_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","kiyólla-hoilé Córiyot amól gorí honó insán Íbar nozor ot forhésgar no ṭóoribo, kiyólla-hoilé Córiyot or duara toh gunár zankari éna aiyé. ");
INSERT INTO rhgc_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Montor yala toh Alla ye maincóre Córiyot sára keéngori forhésgar bóuli kobul goré de rasta híyan zahér óiye, ziyán or baabute Tourat Córif ot edde nobi ókkol or kitab ot óu zikír asé. ");
INSERT INTO rhgc_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Rasta híyan óilde, zetará Isá Mosihr uore iman ané ítara beggún ore nizor-nizor imane Alla ye forhésgar bóuli kobul goré; rasta híyan ot Yohúdi edde Beyohúdi honó forók nái, ");
INSERT INTO rhgc_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kiyólla-hoilé beggúne toh guná goijjé, aar Allar mohíma ttu maárum óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Montor Mosih Isár bútore asé de azadir usílaye Alla ye beggún ore Nizor rahámot or hádiya ísafe forhésgar bóuli kobul goré. ");
INSERT INTO rhgc_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Alla ye Íba re Nizor lou báca báy endilla koffara ísafe peec goijjé ziyán or uore iman aníle gunár maf faa zah. Híyan lói Alla ye daháiye de, Íba oñtté yó Insáfwala accíl zeñtté insáne goijjíl de gunár sáñza no di Íba ye cóoi-cóoi accíl. ");
INSERT INTO rhgc_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Héndilla gorí Íba ye e októt sábut goijjé de ki, Íba insáfwala, aar zee niki Isár uore iman ané ítare Íba ye forhésgar bóuli kobul goré. ");
INSERT INTO rhgc_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Tóoile borái goríbar kii asé? Kessú nái. Hon córiyot olla bóuli nái de? Amól or né? No, bólke iman or córiyot olla bóuli. ");
INSERT INTO rhgc_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Hétolla añára dóri de ki, manúc forhésgar ṭóore de nizor imane, Córiyot or amóle no. ");
INSERT INTO rhgc_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Tóoile Alla ki siríf Yohúdi ókkol or Alla? Íba kí Beyohúdi ókkol or óu Alla no? Becók, Íba Beyohúdi ókkol or óu Alla, ");
INSERT INTO rhgc_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","kiyólla-hoilé Alla toh ekgwá éna asé, zibá ye Yohúdi ókkol ore forhésgar bóuli kobul goríbo de yó imane, aar Beyohúdi ókkol ore goríbo de yó imane. ");
INSERT INTO rhgc_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Tóoile kí añára imane Córiyot ore baatel gorír? Bilkúl no! Bólke, añára Córiyot zari rakí deh. ");
INSERT INTO rhgc_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Héen óile, jisím or híkka ttu añárar ze baf asé hé Ibrahíme híyan or baabute kii loot faáil hoitám? ");
INSERT INTO rhgc_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kiyólla-hoilé Ibrahím ore zodi amóle forhésgar bóuli kobul gorá gíyeh de óile, tóoile toh yóggwa ttu borái goríbar kessú tákito, montor Allar muúntu no. ");
INSERT INTO rhgc_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Pak-kalam ot kii asé? Yián, “Ibrahíme Allar uore iman raikkíl, hétolla yóggwa re forhésgar bóuli gona gyíl.” ");
INSERT INTO rhgc_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ham goré de ítar tolof ore toh hádiya bóuli dóra no zah, bólke hók bóuli dóra zah. ");
INSERT INTO rhgc_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Montor zee niki nizor amól or uore bóraca no gorí Ubár uore bóraca goré zibá ye bedini ókkol ore forhésgar bóuli kobul goré, ítare ítar hé imane beh forhésgar bóuli gona zah, ");
INSERT INTO rhgc_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","zendilla Dawude yó manúc ubá mubarek bouli hoiyé zibá re Alla ye amól sára forhésgar bóuli gone. Íba ye hoiyé de, ");
INSERT INTO rhgc_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Mubarek uitará zetarár hosúr ókkol maf gorídiya gíyeh, zetarár guná dur gorífela gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mubarek manúc ubá, zibár guná Mabude hísaf no rakíbo.” ");
INSERT INTO rhgc_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Eṛé mubarek hoiyé de híyan kí siríf ázomi goijjá ókkol olla? Aar náki ázomi agoijjá ókkol olla yó? Kiyólla-hoilé pak-kalam ot toh añára endilla faiyí, “Ibrahím ore imane beh forhésgar bóuli gona gyíl.” ");
INSERT INTO rhgc_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Tóoile hoñtté gona gyíl dé? Yóggwa ye ázomi gorí baade né náki ázomi no goríbar age? Becók ázomi gorí baade no, bólke ázomi no goríbar age. ");
INSERT INTO rhgc_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Forezai yóggwa ye ázomi goijjíl; yóggwar hé ázomi óilde ekkán nicán ziyáne dahá de, yóggwa ázomi agoijjá tákite lóti yóggwa re imane beh forhésgar bóuli gona gyíl. Hétolla bóuli yóggwa óilde uitará beggún or baf, zetará re ázomi agoijjá óile yo iman anóne forhésgar bóuli gona zah. ");
INSERT INTO rhgc_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Héndilla, yóggwa ázomi goijjá uitarár óu baf zetará siríf ázomi goijjé de no, bólke endilla imane yó zindigi haṛa ziyán añárar baf Ibrahím ottu ázomi goríbar age accíl. ");
INSERT INTO rhgc_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kiyólla-hoilé Alla ye Ibrahím ore ze waada diíl, yóggwa edde yóggwar nosóle e duniyai miras faibo hoói, híyan toh yóggwa ye Córiyot amól gorí faiyé de no, bólke imane forhésgar ṭóori beh faiyé. ");
INSERT INTO rhgc_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kiyólla-hoilé Córiyot amól gorí zodi honókiye mirasdár ói fare, tóoile toh iman befózul óigiyoi, aar hé waadar honó kimot nái; ");
INSERT INTO rhgc_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","kiyólla-hoilé Córiyote toh gozzob éna ané, montor zeṛé córiyot nái, héṛe córiyot báñgar hotá yó nái. ");
INSERT INTO rhgc_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Hétolla, hé miras imane beh faa zah, zeéne híyan rahámote ó aar hé waada Ibrahím or tamám nosóle faibo de híyan fakka ó; híyan siríf Córiyot amól-goróya ókkol olla no, bólke uitará lla yó zetará ttu iman asé Ibrahím or ḍóilla, zibá añára beggún or baf, ");
INSERT INTO rhgc_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","zendilla pak-kalam ot asé, “Añí toré boóut koum or baf banaiyí.” Yóggwa óilde Ubár nozor ot añárar baf zibár uore yóggwa ye iman raikkíl, yáni Allar uore, Zibá ye mora re zinda goré edde nái de jiníc ókkol Nizor hókume foida goré. ");
INSERT INTO rhgc_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ibrahíme honó acá no tákile yo acár sáañte iman ṭikai raikkíl, hétolla yóggwa boóut koum or baf óiye, zendilla yóggwa re howá gíyl de ki, “Tor nosól ókkol bicí óibo.” ");
INSERT INTO rhgc_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Zeñtté yóggwa tokoriban ek cót bosór óiye, buijjíl de, nizor moot or októ ḍáke aáigiyoi aar Sárah ttu yó fua zormo di faribár októ ar nái, montor toóu yóggwar iman komzur nó óiyo. ");
INSERT INTO rhgc_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Allar waadar baabute yóggwar dil ot honó cók-cubá nú aiyé, bólke iman ot aró mozbut ói Allar taarif goittó, ");
INSERT INTO rhgc_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","aar yóggwa ttu furafuri ekin accíl de, Alla ttu Nizor waada fura goríbar óu kémota asé. ");
INSERT INTO rhgc_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Yóggwa re hétolla beh forhésgar bóuli gona gyíl. ");
INSERT INTO rhgc_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","“Forhésgar bóuli gona gyíl” hoó de hotá híyan siríf yóggwa lla leká gíyeh de no, ");
INSERT INTO rhgc_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","bólke añára lla yó. Añára re yó de forhésgar bóuli gona zaybo, kiyólla-hoilé añára toh Ubár uore iman ainní Zibá ye Isá añárar Malik ore mora ttu zinda goijjé, ");
INSERT INTO rhgc_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","zibá re añárar hosúre beh moot or át ot tulídiya gíyl, aar añára forhésgar ṭóori bolla beh mora ttu zinda gorá gíyeh. ");
INSERT INTO rhgc_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Hétolla, añára re zettót imane forhésgar bóuli kobul gorá gíyeh, Alla lloi añára llói añárar Malik Isá Mosihr duara cántit así. ");
INSERT INTO rhgc_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Añára yala ze rahámot or tole así héṛe añára re Íba ye beh foóñsaiye, kiyólla-hoilé añára toh iman ainní; hétolla Allar mohímar bági óibar acáye añára kúci gorír. ");
INSERT INTO rhgc_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Siríf híyan no, bólke añára mosibot ot mazé yó kúci gorí, kiyólla-hoilé añára zani de, mosibote bordac foida goré, ");
INSERT INTO rhgc_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","bordace sóiyi adot bana, aar sóiyi adote acá ané. ");
INSERT INTO rhgc_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Hé acáye toh añára re córminda no goré, kiyólla-hoilé añára re diiya giyéh de hé Pak-Ruhr duara Alla ye añárar dil ot Nizor muhábbot ḍálidiye. ");
INSERT INTO rhgc_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kiyólla-hoilé zeñtté añára nizoré nize basaibár kaabel nu accílam, héñtte sóiyi októ mozin añára bedini ókkol ore basai bolla Mosih ye zan diyé. ");
INSERT INTO rhgc_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Zee tee toh honó forhésgar manúc olla úddwa nizor zan dito no saá, toóu ezzon bálai-goróya lla honókiye nizor zan dito hímmot goillé goittó fare. ");
INSERT INTO rhgc_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lekin Alla ye añára re goré de Nizor muhábbot híyan eén gorí zahér goijjé, añára gunágar accílam de októt Mosih ye añára lla bóuli zan diyé. ");
INSERT INTO rhgc_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Añára re zettót Mosihr lou wór usílaye forhésgar bóuli kobul gorá gíyeh, añára toh hámaha Íbar duara Allar gozzob ottu basiyúm. ");
INSERT INTO rhgc_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kiyólla-hoilé añára toh age Allar duccon accílam, montor Íbar Fuar moot or usílaye Íba llói añárar bonot óigiyoi. Añárar bonot zettót óigiyoi, añára toh hámaha Íbar zibone nejat faiyum. ");
INSERT INTO rhgc_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Siríf híyan no, bólke añára Alla re lói añárar Malik Isá Mosihr duara kúci yó gorí, zibá ye añára re Alla lloi bonot gorídiye. ");
INSERT INTO rhgc_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Guná duniyait ekzon manúc or duara beh aiccíl, aar hé gunár zoriya moot aái fura insán-zatir uore fóligiyoi, kiyólla-hoilé beggúne guná goijjé. ");
INSERT INTO rhgc_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Becók, Córiyot diibar age duniyait guná accíl, montor zeṛé córiyot nái héṛe guná bóuli dóra yó nái. ");
INSERT INTO rhgc_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Toóu moote Adom ottu lóti Muúsa foijjonto hókumot goijjíl, uitarár uore úddwa zetarár guná Adom or nafórmanir ḍóilla no. Adom accíl aibár hotá accíl de Íbar icára. ");
INSERT INTO rhgc_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lekin rahámot or hádiya hé hosúrir ḍóilla no. Kiyólla-hoilé ekzon manúc or hosúre bicí manúc moijjé de óile yo, Allar rahámot toh yár túaro boóut bicí ḍoóñr, ziyán ar ekzon Manúc, yáni Isá Mosihr rahámot or duara hádiya ísafe hé bicí zon or uore bicígori diiya giyéh. ");
INSERT INTO rhgc_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Héndilla, Allar hádiyar notiza yó hé gunár notizar ḍóilla no. Kiyólla-hoilé ek ruwate hé ekkán hosúrir notiza óilde hosúrbon bouli fáisela zari óiye, montor arek ruwate boóut hosúrir zoriya ze hádiya aiccé híyan óilde forhésgar ṭóora. ");
INSERT INTO rhgc_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ekzon manúc or hosúrir zoriya zettót moote hé ekzon ottu lóti hókumot gorá cúru goijjé, tói añára zetará aṭalikka rahámot faiyí aar hádiya ísafe forhésgar ṭóoijji, añára toh zindigit maze Ubár zoriya, yáni Isá Mosihr zoriya hámaha hókumot goríyum. ");
INSERT INTO rhgc_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Hoóir de ki hoilé, zendilla ekkán hosúrir notiza ísafe fura insán-zati hosúrbon ṭóoijje, héndilla ekkán gom ham or notiza óilde fura insán-zati lla forhésgar ṭóora edde zindigi aiccé. ");
INSERT INTO rhgc_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kiyólla-hoilé zendilla ekzon manúc or nafórmanir zoriya boóut zon gunágar ṭóoijje, héndilla Ekzon or fórmadarir zoriya hé boóut zon ore forhésgar bóuli kobul gorá zaybo. ");
INSERT INTO rhgc_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Córiyot etollá beh diiya giyéh, zeéne hosúri bicí ó; montor zeṛé guná bicí óiye, héṛe rahámot toh yár túaro bicí óigiyoi, ");
INSERT INTO rhgc_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","zeéne guná ye zendilla moot or duara hókumot goijjé, héndilla rahámote yó forhésgarir ham loi hókumot goré, Isá Mosih añárar Malik or duara ofúrani zindigi faa bay bolla. ");
INSERT INTO rhgc_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tóoile añára kii hoitám? Añára guná gorát tákitam né zeéne rahámot bicí ó? ");
INSERT INTO rhgc_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bilkúl no! Kiyólla-hoilé añára toh guná ttu morigiyígoi, tói añára hé gunát ar keéngori zindigi haṛaiyúm? ");
INSERT INTO rhgc_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Tuáñra kí no zano, añára zedúne Mosih Isá llói ek óibar bápṭisma loiyí, añára hé bápṭismar duara Íbar fúañti morigiyígoi dé? ");
INSERT INTO rhgc_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Hétolla añára bápṭismar duara Íbar fúañti morigiyígoi de híyane dahá de, añára re Íbar fúañti dohón gorá gíyeh, zeéne Alla Bafe Nizor mohímaye Mosih re zendilla mora ttu zinda goijjé, héndilla añára yó noya zindigi haṛai. ");
INSERT INTO rhgc_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kiyólla-hoilé zodi añára Íbar ḍóilla mori yore Íba llói ek óigiyigoi de óile, añára toh Íbar ḍóilla zinda gorá zah lói yó Íba llói hámaha ek óiyum, ");
INSERT INTO rhgc_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","kiyólla-hoilé añára toh zani, añárar furana fítorot ore Íbar fúañti kúruc ot dí mariféla gíyeh, zeéne guná ye hókumot goittó de añárar jisím yián nac óizagoi, aar añára gunár gulam ar no táki. ");
INSERT INTO rhgc_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kiyólla-hoilé zee niki morigiyói, íte toh guná ttu azad óigiyoi. ");
INSERT INTO rhgc_vpl VALUES ("RM6_8",