﻿USE sofia;
DROP TABLE IF EXISTS sofia.rhg_vpl;
CREATE TABLE rhg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rhg_vpl WRITE;
INSERT INTO rhg_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Šurut maze Allaye asman edde zobin sirišṭi goijje. ");
INSERT INTO rhg_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Duniyai akarsara edde hali aššil, hiyanor uwore aššil andare guijja goin fani. Ar Allar Ruh fanir uwottu sola fira gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Toi Allaye hodde, \"Fohor ok,\" henot fohor oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allaye sadde fohor bala oiye, toi Allaye fohorottu andarore zuda goijje. ");
INSERT INTO rhg_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allaye fohorore nam diye \"din,\" ar andarore hibaye nam diye \"rait.\" Toi heṛe hazinna oiye edde binna oiye, ar hiyan aššilde foila din. ");
INSERT INTO rhg_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Allaye hodde, \"Fanit maze ekkan gũitor ḍoil fák zaga ok, ar fani dui bag oi aleda ok.\" ");
INSERT INTO rhg_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ei bafe Allaye fanit maze ekkan fák zaga goijje, nisor fani edde uworor fani aleda goijje. Ar henot hen oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bade Allaye he gũitor ḍoil fák zagaganor nam diye asman. Toi heṛe hazinna oiye edde binna oiye, ar hiyan aššilde dusora din. ");
INSERT INTO rhg_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Bade Allaye hodde, \"Asmanor nisor hár fani ek zagat zoma ok, ar deha zok fuwana zaga.\" Ar henot hen oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allaye he fuwana zagar nam diye zobin, ar he fani zoma oiyede hiyanor nam diye doriya. Ar Allaye sadde hin bala oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Allaye hodde, \"Zobine háil ker, biz fodai gorede lota-fata, edde šobzi zar zar zat mozin dana loi gula dorade gula gas okkol, zobinor uwore fuṛaok.\" Ar henot hen oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Toi zobine háil ker, biz fodai gorede lota-fata, edde šobzi zar zar zat mozin dana loi gula dorade gula gas okkol, fuṛaiye. Ar Allaye sadde hin bala oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Toi heṛe hazinna oiye edde binna oiye, ar hiyan aššilde tisera din. ");
INSERT INTO rhg_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Bade Allaye hodde, \"Raitottu dinore aleda goribolla asmanot gũitor ḍoil fák zagat fohor okkol ok, ar hin okkol sinno ok, boro din okkololla, din okkololla edde bosorolla, ");
INSERT INTO rhg_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ar hin okkole duniyait fohor dibolla asmanot gũitor ḍoil fák zagat takok.\" Ar henot hen oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Toi Allaye dinor uwore razagiri goribolla ekkan beši ḍõr fohor, ar raitor uwore razagiri goribolla hiyanottuwaro ekka šoṛo fohor, ei beši ḍõr fohor duniyan edde tara banaiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ar Allaye hinore asmanot gũitor ḍoil fák zagat buwaiye, ");
INSERT INTO rhg_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","din edde raitor uwore razagiri goribolla, edde andarottu fohorore aleda goribolla. Ar Allaye sadde hin bala oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ar heṛe hazinna oiye edde binna oiye, ar hiyan aššilde sair lomboror din. ");
INSERT INTO rhg_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Bade Allaye hodde, \"Fani nanan ḍoilla zandaror zãke bori uṛok, edde duniyair uwore asmanot maze faik okkol urok.\" ");
INSERT INTO rhg_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Toi Allaye doriyar he ḍõr ḍõr zanuwar okkol edde fanit zãk bandi solede nanan zator ze hár zandar okkol ase, hin okkolore, edde nanan zator faik okkol sirišti goijje. Ar Allaye sadde hin bala oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Allaye hin okkolore duwa goijje, edde hodde, \"Fólwala o edde beši o, ar doriyar fanire furon goro, duniyait faik okkol o beša beši ok.\" ");
INSERT INTO rhg_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ar heṛe hazinna oiye edde binna oiye, ar hiyan aššilde faš lomboror din. ");
INSERT INTO rhg_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Tarfore Allaye hodde, \"Zobinottu hár ḍoilla zandar zanuwar okkol niyoli aiyok: górot falede edde buke aṛede zandar, abanaiya fahari hár ḍoilla zandar okkol.\" Ar henot hen oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allaye zar zar zat mozin fahari zanuwar edde zar zar zat mozin górot falede zanuwar edde zar zar zat mozin zobinot hár ḍoilla buke aṛede zandar okkol banaiye. Ar Allaye sadde hin bala oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tarfore Allaye hodde, \"Ãra ãrar súrot loi, ãrar ḍoilla manuš banai. Hitara doriyar mas, asmanor faik, górot falede edde fahari zanuwar, ar duniyair hár ḍoilla buke aṛede zandar okkolor uwore šašon goribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Toi Allaye manušore nizor súrote sirišti goijje, Allar súrote hibare sirišti goijje; maya edde morod gori hibaye hitarare sirišti goijje. ");
INSERT INTO rhg_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allaye hitarare duwa goijje edde hitarare hodde, \"Fólwala o edde zono šoinkaye beši o edde duniyai furon goro, ar duniyaire nizor šašonor tole ano. Ar doriyar mas okkol, asmanor tole faikor okkol, edde duniyair hár ḍoilla buke aṛede zandar okkolor uwore razagiri goro.\" ");
INSERT INTO rhg_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Tarfore Allaye hodde, \"So, ãi duniyait asede hár ḍoilla biz fodai gorede lota-fata edde hár ḍoilla dana loi gula dorade gas okkol tũwarare dilam, hin okkol tũwarar haiddo oibo. ");
INSERT INTO rhg_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ar duniyair hár zandar okkolore, asmanor uworor hár ḍoilla faik edde buke aṛede zandar okkolore, mani zeduggun zandar šiz ase hinolla adar hisabe hail fata gas gusola dilam.\" Ar henot hen oiye. ");
INSERT INTO rhg_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Toi Allaye hibar foida goijja hár kiššur uzu saiye, ar so, hin beši bala oiye. Toi hazinna oiye edde binna oiye, ar hiyan aššilde so lomboror din. ");
INSERT INTO rhg_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Endilla gori asman edde zobin ar hinor butore hár kissu tiyar gora šeš oiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ar Allaye hãt dinor din hibaye gorat aššilde hamore šeš goijje; he hãt dinor din hibar hár hamottu ziraiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Toi ei hãt dinor dinware Allaye duwa goriyore fobitro din goijje, kiyollahoile he dinot hibar sirišti edde goijjilde hár hamottu ziraiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","In oiyede asman edde zobinor sirišṭi kahani zẽtte hinore sirišṭi gora oil, zẽtte Mabud Allaye asman edde zobin banaiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Hẽtte duniyair zobinot hono zõl, gas gusola nu aššil, ar maṛot hono lota-fata no fuṛe, kiyollahoile Mabud Allaye hẽtte o duniyait hono zór no defeṛa edde zobinot saš goribolla o hono manuš nu aššil. ");
INSERT INTO rhg_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kintu meṛir tolottu fani uṛiyore zobinor uworor muk agagura bizito. ");
INSERT INTO rhg_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Toi Mabud Allaye meṛir dúil loi manuššuwar forma banaiye edde hibar nak sai fu diyore butore zibon niyaš golai diye edde manušwa ek ziyãta zandar oiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ar Mabud Allaye fuke Edenot ekkan bagan lagaiye; edde hibar tiyari manušware hibaye heṛe raikke. ");
INSERT INTO rhg_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mabud Allaye meṛittu hár zator gas okkol fuṛi uṛabaiye, zin saite o šundor, edde háite o bala, ar baganor maze zibon gas edde neki bodi aholor gas. ");
INSERT INTO rhg_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ar baganot fani dibolla Edenottu ekkan hal niyolle; edde hiyanottu sairgan muk oiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Foilaganor nam oilde Fišon; iyan oilde hiyan ziyan fura Havilah deš guriyore giye, heṛe zeṛe šuna fa za. ");
INSERT INTO rhg_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Ar he dešor šuna bala, ar heṛe bedullium edde šoham fattor o ase.) ");
INSERT INTO rhg_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dusora halor nam oilde Gihon; iyan oilde hiyan ziyan fura Kuš deš guriyore giye. ");
INSERT INTO rhg_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tisera halor nam oilde Hiddekol; iyan oilde hiyan ziyan Asšur dešor fukottu di giye. Ar sair lombor hal oilde Efurat. ");
INSERT INTO rhg_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bade Mabud Allaye manušware loi Eden baganot saš goribolla edde hiyanor dehafuna goribolla heṛe raikke. ");
INSERT INTO rhg_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Toi Mabud Allaye manušware endilla hokum diye, \"Tui ei baganor hár gasor gula issa mozin hái faribi; ");
INSERT INTO rhg_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kintu neki bodi ahol gasottu no há foribo, kiyollahoile ze din tui hibattu háibi, he din tui moribi moribi.\" ");
INSERT INTO rhg_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Bade Mabud Allaye hodde, \"Manušwalla ekela takonan iyan bala no, ãi hitalla hitar laikka ekzon modot goroya zuri banaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Toi Mabud Allaye meṛittu hár fahari zanuwar edde asmanor faik okkolore tiyar goijje; bade manušwaye hinore ki ki name ḍake, hiyan saibolla hin okkolore hibar hãse ainne, henot manušwaye ze zandar zanuwarore ze name ḍaikke, hibar he nam oiye. ");
INSERT INTO rhg_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Manušwaye hár górot falede zanuwar edde asmanor hár faik okkol edde fahari zanuwar okkolor nam raikke. Kintu he manušwalla hibar laikka ekzon modot goroya zuri fa no za. ");
INSERT INTO rhg_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Toi Mabud Allaye manušwar uwore bári gum forefan goijje; toi hiba gumot maze Allaye hibar šaiṭṭanar ãḍḍittu ekkan loiye edde hiyanot bodole gusto loi borai diye. ");
INSERT INTO rhg_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mabud Allaye manušwattu kuli loilde aḍḍigan loi ek mayafuwa goijje, edde hibare manušwar hãse ainne. ");
INSERT INTO rhg_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Hetunot manušwaye hodde, \"Ebar oiye! Iba ãr aḍḍir aḍḍi, ãr gustor gusto; hibare 'mayafuwa' ḍaka oibo, kiyollahoile ibare manušwar butottu lowa oiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hetolla manuše hitar bab mare erizagoi edde hitar bou loi ek o, ar hitara duizon ek ga o. ");
INSERT INTO rhg_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Hẽtte manušwa edde hibar bou hitara dunizon lenḍa aššil, ar hiyanot hitarattu hono šorom nu aššil. ");
INSERT INTO rhg_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mabud Allaye banaiyede zobinor hár fahari zandar zanuwar okkolottuwaro beši salak aššilde oilde haf, toi hite mayafuwaware hodde, \"Allaye ki hãsa hoiye, 'Tũwara baganor hono gasor gula no háiyo'?\" ");
INSERT INTO rhg_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mayafuwawaye hafware hodde, \"Ãra baganor gas okkol beggunor gula hái fari; ");
INSERT INTO rhg_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kintu baganor maze ze gas ase, hibar gular babute Allaye hoiye, 'Tũwara hibattu no háiyo, hin no suiyo, hen gorile moriba.'\" ");
INSERT INTO rhg_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Toi hafe mayafuwaware hodde, \"No, tũwara no moriba, ");
INSERT INTO rhg_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","kiyollahoile Allaye zane ze, ze din tũwara hibattu háiba, hedin tũwarar suk kuli zaiboide edde neki bodi aholor giyan fai tũwara Allar ḍoil oizaibagoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Toi mayafuwawaye dekedde, he gasor gulawa háite bala oibo, ar hiba suke saite o šundor, hin bade giyan faibolla hoi oile o hon sa. Toi hibaye ho uggwa gula fari loi háiye, ar fũwati aššilde hibar zamai, hibare o diye, hibaye o háiye. ");
INSERT INTO rhg_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Henot hitara dunizonor suk kuli giyeoi, ar hitara ulongode hiyan buzi faijje; toi hitara ḍũir fata gãtiyore ga guijje. ");
INSERT INTO rhg_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bade hazinnar ṭanḍa hawar ṭaimot Mabude bagonot gurafira goredde abaz hitara fuinne, toi manušwa edde hibar bou Mabud Allar sarmottu baganor gas okkolor butore lukai taikke. ");
INSERT INTO rhg_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kintu Mabud Allaye manušware ḍaki hodde, \"Tui hoṛe?\" ");
INSERT INTO rhg_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Manušwaye hodde, \"Ãi baganot tũwar abas fuinni, edde ãi ḍoraiyi; kiyollahoile ãi ulongo, ar ãi lukaiyi.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Toi Mabud Allaye hodde, \"Tui ze ulongo iyan tore hone hoiye? Ze gasottu no háibolla mana goijjilam, tui ki hibattu gula háiyos?\" ");
INSERT INTO rhg_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Henot manušwaye hodde, \"Ze mayafuware tũi eṛe ãr fũwati diyo, hibaye ãre gasottu diye, ar ãi háiyi.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Toi Mabud Allaye he mayafuware hodde, \"Tui in ki goijjos?\" Mayafuwawaye hodde, \"Hafe ãre dúha diye, edde ãi háiyi.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bade Mabud Allaye hafore hodde, \"Tui ei ham goijjosde hetolla, \"Hár górowa zanuwar, edde fahari zandar zanuwar okkolor butore bodduwa tore! feṭ loi tor sola fira, ar háibi tui dúil tor zibonor hár din okkolot. ");
INSERT INTO rhg_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ãi tui edde mayafuwar maze, tor bonšo edde hibar bongšor maze, dušmonai golai diyum; hite tor mata fiši dibo, ar tui hitar formurit kuṭ maribi.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hibaye mayafuwaware hodde, \"Ãi tui hamilor ṭaimot mosibot baraidiyum. tui beši zontrona loi fuwa biyaibi. Ar tor zamair uzu tottu issa oibo Ar hite tor uwore šašon solaibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ar hibaye manušware hodde, \"Tui tor bouwor hota doijjos, edde ze gasor babute ãi tore hokum dilam, 'Tui hibattu no háis,' hibattu gula háiyos, \"Tor zoriya zobinore bodduwa; beši duk hošto gori, hiyanottu há foribo. tor zibonor hár din okkolot. ");
INSERT INTO rhg_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ar hiyane keṛa edde agasa okkol tolla fuṛaibo, ar maṛot zin baribo hin tui háibi. ");
INSERT INTO rhg_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","mukottu gam zóraiyore, haiddo háibi meṛit firi nu aiyos foijjonto, tore to hentu lowa oiye, Kiyollahoile tui oilde dúil, ar dúilot tui firizaibi.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bade manušwaye hibar bouwor nam diye Hawa, kiyollahoile hiba hár zinda okkolor ma oiye. ");
INSERT INTO rhg_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mabud Allaye Adom edde hibar bouwolla samrar hor banaiye edde hitarare findai diye. ");
INSERT INTO rhg_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tarfore Mabud Allaye hodde, \"So, neki bodi aholor giyan fai manuš ãrar ekzonor ḍoil oiye, bala edde horaf zaner. Ebar hite zene hat barai diyore zibon gasor gula háiyore azibon basi tai no fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Toi Mabud Allaye manušware zentu lowa oil, Eden baganottu he meṛit saš goribolla niyolai diye. ");
INSERT INTO rhg_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Endilla gori hibaye manušware hentu niyolai diye, edde zibon gasor heṛe zaibar fõtot fahara dibolla Eden baganor fuk ḍakottu Karubi firista okkolore raikke, ar he fũwati heṛe ekkan zolonto toluwar raikke ziyan azibon guri guri taikke. ");
INSERT INTO rhg_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adome hibar bou Hawa loi mille, toi hiba hamil oiye edde Kabilore zormo diye. Hibaye hodde, \"Mabudor modote ãi ekzon manuš zormo di faijji.\" ");
INSERT INTO rhg_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tarfore hibaye Kabilor bái Habilore zormo diye. Habil sool soroya, ar Kabil zobin saš goroya oiye. ");
INSERT INTO rhg_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bade ek šome Kabile Mabudor hãse hodun zobinor fošol aniyore kurbani goijje. ");
INSERT INTO rhg_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ar Habile o hitar nizor zanuwaror zákottu hougguwa foila zormor soolor sore ani hinor sorofwala gustore loi Mabudor hãse kurbani goijje. Mabude Habilore edde hitar kurbanire goisse, ");
INSERT INTO rhg_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kintu Kabil edde hitar kurbanire no gose. Henot Kabil kub beši gušša oiye ar hite nak muk hala gori roiye. ");
INSERT INTO rhg_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Toi Mabud Allaye Kabilore hodde, \"Tui gušša kiyolla oiyos, ar nak muk kiyolla hala goijjos? ");
INSERT INTO rhg_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tui o soiyigan goitti boli torgan o gosa no oito ne? Ar zodi soiyigan no goros, henoile to gunaye tore faibolla dorozat ai boi roiye, kintu tottu hiyanor uwore šašon sola foribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tarfore ekdin Kabile Habilore hodde, \"Aio, ãra bilot zai.\" Bade hitara bilot aššilde šomot, Kabile Habilore hamela goijje edde mari felaiye. ");
INSERT INTO rhg_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Hetunot Mabude Kabilore hodde, \"Tor bái Habil hoṛe?\" Kabile hodde, \"Ãi hoi no fari, ãi ki ãr bái soroya ne hono?\" ");
INSERT INTO rhg_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mabude hodde, \"Sa, tui in ki goijjios! Tor báiyor lou zobinottu tai ãr hãse hander. ");
INSERT INTO rhg_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tor uwore gozob foijje. Tor báiyor lou tor hatottu ze zobine suišše he zobinor bodduwa ehon tor uwore foijje. ");
INSERT INTO rhg_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tui zẽtte alsaš goribi hẽtte hine tore heto fól no dibo. Tui duniyait ziransara edde musafer oibi.\" ");
INSERT INTO rhg_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Toi Kabile Mabud Allare hodde, \"Ei šaza ãlla bordašor bare oibo. ");
INSERT INTO rhg_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","So, aijja tũi ãre enttu lorai dila, ziyanor zoriya ãi tũwar sukor arguwale oi zaiyumboi. Ãi zẽtte ziransara musafer oi duniyait gúriyum hẽtte zar sarme foriyum hite ãre kun gori faribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kintu Mabude Kabilore hodde, \"Etolla tore ze maribo, hitar uwore hãt gun daiya lowa oibo.\" Ar Mabude ekkan nišana diye, toi zene ze honokiye hitare faile no mare. ");
INSERT INTO rhg_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Bade Kabile Mabudor sarmottu zaigoi Eden baganor fuk ḍakottu Nod dešot taka šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Bade Kabile hitar bouwor hãse giye, toi hiba hamil oiye edde Honnukore zormo diye. Bade Kabile ekkan šohor bainde edde hitar futor nam mozin hiyanor nam Honnuk raikke. ");
INSERT INTO rhg_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Honnuke fut Iradore faiye, ar Irad Mehuyaelor baf oiye, Mehuyael Metúšayaelor baf oiye, ar Metúšayael Lemekor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemeke dui bou loiye, ekzonor nam Adah, oinno ar ekzonor nam Šilla. ");
INSERT INTO rhg_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adaye Jabalore biyaiye. Hite aššilde ṭambu mari zanuwar faloya okkolor bongšor foila manuš. ");
INSERT INTO rhg_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Hitar báiyor nam oilde Jubal. Hite hanai edde baši bazoya bongšor foila manuš. ");
INSERT INTO rhg_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ar Šillar feṛot Tubal-Kabil zormo oiye. Hite fitol edde lowar bout ḍoilla zontro okkol banaito. Tubal Kabilor boinor nam oilde Naamah. ");
INSERT INTO rhg_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Toi Lemeke hitar bouwainde hodde, \"Oh Adah edde Šilla, tũwara ãr hota funo; Lemekor bouwain, ãr hota funo. Ãre ze ek manuše zohom diye, ze zuwane ãr gat hat tuille, hitare ãi marifelaiyi. ");
INSERT INTO rhg_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Zodi Kabilor kunor bodola hãtgun o, toile Lemekolla hoitor hãtgun.\" ");
INSERT INTO rhg_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Bade adome abar hibar bouwor hãse giye, ar hibaye ar ek futore zormo diye edde hitar nam raikke Set, \"kiyollahoile Kabile Habilore kun goijje boli Allaye hitar zagat ãre ar ugguwa fuwa diye.\" ");
INSERT INTO rhg_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Setottu o ek fut zormo oiye, ar hite hitar nam raikke Enuš. Hẽtte manuš okkole Mabud Allar nam ḍaka šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adomor bongšo nama oilde endilla. Allaye manušware banailde šomot, hibaye hibare nizor ḍoilla gori sirišti goijje. ");
INSERT INTO rhg_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Maya edde morod goriyore hibaye hitarare širišti goijje, ar sirišti gora oiyede hedin hibaye hitarare duwa goijje edde \"Adom\" nam diye. ");
INSERT INTO rhg_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Bade Adom ekšo tiriš bosor boyošot, hibar nizor ḍoilla edde hibar nizor súrotor ḍoilla ek fut oiye, ar hibar nam raikke Set. ");
INSERT INTO rhg_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set zormo oi bade, adom aro aštošot bosor duniyait basi aššil edde aro bout futziyain okkol oil. ");
INSERT INTO rhg_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adom muṭ nošo tiriš bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ekšo fãs bosor boyošot, hiba Enušor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enuš zormo oi bade, Set aro aštošo hãt bosor basi aššil edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set muṭ nošo baro bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enuš nobboi bosor boyošot, hiba Kenanor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan zormo oi bade, Enuš aro aštošo fundro bosor basi aššil edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Beggun mili nošo fãs bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenane hoittor bosor boyošot, hiba Mahalalelor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel zormo oi bade, Kenan aro aštošo sališ bosor basi aššil edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Beggun mili nošo doš bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel haiṭ fãs bosor boyošot, hiba Yaredor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yared zomo oi bade, Mahalalel aro aštošo tiriš bosor basi aššil edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Beggun mili Mahalalel aštošo nobboi fãs bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared ekšo haiṭ dui bosor boyošot, hibaye Honnukor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Honnuk zormo oi bade, Yared aro ašṭo šot bosor basi aššil edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Beggune mili Yared nošo haiṭ dui bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Honnuk haiṭ fãs bosor boyošot, hibaye Metúšalar baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metúšalah zormo oi bade, Honnuk Allah loi tin šot bosor aza goijje edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Beggun mili Honnukor boyoš tinšo haiṭ fãs bosor oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Honnuk Allah loi solito; tarfore hiba ar no takil, kiyollahoile Allaye hibare hibar hãse loigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metúšalah ekšo aši hãt bosor boyošot, hibaye Lemekor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemek zormo oi bade, Metúšalah aro hãtšo aši dui bosor basi aššil edde aro futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Beggun mili Metúšalah nošo haiṭ no bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemek ekšo aši dui bosor boyošot, hibattu ek fut oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ar hibaye hibar nam raikke Nuh, edde hodde, \"Mabude bodduwa goijjede he meṛit ãrar ham edde hator koṭin haṛonit ite ãrare šantona dibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuh zormo oi bade, Lemeke aro fãs šo nobboi fãs bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Beggune Lemek hãt šo hoittor hãt bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tarfore Nuh fãs šot bosor oi bade, hibaye Šem, Ham, edde Yafetor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ei bafe zehon duniyait manušor šoinkka beši owa šuru goijje edde bout mayafuwain okkol zormo oiye, ");
INSERT INTO rhg_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","toi Allar futain okkole mainšor ziyain okkolore šundor dekiyore, zattu zare issa, hite hibare biya goijje. ");
INSERT INTO rhg_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Henot Mabude hodde, \"Ãr Ruh insanor butore hamiša taki no zaibogoi, kiyollahoile hitara lou edde gustor; hitarar aiyu oibo ekšo kuri bosor.\" ");
INSERT INTO rhg_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Hẽtte, edde hiyar bade o duniyait folowan okkol aššil, Allar futain okkole mainšor ziyain okkol loi zehon mille, hitarattu fuwain okkol oiye, hitara zara aššil he furan hailla nam gora beši ḍõr ḍõr bir okkol. ");
INSERT INTO rhg_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mabud Allaye sadde, duniyait manušor naformani beši ḍõr, edde hitarar dilor hár sinta bafona hár šomot bolke horafir uzu. ");
INSERT INTO rhg_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Hetolla, Mabude duniyait manuš banaiyede hiyan loi bezar oiye, edde dile duk faiye. ");
INSERT INTO rhg_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Toi Mabude hodde, \"Ãi ze manuš zati sirišti goijji, hinore duniyaittu fũsi felaiyum; manušottu loti zandar zanuwar foijjonto, buke aṛede zandar edde asmanor tole faik okkolore o; kiyollahoile ãi hitarare sirišti goriyore ãr dile duk far.\" ");
INSERT INTO rhg_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kintu Nuhuye Allar torfottu doya faiye. ");
INSERT INTO rhg_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","In oilde Nuhur bongšor kahani. Nuh ekzon forhesgar manuš aššil. He šomot manuš okkolor butore hiba aššilde ekzon haṭi manuš. Nuhuttu Allar loi aza zugazug aššil. ");
INSERT INTO rhg_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhuttu Šem, Ham edde Yafet name tin fut aššil. ");
INSERT INTO rhg_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hẽtte Allar nozorot duniyaigan horaf oigiyegoi edde zai-zulume boriuiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allaye duniyair mikka saiye, ar so, hiyan horaf oigiyegoi, haron duniyair hár mainše hitarar kufõt giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Toi Allaye Nuhure hodde, \"Hár zandaror šeš hal ãr sarme aišše, kiyollahoile hitarar duwara duniyai zulume boriuiṭṭe; ar sa, ãi duniyair fũwati hitarare dongšo gorifelaiyum. ");
INSERT INTO rhg_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tui gupér gas diyore ekkan zahaz tiyar gor; hiyanor butore kamera okkol goribi, edde hiyanor butore baire kuldar ḍoli dibi. ");
INSERT INTO rhg_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Endilla gori hiyan tiyar gora foribo: Zahazsan lamba tin šot hat, fatari šoṛa fõnzaš hat, ar hiyan usol oibo tiriš hat. ");
INSERT INTO rhg_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ar zahazor sanir ek hat tolottu zanala tiyar goribi edde zahazor ḍakottu doroza rakibi; hiyanor foila, dusora, edde tisera ṭala gori tiyar gora foribo. ");
INSERT INTO rhg_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ar sa, asmanor tole zeto ḍoilla zandar niyaš foran loi basi ase, hitara beggun dongšo oibolla ãi duniyait ek fanir tuwan aniyum, Duniyair hár zandar mori zaiboi. ");
INSERT INTO rhg_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kintu tor loi ãi ãr wadar sukti buwaiyum. Tui zai zahazot gólibi. Ar tor fũwati tor futain okkol edde tor bou edde tor futaindor bouwain okkol takibo. ");
INSERT INTO rhg_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ar lou gustowala zandar miyala modda zura zura tor fũwati zinda takibolla zahazot loibi. ");
INSERT INTO rhg_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Hár zator faik okkolottu, hár zator zandar zanuwar okkolottu edde hár zator buke aṛede zandar okkolottu foran basaibolla ek ek zura tor hãse aibo. ");
INSERT INTO rhg_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tui háibar hár ḍoilla ziniš okkol loi dola gori rakibi. Hin oibode tor edde hitarar haiddo.\" ");
INSERT INTO rhg_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhuye hendilla goijje, Allaye hokum dilde mozin hibaye hár kissu goijje. ");
INSERT INTO rhg_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Toi Mabude Nuhure hodde, \"Tui edde tor fura gór ṭiya beggune zahazot golo, kiyollahoile ei halor manuš okkolor butore ãr sarme šude tore forhesgar lot faiyi. ");
INSERT INTO rhg_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tottu fotti zator paki zanuwar okkolottu, zur milai, hãt zura gori, ar fotti zator napaki zanuwar okkolottu, zur milai, ek zura gori lowa foribo. ");
INSERT INTO rhg_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ar asmanor faik okkolottu o hendilla gori, zur milai, hãt zura gori tor fũwati lowa foribo. Duniyait hitarar bongšo basai rakibolla hendilla goribi. ");
INSERT INTO rhg_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kiyollahoile ar hãt din bade ãi duniyait sališ din sališ rait zór diyat rakium. Henot ãr sirištir hár zandar okkolore duniyaittu fũsi felaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Toi Mabude Nuhure hokum dilde mozin hibaye hár kissu goijje. ");
INSERT INTO rhg_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Duniyait fanir tuwan šuru oilde šomot Nuhur boyoš so šot bosor. ");
INSERT INTO rhg_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Fanir bottuwanottu uddar faibolla Nuhuye hibar bou, futain ar futaindor bouwain okkol loi zahazot góille. ");
INSERT INTO rhg_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ar paki zanuwar okkolottu, napaki zanuwar okkolottu, faik okkolottu edde meṛit buke aṛede hár kissu, ");
INSERT INTO rhg_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","zur zur Nuhur hãse aiyore zahazot góille, Allaye Nuhure hokum dilde mozin. ");
INSERT INTO rhg_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ar he hãt din farai zaigoi bade duniyait tuwanor fani aišše. ");
INSERT INTO rhg_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhur boyoš sošot bosor furaiyede he bosoror dui maš hõtoro dinor din, atikka meṛir tolottu beša beši fani uṛa šuru goijje, ar zóror fani zen asmanot faṛon doijje. ");
INSERT INTO rhg_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Sališ din sališ rait dori duniyair uwore zór forat roiye. ");
INSERT INTO rhg_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","He din Nuh, Šem, Ham, Yafet name Nuhur futain okkol, edde hitarar fũwati Nuhur bou edde futor bouwain okkol zahazot góille. ");
INSERT INTO rhg_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ar hitarar fũwati fotti zator ek ek zura gori fahari edde górwali zanuwar edde buke aṛede zandar, ar hár ḍoilla faik okkol o aššil. ");
INSERT INTO rhg_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Zibon niyaš loi basi roiyede hár zandar okkol zura zura Nuhur hãse zai zahazot goillil. ");
INSERT INTO rhg_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Hár zanuwar okkol, zandar ziniš okkol miyala edde morod mili zahazot uiṭṭe, ode ode Allaye Nuhure hokum dilde mozin. Toi Mabude zahazor dorozagan bon gori diye. ");
INSERT INTO rhg_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Bade sališ din mula duniyait maze tuwanor fani bariuṛat roiye. Tuwanor fani barizaiyore zahazsan meṛir uwottu fanit baši uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Toi fani uiṭṭe edde duniyait beša beši fani bari giyegoi ar zahazsan fanir uwore baša šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Duiniyair uwore tuwanor fani eto beši uiṭṭe, hinor duwara asmanor nisor ḍõr ḍõr fahar okkolore beggunore ḍufaifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fahar okkol ḍufi bade o fani aro fundro hat uworor mikka uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Henor zoriya duniyait solafira gorede hár zandar, faik, górot falede edde fahari zanuwar okkol, duniyait zãk bandi sorede šoṛo zandar okkol, ar hár manuš okkol mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Fuwana zobinor uwore zibon niyaš loi basi aššilde zandar okkol beggun mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Endilla gori hibaye zobinor bukor hár zandar fũsifelaiye, manuš, zanuwar, buke aṛede zandar okkol edde asmanor faik duniyaittu saf oigiyegoi. Šude Nuh edde hibare fũwati zara zahazot aššil hitara basi roiye. ");
INSERT INTO rhg_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tuwanor faniye duniyai ek šo fõnzaš din ḍufi aššil. ");
INSERT INTO rhg_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kintu Allaye Nuh edde hibar fũwati zahazot aššilde hár zandar okkolore monot raikke, Allaye duniyait bataš ba baiye, henot fani homa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ar meṛir tolottu fani uṛa edde asmanor faṛa okkol bondo oi giyegoi, asmanottu zór diya o tamigilgoi. ");
INSERT INTO rhg_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ar fani meṛir uwottu lami zat taikke; ekšo fõnzaš din šeše fani bout homigiyegoi, ");
INSERT INTO rhg_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","edde hãt maš hõtoro dinor din zahassan Ararot faharor uwore bazigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bade doš maš foijjonto fani homat roiye; he doš mašor foila dinot faharor tuli okkol dehagiye. ");
INSERT INTO rhg_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ar sališ din faraizaigoi bade, Nuhuye zahazot ze zanala goijjil, hiyan hibaye kuille, ");
INSERT INTO rhg_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","edde uggwa hawa baire defeṛaiye, henot hiba meṛir uwottu fani fuwai no zagoi foijjonto aiya zat gorat roiye. ");
INSERT INTO rhg_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Bade meṛir uwottu fani homigiyegoi ne, hiyan saibolla, hibaye uggwa hoitor baire defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kintu hẽtte o šara duniyair uwore fani aššil boli hoitorguwaye hono mikka ṭeng rakibar zaga no fa, hetolla hibar hãse zahazot uwafes firi aišše. Ar hibaye hat niyolaidiyore hibare doijje edde zahazor butore nizor hãse raikke. ");
INSERT INTO rhg_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Toi hibaye aro hãt din entezar goijje, bade he hoitorguware zahazottu abar baire defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Hazinna hoitorguwa hibar hãse firi aišše; ar so, hibar ṭuṛot ugguwa tottoza zaitun fata aššil; iyanot Nuhuye buzi faijje, ze meṛir uwottu fani homi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Toi hibaye aro hãt din entezar goijje, he hoitorguware abar baire defeṛaiye, edde hiba hibar hãse ar uwafes firi nu aiye. ");
INSERT INTO rhg_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhor boyoš sošo ek bosoror foila mašor foila dinor din meṛir uwottu fani fuwaigiyegoi; Toi Nuhuye zahazor sáni kulifelaiye edde baire saiye, ar so, meṛir tola fuwaigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Bade dusora mašor ek kuri hãt dinor din meṛi fuwaigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Toi Allaye Nuhure hodde, ");
INSERT INTO rhg_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","\"Tui tor bou ar tor futain edde hitarar bouwain okkolore loi zahazottu niyoli zagoi. ");
INSERT INTO rhg_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ar tor fũwati asede hár faik, zanuwar edde buke aṛede zandar, zeto zandar zanuwar ase, hin beggunore tor fũwati niyolai loiai, hitara duniyaire bori tulok, edde fólwala ok edde beši ok.\" ");
INSERT INTO rhg_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Toi Nuhuye hibar bou ar futain edde hitarar bouwain okkol beggunore loi zahazottu niyoli aišše. ");
INSERT INTO rhg_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ar zar zar zat mozin hár fahari zanuwar edde hár gorwali zanuwar, hár faik, ar meṛir uwore buke solafira gorede hár kissu, zahazottu niyoli aišše. ");
INSERT INTO rhg_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tarfore Nuhuye Mabudolla ekkan kurbangah tiyar goijje edde fotti zator paki zanuwar edde faik okkolottu hougguwa loi hiyanor uwore fura-kurbani okkol kurbani goijje. ");
INSERT INTO rhg_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mabud he kurbanir kušbot kuši oiye edde mone mone hodde: \"Manušolla ãi ar hono din meṛire bodduwa no diyum, zodi o manušor dil zuwan hale loti horaf. Ar zendilla ãi ehon goijji, hendilla ãi ar hár zandarore dongšo no goriyum. ");
INSERT INTO rhg_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","\"Zetodin duniyai takibo, niyom mozin biz owa edde fošol haṛa, ṭanḍa edde gorom, šit hal edde gorom hal, din edde rait, owa honodin no tamibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Allaye Nuh edde hibar futaindore duwa goriyore hodde, \"Fólwala o, edde beši o edde duniyai furon goro. ");
INSERT INTO rhg_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Duniyair hár zandar zanuwar okkol, edde asmanor hár faik okkol, ar zobinot buke aṛede zandar okkol, ar doriyar hár mas okkol tũwarar ḍor edde bóiye sola fira goribo; ar hin okkolore tũwarar hatot diya oiye. ");
INSERT INTO rhg_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hár kissu ziyãta edde lorasora gorede zanuwar okkol tũwaralla haiddo oibo. Ãi age zendilla tũwarare hak šobzi haiddo hisabe diyilam hendilla ehon in okkol o dilam. ");
INSERT INTO rhg_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","\"Kintu foranwala gusto mani lou šoho gusto no há foribo. ");
INSERT INTO rhg_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Honokiye zodi tũwarare kun gore toile ãi hameka tũwarar louwor bodole hitar lou mani hitar foranor dabi goriyum. Hiba fokšu ok ba manuš ok. Ar manušor foran ze manuše lo, hitar foran o lowa oibo, iyan ãr dabi. ");
INSERT INTO rhg_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","\"Manušor lou ze bair gore, manuše o hitar lou bair goribo, kiyollahoile Allaye, manušore nizor súrot loi banaiye. ");
INSERT INTO rhg_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ar tũwara fólwala o, edde beši o, duniyair sairo mikka šiṛi foro edde heṛe o aro beši o.\" ");
INSERT INTO rhg_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bade Allaye Nuh edde hibar futaindore hodde: ");
INSERT INTO rhg_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","\"So, tũwara edde tũwarar bongšo okkol loi edde tũwarar fũwati asede hár zandar zanuwar okkol, ");
INSERT INTO rhg_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","faik fokšu, górwali zanuwar edde fahari zanuwar, duniyait zeto ḍoilla zandar zanuwar okkol zahazottu niyoli aišše, hitara loi ãi ãr wadar sukti buwaiyum. ");
INSERT INTO rhg_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ãi tũwarar loi ãr wadar sukti buwair: Ar honodin endilla no oibo; fanir bottuwanor duwara hár foranwala zandar okkolore dongšo gora no oibo. Ar duniyaire dongšo gorifelaibolla ar hono din fanir bottuwan no oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Allaye aro hodde, \"Tũwara edde tũwarar fũwati asede hár zandar zanuwar okkol edde ãr maze ze wadar sukti buwair, hiyanor sinno oilde iyan, ziyan bongšor bade bongšo dori solat takibo, ");
INSERT INTO rhg_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","he bebostar sinno hisabe miyulat, ãi ãr donu dehaiyum. Hiyan oibo duniyai loi, ãr he wadar suktir sinno. ");
INSERT INTO rhg_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ãi zẽtte duniyair uwore miyula dola goriyum, hẽtte donugan miyulat deha dibo, ");
INSERT INTO rhg_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","henot tũwara edde hár zandar zanuwar loi, ãr ei wadar hota ãi monot goriyum. Ar hono din hár zandar dongšo oibolla fanir tuwan no oibo. ");
INSERT INTO rhg_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Miyulat zehon donugan deha zaibo, henot ãi hiyanor mikka saiyum, henot duniyair hár zandar okkol loi, ãr azibonor wadare monot goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tarfore Allaye Nuhure hodde, \"Duniyait hár zandar okkol loi ãi buwaiyide wadar suktir sinno oilde iyan.\" ");
INSERT INTO rhg_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhur ze futain okkol zahazottu niyoli aišše, hitara oilde Šem, Ham edde Yafet. (Ham aššilde Kenanor baf.) ");
INSERT INTO rhg_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Itara oilde Nuhur futain okkol; itarar bongšo šara duniyai sorai gilgoi. ");
INSERT INTO rhg_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Bade Nuhuye al saš gora šuru goijje edde ekkan ãngur keti goijje. ");
INSERT INTO rhg_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Hibaye ekdin šoraf fiyore matal oiye edde nizor ṭambur butore lenḍa oi fori roiye. ");
INSERT INTO rhg_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenanor baf Hame hitar bafor ei abosta deikke edde baire zai hitar dui báiyore hin zanaiye. ");
INSERT INTO rhg_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kintu Šem edde Yafete ekkan hor handot felai loiyore fissa aṛi zaiyore hitarar bafor lenḍa gare guridiye. Hitarar muk fissa firaiya aššilde hetolla hitara bafor lenḍa gare no deke. ");
INSERT INTO rhg_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Bade Nuh šorafor gúmottu uṛiyore hibar šoṛo fute hiba loi goijjede he befare zani faijje, ");
INSERT INTO rhg_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","hibaye hodde, \"Kenanore bodduwa! Hite hitar báiyaindor hãse gulamor gulam ok!\" ");
INSERT INTO rhg_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Hibaye aro hodde, \"Šemor Allah Mabudor tarif ok! Kenan Šemor gulam ok! ");
INSERT INTO rhg_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Allaye gorok, Yafetor eleha barok; Hite Šemor ṭambur tole takok, Ar Kenan hitar gulam bonok.\" ");
INSERT INTO rhg_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bor tuwan bade Nuhuye aro tin šo fõnzaš bosor baisse. ");
INSERT INTO rhg_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Beggun mili Nuh šaro no šot bosor baisse, toi bade hibar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","In oilde Nuhur futain, Šem, Ham edde Yafetor bongšor kahani, bor tuwan bade hitara zarattu futain okkol oil. ");
INSERT INTO rhg_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafetor futain okkol oilde: Gumer, Magog, Madai, Javan, Tubal, Mešek edde Tiraš. ");
INSERT INTO rhg_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gumeror futain okkol oilde: Aškenaz, Ripát edde Togarmah. ");
INSERT INTO rhg_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javanor futain okkol oilde: Elišah, Toršiš, Kittim edde Dodanim. ");
INSERT INTO rhg_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(doriyar ḍiyat takoya ei bongšo okkolottu zar zar zuban, gór edde zati okkol mozin bout deš okkolot šiṛi giyegoi.) ");
INSERT INTO rhg_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamor futain okkol oilde: Kuš, Mišor, Puṭ edde Kenan. ");
INSERT INTO rhg_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kušor futain okkol oilde: Seba, Havilah, Sabta, Raamah edde Sabteka. Raamar futain okkol oilde: Seba edde Dedan. ");
INSERT INTO rhg_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuš Nimrudor baf oiye, ze duniyait foila folowan oil. ");
INSERT INTO rhg_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Hite aššilde Mabudor sarme ek folowan šiyari; hetolla iyan endilla ho, \"Nimrudor ḍoil Mabudor sarme ekzon folowan šiyari\" ");
INSERT INTO rhg_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Sinearor Babel, Erek, Akkad edde Kalneh, ei zaga okkol oilde foila hitar raijjor ongšo. ");
INSERT INTO rhg_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","He dešottu hite Asšurot zaiyore Nineveh, Rehobot-Ir, Kalah ");
INSERT INTO rhg_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","edde Resen bainde, ziyan Nineveh edde Kalar maza mazi, ziyan oilde ekkan ḍõr šohor. ");
INSERT INTO rhg_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mišoror bafe Ludiyo, Anamiyo, Lehabiyo, Noftuhiyo, ");
INSERT INTO rhg_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrušiyo, Kasluhiyo, (hitara zarattu Filistini okkol niyoli aišše.) edde Kaptíyo okkol, ");
INSERT INTO rhg_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan oiyede hibar foila fut Sidonor baf, tarfore Hetor, ");
INSERT INTO rhg_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Zebušiyo, Amorittiyo, edde Girgašiyo, ");
INSERT INTO rhg_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hibbiyo, Arkiyo, edde Siniyo, ");
INSERT INTO rhg_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadiyo, Zemariyo, edde Hamatiyo. Aro bade zaiyore Kenaniyo zatir bongšo okkol sorai foijjil. ");
INSERT INTO rhg_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Sidon šohorottu Gerar gẽši giyede rastat Gaza foijjonto edde Gaza šohorottu Súdum, Gumarrah, Admah edde Zeboyim zaibar fõt Laša foijjonto Kenaniyo okkolor dešor šima aššil. ");
INSERT INTO rhg_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Itara oilde nizor nizor gušti, baša edde zati mozin Hamor bongšor manuš. ");
INSERT INTO rhg_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafetor bor bái Šemottu o futziyain oiye. Šem aššilde Eberor futain okkolor fordada. ");
INSERT INTO rhg_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Šemor futain oilde: Elam, Asšur, Arpákšad, Lud edde Aram. ");
INSERT INTO rhg_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramor futain okkol oilde: Uz, Hul, Getér edde Maš. ");
INSERT INTO rhg_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpákšad Šelar baf oiye, Šelah Eberor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberottu dui fut: Ekzonor nam aššil Feleg, kiyollahoile hitar ṭaimot duniyai bag oil; hitar báiyor nam aššil Joktan. ");
INSERT INTO rhg_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan aššilde itarar baf Almodad, Šelef, Hasarmaveth, Jerah, ");
INSERT INTO rhg_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO rhg_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Šeba, ");
INSERT INTO rhg_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havilah edde Jobab. Itara beggun aššilde Joktanor futain okkol. ");
INSERT INTO rhg_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(Mešattu fuk mikka Sefar fahari eleha okkolot hitara bošobaš goitto.) ");
INSERT INTO rhg_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Foribar, baša, deš edde zati hisabe itara oilde Šemor bongšor manuš. ");
INSERT INTO rhg_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ar bongšo edde zati mozin itara oilde Nuhur futaindor bongšodor. Bor tuwan bade itararar butottu bout zati okkol duniyait sorai gilgoi. ");
INSERT INTO rhg_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hẽttiyaror din okkolot šara duniyair mainše šude ek zubanot hota hoito edde hitarar baša aššilde o ek ḍoilla. ");
INSERT INTO rhg_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bade hitara fuk mikka agguwai zaite zaite Sinear dešot ekkan fuwainna zaga faiye edde heṛe hitara bošoti loiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Hitara ekzone ar ekzonore hodde, \"Aiyo, ãra iṭ banai edde hinore furaidi doro gori!\" Hen hoi hitara fattoror bodole iṭ edde mosollar bodole duna bebar goijje. ");
INSERT INTO rhg_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Hitara aro hodde, \"Aiyo, ãra ekkan ãralla šohor banai ar en ekkan usol gór banai ziyanor tuliye asman suibo, toi zene ãrar nam mošuhor o, edde ãrattu šara duniyait šiṛašitta oizagoi no fore!\" ");
INSERT INTO rhg_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tarfore manuš okkole ze šohor edde usol gór bainde, hiyan saibolla Mabud nise laimme, ");
INSERT INTO rhg_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","edde hodde, \"So, itara beggun ek zati edde ek zubanot hota hoiya okkol, itara ei ham gora šuru goijje, bade zaiyore itara ze kissu goribolla ereda loibo, ošombob kissu no oibo. ");
INSERT INTO rhg_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hetolla aiyo, ãra nise zai hitarar zubanore gulmal goridigoi toi zene hitara ekzone ar oinno zonor hota buzi no fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tarfore Mabude he zagattu hitarare duniyair hár mikka šiṛašitta gori diye. Henot hitarar šohor banaibar ham bondo oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Etolla he zagar nam oiyede Babel, ziyanor mani gulmal, haron Mabude šomosto duniyair zubanot gulmal bazaidiye. Mabude manuš okkolore hentu duniyair hár mikka šiṛašitta gori diye. ");
INSERT INTO rhg_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","In oilde Šemor bongšo okkolor kahani. Tuwan zai dui bosor bade, Šemor boyoš ekšot bosor zẽtte oiye, hiba Arpákšador baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ar Šem Arpákšador baf oi bade, hiba aro fãs šot bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpákšad tiriš fãs bosor boyošot, hiba Šelar baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Šelar baf oi bade, Arpákšad aro sair šo tin bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Šelah tiriš bosor boyošot, hiba Eberor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ar Eberor baf oi bade, Šelah aro sair šo tin bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber tiriš sair bosor boyošot, hiba Felegor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ar Felegor baf oi bade, Eber aro sair šo tiriš bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Feleg tiriš bosor boyošot, hiba Reuror baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reuror baf oi bade, Feleg dui šo no bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu tiriš dui bosor boyošot, Serugor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugor baf oi bade, Reu aro dui šo hãt bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug tiriš bosor boyošot, hiba Nahuror baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahuror baf oi bade, Serug aro dui šo bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahur ek kuri no bosor boyošot, hiba Ṭerar baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ṭerar baf oi bade, Nahur aro ekšo unnuš bosor basi aššil edde aro bout futziyain okkol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ṭerah hoittor bosor boyošot, hiba Ibraim, Nahur edde Haranor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","In oilde Ṭerar bongšor kahani. Ṭerah aššilde Ibraim, Nahur edde Haranor baf. Ar Haran Lutor baf oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kintu Haran hibar baf Ṭerar sarme hibar zormostan, Kaldiyar Ur šohorot moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ibraim edde Nahur dunizone biya goijjil; Ibraimor bouwor nam aššil Sarai, ar Nahuror bou aššilde Haranor zi Milka, ar Haran aššilde Milka edde Jiskar baf. ");
INSERT INTO rhg_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai bázá aššil, hibattu hono futziyain no o. ");
INSERT INTO rhg_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ṭeraye hibar fut Ibraim edde hibar nati mani Haranor fut Lut edde hibar futor bou mani Ibraimor bou Saraire fũwati loiye edde itara beggune Kenan dešot zaibolla Kaldiyar Ur šohorottu ruwana diye. Ar hitara Harran foijjonto aiyore heṛe bošoti loiye. ");
INSERT INTO rhg_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ṭerah dui šo fãs bosor baisse, edde Harranot Ṭerar moron oiye. ");
INSERT INTO rhg_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mabude Ibraimore hodde, \"Tui tor nizor deš, tor egena gušti edde tor bafor gór sari, ãi ze dešot tore dehaiyum tui heṛe za. ");
INSERT INTO rhg_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","\"Ãi tore ek ḍõr zati goriyum, edde ãi tore duwa goriyum; Ãi tor namore ḍõr goriyum, edde tui oinno zonolla rahamot oibi. ");
INSERT INTO rhg_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Zara tore duwa goribo, ãi hitarare duwa goriyum, ar zara tore bodduwa dibo, ãi hitarare bodduwa diyum. duniyair fotti zatiye tor duwara duwa faibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Toi Mabude hoiyede mozin Ibraime baisa diye, ar Lut o hibar fũwati giye. Harranottu niyoli zargoide šomot Ibraimor boyoš oilde hoittor fãs bosor. ");
INSERT INTO rhg_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ibraime hibar bou Saraire edde báiyor fut Lutore, ar hitara Harranot ze dón šombotti hamail, ze gulam okkol fail, hin beggun loiyore Kenan dešot zaibolla baisa diye, toi hitara Kenanot fõisse. ");
INSERT INTO rhg_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ar Ibraime deš bai zaite Šekimot he Paki zaga Mure-elun gas foijjonto giye. Hẽtte Kenaniyo okkol he dešot aššil. ");
INSERT INTO rhg_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Tarfore Mabude Ibraimore deha diye edde hibare hodde, \"Ei dešgan ãi tor bongšore diyum.\" Toi Ibraime hibare deha diyede he Mabudor mutallek heṛe ekkan kurbangah tiyar goijje. ");
INSERT INTO rhg_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Bade hibaye hentu Betelor fuke fahari elehat agguwai zaiyore fosimottu Betel ar fukottu Ai šohoror maza mazi ek zagat hibar ṭambu gãijje. Heṛe hibaye Mabudor mutallek ekkan kurbangah tiyar goijje edde Mabudor name ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tarfore Ibraime hentu baisa diyore doine Negevor mikka zat roiye. ");
INSERT INTO rhg_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bade dešot ek raṭ oiye, toi Ibraime lamat Mišorot forbaš goribolla baisa diye; kiyollahoile Kenan dešot koṭin raṭ oil. ");
INSERT INTO rhg_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ar Ibraim zehon Mišoror hãsa haši aišše, hibaye hibar bou Saraire hodde, \"Sa, ãi zani, tui kub šundori. ");
INSERT INTO rhg_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tore zẽtte Mišoriyo okkole dekibo, hitara hoibo, 'Iba itar bou.' Toi hitara tore zinda rakibo kintu ãre mari felaibo. ");
INSERT INTO rhg_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hetolla hitarare endilla hois ze, tui ãr boin, toi zene tor hatire hitara ãr loi bala bebohar gore, ar tor zoriya ãr foran basi zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ibraim zehon Mišorot góille Mišoriyo okkole deikke ze Sarai kub šundori. ");
INSERT INTO rhg_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Feruwanor ofisar okkole hibare dekiyore hitara Feruwanor hãse hibar tarif goijje; toi hibare raz moholot loi za oiye. ");
INSERT INTO rhg_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ar hibar hatire hite Ibraim loi bala bebohar goijje, ar henot hibaye bout sool, goru, gada, gadi, uṭ edde gulam edde bandi okkol faiye. ");
INSERT INTO rhg_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kintu Ibraimor bou, Sarailla boli Mabude Feruwan edde hitar foribaror uwore koṭin bola okkol goṭaiye. ");
INSERT INTO rhg_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Toi Feruwane Ibraimore ḍaki ainne edde hodde, \"Tũi ãr loi endilla ka goijjio? Hiba tũwar boude hiyan tũi ãre kiyolla no ho? ");
INSERT INTO rhg_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tũi 'Iba ãr boin' kiyolla hoiyo, toi ãi hibare biya goribolla loi annilam? So, doro tũwar bou, hibare lo edde zogoi!\" ");
INSERT INTO rhg_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Bade Feruwane hitar manuš okkolore Ibraimor babute hokum diye, ar hitara Ibraimor šombotti šoho, hibare edde hibar bouwore bidai diye. ");
INSERT INTO rhg_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Toi Ibraime hibar bou edde hibar hár kissu loiyore Mišorottu niyoli zai Negevot giye, ar Lut o hibar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ibraim goru, soole edde šuna rufaye kub beši tuwangor aššil. ");
INSERT INTO rhg_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Bade hibaye doine Negevottu ek zagattu ar ek zagat zaite zaite Betel foijjonto aišše, Betel edde Aior maza mazi ze zagat age hibar ṭambu aššil, ");
INSERT INTO rhg_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","edde zeṛe hibaye foila kurbangah tiyar goijjil. Heṛe Ibraime Mabudor nam ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ar Ibraimor fũwati giyede, Lutottu o, goru sool edde ṭambu okkol aššil. ");
INSERT INTO rhg_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kintu zagaganot hitara dunizon ekotro bošoti gora šombob no o, kiyollahoile hitarar šombotti eto oṭṭalika aššil ze hitara ekku fũwati taki no fare. ");
INSERT INTO rhg_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ar Ibraimor zanuwar soroya edde Lutor zanuwar soroya okkolor maze hoijja uiṭṭe. Ar he šomot Kenaniyo edde Perišiyo okkol o he dešot bošoti gorito. ");
INSERT INTO rhg_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Toi Ibraime Lutore hodde, \"Sa, tui edde ãr maze, tor zanuwar soroya edde ãr zanuwar soroya okkolor maze hono hoijja no ok, kiyollahoile ãra to egena. ");
INSERT INTO rhg_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tor sarme fura deš udda fori no take ne? Meherbani gori tui ãttu alok oizagoi! Tui zodi ban ḍaikka zos ãi den ḍaikka zaiyum, ar zodi tui den ḍaikka zos ãi ban ḍaikka zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lute suk tuli sadde Zordanor fura niso zaga, Soar foijjonto hár zaga zola edde saite Mabudor baganor ḍoilla otóba Mišoror ḍoilla. (Iyan aššilde Mabude Súdum edde Gumorrare dongšo goribare age.) ");
INSERT INTO rhg_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hetolla Lute Zordanor hár elehare nizolla basi loiyore fuk mikka giyegoi. Ei bafe hitara ekzon loi arekzon alok oiye. ");
INSERT INTO rhg_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibraim Kenan dešot ar Lute he elehar niso zagar šohorgunot edde Súdum foijjonto ṭambu maijje. ");
INSERT INTO rhg_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Súdum šohoror manuš okkol aššilde beši horaf edde Mabudor berudde beša beši guna gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut Ibraim loi alok oizaigoi bade Mabude Ibraimore hodde, \"Tui ze zagat asos hentu suk tuli uttor doin fuk fosim beggulla sa, ");
INSERT INTO rhg_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","haron tui ze zaga okkol dehor hin ãi tore edde tor bongšore azibonolla diyum. ");
INSERT INTO rhg_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ar duniyair dúilor ḍoilla tor bongšo baraiyum; honokiye zodi duniyair dúilore goni fare, toile tor bongšore o gona zaibo. ");
INSERT INTO rhg_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Uṭ, ei dešganor lamba edde fatari gurisa, kiyollahoile ãi tore iyan diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Toi Ibraime ṭambu hãri loiyore Hebronot asede Mamre elun gas bonor ḍake zaiyore bošoti goijje, edde heṛe Mabudor mutallek ekkan kurbangah tiyar goijje. ");
INSERT INTO rhg_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","He hár din okkolot zẽtte Sinearor badša Amrapél, Ellasaror badša Aryok, Elamor badša Kedor-Laomer edde Goyimor badša Tidal, ");
INSERT INTO rhg_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","itara Súdumor badša Bera, Gumorrar badša Birša, Admaror badša Šinab, Zeboyimor badša Šemebor edde Belar (mani Soaror) badšar berudde larai goijje. ");
INSERT INTO rhg_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ei fãszon badšaye hitarar šoinno okkol beggunore ekkui fũwati gori Siddimor ḍeilot giye, (ziyanore mora doriya o ho.) ");
INSERT INTO rhg_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Itara baro bosor foijjonto Kedor-Laomeror hokumotor tole aššil, kintu tero bosorot aiyore hitara beruddota goijje. ");
INSERT INTO rhg_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Bade soiddo bosoror ṭaimot Kedor-Laomor edde hitar fũwajja badša okkole zaiyore Ašterot-Karnayimot Refaitiyo okkolore, Hamot Zuziyo okkolore, Šaveh Kiryatayimot Emittiyo okkolore, ");
INSERT INTO rhg_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","enki moidanor ḍake asede El-Paran foijjonto zaiyore Seir fahari Horittiyo okkolore, hamela goijje. ");
INSERT INTO rhg_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bade hitara hentu firi aiyore En-Mišpáṭ (ziyanore ehon Kadeš) heṛe aišše, edde hitara Amalekiyo okkolor fura dešore edde Hasseson-Tamarot takitode Amorittiyo okkolore hõṛai felaiye. ");
INSERT INTO rhg_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ar Súdumor badša, Gumorrar badša, Admar badša, Zeboyimor badša, edde Belar (ziyan ehon Soar) badša, itara niyoli giye edde zuddolla hitarar šoinno okkolore Siddim ḍeilot tiya goraiye, ");
INSERT INTO rhg_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elamor Kedor-Laomor badša, Goyimor Tidal badša, Sinearot Amrapél badša edde Ellasarot Aryok badša, fãszon sair zon badša loi zuddo goribolla. ");
INSERT INTO rhg_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddimor ḍeilot beša beši dúnar gãra okkol aiššil; ar Súdum edde Gumorrar badša okkol dárgoide šomot, hitara heṛe fori giyegoi, ar bakigun faharor uzu dáigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Toi ei sair badšaye Súdum edde Gumorrar hár šombotti edde hitarar haiddo luṭ gori loi hentu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ar hitara Ibraimor bái fut Lut edde hibar dón šombotti loigiyegoi, kiyollahoile hiba Súdumot bošoti gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Toi dáizaigoi fajjilde ekzone aiyore Ibroni Ibraimore hóborgan hoiye. He šomot hiba Amorittiyo Mamrer elun gas bonor ḍake bošobaš gorat goijjil, Mamre aššilde Iškol edde Aneror bái, hitara Ibraim loi ekdol aššil. ");
INSERT INTO rhg_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ibraime zehon fuinne ze hibar báiyor futore bondi gori loi giyegoi, hetunot hibaye górot zormo oiyede tin šo aṛaro zon domaya gulamore loi Dan šohor foijjonto fisottu lorai loigiye. ");
INSERT INTO rhg_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Bade raitta hiba edde hibar manuš okkol, hitara bag oiye. Hitara hitarare hamela goijje, edde Damaskusor uttorottu asede Hoba foijjonto fisottu lorai loigiye. ");
INSERT INTO rhg_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Toi hibaye hár zinišfati uwafes firai ainne, ar hibaye aro firai ainne, hibar egena Lut edde hibar dón šombotti, ar mayafuwain edde manuš okkolore. ");
INSERT INTO rhg_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kedor-Laomor edde oinno badša okkolore hõṛai felai zẽtte Ibrahim uwafes firi aišše, Súdumor badšaye hibar loi deha goribolla Šaveh (ziyanore Badšar Ḍeil o ḍaka o) he ḍeilot aišše. ");
INSERT INTO rhg_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ar Šalemor badša Melkisedeke ruṭi edde šoraf ainne. Hiba aššilde šorbo šoktiwala Allar ekzon imam, ");
INSERT INTO rhg_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","toi hibaye Ibraimore duwa goijje, hodde, \"Šorbo šoktiwala Allah, asman edde zobin sirišṭi goroyaye Ibraimore rahamot gorok. ");
INSERT INTO rhg_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ar šorbo šoktiwala Allar tarif ok, ze tor dušmon okkolore tor hatot diye.\" Tarfore Ibraime hár kissur doš bag hibare diye. ");
INSERT INTO rhg_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ar Súdumor badšaye Ibraimore hodde, \"Mal samanagun tũi lo, ar manuššunore ãre do.\" ");
INSERT INTO rhg_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kintu Ibraime Súdumor badšare hodde, \"Ãi asman zobin sirišti goroya šorbo šoktiwala Mabud Allar mikka hat tuli wada gori hoir ze, ");
INSERT INTO rhg_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ãi tũwar hono kissu no loiyum, ekgas fũta otóba ṭengor senḍalor fita o no, fore zene tũi en hoi no faro, 'Ãi Ibraimore tuwangor banaiyi.' ");
INSERT INTO rhg_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Bolke ãr zuwan okkole háiyede hin bade ãi hono kissu no gosiyum. Aner, Iškol edde Mamre, zara ãr fũwati gil, hitarar fawana bag hitara fok.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","In okkol bade, Mabudor kalam Ibraimor hãse ek dehar duwara aišše: \"Ibraim, no ḍorais! Ãi tor ḍal oiyum, tor enam beši ḍõr.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kintu Ibraime hodde, \"Oh Mabud, ãr Malik, tũi ãre ki di fariba, ãide fuwain sara oi roiyi edde ãr šombottir mirazdar oibode oilde Damaskusor Eliyas?\" ");
INSERT INTO rhg_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ar Ibraime hodde, \"Tũi ãre hono futziyain no do; hetolla so, ãr góror ekzon gulam ãr šombottir mirazdar oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Hetunot Mabudor kalam hibar hãse aišše, \"Ite tor mirazdar no oibo, kintu tor nizor kun tor šombottir mirazdar oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Toi hibaye Ibraimore baire loigiye edde hodde, \"Ãsmanor mikka sa edde zodi faros he tara okkolore goni šeš gor.\" Toi Allaye hodde, \"Tor bongšo o hendilla ogona oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ibraime Mabudore biššaš goijje, ar hetolla hibare hibaye forhesgar hisabe goisse. ");
INSERT INTO rhg_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ar hibaye Ibraimore hodde, \"Ãi he Mabud, tore ei dešore miraz dibolla, ze tore Kaldiyar Ur šohorottu niyolai ainne.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Toi Ibraime hodde, \"Oh Mabud, ãr Malik, iyan ãr oibode ãi kengori zaniyum?\" ");
INSERT INTO rhg_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Toi Mabude hodde, \"Tui tin bosojja uggwa gorur so, tin bosojja uggwa sool, tin bosojja uggwa faṛa berasool, edde uggwa hoitoror so, uggwa hoitor, ãr hãse angoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Bade Ibraime hin beggun hibar hãse ainne edde hinore mazottu siri dui falda gori ek faldar ulda ḍake ar ek faldare raikke, kintu faikgunore dui falda no gore. ");
INSERT INTO rhg_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Toi šiyari faik okkol he mora zanuwar okkolor uwore zafi forerbar Ibraime hinore lorai diye. ");
INSERT INTO rhg_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Bade beil dufedde šomot Ibraim beši hora gumot foijje, ar so, beši ḍor edde boiyanok ekkan andar hibar uwore foijjede masus gorer. ");
INSERT INTO rhg_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Hetunot Mabude Ibraimore hodde, \"Iyan tui hameka zani lo, tor bongšodor okkol ofor dešot musaferi goribo edde bideši mainšor gulami goribo, mainše hitarare sair šot bosor foijjonto duk dibo. ");
INSERT INTO rhg_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kintu hitara ze zatir gulam bonibo, ãi hitarar bisar goriyum, toi tarfore hitara beša beši dón šombotti okkol loi he dešottu niyoli zaiboi. ");
INSERT INTO rhg_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ar tui šantiye tor bafdada okkolor hãse zaibi edde beši bura boyošot hoborot zaibi. ");
INSERT INTO rhg_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tor bongšor sair gurur manuš okkole eṛe firi aibo, kiyollahoile Amorittiyo okkolor guna ehono šaza diya forede hettor no o.\" ");
INSERT INTO rhg_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Bade beil ḍufizaigoi zehon ekkubare andar oi giyegoi, hetunot dũwaye boraiya uggwa sula edde ekkan zalaiya uzal deha gilo edde oi dui bag goijja gustor mazottu di giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hedin Mabude Ibraim loi ek wadar sukti buwaiye edde hodde, \"Ãi Mišor dešor Nil halottu loti ḍor hal, Fúrat foijjonto ei zagagan tor bongšore dilam. ");
INSERT INTO rhg_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kenan dešitta okkol, Kenišittiya edde Kodomoniyo, ");
INSERT INTO rhg_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetittiyo, Perišiyo edde Refaitiyo ");
INSERT INTO rhg_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorittiyo, Kenaniyo, Girgašiyo edde Zebušiyo manuš okkolor zaga okkolore tore dilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ibraimor bou, Saraiye, hiballa hono fuwain no biya. Kintu hibattu Hazera name ek Mišoriyo bandi aššil; ");
INSERT INTO rhg_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","toi Saraiye Ibraimore hodde, \"So Mabude ãre fuwain feṛot lowattu dure raikke, foriyad gorir, tũi ãr bandir hãse zo; oitfare ãi hibar duwara ek fut faiyum.\" Ar Ibraime Sarair hotat razi oiye. ");
INSERT INTO rhg_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Toi Ibraime Kenanot doš bosor taki bade, Saraiye, hibar Mišoriyo bandi Hazerare loi, hibar nizor zamai, Ibraimore diye. ");
INSERT INTO rhg_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Bade hiba Hazerar hãse giye, edde hiba hamil oiye. Ar hibaye zehon hamil oiyede buzi faijje, hibaye hibar malik sahebare hela gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Henot Saraiye Ibraimore hodde, \"Ãr uwore ei dukkor daiyi tũi. Ãi ãr bandire tũwar bukot dilam, kintu hiba hamilde buzi fariyore hibaye ãre hela gorer. Mabude tũwar edde ãr bisar gorok!\" ");
INSERT INTO rhg_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ibraime Saraire hodde, \"Sa, tor bandi tor hatot, tottu ziyan bala lage gor.\" Henot Saraiye Hazerare en duk diya šuru goijje, hiba hentu dáigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Bade Mabudor firistaye bošoti sara elehat, Soar zade fõtor kinare nol kuwa asede he nol kuwar fanir ḍake Hazerare faiye. ");
INSERT INTO rhg_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Hibaye hodde, \"Sarair bandi, Hazera, tui hontu aiyor edde hoṛe zor?\" Hibaye zuwabe hodde, \"Ãi ãr saheba Sarair hãsottu dáizairgoide.\" ");
INSERT INTO rhg_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Toi Mabudor firistaye hodde, \"Tui tor saheba Sarair hãse uwafes firi zaigoi edde hibar gulami manilogoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mabudor Firistaye hodde, \"Ãi tor bongšore eto baraidiyum, hitarare goni šeš gora no zaibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mabudor firistaye hibare aro hodde: \"Sa, tui hamil, ar tui ek fut biyaibi. Ar tui hitar nam rakibi Ismail, kiyollahoile Mabude tor dukkore fuinne. ");
INSERT INTO rhg_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ar hite ekzon murailla gadar ḍoilla manuš oibo; hite beggunor berudde hat tulibo, ar beggune hitar berudde hat tulibo. ar hite hitar egena okkol loi, bezur takibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Bade hiba loi ze hota hoiye he Mabudore ei namman diye: \"Tũi he Allah ze ãr uzu sor,\" haron hibaye hodde, \"Ze ãr uzu sar ãi hibare dekilam neki?\" ");
INSERT INTO rhg_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hetolla he kuwar nam aššil Beer-Lahai-Roi, hiba Kadeš edde Beredor maza mazi zagat ase. ");
INSERT INTO rhg_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Bade Hazeraye Ibraimolla ek futore biyaiye, ar Ibraime Hazeraye biyaiyede he futor nam diye Ismail. ");
INSERT INTO rhg_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hazeraye Ibraimolla Ismailore biyaiyede hẽtte Ibraimor boyoš aši so bosor. ");
INSERT INTO rhg_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ibraimor boyoš zehon nobboi no bosor oiye, hẽtte Mabude hibare deha diye edde hodde, \"Ãi he Šorbo-Šoktiwala Allah, ãr issa mozin sol edde hosuri sara o. ");
INSERT INTO rhg_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ar ãi tui edde ãr maze ãr wadar sukti buwaiyum edde tor bongšore beši baraidiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Henot Ibraime soida foijje, toi Allaye hibare hodde, ");
INSERT INTO rhg_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","\"Sa, iyan ãr wadar sukti tor loi: Tui bout zatir baf oibi. ");
INSERT INTO rhg_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tore ar Ibraim hoi ḍaka no oibo, kintu tor nam oibo Ibrahim, kiyollahoile ãi tore bout zatir baf goijji. ");
INSERT INTO rhg_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ãi tore fólwala goriyum, ar tor butottu bout zati goriyum, edde tor butottu badša okkol niyoli aibo. ");
INSERT INTO rhg_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ãi tui edde ãr maze azibonor wadar sukti buwaiyum, ze wadar sukti tui edde tor bongšor bade bongšo dori sirohal solat takibo. Ãi tor edde tor bongšor manuš okkolor Allah oiyum. ");
INSERT INTO rhg_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ze Kenan dešot tui ehon bidešitta oi zibon haṛaor, hiyanore ãi tui edde tor bongšore sirohalolla šombotti hisabe diyum, edde hitarar Allah oiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Toi Allaye Ibrahimore hodde, \"Tottu o ãr wadar sukti falon gora foribo, tui bade tor bongšodor okkole o. ");
INSERT INTO rhg_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iyan oilde ãr wadar sukti ziyan tui edde ãre maze, tui bade tor bongšodor okkolor maze: Tũwarar fotti furušore azomi gora foribo. ");
INSERT INTO rhg_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tũwara fottizonor bodar baror sam haṛa foribo, ar iyan oibode ãr edde tũwarar maze wadar suktir sinno. ");
INSERT INTO rhg_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Bongšor bade bongšo dori tũwarar furuš fuwain okkol zormo oi ašṭo dinor din azomi gora foribo, enki zara bongšodor no, kintu tor górot zormo oiye ba hono bidešittattu kinna gulam okkolore udda. ");
INSERT INTO rhg_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tor górot zormo oiye ba tor kinna gulam, hitarare o azomi gora foribo. Ar iyan oilde tũwarar gat sirohalolla ãr wadar sukti asede sinno. ");
INSERT INTO rhg_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kintu ze hono azomi agoraiya, zarare bodar sam haṛa no o, hitare hitar nizor zatir butottu fũsifela oibo, kiyollahoile hite ãr wadar sukti bainge.\" ");
INSERT INTO rhg_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allaye Ibrahimore aro hodde, \"Tor bou Saraire tui Sarai name no ḍakis; hibar nam oibo Sarah. ");
INSERT INTO rhg_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ãi hibare duwa goriyum, ar hibattu o ãi tore ek fut diyum. Ãi hibare duwa goriyum toi hiba bout zati okkolor ma oibo; Hibar butottu badša okkol aibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Hetunot Ibrahime uite fori hãšše edde mone mone hodde, \"Ek šot bosor oiyede ekzonottu ki fut zormo oibo? Ar nobboi bosojja Saraye ki fuwa biyaibo?\" ");
INSERT INTO rhg_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Bade Ibrahime Allare hodde, \"Ismail tũwar rahamote basi takok!\" ");
INSERT INTO rhg_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Toi Allaye hodde, \"Tor bou Saraye hameka tolla ek morod fuwa biyaibo, ar tui hitar nam Isak rakibi. Ãi hitar loi ãr wadar sukti buwaiyum, ek sirohalolla zari takibode wadar sukti, hite bade hitar bongšo okkololla. ");
INSERT INTO rhg_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ar Ismailor babute tor foriyad ãi funni: Sa, ãi hitare o duwa goriyum, ar hitare fólwala goijjum edde hitar bongšo beši baraidiyum. Hitar butottu baro sordar okkol uṛibo, ar ãi hitare ek ḍõr zati banaiyum. ");
INSERT INTO rhg_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Agami bosor en šomot Saraye tolla zare biyaibo, he Isak loi kintu ãi ãr wadar sukti buwaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ibrahim loi hota howa šeš gori bade Allah hibar hentu uṛi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Allaye hoilde mozin, he ekkui dinot Ibrahime hibar fut Ismailore edde hibar górot zormo oiyede edde hibar kinna gulam, hitara beggunore, hibar góror hár furuš okkolore loi azomi goraiye. ");
INSERT INTO rhg_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahimor boyoš nobboi no bosor zẽtte hibare azomi gora oiye, ");
INSERT INTO rhg_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ar hibar fut Ismailor boyoš tero; ");
INSERT INTO rhg_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ibrahim edde Ismail dunizonore ekkui dinot azomi gora oiye. ");
INSERT INTO rhg_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ar hibar fũwati Ibrahimor góror hár furuš okkol, górot zormo oiyede edde bidešittattu kinna gulam, hitara beggunore azomi gora oiye. ");
INSERT INTO rhg_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Bade Mabude Mamrer elun gas bonor hãse Ibrahimore deha diye. Ar hẽtte hiba dinor goromor ṭaimot ṭambur duwaror mukot boiṛa aššil. ");
INSERT INTO rhg_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Hen šomot suk tuli sadde tinzon furuš manuš Ibrahimor sarme hoddur dure tiyai roiye. Deki mottor hibaye ṭambur duwaror mukottu hitarar hãse dũri zai meṛit uite foijje. ");
INSERT INTO rhg_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ibrahime hodde, \"Oh Malik, aroz gorir, ãi zodi tũwar nozorot doya faiyiede o, toile õne ei gulamor hãsottu no zaiyogoi. ");
INSERT INTO rhg_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ãi ekkena fani anigoi, toi zene õnora beggune ṭeng dui foro edde ei gastalat aram gori faro, ");
INSERT INTO rhg_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","edde kissu hána anidi, toi zene hin haiyore ga doro gori faro, bade õnora zeṛe zor heṛe zaiyo, zehon ei gulamor sarmottu rasta bai zor.\" Hetunot hitara hodde, \"Tui zen hor hen gor.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Toi Ibrahim toratori ṭambut Sarar hãse zai hodde, \"Toratori gori ek bosta bala moida lo edde hinore maki hodun ruṭi banao.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Bade Ibrahim nize dũri zai zanuwaror zakottu uggwa barik, šundor gorur so aniyore hibare gulamor hatot diye edde hite toratori randito loigiye. ");
INSERT INTO rhg_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tarfore Ibrahime doi, dud edde rainda gusto loi hitarar sarme diye. Ar hitara hana háiye edde hiba hitarar ḍake ek gasor tole tiyai taikke. ");
INSERT INTO rhg_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Toi hitara hibare fusar goredde, \"Tor bou Sarah hoṛe?\" Hibaye hodde, \"Uṛe, hiba ṭambur butore ase.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Hitarar butottu ekzone hodde, \"Agami bosor ei ṭaimot ãi abar hameka tor hãse aiššum, ar sa, hẽtte tor bou Sarattu ek fut takibo.\" Ei hota Saraye ṭambur dorozat hibar fisottu takiyore funniye. ");
INSERT INTO rhg_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Hẽtte Ibrahim edde Sarah dunizonor boyoš beši oiye edde Sarar fuwa biyaibar boyoš o farai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hetolla Saraye mone mone hãšiyore hodde, \"Ãr roš-hoš golizai ei bura hale ãttu abar ei kuši firi aibo neki? Ar ãr malik o bura.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bade Mabude Ibrahimore hodde, \"'Ãi ki hãsa ei bura hale fuwa biyaiyum' hoiyore kiyolla Saraye hãšer? ");
INSERT INTO rhg_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mabudolla hono kissu koṭin ase neki? Agami bosor en šomot ãi abar tor hãse aiššum edde Sarattu ek fut takibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Hetunot Saraye ḍoraiyore hodde, \"Hou no! Ãi no hãši.\" Kintu hibaye hodde, \"Oi, tui hãššos.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Bade he manuššune hentu zaiboilla uiṭṭe edde hitara Súdumor mikka saiye, ar hitarare bidai dibolla hitarar fũwati Ibrahim o aṛer. ");
INSERT INTO rhg_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Toi Mabude hodde, \"Ãi ziyan goitto zair hiyan ki ãi Ibrahimottu lukaium ne? ");
INSERT INTO rhg_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ibrahim ek beši dõr edde šoktiwala zati oibo, ar duniyair hár zati okkolore hibar duwara rahamot gora oibo. ");
INSERT INTO rhg_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kiyollahoile ãi hitare basi loiyi, toi zene hite hitar fuwain edde hitar bongšo okkolore Mabudor rasta mozin soiyi edde niyai ham goribolla hokum de, zene Mabude Ibrahimor hãse ze wada dil hin Ibrahimor uwore furon gori fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Toi Mabude hodde, \"Súdum edde Gumorrar berudde guzorani beši ḍõr, ar hitarar guna beši boiyanok, ");
INSERT INTO rhg_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ze ãi ehon nise zaiyum edde hin saiyum ze guzorani ãr hãse fõisse iyan ki hendilla horaf ne naki no. Ar hen no oile, ãi zanifariyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Toi he manuššune hentu firi Súdumor mikka giye, kintu Ibrahim ehono Mabudor sarme tiyat roiye. ");
INSERT INTO rhg_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bade Ibrahime ḍake zaiyore hibare hodde: \"Õne ki horaf okkolor fũwati forhesgar okkolore o fũsifelaiba? ");
INSERT INTO rhg_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","He šohoror butore zodi fõnzaš zon forhesgar take, ar heṛiyar fõnzaš zon forhesgar okkolore o ki õne he zagar mutallek rahamot no goriyore ki hiyan dongšo gorifelaiba? ");
INSERT INTO rhg_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Horaf okkolor fũwati forhesgar okkolore o dongšo gora, õnottu dure takok. Forhesgar okkolore horafor sarme ana, õnottu dure takok. Fura duniyair bisarhare ki niyai bisar no goribo ne?\" ");
INSERT INTO rhg_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Hetunot Mabude hodde, \"Súdumor butore zodi fõnzaš forhesgar manuš fai, toile hitarar zoriya ãi he gũṛa zaga hiyanore basai rakiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Toi Ibrahime hodde, \"So, ãi tũwar šanot dúil edde sai, ar ãi šahoš gori ãr Malik loi hota hoir, ");
INSERT INTO rhg_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","zodi fõnzaš forhesgarottu fãszon hom o, toile ki ei fãszonor zoriya fura šohor dongšo gorifelaiba?\" Hibaye hodde, \"Ãi heṛe sališ fãszon faile hiyan dongšo no goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Hibaye hibare abar hodde, \"Heṛe zodi sališzonore fa gile ka?\" Hibaye hodde, \"He sališzonor zoriya, ãi hen no goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tarfore hibaye hodde, \"Malik ãr hotat naraz no oiyo, kintu ãre hoito do. Heṛe zodi tirišzonore fa gile ka?\" Toi hibaye hodde, \"Heṛe zodi ãi tirišzonore faile o ãi hen no goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahime hodde, \"So, šahoš gori ãi ãr Malik loi hota hoir, doro, heṛe zodi kurizonore fa gile ka?\" Hibaye hodde, \"Ei kurizonor zoriya, ãi hiyan dongšo no goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Toi Ibrahime hodde, \"Malik ãr hotat naraz no oiyo, edde ãre šude ar ekbar hoito do. Heṛe zodi došzon fa gile ka?\" Hibaye hodde, \"Ei došzonor zoriya, ãi hiyan dongšo no goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Toi Mabude Ibrahim loi hota howa šeš gori bade hiba hentu giyegoi, ar Ibrahim hibar nizor górot firi aišše. ");
INSERT INTO rhg_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bade he firista dunizon hãzinna Súdum šohorot fõisse, ar he šomot Lut šohoror geiṛor hãsat boiṛa aššil. Hibaye zehon hitarare deikke, hibaye uṛiyore hitara loi deha goitto giye, edde meṛit uite fori šorman zanaiye, ");
INSERT INTO rhg_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","edde hodde, \"Ãr malik okkol, meherbani gori õnora ei gulamor górot aiyore rait haṛao, ṭeng duwo. Bade binna sori uṛi õnorar baisar uzu zaigoi faribo.\" Hitara hodde, \"No, ãra šohoror butore rait haṛaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kintu Lute zehon beši doddali loi zúr goijje, hitara hibar fũwati giye edde hibar górot góille. Bade Lute iš adiya ruṭi seki hitaralla hánar entezam goijje, toi hitara háiye. ");
INSERT INTO rhg_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hitara neiṭṭo zaibar agottu Súdum šohoror zuwan edde bura, hár manuš okkole sairo ḍakottu ai Lutor gór girifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Hitara Lutore ḍak mari hodde, \"Aijja raitta tor heṛe aiššede manušgun hoṛe? Hitarare bair goriyore ãrar hãse niyolai an, toi zene ãra hitarare ãrar issa mozin gori fari.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Toi Lute dorozar baire niyoliyore hitarar hãse giye edde hibar fisottu dorozagan bon gori diye. ");
INSERT INTO rhg_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ar hodde, \"Oh ãr báiyain okkol, meherbani gori tũwara endilla horaf ham no goijjo. ");
INSERT INTO rhg_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","So, ãttu ziyain duizon ase, zitarare hono furuš mainše no suye, ãi tũwaralla hitarare anigoi edde tũwarattu hitara loi zen issa tũwara gorogoi. Šude ei manuššunore kissu no goijjo, kiyollahoile hitara ehon ãr góror salor tole assoro loiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kintu hitara hodde, \"Ator o, fõtottu lori tiya. Ei manušwa eṛe ãrar hãse aiššede bideši hisabe, tarbade oite ite ãrar uwore matabbori gorer. Ehon utarattuwaro tor loi ãra aro beši horaf bebar goriyum.\" En hoi hitara mummikka zai góror doroza bangifelaibolla Lut loi beša beši ṭelaṭeli gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kintu butottu manuš dunizone hat barai di Lutore góror butore ṭani golai felaiye edde dorozagan bongorifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ar hitara dorozar baire tiyat aššilde zuwan edde bura manuš okkolore anda gori felaiye, hiyanor zoriya hitara doroza tuwaite tuwaite oran oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Toi bade manuš dunizone Lutore hodde, \"Tottu ei šohorot tor zi zamaiyain, futain edde ziyain otóba ar hono kiye ase ne? Tui hitara beggunore loi ei zagattu bair oizagoi, ");
INSERT INTO rhg_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kiyollahoile ãra iyan dongšo gorifelaiyum. Iyanor manuš okkolor berudde Mabudor hãse guzorani eto beši ḍõr, hibaye ei šohor dongšo gorifelaibolla ãrare faṭaiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hetunot Lute baire giye edde hitara zara hibar zi zamai oibo hitarar loi hota hoiye. Hibaye hodde, \"Tũwara toratori ei zaga sari zogoi, kiyollahoile Mabude ei šohorgan dongšo gorifelaibolla tiyar ase!\" Kintu hitara mone goijje Lute fašai gorer buli. ");
INSERT INTO rhg_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Binna dol fohor oiyede šomot firista okkole Lutore hodde, \"Toratori goro! Tor bou edde tor dui zi, zara eṛe ase, hitarare loi entu niyoli zagoi, ar no oile ze gozob ei šohoror uwore lami aiyer tui o hinot maze fori dongšo oizaibigoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lute zaite deri goijje, kintu Mabudor rahamot Lutor uwore aššil buli he dui zone Lut edde hibar bou edde ziyaindore hatot dori ṭani šohoror baire loi ainne. ");
INSERT INTO rhg_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Endilla gori hitarare bair gori ani bade, hitarar ekzone hodde, \"Basito mone hoile dái zogoi! Fissa firi no saiyo ar ei fuwainna zagar hono mikka no tiyaiyo! Faharot dáizogoi, ar no oile tũwara o dongšo oiba!\" ");
INSERT INTO rhg_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kintu Lute hitarare hodde, \"Oh malik okkol, hendilla no ok! ");
INSERT INTO rhg_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","So, õnor ei gulame õnor nozorot doya faiye, ar ãr zibonore basaiyore ãr uwore dõr doya dehaiyo. Tarfore o ãi faharot dáizaigoi no faijjum; ei bifodde ãr uwore zafi foribo edde ãi mori zaiyumboi. ");
INSERT INTO rhg_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","So, eṛe ḍake ekkan šohor ase, ziyanot dũri dáiza šombob, ar hiyan šoṛo o no ne? Ãre heṛe dáizaibolla ejazot do, toi ãr zibon basi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Toi hibaye hibare hodde, \"Bala, ãi ei babute o tor foriyad rakilam edde tui ze zagar hota hoiyos hiyan dongšo no goriyum. ");
INSERT INTO rhg_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kintu toratori heṛe dáizagoi, kiyollahoile tui heṛe no fõsosgoi foijjonto ãi kissu gori no farir.\" (Hetolla he šohoror nam oiye Soar.) ");
INSERT INTO rhg_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut Soarot fõissegoide šomot beil uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tarfore Mabude asmanottu, Mabudor torfottu Súdum edde Gumorrar uwore baros edde oini šil zór felaiye. ");
INSERT INTO rhg_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hibaye he šohor okkol edde hár fuwainna zaga šoho he šohor okkolot takitode hár manuš okkol edde zobinot zin barito, hár kissure dongšo gorifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kintu Lutor bouye hibar fissa firi saiye, ar henot hiba nunor kúṛa oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Tarfordin binna sore Ibrahime uṛi he zagat hiyanot giye zeṛe hibaye Allar sarme tiyai aššil. ");
INSERT INTO rhg_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Hibaye tiyai nisor Súdum edde Gumorrar hár fuwainna zagar uzu saiye, ar dekedde iṭ baṛar bambuttu dũwa uṛerfan, he elehattu dũwa uṛer. ");
INSERT INTO rhg_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ebafe Lut zeṛe takito he fuwainna zagar šohorgun dongšo goribar šomot Allaye Ibrahimor hota bafi Lutore heṛiyar mosibotor butottu lari loi ainne. ");
INSERT INTO rhg_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Bade Lut edde hibar dui ziyore loi Soarottu ek faharot zai heṛe bošoti loiye, kiyollahoile Lute Soarot takare ḍoraiye. Ar heṛe ek faharor gãtot hitara taka šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Bade ekdin ḍõr ziye šoṛo ziyore hodde, \"Baba to bura oi zargoi. Ei elehat en hono furuš manuš o nai ze aiyore ãrare duniyair niyom mozin biya gori faribo. ");
INSERT INTO rhg_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aio! Ãra ãrar bafore šoraf habai fol gori hibar hãse zai. Henot babar duwara ãra ãrar bonšo rokka gori fariyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Henot hitara he raitta nizor bafore šoraf habaiye, bade Lutor ḍõr ziye baf loi gum zaito giye. Kintu hibar neṛa edde uṛa Lute ṭer no fa. ");
INSERT INTO rhg_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tarfor din ḍõr ziye šoṛo ziyore hodde, \"Sa, gelde raitta ãi babar loi gum gilam, ai, ãra aijja raitta o babare abar šoraf habai. Bade tui zai babar loi gum zaibi, endilla gori ãra ãrar bafor bongšo rokka gori fariyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ei bafe hitara he raitta o hitarar bafore šoraf habai fol goijje edde šoṛo ziye o bafor loi gum zaito giye. Kintu hibar neṛa edde uṛa Lute ṭer no fa. ");
INSERT INTO rhg_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Endilla gori Lutor dui ziye hitarar bafor duwara hamil oiye. ");
INSERT INTO rhg_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bade ḍõr ziyottu ek morod fuwa oiye, edde nam diye Muwab. Hite oilde ehonor Muwabiyo okkolor fordada. ");
INSERT INTO rhg_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ar šoṛo ziyottu ek morod fuwa oiye, edde hitar nam raikke Ben-Ammi. Hite oilde ehonor Ammoniyo okkolor fordada. ");
INSERT INTO rhg_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Toi Ibrahim hentu Negevot giye edde Kadeš edde Šuror maze hale ekkan zagat bošoti loiye. Ar kissu dinolla hibaye Gerarot zai taikke. ");
INSERT INTO rhg_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ar heṛe o Ibrahime hibar bou Sarar babute hodde, \"Iba ãr boin.\" Henot Geraror badša Abimaleke manuš defeṛaiyore Sarare hitar hãse ainne. ");
INSERT INTO rhg_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kintu raitta Allaye Abimalekore kuwafot aiyore hodde, \"Sa, tui morar mukot, kiyollahoile ze maya fuwa tui loi ainnos hiba ar ekzonor bou.\" ");
INSERT INTO rhg_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimaleke kintu ehono hibar ḍake no za, ar hite hodde, \"Malik, õne niduši zati oile o ki dongšo goriba? ");
INSERT INTO rhg_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hite nize ki 'ibar ãr boin,' ar hibaye nize ki 'iba ãr bái' no ho ne? Ãi šorol mone edde niduši hate ei ham goijji.\" ");
INSERT INTO rhg_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bade Allaye hitare kuwafot hodde, \"Oi, ãi zani tui šorol mone ei ham goijjos, ar hetolla ãr berudde guna gorattu tore dure raikki, ar hetolla ãi tore hibare suito no di de. ");
INSERT INTO rhg_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ehon tui he manušwar bouwore hitar hãse firaidifela, kiyollahoile hite ekzon nobi, ar hite tolla duwa goribo, henot tui basibi. Ar zodi firai no dos, toile iyan zani rak, tui edde tũwara beggune hameka moriba.\" ");
INSERT INTO rhg_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tarfordin binna sore Abimaleke uṛi hitar gulam okkol beggunore ḍaikke, edde ei hota okkol zehon hitarare funaiye, hitara kub beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Bade Abimaleke Ibrahimore ḍaki ainne edde hibare hodde, \"Tũi ãra loi endilla kiyolla gorila? Ãi tũwar ki hosuri goijji, ze tũi ãi edde ãr raijjor uwore ettor ḍõr guna ainno? Endilla hono kiye no gorede ham tũi ãr loi gorila.\" ");
INSERT INTO rhg_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Toi Abimaleke Ibrahimore aro hodde, \"Tũi ki saiyore endilla ham goijjilade?\" ");
INSERT INTO rhg_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahime zuwabe hodde, \"Ãi mone goijjilam, 'ei zagat hameka hono Allar ḍor nai, ãr bouwolla boli oitefare hitara ãre mari felaibo.' ");
INSERT INTO rhg_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ar hiba ãr boinde hiyan o soiyi, ãr bafor zi zodi o hibar ãr mar boitta zi no; ar hiba ãr bou oiye. ");
INSERT INTO rhg_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ar zẽtte Allaye ãre ãr bafor górottu bair gori ainne, hẽtte ãi hibare hoilam, 'Tui ãre endilla goriyore ador dehai faribi, Ãra zeṛe zaiyum zaiyum, tottu howa foribo \"Iba ãr bái.\"'\" ");
INSERT INTO rhg_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Toi Abimaleke hodun goru sool edde gulam edde bandi Ibrahimore diye, ar hinor fũwati hibar bou Sarare o hibar hãse firai diye. ");
INSERT INTO rhg_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Toi Abimaleke hodde, \"So, ãr deš gũṛa tũwar sarme ase, tũwattu ziyot foson lage hiyot tako.\" ");
INSERT INTO rhg_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ar hite Sarare hodde, \"So, ãi tũwar hár mainšor sarme tũi nidušide hiyan zanefan ãi tũwar báiyore ek hazar rufar foiša dir. Henot beggunor sarme forman oibo ze tũi hono hosuri no goro.\" ");
INSERT INTO rhg_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Tarfore Ibrahime Allar hãse duwa goijje ar henot Allaye Abimalek, hitar bou edde hitar bandi okolore aram goijje zene hitara abar fuwain owaifare, ");
INSERT INTO rhg_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kiyollahoile Ibrahimor bou Sarar zoriya Mabude Abimalekor góror hár mayafuwaindor fuwain owattu bad gori raikkil. ");
INSERT INTO rhg_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mabude hibar kalam mozin Sarar mikka nozor diye edde hibaye ziyan goribo wada dil Saralla Mabude hiyan goijje. ");
INSERT INTO rhg_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah hamil oiye edde hibaye Allaye ze ṭaimor hota hoil, he ekkui ṭaimot Ibrahimor bura boyošot, hiballa ek futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ar Ibrahime he fut, zare Saraye hiballa biyaiye, hitara nam diye Isak, ");
INSERT INTO rhg_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Allaye hokum dilde mozin hibar fut Isak zehon ašṭo din oiye, Ibrahime hitare azomi goraiye. ");
INSERT INTO rhg_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahim ekšot bosor boyošot hibar fut Isak zormo oiye. ");
INSERT INTO rhg_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saraye hodde, \"Allaye ãr mukot hãši ainne, ar hár kiye ze ei babute funibo hitara o ãr fũwati hãšibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hibaye aro hodde, \"Saraye fuwaindore bukor dud habai faribo, hen Ibrahimore hone hoi farito? Otoso hibar ei bura boyošot ãi hiballa ek futore zormo diyi.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Bade fuwawa bari uiṭṭe edde ze din dud saraiye, ar Isakore dud saraiyede he din Ibrahime ek ḍõr mela goijje. ");
INSERT INTO rhg_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ar Saraye dekedde Mišoror Hazeraye Ibrahimolla ze futore biyaiye, hite ṭaṭṭa gorer, ");
INSERT INTO rhg_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Toi hibaye Ibrahimore hodde, \"Ei bandi edde hibar futore dur goro, kiyollahoile ei bandir fute ãr fut Isakor fũwati honodin dón šombottir mirazdar oi no faribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ei ziniš iyan Ibrahimor nozorot beši horaf oiye, kiyollahoile hiyan hibar futor babute. ");
INSERT INTO rhg_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kintu Allaye Ibrahimore hodde, \"Tor fut edde tor bandir babute mon horaf no goris. Saraye tore zen hor tui hibar hota fun, kiyollahoile iyan Isakor duwara zin tor bongšo dora oibo. ");
INSERT INTO rhg_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ãi he bandir futore o ek zati banaiyum, kiyollahoile hite o tor fuwa.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ibrahime binna sore uṛi kissu hána edde fani boraiya uggwa samrar hoilla Hazerar handot tulidiyore hibar fut šoho bidai gori diye. Hiba hentu niyoli zai Beer-Šebar bošoti sara elehat gura fira goijje. ");
INSERT INTO rhg_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hoillar fani zehon šeš oi giyegoi, hibaye fuwaware ek zõlor zafor tole neṛai raikke. ");
INSERT INTO rhg_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tarfore uggwa tir mela marile zeddur za heddur dure zai hiba boi taikke, \"Fuwawar moron zen ãttu deha no fore\" mone mone hen hoi hiba heṛe boi guzori handa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Fuwawar handani Allaye funniye edde Allar firistaye behostottu Hazerare ḍak diye edde hodde, \"Hazera, tottu ki oiye? No ḍorais, kiyollahoile fuwawa zeṛe ase hentu hitar handani Allaye funniye. ");
INSERT INTO rhg_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tui fuwaware tul edde hitare tor hatot doro gori dor, kiyollahoile ãi hitare ek ḍõr zati banaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tarfore Allaye Hazerar suk kuli diye, henot hibaye uggwa fanir kuwa deikke. Toi hibaye zaiyore samrar hoillat fani boijje edde fuware fani fito diye. ");
INSERT INTO rhg_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah he fuwar fũwati aššil ar hite bari uiṭṭe. Hite bošoti sara elehat takito, edde tir maroya ustad boinne. ");
INSERT INTO rhg_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Hite Faronor bošoti sara elehat bošoti goijje, ar hitar maye Mišorottu ek mayafuware loi hitare biya goraidiye. ");
INSERT INTO rhg_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","He šomot Abimalek edde hitar foila komonḍar Fikole Ibrahimore hodde, \"Tũi ze kissu goro hinot Allah tũwar fũwati ase. ");
INSERT INTO rhg_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hetolla tũi eṛe Allar sarme ãre hosom gori ho, ze tũi hono din ãi otóba ãr fuwain ba ãr bongšo loi beimani no goriba. Ar ãi zendilla tũware doya dehaiyi, tũi ãre edde ze dešot tũi bidešitta hisabe takor, ei dešor loi hendilla doya dehaiba.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahime hodde, \"Oi, ãi hosom gorilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abimalekor gulam okkole zurgori uggwa fanir kuwa dokol goijjilde babute Ibrahime Abimalekor hãse nališ goijje. ");
INSERT INTO rhg_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kintu Abimaleke hodde, \"Iyan hone goijje ãi hoi no fari. Tũi ãre iyan age o no ho.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tarfore Ibrahime hodun sool edde goru ainne edde hin Abimalekore diye, ar hitara dunizone ekkan sukti goijje. ");
INSERT INTO rhg_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahime zakottu hãttuwa fãṛi bera soolor so aleda gori raikke. ");
INSERT INTO rhg_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Toi Abimaleke hibare fusar goredde, \"Tũi ei fãṛi bera soolor so hãttuware aleda gori raikkode iyanor mani ki?\" ");
INSERT INTO rhg_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Hibaye hodde, \"Ei bera soolor so hãttuwa in tũi ãr hatottu goso, toi zene tũi ãlla goba oi faro ze ei kuwa ze ãi kujji.\" ");
INSERT INTO rhg_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Etolla he zagar nam oilde Beer-šeba, kiyollahoile he zagat hitara dunizone ek wadar hosom háil. ");
INSERT INTO rhg_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hitara Beer-šebat ei sukti šeš gori bade, Abimalek edde hitar foila komonḍar Fikole Filistini okkolor dešot firigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Bade Ibrahime Beer-šebat maze uggwa zaugas lagaiye, edde heṛe he Mabud Ošeš Allar nam ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ar Ibrahim Filistini okkolor dešot bidešitta hisabe bout din forbaš goijje. ");
INSERT INTO rhg_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ei goṭonar bade Allaye Ibrahimore forikka goijje. Allaye hibare hodde, \"Ibrahim!\" Ibrahime hodde, \"Oto ãi eṛe.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Toi Allaye hodde, \"Tũi tor fut, šude lehar fut, tor adoijja fut Isakore loi Muriah elehat za, edde heṛiyar fahar zibar hota ãi tore hoiyum, hibar uwore fura kurbani hisabe hitare kurbani gor.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibrahime binna sore uṛiyore hibar gadar fiṛot godi buwaye, ar hibar gulam okkolor butottu duizon gulamore edde hibat fut Isakore fũwati loi, fura kurbanilla darguwa haṛi loiyore Allaye hoilde he zagar mikka baisa diye. ");
INSERT INTO rhg_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tin dinor din Ibrahime suk tuli saiye edde durottu tai he zaga deikke. ");
INSERT INTO rhg_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Toi hibaye hibar gulam okkolore hodde, \"Tũwara gadawa loi eṛe tako, ar ãi edde ãr fut uṛe zai dórmo gorigoi, abar tũwarar hãse firi aiššum.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Toi Ibrahime fura kurbanir darguwar fuzá loi hibar fut Isakor handot diye edde hibar hator oinor dešši edde suri loi hitara dunizon ekku fũwati giye. ");
INSERT INTO rhg_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Toi Isake hibar baf Ibrahimore hodde, \"Oh baba!\" \"Ki hodde o fut?\" hoi Ibrahime zuwab diye. Isake hodde, \"Oin edde darguwa dekir, kintu fura kurbanilla bera soolor so hoṛe?\" ");
INSERT INTO rhg_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibrahime zuwabe hodde, \"Fura kurbanilla bera soolor so Allaye nize zuhai dibo, o fut!\" Toi hitara dunizon fũwati giye. ");
INSERT INTO rhg_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Allaye hibare hoilde he zagat hitara fõsiyore Ibrahime heṛe ekkan kurbangah tiyar gori hiyanor uwore darguwa loi hãzaidiye, bade hibar fut Isakore kurbangar uwore, darguwar uwore raikke. ");
INSERT INTO rhg_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ar Ibrahime futore zorgoraibolla suri hatot loiyore tuille. ");
INSERT INTO rhg_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kintu Mabudor firistaye behostottu ḍak diye edde hodde, \"Ibrahim, Ibrahim!\" Hibaye zuwab diye, \"Oto ãi eṛe!\" ");
INSERT INTO rhg_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Hibaye hodde, \"Fuwawar uwore tor hat no dis, hitare hono kissu no goris, kiyollahoile ãi ehon buzi faijji, tui Allare ḍoros, ãlla tor šude lehar futore kurbani dite o fisfa no goros.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Hetunot Ibrahime hibar suk tuli saiye, ar so, hibar fisottu uggwa faṛa sool, šingot zõl berai ãṭkiroiye; bade Ibrahime zai he faṛa soolguwa aniyore futor bodole hibare fura kurbani kurbani diye. ");
INSERT INTO rhg_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibrahime he zagar nam raikke \"YHWH-Jireh\" (Mabud ze zuhaide.) Etolla ehono endilla ho, \"Mabudor faharot zuhaide.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Toi Mabudor firistaye behostottu dusora bar Ibrahimore ḍak maijje ");
INSERT INTO rhg_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","edde hodde, \"Tui tor futore kurbani dite fisfa no goros, hetolla ãi Mabud nize hosom hái hoir ze, ");
INSERT INTO rhg_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ãi hameka tore beši duwa goriyum, ar asmanor tara ḍoilla edde doriyar soror balur reni zedun tor bongšo hedun beši gori diyum. Tor bongšo okkole hitarar dušmon okkolor šohor okkolore dokol goribo. ");
INSERT INTO rhg_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tor bongšor duwara duniyair hár zatiye duwa faibo, kiyollahoile tui ãr hokum mainnos.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Toi bade Ibrahime hibar gulam okkolor hãse firi giye, edde hitara beggune ekku fũwati hentu Beer-Šebat firi zaiboilla baisa diye. Ar Ibrahim Beer-Šebat bošoti goijje. ");
INSERT INTO rhg_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ei goṭona goṭi bade Ibrahimore howa oiye, \"So, tũwar bái Nahurolla Melkaye o futain okkol biyaiye: ");
INSERT INTO rhg_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Foila zormo Uz, hitar bái Buz, Aramor baf, Kamuel, ");
INSERT INTO rhg_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Fildaš, Jidlap edde Betuel.\" ");
INSERT INTO rhg_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel Rebekar baf oiye. Ibrahimor bái Nahuror bou Melkaye ei ašṭo futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahuror bandi bou zar nam Reuma, hibaye o: Ṭebah, Gaham, Tahaš edde Maakah, itarare biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarar boyoš ek šo hãtaiš bosor oil; hiba hetodin basi aššil. ");
INSERT INTO rhg_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ar Kenan dešot Kiryat-Arbat (hiyan oilde, Hebronot) hibar moron oiye, ar Ibrahime Saralla handibolla edde šuk falon goribolla giye. ");
INSERT INTO rhg_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Bade Ibrahime hibar mora bouwor ḍakottu uiṭṭe edde Hetittiyo okkolor hãse zai hodde, ");
INSERT INTO rhg_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","\"Ãi tũwarar butore ekzon osin bidešitta; hoborstan banaibolla ãre tũwarar butore ekkan zaga beso, toi zene ãr sarme ãr mora bouwore dohon gorai fari.\" ");
INSERT INTO rhg_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hetittiyo okkole Ibrahimore zuwabe hodde, ");
INSERT INTO rhg_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","\"Malik, ãrar hota funo, tũi ãrar butore ekzon Allar šoktišali neta. Ãrar hoborgunor butore he barik hoboror butore tũwar morare dohon gorogoi. Tũwar mora gãraibolla ãrar honokiye hitar hobor zaga sari dite ošikar no goribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Toi Ibrahime uṛiyore he dešor manuš mani Hetittiyo okkolor sarme mata niyuraiyore ijjot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Bade hibaye hitarare hodde, \"Ãr morare ãr sarme dohon goraito diba iyan zodi tũwarar issa o, toile ãr hota funo, Soharor fut Efron loi ãlla ottor o, ");
INSERT INTO rhg_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","toi zene hitar maṛor šeš šimat, Mokfelar gãt, ziba hitattu ase, hiba hite ãre de. Hite zene tũwarar sarme hiyanor fura dam loiyore hoborstan banaibolla ãr hãse besifele.\" ");
INSERT INTO rhg_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ar Hetittiyo okkolor fũwati Efron o heṛe boiṛa aššil, ar Hetittiyo Efrone Ibrahimore zuwab dedde hiyan hitar šohor geiṛot góillede beggune funniye. ");
INSERT INTO rhg_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Hite hodde, \"No, ãr malik, õne ãr hota funo, ãi ãr zatir manušor sarme he maṭ edde hiyanot ze gãt ase, hiba šoho ãi tũware dilam. Tũwar morare dohon gorogoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Hetunot Ibrahime abar dešor mainšor sarme mata niyuraiyore ijjot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ar he dešor manuš beggunor sarme hibaye Efronore hodde, \"Zodi mone ho foriyad gorir, tũi ãr hota funo, ãi maṛor dam di, meherbani gori tũi ãttu hingun goso, toi zene ãi ãr mora bouwore heṛe dohon goraifari.\" ");
INSERT INTO rhg_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrone Ibrahimore zuwabe hodde, ");
INSERT INTO rhg_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","\"Malik, ãr hota funo, he zagar dam oiyede sair šot rufar ṭĩya, kintu hin ãlla edde tũwalla hono kissu no, tũwar bouwore heṛe dohon gorogoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahime Efronor hota buzi faijje edde hite Hetittiyo okkolor sarme rufar ṭĩyar hota hoilde mozin, sair šot rufar ṭĩya šodor okkolor maf mozin mafiyore hitare diye. ");
INSERT INTO rhg_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ei bafe Mamrer ḍake Mokfelat asede Efronor maṭ edde gãt, ar he maṛor sairo mikkar hár gas šoho, ");
INSERT INTO rhg_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","hár Hetittiyo okkol hitar šohor geiṭor sarme goillilde hitarar sarme Ibrahimor šombotti šabbišṭo oiye. ");
INSERT INTO rhg_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Tarfore Ibrahime Kenan dešor Mamrer ḍake (ziyan Hebronot) Mokfelar maṛot asede gãtot hibar bou Sarare gãraiye. ");
INSERT INTO rhg_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Endilla gori he maṭ edde heṛe asede gãt hoborstan hisabe Hetittiyo okkolor hatottu Ibrahimor hãtot aišše. ");
INSERT INTO rhg_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Hẽtte Ibrahim bura edde boyoš beši oiye, ar Mabude hibare hár kissut duwa goijjil. ");
INSERT INTO rhg_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibrahime hibar góror šobsaite furan gulam, zar uwore hibattu aššilde hin beggunor hár bár aššil, hitare hodde, \"Tor hattan ãr ranor tole rak. ");
INSERT INTO rhg_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ãi tore behosto edde duniyair Allah, Mabudor sarme hosom gorai, ze Kenaniyo okkolor butore ãi bošobaš gorir, itarar butottu ãr futolla bou no anibi, ");
INSERT INTO rhg_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","kintu ãr dešot ãr nizor egena okkolor hãse zai ãr fut Isakolla bou anibi.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","He gulame hibare hodde, \"Zodi he maya fuwa ãr fũwati ei dešot aite razi no o, henoile ze deš sari tũi eṛe aigiyogoi he dešot ki abar tũwar futore loizaiyum?\" ");
INSERT INTO rhg_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahime hodde, \"Kiyal rakis, ãr futore tui hono mote heṛe no loizais. ");
INSERT INTO rhg_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mabud ze Behostor Allah, ze ãre ãr bafor gór edde ãr zormostanottu niyolai ainne, ze ãr loi hota hoiye edde hosom hái hoiye, 'Ei dešgan ãi tor bongšore diyum' hibaye tor age hibar firistare defeṛaibo, zene tui ãr futolla hentu ek bou ani faros. ");
INSERT INTO rhg_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","He maya fuwa zodi tor fũwati aite razi no o, toile tui ãr hosomottu hedin azad; kintu hono mote ãr futore heṛe no loizais.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Toi he gulame hitar giros Ibrahimor ranor tole hat raki ei befare hibar loi hosom háiye. ");
INSERT INTO rhg_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tarfore he gulame hitar girosor ũṭ okkolottu došwa ũṭ loi, hitar girose diyede hár ḍoilla dami zinišfati okkol loi baisa diye. Hite Aram Nahuriyamor mikka ruwana diyore Nahuror šohorot giye. ");
INSERT INTO rhg_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Hite heṛe šohoror baire uṭgunore ek fanir kuwar ḍake luṛai ejje; ar hiyan aššilde hazinna ṭaimot, zẽtte mayafuwainde fani tulito za. ");
INSERT INTO rhg_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Tarfore hite duwa gorer, \"Oh Mabud, ãr giros Ibrahimor Allah, aijja ãre kamiyaf goro, edde ãr giros Ibrahimore doya dehao. ");
INSERT INTO rhg_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","So, ãi ei fanir kuwar hãsat tiyai roiyi, ar ei šohoror mainšor ziyain okkole fani tulibolla niyoli aiyer. ");
INSERT INTO rhg_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Iyan endilla ok zẽtte ãi ek zuwan mayafuware hoi, 'Tor górawa lama, zene ãi fani fiyi fari,' ar hibaye ho, 'fiyo, ai tũwar uṭgunore o ãi fani diyum' henoile hiba tũwar gulam Isakolla tũwar basai gora ok. Ar iyanot ãi zaniyum ze tũi ãr girosore doya dehaiyo.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ar so, ei duwa goijja no oite, Rebekah góra handot loi niyoli aiyer. Hiba aššilde Ibrahimor bái Nahuror bou Melkar fut Betuelor zi. ");
INSERT INTO rhg_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","He zuwan maya fuwawa aššil beši šundori, ek kumari, zibare hono manuše no sue. Hiba kuwat laimme edde góra furai loi abar uwafes uṛi aišše. ");
INSERT INTO rhg_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Hen šomot gulammuwaye dũri hibar sarme zaiyore hodde, \"Meherbani gori, tor górattu ãre ekka fani fito de.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Hibaye hodde, \"Malik, fani fiyo,\" ar toratori górawa hibar handottu hibar hatot lamaiye edde hitare fani fito diye. ");
INSERT INTO rhg_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ar hibaye hitare fani fito di bade hodde, \"Ãi tũwar uṭgunolla o fani tuliyum, zetun hitara fani fiya šeš no gore.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tarfore hibaye toratori hibar górar fanigun zanuwarore fani habade nor kulot ḍali diyore dũri abar kuwar ḍake fani tulibolla giye, edde hitar hár uṭ okkololla fani tuille. ");
INSERT INTO rhg_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ar manušwaye nizamot hibar uzu saiye, Mabude hitar baisa kamiyaf goijje ne na ki no gore zanibolla. ");
INSERT INTO rhg_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Uṭgune fani fiya šeš oi bade, manušwaye adá šekel uzonor ugguwa šunar nakful, edde dui hatolla doš šekel uzonor duiyan šunar haru hibar sarme bair goijje. ");
INSERT INTO rhg_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Toi hite hodde, \"Tui haro zi, meherbani gori ãre ho, tor bafor górot ãra rait haṛaibolla hono ekkan zaga ase ne?\" ");
INSERT INTO rhg_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hibaye zuwabe hodde, \"Ãi Melkar fut Betuelor zi, zare Melkaye Nahurolla biyaiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Hibaye aro hodde, \"Ãrar górot beša beši ker edde buši ase edde takibar zaga o ase.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hetunot he manušwaye Mabudor soida foriyore šukuriya zanaiye, ");
INSERT INTO rhg_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ar hodde, \"Hár tarif ãr giros Ibrahimor Allah Mabudore, zibaye ãr girosor mutallek hibar doya edde imandari dehare forai no fele. Ãre o fõtot, he Mabude rasta dehaiyore ãr girosor egena báiyor górot ainne.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Bade he zuwan mayafuwawaye dũri zaiyore hibar mar górot ei hota okkolore hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ar Rebekkattu Labon name ek bái aššil, hite oi kuwar ḍake manušwar hãse dũri giye, ");
INSERT INTO rhg_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Hite zehon nakful edde hitar boinor hatot haru deikke, ar manušwaye hoilde hin hitar boine hodde funniye, hite niyoliyore he manušwar hãse giye, edde hite kuwar hãsat ũṛor ḍake tiyat lotfaiye. ");
INSERT INTO rhg_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Toi hite hodde, \"Oh Mabudor rahamotwala manuš, aiyo! Baire kiyolla tiyai taikko? Ãi õnolla gór edde uṭgunolla zaga ṭik goijji.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Toi manušware górot ainne edde uṭgunottu fũza lamai loiye. Ar uṭgunore ker edde buši diye, ar manušwa edde hitar sãti mainšore ṭeng dúibolla fani diye. ");
INSERT INTO rhg_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tarfore zehon hána ainne, hetunot manušwaye hodde, \"Ãi ãr hota hoiya no o foijjonto ãi hána no háiyum.\" Toi Labone hodde, \"Toile ho!\" ");
INSERT INTO rhg_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Toi hite hor, \"Ãi Ibrahimor gulam. ");
INSERT INTO rhg_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mabude ãr girosore beša beši rahamot goijje, ehon hiba ekzon beši ḍõr manuš, ar hibaye hibare beši goru sool šuna rufa gulam edde bandi ar uṭ gada diye. ");
INSERT INTO rhg_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ãr girosor bou, Saraye hibar ei bura boyošot ãr girosolla ek futore biyaiye. Hitare hibar nizor hár kissu difelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ar ãr girose ãre endilla hoi hosom goraiye, 'Ãi zarar dešot bošobaš gorir, he Kenaniyo okkolor ziyain okkolottu ãr futolla bou no anibi, ");
INSERT INTO rhg_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","kintu tui ãr bafor górot zaibi edde ãr nizor egenar butottu ãr futolla ugguwa bou anibi.' ");
INSERT INTO rhg_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","\"Tarfore ãi ãr girosore fusar goijjilam, 'Kintu mayafuwa zodi ãr fũwati aito no sa ka?' ");
INSERT INTO rhg_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","\"Hibaye ãre hoil, 'Ãi zar sarme sola fira gori he Mabude firistare tor fũwati defeṛaibo edde tor baisare kamiyaf goraibo, toi zene ãr bafor gór edde egena okkolor butottu ãr futolla bou ani faros. ");
INSERT INTO rhg_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tui ãr egenar górot zai bade zodi hitara hibare no de toile tui ãr ei hosomottu azad.' ");
INSERT INTO rhg_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","\"Aijja ãi zẽtte kuwar ḍake aišši, ãi hoiyide, 'Oh Mabud, ãr giros Ibrahimor Allah, meherbani gori tũi ãr ei baisare kamiyaf goro. ");
INSERT INTO rhg_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ar so, ãi ei kuwar ḍake tiyai roiyi. Hono zuwan maya fuwa zodi fani tulito aiye, ãi hibare hoiyum, \"Meherbani gori, tũwar górattu ãre ekka fani fiyabo,\" ");
INSERT INTO rhg_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ar hibaye zodi ãre ho, \"Fani fiyo, Ãi tũwar uṭgunolla o fani tuliyum,\" henoile hiba he maya fuwa ok, zibare Mabude ãr girosor futolla basona goijje.' ");
INSERT INTO rhg_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","\"Ãr dilot ei hota howa šeš no oite, Rebekah góra handot loi, niyoli aišše. Hiba kuwat laimme edde fani tuille, ar ãi hibare hoidde, 'Meherbani gori ãre ekka fani do.' ");
INSERT INTO rhg_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","\"Hibaye toratori hibar górawa handottu lamaiye edde hodde, 'Fani fiyo, ar ãi tũwar uṭgunore o fani diyum.' Toi ãi fani filam, edde hibaye uṭgunore o fani diye. ");
INSERT INTO rhg_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","\"Bade ãi hibare fusar goijji, 'Tui haro zi?' \"Hibaye hodde, 'Ãi Melkar fut Betuelor zi, zare Melkaye Nahurolla biyaiye.' \"Toi ãi hibare nakot nakful, ar hatot haru findai dilam. ");
INSERT INTO rhg_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tarfore ãi Mabudore sojida goriyore šukuriya zanaiyi. Ãi ãr giros Ibrahimor Allah Mabudore šukurana adai goijji, kiyollahoile hibaye ãre soiyi rastat loi ainne zene ãi ãr girosor báifutor ziyore hibar futolla loi zai fari. ");
INSERT INTO rhg_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ehon õnora zodi ãr giros loi doya edde soiyi bebar goribolla razi aso, toile ho. Ar zodi no tako, hiyan o ho, henot ãi zene ar oinno hono mikka zai fari.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Toi Labon edde Betuele zuwab diye, \"Iyan zehon Mabudor torfottu oiye; ãra tũware bala edde bura kissu hoi no farir. ");
INSERT INTO rhg_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","So, otiya Rebekah, hibare loi zo, Mabude hoilde mozin hiba tũwar girosor futor bou ok.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ibrahimor gulame zehon hitarar ei hota fuinne, hite meṛit fori Mabudor sarme soida foijje. ");
INSERT INTO rhg_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tarfore he gulame šuna rufa guwana fati hor sour bair gori hinore Rebekare diye; ar bout dami ziniš okkol o hite hibar bái edde mare diye. ");
INSERT INTO rhg_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Toi hite edde hitar fũwati aššilde manuš okkol, hitara beggune há fiya goijje edde heṛe rait haṛaiye. Bade hitara binna sore uiṭṭe, hite hodde, \"Ãi ãr girosor heṛe zaiboilla bidai do.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kintu hibar bái edde maye hodde, \"Zuwan mayafuware aro ašṭo, doš din antaz ãrar fũwati takok; tarfore hiba zaibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ar hite hitarare hodde, \"Ãre ar eṛe raki no diyo, Mabude zehon ãr sofor kamiyaf goijjede dekir; ãre bidai do, ãi ãr girosor heṛe zaigoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tarfore hitara hodde, \"Toi zuwan mayafuwaware ḍaki, hibar mukottu ekka funi sai.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Toi hitara Rebekare ḍaikke edde fusar goijje, \"Tui ei manušwar fũwati zaibi ne?\" Hibaye hodde, \"Ãi zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Toi hitara hitar boin Rebekah edde hibar dáimare Ibrahimor gulam edde hitar manuš okkolor fũwati defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Hitara Rebekare duwa gorer edde hibare hor, \"Oh ãrar boin, tui hazar hazar futziyaindor ma o; tor bongšo okkole odihar adai gorok hitarar dušmon okkolor šohor okkolot.\" ");
INSERT INTO rhg_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Bade Rebekah edde hibar bandi okkol tiyar oiye edde uṭ okkolor uwore sori manušwar fise fise giye; ar he gulame Rebekare loi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ehon Isak Beer Lahai Roi kuwar hentu bai gil, kiyollahoile hiba Negevot takito. ");
INSERT INTO rhg_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Hazinna odde ṭaimot Isake ãṛat maze maṛot giye, ar hibaye uwor mikka sadde šomot dekedde hodun uṭ aiyer. ");
INSERT INTO rhg_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ar Rebekaye o uwor mikka saiye edde Isakore deikke. Toi hiba uṛottu nise laimme ");
INSERT INTO rhg_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","edde gulamware hodde, \"Maṛottu ãṛi ãrar uzu aiyedde hiba honnuwa?\" Toi gulammuwaye hodde, \"Hiba ãrar giros.\" Toi hibaye gũwaṛa loiye edde nizore guijje. ");
INSERT INTO rhg_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tarfore he gulame hite goijjilde hár kissu beggun Isakore zanaiye. ");
INSERT INTO rhg_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isake hibare hibar ma Sarar ṭambut ainne, edde Isake hibare loiye, toi hiba bou oiye edde hibare Isake ador goijje; hibar ma mori bade, Rebekar adore Isakore šantona dil. ");
INSERT INTO rhg_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahime ar ugguwa bou loiye, zar nam Keturah. ");
INSERT INTO rhg_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Hibaye hiballa Simron, Jokšan, Medan edde Midiyan, Išbak edde Šuah, itarare biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokšane Šeba edde Dedan, itarare faiye; ar Dedanor bongšo okkol aššilde Asšuriyo, Letušiyo edde Leummiyo. ");
INSERT INTO rhg_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ar Midiyanor futain okkol aššilde Efah, Efer, Hanok, Abida edde Eldaah. Itara beggun aššilde Keturar bongšo okkol. ");
INSERT INTO rhg_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahime hibar nizor hár kissu Isakore di giye. ");
INSERT INTO rhg_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Kintu Ibrahim basi taite, hibar bandi bouwaindor boitta hibar futain okkolore hadiya okkol diye, edde hibar fut Isakor hentu hitarare fuk mikka fuk dešot faṭai diye. ");
INSERT INTO rhg_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahimor zibonor bosoror din okkol oilde in: Hiba ekšo hoittor fãs bosor basi aššil. ");
INSERT INTO rhg_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Tarfore hibar boyoš oiyore edde beši bura boyošot šeš niyaš felaiye, edde hibar nizor manuš loi dola oiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Hibar futain Isake edde Ismaile Mamrer sarme Hetittiyo Soharor fut Efronor maṭor Mokfelar gãtot hibare dohon diye, ");
INSERT INTO rhg_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ziyan Ibrahime Hetittiyo okkolottu kini loil, heṛe hibar bou Sarar fũwati Ibrahimore o dohon gora oiye. ");
INSERT INTO rhg_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibrahimor moron oi bade, hibar fut Isakore Allaye rahamot goijje. Ar Isak Beer Lahai Roir hãse bošobaš goijje. ");
INSERT INTO rhg_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iyan oilde Ibrahimor fut Ismailor bongšo kahani, zare Sarar Mišoriyo bandi Hazeraye Ibrahimolla biyail. ");
INSERT INTO rhg_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","In okkol oilde Ismailor futaindor nam okkol, hitarar zormonamat nam okkol asede mozin: Ismailor foila zormo Nebayot, Kedar, Adbeel edde Mibsam, ");
INSERT INTO rhg_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mišma, Dumah, Massa, ");
INSERT INTO rhg_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafiš edde Kedmah. ");
INSERT INTO rhg_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","In okkol aššide Ismailor futain okkol, edde hitarar fara okkol edde ṭambu okkol mozin itara oilde baro guštir sordar okkolor nam okkol. ");
INSERT INTO rhg_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismailor zibonor bosoror din okkol oilde in: Hiba ekšo tiriš hãt bosor basi aššil. Bade hibaye šeš niyaš felaiye edde mori giyegoi, ar hibar nizor manuš loi dola oiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ar Ismaili okkol Havilattu Šur foijjonto, ziyan Mišorottu Asšuror mikka, ei zaga okkolot bošobaš goijje, edde hitara hitarar hár sordar okkole ekku fũwati taki no fare. ");
INSERT INTO rhg_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","In okkol oilde Ibrahimor fut Isakor bongšor kahani. Ibrahim Isakor baf oiye, ");
INSERT INTO rhg_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ar sališ bosor boyošot Isake Paddanor Aramiyo Betuelor zi edde Aramiyo Labonor boin Rebekare biya goijje. ");
INSERT INTO rhg_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ar Isake hibar bouwolla Mabudor hãse duwa goijje, kiyollahoile hiba bázá aššil. Mabude hibar duware goisse, edde Rebekah hamil oiye. ");
INSERT INTO rhg_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bade hibar gorbor butore fuwainde dora dori diye edde hibaye hodde, \"Ãttu endilla ka or?\" Toi hibaye Mabudottu fusar goitto giye. ");
INSERT INTO rhg_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mabude hibare hodde, \"Tor gorbot dui zati ase, Tor udorottu loti dui zati alok oiya oibo; Ek zati ar ek zatittuwaro beši šoktiwala oibo, ḍõrguwa oibo šoṛowar gulam.\" ");
INSERT INTO rhg_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Bade zehon hibaye biyaibar ṭaim aišše, ar so, hibar górbot zoikka morod fuwain. ");
INSERT INTO rhg_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ar foila niyoli aiššede hite lal, hitar hara ga kẽšša bazu ḍoilla, hetolla hitara hitar nam raikke Iš. ");
INSERT INTO rhg_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tarfore hitar bái niyoli aišše hitar hate Išor formurit dori, hetolla hitar nam raka oiye Yakub. Isakor boyoš haiṭ bosor zẽtte Rebekaye itarare biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ei fuwain ḍõr oiye edde Iš ekzon maṛot takoya, ekzon beši bala šiyari goroya oiye, ar Yakub aššilde ekzon nizam manuš, ze ṭambut takito. ");
INSERT INTO rhg_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak šiyari gusto hána moza faito, hetolla Išore ador goijje, kintu Rebekaye Yakubore ador goijje. ");
INSERT INTO rhg_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ekbar Yakube zul rãder, Iš horan ferešan oi maṛottu firi aišše. ");
INSERT INTO rhg_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Hite Yakubore hodde, \"Toratori gor, oi lal zulottu ãre kissu haito de, kiyollahoile ãi horan oiyi.\" (Hetolla Išore Edom zar mani Lal o ḍakito.) ");
INSERT INTO rhg_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kintu Yakube hodde, \"Age tui ãre tor foila zormor odihargan besifela.\" ");
INSERT INTO rhg_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Išye hodde, \"Sa, ãi mori zairgoi, foila zormor odihar loi ãi ki goijjium?\" ");
INSERT INTO rhg_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakube hodde, \"Tui aijja ãr loi hosom há.\" Henot hite hitar hãse hosom háiye, edde hitar foila zormor odihargan Yakubore besifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Toi Yakube Išore ruṭi edde rainda mošorir ḍailor zul diye. Ar hite há fiya gori bade hentu giyegoi. Endilla gori Išye hitar foila zormor odiharganore muillo sara goijje. ");
INSERT INTO rhg_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ibrahimor ṭaimot ṛat oilde he foilawa bade ar ugguwa raṭ oiye. Toi Isak Gerarot Filistini okkolor badša Abimelekor hãse giye. ");
INSERT INTO rhg_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mabude Isakore deha diye edde hodde, \"Tui entu Mišorot lami no zaisgoi, ãi tore ze zagar babute hoiyum tui he zagat bošoti gor. ");
INSERT INTO rhg_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tui hotokkalolla ei zagat tak, edde ãi tor fũwati takiyore tore rahamot goriyum, kiyollahoile ãi tore edde tor bongšore ei zaga okkol diyum, edde tor baf Ibrahimor hãse ze hosom háiyi hiyan ãi furon goijjium. ");
INSERT INTO rhg_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ãi tor bongšore asmanor tara zedun hedun goriyum edde ei zaga okkol hitarare diyum, ar tor bongšor duwara duniyair hár zatiye duwa faibo, ");
INSERT INTO rhg_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kiyollahoile Ibrahime ãr hota fuinne edde ãr hár dabi, ãr hokum okkol, ãr ain edde kanon okkol falon goijje.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Toi Isak Gerarot taigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ar he zagar mainše hibar bouwore boute fusar goijje, hibaye hodde, \"Hiba ãr boin.\" Hibaye \"Hiba ãr bou\" hoite ḍoraiye, kiyollahoile hibaye ḍoraiye ze \"Rebekkalla boli hitara hibare mari felaibo, kiyollahoile hiba beši šundor.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isake bout hal heṛe bošobaš gori bade, Filistini badša Abimaleke zanala bai dekedde, Isake hibar nizor bou Rebekah loi šuhag gorer. ");
INSERT INTO rhg_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Toi Abimaleke Isakore ḍaikke edde hodde, \"Sa, hiba hameka tor bou! Tui kengori hiba 'Ãr boin' hoi faijjos?\" Isake hitare zuwabe hodde, \"Kiyollahoile ãi mone goijjilam ãi hiballa boli foran haraiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimaleke hodde, \"Tui ãrar loi endilla kiyolla goijjos? Ze hono mainše to tor bou loi gum zai farito, ar tui ãrare hosurbon banaifelaiti.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Toi Abimaleke hár manuš okkolore endilla hoi hokum zari goijje: \"Ze honokiye ei manušwar berudde otóba hitar bouwor berudde za, hitare hameka marifela oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isake he dešot saš goijje edde he bosor hinot ek šot gun fošol faiye. Mabude hibare rahamot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Toi hiba ḍor owa šuru goijje, ar ekattu ekka bariuṛat takiyore beši ḍõr manuš boinne. ");
INSERT INTO rhg_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ar hibattu goru sool edde beša beši gulam okkol oiye, ar Filistini okkole hibar loi riš goijje. ");
INSERT INTO rhg_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Henot hibar baf Ibrahim zinda taite hibar gulam okkole kujjilde hár kuwa okkolore Filistini okkole meṛi felaiyore búzaifeliye. ");
INSERT INTO rhg_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bade Abimaleke Isakore hodde, \"Tui ãrar hentu zagoi, kiyollahoile tui ãrattuwaro beši šoktiwala oiyos.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Toi Isak hentu giyegoi edde Geraror ḍeilot zai ṭambu gãijje edde heṛe taikke. ");
INSERT INTO rhg_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Toi hibar baf Ibrahim zinda taite kujjilde kuwa hinore Isake abar kuijje, zinore Ibrahim mori bade Filistini okkole búzaifelail, ar bafe hinore ze nam okkol dil hibaye hinore he ekkui nam okkol diye. ");
INSERT INTO rhg_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isakor gulam okkole ḍeilot kuriyore heṛe ugguwa fanir nal faiye. ");
INSERT INTO rhg_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kintu Geraror soolsoroya okkole Isakor soolsoroya okkol loi hoijja diye edde hodde, \"Ei fani ãrar!\" hetolla Isake he kuwar nam diye Ešek, kiyollahoile hitara hibar loi hoijja goijjil. ");
INSERT INTO rhg_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bade hitara ar uggwa kuwa kuijje, kintu hiba loi o hitara hoijja goijje; hetolla hibaye hibar nam diye Sitnah. ");
INSERT INTO rhg_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Toi hiba hentu giyegoi edde ar uggwa kuwa kuijje, ar hiballa hitara hoijja no gore, ar hibaye hibar nam diye Rehobot edde hodde, \"Šeš foijjonto Mabude ãrare farot zaga diye, ar ãra ei zagat fólwala oi faijjum.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ar hentu hiba Beer-Šebat giye. ");
INSERT INTO rhg_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","He raitta Mabude hibare deha diyore hodde, \"Ãi tor baf Ibrahimor Allah, tũi no ḍorais; ãi tor fũwati asi, ãi tore rahamot goriyum; ar Ibrahimor hatire ãi tor bongšore baraidiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Toi Isake heṛe ekkan kurbangah tiyar goijje edde Mabudor nam ḍaikke. Heṛe hibaye hibar ṭambu o maijje, edde hibar gulam okkole heṛe uggwa kuwa kuijje. ");
INSERT INTO rhg_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Bade Abimaleke hitar dusto Ahussat edde hitar foila šenafoti Fikolore loi Gerarottu Isakor hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isake hitarare hodde, \"Tũwara ãr hãse kiyolla aiššo, tũwara to hingša gori ãre hentu dũrai dila?\" ");
INSERT INTO rhg_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Hitara hodde, \"Ãra foriškar gori dekir ze Mabud tor fũwati ase; hetolla ãra baffilam ze 'tui edde ãrar maze uggwa wada sukti takon zoruri.' Aio, ãra tor loi hosom hái, ");
INSERT INTO rhg_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ãra zendilla šude tor balai bade hono hoti no gori edde tore šanti gori bidai dilam, hendilla tui o ãrar hono hoti no goribi. Ar ehon tore Mabude rahamot goijje.\" ");
INSERT INTO rhg_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Toi Isake hitaralla hánar entezam goijje, edde hitara há fiye goijje. ");
INSERT INTO rhg_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tarfordin binna sore uṛi ekzon loi ekzone hosom háiye. Bade Isake hitarare bidai diye, ar hitara šanti gori hentu baisa diye. ");
INSERT INTO rhg_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","He din Isakor gulam okkol aiyore hitarar kuijja uggwa kuwar babute Isakore hoiye. Hitara hodde, \"Ãra fani faiyi!\" ");
INSERT INTO rhg_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Hibaye hibare nam diye Šeba. Hetolla he šohoror nam aijo foijjonto Beer-Šeba. ");
INSERT INTO rhg_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ar Išor boyoš sališ bosor oiyede šomot, Hetittiyo Beerir zi Yudit, edde Hetittiyo Elonor zi Bašmathore o, biya goijje. ");
INSERT INTO rhg_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ar hitara Isak edde Rebekar zibonore tita gori tuillil. ");
INSERT INTO rhg_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak zẽtte bura oiye edde sukor zuti eto homi giyegoi hiba ar suke deki no farito, hibaye hibar ḍõr fut Išore ḍaikke edde hodde, \"Ãr fut.\" Hite hodde, \"Oto ãi eṛe.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Toi Isake hodde, \"Sa, ãi bura oiyi ar hon din ãr moron o ãi no zani. ");
INSERT INTO rhg_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tor zontrofati, tir edde hanḍa loi maṛot za edde ãlla kissu šiyar gori an. ");
INSERT INTO rhg_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ãi foson goride hendilla kissu bana, edde ãlla an, ãi haiyum, toi zene ãi moribar age tore ãi duwa gori fari.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isake hibar fut Iš loi hota hodde Rebekaye fuinne. Toi zehon Iše maṛottu šiyar gori anibolla giye, ");
INSERT INTO rhg_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekaye hibar fut Yakubore hodde, \"Sa, ãi tor bafe tor bái Išore endilla hodde funni, ");
INSERT INTO rhg_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Ãlla kissu šiyar gori an edde ai foson goride hendilla kissu háibolla bana, toi zene ãi moribar age Mabudor sarme tore duwa di fari.' ");
INSERT INTO rhg_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hetolla oh fut, ãi tore ehon zen goitto hoir hũšiyare fun: ");
INSERT INTO rhg_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tui zai zakottu barik duwa soolor so ãre ani de, toi zene ãi tor bafe zendilla foson gore hendilla mozar kissu hána tiyar gori fari. ");
INSERT INTO rhg_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tarfore tui hinore tor bafe háibolla hibar hãse loizabi, zene hiba moribar age tore hibar duwa di fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakube hibar ma Rebekare hodde, \"So, ãr bái Iš ekzon kẽšša manuš, ar ãi kẽš sara. ");
INSERT INTO rhg_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ãr bafe zodi ãre sue edde tuwai fa ze ãi hibare dúha dir, henoile ãi nizor uwore duwattuwaro bodduwa ḍaki aniyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hibar maye hodde, \"Oh fut, tor he bodduwa ãr uwore forok, bolke tui ãi ziyan hoir hiyan gor, zaiyore hingun ãlla ani de.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tarfore Yakube zai hin loi mar hãse loigiye. Toi Yakubor bafe zendilla foson goitto, maye hendilla mozar hána tiyar goijje. ");
INSERT INTO rhg_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ar górot hibar ḍõr fut Išor ze šundor horsuwor aššil, Rebekaye hin loi hibar šoṛo fut Yakubore findai diye. ");
INSERT INTO rhg_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Yakubor hatot edde golat zeṛe kẽš nuwaššil, heṛe hibaye soolor sam berai diye. ");
INSERT INTO rhg_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tarfore nize banaiyede mozar hána edde ruṭi Yakubor hatot tulidiye. ");
INSERT INTO rhg_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Bade Yakube hibar bafor hãse zai hodde, \"Baba!\" Isake zuwabe hodde, \"Oto ãi, oh fut, tui honnuwa?\" ");
INSERT INTO rhg_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakube hibar bafore hodde, \"Ãi tũwar foila zormo Iš. Tũi ãre hoilade hendilla goijji. Meherbani gori uṛi boiyo, ãr šiyari gusto ho, toi zene tũi ãre tũwar duwa di faro.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Zuwabe Isake hibar futore hodde, \"Tui in eto toratori kengori faili, oh fut?\" Zuwabe Yakube hodde, \"Tũwar Mabud Allaye milai diye.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isake Yakubore hodde, \"Ãi tore sui farifan ãr ḍake ai, tui soyi ãr fut Iš oi ne no zani sai!\" ");
INSERT INTO rhg_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakube hitar bafor ḍake aišše, toi hibaye suiye edde hodde, \"Abaz to Yakubor abaz, ar hat to Išor hat.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Hibaye hitare sini no fare, kiyollahoile báiyor hator ḍoilla Yakubor hat o kẽšwala aššil; toi hibaye duwa diye, ");
INSERT INTO rhg_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","edde hodde, \"Tui ki soiyi ãr fut Iš oi?\" Yakube hodde, \"Oi baba.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Toi hibaye hodde, \"Toile hin ãr hãse an, ãi ãr futor šiyaror gusto hái, toi zene ãi tore duwa di fari.\" Toi Yakube hin hibar hãse loigiye edde hibaye háiye; ar Yakube hibare kissu šoraf ani diye edde hibaye fiye. ");
INSERT INTO rhg_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tarfore hibar baf Isake hodde, \"Oh fut, ikka ai, ãre suma de.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Toi Yakub hibar ḍake giye edde suma diye. Ar Isake hitar fušak fũiye edde endilla hoi duwa diye edde hodde, \"Ãr futor šugondi, oilde en ek maṭor ḍoilla, ziyanore Mabude rahamot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Allaye zen tore asmanottu kúwa de, ar tor zobinot bol de, ar beša beši gĩyu edde noya šoraf de. ");
INSERT INTO rhg_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Zati okkole tor gulam ok, ar hokkol mainše tor sarme mata zuhauk. Tor báiyaindor uwore tui malik o, ar tor mar futainde tore mata zuhauk. Tore zara bodduwa dibo, hitarar uwore bodduwa! Tore zara duwa goribo, hitarar uwore rahamot.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isake Yakubore duwa diya šeš gori bade Yakube hibar baf Isakor sarmottu zaigoi mottor hibar bái Iš šiyar gori aišše. ");
INSERT INTO rhg_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Hibaye o mozar ziniš okkol tiyar goijje edde bafor hãse ainne, toi bafore hodde, \"Baba, uṛo, tũwar futor šiyaror gusto ho, toi zene tũi ãre duwa di faro.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Hibar baf Isake hibare hodde, \"Tui honnuwa?\" Hibaye hodde, \"Ãi tũwar foila zormo, Iš.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ei hota funi Isak beša beši hafa šuru goijje edde hodde, \"Toile šiyar gori ãlla šiyaror gusto annilde hiba honnuwa? Ãi tui aibar age hin háiyi edde hitare duwa difelaiyi, ar ehon hite rahamot faigiyegoi!\" ");
INSERT INTO rhg_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Išye zehon hitar bafor hota fuinne, hite õraguzori hainde edde hitar bafore hodde, \"Baba, ãre o duwa goro!\" ");
INSERT INTO rhg_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kintu hibaye hodde, \"Tor báiye dúha bazi gori aiyore tor duwa hite loi giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iše hodde, \"Etolla no ne hitar nam Yakub? Ehon foijjonto hite ãre dui bar dúha diye: Hite ãr foila zormor odihar loiye, ar ehon hite ãr duwa loifelaye.\" Tarfore hibaye fusar goredde, \"Tũi ãlla ki hono duwa no rako ne ki?\" ");
INSERT INTO rhg_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isake zuwabe Išore hodde, \"Sa, ãi hitare tor uwore malik goijji edde hitar guštir beggunore hitar gulam goijji. Ãi hitalla gĩyu edde noya šorafolla bondobos goijji, ehon ãi tolla ar ki gori fariyum?\" ");
INSERT INTO rhg_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iše hitar bafore hodde, \"Baba, tũwattu ki šude ekkan duwa aššilde ne ki? Baba, ãre o duwa goro!\" Toi Iše guzori hainde. ");
INSERT INTO rhg_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Toi hitar baf Isake hitare zuwabe hodde, \"Sa, tor bošoti oibo bol sara zobinot, zeṛe no foribo asmanottu kúwa. ");
INSERT INTO rhg_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ar tui toluwar loi basibi, ar tui tor báiyor gulami goribi. Kintu tui zẽtte odoizzo oi uṛos, tui hitar zũwal, tor handottu felaidibi.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ar Yakubore hibar bafe duwa dil boli Iše hibare hingša goijje. Ar Iše mone mone hodde, \"Ãr bafolla šuk goribar ṭaim hãsaiyegai; tarfore ãi ar bái Yakubore marifelaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Toi Rebekaye zehon hibar ḍõr fut Išor hota zani faijje, hibaye hibar šoṛo fut Yakubor hãse hóbor defeṛaiye, hodde, \"Fun, tor bái Iše tore marifelaibar ereda loi nizore šantona der. ");
INSERT INTO rhg_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Hetolla oh fut, tũi ãr hota fun: Uṭ, tui ehon Haranot ãr bái Labonor heṛe dái zagoi. ");
INSERT INTO rhg_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Hoto din tui heṛe takgoi, tor báiyor rag homi no zagoi foijjonto, ");
INSERT INTO rhg_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ar hitar rag gilegoi edde tui ziyan goijjos hiyan hite foraifelaile, ãi hóbor defeṛaiyum edde hentu tore loi aniyum. Ãi ekkui dinot tũwara dunizonore kiyolla haraitam?\" ");
INSERT INTO rhg_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Bade Rebekaye Isakore hodde, \"Ei Hetittiyo mayafuwaingunolla buli ãttu ar basi taito mone no hor. Heṛe uwore zodi Yakube o ei dešor hono Hetittiyo mayafuware biya gore toile ãi basi taki ki lab oibo?\" ");
INSERT INTO rhg_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Toi Isake Yakubore ḍaikke edde duwa goijje, ar hibaye endilla hokum diye: \"Tui Kenaniyo hono mayafuware biya no goribi. ");
INSERT INTO rhg_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tui Paddan Aramot tor mar baf Betuelor górot za, heṛe tor mar bái Labonor hono ziyaindor butottu tolla ugguwa bou lo. ");
INSERT INTO rhg_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Šorbo-Šoktiwala Allaye tore rahamot gorok edde fólwala gorok edde barai tulok, toi zene tui ugguwa bout zatir šomaz os. ");
INSERT INTO rhg_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ar hibaye Ibrahimor duwa tui edde tor fũwati tor bongšore dok, toi zene ze zagat tui ehon ekzon bidešitta hisabe takor, ziyanore Allaye Ibrahimore dil, hiyan tor šombotti oi fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Toi Isake Yakubore bidai diye, edde Yakube Paddan Aramot, Aramiyo Betuelor fut, Rebekar bái Labonor hãse giye, ze aššil Yakub edde Išor ma. ");
INSERT INTO rhg_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iše zehon zanifaijje ze Isake Yakubore duwa goijje edde Paddan Aramottu hono ek maya fuwa biya goribolla heṛe defeṛaiye, edde hitare duwa goribar šomot hokum dil, \"Tui Kenaniyo hono mayafuware biya no goribi.\" ");
INSERT INTO rhg_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ar Yakube hitar baf edde mar hota mainne edde Paddan Aramot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Toi Išye buzi faijje ze Kenaniyo mayafuwain okkol hitar baf sukot hondilla horaf de hiyan. ");
INSERT INTO rhg_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hetolla hite Ismailor heṛe giye, edde dui bou bade hite Ibrahimor fut Ismailor zi, Nebayotor boin, Mahalathore biya goijje. ");
INSERT INTO rhg_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ar Yakub Beer-Šebattu niyoliyore Haranor mikka giye. ");
INSERT INTO rhg_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ar hono ek zagat fõsi bade heṛe rait haṛaiye, kiyollahoile beil góillegoi. Toi hibaye hentu ugguwa fattor loiye, edde matar tole diyore gum zaibolla neiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Toi Yakube šopponot dekedde, duniyair uwore ekkan hãṭṭa uwa oi roiye, ar hiyanor uworor mata asman suiye, ar so, hiyan bai Allar firista okkol uṛa lama gorer. ");
INSERT INTO rhg_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ar Mabude hiyanor uwore tiyaiye edde hodde: \"Ãi Mabud, tor baf Ibrahimor edde Isakor Allah. Tui zeṛe neṛi roiyos he zaga hiyanore ãi tore edde tor bongšore diyum. ");
INSERT INTO rhg_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tor bongšo okkol duniyair dúilor ḍoilla oibo edde fuk fosim edde uttor doine tor bongšo šiṛi zaiboi, edde tui edde tor bongšor duwara duniyair hár zatire duwa gora oibo. ");
INSERT INTO rhg_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ar sa, ãi tor fũwati asi, tui zeṛe zaibi za, ãi tore rokka goriyum, edde ãi tore ei zagat loi aniyum; kiyollahoile ãi tore wada diyide hin goijja no oite ãi tore eri no zaiyumboi.\" ");
INSERT INTO rhg_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Bade Yakubor gum bainge edde hiba hodde, \"Ei zagat hameka Mabud ase, ar ãi to iyan no zanitam.\" ");
INSERT INTO rhg_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ar hibaye ḍoraiye edde hodde, \"Ken ḍor lagede zaga iyan! Iyan ar kissu no, hameka Allar gór oibo, iyan oilde behostor geiṭ.\" ");
INSERT INTO rhg_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tarfore Yakube binna sore uiṭṭe edde ze fattor hibaye matar tole dil hiba loi faiya ḍoilla gori buwaiye edde hibar uwore tel ḍaille. ");
INSERT INTO rhg_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ar he zagar nam diye Betel, zodi o he šohorganor nam age Luz aššil. ");
INSERT INTO rhg_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Toi Yakube ek manoš goijje edde hodde, \"Zodi Allah ãr fũwati take edde zeṛe zair he fõtot ãre rokka gore, edde ãre háibolla hána ar findibolla hoor de, ");
INSERT INTO rhg_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ar zodi šušondane ãi bafor górot firi aifari, toile ei Mabud ãr Allah oibo. ");
INSERT INTO rhg_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ar ze fattor ãi eṛe faiyar ḍoilla tiya gorai raikki, hiyan Allar gór oibo, ar tũi za kissu ãre diba hinor doš bag ai tũware diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Bade Yakube zat roiye edde fuk mullukka okkolor dešot aišše. ");
INSERT INTO rhg_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Heṛe hibaye maṛot maze uggwa kuwa deikke, ar so, hibar ḍake tinnuwa berasoolor zãk luṛiroiye, kiyollahoile he kuwattu hinore fani fiyaito. Ar kuwawar mukot ekkan beši ḍõr fattor. ");
INSERT INTO rhg_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ar heṛe zãk okkol beggun zẽtte dola oito, hitara kuwar mukor fattorguware algaiyore zãkore fani fiyaito. Tarfore hitara fattorguware abar uwafes loi kuwar mukot buwai dito. ");
INSERT INTO rhg_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakube soolsoroya okkolore fusar goredde, \"Ãr báiyain okkol, tũwara hoṛiyar?\" \"Ãra Harranottu\" hoi hitara zuwab diye. ");
INSERT INTO rhg_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakube hitarare hodde, \"Tũwara Nahuror nati, Labonore sino ne?\" \"Oi, ãra sini,\" hoi zuwab diye. ");
INSERT INTO rhg_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tarfore Yakube hitarare hodde, \"Hiba bala asede no ne?\" Toi hitara hodde, \"Oi, bala ase, ar so, hibar zi Rahela berasoolor zãk loi aiyerwa.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakube hodde, \"So, beil foitte ar bout deri ase, zanuwaror zãk okkolore ekottro goribar ṭaim aizo no o. Tũwara bolke tũwarar soolgunore fani fiyaiyore hinore abar soraito loizo.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Hitara zuwabe hodde, \"Ãra hen gori no faijjum, zãk beggun ekottro no o foijjonto, toi kuwar mukottu fattorgan algaiyore ãra zãkore fani fiyai faijjumde.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakube ehono hitara loi hota hor, hen šomot Rahela hibar bafor berasoolor zãk loi heṛe aišše, kiyollahoile hiba aššilde soolsoroni. ");
INSERT INTO rhg_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Toi Yakube zehon hibar mamu Labonor zi Rahelare edde Labonor soolor zãkore deikke, hibaye ḍake zai kuwar mukottu fattorgan algaiye edde hibar mamu Labonor zãkore fani fiyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Bade Rahelare suma diye edde õraguzori handa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Toi Yakube Rahelare hoil ze hiba hibar bafor egena edde Rebekar fut. Toi hibaye dũri giye edde hiyan bafore hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ar Labone hitar boinor fut Yakubor babute funiyore, dũri hibar loi deha goitto giye, edde hibar loi ãzaãzi goijje, edde hibare suma diye, edde hibare hitar górot loi ainne, ar heṛe Yakube hitare in okkol beggun hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Bade Labone hibare hodde, \"Soiyi tui ãr nizor ãḍḍi edde gusto.\" Toi Yakub hitar górot ek maš taikke, ");
INSERT INTO rhg_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","bade Labone Yakubore hodde, \"Tui ãr egena buli ki bina muzoriye ãr ham goribi ne? Tore beton ki diya foribo ãre ho.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labonottu duizon zi ase; ḍõrguwar nam Leah, ar šoṛowar nam Rahela. ");
INSERT INTO rhg_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leattu aššilde šude duwa šundor suk, kintu Rahelar hara ga edde siyara, hár kissu šundor aššil. ");
INSERT INTO rhg_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakube Rahelare muhabbot goitto. Yakube hodde, \"Tũwar šoṛo zi Rahelalla ãi hãt bosor tũwar gulami goijjium.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labone hodde, \"Ãi hibare oinno honokiyore diyattuwaro tor diya iyan ãlla aro bala oibo. Tui ãr hãse tak!\" ");
INSERT INTO rhg_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Toi Yakube Rahelalla hãt bosor gulami goijje, ar hibattu hibar uwore muhabbotor zoriya hinore hibattu šude kissu dinor ḍoil laigge. ");
INSERT INTO rhg_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tarfore Yakube Labonore hodde, \"Ãr din šeš oiye, ehon ãr bou ãre do, ãi zene hiba loi taki fari.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Toi Labone heṛiyar manuš okkol beggunore ekkui fũwati goijje, edde ek hánar entezam goijje. ");
INSERT INTO rhg_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ar hazinna zehon oiye, hite hitar zi Leare loi Yakubor hãse ani diye, toi Yakube hibar loi taikke. ");
INSERT INTO rhg_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labone hitar bandi Zilpare hitar zi Lealla daima hisabe hibare diye. ");
INSERT INTO rhg_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Toi binna zehon oiye dekedde, hiba Leah! Toi Yakube Labonore hodde, \"Tũi in ãr loi goijjode in ki? Ãi Rahelalla tũwar gulami goijjide, no ne? Tũi ãre dúha kene dila?\" ");
INSERT INTO rhg_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labone hodde, \"Foila zormor age šoṛoware biya diya iyan ãrar ei zagar niyom no. ");
INSERT INTO rhg_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tui ei biyar hãt dinna furon gor; bade aro hãt bosor gulamir bodole ãra tore šoṛoware o diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Henot Yakube hendilla goijje, hãt dinna furon goijje, ar Labone hitar zi Rahelare o Yakubor bou oibolla diye. ");
INSERT INTO rhg_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labone hitar bandi Bilhare Rahelalla daima hisabe hibare diye. ");
INSERT INTO rhg_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakube Rahela loi o taikke, ar hibaye Leattuwaro Rahelare beši ador goijje. Ar Yakube Labonor hãse aro hãt bosor gulami goijje. ");
INSERT INTO rhg_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Bade Mabude zehon deikke ze Leare ador no gore, hibaye hibare hamil oi farefan gori diye, kintu Rahela baz oi roiye. ");
INSERT INTO rhg_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah hamil oiye edde ek futore biyaiye. Hibaye hitar nam raikke Ruben, kiyollahoile hibaye hodde, \"Mabude ãr dukkore deikke; ebar ãr šuwamiye ãre hameka ador goribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Hiba abar hamil oiye, edde ek futore biyaiye, toi hibaye hodde, \"Ãre ador no gorede hiyan Mabude funniye, hetolla hibaye ãre iba o diyede.\" Toi hibaye hitar nam raikke Simeon. ");
INSERT INTO rhg_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hiba abar hamil oiye edde ek futore biyaiye, toi hibaye hodde, \"Ebar ãr šuwami ãlloi bazi takibo, kiyollahoile ãi hiballa tin futore zormo diyi.\" Toi hibaye hitar nam raikke Levi. ");
INSERT INTO rhg_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Hiba abar hamil oiye edde ek futore biyaiye, toi hibaye hodde, \"Ebar ãi Mabudore tarif goriyum.\" Toi hibaye hitar nam raikke Ehudah. Tarfore hibar fuwa biya bon oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahelaye zehon deikke ze hibaye Yakubolla hono fuwain no biya, hibar boinor uwore hibattu hingša oiye. Hibaye Yakubore hodde, \"Ãre fuwain do, ar no oile ãi moriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Henot Yakubor gušša Rahelar uwore zoli uiṭṭe edde hodde, \"Ãi ki Allar zagat ne, zibaye tor udorot fól diyare ošikar goijje?\" ");
INSERT INTO rhg_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Toi hibaye hodde, \"So, otiya, ãr bandi Bilhah hibar hãse zo, zene hibaye fuwa biyai ãr kulot de, toi zene ãi hibar duwara oile ãi o ma oi fari.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Toi hibaye hibar bandi Bilhare Yakubore ek bou hisabe diye. Yakube hibar hãse giye, ");
INSERT INTO rhg_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","edde hiba hamil oiye, ar Yakubolla ek fut biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Toi Rahelaye hodde, \"Allaye ãr bisar goijje; hibaye ãr foriyad fuinne edde ãre ek fut diye.\" Hiyanor zoriya hibaye hitar nam raikke Ḍan. ");
INSERT INTO rhg_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bade Rahelar bandi Bilhah abar hamil oiye edde Yakubolla dusora ek futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Toi Rahelaye hodde, \"Allar kutsi loi ãr boin loi kutsi doriyore ãi zitti.\" Hetolla hibaye hitar nam raikke Naftali. ");
INSERT INTO rhg_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Bade Leaye dekedde hibar fuwa owa bon oigiyegoi, hibaye hibar bandi Zilpare loi Yakubore ek bou hisabe diye. ");
INSERT INTO rhg_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Toi Lear bandi Zilpaye Yakubolla ek futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Toi Leaye hodde, \"Ki baggitta!\" Toi hibaye hitar nam raikke Gad. ");
INSERT INTO rhg_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Bade Lear bandi Zilpaye Yakubolla dusora ek futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Toi Leaye hodde, \"Ãi hoto šuki! kiyollahoile zobuti okkole ãre šuki hoibo.\" Toi hibaye hitar nam raikke Ašer. ");
INSERT INTO rhg_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ar gĩyu dade ṭaimot Rubene maṛot giye edde hodun dudim-sara faiye, zinore hite hitar ma Leare ani diye. Rahelaye Leare hodde, \"Tor futor dudim-sarattu ãre olfo desena!\" ");
INSERT INTO rhg_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kintu Leaye hodde, \"Tui ãr zamai hari loiyosde hiyane ki no o, ne? Ãr futor dudim-saragun o loifelaibi ne ki?\" Zuwabe Rahelaye hodde, \"Bala, tor futor dudim-sarar bodole Yakub aijja raitta tor loi takibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Toi Yakub zehon hazinna maṛottu górot aišše, Leaye bare niyoli hibar hãse zai hodde, \"Tũi ãr hãse aiyo, kiyollahoile ãr futor dudim-sara loi tũware bara goijji.\" Toi he raitta Yakube hibar loi taikke. ");
INSERT INTO rhg_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ar Allaye Lear foriyad fuinne, hibaye hamil oiye edde Yakubolla fãs lombor futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Toi Leaye hodde, \"Ãr šuwamire ãi bandi diyide hiyanor enam Allaye ãre diye.\" Toi hibaye hitar nam raikke Issakar. ");
INSERT INTO rhg_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Bade Leah abar hamil oiye, edde Yakubolla so lombor futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Toi Leaye hodde, \"Allaye ãre barik hadiya diye. Ehon ãr šuwamiye ãre šorman dibo, kiyollahoile ãi hiballa so futore zormo diyi.\" Toi hibaye hitar nam raikke Sebulun. ");
INSERT INTO rhg_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Bade hibaye ek zerfuwa biyaiye edde hibar nam raikke Dina. ");
INSERT INTO rhg_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Allaye Rahelar mikka kiyal raikke; hibaye hibar foriyad fuinne edde hamil oi farefan gori diye. ");
INSERT INTO rhg_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Henot hiba hamil oiye edde hibaye ek futore biyaiye edde hodde, \"Allaye ãr šorom loifelaye.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Hibaye hitar nam raikke Yusuf, ar hodde, \"Mabude ãre aro ek fut dok.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ar Rahelattu Yusuf zormo oi bade Yakube Labonore hodde, \"Ãre bidai do, toi zene ãi ãr nizor dešor górot firizai fari. ");
INSERT INTO rhg_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ar ãr bouwain edde fuwain zaralla ãi tũwar gulami goijji, hitarare ãre do, toi zene ãi zai fari; kiyollahoile tũi to zano ãi tũwalla hondilla haṛoni goijji.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Toi Labone hodde, \"Ãi zodi tottu doyar nozor fai taki toile meherbani gori tak, kiyollahoile ãi goni sai zani faijji ze Mabude tor zoriya ãre rahamot goijje.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Hite aro hodde, \"Tore beton hodun diya foribo tui ho, ãi tore diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kintu Yakube hitare hodde, \"Tũi to nize zano ãi tũwalla hondilla ham goijji, ar ãr hatot tũwar zanuwaror zãkor abosta hondilla oiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kiyollahoile ãi aibar age tũwattu ze hom šombotti aššil hin beša beši barigiyegoi, edde ãr zoriya Mabude tũware rahamot goijje, kintu ãr nizor gór okkololla hõtte hamai goriyum?\" ");
INSERT INTO rhg_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Toi Labone fusar goredde, \"Ãi tore ki diyum?\" Yakube hodde, \"Tũi ãre kissu no diyo; ãlla zodi ekkan ham goro, toile ãi tũwar zanuwaror zãk okkolore soraiyum edde hinore saiyum: ");
INSERT INTO rhg_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Aijja ãi tũwar hár zanuwar okkolor mazottu di zaiyum edde hinor butottu šoṛo ḍõr fuṛawala dag asede berasool edde sool, ar hala berasoolor so okkolore aleda gorito sai. Hin oibode ãr beton. ");
INSERT INTO rhg_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tarfore zẽtte tũi ãre beton saibolla hazir oiba, hẽtte ãr soyiye ãr goba dibo. Toi šoṛo ḍõr fuṛawala dag naide hendilla hono berasoolor so zodi ãr zanuwaror zãkor butore fa gile, toile hin ãi suri goijji dora oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labone hodde, \"Sa, toile tor hota mozin hendilla ok!\" ");
INSERT INTO rhg_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Toi Labone hedin sitara faṛa soolgun edde dag asede faṛi sool okkol zedunor uwore dola aššil hin edde hala rongor berasool okkolore aleda goijje edde hinore hitar futaindor hãse zimma diye. ");
INSERT INTO rhg_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ar Labone hite edde Yakubor maze tin dinor fõtor baisa foijjonto bebedan raikke, ar Labonor baki zãk okkolore Yakube lagar sorat roiye. ");
INSERT INTO rhg_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bade Yakube liboni, luš edde armon gasor tottoza kẽsa ḍeila haṛi loiye edde hinor uwore sál tuliyore dag goijje, gasor ḍeila okkolor butoror dola deha zafan goriyore. ");
INSERT INTO rhg_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Toi hibaye he sál tuilla ḍeilagunore zanuwaror zãke fani fiyede zaga okkolot raikke, toi zene zãk okkol fani fito aile hin okkol šuza sarme fore. Zanuwar okkole fani fito aitode šomot zur zaito. ");
INSERT INTO rhg_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ar hine ḍeilagunor sarme zur zaito, edde hine ze so okkol biyaito, hin sitara, ar no oile ḍõr otóba šoṛo dagwala oito. ");
INSERT INTO rhg_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakube soolor so edde berasoolor so okkolore aleda gori rakito, kintu faṛi sool okkolore Labonor boitta sitara edde hala sool okkolor mikka muk firabaito. Ebafe Yakube hiba nizolla ek soolor zãk gori felaiye, edde hinore Labonor zanuwaror zãk loi no miyaito. ");
INSERT INTO rhg_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ar beši šoktiwala zanuwargune zene ḍeilar ḍake zur za, hiyanolla buli fani fiyede zagat maze zanuwar okkolor sarme he ḍeila okkol rakito, ");
INSERT INTO rhg_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","kintu leṛa zanuwar okkol oile sarme no rakito. Henot leṛa zanuwar okkol Labonor, ar šoktiwala zanuwar okkol Yakubor oito. ");
INSERT INTO rhg_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ar ei bafe Yakub kub beši tuwangor oiye edde hibattu zanuwar edde gulam bandi edde ũṭ gada beši oiye. ");
INSERT INTO rhg_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bade Labonor futainde endilla hodde Yakube fuinne, \"Ãrar bafor hár kissu Yakube loifelaiye, ãrar baforgunottu hite ei šombotti okkol goijje.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakube Labonor siyarar mikka kiyal goijje, ar so, Labon Yakub loi agor ḍoilla nai. ");
INSERT INTO rhg_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hetunot Mabude Yakubore hodde, \"Tui tor bafor dešot tor egena okkolor hãse uwafes firizagoi, ar ãi tor fũwati takiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Toi Yakube hóbor defeṛaiye edde Rahelare edde Leare maṛot hibar zanuwaror zãk asede heṛe ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Hitarare hodde, \"Ãi tũwarar bafor siyarar sai buzi faijji ze ãr loi tũwarar baf agor ḍoilla nai, kintu ãr bafor Allah ãr fũwati ase. ");
INSERT INTO rhg_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ar tũwara nize o zanode hota, ãi ãr hár bol šokti diyore tũwarar bafolla gulami goijji. ");
INSERT INTO rhg_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tarfore o tũwarar bafe ãre ṭokaiye edde ehon foijjonto doš bar ãr beton bodol goijje, kintu Allaye hibare ãre hoti goitto no de. ");
INSERT INTO rhg_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Hibaye zodi hoito, 'dagwalagun oibo tor beton,' henot hár zãke dagwala so biyaito; ar zodi hoito, 'sitaragun tor beton oibo,' henot zãke sitara so biyaito. ");
INSERT INTO rhg_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ei bafe Allaye tũwarar bafor zanuwaror zãkgun loifelaiye edde ãre diye. ");
INSERT INTO rhg_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","\"Zanuwaror zãk okkole zurzade musumot ãi ekbar šopponot suk tuli sailam ze sai sool okkolor uwore ze faṛa sool okkol uiṭṭe hin beggun sitara edde ḍõr šoṛo dagwala. ");
INSERT INTO rhg_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tarfore Allar firistaye ãre šopponot hodde, 'Yakub.' Ar ãi hoidde, 'Oto, ãi eṛe asi.' ");
INSERT INTO rhg_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Toi hibaye hodde, 'Tor suk tuli sa, faṛa sool okkol zin zanuwaror zãkor uwore uṛer hin sitara, šoro ḍõr dagwala, kiyollahoile Labone tor loi goredde hin beggun ãi dekki. ");
INSERT INTO rhg_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ãi he Betelor Allah, zeṛe tui ek kúṛar uwore tel ḍali diyore ãr hãse manoš goijjili. Uṭ, tui ehon ei deššanottu niyoli zagoi edde tui zormo oiyosde dešot uwafes firizagoi.'\" ");
INSERT INTO rhg_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Toi Rahela edde Leaye hodde, \"Ãrattu ki ãrar bafor góttu ehono mirazor bag ase ne? ");
INSERT INTO rhg_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Hibaye ki ãrare bidešitta hisabe no goner ne? Hibaye ãrare besifelaiye edde ãralla ze ṭiya diya oil hin hibaye háifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ei šombotti Allaye ãrar bafottu ãra edde ãrar futziyaindolla hari loiyede. Ar hetolla ehon Allaye tũware za kissu hoiye tũi hen goro.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Toi Yakube hibar fuwain edde bouwaindore ũṛor fiṛot tuli diye, ");
INSERT INTO rhg_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","edde hibaye hibar hár zanuwar zãk šoho aro dusora dón šombotti zin Paddan Aramot hamail hin beggun o fũwati loiye, Kenanot hibar baf Isakor hãse zaiboilla. ");
INSERT INTO rhg_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ar zẽtte Labone hitar berasoolor kẽš ãsaibolla gil, Rahelaye hibar bafor góror muttigunore suri goijje. ");
INSERT INTO rhg_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ar Yakube Aramiyo Labonore dúha diye, kiyollahoile Yakube dái zargoide he babute o hoi no za. ");
INSERT INTO rhg_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ar ebafe Yakubor za kissu aššil hin loi hiba hentu dái giyegoi, Fúrat hal farai giye edde Giliyad faharor mikka giye. ");
INSERT INTO rhg_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ar tin din bade Labonore howa oiye ze Yakub dái giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Toi hite hitar egena okkolore fũwati loiyore hãt dinor fõt foijjonto Yakubore lorai loigiye edde Giliyad faharot hibare lot faiye. ");
INSERT INTO rhg_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kintu Allah raitta šopponot Aramiyo Labonor hãse ai hodde, \"Hũšiyar, Yakubore bala horaf kissu no hois.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ar zẽtte Labone Yakub loi dola oiye, hẽtte Yakube Giliyad faharor uwore ṭambu gãijjil, ar Labon edde hitar egena okkole o heṛe ṭambu gãijje. ");
INSERT INTO rhg_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Bade Labone Yakubore hodde, \"Tui in ki goijjos? Tui ãre dúha diyos, ar ãr ziyaingunore larair bondir ḍoilla gori kiyolla loi aiššos? ");
INSERT INTO rhg_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tui nizamot kiyolla dáiyos edde ãre dúha diyos? Tui ãre no hos kiyolla? Toi zene ãi tore kušir sãte gan, tobla edde bina bazaiyore bidai goritam. ");
INSERT INTO rhg_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tui kene ãr nati edde ziyaindore suma dito foijjonto no dili? Tui endilla ham goriyore bekufai goijjos. ");
INSERT INTO rhg_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tũwarar hoti goribar šokti ãr hatot ase, kintu gelde raitta tũwarar bafor Allaye ãre hodde, 'Hũšiyar, Yakubore bala horaf kissu no hois.' ");
INSERT INTO rhg_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ar ehon tor bafor górot zaibolla oitofare tottu foran handedde hetolla tui ai giyosgoide, kintu ãr góror muttigun kiyolla sur goijjos?\" ");
INSERT INTO rhg_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakube zuwabe hodde, \"Ãi ḍorailam, kiyollahoile ãi baffilam, tũi zodi zurgori ãttu tũwar ziyaindore hari loi rakido. ");
INSERT INTO rhg_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tũi zar hãse tũwar muttigun faiba, hitare marifela oibo. Ãr hár zinišfatir butore tũwar hono kissu takile tũwar egena okkolor sarme hin talaš gori loifelo.\" Asole Yakube no zanito ze, Rahelaye hin suri goijje. ");
INSERT INTO rhg_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Toi Labone Yakubor ṭambur butore edde Lear ṭambur butore ar dui bandir ṭambur butore góille, kintu kissu no fa. Bade hite Lear ṭambuttu niyoli aiyore Rahelar ṭambur butore góille. ");
INSERT INTO rhg_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahelaye kintu he muttigun loi zai ũṛor godir butore golai eriyore hibar uwore boi aššil. Labone hibar ṭambur hár zagat ataiye, kintu kissu no fa. ");
INSERT INTO rhg_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahelaye hibar bafore hodde, \"Malik ãi tũwar sarme uṛi tiyai no farir boli tũi gušša no oiyo, kiyollahoile ãttu ehon mašik oiye.\" Hetolla Labone talaši gori bade o he muttigun tuwai no fa. ");
INSERT INTO rhg_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iyanot Yakub naraz oiyore Labonore hosuri diyore hodde, \"Ãr hosuri ki? Ar ãr oinnai o ba ki ze tũi ãre fise fise lorai aiššo? ");
INSERT INTO rhg_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ar ãr hár zinišfati sai tũwar góror hono ziniš faiyo ne? Fai takile tũwar egena okkolor sarme rako, edde hitara ãra duni fokkor bisar gorok. ");
INSERT INTO rhg_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","\"Ei kuri bosor ãi tũwar hãse roiyi, eṛe butore bera sool ba soole hono so nošto no gore. Ar ãi tũwar soolor zakottu hono faṛa sool o no hái. ");
INSERT INTO rhg_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Enki fahari zanuware marifelaiyede hendilla hono zanuwarore o ãi tũwar hãse hono din no ani; edde he hoti ãi nize boššiyi. Ar hono zanuwar suri oigilegoi o hin din ok ba rait ok tũwara ãr hãsottu hotifuron loiyo. ");
INSERT INTO rhg_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ãi dine fuijji ar raitta ṭanḍa faiyi, edde ãr sukottu gum zaitogoi. ");
INSERT INTO rhg_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ei kuri bosor ãi tũwar górot roiyi, tũwar dui ziyolla soiddo bosor, ar so bosor tũwar zanuwarolla gulami goijji. Heṛe butore tũi doš bar foijjonto ãr beton bodolaiyo. ");
INSERT INTO rhg_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ãr bafor Allah, ze Ibrahimor Allah edde Isakor Ḍor zodi ãr fokkiya no oito, toile tui ãre ehon hameka hali hate bidai goitta. Kintu Allaye ãr duk edde ãr hator mehennot deikke, ar hetolla hibaye gelde raitta tũware dõk diyede.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Toi Labone zuwabe Yakubore hodde, \"Ei mayafuwain okkol ãr ziyain, ei fuwain okkol ãr fuwain, ei zanuwaror zãk oilde ãr zãk. Tui zin dehor in beggun ãr. Ehon ãr ei mayafuwain edde hitarattu oiyede fuwaindore ki goriyum? ");
INSERT INTO rhg_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ai, tui loi ãi loi duni zone ekkan wadar sukti gori, ziyan tui edde ãr maze goba oi takibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Toi Yakube ugguwa fattor loiyore faiya ḍoilla gori tiya goraiye. ");
INSERT INTO rhg_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Toi Yakube egena okkolore hodde, \"Tũwara o kissu fattor dola goro.\" Toi hitara fattor ani ugguwa ṭal banaiye, edde beggune hiyanor ḍake há fiya goijje. ");
INSERT INTO rhg_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labone he fattoror ṭalguware nam diye Jegar-Šahaduta, ar Yakube hiyanor nam diye Gal-Ed. ");
INSERT INTO rhg_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Toi Labone hodde, \"Ei ṭal oilde aijja tui edde ãr maze goba.\" Hetolla hiyanore Gal-Ed, ");
INSERT INTO rhg_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ar Mišfa nam raka oil, kiyollahoile hite hodde, \"Ãra ekzon ar ekzonottu dure oiyumde hẽtte Mabude tor edde ãr uwore kiyal rake. ");
INSERT INTO rhg_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Zodi tui ãr ziyaindor loi horaf bebar goros otóba ãr ziyain takite oinno bou biya goros, zodi o hono manuš ãrar fũwati nai, kintu sais, ãi edde tui, ãrar maze Allah oilde goba.\" ");
INSERT INTO rhg_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labone Yakubore aro hodde, \"Ei ṭalguwa edde ei faiyawa, sa, ei tiya goraiya faiya, ziba ãi edde tor maze ãi buwailam. ");
INSERT INTO rhg_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ei ṭal oilde ek goba edde faiya oilde ek goba, ze ãi ei ṭal farai tor hoti goitto no zaiyum, ar tui o ei ṭal edde faiya farai ãr hoti goitto no aibi. ");
INSERT INTO rhg_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibrahimor Allah edde Nahuror Allah edde hitarar bafor Allaye ãrar bisar gorok.\" Toi Yakube hibar baf Isakor Ḍor loi ek hosom háiye. ");
INSERT INTO rhg_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Bade Yakube he faharot ek kurbani diye edde hibar egena okkolore ek hánar dawat diye. Toi hitara hána háiye edde hitara heṛe rait haṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Bade Labone binna sore uṛi nizor nati edde ziyaindore suma diye edde duwa goijje. Tarfore hite hentu giyegoi edde górot firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ar Yakube o nizor baisar uzu giye, edde Allar firista okkole hibar loi aiyore deha oiye. ");
INSERT INTO rhg_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Hitarare dekiyore Yakube hodde, \"Itara Allar fouz okkol!\" Hetolla he zagar nam diye Mahanaim. ");
INSERT INTO rhg_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ar Yakube hibar ãgottu hóborguwa okkolore Seir elehat Edom maṛot Išor hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakube hitarare šikai diye, \"Tũwara ãr malik Išore hoiye boli hoiba: 'Tũwar gulam Yakube hoiye: ãi Labonor hãse forbaš haiṭṭi edde etodin foijjonto heṛe aiššilam. ");
INSERT INTO rhg_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ãttu goru gada sool berasool edde gulam edde bandi ase. Ar ãi ãr malike bala nozore saibo ei aša loi ãi ei hóborgan tũware hãse defeṛair.'\" ");
INSERT INTO rhg_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ar hóborguwa okkol Yakubor hãse firi aišše, hitara hodde, \"Ãra tũwar bái Išor hãse gilam, ar hibaye o tũware fũwati sair šot manuš loi saito aiyer.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Toi Yakube beši ḍoraye edde dilot ouskus oiye, ar hibar fũwati aššilde hitarare edde hibar goru edde berasoolor zãk okkol, ũṭ okkolore dui grup goijje. ");
INSERT INTO rhg_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Toi hibaye hodde, \"Iše zodi aiyore ek dolore hamela gore, ar ek dol ziba basi takibo hiba dái zaigoi faribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Toi Yakube hodde, \"Oh Mabud, ãr fordada Ibrahimor Allah, ãr baf Isakor Allah, tũi zibaye ãre hoila, 'Tor dešot tor egena okkolor hãse tui firizagoi, ãi tor balai goijjium.' ");
INSERT INTO rhg_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tũwar ei gulamor mikka ze hár rahamot edde imandari dehayo, hin hono kissur laikka ãi no, kiyollahoile uggwa hator laṛi loi ei Zordan farailam, kintu ehon ãttu dui dol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Aroz gori, ãr bái Išor hatottu ãre uddar goro, kiyollahoile ãi hitare ḍorai, ar zodi hite aiyore ãre edde ma-fuwaindore marifele. ");
INSERT INTO rhg_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ar tũi to hoila, 'ãi tore balai goriyum edde tor bongšore doriyar balur renir ḍoilla beši goriyum, zin goni šeš gora no zaibo.'\" ");
INSERT INTO rhg_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Toi Yakub he raitta heṛe rait haṛaiye, ar hibattu aššilde hinottu ek hadiya hisabe hibar bái Išolla loiye: ");
INSERT INTO rhg_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Dui šot sai sool edde kuriwa faṛa sool, dui šot miyala berasool edde kuriwa modda berasool, ");
INSERT INTO rhg_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","so šoho dud dede hendilla tirišwa ũṭ, sališwa gai goru edde došwa bolod goru, ar kuriwa gadi edde došwa modda gada. ");
INSERT INTO rhg_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Bade hibaye hinore ek ekzon gulam okkolor hatot diye, toi hibar gulam okkolore hodde, \"Tũwara ãr agottu farai zogoi, ar zãkor maze maze hoddur dur zaga farot raikko.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Bade hibaye foila zãkor hitare hokum diye: \"Ãr bái Iš zodi tui loi deha o, edde fusar gore, 'Tui har gulam, hoṛe zodde, edde tor sarme asede in har?' ");
INSERT INTO rhg_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Toi tui hoibi, 'In tũwar gulam Yakubor, inore ek hadiya hisabe ãr malik Išor hãse faṭa oiye, so, hiba o ãrar fisottu ase.'\" ");
INSERT INTO rhg_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Hibaye, dusora, tisera, edde aro oinno zara zãk loi zat aššil, hitara beggunore o hokum diye: \"Iš loi deha oile tũwara o ekkui bafe ei hota hoiba. ");
INSERT INTO rhg_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tũwara aro hoiba, 'So, tũwar gulam Yakub ãrar fisottu ase.'\" Haron hibaye hodde, \"Ãi ãr age ei hadiya okkol defeṛaiyore hibare šanto goijjium; toi bade ãi hibar siyara saiyum, oitofare hibaye ãre gosibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Toi hadiyagun hibar sarmottu fargora oil, kintu hiba nize he raitta dolor fũwati rait haṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bade hiba he raitta uiṭṭe edde hibar dui bou, dui bandi edde hibar egaro futore loiye edde Jabbok gáṭ bai faraiye. ");
INSERT INTO rhg_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Hibaye hitarare hal fargorabai bade hibaye hibattu aššilde hár kissure far gorabaiye. ");
INSERT INTO rhg_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Toi Yakub heṛe eka roiye, edde ek zone hiba loi binna dol fohor ofan foijjonto kutsi doijje. ");
INSERT INTO rhg_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kintu Yakubore hõṛai no farede dekiyore hibaye Yakubor kiyailor sunuti sai hamela goijje, ar henot hibar loi kutsi dorat Yakubor kiyailor sunuti zurattu niyoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Toi hibaye hodde, \"Binna dol fohor oiye, ebar ãre eride.\" Kintu Yakube hodde, \"Ãre rahamot no goro foijjonto ãi tũware zaito no diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Toi hibaye hodde, \"Tor nam ki?\" Hibaye hodde \"Yakub.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Toi hibaye hodde, \"Tore ar Yakub ḍaka no oibo, Israil ḍaka oibo, kiyollahoile tui Allah edde manuš loi zuddo goijjos edde tui zittos.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Hetunot Yakube fusar goredde, \"Meherbani gori, õnor namman ho.\" Kintu hibaye hodde, \"Ãr nam kiyolla fusar goror?\" Toi hibaye hibare rahamot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Toi Yakube he zagar nam raikke Peniel, edde hodde, \"Kiyollahoile ãi Allare sarma sarmi oi dekilam, tarfore o ãr foran baisse.\" ");
INSERT INTO rhg_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Bade hiba Peniel farai giyegoide šomot beil uiṭṭe edde hibar kiyailor sunutilla buli lenga šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Etolla iyan ehono foijjonto endilla ze Israili okkole kiyailor sunutir uwore ze gusto ase hin no há, kiyollahoile Yakubor kiyailor sunutir gusto sai hamela gora oil. ");
INSERT INTO rhg_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Bade Yakube suk tuli saiye, ar so, Iš aiyer edde hibar fũwati sair šot manuš ase; hetunot hibaye fuwaingunore Leah, Rahela edde dui bandir hãse bag gori diye. ");
INSERT INTO rhg_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ar hibaye age bandi edde hitarar fuwaindore agottu diye, tarfore fisottu Leah edde hibar fuwaindore, bade šešottu Rahela edde Yusufore diye. ");
INSERT INTO rhg_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ar hiba nize hitarar agottu giye edde meṛit hãt bar mata niyuraiyore ijjot gori gori hibar báiyor hãse hazir oiye. ");
INSERT INTO rhg_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Toi Iše Yakubor loi dola oibolla dũri aišše edde Yakub loi ãzaãzi goijje, edde golat dori suma diye, ar hitara hainde. ");
INSERT INTO rhg_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Bade Iše suk tuli mayafuwain okkol edde fuwain okkolore deki fusar goredde, tor fũwati itara hontara? Yakube hodde, \"Allar rahamote õnor gulamore ei futziyain okkol diye.\" ");
INSERT INTO rhg_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Toi bandi okkol edde hitarar fuwain okkole sarme zaiyore Išore mata niyuraiyore ijjot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Bade Leah edde hibar fuwain okkole sarme aišše edde mata niyuraiyore ijjot goijje. Ar šešottu Yusufe edde Rahela sarme giye, ar hitara o mata niyuraiyore ijjot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Toi Iše hodde, \"Ãi ze dol okkol dekilam in kiyolla?\" Hibaye hodde, \"In ãr malikor nozorottu doya faibolla.\" ");
INSERT INTO rhg_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kintu Iše hodde, \"Ãttu beši ase, oh bái. Tottu zin ase hin tottu takok.\" ");
INSERT INTO rhg_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakube hodde, \"No, ãi foriyad gori hoir, zodi ãi tũwar nozorottu doya faiyide o, toile tũi ãr ei hadiya goso, kiyollahoile ãi tũwar muk sa ãlla hiyan ãi Allar siyara saiyifan, ze tũi ãre kuši mone goisso. ");
INSERT INTO rhg_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Meherbani gori tũwar hãse ana oiyede ei hadiyagun goso, kiyollahoile Allaye ãre rahamot goijje, edde ãttu hár kissu ase.\" Ar Yakube beši foriyad goijje buli Iše hin goisse. ");
INSERT INTO rhg_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Toi Iše hodde, \"Aio, ãra baisa di edde zai, ar ãi tor agottu zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakube hodde, \"Ãr malike to zano, ei fuwain okkol aizo gura, ar dudor sai sool edde faṛi berasool edde goru in okkololla o ãttu bafa foribo, ekdin o zodi itarare zoltigori loigile zanuwaror zãk okkol beggun morizaiboi. ");
INSERT INTO rhg_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hetolla foriyad gorir, oh ãr malik, tũi tũwar gulam okkolore loi age zogoi, ar ãi ãr malikor hãse Seirot no fõsigoi foijjonto sarmor zanuwaror zãk edde fuwain okkolor ãṛar goti buzi aste aste aiššum.\" ");
INSERT INTO rhg_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Hetunot Iše hodde, \"Toile ãr fũwati asede hentu manuš hodunore tor hãse raki zaito de.\" Yakube hodde, \"Hin kiyolla? Ãr malikor hãsottu ãi doya faiyi iyan ãlla beši.\" ");
INSERT INTO rhg_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Toi Iše he din Seiror mikka hibar baisar uzu firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ar Yakube baisa di Sukkotot zai nizolla gór edde zanuwar okkololla ho ekkan ura bainde, hetolla he zagare Sukkot ḍaka oiye. ");
INSERT INTO rhg_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ar Yakub Paddan Aramottu niyoli aiyore hiba aramor sãte Kenanor Šekim šohorot aišše edde šohoror barkule ṭambu maijje. ");
INSERT INTO rhg_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Bade hibaye ze zagat ṭambu gãijje hiyanore ekšot rufar foiša diyore Šekimor baf, Hamoror futaindottu kini loiye. ");
INSERT INTO rhg_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Heṛe hibaye ekkan kurbangah tuille edde hiyanore El-Elohe Israil nam diye. ");
INSERT INTO rhg_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ar Lear zi Dina, zare hibaye Yakubolla biyail, hibaye dešor mayafuwain okkol loi dola oibolla baire gil. ");
INSERT INTO rhg_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ar he elehar šašon goroya, Hibbi Hamoror fut Šekime hibare deikke, hite hibare loi zaiyore hiba loi neiṭṭe edde hibar ijjot hani goijje. ");
INSERT INTO rhg_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ar hitar dil Yakubor zi Dinar uwore foijje; hite hibare ador goijje edde hibar loi ador muhabbotor hota okkol hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Toi Šekime hitar baf Hamorore hodde, \"Ei mayafuware ãr bou hisabe ani do.\" ");
INSERT INTO rhg_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakube fuinne ze hite hibar zi Dinar ijjot hani goijje, ar hibar futain okkol zanuwaror zãk loi maṛot aššil; hetolla Yakube hitara górot firi no aiye foijjonto nizam mari taikke. ");
INSERT INTO rhg_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Bade Šekimor baf Hamor šohorottu niyoli zai Yakub loi hota hoito aišše. ");
INSERT INTO rhg_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ar Yakubor futain okkole oi hóbor funi mottor hitara maṛottu firi aišše, ar hitarar dile beši duk faiye edde guššaye oin oiye, kiyollahoile Yakubor ziyor ijjot hani goriyore Šekime Israilor loi ekkan ofomanor ham goijje, ziyan hitattu muṭe o goron nuwaššil. ");
INSERT INTO rhg_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kintu Hamore hitarare hodde, \"Tũwar he ziyor uwore ãr fut Šekimor foran fori taikke. Meherbani gori hitalla hibare hitar bou hisabe do. ");
INSERT INTO rhg_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ar ãrar loi biya dola goro, tũwarar ziyain okkolore ãrare do, ar ãrar ziyain okkolore tũwaralla lo. ");
INSERT INTO rhg_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tũwara ãrar fũwati bošoti goro; deš tũwarar sarme fori roiye, tũwara eṛe šodori goro edde dón šombottir malik o.\" ");
INSERT INTO rhg_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ar Šekime Dinar baf edde báiyaindore hodde, \"Ãr mikka tũwara rahamotor nozore so, ar tũwara ãttu ziyan saiba ãi hiyan diyum. ");
INSERT INTO rhg_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ei bouwor mohorana edde hadiya tũwara zedun dabi goitto so goro, tũwara hodde mozin ãi diyum, to ei zuwan mayafuwaware bou hisabe do.\" ");
INSERT INTO rhg_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Šekime hitarar boin Dinar ijjot hani goijjilde hetolla, Yakubor futainde hitare edde hitar baf Hamorore dúha loi zuwab diye. ");
INSERT INTO rhg_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Hitara hitarare hodde, \"Ãra ei ham gori no faijjum, ekzon azomi agoraiya manušore ãrar boinore diya iyan ãralla ekkan beši šoromor ham oibo. ");
INSERT INTO rhg_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Bolke ei ekkan ham gorile ãra tũwarar loi razi oi fariyumde: tũwara o zodi ãrar ḍoilla, tũwarar furuš okkole azomi gorao, ");
INSERT INTO rhg_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","toi ãra tũwarare ãrar ziyaindore diyum, ar tũwarar ziyaindore o ãralla loiyum, ãra tũwar fũwati bošoti goijjum edde ek zati oiyum. ");
INSERT INTO rhg_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ar zodi ãrar hota no funo edde azomi goraiya no o, toile ãra ãrar ziyore loi zaiyumboi.\" ");
INSERT INTO rhg_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hitarar hota Hamor edde hitar fut Šekimor nozorot bala laigge. ");
INSERT INTO rhg_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Toi ei zuwan ze hitar bafor góror beši ijjotwala, hite hitara hoiyede hiyan furon goitte deri no gore, kiyollahoile Yakubor ziyor uwore hitattu beši mon foijje. ");
INSERT INTO rhg_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Bade Hamor edde hitar fut Šekime hitarar šohor geiṛot aišše, ar hitara šohoror manuš okkol loi hota hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hitara hodde, \"Ei manušgun ãra loi šanti, itarare ei dešot bošoti goitto do edde šodori goitto do, dešot to hitaralla o bout zaga ase. Ãra hitarar ziyaindore ãralla bouwain hisabe loi, ar ãrar ziyain okkol hitarare di. ");
INSERT INTO rhg_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kintu ei ekkan ham gorile manuššune ãrar fũwati bošoti goribo edde ek zati oibo. hiyan oilde zodi ãrar fotti furuše hitarar ḍoilla azomi goraiya oi. ");
INSERT INTO rhg_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ar hitarar zanuwaror zãk edde hitarar dón šombotti edde hár kissu ki ãrar no oibo ne? Hetolla aiyo ãra hitarar hotat razi oi, toi hitara ãrar fũwati bošobaš goribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ar he šohor geiṛot gilde hár manuš okkole Hamor edde hitar fut Šekimor hota fuinne, toi šohoror hár furuš okkolore azomi gora oiye. ");
INSERT INTO rhg_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tin din bade zẽtte hitarattu biš oiye, Dinar báiyain Yakubor dui fute Simeon edde Leviye hitara zar zar toluwar loi zai baza sara šohorot hamela goijje, hár furuš okkolore marifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hitara Hamor edde hitar fut Šekimore toluwar loi haṛifelaiye bade hitara Dinare Šekimor górottu bair goijje edde niyoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakubor futainde mora okkolor heṛe aišše edde šohor luṭfat goijje, kiyollahoile hitara itarar boinor ijjot hani goijjil. ");
INSERT INTO rhg_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Hitarar goru, sool edde gada, aro za kissu šohoror butore edde maṛot aššil hin beggun itara loiainne. ");
INSERT INTO rhg_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ar hitarar hár gura fuwain edde hitarar hár bouwain okkolore bondi goriyore, hitarar hár šombotti edde góror hár kissu luṭ goijje. ");
INSERT INTO rhg_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Toi Yakube Simeon edde Levire hodde, \"Tũwara ei dešor bašinda Kenaniyo edde Perišiyo okkolor hãse ãttu bašfuṛefan goijjo edde ãre bifodot felaiyo. Ãttu manuš hom, ar hitara zodi ãr berudde ekottro oiyore ãre hamela gore, ãi edde ãr góror gušṭi ṭiya dongšo oiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ar hitara hodde, \"Ãrar boinore hite beiššar ḍoil bebar kiyolla goijje?\" ");
INSERT INTO rhg_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Bade Allaye Yakubore hodde, \"Uṭ, Betelot zaiyore heṛe bošoti gor, ar tui tor bái Išor sarmottu dáigiligoide ṭaimot ze tore deha dil, heṛe he Allalla ekkan kurbangah tiyar gor.\" ");
INSERT INTO rhg_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Toi Yakube hibar foribar okkol edde hibar fũwati zara aššil beggunore hodde, \"Tũwarar hãse ze hár bezatir mutti okkol ase hinore dur goro, tũwara paksaf o edde hoor bodolo. ");
INSERT INTO rhg_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ar ãra uṛi, Betelot zai, ar ze ãr mosibotor dinot ãre zuwab diye edde ze ãi zeṛe giyi ãr fũwati taikke ãi he Allalla heṛe ekkan kurbangah tiyar goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Toi hitarar hatot aššilde hár bezatir mutti okkol edde hanor guwana okkol beggun hitara Yakubore diye, edde Yakube hinore Šekimot elun gasor tolat gãraifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tarfore hitara hentu baisa diye, ar heṛiyar sairo mikkar šohoror okkolot Allar torfottu ḍor lami aišše, hetolla Yakubor futaindore honokiye fisottu lorai no za. ");
INSERT INTO rhg_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakub edde hibar fũwati aššilde beggune Kenan dešot Lušot (ziyan Betel) aišše. ");
INSERT INTO rhg_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Heṛe hibaye ekkan kurbangah tiyar goijje, edde he zagar nam diye El-Betel, kiyollahoile báiyor hãsottu dáizaibar šomot Allaye Yakubore he zagat deha dil. ");
INSERT INTO rhg_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ar Rebekar daima, Deborah entehal oiye edde Betelor baire elun gasor tole dohon gora oiye, hetolla he zagar nam diya oiye Allon Bakuth (handibar-elun gas). ");
INSERT INTO rhg_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakube Paddan Aramottu aizaigoi bade Allaye hibare abar deha diye edde rahamot goijje. ");
INSERT INTO rhg_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allaye hibare hodde, \"Tor nam Yakub, kintu tore ar Yakub no ḍaka no oibo. Tor nam oibo Israil;\" ar hibaye hibar nam raikke Israil. ");
INSERT INTO rhg_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Toi Allaye hibare hodde, \"Ãi Allah, he Šorbo-Šoktiwala; fólwala o edde bari uṭ. Tor butottu ek zati, oi, bout zati okkol aibo, ar tor bongšottu badša okkol oibo. ");
INSERT INTO rhg_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ze deš ãi Ibrahim edde Isakore dilam hiyan ãi tore o diyum, ar tui bade tor bongšore diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Toi Allah hibar hentu uwor mikka uṛi giyegoi, zeṛe hibaye hiba loi hota hoil hentu. ");
INSERT INTO rhg_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Toi Yakube ze zagat hibaye hibar loi hota hoiye hiyanot ugguwa fattoror faiya buwaiye, toi hibar uwore šoraf edde tel ḍaille. ");
INSERT INTO rhg_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Allaye ze zagat hiba loi hota hoil Yakube he zagar nam raikke Betel. ");
INSERT INTO rhg_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Tarfore hitara Betelottu baisa diye edde Efratot gólite ehono hoddur dure ase, hen šomot Rahelaye ek fuwa biyaiye, ar hibattu fuwa halasi oite beši hošṭo oil. ");
INSERT INTO rhg_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Hibaye fuwa biyar biš zehon aro beši oiye, hibar daimaye hibare hodde, \"No ḍorais, ebar o tottu ek fut oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kintu hiba šeš niyaš felai mori zargoide šomot, hibaye hibar futor nam raikke Ben-Oni, kintu hitar bafe nam raikke Benyamin. ");
INSERT INTO rhg_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Toi Rahela mori giyegoi, edde Efrator (ziyan Betlehemor) fõtor hãsat hibare dohon gora oiye. ");
INSERT INTO rhg_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakube hibar hoboror uwore ugguwa fattor faiya buwaiye, ar hiyan ehono foijjonto Rahelar hoboror faiyar sinno ase. ");
INSERT INTO rhg_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Tarfore Israile baisa diye edde Migdol Edaror oḍakottu ṭambu gãijje. ");
INSERT INTO rhg_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israil he dešot bošobaš goredde ṭaimot, Rubene zai hitar bafor bandi bou Bilhah loi gum giye, ar Israile hiyan fuinne. Yakubottu baro fut aššil. ");
INSERT INTO rhg_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lear futain okkol oilde: Yakubor foila zormo Ruben, Simeon, Levi, Ehudah, Issakar edde Sebulun. ");
INSERT INTO rhg_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahelar futain okkol oilde: Yusuf edde Benyamin. ");
INSERT INTO rhg_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahelar bandi Bilhar futain okkol oilde: Dan edde Naftali. ");
INSERT INTO rhg_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lear bandi Zilpar futain okkol oilde: Gad edde Ašer. ");
INSERT INTO rhg_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Bade Yakube Mamre Kiryat-Arbat (hiyan oilde Hebronot) ze zagat Ibrahim edde Isak takito heṛe hibar baf Isakor hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak ekšo aši bosor basi aššil. ");
INSERT INTO rhg_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Tarfore hiba šeš niyaš felaiye edde morigiyegoi. Hiba furafuri zibon haṛaiyore edde bura boyošot entehal goriyore hibar fordada okkolor loi dola oiyegoi. Ar hibar futain Iš edde Yakube hibare dohon goraiye. ");
INSERT INTO rhg_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","In oilde Išor (mani Edomor) bongšor kahani. ");
INSERT INTO rhg_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iše Kenanor ziyain okkolore hibar bouwain hisabe loilde oilde: Hetittiyo Elunor zi, Adah, Hibbi Šibiyonor natini edde Anar zi, Oholibamah, ");
INSERT INTO rhg_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ar Ismailor zi edde Nebayotor boin Bašemat. ");
INSERT INTO rhg_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ar Išolla Adaye Eliphazore, Bašmathe Reuelore, ");
INSERT INTO rhg_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamaye Jeušore, Jalamore edde Korare biyaiye. Itara aššilde Išor futain okkol, zarare hiballa Kenanot zormo dil. ");
INSERT INTO rhg_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Bade Iše hibar bouwain, futain edde hibar góror hár kiyore, ar hibar goru sool edde hibar hár zanuwar okkol edde Kenan dešot hamaiyede hár kissure loiyore hibar bái Yakubottu dure ar ekkan dešot hãr oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Hitarar šo šombotti eto beši aššil, hitara ekku fũwati taki no fare; hitara bidešitta hisabe takitode he zaga hiyane hitaralla fodai gori no fare, kiyollahoile hitarattu beši zanuwar zãk okkol aššil. ");
INSERT INTO rhg_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Hetolla Iše (mani Edome) Seiror fahari elehat bošobaš goijje. ");
INSERT INTO rhg_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","In oilde Seiror fahari elehat asede Edomiyo okkolor fordada Išor bongšo kahani. ");
INSERT INTO rhg_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","In oilde Išor futaindor nam okkol: Eliphaz, Išor bou Adar fut, ar Ruyel, Išor bou Bašemator fut. ");
INSERT INTO rhg_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphazor futain okkol: Teman, Omor, Zepho, Gatam edde Kenaz. ");
INSERT INTO rhg_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ar Timnah ze Išor fut Eliphazor bandi bou, hibaye Eliphazolla Amalekore zormo dil. In okkol aššilde Išor bou Adar natiyain okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","In okkol oilde Reuelor futain okkol: Nahath, Serah, Šammah edde Mizzah. In okkol aššilde Išor bou Bašemator natiyain okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ar Šibiyonor natini edde Anar zi, Išor bou Oholibamar futain okkol oilde in okkol, zarare hibaye Išolla biyaiye: Zeuš, Zalam edde Korah. ");
INSERT INTO rhg_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","In okkol aššilde Išor bongšor sordar okkol: Išor foila zormo Eliphazor futain okkol: Sordar Teman, Omor, Sefu, Kenaz, ");
INSERT INTO rhg_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatim edde Amalek. In okkol aššilde Edomor Eliphazor bongšottu; hitara oilde Aadar natiyain okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ar Išor fut Reuelor futain okkol: Sordar Nahath, Serah, Šammah edde Mizzah. In okkol aššilde Edomor Reuelor bongšottu; hitara aššilde Išor bou Bašemator natiyain okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ar itara oilde Išor bou Oholibamar futain okkol: Sordar Zeuš, Zalam edde Korah. In okkol aššilde Išor bou Anar zi Oholibamar bongšottu sordar okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Itara aššilde Išor (ziba oilde Edom) futain okkol, ar Itara aššilde hitarar sordar okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Itara aššilde Horittiyo Seiror futain okkol, zara he eleha okkolot aššil: Lotan, Šobal, Šibeon, Ana, ");
INSERT INTO rhg_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dišon, Ezer edde Dišan. Edomot Seiror ei futain okkol oilde Horittiyo okkolor sordar okkol. ");
INSERT INTO rhg_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanor futain okkol oilde: Hori edde Hemam, ar Lotanor ek boin oilde Timnah. ");
INSERT INTO rhg_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Šobalor futain okkol oilde: Alvan, Manahath, Ebal, Šefu edde Onam. ");
INSERT INTO rhg_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ar Šibeonor futain okkol oilde: Aiya edde Ana. Ite oilde he Ana, ze bošoti sara elehat hitar bafor gada soradde šomot he gorom fanir nal fail. ");
INSERT INTO rhg_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anar fuwain okkol oilde: Dišon edde zi Oholibamah. ");
INSERT INTO rhg_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ar Dišonor futain okkol oilde: Hemdan, Ešban, Jitran edde Keran. ");
INSERT INTO rhg_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ar Ezeror futain okkol oilde: Bilhan, Zavan edde Akan. ");
INSERT INTO rhg_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ar Dišanor futain okkol oilde: Uz edde Aran. ");
INSERT INTO rhg_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","In okkol oilde Horittiyo okkolor sordar okkol: Lotan, Šobal, Šibeon, Ana, ");
INSERT INTO rhg_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dišon, Ezer edde Dišan. ");
INSERT INTO rhg_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israili okkolore hono badšaye šašon goribar age itara oilde he badša okkol, zara Edomot šašon goijje: ");
INSERT INTO rhg_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beuror fut Belaye Edomot šašon goitto, hitar šohoror nam oil Dinhabah. ");
INSERT INTO rhg_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela mori bade hitar zagat Bozrattu Serar fut Jobabe šašon goijje. ");
INSERT INTO rhg_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab mori bade hitar zagat Temanottu Hušame šašon goijje. ");
INSERT INTO rhg_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hušam mori bade hitar zagat Bedador fut Hadad, ze Muwabor maṛot Midiyaniyo okkolore hõṛaifelail, hite šašon goijje. Hitar šohoror nam oil Avith. ");
INSERT INTO rhg_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad mori bade hitar zagat Masrekattu Samlaye šašon goijje. ");
INSERT INTO rhg_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah mori bade hitar zagat hal hãsar Rehabotittu Šaule šašon goijje. ");
INSERT INTO rhg_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Šaul mori bade hitar zagat Akboror fut Baal-Hanane šašon goijje. ");
INSERT INTO rhg_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ar Akboror fut Baal-Hanan mori bade hitar zagat Hadade šašon goijje. Hitar šohoror nam oil Pai, ar hitar bouwor nam aššil Matredor zi Mehetabel, ze Mesahabor natini. ");
INSERT INTO rhg_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","In okkol aššilde Išor bongšottu sordar okkol, hitarar gušti mozin, hitara takitode zaga mozin, hitarar nam okkol oilde: Timna, Alvah, Jetheth, ");
INSERT INTO rhg_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO rhg_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibsar, ");
INSERT INTO rhg_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel edde Iram. ");
INSERT INTO rhg_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakub Kenan dešot taka šuru goijje, ze dešot hibar baf bidešitta hisabe takkil. ");
INSERT INTO rhg_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","In oilde Yakubor bongšor kahani. Yusuf, ek hõtoro bosojja zuwan, báiyaindor fũwati soolor zãk okkol soraito; hiba gura bafor bouwain Bilhah edde Zilpar futaindor fũwati takito, edde hitarar ku-asaror babute hóbor bafor hãse anito. ");
INSERT INTO rhg_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israile hibar fuwain beggunottuwaro Yusufore beši ador gorito, kiyollahoile hite aššilde hibar bura halor fut; hitare ugguwa lamba kuruta banai dil. ");
INSERT INTO rhg_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Hitarar bafe Yusufore hitarattuwaro beši ador gorede dekiyore, hitare ingša gorito edde hitar loi hono hota šundor gori hoi no farito. ");
INSERT INTO rhg_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Bade Yusufe ek šoppon deikke, edde hin zehon hitar báiyaindore hoiye, hitara Yusufore aro beši ingša goijje. ");
INSERT INTO rhg_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Hibaye hitarare hodde, \"Funo, ãi ekkan šoppon dekki: ");
INSERT INTO rhg_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","So, ãra gĩyũ kũṛat tara bandir, ar so, ãr tarawa uṛi tiyaiye, ar tũwarar taragune ãr tarawar sairo ḍakottu tiyaiyore hibare soida goijje.\" ");
INSERT INTO rhg_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Toi hitar báiyainde hitare hodde, \"Tui ki hãsa ãrar uwore razagiri goribi? Tui ki hãsa ãrar uwore šašon solaibi?\" Hitar šoppon edde hotalla buli hitara hitare aro beši ingša goijje. ");
INSERT INTO rhg_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bade Yusufe aro ekkan šoppon deikke, edde hiyanore hitar báiyaindore hoiye. Hite hodde, \"So, ãi aro ekkan šoppon dekilam, ar so, beile, sande edde egarowa taraye ãre soida goredde dekilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Hite zehon hitar bafore edde báiyaindore hoiye, bafe hitare dõk diye edde hodde, \"Tui in hondilla šoppon dekkili? Ãi, tor ma edde tor báiyain okkol, beggune aiyore ki hãsa tor sarme meṛit soida foijjum?\" ");
INSERT INTO rhg_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Hitar báiyainde hitar loi riš gora šuru goijje, kintu hitar bafe he hota monot rakidiye. ");
INSERT INTO rhg_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ek bar Yusufor báiyainde Šekimot hitarar bafor soolor zãk soraito giye, ");
INSERT INTO rhg_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","toi Israile Yusufore hodde, \"Tor báiyainde Šekimot soolor zãk soradde no ne? Ikka ai, ãi tore hitarar hãse defeṛai.\" Yusufe hodde, \"Oto, ãi aišši.\" ");
INSERT INTO rhg_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Toi bafe hodde, \"Tui zaiyore tor báiyain edde soolor zãkgun ken ase nai sagoi, edde aiyore ãr hãse zanais.\" Toi hibaye hitare Hebronor ḍeilottu defeṛaiye. Yusuf Šekimot fõsiyore, ");
INSERT INTO rhg_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ekzon manuše hitare lot faiye, ar so, maṛot gura fira goredde dekiyore he manušwaye fusar goredde: \"Tui kiyor talaš gorodde?\" ");
INSERT INTO rhg_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufe hodde, \"Ãi ãr báiyaindor talaš goridde, meherbani gori ãre ekka ho, hitara goru sool hoṛe sorar?\" ");
INSERT INTO rhg_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Manušwaye hodde, \"Hitara entu giyegoi. Ãi hitara 'Aio, ãra Dotanot zai' hen hodde funnilam.\" Toi Yusufe báiyaindor talašot Dotanot giye, heṛe hitarar lot faiye. ");
INSERT INTO rhg_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Hitara Yusuf aiyedde durottu loti deikke edde hitarar hãse no fõsibar agottu, hitara hitare marifelaibolla felain goijje. ");
INSERT INTO rhg_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Hitara ekzonore ekzone hodde, \"Oi so, šoppon dekoya aiyer! ");
INSERT INTO rhg_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Aio, ãra hitare mari felai, bade hono ek faṭkuwat felai di, bade hoiyum, hitare hono fahari zanuware hái felaiye. Tarfore hitar šopponor doša ki o saiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kintu Rubene zehon ei hota funniye, hitarar hatottu Yusufore basaito saiye. Hite hodde: \"No, ãra hitare zane mari no felai, ");
INSERT INTO rhg_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","lou no bayo; hitare eṛe bošotisara elehar ei faṭkuwat maze felai do, kintu hitar uwore hat no tuillo.\" Rubene endilla hoiyede oilde Yusufore hitarar hatottu basaibolla edde hitare bafor hãse uwafes firai loizai faribolla. ");
INSERT INTO rhg_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Toi Yusuf zehon báiyaindor hãse fõisse, hitar gat finda aššilde he šundojja lamba kurutawa faṛi kuli loifelaye. ");
INSERT INTO rhg_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Toi hitara hibare dori faṭkuwawat felai diye. Faṭkuwawa hali aššil, ar heṛe hono fani no aššil. ");
INSERT INTO rhg_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tarfore hitara hána haito boišše, hen šomot hitara suk tuli saiye, ar so, Giliyad name ek zagattu ek dol Ismaili šodori goroya aiyer. Hitara ũṛor fiṛot gori kušbo mosolla, rezom edde duf, hin okkol loi Mišor dešot zadde. ");
INSERT INTO rhg_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Toi Ehudaye hitar báiyaindore hodde, \"Báiware marifelaiyore lukai erile ãrar ki lab oibo? ");
INSERT INTO rhg_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Aio, ãra hitare ei Ismaili okkolor hãse besifelai, hitar gat hat no di, kiyollahoile hite to ãrar nizor bái, ek lou-gustor.\" Ar hitar báiyainde he hota fuinne. ");
INSERT INTO rhg_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Toi Midiyaniyo šodori goroya okkol zehon hitarar ḍake aišše, hitara Yusufore faṭkuwattu tuille ṭani tuille edde kuriwa rufar ṭiyar bodole hitare he Ismaili okkolor hãse besifelaiye, ar hitara Yusufore Mišorot loiainne. ");
INSERT INTO rhg_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bade Rubene faṭkuwar ḍake firi giye edde dekedde Yusuf heṛe nai, henot hite nizor hor faiṭṭe, ");
INSERT INTO rhg_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","hitar báiyaindor hãse firi giye edde hodde: \"Fuwawa to nai, ãi hoṛe zaiyum?\" ");
INSERT INTO rhg_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Bade hitara Yusufor kurutawa loiye, ar uggwa soolor so zorgorai he kurutaware louwot buraiye. ");
INSERT INTO rhg_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Toi hitara he lamba kurutaware hitarar bafor hãse defeṛaiye edde hodde: \"Ãra iba faiyi. Tũi bala gori so iba tũwar futor kuruta oi ne naki no?\" ");
INSERT INTO rhg_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Hibaye kurutawa sini faijje edde hodde, \"Iba to ãr futor kuruta, hitare hono fahari zanuware hái felaiye. Yusufore hameka hanhan gorifelaiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Toi Yakube hibar nizor hoor faiṭṭe, kĩyailot salar šoṭ berai bout din foijjonto fuwalla šuk goijje. ");
INSERT INTO rhg_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Hibar hár futain edde ziyainde hibare šantona dito saiye, kintu hiba hono bote šanti no o, aro hodde, \"Ãi šuk goitte goitte ãr fuwar hãse fatalot zaiyumboi.\" Ar bafe futolla handat roiye. ");
INSERT INTO rhg_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ar eṛe Midiyaniyo okkole Yusufore Mišor dešot Feruwanor ofisar okkolor butore Putifar name ekzon fahardar okkolor soddaror hãse besifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","He šomot Ehudah hitar báiyaindor hentu zaigoiyore Odullom farat Hira name ekzonor hãse taka šuru goijjil. ");
INSERT INTO rhg_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Heṛe Ehudaye ek Kenaniyor zi loi deha oiye, zar nam aššil Šuah. Hite hibare biya gori hibar loi milon oiye; ");
INSERT INTO rhg_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ar hiba hamil oiye edde ek futore zormo diye, zare nam diye Er. ");
INSERT INTO rhg_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tarfore hiba abar hamil oiye edde ek futore zormo diye, hitar nam diye Onan. ");
INSERT INTO rhg_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Hibaye abar ek futore zormo diye edde hitar nam diye Šela. Hite zormo odde šomot Ehudah Kasibot takito. ");
INSERT INTO rhg_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Bade Ehudaye hitar foila fut Erolla bou ainne, ar hibar nam aššil Tamar. ");
INSERT INTO rhg_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kintu Ehudar ei foila fut Mabudor nozorot en horaf aššil; Mabudehitare mari felaiye. ");
INSERT INTO rhg_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Toi Ehudaye Onanore hodde: \"Tor bái-bou loi milon gor edde hibar loi diyoror zimma fura goriyore tor báiyolla bongšo barai tul.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kintu Onane zainto ze, he bongšo hitar nizor no oibo; hetolla hite zetobar hitar bái-bou loi milon goijje, hetobar hite hitar birz baire felai diye. ");
INSERT INTO rhg_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","hitar ze ham goijje hiyan Mabudor nozorot horaf, hetolla Mabude hitare o mari felaiye. ");
INSERT INTO rhg_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Toi Ehudaye hitar futor bou Tamarore hodde: \"Ãr fut Šela zuwan no o foijjonto, tui tor bafor górot zai rari hisabe takgoi.\" Kiyollahoile hite baiffe, \"hitar báiyaindor ḍoilla morizaiboi.\" Toi Tamar hibar bafor górot takibolla giyegoi goijje. ");
INSERT INTO rhg_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Iyar bout din bade Ehudar bou, Šuar zi, mori giyegoi. Ehudaye hiballa šuk gorattu aram oi bade, hitar Odullom farar bondu Hirar fũwati Timnah farat soolor kẽš ãsoya okkolor heṛe giye. ");
INSERT INTO rhg_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Hono ekzone Tamarore hoiye, \"Sa, tor houre hitar soolore kẽš ãsaibolla Timnah fara zar.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Henot hibaye hibar rarir hoor kulifelaiyore mukot guwaṛa diye edde gat hoor beraiyore hiba Enaim golede rastar muk, ziyan Timnah fara za rastat, heṛe boi taikkegoi, kiyollahoile hibaye deikke ze, Šela zuwan oiye, tarfore o kintu hibare hitalla bou no bana. ");
INSERT INTO rhg_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Toi Ehudaye hibare deikke edde hite hiba ek beišša maya fuwa mone goijje, kiyollahoile hibar muk guijja aššil. ");
INSERT INTO rhg_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Toi hite rastar hãsat hibar ḍake giye edde hodde: \"Ai, ãi tor hãse zai\" kiyollahoile hite no zanito ze hiba hitar futor bou. Hibaye: \"Ãr hãse zaito dile tũi ki diba?\" ");
INSERT INTO rhg_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Toi hite hodde: \"Ãi tolla zakottu uggwa soolor so defeṛaiyum.\" Hibaye, \"Hiba no defeṛo foijjonto ki tũi ãr hãse hono kissu bondok hisabe diba ne?\" ");
INSERT INTO rhg_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Hite hodde, \"Ãi tor hãse bondok ki ditam?\" Hibaye hodde: \"Fũta šoho ei silmohor edde tũwar hator ašawa.\" Toi hite hin hibare diyore hibar hãse giye edde hiba hamil oiye. ");
INSERT INTO rhg_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tarfore hiba uiṭṭe edde giyegoi, bade hibaye hibar gũwaṛa loifelaiye edde abar hibar rarir fušak finde. ");
INSERT INTO rhg_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Toi oi mayafuwar hatottu bondok surai anibolla Ehudaye hitar Odullom farar bondur di uggwa soolor so defeṛaiye, kintu hite hibare tuwai no fa. ");
INSERT INTO rhg_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hite heṛiyar manuš okkolottu fusar goijje: \"Enaimor fõtor hãsat ze mondir-beišša aššil, hiba hoṛe?\" Hitara hodde, \"Eṛe heṛiyar hono mondir-beišša nu aiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Toi hite Ehudar hãse uwafes firigiye edde hodde, \"Ãi hibare tuwai no fai, ar heṛiyar mainše o hoiye, 'Eṛe heṛiyar hono beišša mayafuwa nu aššil.'\" ");
INSERT INTO rhg_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Toi Ehudaye hodde: \"Hibar hãse zin ase hin hibaye lok, ar no oilede ãra šormot foriyum, sa, ãi to hiballa ei soolor sowa defeṛailam, kintu tui hibare tuwai no faili.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Onumanik tin maš bade Ehudare howa oiye, \"Tor futor bou Tamar beiššagiri gorer, ar so, hiyanor zoriya hiba ehon hamil\" Ehudaye hodde, \"Hibare baire ano edde hibare furaidifelo.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Hibare baire ana odde šomot, hibaye hibar houror hãse endilla hoi defeṛaiye, \"Ei zinišgun zar, he manušwar duwara ãi hamil oiyi,\" hibaye aro hodde, \"Fũta, silmohor edde laṛi in okkol har so.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ehudaye hinore sini faijje edde hodde, \"Hiba ãttuwaro beši forhesgar, kiyollahoile ãi hibare ãr fut Šelare no di.\" Ar Ehudah dusorabar honodin hibar hãse no. ");
INSERT INTO rhg_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ar hibaye fuwa biyaibar šomoi zehon aišše, ar so, hibar feṛot zoikka fuwain. ");
INSERT INTO rhg_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Hibaye biyadde šomot hitarar butottu ekzone hitar niyolai diye; henot daimaye dori hitar hatot lal rongor fũta bandi di hodde, \"Ite foila niyoli aišše.\" ");
INSERT INTO rhg_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kintu hite hitar hat butore ṭani loifelaye, ar so, hitar bái niyoli aišše, toi hibaye hodde, \"Tui kene band bangi niyoli aili!\" Ar hitar nam raka oiye Perez. ");
INSERT INTO rhg_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Tarfore hitar bái, zar hatot lal rongor fũta banda aššil, hite zormo oiye, hitar nam raka oiye Zerah. ");
INSERT INTO rhg_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ehon Yusufore Mišorot loiza oiye, ar Putifar, ekzon Mišoriyo ze aššil razar hormosarir okkolor butottu ek hormosari, faharadar okkolor boro, hite Ismaili okkol zara Yusufore heṛe ainnil, hitarattu kiniloiye. ");
INSERT INTO rhg_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mabud Yusufor fũwati aššil, ar hibaye hibare kamiyaf goijje, edde hiba hibar Mišoriyo munifor górot roiye. ");
INSERT INTO rhg_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ar hibar munife dekedde Mabud Yusufor fũwati ase, ar hár kissu zin gorer hinot Mabude kamiyafi der. ");
INSERT INTO rhg_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufe hibar munifor bala nozorot foijje edde hitar hãsor šeba goroya oiye. Ar Putifare Yusufore hitar gór edde hitar hár kissur uwore dehašunar bar diye. ");
INSERT INTO rhg_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ar endilla oile, zẽtte oite hite gór edde hitar hár kissur uwore dehašunar bar Yusufore diye, Yusufor zoriya he Mišoriyowar górore Mabude rahamot goijje. Ar Mabudor rahamot Putifaror górot edde ketot, hár kissur uwore oiye. ");
INSERT INTO rhg_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hetolla Putifare hitar hár kissur bar Yusufor uwore diye, šude hite háitode hánagun bade ar hono kissur babute sinta no goitto. Yusuf aššilde sina ṭan edde siyara šundor zuwan, ");
INSERT INTO rhg_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ar hoto din farai zai bade endilla oiye, hibar munifor bouwe Yusufor mikka kiya goijje edde hodde: \"Ai, ãr bisanat ai.\" ");
INSERT INTO rhg_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kintu hiba razi no o edde hibar munifor bouwore hodde: \"So, ãr malikottu ei góror hono kissulla sinta gora no forer; hibar hár kissur bar ãr uwore saridiye. ");
INSERT INTO rhg_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ei górot hiba udda ãttuwaro ḍõr no, hibaye šude tũi bade ar hono kissure mana no gore, kiyollahoile tũi hibar bou. Hen abostat maze ãi ken gori ettor ḍõr ekkan horaf ham goriyore Allar berudde guna gori faijjum?\" ");
INSERT INTO rhg_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hibaye Yusufore hendilla din bade din hendilla howat taikke, kintu Yusufe hibar hãse za otóba hibar fũwati owa hiyanot razi no o. ");
INSERT INTO rhg_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ekdin endilla oiye, Yusuf hibar nizor hame góror butore giye, ar he šomot góror hono gulam goror butore nu aššil. ");
INSERT INTO rhg_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Toi hibaye Yusufor zubba sai doijje edde hodde: \"Ai, ãr bisanat ai!\" Kintu Yusufe hibar zubbawa hibar hatot raki dũri góror bair kule dáigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ar hibaye zehon deikke ze Yusufe zubbawa hibar hatot raki dũri góror bair kule dáigiyegoi, ");
INSERT INTO rhg_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","hibaye hibar góror gulam okkolore ḍaikke edde hodde: \"So, hibaye ei Ibroni manušware ãrar loi tõša goribolla ainne! Ite ãr loi neṛibolla eṛe butore aišše, kintu ãi zure kiskisa maijji. ");
INSERT INTO rhg_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ar hite ãr kiskisani funi hite hitar zubbawa ãr hãse raki dũri baire dáigiyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Toi hibaye Yusufor munif górot nu aiye foijjonto hibar zubbawa hibar hãse raki diye. ");
INSERT INTO rhg_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Bade hibaye hitare ei kahanigan buzaiye, hodde: \"He Ibroni gulam zare tũi ãralla ainno, hite ãr hãse aišše ãr loi tõša goribolla. ");
INSERT INTO rhg_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ar ãi zehon ãi zure kiskisa maijji hite hitar zubbawa ãr hãse raki dũri bair kule dáigiyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yusufor munife hitar bouwor hota, zin hibaye hoiye, \"Endilla ham tũwar gulame ãlloi goijje\" funi guššaye oin oiye. ");
INSERT INTO rhg_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Toi Yusufor munife hibare loizaiyore ziyolot raikke, ze zagat raz bondi okkolore raka oito, heṛe, hiba he ziyolot bondi roiye. Ar Yusuf ziyolot roiyede šomot o, ");
INSERT INTO rhg_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mabud hibar fũwati aššil; ar hibaye Yusufore doya dehaiye edde ziyolaror bala nozorot forefan goijje. ");
INSERT INTO rhg_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Toi ziyolare ziyolot asede hár hodi okkolor bar Yusufor hatot gosaidiye, edde heṛe hitara hár has harbar zin gora oito, hin goroya aššilde hiba. ");
INSERT INTO rhg_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ar hibar hatot zimma aššilde hinor hono kissur mikka ziyolare no saito, kiyollahoile Mabud hibar fũwati aššil, ar hibaye zin gorat aššil, hinore Mabude kamiyaf ofan goitto. ");
INSERT INTO rhg_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Iyar bade zai, Mišoror razar šoraf baṛidoya okkolor maziye edde ruṭibanoya okkolor maziye hitarar malik, Mišoror razar berudde hosuri goijje. ");
INSERT INTO rhg_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Feruwan šoraf baṛidoya okkolor mazi edde ruṭibanoya okkolor mazi, ei dui hormosarir uwore gušša oiye, ");
INSERT INTO rhg_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","edde hitarare faharadar okkolor boror górot, zeṛe Yusufore bondi gori raka oiye, heṛe bondi gori rakkiye. ");
INSERT INTO rhg_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Faharadar okkolor boroye hitarare Yusufor hatot diye, ar Yusufe hitarar kermos goijje. Hitara bout din heṛe bondi taki bade, ");
INSERT INTO rhg_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Razar šoraf baṛidoya edde ruṭibanoya ze duizonore ziyolot raikke, hitara dunizone ekkui raitta ekzone ekkan ekkan šoppon deikke, ar hitarar ek ekkan šopponor ek ekkan mani aššil. ");
INSERT INTO rhg_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tarfordin binna Yusuf hitarar hãse aiyore dekedde, ar so, hitarar nak muk beši andar. ");
INSERT INTO rhg_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Toi Yusufor fũwati Feruwanor ze dui hormosari hibar fũwati hibar munifor górot ziyolot bondi aššil, hitarare hibaye fusar goredde, \"Õnorare saite aijja nak muk eto andar kiyolla lager?\" ");
INSERT INTO rhg_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Hitara zuwab diye, \"Ãra dunizone šoppon dekki, kintu hinor mani buzai dibolla hono kiye nai\" Yusufe hitara dunizonore hodde, \"Mani buzai dibar šokti Allattu no o ne? meherbani gori šoppongun ãre ho.\" ");
INSERT INTO rhg_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Toi oi mazi šoraf baṛidoyaye Yusufore hitar soppongan funaiye, hite hibare hodde, \"Ãr šopponot dekidde, so, ãr muntu ekkan ãngur lota, ");
INSERT INTO rhg_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ar hiyanot tinnwa ḍeila aššil. Ar hinot holi ai mottor ful fuiṭṭe edde hinot tũka tũka oiyore fona ãngur oiye. ");
INSERT INTO rhg_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ar Feruwanor fiyalawa ãr hatot aššil edde ãi he ãngurgun loiyi, hinore Feruwanor fiyalat roš sibi loi fiyalawa Feruwanor hatot dilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufe hitare hodde: \"Iyanor mani oilde endilla, tinnuwa ḍeila oilde tin din. ");
INSERT INTO rhg_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tin dinor butore Feruwane õnore šormane entu eri dibo edde õnor agor hamot õnore uwafes dibo, ar õne age zendilla hibar šoraf baṛidoya aššila, hendilla tũi Feruwanor hatot fiyala tuli diba. ");
INSERT INTO rhg_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kintu zẽtte õnor balai oibo, foriyad gorir õne ãre monot raikko edde ãr uwore doya dehaiyo; ãr babute Feruwanore hoiba edde õne ãre ei górottu niyolaiba. ");
INSERT INTO rhg_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kiyollahoile ãre Ibroni okkolor dešottu sur gori ana oiye, ar eṛe o ãi en hono kissu no gori ze hitarattu ãre gãtot raka fore.\" ");
INSERT INTO rhg_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ruṭibanoya okkolor maziye zehon dekilo ze Yusufe šopponor bala mani hoiye, toi hite Yusufore hodde, \"Ãi o ekkan šoppon dekkilam: So, ãr matar uwore tin ṭuri fiṛa ase. ");
INSERT INTO rhg_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Uoror ṭurit Feruwanolla banaiya hãr ḍoilla hana, ar faik okkole ãr matar uwore ṭurittu hinore hát roiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufe hodde, \"Iyanor mani oilde endilla, tinnuwa ṭuri oilde tinnwa din. ");
INSERT INTO rhg_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tin dinor butore Feruwane õnor holla loibo edde gagan gasot zulai rakibo, ar faik okkole gusto háibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Bade tin dinor din Feruwan zormo dinot, hite hitar hormosari okkololla ek mela goijje. Hite he mazi šoraf baṛidoya edde mazi ruṭibanoyare hormosari okkolor sarme hazir goijje: ");
INSERT INTO rhg_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Hite mazi šoraf baṛidoyaware hitar agor hamot uwafes diye, toi hite abar Feruwanor hatot fiyala tulidiya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kintu he mazi ruṭibanoyare faši diye, zendilla Yusufe hitarare mani bangidil. ");
INSERT INTO rhg_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","He mazi šoraf baṛidoyawaye tarfore o Yusufore monot no rake, hibare foraifelail. ");
INSERT INTO rhg_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dui bosor farai zai bade Feruwane ek šoppon deikke: So, hite Nil doriyar farot tiyaiye, ");
INSERT INTO rhg_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ar so, doriyattu hãttuwa šundor edde boli goru uṛi aišše edde hóir bonot sora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hin bade aro hãttuwa bissiri edde leṛa goru doriyattu uṛi aišše, edde hine farot oinno goru okkolor ḍake tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ar bissiri edde leṛa gorugune he šundor edde boli gorugunore háifelaiye. Toi Feruwan gumottu seton oiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Bade hite abar gumot foijje edde dusora bar šoppon deikke: Ar so, hãttuwa fuiṭṭa edde taza gĩyur sóra ekkan narat gozaiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hin bade aro hãttuwa gĩyur sóra gozaiye, hin hĩṛa edde fukali bataše fúwaigilgoi. ");
INSERT INTO rhg_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ar he hiṛa gĩyur sóra okkole oi hãttuwa fuiṭṭa edde taza sóragunore gilifelaiye. Toi Feruwan gumottu seton oiye. Hite buijjede hin šude šoppon. ");
INSERT INTO rhg_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kintu binna razar monot ouskus oiye. Hite manuš defeṛaiyore Mišoror hár zadugor edde giyani okkolore ḍaki ainne. Feruwane hitar šoppon okkolore hitarare buzaiye, kintu honokiye hinor mani bangidi no fare. ");
INSERT INTO rhg_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Hetunot mazi šoraf baṛidoyaye Feruwanore hodde: \"Aijja, ãr ekkan hosurir hota ãttu monot foijje. ");
INSERT INTO rhg_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Feruwan ekbar hibar gulam okkolor uwore ragigilgoi, edde hibaye ãre edde mazi ruṭibanoyare faharadar okkolor boror górot bondi gori rakkil. ");
INSERT INTO rhg_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ek raitta ãra ekzone ekkan ekkan šoppon dekkilam, ek ekkan šopponor ek ekkan mani aššil. ");
INSERT INTO rhg_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ehon heṛe ek Ibroni zuwan, faharadar okkolor boror gulam ãrar fũwati aššil. Ãra hitare ãrar šoppongun buzailam, ar hite ãrar šoppongun ãrare bangidil, ar zar zar šoppon hitare bangi dil. ");
INSERT INTO rhg_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hite ãrare zendilla mani bangi dil ṭik hendilla goṭṭil: Ãre ãr hamot uwafes diya oil, ar utare faši diya oil.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Henot Feruwane Yusufore ḍaki anibolla defeṛaiye, ar hitara Yusufore toratori ziyolor gãtottu niyolai ainne. Hibaye sul dari hamaiye edde hoor bodoille, bade hiba Feruwanor sarme hazir oiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Feruwane Yusufore hodde, \"Ai ekkan šoppon dekilam, honokiye hiyanor mani bangidi no farer. Kintu ãi funni, tore šoppon funaile tui hiyanor mani bangi di faros.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Toi Yusufe zuwabe hodde, \"Ãi no, Allaye Feruwanore hiba šanti ode zuwab dibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Toi Feruwane Yusufore hodde, \"Ãr šopponot maze, ãi Nil doriyar farot tiyai roiyi, ");
INSERT INTO rhg_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ar so, doriyattu hãttuwa šundor edde boli goru uṛi aišše edde hóir bonot sora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Hin bade aro hãttuwa bissiri edde leṛa goru doriyattu uṛi aišše, ãi endilla bissiri goru okkol Mišorot ãi ar hono din no deki. ");
INSERT INTO rhg_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tarfore he bissiri edde leṛa gorugune foilar boli gorur hãtoware háifelaiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tarfore o hinore saite he boli gorugunore háiyefan no lage, hin agor ḍoilla bissiri taigiyegoi. Hetunot ãi gumottu seton oiyi. ");
INSERT INTO rhg_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","\"Šopponot ãi aro dekilam, hãttuwa fuiṭṭa edde taza gĩyur sóra ekkan narat gozaiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Hin bade aro hãttuwa gĩyur sóra gozaiye, hin hĩṛa edde fukali bataše fúwaigilgoi. ");
INSERT INTO rhg_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ar he hiṛa gĩyur sóra okkole oi hãttuwa fuiṭṭa edde taza sóragunore gilifelaiye. Ãi in zadugor okkolore hoilam, kintu hitara honokiye inor mani ãre hoi no fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Toi Yusufe Feruwanore hodde, \"Feruwanor šoppon duniyan asole ekkan, Allaye ziyan goribo hiyan Feruwanor hãse batelai diyede. ");
INSERT INTO rhg_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","He hãttuwa šundor boli goru mani hãt bosor, ar hãttuwa fuiṭṭa edde taza gĩyur sóra mani o hãttuwa bosor; šoppon oilde ekkan. ");
INSERT INTO rhg_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hin bade ze hãttuwa bissiri edde leṛa goru doriyattu uṛi aišše oilde hãttuwa bosor, ar fukali bataše fuwai gilgoide he hiṛa gĩyur sóra oilde o hãttuwa raṭor bosor. ");
INSERT INTO rhg_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","\"Ai Feruwanore iyan endilla hoilam: Allaye ziyan goribo hiyan Feruwanor hãse dehaiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","So, Mišor agagura hãttuwa beša beši fošol oibode bosor aibo. ");
INSERT INTO rhg_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ar tarbade aibo hãttuwa raṭor bosor. Toi Mišorot beša beši oilde hin forai zaiboi, edde ei raṭe dešore šeš gorifelaibo. ");
INSERT INTO rhg_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ar beša beši oilde hin ar monot no takibo, kiyollahoile hiyar bade ze raṭ oibo, hiba beši boiyanok oibo. ");
INSERT INTO rhg_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Feruwanore dui ḍoilla gori šoppon deha oiyede haron oilde, iyan Allaye faisala gori felaiye, ar Allaye iyan hára goribo. ");
INSERT INTO rhg_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","\"Ar ehon, Feruwane ekzon manuš zuhar goro, ze buddiwala edde giyani, ar hitar uwore Mišorot bar do. ");
INSERT INTO rhg_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Feruwanottu dešolla aro hormosari okkol tula foribo, oi hãt bosorot beša beši oibode hẽtte hitara hinor fãs bagor ek bag tulibolla. ");
INSERT INTO rhg_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Hitarattu ei bala bosor okkolor aiyedde hinor hár haiddo okkole dola gora foribo, ar gĩyu okkol Feruwanor anḍare šohor okkolor haiddo hisabe dola gora foribo edde sõli raka foribo. ");
INSERT INTO rhg_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ei haiddo dešolla zoma raka foribo, toi zẽtte raṛor hãt bosor Mišorot oibo, hẽtte zene raṭe dešore dongšo gori felai no fare.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ei mošora Feruwanor edde hitar hormosari okkol nozorot beggunottu bala laigge. ");
INSERT INTO rhg_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Feruwane hitar hormosari okkolore hodde, \"Endilla ekzon manuš ãra ar hare faiyum, zar butore ase Allar Ruh?\" ");
INSERT INTO rhg_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Toi Feruwane Yusufore hodde, \"In okkol zehon Allaye tore dehaiye, tor ḍoilla buddiwala edde giyani ar honokiye nai. ");
INSERT INTO rhg_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tui ãr razbarir hár kissure solaibi, ar tor mukor hokum ãr hár manuš okkole mani solibo, šude šingašonot ãi tottuwaro ḍõr takiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Toi Feruwane Yusufore hodde, \"Sa, ãi šara Mišoror hár zagar uwore tore buwailam.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Bade Feruwane hitar silmohor-õṛiwa hitar hatottu kuli loi Yusufor hatot findai diye. Hite Yusufore šundor hoor findai diye edde golat ekkan šunar hãr diyai diye. ");
INSERT INTO rhg_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ar hite Yusufore hitar dui lombor gũra garit buwagaraiye. Ar hitara hibar age elan goijje, \"Ãṛu nise goro!\" Endilla gori hite Yusufore Mišoror hár zagar uwore buwaiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Bade Feruwane Yusufore hodde, \"Ãi Feruwan, kintu tor hokum sara fura Mišorot honokiye, no hat tulibo, otóba hãi maribo.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Feruwane Yusufore nam diye Safenat-Paneh, ar On šohoror imam, Putiferar zi Asenatore Yusufore hibar bou oibolla diye. Bade Yusuf Mišor deš guri aibolla niyoli giye. ");
INSERT INTO rhg_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufe Mišoror Feruwanor anḍare hamot góillede he šomot hibar boyoš oilde triš bosor. Toi Yusuf Feruwanor sarmottu niyoli giyegoi edde Mišor zaga beggulla sofor goijje. ");
INSERT INTO rhg_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Toi foilar he hãt bosorot dešot beša beši haiddo oiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mišorot ei hãt bosorot hár haiddo okkolore Yusufe dola goijje edde šohor okkolot mojud gori rakkiye. Ek ekkan šohorot hiyanor sairo ḍakor maṭ okkolor haiddore rakkiye. ");
INSERT INTO rhg_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufe doriyar balu zedun hedun haiddo dola goijje; ar eto beši haiddo oiye hinore ar mafiyore lowa šombob no o, hetolla hibaye mafi lowa bondo gori diye. ");
INSERT INTO rhg_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Raṭor bosor aibar age, On šohoror imam Putiferar zi Asenator feṛottu Yusufor dui fut zormo oil. ");
INSERT INTO rhg_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufe foila futor nam raikke Manessa, ar hodde, \"Kiyollahoile Allaye ãr hár duk hošto edde ãr bafor góror hár kissure foraifelabaye.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Bade dusora futor nam raikke Efraim, ar hodde, \"Allaye ãre hošṭo bugor dešot fólwala goijje.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tarfore Mišorot beša beši haiddo oiyede he hãt bosor šeš oiye, ");
INSERT INTO rhg_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","raṭor hãt bosor šuru oiye, ode ode Yusufe hoilde mozin. Raṭ oinno hár deš okkolot šuru oiye, kintu Mišoror hár zagat haiddo ase. ");
INSERT INTO rhg_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mišorot beggulla bukkor zala šuru oiye, manuš okkole Feruwanor hãse zai haiddolla handahaṛi goijje. Feruwane hár Mišoriyo okkolore hoiye, \"Yusufor hãse zo, ar hibaye tũwarare zen goitto ho hen goro.\" ");
INSERT INTO rhg_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Dešor beggulla ei raṭ sorai foijjil, toi Yusufe gudam gór okkol beggun kulidiye edde Mišoriyo okkolore gĩyu beisse; kiyollahoile Mišorot raṭ beši hora oi uṭṭil. ");
INSERT INTO rhg_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ar hár dešottu Mišorot, Yusufottu gĩyu kinito aišše, kiyollahoile hár zagat raṭ beši hora oil. ");
INSERT INTO rhg_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakube Mišorot gĩyu asede zani fariyore hibaye nizor futaindore hodde, \"Tũwara ekzone ar ekzonor mukor uzu kiya sai taikko?\" ");
INSERT INTO rhg_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Hibaye aro hodde, \"So, ãi Mišorot gĩyu asede fuinni, tũwara heṛe lamat zo edde henttu ãralla gĩyu kini anogoi, zene ãrar basai fari edde no mori.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Toi Yusufor doš báiye Mišorottu gĩyu kinibolla lamat giye. ");
INSERT INTO rhg_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kintu Yakube Yusufor bái Benyaminore hitar báiyaindor fũwati no defeṛa, kiyollahoile hibaye hodde, \"Oitfare hitar uwore hono bifod goṭibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Toi zara gĩyu kinito aišše hitarar fũwati Israilor futain okkol o heṛe aišše, kiyollahoile Kenanot o raṭ oil. ");
INSERT INTO rhg_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ehon Yusuf oiyede dešor šašongoroya, ar iba oilde hiba ze he dešitta okkol beggunore gĩyu bessil. Toi Yusufor báiyain okkol aišše edde hitara hibar sarme meṛir uzu uite foijje. ");
INSERT INTO rhg_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufe báiyaindore deikke edde hibaye hitarare sini faijje, kintu hibaye hitara loi osinor ḍoil goijje edde hora gori hota hoiye, hodde, \"Tũwara hontu aiššode?\" Hitara hodde, \"Kenan dešottu, haiddo kinibolla aššide.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufe báiyaindore sini faijje, kintu hitara Yusufore sini no fare. ");
INSERT INTO rhg_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ar Yusufe hitarar babute ze ze šoppon okkol dekkil, hin okkol hibattu monot foijje; toi hitarare hodde, \"Tũwara spai, dešot uidda zaga hoṛe ase saito aiššode.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Hitara zuwabe hodde, \"No, malik, õnor gulam okkole haiddo kinto aiššede. ");
INSERT INTO rhg_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ãra beggun ekzonor futain ãra šada dilla manuš, spai no.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusufe hitarare hodde, \"No, tũwara dešot uidda zaga hoṛe ase saito aiššode.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kintu hitara hodde, \"Õnor gulam okkol baro bái aššilam, ãra oilamde Kenanor ekzonor futain okkol. Ar šoṛo bái ehon ãrar bafor fũwati ase, ar ekzon nai.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufe hitarare hodde, \"Iyan ãi tũwarare hoiyide hendilla, tũwara spai. ");
INSERT INTO rhg_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ar tũwarare iyan loi forikka gora oibo: Ãi Feruwanor zanor hosom gori hoir, tũwarar šoṛo bái eṛe no aile, tũwara ei zagattu bair oi no fariba. ");
INSERT INTO rhg_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tũwarar ekzonore defeṛao, edde tũwarar he báiyore anao, ar tũwara eṛe bondi tako, ar ei bafe tũwarar hota forikka gora oibo, tũwara hãsa hota hor ne. Zodi no oile, ãi Feruwanor zanor hosom gori hoir, tũwara spai okkol.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Toi hibaye hitarare tin din hazotot rakkiye. ");
INSERT INTO rhg_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tin dinor din Yusufe hitarare hodde, \"Ek ham goro, toi tũwara basi fariba, kiyollahoile ãi Allare ḍorai: ");
INSERT INTO rhg_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tũwara zodi šada dilla manuš o toile tũwarar báiyaindor butottu ekzon hazotot bondi tako, ar baki beggune tũwarar bukalo góror manuš okkololla gĩyu loi zogoi. ");
INSERT INTO rhg_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tarfore tũwara tũwarar šoṛo báiyore ãr hãse ano, toi tũwarar hota formanito oibo, edde tũwara no moriba.\" Toi hitara hendilla goijje. ");
INSERT INTO rhg_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ar hitara ekzonore ekzone hodde, \"Soiyi ãra ãrar báiyor babute hosurbon, kiyollahoile hite ãrar hãse minnoti goijje, edde ãra hitar foranor hošto dekiyore hin no funi; etolla ãrar uwore ei mosibot hazir oiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hetunot Rubene hodde, \"Ãi no ne tũwarare hoilamde, fuwawar berudde guna no goijjo? Kintu tũwara no funo, ar ehon hitar louwor hisab diya forer.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hitara ṭer no ze Yusufe hitarar hota buzi farer, kiyollahoile hibaye hota buzaidoya bebar goijje. ");
INSERT INTO rhg_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Toi hiba hitarar hãsottu dure ator oi zaiyore hainde edde uwafes firi aišše. Toi hiba abar firi aišše edde hitara loi hota hoiye, Ar hitarar butottu Simeonore dori hitarar šaikkat bainde. ");
INSERT INTO rhg_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Bade Yusufe hitarar bosta okkolot gĩyu bori dibolla, ar hitara fotti ek ekzonor ṭiya zar zar bostat ferot dibolla, edde baisalla hána dibolla hokum diye. Toi hitaralla hendilla gora oiye. ");
INSERT INTO rhg_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tarfore hitara hitarar gĩyur bosta okkol hitarar gada okkolor fiṛot loiye edde henttu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ar fõtot rait haṛaibolla taimmede heṛe hitarar butottu ekzone hitar gadare adar dibolla hitar gĩyur bosta kuille. Toi hite bostar mukot hitar ṭiyagun deikke. ");
INSERT INTO rhg_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Henot hite báiyain okkolore hodde, \"So, ãr ṭĩya firaidiye, hin ãr bostar butore.\" Henot ḍore hitarar foran uri giyegoi edde hafi hafi ekzonore ekzone hodde, \"Allaye ãrare in ki goijje?\" ");
INSERT INTO rhg_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bade hitara Kenan dešot hitarar baf Yakubor hãse aišše, edde hitarar uwore zen zen goiṭṭe hin okkol beggun hibar hãse hoi funaiye. Hitara hodde, ");
INSERT INTO rhg_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","\"Ze manušwa he dešor uwore malik, hibaye ãra loi hora bafe hota hoiye, ar ãrare dešor uidda zaga tuwoya spai mone goijje. ");
INSERT INTO rhg_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kintu ãra hibare hoiyi, 'Ãra šada dilla manuš, spai no. ");
INSERT INTO rhg_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ãra baro bái, ek bafor futain, kintu ekzon nai, edde šoṛo bái Kenanot ehon ãrar bafor fũwati ase.' ");
INSERT INTO rhg_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","\"Henot he deš šašongoroya manušwaye ãrare hodde, 'Iyan loi ãi tũwara šada dilla manuš oi ne zani fariyum: Tũwarar ek báiyore ãr hãse raki zo, edde tũwarar bukalo góror manuš okkololla haiddo loizo. ");
INSERT INTO rhg_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ar tũwarar šoṛo báiyore ãr hãse ainno, henot ãi buzifariyum ze tũwara spai no, kintu šada dilla manuš. Toi ãi tũwarar bái tũwarar hãse firai diyum, edde tũwara ei dešot besa kina gori fariba.'\" ");
INSERT INTO rhg_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Toi hitara zẽtte bostattu haiddo ḍaille, ar so, hitara fottizonor bostar butore hitarar fottizonor ṭiyar bunda! Ei ṭiyar bunda okkol hitara edde hitarar bafe deki, beggune ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ar hitarar baf Yakube hodde, \"Tũwara ãre fuwain hara goijjo. Yusuf nai, Simeon o nai, abar Benyaminore loizaito sor. In beggun ãr uwottu guzori zar!\" ");
INSERT INTO rhg_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hetunot Rubene hitar bafore hodde, \"Ãi zodi tũwar hãse itare firai no ani, toile tũi ãr dui futore kun goijjo. Hitare ãr hatot do, ãi hitare tũwar hãse uwafes firai aniyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kintu Yakube hodde, \"Na, ãr fut tũwarar fũwati no zaibo; hitar bái mori giyegoi edde šude hite basi ase. Tũwara ze fõt bai zaiba, heṛe zodi hitar hono bifod o, toile hitar šukke ei fona sule ãre fatalot lamai diba.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ehon o dešot raṭ beši hora. ");
INSERT INTO rhg_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Toi hitara Mišorottu ze gĩyu annil, hin beggun zehon haiya šeš oiye, hitarar bafe hitarare hodde, \"Tũwara abar zo, edde ãralla aro olfo haiddo kini ano.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Toi Ehudaye hibare hodde, \"Kintu he manušwaye ãrare hũšiyari diye edde hoiye, 'Tũwarar bái fũwati no takile tũwara ãr sarme no aiššo.' ");
INSERT INTO rhg_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tũi zodi ãrar fũwati ãrar báiyore zaito do, ãra lamat zaiyum edde tũwalla haiddo kini aniyum. ");
INSERT INTO rhg_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ar zodi no defeṛo, ãra no zaiyum, kiyollahoile he manušwaye ãrare hoiye, 'Tũwarar bái fũwati no takile tũwara ãr sarme no aiššo.'\" ");
INSERT INTO rhg_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Toi Israile hodde, \"Tũwara he manušware tũwarattu ar ek bãi ase hoiyore kiyolla tũwara ãr loi endilla bura ham gorila?\" ");
INSERT INTO rhg_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Hitara hodde, \"Manušwaye ãrar babute edde ãrar foribaror babute zora zori gori endilla hoi fusar goijje. 'Tũwarar baf ki ehono zinda ne? Tũwarattu ki aro ek bái ase?' Ar ãra hibare ei suwal okkol mozin zuwab diyi. Henot ãra ken gori zaniyum ze hite hoibo, 'Tũwarar báiyore eṛe ano?'\" ");
INSERT INTO rhg_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Toi Ehudaye hibar baf Israilore hodde, \"Fuwaware ãr fũwati defeṛo, ãra uṛi edde baisa di, toi zene ãra, tũi edde ãrar fuwain šoho, ãra forane basi edde no mori. ");
INSERT INTO rhg_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ãi nize hitar zabin roilam; hitare tũi ãr hatottu gosi loiyo. Ãi zodi hitare tũwarar hãse uwafes firai no ani toile ãi hara zibon tũwar hãse hosurbon oi takiyum. ");
INSERT INTO rhg_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ãra eto deri no goritam boli etone hameka ãra dui bar zaiyore uwafes ai faittam.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Toi hitarar baf Israile hodde, \"Zodi hen gora fore, toile endilla goro: Manušwalla ek hadiya hisabe tũwarar bosta okkolot dešor nam gora ziniš okkolottu kissu lo, olfo duf, olfo rezom, olfo modu, kušbo mosolla, pistašo dana edde badam. ");
INSERT INTO rhg_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ar tũwara fũwati ḍabol ṭĩya lo, kiyollahoile bostar mukot ze ṭĩya firi aišše, hin firai diya foribo. Oitfare hiyan ekkan hono bul oiye. ");
INSERT INTO rhg_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tũwarar báiyore lo edde zolti he manušwar hãse uwafes zo. ");
INSERT INTO rhg_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Šorbo Šoktiwala Allaye gorok zene he manušwaye tũwarare doya gore, toi hite tũwarar dusora bái edde Benyaminore tũwarar fũwati defeṛa. Ar ãttu zodi fuwain hara owa forile o, fuwain hara oilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Toi manušgunore he hadiya, hatot ḍabol ṭĩya edde Benyaminore loiyore hitara uiṭṭe edde Mišorot lami giye edde Yusufor sarme hazir oiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufe hitarar fũwati Benyaminore dekiyore hibaye hibar gór sõloya ze, hitare hodde, \"Ei manuššunore góror butore loiza, ar ek zanuwar zorgorao edde hanar bondobos goro; itara dũijja ãr fũwati hána háibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Manuššuwaye Yusufe hoilde hendilla goijje, hitarare Yusufor górot loigiye. ");
INSERT INTO rhg_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kintu hitarare Yusufor górot loizarbar, hitara ḍoraiye, ar hitara hodde, \"Agor baror ze ṭĩya ãrar bostat gori firigilgoi hinor befare ãrare eṛe ana oiye. Ehon itara ãrare duš dehai akromon gori faribo. Ãrar gadagun hari loifelaibo edde ãrare gulam banaifelibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Toi hitara Yusufor gór sõloyar hãse giye edde hitar loi goror dorozar ḍake hitar loi hota hoiye, ");
INSERT INTO rhg_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","edde hodde, \"Oh malik, ãra iyar age o ek bar haiddo kinto aiššilam. ");
INSERT INTO rhg_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kintu ãra zẽtte fõtot rait haṛaibolla tiyaiyi, edde ãrar bosta kuilli, ar so, fotti ek ekzon zar zar ṭĩya bostar mukot, ãrar nizor ṭiya furafuri uzon mozin, ar ehon hin ãrar fũwati anni. ");
INSERT INTO rhg_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Hin bade o haiddo kinibolla fũwati ãra aro ṭĩya anni. Ãrar ei ṭiya ãrar bostat hone di rakkil hiyan ãra no zani.\" ");
INSERT INTO rhg_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Toi hite hodde, \"Tũwarar balai ok, no ḍoraiyo. Tũwarar Allah edde tũwarar bafor Allaye tũwarar bostat gayebi dón diyede; tũwarar ṭĩya ãi failam.\" Bade hite Simeonore hitarar hãse ainne. ");
INSERT INTO rhg_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Bade manuššuwaye hitarare Yusufor góror butore ainne, fani diye toi hitara hitarar ṭeng duiye, ar hite hitarar gadagunore adar diye. ");
INSERT INTO rhg_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yusuf dujja aibo boli hitara hadiyagunore tiyar gori raikke, kiyollahoile hitara funnil ze hitarar há fiya heṛe oibo. ");
INSERT INTO rhg_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tarfore Yusuf górot aišše, toi hitara ze hadiya okkol ainne hinore góror butore loi zaiyore hibar sarme raikke edde hitara hibar sarme meṛir uite foijje. ");
INSERT INTO rhg_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Hibaye hitara ken ase he hóbor loi bade hibaye hodde, \"Tũwarar ze burá bafor babute ãre hoila hiba bala ase ne? Hiba ki ehono basi ase?\" ");
INSERT INTO rhg_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Hitara hodde, \"Õnor gulam ãrar baf ehono basi ase, ar hiba ehono basi ase.\" Toi hitara meṛit uite foijje edde Yusufore ijjot dehaiye. ");
INSERT INTO rhg_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ar Yusufe suk tuli saiye edde hibar nizor mar fut, afon bái Benyaminore deikke, \"Ite ne tũwarar he šoṛo bái, zar hota tũwara ãre hoila?\" Ar hibaye hodde, \"Allaye tore rahamot gorok, oh fut!\" ");
INSERT INTO rhg_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Toi Yusufe toratori goijje, kiyollahoile báiyore dekiyore hibar foran hainde. Yusufe ekkan handibar zaga tuwaibolla henttu niyoli giyegoi, ar hiba nizor kamerat góille edde hainde. ");
INSERT INTO rhg_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bade hibaye muk dúi bade abar baire niyoli aišše, edde nizore sõli loi, ar hána bari dibolla hokum diye. ");
INSERT INTO rhg_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Toi hitara hiballa, edde hibar báiyain okkololla, edde hibar fũwati Mišoriyo okkol zara hána hóya, hitara beggunore aleda gori hána bari diya oiye, kiyollahoile Mišoriyo okkole Ibroni okkolor fũwati hafiya no gorito, haron hiyan aššilde hitarar hãse ekkan hingšar ham. ");
INSERT INTO rhg_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusufor sarme báiyain okkolore hitarar boyoš mozin buwaiye. Henot hitara tajjuf oi ekzone oinno zonor uzu sa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufe hitar nizor ṭebilottu kissu kissu hána báiyaindore dibolla bebosta goijje. Kintu oinno báiyain beggunottuwaro Benyaminore fãs gun beši diya oiye. Ar hitara Yusufor fũwati beša beši há fiya goijje edde beši kuši goijje. ");
INSERT INTO rhg_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Tarfore Yusufe hibar gór sõloyare endilla hokum diye: \"Ei manuššune zedun boi loizai fare, hedun gĩyu hitarar bostat okkolot bori do, ar hitara fotti zonor ṭĩya hitara fotti zonor bostar mukot di diyo. ");
INSERT INTO rhg_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ze beggunor šoṛo hitar bostar mukot ãr rufar fiyalawa edde hitar gĩyu kinibar ṭiya di diyo.\" Toi hite Yusufe hoiyede mozin goijje. ");
INSERT INTO rhg_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tarfordin binna fohor zehon oiye manuššunore hitara gadagun loi hentu faṭai diya oiye. ");
INSERT INTO rhg_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Hitara šude šohorottu niyoli beši dure no zaite Yusufe hibar gór sõloyare hodde, \"Uṭ, manuššunore fisottu lorai za, ar tui zẽtte hitare doribigoi, hitarare hoibi, 'Tũwara balair bodole burai ka goijjo? ");
INSERT INTO rhg_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Iba loi no ne ãr munife fiyede edde gonafora gorede? Tũwara iyan ziyan goijjo, ek horaf ham goijjo!'\" ");
INSERT INTO rhg_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Gór sõloyaye hitarare doijjegoi edde he hota okkol hitarare hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kintu hitara hitare hodde, \"Ãr malike endilla hota okkol kiyolla hor? Õnor gulam okkole endilla ham hono din no goribo! ");
INSERT INTO rhg_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","So, ãra bostar mukot ze ṭĩya failam hin ãra Kenan dešottu uwafes tũwar hãse firai anni, hen abostat ãra õnor munifor góror šuna rufa kiyolla sur goriyum? ");
INSERT INTO rhg_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Õnor ei gulam okkol zar hãse iba fazaibo, hite moribo; ar ãra o ãr malikor gulam oiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Toi hite hodde, \"Bala, tũwara hodde mozin oibo; zar hãse fa zaibo, hite ãr gulam oibo, ar baki tũwarar hosuri sara oiba.\" ");
INSERT INTO rhg_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Toi hitara toratori goijje edde ek ekzone hitar nizor bosta meṛit lamaiye, edde zar zar bosta te kuille. ");
INSERT INTO rhg_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Toi hite ḍõr báiyor bostattu loti šuru gori šoṛo báiyor bosta foijjonto tuwaiye. Ar Fiyalawa Benyaminor bostat fa giye. ");
INSERT INTO rhg_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Toi hitara hitarar nizor hor faiṭṭe, edde zar zar bosta gadar fiṛot bandi loi uwafes šohorot firi giye. ");
INSERT INTO rhg_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ehudah edde hitar báiyain okkol Yusufor górot aišše, ar Yusuf hehono heṛe aššil; toi hitara Yusufor sarme meṛit ũite foijje. ");
INSERT INTO rhg_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufe hitarare hodde, \"Tũwara goijjode in ki goijjo? Ãr ḍoilla manuše ze goni fare, hiyan ki tũwara no zano?\" ");
INSERT INTO rhg_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ehudaye hodde, \"Ãr malikore ãra ki hoi faijjum? Ki hota hoiyum? Ãra nidušide hiyan ken gori dehai faijjum? Õnor gulam okkolor hosuri Allaye tuwai bair goijje. So, zar hãse fiyala fa giye hite edde ãra ãr ehon malikor gulam.\" ");
INSERT INTO rhg_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kintu Yusufe hodde, \"Endilla ham ãi hono din gori no faijjum! Zar hãse he fiyala fa giye lehar te ãr gulam oibo. Ar tũwara šanti bafe tũwarar bafor heṛe firizaigoi fariba.\" ");
INSERT INTO rhg_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tarfore Ehudaye Yusufor ḍake zai hodde: \"O ãr malik, foriyad gorir, õnor ei gulamore ekkan hota hoibolla ejazot do. Õnor gulamor uwore gušša no goijjo, õne, Feruwanor fuwainna. ");
INSERT INTO rhg_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ãr malike hibar gulam okkolore fusar goijjila, 'Tũwarar baf bái ase ne?' ");
INSERT INTO rhg_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ar ãra malikore zuwab dilam, 'Ãrattu ek burá baf ase, ar hibattu burá halor ek fut ase; ar hitar bái mora giye, ar hite ekela ek mar ek fut, hitar bafe hitare beši ador gore.' ");
INSERT INTO rhg_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","\"Toi õne õnor gulam okkolore hoila, 'Tũwara hitare eṛe anogoi, ãi hitare niz suke saiyum.' ");
INSERT INTO rhg_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ar ãra ãr malikore hoilam, 'He zuwan bafore eri ai no faribo; hite hitar bafore eri aile, hitar baf mori zaiboi.' ");
INSERT INTO rhg_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kintu õne ei gulam okkolore hoila, 'Tũwarar šoṛo báiyore zodi tũwarar fũwati no ano, tũwara ãr sarme ai no fariba.' ");
INSERT INTO rhg_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Toi ãra õnor gulam ãr bafor górot uwafes zaiyore, ãra ãr malikor hár hota hibare zanailam. ");
INSERT INTO rhg_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","\"Toi ãrar bafe hodde, 'Tũwara abar zo, ãralla hodun haiddo kini anogoi.' ");
INSERT INTO rhg_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ãra hoilam, 'Ãra lamat zai no farir; zodi ãrar šoṛo bái ãrar fũwati take, toile ãra zai faridde, kiyollahoile ãrar šoṛo bái fũwati no takile, ãra manušwar muk sai no faijjum.' ");
INSERT INTO rhg_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Toi õnor gulam, ãrar bafe ãrare hodde, 'Tũwara zano ze ãr bouwe ãlla dui futore biyaiye, ");
INSERT INTO rhg_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","henttu o ekzon ãttu giyegoi, ar ãi hoilam, \"hite hameka hanhan oi giyegoi\" hiyattu loti ãi hitare ar no dekilam. ");
INSERT INTO rhg_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ehon ãttu itare o zodi loizogoi, edde hitar hono bifod goṭe, toile tũwara hitar dukke ei burá boyošot ãre fatalot lamai diba.' ");
INSERT INTO rhg_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","\"Ar ehon, õnor gulam ãr bafor munttu ãi hazir oile, edde fuwawa ãrar fũwati no takile, (zar foranor hitar foran loi gãta), ");
INSERT INTO rhg_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","zuwannuwa ãrar fũwati naide dekile hiba mori zaibogoi, endilla gori õnor gulam okkole õnor gulam ãrar bafore šukke ei burá boyošot fatalot lamai dibo. ");
INSERT INTO rhg_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ar õnor gulam ãrar bafor hãse ãi ei zuwanor zabin oi hoilam, 'Ãi zodi hitare tũwar hãse firai no ani, toile ãi ãr bafor hãse zibonbor hosurbon takiyum!' ");
INSERT INTO rhg_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","\"Hetolla aroz gorir, ei fuwawar bodole ãre õnor gulam hisabe rako, edde ei fuwaware hitar báiyaindor fũwati firi zaito do. ");
INSERT INTO rhg_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ei fuware no loi zaiyore ãi ken gori ãr bafor hãse firizai faijjum? Edde bafor ze bifod goṭibo hin o ken gori sai faijjum?\" ");
INSERT INTO rhg_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Toi Yusuf nizor ḍake tiyat aššilde hitarar sarme nizore ar sõli raki no fare, edde guzori hodde, \"Ãr sarmottu beggunore niyolai do!\" Henot hibar ḍake ar kiye tiyat no aššil. Toi hetunot Yusufe báiyaindor hãse nizor foriso diye. ");
INSERT INTO rhg_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ar hibaye eto ḍõr gori guzori hainde ze Mišoriyo okkole hin funniye, edde Feruwanor góror ma he babute funniye. ");
INSERT INTO rhg_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Bade Yusufe hibar báiyaindore hodde, \"Ãi Yusuf; ãr baf ki ehono basi ase?\" Kintu hibar báiyainde hibare zuwab di no fare, kiyollahoile hitara hibar sarme ḍoraye. ");
INSERT INTO rhg_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufe hibar báiyaindore hodde, \"Meherbani gori tũwara ãr ḍake aiyo.\" Hitara hibar ḍake giye, toi hibaye hodde, \"Ãi tũwarar bái Yusuf, zare tũwara Mišorot beisso. ");
INSERT INTO rhg_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ar tũwara ãre eṛe beissode hiyanolla ehon tũwarar monot duk no ainno otóba nizor uwore rag no goijjo; foran okkol basaibolla Allaye tũwarar age ãre eṛe defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kiyollahoile dešot raṭ soledde ehon dui bosor oiye, ar aro fãs bosor saš ba fošol da no oibo. ");
INSERT INTO rhg_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kintu Allaye tũwarar bongšore duniyait basai rakibolla edde moha uddaror duwara tũwarare basaibolla, tũwarar age ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","\"Hetolla, ãre eṛe tũwara defeṛaiyo no, kintu Allaye. Hibaye ãre Feruwanor bafor zagat, edde hibar hár góror malik, edde šara Mišor dešor uwore šašongoroya goijje. ");
INSERT INTO rhg_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tũwara toratori uwore ãr bafor hãse zo edde hibare ho: 'Tũwar fut Yusufe endilla hoiye: Allaye ãre šara Mišor dešor malik goijje; tũi eṛe lamat ãr hãse aiyo, deri no goijjo. ");
INSERT INTO rhg_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tũi, tũwar futziyain edde natifuti, tũwar goru sool, ar za kissu ase beggun loi Gušen elehat takifariba; ar ãr ḍake ogai, ");
INSERT INTO rhg_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ar heṛe ãi tũwarare deha funa goriyum, kiyollahoile raṭ aro fãs bosor ase. Ar no oilede tũi edde tũwarar góror guštiṭiya, zin ase beggune hošto faiba.' ");
INSERT INTO rhg_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","\"Ar so, tũwara edde ãr bái Benyamin, tũwara nizor suke dekor, ze ãi nizor muke tũwarar loi hota hoidde; ");
INSERT INTO rhg_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mišorot ãr hondilla ijjot, edde zaha kissu tũwara deikko, beggun ãr bafore hoiba, ar hibare hara eṛe lamat loianogoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Toi hibaye hibar bái Benyaminor golat dori hainde, ar Benyamine o hibar golat dori hainde. ");
INSERT INTO rhg_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ar hibaye báiyain beggunore suma diye edde hitarar golat dori hainde. Tarfore hibar báiyainde hibar loi hotabattara hoiye. ");
INSERT INTO rhg_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yusufor báiyain aiššede, ei hóbor Feruwanor górot fõsiyore, Feruwan edde hitar gulam okkol beggune kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Feruwane Yusufore hodde, \"Tui tor báiyain okkolore ho, 'Tũwara endilla goro: Tũwarar zanuwargunor fiṛot haiddo lo edde Kenanot baisa do, ");
INSERT INTO rhg_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ar tũwarar bafore edde tũwarar nizor nizor góror manuš okkolore loi ãr hãse aiyogoi. Ãi tũwarare Mišoror uttom zaga diyum, edde tũwara dešor barik ziniš okkol hái fariba.' ");
INSERT INTO rhg_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","\"Tui hitarare hokum dibi, 'Tũwara endilla goro: Tũwarar bou fuwaindolla Mišorottu gũra gari okkol loizo, ar hitarare edde tũwarar bafore loi aiyogoi. ");
INSERT INTO rhg_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ar tũwarar malamalolla no bafiyo, kiyollahoile fura Mišoror uttom ziniš tũwarar oibo.'\" ");
INSERT INTO rhg_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Toi Israilor futain okkole hendilla goijje. Yusufe razar hokum mozin hitarare gũra gari diye, ar hibaye hitarare fõtolla hána o diye. ");
INSERT INTO rhg_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Hibaye fotti zonore noya hor diye, kintu Benyaminore tin šot rufar ṭĩya edde fãs zura hor diye. ");
INSERT INTO rhg_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ar bafolla hibaye in okkol defeṛaiye: došwa modda gadar fiṛot gori Mišoror barik ziniš okkol, ar došwa miyala gadar fiṛot gori gĩyũ edde ruṭi ar bafor baisalla haiddo. ");
INSERT INTO rhg_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tarfore hibaye báiyaindore bidai goijje, ar hitara baisa diyar šomot hibaye hodde, \"Fõtot hoijja-hanḍal no goijjo!\" ");
INSERT INTO rhg_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Toi hitara Mišorottu niyoliyore uwore Kenanot hitarar baf Yakubor hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Edde hitara bafore hoiye, hodde, \"Yusuf ehono zinda ase, ar šara Mišor dešor uwore hite šašongoroya oiye.\" Kintu bafor dil sorot taigiyegoi, kiyollahoile hitara hota hibattu biššaš no lage. ");
INSERT INTO rhg_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ar Yusufe hitarare hoilde he hár hota okkol zehon hitara hibare hoiye, edde hibare boiloizaibolla Yusufe gũra gari okkol defeṛaiyede hin zehon deikke, henot hitarar baf Yakubor ruh uwafes zinda oi uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Toi Israile hodde, \"Iyan beši oiye! Ãr fut Yusuf ehono zinda ase; Ãi zaiyore moribar age hitare saiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Tarfore Israile hibar hár kissu loi baisa diyore Beer-Šebat aišše, edde hibaye hibar baf Isakor Allar mutallek kurbani okkol diye. ");
INSERT INTO rhg_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Allaye raitta Israilore deha diyore hodde, \"Yakub, Yakub!\" hibaye hodde, So, oto ãi. ");
INSERT INTO rhg_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Toi hibaye hodde, \"Ãi Allah, tor bafor Allah; Lamat Mišorot zaite tui no ḍorais, kiyollahoile heṛe ãi tore ek ḍõr zati goriyum. ");
INSERT INTO rhg_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ãi tor fũwati lamat Mišorot zaiyum, edde hentu ãi tore abar uwafes firai o loi ainnum, ar tor sukor fata Yusufor nizor hate bandi dibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Toi Yakube Beer-Šebattu baisa diye. Israilor futainde hitarar baf Yakubore, edde hitara nizor nizor futziyain okkolore, edde bouwain okkolore, oi gũragari okkol, zin Feruwane hibare boiloizaibolla defeṛail, hinot gori loi giye. ");
INSERT INTO rhg_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ar hitara hitarar zanuwar okkol edde Kenanot hamailde hár šombotti okkol fũwati loi, Yakub edde hibar fura bongšo ṭiya hibar fũwati, Mišorot aigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakube hibar futain, futaindor fuwain, ziyain, ziyaindor ziyain, hibar gũṛa bongšo ṭiyare hibar fũwati Mišorot loi anniye. ");
INSERT INTO rhg_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","In okkol oilde Israilor futain okkol nam okkol (Yakub edde hibar bongšo okkol) zara Mišorot aišše: Yakubor foila zormo Ruben. ");
INSERT INTO rhg_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenor futain okkol: Hanok, Pallu, Hešron edde Karmi. ");
INSERT INTO rhg_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeonor futain okkol: Jemuwel, Jamin, Ohad, Jakin, Sohar edde Šaul he Kenaniyo mayafuwar fut. ");
INSERT INTO rhg_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levir futain okkol: Geršon, Kekat edde Merari. ");
INSERT INTO rhg_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ehudar futain okkol: Er, Onan, Šela, Feroš edde Šerah. (Er edde Onan Kenan dešot entehal goijje.) Ferošor futain okkol: Hešron edde Hamul. ");
INSERT INTO rhg_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakaror futain okkol: Tola, Puvah, Job ar Šimron. ");
INSERT INTO rhg_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulunor futain okkol: Serod, Elun ar Jahalel. ");
INSERT INTO rhg_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Itara oilde Lear futain okkol, zarare hibaye Paddan-Aramot Yakubolla biyail, fũwati hibar zi Dina šoho. Hitara mayafuwain edde morod fuwain beggune muṭ triš tinzon. ");
INSERT INTO rhg_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gador futain okkol: Sifiyon, Haggi, Šuni, Esbon, Eri, Arodi edde Areli. ");
INSERT INTO rhg_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ašeror futain okkol: Jimna, Jišba, Jišbi, Beriyah, edde hitarar boin Serah. Beriyar futain okkol: Heber edde Malhiyel. ");
INSERT INTO rhg_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Itara he Zilpar fuwain zare Labone nizor ziyore bandi hisabe dil, hibaye Yakubolla itarare biyaiye. Itara beggune šullo zon. ");
INSERT INTO rhg_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakubor bou Rahelar futain okkol: Yusuf edde Benyamin. ");
INSERT INTO rhg_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ar Mišorot, Manessare edde Efraimore On šohoror imam Putiferar zi Asenate Yusufolla biyaiye. ");
INSERT INTO rhg_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjaminor futain okkol: Bela, Beker, Ašbel, Gera, Naman, Ehi, Ruš, Muffim, Huffim edde Ard. ");
INSERT INTO rhg_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Itara aššilde Rahelar futain okkol, zarare Yakubolla biyaiye. Hitara muṭ soiddo zon. ");
INSERT INTO rhg_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danor fut: Hušim. ");
INSERT INTO rhg_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftalir futain okkol: Zahšiyel, Guni, Jezer edde Šillem. ");
INSERT INTO rhg_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Itara aššilde Bilhar futain, zare Labone nizor ziyore bandi hisabe dil. Hibaye Yakubolla itarare biyaiye. Hitara muṭ hãt zon. ");
INSERT INTO rhg_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Hitara zarare loi Yakube Mišorot aiyat aššil, zara hibar nizor bongšottu, Yakubor futaindor bouwain okkol sara, hitara muṭ haiṭ so zon. ");
INSERT INTO rhg_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Mišorot Yusufottu ze dui fut zormo oiye, edde Yakubor gušṭi zara Mišorot aišše hitara beggune muṭ hoittor zon. ");
INSERT INTO rhg_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Bade Yakube hibar age Ehudare Yusufor hãse defeṛaiye, zene hibaye hitare Gušenot zaibar fõt dehai de, toi hitara Gušen elehat aišše. ");
INSERT INTO rhg_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Toi Yusufe hibar nizor gũra garire hãzaiyore Gušenot hibar baf Israil loi deha goitto giye. Toi bafore zehon deikke, golat dori bout hotun hainde. ");
INSERT INTO rhg_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hetunot Israile Yusufore hodde, \"Ãi ehon moribolla tiyar! Tui zinda asos, ãi tor siyara dekilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Toi Yusufe hibar báiyain okkol edde hibar bafor góror manuš okkolore hodde, \"Ãi Feruwanor hãse zai ei hóborgan hoigoi, hibare hoiyum, 'Ãr báiyain edde bafor góror manuš okkol zara Kenanot takito, hitara ãr hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Hitara soolsoroya okkol; hitara goru sool faloya okkol. Hitara hitarar goru, sool, edde hitarar nizor hár kissu fũwati loi aišše.' ");
INSERT INTO rhg_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ar Feruwane tũwarare zẽtte ḍakibo edde fusar goribo, 'Tũwarar feša ki?' ");
INSERT INTO rhg_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Tũwara hoiba, 'Õnor ei gulam okkol edde hitarar baf dada okkole šoṛo halottu loti ehon foijjonto goru sool fali aiyer.' toi zene tũwara Gušenot takifariba, kiyollahoile soolsoroya okkol mani Mišoriyo okkolor hingšar ziniš.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Toi Yusuf giye edde Feruwanore ei hóborgan diye, hodde, \"Ãr baf báiyain okkole hitarar goru sool edde hitarar nizor hár kissur loi Kenan dešottu aigiyegoi, ar ehon hitara Gušenot.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ar hibaye hibar báiyain okkolor butottu fãs zonore loiyore hitarare Feruwanor sarme hazir goijje. ");
INSERT INTO rhg_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Feruwane báiyain okkolore fusar goijje, \"Tũwarar feša ki?\" Hitara Feruwanore hodde, \"Õnor ei gulam okkol hitarar baf dada okkolor ḍoil, soolsoroya. ");
INSERT INTO rhg_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ãra ei dešot forbaš goribolla aiššide, kiyollahoile õnor gulam okkole hitarar zanuwar okkol sori háibolla hono zaga no fail, kiyollahoile Kenanot raṭ beši hora oiye ar etolla aroz gorir, õnor gulam okkolore Gušenot takito do.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Toi Feruwane Yusufore hodde, \"Tor baf edde tor báiyain okkol tor hãse aišše, ");
INSERT INTO rhg_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mišoror deš tor sarme ase; ar dešor uttom zagat tor baf edde báiyaindore bošoti goraba; hitara Gušen elehat bošoti gorok; ar hitarar butore has laikka manuš asede tor zana takile, hitarar uwore ãr nizor zanuwar zãkor zimma de.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Bade Yusufe hibar nizor baf Yakubore ainne edde Feruwanor sarme hazir goijje; toi Yakube Feruwanore duwa goijje, ");
INSERT INTO rhg_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","toi Feruwane Yakubore fusar goredde, \"Tũwar boyoš ho bosor oiye?\" ");
INSERT INTO rhg_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Toi Yakube Feruwanore hodde, \"Ãr forbaš hal ekšo triš bosor; ãr aiur ei olfo din, hin o hoštot haiṭṭiye. Ar hin ãr baf dada okkolor forbaš halor aiuror fuwainna no o.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Bade Yakube Feruwanore duwa goijje edde hitar sarmottu bidai oiye. ");
INSERT INTO rhg_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Toi Feruwanor hokum mozin, Yusufe Mišor dešor uttom zagat, Rameses elehat, šombotti hisabe di, hibar baf edde hibar báiyain okkolore bošobaš goribolla buwai diye. ");
INSERT INTO rhg_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufe hibar baf báiyain edde hibar bafor hár góror manuš okkolore, hitarar fuwain mozin haiddo zuhai diye. ");
INSERT INTO rhg_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dešor hono mikka haiddo no aššil, kiyollahoile heṛe raṭ beši boiyanok oiye; Mišor edde Kenan raṭor zoriya toba oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ar Mišorot edde Kenanot zeto ṭiya aššil hin loi mainše haiddo kinat maze, Yusufe he šomosto ṭĩya dola gori loi Feruwanor górot ainne. ");
INSERT INTO rhg_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mišor edde Kenan dešor manuš okkolor ṭĩya zehon šeš oi giyegoi, Mišor beggune Yusufor hãse aiyore hodde: \"Ãrare haiddo do! Ãrattu ar hono ṭĩya nai boli ki ãra õnor sukor sarme moriyum ne?\" ");
INSERT INTO rhg_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufe hodde, \"Tũwarattu ṭĩya šeš oigilegoi tũwarar goru sool do, toi ãi tũwarar zanuwaror bodole tũwarare haiddo diyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Toi hitara hitarar zanuwar okkol Yusufor hãse ainne, toi Yusufe gũra, soolor zak, gorur zak, edde gada, hin okkolor bodole tarare haiddo diye. Ebafe Yusufe hitarar hár goru sool okkolor bodole hitarare haiddo diye edde he bosor lalon falon goijje. ");
INSERT INTO rhg_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","He bosor haṛi zaigoi bade hitara dusora bosor aiyore hodde, \"Ãra ãrar malikor hãse kissu gufon no goriyum, ãrar ṭĩya beggun furaigiyegoi, ar goru sool o õnor oiye; ar ãrar ga edde zobin sara malikore sarme rakibolla ãrattu ar kissu nai. ");
INSERT INTO rhg_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Õnor sukor sarme ãra edde zobin šoho kiyolla moritam? Ãrare edde ãrar zobingunore haiddor bodole kini lo, ar ãra ãrar zobin šoho Feruwanor gulam oiyum. Ãrare bizor dana do, toi zene ãra zane basi fari edde no mori, ar zobingun o beabadi oi no zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Toi Yusufe Mišoror hár zobin Feruwanolla kini loiye, kiyollahoile Mišoriyo okkol fotti ekzone hitarar zaga besi felaiye, kiyollahoile hitarar uwore raṭ beši hora oil. Ei bafe Mišoror hár zaga Feruwanor oiye. ");
INSERT INTO rhg_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ar Yusufe Mišoror ek šimattu loti oinno šima foijjontor manuš okkol beggunore šohorot lari loi ainne. ");
INSERT INTO rhg_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","hibaye šude šadu okkolor zobingun kini no lo, kiyollahoile hitara Feruwanottu bata faito, ar ze bata hitarare Feruwane dito hin loi hitara solito. Hetolla hitara hitarar zobin no bese. ");
INSERT INTO rhg_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Toi Yusufe mainšore hodde, \"So, aziya ãi tũwara edde tũwarar zobin Feruwanolla kiniloilam. Ei bizor dana in lo, zobinot šiṛogoi. ");
INSERT INTO rhg_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Hinot folibode hinor fãs bagor ek bag Feruwanore diba, ar baki sair bagottu bizor dana edde tũwara edde tũwarar góror manuš okkol edde tũwarar fuwaindolla haiddo oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Toi hitara hodde, \"Õne ãrar foran rokka goilla, ãrar uwore õnor rahamotor nozor ok; ãra Feruwanor gulam oiyum.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufe Mišoror zobinor babute ei ain ze goijjil hiyan aizo foijjonto zari ase. Zendilla neki, hár fošolor fãs bagor ek bag Feruwanor. Šude šadu okkolor zobin Feruwanor no o. ");
INSERT INTO rhg_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Toi Israili okkol Mišoror Gušen elehat bošoti goijje. Hitara heṛe šombotti fail edde hitara fólwala oiye edde manušor zono šoinka beši oi uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakub Mišor dešot hõtoro bosor basi aššil, ar Yakubor boyoš ek šo sališ hãt bosor oiye. ");
INSERT INTO rhg_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Bade zehon Israil moribar ṭaim hãse aišše, hibaye hibar fut Yusufore ḍakaiyore hodde: \"Ãi zodi tor doya fai taki, toile aroz gorir, tui ãr kulot hat de edde ãre hota de ze tui ãre doya dehaibi edde he mozin wada ṭik rakibi. Tũi ãre Mišorot no gãraibi, ");
INSERT INTO rhg_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ãi zehon ãr baf dada okkolor hãse ziraiyum, tui ãre Mišorottu niyolai loi zaiyore hitarar hoborstanot ãre gãraibi.\" Yusufe hodde: \"Tũi zen hor, ãi hen goijjum.\" ");
INSERT INTO rhg_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Toi hibaye hodde, \"Tui ãr loi hosom gor.\" Toi hibaye hosom goijje, toi Israile bisanar šitanor mikka sojida foijje. ");
INSERT INTO rhg_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Iyar hoto din bade ekzone Yusufore hodde, \"So, õnor bafottu ošuk.\" Henot hibaye hibar dui fut, Manessa edde Efraimore, hibar fũwati loiye. ");
INSERT INTO rhg_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Toi ekzone Yakubore hóbor hoiye, hodde, \"So, tũwar fut Yusuf aišše.\" Henot Israile hibar gar hár bol diyore uiṭṭe edde bisanat uṛi boišše. ");
INSERT INTO rhg_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakube Yusufore hodde, \"Kenan dešor Lušot maze Šorbo-Šoktiwala Allaye ãre deha dil edde duwa goijjil. ");
INSERT INTO rhg_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Hibaye ãre hoil, 'Sa, ãi tore beši fólwala goijjum edde tor bongšo barai diyum, ar ãi tore uggwa bout zatir šomaz goriyum, ar ãi tui bade tor bongšo okkolore ei dešgan sirohalolla šombotti hisabe diyum.' ");
INSERT INTO rhg_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","\"Ar ehon, tor dui fut, zara ãi eṛe Mišorot aibar age zormo oiye, hitara ãr; Ruben edde Simeonor ḍoilla Efraim edde Manessa o, hitara ãr. ");
INSERT INTO rhg_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kintu itara bade zarare zonom dibi, hitara tor oibo; hitara hitarar báiyaindor name ei zagat šombottir miraz faibo. ");
INSERT INTO rhg_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ar ãi Paddanottu aibar šomot Kenan dešor Efratot fõsite olfo fõt baki takite, Rahela ãr hãsottu mara giye. Henot ãi heṛe Efrator (hiyan oilde Betlehem) fõtor ḍake hibare dohon gorailam.\" ");
INSERT INTO rhg_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Toi, Israile Yusufor dui futore dekiyore hibaye fusar goredde, \"Itara hontara?\" ");
INSERT INTO rhg_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufe hibar bafore hodde, \"Itara ãr futain, zarare Allaye ei dešot ãre diye.\" Toi Israile hodde, \"Hitarare ãr hãse an, ãi hitarare duwa gori.\" ");
INSERT INTO rhg_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Burá boyoše suke dekibar šokti homi zagoinor zoriya Yakube bala gori no dekito. Yusufe hibar dui futore hibar hãse ainne, ar hibar bafe hitarare suma diye edde ãzamari doijje. ");
INSERT INTO rhg_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Toi Israile Yusufore hodde, \"Ãi baffilam, tor muk ar no dekiyum; kintu sa, Allaye ãre tor bongšo udda dehaiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tarfore Yusufe hitarare Yakubor kulottu lamai diye edde meṛir uzu oi holla zuhaiore bafore salam goijje. ");
INSERT INTO rhg_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Bade Yusufore dunizonore loi zai, Efraimore ḍen hate dori Israilor bame edde Manessare bam hate dori Israilor ḍene, hibar ḍake ainne. ");
INSERT INTO rhg_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kintu Israile hibar ḍen hattan barai di Efraimor matat rakkil, zodi o hite šoṛo fut. Ar bam hattan Manessar matat rakkil, zodi o hite foila fut. ");
INSERT INTO rhg_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Toi hibaye Yusufore duwa goijje edde endilla hoiye, \"Ãr baf dada, Ibrahim edde Isak, Allar issa mozin solito, ãr zibonor foila loti aijja foijjonto, he Allah ze ãre soolsoroyar ḍoilla gori sõli aiyer. ");
INSERT INTO rhg_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","he firista ze ãre hár mosibotottu uddar goijje, Hibaye ei zuwan okkolore duwa gorok. Itarar duwara ãr edde ãr baf dada, Ibrahim edde Isakor nam basi takok, ar itarar bongšo ei zobinot beša beši bari uṛok.\" ");
INSERT INTO rhg_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Hetunot Efraimor matat bafe ḍen hat raikkede deki Yusuf naraz oiye; toi hibaye Efraimor matattu bafor hattan loi Manessar matat dibolla saiye. ");
INSERT INTO rhg_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufe bafore hodde, \"Baba, hendilla no, foila zormo iteya; itar matat tũwar ḍen hat rako.\" ");
INSERT INTO rhg_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kintu bafe na monzur oi hodde, \"Ãi zani, o fut, ãi zani. Hitar butottu o uggwa zati oibo, edde hite o mohan oibo, kintu hitar šoṛo bái hitattuwaro aro beši mohan oibo. Hitar bongšor manuš okkolor butottu beši zati okkol oibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Toi hibaye hitarare he din duwa goijje edde hodde: \"Israili zati okkole honokiyore duwa dibar šomot hitara en hok: 'Allaye tore Efraim edde Manessar ḍoilla gorok.'\" Endilla hoiyore hibaye Efraimore Manessare ḍõr banaiye. ");
INSERT INTO rhg_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Tarfore Israile Yusufore hodde, \"Sa, ãi moribar ṭaim aišše, kintu Allah tũwarar fũwati takibo edde tũwarare tũwarar baf-dadar dešot firai loizaiboi. ");
INSERT INTO rhg_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ãi tore tor báiyaindottuwaro ek bag miraz beši dilam, ze beši bag ãi tore diyum, hiyan oilde he zaga ziyan ãi toluwar edde silhanḍa loi zuddo gori Amorittiyo okkolor hatottu loilam.\" ");
INSERT INTO rhg_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Bade Yakube hibar futaindore ḍaikke edde hodde, \"Beggune fũwati aiyo, sarme tũwarar uwore zin goṭibo hin ãi tũwarare hoi: ");
INSERT INTO rhg_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","\"Beggune fũwati aiyo! Funo, Yakubor futain okkol, tũwarar bab Israilor hota funo. ");
INSERT INTO rhg_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","\"Ruben, tui ãr foila zormo. Tui ãr bol, ãr juwanir foila fól, tui beggunor uwore šommani edde šoktidar. ");
INSERT INTO rhg_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tui fanir ḍoilla ũtari foror, tor he usol tokka ar no takibo, kiyollahoile tui tor bafor bisanat giyos; tui napak ham goijjos, hite ãr bisanat giye. ");
INSERT INTO rhg_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","\"Simeon edde Levi bái bái hitarar horafir zontro oilde toluwar. ");
INSERT INTO rhg_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Hitarar gufon mošorat ãr hono ongšo nai, ãi hitarar dolot no! kiyollahoile hitara guššae manuš kun gore, nizor issa mote gorur ṭengor šiṛa haṛe. ");
INSERT INTO rhg_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bodduwa hitarar gušša edde gumanore, haron hin bišon edde beši zalemi. Ãi hitarare Yakubor bongšottu bag goriyum, edde Israilor butore hitarare šiṛašitta goriyum. ");
INSERT INTO rhg_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","\"Ehudah, tor báiyainde tor tarif goribo; dušmon okkolor geṛir uwore tor hat oibo; tor bafor futain okkole tor sarme mata zuhaibo. ");
INSERT INTO rhg_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ãr fut Ehudah, tui šingor so; tui šiyaror gusto há šeš gori uṛi aili. Šingor ḍoilla neṛili edde uite fori roili, honokiye tor ḍake aibar šahoš no gorer. ");
INSERT INTO rhg_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ekdin Ehudar bongšor butottu ekzon šašongoroya aibo, zar hokum hár zatiye manibo. Ehudattu razar aša no zaibogoi, no zaibogoi bisaror aša hibar dui ṭengor mazottu Ze foijjonto šilo no aiye ar zati okkolor baiddota hibar oibo. ");
INSERT INTO rhg_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","He ãngur lotat hibare gadawa bandibo, ar ãngur gasor he barik ḍeilat bandibo, gadar soware, hibaye šorafot duiye hibar fušak, ãnguror louwot duiye hibar hoor. ");
INSERT INTO rhg_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Hibar suk oibo šorafottuwaro lal, hibar dat dudottuwaro dola. ");
INSERT INTO rhg_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","\"Sebulun doriyar farot bošot goribo, hiyan zahaz biraibar bondor oibo; Sidon foijjonto hitar dešor šima oibo. ");
INSERT INTO rhg_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","\"Issakar oilde ek boli gada ze dui soolor urar mazottu neṛer. ");
INSERT INTO rhg_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","hite dekilo ze ziranir zagagan bala, ar deššan šundor, hetolla hite bár boibolla hand lagai dilo, ar ek bondi gulam oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","\"Dane hitar mainšor bisar goribo, Israilor guštir ek bongšor ḍoilla gori. ");
INSERT INTO rhg_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ek haf, fõtor ḍake ek bišdor haf, siyon rastat ze gũrar kuri sai kuṭmare, ar gũrar suwari uldi fis mikka fori zagoi. ");
INSERT INTO rhg_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","\"O Mabud ãi tũwar uddaror ofekkat asi. ");
INSERT INTO rhg_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","\"Gadore ḍahaitor dole hamela goribo, kintu te o ulda falda hamela goribo. ");
INSERT INTO rhg_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","\"Ašerottu barik haiddo fodai oibo; hite razalla mozar hana zuhaibo. ");
INSERT INTO rhg_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","\"Naftali melá horinni, hite šundojja baša ho. ");
INSERT INTO rhg_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","\"Yusuf oilde ek gulawala gas, zonnar ḍake ek gulawala gas, ze gasor ḍeila okkol ḍebal ḍiyai giye. ");
INSERT INTO rhg_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tir maroya okkole hitare beši hošṭo der, hitara hitare tir marer edde hamela gorer. ");
INSERT INTO rhg_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kintu hitar silhanḍa zendilla mojbut, hitar hator bayerat roiye hendilla bol, kiyollahoile Yakubor Šoktiwalar hat, ze Israilor falok edde he ḍõr fattor, ");
INSERT INTO rhg_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","tor bafor Allah, ze tore modot gorer, he Šoktiwala, ze tore rahamot gorer, asmanor uworor rahamot loi, nisor zobinor rahamot loi, bukor dud edde gorbor rahamot loi. ");
INSERT INTO rhg_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tor bafor rahamot aro barik sirohailla faharottu rahamotottuwaro, sirohailla parbotottu bala zinišottuwaro. Hin okkol Yusufor matar uwore forok, forok hitar matar širot, ze báiyain okkolor maze razfut. ");
INSERT INTO rhg_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","\"Benyamin oilde ek šiyari gendabag, binna hite šiyar háibo, ar hazinna hite luṭ baṛe.\" ");
INSERT INTO rhg_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Itara beggun oilde Israilor baro bongšo, ar in oilde zin hitarar bafe hitarare hoil zẽtte hibaye hitarare rahamot goijje. Hibaye rahamot goijje edde hitara fotti ekzon ze zar laikka mozin duwa diye. ");
INSERT INTO rhg_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Bade Yakube hitarare hokum diye edde hitarare hodde, \"Ãi ãr baf dada okkolor hãse dola oirgoi. Hetittiyo Efronor maṛor hoboror gãtot, ãr baf dada okkolor fũwati ãre hobor diyo. ");
INSERT INTO rhg_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ei gãt iba oilde Kenanot Mamrer muwamui Mokfelar maṛot, ziyan Ibrahime Hetittiyo Efronor hãsottu maṭ šoho hoborstan banaibolla kini loil. ");
INSERT INTO rhg_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Heṛe Ibrahim edde hibar bou Sarare o hobor diya oiye, ar Isak edde hibar bou Rebekare o heṛe hobor diya oiye, ar ãi Leare o heṛe hobor diyi. ");
INSERT INTO rhg_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","He maṭ edde heṛe asede gãt šoho hiyan Hetittiyo okkolottu kini lowa oiye.\" ");
INSERT INTO rhg_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakube hibar futaindore hokum diya šeš gori bade bisanar uwore dui ṭeng ek hatar goijje, bade niyaš felaiye edde hibar baf dada okkol loi dola oiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Hetunot Yusufe hibar bafor mukor uwore muk diyore hainde, edde hibare suma diye. ");
INSERT INTO rhg_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Bade Yusufe hibar bafor gat kušbo mosolla makidibolla, hibar gulam okkol edde ḍakṭor okkolore hokum diye, henot ḍakṭor okkole hibare kušbo mosolla makidiye, ");
INSERT INTO rhg_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Hitara he ham sališ din dori goijje, kiyollahoile kušbo mosolla maki dite sališ din lage. Ar Mišoriyo okkole hiballa hoittor din foijjonto šuk goijje. ");
INSERT INTO rhg_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Šukor din okkol faraizaigoi bade, Yusufe Feruwanor hormosari okkolore hodde, \"Zodi ãi tũwarar nozorottu doya fai taki, toile Feruwanor hanot ei hotagun hogoi, ");
INSERT INTO rhg_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Ãr bafe ãre hosom goraiye edde hoiye, \"Sa, ãi morizairgoi, Kenanot ãi ãlla ze hobor kuri raikki, tui ãre hibat gãrais.\" Hetolla foriyad gorir, ãre heṛe uwore zaito do; ãi bafore gãrai bade abar firi aiššum.'\" ");
INSERT INTO rhg_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Feruwane hodde, \"Za, tor bafe tore zendilla hosom goraiye, tui he mozin hibar hobor degoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Toi Yusufe hibar bafore gãraibolla uwor mikka baisa diye, Feruwanor gulam okkol beggun, hitar góror hár murubbi okkol edde dešor hár murubbi okkol, beggune hibar fũwati uwore giye. ");
INSERT INTO rhg_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ar Yusufor fura gór, edde hibar báiyain okkol, edde hibar bafor gór okkol giye; šude hitarar gura fuwain okkol edde goru soolor zãkgunore Gušenot eri giye. ");
INSERT INTO rhg_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ar hibar fũwati uwore gũragari edde gũrar suwari okkol o giye. Hitara beggune ḍõr ek dol oiye. ");
INSERT INTO rhg_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Toi hitara Zordan halor oinno faror Atador hõlat fõisse, heṛe beša beši bilag dori handa haṛi goijje. Ar Yusufe o hãt din dori bafolla šuk goijje. ");
INSERT INTO rhg_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ar Kenanor bašinda okkole Atador hõlat Mišoror mainšor šuk falon šoba deki hodde, \"Mišoriyo okkololla iyan ekkan beši muilliyoban šuk šoba oibo.\" Hetolla Zordanor oinno ḍakottu asede zaga hiyanor nam Abel-Mišraim nam oiye. ");
INSERT INTO rhg_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Toi hibar futaindore hokum dilde mozin hitara goijje. ");
INSERT INTO rhg_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Hitara hibare Kenanot loigiye, edde Mamrer muwamui Mokfelar maṛor gãtot hobor diye, ziyan Ibrahime Hetittiyo Efronor hãsottu hoborstan banaibolla kiniloil. ");
INSERT INTO rhg_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bafore dohon gorai bade Yusufe báiyain okkol, aro zara hibar fũwati hibar bafore dohon goraito gil, hitara beggun šoho Mišorot firi aigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yusufor báiyainde zehon deikke ze hitarar baf morigiyegoi, hitara hodde, \"Otfare Yusufe ãrare hingša goribo, edde ãra hitar uwore ze burai goijjilam, hin beggunor bodola uwafes ãrattu loibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hetolla hitara Yusufor hãse en hoiyore hóbor defeṛaiye, \"Tor bafe moribar age ãrare endilla hokum dil: ");
INSERT INTO rhg_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Tũwara Yusufore ei hota hoiyo: Tor báiyainde tor berudde oinnai goriyore ze nasoyi edde guna goijje meherbani gori tui hitarar onnaire edde gunare maf goride.' Etolla ehon ãra foriyad gorir, tor bafor Allar ei gulam okkolor onnaire edde gunare maf goride.\" Hitarar ei hotat Yusufe hainde. ");
INSERT INTO rhg_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bade hibar Báiyain okkol o aišše edde hibar sarme meṛit ũite foijje edde hodde, \"Sa, ãra tor gulam okkol.\" ");
INSERT INTO rhg_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Toi Yusufe hitarare hodde, \"No ḍoraio! Ãi hon Allar zagat tiyoya? ");
INSERT INTO rhg_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tũwara ãr berudde horafi goribolla baffila hiyan ṭik, kintu Allaye balar mikka baiffe. Ei bafe Allaye beši mainšor foran rokka goribar issa goijje, zendilla tũwara aziya dehor. ");
INSERT INTO rhg_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hetolla no ḍoraiyo! Ãi tũwara edde tũwarar fuwaindore falizaiyum.\" Ei bafe hibaye hitarare dilot šanti edde buz diye. ");
INSERT INTO rhg_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Bade Yusuf hibar bafor gór šoho beggun loi Mišorot bošoti goijje; Hiba ekšo doš bosor zinda aššil, ");
INSERT INTO rhg_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ar Yusufe Efraimor fuwain edde Efraimor natiyain okkol foijjonto dekkil. Ar Manessar fut Makiror fuwain okkol o Yusufor kulot zormo oil. ");
INSERT INTO rhg_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bade Yusufe báiyaindore hodde, \"Ãi morizairgoi, kintu Allaye hameka tũwarar uzu nozor rakibo, edde Ibrahim, Isak edde Yakubor hãse ze deš dibar wada goijjil, tũwarare ei dešottu he dešot loizaibo.\" ");
INSERT INTO rhg_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusufe Israili okkolore ek hosom goraiye edde hodde, \"Allaye hameka tũwarar uzu saibo, ar tũwara entu ãr ãḍḍigun tuli loizaiyogoi.\" ");
INSERT INTO rhg_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Toi Yusuf ekšo doš bosor umorot mori giyegoi. Ar mainše hibare kušbo mosolla maki diye edde hibare Mišorot ek tabutot raki diya oiye.");
INSERT INTO rhg_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Još okkole šašon goribar agor ṭaimot dešot ek bar raṭ oil. Ar Ehudiyar Betlehemottu ekzon manuše, hitar bou edde dui futore fũwati loi Muab dešot hãroigilgoi. ");
INSERT INTO rhg_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Manušwar nam aššilde Elimelek, hitar bouwor nam aššilde Naumi, ar hitar dui futor nam aššilde Mahlon edde Kilion. Itara aššilde Ehudiyar Betlehemor Efrat-guštir manuš. Itara Muab dešot giye edde heṛe roiye. ");
INSERT INTO rhg_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Bade Naumir šuwami Elimelek mori gilgoi, henot hiba hibar dui futore loi roiye. ");
INSERT INTO rhg_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Bade hitara duizone dui Muabi hoinniare biya goijje: ekzonor nam aššil Orpa, ar ekzonor nam aššil Rut. Hitara onumanik doš bosor heṛe bošoti goijje. ");
INSERT INTO rhg_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Tarfore Mahlon edde Kilion, hitara dunizono mori giyegoi, ar Naumi šuwami hara, fuwain hara, duni mikkattu eka oi roiye. ");
INSERT INTO rhg_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Bade Naumi hibar futor bouwain dunizon fũwati loi Muab dešottu firi zaiboilla uṭṭil; haron hibaye Muab dešot fuinnil ze Mabude hibar mainšor uwore nozor diye edde ahar der. ");
INSERT INTO rhg_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Hiyanor zoriya hiba zeṛe takito he zagttu niyolle, ar fũwati hibar dui futor bouwain o aššil, Toi hitara Ehudiya dešot uwafes firi zaiboilla fõt bai baisa diye. ");
INSERT INTO rhg_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Hetunot Naumiye hibar dui futor bouwaindore hodde: \"Tũwara tũwarar mar górot firizogoi. Mora okkololla edde ãlla ze raham goijjio, Mabud tũwarare o he bafe raham gorok. ");
INSERT INTO rhg_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Tũwara dunizone zene šuwamir górot bissram fo, Mabud tũwarare hendilla dula dok.\" Toi hibaye hitarare suma diye; henot hitara guzori handa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ar hibare hodde: \"Na, ãra o tũwar fũwati tũwar zatir heṛe firi zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Kintu Naumiye hodde: \"Oh ãr hoinnia okkol, firizogoi, tũwara ãr fũwati kiyolla zaiba? Tũwarar šuwami oi farefan ãr feṛot ki aro morod fuwa oibar aša ase? ");
INSERT INTO rhg_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Oh ãr hoinnia okkol, firizogoi; haron ãr boyoš oiye, ãi abar biya gori no faijjum. Ar zodi o aša ase hoi aijja raitta biya gori, ar futain zormo di. ");
INSERT INTO rhg_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Toile tũwara ki hitara zuwan ofan ofekka gori tai fariba? Hitaralla ki tũwara biya no gori boi taiba? No no, Oh ãr hoinnia okkol! Iyan tũwarattuwaro ãttu aro beši titar lager, kiyollahoile Mabudor hãt ãr berudde giye! ");
INSERT INTO rhg_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Henot hitara abar guzori handa šuru goijje. Toi Orpaye hibar horire sumadi bidai loiye, kintu Rute hibar hórire ãzamari dori taigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tehon Naumi hodde: \"Sa, tor zal hibar mainšor edde hibar devotar hãse firigiyegoi, tui o tor zalor fise fise firizagoi.\" ");
INSERT INTO rhg_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Kintu Rute hodde: \"Tũware felaizaite, tũwar fisa lowattu firizaibolla ãre no hoiyo: Kiyollahoile zeṛe tũi zor, ãi o zaiyum, ar zeṛe tũi takor, ãi o takiyum. Tũwar zati, ãr zati, ar tũwar Allah, ãr Allah. ");
INSERT INTO rhg_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Zeṛe tũi moror, ãi o morium, edde heṛe ãre hobor diya ok. Moron sara ar kissuye zodi ãre edde tũware zuda gori fare, toile Mabud ãre beši gozob dok!\" ");
INSERT INTO rhg_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naumi zehon dekilo hibar fũwati zaibolla Rut mon sokto gori ereda gorifelaye, tehon hibaye hibare ar kissu no hoilo. ");
INSERT INTO rhg_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Bade hitara dunizon zaite zaite Betlehem zehon fõssiyegoi, farar agagura hitarar babute howa hoi šuru oiye; mayafuwain okkole hodde: \"Iba Naumi no?\" ");
INSERT INTO rhg_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Hibaye hitarare hodde: \"Ãre Naumi (zara mani kuši) no ḍaikkio, bolke Mara (zar mani tita) ḍako, Kiyollahoile Šorbo-šoktiwalaye ãr zibonore beši tita gori diye. ");
INSERT INTO rhg_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ãi hár kissu furon gori loi baisa dilam, kintu ehon Mabude ãre hali hat loi firai ainnye. Tũwara ãre Naumi hoi ka ḍakor zehon Mabud ãr bifokkede forman diye, ar Šorbo-šoktiwalaye ãre hoštot felaiye. ");
INSERT INTO rhg_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ei bafe Naumi firi aišše, hibar fũwati hibar futor bou Rut o, ze Muab dešottu firi aišše. Toi hitara Betlehem aiššede šomot gĩu da šuru oiye. ");
INSERT INTO rhg_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naumir šuwami Elimelekor guštir ekzon ijjotdar tuwangor egena aššil; tãir nam Buaz. ");
INSERT INTO rhg_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ek dinna Muabiya Rute Naumire hodde: Ãi ketor kuṛat zaiore ze ãre rahamotor nozore giudanar sóra feṛaito de, tar fise fise giudanar sóra feṛaigoi. Naumi hoil: Okena, za oh zi. ");
INSERT INTO rhg_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Bade hiba zaiore ek ketor kuṛat fošol haṛoya okkolor fise fise kuṛat foijjia giudanar sóra okkol feṛailowa šuru goijjil. Ar endilla oilo, ze kuṛat Rute giudana feṛail hiyan Elimelekor egena Buazor ket. ");
INSERT INTO rhg_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ar so, Buaz Betlehemottu aišše edde fošol haṛoya okkolore hoil: Mabud tũwarar fũwati takok. Tara zuwabe hoil: Mabud õnore o duwa gorok. ");
INSERT INTO rhg_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bade Buaz fošol haṛoya okkolor uwore zimmadarore fusar goijjil, Iba haro zobuti? hoi. ");
INSERT INTO rhg_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Tehon zimmadare hoil: Iba Muabiya zobuti, ze Naumir fũwati Muab dešottu aišše. ");
INSERT INTO rhg_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Hibaye ãttu fusargoijjil, meherbanigori fošol haṛoya okkolor fise fise zai kuṛattu giudanar sóra feṛai loifaijjum ne hoi. Hiba binna loti ehon foijjonto eṛe ase; bana ekkenagori góror butore aiššil edde zirail. ");
INSERT INTO rhg_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Toi Buaz Rutore hoil: Fun; oh ãr maya fuwa, tui giudana feṛaito oinno ketot no zais, ei ketottu no zaisgoi, ãr zobuti bandi okkolor fũwati eṛe tak. ");
INSERT INTO rhg_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Fošol haṛoya okkol zeṛe fošol haṛibo hikka diyan raki tui bandi okkolor fise fise zais. Tor gat hat no defan ãi zobuk okkolore hoidir. Ar fanir tirašlagile tui oi górar hãse zai, zobuk okkole ze fani tuli raikke henttu fihaisgoi. ");
INSERT INTO rhg_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Henot hibaye meṛit sojida fori tare salam gori hoil: Ãi boideši, õne ãre eto faṭṭa dor, õnor sarme ãi ei doya kiyottu failamde? ");
INSERT INTO rhg_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Buaze zuwab dil: \"Tor šuwami mori bade tui tor horire zendilla goijjios edde nizor ma bab, zormostan sari ek osin zatir hãse aiššos, he šob hota beggun ãi fuinni. ");
INSERT INTO rhg_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Mabude tore, tui zin goijjos hinor enam dok; He Israilor Allah, Mabudor fakor nise zehon tui assoro loito aiššos, hibaye tore furafuri bafe enam dok.\" ");
INSERT INTO rhg_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Hibaye Buazore hoil: \"Oh ãr malik, õne ãre rahamotor nozore so; õnor ei bandire šantona dila edde šantir hota hoila, zodi o ãi õnor bandi okkolor laikka no.\" ");
INSERT INTO rhg_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Tarfore hána háibar ṭaim zẽtte oil Buaze hibare hoil: Tui eṛe ai ruṭi hagai, tor ruṭir ṭukura rošot burai lo. Bade hibaye fošol haṛoya okkolor ḍakottu boiššil, ar Buaze hibare baijja dana dil. Toi hibaye feṭbori hána háil. bade aro hodun basitaigilgoi. ");
INSERT INTO rhg_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Bade hiba giudana feṛaito zehon uṛil, Buaz tar mainšore hokum dil: Hibare dolagoijjattu feṛailoito do, edde hibare hũnki no diba hoi. ");
INSERT INTO rhg_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Oh, tũwara hodun giudanar tarattu ṭani hiballa raki do, zene hiba feṛailoi fare, ar honokiye hibare dõk no diba. ");
INSERT INTO rhg_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ar hibaye hazinna foijjonto he ketot giudana feṛail. Bade hibar feṛaiya giudana hinore baijjaiore onumanik ek ari foijjonto giudana oil. ");
INSERT INTO rhg_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Bade hibaye hin tuliloi šohorot uwafes firigilgoi. Horiye hibar feṛaiya giudanar bosta dekil; ar Rute basitakkilde he hánagun o hibar fũwati loiannil, ar hinore hibar horir munttu niyolaidil. ");
INSERT INTO rhg_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Tehon horiye hibare hoil: Tui aijjia hoṛe feṛaios? Hoṛe ham goijjos? Ze tor mikka rahamotor nozor diye, Allah tare rahamot gorok. Tehon hibaye har hãse ham goijje, hin horire zanail. Hibaye endilla hoil: Ze manušwar hãse aijjia ãi ham goijji tar nam Buaz. ");
INSERT INTO rhg_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Henot Naumi hibar futor boure hoil: Tare rahamot gorok he Mabude ze doya deha bondogori no fele zinda edde mora okkolor uwore. Naumi aro hoil: Hite ãrar egena, ãrare dehašuna goribar zimma asede tarar butorottu ekzon. ");
INSERT INTO rhg_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ar Muabiya Rute hoil: Te ãre endilla o hoiye, ãr šomosto fošol daiya šeš no o foijjonto tui ãr mainšor fũwati fũwati takis. ");
INSERT INTO rhg_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Tehon Naumi hibar futor boure hoil: Mare, oinno honokiyor ketot, tore honokiye zalafura gori no farefan, tar hamor mayafuwaindor fũwati fũwati takon tolla bala oibo. ");
INSERT INTO rhg_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Toi fošol daiya šeš no o foijjonto, hibaye giudana feṛaibolla Buazor hamor mayafuwaindor fũwati fũwati takil edde hibar horir fũwati bošobaš goijil. ");
INSERT INTO rhg_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ek din Naumiye Rutore hodde: Oh zi! Ãi tolla ki ekkan gór sešta no goijjum zene tui šuk fos? ");
INSERT INTO rhg_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Fun! Tui ze Buazor bandi okkolor fũwati aššili, hite ki ãrar egena no ne? Sa, hite aziya raitta hõlat giudana uraibo ");
INSERT INTO rhg_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Tui ga du edde kušbo tel bebargor, ar tor šundoijjia hoor findi oi hõlat za, kintu tar há fiya šeš no o foijjonto tui tare tor foriso no dis. ");
INSERT INTO rhg_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Te zẽtte neiṭṭo zaibo, tehon tui tar bisana otgori rakibi. Bade heṛe zaiore tui tar saddorgan ṭengor uwottu atorgorifelai heṛe neṛizaibigoi. Ar ki goraforibo hin te tore hoibo. ");
INSERT INTO rhg_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Hibaye zuwabe hoil: Tũi zen hor, hin beggun ãi goijjum. ");
INSERT INTO rhg_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Bade hiba oi hõlat lamigil edde hibar horiye zendilla hokum dil, he mozin hibaye beggun goijjil. ");
INSERT INTO rhg_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Buaz há fiya gorifelail edde tar mondil kuši oil, te giudana ṭalor hãsat zai neiṭṭilgoi. Ar Rut aste aste zai tar ṭengor uwottu saddorgan algaifelail edde heṛe neiṭṭil. ");
INSERT INTO rhg_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Bade ada raittot maze Buaz somkiuṛiṭṭil edde faš bodolil. Ar so, ekzon beṛimanuš tar ṭengor ḍake neṛitaikke. ");
INSERT INTO rhg_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Toi hite fusar goijjil: Tui hon? Hibaye zuwabdil: Ãi tũwar bandi Rut. Tũi tũwar saddoror tole bandire assoro do, haron tũi ãr dehašuna goroya egenar buttotu ekzon. ");
INSERT INTO rhg_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Te hodde: Allar rahamot ok tor uwore, oh zi! Ei foijjonto tui ze fakka dilolade hiyan dehaiyos ehon hinottu aro beši fakka dilolade hiyan dehaili. Kiyollahoile tui tuwangor otóba gorib hono ḍoilla zobukor fise no zos. ");
INSERT INTO rhg_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ehon tui, oh zi, ar no ḍorais. Tui zã hoibi ãi tolla hin beggun goijjium. Haron tui ze beši bala maya fuwa hiyan ãr farar manuš beggune zane. ");
INSERT INTO rhg_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ar ãi tor dehašuna goroya egenar buttotu ekzon hiyan soiyi, kintu ãttu aro hãsor ar ekzon egena ase. ");
INSERT INTO rhg_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Tui aijjia raittia eṛe tak. Binna zodi te tor dehašunar bar lo, toile hite hen gorok, ar zodi hite tor dehašunar bar no lo, toile zinda Mabudor hosom gori hoir, ãi tor dehašunar bar loiyum; binna no o foijjonto tui eṛe neṛitak. ");
INSERT INTO rhg_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Tarfore Rut binna fozor o foijjonto tar ṭengor ḍake neṛitakkil, edde ekzone ekzonore sini no farede hendilla andar takite hiba neṛattu uṛigilgoi, haron Buaze hibare hoil: Hõlat ze ekzon maya fuwa aišše hiyan honokiye no zana foribo. ");
INSERT INTO rhg_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Te aro hoil: Tor gar šallan loi ikka ai edde hiyanore tor munttu gori dor. Ar hibaye šallanore munttu gori doril, toi te so barang giudana mafi hibar matar uwore tulidil. Toibade hite šohoror uzu gilgoi. ");
INSERT INTO rhg_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Bade Rut zehon hibar horir hãse aigilgoi, hibaye fusargoijjil: Ken ken oil, oh zi? Henot hibaye beggun kulasagori hoil, Buaze hibare zen zen goijje. ");
INSERT INTO rhg_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Hibaye horire aro hoil: Te ãre horir hãse halihate no zais hoi ei giudana so barang in ãre diye. ");
INSERT INTO rhg_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ei hota funi Naumi hoil: Tui sofor gor, oh zi, šeše hondilla o sasena! Aijjia iyanore hono šabišto no oite te no tamibo. ");
INSERT INTO rhg_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bade Buaz ṭaun-geiṛot zai heṛe boiššilgoi. Ar so, ze dehašuna goroya egenar hota Buaze hoil te hehon henttu aiššil. Buaze tare, Oh, folona omuk hoi ḍakdil edde hoil: \"Eṛe aio, boiyogai.\" Toi te fottottu ai boššilgai. ");
INSERT INTO rhg_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bade Buaze došzon bura murubbi okkolore ḍaki hoil: Onora eṛe boio. Toi tara o aiyore boššilgai. ");
INSERT INTO rhg_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Buaze he dehašuna goroya egena hitare hodde: Naumi Muab dešottu firi aišše, hibaye ãrar egena Elimelekor zobingan besito sar. ");
INSERT INTO rhg_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Hetolla ãi bafilam ei befargan tũwarare zanaon dorhar. Eṛe zara aišše tarar sarme edde ãr zatir bura murubbi okkolor sarme tũi hiyan kinilo. Tũi zodi zobingan surailoito so, toile surailoifelo. Ar zodi tũi no loito so toile ãre ho, haron hiyan surailoibar odihar beggunor age tũwar, ar tũi bade ãr. Tarbade he dehašuna goroya egenaye hodde: Ṭik ase, ãi hiyan surailoium. ");
INSERT INTO rhg_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Henot Buaze hoil: Tũi ze din he zobingan Naumir hãsottu kiniloiba, hedin tũwattu Rut, he Muabiya rarire o gosaforibo, zene mora manušwar odihare, tar nam edde tar zobinor mirazdar take. ");
INSERT INTO rhg_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ei hota funi oi dehašuna goroya egenaye hodde: Ãi henoile hiyan surailoi no faijjum, hen goillye ãr nizor fuwaindor miraz nošto gorifelayifan oibo. Ãr zagat tũi surailo, haron ãi surailoi nofarir. ");
INSERT INTO rhg_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Surailowa edde besa-kina in okkol age Israil dešot endilla rosom aššil ze hota fakka goribolla ekzonor ṭengor zuta ar ekzonore dito, ei bafe boni-Israil hono hamor goba goitto. ");
INSERT INTO rhg_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Toi oi dehašuna goroya egena hite Buazore: Hiyan tũi kinilogoi, hoi te tar ṭengor zuta kulidil. ");
INSERT INTO rhg_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Tehon Buaze bura murubbi edde heṛe aiššilde tara beggunore hoil: Ãi Naumir hãsottu Elimelek, Kilion edde Mahlonor šomosto šombotti kiniloilam, aijjia tũwara hinor goba oila. ");
INSERT INTO rhg_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Zene morar nam tar afon báiyaindor edde farattu buzi no zagoi, edde he šombottittu mirazdar okkole miraz fa, ar he mora manušwar odihare tar nam uddar goribolla ãi ãr bou hisabe Muabiya hoinnia Rut, Mahlonor boure kobul gorilam. Tũwara aijjia ei šomostor goba oila. ");
INSERT INTO rhg_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Toi heṛe ṭaun-geiṛor butore zara boiššil, tara šoho bura murubbi okkole hoil: Oi, ãra goba oilam. Ze maya fuwa tũwar górot aiyer hibare Mabude Rahela edde Leyar ḍoilla gora ok, zarar duwara šomosto boni-Israil lami aišše. Ar Eferatot tũwar kamiyaf ok edde Betlehemot tũwar nam mošur ok. ");
INSERT INTO rhg_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Mabud he zobutir feṛottu ze fuwain tũware dibo, tarar butottu di tũwar bongšo zen Tamaror feṛot Ehudar fuwa Ferošor bongšor ḍoilla o. ");
INSERT INTO rhg_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Bade Buaz Rutore biyagoril edde Rut tar bou oil. Buaz hibar hãse gil, toi Mabud Rutor feṛot fuwa dil edde hibattu ekzon morod fuwa oil. ");
INSERT INTO rhg_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Bade mayafuwain okkole Naumire hoil: Allare šukuriya, Tãi aizo tũware dehašuna goroya egenattu siri nofele. Ei fuwar nam boni-Israilor maze mošur ok. ");
INSERT INTO rhg_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ite tũwar foranore abar tottoza gori tulibo edde tũwar bura boyošot tũwar deha šuna goribo, haron tũwar futor boue tũware adorgore, hibaye biyayede fuwa, ze tũwalla hãt futottu aro barik. ");
INSERT INTO rhg_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Bade Naumi gura morod fuwaware kulot loil edde tare lalon falon gora šuru goijjil. ");
INSERT INTO rhg_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Bade Naumiye ekzon morod fuwa faiye! En hoi ḍen gór bam górjjiya okkole tar nam rakil. Tara tar nam rakkil Obed. Obed aššilde Yašir bab, Yašir aššilde Daudor bab. ");
INSERT INTO rhg_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","In oilde Ferošor hãndan okkolor nam: Ferošor fuwa Hešron, ");
INSERT INTO rhg_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hešronor fuwar nam Ram, edde Ramor fuwa Omminadab, ");
INSERT INTO rhg_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Omminadabor fuwa Nahušon, Nahušonor fuwa Salmon, ");
INSERT INTO rhg_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmonor fuwa Buaz, Buazor fuwa Obed, ");
INSERT INTO rhg_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedor fuwa Yasir, Yasiror fuwa Daud.");
INSERT INTO rhg_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Mabudor kalam Amittaior fut Yunusor heṛe aišše, hodde: ");
INSERT INTO rhg_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","\"Uṭ, he moha šohor, Ninivit za, ar hiyanor berudde guzori zanai degoi ze hitarar naformani ãr sarme aišše.\" ");
INSERT INTO rhg_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Kintu Yunus nobi uzan Allar munttu atoroi zaibolla toiyaroil. Tãi Zaffa šohoror bondorot, Toršišot zaibo hendilla ekkan zahaz fail. Hetunot Allar munttu daizaiboilla zahazor bara di zahazor serainga okkolor fũwati Toršišot zaibolla he zahazot uṭṭil. ");
INSERT INTO rhg_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Kintu Mabud doriyat zur bataš melamajjil edde doriyat en tuwan bail ze tuwane zahazsan bangizaibar alamot oil. ");
INSERT INTO rhg_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Henšomot zahazor serainga okkole ḍorail, fottikiye tarar nizor nizor devotar hãse handahaṛi gora šuru goillio. Ar uzon homaibolla zahazor malfottro okkol doriyat felai dilo. Kintu Yunus nobi zahazor khulot lammilgoi edde heṛe neṛi bári gumot aššil. ");
INSERT INTO rhg_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Tehon zahazor keptine tãir hãse ai hoil: Oh! Tũi ze gumzor, tũwattu ki oiye? Uṛo, tũwar devotare ḍako; oitfare tũwar devotaye ãrar befare sinta goribo toi ãra ar dongšo no oiyum. ");
INSERT INTO rhg_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Tarfore zahazor serainga okkol tara ekzone ekzonore hodde: Aiyo ãra loṭari baṛi, toi zanifarium har duše ãrar kubaigio or. Bade tara loṭari baṛil, ar Yunusor name loṭari uṭṭil. ");
INSERT INTO rhg_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Hetunot tara fusar goijjil: Tũi ãrare ho, har duše ãrattu kubaigio or? Tũwar ham ki? Tũi hontu aiššode? Tũi hon dešor manuš? Hon zatir manuš? ");
INSERT INTO rhg_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Tãi tarare hoil: Ãi ekzon Ibroni; ãi Mabudore ḍorai, tãi behostor Allah, tãi doriyare edde fuwana zobinore banaiye. ");
INSERT INTO rhg_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Hetunot he manuš okkole beši ḍorail edde tãire hoil: Tũi in ki goror? Yunus Allar sarmottu daizargoide hehota tara zainto, haron tãi tarare zanail. ");
INSERT INTO rhg_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Doriya ošantir uwore ošanti oi gilgoi, hetolla tara tãire hodde: Ãra tũware ki gorile doriya ãralla šanti oibo? ");
INSERT INTO rhg_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Tãi tarare hoil: Ãre dori doriyat felido, toi doriya tũwaralla nizam oi zaiboi; haron ãi zani, ãr duše tũwarar uwore ei bári tuwan munttu aišše. ");
INSERT INTO rhg_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Tarfore o oi manuš okkole zahaz firaiore kulsuwaibolla darba šuru goijjil; kintu tara nofaril, haron doriya ulda taralla utaltal oi gilgoi. ");
INSERT INTO rhg_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ei harone tara Yunusor Mabudore ḍaka šuru goijjil, ar hoil: Oh Mabud, aroz gorir, ei manušwar foranollabuli ãrare dongšo no goijjio, ãrar uwore nidušir roktor dai no goijjio; haron, oh Mabud tũi tũwar issa mote ham goijjio. ");
INSERT INTO rhg_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Bade tara Yunus nobire dóri doriyar fanit felaidil, tehon doriyar tuwan tamigilgoi. ");
INSERT INTO rhg_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Henot oi manuš okkole Allare beši ḍora šuru goillio. Ar tara Mabudor mutallek kurbani gorilo edde manoš goillio. ");
INSERT INTO rhg_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ar Mabud Yunus nobire gilifelaibolla uggwa bor mas ṭik gori rakkil. He masor feṛot Yunus nobi tin din tin rait aššil. ");
INSERT INTO rhg_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Tehon Yunus oi masor feṛottu tai Allah Mabudor hãse munazat goijjil, tãi hoil: ");
INSERT INTO rhg_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Mabud, ãi tũware bifodot ḍakilam ar tũi ãr ḍak funila; ãi hoboror murottu tai tũware ḍakilam, ar tũi ãr foriyad funila. ");
INSERT INTO rhg_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Tũi ãre mur fanit doriyar bukot felaidila, zeṛe sairo mikka fani, tũwar har goiror fanir zalazontrona ãr uwottu guzorigilgoi. ");
INSERT INTO rhg_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ãi hoilam, ãre tũwar nozoror tolottu dure loi za oiye, ãi ki tũwar fobitro dórmogóror uzu hono din suk tuli sai no faijjum neki? ");
INSERT INTO rhg_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Doriyar faniye ãre giridoijje, foran foijjonto zar zar oiye, doriyaye ãre sairomikkattu giridoijje, ãr matat heṛiyar fezalota okkol beraiye. ");
INSERT INTO rhg_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ãi ḍufizaiore faharor gura foijjonto gilamgoi, ãr fise duniyair doroza sirohalolla ṭalamara oiye, tarfore o, oh ãr Allah Mabud, tũi ãr foranore morattu uwafes tuli anila. ");
INSERT INTO rhg_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ãr foran zẽtte zarzar oiye, hẽtte ãi Mabudore monot goillam, ãr munazat tũwar hãse, tũwar fobitro kaba górot fõssil. ");
INSERT INTO rhg_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Zara misa devdevire fũze, tara tarar asol muhabbotottu durezagoi. ");
INSERT INTO rhg_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Kintu ãi tũwar namor tarif šoho kurbani goriyum; ãi ze manoš goijji hiyan furon goriyum; ar uddar gora šudu Mabudor ham. ");
INSERT INTO rhg_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Bade Mabud he masore hokum dil, ar he mase Yunus nobire fuwana zagar uwore hogori bairgoridil. ");
INSERT INTO rhg_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Bade Mabudor kalam Yunus nobir uwore dusorabar naziloil. ");
INSERT INTO rhg_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Tãi hoil; Tũi uṛo, he moha šohor, Ninivit zo, ãi tũware zin hoito hoir, hin he šohorot guzori hoidogoi. ");
INSERT INTO rhg_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Toi Yunus nobi Mabudor hokum mozin Nineveh šohorot gil. Allar nozdikot ekkan ḍõr šohor, hiyanor ek ḍakottu ar ek ḍake zaite tin din lagito. ");
INSERT INTO rhg_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Bade Yunus nobi šohorot za šuru gori ekdinor fot foijjonto fõsil, tehon tãi guzori hoil: Ar sališ din bade Nineveh dongšo oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Tehon Nineveh šohoror manuš okkole Allare biššaš goijjil. Tara ruza elan goijjil, edde tara šoṛo ḍõr beggune salaršoṭ findil. ");
INSERT INTO rhg_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ar he hóbor zehon Ninevir badšar hãse fõsil, te o tar šingašonottu uṛi tar razfušak kulifelail edde salaršoṭ findi saior uwore boiššil. ");
INSERT INTO rhg_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ar te edde tar raz hormosari okkolor hokume ei hotagun guzori elan goridil: Manuš otóba fošu, goru sool honokiyo kissu no hok, tara hána fani mukot nodok. ");
INSERT INTO rhg_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kintu manuš edde zanuwar tara salaršoṭ findi zoto šombob Allare ḍakok. Ar fottikiye nizor nizor kufot edde kuhamottu firi aiyok. ");
INSERT INTO rhg_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Oitofare, Allah hantaoibo, ar monfiraibo edde tãir zolonto gušša hom goribo, ar ãra dongšo no oiyum. ");
INSERT INTO rhg_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Hetunot Allah tarar ham, tara ze zar zar kufotottu mon firaiyede deki, Allaye tarar uwore ze dongšo ḍakianibo hoil henttu mon firail, ar hen no gore. ");
INSERT INTO rhg_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Henot Yunus nobi moha narazoil edde guššaoil. ");
INSERT INTO rhg_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Tãi Mabudor hãse munazat gori hoil: Ya Mabud, in no neki ãi ãr nizor dešot takite hoilamde? Hetollana ãi toratori foilabar Toršišot daizaiboilla gilamgoide; haron ãi zaintam, tũi rahamoti edde doyaban Allah, aste gušša oya edde oṭol muhabbote mohan, ar šasti mafgoridite toiyar. ");
INSERT INTO rhg_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Hetolla ehon, o Mabud, foriyadgorir ãttu ãr foran horifelo kiyollahoile ãi zinda takattuwaro moron bala oibo. ");
INSERT INTO rhg_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Mabude hodde: Tui gušša oiosde ki bala oil? ");
INSERT INTO rhg_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Hẽtte Yunus nobi šohoror baire fuke ek zagat boiṛa aššil. Heṛe tãi nizolla ekkan zuguṛi baša banai heṛe tole sabat boiaššil, šohoror ki doša o hin saibar ofekkat. ");
INSERT INTO rhg_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Mabud Allah uggwa beronggas fuṛail; ar he gasore ḍõr gori Yunus nobir uwore annil, zene tãir matar uwore gasor sába o, edde tãittu biyaram no lage. Ar Yunus nobi he beronggasswa loi beši kuši oil. ");
INSERT INTO rhg_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Kintu tarfordin beil uṛibar age Allah uggwa log defeṛail, he loge oi beronggassware haṛifelail, he harone beronggasswa fuaigilgoi. ");
INSERT INTO rhg_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Bade zehon beil uṛil, Allaye fukali gorom bataš defeṛail, henot Yunus nobir matat endilla ze roid lagil, tãi beši durbol oi gilgoi, edde tãi moribolla foriyadgoijjil, hoil: Ãi zinda takattu aro moron bala oibo. ");
INSERT INTO rhg_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Tehon Allah Yunus nobire hodde: Oi beronggas šomonde rag gorilide iyan ki soiyi oil? Tãi hoil: Oy, iyanor haron ase, ãi guššaye moitto sai. ");
INSERT INTO rhg_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Allaye hodde: Tui ei beronggasolla honokissu no goros, ibare barai o no tulos, iba ek raite fuṭṭye edde ek raite mori gilgoi, tarfore o ei beronggasolla doya lager. ");
INSERT INTO rhg_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Toile ãi ki Ninevir ei moha šohoror uwore doya no goijjum? Heṛe endilla ek lak kuri hazarottu aro beši manuš ase, zara ḍen hat bam hat forokgori no zane; aro bout beši zanuwar okkol ase.");
INSERT INTO rhg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Allar Fut, Isa Mosir kušir hóboror babute šuru, ");
INSERT INTO rhg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Esaiyah nobir kitabot iyan zendilla leka ase: \"Sa, ãi tor age ãr hóborguware defeṛair, hite tor age zai tolla fõt saf goribo.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"Bošoti sara elehat ek abaze guzori zanai der, 'Tũwara Mabudor fõt ṭik goro, hibar rasta uzu goro.'\" ");
INSERT INTO rhg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","He mozin torikotor gusol doya Yahyaye bošoti sara elehat hazir oiye edde guna maf faibolla gunattu mon firaito edde torikotor gusol loito hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ehudiya beggullattu edde Zeruzalemor hár kiye niyoliyore hibar hãse giye. Hitara hitarar guna okkolore šikar goijje edde Zordan halot hibattu torikotor gusol loiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahyaye uṛor kẽšor hoor findito edde kĩyailot ekkan samorar duwali takito, ar hibaye firing edde fahari modu háiyore zibon haṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hibaye endilla hoi tobolig goijje: \"Ãi bade en ekzon aiyer ze ãttũwaro šoktiwala, edde ãi niyuriyore hibar zutar fita kúlidibar laikka o ãi no. ");
INSERT INTO rhg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ãi tũwarare fani loi torikotor gusol diyi, kintu hibaye tũwarare he Pak Ruh loi torikotor gusol dibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","He šomot Isaye Galilor Nasarat farattu aišše, edde Yahyattu Zordan halot torikotor gusol loiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hibaye fanittu uṛer mottor, asman fáṛi bag oiye edde dekedde Pak Ruh hoitoror ḍoilla oi hibar uwore lami aiyer. ");
INSERT INTO rhg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ar behostottu ei hota funa giye: \"Tui ãr he adoijja Fut, tor uwore ãi kub kuši.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iyar bade he Ruhuye hibare bošoti sara elehat loigiye, ");
INSERT INTO rhg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ar hiba heṛe sališ din aššil edde šoitane dúha diye. Hiba heṛe fahari zanuwar okkolor fũwati aššil, edde hibare firista okkole šeba goijje. ");
INSERT INTO rhg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yahyare ziyolot diya oi bade, Isaye Galilot aišše edde Allar kušir hóbor tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hibaye hodde: \"Ṭaim oiye, Allar raijjo tũwarar hãse aišše.Tũwara mon firo edde ei kušir hóbor biššaš goro.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ek bar hibaye Galil doriyar hãsa bai gil, hen šomot hibaye Simon edde hitar bái Anderiyaze doriyat zal feledde deikke, kiyollahoile hitara aššilde zailla. ");
INSERT INTO rhg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isaye hodde, \"Aiyo, ãr fisa lo, toi ãi tũwarare manuš doribar zailla banaiyum\" ");
INSERT INTO rhg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hehon hitara hitarar zal okkol felai raki Isar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Toi hentu ar hoddur mummikka zaiyore Sebdeusor futain Yakub edde hitar bái Yuhannare deikke, hitara not boiyore zal baz gorer. ");
INSERT INTO rhg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Toi hitarare deki mottor hibaye ḍak diye, ar hitara hitarar baf Sebdeusore muzur okkolor fũwati not diyore bade itara Isar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tarfore hitara Kofornahumot aišše, toi bade zehon dórmo din oiye, Isaye sinagogot giye edde šikka diye. ");
INSERT INTO rhg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Isar šikkat beggune tajjuf oiye, kiyollahoile hibaye alem okkolor ḍoilla gori šikka no de bolke hibaye hitarare kemota loi šikka diye. ");
INSERT INTO rhg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ehon, heṛe hitarar muzolišhanar butore bod ruhuye faiya ekzon manuš aššil. Hite ḍak mari hodde, ");
INSERT INTO rhg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"Oh, Nasarator Isa, õne loi ãrar loi ki talukkat? Õne ki ãrare naš goitto aiššo? Ãi zani õne honnuwa, õne to Allar he Pak zon!\" ");
INSERT INTO rhg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kintu Isaye hitare dõk diyore hodde,\"Nizam o, ei manušwar butottu niyoli ai.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Toi he bod ruhuye manušware doro gori musori doijje edde zure guzori hitar butottu niyoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ei hanḍo deki beggune tajjuf oiye edde hitara nizor butore howahoi goijje edde hodde, \"In ki? Ek noya šikka, kemota loi! Hibaye bod ruh okkolore hokum de, ar hitara hibar hota mane.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Toi hibar babute hóbor beši toratori Galil elehar hár mikka sorai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bade hitara muzolišhanattu niyoli zaigoi mottor, hitara Simon edde Anderiyazor górot giye. Yakub edde Yuhanna o hitarar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Heṛe Simonor hori zor biyaram loi bisanat fori taikke. Isa aišše mottor hitara hiyan hibare hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Toi Isa hibar ḍake zaiyore hibare hate dori tuille, henot hibattu zor sari giyegoi, ar hibaye hitarare mehemandari goijje. ");
INSERT INTO rhg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Beil ḍufigiyegoi edde hazinna oiye, manušzon okkole har biyaraimma okkolore edde bod ruhuye faiya manuš okkolore Isar hãse ainne. ");
INSERT INTO rhg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ar šohor ṭĩya aiyore dorozar munttu dola oiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isaye hár ḍoilla biyaraimma okkolore aram goijje edde bod ruh dafaiye. Kintu hibaye bod ruh okkolore hono hota hoito no de, kiyollahoile hiba Moside hiyan hitara zainto. ");
INSERT INTO rhg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tarforor din binna sore, andar takite Isaye uiṭṭe edde niyoli ekkan nirzon zagat giye, zeṛe hibaye duwa goijje. ");
INSERT INTO rhg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kintu Simon edde hitara Isare tuwaito giye, ");
INSERT INTO rhg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","toi hitara hibare tuwai faiyore hodde, \"Beggune õnor talaš gorer!\" ");
INSERT INTO rhg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Isaye hitarare hodde, \"Aiyo, ãra eṛiyar ate hãsor fara okkolot zai, zene ãi heṛe o tobolig gori fari, hiyanolla to ãi aiššiyi.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Toi hibaye Galilor hár mikka giye, sinagog okkolot šikka diye, edde bod ruh okkolore dafaiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ek kurus biyaraimmaye Isar hãse aiyore hibar sarme fot uite fori foriyad goijje, \"Õne issa gorile ãre foriškar gori fariba.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Manušwalla Isattu doya oiye, hat barai di hitare suiyore hodde, \"Ãi sai, tũi foriškar o!\" ");
INSERT INTO rhg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ar hehon hitattu kurus sari giyegoi edde hite foriškar oiye. ");
INSERT INTO rhg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Isaye hitare hora gori nišod goijje edde en hoiyore hehon dũrai diye: ");
INSERT INTO rhg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","\"Ei hota honokiyore no hois. Kintu zaiyore dórmiyo alem okkolore dehagoi, ar foriškar oi faijjosde hiyanolla Musar ain mozin kurbani gorgoi. Henot hitarar hãse tui foriškar oiyosde hiyanor forman oibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kintu manušwaye zaiyore hár zagat ei hóbor en bafe sorai diye, ziyanor zoriya Isaye ar hono ekkan šohorot kulasa gori goli no fare, kintu baire nirzon zagat taikke. Tarfore o hár zagattu manuš okkol hibar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hoekdin bade, Isaye zehon abar Kofornahumot aišše, edde hiba górot asede funa giye. ");
INSERT INTO rhg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Toi eto manuš dola oiye, dorozar bare udda ar zaga nu aššil. Hibaye hitarare kalam tobolig goijjede šomot, ");
INSERT INTO rhg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ekzon ãtur biyaraimmare loi hoekzon manuš hibar hãse aišše, manušware sairzone boi ainne, ");
INSERT INTO rhg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu zamila buli hitara hitare Isar hãse loizai no fare, hetolla Isa zeṛe aššil he borabor hitara góror salor uwore uiṭṭe edde ekkan fõt goijje, ar ze bisanar uwore ãtur biyaraimmawa aššil, hiyanor uwore gori hitare nise lamai diye. ");
INSERT INTO rhg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hitarar biššaš dekiyore, Isaye he ãtur manušware hodde, \"Fuwa, tor guna okkol maf gora oiye.\" ");
INSERT INTO rhg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Heṛe hoekzon alem boiṛa aššil edde hitara nize nize bafa šuru goijje, ");
INSERT INTO rhg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"Ei manušwaye endilla kiyolla hor? Hite kuferi gorer, šude Allah bade ar honokiye guna maf gori di no fare?\" ");
INSERT INTO rhg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hitara in okkol bafedde Isaye hibar dilor butore hehon buzi faijje, edde hibaye hitarare hodde,\"Tũwara dilot hendilla kiyolla sinta goror? ");
INSERT INTO rhg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ei ãtur biyaraimmare honnan howa asan oibo, 'tor guna maf gora oiye', ne naki 'tui uṭ, tor bisana lo edde aṭ'? ");
INSERT INTO rhg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kintu duniyait guna maf gori dibar kemota Adomor fuwattu ase, hiyan zene tũwara zani faro.\" Hen hoi Isaye he leng manušware hodde, ");
INSERT INTO rhg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"Ãi tore hoir, uṭ, bisana tuli loiyore gór zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hetunot hite uṛi hitar bisana tuli loiye edde beggunor sarmottu baire niyoli giyegoi. Henot beggune tajjuf oiye edde hitara Allar tarif goriyore hodde, \"Ãra endilla ar hono oktot no deki.\" ");
INSERT INTO rhg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isaye abar niyoliyore doriyar farot giye, heṛe beši manuš okkol hibar hãse aišše, toi hibaye hitarare šikka diye. ");
INSERT INTO rhg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tarfore hibaye fõt bai zat maze dekedde Alfeyusor fuwa Levi hazna adai gorede zagat boiṛa, Isaye hitare hodde, \"Ãr fisa lo\" Toi Leviye uiṭṭe edde hibar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tarfore Isaye hitar górot gorba giye, ar heṛe bout hazna adaigoroya okkol edde gunagar manuš okkol, Isa edde hibar sahabi okkolor fũwati hánar ṭebilot boišše, kiyollahoile boute aššil zara hibar fisa loil. ");
INSERT INTO rhg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Foroši dolor alem okkole zehon Isa hazna adaigoroya edde gunagar manuš okkolor fũwati hána hadde deikke, hitara sahabi okkolore hodde, \"Hibaye hazna adaigoroya edde gunagar okkolor fũwati kiyolla hána hár?\" ");
INSERT INTO rhg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isaye ei hota fuinne edde hitarare hodde, \"Araimma mainšottu ḍakṭoror dorhar nai, kintu biyaraimma mainšottu dorhar ase. Ãi forhesgar okkolore no, kintu gunagar okkolore ḍakito aišši.\" ");
INSERT INTO rhg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Foroši okkole edde Yahyar šagirit okkole ruza rakkil. Toi hoekzone Isar hãse aiyore fusar goijje, \"Foroši edde Yahyar šagirit okkole ruza rake, kintu õnor sahabi okkole kiyolla hen no gore?\" ");
INSERT INTO rhg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isaye hitarare hodde, \"Dula fũwati taite kengori dular fũwajja okkole ruza raki faribo? Dula zetodin hitarar fũwati ase, hitara ruza raki no faribo. ");
INSERT INTO rhg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kintu en šomoi aiyer, zẽtte hitarar hãsottu dulare loi zaiboi, edde toi he dinot hitara ruza rakibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","\"Honokiye furan kurutat noya horor tali no sila. Kiyollahoile, he furan kurutattu noya taligan siri aibo, ar henot hanagan aro ḍõr oibo. ");
INSERT INTO rhg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ar furan samorar hoillat honokiye tottoza šoraf no ḍale, kiyollahoile ḍalile šorafgune hoillagunore o fuṛaifelaibo, henot šoraf edde hoilla dunigun borbat oi zaiboi. No, tottoza šoraf noya samorar hoillat!\" ");
INSERT INTO rhg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Hono ek dórmor din Isaye fõtot hono ek gĩyuketi bai gil, ar hibar sahabi okkole ãṛi zat maze giyũrdanar sora sijje. ");
INSERT INTO rhg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Henot Foroši okkole hodde, \"So, ain mozin dórmor din zin gora mana hitara hin kiyolla gorer?\" ");
INSERT INTO rhg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hibaye hitarare hodde: \"Daud edde hibar fũwajja okkolottu zehon buk laggil edde haiddor obaf aššil hẽtte hibaye ki goijje, hin tũwara honodin no foro? ");
INSERT INTO rhg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Obiyator ḍõr imam aššilde ṭaimot, hibaye Allar górot goillil edde sarme rakkilde ruṭi háil, zin šude imam okkol sara ar honokiye háibar mana aššil. Hibaye aro hibar sãti okkolore o dil.\" ");
INSERT INTO rhg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Isaye hitarare aro hodde, \"Manušolla dórmodin gora oiyede, kintu dórmor dinolla manuš gora no o. ");
INSERT INTO rhg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hetolla Adomor Fut oilde dórmogóror uwore o malik.\" ");
INSERT INTO rhg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hiba abar sinagogot góille, ar heṛe ekzon hat mozigiyegoide manuš aššil. ");
INSERT INTO rhg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dórmor din Isaye hitare aram gore ne naki no gore hiyan saibolla hodune hibar uwore bala gori nozor raikke, toi zene hitara hibar berudde hosuri di fare. ");
INSERT INTO rhg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","He hat mozigiyegoide manušware Isaye hodde, \"Uṛi beggunor munttu ai tiya!\" Henot hite uṛi tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Toi hibaye hitarare fusar goredde: \"Dórmor din ki gora ezajot ase? Bala ham gora ne naki horaf ham gora? Foran basa ne naki foran dongšo gora?\" Kintu hitara nizam mari taikke. ");
INSERT INTO rhg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Isaye hitarar sairo mikka gušša gori saiye edde hitarar dil dorode dekiyore hibar dilor beši murot ferešan oiye, edde manušware hodde, \"Tor hattan mum mikka ṭan.\" Hite hen goijjebar hitar hattan ekkubare bala oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hetunot Foroši okkol baire giye edde Isare kene marifela za he babute Herudor dolor loi felain goijje. ");
INSERT INTO rhg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isaye sahabi okkolore fũwati loi lamat doriyar hãsat giye edde Galilottu ek ḍõr mainšor dole hibar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ar Ehudiyattu, Zeruzalemottu edde Idumiyattu, Zordanor dusora farottu edde Tiros edde Sidon elehar sairo mikkar zaga okkolottu beši manuš okkol, hibaye ze hár ham okkol goijje hin funiyore hibar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Toi hibaye sahabi okkolore hiballa ekkan no ṭik gori rakito hoiye, zene mainše hibare suibolla ṭelaṭeli gori hibar uwore no foregai. ");
INSERT INTO rhg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kiyollahoile hibaye bout manuš okkolore aram goijjil, hetolla biyaraimma okkole hibare suibolla mummikka ṭelaṭeli goijje. ");
INSERT INTO rhg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Napak ruh okkole zẽtte hibare dekito, hibar sarme meṛi uite fori guzori hoito, \"Õne Allar Fut.\" ");
INSERT INTO rhg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kintu hibaye hitarare kub hora gori hokum dito, zene hiba honnuwa hiyan hitara honokiyore no ho. ");
INSERT INTO rhg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tarfore hiba faharot uiṭṭegoi edde nizor issaye kissu manušore ḍaikke. Ar hitara hibar hãse giye. ");
INSERT INTO rhg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hibaye barozonore asab basona goijje zene hitara hibar fũwati fũwati take edde hibaye hitarare toboligot defeṛai fare, ");
INSERT INTO rhg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","edde bod ruh dafaibolla šokti fa. ");
INSERT INTO rhg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ze barozonore basi loiye hitara oilde: Simon (Zare hibaye Fitor nam diye.) ");
INSERT INTO rhg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebudiyusor dui fuwa Yakub edde Yuhanna, (ar ei duizonore hibaye nam diye Buwanerges, zar mani ṭaṛalor futain) ");
INSERT INTO rhg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderiyaz, Filip, Bartolomeus, Moti, Tomas, Alfeyusor fuwa Yakub, Táddeyus, Simon Zelot, ");
INSERT INTO rhg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Edde Ehudah Iskariyot, ze Isa loi beimani goijje. ");
INSERT INTO rhg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tarfore zehon hiba górot aišše, abar manuš okkol dola oiye, hetolla hiba edde hibar sahabi okkole kissu hái no fare. ");
INSERT INTO rhg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Isar nizor manuš okkole ei hóbor faiyore hibare henttu niyolai loi aišše. Hitara hodde, \"Iba fool oigiyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Zeruzalemottu aiššede alem okkole hodde, \"Hitar butore Belsebul ase! Butor raza Belsebulor modote ite but bair gore.\" ");
INSERT INTO rhg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Toi Isaye hitarare hibar hãse ḍaikke edde hitarare mesal kahani okkol loi hota hoiye: \"Šoitane kengori Šoitanore dafai faribo? ");
INSERT INTO rhg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Zodi raijjo ekkan nizor butore bag o, hiyan ṭiki tai no fare. ");
INSERT INTO rhg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Abar, zodi ekkan gór nizor butore bag o, toile he górgan o ṭiki tai no fare. ");
INSERT INTO rhg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ar ehon, zodi šoitane hitar nizor berudde tiya edde hitar nizor butore bag o, toile hite ṭiki tai no faribo. Hite heddurot šeš. ");
INSERT INTO rhg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kintu honokiye bolwala mainšor górot goli hitar dón šombotti luṭ gori no faribo, age zodi hite he bolwala manušware bandi no fele. Zodi bande, toi hitar górgan luṭ gori faribo. ");
INSERT INTO rhg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ãi tũwarare soiyi hoir, mainšor hár ḍoilla guna edde kuferi maf gora oibo, ");
INSERT INTO rhg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu ze honokiye Pak Ruhor berudde kuferi gore, hitarare hono din maf gora no oibo, bolke hite azibon gunar dai tai zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","\"Hibar butore ek napak ruh ase\" hitara hen hoilde hetolla hibaye ei hota hoiyede. ");
INSERT INTO rhg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tarfore hibar ma edde báiboinain okkol aišše. Hitara baire tiyai taki Isare aibolla hóbor defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Isar sairo ḍakottu hẽtte ek ḍõr mainšor dol boiṛa aššil. Hitara hodde, \"Õnor ma báiboinain okkol baire, edde õnor talaš gorer.\" ");
INSERT INTO rhg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Isaye hodde, \"Ãr ma, báiboinain hontara?\" ");
INSERT INTO rhg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Zara hibar sairo ḍakottu boišše, hitarar uzu saiyore hodde,\"So, itara oilde ãr ma, báiboinain okkol! ");
INSERT INTO rhg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kiyollahoile ze honokiye Allar issa falon gore, hitara oilde ãr bái, boin edde ma.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Isaye abar lamat doriyar hãsat manuš okkolore šikka diya šuru goijje. Hibar sairo ḍakottu eto beši ḍõr ek mainšor dol zoma oiye, hibaye halot ekkan not zai boiššegoi, ar manuš okkol doriyar farot tiyai aššil. ");
INSERT INTO rhg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hibaye mesal kahanir duwara bout kissur babute šikka diye edde hinor butore hibaye hodde, ");
INSERT INTO rhg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"Funo! Ekzon sašaye bizor dana šiṛibolla giye. ");
INSERT INTO rhg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Biz šiṛibar šomot, hodun biz fõtor kinare foijje, ar hin faik okkole aiyore háifelaiye. ");
INSERT INTO rhg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ar hodun biz šil meṛir uwore foijje, zeṛe beši meṛi nuaššil. Meṛi mur nuaššil boli hin toratori fuṛi uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kintu beil zehon uiṭṭe, hin hiṛa oigiyegoi edde šiyõr no takonor zoriya fuwai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Abar hodun biz keṛarzaliwala zagat foijje, keṛarzali bari uiṭṭe, hinore sibi dori raikke, hetolla hinot gula no dore. ");
INSERT INTO rhg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kintu abar hodun biz bala zobinot foijje edde fuṛi uiṭṭe edde gula doijje, kissuye ekšot gun, kissuye haiṭ gun, ar kissuye tiriš gun.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Toi hibaye hodde, \"Zattu funibar han ase hite funok!\" ");
INSERT INTO rhg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hiba zẽtte ekela oiye, he barozon asab edde aro zara fũwati aššil hitara he mesal kahaniganor babute hibattu fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Isaye hitarare hodde, \"Allar raijjor gufon soiyi tũwarare zanibolla šuzug diya oiye. Kintu zara baire ase hitaralla hár kissu mesal kahanir duwara howa oiye, ");
INSERT INTO rhg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","toi zene, \"'hitara sa kintu no deke, ar fune kintu no buze. Ar no oile hitara Allar mikka firito edde maf gori diya oito.'\" ");
INSERT INTO rhg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tarfore Isaye hodde, \"Tũwara zehon ei mesal kahanigan no buzor, toile kengori oinno mesalgunor mani buziba? ");
INSERT INTO rhg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sašaye šittede hin Allar kalam. ");
INSERT INTO rhg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fõtor kinarorgun oilde endilla manuš, zara kalam heṛe šiṭṭe, kintu zehon hin fuinna oiye, toi hehon šoitan aiyore hitarar butore ziyan šittil hiyan tuli loi zagoi. ");
INSERT INTO rhg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hendilla ekkui bafe zin šil meṛiwala zagat šiṛa oiye, hitara oilde hitara, zitara kalam fune edde toratori kuši mone hin gose. ");
INSERT INTO rhg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kintu hitarar butore šiyõr bala gori no boiye, hitara olfo dinolla tim take. Bade kalamolla boli zehon zulum aiye hetunot hitara fissa fori zagoi. ");
INSERT INTO rhg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abar zin keṛar zaliwalat šiṛa oiye, itara oilde hitara, zara kalam fune, ");
INSERT INTO rhg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kintu duniyaibi šongšari sinta bafona, dón šombottir maya edde aro oinno hár ziniš okkolor lalsi aiyore he kalamore sibi dore, hetolla hibat hono gula no dore. ");
INSERT INTO rhg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kintu zin bala zobinot šiṛa oiye, hitara oilde hitara, zara kalam fune edde hin gose, ar tirišgun, haiṭgun ar kissuye ek šotgun gula dora.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Isaye aro hodde,\"Ekzon zẽtte serag loi butore aiye, hiyan ki ugguwa laiyor nise otóba haṭor tole rake? Hiyan ki boiṛonir uwore no rakibo ne? ");
INSERT INTO rhg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kiyollahoile hono kissu lukaiya nai, zin forhaš no oi no takibo. Abar hono kissu gufon no takibo, kiyollahoile heṛe fohor aibo. ");
INSERT INTO rhg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zodi honokiyottu funibolla han take, toile hite funok!\" ");
INSERT INTO rhg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Toi Isaye hodde, \"Tũwara zin funor he babute diyan do! Zendilla mafoni loi tũwara mafo, tũwaralla o hendilla gori mafa oibo, bolke aro beši tũwarare diya oibo. ");
INSERT INTO rhg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kiyollahoile zattu ase, hitare aro diya oibo, kintu zattu nai, hitattu zin ase hin o loifela oibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hibaye aro hodde,\"Allar raijjo oilde endilla. Ekzon manuše zobinot biz šiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bade hite gum zar edde gumottu uṛer, rait or edde din or, eṛe bizottu šem fuṛer edde bari uṛer, kintu hin kengori or hin hite hoi no fare. ");
INSERT INTO rhg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Onegane zobinottu fodai gorer, foila sara, tarfore túr, bade túrottu sórat maze furafuri fõna dana. ");
INSERT INTO rhg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dana zehon faikke, hite hinot haši golai de, kiyollahoile hin daibar ṭaim oiye.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Abar hibaye hodde,\"Ãra ki loi Allar raijjor tulona goriyum? Hon mesal kahani hoiyore hiyan buzaiyum? ");
INSERT INTO rhg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hiyan uggwa horoir danar ḍoilla, ziba šiṛibar šomot duniyair hár dana okkolottuwaro šoṛo, ");
INSERT INTO rhg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu hiba zehon laga o, hiba bari uṛe edde ketor hár sara okkolottuwaro ḍõr o edde en ḍõr ḍõr ḍeila okkol fuṛe, asmanor faik okkole hibar sabar tole baha bande.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Endilla aro bout mesal kahani okkol loi hibaye hitarar buz mozin hitare kalam hoito. ");
INSERT INTO rhg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mesal kahani sara hibaye hitarare hono kissu no hoito, kintu zẽtte hibar nizor sahabi okkol loi ekela oito, hẽtte hibaye beggun hitarare buzai dito. ");
INSERT INTO rhg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","He din zẽtte hazinna oiye, hibaye sahabi okkolore hodde, \"Solo, ãra doriyar ofarot zai.\" ");
INSERT INTO rhg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hetunot mainšor dolore fissa felai rakiyore hitara Isa ze not boišše hiyanot gori loiye, aro dusora no okkol o hibar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bade kub beši bári ek tuwan uiṭṭe edde goiror fani nor butore foijje, toi nogan faniye furaiya owa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hẽtte Isa nor fis mikka balušor uwore gum giye. Hitara hibare ḍaki diyore hodde, \"Ustad, ãra ḍufi zairgoide ki õne kiyal no goror ne?\" ");
INSERT INTO rhg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Toi hiba uiṭṭe, boyarore dõk diye edde doriyare hodde,\"Nizam, šanti o.\" Henot boyar tamigiyegoi edde hár kissu hehon nizam oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hibaye sahabi okkolore hodde, \"Tũwara eto ḍoror kiyolla? Tũwarattu ehon o biššaš no o neki?\" ");
INSERT INTO rhg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Toi hitara beša beši ḍoraiye edde ekzonore ekzone hodde, \"Iba honnuwa? Boyar edde doriyar goire udda hibare mane!\" ");
INSERT INTO rhg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tarfore hitara doriyar dusora farot Geraseni okkolor dešot aišše. ");
INSERT INTO rhg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Isaye nottu laimme mottor, napak ruhuye faiya ekzon manuš hoboror gãtottu niyoliyore hibar muntu aiššiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ei manušwa hoboror gãt okkolot takito edde hitare honokiye bandi raki no farito, enki siyol loi udda no. ");
INSERT INTO rhg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kiyollahoile hitar hãt ṭeng hamiša beri edde siyol loi bandi raka oito, kintu hite siyol sirifelaito edde ṭengor beri bangi ṭura ṭura gorifelaito. Hitare honokiye samali no farito. ");
INSERT INTO rhg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hite dine raite hoboror gãt okkolot edde faharot guzori guri beraito edde fattor diyore nize nizor ga haṛito. ");
INSERT INTO rhg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Isare durottu dekiyore hite dũri aišše edde hibar fõt uite foijje ");
INSERT INTO rhg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","edde guzori hodde, \"Oh beši ḍõr šoktiwala Allar Fut, Isa, ãr loi õnor ki tallukat? Allar name duhai, õne ãre zala zontrona no diyo.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ei hota hoiyede moksud oilde Isaye hitare hoiye, \"Tui napak ruh, ei manušwar butottu niyoli ai.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tarfore Isaye hitare fusar goijje, \"Tor nam ki?\" Hite hodde, \"Ãr nam Bahini, kiyollahoile ãra beši.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Toi he elehattu hitarare niyolai no dibolla hite bar bar fori dori Isar hãse foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Heṛe faharor hãsat ḍõr ek šuworor zak soredde aššil. ");
INSERT INTO rhg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ar he napak ruh okkole fori dori foriyad gorilo, \"Ãrare oi šuworgunor butore defeṛo, toi zene ãra hin okkolor butore goli fari.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hibaye hitarare ezajot diye edde napak ruh okkol niyoli aiyore šuworgunor butore góille. Toi he šuworor zak, homsehom dui hazar oibo, hin okkol zure dũri faharor haindat giye edde doriyat fori fanit dufi moijje. ");
INSERT INTO rhg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Šuwor soroya okkole hentu dai giyegoi edde farat edde heṛiyar ato hãse sairo mikka ei hóbor hoiyegoi, toi manuš okkole ki goṭṭil hin saito aišše. ");
INSERT INTO rhg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hitara zẽtte Isar hãse aišše, dekedde oi napak ruhuye failde manušwa hor findi šuida oi boi roiye, henot hitarattu ḍore doijje. ");
INSERT INTO rhg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Zara ei goṭonagan dekkil, hitara he napak ruhuye failde manušwar edde šuworgunor ki halot oiye he babute mainšore zanaiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Henot manuš okkole Isare fori dori hoiye zene hiba hitarar eleha sari zagoi. ");
INSERT INTO rhg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Toi Isa not giye, ar napak ruhuye failde manušwaye hibar fũwati zaibolla foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kintu Isaye hitare ezajot no de edde en hoiye, \"Tui tor góror nizor mainšor heṛe firizagoi edde tolla Mabude ze ham goijje edde tor uwore hoto doya dehaiye hin beggun hitarare hogoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Toi hite hentu giyegoi edde Isaye hitalla zin goijje hin beggun Dekapolis elehat howa šuru goijje. Henot manuš okkol tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Isaye zẽtte abar no loi doriyar dusora farot gil, hẽtte hibar sairo ḍakottu ek mainšor ḍõr dol dola oil. Hiba hehon o doriyar farot, ");
INSERT INTO rhg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","hen šomot Zairus name ekzon muzolišhanar neta heṛe aišše. Hite Isare dekiyore hibar ṭengot uite foijje. ");
INSERT INTO rhg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","edde fori dori foriyad goijje, \"Ãr zi morar fõtot, õne aiyore hibar uwore hat rakogai toi hiba aram oi faribo edde basibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Toi Isa hitar fũwati giye. Ar ek ḍõr mainšor dol o fise fise gil edde hibar sairo ḍakottu ṭelaṭeli goijjil. ");
INSERT INTO rhg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Heṛe butore ekzon beṛi maya fuwa aššil ze baro bosorfan kunzari loi duk fat ase. ");
INSERT INTO rhg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bout ḍakṭor okkolor hatot hibaye bout hošṭo faiye. Ar hibattu ze kissu aššil hin beggun horos gori felaiye bade o hono kissu no o, aram oibar bodole aro beši oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hibaye Isar babute fuinne edde he mainšor dolor butore hibar fisottu aiyore hibar saddorgan suiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kiyollahoile hibaye baffil, \"Zodi ãi šude hibar hor sui fari, toile ãi aram oi zaiyumboi.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ar hehon hibar kunzari bondo oiye edde hibaye hibar gar butore buzi faijje ze hiba aram oiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Isaye hetunot buzi faijje ze hibar butottu šokti giye, hetolla hibaye mainšor dolor uzu saiyore hodde, \"Ãr hor hone suiye?\" ");
INSERT INTO rhg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sahabi okkole hodde, \"Õne dekor, õnore loi mainše kengori ṭelaṭeli gorer, ar tarfore o õne hoor, õnore hone suiye!\" ");
INSERT INTO rhg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kintu ei ham hone goijje hiyan saibolla Isaye sairo mikka saiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mayafuwawattu ken oiye buzi fariyore, hibaye ḍore hafi hafi Isar sarme uite foijje edde hibaye hár goṭonare hibare zanaiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Isaye hibare hodde: \"Oh zi, tor biššaše tore bala goijje, šantiye zagoi, tor ei duk bug gorodde hentu tui azad\" ");
INSERT INTO rhg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Isa ehon o hota howat ase, hen šomot muzolišhanar netar górottu manuš aiyore hodde, \"Tũwar zi mori giyoi. Ustadore loi aro kiyolla diddari gora forer?\" ");
INSERT INTO rhg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hitarar hota funiyore Isaye muzolišhanar netaware hodde, \"No ḍorais, šude biššaš gor.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ehon, hibaye Fitor, Yakub edde Yakubor bái Yuhanna, hitarare bade ar honokiyore fũwati zaito no de. ");
INSERT INTO rhg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bade hitara zehon muzolišhanar netar górot aišše heṛe dekedde uzora uzori oiye, edde manuš okkole handa haṛi gorer edde bilag gorer. ");
INSERT INTO rhg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isaye butore zai mainšore hodde,\"Tũwara uzora uzori edde handa haṛi kiyolla goror? Hiba no more, gum zadde.\" ");
INSERT INTO rhg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hitara hibar hotat hãšše. Toi hibaye beggunore góttu bare niyolai diye. He zerfuwar ma bab edde hibar sãti okkolore loiyore zerfuwawa zeṛe aššil heṛe butore góille. ");
INSERT INTO rhg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tarfore hibaye zerfuwaware hate doriyore hodde, \"Talita Kumi!\"ziyanor mani \"Gura zi, tore hoir, uṭ!\" ");
INSERT INTO rhg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ar hehon zerfuwawa uṛi tiyaiye edde aṛi bera šuru goijje. (Hibar boyoš aššilde baro bosor.) Ar hitara beggune kub beši ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kintu hibaye hora gori hokum diye zene ei babute honokiye no zane edde zerfuwaware hono kissu haito dibolla hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hiba henttu giyegoi edde nizor farat aišše, ar sahabi okkol o hibar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dórmor din zehon aišše, hibaye sinagogot šikka diya šuru goijje. Bout kiye zara hibar hota fuinne, hitara tajjuf oiye. Ar hodde, \"Ei manušwaye in honttu faiye? Ei giyan in hibare diyede hiba honnuwa? Abar hibaye keramoti ham o gorer? ");
INSERT INTO rhg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iba ki gas mistiri no neki? Iba ki Moriyamor fuwa no neki? Yakub, Yusuf, Ehudah edde Simonor bái no neki? Hitar boinain okkol ki eṛe ãrar fũwati no take?\" Ar endilla gori Isare loi mainšor dilot šondo aišše. ");
INSERT INTO rhg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hetunot Isaye hitarare hodde, \"Ekzon nobiye šude nizor farat, nizor egena edde nizor gór bade ar hár zagat ijjot fa.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hiballa heṛe hono ḍõr keramoti ham gora šombob no o, šude hoekzon ošuikka manušor uwore hibaye hat raikke edde hitarare aram goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hitarattu biššaš naide dekiyore hibaye ammuwak oiye. Tarfore Isaye sairo mikkar fara fara zai manuš okkolore šikka diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Hibaye he barozon asabore hibar hãse ḍaikke edde duizon duizon gori faṭai diye, hibaye hitarare napak ruhor uwore kemota diye. ");
INSERT INTO rhg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","In oilde hokum okkol: \"Baisar fõtolla šude ugguwa laṛi bade, ruṭi, gaṭṭi, zalit rufar foiša, hono kissu no loiyo. ");
INSERT INTO rhg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ṭengor šendal loiba, kintu ugguwa bazuttuwaro beši no. ");
INSERT INTO rhg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tũwara zẽtte ekkan górot goliba, he fara sari no zogoi foijjonto he górot taikko. ");
INSERT INTO rhg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ar hono zagat zodi hitara tũwarare no gose edde tũwarar hota no fune, toile he zagattu zaibar šomot ṭengor tolar dúil udda zari felaiyo zene hiyan hitarar berudde goba o.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Toi hitara giye edde manuš okkolor hãse hitara gunattu mon firaibar babute tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hitara bout napak ruh dafaiye edde bout ošuikka manuš okkolor matat tel diye, hitarare aram goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Isar bala nam ehon zana zani oigiyegoi boli badša Herude hibar babute fuinne. Kiye kiye hodde, \"Torikotor gusoldoya Yahya mora okkolor butottu uwafes zinda uiṭṭe, hetolla hibar butore keramoti šoktiye ham goredde.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ar kiye hodde, \"Hiba Eliyas\" Ar kiye hodde, \"Bout agor nobi okkolor ḍoil hiba o ekzon nobi.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kintu Herude zẽtte fuinne, hite hodde, \"Hiba he Yahya, zar ãi holla loilam, hiba morattu zinda uṛi giyegoide!\" ");
INSERT INTO rhg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kiyollahoile ei Herud, zibaye nize Yahyare dori anibolla manuš defeṛail edde hibare bandiyore ziyolot felai rakkil. Hite iyan goijjilde oilde Herudiya, ziba aššil Herudor bái Filipor biyata bou, zibare abar Herude biya goijjil. ");
INSERT INTO rhg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hiyanor zoriya Yahyaye hitare hoil, \"Tor bái bouwore tui biya gora hiyan tolla ain mozin no o.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hetolla Herudiyattu Yahyar uwore beši rag taigilgoi edde hibare marifelaito sail, kintu hibaye he mozin gori no fajjil. ");
INSERT INTO rhg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kiyollahoile Herude Yahya ekzon forhesgar edde Paki manušde hiyanolla boli hibare ijjot goitto edde hibare rokka goitto. Herude zẽtte Yahyar hotabatra funito, hẽtte hitar dilot beši goṭboṭ oi zaitoi, tarfore o kintu hite hibar hota funito. ");
INSERT INTO rhg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Šeše ek šuzug faiye. Herude hitar zormo dinor din hitar usol tokkar ofisar okkol, meliṭari komanḍar okkol edde Galilor zimmadar manuš okkol, itarare ugguwa hána diye. ");
INSERT INTO rhg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herudiyar zi aiyore naisse. Herud edde hitar meheman okkolore hibaye eto kuši goijje. Hetunot badšaye hodde, \"Tui zin sos ãi tore hin diyum?\" ");
INSERT INTO rhg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ar hite ziyore hosom haiyore wada goijje \"Tui zin sos, ãi tore diyum, enki ãr raijjo oddok udda.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ziye zaiyore hibar mare hodde, \"Ãi ki saiyum?\" Hibaye zuwabe hodde, \"Torikotor gusoldoya Yahyar matawa.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Zerfuwaye hehon zaiyore badšare hodde, \"Ekkan talot gori ãi torikotor gusoldoya Yahyar matawa ehon sai.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ei hota funi badša beši ferešan oiye, kintu meheman okkolor muntu hosom háiye boli ziyor hotare no fela. ");
INSERT INTO rhg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Toi badšaye hehon ekzon zollatore Yahyar matawa anibolla hokum loi defeṛaiye. Toi hite ziyolhanat zaiyore Yahyar mata haṛi loiyore, ");
INSERT INTO rhg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ekkan talot gori loi aišše edde hiba zerfuwaware diye, bade hibaye mataware hibar mare diye. ");
INSERT INTO rhg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ei hóbor hibar šagirit okkole funiyore hitar aišše edde hibar lašwa loizai ek hoborot raikkegoi. ");
INSERT INTO rhg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Asab okkol abar Isar hãse ekotro oiye edde hitara ki ki goijje hin edde manuš okkolore zin zin šikka diye hin beggunor babute hibare zanaiye. ");
INSERT INTO rhg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Toi, hibaye hitarare hodde, \"Ãr fũwati ekkan nirzon zagat aiyo zeṛe ãra alok oi faijjum edde ekka aram gorogai\" Kiyollahoile heṛe beša beši manuš okkol aza goijjil boli hitara hána háibar ṭaim udda no fail. ");
INSERT INTO rhg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hitara not gori ekkan nirzon zagat giye. ");
INSERT INTO rhg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kintu bout kiye hitara zadde dekiyore hitarare sini faijje, ar hár fara okkolottu manuš dũri age zai heṛe hazir oiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isaye nottu zehon laimme ek ḍõr mainšor dol dekilo. Hibattu hitarar uwore beši maya oiye, kiyollahoile hitara soroya sara soolor ḍoil oiye. Toi hibaye hitarare bout kissur babute šikka diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zehon din šeš oi aiššil, hetunot sahabi okkole Isar hãse aiyore hodde, \"Zagagan nirzon zaga, ar din o giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Itarare bidai gori do, zene itara ãte hasor zaga edde fara okkolot zai hána kini loi hái fare.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kintu hibaye zuwabe hitarare hodde, \"Tũwara hitarare hána do na\" Hitara hodde, \"Ãra ki zai dui šot dinaror ruṭi kini aniyore hitarare háito ditam neki?\" ");
INSERT INTO rhg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hibaye hitarare hodde, \"Tũwarattu ruṭi howa ase, zo sogoi.\" Toi hitara zai sai aiyore hodde, \"Fãssuwa ruṭi edde duwa mas.\" ");
INSERT INTO rhg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Toi hibaye hitara beggunore gurup gurup gori hail keror uwore buwai dibolla hitarare hokum diye. ");
INSERT INTO rhg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Manuš okkole laine laine ek šot ek šot, ar kiye fõnzašzon fõnzašzon gori boigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Toi hibaye fãswa ruṭi edde duwa mas loiyore asmanor mikka suk tui šukurana duwa zanaiye, ar ruṭigunore ṭura ṭura gori sahabi okkolor hãtot diye, zene hitara manuš okkolore hin baṛi di fare. Hendilla gori he mas duniware o hibaye bag gori diye, hitara beggunor maze baṛi dibolla. ");
INSERT INTO rhg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hitara beggune feṭbori háiye. ");
INSERT INTO rhg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tarfore sahabi okkole baro barang banga ruṭi edde mas feṛai loi dola goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Háilde hitarar butore onumanik fãs hazar morodfuwain aššil. ");
INSERT INTO rhg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ar Isaye hehon hibar sahabi okkolore not uiṭṭo hoiye zene hitara hibar agottu zai dusora farot, Betsaidar mikka za, ar eṛe hiba nize manuš okkolore bidai goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Toi manuš okkolottu bidai loi bade hiba munazat goribolla uwore faharot giye. ");
INSERT INTO rhg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Toi zehon hazinna oiye, nogan doriyar maze aššil, hiba eṛe ekela zobinor kulot tai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hibaye dekedde hitara beši hošṭo gori dar bar, kiyollahoile bataš hitarar uzan aššil. Dolfohor oibar age hiba doriyar uwottu ãṛiyore hitarar heṛe aišše. Hibaye hitarar ḍak bai zafan goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kintu hibaye fanir uwottu aṛedde dekiyore hitara but deker boli mone goijje edde kiskisai uiṭṭe, ");
INSERT INTO rhg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kiyollahoile hibare dekiyore beggune ḍoraiye. Isaye hehon hitara loi hota hoiye edde hodde,\"Iba ãi, no ḍoraiyo!\" ");
INSERT INTO rhg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Toi hiba hitarar not uiṭṭe edde bataš tamigiyegoi, edde hitara beši ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kiyollahoile ruṭir goṭona ziyan goṭṭil hiyan hitara buzi no fare, kiyollahoile hitarar dil doro taki gilgoi. ");
INSERT INTO rhg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Toi hitara okule zehon faraiyore Gennesaretot tiya goraiye edde nogan bainde. ");
INSERT INTO rhg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hitara nottu laimme mottor, manuš okkole hibare sini faijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Edde hitara he elehar butore hár mikka dũra dũri gora šuru goijje edde ošuikka manuš okkolore haiṭṭat gori hiba zeṛe ase boli fuinne heṛe ana šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ar hiba šohorot, farat otóba geramot, hiba zeṛe giye heṛiyar manuš okkole biyaraimma okkolore aniyore bazaror butore dola goijje, ar hitara hibare foriyad goijje zene hitara šude hibar saddoror hãsagan oile sui fare. Ar zeduggune hiyan suiye, hitara beggune aram oiye. ");
INSERT INTO rhg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ar Zeruzalemottu aiššede hoekzon Forošiye edde dormiyo aleme Isa loi dola oiye. ");
INSERT INTO rhg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hitara Isar sahabi hoekzone napaki abostat mani hat no duiyore hána háito boiššede deikke. ");
INSERT INTO rhg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Foroši okkole, edde hár Ihudi okkole hitarar furana amolottu loti soli aiyedde niyomore maniyore, hitara hat no duiyore hána no há. ");
INSERT INTO rhg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bazarottu aiyore hitara hat ṭeng no duite kissu no há. Hendilla dusora aro bout kissu hitara falon gorede ase, zenneki fiyala, gora edde tamar gala, haṭ falong, in okkolore dúwa. ");
INSERT INTO rhg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Toi Foroši okkole edde dormiyo alem okkole hibare suwal goijje: \"Furana amolottu loti soli aiyedde niyomore kiyolla tũwar sahabi okkole no maner, kintu hitara aduiya hate ruṭi hár?\" ");
INSERT INTO rhg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Toi hibaye hitarare zuwabe hodde, \"Tũwara munafek okkolor babute nobi Esaiyaye ṭik hoi giye, iyan zendilla leka ase: \"'Ei zatiye ãre hitarar mukor uwottu šorman gore, kintu hitarar dil ãttu bout dure. ");
INSERT INTO rhg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","hitara ãre mani sara fũza gore, hitarar šikka okkol mainšor diya ain okkol.' ");
INSERT INTO rhg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Allar hokumgunore bad goriyore, tũwara mainšor rosomore falon goror.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ar hibaye hitarare hodde,\"Oi, Allar hokum bad goriyore tũwarar nizor rosom salu rakibolla tũwarattu kub šundojja rasta ase! ");
INSERT INTO rhg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Zendilla Musaye hoiye, 'Ma bafore šorman goro,' ar, 'Ze honokiye nizor baf mare bura hota ho hitare marifela oibo.' ");
INSERT INTO rhg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kintu tũwara ho, honokiye hitar ma otóba bafore ho, 'ãttu ze ziniš loi tolla modot oito, hin kurban' mani Allar hãse kurbani gora oiye. ");
INSERT INTO rhg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Hen oile, tũwara hitare hitar baf edde malla hono kissu gorattu bad goror. ");
INSERT INTO rhg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ei bafe tũwara Allar kalamore batil goriyore tũwara ze rosom faiyo hiyanore zari raikko. Aro bout kissu ase tũwara hendilla gorode.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tarfore Isaye manuš okkolore abar ḍakiyore hodde, \"Tũwara beggune ãr hota funo edde buzo! ");
INSERT INTO rhg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","En hono kissu nai zin manušor butore zaiyore hitare napak gori fare, bolke zin manušor butottu niyoli aiye hine napak gore. ");
INSERT INTO rhg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Zattu funibar han ase, hite funo!\" ");
INSERT INTO rhg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tarfore Isaye mainšor dolore eri górot góille, hetunot hibar sahabi okkole he mesal kahaniganor manir babute fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Isaye hitarare hodde, \"Tũwara kissu no buzo? Tũwara buzi no faror ne, hono kissu zin mainšor butore gole hine hitare napak gori no farede? ");
INSERT INTO rhg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kiyollahoile, hin hitar dilot no gole, kintu feṛot za ar tarfore gar bair oi zagoi.\" Ei hota loi Isaye buzai diye ze, hono ḍoilla hána napak nai. ");
INSERT INTO rhg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hibaye aro hodde,\"Mainšor butottu zin niyoli aiye, hine manušore napak gore. ");
INSERT INTO rhg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kiyollahoile butottu, manušor dilor butottu, he horaf sinta okkol niyoli aiye: Beššagiri, suri, kun, ");
INSERT INTO rhg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","zena, lub lalsi, horafi, oinnore hotigora, dúhabazi, bíyaṛa hota, kukiyal, gibod, nizore loi ohonkari gora, bekufai. ");
INSERT INTO rhg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ei horaf in okkol beggun ekzon manušor dilor butottu niyoli aiye edde hitare napak gore.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bade hiba uiṭṭe edde hentu Tiros elehat giye, heṛe hiba ek górot góille. Ar sail hiyan zene honokiye zani no fare, kintu hiba lukai taki no fare. ");
INSERT INTO rhg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ar hehon ek mayafuwa, zattu ek gura zi aiššil edde napak ruhuye fail, Isar babute funiyore aišše edde hibar fõt uite foijje. ");
INSERT INTO rhg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","He mayafuwawa aššilde Girik zuban hoiya, Siriya-Fonikiyar zormo, toi hibaye Isar hãse foriyad goijje hibaye zene hibar ziyor butottu he napak ruhure bair gori de. ");
INSERT INTO rhg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kintu Isaye hibare hodde,\"Age futziyainde feṭ bori háok, kiyollahoile futziyaindottu ruṭi loiyore hin kũirore diya hiyan bala no.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Toi hibaye zuwab diye edde hodde, \"Oi, Malik, kintu kũir okkole o hánar ṭebilottu futziyaindor hánar guragara zin tole fore hin há.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Toi Isaye hodde,\"Tui endilla hoiyosde hiyanolla, ãi tore hoir, tui za, tor ziyor butottu napak ruh niyoli giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ar hibaye górot aiyore dekedde, ziwa bisanat neṛi taikke edde napak ruhuye sari giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Toi abar, hibaye Tiros eleha sari Sidon šohoror butottu diyore Galil doriyar hãsa hãsi Dekapolis elehar fara okkolot giye. ");
INSERT INTO rhg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Heṛe hodun mainše ekzon manušore hibar hãse ainne, ze aššil nafang edde túta, ar hitar uwore hat rakibolla hitara hibar hãse foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isaye he manušware mainšor dolottu ek ḍaikka loizaiyore hibaye hitar dui hanot õl diye, ar sef loiyore hitar zilot ḍoille. ");
INSERT INTO rhg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tarfore hibaye asmanor mikka saiyore ek ḍor niyaš felaiye edde hitare hodde,\"Effata\" mani \"kuli zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Henot hehon manušwar han kula oigiyegoi edde alazilgan eridiya oigiyegoi, ar hite foriškar gori hota howa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hibaye hitarare hokum diye zene honokiyore no ho, kintu hibaye zeto no hoito hoiye, heto hitara aro beši gori elan goijje. ");
INSERT INTO rhg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Manuš okkole kub beši ammuwak oiye edde tajjuf oiyore hodde, \"Hibaye hár ham zin gorer hin bala. Hibaye nafange funefan edde buke hota hoi farefan gorer.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ar ek bar hẽtte ek ḍõr mainšor dol dola oiye, edde hitarattu háibolla kissu nu aššil. Toi Isaye sahabi okkolore hibar hãse ḍaikke edde hodde, ");
INSERT INTO rhg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"Ei manuš okkololla ãr dilot doya or, kiyollahoile itara aijja tin din dori ãr fũwati ase, ar hitarattu háibolla hono kissu nai. ");
INSERT INTO rhg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Zodi ãi itarare uwašša górot defeṛai toile hitara fõtot bangi fori zaiboi, kiyollahoile eṛe kiye kiye bout durottu aiššede ase.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sahabi okkole hodde, \"Ei nirzon zagat itarare habaibolla edun ruṭi hontu faibo?\" ");
INSERT INTO rhg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isaye hitarare hodde, \"Tũwarar hãse howa ruṭi ase?\" Hitara zuwabe hodde, \"Hãttuwa\" ");
INSERT INTO rhg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Toi hibaye manuš okkolore meṛit boibolla hokum diye. Bade he ruṭi hãttuwa loi hibaye Allare šukuriya zanaiye, hinore bangi hibar sahabi okkolore diye zene hitara manuš okkolore baṛi de, ar hitara hinore manuš okkolore baṛi diye. ");
INSERT INTO rhg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hitarattu hougguwa šoṛo mas o aššil. Hibaye hinore loi duwa goijje edde hin o hitarare baṛi dito hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ar hitara feṭ bori hái faijje, tarfore ze ṭura okkol fori roiye hin sahabi okkole tuli loiyore hãt barang oiye. ");
INSERT INTO rhg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Heṛe onumanik sair hazar manuš aššil. Tarfore hibaye hitarare bidai diye. ");
INSERT INTO rhg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ar hibaye sahabi okkolore loi hehon not giye edde Dalmanuta elehat aišše. ");
INSERT INTO rhg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Foroši okkole aišše edde Isa loi barabari gora suru goijje. Hibare forikka goribolla hitara hibare behostottu ekkan sinno dehaito hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Henot hibaye dilor beši murottu dukke hodde, \"Ei halor manuš okkole sinno kiyolla tuwa? Ãi tũwarare soiyi hoir, itarare hono sinno deha no oibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tarfore hibaye hitarare eri zai abar not uṛi dusora farot giye. ");
INSERT INTO rhg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kintu sahabi okkolottu ruṭi loite monot nuaššil, hitarattu šude ugguwa ruṭi bade not maze ar hono kissu no aššil. ");
INSERT INTO rhg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hen šomot Isaye hodde, \"Tũwara hũšiyar, Foroši edde Herudor išottu šabdan taikko.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kintu hitara hitara howa hoi goijje: \"Ãrattu ruṭi nai boli hibaye ei hota hodde.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isaye hitara ki hodde buzi fariyore hodde,\"Tũwarattu ruṭi naide he babute kiyolla howahoi goror? Tũwara ehono buzi no faro ne? Tũwarar dil ki koṭin oigiyegoi neki? ");
INSERT INTO rhg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tũwarattu suk takiyore o ki deki no faror? Han takiyore o ki funi no faror? Ar tũwarattu monot nai ne? ");
INSERT INTO rhg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ãi zẽtte fãs hazar manušolla fãswa ruṭi bangilam hẽtte tũwara ho barang ruṭir ṭura feṛai loi dola goijjila?\" Hitara zuwabe hodde, \"Baro barang\" ");
INSERT INTO rhg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","\"Ar ãi zẽtte he sair hazarolla hãttuwa ruṭi bangilam hẽtte tũwara ho barang ruṭir ṭura feṛai loi dola goijjila?\" Hitara hodde \"Hãt barang\" ");
INSERT INTO rhg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hibaye hitarare hodde, \"Toile tũwara ehono kissu buzi no faror?\" ");
INSERT INTO rhg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bade hitara Betsaidat aišše, heṛe hodun mainše ekzon andare Isar hãse loi aišše, ar he manušware suibolla hibare foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Isaye he anda manušware hate dori farar baire loigiye. Tarfore hitar sukot sef diye edde hitar uwore hat raikke edde fusar goijje, \"Tui ki hono kissu dekor ne?\" ");
INSERT INTO rhg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hite saiye edde hodde, \"Ãi manušore dekir, hitarare saite gasor ḍoilla, aṛerfan lager.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ar ek bar Isaye he manušwar sukor uwore hat raikke. Toi suk kuligiyegoi, ar hite aram oiye edde beggun foriškar gori deki faijje. ");
INSERT INTO rhg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Isaye en hoiyore hitare górot faṭai diye,\"Farar butore no zais.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isa edde hibar sahabi okkol Sesariyar Filifir atehasor šohoror okkolot aišše, fõtot hibaye hitarare fusar goredde, \"Ãi honnuwa, ei babute manuš okkole ki ho?\" ");
INSERT INTO rhg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hitara zuwabe hodde, \"Torikotor gusol doya Yahya, kintu kiye kiye ho nobi Eliyas, ar kiye ho nobi okkolor butottu ek nobi.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Toi hibaye hodde, \"Ar tũwara, tũwara ki ho ãi honnuwa?\" Toi Fitore zuwab diye, \"Õne he Mosi.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Isaye hitarare hũšiyari diye zene hitara hibar babute honokiyore no ho. ");
INSERT INTO rhg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bade Isaye hitarare šikka diya šuru goijje ze Adomor Futottu beši duk bug gora foribo edde hibare murobbi okkol, ḍõr imam okkol edde alem okkole batil goribo. Hibare mari fela oibo, edde tin dinor din bade abar uṛi zaibogoi. ");
INSERT INTO rhg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hibaye ei babute kulasa gori hoiye. Toi Fitore hibare ek ḍaikka loizaiyore jejeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kintu Isaye firiyore sahabi okkolor mikka saiye edde Fitorore dõk diyore hodde, \"Šoitan, ãr hãsottu dur o, Allaye ziyan issa gorer tottu hiyanor baf nai, kintu šude manuše ziyan sa hiyan bafos.\" ");
INSERT INTO rhg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Toi hibaye sahabi okkol edde oinno manuš okkolore ḍakiyore hodde, \"Honokiye zodi ãr fise aito issa gore, hite nizore ošikar gorok edde hite fotti din nizor kuruš handot loi ãr fise fise aiyok. ");
INSERT INTO rhg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kiyollahoile ze honokiye hitar nizor zibon basaito sa hite hiyan haraibo, kintu ze kiye ãlla boli edde kušir hóborolla hitar foran hara hite hiyan basaibo. ");
INSERT INTO rhg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Zodi ekzone šara duniyai hamaiye, kintu hitar asol foran haraifele, toile hitar ki lab oiye? ");
INSERT INTO rhg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ar hite ki kissu diyore asol foran hiyan uwafes firai faibolla kissu ase? ");
INSERT INTO rhg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ei halor beiman edde gunagar manuš okkolor butore zodi honokiye ãre edde ãr hota loi šorma, Adomor Fut zẽtte pak fobitro firista okkolor fũwati hibar Bafor tozolli loi aibo, hẽtte hibaye o he manuš okkolore šormaibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Toi hibaye hitarare hodde, \"Ãi tũwarare soiyi hoir, eṛe tũwarar butore en hozon ase zara Allar raijjo beši ḍõr šokti loi aiššede no deke foijjonto hitara hono mote moutor fiyala no fibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iyar so din bade, Isaye Fitor, Yakub, edde Yuhanna, itarare fũwati loi ek usol faharor uwore giye, zeṛe hitara ekela aššil. Hitarar sarme hibar siyara bodoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hibar fušak en dola oi giyegoi zenneki duniyair hono dufiye hor duiyore hendilla dola gori no faribo. ");
INSERT INTO rhg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Toi heṛe Musa edde Eliyase hitarare deha diyore Isa loi hota hor. ");
INSERT INTO rhg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Toi Fitore Isare hodde: \"Ustad, ãra eṛe aside bala oiye. Ãra tinnan bãša banai, ekkan õnolla, ekkan Musalla, ar ekkan Eliyasolla.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Kintu Fitore ki hoibo hiyan hibaye buzi uṛi no faijjil, kiyollahoile hitarare beši ḍore doijjil.) ");
INSERT INTO rhg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Toi ekkan miyula aiyore hitarare guri felaiye, edde he miyular butottu ek abaz aišše, \"Iba ãr he adoijja Fut, tũwara hibar hota funo!\" ");
INSERT INTO rhg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bade hehon sahabi okkole sairo mikka saiye kintu Isa sara heṛe ar honokiyore no deke. ");
INSERT INTO rhg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Faharottu lami aiyedde šomot, Isaye hitarare hokum diye ze hitara zin dekkil hin Adomor Fut morattu uwafes zinda no uṛe foijjonto honokiyore no ho. ");
INSERT INTO rhg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hitara ei hokum mainne, edde morattu uwafes zinda uṛar mani ki hiyan hitara hitarar butore biyasana goijje. ");
INSERT INTO rhg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Toi hitara hibare fusar goredde, \"He alem okkole kiyolla ho ze Mosi aibar age Eliyasottu aiya foribo?\" ");
INSERT INTO rhg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zuwabe Isaye hodde, \"Oi, ei hota soiyi, Eliyase age aiyore hár kissure agor abostat firai anibo. Toile endilla kiyolla leka ase ze Adomor Fute beši duk bug goribo edde hibare batil gora oibo? ");
INSERT INTO rhg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kintu ãi tũwarare hoir, Eliyasor babute pak kitabot zendilla leka ase hiba he mozin aiššil, ar hitara hibar uwore hitarar issa mozin hár kissu goijje.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Toi hitara zẽtte he dusora sahabi okkolor hãse firi aišše, dekedde oi sahabi okkolor sairo ḍakottu ek ḍõr manuš dol zoma oiye edde hoekzon aleme hitara loi barabari diye. ");
INSERT INTO rhg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mainše Isare deikke mottor hitara kub beši tajjuf oiye edde dũri zaiyore hibare solam zanaiye. ");
INSERT INTO rhg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Toi Isaye hitarare fusar goredde,\"Tũwara utara loi kiyor babute barabari goijjilade?\" ");
INSERT INTO rhg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dolor butottu ekzone zuwab diye, \"Ustad, ãi ãr fuware loi õnor hãse aiššide, kiyollahoile hitare ek ruhuye faiye, zibaye hitare buk gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hibaye zẽtte hitare dore hetunot asari meṛit felaide. Hitar galottu fena ane ar dat loi dat goše edde ebbe doro oi zagoi. Ei ruhure dafaidibolla ãi õnor sahabi okkolore foriyad goijjilam, kintu hitara no fare.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hetunot Isaye hodde,\"Oh obiššaši manuš okkol! Ar hotokal ãi tũwarar fũwati takiyum, ar hotokal tũwarare bordaš goriyum? Tor fuware loi eṛe ai!\" ");
INSERT INTO rhg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Toi hitara hitare ainne. Hetunot he ruhuye zehon hibare deikke, hehon kub zure musori doijje, toi fuwawa meṛit fori giyegoi edde goijja šuru goijje, ar galottu fena ainne. ");
INSERT INTO rhg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isaye fuwar bafore fusar goredde, \"Itattu endilla oiyede hotodin oiye?\" Manušwaye hodde, \"Šoṛo halottu loti. ");
INSERT INTO rhg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bout bar ei ruhuye hitare marifelaibolla oinot edde fanit felaidil. Kintu õne zodi kissu gori faribade oile, toile ãrar uwore doya deho edde modot goro.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Isaye hitare hodde, \"'Zodi ãi gori farile mani?' Ze biššaš gore hitalla hár kissu šombob.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hetunot fuwar bafe guzori hodde, \"Ãi biššaš gori, ãr butore ze obiššaš ase hin dur gori do!\" ");
INSERT INTO rhg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bout manuš okkol dũri aiyedde dekiyore Isaye he ruhure dõk diyore hodde, \"Oh nafang edde buk ruh, ãi tore hokum dir, hitar butottu niyol, hitar butore ar hono din no gólis.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hetunot ruhuye guzori fuwaware zure musori doijje edde hitar butottu niyoli giyegoi. Henot fuwawa morar ḍoil oi fori roiye edde beggune \"hite morigiyegoi\" boli hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kintu Isaye hitare hate doijje edde modot goijje, toi hite uṛi tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tarfore zehon Isaye góror butore giye, toi sahabi okkol hibar fũwati ekela aššil, hitara fusar goijje, \"Ãra kiyolla ibare dafai no fari?\" ");
INSERT INTO rhg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Isaye hodde,\"Endillagunore šude munazat edde ruzar duwara dafa šombob.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bade hitara hentu uṛi baisa diye edde Galil elehar butottu di giye ar hiyan hono kiye zani farok hibattu issa nuaššil, ");
INSERT INTO rhg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kiyollahoile hibaye hibar sahabi okkolore šikka diyat aššil. Hibaye hitarare hodde,\"Adomor Futore manuš okkolor hatot tuli diya oibo. Hitara hibare mari felaibo, ar tin dinor din hiba uṛi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kintu hibaye ki hoiye hin hitara buzi no fare ar he babute fusar goitte o ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hitara Kofornahumot aišše, toi hitara góror butore zehon oiye, hibaye hitarare fusar goijje, \"Tũwara fõtot kiyor babute barabari goijjilade?\" ");
INSERT INTO rhg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kintu hitara nizam oi roiye, kiyollahoile fõtot hitara hone beggunottuwaro ḍõr he babute ekzone ekzon loi hotabartra hoil. ");
INSERT INTO rhg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Toi hibaye boišše edde he barozonore ḍakiyore hodde, \"Zodi honokiye beggunor age oito sa toile hitattu beggunor šešottu taka foribo, ar beggunor šeba goroya owa foribo.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bade hibaye ugguwa gura fuware loiye edde hitarar maze tiya goraiye. He gura fuwaware hibaye ãza mari loiyore hodde, ");
INSERT INTO rhg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"Ze honokiye ãr name itar ḍoilla hono gura fuware gose, hite ãre gose. Ar ze ãre gose hite šude ãre gosede no, bolke hibare gose, ze ãre defeṛaiye.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhannaye Isare hodde, \"Ustad, õnor name ekzon mainše napak ruh saradde dekkilam, hite ãrar dolot nuaššil hetolla buli ãra hitare mana goijjilam.\" ");
INSERT INTO rhg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Isaye hodde, \"Hitare mana no goijjo, kiyollahoile ãr name ekkan keramoti ham gori bade hehon honokiye ãr babute horaf hoi no faribo, ");
INSERT INTO rhg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","kiyollahoile ze ãrar bifokke no hitede ãrar fokke ase. ");
INSERT INTO rhg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ze honokiye tũwarare ek kaf fani fi haito de, kiyollahoile tũwara Mosir manušde hetolla Ãi tũwarare soiyi hoir: Hite hitar enam no haraibo. ");
INSERT INTO rhg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","\"Ar ze honokiye ãr uwore biššaši ei šoṛo okkolor butottu honokiyore gunar fõtot loi za, toile hitare golat ugguwa ḍõr fattor bandi di doriyar mur fanit felai diya, bolke hitalla aro beši bala oibo. ");
INSERT INTO rhg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tũwar hate zodi tũware gunat felaito sa, toile he hat haṛi felai do. Dui hat loi jahannamot, ze oin hono din no nifibo, heṛe golattuwaro, bolke tũṛa oi akeri zibonot gola tũwalla bala oibo. ");
INSERT INTO rhg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Zeṛe log okkole hitarare hár, hin no morer, edde oinor zilha no nifer.) ");
INSERT INTO rhg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tũwar ṭenge zodi tũware gunat felaito sa, toile he ṭeng haṛi felai do. Dui ṭeng loi jahannamot feli diyattuwaro, bolke tũṛa oi akeri zibonot gola tũwalla bala oibo. ");
INSERT INTO rhg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Zeṛe log okkole hitarare hár, hin no morer, edde oinor zilha no nifer.) ");
INSERT INTO rhg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tũwar ek suke zodi tũware gunar fõtot ṭane, toile hiba niyalaifelo. Dui suk loi jahannamot felaidiya oibade hiyanottuwaro, bolke ek suk loi Allar raijjot gola tũwalla aro bala oibo, ");
INSERT INTO rhg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","zeṛe, \"'log okkole hitarare hár, hin no morer, ar oin o no nifer.' ");
INSERT INTO rhg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kiyollahoile fotti manušore oin di forikka gora oibo, zendilla kurbanire nun di pak saf gore. ");
INSERT INTO rhg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","\"Nun bala ziniš, kintu nunottu zodi nunor moza zagoi, toile hin ken gori abar nun oi faribo? Tũwarar dilot nun rako edde tũwara ekzone ar ekzon loi šantit tako.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bade Isa hentu uiṭṭe edde Ehudiya Elehat edde Zordanor dusora farot giye. Abar hibar hãse manuš okkole ai zoma oiye, ar hibaye hibar niyom mozin hitarare šikka diye. ");
INSERT INTO rhg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","He šomot hoekzon Foroši aišše edde hibare forikka gori saibolla fusar goijje, \"Ekzon manuše hitar nizor bouwore sarifela iyan ki ain mozin?\" ");
INSERT INTO rhg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Isaye hitarare hodde,\"Musaye tũwarare ki hokum diye?\" ");
INSERT INTO rhg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hitara hodde, \"Ekzon manuše hitar nizor bouwore sarhabos diyore dũrai dibar ejazot Musaye diye.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Toi hibaye hitarare hodde,\"Tũwarar dil koṭin boli Musaye tũwaralla ei ain leikke, ");
INSERT INTO rhg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kintu sirištir šuruttu loti Allaye 'hitarare maya edde morod gori sirišti goijje.' ");
INSERT INTO rhg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Hetolla manuše hitar bab mare erizaibo edde hitar bou loi ek oibo, ar hitara duizon ek ga oibo, ");
INSERT INTO rhg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ar hitara duizon ek ga oibo;' hetolla hitara ar dui nai, kintu ek ga. ");
INSERT INTO rhg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hetolla ziyan Allaye ekku fũwati zug goijje, manuše hiyanore aleda no gorok.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Toi góror butore hibar sahabi okkole ei ekkui befare Isare abar suwal goijje. ");
INSERT INTO rhg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Hibaye hodde, \"Ze honokiye nizor bouwore sari diyore ar ekzonore biya gore hite hitar bouwor berudde zena gore. ");
INSERT INTO rhg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ar zodi ekzon mayafuwaye hibar nizor zamaire sari diyore ar ekzon loi biya gore, toile hibaye o zena gore.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hitara gura fuwain okkolore o Isar hãse ainne, toi zene hibaye hitarare sui fare, kintu sahabi okkole hitarare gozgozaiye. ");
INSERT INTO rhg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Isaye hen dekiyore hiba beši naraz oiye edde hitarare hodde,\"Gura fuwaindore ãr hãse aito do, ar hitarare banda no diyo, kiyollahoile Allar raijjo itarar ḍoilla mainšor. ");
INSERT INTO rhg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ãi tũwarare soiyi hoir, ze honokiye ugguwa gura fuwar ḍoilla oi Allar raijjo no gose, hite hono mote heṛe goli no faribo.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tarfore Isaye he gura fuwaindore hate ãza mari loiye, edde hibar hat rakiyore hitarare duwa goijje. ");
INSERT INTO rhg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Isaye abar za šuru goijje, hetunot ekzon manuš dũri hibar hãse aišše edde hibar sarme ãṛu felaiyore hodde, \"Oh bala ustad, akeri zibon faibolla ãttu bala ham ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kintu Isaye hitare hodde,\"Ãre kiyolla bala hor? Allah ekzon sara ar honokiye bala no. ");
INSERT INTO rhg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tũi to hokumgun zano: 'Kun no goijjo, zena no goijjo, suri no goijjo, misa goba no diyo, honokiyore no ṭokaito, tũwar baf mare šorman goro.'\" ");
INSERT INTO rhg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hite hodde: \"Ustad! Gura halottu loti ãi in okkol falon gori aiyir.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isattu hitare ador laigge edde hitar mikka saiyore hodde, \"Ehon o tũwattu ekkan ham baki ase, zo, tũwattu za kissu ase hin beggun besifelogoi, ar hin gorib okkolore baṛidogoi, henot tũi behostot dón faiba, tarfore aiyore ãr fisa lo.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kintu ei zuwabor zoriya hitar nakmuk hala oigiyegoi edde ferešan oiyore giyegoi, kiyollahoile hitattu beši šombotti aššil. ");
INSERT INTO rhg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ar Isaye sairo mikka saiye edde sahabi okkolore hodde, \"Tuwangor okkololla Allar raijjot gola hondilla koṭin oibo!\" ");
INSERT INTO rhg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sahabi okkole hibar hota funiyore ammuwak oiye. Isaye abar hodde, \"Fuwain okkol, hitaralla Allar raijjot gola iyan hondilla koṭin! ");
INSERT INTO rhg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tuwangor okkol Allar raijjot golattuwaro fũišor fai bai uṭ gola aro asan.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Henot hitara aro beši ammuwak oiye edde hitara ekzonore ekzone hodde, \"Toile uddar hone oi faribo?\" ");
INSERT INTO rhg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isaye hitarar hikka saiye edde hodde, \"Mainšolla iyan ošombob, kintu Allalla hár kissu šombob.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Toi Fitore endilla howa šuru goijje, \"Ãralla ken oibo? So, ãra hár kissu felai aišši edde õnor fisa loiyi!\" ");
INSERT INTO rhg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zuwabe Isaye hodde, \"Ãi tũwarare soiyi hoir, ze hono ekzone ãr namolla edde kušir hoborolla buli gór, bái boin, ma baf, futziyain ba zaga zobin eri difelaiye, ");
INSERT INTO rhg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hitara ekšot gun beši faibo, ar akéri zibon o faibo. Ei zugot o gór, bái, boin, ma, fuwain edde zaga zobin faibo, kintu fũwati ottisar o bug gora foribo edde aiyedde zugot akéri zibon faibo. ");
INSERT INTO rhg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kintu funo! Hitarar foilar hataror bout kiye šešor hatarot oibo ar šešor hataror hitara foilar hataror oibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hitara uwore Zeruzalem zadde fõtot, Isa hitarar age age ãṭṭil. Sahabi okkol ammuwak oiye edde zara hibar fise fise giye, hitara ḍoraiye. Abar hibaye he barozonore ek ḍaikka loigiye edde hiba nizor uwore zin goṭibo he babute howa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hibaye hodde, \"So, ãra Zeruzalem zair. Heṛe Adomor Futore ḍõr imam edde alem okkolor hatot tuli diya oibo. Hitara hibar bisar gori hibare moron šaza faibar laikka ṭoraibo, edde Oihudi okkolor hatot tuli dibo, ");
INSERT INTO rhg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","hitara hibare loi ṭaṭṭa goribo edde hibare sep maribo, souk maribo edde marifelaibo. Bade tin dinor din hiba zinda uṛi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bade Sebdeusor fuwain Yakub edde Yuhannaye Isar hãse aiyore hodde, \"Ustad, ãra ziyan sai hiyan õne ãralla goro.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Isaye hodde,\"Tũwara ki so? Ãi tũwaralla ki goritam?\" ");
INSERT INTO rhg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hitara hodde, \"Õne zẽtte kuduruti loi razagiri goriba hẽtte ãra ekzonore õnor den ḍakottu edde ar ekzonore ban ḍakottu boito do.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Isaye hodde, \"Tũwara kiyor babute sor hin tũwara no zano. Ze motor fiyala ãi fito zair hin ki tũwara fi fariba? Otóba ze torikotor gusol ãre gora or tũwara ki he gusol loi fariba?\" ");
INSERT INTO rhg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hitara zuwabe hodde, \"Ãra faijjum\" Isaye hitarare hodde,\"Ze motor fiyala ãi fiyum tũwara fiba, ar ze torikotor gusol ãre diya oiye he gusol tũwarare o diya oibo, ");
INSERT INTO rhg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu ãr ḍen ḍakottu otóba ban ḍakottu boito dibolla ãttu odihar nai. Ei zaga okkol in zaralla ṭik gori raka oiye, hitara hin faibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baki došzone ei babute funiyore Yakub edde Yuhannar uwore gušša oiye. ");
INSERT INTO rhg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hetunot Isaye beggunore ekkui fũwati ḍakiyore hodde, \"Tũwara zano ze, zara Oihudi okkolor šašon goroya hitara hitarar uwore kemota sola, ar hitarar ḍõr manuš okkole hitarar uwore kemota sola, ");
INSERT INTO rhg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kintu tũwarar butore hendilla no on sa, bolke tũwarar butore honokiye zodi ḍõr oito sa, hite tũwarar šeba goroya ok. ");
INSERT INTO rhg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ar ze tũwarar butore foila oito sa, hitattu beggunor gulam owa foribo, ");
INSERT INTO rhg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","kiyollahoile Adomor Fut udda šeba faibolla nu aiye, bolke šeba goitto aišše edde bout mainšor azadir dam hisabe hibar foran dibolla aišše.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bade hitara Zeriku šohorot giye. Isa edde hibar sahabi okkole ek ḍõr dolor fũwati šohorottu niyoli zargoide šomot ekzon anda manuš fõtor ḍake horat magedde boiṛa aššil. Hitar nam aššilde Bartimeus, Timeusor fuwa. ");
INSERT INTO rhg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Zehon hite fuinne ze hiba Nasarator Isa, hite guzora šuru goijje, \"Daudor bongšor Isa, ãre doya goro.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Boute hitare dõk diye edde nizam taito hoiye, kintu hite aro beši guzora šuru goijje, \"Daudor bongšor Isa, ãre doya goro!\" ");
INSERT INTO rhg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Isaye tamiyore hodde, \"Hitare eṛe aito ho!\" Mainše he andaware ḍaikke edde hodde, \"Himmot gor, uṭ! Hibaye tore ḍaker.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hetunot hite hitar saddorgan ek ḍaikka felai rakiyore falmari uiṭṭe edde Isar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isaye fusar goijje,\"Ãi tolla ki goriyum, tui ki sos?\" He anda manušwaye hodde, \"Malik, ãi suke deki farifan gori do.\" ");
INSERT INTO rhg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Toi Isaye hodde, \"Dór, za! Tor biššaše tore aram goijje.\" Henot hite hehon deki faijje edde fõtot hite Isar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hitara zẽtte Zeruzalemor hãsa hãsi oiye edde Zaitun faharor ḍake Betfage edde Betaniya farar hãse aišše, Isaye duizon sahabire ");
INSERT INTO rhg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","endilla hoi defeṛaiye,\"Oi sarmor farat zo, heṛe goli mottor ek gadar so banda dekiba, zibar uwore ehon o hono manuše no boiye. Hiba kuli ãlla loi anogoi. ");
INSERT INTO rhg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ar zodi honokiye fusar gore, 'Tũwara hendilla kiyolla goror?' toile hoiba, 'Ibare Malikottu dorhar oiye edde ibare uwafes toratori eṛe firai dibo.'\" ");
INSERT INTO rhg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Toi hitara giye edde gadar soware rastat ekkan dorozar ḍake banda faiye. Hitara hibare kuille. ");
INSERT INTO rhg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Henot heṛe zara tiyai aššilde hitara hodde, \"Tũwara ki goror? Gadar sowa kiyolla kulor?\" ");
INSERT INTO rhg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Isaye zendilla hoito hoil hitara hendilla hoiye, toi hitarare ejazot diye. ");
INSERT INTO rhg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tarfore hitara gadar soware Isar hãse ainne edde hibar uwore hitarar saddor bisai diye, toi hibar uwore Isa boišše. ");
INSERT INTO rhg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bout mainše hibare šorman goribolla hoi hitarar saddor okkolore rastar uwore bisai diye, ar kiye maṛottu fatawala ḍeila okkol ani fõtot šiṛi diye. ");
INSERT INTO rhg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ar ze manuš okkol age edde fise gil hitara guzojje, \"Hosanna!\" \"Malikor name ze aiyer hiba rahamoti!\" ");
INSERT INTO rhg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","\"Ãrar Baf Daudor ze raijjo aiyer, hiba rahamoti.\" \"Uwore behostot Hosanna!\" ");
INSERT INTO rhg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bade Isa Zeruzalemot goliyore butore dórmogóror uṛanot giye. Hibaye sairo mikkar hár kissur uzu saiye, tarfore beil giyegoi boli he barozon sahabire fũwati loi Betaniyat giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tarfor din, hitara Betaniya sari zargoide šomot, Isattu bug laigge. ");
INSERT INTO rhg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hibaye durottu ugguwa fatawala ḍũir gas deikke edde hibat hono gula asene nai saito giye. Kintu hiba heṛe zaiyore fata bade ar kissu no fa, kiyollahoile hẽtte ḍũir gula dorede ainda no. ");
INSERT INTO rhg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Toi hibaye gassware hodde,\"Ar hono din honokiye tottu gula no háibo.\" Ar ei hota hibaye hodde hibar sahabi okkole fuinne. ");
INSERT INTO rhg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bade hitara Zeruzalem aišše, ar Isa uwore dórmogóror uṛanot góille edde heṛe zara besa kina goijjil hitarare hentu lorai diya šuru goijje. Hibaye ṭiya bodolidoya okkolor ṭebil edde hoitor besoya okkolor ṭebil uldai diye. ");
INSERT INTO rhg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ar hibaye dórmogóror uṛan bai honokiyore hono besa kinar ziniš boi loizaito no de. ");
INSERT INTO rhg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bade hibaye šikka diye, \"Iyan endilla leka nai ne?, 'Ãr górore hár zatilla munazator gór ḍaka oibo'? Kintu tũwara iyanore ḍahaitor aḍḍahana banaifelaiyo!\" ");
INSERT INTO rhg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ḍõr imam edde alem okkole ei hota fuinne edde hitara hibare marifelaibolla rasta tuwa šuru goijje. Hitara hibare ḍoraito, kiyollahoile manuš okkol hibar šikkat tajjuf oi zaitogoi. ");
INSERT INTO rhg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ar hazinna oile Isa edde hibar sahabi okkol šohoror baire zaitogoi. ");
INSERT INTO rhg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Toi hitara binna zadde ṭaimot dekedde ḍũir gasswa šiyorottu loti fuwai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Fitorottu Isar hota monot foijje edde hodde, \"Ustad, so, ze ḍũir gasore õne bodduwa dila hiba fuwai giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hetunot Isaye hitarare zuwabe hodde,\"Allar uwore biššaš rako! ");
INSERT INTO rhg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ãi tũwarare soiyi hoir, zodi honokiye ei faharore ho, 'Uṛiyore doriyat zai for,' ar hitar dile šondo no gore kintu hite ziyan hoiye hiyan oibode biššaš gore, iyan hitalla gora oibo. ");
INSERT INTO rhg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hetolla ãi tũwarare hoir, tũwarar munazatot ze hono kissu so, biššaš goro ze tũwara hin faifelaiyo, ar hin tũwarar oibo. ");
INSERT INTO rhg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ar tũwara zẽtte munazat goitto tiyo, honokiyor berudde hono kissu take, toile hitare maf goro, zene tũwarar behostor Bafe o tũwarar guna maf gori fare.\" ");
INSERT INTO rhg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Kintu tũwara zodi maf no goro, toile tũwarare o tũwarar behostor Bafe tũwarar guna maf no goribo.) ");
INSERT INTO rhg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hitara abar Zeruzalemot aišše edde dórmogóror uṛanot Isaye gura fira gorer, ḍõr imam okkol, he alem okkol edde bura murobbi okkol hibar hãse aišše, ");
INSERT INTO rhg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","edde hitara hibare hodde, \"Har kemota loi tui in okkol goros? Otóba in goribolla ei kemota tore hone diye?\" ");
INSERT INTO rhg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Toi zuwabe Isaye hitarare hodde,\"Ãi o tũwarare ekkan hota suwal gori, ãre hiyanor zuwab do, toi ãi o tũwarare hoiyum har kemota loi ãi in okkol gori. ");
INSERT INTO rhg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yahyar torikotor gusol, iyan ki Allattu naki mainšottu?\" ");
INSERT INTO rhg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Toi hitara ekzone ekzon loi mošora gori hodde, \"Zodi hoi, 'Allaro torfottu,' hen oile hite hoibo, 'Toile tũwara Yahyare biššaš ka no goro?' ");
INSERT INTO rhg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naki endilla zuwab diyum, 'Mainšor torfottu?'\" (Kintu hitara mainšore ḍoraiye, kiyollahoile beggune Yahyare ekzon soiyi nobi boli mainto.) ");
INSERT INTO rhg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Toi hitara Isare zuwab diye, \"Ãra no zani.\" Hetunot Isaye hodde, \"Toile ãi o tũwarare no hoiyum har kemota loi ãi in okkol gori.\" ");
INSERT INTO rhg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Toi Isaye hitarare mesal kahani loi hota howa šuru goijje: \"Ekzon manuše ekkan ãngur keti goijje, ar hiyanor sairo ḍakottu gíra diyore butore šoraf banaibolla ugguwa gãt tiyar goijje, edde ekkan usol fahara gór bainde. Bade hite hoekzon sašar hãse hiyan lagaiyore bidešot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gular ainda zẽtte aišše, hite hitar gular bag loianibolla ekzon gulamore oi saša okkolor hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kintu hitara he gulamware doriyore maijje edde hali hate dũrai diye. ");
INSERT INTO rhg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tafore hite ar ekzon gulamore hitarar hãse defeṛaiye. Hitara hitare o mata sai mari agat goijje edde ofoman goijje. ");
INSERT INTO rhg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hite tarfore o aro ekzonore defeṛaiye. Hitara hitare mari felaiye. Tarfore hite aro bout zonore defeṛaiye, kintu hitarar butottu hoekzonore mara dora goijje, ar hoekzonore marifelaiye. ");
INSERT INTO rhg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","\"Heṛe defeṛaibolla hitattu basi aššilde šude ekzon, hiba oilde hitar nizor adoijja fut. 'Hitara ãr futore oile ijjot goribo' hen bafiyore šešottu hitare hitarar hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","\"Kintu saša okkole ekzonore ekzone hodde, 'Ite mirazdar, aiyo, ãra itare marifelai, toi miraz ãrar oi zaiboi'. ");
INSERT INTO rhg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hitara hitare dori marifelaiye. Tarfore ãngur ketir baire felai diye. ");
INSERT INTO rhg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","\"Toile ãngur ketir girose ki goribo, hosai? Hite aibo edde he saša okkolore marifelaibo ar ketigan o oinno kiyore difelaibo. ");
INSERT INTO rhg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tũwara kitabor ei lekagun no foro ne: \"'Ze fattorguware raz mistiri okkole batil goijje: hiba i beši dorhari fattor oi uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iyan Mabud nizor ham, ar hiyan ãrar sukot kub beši tajjuiffa.'\" ");
INSERT INTO rhg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hetunot he dormiyo neta okkole Isare dorifelaibolla kušiš goijje, kiyollahoile hitara buzifaijjil ze Isaye mesal kahanigan hitarar berudde hoiye. Kintu hitara mainšore ḍoraiye, hetolla hitara zar zar bote te te giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tarfore hitara Isar hotat doribolla hoekzon Foroši edde Herudiyo okkolore Isar hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Toi hitara Isar hãse aišše edde hodde, \"Ustad, ãra zani õne hamiša soiyir uzu tako, ar mainše ki mone goribo hin õne forba no goro, kiyollahoile õne honokiyor suk saiya muk saiya kissu no goro, kintu Allar rastar babute ziyan soiyi hiyan šikka do.Toile Romor badšare hazna diya iyan ṭik ne naki beṭik? Ãra diyum ne naki no diyum?\" ");
INSERT INTO rhg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kintu Isaye hitarar bonḍami sail buzi fariyore hitarare hodde,\"Tũwara ãre fãndot feilaito kiyolla sešta goror? Ãlla ekkan foiša ano edde ãi hiyan ekka sai!\" ");
INSERT INTO rhg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hitara ekkan foiša anidiye. Bade Isaye fusar goredde, \"Iyanor uwore har sóbi edde nam ase?\" Toi hitara hodde, \"Romor badšar\" ");
INSERT INTO rhg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Toi hibaye hitarare hodde, \"Toile zin zin Romor badšar hin Romor badšare do, ar zin zin Allar hin Allare do!\" Ei hotar uwore hitara ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tarfore Sadduki okkol Isar hãse aišše, zara hoito heṛe hono uwafes zinda nai, toi hitara Isar hãse suwal goijje. ");
INSERT INTO rhg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","\"Ustad, nobi Musaye ãralla leki giye, hono ekzonor bái zodi fuwain no owaite bouwore raki mori zagoi, toile hitar báiye he bouwore biya goribo, edde nizor báiyolla bongšo baraibo. ");
INSERT INTO rhg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ehon, hãt bái ase ek górot. Foilawaye biya goijje, kintu hono fuwain no raka abostat mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bade hibare dusorawaye biya goijje, kintu hite o hono fuwain no raka abostat mori giyegoi. Ar hendilla ekkui bafe tiserawaye goijje. ");
INSERT INTO rhg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hitara hãtozon honokiyottu fũwain no o. Šeše he mayafuwawa o morigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Henoile uwafes zindar šomot, hitara zẽtte uwafes zinda oibo, hitarar butottu hiba har bou oibo? Hibarede hãtozon beggune biya goijjil.\" ");
INSERT INTO rhg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isaye hitarare zuwab diye, \"Tũwara búl, kiyollahoile tũwara no buzo Allar kalam otóba no buzo Allar šoktire. ");
INSERT INTO rhg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mora okkol zẽtte zinda oi uṛibo, hitara biya no goribo ar biya o diya no oibo, hitara behostot firista okkolor ḍoilla. ");
INSERT INTO rhg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kintu mora okkol uwafes uṛar babute tũwara zolonto zúwãr kahani Torah šorifot no foro ne? Allaye Musare hodde, 'Ãi Ibrahimor Allah, Isakor Allah, edde Yakubor Allah.' ");
INSERT INTO rhg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hiba mora okkolor Allah no, kintu zinda okkolor. Tũwara beši ḍõr búl fõtot aso!\" ");
INSERT INTO rhg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hitarar ekzon aleme heṛe aiyore hitarar barabari fuinne edde Isaye hondilla bala zuwab diyede hiyan buzi fariyore Isar hãse giye edde fusar goijje, \"Hokum beggunor butore honnan beši zoruri?\" ");
INSERT INTO rhg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isaye hodde, \"Beši zoruri oilde iyan, 'Funo Israili okkol! Ãrar Mabud Allah, Mabud oilde ek. ");
INSERT INTO rhg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tũi tũwar hár dil, hár mon hár foran, hár šokti, diyore Allah Mabudore muhabbot goro.' ");
INSERT INTO rhg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ar dusoragan oilde iyan: 'Ar tũwar ḍen gór bam gójjare nizor zani muhabbot goro.' Inottuwaro ar hono ḍõr hokum nai.\" ");
INSERT INTO rhg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","He aleme hibare hodde, \"Ustad, bala hoiyo. Õne soiyi hoiyo ze Mabud oilde ek, Hiba sara ar oinno honokiye nai. ");
INSERT INTO rhg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ar hár dil, hár buddi edde hár šokti diyore hibare muhabbot gora edde ḍen gór bam gójjare nizor zani muhabbot gora oilde aro beši muilloban, hár fura-kurbani okkol edde kurbani okkolottuwaro.\" ");
INSERT INTO rhg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","He aleme hondilla giyani zuwab diye hiyan Isaye dekiyore, hibaye hitare hodde, \"Tui Allar raijjottu beši dure no.\" He oite honokiye ar hono suwal goitte himmot no gore. ");
INSERT INTO rhg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isaye dórmogóror uṛanot šikka dedde šomot, hibaye hodde, \"He alem okkole ken gori Mosire Daudor fuwa hoi fare? ");
INSERT INTO rhg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daud nize, Pak Ruhur duwara elan goijje: \"'Mabude ãr Malikore hodde: \"Ãr ḍen ḍakottu boi, zetodin ãi tor dušmon okkolore tor ṭengor tole no raki.\"' ");
INSERT INTO rhg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daude nize hibare Malik ḍaker, toile hiba ken gori Daudor fuwa oi faribo?\" Ek ḍor mainšor dole kušir sãte hibar hota fuinne. ");
INSERT INTO rhg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ar šikka dedde šomot hibaye hodde,\"Alem okkolottu hũšiyar! Hitara lamba lamba hor findi beraito sa edde haṛot bazarot mainšor solam, ");
INSERT INTO rhg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","muzolišhanar usol zagat edde mela šobar barik zagat buware foson gore. ");
INSERT INTO rhg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hitara rari okkolor gór okkol dokol gore, ar mainšore dehaibolla lamba gori duwa gore. Hendilla mainše bisaror din bout beši šasti faibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Toi Isaye dórmogóror dan bakšur ḍake sarmottu boiyore, mainše hitarar nizor nizor ṭiyare dan bakšut rakedde saiye. Bout tuwangor okkole beši diye. ");
INSERT INTO rhg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kintu ekzon gorib rari maya fuwa o aišše edde duiyan šoṛo tamar foiša raikke, zinor muillo šude ho ek fiya. ");
INSERT INTO rhg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Toi Isaye sahabi okkolore hibar hãse ḍaikke edde hodde, \"Ãi tũwarare soiyi hoir, oinno zara ei dórmogóror dan bakšut raikke, hitara beggunottuwaro ei gorib rari mayafuwawaye beši raikke. ");
INSERT INTO rhg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kiyollahoile hitara beggune hitarar beši šombottittu dan bakšut raikke, kintu hibaye hiba obafi oi bade o, hibattu foran basaibolla zin aššil, hin beggun di felaiye.\" ");
INSERT INTO rhg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Toi Isa dórmogórottu niyoli zargoide šomot hibar sahabi okkolor ekzone hibare hodde, \"Ustad, so, ken šundor šundor fattor okkol edde kuṭa okkol!\" ");
INSERT INTO rhg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isaye hitare zuwabe hodde,\"Oi, tui ei ḍõr kuṭa okkol banaiyede dehor ne? Inor ekkan fattor o ar ekkan fattoror uwore no takibo, beggun bangi fela oibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Toi Isaye dórmogóror uṛanor muntu Zaitun faharor uwore boišše ar Fitor, Yakub, Yuhanna edde Andreas hibar fũwati ekela aššil, hitara hibare fusar goredde, ");
INSERT INTO rhg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"Õne ãrare ho, in okkol hõtte oibo edde in okkol beggun furon oibode hiyar sinno ki?\" ");
INSERT INTO rhg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Toi Isaye hitarare zuwabe howa šuru goijje: \"Saiyo, hono honokiye tũwarare dúhat felar ne! ");
INSERT INTO rhg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kiyollahoile boute ãr namor béddori aibo, ar hoibo, 'Ãi hiba,' edde boutore búl fõtot loizaibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ar zẽtte tũwara larair babute funor edde larair andeikka hóborahóbor funiba, hẽtte no ḍoraiyo! In okkol hameka goṭa foribo, kintu hetunot o šeš no. ");
INSERT INTO rhg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ek zatiye oinno zatir berudde edde ek raijjoye oinno raijjor berudde larai goribo. Ar bout zagat raṭ edde busal oibo. Kintu in okkol šude fuwa biyaibar šomot zontoronar šuru. ");
INSERT INTO rhg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","\"Tũwara hũšiyar taikko! Hitara tũwarare bisar šobar hatot tuli dibo, hitara tũwarare sinagogot bet maribo, ar ãlla boli tũwarattu šašon goroya edde raza okkolor muntu tiya foribo. Hitarar hãse ãr babute goba diba. ");
INSERT INTO rhg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Edde hár zatir hãse foila kušir hóbor tobolig gora foribo. ");
INSERT INTO rhg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kintu hitara zẽtte tũwarare doribo edde bisarot loizaibo, hetunot ki hoiba he babute age loti sinta no goijjo, kintu he šomot ze hota tũwarare howa oibo, tũwara hin hoiba, kiyollahoile iyan endilla no ze tũwara hota hoiba bolke Pak Ruhye hota hoibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","\"Báiye báiyore ar bafe fuwaindore dúha diyore moutor fõtot faṭaibo, ar fuwainde baf mar berudde tiyaibo edde hitarare kun goraibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ãlla boli tũwarare beggune hingša goribo, kintu ze šeš foijjonto ṭiki takibo, hite uddar faibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","\"Tũwara zẽtte 'šorbo naša hingšar ziniš' tiya gorai no farede zagat tiya goraiyede dekor, ze foré hite buzok! Hetunot zara Ehudiyat takibo hitara fahar okkolot dai zoggoi. ");
INSERT INTO rhg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ze góror sádor uwore ase, hite hentu góror butottu hono kissu fũwati loi zaibolla nise lami no aiyok. ");
INSERT INTO rhg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ze maṛot ase, hite gar saddor loibolla uwafes firi górot nu aiyok. ");
INSERT INTO rhg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hẽtte hamilwala mayafuwain okkol edde dudor fuwaindor ma okkololla hondilla ze oibo! ");
INSERT INTO rhg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Duwa goro zene in okkol šit hale no goṭe, ");
INSERT INTO rhg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","kiyollahoile en beši ḍõr hošṭo oibo, zin Allaye duniyaire sirišti goijje loti ei foijjonto hono šome no o, ar sarme o no oibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","\"He din okkolore zodi Allaye homai no dito, toile honokiye no basito. Kintu hitara zarare hibaye basi loiye, hitarar zoriya he din okkolore hibaye homai diye. ");
INSERT INTO rhg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","He ṭaimot zodi honokiye tũwarare ho, 'So, Mosi eṛe!' otóba, 'So, Mosi uṛe!' tũwara biššaš no goijjo. ");
INSERT INTO rhg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kiyollahoile hẽtte bonḍo mosi okkol edde bonḍo nobi okkol muntu aibo ar keramoti edde sinnor ham goribo zene šombob oile Allar basaigora okkolore hitara dúha difare. ");
INSERT INTO rhg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","\"Tũwara hũšiyar taikko. Ãi tũwarare in okkol hár beggun age bare hoi rakilam. ");
INSERT INTO rhg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","\"Kintu he din okkolot, ei mosibot farai zai bade, \"'beil andar oi zaiboi, sande ar fohor no dibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Asmanottu tara okkol fori zaiboi, asmanor šokti okkolore hafai felaibo.' ");
INSERT INTO rhg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","\"He šomot hitara ḍõr šokti edde mohima loi Adomor Fut miyular butottu aiyedde dekibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hibaye firista okkolore defeṛaibo edde duniyair ek šimattu loti asmanor šeš šima foijjonto, sairo mikkattu hibar basai gora okkolore dola goribo. ");
INSERT INTO rhg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","\"Ḍũir gasor mesalottu ei šikkagan šiko: Hibar ḍeila zehon hail oiyore ṭũi niyole hẽtte tũwara zani faro ze, gorom hal hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","He bafe tũwara o zani fariba zẽtte in okkol goṭedde tũwara dekor, ze Adomor Fut hãse aigiyegoi, kub hãse, en ki, dorozat hazir. ");
INSERT INTO rhg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ãi tũwarare soiyi hoir, in beggun no goṭibar age ei halor manuš okkolor mout no oibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asman zobin šeš oibo, kintu ãr hota hono din šeš no oibo. ");
INSERT INTO rhg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","\"Kintu he din edde šomoiganor babute honokiye no zane, behostor firista okkole o no, Fuwaye o no, šude Bafe zanede. ");
INSERT INTO rhg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","\"Hetolla seton tako, kiyollahoile he din edde šoimoiganor babute tũwara no zano. ");
INSERT INTO rhg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","\"Iyan oibode endilla, ek zon manuš bidešot musaferi goitto zar. Górottu baisa dibar age, hite hitar gulam okkolore hár hamor zimma gosai diye. Hite ekzon ekzon fotti gulamore ham diye, ar dorowanore seton takito hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","\"Hetolla seton taki fahara do, kiyollahoile góror giros hõtte aiye, ki hazinna aiye naki ada raitta aiye naki kuraye bak dedde hiya aiye, naki binna aiye tũwara hoi no faro. ");
INSERT INTO rhg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hiba atikka aiyore zene tũwarare gum zai taikkode no deke. ");
INSERT INTO rhg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ãi ziyan tũwarare hoir, hiyan ãi tũwara beggunore hoir: 'Tũwara seton tako!'\" ");
INSERT INTO rhg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Uddar id edde iš adiya ruṭir id aite šude dui din baki. Ḍõr imam edde alem okkole gufone Isare dori marifelaibolla ufai tuwail. ");
INSERT INTO rhg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hitara hodde, \"Idor šomot no, manuš okkolor butore gulmal uṛit fare\" ");
INSERT INTO rhg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Isa Betaniyar kurus biyaraimma Šimonor górot aiššil. Hitara hána hadde šomot ekzon mayafuwaye ek dóla fattoror boyomot gori kub beši dami edde asoli kušbo tel loi hibar hãse aišše. Hibaye boyommuwa bainge edde telgunore Isar matat ḍali diye. ");
INSERT INTO rhg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Heṛe zara hazir aššil, hitarar butottu ho ekzone naraz oiyore hodde, \"Ei dami zinišgun kiyolla borbat gorifela or? ");
INSERT INTO rhg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ei tel to beši dame besa zaito edde ṭiyagun loi gorib okkolore modotolla diya zaito.\" Ar hitara mayafuwaware hora bafe zejeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hetunot Isaye hodde, \"Tũwara hibare loi hen kiyolla goror? Hibaye ãlla ekkan bala ham goijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gorib okkol to hamiša tũwarar fũwati ase, ar zẽtte mone ho tũwara hitarare modot gori fariba, kintu ãre tũwara hamiša no faiba. ");
INSERT INTO rhg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hibaye ziyan gori faitto hiyan goijje, hibaye ãr uwore ei kušbo tel ḍali diyore agottu loti ãre hoborolla tiyar goijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ãi tũwarare soiyi hoir, duniyair ze hono mikka zeṛe kušir hóbor tobolig gora oibo, heṛe ei mayafuwaware monot goribolla hibar ei hamor hota o howa oibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tarfore Ehudah Iskariyot, he baro zonor butoror ekzon, hite ḍõr imamor hãse giye edde hitarar hatot Isare tuli di faribo hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hitara hendilla funiyore beši kuši oiye edde hitare ṭĩya dibo hoi wada diye. He oite hite hibare hitarar hatot kene tulidi faribo he šuzug tuwa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Iš adiya ruṭir idor foila dinot din, zẽtte rosom mozin uddar idor hánalla soolor so zorgora oito, sahabi okkole hibattu fusar goijje, \"Malik, ãra hoṛe zai õnolla uddar idor hána tiyar goriyum so, zene õne uddar id falon gori faro?\" ");
INSERT INTO rhg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Toi hibaye hibar sahabi okkolor dui zonore endilla hoi defeṛaiye, \"Tũwara šohoror butore zo! Heṛe ekzon manuše ek góra fani boi loi zadde lot faiba. Tũwara hitar fise fise zaiba. ");
INSERT INTO rhg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ar heṛe hite ze górot golibo, tũwara he góror girosore hoiba, 'Ustade fusar goijje, gorba gór hoṛe, zeṛe ãi ãr šahabi okkolore loi uddar idor hána hái fari?' ");
INSERT INTO rhg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Henot hite tũwarare tiyar goijja dui ṭalar uwore ekkan ḍõr rum dehai dibo. Heṛe zai ãralla tiyar gorogoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Toi sahabi okkole baisa diye edde šohoror butore giye. Ar Isaye zendilla hoil he mozin hin hitara faiye edde uddar idor hána tiyar goijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bade hazinna zehon oiye, Isaye he barozon sahabire loi heṛe aišše. ");
INSERT INTO rhg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hitara hánar hádde šomot hibaye hodde,\"Ãi tũwarare soiyi hoir, tũwarar butottu ekzone ze ãr fũwati hána hár, hite ãre dušmonor hatot tuli dibo.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Toi hitara ferešan oiye edde ekzon bade ekzone hibattu fusar goijje, \"Hiba ki ãi?\" ");
INSERT INTO rhg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hibaye zuwab diye, \"Ze ãr fũwati hoddat ruṭi burar, hite. ");
INSERT INTO rhg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kiyollahoile Adomor Futor morar babute zendilla leka ase, hendilla oibo. Kintu afsus he manušwalla, Adomor Fut loi ze beimani gorer! Hite honodin zormo no owa iyan hitalla aro beši bala oito.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hitara hána hadde šomot hibaye ruṭi loi šukuriya zanaiye edde hibaye ruṭiware bainge, toi sahabi okkolore diyore hodde,\"In lo, hó, in ãr ga.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tarfore hibaye fiyala loiyore šukuriya zanaiye, hitarare diye edde hitara beggune hibattu fi háiye. ");
INSERT INTO rhg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Toi Isaye hitarare hodde, \"In ãr lou, noya wadar suktir lou, zin beši mainšolla ḍali diya oibo. ");
INSERT INTO rhg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ãi tũwarare soiyi hoir, ãngur gasor šoraf ãi ar honodin no fiyum, zeto din Allar raijjot abar noya gori hin no fiyi.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tarfore hitara tarifor gan gaye, toi niyoli Zaitun faharot giye. ");
INSERT INTO rhg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Isaye hitarare hodde, \"Tũwara beggune fori zaibagoi edde ãre eri zaibagoi,\" Kiyollahoile iyan endilla leka ase: \"'Ãi sool soroyare marifelaiyum, ar soolgun sairo mikka šiṛašitta oi zaiboi' ");
INSERT INTO rhg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kintu ãi uṛizaigoi bade, ãi tũwarar age Galilot zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hetunot Fitore hodde: \"Zodi õnore beggune felai zailegoi o, ãi hen no goijjum.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isaye zuwabe hodde, \"Ãi tore soiyi hoir, ehon aijja raitor butore, rata kuraye dui bar bak no dite, tui ãre tin bar ošikar goribi.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kintu Fitore aro zur diyore hodde, \"Zodi ãttu õnor fũwati mora o fore, to ãi õnore ošikar no goriyum!\" He ekkui hota hitara beggune hoiye. ");
INSERT INTO rhg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ar hitara Getsemoni name ek zagat aišše, toi hibaye sahabi okkolore hodde, \"Ãi zetun duwa gori, tũwara eṛe boiyo.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tarfore hibaye Fitor, Yakub edde Yuhannare fũwati loigiye edde monot kub beši zontrona edde hošto fa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ar hibaye hitarare hodde, \"Dukke ãr foran niyoli zargoi. Tũwara eṛe tako edde seton taikko.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bade hiba hoddur dure zaiyore meṛit uite foijje edde munazat goijje zene šombob oile ei dukkor ṭaim hibar hãsottu dur oi zagoi. ");
INSERT INTO rhg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hibaye hodde, \"Abba, Baf! Tũwalla hár kissu šombob. Ãttu ei motor fiyalawa loifelo. Tarfore o ãr issaye no, šude tũwar issaye gora ok.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tarfore hiba sahabi okkolor hãse uwafes firi aiyore hitarare gumot lot faiye. Hibaye Fitorore hodde, \"Simon, tui gum zodde neki? Ek gonḍa o ki seton tai no farili ne? ");
INSERT INTO rhg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Seton tako ar duwa goro zene forikkat no foro! Dile issa gorer, kintu tũwarar ga durbol.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Abar hibaye zaiyore he ekkui munazat goijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hiba abar firi ai hitarare gumot foijja faiye, kiyollahoile hitarar sukot gum bári aššil. Ar hitara hibare ki zuwab dibo buzi no faijjil. ");
INSERT INTO rhg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tisera bar hiba hitarar hãse firi aišše edde hodde,\"Ehono tũwara gum zor edde aram goror? Beši oiye! Šomoi hãse aišše. Adomor Futore gunagaror hatot tuli diya or. ");
INSERT INTO rhg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uṛo, solo, ãra zai! Ze ãre loi beimani gorer hite hãse aigiyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ar hehon, hibaye ehon o hota hor, hen šomot Ehudah, ze barozon sahabir ekzon, hite heṛe aišše. Hitar fũwati ek ḍõr dole suri edde laṛi loi aišše. Hitarare defeṛaiyede oilde ḍõr imam okkol, alem okkol edde manuš okkolor murubbi okkole. ");
INSERT INTO rhg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Beimani goroyaye hitara loi ekkan sinno ṭik goijjil: \"Ãi zare suma diyum hite oilde hiba. Tũwara hitare doriba edde fahara diyore loi zaiba.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ar hite aišše edde toratori Isar hãse zai hodde, \"Rabbi\" en hoi hite hibare suma diye. ");
INSERT INTO rhg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Toi hitara hibare doijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Heṛe tiyai aiššilde hitarar butottu ekzone hitar suri niyolaiye edde ḍõr imamor gulamore hamela goijje edde hitar han haṛi loi felaiye. ");
INSERT INTO rhg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Isaye hitarare hodde,\"Ḍahait doitto zafan gori tũwara ãre kiyolla laṛi edde súri loi doitto aiššo? Ãi ki ḍahait? ");
INSERT INTO rhg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Fotti din ãi tũwarar fũwati aššilam edde dórmogóror uṛanot šikka diyi, kintu hẽtte to tũwara ãre no doro! Kintu kitabor hota endilla gori furon owa forer.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hetunot sahabi okkol beggune Isare eri dáigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ekzon zuwan fuwaye šude ekkan saddor findiyore Isar fise fise gil. Hitara hitare doijje, ");
INSERT INTO rhg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kintu hite he saddor felaiyore lenḍa dai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hitara Isare ḍõr imamor hãse loigiye edde hár ḍõr imam okkol, he bura murobbi edde alem okkol beggune ekku fũwati dola oiye. ");
INSERT INTO rhg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kintu Fitore dure takiyore hibar fise fise zaite zaite, ḍõr imamor uṛanot foijjonto góille. Fitore heṛe faharadar okkolor fũwati oinor ṭalor ḍake boiyore oin fuhar. ");
INSERT INTO rhg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Toi ḍõr imam okkol, bura murubbi okkol edde alem okkol, mani beggune Isare marifelaibolla hibar berudde goba zuhar goitto sail, kintu hitara honokiyore no fa. ");
INSERT INTO rhg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hibar berudde bout kiye misa goba diye, kintu hitarar goba no mile. ");
INSERT INTO rhg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hetunot ho ekzone uṛi tiyaye edde hibar berudde misa goba diye, ");
INSERT INTO rhg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"Ãra hite endilla hodde fuinni, 'Ãi ei hate banaiya dórmogór bangifelaiyum edde tin dinor butore en ar ekkan tiyar goijjum, ziyan manušor hate banaiya no.'\" ");
INSERT INTO rhg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kintu hitarar goba o no mile. ");
INSERT INTO rhg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hetunot ḍõr imame beggunor sarme tiyaiye edde Isare hodde, \"Tor berudde hitara nališ goredde hinot tottu kissu hoibar nai neki?\" ");
INSERT INTO rhg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kintu Isaye suf oi roiye edde hono zuwab no de. Ḍõr imame hibare abar fusar goijje, \"Tui ki he rahamoti Allar Fut, Mosi?\" ");
INSERT INTO rhg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isaye hodde, \"Ãi oi. Tũwara Adomor Futore he Šorbo Šoktiwalar ḍen ḍakottu boiṛade edde asmanor miyulat gori aiyedde dekiba.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Henot ḍõr imame hitar nizor hor faṛifelaiye edde hodde, \"Ar ãrattu gobar ki dorhar? ");
INSERT INTO rhg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tũwara to kuferigan fuinno. Tũwara ki bafo?\" Hitara beggune hibare duši goriyore moribar laikka hoi faisala diye. ");
INSERT INTO rhg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Toi ho ekzone hibar gat sef maijje edde hibar muk bandi guša maijje edde hodde, \"Tui nobi no ne? Sai, hosai tore hone maijje!\" Ar faharadar okkole loizaiyore beši mara maijje. ");
INSERT INTO rhg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Fitor zẽtte lamat uṛanot aššil, hetunot ḍõr imamor ekzon bandi heṛe aišše. ");
INSERT INTO rhg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hibar nozor Fitore oin fuhadde hikka foijje edde hibaye bala gori Fitoror mikka saiyore hodde, \"Tui o to oi Nasarator Isar fũwati aššili.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kintu Fitore hiyan ošikar goijje. \"Tui kiyor babute hor hin ãi no zani, no buzir,\" endilla hoi Fitor baror dorozar hãse giye, ar hetunot ugguwa rata kuraye bak di uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kintu mayafuwaye Fitorore heṛe dekiyore abar heṛe zara tiyai aššil hitarare hodde, \"Ite o hitarar ekzon.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kintu Fitore abar hiyan o ošikar goijje. Aro hotun bade, zara heṛe tiyat aššil hitara o Fitorore hodde, \"Hameka tui o utarar ekzon, kiyollahoile tui o to Galilor manuš, tor baša loi buza zar.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kintu Fitore nizore bodduwa diyore hosom hái hodde, \"Tũwara zar babute hota hor ãi he manušware no sini.\" ");
INSERT INTO rhg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ar hehon dusora bar rata kuraye bak diye. Toi Isaye Fitorore ki hoil hiyan hibattu monot foijje: \"Rata kuraye dui bar bak no dite tui ãre tin bar ošikar goribi.\" Toi hiba handa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kub binna sore, ḍõr imam okkol edde murubbi okkol, edde alem okkol, ḍõr šobar beggune ek mošora goijje. Tarfore hitara Isare bandiyore loigiye edde Filator hatot gosaidiye. ");
INSERT INTO rhg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Filate fusar goredde, \"Tui ki Ihudi okkolor badša?\" Isaye zuwabe hodde, \"Tũi hor hendilla\" ");
INSERT INTO rhg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ḍõr imam okkole hibar namot bout hosuri okkol diye. ");
INSERT INTO rhg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tarfore Filate Isattu abar fusar goijje, \"Tui ki hono zuwab no dibi? Sa, hitara tore hodun hosuri der?\" ");
INSERT INTO rhg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kintu Isaye ek ohor udda zuwab no de, henot Filat tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Fotti uddar idot Filate mainše zare saito hendilla ekzon bondire eridito. ");
INSERT INTO rhg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","He šomot Barabbas name ekzon manuš hokumotor ulda hórtal goroya okkolor fũwati ziyolot bondi aiššil, zara hórtalor butore ekzonore kun gorifelail. ");
INSERT INTO rhg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manuš okkole Filator hãse aiyore guzora šuru goijje, hite goittode hendilla goribolla. ");
INSERT INTO rhg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Toi Filate hitarare hodde, \"Tũwara so ne, ãi Ihudi okkolor badšare eridi?\" ");
INSERT INTO rhg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Dõr imam okkole ze hingša gori Isare hitar hatot tulidil hiyan Filate zaintode hetolla hite hen hoiyede. ");
INSERT INTO rhg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kintu ḍõr imam okkole mainšor dolore uskani diye zene Filate hitaralla Barabbasore eride. ");
INSERT INTO rhg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Filate abar hitarattu fusar goijje, \"Toile tũwara zare Ihudi okkolor badša hoi ḍako, tũwara ki so, ãi hitare ki goittam?\" ");
INSERT INTO rhg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hitara guzori hodde, \"Hitare kurušot do!\" ");
INSERT INTO rhg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Filate hodde, \"Kiyolla, hite ki duš goijje?\" Kintu hitara aro zure guzoriyore howa šuru goijje, \"Hitare kurušot do!\" ");
INSERT INTO rhg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Filate mainšor dol okkolore razi goitto saiye. Hite hitaralla Barabbasore eridiye, kintu Isare souk maraiye edde kurušot dibolla tuli difelaiye. ");
INSERT INTO rhg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tarfore šoinno okkole Isare loi ḍõr šašon goroyar gõrot giye edde šoinno okkol beggunore ekkui fũwati goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hitara Isare baiyonna rongor hor findaiye, ar keṛa diyore ekkan taz banai matat findai diye. ");
INSERT INTO rhg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tarfore hitara Isare ṭaṭṭa gori hodde, \"Mórhaba, Ihudi okkolor badša!\" ");
INSERT INTO rhg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Hitara ugguwa laṛi loi hibar mata sai bari maijje edde hibar gat sep maijje ar ãṛu felai hibare ijjot goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hibare loi ṭaṭṭa gori bade hitara he baiyonna rongor hoorgan kuli loi felaiye edde hibar nizor ho sour findai diye. Toi hitara Isare kurušot dibolla niyolai loigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ar Simon name ekzon Kuroni šohoror manuš farattu he fõt bai aiššil. Hite aššilde Alekzendar edde Rufusor baf. Šoinno okkole hitare Isar kuruš boi loi zaibolla zur goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hitara hibare Golgata name ekkan zagat loigiye. Ei namor mani Mata kulir zaga. ");
INSERT INTO rhg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tarfore hitara Isare tita mišaiya horor roš fito diye, kintu hibaye hin no gose. ");
INSERT INTO rhg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tarfore hitara hibare kurušot diye edde hibar horgunolla har baiggot ki hor fore hiyan saibolla hitara loṭari maijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hitara hibare kurušot diyede hiya binna nowa baijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hibar berudde duš nama sainbuṛot leka aššil, \"IHUDI OKKOLOR BADŠA.\" ");
INSERT INTO rhg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hibar fũwati hitara duizon ḍahaitore o kurušot diye, ekzonore ḍen ḍakottu ar oinno ekzonore bam ḍakottu. ");
INSERT INTO rhg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Henot Pak kitabor ei hota furon oiye: \"Hibare oinnai goroya okkolor fũwati gona oiye.\") ");
INSERT INTO rhg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Zara he fõt bai giye hitara mata zaijje edde ofoman gori hoiye, \"Tui no ne dórmogórgan bangi abar tin dinor butore hiyan tiyar gori farosde! ");
INSERT INTO rhg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Henoile ehon nizore basa edde kurušottu lami ai!\" ");
INSERT INTO rhg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hendilla ekkui bafe ḍõr imam edde alem okkole o Isare loi ṭaṭṭa goijje edde ekzonore ekzone hodde, \"Hite oinno kiyore uddar goitto, kintu nizore uddar gori no farer! ");
INSERT INTO rhg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ei Mosi, Israilor badša, ehon kurušottu lami ai ok, zene ãra sai fari edde biššaš gori fari.\" Hitara zarare hibar fũwati kurušot diye hitara o hibare ofoman goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bade dũijja oiye loti tin gonḍa mula ek andar hara dešor uwore foijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Šomoi tinnuwa baijjede šomot Isaye ḍõr abaze guzori hodde, \"Eloi, Eloi, lema sabaktáni?\" (Ziyanor mani \"Ãr Allah, ãr Allah, kiyolla tũi ãre felaigiyogoi?\") ");
INSERT INTO rhg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ḍake tiyat aššilde hitarar hoekzone ei hota funiyore hodde, \"Funo, hite Eliyasore ḍakedde\" ");
INSERT INTO rhg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ekzone dũri zaiyore ekkan hani rošot buraiyore hiyan nolor matat gori Isare fi haito diye. Hite hodde, \"Tiya! Sai, nobi Eliyase hono hitare uddar goitto aiye ne!\" ");
INSERT INTO rhg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kintu Isaye zure guzoriyore šeš niyaš felaiye. ");
INSERT INTO rhg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ar dórmogóror forodagan uwottu loti nise foijjonto siri dui bag oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ze Romiyo ofisar Isar sarme tiyai aššil hite Isaye endilla gori šeš niyaš felaiyede deki hodde, \"Soiyi, ei manušwa Allar Fut aššil.\" ");
INSERT INTO rhg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Heṛe hoekzon mayafuwain o dure tiyat aššil, zara in okkol saiye. Hitarar butore aššilde, Salomi, Mogdaleni Moriyam, ar šoṛo Yakub edde Yusesor ma Moriyam. ");
INSERT INTO rhg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Isa Galilor taite ei mayafuwain okkole hibar fise fise zaito edde hibar šeba gorito. Aro bout mayafuwain okkol, zara hibar fũwati uwore Zeruzalem aiššil, hitara o heṛe tiyai aššil. ");
INSERT INTO rhg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","He dinnuwa aššilde tiyarir din, mani dórmor dinor agor din, ar hazinna oi giyegoi, ");
INSERT INTO rhg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatiya farar Yusuf, ze ḍõr šobar beši nam gora ekzon montri, hibaye Allar raijjolla boi aššil. Hibaye himmot gori zai Isar laššuwa faibolla Filator hãse foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ar Filat tajjuf oiye ze Isa eto toratori mori giyegoi, ar šenafotire ḍaki Isa morigiyegoide oi ne, hitattu fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Zehon šenafotir hãsottu hite foriškar zuwab zani faijje, toi laššuwa Yusufore diye. ");
INSERT INTO rhg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufe zai ekkan kafonor hor kinne, toi Isar laš nise lamaiyore he hoorgan beraiyore en ek hoborot raikkegoi, ziba faharor haindat kuinda aššil. Tarfore he hoboror mukot ugguwa fattor gorgorai loizai ouzai diye. ");
INSERT INTO rhg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hibare hoṛe hobor diye, Mogdaleni Moriyam edde Yusesor ma Moriyame deikke. ");
INSERT INTO rhg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dórmor din šeš oi zaigoi bade, Mogdaleni Moriyam, Yakubor ma Moriyam, edde Salomi, hitara Isar lašot ḍoli dito zaibolla kušbo tel kinne. ");
INSERT INTO rhg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bade haftar foila din binna kub sore, zẽtte hitara hoboror hãse giye hẽtte beil uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hitara ekzone ekzonore hodde, \"Hoboror mukottu fattorguware ãra hare diyore šoraiyum?\" ");
INSERT INTO rhg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kintu hitara saiyore dekedde fattorguwa šoraiya. Hiba beši ḍõr aššil. ");
INSERT INTO rhg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hoboror butore goli hitara dola lamba hor finda ekzon zuwan manušore den ḍakottu boiṛa deikke, henot hitara beši ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kintu hite hodde, \"Ammuwak no oiyo, kurušot diya oiyede Nasarator Isare ze tũwara tuwor, hiba eṛe nai, hiba uṛi giyegoi. So, iyan he zaga ziyanot hitara hibare rakkil. ");
INSERT INTO rhg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ar tũwara zo, hibar sahabi okkolore edde Fitorore hogoi ze Hiba tũwarar age Galilot zar. Hibaye zendilla hoil he bafe tũwara heṛe hibar deha faiba.\" ");
INSERT INTO rhg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Toi hitara kissu buzi uṛi no fari ḍore hafi hafi hoborottu niyoli giyegoi edde hentu dai giyegoi. Hitara ei babute ek or hota o honokiyore no ho, kiyollahoile hitara ḍorai gilgoi. ");
INSERT INTO rhg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Haftar foila din binna sore, Isa abar uṛizaigoi bade hibaye foila Mogdaleni Moriyamore deha diye, zibattu Isaye hãttuwa but dafail. ");
INSERT INTO rhg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hibaye hentu giyegoi edde he hóborgan zara Isar fũwati takito, hitarare diye edde hitara hainde edde bilag gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kintu hitara zehon fuinne, ze Isa zinda ase edde hibare deha diye, hitara hiyan biššaš no gore. ");
INSERT INTO rhg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","In okkol goṭi bade, Isaye oinno ruf dori hitarar dui zonore fõtot deha diye, zara baire farat zadde aššil. ");
INSERT INTO rhg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Itara o uwafes firi giye edde dusoragunore o he hóbor diye, kintu hitarare o hitara biššaš no gore. ");
INSERT INTO rhg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Šeše hiba he egarozon asabe hána háibolla dola oiyede šomot hitarare deha diye. Biššašor obaf edde dil dorode hiyanolla hitarare hibaye boka diye, kiyollahoile hiba uṛizaigoi bade zara hibare deikke hitarar hota itara biššaš no gore. ");
INSERT INTO rhg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Isaye hitarare hodde,\"Duniyair hár mikka zo edde Allar diya kušir hobor hár manuš zatir hãse tobolig goro. ");
INSERT INTO rhg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ze honokiye biššaš gore edde torikotor gusol lo hite uddar faibo. Kintu ze biššaš no goribo, hitare duši ṭora oibo. ");
INSERT INTO rhg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Zara biššaš gore hitarar butore ei sinnogun deha zaibo: Ãr name hitara bod ruh dafaibo, hitarar zile noya bášat hota hoibo, ");
INSERT INTO rhg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ar hitara hate háf doribo, zodi hitara hono moron biš há, toile hitarar hono hoti no oibo. Ar zẽtte hitara biyaraimmar gat hat rakibo, hitara bala oi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Malik Isaye hitarar loi hota hoi bade, hibare asmanot tuli loi za oiye edde Allar den ḍakottu boišše. ");
INSERT INTO rhg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Toi sahabi okkol baire giye edde hár zagat tobolig goijje. Ar Malike hitarar fũwati ham gorat taikke edde hitarare keramoti ham goribar šokti diyore forman goijje ze hibar kalam soiyi. Amen!");
INSERT INTO rhg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ãrar bout kiye ãrar butoror goṭona okkol zin zin ãrar maze goiṭṭe hinore leka šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Foila loti hitara zara nizor suke deikke edde bala hóbor tobolig goijje hitara ãrar hãse zendilla zanaiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hendilla ãi o šuruttu loti hár goṭonare bala gori zasai basai gori bade, o adoijja Teofilos, ãi tũwar hãse he goṭonagunore kulasa bafe leka bala mone gorilam. ");
INSERT INTO rhg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Zene ze kissu šikka tũi faiyo, hin soiyi oi ne naki no zani faro. ");
INSERT INTO rhg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ehudiyar badša Herudor ṭaimot, heṛe Abiyas dolor ekzon imam aššil, zar nam Zakariya. Hitar bou o Harun guštir maya fuwa. Hibar nam aššil Elizabet. ");
INSERT INTO rhg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hitara dunizon Allar šaikkat forhesgar aššil. Mabudor har hokum edde niyom mozin hitara niduši bafe solito. ");
INSERT INTO rhg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hitarattu hono fuwain no aššil, kiyollahoile Elizabet aššilde bázá. Ar hitarar umor o beši oil. ");
INSERT INTO rhg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ek din Zakariyaye hibar dolor fala mozin Allar sarme imamoti ham goijjil. ");
INSERT INTO rhg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Toi imamoti hamor niyom mozin dusora imam okkole loṭari maijje, henot Zakariyar nam uiṭṭe edde hibattu Mabudor pak zagat goli duf zala foijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Duf zalaibar ṭaimot mainše battu tai munazat goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","En šomot dufgar ḍen ḍakottu Mabudor ek firistaye Zakariyare deha diye. ");
INSERT INTO rhg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Toi Zakariyaye he firistare deki hibar mon hoisali oi uiṭṭe edde beša beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kintu firistaye Zakariyare hodde: \"No ḍorais Zakariya, tor duwa kobul gora oiye. Tor bou Elizabete tolla ek futore biyaibo, ar tui hitar nam rakibi Yahya. ");
INSERT INTO rhg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hite tolla ek kuši edde ullaš oibo, ar hite zormo owa loi boute kuši oibo, ");
INSERT INTO rhg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kiyollahoile hite Malikor nozorot mohan oibo, edde šoraf otóba hono ḍoilla mod no fibo; ar enki hite mar feṛottu loti he Pak Ruhuye furaiya oibo. ");
INSERT INTO rhg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hite Israilor beša beši manuš okkolore hitarar Allah Malikor hãse firai anibo. ");
INSERT INTO rhg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eliyas nobir ḍoil hanggam edde šokti loi, hite Malikor age aibo, bab okkolor mon fuwaindor uzu firaibolla, edde naforman mainšor monor báfore bodoli, Allar formandar mainšor monor báfor ḍoilla goribolla, zene Malikolla ek dol manušore furafuri bafe tiyar gori fare.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariyaye firistare hodde, \"Iyan ãi kene ekin goijjum? Kyollahoile ãi to bura, edde ãr bouwe fuwa biyaibar boyoš o farai giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Firistaye hitare hodde, \"Ãi Zibrail ze Allar sarme tiyai taki. Tor loi hota hoibolla edde ei kušir hóbor dibolla ãre defeṛa oiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ar sa, ehon loti in okkol ze din goṭibo, he din foijjonto tui buk oi takibi edde hota hoi no faribi, kiyollahoile tui ãr hota biššaš no goros. Kintu ãi ze hota hoiyi hin šomoi mozin furon oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ar eṛe bare manuš okkole Zakariyalla entezar gori taikke. Dórmogóror pak zagar butore hibaye deri gorer deki hitara tajjuf oi bafa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bade Zakariya zehon niyoli aišše, hibaye hitara loi mati no fare. Hitara buijjede dórmogóror pak zagar butore hameka hibaye hono deha faiye, kiyollahoile hibaye hitarar loi šude išara bišara gorat roiye edde buk oi roiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tarfore Zakariyar fala zehon šeš oiye, hite hitar górot firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hotodin bade Zakariyar bou Elizabet hamil oiye edde fãs maš foijjonto hiba mainšor arguwal oi roiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabete hodde, \"Iyan Mabudor ham. Mainšor sarme ãttu šorom no lagefan Allaye ehon ãr mikka suk tuli saiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bade Elizabet so maišša hamil oiyede šomot, Allaye Zibrail firistare Galil elehar Nasarat farar ek kumarir hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hibare loi badša Daudor bongšor Yusuf name ekzon loi hibar biyar hotabattara ṭik oil. He kumarir nam Moriyam. ");
INSERT INTO rhg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Firistaye hibar munttu zaiyore hodde, \"Tor šanti ok! Tui ḍõr rahamot faiyos! Mabud tor fũwati ase.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ei hota funi Moriyamor mon beši hoisalit fori gilgoi, ar mone mone bafa šuru goijje ei solamor mani ki hoi. ");
INSERT INTO rhg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kintu firistaye hibare hodde, \"No ḍorais Moriyam; kiyollahoile tui Allattu rahamot faiyos. ");
INSERT INTO rhg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ar fun! Tui hamil oibi edde tottu ek futore biyaibi, ar hibar nam rakibi Isa. ");
INSERT INTO rhg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hiba mohan oibo, hibare šorbo šoktiwalar fut ḍaka oibo. Allah Mabude hibar baf Daudor šingašon hibare dibo. ");
INSERT INTO rhg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yakubor bongšor uwore hibaye abadul abad razagiri goribo, ar hibar razagiri hono din šeš no oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Moriyame firistare hodde, \"En ken gori oi faribo? Ãi aizo kumari?\" ");
INSERT INTO rhg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Firistaye zuwabe hibare dedde, \"Pak Ruh tor uwore aibo, edde šorbo šoktiwalar šokti tor uwore saiya oibo. Hetolla ze paki zon zormo oibo hibare Allar Fut ḍaka oibo. ");
INSERT INTO rhg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ar sa, tor egena Elizabet, hibattu o ei bura boyošot ek fut feṛot oiye. Hiba zare bázá hoito, hibattu iyan so mašor san. ");
INSERT INTO rhg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kiyollahoile Allattu ošombob kissu nai.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Moriyame hodde, \"So, ãi Mabudor bandi, tũwar hota mozin ãr uwore har kissu ok.\" Tarfore he firista Moriyamor henttu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hotodin bade Moriyame toratori gori Ehudiya elehar ek fahari farat giye, ");
INSERT INTO rhg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","zeṛe Zakariya take. Hiba heṛe Zakariyar górot góille edde Elizabet loi mulot oiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabete zehon Moriyamor abaz fuinne hetunot hibar feṛor fuwaye fal mari uiṭṭe. Ar Elizabet he Pak Ruhuye furon oiye edde ");
INSERT INTO rhg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","zure ḍak mari hodde: \"Har nari okkolor butore tore rahamot, ar rahamot ze fuwa tor gorbot ase. ");
INSERT INTO rhg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iyan ki bafe oi fare, ãr Malikor mattu ãr hãse aiya foijje? ");
INSERT INTO rhg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ãi zẽtte tor abaz funilam hẽtte ãr gorbot ãr fuwaye kušiye fal mari uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ar rahamot tore, tui biššaš goijjos, ar hetolla tor babute Mabude zen hoiye, hen furon oibo!\" ");
INSERT INTO rhg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hetunot Moriyame hodde: \"Ãr forane Malikor šanor tarif gorer! ");
INSERT INTO rhg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ar ãr ruh ãr basailoya Allare loi kušiye ullaš, ");
INSERT INTO rhg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kiyollahoile hibaye ei nihait gorib bandir uwore nozor diye. Ar so, ehonottu loti hár mainše ãre mubarak hoibo. ");
INSERT INTO rhg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kiyollahoile hiba, he Šoktiwalaye ãlla beši ḍõr ham okkol goijje, paki oilde hibar nam. ");
INSERT INTO rhg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","hibar doya bongšor bade bongšolla, zara Hibare ḍorar. ");
INSERT INTO rhg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Allaye nizor ḍũwa loi ḍõr šoktir ham goijje. Zarar nizor dilot ohonkare bora, hitarare Allaye šiṛa šitta gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Allaye šingašonottu raza okkolore lamai diye, kintu nisorgunore usolot goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Zetarattu obaf ase, hitarare bala bala hána fani diye, kintu tuwangor okkolore hali hate bidai goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Allaye ãrar fordada okkolor hãse ze wada dil, he mozin hibaye hibar gulam Israilore ufohar goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ibrahim edde hibar bongšor manuš okkolor uwore, abadul abad adorhatir goribar hota Allaye monot raikke.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ar Moriyam maš tin maš Elizabetor górot taki bade nizor górot uwafes firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bade zehon Elizabete fuwa biyaibar din furon oiye, hibaye ek futore biyaiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ar hibar ḍen gór bam gójja edde egena okkole fuinne ze, Mabude hibare hoto ḍõr ador dehaiye, edde hitara hibar fũwati kuši goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ašṭo dinor din hitara fuware azomi goraito aišše, edde hibar bafor nam mozin hitara fuwar nam Zakariya rakito saiye, ");
INSERT INTO rhg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu fuwar maye zuwabe hodde: \"No, hitar nam Yahya raka oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hitara hibare hodde, \"Tũwar egena okkolor butore hono kiyor nam to Yahya nai.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bade hitara fuwar bafore išara gori hibattu zainto saiye fuwar nam ki rakito so hoi. ");
INSERT INTO rhg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariyaye ekkan lekibar silet maigge edde heṛe leikke: \"Itar nam Yahya.\" Henot beggune ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ar hehon Zakariyar muk kuligiyegoi edde zil eridiya oi giyegoi, toi hibaye Allare tarif gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hen deki atehasor manuš okkol beggune beši ammuwak oiye. Henot ze hanḍo okkol goiṭṭe hinor babute Ehudiyar har fahari elehar manuš okkole howa hoi gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mabudor hat ei fuwar uwore aššil buli zedune ei hota okkol fuinne hitara hin dilot raikke edde fusar goijje: \"Ḍõr oile ei fuwa ki oibo?\" ");
INSERT INTO rhg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hibar baf Zakariyaye he Pak Ruhuye furaiya oi nobi hisabe hota hoiye, hodde: ");
INSERT INTO rhg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Israilor Allah Mabudor tarif ok, kiyollahoile hibaye nizor mainšor uzu suk diye edde deha šunar bar loiye. ");
INSERT INTO rhg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Allaye ãralla hibar gulam Daudor bongšottu ekzon šoktiwala basailoiya tuille. ");
INSERT INTO rhg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Ei wadare Allaye bout age hibar pak nobi okkolor muke howaiye.) ");
INSERT INTO rhg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dušmon okkolor edde zara ãrare hingša gore hitarar hatottu basaibo. ");
INSERT INTO rhg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Allaye ãrar bafdadare doya dehaiye edde hibar paki wadare monot raikke, ");
INSERT INTO rhg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","he wadare hibaye ãrar baf, Ibrahimor hãse dil: ");
INSERT INTO rhg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Hetolla ãra dušmon okkolor hatottu ḍor sara uddar oiyi, toi zene ãra zetodin basi, Allar sukor sarme ");
INSERT INTO rhg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","pak saf edde soiyi bafe Allar šeba gori fari. ");
INSERT INTO rhg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ar oh ãr fuwa, tore šorbo šoktiwalar nobi hoi ḍaka oibo, kiyollahoile tũi Malikor age age zaibi edde Malikor fõt ṭik goribi. ");
INSERT INTO rhg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Edde Malikor manuš okkolore uddar sinaibi, hẽtte hitarar guna maf gora oibo, ");
INSERT INTO rhg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kiyollahoile ãrar Allar doyaye boraiya. Uworwalar fohor beil uṛefan oibo ãrar uwore, ");
INSERT INTO rhg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","zara andarot edde morar sabat boi roiye, edde ãrare šantir fõtot solai fare.\" ");
INSERT INTO rhg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ar fuwawa bari uiṭṭe edde ruhuye mojbut oiye; Israili okkolor munttu aibar age foijjonto Yahya bošoti sara elehat maze zibon haṛaiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hẽttiyaror din okkolot Rom dešor badša Agustusor hokum zari oiye, ze šara raijjor hár manuš okkolottu nam leka diya foribo. ");
INSERT INTO rhg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Siriyar šašon goroya Kuronir ṭaimot ei foila bar manuš gona oiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Har mainše nam leka dibolla nizor nizor farat za šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ar Yusuf aššilde badša Daudor bongšor manuš. Badša Daudor zormostan aššilde Ehudiya elehar Betlehem šohorot. Hetolla Yusuf o nam leka dibolla Galil elehar Nasarat farattu uwore Daudor šohor Betlehemot gil. ");
INSERT INTO rhg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Moriyam, zar loi Yusufor biyar hotabattara ṭik oil, ar he šomot hiba hamil aššil, hibaye o Yusufor fũwati nam leka dibolla heṛe giye. ");
INSERT INTO rhg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hitara heṛe giyede šomot hibar fuwa halasi oibar ṭaim oiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Toi hibaye foila fuwa morod fuwa halasi goijje. Ar hibaye he fuware hoor berai di hanḍailot neṛai diye. Kiyollahoile hitaralla heṛe hiyan sara ar hono mikka takibar zaga no aššil. ");
INSERT INTO rhg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Heṛe maṛot ḍakeduke hoekzon soolsoroya aššil, zara raitta soolor zãk fahara dil. ");
INSERT INTO rhg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ar Allar ek firista ai hitarar sarme hazir oiye. Toi Allar nuror tozolli sairo mikka oiye, henot soolsoroya okkole beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Firistaye hitarare hodde, \"No ḍoraiyo, kiyollahoile so, ãi tũwarare beši ḍõr kušir hóbor zanaito aišši; ei kuši hár manušolla oibo. ");
INSERT INTO rhg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kiyollahoile aziya Daudor šohorot tũwaralla ek basailoya zormo oiye; hiba oilde Mosi, Malik. ");
INSERT INTO rhg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ei hota soyide hiyanor sinno oilde, tũwara ek gura fuware hanḍailot hoor beraiya neṛaiya dekiba.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bade atikka he firistar fũwati ek ḍõr firistar dol behostottu ai zug diye edde hitara beggune Allare ganor šure tarif gora šuru goijje: ");
INSERT INTO rhg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"Uwore behostot Allar tarif ok, edde duniyait hibar manuš okkolor maze, zitarare loi Allah kuši hitarar uwore šanti ai ok!\" ");
INSERT INTO rhg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Firista okkol zehon hitarar henttu behostot giyegoi, soolsoroya okkole ekzone ekzonore hodde: \"Aiyo, ãra Betlehem foijjonto zai, ze hota Allaye ãrare firistar duwara zanaiye hin saigoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Toi hitara toratori he zagat fõiššegoi, heṛe Moriyam edde Yusuf, hanḍailot neṛaiya he gura fuwar deha faiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hitara he fuware deki bade he fuwar babute zin zin firistaye soolsoroya okkolore hoil hin hitara itarare zanai diye. ");
INSERT INTO rhg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ar zedun mainše soolsoroya okkolor hota fuinne, hitara beggune tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kintu Moriyame he šob hota mone mone bafa šuru goijje edde hin nizor dilot gãti raikke. ");
INSERT INTO rhg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ar soolsoroya okkolore zendilla howa oil, hitara hendilla hár kissu deki funi Allare tarif edde šukuriya zaniye. Toi bade hitara henttu uwafes firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ašṭo din bade fuware azomi goraibar ṭaim oiye, ar hẽtte nam raka oiye Isa. Mar feṛot aibar age firistaye ei namman dil. ");
INSERT INTO rhg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bade zehon Musar šoriyotot mozin pak saf oibar ṭaim oiye. Toi Yusuf edde Moriyame gura fuwa Isare Mabudor sarme tiya goraibolla Zeruzalemot loigiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Zendilla Mabudor ainot leka ase, \"Foila zormor har morodore Mabudor dora oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hin bade o hitara kurbani goitto giye, zendilla ainot kurbani dibar hota leka ase: \"Ek zura faikor so otóba duwa hoitoror basa.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hẽtte Zeruzalemot Simeon name ekzon dórmiyo edde allawala manuš aššil. Allaye hõtte Israil zatir dukkore dur goribo he ṭaimolla hibaye sai aššil. Pak Ruh hibar uwore aššil, ");
INSERT INTO rhg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ar Pak Ruhur duwara hibare batelai diya oi ze, Malik Messiyare no dekite hibar mout no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Toi hiba Pak Ruhor išara faiyore dórmogórot aišše. Ar zehon ma bafe fuwa Isare ainor rosom mozin furon goribolla dórmogóror butore ainne. ");
INSERT INTO rhg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Hetunot Simeone hibare fatarikula gori loiye edde Allar tarif gori hodde: ");
INSERT INTO rhg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"Mabud, tũi tũwar kalam mozin tũwar gulamore ehon šanti gori bidai goijjo, ");
INSERT INTO rhg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kiyolla buli hoile ãr dui suke tũwar uddarore dekilam, ");
INSERT INTO rhg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ziyan tũi har zatilla bebosta goijjo. ");
INSERT INTO rhg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Oihudi okkolor hãse forhaš oibar nur, ar tũwar zati Israilolla ijjot.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Hibar babute hoiyede hin okkolot fuwar baf edde ma tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ar Simeone hitarare duwa goijje edde Isar mare hodde: \"Sa, ei fuwaye Israilor butore boutore tole felaibo edde uwore tulibo, ar iba en ek sinno oibolla aišše zar bifokke boute matibo. ");
INSERT INTO rhg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Henot hitarar monor sinta forhaš oi zaiboi. Hin bade o, Moriyam tor dilot surir agator ḍoilla duk oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ar heṛe Hanna name ekzon maya fuwa nobi aššil, hiba aššilde Ašar bongšor Panuwelor zi, hibar umor beši oil. Hiba zuwan hale hãt bosor zamair gór gori bade, ");
INSERT INTO rhg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","aši sair bosor umor o foijjonto rari boni takkil. Ar hiba dórmogórot ruza edde munazat loi dine raite Allar ebadotot fori takito. Hibaye dórmogór sari hono mikka no zaitogoi. ");
INSERT INTO rhg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","He šomot Hannaye o heṛe aiyore šukuriya adai gora šuru goijje edde zedun manuš Zeruzalem azadir entezarot aiššil, hitarare hibaye Isar babute hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Toi hitara Mabudor ain mozin hár kissu fura gori bade Galil elehat, hitarar nizor fara Nasaratot firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ar fuwawa bari uiṭṭe edde mojbut oiye, giyane furaiya oiye, edde Allar rahamot hibar uwore aššil. ");
INSERT INTO rhg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Uddar idor šomot Isar ma bafe fotti bosor Zeruzalem zaito. ");
INSERT INTO rhg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Toi hiba zẽtte baro bosor oiye, hẽtte hitara hitarar idor niyom mozin uwore Zeruzalem giye; ");
INSERT INTO rhg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Toi idor din okkol šeš oi bade, hitara firi zargoide šomot, fuwa Isa fissa Zeruzalem tai giyegoi, ar hibar baf maye hiyan no zanito. ");
INSERT INTO rhg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Isa mainšor fũwati maze ase mone gori ek dinor fõtor baisa foijjonto hitara ai giyegoi. Bade hitara hitarar egena edde sina funa manuš okkolottu Isar talaš gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hitara zehon Isare tuwai no fa, hitara Isare tuwaibolla uwafes firi Zeruzalem giye. ");
INSERT INTO rhg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Šeše, tin din bade hitara Isare dórmogórot tuwai faiye. Isaye heṛe alem okkolor maze boi hitarar hota funat aššil edde hitarare suwal fusar goijjil. ");
INSERT INTO rhg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Zara Isar hota fuinne hitara Isar ahol deki edde zuwab funi beggune tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Isar baf maye Isare deki ammuwak oiye. Maye Isare hodde: \"Oh fut, tũi ãrar loi en kiyolla goijjo? Tũwar baf edde ãi hoto suhara oi tũware tuwa šuru goijjilam.\" ");
INSERT INTO rhg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kintu Isaye hodde: \"Tũwara kiyolla ãre talaš goijjila? Tũwara no zano ze ãttu ãr bafor górot taka foribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kintu Isaye hitarare ki hoiye hin hitara buzi no fare. ");
INSERT INTO rhg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tarfore Isa hitarar fũwati Nasarat uwafes firi giyegoi, edde baf mar hota mani soille. Isar maye in beggunore dilot gãti raikke. ");
INSERT INTO rhg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isa giyane edde boyoše bari uiṭṭe, Allah edde manušor adore. ");
INSERT INTO rhg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Badša Ṭaiberiyar razagiri fundoro bosor soledde šommot, Ehudiya elehar govarnar aššilde Pontus Filat. Hẽtte Herud Galil elehar, ar hitar bái Filip, Ituriya edde Trakonitisor šašon goroya aššil. Ar Lusaniyas aššilde Abileniya elehar šašon goroya. ");
INSERT INTO rhg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas edde Kaifas aššilde Ihudi okkolor ḍõr imam. Ṭik he šomot Allar kalam bošoti sara elehat maze Zakariyar fut Yahyar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ar hibaye Zordan giriyore asede hár zaga okkolot giye edde mon firaibar ek torikotor gusol tobolig goijje, ziyane guna okkolore maf diye, ");
INSERT INTO rhg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zendilla Esaiyah nobir kitabot iyan leka ase: \"Bošoti sara elehat ek abaze guzori zanaider, 'Tũwara Mabudor fõt ṭik goro, hibar rasta uzu goro. ");
INSERT INTO rhg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Har ḍeil okkol bora oibo, mura fahar fuwan gora oibo. Behã sura fõt fuwan gora oibo, bešoman rasta šoman gora oibo. ");
INSERT INTO rhg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ar hár mainše Allar uddar dekibo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Beši manuš okkole Yahyattu torikotor gusol loibolla niyoli giye edde hibaye hitarare hodde: \"Hafor dol okkol! Tũwarare Allar gozob lami aiyerde henttu dai zaibolla hũšiyar gori hone dilo? ");
INSERT INTO rhg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Toile gunattu mon firaiyode hiyanor laikka gula dorai tũwarar zibonot deho. Mone mone howa šuru no goijjo ze, 'Ãrattu baf Ibrahim ase.' Kiyollahoile ãi tũwarare hoir, Allaye ei fattor okkolottu Ibrahimolla fuwain fodai gori fare. ");
INSERT INTO rhg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ar gasor gurat kuroil ehon loti lagaiya ase. Ze hono gas zibat bala gula no doribo, hiba haṛi oinot felai diya oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Toi mainšor dol okkole Yahyare fusar goredde, \"Toile ãrattu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yahyaye hitarare hodde: \"Zattu duwa kuruta ase, hite zattu nai hitare uggwa dok. Ar zar hãse haiddo ase, hite o hen gorok.\" ");
INSERT INTO rhg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ar heṛe hazna adaigoroya o torikotor gusol loibolla aišše. Hitara Yahyare hodde, \"Ustad, ãrattu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hibaye zuwab diye, \"Ainot zen ase henor beši adai no goijjo.\" ");
INSERT INTO rhg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Šoinno okkol hoekzone o fusar goijje, \"Ãrattu ki gora foribo?\" Hibaye hitarare hodde, \"Hono kiyottu zurgori otóba oinnai bafe kissu adai no goijjo. Tũwara tũwarar beton loi razi tako.\" ");
INSERT INTO rhg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ar manuš okkole Mosilla entezar gori taikkede hisabe beggune mone mone bafa šuru goijjede,Yahya i Mosi oit fare. ");
INSERT INTO rhg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hetunot Yahyaye hitara beggunore hodde, \"Ãi tũwarare fani loi torikotor gusol dir ṭik, kintu en ekzon aiyer, ze ãttuwaro šoktiwala. Ãi hibar zutar fita kuli dibar laikka o no. Hibaye tũwarare Pak Ruh edde oin loi torikotor gusol dibo. ");
INSERT INTO rhg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kula hibar hatot ase, hõlat gĩyur dana zari foriškar goribolla. Gĩyur dana hinore hibar nizor gudamot rakibo, kintu tušore hono din no nifede hendilla oin loi furaidi felaibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yahyaye aro bout hota hoi manuš okkolore Allar diya kalam tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kintu Yahyaye badša Herudore jejeṛaiye, kiyollahoile hite hitar bái bou Herudiyare loi taikke edde aro bout kuham okkol goijje, ");
INSERT INTO rhg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","hitar oinno kuham okkolor fũwati aro ekkan noya kuham zug diye, hiyan oilde Yahyare ziyolot diye. ");
INSERT INTO rhg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ar zẽtte hár manuš okkole Yahyar hãse zaiyore torikotor gusol lor, Isaye o torikotor gusol loiye. Ar hibaye munazat goredde šomot asman kuligiyegoi, ");
INSERT INTO rhg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","edde he Pak Ruh ek hoitoror sonna loi Isar uwore lami aišše, ar behostottu ei abaz aišše: \"Tui ãr he adoijja Fut, tor uwore ãi kub kuši.\" ");
INSERT INTO rhg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Onumanik tiriš bosor oiyede šomot Isaye ham šuru goijje. Mainše mone goittode mozin Isa Yusufor fut, Yusuf Elir fut. ");
INSERT INTO rhg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli Mattátor fut, Mattát Levir fut, Levi Melkir fut, Melki Zannaiyor fut, Zannaiyor fut Yusuf, ");
INSERT INTO rhg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf Mottitiyar fut, Mottitiya Amošor fut, Amoš Nahumor fut, Nahum Ešalir fut, Ešali Nogir fut. ");
INSERT INTO rhg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nogi Mator fut, Mat Mottitiyar fut, Mottitiya Šimiyor fut, Šimiyo Yusekor fut, Yusek Zodar fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda Yohananor fut, Yohanan Resar fut, Resa Serubabelor fut, Serubabel Salṭiyolor fut, Salṭiyol Nerir fut. ");
INSERT INTO rhg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melkir fut, Melki Addir fut, Addi Kušomor fut, Kušom Elimadamor fut, Elimadam Eror fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Yosuvar fut, Yosuva Eliyesoror fut, Eliyesor Zorimor fut, Zorim Mattátor fut, Mottot Levir fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi Simeonor fut, Simeon Ehudar fut, Ehudah Yusufor fut, Yusuf Yonamor fut, Yonam Eliyakimor fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim Meleyar fut, Meleya Minnar fut, Minna Mottotiyar fut, Mottotiya Natanor fut, Natan Daudor fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud Yasiror fut, Yasir Obedor fut, Obed Buazor fut, Buaz Salmonor fut, Salmon Nahušonor fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahušon Omminadabor fut, Omminadab Adomanor fut, Adoman Ornir fut, Orni Hešronor fut, Hešron Ferošor fut, Feroš Ehudar fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ehudah Yakubor fut, Yakub Isakor fut, Isak Ibrahimor fut, Ibrahim Ṭerar fut, Tera Nahuror fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahur Šorugor fut, Serug Reuor fut, Reu Felegor fut, Feleg Eberor fut, Eber Šelar fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Šela Kenanor fut, Kenan Arpákšador fut, Arpákšad Šemor fut, Šem Nuhor fut, Nuh Lemekor fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek Metúšalar fut, Metúšalah Honnukor fut, Honnuk Yaredor fut, Yared Mahalalelor fut, Mahalalel Kenanor fut, ");
INSERT INTO rhg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enošor fut, Enoš Šetor fut, Šet Adamor fut, adom Allar Fut. ");
INSERT INTO rhg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isa, Pak Ruhor šoktiye furaiya oiyore Zordanottu firi aišše edde he Pak Ruhor išaraye bošoti sara elehat sairi goijje, ");
INSERT INTO rhg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","zeṛe hibare sališ din foijjonto šoitane dúha diye, ar he din okkolot maze Isaye hána hono kissu no há, he din okkol šeš oi bade hibattu buk laigge. ");
INSERT INTO rhg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Toi Šoitane Isare hodde, \"Tui zodi Allar Fut oi, toile ei fattorguware ho ruṭi oizagoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isaye hitare zuwabe hodde, \"Iyan endilla leka ase: 'Manuš šude ruṭi loi no base.'\" ");
INSERT INTO rhg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tarfore Šoitane Isare ek usol faharor uwore loigiye edde ek sator butore duniyair hár raijjore dehaiye. ");
INSERT INTO rhg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Toi Šoitane Isare hodde, \"Ãi tore ei hár odihar edde zak zomok diyum; kiyollahoile in ãre diya oiye, ar ãttu zare issa lage ãi hitare di. ");
INSERT INTO rhg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hetolla tui zodi ãre sojida goros, toile in beggun tor oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isaye zuwabe hitare diye: \"Leka ase: 'Tũi tũwar Mabud Allare sojida goro, edde lehar hibare šeba goro.'\" ");
INSERT INTO rhg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tarfore Šoitane Isare Zeruzalemor uwore loigiye edde dórmogóror tulir uwore tiya goraiyore hodde: \"Tui zodi Allar Fut, toile enttu nise zaf mar. ");
INSERT INTO rhg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kiyollahoile kitabot leka ase: \"'Hibaye hibar firista okkolore tor babute hokum dibo, tore uddar goribolla. ");
INSERT INTO rhg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hitara tore hatot gori tuli loibo, zene tor ṭengot fattoror ujaṭ no lage.'\" ");
INSERT INTO rhg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kintu Isaye hitare zuwab diye, \"Iyan endilla howa oiye: 'Tũi tũwar Allah Mabudore forikka no goijjo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Šoitane hibare hár ḍoilla gori dúha diya šeš oi bade, toi hite olfo ṭaimolla hibar hãsottu dur oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ruhor šoktit Isa Galilot firigiye edde elehar hár zagat hibar hóbor sorai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Isaye hitarar bout sinagog okkolot šikka diye edde beggune Isare tarif goijje. ");
INSERT INTO rhg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Isa Nasarat fara aišše, zeṛe hiba zuwan oil. Dórmor din Isaye nizor rosom mozin sinagogot giye. Heṛe hibaye pak kalam foribolla uṛi tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tarfore hibar hatot nobi Esaiyar leka kitabwa diya oiye. He rol beraiya kitabwa kuli hibaye he zagagan faiye zeṛe leka ase: ");
INSERT INTO rhg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"Allah Mabudor Ruh ãr uwore ase, kiyollahoile Allaye ãre ṭik goijje zene ãi gorib okkolor hãse kušir hóbor tobolig gori. Hibaye ãre bondi okkolor hãse azadir hota, anda okkolor hãse nozor danor hota gušona goribolla defeṛaiye. Zene zara zulum far hitarare ãi rehai gori fari. ");
INSERT INTO rhg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","edde Mabudor rahamotor bosor elan gori.\" ");
INSERT INTO rhg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tarfore Isaye he rol beraiya kitabware berai hademor hatot diye edde boišše. Muzolišhanar fotti mainšor suk Isar uzu oiye. ");
INSERT INTO rhg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Isaye hitarare en hoi šuru goijje, \"Pak kitabor ei kalam tũwara funone aziya hiyan furon oiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Henot beggune Isar babute goba diye edde Isar mukottu rahamoti hota funi hitara beggune tajjuf oiye. Hitara hodde, \"Iba Yusufor fuwa no?\" ");
INSERT INTO rhg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Isaye hitarare hodde, \"Tũwara ãre hameka en boson hoiba: 'Ḍakṭor, age nizore aramgor!' Aro hoiba 'Kofornahum šohorot zen zen gora oiye boli funni hendilla eṛe niz farat o hen gori deha.'\" ");
INSERT INTO rhg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Isaye aro hodde: \"Ãi tũwarare soiyi hoir, hono nobire nizor farar mainše no gose. ");
INSERT INTO rhg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ar ãi tũwarare hoir, soiyi oilde nobi Eliyasor ṭaimot zẽtte šaro tin bosor zór noddil edde har deš okkolot raṭ oil, hẽtte Israil dešot beša beši rari mayafuwain okkol aššil. ");
INSERT INTO rhg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kintu Eliyasore hitara honokiyor hãse defeṛa no o, bolke Sidon elehar Šarifot farar ek rari mayafuwar hãse defeṛa oil. ");
INSERT INTO rhg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nobi Elišar ṭaimot Israil dešot bout kurus biyaraimma okkol aššil, kintu hitara honokiyore aram gora no o, bolke Siriya dešor Namanore aram gora oil.\" ");
INSERT INTO rhg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ei hota funi he muzolišhanar manuš beggun guššaye oin oiye. ");
INSERT INTO rhg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ar hitara uṛi Isare he farattu ṭeli niyolai loi za šuru goijje. Hitara ze faharot fara bainde hiyanor haindar uwore loigiye edde Isare nise feli dito saiye. ");
INSERT INTO rhg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kintu Isaye hitarar mazottu ãṛi giyegoi, honokiye Isare sui no fare. ");
INSERT INTO rhg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Isaye nise Galil elehar Kofornahum šohorot giye edde dórmor din manuš okkolore šikka diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Manuš okkole Isar šikkat tajjuf oiye, kiyollahoile hibar kalam kemotawola aššil. ");
INSERT INTO rhg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Heṛe sinagogot napak butor ruhuye failde ekzon manuš aššil. ");
INSERT INTO rhg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","He manušwaye ḍak mari hodde: \"Oh, Nasarator Isa, õne loi ãrar loi ki talukkat? Õne ki ãrare binaš goitto aiššo? Ãi zani õne honnuwa, õne Allar he Pak zon!\" ");
INSERT INTO rhg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kintu Isaye hibare dõk diyore hodde: \"Nizam o, ei manušwar butottu niyoli ai.\" Toi he bod ruhuye manušware mainšor sarme meṛit asari felai raki hitar butottu niyoli giyegoi, manušwar hono hoti no o. ");
INSERT INTO rhg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Manuš okkol beggune tajjuf oiyore hitara ekzonore ekzone hodde: \"In ki hota! Odihar edde šokti loi napak but okkolore hokum de, ar hitara niyoli aiye!\" ");
INSERT INTO rhg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Toi ei hóbor he elehar hár mikka sorai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bade Isa muzolišhanattu niyoli Simonor górot giye. Hẽtte Simonor hori zor biyaram loi beši hošto fat aššil. Hetolla hitara hibare aram goribolla Isar hãse foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Toi Isaye Simonor horir ḍake tiyai zor biyaramore dõk diye. Ar hibattu zor sari giyegoi edde hibaye hehon uṛi hitaralla hána danar bebosta goijje. ");
INSERT INTO rhg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Beil dufedde ṭaimot maze, manušzon okkole har biyaraimma zara ḍoilla boḍoilla biyaram loi hoštofar, hitarare Isar hãse ainne. Isaye hitara fottizonor uwore hat raikke, edde hitarare aram goijje. ");
INSERT INTO rhg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ar beši mainšottu bod ruh niyoli giyegoi, bod ruh okkole guzori hodde, \"Tũi Allar Fut!\" Kintu Isaye hitarare dõk diye edde hoito no de, kiyollahoile hiba Moside hiyan hitara zainto. ");
INSERT INTO rhg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Din zehon oiye Isaye he zagattu zaigoire ekkan nirzon zagat giye. Manuš okkole Isare tuwai tuwai hibar hãse giye. Hitara Isare berai dori taikke zene hiba hitarar hãsottu no zagoi. ");
INSERT INTO rhg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kintu Isaye hitarare hodde, \"Aro bout zagat zai ãttu Allar raijjor kušir hóbor tobolig goragoi foribo, kiyollahoile Allaye ãre in goribolla defeṛaiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tarfore Isaye Ehudiya elehar sinagog okkolot zai zai kušir hóbor tobolig gorat taikke. ");
INSERT INTO rhg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ek šome Isa Gennesaret halor farot tiyaiye. Heṛe manuš okkole Isattu Allar kalam funibolla ṭelaṭeli goijje. ");
INSERT INTO rhg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Isaye sadde halor hãsat duiyan no ase, kintu zailla okkole henttu lami zai zal duwer. ");
INSERT INTO rhg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Henot oi duiyan nor butottu, Isaye Simonor not uiṭṭe. Ar hitare nogan kulottu ekkena dure loi zaibolla hoiye. Toi Isaye not boi manuš okkolore šikka diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Isaye hota howa šeš gori bade hibaye Simonore hodde, \"Tui tor noganore entu maze loi za, ar mas saibolla tor zal felagoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simone hodde, \"Ustad, ãra šara rait mehennot gori kissu no fai, tarfore o õne zehon hor, ãi zal felaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hitara zal felaiye bade en masor ḍõr zãk dora foijje, zenneki hitarar zal udda siri zaitoi saiye. ");
INSERT INTO rhg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Henot hitarar šiyardar okkol zara oinno not ase, hitarare o hate išara gori ḍaikke, zene hitara aiyore itarare modot gori fare. Hitara aiyore duiyan no en bafe mas loi botti goijje, zene no duniyan dufi zaibar alamot oiye. ");
INSERT INTO rhg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ei hanḍo deki Simon, zare Fitor hoi o ḍake, hite Isar sarme uite fori hodde, \"Malik õne ãr hãsottu zogoi, ãi gunagar.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kiyollahoile zalot eto mas dora foijje, Simon edde hitar sãti okkol beggune tajjuf oiye, ");
INSERT INTO rhg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ar hendilla ekkui bafe Simonor šiyardar, Sebudiyusor fuwain Yakub edde Yuhanna o tajjuf oiye. Hetunot Isaye Simonore hodde, \"No ḍorais, ehon loti tui manuš doribi.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tarfore hitara hitarar nogunore kulor uwore tuli felaiyore, hár kissu felai raki Isar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isaye ek bar ek šohorot giye. Heṛe ekzon kurus biyaraimma manuš aššil, zar hara ga gáye furaiya aššil. Isare deki he manušwaye meṛir uzu oi uite fori Isattu duwa sai hodde, \"Malik, õne issa gorile ãre bala gori fariba.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isaye hat ṭani hitare suiyore hodde, \"Ãi sai, tũi foriškar o!\" Ar hehon hitar kurus biyaram bala oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Isaye hitare endilla hokum diye, \"Ei hota honokiyore no hois, bolke zaiyore dórmiyo Alem okkolore dehagoi, toi bade saf oi faijjosde hiyanolla Musar ain mozin ekkan kurbani gorgoi. Henot mainšor hãse tui foriškar oiosde hiyanor forman oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tarfore o Isar hóbor aro beši sorai giyegoi. Isar hota funibolla edde biyaraimma okkol aram oibolla bout manuš okkol Isar hãse aiya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kintu Isaye hamiša nirzon zagat zai duwa gorito. ");
INSERT INTO rhg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ek din Isaye šikka der, hen šomot Foroši okkol edde dórmiyo alem okkol Isar hãse ai boiššegai. Hitara aššilde Galil edde Ehudiya elehar bout fara okkolor edde Zeruzalem šohoror manuš okkol. Biyaraimma aram goribolla Mabudor šokti Isattu aššil. ");
INSERT INTO rhg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hetunot hoekzon mainše ekzon leng biyaraimmare haiṭṭa loi bar gori ainne. Hitara hitare butore loi zaiyore Isar sarme rakito saiye. ");
INSERT INTO rhg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kintu zamila buli hitare butore loizaibar fõt no fa. Hetunot hitara góror salor uwore uiṭṭe edde salor sani hana gori bisana šo hitare manuš okkolor maze Isar sarme lamai diye. ");
INSERT INTO rhg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isaye hitarar biššaš dekiyore hodde, \"Bondu, tor guna maf gora oiye!\" ");
INSERT INTO rhg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Henot dórmiyo alem edde Foroši okkole mone mone bafa šuru goijje, \"Ite honnuwa, ze Allare ofoman gorer? Allah sara ar honokiye guna maf gori di no fare!\" ");
INSERT INTO rhg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hitara mone mone ki sinta goijje Isaye buzi fariyore hodde: \"Tũwara mone mone hendilla ka bafor? ");
INSERT INTO rhg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tor guna maf gora oiye howa asan oibo ne naki tui uṛi ãṛi bera howa asan oibo? ");
INSERT INTO rhg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kintu duniyait guna maf gori dibar kemota Adomor Futottu ase, hiyan zene tũwara zani faro.\" Hen hoi Isaye he leng manušwar mikka firi hitare hodde, \"Ãi tore hoir, uṭ, tor bisanagan tuli loi górot zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ar manušwa hehon beggunor sarme tiyaiye edde hite neṛi aššilde bisanagan tuli loiye, edde Allare šukuriya gori gori górot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Henot beggune kub tajjuf oiye edde Allare šukuriya zanaiye. Ar hitarattu Allar ḍor góille edde hodde, \"Aijja ãra ki tajjuiffa ham dekilam!\" ");
INSERT INTO rhg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tarfore Isa henttu niyoli giyegoi edde dekedde Levi name ekzon hazna adaigoroya, hite hazna tulede zagat boi taikke. Isaye Levire hodde, \"Ãr fisa lo!\" ");
INSERT INTO rhg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Toi hite o uiṭṭe edde hitar hár kissu felai raki Isar fisa loiye. ");
INSERT INTO rhg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bade Levi manušwaye hitar górot Isalla ek ḍõr hána goijje. Heṛe aro bout hazna adaigoroya okkol edde aro bout manuš okkol šoho hitarar fũwati hána haito boišše. ");
INSERT INTO rhg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hetunot heṛe aššilde Foroši okkol edde hitarar dórmiyo alem okkole Isar sahabi okkolore nališ gori hodde, \"Tũwara hazna adaigoroya edde gunagar okkol loi kiyolla há fiya goro?\" ");
INSERT INTO rhg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kintu zuwabe Isaye hitarare hodde, \"Araimma mainšottu ḍakṭoror dorhar nai, kintu biyaraimma mainšottu dorhar ase. ");
INSERT INTO rhg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ãi forhesgar okkolore no, kintu gunagar okkolore ḍakito aiššide, zene hitara gunattu mon fira.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Toi hitara hibare hodde, \"Yahyar šagirit okkole hamiša ruza rake edde munazat gore, Foroši okkolor šagirit okkole o hen gore, kintu õnor sahabi okkole há fiya gorat take.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isaye hitarare hodde: \"Dula fũwati taite dular fũwajja okkolore ki tũwara ruza rakai fariba? ");
INSERT INTO rhg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kintu en šomoi aiyer, zẽtte hitarar hãsottu dulare loi za oibo, ar he din okkolot hitara ruza rakibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hibaye hitarare ekkan mesal kahani o hoiye: \"Noya kurutattu ṭura siri honokiye furan kurutat tali no laga. Kiyollahoile, hen gorile to noya kurutawa siri fela o. Ar he noya taligan o furan kurutar fũwati no mana. ");
INSERT INTO rhg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Otóba honokiye no ḍale tottoza šoraf furan samorar hoillat. Kiyollahoile ḍalile he tottoza šorafgune hoillagunore fuṛai felaibo, henot šorafgun o goli zaiboi edde hoillaguno o nošto oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","No, tottoza šoraf noya samor hoillat raka foribo. ");
INSERT INTO rhg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Furan šoraf hái bade honokiye tottoza šoraf haito no sa, kiyollahoile hite hoibo, 'Furangun bala beši.'\" ");
INSERT INTO rhg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hono ek dórmor din Isaye fõtot hono ek gĩyuketi bai gil. Isar sahabi okkole giyũrdanar sora siri hatot góši góši há šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hetunot hozon forošiye hodde, \"Ain mozin dórmor din zin gora mana hin kiyolla goror?\" ");
INSERT INTO rhg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isaye hodde: \"Daud edde hibar fũwajja okkolottu zehon buk laggil hẽtte ki goijje hin ki tũwara no foro? ");
INSERT INTO rhg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hibaye to Allar górot goillil, edde sarme rakkilde ruṭi loi háil edde hibar fũwajja okkolore dil, zin šude imam okkole haibar ain ase.\" ");
INSERT INTO rhg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bade Isaye he Foroši okkolore hodde, \"Adomor Fut oilde dórmor dinor malik.\" ");
INSERT INTO rhg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ar ek dórmor din Isaye sinagogot giye edde šikka diye. Heṛe en ekzon manuš aššil zar ḍen hat mozigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dórmiyo alem okkol edde Foroši okkole, Isaye dórmor din he manušware aram gore ki no gore hiyan saibolla, hitara Isar uwore bala bafe nozor raikke. Toi zene hitara Isare hosuri dibar haron tuwai fa. ");
INSERT INTO rhg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kintu Isaye hitarar monor sinta zainto. Hetolla he hat mozi giyegoide manušware Isaye hodde, \"Uṛi beggunor munttu ai tiya!\" Henot hite uṛi tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Isaye dórmiyo alem okkol edde Foroši okkolore hodde,\"Ãi tũwarare ekkan hota fusar gori, dórmor din ki gora ezajot ase? Bala ham gora ne naki horaf ham gora? Foran basa ne naki foran dongšo gora?\" ");
INSERT INTO rhg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tarfore Isaye sairo ḍakor beggunor mikka sai manušware hodde: \"Tor hattan mum mikka ṭan.\" Hite hen goijjebar hitar hattan ekkubare bala oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hetunot hitara guššaye heṛe uzora uzori oi giyegoi edde Isare ki gora zaibo he babute hitara hitara biyasana goijje. ");
INSERT INTO rhg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","He din okkolot ekdin hiba munazat goribolla ek faharor uwore uiṭṭe, edde heṛe hibaye Allar hãse munazat gorat šara rait haṛai diye. ");
INSERT INTO rhg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bade binna zehon oiye, hibaye hibar šahabi okkolore ḍaikke edde hitarar butottu barozonore basi loiye, zarare asab hoi nam diye: ");
INSERT INTO rhg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, zare Isaye Fitor hoi nam diye edde hitar bái Andreas, Yakub, Yuhanna, Filip, Bartolomeus, ");
INSERT INTO rhg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Moti Ṭomas, Alfeusor fuwa Yakub, Simon, zare bahadur Zelot hoito, ");
INSERT INTO rhg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakubor fut Ehudah, edde Ehudah Iskariyot, ze Isare dušmon okkolor hatot dori diye. ");
INSERT INTO rhg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hibaye hitarare fũwati loi faharottu abar lami giye edde ekkan fuwainna zagat tiyaiye. Heṛe hibar ek ḍõr sahabi okkol edde Šara Ehudiyattu, Zeruzalem edde doriyar hãsar Sidon edde Tirosottu o aro bout beši manuš okkol, ");
INSERT INTO rhg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","zara heṛe hibar boyan funibolla edde biyaramottu aram oibolla heṛe aišše. Ar zara napak ruh loi duk fail, hitarare o hibaye bala goijje. ");
INSERT INTO rhg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Edde hár mainše hibare suibolla kušiš goijje, kiyollahoile hibar butottu ek šokti niyoli gil edde harkiyore aram goijjil. ");
INSERT INTO rhg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Isaye sahabi okkolor uzu suk tuli hodde: \"Allar rahamot tũwarar uwore zara gorib, Allar raijjo tũwarar. ");
INSERT INTO rhg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Allar rahamot tũwarar uwore zara ehon waišša, tũwarar buk miṭa oibo. Allar rahamot tũwarar uwore zara ehon handor, tũwara hašiba. ");
INSERT INTO rhg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Allar rahamot tũwarar uwore, zẽtte Adomor Futolla buli, mainše tũwarare hingša gore, tũwarare šomazottu niyolai de, ar ofoman gore, edde tũwarar nam horaf hoi tũwarare batil gore. ");
INSERT INTO rhg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","\"He dinot anondo goro edde kušiye fal maro, kiyollahoile, so, behostot tũwaralla enam beši ḍõr. Kiyollahoile hitarar bafdada okkole o nobi okkolor loi endilla bebohar okkol gorito. ");
INSERT INTO rhg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","\"Kintu bifod tũwarare, zara tuwangor, tũwara tũwarar šantona faifelaiyo. ");
INSERT INTO rhg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bifod tũwarare zara ehon feṭ borai faror tũwarattu buk lagibo. Bifod tũwarare zara ehon hašor, tũwara bilak goriba edde handiba. ");
INSERT INTO rhg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bifod tũwarar, zẽtte hár mainše tũwarare šunam gore. Hitarar bafdada okkole o bonḍo nobi okkolore hendilla goitto. ");
INSERT INTO rhg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"Kintu tũwara zara funor ãi hitarare hoir: Tũwarar dušmonore o muhabbot goro, zara tũwarare hingša gore hitarare balai goro. ");
INSERT INTO rhg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Zara tũwarare bodduwa de, hitarare duwa goro. Zara tũwarare ninda gore hitaralla munazat goro. ");
INSERT INTO rhg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ze tũwar ek galot suwar mare, hitar mikka oinno galo lagai diyo, ar ze tũwar saddor kuli lor, hitare bazu kuli loite o mana no goijjo. ");
INSERT INTO rhg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ar ze honokiye tũwattu kissu sa, hitare diyo, edde ze honokiye tũwarar hono kissu loi za, hin ar uwafes no saiyo. ");
INSERT INTO rhg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","\"Funo, mainše tũwarare zendilla gorok aša goro, tũwara o hitarar loi hendilla bebohar goro. ");
INSERT INTO rhg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","\"Ar zara tũwarare muhabbot gore, šudu hitarare muhabbot gorile tũwara ki gun faiba? Hendilla muhabbot to horaf mainše o gori take. ");
INSERT INTO rhg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ar zara tũwarar ufohar gore, šudu zodi hitarar ufohar goro, toile tũwara ki gun faiba? Hendilla to gunagar mainše o gore. ");
INSERT INTO rhg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ar zarar hãsottu uwafes faibar aša take, hali zodi hitarare udar do, toile tũwara ki gun faiba? Horaf mainše o horaf manuš okkolore udar de, zene hedun firaifa. ");
INSERT INTO rhg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kintu tũwara nizor dušmonore o muhabbot goro edde hitarar balai goro. Uwafes faibar aša no raki udar do. Toile tũwarar enam ḍõr oibo edde tũwara šorbo šoktiwala Allar fuwain oiba. Haron Allah našukur edde horafore o doya gore. ");
INSERT INTO rhg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tũwarar behostiyo Baf zendilla rahamoti, tũwara o hendilla rahamoti o. ");
INSERT INTO rhg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","\"Ar tũwara bisar no goijjo, henot tũwarare o bisar gora no oibo. Duši no goijjo, henot tũwarare o duši gora no oibo. Tũwara sari do, henot tũwarare o sari diya oibo. ");
INSERT INTO rhg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dan goro, henot tũwarare o diya oibo. Beši forimane sibi sibi, zankai zankai, zaf di forefan gori tũwarar kulot diya oibo, kiyollahoile tũwara ze bafe mafi do, he bafe tũwaralla o mafa oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ar hibaye ekkan boson o hoiye: \"Ekzon andaye ki ar ekzon andare fõt dehai faribo? Dunizon gorot fori no zaiboi ne? ");
INSERT INTO rhg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Šagirit ustator uwore no, kintu ze furafuri šikka fa, hite hitar ustator ḍoilla o. ");
INSERT INTO rhg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","\"Ar tũwar báiyor sukot ze hal ase hiyan kiyolla dekor, kintu tũwar nizor sukot ze gasor ḍõr seli ase hiyan kiyolla bafi no sor? ");
INSERT INTO rhg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tũwar sukot ze gasor seli ase hiyan zehon no dekor, toile tũi ken gori ar ekzonore hoi faror, 'Bái aiyo, ãi tũwar sukottu hallan loifelai, 'Oh munafek! Age nizor sukor gasor ḍõr seli hiyan loifela, toi bade tor báiyor sukot ze hal ase hiyan loi felaibolla foriškar gori dekibi. ");
INSERT INTO rhg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","\"Bala gasot horaf gula dorede hendilla hono hota nai, ar hendilla horaf gasot o bala gula no dore. ");
INSERT INTO rhg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gula sai gas sinaza. Mainše keṛarzalittu ḍuirgula ba kẽṛagasottu ãngur no tule. ");
INSERT INTO rhg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bala manuše hitar dil boraiya balattu bala hota bair gori ane, ar horaf mainše hitar dil furaiya horafottu horaf hota bair gori ane, kiyollahoile zar dil zine furaiya, hitar gale hin ho. ");
INSERT INTO rhg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","\"Tũwara ãre Malik, Malik hoi ka ḍako, ãi ziyan hoi hiyan zodi no goro? ");
INSERT INTO rhg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ze honokiye ãr hãse aiye, ãr hota fune edde he mozin gore, hite hár ḍoilla ãi tũwarare dehai. ");
INSERT INTO rhg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hite en ekzon manušor ḍoilla, ze gór bandibolla murgori meṛi kuijje edde fattoror uwore faiya gãijje. Bade he góror uwore boinna aišše edde ḍollor fani aišše, to górganore lari no fare, kiyollahoile hiyan mujbut gori banda oiye. ");
INSERT INTO rhg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ar ze ãr hota fune, kintu he mozin no gore, hite en ekzon manušor ḍoilla, ze faiya no gãri meṛir uwore gór bainde. Bade he górot ḍollor fani aišše, hetunot he górgan fori ekkubare dongšo oi giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Toi Isaye manuš okkolore šikka diya šeš gori bade hiba Kofornahum šohorot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Heṛe ekzon Rom šenafotir gulamottu ošuk oi foran zar zar oiye. Ei gulamore he šenafotiye beši ador gorito. ");
INSERT INTO rhg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hite Isar hóbor funi hoekzon Ihudi murobbi mainšore Isar hãse aroz goribolla defeṛaiye zene Isaye zai hitar gulamore aram gori fare. ");
INSERT INTO rhg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hitara Isar hãse zai Isare beša beši aroz gori hodde, \"Õne zalla ei ham goriba hite iyan faibar laikka, ");
INSERT INTO rhg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kiyolla buli hoile hite ãrar mainšore ador gore edde ãrare sinagog banai diye.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Henot Isa hitarar fũwati giye. Isaye hitar góror hãsa hãsi aišše de hetunot, oi šenafotiye hitar hoekzon fũwajjare hoi defeṛaiyede: \"Malik, nizore ar duk no diyo, kiyollahoile õne ãr góror salor tole aiyo, ãi he laikka no. ");
INSERT INTO rhg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ar ãre ãi o õnor hãse aibar laikka mone no gori. Kintu õnor muke ho, henot ãr gulam bala oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ãi iyan zani, kiyollahoile ãttu o oinno zonor hokum mozin sola fore, ar ãttu o šena okkol ase. Zodi ãi ekzonore 'Za,' hoi hite za. Ar ekzonore 'Ãi,' hen hoile hite aiye. Ar ãr gulamore 'Iyan gor' hen hoile hite hiyan gore.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ei hota funi Isaye tajjuf oiye. Ze šob manuš okkol Isar fise fise aišše hitarar uzu firiyore hodde, \"Ãi tũwarare hoir, Israili okkolor butore o eto ḍõr biššaš ãi ar hono šome no deki.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Šenafotiye defeṛailde hitara górot firizai sadde he šenafotir gulammuwa aram oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hotun bade Isa Nain name ek farar mikka za šuru goijje. Hibar fũwati sahabi okkol edde ek ḍõr mainšor dol o giye. ");
INSERT INTO rhg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ar hiba ṭon geiṭor hãsa hãsi aišše, toi ar so heṛe ek mora lašore bargori hoborstanot gãraito loizar. He lašwa aššilde ek mar lehar ek fut, he ma aššilde ekzon rari maya fuwa. Ar hibar fũwati šohorottu bout manuš okkol aššil. ");
INSERT INTO rhg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Malik Isaye he rarir mayafuwaware deki beši doya laigge edde hibare hodde, \"No haindis!\" ");
INSERT INTO rhg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tarfore Isaye hãse zai hãiṭṭagan suiye. Ar hãiṭṭa boi loizaoya okkole tiyaiye. Toi Isaye hodde, \"He zuwan fuwa, ãi tore hoir: Uṭ!\" ");
INSERT INTO rhg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hen šomot he mora lašwa uṛi boišše edde hite hota howa šuru goijje. Toi Isaye hitare hitar mar hatot tulidiye. ");
INSERT INTO rhg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hetunot beggunor dilot Allar ḍor góille edde Allar tarif gori howa šuru goijje. \"Ãrar maze ekzon moha nobi uiṭṭe, ar Allaye hibar bonda okkolor uzu mon diye!\" ");
INSERT INTO rhg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bade šara Ehudiya edde hiyanor sairo mikkar elehat Isar hanḍor babute sorai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yahyar šagirit okkole ei šob goṭona beggun Yahyare funaiye. Ar Yahyaye duizon šagiritore ḍaikke, ");
INSERT INTO rhg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","edde hitarare Malik Isar hãse fusar goitto defeṛaiye, \"Ze aibar hota, he zon ki õne, naki ãra oinno zonolla entezarot takiyum?\" ");
INSERT INTO rhg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Toi hitara Isar hãse zaiyore hodde, \"Torikotor gusol doya Yahyaye ãrare õnor hãse defeṛaiye, 'Ze aibar hota he zon ki õne, naki ãra oinno zonor entezarot takiyum?'\" ");
INSERT INTO rhg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","He šomot Isaye bout manuš okkolore biyaram, hošto edde bod ruh, in okkolottu hitarare aram goijje. Hibaye aro bout anda mainšor sukore bala gori diye. ");
INSERT INTO rhg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Isaye Yahyar šagirit dunizonore endilla zuwab diye, \"Tũwara zo, zin deikko edde fuinno he hóbor Yahyare hogoi: Andaye deker, lenge aṛer, kurus biyaraimma pak saf or, nafange funer, mora uṛi zargoi, edde gorib okkololla bala hóbor tobolig gora or. ");
INSERT INTO rhg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ar mubarok hite, ze ãr zoriya ujaṭ hái fori no zagoi\" ");
INSERT INTO rhg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yahyar hoborguwa okkol zaigoi bade, hibaye manuš okkolore Yahyar babute howa šuru goijje: \"Tũwara bošoti sara elehat ki saito gilade? Boyare lorede hóir ne? ");
INSERT INTO rhg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","No oile, ki saito gilade? Šundor hor findda ekzon manušore ne? So, dami hor finde edde zak zomok loi zibon haṛa, hitara mehelot take. ");
INSERT INTO rhg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Toile ki saito gilade? Ki ekzon nobi re? Oi, ãi tũwarare hoir, ekzon nobittuwaro beši! ");
INSERT INTO rhg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iba oilde hiba zar babute kitabot leka ase: \"'Sa, ãi tor age ãr hóborguware defeṛair, hite tor age zai tolla fõt saf goribo.' ");
INSERT INTO rhg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ãi tũwarare hoir, narittu zormo oiyede hitarar maze, Yahyattuwaro mohan kiye nai; tarfore o Allar raijjot ze šobsaite beši šoṛo, hite o hibattuwaro mohan.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Ar šomosto manuš okkol edde hazna adaigoroya okkole ei hota funi Allah niyaiban hoi kobul goijje, kiyollahoile hitara Yahyar hãsottu torikotor gusol loiye, ");
INSERT INTO rhg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu Foroši edde dórmiyo alem okkole Yahyar hãsottu torikotor gusol no lowat hitara nizor šommonde Allar eredare befol goijje.) ");
INSERT INTO rhg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","\"Henoile ei zobanar manuš okkolore ãi har loi tulona goijjum? Hitara honḍoilla? ");
INSERT INTO rhg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hitara en fuwaindor ḍoilla zara bazarot boi ekzone ar ekzonore ḍakiyore hodde: \"'Ãra tũwaralla baši bazailam, kintu tũwara no nasila. Ãra dukkor gan gailam, kintu tũwara no handila.' ");
INSERT INTO rhg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kiyollahoile torikotor gusoldoya Yahya aišše, edde hite ruṭi ba ãnguror roš no har, ar tũwara hor, 'Hitare bute faiye.' ");
INSERT INTO rhg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ar Adomor Fut ai há fiya gorer buli tũwara hor: 'So, ei manušwa hánar lalsi bonda edde šorafkur, ar hazna adaigoroya mainšor bondu.' ");
INSERT INTO rhg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kintu Allar giyanor butore ze za hitar zibone forman gore ze Allar giyan soiyi.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ekzon forošiye hitar górot Isare hánar dawat diye. Hetunot Isa he forošir górot giye edde hána haito boišše. ");
INSERT INTO rhg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ehon, he šohorot ek gunagar maya fuwa aššil. Hibaye Isa he forošir górot hána hadde zani fariyore ek dola fattoror boyomot gori kušbo tel loi hiba heṛe aišše. ");
INSERT INTO rhg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bade hibaye Isar fis ḍakottu ṭengor hãse zai tiyaiye edde hainde. Tarfore sukor fani loi, Isar ṭengor fata bizai diye edde hibar matar sul loi hin fũsi loiye. Tarfore hibaye Isar ṭengor fatat suma diye edde kušbo tel maki diye. ");
INSERT INTO rhg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Toi ze forošiye Isare dawat dil hite ei abosta deki mone mone hodde, \"Ei manušwa zodi nobi oito toile zani farito, iba hon ḍoilla maya fuwaye suwer, kiyollahoile hiba ekzon gunagar maya fuwa.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hetunot Isaye he forošire hodde, \"Simon, ãttu tore kissu hoibar ase.\" Hite hodde, \"Ustad, ho na.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","\"Ekzon ṭĩya udar doyattu duizon mainše hozzo loiye. Ekzone hozzo loiye fãs šot ṭĩya, ar ekzone fõnzaš ṭĩya. ");
INSERT INTO rhg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kintu hitarar he hozzo fuzibar ra no takone, ṭĩya udar doyaye hitara dunizonor hozzogun maf gori diye. Ehon, itarar butore hone he ṭĩya udar doyare beši muhabbot goribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simone hodde, \"Zar beši hozzo maf oiye, hite boli mone gori ãi.\" Isaye hodde, \"Tui ṭik hoiyos.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Toi Isaye he mayafuwawar uzu firiyore Simonore hodde, \"Ei mayafuwaware dehor ne? Ãi tor górot golilam, tui ãre ṭeng dúibolla fani no dos, kintu ibaye sukor fani di ãr ṭeng bizaiye edde nizor sul loi hin fũsi loiye. ");
INSERT INTO rhg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tui ãre suma di solam no goros, kintu zehon loti ãi butore aišši, hibaye ãr ṭengor fatat suma diyat roiye. ");
INSERT INTO rhg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tui tel di ãr matat maki no dos, kintu hibaye kušbo tel ãr ṭengot maki diye. ");
INSERT INTO rhg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hetolla ãi tore hoir, Hibaye beši guna gorile o hibar guna maf gora oiye, ar etolla hibaye beši muhabbot dehaiye. Kintu zare olfo maf gora za, hite olfo muhabbot deha.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bade Isaye he mayafuware hodde, \"Tor guna maf gora oiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Zara Isar fũwati hána haito boiššil hitara hitara howa hoi gora šuru goijje, \"Iba honnuwa ze guna udda maf gori de?\" ");
INSERT INTO rhg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Isaye hetunot he mayafuwaware hodde, \"Tor imane tore uddar goijje, šanti gori zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tarfore Isaye elan goribolla edde Allar raijjor mutallek kušir hóbor tobolig goribolla fara fara, šohore šohore gura šuru goijje. Ar fũwati he barozon sahabi, ");
INSERT INTO rhg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","edde zara bod ruhuttu uddar faiye, biyaramottu aram faiye hendilla hoekzon mayafuwain o fũwati aššil. Hitarar butore aššilde: Moriyam zare Mogdaleni hoi o ḍakito edde zar butottu hãttuwa bod ruh niyoli gilgoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana ze badša Herudor menezar Kusar bou. Susanna edde aro bout mayafuwain okkol. Hitarar nizor šombottittu Isa edde he barozon sahabi okkolore solaito. ");
INSERT INTO rhg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ar zẽtte beša beši manuš okkol bout šohor okkolottu aiyore Isar hãse ai birgorer. Toi Isaye hitarare šikka dibolla ei kahanigan hoiye: ");
INSERT INTO rhg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"Ekzon sašaye hitar bizor dana šiṛibolla giye. Biz šiṛibar šomot hodun biz fõtor kinare foijje, hin manušor fortole oiye edde faik okkole hái felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ar hodun biz šil meṛir uwore foijje edde hin heṛe fuiṭṭe, kintu fanir obafe saragun fuwai gilgoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Abar hodun biz keṛarzaliwala zagat foijje, he saragun keṛarzalir fũwati bari uiṭṭe, edde hinore keṛarzaliye sibi dori raikke. ");
INSERT INTO rhg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Abar hodun biz bala zobinot foijje, hin bari uiṭṭe edde ek šot gun gula diye.\" Ei kahanigan hoi bade Isaye zur gola loi hodde, \"Zar han ase hite funok!\" ");
INSERT INTO rhg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hibar sahabi okkole ei mesal kahaniganor mani ki fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Isaye hodde, \"Allar raijjor gufon soiyi tũwarare zainto diya oiye, kintu hitarar hãse kahanir mesale howa oiye, zene, \"'Hitara deke kintu no deke, ar fune kintu no buze.' ");
INSERT INTO rhg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","\"Ei mesal kahaniganor mani oilde endilla: Biz oilde Allar kalam. ");
INSERT INTO rhg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fõtor kinare foijjede bizor mesal hitarare diya oiye, zara kalam fune, kintu Šoitane ai hitarar dilottu hiyan tuli loi zagoi. Henot hitara ar hiyanor uwore iman ani no fare boli uddar oi no fare. ");
INSERT INTO rhg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Šil meṛit foijjede bizor mesal hitarare diya oiye, ze he kalam fune edde kuširsate mani lo, kintu hitarattu hiyanor hono šiyõr nai; hitara olfo dinolla biššaš gore, ar forikkar šomot hitara fissa fori zagoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Keṛarzaliwala zagat foijjede bizor mesal hitarare diya oiye, zara kalam fune kintu zibon fõtot soilte soilte, šongšari sinta bafona, dón šombotti edde aram aiyešor maze hin sibot fori zagoi, hetolla zibonot hono fona fól deha no de. ");
INSERT INTO rhg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bala zobinot foijjede bizor mesal hitarare diya oiye ze soiyi šorol mone he kalam fune, edde mojbut gori kolobor butore dori rake ar hitarar sobori zibonot fona fól dore. ");
INSERT INTO rhg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"Ar serag zali honokiye dešši loi guri no rake otóba haṭor tole no rake, kintu serag boiṛonir uwore rake, zene zara butore za, hitara fohor deki fare. ");
INSERT INTO rhg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Henot en gufon kissu no takibo zin forhaš no oibo otóba en sufaiya kissu no takibo zin zana no zaibo ba deha no zaibo. ");
INSERT INTO rhg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hetolla tũwara hondilla gori funor he babute diyan do, kiyollahoile zattu ase hitare aro diya oibo. Ar zattu nai hite hitattu zin ase boli mone gore, hin o hitattu loifela oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ar Isar ma edde báiboinain okkole Isare saito aišše. Kintu hitara mainšor zamilalla buli Isa loi deha gori no faijjil. ");
INSERT INTO rhg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bade ekzone Isare hodde: \"Õnor ma báiboinain okkole baire tiyai taikke, õne loi deha goitto sar.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kintu hibaye hodde, \"Itara zara Allar kalam fune edde he bafe falon gore, hitara oilde ãr ma edde báiboinain.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ek din Isa edde Isar sahabi okkol ekkan not uiṭṭe. Isaye hitarare hodde, \"Solo, ãra doriyar ofarot zai.\" Toi hitara no sajje, ");
INSERT INTO rhg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","edde hitara šor tulidi no solat maze Isa gumot fori giyegoi. Ar doriyat en tuwan oiye, henot hitarar nogan faniye furaiya owa šuru goijje. Henot hitara beša beši bifodot fori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hitara Isar hãse zai Isare gumottu tulidi hodde, \"Malik, Malik ãra ḍufizairgoi!\" Hetunot Isa uṛi boyarore edde goirore dõk diye, ar boyar edde goir hanta oiye, hár kissu nirol oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tarfore Isaye sahabi okkolore hodde, \"Tũwarar biššaš hoṛe?\" Kintu hitara ḍore ammuwak oiye edde ekzonore ekzone hodde: \"Iba honnuwa? Hibaye boyar edde doriyare hokum gore, ar hitara hibar hota mane!\" ");
INSERT INTO rhg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tarfore hitara Geraseni okkolor dešot no loi fõisse, ziyan Galilor dusora faror mikka. ");
INSERT INTO rhg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ar Isa zẽtte farot laimme he šohoror ekzon bod ruhuye faiya manuš loi deha oiye. Bout dinottu loti ei manušwaye hor no finder edde górot no taker, kintu hoboror gãtot taker. ");
INSERT INTO rhg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hite Isar sarme meṛit uite fori guzori hodde: \"Oh Isa, šoktiwala Allar Fut, ãlloi õnor ki tallukat? Õnor hãse ãi foriyad gorir, ãre zontrona no diyo!\" ");
INSERT INTO rhg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Isaye he napak ruhure manušwar butottu niyoli zaito hokum dilde hetolla hite hen goijje. Ei ruhuye bout din oite he manušware doijje. Ar hitare siyol edde beri loi bandi rakile o hite siyol siri bod ruhor kemotaye nirzon zagat zaitogoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isaye hitare fusar goredde, \"Tor nam ki?\" Hite hodde, \"Bahani\" kiyollahoile hitar butore bout bod ruh okkol aššil. ");
INSERT INTO rhg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tarfore hitarare aṭai gãtot no defeṛaibolla Isare foriyad gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Heṛe faharor uwore ḍõr ek šuworor zak soredde aššil, he napak ruhugune Isare foriyad goijje šuworgunor butore hitarare goilto ezajot dibolla, ar hibaye hitarare ezajot diye. ");
INSERT INTO rhg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Toi bod ruh okkole he manušwar butottu niyoli zai šuworgunor butore góillegoi. Henot he šuworor zakgun zure dũri faharor haindat giye edde henttu fori fori fanit dufi moijje. ");
INSERT INTO rhg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Zara šuworor zak sorail hitara ei hanḍo deki henttu dai giyegoi. Ar ei goṭonaganore he šohorot edde farar hár zagat zai hoiyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ki oiye hin saibolla hetunot manuš okkol niyoli aišše. Hitara Isar hãse ai dekedde, ze manušwar butottu bod ruh niyoli giyegoi, hite hor findi šuida oi Isar ṭengor ḍake boi taikke, hen deki manuš okkole ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Zara he goṭonagan dekkil, hitara he bod ruye faiya manušwa ki bafe aram oil hin manuš okkolore hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Toi Geraseni elehar sairo mikkar šomosto manuš okkole Isare beši ḍoraiye hetolla hitara beggune Isare henttu zaiboilla foriyad goijje. Toi Isaye uiṭṭe edde henttu uwafes firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ze manušwattu bod ruh niyoli gilgoi, hite Isar fũwati zai faribo ne fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kintu Isaye hitare en hoi bidai diye, \"Tui tor górot zagoi edde tolla ze ḍõr ham Allaye goijje, hin mainšore hogoi.\" Henot hite farat firi giyegoi edde Isaye hitalla ze ḍõr ham goijje hin šohoror agagura hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Isa zẽtte firi aišše manuš okkole hibare kuši mone goisse, kiyollahoile hitara beggune hiballa entezar gori aššil. ");
INSERT INTO rhg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ar so, Zairus name ekzon manuš, Isar sarme aišše. Hite aššilde muzolišhanar ekzon neta. Hite Isar fot fori hitar górot zaibolla Isare foriyad gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kiyollahoile hitattu lehar ek zi aššil, boyoš hom beši baro bosor, ar hiba morar mukot. Isa heṛe zadde šomot manuš okkole hibare har ḍakottu ṭelaṭeli goijje. ");
INSERT INTO rhg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Heṛe butore ekzon beṛi maya fuwa aššil ze baro bosorfan kunzari biyaram loi duk fat ase. Ḍaktor okkolor fise har šombotti beggunore horos gori felai bade o honokiye hibare bala gori no fare. ");
INSERT INTO rhg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hibaye Isar fisottu zai Isar horor kuna suiye. Toi hehon hibar kunzari bon oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Toi Isaye hodde, \"Ãre hone suiye?\" Kintu beggune ošikar goijje. Fitore hodde, \"Huzur, mainše har ḍakottu ṭelaṭeliye zafdiforer.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Toi Isaye hodde, \"Ãre hono ekzone suiye, ãi ṭer faiyi ãr butottu šokti giyede.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mayafuwawaye dekedde hiba luwai tai no faribo, hetunot hiba hafi hafi Isar munttu aišše. Hibaye Isar sarme uite fori kiyolla Isare suiye edde kibafe hehon hibar kunzari bon oiye, in okkol har manušor sarme hibaye hoi funaiye. ");
INSERT INTO rhg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Toi Isaye hodde, \"Oh zi, tor biššaše tore bala goijje, arame górot firi zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Isa ehon o hota howat ase, hen šomot muzolišhanar netar górottu ekzon manuš aiyore hodde, \"Tũwar zi mori giyoi. Huzurore loi ar diddari no goris.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ei hota funiyore Isaye Zairusore hodde, \"No ḍorais, bolke biššaš gor, henot hiba aram oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bade Isa zehon Zairusor górot fõisse, Fitor, Yakub, Yuhanna edde he zerfuwar babma sara ar honokiyore Isaye góror butore golito no de. ");
INSERT INTO rhg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Beggune hiballa handahaṛi edde bilag gorer kintu Isaye hodde, \"No haindo! Hiba no more, gum zadde.\" ");
INSERT INTO rhg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hitara hen funi Isare ṭaṭṭa uraiye, kiyollahoile hiba mori giyegoide hiyan hitara zainto. ");
INSERT INTO rhg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kintu Isaye hibar hat dori ḍaki hodde, \"Oh zi, uṭ!\" ");
INSERT INTO rhg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Henot hibar foran firi aišše edde hiba hehon uṛi tiyaiye. Ar Isaye hibare kissu haito dito hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Henot hibar babma ekkubare ammuwak oi giyegoi, kintu Isaye hitarare ei goṭonar hotagan honokiyore no hoibolla mana goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Bade he barozon asabore ekottoro gori ḍaikke edde hibaye hitarare har bod ruhor uwore edde biyaram bala goribolla šokti edde kemota diye. ");
INSERT INTO rhg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ar Allar raijjor tobolig goribolla edde biyaram aram goribolla Isaye hitarare faṭai diye. ");
INSERT INTO rhg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Toi Isaye hitarare hodde: \"Tũwara fõtolla kissu no loiyo, laṛi otóba gaṭṭi, hána otóba ṭĩya kissu no loiyo. Findibar fušak o dui zura no loiyo. ");
INSERT INTO rhg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ar tũwara ze górot zo, he fara sari no zogoi foijjonto he górot taikko. ");
INSERT INTO rhg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Zodi mainše tũwarare no gose, he šohor sari zaibar šomot tũwarar ṭengor tolar dul zari felaiyo, zene hine hitarar berudde goba oi tiya.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Toi sahabi okkol henttu giyegoi edde fara fara zai Allar raijjor kušir hóbor tobolig goijje edde biyaramma okkolore aram goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Badša Herude Isaye zin zin gorer hin beggun fuinne kintu hite honnan biššaš goribo buzi uṛi no fajjil. Kiyollabulihoile kiye kiye hoito Yahya mora okkolor butottu uṛi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ar kiye kiye hoito Eliyase deha diye, ar kiye kiye hoito, furan hailla nobi okkolor butottu ekzon zinda oi uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ar Herude hodde, \"Ãi to Yahyar mata haṛi felailam, kintu iba honnuwa zar babute endilla hota funazar.\" Hetolla badša Herude Isare saibolla kušiš goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bade asab okkole zin zin goijje, firi aiyore hitara hinore kulasagori Isare zanaiye. Tarfore Isaye hitarare fũwati loi Betsaida farar ḍake ek nizam zagat giye. ");
INSERT INTO rhg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kintu mainše he hóbor zani fariyore hitara Isar fisa loiye. Toi Isaye hitarare rahamotor sãte goisse edde hitarar hãse Allar raijjor babute hota hoiye. Ar zara aram oibar dorhar aššil hitarare aram goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tarfore din šeš oi aišše, ar he barozon asabe Isar hãse zai hodde: \"Õne ei manuš okkolore bidai do, zene itara sairo mikka farat, geramot zai rait haṛai fare edde hána fani tuwai loi fare, kiyollahoile ãra aside zagagan kissu naide zaga.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kintu Isaye hitarare hodde: \"Tũwara hitarare hána do!\" Asab okkole hodde, \"Fãswa ruṭi edde duwa mas sara ãrar hãse ar kissu nai. Ar ki ãra zai edun manušolla haiddo kini ani faijjum?\" ");
INSERT INTO rhg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Heṛe onumanik fãs hazar furuš manuš aššil.) Hetunot Isaye sahabi okkolore hodde, \"Itara beggunore fõnzašzon fõnzašzon grup gori buwai do.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sahabi okkole hen goijje, beggunore buwai diye. ");
INSERT INTO rhg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tarfore Isaye he fãswa ruṭi edde duwa mas loi asmanor uzu suk tuli hinolla Allare šukuriya zanaiye edde hinore bangi sahabi okkolore diye, mainšore baṛi dibolla. ");
INSERT INTO rhg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Toi beggune feṭbori hána háiye. Tarfore hitara zin hái bade guragara basi roiye hinore dola gori baro barang hána oiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Isaye ek bar ekela munazat goredde šomot sahabi okkol o hibar fũwati heṛe aššil. Isaye hitarare fusar goredde: \"Ãi honnuwa, ei babute mainše ki ho?\" ");
INSERT INTO rhg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hitara zuwab diye, \"Torikotor gusol doya Yahya, kintu kiye kiye ho nobi Eliyas, ar kiye, beši agor nobi okkolor butottu ek nobi uṛigiyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Isaye hitarare fusar goredde: \"Kintu tũwara ki ho, ãi honnuwa?\" Fitore hodde, \"Õne Allar he Mosi.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hetunot Isaye hitarare ei hota honokiyore no hoibolla hũšiyari diye edde mana goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Isaye hodde, \"Adomor Futottu beši duk buggora foribo. Ar murobbi okkol, ḍõr imam edde alem okkole hibare batil goribo edde mari felaibo. Ar tin dinor din hibattu morattu uṛizagoi foribo.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Toi hibaye beggunore hodde: \"Honokiye zodi ãr fise aito issa gore, hite nizore ošikar gorok edde hite fotti din nizor duk hoštore bordaš gori ãr fise fise aiyok. ");
INSERT INTO rhg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kiyollahoile ze honokiye hitar nizor foran basaito sa, hite hiyan haraibo. Kintu ze honokiye ãlla boli hitar nizor foran hara, hite hiyan basaibo. ");
INSERT INTO rhg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hitar ki lab oiye, zodi šara duniyai hama, kintu nizore harai fele otóba nošto gori fele? ");
INSERT INTO rhg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kiyollahoile ze honokiye ãre edde ãr kalamore mainšor munttu šorome ošikar gore. Adomor Fut zehon nizor, edde fobitro firista okkol edde Bafor tozolli loi aibo, hẽtte hibaye o he manuš okkolore ošikar goribo. ");
INSERT INTO rhg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","\"Ãi tũwarare soiyi hoir, eṛe tũwarar butore en hozon ase zara Allar raijjo no deke foijjonto hitara hono mote moutor fiyala no fibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","In okkol hoi ek hafta bade, Isaye munazat goribolla Fitor, Yuhanna, Yakub, itarare loi ek faharor uwore giye. ");
INSERT INTO rhg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Munazat goribar šomot Isar mukor siyara bodoli giyegoi edde hibar fušak ujjol dola oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ar so, duizon manuš, Musa edde Eliyas, hitara Isa loi hota howa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hitara keramoti zak zomok loi deha diye edde Zeruzalemot Isaye ze moutor muamui oito zar, hitara he befare hotabatra hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","He šomot Fitor edde hitar sãti okkol bári gumot aššil. Hitara seton oi Isar keramot edde oi duizon manuš zara Isar fũwati tiyai taikke hitarare deikke. ");
INSERT INTO rhg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","He duizon Isar hãsottu zargoide šomot Isare Fitore hodde: \"Huzur, ãra eṛe aside bala oiye. Ãra tinnan bãša banai, ekkan õnolla, ekkan Musalla, ar ekkan Eliyasolla.\" (Kintu Fitore asole ki hor hin hite nize o no zane.) ");
INSERT INTO rhg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fitore hen hodde šomot ekkan miyula ai hitarar uwore saiya oiye. Hitara zẽtte miyular butore oiye, hẽtte hitara beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ar he miyular butottu endilla ek abaz funa giye, \"Iba ãr fut, he basai gora, hibar hota fuinno.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Abaz oi mottor Isare ekela deha giye. Ar hitara suf gori taikke, zin zin sahabi okkole dekkil hin he šomot honokiyore no ho. ");
INSERT INTO rhg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tarfordin zehon hitara he faharottu lami aišše, bout mainše Isa loi deha goijje. ");
INSERT INTO rhg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ar so, zamor butottu ekzone guzori hodde, \"Huzur, aroz gorir, ãr fuwawar uzu suk tuli so, kiyollahoile ite šude ãr lehar ek fut. ");
INSERT INTO rhg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","So, ek ruhuye itare hamela gorer, ar atikka kiskisai uṛe. He ruhuye itare musori dore, henot ite muk bai fena bair gore, ar ruhuye itare zal zal gori kub hošto di erizagoi. ");
INSERT INTO rhg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ãi õnor sahabi okkolore foriyad goijjilam, zene hitara ibare sarai de, kintu hitara no fare.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Toi Isaye zuwabe hodde: \"Oh obiššaši edde bonḍor dol! Ar hotokal ãi tũwarar fũwati takiyum edde tũwarare bordaš goriyum? Tor futore loi eṛe ai!\" ");
INSERT INTO rhg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","He fuwawa aiyerde hen šomot oi bod ruhuye hitare felai diye edde hora gori musori doijje. Kintu Isaye he napak ruhure dõk diyore fuwaware aram goijje. Toi hitare bafor hãse firai diye. ");
INSERT INTO rhg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Henot beggune Allar he mohimar šokti deki tajjuf oiye. Toi hár manuš okkol Isaye goijjede hamot tajjuf oiyede šomot, Isaye sahabi okkolore hodde, ");
INSERT INTO rhg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"Tũwara ei šob hota mon di funo! Kiyollahoile Adomor Futore manuš okkolor hatot tuli diya oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kintu hitara he hota buzi no fare, edde he hotar mani hitarattu gufon raka oiye, zenneki hitara buzi uṛi no fare, ar he babute Isattu fusar goitte o hitara ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sahabi okkol hone beggunottuwaro ḍõr hiyan loi hitarar butore hota haṛa haṛi oiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isaye hitarar monor baf buzi fariyore ek gura fuware loi hibar ḍake tiyagoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Toi sahabi okkolore hodde, \"Ze honokiye ãr name ei gura fuwaware gose, hite ãre gose. Ar ze honokiye ãre gose, hite hibare gose ze ãre defeṛaiye. Kiyollahoile ze tũwarar butore beggunottuwaro šoṛo, hite oilde dõr.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bade Yuhannaye hodde, \"Ustad, õnor name ekzon mainše but saradde dekkilam, hite ãrar dolot node hetolla buli ãra hitare mana goijjilam.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kintu Isaye hodde, \"Tũwara hitare mana no goijjo! Kiyollahoile ze tũwarar bifokke no hitede tũwarar fokke ase.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ar zehon Isare uwore tuli loi zaibar ṭaim hãse aišše, hetunot Isa Zeruzalemor mikka zaibolla ek mone ereda gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ar Isaye zaibar age hóborguwa okkolore defeṛaiye. Ar hitara zai Sameri okkolor farat góille, Isalla entezam gori farefan. ");
INSERT INTO rhg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Isaye Zeruzalem zaibo ereda goijje buli heṛiyar manuš okkole Isare no gose. ");
INSERT INTO rhg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hendilla deki Isar sahabi Yakub edde Yuhannaye fusar goredde, \"Malik, õne ki issa goro, Eliyase zendilla goijje hendilla ãra hoi, asmanottu oin lami ai itarare dongšo gori felok?\" ");
INSERT INTO rhg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kintu Isaye hitarar mikka muk firai dõk diye edde hodde, tũwara no zano ne, tũwarare hon ruh loi banaiye? Adomor Futore manušor zibon dongšo goribolla faṭa oiyede no, kintu uddar goribolla. ");
INSERT INTO rhg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tarfore hitara oinno ekkan farat giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hitara fõt bai zadde hen šomot ekzon manuše Isare hodde, \"Õne zeṛe zo ãi o õnor fũwati heṛe zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isaye hitare hodde, \"Šiyal okkolottu gãt ase edde asmanor faikottu baha ase, kintu Adomor Fute mata rakibar hono zaga nai.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isaye ar ekzonore hodde: \"Ãr fisa lo.\" Kintu hite hodde: \"Huzur, age ãr bafore dohon gorai aito do.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Isaye hitare hodde: \"Mora okkole mora okkolore dohon gora ok, kintu tui zai Allar raijjor tobolig gor.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ar ekzone Isare hodde, \"Malik, ãi õnor fisa loiyum, kintu age ãre ãr góror manuš okkolottu bidai loi aito do.\" ");
INSERT INTO rhg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Isaye hitare hodde, \"Ze honokiye naholor kuṛi dori fis mikka firisa hite Allar raijjor laikka oi no fare.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hiyar bade Malik Isaye aro oinno hoittor duizonor mainšore basona goijje. Ar Isa nize ze ze šohor ba fara okkolot zaibolla ereda goijje, he šomosto zaga edde šohorot hiba zaibar age duizon duizon gori hitarare defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Isaye hitarare hodde, \"Hãsa, dán beši foille kintu dán daoya manuš hom. Etolla danor malikor hãse foriyad goro zene malike hibar dán daibolla manuš faṭai de. ");
INSERT INTO rhg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tũwara zo! Ãi tũwarare sool hisabe genḍa bagor okkolor butore defeṛair. ");
INSERT INTO rhg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ṭiyar beg, hoilla ba ṭengor šendal fũwati no loiyo, edde fõtot honokiyor loi mulot oibolla no tiyaiyo. ");
INSERT INTO rhg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","\"Kintu tũwara ze górot goliba, heṛe tũwara foila hoiba, 'Ei górot šanti aiyok.' ");
INSERT INTO rhg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Zodi heṛe šantir manuš take henoile tũwarar šanti hitar uwore ziraibo. Ar zodi hendilla honokiye no take hentoile tũwarar šanti tũwarar hãse firi aibo. ");
INSERT INTO rhg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ar he górot taikko edde hitara zin há fiya gorito de hin haiyo, kiyollahoile ze ham gore hite beton faibar laikka. Ek gór sari ar ek górot no zaiyogoi. ");
INSERT INTO rhg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","\"Zodi hono farat zo edde heṛeiyar manuš okkole tũwarare gose toile hitara tũwarare zin de hin haiyo! ");
INSERT INTO rhg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","He farar biyaraimma okkolore aram goijjo edde hoiba, 'Allar raijjo tũwarar hãse aišše.' ");
INSERT INTO rhg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kintu zodi hono farat zo edde heṛiyar mainše tũwarare no gose, he farar rasta rasta zai en hoiba, ");
INSERT INTO rhg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Tũwarar farar ze dul ãrar ṭengot boijje hin o ãra zari felailam, tarfore o tũwara zani rako ze Allar raijjo hãse aišše.' ");
INSERT INTO rhg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ãi tũwarare hoir, bisaror din he farattuwaro Súdum šohoror doša šowa zaibo. ");
INSERT INTO rhg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","\"Korasin šohor tor bifod! Betsaida šohor tor bifod! Ze šob keramot tũwarar butore gora oiye, hin okkol zodi Tiros edde Sidon šohorot gora oito, toile hitara bout din age salar šoṭ findi saiyot boi gunattu mon firaito. ");
INSERT INTO rhg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kintu bisaror din tũwarar došattuwaro Tiros edde Sidon šohoror doša šowa zaibo. ");
INSERT INTO rhg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ar tui Kofornahum šohor, tũi bole ki asman uwore uṛibi? Honodin oi no fare, tore meṛir nise fatalfurot feli diya oibo! ");
INSERT INTO rhg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","\"Zara tũwarar hota fune hitara ãr hota fune. Zara tũwarare hela gore, hitara ãre hela gore. Kintu zara ãre hela gore, hitara ãre ze defeṛaiye hibare hela gore.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","He hoittor duizon ummote kušir sãte firi aišše edde hodde: \"Malik, õnor nam dorile bod ruh okkole foijjonto ãrar hota fune!\" ");
INSERT INTO rhg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Toi Isaye hitarare hodde, \"Ãi Šoitanore asmanottu bizoli somkefana gori nise foredde dekki. ");
INSERT INTO rhg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","So, ãi tũwarare haf edde bissure ṭenge fiši maribolla edde dušmon Šoitanor har šokti loi ziti faribolla šokti diyi. Hono kissuye tũwarare hoti gori no faribo. ");
INSERT INTO rhg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kintu bod ruhuye tũwarar hota fune boli kuši no goijjo bolke behostot tũwarar nam leka oiye boli kuši goro.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hetunot Isaye Pak Ruhur kušiye ullaš oi hodde, \"Ya Baf, tũi asman edde duniyair malik, ãi tũware šukuriya zanai, kiyollahoile ei hota okkol tũi giyani edde buddiman okkolottu lukairaki masum gura fuwaindor hãse forhaš goijjo. Oi, Baf, iyan tũwar bala issa. ");
INSERT INTO rhg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","\"Ãr Bafe ãr hatot hár kissu diye. Baf sara ar honokiye no zane Fuwa honnuwade hiyan, ar Fuwa sara honokiye no zane Baf honnuwade hiyan. Ar Fuwaye zar hãse Bafore forhaš goitto sa šude hite zane.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Toi hitara zehon ekela oiye, hibaye hitarar mikka firiyore hodde, \"Rahamot ok he suk okkolor uwore, tũwara dekodde hin zara deker. ");
INSERT INTO rhg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ãi tũwarare hoir: Tũwara dekorde hin bout nobi okkole edde badša okkole saito issa goijje kintu saibolla no fa, ar funito issa goijje kintu funito no fa.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ar so, ekzon dórmiyo aleme Isare forikka gori saibolla hibar hãse aiyore hodde, \"Huzur, akeri zibonor odihar faite ãttu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isaye hodde, \"Ainot ki leka ase? Heṛe hondilla foijjo?\" ");
INSERT INTO rhg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","He hite hodde: \"'Tũi tũwar šomosto dil, šomosto mon, šomosto foran, šomosto šokti, diyore Allah Mabudore muhabbot goro. Ar tũwar ḍen gór bam gójjare nizor zani muhabbot goro.'\" ");
INSERT INTO rhg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isaye hitare hodde: \"Tũi ṭik zuwab diyo. Zodi tũi he mozin gorat tako, toi tũi o zibon faiba.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","He aleme hitar nizor šorman basaibolla Isare abar hodde, \"Bala, ãr ḍen gór bam gójja hontara?\" ");
INSERT INTO rhg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zuwabe Isaye endilla hoiye: \"Ekzon manuš Zeruzalemottu fõt bai lami Zeriku šohorot zar, hen šomot hite ḍahaitor hatot foijje. Ḍahait okkole hitar findonor hoorgun kuli loi felaiye edde hitare mari ada mora abostat raki giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Goṭona sokkore ekzon imam o he fõt bai lami aišše. Hite he manušware deki rasta fašhaṛi gilgoi. ");
INSERT INTO rhg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bade hendilla ekzon dórmogór šasiyot goroya Levi o he zagat ai manušware deki, hite o fašhaṛi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tarbade Sameriya elehar ekzon manuš, zarare šomazot niroš zat hisabe gona oito, he fõt bai zaite zaite oi manušwar hãsa hãsi aišše. Hitare deki tattu doya laigge, ");
INSERT INTO rhg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","edde hitar ḍake zai, hitar gá okkolot tel edde ãnguror roš ḍalidi hinore bandi diye. Tarfore hitar nizor zanuwaror uwore buwai ek šoraihanat loigiye edde hitare šeba zotton goijje. ");
INSERT INTO rhg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tarfordin he Sameriyar manušwaye duiyan dinar šoraihanar menezarore diyore hodde, 'Ei manušwar adorhatir goriba, beši za kissu horos o, hin ãi abar aile šud gori diyum.' ");
INSERT INTO rhg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","\"Ehon tũwattu ki mone o? Ei tinzonor maze hone he ḍahaitor hatot fora manušwar ḍen gór bam gójja?\" ");
INSERT INTO rhg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","He aleme zuwabe hodde, \"Ze manušwaye hitare ador hatir goijje hite.\" Toi Isaye hitare hodde, \"Toile tũi o zo he mozin gorogoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ar hitara zadde šomot Isaye hono ek farat góille, heṛe Martá name ek maya fuwaye hibar górot Isare meheman hisabe goisse. ");
INSERT INTO rhg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Moriyam name ekzon hibattu boin aššil. Hibaye Malik Isar ṭengor ḍake ai boi Isar hota funer. ");
INSERT INTO rhg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kintu Martá góror harz harbare beši duwadit aššil. Hibaye hitara dunizonor hãse aiyore hodde: \"Malik õne ki kissu bafi no sor ne, ãr boine ãre beggun halika ga gora diyede? Õne hibare ãre modot gori dito ho!\" ");
INSERT INTO rhg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kintu malik Isaye zuwabe hodde: \"Martá! Tui bout hame duwadit edde sintat. ");
INSERT INTO rhg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kintu ekkan šude zoruri ham ase. Moriyame he hamman basi loiye, hetolla hiyan hibattu loi fela no zaibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ek šome Isaye hono ek zagat duwa gorer. Duwa gora šeš oi bade Isar sahabi okkolor butottu ekzone Isare hodde: \"Malik, Yahyaye zendilla hibar šagirit okkolore duwa gora šikaiye hendilla õne ãrare o duwa gora šikao.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isaye hitarare hodde: \"Tũwara duwa goribar šomot endilla ho: \"'Ya, ãrar behosti Baf, Tũwar nam fobitro boli mana ok. Tũwar raijjo aiyok. ");
INSERT INTO rhg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fotti dinor haiddo tũi fotti din ãrare do. ");
INSERT INTO rhg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ãrar har gunare maf gori do, zendilla ãra o maf gori hitarare, zara ãrar berudde hosuri gore. ar ãrare forikkat foitto no diyo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tarfore Isaye hitarare hodde, \"Mone goro! Tũwarar butore hono ekzonottu ekzon bondu ase. Ar hite zodi ada raitta hitar bondur hãse zai ho, 'Bondu, ãre tinnwa ruṭi udar do, ");
INSERT INTO rhg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kiyollahoile ãr ek bondu musafer oi ãr heṛe aišše, hitar munttu ani dibolla ãttu kissu nai.' ");
INSERT INTO rhg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Henoile ki he manušwaye butottu tai en zuwab dibo ne, 'Ãre hošto no diyo, ehon doroza banda, ar ãr fuwain ãr ḍake gum giye. Ãi uṛi tũware kissu di no farir.' ");
INSERT INTO rhg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ãi tũwarare hoir, hite zodi bondu hisabe uṛi no de, tarfore o hite bar bar foriyad goredde hiyanolla buli oile o hite uṛibo edde hitar zorulot mozin hitare hin dibo. ");
INSERT INTO rhg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","\"Etolla ãi tũwarare hoir: Munazatot so, toi tũwarare diya oibo. Tuwo, toi tũwara tuwai faiba. Dorozat ṭulki maro, toi tũwaralla kula oibo. ");
INSERT INTO rhg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Zara mage hitara to fottizonore diya o, ze tuwa, hite tuwai fa, ar ze dorozat ṭulki de, hitalla doroza kula o. ");
INSERT INTO rhg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","\"Tũwarar butore endilla baf hone ase, fuwaye mas magile haf de, ");
INSERT INTO rhg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","otóba ãnḍa magile bissu de? ");
INSERT INTO rhg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tũwara zodi horaf oi bade o tũwarar fuwain okkolore uttom uttom ziniš di zano, toile ei hota hoto haṭi ze, zara mage hitarare behostiyo Bafe Pak Ruhure dibo!\" ");
INSERT INTO rhg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ar ek bar Isaye ek buk but dafaiye. But zehon bair oigiyegoi, he buk manušwaye hota howa šuru goijje. Henot manuš okkol tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kintu hitarar butore kiye kiye hodde, \"Butor raza Belsebulor modote ite but bair gore.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ar kiye kiye forikka gori saibolla Isare behostottu ekkan sinno dehaito hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kintu Isaye hitarar monor baf buzi faijje edde hibaye hitarare hodde: \"Ze raijjo bag o hiyan dongšo o, ar gór zodi góror bifokke o hiyan dongšo o. ");
INSERT INTO rhg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hendilla, Šoitane o zodi hitar nizor berudde ai tiya, toile ken gori hitar raijjo ṭikibo? Ar tũwara hor ãi Belsebulor modote but sarai. ");
INSERT INTO rhg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ašša! Ãi zodi Belsebulor modote but sarai, toile tũwarar nizor manuš okkole har modote but sara? Tũwara soiyi hor ne hiyan hitara bisar gori sok. ");
INSERT INTO rhg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kintu ãi zodi Allar kemota loi but sarai, henoile Allar raijjo tũwarar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","\"Ekzon bolwala mainše zodi hár ḍoilla ostro loi nizor gór fahara de, toile hitar mal fottoro nirafodot take. ");
INSERT INTO rhg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kintu hitattuwaro bolwala honokiye zodi ai hitar loi zite, toile hite ze ostro okkolor uwore nirbor goijje hin oi manušwaye hari loi felaibo, ar luṛor mallun loi zai bag goribogoi. ");
INSERT INTO rhg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","\"Ãi hoir: Zodi honokiye ãr fokke no take toile hitede ãr bifokke roiye, ze ãr fũwati no feṛa hitede šiṛe.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","\"Hono napak ruh zehon ekzon manušor butottu bair oi zagoi, hetunot hite aramor zaga tuwaibolla šuwana zagat zai gura fira gore. Bade zodi hite hendilla no fa, hite hode, 'Ãi ze górottu niyoli aiššyi he górot ãi abar firi zaiyumboi.' ");
INSERT INTO rhg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Firi ai sadde, górgan foriškar edde hãzaiya. ");
INSERT INTO rhg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hetunot hite zai hitattuwaro aro hãt zon horaf napak ruhure fũwati loi ane edde heṛe goli bošobaš gore. Hiyanolla boli he manušwar doša foila barottuwaro šešor doša aro horaf o.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Isaye ei šob hota hodde šomot mainšor zamottu hono ek maya fuwaye guzori Isare hodde, \"Mubarok he feṭ, ze õnore feṛot loiye edde bukor dud habaiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kintu Isaye hodde: \"Iyanottuwaro hitarare mubarak zara Allar kalam fune edde hindilla gore.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Toi aro manuš okkole Isare sairo ḍakottu berai doijje, hetunot Isaye hodde, \"Ei halor manuš okkol horaf, hitara sinno tuwa, kintu Yunus nobir sinno bade ar hono sinno hitarare deha no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nineveh šohoror manuš okkololla zendilla Yunus nobi nize sinno oil, ṭik hendilla ei halor manuš okkololla o Adomor Fut sinno oibo. ");
INSERT INTO rhg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bisaror din doin dešor raniye ei halor manuš okkolor fũwati uṛi itarare duši goribo, kiyollahoile hibaye badša Soloimanor giyanor hota funibolla duniyair šeš ḍakottu aiššil. Ar so, eṛe Soloimanottuwaro aro mohan ekzon ase. ");
INSERT INTO rhg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bisaror din Nineveh šohoror manuš okkole ei halor manuš okkolor fũwati uṛi itarare duši goribo, kiyollahoile Yunus nobir toboligor duwara Nineveh šohoror manuš okkole gunattu mon firail. Ar so, eṛe Yunusottuwaro aro mohan ekzon ase. ");
INSERT INTO rhg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","\"Serag zalai honokiye ũjja góror tole ba laiyor nise no rake, bolke hiyan seragor tokor uwore rake, zene zara butore za hitara fohor deke. ");
INSERT INTO rhg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Suk oilde gar serag, tũwar suk zodi taza o, hin hendilla oiyede haron oilde, gagan fohore furaiyade hetolla. Kintu suk zodi taza no o, hin hendilla oiyede haron oilde, gaganot andar ase. ");
INSERT INTO rhg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hetolla so, tũwar butore ze fohor ase hiyan hono andarot ne. ");
INSERT INTO rhg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tũwar šara ga zodi fohore furaiya o, edde ekkagori o andar no take, ṭik serag zendilla nizor teze tũware fohor de, hendilla tũwar hara ga furafuri bafe fohore furaiya oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Isa hota howa šeš gori bade ekzon forošiye Isare hánar dawat diye. Hibaye butore zai hána haito boišše. ");
INSERT INTO rhg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Isaye hána háibar age hat no duwede deki forošiwaye ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kintu Malik Isaye hitare hodde: \"Tũwara Foroši okkole fanir fiyala edde deššir bar ḍakottu foriškar goro kintu tũwarar butore lalos edde naformaniye boraiya. ");
INSERT INTO rhg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Murokko manuš okkol! Ze baror ḍak banaiye, hibaye ki butoror ḍak o no bana ne? ");
INSERT INTO rhg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bolke deššir butore za za ase hin gorib okkolore dan goro, toi dekiba, beggun tũwaralla foriškar oibo. ");
INSERT INTO rhg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","\"Bifod tũwara Foroši okkolore, kiyollahoile tũwara Allare fudina, tez fata edde hár ḍoilla hakor doš bagor ek bag di tako. Kintu niyai bisar edde Allar muhabbotor mikka diyan no do. Foilagan falon goribar fũware fũware dusoragan falon gora o tũwarar dorhari. ");
INSERT INTO rhg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","\"Bifod tũwara Foroši okkolore, muzolišhanar mum mikkar zagat boite edde rasta gaṛot ijjot fare muhabbot goro. ");
INSERT INTO rhg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","\"Bifod tũwara Foroši okkolore, tũwara en hobor okkolor ḍoilla zinor hono sinno no take, edde no zani mainše heṛe uwottu ãṛe, ar hitara napak o.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hetunot dórmo šikoya alem okkolor butottu ekzone Isare hodde, \"Huzur, õne ei hota hoi ãrare o ofoman goror.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isaye hitarare hodde, \"Bifod tũwara dórmo šikoya alem okkolore! Tũwara manušor uwore bor fũza tuli do, kintu hitara hin mani farefan modot gori hoi uggwa õl o no laro. ");
INSERT INTO rhg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","\"Bifod tũwarare, tũwara nobi okkolor hoborore mazar banao, otoso tũwarar baf dada okkole hitarare kun goijje. ");
INSERT INTO rhg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iyan deki buza zar ze tũwara tũwarar baf dadar hamot ekmot oiyo, kiyollahoile hitara mari felaiye ar tũwara hitarar hoborore mazar banayo. ");
INSERT INTO rhg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Etolla giyani Allaye Allar kalamot hodde, 'Ãi hitarar hãse nobi okkol edde asab okkolore defeṛaiyum. Hitarar butottu ho ekzonore hitara kun goribo edde ar kissur uwore ottisar goribo.' ");
INSERT INTO rhg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hetolla duniyair foilar šuru oite šuru gori zetozon nobire kun gora oiye, hitarar louwor dai oibo ei halor manuš okkol. ");
INSERT INTO rhg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Habilor kun oiyede oite šuru gori Zakariya, zare pak zaga edde dórmogóror maza mazi zagat kun gora oiye. Oi, ãi tũwarare hoir, ei halor manuš okkol ei louwor dai oibo. ");
INSERT INTO rhg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","\"Bifod tũwara dórmo šikoya alem okkololla! Tũwara giyanor sabi nizor hãse raki diyo. Giyanor butore tũwara o no golila, ar zara butore goilto saiye hitarare o tiya garai felaiyo.\" ");
INSERT INTO rhg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Toi Isaye hentu niyoli zargoide šomot dórmiyo alem okkol edde Foroši okkole mezaz gorom gori bout ḍoilla suwal okkol loi Isar uwore zafai foijje. ");
INSERT INTO rhg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hitara Isare mukor hotat bul doribolla fand buwai raikke. ");
INSERT INTO rhg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hen šomot hazar hazar manuš en bafe dola oiye, hitara ṭelateli gori ekzone ar ekzonor uwore fora šuru goijje. Hetunot Isaye foila sahabi okkolor uzu firi hodde, \"Tũwara Foroši okkolor šikkattu hũšiyar, hin tũwarar gat no farafan, kiyollahoile hin bonḍami. ");
INSERT INTO rhg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Guijja kissu nai, zin forhaš no oibo, edde gufon kissu nai, zin zana no zaibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Otoso tũwara andarot za kissu hoiyo, hin fohorot funa zaibo, edde zin góror butore hane hane ho, hin sador uwottu guzori howa oibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","\"O ãr bondu okkol, ãi tũwarare hoir, zara ga dongšo gori bade ar kissu gori no fare, hitarare no ḍoraiyo. ");
INSERT INTO rhg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Harare ḍoraiba ãi tũwarare hiyan hoir. Tũwarare mari felai bade jahannamot dibar kemota zattu ase hibare ḍoro. Oi ãi tũwarare hoir, hibare ḍoro. ");
INSERT INTO rhg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fãswa fiyajjare ki dui foišaye no bese ne? Tarfore o Allaye hinor uggware o forai no fele. ");
INSERT INTO rhg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","En ki tũwarar matar sullun o Allattu gona ase. No ḍoraiyo, tũwara beši fiyajja okkolottuwaro aro beši dami. ");
INSERT INTO rhg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","\"Ãi tũwarare hoir, ze honokiye manušor šaikkat ãre šikar gore, Adomor Fute o Allar firistar šaikkat hitare šikar goribo. ");
INSERT INTO rhg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kintu ze honokiye ãre manušor šaikkat ošikar gore, Adomor Fute o Allar firistar šaikkat hitare ošikar goribo. ");
INSERT INTO rhg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Adomor Futor berudde honokiye hota hoile, hite maf faibo. Kintu ze honokiye Pak Ruhure hingša gore, hitare maf gora no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","\"Ar mainše tũwarare zẽtte sinagogot edde šašon goroyar sarme loi za, hetunot ki zuwab diba ba ki hoiba he babute sinta no goijjo. ");
INSERT INTO rhg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kiyollahoile hetunot ki howa foribo tũwarare Pak Ruhuye šikai dibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Zamilar butottu ekzon manuše Isare hodde: \"Huzur, ãr báiyore ãr loi miraz borat goitto ho!\" ");
INSERT INTO rhg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kintu Isaye hodde, \"Bondu, tũwarar uwore bisarhar ba miraz bag gori doya hoi ãre hone tuille?\" ");
INSERT INTO rhg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bade Isaye manuš okkolore hodde, \"Hũšiyar! Har ḍoilla lalsittu nizore basai rako, kiyollahoile ekzon mainšottu zafdi forefan dón šombotti oile o, hine zibon no de.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ar Isaye hitarare ei mesal kahanigan hoiye, \"Ekzon zomidaror zobinot kethõla beši oiye. ");
INSERT INTO rhg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Henot hite mone mone sinta gori hodde, 'Ãi ehon ki goijjum? Ãttude hin rakibar zaga nai.' ");
INSERT INTO rhg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","\"Bade hite hodde, 'Ãi endilla goijjum. Ãr gudam górgun bangi felai hinore ḍõr ḍõr gori banaiyum edde ãi ãr kuraffati edde ãr zinišfati okkolore heṛe zoma gori rakiyum. ");
INSERT INTO rhg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bade ãi nizor foranore hoiyum, foran, tolla bout bosorolla beša beši bala bala zinišfati dola goijja ase, há fiya gor, aram gor, asanot zibon haṛa.' ");
INSERT INTO rhg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","\"Kintu Allaye hitare hodde, 'O bekub, aijja raitta tor foran hori loi zaiboi, toile tui in zinor bondobos goijjos, hin har oibo?' ");
INSERT INTO rhg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","\"Ze nizolla dón zoma gore kintu Allar nozdikot dónban no hitalla hendilla oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bade Isaye sahabi okkolore hodde: \"Etolla ãi tũwarare hoir: Ki háiyum hoi foranor babute, otóba ki findiyum hoi gar babute sinta no goijjo. ");
INSERT INTO rhg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kiyollahoile foran haiddottuwaro ar ga horottuwaro ḍõr ziniš. ");
INSERT INTO rhg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hawagunor uzu so, hine no laga, ar no da. Hinottu gudam ba hãijja o nai, to kintu Allaye hitarare o ahar de. Ar tũwara to faikottuwaro bout dami! ");
INSERT INTO rhg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ho sai, tũwarar butore bafa sinta gori hone šude ek gonḍa nizor aiyu barai fariba? ");
INSERT INTO rhg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Zehon tũwara hen šoṛo ham o gori no faro, toile baki befare kiyolla sinta goriba?\" ");
INSERT INTO rhg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","\"Bafi so, full ken gori bare. Hine hono ham o no gore, hor banaibolla fũta o no haṛe. Kintu ãi tũwarare hoir: Badša Soloimane hibar šomosto zak zomokottu o inor ekkanor ḍoilla nizore hãzai no fare. ");
INSERT INTO rhg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Maṛot ze ker ase, zin hailla sulat felai diya oibo, hin zodi Allaye endilla gori hãzai fare, toile oh olfo biššaši okkol! Allaye tũwarare hãzaibode hiyan aro hoto beši haṭi! ");
INSERT INTO rhg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ar ki há fiya goriba in loi tũwara no baiffo, sinta no goijjo. ");
INSERT INTO rhg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","In okkol to zara Allare biššaš no gore hitara tuwa, kintu tũwarar bafe zane ze tũwarattu in okkolor dorhar ase. ");
INSERT INTO rhg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hinottuwaro bolke Allar raijjor talaš goro, toi in beggun o tũwarare diya oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","\"Oh šoṛo dol, no ḍorais! Kiyollahoile tũwarar Bafor bala issa oilde, he raijjore tũwarare diya. ");
INSERT INTO rhg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tũwarattu zin ase, hin besi horat hisabe dan goro. Ar behostot ofurani dón zoma goro, zeṛe sur o hãse nu aibo, fuk zuke o hoti gori no faribo. ");
INSERT INTO rhg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kiyollahoile zeṛe tũwarar dón, heṛe tũwarar dil o takibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","\"Tũwarar kiyail bandi tiyar tako edde serag zalai rako. ");
INSERT INTO rhg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ar tũwara en mainšor ḍoilla o, zitara hitarar malik biyar melattu firi aiyer ne sai take, zendilla neki malik ai dorozat ṭulki dile, hitara malikore toratori doroza kuli di fare. ");
INSERT INTO rhg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Šuki he gulam okkol, zarare góror malike ai seton dekibo. Ãi tũwarare soiyi hoir, he malike kiyail bandi hitarare hánar ṭebilot buwaibo edde ḍake zai hitarare luid goribo. ");
INSERT INTO rhg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Šuki hitara, zarare góror malike ada raitta ba dolfohor ode hetunot ai o seton dekibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kintu iyan buzo: Sur hon šomoi loi aibo hiyan zodi góror malike zainto, toile seton takito, nizor górot šingar dito no dito. ");
INSERT INTO rhg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hetolla tũwara o tiyar tako, kiyollahoile ze šomot mone no goriba, he šomot Adomor Fut aibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hetunot Fitore fusar goredde, \"Malik, ei mesal ki õne ãrare hodde naki beggunore hodde?\" ");
INSERT INTO rhg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Malik Isaye hodde, \"He biššaši, buddiwala menezar hiba honnuwa, zare hitar malike hibar gulam okkolor uwore buwaibo hitarare ṭãim motabek hána dibolla. ");
INSERT INTO rhg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Šuki he gulam, zare malike ai hendilla goredde dekibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ãi tũwarare soiyi hoir, hitare he góror malike hár kissur uwore zimma dibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kintu mone goro! He gulame zodi mone mone ho, ãr malik aite aro deri ase hoi gulam edde bandi okkolore mara dora gore edde há fiya gori fól owa šuru gore. ");
INSERT INTO rhg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ze din Malik aibo hoi ofekka no gore edde ze šomoir hota hite no zane, he dinor he šomot he gulamor malik aibo edde hitare haṛi bag gori obiššaši okkolor fũwati hitar zaga ṭik goribo. ");
INSERT INTO rhg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","\"He gulam ze hitar nizor malikor issa zane, tarfore o hite tiyar no o ba malikor issa mozin no gore hitare beši fiṛa diya zaibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kintu ekzone hiyan no zane edde fiṛa faibar ham goijje, hitare hom šaza diya oibo. Zare beši diya oiye, hitattu beši dabi gora oibo, ar mainše zar hãse beši rake, hitattu beši uwafes lo. ");
INSERT INTO rhg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","\"Ãi duniyait oin zalaito aiššyi. Ar ehon zodi ãi issa goijjilamde mozin he oin zolito! ");
INSERT INTO rhg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kintu ãttu dukkor torikotor gusol muwamui owa foribo, ar hiyan furon no o foijjionto ãi hoto sifor butore asi! ");
INSERT INTO rhg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tũwara ki mone goror, ãi ki duniyaire šanti dito aiššyi? Ãi tũwarare hoir, hen no, bolke hiyanor ulda. ");
INSERT INTO rhg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ehonottu loti ek góror fãszon aleda oibo, tinzon duizonor bifokke, duizon tinzonor bifokke lagibo. ");
INSERT INTO rhg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baf fuwar bifokke, ba fuwa bafor bifokke, ma ziyor bifokke, ba zi mar bifokke, hori bouwor bifokke ba bou horir bifokke lagibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mainšor dolore Isaye hodde, \"Tũwara zehon fosimottu miyula uṛede deko, hetunot onegane ho, 'Zór aibo', ar hendilla o. ");
INSERT INTO rhg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ar zẽtte doinottu bataš badde deho, hetunot ho, 'Beši roidor gorom oibo,' ar hendilla o. ");
INSERT INTO rhg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Munafek okkol! Tũwara duniyai edde asmanor baf buzi faro, kintu ei ṭaim buzi no faror, iyan honḍoilla hota? ");
INSERT INTO rhg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","\"Niyai oinnai tũwara nize bisar gori kiya no sor? ");
INSERT INTO rhg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Zẽtte tũwara bifokkor manušor fũwati bisarharor hãse zo, fõtot maze rehai faibolla kušiš goro, ar no oile hite tũwarare bisarharor hãse ṭani loizaibo. Ar bisarhare fulišor hatot gosai dibo edde fuliše tũware ziyol golai eribo. ");
INSERT INTO rhg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ãi tore hoir: Zetodin šeš foiša foijjonto fũzi no felos, hetodin tui hono mote hentu baire ai no faribi.\" ");
INSERT INTO rhg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","He šomot hozon manuš Isar heṛe hazir oil. Hitara Galilor kissu mainšor babute Isare howa šuru goijje. Hitara hoiye ze, Filate ei Galilor manuššunore haṛi hitarar kurbanir zanuwaror louwor fũwati itarar louwore mišai felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Zuwabe Isaye hodde, \"He Galilor mainšor uwore endilla durgoti oiye boli ki hitara dusora Galilor manušottuwaro beši gunagar boli mone goro? ");
INSERT INTO rhg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ãi tũwarare hoir, hen no! Bolke tũwara zodi o mon no firo, tũwara beggune o hendilla dongšo oi zaibagoi. ");
INSERT INTO rhg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ar no oile he aṛarozon, zarar matar uwore Šilo guid bangi fori mori gilgoi. Tũwara ki mone goro, hitara ki ar baki Zeruzalemot bošobaš goredde hitarattuwaro beši gunagar aššil? ");
INSERT INTO rhg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ãi tũwarare hoir, hen no! Bolke tũwara zodi o mon no firo, tũwara beggune o hendilla dongšo oiba.\" ");
INSERT INTO rhg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tarfore Isaye ei mesal kahanigan hoiye: \"Ekzon manuš, hitar ãngur ketit uggwa ḍuirgula gas aššil. Hite heṛe ai ḍuirgula tuwail, kintu no fa. ");
INSERT INTO rhg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Henot hite keti sõloyare hodde, 'Ãi eṛe ei gasot tin bosor mula ailam edde ḍuirgula tuwailam, kintu hono gula fa no za. Iba haṛi felaide! Iba eṛe taiyore kiyolla zobin nošto oito!' ");
INSERT INTO rhg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","\"Kintu keti sõloyaye hodde, 'Huzur, ibare ei bosor o raki do, ãi ibar šiyoror sairo ḍakottu kuri fãš diyum. ");
INSERT INTO rhg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Zodi gula lage toile to bala, ar no oile hiba haṛi felaiyo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ek dórmor din Isaye hono ek sinagogot šikka dil. ");
INSERT INTO rhg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ar so, ekzon maya fuwa, zare aṛaro bosorfan ek bod ruhuye kuza gori raikke. Hiba en behã oi gilgoi hono mote uzu oi no farito. ");
INSERT INTO rhg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isaye zehon hibare deikke, toi hibare hãse ḍaikke, ar hodde: \"Oh maya fuwa, tui ošukottu azad oiyos!\" ");
INSERT INTO rhg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hen hoi bade Isaye hãttan hibar uwore raikke. Ar hehon hiba uzu oi tiyai faijje edde hibaye Allar tarif gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kintu Isaye dórmor din aram goijje boli muzolišhanar netaye naraz oiye. Hite manuš okkolore hodde: \"So din ase he šob ham goribar. Ar he šomosto din okkolot aiššo edde aram oiyo, dórmor din no!\" ");
INSERT INTO rhg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kintu Malik Isaye hitare zuwab diye, \"Munafek okkol! Tũwara fottizone ki dórmor din tũwarar goru sool okkolore urattu kuli fani habaito no loi zo? ");
INSERT INTO rhg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Toile ei maya fuwa, Ibrahimor šontan, zare Šoitane, so, aijja aṛaro bosor dori bandi raikke, he bandottu dórmor din azad fa ki zoruri no ne?\" ");
INSERT INTO rhg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Isaye ei hotabattara zehon hoiye, hibar bifokkor beggune šorminda oiye. Kintu Isar duwara ze šomosto mohimar ham oiye, henot baki šomosto manuš okkol kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tarfore Isaye hodde, \"Allar raijjo kiyor ḍoilla? Ki loi ãi hiyanor tulona diyum? ");
INSERT INTO rhg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hiyan uggwa šoṛo danar ḍoilla, hono ekzone hiba loi zai nizor baganot lagaiye, bade hiba bari uiṭṭe edde uggwa gas oiye, ar faik okkole he gasor ḍeil okkolot baha bainde.\" ");
INSERT INTO rhg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Isaye abar hodde, \"Ãi ki loi Allar raijjor tulona diyum? ");
INSERT INTO rhg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hiyan išor ḍoil, zin mayafuwainde tin barang moidat maze mišaiye, šeše hin fuli uiṭṭe.\" ");
INSERT INTO rhg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ar Isaye šohore šohore edde fara fara guri guri šikka di di Zeruzalemor uzu giye. ");
INSERT INTO rhg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hetunot ekzone fusar goredde, \"Malik, zara uddar far, hitara ki hom manuš?\" Isaye hitare hodde, ");
INSERT INTO rhg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","\"Haiṭṭa haṛiwala doroza bai golibolla har kušiš goro! Kiyollahoile ãi tũwarare hoir, bout kiye butore goilto kušiš goribo, kintu goli no faribo. ");
INSERT INTO rhg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Góror malike uṛi zehon doroza bandi felaibo bade tũwara baire tiyai doroza baijjai howa šuru goriba, 'Malik, ãralla dorozagan kuli do!' \"Kintu Malike zuwab di hoibo, 'Ãi no sini tũwara hoṛiyar manuš.' ");
INSERT INTO rhg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","\"Toi tũwara howa šuru goriba, 'Ãra tũwar ekkui fũwati há fiya goijji, ãrare fõte fõte tũi šikka dila.' ");
INSERT INTO rhg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","\"Kintu he malike hoibo, 'ãi tũwarare no sini, tũwara honttu aiššo. Horaf manuš okkol, ãr sarmottu dur oi zogoi!' ");
INSERT INTO rhg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","\"He zagat tũwara handa haṛi goriba edde zala zontronaniye dat loi dat gošiba. Hetunot tũwara dekiba, Ibrahim, Isak edde Yakub edde nobi okkol Allar raijjor butore ase, ar tũwarare baire felai diya oiye. ");
INSERT INTO rhg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ar fuk edde fosimottu, uttor edde doinottu manuš okkol ai Allar raijjot boibo. ");
INSERT INTO rhg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ar so, šešor hataror hono hono manuš foila oibo. Ar foila hataror hono hono manuš šešor hatarot oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","He šomot hoekzon Foroši Isar hãse aišše edde hibare hodde, \"Huzur! Õne entu ar oinno hono mikka zogoi, kiyollahoile badša Herude tũware mari felaito sar.\" ");
INSERT INTO rhg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Isaye hodde: \"Zo, tũwara zai he šiyalore hogoi, 'Aijja edde aiyerde hailla ãi bod ruh dafair edde biyaraimma okkolore aram gorir, ar tin dinor din ãr ham šeš goriyum.' ");
INSERT INTO rhg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Zen oibo ok, aijja, aiyerde hailla edde forure šeš gora foribo. Kiyollahoile en to oi no faribo, Zeruzalemor baire hono nobi dongšo o! ");
INSERT INTO rhg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","\"Zeruzalem! Zeruzalem! Tui nobi okkolore kun goros, tor hãse zarare defeṛa o, hitarare fattor mari takos! Faikor maye zendilla hibar so okkolore fakor nise ekkui fũwati gore, ãi hoto bar hendilla tor šontan okkolore ekkui fũwati goitto issa goijji. Kintu tũwara razi no oila. ");
INSERT INTO rhg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hetolla sa, tũwarar gór tũwarar muntu hali fori taibo. Ar ãi tũwarare hoir, tũwara ãre ar deha no faiba zetun foijjonto tũwara no ho, 'Šukuriya ze Mabudor name aišše.'\" ");
INSERT INTO rhg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ek bar ekzon Foroši netaye Isare hitar górot hánar dawat diye. He din aššilde dórmor din, ar manušzone kub bala gori Isar uzu kiyal raikke. ");
INSERT INTO rhg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ar so, fula biyaram oiyede hendilla ekzon ošuikka manuš Isar sarme aišše. ");
INSERT INTO rhg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Toi Isaye dórmiyo alem okkol edde Foroši okkolore fusar goredde, \"Musar ain mozin dórmor din honokiyore aram goro ki ejazot ase, naki nai?\" ");
INSERT INTO rhg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kintu hitara nizam oi taikke. Hetunot Isaye he manušware hate dori aram gori bidai diye. ");
INSERT INTO rhg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tarbade Isaye he dórmiyo neta okkolore hodde, \"Tũwara honokiyor fũwa ba goru zodi kuwat fori zagoi, dórmor din oile o ki tũwara hitarare hehon hentu tuli no lo ne?\" ");
INSERT INTO rhg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kintu hitara hiyanor zuwab o di no fare. ");
INSERT INTO rhg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ar dawatot aišše de manuš okkole ijjotor zaga ken gori basi lor deki, Isaye hitarare šikka dibolla ekkan kahani hoiye: ");
INSERT INTO rhg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"Zehon honokiye tũware melat dawat de, hetunot tũi hánar ṭebilor uworor zagat zai no boiššogoi. Kiyollahoile oitfare tũwattuwaro aro ijjotdar honokiyore heṛe dawat diya oiye. ");
INSERT INTO rhg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ze tũware edde hibare dawat diye hiba ai zodi tũware ho, ei zaga iyan ubare do, hetunot to tũi šorom faiba. Ar tũwattu beggunottuwaro nisor zagat zai bowagoi foribo. ");
INSERT INTO rhg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tũware honokiye dawat dile, bolke beggunottuwaro nisor zagat zai boiyo. Hen oile dawat diyede góror malike aiyore tũware hoibo, 'Bondu aro bala zagat zai boyogoi.' Hetunot oinno meheman okkolor sarme tũi ijjotta oiba. ");
INSERT INTO rhg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kiyollahoile ze nizore usol gore hitare niso gora oibo, ar ze nizore niso gore hitare usol gora oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ar ze Isare dawat diye, hitare Isaye hodde, \"Tũi zẽtte dũijjar otóba hazinnar hána goro, hẽtte tũwar bondu ba báiyaindore otóba egena gušṭire ba tuwangor ḍen gór bam góijjare dawat no diyo. Hen gorile oitofare hitara o tũware dawat dibo. Ar ei bafe tũwar dawat fũzi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kintu tũi zẽtte hánar bebosta goro, hẽtte gorib, lula, anda edde ãtur, in okkolore ḍako. ");
INSERT INTO rhg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Henot tũwar balai oibo, kiyollahoile tũware firai dibolla hitarattu kissu no takibo, forhesgar okkol morattu uwafes zinda oibar šomot hinor enam faiba.\" ");
INSERT INTO rhg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Zara hána haito boišše hitarar butottu ekzone ei hota funi Isare hodde, \"Hite hoto baggitta, ze Allar raijjot haito boibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isaye hitare hodde, \"Doro, hono ekzon mainše ekkan ḍõr mela goijje. He melat bout mainšore dawat diya oiye. ");
INSERT INTO rhg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mela zehon oiye, hite hitar gulamore di dawat diyede manuš okkolore hoito defeṛaiye, 'Aio, ehon hár kissu tiyar oiye.'\" ");
INSERT INTO rhg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","\"Kintu hitara ekzonor bade ekzone beggune bahana deha šuru goijje. Foila ekzone hodde, 'Ãi kissu zobin kinni, ãttu zaire hin sagoi forer. Ãi dawatot zai no faridde hiyanolla maf sai.' ");
INSERT INTO rhg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","\"Ar ekzone hodde, 'Ãi fãs zura bolod goru kinni, hinore bala horaf forikka goitto zair. Ãi dawatot zai no faridde hiyanolla maf sai.' ");
INSERT INTO rhg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","\"Oinno ar ekzone hodde, 'Ãi biya goijji, hetolla ãi zai no farir.' ");
INSERT INTO rhg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","\"Toi he gulam firi zai hitar malikore ei šob hota zanaiyegoi. Henot góror malike hitar gulamore rag gori hodde, 'Tui toratori šohoror rasta rasta edde goliye goliye za, gorib lula, anda, ãtur okkolore eṛe loi ai.' ");
INSERT INTO rhg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","\"Hite giye edde malike zen zen hoiye hen hen goijje. Toi hite górot firi ai hodde, 'Huzur, kintu ehono kissu hána háibar zaga hali ase.' ");
INSERT INTO rhg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","\"Henot malike gulamore hodde, 'Šohoror baire rasta rasta edde fõte fõte za, eṛe aibolla mainšore zurgor, zene ãr gór bori zagoi.' ");
INSERT INTO rhg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ãi tũwarare hoir, zarare dawat diya oiye hitarar butottu honokiye ãr ei melat hána hái no faribo.\" ");
INSERT INTO rhg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bout manuš okkol Isar fũwati zat aššil. Isaye hitarar uzu muk firai hodde: ");
INSERT INTO rhg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"Ze ãr hãse aiye hite zene nizor baf ma, bou fuwain edde bái boin, enki nizore foijjonto ãttuwaro hom adoijja boli mone gore. Hen no gorile hite ãr biššaši oi no fare. ");
INSERT INTO rhg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ze honokiye fotti din nizor duk hoštore bordaš gori ãr fise no aiye, hite ãr biššaši oi no fare. ");
INSERT INTO rhg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","\"Tũwarar butore zodi honokiye ekkan usol gór banaito sa, toile hite age boi horosor hisab gori no saibo ne? Hite saibo hiyan bandi šeš gori farefan hitattu ṭĩya ase ne nai. ");
INSERT INTO rhg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kiyollahoile hite ṭuni gãri bade zodi bandi šeš gori no fare, toile ze mainše hiyan dekibo hitara beggune ṭaṭṭa uraibo. ");
INSERT INTO rhg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hitara hoibo, 'Manušwaye banda šuru goijje kintu šeš gori no fare.' ");
INSERT INTO rhg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","\"Zodi ekzon razaye oinno ar ekzon raza loi zuddo gorito za, hite foila boi sinta goribo, kuri hazar šonnioye ãr loi zuddo goitto aiyer, šude doš hazar šoinno loi ki ãi hitarare tiya gorai fariyum? ");
INSERT INTO rhg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Zodi hite hitar loi no fare toile hite oinno raza dure taite hitar loi šanti sukti goribolla manuš defeṛaibo. ");
INSERT INTO rhg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","\"He bafe, tũwarar butore zodi honokiye bafi sinti hitar hár kissu sari no aiye, hen oile hite ãr biššaši oi no fare. ");
INSERT INTO rhg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","\"Nun bala ziniš, kintu nunor moza zodi nošto oi zagoi, toile hin ken gori abar nun oibo? ");
INSERT INTO rhg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hetunot hin šude felai diya sara, zobinot fãš hisabe o ar bebar gora no zaibo. \"Zattu funibar han ase hite funok!\" ");
INSERT INTO rhg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ar hazna adaigoroya edde gunagar manuš okkol beggune Isar kalam funibolla Isar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Henot Foroši okkole edde dórmiyo alem okkole monmonai endilla howa šuru goijje, \"Ei manušwaye gunagar okkolore gose edde hitarar fũwati há fiya gore.\" ");
INSERT INTO rhg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isaye hetunot hitarare ei mesal kahanigan hoiye: ");
INSERT INTO rhg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"Doro! Tũwarar butore hono ekzonottu ek šottuwa berasool ase. Zodi hinor butottu uggwa berasool hãzi zagoi. Toile ki aro nobboi noware maṛot raki, he uggware zetun tuwai no fa he foijjonto ki tuwaito no zaibo ne? ");
INSERT INTO rhg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ar hite zehon hiba tuwai faibo, hite kuši oi hibare handot tuli loibo. ");
INSERT INTO rhg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bade górot ai hitar fũwajja okkol edde ḍen gór ba gójjare ḍaki hoibo, 'Aiyo! Ãr fũwati kuši goro, kiyollahoile ãr hãzi gilgoide berasoolguwa tuwai faiyi.' ");
INSERT INTO rhg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ãi tũwarare hoir, ṭik hendilla, ekzon gunagar gunattu mon firaile behostot aro beši kuši oibo, zarattu monfira no fore, hendilla nobboi nozon forhesgaror babute heto beši kuši no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","\"Otóba hono ekzon mayafuwattu doššan rufar foiša ase, hibaye zodi ekkan hãzai fele, toile serag zalai gór kũsai zetun hiyan tuwai no fa, he foijjonto bala gori tuwai no saibo ne? ");
INSERT INTO rhg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Toi hibaye zehon hiyan tuwai faibo, hibaye fũwajja okkolore, ḍen gór bam gójjare ḍaki hoibo, 'Aiyo! Ãr fũwati kuši goro, kiyollahoile hãzi gilgoide foišagan ãi abar tuwai faiyi.' ");
INSERT INTO rhg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ṭik hendilla, ãi tũwarare hoir, ekzon gunagar gunattu mon firaile Allar firista okkolor maze kuši aiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isaye hodde: \"Ekzonottu duizon morod fuwain aššil. ");
INSERT INTO rhg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Šoṛo fuwawaye bafore hodde, 'Baba, šombottir ze borat ãr bagot fore, hiyan ãre difelo.' Henot hite hitar dui futor maze šombottigun borat gori diye. ");
INSERT INTO rhg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hotodin din bade he šoṛo fuwawaye hitar har šombotti besi ṭĩya loi ek duror dešot giyoi. Ar heṛe hite altifalti zibon haṛai hitar nizor ṭĩya foiša urai felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hin horos goijja oiye, bade he dešot kub beši raṭ oiye. Henot hite obafot fora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Toi hite zai he dešor ek girostorot sahara loiyegoi. He manušwaye hitare šuwor soraibolla hitar maṛot defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Toi hite šuworor adar hái feṭ boraito saito, edde honokiye hitare hono kissu no dito. ");
INSERT INTO rhg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","\"Hite zehon hitar nizor bul buzi faijje, hite hodde, 'Ãr bafor góror hoto muzur okkole beši beši hána far, kintu ãi eṛe bukke morir. ");
INSERT INTO rhg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ãi uṛi ãr Bafor heṛe zaiyum edde ãi hoiyumboi: O baf, ãi Allah edde tũwar berudde guna goijji. ");
INSERT INTO rhg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ãre tũi tũwar fuwa ho he zuiggota ãttu ar nai, kintu ãre tũi šude tũwar oinno muzur okkolor ḍoil gori ãre rako.' ");
INSERT INTO rhg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Endilla hoi hite hitar bafor heṛe giye. \"Hite dure taite bafe hitare deki hitalla doyaye dil bori uiṭṭe. Ar hite fuwar hãse dũri zai, gola sai berai dori galot suma diye. ");
INSERT INTO rhg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","\"Fuwaye hodde, 'O baf, ãi Allah edde tũwar berudde guna goijji. Ãre tũi tũwar fuwa ho he zuiggota ãttu ar nai.' ");
INSERT INTO rhg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","\"Kintu hitar bafe hitar gulam okkolore hodde, 'Toratori barik kurutawa ano edde itare gat diyai do, õlot õri, ṭengot šendal findai do. ");
INSERT INTO rhg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ar boli muṭa goruror sowa ano edde hiba zorgorao. Aiyo, mela gori edde hafiya gori. ");
INSERT INTO rhg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kiyollahoile ãr ei fuwa mori gilgoi edde ehon zinda oiye. Hite hãzigilgoi edde abar fa giye.' Toi hitara mela edde há fiya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","\"Hetunot ḍõr fuwawa bare ketit aššil. Hite aite aite zehon góror hãsa hãsi fõisse, hetunot tal bazana nasor abaz fuinne. ");
INSERT INTO rhg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Toi hite ekzonore ḍak mari fusar goredde: Eṛe ki oiyede? ");
INSERT INTO rhg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hite hodde: Tor šoṛo bái firi aišše, hitare šušondane firai faiyede hetolla tor bafe boli muṭa gorur soware zorgoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","\"Henot he ḍõr báiye gušša oiye edde górot no goilto saiye. Toi hitar bafe góror baire zai hitare górot golaibolla fot dori hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kintu hite bafore hodde, 'So, hara bosorṭiya ãi tũwalla gulami gori aiyir, ar hono din tũwar hokumor baire no zai. Hen abostat maze o tũi ãre fũwajja okkol loi kuši aiyaši goribolla hoi uggwa soolor so foijjonto no do. ");
INSERT INTO rhg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kintu ze fuwaye tũi dilade ṭĩya foiša beggun beššiya okkolor fise hossa gori felaiye, bade górot firi aišše, hitalla boli tũi muṭa goruwa zorgoraiyo!' ");
INSERT INTO rhg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","\"Bafe hodde, 'O fut, tui hamiša ãr fũwati asos, ar zin ãttu ase hin tor. ");
INSERT INTO rhg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kintu ãrattu mela gori kušiaši goron zorulot, kiyollahoile tor ei bái mori gilgoi, abar zinda oiye. Hite hãzigilgoi, abar hitare fa giye.'\" ");
INSERT INTO rhg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isaye sahabi okkolore hodde: \"Hono ek tuwangor mainšottu ekzon menezar aššil. He tuwangor manušwaye mainšottu funedde ei menezare hitar dón šombotti sarhar gori feler. ");
INSERT INTO rhg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hetunot hite menezarore ḍaki fusar goredde, 'Tor babute ãi in ki funir? Tor hamor hisab de, kiyollahoile tũi ar ãr menezar hisabe tai no faribi.' ");
INSERT INTO rhg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","\"Hetunot he menezare mone mone hodde, 'Ãi ehon ki goijjum? Ãr malikede ãre hamottu niyolai der. Ãttu meṛi haṛibar o šokti nai, ar ãttu horat magite o šorom lage. ");
INSERT INTO rhg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Zen oibo ok, malike hamottu niyolai dile, mainše zene ãre hitarar górot takito de he bebostalla ãttu ki gora foribo ãi zani.' ");
INSERT INTO rhg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","\"En hoi, zitara hitar malikor hãsottu šud loiye hitarare ekzon ekzon fottikiyore ḍaikke edde foila ekzonore hodde, 'Tui ãr malikottu hozzo hodun loiyos?' ");
INSERT INTO rhg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","\"Hite hodde: 'Ek šot mon tel.' \"He menezare hitare hodde, 'Tor hozzor habosgan lo edde toratori boi, hiyanot fõnzaš mon lek.' ");
INSERT INTO rhg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","\"He menezare ar ekzonore hodde, 'Tor hozzo hodun?' \"Hite hodde, 'No šot mon gĩyu.' \"Menezare hitare hodde: 'Tor habosot hãt šot mon lek.' ");
INSERT INTO rhg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","\"He menezar ošot oile o hite aholor ham goijje boli hitar malike hitar bala nam goijje. Kiyollahoile ei duniyair manuš okkole nizor zatir babute fohoror fuwain okkolottuwaro beši buddiwala. ");
INSERT INTO rhg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ãi tũwarare hoir, ei horaf duniyair dónor duwara mainšolloi egenafoti zurao, zenneki he dón furai gilegoi bade hitara abadul abad takibar zagat tũwarare gose. ");
INSERT INTO rhg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","\"Zare šoṛo befaror uwore biššaš gora za, hitare ḍõr befaror uwore o biššaš gora za, ar šoṛo befare zare biššaš gora no za, hitare ḍõr befare o biššaš gora no za. ");
INSERT INTO rhg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ei duniyair dón šombottir befare zodi tũwarare biššaš gora no za hen oile tũwarare biššaš gori asol dón hone dibo? ");
INSERT INTO rhg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Oinnor šombottir uwore zodi tũi obiššaši o, tũware nizolla šombotti hone dibo? ");
INSERT INTO rhg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","\"Hono gulame dui malikor šeba gori no fare, kiyollahoile hite ekzonore hingša goribo ar ekzonore ador goribo, otóba hite ekzonor uzu mon dibo, ar dusora zonore hela goribo. Allah edde dón šombotti ei duior šeba o tũwara ekku fũwati gori no fariba.\" ");
INSERT INTO rhg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Toi Foroši okkol zara ṭĩya foišar lalsiwala, hitara Isar ei šob hota funni Isare loi ṭaṭṭai goijje. ");
INSERT INTO rhg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isaye hitarare hodde, \"Tũwarattu to mainšor muntu forhesgar kuwalaito mon, kintu Allaye tũwarar monor abasta zane. Manuše ziyan šorman mone gore hiyan Allar sukot niroš.\" ");
INSERT INTO rhg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","\"Torar ain edde nobi okkolor kitab mozin torikotor gusol doya Yahyar ṭaim foijjonto soille. Tarfore oite Allar raijjor kušir hóbor tobolig gora or, ar beggune heṛe golibolla ṭelaṭeli gorer. ");
INSERT INTO rhg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tarfore o Musar šoryotottu uggwa horof bad forattuwaro bolke asman zobin šeš oi za aro bout asan oibo. ");
INSERT INTO rhg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","\"Ze honokiye nizor bouwore sari di ar ekzonore biya gore hite zena gore. Zamaiye sari diyede hendilla bouwore ze biya gore hite zena gore. ");
INSERT INTO rhg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","\"Ekzon tuwangor manuš ze baiyonna rongor hor edde dami dami horsuwor findito. Hite fotti din kub zak zomok há fiya loi zibon haṛaito. ");
INSERT INTO rhg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","He tuwangor manušwar gaṛaṛ duwaror ḍake Lazarus name ekzon horat magoyare buwai dito. Hitar hara gat gá aššil. ");
INSERT INTO rhg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","He tuwangor manušwar hánar tebilottu ze hána fori zaitoi hin hái hite feṭ boraito issa gorito. Kũir okkole hitar gá lekito. ");
INSERT INTO rhg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","\"Ek din he magoyawa mori gilgoi. Hetunot firista okkole hitare tuli loi zai Ibrahimor kulot buwai dilgoi. Tarfore ek din oi tuwangor manušwa o mori gilgoi, edde hitare hoborot garai fela oil. ");
INSERT INTO rhg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hite jahannamot kub zontrona loi uworor mikka sail, ar durottu tai dekedde Ibrahimor kulot Lazarus. ");
INSERT INTO rhg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hetunot oi tuwangor manušwaye ḍak mari hodde, 'Baf Ibrahim ãre rahamot goro. Lazarusore defeṛo, ãi zene hitar õlor matagan fanit bizai ãr zil ṭanḍa gori fari. Ei oinor zilhat ãi beši duk fair.' ");
INSERT INTO rhg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","\"Kintu Ibrahime hodde, 'O fut, mone gori sa, tũi basi takite hoto šuk goijjili ar Lasare hoto duk toziya faiye. Kintu ehon hite eṛe šuk gorer ar tui duk for. ");
INSERT INTO rhg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hin bade o tũwara edde ãrar maze ekkan beši ḍõr fák ase, honokiye issa gorile o enttu farai tũwarar heṛe zai no fare edde henttu farai ãrar hãse ai no fare.' ");
INSERT INTO rhg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","\"Hetunot he tuwangorwaye hodde, 'Toile baf, meherbani gori Lazarusore ãr bafor górot defeṛo, ");
INSERT INTO rhg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","zene ãr he fãs báiyore hite hũšiyar gori di fare. Ar no oilede hitara o ei zontronar zagat aibo.' ");
INSERT INTO rhg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","\"Kintu Ibrahime hodde, 'Musa nobi edde nobi okkolor kitab to hitarar hãse ase. Hitara hinottu diyan di funok.' ");
INSERT INTO rhg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","\"He tuwangor manušwaye hodde: 'No, no, baf Ibrahim, mora okkolor butottu honokiye zaile hitara gunattu mon firaibo.' ");
INSERT INTO rhg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","\"Toi Ibrahime hodde, 'Musa nobi edde nobi okkolor hota zodi hitara no fune toile morar butottu honokiye uṛile o hitara biššaš no goribo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isaye hibar sahabi okkolore hodde: \"Gunar fõtot loizaibar uskani sarme no aibo, hen to oi no fare, kintu bifod hitare, zar duwara hin aibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ze ei šoṛo okkolor butottu ekzonore honokiye gunar fõtot ṭani loi zade o, henoile hitare golat ḍõr fattor bandi di doriyat felai diya hitalla aro beši bala oibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hetolla tũwara nizor babute hũšiyar taikko. \"Zodi tor báiye tor berudde hosuri gore, toile tui hitare hen no goribolla mana gor. Ar zodi hite mon fira toile tui hitare maf goride. ");
INSERT INTO rhg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Zodi ek dinor butore hite hãt bar tor berudde hosuri gore edde hãtobar ai ho, 'Ãi ei oinnaittu firi aišši,' toile hitare tottu maf gori diya foribo.\" ");
INSERT INTO rhg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ar asab okkole malik Isare hodde: \"Ãrar iman barai do.\" ");
INSERT INTO rhg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Isaye zuwabe hodde, \"Uggwa horoir dana borabor biššaš o zodi tũwarattu take edde ei gassware endilla ho, 'Ei gas, šiyõr udda šoho hãri zai doriyat fuṭgoi,' toile he gaswaye tũwarar hota manibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","\"Ar tũwarar butore endilla hone aso, zar gulame al so otóba sool sora, hite górot aile hoiba 'Tui ehon ai, hána haito bošgai?' ");
INSERT INTO rhg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bolke hitare ki no hoiba ne? 'Ãi ki háiyum hinor entezam gor! Ar zetun ãttu hána haiya no o, hetun kiyail bandi ãre šeba gor! Tarfore tui hána hái faribi!' ");
INSERT INTO rhg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","He gulame malikor hokum mainne buli ki hitar malike hitare šukuriya zanaibo? ");
INSERT INTO rhg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","He bafe har hokum mani bade o tũwara ho, 'Ãra niroš gulam, ziyan goribar zimma ãra šude hiyan goijji.'\" ");
INSERT INTO rhg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ehon Isaye Zeruzalem zaibar šomot Sameriya edde Galilor mazottu di giye. ");
INSERT INTO rhg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hibaye hono ek farat góillede šomot došzon kurus biyaraimma manuš hibar sarme foijje. Hitara dure tiyaiye edde, ");
INSERT INTO rhg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","guzori hodde: \"Isa, Malik, ãrare doya goro!\" ");
INSERT INTO rhg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Isaye hitarare deki hodde, \"Zo, imam okkolor hãse zai nizore dehogoi.\" Zaite zaite hitara faksaf oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Toi hitarar butottu ekzone aram oi giyegoide otfaiyore hite guzori Allar tarif gorat uwafes firi aišše, ");
INSERT INTO rhg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","edde Isar fõt uite fori Isare šukuriya zanaiye. He manušwa aššilde Sameriyar manuš. ");
INSERT INTO rhg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Isaye hodde, \"Došozon pak saf no o neki? Ar nozon hoṛe? ");
INSERT INTO rhg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ei ofor manušwa sara ki ar honokiye Allare tarif goribolla no ailo?\" ");
INSERT INTO rhg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Toi Isaye hitare hodde, \"Uṭ edde zagoi! Tor biššaše tore bala goijje!\" ");
INSERT INTO rhg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ek bar Foroši okkole Allar raijjo hõtte aibo Isare fusar goijje. Isaye zuwabe hodde, \"Allar raijjor suke deha no za. ");
INSERT INTO rhg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ar manušore o no hoibo, so, Allar raijjo ei zagat ba o zagat, kiyollahoile so, Allar raijjo to tũwarar butore ase.\" ");
INSERT INTO rhg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Toi Isaye sahabi okkolore hodde: \"En šomoi aibo zẽtte tũwara Adomor Futor šomoir ekkan din dekibolla issa goriba, kintu deha no faiba. ");
INSERT INTO rhg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hẽtte manuš okkole tũwarare hoibo, 'So, Adomor Fut o zagat!' So, 'Adomor Fut ei zagat!' Kintu tũwara heṛe no zaiyo, ba hitarar fisa no loiyo. ");
INSERT INTO rhg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Zendilla asmanor ek mikkattu bizoli somkile asmanor nise oinno mikka foijjonto fohor o, Adomor Futor dinot o hendilla oibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kintu ei šob goṭibar age, Adomor Futottu beša beši duk bug gora foribo. Ar ei halor mainše hibare batil goribo. ");
INSERT INTO rhg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","\"Ar Nuh nobir ṭaimot zendilla oiye, Adomor Futor ṭaimot o hindilla oibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Manuš okkole há fiya goijje, biya goijje, biyata oiye, ze foijjonto Nuh nobi kištit no gole. Toi bor tuwan aišše edde beggunore šeš gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","\"He bafe Lutor ṭaimot o hendilla oiye. Hẽtte mainše háiye edde fiye, beisse edde kinne, lagaiye edde banaiye. ");
INSERT INTO rhg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kintu ze din Lut Súdum šohorottu niyoli giyegoi, hedin asmanottu oin edde oini šilor zór fori hitara beggunore dongšo gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","\"Adomor Fut ze din nizore forhaš goribo, he din o hendilla oibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","He dinor din zodi honokiye góror sãdor uwore take, ar hitar šomošto zinišfati góror butore take, henoile hite hin loibolla lami no ai ok. Hendilla ze maṛot take, hite górot uwafes firi no ai ok. ");
INSERT INTO rhg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lutor bouwor hota monot gori so! ");
INSERT INTO rhg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ze nizor foran basaito sa, hite hiyan haraibo. Kintu ze foran hara, hite hiyan uddar faibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ãi tũwarare hoir: He raitta ek bisanat duizon takile ekzonore loi za oibo, ar oinno ekzon fori takibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duizon mayafuwain ek ḍeit gĩyur dana dufe. Hentu ekzonore loi za oibo, ar oinno ekzon fori takibo. ");
INSERT INTO rhg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Zodi duizon manuš maṛot take, hentu ekzonore loi za oibo, ar oinno ekzon fori takibo.\") ");
INSERT INTO rhg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Toi sahabi okkole fusar goredde: \"Malik, hoṛe goṭibode?\" Isaye zuwabe hodde, \"Mora ga zeṛe, heṛe hawa aiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Toi hibaye hitarare ekkan mesal kahanir babute hoiye zene hitara hamiša munazat gore edde niraš no o. ");
INSERT INTO rhg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hibaye hodde,\"Ek šohorot maze ekzon bisarhar aššil. Hite no ḍoraito Allare, ar no manito manušore. ");
INSERT INTO rhg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ar he šohorot ek rari maya fuwa aššil. Hibaye he bisarharor hãse zai hoitode, 'Oinnair berudde tiyai ãr bifokkor hatottu ãre uddar goro!' ");
INSERT INTO rhg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","\"Bisarhare hoto din foijjonto kissu no gore, kintu bade mone mone hite hodde, 'Zodi o ãi Allare no ḍorai, manušore no mani. ");
INSERT INTO rhg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tarfore o ei rari mayafuwawaye ãre zalar, hetolla oinnaittu ibare ãi uddar goriyum. Ar no oilede hibaye hamiša ãre zalat takibo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Toi Malik Isaye hodde, \"Ošot bisarhare ki hor funor ne! ");
INSERT INTO rhg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Toile zara din rait Allar hãse handa haṛi gore, he Allar basai gora okkolore ki hitarar oinnair berudde tiyai soiyi bisar no goribo? Naki hin goitte Allaye deri goribo? ");
INSERT INTO rhg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ãi tũwarare hoir, hibaye toratori hitarar fokke niyai bisar gori dibo. Kintu Adomor Fut zẽtte aibo, hẽtte ki hibaye ei duniyait iman dekibo?\" ");
INSERT INTO rhg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zara nizore nize forhesgarde biššaš goitto ar oinno mainšore hela gorito, hendilla hoekzon mainšore Isaye ei mesal kahanigan hoiye: ");
INSERT INTO rhg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","\"Duizon manuše dórmogórot munazat goitto giye. Hitarar butore ekzon aššilde Foroši alem ar ekzon hazna adaigoroya. ");
INSERT INTO rhg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Foroši alemwaye zai en zagat tiyayegoi zeṛe hitare deha za. Toi hite hitar nizor babute duwa gorer, hite hodde, 'Oh Allah, ãi tũware šukuriya zanai ze ãi oinno mainšor ḍoilla no, ṭok, ošot edde zena goroya no, enki oi hazna adai goroyar ḍoilla o no. ");
INSERT INTO rhg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ãi haftaye dui bar ruza raki, ãr šomosto hamanir doš bagor ek bag tũware di.' ");
INSERT INTO rhg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","\"Kintu hazna adaigoroya manušwaye dure tiyaiye edde asmanor uzu suk tuli o sai no farer, bolke hite buk bajjai bajjai hodde, 'Oh Allah, ãi gunagar, ãre rahamot goro.' ");
INSERT INTO rhg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","\"Ãi tũwarare hoir, he hazna adai goroyare Allaye forhesgar hoi mani loiye, hite arame górot firi giyegoi. Kintu he forošire no. Toile buzi so! Ze honokiye nizore usol gore hitare niso gora oibo, ar ze nizore niso gore hitare usol gora oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hitara gura gura dudor fuwain okkolore o Isar hãse ainne, Isaye zene hitarar uwore hat rake. Sahabi okkole hen deki hitarare gozgozaiye. ");
INSERT INTO rhg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kintu Isaye gura fuwaindore hãse ḍaikke edde hodde, \"Gura fuwaindore ãr hãse aito do, hitarare band no diyo, kiyollahoile Allar raijjo itarar ḍoilla mainšor. ");
INSERT INTO rhg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ãi tũwarare soiyi hoir, ze honokiye ugguwa gura fuwar ḍoilla oi Allar raijjo no gose, hite hono mote heṛe goli no faribo.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ek Ihudi netaye Isare fusar goredde: \"Oh bala ustad, akéri zibonor miraz faite ãttu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kintu Isaye hitare hodde, \"Ãre kiyolla bala hor? Allah ekzon sara ar honokiye bala no. ");
INSERT INTO rhg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tũi to hokumgun zano, 'Zena no goijjo, kun no goijjo, suri no goijjo, misa goba no diyo, tũwar baf mare ijjot goro.'\" ");
INSERT INTO rhg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hite hodde, \"Gura halottu loti ãi in okkol falon gori aiyir.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isaye ei hota funiyore hitare hodde, \"Ehon o tũwattu ekkan ham baki ase. Zo, tũwattu za kissu ase hin beggun besi felo, ar gorib okkolore baṛi do, henot behostot dón faiba. Tarfore ai ãr fisa lo.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ei hota funi hite beši ferešan oiye, kiyollahoile hite aššilde ek ḍõr tuwangor manuš. ");
INSERT INTO rhg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Toi Isaye hitar uzu saiyore hodde, \"Tuwangor okkololla Allar raijjot gola ken duk! ");
INSERT INTO rhg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tuwangor okkol Allar raijjot golattuwaro fuišor fa bai uṭ gola aro asan.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Zara fuinne hitara hodde, \"Henoile uddar hone oi faribo? Henoile Allar raijjot hone goli faribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isaye hodde, \"Ziyan mainšolla ošombob, hiyan Allalla šombob.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Toi Fitore hodde: \"Ãralla ken oibo? So, ãra nizor hár kissu felai aišši edde õnor fisa loiyi!\" ");
INSERT INTO rhg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isaye hitarare hodde, \"Ãi tũwarare soiyi hoir, ze honokiye Allar raijjolla buli nizor gór ba bou, bái boin, ma baf, ba fuwain eri diye, ");
INSERT INTO rhg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hitara fottikiyor ei zugot o bout gun edde aiyedde zugot o akéri zibon faibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bade Isaye hibar barozon sahabire ek ḍeikka loi zai hodde: \"So, ãra Zeruzalem zair, Adomor Futor befare nobi okkole zin zin leikke, he mozin ãre di furon oibo. ");
INSERT INTO rhg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","He zonore Oihudi okkolor hatot tuli diya oibo. Hitara he zonore loi ṭaṭṭa edde ofoman goribo, ar hibar gat sep maribo, ");
INSERT INTO rhg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","beša beši souk maribo edde hibare mari felaibo. Ar tin dinor din abar zinda uṛi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kintu sahabi okkole in kissu buzi no fare. Hitarattu Isaye hoiyede hotar mani gufon roigiyegoi. Hitara Isar hota buzi uṛi no fare. ");
INSERT INTO rhg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ar zẽtte Isa Zeriku šohoror hãsa hãsi aišše, he šomot ekzon anda manuše rastar kinare mager. ");
INSERT INTO rhg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","He anda manušwaye manuš okkolor ãṛar abaz funi fusar goredde: Ki oiyede? ");
INSERT INTO rhg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mainše hitare hodde: \"Nasarator Isa ei fõt bai aiyer.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hetunot hite guzori hodde: \"Oh Nasarator Isa, Daudor šontan, ãre uwore doya goro.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Zara age age giye, hitara, suf tak, hoi he manušware dõk diye. Kintu hite aro beši sikkarai howa šuru goijje, \"Oh Daudor šontan ãr uwore doya goro.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Toi Isa tiyaiye edde he manušware Isar hãse anibolla hokum goijje. Hite zehon Isar ḍake aišše Isaye hitare fusar goredde, ");
INSERT INTO rhg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"Tui ki sos, ãi tolla ki gorium?\" Hite hodde, \"Malik, ãi suke deki farifan gori do.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isaye hodde, \"Dor, deki far! Tor imane tore aram goijje.\" ");
INSERT INTO rhg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Henot hite hehon suke deki faijje edde Allar tarif gori gori Isar fisa loiye. Ar manušor dol, zara iyan deikke hitara o Allar tarif goijje. ");
INSERT INTO rhg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bade Isa Zeriku šohoror butottu di zar. ");
INSERT INTO rhg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ar so, heṛe ekzon Sakkeus name manuš aššil. Hite oilde ekzon hazna adaigoroya okkolor mazi, ek tuwangor manuš. ");
INSERT INTO rhg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ar hite Isare saito kušiš goijje, kintu hite baiṭṭa buli manušor zamot Isare sai no fare. ");
INSERT INTO rhg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Toi hite Isare sai farefan, mum mikka dũri zai ek ḍũir gasor uwore uiṭṭe, kiyollahoile Isa he fõt bai gil. ");
INSERT INTO rhg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bade Isaye zẽtte he zagat fõisse, hetunot Isaye uwor mikka sai hitare hodde, \"Sakkeus, toratori lami ai, kiyollahoile aijja ãttu tor górot taka foribo.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Henot Sakkeuse toratori lami aišše edde Isare kušir sãte mehemandari kobul goijje. ");
INSERT INTO rhg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kintu hen deki beggune monmonaiye, \"Isaye ekzon gunagaror górot rait haṛaito zar.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kintu heṛe Sakkeuse tiyai malik Isare hodde, \"Malik so, ãr šombottir oddok ãi gorib okkolore dir. Ar zodi oinnai bafe honokiyor hono kissu ṭokai taki, toile hinor ãi sairgun firai diyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hetunot Isaye hitare hodde: \"Uddar aijja ei górot aišše, Sakkeus o ekzon Ibrahimor šontan. ");
INSERT INTO rhg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kiyollahoile zara hãzi giyegoi hitarare talaš edde basaibolla Adomor Fut aišše.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ar zara Isar hota funnil hitarare Isaye šikka dibolla ekkan mesal kahani hoiye, kiyollahoile Isa zeṛe aššil hentu Zeruzalem beši dure nuwaššil. Ar mainše mone goijje Allar raijjo hara deha zaibo. ");
INSERT INTO rhg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Isaye hodde: \"Ek usol bongšor manuše razagiri firai anibo hoi ek duror dešot giye. ");
INSERT INTO rhg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ar hite hitar nizor došzon gulamore ḍaki fottizonore ekkan ekkan šunar mohor diyore hodde, 'Ãi zeto din foijjonto firi no aiyi, in diyore šodori goijjo.' ");
INSERT INTO rhg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","\"Kintu hitar dešor mainše hitare hingša goitto, hitara hitar fise manuš defeṛaiye endilla hoibolla, 'Ãra no sai, ei manušwa ãrar raza ok!' ");
INSERT INTO rhg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","\"Zen oibo ok, ei manušware raza banaiye edde hite górot uwafes firi aigiyegoi. Toi hite ze gulam okkolore ṭĩya dil, hitara šodorit hone hodun amodoni goijje hin saibolla he gulam okkolore hitar hãse ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","\"Toi foila ekzon ai hodde, 'Malik, tũwar ekkan šunar mohore aro doššan šunar mohor hamaiye.' ");
INSERT INTO rhg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","\"Razaye hitare hodde, 'Bala goijjos tui ãr bala gulam! Kiyollahoile tui oti šoṛo hamot o biššaš dehaiyos etolla doššan šohoror uwore šašon goribar kemota dilam.' ");
INSERT INTO rhg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","\"Toi dusora ekzon aišše edde hodde, 'Malik, tũwar šunar mohor loi aro fãssan mohor ãi hamaiyi.' ");
INSERT INTO rhg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","\"Toi razaye hitare hodde, 'Tore o fãssan šohoror uwore šašon goribar kemota dilam.' ");
INSERT INTO rhg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","\"Bade ar ekzone aiyore hodde, 'Malik, doro tũwar šunar mohorgan. Ãi iyan fakit nummalot bandi raki dilam. ");
INSERT INTO rhg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ãttu tũware ḍor laigge, kiyollahoile tui ekzon hora manuš, zin no rako hin tũi tuli lo, edde zin no lago hin haṛo.' ");
INSERT INTO rhg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","\"Hite hitare hodde, 'O horaf gulam, ãi tor mukor hota loi tor bisar goriyum. Tui to ãi hora manuš de zaniti, zin no raki hin ãi tuli edde zin no lagai hin ãi dai. ");
INSERT INTO rhg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Henoile ãr ṭĩya udar loyare kiya no dos, hen goriti buli ãi aile šudor fũwati hin uwafes adai gori faittam?' ");
INSERT INTO rhg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","\"Toi heṛe aro zara tiyai aššil hitarare hite hodde: 'Itar hãsottu šunar mohorgan loifelo edde zattu doššan mohor ase hitare iyan o do.' ");
INSERT INTO rhg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","\"Hitara hodde, 'Malik, hitattu de age loti doššan mohor ase!' ");
INSERT INTO rhg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","\"Malike hodde, 'Ãi tũwarare hoir, zattu ase, hitare aro diya zaibo, kintu zattu nai, hitattu asede hin o loifela oibo. ");
INSERT INTO rhg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tũwara zo! He dušmon okkol zara ãi raza oi no sa, hitarare eṛe ano edde ãr šaikkat hitarar holla lo.'\" ");
INSERT INTO rhg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ei šob hota hoi bade Isaye hitarar age age Zeruzalemor mikka uṛa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bade zẽtte Isa zaitun faharor ato hãse asede Betfage edde Betani farar hãsa hãsi oiye, hetunot hibaye duizon sahabire faṭai diye endilla hoi: ");
INSERT INTO rhg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","\"Oi sarmor farat zo, heṛe goli mottor ek gadar so banda dekiba, zibar uwore hono manuš hono din no boiye. Hiba kuli ãlla loi anogoi. ");
INSERT INTO rhg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Honokiye zodi hiba kiyolla kulor hoi fusar gore, toile endilla hoiba, 'Ibare malikottu dorhar oiye.'\" ");
INSERT INTO rhg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Toi zarare defeṛa oiye, hitara zai Isaye hoiyede mozin hár kissu deikke. ");
INSERT INTO rhg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hitara he gadar so zehon kuilto saiye, giros okkole hitarare fusar goijje, \"Tũwara gada sowa kiyolla kulor?\" ");
INSERT INTO rhg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hitara giros okkolore hodde, \"Iba malikottu dorhar ase.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tarfore sahabi okkole he gadar soware Isar hãse ainne. Toi hibar fiṛot hitarar hor bisai di, heṛe uwore Isare buwaiye. ");
INSERT INTO rhg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bade Isa zehon za šuru goijje, hẽtte manuš okkole hitarar nizor nizor hor okkolore rastat bisai diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ar Isa zehon Zaitun faharottu lamibar zagar hãsa hãsi fõissegai, hen šomot biššaši okkole ze šob kuduruti ham deikke, hin okkololla kušir sãte guzori guzori hitara beggune Allar tarif goijje. Hitara howa šuru goijje: ");
INSERT INTO rhg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","\"Rahamot he badšare, ze Malikor name aiyer!\" \"Behostot šanti ok ar Uwore Allar mohima ok!\" ");
INSERT INTO rhg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Manušor zamor butottu hoekzon forošiye Isare hodde, \"Huzur, õnor sahabi okkolore mana goro.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kintu Isaye hodde, \"Ai tũwarare hoir, itara zodi suf take, toile fattorgune guzori uṛibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Isaye Zeruzalemor hãsa hãsi fõssi šohoror uzu saiye edde hiyanolla sukor fani felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ar hodde, \"Tui aijja o zodi šanti kiye de hiyan buziti, kintu tui no buzor, ehon he šob tor sukor arguwale oi taikke. ");
INSERT INTO rhg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Endilla ṭaim aibo zẽtte tor dušmon okkole sairo mikkattu zonzal bandibo, tore giri doribo edde tore šomosto kunattu geruwa goribo. ");
INSERT INTO rhg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ar tore edde tor butoror šontan okkolore meṛi loi fišai felaibo, tor butore uggwa fattoror uwore fattor takito no dibo. Kiyollahoile Allaye tore basaito ze šuzug diye he šomoi tui sini no los.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tarfore Isaye dórmogórot góille edde heṛe zara besa kina goijjil hitarare henttu baire lorai diye. ");
INSERT INTO rhg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Isaye hitarare hodde, \"Leka ase: 'Ãr gór munazator gór oibo.' Kintu tũwara iyanore ḍahaiṭor aḍḍahana banai felaiyo.\" ");
INSERT INTO rhg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Isaye fotti din dórmogórot zai šikka dito. Ar ḍõr imam edde alem ar mainšor neta okkole Isare furai felaibolla kušiš goijje. ");
INSERT INTO rhg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kintu hitara ki bafe hen goribo he ufai tuwai no fa, kiyollahoile manuš beggune diyan di ekmone Isar hota fuinto. ");
INSERT INTO rhg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ek din Isaye dórmogórot manušzon okkolore šikka der edde bala hóbor tobolig gorer. Hen šomot ḍõr imam okkol, alem okkol edde bura murobbi okkol hitara beggune fũwati ai Isare hodde, ");
INSERT INTO rhg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","\"Ãrare ho, tũi har kemota loi in goror? Tũware ei kemota diye de hiba honnuwa?\" ");
INSERT INTO rhg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isaye hitarare hodde, \"Ãi o tũwarare ekkan hota suwal goijjum. Ãre ho: ");
INSERT INTO rhg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yahyar torikotor gusol, hiyan ki behostottu naki mainšottu?\" ");
INSERT INTO rhg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Toi hitara ekzone ekzon loi mošora gori hodde, \"Zodi hoi, 'Allaro torfottu,' hen oile hite hoibo, 'Toile tũwara Yahyare biššaš ka no goro?' ");
INSERT INTO rhg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ar zodi hoi, 'manušor torforttu,' toile mainše ãrare fattor maribo, kiyollahoile mainše Yahyare nobi mane.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hetolla hitara endilla zuwab diye, \"Ãra hoi no fari hontu.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Toi Isaye hodde, \"Toile ãi o ki kemotaye ei šob gorir hin tũwarare no hoiyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tarfore Isaye mainšore ei mesal kahanigan howa šuru goijje: \"Hono ekzon mainše ekkan ãngur keti goijje. Hiyan saša okkolore lagaiyore lamba ṭaimolla hite oinno dešot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ãnguror ainda zehon aišše, hite hitar gular bag loi anibolla ekzon gulamore oi saša okkolor hãse defeṛaiye. Kintu hitara he gulamware mar doir goijje edde hitare hali hate dũrai diye. ");
INSERT INTO rhg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bade malike ar ekzon gulamore defeṛaiye, kintu hitara hitare o mar dor gori edde ofoman gori hali hate bidai diye. ");
INSERT INTO rhg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hendilla hite tisera ekzon gulamore o defeṛaiye, kintu hitara hitare o mari reza reza gori baire felai diye. ");
INSERT INTO rhg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","\"Toi ãngur ketir giros hodde: 'Ãi ki goijjum? Ãi ãr adoijja fuware defeṛaiyum, oitofare hitara itare šorman goribo.' ");
INSERT INTO rhg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","\"Kintu saša okkole hitare deki ekzone ekzonore howa hoi goredde: Ite oilde mirazdar, aiyo, ãra itare mari felai, toi mirazgun ãrar oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bade hitara hitare ãngur ketor baire loi zai mari felaiye. \"Ãngur ketir girose hitarare loi ki goribo? ");
INSERT INTO rhg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hibaye zai ei saša okkolore furai felaibo edde ketigan oinno mainšor hatot dibo.\" Ei hota funi mainše hodde, \"Endilla no ok!\" ");
INSERT INTO rhg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kintu Isaye uzu hitarar mikka suk firaiyore hodde, \"Toile endilla ze leka ase hiyanor mani ki? \"'Ze fattor raz mistiri okkole batil goijje, hiba i beši dorhari fattor oi uiṭṭe!' ");
INSERT INTO rhg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","He fattoror uwore ze foribo, hite bangi ṭura ṭura oi zaiboi edde zar uwore he fattor foribo, hite guri oi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","He šomot alem okkol edde ḍõr imam okkole Isare doitto saiye, kiyollahoile hitara buzi faijjil ze, oi kahanigan hitarar berudde hoiyede. Kintu hitara mainšore ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hetolla hitara Isare suke suke raikke. Ar hitara Isare šašon goroya bisar šoktir hatot tuli di farefan hoekzon spai defeṛaiye. He spai okkole bed dori Isar sarme forhesgar boinne, zene hitara Isar hotattu Isare gollot dori fare. ");
INSERT INTO rhg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Toi hitara Isare fusar goredde, \"Huzur! Ãra zani, õne zin ho edde šikka do hin ṭik, õne honokiyor uzu ṭan no goro, kintu soiyi bafe Allar rastar babute šikka do. ");
INSERT INTO rhg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ãrare hosai, Romor badšare hazna diya iyan ãralla ṭik ki no?\" ");
INSERT INTO rhg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kintu Isaye hitarar salaki buzi fari hodde, \"Ãre ekkan rufar foiša deho. Eṛe har foṭo edde nam ase?\" ");
INSERT INTO rhg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Hitara hodde, \"Romor badšar\" ");
INSERT INTO rhg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Toi Isaye hitarare hodde: \"Toile zin zin badšar hin badšare do, ar zin zin Allar hin Allare do.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Henot hitara manušor sarme Isar hotat hono šer tuwai no fa, bolke hitara Isar zuwab funi tajjuf oiye edde suf gori taikke. ");
INSERT INTO rhg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hodun Sadduki dolor manuše Isar hãse aišše, zara hono uwafes zinda nai hoito. ");
INSERT INTO rhg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hitara Isare hodde, \"Huzur, Nobi Musaye ãralla leki giye, hono ekzonor bái zodi fuwain no owaite bouwore raki mori zagoi, toile hitar báiye he bouwore biya goribo, edde nizor báiyolla bongšo baraibo. ");
INSERT INTO rhg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ehon, hãt bái ase ek górot. He ḍõr báiye biya goijje, kintu fuwain no owaite mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hitar nisor ḍõr báiye hibare biya goijje, ");
INSERT INTO rhg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tarfore tisera zone edde hendilla hãtozone biya goijje. Hitara beggune fuwain no owaite no owaite mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Šeše he mayafuwawa o mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ehon, hitara zẽtte uwafes zinda oibo, hitarar butottu hiba har bou oibo? Hibarede hãtozone biya goijje.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isaye zuwabe hodde, \"Ei duniyair mainše biya gore edde biya difele. ");
INSERT INTO rhg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kintu zarare he duniyai edde mora okkolor butottu he uwafes zinda oibar laikka boli gona oiye, hitara biya o no gore ba biya o no de. ");
INSERT INTO rhg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kiyollahoile hitara ar mori no fare. Hitara firista okkolor ḍoilla. Hitara Allar góror fuwain, zarare morattu uwafes zinda gora oiye. ");
INSERT INTO rhg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kintu mora okkol uwafes uṛibode Musa nobir oin zoledde zongolor kahanit dehaiye, kiyollahoile Musa nobiye Mabudore, 'Ibrahimor Allah, Isakor Allah edde Yakubor Allah boli hoiye.' ");
INSERT INTO rhg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hiba mora okkololla Allah no kintu zinda okkololla, kiyollahoile Mabudor šaikkat hitara beggune zinda ase.\" ");
INSERT INTO rhg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hetunot hozon dórmiyo aleme hodde: \"Huzur, õne bala zuwab diyo!\" ");
INSERT INTO rhg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","He oite Sadduki dole ar hono hota suwal goitte šahoš no fa. ");
INSERT INTO rhg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Isaye hitarare hodde, \"Mainše ken goriyore Mosire Daudor fut hoi fare? ");
INSERT INTO rhg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daud nize Zobur kitabot hor: \"'Mabude ãr Malikore hodde: \"Ãr ḍen ḍakottu boi ");
INSERT INTO rhg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","zetodin ãi tor dušmon okkolore tor ṭengor tolat no raki.\"' ");
INSERT INTO rhg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Otoso Daude hibare 'Malik' ḍaker; toile hiba kengori hibar fut oi faribo?\" ");
INSERT INTO rhg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Manuš okkole funedde šomot, Isaye sahabi okkolore hodde, ");
INSERT INTO rhg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"Alem okkolottu hũšiyar! Hitara lamba lamba hor findi beraito sa edde haṛot bazarot mainšor solam muzolišhanar usol zagat edde mela šobar barik zagat buware foson gore. ");
INSERT INTO rhg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hitara rari okkolor gór dokol gore ar mainšore dehaibolla lamba gori duwa gore. Hendilla mainše bisarot aro beši šasti faibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bade Isaye suk tuli sadde, tuwangor manuš okkole dórmogóror dan bakšut hitarar nizor nizor sodka raker. ");
INSERT INTO rhg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ar o dekedde, ekzon gorib rari maya fuwaye o he bakšut duiyan foiša raikke. ");
INSERT INTO rhg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hetunot Isaye hodde, \"Ãi tũwarare soiyi hoir, ei gorib rari mayafuwawaye beggunottuwaro beši raikke. ");
INSERT INTO rhg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kiyollahoile itara beggune nizor beši šombottittu kissu kissu dan bakšut raikke, kintu hiba obafi oi bade o, hibattu foran basaibolla zin aššil hin beggun di felaiye.\" ");
INSERT INTO rhg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Heṛe biššaši okkolor butottu kiye kiye dórmogór babute hoil, hiyan ki šundor šundor fattore edde dan goijjede ziniš loi hãzaiya. Kintu Isaye hodde, ");
INSERT INTO rhg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","\"Tũwara ei šob zin dehor, en din aiyer ekkan fattor ar ekkan fattoror uwore no takibo, beggun bangi fela oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Toi hitara fusar goredde, \"Huzur, in hõtte oibode edde in okkol šuru oibode hẽtte sinno ki?\" ");
INSERT INTO rhg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isaye zuwab diye: \"Saiyo, hono dúhat forizorgoi ne! Kiyollahoile boute ãr namor bed dori aibo, hoibo, 'Ãi Mosi' edde 'šomoi hãse aišše.' Kintu hitarar fise tũwara no zaiyo. ");
INSERT INTO rhg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ar zẽtte tũwara larai edde gonḍugulor hota funiba, hẽtte no ḍoraiyo! Kiyollahoile in okkol hameka foila goṭibo, kintu hehon ze šeš iyan o no.\" ");
INSERT INTO rhg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bade Isaye hitarare hodde: \"Zatir bifokke zati edde raijjor bifokke raijjo tiyaibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ḍõr ḍõr busal oibo edde bout zagat raṭ edde bor biyaram okkol oibo. Ajib goṭona okkol goṭibo edde asmanot ḍor lagede hanḍo edde ḍõr sinno okkol deha oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","\"Kintu in goṭibar age manuš okkole tũwarare bondi goribo edde zulum goribo, sinagog edde ziyolot faṭaibo. Ar ãr namolla buli tũwarare raza edde šašon goroyar sarme ana oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hetunot tũwara ãr babute goba diya šuzug oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kintu tũwara ki zuwab diba hiyanolla agottu loti sinta no goribade hiyan ehon loti dilot yad rako. ");
INSERT INTO rhg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kiyollahoile ãi tũwarar mukot hota zuhai diyum edde giyan diyum, tũwarar bifokkor honokiye tũwarare baron otóba zuwab di no faribo. ");
INSERT INTO rhg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kintu en ki tũwarar bab ma, bái boin, egena fũwajja okkole tũwarare dušmonor hãtot tuli dibo. Ar tũwarar kiyore kiyore hitara mari felaibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mainše ãlla buli tũwarare hingša goribo. ");
INSERT INTO rhg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kintu tũwarar matar ekkan sul o dongšo no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tũwarar nizor sofore tũwarar nizor zibon furaiya faiba. ");
INSERT INTO rhg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","\"Ar zẽtte tũwara Zeruzalemore armiye geruwa goijja dekiba, hẽtte hiyan donšo oibar ṭaim hãse aišše de zaniba. ");
INSERT INTO rhg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hetunot zara Ehudiyat take, hitara fahari elehat dai zoggoi, ar zara šohorot take hitara baire dai zoggoi. Ar zara gang zagat take hitara šohorot no aiyok. ");
INSERT INTO rhg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kiyollahoile ehon oilde šazar ṭaim, kitabot ze šob hota leka ase hin furon oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Afsus! He šomot hamilwala mayafuwain edde dudor fuwawala mayafuwain okkololla, kiyollahoile dešot beši durgoti oibo edde ei zatir uwore Allar gozob lami aibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Manuš okkol toluwaror tole oi oi moribo edde bondi hisabe hár zatir heṛe loi za oibo. Zetodin Oihudi okkolor ṭaim šeš oi no zagoi hetodin foijjonto Zeruzalemore Oihudi okkole hitar ṭengor tole ḍolibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","\"Ar san surzo asmanor tara okkolot nanan ḍoilla sinno deha zaibo. Duniyait hár manuš okkole zontrona faibo. Doriyar goiror uzore hitara ḍore suhara oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Duniyait zin goṭibo hinor ḍore manušor foran sulor agat zaiboi, kiyollahoile san, surzo, tara okkol oulzoul oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ar he šomot hitara Adomor Futore ḍõr šokti edde mohima loi miyular butottu aiyedde dekibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ei hanḍo beggun šuru oile o tũwara uṛi tiyaiyo, matá tuillo, kiyollahoile tũwarar azadi hãse.\" ");
INSERT INTO rhg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ar Isaye hitarare ei mesal kahanigan hoiye: \"Ei ḍũir gaswa edde ar har gasor uzu so! ");
INSERT INTO rhg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Zehon hinottu noya fata fuṛe, hetunot tũwara hin sai hoi faro horan hal hãse aišše de. ");
INSERT INTO rhg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","He bafe tũwara o zẽtte ei šob oibode dekiba hẽtte zaniba Allar raijjo hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","\"Ãi tũwarare soiyi hoir, ze foijjonto in okkol furon no o, he foijjonto ei halor manuš okkolor mout no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Asman edde zobin šeš oibo, kintu ãr hota hono din šeš no oibo. ");
INSERT INTO rhg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","\"Hũšiyar tako edde tũwarar kolobore beši niša fani hafiyar folai loi edde šongšari sinta loi kobza gori no raikko, zen atikka he din fandor ḍoilla oi tũwarar uwore no fore gai. ");
INSERT INTO rhg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kiyollahoile he dingan duniyair hár manuš beggunor uwore foribo. ");
INSERT INTO rhg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kintu tũwara hamiša seton taikko, munazat goijjo, zene he šob zin goṭibo hin okkolottu dai zaigoi faribolla edde Adomor Futor sarme tiyai faribolla šokti fo.\" ");
INSERT INTO rhg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Isaye fotti din dórmogórot zai šikka dito edde fotti raitta hibaye hentu bair oi Zaitun faharot zai takitogoi. ");
INSERT INTO rhg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ar hár manuš okkol Isar hota funibolla kub binna sore dórmogórot zai Isar hãse hazir oito. ");
INSERT INTO rhg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","He šomot iš no diya ruṭir idor din hãse aišše, ze idore uddar id o howa za. ");
INSERT INTO rhg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ar dõr imam edde alem okkole ki bafe Isare mari felai fare hitara gufone he kušiš goijjil, kiyollahoile hitara manuš zonore ḍoraito. ");
INSERT INTO rhg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Toi Ehudah Iskariyot, oi barozon sahabir ekzon, hitar butore Šoitan góille. ");
INSERT INTO rhg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Toi hite ḍõr iman okkol edde dórmogór sõloya garḍ okkol loi dola oito giye edde kibafe Isare hitarar hatot tuli di faribo he babute mošora goijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Henot hitara kuši oiye edde hitare ṭĩya dibo wada diye. ");
INSERT INTO rhg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ar henot Ehudaye o razi oiye edde manuš okkolor nozor arguwale Isare hitarar hatot tuli dibolla šuzug tuwa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tarfore iš no diya ruṭir idor butore ze din uddar idor sool kurbani gora o, he din aišše. ");
INSERT INTO rhg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Toi Isaye Fitor edde Yuhannare hoi defeṛadde, \"Tũwara zo, uddar idor hána tiyar gorogoi, ãra uddar idor hána háiyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hitara hodde, \"Hoṛe tiyar goijjum? Tũwar issa ki?\" ");
INSERT INTO rhg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Isaye hitarare hodde, \"Tũwara šohorot golile ekzon manuše ek gora fani boi loi zadde lot faiba. Tũwara hitar fise fise, hite ze górot golibo, heṛe zaiba. ");
INSERT INTO rhg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ar he góror malikore hoiba, 'Huzure fusar goijje, gorba gór hoṛe, zeṛe ãi ãr šahabi okkolore loi uddar idor hána hái fari?' ");
INSERT INTO rhg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Henot hite tũwarare ekkan šaz guz goijja dui ṭalar uwore ekkan ḍõr kamera dehai dibo. Heṛe zai tũwara hána gorogoi.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hitara baisa diye edde Isaye zendilla hoil, he mozin lot faiye, ar hitara uddar idor hána tiyar goijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bade ṭaim mozin Isaye asab okkolore loi haito boišše. ");
INSERT INTO rhg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hetunot Isaye hitarare hodde, \"Ãi duk šoibar age tũwarar fũwati ei uddar idor hána háiyum, ãi kub issa goijji. ");
INSERT INTO rhg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ãi tũwarare hoir, ze foijjonto Allar raijjo furon no o, ãi ar honokon ei idor hána na háiyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bade Isaye fiyala loiye, šukuriya zanaiye edde hodde, \"Lo in, tũwarar maze bag gori lo. ");
INSERT INTO rhg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kiyollahoile ãi tũwarare hoir, ze foijjonto Allar raijjo no aiye, ehon oite he foijjonto ãi ãnguror roš ar no fiyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bade Isaye ruṭi loi šukuriya zanaiye edde hin bangi ṭura ṭura gori asab okkolore diyore hodde, \"In ãr ga, ziyan tũwaralla diya oiye. Ãre monot goribolla endilla goijjo.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ar ekkui bafe, Isaye hána šeš oi bade fiyalawa hãtot loi hodde, \"Ei fiyala ãr louwor noya wadar sukti, ze lou tũwaralla ḍali diya oiye. ");
INSERT INTO rhg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kintu so, ze ãlloi beimani goribo, hite ãr fũwati hána hár. ");
INSERT INTO rhg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kiyollahoile zendilla faisala gori raikke, he bafe Adomor Fut zar. Kintu bifod hitar, ze Adomor Fut loi beimani gorer.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hetunot asab okkole ekzone ekzon loi fusar gora šuru goijje ze hitarar butore endilla ham hone goribo. ");
INSERT INTO rhg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ar asab okkolor butore hone hokkolottuwaro ḍõr hin loi hitara hota haṛa haṛi goijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Hetunot Isaye hitarare hodde, \"Oihudi dešor raza okkolena hitarar mainšor uwore munifgiri deha. Ar hitara zonogonor dusto boli o ho. ");
INSERT INTO rhg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kintu tũwara hendilla no oiyo. Bolke tũwarar butore ze beggunottuwaro ḍõr hite beggunottuwaro šoṛor ḍoilla ok. Ar ze neta hite šeba goroyar ḍoilla ok. ");
INSERT INTO rhg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kiyollahoile hone ḍõr? Ki ze hánar ṭebilot haito boiye, hite, naki ze gulame hána baride, hite? Ze hánar ṭebilot haito boiye, hite no ne! Kintu ãi tũwarar maze šeba goroyar ḍoilla oi roiyi. ");
INSERT INTO rhg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Funo! Tũwara ãr har bola mosibot okkolot maze ãr fũwati roiyo. ");
INSERT INTO rhg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ar ãr Bafe zendilla ãre šašon kemota diye, hendilla ãi o tũwara ekkan raijjo diyi. ");
INSERT INTO rhg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Zene tũwara ãr raijjot ãr mezot boi há fiya gori faro. Ar tũwara šingašonot boi Israilor baro bongšor bisar goriba. ");
INSERT INTO rhg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","\"Simon, Simon, sa! Šoitane tũwara beggunore gĩyur dana salefan salibolla dabi gorer. ");
INSERT INTO rhg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kintu ãi tolla duwa gorir, zene tor iman komzur no o. Tui abar zẽtte ãr hãse firi aibi hẽtte tor báiyaindore tui tuwajjo dis.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Fitore Isare hodde, \"Malik, õnor fũwati ãi ziyolot zaibolla edde moribolla o razi asi.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isaye zuwabe hodde, \"Fitor, ãi tore hoir, aijja rata kuraye bak no dite, tui ãre no sinos hoi tin bar ošikar goribi.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tarfore Isaye sahabi okkolore fusar goredde: \"Ãi zẽtte tũwarare ṭiyar toli, gaṭṭi edde zuta in hono kissu sara defeṛailam, tũwarattu ki hẽtte hono kissur obaf oil ne?\" Hitara hodde, \"Na, no o.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hetunot Isaye hodde, \"Kintu ehon zattu ṭiyar toli ase, te hin lok, ekkui bafe gaṭṭi o lok. Zattu toluwar nai hite hitar kuruta besi ekkan toluwar kinok. ");
INSERT INTO rhg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kiyollahoile ãi tũwarare hoir, pak kalamot ze leka ase: 'Adomor Futore naforman okkolor fũwati gona oiye,' hendilla ãr duwara furon oibo. Kiyollahoile ãr babute zin howa oiye, hin furon or.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hetunot sahabi okkole hodde, \"Malik, so, eṛe duiyan toluwar ase.\" Isaye hitarare hodde, \"Oiye oiye!\" ");
INSERT INTO rhg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bade Isaye niyoli zai nizor rosom mozin zaitun faharor mikka fõt bai za šuru goijje. Ar fũwati sahabi okkol o fise fise giye. ");
INSERT INTO rhg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Isa heṛe fõsi bade sahabi okkolore hodde, \"Tũwara duwa goro, zene tũwara forikkat no foro.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bade Isaye hitarattuwaro hom beši ek dolar fõtot giye edde ãṛu feli munazat gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Munazatot hodde, \"Ya, Baf, zodi tũi so, ãr hãsottu ei motor fiyala dur goro. Tarfore o ãr issaye no, tũwar issaye furon ok.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hetunot behostottu ekzon firista aiyore Isare šokti diye. ");
INSERT INTO rhg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Toi Isaye moron hoštoye mogno oi aro issa zuge munazat goijje. Ar Isar gar gám zen lour fuṛar ḍoilla oi meṛit fora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Isaye munazat gori uṛi bade sahabi okkolor hãse aišše, ar dekedde hitarare, monor dukkor zoriya gumot fori giyoi. ");
INSERT INTO rhg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Toi Isaye hitarare hodde, \"Gum zor kiyolla? Uṛo, forikkat no forofan duwa goro.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Isaye hota howat roiye, hen šomot so, heṛe ek ḍõr mainšor dol aišše. Ehudah, ze barozon sahabir ekzon, hite o hitarar fũwati age age aišše. Ehudaye Isare suma diyore dehai dibolla Isar hãse giye. ");
INSERT INTO rhg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kintu Isaye Ehudare hodde: \"Ehudah, sumar duwara ki Adomor Futore dori dor?\" ");
INSERT INTO rhg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Isar fũwati zara aššil hitara ki ki goṭibo hin buzi fariyore Isare fusar goredde: \"Malik, ãra ki suri loi hamela goriyum?\" ");
INSERT INTO rhg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ar hitarar butottu ekzone, ek ḍõr imamor gulamore hamela gori hitar ḍen han haṛi loi felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kintu Isaye hodde, \"Tam, ar hen no goris!\" Bade Isaye hitar han suiyore hitare bala gori diye. ");
INSERT INTO rhg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Isare doribolla ze ḍõr imam okkol, dórmogór sõloya garḍ okkol edde murubbi okkol aišše. Isaye hitarare hodde, \"Ãi ki ḍahait ze tũwara laṛi sura, toluwar loi aiššo? ");
INSERT INTO rhg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ãi zẽtte fotti din dórmogórot tũwarar fũwati aššilam, hẽtte to ãr uwore tũwara hat o no tulo. Kintu ehon tũwarar šomoi, andaror razotto soler.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Toi hitara Isare dori loi giyegoi edde Isare ḍõr imamor górot ainne. Ar Fitor o dure taki hitarar fise fise giye. ");
INSERT INTO rhg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bade manuš okkol zara uṛanot oinor ṭal zali boišše hitarar fũwati Fitor o boišše. ");
INSERT INTO rhg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Heṛe oinor ṭalor forot Fitor boiššede ek bandi maya fuwaye deki hitar mikka suk firai hodde, \"Ei manušwa o utar fũwati aššil.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kintu Fitore ošikar gori hodde, \"He maya fuwa, ãi hitare no sini.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ekkena gori bade ar ekzone Fitorore deki hodde, \"Tui o to hitarar ekzon.\" Fitore hodde, \"Na, ãi no.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Gonḍa anik bade ar ekzone zure hodde, \"Soiyi, ei manušwa o hitar fũwati aššil, kiyollahoile ite o Galil elehar manuš.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hetunot Fitore hodde, \"No, tui ki hor ãi buzi no farir.\" Fitore hen hoiya šeš no oite uggwa rata kuraye bak di uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hetunot Malik Isaye Fitoror mikka muk firai saiye. Henot Isaye ze hota hoil: \"Aijja ratakuraye bak no dite, tui ãre no sinos hoi tinbar ošikar goribi,\" hiyan Fitorottu monot foijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hetunot Fitore baire zai kub hainde. ");
INSERT INTO rhg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ar Isare sõi roiyede manuš okkole Isare loi ṭaṭṭa goijje edde maijje. ");
INSERT INTO rhg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Hitara Isar suk bandi Isattu fusar goredde, \"Tui zodi nobi oi takos toile ho sai, tore hone maijje?\" ");
INSERT INTO rhg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ar hitara ingša gori Isar berudde aro bout hota okkol hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Din zehon oiye, Ihudi dórmo komitir murubbi okkol, ḍõr imam okkol edde alem okkol beggune ekkui fũwati dola oiye. Toi Isare hitarar munttu ana oiye ");
INSERT INTO rhg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","edde hodde, \"Tui zodi he Mosi, toile ãrare ho!\" Isaye hitarare hodde, \"Zodi ãi tũwarare hoi, tũwara biššaš no goriba. ");
INSERT INTO rhg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ar zodi tũwarare fusar gori, hono zuwab no diba. ");
INSERT INTO rhg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kintu ehonottu loti Adomor Fut šoktiwala Allar ḍen ḍakottu boiṛa takibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hetunot hitara beggune fusar goredde, \"Toile ki tui Allar Fut?\" Isaye hitarare zuwab diye, \"Tũwara hor ze, Ãi Hiba.\" ");
INSERT INTO rhg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Toi hitara hodde, \"Ãrattu ar gobar ki dorhar? Ãra beggune hitar nizor mukottu funilam.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bade hitara dol šoho beggune uṛi Isare Rom šašok Filator hãse loigiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ar hitara Isar berudde en hoi nališ goijje, \"Ãra dekki ei manušwaye ãrar zatire kufõtot loi zargoi. Romor badšare hazna no dibolla mainšore mana gorer, ar nizore Mosi edde badša dabi gorer.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Toi Filate Isare fusar goredde, \"Tui ki Ihudi okkolor badša?\" Isaye Filatore zuwabe hodde, \"Tũi ze hor.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Toi Filate ḍõr imam okkolore edde manušor dolore hodde, \"Ãi ei manušwar hono hosuri no fair.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kintu hitara zid gori howa šuru goijje, \"Ehudiya elehar har zaga okkolot šikka di di ite manuš okkolore gonḍogul bazaider. Ite in Galilottu loti šuru goijje, ar ehon eṛe aišše.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ei hota funi, Filate manušwa Galilor ne ki hoi fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Isa badša Herudor šašonor tole asede zani fari Filate Isare Herudor hãse faṭai diye. Ar he šomot Herud Zeruzalemot aššil. ");
INSERT INTO rhg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Badša Herude Isare deki beša beši kuši oiye, kiyollahoile hite Isar babute bout hota funnil, ar bout din dori hite Isare saibolla issa gori aššil. Ar Herude aša goijje Isaye hono keramot gori dehaibo. ");
INSERT INTO rhg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herude Isattu bout suwal okkol fusar goijje, kintu Isaye hitare hono zuwab no de. ");
INSERT INTO rhg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ar ḍõr imam edde alem okkol tiyaiyore Isare beši hosuri diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Toi Herud edde hitar šena okkole o Isare ofoman goijje edde ṭaṭṭa goijje. Toi Herude Isare raz fušak findai abar Filator hãse faṭai diye. ");
INSERT INTO rhg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hedin Herud edde Filat hitara ekzon loi ekzon dusto oi giyegoi, hiyar age hitarar butore dušmonai baf aššil. ");
INSERT INTO rhg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tarfore Filate ḍõr iman okkol, neta okkol edde manuš okkolore ekkui fũwati ḍaki, ");
INSERT INTO rhg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","hitarare hodde, \"Tũwara itare ãr hãse ainno edde hoiyo, ei manušwaye manuš okkolore kufõtot loizar. Ar so, ãi tũwarar šaikkat bisar gorile o, tũwara hitar uwore ze šob duš okkol dor, hinor butore ei manušwar hono hosuri no fair. ");
INSERT INTO rhg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ar Herude o no fa. Hetolla Herude itare ãr hãse uwafes faṭaiyede. Ar so, ei manušwaye moron šaza faibar laikka o kissu no gore. ");
INSERT INTO rhg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hetolla ãi hitare šasti diyore eri diyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Filate ei šob hota hoiyede haron oilde he idor ṭaimot hitaralla ekzonore eridiya oito.) ");
INSERT INTO rhg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kintu hitara dol šoho beggune uzor diyore hodde, \"Itare dur goro, ãralla Barabbasore sari do.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ei Barabbas zare šohoror maze danga edde kunor harone ziyolot bondi gori raka oiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Deš šasiyot goroya Filate Isare eri dito saiye hetolla abar hite mainšor dolor hãse zanaiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kintu manuš okkole guzori hodde, \"Itare kurušot do! Kurušot do! Itare mari felo!\" ");
INSERT INTO rhg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Filate tin mottor barot hodde, \"Kiyolla? Ite hosuri ki goijje? Ãi hitare šazaye mout dibar hono hosuri no dekir, hetolla ãi itare šasti di eri diyum.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kintu Isare kurušot diya oibolla hitara zid gori beši uzor diya šuru goijje. Toi hitarar uzor kamiyaf oiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Filate hitarar issa mozin goribar hokum di felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Danga edde kungorar harone ze Barabbasore ziyolot raka oil, hitara hitare saiye. Toi Filate hitare hitaralla eri diye, kintu Isare mari felaibolla tuli diye. Hitarar issa furon oiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tarfore hitara Isare loi zadde šomot Šimon name ekzon Kuronir manuš farar butottu di aiššil. Hitara Isar fise fise kuruš boi loi zaibolla he manušwar handot kuruš tuli diye. ");
INSERT INTO rhg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ar bout mainšor dol okkol fise fise giye. Hitarar butore bout mayafuwain okkol aššil, zara Isalla bilag gorer edde šuk tuli hander. ");
INSERT INTO rhg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kintu Isaye hitarar mikka firiyore hodde, \"O Zeruzalemor hoinna okkol, ãlla no haindo, bolke nizolla edde nizor nizor fuwaindolla hando. ");
INSERT INTO rhg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kiyollahoile so en šomoi aiyer zẽtte tũwara hoiba, 'Šuki he bázá mayafuwain okkol, zarar udore hono fuwain no owa, zarar buke hono din dud no de!' ");
INSERT INTO rhg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","He šomot \"'manuš okkole faharore hoibo, \"Ãrar uwore for!\" Ar mura okkolore hoibo, \"Ãrare guri rak!\"' ");
INSERT INTO rhg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kiyollahoile mainše hail gasor uwore zodi en gore, toile fuwana gasor uwore ki no goṭibo?\" ");
INSERT INTO rhg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aro dusora duizon ašami manušore o Isar fũwati mari felaibolla loi za oiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hitara Matakuli name ek zagat fõsi bade heṛe šena okkole Isa edde he duizon ašamire kurušot loṭkaiye, ekzonore Isar ḍen ḍake ar ekzonore bam ḍake gori. ");
INSERT INTO rhg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hetunot Isaye Allare hodde: \"Ya Bab, itarare maf goro, kiyollahoile itara ki gorer hin itara no zane.\" Bade šena okkole Isar horgunore loṭari kelai bag goijje. ");
INSERT INTO rhg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Manuš okkole tiyai sai taikke, kintu Ihudi neta okkole Isare loi ṭaṭṭa goijje edde hodde: \"Ite oinno manuš okkolore basaito, zodi hite Allar he Mosi, Allar basai gora, toile ehon hite nizore basaok.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ar šena okkole Isare horor roš dito saiye edde hitara ṭaṭṭa gori hodde, ");
INSERT INTO rhg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","\"Tui zodi Ihudi okkolor badša os, toile nizore basa.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ar Isar matar uwore ekkan sainboṛot mari diya aššil ziyanot leka ase: \"Iba Ihudi okkolor badša.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ar ze duizon hosurbonore kurušot ṭaikke, hitarar butore ekzone ṭiṭkari di Isare hodde, \"Tui Mosi no ne? Tui nizore edde ãrare basasena!\" ");
INSERT INTO rhg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kintu ar ekzon ze ase hite itare zejjeṛai hodde, \"Tui šaza for, to ki Allare o boi no goros? ");
INSERT INTO rhg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ãra usit šaza fair, zin goijji hinor fól hisabe. Kintu Isayede hono kuham no gore.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tarfore hite Isare hodde, \"Huzur Isa, õne zẽtte nizor raijjot oiba hẽtte ãre monot raikko.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isaye hitare hodde, \"Ãi tore soiyi hoir, aijja tui ãr fũwati zonnotot oibi.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hẽtte šomoi onumanik dũjja, beilore ganda doijje. Ar šara deš tin gonḍa mula andar oi taikke. ");
INSERT INTO rhg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","dórmogóror forodagan uwottu loti siri dui bag oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isaye guzori hodde: \"Oh Baf, ãi tũwar hatot ãr ruh tuli dilam.\" Ei hota hoi bade Isaye hibar šeš niyaš felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ei šob hanḍo deki ekzon Romor šenar boroye Allare tarif gori hodde, \"Hãsa ei manušwa soiyi aššil.\" ");
INSERT INTO rhg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ar ze šomosto manuš okkole ei hanḍo saibolla zoma oiye, hitara zin zin goiṭṭe hin okkol deki buk bajjai bajjai henttu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ar Isar sin foriso zara edde ze mayafuwain okkol Isar fũwati Galilottu aišše, hitara šoho beggune dure tiyai in okkol saiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ar heṛe Yusuf name ekzon manuš aššil, dórmo komitir ekzon ze bala edde soiyi. ");
INSERT INTO rhg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Komitir mainše hormo hanḍo, solla mošora zin Isar babute goijje hinot ei manušwaye razi oi no fare. hiba aššilde Ehudiyar Arimatiya farar manuš. Hibaye Allar raijjolla boi aššil. ");
INSERT INTO rhg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hiba Filator hãse zaiyore Isar lašwalla saiye. ");
INSERT INTO rhg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bade laš lamai kafonor hoor berai di fattorot kuinda, en ek hoborot raikkegoi, zeṛe honokiyore age heṛe raka no o. ");
INSERT INTO rhg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","He din dórmo dinor tiyarir din, dórmor din onumanik šuru oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Isar fũwati ze mayafuwain okkol Galilottu aiššil hitara Yusufor kure kure zai he hobor edde ki bafe Isar laš raka oiye hin saiyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bade hitara firi giye edde kušbo mollom edde tel banaiye. Tarfore dórmor din Musar ain mozin hitara ziraiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Haftar foila dinot, binna kub sore, mayafuwain okkole hoboror hãse aišše, ze mosolla hin loi ");
INSERT INTO rhg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Heṛe hitara dekedde hoboror mukor fattorgan algaiya. ");
INSERT INTO rhg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ar hitara hoboror butore zai sadde Malik Isar laš heṛe nai. ");
INSERT INTO rhg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hitara ammuwak oi ei befare bafedde šomot, so, ujjol fušak finda duizon manuš hitarar ḍake ai tiyaiyegai. ");
INSERT INTO rhg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Henot he mayafuwain okkole ḍore meṛir uzu matá nise gori taikke. He duizone hodde, \"Tũwara morar butore zindare kiyolla tuwor? ");
INSERT INTO rhg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hiba eṛe nai, hiba uṛi giyoi. Galilot takite Isaye tũwarare ki hoil hin monot goro. ");
INSERT INTO rhg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hibaye endilla hoilde no ne, 'Adomor Futore gunagaror hatot tuli diya oibo edde kurušot diya oibo. Ar tin dinor din hiba abar uṛi zaiboi.'\" ");
INSERT INTO rhg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hetunot Isar hota hitarattu monot foijje. ");
INSERT INTO rhg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Toi hitara hoborottu firi giyegoi edde he egarozon asab edde aro oinno beggunore ei hota zanaiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","He mayafuwain okkolor butore aššilde hitara oilde: Mogdaleni Moriyam, Joanna, edde Yakubor ma Moriyam. Ar hitarar fũwati oinno mayafuwain okkol edde aro zara aššil, hitara beggune asab okkolore ei šob hota hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kintu zara ei šob hota fuinne hitarattu hin baze hota hoiye fan laigge. Hitara mayafuwaindor hotare biššaš no gore. ");
INSERT INTO rhg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tarfore o Fitore uṛi hoboror mikka dũr diye, ar heṛe zai holla niyuri sadde šude hor fori roiye. Ar zin goiṭṭe, hinot hite tajjuf oi he zagattu firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ar so, hedin duizon sahabi Zeruzalemottu hãt mail dure Emmaus name ek farat zadde šomot, ");
INSERT INTO rhg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","hitara oi šomosto goṭonar babute hotabattara hor. ");
INSERT INTO rhg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hitara hotabattara hor edde fusar asar goredde hen šomot maze Isaye nize ai hitarar fũwati ãṛa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kintu hitarar suk zen bon oi giyegoi, hetolla Isare hitara sini no fare. ");
INSERT INTO rhg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isaye hitarare hodde, \"Tũwara ãṛat maze ekzonore ekzone ze šob hota howa hoi goror, hin ki?\" Hitara nak muk hala gori tiyai roiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bade zar nam Kleofas, hite hodde, \"Tũi šude ekzon Zeruzalemot zoya oibo, ei hodinor butore heṛe ze goṭona okkol oiye hin no zanode.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isaye hitarare hodde, \"Ki goṭṭiyede?\" Hitara hodde, \"In Nasarator Isar babute goṭona, ze Allah edde har mainšor šaikkat hotaye edde hame ek ḍõr kemotawala nobi aššil. ");
INSERT INTO rhg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kintu ken gori ḍõr imam edde ãrar dórmo komiṭir neta okkole moron šaza dibolla tuli diye edde kurušot mari felaiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ãra aša goijjilam iba hiba, zibaye Israil zatire azad goribo. Ar hin bade o, aijja tin din oiye in okkol goiṭṭede. ");
INSERT INTO rhg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ar ãrar hozon mayafuwainde o ãrare tajjuf goijje, hitara binna kub sore Isar hoborot giye. ");
INSERT INTO rhg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Hitara Isar lašor deha no fa. Ar hitara henttu firi ai zaigoi bade ãrare hoiye, hitara ze firistar okkolor deha fail hitara Isa zinda ase buli hoiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ar ãrar fũwajja okkolor butottu kiye kiye hoboror hãse zai, he mayafuwainde zen hoiye, hendilla zasai goijjegoi, kintu hitara o Isare no deke.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hetunot Isaye hitarare hodde: \"Tũwara hoto bekub! Ar nobi okkole ze šomosto hota hoiye, hin beggun biššaš goitte hoto durbol! ");
INSERT INTO rhg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mosiye ei šob duk bug gori nizor šanot golibolla hin gora ki zorulot no ne?\" ");
INSERT INTO rhg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tarfore Isaye Musar ain edde šomosto nobi okkolor kitabottu šuru gori har kitabot hiba nizor babute ze šob leka ase, hin okkol hitarare buzai diye. ");
INSERT INTO rhg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tarfore hitara zeṛe zar he farar hãsa hãsi fõssiyegai. Toi Isaye aro dure zaibar alamot dehaiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kintu hitara hoisali gori hodde, \"Ehon din to giyegoi, hãz oi giyegoi, õne ãrar fũwati tako.\" Henot Isa hitarar fũwati takibolla górot góille. ");
INSERT INTO rhg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tarfore Isa zehon hitarar fũwati hána haito boišše, hetunot Isaye ruṭi loi duwa goijje edde hin bangi hitarare diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hetunot hitarar suk kuli giyegoi, hitara Isare sini faijje. Kintu Isa hitarar hentu gayeb oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Toi hitara ekzonore ekzone hodde, \"Isaye ãra loi fõtot maze hota hoiyede he ṭaimot edde ãrar hãse Pak kitabor mani kuli diyede hẽtte ãrar dilor butore zoli zoli no uṛe ne?\" ");
INSERT INTO rhg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ar hitara hehon uṛi Zeruzalem firi giye. Toi he egarozon asab edde hitarar fũwajja okkol beggune zomula oiya deha faiye, ");
INSERT INTO rhg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ar hitara en hodde fuinne, \"Malik hameka uṛi giyegoi, Simonore deha diye.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bade itara duizone o fõtor goṭonar babute edde ruṭi bangibar šomot hitara ki bafe Isare sini faijje, he šob hota hitara beggunore funaiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hitara ekzone ekzon loi howa hoi goredde šomot Isa nize ai hitarar maze tiyaiyegai. Hitarare hodde, \"Tũwarar šanti ok.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Henot hitara ḍore somki uiṭṭe. Ar hitara but dekere buli mone goijje. ");
INSERT INTO rhg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Isaye hitarare hodde, \"Tũwara ḍoror kiyolla? Tũwarar dilot andaša ka anor? ");
INSERT INTO rhg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ãr hat ṭengor uzu so, so iba šoyong ãi. Ãre sui so, so ãre, butottu lou gusto no take zendilla ãttu asede dehor.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ei hota hoi Isaye hitarare hat, ṭeng dehaiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Toi hitara eto kuši oiye, biššaš gori no fajjil ebbe ammuwak oi giyegoi. Toi Isaye hitarare hodde, \"Tũwarar hãse eṛe hono kissu háibolla ase ne?\" ");
INSERT INTO rhg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Toi hitara Isare ekkan baijja mas diye. ");
INSERT INTO rhg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ar Isaye hiba loi hitarar šaikkat háiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tarfore Isaye hitarare hodde, \"Ãi tũwarar fũwati takite zin hoilam, he hota oilde endilla: Musar ain, nobi okkolor kitabot edde Zobur šorifot ãr babute ze hota leka ase hin hameka furon oibo.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hetunot Isaye hitarar dil kuli diye zene hitara Pak kitabor kalam okkol buzi fare. ");
INSERT INTO rhg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Toi Isaye hitarare hodde: \"Endilla leka ase ze: Mosittu toziya fa foribo edde tin dinor din hiba morattu uṛibo. ");
INSERT INTO rhg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ar hibar name guna maf faibolla edde mon firaibar hóbor hokkol zatir hãse tobolig gora oibo. In Zeruzalemottu šuru oibo. ");
INSERT INTO rhg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tũwara in okkolor goba. ");
INSERT INTO rhg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","So, ãr Bafe ze wada goijje he wadare ãi tũwarar hãse defeṛaiyum. Ar behostottu šokti no fo foijjonto tũwara ei šohorot taikko.\" ");
INSERT INTO rhg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bade Isaye sahabi okkolore Betaniya foijjonto loigiye edde hitarare hat tuli duwa diye. ");
INSERT INTO rhg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Toi endilla oiye, hibaye hitarare duwa gorat maze hitarattu alok oi giyegoi, edde hibare asmanot tuli loi za oiye. ");
INSERT INTO rhg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ar sahabi okkole hibare sojida goijje edde beši kuši oiyore Zeruzalem firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Toi hitara hamiša dórmogórot taki Allare šukurana guzar gorat taikke.");
INSERT INTO rhg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Šurut Kalam aššil, Kalam Allar fũwati aššil edde Kalam nize Allah aššil. ");
INSERT INTO rhg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hiba šurut Allar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hár kissu hibar duwara oiye, ar zin oiye, hinor ekkano hibare sara no o. ");
INSERT INTO rhg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hibattu zibon aššil, edde he zibon aššilde manušor nur. ");
INSERT INTO rhg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ar he nur andarot zoler, edde andare nurore loi ziti no fare. ");
INSERT INTO rhg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Heṛe ekzon manuš hazir oil, hibare Allar torfottu defeṛa oil, hibar nam oilde Yahya. ");
INSERT INTO rhg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hibaye goba dito aiššil, zene hibaye Nuror babute goba de, toi zene hibar duwara beggune biššaš gore. ");
INSERT INTO rhg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hiba nize he nur nu aššil, kintu hibaye šude he nuror babute goba dito aiššil. ");
INSERT INTO rhg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hiba oilde asol nur, ze fotti manušore nur dan gore, hiba duniyait aišše. ");
INSERT INTO rhg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ei duniyait hiba aššil, edde duniyai hibar duwara oiye, to duniyair mainše hibare no sine. ");
INSERT INTO rhg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hiba nizor dešor aiššil, kintu hibar nizor mainše hibare no gose. ");
INSERT INTO rhg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tarfore o zeto zone hibare goisse, zara hibar namore biššaš goijje, hitara fottikiyore hibaye Allar fuwain oibar odihar diye. ");
INSERT INTO rhg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hitara louwottu no, gustottu no, manušor issaye o no o, kintu Allattu oiye. ");
INSERT INTO rhg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","He Kalam manušor ruf loiye edde ãrar fũwati bošobaš goijje. Bafor hãsottu aiššede šude lehar ek Fut, hibar ze mohima, he mohima ãra dekki, hiba doya edde soyiye furaiya. ");
INSERT INTO rhg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(Yahyaye hibar babute goba diye, ar guzori hodde, \"Iba hiba zar babute ãi hoilam, 'Hiba ze ãi bade aiyer hiba ãttuwaro mohan, kiyollahoile hiba ãr age loti ase.'\") ");
INSERT INTO rhg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hibar he furaiyattu ãra beggune doyar uwore doya faiyi. ");
INSERT INTO rhg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kiyollahoile Musar duwara ain diya oil; Isa Mosir duwara doya edde soiyi aišše. ");
INSERT INTO rhg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Allare honokiye hono din no deke, kintu lehar he Fut, ze nize Allah, edde ze bafor beša beši hãse ase, hibaye hibare forhaš goijje. ");
INSERT INTO rhg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ar iyan oilde Yahyar goba, zẽtte Ihudi neta okkole Zeruzalemottu hoekzon imam edde levire Yahyar hãse hiba honnuwa fusar goitto defeṛail. ");
INSERT INTO rhg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ar hibaye šikar goijje, ošikar no gore, bolke šikar goijje, \"Ãi Messiyah no.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hitara hibare fusar goijje, \"Toile tũi honnuwa? Tũi ki Eliyas?\" Hibaye hodde, \"Ãi no.\" \"Toile tũi ki he Nobi?\" Hibaye zuwabe hodde, \"No.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hetunot hitara hibare hodde, \"Toile tũi honnuwa? Ãrare ho, zara ãrare defeṛaiye, hitarare zene ãra zuwab di fari. Tũi tũwar nizor babute ki ho?\" ");
INSERT INTO rhg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hibaye hodde, \"Ãi, bošoti sara elehat ek abaze guzori zanai der, 'Mabudolla fõt ṭik goro.'\" zendilla Esaiyah nobiye hoiye. ");
INSERT INTO rhg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Toi defeṛa oiyede Foroši okkole, ");
INSERT INTO rhg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","hitara hibattu fusar goijje, \"Tũi zodi Messiyah o no oile, Eliyas o no oile, otóba he Nobi o no oile, toile kiyolla tũi torikotor gusol dor?\" ");
INSERT INTO rhg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahyaye zuwabe hodde, \"Ãi fani loi torikotor gusol dir, kintu tũwarar butore ekzon tiyai roiye, zare tũwara no sino. ");
INSERT INTO rhg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iba hiba ze ãi bade aiyer, hibar ṭengor zutar fita kuli dibar laikka o ãi no.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Zordanor oinno faror Betaniyat, zeṛe Yahya torikotor gusol dil, heṛe in okkol goiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tarfordin Yahyaye Isare hibar mikka aiyedde dekiyore hodde, \"So, Allar berasoolor so, ze duniyair guna boi loizargoi! ");
INSERT INTO rhg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iba oilde hiba zar babute ãi hoilam, 'Ãi bade en ekzon manuš aiyer ze ãttuwaro mohan, kiyollahoile hiba ãr age loti ase.' ");
INSERT INTO rhg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ãi nize hibare no sinitam, kintu hiba zene Israili okkolor hãse forhaš o, hiyanolla ãi aiyore fanit torikotor gusol dir.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ar Yahyaye endilla goba diye, hodde: \"Ãi dekki Ruh hoitoror ḍoilla oi asmanottu lami aiyedde, ar hiba hibar uwore roiye. ");
INSERT INTO rhg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ãi nize hibare no sinitam, kintu ze ãre fanit torikotor gusol dito defeṛaiye hibaye ãre hoiye, 'Zar uwore Pak Ruh lami aiyer edde hibar uwore roiyede dekibi, iba oilde hiba ze Pak Ruh loi torikotor gusol dibo.' ");
INSERT INTO rhg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ãi hen dekki edde goba dir ze, hiba oilde Allar Fut.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tarfordin, abar Yahyaye hibar duizon šagiritore fũwati loi heṛe tiyai aššil. ");
INSERT INTO rhg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ar Isa aṛi zadde dekiyore hibaye hodde, \"So, Allar berasoolor so!\" ");
INSERT INTO rhg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ei hota hodde šagirit dunizone funiyore hitara Isar fise fise za šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isaye fissa fijje edde dekedde hitara hibar fise fise aiyer. Toi fusar goredde, \"Tũwara kiyor talaš gorodde?\" Hitara hodde: \"Rabbi! (zar mani ustad) Õne hoṛe tako?\" ");
INSERT INTO rhg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Isa hitarare hodde, \"Aiyo edde sogai.\" Toi hitara giye edde hiba hoṛe take he zaga hiyan saiye. Ar he dingan hitara hibar fũwati haṛaiye. Hẽtte dinor sairguwa baijje. ");
INSERT INTO rhg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yahyar hota funi ze duizon Isar fise fise gil, hitara ekzonor nam aššil Andreas, hite Simon Fitoror bái. ");
INSERT INTO rhg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andreas foila hitar bái Simonore tuwai loiye edde hitare hodde, \"Ãra Messiyar deha faiyi\" (Messiyah zar mani he basona goijjawa). ");
INSERT INTO rhg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Toi hite Simonore Isar hãse ainne. Isaye Simonor mikka saiyore hodde, \"Tui Yohannar fut Simon, kintu tore Koifa hoi ḍaka oibo\" (Koifa oilde Fitor zar mani fattor). ");
INSERT INTO rhg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tarfordin Isaye Galilot zaibo issa goijje. Ar hibaye Filipore faiyore hitare hodde, \"Ãr fisa lo.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip o Andreas edde Fitoror ḍoil Betsaida ṭonor aššil. ");
INSERT INTO rhg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe Natanaelore lot faiye edde hitare hodde, \"Musa nobiye zar babute Torah kitabot leikke edde zar babute nobi okkole o leikke, ãra hibar deha faiyi: Hiba oilde Nasarator Isa, Yusufor fut.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Toi Natanaelye hitare hodde, \"Nasaratottu ki bala hono kissu ai faribo?\" Filipe hitare hodde, \"Ai edde sagai.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Isaye dekedde Natanael hibar mikka aiyer, toi hibaye hitar babute hodde, \"Oto so, ekzon soiyi Israili, zar butore hono dúhabazi nai.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelye hibare hodde, \"Õne ãre kengori sino?\" Isaye zuwab diye edde hitare hodde, \"Filipe tore ḍakibar age zẽtte tui ḍũir gasor tolat aššili, hẽtte ãi tore dekkilam.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelye zuwab diye edde hibare hodde, \"Rabbi, õne Allar Fut, Israilor badša.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Isaye hodde, \"Ãi tore ḍũir gasor tolat dekki boli hoiyi hetolla ki tui ãre biššaš goror? Tui hiyanottuwaro aro ḍõr kissu dekibi.\" ");
INSERT INTO rhg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bade Isaye aro hodde, \"Soiyi, soiyi, ãi tũwarare hoir, tũwara dekiba, 'behosto kula, ar Allar firista okkol uṛa lama gorer' Adomor Futor uwore.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ar tin dinor din Galilor Kana farat ekkan biya oiye. Isar ma heṛe aššil. ");
INSERT INTO rhg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ar he biyat Isa edde hibar sahabi okkolore o dawat diya oil. ");
INSERT INTO rhg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bade šoraf zehon furai giyegoi Isar maye Isare hodde, \"Hitaratu šoraf furai giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Isaye hodde, \"He maya fuwa, ãre kiyolla ei babute šamil goror? Ãr ṭaim aizo nu aiye.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hibar maye sakor okkolore hodde, \"Hibaye tũwarare zen goitto ho, tũwara hendilla goro.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Heṛe Ihudi okkole pak saf oibolla bebar gorede sowa fattoror fanir siyũ buwagoraiya aššil, hin fotti ugguwat kuri tiriš gelom fani aṛito. ");
INSERT INTO rhg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isaye he soijja okkolore hodde, \"Ei siugunot fani bori do.\" Toi hitara hinor hãra hãra ofan gori fani bori diye. ");
INSERT INTO rhg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hibaye hitarare hodde, \"Ebar hentu olfo olfo furai loi hána baṛidoya okkolor mazir hãse loizo.\" Toi hitara hen goijje, ");
INSERT INTO rhg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","tarfore hána baṛidoya maziye ze fani šoraf oiye hin fi hái saiye, ar hite hin honttu aišše no zanito, kintu ze soijja okkole fani tuillil, hitara zanito. Toi hite dulare ek ḍaikka ḍaki loizai hodde, ");
INSERT INTO rhg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","\"Mainše foila barik šoraf haito de, tarfore zehon meheman okkole beši fifele hetunot hosta šoraf diya o; kintu tui barik šoraf ehon o foijjonto rakidiyos.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iyan aššilde sinno okkolor šuru, ziyan Isaye Galilor Kana farat goijje, edde hibar mohimare forhaš goijje; ar hibar sahabi okkole hibar uwore biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tarfore hiba, hibar ma, báiyain edde sahabi okkol Kofornahumot lami giye, ar heṛe beši din no take. ");
INSERT INTO rhg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hẽtte Ihudi okkolor uddar id hãse aišše, ar Isa uwore Zeruzalemot giye. ");
INSERT INTO rhg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Heṛe dórmogóror uṛanot hibaye goru, sool, ar hoitor, besa kina goredde lotfaiye, ar heṛe fũnḍiola okkol boišše. ");
INSERT INTO rhg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Toi hibaye dori loi ekkan souk banaiye, ar hiyan loi goru sool edde manuš beggunore dórmogórottu lorai diye; ar hibaye fũnḍiola okkolor foiša okkol šiṛidiye edde hitarar ṭebilgunore uldaidiye. ");
INSERT INTO rhg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Toi hibaye he hoitor besoya okkolore hodde, \"Ei zagattu in okkol šorai loi felo! Ãr Bafor górore bazaror zaga no banaiyo.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hibar sahabi okkolottu monot foijje ze iyan leka ase: \"Tũwar górolla zolonto issaye ãr dil zali tulibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Toi Ihudi okkole zuwab diye edde fusar goijje, \"Tui ki sinno ãrare dehai faribi ze tottu in goribolla odihar ase?\" ");
INSERT INTO rhg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isaye zuwab diye edde hitarare hodde, \"Ei dórmogórgan bangifelo, ar ãi iyan abar tin dinor butore tuliyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hitara hodde, \"Ei dórmogór iyan bandite sališ so bosor laggil, ãr iyan tui tin dinor butore tulibi?\" ");
INSERT INTO rhg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Asole hibaye ḍórmogór hoite hibar nizor gar babute hoiyede. ");
INSERT INTO rhg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hetolla hiba zẽtte morattu uṛigiyegoi, hibar sahabi okkolottu monot foijje ze hibaye hitarare iyan hoilde, ar hitara Pak kitabor kalam edde Isaye hoilde hota biššaš goijje. ");
INSERT INTO rhg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Uddar idor ṭaimot hiba zẽtte Zeruzalemot aššil, hẽtte ze sinno okkol hibaye gorat aššil, hin dekiyore boute hibar namot biššaš goijje. ");
INSERT INTO rhg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kintu Isa nize hitarar biššašor babute biššaš no gore, kiyollahoile hibaye hitara beggunore zane. ");
INSERT INTO rhg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ar manuš zatir babute honokiye goba dok, hibattu hiyanor hono dorhar nu aššil, kiyollahoile manušor butore ki aššilde hiyan hibaye nize zanito. ");
INSERT INTO rhg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Heṛe Forošir ekzon manuš aššil, zar nam Nikoḍomas, Ihudi okkolor ek neta. ");
INSERT INTO rhg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ekdin raitta hibaye Isar hãse aiyore hodde, \"Rabbi, ãra zani õne ekzon šikkadoya, ze Allar hãsottu aiššo. Kiyollahoile õne ze sinnor ham okkol zin goijjo, hin Allah fũwati no takile honokiye gori no fare.\" ");
INSERT INTO rhg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isaye zuwabe hodde, \"Ãi tũware soiyi hoir, noya gori zormo no oile, honokiye Allar raijjo deki no faribo.\" ");
INSERT INTO rhg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikoḍomase hibare hodde, \"Manuš ekzon bura oile kengori zormo oi faribo? Hite ki dusora bar mar ferõt uwafes firizaiyore zormo oi faribo?\" ");
INSERT INTO rhg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zuwabe Isaye hodde, \"Ãi tũware soiyi hoir, zodi hono kiye fani edde Pak Ruhuttu zormo no o, hite Allar raijjot goli no fare. ");
INSERT INTO rhg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hiyan ziyan gustor zormo oiye, oilde gusto, ar hiyan ziyan Ruhor zormo oiye, oilde ruh. ");
INSERT INTO rhg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ãi ze tũware hoilam, 'Tũwarattu hameka noya gori zormo owa foribo,' hiyanot ammuwak no oiyo. ");
INSERT INTO rhg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Boyar ze mikka baito sa he mikka ba. Tũwara hinor abas funo, kintu ei boyar hontu aiye edde hon mikka za hiyan tũwara hoi no faro. Pak Ruhor zormo owa o hendilla.\" ");
INSERT INTO rhg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikoḍomase hodde, \"En kengori oi faribo?\" ");
INSERT INTO rhg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hetunot Isaye hodde, \"Tũi Israilor šikkadoya oi bade ei ziniš okkol kissu no buzo kiya? ");
INSERT INTO rhg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ãi tũware soiyi hoir, ãra ziyan zani ãra hiyan hoi, ar zin deki hinor babute goba di, kintu tũwara ãrar goba no goso. ");
INSERT INTO rhg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ãi duniyaibi zinišor babute hoidde hin zodi biššaš no goror, henot behostor zinišor babute hoile ken gori biššaš goriba? ");
INSERT INTO rhg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ze behostottu lami aišše he Adomor Fut sara ar honokiye honodin behostot no uṛe. ");
INSERT INTO rhg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ar Musa nobiye zendilla bošoti sara elehat hafore uwore tullil, hendilla Adomor Futore o tuli lowa oibo, ");
INSERT INTO rhg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","zene fottikiye ze hibare biššaš gore hite akeri zibon fa.\" ");
INSERT INTO rhg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kiyollahoile Allaye duniyaire eto beši ador goijje ze, hibar he lehar ek Futore diye, zene, ze kiye hibar uwore biššaš ane hite dongšo no o, bolke akeri zibon fa. ");
INSERT INTO rhg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kiyollahoile Allaye hibar Futore defeṛaiyede duniyair bisar goribolla no, bolke duniyaiye zene hibar duwara uddar fa. ");
INSERT INTO rhg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Hite ze hibare biššaš gorer, hitar bisar gora no oibo, kintu hite ze biššaš no gorer hitar bisar ehon loti oigiyegoi, kiyollahoile hite Allar šude lehar Futor namot biššaš no ane. ");
INSERT INTO rhg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ar iyan oilde bisar: Nur duniyait aišše, ar manuš okkole nurottuwaro andarore beši muhabbot goijje, kiyollahoile hitarar ham aššil horaf. ");
INSERT INTO rhg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kiyollahoile fottikiye ze horaf ham gorer, hitara nurore hingša gorer, ar nuror ḍake nu aiye, zene hitar horaf ham forhaš oi no zagoi ");
INSERT INTO rhg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kintu hite ze soyit soler, hite nuror hãse aiye, toi zene hitar hamgun Allar issa mozin gora oiyede hiyan foriškar deha za. ");
INSERT INTO rhg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","In okkol bade, Isa edde hibar sahabi okkol Ehudiya elehat aišše, ar hiba heṛe kissu din hitarar fũwati taikke, edde torikotor gusol diye. ");
INSERT INTO rhg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ehon, Yahyaye o Salimor hãsa hãsi Aenonot, torikotor gusol diyat aššil, kiyollahoile heṛe beši fani aššil, ar manuš okkol heṛe aiyore torikotor gusol lowat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(In aššilde Yahyare ziyolot dibar age.) ");
INSERT INTO rhg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hẽtte Ihudi rosomi pak safor babute Yahyar šagirit okkol loi edde ekzon Ihudi loi barabari uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bade hitara Yahyar hãse aiyore hodde, \"Rabbi, ze Zordanor ofarot õnor fũwati aššil, edde zar babute õne goba dila, so, hibaye torikotor gusol der, ar beggune hibar hãse zar.\" ");
INSERT INTO rhg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahyaye hodde, \"Behostottu diya oiyede no oile ekzon mainše hono kissu fai no fare. ");
INSERT INTO rhg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tũwara nize ãr goba ze ãi hoiyi, 'Ãi Messiyah no, kintu ãre hibar age defeṛa oiye.' ");
INSERT INTO rhg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Zar hãse hoinna, hiba oilde dula. Dular bondu, ze tiyaiyore hibar hota funer, hibaye dular abazot beši kušiye anondo gorer; aijja ãttu o hendilla furafuri kuši furon oiye. ");
INSERT INTO rhg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iyan zorulot ehonottu loti hibattu bara foribo, ãttu šoṛo owa foribo.\" ");
INSERT INTO rhg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ze uwottu aiye, hiba beggunor uwore; ze duniyaittu hite duniyair, ar duniyair ekzonor ḍoilla hota ho. Hiba ze behostottu aiye, hiba beggunor uwore. ");
INSERT INTO rhg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hibaye zin deikke edde fuinne hinor goba der, tarfore o honokiye hibar gobare no goser. ");
INSERT INTO rhg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hite ze hibar gobare goser, hiyane sil maijje ze Allah oilde soiyi. ");
INSERT INTO rhg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kiyollahoile hiba zare Allaye defeṛaiye, hibaye Allar kalam hor; kiyollahoile Allaye Ruhure mafiyore no de. ");
INSERT INTO rhg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bafe Futore ador gore edde hár kissure hibar hãtot šebi diye. ");
INSERT INTO rhg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hite ze Futore biššaš gore, hite akeri zibon faiye, kintu hite ze Futore batil gore, hite zibon no dekibo, bolke Allar gozob hitar uwore ase edde takibo. ");
INSERT INTO rhg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ehon, Malike zehon zani faijje ze Foroši okkole fuinnil, hibaye Yahyattuwaro beši sahabi banar edde torikotor gusol der, ");
INSERT INTO rhg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(zodi o Isaye nize torikotor gusol no dito, kintu hibar sahabi okkole dito.) ");
INSERT INTO rhg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Toi hiba Ehudiyattu giyegoi edde abar Galilot giye. ");
INSERT INTO rhg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Zaite hibattu Sameriyar butottu di za foijje. ");
INSERT INTO rhg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Toi hiba Sykar name Sameriyar ek šohorot, aiššiye; ziyan Yakube hibar fut Yusufore dilde zobinor hãse. ");
INSERT INTO rhg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","He zagat heṛe ugguwa Yakubor kuwa aššil. Fõtot zat maze Isa oran oiye, edde he kuwar ḍake boišše; ar hẽtte ṭaim onumanik dũijja. ");
INSERT INTO rhg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Toi heṛe Sameriyattu ek mayafuwa fani tulito aišše, Isaye hibare hodde, \"Ãre fani fito de\" ");
INSERT INTO rhg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Hibar sahabi okkole šohorot hána kinto gil.) ");
INSERT INTO rhg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","He Sameriyo mayafuwawaye hibare hodde, \"Õne, ekzon Ihudi oiyore, ãi ekzon Sameriyar mayafuwa oiyore, ãttu kengori fani sor?\" (Kiyollahoile Ihudi okkole Sameriyo okkol loi suwa fiya no gorito.) ");
INSERT INTO rhg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isaye zuwabe hibare hodde, \"Tui zodi zaniti Allar hadiya ki, edde hiba honnuwaye hor 'Ãre fani fito de', toile tui hibattu saiti, ar hibaye tore zinda fani dito.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mayafuwawaye hodde, \"Malik, õnottude fani tulibolla kissu nai ar kuwawa o mur. Toile he zinda fani hontu for? ");
INSERT INTO rhg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ãrar baf Yakubottuwaro ki õne mohan, edde ze ei kuwa ãrare diye, ar hibattu hiba nize edde hibar fuwain okkole, hibar zanuwaror záke fani fiye?\" ");
INSERT INTO rhg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isaye zuwabe hibare hodde, \"Fottikiye ze ei fani fiyer hite abar tiraši oibo, ");
INSERT INTO rhg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu ze honokiye ãi diyumde he fanittu fibo, hite ar honodin tiraši no oibo; ãi diyumde fani hin hitar dilor butore ũtari uṛede zonnar fani ḍoilla oibo, edde akeri zibon dibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mayafuwawaye hibare hodde, \"Malik, toile ei fani ãre do, zene ãttu ar tiraš no lage, ar fani tulibolla eṛe aiya no fore.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isaye hibare hodde, \"Za, tor zamaire ḍaki loiagoi\" ");
INSERT INTO rhg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mayafuwaye hodde, \"Ãttu zamai nai.\" Isaye hibare hodde, \"'Ãttu zamai nai' hoyosde hiyan tui ṭik hois. ");
INSERT INTO rhg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kiyollahoile ei foijjonto tottu fãszon zamai aššil, ar ehon tottu ze ase, hite tor zamai no; tui hodde hiyan soiyi.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mayafuwaye hodde, \"Malik, ãi buzi faijji ze õne ekzon nobi. ");
INSERT INTO rhg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ãrar fordada okkole ei faharor uwore ebadot gorito, kintu tũwara ho ze zagat ebadot gora foribo hiyan oilde Zeruzalemot.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isaye hibare hodde: \"Oh mayafuwa, ãrar hota biššaš gor, en ṭaim aiyer zẽtte tũwara, no ei faharot, no Zeruzalemot, Bafor ebadot goriba. ");
INSERT INTO rhg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tũwara ziyan no zano hiyanor ebadot goro; kintu ãra ziyan zani hiyanor ebadot gori, kiyollahoile uddar oilde Ihudi okkolor butottu. ");
INSERT INTO rhg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kintu en ṭaim aiyer, enki ehon he šomoi aigiyegoi zẽtte asol ebadot goroya okkole soiyit edde Ruhut Bafor ebadot goribo. Bafe o endilla ebadot goroya okkolore tuwa. ");
INSERT INTO rhg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Allah oilde Ruh, ar hitara zara hibar ebadot gore, soiyit edde Ruhut ebadot gora foribo.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mayafuwawaye hodde, \"Ãi zani Messiyah aibo (zare Mosi ḍake). Hiba zẽtte aibo, hibaye ãrare hár kissu buzai dibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Toi Isaye hibare hodde, \"Ãi, ze tor loi hota hoir, ãi hiba.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hen šomot hibar sahabi okkol aišše, edde hibaye ekzon mayafuwa loi hota hodde dekiyore hitara ammuwak oiye. Tarfore o hitara honokiye no ho, \"Õne ki sodde?\" Ba \"hibar loi kiyolla hota hor?\" ");
INSERT INTO rhg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Toi mayafuwawaye hibar gorawa felai raki šohoror butore giye, edde mainšore hodde, ");
INSERT INTO rhg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","\"Aiyo, ekzon manušore sogai, ze ãi zaha kissu goijji, beggun ãre hoi diye; Iba ki hono Messiyah ne?\" ");
INSERT INTO rhg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hitara šohorottu niyoli giye edde Isar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hen šomot hibar sahabi okkole hibare foriyad gori hodde, \"Rabbi, kissu hó.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Isaye hitarare hodde: \"Ãttu háibolla en hána ase, zinor babute tũwara no zano.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sahabi okkol ekzone oinno zonore howa hoi goijje, \"Honokiye ki hibare háibolla kissu ani diye oitfare?\" ");
INSERT INTO rhg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isaye hitarare hodde, \"Ze ãre defeṛaiye hibar issa falon gora edde hibar ham gori šeš gorifela oilde ãr hána. ");
INSERT INTO rhg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tũwara ki no ho ne, 'ehon o sair maš ase, tarfore gula daibar ainda aiyer'? Ãi tũwarare hoir, suk tuli maṭ okkolor mikka so, hin daibolla fagi dóla oiye. ");
INSERT INTO rhg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ze dar hite hitar beton far, ar akeri zibonolla gulagun dola gori raker, zene ze biz laga edde ze gula da, dunizone ekkui fũwati kuši gori fare. ");
INSERT INTO rhg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Etolla ei bosongan soiyi, 'Ekzone laga ar ekzone da.' ");
INSERT INTO rhg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ãi tũwarare daito defeṛailam zinolla tũwara hono haṛoni no goro; haṛoni goijje oinno kiye, ar tũwara goillo hitarar haṛonir fošol daito.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","'Ãi zaha kissu goijji, beggun ãre hoi diye' he mayafuwawar ei gobar hotar zoriya he šohoror bout Sameriyo okkole Isar uwore biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Toi hitara hibar hãse aišše edde hibare hitarar fũwati takibolla foriyad goijje; ar hiba heṛe dui din taikke. ");
INSERT INTO rhg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hibar hotar zoriya aro bout beši mainše biššaši oiye. ");
INSERT INTO rhg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hitara mayafuwaware hodde: \"Ãra šude tor hotar zoriya biššaš ainnide no; kiyollahoile ãra nize hibar hota fuinni edde zani ze iba oilde soiyi duniyair he Uddargoroya.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dui din farai zaigoi bade Isaye hentu baisa diye edde Galilot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Kiyollahoile hibaye nize goba dil ze ekzon nobi hibar nizor dešot ijjot no fa.) ");
INSERT INTO rhg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hiba zehon Galilot aišše, Galiliyo okkole hibare goisse, Zeruzalemot uddar idot hibaye goijjede hár kissu hitara dekiyore, kiyollahoile hitara o uddar idot gil. ");
INSERT INTO rhg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Isa abar Galilor Kana farat giye, zeṛe hibaye fanire šoraf goijjil. Ar heṛe ek raz hormosari aššil, zar fute ošuk loi duk fat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ehudiyattu Isa Galilot aišše funiyore hite hibar hãse aišše, edde foriyad goijje zene hiba hitar fũwati lamat za edde hitar futore aram gore, kiyollahoile hitarar foran zar zar oiye. ");
INSERT INTO rhg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Toi Isaye hitare hodde: \"Sinno edde keramoti ham no dekile, tũwara biššaš no goriba.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","He raz hormosariye hodde: \"Malik, meherbani gori ãr fuwawa no morite aiyo.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isaye hitare hodde, \"Za, tor fut basibo.\" Henot hite Isaye hoiyede hota biššaš goijje edde giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ar hite lamat zadde fõtot, hitar gulam okkole dola oiye edde hitar hãse hóbor diye ze hitar fuwawa baisse. ");
INSERT INTO rhg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hite hitarare hite hõtte bala oiye he babute zera goijje, ar hitara hitare hodde: \"Gelde hailla ugguwa baze, hitattu zor sarigiyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Henot fuwawar bafe buzi faijje ze, ṭik he šomot Isaye hitare hoil, \"Za, tũwar fut basibo.\" Toi hite edde hitar fura gór ṭiyaye biššaši oiye. ");
INSERT INTO rhg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ehudiyattu Galilot ai bade Isaye ei dusora bar keramoti ham goijjil. ");
INSERT INTO rhg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iyar bade Ihudi okkolor ek id oiye, ar Isa uwore Zeruzalem giye. ");
INSERT INTO rhg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ar heṛe Zeruzalemot Sool Geiṭor hãse ugguwa foir ase, zibare Ibroni bašat Betesda ho, ar hibat fãssan saniola gãṭ aššil. ");
INSERT INTO rhg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","In okkolot ek dõr biyaraimma mainšor dol foritakito, zara anda, lula, ãtur manuš okkol. ");
INSERT INTO rhg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Kiyollahoile ek firistaye šome šome oi foirot lami zaiyore fani hafaito, ei fani hafa bade ze foila fanit lamito, hitattu ze hono ḍoilla biyaram takibo takok, aram oi zaitogoi.) ");
INSERT INTO rhg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ar heṛe ekzon manuš aššil, ze tiriš ašṭo bosormula biyaraimma, ");
INSERT INTO rhg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","hite heṛe fori taikkede Isaye deikke, ar zani faijje ze hite bout din dori hite he abostat ase, toi hibaye hitare fusar goredde: \"Tui aram oito sos ne?\" ");
INSERT INTO rhg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","He biyaraimma manušwaye hodde, \"Malik, fani hafi uṛede šomot ãre foirot lamai loizaoya ãttu hono kiye nai; ar ãi nize zaite zaite ar ekzon ãr agottu lamegoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Toi Isaye hitare hodde, \"Uṭ, tor bisana tuli lo edde aṭ.\" ");
INSERT INTO rhg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hehon he manušwa aram oiye; ar hite hitar bisanagan tuli loiye edde ãiṭṭe. Ar he din aššilde Šabbat, ");
INSERT INTO rhg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ihudi neta okkole aram gora oiyede he manušware hodde, \"Aijja, Šabbat, ain mozin bisana boi loi za mana.\" ");
INSERT INTO rhg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hite hitarare zuwab diye, \"Hiba ze ãre aram goijje, hibaye ãre hoiye,'Tor bisana tuli lo edde aṭ.' \" ");
INSERT INTO rhg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Toi hitara hitattu fusar goijje, \"Manuš hiba honnuwa ze tore bisana tuli lo edde aṭ hoiye?\" ");
INSERT INTO rhg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ze manušwa aram oiye hite no zanito hiba honnuwa aššil, kiyollahoile Isaye šori gilgoi, heṛe beša beši manuš okkol aššil. ");
INSERT INTO rhg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Fore zaiyore Isaye he manušware abar dórmogóror uṛanot lot faiye edde hitare hodde: \"Sa, tui bala oiyos, guna ar no goris, toi zene tor uwore iyattuwaro aro horaf hono kissu no goṭe.\" ");
INSERT INTO rhg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hite zaiyore Ihudi netare hoiyegoi ze, hitare bala goijje hiba aššilde Isa. ");
INSERT INTO rhg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ar iyanolla boli Ihudi okkole hibare zala šuru goijje, kiyollahoile hibaye in okkol Šabbatot goijje. ");
INSERT INTO rhg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ar Isaye hitarare hodde, \"Ãr Baf ehon foijjonto hamot, ar ãi o ham gorir.\" ");
INSERT INTO rhg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iyanor zoriya Ihudi okkole hibare marifelaibolla aro beši kušiš goijje; kiyollahoile hibaye šude Šabbator niyom no bange, kintu Allare hibaye nizor Baf o hoiye, hiba nizore Allar fuwainna goriyore. ");
INSERT INTO rhg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iyanot Isaye hitarare zuwab diye edde hodde: \"Ãi tũwarare soiyi soiyi hoir, Fute nizottu hono kissu gori no fare; zodi hibar Bafe kissu gorede no deke; kiyollahoile zin hibaye gore Fute o gore. ");
INSERT INTO rhg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kiyollahoile Bafe Futore ador gore, ar hár kissu zin hibaye nize gore, beggun hibare deha; ar inottuwaro aro mohan ham okkol hibaye hibare dehaibo, zene tũwara ammuwak o. ");
INSERT INTO rhg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Zendilla Bafe mora okkolore tule edde zibon de, hendilla Fute o hibattu zare issa hitare zibon de. ");
INSERT INTO rhg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aro, Bafe honokiyor bisar no gore, kintu bisaror fura bar hibar Futor uwore diye, ");
INSERT INTO rhg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","zene beggune Bafore šorman gorede mozin Futore šorman gore; hite ze Futore šorman no gore, hite Bafore šorman no gore, ze hibare defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","\"Soiyi, soiyi, ãi tũwarare hoir, hite ze ãr kalam funer, ar ze ãre faṭaiye hibare biššaš gorer, hitattu akeri zibon ase; ar hitare bisarot tula no oibo, kintu morattu zibonot faraiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ãi tũwarare soiyi soiyi hoir, en ṭaim aiyer, bolke hiyan ehon aišše, zẽtte mora okkole Allar Futor abaz funibo, edde hitara zara funibo, hitara basibo. ");
INSERT INTO rhg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kiyollahoile Baf nizottu zendilla zibon ase, hendilla hibaye Fut nizottu o zibon taibolla diye. ");
INSERT INTO rhg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ar hibaye hibare bisar goribolla odihar diye, kiyollahoile hiba oilde Adomor Fut. ");
INSERT INTO rhg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","\"Ei hota funi ammuwak no oiyo, kiyollahoile en ṭaim aiyer, zara hoborot ase hitara beggune hibar abaz funibo, ");
INSERT INTO rhg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","edde hitara niyoli aibo, hitara zara bala ham goijje hitara zibon faibolla, ar hitara zara horaf ham goijje, hitara šasti faibolla. ");
INSERT INTO rhg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ãi nizottu kissu gori no fari, zendilla funi hendilla bisar gori, ãr bisar niyaiwala, kiyollahoile ãi ãttu ziyan goitto mone hor, hen no sai, kintu hibaye zendilla sar, ze ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","\"Ãi nize zodi ãr babute goba di, ãr goba soiyi no. ");
INSERT INTO rhg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kintu ar ekzon ase ze ãr babute goba der, ar ãi zani ze hibaye ãr babute ze goba der hiyan soiyi. ");
INSERT INTO rhg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","\"Tũwara Yahyar hãse manuš defeṛaila, ar hibaye soiyir foikka goba diye. ");
INSERT INTO rhg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Manuše ãr gobar dok ãi hiyan saide no; kintu ãi iyan hoir zene tũwara uddar fo. ");
INSERT INTO rhg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahya aššil he zoledde edde ujjol serag, ar tũwara hibar he fohorot hoto dinolla anondo goribolla issa goijjila. ");
INSERT INTO rhg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","\"Kintu ãttu Yahyar gobattuwaro aro mohan goba ase, kiyollahoile Bafe ãre ze ham okkol gori šeš goribolla diye, ze ham okkol ãi gorir, in okkole ãr babute endilla goba der ze ãre Bafe defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ar Baf, ze ãre defeṛaiye, hibaye nize ãr babute goba diye. Tũwara honodin hibar abaz no funo, hibar rohom o no deko. ");
INSERT INTO rhg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ar tũwarar dilot hibar kalam o bošoti no gorer, kiyollahoile hibaye defeṛaiyede hibare tũwara biššaš no goro. ");
INSERT INTO rhg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tũwara pak kitabor kalam tuwo, kiyollahoile akeri zibon heṛe butore faiba boli mone goro. Kintu ei pak kitabor kalam okkol oilde hin zine ãr babute goba de, ");
INSERT INTO rhg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tarfore o tũwara zibon faibolla ãr hase aito issa no goro. ");
INSERT INTO rhg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","\"Ãi manušor hãsottu tarif no gosi, ");
INSERT INTO rhg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kintu ãi tũwarare sini, tũwarar dilot Allar ador nai. ");
INSERT INTO rhg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ãi ãr Bafor namot aišši, ar tũwara ãre no gosor; kintu oinno kiye zodi hitar nizor name aiye, hitare tũwara gosiba. ");
INSERT INTO rhg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tũwara kengori biššaš gori faro? Tũwara ekzone ar ekzonottu tarif goso, kintu ze tarif šude Allar torfottu aiye hiyan no tuwo. ");
INSERT INTO rhg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","\"Mone no goijjo ze, tũwarare ãi Bafor sarme duši banaiyum; kintu tũwarar duši goroya oilde Musa, zar uwore tũwarar aša raikko. ");
INSERT INTO rhg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kiyollahoile tũwara zodi Musare biššaš gorita, toile tũwara ãre biššaš gorita, kiyollahoile hibaye ãre babute leikke. ");
INSERT INTO rhg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kintu tũwara zodi hibar leka biššaš no goro, toile ãi hoidde hin kengori biššaš goriba?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iyar bade Isaye Galil doriyar dusora farot giye, (ziyanore Ṭaiberiya doriya o ho.) ");
INSERT INTO rhg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ar ek beši ḍõr mainšor dole hibar fise fise giye, kiyollahoile hibaye biyaraimma okkolore aram goijjilde he keramot okkol hitara dekkil. ");
INSERT INTO rhg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tarfore Isaye ek faharor uwore giye edde heṛe hibaye hibar sahabi okkolore loi boišše. ");
INSERT INTO rhg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hẽtte Ihudi uddar id hãse aššil. ");
INSERT INTO rhg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Toi Isaye hibar suk tuille ek ḍõr mainšor dol hibar mikka aiyedde dekiyore, hibaye Filipore hodde, \"Itara háibolla ãra ruṭi hontu kiniyum?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hibaye hitare ei hotagan šude forikka goribolla hoiye, kiyollahoile hibaye ki goribo hiyan hibaye agottu loti zanito. ");
INSERT INTO rhg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe hibare zuwabe hodde, \"Hitarar fotti ekzone ek ṭukura gori faibolla dui šot dinaror ruṭiye o no kulaibo!\" ");
INSERT INTO rhg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Hibar sahabi okkol butore ekzon, Andreas, Simon Fitoror bái, hite hibare hodde, ");
INSERT INTO rhg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"Eṛe ek gura fuwattu fãswa buṭkar aṭar ruṭi edde duwa mas ase, kintu edun mainšore hin diyore ki oibo?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Isaye hodde, \"Mainšore buwagorai do.\" He zagaganot beši ker aššil, manuš okkol heṛe uwore boišše. (Onumanik fãs hazar furuš manuš heṛe aššil.) ");
INSERT INTO rhg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tarfore Isaye he ruṭigun loi Allare šukuriya zanaiye edde zara boišše hitara ze zedun saiye hitare hedun hedun bag gori diye. Hibaye mas o hen gori bag gori diye. ");
INSERT INTO rhg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Toi hitara beggune feṭ bori hái bade hibaye sahabi okkolore hodde, \"Ze ṭuragun basi roiye hin beggun ekku fũwati dola goro, zene kissu nošto oi no zagoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Toi hitara hen goijje, hána hái bade ze he fãswa ruṭittu ṭura basi aššil hinore hitara dola gori baro barang oiye. ");
INSERT INTO rhg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Isar ei keramoti ham deki mainše howahoi šuru goijje, \"Iba oilde he nobi ze duniyait aiyer.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Isaye buzi faijje ze hitara aibo edde hitara hibare raza banaibolla zur goribo; hetolla hiba hentu šoṛi zaigoiyore ekela abar faharot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Toi hazinna zehon oiye, sahabi okkol lamat doriyar hãsat giye, ");
INSERT INTO rhg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","edde ekkan not uiṭṭe edde Kofornahumor mikka baisa diye. Ar hẽtte andar aiššil edde ehon o Isaye hitara loi ottor no o. ");
INSERT INTO rhg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Heṛe beši zure bataš bonor zoriya fani beši utaltal oiye. ");
INSERT INTO rhg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hitara zẽtte tin sair mail no solai giye, bade dekedde Isaye fanir uwottu ãṛiyore hitarar mikka agguwai aiyer. Ar hitara beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kintu Isaye hitarare hodde, \"Iba ãi, no ḍoraiyo.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hitara hibare not tuli loito saiye, edde hehon nogan hitara zeṛe zat aššil he zagar kulot fõissegoi. ");
INSERT INTO rhg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tarfordin, ze manuš okkol doriyar oinno farot tiyai aššil, hitara deikke ze, heṛe ekkan bade ar hono no nu aššil, ar ze hibar sahabi okkol ziyanot uiṭṭe, Isaye hibar sahabi okkolor fũwati no hiyanot no uṛe, kintu hitara ekela gilgoi. ");
INSERT INTO rhg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ar Ṭaiberiyattu ho ekkan no, zeṛe Malike šukuriya zanai bade mainše ruṭi háil, he zagar ḍake aišše. ");
INSERT INTO rhg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mainšor dol okkole zehon dekilo ze Isa otóba hibar sahabi okkol kiye heṛe nai, hetunot hitara nogunot uiṭṭe edde Isare tuwaibolla Kofornahumot giye. ");
INSERT INTO rhg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ar hitara hibare doriyar ofarot faiyore, hitara hibare hodde, \"Rabbi, õne eṛe hõtte aiššo?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isaye hitarare zuwab diye edde hodde, \"Ãi tũwarare soiyi hoir, tũwara sinnor ham deikko boli tũwara ãre tuwodde no, bolke feṭ bori ruṭi hái faijjo boli. ");
INSERT INTO rhg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nošto oi zaiboide hánalla ham no goijjo, bolke hána zin akeri zibon foijjonto takibo, zin Adomor Fute tũwarare dibo, hinolla goro. Kiyollahoile he Baf Allah nize hibar uwore sil maijje.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Henot hitara hibare fusar goredde, \"Henoile ãra Allar ham okkol goribolla ãrattu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isaye hitarare zuwabe hodde, \"Allar ham oilde in: hibar uwore biššaš ano, zare Allaye defeṛaiye.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Toi hitara hibare hodde, \"Õne ki en sinno goror, zin dekiyore ãra õnore biššaš gori faijjum? Õne en ki ham goriba de? ");
INSERT INTO rhg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ãrar bafdada okkole bošoti sara elehat manna háil, zendilla leka ase: 'Hibaye hitarare behostottu háibolla ruṭi diye.'\" ");
INSERT INTO rhg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Isaye hitarare hodde, \"Ãi tũwarare soiyi soiyi hoir, tũwarare ruṭi behostottu Musaye diyede no, kintu ãr Bafe tũwarare behostottu he soiyi ruṭi de. ");
INSERT INTO rhg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kiyollahoile Allar ruṭi oilde hiba ze ruṭi behostottu nise lami aiye edde duniyaire zibon de.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hitara hodde, \"Malik, ei ruṭi ãrare hamiša do.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isaye hitarare hodde, \"Ãi oilamde he zibon ruṭi; hite ze ãr hãse aiye, hitattu buka no lagibo, ar hite ze ãre uwore biššaš ane, hite tiraši no oibo, hono dinolla. ");
INSERT INTO rhg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kintu ãi tũwarare hoiyi, tũwara ãre deikko, ar ehon o biššaš no goror. ");
INSERT INTO rhg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bafe zarare ãre diye, hitara beggun ãr hãse aibo, ar hite ze ãr hãse aiye, hitare ãi honodin baire felai no diyum. ");
INSERT INTO rhg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kiyollahoile ãi behostottu ãr issa mozin ham goribolla lami aiššide no, bolke hibar issa furon goribolla, ze ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ar ze ãre defeṛaiye, hibar issa oilde iyan ze, hibaye beggun zarare ãre diye, hentu ekzon o zene ãi no harai, bolke šešor dinot hitarare uwafes tuli. ");
INSERT INTO rhg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ar ãr Bafor issa oilde iyan ze, fotti ekzon ze Futore sa edde hibar uwore biššaš ane, hite akeri zibon fa; ar ãi hitarare šešor dinot uwafes tuliyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Henot Ihudi okkole hibar berudde monmona šuru goijje, kiyollahoile hibaye hoil, \"Ãi he ruṭi ze behostottu nise lami aišši.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hitara hodde, \"Iba ki Yusufor fut, Isa no ne? Zar baf mare ãra sini? Ite kengori endilla hoi fare, 'ãi behostottu nise lami aišši'?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Isaye zuwabe hodde, \"Tũwara ekzon loi ar ekzone monmonani bon goro; ");
INSERT INTO rhg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ãr Baf, ze ãre defeṛaiye, hibaye ṭani nu anile honokiye ãr hãse ai no fare, ar ãi hitare šešor dinot uwafes tuliyum. ");
INSERT INTO rhg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nobi okkolor kitabot leka ase: 'Hitara beggune Allar duwara šikka faibo.' Fottikiye ze Bafore funer edde hibattu šikka fa, hite ãr hãse aiyer. ");
INSERT INTO rhg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Endilla no ze Bafore honokiye deke, hiba ze Allar hãsottu aišše, šude hibaye deikke Bafore. ");
INSERT INTO rhg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ãi tũwarare soiyi soiyi hoir, hite ze ãr uwore biššaš ane hitattu akeri zibon ase. ");
INSERT INTO rhg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ãi oilamde he zibonor ruṭi. ");
INSERT INTO rhg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tũwarar bafdada okkole bošoti sara elehat manna háil, ar hitara morigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Iba oilde he ruṭi ziba behostottu nise lami aišše, zene ze honokiye hibattu há, edde no morer. ");
INSERT INTO rhg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ãi oilamde he zinda ruṭi, ziba behostottu lami aišše. Hite ze ei ruṭi há, hite sirohalolla basibo. Ar ze ruṭi ãi diyum hiyan oilde ãr ga, ziyan ãi diyum duniyair zibonolla.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ei hota funiyore Ihudi okkol ekzone ar ekzon loi doromoro barabari gori howa šuru goijje, \"Ite kengori ãrare hitar ga haito di fare?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isaye hitarare hodde, \"Ãi tũwarare soiyi soiyi hoir, Adomor Futor gusto zodi no ho, ar zodi no fiyo hibar lou, toile tũwarar butore zibon nai. ");
INSERT INTO rhg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hite ze ãr gusto edde lou há hitattu akeri zibon ase, ar ãi šeš dinot hitare uwafes tuliyum. ");
INSERT INTO rhg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ãr gusto oilde asol hána, ãr lou oilde asol fibar ziniš. ");
INSERT INTO rhg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hite ze ãr gusto edde lou há, hite ãr butore take ar ãi o hitar butore taki. ");
INSERT INTO rhg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Zendilla zinda Bafe ãre defeṛaiye ar hibar duwara zinda asi, ṭik hendilla ze ãre há hite o ãr duwara zinda takibo. ");
INSERT INTO rhg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iba oilde he ruṭi ze behostottu nise lami aišše. Tũwarar bafdada okkole manna háil edde morigiyegoi, kintu ze honokiye ei ruṭi háibo hite sirohalolla basibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","In okkol hibaye Kofornahumor sinagogot šikka dedde šomot hoil. ");
INSERT INTO rhg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hibar sahabi okkolor butore boute ei hota funiyore hodde, \"In beši koṭin šikka. Hone inore gosi faribo?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hibar sahabi okkole ei babute monmonar, hiyan Isaye buzi fariyore hitarare hodde, \"Iyanor zoriya ki tũwara forizorgoi? ");
INSERT INTO rhg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hetunot tũwara ki bafiba Adomor Fut age zeṛe aššil heṛe uṛi zargoide dekile? ");
INSERT INTO rhg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruhuye zibon de; gustoye hono kissu faida no de, ze hota okkol ãi tũwarare hoilam, hin oilde Ruh edde zibon. ");
INSERT INTO rhg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tarfore o tũwarar butore en hozon ase, zara biššaš no gore.\" Kiyollahoile Isaye šuruttu loti zanito, hitara hontara zara hibare biššaš goribo, ar hite honnuwa ze hibar loi beimani goribo. ");
INSERT INTO rhg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ar hibaye hodde, \"Etolla ãi tũwarare hoilam, zodi ãr Bafor torfottu kemota diya no o, toile honokiye ãr hãse ai no fare.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iyar bade hibar bout sahabi okkol uwafes firi giyegoi edde hibar loi ar sola fira no gore. ");
INSERT INTO rhg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Toi Isaye he barozonore fusar goijje, \"Tũwara o ki uwafes firi zaibolla issa goror?\" ");
INSERT INTO rhg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Fitore zuwabe hodde, \"Malik, ãra har hãse zaiyum? Akeri zibonor kalam to õnor hãse ase. ");
INSERT INTO rhg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ãra biššaš goijji, ãra zani ze, õne Allar he Pakzon.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Toi Isaye hitarare hodde, \"Ãi ki tũwara barozonore basi no loi ne? Zodi o tũwarar butore ekzon šoitan.\" ");
INSERT INTO rhg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ei hota hibaye Iskariyoti Simonor fut Ehudar babute hoiyede, kiyollahoile hite, he barozonor butore ekzon oi bade o, hiba loi beimani goribo.) ");
INSERT INTO rhg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","In okkol bade, Isa Galilot gurafira gorer. Hiba Ehudiyat zaito no sa, kiyollahoile Ihudi neta okkole hibare marifelaibar kušišot aššil. ");
INSERT INTO rhg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ar hẽtte Ihudi bãša id (ziyanore Sukkut ho) hãsa hãsi aššil, ");
INSERT INTO rhg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Isar báiyainde hibare hodde, \"Enttu Ehudiyat zagoi, toi zene tui gorodde he ham okkol tor sahabi okkole deki fare. ");
INSERT INTO rhg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kiyollahoile ze nize mainšor muntu forhaš oito sa, hite gufone hono kissu no gore. Tui zehon in okkol goror, nizore duniyair sarme forhaš gor.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kiyollahoile hibar nizor báiyainde o hibare biššaš no gorito. ");
INSERT INTO rhg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Henot Isaye hitarare hodde, \"Ãr ṭaim ehono nu aiye, kintu tũwarar ṭaim hamiša hazir. ");
INSERT INTO rhg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Duniyaiye tũwarare hingša gori no fare, kintu hiyane ãre hingša gore, kiyollahoile ãi hiyanor babute goba di ze hiyanor ham horaf. ");
INSERT INTO rhg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Idot tũwara zo; ãi ehon no zaiyum, kiyollahoile ãr ṭaim ehono furon no o.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hibaye hitarare in okkol hoiyore hiba Galilot taigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kintu hibar báiyain okkol uwore idot giyegoi, bade hiba nize o heṛe giye, tarfore o kulasa bafe no, gufone. ");
INSERT INTO rhg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Idot Ihudi neta okkole Isare tuwail, ar hodde, \"Hite hoṛe?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ar heṛe mainšor dolor butore hibar babute bout monmonani šuru oiye, kissuye hodde: \"Hiba bala.\" Ar kiye hor, \"No, hite mainšore bul fõtot loizargoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kintu Ihudi neta okkolor ḍore honokiye hibar babute kulasa bafe kissu no ho. ");
INSERT INTO rhg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Id ada adi oiyede ṭaimot Isa uwore dormogórot giye, edde šikka diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Henot Ihudi neta okkol tajjuf oiyore hodde, \"Hono šikka no gori kengori ite endilla giyan zane?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Isaye hitarare zuwabe hodde, \"Ãr šikka ãr nizor no, kintu ze ãre defeṛaiye, hibar. ");
INSERT INTO rhg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ze honokiye hibar issa falon goribolla issa gore, hite ei šikkar babute zanibo, iyan Allattu or ne naki ãi nizottu hoi. ");
INSERT INTO rhg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hite ze nizottu ho hite hitar nizor tarif tuwa, kintu hite ze defeṛaiyede hibar tarif tuwa, toile hite soiyi, na soiyi hitar butore nai. ");
INSERT INTO rhg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musaye ki tũwarare ain no de ne? To tũwarar honokiye he ain falon no gore; tũwara ãre kiyolla marifelaito sor?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Manuš okkole zuwabe hodde, \"Tore bute faiye, tore marifelaito hone sar?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isaye zuwabe hitarare hodde, \"Ãi ekkan ham goijji, ar tũwara beggune ammuwak oiyo. ");
INSERT INTO rhg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ar Musaye tũwarare azomi goraibar niyom dil, (zodi o ei niyom asole Musar hãsottu nu aiye, bafdada okkolottu aišše), ar tũwara Šabbator din o azomi goro. ");
INSERT INTO rhg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Musar ain banga no ofan zodi Šabbator dinot ekzonore azomi gora za, toile Šabbatot ãi ekzon manušore furafuri aram goijjide hiyanolla kiyolla tũwara ãr uwore rag goror? ");
INSERT INTO rhg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tũwara dekodde mozin bisar no goijjo, bolke niyai bisar goro.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hetunot hodun Zeruzalemor mainše hodde, \"Manuš iba hiba no ne, zare hitara marifelaibolla tuwar?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kintu so, ite eṛe kulasa bafe hota hor, ar honokiye hitar berudde kissu no hor; toile šašon goroya okkole ki soiyi zani faijje ze iba Messiyah?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kintu ite hontu hiyan to ãra zani, ar Messiyah zẽtte aibo, hiba hontu honokiye no zanibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tarfore Isaye dórmogóror uṛanot šikka dedde šomot guzori hodde,\"Oi, tũwara ãre zano, ar ãi hontu iyano zano; ãi ãr nizottu nu aiyi, kintu ãre defeṛaiyede hiba soiyi, zare tũwara no zano, ");
INSERT INTO rhg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ãi hibare zani, kiyollahoile ãi hibar hentu aišši, ar ãre hibaye defeṛaiye.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Henot hitara Isare doitto saiye, kintu honokiye hibar gat hat no de, kiyollahoile hibar ṭaim ehon o nu aiye. ");
INSERT INTO rhg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ehono, mainšor dolor butottu bout kiye hibar uwore biššaš ainne edde hodde, \"Messiyah zẽtte aibo, hibaye ki ei manuššuwaye goijjede hinottuwaro beši sinno gori dehaibo?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Foroši okkole hibar babute in okkol loi monmonadde fuinne; ar ḍõr imam okkole edde Foroši okkole hibare dori anibolla hoekzon dórmogóror faharadarore defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Toi Isaye hodde, \"Ehon o ãi olfo dinolla tũwarar fũwati asi, tarfore ze ãre defeṛaiye ãi hibar hãse zaiyumboi. ");
INSERT INTO rhg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tũwara ãre tuwaiba, kintu ãre no faiba; ar ãi zeṛe, heṛe tũwara ai no fariba.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Henot Ihudi okkole ekzonore ekzone hodde, \"Iba hoṛe zaibo ze, ãra hibare tuwai no faiyum? Hiba hono ãrar Ihudi okkol zara Girikiyo okkolor fũwati šiṛašitta oi asede heṛe zaibo, edde Girikiyo okkolore šikka dibogoi? ");
INSERT INTO rhg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hibaye, 'Tũwara ãre tuwaiba, kintu tũwara ãre tuwai no faiba, ar ãi zeṛe, heṛe tũwara ai no fariba.' hoi ki hoito sadde?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Idor šeše, ze din idor asol boro din, Isaye tiyaiyore guzori hodde, \"Ze honokiye tiraši, hite ãr hãse aiyok edde fiyok. ");
INSERT INTO rhg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hite ze ãr uwore biššaš ane, kitabor leka mozin, hitar dilot zinda halor fani baibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ei hota hibaye Pak Ruhur babute hoiye, hitara zara hibare biššaš goijje, hitara faibo, ze Pak Ruhure ehono diya no o, kiyollahoile hẽtte o Isare mohimaola gora no o. ");
INSERT INTO rhg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hibar hota okkol funiyore dolor butottu kiye kiye hodde, \"Soiyi iba he nobi.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ar kiye hodde, \"Iba Messiyah\" Kintu kiye kiye hodde, \"Galilottu kengori Messiyah aibo? ");
INSERT INTO rhg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kalame ki no ho ne ze Messiyah Daudor bongšottu edde ze šohorot Daud aššil, he Betlehemottu aibo?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Endilla gori hibare loi manuš okkolor butore bag oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ar hitarar butottu hodune hibare dorito saiye, kintu honokiye hibar gat hat no de. ");
INSERT INTO rhg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Toi dormogór faharadar okkol uwafes ḍõr imam edde Foroši okkolor hãse aišše, toi hitara hitarare hodde, \"Hitare tũwara nu ano kiyolla?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dormogór faharadar okkole zuwabe hodde, \"Hibar ḍoilla endilla hota ar honokiye honodin no ho.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Henot Foroši okkole hodde, \"Tũwarare o ki kufõtot loigiyegoi neki? ");
INSERT INTO rhg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Šašon goroya okkol otóba Foroši okkolor butottu honokiye hitar uwore biššaš ainne ne, hono? ");
INSERT INTO rhg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kintu ei manušor dole Musar ain no zane, itarar uwore bodduwa ase.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikoḍomas, Foroši okkolor butore ekzon ze age Isar hãse aiššil, hibaye hitarare hodde, ");
INSERT INTO rhg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","\"Age, hono ekzon manuš hitar nizor hota no funiyore edde hite ki gore hiyan no zaniyore ki ãrar aine bisar gore?\" ");
INSERT INTO rhg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hitara zuwabe hodde, \"Tũi o hono Galilor ne? Pak kitabot tuwai so, toi dekiba ze Galilottu hono nobi nu aibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Toi hitara beggune ze zar zar górot giyegoi, ");
INSERT INTO rhg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","kintu Isa zaitun faharot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Taforor din binna sore Isa abar dórmogóror uṛanot giye, zeṛe hár manuš okkol hibar sairo ḍakottu aišše. Ar hiba boiyore hitarare šikka diye. ");
INSERT INTO rhg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Toi alem okkole edde Foroši okkole ekzon zenat dora háiyede mayafuware ainne edde hibare maze tiya goraiyore ");
INSERT INTO rhg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","edde hodde, \"Ustad, ei mayafuware zenar hamot dora háiye. ");
INSERT INTO rhg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Torar ainot Musaye endilla mayafuwaindore fattor maribolla ãrare hokum diye; kintu õne ki ho?\" ");
INSERT INTO rhg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hitara hibare forikka goribolla iyan hoiye, zene hitara hibare hosuri dibolla ekkan muda tuwai fa. Kintu Isaye nise niyuriyore õl diyore meṛit leka šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hitara zehon fusar gorat roiye, hiba uzu oiyore hitarare hodde, \"Tũwarar butore guna sarawaye hibare foila fattorguwa marok.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Toi hiba abar nise niyuriyore meṛit leka doijje. ");
INSERT INTO rhg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Toi hitara iyan funiyore ekzon ekzon, murubbi okkol loti šuru gori, giyegoi, šude Isa roigiyegoi, edde mayafuwawa hibar sarme tiyai aššil. ");
INSERT INTO rhg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Isaye abar uzu oiyore he mayafuwaware hodde, \"Mayafuwa, hitara hoṛe? Honokiye ki tore šasti no de?\" ");
INSERT INTO rhg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hibaye hodde, \"Malik, hono kiye nai.\" Toi Isaye hodde, \"Henoile ãi o tore šasti no diyum; za ehon loti ar guna no goris.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isaye abar mainšor loi hota hoiye, hibaye hodde, \"Ãi duniyair nur; hite ze ãr fisa lo, hite andarot no ãṛibo, kintu hite zibonor nur faibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Foroši okkole hibare hodde, \"Tui tor goba dor, tor goba soyi no.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isaye zuwabe hitarare hodde, \"Zodi o ãi ãr goba nize, ãr goba soiyi; kiyollahoile ãi honttu aišši, ar hoṛe zair, ãi zani, kintu tũwara no zano ãi hontu aišši, ar hoṛe zair. ");
INSERT INTO rhg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tũwara manušor ḍoilla bisar goro, kintu ãi honokiyor bisar no gori. ");
INSERT INTO rhg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ar zodi o ãi bisar gori, ãr bisar soiyi, kiyollahoile ãi ekela no, kintu ãi ãr Bafor fũwati asi, ze ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ar tũwarar nizor ainot o iyan leka ase ze, duizon mainšor goba soiyi. ");
INSERT INTO rhg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ãi ãr goba dir; ar ze Bafe ãre defeṛaiye, hibaye o ãr goba der.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hitara hibare hodde, \"Tor Baf hoṛe?\" Isaye zuwabe hodde, \"Tũwara na ãre zano otóba ãr Bafore zano, zodi tũwara ãre zanita, toile tũwara ãr Bafore o zanita.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ei hota okkol hibaye dórmogóror uṛanot šikka dibar šomot dan bakšur ḍake hoiye. Ar hibare honokiye no dore, kiyollahoile hehon o hibar ṭaim nu aiye. ");
INSERT INTO rhg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Isaye hitarare abar hodde, \"Ãi zaiyumboi, ar tũwara ãre talaš goriba, kintu tũwara tũwarar gunat moriba. Ãi zeṛe zair tũwara heṛe ai no fariba.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ihudi okkole hodde, \"Hite ki nizor zan nize loibo, ar hetolla hor, 'Ãi zeṛe zaiyum tũwara heṛe ai no fariba.'?\" ");
INSERT INTO rhg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kintu Isaye hitarare hodde, \"Tũwara oilade nisottu, ãi oilamde uworottu. Tũwara ei duniyair kintu ãi ei duniyair no. ");
INSERT INTO rhg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ãi tũwarare hoilam ze tũwara tũwarar guna okkolot moriba; kiyollahoile tũwara zodi biššaš no goro ze ãi oi hiba, tũwara hameka tũwarar guna okkolot moriba.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hitara hodde, \"Tui honnuwa?\" Hibaye hitarare hodde, \"Hiyan ãi tũwarare šuruttu loti howat asi. ");
INSERT INTO rhg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","\"Tũwarar babute hoibar edde bisar goribar ãttu beši kissu ase; kintu ze ãre defeṛaiye, hiba soiyi, ar ãi hibar hãsottu ziyan fuinni hiyan ãi duniyaire hoir.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hibaye ze hibar nizor Bafor babute hor hiyan hitara buzi no fare. ");
INSERT INTO rhg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Toi Isaye hitarare hodde, \"Tũwara zẽtte Adomor Futore uwore tuliba, hẽtte buzi fariba ze ãi oi hiba, ar ãi nizor torfottu hono kissu no gori, bolke Bafe ãre zendilla šikka diye hin okkol hoi. ");
INSERT INTO rhg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ãre defeṛoya ãr fũwati ase, ãre eka eri no zagoi, kiyollahoile ãi hamiša hibar razir ham gori.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hibaye ei hota zehon hoiye, bout kiye hibar uwore biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Isaye, Ihudi okkol zara hibar uwore biššaš ainne, hitarare hodde, \"Tũwara zodi ãr hotar butore tako, toile soiyi tũwara ãr biššaši. ");
INSERT INTO rhg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Toi tũwara soiyire zani fariba, ar he soiyiye tũwarare azadi dibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hitara hibare hodde, \"Ãra Ibrahimor bongšor manuš, ãra honodin honokiyor gulam no oi. Toile tũi kengori hoi faror ze, ãrare azadi diya oibo?\" ");
INSERT INTO rhg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isaye hodde, \"Ãi tũwarare soiyi soiyi hoir, hite ze guna gore hite gunar gulam. ");
INSERT INTO rhg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ar ek gulam hamišalla górot no take, kintu Fut hamišalla hiyanot take. ");
INSERT INTO rhg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hetolla Fute zodi tũwarare azadi de, toile tũwara soiyi azad oiba. ");
INSERT INTO rhg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ãi zani, tũwara Ibrahimor bongšor manuš, kintu tũwara ãre marifelaibolla kušišot aso, kiyollahoile tũwarar dilot ãr hotalla hono zaga nai. ");
INSERT INTO rhg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ãi ãr Bafor hãse zin dekki he babute hoi, ar tũwara hin goro zin tũwara tũwarar bafottu fuinno.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Henot hitara zuwab diye, \"Ãrar baf Ibrahim.\" Isaye hodde, \"Tũwara zodi Ibrahimor fuwain oita, toile tũwara Ibrahimor ham gorita. ");
INSERT INTO rhg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kintu Allar hãsottu ze soiyi ãi funiyore tũwarare hoi boli tũwara ãre marifelaibolla kušiš goror. Ibrahime to endilla ham no gore. ");
INSERT INTO rhg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tũwara tũwarar bafor ham goror.\" Hitara hibare hodde, \"Ãra zoura fuwain no; ãrar ek Baf ase: hiba oilde Allah.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isaye hitarare hodde, \"Allah zodi soiyi tũwarar Baf oito, toile tũwara ãre ador gorita, kiyollahoile ãi Allattu tũwarar eṛe aišši. Ãi nizottu nu aiyi; kintu hibaye ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tũwara ãr hota kiyolla no buzo? Haron oilde iyan ze tũwara ãr hota bordaš gori no faro. ");
INSERT INTO rhg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tũwara tũwarar ek baf šoitanor, ar tũwara tũwarar bafor issa furon gora oilde tũwarar issa. Hite šuruttu loti ekzon kuni, soiyit no take, kiyollahoile hitar butore soiyi nai; hite zẽtte misa hota ho, hite hin hitar nizottu ho, kiyollahoile hite ek misa hoiya edde misa hota hoiyar baf. ");
INSERT INTO rhg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kintu ãi soiyi hoi, ar hetolla tũwara ãre biššaš no goror. ");
INSERT INTO rhg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tũwarar butottu ãre hone gunar hosurbon sabut gori fariba? Ar ãi zodi soiyi hoir, toile tũwara ãre biššaš kiya no goror? ");
INSERT INTO rhg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hite ze Allar, hite Allar kalam fune. Ar tũwara no funor, kiyollahoile tũwara Allar no.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","He Ihudi okkole hibare zuwabe hodde, \"Ãra ki ṭik no hoir ne ze tui ekzon Sameriyo, ar tore bute faiye?\" ");
INSERT INTO rhg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isaye hodde, \"Ãre bute no fa, kintu ãi ãr Bafore šorman gori, ar tũwara ãre ošormani goror. ");
INSERT INTO rhg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ãi ãr nizor tarif no tuwair, kintu ekzon ase ze tuwa, ar hiba oilde bisarhar. ");
INSERT INTO rhg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ãi tũwarare soiyi soiyi hoir, hite ze ãr kalam falon gore, hite honodin moron no dekibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ihudi okkole zuwab diye, \"Ehon, ãra zani farilam ze tore bute faiye; Ibrahim edde nobi okkol morigiyegoi; ar tui hor, hite ze ãr kalam falon gore hite honodin moron no dekibo. ");
INSERT INTO rhg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tui ki ãrar baf Ibrahim, ze morigiyegoi, hibattuwaro mohan? Ar nobi okkol o morigiyegoi. Tui nizore ki mone goros?\" ");
INSERT INTO rhg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isaye zuwabe hodde, \"Ãi zodi nizor tarif nize gori, toile ãr tarif kissu no; ãr Bafe ãr tarif gorer, hiba zar babute tũwara ho, hiba ãrar Allah. ");
INSERT INTO rhg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Zodi o tũwarattu hibar zana nai, ar ãi zodi hoi ze ãi hibare no zani, toile tũwarar ḍoilla ãi o misa hoya oiyum; kintu ãi hibare zani edde hibar kalam falon gori. ");
INSERT INTO rhg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tũwarar baf Ibrahime ãr din saibolla aša loi kuši goijjil; ar hibaye hiyan deikke edde kuši goijje.\" ");
INSERT INTO rhg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hitara hodde, \"Tor umor ehono fõnzaš bosor no o, ar tui Ibrahimore deikkos!\" ");
INSERT INTO rhg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isaye hitarare zuwab diye, \"Ãi tũwarare soiyi soiyi hoir, Ibrahim zormo oibar agottu loti, ãi oi!\" ");
INSERT INTO rhg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Henot hitara hibare mela maribolla fattor feṛai loiye, kintu Isa hitarattu lukaigiyegoi edde dórmogóror uṛanottu baire niyoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Isa aṛi zat maze hibaye ek zormo anda manušore deikke. ");
INSERT INTO rhg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Toi sahabi okkole hibare fusar goijje, hodde \"Rabbi, guna hone goijjede, hite nize ne naki hitar ma bafe, ze hitattu anda zormo owa foijje?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isaye hodde, \"Guna no ite goijje, otóba hitar ma bafe; kintu iyan oiye zene hitar butore Allar ham forhaš oi fare. ");
INSERT INTO rhg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Din zetun ase hetun, ze ãre defeṛaiye, hibar ham ãra gora iyan zoruri. Rait aiyer, zẽtte honokiye ham gori no faribo. ");
INSERT INTO rhg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ãi zetodin duniyait asi, ãi oilamde duniyair nur.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ei hota hoiyore, hibaye meṛit sep felaiyore hodun fũṭ goijje edde hin manušwar sukot lagai diye. ");
INSERT INTO rhg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tarfore hodde, \"Za, Šiloam foirot zai dúifelagoi,\" (ziyanor mani gorile \"defeṛa oiye\" o). Toi hite zaiyore dúifelaiye, edde suke dekat maze firi aišše. ");
INSERT INTO rhg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ḍengór bam gójja okkol edde aro zara hite boiyore horat magitode dekkil, hitara hodde, \"Ite no neki ze boiyore horat magitode?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kiye kiye, oi iba hite hoiye. Ar kiye hodde, \"No, hitare saite hendilla lagedde\" Kintu manušwaye nize hodde, \"Oi, ãi hiba.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hitara fusar goredde, \"Kintu tor suk kengori kuli giyegoi?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hite zuwabe hodde, \"Isa name manušwaye hodun fũṭ banaiye edde ãr sukor uwore lifidiye, ar ãre hodde, Šiloam foirot za, dúifelagoi; ãi zaiyore zehon dúifelaiyi, toi ãi deki faijji.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hitara hodde, \"hiba hoṛe?\" Hite hodde, \"Ãi no zani.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Toi hitara he anda aššilde manušware Foroši okkolor hãse loigiye. ");
INSERT INTO rhg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ze din Isaye fũṭ banaiyore manušwar suk kulidiye hedin aššilde Šabbat. ");
INSERT INTO rhg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hetolla Foroši okkole o hitattu fusar goijje, hite deki kengori faijje. Hite hitarare hodde: \"Hibaye ãr sukgunor uwore fũṭ lifidiye, ar ãi duifelaiyi, toi ãi dekir.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Foroši hoekzone hodde, \"Ei manušwa Allar hãsottu nu aiye, kiyollahoile hite Šabbat falon no gore.\" Ar kiye hodde, \"Ekzon gunagar manuše kengori endilla sinnor ham gori fare?\" Ei bafe hitarar butore baga bagi oiye. ");
INSERT INTO rhg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Toi hitara he anda aššilde manušwattu abar fusar goijje, \"Tui hitar babute ki hos, kiyollahoile hite to tor suk kuli diye\" Manušwaye hodde, \"Hiba ekzon nobi.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ihudi okkole kintu manušwar baf mare ḍaki ani fusar no gore foijjonto hitara biššaš gori no faijjil ze hite age anda aššil, ar ehon deker. ");
INSERT INTO rhg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hitara manušwar baf mare fusar goijje, \"Ite ki tũwarar he fut, ze anda zormo oiye boli tũwara ho? Ehon hite kengori deki farer?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hitar ma bafe zuwab diye, \"Ãra zani iba ãrar fut, ar ite anda zormo oiye. ");
INSERT INTO rhg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kintu ehon hite kengori deki farer hiyan ãra no zani. Ar iyano no zani hiba honnuwa, ze hitar suk kuli diye. Hitattu boyoš oiye, hitattu fusar goro. Hite nizor babute nize hok.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hitar baf maye Ihudi neta okkolor ḍore in okkol hoiye, kiyollahoile Ihudi neta okkol beggune razi aššil ze, ze kiye Isare Messiyah šikar gore, hitare sinagogottu niyolai diya oibo. ");
INSERT INTO rhg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iyanor zoriya hitar baf maye hoiye, \"Hitar boyoš oiye, hitare fusar goro.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Anda aššilde manušware dusorabar ḍaikke edde hitare hodde, \"Tui soiyi hoiyore Allare tarif de. Ãra to zani ze ei manušwa gunagar.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hite hodde, \"Hiba gunagar ne naki no ãi no zani, kintu ãi iyan zani ze, ãi age anda aššilam ar ehon ãi dekir!\" ");
INSERT INTO rhg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Toi hitara fusar goijje, \"Hite tore ki goijje? Tor suk hite kengori kuli diye?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hite zuwab diye, \"Ãi to tũwarare age hoiyi, kintu tũwara no funo. Toile tũwara abar kiyolla fuinto sor? Tũwara o ki hibar biššaši oito sor neki?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Henot hitara hitare kub gozgozaiye edde hodde, \"Tui hitar biššaši, kintu ãra Musar biššaši. ");
INSERT INTO rhg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ãra zani ze Allaye Musa loi hota hoiye, kintu ite hontu aišše hiyan ãra no zani.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Manušwaye hitarare zuwab diye, \"Iyan ekkan ki tajjuiffa ze hiba hontu tũwara no zano, otoso hibaye ãr suk kuli diye. ");
INSERT INTO rhg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ãra zani ze Allaye gunagarore no fune, kintu hite zodi Allah bokto o, ar hibar issa falon gore, hibaye hitare fune. ");
INSERT INTO rhg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Duniyai sirišti oiye loti iyan endilla honodin funa no za ze, honokiye zórmottu loti anda mainšor suk kuli diye. ");
INSERT INTO rhg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hiba zodi Allattu no aito, toile hibaye kissu gori no farito.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hitara hodde, \"Tor zormo ekkubare gunar butore oiyore, ar ãrare šikka dor!\" Bade hitara hitare baire niyolai diye. ");
INSERT INTO rhg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Isaye fuinne ze, hitara manušware bair gori diye, ar hibaye hitare tuwai faiyore hodde, \"Tui ki Adomor Futore biššaš goros ne?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hite zuwab diye, \"Malik, hiba honnuwa? Toi zene ãi hibare biššaš gori fari.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Toi Isaye hitare hodde, \"Tui hibare dekor, ar hibaye tor loi hota hor.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hetunot he manušwaye hodde, \"Malik, ãi biššaš gori\" ar hite hibare soida goijje. ");
INSERT INTO rhg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isaye hodde, \"Bisarolla ãi ei duniyait aišši, zene zara anda hitara deke, ar zara deke hitara anda o.\" ");
INSERT INTO rhg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Foroši okkolor butottu zara hibar fũwati aiššil hitara in okkol fuinne, toi hitara hibare hodde, \"Ãra o ki anda neki?\" ");
INSERT INTO rhg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isaye hodde, \"Tũwara zodi anda oita, toile tũwarattu hono guna no takito; kintu ehon tũwara hor, 'Ãra dekir,' Hetolla tũwarar guna taki giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","\"Ãi tũwarare soiyi soiyi hoir, hite ze soolor zãkot doroza bai no gole, kintu oinno ḍak bai zai faraiyore gole, hite ekzon sur edde ekzon ḍahait. ");
INSERT INTO rhg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kintu ze doroza bai gole, hite oilde soolgunor soroya. ");
INSERT INTO rhg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Doroza fahara doyaye hiballa doroza kuli de, ar soolgune hibar abaz fune, ar hibar nizor soolgunore hibaye nam dori ḍake edde fõt dehai barkule loiza. ");
INSERT INTO rhg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ar zehon hibaye hibar nizor soolgunore barkule niyolaiye, hiba hitarar age age za, edde soolgune hibar fisa lo, kiyollahoile hitara hibar abaz sine. ");
INSERT INTO rhg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kintu hitara osina ekzonor fise no loibo; bolke hitar hãsottu dái zaiboi, kiyollahoile osina mainšor abazore hitara no sine.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isaye ei mesal kahanigan hitarare hoiye, kintu hibaye hitarare ki ze hoiye, hiyan hitara no buze. ");
INSERT INTO rhg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hetolla Isaye abar hodde, \"Ãi tũwarare soiyi soiyi hoir, soolgunolla ãi oilamde he doroza. ");
INSERT INTO rhg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Beggun zara ãr age aišše, hitara sur okkol edde ḍahait okkol, kintu soolgune hitarare no fune. ");
INSERT INTO rhg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ãi doroza; ze ãr butottu di gole, hite uddar oibo edde butore aibo edde bare zaibo, ar sori háibolla zaga faibo. ");
INSERT INTO rhg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sur aiye šude zene hite suri, kun edde dongšo gori fare; ãi aiššyi, zene hitara zibon fa edde zaf di forefan gori fa. ");
INSERT INTO rhg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","\"Ãi he bala soolsoroya. Bala soolsoroyaye soololla hitar nizor zibon šebi de. ");
INSERT INTO rhg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kintu betondari, ze sool soroya no, ar sool o zin hitar nizor no, ar so, hite zehon genḍa bag aiyedde deker, soolgun eri dái zargoi; toi bage hinore súlai loizagoi edde šiṛašiṭṭa goride, ");
INSERT INTO rhg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","kiyollahoile hite ekzon betondari, hitattu soolgunolla hono dorod nai. ");
INSERT INTO rhg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","\"Ãi oilamde he bala soolsoroya; ãi ãrgunore sini ar ãrgune o ãre sine, ");
INSERT INTO rhg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","zendilla ãr Bafe ãre sine, ar ãi Bafore sini, soololla ãi ãr zibon šebi di. ");
INSERT INTO rhg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ãttu aro sool okkol ase, zin ei zãkor no, hitarare o ãttu ana foribo edde hitara o ãr abaz funibo, ar henot ugguwa zãk edde ekzon soolsoroya oibo. ");
INSERT INTO rhg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ãr Bafe ãre ador gore, kiyollahoile ãi ãr zibon šebi di, zene hiyan ãi abar uwafes firai loi fari. ");
INSERT INTO rhg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ãr foran honokiye no lor, bolke ãi nize hiyan šebi dir, ar hiyan šebi dibar kemota ãttu ase; edde hiyan abar loibar kemota o ãttu ase; ei hokum ãr Bafottu ãi faiyi.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ei hota okkolor zoriya Ihudi okkolor butore abar baga bagi oiye. ");
INSERT INTO rhg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hitarar bout kiye hodde, \"Hitar butore ek but ase, hite fool. Tũwara hitar hota kiyolla funor?\" ");
INSERT INTO rhg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ar kiye hodde, \"Ekzon bute faiya manuše endilla hota okkol no ho. Bute ki anda mainšor suk kuli di fare?\" ");
INSERT INTO rhg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tarfore hannuka id aišše, ar hẽtte šit hal. ");
INSERT INTO rhg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Isaye dórmogóror butore badša Soloimanor haissarat ãṛa ãṛi gorer. ");
INSERT INTO rhg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hẽtte Ihudi okkole hibar sairo ḍakottu zoma oiye edde hibaye hodde, \"Tui ãrare ar hoto din šondot rakibi? Tui zodi Messiyah, toile ãrare ho.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isaye zuwabe hodde, \"Ãi to tũwarare hoiyi, kintu tũwara biššaš no goro. Ãr bafor name ze ham okkol ãi gori, hine ãr babute goba de, ");
INSERT INTO rhg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintu tũwara biššaš no goro, kiyollahoile tũwara ãr sool no. ");
INSERT INTO rhg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ãr sool okkole ãr abaz fune, ãi hitarare zani, edde hitara ãr fisa lo. ");
INSERT INTO rhg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ãi hitarare akeri zibon di, edde hitara honodin dongšo no oibo, ar honokiye ãr hatottu hitarare hari loi no faribo. ");
INSERT INTO rhg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ãr baf, ze hitarare ãre diye, hiba oilde hár kissuttuwaro mohan, ar honokiye ãr Bafor hatottu hari loi no faribo. ");
INSERT INTO rhg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ãi edde Baf ek.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hetunot Ihudi okkole hibare maribolla abar fattor feṛailoiye, ");
INSERT INTO rhg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","kintu Isaye hitarare hodde, \"Ãi ãr Bafor hentu tũwarare beši bala ham okkol gori dehaiyi. Hinor butore honnanolla tũwara ãre fattor mariba?\" ");
INSERT INTO rhg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ihudi okkole zuwab diye, \"Hono bala hamolla tore ãra fattor no marir, kintu kuferilla, haron tui ekzon manuš oiyore, nizore Allah dabi goror.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isaye hodde, \"Tũwarar ainot ki endilla leka nai ne, 'Ãi hoilam, tũwara allah okkol'? ");
INSERT INTO rhg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Allar kalam zarar hãse aišše hitarare zodi hibaye 'Allah okkol' ho, ar Pak kitabor kalam bad oi no fare. ");
INSERT INTO rhg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Henoile, zare Bafe fobitro goijje edde duniyait defeṛaiye, tũwara ki hoiba, ze 'Tui kuferi goror' kiyollahoile ãi hoilam ze 'ãi Allar Fut'? ");
INSERT INTO rhg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ãr Bafor ham zodi ãi no gori, toile tũwara ãre biššaš no goijjo. ");
INSERT INTO rhg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kintu ãi zodi gori, tũwara ãre biššaš no gorile o, hamgunore oile biššaš goro, zene tũwara zani faro edde buzi faro ze, Baf ãr butore, ar ãi Bafor butore asi.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Abar hitara Isare doitto kušiš goijje, kintu hiba hitarar hatottu harigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tarfore Isa abar Zordanor ofarot giye, zeṛe Yahyaye torikotor gusol dito. Hiba heṛe taikke. ");
INSERT INTO rhg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bout manuš okkol hibar hãse aišše, edde hodde, \"Yahyaye hono keramoti ham no gore, tarfore o kintu hibaye ei manušwar babute zin zin hoiye hin beggun soiyi.\" ");
INSERT INTO rhg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ar heṛe bout manuš okkol Isar biššaši oiye. ");
INSERT INTO rhg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betaniyat ekzon ošuikka manuš aššil, nam Lazarus; ar hite Moriyam edde hibar boin Martár farar manuš. ");
INSERT INTO rhg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Iba he Moriyam, ze Malikore kušbo tel loi ḍoli dil, ar hibar nizor sul loi ṭeng fũsi dil, zar bái Lazarusottu ehon ošuk.) ");
INSERT INTO rhg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hetolla boinain okkole Isar hãse hóbor defeṛaiye, \"Malik, zar loi õne kuši hitattu ehon ošuk.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Isaye ei hota funiyore hodde, \"Ei ošuk moribolla no o, kintu Allar tarifolla, zene iyanor duwara Allar Fut mohimawala oi fare.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Isaye Martá, hibar boin edde Lazarusore ador gorito. ");
INSERT INTO rhg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hibaye zehon hitattu ošuk oiyede fuinne, hiba zeṛe aššil heṛe aro dui din taigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tarfore hibaye sahabi okkolore hodde, \"Aiyo, ãra abar Ehudiyat zai.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sahabi okkole hibare hodde, \"Rabbi, ei kissu din age no ne Ihudi okkole õnore fattor maitto saiye, ar õne abar heṛe zodde?\" ");
INSERT INTO rhg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isaye zuwabe hodde, \"Dinot ki baro gonḍa nai ne? Ar hite ze dinot solafira gore, hite ujaṭ no há, kiyollahoile hite ei duniyair fohor deke. ");
INSERT INTO rhg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ar hite ze raitta solafira gore, hite ujaṭ há, kiyollahoile hitar butore fohor nai.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hibaye in okkol hoiye, in bade hibaye hitarare hodde, \"Ãrar bondu Lazarus gumot foijje, kintu ãi hitare gumottu tulibolla heṛe zair.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Toi sahabi okkole hodde, \"Malik, hite gum giyede oilede hite bala oi zaiboi.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kintu Isaye hitar moronor babute hoilde, kintu hitara ṭaijje hibaye amfam gumor hota hor. ");
INSERT INTO rhg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Toi Isaye foriškar gori hoiye, \"Lazarus morigiyegoi, ");
INSERT INTO rhg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ar tũwaralla hoi ãi kuši ze ãi heṛe nu aššilam, zene tũwara biššaš gori faro; hetolla aiyo, ãra Lazarusor hãse zai.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hetunot Tomas, (zare Didymus ho) hibaye oinno fũwajja sahabi okkolore hodde, \"Aiyo, ãra o zai, zene ãra o hitar fũwati mori fari.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Isa aiyore zani faijje ze, Lazarus hẽtte hoborot asede sair din oiye. ");
INSERT INTO rhg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniya aššilde Zeruzalemor hãsa hãsi, onumanik tin kilomiṭaror fõt. ");
INSERT INTO rhg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ihudi okkolor butottu boute Martá edde Moriyamor hãse aišše, zene hitarar báiyor babute šantona di fare. ");
INSERT INTO rhg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martáye zehon fuinne ze Isa aiyer, hiba zaiyore hibar loi deha goijje, ar Moriyam gorot boiṛa taigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martáye Isare hodde, \"Malik, õne zodi eṛe takita, toile ãr báiwa no morito. ");
INSERT INTO rhg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kintu ãi zani, õne Allar hãse ze kissu saiba, hin Allaye õnore dibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isaye hibare hodde, \"Tor bái abar uṛibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martáye hodde, \"Ãi zani šeš hale uwafes zindar šomot hite o uṛibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isaye hodde, \"Ãi oilamde he uwafes zinda edde he zibon. Hite ze ãr uwore biššaš ane hite morile o zinda takibo; ");
INSERT INTO rhg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ar hite ze zinda edde ãre biššaš gore hite hono din no moribo, iyan ki biššaš goros?\" ");
INSERT INTO rhg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hibaye hodde, \"Oi, Malik, ãi biššaš gori õne he Messiyah, Allar Fut, ze duniyait aibar hota.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ei hota hoi Martá zaiyore hibar boin Moriyamore gufone ḍakiyore hodde, \"Malik eṛe ase, ar tore ḍaker.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Moriyame ei hota funiyore, toratori uiṭṭe edde hibar hãse giye. ");
INSERT INTO rhg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Isa hetunot o farar butore no aiye, kintu ehono he zagat zeṛe Martáye hiba loi deha oil. ");
INSERT INTO rhg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ze Ihudi okkol Moriyamor górot aššil edde hibare šantona diyat aššil, hitara dekedde Moriyam toratori uṛi baire giye, ar hitara o hibar fise fise giye, ar mone goijje ze hibaye hoboror ḍake handito zar boli. ");
INSERT INTO rhg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Toi Moriyam, Isa zeṛe aššil, hiba heṛe aišše edde hibare dekiyore hibar ṭengot foijje edde hodde, \"Malik, õne zodi eṛe takita, toile ãr bái no morito.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Toi Isaye hibar handani edde hibar fũwati ze Ihudi okkol aššil, hitara handani dekiyore hibar dilor butore hoisali oiye, toi hibaye hodde, ");
INSERT INTO rhg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","\"Tũwara hitare hoṛe raikko?\" Hitara hodde, \"Malik, aiyo sogai.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Isaye hainde. ");
INSERT INTO rhg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Toi Ihudi okkole hodde, \"So, hiba hitare loi hondilla kuši.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kintu hitarar hodune hodde, \"Iba hiba no ne, ze he anda manušwar suk ze kuli diye, hibaye ki ite no morefan gori no farito ne?\" ");
INSERT INTO rhg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Henot Isar dilot abar o hoisali oiye edde hoboror hãse aišše, ar hiba aššilde ugguwa guha, ar hiyanor uwore ugguwa šil aššil. ");
INSERT INTO rhg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isaye hodde, \"Šilgan šoraifelo.\" morigiyegoide hitar boin Martáye hodde, \"Malik, ehon hitattu baš uṛer, kiyollahoile hite heṛe sair dinna mora.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Isaye hibare hodde, \"Ãi ki tore no hoi ne, ze tui zodi biššaš goros, toile tui Allar mohima dekibi?\" ");
INSERT INTO rhg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tarfore hitara šilgan šoraifelaiye. Isaye hibar suk uwor mikka tuille edde hodde,\"Baf, ãi tũware šukuriya gori, ze tũi ãre fuinno. ");
INSERT INTO rhg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ar ãi zani ze tũi ãre hamiša funo; kintu eṛe ze manuš okkol tiyaiye hitaralla ãi ei hota hoir, zene hitara ekin gore, ze tũi ãre defeṛaiyo.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","In okkol hoi bade, hibaye ek zur abaz loi hodde, \"Lazarus, niyoli ai.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Henot morawa niyoli aišše; hitar hat ṭeng aššil kafonor hor loi banda, ar hitar mukot aššil ekkan gamsa loi banda. Isaye hitarare hodde, \"Hitare kuli do, hitare zaito do.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bout Ihudi okkol zara Moriyamor hãse aiššil, edde Isaye ki goijje hin dekiyore, hitara hibar uwore biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kintu hitarar kiye kiye Foroši okkolor hãse giye, edde Isaye ki goijje hin hitarare hoiye. ");
INSERT INTO rhg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Toi ḍõr imam edde Foroši okkole ḍõr šoba Sanhedrinore ekottro goriyore hodde, \"Ãra ehon ki goriyum? Ei manušwaye bout sinnor ham okkol gorer. ");
INSERT INTO rhg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ãra zodi itare endilla solito di, toile beggune hitar uwore biššaš anibo; ar Romiyo okkol aiyore ãrar paki zaga edde ãrar zati dunigun hari loibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ar hitarar butore ekzon, Kaifas name, he bosoror ḍõr imam, hibaye hitarare hodde, \"Tũwara kissu no zano. ");
INSERT INTO rhg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ar bafi no sor ne ze, iyan ãralla bala oibo, mainšolla ekzon manuš more, edde guṛa zati dongšo no o.\" ");
INSERT INTO rhg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ei hota hite nizottu hoiye hen no, kintu hite he bosoror ḍõr imam hisabe hite nobi hisabe hota hoiye, ze Isa zatilla moribo, ");
INSERT INTO rhg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","šude he zatilla no, bolke he Allar fuwain okkololla o, zara šiṛašitta oi roiye, zene hibaye hitarare dola gore edde ek gore. ");
INSERT INTO rhg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","He dinottu loti hitara felain goijje ze hitara hibare marifelaibo. ");
INSERT INTO rhg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hetolla Isaye Ihudi okkol loi ar kulasa solafira no gore, kintu hentu zaigoiyore bošoti sara elehar ḍake Efraim name ekkan šohorot giye, zeṛe hiba hibar sahabi okkolore loi taikke. ");
INSERT INTO rhg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hẽtte Ihudi okkolor uddar id hãse aiššil, ar boute uddar idor age hitara nizore paksaf goribolla dešottu uwore Zeruzalem giye. ");
INSERT INTO rhg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hitara Isare tuwat aššil, edde dormogórot tiyaiyore ekzone oinnozonore hodde, \"Tũwarattu ken lage? Hiba idot nu aibo ne ki?\" ");
INSERT INTO rhg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ḍõr imam edde Foroši okkole hokum dilo ze, Isa hoṛe ase hiyan zodi honokiye zane hóborgan hitarare de, zene hitara Isare dori fare. ");
INSERT INTO rhg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Uddar idor só din age Isa Betaniyat aišše, heṛe he Lazarus aššil, zare hibaye morattu tuille. ");
INSERT INTO rhg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Heṛe hiballa ek hánar entezam gora oiye, ar Martáye hána bari dil, ar Lazarus o hibar fũwati hánar ṭebilot boiššilde hitarar maze. ");
INSERT INTO rhg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hen šomot Moriyame ada liṭar beši dami, haṭi ator aniyore Isar ṭengot ḍoli diye edde hibar sul loi hibar ṭeng fũsi diye. Ar he atoror kušboye gór bori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iskariyoti Ehudah, hibar sahabi okkolor ekzon, ze hiba loi beimani goribo, hite endilla hodde, ");
INSERT INTO rhg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","\"Ei ator in tin šot denar di besiyore kiyolla gorib okkolore diya no or?\" ");
INSERT INTO rhg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hitattu goribolla dorod asede hiyan bafiyore hite ei hota hoiyede no, kintu hite aššilde ek sur, ar ṭiyar beg hitar hatot takitode hisabe, zin heṛe raka oito hite hentu loifelaito. ");
INSERT INTO rhg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Isaye hodde,\"Hiba loi hen no goijjo! Hibaye hin ãr hoboror dinolla raikkede. ");
INSERT INTO rhg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gorib okkol to hamiša tũwarar fũwati ase, kintu ãre hamiša tũwara no faiba.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Isa Betaniyat ase zani fariyore Ihudi okkolor ek ḍõr dol heṛe aišše, hitara šude Isare saito nu aiye, bolke Lazarus, zare hibaye morattu tuille, hitare o saito aišše. ");
INSERT INTO rhg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ar ḍõr imam okkole felain goijje zene hitara Lazarusore o marifelai fare, ");
INSERT INTO rhg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kiyollahoile hitalla buli Ihudi okkolor boute heṛe zat aššil edde Isare biššaš gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tarforor din idot falon goitto aiššede ek dõr mainšor dole Isa Zeruzalem aiyer funiyore, ");
INSERT INTO rhg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","hitara hazu fatar ḍeila okkol loiye edde dola oibolla niyoli giye, ar guzori hoiye, \"Hosanna!\" \"Rahamoti hiba ze mabudor name aiyer, Israilor badša!\" ");
INSERT INTO rhg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ar Isaye ugguwa gadar so faiye edde hibar uwore boišše, iyan zendilla leka ase: ");
INSERT INTO rhg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","\"O Sion hoinna, no ḍorais, sa, tor badša aiyer, gadar sor fiṛot boiyore.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hibar sahabi okkole in okkol foila buzi no fare, kintu Isa zehon mohimawala oiye, hẽtte hitarattu monot foijjil ze in okkol hibar babute leka aššil, edde manuš okkole hibare in okkol goijje. ");
INSERT INTO rhg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Isa Lazarusore hoborottu aibolla ḍaikkede edde morattu tuillede šomot ze manuš okkol hibar fũwati aššil, hitara he babute goba diyat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ar hetolla bout manuš okkole zaiyore hiba loi dola oiye, kiyollahoile hibaye ei sinnor ham goijjede hitara fuinnil. ");
INSERT INTO rhg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Toi Foroši okkol ekzone ar ekzonore hodde, \"Tũwara dekor, tũwarar hono kissu lab no or; so, duniyai udda hitar fisa loiye.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Idot ebadot goitto aiššede hitarar maze ho ekzon Girikiyo aššil. ");
INSERT INTO rhg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hitara Galilor Betsaidar Filipor hãse aišše, edde hibare foriyad goijje, \"Ustad, ãra Isare saito sai.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe aiyore Anderiyazore hoiye, toi Anderiyaz edde Filipe Isare hoiye. ");
INSERT INTO rhg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isaye zuwabe hodde, \"Adomor Futore mohimaola gora oibar ṭaim aišše. ");
INSERT INTO rhg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ãi tũwarare soiyi soiyi hoir, gĩyur biz zodi meṛit foriyore zodi no more, toile hiba ugguwa dana take; kintu zodi more, toile hibaye beši gula dora. ");
INSERT INTO rhg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hite ze nizor foranore beši ador gore, hite hiyan haraibo; ar hite ze nizor zibonore ei duniyait hingša gore, hite hiyan akeri zibonolla basaibo. ");
INSERT INTO rhg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hite ze ãr šeba goribo, hite ãr fisa lok, ar ãi zeṛe, heṛe ãr šeba goroya o oibo; ar hite ze ãr šeba gore, ãr Bafe hitare šorman dibo. ");
INSERT INTO rhg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","\"Ehon ãr dil ferešani oiye; iyanot ki ãi ki en hoiyum ne? 'Baf, ei ṭaimottu ãre basao'? no, bolke ai aiššilamde to ei ṭaimolla. ");
INSERT INTO rhg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baf, tũwar nam mohimawala goro!\" Hetunot asmanottu ek abaz aišše, \"Ãi hiyan mohimawala goijji, ar ãi abar hiyan mohimawala goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Heṛe tiyat aššilde manušor dole iyan fuinne edde hodde, \"Ḍeba mater;\" ar kiye hor, \"Hono ek firistaye hibar loi hota hor.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Isaye zuwabe hodde,\"Ei abaz ãlla oiyede no, kintu tũwaralla. ");
INSERT INTO rhg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ehon oilde ei duniyair bisar; ehon ei duniyair šašon goroyare baire felai diya oibo. ");
INSERT INTO rhg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ar ãi, ãre zẽtte zobinottu tula oibo, hár manušore ãi ãr mikka ṭaniyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ar hibaye ei hotar duwara sin diye ze ki moron hibaye moribo. ");
INSERT INTO rhg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mainšor dole hodde, \"Ãra Torar ainottu fuinni ze Messiyah sirohal takibo; toile tũi kene hoi faror, 'Adomor Futore uwore tula owa foribo'? Toile iba hon 'Adomor Fut'?\" ");
INSERT INTO rhg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isaye hitarare hodde, \"Aro olfo ṭaimolla šude he nur tũwarar fũwati ase; he nur tũwarar fũwati takite ãṛo, zene andar aiyore tũwarar uwore no fore; ar hite ze andarot sole, hoṛe zar hiyan hite no zane. ");
INSERT INTO rhg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nur tũwarar hãse takite nuror uwore biššaš ano, zene tũwara nuror fũwain oi faro.\" Ei hota hoiya oi bade Isaye hitarar hãsottu giyegoi edde hitarattu gufon oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zodi o Isaye hitarar sarme eduggun keramoti ham okkol goijje, tarfore o hitara hibar uwore biššaš no ane. ");
INSERT INTO rhg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iyan oiye zendilla Esaiya nobiye hoilde hota furon o: \"Malik, ãrar diya hóbor hone biššaš goijje, Har hãse Malikor ḍũwa forhaš oiye?\" ");
INSERT INTO rhg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Etolla hitara biššaš no gore, kiyollahoile, zendilla Esaiyaye aro hor: ");
INSERT INTO rhg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"Hibaye hitarar suk anda gori diye, ar hitarar dilore doro gori diye, zene hitara suk diyore no deke, ar hitarar dile o no buze, ar uwafes no fire, ar ãi hitarare aram goritam.\" ");
INSERT INTO rhg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esaiyaye in okkol hoiye, kiyollahoile hibaye Isar mohima dekkil edde hibar babute hoil. ");
INSERT INTO rhg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tarfore o neta okkolor butore boute hibar uwore biššaš ainne, kintu Foroši okkolor ḍore šikar no gore, ze hitarare sinagogottu niyolai dibo; ");
INSERT INTO rhg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","kiyollahoile hitara Allattu tarifottuwaro mainšottu tarifore beši muhabbot gorito. ");
INSERT INTO rhg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Bade Isaye guzori uiṭṭe, \"Hite ze ãr uwore biššaš ane, hite ãr uwore no, kintu ze ãre defeṛaiye, hibar uwore biššaš ane. ");
INSERT INTO rhg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ze ãre deke, hite hibare deke, ze ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ãi ei duniyait nur hisabe aišši, zene ze kiye ãr uwore biššaš ane, hite andarot no take. ");
INSERT INTO rhg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","\"Hite ze ãr kalam fune edde hin falon no gore, ãi nize hitar bisar no gori, kiyollahoile ãi duniyair bisar goribolla no, bolke duniyaire uddar goribolla, aišši. ");
INSERT INTO rhg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ze ãre hela gore edde ãr hota no gose, hitalla ek bisarhar ase; ãi ze kalam hoiyi, šeš dinot hiyane hitar bisar goribo. ");
INSERT INTO rhg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kiyollahoile ãi to nizottu hono kissu no hoi, kintu ki howa foribo edde kengori howa foribo, hin Baf ze ãre defeṛaiye, hibaye ãre hokum diye. ");
INSERT INTO rhg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ar ãi zani ze, hibar hokum oilde akeri zibon; hetolla ãi zin hoi, Bafe ãre zendilla hoiye, hendilla hoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Uddar idor ekka gori age, Isa ei duniyaittu hibar Bafor hãse zaibar ṭaim aišše zaniyore, ei duniyait zara hibar nizor manuš aššil, zarare hibaye beši ador gorito, hitarare hibaye šeš foijjonto ador goijje. ");
INSERT INTO rhg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ar raitor hána haibar ṭaimot, hibare dorai dibolla šoitane Simonor fut Iskariyoti Ehudar dilot issa zuhai dil. ");
INSERT INTO rhg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isattu zana aššil ze, Bafe hár kissu hibar hatot diye, ar hiba Allar torfottu aišše, edde hiba Allar hãse firi zargoi; ");
INSERT INTO rhg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","toi hiba hánar ṭebilottu uiṭṭe, edde uworor hoorgan kulifelaiye, ar ekkan toila loiyore nizor kĩyailot beraiye. ");
INSERT INTO rhg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tarfore hibaye ek galat fani ḍaille edde hibar sahabi okkolor ṭeng duwai diya šuru goijje edde hibaye kĩyailot ze toila berail hiyan loi ṭeng fũsi diye. ");
INSERT INTO rhg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Toi hiba Simon Fitoror ḍake zehon aišše, toi hite hodde, \"Malik, õne ãre ṭeng duwai diba?\" ");
INSERT INTO rhg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zuwabe Isaye hitare hodde, \"Ãi zin gorir hin tui ehon buzi no faror, kintu fore iyan buzi faribi.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Fitore hodde, \"No, õne honodin ãr ṭeng no duiyo.\" Zuwabe Isaye hodde, \"Zodi tore ãi no dui, toile ãr loi tor hono bag nai.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Fitore hibare hodde, \"Malik, toile šude ãr ṭeng no, kintu ãr hat edde mata o dui do.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isaye hitare hodde,\"Ze gusol goijje, ṭeng duwa sara hitattu ar hono kissur dorhar nai, hitar agagura foriškar, hite Pak fobitro. Ar tũwara Pak fobitro, kintu beggune no.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kiyollahoile ze hibare dorai dibo hitare hibaye sinito, hetolla hibaye \"tũwara beggune foriškar no\" hen hoiyede. ");
INSERT INTO rhg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ar zehon hitarare ṭeng duwai diya šeš oiye, toi hibaye hor gat diye bade boišše. Toi hibaye hitarare hodde, \"Ãi tũwarare ki gorilam zano ne? ");
INSERT INTO rhg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tũwara ãre ustad, Malik, hoi ḍaki tako, ar gorode hiyan o bala, kiyollahoile ãi hen oi. ");
INSERT INTO rhg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bala, ãi malik edde ustad oi bade o tũwarar ṭeng duwai dilam, henot tũwara o ekzone ar ekzonore ṭeng duwai diya zoruri. ");
INSERT INTO rhg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kiyollahoile ãi tũwarare mesal dehailam, zene ãi tũwaralla zen goijji, tũwara o hendilla goro. ");
INSERT INTO rhg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ãi tũwarare soiyi soiyi hoir, gulam hitar nizor malikottuwaro boro no, ze defeṛaiye hibattuwaro zare defeṛa oiye hiba boro no. ");
INSERT INTO rhg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ehon, tũwara in okkol zano, ar hin okkol zodi goro, toile tũwarar mubarok. ");
INSERT INTO rhg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","\"Ãi tũwara beggunor hota no hoir; ãi hontarare ãlla basona goijji ãi zani. Kintu kitabor ei kalam furon owa forer: 'Ze ãr ruṭi hár, hite ãr berudde formuri tuille.' ");
INSERT INTO rhg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","\"In goṭibar agottu ãi tũwarare hoi rakir, zene zẽtte in goṭibo hẽtte tũwara biššaš goro ze, ãi hiba. ");
INSERT INTO rhg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ãi tũwarare soiyi soiyi hoir, ãi zare defeṛai, hitare ze gose, hite ãre gose, ãre ze gose, hite hibare gose, ze ãre defeṛaiye.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ei hota hoi bade Isar dilot hoisali oiye, ar goba diye, \"Ãi tũwarare soiyi soiyi hoir, tũwarar butottu ekzone ãre dorai dibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sahabi okkole ekzone ar ekzonor uzu sa šuru goijje, ar ṭik buzi no faijjil hibaye har babute hoiyede. ");
INSERT INTO rhg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hetunot Isar sahabi okkolor butottu ekzon, zare Isaye muhabbot gorito, hite hibar kulot elan di boiššil. ");
INSERT INTO rhg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hetunot Simon Fitore išara goijjil edde hodde, \"Hibaye zar babute hor, hiba honnuwa?\" ");
INSERT INTO rhg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hetunot hite Isar mikka zúkdiyore hodde, \"Malik, iba honnuwa?\" ");
INSERT INTO rhg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isaye zuwab diye, \"Ei ruṭir ṭuragan buraiyore ãi zare diyum, iba oilde hite.\" Toi hibaye ruṭir ṭuragan buraiyore Iskariyoti Simonor fut Ehudare diye. ");
INSERT INTO rhg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ehudaye ruṭir ṭuragan fai mottor Šoitan hitar butore góille. Isaye hitare hodde, \"Tui zin goribi hin toratori gor.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hána haito boiššede hitarar honokiye buzi no fare hon bafe hibaye hitare iyan hoiye. ");
INSERT INTO rhg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ehudar hãse ṭiyar tolir zimma aššilde hetolla, kiye kiye mone goijje, Isaye hitare idolla zin zin lage kini angoi otóba gorib okkolore kissu dan goribolla hor. ");
INSERT INTO rhg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ruṭir ṭuragan loi mottor hite hehon baire giye. Ar hẽtte aššilde rait. ");
INSERT INTO rhg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Hite zaigoi bade, Isaye hodde, \"Ehon Adomor Fut mohimawala oiye, ar Allah hibar butore mohimawala oiye. ");
INSERT INTO rhg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Allah zodi Adomor Futor butore mohimawala oiye, hetunot Allaye o hibare hibar nizor butore mohimawala goribo, ar hara hibare mohimawala goribo. ");
INSERT INTO rhg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","\"Ãr fuwain okkol, ehon o olfo ṭaimolla, tũwarar fũwati ãi asi. Tũwara ãre tuwaiba, ar ãi Ihudi okkolore zen hoilam, hendilla tũwarare ãi ehon hoir: Ãi zeṛe zair, heṛe tũwara ai no fariba. ");
INSERT INTO rhg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","\"Ek noya hokum ãi tũwarare dir: Tũwara ekzone ekzonore ador goro. Ãi zendilla tũwarare ador goijji, tũwara o hendilla ekzonore ekzone ador goro. ");
INSERT INTO rhg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tũwara zodi ekzonore ekzone ador goro, toile beggune zanibo ze tũwara ãr sahabi okkol.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Fitore hibare hodde, \"Malik, õne hoṛe zaibagoide?\" Zuwabe Isaye hodde, \"Ãi zeṛe zair, heṛe tui ehon ãr fisa loi ai no faribi, kintu fore tui o heṛe aibi.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Fitore hodde, \"Malik, ãi ehon kiyolla õnor fisa loi no fariyumde? Ãi õnolla ãr foran diyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Zuwabe Isaye hodde, \"Tui ki soiyi ãlla tor foran dibi? Ãi tore soiyi soiyi hoir, rata kuraye bak no dite, tui ãre tin bar ošikar goribi! ");
INSERT INTO rhg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","\"Tũwarar dil ferešan no ok, Allare biššaš goro, ar ãre o biššaš goro. ");
INSERT INTO rhg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ãr bafor górot takibar zaga beši ase; ar zodi no takito, ãi tũwarare hoitam; ãi tũwaralla zaga tiyar goitto zair. ");
INSERT INTO rhg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ar ãi zẽtte zaiyum edde tũwaralla zaga tiyar gori, ãi abar aiššum edde tũwarare ãr hãse loi zaiyum, zene ãi zeṛe, tũwara o heṛe oi faro. ");
INSERT INTO rhg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ãi hoṛe zair heṛe zade fõt to tũwara sino.\" ");
INSERT INTO rhg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ṭomase hibare hodde, \"Malik, õne hoṛe zorgoi hiyan ãra no zani, ar henot kengori fõt zaniyum?\" ");
INSERT INTO rhg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isaye hodde,\"Ãi oi he fõt, he soiyi edde he zibon, ãr butottu di no gile, honokiye Bafor hãse ai no fare. ");
INSERT INTO rhg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Zodi tũwara ãre zanita, toile ãr Bafore o zanita, ar ehon oite tũwara hibare zainno edde hibare deikko.\" ");
INSERT INTO rhg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe hodde, \"Malik, Bafore ãrare deho, henot hiyan ãralla beši oibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isaye hitare hodde, \"Filip, ãi eto din tũwarar fũwati asi, ar tarfore o ki ãre no sinili? Hite ze ãre deikke hite Bafore o deikke. Tui tarfore o ken gori hoi faror, 'Bafore ãrare dehao'! ");
INSERT INTO rhg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tui ki biššaš no goros ze ãi Bafor butore asi edde baf ãr butore asede? Ãi tũwarare ze hár hota okkol hoi, hin ãr nizottu no hoi, kintu Baf, ze ãr butore taker, hiba nize ham gore. ");
INSERT INTO rhg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ãre biššaš gor, ze ãi Bafor butore, ar Baf ãr butore ase; ar no oile, ãr hamolla oile o biššaš gor. ");
INSERT INTO rhg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ãi tũwarare soiyi soiyi hoir, hite ze ãr uwore biššaš ane, ãi ze hár ham okkol gori, hite o he ham okkol goribo, oi, in okkolottuwaro ḍõr ham okkol hite goribo, kiyollahoile ãi Bafor heṛe zairgoi. ");
INSERT INTO rhg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ar tũwara ãr name za kissu saiba, ãi hin goriyum, zene Bafore Futor butore mohimawala gora o. ");
INSERT INTO rhg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ãr name zodi tũwara hono kissu so, ãi hiyan goriyum. ");
INSERT INTO rhg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","\"Tũwara zodi ãre ador goro, toile ãr hokum okkol falon goro. ");
INSERT INTO rhg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ãi ãr Bafottu saiyum, ar hibaye ar ekzon modot goroya defeṛaibo, ze tũwarar fũwati hamiša takibo. ");
INSERT INTO rhg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hiba soiyir Ruh, duniyaiye hibare gosi no fare. Kintu tũwara hibare sino, kiyollahoile hiba tũwarar fũwati take ar tũwarar dilot takibo. ");
INSERT INTO rhg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ãi tũwarare etim raki no zaiyum, ãi tũwarar hãse aiššum. ");
INSERT INTO rhg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hara, duniyaiye ãre ar no dekibo, kintu tũwara dekiba, kiyollahoile ãi zinda asi, tũwara o zinda takiba. ");
INSERT INTO rhg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","He din tũwara buzi fariba ze, ãi Bafor butore, ar tũwara ãr butore aso, edde ãi tũwarar butore asi. ");
INSERT INTO rhg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hite ze ãr hokum zane edde falon gore, hite ãre ador gore; ar ze ãre ador gore, ãr Bafe o hitare ador goribo. Oi, ãi o hitare ador goriyum, edde nizore hitar hãse forhaš goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hetunot Ehudaye (Iskariyote no) hibare hodde, \"Malik, õne šude ãrar hãse kiyolla forhaš goribade, duniyair hãse kiyolla no?\" ");
INSERT INTO rhg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isaye zuwab diye, \"Hite ze ãre ador gore, hite ãr kalam falon goribo; ar ãr Bafe hitare ador goribo, edde ãra hitar hãse aiššum ar hitar hãse bošoti goijjum. ");
INSERT INTO rhg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hite ze ãre ador no gore, hite ãr kalam falon no gore; ar ze kalam okkol tũwara funor, hin ãr no, kintu Bafor, ze ãre defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","\"In okkol ãi tũwarar fũwati takite hoilam. ");
INSERT INTO rhg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kintu he Modotgoroya, Pak Ruh, zare Bafe ãr name defeṛaibo, hibaye tũwarare hár kissu šikka dibo edde ãi tũwarare zin zin hoiyi hin okkol beggun tũwarare monot gori dibo. ");
INSERT INTO rhg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ãi tũwaralla šanti raki zair; ãr šanti ãi tũwarare dir; duniyaiye dede he mozin ãi no di. Tũwarar dilot ferešani no ok, edde ḍor no golok. ");
INSERT INTO rhg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","\"Tũwara ãi hoiyide fuinno, 'Ãi zaiyumboi edde abar tũwarar hãse firi aiššum.' Tũwara zodi ãre ador gorita, toile tũwara kuši oita, ze ãi ãr Bafor hãse zair, kiyollahoile Baf ãttuwaro mohan. ");
INSERT INTO rhg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","In okkol goṭibar age ãi tũwarare hoi rakilam, toi zene in zẽtte goṭibo tũwara biššaš gori faro. ");
INSERT INTO rhg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ãi tũwara loi ar beši hotun hota no hoiyum; kiyollahoile duniyair šašon goroya aiyer, ãr uwore hitar hono odihar nai, ");
INSERT INTO rhg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kintu duniyaiye zene zani fare ze, ãi Bafore ador gori, edde Bafe ãre hokum diyede he mozin ãi gori. \"Aiyo, ãra enttu zaigoi.\" ");
INSERT INTO rhg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","\"Ãi he asoli ãngur gas, edde ãr Baf bagan šaši. ");
INSERT INTO rhg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ãr fotti ḍeila zinot gula no dorer, hinore hibaye haṛi fele, ar fotti ḍeila zinot gula dorer, hinore hibaye šaṛiyore foriškar gore, zene aro beši gula dore. ");
INSERT INTO rhg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ãi tũwarare ze kalam hoilam hinor zoriya tũwara beggune age foriškar oiyo. ");
INSERT INTO rhg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ãr butore tako, toi ãi o tũwarar butore taki; zendilla ḍeilaye nize gula dorai no fare, zodi ãngur gas loi laigga no take, hendilla tũwara o ãr butore no takile gula dorai no fariba. ");
INSERT INTO rhg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","\"Ãi ãngur gas; tũwara ḍeila okkol; hite ze ãr butore, ãi hitar butore taki, ar hite beši gula doraibo; kiyollahoile ãre sara tũwara kissu gori no faro. ");
INSERT INTO rhg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hite ze ãr butore no take, hitare ḍeila felaidefan baire felaidiya oibo edde fuwai zaiboi, ar hinore dola gori oinot felaidiya o edde hinore furifela o. ");
INSERT INTO rhg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zodi tũwara ãr butore tako, ar ãr kalam tũwarar butore take, tũwara za issa mago, hin tũwaralla gora oibo. ");
INSERT INTO rhg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iyanot ãr Baf mohimawala o, ze tũwara beši fól dorao, edde tũwara ãr sahabi forman oiba. ");
INSERT INTO rhg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","\"Bafe zendilla ãre ador goijje, ãi o tũwarare ador goijji; tũwara ãr adorot tako. ");
INSERT INTO rhg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tũwara zodi ãr hokum okkol falon goro, toile tũwara o ãr adorot takiba, zendilla ãi o ãr Bafor hár hokum okkol falon goriyore hibar adoror butore taikki. ");
INSERT INTO rhg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","In okkol ãi tũwarare hoilam, zene tũwarar dilot ãr anondo take edde tũwarar anondo furafuri furon o. ");
INSERT INTO rhg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ãr hokum oilde ei: Tũwara ekzone oinnozonore ador goro, zendilla ãi tũwarare ador goijji. ");
INSERT INTO rhg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hono ekzone hitar bondu okkololla nizor zibon de, hiyanottuwaro mohan ador kissu nai. ");
INSERT INTO rhg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tũwarare ãi ze hokum okkol dir, hin zodi falon goro, toile tũwara ãr bondu okkol. ");
INSERT INTO rhg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ãi tũwarare ar gulam no ḍakir, kiyollahoile malike ki gore, gulame hiyan no zane, ar ãi tũwarare bondu ḍaikki, kiyollahoile hár kissu zin ãr Bafor hãsottu fuinni, hin tũwarare zanaiyi. ");
INSERT INTO rhg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tũwara ãre basi no lo, kintu ãi tũwarare basi loiyi, ar buwayi zene tũwara zo edde gula dorao, gula zene ṭiki take, toi zene tũwara ãr name Bafor hãse za kissu saiba, hin hibaye tũwarare de. ");
INSERT INTO rhg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ei oilde ãr hokum tũwaralla: Ekzonore ekzone ador goro. ");
INSERT INTO rhg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","\"Duniyaiye zodi tũwarare hingša gore, tũwara to zano, hiyane tũwarar age ãre hingša goijje. ");
INSERT INTO rhg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tũwara zodi duniyair oita, toile duniyaiye tũwarare nizor hoi ador goitto; kintu tũwara zehon duniyair no, bolke ãi tũwarare duniyaittu basi loiyi, etolla duniyaiye tũwarare hingša gore. ");
INSERT INTO rhg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ãr ei hota tũwara monot raikko: Ekzon gulam hitar malikottuwaro ḍõr no: hitara zodi ãre zulum goijje, toile tũwarare o hitara zulum goribo; ar hitara zodi ãr kalam falon gorito, hitara tũwarargun o funito. ");
INSERT INTO rhg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kintu hitara ãr namolla boli tũwarare in okkol goribo, kiyollahoile ãre ze defeṛaiye, hibare hitara no zane. ");
INSERT INTO rhg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ãi zodi nu aitam edde hitarar hãse no hoitam, toile hitara hosuri sara oito; kintu ehon hitarar gunar kofiyot dibolla hono rasta nai. ");
INSERT INTO rhg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hite ze ãre hingša gore, hite ãr Bafore o hingša gore. ");
INSERT INTO rhg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ãi zodi hendilla ham okkol gori no dehaitam, zin oinno honokiye no gore, toile hitarattu guna no oito; kintu ehon hitara ãr ham okkol deikke, ar ãre edde ãr Bafore hingša gorer. ");
INSERT INTO rhg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kintu endilla oiye, zene hitarar ainot ziyan leka ase hiyan furon o: 'Hitara hono kissu sara ãre hingša goijje.' ");
INSERT INTO rhg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","\"Modot goroya zẽtte aibo, zare ãi Bafor hentu tũwarar hãse defeṛaiyum, soiyir he Ruh, ze Bafor hentu niyoli zar, hibaye ãr babute goba dibo. ");
INSERT INTO rhg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ar tũwara o ãr goba, kiyollahoile tũwara šuruttu loti ãr fũwati aso. ");
INSERT INTO rhg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","\"In okkol ãi tũwarare hoilam, zene tũwara fori no zogoi. ");
INSERT INTO rhg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Hitara tũwarare sinagogottu niyolai dibo; enki, en ṭaim aiyer, zẽtte tũwarare ze hono kiye marifelaibo, hite mone goribo, ze hiyan hitara Allare ek šeba der. ");
INSERT INTO rhg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hitara endilla goribo, kiyollahoile hitara no Bafore zane, ar no ãre zane. ");
INSERT INTO rhg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ãi tũwarare in okkol hoilam, zene hitarar ṭaim zẽtte aibo, tũwarar monot take ze ãi tũwarare hitarar babute hoiyi. Ãi tũwarare in age no hoi, kiyollahoile ãi tũwarar fũwati aššilam, ");
INSERT INTO rhg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","kintu ehon ãi zairgoi, ze ãre defeṛaiye hibar heṛe. Ar tũwarar honokiye ãre fusar o no goror, 'Tũi hoṛe zodde?' ");
INSERT INTO rhg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bolke ãi tũwarare in okkol hoi boli tũwarar dil dukke bori uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kintu ãi tũwarare soiyi hoir, ãi zairgoide hiyan tũwaralla bala, kiyollahoile ãi no zailegoi, he modot goroya tũwarar hãse no aibo; kintu ãi zodi zaigoi, toi hibare tũwarar hãse faṭai diyum. ");
INSERT INTO rhg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ar hiba aiyore gunar babute, soiyir babute edde forhesgarir babute, duniyaire golti dehai dibo: ");
INSERT INTO rhg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","gunar zoriya, hitara ãr uwore biššaš no ane. ");
INSERT INTO rhg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","edde forhesgarir babute, kiyollahoile ãi Bafor heṛe zair, ar tũwara ãre ar no dekiba; ");
INSERT INTO rhg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ar Bisar babute, kiyollahoile ei duniyair šašon goroyar bisar oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","\"Tũwarare ãttu bout kissu hoibar ase, kintu tũwara ehon hin bordaš gori no fariba. ");
INSERT INTO rhg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ar zẽtte hiba, he soiyir Ruh, aibo, hẽtte hibaye fõt dehaiyore tũwarare hár soyit loizaibo; kiyollahoile hibaye hiba nizottu hota no hoibo, kintu zin funibo hin hoibo, edde sarme goṭibode hin okkol tũwarare hoibo. ");
INSERT INTO rhg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hibaye ãre mohimawala goribo, kiyollahoile hibaye ãrgun loibo, edde tũwarare zanai dibo. ");
INSERT INTO rhg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ar Bafottu zin zin ase, beggun ãr; etolla ãi hoiyi, ze hibaye ãrgun loibo edde tũwarare zanai dibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","\"Olfo ṭaimor butore tũwara ãre ar no dekiba, toi tarfore abar olfo ṭaimor butore tũwara ãre dekiba.\" ");
INSERT INTO rhg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Henot hibar sahabi okkol ho ekzone ekzonore ekzone hodde, \"Ibaye ãrare in ki hor, 'Olfo ṭaimor butore tũwara ãre ar no dekiba, tarfore abar olfo ṭaimor butore tũwara ãre dekiba,' ar, 'Ãi Bafor hãse zair'? ");
INSERT INTO rhg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Toi hitara hodde, \"Hibaye 'olfo ṭaimor butore' hoi ki hodde? Hibaye ki hor ãra buzi no farir.\" ");
INSERT INTO rhg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isaye deikke ze hitara ei babute fusar goitto sar, toi hibaye hitarare hodde, \"Tũwara ki ei babute howahoi goror ze ãi hoilam, 'Olfo ṭaimor butore tũwara ãre ar no dekiba, tarfore abar olfo ṭaimor butore tũwara ãre dekiba'? ");
INSERT INTO rhg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ãi tũwarare soiyi hoir, tũwara handiba edde bilag goriba, kintu duniyaiye anondo goribo; tũwara ferešan oiba, kintu tũwarar ferešani anondo oi zaibogoi. ");
INSERT INTO rhg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Fuwa oibar šomot mayafuwaye duk fa, kiyollahoile hibar ṭaim aišše, kintu hibar fuwa zormo oi bade, ekzon noya manuš duniyait aišše, ei anondoye hibattu ar he bišor hota monot no take. ");
INSERT INTO rhg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hendilla tũwara o ehon duk for, kintu ãi tũwara loi abar deha oiyum, ar tũwarar dile anondo goribo, edde tũwarar he anondo honokiye no loi zaibo. ");
INSERT INTO rhg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","He din tũwara ãttu hono kissu suwal goribolla no takibo; soiyi soiyi, ãi tũwarare hoir, tũwara Bafor hãse zodi kissu so, hibaye ãr name tũwarare hin dibo. ");
INSERT INTO rhg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ehon foijjonto tũwara ãr name kissu no so. So, tũwara faiba, toi tũwarar anondo furafuri furon oibo. ");
INSERT INTO rhg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","\"Zodi o ãi tũwarare in okkol mesalor duwara hoilam, kintu en ṭaim aiyer zẽtte ãi ar mesalor duwara hota no hoiyum, kintu kulasa gori Bafor babute hoiyum. ");
INSERT INTO rhg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","He din tũwara ãr name saiba, ar ãi tũwarare no hoir, ze ãi tũwaralla Bafor hãse foriyad goriyum. ");
INSERT INTO rhg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kiyollahoile Baf nize tũwarare ador gore, kiyollahoile tũwara ãre ador goror edde biššaš goijjo ze ãi Allar hentu aišši. ");
INSERT INTO rhg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ãi Bafor hentu ei duniyait aišši, ei duniyai ãi abar eri zairgoi edde Bafor heṛe zair.\" ");
INSERT INTO rhg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hetunot Isar sahabi okkole hodde, \"So, õne ehon to kulasa gori hota hor, mesalor duwara no hor. ");
INSERT INTO rhg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ehon ãra buzi faijji ze õne beggun zano edde õnore honokiye suwal fusar gorok o dorhar nai. iyanot ãra biššaš goijji ze õne Allar hentu aiššo.\" ");
INSERT INTO rhg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isaye zuwabe hodde, \"Henoile ki ehon biššaš goror? ");
INSERT INTO rhg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","En ṭaim aiyer, enki aigiyegoi, zẽtte tũwara šiṛašitta oi zaibagoi, ãre halikaga raki ze zar zar zagat hite zaibagoi, tarfore o ãi halikaga no, kiyollahoile Baf ãr fũwati ase. ");
INSERT INTO rhg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","\"Ãi tũwarare in okkol hoilam zene tũwara ãr butore šanti fo. Ei duniyait tũwarattu mosibot takibo, kintu šahoš no haraiyo! Ãi duniyai loi zitti.\" ");
INSERT INTO rhg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Isaye in okkol hoi bade, asmanor mikka hibar suk tuille, toi hodde: \"Baf, šomoi aigiyegoi; tũwar Futore mohimawala goro, zene tũwar Fute tũware mohimawala gori fare. ");
INSERT INTO rhg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kiyollahoile tũi hibare hár manuš okkolor uwore kemota diyo, zene tũi zarare hibare diyo, hitara beggunore hibaye akeri zibon di fare. ");
INSERT INTO rhg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ar iyan oilde akeri zibon: zene hitara tũware, ek matro soiyi Allare, edde hiba zare tũi defeṛaiyo, he Isa Mosire, zane. ");
INSERT INTO rhg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tũi ãre ze ham goitto diyo hin ãi šeš goriyore ei duniyait tũware mohimawala goijji. ");
INSERT INTO rhg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ar ehon oh Baf, duniyair age tũwar loi ãr ze mohima aššil, tũi he mohima loi ãre tũwar sarme mohimawala goro. ");
INSERT INTO rhg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","\"Duniyaittu zarare tũi ãrare diyo, ãi hitarar hãse tũwar nam forhaš goijji. Hitara tũwar aššil; tũi hitarare ãre diyo, ar hitara tũwar kalam falon goijje. ");
INSERT INTO rhg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hitara ehon zani faijje, ze tũi ãre zin diyo, hin tũwar hãsottu. ");
INSERT INTO rhg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kiyollahoile tũi ãre ze kalam okkol diyo, hin ãi hitarare diyi, ar hitara hinore goisse, ar soiyi gori zani faijje, ze ãi tũwar hãsottu aišši, ar hitara biššaš goijje ze, tũi ãre defeṛaiyo. ");
INSERT INTO rhg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ãi hitaralla foriyad gorir; Ãi duniyailla foriyad no gori, kintu hitaralla gori, zarare tũi ãre diyo; kiyollahoile hitara tũwar. ");
INSERT INTO rhg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ãr beggun tũwar, ar tũwattu beggun ãr; ar ãi hitarar duwara mohimawala oiyi. ");
INSERT INTO rhg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ãi ar ei duniyait no takiyum, kintu hitara ei duniyait ase, edde ãi tũwar hãse aiyir. Fobitro Baf, tũwar name hitarare hefazot goro, ze nam tũi ãre diyo, toi zene hitara ek oi fare, zendilla ãra ek. ");
INSERT INTO rhg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ãi hitarar fũwati taite, ãi hitarare tũwar name hefazotot raikki, ze nam tũi ãre diyo; ãi hitarare fahara di sõli raikki, hitarar butottu honokiye dongšo no o, dongšor fut bade, zene kitabor kalam furon o. ");
INSERT INTO rhg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","\"Ar ehon ãi tũwar hãse aiyir, kintu in okkol ãi duniyait taite hoir, zene hitara ãr anondo hitara nizor butore furafuri bafe furon o. ");
INSERT INTO rhg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ãi hitarare tũwar kalam diyi, kintu duniyaiye hitarare hingša goijje, kiyollahoile hitara duniyair no, zendilla ãi duniyair no. ");
INSERT INTO rhg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ãr foriyad iyan no ze tũi hitarare duniyaittu loi zogoi, kintu tũi hitarare he horafottu rokka goro. ");
INSERT INTO rhg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hitara duniyair no, zendilla ãi duniyair no. ");
INSERT INTO rhg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hitarare soiyi loi fobitro goro; tũwar kalam soiyi. ");
INSERT INTO rhg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tũi zendilla ãre duniyait defeṛaiyo, hendilla ãi o hitarare duniyait defeṛaiyi. ");
INSERT INTO rhg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hitaralla ãi nizore fobitro goijji, zene hitarare o hitara nizore soyit fobitro oi fare. ");
INSERT INTO rhg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","\"Ãi šude itaralla foriyad no gorir, kintu hitaralla o, zara itarar hotar duwara ãr uwore biššaš anibo, ");
INSERT INTO rhg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","zene hitara beggune ek o; Baf, zendilla tũi ãr butore, ar ãi tũwar butore, hitara o zene hendilla ãrar butore ek take; zene duniyaiye biššaš gore ze, tũi ãre defeṛaiyo. ");
INSERT INTO rhg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ar tũi ze mohima ãre diyo, hin ãi hitarare diyi, zene hitara o ãrar ḍoilla ek oi fare; ");
INSERT INTO rhg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ãi hitarar butore, ar tũi ãr butore, toi zene hitara furafuri bafe ek o; zene duniyaiye zani fare ze, tũi ãre defeṛaiyo, edde tũi ãre zendilla ador goijjo, hendilla hitarare o ador goro. ");
INSERT INTO rhg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","\"Baf, tũi ãre zarare diyo, ãi sai ze ãi zeṛe hitara o ãr fũwati taki fare, zene ze mohima tũi ãre diyo, hitara hiyan deki fare, kiyollahoile duniyai zuron dibar agottu tũi ãre ador goijjo. ");
INSERT INTO rhg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","\"Niyaiwala Baf, duniyaiye zodi o tũware no zane, kintu ãi tũware zani, ar itara zainne ze tũi ãre defeṛaiyo. ");
INSERT INTO rhg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ar ãi itarare tũwar nam zanefan goijji edde zanefan goijjum, zene tũi ãre ze ador loi ador goijjo, he ador hitarar butore take, edde ãi hitarar butore taki.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","In okkol hoi bade, Isaye hibar sahabi okkolore fũwati loi niyoliyore Kidron zúra farai giye; heṛe ugguwa bagan aššil, hibar butore hiba edde hibar sahabi okkol góille. ");
INSERT INTO rhg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ar Ehudah, ze hibare dorai dil, hitattu o he zagagan zana aššil, kiyollahoile Isaye bout bar hibar sahabi okkolore loi heṛe ekottro oito. ");
INSERT INTO rhg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hetolla Ehudaye ḍõr imam edde Foroši okkolor hentu ek šoinno dol edde hoekzon hitarar hormosari okkolore ainne, ar hitara uzal edde fanoš edde ostro loi heṛe aišše. ");
INSERT INTO rhg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Isaye, hibar nizor uwore goṭedde hin okkol zaniyore, hibaye mummikka giye edde hitarare hodde, \"Tũwara hare tuwor?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hitara hibare zuwabe hodde, \"Nasarator Isare.\" Isaye hodde, \"Ãi Oi.\" Ar Ehudah, ze hibare dorai der, hite o hitarar fũwati tiyat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Isaye zehon hitarare hoiye, \"Ãi Oi\" hetunot hitara fissa giye edde meṛit forigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hibaye hitarare abar fusar goijje,\"Tũwara hare tuwor?\" Hitara hodde,\"Nasarator Isare.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isaye hodde, \"Ãi to tũwarare hoilam ze, ãi oi. Tũwara zodi ãre tuwor, toile itarare zaito do.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zene hibaye ze hoil hiyan furon o,\"Tũi zarare ãre diyo, ãi hitarar ekzonore no harai.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Fitor, zattu ekkan suri aššil, hibaye hiyan niyolaiye edde ek ḍõr imamor gulamore hamela gori hitar ḍen han haṛi felaiye. (Gulammuwar nam aššilde Malkos.) ");
INSERT INTO rhg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Toi Isaye Fitorore hodde, \"Tor suri ḍafor butore rak; ze fiyala Bafe ãre diye hiba ki ãi no fiyum ne?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hetunot he šoinno okkole edde hitarar komonḍar edde Ihudi neta okkolor hormosari okkole Isare gereftar goijje edde bainde, ");
INSERT INTO rhg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","edde foila Isare Annasor heṛe loigiye. Annas aššilde Kaifasor hour, ze he bosoror ḍõr imam aššil. ");
INSERT INTO rhg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ar ei Kaifas, ze Ihudi okkolore mošora dil, ekzon mora iyan mainšolla bala. ");
INSERT INTO rhg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Fitor edde ar ekzon sahabi Isar fise fise giye. He dusora sahabiwa ḍõr imamor sina aššil, edde Isar fũwati hite ḍõr imamor góror sarme uṛanot góille, ");
INSERT INTO rhg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu Fitor bare dorozar hãse tiyai roiye. Toi ḍõr imamor sina dusora sahabiwaye bare giye edde doroza faharadar mayafuware hoiyore Fitorore butore loigiye. ");
INSERT INTO rhg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","He mayafuwawaye Fitorore hodde, \"Tui o ki ei manušwar sahabi okkolor butottu ekzon?\" Fitore hodde, \"No, ãi no.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hẽtte beši šit foijjil, hetolla gulam okkol edde faharadar okkole oinor ṭal zaillil edde tiyaiyore oin fuhail. Fitor o hitarar fũwati tiyaiyore oin fuhail. ");
INSERT INTO rhg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","He šomot ḍõr imame Isattu hibar sahabi okkolor babute edde hibar šikkar babute fusar goijje. ");
INSERT INTO rhg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kintu Isaye zuwabe hodde, \"Ãi duniyair sarme kulasa gori hota howat asi. Ãi hamiša sinagog okkolot edde dórmogórot, zeṛe Ihudi okkol beggune ekottro o, heṛe šikka diyat asi. Ãi gufone kissu no hoi. ");
INSERT INTO rhg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ãre kiyolla fusar goror? Zara fuinne hitarare fusar goro, ãi hitarare ki hoiyi; so, ãi ki hoiyi hin hitara zane.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Isaye ei hota hodde ṭaimot, faharadar okkol butottu ekzon ze hibar ḍake tiyat aššil, hite hibare suwar mariyore hodde, \"Endilla neki ḍõr imamore zuwab dodde?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isaye hitare hodde, \"Zodi horaf kissu hoi taki, he horafir goba de, kintu zodi bala hoi taki, toile tui ãre kiyolla maror?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hetunot Annase banda abostat Isare ḍõr imam Kaifasor hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Fitor tiyaiyore oin fuhadde šomot, hitara hibare hodde, \"Tui o utar sahabi okkolor butottu ekzon no?\" Hibaye ošikar goijje edde hodde, \"No, ãi no.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ḍõr imamor gulam okkolor ekzon, Fitore zar han haṛifelail, hitar ek egenaye hodde, \"Ãi ki tore baganot hitar fũwati no deki ne?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Fitore abar ošikar goijje, toi hetunot ugguwa rata kuraye bak diye. ");
INSERT INTO rhg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bade binna sore hitara Isare Kaifasor hentu Romiyo govarnaror mehelot loigiye. Ar hitara nafak no ofan, edde uddar idor hana hái farefan, hitara nize mehelor butore no gole. ");
INSERT INTO rhg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hetolla Filat baire hitarar ḍake aiyore hodde,\"Ei manušwar berudde tũwara kiyor hošuri dodde?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hitara hodde, \"Ite horaf ham no gorito boli ãra hitare õnor hãse no anitam.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Filate hitarare hodde, \"Itare tũwara loizogoi edde tũwara nizor ain mozin bisar gorogoi.\" Henot hitara hodde, \"Kintu honokiyore moron šaza dibar kemota to ãrar hatot nai.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zene Isar kalam furon o, ziyan hoiyore hibaye dehai dil, hondilla moron hibaye moribo. ");
INSERT INTO rhg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Toi Filat abar mehelot góille edde Isare ḍaki hodde, \"Tui ki Ihudi okkolor badša?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isaye hodde, \"Tũi ki nize ei hota hor, naki oinno kiye tũware ãr babute iyan hoiye?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Filate zuwabe hodde, \"Ãi ki Ihudi? Tor zati edde ḍõr imam okkole tore ãr hatot tuli diye. Tui ki goijjos?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isaye zuwabe hodde, \"Ãr raijjo ei duniyair no; zodi ãr raijjo ei duniyair oito, toile ãre Ihudi neta okkolor hatot tuli diya no ofan, ãr mainše zuddo gorito, kintu ãr raijjo eṛe no.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Filate Isare hodde, \"Toile ki tui badša?\" Isaye hodde, \"Tũi ṭik hoiyo ze, ãi badša. Soiyir foikka goba dibolla ãi zormo oiyi, ar hetolla ãi duniyait aišši. Fottikiye ze soiyir foikka hite ãr hota fune.\" ");
INSERT INTO rhg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Filate hibare hodde, \"Soiyi ki?\" Ei hota hoi hite abar bare Ihudi neta okkolor hãse zaiyore hodde, \"Ãi ei manušwar hono hosuri no fair. ");
INSERT INTO rhg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kintu tũwarar ekkan niyom ase ze, uddar idor ṭaimot ãi tũwarar ekzon hodire tũwaralla eridi. Tũwara ki so ze ãi Ihudi okkolor badšare eridi?\" ");
INSERT INTO rhg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hitara beggune abar guzori hodde, \"No, hitare no! Ãra Barabbasore sai.\" He Barabbas aššilde ekzon ḍahait. ");
INSERT INTO rhg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Filate Isare loigiye edde beša beši souk maraiye. ");
INSERT INTO rhg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Šoinno okkole keṛa lota diyore ekkan taz banaiye edde hibar matat buwai diye. Ar hitara hibare ugguwa baiyonna rongor zubba o findai diye. ");
INSERT INTO rhg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tarfore hitara hibar hãse zai zai hodde, \"Oh Ihudi okkolor badšar hayat lamba ok!\" Ar hitara hibare suwar maijje. ");
INSERT INTO rhg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Filat abar mainšor dolor heṛe niyoli aišše edde Ihudi okkolore hodde, \"So, ãi hitare tũwarar hãse niyolai anir zene tũwara buzi faro ze, ãi hitar hono hosuri no fair.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isaye he keṛar taz edde baiyonna rongor hor finda abostat maze baire aišše. Hetunot Filate mainšore hodde, \"Oto so ei manušwa!\" ");
INSERT INTO rhg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kintu Isare dekiyore ḍõr imam edde faharadar okkole guzoriyore hodde, \"Kurušot do, itare kurušot do!\" Filate hodde, \"Tũwara itare loizaiyore kurušot dogoi! Ãi hitar hono hosuri no fair.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ihudi okkole hodde, \"Ãrattu ek ain ase, he ain mozin hitattu mora foribo, kiyollahoile hite nizore Allar Fut hoiye.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Filate zehon ei hota fuinne hetunot hite aro ḍoraiye; ");
INSERT INTO rhg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","edde hite abar mehelor butore giye edde Isare hodde, \"Tui honttu aiššos?\" Kintu Isaye hitare hono zuwab no de. ");
INSERT INTO rhg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Filate hodde, \"Tui ki ãr loi hota no hoibi? Tui ki no zanos ze, tore eridibar edde kurušot dibar kemota ãttu asede?\" ");
INSERT INTO rhg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isaye hodde, \"Uwottu tũware kemota diya no oito buli ãr uwore tũwar hono kemota no takito; etolla hite ze ãre tũwar hatot tuli diye, hitar guna beši ḍõr.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ei hota funi Filate Isare eridibolla kušiš goijje, kintu Ihudi okkole guzori hoiye, \"Õne zodi itare erido, toile õne Kaisaror bondu no; ze honokiye nizore badša dabi gore hite to Kaisaror bifokke hota ho.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Filate ei hota zehon fuinne, hite Isare baire ainne edde ek šil bisaiya zagat bisaror siyarot boišše, (ze zagaganore Ibroni zubanot Gabbata howa oito). ");
INSERT INTO rhg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","He dinnan aššil uddar id entezamor din; hẽtte ṭaim oilde dũijja. Filate Ihudi okkolore hodde, \"Ei so, tũwarar badša\" ");
INSERT INTO rhg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Henot hitara guzori hodde, \"Dur goro! Dur goro! hitare kurušot do.\" Filate hitarare hodde, \"Tũwarar badšare ki ãi kurušot diyum?\" Ḍõr imam okkole zuwab diye, \"Kaisar bade ãrattu ar hono badša nai.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Toi hite Isare hitarar hatot tuli diye, zene hibare kurušot diya o. Toi hitara hibare hentu loi giyegoi; ");
INSERT INTO rhg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ar hiba nizor kuruš boi loizaiyore Matakuli name ek zagat giye (ziyanore Ibroni zubanot Golgotá ho.) ");
INSERT INTO rhg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Heṛe hitara Isare kurušot diye, edde hibar fũwati aro duizonore diye, ekzonore ek ḍakottu ek ḍakottu, ar maze Isare. ");
INSERT INTO rhg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Filate ekkan dušnama lekiyore Isar kurušor uwore lagai diye, ar leka aššil: \"NASARATOR ISA, IHUDI OKKOLOR BADŠA.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ihudi okkolor boute he dušnamagan foijje, kiyollahoile Isare kurušot diya oiyede zagagan aššilde šohoror ḍake, ar hiyan leka aššil Ibroni, Romiyo edde Girik bašat. ");
INSERT INTO rhg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ihudi okkolor ḍõr imam okkole Filatore hodde, \"'Ihudi okkolor badša no leikko,' kintu leko ze, ite hoito, 'ãi Ihudi okkolor badša.'\" ");
INSERT INTO rhg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Filate hodde, \"Ãi ziyan lekki, hiyan ãi lekki.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Šoinno okkole Isare kurušot di bade, hitara hibar horgunore sair bag goriyore ekzone ek bag gori loiye, ar zubba o loiye; kintu hiba silaiya nu aššil, uwottu nise foijjonto banaiya. ");
INSERT INTO rhg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Toi hitara ekzonore ekzone hodde, \"Iyan no faṛiyum, bolke iyanolla loṭari mari, sai iba har o.\" Zene ei kalam furon oi fare, \"Hitara ãr horgunore hitarar maze bag goijje, ar ãr zubbawalla loṭari maijje\" Ar hendilla in okkol ei šoinno okkole goijje. ");
INSERT INTO rhg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ar Isar kurušor ḍake hibar ma, hibar mar boin, Klofasor bou Moriyam, edde Mogdaleni Moriyam, itara tiyat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Isaye, mare edde sahabi zare hibaye ador gorito, hitara tiyai taikkede dekiyore, hibaye mare hodde, \"Mayafuwa, sa, iba tor fut.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tarfore he sahabire hodde, \"Sa, iba tor ma.\" He oite, he sahabiye hibare hitar nizor górot loigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tarfore, Isaye buzi farer ze beggun šeš oiye, kitabor kalam zene furon o, hibaye hodde,\"Ãi tiraši oiyi.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Heṛe horor roš furaiya ugguwa dešši aššil, toi hitara ekkan hanire he horor rošot bizaiye edde esup gasor ḍeila loi hin Isar mukor hãse doijje. ");
INSERT INTO rhg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Isaye he horor roš haiyore hodde,\"Šeš oiye.\" Tarfore hibaye mata niso gori hibar šeš niyaš felaiye. ");
INSERT INTO rhg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","He dinnan aššilde entezamor din, ar Šabbator din zene lašgun kurušor uwore no take, kiyollahoile he Šabbat aššilde ek moha din, etolla Ihudi okkole Filatore foriyad goijje zene hitarar ṭenggun bangi diyore hitarare kurušottu lamaifela o. ");
INSERT INTO rhg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Toi šoinno okkol aiyore foila ekzonore, edde hibar fũwati kurušot diya oiyede dusora ekzonore, ṭenggun bangi diye. ");
INSERT INTO rhg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kintu hitara zẽtte Isar hãse aiyore dekilo ze, hiba mori giyegoi, toi hibar ṭeng no bange. ");
INSERT INTO rhg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kintu soinno okkolor ekzone hibar ḍak sai sel loiyore hana goijje; henot toratori lou edde fani niyoli aišše. ");
INSERT INTO rhg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ze nizor suke deikke, hite goba diye, ar hitar goba soiyi. Ar hite zane ze hite soiyi hor, zene tũwara o biššaš goro. ");
INSERT INTO rhg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Haron in okkol goiṭṭe, zene kitabor ei kalam furon o, \"Hibar ekkan ãḍḍi o banga no oibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Abar kitabor ar ek kalam endilla hor, \"Hitara zare hana goijje hibare hitara saibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ar in okkol bade, Arimatiyar Yusuf, ze aššil Isar sahabi, kintu Ihudi okkolor ḍore gufone aššil, hibaye Filatore foriyad goijje, zene hibaye Isar gagan loizai fare; Filate loizaibolla ezajot diye. Toi hibaye aiyore hibar gagan loigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ar Nikoḍomas, hiba ze foilabar raitta Isar hãse aiššil, hibaye o heṛe aššil, myrrah edde aloi miyaiya onumanik ek šot fond mosolla loiyore. ");
INSERT INTO rhg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hitara Isar ga loizaiyore Ihudi okkolore dohon gorade niyom mozin he kušbo mosolla kafon horot diyore berai diye. ");
INSERT INTO rhg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Isare zeṛe kurušot diya oiye, heṛe ek bagan aššil, ar he baganot ugguwa noya hobor aššil, zibat honokiyore ehono raka no o. ");
INSERT INTO rhg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","He din aššilde Ihudi okkolor entezamor din, hitara Isare he hoborot raikke, kiyollahoile he hoborguwa ḍake aššil. ");
INSERT INTO rhg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Haftar foila din binna sore, andar taite Mogdaleni Moriyame hoboror hãse giye, ar hibaye dekedde hoboror mukottu fattorgan algaifela oiye. ");
INSERT INTO rhg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hibaye dũri Simon Fitoror hãse edde dusora sahabi zare Isaye ador gorito hibar hãse aišše, ar hitarare hodde, \"Hitara Malikore hoborottu loigiyegoi; ar hitara hibare hoṛe raikke ãra no zani.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Toi Fitor edde he dusora sahabiwa hetunot niyoli giye edde hoboror mikka zat aššil. ");
INSERT INTO rhg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ar hitara dunizon ekku fũwati dũrat aššil, kintu he dusora sahabiwaye Fitorottuwaro aro beši dũriyore mummika giye edde hoborot agottu fõissegai; ");
INSERT INTO rhg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","edde niyuriyore hoboror butore saiye, heṛe kafonor hor fori taikkede deikke, kintu hibaye hoboror butore no za. ");
INSERT INTO rhg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Fitor o hibar fise fise aišše, edde hoboror butore giye edde dekedde kafonor horgun heṛe fori roiye, ");
INSERT INTO rhg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ar ze rumalgan hibar matat beraiya aššil hiyan kafonor horor fũwati nai, kintu ar ekkan zagat hok gori raka oiye. ");
INSERT INTO rhg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tarfore dusora sahabi ze age hoboror hãse fõissil, hibaye o butore giye. Hibaye deikke edde biššaš goijje. ");
INSERT INTO rhg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Hehon foijjonto hitara kitabor ei hota buzi no fare ze, mora okkolor butottu abar hiba uṛa iyan dorhari.) ");
INSERT INTO rhg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tarfore sahabi okkol górot firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Toi Moriyam hoboror baire tiyai handat roiye, hibaye handat maze niyuriyore hoboror butore saiye, ");
INSERT INTO rhg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ar dekedde, dola hor finda duizon firista Isar ga ze zagat neṛai diya oil, ekzon hibar matar hentu, ar ekzon ṭengor hentu, boi taikke. ");
INSERT INTO rhg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hitara hibare hodde, \"He mayafuwa, handor kiyolla?\" Hibaye hitarare hodde, \"Hitara ãr Malikore loigiyegoi, edde hibare hoṛe raikke ãi no zani.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","In okkol hoiyore hiba fissa firi sadde Isa tiyai roiye, kintu hiba Isade hiyan hibaye buzi no fare. ");
INSERT INTO rhg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Isaye hibare hodde, \"He mayafuwa, handor kiyolla? Hare tuwor?\" Isare baganor mali boli ṭariyore, hibaye hodde, \"So, õne zodi hibare loi giyogoide o, toile ãre ho hoṛe raikko, ãi hibare loi ainnumboi.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isaye hibare hodde, \"Moriyam.\" Henot Moriyame hibar mikka firiyore Ibroni zubanot Isare hodde, \"Rabbuni\" zar mani \"ustad.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Isaye Moriyamore hodde, \"Ãre no suis, kiyollahoile ãi ehono uwore Bafor hãse no zai. Tui bolke ãr báiyaindor hãse zaiyore hogoi, ze ãr edde tũwarar Baf, ze ãr edde tũwarar Allah, ãi uwore hibar hãse zair.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Toi Mogdaleni Moriyam hentu giyegoi edde sahabi okkolore hodde, \"Ãi Malikore dekki!\" Ar Isaye hibare ki hoil hin okkol o hibaye hitarare hoiye. ");
INSERT INTO rhg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","He ekkui dinor hazinna, haftar foila din, Ihudi okkolor ḍore, sahabi okkol ziyot dola oiya aššil he góror doroza okkol bon gori dil. Isa nize ai hitarar maze tiyaiyore hodde, \"Tũwarar šanti ok.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ei hota hoi bade hibaye hitarare hat edde ḍak dehaiye. Sahabi okkole Malikore dekiyore beši kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Toi Isaye abar hodde, \"Tũwarar šanti ok; zendilla ãre he Bafe defeṛaiye, ãi o tũwarare defeṛair.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ei hota hoiyore hibaye hitarar uwore fu diye edde hodde, \"Pak Ruhure goso. ");
INSERT INTO rhg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tũwara zodi honokiyor guna maf gori do, toile hitarar guna maf oibo, ar zodi honokiyor guna maf gori no do, toile hitarar guna maf gora no oibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Isa zẽtte aššil, hẽtte Ṭomas, he barozonor ekzon, (zare Didymus ḍaka oito,) hiba oinno sahabi okkolor fũwati nu aiššil. ");
INSERT INTO rhg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Toi oinno sahabi okkole hibare hodde, \"Ãra Malikore dekki.\" Kintu hibaye hitarare hodde, \"Ãi zodi hibar dui hatot ferakor sinno no deki, edde he ferakor sinnot ãr õl diyore, edde hibar ḍakot ãr hat diyore ãi sai no fari, toile hono mote ãi biššaš no goriyum.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ar ašṭo din bade, hibar sahabi okkole abar he górot dola oiye, edde Ṭomas o hitarar fũwati aššil, ar hẽtte dorozagun banda taki bade o Isa aišše, edde hiba hitarar maze tiyaiye, ar hodde, \"Tũwarar šanti ok.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tarfore hibaye Ṭomasore hodde, \"Tor õl eṛe an, ar ãr dui hat sa. Ar tor hat barai de, edde ãr ḍakot rak. Obiššaši no ois, kintu biššaši o.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hetunot Ṭomase zuwab diye edde hibare hodde, \"Ãr Malik, ãr Allah.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isaye hibare hodde, \"Ṭomas, tui ki ãre deikkos boli biššaš ainnos? Mubarok hitara, zara no dekiyore biššaš gore.\" ");
INSERT INTO rhg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isaye sahabi okkolor sukor sarme aro bout keramoti ham goijje, zin ei kitabot leka no o. ");
INSERT INTO rhg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kintu in okkol leka oiye, zene tũwara biššaš gori faro ze, Isa oilde Messiyah, Allar Fut, ar zene biššašor duwara tũwara hibar namot zibon fo. ");
INSERT INTO rhg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","In okkol bade, Isaye Ṭaiberia doriyar farot abar nizore sahabi okkolore deha diye. Ar hibaye nizore endilla gori forhaš goijje. ");
INSERT INTO rhg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Fitor, Ṭomas (zare Didymus ḍaka oito,) Galilor Kana farar Natanael, Sebdeusor futain edde hibar oinno duizon sahabi, itara ekkui fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Fitore hitarare hodde, \"Ãi mas doitto zair.\" Ar hitara hibare hodde, \"Ãra o tũwar fũwati zai.\" Toi hitara bair oi niyoli zai not uiṭṭe, ar he raitta hitara kissu no fa. ");
INSERT INTO rhg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Binna oi aišše, hen šomot Isaye doriyar farot tiyaiye, tarfore o sahabi okkole hiba Isade hiyan buzi no fare. ");
INSERT INTO rhg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Toi Isaye hitarare hodde, \"Fuwain okkol, tũwarattu ki háibolla kissu ase?\" Hitara hodde, \"Kissu nai.\" ");
INSERT INTO rhg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hibaye hitarare hodde, \"Nor ḍen ḍakottu zal felo, faiba.\"Toi hitara hendilla goijje, ar eto beši mas foijje, hitara hiyan ṭani tuli no faijjil. ");
INSERT INTO rhg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Toi Isaye ze sahabire ador gorito, hibaye Fitorore hodde, \"Iba Malik!\" Ei hota funiyore Simon Fitore gat hoor beraiye, (kiyollahoile hiba ulongo aššil) edde doriyat zaf maijje. ");
INSERT INTO rhg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ar oinno sahabi okkole mas furaiya zalgan ṭani ṭani gura not gori farot aišše, kiyollahoile hitara farottu beši dure nu aššil, onumanik dui šot hat dure aššil, hitara. ");
INSERT INTO rhg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Farot lamiyore hitara dekedde, oinor hoilar ṭal ase, ar heṛe uwore hodun mas ase, edde ruṭi. ");
INSERT INTO rhg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Hetunot Isaye hitarare hodde, \"Ze mas ehon doijjo, hentu hougguwa ano.\" ");
INSERT INTO rhg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Fitore not zaiyore zalgan farot ṭani ainne, ḍõr ḍõr mase furaiya, beggune ekšo fõnzaš tinnuwa mas oiye, eto beši mas oi bade o, zalgan no síre. ");
INSERT INTO rhg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isaye hitarare hodde, \"Aio, hógai.\" Sahabi okkol honokiye \"Õne honnuwa?\" fusar goitte šahoš no gore, kiyollahoile hitara zanito ze hiba Malik. ");
INSERT INTO rhg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Bade Isaye ruṭi loi aiyore hitarare diye, ar he bafe mas o diye. ");
INSERT INTO rhg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Morattu uṛi bade Isaye ei tisera bar sahabi okkolore deha diye. ");
INSERT INTO rhg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hitara beggune hána haiya šeš oi bade Isaye Simon Fitore hodde,\"Yuhannar fut Simon, itarattuwaro ki tui ãre beši ador goros?\" Simone hodde, \"Oi, malik, õne hoi faro õne ãr hoto adoijja.\" Isaye hodde, \"Ãr soolor sogunore hábais.\" ");
INSERT INTO rhg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Isaye abar hodde, \"Yuhannar fut Simon, itarattuwaro ki tui ãre beši ador goros?\" Simone hodde, \"Oi, malik, õne hoi faro õne ãr hoto adoijja.\" Isaye hodde, \"Ãr soolgunore sora.\" ");
INSERT INTO rhg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hibaye tisera bar Simonore hodde, \"Yuhannar fut Simon, tui ki ãre ador goros ne?\" Fitor ebarot dukkito oiye, kiyollahoile Isaye \"Tui ki ãre ador goros ne?\" tisera bar fusar goijje, ar hibare hodde, \"Malik, õne hár kissu zano, õne zano ze õne ãr adoijja.\" Isaye hodde, \"Toile ãr soolor sogunore hábais. ");
INSERT INTO rhg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ãi tore soiyi soiyi hoir, tui zẽtte zuwan aššili hẽtte tui nize tor kiyail banditi ar zeṛe issa heṛe zaiti, kintu zẽtte tui bura oibi hẽtte tor hat ṭanibi edde oinno ekzone tore bandibo ar tui zeṛe no zaito sos heṛe loizaibo.\" ");
INSERT INTO rhg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Allar mohima forhaš goralla boli Fitor kibafe moribo hiyan dehaibolla Isaye ei hotagan hoiye. Tarfore Isaye hodde, \"Ãr fisa lo!\" ");
INSERT INTO rhg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Fitore muk firai sadde, Isar adoijja sahabiwa o fise fise aiyer. (Iba oilde he sahabi ze hána háibar šomot Isar mikka helandiyore hoil, \"Malik, õnore ze dušmonor hatot dori dibo, hiba honnuwa?\") ");
INSERT INTO rhg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Fitore hibare dekiyore hodde, \"Malik, ibar babute ken?\" ");
INSERT INTO rhg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isaye Fitorore hodde, \"Ãi zodi sai ãi abar uwafes firi no aiyi foijjonto ite zinda take, henot tor ki? Tui ãr fisa lo.\" ");
INSERT INTO rhg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hiyanor zoriya báiyain okkolor butore hóbor sorai giyegoi ze, hite no moribo; zodi o Isaye hitare no ho ze, hite no moribo; bolke hibaye hoil, \"Ãi zodi sai ãi abar uwafes firi no aiyi foijjonto ite zinda take, henot tor ki?\" ");
INSERT INTO rhg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iba oilde he sahabi ze in beggunor babute goba der, edde in okkol hibaye leikke; ar ãra zani ze, hibar goba soiyi. ");
INSERT INTO rhg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isaye aro bout kissu goijjil; hin okkol zodi ek ekkan gori leka oito, toile edun kitab ze oito, ãi mone gorir he kitab okkol hin duniyait nu ãṛito.");
INSERT INTO rhg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Adoijja Teofilos, ãr foila siyarat ãi beggun hin okkolor babute leikki, zin Isaye goijje edde šikka diye, hibaye šuru goijjede hiya loti ");
INSERT INTO rhg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hedin foijjonto zẽtte hibare behostot tuli loiza oiye. Hẽtte hibaye hibar basai goijja asab okkolore Pak Ruhur duwara hokum dil. ");
INSERT INTO rhg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hibaye toziya bordaš gori bade ei manuš okkolore deha diye edde hiba ze zinda ase hiyanor beša besi biššaš lagede saf forman okkol diye. Sališ din dori hitarare deha diye edde Allar raijjor babute bout hota okkol hoiye. ");
INSERT INTO rhg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ek bar hibaye hitarar fũwati hána háil, hen šomot hitarare endilla hokum diye: \"Tũwara Zeruzalem sari no zaiyogoi, kintu Bafor wada gora ze hadiyar hota tũwara ãttu fuinno hiyanolla entezar goijjo. ");
INSERT INTO rhg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kiyollahoile Yahyaye fani loi torikotor gusol diye, kintu ho ek dinor butore tũwara he Pak Ruhur torikotor gusol faiba.\" ");
INSERT INTO rhg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sahabi okkole ekku fũwati dola oiyore Isare fusar goredde: \"Malik, õne ki ei šomot Israili okkolor hatot raijjo firai diba?\" ");
INSERT INTO rhg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Isaye zuwabe hodde: \"Ze din otóba ṭaim zin Bafe nizor odiharor butore raikke, hin tũwarare zanito diya no o. ");
INSERT INTO rhg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kintu he Pak Ruh tũwarar uwore aile tũwara šokti faiba. Ar Zeruzalem, Ehudiya beggulla, Sameriya edde duniyair šeš mata foijjonto tũwara ãr goba oiba.\" ");
INSERT INTO rhg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ei hota hoi bade, Isare tuli loi za odde hitara sai taikke. Ar ekkan miyulaye hibare hitarar sukor arguwale gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hitara asmanor mikka ek diyane sai roiye hen šomot, dóla hoor finda duizon manuš hitarar hãse ai tiyaiyegai. ");
INSERT INTO rhg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ar hitarare hodde: \"Oh Galilor manuš okkol! Tuwara eṛe tiyai asmanor uzu kiyolla sai roiyo? Ei Isa zare tũwarar hãsottu behostot tuli loi za oiyede deikko, ode ode hendilla gori hiba abar uwafes firi aibo.\" ");
INSERT INTO rhg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tarfore Sahabi okkol Zaitun faharottu uwafes Zeruzalem firi giyegoi. He faharguwa Zeruzalemottu onumanik ada mailor fõt. ");
INSERT INTO rhg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Šohoror butore hitara zeṛe takito, he góror uworor ṭalat giye. Hitara aššilde Fitor, Yahya, Yakub, Andreas, Filip, Ṭomas, Bartolomeus, Moti, Alfeyusor fuwa Yakub, Bahadur Simon Zelot, edde Yakubor fuwa Ehudah. ");
INSERT INTO rhg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Itara hoekzon mayafuwain edde Isar ma Moriyam ar Isar báiyain okkolor fũwati hamiša beggune ekmone duwa gorat roiye. ");
INSERT INTO rhg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hẽtte ek bar onumanik ekšo kuri zon torikotor bái bondu okkolor maze tiyai, ");
INSERT INTO rhg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Fitore hodde: \"Oh ãr báiboinain okkol, Ehudar babute Pak Ruhuye nobi Daudor muke zendilla hoil, Pak kalamor he hota hameka furon owa foijje. Isare zara doijje hitarare ei Ehudaye fõt dehaiye. ");
INSERT INTO rhg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hite ãrar butoror ekzon aššil edde ei ekkui šeba hamor bag fail.\" ");
INSERT INTO rhg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Hite kuham gori ze beton faiye hin loi ekkan zobin kinne. Kintu hite mata hemmika abostat meṛit foijje, hitar feṭ faṛi ãti zula niyoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Zeruzalemor hár mainše ei hota zani faijjil. Hetolla hitarar zubanot he zobinganore Hokkoldama mani Louwor Zobin name foriso.) ");
INSERT INTO rhg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","\"Kiyollahoile Zobur Šorifot leka ase: \"'Hitar bošot bari hali takok, heṛe honokiye bošoti no gorok,' Edde, \"'Hitar hamor bar oinno honokiye lok.' ");
INSERT INTO rhg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Malik Isa ãrar fũwati solafira goijjilde hiya ãrar fũwati hamiša hozon manuš aššil, ");
INSERT INTO rhg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ebbe šuruttu loti, zẽtte Isaye Yahyattu torikotor gusol loil hiya loti šuru gori hibare ãrar hãsottu behostot tuli loiza oiye foijjonto. Ehon, ei manuš okkolor butottu ekzon ãrar fũwati Isar uwafes zindar babute goba doya owa foribo.\" ");
INSERT INTO rhg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Toi hitara dui zonore tiya goraiye, Yusuf zare Barsabbas ba Yustus hoi ḍakito edde Motottiyas. ");
INSERT INTO rhg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tarfore hitara duwa goijje: \"Oh, Malik, tũi har zonor dilore zano. Ãrare dehai do ei dui zonor butottu zare basona goijjo, ");
INSERT INTO rhg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","šeba edde asabor tokka loibolla, ziyan Ehudaye eri di ze ze laikka heṛe giyegoi.\" ");
INSERT INTO rhg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tarfore hitara loṭari maijje edde Motottiyasor name loṭari uiṭṭe. Henot hite o he egarozon asabor fũwati zug diye. ");
INSERT INTO rhg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Fõnzaš dinna idor din sahabi okkol beggune ek zagat dola oiye. ");
INSERT INTO rhg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hetunot atikka asmanottu bári boyaror abazor ḍoilla ek abaz aišše edde ze górot hitara boiššil hiyanor hár mikka he abaze furaigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Toi hitara dekedde, hinore saite oinor zil okkolor ḍoil, zin šiṛiyore hitara fottizonor uwore boišše. ");
INSERT INTO rhg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Henot hitara beggune Pak Ruhuye furaiya oiye edde Ruhuye zare zendilla hota hoibar šokti diye he mozin hitara oinno oinno zuban okkolot hota howa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hẽtte Allar ḍorwala Ihudi okkol duniyair har zatittu ai Zeruzalemot bošobaš goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ar hitara ei abaz funiyore ek dol manuš zoma oiye edde hitara beggune giyan hara oigiyoi, kiyollahoile hitara fotti ekzonor nizor zubanot hota howa odde fuinne. ");
INSERT INTO rhg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hitara kub beši ammuwak edde tajjuf oiyore fusar goredde: \"So, hota hodde itara beggun ki Galilor manuš no neki? ");
INSERT INTO rhg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","To ãra kene fottikiyor nizor nizor madinna zuban hodde funir? ");
INSERT INTO rhg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Fartiyo, Madiyo edde Elamiyo, edde Mesofotamiyar bašinda okkol, Ehudiya edde Kafnadkiya, Pontus edde Ešia, ");
INSERT INTO rhg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Forugiya edde Famfuliya, Mišor edde Leviya deš šoho Kuronir ate hãsor elehar bašinda okkol edde boidešitta Romiyo, ");
INSERT INTO rhg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ihudi edde Ihudi dórmo manoya manuš okkol edde Kreṭiyo edde Arabiyo manuš okkol ze ãra, ãra ze zar zar zubanot hitara Allar ḍõr ḍõr hamor hota hodde funir!\" ");
INSERT INTO rhg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Endilla gori hitara beggune tajjuf oiye. Ar hitara suhara oiyore ekzonore ekzone fusar gora šuru goijje, \"Iyanor mani ki?\" ");
INSERT INTO rhg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Abar hodune hitarare loi ṭaṭṭa urar edde hodde, \"Hitara taza šoraf beši fifelaiyore fool oiyede.\" ");
INSERT INTO rhg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kintu Fitore he egarozon sahabir fũwati tiyaiyore he manušor dolore guzori hodde: \"Oh Ihudi manuš okkol edde Zeruzalemor bašinda okkol! Tũwara beggune ei hota zani rako edde ãr hota funo! ");
INSERT INTO rhg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tũwara ziyan mone goror hiyan no, itara šoraf hái fool oiyede no, kiyollahoile aizo binna nowa baijjede! ");
INSERT INTO rhg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kintu iyan oilde he goṭona ze hota Zuel nobir duwara howa oiye: ");
INSERT INTO rhg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"'Šeš hale endilla oibo, Allaye hor, har mainšor uwore ãi ãr Ruhure ḍali diyum. Tũwarar futziyainde nobi hisabe agam hota hoibo, He zuwan okkole deha faibo, ar he burá okkole šoppon dekibo. ");
INSERT INTO rhg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","En ki, ãr gulam edde bandi okkolor uwore, he din okkolot ãi ãr Ruh ḍali diyum, ar hitara nobi hisabe agam hota hoibo. ");
INSERT INTO rhg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ãi uwore asmanot nanan keramotor alamot ar nise duniyait nanan ḍoilla sinno, lou, oin ar dũwa dehaiyum. ");
INSERT INTO rhg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Malikor he moha mohimar din aibar age, beil andar oi zaiboi, san louwor ḍoilla oi zaiboi, ");
INSERT INTO rhg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ar ze honokiye Malikor nam ḍake, hite uddar faibo.' ");
INSERT INTO rhg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","\"Oh Israili manuš okkol, ei hotagun funo: Nasarator Isaye kuduruti ham, keramot, ar sinno okkolor duwara tũwarar hãse hiba ekzon Allar torfottu formanwala manuš. Isar duwara Allaye tũwarar maze ei ham okkol goijje, zin tũwara nize nize zano. ");
INSERT INTO rhg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Allah, ze age loti zane edde faisala gori rakkil, he mozin hibare tũwarar hatot šebi diya oiye. Ar tũwara hibare bedormiyo okkolor hatot tuli di kurušot di mari felaiyo. ");
INSERT INTO rhg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kintu Allaye hibare moron zontronar hatottu uddar gori tuli loi giyegoi, kiyollahoile hibare moute dori rakibolla šaiddo no aššil. ");
INSERT INTO rhg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Badša Daude hibar babute hor: \"'Ãi Malikore hamiša ãr sarme deki, kiyollahoile hiba ãr ḍen ḍakottu ase, zene ãi bifodot no fori. ");
INSERT INTO rhg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hetolla ãr dil kuši o, edde ãr zile kušir hota ho, ar ãr gagan o aša loi basibo. ");
INSERT INTO rhg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kiyollahoile tũi ãr foranore fatalfurot raki no zaibagoi, No diba tũi, tũwar Paki zonor gare fõsito. ");
INSERT INTO rhg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tũi ãre sinaiyo, zibon fõtore, tũwar hazirir duwara ãre kušiye furon gore.' ");
INSERT INTO rhg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","\"Báiyain okkol, he raz bongšor baf Daudor babute ãi tũwarare kula zubane hoi fariyum, ze hiba morigiyegoi edde hibare dohon gora oiye, ar hibar hobor aizo foijjonto ãrar hãse ase. ");
INSERT INTO rhg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bala, hiba ekzon nobi aššil ar hibaye zanito ze Allaye hosom hái son goijje, Daudor ekzon bongšodorore hibar šingašonot buwaibo. ");
INSERT INTO rhg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hetolla Daude agottu loti dekkil buli Isa Mosir uwafes zinda uṛar babute hoiye ze hibare fatalfurot feli raka no o, hibar ga o no fõse. ");
INSERT INTO rhg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ehon! Ei Isare Allaye morattu uwafes tuille, ar ãra beggun iyanor goba. ");
INSERT INTO rhg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Allar ḍen ḍakottu boibar ijjot hibare diya oiye edde hibaye wada gora Pak Ruhure hibar Bafottu faiye, ar ehon tũwara zin dekor edde funor hin oilde he Pak Ruh zin Isaye ḍali diye. ");
INSERT INTO rhg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud hono behostot no za, kintu hibaye nize ei hota hoiye, \"'Mabude ãr malikore hodde: \"Tui ãr ḍen ḍakottu boi, ");
INSERT INTO rhg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","zetodin ãi tor dušmon okkolore tor fottole no raki.\"' ");
INSERT INTO rhg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","\"Etolla Israilor hár mainše haṭi gori zanok: Zare tũwara kurušot marifelaila, Allaye he Isare Malik edde Mosi duni ḍoilla goijje.\" ");
INSERT INTO rhg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ei hota funone hitarar dilot tir góillefan oiye. Ar hitara Fitorore edde oinno asab okkolore hodde, \"Báiyain okkol, ãrattu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Fitore zuwabe hodde, \"Tũwara fotti ekzone gunattu mon firao edde Isa Mosir name torikotor gusol lo, toi tũwara guna maf faiba, ar hadiya hisabe tũwara Pak Ruhure faiba. ");
INSERT INTO rhg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kiyollahoile tũwaralla edde tũwarar futziyain okkololla edde zara dure ase hitara beggunolla, zar mani zedun manušore ãrar Allah Malike ḍaki anibo hitara beggunolla ei wada gora oiye.\" ");
INSERT INTO rhg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Hin bade o aro bout hota hoi Fitore goba diye, edde hitarare endilla nosiyot goijje: \"Ei zobanar naforman, horaf manuš okkolottu tũwara nizore dure raikko.\" ");
INSERT INTO rhg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Henot hitara zara Fitoror hota mani loiye, hitara torikotor gusol loiye edde henot hedin hom beši tin hazar manušore Allaye hitarar ekku fũwati zug goijje. ");
INSERT INTO rhg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ar hitara sahabi okkolor šikka lowat, edde hitarar fũwati šongo diyat, ruṭi bangat edde munazat gorat fori taito. ");
INSERT INTO rhg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Toi beggunor dilot Allar ḍor góille, kiyollahoile sahabi okkole bout tajjuiffa alamot edde sinnor ham okkol goitto. ");
INSERT INTO rhg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ar biššaši okkol beggune ekku fũwati takito edde hár kissu ek taillatt rakito. ");
INSERT INTO rhg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ar hitarar zaga zobin edde šombotti za kissu aššil hin besi zar zendilla zorulot oito he mozin beggunore baṛi diya oito. ");
INSERT INTO rhg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hitara fotti din dórmogóror uṛanot ekku fũwati dola oito, ar gór okkolot hitara hãši kušiye edde šorol mone há fiya gorito. ");
INSERT INTO rhg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hitara Allar tarif gorat taito edde hár mainše hitarare ijjot goitto. Ar zara din din uddar faito, Malike hitarare o ani itarar dolot zug gorito. ");
INSERT INTO rhg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ekdin dinor tinnwa baze munazator ṭaimot Fitor edde Yuhanna dórmogórot gil. ");
INSERT INTO rhg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Heṛe mar feṛottu loti ãtur ekzon manušore hodun manuše bar gori ani dórmogóror šundor name dorozar hãse fotti din buwai dito, zene zara dórmogórot gole hitarattu hite horat sai fare. ");
INSERT INTO rhg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Fitor edde Yuhanna dórmogórot goledde dekiyore he manušwaye hitarattu horat saiye. ");
INSERT INTO rhg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Henot Fitore edde Yuhannaye šuza hitar mikka saiye. Bade Fitore hodde: \"Ãrar mikka sa!\" ");
INSERT INTO rhg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Toi manušwaye hitarar hãsottu kissu faibar aša loi hitarar mikka sai roiye. ");
INSERT INTO rhg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Toi Fitore hodde, \"Rufa ba šuna ãttu nai, kintu za ase hin tore diyum: Nasarator Isa Mosir name uṛi tiya edde aṭ.\" ");
INSERT INTO rhg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bade Fitore hitar ḍen hat sai dori hitare tuille, henot hehon hitar ṭeng edde formuri sokto oiye. ");
INSERT INTO rhg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hite faldi uṛi ṭengor fatar uwore tiyaiye edde aṛa šuru goijje. Toi hite faldi faldi ãṛat maze Allare šukuriya guzar gori gori hitarar fũwati dórmogóror uṛanot giye. ");
INSERT INTO rhg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Har mainše zehon hite aṛi faredde edde Allar tarif goredde deikke, ");
INSERT INTO rhg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","hẽtte hitara hitare sini faijje ze hite he manuš, ze dórmogóror šundor name dorozat boi horat magito. Ar hitar uwore ze hanḍo goiṭṭe hin deki hitara beša beši tajjuf edde ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","He horat magoyawaye kintu Fitor edde Yuhannar fisa no sare. Fitoror he hamot hár manuš okkol tajjuf oiyore Soloimanor haissarar tole hitarare giri doijje. ");
INSERT INTO rhg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hetunot Fitore hodde: \"Israili okkol! Tũwara iyanot tajjuf kiyolla or? Ãrar nizor šoktiye otóba Allare ḍorai de he gunor zoriya itare ãṛi faribolla šokti diyi mone gori kiyolla tũwara ãrar uzu sai taikko? ");
INSERT INTO rhg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","No, Ibrahim edde Isak edde Yakubor Allah, ãrar baf dadar Allaye ei hamor duwara hibar nizor gulam Isar mohima forhaš goijje. Tũwara to Isare mari felaibolla dori dila. Filate hibare eri dito sail, kintu tũwara Filator muntu hibare ošikar goijjo. ");
INSERT INTO rhg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tũwara he Fobitro edde Niyaiwalare ošikar gori ekzon kuni manušore tũwaralla eri dito hoiyo. ");
INSERT INTO rhg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ze zibon doya hibare tũwara mari felaila, kintu Allaye hibare zinda gori tuille, hiyanor goba ãra. ");
INSERT INTO rhg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ei manuš iba zare tũwara dekor edde zare tũwara sino, hite Isar namor gune he šokti hamaiye. Isar butottu di ze biššaš ãra fai hiyane ei manušware furafuri bafe aram goijje, zendilla tũwara beggune dekor. ");
INSERT INTO rhg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","\"Ehon báiyain okkol, ãi zani tũwara tũwarar neta okkolor ḍoil no buziyore Isare kurušor uwore mari felaiyo. ");
INSERT INTO rhg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kintu Allaye hibar Mosiye ze duk šoibo he hota ei bafe furon goijje, ziyan hibaye bout age har nobi okkolor duwara howabail. ");
INSERT INTO rhg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hetolla, tũwara mon firo, toi tũwarar guna fũsi fela oibo. ");
INSERT INTO rhg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ar he Mosi zare tũwaralla basona gora oiye mani Isa, hibare defeṛaiyore tũwarare tottaza gori tuli fare. ");
INSERT INTO rhg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Allaye hár kissure abar agor ḍoilla uwafes firai anibode hibar he ṭaim nuwaiye foijjonto hibattu behostot taka foribo, zendilla hibaye bout age hibar nobi okkolor muke hoil. ");
INSERT INTO rhg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musaye to hoiye, 'Mabud Allaye tũwaralla ãr ḍoilla ekzon nobi tũwarar nizor zatir butottu tulibo. Har kissu zin tũwarare hibaye ho hin beggun funa foribo. ");
INSERT INTO rhg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ze hibar hota no funibo hitare hibar mainšor butottu furafuri bafe fũsi fela oibo.' ");
INSERT INTO rhg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","\"Hin bade o, nobi Samuelottu loti šuru gori har nobi okkol zara kalam hoi giye hitara o ei din okkolot zin goṭer hinor babute hoi giye. ");
INSERT INTO rhg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ar tũwara to he nobi okkolor bongšor manuš edde he wadar suktir šiyardar, ziyan Allaye tũwarar bafdada okkol loi goijjil, hẽtte Allaye Ibrahimore hoil, 'Tor bongšor butottu di duniyair har zatiye rahamot faibo.' ");
INSERT INTO rhg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Allaye hibar gulam Isare tũwarar sarme tiya goraiye foila, hibare defeṛaiye, ze kufõtottu firi aiye hitare rahamot goribolla.\" ");
INSERT INTO rhg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hitara ehono mainšor loi hota howat ase, hen šomot imam okkol edde dórmogór sõloya okkolor boro edde Sadduki okkol aišše. ");
INSERT INTO rhg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Fitor edde Yuhannaye manuš okkolore šikka dedde edde Isar duwara mora okkol abar uwafes uṛar babute tobolig goredde deki hitara beši gušša oiye. ");
INSERT INTO rhg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hitara Fitor edde Yuhannare doijje. He din hãzinna oi giyegoi buli tarforor din foijjonto hitarare ziyolot bon gori raikke. ");
INSERT INTO rhg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kintu hitara zara Fitoror boyan fuinne hitara boute biššaš ainne, henot biššaši furuš manuš okkolor dol barizaiyore hom beši fãs hazar oiye. ");
INSERT INTO rhg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ihudi okkolor neta okkol, murubbi okkol, edde alem okkol ekku fũwati Zeruzalem dola oiye. ");
INSERT INTO rhg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","He ḍõr imam Annas o heṛe hazir aššil, ar Kaifas, Yuhanna edde Alekzendar, edde he ḍõr imamor góror oinno manuš okkol o heṛe aššil. ");
INSERT INTO rhg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hitara Fitor edde Yuhannare hitarar sarmottu tiya goraiyore fusar goijje: \"Tũwara kiyor šokti loi otóba har nam loi ei ham goijjo?\" ");
INSERT INTO rhg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hetunot Fitore Pak Ruhuye furaiya oiyore hitarare hodde: \"Ãrar neta okkol, murubbi okkol! ");
INSERT INTO rhg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ekzon ãtur manušore balai goijji buli zehon aijja ãrare zera gora or edde ei manušwa kengori bala oiye, he babute fusar gora or. ");
INSERT INTO rhg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Henoile tũwara beggune edde har Israil zatiye, ei hota zani rako: Iyan Nasarator Isa Mosi loi, zare tũwara kurušor uwore mari felaila edde zare Allaye mora okkolor butottu tuille, hibar šokti loi ei manušwa furafuri bafe aram oiyore õnorar sarme tiyai roiye. ");
INSERT INTO rhg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hiba oilde \"'he fattor, zibare tũwara raz mistiri okkole bad diyo, kintu hiba i har beggunottuwaro dorhari fattor oiye.' ");
INSERT INTO rhg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uddar ar honokiyor hãse fa no za, kiyollahoile asmanor nise manušor butore en ar hono nam diya no o, ze namor zoriya ãra uddar oi fari.\" ");
INSERT INTO rhg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hitara Fitor edde Yuhannar himmot deikke, ar itara ze anfora edde awam manuš hiyan dekiyore hitara tajjuf oiye, ar itara ze Isar fũwati aššil hiyan buzi faijje. ");
INSERT INTO rhg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aram oiyede manušwa, Fitor edde Yuhannar fũwati tiyat ase, dekiyore hitara itarar berudde hoibar ar kissu no aššil. ");
INSERT INTO rhg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Etolla hitarare bisar šobattu bare zaibolla hokum diye edde hitara ekku fũwati biyasanat boišše. ");
INSERT INTO rhg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Hitara hodde: \"Ãra ei manuš okkolore loi ken goriyum? Zeruzalemot asede har kiye zane ze itara ekkan ḍõr keramoti ham goijje, ar hiyan ãra ošikar gori no fariyum. ");
INSERT INTO rhg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kintu iyan aro mainšor hãse sorai zai no farefan ei manuš okkolore domki diya foribo, toi zene itara ar honokiyore ei namor babute hono hota no ho.\" ");
INSERT INTO rhg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tarfore hitara Fitor edde Yuhannare abar butore ḍaki aniyore hokum diye, zene hitara Isar name hono hota no ho otóba šikka ebbere no de. ");
INSERT INTO rhg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Fitor edde Yuhannaye zuwabe hodde: \"Tũwarar hokum falon goijjum ne naki Allar hokum falon goijjum? Allar nozorot honnan ṭik, tũwara hiyan bisar gori so! ");
INSERT INTO rhg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kiyollahoile ãra zin dekki edde fuinni hinor babute no hoi tai no faijjum.\" ");
INSERT INTO rhg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Toi hitarare aro sokto gori domki diyore eri diye. Kiyollahoile hitara itarare šaza dibolla hono ufai tuwai no fa, haron zin goṭṭil hinolla hár manuš okkole Allare tarif goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ze manušware keramotir duwara aram gora oiye hitar umor sališ bosorottuwaro beši. ");
INSERT INTO rhg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hitara hentu sara fai bade, hitarar nizor manuš okkolor hãse giye, ar ḍõr imam edde murubbi okkole zin zin hoil har kissu hitarare zanaiye. ");
INSERT INTO rhg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ei hota funiyore hitara beggune mili ek diyane Allar mutallek munazat gori hodde: \"Oh Malik, tũi asman zobin, doriya, hinor butore ze kissu ase beggun sirišti goijjo. ");
INSERT INTO rhg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tũi Pak Ruhur duwara tũwar gulam ãrar fordada Daudor muk diyore howaila: \"'Har zatir manuš okkole kiyolla suhara oi sesamesi gorer? Kiyolla manuš okkole hannak misa misi Allar berudde zar? ");
INSERT INTO rhg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Duniyair badša okkole Mabud edde hibar Mosir berudde tiyaiye, ar šašon goroya okkole ekkui fũwati oiye.' ");
INSERT INTO rhg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hendilla ode ode oiye, tũwar Paki gulam Isa, zare tũi Mosi hisabe basona goijjila, badša Herud edde Pontus Filate, ei šohorot hibar berudde Oihudi okkolor fũwati edde Israili okkolor fũwati hat milail. ");
INSERT INTO rhg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tũwar kuduruti edde issa mozin zin zin goṭibode tũi age loti ṭik gori rakkila, hitara hendilla goijje. ");
INSERT INTO rhg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ar ehon Mabud, itara ãrare ki bafe ḍor lagar tũi kiyal goror. Tũwar gulam okkolore endilla šokti do zene kub himmot loi hitara tũwar kalam hoi fare. ");
INSERT INTO rhg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tũwar hat barai do, zene tũwar Paki gulam Isar name hitara manuš okkolore aram gori fare edde keramot edde sinnor ham okkol gori fare.\" ");
INSERT INTO rhg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ze zagat hitara dola oiye, munazat gori bade he zagagan hafi uiṭṭe. Ar hitara beggune Pak Ruhuye furaiya oi fũwati šahoš loi Allar kalam howa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Har biššaši okkol beggunor mon dil ek aššil. Hitarar nizor dón šombottire nizor hoi dabi no gorito, kintu hitarattu zin aššil hinore beggun loi borat gorito. ");
INSERT INTO rhg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Asab okkole ḍõr šokti loi goba diya šuru goijje ze Isa morattu zinda uṛi giyegoi, ar hitara beggunor uwore Allar ofurani rahamot aššil. ");
INSERT INTO rhg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hitarattu hono obafi manuš nuaššil, kiyollahoile zarattu zobin otóba gór aššil hitara hin okkol besi ṭĩya foiša anito, ");
INSERT INTO rhg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","edde asab okkolor ṭengor ḍake rakito. Bade zattu zendilla zorulot he bafe hitare diya oito. ");
INSERT INTO rhg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusuf, Kiprus ḍiyar ekzon Levi. Hitare asab okkole Barnabas hoito, zar mani tuwajjo doyar fut. ");
INSERT INTO rhg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hitattu ekkan zobin aššil, hite hiyan besi ṭĩya ani asab okkolor ṭengor ḍake rakkil. ");
INSERT INTO rhg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ehon, Ananiyas name ekzon manuš edde hitar bou Safiraye ekkan zobin šombotti beisse. ");
INSERT INTO rhg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hite ṭiyattu hodun nizolla raki diyore baki ṭiyagun asab okkolor ṭengor ḍake raikkegoi, ar hite hen goijjede hitar bouwe o furafuri zanito. ");
INSERT INTO rhg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hetunot Fitore hodde, \"Ananiyas, Šoitane tor mon kengori dokol goijje, ziyanor zoriya tui Pak Ruhur hãse misa hota hoiyos edde zobin besa ṭiyattu hodun nizolla raki diyos? ");
INSERT INTO rhg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Besibar age ki zobingan tor nu aššil ne? Ar besi bade o ki ṭiyagun tor hatot nu aššil ne? To kiyolla tui endilla ham goribi ṭik goijjos? Tui šude mainšor loi misa no hos, kintu Allar loi misa hoiyos.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ei hota funi mottor Ananiyas meṛit fori mori giyegoi. Ei goṭonar hota zara fuinne hitara beggune beša beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bade hozon zuwan manuš aišše edde hitar gat kafonor hor berai diye edde bare loi zai hitare dohon gorai felaiye. ");
INSERT INTO rhg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iyar tin gonḍa bade Ananiyasor bou heṛe aišše, kintu ki oiye hin hibaye no zanito. ");
INSERT INTO rhg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fitore hibare fusar goredde, \"Sai ho sai, tũwara zobin besiyore beggun failade in ne ki?\" Hibaye hodde, \"Oi hin beggun in.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hetunot Fitore hodde, \"Tũwara kengori Mabudor Ruhure entehan goribolla razi oila? Sa, ze mainše tor zamaire dohon goraito aišše hitara dorozar hãsat aišše, ar hitara tore o baire loizaibo.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Safira hetunot Fitoror ṭengor ḍake mori giyegoi. Ar he zuwan manuš okkole butore aiyore dekedde hiba mora, toi hibare baire loizai hibar zamair ḍakottu dohon goraiye. ");
INSERT INTO rhg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hetunot zomator manuš edde oinno zara he hota fuinne hitara beggune beši ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Asab okkolor duwara bout ḍoilla keramot edde sinnor ham okkol mainšor maze gora oiye. Ar biššaši okkol beggune dórmogóror Soloimanor haissarat ekku fũwati dola oito. ");
INSERT INTO rhg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Oinno hono mainše hitarar loi dola oibolla himmot no gorito, zodi o hitarare manuš okkole kub beši ijjot gorito. ");
INSERT INTO rhg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ar din din bout furuš edde mayafuwain okkol Malikor uwore biššaš ainne edde Malikor dolor fũwati zug goijje. ");
INSERT INTO rhg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ar manuš okkole biyaraimma okkolore rastar uwore bar gori ani haṭor uwore edde faṛir uwore neṛai rakito, zene rasta bai zaibar šomot ebbe no oile Fitoror sabagan oile hitarar hono hono kiyor uwore fore. ");
INSERT INTO rhg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Zeruzalemor atehasor fara okkolottu bout manuš okkole hitarar biyaraimma okkolore edde horaf zine faiyede manuš okkolore bar gori anito edde hitara beggune aram oito. ");
INSERT INTO rhg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hetunot ḍõr imam edde hitar har sãti okkol, zara Sadduki dolor manuš, hitara riše zoli uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hitara asab okkolore dori šorkari ziyolot diye. ");
INSERT INTO rhg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kintu raitta Mabudor ekzon firistaye ziyolor dorozagun kuli hitarare hentu baire niyalai ani hodde, ");
INSERT INTO rhg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"Zo, tũwara dórmogóror uṛanot tiyaiore manuš okkolore ei noya zibonor babute har hóbor hogoi.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ei hota funiyore tarfore binna kub sore hitara dórmogórot giye edde šikka diya šuru goijje. Toi heṛe maze, ḍõr imam edde hitar fũwajja okkol, zara Sadduki dol, mani Israili okkolor murubbi neta beggunore loi ek ḍõr bisar muzoliš ḍaikke edde asab okkolore anibolla hoekzon manušore ziyolot defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kintu zehon faharadar okkol heṛe aišše, heṛe hitarare no fa. Hitara uwafes firi zaiyore ei hóbor hoiyegoi, ");
INSERT INTO rhg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","\"Ãra ziyolor doroza mojbut gori ṭala lagaiya asede edde doroza doroza faharadar okkol tiyai roiyede lot faiyi, kintu doroza kuli honokiyore butore no dekilam.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ei hota funi dórmogór sõloya garḍ okkolor boro edde ḍõr imam okkol suhara oi bafa šuru goijje, iyanor anzam ki oibo,hoi. ");
INSERT INTO rhg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hetunot ekzon manuš aiyore hodde, \"So, ze manuš okkolore tũwara ziyolot dila hitara dórmogóror uṛanot tiyaiyore mainšore šikka der.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hetunot faharadar okkolor boroye hitar manuš okkol loi zaiyore hitarare dori ainne. Kintu mainše fattor maribo ḍore hitara asab okkolor uwore hono zobodusti no gore. ");
INSERT INTO rhg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hitara asab okkolore aniyore bisar šobar sarme tiya goraiye. Hetunot ḍõr imame asab okkolore hodde: ");
INSERT INTO rhg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","\"Ãra tũwarare hora bafe hokum dilam he namor babute šikka no dibolla, kintu tũwara tũwarar šikkare Zeruzalemor aga gura borai felaiyo, edde he manušwar louwor dai ãrare goitto sor.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hetunot Fitor edde oinno asab okkole zuwab dedde: \"Manušor hokum falon goribattuwaro bolke Allar hokum ãra falon goronnan zoruri! ");
INSERT INTO rhg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zare õnora ek gasor uwore ṭaikko edde mari felaiyo, ãrar baf dadar Allaye he Isare morattu uwafes tuille. ");
INSERT INTO rhg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allaye hibare badša edde Basailoya hisabe hibar ḍen ḍakottu boibar ijjot diye, zene hibaye Israili okkolore gunattu mon firat ani fare edde gunar maf di fare. ");
INSERT INTO rhg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ãra in beggunor babute goba, ar zara Allar baiddo o, hitarare Allaye he Pak Ruhure diye, he Pak Ruh o hibar goba.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ei hota funi hitara guššaye oin oiye edde hitarare furai felaibolla ereda loiye. ");
INSERT INTO rhg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kintu he bisar šobattu Gamaliel name ekzon Foroši alem, zare hár mainše ijjot goitto, hiba tiyai giyegoi edde ei manuššunore hotun baire loizai raka oibolla hokum diye. ");
INSERT INTO rhg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tarfore hibaye ḍõr šobare hodde: \"Israili okkol! Tũwara ei manuššunore kissu goribar age bala gori bafi so. ");
INSERT INTO rhg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Oto! kissu din age Tevdas name ekzon manuš muntu aišše, hitare hite ekzon ḍõr manuš dabi goijjil, ar hom beši sair šot mainše hitar fũwati zug dil. Hitare mari fela oiye edde hitar har sãti okkol šiṛašitta oi giyegoi edde hãzi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hite bade, manuš gona oibar šomot endilla oilo, Galilot Ehudaye ek dol manušore failo, kintu hite o mori giyegoi, ar hitar sãti okkol beggun šiṛašiṭṭa oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hetolla ãi tũwarare hoir: Ei manuš okkolore kissu no goijjo. Itarare sari do, kiyollahoile itarar moksud edde haz harbar zodi manušor torfottu oi take, toile hin dongšo oi zaiboi. ");
INSERT INTO rhg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kintu zodi Allar torfottu o, toile tũwara itarare tamai no fariba. Hetolla hũšiyar! Ar no oile šude dekiba, tũwara Allar berudde larai goror.\" ");
INSERT INTO rhg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Toi hitara hibar mošowarat razi oiye. Hitara asab okkolore abar butore ḍaki ainne edde hitarare bet marabaiye. Tarfore hitarare Isar nam loi tobolig no goribolla hokum diyore bade eri diye. ");
INSERT INTO rhg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Henot Isar namolla buli asab okkole ze ohomani oibar laikka oiye, hiyanolla kuši gori gori hitara he bisar šobattu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hitara fotti din dórmogórot edde góre góre zai šikka diye, hitara hinore tiya gorai no fele, Isa ze Mosi he kušir hóbor tobolig gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ar he ṭaimot, zehon biššaši okkol bari uṛa šuru goijje, hitarar butore Girik baša hoiya okkole Ibroni baša hoiya okkolore endilla hoi hosuri diya šuru goijje, ze fotti din hána dibar šomot hitarar rari mayafuwain okkole kissu no fa. ");
INSERT INTO rhg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Henot maze he barozon asabe har biššaši okkolore ek zagat ḍakiyore hodde: \"Ãra Allar kalam tobolig gora bad gori hána diyar befar loi fori taka, iyan ãralla ṭik no. ");
INSERT INTO rhg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kintu oh báiyain okkol tũwara tũwarar butore zarar bala nam ase edde zara Pak Ruhuye furaiya edde giyani manuš hendilla hãt zonore basi lo. Hitarare ãra ei hamor bar diyum. ");
INSERT INTO rhg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kintu ãra munazat edde kalam toboligot diyan diyum.\" ");
INSERT INTO rhg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ei mošowarare dolor beggune bala gori goisse edde hitara biššaš edde Pak Ruhuye boron botti Stifanore, bade Filip, Frokorus, Nikanor, Timon, Farmenas, edde Anṭiyok šohoror Ihudi dórmot zat diya Nikolas, itarare basi loiye. ");
INSERT INTO rhg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bade asab okkolor sarme hitarare tiya goraiye, zara duwa goijje edde hitarar uwore hat raikke. ");
INSERT INTO rhg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Toi Allar kalam ei bafe sorai giyegoi edde Zeruzalemot biššaši okkol beša beši bari uṛi gilgoi. Ar ek dol ḍor imam okkolor dole o biššašor baiddota oiye. ");
INSERT INTO rhg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stifane Allar rahamot edde šokti furaiya oiyore manuš okkolor butore bout keramot edde sinnor ham okkol goijje. ");
INSERT INTO rhg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ze muzolišhanare azad gora manuš okkolor sinagog hoito, hiyanor hoekzon manuše Stifanor fisali laigge. Hitara aššilde Kuroni edde Alekzanderiya šohor ar Kilikiya edde Ešiar hoekzon Ihudi okkol, hitara Stifan loi hotat bara bari diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kintu Stifane Pak Ruhur duwara kub giyan loi hota hoiye. Hetolla hitara hibar berudde tiyai no fare. ");
INSERT INTO rhg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hetunot he Ihudi okkole gufone hoekzon Ihudire endilla hoibolla uskani diye, \"Ãra Stifanore nobi Musa edde Allar berudde kuferi goredde funni.\" ");
INSERT INTO rhg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Endilla gori hitara mainšore, murubbi okkolore edde Alem okkolore hafai tuille. Ar hitara Stifanore dori he ḍõr bisar šobar sarme ainne. ");
INSERT INTO rhg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hitara ho ekzon misa goba tiyagoraiye, hitara hodde, \"Ei manušwaye hamiša dórmogóror edde Musar ainor berudde hota ho. ");
INSERT INTO rhg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ãra ite endilla hodde funni ze, he Nasarator Isaye bole ei dórmogór bangi felaibo edde Musaye ze ain okkol ãrare di giye hinore bole bodoli felaibo.\" ");
INSERT INTO rhg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","He ḍõr bisar šobat boiššilde hitara beggune Stifanor uzu sadde Stifanor siyaragan ek firistar siyarar ḍoil oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Toi ḍõr imame Stifanore fusar goijje, \"Ei hota ki soiyi ne?\" ");
INSERT INTO rhg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Zuwabe Stifane hodde: \"Oh ãr báiyain edde baf okkol ãr hota funo! Ãrar fordada Ibrahim Harran šohorot bošoti loibar age zẽtte Mesofotemiya dešot aššil, hẽtte fohoraiwala Allaye hibare deha diyore hoil, ");
INSERT INTO rhg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Tui tor nizor deš edde tor egena gušti feli ãi tore ze deš dehaiyum heṛe zagoi.' ");
INSERT INTO rhg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","\"Toi hiba Kalaḍiya okkolor deš felai Harran šohorot gil edde heṛe bošoti loil. Ar hibar baf mori bade, Allaye Ibrahimore ei dešot defeṛail, zeṛe tũwara ehon bošoti goror. ");
INSERT INTO rhg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Allaye hibare nizolla hono zobin no de, enki ekkan ṭeng raki farefan zaga o no, kintu hibaye wada goijjil ze hibare edde hibar bade hibar bongšor manuš okkolore hitarar miraz hisabe he dešore dibo, zodi o he šomot Ibrahimottu hono fuwain no aššil. ");
INSERT INTO rhg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Allaye hibare endilla hoil: 'Tor bongšodor okkol bidešot bošobaš goribo. Manuš okkole hitarare gulam banai rakibo edde sair šot bosor dori hitarar uwore zulum salaibo.' ");
INSERT INTO rhg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Allaye aro hodde, 'Kintu ze zatiye hitarare gulam banaibo ãi hitarare šasti diyum. Bade hitara he dešottu niyoli aiyore ei zagat ãr ebadot goribo.' ");
INSERT INTO rhg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tarfore Allaye Ibrahimore wadar suktir sinno hisabe azomi goraibar niyom dil, bade hiba Isakor baf oiye edde ašṭo dinor din hibare azomi gora oiye. Hendilla Isake Yakubore edde Yakube he baro gušṭir baf okkolore azomi goraiye. ");
INSERT INTO rhg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","\"He baro bongšor baf okkole riš gori Yusufore gulam hisabe Mišor dešot besifelail. Kintu Allah hibar fũwati aššil, ");
INSERT INTO rhg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","edde har duk hošṭottu hibare uddar goijje. Allaye hibare giyan dan goijjil edde Mišor dešot razar bala nozorot felabail. Hetolla he razaye hibare Mišor dešor šašon goroya edde razar nizor gór dehafuna goriballa buwail. ");
INSERT INTO rhg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","\"Tarfore Mišor agagura edde Kenanot raṭ deha dilo, edde beši ḍõr hošṭo hazir oiye hetunot ãrar bafdada okkole haiddo lot no fail. ");
INSERT INTO rhg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kintu Mišorot gĩyu ase funi Yakube ãrar bafdada okkolore foila bar heṛe defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dusora bar zẽtte hitara aišše Yusufe hibar báiyaindore sin diye edde razaye Yusufor górwala okkolor babute zani faijje. ");
INSERT INTO rhg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iyar bade, Yusufe hibar baf Yakub edde góror gušṭi ṭiya, muṭ hoittor fãszon, beggunore ḍaki anibolla hóbor defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tarfore Yakub lami Mišor dešot gil, zeṛe hiba edde ãrar bafdada okkol entehal goijje. ");
INSERT INTO rhg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hitarare Šekimot ana oiye edde ze hoboror gãt Ibrahime Šekim šohoror Hamoror fũwain okkolottu rufa diyore kini loil, hibat dohon gora oil. ");
INSERT INTO rhg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","\"Ibrahimor hãse Allaye ze wada goijje hin furon oibar ṭaim zehon hãse aišše, hetunot deha zadde ãrar manušzon okkol kub beši bari giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tarfore Mišor dešot en 'ekzon noya badša oiye, ze Yusufor babute kissu no zanito.' ");
INSERT INTO rhg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","He badšaye ãrar manuš okkolore ṭokaito edde ãrar bafdada okkolor uwore zulum goitto, enki hitarattu ze futziyain okkol zormo oito hitara mori zagoifan he gura fuwain okkolore baire felai rakibolla zur gorito. ");
INSERT INTO rhg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","\"He šomot Musa zormo oil. Musa Allar šanot ekzon beši šundojja fuwa aššil. Hibare tin maš foijjonto baf mar górot lalon falon gora oil. ");
INSERT INTO rhg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bade zẽtte hibare baire felai raka oiye, hẽtte razar ziye tuli loizaiyore hibare nizor fuwa hisabe lalon falon goijje. ");
INSERT INTO rhg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mišoriyo okkolor har giyane en bafe šikkita oiye, hiba hotaye edde hame šoktišali aššil. ");
INSERT INTO rhg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","\"Musar umor sališ bosor oiyede šomot hibaye Israili báiyain okkol loi deha goitto zaibo faisela loil. ");
INSERT INTO rhg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ar heṛe Mišoriyo ekzone hitarar ekzonore horaf bebohar goredde Musaye deikke, toi hibaye ei Israili manušwar foikka oibolla giye edde he Mišoriyo manušware marifelaiyore hiyanor daiya loiye. ");
INSERT INTO rhg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musaye mone gojjil hibar nizor manuš okkole buzibo ze Allaye hibar duwara hitarare uddar goribo, kintu hitara hiyan buzi no fare. ");
INSERT INTO rhg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tarforor din Musaye duizon Israilire mara mari goredde deikke. Hetunot hitarare milai dibolla hodde, 'Oh báiyain, tũwara to bái bái, to kiyolla ekzone ekzon loi endilla horaf bebohar goror?' ");
INSERT INTO rhg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","\"Kintu ze manušwaye horaf bebohar goijjil hite Musare ḍeikka mari lorai diyore hodde, 'Ãrar uwore tore šašon goroya edde bisarhar hone tuille? ");
INSERT INTO rhg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Gelde hailla zendilla gori he Mišoriyo manušware mari felaiyos, ãre o ki hendilla gori mari felaito sos?' ");
INSERT INTO rhg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ei hota funi Musa dai zaigoi Midiyan dešot musafer hisabe bošobaš gora šuru goijje. Heṛe hibattu duizon morod fuwain zormo oil. ");
INSERT INTO rhg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","\"Sališ bosor farai zaigoi bade, Sinai faharor ḍake bošoti sara elehat maze ek firistaye ek zolonto zaḍḍowar oinor butottu Musare deha diye. ");
INSERT INTO rhg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musaye dekiyore tajjuf oil. Hibaye aro hãse zai saibolla zehon giye, hetunot Mabudor abaz fuinne: ");
INSERT INTO rhg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Ãi tor fordada okkolor Allah, Ibrahim, Isak edde Yakubor Allah.' Kintu Musaye ḍore hafa šuru goijje, hikka saibolla o himmot no gore. ");
INSERT INTO rhg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","\"Hetunot Mabude hibare hodde, 'Tor ṭengor zuta kulifela, kiyollahoile ze zagat tui tiyaiyos hiyan Paki zaga. ");
INSERT INTO rhg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mišor dešot ãr bonda okkolor uwore ze zulum or hin ãi dekki. Ãi hitarar hatoranir ḍak funni edde hitarare uddar goribolla ãi nise lami aišši. Ehon ãi tore Mišor dešot uwafes defeṛaiyum.' ");
INSERT INTO rhg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","\"Iba oilde he Musa zare Israili okkole en hoi batil goijjil, 'Tore šašon goroya edde bisarhar hone banaiye.' Ze firistaye he zaḍḍowar butottu Musare deha dil, he firistar duwara Allah nize ei Musare Israili okkolor šašon goroya edde uddar goroya hisabe Mišorot defeṛail. ");
INSERT INTO rhg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ei Musaye Mišor dešottu Israili okkolore niyolai loi ainnil edde Mišor dešot, louwor doriyar ḍake edde sališ bosorfan bošoti sara elehat bout keramot edde sinnor ham okkol goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","\"Iba oilde he Musa ze Israili okkolore hoil, 'Allaye tũwarar nizor báiyain okkolor butottu tũwaralla ãr ḍoil ekzon nobi tiya goraibo.' ");
INSERT INTO rhg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ei Musa bošoti sara elehat maze Israili okkolor dolor butore, ãrar fordada okkolor fũwati aššil. Ze firistaye Sinai faharottu hota hoil ei Musaye he firistar fũwati heṛe aššil. Ãrare dibolla hibaye zinda kalam fail. ");
INSERT INTO rhg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","\"Kintu ãrar fordada okkole Musare mainto no sa. Hiyanor bodole hitara hibare batil goijjil edde hitarar dil Mišoror uzu oigilgoi. ");
INSERT INTO rhg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hitara Harunore hodde, 'Ãrare fõt dehai loi zai farefan dev devi banao, kiyollahoile ze Musaye Mišor dešottu ãrare niyolai loi ainne hibar ki oiye ãra hoi no fari. ");
INSERT INTO rhg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","He ṭaimot maze hitara gorur so ḍoil gori uggwa mutti tiyar goijje. Hitara he muttir mutallek zanuwar kurbani goijje edde nizor hate banaiyede hiyanor uwore hitara kušir mela goijje. ");
INSERT INTO rhg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kintu Allaye hitarattu muk firai felaiye edde asmanor san šurzo edde tara fũzat maze hitarare felai raikke, zendilla nobi okkolor kitabot leka ase: \"'Oh, Israil zati, bošoti sara elehat he sališ bosorfan tũwara ki ãr mutallek hono zandar kurbani ba hadiya dila ne? ");
INSERT INTO rhg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","No, no do, bolke tũwara to Mulok devotar mutti, ar Rifon devotar tara, tũwara bar gori boi loi gila, fũza goribar niyote he mutti okkol banaila. Kintu ãi tũwarare Babilonor okule felai diyum.' ");
INSERT INTO rhg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","\"Bošoti sara elehat ãrar fordada okkolottu uggwa ṭambu aššil zibaye Allah hitarar fũwati aššilde forman diye. Allaye Musare zendilla gori hokum dil edde Musare ze nomuna dehail he mozin ei ṭambu tiyar gora oil. ");
INSERT INTO rhg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ãrar fordada okkol he ṭambu faiyore hitarar neta Yosbar anḍare hiyan hitarar fũware ei dešot loi aššil. Allaye hitarar sarmottu oinno zatire lorai dil edde hitara ei deššan adai goijjil. Daudor ṭaim foijjonto he ṭambu ei dešot aššil. ");
INSERT INTO rhg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Hibaye Allattu rahamot fail edde ejazot dibolla foriyad goijjil zene Yakubor bongšolla ekkan dórmogór hibaye tiyar gori fare. ");
INSERT INTO rhg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kintu Soloimane hiballa ekkan dórmogór tiyar goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","\"Zen oibo ok, šorbo šoktiwala Allah manušor tiyari górot no take, zendilla nobiye hor: ");
INSERT INTO rhg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"'Behosto oilde ãr šingašon, ar duniyai ãr ṭeng rakibar zaga. Ãlla tui hondilla gór tiyar goribi, Mabude hor. Zaga hiyan hoṛe, zeṛe ãi zirai faijjum? ");
INSERT INTO rhg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ei šob ziniš beggun ki ãi nizor hate foida no gori ne?' ");
INSERT INTO rhg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","\"Oh ek gũwaijja zati! Tũwarar han edde dil Oihudi okkolor ḍoil, ar tũwara o tũwarar fordada okkolor ḍoil. Tũwara šob šome Pak Ruhure bad di tako. ");
INSERT INTO rhg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","En hono ki nobi ase, zare tũwarar fordada okkole zulum no gore? Hitara hitarare mari felail, zara agottu loti he niyaiwala aibar babute tobolig goijjil. Ar ehon tũwara hibar loi dúha bazi goijjo edde mari felaiyo. ");
INSERT INTO rhg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Firista okkolor duwara tũwarar hãse to ain diya oil, kintu tũwara hin falon no goro.\" ");
INSERT INTO rhg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ei hota okkol funi hitara guššaye oin oi giyegoi edde Stifanor berudde dat loi dat kirkiraiye. ");
INSERT INTO rhg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kintu Stifane, Pak Ruhuye furaiya oi behostor mikka sai taikke edde heṛe Allar mohimar deha faiye. Hibaye Isare Allar den ḍakottu tiyai taikkede dekiyore, ");
INSERT INTO rhg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stifane hodde, \"So, ãi behosto kula asede dekir edde Adomor Fut Allar ḍen ḍakottu tiyai roiye.\" ");
INSERT INTO rhg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Henot hitara hanot õl diye edde zure guzoriyore beggune Stifanor uwore zafai foijje. ");
INSERT INTO rhg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bade hitara Stifanore fattor maribolla ṭani šohoror bar kule loigiye, ar goba okkole hitarar zubba okkol gattu kuli Šaulus name ek zuwan fuwar ṭengor ḍake eijje. ");
INSERT INTO rhg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hitara Stifanore fattor maredde šomot, hibaye munazat goijje edde hodde, \"Malik Isa, ãr ruhure gosi lo.\" ");
INSERT INTO rhg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tarfore hibaye ãṛu felaiye edde ḍõr gori guzojje, \"Malik, itarar berudde ei gunare monot no raikko,\" ei hota hoi hiba zurai giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul o Stifanore kun gorat razi aššil. He din Zeruzalemot Isayi zomator manuš okkolor uwore beša beši zulum owa šuru oiye. Henot asab okkolgun bade ar har biššaši okkol Ehudiya edde Sameriyar hár zagat šiṛa šitta oi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Hoekzon allawala manuše Stifanore dohon goraiye edde hiballa kub beši bilag goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kintu Saule he zomatore dongšo gori felaibar kušišot góre góre zai zomator mayafuwain edde morod fuwain okkolore ṭani ani ani ziyolot diya šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ze biššaši okkol šiṛa šiṭṭa oigilgoi, hitara sairo mikka giye edde kalam tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","He šomot Filipe Sameriyar ek šohorot zai Mosir babute tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ar beggune zara hibar hota fuinne edde ze keramoti ham okkol hibaye goijje, hin saiyore hitara hibar hota mon di fuinne. ");
INSERT INTO rhg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bout kiyor butottu napak ruh okkol sikkar mari niyoli gilgoi edde bout leng biyaraimma edde ãtur okkol aram oiye. ");
INSERT INTO rhg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Henot heṛe šohorot ek ḍõr kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","He šohorot Simon name ekzon manuš aššil, ze bout din dori heṛe zadu dehaito, henot Sameriyar manuš okkol ebbere tajjuf oi zaitogoi. Hite hitare ek ḍõr manuš fukarito. ");
INSERT INTO rhg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ar šoṛo ḍõr beggune hitar hotare dam dito edde hoito: \"Allar ze kudurutire ḍõr kuduruti howa o, ite he ḍõr kuduruti.\" ");
INSERT INTO rhg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mainše hitar hota mozin solito, kiyollahoile bout din dori hite hitar zadu dehaiyore hitarare tajjuf gorat aššil. ");
INSERT INTO rhg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kintu Filipe zehon Allar raijjor babute edde Isa Mosir namor kušir hóbor tobolig goijje hetunot manuš okkole hibar hotat biššaš ainne, Hitara mayafuwain edde morod fuwain beggune torikotor gusol loiye. ");
INSERT INTO rhg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","He Simon nize o biššaš ainne, toi hite torikotor gusol loi bade Filipor fũwati fũwati gil, ar sinno edde ḍõr ḍõr keramoti ham okkol deki hite ammuwak oil. ");
INSERT INTO rhg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Zeruzalemor asab okkole zehon fuinne, ze Sameriyar manuš okkole Allar kalamor uwore biššaš ainne, hetunot hitara Fitor edde Yuhannare hitarar hãse defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hitara heṛe fõsi bade, hitara Pak Ruhure faibolla duwa goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kiyollahoile hẽtte o hitarar uwore Pak Ruh no aiye. Bolke hitarare šude Isar name torikotor gusol diya oil. ");
INSERT INTO rhg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ehon hitarar uwore hat raikke, ar hitara Pak Ruhure faiye. ");
INSERT INTO rhg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kintu Simone zehon deikke ze asab okkole hat rakiyore hitarare Pak Ruhure diye, hetunot hite hitarar hãse ṭĩya ainne ");
INSERT INTO rhg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","edde hodde: \"Ãre o ei šokti do, zene ãi o honokiyor uwore hat rakile hite he Pak Ruhure fa.\" ");
INSERT INTO rhg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hetunot Fitore hitare hodde: \"Tor ṭĩya tor fũwati donšo ok, kiyollahoile tui mone goijjos Allar hadiya ṭĩya di kina fa. ");
INSERT INTO rhg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tottu ei hamot hono miraz otóba bag nai, kiyollahoile tor dil Allar mikka soiyi no. ");
INSERT INTO rhg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ei horafittu tui mon fira edde Mabudor hãse munazat gor. Hen oile Allaye tor dilor ei horaf sinta oitfare maf goribo. ");
INSERT INTO rhg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kiyollahoile ãi dekir, tor dil lalsiye boraiya edde tui gunar hãse kobza oi taikkos.\" ");
INSERT INTO rhg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hetunot Simone hodde: \"Tũwara Mabudor hãse ãlla duwa goro zene tũwara zen hoiyo hendilla ãr uwore no goṭe.\" ");
INSERT INTO rhg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hitara Malikor babute kalam tobolig edde goba diye bade Zeruzalem firi giyegoi. Zargoide fõtot hitara Sameri okkolor bout fara okkolot kušir hóbor tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ekdin Mabudor ek firistaye Filipore hodde, \"Uṭ, doin mikkar rastat za, ze rasta Zeruzalemottu Gaza šohoror mikka giye.\" He rastawa aššilde bošoti sara elehat. ");
INSERT INTO rhg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Toi Filipe hikka giye edde fõtot Etupia dešor ekzon has raz hormosari loi deha oiye. Etupiar Kandaki ranir dón mal dehafuna goribar bar ei manušwar uwore aššil. Allar ebadot goribolla ei raz hormosariwa Zeruzalem gil, ");
INSERT INTO rhg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ar ehon górot uwafes firi zargoide fõtot, hite hitar gũra garit boi nobi Esaiyar kitab telewat gorer. ");
INSERT INTO rhg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pak Ruhuye Filipore hodde, \"Oi gũra garir hãse za edde hiyanor hãse takis.\" ");
INSERT INTO rhg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Toi Filipe dũri he gũra garir hãse giye edde funedde manušwaye nobi Esaiyar kitabwa telewat gorer. Filipe fusar goredde, \"Tũi telewat gorodde hin buzo ne?\" ");
INSERT INTO rhg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","He hormosariye hodde, \"Honokiye buzai no dile ãi ken gori buzi fariyum.\" Hite Filipore gũra garit uiṭṭo edde hitar ḍake boibolla foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","He raz hormosariwaye zin telewat goijje hin oilde in: \"Zorgoraibar soolore loizafan gori hibare loigiye, soolor kẽš ãsoyar munttu zendilla sool suf take, hendilla hibaye o muk no kuler. ");
INSERT INTO rhg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hiba ohomani oiye, hibar uwore niyai bisar gora no o. Hone hoi faribo hibar bongšor hota? zehon hibar foran ei duniyaittu loifela oiye.\" ");
INSERT INTO rhg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","He raz hormosariwaye Filipore hodde, \"Meherbani gori ekkena hona, nobiye ei hota har babute hodde, nizor babute ne naki ar oinno honokiyor babute?\" ");
INSERT INTO rhg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Toi Filipe Pak kitabor he aiyatottu loti šuru goijje edde Isar kušir hóbor hitar hãse zanaiye. ");
INSERT INTO rhg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hitara fõt bai zaite zaite en ek zagat fõissegoi, zeṛe fani ase. Hetunot he raz hormosariwaye hodde, \"So, eṛe fani ase, ãi torikotor gusol loite ãttu banda hoṛe?\" ");
INSERT INTO rhg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Filipe hodde, \"Tũi zodi zane dile biššaš goro toile tũi loi fariba.\" Hetunot he hormosariwaye hodde, \"Ãi biššaš gori ze Isa Mosi oilde Allar Fut.\") ");
INSERT INTO rhg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Toi he hormosariwaye gũra gari tiya goraito hokum diye. Ar Filip edde raz hormosari, hitara dunizone fanit maze laimme. Toi Filipe hitare torikotor gusol diye. ");
INSERT INTO rhg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hitara fanittu uṛi aiššede šomot, Mabudor Ruhuye Filipore loigiyegoi, raz hormosariwaye hibare ar no deke. Toi hite kuši oiyore hitar nizor baisar uzu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipore kintu Ašdud šohorot deha giye. Ar hibaye har šohor okkolot kušir hóbor tobolig gori gori Sizeriya foijjonto giye. ");
INSERT INTO rhg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saule hehono Malikor sahabi okkolor uwore zafai forat roiye edde hitarare zane mari felaibo domki diyat roiye. Saule ḍõr imamor heṛe giye, ");
INSERT INTO rhg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","edde hitattu Damaskus šohoror sinagog okkololla šeṛi saiye, zene Saule he fõtot giyede hendilla nari furuš zarare faibo, hitarare bandi Zeruzalem loi ani fare. ");
INSERT INTO rhg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hite baisa di Damaskusor hãsa hãsi fõissegoide šomot, asmanottu atikka ek fohoror šoṛak hitar sairo mikka foijje. ");
INSERT INTO rhg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hite meṛit fori giyegoi edde ek abaz fuinne, hodde, \"Saul, Saul, kiyolla tui ãr uwore zulum goror?\" ");
INSERT INTO rhg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saule hodde, \"Malik, tũi honnuwa?\" Malike hodde, \"Ãi he Isa, zar uwore tui zulum goror. ");
INSERT INTO rhg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tui ehon uṛi šohoror butore za, tottu ki gora foribo hin tore heṛe howa oibo.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ze manuš okkol Saulor fũwati giye hitara ammuwak oi tiyai roiye, hitara abaz fuinne kintu honokiyore no deke. ");
INSERT INTO rhg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Bade Saul uṛi tiyaiye edde suk kuille, kintu hite suke deki no faijjil. Hetunot hitar fũwajja okkole hate dori dori hitare Damaskus šohorot loigiye. ");
INSERT INTO rhg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tin din foijjonto Saul anda oi aššil edde hána fani kissu no há. ");
INSERT INTO rhg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskusot Ananiyas name ekzon sahabi aššil. Malike hibare deha diyore hodde, \"Ananiyas!\" Hibaye hodde, \"Malik, so ãi eṛe.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Toi Malike hibare hodde, \"Uzu name ze rasta ase tui he rastat za, heṛe Ehudar górot Saul hoi ekzon Tarsus šohoror manušore talaš gorgoi, kiyollahoile hite duwa gorer. ");
INSERT INTO rhg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ar hite ek deha faiyede heṛe dekedde, Ananiyas name ekzon manuš aiyore hitar uwore hat rakibo, toi hite abar suke dekibo.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kintu Ananiyase hodde, \"Malik, ãi bout kiyor mukottu ei manušwar babute fuinni, Zeruzalemot tũwar Paki manuš okkolor uwore ite hondilla zulum okkol goijje. ");
INSERT INTO rhg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ar ehon, hite ḍõr imamottu kemota loi õnor name ḍakede har mainšore bandi loizaibolla eṛe o aiššiye.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kintu Ananiyasore Malike hodde,\"Tui za! Kiyollahoile Oihudi edde hitarar badša okkol edde Israili okkolor hãse ãr babute tobolig goribolla ite ãr basona goijja zontro. ");
INSERT INTO rhg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ãi hitare dehaiyum ãr namolla buli hitattu hoto duk šowa foribo.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Toi Ananiyas giye edde he górot góille, ar Saulor uwore hat rakiyore hodde, \"Bái Saul, eṛe aibar fõtot tore ze deha dil he Isaye ãre defeṛaiye, zene tui suke dekibar šokti firai fos edde Pak Ruhuye furaiya os.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hetunot Saulor sukottu õišor ḍoilla ekkan ki fori giyegoi, toi hite abar suke deki faijje. Tarfore hite uiṭṭe edde torikotor gusol loiye, ");
INSERT INTO rhg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tarfore hite hána haiyore doromoro oiye. Saule hoto din Damaskus šohoror biššaši okkolor fũwati heṛe taikke. ");
INSERT INTO rhg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ar deri no gori hibaye sinagog okkolot tobolig gora šuru goijje, ze Isa oilde Allar Fut. ");
INSERT INTO rhg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Beggune zara hibar hota funito, hitara tajjuf oi fusar gorito, Zeruzalemot zara Isar nam dori ḍakito hitarare zulum goittode, ite no ne ki? Ar eṛe o zara Isar nam dori ḍake hitarare bandi ḍõr imamor hãse loi zaibolla aiššede, ite no ne ki? ");
INSERT INTO rhg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saule kintu lagatar ḍõr ḍõr šokti faiye. Damaskusor Ihudi okkole zuwab dibolla fõt udda tui no fa, zẽtte hibaye Isa Moside forman diye. ");
INSERT INTO rhg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Iyar bout din bade Ihudi okkole hibare mari felaibolla felain goijje. ");
INSERT INTO rhg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kintu Saule hitarar felainor hota zani faijje. Hibare mari felaibolla hitara šohoror geiṭ okkolot dine raite fahara diye. ");
INSERT INTO rhg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kintu ek raitta hibar šagirit okkole hibare ek ḍular butore gori loizai ḍebal far gorai diye. ");
INSERT INTO rhg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul Zeruzalem ai bade sahabi okkol loi zug dito saiye, kintu beggune hibare ḍoraiye. Saul ze ekzon hãsa biššaši hiyan hitara biššaš gori no faijjil. ");
INSERT INTO rhg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kintu Barnabase hibare fũwati asab okkolor hãse loigiye edde Saule fõtot ki bafe Malikor deha fail edde ki bafe Malike Saul loi hota hoil, ar ki bafe Saule Damaskusot šahoš loi Isar nam tobolig goijje hin okkol hibaye hitarare zanaiye. ");
INSERT INTO rhg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tarfore oite Saul hitarar fũwati Zeruzalemot takito edde butore baire aša zawa goitto, ar kulasa bafe edde šahoš loi Malikor namot tobolig gorito. ");
INSERT INTO rhg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hibaye Girik baša hoiya Ihudi okkol loi hotabattara edde barabari goitto, kintu hitara hibare mari felaibolla kušiš goijje. ");
INSERT INTO rhg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Torikotor báiyain okkole zehon ei hota fuinne, hibare Sizeriya šohorot loi giyegoi, toi hentu Tarsus šohorot faṭai diye. ");
INSERT INTO rhg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","He šomot Ehudiya, Galil edde Sameriya eleha okkolor zomat okkolot šanti aššil. He zomatgun gori uṭṭil, hiyanor zoriya Malikor mutallek ḍor edde Pak Ruhur tuwajjo loi solat zomator manuš okkol bari uṭṭil. ");
INSERT INTO rhg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fitore hár zagat gurite gurite Ludda šohorot ze Allar bonda okkol aššil hitarar hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Heṛe Aneas name ekzon manušore dekkil, hite aššilde ãtur, ze ašṭo bosor mula bisanat fori roiye. ");
INSERT INTO rhg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fitore hitare dekiyore hodde: \"Aneas, Isa Mosiye tore bala gorer. Uṭ, tor bisana tuli lo.\" Hite hehon uṛi tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Henot Ludda šohorot edde Šarun ḍeilot takitode hár manuš okkole Aneasore deki Malikor mikka fijje. ");
INSERT INTO rhg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Zaffa šohorot Tabita name ek mayafuwa biššaši aššil, Girik bašat Dorka (mani Horini). Hibaye beši bala ham okkol edde gorib okkolore modot okkol gorito. ");
INSERT INTO rhg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kintu hẽtte hibattu beši ošuk oiyore bade mori giyegoi, ar manuš okkole hibare duwaiyore uworor uggwa kamerat rakkil. ");
INSERT INTO rhg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ludda aššilde Zaffa šohoror hãsa hãsi, toi sahabi okkole fuinne ze Fitor Luddat ase. Hitara duizon manušore hibar hãse defeṛaiye, hibare hitarar heṛe toratori aito foriyad goribolla hoi. ");
INSERT INTO rhg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Toi Fitor hitarar fũwati giye. Hiba heṛe fõsi bade hibare uworor kamerat loigiye. Heṛe rari okkol beggune Fitorore berai doijje. Dorka basi taite hibaye ze kuruta edde oinno horsuwor silail hin okkolore hitara Fitorore deha šuru goijje edde handa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Toi Fitore beggunore hentu niyolai diye edde ãṛu felai duwa goijje. Tarfore he mora maya fuwawar uzu firiyore hodde: \"Tabita, uṭ! Henot hibaye suk kuille, ar Fitorore deki uṛi boišše.\" ");
INSERT INTO rhg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Toi Fitore hat diyore hibare tuille. Tarfore biššaši edde rari okkolore ḍaikke edde hibare zinda dehaiye. ");
INSERT INTO rhg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ei hota Zaffa šohoror beggune zani faijje edde boute Malikor uwore biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Fitor bout din mula Zaffa šohorot Simon name ekzon samorar ham goroyar górot taigilgoi. ");
INSERT INTO rhg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sizeriya šohorot Kornelius name ekzon manuš aššil. Hite aššilde Iṭalittu Romiyo šoinno dolor ofisar. ");
INSERT INTO rhg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hite ekzon allawala manuš, hitar góror beggune o Allare ḍoraito. Hite Ihudi gorib okkolore šome šome modot okkol dito, ar Allar hãse hamiša munazat gorito. ");
INSERT INTO rhg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ek din, dinor tinnwa baijjede ṭaimot maze hite ekkan deha faiye. Hite foriškar gori deikke ze Allar ekzon firista aiyore hitare ḍaker: \"Kornelius!\" ");
INSERT INTO rhg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korneliuse ḍoraiye edde he firistar mikka saiyore hodde, \"Ki hodde, malik?\" Firistaye hodde, \"Tor munazat edde gorib okkolore modotor hota Allar hãse fõisse edde Allaye hin monot raikke. ");
INSERT INTO rhg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ehon tui Zaffa šohorot manuš defeṛai Simon, zare Fitor o ho, hitare ḍaki an. ");
INSERT INTO rhg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hite Simon name ek samora biyarir górot ase, ze górgan doriyar hãsat.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ze firistaye Kornelius loi hota hoil hiba hentu giyegoi, bade Korneliuse duizon gulam edde ekzon nizor faharadari šoinnore ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hite har hota buzaiye edde hitarare Zaffa šohorot defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tarforor din he manuš okkol fõt bai zaite zaite zẽtte Zaffa šohoror hãsa hãsi fõissegai, hẽtte ṭaim onumanik dũijja, Fitore sador uwore munazat goribolla uṭṭil. ");
INSERT INTO rhg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hibattu bug laigge edde kissu haito saiye, kintu hitara hehono hána tiyar gorat aššil, hetunot Fitor zurainna mikka abostat aššil. ");
INSERT INTO rhg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","He abostat maze Fitore dekedde asman kuli giyegoi edde hono kissu ekkan lami aiyer, hiyanore saite ekkan ḍõr saddor sair kuna loi duniyait lamai diya or. ");
INSERT INTO rhg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","He saddoror uwore hár ḍoilla sair ṭenga zanuwar edde buke aṛede zandar okkol edde faik okkol ase. ");
INSERT INTO rhg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tarfore ek abaze hibare hodde, \"Fitor, uṭ, zora edde há!\" ");
INSERT INTO rhg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Fitore hodde: \"No, no, Malik, hono mote no, kiyollahoile ãi hono din hono napak, oforiškar no hái.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Hetunot hibaye dusora bar ei abaz fuinne, \"Allaye zinore Pak goijje, hinore tui napak no hois.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Endilla tin bar oiye, toi bade he saddorgan abar asmanot tuli loi za oiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Fitore ze deha faiye hiyanor mani ki oitfare, ei babute hibaye ehono bafer, hen šomot Korneliuse defeṛaiyede manuššune Simonor gór tuwaiyore ehon dorozar sarme ai tiyaiyegai. ");
INSERT INTO rhg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tarfore hitara góror butore ḍak maijje edde fusar goijje, Simon, zare Fitor ḍaka o, hiba ki heṛe ase ne, hoi. ");
INSERT INTO rhg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Fitore ehono o deha failde he babute bafat ase, toi Pak Ruhuye hibare hodde, \"Sa, tinzon manuše tor talaš gorer. ");
INSERT INTO rhg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Toratori gor, lamat za. Hono andeša no ani hitarar fũwati za, kiyollahoile hitarare ãi defeṛaiyide.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Toi Fitore lamiyore oi manuššunor hãse giye edde hodde: \"So, tũwara zare talaš goror hiba ãi. Tũwara eṛe kiyolla aiššode?\" ");
INSERT INTO rhg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hitara zuwabe hodde, \"Ãrare šenafoti ofisar, Korneliuse defeṛaiyede. Hiba ekzon dormiyo manuš, ze Allare ḍora. Ar har Ihudi okkole hibar šunam gore. Hibaye ek Paki firistattu hokum faiye ze õnore hibar gõrot ḍaki loi zaiyore hibaye õnor hota fune.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Toi Fitore he manuš okkolore góror butore ḍaki ainne edde hitarare mehemandari goijje. Tarforor din uṛi hitarar fũwati giye. Ar Zaffa šohorottu ho ekzon torikotor báiyain hibar fisa fise giye. ");
INSERT INTO rhg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tarforor din hitara Sizeriyat fõissegoi. He šomot Korneliuse hitar nizor afonzon, egena, dusto okkolore ek zagat gori hitaralla entezar goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bade Fitor zehon górot góille hetunot Korneliuse hibar loi deha oiye edde hibar ṭengot uitefori hibare soida goijje. ");
INSERT INTO rhg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kintu Fitore hitare tuli loiye, edde hodde: \"Uṛi zagoi, ãi nize o bolke ekzon manuš.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kornelius loi hota hoite hoite, Fitore butore zai sadde heṛe beša beši manuš okkol zoma oi taikke. ");
INSERT INTO rhg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hetunot Fitore hitarare hodde: \"Õnora to zanode hota ze oinno hono zatir manuš loi aza gora ba hitarar loi dola owa ekzon Ihudilla iyan niyomor baire. Kintu ãre Allaye dehaiye ze honokiyore napak ba oforiškar howa bala no. ");
INSERT INTO rhg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hetolla tũwara zẽtte ãre ḍakito defeṛaila hẽtte hono bázá no raki ãi aišši. Kintu ãi ehon tũwarare fusar gori, tũwara ãre kiyolla ḍakito defeṛailade?\" ");
INSERT INTO rhg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Hetunot Kornileuse hodde: \"Sair din age ṭik ei šomot, ãi ãr górot munazat goijjilam. Hen šomot atikka ekzon ujjol dola hor finda manuš ãr sarme aiyore tiyaiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Edde hodde, 'Kornelius, tor munazat edde gorib okkolore modotor hota Allar hãse fõisse edde Allaye hin monot raikke. ");
INSERT INTO rhg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ehon tui Zaffa šohorot manuš defeṛai Simon, zare Fitor o ḍaka o.hitare ḍaki ana. Hite Simon name ek samora biyarir górot ase, ze górgan doriyar hãsat.' ");
INSERT INTO rhg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hetolla ãi hehon õnore ḍaki anibolla manuš defeṛailam. Õne aiššode bala oiye. Ar ãra ehon beggune Allar sarme asi, Malike õnore ãrar hãse ziyan hoibolla hokum diye ãra hiyan funiyum.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tarfore Fitore muk kuille edde hitarare hodde: \"Soiyi ãi buzi faijji ze Allaye hono manušore forok no gore. ");
INSERT INTO rhg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kintu hár zatir butottu zara hibare ḍora edde ziyan hibar sukot ṭik hiyan ze gore, hitarare hibaye gose. ");
INSERT INTO rhg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tũwara zanode hota, Allaye ei kušir hóbor Israili okkolor hãse defeṛail, Isa Mosir duwara he šantir kušir hóbor, Isa Mosi, hiba ziba beggunor uwore Malik. ");
INSERT INTO rhg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tũwara beggune ei goṭona zano ze Yahyar duwara torikotor gusol tobolig gora oi bade Galilottu loti šuru gori šara Ehudiya agagura ei hóbor sorai gilgoi. ");
INSERT INTO rhg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ar Allaye kibafe Nasarator Isare Pak Ruh edde šokti diye, kibafe hibaye hár mikka giye edde bala ham okkol goijje, ar zara Šoitanor kobzar butore duk bug goitto, hitara beggunore aram gorito. Kiyollahoile hibar fũwati Allah aššil. ");
INSERT INTO rhg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","\"Hibaye Ihudi okkolor dešot edde Zeruzalemot zin zin goijje hin beggunor goba oilamde ãra, hitara zara hibare kurušot loṭkaiyore mari felaiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kintu Allaye hibare tin dinor din uwafes tuille, ar endilla goijje zene mainše hibare deke. ");
INSERT INTO rhg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hibare beggune no deke, kintu ze goba okkolore agottu loti Allaye basona goijjil hitarare deha diye. Hiba morattu uwafes uṛi zaigoi bade ãra hibar fũwati hafiya goijjilam. ");
INSERT INTO rhg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Hibaye ãrare hokum diye, ãra zene tobolig gori edde goba di, ze Iba oilde he zon zibare Allaye zinda edde mora okkololla bisarhar hisabe buwaiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hibar babute har nobi okkole goba der, ze honokiye hibar uwore biššaš ane, hite hibar namor duwara guna maf faibo.\" ");
INSERT INTO rhg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fitore ehono hota howat ase, hen šomot hitara zara he kalam funnil, hitara beggunor uwore Pak Ruh aiššiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ze Ihudi biššaši okkol Fitoror fũwati aiššil hitara Oihudi okkolor uwore o Pak Ruhure hadiya hisabe ḍali diya oiyede deki tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kiyollahoile zilor baša hodde edde Allar tarif goredde hitara fuinne. Toi Fitore hodde: ");
INSERT INTO rhg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","\"Itara o ãrar ḍoilla Pak Ruhure faiye. Honokiye ki itarare torikotor gusol dite banda di faribo?\" ");
INSERT INTO rhg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Toi Fitore he manuš okkolore Isar name torikotor gusol dibolla hokum diye. Bade hitara Fitorore ho ek din hitarar hãse takibolla foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Oihudi okkole o Allar kalam goissede he hota asab okkole edde Ehudiyar har biššaši báiyain okkole fuinne. ");
INSERT INTO rhg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ar zẽtte Fitor Zeruzalemot aišše, he azomi goraiya biššaši okkole Fitorore hosuri diyore hodde, ");
INSERT INTO rhg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","\"Tũi azomi agoraiya manuš okkolor górot zai hitarar loi kiyolla hafiya goijjo?\" ");
INSERT INTO rhg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Fitore foilattu loti šuru gori zin zin goiṭṭe ekkan ekkan buzaiyore hoiye. ");
INSERT INTO rhg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Hodde: \"Ãi Zaffa šohorot munazat goijjilam, hẽtte zurainna mikka oi ãi ek deha failam. Ãi dekidde ekkan ḍõr saddoror ḍoil ziniš sair kuna loi asmanottu lamai diya or, ar hiyan ãr hãse aišše. ");
INSERT INTO rhg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ãi hiyanore kiyal gori sailam, ar dekidde sair ṭenga zanuwar edde fahari zanuwar okkol, buke aṛede zandar edde faik okkol ase. ");
INSERT INTO rhg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Toi ãre hodde ek abaz fuinni: 'Fitor, Fitor, uṭ, zora edde há' ");
INSERT INTO rhg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","\"Ãi hoilam: 'No, No, Malik, ãi hono mote hái no faijjum, kiyollahoile ãi hono din hono napak, oforiškar no hái.' ");
INSERT INTO rhg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","\"Kintu dusora bar asmanottu howa oiye: 'Allaye zinore paksaf goijje hinore tui napak no hois.' ");
INSERT INTO rhg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Endilla tin bar oiye, toi bade hin beggun abar asmanot tuli loi za oiye. ");
INSERT INTO rhg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","\"Ar hin deki mottor dekidde tinzon manuš, ãra ze górot aiššilam heṛe ai tiyaiyegai. Hitarare Sizeriya šohorottu defeṛa oil. ");
INSERT INTO rhg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Hetunot Pak Ruhuye ãre hono andeša no ani hitarar fũwati zaito hoiye. Ei sozon báiyain itara o ãr fũwati gil. Bade ãrare ze ḍakito defeṛail he manušwar gõrot goillilam. ");
INSERT INTO rhg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Hite ekzon firistare ki bafe hitar górot deha fail hin hite ãrare hoiye. He firistaye hitare hoil, 'Zaffa šohorot manuš defeṛai Simon, zare Fitor o ḍaka o, hitare ḍaki an. ");
INSERT INTO rhg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hite tor hãse kalam hoibode he kalamor duwara tui edde tor góror gušṭi ṭiyaye uddar faibo.' ");
INSERT INTO rhg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","\"Bade ãi hota howa šuru goijjibar, Pak Ruh hitarar uwore aišše, zendilla foilar šurut ãrar uwore aiššil. ");
INSERT INTO rhg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hetunot ãttu Malikor hota monot foijje, zendilla hibaye hoil: 'Yahyaye fani loi torikotor gusol dito, kintu tũwarare he Pak Ruh loi torikotor gusol diya oibo.' ");
INSERT INTO rhg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Allaye zehon hitarare o he hadiya diye ziyan ãra Malik Isa Mosir uwore biššaš ainnide hiya failam, henot ãi honnuwa ze Allare banda di fari?\" ");
INSERT INTO rhg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hitara in okkol zehon fuinne, toi nizam oiye edde Allare tarif goriyore hodde: \"Henoile to Allaye Oihudi okkolore o gunattu mon firaiyore zibonot aibolla šuzug diye.\" ");
INSERT INTO rhg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ehon Stifanore loi šuru oilde he zulumor zoriya biššaši okkol zara Fonikiya, Kiprus, edde Anṭiyok foijjonto sorai gilgoi, hitara šude Ihudi okkolore sara ar honokiyore kalam tobolig no gore. ");
INSERT INTO rhg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kintu hitarar butore Kiprus edde Kuronir hoekzon manuše Anṭiyokot zaiyore Oihudi okkolor hãse Isar babute kušir hóbor tobolig gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ar Malikor hat hitarar uwore aššil edde bout manuš okkole biššaš ani Malikor mikka fijje. ");
INSERT INTO rhg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ei hóbor zehon Zeruzalemor zomator manuš okkolor hanot giye, hitara Barnabasore Anṭiyokot defeṛaiye. ");
INSERT INTO rhg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas heṛe aiyore zehon Allar rahamote ki goijje hin deikke, hiba kuši oiye, edde hitarare tuwajjo diye zene hitara hitarar furafuri dil diyore Malikore dori take. ");
INSERT INTO rhg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ekzon bala manuš aššil edde hiba Pak Ruhuye edde biššaše furaiya aššil. Ar bout manuš okkolore Malikolla zitaiye. ");
INSERT INTO rhg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tarfore Barnabase Saulore tuwaibolla Toršišot giye. ");
INSERT INTO rhg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Toi hibare tuwai faiyore Anṭiyokot ainne. Barnabas edde Saule ek bosor foijjonto zomator manuš okkol loi mille edde beši manuš okkolore šikka diye. Ei foilabar Anṭiyokor biššaši okkolore Kiristan hoi nam diye. ");
INSERT INTO rhg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","He ṭaimot hoekzon nobi okkol Zeruzalemottu Anṭiyokot aišše. ");
INSERT INTO rhg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hitarar butore Agab name ekzon uṛi tiyaiore Pak Ruhur duwara hodde, Rom raijjo agagurat ek ḍõr raṭ oibo. (Badša Klaudius šašonor ṭaimot he hota furon oil.) ");
INSERT INTO rhg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hetunot biššaši okkole bebosta goijje ze Ehudiya elehar biššaši báiboinain okkololla hitarar nizor šaiddo mozin modot faṭaibo. ");
INSERT INTO rhg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ar hitara he mozin goijje, Barnabas edde Saulor hatot Ehudiyar zomat okkolor murubbi okkolor hãse modot faṭaiye. ");
INSERT INTO rhg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","He šomot badša Herude zulum goribolla zomator hoekzon manušore dori annil. ");
INSERT INTO rhg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hite Yuhannar bái Yakubore toluwar loi kun gori felaiye. ");
INSERT INTO rhg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Henot Ihudi okkole kuši oiyede deki hite abar giye edde Fitorore o doijje. In goiṭṭede iš adiya ruṭir idor šomot. ");
INSERT INTO rhg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hite Fitorore dori ziyol golai raikke. Ar Fitorore fahara dibolla sairzon sairzon gori šoinno okkolor uwore bar diya oiye. Herude ṭik goijjede uddar idor bade bisar goribolla Fitorore mainšor hãse niyolai anibo. ");
INSERT INTO rhg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hetolla Fitorore ziyolot bondi raka oil. Zomator manuš okkole kintu hiballa Allar hãse ekmone duwa goijje. ");
INSERT INTO rhg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ze din Herude bisar goribolla Fitorore niyolai anibo, hiyar agor raitta duizon šoinnor maze Fitor gum zai aššil. Hibare duiyan siyol loi bandi raka oil, ar faharadar okkole dorozat fahara dil. ");
INSERT INTO rhg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","So, hen šomot atikka Allar ek firista heṛe aiyore tiyaiyegai. Henot ziyolhanagan fohore ujjol oigiyegoi. Firistaye Fitoror gat zure ṭela diyore gumottu tuli diye edde hodde: \"Toratori uṭ!\" Henot Fitoror dui hatottu siyol kuli fori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Hetunot firistaye hodde: \"Tor kĩyailot kiyail bandoni band edde šendal find,\" Fitore hen goijje. Bade firistaye hodde: \"Tor saddor gat diyore ãr fise fise ai.\" ");
INSERT INTO rhg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Henot Fitore niyoliyore firistar fise fise za šuru goijje. Kintu firistar duwara zin gora oiye, hin ze hãsa hin hibaye buzi no faijjil, bolke hibaye šoppon deker buli mone goijje. ");
INSERT INTO rhg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bade hitara foila edde dusora faharadar okkolor dolore ḍiyai zaiyore šohorot golede luwar dorozar hãse aišše. Dorozagan hitaralla onegane kuli giyegoi, ar hitara heṛe butottu di niyoli giyegoi. Hitara ekkan rasta bai, rasta hiyan furafan foijjonto giye. Ar hetunot firistawa atikka hibar hãsottu gayeb oigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hetunot Fitore buzi fariyore hodde, \"Ehon ãi buzilam, Malik nize firista defeṛaiye edde Herudor hatottu edde Ihudi okkolor har monor issattu ãre uddar goijje.\" ");
INSERT INTO rhg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ei babute buzi fariyore hibaye Yuhannar ma Moriyamor górot giye. Ei Yuhannare Mark hoi o ḍaka oito. He górot boute ekku fũwati dola oi munazat goijje. ");
INSERT INTO rhg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Fitore battu tai doroza bajjaiye toi Ruda name ekzon goroni maya fuwaye doroza kuli dibolla aišše. ");
INSERT INTO rhg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Fitoror abaz sini fariyore hibaye eto kuši oiye, doroza no kulite, dũri butore giye edde hoiye, ze Fitor dorozar hãse tiyai roiye! ");
INSERT INTO rhg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hetunot biššaši okkole he mayafuwaware hodde, \"Tor mata horaf oiyede oibo.\" Kintu hibaye bar bar zurgori zehon hoiye hitara hodde, \"Toile iba Fitoror firista.\" ");
INSERT INTO rhg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eṛe Fitore doroza baijjat roiye. Hetunot biššaši okkole doroza kuli Fitorore deki ammuwak oiye. ");
INSERT INTO rhg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Fitore hitarare nizam oibolla hate išara goijje edde ziyolottu Malike hibare kengori niyolai ainne hiyan zanaiye. Toi Fitore hodde, \"Tũwara ei hóbor Yakubore edde aro báiyain okkolore hoiyo,\" hen hoi hiba hentu niyoli oinno zagat giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Binna sore šoinno okkolor maze uruskul oiye, Fitor hoṛe giyegoi hoi. ");
INSERT INTO rhg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herude Fitorore talaš goijje, kintu hibare tuwai zehon no fa, faharadar okkolore zera goijje edde hite hitarare mari felaibolla hokum diye. Tarfore Herude Ehudiyattu Sizeriya giye edde heṛe hoto din taikke. ");
INSERT INTO rhg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hešomot Herud Tiros edde Sidon šohoror manuš okkolor uwore guššaye oin oil. Ehon, heṛiyar manuš okkole ekkui fũwati miliyore Herud loi deha gorito gil. Blastos name ekzon badšar góror has hormosari loi hat goriyore hitara badšattu šanti saiye, kiyollahoile hitarar hánar zinišfati okkol he badšar dešottu itarar dešot aito. ");
INSERT INTO rhg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hẽtte ekdin Herude ekkan din ṭik goijje, hite hedin raz fušak findi šingašonot boiyore hitarare bašon diye. ");
INSERT INTO rhg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Hitar hota funi manuš okkole guzoriyore hodde: \"In oilde devotar abaz, manušor no!\" ");
INSERT INTO rhg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hetunot atikka Mabudor ekzon firistaye hitare maijje, kiyollahoile hite Allare tarif no de. Hitar ga loge háiye edde morigiyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kintu Allar kalam mummikka giye edde sairo mikka sorai gilgoi. ");
INSERT INTO rhg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ar Barnabas edde Saule Zeruzalemot hitarar šebar ham šeš gori bade, Yuhanna, zare Mark ho hibare fũwati loi hitara uwafes firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anṭiyok šohoror zomatot hoekzon nobi edde ustat aššil. Hitarar nam Barnabas, Simeon zare Niger o ḍaka oito, Kuroni šohoror Lukiyus, šašon goroya Herudor falok bái Manaen, edde Saul. ");
INSERT INTO rhg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hitara ruza rakiyore Mabudor ebadot goredde hetunot Pak Ruhuye hitarare hodde: \"Barnabas edde Saulore ãi ze hamolla ḍaikki he hamolla hitarare aleda gori lo!\" ");
INSERT INTO rhg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Toi hitara ruza edde munazat gori bade he duizonor uwore hat raikke edde hitarare faṭaiye. ");
INSERT INTO rhg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ei dunizonore endilla gori Pak Ruhur duwara defeṛa oil, hitara dunizon Selebkiyat giye, hentu zahazot gori Kiprus ḍiyat aišše. ");
INSERT INTO rhg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hitara Salamit hazir oiyore Ihudi okkolor sinagogot Allar kalam tobolig goijje. Yuhanna o modot goroya hisabe hitarar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hitara ḍiya gũṛa farai zaiyore šeše Pafosot hazir oiye. Heṛe hitara ekzon Ihudi zadugor edde bonḍo nobire lot faiye, zar nam Bar-Isa. ");
INSERT INTO rhg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hite aššilde šašon goroya Sergius Paulosor ekzon bondu, ar he šašon goroya manušwa aššil ekzon bala manuš. Sergius Paulose Allar kalam funibolla Barnabas edde Saulore ḍaikke. ");
INSERT INTO rhg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kintu Elymas, ze namor mani zadugor, hite Barnabas edde Saulore mana goijje ar hite sailde šašon goroyaye biššašottu muk firai felok. ");
INSERT INTO rhg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kintu Saul zare Paulos ho, hibaye Pak Ruhuye furaiya oiyore hitar mikka šuza saiyore ");
INSERT INTO rhg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","hodde: \"Tui Šoitanor fuwa, zin bala hinor dušmon edde hár ḍoilla dúha edde sokkore furaiya, tui ki Malikor uzu fõtore behã gora no tamaibi ne ki? ");
INSERT INTO rhg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sa, tor uwore Allar gozob foijje. Tui anda oibi edde hoto din foijjonto beilor fohor no dekibi.\" Hetunot kuwa edde andare hitare guri felaiye, edde honokiye hitare hate dori loizai farefan hite ata šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","In okkol deki he šašon goroyaye biššaš ainne. Kiyollahoile Malikor babute ze šikka hibaye faiye henot hiba tajjuf oiye. ");
INSERT INTO rhg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bade Paulos edde hibar fũwajja okkol Pafos sari zahazot gori Famfuliya elehar Forga šohorot giye. Heṛe Yuhannaye hitarare eri Zeruzalem firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bade hitara Forgattu Pisidiya elehar Anṭiyok šohorot giye edde dórmo din sinagogot goli zai boiššegoi. ");
INSERT INTO rhg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Torah edde nobi okkolor kitabottu telewat goijja šeš oi bade muzolišhanar neta okkole hitarar hãse hoi defeṛaiyede: \"Báiyain okkol! Manuš okkolore tuwajjo dibolla zodi hono hota take toile ho.\" ");
INSERT INTO rhg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hetunot Paulose uṛi tiyaiye edde hate išara gori hodde: \"Israili okkol edde aro zara Allare ḍorode Oihudi manuš okkol, tũwara ãr hota funo! ");
INSERT INTO rhg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israil zatir Allaye ãrar bafdada okkolore basiloil. Hitara zẽtte Mišor dešot aššil hẽtte hitarare ek ḍõr zati goijjil. Bade Allaye ḍõr kudurutir duwara he dešottu hitarare niyolai ainnil. ");
INSERT INTO rhg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Onumanik sališ bosorfan bošoti sara elehat hitarar oinnai bebar bordaš goriyore hitarar fũwati aššil. ");
INSERT INTO rhg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bade hibaye Kenanot hãt zatire furai felaiye. Ar Israil zatire he šomosto zatir dešore diye. ");
INSERT INTO rhg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Endilla owat sair šo fõnzaš bosorfan haṛi giyegoi. Tarfore nobi Samuelor ṭaim foijjonto Allaye hoekzon bisarhar okkolore dil. ");
INSERT INTO rhg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tarfore manuš okkole ekzon badša sail hetolla Allaye Benjaminor bongšor ekzon manuš, Kišor fuwa Saulore hitaralla badša hisabe diye, ze sališ bosorfan raza aššil. ");
INSERT INTO rhg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tarfore Allaye hibare lari hitarar raza oibolla Daudore tuille, zar babute Allaye hoil, hiba oilde he Daud: 'Ãi Yasiror fuwa Daudore faiyi, hite ãr monor moto manuš, hite ãr šomosto issa falon goribo.' ");
INSERT INTO rhg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","\"Allaye hibar wada hisabe ei manušwar bongšo okkolor butottu basailoya Isare Israili okkolor hãse hazir goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Isa aibar age har Israili okkolor hãse Yahyaye gunattu mon fira edde torikotor gusol tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ham šeš goribar šomot Yahyaye hodde: 'Ãi hiba no, tũwara ziba ãi oi boli mone goror. Kintu ãi bade en ekzon ze aiyer, ãi hibar zutar fita kuli dibar laikka o no.' ");
INSERT INTO rhg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","\"Báiyain okkol, Ibrahimor bongšor manuš okkol edde allawala Oihudi manuš okkol, uddaror ei hóbor hiyan ãrar hãse faṭa oiye. ");
INSERT INTO rhg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Zeruzalemor manuš okkole otóba hitarar neta okkole hiba honnuwa sini no fare, hitara hibare hosurbon goriyore, ze kalam okkol hitara fotti dórmo din telewat gorito he šob kalam furon goijje. ");
INSERT INTO rhg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ar moron šaza dibolla hono hosuri no fa, tarfore o kintu hitara Filator hãse dabi goijje, zene hibare mari fela o. ");
INSERT INTO rhg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ar hibar babute zin leka aššil hitara hin beggun furon goijje. Bade hitara hibare gasottu lamaiye edde ek hoborot rakkilgoi. ");
INSERT INTO rhg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kintu Allaye he mora okkolor butottu hibare zinda tuille. ");
INSERT INTO rhg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galilottu zara hibar fũwati Zeruzalemot aiššil hitarare hibaye bout din foijjonto deha diye. Ehon hitara manušor hãse hibar goba. ");
INSERT INTO rhg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","\"Hetolla ãra tũwarar hãse he kušir hóbor tobolig gorir. Ãrar bafdada okkolore Allaye ze wada goijjil, ");
INSERT INTO rhg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","hiyan Allaye Isare uwafes zinda gori tuli, ãra zara hitarar bongšo okkol, hitarar hãse wada furon goijje, zendilla dui lombor zoburot o leka ase: \"'Tui ãr fut, aziya, ãi tor baf oilam' ");
INSERT INTO rhg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allaye ze hibare morattu zinda goijje edde hibar ga ze ar hono din nošto no oibo, ei babute Allaye hor, \"'Ãi Daudor hãse ze Paki edde haṭi duwar wada goijji, hin ãi tũwarare dium.' ");
INSERT INTO rhg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ar ek zagat hibaye hodde: \"'Tui tor Paki zonore fõsito no dibi.' ");
INSERT INTO rhg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","\"Daude hibar amolot, hiba ek zon Allar gulam aššil. Tarfore hiba mori giyoi edde hibar bafdada okkolor fũwati hibare hobor diya oil, ar hibar ga fõsi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kintu Allaye zare morattu zinda tuille hibar ga no fõse. ");
INSERT INTO rhg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","\"Hetolla oh ãr báiyain okkol! Tũwarattu iyan zana zoruri, ze Isar duwara gunattu maf faibar babute tũwarar hãse tobolig gora or. ");
INSERT INTO rhg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tũwara Musar ainor duwara gunar šazattu rehai fai no faro, kintu ze hono kiye Isar uwore biššaš ane hite gunar šazattu rehai fa. ");
INSERT INTO rhg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Etolla tũwara hũšiyar o! Zene nobi okkole hoi giyede hen tũwarar uwore no goṭe: ");
INSERT INTO rhg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"'Tũwara zara omainno goroya okkol, so edde ammuwak o edde dongšo o. Kiyollahoile tũwarar din okkolot ãi ekkan en ham goijjum. Zodi o he hamor hota honokiye tũwarare ho, hiyan biššaš no goriba.'\" ");
INSERT INTO rhg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulos edde Barnabas sinagog sari zargoide šomot, manuš okkole hitarare foriyad goijje, zene hitara sarmor baror dórmor din ei babute aro kissu ho. ");
INSERT INTO rhg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Muzolišhanar šoba šeš oi bade bout Ihudi okkol edde Allar ḍorola Ihudi zat diyede manuš okkole hitarar fisa loiye. Paulos edde Barnabase hitarar loi hota hoiye edde hitarare tuwajjo diye zene hitara Allar rahamotor butore mojbut take. ");
INSERT INTO rhg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tarforor haftat dórmor din šohoror hár manuš okkol Allar kalam funibolla dola oiye. ");
INSERT INTO rhg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Eto manušor zam oiyede dekiyore Ihudi okkole hingšaye zoli uiṭṭe. Ar Paulose zin tobolig goijjil hitara hinor berudde nanan ḍoilla hota okkol hoi hibare ninda gora šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hetunot Paulos edde Barnabase šahoš loi hodde: \"Allar kalam age ãrattu tũwarar hãse tobolig goron dorhar aššil. Kintu tũwara zehon hiyanore hela goror edde nizore akeri zibon faibar belaikka gori tulor, toile ãra Oihudi okkolor hãse zaiyum. ");
INSERT INTO rhg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kiyollahoile Mabude ãrare endilla hokum diye: \"'Ãi oinno zati okkolor hãse tore fohoror ḍoil goijji, zene tui uddarore duniyair šeš šima foijjonto loizos.'\" ");
INSERT INTO rhg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Oihudi okkole ei hota okkol zẽtte fuinne hẽtte hitara kuši oiye edde Mabudor kalamor tarif goijje. Ar zarare akeri zibonolla basi lowa oil, hitara beggune biššaš goijje. ");
INSERT INTO rhg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mabudor kalam he elehar hár mikka sorai foijje. ");
INSERT INTO rhg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kintu Ihudi okkole Allar ḍorwala tuwangor mayafuwain okkol edde šohoror ḍai ḍõr manuš okkolore uskani diye. Endilla gori hitara Paulos edde Barnabasor uwore zulum goriyore he elehattu hitarare niyolai diye. ");
INSERT INTO rhg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hẽtte Paulos edde Barnabase he manuš okkolor berudde hitarar ṭengor dul zari felai Ikuniya šohorot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kintu heṛiyar biššaši okkole kuši edde Pak Ruhuye furon oiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tarfore Paulos edde Barnabas Ikuniya šohorot hitarar niyom mozin Ihudi sinagogot góille edde heṛe hitara endilla gori hota hoiye ze, ek dõr Ihudi edde Oihudi okkolor dole biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kintu ze Ihudi okkole biššaš nu ane hitara Oihudi okkolore Paulos edde Barnabasor berudde uskani diyore hitarar dilore tita gori tuille. ");
INSERT INTO rhg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tarfore o Paulos edde Barnabas bout din heṛe tai zaigoiyore šahoš edde Malikor uwore boroša raki tobolig goijje. Ar Malik nize hitarar duwara he keramot edde sinno okkol goṭabaiyore hibar rahamotor hotar goba diye. ");
INSERT INTO rhg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Hiyanor zoriya šohoror manuš okkol dui bag oi giyegoi, ek dol Ihudi okkolor foikka, ar ek dol asab okkolor foikka loiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Oihudi edde Ihudi okkol, dui dole hitarar neta okkol loi mili Paulos edde Barnabasore ottisar goribolla edde fattor maribolla felain goijjede buzi faijje, ");
INSERT INTO rhg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","hitara Lukainiyar Lystra edde Dorbi šohorot edde heṛiyar ate hãsor zaga okkolot dai dai roiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ar heṛe o hitara kušir hóbor tobolig goijje. ");
INSERT INTO rhg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra šohorot ekzon manuš boi takito, hitattu tiyaibar hono šokti nuwaššil, hite fodaši ãtur ze hono din nu ãṛe. ");
INSERT INTO rhg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hite Paulosor hota funnil, Paulose šuza hitar mikka saiye, ar dekedde hite aram oibolla hitattu biššaš ase. ");
INSERT INTO rhg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Toi hitare zure ḍak maijje: \"Tor ṭengor uwore bor di uzu oi tiya.\" Toi hite fal mari tiyaiye edde aṛa šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Paulose zin goijje hin manuš okkole Lukaniyo zubanot guzoriyore hodde, \"Devota okkol manuš ruf loiyore ãrar hãse lami aišše.\" ");
INSERT INTO rhg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ar mainše Barnabasore Zaius nam diye, ar Paulos asol hota hoiya aššil buli hibar nam diye Harmes. ");
INSERT INTO rhg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zaius devotar mondir aššilde he šohoror baire. Šohor geiṛot dorozar sarme Zaius devotar mondiror imame hougguwa bolod goru edde fulor mala loi aiššiye, kiyollahoile he imam edde hár mainše Paulos edde Barnabasolla kurbani dito saiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kintu asab Barnabas edde Paulose he hota zehon fuinne, hitara nizor hor faṛi dũri mainšor butore giye edde guzori hodde, ");
INSERT INTO rhg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","\"Bondu okkol! Tũwara in kiyolla gorodde? Ãra o tũwarar ḍoilla insan. Ãra tũwarare ei kušir hóbor tobolig gorir zene tũwara ei šob abi zabi hamottu zinda Allar hãse firi aiyo, ze asman, zobin, duniyai, doriya edde hin butore za kissu ase beggunore sirišti goijje. ");
INSERT INTO rhg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Agor din okkolot har zatire hibaye hitarar issa mozin solito diye. ");
INSERT INTO rhg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tarfore o kintu hibaye hamiša hiba nizor babute goba diye, asmanottu zór edde ainda mozin haiddo diyaiyore hibaye hibar doyare tũwarare dehaiye. Hibaye beša beši haiddo zuhai diyore tũwarar dilore kušiye borai tuille.\" ");
INSERT INTO rhg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ei hota okkol honor bade o, Paulos edde Barnabasolla zanuwar kurbani gorattu manuš okkolore tamaite beši hošto oiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bade Anṭiyok edde Ikuniyattu hoekzon Ihudi ai Paulos edde Barnabas berudde manuš okkolore uskani diye. Henot mainše Paulosore fattor maijje edde hibare šohoror baire ṭani loigiye, kiyollahoile hitara mone goijje, hiba mori giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kintu biššaši okkol hibar sairo mikkattu dola oiye, bade hentu uṛi šohoror butore firi giye. Tarforor din hiba edde Barnabas Dorbi šohorot giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dorbi šohorot kušir hóbor tobolig goijje edde bout manuš okkolore biššaši goijje. Tarfore hitara uwafes Lystra, bade Ikuniya, bade hentu Anṭiyokot firi giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Heṛe hitara biššaši okkolore dilot šokti edde boroša diye, biššaše mojbut takibolla, ar hodde: \"Ãrattu bout duk hošṭor mazottu di Allar raijjot gola foribo.\" ");
INSERT INTO rhg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulos edde Barnabase hitara fotti muzolišolla murubbi okkol tuille. Ar ruza edde duwa goijje, ar zara Malikore biššaš goijjil hitarare Mabudor hatot gosai diye. ");
INSERT INTO rhg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tarfore hitara Pisidiyar butottu di Famfuliya aišše. ");
INSERT INTO rhg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tarfore hitara Forgat maze Allar kalam tobolig gori bade hentu Attaliya giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bade Attaliyattu zahazot gori Anṭiyokot firi aišše, zeṛe hitarare ei hamolla Allar rahamotor hãse šebi diya oil, ziyan ehon gori šeš oiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hitara zehon firi aišše, toi zomator beggunore ekottro goijje edde hitarare beggun hoiye, Allaye hitarar duwara ze ham okkol goijje edde kibafe Oihudi okkololla biššašor doroza kuli diye, he hota okkol hitarare kulasa gori zanaiye. ");
INSERT INTO rhg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bade hitara biššaši okkolor heṛe lamba ṭaim taikke. ");
INSERT INTO rhg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ho ekzon manuš Ehudiya elehattu lami nise Anṭiyok šohorot aiyore torikotor báiyain okkolore endilla hoi šikka diya šuru goijje: \"Musar ain mozin tũwara azomi goraiya no oile, tũwara uddar oi no fariba.\" ");
INSERT INTO rhg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Iyan loi hoijja oiye, Paulos edde Barnabasor loi ei manuš okkolor maze beša beši hota haṛa haṛi oiye. Toi hitara iyan ṭik goijje ze Paulos edde Barnabas, aro hoekzon šoho beggune uwore Zeruzalem zaibo edde heṛe asab okkol edde he murubbi okkol loi ei suwalor babute biyasana goribo. ");
INSERT INTO rhg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Anṭiyokor zomate hitarare zaibolla bebosta gori diye. Toi hitara Fonikiya edde Sameriya bai zaibar šomot Paulos edde Barnabase Oihudi okkol ki bafe mon firaiye ei hóbor heṛe torikotor biššaši okkolore hoiye. Ar hitara hen funiyore beši kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Zehon hitara Zeruzalem fõisse, zomator mainše, murubbi okkole edde asab okkole hitarare kuši mone goisse. Hitarar duwara Allaye zin zin goijje hin beggun hitara beggunore zanaiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kintu Foroši dolottu biššaši oilde hendilla hoekzon mainše tiyaiyore hodde: \"Oihudi okkolottu hameka azomi gora foribo, ar Musar ain manefan hitarare hokum diya zok.\" ");
INSERT INTO rhg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Toi asab okkol edde murubbi okkole ei babute biyasana goribolla ek zagat ottor oiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bout hota haṛa haṛi gori bade Fitore uṛiyore hitarare hodde: \"Báiyain okkol, tũwara to zano ze, bout din age tũwarar butottu Allaye ãre basi loiye, zene Oihudi okkole ãr mukottu kušir hóbor fune edde biššaš ane. ");
INSERT INTO rhg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ar Allaye har mainšor dilore zane, hibaye hitarar foikka goba diye ze ãra zendilla, hitarare o hendilla Pak Ruhure diya oiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hibaye ãra edde hitarar maze hono beš hom no rake, kiyollahoile hitara biššaš ainne boli hibaye hitarar dil o foriškar goijje. ");
INSERT INTO rhg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hen abostat maze, ãrar bafdada otóba ãra ze fũza boi no fari, he fũza Oihudi biššaši okkolor handor uwore tuli diyore kiyolla tũwara Allare forikka goribolla kušiš goror? ");
INSERT INTO rhg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ãra biššaš gori hitara zendilla hendilla ãra o ekkui bafe Malik Isar rahamotor duwara uddar faiyum.\" ");
INSERT INTO rhg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Hetunot šobar beggune nizam oiye. Ar Paulos edde Barnabasor duwara Allaye Oihudi okkolor maze ze keramoti ham okkol goijje hin okkol hitarar mukottu fuinne. ");
INSERT INTO rhg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hitarar hota hoiya šeš oi bade Yakube hota hoiye, hodde, \"Báiyain okkol funo! ");
INSERT INTO rhg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Allaye hibar nizor bonda oibolla Oihudi okkolor butottu ek dol mainšore kengori basi loiye he babute Simeone ãrare buzail. ");
INSERT INTO rhg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ar ei hota nobi okkolor agam hóbor loi mil ase, zendilla kitabot leka ase: ");
INSERT INTO rhg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"'Iyar bade ãi abar firi aiššum, Daudor fori taikkede gór uwafes tuliyum. Ziyan dongšo oigiyegoi, hiyan abar banaiyum, hiyan abar noya gori tuliyum. ");
INSERT INTO rhg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Zene bad baki manuš okkole Mabudore tuwa, ar zeto Oihudi okkole ãr nam boi loizar, Mabud, zibaye ei šob ham gore hibaye ei hota hor,' ");
INSERT INTO rhg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","zin hibattu bout age loti zana. ");
INSERT INTO rhg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","\"Hetolla ãr howa oilde Oihudi okkol zara Allar mikka fijje hitarare ãra iyan duk ofan gori no di. ");
INSERT INTO rhg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kintu ãra hitarar hãse endilla leki faṭaiyum, zene hitara mutti fũzar har hamottu edde zenar hamottu, ar gola sibi dori marifelai zandaror gusto edde lou hattu dure take. ");
INSERT INTO rhg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ei hokumgun diya bala oibo, kiyollahoile Musaye zin hoiye hin bout age loti fotti šohore šohore tobolig gora oiye. Ar zin zin hibaye leki giye hin fotti dórmo din sinagog okkolot telewat gora o.\" ");
INSERT INTO rhg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hetunot asab okkole, zomator murubbi okkole edde aro oinno manuš okkole endilla faisala loiye ze, hitara hoekzon manušore basi loi Paulos edde Barnabasor fũwati Anṭiyok šohorot defeṛaibo. Ehudah, zare Barsabbas hoito edde Silas, zara báiyain okkolor butore ijjotdar manuš, hitarare basona goijje. ");
INSERT INTO rhg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Toi hitarar fũwati ei šeṛigan defeṛa oiye: Anṭiyok, Siriya edde Kilikiyar Oihudi biššaši báiyain okkol, tũwarare ãr Šalom. ");
INSERT INTO rhg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ãra fuinni ze ãrar butottu ho ekzone zaiyore, hitara bout ḍoilla hota hoiyore tũwarare bekub banaiye edde tũwara alabula oiyo. Kintu ãra hitarare hendilla hoibolla no defeṛai. ");
INSERT INTO rhg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hetolla ãra beggune ek oiyore ho ekzonore basi loi ãrar adoijja fũwajja Barnabas edde Paulusor fũwati tũwarar hãse hitarare defeṛair. ");
INSERT INTO rhg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ei dunizone ãrar Malik Isalla buli hitarar nizor zibonore morar fõtot lagai diye. ");
INSERT INTO rhg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ãra Ehudah edde Silasore o defeṛair zene ãra zin lekki hin tũwarare hitarar muke hoi fare. ");
INSERT INTO rhg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Pak Ruhuye edde ãra iyan bala mone gorilam ze, ei ho ekkan beši dorhari ziniš sara ar hono oinno fũza tũwarar uwore tulidiya no o. ");
INSERT INTO rhg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","He dorhari zinišgun oilde: Tũwara devotar name kurbani goijjode hána no haiyo, lou, gola sibi dori mari felaiya zanuwaror gusto hattu edde beššagirittu dure tako. In okkolottu tũwarare dure rakile tũwarar balai oibo. Tũwarar šanti ok. ");
INSERT INTO rhg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Toi hitarare defeṛaiye, hitara lamat Anṭiyokot aišše. Heṛe hitara zomator manuš okkolore ekottro goriyore he šeṛigan hitarare diye. ");
INSERT INTO rhg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hitara hiyan foijje edde hiyane ze tuwajjo diye hin loi beggune kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ar Ehudah edde Silas, hitara nize o nobi hisabe, hitara o bout hota okkol hoiyore heṛiyar báiyain okkolore tuwajjo edde šokti diye. ");
INSERT INTO rhg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Hitara kissu din heṛe taki bade, zara hitarare defeṛail, hitarar hãse firi zaiboilla báiyain okkolottu šanti gori bidai loiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kintu Paulus edde Barnabas Anṭiyokot taigilgoi, zeṛe hitara edde aro bout manuš okkolore fũwati šikka dito edde kušir hóbor tobolig gorito. ");
INSERT INTO rhg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kissu din bade Paulose Barnabasore hodde: \"Aiyo, ãra Malikor kalam tobolig goijjilamde he šohor okkolot torikotor báiboinain okkolor heṛe beraito zai, ar hitara ken ase saigoi.\" ");
INSERT INTO rhg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Hetunot Barnabase Yuhanna, zare Mark ho, hibare fũwati loi zaito saiye. ");
INSERT INTO rhg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paulose kintu hibare fũwati loizare bala mone no gore, kiyollahoile Marke hitarare Famfuliyat eri hentu gilgoi. He oite hitarar fũwati ar ham no gore. ");
INSERT INTO rhg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hetunot hitarar butore mot omil oiye, hetolla hitara ekzone ekzon loi aleda oigilgoi. Barnabase Markore loi zahazot gori Kiprus ḍiyat giye, ");
INSERT INTO rhg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu Paulose Silasore basi loiye. Ar báiyain okkole Paulus edde Silasore Mabudor rahamotor hatot tuli di bade hitara rowana diye. ");
INSERT INTO rhg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulose Siriya edde Kilikiya di baisa diye, ar zomat okkolore aro mojbut goijje. ");
INSERT INTO rhg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bade Paulos Dorbi šohorot aišše, hentu Lystra šohorot giye. Ar so, heṛe Timoti name ekzon biššaši aššil. Hite aššilde ekzon biššaši Ihudi mayafuwar fuwa, ar baf aššilde Girik zat. ");
INSERT INTO rhg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra edde Ikuniyar biššaši báiboinain okkole Timotir babute bala nam gorito. ");
INSERT INTO rhg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulose Timotire fũwati loi zaito sail buli hitare azomi goraiye, kiyollahoile heṛe ze Ihudi okkol takito hitara zanito Timotir baf ekzon Girik zatide hiyan. ");
INSERT INTO rhg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bade hitara šohore šohore giye edde Zeruzalemor asab okkol edde he murubbi okkole ze hokum okkol dil hitara hin manuš okkolore zanaiye. Ar he niyom okkol falon goitto hoiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ei bafe zomator manuš okkol biššaše mojbut oiye edde hitarar dol din din bari za šuru goijje. ");
INSERT INTO rhg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pak Ruhuye hitarare Ešia dešot kalam tobolig gorito no de, hetolla hitara Forugiya edde Galatiya deš bai giye. ");
INSERT INTO rhg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hitara Mysiyar hãsa hãsi fõsi, hentu Bitúniya zaito kušiš goijje, kintu Isar Ruhuye hitarare zaito no de. ");
INSERT INTO rhg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Toi hitara Mysiya bai lamat Troasot aišše. ");
INSERT INTO rhg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Raitta Paulose ek deha fail, hibaye dekedde, ekzon Makeḍuniyar manuš aiyore tiyaiye edde foriyad gori ḍaki hodde: \"Makeḍuniyat aiyore ãrare modot goro!\" ");
INSERT INTO rhg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulose ei deha fai bade ãra Makeḍuniyat zaibolla hehon tiyar oilam, kiyollahoile ãra buzi faijjilam ze Allaye ãrare heṛe kušir hóbor tobolig goribolla ḍaker. ");
INSERT INTO rhg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bade ãra doriyar fõte Troasottu uzu siri Samotrak, tarforor din Neofolisot fõsilam. ");
INSERT INTO rhg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Henttu Filifit maze gilam, hiyan Makeḍuniyar he elehar mein šohor edde Romiyo okkolor koloni, he šohorot ãra hoddin takilam. ");
INSERT INTO rhg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ar dórmor din ãra šohoror baire doriyar farot gilam, ar ãra mone goijjilam heṛe munazator zaga ase. Ãra heṛe boilam edde heṛe ek dol mayafuwain dola oiyede hitara loi hota hoilam. ");
INSERT INTO rhg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ar hitarar butore Tuwatira šohoror Ludiya name ek allawala maya fuwa aššil. Hibaye baiyonna rongor horor beboša gorito. Hibaye ãrar hota funnil. Malike hibar dil kuli dil zene hibaye Paulosor hotat diyan de. ");
INSERT INTO rhg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hiba edde hibar góror manuš okkol beggune torikotor gusol loiye. Bade hibaye ãrare foriyad gori hodde: \"Õnora zodi ãre Malikor name biššaši boli mone goro, toile ãr górot ai takogai.\" Ei hota hoiyore hibaye ãrare ata ati gori dori ṭani hibar gorot loigiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ek din ãra he munazator zagat zaidde šomot, ekzon bandir loi deha oilam zattu ek ruh aššil, ziyan loi hibaye goni farito. Hibaye gonafora loi hibar malik okkololla beši ṭiya hamaiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hibaye Paulos edde ãrar fise fise aiššil edde guzori hoil: \"Ei manuš itara Šorbo šoktiwala Allar gulam okkol, itara tũwarare nazator fõt zanai dedde.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hibaye bout din foijjonto endilla gorat takil. Kintu Paulose ar bordaš gori no fari muk firai he ruhure hodde: \"Ãi Isa Mosir name hokum dir, hibar butottu niyoli zagoi.\" Henot hehon hiba hibattu niyoli giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kintu hibar malik okkole, lafor aša ar nai deki Paulos edde Silasore dori bazarot šorharor hãse ṭani loigiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hitara itarare Romiyo bisarhar okkolor munttu loizaiyore hodde: \"Ei manuš okkole ãrar šohorot beši gonḍogul sirišti gorer. ");
INSERT INTO rhg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Itara Ihudi, ar ãra Romiyo. Ãrar riti niti mozin zin falon gora mana, itara hin tobolig gorer.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Henot oinno manuš okkole o hitarar berudde giye. Ar bisarhar okkole hitarar gar hoor siri felaito edde bet maribolla hokum diye. ");
INSERT INTO rhg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Toi hitarare beša beši mar dor gori bade ziyolot golai eijje. Ar hitarare bala gori fahara dibolla ziyolarore hokum diye. ");
INSERT INTO rhg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Endilla hokum faiyore ziyolare hitarare beši butoror kamerat loigiye edde kundat maze ṭeng ãṭkai eijje. ");
INSERT INTO rhg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kintu ada raitta Paulos edde Silas Allar hãse munazat edde šukuriya gan goijjil edde hodi okkole hin õl gori funnil. ");
INSERT INTO rhg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Hetunot atikka ḍõr busal oil, en ki ziyolhanar meṛi udda hafi uṭṭil, ar hannasun šomosto doroza okkol kuligilgoi edde har hodi okkolor band kuligilgoi. ");
INSERT INTO rhg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Henot ziyolar gumottu seton oil edde ziyolor dorozagun kula deki, toluwar loi hite hitar nizor zan nize loibolla bebosta loiye. Kiyollahoile hite hodi okkol dai giyegoi boli mone goijje. ");
INSERT INTO rhg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kintu Paulose guzori ḍak mari hodde, \"Oh, nizor hoti no goris, kiyollahoile ãra beggun eṛe asi.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hetunot he ziyolare serag ani hoi hite dũri butore giye, edde beša beši ḍore hafite hafite Paulos edde Silasor ṭengor sarme foijje. ");
INSERT INTO rhg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Toi hite hitarare hentu baire niyolai ainne edde fusar goredde, \"Sahab okkol, uddar faibolla ãttu ki gora foribo?\" ");
INSERT INTO rhg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hitara zuwabe hodde, \"Tũi Malik Isare biššaš goro, toi tũi edde tũwar gór ṭiyaye uddar faiba.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bade hitara hitare edde hitar góror manuš beggunore Malikor kalam hoiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ar he raitta ziyolare hitarare hitar fũwati loigiye edde hitarar haṛa sira gá okkolore duiye. Ar hite edde hitar góror manuš beggune hehon torikotor gusol loiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tarfore ziyolare hitarare góror butore loigiye edde hitarar sarme hána fani ani diye. Hite edde góror manuš beggune Allare biššaš gori faijjede hiyanor uwore hitara beggune beši kuši oiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bade din zehon oiye, bisarhar okkole ziyolaror hãse endilla hokum loi ofisar okkolore defeṛaiye: \"Ei manuš okkolore erido.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Toi ziyolare ei hóbor Paulosore diyegoi edde hodde: \"Bisarhar okkole õnorare eri dito hokum diye. Õnora ehon niyoli aiyo, aramor sãte zogoi.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Hetunot Paulose hodde: \"Ãra Romor nagorik oi bade ãrar bisar no gori, beainna mainšor šaikkat ãrare bet mara oiye edde ziyolot diya oiye. Ar ehon ãrare gufone bair gori dito sadde neki? Hen oi no fare. Hitara nize aiyok edde ãrare bair gori loi zok.\" ");
INSERT INTO rhg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Toi ofisar okkole ei hóbor bisarhar okkolore zanaiyegoi. Itara Romor nagorikde zani fariyore ḍoraiye. ");
INSERT INTO rhg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Toi bisarhar okkole aiyore Paulos edde Silasottu maf saiye edde hitarare ziyolottu baire niyolai loigiye, ar šohor sari zaibolla foriyad goijje. ");
INSERT INTO rhg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hitara ziyolhanattu niyoli ai bade Ludiyar górot giye. Heṛe torikotor báiboinain okkol loi deha goijje edde hitarare tuwajjo di bade henttu giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bade hitara Amfipuli edde Apolloniyar mazottu faṛi zai Tessalonika šohorot aiššil, zeṛe ek Ihudi okkolor sinagog aššil. ");
INSERT INTO rhg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ar Paulose hibar niyom mozin sinagogot giye. Hendilla tin dórmor din fan hitarare kitabottu buzaiye. ");
INSERT INTO rhg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Hibaye kitabottu mainšore forman diye ze Mosir moron edde mora okkolor butottu uwafes uṛa iyan hameka zorulot aššil. Hibaye hitarare hodde: \"Ze Isar hota ãi tũwarar hãse tobolig gorir, hiba oilde he Mosi.\" ");
INSERT INTO rhg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Henot ho ekzone hitarar hotat biššaš ainne edde Paulos edde Silasor fũwati zug oiye. Ar ek ḍõr Allar ḍorwala Girik manušor dole edde beš hoekzon zimmadar mayafuwainde o zug dil. ");
INSERT INTO rhg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kintu Ihudi okkole rag gori, bazarguwa hoekzon horaf manuš zomula goijjil edde šohorot gonḍogul bazai dil. Tarfore hitara Paulos edde Silasore tuwai bair gori manuš okkolor munttu anibolla Jaisonor górot hamela goijje. ");
INSERT INTO rhg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kintu hitarare tuwai no faiyore Jaison edde ho ek báiyore hitara šohor šasiyot goroyar hãse ṭani loi zaiyore guzori hodde: \"Ei manuš okkole fura duniyaire utaltal goijje, ehon hitara eṛe hazir oiye, ");
INSERT INTO rhg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ar Jaisone hitarare mehemandari gorer. Itara beggune Romor badša hokumor beruddota gorer edde Isa name ar ekzon badša ase boli hor.\" ");
INSERT INTO rhg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Zehon ei šob hota okkol fuinne, manušor dol okkol edde šohoror šasiyot goroya okkol ũtari uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ar hitara Jaison edde oinno beggunottu zomanot loi zabine eri diye. ");
INSERT INTO rhg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bade raitta torikotor báiyain okkole Paulosore edde Silasore Beriyat faṭai dil. Hitara heṛe fõsi bade, Ihudi okkolor sinagogot giye. ");
INSERT INTO rhg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tessalonikar Ihudi okkolottuwaro Beriya šohoror Ihudi okkolor dil kula mela aššil. Hitara beši ajju loi Allar kalam fuinne edde hinore kobul goijje. Ar Paulose zin hoiye hin soiyi ne naki no saibolla fotti din hitara kitabot maze tuwai saito. ");
INSERT INTO rhg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hitarar butottu bout Ihudi okkole biššaš ainne, hendilla bout tuwangor Girik mayafuwain okkol edde manuš okkole o biššaš ainne. ");
INSERT INTO rhg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kintu Tessalonikar Ihudi okkole zehon zani faijje ze, Beriyat o Paulose Allar kalam tobolig gorer hetunot hitara heṛe aišše edde manuš okkolore uskani diyore gulmal bazai diye. ");
INSERT INTO rhg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Henot torikotor báiyain okkole hehon Paulosore doriyar soror hãsat zaibolla faṭai diye. Kintu Silas edde Timoti Beriyat taki giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Zara Paulosore fũwati loigiye hitara hibare Aten foijjonto ainne. Tarfore hitara uwafes aigiyegoi Silas edde Timotilla endilla hokum loi, tũwara zeto toratori šombob ãr hãse aizogoi. ");
INSERT INTO rhg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulose Aten šohorot Silas edde Timotilla entezar goredde šomot dekedde he šohorgan mutti okkole boraiya, hen dekiyore hibar mon hošoṛi uiṭṭe. ");
INSERT INTO rhg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hibaye Muzolišhanat Ihudi okkol loi, Allar ḍorwala Girik okkol loi edde fotti din bazarot zai zara loi deha oito hitara loi hota hoito. ");
INSERT INTO rhg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Toi Efikurian edde Sṭoiki dolor hoekzon fonḍite Paulos loi hotat baza bazi diye. Hitarar butottu ho ekzone hodde: \"Ei hotabaze ki hoito sadde?\" Kintu kiye kiye hodde: \"Hite hono oinno devota okkolor hota zanaito sar oibo!\" Kiyollahoile Paulose Isa edde uwafes zindar babute kušir hóbor tobolig goijjil. ");
INSERT INTO rhg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Toi hitara hibare hitarar fũwati loigiye edde Eripagas šobar sarme hazir goijje. Hitara Paulosore fusar goijje, \"Tũi ze noya šikka tobolig goror hin hon ḍoilla, ãra zani faijjum ne? ");
INSERT INTO rhg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kiyollahoile tũi ze en hodun hota hor zin ãra funi toddo oir. Ar hetolla ei šob hotar mani ki ãra zainto sai.\" ");
INSERT INTO rhg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Hitara ei hota hoiyede kiyollabuli hoile, Atenor bašinda okkol otóba bideši okkol zara heṛe takito hitara šude noya noya hota howa ba funa sara oinno hono kissut ṭaim borbat no goitto.) ");
INSERT INTO rhg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Hetunot Paulose Eripagas šobat maze uṛi tiyaiye edde hodde: \"Oh Atenor manuš okkol! Ãi dekir, tũwara har mikkattu beši dórmidar. ");
INSERT INTO rhg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kiyollahoile ãi guitto giyide šomot tũwarar fũzagór dekkilam. Ar en ugguwa devota zibar uwore leka ase, OZANA DEVOTAR MUTALLEK. Tũwara no zani zar fũza goror, hibar babute ãi tũwarar hãse tobolig gorirde. ");
INSERT INTO rhg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Allah ze duniyai edde hiyanor butoror hár kissure tiyar goijje, hiba oilde asman zobinor Malik, hiba manušor hate banaiya fũza górot no take. ");
INSERT INTO rhg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Hibattu hono obaf nai, hetolla manušor hatottu o šeba lowa hibattu dorhar nai, kiyollahoile hibaye hár manuš okkolore zibon edde foran ar oinno hár kissu diye. ");
INSERT INTO rhg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hibaye ekzon manušor duwara har zatire banaiye. Hibaye hitarare duniyair agagura bošobaš goitto diye. Hitara hõtte hoṛe bošobaš goribo hin o faisala gori diye. ");
INSERT INTO rhg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Allaye iyan goijje zene manuš okkole hibare tuwa, zodi hitara tuwaite tuwaite hitara hibare tuwai fa. Asole hiba ãra honokiyor hãsottu dure no. ");
INSERT INTO rhg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kiyollahoile ãra hibar butore zinda asi edde solafira gorir, ar basi asi. Zendilla tũwarar hoekzon šaire o hoiye, 'Kiyollahoile ãra o hibar bongšodor.' ");
INSERT INTO rhg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","\"Henoile ãra zehon Allar fuwain toile Allare manušor hat edde sinta šokti diyore tiyar goijja šuna rufa ba fattoror mutti ãrattu mone no gora foribo. ");
INSERT INTO rhg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Agor mainše no zanito boli Allaye in okkol dekiyore hinore hosuri mone no gorito. Kintu ehon hibaye hár zagat mon firaibolla manuš okkolore hokum diye. ");
INSERT INTO rhg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kiyollahoile hibaye en ekkan din ṭik goijje ze din hiba nizor basona goijja he zonore diyore duniyair bisar goraibo. Ar he zonore morattu zinda tuliyore hár manuš okkolor hãse forman diye.\" ");
INSERT INTO rhg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Morattu abar zinda uiṭṭe he hota funiyore hitara kiye kiye hãša hãši goijje, kintu ar oinnogune hodde, \"Ei babute tũwar hota ãra abar hono šomot funium.\" ");
INSERT INTO rhg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hetunot Paulos he šoba sari giyegoi. ");
INSERT INTO rhg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kintu hoekzon manuše Paulos loi zug diye edde biššaš ainne. He biššaši okkolor butore Dionysios name Eripagas šobar ekzon, Damariš name ekzon maya fuwa, ar fũwati aro hoekzon. ");
INSERT INTO rhg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Iyar bade Paulose Aten šohor sari Korontiyo šohorot giye. ");
INSERT INTO rhg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Heṛe Akila name ekzon Ihudi manuš loi deha oiye. Pontus destrikot Akila zormo oil. Badša Klaudiuse har Ihudi okkolore Rom šohorottu zaitogoi hokum dil, hetolla kissu din age Akilaye hitar bou Priskillare loi Itali dešottu Korontiyo šohorot aigilgoi. Paulose hitarar heṛe giye. ");
INSERT INTO rhg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kiyollahoile Paulos o hitarar ḍoilla ṭambu banaoya aššil. Hibaye hitarar fũwati taki ham gora doijje. ");
INSERT INTO rhg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Fotti dórmor din Paulose sinagogot Isar babute Ihudi okkolore edde Girik okkolore hota buzaito edde hitarare Isar uwore biššaš anibolla tagid gorito. ");
INSERT INTO rhg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas edde Timoti zehon Makeḍoniyattu aišše, Paulose šude Allar kalam tobolig goitto, ar Isa Moside hiyan Ihudi okkolor hãse goba dito. ");
INSERT INTO rhg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kintu Ihudi okkole zehon Paulosor berudde hota hoi hibare ofoman gora šuru goijje, hetunot hitarar berudde Paulose hor zarifelai hodde, \"Tũwarar louwor dai tũwara nizor matar uwore forok. Ei babute ãr hono dai nai. Ehonottu loti ãi Oihudi okkolor hãse zaiyum.\" ");
INSERT INTO rhg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Toi Paulose sinagog sari Titius Zoštus name ekzon allawala manušor górot giye, zar górgan he sinagog loi bazaiya aššil. ");
INSERT INTO rhg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus name sinagog šasiyot goroya edde hitar fura góror gušṭi ṭiya beggune Malikor uwore biššaš ainne edde aro bout Korontiyo okkol, zara hibar hota fuinne hitara o biššaš ainne edde torikotor gusol loiye. ");
INSERT INTO rhg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ek raitta Malike Paulosore sopponot deha diyore hodde: \"No ḍorais, bolke hota ho, suf no takis. ");
INSERT INTO rhg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ãi tor fũwati fũwati asi, honokiye tore sui no faribo otóba tor hoti gori no faribo, kiyollahoile ei šohorot ãr bout manuš ase.\" ");
INSERT INTO rhg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Henot Paulos der bosor he šohorot takiyore manuš okkolore Allar kalam šikka diye. ");
INSERT INTO rhg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galliyo ze šomot Akaia destrikor šašon goroya oiye hẽtte Ihudi okkol beggune mili Paulosor berudde uiṭṭe edde hibare dori adalotot loigiye. ");
INSERT INTO rhg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Hitara hodde, \"Ei manušwaye endilla gori Allar ebadot goribolla uskani der ziyan ainor ulda.\" ");
INSERT INTO rhg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kintu Paulose muk kulibar agottu Gallioye Ihudi okkolore hodde: \"Oh Ihudi okkol, iyan zodi hono oinnai ba beši ḍõr hosuri oito toile ãi tũwarar hota funa ãlla ṭik ham oito. ");
INSERT INTO rhg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kintu iyan zehon nam ba hota otóba tũwarar nizor ainor babute suwal, toile tũwara tũwara iyanor faisala gorogoi. Ãi endilla befarot ãi bisar goroya oito no sai.\" ");
INSERT INTO rhg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Bade hite hitarare adalotottu lorai diye. ");
INSERT INTO rhg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tarfore manuš beggune miliyore sinagog šasiyot goroya Sostinesore dori loizai adalotor sarme mardor goijje. Gallioye kintu hin dekiyore o no dekefan gori taikke. ");
INSERT INTO rhg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bout hoto din Korontiyo šohorot haṛai bade Paulose torikotor báiyain okkolottu bidai loiye edde Akila edde Priskillar fũwati doriyar fõte Siriya dešot giye. Paulose manoš goijjil buli zahazot uṛibar age hibaye Kinšeriyat bondorot matar sul haṛi felai