﻿USE sofia;
DROP TABLE IF EXISTS sofia.rgu_vpl;
CREATE TABLE rgu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rgu_vpl WRITE;
INSERT INTO rgu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Masososa na, Manetualain adu lalai no dae-bafoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tepoꞌ ria, dae-bafoꞌ a bei ta dadi fa. Basan bei taohiro-taohari. Hapu noi oe. Ma maiu-inaꞌ napoti nan. Manetualain Dula-dale na laꞌo-laꞌo nai oe ria lain. ");
INSERT INTO rgu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Basa de Manetualain dedea nae, “Muste hapu makaledoꞌ.” Dedea basa nae leoꞌ na, boe ma hapu makaledoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nita makaledoꞌ ria, boe ma dale na namahoꞌo, nana huu hata fo Ana adu a, tebe malole. Basa de Ana tada makaledoꞌ ria nemeꞌ maꞌiuꞌ a mai, de esaꞌko noꞌ ledo-fain. ");
INSERT INTO rgu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ana fee makaledoꞌ ria, nade ‘leledoꞌ’, ma maiꞌuꞌ ria nade ‘hatuꞌ’. Ria nana, fai masososaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Basa de Manetualain dedea bali, nae, “Muste hapu mamana rouꞌ fo tada-bati oe a. Huu ria na, de hapu oe nai tadaꞌ lai, ma hapu oe nai tadaꞌ dae.” Dedea basa leoꞌ na boe ma, oe a tada-batin neuꞌ dua. ");
INSERT INTO rgu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Basa boe ma Ana fee mamana rouꞌ fo nai tadaꞌ lai, nade ‘lalai’. Ria nana, fai kadua. ");
INSERT INTO rgu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Basa de Manetualain dedea bali, nae, “Oe nai tadaꞌ dae, muste nabua neuꞌ mamanaꞌ esa, fo ela hapu dae tuuꞌ.” Dedea basa nae leoꞌ na, boe ma hapu dae tuuꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Basa de Ana fee dae tuuꞌ ria, nade ‘madaꞌ lain’, ma oe fo nabua neuꞌ esa a, Ana feen nade ‘tasiꞌ’. Nita basa sira boe ma, dale Na namahoꞌo, nana huu hata fo Ana adu a, tebe malole. ");
INSERT INTO rgu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Basa de Manetualain dedea bali, nae, “Madaꞌ lain muste namomoriꞌ basa huu manrerebiꞌ ma doo mansesepeꞌ ara. Muste hapu ai huu maboaꞌ, ma madekeꞌ, ma doo manmomodoꞌ. Ela leoꞌ bea na, huu manrerebiꞌ ma doo mansesepeꞌ ara esaꞌko neniꞌ buna-boan tuka ria rupa na.” Dedea basa leoꞌ na, boe ma basan dadi. ");
INSERT INTO rgu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nai madaꞌ lain huu manrerebiꞌ ma doo mansesepeꞌ ara kalua buna-boa nara tuka sira esaꞌko rupan. Nita basa sira, boe ma dale na namahoꞌo, nana huu hata fo Ana adu a, tebe malole. ");
INSERT INTO rgu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ria nana, fai katelu. ");
INSERT INTO rgu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Basa de Manetualain dedea bali, nae, “Nai tadaꞌ lai muste hapu hata makaledo rupaꞌ ara, ela rahaa dae-bafoꞌ ia. Muste hapu ruma rahaa nai fai leledoꞌ, ma muste fekeꞌ ara rahaa nai fai hatuꞌ. Basa sira dadi tanda fo ela leoꞌ bea na bisa reke fai, teuꞌ, ma ledo-fai.” Dedea basa nae leoꞌ na, boe ma hapu basa hata makaledoꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ana tao na hata makaledo bau-inaꞌ rupaꞌ dua. Hata bau-inaꞌ a, nahaa nai fai leledoꞌ; ma maraaꞌ a nasararaa nai fai hatuꞌ. Ana adu na ruuꞌ ara boe. ");
INSERT INTO rgu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ana ator hata sira rai lalai, fo ara rahaa leo dae-bafoꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Basa de ara rahaa nai fai leledoꞌ, ma rahaa nai fai hatuꞌ. No ria na, ara tada-bati makaledoꞌ a neme maꞌiuꞌ a mai. Nita basa sira, boe ma dale Na namahoꞌo, nana huu hata fo Ana adu a, tebe malole. ");
INSERT INTO rgu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ria nana, fai kahaa. ");
INSERT INTO rgu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Basa de Manetualain dedea bali, nae, “Muste hapu banda rupaꞌ ara rasoda rai oe daleꞌ. Ma muste hapu manupui rupaꞌ ara laa-laa rai dae-bafoꞌ a lain.” ");
INSERT INTO rgu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Basa de Ana adu na basa ika rupaꞌ ara ro banda bau-inaꞌ fo rasoda rai oe daleꞌ. Ana adu manupui rupaꞌ ara laa-laa rai lalai boe. Nita basa sira, boe ma dale na namahoꞌo, nana huu hata fo Ana adu a, tebe malole. ");
INSERT INTO rgu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Basa boe ma Ana dedea fee ua-naleꞌ neuꞌ basa banda ra, nae, “Ikaꞌ ara muste tamba dodouꞌ fo rahenu oe nai basa mamanaꞌ. Ma manupuiꞌ ara boe muste tamba dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ria nana, fai kalima. ");
INSERT INTO rgu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Basa de Manetualain dedea bali, nae, “Muste hapu banda rupaꞌ ara, fo rasoda rai madaꞌ lain. Riꞌ banda aeꞌ, banda fuiꞌ, ma banda manlodo-manraeꞌ, esaꞌko noꞌ rupan.” Dedea basa nae leoꞌ na, boe ma hapu basa banda-manuꞌ ara. Nita basa sira, boe ma dale na namahoꞌo, nana huu hata fo Ana adu a, tebe malole. ");
INSERT INTO rgu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Basa de Manetualain dedea bali, nae, “Mai fo Ita adu-tao lahenda tuka Ita rupa-lolen. Fo ela ara rafaduli ma ator basa ikaꞌ rai tasiꞌ a, basa manupuiꞌ rai lalai, basa banda aeꞌ, ma basa banda fekeꞌ fo rasoda rai dae-bafoꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Boe ma Ana adu-tao lahenda tuka Ria rupa-lolen. Ana adu-tao naa si, touꞌ no inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Boe ma Ana dedea fee si ua-naleꞌ nae, “Emi muste boki tamba dodouꞌ fo mahenu dae-bafoꞌ ia, ma ator ana. Au fee emi hak boe, fo urus ikaꞌ ara, manupuiꞌ ara, ma basa banda nai madaꞌ lain. ");
INSERT INTO rgu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nenene matalolole! Au bati-pala fee emi nanaa-nininu rupaꞌ nai dae-bafoꞌ ia. Riꞌ: huu maboaꞌ, ma madekeꞌ, ma doo manmomodoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Au boe fee basa huu manrerebiꞌ ma doo mansesepeꞌ rupaꞌ, ela dadi reuꞌ banda rupaꞌ ara nanaan. Hapu nanaaꞌ soaneuꞌ banda aeꞌ, banda fuiꞌ, manalodo-manaraeꞌ, ma manupuiꞌ ara.” Dedea basa leoꞌ na, boe ma hapu nanaa rupaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nita basa sira boe ma, dale na namahoꞌo nana huu hata fo Ana adu a, tebe malole nan seliꞌ. Ria nana, fai kanee. ");
INSERT INTO rgu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","No ria na, Manetualain adu na lalai ma dae-bafoꞌ a, no basa oe-isi nara. ");
INSERT INTO rgu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ana noi-tao nabasa si, de balahaꞌ naraa no fai kahitu na, boe ma Ana hahae aon. ");
INSERT INTO rgu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","No ria na, Ana tao fai kahitu a dadi neuꞌ fai bau-inaꞌ neme fai fekeꞌ ara mai. Ana ator leo naꞌ, nana huu noi-tao nabasa nonoi-tataon, basa de fai kahitu a, boe ma Ana hahae aon. ");
INSERT INTO rgu_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Manetualain adu lalai ma dae-bafoꞌ a, tutui na riꞌ naꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Tepoꞌ fo MANETUALAIN besaꞌ ko mulai adu lalai no dae-bafoꞌ a, ");
INSERT INTO rgu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","bei ta hapu parusa hata-hata esa boeꞌ, nana huu Ana bei ta naondaꞌ uda fa. Tepoꞌ ria, hapu adaꞌ noi masuꞌ neme dae a mai fo naꞌoe dae-bafoꞌ a. Ma bei ta hapu lahenda tao oka-tine. ");
INSERT INTO rgu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Basa boe ma, MANETUALAIN hai na dae baiꞌ, de tao nan dadi neuꞌ lahenda. Basa de Ana fuu ani hahaeꞌ leo idu bolon daleꞌ neu, boe ma lahenda ria nasoda tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Basa de MANETUALAIN buka okaꞌ esa nai dae Eden pooꞌ dulu. Boe ma Ana fee lahenda a leo neuꞌ okaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nai okaꞌ ria daleꞌ, Ana namomoriꞌ na ai huu malole rupaꞌ ara so, fo lahenda bisa raa no mina-malada. Ana namomoriꞌ na ai huuꞌ rupaꞌ dua rai okaꞌ ria talada. Maneniko lahenda naa ai huuꞌ sira esa boa na, ana nasoda naroo. Tehuu maneniko lahenda naa ai huuꞌ esa boa na bali, sona ana bisa bubuluꞌ nae bea riꞌ malole ma bea riꞌ tadaluꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hapu lee esa nai naa, faa kalua neme okaꞌ ria mai. Lee ria nanuu baꞌe haa. ");
INSERT INTO rgu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Baꞌe masososaꞌ a, nade Pison. Baꞌe ria rule-feo basa dae Hawila. Nai naa, hapu lilopilas. ");
INSERT INTO rgu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Hapu lilopilas isiꞌ, hapu ai huuꞌ fo naana na naboomeni, ma hapu batu makarelaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Lee ria baꞌe kadua na, nade Gihon. Baꞌe ria rule-feo basa dae Kus. ");
INSERT INTO rgu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Baꞌe katelu na, nade Tigris. Baꞌe ia riꞌ dadi too nai dae Asyur, pooꞌ dulu. Baꞌe kahaa na, nade Efrat. ");
INSERT INTO rgu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","MANETUALAIN fee lahenda ria leo nai Eden, ela nafaduli natalolole okaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Boe ma Ana pareta lahenda ria nae, “O bole mua sudi laꞌe ai boa ubeaꞌ neme basa ai huuꞌ nai okaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tehuu hapu esa nai naa, o ta bole muan fa. Riꞌ ai huuꞌ fo nafada nae bea riꞌ malole ma bea riꞌ tadaluꞌ. Maneniko mua ni, sona o mate.” ");
INSERT INTO rgu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Basa de MANETUALAIN dedea bali, nae, “Maneniko lahenda ia nasoda mesaꞌ ana, sona ta malole a fa. De Au nau adu-tao feen, nonooꞌ esa naraa noo ni.” ");
INSERT INTO rgu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Tepoꞌ ria, MANETUALAIN hai na dae, de tao na banda rupaꞌ ma manupuiꞌ. Basa de Ana neni banda ra, ma manupuiꞌ ara leo lahenda ria neu, ela leoꞌ bea na ana foi nade nara. De lahenda ria foi banda ra ma manupuiꞌ ara esaꞌko noꞌ naden. Tehuu ria mesaꞌ ana bei ta hapu nonooꞌ esa fo naraa non boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Basa de MANETUALAIN tao na lahenda ria suku namanee. Tepoꞌ fo ana suku, Manetualain hai na dui aiusun esa, boe ma napoti faliꞌ hinaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Neme duiꞌ ria mai, Ana tao nan dadi neuꞌ inaꞌ esa. Basa de fee inaꞌ a leo lahenda ria neu. ");
INSERT INTO rgu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Lahenda a nita inaꞌ ria, boe ma nae, “Naa! Ia dei! Ia besaꞌ ko naraa no au! Dui na sama leoꞌ au dui ka, ma aopaa na boe, sama leoꞌ au aopaa ka. Huu no ana dadi neme touꞌ a mai, de au foi ni, nade ‘inaꞌ’.” ");
INSERT INTO rgu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huu ria na, de touꞌ a muste foa ela ina-ama nara, fo neu nasoda daleꞌ esa no sao na, huu fo sira dua nanahekeꞌ dadi esaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tepoꞌ ria, dua si bei poiraoꞌ, tehuu ara ta maeꞌ baiꞌ boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nemeꞌ basa banda fo MANETUALAIN tao naa si nai dae-bafoꞌ ia so, meke a riꞌ malela napuputa na seli. Laiꞌ esa de, meke a natane inaꞌ ria nae, “Tebe do? Manetualain horo nae, ‘Emi ta bole mia ai boaꞌ neme ai huuꞌ fo rai okaꞌ ia, hete?’ ” ");
INSERT INTO rgu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Inaꞌ ria nataa natafaliꞌ nae, “Taꞌa! Ami bole mia! Tehuu noi ai huuꞌ esa nai okaꞌ a talada, riꞌ Manetualain horo ami mia ni. Ana nae ami ta bole mia ni, ma ta bole tototo laꞌe boa na, taꞌa sona ami mate.” ");
INSERT INTO rgu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tehuu meke ria nataa nae, “Ae, ria ta laꞌe fa! Emi ta mate fa! ");
INSERT INTO rgu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Manetualain horo tao leoꞌ na, huu fo Ana bubuluꞌ nae, maneniko emi mia ai boaꞌ ria, sona emi malelaꞌ sama leoꞌ Ria. Neuꞌ ko emi bubuluꞌ bea riꞌ malole ma bea riꞌ tadaluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Basa de inaꞌ a mete neu te, ai huuꞌ ria malole a, ma boa na nonooꞌ nae malada na seli. Boe ma ana afi nae, “Maneniko au ua ai boaꞌ ia, tantu au dadi malelaꞌ.” Basa de ana etu na ai boaꞌ ria, boe ma naa. Basa de ana neni fee sao na, ma ana naa boe. ");
INSERT INTO rgu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Raa basa, boe ma besaꞌ ko ara bululuꞌ rae, dua si poiraoꞌ. Huu ria na, de ara nato ai doo fo raꞌeoꞌ rapoti mamae nara. ");
INSERT INTO rgu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Leodaen ria, boe ma ramanene MANETUALAIN laꞌo-laꞌo nai okaꞌ ria daleꞌ. Basa de ara reu tamaꞌ nai ai huuꞌ, fo ela MANETUALAIN bosoꞌ nita si. ");
INSERT INTO rgu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tehuu MANETUALAIN naloo touꞌ ria nae, “Ae! Adam, o nai bea?” ");
INSERT INTO rgu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Touꞌ a nataa nae, “Au amanene Manetualain hara-oe ma nai ia. Tehuu au maeꞌ, huu fo au poꞌiraoꞌ. Huu ria na, de au tamaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Basa de Manetualain nae, “Bea riꞌ nafada nae, o poiraoꞌ? Leoꞌ bea? Tantu o mua ai boaꞌ fo Au horo a, hete?” ");
INSERT INTO rgu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ana nataa nae, “Inaꞌ fo Manetualain fee ela sama-sama no au a, ria riꞌ neni ai boaꞌ a de au ua!” ");
INSERT INTO rgu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Basa boe ma MANETUALAIN dedea no inaꞌ a nae, “Ubeaꞌ taon de o tao leo naꞌ?” Boe ma inaꞌ a nataa nae, “Te meke a eꞌediꞌ nalaꞌ au! Huu ria na, de au ua ai boaꞌ ria, so te.” ");
INSERT INTO rgu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Basa ria, boe ma MANETUALAIN kutuk meke a nae, “Huu no o nonoi-tataom ia, Au huku o. Neme basa banda fekeꞌ ara mai, adaꞌ noi o riꞌ hapu kutuk leo iaꞌ. Mulai neme besaꞌ ia mai losa o mate, o lodo muniꞌ ara dale ma, ma o malelaꞌ noi mua nai dae a. ");
INSERT INTO rgu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au tao o mo inaꞌ ia, emi mamusu ao maroo. Ma emi dua tititi-nonosi mara boe, leo naꞌ. O tititi-nonosim neuꞌ ko aa neuꞌ lahenda ei tika na. Tehuu ria tititi-nonosin esa neuꞌ ko tutu nasosopuꞌ o laka ma.” ");
INSERT INTO rgu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Basa ria boe ma, Manetualain nafada inaꞌ a nae, “Neuꞌ ko Au tamba fee o susa faiꞌ fo mairu, ma tamba hedis faiꞌ fo o boki a. Tehuu mae leoꞌ na boe, o dale ma bei mahiiꞌ maroo neuꞌ sao ma. Ma ria riꞌ ator o.” ");
INSERT INTO rgu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Basa boe ma, Manetualain nafada touꞌ a nae, “O ta tuka Au pareta ka, tehuu tuka sao ma hihii-nanaun, losaꞌ o mua ai boaꞌ fo Au horo ni a. Huu ria na, de o boe hapu huhukuꞌ. Ma dae a boe hapu huhukuꞌ. Mulai besaꞌ ia losaꞌ o mate, o muste moi-tao foi dae sota maan seli, fo o bisa hapu nanaaꞌ. No moi-tao leo naꞌ, besaꞌ ko o masoda. ");
INSERT INTO rgu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Leo mae o sele-tande rupaꞌ ara, tehuu dae a namomoriꞌ adaꞌ noi ko-kauꞌ ma matemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Basa nana o muste moi-tao sota maan seli, besaꞌ ko dae a fee o mua. O muste moi-tao puse ma titi leoꞌ na losaꞌ mate. Au adu-tao o neme dae a mai. De o mate, o fali dadi dae seluꞌ bali.” ");
INSERT INTO rgu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Basa ria boe ma Adam foi sao na, nade ‘Hawa’ (sosoa na nae, ‘masodaꞌ’), huu fo ria nana basa lahenda fo rasoda a mama na. ");
INSERT INTO rgu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Basa de MANETUALAIN tao papakeꞌ nemeꞌ banda a rou na mai, fo fee dua si pake. ");
INSERT INTO rgu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Boe ma MANETUALAIN dedea nae, “Besaꞌ ia lahenda ia ra bubuluꞌ bea riꞌ malole, ma bea riꞌ tadaluꞌ, sama leoꞌ Ita so. Bosoꞌ losa sira boe raa ai boaꞌ fo fee si rasoda raroo.” ");
INSERT INTO rgu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Basa boe ma, Ana usi heni si reme oka Eden ria mai, de ara leo mamana fekeꞌ reu, fo raue-raosa ela rasoda nemeꞌ dae a buna-boan mai. ");
INSERT INTO rgu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Manetualain usi heni si, boe ma Ana nadenu eilaꞌo-limalope madila nara reme nusatetu-ikutemaꞌ a mai, fo ranea rai okaꞌ ria pooꞌ dulu. Ara hopu tafaꞌ ma lalaeꞌ ana neu-mai, pila loa-loa sama leoꞌ aipilaꞌ. Manetualain nadenu si ena etu enoꞌ fo leo okaꞌ daleꞌ neu, huu fo Ana ta nau lahenda ra etu ai boaꞌ fo fee si rasoda raroo. ");
INSERT INTO rgu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Laiꞌ esa de, Adam neu suku noꞌ saon Hawa. Boe ma inaꞌ a nairu. Basa de boki na ana touꞌ esa. Boe ma ana nae, “Au boki a ana touꞌ esa, nana huu MANETUALAIN tulu-fali neuꞌ au so.” Basa de ana foi anaꞌ ria nade, Kaen (sosoa na nae, ‘kalua henin’). ");
INSERT INTO rgu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Basa boe ma, Hawa boki seluꞌ ana touꞌ esa bali. Boe ma ana foin nade, Habel. Dua si rambau-ina boe ma, Habel foo banda, ma Kaen tao oka-tine. ");
INSERT INTO rgu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Laiꞌ esa boe ma, Kaen neni oka-tinen buna-boan ruma, fee neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel boe neni ria bibi-lopo ina nara ana ulu na. Ana pau bibi-lopo sira, basa de neni katemaꞌ paaꞌ fo malole naan seli, fee neuꞌ Manetualain. MANETUALAIN nita leoꞌ na, dale Na namahoꞌo neuꞌ Habel tutunu-hohotun ria. ");
INSERT INTO rgu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tehuu Ana ta nahiiꞌ Kaen no tutunu-hohotun ria. Boe ma Kaen namanasa naan seli, losaꞌ mata-idun rutuꞌ-rutu. ");
INSERT INTO rgu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Boe ma MANETUALAIN dedea no Kaen nae, “He, Kaen! Ubeaꞌ taon de o mamanasa leoꞌ na? Ubeaꞌ taon de o mata-idum rutuꞌ-rutu leoꞌ na? ");
INSERT INTO rgu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kalu o tao malole, tantu Au boe sipoꞌ o no malole. Tehuu besa-besa! Kalu o tao tadaluꞌ, neuꞌ ko tadaluꞌ ria nala seluꞌ o. De kalu o mahiiꞌ tao tadaluꞌ, malole lenaꞌ tipa henin memaꞌ!” ");
INSERT INTO rgu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Laiꞌ esa de, Kaen leleꞌo Habel nae, “Fadi, ee! Mai fo dua kata lalaꞌo leo okaꞌ teu.” Ara losa naa, kekeneu te Kaen naisa fadi na. ");
INSERT INTO rgu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Boe ma MANETUALAIN natane Kaen nae, “He, Kaen! O fadi ma nai bea?” Kaen nataa nae, “Au ta bubuluꞌ ana nai bea. Ee mae au homu ei na, do?” ");
INSERT INTO rgu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Manetualain dedea nae, “Ubeaꞌ taon de o tao tadaluꞌ leoꞌ na? Bosoꞌ mae o bisa mafuni fadi ma daa na nai dae a, huu fo Au ita katemaꞌ asa so! ");
INSERT INTO rgu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Besaꞌ ia kutuk a laꞌe o so. Huu fai fo o maisa fadi ma, dae a nasamusi na daa na. De besaꞌ ia, dae ria ta neni fee o sodaꞌ soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kalu o tao oka-tine, dae a ta neni fee o buna-boaꞌ hata esa boeꞌ. Mulai nemeꞌ besaꞌ ia mai, o masararala mu-mai sama leoꞌ lahenda kasian fo saka sodaꞌ nai dae-bafoꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaen nadedea laka neuꞌ MANETUALAIN nae, “Awii! Manetualain, ee! Ubeaꞌ taon de Manetualain fee au kutuk mabera-ina ia, losaꞌ au ta bisa lepa a beꞌin soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Huu no Manetualain usi heni au eme mamanaꞌ ia mai so, neuꞌ ko au dooꞌ a eme Manetualain mai. Au asararala nai basa mamanaꞌ ain. Basa de sudi bea a fo raneta ro au, tantu ara raisa au.” ");
INSERT INTO rgu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tehuu MANETUALAIN nataa ni nae, “Ta leo naꞌ fa! Bea naisa o, neuꞌ ko Au huku ni bera lena laiꞌ hitu!” Basa de MANETUALAIN tao tanda neuꞌ Kaen, ela lahenda ra bubuluꞌ, sona ara ta bole raisa ni fa. ");
INSERT INTO rgu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Basa de Kaen laꞌo ela mamanaꞌ ria, de dooꞌ a nemeꞌ MANETUALAIN mai. Ana laꞌo losa mamanaꞌ esa nai oka Eden na pooꞌ dulu. Mamanaꞌ ria nade Nod. Sosoa na nae, ‘masararalaꞌ’. De ana leo neuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Basa ria de Kaen sao, boe ma inaꞌ a nairu. Ana boki ana touꞌ esa, boe ma ara foin nade, Henok. Kaen nafoa koroꞌ esa boe, feen nade Henok, tuka ana na nade na. ");
INSERT INTO rgu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok ana na, riꞌ Irad. Irad ana na, riꞌ Mehuyael. Mehuyael ana na, riꞌ Metusael. Ma Metusael ana na, riꞌ Lamek. ");
INSERT INTO rgu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek saon dua. Esa nade Ada, ma esa nade Sila. ");
INSERT INTO rgu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ana na, nade Yabal. Ria tititi-nonosi nara dadi manafoo. Ara lali-lali, ma leo rai tenda. ");
INSERT INTO rgu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Fadi na, nade Yubal. Yubal tititi-nonosi nara manamamina musik, fuu suling ma ramina pake sanaar. ");
INSERT INTO rgu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek saon Sila boki na Tubal Kaen. Ria tititi-nonosi nara mantutu besi, de ara tao hata rupaꞌ ara reme besi ma riti. Tubal Kaen feto na, nade Naꞌama. ");
INSERT INTO rgu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laiꞌ esa, Lamek dedea koa ao neuꞌ saon dua si mata nara nae, “Emi nenene, ee! Bisinaaꞌ a ana touꞌ esa boa fee au, tehuu au popoꞌo aisa ni. ");
INSERT INTO rgu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Lahenda fo raisa Kaen, ara hapu huhukuꞌ laiꞌ hitu. Tehuu maneniko hapu bea rapeda daleꞌ fo nau balas au, sona ara hapu huhukuꞌ laiꞌ hitu hulu hitu.” ");
INSERT INTO rgu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Boe ma Adam saon Hawa boki seluꞌ ana touꞌ esa bali. Ara foi anaꞌ ria nade, Set (sosoa na nae, ‘loo fee’), huu fo Hawa nae, “Manetualain loo fee au anaꞌ ia so kati Habel, fo Kaen naisa ni so a.” ");
INSERT INTO rgu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Doo-doo boe ma, Set hapu ana touꞌ esa, nade Enos. Tepoꞌ ria, besaꞌ ko lahenda ra mulai doꞌo-tabe neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Tepoꞌ fo Manetualain adu lahenda, Ana taon tuka Ria rupa-lolen, sama leoꞌ ao-ina na. Ana adu naa si, touꞌ no inaꞌ. Ana nanade si nae, “lahenda”, ma Ana fee si ua-naleꞌ. Lahenda masososaꞌ a, nade Adam. Adam tititi-nonosin, nade nara siꞌ iaꞌ: ");
INSERT INTO rgu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam teun natun esa telu hulu, ana hapu ana touꞌ esa, rupa-lolen sama leoꞌ papa na. Boe ma ana foi anaꞌ ria, nade Set. ");
INSERT INTO rgu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Basa ria boe ma, Adam bei nasoda seluꞌ teuꞌ natun falu. Ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ana maten neuꞌ teun natun sio telu hulu. ");
INSERT INTO rgu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tepoꞌ fo Set teun natun esa lima, boe ma ana hapu ana touꞌ esa, nade Enos. ");
INSERT INTO rgu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Basa de Set bei nasoda seluꞌ teuꞌ natun falu ma hitu. Ana hapu seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ana maten neuꞌ teu ni natun sio sanahulu dua. ");
INSERT INTO rgu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tepoꞌ fo Enos teun siohulu, boe ma ana hapu ana touꞌ esa nade, Kenan. ");
INSERT INTO rgu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Basa de Enos bei nasoda seluꞌ teuꞌ natun falu sanahulu lima, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ana maten neuꞌ teu ni natun sio lima. ");
INSERT INTO rgu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tepoꞌ fo Kenan teun hitu hulu, boe ma ana hapu ana touꞌ esa nade, Mahalalel. ");
INSERT INTO rgu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Basa de Kenan bei nasoda seluꞌ teuꞌ natun falu haa hulu, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ana maten neuꞌ teu ni natun sio sanahulu. ");
INSERT INTO rgu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tepoꞌ fo Mahalalel teun nee hulu lima, ana hapu ana touꞌ esa nade, Yared. ");
INSERT INTO rgu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel bei nasoda seluꞌ teuꞌ natun falu telu hulu, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ana maten neuꞌ teu ni natun falu sio hulu lima. ");
INSERT INTO rgu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tepoꞌ fo Yared teun natun esa nee hulu dua, ana hapu ana touꞌ esa nade, Henok. ");
INSERT INTO rgu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Basa de Yared bei nasoda seluꞌ teuꞌ natun falu, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ana maten neuꞌ teu ni natun sio nee hulu dua. ");
INSERT INTO rgu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tepoꞌ fo Henok teun nee hulu lima, ana hapu ana touꞌ esa nade, Metusalak. ");
INSERT INTO rgu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok nasoda daleꞌ esa no Manetualain losaꞌ teuꞌ natun telu bali. Boe ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Ana nasoda daleꞌ esa naroo no Manetualain. Basa de tepoꞌ fo teu ni natun telu nee hulu lima, boe ma mopon huu fo Manetualain soꞌu naꞌae ana. ");
INSERT INTO rgu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalak teun natun esa faluhulu hitu, ana hapu ana touꞌ esa nade, Lamek. ");
INSERT INTO rgu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusalak bei nasoda seluꞌ teuꞌ natun hitu falu hulu dua, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ana maten neuꞌ teu ni natun sio nee hulu sio. ");
INSERT INTO rgu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tepoꞌ fo Lamek teun natun esa falu hulu dua, ana hapu ana touꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek foi anaꞌ ria nade Noh, (sosoa na nae, ‘fee oꞌoe-nanasiꞌ’), nana huu nae, “Anaꞌ ia neuꞌ ko oꞌoe-nanasi tao namahoꞌo ita daleꞌ na neme memela-mamakuꞌ nai dae ia, fo Manetualain kutuk ana so a.” ");
INSERT INTO rgu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Basa ria, Lamek bei nasoda seluꞌ teuꞌ natun lima siohulu lima, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ana maten neuꞌ teu ni natun hitu hitu hulu hitu. ");
INSERT INTO rgu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tepoꞌ fo Noh teun natun lima, ana hapu ana touꞌ telu so, siꞌ Sem, Yafet ma Ham. ");
INSERT INTO rgu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tepoꞌ ria, lahenda ra boe-boe tamba. Ara kofela basa mamanaꞌ nai dae-bafoꞌ a. Ara boki ra ana inaꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Manetualain ana tou nara rita lahenda a ana feto nara napuꞌ mesan. Boe ma ara reu sao ra ana fetoꞌ fo rahiiꞌ asa a. ");
INSERT INTO rgu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Boe ma MANETUALAIN nae, “Au sotaꞌ no lahenda ia ra masoda taohiro-taohari nara so. Au Dula-dale Ka fo riꞌ fee si sodaꞌ a, ta nau fee si rasoda raroo soꞌ. Ara muste mate. De neuꞌ ko ara rasoda losa adaꞌ noi teuꞌ natun esa dua huluꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tepo-leleꞌ ria, ma tepo-leleꞌ mabuiꞌ ara, hapu lahenda parnaka-ina rai dae-bafoꞌ a. Manetualain ana tou nara sao ra lahenda dae-bafoꞌ a ana feto nara, boki ra lahenda kahereꞌ ara, siꞌ parani musu manade nai tutui fai uluꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tepoꞌ ria, MANETUALAIN nita lahenda dae-bafoꞌ a tadalu nara talalu so. Sira dale nara afi raroo adaꞌ noi tadaluꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Boe ma MANETUALAIN nasale dale adu naa si fo leo rai dae-bafoꞌ ia. No enoꞌ ria, riꞌ tao na dale Na hedis naan seli. ");
INSERT INTO rgu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Huu ria na, Ana dedea nae, “No leo naꞌ a, neuꞌ ko Au tao alulutuꞌ lahenda fo riꞌ Au adu aa si rai dae-bafoꞌ ia so. Manupuiꞌ ara ma banda fekeꞌ ara boe, Au tao alulutuꞌ katemaꞌ asa. Huu fo Au asale dale adu a si so.” ");
INSERT INTO rgu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tehuu adaꞌ noi Noh riꞌ tao na MANETUALAIN dale na namahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noh tutui na leo iaꞌ: Ria ana toun telu, siꞌ Sem, Yafet ma Ham. Noh nasoda roo-tetuꞌ, ta tao tadaluꞌ fa. Tepoꞌ ria adaꞌ noi ria riꞌ malole. Ana nasoda naneneaꞌ no Manetualain. ");
INSERT INTO rgu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Tehuu Manetualain nita basa lahenda fekeꞌ ara basan tadaluꞌ. Nai bea-bea oo, lahenda eno masoda nara tadalu raan seli. Manetualain nita adaꞌ noi lahenda dae-bafoꞌ a tadalu nara. ");
INSERT INTO rgu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Basa de Manetualain nafada Noh nae, “Nai mamanaꞌ bea-bea oo, Au ita adaꞌ noi lahenda a tadalu nara. De Au aetuꞌ so ae, Au nau tao alulutuꞌ dae-bafoꞌ ia no basa oe-isin. ");
INSERT INTO rgu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","De leo iaꞌ, Noh! Besaꞌ ia o tao ma ofa bau-inaꞌ esa, neme ai matea a mai. Nai ofaꞌ a daleꞌ, o tao kama dodouꞌ. Basa nanadudu dama neuꞌ ofaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","O tao ofaꞌ a nanaru naa meter natun esa telu hulu telu; loloa na meter duahulu dua; ma dedema na meter sanahulu telu. ");
INSERT INTO rgu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tao puniꞌ neuꞌ ofaꞌ a. Tehuu fee puniꞌ ria doo a baiꞌ neme dindi a lain mai, ee meter seseriꞌ esa. O bati ofaꞌ a neuꞌ tadaꞌ telu. Basa sona tao lelesu esa nesiꞌ poo na. ");
INSERT INTO rgu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mafarereneꞌ matalolole! Neuꞌ ko Au aonda faa ina, fo namate basa-basa masodaꞌ ara rai dae-bafoꞌ ia, losaꞌ ta ela hata esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tehuu Au nau heke hehelu-barataa ia neuꞌ o. Neuꞌ ko o masoꞌ leo ofaꞌ a daleꞌ mu, sama-sama mo sao ma, ma ana-manafeu mara. ");
INSERT INTO rgu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Neme basa banda ra, o muste mu hai ma pasang be esaꞌ, muni si leo ofaꞌ daleꞌ reu, ela ara rasoda sama-sama roo o. Leo-leoꞌ banda aeꞌ, manupuiꞌ ara, ma banda manlodo-manraeꞌ ara, fo ela basa si rasoda. ");
INSERT INTO rgu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","O muste muni nanaa rupaꞌ ara, leo ofaꞌ a daleꞌ neu, soaneuꞌ emi, ma soaneuꞌ banda-manuꞌ ara.” ");
INSERT INTO rgu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noh namanene leoꞌ na, boe ma ana tao tuka Manetualain pareta Na katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Basa ria boe ma, MANETUALAIN dedea no Noh nae, “Au mete basa mamanaꞌ lalaꞌen, tehuu Au hapu adaꞌ noi o riꞌ dale ma roos a. Huu ria na, mo sao-ana mara masoꞌ ofaꞌ daleꞌ meu leo. ");
INSERT INTO rgu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Neme basa banda rupaꞌ fo emi bole mia paa nara, ma bole meni soaneuꞌ Au, sona muni pasang behituꞌ leo ofaꞌ a daleꞌ neu. Neme basa manupui rupaꞌ ara boe, muni pasang behituꞌ. Tehuu neme banda fekeꞌ ara mai, muni adaꞌ noi pasang beesaꞌ. No ria na, banda ma manupuiꞌ sira dadi bini-kee, ela bosoꞌ ramaetu si. ");
INSERT INTO rgu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mafarereneꞌ matalolole! Seluꞌ faiꞌ hitu, Au aꞌonda uda ta pake hahaeꞌ fa losaꞌ leledoꞌ haa hulu, ma hatuꞌ haa hulu. No ria na, Au amate katemaꞌ basa-basan riꞌ Au adu a si so, fo rasoda rai madaꞌ lain.” ");
INSERT INTO rgu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Basa boe ma Noh tao tuka matetuꞌ MANETUALAIN pareta na katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tepoꞌ fo faa inaꞌ a, nana Noh teun natun nee. ");
INSERT INTO rgu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noh no sao na, ma ana-manafeu nara masoꞌ leo ofaꞌ a daleꞌ reu, fo soi ra ao nara remeꞌ faa ina a mai. ");
INSERT INTO rgu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Noh tuka MANETUALAIN pareta na, boe ma ana neni manupui rupaꞌ, ma banda fekeꞌ ara, esaꞌko noꞌ pasang na, leo mae banda fo lahenda bole naa paa na, ma lahenda raluli a. ");
INSERT INTO rgu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Basa faiꞌ hitu, boe ma faa ina sikilapa mai de napoti na dae-bafoꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Naraa no Noh teun natun nee, bulaꞌ dua ma faiꞌ sanahulu hitu, boe ma fa ina a mai. Faiꞌ ria nonooꞌ leo, lalai natahuꞌa, de oe a noi sikilapaꞌa mai. Ma basa oe mataꞌ ara adi si, de oe a nasapura deaꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Boe ma uda a ta pake hahaeꞌ fa hatu-leledon, losaꞌ faiꞌ haa hulu. ");
INSERT INTO rgu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tehuu faiꞌ ria boe, Noh sao na, anan telus, siꞌ Sem, Yafet no Ham, ma manafeu nara, basa si masoꞌ leo ofaꞌ daleꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ara masoꞌ sama-sama roo basa banda ra, riꞌ banda aeꞌ, banda fuiꞌ, manlodo-manraeꞌ, manupuiꞌ, ma banda feke madilaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Basa masodaꞌ ara pasang beesaꞌ, masoꞌ leo ofaꞌ daleꞌ reu sama-sama ro Noh, sama leoꞌ Manetualain pareta ni a. Basa si masoꞌ rala ofaꞌ daleꞌ, boe ma MANETUALAIN koe ofaꞌ a lelesu na. ");
INSERT INTO rgu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Uda bau-inaꞌ a mai naroo, losa faiꞌ haa hulu, ma faa a boe-boe namadema losaꞌ ofaꞌ a bonu. Oe a ae naroo losaꞌ seli basa lete madema ra. ");
INSERT INTO rgu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Oe a ae ta pake hahaeꞌ fa, losaꞌ dedema na meter hitu neme leteꞌ ara poi na mai. ");
INSERT INTO rgu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","No ria na, basa masodaꞌ fo rai madaꞌ lain mate katemaꞌ asa. Riꞌ lahenda, banda aeꞌ, banda fuiꞌ, manlodo-manraeꞌ, ma manupuiꞌ ara. Adaꞌ noi Noh ma basa si rai ofaꞌ a daleꞌ, soi ra ao nara. ");
INSERT INTO rgu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oe a ta reꞌe fa losa faiꞌ natun esa lima hulu. ");
INSERT INTO rgu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tehuu Manetualain ta nafarene heni Noh no basa banda ra raiꞌ ofaꞌ a. Ana fee ani a fufuu nareꞌeꞌ faa ria. ");
INSERT INTO rgu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ana tutuꞌ etu basa oe mataꞌ fo rai dae-bafoꞌ a, ma fee uda a hai. ");
INSERT INTO rgu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Boe ma oe reꞌe naroo. Basa faiꞌ natun esa lima hulu, boe ma oe a ta demaꞌ a soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Naraa no bula kahitu na faiꞌ sanahulu hitu, boe ma ofaꞌ a hara nai lete madema-ina esa, nade Ararat. ");
INSERT INTO rgu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Oe a reꞌe naroo, losa bula kasanahulu na faiꞌ esa, boe ma lete poiꞌ ara mulai nananitaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Basa faiꞌ haa hulu boe ma Noh soi ofaꞌ a jandelan esa. ");
INSERT INTO rgu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Basa de ana poꞌi manupui kaaꞌ esa. Manupuiꞌ ria laa naroo neu-mai, losaꞌ faa a reꞌe matetuꞌ. Ana ta fali seluꞌ leo ofaꞌ a neu soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Boe ma Noh poꞌi seluꞌ kalasi esa, ela neu lalafa sudi oe ria meti ni matetuꞌ so, do beiꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tehuu no oe a bei lifu na katemaꞌ dae-bafoꞌ a, de manupuiꞌ a ta hapu mamana tetenaꞌ fa. Boe ma ana fali leo ofaꞌ a neu. Noh loꞌ lima na neu de sipoꞌ na manupuiꞌ a leo ofaꞌ daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh nahani faiꞌ hitu bali, boe ma ana poꞌi seluꞌ manupuiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ledo leodaeꞌ boe ma, manupuiꞌ a fali leo Noh neu, ma seu neni ai saitun dooꞌ esa. Noh nalelaꞌ nan oe a reꞌe matetuꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ana nahani seluꞌ faiꞌ hitu bali, boe ma poꞌi seluꞌ kalasi a. Tehuu oeꞌ ia, manupuiꞌ a ta fali soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noh teun natun nee esa, laꞌe bula kaesa na faiꞌ esa, oe a reꞌe matetuꞌ so. Boe ma Noh soi ofaꞌ a jendela na, basa de ana mete naleleiꞌ, te dae a namatuu so. ");
INSERT INTO rgu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Losa bula kadua na faiꞌ duahulu hitu, te dae a namatuu matetuꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Basa boe ma, Manetualain dedea no Noh nae, ");
INSERT INTO rgu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Besaꞌ ia emi basa onda memeꞌ ofaꞌ ia lain mai leo. ");
INSERT INTO rgu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Poꞌi banda sira katemaꞌ asa! Riꞌ banda aeꞌ, banda fuiꞌ, banda manlodo-manraeꞌ, ma manupuiꞌ ara. Remeꞌ na elaꞌ ara tamba dodouꞌ, ma rahenu dae-bafoꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Basa de Noh no sao na, ma ana-manafeu nara, basa si kalua remeꞌ ofaꞌ a mai. Basa banda sira boe kalua, esaꞌko noꞌ bubuan. ");
INSERT INTO rgu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Basa de, Noh lutu batu fo tao mamana tutunu-hohotuꞌ soa neuꞌ MANETUALAIN. Neme basa banda fo bole pake si dadi reuꞌ tutunu-hohotuꞌ, Noh hai na beꞌesaꞌ. Basa de ana hala si, fo tunu si reuꞌ mamana tutunu-hohotuꞌ ria lain, ela dadi tanda makasi neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","MANETUALAIN hae na tutunu-hohotuꞌ ria boomeni na, boe ma dale Na namahoꞌo. Ana afi nae, “Mulai nemeꞌ besaꞌ ia, leo mae leoꞌ bea boe Au ta kutuk dae-bafoꞌ ia nana huu lahenda ra tadalun. Leo mae reme aana nara mai, afi adaꞌ noi tadaluꞌ a, tehuu Au ta alulutuꞌ basa hata masodaꞌ ara soꞌ, sama leoꞌ Au tao ia so a. ");
INSERT INTO rgu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Maneniko dae-bafoꞌ a bei hapun, ledo-fai ia ra basan laꞌo raroo, tuka ria atoran a. Riꞌ fai seseleꞌ ma fai ooruꞌ, fai masufuꞌ ma fai hanas, fai fanduꞌ ma fai oe faaꞌ, leledoꞌ ma hatuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Manetualain fee ua-naleꞌ neuꞌ Noh no ana nara, ma dedea nae, “Emi boki-lae fo mamefu seluꞌ dae-bafoꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Neuꞌ ko basa banda fuiꞌ, manupuiꞌ ma ikaꞌ ara, biiꞌ emi. Emi riꞌ muste ator asa. ");
INSERT INTO rgu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Emi bole mia basa banda sira paa nara, sama leoꞌ emi boe bole mia parusa ra buna-boan. Basa ia ra, Au fee si reuꞌ emi. ");
INSERT INTO rgu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Adaꞌ noi emi ta bole mia paaꞌ fo bei no daa na, nana huu banda a sumane na, hapun nai daa na. ");
INSERT INTO rgu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Au adu-tao lahenda tuka Au rupa-lole Ka. Huu ria na, emi ta bole maisa lahenda. Maneniko hapu lahenda, do banda, fo raisa lahenda, muste maisa si boe. Hehelu-barataaꞌ ia nemeꞌ Au mai. ");
INSERT INTO rgu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Emi muste boki-lae fo mamefu seluꞌ dae-bafoꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Manetualain tuti seluꞌ dedea Na nae, ");
INSERT INTO rgu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Besaꞌ ia Au nau heke hehelu-barataa Ka o emi, losa tititi-nonosi mara boe. ");
INSERT INTO rgu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Hehelu-barataaꞌ ia soaneuꞌ basa masodaꞌ ara, riꞌ banda aeꞌ, banda fuiꞌ, ma manupuiꞌ ara. Eetu dedea na, basa-basan fo kalua sama-sama ro emi meme ofaꞌ ria mai. ");
INSERT INTO rgu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Au hehelu-barataa Ka leo iaꞌ: Leo mae leoꞌ bea oo, Au ta fee faa ina mai seluꞌ soꞌ, fo namate basa masodaꞌ ara, ma nalutu heni dae-bafoꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Au tao elus ka nai lalai, fo dadi tanda nafarereneꞌ neuꞌ Au hehelu-barataa ki fo ta manaetu-manabasaꞌ neuꞌ emi, ma basa masodaꞌ ara, ma dae-bafoꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Maneniko hapu oa uda a nai lalai, basa de elus a kalua mai, neuꞌ ko ria nafarereneꞌ Au hehelu-barataa Ki nae: neuꞌ ko faa ina ta nalutuꞌ basa masodaꞌ ara soꞌ. No ria na, Au heke hehelu-barataa Ki neuꞌ emi ma basa masodaꞌ ara. Au hehelu-barataa Ki ta naꞌetu-nabasan fa.” ");
INSERT INTO rgu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh ana nara fo kalua remeꞌ ofaꞌ a mai a, siꞌ Sem, Yafet ma Ham. (Ham nana, Kanaꞌan papa na). ");
INSERT INTO rgu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Basa lahenda rai dae-bafoꞌ a tititi-nonosi nara nana reme Noh anan sira telu mai. ");
INSERT INTO rgu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh nana lahenda maue-maosa. Ria riꞌ tao masososa oka anggor. ");
INSERT INTO rgu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Laiꞌ esa de, ana ninu oe anggor losaꞌ mafuꞌ naan seli. Boe ma ana olu heni bua-loan, basa de suku poiraoꞌ nai mamana leleo na daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham nita papa na poiraoꞌ, boe ma ana nalai deaꞌ neu, de nafada aꞌan Sem no Yafet. ");
INSERT INTO rgu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Basa de dua si hai ra lafa esa, boe ma ara rapela ran fuan neuꞌ aru nara lain. Basa de ara laꞌo rasadedeaꞌ a masoꞌ leo mamana leleoꞌ daleꞌ reu, de ralusen neuꞌ papa na. No ria na, ara ta rita papa na poiraon ria. Basa boe ma deaꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noh mamafu na mulai mopon, besaꞌ ko ria bubuluꞌ nae ana mateꞌa tei-susu na, nonoi-tataon. ");
INSERT INTO rgu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Basa de ana dedea nae, “He! Kanaꞌan papa na! Au kutuk o! Neuꞌ ko o dadi ata soaneuꞌ aꞌam dua si! ");
INSERT INTO rgu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Io-oa MANETUALAIN! Ela leoꞌ bea na, Ana fee ua-naleꞌ neuꞌ Sem! Tehuu ela leoꞌ bea na, Kanaꞌan dadi neuꞌ Sem atan. ");
INSERT INTO rgu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ela leoꞌ bea na, Manetualain namaloa Yafet oe-daen; Ma ria tititi-nonosi nara rasoda mole-dame ro Sem tititi-nonosin. Tehuu ela leoꞌ bea na, Kanaꞌan dadi neuꞌ Yafet atan.” ");
INSERT INTO rgu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mulai nemeꞌ basa faa inaꞌ ria, Noh bei nasoda seluꞌ teuꞌ natun telu lima hulu bali. ");
INSERT INTO rgu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ana maten neuꞌ teun natun sio lima hulu. ");
INSERT INTO rgu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Basa faa inaꞌ a, boe ma Noh ana nara hapu tititi-nonosiꞌ. Siꞌ tititi-nonosiꞌ reme Sem, Yafet ma Ham. ");
INSERT INTO rgu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet tititi-nonosi nara, siꞌ: Gomer, Magog, Madai, Yawan, Tubal, Mesek ma Tiras. Esaꞌko noꞌ dedea nara, leo nara, ma oe-dae nara. Gomer tititi-nonosi nara, siꞌ: Askenas, Rifat ma Togarma. Yawan tititi-nonosi nara, siꞌ: Elisa, Tarsis, lahenda Kitim ara, ma Dodanim fo ara leo rai tasi suuꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham tititi-nonosi nara, siꞌ: Kus, Misraim, Put, ma Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus tititi-nonosi nara, siꞌ: Seba, Hawila, Sabta, Raema ma Sabteka. Raema tititi-nonosi nara, siꞌ: Syeba ma Dedan. ");
INSERT INTO rgu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ana tou na, riꞌ Nimrod. Ria nana malaka parani matati masososa kahereꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ria kahere na nemeꞌ MANETUALAIN mai, losaꞌ ria boe dadi mansopu kahereꞌ naan seli. Huu ria na, lahenda biasa dedea rae, “Ela leoꞌ bea na, o dadi mansopu kahereꞌ, sama leoꞌ Nimrod fo hapu kahere na neme MANETUALAIN mai.” ");
INSERT INTO rgu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Masososa na ria nusa-namon mulai nemeꞌ Babel, Erek Akad ma Kalne. Sira basa si rai Sinear. ");
INSERT INTO rgu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Neme naaꞌ mai, ana pareta Asyur boe. Basa boe ma ana nafoa kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO rgu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen, fo rai Niniwe no Kala talada. Basa sira nana bendar mesan. ");
INSERT INTO rgu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim tititi-nonosi nara, siꞌ lahenda Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO rgu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim, ma Kaftorim. Lahenda Kasluhim, nana lahenda Filistin nara bei-baꞌin. ");
INSERT INTO rgu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan ana ulu na, riꞌ Sidon. Kanaꞌan boe dadi bei-baꞌi neme lahenda Het ara, ");
INSERT INTO rgu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amori, Girgasi, ");
INSERT INTO rgu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi, Arki, Sini, ");
INSERT INTO rgu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari, ma Hamati. Kanaꞌan tititi-nonosin nara kofela rai basa mamanaꞌ ara, ");
INSERT INTO rgu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","losaꞌ sira dae nara ratoo mulai neme Sidon, naroo leo Gerar, losa Gasa. Neme naaꞌ mai leo Sodom, Gomora, Adma ma Seboim, losa nai Lasa. ");
INSERT INTO rgu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sira basa nana Ham tititi-nonosin. Esaꞌko noꞌ dedea nara, leo nara, ma oe-dae nara. ");
INSERT INTO rgu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet aꞌan Sem, dadi neuꞌ lahenda Eber ara bei-bain. ");
INSERT INTO rgu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem tititi-nonosin siꞌ: Elam, Asyur, Arpaksad, Lud ma Aram. ");
INSERT INTO rgu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram tititi-nonosin siꞌ: lahenda Us, Hul, Geter ma Mas. ");
INSERT INTO rgu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad ana na, riꞌ Sela. Sela ana na riꞌ, Eber. ");
INSERT INTO rgu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber hapu ana touꞌ dua. Uluꞌ a foin nade, Pelek, (sosoa na nae, ‘esaꞌko matan’), huu fo tepoꞌ ria lahenda ra kofela nai dae-bafoꞌ a. Pelek fadi na, nade Yoktan. ");
INSERT INTO rgu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan tititi-nonosin siꞌ: Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO rgu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO rgu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO rgu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, ma Yobab. Basa sira nana Yoktan tititi-nonosi nara. ");
INSERT INTO rgu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Sira mamana leleo nara mulai neme Mesa naroo losa Sefar, riꞌ nai pooꞌ dulu fo mamana lete malelepiꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Basa sira nana, Sem tititi-nonosin nara. Esaꞌko noꞌ dedea nara, leo nara, ma oe-dae nara. ");
INSERT INTO rgu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Basa sira nana Noh tititi-nonosin nara, esaꞌko noꞌ leo nara. Basa faa inaꞌ a, sira siꞌ kofela rahenu dae-bafoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Fai a ulu na, basa lahenda nai dae-bafoꞌ a, ara dedea pake dedeaꞌ esaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tepoꞌ fo sira ruma mulai lali dulu reu, ara losa dae malekaꞌ esa nai Sinear, boe ma ara leo reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Basa si rala haraꞌ rae, “Ae! Toranoo kara emin! Mai fo ita tafoa ta kota bau-inaꞌ esa. Ita muste tao batu pilas, basa sona hotun losa namepe. Ma ita tatutuleꞌ batu sira pake ter. Basa nana ita tafoa uma madema esa, fo poilai na losa lalai, ela leoꞌ bea na, ita hapu nadeꞌ. Ela ita dadi teuꞌ lahenda nusa bau-inaꞌ esa, fo bosoꞌ esaꞌko matan.” ");
INSERT INTO rgu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Boe ma MANETUALAIN onda, ela memete sudi kota ria no uma madema fo ara rafoa ni a. ");
INSERT INTO rgu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Basa de Ana dedea nae, “Lahenda ia ra basa si lahenda nusaꞌ esa, ma ara pake dedeaꞌ esa. Hata fo besaꞌ ia ara taon ia, besaꞌ ko sauꞌ masososa. Balaha-binesaꞌ maneniko basa si nanahekeꞌ dadi esaꞌ sama leoꞌ besaꞌ ia, neuꞌ ko ara bisa tao sudi laꞌe ubeaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Malole lenaꞌ Ita onda fo tao fee si esaꞌko dedean, ela ara bosoꞌ esa bubuluꞌ esa dedean bali.” ");
INSERT INTO rgu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Basa boe ma Manetualain onda, de tao taohiro-taohari sira dedean. No ria na, Ana tao na lahenda sira kofela leo basa mamanaꞌ nai dae-bafoꞌ a. Boe ma ara ta rafoa raroo kota ria soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Huu ria na, de ranade kota ria, Babel (hiiꞌ nae sama no dedeaꞌ esa fo sosoa na nae, ‘lakadileꞌ’), nana huu MANETUALAIN tao taohiro-taohari sira dedea na, ma fee si kofela leo basa mamanaꞌ nai dae-bafoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem tititi-nonosin siꞌ iaꞌ. Tepoꞌ fo faa inaꞌ a hai basa teuꞌ dua, naraa laꞌe Sem teun natun esa, ana hapu ana touꞌ esa nade Arpaksad. ");
INSERT INTO rgu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ana bei nasoda seluꞌ teuꞌ natun lima, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad teun telu hulu lima, ana hapu ana touꞌ esa nade Sela. ");
INSERT INTO rgu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksad bei nasoda seluꞌ teuꞌ natun haa telu, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela teun telu hulu, boe ma ana hapu ana touꞌ esa nade, Eber. ");
INSERT INTO rgu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Basa ria boe ma, Sela bei nasoda seluꞌ teuꞌ natun haa telu, ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber teun telu hulu haa, ana hapu ana touꞌ esa nade, Pelek. ");
INSERT INTO rgu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Basa ria boe ma, Eber bei nasoda seluꞌ teuꞌ natun haa telu hulu, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek teun telu hulu, ana hapu ana touꞌ esa nade, Rehu. ");
INSERT INTO rgu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Basa ria boe ma, Pelek bei nasoda seluꞌ teuꞌ natun dua sio, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu teun telu hulu dua, ana hapu ana touꞌ esa nade, Seruk. ");
INSERT INTO rgu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Basa de, Rehu bei nasoda seluꞌ teuꞌ natun dua hitu, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk teun telu hulu, ana hapu ana touꞌ esa, nade Nahor. ");
INSERT INTO rgu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seruk bei nasoda seluꞌ teuꞌ natun dua, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor teun duahulu sio, ana hapu ana touꞌ esa, nade Tera. ");
INSERT INTO rgu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor bei nasoda seluꞌ teuꞌ natun esa sanahulu sio, ma ana hapu tamba seluꞌ ana touꞌ ma ana inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera teun hituhulu lenaꞌ, boe ma hapu ana touꞌ telu, siꞌ Abram, Nahor, ma Haran. ");
INSERT INTO rgu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ia nana Tera tititi-nonosi nara. Tera ana nara siꞌ Abram, Nahor ma Haran. Haran hapu ana touꞌ esa nade Lot. ");
INSERT INTO rgu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mate ni nai dae fua-funi na nade Ur, nai lahenda Kasdim ara daen. Tepoꞌ fo mate ni, nana papan Tera bei nasoda. ");
INSERT INTO rgu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram sao Sarai. Nahor sao Haran ana feto na nade Milka. Haran boe hapu ana touꞌ esa nade Yiska. ");
INSERT INTO rgu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tehuu Sarai tedi ni, de ta bisa boki fa. ");
INSERT INTO rgu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Laiꞌ esa de, Tera no anan Abram, manafeun Sarai, ma upun Lot, ara laꞌo ela koro Ur. Ara nau leo dae Kanaꞌan reu. Tehuu ara losa nusa Haran, boe ma ara leo reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera teun natun dua lima, boe ma maten nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Tepoꞌ ria, MANETUALAIN dedea no Abram so nae, “Abram! O kalua laꞌo ela kileoboboki mara, papa ma uma-loon, ma o koro-tadum. O leo mamanaꞌ esa mu, neuꞌ ko Au atudun neuꞌ o. ");
INSERT INTO rgu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Neuꞌ ko Au fee o ua-naleꞌ. Ma o tititi-nonosi mara neuꞌ ko tamba dodouꞌ, ma ara dadi reuꞌ lahenda nusa kahereꞌ, losaꞌ basa lahenda ra ralelaꞌ o nade ma. Basa te, neuꞌ ko o dadi ua-naleꞌ fee lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Neuꞌ ko Au fee ua-naleꞌ neuꞌ lahenda fo fee o ua-naleꞌ. Tehuu Au fee kutuk neuꞌ lahenda fo fee o kutuk. Nenene matalolole! Huu fo neuꞌ ko basa lahenda nusaꞌ nai dae-bafoꞌ a hapu ua-naleꞌ nana huu o.” ");
INSERT INTO rgu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Tepoꞌ ria, Abram teun hituhulu lima. Ana noo saon Sarai, fadi na ana manen Lot, ma basa hata pusaka nara, no basa lahenda manoi fo ana hapu nai kota Haran. Boe ma Abram asa laꞌo ela Haran, de leo mamanaꞌ fo MANETUALAIN nafadan ni a. De ara laꞌo raroo losa mamanaꞌ esa, nade Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Losa na boe ma, Abram laꞌo nafeo basa dae ria, losaꞌ nananeaꞌ no koroꞌ esa nade Sikem. Basa de ara leo lalai reuꞌ na, raneneaꞌ ai huu inaꞌ esa nai More. Tepoꞌ ria, lahenda Kanaꞌan ara bei leo rai naa. ");
INSERT INTO rgu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nai naa, MANETUALAIN natudu Ao na neuꞌ Abram. Ana nae, “Neuꞌ ko Au fee o tititi-nonosi mara nusaꞌ ia.” Basa de Abram lutu na batu ra, fo pake ni dadi neuꞌ mamana tutunu-hohotu soaneuꞌ MANETUALAIN fo riꞌ Ana natudu Ao na nai naa so. ");
INSERT INTO rgu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Basa ria, boe ma Abram asa lali leo leteꞌ esa nai ona, de ara leo lalai reuꞌ koro Betel no koro Ai talada. Nai naa, ana napadedeiꞌ mamana tutunu-hohotuꞌ esa, ma ana doꞌo-tabe neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Basa ria boe ma, ana lali naleleiꞌ mamanaꞌ, losa dae Negeb nai Kanaꞌan pooꞌ ona. ");
INSERT INTO rgu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Laiꞌ esa de, hapu fai laa-roes inaꞌ nai dae Kanaꞌan. Huu ria na, de Abram asa laꞌo leo dooꞌ a reu bali nai pooꞌ ona, losa dae Masir. Ara leo lalai reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ara sakaꞌ masoꞌ leo dae Masir a reu, Abram nafada saon nae, “Sarai. O napuꞌ mesan. ");
INSERT INTO rgu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tehuu maneniko lahenda Masir a rita o napu ma leoꞌ ia, tantu ara nau raisa au, nana huu au nana o saom. No ria na, ara bisa tonda ra o. ");
INSERT INTO rgu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","De malole lenaꞌ, o mafada si mae au nana o naa ma. No ria na, ara ta raisa au fa, tehuu neuꞌ ko malole roo au, nana huu o.” ");
INSERT INTO rgu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram asa losa Masir so, boe ma lahenda ra rita Sarai napuꞌ mesan. ");
INSERT INTO rgu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mane Masir a pegawe nara rita ni, boe ma ara io inaꞌ ria lole-napun nai maneꞌ a mata na. Boe ma ara roo inaꞌ ria leo maneꞌ a uma na neu. ");
INSERT INTO rgu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","De maneꞌ a malole no Abram, nana huu Sarai. Boe ma maneꞌ a parseen fee Abram banda, leo-leoꞌ bibi-lopo, kedaeꞌ, sapi, keledei, ma onta. Ana parseen fee ni ata touꞌ ma inaꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tehuu no maneꞌ a tonda na lahenda saon leo ria uman daleꞌ neu so, de MANETUALAIN feen no uma isi nara huhuku rupaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Basa boe ma, maneꞌ a naloo na Abram de natane ni nae, “Abram! O tao au leoꞌ bea ia so? Ubeaꞌ taon de o ta mafada mae inaꞌ ia nana o sao ma fa? ");
INSERT INTO rgu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Tehuu o mae inaꞌ ia nana o feto ma. Kura baiꞌ au sao ni! Hai faliꞌ sao ma! Besaꞌ ia mo ni, maheoꞌ memeꞌ au mata ka mai leo!” ");
INSERT INTO rgu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Basa boe ma, maneꞌ a pareta pegawe nara, fo usi heni Abram no sao na, ma basa hata-heto nara remeꞌ nusa na mai. ");
INSERT INTO rgu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Basa ria, boe ma Abram laꞌo ela Masir, de fali leo dae Negeb neu. Ana neu no sao na, ma basa hata posaka nara. Fadi na anan Lot boe tuka si. ");
INSERT INTO rgu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram namasuꞌi naan seli. Banda-manun, ma lilopilas, lilofula ni dodou-inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nemeꞌ Negeb mai ana lali-lali, fo fali seluꞌ leo koro Betel no koro Ai talada neu. Maꞌulu na ana leo nai naa so. ");
INSERT INTO rgu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ma ana napadedeiꞌ mamana tutunu-hohotuꞌ boe. Basa de ana doꞌo-tabe neuꞌ MANETUALAIN nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, fo riꞌ tuka sama-sama no Abram, boe nanuu banda-manuꞌ dodouꞌ, ma lahenda manoi-mantao nara boe dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Tehuu mamanaꞌ ria ta loaꞌ a soaneuꞌ Abram no Lot, ma basa hata-heto nara lalaꞌen, ela leo rabua reuꞌ na. Basa de Abram no Lot manafoo nara mulai rareresiꞌ, nana huu nau-ai doo nai mamanaꞌ ria ta dai sira banda nara raa soꞌ. (Tepoꞌ ria, lahenda Kanaꞌan ro lahenda Feris ara bei leo rai naa boe.) ");
INSERT INTO rgu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Basa boe ma, Abram nafada Lot nae, “Ana ki on! Ita dua ia nana toranooꞌ. Bosoꞌ losa ita dua esa ta malole no esa, ma ita lahenda mana noi nara rahuu raroo. ");
INSERT INTO rgu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Malole lenaꞌ ita dua tasidaꞌ. Mamanaꞌ ia loaꞌ a. De maneniko o here dae nai pooꞌ ii, sona au soa nai pooꞌ ona. Tehuu maneniko o here dae nai pooꞌ ona, sona au soa nai pooꞌ ii.” ");
INSERT INTO rgu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Basa de Lot memete naleleiꞌ. Boe ma ana nita lee Yarden bafaꞌ a oe-oe mesan losa koro Soar. Mamanaꞌ ria dae mandadiꞌ, sama leoꞌ MANETUALAIN oka Na, ma sama leoꞌ dae Masir. (Tepoꞌ ria, Manetualain bei ta nalulutuꞌ Sodom no Gomora. De dae ria bei malole a.) ");
INSERT INTO rgu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","De Lot here na katemaꞌ dae fo nai Yarden bafaꞌ a. Boe ma, dua si rasidaꞌ. Basa de Lot leo pooꞌ dulu neu. ");
INSERT INTO rgu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Tehuu Abram leo nahaniꞌ dae Kanaꞌan. Basa de Lot neu leo nai koroꞌ fo raneneaꞌ kota Sodom, nai Yarden bafaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tehuu lahenda Sodom ara, nana tadalu heta. Ma ara ta nau ramanene neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot no Abram rasidaꞌ so, boe ma MANETUALAIN nafada Abram nae, “Abram! Soba o mete maleleiꞌ basa mamanaꞌ ara, nemeꞌ mamanaꞌ fo o mapadeiꞌ ria a. Mete matalolole, dea-mataꞌ, ii-onaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Basa dae fo o mita si a, neuꞌ ko Au fee o ma tititi-nonosi mara, fo dadi neuꞌ emi hata posaka mara naroo losa dodoo na. ");
INSERT INTO rgu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Neuꞌ ko Au fee o tititi-nonosim ramefu sama leoꞌ soro aeꞌ nai tasi suuꞌ. Losa lahenda ra ta bisa reke rala o tititi-nonosi mara dedesi na. ");
INSERT INTO rgu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Besaꞌ ia o laꞌo rule-feo dae ria tuka loloa-nanarun. Huu fo basa sira neuꞌ ko Au fee si reuꞌ o!” ");
INSERT INTO rgu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Basa ria, boe ma Abram asa rarali, de reu leo seluꞌ nai mamanaꞌ fo raneneaꞌ ai huu inaꞌ ara nai Mamre, naneneaꞌ koro Hebron. Basa de ana lutu mamana tutunu-hohotuꞌ neuꞌ naa, fo doꞌo-tabe neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tepoꞌ ria, maneꞌ haa rabua. Siꞌ Amrafel, mane nusa Sinear. Ariok, mane nusa Elasar. Kedarlaomer, mane nusa Elam. Ma Tideal, mane nusa Goyim. ");
INSERT INTO rgu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Tepoꞌ ria boe, mane fekeꞌ lima rabua. Siꞌ Bera, mane nusa Sodom. Birsa, mane nusa Gomora. Sinab, mane nusa Adema. Semeber, mane nusa Siboim. Ma mane nusa Bela (fo riꞌ nusa Soar). Basa de, mane kahaaꞌ ara ratati soaꞌ mane feke kalimaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mane kalimaꞌ sira rabua ro sira soldadu nara nai Sidim bafaꞌ a (fo besaꞌ ia rae, Tasi Mates). ");
INSERT INTO rgu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Natatiꞌ ria, tute na leo iaꞌ: Maꞌulu na mane kalimaꞌ sira, mane Kedorlaomer pareta si losaꞌ teuꞌ sanahulu dua. Tehuu teu kasanahulu telu na, boe ma ara soaꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Masoꞌ teu kasanahulu haa na, boe ma mane Kedarlaomer no tia-lai mane kateluꞌ sira, roo soldadu nara mai. Boe ma ara ratati raseki nusaꞌ hida. Siꞌ: lahenda Refaim rai nusa Asterot-Karnaim, lahenda Susim rai nusa Ham, lahenda Emim rai nusa Sawe-Kiryatim, ");
INSERT INTO rgu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma lahenda Hori fo rai lete Seir, losa neuꞌ mamana lino-nees El Paran suu na. ");
INSERT INTO rgu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Basa de, ara ratafali leo En Mispat reu (besaꞌ ia nade Kades). Basa boe ma ara ralulutuꞌ lahenda Amalek ara nusa na, ma lahenda Amori, fo leo rai nusa Haseson-Tamar. ");
INSERT INTO rgu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Basa ria, boe ma mane kalimaꞌ sira ator soldadu nara nai Sidim bafaꞌ a, de ara ratati soaꞌ mane kahaaꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nai bafaꞌ ria, hapu dano ter dodouꞌ. Ara ratati a, nana mane Sodom no Gomora roo basa soldadu nara ralai heni ao nara. Sira ruma tuda rala dano ter daleꞌ. Ma ruma ralai leo leteꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","De mane kahaaꞌ fo raseki a, ara ralea reni basa hata-heto, ma nanaaꞌ nemeꞌ Sodom no Gomora mai. Basa boe ma ara mulai fali reus. ");
INSERT INTO rgu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tehuu Abram anan Lot leo nai Sodom. Basa de, mane kahaaꞌ siraꞌ hopu roo Lot asa, ma ralea reni basa hata-heto nara. ");
INSERT INTO rgu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tehuu lahenda esa nalai na aon. Boe ma ana nalai neu tui Abram, lahenda Ibrani a. Tepoꞌ ria hapu lahenda Amori esa nade Mamre. Abram leo naneneaꞌ nai Mamre ai huu bau-ina nara. Mamre toranoo nara siꞌ Eskol ma Aner. Sira nana, dadi reuꞌ Abram partei na. ");
INSERT INTO rgu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram namanene nae lahenda ra hopu ro fadi na ana na so, boe ma ana nabua na lahenda mananoin fo ratati ralelaꞌ a. Sira basa, lahenda natun telu sanahulu falu. Basa de ara reu usi mane kahaaꞌ sira losa doo inaꞌ a nai koro Dan pooꞌ ii. ");
INSERT INTO rgu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nai naa, Abram bati lahenda nara reuꞌ bubuaꞌ hida. Nahatu, boe ma ara reu suu lahenda sira. Tehuu ruma ralai. Basa de, Abram asa usi raroo si, losa koro Hoba nai kota Damsik pooꞌ ii. ");
INSERT INTO rgu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Basa de Abram hapu faliꞌ Lot no lahenda nara, ro basa hata-heto nara, ma lahenda fekeꞌ ara boe. ");
INSERT INTO rgu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram naseki mane kahaaꞌ sira, de ana fali. Boe ma mane Sodom mai soruꞌ Abram nai Sawe bafaꞌ a (fo lahenda biasa hule rae, Maneꞌ Bafaꞌ a). ");
INSERT INTO rgu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tepoꞌ ria, Melkisedek dadi mane nai kota Salem. Ma ria boe malaka agama nemeꞌ Manetualain Madema Nan Seli. Ana mai fo neni fee Abram roti no oe anggor. ");
INSERT INTO rgu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Basa boe ma ana dedea fee Abram ua-naleꞌ nae, “Ela leoꞌ bea na, Manetualain Madema Nan Seli, fo adu na lalai ma dabafoꞌ a, fee ua-naleꞌ neuꞌ o. Io-oa Manetualain, fo riꞌ tao na o maseki musu mara.” Basa ria boe ma, Abram bati fee Melkisedek babatiꞌ esa neme babatiꞌ sanahulu, nemeꞌ basa hata fo ralea faliꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Basa ria boe ma, mane Sodom naloloe aon neuꞌ Abram nae, “Papa Abram. Basa hata-heto fo papa ka malea faliꞌ reme au musu kara mai a, ela leoꞌ bea na papa ka soa katemaꞌ asa. Tehuu au hule faliꞌ adaꞌ noi lahenda kara.” ");
INSERT INTO rgu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tehuu Abram nataa nae, “Au soo-supu nai Manetualain Madema Nan Seli mata na, fo manaadu lalai ma dae-bafoꞌ a, ");
INSERT INTO rgu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ae, neme basa o hata-heto mara mai, au ta hai esa boeꞌ, leo mae abadoo peda anaꞌ esa boe, au ta hain fa. No ria na, o ta bisa mafada mae, ‘Abram namasuꞌi, nana huu au.’ ");
INSERT INTO rgu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Au ta hule hata-hata esa boeꞌ. Adaꞌ noi hata bea, fo au lahenda kara pake heni si, sona taon neuꞌ basa so. Ma nemeꞌ na ela au tia-lai ki lahenda kateluꞌ ia ra, Aner, Eskol ma Mamre, hai reni sira nuu babati nara.” ");
INSERT INTO rgu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Basa ria boe ma, MANETUALAIN natudu Ao Na neuꞌ Abram. Ana nae, “Abram! O bosoꞌ bii. Huu fo Au riꞌ anea-asalaꞌe o nemeꞌ musu a mai. Ma Au fee o ua-nale bau-inaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tehuu Abram nae, “Oo Manetualain! Leo mae Manetualain nau fee au hata dodouꞌ boe, ta nanuu sosoa-raraaꞌ hata esa boeꞌ. Huu fo au ta anuu anaꞌ ela fee au tititi-nonosiꞌ. De nau hapu posakaꞌ dodou-inaꞌ, fo tao ubeaꞌ? Mae tao leoꞌ bea boe, au ata ki Eliasar neme Damsik mai, riꞌ hapu katemaꞌ asa.” ");
INSERT INTO rgu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tehuu MANETUALAIN nataa nae, “Ta leo naaꞌ fa! Huu fo o ana boki ma riꞌ neuꞌ ko hapu basa posakaꞌ sira, ta atam ria fa.” ");
INSERT INTO rgu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Boe ma Ana noo Abram deaꞌ neu, basa de Ana nae, “Besaꞌ ia o mete leo lalai mu. Soba o mete ruuꞌ sira. O bisa reke mala si? O tititi-nonosi mara neuꞌ ko dedesi nara sama leoꞌ ruuꞌ sira!” ");
INSERT INTO rgu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Boe ma Abram sipoꞌ na MANETUALAIN dedean ria. Basa de MANETUALAIN sipo ana neuꞌ lahenda dale roos, nana huu Abram namahere Ni. ");
INSERT INTO rgu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Basa ria boe ma, MANETUALAIN dedea naroo bali, nae, “Au ia, nana Manetualain. Au riꞌ fee o kalua so memeꞌ koro Ur nai lahenda Kasdim ara dae na. Ma Au riꞌ fee dae ia fo dadi neuꞌ o posaka ma.” ");
INSERT INTO rgu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tehuu Abram natane nae, “Leo beaꞌ MANETUALAIN? Tao leoꞌ bea fo au bisa bubuluꞌ ae, neuꞌ ko dae ia dadi neuꞌ au posaka ka?” ");
INSERT INTO rgu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Manetualain nataa nae, “Leo iaꞌ! Mai ita heke hehelu-barataaꞌ esa neuꞌ Au dedea bisinaaꞌ ka. Besaꞌ ia o mu fo muni fee Au banda: sapi tenaꞌ esa, kedae tenaꞌ esa, ma bibi-lopo mane anaꞌ esa. Basa sira muste fadi teluꞌ. Basa sona o muni seluꞌ manupui kateu esa, ma manupui kalasi esa.” ");
INSERT INTO rgu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Boe ma Abram neu nala basa banda sira. Basa de ana seseri bati dua sapi a, kedaeꞌ a, ma bibi-lopo a. Boe ma ana ator bati dua paaꞌ sira reuꞌ dae a, fee si rasasare mataꞌ, dadi reuꞌ baris dua. Tehuu ana ta seseri manupuiꞌ sira fa. ");
INSERT INTO rgu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Basa de manupui manaa ao-paaꞌ mates ara, mai fo nau raa paꞌ sira. Tehuu Abram nasalaa heni si. ");
INSERT INTO rgu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ledo a tena, boe ma Abram suku namanee. Ana nalamei nae maꞌiu inaꞌ a napoti nan, losaꞌ bii naan seli. ");
INSERT INTO rgu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Basa de Manetualain nafada ni nae, “Abram! Neuꞌ ko o masoda losaꞌ mamalasi man seliꞌ, ma o mate no mole-dame, ma ratoi o no malole. Tehuu o tititi-nonosi mara neuꞌ ko reu tai nai lahenda fekeꞌ ara nusa-namon. Neuꞌ ko lahenda nusaꞌ ria tao si dadi ata, ese-rumu tao doidoso si losa teuꞌ natun haa. Tehuu neuꞌ ko Au huku lahenda nusaꞌ ria. Basa te Au o faliꞌ tititi-nonosi mara kalua reme naaꞌ mai, ma reni hata posakaꞌ dodou-inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Neuꞌ ko Au ator fo o tititi-nonosi tada kalima a, fali seluꞌ leo iaꞌ mai. Besaꞌ ia lahenda Amori ra leo rai dae ia lain. Lahenda ia ra tadaluꞌ, tehuu bei ta beraꞌ a fa. Upu-ana mara fali leo iaꞌ mai, sona Au nau pake si, fo huku alulutuꞌ lahenda Amori ra. Huu fo tepoꞌ ria sira tadalu nara seli uukuꞌ a so.” ");
INSERT INTO rgu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Fatilada, boe ma kekeneu te hapu rao dae pilas esa namasu, ma obor esa pila, laꞌo resiꞌ paa baris kaduaꞌ sira talada. ");
INSERT INTO rgu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Faiꞌ ria boe, MANETUALAIN heke hehelu-barataaꞌ no Abram. Ana nafada nae, “Au helu, neuꞌ ko Au fee nusaꞌ ia neuꞌ o tititi-nonosim, neme lee Masir losa lee Efrat, ");
INSERT INTO rgu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ma lahenda Keni, Kenas, Kadmon, ");
INSERT INTO rgu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het, Feris, Refaim, ");
INSERT INTO rgu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaꞌan, Girgasi ma Yebus dae nara.” ");
INSERT INTO rgu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Tepoꞌ ria, Abram fali neme Masir mai, de leo teuꞌ sanahulu nai Kanaꞌan so. Sao ni Sarai bei ta hapu anaꞌ fa. Sarai nanuu ata inaꞌ esa, lahenda Masir, nade Hagar. Laiꞌ esa boe ma, Sarai dedea no Abram nae, “Papa! MANETUALAIN ta fee au boki soꞌ. Malole lenaꞌ papa ka mu suku moꞌ au ata ki Hagar, ela ana boki fee au.” Boe ma Abram tuka sao na nafada na. Basa de Sarai fee Hagar leo Abram neu fo dadi sao muri na. ");
INSERT INTO rgu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Basa de, Abram neu suku noꞌ Hagar, boe ma inaꞌ ria nairu. Tehuu Hagar bubuluꞌ nae ana nairu so, boe ma ana koa ao, de ta hika-hadaꞌ neuꞌ Sarai. ");
INSERT INTO rgu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Boe ma Sarai dedea no Abram nae, “Au riꞌ fee ata ria fo dadi neuꞌ sao muri ma. Tehuu inaꞌ ria bubuluꞌ nae nairu, boe ma ana ta hika-hadaꞌ au soꞌ. Basa ia ra nana o salam. Nemeꞌ na fo MANETUALAIN naetuꞌ ita dua dedea na. Besaꞌ ko o bubuluꞌ!” ");
INSERT INTO rgu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram nataa nae, “Leo iaꞌ! O ia, nana au sao ulu ka. Tehuu ria adaꞌ noi sao muriꞌ! De o riꞌ pareta ni. De o mae tao ni leoꞌ bea, nemeꞌ o mai!” Boe ma Sarai piruꞌ-piru no Hagar, losaꞌ ana nalai heni aon. ");
INSERT INTO rgu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar nalai losa nai manana lino-nees. Boe ma MANETUALAIN eilaꞌo-limalopen esa neme nusatetu-ikutemaꞌ a mai, naneta noo ni naneneaꞌ oe mataꞌ nai enoꞌ fo leo Sur neu. ");
INSERT INTO rgu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Basa de ana nae, “Ae! Hagar, Sarai atan! Ubeaꞌ taon de o nai ia? O meme beaꞌ mai, ma sakaꞌ leo beaꞌ mu?” Hagar nataa nae, “Au alai ela au ina mane ka!” ");
INSERT INTO rgu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Boe ma MANETUALAIN eilaꞌo-limalopen oꞌoe ni nae, “Leo iaꞌ! Malole lenaꞌ o fali seluꞌ leo ina mane ma mu. Ana tao o leoꞌ bea boe, moi sipo-sipoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","O bosoꞌ bii. Neuꞌ ko au tao a o tititi-nonosi mara ramefu, losaꞌ lahenda ta bisa reke rala si. ");
INSERT INTO rgu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Besaꞌ ia o mairu so. Ta dooꞌ a soꞌ, te o boki ma ana touꞌ esa. O muste foin nade, Ismael, (hiiꞌ nae sama leoꞌ dedea fekeꞌ esa sosoa na nae, ‘Manetualain namanene’), nana huu MANETUALAIN namanene o dodola ma so. ");
INSERT INTO rgu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tehuu anaꞌ ria nambau-ina mai, ana nasoda dooꞌ a neme toranoo nara mai. Huu fo ria sama leoꞌ dara fuiꞌ, de ta namanene nalelaꞌ pareta. Ana soaꞌ sudi bea a. Ma basa lahenda ra soaꞌ seluꞌ ana.” ");
INSERT INTO rgu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar namanene basa dedeaꞌ sira, boe ma ana dodoo neuꞌ dale na nae, “Au ita MANETUALAIN so, fo riꞌ Ana relu-natanae au.” Basa de, ana mulai naloo neuꞌ Manetualain pake nadeꞌ, “Ramatuaꞌ fo riꞌ nafaduli au.” ");
INSERT INTO rgu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huu ria na, de lahenda ra ranade oe mataꞌ ria rae, Beer Lahai Roi, sosoa na nae, “Oe mataꞌ nemeꞌ Ria fo masodaꞌ, riꞌ nafaduli au.” Oe mataꞌ ria mamana na, nai koro Kades no Beret talada. Oe mataꞌ ria bei nai naa, losaꞌ besaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Basa ria boe ma, Hagar fali neun. Boe ma boki na ana touꞌ esa. Abram foin nade, Ismael. ");
INSERT INTO rgu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar boki Ismael nana, Abram teun faluhulu nee so. ");
INSERT INTO rgu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram teun siohulu sio, boe ma MANETUALAIN mai natudu Ao Na neuꞌ ana. Ana dedea nae, “Au ia Manetualain Manakuasa Nan Seli. O muste tuka maroo Au hihii-nanau ka, ma masoda no roo-tetuꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au nau heke hehelu-barataaꞌ neuꞌ o, fo ela o tititi-nonosim ramefu.” ");
INSERT INTO rgu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram namanene leꞌo naa, boe ma sundaꞌ undulaka na, ma naloe laka na losa dae a. Boe ma Manetualain dedea naroo nae, ");
INSERT INTO rgu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Au heke hehelu-barataaꞌ neuꞌ o, leo iaꞌ: neuꞌ ko o dadi mu lahenda nai nusaꞌ dodouꞌ bei-baꞌin. Huu ria na, de o ta nade Abram soꞌ (sosoa na nae, ‘amaꞌ fo nade na bau-inaꞌ’), tehuu nade Abraham (sosoa na nae, ‘lahenda nai nusaꞌ dodouꞌ bei-baꞌin’). ");
INSERT INTO rgu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Neuꞌ ko Au tao a tititi-nonosim ramefu. Ma neuꞌ ko Au boe afoa lahenda reme sira mai nai nusaꞌ dodouꞌ. Ma soꞌu maneꞌ dodouꞌ reme tititi-nonosiꞌ sira mai. ");
INSERT INTO rgu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au homu aroo hehelu-barataa ka neuꞌ o ma tititi-nonosim. Hehelu-barataaꞌ ia ta etu-basan fa, huu fo Au ia nana, o mo tititi-nonosim Manetualain ma. ");
INSERT INTO rgu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dae Kanaꞌan ia neuꞌ ko Au fee katemaꞌ ana neuꞌ o mo tititi-nonosim. Besaꞌ ia o adaꞌ noi leo lalai maiꞌ ia. Tehuu neuꞌ ko, o tititi-nonosim ranuu dae Kanaꞌan ia losaꞌ dodoo na neu. Ma Au dadi uꞌ sira Manetualain na. ");
INSERT INTO rgu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Tehuu o mo tititi-nonosim boe muste homu maroo hehelu-barataaꞌ ia, no dale katema tua. Basa touꞌ ara muste sunat. ");
INSERT INTO rgu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Besaꞌ ia, basa touꞌ ara mulai nemeꞌ faiꞌ falu mai, muste sunat. O kileoboboki mara, ma lahenda manoi-mantao mara, ma ata fo o asa nemeꞌ nusa fekeꞌ a mai, basan muste sunat. Sunat ia nanadadi tanda neuꞌ ita dua hehelun, fo dite nahere neuꞌ emi ao-ina mara. ");
INSERT INTO rgu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Touꞌ bea fo ta sunat, ta hapu babatiꞌ nai Au hehelu-barataa ka, ma ta bisa masoꞌ dadi neuꞌ Au lahenda kara.” ");
INSERT INTO rgu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Basa ria boe ma, Manetualain dedea naroo nae, “Mulai besaꞌ ia, o bosoꞌ boe maloo sao ma mae Sarai, tehuu maloon mae Sara. ");
INSERT INTO rgu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Neuꞌ ko Au fee ua-naleꞌ dodouꞌ neuꞌ Sara, ela ana boki fee o ana touꞌ esa. Tebe! Neuꞌ ko Sara dadi neuꞌ lahenda nai nusaꞌ dodouꞌ bei-baꞌin. Ma neuꞌ ko Au soꞌu a maneꞌ dodouꞌ reme ria tititi-nonosin mai.” ");
INSERT INTO rgu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham namanene leoꞌ naa, boe ma sundaꞌ undulaka na, ma naloe laka na losa dae a. Tehuu ana hiꞌa daleꞌ a. Ana afi nae, “Tou lasi kumulouꞌ teuꞌ natun esa leoꞌ au ia, bei hapu anaꞌ bali? Ma Sara namalasi kokoo, teun siohulu so. Hapu nai bea bisa boki?” ");
INSERT INTO rgu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Boe ma ana nafada Manetualain nae, “Manetualain. Nemeꞌ na ela Ismael riꞌ hapu au hata posaka kara boe, ta hata-hata fa.” ");
INSERT INTO rgu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tehuu Manetualain nataan nae, “Taꞌa! Huu fo neuꞌ ko o saom Sara boki ana touꞌ esa. O foin nade, Isak. Au hehelu-barataa ka neuꞌ ko onda neuꞌ ana no ria tititi-nonosin, losa dodoo na neu. ");
INSERT INTO rgu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tehuu Au boe amanene hata fo o hule fee Ismael. Huu ria na, Au boe fee ni ua-naleꞌ, ma Au tao a tititi-nonosin ramefu. Neuꞌ ko mane leo sanahulu dua dadi remeꞌ ria tititi-nonosin mai. Ma ria tititi-nonosin neuꞌ ko dadi lahenda nusa kahereꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Leo mae Au tao leoꞌ na neuꞌ Ismael, tehuu Au hehelu-barataa ka nanahekeꞌ noi neuꞌ o anam Isak. Teu manamaiꞌ ia, ee leoꞌ ledo-fai ia, te Sara boki nan so.” ");
INSERT INTO rgu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Dedea basa leoꞌ na, boe ma Manetualain laꞌo ela Abraham mesaꞌ ana neuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Faiꞌ ria boe, Abraham tuka memaꞌ Manetualain pareta Na, boe ma ana sunat. Basa de ana sunat Ismael no basa touꞌ fo rai uman daleꞌ. Ana sunat ata touꞌ ara boe. Tepoꞌ ria, Abraham teun siohulu sio so, ma Ismael teun sanahulu telu. ");
INSERT INTO rgu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraham leo naneneaꞌ nai ai huu inaꞌ ara nai Mamre. MANETUALAIN mai natudu Ao na neuꞌ ana nai naa. Tutui na leo iaꞌ: Faiꞌ ria makahana na seli, de Abraham natuuꞌ hai ani nai mamana leleo na matan. ");
INSERT INTO rgu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham botiꞌ laka na, boe ma nita lahenda telu rapadeiꞌ rai naa. Boe ma nalale nalai neu sipoꞌ asa. Ana sundaꞌ undulaka na, ");
INSERT INTO rgu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","basa de nae, “Papa kasa! Kalo bisa, sona papa kasa tuli au mamana leleo ka dei. Leo mae minu adaꞌ noi oe hihiiꞌ boe, malole. ");
INSERT INTO rgu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Papa kasa hahae maiꞌ ai laoꞌ. Neuꞌ ko anaꞌ ara reni oe, fo safe ei mara. ");
INSERT INTO rgu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Au sadia nanaa-nininuꞌ fee papa kasa, fo ela hapu mapii-baraꞌaiꞌ baiꞌ, besaꞌ ko papa kasa laꞌo maroo. Huu fo au amahoꞌo nana alalau papa kasa.” Boe ma ara rataa rae, “Ria malole a. Makasi dodouꞌ. Ami tuli.” ");
INSERT INTO rgu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Basa de Abraham nalai leo mamana lelelo na neuꞌ, ma nafada Sara nae, “Malale! Hai ma uuꞌ malole naan seli, saku esa fo tao roti.” ");
INSERT INTO rgu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Boe ma ana nalai leo sapi nara neu, de heke na sapi ana mapetaꞌ esa. Ana nadenu ata nara tati sapi ria, ma tunu-nasu paa na. ");
INSERT INTO rgu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Basa ria, boe ma Abraham neu hai na sosoeꞌ, sosoe isiꞌ, ma paaꞌ fo besaꞌ ko tunu-nasu si a, de ana neni fee fui ra. Ara raa-rinu, ma Abraham napadei nai ai a huu na, de nalalau si. ");
INSERT INTO rgu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Basa boe ma ara ratane ni rae, “Abraham! O saom Sara, nai bea?” Ana nataa nae, “Nai mamana leleoꞌ daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Boe ma neme sira telu mai, esa dedea nae, “Bate manafaliꞌ, te Au mai seluꞌ. Faiꞌ ria, o saom Sara boki na ana touꞌ esa so.” Ara dedea rae leoꞌ na, te Sara namanene nemeꞌ lelesu a deaꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Tepoꞌ ria, Abraham no Sara ramalasi raan seliꞌ so, ma Sara boe ta namahedi ina soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara namanene si dedea rae leoꞌ na, boe ma ana hiꞌa daleꞌ a. Ana afi nae, “Awe! Au amalasi kokoo leoꞌ ia so, ma au sao ka boe namalasi so. Hapu nai bea ami dadi sama leoꞌ manasao bebeuꞌ, fo saka anaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Boe ma MANETUALAIN natane Abraham nae, “Ubeaꞌ taon de Sara hiꞌa? Ria afi nae hata fo Au dedea ia a ta bisa dadi, nana huu ria namalasi so, do? ");
INSERT INTO rgu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au ia, MANETUALAIN! Ta hapu hata esa fo Au ta bisa taon fa! Mafarene matalolole, e! Manafaliꞌ Au fali seluꞌ mai, Sara boki na ana touꞌ esa so.” ");
INSERT INTO rgu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara namanene leoꞌ na, boe ma ana biiꞌ. Basa de ana nalena nae, “Au ta hiꞌa fa, a.” Tehuu Manetualain nataan nae, “Tebe bisinaaꞌ a o hiꞌa, a!” ");
INSERT INTO rgu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Basa boe ma fui kateluꞌ sira sakaꞌ leo kota Sodom reu. De Abraham neu nafuli si losa eno taladaꞌ. Neme naaꞌ mai, ara bisa lalanda rita kota Sodom. ");
INSERT INTO rgu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Boe ma MANETUALAIN ootoꞌ nai dale na nae, “Malole lenaꞌ, Au tui Abraham ae, Au nau alulutuꞌ kota Sodom. ");
INSERT INTO rgu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Huu fo ria tititi-nonosin neuꞌ ko ramefu, ma dadi lahenda nusa kahereꞌ. Ma ria boe dadi ua-naleꞌ fee basa lahenda nusaꞌ nai dae-bafoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Au here an so, fo nanori ana nara ma lahenda fekeꞌ ara, ela tuka raroo MANETUALAIN eno-dalan, ela rasoda no dale roo-tetuꞌ. Maneniko ara tao leo naꞌ, sona Au atetu hehelu-barataa ki neuꞌ Abraham.” ");
INSERT INTO rgu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Basa de MANETUALAIN nafada Abraham nae, “Leo iaꞌ! Au amanene lahenda dodouꞌ ramumuu laꞌeneuꞌ lahenda rai kota Sodom ma Gomora so. Sira tadalu nara, lena uukuꞌ a so. ");
INSERT INTO rgu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Huu ria na, de Au onda fo parisaꞌ mata ki basa-basan fo Au amanene so a, tebe do taꞌa. Maneniko taꞌa, neuꞌ ko Au muste bubuluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","MANETUALAIN bei dedea no Abraham, boe ma fui kaduaꞌ sira laꞌo raroo leo kota Sodom reu. ");
INSERT INTO rgu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham naneneaꞌ aon leo Manetualain neu, basa de ana ooe-leleꞌo nae, “Leoꞌ bea? Papa ka nau malulutuꞌ belaꞌ lahenda malole a ma lahenda tadaluꞌ a, do? ");
INSERT INTO rgu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kalu hapu lahenda malole lima hulu rai kota ria daleꞌ, Papa ka bei nau malulutuꞌ kota ria? ");
INSERT INTO rgu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Papa ka bosoꞌ tao leo naꞌ! Bosoꞌ losa lahenda malole sira boe mate, nana huu Papa ka nau malulutuꞌ lahenda tadaluꞌ ara. Papa ka riꞌ dadi Manaꞌee dedeaꞌ nai lalai ma dae-bafoꞌ a. Papa ka bubuluꞌ ria nana ta bei beberaꞌ fa.” ");
INSERT INTO rgu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Boe ma MANETUALAIN nataa nae, “Maneniko Au hapu lahenda malole lima hulu nai kota Sodom, Au ta huku kota ria, nana huu sira.” ");
INSERT INTO rgu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Boe ma Abraham dedea bali, nae, “Papa, hule ampon, kalu au bisa dedea seluꞌ baiꞌ. Au ia, adaꞌ noi lahenda pakanaꞌ, de ta alelaꞌ hata-hata esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Uniꞌ ko leo lahenda malole ta losa lima hulu fa, tehuu hapu adaꞌ noi haa hulu limaꞌ a, leoꞌ bea? Hai heni noi limaꞌ a, Papa ka bei nau malulutuꞌ kota ria, do?” Manetualain nataa nae, “Maneniko Au hapu lahenda malole haa hulu lima rai naa, Au ta alulutuꞌ kota ria fa.” ");
INSERT INTO rgu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham oꞌoe-leleꞌo bali, nae, “Maneniko hapu adaꞌ noi haahuluꞌ a, leoꞌ bea Papa?” Manetualain nataa nae, “Maneniko Au hapu haa hulu, Au ta huku si fa.” ");
INSERT INTO rgu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham oꞌoe-leleꞌo naroo bali, nae, “Papa! Bosoꞌ mamanasaꞌ, tehuu uniꞌ ko leo lahenda malole adaꞌ noi teluhuluꞌ a, leoꞌ bea?” Manetualain nataa nae, “Maneniko Au hapu telu hulu, Au ta huku si fa.” ");
INSERT INTO rgu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Basa boe ma Abraham naloloe bali, nae, “Papa bosoꞌ mamanasaꞌ kalu au atane seluꞌ baiꞌ. Maneniko hapu adaꞌ noi lahenda duahulu, leoꞌ bea?” Manetualain nataa bali, nae, “Hapu duahulu, Au ta alulutuꞌ kota ria.” ");
INSERT INTO rgu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Boe ma Abraham nateꞌe dedea na nae, “Papa! Au dedea seluꞌ laꞌi esa, ma bosoꞌ mamanasaꞌ mo au, o! Leoꞌ bea kalu hapu adaꞌ noi lahenda malole sanahuluꞌ a?” Manetualain nataa nae, “Maneniko Au hapu lahenda malole sanahulu rai naa, Au ta alulutuꞌ kota ria fa.” ");
INSERT INTO rgu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ara dedea rao nara basa leoꞌ na, MANETUALAIN laꞌo naroo. Boe ma Abraham fali neun. ");
INSERT INTO rgu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Manetualain bei dedea no Abraham, te eilaꞌo-limalope Ni dua si raroo leo kota Sodom a reu. Ara losa naa, te ledo a sakaꞌ tena so. Fai ria Lot bei natuuꞌ nai kota a lelesu bafa na. Nita lahenda sira dua, boe ma ana neu sipoꞌ asa. Ana sundaꞌ undulaka na ma natele neuꞌ sira matan. ");
INSERT INTO rgu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Basa de ana dedea nae, “Papa kasa! Mai fo tuli lalai nai au uma ka dei. Ela papa kasa safe ei mara, basa sona suku mo ami. Balaha, balahaa ana na besaꞌ ko papa kasa laꞌo maroo.” Tehuu dua si rataa rae, “Makasi dodouꞌ. Tehuu bosoꞌ masosotaꞌ aom! Nemeꞌ na ela ami suku meuꞌ kota a moo na.” ");
INSERT INTO rgu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tehuu Lot oꞌoe-leleꞌo naroo si, losaꞌ ara nau suku reuꞌ uma na. Boe ma Lot asa tunu roti ma sadia nanaa-nininuꞌ, de ara raa-rinu belaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Fui sira bei ta reu suku boeꞌ, te Sodom tou nara aana bau-inaꞌ, basa si mai de eo ra Lot uma na. ");
INSERT INTO rgu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ara rasapapara neuꞌ Lot rae, “He, Lot! Bisinaaꞌ a tou kaduaꞌ sira rai bea? Kalua si leo deaꞌ mai, huu fo ami nau saꞌe si!” ");
INSERT INTO rgu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Boe ma Lot deaꞌ neu, basa de ena lelesu a. ");
INSERT INTO rgu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ana dedea nae, “Toranoo kara! Emi bosoꞌ tao tadalu leo naꞌ neuꞌ au fui kara. ");
INSERT INTO rgu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Emi soba nenene, e? Au anuu ana fetoꞌ dua. Ara bei ao tema. Ela au fee dua si reuꞌ emi. Emi mae tao si leoꞌ bea oo, neme emi mai. Tehuu emi bosoꞌ tatao au fui kara. Huu fo tuka ita hada na, au muste anea atalolole si.” ");
INSERT INTO rgu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tehuu lahenda Sodom ara bobou helaꞌ rae, “O bosoꞌ sosoroꞌ nuu ma! O adaꞌ noi lahenda manamai nai ia! O lahenda dea, de ta manuu hak fo ator ami. Malole lenaꞌ o heoꞌ memeꞌ iaꞌ mai. Kalu taꞌa, sona ami tao o bera na lena neme lahenda sira dua mai!” Basa de ara tipa heni Lot, boe ma ara tafaruu reu belaꞌ a, fo nau ralutu lelesu a. ");
INSERT INTO rgu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tehuu fui sira dua looꞌ lima nara reu, de hela ra Lot leo uma daleꞌ neu, boe ma ara koe etu lelesu a. ");
INSERT INTO rgu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Basa de ara rapoke lahenda Sodom ara mata nara, losaꞌ roi rafaroroeꞌ a saka lelesu a, tehuu ta hapun fa. ");
INSERT INTO rgu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Basa boe ma fui sira dua dedea ro Lot rae, “Lot! MANETUALAIN bubuluꞌ kota ia tadalu na so. De Ana fee ami mai fo nau malulutuꞌ kota ia. O bei manuu kileoboboki fekeꞌ nai kota ia, do taꞌa? Maneniko manuu ana touꞌ, do ana inaꞌ, do manafeuꞌ, do sudi bea, sona mu mala si, fo kalua meme kota ia mai leo!” ");
INSERT INTO rgu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot namanene ria boe ma, ana neu dama ana tou kaduaꞌ fo sakaꞌ dadi reuꞌ ria manafeun. Ana nafada si nae, “Nenene matalolole! Besaꞌ ia emi malale kalua meme kota ia mai leo, huu fo MANETUALAIN sakaꞌ tao nalulutuꞌ kota ia!” Tehuu ara raendobuko Lot dedea naseseko. ");
INSERT INTO rgu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Balahaaꞌ, balahaa ana na, boe ma Manetualain eilaꞌo-limalopen sira dua, laku Lot asa fo ralale kalua leo. Ara rae, “Lot! Foa leo! Moo sao ma no ana fetom dua si, fo malai leo. Foa ela kota ia. Bosoꞌ losa emi mate hihiiꞌ, ma malulutuꞌ sama-sama mo kota ia.” ");
INSERT INTO rgu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tehuu Lot bei naleleiꞌ. Sekonaa te MANETUALAIN nau fee ni nasoda. De fui sira dua tai ra Lot, sao na, ma ana feton dua si lima nara, fo hela roo si kalua remeꞌ kota ria mai. ");
INSERT INTO rgu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Boe ma esa neme fui sira dua mai fee pareta nae, “Malai inaꞌ a fo saka sodaꞌ leo! Bosoꞌ lipe deaꞌ! Bosoꞌ mateꞌe nai bafaꞌ a! Malai ae maroo leo leteꞌ ele lain meu, ela emi bosoꞌ mate!” ");
INSERT INTO rgu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tehuu Lot nataa nae, “Adoo, papa ee! Bosoꞌ leo naꞌ! ");
INSERT INTO rgu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tebe papa tulu-fali so, ela ami masoda. Tehuu leteꞌ ria doo na seli! Bosoꞌ losa ami bei ta losa naa boeꞌ, te soe a hapu na ami nai eno taladaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Papa mete dei. Hapu koro anaꞌ esa, ta dooꞌ a neme iaꞌ mai fa. Koroꞌ ria ta nanuu sosoa-raraaꞌ hata-hata esa boeꞌ. De maneniko papa nau, sona ela leoꞌ bea na ami meu saka sodaꞌ nai naa.” ");
INSERT INTO rgu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ana nataa nae, “Neu! Meu leo! Neuꞌ ko au ta tao alulutuꞌ koroꞌ ria fa. ");
INSERT INTO rgu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","De besaꞌ ia emi malai-malai mesan naaꞌ meu leo! Huu fo au ta bisa tao hata-hata esa boeꞌ, kalu emi bei ta losa naa fa.” Mulai nemeꞌ tepoꞌ ria mai, boe ma lahenda fee koroꞌ ria nade, Soar, sosoa na nae, ‘aanaꞌ’. ");
INSERT INTO rgu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ledo a sakaꞌ tii, boe ma Lot asa losa rai Soar. ");
INSERT INTO rgu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kekeneu te, MANETUALAIN poꞌa aipilaꞌ no balerang, pila loa-loa neme lalai mai onda leo kota Sodom no Gomora. ");
INSERT INTO rgu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","MANETUALAIN tao nalulutuꞌ heni kota a no koroꞌ ara rai nusaꞌ ria, ma basa-basan fo rasoda rai naa, siꞌ: lahenda, banda-manuꞌ, ma parusa ra. ");
INSERT INTO rgu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot asa bei ralai, te sao na lipe dea na. Kekeneu te ana dadi dii masi so. ");
INSERT INTO rgu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Balahaaꞌ, balahaa anan na, Abraham neu seluꞌ leo mamanaꞌ, fo uselen ria ana oꞌoe-leleꞌo neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ana lalanda leo Sodom no Gomora, ma basa bafaꞌ sira neu. Ana mete, te nai bea-bea oo, ai masuꞌ a kaboboa leo lalai neu. Ma aipilaꞌ a naa heni basa-basan. ");
INSERT INTO rgu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Manetualain tao nalulutuꞌ kota sira, tehuu Ana tuli-fali na Lot kaluar neme mamanaꞌ fo hapu huhukuꞌ ria, nana huu nafarene hehelu Na neuꞌ Abraham. ");
INSERT INTO rgu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Tepoꞌ ria, Lot biiꞌ leo nahaniꞌ koro Soar. Huu ria na, de ana no ana feton dua si lali leo leteꞌ reu. Basa de ara leo rai leaꞌ esa daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Laiꞌ esa de, ana feto uluꞌ a dedea no fadi na nae, “Rule-feo basa mamanaꞌ ia, ta hapu touꞌ esa boeꞌ, fo bisa mai sao ra ita. Ma ta dooꞌ a soꞌ, te papa ka boe-boe namalasi, ma ta hapu anaꞌ soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","De malole lenaꞌ ita fee papa ka ninu mafuꞌ. Basa nana suku toꞌ ana, fo ela leoꞌ bea na ita bisa tuti taroo papa ka tititi-nonosin.” ");
INSERT INTO rgu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Boe ma hatun ria, ara fee papa na ninu oe anggor losa mafuꞌ. Basa boe ma, ana uluꞌ a neu suku noꞌ papa na. Tehuu tou lasiꞌ a mafuꞌ naan seli, losaꞌ ana ta bubuluꞌ nae ria tao ana feto na leoꞌ bea soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Balahaaꞌ, boe ma aꞌa a nafada fadi na nae, “Fadi, e! Leodaeꞌ a au suku oꞌ papa ka so. Hatun ia, o nuum bali. Ela ita tao tamafuꞌ papa ka bali, basa nana fadi ka mu suku moꞌ ana. No ria na, ita dua hapu anaꞌ belaꞌ a, fo tuti papa ka tititi-nonosin.” ");
INSERT INTO rgu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Hatun ria boe ma, ara tao ramafuꞌ papa na bali. Ana muriꞌ a neu suku noꞌ papa na. Tehuu tou lasiꞌ a mafuꞌ naan seli, losaꞌ ana ta bubuluꞌ nae ria tao ana feto na leo bea soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","No ria na, dua si rairu neme sira papa boki na mai. ");
INSERT INTO rgu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ana uluꞌ a boki na ana touꞌ esa. Boe ma ana foin nade, Moab (hiiꞌ nae sama leoꞌ dedeaꞌ fekeꞌ esa, fo sosoa na nae, ‘neme papa ka mai’). Ria riꞌ besaꞌ ia dadi neuꞌ lahenda Moab ara bei-baꞌin. ");
INSERT INTO rgu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Basa boe ma ana muriꞌ a boki na ana touꞌ esa. Ana foin nade, Ben Ami (sosoa na nae, ‘anaꞌ neme au lahenda ka’). Ria nana riꞌ besaꞌ ia dadi neuꞌ lahenda Amon ara bei-baꞌin. ");
INSERT INTO rgu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Basa ria boe ma, Abraham lali neme Mamre mai, leo dae Negeb neu nai pooꞌ ona, de leo nai koro Kades no Syur talada. Tehuu ta doo bea boeꞌ, te ana lali leo koro Gerar a neu bali. ");
INSERT INTO rgu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Boe ma ana nafada lahenda rai naa, nae Sara nana ria feto na. Huu ria na, de Abimelek, mane Gerar, nadenu lahenda nara reu rala Sara, fo roo ni leo maneꞌ a uma manpareta na neu. ");
INSERT INTO rgu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Hatuꞌ esa boe ma, Manetualain natudu Ao Na neuꞌ maneꞌ a nai mei-afes daleꞌ. Ana dedea nae, “O moi mate ia so! Huu fo o tonda ma lahenda saon.” ");
INSERT INTO rgu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Tehuu Abimelek sipoꞌ nae, “Manetualain! Au ta sala fa. Au bei ta tototo inaꞌ ria fa. Abraham riꞌ nafada aon nae inaꞌ ria nana feto na! Ma inaꞌ ria boe manaku nae leoꞌ na. Huu ria na, de au adenu fo reu ralan no dale makamoiꞌ. De Manetualain bosoꞌ sale au!” ");
INSERT INTO rgu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Boe ma, Manetualain nataa nae, “Tebe Au bubuluꞌ o dale makamoiꞌ ma. Au riꞌ amakee, fo o bosoꞌ tototo inaꞌ ria. No ria na, o ta masala neuꞌ Au fa. ");
INSERT INTO rgu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Fee faliꞌ inaꞌ ria leo sao na neu. Ria nana Au lahenda manesimata Ka. De mafada ni fo hule-haradoi fee o, ela o bosoꞌ mate. Tehuu o ta fee faliꞌ inaꞌ ria fa, sona mafarene matalolole! Neuꞌ ko mate katemaꞌ o mo basa lahenda mara, ri naꞌ so.” ");
INSERT INTO rgu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Balahaaꞌ, balahaa ana na, boe ma maneꞌ a naloo na basa pegawe nara, de tui meis na. Boe ma basa si bii. ");
INSERT INTO rgu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Basa de maneꞌ a naloo na Abraham, boe ma natane nae, “Au tao a sala ubeaꞌ, losaꞌ o tao soe fee au o anaraun kara leoꞌ ia? O ta bole tao nonoi tadalu leo iaꞌ fa! ");
INSERT INTO rgu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","O afi ubeaꞌ, losaꞌ o tao leo iaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham nataa nae, “Papa maneꞌ! Au afi ae emi basa ta malelaꞌ Manetualain fa. Tantu hapu emi ruma nau maisa au, fo ela tonda ra au sao ka. ");
INSERT INTO rgu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tebe au dedea teteaꞌ ae, au feto ki ria. Huu fo ami dua nana papa esa, tehuu esaꞌ ko maman. Huu ria na, de ami ma sao ao. ");
INSERT INTO rgu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tepoꞌ fo Manetualain nadenu ami meu tai-tapa nai lahenda nusa-namon, au afada sao ka ae, ‘Maneniko ita leo beaꞌ teu, ma hapu lahenda ratane ita dua tututi-nanaton, kalu o sue au, sona mataa mae, ita feto-naaꞌ.’ ” ");
INSERT INTO rgu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Basa boe ma mane Abimelek fee faliꞌ Sara. Ana dedea no Sara nae, “Besaꞌ ia, au bae o naa ma doifulaꞌ rifun esa, fo dadi buti nae, au ta tao salaꞌ hata-hata esa neuꞌ o boeꞌ. Ela basa lahenda ra bubuluꞌ leoꞌ na!” Basa de maneꞌ a dedea no Abraham nae, “Abraham! Au nusa ki ia nanasoi loaꞌ soaneuꞌ o. O mahiiꞌ mu leo nai mamanaꞌ bea boe oo, bole.” Basa de ana fee Abraham sapi, kedaeꞌ ma bibi-lopo boe. Ana fee ata touꞌ ma inaꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Masososa na MANETUALAIN tao na inaꞌ fo leo rai Abimelek nusa na kalatedis, nana huu Abimelek tonda na Abraham sao na. Tehuu fai fo maneꞌ a fee faliꞌ Sara leo sao na neu, boe ma Abraham hule-haradoi fo ela Manetualain buka seluꞌ inaꞌ sira anamana nara. No leoꞌ na boe ma, inaꞌ sira bisa boki seluꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Basa ria boe ma, MANETUALAIN fee ua-naleꞌ neuꞌ Sara, tuka Ria hehelu na. Abraham namalasi so, te Sara nairu. Fai fo ana boki a, Abraham teun natun esa so. Naraa no ledo-fain, boe ma Sara boki na ana touꞌ esa. Abraham foi anaꞌ ria nade, Isak (sosoa na nae, ‘ana hiꞌa’). Sara boe dedea nae, “Manetualain tao na au hiꞌa, nana huu besaꞌ ia au amahoꞌo. Lahenda ra afi rae, au ta bisa hapu anaꞌ nai au fai lasi ka soꞌ. Sekonaa te, leo mae au sao ka namalasi kokoo so, tehuu au bei boki fee ni. De besaꞌ ia, sudi bea fo ramanene hata ia, sira boe hiꞌa sama-sama roo au.” Boki basa Isak faiꞌ falu, boe ma Abraham sunat ana, tuka Manetualain pareta Na. ");
INSERT INTO rgu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isak boe-boe nambau-ina. Fai fo sakaꞌ fila ni, Abraham tao feta bau-inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Laiꞌ esa de, Sara nita Abraham sao murin Hagar ana ni Ismael naseseboꞌ Isak. Bei nita leoꞌ na, boe ma Sara dedea no sao na nae, “Usi heni ata fo riꞌ neme Masir mai a, no ana na! Huu fo au ta nau ata a anan ria sipo hata posakaꞌ esa boeꞌ. Adaꞌ noi au ana ki Isak, riꞌ muste hapu katemaꞌ asa.” ");
INSERT INTO rgu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham namanene Sara dedea nae leoꞌ na, boe ma dale na nasalaꞌ, nana huu Ismael boe, ria anan. ");
INSERT INTO rgu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tehuu Manetualain dedea no Abraham nae, “Abraham, e! O bosoꞌ afi leo sao murim ria no ana na. Tuka noi Sara hihii-nanaun, huu fo tititi-nonosiꞌ fo au helu a, neuꞌ ko o hapu nemeꞌ Isak mai. ");
INSERT INTO rgu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tehuu Au boe fee ua-naleꞌ neuꞌ o sao muri ma ana na, nana huu ria boe ana bokim. Neuꞌ ko ria tititi-nonosin boe dadi reuꞌ lahenda nusaꞌ esa.” ");
INSERT INTO rgu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Balahaaꞌ, balahaa ana na, boe ma Abraham tao tua-lepa fee Hagar, ma feen nasalili neni oe boto esa. Basa de ana nafuli heni inaꞌ ria no anan Ismael. Basa boe ma ara laꞌo rafeo nai dae rouꞌ naneneaꞌ Beer Syeba. ");
INSERT INTO rgu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sira oe nininu na basan, boe ma Hagar foa ela ana na neuꞌ ai huu anaꞌ esa lao na. ");
INSERT INTO rgu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ana afi nai dale na nae, “Au ta anenete relu laꞌe anaꞌ ia mamate na soꞌ.” Basa de ana oruꞌ ela anaꞌ a bate meter lima hulu, de natuuꞌ. Boe ma ana dola nasaꞌeedu. ");
INSERT INTO rgu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Manetualain namanene Ismael haraoe dodola na, boe ma eilaꞌo-limalopen esa neme nusatetu-ikutemaꞌ naloo Hagar nae, “Hagar! Ubeaꞌ taon de o susa tao leoꞌ ia? Bosoꞌ bii, huu fo Manetualain namanene anaꞌ ria haraoe dodola na so. ");
INSERT INTO rgu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Foa fo mu dama anaꞌ ria leo. Matetea dale na, huu fo neuꞌ ko au tao a ria tititi-nonosin dadi reuꞌ lahenda nusa kahereꞌ esa.” ");
INSERT INTO rgu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Basa de Manetualain tao nadilaꞌ Hagar mata na, losaꞌ ana nita oe dodoluꞌ esa nai naa. Boe ma ana neu dou oe neuꞌ boto ria, de naninuꞌ anaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ismael no mama na leo rahaniꞌ mo soroae Paran. Ana nambau-ina mai, boe ma dadi neuꞌ mana ou kahereꞌ. Basa de mama na feen sao ina Masir esa. Basa ia ra dadi, nana huu Manetualain sama-sama no Ismael. ");
INSERT INTO rgu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tepoꞌ ria, mane Abimelek no ria parani musu na, nade Fikol, mai raneta ro Abraham. Maneꞌ a dedea nae, “Abraham! Ami bubuluꞌ so, mae Manetualain sama-sama no o. Huu ria na, de o tao sudi ubeaꞌ a basan dadi. ");
INSERT INTO rgu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Besaꞌ ia au hule o soo-supa nai Manetualain mata Na mae, o ta edi-fule au oo basa upu-ana kara. Sama leoꞌ au tao malole neuꞌ o, sona o boe muste tao malole neuꞌ au ma nusaꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham nataa nae, “Ia! Au soo-supa.” ");
INSERT INTO rgu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tehuu Abraham boe tui maneꞌ a nae, “Papa maneꞌ lahenda mara ralea ra au oe dodolu ki esa.” ");
INSERT INTO rgu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Maneꞌ a namanene leoꞌ na, boe ma nataa nae, “Ae! Au besaꞌ ko amanene hata ia. Ubeaꞌ taon de papa ta tui neme maulun ria mai fa? Au ta bubuluꞌ bea riꞌ nonoi-tataon ria.” ");
INSERT INTO rgu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Boe ma Abraham no Abimelek heke hehelu-barataaꞌ. Abraham heo fee maneꞌ a sapi ma bibi-lopo. Boe ma ana heo tamba seluꞌ bibi-lopo tenaꞌ hitu. ");
INSERT INTO rgu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Maneꞌ a natane ni nae, “Ubeaꞌ taon de o tao leo naꞌ?” ");
INSERT INTO rgu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham nafada nae, “Papa maneꞌ sipo ma bibi-lopo tena kahituꞌ ia ra, fo dadi tanda nae, papa mane manaku, au riꞌ ali oe dodoluꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huu no dua si soo-supa reuꞌ na, boe ma ara fee mamanaꞌ ria, nade Beer Syeba. Sosoa na nae, ‘Oe dodolu mansooꞌ’. ");
INSERT INTO rgu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ara soo-supa basa, boe ma mane Abimelek no parani musu na fali leo sira nusa Filistin na reu. ");
INSERT INTO rgu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Basa ria, Abraham sele ai tamareska huuꞌ esa nai Beer Syeba. Mulai faiꞌ ria, ai huuꞌ a fee nafarereneꞌ neuꞌ Abraham nae maꞌulu na ana doꞌo-tabe neuꞌ MANETUALAIN fo Masodaꞌ Losa Dodoo na nai na. ");
INSERT INTO rgu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Basa boe ma Abraham leo namanoso nai lahenda Filistin ara nusa-namon. ");
INSERT INTO rgu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ta doo bea boeꞌ, te Manetualain teteni Abraham, fo nau mete nasudi ni namanene neuꞌ Manetualain, do taꞌa. Manetualain naloo ni nae, “Abraham!” Abraham nataa nae, “Ya, Manetualain!” ");
INSERT INTO rgu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Manetualain nadenu ni nae, “Nenene matalolole! Hai ma ana mane isem fo o sue maan seli a, moo ni leo dae Moria neu, fo taon dadi tutunu-hohotuꞌ soaneuꞌ Au. Losa naa, besaꞌ ko Au atudu o mamana na nai leteꞌ esa.” ");
INSERT INTO rgu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Balahaaꞌ, balahaa ana na, boe ma Abraham tati ai natutuꞌ. Basa de ana puputu naa si, boe ma fua si reuꞌ keledei lain. Ana no Isak, ma ata ni dua, ara laꞌo leo mamanaꞌ fo Manetualain nafada ni so a. ");
INSERT INTO rgu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ara roi laꞌo-laꞌo a, binesaꞌ boe ma Abraham lalanda nita mamanaꞌ ria nai dooꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Boe ma ana nafada ata sira dua nae, “Emi dua adaꞌ ia lalai, mo keledei ia, fa! Au o ana ka sakaꞌ leo lain eleꞌ meu, fo doꞌo-tabe neuꞌ Manetualain. Basa ria, neuꞌ ko ami fali seluꞌ leo iaꞌ mai.” ");
INSERT INTO rgu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Boe ma Abraham hai na ai natutuꞌ ela tunu-hotu neniꞌ a, de fua si reuꞌ Isak arun lain. Ria riꞌ homu neni dope ma ai suuꞌ mandedeꞌ. Dua si laꞌo-laꞌo, ");
INSERT INTO rgu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","boe ma Isak naloo papa na nae, “Papa!” Abraham nataa nae, “Ubeaꞌ, Isak?” Isak natane tutiꞌ a nae, “Papa. Ita sakaꞌ tao tutunu-hohotuꞌ. Ai natutuꞌ ma aipilaꞌ nai ia so. Tehuu bibi-lopo anaꞌ fo ita pake ni dadi tutunu-hohotuꞌ, nana nai bea?” ");
INSERT INTO rgu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham nataa nae, “Ana ki on, e! Neuꞌ ko Manetualain riꞌ fee Ria bibi-lopo ana na fo pake ni dadi tutunu-hohotuꞌ.” Boe ma dua si ae raroo leteꞌ lain reu. ");
INSERT INTO rgu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ara losa rai mamanaꞌ fo Manetualain nafada so a, boe ma Abraham lutu batu, fo tao mamana tutunu-hohotuꞌ. Basa de ana hai na ai natutuꞌ ara, naduduru si reuꞌ batu lain. Boe ma puputu na ana na, de fee ni napeuꞌ naleka neuꞌ ai natutuꞌ lain. ");
INSERT INTO rgu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Boe ma ana hai na dope fo nau pau ana na. ");
INSERT INTO rgu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tehuu kekeneu te, MANETUALAIN eilaꞌo-limalopen nahara neme lalai mai nae, “Abraham! Mahani dei!” Abraham nataa nae, “Ubeaꞌ, Manetualain?” ");
INSERT INTO rgu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Boe ma haraoeꞌ a nae, “O bosoꞌ maisa anaꞌ ria! Bosoꞌ taon hata-hata esa boe! Besaꞌ ia Au bubuluꞌ so ae, tebe-tebe o tuka Manetualain hihii-nanaun, nana huu o sadia fee Manetualain ana mane ise ma, dadi tutunu-hohotuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Basa boe ma Abraham nita bibi-lopo maneꞌ esa, susura na soroꞌai nai ai huu anaꞌ a rana nara. Basa de Abraham neu hela na tutiꞌ bibi-lopo ria, de ana tao ni dadi tutunu-hohotuꞌ soaneuꞌ Manetualain, kati ana na. ");
INSERT INTO rgu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","De Abraham hule mamanaꞌ ria, nade, ‘Manetualain neuꞌ ko sadia fee hata fo parluu.’ Huu ria na, de losaꞌ besaꞌ ia boe, lahenda ra rae, “Nai MANETUALAIN leten lain, Ana sadia fee hata fo parluu.” ");
INSERT INTO rgu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Basa boe ma Manetualain eilaꞌo-limalopen nahara seluꞌ neme lalai mai nae, ");
INSERT INTO rgu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“MANETUALAIN riꞌ nae, ‘Au soo-supa pake Au nade ka leo iaꞌ: O sadia fee Au ana mane ise ma, fo dadi tutunu-hohotuꞌ so. Huu ria na, de ");
INSERT INTO rgu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Au fee ua-naleꞌ dodouꞌ neuꞌ o mo tititi-nonosim. Neuꞌ ko ara ramefu losaꞌ ta hapu lahenda reke rala si, sama leoꞌ ruuꞌ ara rai lalai, ma soroaeꞌ nai tasiꞌ a suu na. Neuꞌ ko upu-ana mara raseki musu nara. ");
INSERT INTO rgu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Neme o tititi-nonosi mara mai, basa lahenda nusaꞌ nai dae-bafoꞌ a, hapu ua-naleꞌ nana huu o tuka Au pareta ka so.’ ” ");
INSERT INTO rgu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Basa de Abraham no Isak onda faliꞌ, reu raneta ro ata kadua sira, boe ma ara sama-sama fali leo Beer Syeba reu. Abraham asa leo reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Laiꞌ esa de, Abraham namanene nae, fadin Nahor saon Milka boki na ana nara so. ");
INSERT INTO rgu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana uluꞌ a nade Us. Fadi nara nade Bus, Kemuel (fo riꞌ dadi Aram papa na), ");
INSERT INTO rgu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Haso, Pildas, Yidlaf, ma Betuel. ");
INSERT INTO rgu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel nana, Ribka papa na. ");
INSERT INTO rgu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor boe hapu tamba anaꞌ neme sao nafufuni na nade Reuma. Ria boki na Teba, Gaham, Tahas, ma Maaka. ");
INSERT INTO rgu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara maten neuꞌ teu ni natun esa duahulu hitu. Tepoꞌ fo mate ni a, Abraham asa leo rai koro Kiryat-Arba (riꞌ Hebron), nai dae Kanaꞌan. Abraham boreu, ma ana mete. ");
INSERT INTO rgu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Basa de Abraham neu dama lahenda Het ara. Ana dedea nae, ");
INSERT INTO rgu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au adaꞌ noi manataiꞌ nai emi basa talada. Au ta anuu dae fo atoi sao ka fa. Maneniko emi nau, sona fee au asa a emi daem bibia anaꞌ esa, ela atoi ni neuꞌ naa.” ");
INSERT INTO rgu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ara rataa ni rae, ");
INSERT INTO rgu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Leo iaꞌ, papa! Doo-naru basa ia nana, ami tao papa sama leoꞌ lahenda lasiꞌ esa, de ami hadaꞌ ma papa seli. Papa here leo, dae bea riꞌ malole a naan seli, fo raa laꞌe papa hihii-nanaum. Ami sipo-sipoꞌ mesan, ta tipa fa.” ");
INSERT INTO rgu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham namanene leoꞌ na, boe ma napadeiꞌ, naloe aon fo fee hada-hormata neuꞌ lahenda Het, manuu dae ara. ");
INSERT INTO rgu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ana nae, “Maneniko emi sipoꞌ au dedea bisina ka, sona au hule emi fo dedea mo papa Sohar ana manen Efron. ");
INSERT INTO rgu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Hulen fo maneniko bisa, sona ana seꞌo fee au ria lea na, nade Makpela, fo riꞌ nai oka na suu na. Ana hule beli na bau bea oo, au bae. Au nau bae etu beli na nai emi basa matam, ela dae ria dadi neuꞌ au nuhuu ka. Au nau taon dadi neuꞌ ami mamana roo-ratem.” ");
INSERT INTO rgu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Faiꞌ ria, Efron natuuꞌ no lahenda Het ara nai na boe. Ana namanene Abraham dedean ria boe. Basa de ana napadei, de nataa neuꞌ Abraham nai basa lasiꞌ ara matan nae, ");
INSERT INTO rgu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Bosoꞌ tao leo naꞌ, Papa! Leo iaꞌ dei. Au fee hihiiꞌ okaꞌ ria no lea Makpela neuꞌ papa. Papa matoi sao ma neuꞌ na. Au fee heni dae ria leo papa neu nai au lahenda kara matan. Ela leoꞌ bea na sira basa sakasii!” ");
INSERT INTO rgu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Basa de Abraham naloe aon seluꞌ neuꞌ lahenda Het ara. ");
INSERT INTO rgu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ana dedea no Efron nae, “Leoꞌ na boe malole a, tehuu emi basa nenene au dei. Au nau asa a dae ria, fo atoi lahenda kara reuꞌ na.” ");
INSERT INTO rgu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efron nataa nae, “Dae ria beli na adaꞌ noi doifulaꞌ natun haa! Huu hata de ita dua taloloe teu-mai no doi kabaianaꞌ sira? Papa muu fo matoi sao ma neuꞌ na leo.” ");
INSERT INTO rgu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham sipoꞌ na dae ria beli na, tuka Efron nafadan. Ana reke na doifulaꞌ natun haa nai basa lahenda Het ara matan fo ara sakasii. Basa de ana bae doi sira reuꞌ Efron. ");
INSERT INTO rgu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","No ria na Abraham hapu Efron dae na, dadi neuꞌ ria nuhuun. Dae fo riꞌ nai Makpela, naneneaꞌ no Mamre (riꞌ Hebron). Ana asa na dae ria no oka-tinen, lea na, ma ai huu nara katemaꞌ. Basa lasi Het ara sakasii, rae dae ria no basa oe isin, nana Abraham nuhuun. Basa boe ma Abraham natoi Sara neuꞌ leaꞌ ria daleꞌ, nai dae Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","No ria na okaꞌ ria, ma lea na fo maulu na lahenda Het ara daen, besaꞌ ia dadi neuꞌ Abraham nuhuun so, de ana taon dadi neuꞌ mamana roo-rates. ");
INSERT INTO rgu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham teu-fain loa-naruꞌ, losaꞌ namalasi naan seli so. Ma MANETUALAIN nanea natalolole ni, de feen nasoda no mole-dame. ");
INSERT INTO rgu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham nanuu lahenda kamahereꞌ esa, fo nafaduli ria hata-heton katemaꞌ. Laiꞌ esa boe ma Abraham naloo nan nae, “Nenene matalolole! Au hule o soo-supa, pake MANETUALAIN nade Na, fo riꞌ adu na lalai ma dae-bafoꞌ a. Soo-supa mae, o ta matane ana fetoꞌ neme lahenda Kanaꞌan ara mai, fo feen sao au ana ki Isak. ");
INSERT INTO rgu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","O muste leo au dae fua-funi ka muu, nai au kileoboboki kara. O matane ana fetoꞌ esa nai naa fo feen sao au ana ka.” ");
INSERT INTO rgu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Basa de ata ria natane Abraham nae, “Ia, papa! Tehuu leoꞌ bea, kalu ana fetoꞌ ria ta nau tuka leo iaꞌ mai fa? Kalu leoꞌ na, sona au muste oo papa ka ana ma, neuꞌ naa fo sao, do leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham nataa nae, “Mafareneneꞌ matalolole! Leo mae leoꞌ bea boe oo, ta bole mo au ana ka leo naaꞌ neu fa! ");
INSERT INTO rgu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mafarereneꞌ huu fo MANETUALAIN mankuasa nai lalai, noo au kalua eme dae fua-funi ka mai, losa nai dae ia so. Ma Ana heke hehelu-barataaꞌ no au nae, ‘Neuꞌ ko Au fee katemaꞌ dae ia neuꞌ o tititi-nonosim.’ O dale ma bosoꞌ dodaꞌ! O muu leo. Huu fo neuꞌ ko Manetualain nadenu eilaꞌo-limalopen neme nusatetu-ikutemaꞌ a mai soi enoꞌ fee o bisa maneta mo ana fetoꞌ fo neuꞌ ko dadi neuꞌ au ana ka sao na. ");
INSERT INTO rgu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tehuu maneniko ana fetoꞌ ria ta nau tuka leo iaꞌ mai fa, sona o soi ma aom meme sosoo-susupaꞌ ria mai. Leo mae leoꞌ bea boe oo, ta bole mo au ana ka leo naaꞌ neu.” ");
INSERT INTO rgu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Boe ma ata ria soo-supa neuꞌ Abraham nae, neuꞌ ko ana tao tuka Abraham hihii-nanaun katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ata ria teka-here na onta sanahulu. Basa de ana fua hata malole rupaꞌ ara reuꞌ onta sira koti ai nara lain. Boe ma ana laꞌo leo Nahor kota na neu nai Mesopotamia. ");
INSERT INTO rgu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mateꞌe oe na, ata a losa kota ria. Basa de, ana fee onta nara hahae reuꞌ kota a suu na, naneneaꞌ no oe dodoluꞌ esa. Fai ria ledo a nai daeꞌ so, naraa no ana fetoꞌ ara reu dolu oe nai oe dodoluꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ata a hule-haradoi nae, “MANETUALAIN, fo au malaka ki Abraham Manetualain a. Soi enoꞌ fo ela au leleo-lalaꞌo ki ia neni buna-boaꞌ. Manetualain matudu dale malole ma neuꞌ au malaka ka, ma mafarereneꞌ hehelu na neuꞌ au. Ela leoꞌ bea na au aneta o ana fetoꞌ fo riꞌ neuꞌ ko dadi neuꞌ Isak sao na. ");
INSERT INTO rgu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Manetualain, au apadei nai oe dodoluꞌ ia suu na. Ma ana fetoꞌ ara reme kota daleꞌ mai aso oe nai ia. ");
INSERT INTO rgu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Au hule leo iaꞌ: Maneniko au dedea o ana fetoꞌ esa ae, ‘Nona, e! Maonda ure oe ma fo fee au oe baiꞌ inu dei.’ Maneniko ana nataa nae, ‘Papa ka minu leo. Ma neuꞌ ko papa ka onta mara boe au hani si.’ Na, ria nanadadi tanda nae, ana fetoꞌ ria riꞌ Manetualain here man so, fo dadi neuꞌ Isak sao na. No tanda leo naꞌ a, au bubuluꞌ ae, Manetualain matudu susue ma, neuꞌ au malaka ki Abraham so.” ");
INSERT INTO rgu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Abraham ata na bei ta hule-haradoi basa boeꞌ, te ana fetoꞌ esa mai. Nade Ribka. Ria nana, Nahor no saon Milka upu na. Nahor, nana Abraham fadin. Ribka papan nade Betuel. Ribka lole na seliꞌ, ma bei ao tema. Ana onda leo oe mataꞌ ria daleꞌ neu, ana dou oe nahenu ure na, basa de ae lain mai. ");
INSERT INTO rgu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ribka losa lain, boe ma Abraham ata na nalai neu soruꞌ ana. Ana hule nae, “Nona, fee au oe baiꞌ inu dei.” ");
INSERT INTO rgu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Boe ma ana feto anaꞌ a nataa nae, “Minu leo, toꞌo!” Ana naonda lai-lai ure oe na, de fee ata a ninu. ");
INSERT INTO rgu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ninu basa boe ma, ana fetoꞌ a nae, “Nemeꞌ na, ela au hela oe fee toꞌo ka onta mara fo rinu losaꞌ rabete.” ");
INSERT INTO rgu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Boe ma ana poꞌa oe lenaꞌ a neuꞌ haꞌo ra daleꞌ. Basa de ana nalai, onda-ae aso oe nemeꞌ oe dodoluꞌ ria mai, fo fee basa onta ra rinu losaꞌ rabete. ");
INSERT INTO rgu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham ata na napadeiꞌ nee-nee, ma nanilu nahere ana fetoꞌ a nonoi-tataon. Ana aafi nae, “Ana fetoꞌ ia riꞌ Manetualain heren, do?” ");
INSERT INTO rgu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Onta sira basa si rinu losaꞌ rabete. Boe ma ata a hai na rereli idu lilopilas ma sue lilopilas pasang esa, de olu si reuꞌ ana fetoꞌ a liman duas. ");
INSERT INTO rgu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Basa boe ma ata a natane nae, “Nona, papa ma nade bea? Kalu bisa, sona au tuli fo suku nai papa ma uma na.” ");
INSERT INTO rgu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ana fetoꞌ a nataa nae, “Au papa ka, nade Betuel. Au baꞌi ka, riꞌ Nahor. Ma au besa ka, riꞌ Milka. ");
INSERT INTO rgu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nai ami uma ma hapu mamana susukuꞌ dai fee toꞌo kasa. Ma nau-ai doo dodouꞌ fee toꞌo ka banda mara.” ");
INSERT INTO rgu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Abraham ata na namanene leoꞌ na, boe ma ana sundaꞌ undulaka na fo doꞌo-tabe neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ana dedea nae, “Io-oa Manetualain! Manetualain soi enoꞌ fee au so, losaꞌ aneta o malaka Abraham kileoboboki nara rai ia. Manetualain matudu dale malole ma neuꞌ au malaka ki Abraham, ma tao natetu hehelu-baratan neuꞌ au so.” ");
INSERT INTO rgu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Basa de, ana fetoꞌ a nalale nalai neun, fo tui basa uma isi nara, hata fo dadi so a. ");
INSERT INTO rgu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka naa na, nade Laban. Laban nita lilopilas sira ma namanene Ribka tutui na, boe ma ana nalai neu naneta no ata fo riꞌ bei no onta nara rapadei raneneaꞌ nai oe dodoluꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban dedea nae, “Toꞌo! MANETUALAIN napipi-nalalaꞌo noo toꞌo ka losa ia no soda-moleꞌ. Bosoꞌ mapadeiꞌ mahaniꞌ deaꞌ ia! Mai leo ami umam teu. Ami sadia ma kama so. Nanaaꞌ soaneuꞌ toꞌo ka onta mara nana heta.” ");
INSERT INTO rgu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Basa boe ma Abraham ata na tuka Laban, de leo Betuel uma na neu. Laban asa fali ni de raonda hata fo fua reni a, reme onta ra mai. Basa boe ma ara fee onta ra nau fo raa. Ara reni oe boe fo ata a no lahenda nara safe ei nara. ");
INSERT INTO rgu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ara mulai sadia nanaa-nininuꞌ nai mei a, boe ma ata a nae, “Ami sakaꞌ mia-minu riaꞌ so, tehuu au hule parmisi fo afada au mamai ka sosoa na dei.” Laban nataa nae, “Toꞌo ka, dedea leo.” ");
INSERT INTO rgu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ata a nae, “Au ia nana, emi baꞌim Abraham atan. ");
INSERT INTO rgu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","MANETUALAIN fee ua-naleꞌ dodouꞌ neuꞌ au malaka ka so, losaꞌ ana namasuꞌi naan seli. Manetualain pala-bati feen lilopilas, lilofula, ata inaꞌ ma ata touꞌ, banda-manuꞌ dodouꞌ: sapi, onta, keledei, kedaeꞌ, ma bibi-lopo. ");
INSERT INTO rgu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Au malaka ki dua si ina-touꞌ ramalasi so, boe ma mama Sara boki fee malaka ki Abraham ana touꞌ esa. Ria riꞌ neuꞌ ko sipoꞌ na malaka ki Abraham pusaka nara katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Malaka ki Abraham nadenu au soo-supa ae, ‘O ta saka ana feto Kanaꞌan feen sao au ana ki Isak. ");
INSERT INTO rgu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","O muste saka feen ana fetoꞌ nemeꞌ au kileoboboki kara mai, dadi neuꞌ ria saon.’ ");
INSERT INTO rgu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Basa de au atane malaka ka ae, ‘Kalu ana fetoꞌ ria ta nau tuka au fa, sona leo beaꞌ?’ ");
INSERT INTO rgu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ana nataa nae, ‘MANETUALAIN fo au oi tuka-tukaꞌ hihii-nanau Ni a, neuꞌ ko nadenu eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai, soi fee o enoꞌ, ela o bisa hapu ana fetoꞌ esa neme au kileoboboki kara mai, fo dadi neuꞌ au ana ka sao na. ");
INSERT INTO rgu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tehuu maneniko au kileoboboki kara tipa, fo ta nau poꞌi ana fetoꞌ ria leo iaꞌ mai, sona o soi ma aom meme sosoo-susupaꞌ ria mai.’ ");
INSERT INTO rgu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Bisinaaꞌ a au losa nai oe dodoluꞌ a, au hule-haradoi nai dale ka ae, ‘MANETUALAIN, Au malaka ki Abraham Manetualain na. Soi enoꞌ fo ela leoꞌ bea na au leleo-lalaꞌo ki ia neni buna-boa. Ela leoꞌ bea na au aneta o ana fetoꞌ fo dadi neuꞌ Isak sao na. ");
INSERT INTO rgu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Manetualain, au apadeiꞌ nai oe dodoluꞌ ia. Ma ana fetoꞌ ara reme kota daleꞌ mai aso oe nai ia. De au hule leo iaꞌ: Neuꞌ ko au dedea o ana fetoꞌ esa ae, ‘Nona, e! Fee au oe baiꞌ inu dei.” ");
INSERT INTO rgu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Maneniko ana nataa nae, “Papa minu leo! Ma au fee papa onta mara rinu boe.” Na, ria dadi tanda nae, Manetualain here ana fetoꞌ ria dadi neuꞌ au malaka ka ana mane na saon!’ ");
INSERT INTO rgu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Au bei ta hule-haradoi basa boeꞌ, te ana feto Ribka mai so, neni ure oe na, fo aso oe nai oe dodoluꞌ a. Bei ae lain mai, boe ma au hulen ae, ‘Nona, fee au oe baiꞌ inu dei.’ ");
INSERT INTO rgu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Boe ma ana naonda lai-lai ure oe na, de nae, ‘Toꞌo minu leo. Ma au fee toꞌo onta nara rinu boe.’ Basa de au inu, ma au onta kara rinu boe. ");
INSERT INTO rgu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Boe ma au atane ae, ‘Nona, papa ma nade bea?’ Ana nataa nae, ‘Au papa ka, nade Betuel. Au baꞌi ka, nade Nahor. Ma au besa ka, nade Milka.’ Basa boe ma au fee ni pake rereli neuꞌ idu na, ma olu sue lilopilas dua reuꞌ lima nara. ");
INSERT INTO rgu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Basa de, au aloe ao ka fo doꞌo-tabe Manetualain ae, ‘Io-oa Manetualain! Manetualain soi fee au enoꞌ so, losaꞌ au aneta o malaka ki Abraham kileoboboki nara rai ia. Ma au aneta tutiꞌ oo ana fetoꞌ, fo riꞌ sakaꞌ dadi neuꞌ mane ana Isak, sao na.’ ");
INSERT INTO rgu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","De besaꞌ ia, kalu papa kasa nau matudu dale susue mara neuꞌ au malaka ki Abraham, sona mafada au ledo-ledo leo. Ma kalu taꞌa boe, mafada ledo-ledo. Ela au bubuluꞌ ae muste tao ubeaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ata a dedea basa, boe ma Laban no Betuel rataa rae, “Kalu MANETUALAIN ator nan leoꞌ na, sona ami bei mae ubeaꞌ bali. ");
INSERT INTO rgu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ana feto Ribka nai ia. De moo ni neu leo. Fo ela ana dadi neuꞌ baꞌi Abraham manafeun, tuka hata fo MANETUALAIN ator so a.” ");
INSERT INTO rgu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham ata na namanene leoꞌ na, boe ma ana natele aon losa dae a, fo hule makasi neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Boe ma, ana ofe na hata-heto lilopilas-lilofulaꞌ, ma papake malole ra, de fee Ribka. Ana fee Ribka naa na, ma mama na, hadia mabeli boe. ");
INSERT INTO rgu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Basa ria, boe ma Abraham ata na no lahenda nara ratuuꞌ, de raa feta. Boe ma ara suku reuꞌ na. Balahaaꞌ, balahaa ana na, ara foa boe ma ata a nafada manuu umaꞌ a nae, “Au hule parmisi, kalu bisa, sona besaꞌ ia ami fali leo au malaka ka meu.” ");
INSERT INTO rgu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tehuu Ribka naa na ma mama na rae, “Te mapue marooꞌ fafaliꞌ a tao ubeaꞌ? Nemeꞌ naa fo Ribka leo no ami seluꞌ faiꞌ sanahulu leoꞌ naa dei. Basa sona, moo ni leo.” ");
INSERT INTO rgu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tehuu ata a nataa nae, “Adoo! Bosoꞌ ena au! MANETUALAIN tulu-fali au so, losaꞌ aneta oo ana mane anaꞌ a sao na so. De mama kasa poꞌi ami, fo fali meu tui malaka a dei.” ");
INSERT INTO rgu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ara rataa rae, “Leo iaꞌ! Mai fo ita tatane mataꞌ Ribka. Ria hihii na leo beaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Boe ma ara raloo ran de ratane ni rae, “Ribka! Besaꞌ ia neme o dale ma mai. O nau tuka memaꞌ lahenda ia do, leoꞌ bea?” Ana fetoꞌ a nataa nae, “Au nau!” ");
INSERT INTO rgu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Boe ma ara poꞌi Ribka, ma ria ata inan fo riꞌ anutun neme ananan ria mai, fo roo Abraham ata na reu belaꞌ a. Ara dedea fee Ribka ua-naleꞌ rae, “Ribka! Ami mamahehenaꞌ Manetualain fee o boki ma dodouꞌ, fo o tititi-nonosim dadi rifu-natun. Ma ami boe mamahehenaꞌ o tititi-nonosi mara raseki musu ra.” ");
INSERT INTO rgu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Basa ria de, Ribka no ata inan rafafau sira bua-loas nara, boe ma ara saꞌe onta, de laꞌo tutiꞌ a, tuka Abraham ata nara. ");
INSERT INTO rgu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Faiꞌ ria Isak leo nai dae Negeb. Ana besaꞌ ko fali nemeꞌ oe dodoluꞌ, fo nai Beer Lahai Roi. ");
INSERT INTO rgu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ledo leodaeꞌ esa, ana kalua neme mamana leleo na mai, fo lalaꞌo hai ani. Ana botiꞌ laka na, boe ma nita onta ra mai. ");
INSERT INTO rgu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka nita Isak, boe ma ana nalale de boꞌe nemeꞌ onta na mai. ");
INSERT INTO rgu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ana natane Abraham ata na nae, “Toꞌo! Touꞌ fo laꞌo mata mai riꞌ eleꞌ a, bea ria?” Ata a nataa nae, “Ria nana au mane ana ka.” Boe ma Ribka hai na lafa ana na, de lalaa etu mata-idun. ");
INSERT INTO rgu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Basa ria boe ma, ata a tui basa-basan neuꞌ Isak. ");
INSERT INTO rgu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak no Ribka masoꞌ leo mamana lelelon daleꞌ neu, boe ma dua si sao. Isak sue na Ribka seliꞌ, huu ria na, ana ta dale hedi neuꞌ mama na mamate-momopon soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham sao seluꞌ inaꞌ esa, nade Ketura. ");
INSERT INTO rgu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura boki fee ni anaꞌ. Nade nara siꞌ: Simran, Yoksan, Medan, Midian, Isbak, ma Sua. ");
INSERT INTO rgu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan ana nara, siꞌ Seba ma Dedan. Dedan tititi-nonosin, siꞌ lahenda Asyur, Letus, ma lahenda Leum ara. ");
INSERT INTO rgu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ana nara, siꞌ: Efa, Efer, Henok, Abida, ma Eldaa. Basa sira nana, Ketura tititi-nonosin. ");
INSERT INTO rgu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Tepoꞌ fo Abraham bei nasoda a, ana bati fee Hagar no Ketura ana nara, esaꞌko noꞌ hata-heton. Basa de ana nadenu si, fo reu leo rai dae Kanaꞌan pooꞌ dulu, fo ela ara dooꞌ a reme ana ni Isak mai. Tehuu basa hata posaka nara, ana fee katemaꞌ asa leo Isak reu. ");
INSERT INTO rgu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham maten neuꞌ teu ni natun esa hituhulu lima. ");
INSERT INTO rgu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Basa de ana nara, Isak ma Ismael ratoin nai lea Makpela, fo riꞌ naneneaꞌ no Mamre. Maulu na Abraham asa na okaꞌ ria neme lahenda Het, riꞌ Sohar anan, Efron. Maulu na, ara ratoi Sara nai leaꞌ ria boe. ");
INSERT INTO rgu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mate ni, basa boe ma Manetualain fee ua-naleꞌ neuꞌ Isak, losaꞌ ana nasoda no mole-dame. Tepoꞌ ria, Isak leo naneneaꞌ oe dodoluꞌ esa, nade Beer Lahai Roi. ");
INSERT INTO rgu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ia nana Ismael tutui na. Ria nana, Abraham no sao murin Hagar anan. Hagar nana, Sara atan neme Masir mai. ");
INSERT INTO rgu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael ana nara, touꞌ sanahulu dua. Nade nara ratutuka ao, neme uluꞌ a losa mateꞌa tei-susuꞌ a, siꞌ: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, ma Kedma. Anaꞌ sira dadi reuꞌ bei-baꞌi reme lahenda nusaꞌ sanahulu dua mai, esaꞌko noꞌ nusa-namon. Ara fee nusa-namo sira ranade tuka sira esaꞌko bei-baꞌin naden. ");
INSERT INTO rgu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael maten neuꞌ teu ni natun esa telu hulu hitu. ");
INSERT INTO rgu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tehuu tititi-nonosi nara, esa musu no esa. De ara leo kofela mulai remeꞌ Hawila losa Syur, natoo no nusa Masir, naroo neu losa Asyur. ");
INSERT INTO rgu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ia nana Abraham anan Isak tutui na. ");
INSERT INTO rgu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tepoꞌ fo Isak sao Ribka, nana Isak teun haa hulu. Ribka papa ni, Betuel. Ma naa ni, Laban. Sira nana, lahenda Aram, reme Padan Aram mai. ");
INSERT INTO rgu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka ta boki fa. Huu ria na, de Isak hule-haradoi neuꞌ MANETUALAIN ela Ribka boki. Manetualain namanene huhule-haradoi na, boe ma Ribka nairu. ");
INSERT INTO rgu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Sekonaa te, ana nairu ana kaduaꞌ. Tehuu anaꞌ sira rafifiti raroo nai inan tein daleꞌ. Boe ma Ribka natane nai dalen daleꞌ nae, “Ubeaꞌ taon de ana kaduaꞌ ia ra, leo iaꞌ?” Basa de ana natane neuꞌ MANETUALAIN. ");
INSERT INTO rgu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","MANETUALAIN nataa nae, “Nai o tei ma daleꞌ, hapu lahenda nusaꞌ dua fo neuꞌ ko ara ramusu ao raroo. Neuꞌ ko muriꞌ a baraꞌai na lena neme uluꞌ a mai. Ma aꞌa a noi-tao soa neuꞌ fadi na.” ");
INSERT INTO rgu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Losa fai boboki na, boe ma Ribka boki ana kaduaꞌ, touꞌ mesan. ");
INSERT INTO rgu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ana uluꞌ a rou na pilas, ma ao-ina na nabubulu. Huu ria na de ara foin nade, Esau (hiiꞌ nae sama leoꞌ dedea fekeꞌ a sosoa na nae ‘kabubulus’). ");
INSERT INTO rgu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Basa ria, besaꞌ ko fadi na kalua. Tehuu ana homu neuꞌ aꞌa na eitika na. Huu ria na de ara foin nade, Yakob (hiiꞌ nae sama leoꞌ dedea fekeꞌ fo sosoa na nae ‘eitikaꞌ’). Faiꞌ fo boki dua si, nana Isak teun nee hulu. ");
INSERT INTO rgu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ana kaduaꞌ sira rambau-ina mai, Esau dadi manasopu kahereꞌ. Ana nahiiꞌ leo nai nura a. Tehuu Yakob lahenda hara taaꞌ, ma nahiiꞌ nahaniꞌ uma. ");
INSERT INTO rgu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak nahiiꞌ naaꞌ paa banda fuiꞌ. Huu ria na, de ana sue na Esau seliꞌ. Tehuu Ribka sue na Yakob seliꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Laiꞌ esa de Yakob nasu fufue, Esau besaꞌ ko sopu fali. Ana sota ma namalaa naan seli. ");
INSERT INTO rgu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ana nafada Yakob nae, “Fadi, e! Fee au kua pilas ma baiꞌ nai ureꞌ a, fo ua dei! Au amalaa an seliꞌ.” (Huu ria na de raloo ni rae, Edom, hiiꞌ nae sama leoꞌ dedea fekeꞌ fo sosoa na nae ‘pilas’). ");
INSERT INTO rgu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Boe ma Yakob nataa nae, “Malole a aꞌa. Tehuu loo fee au hak ulu-bau-ina ma dei!” ");
INSERT INTO rgu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nataa nae, “Ubea aleꞌ no hak ulu-bau-inaꞌ ria! O soan leo. Au amalaa an seliꞌ so. O sode malaiꞌ a, fo munin mai leo, huu fo au nau ua so.” ");
INSERT INTO rgu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tehuu Yakob dedea bali, nae, “Aꞌa, mahani deiꞌ! Aꞌa ka soo-supa dei mae, loo fee au hak ria.” Boe ma Esau soo-supa nae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Basa de Yakob sode feen kua fufue ria no roti. Esau naa-ninu basa, boe ma ana laꞌo heni aon. No ria na, Esau parsen heni ria hak ulu-bau-ina na. ");
INSERT INTO rgu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Laiꞌ esa de, nai nusaꞌ ria hapu fai laa-roes inaꞌ a, sama leoꞌ fai laa-roes tepoꞌ fo Abraham bei nasoda. De, Isak hule Abimelek, lahenda Filistin nara mane na, fo ana bisa leo nai Gerar. ");
INSERT INTO rgu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ana tao leo naꞌ, nana huu MANETUALAIN natudu Ao na neuꞌ ana so nae, “O bosoꞌ leo Masir mu. Neuꞌ ko Au atudu fee o mamana fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Maneniko o leo lalai muꞌ mamanaꞌ ria, neuꞌ ko Au sama-sama oo o, ma fee o ua-nale rupaꞌ ara. Neuꞌ ko Au tao a tititi-nonosi mara tamba dodouꞌ, sama leoꞌ ruuꞌ nai lalai. Ma Au fee o mo tititi-nonosim dae ia, no basa nusa nara katemaꞌ. Neme o tititi-nonosim mai, neuꞌ ko basa lahenda nusaꞌ nai dae-bafoꞌ a hapu ua-naleꞌ. No ria na, Au tao atetu hehelu Ka neuꞌ o papam Abraham. ");
INSERT INTO rgu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Au tao basa ia ra, nana huu o papa ma tuka Au hihii-nanau ka so, Au pareta ka, ma Au atoran ka.” ");
INSERT INTO rgu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","De Isak leo lalai neuꞌ Gerar. ");
INSERT INTO rgu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka lole na seli. De, tepoꞌ fo lahenda bainaꞌ sira rita ni, boe ma ara ratatane aoꞌ laꞌeneuꞌ ana. Tehuu Isak nataa nae, “Ribka nana au fadi ka.” Ana biiꞌ maneniko manaku nae ria sao na, neuꞌ ko ara raisan fo tonda ra Ribka. ");
INSERT INTO rgu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak leo namanoso nai naa so, laiꞌ esa boe ma maneꞌ a titiro nesiꞌ jandela, te ana nita Isak no Ribka dua si raholu ao ma radeꞌiꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Boe ma ana nadenu lahenda reu raloo Isak, de ana nasaꞌai ni nae, “Isak! Au bubuluꞌ matetuꞌ so, tebe inaꞌ ia nana o sao ma! Tehuu ubeaꞌ taon de o mae, ria nana o fadi ma?” Boe ma Isak nataa nae, “Leo iaꞌ, papa! Au biiꞌ, maneniko au ae ria nana au sao ka, bosoꞌ losa neuꞌ ko lehenda raisa au.” ");
INSERT INTO rgu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Basa de maneꞌ a nataa nae, “Maneniko hapu lahenda nai ia, suku no sao ma, tantu o sale ami so! Ubeaꞌ taon de o tao leo naꞌ neuꞌ ami?” ");
INSERT INTO rgu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Basa ria, boe ma Abimelek barataa ana raun ara nae, “Emi basa mafarereneꞌ matalolole! Emi bea riꞌ maparani fufudi-leleꞌo lahenda ia, do sao na, neuꞌ ko au huku a mate ni.” ");
INSERT INTO rgu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tepoꞌ ria, Isak naue-naosa nai nusaꞌ ria boe. Boe ma ana hapu faliꞌ buna-boaꞌ, laꞌi natun esa, nana huu MANETUALAIN bati-pala fee ni ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ria hata-heton tamba raroo, losaꞌ ana namasuꞌi naan seli. ");
INSERT INTO rgu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ria sapi nara, ma kedaeꞌ, bibi-lopo nara rama ate. Ria ana uma dale nara boe dodouꞌ. Losaꞌ lahenda Filistin eteꞌ ao nara roo ni. ");
INSERT INTO rgu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Fai a ulu na, Isak papan Abraham, ali ra oe dodoluꞌ dodouꞌ so. Tehuu besaꞌ ia lahenda Filistin ara, radofu etu katemaꞌ asa so. ");
INSERT INTO rgu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Basa boe ma mane Abimelek a dedea no Isak nae, “Isak! Malole lenaꞌ, o laꞌo ela nusaꞌ ia leo. Huu fo o kuasa ma lena heni ami so.” ");
INSERT INTO rgu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Boe ma Isak heoꞌ neme naꞌ mai, de fali seluꞌ neu leo nai Gerar bafaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Boe ma ana suu seluꞌ oe dodoluꞌ fo ara radofu etu si a. Ma ana fee oe dodoluꞌ sira ranade tuka nadeꞌ fo papa na foi a. ");
INSERT INTO rgu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak ata nara ali oe dodoluꞌ nai Gerar bafaꞌ a, boe ma ara ali laꞌe oe a mata na de nasapura deaꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tehuu Gerar manafoo nara, ara ralelena aoꞌ ro Isak manafoo nara, nana huu oe ria. Ara rae, “Ami oem ia!” Huu ria na, de Isak fee oe dodoluꞌ ria, nade Esek, fo sosoa na nae, ‘ralelena aoꞌ’. ");
INSERT INTO rgu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Basa ria, boe ma Isak lahenda nara ali seluꞌ oe dodoluꞌ esa bali. Tehuu ara ralelena aoꞌ bali, nana huu oe dodoluꞌ ria. Huu ria na, Isak fee oe dodoluꞌ ria nade, Sitna, fo sosoa na nae, ‘esa soaꞌ esa’. ");
INSERT INTO rgu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Basa ria, boe ma ana foa ela mamanaꞌ ria, de ali seluꞌ oe dodolu fekeꞌ esa bali. Oeꞌ ia sona ara ta ralelena aoꞌ soꞌ. Huu ria na, Isak fee oe dodoluꞌ ria nade, Rehobot, fo sosoa na nae, ‘mamana loan’. Ma ana dedea nae, “Besaꞌ ia, Manetualain fee ita leo nai dae loan so. Nai ia, besaꞌ ko ita bisa tamba dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Neme naaꞌ mai, boe ma Isak asa laꞌo bali fo nau reu leo rai Beer Syeba. ");
INSERT INTO rgu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Hatun ria, boe ma MANETUALAIN natudu Ao na neuꞌ ana ma dedea nae, “Isak! Au ia nana o papam Abraham Manetualain a. De, o bosoꞌ bii, huu fo Au anea-asalaꞌe o. Neuꞌ ko Au fee o ua-naleꞌ. Ma o tititi-nonosim neuꞌ ko tamba dodouꞌ. Au tao leo iaꞌ, nana huu Au hehelu ka neuꞌ o papa ma.” ");
INSERT INTO rgu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Basa de Isak lutu na mei tutunu-hohotuꞌ neuꞌ na. Boe ma ana hule makasi neuꞌ MANETUALAIN nai mamanaꞌ ria. Ana leo neuꞌ na, ma lahenda nara mulai ali seluꞌ oe dodoluꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Tepoꞌ ria, mane Abimelek neme Gerar mai. Ana sama-sama no tian Ahusat, ma ria parani musun, Fikol, mai dama Isak. ");
INSERT INTO rgu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Boe ma Isak natane nae, “Papa mane! Maulu na emi usi heni ami so. De besaꞌ ia emi nau mai tao ubeaꞌ bali?” ");
INSERT INTO rgu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Boe ma ara rataa rae, “Leo iaꞌ! Besaꞌ ia ami bubuluꞌ mae, Manetualain nanea o. Huu ria na, ami dodoo mae, malole lenaꞌ ita dua tao hekenee-barataaꞌ leo iaꞌ: O soo-supa mae, ");
INSERT INTO rgu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","neuꞌ ko emi ta tao tadaluꞌ neuꞌ ami, sama leoꞌ ami boe ta tao tadaluꞌ neuꞌ emi. Tebe ami dale mara malole a mo emi. Huu ria na, faiꞌ naa ra emi kalua memeꞌ ami dae ma mai no mole-dame. Ami bubuluꞌ matetuꞌ so, MANETUALAIN riꞌ fee emi ua-naleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Basa de, Isak tao feta fee si, boe ma basa si raa-rinu no namahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Balahaaꞌ, balahaa ana na, boe ma ara soo-supa. Basa boe ma Isak fee si fali no mole-dame. ");
INSERT INTO rgu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Faiꞌ ria, Isak lahenda manoi nara mai tui laꞌeneuꞌ oe dodoluꞌ fo ara ali a, rae “Papa! Ami hapu oe so.” ");
INSERT INTO rgu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Basa de Isak fee oe dodoluꞌ ria nade, Syeba, fo sosoa na nae ‘soo-supa’. De, ara fee kota ria nade, Beer Syeba losaꞌ besaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tepoꞌ fo Esau teun haa hulu, sao na ana fetoꞌ dua, remeꞌ leo Het mai. Esa nana Beeri anan, nade Yudit. Esa bali, Elon anan, nade Basmat. ");
INSERT INTO rgu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ina kaduaꞌ sira riꞌ, tao ra Isak no Ribka dale nara susa. ");
INSERT INTO rgu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak namalasi, de mata nasasapu naan seli so, boe ma naloo na ana ulu susue na nae, “Esau! O maiꞌ ia dei.” Esau nataa nae, “Ubeaꞌ, papa?” ");
INSERT INTO rgu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak nafada nae, “Leo iaꞌ! Au amalasi so. Au ta bubuluꞌ ae fai hidaꞌ mate fa. ");
INSERT INTO rgu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","De, mu hai ma o manara mara, fo mu sopu fee au banda fuiꞌ esa dei. ");
INSERT INTO rgu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Basa nana tunu-nasu mina-malada tuka au au hihii ka, fo muni fee au. Au ua basa, besaꞌ ko au fee memaꞌ o ua-naleꞌ. Maneniko fee basa ua-naleꞌ neuꞌ o, leo mae au mate boe malole.” ");
INSERT INTO rgu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Basa boe ma Esau neu sopu banda. Tehuu Ribka boe namanene Isak dedean ria. ");
INSERT INTO rgu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Basa de Ribka neu nafada Yakob nae, “Ae, Ako, ee! O nenene matalolole! Bisi naaꞌ a au amanene papa ma dedea no Esau nae, leo iaꞌ: ");
INSERT INTO rgu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘O mu sopu ma banda fuiꞌ esa, fo tunu-nasu mina-malada fee au. Maneniko au ua basa, sona neuꞌ ko au fee o ua-naleꞌ, nai MANETUALAIN mata Na.’ ");
INSERT INTO rgu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","De, o nenene matalolole! Tuka tebe-tebe au pareta ki ia. ");
INSERT INTO rgu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Besaꞌ ia, mu dama ita bibi nara, fo heke muni tena mapetaꞌ dua. Basa nana pau si, fo eꞌee ma paa nara, muni si leo au mai. Neuꞌ ko au tunu-nasu, tuka papa ma hihii na. ");
INSERT INTO rgu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Maneniko au tunu-nasu a si, sona muni fee papa ma fo naa. Basa te, neuꞌ ko ana fee o ua-naleꞌ dei, besaꞌ ko ana mate. No ria na, o riꞌ hapu ua-naleꞌ ria. Ta aꞌa ma fa.” ");
INSERT INTO rgu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tehuu Yakob dedea no mama na nae, “Mama! Masala na leo ia. Aꞌa Sau ao-ina na nabubulu, tehuu au ao-ina ka sona taꞌa! ");
INSERT INTO rgu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Bosoꞌ losa papa ka nafaroe laꞌe ao-ina ka, boe ma ana bubuluꞌ nae, au edi-fulen ni. Boe ma ana kutuk au!” ");
INSERT INTO rgu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Boe ma mama na nataa nae, “Ako, ee! O dale ma bosoꞌ dodaꞌ. Nemeꞌ na fo neuꞌ ko mama riꞌ ator! Maneniko papa ma kutuk o, nemeꞌ na ela mama riꞌ lepa nan! Besaꞌ ia, o mu mala bibi sira leo.” ");
INSERT INTO rgu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Basa de Yakob neu nala bibi sira, boe ma ana pau si, de neni paa nara leo mama na neu. Boe ma Ribka tunu-nasu si tuka Isak hihii na. ");
INSERT INTO rgu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Basa de Ribka neu hai na Esau papake malole nara, fo fee Yakob pake. ");
INSERT INTO rgu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ana poti etu Yakob lima nara no bolii na boe, pake bibi rouꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Boe ma ana fee Yakob nanaa mina-malada sira ma roti fo ana tao na si a. ");
INSERT INTO rgu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Basa de Yakob soꞌu neni nanaaꞌ sira fee papa na. Ana dedea nae, “Papa! Au mai riaꞌ so.” Boe ma Isak nataa nae, “He? Te, o nana bea?” ");
INSERT INTO rgu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob nataa nae, “Au ia nana, papa ka ana ulum, Esau! Au tao tuka hata fo bisinaaꞌ a papa ka madenu so a. Foa fo mua leo. Au tunu-nasu paaꞌ, fo riꞌ au sopu neme nura lain mai a. Papa ka mua leo, fo basa nana fee au ua-naleꞌ!” ");
INSERT INTO rgu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Basa de Isak dedea nae, “O kahereꞌ, oo! O bisa hapu lalaiꞌ banda leoꞌ na?” Boe ma Yakob nataa nae, “Au hapu ia, nana huu MANETUALAIN fo papa ka doꞌo-tabe ni a, Ana tulu-fali au.” ");
INSERT INTO rgu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Boe ma Isak naloo Yakob nae, “Maneneaꞌ maiꞌ mata ia, fo au afaroe soba o dei! O ia nana tebe Esau, do?” ");
INSERT INTO rgu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Basa de Yakob naneneaꞌ leo papa na neu, boe ma ana nafaroroe ni. Ana dedea nae, “Haraoeꞌ ia, sama leoꞌ Yakob haraoe na! Tehuu limaꞌ ia, Esau lima na!” ");
INSERT INTO rgu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tehuu Isak ta nalelaꞌ Yakob fa, nana huu lima nara rabubulu sama leoꞌ Esau. Tehuu ana sakaꞌ fee Yakob ua-naleꞌ, ");
INSERT INTO rgu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ana natane seluꞌ bali nae, “O ia nana, tebe-tebe Esau, do?” Yakob nataa nae, “Tebe, Papa!” ");
INSERT INTO rgu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Basa boe ma Isak dedea nae, “O loo fee paaꞌ sira mai, fo au ua. Basa nana au fee o ua-naleꞌ.” Yakob loo fee ni paaꞌ sira, ma feen oe anggor fo ninu. ");
INSERT INTO rgu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Basa ria, boe ma papa na dedea nae, “O ana ki on, ee! Maneneaꞌ maiꞌ ia, fo deꞌi au.” ");
INSERT INTO rgu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakob naneneaꞌ fo deꞌi ni, boe ma Isak hae na Esau papake nara boo na. Basa de, ana dedea fee Yakob ua-naleꞌ nae, “Au ana ka ao boo na sama leoꞌ moꞌ fo MANETUALAIN fee ua-naleꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ela leoꞌ bea na Manetualain naonda dinis a neme lalai mai, fo tao na o oka-tine mara dae na, namina! Ela leoꞌ bea na Ana fee o hade dodou-inaꞌ, ma anggor boaꞌ henu-sofeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Basa lahenda nusaꞌ ara dadi reuꞌ o atam, Ma basa leo lahenda nusaꞌ ara, fee hada-horomata neuꞌ o. Ela leoꞌ bea na o pareta basa toranoo mara, ma ara sundaꞌ undulaka nara reuꞌ o mata ma. Bea riꞌ kutuk o, sira boe hapu kutuk. Ma bea riꞌ fee o ua-naleꞌ, sira boe hapu ua-naleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak hule basa ua-naleꞌ, ma Yakob besaꞌ ko kalua foa ela papa na, boe ma aꞌan Esau fali neni banda fo riꞌ sopu nala a. ");
INSERT INTO rgu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Boe ma ana tunu-nasu, basa de neni fee papa na. Ana dedea nae, “Papa! Foa fo mua leo! Au tunu-nasu paaꞌ fo au sopu so a. Papa ka mua basa, sona fee au ua-naleꞌ leo.” ");
INSERT INTO rgu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Boe ma Isak noi namakokoaꞌ a, ma natane nae, “He! Te, o ia nana, bea bali?” Basa de Esau nataa nae, “Au ia nana, Esau! Papa ka ana ulu ma.” ");
INSERT INTO rgu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Boe ma Isak mulai dere. Basa de tou lasiꞌ a natane nae, “Maneniko leoꞌ na, sona bisinaaꞌ a, bea riꞌ neni fee au paaꞌ sira fo ua? Basa boe ma au fee ni ua-naleꞌ so. Ma, ta bisa faꞌu faliꞌua-naleꞌ ria soꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau namanene papa na dedea nae leoꞌ na, boe ma dale na hedis a, ma dola, ma dedea namberaina nae, “Adoo! Papa, ee! Fee au ua-naleꞌ boe dei, papa!” ");
INSERT INTO rgu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tehuu Isak nae, “O fadi ma mai de eediꞌ nalaꞌ au, ma namanaꞌo neni o ua-nalem so.” ");
INSERT INTO rgu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Boe ma Esau dedea nae, “Ana eediꞌ nalaꞌ au laꞌi dua ian so. Masososa na ana tipu-dai na au hak ulu-bau-ina ka. Besaꞌ ia ana tipu-dai na au ua-naleꞌ ka bali. Rina ko ana naraa nade, ‘Yakob’. Tehuu, papa ka bei manuu ua-nale fekeꞌ fee au boe, do?” (nadeꞌ Yakob sosoa na nae, ‘homu neuꞌ eitikaꞌ’. Tehuu ana nanuu sosoa fekeꞌ nae, ‘mantipu-mandaiꞌ’.) ");
INSERT INTO rgu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Basa boe ma Isak nataa nae, “Au soꞌu an dadi neuꞌ o malaka ma so. Ma basa toranoo nara, dadi reuꞌ ria atan. Au feen hade no anggor dodou-inaꞌ, ma anggor henu-sofeꞌ. De ana ki on, ee! Besaꞌ ia bei hapu ua-nale ubeaꞌ bali, fo au fee o?” ");
INSERT INTO rgu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau namanene leoꞌ na, boe ma ana laꞌa papa na naroo nae, “Papa ka ua-nale ma adaꞌ noi esaꞌ a, do? Tantu papa ka bei bisa saka fee au ua-nale fekeꞌ. Leo mae ua-nale aanaꞌ boe oo, malole.” Boe ma ana mulai dola bali. ");
INSERT INTO rgu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Basa ria, boe ma Isak nataa natafaliꞌ ana nae, “O soda ma neuꞌ ko dooꞌ a meme oka-tine mandadiꞌ a mai, huu fo ta hapu dinis onda neme lalai mai ela tao naoe o dae ma. ");
INSERT INTO rgu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","O tafa ma riꞌ neuꞌ ko neni fee o sodaꞌ. Tehuu leo mae leoꞌ bea oo, o dadi ata neuꞌ o fadi ma. Noi maneniko o bisa soaꞌ ana fo masekin, o besaꞌ ko poꞌi ma aom meme ria lima na mai.” ");
INSERT INTO rgu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau eteꞌ aon mamateꞌ no Yakob, nana huu ana nalea na ria ua-nale na so. Tehuu ana dodoo nae, “Ta dooꞌ a soꞌ, te papa ka maten. De mahani. Maneniko basa papa ka fai nara, neuꞌ ko au aisa ni!” ");
INSERT INTO rgu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Ribka namanene Esau duduꞌa-aafin ria, boe ma ana naloo na Yakob, ma nae, “O nenene matalolole! O aꞌa ma nau balas dale hedi na, fo naisa o. De, malale fo malai leo toꞌo mi Laban mu nai Haran. ");
INSERT INTO rgu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mu leo mamanoso nai naa, losaꞌ aꞌa ma ta namasa no o soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Maneniko ana nafarene heni hata fo o tao ni neuꞌ ana so a, neuꞌ ko au adenu lahenda raloo faliꞌ o. Huu fo au ta nau ana ki dua si mopo belaꞌ asa nai faiꞌ esa dalen.” ");
INSERT INTO rgu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Basa de Ribka dedea no Isak nae, “Au doaꞌ o Esau saon lahenda Het sira so! Maneniko Yakob boe sao ana feto Het bali, na malole lenaꞌ au mate leoꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isak naloo na tutiꞌ Yakob, boe ma ana feen ua-naleꞌ ma lelea-nonoreꞌ nae, “Nenene matalolole! O bosoꞌ sao ana feto Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tehuu o leo Padan Aram mu, nai baꞌi Betuel uman. O muu sao ma toꞌo mi Laban ana feton esa. ");
INSERT INTO rgu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ela leoꞌ bea na Manetualain fo Manakuasa Nan Seli, riꞌ fee o ua-naleꞌ, ela o upu-ana mara tamba dodouꞌ, ma dadi reuꞌ lahenda nusa kahereꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ela leoꞌ bea na Manetualain hehehelu-barataan neuꞌ Abraham a tuda leo o neu, ma o tititi-nonosim. Ela leoꞌ bea na o soa dae ia, fo riꞌ Manetualain helu basa feen neuꞌ Abraham so.” ");
INSERT INTO rgu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak dedea basa nae leoꞌ na, boe ma ana nadenu Yakob leo Padan Aram neu, nai toꞌon Laban no baꞌin Betuel uman. ");
INSERT INTO rgu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau namanene nae, Isak fee basa ua-naleꞌ neuꞌ Yakob so, ma horo ni fo bosoꞌ sao ana feto Kanaꞌan. Ana namanene boe, nae papa na nadenu fadi na so, fo neu sao toꞌo na ana feton esa nai Padan Aram. ");
INSERT INTO rgu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Basa de Yakob namanene neuꞌ papa na no mama na paretan, boe ma ana leo Padan Aram neu. ");
INSERT INTO rgu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau boe bubuluꞌ nae, papa na ta nahiiꞌ ria sao na, lahenda Kanaꞌan ara. ");
INSERT INTO rgu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","De, ana leo papa bauinan Ismael neu, de sao na seluꞌ Ismael ana feton, nade Mahalat. Mahalat nana, Nebayot fadi na. ");
INSERT INTO rgu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Basa boe ma, Yakob laꞌo ela Beer Syeba, fo sakaꞌ leo Haran neu. ");
INSERT INTO rgu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ledo a tena, boe ma ana losa mamanaꞌ esa, de suku neuꞌ na. Ana sakaꞌ suku, boe ma hai na batu esa de ainulu neuꞌ lain. ");
INSERT INTO rgu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Hatun ria nalamei. Ana nita edaaeꞌ esa, nanaseleꞌ nai dae a, ma peda na losa lalai. Basa de Manetualain eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai, ara onda-ae resiꞌ edaaeꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nai meis ria daleꞌ, Yakob nita MANETUALAIN napadei nai boboa na, basa de dedea nae, “Au ia MANETUALAIN, o baꞌim Abraham, ma o papam Isak Manetualain a. Neuꞌ ko Au fee dae ia neuꞌ o, ma tititi-nonosi mara. ");
INSERT INTO rgu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Neuꞌ ko o tititi-nonosim dedesi na sama leoꞌ afu-dae. Ma neuꞌ ko ara kofela nai basa mamanaꞌ ara. Neme o tititi-nonosim mai, neuꞌ ko basa lahenda nusaꞌ nai dae-bafoꞌ a hapu ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mafarerene matalolole! O leo beaꞌ mu oo, Au sama-sama ma anea o. Neuꞌ ko Au o faliꞌ o leo nusaꞌ ia mai. Au ta foa ela o mesaꞌko fa. Ma neuꞌ ko Au tao atetu basa Au hehelu-barataaꞌ fo Au feen neuꞌ o a.” ");
INSERT INTO rgu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Fai fo Yakob foa na aon, boe ma ana nae, “Au besaꞌ ko bubuluꞌ ae MANETUALAIN nai ia boe!” ");
INSERT INTO rgu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma ana bii, boe ma afi nae, “Ae! Mamanaꞌ ia tao na au ao ka maninis a. Tantu Manetualain uma Na nai ia. Ma ia nana, nusatetu-ikutemaꞌ a lelesu na.” ");
INSERT INTO rgu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Balahaaꞌ, balahaa ana na, boe ma Yakob foa de hai na tutiꞌ batu fo riꞌ ainulu neuꞌ lai ni a, de napadedeiꞌ nan dadi neuꞌ tanda. Basa de ana poꞌa mina neuꞌ batu ria, fo doꞌo-tabe neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ana hule mamanaꞌ ria nade, Betel, fo sosoa na, ‘Manetualain uma na’. (Maulu na mamanaꞌ ria, nade Lus). ");
INSERT INTO rgu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Basa ria, boe ma Yakob soo-supa nae, “Kalu Manetualain sama-sama, ma nanea nai au lalaꞌo ki ia, ma nahao-nafati au, ");
INSERT INTO rgu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","losaꞌ au fali no *soda-moleꞌ, neuꞌ ko MANETUALAIN dadi neuꞌ au Ramatua ka. ");
INSERT INTO rgu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Batu fo au apadedeiꞌ ana ia, dadi mamana dodoꞌo-tatabeꞌ neuꞌ Manetualain. Ma basa-basan fo Manetualain bati fee au, neuꞌ ko au fee faliꞌ babatiꞌ esa neme babatiꞌ sanahulu mai.” ");
INSERT INTO rgu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Basa riaꞌ boe ma Yakob laꞌo naroo leo dulu neu. ");
INSERT INTO rgu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Faiꞌ esa, boe ma ana nita oe dodoluꞌ esa naneneaꞌ no koroꞌ esa. Naneneaꞌ nai naa, hapu kedaeꞌ, bibi-lopo bubuaꞌ telu ara rahani fo rinu oe. Tehuu batu bauinaꞌ esa mantatanaꞌ nai oe dodoluꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Biasa kalu kedaeꞌ, bibi-lopo ra basa si tesa, sona besaꞌ ko manafoo ra eso heni batu ria, fo aso oe fee banda sira rinu. Rinu basa, nana ara tatana seluꞌ batu a neuꞌ oe dodoluꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Boe ma Yakob neu natane manafoo sira nae, “Ae! Emi meme beaꞌ mai?” Ara rataa rae, “Ami meme koro Haran mai.” ");
INSERT INTO rgu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Basa de Yakob natane bali nae, “Emi malelaꞌ au toꞌo ki Laban, do? Ria nana Nahor anan.” Boe ma ara rataa rae, “Ami malelaꞌ ana.” ");
INSERT INTO rgu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Boe ma Yakob natane naroo bali nae, “Ana soda-moleꞌ, do?” Ara rataa rae, “Tou lasiꞌ a soda-moleꞌ. Soba mete. Ana feto na riꞌ naꞌ, nade Rahel, foo neni bibi nara, mai fo hani si rai ia. O mahani leo.” ");
INSERT INTO rgu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Basa de Yakob dedea bali nae, “Besaꞌ ia, ledo a bei nai lain. De, malole lenaꞌ banda fo rabua rai ia, sona emi hani si leo. Basa nana foo meni si leo moꞌ reu fo raa nau-aidoo bali.” ");
INSERT INTO rgu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tehuu ara radedea laka rae, “Ae! Ta bisa leo naꞌ fa! Ami muste mahani basa manafoo ra reni banda nara, mabubua si rai ia dei. Besaꞌ ko ami eso heni batu ria, fo fee banda ra rinu.” ");
INSERT INTO rgu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob bei dedea no lahenda sira, te Rahel foo neni papa na bibi nara losa so. Ria riꞌ biasa foo banda sira. ");
INSERT INTO rgu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakob nita Rahel no bibi nara, boe ma ana neu eso heni oe dodoluꞌ ria batu tatana na. Boe ma ana fee toꞌo na banda nara rinu. ");
INSERT INTO rgu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Basa boe ma ana holu na Rahel de deꞌin ma dola. ");
INSERT INTO rgu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ana tui Rahel nae, “Fadi, ee! Au ia nana o papa ma feton Ribka anan.” Boe ma, Rahel nalai neun de nafada papa na. ");
INSERT INTO rgu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Fai fo Laban namanene Rahel tui laꞌeneuꞌ Yakob, feto ni Ribka ana na, boe ma nalai fo neu soruꞌ ana. Naneta noo ni, boe ma Laban holu nan de deꞌin, basa de no Yakob leo uma reu. Boe ma Yakob tui basa-basan neuꞌ Laban. ");
INSERT INTO rgu_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Basa boe ma Laban dedea nae, “Tebe leoꞌ na! Ita dua kileoboboki esa!” ");
INSERT INTO rgu_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Yakob leo no si losa bulaꞌ esa so, ");
INSERT INTO rgu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban dedea noo ni nae, “Leo iaꞌ, Ako! Au ta nau o moi-tao hihiiꞌ fee au, nana huu ita dua kileobobokiꞌ esa. O hule kadi ma bau bea?” ");
INSERT INTO rgu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na, Laban nanuu ana fetoꞌ dua. Uluꞌ a nade Lea. Fadiꞌ a nade Rahel. ");
INSERT INTO rgu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea mata makanaroꞌ. Tehuu Rahel sona napuꞌ mesan, ma ao-ina na deseꞌ-dese. ");
INSERT INTO rgu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob nahiiꞌ Rahel. De, ana nataa Laban nae, “Au oi-tao fee toꞌo ka teuꞌ hitu, sadi toꞌo ka fee au sao Rahel.” ");
INSERT INTO rgu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban nataa nae, “Au sipoꞌ! Berako au fee Rahel sao lahenda fekeꞌ, malole lenaꞌ sao o, au kileoboboki ka! De, o leo mahaniꞌ ia, fo moi-tao fee au.” ");
INSERT INTO rgu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakob noi-tao teuꞌ hitu, ela bisa hapu Rahel. Tehuu ana nahiiꞌ na Rahel seli. De, teuꞌ hitu nana, ana nameda nan nonooꞌ nae adaꞌ noi faiꞌ hidaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Basa teu kahituꞌ sira, boe ma Yakob nafarereneꞌ fee Laban nae, “Toꞌo! Au oi-tao fee toꞌo ka teuꞌ hitu ian so, de besaꞌ ia fee au sao Rahel leo.” ");
INSERT INTO rgu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Boe ma Laban tao feta kakabiꞌ, ma naloo basa lahenda rai nusaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Hatun ria, Laban ta fee Rahel fa, tehuu ana fee Lea masoꞌ leo Yakob mamana leleon daleꞌ neu. De, Yakob suku noꞌ ana. Balahaꞌ besaꞌ ko Yakob bubuluꞌ nae, ana sao Lea. Boe ma Yakob neu nadedea laka no Laban nae, “Ubeaꞌ taon de toꞌo ka edi au leo iaꞌ? Au oi-tao sota an seliꞌ teuꞌ hitu, ela hapu Rahel! Tehuu ubeaꞌ taon de toꞌo ka kati ni neniꞌ Lea?” Basa de Laban nataa nae, “O bosoꞌ mamanasa leoꞌ na! Tuka ami nai ia hada ma, fadiꞌ a ta bole sao nauluꞌ aꞌa a. De, malole lenaꞌ leo iaꞌ dei! O mahani losaꞌ basa feta kakabiꞌ ia faiꞌ hitu dei. Besaꞌ ko o hapu Rahel, sadi o moi-tao fee au teuꞌ hitu bali.” Basa de Laban fee ria ata inan, nade Silpa fo dadi neuꞌ Lea atan. ");
INSERT INTO rgu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob nataa. Huu ria na, de basa feta a faiꞌ hitu, boe ma Laban fee Rahel sao Yakob. ");
INSERT INTO rgu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Basa de Laban fee ata inan esa bali, nade Bilha, fo dadi neuꞌ Rahel atan. ");
INSERT INTO rgu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Basa boe ma Yakob suku noꞌ Rahel. Ana sue Rahel lena heni Lea. Boe ma ana noi-tao tamba seluꞌ teuꞌ hitu fee arama na. ");
INSERT INTO rgu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tehuu MANETUALAIN bubuluꞌ Yakob sue Rahel lena heni Lea. Basa de Ana fee noi Lea boki. Tehuu Rahel ta boki fa. ");
INSERT INTO rgu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Basa boe ma Lea nairu, de boki na ana touꞌ esa. Ana foi anaꞌ ria nade, Ruben (sosoa na nae, ‘mitaꞌ, hapu anaꞌ’), nana huu ana nae, “Tebe MANETUALAIN nita au susa ka so. Huu ria na, de besaꞌ ia au sao ka boe nau relu-natanae au.” ");
INSERT INTO rgu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Basa ria, boe ma Lea nairu bali, de boki na ana touꞌ esa. Ana foi anaꞌ ria nade, Simeon, (sosoa na nae, ‘lahenda ramanene so’), nana huu ana nae, “MANETUALAIN namanene so nae, sao ka ta tao daleꞌ neuꞌ au. Huu ria na, de Ana fee tamba seluꞌ au anaꞌ esa bali.” ");
INSERT INTO rgu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Basa ria, boe ma Lea nairu bali, de boki na ana touꞌ esa. Ana foi ana ria nade, Lewi, nana huu ana nae, “No anaꞌ ia, basa au dedea ka so. Tantu au sao ko nanahekeꞌ no au, nana huu au boki feen ana touꞌ telu so.” ");
INSERT INTO rgu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Basa boe ma Lea nairu bali, de boki na ana touꞌ esa. Ana foi ana ria nade, Yahuda (sosoa na nae, ‘io-oa’), nana huu ana nae, “Oeꞌ ia, au nau io-oa MANETUALAIN!” Basa ria, boe ma Lea ta boki soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tehuu Rahel bei ta hapu anaꞌ fa. Huu ria na, de namanasaꞌ aꞌa na. Boe ma dedea no sao na nae, “Aꞌa! Fee au anaꞌ dei! Kalu taꞌa, sona malole lenaꞌ au mate leo.” ");
INSERT INTO rgu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Boe ma Yakob nasapaa ni nae, “O bate mae Manetualain riꞌ au, fo bisa fee o anaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Basa boe ma, Rahel dedea nae, “Leo iaꞌ! Malole lenaꞌ, papa sao ma au ata ki Bilha. Mu suku moꞌ ana, ela boki fee au anaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ana fee Bilha neuꞌ sao na. Boe ma Yakob suku noꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha nairu, de boki na ana touꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel dedea nae, “Manetualain namanene au huhule-haradoi ka so. Huu ria na, de Ana fee au ana touꞌ esa so. Manetualain naetuꞌ au dedea ka no, matetuꞌ.” De ana foi anaꞌ ria nade, Dan (sosoa na nae, ‘naetuꞌ dedeaꞌ’). ");
INSERT INTO rgu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha nairu bali, de boki na ana touꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel dedea nae, “Au asudi susuraꞌ o aꞌa ka so, de aseki ni.” Huu ria na, de ana foi anaꞌ ria, nadeꞌ Naftali (sosoa na nae, ‘nasudi susuraꞌ’, do nahohoe aoꞌ’). ");
INSERT INTO rgu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea nameda nan ana ta boki soꞌ, boe ma fee ata ni Silpa leo sao na neu, ela sao nan. ");
INSERT INTO rgu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Basa de Silpa boki ana touꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea dedea nae, “Au ua-nale ka malole a so.” Boe ma ana foi anaꞌ ria nade, Gad (sosoa na nae, ‘ua-nale malole’). ");
INSERT INTO rgu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa boki na seluꞌ ana touꞌ esa bali. ");
INSERT INTO rgu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Basa de Lea dedea nae, “Ae! Besaꞌ ia besaꞌ ko au amahoꞌo! Meten, te neuꞌ ko basa inaꞌ ara dedea rae, au aua-anale an seli.” Huu ria na, de foi anaꞌ ria nade, Aser (sosoa na nae, ‘namahoꞌo’). ");
INSERT INTO rgu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Laiꞌ esa de, laꞌe fai ooruꞌ, Ruben leo nura lain neu, boe ma ana nita ai-doo esa, fo lahenda rae ai-doo ria bisa tao na inaꞌ ara boki. Boe ma ana neni fee maman Lea. Rahel nita leoꞌ na, boe ma ana hule Lea nae, “Aꞌa, ee! Ruben neni modo-aidoo ria a, bati fee au baiꞌ deiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tehuu Lea nataa nae, “Ae! O ia, talalu maan seli so! O malea ma au sao ka so. Besaꞌ ia, o nau roso ma modo-aidoo ria neme au ana ka mai bali? O ta maeꞌ malelaꞌ boeꞌ.” Tehuu Rahel dedea nae, “Leo iaꞌ, aꞌa. Maneniko au hapu modo ai-doo ria, sona hatun ia o suku moꞌ Yakob.” Boe ma Lea nataa. ");
INSERT INTO rgu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ledo leo dae na, Yakob fali nemeꞌ okaꞌ mai. Boe ma Lea neu naneta noo ni ma dedea nae, “Ako! O muste suku mo au hatun ia! Huu fo au bae memaꞌ o so, uniꞌ au ana ka modo-aidoon.” Basa de, Yakob suku no Lea hatun ria. ");
INSERT INTO rgu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Basa de Manetualain namanene Lea huhule-haradoin. Huu ria na, ana nairu de boki ana tou kalima a. ");
INSERT INTO rgu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Boe ma Lea foi anaꞌ ria nade, Isaskar (sosoa na nae, ‘bae sosotaꞌ’), nana huu ana nae, “Manetualain bae au sosota ka so, huu fo au fee Silpa sao na au sao ka.” ");
INSERT INTO rgu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Basa boe ma, Lea nairu bali, de boki ana tou ka nee a. ");
INSERT INTO rgu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ana dedea nae, “Manetualain fee au hadia malole so. De besaꞌ ia au sao ka muste hadaꞌ au, nana huu au boki feen ana touꞌ nee lalaꞌen.” Huu ria na, ana foi ana ria nade, Sebulon (sosoa na nae, ‘fee hada-horomata’). ");
INSERT INTO rgu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Basa ria, de Lea boki na ana inaꞌ esa, boe ma ana foi ni nade, Dina. ");
INSERT INTO rgu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Manetualain nafarene Rahel, boe ma namanene huhule-haradoi na. Huu ria na, de Ana buka anamana na. ");
INSERT INTO rgu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Basa de, Rahel nairu, boe ma boki na ana touꞌ esa. Ana nae, “Manetualain tuꞌu-tapa heni au mata mamae ka so.” ");
INSERT INTO rgu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Boe ma ana foi anaꞌ ria nade, Yusuf (sosoa na nae, ‘ela ana fee tamba seluꞌ’), nana huu ana nae, “Au hule fo Manetualain tamba fee seluꞌ au ana touꞌ esa bali.” ");
INSERT INTO rgu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Tepoꞌ fo Rahel boki Yusuf so, Yakob dedea no Laban nae, “Papa! Kalu bisa, sona au fali leo nusa-namo ka uu dei. ");
INSERT INTO rgu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ela leoꞌ bea na au fali ma oo sao-ana kara. Papa ka bubuluꞌ so, au oi-tao sota an seliꞌ fee papa ka, de au bae etu si so. Huu ria na, besaꞌ ia sira nana au hak asa.” ");
INSERT INTO rgu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Boe ma arama na nataa nae, “Ana ki, on! O nenene dei. Au amaladaꞌ basa so, de bubuluꞌ ae Manetualain fee au ua-naleꞌ nana huu o. ");
INSERT INTO rgu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Na, besaꞌ ia o hule bau bea boe au bae! Sadi o leo adaꞌ ia, ma moi-tao maroo fee au.” ");
INSERT INTO rgu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Basa de Yakob nataa nae, “Papa ka mita mataꞌ so, au oi-tao sota an seli. Huu ria na, de papa ka banda mara tamba raroo. ");
INSERT INTO rgu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tepoꞌ fo au bei ta mai fa, nana papa ka hata-hetom bei ta dodouꞌ. Tehuu besaꞌ ia papa ka mamasuꞌi so. Manetualain bati fee papa ka ua-naleꞌ so, nana huu au nonoi-tatao ki. Besaꞌ ia losa ledo-fain so, fo au oi-tao fee sao-ana kara bali.” ");
INSERT INTO rgu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Basa boe ma Laban natane nae, “De au muste bae tao o leoꞌ bea?” Yakob nataa nae, “Papa ka bosoꞌ fee au hata-hata esa boe. Neuꞌ ko au aboi aroo papa ka banda mara, sadi au bisa tao hata esa. ");
INSERT INTO rgu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Fee au lelaꞌ, fo faiꞌ ia boe uu dama papa ka banda mara, fo here kedaeꞌ ma bibi-lopo. Ta dedetaꞌ, ma ta baraetaꞌ ara, sona papa ka num sira. Tehuu dedetaꞌ, ma baraetaꞌ ara, sona au soa sira. Ma au hai a katemaꞌ bibi-lopo keoꞌ ara. Basa sira nana lole leoꞌ bae neuꞌ au sosota ka. ");
INSERT INTO rgu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nai fai a mabui, neuꞌ ko papa ka bisa bubuluꞌ au ia nana roo-tetuꞌ, do taꞌa. Sudi faiꞌ bea a, papa ka bisa mai parisaꞌ au banda kara. Maneniko mita kedaeꞌ fo ta dedetaꞌ, ma ta baraetaꞌ, do bibi-lopo fulaꞌ, sona papa ka bubuluꞌ mae, au amanaꞌo papa ka banda mara.” ");
INSERT INTO rgu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Basa boe ma Laban nataa nae, “Malole! Leo naꞌ leo.” ");
INSERT INTO rgu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tehuu, faiꞌ ria boe Laban heo heni basa banda dedetaꞌ ara, baraetaꞌ ara, ma bibi-lopo keoꞌ ara. Basa de ana nadenu ana nara fo urus banda sira. ");
INSERT INTO rgu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Boe ma ara foo reni banda sira leo mamanaꞌ esa reu, dodoo na laꞌo eiꞌ faiꞌ telu nemeꞌ Yakob mai. Yakob bei naboi nahere arama na bibin fo bei ela a. ");
INSERT INTO rgu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Basa ria, boe ma Yakob tati na ai-huu rupaꞌ telu rana nara, de ana lelefo rou nara. ");
INSERT INTO rgu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ana tao ai rana manlelefo rouꞌ sira reuꞌ banda ra mamana nininu nara. Banda ra rahiiꞌ rasaoꞌ nai mamana nininuꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","De, tepoꞌ fo banda ra rasaoꞌ rai ai rana manalelefo rouꞌ sira matan, neuꞌ ko boki ra ana nara te, bulu na boe dedetaꞌ ma baraetaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Tepoꞌ fo Laban banda nara sakaꞌ rasaoꞌ, Yakob fee si rasare leo banda dedetaꞌ ma baraetaꞌ ara reu. Basa te sira ana nara boe dedetaꞌ ma baraetaꞌ. No ria na, boe ma ria banda nara tamba dodou. Basa de ana heo heni si reme Laban banda nara mai. ");
INSERT INTO rgu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tepoꞌ fo banda baraꞌaiꞌ ara rasaoꞌ, Yakob tao ai rana manlelefo rouꞌ sira reuꞌ mata nara, nai sira mamana nininun. ");
INSERT INTO rgu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tehuu maneniko nita banda kalanaꞌu ara rasaoꞌ, sona ana ta tao ai rana manlelefo rouꞌ sira, reu fa. De Laban hapu basa banda kalanaꞌu ara. Tehuu Yakob hapu basa banda baraaiꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","No ria na, Yakob namasuꞌi naan seli. Ria bibi nara, onta, keledei, ma ata nara dodouꞌ raan seli. ");
INSERT INTO rgu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laiꞌ esa, de Yakob namanene Laban ana nara bei dea rae, “Yakob namasuꞌi naan seli so, nana huu ana aro nameti ita papa na hata nara.” ");
INSERT INTO rgu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob boe nita araman Laban mata-idun ta naleleka, ma ta malole a noo ni sama leoꞌ maulu na soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Boe ma MANETUALAIN dedea no Yakob nae, “Besaꞌ ia losa ledo-fain so. De, o muste fali leo ina-ama mara mu leo. Neuꞌ ko Au sama-sama o o.” ");
INSERT INTO rgu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Basa boe ma, Yakob nadenu reu raloo Rahel no Lea, fo mai ranetaꞌ roo ni nai banda ra mamana na, nai moꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Basa de ana nafada si nae, “Besaꞌ ia au ita emi papa ma mata-idun ta raleleka no au soꞌ. Ma ana ta malole a no au sama leoꞌ maulu na soꞌ. Tehuu Manetualain fo au papa ka doꞌo-tabe ni a, sama-sama no au. ");
INSERT INTO rgu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Emi dua bubuluꞌ, doo-naru basa ia, au oi-tao sotaꞌ an seliꞌ fee emi papa ma. ");
INSERT INTO rgu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tehuu leo mae leoꞌ na boe, ana bei tipu namiminaꞌ au kose-kose. Ana kati au seseba-babae ka losaꞌ laiꞌ sanahulu. Leo mae leoꞌ na boe, Manetualain nanea nahere au. ");
INSERT INTO rgu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tepoꞌ fo emi papa ma dedea nae, ‘Banda dedetaꞌ sira, dadi neuꞌ o seseba ma,’ boe ma, banda ra boki te ana nara dedetaꞌ mesan. Fai fekeꞌ ana dedea bali nae, ‘Besaꞌ ia, banda baraetaꞌ ara, dadi reuꞌ o seseba-babaem,’ boe ma banda sira boki te basa si baraetaꞌ mesan. ");
INSERT INTO rgu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Manetualain tao leo naꞌ, fo ela Ana heo na emi papa ma banda nara, fo fee au. ");
INSERT INTO rgu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Laiꞌ esa de, tepoꞌ fo naraa no banda ra ledo-fai sasao nara, au ita nai mei-afeꞌ daleꞌ nae, basa banda maneꞌ fo raba banda inaꞌ a, hapu ruma baraetaꞌ, ma hapu dedetaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Basa de Manetualain eilaꞌo-limalopen neme nusatetu-ikutemaꞌ a mai, naloo au nai mei-afeꞌ daleꞌ nae, ‘Yakob, ee!’ Au ataa ae, ‘Ia, Manetualain?’ ");
INSERT INTO rgu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Boe ma Ana nafada nae, ‘Mete dei! Basa banda maneꞌ fo kahoaꞌ ara, nana adaꞌ noi baraetaꞌ, ma dedetaꞌ ara. Au riꞌ ator basa sira, nana huu Au ita hata fo Laban tao ni neuꞌ o so a. ");
INSERT INTO rgu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au ia nana Manetualain, fo riꞌ Au atudu Ao ka neuꞌ o, nai Betel a. O mapadedeiꞌ batu nai naa, basa de poꞌa mina neuꞌ lain, fo doꞌo-tabe neuꞌ Au. Basa de o heke hehelu-barataaꞌ mo Au nai naa. Besaꞌ ia o muste foa ela nusaꞌ ia, fo fali leo ina-ama mara nusa-namon mu.’ ” ");
INSERT INTO rgu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Boe ma Rahel no Lea rataa rae, “Neu! Ami tuka-tuka mesan! Huu fo ami ta hapu hata posakaꞌ neme papa Laban mai soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Doo-naru basa ia, tou lasiꞌ a tao ami sama leoꞌ lahenda dea. Ana seꞌo heni ami so. Boe ma naa heni ami beli-paa mara so. ");
INSERT INTO rgu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Basa hata-heto fo Manetualain hai neme papa Laban mai, nana besaꞌ ia dadi neuꞌ ami mo ana mara posakan so. De maneniko Manetualain nae leoꞌ bea, sona tuka leo.” ");
INSERT INTO rgu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Basa de Yakob mulai nafafau hata-heto nara. Boe ma ana nasasaꞌe sao-ana nara basa si reuꞌ onta lain, ma foo neni katemaꞌ banda nara, ma hata-heto fo ana hapu nai Padan Aram, de ara fali leo dae Kanaꞌan reu. ");
INSERT INTO rgu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Faiꞌ ria, Laban neu kuti bibi-lopo nara bulun. Boe ma Rahel namanaꞌo neni papa na patung sosoko nara. ");
INSERT INTO rgu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob asa laꞌo ramanininoꞌ, ma ta nafada arama na fa. ");
INSERT INTO rgu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ana neni katemaꞌ hata-heto nara, ara laꞌo rapue rarooꞌ a, tuka lee Efrat, de ralaka leo lete Gilead reu. ");
INSERT INTO rgu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Basa faiꞌ telu, boe ma Laban hapu haraꞌ nae, Yakob asa foa laꞌo so. ");
INSERT INTO rgu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Boe ma Laban nabubua na lahenda nara, fo reu usi tuka manafeu na. Ara usi losaꞌ faiꞌ hitu, besaꞌ ko hapu si rai lete Gilead. ");
INSERT INTO rgu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nahatu, boe ma Manetualain natudu Ao na neuꞌ Laban nai mei-afes daleꞌ. Ana nae, “Laban! Maneniko o dedea mo Yakob, sona manea matalolole bafa ma.” ");
INSERT INTO rgu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Hatun ria, Yakob napadedeiꞌ mamana leleo na nai lete Gilead. Ma Laban asa boe rapadedeiꞌ sira mamana leleo na ta dooꞌ a neme naꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Basa de Laban mai naneta no Yakob. Boe ma ana dedea nae, “He, Yakob! Ubeaꞌ taon de o malai mo au ana feto kara, namanininoꞌ leo iaꞌ? Sama leoꞌ o heke mo lahenda neme musu daleꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Medaꞌ o malai mamanininoꞌ, ta mateꞌa sudi au boeꞌ! Kalu o mafada matalolole au, tantu au tao feta bauinaꞌ, fo afuli emi pake musik, besaꞌ ko poꞌi emi fo laꞌo. ");
INSERT INTO rgu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","O sala mi esa bali, riꞌ o ta fee au lelaꞌ fo deꞌi upu-ana kara, besaꞌ ko fee si laꞌo. O enom ia pakanaa heta! ");
INSERT INTO rgu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ma mudaꞌ laesaꞌ au bisa tao soe fee o! Tehuu leodaeꞌ a, Manetualain fo riꞌ o papa ma doꞌo-tabe ni a nasaꞌai au nae, maneniko au dedea o o, au muste anea atalolole bafa ka. ");
INSERT INTO rgu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tebe au bubuluꞌ ae, o laꞌo, nana huu mahiiꞌ fali. Tehuu ubeaꞌ taon de o bei mamanaꞌo muni au patung sosoko kara?” ");
INSERT INTO rgu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Basa boe ma Yakob nataa nae, “Toꞌo bosoꞌ mamanasa mo au! Au laꞌo amanininoꞌ a, nana huu au biiꞌ, bosoꞌ losa toꞌo ka ena ma anaꞌ ara, sona leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tehuu Yakob ta bubuluꞌ nae, saon Rahel riꞌ namanaꞌo neni patung sosokoꞌ sira. De, ana nae, “Toꞌo! Laꞌeneuꞌ patung ria, sona saka si leo! Maneniko hapun nai bea, sona huku maisan. Ofe katemaꞌ asa! Maneniko toꞌo ka hapu hata posaka feke mi, sona hai faliꞌ asa. Ela leoꞌ bea na lahenda ia ra sakasii.” ");
INSERT INTO rgu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Basa de Laban neu ofe sira esa-esa mamana leleon. Masososa na Yakob mamana leleo na. Basa ria boe ma ata inan dua si mamana leleon. Tehuu ana ta nita patung sira fa. Mateꞌe oe na, ana masoꞌ leo Rahel mamana leleo na neu. ");
INSERT INTO rgu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tehuu Rahel nafuni patung sira rai onta a sela na sordalen. Basa de natuu neuꞌ sela ria lain. Laban ofe lutu-lutu nai Rahel mamana leleo na, tehuu ta nita si fa. ");
INSERT INTO rgu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Boe ma Rahel dedea no papa na nae, “Papa ka bosoꞌ mamanasa. Au ta bisa foa apadeiꞌ fa, huu fo au amahedi ina.” Laban saka naroo, tehuu ana ta nita patung sira fa. ");
INSERT INTO rgu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Basa de Yakob nasa na lua, boe ma nasapaa Laban nae, “Au tao asalaꞌ toꞌo ka ubeaꞌ? Losaꞌ toꞌo ka usi ami, dadiꞌ lahenda tadaluꞌ! ");
INSERT INTO rgu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Toꞌo ka ofe katemaꞌ au hata-heto kara so. Basa de toꞌo ka hapu ubeaꞌ? Soba tao si maiꞌ mata ia, fo ita basa tita! Ela leoꞌ bea na lahenda ia ra raetuꞌ, hata sira nana bea nuun. ");
INSERT INTO rgu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Teuꞌ duahulu au kuli fee toꞌo ka. Tepoꞌ fo au foo toꞌo ka banda mara, ta hapu esa alahendi boeꞌ. Au ta ua esa boeꞌ! ");
INSERT INTO rgu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Maneniko banda fui maꞌaaꞌ ara ramate toꞌo ka bandam esa, au ta afada fa, tehuu au kati. Ma kalu lahenda ramanaꞌo ra toꞌo ka bandam sona madenu fo au kati, leo mae au ta sala fa. ");
INSERT INTO rgu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Leledoꞌ, sona ledo a haa na au seliꞌ. Hatuꞌ, sona au dere sauꞌ-sauꞌ. Au mete mata isi ka losaꞌ ta bisa suku fa, nana huu anea toꞌo ka banda mara. ");
INSERT INTO rgu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tebe teuꞌ duahulu ria nana, laꞌe! Au oi-tao teuꞌ sanahulu haa, fo hapu toꞌo ka ana feto mara. Basa ria, boe ma au oi-tao tamba seluꞌ teuꞌ nee bali, ela au bisa hapu banda kara. Au dadi kuli dooꞌ a leoꞌ na, tehuu toꞌo ka kati au seseba ka losaꞌ laiꞌ sanahulu. ");
INSERT INTO rgu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mauaꞌ a de Manetualain fo baꞌi Abraham ma papa Isak doꞌo-tabe ni a. Kalu Ana ta nanea au, tantu toꞌo ka usi faliꞌ au no lima rouꞌ. Tehuu Manetualain ta nasuku mata na soaneuꞌ au susa ka, ma Ana relu-natanae au nonoi-tatao kara. Huu ria na, de leodaeꞌ a Ana mai nasaꞌai toꞌo ka.” ");
INSERT INTO rgu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban namanene basa Yakob dedean sira, boe ma ana nataa nae, “Leo iaꞌ! Ana inaꞌ sira dua, nana au ana kara. Anaꞌ fo boki ra si a, nana au upu ki katemaꞌ sira. Basa banda ia ra, au nuu ki. Basa-basan fo o mita si rai ia, tebe au nuu ki. Tehuu au bei nau tao ubeaꞌ? Au ta bisa ena si fa. ");
INSERT INTO rgu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","De malole lenaꞌ ita dua heke hehelu-barataaꞌ. Ma ita muste tasoda tuka heheluꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Basa de, Yakob eso na batu bauinaꞌ esa, de napadedeiꞌ ana neuꞌ naa, dadi tanda. ");
INSERT INTO rgu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Boe ma Yakob nadenu lahenda nara, fo reu bau batu, fo raunu. Boe ma basa si ratuuꞌ raa-rinu raneneaꞌ batu sira. ");
INSERT INTO rgu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Boe ma Laban fee batu maunuꞌ ria nade, Yegar Sahaduta. Tehuu Yakob feen nade Galeed. ");
INSERT INTO rgu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Basa de Laban nae, “Batu maunuꞌ ia, dadi sakasii neuꞌ ita dua.” Huu ria na, mamanaꞌ ria nade, Galeed. ");
INSERT INTO rgu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban boe fee mamanaꞌ ria nade, Mispa (sosoa na nae, ‘mamana naneaꞌ madema’), nana huu ana dedea nae, “Neuꞌ ko MANETUALAIN riꞌ nanea ita dua, de leo mae ita dua esa dooꞌ a no esa boe, ita bosoꞌ lena hehelu-barataaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Maneniko o tao tadaluꞌ neuꞌ au ana ki ia ra, fo sao ina fekeꞌ ara, tantu au ta bubuluꞌ fa. Tehuu mafarereneꞌ! Manetualain riꞌ dadi sakasii neuꞌ ita dua. ");
INSERT INTO rgu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Soba mete maneni batu mapadedeiꞌ ma maunuꞌ ia ra. Mafarereneꞌ batu ia ra boe, dadi too-lane. O ta bole kani seli batu ia ra, fo tao tadaluꞌ au. Ma au boe ta bole kani seli batu ia ra, fo tao tadaluꞌ neuꞌ o. ");
INSERT INTO rgu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ita heke hehelu-barataaꞌ ia, pake ita bei-baꞌin Manetualain a. Riꞌ o baꞌim Abraham, ma au baꞌi ki Nahor Manetualain a. Neuꞌ ko Ria riꞌ dadi mana ee dedeaꞌ, fo naetuꞌ ita dua dedean.” Yakob namanene basa leoꞌ na, boe ma ana soo-supa mamateꞌ, pake nadeꞌ neme Manetualain, fo ria papan Isak doꞌo-tabe Ni a. ");
INSERT INTO rgu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Basa ria boe ma, Yakob pau banda, de neni tutunu-hohotuꞌ fee Manetualain nai leteꞌ ria lain. Ana naloo na basa lahenda ra, de ara raa-rinu no namahoꞌo, ma ara mete ralaꞌ malua nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Balahaaꞌ, balahaa ana na, boe ma Laban neu de holu ma deꞌi basa upu-ana nara. Basa de ana hule fee si ua-naleꞌ, boe ma ana fali leo nusa na neu. ");
INSERT INTO rgu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Basa de, Yakob asa laꞌo raroo. Boe ma Manetualain eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai raneta roo ni. ");
INSERT INTO rgu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ana nita si boe ma, dedea nae, “Ia nana Manetualain soldadu nara mamana hahaen ia, ma!” Huu ria na, de ana fee mamanaꞌ ria, nadeꞌ Mahanaim (sosoa na nae, ‘mamana hahaeꞌ dua’). ");
INSERT INTO rgu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Basa boe ma Yakob nadenu ata ni hida, laꞌo rauluꞌ leo nusa Edom (riꞌ, Seir), fo reu rafada aꞌan Esau rae, ana noi mai. ");
INSERT INTO rgu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob nafada ata nara nae, “Emi meu mafada aꞌa ki Esau mae leo iaꞌ: ‘Papa Esau! Papa ata ma, fo fadim Yakob haitua haraoe soda-moleꞌ dodouꞌ neuꞌ papa. Neme maulu na au lalaꞌo ka, losaꞌ besaꞌ ia, papa atam ia leo nai toꞌo Laban uma na. ");
INSERT INTO rgu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Besaꞌ ia papa ata mi ia, nanuu sapi, keledei, bibilopo-kedaeꞌ, ma ata touꞌ ma inaꞌ. Au adenu lahenda ia ra mai rauluꞌ, reni haraoeꞌ fee papa rae au sakaꞌ mai. Au amahehenaꞌ, papa nau sipo ami no dale loaꞌ.’ ” Boe ma lahenda sira reu. ");
INSERT INTO rgu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tepoꞌ fo fali seluꞌ leo Yakob mai, ara tui rae, “Ami meu de maneta mo papa ka aꞌam Esau so. Besaꞌ ia ana tuka mai nai deaꞌ ia, noo touꞌ natunhaa, fo nau raneta ro papa.” ");
INSERT INTO rgu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakob namanene leoꞌ na, boe ma tende na toko, ma ana bii namateꞌ aon. Basa de, ana bati lahenda nara ma banda ra katemaꞌ asa, reuꞌ bubuaꞌ dua. ");
INSERT INTO rgu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ana afi nae, “Maneniko Esau mai, fo neu suu bubua masososaꞌ a, na bubua kadua a bisa ralai *ra ao nara.” ");
INSERT INTO rgu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Basa boe ma Yakob hule-haradoi nae, “Oo Manetualain! Manetualain fo riꞌ baꞌi Abraham, ma au papa ki Isak doꞌo-tabe a. Mamanene au dei! Tepoꞌ fo, Manetualain madenu au fali seluꞌ leo kileoboboki kara uu, nai nusaꞌ ia. Manetualain helu mae neuꞌ ko ator, fo tao matetu basa-basan. ");
INSERT INTO rgu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au ta araa sipoꞌ Manetualain susue-lalaim, no nasuru-nahapa ma. Maulu na tepoꞌ fo au hana lee Yarden ia, au uni adaꞌ noi teteꞌe. Tehuu besaꞌ ia au fali mai, uni lahenda bubuaꞌ dua, ma banda-manuꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au biiꞌ, bosoꞌ losa aꞌa Esau mai suu, fo tao namate ami basa. De, au hule fo Manetualain poꞌi-tata ma au, ma basa sao-ana kara, neme aꞌa Esau mai. ");
INSERT INTO rgu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Manetualain helu mae fee au ua-naleꞌ dodouꞌ, ma tao ma au tititi-nonosi kara ramefu, sama leoꞌ soroaeꞌ nai tasiꞌ a suu na, de lahenda ta reke rala si fa.” ");
INSERT INTO rgu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Basa de Yakob suku neuꞌ mamanaꞌ ria. Balahaaꞌ, boe ma ana heo banda, fo nau parseen aꞌa na. ");
INSERT INTO rgu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ana heo na kedae inaꞌ natun dua, maneꞌ dua hulu, bibi-lopo inaꞌ natun dua, maneꞌ dua hulu, ");
INSERT INTO rgu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","onta inaꞌ telu hulu, roo ana mana susu nara, sapi inaꞌ haa hulu, sapi maneꞌ sanahulu, keledei inaꞌ dua hulu, ma keledei maneꞌ sanahulu. ");
INSERT INTO rgu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Basa de, ana heo banda sira, rupaꞌ esaꞌ ko noꞌ bubuan. Ana fee bubuaꞌ sira esaꞌko noꞌ manafoon. Ana nafada si nae, “Emi laꞌo mauluꞌ. Neuꞌ ko au tuka dea. Tehuu emi manea, fo ela bubuaꞌ esa doo a baiꞌ nemeꞌ esa mai.” ");
INSERT INTO rgu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Basa de, Yakob pareta manafoo nemeꞌ bubua masososaꞌ a nae, “Maneniko aꞌa Esau naneta no o, ma natane nae, ‘O sakaꞌ leo beaꞌ mu? O ia nana bea atan? Banda ia ra, nana bea nuun?’ ");
INSERT INTO rgu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Na, emi muste mataa mae, ‘Banda ia ra, nana papa ata mi Yakob nuun. Ana haitua fee aꞌan, papa Esau. Ana bei mai nai deaꞌ.’ ” ");
INSERT INTO rgu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Ana fee pareta leo naꞌ neuꞌ basa manafoo bubua fekeꞌ ara nae, “Maneniko maneta mo aꞌa Esau, sona emi parsen feen banda sira. Ma mafadan mae, au bei tuka dea.” Yakob afi nae, kalu ana fee katemaꞌ banda sira reuꞌ Esau, neuꞌ ko Esau dale na balanau non. ");
INSERT INTO rgu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","De ana haitua nauluꞌ banda sira. Tehuu hatun ria, ana bei nahaniꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Hatun ria, Yakob foa na aon, boe ma ana ator saon dua si, ma sao uma dalen dua si, ma anan sanahulu esa, fo lena leo lee Yabok a seriꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Fai fo basa si losa seriꞌ, boe ma ana haitua basa hata posaka nara naaꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tehuu Yakob mesaꞌ ana nahaniꞌ ria. Boe ma touꞌ esa mai, de dua si rakale ao, losaꞌ lole maluaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Touꞌ a nameda nan sakaꞌ seki ni, boe ma ana fae fee Yakob neuꞌ pau na, losaꞌ dui sesesu na osiꞌ neme mamana na mai. ");
INSERT INTO rgu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Boe ma touꞌ ria nae, “Poꞌi au leo, huu fo ledo a sakaꞌ tii mai riaꞌ so.” Tehuu Yakob nataa nae, “O mafada fee au ua-naleꞌ dei, besaꞌ ko au poꞌi o!” ");
INSERT INTO rgu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Boe ma touꞌ ria natane nae, “O nade, bea?” Ana nataa nae, “Yakob.” ");
INSERT INTO rgu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Basa de, touꞌ ria dedea nae, “O ta nade Yakob soꞌ. Mulai besaꞌ ia lahenda raloo o, sona rae, Israel, nana huu o soaꞌ lahenda dae-bafoꞌ a, ma Manetualain, losaꞌ o maseki.” (Nadeꞌ Israel sosoa na nae, ‘nakale ao no Manetualain’.) ");
INSERT INTO rgu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Boe ma Yakob natane nae, “O nade, bea?” Tehuu touꞌ ria nataa nae, “O nau matane au nade ka, tao ubeaꞌ?” Basa de, ana dedea fee Yakob ua-naleꞌ nai mamanaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Basa boe ma Yakob dedea nae, “Au ita mataꞌ Manetualain so, tehuu au bei asoda.” Huu ria na, ana fee mamanaꞌ ria nade, Peniꞌel, sosoa na nae, ‘Manetualain mata-idun’. ");
INSERT INTO rgu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakob laꞌo ela mamanaꞌ ria nana ledo a demaꞌ a so. Tehuu ana laꞌo noi sekaꞌ a, nana huu pau na osiꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Huu ria na, losaꞌ besaꞌ ia lahenda Israel ara raluli banda paa pau buꞌu, nana huu Manetualain fae nalutu sira baꞌin Yakob pau buꞌu na. ");
INSERT INTO rgu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Fai ria, Yakob nita Esau mai, no lahendan natun haa. Basa de ana bati ana nara esaꞌko noꞌ maman. ");
INSERT INTO rgu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ana ator de fee sao uma dale ni dua si resiꞌ uluꞌ. Basa de Lea no ana nara, besaꞌ ko Rahel no anan Yusuf resiꞌ buiꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tehuu Yakob nesiꞌ mata nauluꞌ basa si. Ana sakaꞌ naneneaꞌ no aꞌa na, boe ma ana sundaꞌ undulaka na, ma naloe aon losa dae a, laiꞌ hitu. ");
INSERT INTO rgu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tehuu Esau nita fadi na, boe ma nalai neu soruꞌ ana, de holu nan ma deꞌin, Boe ma dua si radola ao. ");
INSERT INTO rgu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau nita inaꞌ ara ro ana nara, boe ma natane nae, “Te basa lahenda ia ra nana, bea?” Boe ma Yakob nataa nae, “Sira nana, lahenda fo Manetualain fee au so, fo aꞌa ka ata ma.” ");
INSERT INTO rgu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Basa boe ma sao ana uma daleꞌ ara, ro ana nara reu doꞌo Esau. ");
INSERT INTO rgu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Basa de Lea no ana nara mai doꞌo Esau. Mabui oeꞌ a, Yusuf no maman Rahel mai doꞌo Esau. ");
INSERT INTO rgu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Basa de Esau natane nae, “Banda bubuaꞌ fo bisinaaꞌ a, o haitua nana sosoa na, ubea?” Boe ma Yakob nataa nae, “Leo iaꞌ, aꞌa! Au parseen aꞌa ka basa sira, fo ela leoꞌ bea na aꞌa ka sipoꞌ au no dale loaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tehuu Esau nataa natafaliꞌ nae, “Fadi Yakob! Au hata-heto ki boe dodouꞌ. De o bosoꞌ boe fee au hata-hata esa bali.” ");
INSERT INTO rgu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakob nataa nae, “Aꞌa, bosoꞌ tao leo naꞌ! Aꞌa ka muste sipo maa si, fo dadi tanda esa nae, aꞌa ka sipoꞌ au no dale loaꞌ. Huu fo bisinaaꞌ a au ita aꞌa ka huhume ma, nonooꞌ leo au ita Manetualain huhume na. ");
INSERT INTO rgu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","De, au hule no hada-hormata, fo ela leoꞌ bea na aꞌa ka sipo ma au hadia sosoa-raraa taa ki ia ra. Huu fo Manetualain malole na seliꞌ neuꞌ au, de Ana fee basa-basan fo au parluu a.” Yakob lameoꞌoe naroo ni, losaꞌ nau do ta nau fa, Esau sipo na hata hadia sira. ");
INSERT INTO rgu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Basa ria, boe ma Esau dedea nae, “Leoꞌ na, sona emi mahehere ao mara fo teu leo! Neuꞌ ko au laꞌo sama-sama o emi.” ");
INSERT INTO rgu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tehuu Yakob nataa nae, “Nemeꞌ na, aꞌa! Aꞌa ka mita mataꞌ. Anaꞌ ara bei aanaꞌ, ma ta bisa laꞌo ralaiꞌ a fa. Ma banda boki beuꞌ ara, boe dodouꞌ. Maneniko ita laꞌa si fo laꞌo ralaiꞌ a, nai faiꞌ esa dalen, sona neuꞌ ko mate basa banda ia ra. ");
INSERT INTO rgu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","De, malole lenaꞌ aꞌa kasa laꞌo mauluꞌ leo. Ami basa laꞌo bai-bai tuka dea. Neuꞌ ko au eti dama aꞌa ka nai Seir.” ");
INSERT INTO rgu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Basa ria, Esau dedea bali nae, “Kalu leoꞌ na, sona au laꞌo ela ana uma daleꞌ ruma roo o, ela ratudu emi enoꞌ a.” Tehuu Yakob nae, “Aꞌa ka bosoꞌ masapute huu ami! Sadi au bubuluꞌ ae aꞌa ka sipoꞌ au so.” ");
INSERT INTO rgu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esau namanene leoꞌ na, boe ma ana laꞌo ela si, de fali leo Seir neu. ");
INSERT INTO rgu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tehuu neme naꞌ mai Yakob leo Sukot neu. Ana tao uma neuꞌ naa, ma tao okaꞌ fee basa banda nara. Huu ria na, mamanaꞌ ria, nade Sukot (sosoa na nae, ‘uma ofu’). ");
INSERT INTO rgu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Mateꞌe oe na, Yakob asa reme Padan Aram mai leo koro Sikem reu, nai nusa Kanaꞌan, ara losa no soda-moleꞌ. Ara rapadedeiꞌ mamana leleoꞌ, fo leo raneneaꞌ koroꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dae fo riꞌ Yakob napadedeiꞌ mamana leleo na a, ana asa nan neme Hemor, Sikem papa na. Ana bae neniꞌ doi fulaꞌ natun esa. ");
INSERT INTO rgu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ana lutu batu tao mei tutunu-hohotuꞌ neuꞌ naa. Basa de ana fee mamanaꞌ ria, nade El-Elohe-Israel, sosoa na nae, ‘Manetualain nana, Israel Manetualain a’. ");
INSERT INTO rgu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Laiꞌ esa de, Yakob no Lea ana feton, Dina, neu dama ana fetoꞌ ara rai nusaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nusaꞌ ria mane na, nade Hemor, neme leo Hewi. Ana mane na, nade Sikem. Laiꞌ esa de Sikem nita Dina, boe ma nalai noo ni, de ana hohoken. ");
INSERT INTO rgu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem nahiiꞌ Dina, ma sue nan seliꞌ. De, Sikem dedea balananau no Dina, fo ela leoꞌ bea na Dina boe nahiiꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Basa de, Sikem nafada papa na nae, “Papa! Au hule fo meu matane Dina fee au, ela au bisa sao an.” ");
INSERT INTO rgu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob namanene nae lahenda hohoke ana feto na so, tehuu ana nee-nee, ma ta tao hata esa boeꞌ. Huu fo tepoꞌ ria, ana tou nara ranea banda rai moꞌ. De, ana nahani losaꞌ basa si fali. ");
INSERT INTO rgu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Faiꞌ ria, Sikem papan Hemor leo Yakob neu, fo nau natane Dina fee Sikem. ");
INSERT INTO rgu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Naraa no dua si dedea raon ara, boe ma Yakob ana nara fali reme moꞌ mai. Ara ramanene rae Sikem hohoke sira feto na, boe ma dale nara hedis a, ma ramanasa ran seliꞌ. Basa de ara rae, “Hata rupa leo naꞌ a, ta naraa hapun nai Israꞌel fa. De, ita ta bole sipoꞌ lahenda mana tao tadalu rupa leo naꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Boe ma Hemor ooe-leleꞌo Yakob asa nae, “Toranoo Yakob! Au ana ki Sikem tebe-tebe nahiiꞌ na toranooꞌ a ana feto ma seli so. De, au hule fo fee au ana ka sao nan. ");
INSERT INTO rgu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Maneniko bisa, sona ita ana nara rasao ao. Emi ana tou mara sao ami ana feto mara. Ma ami ana tou mara sao emi ana feto mara. ");
INSERT INTO rgu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ma ela leoꞌ bea na emi leo mabua mo ami nai ia. Emi here ao mara, mahiiꞌ leo meuꞌ bea a. Basa nana seꞌo-asa, ma hapu hata-heto nai ia.” ");
INSERT INTO rgu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Basa ria, boe ma Sikem dedea no Dina papa na, ma aꞌa nara nae, “Emi nau hule ubeaꞌ oo, au tuka-tuka mesan. Emi hule doi natetu mataꞌ, ma belis ara hida boe oo, au bae. Sadi emi mataa fo au sao emi feto ma.” ");
INSERT INTO rgu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tehuu Yakob ana nara bubuluꞌ rae, Sikem hohoke sira fadin Dina so. De, ara rataa fufudiꞌ Sikem no papan Hemor. ");
INSERT INTO rgu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Basa de rataa rae, “Ami ta bisa fee ami fadi ma sao lahenda fo ta sunat fa! Ria tao namamaeꞌ ami! ");
INSERT INTO rgu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tehuu eno kalua na leo iaꞌ: Basa emi tou mara, aana-bauinaꞌ muste sunat sama leoꞌ ami. ");
INSERT INTO rgu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Maneniko emi tao leo naꞌ, sona besaꞌ ko ita tasao ao. Ma ami boe bisa leo mabua mo emi nai ia, fo ita dadi teuꞌ lahenda nusaꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tehuu maneniko emi ta nau tuka ami hihii-nanaum, ma ta nau sunat, neuꞌ ko ami hela faliꞌ ami fadi ma, basa nana ami laꞌo ela mamanaꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor no Sikem sipoꞌ dedeaꞌ ria no malole. ");
INSERT INTO rgu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tehuu Sikem ta nanenete soꞌ, nana huu nahiiꞌ na Dina seli. Na, basa lahenda nai nusaꞌ ria hadaꞌ neuꞌ Sikem. ");
INSERT INTO rgu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","De, Hemor no Sikem leo mamana parisa dedeaꞌ a nai koroꞌ a kota bafa na, basa de ara dedea raoꞌ ro basa lahenda rai nusaꞌ ria. Ara dedea rae, ");
INSERT INTO rgu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Basa toranoo kara emin! Lahenda Israel ara rahiiꞌ leo mole-dame ro ita. De nemeꞌ naa, fo ela ara leo sama-sama ro ita nai nusaꞌ ia. Nusaꞌ ia loaꞌ a soaneuꞌ ita basa. Ita bisa sao sira ana feto nara. Sira boe bisa sao ita ana feto nara. ");
INSERT INTO rgu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ara hule adaꞌ noi hata anaꞌ esa, nemeꞌ ita mai. Riiꞌ basa ita tou ara sunat sama leoꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Maneniko ita leo tabua, neuꞌ ko sira banda-manun, ma basa hata-heto nara boe, dadi reuꞌ ita hata posakan, hete? De, malole lenaꞌ ita tuka sira hihii-nanaun. Mai fo ita basa sunat belaꞌ a! Mataa, do?” ");
INSERT INTO rgu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Basa lahenda fo rabua rai na, rataa tuka Hemor no Sikem dedean. Boe ma basa touꞌ fo rai nusaꞌ ria, ara sunat belaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Fai katelu na, tepoꞌ fo mansunat ara hina nara bei hedi sa, boe ma Dina aꞌan Simeon no Lewi lesu ra tafa nara, de masoꞌ rafufuniꞌ leo koroꞌ daleꞌ reu. De raisa basa touꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ara raisa Hemor no Sikem boe. Boe ma Ara hela ra Dina, neme Sikem uman daleꞌ mai, de roo faliꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Basa de, Yakob ana feke nara masoꞌ leo nusaꞌ daleꞌ reu, de roso reni nusaꞌ ria hata nara katemaꞌ. Ara ramanasa, nana huu lahenda hohoke sira feto na nai na so. ");
INSERT INTO rgu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ara roso ra katemaꞌ lahenda hatan fo rai uma daleꞌ, ma foo reni lahenda banda-manun katemaꞌ reme moꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ara reni basa inaꞌ ara roo ana nara, ma roso reni nusaꞌ ria bua-loas mabeli nara katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakob namanene hata ria, boe ma ana dedea no Simeon ma Lewi nae, “Emi tao nonoi pakanaa ubeaꞌ ia? Emi tao masususaꞌ au! Neuꞌ ko lahenda Kanaꞌan ara, lahenda Peris, ma basa nusaꞌ ia lahenda nara, eteꞌ ao nara ro ita. Sira lahenda nara dodouꞌ. Tehuu ita adaꞌ noi baianaꞌ. Maneniko ara mai suu ita, sona sopuꞌ nala ita.” ");
INSERT INTO rgu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tehuu ara rataa no nasaꞌ rae, “Papa! Papa ka bate mae ami mataaꞌ asa, fo tao ami fadi ma dadi neuꞌ ina mansosoa!” ");
INSERT INTO rgu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Basa ria, boe ma Manetualain dedea no Yakob nae, “Au ia, Manetualain, fo Au atudu Ao ka neuꞌ o, tepoꞌ fo malai meme aꞌam Esau mai. Besaꞌ ia, o lali Betel mu leo. Losa nai naa, sona o mafoa mei tutunu-hohotuꞌ fee Au. Basa nana leo muꞌ na.” ");
INSERT INTO rgu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Boe ma, Yakob dedea no basa uma isi nara nae, “Besaꞌ ia, ita basa sakaꞌ leo Betel teu. Maulu na tepoꞌ fo au nai susa daleꞌ a, Manetualain tulu-fali au nai naa. Au nau apadedeiꞌ mei tutunu-hohotuꞌ nai naa. De besaꞌ ia, emi tuꞌu heni patung hata sosoko mara katemaꞌ. Tao makamoi ao-ina mara, ma kati papakeꞌ, huu fo ita sakaꞌ doꞌo-tabe neuꞌ Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Boe ma ara fee heni patung sosokoꞌ ma ante nara katemaꞌ. Basa de Yakob nadofu etu basa hata sira, rai ai-huu inaꞌ esa huu na naneneaꞌ koro Sikem. ");
INSERT INTO rgu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tepoꞌ fo Yakob asa laꞌo ela Sikem, Manetualain tao na bibiiꞌ lahenda nusa maneneaꞌ sira, losaꞌ ara ta raparani tao tadadalu Yakob asa. ");
INSERT INTO rgu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Boe ma Yakob no basa lahenda nara losa Betel no soda-mole *(fo maulu na nade, Lus), nai dae Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nai naa Yakob lutu mei tutunu-hohotuꞌ neme batu a mai. Basa de ana fee mamanaꞌ ria nade, El Betel, (sosoa na nae, ‘Betel Manetualain a’), nana huu maulu na Manetualain natudu Ao na neuꞌ Yakob nai naa, tepoꞌ fo nalai neme aꞌa na mai. ");
INSERT INTO rgu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Naneneaꞌ no koro Betel, hapu ai-huu inaꞌ esa, fo lahenda feen nade, Alon Bakut. Sosoa na nae, ‘ai-huu boreuꞌ’. Aihuuꞌ a nade ria, nana huu Ribka maman fo anutu ni a, nade Debora, maten de ratoin neuꞌ ai ria huu na. ");
INSERT INTO rgu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tepoꞌ fo Yakob fali neme Padan Aram mai so, Manetualain natudu seluꞌ Ao na bali, ma fee ni ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Manetualain dedea nae, “Mulai neme besaꞌ ia mai, o ta nade Yakob soꞌ. Tehuu Au fee o nade bebeuꞌ, riꞌ Israel. ");
INSERT INTO rgu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Au ia, Manetualain Manakuasa naan seli. De, o boki fo maupu-maanaꞌ dodouꞌ leo! Neuꞌ ko lahenda nusaꞌ ara dadi reme o tititi-nonosim mai. Ma neuꞌ ko o boki ma maneꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nusaꞌ fo Au feen neuꞌ o baꞌim Abraham, ma papam Isak so a, besaꞌ ia Au feen neuꞌ o mo tititi-nonosi mara.” ");
INSERT INTO rgu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Manetualain dedea basa leoꞌ na, boe ma Yakob napadedeiꞌ na dii batu esa neuꞌ naa, fo ela dadi tanda nafarereneꞌ neuꞌ Manetualain hehelu na. Boe ma ana poꞌa oe anggor, ma mina neuꞌ batu ria lain, fo doꞌo-tabe neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ana fee mamanaꞌ ria nade, Betel. ");
INSERT INTO rgu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Basa boe ma, Yakob asa laꞌo ela Betel. Fai fo ara raneneaꞌ Efrata (riꞌ Betlehem), Rahel nameda bobokin so. Tehuu boboki na nareo. ");
INSERT INTO rgu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tepoꞌ fo ana bei nanasa, boe ma ina mabobokiꞌ a nafada ni nae, “Mama Rahel! Matetea dale ma, huu fo mama ka hapu ana touꞌ bali!” ");
INSERT INTO rgu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rahel sakaꞌ mate ni, boe ma ana foi anaꞌ ria nade, Ben-Oni, (sosoa na nae, ‘anaꞌ neme au doidoso ka mai’). Basa boe ma maten. Tehuu Yakob foi anaꞌ ria nade, Benyamin (sosoa na nae, ‘anaꞌ lima boa onaꞌ’). ");
INSERT INTO rgu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Basa boe ma ara ratoi Rahel nai enoꞌ, fo leo Efrata neu a, suu na (fo besaꞌ ia nade, Betlehem). ");
INSERT INTO rgu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Boe ma Yakob lutu na batu rates esa neuꞌ naa. Losaꞌ fai ia, Rahel batu raten ria bei nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Basa ria boe ma Yakob leo lali-lali naroo. Laiꞌ esa de, ana napadedeiꞌ mamana leleoꞌ nai manara Eder boboa na. ");
INSERT INTO rgu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tepoꞌ fo ara leo rai naa, Ruben suku noꞌ, papa na sao uma dalen, Bilha. Yakob bubuluꞌ hata ria. Yakob ana toun sanahulu dua. ");
INSERT INTO rgu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ana nara, siꞌ: Ruben (Yakob ana ulu na), Simeon, Lewi, Yahuda, Isaskar, ma Sebulon. ");
INSERT INTO rgu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel ana nara, siꞌ: Yusuf ma Benyamin. ");
INSERT INTO rgu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel ana uma dalen, Bilha ana nara siꞌ: Dan ma Naftali. ");
INSERT INTO rgu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Boe ma Lea ana uma dalen, Silpa ana nara, siꞌ: Gad ma Aser. Boki anaꞌ sira rai Padan Aram. ");
INSERT INTO rgu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Basa ria, boe ma Yakob neu dama papan Isak, nai Mamre, naneneaꞌ koro Kiriat-Arba (riꞌ besaꞌ ia nade, Hebron). Maulu na, baꞌin Abraham leo nai naa boe. ");
INSERT INTO rgu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak nasoda losaꞌ teun natun esa falu hulu, besaꞌ ko mate ni. Boe ma anan Esau no Yakob ratoin. ");
INSERT INTO rgu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ia nana Esau tititi-nonosi nara. Ria boe nanuu nade fekeꞌ, Edom. ");
INSERT INTO rgu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau sao ana feto Kanaꞌan dua. Esa, lahenda Het, Elon ana feto na, nade Ada. Kadua na lahenda Hewi, nade Oholibama, papa na nade Anah, ma baꞌi na, nade Sibeon. ");
INSERT INTO rgu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau boe sao Ismael ana feto na, nade Basmat. Basmat aꞌa tou na, nade Nebayot. ");
INSERT INTO rgu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau sao ulun, Ada boki na Elifas. Basmat boki na Rehuel. ");
INSERT INTO rgu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Boe ma Oholibama boki na Yeus, Yalam, ma Kora. Esau ana nara boki si rai nusa Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Laiꞌ esa de, Esau lali leo nusa fekeꞌ esa neu, dooꞌ a neme Yakob mai. Ana noo sao-anan, lahenda mana noi ra, banda-manuꞌ, ma basa hata-heton. ");
INSERT INTO rgu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau no Yakob esaꞌko matan, nana huu banda-manu ma hata-heto nara dodouꞌ raan seli. De rasetiꞌ nusaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Boe ma Esau (riꞌ Edom), neu leo nai nusa lete marerebiꞌ ara nai Seir. ");
INSERT INTO rgu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ia nana, Esau tititi-nonosin, fo rae ‘lahenda Edom’. Ara leo rai nusa lete marerebiꞌ ara rai Seir. ");
INSERT INTO rgu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau saon Ada, boki ana touꞌ esa, nade Elifas. Elifas ana toun lima. Siꞌ, Teman, Omar, Sefo, Gatam ma Kenas. Elifas sao nafufuni na, nade Timna. Ria boki ana touꞌ esa, nade Amalek. Esau saon Basmat boki ana touꞌ esa, nade Rehuel. Rehuel hapu ana touꞌ haa, siꞌ: Nahat, Sera, Syama ma Misa. ");
INSERT INTO rgu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau saon Oholibama, riꞌ Anah ana na, fo Sibeon upu na, boki ana touꞌ telu, siꞌ: Yeus, Yalam, ma Kora. ");
INSERT INTO rgu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau upu-ana nara kofela dadi reuꞌ leo dodouꞌ. Esaꞌko noꞌ mane leo na. Esau ana ulun Elifas ana nara, dadi mane leo Teman, mane leo Omar, mane leo Sefo, mane leo Kenas, mane leo Kora, mane leo Gatam, ma mane leo Amalek. Sira basa, nana Esau no saon Ada tititi-nonosin. ");
INSERT INTO rgu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau anan Rehuel ana nara, dadi mane leo Nahat, mane leo Sera, mane leo Syema, ma mane leo Misa. Sira basa, nana Esau no saon Basmat tititi-nonosin. ");
INSERT INTO rgu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau no saon Oholibama ana nara, dadi mane leo Yeus, mane leo Yalam, ma mane leo Kora. ");
INSERT INTO rgu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Leo sira basa, nana Esau tititi-nonosin. ");
INSERT INTO rgu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Nai mamanaꞌ ria, boe hapu lahenda Hori esa, nade Seir. Ria ana nara kofela, dadi reuꞌ leo dodouꞌ. Esaꞌko noꞌ mane leon. Basa de, ana nara dadi mane leo Lotan, mane leo Sobal, mane lao Sibeon, mane leo Anah, mane leo Dison, mane leo Eser, ma mane leo Disan. ");
INSERT INTO rgu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ana nara, siꞌ Hori ma Heman. (Lotan feto na, riꞌ Timna). ");
INSERT INTO rgu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ana nara, siꞌ: Alwan, Manahat, Ebal, Sefo, ma Onam. ");
INSERT INTO rgu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon ana nara, siꞌ Aya, ma Anah. Anah riꞌ hapu oe mata hanas nai mo soroaeꞌ, tepoꞌ fo ana foo papa na keledei nara. ");
INSERT INTO rgu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah ana feto na, riꞌ, Oholibama. Ma ana tou na, riꞌ, Dison. Dison ana nara, siꞌ, Hemdan, Esban, Yitran, ma Keran. ");
INSERT INTO rgu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser ana nara, siꞌ, Bilham, Saꞌawan, ma Akan. ");
INSERT INTO rgu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan ana nara, siꞌ, Us, ma Aran. ");
INSERT INTO rgu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","De mane leo lahenda Hori ra, siꞌ, Lotan, Sobal, Sibeon, Anah, Dison, Eser, ma Disan. Sira basa leo rai nusa Seir. ");
INSERT INTO rgu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Tepoꞌ fo nusa Israꞌel bei ta nanuu maneꞌ fa, te nai dae Edom nanuu maneꞌ so. Sira nade nara ratutuka ao siꞌ: ");
INSERT INTO rgu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ara soꞌu ra Beor ana na, nade Bela, dadi mane nai kota Dinhaba. ");
INSERT INTO rgu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tepoꞌ fo Bela maten, Yobab dadi mane, kati ni. Ria papa na, nade Sera, neme koro Bosra mai. ");
INSERT INTO rgu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tepoꞌ fo Yobab maten, Husam dadi mane, kati ni. Husam, nana neme lahenda Teman nara nusan mai. ");
INSERT INTO rgu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tepoꞌ fo Husam maten, Hadad dadi mane kati ni. Ria papa na, nade Bedad neme koro Awit mai. (Ria riꞌ naseki lahenda Midian ara, tepoꞌ fo ratati nai Moab.) ");
INSERT INTO rgu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tepoꞌ fo Hadad maten, Samla dadi mane kati ni. Samla nana, neme koro Masreka mai. ");
INSERT INTO rgu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tepoꞌ fo Samla maten, Saul dadi mane kati ni. Saul nana, neme koro Rehobot nai lee suuꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Tepoꞌ fo Saul maten, Baꞌal-Hanan dadi mane kati ni. Ria papa na, nade Akbor. ");
INSERT INTO rgu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tepoꞌ fo Baꞌal-Hanan maten, Hadar dadi mane kati ni. Hadar nana, neme koro Pau. Sao na nade Mehetabel. Mehetabel papa na, nade Matret. Ma baꞌi na, riꞌ Mesahab. ");
INSERT INTO rgu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","De, mane leo fo dadi remeꞌ Esau sara mai, nana siꞌ: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, ma Iram. Ara fee nusa nara ranade tuka sira esa-esa naden. De, sira basa, nana Esau tititi-nonosin, fo tuka lahenda Edom ara tutuin. ");
INSERT INTO rgu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Ia nana Yakob tutui na. Tepoꞌ ria, Yakob fali neu leo seluꞌ nai dae Kanaꞌan. Ria nana papa ni Isak mamana leleon neme uluꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Tepoꞌ ria, Yakob ana ni esa neme saon Rahel mai, nade Yusuf. Tepoꞌ fo teu ni sanahulu hitu, ana biasa sama-sama no aꞌa nara reu foo sira bibi nara. Ria aꞌa nara, nana Yakob saon Bilha, ma saon Silpa ana nara. Ma Yusuf soa-soa neu tui papa na, laꞌeneuꞌ aꞌa nara hada-pariin. ");
INSERT INTO rgu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Boki Yusuf, nana Yakob namalasi so. Huu ria na, ana sue Yusuf lena heni ana feke nara. Laiꞌ esa de Yakob rau badu naru malole inaꞌ esa, fee Yusuf. ");
INSERT INTO rgu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yusuf aꞌa nara rita sira papa na sue na Yusuf seliꞌ, boe ma eteꞌ ao nara roo ni, losaꞌ ara ta nau dedea malole ron soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Hatuꞌ esa, boe ma Yusuf nalamei. Basa de, ana tui meis ria neuꞌ aꞌa nara nae, “Ae! Emi nenene dei! Au alamei, uni leo ita basa puputu hade gandum nai okaꞌ daleꞌ. Boe ma au hade ka napadei dodoko. Tehuu emi hade mara rapadei eo raan, fo ara doꞌo-tabe au nuu ka.” Ramanene leoꞌ na, boe ma aꞌa nara boe-boe eteꞌ ao nara roo ni. ");
INSERT INTO rgu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Basa de aꞌa nara rasaꞌai Yusuf rae, “Ae! O bate mae o dadi malaka fo pareta ami, do?” Ara eteꞌ ao nara raan seli roo ni, nana huu ana tui meis ria. ");
INSERT INTO rgu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Basa de, Yusuf nalamei seluꞌ bali. Boe ma ana tui aꞌa nara nae, “Ae! Au alamei seluꞌ bali. Au ita ledo a, bulaꞌ a, ma ruuꞌ sanahulu esa. Basa si doꞌo-tabe ratalolole neuꞌ au.” ");
INSERT INTO rgu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yusuf tui basa meis ria neuꞌ papa na ma aꞌa nara, boe ma papa na nasaꞌ ai ni no hara beraꞌ nae, “Meis ubeaꞌ ria! O afi mae au oo mama ma, aꞌa-fadi mara, mai fo sundaꞌ undulaka mara nai o matam? Ta mae tao boeꞌ ma!” ");
INSERT INTO rgu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","De, Yusuf aꞌa nara ramanasaꞌ ana. Tehuu papa na dodoo neuꞌ meis ria ta basan fa. ");
INSERT INTO rgu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Faiꞌ esa, boe ma Yusuf aꞌa nara foo reni papa na bibi nara losaꞌ raneneaꞌ koro Sikem. ");
INSERT INTO rgu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Boe ma papa na nae, “Usu, a! O aꞌa mara foo bibi ra raneneaꞌ nai Sikem. De, mahehere aom fo muu dama si dei.” Basa de Yusuf nataa nae, “Ia, papa.” ");
INSERT INTO rgu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Boe ma papa na nae, “O muu fo mete maneni aꞌa mara, ma au bibi kara dei. Sira leo beaꞌ, sona o fali mai mafada au.” Basa boe ma Yusuf laꞌo ela dae Hebron moo na, de naroo losa Sikem. ");
INSERT INTO rgu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Losa naa, boe ma ana saka naleleiꞌ asa nai mooꞌ sira. Basa de naneta no touꞌ esa. Touꞌ ria natane ni nae, “O saka ubea?” ");
INSERT INTO rgu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf nataa nae, “Papa. Au saka aꞌa kara. Ara foo bibi raneneaꞌ nai bai iaꞌ ee. Papa ka mita si boe, do?” ");
INSERT INTO rgu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Basa de touꞌ ria nafada nae, “Ara ta rai ia soꞌ. Tehuu ara rae reu foo raneneaꞌ nai koro Dotan.” Basa boe ma, Yusuf neu saka aꞌa nara, losaꞌ nita si rai koro Dotan. ");
INSERT INTO rgu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tehuu Yusuf bei nai dooꞌ a, te aꞌa nara ritan so. Boe ma ara rala haraꞌ fo nau raisa ni. ");
INSERT INTO rgu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Esa nafada esa nae, “Emi mete dei. Malaka meis a mai so! ");
INSERT INTO rgu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mai sona taisa ni leo. Basa nana ita tapa henin leo oe dodolu mates a ri naꞌ daleꞌ neu. Neuꞌ ko tafada ita papa na tae banda fuiꞌ ara raa henin so. Besaꞌ ko ita tita ria mei-afen sira leo beaꞌ!” ");
INSERT INTO rgu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Aꞌan Ruben namanene naa ria, boe ma ana saka enoꞌ fo nau poꞌi naa Yusuf. Ana nasaꞌai fadi nara nae, “Ae! Ita bosoꞌ taisa ni, e! ");
INSERT INTO rgu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Malole lenaꞌ ita tuꞌun leo oe dodolu mates ia daleꞌ neu. Nai ia mamana lino-nees, de ta hapu lahenda bubuluꞌ fa. Sadi bosoꞌ tao taan nala daa ra.” Ana dedea nae leoꞌ na, nana huu ana nau poꞌi naa Yusuf, fo nadenu faliꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusuf losa si, boe ma aꞌa nara homu raan, de ara rui heni badu malolen ria. ");
INSERT INTO rgu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Basa ria, boe ma ara roi rosoꞌ ana, de ruan leo oe dodolu mates ria daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Basa boe ma ara fali reu raa-rinu. Ara bei raa-rinu, kekeneu te, rita lahenda bubuaꞌ esa mai. Lahenda bubuaꞌ sira onta nara fua reni hata naseꞌo, leo-leoꞌ ai-nana maboo meniꞌ, bumbu, ma modo-aidoo rupaꞌ ara. Sekonaa te bubuaꞌ ria nana lahenda Ismael remeꞌ koro Gilead sakaꞌ leo dae dooꞌ reu nai nusa Masir. ");
INSERT INTO rgu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Basa ria, boe ma Yahuda nafada aꞌa-fadi nara nae, “Ae! Malole lenaꞌ leo iaꞌ. Ita bosoꞌ taisa ni. Hapu ubeaꞌ? Leo mae leoꞌ bea boe oo, ita ta bisa tafuni tala ria daa na. ");
INSERT INTO rgu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Malole lenaꞌ ita seꞌo ni leo lahenda Ismael sira neu. Leo mae ita tao ni leoꞌ bea boe, ria nana ita bei fadi bokin. Huu ria na, ita bosoꞌ tao tahehediꞌ ana, ee!” Boe ma, basa si sipoꞌ dedeaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Basa ria, naraa no lahenda papalele sira resiꞌ naa, Yusuf aꞌa nara hela raan nemeꞌ oe dodoluꞌ ria daleꞌ mai. Boe ma ara seꞌo ni leo lahenda Ismael sira neu, neniꞌ doi fulaꞌ dua hulu. Basa boe ma ara roo Yusuf leo Masir neu. ");
INSERT INTO rgu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Faiꞌ fo ara seꞌo heni Yusuf nana, Ruben ta bubuluꞌ fa. Ana natafali leo oe dodoluꞌ ria neu, boe ma ana kekes ara naan seli, nana huu Yusuf neꞌes ana so. De ana sii nalutu papakeꞌ fo nai ao-ina na, nana huu dale na susa naan seli. ");
INSERT INTO rgu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Basa de ana natafali leo fadi nara neu nae, “Adoo! Anaꞌ ria neꞌes ana naa so! Besaꞌ ia au muste tao ubea bali?” ");
INSERT INTO rgu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ara hala bibi esa, boe ma hai raa Yusuf badu malolen ria, de raboron neuꞌ daa ria daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Basa de ara hai raa badu ria, renin leo papa na neu de rafada rae, “Papa! Ami here ma badu ia. Papa ka mete masudin. Bosoꞌ losa ia nana fadi Usu badun.” ");
INSERT INTO rgu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakob nita badu ria, boe ma ana nalelaꞌ tutiꞌ ana. Boe ma nataa nae, “Adoo! Ia nana tebe au ana ka badu na. Ta bubuluꞌ banda fuiꞌ ara sii raan nai bea. Adoo! Au ana ka maten so!” ");
INSERT INTO rgu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Basa de Yakob sii nalutu badu na, ma ana pake karong balau, nana huu ana susa naan seli. Ana dola naroo doo na seli soaneuꞌ ana na. ");
INSERT INTO rgu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ana toun ma ana inan basa si mai oꞌoe-nanasin, tehuu doaꞌ roon. Ana nae, “Taꞌa! Au susa losaꞌ mate, huu fo au ta afarene heni anaꞌ ia fa.” Boe ma Yakob dale na susa naroo, nana huu nafarene anan Yusuf fo riꞌ maten so a. ");
INSERT INTO rgu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yakob bei nai susa daleꞌ, te lahenda papalele sira losa rai Masir so. Basa boe ma ara reu seꞌo Yusuf leo lahenda bauinaꞌ esa neu, nade Potifar. Ria nana mane Masir malaka manean. ");
INSERT INTO rgu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Basa ria, boe ma Yahuda laꞌo ela aꞌa-fadi nara, de leo no tia ni Hira nai koro Adulam. ");
INSERT INTO rgu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nai naa hapu tou Kanaꞌan esa, nade Sua. Yahuda nahiiꞌ Sua ana feton esa, de dua si sao. Boe ma ana boki ana touꞌ hida ratutuka ao. ");
INSERT INTO rgu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana uluꞌ a, ara feen nade Er. ");
INSERT INTO rgu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ana kadua a, ara feen nade Onan. ");
INSERT INTO rgu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ana katelu a, ara feen nade Sela. Tepoꞌ fo boki Sela, ara lali leo koro fekeꞌ esa reu so, nade Kesib. ");
INSERT INTO rgu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Er, ana uluꞌ a nambau-ina so, boe ma Yahuda neu natane feen ana fetoꞌ esa, nade Tamar, de dua si sao. ");
INSERT INTO rgu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tehuu Er tadaluꞌ a naan seli. Huu ria na, de Manetualain huku naisa ni. De Er maten, te anaꞌ bei taꞌa. ");
INSERT INTO rgu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Basa ria boe ma, Yahuda nadenu ana kadua na nae, “Onan! Aꞌa ma maten so, tehuu anaꞌ taꞌa. De besaꞌ ia, tuka lasiꞌ ara hada na, o muste kati aꞌa ma, fo sao ma ria sao na. Fo ela o boki fee aꞌa ma tititi-nonosiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan bubuluꞌ hadas ria. Tehuu ana ta nau boki fee aꞌan Er tititi-nonosiꞌ fa. De tuka-tuka faiꞌ, maneniko ana suku nooꞌ Tamar, sona ana tuꞌu buna-boaꞌ deaꞌ neu, fo ela Tamar bosoꞌ boki. ");
INSERT INTO rgu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan tataon ria, tao na Manetualain namanasa naan seli. Huu ria na, de Manetualain huku naisa ni boe. ");
INSERT INTO rgu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahuda nita anan sira dua fo riꞌ sao Tamar a, mate si so, boe ma ana biiꞌ. Ana afi nae, bosoꞌ losa ana murin Sela sao Tamar, fo maten bali. Huu ria na, de ana neu nafada manafeun Tamar nae, “Ana ki, on! Malole lenaꞌ o fali leo ina-ama mara muu leo. Kalu au ana ki Sela nambau-ina, sona besaꞌ ko o fali fo sao maan.” Basa boe ma, Tamar fali. ");
INSERT INTO rgu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ta doo bea boeꞌ, te Yahuda sao na maten. De ana susa losaꞌ basa fai luumata-pinuiduꞌ a. Basa boe ma, ana naloo naa tian Hira, fo dua si leo koro Timna reu. Nai naa lahenda ra rame laesaꞌ kuti bibi-lopo ra bulu nara, fo raseꞌo. ");
INSERT INTO rgu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Boe ma lahenda rafada Tamar rae, “O arama ma leo Timna neu, ela ana urus lahenda fo kuti bibi-lopo nara bulu na.” ");
INSERT INTO rgu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tepoꞌ ria, Yahuda ana murin Sela nambau-ina so. Tehuu Tamar bubuluꞌ nae, arama na ta nau feen sao Sela fa. De, Tamar saka enoꞌ ela nasalaꞌo hak na. Ana olu heni papake ina falu na, basa de pake papake malole, ma lafa anaꞌ fo poti etu laka na ma mata-idun. Basa de ana neu natuuꞌ nai koro Enaim lelesu bafa na, naraa no enoꞌ fo leo Timna neu. ");
INSERT INTO rgu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Fai fo Yahuda nesiꞌ lelesu bafaꞌ fo masoꞌ leo koroꞌ daleꞌ neu, ana nita inaꞌ esa. Ana naendobuko ina manasosoa ria, nana huu Tamar kakao-papaken, ma poti etu mata-idun. ");
INSERT INTO rgu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda ta bubuluꞌ nae inaꞌ ria, nana manafeu na. De, ana naneneaꞌ leo inaꞌ ria neu, fo natane nae, “Ae! Maneniko ita suku tabuaꞌ, sona o hule bau bea?” Tehuu Tamar nataa nae, “Neu! Neme papa ka hihii ma mai!” ");
INSERT INTO rgu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda naloloe nae, “Leoꞌ bea kalu au fee o kedaeꞌ esa?” Basa de Tamar sipoꞌ nae, “Malole a, papa. Sadi papa fee au homu hata esa dei. Losaꞌ fai bea papa haitua kedaeꞌ ria mai.” ");
INSERT INTO rgu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Boe ma Yahuda natane nae, ‘Au fee o homu hata ubea?” Tamar sipoꞌ nae, “Papa foa ela cap fo manaloloeꞌ riꞌ papa bolii ma ria. Ma foa ela teteꞌe ria boe.” Namanene leoꞌ na, boe ma Yahuda fee ni basa hata sira. Boe ma dua si reu suku rabua. Basa de Tamar fali. Ana olu heni papake malole nara ma lafa anaꞌ ria, de pake seluꞌ papake ina falu na neu. Sekonaa te Tamar nairu so. ");
INSERT INTO rgu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ta doo bea boeꞌ te, Yahuda nadenu tian Hira nae, “O muni kedaeꞌ ia leo ina manasosoa fo riꞌ nai Enaim, ela muni faliꞌ au hata kara fo ana homu si rai naa.” Hira losa naa, ana natatane neu-mai, tehuu ta naneta noo inaꞌ ria fa. ");
INSERT INTO rgu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Boe ma ana natane lahenda fo rai naa nae, “Ae! Emi mita ina manasosoa fo riꞌ biasa natuuꞌ nai lelesu bafaꞌ ia boe, do? Ana nai bea, ee?” Tehuu ara rataa rae, “Papa, Nai ia ta hapu ina manasosoa fa.” ");
INSERT INTO rgu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","De, Hira fali seluꞌ leo Yahuda neu. Ana nafada nae, “Au ta aneta o inaꞌ ria fa. Au asakaꞌ ana, tehuu lahenda fo rai naa rafada rae, nai mamanaꞌ ria ta hapu ina manasosoa fa.” ");
INSERT INTO rgu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda sipoꞌ nae, “Nemeꞌ na fo ela ana soa hata sira leo! Sadi lahenda bosoꞌ tao ramamaeꞌ ita! Huu fo au nau bae so, tehuu ita ta taneta too ni fa.” ");
INSERT INTO rgu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Basa bulaꞌ telu, boe ma lahenda reu rafada Yahuda rae, “O manafeum Tamar tao aon leoꞌ ina manasosoa. Besaꞌ ia nairu so.” Yahuda namanene leoꞌ na, boe ma namanasa naan seli. Basa de, ana pareta lahenda ria nae, “Muu hela moo inaꞌ ria mai, fo hotu masosodaꞌ heni ni!” ");
INSERT INTO rgu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Basa de ara reu rala Tamar mai. Tehuu ana natudu cap a noo teteꞌe ria. Boe ma ana nadenu si reu rafada arama na rae, “Papa, parisaꞌ matalolole hata ia ra dei. Lahenda fo cap na, ma teteꞌen ia, sona ria riꞌ tao na au airu.” ");
INSERT INTO rgu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda nita hata sira, boe ma nalelaꞌ tuti asa nae, hata sira nana ria nuun. Basa de ana nafada nae, “Tebe! Inaꞌ ria ta sala fa. Au riꞌ sala. Ria laꞌe. Tuka matetu na au muste feen sao au ana ki Sela. Tehuu au riꞌ ta ataa fa. Poꞌi ni leo!” Basa de Yahuda ta nabua no Tamar soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar ledo-fai boboki na naraa so, ana boki ana kaduaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Fai fo ana boki, anaꞌ esa lima na nauluꞌ deaꞌ. Boe ma ina mabobokiꞌ a heke abas pilas neuꞌ anaꞌ ria lima na. Ana nae, “Ana uluꞌ a riaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tehuu anaꞌ ria hela nafaliꞌ lima na. Basa boe ma nonoo na kalua nauluꞌ. Ina mabobokiꞌ a nafada anaꞌ ria nae, “Ae! Tebe o baraꞌai ma seli, oo! Huu ria na, de o maseti fo kalua mauluꞌ!” Basa de, ara foi anaꞌ ria nade, Peres (sosoa na, ‘naseti fo kalua’). ");
INSERT INTO rgu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Basa, besaꞌ ko fadi na fo riꞌ lima na manaheke abas pilas a, kalua. Ara foi anaꞌ ria nade, Sera (sosoa na, ‘pilas makarelaꞌ’). ");
INSERT INTO rgu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Tepoꞌ ria, lahenda Ismael sira ro Yusuf leo Masir reu. Nai naa, hapu lahenda bauinaꞌ esa, nade Potifar. Ria nana malaka neme basa soldadu fo ranea mane Masir uma mana pareta na. Potifar asa na Yusuf nemeꞌ papalele sira mai, dadi ata nai ria uma na. Nai naa, MANETUALAIN tulu-fali Yusuf, losaꞌ ria nonoi-tataon basan dadi no malole. ");
INSERT INTO rgu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Malaka na nita Yusuf nonoi-tataon malole a, boe ma ana bubuluꞌ matetuꞌ nae MANETUALAIN tulu-fali Yusuf. ");
INSERT INTO rgu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Huu ria na, de malaka na nahiiꞌ Yusuf, ma namahere ni. De, ana soꞌu naa Yusuf dadi mandor nai uma na. Ana fee Yusuf urus ria uma na, ma basa hata posaka nara boe. ");
INSERT INTO rgu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mulai neme Yusuf dadi mandor nai naa, Manetualain boe fee ua-naleꞌ neuꞌ malakan, lahenda Masir ria. Ria uma isi nara, ria hata posakan, ria oka-tinen, ma ria nonoi-tataon, basan dadi no malole. ");
INSERT INTO rgu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar nita Yusuf urus basa nonoi-tataoꞌ no malole, de ana ta afi hata-hata esa boeꞌ, nalelaꞌ adaꞌ noi naa-ninuꞌ a. Tepoꞌ ria, Yusuf lole na seli. ");
INSERT INTO rgu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ana leo nai naa, bei ta dooꞌ a fa, te Potifar sao na nahiiꞌ ana. Boe ma ana leleꞌo Yusuf fo dua si suku rabuaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tehuu Yusuf ta nataa fa, de ana sipoꞌ nae, “Bosoꞌ tao leo naꞌ, mama! Au malaka ki Potifar fee au kuasa so, fo urus ria nonoi-tataon katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nai uma ia, ta hapu lahenda fo homu kuasa lena au soꞌ. Huu fo malaka a fee au urus basa-basan so. Adaꞌ noi mama ka, sona taꞌa. Tao leoꞌ bea fo au bisa tao tadaluꞌ leo naꞌ! Nonoi leo naꞌ a, nalenalaka Manetualain hihii-nanaun so!” ");
INSERT INTO rgu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Leo mae leoꞌ na boe, tuka-tuka faiꞌ, malaka ria sao na leleꞌo naroo Yusuf. Tehuu Yusuf ta tao daleꞌ neuꞌ ana fa. ");
INSERT INTO rgu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Laiꞌ esa de Yusuf leo uma daleꞌ neu, fo nau memete ria nonoi-tataon. Faiꞌ ria, ta hapu lahenda fekeꞌ nai uma fa. ");
INSERT INTO rgu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Boe ma ria malaka na sao na mai, de lobeꞌ na Yusuf badu na ana hela ni, boe ma nae, “Mai leo! Besaꞌ ia ela noi ita dua so. Mai fo ita dua teu tapeuꞌ leo.” Tehuu Yusuf ta nataa fa. Basa de ana naule, losaꞌ posu heni badu na. Boe ma ana nalai deaꞌ neu. Tehuu inaꞌ a bei hopu nahere badu ria. ");
INSERT INTO rgu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potifar sao na nita Yusuf nalai ela badu na, ");
INSERT INTO rgu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","boe ma ana naloo lahenda mana noi nara, de nafada nae, “Ae! Emi mai mitaꞌ ia dei! Bisinaaꞌ a tou Ibrani ria, ana masoꞌ leo au kama ka daleꞌ mai. Ana nau tao tadadalu au, tehuu au aloo ambera ina, boe ma ana nalai deaꞌ neu. Mitaꞌ ia dei, ana foa ela badu na riaꞌ. Au sao ka noo lahenda manori-taaꞌ ia mai, fo tao namamaeꞌ ita!” ");
INSERT INTO rgu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifar sao na homu nahere badu ria losaꞌ sao na fali main. ");
INSERT INTO rgu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ana tui nae, “Aꞌa, e! Touꞌ Ibrani fo riꞌ aꞌa ka moon mai a, bisinaaꞌ a ana masoꞌ leo au kama ka daleꞌ neu so, fo nau hohoke au! ");
INSERT INTO rgu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tehuu au aloo ambera ina lahenda ra. Basa de ana nalai neu fuiꞌ, de foa ela badu na riaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifar namanene sao na tui nae leoꞌ na, boe ma ana namanasa nan seliꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","De ana pareta lahenda ra reu hopu ra Yusuf. Boe ma ara teen leo maneꞌ a uma huhukun daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tehuu MANETUALAIN ta nafarene heni Yusuf fa, Ana tulu-fali naroo ni losaꞌ uma huhukuꞌ ria malaka na boe nahiiꞌ na Yusuf seli. ");
INSERT INTO rgu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ana namahere Yusuf. Huu ria na, de ana fee Yusuf urus basa lahenda manahukuꞌ ara, ma basa nonoi-tataoꞌ nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Huu ria na malaka a ta laka hediꞌ urus hata-hata esa nai uma huhukuꞌ ria soꞌ. MANETUALAIN tulu-fali naroo Yusuf, de basa nonoi-tataoꞌ nai uma huhukuꞌ ria, dadi malole. ");
INSERT INTO rgu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Nai uma huhukuꞌ ria, hapu lahenda dua. Fai a ulu na, dua si dadi malaka malalau nai mane Masir uma manaparetan. Esa urus maneꞌ a nininu na. Esa bali urus maneꞌ a roti na. Dua si tao rasalaꞌ maneꞌ a. Huu ria na maneꞌ a namanasa, de tee si leo uma huhukuꞌ daleꞌ reu. De dua si mamanaꞌ esa ro Yusuf. ");
INSERT INTO rgu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Basa de, malaka bui ria pareta Yusuf fo urus pegawe sira. Ara leo rai naa losa teuꞌ esa-dua rian so. ");
INSERT INTO rgu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Hatuꞌ esa, boe ma pegawe sira dua ralamei. Esaꞌko noꞌ mei-afen. Ma mei-afes sira esaꞌko sosoan. ");
INSERT INTO rgu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Balahaꞌ boe ma, Yusuf mai te nita dua si mata-idu nara ta raleleka fa. ");
INSERT INTO rgu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ana natane si nae, “Ubeaꞌ taon de faiꞌ ia emi dua mata-idu mara ta ralelekaꞌ fa?” ");
INSERT INTO rgu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ara rataa rae, “Leodaeꞌ a ami malamei, tehuu ami ta bubuluꞌ sosoa-raraan ubeaꞌ.” Basa de Yusuf dedea nae, “Ta hapu lahenda esa nalelaꞌ mei-afes ara sosoa-raraan, adaꞌ noi Manetualain riꞌ bubuluꞌ. Soba emi tui dei. Neuꞌ ko au saka sudi sosoa-raraa nara neme Manetualain mai.” ");
INSERT INTO rgu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Basa ria, boe ma pegawe fo urus maneꞌ a nininu na, tui nae, “Leo iaꞌ! Au alamei, ita ai anggor huuꞌ esa ");
INSERT INTO rgu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","baꞌeꞌ telu. Aihuu ria nadoo tutiꞌ a, nabuna, ma naboa rakikii, latu-latuꞌ mesan. ");
INSERT INTO rgu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Basa de au ita, au homu maneꞌ a galaas nininu na. Boe ma au etu a anggor ria boa na, de hee oe na neuꞌ maneꞌ a galaas na daleꞌ. Basa de, au loon leo maneꞌ a neu, fo ninu.” ");
INSERT INTO rgu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusuf namanene leoꞌ na, boe ma nafada nae, “Papa. Meis ria sosoa na leo iaꞌ: Baꞌe sira telu, nana sosoa na faiꞌ telu. ");
INSERT INTO rgu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nai fai kateluꞌ ia ra dalen, neuꞌ ko maneꞌ a poꞌi na papa nemeꞌ uma huhukuꞌ ia mai. Basa nate ana soꞌu na seluꞌ papa, fo urus seluꞌ maneꞌ a nininu na, sama leoꞌ maulu na. ");
INSERT INTO rgu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Maneniko papa ua-nalem malole a leoꞌ na, sona bosoꞌ mafarene heni au, o! Maneniko papa sue au, sona tui maneꞌ a ela ana poꞌi au emeꞌ mamanaꞌ ia mai boe. ");
INSERT INTO rgu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tuka matetu na, maulu na ara hai au no nasetiꞌ eme lahenda Ibrani ra koro na, de roo au leo iaꞌ mai. Nai ia boe au ta tao salaꞌ hata esa boeꞌ. Tehuu kekeneu te, ara ena au nai uma huhukuꞌ ia, sama leoꞌ au ia lahenda tadaluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pegawe fo urus maneꞌ a roti na namanene mei-afes ria sosoa na malole a leoꞌ naa, boe ma ana tui Yusuf nae, “Fadi, e! Au boe alamei leo iaꞌ: au sua atutuleꞌ lapaneu telu. ");
INSERT INTO rgu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nai lapaneu misilai teteꞌeꞌ a, hapu maneꞌ a kokis rupa nara rai daleꞌ. Tehuu manupuiꞌ ara mai, de raa heni kokis sira nai au laka ka lain.” ");
INSERT INTO rgu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuf namanene leoꞌ na boe ma, nataa nae, “Papa mei-afes ma sosoa na leo iaꞌ: lapaneu sira telu, sosoa na nae faiꞌ telu. ");
INSERT INTO rgu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nai fai kateluꞌ ia ra dalen, neuꞌ ko maneꞌ a nadenu lahenda mai tete heni papa laka ma. Basa te, ara londa nenetu ma neuꞌ dii lain. Boe ma manupui ara mai raa heni papa popora ma.” ");
INSERT INTO rgu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Basa faiꞌ telu, naraa laꞌe maneꞌ a fai boboki na, ana tao feta bauinaꞌ fee basa pegawe nara. Ana pareta fo reu poꞌi ra pegawe sira dua reme uma huhukuꞌ daleꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Basa de, maneꞌ a soꞌu na seluꞌ pegawe fo urus nininu na neuꞌ nonoi laka maulu na, de ana urus seluꞌ maneꞌ a nininu na. ");
INSERT INTO rgu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Boe ma pegawe fo urus maneꞌ a roti na, ara londa raisan, natetu no Yusuf dedea na. ");
INSERT INTO rgu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tehuu pegawe fo urus maneꞌ a nininu na, ta nafarene Yusuf soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Basa teuꞌ dua, boe ma mane Masir nalamei, uni leo napadeiꞌ nai lee Nil a suu na. ");
INSERT INTO rgu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kekeneu te, nita sapi mapetaꞌ hitu. Rou nara makadidilan. Ara kalua remeꞌ lee ria mai, de raa nau nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Basa boe ma, sapi fekeꞌ hitu kalua reme lee ria mai. Ao nara korau raan seli. Ara rapadei raneneaꞌ ro sapi mapetaꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Basa de, sapi korauꞌ sira hitu si odo ra sapi mapeta sira hitu si. Boe ma maneꞌ a keke na aon. ");
INSERT INTO rgu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ta doo bea boeꞌ te, ana suku namanee seluꞌ bali. Ana nita hade neuꞌ puleꞌ hitu, kalua reme hade huu mapetaꞌ esa mai. ");
INSERT INTO rgu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Basa de, nita seluꞌ hade lakaꞌ puleꞌ hitu. Ara mamale so, nana huu laꞌe ani hanas fo fuu neme moo soro aeꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Boe ma basa hade lakaꞌ sira odo ra hade neuꞌ kahituꞌ sira. Basa boe ma, maneꞌ a foa na aon. Besaꞌ ko bubuluꞌ nae, ana nalamei seluꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Foa balahaa anan ria, maneꞌ a dale na ta tama soꞌ. De ana pareta lahenda ra reu raloo basa ladaꞌ ara, ma lahenda malelaꞌ fo rai Masir. Boe ma, ana tui si ria mei-afes na, tehuu ta hapu esa bisa nafada meis ria sosoa na boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Basa besaꞌ ko, pegawe fo urus maneꞌ a nininu na, nafarene Yusuf. De ana neu tui maneꞌ a nae, “Papa mane, au besaꞌ ko afarene. ");
INSERT INTO rgu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Maꞌulu na, papa mamanasa mo au o nonoo ka, de ena ami nai uma huhukuꞌ daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Hatuꞌ esa, boe ma ami dua malamei. Esaꞌko meis na, ma meis ara esaꞌko noꞌ sosoan. ");
INSERT INTO rgu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nai uma huhukuꞌ ria daleꞌ boe, hapu lehenda Ibrani esa bei murianaꞌ. Malaka a soꞌu nan dadi malaka malalau nai uma huhuku dale. Ami tui ni meis mara. Boe ma ana nafada fee meis sira sosoan. ");
INSERT INTO rgu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Huu ria na, de papa maneꞌ soꞌu ma seluꞌ au. Tehuu au nonoo ki ria, hapu huhuku mamates. Basa sira, natetu no lahenda Ibrani ria nafada na!” ");
INSERT INTO rgu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Maneꞌ a namanene leoꞌ na, boe ma nadenu lahenda lai-lai reu rala Yusuf nai uma huhuku daleꞌ. Yusuf keu heni koromii na, kati papake nara, ma sasau aon, basa boe ma neu nataa maneꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ana losa, boe ma maneꞌ a dedea nae, “Ana touꞌ on, e! Au alamei, tehuu ta hapu lahenda esa bisa nafada meis ria sosoa na boeꞌ. Tehuu lahenda rafada au rae, o bisa.” ");
INSERT INTO rgu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Boe ma Yusuf sipoꞌ nae, “Papa mane. Au boe ta alelaꞌ fa. Adaꞌ noi Manetualain riꞌ bisa nafada no matetuꞌ meis ria sosoa na. Ria tantu nau nafada hata malole neuꞌ papa mane.” ");
INSERT INTO rgu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Basa de maneꞌ a tui nae, “Nai au meis ka daleꞌ, apadeiꞌ nai lee Nil a suu na. ");
INSERT INTO rgu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Boe ma sapi mapetaꞌ hitu, rou nara makadidilan. Ara kalua remeꞌ lee ria daleꞌ mai, de reu raa nau nai lee a suu na. ");
INSERT INTO rgu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Basa boe ma sapi fekeꞌ hitu mai bali. Tehuu sapi sira korau raan seli. Nai dae Masir ia, au bei ta parna ita sapi korau rupa leo naꞌ fa! ");
INSERT INTO rgu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tehuu au heran an seli! Kekeneu te, sapi korau kahituꞌ sira, odo ra sapi mapeta kahituꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ara odo basa si, tehuu sira korau raroo. Basa boe ma, au edoꞌ a ao ka. ");
INSERT INTO rgu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Basa de au suku amanee seluꞌ, boe ma alamei bali. Au ita hade neuꞌ puleꞌ hitu, kalua reme hade huu mapetaꞌ esa mai. ");
INSERT INTO rgu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Basa de, au ita seluꞌ, hade lakaꞌ puleꞌ hitu. Ara mamale so, nana huu ani hanas a fuu laꞌe si. ");
INSERT INTO rgu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Boe ma basa hade pule lakaꞌ sira, odo ra hade neuꞌ pule kahituꞌ sira. Basa de, au foa a ao ka. Au tui meis ria neuꞌ lahenda malelaꞌ ara, tehuu ta hapu esa bisa nafada sosoa na boeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Basa de Yusuf nafada nae, “Papa mane. Meis sira dua sosoaꞌ esaꞌ a. Manetualain nafada memaꞌ papa maneꞌ, hata fo Ana sakaꞌ taon. ");
INSERT INTO rgu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Meis ria sosoa na, leo iaꞌ: sapi mapetaꞌ kahituꞌ sira, ma hade neuꞌ pule kahituꞌ sira, nana fai betes teuꞌ hitu. Sira sosoan esaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Boe ma sapi korauꞌ kahituꞌ sira, ma hade laka pule kahituꞌ sira, nana fai laas teuꞌ hitu. ");
INSERT INTO rgu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","De, Manetualain nafada memaꞌ so, hata fo Ana sakaꞌ taon. Ria sama leoꞌ bisinaꞌ a au afada so a. ");
INSERT INTO rgu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Neuꞌ ko ita hapu fai betes losa teuꞌ hitu, nai basa mamanaꞌ nai nusa Masir ia. ");
INSERT INTO rgu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Basa ria, besaꞌ ko ita hapu fai laas losaꞌ teuꞌ hitu. Neuꞌ ko fai laas ria ta madudulaꞌ fa, losaꞌ ta hapu nanaaꞌ nai nusaꞌ ia soꞌ. Basa lahenda ra ramalaa raan seli, losaꞌ ara ta bisa rafarene fai betes ria soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Papa mane malamei matututiꞌ laiꞌ dua ria, nana sosoa na nae, Manetualain ator memaꞌ so. Ta dooꞌ a, te hata fo Ana ator a, mulai dadi so. ");
INSERT INTO rgu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Huu ria na, au ae leoꞌ ia: malole lenaꞌ papa mane saka ma lahenda malelaꞌ esa, fo bisa urus no malole. Basa nana soꞌu ni fo ator natalolole nusaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Fai betes teu kahituꞌ sira neuꞌ ko hapu buna-boaꞌ dodouꞌ naan seli. De, malole lenaꞌ papa mane soꞌu ma lahenda fekeꞌ bali, ela rabubua basa buna-boaꞌ. Buna-boaꞌ sira ara bati si reuꞌ babatiꞌ lima fo pake babatiꞌ haa, ma peda babatiꞌ esa neuꞌ mana pareta mamana pepeda-fufuan. ");
INSERT INTO rgu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ara muste tuka papa mane pareta ma, fo reu susu hade remeꞌ basa koroꞌ nai Masir ia. Basa nana ara muste radai hade sira reuꞌ mamanaꞌ pepeda-fufuaꞌ ara, fo ranea ratalolole si. ");
INSERT INTO rgu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Fo ela losa teu laa-roes kahituꞌ sira, sona ita bei hapu nanaaꞌ. Ator leo naꞌ, sona ta hapu lahenda mate huu laas.” ");
INSERT INTO rgu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Maneꞌ a no pegawe bau-ina nara ramanene Yusuf dedea nae leoꞌ na, boe ma ara sipoꞌ Yusuf nanaen ria. ");
INSERT INTO rgu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Maneꞌ a dedea no pegawe nara nae, “Manetualain Dula-dale Na kuasa memaꞌ neuꞌ Yusuf so. Huu ria na, ita ta bisa hapu lahenda fekeꞌ lena nemeꞌ ria mai soꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Boe ma maneꞌ a dedea no Yusuf nae, “Manetualain nafada basa ia ra neuꞌ o so. Besaꞌ ko ami bubuluꞌ mae, o ia nana lahenda malelaꞌ. Ma o duduꞌa-aafim lena neme basa lahenda ra mai. ");
INSERT INTO rgu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Huu ria na, besaꞌ ia, au soꞌu o, dadi neuꞌ au lima boa ona ka. O dadi malaka nai au uma mana pareta ka. Ma neuꞌ ko basa anaraun kara tuka o pareta ma. Tehuu noi au riꞌ lena neme o mai.” ");
INSERT INTO rgu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Basa boe ma, maneꞌ a olu na rereli makuta na, de olun neuꞌ Yusuf lima uꞌu na. Ana dedea nae, “No enoꞌ ia, au soꞌu o dadi neuꞌ au lima boa ona ka, nai basa dae Masir ia.” Basa de fee Yusuf pake badu naru mabeli esa, ma nabolii ni rante lilopilas. ");
INSERT INTO rgu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Boe ma maneꞌ a fee Yusuf kareta nomer dua na, fo saꞌe. Lahenda ruma ralai rauluꞌ kareta a, fo raloo rasarerei rae, “Ae! Soi enoꞌ, oo! Fee hada-horomata! Lahenda bauinaꞌ a sakaꞌ nesiꞌ ia!” No enoꞌ ria, maneꞌ a soꞌu na Yusuf dadi neuꞌ ria lima boa ona na nai dae Masir so. ");
INSERT INTO rgu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Basa de maneꞌ a dedea no Yusuf nae, “Leo iaꞌ. O bubuluꞌ memaꞌ so, au ia nana maneꞌ. Tehuu au afada basa lahenda fo nai Masir ia so ae, maneniko o ta fee isin fa, sona ara ta bisa tao hata esa boeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Basa boe ma maneꞌ a foi Yusuf nade, Safnat Panea, tuka lahenda Masir ara naden. Ana fee Yusuf sao ana fetoꞌ esa boe, nade Asnat. Yusuf arama na, nade Potifera. Ria riꞌ urus agama nai kota On. No ria na, Yusuf dadi lahenda bauinaꞌ nai dae Masir. ");
INSERT INTO rgu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tepoꞌ fo soꞌu Yusuf, nana teun telu hulu. Basa ria, boe ma ana laꞌo rule-feo basa mamanaꞌ nai dae Masir. ");
INSERT INTO rgu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nai fai betes teuꞌ kahituꞌ sira, oka-tine nara buna-boan dodouꞌ na seli. ");
INSERT INTO rgu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Basa de, Yusuf neu nabubua na basa buna-boaꞌ ara, fo ana peda si. Ana nabubua hade neme mamanaꞌ fo naneneaꞌ kota bea, sona ana peda adaꞌ kota ria mamana pepeda-fufuan. ");
INSERT INTO rgu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Losaꞌ ana nabubua na hade dodouꞌ naan seli. Sama leoꞌ soroaeꞌ nai tasi a suu na, losaꞌ lahenda ta bisa uku-sudi rala si soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bei ta losa fai laas a boeꞌ, te Yusuf saon, Asnat, boki na ana touꞌ dua so. ");
INSERT INTO rgu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Boe ma Yusuf dedea nae, “Manetualain tao na au afarene heni doidoso ka so, tepoꞌ fo au kalua eme papa ka uma na mai.” Huu ria na, ana foi ana ulu na nade, Manase (fo sosoa na nae, ‘nafarene henin’). ");
INSERT INTO rgu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ana hapu ana nomer dua, boe ma ana dedea bali nae, “Au hapu doidoso dodouꞌ nai mamanaꞌ ia. Tehuu Manetualain fee au ua-naleꞌ so, ma au hapu anaꞌ nai ia.” Boe ma ana foi anaꞌ ria nade, Efraim. ");
INSERT INTO rgu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Basa ria, boe ma fai betes teu kahituꞌ sira basan. ");
INSERT INTO rgu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Boe ma fai laas teu kahituꞌ ara mulai mai, natetu no maꞌulu na Yusuf dedea-nafadan. Nai mamana fekeꞌ, lahenda ra ramalaa so. Tehuu basa mamanaꞌ fo nai Masir, nanuu nanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Doo-doo, boe ma lahenda Masir ara mulai ramalaa. Basa de reu hule nanaaꞌ nai maneꞌ a. Boe ma maneꞌ a nadenu si leo Yusuf reu, fo tuka Yusuf pareta na. ");
INSERT INTO rgu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tehuu fai laas ria tamba, losaꞌ basa mamanaꞌ nai Masir boe laꞌe belaꞌ. Boe ma Yusuf mulai hai hade neme mamana pepeda-fufuaꞌ ara mai, fo seꞌo fee lahenda Masir ara. ");
INSERT INTO rgu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Basa de, lahenda reme basa mamanaꞌ ara leo Masir reu, asa nanaaꞌ neme Yusuf mai. Nana huu fai laas ria tebe masalae naan seli. ");
INSERT INTO rgu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Tepoꞌ ria, papa Yakob namanene lahenda rae hapu hade nai Masir, de ana nafada ana nara nae, “Ana kara, ee! Ubeaꞌ taon de emi matuuꞌ moi mamakokoaꞌ a leo iaꞌ! ");
INSERT INTO rgu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Au amanene so rae, hapu nanaaꞌ nai Masir. Malole lenaꞌ emi meu asa nai naa dei, fo ela ita bosoꞌ mate huu laas a.” ");
INSERT INTO rgu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Basa boe ma, Yusuf aꞌan sanahulu si, rahehere ao nara fo sakaꞌ reu asa nanaaꞌ nai Masir. ");
INSERT INTO rgu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tehuu Yakob ta nau poꞌi Yusuf fadin, Benyamin fo no aꞌa nara reu belaꞌ a. Ana afi nae, “Bosoꞌ losa anaꞌ ria hapu soe bali!” ");
INSERT INTO rgu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Huu no lahenda nai basa mamanaꞌ ara ramanene so, rae hapu nanaaꞌ nai Masir, de lahenda dodouꞌ reu asa nai naa. Fai laas ria boe, losa nai dae Kanaꞌan. Basa de Yakob ana nara boe tuka reu asa nai naa. ");
INSERT INTO rgu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tepoꞌ ria, Yusuf dadi neuꞌ maneꞌ a lima boa ona na nai Masir so. Maneniko lahenda reme basa mamanaꞌ ara mai fo asa hade, sona Yusuf riꞌ seꞌo fee si. Huu ria na, fai fo aꞌa nara losa, ara reu sundaꞌ undulaka nara, fee hada-horomata neuꞌ ana, losaꞌ mata-idu nara neta dae a. ");
INSERT INTO rgu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Yusuf nita si, boe ma nalelaꞌ tutiꞌ asa. Tehuu Yusuf tao aon sama leoꞌ lahenda Masir, huu ria na, ara ta ralela ana. Basa de ana natane si no hara beraꞌ nae, “Emi ia, nana meme beaꞌ mai?” Ara rataa rae, “Ami ia meme Kanaꞌan mai. Ami mai fo nau asa nanaaꞌ nai papa wakil.” ");
INSERT INTO rgu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Basa de Yusuf nafarene maꞌulu na meis na. De ana nabibiiꞌ asa nae, “Au ta amahere fa! Tantu emi basa ia nana manalalafa. Emi mai lalafa dae Masir eno-maan, basa nana matafali mai suu ami, hete!” ");
INSERT INTO rgu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tehuu ara rataa rae, “Taꞌa, papa! Ami ia nana adaꞌ noi papa lahenda nadedenum. Tebe-tebe ami adaꞌ noi mai asa nanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ami basa ia nana papaꞌ esa. Ami ta manalalafa fa, papa! Ami lahenda roo-tetuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tehuu Yusuf dedea nasapaa nae, “Hee! Emi dedea fufudiꞌ! Bosoꞌ mapuputaꞌ au! Tebe emi ia nana manalalafa. Tantu emi mai lalafa nusaꞌ ia eno-maan.” ");
INSERT INTO rgu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Basa de, ara radedea laka rae, “Taꞌa, papa wakil! Ami adaꞌ noi papa lahenda nadedenum! Ami meme dae Kanaꞌan mai. Ami lahenda sanahulu dua. Ami basa papaꞌ esa. Ami fadi mateꞌa tei-susu ma foa elan no ami papa ma. Ma ami fadim esa, neꞌes ana so.” ");
INSERT INTO rgu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusuf nataa natafaliꞌ nae, “Taꞌa! Tebe leoꞌ bisinaaꞌ a hata fo au afada a! Emi ia nana memaꞌ manalalafa. ");
INSERT INTO rgu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Au nau soba emi, ela au bubuluꞌ ae bisinaꞌ a emi dedeam ria, tebe do taꞌa. Au soo-supa! Maneniko emi fadi mateꞌa tei-susum ria ta leo iaꞌ mai fa, sona emi ta bisa laꞌo ela nusaꞌ ia! ");
INSERT INTO rgu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","De, emi here ma lahenda esa, fo neu nala emi fadi mateꞌa tei-susum ria leo iaꞌ mai. Fekeꞌ ara, sona au ena si. Au nau ita emi dedea tetebeꞌ do taꞌa. Maneniko taꞌa, sona memaꞌ tebe emi manalalafa.” ");
INSERT INTO rgu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Basa de, Yusuf nadenu fo ena si faiꞌ telu nai uma huhukuꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Fai katelu na, boe ma Yusuf neu dedea no si rai uma huhukuꞌ daleꞌ nae, “Lahenda esa aun biiꞌ neuꞌ Manetualain. Ma au tuka aroo Ria hihii-nanaun. De ela emi bisa masoda, au nau poꞌi emi. Tehuu no naeetuꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Maneniko emi tui teaꞌ, sona emi musti matudu fee au buti. Eno na leo iaꞌ: au ena ahere lahenda esa adaꞌ bui dale. Fekeꞌ ara fali fo meni fee kileoboboki mara nanaaꞌ. Huu fo ara rahani emi fali meni nanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Basa sona moo emi fadim ria mai, ela dadi buti nae emi nana lahenda roo-tetuꞌ. Fo ela au bosoꞌ huku amate emi.” Ramanene leoꞌ na, boe ma rataa. ");
INSERT INTO rgu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Basa de, ara dedea raoꞌ rae, “Besaꞌ ia ita hapu babalaꞌ neme maulu na ita sala na, fo riꞌ taon neuꞌ ita fadi na a. Ita tita ni doidoso naan seli so, losaꞌ ana hule tutulu-fafali, tehuu ita ta tao daleꞌ neuꞌ ana. Huu ria na, de besaꞌ ia ita doidoso leoꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Boe ma Ruben nafarereneꞌ fee si nae, “Ae, Fadi kara, e! Maulu na au asalaꞌe emi, fo bosoꞌ tatao anaꞌ ria, hete! Tehuu emi ta tao daleꞌ neuꞌ au dedea-nafada ki ria. De, besaꞌ ia ita hapu huhukuꞌ nana huu ita lepa-tasaa ta Yusuf daa na.” ");
INSERT INTO rgu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ara dedea rae leoꞌ na, tehuu ta bubuluꞌ rae, Yusuf nala sira dedea na. Nana huu, Yusuf dedea no si pake dedea Masir, basa nana mana nesimata a salin leo dedea Ibrani neu. ");
INSERT INTO rgu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusuf namanene si dedea rae leoꞌ na, boe ma ana foa ela si, de mesaꞌ ana neu dola nai mamana fekeꞌ. Ana dola basa, boe ma fali seluꞌ leo aꞌa nara neu. Basa de nadenu lahenda ra heke ra Simeon nai toranoo nara matan. ");
INSERT INTO rgu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Basa boe ma, Yusuf pareta pagawe nara, fo radai hade neuꞌ aꞌa nara karong nara, ma peda faliꞌ sira esaꞌko doin neuꞌ karong nara bafan. Ana nadenu fo fee si tua-lepa boe. De, pagawe sira tao tuka Yusuf pareta na. ");
INSERT INTO rgu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Basa ria boe ma, Yusuf aꞌa nara fua hade karong ara reuꞌ keledei nara. Basa de ara fali reus. ");
INSERT INTO rgu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nai eno taladaꞌ ara hahae ao nara. Boe ma esa nemeꞌ sira mai sefi karong na, fo nau hani keledei na. Tehuu ana nita doi na manafuaꞌ nai hade lain. ");
INSERT INTO rgu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ana kekes ara! Ana naloo aꞌa nara nae, “Awii! Mai mitaꞌ ia dei. Ita soe ia so! Ara fee faliꞌ au doi ka nai au karong ka.” Basa si rita leoꞌ na, boe ma mopo basa aafi nara, huu fo ara bii ran seliꞌ. Ara beidea rae, “Manetualain tao ita leoꞌ bea ia so?” ");
INSERT INTO rgu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Basa de ara laꞌo raroo. Losa Kanaꞌan, boe ma ara tui papa na basa-basan fo laꞌe si a. ");
INSERT INTO rgu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ara tui rae, “Papa, e! Mane Masir lima boa onan ria talalu naan seli. Dedea-nafadan meruꞌ-meruꞌ mesan. Ana neo ami nae, ami meu lalafa ria nusa na. ");
INSERT INTO rgu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tehuu ami mataa mae, ‘Taꞌa! Ami tui teaꞌ. Ami ta lahenda manalalafa fa. ");
INSERT INTO rgu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ami lahenda malole. Ami basa lahenda sanahulu dua. Ami papaꞌ esa. Tehuu esa neꞌe sana so, ma mateꞌa tei-susuꞌ a foa elan no ami papa ma nai Kanaꞌan.’ ");
INSERT INTO rgu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Basa boe ma malaka ria nae, ‘Au nau soba emi ia tui teaꞌ do taꞌa! Emi muste foa ela esa nahaniꞌ ia. Fekeꞌ ara fali, meni hade fee kileoboboki mara, ela bosoꞌ mates no laas a. ");
INSERT INTO rgu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Emi muste mo fadi ma mai dei. No ria na, besaꞌ ko au bubuluꞌ ae emi ta manalalafa fa, tehuu memaꞌ emi lahenda roos. Basa sona besaꞌ ko poꞌi emi toranoom fo au ena ni a. Ma au fee emi lelaꞌ, fo emi bole leo beaꞌ meu a, nai nusaꞌ ia.’ ” ");
INSERT INTO rgu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tui basa, boe ma ara ofe karong ara isi nara. Te ara kekes ara, huu fo esaꞌko nitaꞌ doin bei hapun nai sira karong nara. Yakob no ana nara rita leoꞌ na, boe ma ara bii raan seli. ");
INSERT INTO rgu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Boe ma, Yakob dedea no ana nara nae, “Emi nanatao mamopo au ana kara so. Yusuf neꞌes ana so. Basa de, Simeon boe leoꞌ na. Besaꞌ ia emi nau mo Benyamin bali? Tebe-tebe emi nau tao doidoso fee au!” ");
INSERT INTO rgu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Boe ma Ruben dedea no papa na nae, “Papa, e! Fee au oo Benyamin leo. Au riꞌ lepa-asaa an. Au helu, neuꞌ ko au oo faliꞌ ana leo papa ka mai. Tehuu maneniko taꞌa, sona ela papa ka maisa au ana tou ki dua si.” ");
INSERT INTO rgu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tehuu Yakob nafada natafaliꞌ nae, “Ta bisa fa! Emi ta bole moo Benyamin. Ria aꞌan Yusuf, maten so. Besaꞌ ia ela noi ria mesaꞌ ana. Maneniko ria boe hapu soe nai eno taladaꞌ, emi tao au susa losaꞌ loe dae boloꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tepoꞌ ria, fai laas a boe-boe tamba naan seli nai Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob kileoboboki nara raa heni nanaaꞌ fo riꞌ faiꞌ naa ra, ana nara reni remeꞌ Masir mai a. Basa boe ma ana nafada si nae, “Ana kara, e! Malole lenaꞌ emi fali seluꞌ Masir meu, fo asa hade dei.” ");
INSERT INTO rgu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tehuu Yahuda sipoꞌ nae, “Papa! Faiꞌ naa ra, mane Masir lima boa ona na fee ami nafarereneꞌ so nae, ami ta bole matudu mata-idu mara neuꞌ ana, maneniko ami ta moo papa ka ana mateꞌa tei-susum, Benyamin. ");
INSERT INTO rgu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","De, papa ka muste poꞌi Benyamin, fo tuka ami dei. Besaꞌ ko ami meu asa nanaaꞌ fee papa ka. ");
INSERT INTO rgu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Maneniko papa ka ta fee Benyamin neu fa, sona ami ta meu boeꞌ. Huu fo lahenda Masir ria nae leoꞌ na so.” ");
INSERT INTO rgu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Boe ma Yakob nasaꞌai si nae, “Ubeaꞌ taon de emi mafada lahenda ria mae, emi bei manuu fadiꞌ esa bali! Emi saka susa fee au!” ");
INSERT INTO rgu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ara leleꞌo rae, “Papa, e! Lahenda ria natane naroo, fo nau bubuluꞌ ita, ma basa ita kileoboboki nara. Ana natane nae, ‘Leoꞌ bea? Emi papa ma bei sodaꞌ, do? Emi bei manuu fadi tou fekeꞌ boe, do?’ De, ami bei mae leoꞌ bea bali! Nau do ta nau fa oo, ami tui teaꞌ leo. Te bea bubuluꞌ nae, ana nadenu fo ami moo ami fadi ma leo naꞌ neu?” ");
INSERT INTO rgu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Boe ma Yahuda nafada seluꞌ nae, “Papa! Fee ami moo anaꞌ ria leo. Au helu, maneniko hata dadin, sona ela au riꞌ lepa-asaa kati ni. Maneniko au ta oo faliꞌ ana no sodaꞌ leo papa ka mai, sona papa ka fua fee au salaꞌ ria losaꞌ au mate. De, papa ka poꞌi anaꞌ ria leo, huu fo ami sakaꞌ laꞌo riaꞌ so. Malole lenaꞌ ami meu hapu leo, fo ela ta hapu esa mate boeꞌ, nana huu laas a. ");
INSERT INTO rgu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Soba ami ta mahani doo-naru basa ia, sona tantu ami fali laiꞌ dua so.” ");
INSERT INTO rgu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Basa boe ma sira papa na nae, “Maneniko leoꞌ na, sona emi tao leo iaꞌ. Meu hai ma ita buna-boa malole naan seli. Riꞌ: fani oeꞌ, bumbu, ai-nana maboo meniꞌ, modo-aidoo salap, kanari ma ai-deke fekeꞌ ara. Meni fee mane Masir a lima boa onan ria, fo ela mafada mae ia nana ita hata haituan. ");
INSERT INTO rgu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Emi meni doiꞌ desi lena ria laiꞌ dua boe, nana huu emi muste fee faliꞌ doiꞌ fo riꞌ faiꞌ na emi hapu si rai karong mara a. Bate lahenda sira siꞌ tao rasalaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Moo emi fadi ma boe, ma malale fo meu leo! ");
INSERT INTO rgu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Au hule ela Manetualain fo Manakuasa Kahereꞌ a tao na mane Masir lima boa onan ria, kasian neuꞌ emi, losaꞌ ana nau fee faliꞌ Benyamin no Simeon, fo emi basa fali belaꞌ a. Tehuu maneniko au ana kara mopo si, sona ela au lepa aroo susa ria.” ");
INSERT INTO rgu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Basa ria boe ma, rabubua ra sira hata haitua nara, ma doiꞌ, fo reni leo Masir reu. Ara roo Benyamin boe. Losa naa, boe ma ara reu rasare Yusuf. ");
INSERT INTO rgu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusuf nita Benyamin no aꞌa nara, boe ma ana nadenu malaka malalau na nae, “Ae! Moo lahenda ia ra leo au uma ka reu! Basa nana meu tati sapi esa, fo tunu-nasu mina-malada. Huu fo ara leledon ia ara raa-rinu ro au.” ");
INSERT INTO rgu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Basa de malaka malalau a tao tuka Yusuf pareta na. Boe ma ana no si leo Yusuf uma na reu. ");
INSERT INTO rgu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Fai fo ara laꞌo-laꞌo leo Yusuf uma na reu, aꞌa nara bii raan seli. Nai eno taladaꞌ ara beidea rae, “Ae! Ubeaꞌ taon de ana nadenu fo roo ita leo iaꞌ mai? Bate ana nau tao nasususaꞌ ita, nana huu doiꞌ fo faiꞌ naa ra ara fee faliꞌ asa nai ita karong ara daleꞌ a. Ara roi taoꞌ, de ro ita leo iaꞌ mai fo kekeneu te homu ra ita, ela tao ita teuꞌ ria atan. Basa te ara roso ra ita keledei nara katemaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Huu ria na, de ara raneneaꞌ Yusuf uma na, boe ma ara dedea ro malaka malalau ria rae, ");
INSERT INTO rgu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Papa! Ami hule ampon, huu fo faiꞌ naa ra ami parna mai asa nanaaꞌ nai ia so. ");
INSERT INTO rgu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Basa de fai fo ami fali leo koro ma meu, ami hahae nai enoꞌ fo nau suku. Boe ma ami sefi karong ara fo sakaꞌ hani banda ra. Sekonaa te ami hapu faliꞌ esaꞌko doin fo asa meniꞌ hade a, nai karong daleꞌ. Ami ta bubulu mae bea riꞌ tao si reuꞌ naa! Tehuu besaꞌ ia, ami meni faliꞌ basa doiꞌ sira. De papa bosoꞌ mamanasa, oo! Ela papa bubuluꞌ ami meni doi fekeꞌ bali, fo nau asa seluꞌ nanaaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Basa ria, boe ma malaka malalau a nataa nae, “Emi nee-nee! Bosoꞌ bii! Bate emi Manetualain ma, riꞌ fee emi ua-naleꞌ ria nai karong sira daleꞌ. Tepoꞌ ria, au sipo a emi doi mara katemaꞌ so. Emi ta mahuta soꞌ!” Basa de ana kalua na Simeon fee ni leo toranoo nara neu. ");
INSERT INTO rgu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Boe ma basa si masoꞌ leo Yusuf uman daleꞌ reu. Basa de, malaka malalau ria fee si oe fo safe makamoi ei nara. Ana hani sira keledei nara boe. ");
INSERT INTO rgu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Basa boe ma ana nafada nae, “Neuꞌ ko leledon ia emi mia sama-sama mo malaka a.” Ara bei rahani Yusuf mamai na, te ara ator memaꞌ sira hata haitua nara. ");
INSERT INTO rgu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusuf losa, boe ma basa si sundaꞌ undulaka nara rai mata na. Boe ma ara fee ni hata haitua ra. ");
INSERT INTO rgu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Basa de, Yusuf natane si nae, “Leoꞌ bea? Emi basa sodaꞌ, do? Emi papam fo namalasi so a, leoꞌ bea? Ana bei sodaꞌ boe, do?” ");
INSERT INTO rgu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ara rataa rae, “Papa ata lasi mi ria, fo riꞌ ami papa boki ma, bei sodaꞌ.” Boe ma ara ratele bali, fo fee hada-horomata neuꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Basa de, Yusuf mete nalelei asa, losaꞌ nita fadin Benyamin. Dua si nana, ama esa ma ina esa. Boe ma ana nae, “Ooo! Faiꞌ na tui mae emi fadi mateꞌa tei-susu ma, nana riaꞌ, do?” Basa de, ana dedea no Benyamin nae, “Anaꞌ ki on, e! Au hule Manetualain fo bati fee o ua-naleꞌ dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yusuf nita Benyamin, boe ma dale na nahiiꞌ naan seli so, huu fo ana sue na fadin ria seli. Ana ta bisa nanenete nala dale na soꞌ. Boe ma ana nalale foa ela si, leo kama na daleꞌ neu de dola. ");
INSERT INTO rgu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Dola basa, boe ma ana neu narou oe. Ana natatama dale na, basa de kalua neu naneta no si. Boe ma nadenu ana uma dale nara fo reu ator nanaaꞌ neuꞌ mei. ");
INSERT INTO rgu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Basa de ara peda fee Yusuf mesaꞌ ana neuꞌ mei esa. Aꞌa-fadi nara raa reuꞌ mei fekeꞌ. Ria pagawen lahenda Masir ara, mesaꞌ asa raa nai mei fekeꞌ boe, nana huu lahenda Masir ara raa-rinu rabua ro lahenda Ibrani ra, sona rahiaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Malaka malalau ria ator fo Yusuf aꞌa-fadi nara ratuuꞌ rasasare mataꞌ ro Yusuf. Ana ator, de ratuu tuka sira esaꞌko teu-fai bobokin, mulai neme uluꞌ a mai losa mateꞌa tei-susuꞌ a. Ara rita ator natuu nara leoꞌ na, boe ma ara roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Basa de Yusuf ator fo ana uma dale nara hai fee aꞌa-fadin nanaaꞌ neme ria mei na mai. Basa si sipo bei dedesiꞌ. Tehuu ara fee Benyamin desi lena aꞌa nara laiꞌ lima. Ara raa-rinu losaꞌ rabete. ");
INSERT INTO rgu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ara raa basa, boe ma Yusuf nabobotoꞌ malaka malalau na nae, “Ae! O mu madai hade neuꞌ lahenda ia ra esa-esaꞌko karong na, losaꞌ henu si. Basa sona o peda faliꞌ doi nara neuꞌ sira esaꞌko karong na daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Basa nana o hai ma au mok lilofula ka, fo taon neuꞌ ana mateꞌa tei-susuꞌ a karong na.” Boe ma ana neu tao tuka Yusuf paretan ria. ");
INSERT INTO rgu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Balahaaꞌ, balahaa anan boe ma Yusuf fee si fali reus ro keledei nara ma reni nanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ara raola ela kota a, boe ma Yusuf nafada malaka malalaun ria nae, “O malale mu usi tuka lahenda sira. Maneniko hapu ma si, sona mae leoꞌ ia: ‘Ubeaꞌ taon, de emi madale tadaluꞌ neuꞌ tou lasiꞌ a? De, emi balas ria malole na meniꞌ tadalu leo iaꞌ! ");
INSERT INTO rgu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tao leoꞌ bea de emi manuu daleꞌ, mamanaꞌo meni malaka a mok lilofula na? Emi ta bubuluꞌ, do? Ria ta noi malaka a mok nininu na fa! Ana pake mok ria boe, fo siura-tokonoo lahenda ua-nalen. Emi tataom ia, memaꞌ tadalu naan seli so!’ ” ");
INSERT INTO rgu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Basa boe ma malaka malalau ria, neu usi tukas losaꞌ hapu si. Boe ma ana nafada si, tuka bisinaꞌ a Yusuf dedean ria. ");
INSERT INTO rgu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Basa de ara radedea laka rae, “Papa dale ma mae leo beaꞌ ia? Ami soo-supa. Ami ta bisa tao tadaluꞌ leoꞌ na fa! ");
INSERT INTO rgu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Papa riꞌ bubuluꞌ so, hete? Faiꞌ naa ra doiꞌ fo rai ami karong mara a, ami meni faliꞌ asa leo papa mai so, hete? De, tao leoꞌ bea fo ami bisa mamanaꞌo malaka ria lilopilan do lilofulan nemeꞌ uma na mai! Ta leo naꞌ fa! ");
INSERT INTO rgu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Papa parisaꞌ leo! Hapu hataꞌ ria nai bea karong na, sona huku maisan leo! Ma ela ami fekeꞌ ara dadi meuꞌ o atam.” ");
INSERT INTO rgu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Basa boe ma malaka malalau ria nae, “Taꞌa! Leo iaꞌ dei. Maneniko hapu mok ria nai bea, sona ria riꞌ dadi neuꞌ au ata ka. Fekeꞌ ara bole fali.” ");
INSERT INTO rgu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Boe ma ara raonda lai-lai karong sira. De ara sefi tutiꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Basa de malaka malalau ria parisaꞌ nalulutuꞌ karong sira esa-esa, mulai neme aꞌa karong na, losa fadiꞌ a. Boe ma ana hapu mok lilofulaꞌ ria nai Benyamin karong na. ");
INSERT INTO rgu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Benyamin aꞌa nara rita leoꞌ naa, boe ma dale nara ralulutuꞌ. Basa de ara fua faliꞌ karong sira reuꞌ keledei ra lain, de fali seluꞌ kota daleꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ara losa rai Yusuf uma na, te ana bei nai naa. Boe ma ara sundaꞌ undulaka nara reuꞌ mata na. ");
INSERT INTO rgu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Boe ma Yusuf nasapaa si nae, “Hee! Ubeaꞌ taon de emi tao au leoꞌ ia! Emi ta bubuluꞌ mae, lahenda bauinaꞌ leoꞌ au ia, bisa siura-tokonoo lahenda nonoi-tatao nafunin?” ");
INSERT INTO rgu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Basa de Yahuda nataa nae, “Awii! Manetualain lufa poꞌiraoꞌ ami sala mara so. De ami bei mae ubea bali, papa? Ami sakaꞌ masalaꞌe tao ao-ina mara leoꞌ bea bali. Maneniko papa nau ena ma ami fadi mateꞌa tei-susum ia, sona malole lenaꞌ papa ena ma ami basa. Tao ami basa dadi meuꞌ papa atam leo.” ");
INSERT INTO rgu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tehuu Yusuf nataa nae, “Taꞌa! Hapu mok ria nai bea, sona ria riꞌ dadi neuꞌ au ata ka! Emi fekeꞌ ara bole fali leo emi papa ma meu leo!” ");
INSERT INTO rgu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Basa ria, de Yahuda naneneaꞌ leo Yusuf neu boe ma dedea nae, “Papa wakil! Au bubuluꞌ papa kuasa ma sama leoꞌ maneꞌ a. Huu ria na, bosoꞌ mamanasa mo au dei. Au hule fo dedea baiꞌ o papa dei. ");
INSERT INTO rgu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Useleꞌ a papa matane ami so mae, ‘Emi papa ma no fadi mi esa a, bei sodaꞌ, do?’ ");
INSERT INTO rgu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Basa de ami mataa mae, ‘Ami papa ma namalasi so. Ma ami fadi mateꞌa tei-susum esa boe. Tepoꞌ fo boki ni a, ami papa ma namalasi so. Fadi mateꞌa tei-susuꞌ ria aꞌa bokin esa, tehuu maten so. De besaꞌ ia, ela noi fadi mateꞌa tei-susuꞌ a mesaꞌ ana. Huu ria na, de ami papa ma sue naan seli.’ ");
INSERT INTO rgu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Basa de papa madenu ami mo fadim ria mai, ela papa bisa mita ni. ");
INSERT INTO rgu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Boe ma ami mataa mae, anaꞌ ria ta bisa laꞌo ela papa na fa. Maneniko ana laꞌo ela ni, sona ami papa ma maten naꞌ so. ");
INSERT INTO rgu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Boe ma papa mataa mae, ‘Maneniko emi ta mo fadim ria fa, sona emi ta bisa mita au mata ka soꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Basa de ami fali. Losa, boe ma ami tui dedeam sira katemaꞌ neu ami papa ma. ");
INSERT INTO rgu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Doo-doo boe ma ami nanaa mara basa si so. Basa de papa ka nadenu ami leo Masir mai seluꞌ, fo asa nanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tehuu ami mafada mae, ‘Papa, e! Ami ta bisa leo naꞌ meu soꞌ. Huu fo maneꞌ a lima boa onan ria nafada so nae, maneniko ami ta mo fadi mateꞌa tei-susum ria, sona ami ta bisa mita ria mata na soꞌ. De ami fadi mateꞌa tei-susu ma muste tuka dei, besaꞌ ko ami laꞌo.’ ");
INSERT INTO rgu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Boe ma ami papa ma dedea bali nae, ‘Emi bubuluꞌ so, hete? Au sao ki Rahel anaꞌ adaꞌ noi duaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana uluꞌ a neꞌes ana so. Tantu banda fuiꞌ ara odo raan so. Huu ria na, de losaꞌ besaꞌ ia au ta ita ni soꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Maneniko emi mo ana mateꞌa tei-susuꞌ ia neme au mai bali, boe ma ana hapu soe, sona emi tao tamba susa fee au nai fai lasi ka, de au mate leo.’ ");
INSERT INTO rgu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Huu ria na, papa wakil. Maneniko au ta oo faliꞌ fadi mateꞌa tei-susuꞌ ia leo papa ka neu, tantu ami papa ma maten naꞌ so. Huu fo papa ka sue naa anaꞌ ia seli. Ma ana namalasi naan seliꞌ so, de maneniko ami tao tamba fee ni susa, tantu ana mate. ");
INSERT INTO rgu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Lena-lenaꞌ bali au aheluꞌ o papa ka so ae, au riꞌ tanggong anaꞌ ria masoda na. Au aheluꞌ o papa ka ae, maneniko au ta oo faliꞌ anaꞌ ria leo papa ka neu fa, sona au riꞌ tanggong salaꞌ ria losaꞌ mate. ");
INSERT INTO rgu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","De au hule ae leo iaꞌ, papa: Ela leoꞌ bea na au kati ni fo leo ahaniꞌ ia, ela au riꞌ dadi uꞌ papa atam. Ela ria no aꞌa nara fali reu si. ");
INSERT INTO rgu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Maneniko anaꞌ ria ta tuka fa, sona au boe ta bisa fali fa. Au ta bisa anenete relu laꞌe papa ka doidoso na, losaꞌ mate.” ");
INSERT INTO rgu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf namanene leoꞌ na, boe ma dale na hedis a, losaꞌ ta bisa nanenete nai pegawe nara matan soꞌ. Huu ria na, de ana nadenu si deaꞌ reu, fo ela mesaꞌ ana no noi aꞌa-fadi nara. No ria na, ana bisa nafada aon nae ria nana, bea. ");
INSERT INTO rgu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Basa de pegawe sira basa si kalua, boe ma Yusuf dola namberaina, losaꞌ lahenda Masir fo rai deaꞌ, ara ramanene. Ma lahenda fo rai maneꞌ a uma na boe ramanene. ");
INSERT INTO rgu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Boe ma Yusuf tui ledo-ledo neuꞌ toranoo nara nae, “Ae! Aꞌa-fadi kara, e! Au ia Yusuf, emi toranoom! Papa ka bei nasoda, do?” Toranoo nara ramanene, boe ma ara bii raan seli, losaꞌ ara ta bisa dedea hata-hata esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Basa de Yusuf kape si nae, “Ae! Emi maneneaꞌ maiꞌ ia dei.” Ara raneneaꞌ leo Yusuf reu, boe ma ana dedea seluꞌ nae, “Au ia Yusuf, fo tepoꞌ ria emi seꞌo heni au leo Masir mai a. ");
INSERT INTO rgu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tetebes ara emi seꞌo heni au so. Tehuu emi bosoꞌ biiꞌ, bosoꞌ malelena aoꞌ, ma bosoꞌ esa sale esa bali. Sekonaa te, Manetualain riꞌ no au auluꞌ emi leo iaꞌ mai. De no ria na, Ana pake au, fo tulu-fali lahenda dodouꞌ, fo ara bosoꞌ mate huu laas a. ");
INSERT INTO rgu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Besaꞌ ia fai laas a besaꞌ ko laꞌo teuꞌ dua ian. Bei teuꞌ lima bali. Nai ledo-fai sira, lahenda ta foi dae, ta sele-tande ma ta hapu buna-boaꞌ esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","No enoꞌ fo ita ta bubuluꞌ ia, Manetualain noo au auluꞌ emi. Fo ela ruma neme emi moo emi tititi-nonosim rasoda, ma ta ramaꞌetu si fa. ");
INSERT INTO rgu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","De, tea na nana ta huu no emi nonoi-tataom fa losaꞌ au nai ia, tehuu Manetualain nonoi-tataon. Ria riꞌ tao na au dadi uꞌ mane Masir lima boa onan. Au dadi malaka malalau nai maneꞌ a uma mana pareta na boe. Ta hapu lahenda fekeꞌ bau lena au. ");
INSERT INTO rgu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Besaꞌ ia emi lai-lai fali leo, fo tui au dedea ka neuꞌ papa ka mae, leoꞌ ia: ‘Papa ka anan Yusuf bei nasoda! Ana dadi lahenda bauinaꞌ nai nusa Masir. Ria boe hule papa fo lai-lai leo Masir mu. ");
INSERT INTO rgu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Neuꞌ ko papa ka bole leo nai dae Gosen maneneaꞌ mo ni. Mamanaꞌ ria malole, ma loaꞌ a. De, papa ka bisa maboi bibilopo-kedaeꞌ, ma basa sapi mara. Ma ana hule boe fo papa ka mo upu-anam, uma isi mara, ma basa hata-hetom fo leo mahaniꞌ naa. ");
INSERT INTO rgu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Maneniko papa ka nai Gosen, sona ana bisa nahao-nafati papa ka nai naa. Huu fo fai laas a bei teuꞌ lima bali. De neuꞌ ko ana ator fo papa mo kileoboboki mara, papa ka banda-manum, ta kura-kai hata esa boeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf nafada basa, boe ma ana dedea bali nae, “Besaꞌ ia emi mita mataꞌ so, tebe au ia nana Yusuf. Ma Benyamin o boe, mita mataꞌ au so. ");
INSERT INTO rgu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","De mafada ita papa na mae, au kuasa ka nai Masir ia bau na seliꞌ. Ma tui papa ka basa-basan fo emi mita a. Basa ria, sona mo papa ka lai-lai leo iaꞌ mai leo!” ");
INSERT INTO rgu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Basa de ana holu na fadin Benyamin, de dua si radola ao. ");
INSERT INTO rgu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ana holu na aꞌa nara boe, de deꞌi esa-esa no si. Basa ria besaꞌ ko, ara mulai dedea roo ni. ");
INSERT INTO rgu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Basa de, faiꞌ fo maneꞌ a no pegawe nara ramanene rae Yusuf aꞌa-fadi nara mai, boe ma basa si ramahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Basa boe ma maneꞌ a dedea no Yusuf nae, “Yusuf, e! Mafada aꞌa-fadi mara, fo ara fua hade neuꞌ sira keledei nara, fo reni leo Kanaꞌan reu. ");
INSERT INTO rgu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Basa sona madenu si ro papa ma no basa kileoboboki nara, fo ara lali iaꞌ mai leo. Neuꞌ ko au fee si dae malole naan seli nai Masir, fo ara bisa leo reuꞌ naa, ma raa dae ria buna-boan. ");
INSERT INTO rgu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Boe ma mafada si, fo reni memaꞌ kareta hida neme iaꞌ mai, ela fua ro ana aanaꞌ ara ma papa ma. ");
INSERT INTO rgu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Boso afi hata posakaꞌ fo ta bisa reni si fa, huu fo basa lole-napuꞌ lalaꞌen nai Masir ia, neuꞌ ko ara soa si.” ");
INSERT INTO rgu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yusuf namanene leoꞌ na, boe ma ana fee si kareta hida ma tua-lepa, tuka maneꞌ a pareta na. Ma aꞌa-fadi nara boe rafafau fo fali reus tuka maneꞌ a pareta na. ");
INSERT INTO rgu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf boe fee si papake bebeuꞌ pasang bei esaꞌ. Tehuu ana fee Benyamin doifulaꞌ natun telu, ma papake bebeuꞌ pasang lima. ");
INSERT INTO rgu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ria boe haitua fee papa na hata fo malole naan seli neme Masir mai, fua si reuꞌ keledei maneꞌ sanahulu. Ana fee tamba seluꞌ hade, roti, ma nanaa rupaꞌ ara, nai keledei inaꞌ sanahulu, ela dadi tua-lepa soaneuꞌ asa ratafali leo Masir mai. ");
INSERT INTO rgu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Basa ria, de ana nadenu si fali ma nafarereneꞌ fee si nae, “Bosoꞌ mareresiꞌ nai enoꞌ, e!” ");
INSERT INTO rgu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Basa boe ma ara fali leo papa na reu nai Kanaꞌan. ");
INSERT INTO rgu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Losa naa, boe ma ara tui papa na rae, “Papa, e! Papa ka anam Yusuf bei nasoda. Ana dadi lahenda bauinaꞌ de pareta nai Masir!” Yakob namanene, boe ma noi namakokoaꞌ a, ma ana ta namahere sira dedean ria. ");
INSERT INTO rgu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tehuu noo ara tui basa Yusuf dedea nara, ma ana nita kareta fo Yusuf haitua ela fua roon leo Masir neu, besaꞌ ko ana mulai namahere. ");
INSERT INTO rgu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Boe ma ana dedea nae, “Awii! Au ana ka bei nasoda, oo! Leoꞌ na sona besaꞌ ko au amahoꞌo! Au muste u dama ni dei, besaꞌ ko au bisa mate no tesatei-tamadaleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Basa ria, boe ma Yakob nafafau ria hata-heto nara fo laꞌo ela Kanaꞌan. Losa koro Barseba, boe ma ana hala banda ela tao tutunu-hohotuꞌ fee Manetualain, fo riꞌ neme uluꞌ mai Isak doꞌo-tabe ni a. ");
INSERT INTO rgu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Hatuꞌ esa boe ma Yakob nalamei. Nai meis ria, ana namanene Manetualain naloo ni nae, “Ae! Yakob! Yakob! O foa fo nenene dei!” Boe ma ana nataa nae, “Ubeaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Basa de Manetualain nae, “Au ia Manetualain fo riꞌ o papa ma doꞌo-taben neme uluꞌ mai so. O bosoꞌ bii leo Masir mu. Neuꞌ ko Au tao a tititi-nonosim dadi lahenda nusa bauinaꞌ rai naa. ");
INSERT INTO rgu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Neuꞌ ko Au leo Masir uu sama-sama oo o. Ma neuꞌ ko Au oo faliꞌ tititi-nonosi mara leo dae Kanaꞌan reu. Fai bea ma o mate, neuꞌ ko anam Yusuf hapu hahae ma.” ");
INSERT INTO rgu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Basa ria, boe ma Yakob no ana nara foa ela koro Barseba. Ara fee ni no sao-ana nara saꞌe kareta fo riꞌ mane Masir a haitua so a. ");
INSERT INTO rgu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Ara reni basa sira hata-posaka nara katemaꞌ, ma basa banda-manuꞌ fo dadi sira nuhuun so, nai dae Kanaꞌan. Basa de Yakob no ana toun, ana inan, upu-anan, ma soro-san, basa si leo Masir reu. ");
INSERT INTO rgu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob kileobobokin fo lali leo Masir reu nana, siꞌ: Ruben, ana uluꞌ a. ");
INSERT INTO rgu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ria ana nara siꞌ: Henok, Palu, Hesron, ma Karmi. ");
INSERT INTO rgu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, no ana nara. Siꞌ: Yemuel, Yamin, Ohad, Yakin, ma Sohar. Ma Saul boe, fo Simeon saon lahenda Kanaꞌan a, anan. ");
INSERT INTO rgu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, no ana nara. Siꞌ: Gerson, Kehat, ma Merari. ");
INSERT INTO rgu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda, no ana nara. Siꞌ: Sela, Peres, ma Sera. Yahuda ana feke nara, Er no Onan, mate si rai Kanaꞌan so. Peres anan Hesron no Hamul tuka leo Masir boe. ");
INSERT INTO rgu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar, no ana nara. Siꞌ: Tola, Pua, Ayub, ma Simron. ");
INSERT INTO rgu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon, no ana nara. Siꞌ: Sered, Elon, ma Yahleel. ");
INSERT INTO rgu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sira basa nana, Yakob saon Lea anan fo boki si rai Mesopotamia. Ara ranuu ana inaꞌ boe, nade Dina. De Yakob no Lea tititi-nonosin basa si lahenda telu hulu telu. ");
INSERT INTO rgu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Boe ma, anaꞌ reme sao feke na mai. Siꞌ: Gad no ana nara: Sifion, Hagi, Suni, Esbon, Eri, Arodi, ma Areli. ");
INSERT INTO rgu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser, no ana nara. Siꞌ: Yimna, Yiswa, Yiswi, Beria, ma sira feto na, nade Sera. Beria nanuu anaꞌ boe: Heber no Malkiel. ");
INSERT INTO rgu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sira basa, lahenda sanahulu nee. Sira nana Yakob no saon Silpa upu-anan. Silpa nana, riꞌ ata fo Laban fee ria ana feton Lea, Yakob sao ulu na. ");
INSERT INTO rgu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Boe ma Yakob sao feken, nade Rahel. Ria boki na anaꞌ dua. Siꞌ: Yusuf no Benyamin. ");
INSERT INTO rgu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Tepoꞌ ria, Yusuf sao Asnat nai Masir so. Arama na, malaka agama nai kota On. Ria nade Potifera. Yusuf no Asnat ana nara, siꞌ: Efraim no Manase. ");
INSERT INTO rgu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin no ana nara boe tuka leo Masir reu. Siꞌ: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, ma Ared. ");
INSERT INTO rgu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yakob no saon Rahel tititi-nonosi nara, lahenda sanahulu haa. ");
INSERT INTO rgu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yakob bei nanuu saoꞌ esa bali, nade Bilha. Ria boki naa anaꞌ dua, siꞌ Dan noo Naftali. Dan ana na, nade Husim. ");
INSERT INTO rgu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali, no ana nara. Siꞌ: Yasel, Guni, Yeser, ma Silem. ");
INSERT INTO rgu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob no saon Bilha tititi-nonosi nara, lahenda hitu. Bilha nana, Rahel atan fo ana hapu neme papan Laban mai. ");
INSERT INTO rgu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","De, Yakob tititi-nonosin fo leo Masir reu nana, basa si lahenda nee hulu nee. Bei ta rekeꞌ manafeu nara. ");
INSERT INTO rgu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tamba Yusuf, no ana nara fo riꞌ boki si rai Masir, lahenda dua. De, Yakob no kileobobokin fo leo rai Masir a, basa si lahenda hitu hulu. ");
INSERT INTO rgu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tepoꞌ fo ara sakaꞌ losa Masir, boe ma Yakob nadenu anan Yahuda neu nauluꞌ, fo naloo Yusuf mai naneta no papa na nai Gosen. Ara losa rai Gosen, ");
INSERT INTO rgu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","boe ma Yusuf saꞌe na kareta na, fo neu naneta no papa na, nai naa. Ara raneta, boe ma Yusuf holu na papa na, de ana dola doo na seliꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Basa boe ma Yakob dedea no Yusuf nae, “Yusuf, ee! Besaꞌ ia, au ita mataꞌ o so. Ma au bubuluꞌ so, o bei masoda. Huu ria na, leo mae besaꞌ ia au mate boe, malole a.” ");
INSERT INTO rgu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Boe ma Yusuf nafada basa aꞌa-fadi nara nae, “Au muste u afada maneꞌ a ae, au kileoboboki kara reme Kanaꞌan mai so. ");
INSERT INTO rgu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Boe ma neuꞌ ko au afada ae, emi nana lahenda manamaboi bibi-lopo ma sapi. Huu ria na, de emi meni basa banda-manuꞌ, ma posaka mara reme Kanaꞌan mai. ");
INSERT INTO rgu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Maneniko maneꞌ a naloo emi, ma natane nae emi biasa moi-tao nonoi ubeaꞌ, ");
INSERT INTO rgu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","sona mataa ni mae, emi basa ia manamaboi banda meme aana mara mai, sama leoꞌ emi bei-baꞌi mara, fo ela ana nadenu emi leo nai dae Gosen.” Yusuf nafada nae leoꞌ na, nana huu maneniko lahenda Masir leo rabua ro manafoo ra, sona ara rahiaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Basa boe ma, Yusuf no toranoon lima reu rasare maneꞌ a. Yusuf tui nae, “Papa mane! Au papa ka ma aꞌa-fadi kara remeꞌ Kanaꞌan mai so. Ara mai reni sira bibi nara, ma sapi nara, ma hata-heto nara katemaꞌ. Besaꞌ ia basa si rai dae Gosen so.” ");
INSERT INTO rgu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Basa de maneꞌ a natane nae, “Emi nonoi-tataom ma ubeaꞌ?” Boe ma rataa maneꞌ a rae, “Ami ia manafoo, sama leoꞌ ami bei-baꞌi mara. ");
INSERT INTO rgu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Besaꞌ ia, fai hanas masalaeꞌ a nai dae Kanaꞌan losaꞌ ta hapu nanaaꞌ ma nau-aidoo soꞌ. Huu ria na, ami maiꞌ nusaꞌ ia fo leo lalai. Ami meni banda-manu mara boe. Besaꞌ ia ami hule neuꞌ papa mane fo fee ami leo nai dae Gosen, ela ami maboi banda-manu mara rai na.” ");
INSERT INTO rgu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Boe ma maneꞌ a nafada ria hihii-nanaun neuꞌ Yusuf nae, “Besaꞌ ia o papa ma no aꞌa-fadi mara rai ia so. ");
INSERT INTO rgu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","De, ara bole tao nusaꞌ ia sama leoꞌ sira nusa-namo hehelin. Au bubuluꞌ dae Gosen, nana malole a naan seli nai nusaꞌ ia. De malole lenaꞌ ara leo reuꞌ na. Ma sira bea raboi ralelaꞌ banda no malole, sona ela sira boe urus au nuu kara reuꞌ na.” ");
INSERT INTO rgu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Basa de Yusuf no papa na leo maneꞌ a reu, ela nalelaꞌ ana. Boe ma Yakob hule-haradoi neuꞌ Manetualain fo fee maneꞌ a ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Boe ma maneꞌ a natane Yakob nae, “Papa, teu mi hida ian so?” ");
INSERT INTO rgu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob nataa nae, “Au teu ki natun esa telu hulu so, tehuu au ta leo ahaniꞌ mamanaꞌ esaꞌ a. Au bei-baꞌi kara leo naꞌ boe. Maneniko nararaaꞌ ana noo si, sona au teuꞌ kara ta desi si fa. Tehuu henuꞌ noo doidoso.” ");
INSERT INTO rgu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Basa de, Yakob nateꞌa maneꞌ a. Tehuu ana bei ta laꞌo fa, te ana hule bali fo Manetualain fee maneꞌ a ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusuf tuka maneꞌ a nafada na, de ana natudu fee si mamanaꞌ nai dae Gosen. Mamanaꞌ ria malole na seli. (Neuꞌ ko ara hule mamanaꞌ ria rae, ‘Rameses’.) Boe ma Yusuf papa na, ma aꞌa-fadi nara leo raroo reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf boe sadia nanaaꞌ fee papa na, aꞌa-fadi nara, ro basa sao-ana nara, neme bauinaꞌ a mai losa aanaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Fai laa-roes ria masalae naan seli, losaꞌ nai basa mamanaꞌ ara, nanaaꞌ taꞌa so. Neme Masir mai losa Kanaꞌan, lahenda ra roi mamaleꞌ ao nara so. Ara ta bisa roi-tao hata esa so boeꞌ, nana huu ramalaa raan seli. ");
INSERT INTO rgu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Basa lahenda reme basa mamanaꞌ nai Masir, ma basa mamanaꞌ nai Kanaꞌan, mai fo asa nanaaꞌ nai Yusuf. Boe ma ana nabubua na katemaꞌ doiꞌ sira, de neu peda si reuꞌ maneꞌ a uma na. ");
INSERT INTO rgu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tepoꞌ ria lahenda Masir ro lahenda Kanaꞌan ara basa doi nara so. Huu ria na, ara ta bisa asa nanaaꞌ soꞌ. Boe ma ara mai rasare Yusuf, de hule rae, “Papa wakil, e! Fee ami nanaaꞌ dei, ela bosoꞌ ami mate no laas. Te ami doi mara basa si so.” ");
INSERT INTO rgu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Boe ma Yusuf nataa nae, “Maneniko tebe emi doiꞌ taꞌa, sona tao leo iaꞌ: fee emi banda-manum leo au mai, fo seluꞌ neuꞌ nanaaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Basa de ara fee banda-manu nara leo Yusuf reu, fo seluꞌ neuꞌ nanaaꞌ. Riꞌ sira dara nara, bibi, sapi ma keledei nara. Nana huu teuꞌ ria, Yusuf helu nae leoꞌ na so. ");
INSERT INTO rgu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Natafali teuꞌ a, boe ma ara leo Yusuf mai rae, “Papa wakil, e! Ami tui teaꞌ ia so. Ami doi mara, ma banda mara, papa seluꞌ ma katemaꞌ asa so. Besaꞌ ia ta hapu hata esa so boeꞌ. Ela noi ami ao-ina ma, ma oe-dae mara so. ");
INSERT INTO rgu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Bosoꞌ mataaꞌ ami mate. Maneniko ami mate, sona bea urus dae sira bali? Malole lenaꞌ ami dadi ata fee papa wakil. Ma papa boe hai ma ami oe-dae mara, fo soa si. Basa nana papa fee bini-kee, fo ami sele-tande fee papa. Basa nana ami sosotam, ma ami oe-daem ria, papa kati ni neniꞌ nanaaꞌ. Sadi bosoꞌ ami mate!” ");
INSERT INTO rgu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Huu no fai laa-roes boe-boe masalaeꞌ a, de lahenda Masir seꞌo heni oe-dae nara. Boe ma Yusuf asa na katemaꞌ dae nai Masir fo dadi neuꞌ maneꞌ a posakan. ");
INSERT INTO rgu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","No ria na, de basa anaraun Masir dadi reuꞌ maneꞌ a atan. ");
INSERT INTO rgu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tehuu Yusuf ta asa malaka agama ra oe-daen fa, nana huu maneꞌ a fee si nanaaꞌ naroo. Huu ria na, de ara ta parluu seꞌo sira oe-dae nara. ");
INSERT INTO rgu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Tepoꞌ ria boe, Yusuf dedea no anaraun ara nae, “Besaꞌ ia emi dadi meuꞌ maneꞌ a atan so. Emi oe-dae mara boe, au asa a katemaꞌ asa, fee maneꞌ a so. De, emi hai ma bini-kee ia ra, fo meu sele neuꞌ dae sira leo. ");
INSERT INTO rgu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Basa fo etu-oru, sona emi bati neuꞌ babatiꞌ lima. Babatiꞌ esa meni fee maneꞌ a. Ma sisa babatiꞌ haa nana mabini, ma emi mo kileoboboki mara mia.” ");
INSERT INTO rgu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Boe ma ara rataa rae, “Papa fee ami sodaꞌ a so, huu ria na ami hule makasi dodouꞌ. Ami nau dadi meuꞌ papa maneꞌ ata ma.” ");
INSERT INTO rgu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Basa de Yusuf tao atoran ria dadi neuꞌ hadas nai nusa Masir. Huu ria na, neme basa hade fo anaraun ara oru, sona ara bati neuꞌ babatiꞌ lima. Babatiꞌ esa ara fee maneꞌ a. Ara soa babatiꞌ haa. Adaꞌ noi malaka agama ra oe-daen, sona ta dadi reuꞌ maneꞌ a nuun fa. Yusuf atoran ria ara bei pake raroon losaꞌ besaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mulai neme naꞌ mai, boe ma lahenda Israel ara leo rahaniꞌ Masir, nai dae Gosen. Ara dadi lahenda kamasuꞌi, ma tititi-nonosi nara tamba dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nai Masir, Yakob bei nasoda seluꞌ teuꞌ sanahulu hitu, losaꞌ ria teun natun esa haa hulu hitu. ");
INSERT INTO rgu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Basa de fai mamate na naneneaꞌ so, boe ma ana naloo na Yusuf de nafadan nae, “Ana Usu, e! Au namemeda ka nana ta dooꞌ a soꞌ, te Manetualain naloo nafaliꞌ au. De au hule, maneniko sue au, sona o soo-supa, fo bosoꞌ matoi au nai dae Masir ia. ");
INSERT INTO rgu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","O muste muni faliꞌ au popora ka leo ita bei-baꞌin mamana roo-raten. Fo matoi au nai naa. Ria nana papa hihii-nanaun!” Boe ma Yusuf nataa nae, “Malole a, papa! Maneniko papa ka hihii ma leo naꞌ, sona au tuka-tuka mesan.” ");
INSERT INTO rgu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Boe ma Yakob dedea nae, “Kalu leoꞌ na, sona besaꞌ ia o soo-supa dei, mae o tuka papa hihii-nanaun.” Boe ma Yusuf soo-supa tuka Yakob dedean ria. Basa de Yakob sundaꞌ undulaka na nai koi lain, hule-haradoi fo hule makasi neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ta doo bea boeꞌ te, lahenda mai rafada Yusuf rae, papa na hedi beraꞌ so. De ana no anan dua si, Manase no Efraim, fo reu dama baꞌin Yakob. ");
INSERT INTO rgu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakob namanene Yusuf asa mai so, boe ma ana laꞌa ao na fo natuuꞌ neuꞌ koi lain. ");
INSERT INTO rgu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Boe ma ana nafada Yusuf nae, “Ana Usu, e! Faiꞌ naa ra Manetualain fo Manakuasa Kahereꞌ Nan Seli, natudu Ao na neuꞌ au so, nai koro Lus nai dae Kanaꞌan. Nai naa Ana helu au. ");
INSERT INTO rgu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ana dedea nae, ‘Neuꞌ ko Au fee o upu-ana mara tamba dodouꞌ, ela o tititi-nonosim dadi reuꞌ lahenda nusa bauinaꞌ. Neuꞌ ko Au boe fee nusaꞌ ia neuꞌ o tititi-nonosi mara, fo dadi neuꞌ sira posakan losaꞌ dae-bafoꞌ a noe.’ ");
INSERT INTO rgu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Besaꞌ ia, o anam Efraim no Manase, sira hak na leo iaꞌ: au leo Masir mai, te boki sira dua so. Leo mae leoꞌ na boe, besaꞌ ia au tao dua si sama leoꞌ au ana boki kara, leoꞌ Ruben no Simeon. ");
INSERT INTO rgu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tehuu maneniko o boki seluꞌ, sona ria nana o anam. Au ta tao si reuꞌ ana ki soꞌ. Ela sira dei sipo posakaꞌ neme sira aꞌan Efraim no Manase mai. ");
INSERT INTO rgu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Au tao leo naꞌ, fo afarene o mamam Rahel. Tepoꞌ fo ami fali meme Mesopotamia mai leo Kanaꞌan meu, losa eno taladaꞌ naneneaꞌ koroꞌ Efrata nai dae Kanaꞌan, boe ma o mama ma boki de maten. Tepoꞌ ria, au susa an seli! Boe ma au atoi ni nai enoꞌ fo leo koro Efrata neu a, suu na.” (Besaꞌ ia ara fee koroꞌ ria nade, Betlehem.) ");
INSERT INTO rgu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Yakob dedea basa de botiꞌ laka na, boe ma nita Yusuf ana nara rai na. Basa de ana natane Yusuf nae, “Ae! Bea ana ni ia ra? Yusuf nataa nae, “Ia ra nana anaꞌ fo Manetualain fee au nai Masir ia.” Basa boe ma Yakob dedea nae, “Maneniko leoꞌ na, sona mo si mai raneneaꞌ ro au, fo au hule-haradoi neuꞌ Manetualain ela fee si ua-naleꞌ.” Yakob namalasi so, ma mata nara rasasapu so. Huu ria na, de ana ta bisa nita dae, matetuꞌ soꞌ. Boe ma Yusuf no ana nara reu raneneaꞌ ro Yakob, fo ana holu si ma deꞌi. ");
INSERT INTO rgu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Basa boe ma ana dedea no Yusuf nae, “Doo-naru basa ia, au afi ae bate ta aneta o, o soꞌ. Tehuu besaꞌ ia, Manetualain tao lena ria bali, losaꞌ au bei bisa ita o ana mara.” ");
INSERT INTO rgu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Basa de Yusuf naheoꞌ heni ana nara reme Yakob mai, boe ma ana sundaꞌ undulaka na, ma mata-idun neta dae a, nai papa na matan. ");
INSERT INTO rgu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Basa de Yusuf foa. Boe ma ana fee ana nara rapadeiꞌ raneneaꞌ ro papa na. Ana fee ana uluꞌ a, Manase, napadei neuꞌ Yakob boboa ona na; ma fadiꞌ a, Efraim neuꞌ Yakob boboa ii na. ");
INSERT INTO rgu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yakob sakaꞌ fua lima na fo hule fee dua si ua-naleꞌ, te ana narali na lima ona na fuan neuꞌ Efraim, fadiꞌ a laka na, ma ana fua lima ii na neuꞌ Manase aꞌa a, laka na. ");
INSERT INTO rgu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Boe ma ana hule-haradoi fo ela Manetualain fee Yusuf ua-naleꞌ nae, “O baꞌim Isak papan Abraham, ma o baꞌi bokim Isak, sira dua tuka raroo Manetualain hihii-nanaun. Manetualain boe naboi-nasamao au so, eme muri ana ka mai losaꞌ besaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ana poꞌi-tata na au eme basa soe rupaꞌ ara mai. De au hule boe, fo Ana fee ua-naleꞌ neuꞌ anaꞌ ia ra ma tititi-nonosi nara. Boe ma maneniko ara hule-haradoi neuꞌ Manetualain, ara ta rafarene henin baꞌi Abraham, baꞌi Isak, ma au nade ka. Ela leoꞌ bea na sira tititi-nonosin tamba dodouꞌ, fo dadi lahenda nusa bauinaꞌ nai dae-bafoꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tehuu Yusuf nita papa na fua lima ona na neuꞌ Efraim fadiꞌ a laka na, de ana narali papa na lima na, fo fuan neuꞌ Manase aꞌa a laka na. ");
INSERT INTO rgu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ana nafada papa na nae, “Papa, e! Bosoꞌ tao leo naꞌ. Te Efraim nana fadiꞌ ria. Uluꞌ a ta ria fa. Papa ka muste fua lima ona ma neuꞌ Manase, aꞌa a laka na. Huu fo ana uluꞌ a hak na ria.” ");
INSERT INTO rgu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tehuu papan Yakob ta nau fa. Ana nae, “Ana on, e! Tebe au bubuluꞌ! Tehuu neuꞌ ko Manase dadi kahereꞌ, ma ria tititi-nonosin tamba dodouꞌ losaꞌ dadi lahenda nusa bauinaꞌ. Tehuu fadin Efraim neuꞌ ko kahereꞌ lena neme ria mai. Ma ria tititi-nonosin, neuꞌ ko dodouꞌ raan seli losaꞌ ara dadi lahenda nusa kahereꞌ dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Basa boe ma ana nafada ana sira dua nae, “Maneniko lahenda Israel hule Manetualain fee lahenda ua-naleꞌ, sira boe seseiꞌ emi dua nade mara. Neuꞌ ko ara hule rae, ‘Ela leoꞌ bea na Manetualain fee o ua-naleꞌ, sama leoꞌ Ana fee ua-naleꞌ neuꞌ Efraim no Manase.’ ” No ria na, Yakob boe seseiꞌ nauluꞌ Efraim fadiꞌ a nade na, besaꞌ ko Manase, aꞌa a nade na. ");
INSERT INTO rgu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Basa boe ma Yakob nafada Yusuf nae, “Ana ki on, e! Ta doo a soꞌ, te au mate. Tehuu neuꞌ ko Manetualain tulu-fali emi, ma noo faliꞌ emi leo bei-baꞌi mara nusa-namon meu. ");
INSERT INTO rgu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tehuu besaꞌ ia, au bati fee o lena nemeꞌ aꞌa-fadi mara mai. Huu fo au fee tamba o leteꞌ nai dae Kanaꞌan, fo maulu na au alea an neme lahenda Amori ra mai, tepoꞌ fo au atati o si a.” ");
INSERT INTO rgu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Basa ria, boe ma Yakob nadenu fo raloo basa ana nara. Basa si mai, boe ma ana nafada nae, “Ana kara, e! Mai fo emi basa mabua maneneaꞌ mo au nai ia dei. Au sakaꞌ afada emi, esa-esaꞌko eno masoda na, nai mabui a.” ");
INSERT INTO rgu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Boe ma Yakob mulai nafada memaꞌ ana nara nae, “Leo iaꞌ! Yakob ana nara emin! Emi mai mapadeiꞌ eo ma au. Mamanene emi papam Israel dedea na. ");
INSERT INTO rgu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! O ia, nana au ana ulu ka! O ia, nana au teteꞌe ka, ma au lima boa ona ka. Lahenda hadaꞌ ra o seli. ");
INSERT INTO rgu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tehuu o dale ma sama leoꞌ nafa a, de koka neu-mai. Kekeneu te, o mu suku moꞌ au sao ki Bilha so, de tao makekeo o papa ma mamana susuku na. Huu ria na, de o pangkat ulu-bau-ina ma tuda tutiꞌ a! ");
INSERT INTO rgu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeonmo Lewi! Emi dua moi maraaꞌ a. Emi dua muda laesaꞌ soꞌu tafaꞌ, fo tao fee lahenda doidoso. ");
INSERT INTO rgu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Emi namahoꞌo ma, riꞌ tati maetu sapi ra ei pipii nara, losaꞌ ara dile eeto adaꞌ mamanan. Ma tadalu mara bali, riꞌ emi heku nisi mara, besaꞌ ko maisa lahenda. Huu ria na, de au ta nau tao daleꞌ neuꞌ emi dedea-nafadam. Au boe ta nau sososoꞌ leo emi dedea ma. ");
INSERT INTO rgu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","De, besaꞌ ia au kutuk emi meru-ranim ria, huu fo talalu so! Ma nasa-boliim fo ta nanuu dale kasian baiꞌ boeꞌ. Neuꞌ ko emi lepa ao mara tadalum sira. Neuꞌ ko Manetualain fee emi tititi-nonosi mara esaꞌko matan. Basa te ara leo kofela rai basa mamanaꞌ nai dae Israel. ");
INSERT INTO rgu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! O nade ma sosoa na nae, ‘iꞌio’. O aꞌa-fadi mara neuꞌ ko ara io neuꞌ o, ma fee o hada-horomata. O maseki musunoo mara, losaꞌ ara ta bisa botiꞌ laka nara. ");
INSERT INTO rgu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O ia sama leoꞌ singa fadi dua kahereꞌ, fo bisa saka aon nanaaꞌ. O boe sama leo singa maneꞌ fo hela naroroo aon sakaꞌ suku; ta hapu hata esa naparani neu tatao o boeꞌ. O boe sama leoꞌ singa inaꞌ a nanea ana na; ta hapu lahenda naparani neu tafaruruu ni. Leoꞌ na boe neuꞌ o. Lahenda lele o, ma ara ta raparani tao rupa-rupaꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Neuꞌ ko o ia, homu pareta. O tititi-nonosi mara boe, homu pareta ratutuka ao, losaꞌ neuꞌ ko hapu Esa nanuu hak lena heni basan, natuuꞌ homu pareta ria. Basa lahenda nusaꞌ ara doꞌo Ni, ma ramanene Ni. ");
INSERT INTO rgu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Neuꞌ ko o masoda no namahoꞌo-natadaleꞌ. O mahiiꞌ ubeaꞌ boe, hapu! O mahiiꞌ tao ubeaꞌ boe, dadi! O banda-manu mara, ma oke-tinem buna-boan tamba dodouꞌ losaꞌ henu-sofeꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","O nanaa-nininu mara mina-malada, ta etu-basan. ");
INSERT INTO rgu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! O dae posaka ma loa na seli, ma naneneaꞌ tasiꞌ a, losaꞌ natoo no kota Sidon. Ofaꞌ ara reme basa mamanaꞌ ara, mai fo nafu no malole nai o namo-sesee ma. ");
INSERT INTO rgu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! O ia sama leoꞌ keledei baraaiꞌ, tehuu o laka batu ma seli. Maneniko o suku nai enoꞌ lain, sona bea riꞌ bei bisa neu nafoa o, fo laꞌo naroo. Tehuu maneniko o mita koro malole nai seriꞌ ele, sona ta radenu fa boe, o fua ma hata mara fo muu leo. O nana leo naꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! O nade ma sosoa na nae, ‘mana ee dedeaꞌ’. O mo tititi-nonosi mara, neuꞌ ko maetuꞌ o leo ma dedea nara no matetuꞌ. Huu fo o leo ma, nana esa neme lahenda nusa Israel ara. ");
INSERT INTO rgu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","O kate-lale ma boe sama leoꞌ meke manuu rasoꞌ fo luꞌu nai enoꞌ a suu na. Maneniko lahenda saꞌe dara resiꞌ naa, sona kekeneu te o aa neuꞌ dara a ei pipii na so, losaꞌ lahenda mana saꞌe a lokopiro mai. ");
INSERT INTO rgu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oo, MANETUALAIN! Au hule fo O fee ami basa sodaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! O nade ma hiiꞌ nae sama leoꞌ ‘suu’. Neuꞌ ko parampok ara mai suu fo soaꞌ o, tehuu o maseki si. ");
INSERT INTO rgu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Neuꞌ ko oka-tinem buna-boa nara malole naa seli, losaꞌ o bisa tao nanaa-nininu mina-malada mabeli, fo maneꞌ ara mai asa. ");
INSERT INTO rgu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! O ia, sama leoꞌ rusa ina fuiꞌ a, de ta hapu lahenda bisa ator rala o. O boe boki maa ana mara, napuꞌ-napuꞌ mesan. ");
INSERT INTO rgu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! O sama leoꞌ ai huu malabaꞌ, fo nasoda naneneaꞌ nai oe mataꞌ. O doo-rana mara ralaba leo tembok madema a reu. ");
INSERT INTO rgu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Hapu lahenda tuꞌu-tapa fee o salaꞌ, sama leoꞌ musunooꞌ a ou o. ");
INSERT INTO rgu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tehuu Manetualain fo au doꞌo-tabe ni a, tulu-fali o. Huu ria na, Ana tao na lima ma baraaiꞌ, losaꞌ bisa ou balas sira, leo mae neme dooꞌ a mai. O bisa maseki si, nana huu Manetualain riꞌ tulu-fali o. Ria kuasa Na tebe kahereꞌ. De au asarai neuꞌ Ana, huu fo Ria riꞌ nanea au. ");
INSERT INTO rgu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ria boe neuꞌ ko nanea o. Ma Ana fee o ua-naleꞌ, ua-naleꞌ nemeꞌ lalai mai, ua-naleꞌ neme dae-bafoꞌ a mai, ma ua-naleꞌ boboki-lalaeꞌ de boki ma ana mapii-baraaiꞌ dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Leteꞌ ara ta mopo si. Ma au fee o ua-naleꞌ ia, desi lena basa leteꞌ ara! Ela leoꞌ bea na basa ua-naleꞌ ia ra, nanapoꞌa leo o reu, nana huu o lena neme aꞌa-fadi mara mai. ");
INSERT INTO rgu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! O naparani ma sama leoꞌ busa fuiꞌ mamalaaꞌ a. Maneniko balahaa anaꞌ, sona ana sopu-daka, de hapu paaꞌ. Maneniko hatuꞌ, sona ana neu bati-pala paaꞌ fee ana nara. O tititi-nonosi mara kahereꞌ leoꞌ na boe.” ");
INSERT INTO rgu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yakob dedea na noi ri naaꞌ so. Ana nafada memaꞌ dedea-nafadaꞌ ria soaneuꞌ ana nara eno masodan ma ua-nale nara nai fai mabuiꞌ a. Ana nafada soaneuꞌ sira esa-esaꞌ ko nooꞌ tititi-nonosin. Sira basa dadi reuꞌ Israel leo kasanahulu dua nara. ");
INSERT INTO rgu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Basa ria boe ma Yakob helu ana nara nae, “Ta dooꞌ a soꞌ, te au mate. Maneniko mate au, sona emi muste meu matoi au nai baꞌi Abraham rate na. Rates ria nai leaꞌ, naneneaꞌ no koroꞌ Makpela ma Mamre, nai dae Kanaꞌan. Maulu na baꞌi Abraham asa na leaꞌ ria no oka-tinen, fo tao ni neuꞌ mamana roo-rates na. Ana asa neme lahenda leo Het, nade Efron. ");
INSERT INTO rgu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nai naa ara ratoi ita Baꞌin Abraham no ita bein Sara, au papa ki Isak, ma au mama ki Ribka. De, emi boe muste matoi au nai naa, neuꞌ au sao ki Lea boboa na. ");
INSERT INTO rgu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Emi bosoꞌ mafarene henin matoi au nai leaꞌ fo baꞌi Abraham asa nan so a.” ");
INSERT INTO rgu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob dedea nae leoꞌ na, basa de ana napeuꞌ seluꞌ neuꞌ koi lain, boe ma mate ni. ");
INSERT INTO rgu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Basa de Yusuf holu na papa na, boe ma ana boreu. Ana deꞌi nasarerei papa na. ");
INSERT INTO rgu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Boe ma Yusuf pareta lahenda mana urus poporaꞌ a, fo tao modo-aidoo neuꞌ Yakob popora na, ela bosoꞌ nasalaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","De, ara urus poporaꞌ ria losa faiꞌ haa hulu, tuka sira hada na. Yakob mamate na, nana basa lahenda Masir ara boe dola. Ara tao leo naꞌ losa faiꞌ hitu hulu, sama leoꞌ mate sira lahenda bauinan. ");
INSERT INTO rgu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Basa faiꞌ hitu hulu, boe ma Yusuf nafada pegawe nara nae, “Nenene! Au hule fo emi meni au dedea ki ia, meu mafada maneꞌ a mae leo iaꞌ: ");
INSERT INTO rgu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Fai fo au papa ka sakaꞌ mate, ana helu au fo uu atoi popora na nai dae Kanaꞌan. De au hule maneꞌ a poꞌi au ela u atoi papa ka. Basa sona besaꞌ ko au fali leo iaꞌ mai.’ ” ");
INSERT INTO rgu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Maneꞌ a namanene leoꞌ na, boe ma nataa nae, “Maneniko o helu leoꞌ na soaneuꞌ papa ma, sona muu matoin nai na leo.” ");
INSERT INTO rgu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Boe ma Yusuf neu natoi papa na. Lahenda dodouꞌ tuka roo ni reu boe. Manatukaꞌ sira, nana maneꞌ a pegawe nara, ma basa lahenda bauinaꞌ reme Masir mai. ");
INSERT INTO rgu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf aꞌa-fadi nara, ma basa lahenda mana noi nara boe tuka reu ratoi Yakob. Foa ela nai Gosen, nana adaꞌ noi saoina nara ro ana aanaꞌ ara, ma sira banda-manun. ");
INSERT INTO rgu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Soldadu dodouꞌ tuka boe. Ruma saꞌe kareta, ma ruma saꞌe dara. Huu no manatukaꞌ ara dodou raan seli, de manamatoi sira ranononda naru na seli. ");
INSERT INTO rgu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Basa si laꞌo losaꞌ lena lee Yarden, nai mamanaꞌ esa nade Atad. Lahenda biasa mai popoꞌo hade nai na. Yusuf asa boreu papa na mamaten nai mamanaꞌ ria. Boe ma ara mete seluꞌ hatuꞌ hitu bali. ");
INSERT INTO rgu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Lahenda Kanaꞌan rai naa, rita susa leoꞌ na, boe ma ara dedea rae, “Ae! Emi mete dei. Lahenda Masir ara mete mamates, sona ara dola raan seli.” Huu ria na, de lahenda ra fee mamanaꞌ ria nade, Abel-Misraim. Sosoa na nae, ‘Lahenda Masir lumata-pinuidun.’ ");
INSERT INTO rgu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yakob ana nara tao tuka sama leoꞌ sira hehelun ria. ");
INSERT INTO rgu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","De, ara oꞌo reni Yakob popora na, de reu ratoin nai leaꞌ fo naneneaꞌ koro Makpela no Mamre. Abraham asa na mamanaꞌ ria so, neme lahenda leo Het mai, nade Efron, fo ana taon dadi neuꞌ sira mamana roo-raten. ");
INSERT INTO rgu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf natoi basa papa na, boe ma no basa aꞌa-fadi nara ma lahenda fekeꞌ fo reu ratoi a, ara fali leo Masir reu. ");
INSERT INTO rgu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ara losa Masir, boe ma Yusuf aꞌa nara mulai biiꞌ. Huu no sira papa na neꞌes ana so, boe ma ara dedea rao nara rae, “Ae! Emi afi dei! Uniꞌko leo Yusuf bei napeda daleꞌ no ita, de ana balas ita tatao tadalu na neuꞌ ana a, sona leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Basa de rala haraꞌ fo fee reu rafada Yusuf rae leoꞌ ia: “Papa wakil. Ami bei mafarene tepo fo ita papa na bei nasoda, ana nadenu ami ");
INSERT INTO rgu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","fo mafada papa mae, ‘Usu muste nafarene heni aꞌa nara sala-sikon. Nana huu maulu na ara tao tadaluꞌ soaneuꞌ ana so.’ Ami boe mafarene neme uluꞌ mai ita papa na doꞌo-tabe neuꞌ Manetualain. Ami boe dadi meuꞌ Manetualain ata nara. Huu ria na, besaꞌ ia ami hule ampon, nana huu ami tao masalaꞌ papa so.” Yusuf namanene leoꞌ na, boe ma ana dola. ");
INSERT INTO rgu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Basa boe ma aꞌa nara mai mataꞌ, de sundaꞌ undulaka nara reuꞌ Yusuf mata na, ma ara dedea rae, “Ela leoꞌ bea na papa tao ami dadi meuꞌ papa atam.” ");
INSERT INTO rgu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tehuu Yusuf nafada si nae, “Aꞌa kara, e! Emi bosoꞌ bii bali! Adaꞌ noi Manetualain riꞌ nanuu hak huku lahenda. Tehuu au ia, sona taꞌa. ");
INSERT INTO rgu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Maulu na tebe emi mala haraꞌ, fo tao tadaluꞌ soaneuꞌ au. Tehuu emi hihii-nanau tadalum ria, Manetualain naralin so fo dadi malole. Huu ria na, de Ana soꞌu naa au dadi malaka bauinaꞌ, fo ela lahenda dodouꞌ bisa hapu sodaꞌ. ");
INSERT INTO rgu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","De, besaꞌ ia au afada emi, fo bosoꞌ bii bali. Huu fo au helu neuꞌ ko au relu-atanae emi, ma basa upu-ana mara.” No Yusuf dedea malolen ria, boe ma tao natatama aꞌa nara dalen. ");
INSERT INTO rgu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Basa de Yusuf no aꞌa-fadin basa si leo rahaniꞌ Masir. Ana nasoda losa teuꞌ natun esa sanahulu. ");
INSERT INTO rgu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ana bei nita Efraim upu-anan. Ma ria riꞌ nahao-nafati Manase upu nara boe, siꞌ Makir ana nara. ");
INSERT INTO rgu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf nafada aꞌa nara nae, “Aꞌa kara, e! Au ameda an nana fai mamate ka naneneaꞌ so. Tehuu au amahere Manetualain naboi-nasamao emi. Ria riꞌ neuꞌ ko poꞌi-tata na emi meme nusaꞌ ia mai. Ria boe napipipi-nalalaꞌo emi fali leo nusaꞌ fo Ana soo-supa so, helu feen neu baꞌi Abraham, baꞌi Isak, ma ita Papan Yakob.” ");
INSERT INTO rgu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Boe ma Yusuf hule toranoo nara, soo-supa rae, “Emi muste helu maiꞌ au dei. Maneniko losa tepoꞌ fo Manetualain no faliꞌ emi leo nusaꞌ ria meu, sona emi muste meni au dui-aalu ka boe.” ");
INSERT INTO rgu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Basa boe ma Yusuf maten nai Masir, neu teun natun esa sanahulu. Ara tao modo-aidoo neuꞌ popora na. Boe ma ara tatana etun neuꞌ opaꞌ daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Susuraꞌ ia tui laꞌe-neuꞌ Yesus Kristus, Lahenda fo riꞌ nemeꞌ uluꞌ mai Manetualain helu memaꞌ nau fee Ni mai. Ria nana, mane Daud ma baꞌi Abraham tititi-nonosin. Mulai neme baꞌi Abraham losa mane Daud a, nana tititi-nonosiꞌ sanahulu haa. Ria bei-baꞌin nade nara siꞌ: Abraham boki Isak, Isak boki Yakob, Yakob boki Yahuda no aꞌa-fadi nara, ");
INSERT INTO rgu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda boki Peres no Sera (sira mama na, nade Tamar), Peres boki Herson, Herson boki Ram, ");
INSERT INTO rgu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram boki Aminadab, Aminadab boki Nahason, Nahason boki Salmon, ");
INSERT INTO rgu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon boki Boas (ria mama na, nade Rahab), Boas boki Obet (ria mama na, nade Rut), Obet boki Isai, ");
INSERT INTO rgu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai boki Daud. Neme Daud losa tepoꞌ fo lahenda nusa Israel nanatuꞌu leo Babel reu, nana tititi-nonosiꞌ sanahulu haa bali, siꞌ: Daud boki Soleman (ria mama na, riꞌ maulu na Uria sao na). ");
INSERT INTO rgu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soleman boki Rehabeam, Rehabeam boki Abia, Abia boki Asaf, ");
INSERT INTO rgu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf boki Yosafat, Yosafat boki Yoram, Yoram boki Usia, ");
INSERT INTO rgu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia boki Yotam, Yotam boki Ahas, Ahas boki Heskia, ");
INSERT INTO rgu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Heskia boki Manase, Manase boki Amos, Amos boki Yosias, ");
INSERT INTO rgu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosias boki Yekonya no fadi nara tepoꞌ fo sira nanatuꞌu leo Babel reu. ");
INSERT INTO rgu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tepoꞌ fo sira nanatuꞌu leo Babel reu losa Yesus, nana tititi-nonosiꞌ sanahulu haa bali, siꞌ: Yekonya boki Saltiel, Saltiel boki Serubabel, ");
INSERT INTO rgu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel boki Abihut, Abihut boki Elyakim, Elyakim boki Asor, ");
INSERT INTO rgu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor boki Sadok, Sadok boki Akim, Akim boki Eliut, ");
INSERT INTO rgu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut boki Eliasar, Eliasar boki Matan, Matan boki Yakob, ");
INSERT INTO rgu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","boe ma Yakob boki Yusuf. Yusuf, sao Maria. Maria, riꞌ boki Yesus Kristus. ");
INSERT INTO rgu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","De, mulai neme Abraham losa Daud, nana tititi-nonosiꞌ sanahulu haa; neme Daud losa sira nanatuꞌu leo Babel reu tititi-nonosiꞌ sanahulu haa; ma neme Babel mai losa boki Kristus, nana tititi-nonosiꞌ sanahulu haa. ");
INSERT INTO rgu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria boki Yesus a, tutui na leo iaꞌ: Maria no Yusuf rahihii aoꞌ so. Dua si bei ta parnaa suku rabua sama leoꞌ sao touꞌ no sao inaꞌ, matetuꞌ na Maria nairu neme Manetualain Dula-dale Malalao-malalafu Na mai. ");
INSERT INTO rgu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tepoꞌ fo Yusuf nalelaꞌ nae Maria nairu leo naꞌ, boe ma ana nau namaetuꞌ noo ni. Tehuu ana ta nau tao namamaeꞌ Maria nai lahenda dodouꞌ matan, nana huu ria nanuu dale lalao-lalafuꞌ. De ana nau namaetuꞌ namanininoꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ana bei afi neu-mai, hatuꞌ esa boe ma ana nala mei. Nai meis ria, ana nita Manetualain eilaꞌo-limalopen nai nusatetu-ikutemaꞌ a mai nafada ni nae, “Ae, Yusuf! O ia, mane Daud a tititi-nonosin. O dale ma bosoꞌ dodaꞌ sao Maria. Huu fo ana nairu anaꞌ ria, nana huu Manetualain Dula-dale Na kuasan. ");
INSERT INTO rgu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Neuꞌ ko Maria boki naa ana touꞌ esa. Boe ma o muste foi Ni, nade Yesus, huu fo Ria riꞌ neuꞌ ko poꞌi-tata naa Manetualain lahenda nara reme sala-siko nara mai.” ");
INSERT INTO rgu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hihii-nanauꞌ ia neuꞌ ko dadi leoꞌ na, nana huu Manetualain nafada memaꞌ neme uluꞌ mai so. Ana parnaa pake mana nesi matan Yesaya fo duiꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Emi nenene! Neuꞌ ko ana feto esa bei ao-tema, tehuu nairu so. Boe ma boki naa Ana touꞌ esa. Ara foi Ni nade, Imanuel.” (Nai dedea Ibrani, ‘Imanuel’ sosoa na: Manetualain sama-sama noo ita.) ");
INSERT INTO rgu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf nala mei basa, boe ma ana foa. Ana tuka memaꞌ Manetualain nafada Na. Ana sao na Maria, ");
INSERT INTO rgu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","tehuu ta suku noꞌ ana sama leoꞌ saotou-saoinaꞌ losaꞌ Maria boki heni Anaꞌ ria. Boki Anaꞌ ria, boe ma Yusuf foi Ni nade Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tepoꞌ fo boki Yesus nai koro Betlehem nai propinsi Yudea, mane Herodes a homu pareta. Tepoꞌ ria, lahenda hida reme dae dooꞌ nai timudulu-sepelaka, leo kota Yerusalem mai. Sira nana lahenda mana mete malela ruuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ara losa Yerusalem, boe ma ratane reu-mai rae, “Lahenda Yahudi ra mane na fo riꞌ besaꞌ ko boki ni a, nai bea? Ami mita ruuꞌ esa nai dulu natudu tanda nae, boki Ni so. Huu ria na, de ami mai ela doꞌo-tabe Ni.” ");
INSERT INTO rgu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Maneꞌ Herodes a namanene sira dedea na, boe ma dale na ta tama soꞌ. Ma basa lahenda rai Yerusalem ara rameda leoꞌ na boe. ");
INSERT INTO rgu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Boe ma mane Herodes a nabubua na malaka agama Yahudi malaka nara ma basa mesen agama ra, de natane si nae, “Soba emi mafada au dei! Kristus, fo riꞌ Manetualain helu memaꞌ a, boki Ni nai bea?” ");
INSERT INTO rgu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ara rataa ni rae, “Papa maneꞌ! Nai koro Betlehem, nai propinsi Yudea. Huu fo neme uluꞌ mai Manetualain mana nesi matan Mika duiꞌ memaꞌ nae leo iaꞌ: ");
INSERT INTO rgu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ae, emi lahenda Betlehem, nai propinsi Yudea. Bosoꞌ mae, emi koro ma, noi koro aanaꞌ de sosoa-raraaꞌ taꞌa. Huu fo neuꞌ ko lahenda bau-inaꞌ esa neme naaꞌ mai. Neuꞌ ko Ana dadi mana foo soa-neuꞌ Au lahenda Israel kara.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Maneꞌ Herodes a namanene leoꞌ na, boe ma naloo namanininoꞌ lahenda mana mete malela ruuꞌ sira. Ana natane si nae, “Fai hidaꞌ a riꞌ emi mita ruuꞌ ria toda nai lalai?” De ara rafada ni. ");
INSERT INTO rgu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Boe ma ana fee si leo Betlehem reu, ma nafada nae, “Emi meu fo saka matabebesa Anaꞌ ria nai naa. Maneniko maneta moo Ni, sona matafali mai mafada au. Huu fo au boe sakaꞌ uu doꞌo-tabe Ni.” ");
INSERT INTO rgu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ramanene basa maneꞌ a dedea na, boe ma ara reu. Ara rita seluꞌ ruuꞌ fo riꞌ maulu na parnaa rita ni nai dulu a. Ruuꞌ ria toda nai sira matan, de laꞌo losaꞌ nateꞌe naraa no mamanaꞌ fo riꞌ boki Anaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ara rita leoꞌ na, boe ma ramahoꞌo-ratadale raan seli. ");
INSERT INTO rgu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ara masoꞌ leo uma ria daleꞌ reu, te rita Anaꞌ a no maman Maria. Boe ma ara sundaꞌ undulaka nara fo doꞌo-tabe Ni. Ara buka sira popoti-popole hadia hata-heto mabeli nara, fee Anaꞌ a. Ara fee lilo pilas, kamanyan ma ai-nana boo meniꞌ mabeli. ");
INSERT INTO rgu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ta doo bea boeꞌ, te ara hapu meis neme Manetualain mai nae, “Emi bosoꞌ boe fali seluꞌ leo maneꞌ Herodes a meu.” Huu ria na, de ara fali leo sira nusa-namon reu, resiꞌ eno fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lahenda mana mete malela ruuꞌ sira fali, boe ma Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a esa mai nafada Yusuf nai meis daleꞌ nae, “Ae, Yusuf! Foa leo! Malale fo moo Anaꞌ a, no mama Na leo Masir meu. Leo mahaniꞌ naa losaꞌ Au afada ae fai hidaꞌ emi bole fali, huu fo maneꞌ Herodes a saka Anaꞌ a fo nau naisan!” ");
INSERT INTO rgu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusuf foa na aon, boe ma noo sao na ma Anaꞌ a, de ralai leo nusa Masir reu hatun ria. ");
INSERT INTO rgu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ara leo rai naa losaꞌ mate Herodes. No ria na, natetu na Manetualain dedean, sama leoꞌ neme uluꞌ mai Ria mana nesi matan Hosea nafada memaꞌ nae, “Au aloo faliꞌ Au Ana Ka, fo kalua neme Masir mai.” ");
INSERT INTO rgu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Maneꞌ Herodes a bubuluꞌ nae, lahenda mana mete malela ruuꞌ sira fufudiꞌ ana, boe ma namanasa naan seli. Ana pareta soldadu nara nae, “Leo koro Betlehem, ma koroꞌ fo raneneaꞌ rai naa. Maisa basa ana aana touꞌ, fo riꞌ teuꞌ dua leo daeꞌ mai.” Herodes pareta nae leoꞌ na, nana huu ana nafarene lahenda mana mete malela ruuꞌ ara tutui na. Ana reken mulai neme masososa na ara rita ruuꞌ a toda nai lalai a. ");
INSERT INTO rgu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Basa hihii-nanauꞌ ia ra dadi, tuka hata fo neme fai a ulu na mai Manetualain mana nesi matan Yeremia duiꞌ memaꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramanene lahenda dola-namatani nai kota Rama. Rahel dola-namatani, nana huu mate katemaꞌ ana aana nara. Ana ta nau lahenda mai oꞌoe-nanasin, nana huu ana nara reꞌes ana so.” ");
INSERT INTO rgu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Boe ma mate maneꞌ Herodes a. Tepoꞌ ria Yusuf asa bei rai Masir. Manetualain eilaꞌo-limalopen nai nusatetu-ikutemaꞌ a mai, natudu ao na neuꞌ ana nai mei-afes daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Eilaꞌo-limalope ria nae, “Ae, Yusuf! Foa leo! Moo Anaꞌ a, noo mama na, fo fali Israel meu leo. Te lahenda fo riꞌ nau naisa Anaꞌ a, maten so.” ");
INSERT INTO rgu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuf namanene leoꞌ na, boe ma ana foa na aon. De noo faliꞌ asa leo nusa Israel reu. ");
INSERT INTO rgu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tehuu ana namanene rae, maneꞌ Herodes a anan Arkilaus pareta nai propinsi Yudea, de ana biiꞌ fali leo naaꞌ neu. Boe ma Manetualain pareta seluꞌ ana nai mei-afes esa bali nae, “Yusuf, o bosoꞌ leo nai Yudea.” Huu ria na, de ana neu leo nai propinsi Galilea, ");
INSERT INTO rgu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","nai koroꞌ esa nade Nasaret. No ria na, natetu-naraa noo Manetualain dedea-nafadan, tuka hata fo Ria mana nesi mata nara duiꞌ memaꞌ rae, “Neuꞌ ko ara raloo Ni rae Lahenda Nasaret.” ");
INSERT INTO rgu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tepoꞌ fo Yesus nambau-ina, boe ma Yohanis Mana Saraniꞌ a mulai nanori-nafada lahenda ra nai mamana lino-nees, nai propinsi Yudea. ");
INSERT INTO rgu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ana nafada nae, “Toranoo susue kara! Emi muste manaku ma foa ela sala-siko mara, fo matafali leo Manetualain meu leo. Huu fo besaꞌ ia basa lahenda ra bisa dadi reuꞌ Manetualain lahenda nara so.” ");
INSERT INTO rgu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Maulu na Manetualain mana nesi matan esa, nade Yesaya duiꞌ memaꞌ laꞌe-neuꞌ Yohanis nae, “Neuꞌ ko lahenda esa naloo bou-bou nai mamana lino-nees nae, ‘Basa lahenda rahehere ao nara tao ratalolole enoꞌ, fo sipoꞌ Manetualain mamai Na! Tao ra enoꞌ a roos soa-neuꞌ Ana!’ ” ");
INSERT INTO rgu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis eno masoda na sama leoꞌ Manetualain mana nesi mata fai ulu nara. Kakao-papaken, tao si reme banda onta a bulu na. Ria tali-ee na, tao ni neme banda a rou na. Ria nanaa-nininun, lamaꞌ ma fani-oe nura. ");
INSERT INTO rgu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tepoꞌ ria lahenda dodouꞌ mai fo nau raneta roo Yohanis. Ara reme Yerusalem mai, ma reme propinsi Yudea isi na katemaꞌ. Ma reme basa koroꞌ fo raneneaꞌ lee Yarden. ");
INSERT INTO rgu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ara manaku neuꞌ loan sira sala-sikon katemaꞌ, boe ma Yohanis sarani si rai lee Yarden. ");
INSERT INTO rgu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tepoꞌ ria, partei agama Farisi ma partei agama Saduki lahenda nara boe mai hule Yohanis fo sarani si. Tehuu ana nita si, boe ma nasapaa nae, “Hee! emi ia sama leoꞌ meke mapuputaꞌ! Manetualain neuꞌ ko huku emi, nana huu nonoi-tatao tadalu mara. Wee! Bosoꞌ mae emi bisa kalua meme Ria huhuku Na mai. ");
INSERT INTO rgu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","De malole lenaꞌ emi matafali leo Manetualain meu, ma saledale-tuꞌetei mara. Boe ma tao hihii-nanauꞌ malole ra, sama leoꞌ ai huuꞌ fo neni buna-boa malole. ");
INSERT INTO rgu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bosoꞌ afi mae emi lui memeꞌ Ramatuaꞌ a huhuku Na, nana huu emi ia nana baꞌi Abraham tititi-nonosin. Mamahere Au! Huu fo Manetualain bisa tao na batu ia ra dadi reuꞌ baꞌi Abaraham tititi-nonosin. ");
INSERT INTO rgu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Besa-besa! Huu fo Manetualain nahehere aon neni taꞌa sakaꞌ loꞌo heni basa ai huuꞌ fo boa nara ta malole a. Loꞌo basa nate, Ana tuꞌu si leo ai-pilaꞌ daleꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Besaꞌ ia au sarani emi pake oe, fo dadi tanda nae, emi saledale-tuꞌetei mara so. Tehuu neuꞌ ko Lahenda esa kahereꞌ lena au, sakaꞌ mai. Leo mae au dadi noi neuꞌ Ria atan boe oo, au ta araa. Neuꞌ ko Ana tao nahenu emi dale mara neniꞌ Manetualain Dula-dale Malalao-malalafu Na. Ria boe tao na emi dadi lalao-lalafuꞌ, sama leoꞌ lahenda hotu heni kadafuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Huu fo Ana homu niru fo isiꞌ nai daleꞌ, de sakaꞌ dai heni uu na. Boe ma Ana poꞌa isiꞌ sira leo soꞌa daleꞌ reu. Tehuu uuꞌ ara, Ana tuꞌu si leo ai-pilaꞌ manabasa taaꞌ a daleꞌ reu.” ");
INSERT INTO rgu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Fai ria Yesus onda neme Galilea mai leo lee Yarden neu. Ana mai hule Yohanis fo sarani Ni, ");
INSERT INTO rgu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","tehuu Yohanis ta nau fa. Ana nadedea laka nae, “Tao leoꞌ bea fo au muste sarani Ramatuaꞌ a? Ta tabaleꞌ ia fa, do? Ramatuaꞌ a riꞌ muste sarani au. Huu fo ria riꞌ au parluu!” ");
INSERT INTO rgu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tehuu Yesus nataa nae, “Ta hata-hata fa. Soa-neuꞌ besaꞌ ia o riꞌ sarani Au. No ria na, ita tuka Manetualain hihii-nanaun.” Yohanis namanene leoꞌ na boe ma nataa nae, “Neu, neme Ramatuaꞌ a mai.” Boe ma ana sarani Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sarani basa, boe ma Yesus kalua neme oe daleꞌ mai. Kekeneu te, lalai natahuꞌa. Boe ma Ana nita Manetualain Dula-dale Na sama leoꞌ manupui kalasi a onda mai de tena neuꞌ aoina Na lain. ");
INSERT INTO rgu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Boe ma ara ramanene Manetualain haraoe Na neme lalai mai nae, “Ia nana, Au Ana susue Ka. Ana tao na Au dale Ka namahoꞌo.” ");
INSERT INTO rgu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Basa ria, boe ma Manetualain Dula-dale Na napipipi-nalalaꞌo noo Yesus leo mamana lino-nees neu, ela nitu ra malaka na soba Ni. ");
INSERT INTO rgu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ana puasa nai naa hatu-leledon faiꞌ haa hulu. De Ana namalaa naan seli. ");
INSERT INTO rgu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fai fo Ana namalaa, boe ma nitu ra malaka bau-ina na mai soba Ni nae, “O ia nana tebe-tebe Manetualain Ana Na, hete? Maneniko tebe, sona pareta batu ia ra fo dadi reuꞌ nanaaꞌ leo.” ");
INSERT INTO rgu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tehuu Yesus nataa nae, “Manaduiꞌ nai Manetualain Susura Makamoi Na daleꞌ nae: ‘Lahenda dae-bafoꞌ a ta nasoda nemeꞌ noi nanaa-nininuꞌ a mai. Tehuu sira boe muste ramanene Manetualain Dedea-nafadan, ma tao tuka Ria hihii-nanaun.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Boe ma nitu ria noo Yesus leo kota Yerusalem neu, Manetualain kota malalao-malalafu Na. Ma noo Yesus leo mamana madema lain neu nai Uma Mamaso Yahudi Ina. ");
INSERT INTO rgu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Boe ma nitu ria nae, “Maneniko tebe-tebe Manetualain Anan O, sona soba paraboku daeꞌ muu leo. Huu fo manaduiꞌ nai Manetualain Susura Makamoi na nae, ‘Neuꞌ ko Manetualain pareta Ria eilaꞌo-limalope nara reme nusatetu-ikutemaꞌ a mai, fo ranea O.’ Nai Manetualain Susura Makamoi na boe manaduiꞌ nae, ‘Neuꞌ ko ratanee ra O reniꞌ lima nara, fo ela O ao-ina ma bosoꞌ hedis a, ma ta tetaꞌ laꞌe batu a boeꞌ.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tehuu Yesus nataa nae, “Manaduiꞌ nai Manetualain Susura Makamoi Na daleꞌ boe nae, ‘Manetualain riꞌ nanuu haak fo pareta o. Huu ria na, de o bosoꞌ soba Ni.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Basa de nitu ria noo Yesus leo lete kademaina esa lain neu. Boe ma natudu basa nusaꞌ nai dae-bafoꞌ a, ma sira lole-napun katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nitu ria natudu basa sira, boe ma nafada nae, “Sadi O sundaꞌ undulaka ma fo doꞌo-tabe au, neuꞌ ko au fee katemaꞌ sira reuꞌ O.” ");
INSERT INTO rgu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tehuu Yesus nasapaa nae, “He, nitu on! O maheoꞌ meme iaꞌ mai! Huu fo Manetualain Susura Makamoi na nae, ‘O muste doꞌo-tabe Manetualain, ma o muste malalau adaꞌ neuꞌ Ana.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nitu ria namanene leoꞌ na, boe ma ana laꞌo ela Yesus. Tehuu Manetualain eilaꞌo-limalope nara reme nusatetu-ikutemaꞌ a mai de urus Ana. ");
INSERT INTO rgu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tepoꞌ ria, mane Herodes a ena Yohanis Mana Saraniꞌ a nai bui daleꞌ. Yesus namanene leoꞌ na, boe ma Ana fali leo Galilea neu. ");
INSERT INTO rgu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ana leo koro Nasaret na neu, basa de Ana laꞌo naroo fo neu leo nai koro Kapernaum. Koroꞌ ria nai dano Galilea a suu na, nai Sebulon no Naftali oe-daen. ");
INSERT INTO rgu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","No ria na, Ana tao tuka hata fo Manetualain mana nesi matan Yesaya duiꞌ memaꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon oe-daen, ma Naftali oe-daen fo raneneaꞌ dano Galilea, nai lee Yarden pooꞌ muri. Lahenda fo ta Yahudi fa, leo rai naa. ");
INSERT INTO rgu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ara rasoda nai maiuꞌ daleꞌ, tehuu besaꞌ ia ara rita Makaledoꞌ a so. Huu fo besaꞌ ia, Makaledoꞌ a nahaa soa-neuꞌ basa lahenda fo bei ta ralelaꞌ Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Neme tepoꞌ ria mai, boe ma Yesus mulai nanori-nafada lahenda nae, “Emi muste saledale-tuꞌetei mara, fo masoda lalao-lalafuꞌ leo! Huu fo besaꞌ ia basa lahenda ra bisa dadi reuꞌ Manetualain lahendan so.” ");
INSERT INTO rgu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Faiꞌ esa, boe ma Yesus laꞌo tuka dano Galilea a suu na. Ana nita lahenda dua aꞌa-fadiꞌ. Esa nade Simon, tehuu lahenda biasa raloo ni rae, Petrus. Ma fadi na nade Anderias. Dua si dala ikaꞌ nai dano a, nana huu sira dua, manadolu-manadala. ");
INSERT INTO rgu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus naloo si nae, “Ae, mai fo tuka Au leo! Emi biasa saka ikaꞌ, tehuu besaꞌ ia Au nau anori emi, ela dadi meuꞌ mana saka sumaneꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dua si ramanene leoꞌ na, boe ma foa ela sira dala na, de tuka tutiꞌ Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus asa laꞌo raroo seluꞌ baiꞌ, boe ma Ana nita Sabadeus ana nara. Aꞌa a nade Yakobis, ma fadi na nade Yohanis. Dua si sama-sama roo papa na rahii ratalolole pukaꞌ nai ofaꞌ daleꞌ. Yesus naloo si fo tuka Ni. ");
INSERT INTO rgu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dua si ramanene leoꞌ na, boe ma ara foa ela papa na ma sira ofaꞌ na, de reu tuka tutiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Boe ma Yesus asa laꞌo rule-feo propinsi Galilea, fo Ana nanori-nafada nai lahenda Yahudi ra uma mamaso nara. Ana nanori-nafada laꞌe-neuꞌ Manetualain Tutui Malole Na, ma nafada eno na leo beaꞌ fo lahenda bisa tuka Manetualain pareta na. Ma Ana puli na basa lahenda ra reme hedi-raus rupa nara mai boe. ");
INSERT INTO rgu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta doo bea boeꞌ, te tutuiꞌ laꞌe-neuꞌ Yesus tataon ria, tui-bekan losa rule-feo basa propinsi Siria. Lahenda ra roo sira lahenda kamahedi rupa nara, leo Ria neu. Ara roo lahenda nitu hekeꞌ, manahedeꞌ, ma lukuꞌ ara. Boe ma Ana puli na katemaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tepoꞌ ria, lahenda dodouꞌ mai tuka Ni. Ara reme propinsi Galilea, ma reme Dekapolis, fo riꞌ sosoa na nae, Kota Sanahulu. Ruma bali reme kota Yerusalem, reme propinsi Yudea, ma reme lee Yarden seriꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus nita lahenda dodouꞌ mai tuka Ni, boe ma Ana ae leo lete anaꞌ esa lain neu, de natuuꞌ neuꞌ naa. Ria ana mana tuka dean fo here naa si a, raneneaꞌ mai fo ramania-ramanene neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","De, Ana mulai nanori-nafada si nae, ");
INSERT INTO rgu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lahenda fo kasian nai Manetualain matan ara raua-ranale, huu fo Manetualain nana, sira Mane malole na. ");
INSERT INTO rgu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lahenda fo luumata-pinuidu ara raua-ranale, nana huu Manetualain riꞌ oꞌoe-nanasi si. ");
INSERT INTO rgu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lahenda dale maloe-madae aoꞌ ara raua-ranale, nana huu neuꞌ ko ara sipo katemaꞌ ua-naleꞌ fo Manetualain helu a. ");
INSERT INTO rgu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lahenda fo rahiiꞌ raan seli Manetualain eno roo-tetu na, ara raua-ranale, nana huu neuꞌ ko Ana tao naa si ramanoꞌu-ramadai. ");
INSERT INTO rgu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lahenda fo ratudu dale kasian, ara raua-ranale, nana huu neuꞌ ko Manetualain boe kasian neuꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lahenda fo dale nara lalao-lalafuꞌ, ara raua-ranale, nana huu neuꞌ ko sira siꞌ rita Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lahenda maneni mole-dame, ara raua-ranale, huu fo neuꞌ ko Manetualain nae, ‘Sira nana, Au ana kara.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lahenda fo hapu eese-rurumuꞌ nana huu tuka Manetualain, ara raua-ranale, nana huu Manetualain nana, sira Mane malole na. ");
INSERT INTO rgu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Maneniko lahenda fekeꞌ a tao doidoso emi, nana huu emi tuka Au, emi boe maua-manale. Maneniko ara dedea tadaluꞌ neuꞌ emi, ma tui rapuputaꞌ tao ralutu emi nadem, emi boe maua-manale. ");
INSERT INTO rgu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Leo mae leoꞌ na, tehuu emi muste mamahoꞌo-matadale, nana huu Manetualain sadia balas fee emi babati ma, mauunuꞌ nai nusatetu-ikutemaꞌ a. Tehuu mafarereneꞌ! Ta noi emi riꞌ hapu doidoso leoꞌ na, huu fo fai a ulu na lahenda ra tao tadalu leo naꞌ soa-neuꞌ Manetualain mana nesi mata nara boe.” ");
INSERT INTO rgu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Maneniko ita nau tao nanaaꞌ a malada, sona parluu ita tao masiꞌ neu dei. Leoꞌ na boe lahenda fo rasoda nai dae-bafoꞌ ia, ara parluu emi. Tehuu maneniko masiꞌ a dadi mamis, sona sosoa-raraan ubeaꞌ? Adaꞌ noi tuꞌu henin nai enoꞌ fo ramolo-ratabuꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Emi boe muste masoda sama leoꞌ dededeꞌ, fo ela lahenda dodouꞌ rita-dae no malole. Emi muste pila loa-loa, sama leoꞌ kota fo nai leteꞌ lain, de basa lahenda ra ritan. ");
INSERT INTO rgu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lahenda fo dede na dedede anaꞌ a, ara ta tatana etu dededeꞌ ria nai ure dae daleꞌ. Tehuu ara fua dededeꞌ ria nai mamana madema, ela bisa nahaa nabasa uma a oe-isin. ");
INSERT INTO rgu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Emi boe muste masoda leo naꞌ. Emi muste mahaa-makaledo, fo ela lahenda fekeꞌ ara rita emi soda malole ma. Ma rita leoꞌ na neuꞌ ko ara io-oa Manetualain rae, ‘Emi Papa ma nai nusatetu-ikutemaꞌ a, marela-masaꞌa naan seli!’ ” ");
INSERT INTO rgu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Emi bosoꞌ afi mae, Au mai nai dae-bafoꞌ ia, fo nau ose heni Manetualain atoran fo Ana feen neuꞌ baꞌi Musa. Ma bosoꞌ mae Au ta tao daleꞌ neuꞌ hata fo Manetualain mana nesi mata nara rafada memaꞌ neme uluꞌ mai so a. Huu fo Au mai, nana nau tao a basa-basan dadi natetu no basa hata fo ara rafada so a. ");
INSERT INTO rgu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Huu ria na, nenene matalolole! Basa Musa atoran nara, leo mae titiꞌ do koma esa boe bei pake raheren ma neuꞌ ko natetu na maksud na losaꞌ lalai ma dae-bafoꞌ a noe. ");
INSERT INTO rgu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Neme basa Manetualain lahenda nara mai, esa nalena laka Manetualain atoran na, nana huu ana afi nae, ‘Hee! Atoran ia aanaꞌ, ta nanuu sosoa-raraaꞌ fa!’ Boe ma ana nanori-nafada leo naꞌ soa-neuꞌ lahenda fekeꞌ, neuꞌ ko Manetualain nai nusatetu-ikutemaꞌ a tao naan dadi neuꞌ lahenda aanaꞌ. Tehuu lahenda fo tao tuka Manetualain atoran na katemaꞌ, basa nana ana nanori-nafada leo naꞌ soa-neuꞌ lahenda fekeꞌ, sona neuꞌ ko lahenda ria hapu hada-horomata nai Manetualain matan. ");
INSERT INTO rgu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mamahere Au! Maneniko emi ta masoda roo-tetuꞌ malole lena neme mesen agama, ma lahenda partei Farisi ra, sona emi ta bisa dadi meuꞌ Manetualain lahendan.” ");
INSERT INTO rgu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Emi bubuluꞌ baꞌi Musa atoran fo riꞌ ana nafada memaꞌ neuꞌ ita bei-baꞌin nae, ‘Bosoꞌ maisa lahenda, huu fo bea naisa lahenda, neuꞌ ko ana hapu huhukuꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tehuu Au nau afada leo iaꞌ: bosoꞌ mamanasa, huu fo bea namanasa no toranoo na, neuꞌ ko ana hapu huhukuꞌ. Lahenda fo nasa na lua no ria toranoo na nae, ‘O dodole ea!’ Neuꞌ ko lahenda ria muste nataa nai lasi agama ra. Ma lahenda fo nasapaa ria toranoo na nae, ‘Pakanaaꞌ!’, neuꞌ ko ana hapu huhukuꞌ nai ai-pila naraka. ");
INSERT INTO rgu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","De maneniko o muni tutunu-hohotuꞌ soa-neuꞌ Manetualain, tehuu mafarene mae, hapu toranooꞌ bei namanasa no o, ");
INSERT INTO rgu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sona bosoꞌ fee tutunu-hohotuꞌ sira dei. O muu mole-dame mo toranoo ma dei, basa ria besaꞌ ko muu fee tutunu-hohotuꞌ ria soa-neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Maneniko lahenda nau nadedea no o, sona malole lenaꞌ malale muu mole-dame moo ni dei. Maneniko taꞌa, sona neuꞌ ko lahenda ria no o muu mataa nai mana ee dedeaꞌ a. Boe ma mana ee dedeaꞌ a fee heni o leo polisi ra muu, de ara ena o nai bui daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au dedea teteaꞌ ia! Neuꞌ ko o leo mahaniꞌ bui daleꞌ, losaꞌ o bae etu huta ma katemaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Emi bubuluꞌ baꞌi Musa atoran na nae, ‘Bosoꞌ hohoke.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tehuu Au nau afada leo iaꞌ: lahenda fo nita inaꞌ esa, boe ma dale na nahiiꞌ suku noꞌ ana, sona touꞌ ria hohoke inaꞌ ria nai dale na so. ");
INSERT INTO rgu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Maneniko o tao salaꞌ muniꞌ mata ona ma, sona edo henin. Huu fo malole lenaꞌ o masoꞌ leo nusatetu-ikutemaꞌ a muu, muni noi mataꞌ esaꞌ a, beraꞌ ko ara tuꞌu o leo ai-pila naraka a muu muni matam dua si. ");
INSERT INTO rgu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma kalu o tao salaꞌ muniꞌ lima ona ma, sona tete heni limaꞌ ria. Huu fo malole lenaꞌ o masoꞌ leo nusatetu-ikutemaꞌ a muu, muni noi limaꞌ esaꞌ a, beraꞌ ko ara tuꞌu o leo ai-pila naraka a daleꞌ muu muni limam dua si.” ");
INSERT INTO rgu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Emi bubuluꞌ baꞌi Musa atoran na nae, ‘Lahenda fo namaetuꞌ no sao ina na, sona ana muste fee susura namaetuꞌ leo inaꞌ ria neu.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tehuu Au afada leo iaꞌ: maneniko lahenda namaetuꞌ no sao ina na, sekona te sao ina na ta parnaa hohoke, ria bei sama leoꞌ ara bei sao rahere. De kalu inaꞌ ria sao seluꞌ, sona ria sama leoꞌ sao ulu na tao naan hohoke. Ma kalu touꞌ esa sao na inaꞌ esa fo parnaa namaetuꞌ, sona sira dua hohoke ria so boe, huu fo ara ralena laka neuꞌ eno sasaoꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Emi bubuluꞌ baꞌi Musa atoran fo riꞌ ana nafada neuꞌ ita bei-baꞌi nara nae, ‘Maneniko o soo-supa pake Manetualain nade Na, sona o muste tao matetuꞌ hehelu-barataaꞌ ria.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tehuu Au afada leo iaꞌ: maneniko o tao hehelu-barataaꞌ, sona bosoꞌ pake sosoo-susupaꞌ. Bosoꞌ soo-supa pake nusatetu-ikutemaꞌ a nade na, huu fo nusatetu-ikutemaꞌ a, nana Manetualain mamana leleon. ");
INSERT INTO rgu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bosoꞌ soo-supa pake dae-bafoꞌ a nade na, huu fo dae-bafoꞌ a, nana Manetualain ei momolo-tatabun. Ma bosoꞌ soo-supa pake Yerusalem nade na, huu fo Yerusalem, nana Mane Bau-inaꞌ a kota na. ");
INSERT INTO rgu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bosoꞌ soo-supa meniꞌ emi laka ma. Huu fo emi ta manuu kuasa fo pareta lakadooꞌ esa ela dadi keoꞌ do fulaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","De, maneniko emi nau tao hehelu-barataꞌ mae, ‘ya’, sona mafada mae, ‘ya’. Tehuu maneniko taꞌa, sona mae, ‘taꞌa’. Maneniko emi mafada lena neme naꞌ mai, sona ria naoka-nasamu nai nitu a.” ");
INSERT INTO rgu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Emi bubuluꞌ baꞌi Musa atoran na nae, ‘Maneniko lahenda tao nalutu o mata ma, sona balas ana fo tao malutu mata na boe. Ma maneniko lahenda tao namosu heni nisi ma, sona balas ana fo tao mamosu heni nisi na boe.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tehuu Au afada ae leoꞌ ia: bosoꞌ balas tadaluꞌ no tadaluꞌ. Maneniko lahenda fapa suke mi seri, sona nemeꞌ na ela ana fapa sukeꞌ seri bali. ");
INSERT INTO rgu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Maneniko lahenda nau nadedea no o, fo nau hai na badu ma, sona fee seluꞌ badu hanas ma neu. ");
INSERT INTO rgu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Maneniko soldadu esa naseti o fo lepa-masaa feen hata ni esa doo-doo na kilo esa, sona masaa maroon losa kilo dua. ");
INSERT INTO rgu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maneniko lahenda hule o hata ubeam, sona fee ni. Ma kalu lahenda nau tonda o hata ubeam, sona fee neu.” ");
INSERT INTO rgu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Emi mamanene lahenda rafada rae, ‘Sue-lai o toranoom, ma eteꞌ ao ma moo lahenda fo eteꞌ aon no o.’ ");
INSERT INTO rgu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tehuu Au afada leo iaꞌ: o muste sue-lai lahenda fo eteꞌ aon no o. Ma hule ela Manetualain fee ua-naleꞌ neuꞌ lahenda fo tao na o doidoso. ");
INSERT INTO rgu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Maneniko o tao leo naꞌ, sona matudu mae, o ia nana Amaꞌ nai nusatetu-ikutemaꞌ a anan. Huu fo Ana adu-tao na ledo a nahaa soa-neuꞌ lahenda malole, ma soa-neuꞌ lahenda tadaluꞌ a boe. Ria boe naonda uda fee lahenda fo tao tuka pareta Na sama-sama roo lahenda fo ralena laka Ria pareta Na. ");
INSERT INTO rgu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","De, maneniko o sue-lai noi lahenda fo sue-lai o, sona bosoꞌ afi mae Manetualain muste balas o neniꞌ ua-naleꞌ. Huu fo lahenda tadaluꞌ boe sue-lai sira tia-lain fo sue-lai si a. ");
INSERT INTO rgu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","De, maneniko o fee haraoe soda-moleꞌ noi neuꞌ tia-laim, sona bosoꞌ afi mae ria lena neme lahenda fekeꞌ. Te lahenda fo ta namahere Manetualain, boe tao leo naꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","De mafarereneꞌ! O Papa ma nai nusatetu-ikutemaꞌ a sue-lai basa lahenda ra. De o boe muste tao tuka leoꞌ na!” ");
INSERT INTO rgu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus nanori-nafada naroo nae, “Mafarereneꞌ! Bosoꞌ moi tuka-tukaꞌ agama a atoran na, fo ela lahenda io emi. Maneniko emi tao leo naꞌ, sona emi Papa ma nai nusatetu-ikutemaꞌ a neuꞌ ko ta seba emi hata-hata esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kalu emi nau tulu-fali lahenda kasian ara, sona bosoꞌ meu matui dedea nai basa mamanaꞌ ain. Maneniko emi tao leo naꞌ, sona emi sama leoꞌ lahenda fo dedea fekeꞌ tao fekeꞌ. Ara rahiiꞌ lalaꞌo leo uma mamasoꞌ a reu, fo ela lahenda io si rae, ‘Ae, lahenda ia kahereꞌ.’ Au dedea tetebeꞌ! No hapu iꞌio leo naꞌ a, ara sipo ra seseba nara so. ");
INSERT INTO rgu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","De, maneniko emi nau tulu-fali lahenda kasian ara, sona bosoꞌ tutui esa boe! ");
INSERT INTO rgu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","No ria na, lahenda nai dae-bafoꞌ ia ta bubuluꞌ. Tehuu emi Papa ma nai nusatetu-ikutemaꞌ a riꞌ bubuluꞌ hata fo emi tao no namanininoꞌ a. Neuꞌ ko Ana balas emi neniꞌ ua-naleꞌ dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Emi hule-haradoi, sona bosoꞌ tao ao mara sama leoꞌ lahenda fo dedea fekeꞌ, tao fekeꞌ. Ara rahiiꞌ lalaꞌo rai eno-dala rame, ma rapadei rai uma mamasoꞌ daleꞌ, fo ela lahenda dodouꞌ rita ma io si rae, ‘Ae! Lahenda lalao-lalafuꞌ ia ra!’ Tehuu nenene! No saka iꞌio leo naꞌ, sira sipo ra seseba-babae nara so. ");
INSERT INTO rgu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tehuu emi ta bole leo naꞌ fa. Maneniko emi hule-haradoi, sona masoꞌ leo kama daleꞌ meu fo ena lelesu a. Boe ma hule-haradoi nai dale mara neuꞌ emi Papa ma. Leo mae lahenda fekeꞌ ta nita, tehuu emi Papa ma riꞌ nita. Neuꞌ ko Ana balas emi neniꞌ ua-naleꞌ dodou-inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Maneniko emi hule-haradoi, sona bosoꞌ dedea matafafali meu-mai. Te lahenda fo ta ralelaꞌ Manetualain boe oo bisa hule-haradoi leo naꞌ. Ara afi rae, Manetualain nahiiꞌ namanene sira huhule-haradoi manaru na. ");
INSERT INTO rgu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bosoꞌ tao sama leoꞌ sira! Huu fo leo mae emi bei ta hule hata-hata esa neme emi Papa ma nai nusatetu-ikutemaꞌ a, tehuu Ana bubuluꞌ memaꞌ hata fo emi parluu a. ");
INSERT INTO rgu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","De maneniko hule-haradoi, sona pake natutuduꞌ leo iaꞌ: ‘Amaꞌ nai nusatetu-ikutemaꞌ a! Amaꞌ a nade Ma Lalao-lalafuꞌ naan seli. Ela leoꞌ bea na basa lahenda ra soꞌu-fua radedema Amaꞌ a nade Marela-masaꞌa Ma. ");
INSERT INTO rgu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ela leoꞌ bea na Papa dadi Mane soa-neuꞌ basa lahenda ra! Ela leoꞌ bea na basa lahenda ra tao tuka Papa pareta ma nai dae-bafoꞌ ia, sama leoꞌ Papa eilaꞌo-limalope mara tao tuka Papa pareta ma nai nusatetu-ikutemaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Papa fee ami nanaa-nininu namanoꞌu-namadaiꞌ tuka-tuka faiꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ami hule Papa sae-safe heni ami sala-siko mara, sama leoꞌ ami fee ampon neuꞌ lahenda sala-sikon fo ara taon soa-neuꞌ ami. ");
INSERT INTO rgu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Papa, manea ami fo bosoꞌ tao salaꞌ. Ma poꞌi-tata maa ami meme nitu a kuasa na mai. Huu fo Papa nana, Maneꞌ Manakuasa ma Marela-masaꞌa. Papa riꞌ homu maroo pareta. Papa, ami huhule-haradoi ma, noi ri naꞌ. Amin.’ ");
INSERT INTO rgu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tehuu nenene! Maneniko emi fee ampon neuꞌ lahenda fo nasala no emi, neuꞌ ko emi Papa ma nai nusatetu-ikutemaꞌ a boe sae-safe heni emi sala-sikom. ");
INSERT INTO rgu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tehuu maneniko emi ta nau fee ampon neu lahenda fo nasala no emi, neuꞌ ko emi Papa ma boe ta fee ampon neuꞌ emi.” ");
INSERT INTO rgu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Maneniko emi hule-haradoi ma puasa, sona bosoꞌ marurutu sama leoꞌ lahenda fo dedea fekeꞌ tao fekeꞌ. Ara tao leo naꞌ fo ela lahenda io si rae, ‘Sira nana, lahenda lalao-lalafuꞌ.’ Tehuu nenene! No hapu iꞌio leo naꞌ, ara sipo ra seseba-babae nara so. ");
INSERT INTO rgu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tehuu maneniko emi puasa, sona marou makamomoi mata-idum, ma sau matalolole laka mara! ");
INSERT INTO rgu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","De, neuꞌ ko lahenda rita emi, ara ta bubuluꞌ rae, emi puasa. Tehuu emi Papa ma riꞌ bubulu. Neuꞌ ko Ana balas fee emi neniꞌ ua-naleꞌ dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bosoꞌ moi-tao mela-maku fo mabubua hata-heto dodouꞌ nai dae-bafoꞌ ia. Huu fo neuꞌ ko fufuꞌ, ma rutuꞌ ara raa heni si. Ma naꞌo ra mai ramanaꞌo reni si. ");
INSERT INTO rgu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tehuu malole lenaꞌ emi moi-tao mela-maku mabubua hata-heto dodouꞌ nai nusatetu-ikutemaꞌ a. Huu fo nai naa fufuꞌ ma rutuꞌ ara ta raa si. Ma naꞌo ra boe ta bisa mai ramanaꞌo reni si. ");
INSERT INTO rgu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Emi peda hata-heto mara rai bea, tantu emi dale ma boe rai naa.” ");
INSERT INTO rgu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lahenda mata na, sama leoꞌ dededeꞌ fo tao makaledo ria dale na. Maneniko mata na nita-dae, sona ana tuka eno soda matetuꞌ a, sama leo lahenda laꞌo nai makaledoꞌ a daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tehuu maneniko mata na nasasapu, sona ana ta tuka eno malole a, sama leo lahenda laꞌo noi nafaroroeꞌ a nai maiuꞌ daleꞌ. De maneniko makaledoꞌ fo nai emi dale mara dadi maiuꞌ, sona emi boe masoda nai maiuꞌ daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Lahenda ta bisa noi-tao tebe-tebe soa-neuꞌ malaka dua, huu fo neuꞌ ko ria nahiiꞌ malaka esa, lena neme malaka fekeꞌ a. Neuꞌ ko ana tuka malaka esa, tehuu malaka esa bali sona ana ta tao daleꞌ neu. Huu ria na, o ta bisa mae ‘Manetualain riꞌ nanuu haak fo pareta au,’ kalu o tao doiꞌ a dadi neuꞌ malaka ma. ");
INSERT INTO rgu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Huu ria na Au afada leo iaꞌ: bosoꞌ dale mara dodaꞌ mae ami sakaꞌ masoda tao leo beaꞌ, ami sakaꞌ mia ubeaꞌ, minu ubeaꞌ, kao-pake ubeaꞌ? Emi bate mae masodaꞌ a nana noi riꞌ nanaa-nininuꞌ? Ma ao-inaꞌ a nana pake noi kakao-pakeꞌ? Ta leo naꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Soba mete masudi manupuiꞌ fo ara laa-laa rai lalai. Ara ta rasapute sele-tande ma etu-oru fo peda nanaaꞌ nai mamana pepeda-fufuaꞌ. Tehuu emi Papa ma nai nusatetu-ikutemaꞌ a naboi-nasamao naroo si. Ria boe tantu bisa naboi-nasamao emi lena neme ria mai bali. De afi matalolole dei. Huu fo Ana uku-sudi emi lena neme manupuiꞌ sira mai. ");
INSERT INTO rgu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Maneniko lahenda napadeiꞌ nai tiroao a matan, boe ma dale na dodaꞌ, ana bisa tao namadema ria ao-ina na, do? Ta bisa fa! ");
INSERT INTO rgu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Maneniko taꞌa, sona ubeaꞌ taon, de emi dale mara dodaꞌ laꞌe-neuꞌ kakao-papakeꞌ? Soba meu mete masudi buna bakung nai mooꞌ a. Ara ta tenu-heke fa. ");
INSERT INTO rgu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tehuu nenene matalolole! Mane Soleman kakao-papake madidila-mabebeben boe oo, ta bisa leoꞌ bunaꞌ sira lole nara. ");
INSERT INTO rgu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Huu fo Manetualain tao daleꞌ neuꞌ bunaꞌ fo rasoda noi faiꞌ ia, boe ma balahaaꞌ te mate si, de lahenda tuꞌus leo ai-pilaꞌ daleꞌ reu. Maneniko Ana tao leo naꞌ, Ria boe tantu fee emi kao-pake lena neme bunaꞌ sira mai. Ubeaꞌ taon, de emi ta mamahere tebe-tebe neuꞌ Ana? ");
INSERT INTO rgu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","De, bosoꞌ dale mara dodaꞌ mae, ‘Ami sakaꞌ mia ubeaꞌ?’ do, ‘Ami sakaꞌ minu ubeaꞌ?’ do, ‘Ami sakaꞌ kao-pake ubeaꞌ?’ ");
INSERT INTO rgu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Lahenda fo ta nau ramahere Manetualain, ara sota raan seli ela hapu katemaꞌ hihii-nanauꞌ sira. Tehuu emi bosoꞌ leo naꞌ, huu fo emi Papa ma nai nusatetu-ikutemaꞌ a bubuluꞌ basa-basan fo emi parluu a. ");
INSERT INTO rgu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tehuu emi muste malalaꞌo Ria nonoi-tataon, ma muste tuka Ria pareta na dei, sona neuꞌ ko Ana fee tamba seluꞌ basa hihii-nanauꞌ fo emi parluu a. ");
INSERT INTO rgu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","De, bosoꞌ emi dale mara dodaꞌ neuꞌ hata fo emi parluu nai balahaaꞌ. Huu fo balahaaꞌ nanuu pupute-aai fekeꞌ bali. Fai ia susa na dai so.” ");
INSERT INTO rgu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Emi bosoꞌ mapaneneoꞌ lahenda, fo ela Manetualain bosoꞌ napaneneoꞌ emi. ");
INSERT INTO rgu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Emi mararaaꞌ lahenda leoꞌ bea, sona neuꞌ ko Manetualain nararaaꞌ emi leo naꞌ boe. Ma emi uku-sudi lahenda fekeꞌ a sala-sikon leo beaꞌ, sona neuꞌ ko Manetualain uku-sudi emi leo naꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","O mahiiꞌ tanda noi lahenda sala-siko aana na, tehuu o sala-siko kabaꞌuina ma, sona o mae salaꞌ ta ria fa. Ria sama leoꞌ o mita afu sopuꞌ esa nai o tia-laim mata na. Sekona te baloꞌ kabaꞌuina a babaa etu o mata ma, tehuu ta mameda maan. ");
INSERT INTO rgu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tao leoꞌ bea, de o maparani dedea mae, ‘Toranooꞌ! Mai fo au kue heni afu ria neme mata ma mai dei.’ Sekona te o ta bisa mita hata-hata esa boeꞌ, huu fo baloꞌ a babaa etu o mata ma. ");
INSERT INTO rgu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ae! O nana tebe lahenda dea-mataꞌ! Afi fo, tuꞌu heni baloꞌ ria neme o mata ma mai dei, besaꞌ ko o bisa mita-dae, fo kue heni afu a neme o toranoo ma mata na mai. ");
INSERT INTO rgu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Hihii-nanauꞌ lalao-lalafuꞌ laꞌe-neuꞌ Manetualain, bosoꞌ manori-mafadan neuꞌ mana mamumuluꞌ ara. Huu fo sira nana sama leoꞌ busa maꞌaaꞌ, de neuꞌ ko natafali mai suu emi. Sira boe pakanaaꞌ sama leoꞌ bafi. Maneniko lahenda fee lilo mabeli, sona ana ta tao daleꞌ neu! Huu fo noi namolo-natabuꞌ ana.” ");
INSERT INTO rgu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Maneniko emi hule-haradoi, hule maroo neuꞌ Manetualain; neuꞌ ko Ana fee. Maneniko saka maroo; neuꞌ ko Ana natudu eno. Maneniko maloo maroo; neuꞌ ko Ana soi lelesu. ");
INSERT INTO rgu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lahenda fo hule raroo neuꞌ Manetualain, neuꞌ ko sipo. Saka naroo, neuꞌ ko hapu. Naloo naroo, neuꞌ ko Ana soi lelesu. ");
INSERT INTO rgu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Emi dodoo manenin! Maneniko anaꞌ a hule roti, tantu papa na ta feen batu fa, hete? ");
INSERT INTO rgu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Do maneniko anaꞌ a hule ikaꞌ, papa na ta feen meke! ");
INSERT INTO rgu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Maneniko lahenda tadaluꞌ rupa leoꞌ emi a, mahiiꞌ fee emi ana mara hata malole, tantu emi Papa ma nai nusatetu-ikutemaꞌ a fee hata fo emi hule Ni a, huu fo emi Papa ma riꞌ tebe malole a. ");
INSERT INTO rgu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","De, hata fo o nau lahenda fekeꞌ taon soa-neuꞌ o, sona o muste tao leo naꞌ soneuꞌ ria boe. Huu fo ia nana, huu-pedaꞌ neme basa-basan fo baꞌi Musa no Manetualain mana nesi mata feke nara ranori-rafada memaꞌ neme fai a ulu na mai.” ");
INSERT INTO rgu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Maneniko lahenda nau masoꞌ nusatetu-ikutemaꞌ, sona ana muste laꞌo nesiꞌ lelesu bafa lutuꞌ a. Huu fo enoꞌ fo mudaꞌ laꞌesaꞌ ma lelesu bafa loaꞌ, riꞌ lahenda dodouꞌ rahiiꞌ resiꞌ ana. Tehuu besa-besa! Huu fo eno leo naꞌ a, riꞌ neni lahenda leo naraka neu, fo ara bika-bati reme Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lahenda fo nau masoꞌ nusatetu-ikutemaꞌ a, muste tuka eno susa, ma nesiꞌ lelesu bafa lutuꞌ ria. Huu fo leo mae noi lahenda bai anaꞌ a laꞌo resiꞌ na, tehuu eno bafa lutu leo naꞌ a riꞌ noo lahenda leo Manetualain neu.” ");
INSERT INTO rgu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Besa-besa mo manatipu-manadaiꞌ fo io ao nara rae, sira nana Manetualain mana nesi matan. Huu fo tao uni sira malole sama leoꞌ bibi-lopo. Sekona te sira tadaluꞌ, sama leoꞌ busa fuiꞌ maꞌaa. ");
INSERT INTO rgu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Emi bisa malelaꞌ tao lahenda mana fufudiꞌ sira leoꞌ bea? Mete neme sira nonoi-tataon. Sama leoꞌ lahenda nita ai boaꞌ, fo nalelaꞌ ai boaꞌ ria huu na. Ai boa malole, ta kalua neme ai huuꞌ fo ta malole. ");
INSERT INTO rgu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Huu fo ai huu malole neni buna-boa malole. Tehuu ai huu ta malole neni buna-boa ta malole. ");
INSERT INTO rgu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ta hapu ai huu malole neni buna-boa ta malole. Ma ta hapu ai huu ta malole, neni buna-boa malole. ");
INSERT INTO rgu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ai huuꞌ fo ta neni buna-boa malole, tantu ara mai beta henin fo tuꞌun leo ai-pilaꞌ daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Leoꞌ na boe soa-neuꞌ mana nesi mata fufudiꞌ ara. Emi bisa malelaꞌ asa neme sira nonoi-tataon mai.” ");
INSERT INTO rgu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Neuꞌ ko lahenda raloo Au rae, ‘Ramatuaꞌ!’ Tehuu ara seseiꞌ noi nai bafadoo nara. Neuꞌ ko Manetualain nai nusatetu-ikutemaꞌ a tipa heni si. Noi lahenda fo tuka matetuꞌ Ria hihii-nanaun, riꞌ Ana sipoꞌ asa dadi reuꞌ Ria lahendan. ");
INSERT INTO rgu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Neuꞌ ko dae-bafoꞌ a nonoe na, te lahenda dodouꞌ manaku rae, Au ia nana sira Ramatua na. Ara leleꞌo Au rae, ‘Ramatuaꞌ! Ami meu tui-beka Ramatuaꞌ a nanori-nafadam so. Ami boe usi nitu ra pake Ramatuaꞌ a nade Ma. Ma ami tao tanda heran rupaꞌ ara pake Ramatuaꞌ a kuasa Ma.’ ");
INSERT INTO rgu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Leo mae ara leleꞌo Au laꞌo naroo leoꞌ na boe, tehuu neuꞌ ko Au afada si ae, ‘Emi ia nana bea? Au ta alelaꞌ emi, huu fo emi ta masoda tuka Manetualain hihii-nanaun. De maheoꞌ meme iaꞌ mai leo.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Lahenda fo mai namanene neuꞌ Au, ma tao tuka Au dedea-nafada Ki, ria sama leoꞌ lahenda malelaꞌ a nafoa uma na nai fanderen batu. ");
INSERT INTO rgu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Boe ma uda inaꞌ a onda mai losaꞌ faa ra. Ani inaꞌ a boe fae fee uma ria. Tehuu uma ria ta hea neu, nana huu ana napadei nai fanderen batu matea. ");
INSERT INTO rgu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lahenda fo mai namanene neuꞌ Au, tehuu ta tao tuka Au dedea-nafada Ki, ria sama leoꞌ lahenda pakanaaꞌ a nafoa uma na neuꞌ soroaeꞌ lain. ");
INSERT INTO rgu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tepoꞌ fo uda inaꞌ a mai losaꞌ faa ra, ma ani inaꞌ a fae fee uma ria. Boe ma uma ria hea neu losaꞌ nalulutuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus dedea basa leoꞌ na, boe ma basa lahenda ra heran ramanene Ria nanori-nafadan, ");
INSERT INTO rgu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","huu fo Ana nalelaꞌ matetuꞌ nanoriꞌ ria isi-liin. Ria eno nanori-nafadan, ta sama no sira mesen agama nara. ");
INSERT INTO rgu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus onda neme leteꞌ lain mai, boe ma lahenda dodouꞌ ranononda reu tuka Ni. ");
INSERT INTO rgu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kekeneu te, lahenda kamahedis kusta esa mai nasare Nan. Ana sundaꞌ undulaka na fo hule Yesus nae, “Ramatuaꞌ! Tulu-fali au dei! Kalu Ramatuaꞌ a nau, sona bisa mamopo au hedis ka, ela lahenda bosoꞌ rahiaꞌ au bali, fo au bisa hule-haradoi seluꞌ nai uma mamaso Yahudi.” ");
INSERT INTO rgu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus namanene leoꞌ na, boe ma looꞌ lima Na neu, de nafaroe lahenda kamahedis kusta ria, ma dedea nae, “Au nau! O teꞌe leo!” Kekeneu te, lahenda ria hedis na mopon tutiꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Boe ma Yesus nafada ni nae, “Mafarereneꞌ! O teꞌe ma aom so, tehuu ta bole mafada lahenda esa boeꞌ. O muste tuka baꞌi Musa atoran na dei. De leo malaka agama muu, fo ana parisaꞌ ao-ina ma, ela ana bubuluꞌ nae o hedis ma teꞌe matetuꞌ so do, beiꞌ. Boe ma o muste fee tutunu-hohotuꞌ tanda makasi, ela basa lahenda bubuluꞌ rae, o teꞌe matetuꞌ so.” ");
INSERT INTO rgu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Basa boe ma Yesus masoꞌ leo koroꞌ Kapernaum neu. Nai naa, malaka soldadu Roma esa mai hule tutulu-fafaliꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Papa! Au ata ki esa namahedi beraꞌ nai uma. Ana ta bisa foa neme koi lain mai fa, huu fo ana doidoso naan seli.” ");
INSERT INTO rgu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus nataa nae, “Malole! Neuꞌ ko Au uu fo puli an.” ");
INSERT INTO rgu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tehuu malaka soldadu ria nae, “Papa! Papa bosoꞌ masosota aom mai bali, huu fo au ta araa sipoꞌ Papa nai au uma ka. Sadi Papa moi mafadaꞌ a meme iaꞌ mai, tantu au ata ka teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au bubuluꞌ hihii-nanauꞌ ia, nana huu au malaka kara ranuu kuasa fo pareta au. Ma au boe anuu kuasa fo pareta soldadu kara. Maneniko au pareta ei-lima ki esa ae, ‘Leo eleꞌ mu!’ tantu ana neu. Maneniko au ae, ‘Leo iaꞌ mai!’ tantu ana mai. Ma kalu au adenu ata ka ae, ‘Moi-tao ia!’ tantu ana tao leo naꞌ. De sadi Papa moi dedeaꞌ a, tantu au ata ki ria teꞌe tutiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus namanene leoꞌ na, boe ma Ana heran. Ana dedea neuꞌ lahenda kadodouꞌ fo tuka Ni a nae, “Heran! Doo-naru basa ia, tehuu Au bei ta parnaa aneta oo lahenda Yahudi esa, namahere tebe-tebe sama leoꞌ lahenda Roma ia boeꞌ! ");
INSERT INTO rgu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nenene! Neuꞌ ko lahenda dea dodouꞌ reme dulu ma reme muri mai sama leoꞌ lahenda Roma ia, ara ratuuꞌ raa feta sama-sama roo baꞌi Abraham, baꞌi Isak ma baꞌi Yakob rai Manetualain uma na nai nusatetu-ikutemaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Leo mae Manetualain teka-here lahenda Yahudi ra fo dadi reuꞌ Ria lahendan, tehuu lahenda dodouꞌ ta tao daleꞌ neuꞌ Ana. Neuꞌ ko Ana tipa heni si leo mamana maiu-mahatuꞌ a reu. Nai naa ara dola-ramatani ma doidoso raan seli.” ");
INSERT INTO rgu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesus dedea basa nae leoꞌ na, boe ma nafada malaka soldadu ria nae, “Papa fali leo. Huu fo ata ria teꞌe na aon so, sama leoꞌ papa namahere ma.” Naraa no oras ria boe, ata ria teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Laiꞌ esa de, Yesus leo Petrus uma na neu. Ana nita Petrus arina na napeuꞌ nai koi lain, huu fo ao na luu mai. ");
INSERT INTO rgu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus tai na lima na, boe ma ina lasiꞌ a ao luu mai na mopon tutiꞌ a. Basa de ana foa fo neu urus Yesus asa. ");
INSERT INTO rgu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ledo a mulai tena, boe ma lahenda ra roo lahenda nitu heke nara mai. Yesus pareta nitu sira nae, “Nitu emin! Heoꞌ meme lahenda iaꞌ ra mai!” Boe ma nitu sira kalua tutiꞌ a. Ana puli na basa lahenda kamahedis ara boe. ");
INSERT INTO rgu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ana tao basa ia ra, ela natetu no hata fo Manetualain mana nesi matan Yesaya duiꞌ memaꞌ nae, “Ana puli na ita hedi-raun. Ma Ana lepa-nasaa na ita doidoso na.” ");
INSERT INTO rgu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus nita lahenda dodouꞌ mai eo Ran. Boe ma Ana nafada ana mana tuka dea nara nae, “Mai hela laa fo leo dano seriꞌ teu.” ");
INSERT INTO rgu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Boe ma mesen agama esa mai dedea nae, “Papa mesen! Papa leo beaꞌ muu, sona au tuka ahere Papa!” ");
INSERT INTO rgu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tehuu Yesus nataa ni nae, “Malole a boe! Tehuu mafareneꞌ leo iaꞌ. Basa lahenda ma banda ara esaꞌ ko nanuuꞌ mamana leleon. Busa fuiꞌ a fali leo bolo na neu. Manupuiꞌ a fali leo runu na neu. Tehuu Au, Ana Lahenda ia, ta anuu uma fo fali leo naaꞌ uu. Ai nulu lakaꞌ boe taꞌa.” ");
INSERT INTO rgu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Boe ma lahenda mana tuka dea feken esa bali, mai hule nae, “Ramatuaꞌ! Au nau tuka Ramatuaꞌ a, tehuu leoꞌ bea sona au fali fo urus ina-ama kara dei. Maneniko mate au papa ka, besaꞌ ko au tuka.” ");
INSERT INTO rgu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tehuu Yesus dedea nae, “Leo iaꞌ! Nemeꞌ na ela lahenda fo ta ramahere Ramatuaꞌ a, urus sira lahenda mana mate nara. Tehuu maneniko o nau tuka Au, sona o muste tuka no matetuꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Basa de Yesus sama-sama no ana mana tuka dea nara ae leo ofaꞌ lain. ");
INSERT INTO rgu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ara leo dano a seriꞌ reu, boe ma Ana suku. Ta doo bea boeꞌ, te ruli a foa. Nafa ra rapepena, de oe a nala ofaꞌ daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ana mana tuka dea nara rita leoꞌ na boe ma ara fafae Ni rae, “Ramatuaꞌ! Ramatuaꞌ, ee! Foa fo tulu-fali ami dei! Huu fo ita sakaꞌ bolo riaꞌ so!” ");
INSERT INTO rgu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus nataa si nae, “Ubeaꞌ taon de emi biiꞌ? Emi ta mamahere Au fa, do?” Boe ma Ana foa, de nasaꞌai nafa-ani ria nae, “Mamate leo!” Boe ma nafa-ani tena tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yesus ana mana tuka dea nara heran, ma rae, “Awii! Te Lahenda ia nana bea ia? Tao leoꞌ bea, de Ana bisa pareta nafa-ani fo tuka Ria hihii-nanaun?” ");
INSERT INTO rgu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ta doo bea boeꞌ, te ara losa dano a seriꞌ, nai lahenda Gadara ra nusa na. Nai naa hapu lahenda nitu hekeꞌ dua, leo rahaniꞌ leaꞌ rates ara talada. Sira, makaresi nara seli, losaꞌ ta hapu lahenda esa naparani laꞌo nesiꞌ naa boeꞌ. Ara rita Yesus mai boe ma ");
INSERT INTO rgu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","bobouꞌ rae, “Ae, Manetualain Anan! Ubeaꞌ taon de O mai maepoꞌ ami? Leo mae bei ta losa ledo-fain fo huku ami, tehuu O nau mai ese-rumu ami ia so.” ");
INSERT INTO rgu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta dooꞌ a neme naaꞌ mai, bafi dodouꞌ totofi saka nanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Boe ma nitu ra hule Yesus rae, “Maneniko nau usi ami, sona madenu ami masoꞌ leo bafi sira daleꞌ meu!” ");
INSERT INTO rgu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus pareta si nae, “Meu leo!” Boe ma nitu ra kalua ela lahenda sira dua, de ara masoꞌ leo bafi ra daleꞌ reu. Bafi ra ralai ratotofaꞌ onda tuka lete a suu na, boe ma tuda rala dano daleꞌ, de mate basa si. ");
INSERT INTO rgu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Manea bafi ra rita leoꞌ na, boe ma ralai faliꞌ leo koroꞌ daleꞌ reu, ara tui basa-basan. ");
INSERT INTO rgu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lahenda kadodou-inaꞌ ara ramanene si tui rae leoꞌ na, boe ma ara leo mamanaꞌ ria reu. Ara raneta ro Yesus, boe ma ara hule doe-doe ro Ni fo laꞌo ela mamanaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Basa de Yesus asa saꞌe ra seluꞌ ofaꞌ a, fo leo dano seriꞌ reu, boe ma ara losa Ria kota Na. ");
INSERT INTO rgu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nai naa lahenda rolo reni sira nonoon lukun, leo Ria neu. Yesus nita leo naꞌ boe ma Ana bubuluꞌ nae, ara ramahere Ni bisa puli na sira nonoon ria. Boe ma Ana dedea neuꞌ lahenda lukuꞌ ria nae, “Ana Ki on! Matetea dale ma dei! Huu fo Au sae-safe heni o sala-sikom so.” ");
INSERT INTO rgu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tehuu mesen agama Yahudi hida rai naa, ramanene Yesus dedean ria. Boe ma dale nara hanas a, de bei dea rae, “Lahenda ia naparani laiesaꞌ dedea leo naꞌ! Noi Manetualain riꞌ bisa fee ampon neuꞌ lahenda sala-sikon. Tehuu lahenda ia dedea na, tao aon sama leoꞌ ria nana Manetualain. Ana namumulu-namamaeꞌ Manetualain ria so!” ");
INSERT INTO rgu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tehuu Yesus bubuluꞌ sira dale na. Boe ma Ana dedea nae, “Ubeaꞌ taon de emi afi mae, Au dedea namumulu-namamaeꞌ? ");
INSERT INTO rgu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Muda na riꞌ ubeaꞌ? Maneniko Au afada lahenda lukuꞌ ia ae, ‘O sala-sikom hapu ampon so,’ do, Au ae, ‘Foa fo fali leo.’ ");
INSERT INTO rgu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Maneniko ana foa tutiꞌ a, besaꞌ ko emi mita buti mae, Au nana, Ana Lahenda. Huu fo Au anuu haak fee ampon neuꞌ lahenda sala-sikon.” Boe ma Yesus pareta lahenda lukuꞌ ria nae, “Foa leo! Hai muni mamana napeu ma, fo fali leo!” ");
INSERT INTO rgu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lahenda lukuꞌ ria foa tutiꞌ a, de ana fali neun. ");
INSERT INTO rgu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Basa lahenda ra rita leo naꞌ, boe ma ara heran. Ara io-oa Manetualain nade Na rae, “Manetualain marela-masaꞌa naan seli! Ana fee kuasa bau-ina leo iaꞌ neuꞌ lahenda nai dae-bafoꞌ a so.” ");
INSERT INTO rgu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus laꞌo neme naaꞌ mai, boe ma nita lahenda mana susu bea esa, nai mamana sususu bea. Ria nade, Mateos. Yesus leleꞌon nae, “Mai tuka Au!” Mateos namanene leoꞌ na, boe ma foa de neu tuka tutiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Boe ma Mateos hule Yesus asa mai raa-rinu nai uma na. Ana hule nonoo mana susu bea nara, ma fui fekeꞌ ara boe, fo mai raa-rinu sama-sama roo si. ");
INSERT INTO rgu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tehuu lahenda hida reme partei Farisi a, mai ramuu-radau nai Yesus ana mana tuka dea nara rae, “Ubeaꞌ taon, de emi mesen ma natuuꞌ naa-ninu sama-sama noo lahenda masala-masikoꞌ ara, leo-leoꞌ mana susu bea ra, ma sira tia-lai lahenda tadalu nara?” ");
INSERT INTO rgu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tehuu Yesus nafada si nae, “Tebe lahenda kamahedis ara parluu doter. Tehuu lahenda sodaꞌ a ta parluu soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Malole lenaꞌ emi fali fo lees matalolole Manetualain Dedea-nafadan, fo riꞌ fai a ulu na Ana nadenu mana nesi matan Hosea duiꞌ nae, ‘Au hihii-nanau Ki, riꞌ, Au lahenda kara rasue-ralai ao ma ratudu dale kasian ara. Maneniko ara ta tao leo naꞌ, sona, sira banda tutunu-hohotun fo riꞌ reni fee Au a, ta nanuu sosoa-raraaꞌ hata-hata esa boeꞌ.’ Ria riꞌ Manetualain nafada nae. Huu ria na, Au ta mai urus lahenda fo tao ao nara dadi lahenda roos, tehuu Au mai urus lahenda masala-masikoꞌ ara.” ");
INSERT INTO rgu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Boe ma Yohanis Mana Saraniꞌ a ana mana tuka dea nara leo Yesus reu. Ara ratane rae, “Ami fo tuka Yohanis a, biasa puasa. Lahenda Farisi ra boe puasa. Tehuu ubeaꞌ taon, de Papa ana mana tuka dea mara raa-rinu raroo? Ara ta puasa ralelaꞌ fa, do?” ");
INSERT INTO rgu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tehuu Yesus nataa si, pake nasasamaꞌ nae, “Leo iaꞌ: maneniko feta kakabiꞌ, fui ra ta puasa fa, tehuu ara raa-rinu rabete. Maneniko mana kabi touꞌ a bei nai naa, tantu ara raa-rinu. Tehuu maneniko laiꞌ esa nai ria lahenda fekeꞌ ara hopu roo mana kabi touꞌ a, boe ma tia-lai nara susa dei, faiꞌ ria besaꞌ ko ara puasa. ");
INSERT INTO rgu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Lahenda ta hai na temaꞌ bibia bebeuꞌ, fo tapa neuꞌ badu paraa saiꞌ a. Huu fo maneniko safe badu ria, temaꞌ bebeu manatapaꞌ a uꞌulu. No ria na badu paraaꞌ a sii nambera. ");
INSERT INTO rgu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Leoꞌ na boe, lahenda ta isi tua nasu beuꞌ neuꞌ hai paraaꞌ daleꞌ. Huu fo neuꞌ ko haiꞌ ria hean, boe ma tua nasu a nosi henin. De tua nasu beuꞌ a muste disin leo hai bebeuꞌ daleꞌ neu, fo ela haiꞌ a bosoꞌ hean ma tua nasuꞌ a ta nosi henin!” No ria na, Yesus nanori si nae Ria nanori-nafadan, bebeuꞌ. De bosoꞌ epo-seoꞌ ana no nanori-nafada paraaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus bei dedea no Yohanis ana mana tuka dea nara, te malaka uma mamaso Yahudi esa mai naneta no Ni. Lahenda ria sundaꞌ undulaka na neuꞌ Yesus matan, fo hule nae, “Papa, ee! Tulu-fali dei! Huu fo au ana feto ka besaꞌ ko maten. Papa mai fo fua lima ma neuꞌ ana dei, ela bisa nasoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus namanene leoꞌ na, boe ma no ana mana tuka dea nara tuka tutiꞌ lahenda ria. ");
INSERT INTO rgu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Inaꞌ esa tuka no si rai eno taladaꞌ. Ana poꞌa-poꞌa mesan daa teuꞌ sanahulu dua, ta teꞌe matetuꞌ fa. Ana afi nai dale na nae, “Sadi au bisa afaroe laꞌe Yesus badu na, tantu au teꞌe a ao ki.” Huu ria na, de ana neu nafaroe Yesus badu peda na. ");
INSERT INTO rgu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus nameda naan, boe ma Ana lipe aon fo mete inaꞌ ria. Ana dedea nae, “Ana Ki on! Matetea dale ma. Huu fo o mamahere tebe-tebe neuꞌ Au, de o teꞌe ma aom.” No besaꞌ ria boe, inaꞌ a teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesus asa laꞌo raroo leo malaka uma mamaso Yahudi a, uma na reu. Losa naa boe ma Ana masoꞌ leo uma daleꞌ neu, ma nita mana mamina musik luumata-pinuiduꞌ, ma lahenda dodouꞌ dola. ");
INSERT INTO rgu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tehuu Yesus nafada si nae, “Emi hahae dodolaꞌ a, fo fali leo! Huu fo anaꞌ ia ta maten fa, ana suku ria.” Tehuu ara hiꞌa ma peko bafa nara ro Ni. ");
INSERT INTO rgu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Basa lahenda sira kalua, boe ma Yesus masoꞌ leo anaꞌ ria kaman daleꞌ neu, ma tai na lima na. Boe ma anaꞌ ria nasoda seluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lahenda ra rita leoꞌ na, boe ma ara mulai ratuiꞌ rule-feo sira nusa-namon laꞌe-neuꞌ hata fo Yesus tao a. ");
INSERT INTO rgu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Basa boe ma Yesus laꞌo naroo. Nai eno taladaꞌ, lahenda pokeꞌ dua tutukaꞌ Ana. Ara raloo bou-bou rae, “Mane Daud tititi-nonosin! Kasian neuꞌ ami dei!” ");
INSERT INTO rgu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus masoꞌ uma daleꞌ neu, boe ma lahenda poke kaduaꞌ sira mai. Ana natane si nae, “Emi mamahere tebe-tebe, mae Au anuu kuasa fo tao emi bisa mita-dae?” Ara rataa rae, “Awii! Papa bosoꞌ matane bali, huu fo ami mamahere tebe-tebe neuꞌ Papa.” ");
INSERT INTO rgu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesus namanene leoꞌ na, boe ma Ana nafaroe sira mata nara, ma dedea nae, “Kalu leoꞌ na, sona ela dadi tuka emi namahere ma!” ");
INSERT INTO rgu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus dedea basa leoꞌ na, boe ma ara rita-dae tutiꞌ a. Yesus nafarereneꞌ fee si nae, “Mafarereneꞌ. Emi bosoꞌ mafada lahenda hata mana dadiꞌ ia!” ");
INSERT INTO rgu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tehuu ara ta bisa ranenete fa. Boe ma ara laꞌo rule-feo nusaꞌ ria fo tui-beka laꞌe-neuꞌ Yesus nonoi-tataon. ");
INSERT INTO rgu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lahenda poke kaduaꞌ sira kalua, boe ma lahenda roo lahenda fekeꞌ esa leo Yesus neu. Lahenda ria ta bisa nadedea fa, huu fo nitu a heke naan. ");
INSERT INTO rgu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus nita leoꞌ na, boe ma Ana pareta nitu a kalua neme lahenda ria mai. Nitu a kalua boe ma lahenda ria bisa nadedea tutiꞌ a. Basa lahenda fo rai naa, ara heran, ma rae, “Awii! Ami lahenda Yahudi a bei ta parnaa mita leo iaꞌ fa!” ");
INSERT INTO rgu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tehuu lahenda Farisi ra dale nara ta loaꞌ a. Ara dedea rae, “Ae! Nitu ra malaka na riꞌ feen kuasa fo ela Ana bisa usi kalua nitu.” ");
INSERT INTO rgu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Basa de Yesus laꞌo rule-feo kota ma koroꞌ dodouꞌ, fo nanori-nafada nai uma mamaso Yahudi ra. Ana nanori-nafada lahenda laꞌe-neuꞌ Manetualain Tutui Malole Na, ma tao leoꞌ bea fo ara bisa dadi reuꞌ Ria lahendan. Ana puli na basa hedis rupaꞌ ara, ma lahenda luku-lakaꞌ ara boe. ");
INSERT INTO rgu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesus nita lahenda kadodouꞌ sira, boe ma Ana kasian neuꞌ asa, huu fo ara ta bubuluꞌ rae tao leo beaꞌ. Nana huu sira basa sama leoꞌ bibi-lopo fo ta ranuu mana foo. ");
INSERT INTO rgu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Boe ma Yesus dedea no ana mana tuka dea nara nae, “Lahenda kadodouꞌ ia ra, sama leoꞌ oka-tine a buna-boan. Leo mae buna-boan dodouꞌ, tehuu lahenda mana noi ta dai fo etu-oru buna-boaꞌ sira, ma peda si reuꞌ mamana pepeda-fufuaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huu ria na, emi muste hule Manuu okaꞌ a fo fee lahenda mana noi seluꞌ, fo ela ara reu rabubua ra Ria buna-boa nara.” ");
INSERT INTO rgu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Boe ma Yesus naloo na ana mana tuka dea nara fo mai rabuaao nara. Ana fee si kuasa fo usi nitu, ma puli ra lahenda reme hedis rupaꞌ ara mai. ");
INSERT INTO rgu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana mana tuka dea kasanahulu duaꞌ fo Ana nadenu si a, nade nara siꞌ: Masososaꞌ a, nade Simon (fo biasa lahenda raloon rae, ‘Petrus’), ma fadi na, nade Anderias, Yakobis, ma fadi na, nade Yohanis (sira dua, nana Sabadeus ana nara). ");
INSERT INTO rgu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus, ma Bertolomeos. Tomas, ma Mateos (mana susu bea). Yakobis (Alpius ana na), ma Tadius. ");
INSERT INTO rgu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon (fo tuka partei Selot), ma Yudas Iskariot (fo riꞌ neuꞌ ko seꞌo heni Yesus). ");
INSERT INTO rgu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Boe ma Yesus nadenu ana mana tuka dean sanahulu duas, ma Ana fee si pareta nae, “Au adenu emi leo ita lahenda Yahudi nara meu, nana huu ita lahendan dodouꞌ ta tuka matetuꞌ Manetualain eno-dalan. Sira nana, sama leoꞌ bibi-lopo manasala-manamopoꞌ. Huu ria na, emi bosoꞌ leo lahenda fo ta Yahudi fa, conto leo-leoꞌ lahenda Samaria ra. ");
INSERT INTO rgu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Meu mafada ita lahenda Israel nara mae, ‘Losa ledo-fain so, de basa lahenda Yahudi ra bisa dadi reuꞌ Manetualain lahenda nara.’ ");
INSERT INTO rgu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Meu puli ma lahenda kamahedis, fee lahenda mana mateꞌ ara rasoda seluꞌ, puli ma lahenda kamahedis kusta, ma usi kalua nitu. Manetualain fee emi dodouꞌ, tehuu Ana ta hule faliꞌ hata-hata esa boeꞌ. De besaꞌ ia emi muste meu ela fee dodouꞌ soa-neuꞌ lahenda fekeꞌ, tehuu emi bosoꞌ hule faliꞌ hata-hata esa neme sira mai boe. ");
INSERT INTO rgu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Meu hihiiꞌ. Bosoꞌ meni doi-tali, ");
INSERT INTO rgu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tua-lepa, kakao-papake lenaꞌ, sopatu, do teteꞌe. Huu fo lahenda fo riꞌ sipo nanori-nafada neme mana noi, muste fee hata fo naraa neuꞌ mana noi sira bisa rasoda. ");
INSERT INTO rgu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Maneniko emi masoꞌ leo kota esa, do koroꞌ esa meu, sona emi saka lahenda fo riꞌ nau sipoꞌ emi. Boe ma leo mahaniꞌ naa, losaꞌ emi foa ela mamanaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Maneniko emi masoꞌ leo lahenda uman meu, sona mafada mae, ‘Soda-moleꞌ! Manetualain fee ua-naleꞌ soa-neuꞌ emi.’ ");
INSERT INTO rgu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Maneniko lahenda rai uma ria sipoꞌ emi no malole, emi hule fo Manetualain fee si ua-naleꞌ. Tehuu maneniko ara ta sipoꞌ emi, Manetualain boe ta fee si ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Maneniko lahenda ta nau ramanene neuꞌ emi, sona kalua meme uma ria, do kota ria, ma sasapu heni afu a neme ei mara mai, ela dadi tanda nae, ara ta nau ramanene, de ara lepa ao nara natataaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Maneniko Manetualain fee huhukuꞌ neuꞌ lahenda nai dae-bafoꞌ ia, neuꞌ ko Ana fee huhukuꞌ mabera neuꞌ lahenda Sodom ma Gamora fo riꞌ fai a ulu na tadalu raan seli a. Tehuu mafarereneꞌ. Huu fo Ana fee huhuku mabera lena bali soa-neuꞌ lahenda fo riꞌ ta nau sipoꞌ emi!” ");
INSERT INTO rgu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mafarereneꞌ. Huu fo Au adenu emi ia, sama leoꞌ Au poꞌi bibi-lopo a leo busa fui maꞌaaꞌ a talada neu. Huu ria na, emi muste pake duduꞌa-aafiꞌ sama leoꞌ meke malelaꞌ. Ma emi dale ma boe muste roo-tetuꞌ, sama leoꞌ manupui kalasi fo ta saka nalelaꞌ dedea lakaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tehuu besa-besa! Huu fo neuꞌ ko lahenda ese-rumu emi sama leoꞌ busa fuiꞌ aa namate bibi-lopo. Neuꞌ ko ara hela roo emi leo mamana parisa dedea agama a meu. Ma neuꞌ ko ara liꞌu-fepa emi nai sira uma mamaso Yahudi na. ");
INSERT INTO rgu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Neuꞌ ko ara hela roo emi meu mataa nai gubernor no maneꞌ a, nana huu emi tuka Au. Tehuu emi muste pake lelaꞌ ria fo tui-beka Au Tutui Malole Ka soa-neuꞌ asa. No ria na, lahenda fo ta ralelaꞌ Manetualain boe oo, ramanene laꞌe-neuꞌ Au. ");
INSERT INTO rgu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tehuu maneniko ara hela roo emi leoꞌ na, sona bosoꞌ biiꞌ mae, ‘Neuꞌ ko au dedea ae, leoꞌ bea?’ Do, ‘Neuꞌ ko au ataa ae, ubeaꞌ?’ Bosoꞌ dale mara dodaꞌ, huu fo losa ledo-fai na, te neuꞌ ko emi Amam nai nusatetu-ikutemaꞌ a riꞌ nafada emi muste dedea mae leoꞌ bea. ");
INSERT INTO rgu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hata fo emi dedean ta naoka-nasamu neme emi mai fa, huu fo Ria Dula-dale Malalao-malalafu Na riꞌ nanori-nafada, ela emi bisa dedea mae leoꞌ bea. ");
INSERT INTO rgu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Emi mete fa, nai uma esa daleꞌ, maneniko lahenda namahere Au, neuꞌ ko ria toranoo boki na riꞌ saka enoꞌ fo ela lahenda fekeꞌ naisa toranoon ria. Maneniko anaꞌ a namahere, neuꞌ ko papa na riꞌ naisa ni. Maneniko ina-ama ramahere, neuꞌ ko sira ana boki na riꞌ naisa si. ");
INSERT INTO rgu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Meten fa, neuꞌ ko basa lahenda eteꞌ ao nara ro emi, nana huu emi tuka Au. Tehuu lahenda fo nanenete losaꞌ babasa na, neuꞌ ko Manetualain poꞌi-tata naan. ");
INSERT INTO rgu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Maneniko lahenda ese-rumu emi nai kota esa, sona malai leo kota fekeꞌ meu. Tebe ria! Au ia, Ana Lahenda. Neuꞌ ko emi bei ta laꞌo rule-feo mabasa kota nai Israel, tehuu Au atafali mai so. ");
INSERT INTO rgu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Lahenda ra biasa fee hada-horomata neuꞌ mesen esa, lena neme ria ana sakola nara. Ma lahenda fee hada-horomata neuꞌ malaka esa, lena neme ria ata nara. ");
INSERT INTO rgu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Maneniko ana sakola a nanori de malela na sama no ria mesen na, sona ana nameda naan dai so. Ma kalu ata a nanori, de malela na sama no ria malaka na, sona ana nameda naan dai so boe. De, mafarereneꞌ. Maneniko lahenda naloo manuu umaꞌ a nae, ‘O ia, nana Balsebul, fo riꞌ nitu ra malaka na!’ Sona tantu ria uma isi nara boe hapu nade tadaluꞌ lena bali.” ");
INSERT INTO rgu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“De, emi bosoꞌ bii lahenda fo soaꞌ emi. Te hata fo lahenda tao nafufuniꞌ, neuꞌ ko basa lahenda ra rita. ");
INSERT INTO rgu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hata fo Au anori-afadan noi neuꞌ emi, neuꞌ ko emi muste meu mafada basa lahenda ra. Ma hata fo Au afada oi abobotoꞌ a, neuꞌ ko emi muste meu mafada rule-feo nai basa mamanaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bosoꞌ bii lahenda, huu fo sira bisa raisa noi lahenda ao-ina na, tehuu ara ta bisa raisa lahenda sumane na. Huu ria na, emi muste biiꞌ Manetualain, te noi Ria riꞌ nanuu kuasa fo tuꞌu heni lahenda ao-ina na no sumane na leo tasi ai-pila mana mate taaꞌ a daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","De matetea dale mara. Lahenda seꞌo manupui karutuꞌ nai pasar neniꞌ beliꞌ bai anaꞌ. Tehuu ta mate esa boeꞌ, kalu emi Papa ma nai nusatetu-ikutemaꞌ a ta nataa fa. ");
INSERT INTO rgu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Emi Papa ma nai nusatetu-ikutemaꞌ a boe relu-natanae emi losa leo lulutu-raraeꞌ a. Emi lakadoo mara dedesi na boe, Ana reke naa si so. ");
INSERT INTO rgu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De, emi bosoꞌ biiꞌ! Huu fo Manetualain uku-sudi emi beli ma lena neme basa manupui karutuꞌ sira mai.” ");
INSERT INTO rgu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Boe ma Yesus dedea bali nae, “Lahenda fo naparani manaku nae nalelaꞌ Au nai lahenda dodouꞌ matan nai dae-bafoꞌ ia, neuꞌ ko Au boe manaku ae alelaꞌ ana nai Au Papa ka matan, nai nusatetu-ikutemaꞌ a ae, ‘Ria nana Au lahenda Ki.’ ");
INSERT INTO rgu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tehuu lahenda fo nalena Au nai lahenda dodouꞌ matan nae, ana ta nalelaꞌ Au, neuꞌ ko Au boe afada Papa Ka nai nusatetu-ikutemaꞌ a ae, ‘Au ta alelaꞌ lahenda ia.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Emi bosoꞌ afi mae, Au mai uni mole-dame nai dae-bafoꞌ ia. Au mai fo tao a lahenda ra esa soaꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au mai nai dae-bafoꞌ ia, tuka hata fo riꞌ Manetualain mana nesi mata nara duiꞌ memaꞌ so rae, ‘Neuꞌ ko ana touꞌ a soaꞌ papa na, ana inaꞌ a soaꞌ mama na, ma manafeu inaꞌ a soaꞌ arina na, ");
INSERT INTO rgu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","huu fo uma isiꞌ ara siꞌ esa musu no esa.’ ");
INSERT INTO rgu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","De, lahenda bea tebe-tebe nau tuka Au, ana muste sue Au lena neme basa-basan; lena neme ina-aman, ma lena neme ria ana nara mai. Maneniko taꞌa, sona lahenda ria ta naraa dadi neuꞌ Au lahenda Ki. ");
INSERT INTO rgu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Lahenda bea nau tuka Au, tehuu ta nau lepa doidoso, ana ta naraa dadi neuꞌ Au lahenda Ki. ");
INSERT INTO rgu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Lahenda bea sadia mate nana huu ana tuka Au, neuꞌ ko nasoda naroo no Manetualain. Tehuu lahenda bea nasoda soa noi ria ao-ina hehelin, neuꞌ ko soda na sapu-lalo!” ");
INSERT INTO rgu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Lahenda bea sipoꞌ emi no malole, ria boe sipoꞌ Au. Ma lahenda bea sipoꞌ Au, ria boe sipoꞌ Manetualain fo riꞌ nadenu Au. ");
INSERT INTO rgu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Lahenda bea sipoꞌ Manetualain mana nesi matan, huu fo sira dedea laꞌe-neuꞌ Manetualain, neuꞌ ko Manetualain balas ana sama leoꞌ Manetualain balas mana nesi mata esa. Ma lahenda bea sipoꞌ lahenda dale roo-tetuꞌ esa, huu fo lahenda ria tuka matetuꞌ Manetualain hihii-nanaun, neuꞌ ko Manetualain balas ana sama leoꞌ Manetualain balas neuꞌ lahenda dale roo-tetuꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lahenda bea sipoꞌ lahenda aanaꞌ esa, huu fo ana tuka Au, tantu Manetualain balas ana. Leo mae lahenda fee noi oe hihiiꞌ galas esa boe, tantu Manetualain ta nafarene heni ni.” ");
INSERT INTO rgu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Fai fo Yesus helu basa soa-neuꞌ ana mana tuka dean sanahulu duas, boe ma Ana laꞌo rule-feo koroꞌ nai nusaꞌ ria, fo nanori-nafada lahenda ma tui-nafada Manetualain Tutui Malole Na. ");
INSERT INTO rgu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tepoꞌ ria, Yohanis nai bui daleꞌ. Ana namanene basa hata fo Yesus tao a, boe ma nadenu ana mana tuka dea nara reu ratane Yesus rae, ");
INSERT INTO rgu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Manetualain helu memaꞌ neme uluꞌ mai nae, Ana nau fee Kristus mai fo poꞌi-tata naa ita lahenda Yahudi. Papa nana, riꞌ Kristus, do? Do, ami muste mahani lahenda fekeꞌ bali?” Boe ma ara reu ratane Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus namanene leoꞌ na, boe ma nataa nae, “Emi mamanene, ma mita mataꞌ so. De fali leo fo tui aꞌa Yohanis mae, basa-basan dadi tuka hata fo Manetualain mana nesi matan Yesaya duiꞌ memaꞌ nae: ");
INSERT INTO rgu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lahenda pokeꞌ a, nita-dae. Lahenda lukuꞌ a, foa fo laꞌo. Lahenda kamahedis kusta, dadi makamoiꞌ. Lahenda pakeꞌ a, namanene. Lahenda mana mateꞌ a, nasoda seluꞌ. Lahenda kasian a, namanene Tutui Malole. ");
INSERT INTO rgu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","De leo iaꞌ: meu mafada aꞌa Yohanis mae, neuꞌ ko ana naua-nanale kalu namahere naroo Au. Huu fo neuꞌ ko Manetualain fee ua-naleꞌ neuꞌ lahenda fo namahere naroo Au, ma ta keke-boiꞌ fa!” ");
INSERT INTO rgu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohanis ana mana tuka dea nara fali, boe ma Yesus dedea no lahenda kadodouꞌ ara laeꞌneuꞌ Yohanis nae, “Tepoꞌ fo emi meu saka Yohanis nai mamana lino-nees a, emi afi mae nau meu mita lahenda rupa-lole leo beaꞌ? Emi bubuluꞌ ria ta lahenda noe-naꞌu sama leoꞌ oo teriꞌ, de ani a fuun sona liuꞌ neu-mai! ");
INSERT INTO rgu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ria boe ta lahenda pake papake mabeli, huu fo lahenda rupaꞌ leo naꞌ a leo-naparasa noi nai uma maneꞌ! ");
INSERT INTO rgu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","De emi meu mita lahenda rupa leo beaꞌ a nai naa? Ria nana Manetualain mana nesi matan. Tebe! Ria nana mana nesi mata fo kahereꞌ naan seli. ");
INSERT INTO rgu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Huu fo Manetualain Susura Makamoi Na manaduiꞌ memaꞌ laꞌe-neuꞌ Yohanis nae, ‘Nenene! Au adenu lahenda Ki, fo neu soi enoꞌ soa-neuꞌ O.’ ");
INSERT INTO rgu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nenene matalolole! Nai dae-bafoꞌ ia, ta hapu lahenda esa kahereꞌ lena Yohanis boeꞌ. Tehuu neuꞌ ko lahenda ra manaku rae Mesias nana sira Manen. Ma basa lahenda ra, leoꞌ na boe lahenda fo aanaꞌ naan seli a, Manetualain tao si reuꞌ lahenda kahereꞌ lena neme Yohanis mai. ");
INSERT INTO rgu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mulai neme Yohanis noi ria nonoi-tataon losaꞌ besaꞌ ia, lahenda dodouꞌ dadi reu Manetualain nuun. Tehuu nai lahenda sira talada ruma afi sala. Ara makate raan seli losaꞌ rasetiꞌ lahenda fekeꞌ ara masoꞌ dadi reuꞌ Manetualain lahendan. Tehuu lahenda fo riꞌ raseti si a, ara ta sipoꞌ ma radedea laka neuꞌ Manetualain lahendan sira. ");
INSERT INTO rgu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Losa leo Yohanis Mana Saraniꞌ a mamai na, ita lahenda Yahudi a bisa tuka baꞌi Musa ma Manetualain mana nesi mata nara atoran. ");
INSERT INTO rgu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","De mamahere Au! Elia fo riꞌ Manetualain mana nesi matan nafada memaꞌ a ana natafali seluꞌ mai, riꞌ Yohanis! ");
INSERT INTO rgu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","De, bea nau bubuluꞌ, muste nenene natalolole! ");
INSERT INTO rgu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Au nau fee nasasamaꞌ ela emi malelaꞌ lahenda besaꞌ ia ra, lahenda dae-bafo rupa ubeaꞌ. Huu fo sira sama leoꞌ anaꞌ fo ratuuꞌ rai pasar. Ara raloo bou-bou ro sira tia-lai nara rae, ");
INSERT INTO rgu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ae! Ami fuu belaꞌ suling, tehuu emi ta roke-foti no namahoꞌo. Boe ma ami soda sosoda luumata-pinuiduꞌ, tehuu emi ta dola.’ ");
INSERT INTO rgu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Emi ia sama leoꞌ ana aanaꞌ ara fo ta doaꞌ fa. Tepoꞌ fo Yohanis mai, ana nahiiꞌ puasa, ma ta ninuu anggor. Tehuu lahenda tao ni neuꞌ, ‘Nitu hekeꞌ!’ ");
INSERT INTO rgu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Besaꞌ ia Au, Ana Lahenda, mai so. Au ta puasa, ma inu anggor. Tehuu lahenda tao Au neuꞌ, ‘Lahenda maoroꞌ! Mana mafuꞌ! Ana neu natiaꞌ no mana susu bea ra! Partei esa no lahenda papake taaꞌ ara! Ta nameda aon!’ Nenene matalolole! Manetualain duduꞌa-aafi tanden nananitaꞌ nai Ria lahenda nara masodan.” ");
INSERT INTO rgu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Boe ma Ramatua Yesus mulai nasaꞌai lahenda fo leo rai koroꞌ hida. Ana tao tanda heran dodouꞌ nai naa so, tehuu ara ta nau saledale-tuꞌetei nara, fo tuka Manetualain eno masoda roo-tetun. ");
INSERT INTO rgu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus nasaꞌai nae, “Emi basa lahenda Korasin, ma lahenda Betsaida! Besa-besa, ee! Neuꞌ ko emi soe! Au tao tanda heran rupaꞌ ara nai emi mata-idum, tehuu emi ta nau mamahere Manetualain. Sekona te, emi ia lahenda Yahudi, fo manaku mae malelaꞌ Manetualain. Tehuu uniꞌ ko leo tanda heran fo riꞌ Au tao si rai emi koro-tadum, dadi nauluꞌ nai kota Tirus ma kota Sidon, tantu doo-naru basa ia lahenda fo rai naa saledale-tuꞌetei nara, ma tuka Manetualain. Ma sira boe tantu pake papake luumata-pinuiduꞌ, ma kari afu neuꞌ laka nara fo dadi tanda nae, sira rasaledale no sala-siko nara. Sekona te lahenda Tirus ma lahenda Sidon, nana lahenda ta Yahudi fo manaku rae ralelaꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tebe! Neuꞌ ko emi mita! Maneniko Manetualain naetuꞌ basa lahenda ra dedean, lahenda Tirus ma lahenda Sidon huhuku na bei kafaꞌ a reme emi huhuku ma mai. ");
INSERT INTO rgu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Emi lahenda Kapernaum! Besa-besa, ee! Emi bosoꞌ afi mae, neuꞌ ko Manetualain soꞌu emi leo nusatetu-ikutemaꞌ a meu. Taꞌa! Neuꞌ ko Manetualain tuꞌu emi leo naraka a meu! Uniꞌ ko leo tanda heran fo riꞌ Au taon nai emi koro ma dadi nauluꞌ nai kota Sodom, tantu Manetualain ta parluu tao nalulutuꞌ kota tadaluꞌ ria. Huu fo maneniko lahenda Sodom ara rita tanda heran sira, tantu ara foa ela sira tadalu nara so. ");
INSERT INTO rgu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tebe! Neuꞌ ko emi mita! Maneniko Manetualain naetuꞌ basa lahenda ra dedean, lahenda Sodom ara huhuku na bei kafaꞌ a neme emi huhuku ma mai!” ");
INSERT INTO rgu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesus dedea basa nae leoꞌ na, boe ma Ana hule-haradoi nae, “Papa! Papa riꞌ manuu haak pareta basa-basan nai lalai ma dae-bafoꞌ a. Au hule makasi dodouꞌ, nana huu Papa mafuni huhukuꞌ neme lahenda tao ao nara malelaꞌ, ma mana koaoꞌ ara. Tehuu Papa soi basa huhukuꞌ sira reuꞌ loan soa-neuꞌ lahenda aanaꞌ ara ma lahenda dale balaroe-balanauꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tebe, Papa! Huu fo ria riꞌ tao na Papa dale Ma namahoꞌo!” ");
INSERT INTO rgu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesus hule-haradoi basa leoꞌ na, boe ma nafada lahenda rai naa nae, “Nenene matalolole! Au Papa Ka nai nusatetu-ikutemaꞌ a fee Au kuasa a katemaꞌ so. Noi Au Papa ka, riꞌ nalelaꞌ Au. Ma noi Au ia fo Ana Na, riꞌ alelaꞌ matetuꞌ Amaꞌ a. Ma Au teka-here lahenda fekeꞌ ara, fo afada si, ela sira boe ralelaꞌ matetuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Basa manamela-manamakuꞌ emin, mai tuka Au! Basa manalepa bera-bauꞌ emin, leo Au mai! ");
INSERT INTO rgu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Maneniko emi sipoꞌ Au nanori-nafada Ki, fo laꞌo sama-sama mo Au, sona ita ia sama leoꞌ sapi luku dua hela belaꞌ luku esa. Huu fo Au, dale malole, ma Au dale balaroe-balanauꞌ. Maneniko emi tuka Au, sona emi dadi mapii-baraaiꞌ seluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Huu fo Au nanori-nafada Ki, ta susa fa. Ma Au pareta Ka, ta beraꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Laiꞌ esa de, naraa laꞌe lahenda Yahudi ra fai hahae aon, Yesus no ana mana tuka dea nara laꞌo tuka lahenda oka-tinen. Huu no Ria ana mana tuka dea nara ramalaa, de ara etu ra hade gandum a pule na fo ara raa laꞌo-laꞌo. ");
INSERT INTO rgu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nai naa, lahenda hida reme partei Farisi fo riꞌ homu rahere sira hadas Yahudi na. Rita Yesus ana mana tuka dea nara tao leo naꞌ, boe ma ara rasaꞌai Ni rae, “O ana mana tuka dea mara etu hade gamdum naraa laꞌe fai hahae aoꞌ! Ta bole leo naꞌ fa! Huu fo ria nana nalena laka ita atoran.” ");
INSERT INTO rgu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Tehuu Yesus nataa si nae, “Leoꞌ bea? Emi ta mafarene baꞌi Daud tutui na? Baꞌi Daud no ana mana tuka dea nara ramalaa raan seli. Boe ma ara masoꞌ leo Manetualain Manetualain Laa Huhule-haradoi Na daleꞌ reu, de hai roti fo riꞌ malaka agama ra fee neuꞌ Manetualain, de ara raa. Sekona te noi malaka agama ra siꞌ bole raa roti ria. Lahenda fekeꞌ, sona ta bole fa. Baꞌi Daud asa raa, tehuu ta hapu lahenda sale si. Nonooꞌ leo emi ta lees Manetualain Susura Makamoi Na! ");
INSERT INTO rgu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nai naa boe manaduiꞌ laꞌe-neuꞌ malaka agama fo riꞌ ralalau nai uma mamasoꞌ, naraa laꞌe fai hahae aoꞌ. Tehuu ta sala fa. ");
INSERT INTO rgu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nenene! Maulu na uma mamasoꞌ a riꞌ penting, tehuu besaꞌ ia ruma penting lena bali. Riꞌ Au, Ana Lahenda ia. ");
INSERT INTO rgu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nai Manetualain Susura Makamoi Na, Manetualain nae, ‘Au hihii-nanau Ka leo iaꞌ: Au lahenda kara muste ratudu dale kasian nara esa no esa. Maneniko ara ta tao leo naꞌ, sona sira banda tutunu-hohotun fo riꞌ reni fee Au a, sosoa-raraaꞌ taꞌa.’ Maneniko emi bubuluꞌ matetuꞌ Manetualain dedea Na, tantu emi ta sale mae Au ana mana tuka dea kara sala. Huu fo sira ta tao salaꞌ hata esa boeꞌ! ");
INSERT INTO rgu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Au ia, Ana Lahenda. Au riꞌ anuu haak fo aetuꞌ ae, lahenda bole tao ubeaꞌ naraa laꞌe fai hahae aoꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Basa boe ma Yesus laꞌo ela mamanaꞌ ria, fo leo sira uma mamaso Yahudi na neu. ");
INSERT INTO rgu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nai naa, hapu touꞌ esa mate liman seri. Lahenda Farisi ra rasaka enoꞌ nau sale Yesus, uniꞌ ko leo Ana puli na lahenda fo riꞌ mate liman seri a, naraa laꞌe fai hahae aoꞌ. Boe ma ara ratane Ni rae, “Tuka ita atoran agama na, lahenda bole puli na lahenda naraa laꞌe fai hahae aoꞌ do, taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus nataa si nae, “Maneniko lahenda bibi-lopon esa tuda nala boloꞌ daleꞌ, naraa laꞌe fai hahae aoꞌ, tantu manuu bibiꞌ a neu hela heni bibi-lopo ria leo deaꞌ mai, hete? ");
INSERT INTO rgu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Manetualain sue-lai lahenda dae-bafoꞌ a, lena neme manuu bibiꞌ a sue ria bibi-lopon. Huu ria na, lahenda bole tao hihii-nanauꞌ malole naraa laꞌe fai hahae aoꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Boe ma dedea noo lahenda fo riꞌ mate liman seri a nae, “Aꞌa, ee! Looꞌ lima ma mai!” Ana looꞌ lima mates na, boe ma teꞌe tutiꞌ a, sama leoꞌ lima masoda na. ");
INSERT INTO rgu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lahenda Farisi ra rita leoꞌ na, boe ma nasa nara lua. De ara kalua ela uma mamasoꞌ ria, boe ma ara reu dedearaoꞌ rae, “Ita muste saka enoꞌ fo taisa Ni!” ");
INSERT INTO rgu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tehuu Yesus bubuluꞌ sira dale tadalu na, huu ria na de Ana laꞌo leo mamana fekeꞌ neu. Lahenda dodouꞌ tuka Ni, boe ma Ana puli na basa lahenda kamahedis ara. ");
INSERT INTO rgu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tehuu Ana horo si nae, “Emi bosoꞌ mafada lahenda fekeꞌ a laꞌe-neuꞌ Au.” ");
INSERT INTO rgu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ana tao leo naꞌ tuka hata fo Manetualain nafada neuꞌ Ria mana nesi matan Yesaya nae, ");
INSERT INTO rgu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Soba mete! Ia nana Au lahenda nadedenu Ki fo riꞌ Au teka-here Ni a. Au sue-lain, ma Au dale Ka namahoꞌo naroo oo Ni. Neuꞌ ko Au fee Ni Au Dula-dale Ka, ela Ana neu nanori-nafada lahenda nai basa nusa-namo laꞌe-neuꞌ Au eno masoda roo-tetu Ka. ");
INSERT INTO rgu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ana ta io aon. Ana ta natutua-nadedema aon. ");
INSERT INTO rgu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ria dale na malole a. Ana ta tao nasususaꞌ lahenda. Ai fo sakaꞌ tepan, Ana ta helu henin. Dedede anaꞌ fo noi nasararaꞌ a, Ana ta fuu naisan. Ana nanori-nafada naroo lahenda, losaꞌ basa lahenda nusaꞌ ara bubuluꞌ de tuka Manetualain eno masoda roo-tetun. ");
INSERT INTO rgu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lahenda reme basa nusaꞌ ara mai, neuꞌ ko ramahere Au, huu fo ara bubuluꞌ rae Ria nana bea.” ");
INSERT INTO rgu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lahenda esa nitu a heke naan losaꞌ poken, ma ta bisa dedea fa, laiꞌ esa de lahenda ra roo ni leo Yesus neu. Boe ma Yesus puli naan, ma usi heni nitu ria. De lahenda ria bisa nita-dae, ma bisa dedea tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Basa lahenda ra rita leoꞌ na, boe ma ara heran. Ara bei dea rae, “Bate ia nana, Daud tititi-nonosin, fo riꞌ Manetualain mana nesi mata nara duiꞌ memaꞌ neme fai a ulu na mai. Ria nana, tantu riꞌ Lahenda fo ita tahanin a!” ");
INSERT INTO rgu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tehuu lahenda Farisi ra ramanene leoꞌ na, boe ma ara ta sipoꞌ. De ara bei dea rae, “Ae! Lahenda ia bisa usi kalua nitu, nana huu nitu ra malakan Balsebul, riꞌ fee Ni kuasa.” ");
INSERT INTO rgu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tehuu Yesus bubuluꞌ lahenda Farisi ra dedea na. Boe ma Ana nafada si nae, “Emi dedea ma, ta laꞌe fa! Maneniko nai nusaꞌ esa, anaraun nara ranalaao, tao leoꞌ bea fo nusaꞌ ria bei bisa natataꞌa! Leoꞌ na boe maneniko lahenda rai kota esa daleꞌ, do rai uma esa daleꞌ, esa naruiao no esa, tantu ara rabika-rabatiꞌ losaꞌ rasosopuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De, maneniko nitu ra ranalaao ma rausiao, sona sira malaka na ta bisa homu pareta namanoso soꞌ! ");
INSERT INTO rgu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mafarereneꞌ. Hapu lahenda rai emi Farisi a talada, lahenda fekeꞌ ara rae sira ranuu kuasa fo usi nitu. Ara pake kuasa neme nitu a mai, do? Taꞌa! De emi bosoꞌ dedea mafararaꞌu mae, Au pake nitu a kuasa na fo usi nitu. Neuꞌ ko emi lahenda mara siꞌ raetuꞌ rae, hata fo emi mapaneneoꞌ ana a, sala. ");
INSERT INTO rgu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tehuu maneniko tebe-tebe Au usi nitu pake kuasa neme Manetualain Dula-dale Malalao-malalafu Na, ria natudu nae, tebe Manetualain Maneꞌ nai emi mata-idum. ");
INSERT INTO rgu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Maneniko lahenda nau mai ofe hata nai lahenda baraꞌaiꞌ esa uma na, ana muste heke naisaꞌ lahenda ria dei. Besaꞌ ko, ana bisa ofe neni lahenda ria hata-heton. ");
INSERT INTO rgu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mafarereneꞌ matalolole! Huu fo lahenda bea ta eiꞌ esa noo Au, sona ria nana Au musunoo Ki. Ma lahenda bea ta tulu-fali Au nai nonoi-tatao Ka, ria nanatao noi liuaariꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","De nenene matalolole Au dedea Ka! Manetualain sadia sae-safe heni lahenda sala-sikon. Ma kalu lahenda dedea ta malole soa-neuꞌ lahenda fekeꞌ, Manetualain bei sadia fee ni ampon. Tehuu maneniko lahenda naparani dedea ta malole soa-neuꞌ Manetualain Dula-dale Malalao-malalafu Na, Manetualain ta sae-safe heni ria sala-sikon. ");
INSERT INTO rgu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Maneniko lahenda dedea tadaluꞌ soa-neuꞌ Au, Ana Lahenda ia, Manetualain sadia fee ampon neuꞌ ana. Tehuu maneniko lahenda dedea nadadae Manetualain Dula-dale Malalao-malalafu Na, leo mae losa dae-bafoꞌ a noe boe oo, Manetualain ta sae-safe heni ria sala-sikon!” ");
INSERT INTO rgu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Boe ma Yesus dedea naroo neuꞌ lahenda Farisi ra nae, “Afi matalolole! Ai huu malole naboa boa malole. Tehuu ai huu tadaluꞌ a naboa boa tadaluꞌ. Huu fo neme ai huuꞌ a boa na mai, lahenda bisa bubuluꞌ nae, ai huuꞌ ria malole a, do taꞌa. ");
INSERT INTO rgu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tehuu emi sama leoꞌ meke mapuputaꞌ! Emi ta bisa dedea hihii-nanau malole ra. Nana huu hata fo nanapedaꞌ nai lahenda dale na, ria riꞌ neuꞌ ko kalua neme ria bafa na mai. ");
INSERT INTO rgu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lahenda malole, tantu dedea malole nana huu hihii-nanau malole ra nanapedaꞌ rai ria dale na. Tehuu lahenda tadaluꞌ a, tantu dedea tadaluꞌ, nana huu hihii-nanau tadaluꞌ ara nanapedaꞌ rai ria dale na. ");
INSERT INTO rgu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mamahere Au! Huu fo maneniko dae-bafoꞌ a noe, neuꞌ ko Manetualain parisaꞌ basa lahenda ra dedean. Tepoꞌ ria, lahenda ra muste esaꞌ ko nataa aon ria dedean fo riꞌ ta nanuu sosoa-raraaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","De besa-besa, ee! Huu fo neuꞌ ko Manetualain tai emi dedea-nafadam, ma naetuꞌ nae, emi hapu huhukuꞌ, do taꞌa.” ");
INSERT INTO rgu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ramanene Yesus dedea nae leoꞌ na, boe ma mesen agama hida ma lahenda Farisi ra hule Ni rae, “Papa Mesen! Ami mahiiꞌ mita Papa tao tanda heran, fo dadi buti nae, Papa kuasa Ma tebe-tebe neme Manetualain mai.” ");
INSERT INTO rgu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tehuu Yesus nasapaa si nae, “Emi lahenda besaꞌ ia ta nau mamania-mamanene neuꞌ Manetualain! Emi tao noi tadaluꞌ a! Leo mae emi hule tanda heran, tehuu Au ta fee. Huu fo fai a ulu na Manetualain fee tanda heran so, pake Ria mana nesi matan Yunus. Ria dai so! ");
INSERT INTO rgu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus leo hatu-leledon faiꞌ telu nai ika bau-inaꞌ a tein daleꞌ. Leoꞌ na boe Au, Ana Lahenda ia. Neuꞌ ko Au leo hatu-leledon faiꞌ telu nai leaꞌ roo-rates. ");
INSERT INTO rgu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nai dae-bafoꞌ a nonoe na, maneniko Manetualain dadi mana ee dedeaꞌ, neuꞌ ko lahenda Niniwe ra dadi sakasii fo neo emi rae, ‘Emi basa ia nana, pakanaaꞌ!’ Maulu na, lahenda Niniwe ra ramanene neuꞌ Manetualain mana nesi matan Yunus, boe ma ara saledale-tuꞌetei nara. Tehuu emi taꞌa. Sekona te, besaꞌ ia Lahenda fo nai emi talada kahereꞌ lena neme Yunus mai, nana riꞌ Au ia. Tehuu emi ta nau tao daleꞌ neuꞌ Au baiꞌ boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nai dae-bafoꞌ a nonoe na, maneniko Manetualain dadi mana ee dedeaꞌ, ina mane Seba neme ona mai, dadi sakasii boe. Ana tudu lima uꞌu na, neo emi basa fo riꞌ masoda nai besaꞌ ia nae, ‘Emi basa ia nana, pakanaaꞌ!’ Maulu na ina maneꞌ ria neme dae dooꞌ mai fo nita mataꞌ mane Soleman malela na. Sekona te, besaꞌ ia Lahenda esa nai emi talada kahereꞌ lena neme Mane Soleman mai, riꞌ Au ia. Tehuu emi ta nau tao daleꞌ neuꞌ Au baiꞌ boeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Maneniko nitu a nanausiꞌ heniꞌ neme lahenda esa mai, nitu ria leo mamana lino-nees neu fo saka mamana hahaeꞌ. Tehuu ana ta hapu mamana matetu-maraaꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Boe ma ana afi nae, ‘Hee! Ta hapu mamanaꞌ fa, de malole lenaꞌ au fali uu leo seluꞌ nai maulu na lahenda ria a.’ Basa de ana fali seluꞌ, te nita mamanaꞌ ria mana kakai makamoiꞌ ma nana ator natalololeꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Boe ma nitu ria neu naloo nonoon hitu fo riꞌ makaresi lena neme ria mai bali. Boe ma basa si reu leo nai lahenda ria, de ara ese-rumu belaꞌ ana. De besaꞌ ia lahenda ria masoda na soe lena. Leoꞌ na boe soa-neuꞌ lahenda tepo-leleꞌ besaꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus bei dedea no lahenda kadodouꞌ ara, boe ma Ria mama Na ma fadi nara mai fo nau raneta ro Ni. Ara rapadei rahaniꞌ uma deaꞌ, de radenu lahenda neu naloo Ni. ");
INSERT INTO rgu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Boe ma lahenda mai nafada nae, “Papa! Papa mama ma, no fadi mara rai deaꞌ. Ara nau raneta ro Papa.” ");
INSERT INTO rgu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus nataa nae, “Au mama boki Ka riꞌ bea? Ma Au toranoo boki kara siꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Boe ma Ana tudu leo lahenda fo ara tuka Ni, ma nafada nae, “Mitaꞌ, basa ia ra nana Au mama ka, ma Au toranoo kara. ");
INSERT INTO rgu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Huu fo lahenda bea tao tuka Au Papa Ka nai nusatetu-ikutemaꞌ a hihii-nanaun, sira nana Au kileoboboki tea kara.” ");
INSERT INTO rgu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Fai ria boe Yesus kalua neme uma ria mai, de neu natuuꞌ nai dano Galilea suu na. ");
INSERT INTO rgu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Boe ma lahenda dodouꞌ mai fela-eo raa Ni. Ana ae leo ofa mananafuꞌ esa nai naa lain neu, de natuuꞌ fo nanori-nafada. Basa lahenda fo rai madaꞌ lain ara ramanene neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ana nanori-nafada si pake dedea nasasamaꞌ dodouꞌ. Ana tui nae, “Lahenda maue-maosa esa neu kari bini-kee nai ria oka-tinen. ");
INSERT INTO rgu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fai fo ana kari bini-kee sira, ruma tuda rai enoꞌ. Boe ma manupuiꞌ ara mai, de seseu rabasa bini-kee sira. ");
INSERT INTO rgu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bini-kee ruma tuda laꞌe dae batu. Bini-kee sira mori lalaiꞌ, nana huu dae a niis a. ");
INSERT INTO rgu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tehuu ledo a nahaa, boe ma nupu nara mamale, de mate si. Huu fo oka nara ta tora losa dae daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bini-kee ruma bali tuda rai matemaꞌ a talada. Boe ma matemaꞌ a amu naisa nupuꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tehuu bini-kee ruma tuda laꞌe dae isiꞌ. Bini-kee sira mori, boe ma rambau-ina losa rabuna-raboa. Ruma reni buna-boaꞌ desi lena laiꞌ telu hulu, ruma desi lena laiꞌ nee hulu, ma ruma desi lena laiꞌ natun esa. ");
INSERT INTO rgu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bea nanuu ridooꞌ, sona nenene natalolole!” ");
INSERT INTO rgu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Boe ma Yesus ana mana tuka dea nara mai ratane Ni rae, “Ubeaꞌ taon, de Papa manori-mafada lahenda kadodouꞌ sira pake nasasamaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus nataa nae, “Huu no emi nau bubuluꞌ matetuꞌ Manetualain pareta Na, de Au afada memaꞌ nasasamaꞌ ria sosoa na. Tehuu maneniko lahenda fekeꞌ, sona Au anori-afada pake noi nasasamaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Huu fo lahenda bea nau saka matetuꞌ Manetualain hihii-nanaun, neuꞌ ko Ana fee ni boe-boe bubuluꞌ bali. Tehuu lahenda fo ta tao daleꞌ neuꞌ Manetualain hihii-nanaun, neuꞌ ko Ana tao naan dadi pakanaaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Au anori-afada si pake nasasamaꞌ, nana huu: ‘Ara rita, tehuu ta nau bubuluꞌ. Ara ramanene, tehuu ta nau ralelaꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sira sama leoꞌ lahenda fo riꞌ Manetualain mana nesi matan Yesaya duiꞌ nae, ‘Neuꞌ ko emi mamanene, tehuu emi ta nau malelaꞌ. Neuꞌ ko emi mita, tehuu emi ta nau bubuluꞌ hata fo dadi so a. ");
INSERT INTO rgu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Huu fo lahenda ia ra dale nara tea-mepeꞌ, sira tao rapake ridoo nara, sira tao rapoke mata nara. De nemeꞌ na ela sira ridoo nara pake si, ma nemeꞌ na ela mata nara poke si. Nemeꞌ na ela Au bosoꞌ puli a si, nana huu ara ta nau tao daleꞌ neuꞌ Au.’ ");
INSERT INTO rgu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tehuu emi, maua-manale! Huu fo emi mata mara rita, ma emi ridoo mara ramanene. ");
INSERT INTO rgu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mamahere Au! Fai a ulu na Manetualain mana nesi mata nara, ma lahenda dale roo-tetuꞌ ara rahiiꞌ rita hata fo riꞌ emi mitan, tehuu ara ta bisa fa. Sira boe rahiiꞌ ramanene hata fo riꞌ emi mamanenen, tehuu ara ta bisa fa.” ");
INSERT INTO rgu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesus dedea basa leoꞌ na, boe ma nafada si nae, “De besaꞌ ia emi nenene nasasamaꞌ ria sosoa-raraan. ");
INSERT INTO rgu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bini-kee fo tuda nai enoꞌ a, nana riꞌ lahenda fo namanene Dedea-nafadaꞌ laꞌe-neuꞌ Manetualain hohomu pareta na, tehuu ana ta nalelaꞌ matetuꞌ. Boe ma nitu ra malaka na mai nalea neni Dedea-nafadaꞌ a neme lahenda ria dale na mai. ");
INSERT INTO rgu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bini-kee fo tuda nai dae batu a, nana riꞌ lahenda fo namanene Manetualain Dedea-nafadan, boe ma ana sipoꞌ no dale namahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tehuu Dedea-nafadaꞌ ria ta naoka-nasamu. Huu ria na, de ta nanapedaꞌ nalaꞌ dooꞌ a nai lahenda dale na. Leoꞌ na boe lahenda fekeꞌ a tao nasususaꞌ nana huu ana sipo Dedea-nafadaꞌ ria, ana tuꞌu-tapa heni si tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma bini-kee fo tuda nai matemaꞌ a talada a, sama leoꞌ lahenda fo namanene Dedea-nafadaꞌ ria. Tehuu ana nasapute no urusan rupaꞌ ara, fo bisa nasoda lole-napuꞌ. Boe ma urusan sira, seti heni Dedea-nafada ria neme dale na mai, losaꞌ ta nanuu sosoa-raraaꞌ soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tehuu bini-kee fo tuda nai dae isiꞌ a, sama leoꞌ lahenda fo pasaꞌ ridoo na ela sipoꞌ Dedea-nafadaꞌ ria, ma tuka Manetualain hihii-nanaun. Boe ma ana tao noi hihii-nanauꞌ malole ra, sama leoꞌ bini-kee mabuna-maboaꞌ ria. Ruma rabuna-raboa desi lena laiꞌ telu hulu, ruma desi lena laiꞌ nee hulu, ma ruma desi lena laiꞌ natun esa.” ");
INSERT INTO rgu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nafada seluꞌ nasasamaꞌ esa nae, “Manetualain hohomu pareta na, sama leoꞌ lahenda fo sele-kari bini-kee malole nai ria oka-tinen. ");
INSERT INTO rgu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nahatu de basa lahenda ra suku ramanee, boe ma lahenda tadaluꞌ a mai, de sele-kari fii nupuꞌ nai okaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Fai fo okaꞌ ria mulai neni buna-boaꞌ, boe ma ata ra rita fii a mori rai naa sama-sama ro hade gandum. ");
INSERT INTO rgu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Boe ma ara reu rafada manuu okaꞌ a rae, ‘Papa! Faiꞌ naa ra ami sele-kari bini-kee malole nai papa oka-tinem, hete? Ubeaꞌ taon, de besaꞌ ia hapu fii dodouꞌ so?’ ");
INSERT INTO rgu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Malaka ria nataa nae, ‘Ria nana, lahenda tadaluꞌ a nonoi-tataon.’ Boe ma lahenda mana noi ra rafadan rae, ‘Papa, ami meu faꞌu heni fii sira, do?’ ");
INSERT INTO rgu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tehuu ana nataa nae, ‘Bosoꞌ! Huu fo emi faꞌu fii ra, te neuꞌ ko faꞌu meni no hade gandum ara boe. ");
INSERT INTO rgu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nemeꞌ na ela ara mori sama-sama losa ledo-fai eetu-ooruꞌ. Neuꞌ ko fai ria, besaꞌ ko au afada lahenda manaoru ra ae, “Emi mabubua ma fii sira dei. Boe ma puputu mabua si, fo hotu henis. Basa sona besaꞌ ko mabubua ma buna-boa malole ra, fo madai si reuꞌ mamana pepeda-fufuaꞌ daleꞌ.”’ ” ");
INSERT INTO rgu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Boe ma Yesus dedea bali nae, “Au tamba seluꞌ nasasamaꞌ esa bali, ela emi bisa bubuluꞌ mae Manetualain dadi Mane soa-neuꞌ lahenda dodouꞌ. Ria lahenda nara, mulai masososa na bai anaꞌ, sama leoꞌ ai deke lutu anaꞌ fo riꞌ lahenda selen nai oka-tine. ");
INSERT INTO rgu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Leo mae ai dekeꞌ ria, lutu anaꞌ a naan seli, tehuu maneniko ana nambau-ina mai, sona dadi neuꞌ ai huu bau-inaꞌ nai oka-tine. Losaꞌ manupuiꞌ ara mai rarunu rai ria doo ranan.” ");
INSERT INTO rgu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus tamba seluꞌ nasasamaꞌ esa nae, “Manetualain lahenda nara, sama leoꞌ ralu teteiꞌ fo riꞌ inaꞌ esa ame nabuan noo uuꞌ saku esa. Boe ma roti a aifuu losaꞌ bauꞌ basa, nana huu ralu tetei kabai anaꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus nanori-nafada lahenda dodouꞌ pake tutuiꞌ rupaꞌ dodouꞌ leo naꞌ. Ana nanori-nafada lahenda dodouꞌ pake nasasamaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ana nanori-nafada leoꞌ na tuka hata fo Manetualain mana nesi mata na duiꞌ memaꞌ nae, “Neuꞌ ko Au anori-afada pake nasasamaꞌ. Neuꞌ ko Au afada hihii-nanauꞌ fo lahenda bei ta parnaa ramanenen, mulai neme Manetualain adu dae-bafoꞌ a losaꞌ besaꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus laꞌo ela lahenda kadodouꞌ sira, de fali leo uma neu. Boe ma ana mana tuka dea nara mai hule Ni rae, “Papa! Mafada fee ami nasasamaꞌ laꞌe-neuꞌ fii a sosoa-raraan dei!” ");
INSERT INTO rgu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus nataa nae, “Lahenda fo sele-kari bini-kee malole a, nana Au, Ana Lahenda ia. ");
INSERT INTO rgu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma oka-tine a, nana riꞌ dae-bafoꞌ ia. Bini-kee malole a, nana riꞌ lahenda fo dadi reuꞌ Manetualain lahendan. Ma fii a, nana riꞌ nitu ra malaka na lahenda nara. ");
INSERT INTO rgu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Boe ma lahenda tadaluꞌ fo riꞌ mai sele-kari fii nupuꞌ a, nana riꞌ nitu ra malaka bau-ina na. Ma ledo-fai eetu-ooruꞌ a, nana riꞌ dae-bafoꞌ a nonoe na. Lahenda manaetu-manaoru buna-boaꞌ a, nana siꞌ Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tepoꞌ fo dae-bafoꞌ a nonoe na, ara rabubua ra fii sira ela hotu henis. ");
INSERT INTO rgu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Au, Ana Lahenda ia, neuꞌ ko fee eilaꞌo-limalope reme nusatetu-ikutemaꞌ a mai. Neuꞌ ko ara reu rabubua ra lahenda fo ta tuka Manetualain pareta Na. Ma sira boe rabubua ra basa lahenda fo duduku-papauꞌ lahenda fekeꞌ, ela bosoꞌ tuka Manetualain pareta Na. ");
INSERT INTO rgu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Neuꞌ ko ara tuꞌu heni lahenda tadaluꞌ sira basa si leo ai-pila naraka a reu, sama leoꞌ hotu heni fii ra. Nai naa, besaꞌ ko ara doidoso raan seli, ma dola-ramatani losa dodoo na. ");
INSERT INTO rgu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tehuu lahenda bea nasoda roo-tetuꞌ tuka Manetualain hihii-nanaun, neuꞌ ko ara leo rahere roo sira Papa Mane na nai nusatetu-ikutemaꞌ a. Nai naa, ara rahaa-rakaledo sama leoꞌ ledo a. Lahenda bea nau bubuluꞌ neu Au, pasaꞌ natalolole ridoo na!” ");
INSERT INTO rgu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus tamba seluꞌ nasasamaꞌ esa bali nae, “Lahenda fo nau bubuluꞌ Manetualain hohomu pareta na, sama leoꞌ lahenda fo nahiiꞌ hapu hata mabeli beraꞌ, lahenda parnaa nafunin nai dae bibia anaꞌ esa daleꞌ. Lahenda ria mai ali, boe ma ana hapu hata ria nai naa, huu ria na de namahoꞌo naan seli. Boe ma ana nadofu faliꞌ hata ria. Basa de ana nalale fali neun fo seꞌo heni ria hata-heton katemaꞌ. Boe ma ana neu asa na dae ria, fo ela ana bisa nanuu memaꞌ hata mabeli ria.” ");
INSERT INTO rgu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus tamba selu nae, “Lahenda fo nau bubuluꞌ Manetualain hohomu pareta na, sama leoꞌ lahenda papalele esa nahiiꞌ hapu mutiara mabeli beraꞌ. Boe ma ana saka mutiara fo nau asa. ");
INSERT INTO rgu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Fai fo ana nita mutiara malole inaꞌ esa, boe ma ana nalale fali neun fo seꞌo heni ria hata-heton katemaꞌ. Basa de ana neu asa na mutiara ria, fo ela ana bisa nanuu ni.” ");
INSERT INTO rgu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus tamba bali nae, “Manetualain hohomu pareta Na, sama leoꞌ manadolu-manadala ra poꞌi pukaꞌ esa nai dano a. Pukaꞌ ria nala ika rupaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ikaꞌ henu pukaꞌ a, boe ma manadolu-manadala ra mai hela reni pukaꞌ ria leo dano a suu na neu. Boe ma ara ratuuꞌ de rahii ikaꞌ neme pukaꞌ a mai. Ika malole, sona ara peda si reuꞌ sosoroꞌ daleꞌ. Tehuu ikaꞌ fo ta malole, ara tuꞌu henis. ");
INSERT INTO rgu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Leoꞌ na boe dae-bafoꞌ a nonoe na. Neuꞌ ko Manetualain eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai, fo reu heo heni lahenda tadaluꞌ ara reme lahenda dale roo-tetuꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Neuꞌ ko ara tuꞌu heni lahenda tadaluꞌ sira basa leo ai-pila naraka a reu. Nai naa, besaꞌ ko ara doidoso raan seli, ma dola-ramatani losa dodoo na.” ");
INSERT INTO rgu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus dedea basa nae leoꞌ na, boe ma natane si nae, “Emi malelaꞌ basa-basan fo riꞌ bisinaaꞌ a Au dedea a, do?” Ara rataa rae, “Malelaꞌ, Ramatuaꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus nataa natafaliꞌ asa nae, “Malole! Huu fo mesen agama fo homu nahere Musa atoran fo riꞌ manaduiꞌ memaꞌ neme fai a ulu na mai, ma ana homu nahere Au nanori-nafada besaꞌ ia ka, sona ria sama leoꞌ manuu umaꞌ esa nahiiꞌ soi mamana pepeda-fufuan, ela natudu ria hata-heto paraa nara, ma hata-heto bebeu nara.” ");
INSERT INTO rgu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus nanori-nafada lahenda kadodouꞌ ara pake nasasamaꞌ, basa boe ma Ana laꞌo ela mamanaꞌ ria, ");
INSERT INTO rgu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","de fali leo Ria koro Na neu. Nai naa, Ana leo uma mamasoꞌ daleꞌ neu fo nanori-nafada lahenda ra. Basa lahenda fo ramanene Ni, ara heran raan seli. Ara bei dea rae, “Awii! Lahenda ia malela na seli! Ana nanori nai bea ia? Tao leoꞌ bea, de Ana bisa tao tanda heran sira? ");
INSERT INTO rgu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sekona te Ria nana noi tukan ai anan. Ita talelaꞌ Ria maman, Maria; ma Ria fadi nara, siꞌ Yakobis, Yusuf, Yudas ma Simon. ");
INSERT INTO rgu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ita boe talelaꞌ Ria feto nara, huu fo ita basa leo nai koroꞌ esa! De Ana hapu malelan ria, neme beaꞌ mai bali? Ma Ana hapu kuasa kaheren ria, neme beaꞌ mai bali?” ");
INSERT INTO rgu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huu ria na, de bolii nara puruꞌ, losaꞌ ara ta nau ramanene Ni soꞌ. Tehuu Yesus nafada nae, “Tebe! Nai mamana fekeꞌ, lahenda rahiiꞌ fee hada-horomata neuꞌ Manetualain mana nesi matan. Tehuu nai ria koro-tadun ma uma isi nara, lahenda ta nau fee hada-horomata neuꞌ ana.” ");
INSERT INTO rgu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huu no sira dale kamahere taa nara, de Yesus ta tao tanda heran dodouꞌ nai naa. ");
INSERT INTO rgu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tepoꞌ ria, mane Herodes pareta nai propinsi Galilea. Ana namanene tutuiꞌ rupaꞌ laꞌe-neuꞌ Yesus boe. ");
INSERT INTO rgu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ana nafada pegawe nara nae, “Yesus nana, tantu Yohanis Mana Saraniꞌ fo riꞌ fai naa ra au adenu tete reni laka na. Besaꞌ ia ana nasoda seluꞌ so! Huu ria na, de ana nanuu kuasa fo tao tanda heran sira.” ");
INSERT INTO rgu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mane Herodes a dedea nae leoꞌ na, huu fo maulu na ana nadedea noo Yohanis, losaꞌ ana hopu na Yohanis de teen leo bui daleꞌ neu. Dedeaꞌ ria tutui na leo iaꞌ: mane Herodes, sao na fadin Filipus sao na, nade Herodias. Sekona te Filipus noo Herodias bei ta ramaetuꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Huu ria na, de Yohanis nasaꞌai nasarerein nae, “Papa maneꞌ ta bole sao fadi ma sao na. Huu fo ria nalena laka neuꞌ ita hadas Yahudi na!” ");
INSERT INTO rgu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tehuu Herodes ta nau tao daleꞌ neuꞌ ana, de ana sao na Herodias. Tuka matetu na, Herodes nahiiꞌ naisa Yohanis Mana Saraniꞌ. Tehuu ana lele lahenda kadodouꞌ ara, huu fo ara ramahere rae, Yohanis nana Manetualain mana nesi matan. Huu ria na, de ana nadenu lahenda nara, fo tee Yohanis leo bui daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tehuu nara laꞌe Herodes fai boboki na, boe ma ana tao feta. Faiꞌ ria, ina maneꞌ Herodias ana feto na roke nasare na fui ra. Ria roroke na malole a, losaꞌ tao na Herodes namahoꞌo naan seli. ");
INSERT INTO rgu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Roke basa, boe ma Herodes naloo na ana fetoꞌ ria de nae, “O nau hule ubeaꞌ neme au mai, sona mafada leo! Huu fo neuꞌ ko au fee neuꞌ o. Tebe-tebe au homu ahere hehelu ki ia. Ma au soo-supa pake Manetualain nade Na.” ");
INSERT INTO rgu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ana feto anaꞌ a mama na namanene maneꞌ a dedea nae leoꞌ na, boe ma ana duduku-papauꞌ ana feto na. Huu ria na, de ana hule nae, “Papa! Au hule Yohanis Mana Saraniꞌ a laka na. Tao ni neuꞌ dulang, menin leo iaꞌ mai, fee au.” ");
INSERT INTO rgu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mane Herodes a namanene ana fetoꞌ a hule leo naꞌ, boe ma dale na susa. Tehuu ana ta bisa hela faliꞌ ria sosoo-susupan, nana huu basa fui ra ramanene basa so. Huu ria na, de ana tuka ana fetoꞌ ria hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Boe ma ana pareta fo lahenda reu tete ra Yohanis laka na nai bui daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ara tete ra Yohanis laka na, boe ma tao ni neuꞌ dulang esa daleꞌ, de renin leo ana fetoꞌ a neu. Ana sipo na dulang ria, boe ma oꞌo nenin de feen leo mama na neu. ");
INSERT INTO rgu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohanis ana mana tuka dea nara ramanene ara tete reni laka na, boe ma ara mai rala popora na, fo reu ratoin. Basa de ara reu tui mana dadiꞌ ria neuꞌ Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus namanene tutuiꞌ laꞌe-neuꞌ Yohanis, boe ma no ana mana tuka dea nara nau heoꞌ reme mamanaꞌ ria mai. Basa de ara saꞌe ofaꞌ fo sakaꞌ leo mamana lino-nees reu, ela bisa hahae ao nara. Tehuu lahenda dodouꞌ rita Yesus asa ofa na tuka-tuka dano a suu na. Boe ma ara kalua reme koroꞌ ara mai, de ara laꞌo ralaiꞌ a tuka madaꞌ lain. Huu ria na, de ara leo mamanaꞌ ria reu a, losa rauluꞌ Yesus asa. ");
INSERT INTO rgu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Fai fo Ana onda neme ofaꞌ lain mai, boe ma Ana nita lahenda dodouꞌ rahani Ni. Boe ma Ana kasian neuꞌ asa, de Ana puli na sira lahenda kamahedis nara. ");
INSERT INTO rgu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ledo leo daeꞌ, boe ma Ria ana mana tuka dea nara mai rafada Ni rae, “Papa, ee! Malole lenaꞌ Papa madenu lahenda ia ra basa si reu asa nanaaꞌ nai koro maneneaꞌ ia ra. Huu fo ledo a sakaꞌ tena riaꞌ so! Nai ia nanaaꞌ taꞌa.” ");
INSERT INTO rgu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesus nataa nae, “Bosoꞌ! Emi riꞌ mahao si.” ");
INSERT INTO rgu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tehuu ara rataa rae, “Awi, Papa, ee! Ami ta manuu hata-hata esa boeꞌ, fo mahao lahenda makadotoꞌ ia ra. Ami tao leo beaꞌ? Huu fo hapu noi roti lima, ma ikaꞌ boaꞌ dua!” ");
INSERT INTO rgu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tehuu Yesus dedea nae, “Neu! Ria malole a so. Meni si mai leo!” ");
INSERT INTO rgu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Boe ma Ana nadenu lahenda sira fo ratuu rabubua reuꞌ nau lain. Yesus hai na roti kalimaꞌ sira, ma ikaꞌ boa kaduaꞌ ara. Boe ma Ana nasare leo lalai neu fo hule makasi neuꞌ Manetualain. Basa de Ana tetebi roti sira, de loo si leo ana mana tuka dea nara reu, fo ara reu babati fee basa lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Basa si raa losaꞌ rabete. Raa basa, boe ma ara reu rabubua ra nanaa lenaꞌ ara, losaꞌ henu lapaneu rupia sanahulu dua. ");
INSERT INTO rgu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lahenda mananaa ra, nana bate touꞌ rifun lima. Bei ta rekeꞌ inaꞌ ara roo ana nara. ");
INSERT INTO rgu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ara raa basa, boe ma Yesus nadenu ana mana tuka dea nara saꞌe ofaꞌ fo rauluꞌ leo dano a seriꞌ reu. Tehuu Ana bei nahaniꞌ naa, ela nadenu lahenda makadotoꞌ sira fali reus. ");
INSERT INTO rgu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Basa si fali, boe ma Yesus ae leo leteꞌ esa lain neu, fo hule-haradoi. Nahatu so boe, Ria mesaꞌ ana bei nai naa. ");
INSERT INTO rgu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ria ana mana tuka dea nara ofa na losa nai dano a talada so. Tehuu ara sefe sota raan seli, nana huu ani tatadaꞌ, ma nafa lolis ara. ");
INSERT INTO rgu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lole maluaꞌ, boe ma Yesus neu tuka si. Tehuu Ana laꞌo nai oe lain. ");
INSERT INTO rgu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ana mana tuka dea nara rita leoꞌ na, boe ma ara kekes ara. Ara dedea no bibiiꞌ rae, “Ae! Mitaꞌ sumane lahenda mana mateꞌ a rii naꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tehuu Yesus dedea mataꞌ no si nae, “Ae! Emi bosoꞌ bii! Huu fo Au ia, Yesus!” ");
INSERT INTO rgu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus namanene leoꞌ na, boe ma ana nataa nae, “Tete-tebe o nana Ramatuaꞌ, sona madenu fo au laꞌo usiꞌ oe lain leo Ramatuaꞌ a uu.” ");
INSERT INTO rgu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus nataa nae, “Neu! Mai leo!” Boe ma Petrus kalua neme ofaꞌ a mai de ana laꞌo nai oe lain leo Yesus neu. ");
INSERT INTO rgu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tehuu Petrus nameda naan ani a nasaꞌ, de ana bii naan seli. Ana mulai bolo, boe ma naloo nae, “Adoo, Ramatuaꞌ, ee! Mai tulu-fali ma au dei!” ");
INSERT INTO rgu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus nalale looꞌ lima Na neu, de lobeꞌ naan. Ana dedea nae, “Ae, Petrus, ee! Ubeaꞌ taon, de dale ma kadudua? O ta mamahere matetuꞌ Au fa, do?” ");
INSERT INTO rgu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dua si ae leo ofaꞌ lain reu, boe ma ani a namate tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ria ana mana tuka dea nara rita leoꞌ na, boe ma ara io Ni rae, “Awii! Papa ia, nana tetebes ara Manetualain Anan, oo!” ");
INSERT INTO rgu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesus asa losa dano a seriꞌ, boe ma ara see reuꞌ koro Genesaret a namo sesee na. ");
INSERT INTO rgu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ara bei onda, te lahenda dodouꞌ ralelaꞌ tutiꞌ asa. Boe ma ara mulai bobouꞌ rae, “Ae! Yesus mai so!” Ara ralai reu rafada rule-feo nusaꞌ ria, de lahenda ra roo basa lahenda kamahedis ara mai. ");
INSERT INTO rgu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ara hule fo bisa rafaroe laꞌe Ria badu Na. Huu fo ara afi rae, “Sadi lahenda kamahedis ara rafaroe laꞌe Yesus badu peda Na boe, tantu ara teꞌe tutiꞌ a.” De basa lahenda kamahedis fo riꞌ rafaroe laꞌe Ria badu Na, ara teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Faiꞌ esa, boe ma lahenda Farisi ma mesen agama bubuaꞌ esa reme Yerusalem mai raneta ro Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Lahenda Farisi ra homu rahere hadas Yahudi nara. Ara ramanene rae, Yesus ana mana tuka dea nara raa-rinu ta tao tuka hadas sasafe limaꞌ a fa, de eteꞌ ao nara. Ara mai sale Yesus rae, “Ubeaꞌ taon, de O ana mana tuka dea mara raa-rinu, tehuu ta tao tuka hadas sasafe limaꞌ a fa? Ria nana ralena laka neuꞌ ita hadas bei-baꞌin!” ");
INSERT INTO rgu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tehuu Yesus nataa si nae, “Emi nana, tebe lahenda fo riꞌ dedea fekeꞌ ma tao fekeꞌ! Emi malena laka malelaꞌ Manetualain pareta Na, fo tuka noi bei-baꞌi mara hadas na. ");
INSERT INTO rgu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Huu fo Manetualain pareta nae, ‘Fee hada-horomata neuꞌ ina-ama mara,’ Ma tamba bali nae, ‘Maneniko lahenda esa doꞌi ina-aman, muste huku mateꞌ ana.’ ");
INSERT INTO rgu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Manetualain nanori-nafada leo naꞌ, tehuu emi manori-mafada fekeꞌ bali. Huu fo emi mae, ‘Maneniko lahenda esa helu sakaꞌ fee hata-heton leo Manetualain neu, sona leo mae ina-aman doidoso raan seli boe oo, ana ta tulu-fali si pake ria hata-heton sira.’ Tehuu no emi manori-mafada leo naꞌ, emi tuꞌu-tapa heni Manetualain pareta Na, fo kati meniꞌ emi atoran mara. ");
INSERT INTO rgu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Huu ria na, de bisinaaꞌ a Au afada ae, emi nana, lahenda fo dedea fekeꞌ ma tao fekeꞌ! Ria naraa no hata fo Manetualain mana nesi matan Yesaya duiꞌ memaꞌ neme uluꞌ mai laꞌe-neuꞌ emi! Huu fo Manetualain pake ni fo duiꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Lahenda io-oa Au, noi nai bafadoo peda na, tehuu daleꞌ taꞌa. ");
INSERT INTO rgu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Leo mae ara tao leo naꞌ boe oo, mana dadi taaꞌ. Ara ta tao daleꞌ neuꞌ Au, huu fo ara tao daleꞌ noi neuꞌ lahenda dae-bafoꞌ a atoran na.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Boe ma Yesus naloo na lahenda fekeꞌ rai naa, de nanori-nafada si nae, “Pasaꞌ matalolole ridoo mara, ela emi bisa bubuluꞌ! ");
INSERT INTO rgu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hata fo masoꞌ leo lahenda bafan daleꞌ neu, ria ta tao nakekeo-nakakanu lahenda. Tehuu hata fo kalua neme lahenda bafan daleꞌ mai, ria riꞌ tao nakekeo-nakakanu.” ");
INSERT INTO rgu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesus ana mana tuka dea nara mai de rafada Ni rae, “Papa bubuluꞌ, do? Lahenda Farisi ra dale nara hanas a, nana huu ramanene Papa dedea-nafadam ria.” ");
INSERT INTO rgu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tehuu Yesus nataa nae, “Au Papa Ka nai nusatetu-ikutemaꞌ a neuꞌ ko tuꞌu-tapa heni lahenda fo ta nanori-nafada tuka Ria hihii-nanaun. Ria sama leoꞌ lahenda feꞌa heni parusa fo riꞌ ana ta selen fa. ");
INSERT INTO rgu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","De, bosoꞌ tao daleꞌ neuꞌ lahenda Farisi ra! Huu fo sira sama leoꞌ lahenda pokeꞌ natudu lahenda pokeꞌ a enoꞌ. Neuꞌ ko ara rame-rame tuda rala boloꞌ daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Boe ma Petrus dedea nae, “Papa, mafada fee ami nasasama bisinaaꞌ a sosoa-raraan dei!” ");
INSERT INTO rgu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus nataa nae, “Emi bei ta bubuluꞌ boeꞌ? ");
INSERT INTO rgu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sosoa-raraan leo iaꞌ: Hata fo ita taa-tinun, masoꞌ nesiꞌ bafaꞌ ara, naroo leo teiꞌ ara daleꞌ neu, boe ma kalua leo kakus daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tehuu hata fo kalua neme bafaꞌ ara mai, ria riꞌ tao nakekeo-nakakanu lahenda, losaꞌ Manetualain boe nahiaꞌ ana, ma ta nau sipoꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Huu fo hata tadaluꞌ dodouꞌ riꞌ kalua neme lahenda dale na mai! Sama leoꞌ: duꞌa-afi tadaluꞌ, naisa lahenda, hohoke, namanaꞌo, sakasii pepekoꞌ, ma dedea namumulu lahenda. ");
INSERT INTO rgu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hihii-nanauꞌ leo naꞌ ara, siꞌ tao rakekeo-rakakanu lahenda. Tehuu kalu noi riꞌ lahenda naa-ninu ma ta tao tuka hadas sasafe limaꞌ a, ria salaꞌ taꞌa.” ");
INSERT INTO rgu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Boe ma Yesus foa ela mamanaꞌ ria, de leo nusaꞌ fo riꞌ naneneaꞌ no kota Tirus ma kota Sidon. ");
INSERT INTO rgu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Inaꞌ esa nai naa, neme nusaꞌ ria mai. Ria ta lahenda Yahudi fa. Faiꞌ fo namanene Yesus nai naa, boe ma ana mai hule teteaꞌ nae, “Mane Daud tititi-nonosin, ee! Kasian neuꞌ au dei! Huu fo au ana feto ka nitu ra heke raan, kasian, ana doidoso naan seli so.” ");
INSERT INTO rgu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tehuu Yesus neneeꞌ, ma ta nataa hata-hata esa boeꞌ. Boe ma ana mana tuka dea nara mai rafada Ni rae, “Papa, inaꞌ ia bou-bou tao tasibuꞌ. Malole lenaꞌ Papa mafadan fo naheoꞌ neme iaꞌ mai!” ");
INSERT INTO rgu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus nataa si nae, “Manetualain nadenu Au mai fo tulu-fali ita lahenda Yahudi nara, nana huu ara laꞌo sala, sama leoꞌ bibi-lopo manasala-manamopoꞌ. Ana ta nadenu Au uu tulu-fali lahenda fekeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tehuu inaꞌ ria naneneaꞌ leo Yesus mai. Ana sundaꞌ undulaka na, ma hule tutulu-fafaliꞌ nae, “Ramatuaꞌ! Tulu-fali au dei.” ");
INSERT INTO rgu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tehuu Yesus tuꞌu dedeaꞌ nae, “Ta naraa hai anaꞌ ara nanaa-nininun, fo tuꞌu fee busa ra.” Sosoa-raraan nanafuniꞌ nae, Yesus muste tulu-fali Ria lahenda Yahudi nara dei, besaꞌ ko bisa tulu-fali lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tehuu inaꞌ ria balas nae, “Tebe, Papa! Tehuu busa ra rahani nai mei a fiki dale na. Sira boe raa hata fo riꞌ tuda nemeꞌ anaꞌ ara bika nara mai.” Sosoa-raraan nae, faiꞌ fo anaꞌ ara raa, busa a boe naa. Leo mae Yesus tulu-fali Ria lahenda nara, tehuu Ria boe muste relu-natanae lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus namanene leoꞌ na, boe ma nafada nae, “Awii! Mama namahere tebe-tebe neuꞌ Au, oo! De mama fali leo, te hata fo mama hule a, dadi memaꞌ so!” Boe ma ana fali, te nita ana na teꞌe na aon so. ");
INSERT INTO rgu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Basa de Yesus no ana mana tuka dea nara foa ela mamanaꞌ ria, ara laꞌo tuka dano Galilea suu na. Ara ae leo leteꞌ esa lain reu, de Yesus natuuꞌ fo nanori-nafada si. ");
INSERT INTO rgu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Boe ma lahenda dodouꞌ leo Ria mai. Ara roo lahenda ei helaꞌ, lahenda pokeꞌ, lahenda lukuꞌ, lahenda pakanaaꞌ, ma lahenda kamahedis fekeꞌ boe. Ara raneneaꞌ lahenda kamahedis sira reuꞌ Yesus ei Na. Boe ma Ana puli naa si. ");
INSERT INTO rgu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lahenda makadotoꞌ sira rita leoꞌ na, boe ma ara heran. Ara bei dea rae, “Ae! Kahereꞌ naan seli, oo! Lahenda ei helaꞌ, bisa laꞌo natetu. Lahenda pokeꞌ bisa nita-dae. Lahenda lukuꞌ bisa laꞌo. Ma lahenda pakanaaꞌ bisa dedea so! Tantu Manetualain riꞌ nonoi-tataon ia. Ria nana, Ramatuaꞌ fo riꞌ neme fai a ulu na mai, ita bei-baꞌin doꞌo-tabe Ni a.” ");
INSERT INTO rgu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Basa faiꞌ hida, boe ma Yesus naloo na ana mana tuka dea nara de nae, “Au kasian neuꞌ basa lahenda makadotoꞌ ia ra. Ruma reme dae dooꞌ mai, nate ara rabua faiꞌ telu ian, de nanaaꞌ taꞌa so. Malole lenaꞌ ara bosoꞌ fali no tei rouꞌ. Bosoꞌ losa ara saparao rai eno taladaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tehuu Yesus ana mana tuka dea nara rataa rae, “Papa! Ia nana mamana lino-nees, dooꞌ a neme koroꞌ a mai. Mae tao lee oo, ita ta bisa tahao lahenda makadotoꞌ ia ra fa.” ");
INSERT INTO rgu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tehuu Yesus natane si nae, “Emi manuu roti hida?” Ara rataa rae, “Hituꞌ a! Ma ikaꞌ baiꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Boe ma Yesus nadenu lahenda sira basa si fo ratuuꞌ reuꞌ dae a. ");
INSERT INTO rgu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ana hai na roti kahituꞌ ara ma ikaꞌ sira, boe ma Ana hule makasi neuꞌ Manetualain. Boe ma Ana tetebi si, de fees reuꞌ ana mana tuka dea nara, fo ara babati fee basa lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ara raa losaꞌ rabete. Basa de rabubua ra nanaa lenaꞌ ara henu lapaneu hitu. ");
INSERT INTO rgu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lahenda fo raa a, basa si bate touꞌ rifun haa. Bei ta rekeꞌ inaꞌ ma anaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basa de Yesus nadenu lahenda makadotoꞌ sira fali. Boe ma Ana saꞌe ofaꞌ fo ara leo nusa Magadan reu. ");
INSERT INTO rgu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Laiꞌ esa de, lahenda Farisi ma lahenda Saduki hida leo Yesus mai. Ara nau ratatane aoꞌ ro Ni, fo ela rahihiiꞌ Ana. Huu ria na, ara hule Ni rae, “Papa! Matudu tanda heran dei, fo dadi buti nae, Papa hapu kuasa neme Manetualain mai.” ");
INSERT INTO rgu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tehuu Yesus nataa nae, “Maneniko ledo a tena ma lalai haramea, sona emi mae, ‘Balahaꞌ te ta uda fa.’ ");
INSERT INTO rgu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma kalu ledo a tii ma oa keoinaꞌ a, emi mae, ‘Fai ia sakaꞌ uda.’ De maneniko emi bisa tanda malelaꞌ oa-ani leoꞌ na, ubeaꞌ taon de emi ta bisa tanda malelaꞌ hata fo Ramatuaꞌ a tao nai basa tepo-leleꞌ ia ra? ");
INSERT INTO rgu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Emi lahenda besaꞌ ia malelaꞌ noi tatao tadaluꞌ a! Emi ta tao daleꞌ neuꞌ Manetualain! Leo mae emi hule tanda heran, tehuu Au ta fee fa. Huu fo maulu na Manetualain fee tanda heran, pake Ria mana nesi matan Yunus. De ria dai so!” Yesus dedea basa nae leoꞌ na, boe ma Ana foa ela si. ");
INSERT INTO rgu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Faiꞌ fo Yesus asa losa dano a talada, besa ko ana mana tuka dea nara rafarene rae, ara rafarene henin de ta reni roti ela tao tua-lepa. ");
INSERT INTO rgu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ana namanene si rae leoꞌ na, boe ma Ana nafada nae, “Emi muste besa-besa moo lahenda Farisi ma lahenda Saduki ra ralu tetei na.” ");
INSERT INTO rgu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ana mana tuka dea nara ramanene leoꞌ na, boe ma roi ramakokoaꞌ a. Ara dedearao nara rae, “Tou lasiꞌ a dedea nae ubeaꞌ ria? Bate Ana dedea nae leoꞌ na, nana huu ita ta teni roti fa, do?” ");
INSERT INTO rgu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tehuu Yesus bubuluꞌ sira duduꞌa-aafin. Boe ma Ana dedea nae, “Ae! Emi talalu maan seli so! Ubeaꞌ taon, de emi dedea laꞌe-neuꞌ roti! Emi ta mamahere Au fa, do? ");
INSERT INTO rgu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Emi bei ta bubuluꞌ Au kuasa Ka, do? Faiꞌ naa ra, Au tetebi roti bibiaꞌ kalimaꞌ sira fo fee lahenda rifun lima raa a, emi mabubua ma lena nara lapaneu rupia hida? ");
INSERT INTO rgu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Boe ma roti kahituꞌ fo riꞌ Au bati fee lahenda rifun haa a, leo beaꞌ bali? Emi mabubua ma lena nara lapaneu hida? ");
INSERT INTO rgu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ubeaꞌ taon, de emi ta bubuluꞌ bisinaaꞌ a Au dedea Ka? Au ta dedea laꞌe-neuꞌ roti. Au nau afarereneꞌ fee emi, fo ela emi besa-besa moo lahenda Farisi ma lahenda Saduki ra nanori-nafadan. Huu fo sira nanori-nafadan, bisa fufudi-leleꞌo ra lahenda dodouꞌ, sama leoꞌ ralu teteiꞌ a tao na roti a aifuu.” ");
INSERT INTO rgu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus dedea nae leoꞌ na, besaꞌ ko ara bubuluꞌ rae, Ana ta dedea laꞌe-neuꞌ roti. Tehuu Ana dedea laꞌe-neuꞌ lahenda Farisi ma lahenda Saduki ra nanori-nafada masala na. ");
INSERT INTO rgu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Basa boe ma Yesus asa leo nusaꞌ fo naneneaꞌ no kota Kaisarea Filipi. Nai eno taladaꞌ, Ana natane si nae, “Tuka lahenda ra dedean, ara rae, Au fo Ana Lahenda ia nana bea?” ");
INSERT INTO rgu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ara rataa rae, “Ruma rae Papa nana, Yohanis Mana Saraniꞌ a nasoda seluꞌ. Fekeꞌ ara rae, Papa nana baꞌi Elia. Fekeꞌ ara bali rae, baꞌi Yeremia. Taꞌa sona Manetualain mana nesi mata fai ulu feke Na.” ");
INSERT INTO rgu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus natane si bali nae, “Tuka emi, sona Au ia nana bea?” ");
INSERT INTO rgu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Boe ma Simon Petrus nataa nae, “Papa nana Kristus, Lahenda fo riꞌ fai a ulu na Manetualain helu nau feen mai a! Ma Papa nana, Anaꞌ neme Manetualain fo riꞌ nasoda naroo a!” ");
INSERT INTO rgu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Boe ma Yesus nae, “Simon, Yunus anan! O maua-manale! Huu fo ta lahenda dae-bafoꞌ a riꞌ nafada o hal-hal ia. Tehuu Au Papa Ka nai nusatetu-ikutemaꞌ a riꞌ nafada. ");
INSERT INTO rgu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nenene, ee! Besaꞌ ia Au nau fee o nade ‘Petrus’. Nadeꞌ ria sosoa na nae, ‘batu’. Nana huu o namahere ma teaꞌ a leoꞌ batu, neuꞌ ko o dadi fanderen soa-neuꞌ Au lahenda kamahere kara. Leo mae ara hapu eese-rurumuꞌ losaꞌ mate boe oo, ara ranenete raroo. ");
INSERT INTO rgu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Neuꞌ ko Au fee o haak, fo urus Au lahenda kara, sama leoꞌ o homu nusatetu-ikutema a koe na. Hata ubeaꞌ fo emi ta fee lelaꞌ neuꞌ ana nai dae-bafoꞌ ia, Manetualain boe ta fee lelaꞌ neuꞌ ana nai nusatetu-ikutemaꞌ a. Ma hata ubeaꞌ fo emi fee lelaꞌ neuꞌ ana nai dae-bafoꞌ ia, Manetualain boe fee lelaꞌ neuꞌ ana nai nusatetu-ikutemaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesus dedea basa nae leoꞌ na, boe ma Ana padaꞌ asa fo bosoꞌ rafada esa boe, rae Ria nana Kristus. ");
INSERT INTO rgu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mulai neme faiꞌ ria mai, boe ma Yesus nafada ana mana tuka dea nara nae, “Au muste leo kota Yerusalem uu. Tehuu nai naa neuꞌ ko Au hapu doidoso dodouꞌ neme lasiꞌ ara, malaka agama Yahudi malaka nara, ma basa mesen agama ra. Neuꞌ ko ara raisa Au, tehuu fai binesa na, te Au asoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesus nafada nae leoꞌ na, boe ma Petrus hela Ni leo suuꞌ neu, fo nasaꞌai nae, “Papa bosoꞌ dedea leo naꞌ! Manetualain ta bisa noi nataaꞌ a leo naꞌ fa!” ");
INSERT INTO rgu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tehuu Petrus dedean ria, ta tuka Manetualain hihii-nanaun. Huu ria na, de Yesus nasaꞌai natafaliꞌ ana nae, “Wee! Heoꞌ meme iaꞌ mai! Ria nana, nitu a malaka na riꞌ dedea! O bosoꞌ matabaa Au! O duꞌa-afi tuka noi lahenda dae-bafoꞌ a hihii-nanaun, ta tuka Manetualain hihii-nanaun fa!” ");
INSERT INTO rgu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Boe ma Yesus nanori-nafada ana mana tuka dea nara nae, “Lahenda fo nau tuka Au, sona tuka-tuka faiꞌ ana muste tuka nahere! Ana muste nafarene heni ria hihii-nanaun, fo tuka noi Manetualain hihii-nanaun. Leo mae lahenda nau raisa ni, ana muste tuka nahere, sama leoꞌ lahenda nasaa ai kake na fo neu mate. ");
INSERT INTO rgu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Huu fo lahenda bea sadia mate nana huu ana tuka Au, neuꞌ ko nasoda naroo noo Manetualain. Tehuu lahenda bea nasoda soa noi ao-ina heheli na, neuꞌ ko ria masoda na sapu-lalo! ");
INSERT INTO rgu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nenene, ee! Leo mae o manuu katemaꞌ dae-bafoꞌ a oe-isin, tehuu maneniko Manetualain tipa heni o, sona onto ubeaꞌ? Leo mae o lepa muni katemaꞌ dae-bafoꞌ a oe-isin boe oo, o ta bisa seluꞌ neuꞌ sumane ma. ");
INSERT INTO rgu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Au afada emi basa hal-hal ia ra, nana huu Au ia, Ana Lahenda. Neuꞌ ko Au onda faliꞌ mai pake Au Papa Ka kuasa marela-masaꞌa Na, Ria eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a sama-sama ro Au. Tepoꞌ ria, te neuꞌ ko Au balas lahenda ra tuka sira esa-esaꞌ ko nonoi-tataon. ");
INSERT INTO rgu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mafarereneꞌ matalolole! Neme emi basa ia mai, neuꞌ ko lahenda hida ta mate, losa fai hidaꞌ ara rita Au, Ana Lahenda a dadi Mane fo pareta.” ");
INSERT INTO rgu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Basa faiꞌ nee, boe ma Yesus naloo naa Petrus, Yakobis no fadin Yohanis, fo ara sama-sama ae leo lete madema esa lain reu, de noi mesaꞌ asa rai naa. ");
INSERT INTO rgu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Losa lain, boe ma ara rita Yesus narupa feke. Mata-idun rahaa sama leoꞌ ledo, ma kakao-papaken dadi fula makadila. ");
INSERT INTO rgu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kekeneu te, ara rita Ni dedea no baꞌi Musa ma baꞌi Elia. ");
INSERT INTO rgu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Boe ma Petrus noi namakokoaꞌ a losaꞌ ana dedea nafararaꞌu nae, “Papa! Ami nai ia malole na seli! De malole lenaꞌ ami mafoa maa laa anaꞌ telu. Esa fee Papa, esa fee baꞌi Musa, ma esa bali fee baꞌi Elia.” ");
INSERT INTO rgu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus bei dedea nae leoꞌ na, kekeneu te, oaꞌ a onda mai de napoti naa si. Boe ma ara heran ramanene haraoeꞌ esa kalua neme oaꞌ ria mai nae, “Nenene! Yesus nana Au Ana susue Ka. Ana tao naa Au dale Ka namahoꞌo. Mamanene matalolole neuꞌ Ana!” ");
INSERT INTO rgu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ana mana tuka dea nara ramanene leoꞌ na, boe ma ara bii raan seli, losaꞌ ara lekubara reu. ");
INSERT INTO rgu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tehuu Yesus mai fafae si, ma nae, “Ae! Emi foa leo. Bosoꞌ biiꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Boe ma ara botiꞌ laka nara, tehuu ara ta rita lahenda esa nai naa boeꞌ. Noi Yesus mesaꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ara mulai onda reme leteꞌ lain mai. Boe ma Yesus padaꞌ asa nae, “Hata fo besaꞌ ko emi mita ni a, bosoꞌ mafada esa boe! Au, Ana Lahenda ia, muste mate dei. Boe ma maneniko Au asoda seluꞌ, besaꞌ ko emi bole tui-mafada lahenda.” ");
INSERT INTO rgu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Boe ma ara ratane Ni rae, “Papa nana, tebe Kristus, tehuu baꞌi Elia nai bea? Huu fo mesen agama sira ranori-rafada rae, baꞌi Elia muste mai dei, besaꞌ ko Kristus mai. Tehuu tuka Papa, sona leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus nataa nae, “Tebe. Baꞌi Elia muste mai fo soi enoꞌ soa-neuꞌ Kristus dei. ");
INSERT INTO rgu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nenene matalole! Baꞌi Elia mai so, tehuu lahenda ta ralelaꞌ ana fa. Ara tao rasususaꞌ ana, tuka sira hihii-nanaun. Leoꞌ na boe, neuꞌ ko ara tao Au, Ana Lahenda ia.” ");
INSERT INTO rgu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ara ramanene basa leoꞌ na, besaꞌ ko bubuluꞌ rae, baꞌi Elia fo riꞌ Yesus nafada a, nana riꞌ Yohanis Mana Saraniꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus asa fali, te lahenda dodouꞌ rahani memaꞌ asa so. Boe ma touꞌ esa mai sundaꞌ undulaka na fo hule tutulu-fafaliꞌ neuꞌ Ana ");
INSERT INTO rgu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nae, “Ramatuaꞌ! Kasian neuꞌ au ana ka dei! Huu fo ana namahedi hehedeꞌ, ma doidoso naan seli. Maneniko hedis ria foa, sona ana tuda nala oe daleꞌ, do ai-pilaꞌ daleꞌ. Ramatuaꞌ e, tulu-fali dei! ");
INSERT INTO rgu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Au oo ni leo Ramatuaꞌ a ana mana tuka dea mara neu so, tehuu ara ta bisa puli ralan.” ");
INSERT INTO rgu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus namanene leoꞌ na, boe ma nasapaa ana mana tuka dea nara nae, “Ae! Emi talalu! Au anori-afada emi kose-kose, tehuu emi ta bubuluꞌ matetuꞌ. Ma emi ta mamahere tebe-tebe neuꞌ Au! Au muste anenete oo emi losa fai hidaꞌ bali? Moo anaꞌ ria leo iaꞌ mai!” ");
INSERT INTO rgu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ara roo anaꞌ a neu, de Ana usi heni nitu a neme anaꞌ ria mai. Nitu a kalua ela anaꞌ ria, boe ma teꞌe na aon tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Faiꞌ fo Yesus noo noi ana mana tuka dea nara mesaꞌ asa, boe ma ara ratane Ni rae, “Papa! Ubeaꞌ taon, de bisinaaꞌ a ami ta bisa usi mala nitu ria fa?” ");
INSERT INTO rgu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nataa nasafali asa nae, “Emi ta bisa usi nitu ria, nana huu emi ta mamahere tebe-tebe fa. Mafarereneꞌ! Maneniko emi mamahere tebe-tebe neuꞌ Au, leo mae noi bai anaꞌ sama leoꞌ ai deke anaꞌ a boe, emi bisa pareta leteꞌ esa mae, ‘Leteꞌ, on! Marali eleꞌ muu!’ Tantu ana narali. De emi bisa tao sudi ubeaꞌ, sadi emi mamahere tebe-tebe neuꞌ Ramatuaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tehuu nenene! Nitu rupa leo iaꞌ a memaꞌ makaresi na seli. Maneniko emi ta hule-haradoi ma puasa fo hule tutulu-fafaliꞌ neuꞌ Manetualain, sona emi ta bisa usi mala nitu rupa leo naꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lai esa de, Yesus noo ana mana tuka dea nara rabua rai propinsi Galilea. Ana nafada si nae, “Ta dooꞌ a soꞌ, te lahenda sakaꞌ seꞌo heni Au. ");
INSERT INTO rgu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Boe ma ara raisa Au, Ana Lahenda ia. Tebe Au mate, tehuu fai binesa na, te Au asoda seluꞌ.” Ana mana tuka dea nara ramanene Ni dedea nae leoꞌ na, boe ma dale nara susa raan seli. ");
INSERT INTO rgu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus noo ana mana tuka dea nara leo koro Kapernaum reu, boe ma mana susu bea ra mai de ratane Petrus rae, “Emi Mesen ma bae Uma Mamaso Yahudi Ina a doi-bea na do, taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus nataa nae, “Tantu bae!” Petrus fali, boe ma Yesus nafada nauluꞌ ana nae, “Ae, Simon! Soba o afi dei. Maneꞌ ara rai dae-bafoꞌ ia susu doi-bea neme bea mai? Neme sira ana nara, do neme lahenda fekeꞌ mai?” ");
INSERT INTO rgu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus nataa nae, “Neme lahenda fekeꞌ mai!” Yesus nafada bali nae, “Kalu leoꞌ na, sona maneꞌ a ana nara ta bae fa, hete? ");
INSERT INTO rgu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Leoꞌ na boe neuꞌ Uma Mamaso Yahudi Pusat a bea na. Tehuu ita ta bole tao fee mana susu bea ra ramanasa. De malole lenaꞌ, o muu dolu ikaꞌ nai dano. O mala ika masososaꞌ a, sona buka bafa na. Neuꞌ ko o hapu doi perak esa nai naa. Basa sona pake doiꞌ ria fo muu bae ita dua doi-bea na. Huu fo doiꞌ ria dai soa-neuꞌ ita dua.” ");
INSERT INTO rgu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Faiꞌ ria Yesus ana mana tuka dea nara mai ratane Ni rae, “Papa! Neme basa Manetualain lahenda nara mai, bea riꞌ bau lena?” ");
INSERT INTO rgu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Boe ma Yesus naloo na ana aanaꞌ esa, de feen napadei neuꞌ sira talada. ");
INSERT INTO rgu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ana nae, “Nenene matalolole! Lahenda bea nau dadi neuꞌ Manetualain lahendan, ria muste narali duduꞌa-aafin ela dadi sama leoꞌ ana aanaꞌ fo ta natutua-nadedema aon. ");
INSERT INTO rgu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Huu fo lahenda bea naloe-nadae aon sama leoꞌ ana aanaꞌ ia, sona ria riꞌ lahenda bau-inaꞌ nai Manetualain mata Na. ");
INSERT INTO rgu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma lahenda bea sipoꞌ lahenda aanaꞌ leo iaꞌ, nana huu namahere Au, sona ana sipoꞌ Au ria so.” ");
INSERT INTO rgu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesus nafada seluꞌ asa nae, “Maneniko lahenda bea tao na ana aanaꞌ esa, tuka eno masalaꞌ a, losaꞌ ta namahere Au, sona besa-besa, oo! Malole lenaꞌ lahenda heke batu bau-inaꞌ esa, neuꞌ bolii na, fo dolu ni leo tasiꞌ daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dae-bafoꞌ ia tebe-tebe mamana soe, huu fo hihii-nanauꞌ dodouꞌ riꞌ tao ra lahenda tuda rala sala-sikoꞌ daleꞌ. Tehuu lahenda fo soe raan seliꞌ a, nana siꞌ lahenda fo no ria tataon de lahenda fekeꞌ tao salaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Maneniko o tao salaꞌ muniꞌ lima ma, do, ei ma, sona tete henis! Huu fo malole lenaꞌ o masoꞌ nusatetu-ikutemaꞌ a no lima seseriꞌ, do ei seseriꞌ, beraꞌ ko no o ei-lima katematuam, ara tuꞌu o leo ai-pila naraka a muu. ");
INSERT INTO rgu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Maneniko o tao salaꞌ muniꞌ mata ma, sona edo henin! Huu fo malole lenaꞌ o masoꞌ nusatetu-ikutemaꞌ a no mata seseriꞌ, beraꞌ ko no o matam duas ara tuꞌu o leo ai-pila naraka muu.” ");
INSERT INTO rgu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus dedea bali nae, “Besa-besa, oo! Bosoꞌ losa emi ta hika-hadaꞌ ana aana leo iaꞌ. Huu fo Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a riꞌ ranea si. Ma eilaꞌo-limalopen sira bisa masoꞌ faiꞌ bea a, fo reu rafada lahenda ia ra hihii-nanauꞌ nara nai Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Emi afi matalolole, huu fo Au nau fee nasasamaꞌ leo iaꞌ: Lahenda esa nanuu bibi-lopo natun esa. Faiꞌ esa boe ma bibi esa sala de laꞌo mesaꞌ ana. Emi dodoo ma nana, mana foo ria muste tao ubeaꞌ? Tantu ana foa ela bibi-lopo kasio hulu sioꞌ sira reuꞌ leteꞌ lain, boe ma neu saka bibi-lopo iseꞌ mana mopoꞌ ria. Maneniko hapu faliꞌ ana, sona dale na namahoꞌo-natadale nita bibi-lopo iseꞌ mana mopoꞌ ria, lena neme nita bibi-lopon kasio hulu sio mana mopo taaꞌ sira. Au, Ana Lahenda ia, mai ela poꞌi-tata lahenda fo riꞌ heo reme eno roo-tetuꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Huu fo leo mae mopo noi ana aanaꞌ kamahereꞌ esa boe oo, Au Papa Ka nai nusatetu-ikutema a, ta nau fa.” ");
INSERT INTO rgu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus dedea seluꞌ nae, “Maneniko toranoom lahenda kamahereꞌ tao nasalaꞌ o, sona muste muu dama ni. Maneniko noi emi dua, sona besaꞌ ko mafada ria sala na. Kalu ana namanene o dedea-nafadam, sona emi dua malole ma seluꞌ ao mara. ");
INSERT INTO rgu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tehuu maneniko ana ta nau namanene neuꞌ o, sona muu mala tia-laim esa-dua fo mo si sama-sama meu dama lahenda ria, ela dedea mo ni seluꞌ. Huu fo mana duiꞌ nai Manetualain Susura Makamoi Na daleꞌ nae, ‘Nai dedeaꞌ esa, muste hapu sakasii dua do telu tutui nara sama, besaꞌ ko bisa sipoꞌ asa.’ ");
INSERT INTO rgu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tehuu maneniko ana bei ta nau namanene neuꞌ emi, sona meu mafada saraniꞌ ara. Ma kalu ana ta nau sipoꞌ saraniꞌ ara dedean no malole, sona tao ni sama leoꞌ lahenda fo ta nalelaꞌ Manetualain. Taꞌa, sona tao ni neuꞌ lahenda tadaluꞌ sama leoꞌ mana susu bea. ");
INSERT INTO rgu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mafarereneꞌ matalolole Au dedea Ka! Kalu hata ubeaꞌ fo emi horo ta bole taon nai dae-bafoꞌ a, sona Manetualain boe horo leo naꞌ nai nusatetu-ikutemaꞌ a. Ma kalu hata ubeaꞌ fo emi ta horo bole taon nai dae-bafoꞌ a, sona Manetualain boe ta horo leo naꞌ nai nusatetu-ikutemaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma Au afada seluꞌ ae, maneniko lahenda dua neme emi mai daleꞌ esa, fo hule-haradoi, neuꞌ ko Au Papa Ka nai nusatetu-ikutemaꞌ a fee hata fo ara hule a. ");
INSERT INTO rgu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maneniko Au lahenda Ki dua do telu rabua-raesa fo hule-haradoi sama-sama, sona Au boe nai sira talada.” ");
INSERT INTO rgu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Boe ma Petrus mai natane Yesus nae, “Ramatuaꞌ, au nau atane baiꞌ. Maneniko au toranoo lahenda kamahere ka tao nasalaꞌ au kose-kose, sona au muste fee ampon neuꞌ ana losa laiꞌ hida? Losa laiꞌ hitu, do?” ");
INSERT INTO rgu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus nataa ni nae, “Taꞌa! O muste fee ampon neuꞌ ana hitu laiꞌ hitu hulu (7 x 70), losaꞌ o reke doaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Emi muste tao tuka leoꞌ na, nana huu Manetualain sama leoꞌ maneꞌ esa bareken pegawe nara huta-buꞌun. ");
INSERT INTO rgu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tepoꞌ fo ana mulai bareken, boe ma nadenu ria lahendan neu naloo pegawe fo riꞌ nahuta ni doiꞌ, losa kefu-kafun. ");
INSERT INTO rgu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tehuu pegawe ria ta bisa bae nala huta na. De maneꞌ a pareta nae, ‘Meu seꞌo lahenda ia noo sao-anan katemaꞌ, ela ara dadi ata. Ma seꞌo heni basa hata-heton, fo ela bae ria huta-buꞌun.’ ");
INSERT INTO rgu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pegawe ria namanene leoꞌ na, boe ma ana sundaꞌ undulaka na nai maneꞌ a matan, fo leleꞌo ni nae, ‘Adoo! Papa, ee! Papa mane fee au fai lelaꞌ baiꞌ dei! Neuꞌ ko au bae etu katemaꞌ huta kara.’ ");
INSERT INTO rgu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Maneꞌ a namanene leoꞌ na, boe ma kasian neuꞌ ana. De ana eꞌa heni tutiꞌ pegawe ria huta nara katemaꞌ, ma ana poꞌi ni. ");
INSERT INTO rgu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tehuu pegawe ria kalua, boe ma neu dama tia-lain fo riꞌ nahuta ni doiꞌ baiꞌ. Ana hopu na tia na, de rumu neuꞌ bolii na, ma nasapaa nae, ‘O bae huta ma besaꞌ ia leo!’ ");
INSERT INTO rgu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tia na namanene leoꞌ na, boe ma sundaꞌ undulaka na fo leleꞌo ni nae, ‘Adoo! Tia, ee! Fee au fai lelaꞌ baiꞌ dei! Neuꞌ ko au bae etu katemaꞌ huta kara.’ ");
INSERT INTO rgu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tehuu pegawe ria nae, ‘Ta bisa fa! Leo mae leoꞌ bea boe oo, muste bae adaꞌ besaꞌ ia!’ Boe ma ana tee tia na leo bui daleꞌ neu, losaꞌ ana bae etu katemaꞌ huta nara. ");
INSERT INTO rgu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Maneꞌ a pegawe feke nara rita hata mana dadiꞌ ria, boe ma dale nara susa, de reu tui maneꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Maneꞌ a namanene leoꞌ na, boe ma naloo na pegawe mata mamae taaꞌ ria. Ana nasaꞌai ni nae, ‘Ae, lahenda tadaluꞌ on! O hule au kasian neuꞌ o, huu ria na de au eꞌa heni katemaꞌ huta mara so. ");
INSERT INTO rgu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tehuu ubeaꞌ taon de o ta kasian neuꞌ tia-laim ria, sama leoꞌ au kasian neuꞌ o?’ ");
INSERT INTO rgu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Maneꞌ a namanasa, losaꞌ ana nadenu si teen leo bui daleꞌ neu, fo ela ara ese-rumun, losa ana bae nabasa huta-buꞌun.” ");
INSERT INTO rgu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesus tui nateꞌe, boe ma Ana nafada nae, “Au Papa Ka nai nusatetu-ikutemaꞌ a bareken leo naꞌ boe. Maneniko emi ta tebe-tebe mafarene heni toranoo kamahere mara sala-sikon, sona neuꞌ ko Ana huku emi.” ");
INSERT INTO rgu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nanori-nafada basa sira, boe ma Ana laꞌo ela Galilea de leo propensi Yudea neu nai lee Yarden a seriꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lahenda dodouꞌ tuka Ni, ma Ana puli na lahenda kamahedis ara rai naa. ");
INSERT INTO rgu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lahenda Farisi hida mai fo nau rahihiiꞌ Yesus boe. Ara ratane rae, “Papa! Tuka ami atoran agama ma, maneniko touꞌ a sao, sona ana bole namaetuꞌ no sao na neniꞌ sudi eno ubeaꞌ a, do leo beaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tehuu Ana nataa nae, “Emi nana, lahenda fo malelaꞌ agama. Tehuu ubeaꞌ taon, de emi ta bubuluꞌ Manetualain Susura Makamoi Na isi-liin? Nai tutui masososaꞌ a, manaduiꞌ nae, ‘Manetualain adu na lahenda a, touꞌ ma inaꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma nanaduiꞌ bali nae, ‘Huu ria na, touꞌ a muste foa ela ina-aman, fo neu nasoda daleꞌ esa no sao na, nana huu sira dua dadi esaꞌ so.’ ");
INSERT INTO rgu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Huu ria na, de maneniko Manetualain riꞌ tao naa sira dadi esaꞌ, sona lahenda bosoꞌ fee si ramaetuꞌ bali!” ");
INSERT INTO rgu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lahenda Farisi sira ramanene Yesus dedea nae leoꞌ na, boe ma ratane bali rae, “Kalu leoꞌ na, sona ubeaꞌ taon de baꞌi Musa nae, lahenda bole ramaetuꞌ, sadi ana fee susura namaetuꞌ neuꞌ sao ina na dei?” ");
INSERT INTO rgu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Boe ma Yesus nataa bali nae, “Baꞌi Musa nataaꞌ emi bei-baꞌim ramaetuꞌ ro sao ina nara, huu fo sira laka batuꞌ leoꞌ emi! Tehuu tepoꞌ fo Manetualain adu dae-bafoꞌ ia, Ria hihii-nanaun ta leo naꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Huu ria na de Au afada! Maneniko sao inaꞌ a hohoke nauluꞌ, sona touꞌ a bole namaetuꞌ. Tehuu maneniko sao inaꞌ a ta hohoke fa, te touꞌ a riꞌ namaetuꞌ noon, boe ma sao seluꞌ ina fekeꞌ, sona ana hohoke ria!” ");
INSERT INTO rgu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ana mana tuka dea nara ramanene Ni dedea nae leoꞌ na, boe ma ara dedea rae, “Kalu leoꞌ na, sona malole lenaꞌ bosoꞌ sao.” ");
INSERT INTO rgu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus nataa si nae, “Ta basa lahenda ra bisa sipoꞌ Au dedea Ka. Noi lahenda fo riꞌ Manetualain teka-here si a. ");
INSERT INTO rgu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hapu lahenda manasao taaꞌ, nana huu neme boki ni a leo naꞌ. Hapu lahenda manasao taaꞌ, nana huu lahenda tao ni leoꞌ na. Ma lahenda ta nahiiꞌ sao fa, nana huu ria nau nalalaꞌo noi Manetualain nonoi-tataon. Lahenda bea bisa bubulu-nalelaꞌ nanori-nafadaꞌ ia, sona ela ana sipoꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Faiꞌ ria, lahenda ra oꞌo roo ana nara leo Yesus reu, fo ela Ana fua lima Na neuꞌ asa ma nafada fee si ua-naleꞌ. Tehuu ana mana tuka dea nara rasaꞌai lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Boe ma Ana namanasa no ana mana tuka dea nara nae, “Nemeꞌ na ela anaꞌ sira leo Au mai! Bosoꞌ ena-matabaa si! Huu fo lahenda leo iaꞌ ara, nana Manetualain lahendan.” ");
INSERT INTO rgu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Boe ma Ana fua lima Na neuꞌ ana aanaꞌ sira, ma hule fo Manetualain fee si ua-naleꞌ. Basa boe ma Ana laꞌo ela mamanaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Laiꞌ esa de, lahenda mai natane Yesus nae, “Papa Mesen! Au muste tao hihii-nanauꞌ malole leo beaꞌ, fo ela au bubuluꞌ matetuꞌ ae, au bisa masoꞌ nusatetu-ikutemaꞌ a. Huu fo au nau asoda aroo sama-sama oo Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus nataa nae, “Ubeaꞌ taon, de o matane Au laꞌe-neuꞌ ubeaꞌ riꞌ malole? Noi Manetualain riꞌ malole. Maneniko o nau masoda mo Ni, sona tuka pareta Na.” ");
INSERT INTO rgu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lahenda ria natane seluꞌ nae, “Pareta a riꞌ ubeaꞌ?” Yesus nataa nae, “Bosoꞌ maisa lahenda; bosoꞌ hohoke; bosoꞌ mamanaꞌo; bosoꞌ sakasii pepekoꞌ; ");
INSERT INTO rgu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","fee hada-horomata neuꞌ o ina-amam; ma sue-lai toranoo ma sama leoꞌ o sue-lai ao-ina heheli ma.” ");
INSERT INTO rgu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lahenda ria nataa Ni nae, “Basa pareta sira au tao si so. Bei kura ubeaꞌ bali?” ");
INSERT INTO rgu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus namanene leoꞌ na, boe ma nae, “Maneniko o nau tuka Manetualain hihii-nanaun katemaꞌ, sona fali fo seꞌo heni katemaꞌ hata-hetom. Basa sona muu babati doiꞌ sira fee lahenda hata taaꞌ ara, besaꞌ ko mai fo tuka Au. Huu fo neuꞌ ko Manetualain balas fee o hata-heto dodouꞌ nai nusatetu-ikutemaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lahenda ria namanene leoꞌ na, boe ma ana fali neun no dale susa, huu fo namasuꞌi naan seli. ");
INSERT INTO rgu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Boe ma Yesus dedea no ana mana tuka dea nara nae, “Mamahere Au, huu fo lahenda kamasuꞌi a susa laesaꞌ masoꞌ nusatetu-ikutemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ria susa na, sama leoꞌ banda onta bau-inaꞌ a, masoꞌ leo oka na neu, nesiꞌ rarauꞌ a bolo na.” ");
INSERT INTO rgu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ana mana tuka dea nara ramanene leoꞌ na, boe ma ara heran. Ara rataa rae, “Kalu leoꞌ na, sona bea riꞌ bisa masoꞌ nusatetu-ikutemaꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ana mete natalolole si, boe ma dedea nae, “Maneniko lahenda dae-bafoꞌ a riꞌ noi-tao, sona memaꞌ ta bisa fa. Tehuu kalu Manetualain riꞌ noi-tao, sona basa-basan bisa dadi!” ");
INSERT INTO rgu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Boe ma Petrus fee nafarereneꞌ nae, “Papa! Ami foa ela hata-hetom katemaꞌ so, fo tuka Papa. Tehuu ami hapu ubeaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus nataa nae, “Mamahere Au! Maneniko Manetualain tao na basa-basan dadi bebeu, neuꞌ ko Au Ana Lahenda ia, atuuꞌ nai kadera mana pareta bau-inaꞌ. Tepoꞌ ria, emi fo riꞌ tuka Au a, matuuꞌ nai kadera mana pareta kasanahulu duaꞌ sira boe, fo dadi mana ee dedeaꞌ soa-neuꞌ leo Israel kasanahulu duaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lahenda fo foa ela ria uma-loon, aꞌa-fadin, ina-aman, ana nara, ma oka-tinen fo tuka Au, neuꞌ ko ana sipo faliꞌ losa lena heni laiꞌ natun. Boe ma maneniko dae-bafoꞌ ia noe, ana nasoda naroo noo Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mafarereneꞌ! Tuka Manetualain duduꞌa-aafin, lahenda dodouꞌ matutua-madedema aoꞌ ara, nana siꞌ lahenda fo aanaꞌ raan seli. Tehuu lahenda maloe-madae aoꞌ ara, nana siꞌ lahenda bau-inaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Boe ma Yesus nanori-nafada nae, “Manetualain hohomu pareta na, sama leoꞌ nasasamaꞌ ia: lahenda manuu okaꞌ esa liꞌu nee balahaan, ana kalua neu saka lahenda fo roi oka anggor na. ");
INSERT INTO rgu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ana hapu lahenda mananoi, boe ma ara dedearaoꞌ fo roi faiꞌ esa, sona seseba na, doi perak esa, tuka beli biasa. Hala haraꞌ basa, boe ma ana nadenu si reu roi nonoiꞌ nai ria oka na. ");
INSERT INTO rgu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Liꞌu sio balahaan, boe ma ana kalua leo pasar neu, de nita lahenda hida ratuu kukuaꞌ rai naa. ");
INSERT INTO rgu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ana nafada si nae, ‘Ae, aꞌa kara, ee! Emi nau moi nonoiꞌ nai au oka ka, do? Neuꞌ ko au bae emi no malole.’ Ara ramanene leoꞌ na boe ma rataa, de reu roi nonoiꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Liꞌu sanahulu dua ledo hanan, ma liꞌu telu leodaen, manuu okaꞌ a kalua neu saka lahenda mana noi bali. ");
INSERT INTO rgu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ledo leodaen, bate liꞌu lima, boe ma manuu okaꞌ ria kalua bali. Ana mete neu-mai, te bei hapu lahenda rapadei hihiiꞌ. Ana natane si nae, ‘Ubeaꞌ taon, de emi mapadei hihiiꞌ memeꞌ balahaaꞌ a mai losaꞌ leodaen ia, ma ta tao hata-hata esa boeꞌ?’ ");
INSERT INTO rgu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lahenda sira rataa ni rae, ‘Papa, ee! Ta hapu lahenda fee ami moi nonoiꞌ.’ Boe ma manuu okaꞌ a nae, ‘Kalu leoꞌ na, sona emi meu moi nonoiꞌ nai au oka ka leo!’ ");
INSERT INTO rgu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Basa jam nonoiꞌ a, boe ma manuu okaꞌ a naloo mandor na de nae, ‘Maloo lahenda mana noi ra, fo au bae sira esa-esa seseba nara. Mulai neme lahenda fo mai nesiꞌ buiꞌ, losa leo lahenda fo mai nauluꞌ a.’ ");
INSERT INTO rgu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Boe ma mandor naloo lahenda mana noi ra, mulai neme liꞌu lima leodaen. Ana fee si esa na sipo doi perak esaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Basa de mandor naloo lahenda mana noi fekeꞌ sira, losa leo lahenda fo roi nonoiꞌ reme liꞌu nee balahaan. Lahenda fo roi reme balahaa anan ria mai a, afi rae tantu ara sipo desi lena neme lahenda fo roi mulai reme liꞌu lima leodaen. Sekona te, sira boe sipo doi perak bei esaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ara sipo ra, boe ma ramumuu manuu okaꞌ a rae, ");
INSERT INTO rgu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aweꞌ! Bos, ta bisa leo iaꞌ fa! Sira mai resiꞌ buiꞌ, roi nonoiꞌ noi jam esaꞌ a. Tehuu ami moi nonoiꞌ sota maan seli meme balahaa anan ria mai, losaꞌ ami puse makeoꞌ ara! Tehuu tao leoꞌ bea, de bos bae ami sama leoꞌ sira?’ ");
INSERT INTO rgu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Boe ma manuu okaꞌ a nataa sira esa nae, ‘Aꞌa, ee! Au ta parnanake aꞌa fa. Huu fo aꞌa riꞌ sipoꞌ mae moi nonoiꞌ faiꞌ esa, sona seba doi perak esa. Tebe, hete? De au bae tuka ita nahelu na hete? ");
INSERT INTO rgu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Malole lenaꞌ aꞌa sipo ma doi seseba ma fo fali leo. Maneniko au nau fee lahenda fo mai nesiꞌ buiꞌ a desi au fee aꞌa, sona ria nana au urusan ka. ");
INSERT INTO rgu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Au riꞌ araa ator aok doi kara tuka au dale hihii ka. Ubeaꞌ taon de aꞌa eteꞌ ao ma, nana huu au dale malole ka?’ ");
INSERT INTO rgu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Leoꞌ na boe, tepoꞌ fo Manetualain dadi mane soa-neuꞌ lahenda ra, Ana balas lahenda nara tuka Ria hihii-nanaun. De lahenda fo mai nesiꞌ buiꞌ, neuꞌ ko ana sipo babatiꞌ, sama leoꞌ lahenda fo mai nauluꞌ. Ma lahenda fo mai nauluꞌ, neuꞌ ko ana sipo babatiꞌ sama leoꞌ lahenda fo mai nesiꞌ buiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Boe ma Yesus asa mulai leo Yerusalem reu. Nai eno taladaꞌ, Ana naloo na ana mana tuka dea nara, de rabua ro noi mesaꞌ Ana. Boe ma Ana nafada bali nae, ");
INSERT INTO rgu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Emi nenene, ee! Besaꞌ ia ita sakaꞌ leo Yerusalem teu. Tehuu nai naa, lahenda seꞌo heni Au, Ana Lahenda ia, fee malaka agama Yahudi malaka nara, ma mesen agama ra. Ara raetuꞌ fo huku ramate Au. ");
INSERT INTO rgu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Boe ma ara fee heni Au leo lahenda fekeꞌ fo riꞌ ta ralelaꞌ Manetualain. Ara ramumulu-ramamaeꞌ Au. Ma ara fepa-liꞌu ralulutuꞌ Au ao-ina Ka, basa de ara raisa Au nai ai kake a. Tetebes ara Au mate. Tehuu fai binesa na, te Au asoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Boe ma Sabadeus sao na noo ana nara Yakobis ma Yohanis, ara sama-sama leo Yesus mai. Boe ma ana sundaꞌ undulaka na, ma fee hada-horomata fo dodoe-taiboni neuꞌ Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus natane ni nae, “Mama parluu ubeaꞌ?” Ana nafada nae, “Leo iaꞌ Papa! Au hule fo, maneniko Papa matuuꞌ homu pareta, sona Papa soꞌu ma au ana ki ia ra duas, fo ara homu pareta sama-sama ro Papa. Au hule fo Papa fee esa natuuꞌ nai Papa boboa ona Ma, ma esa nai boboa ii Ma.” ");
INSERT INTO rgu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus namanene ria huhule na, boe ma nafada Yakobis ma Yohanis nae, “Emi ta bubuluꞌ hata fo emi hule a. Huu fo neuꞌ ko Au hapu doidosoꞌ dodouꞌ. De leoꞌ bea? Dodoo maan nana emi mabeꞌi lepa doidoso ria sama-sama mo Au, do?” Dua si rataa ratalolole rae, “Papa e, talalu bisa!” ");
INSERT INTO rgu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Boe ma Yesus nataa si bali nae, “Tebe, emi boe neuꞌ ko lepa doidoso ria sama leoꞌ Au. Tehuu neuꞌ ko bea riꞌ natuuꞌ nai Au boboa ona, ma boboa ii Ka, ta Au riꞌ aetuꞌ fa. Manetualain riꞌ nanuu haak naetuꞌ ria. Ana naetuꞌ memaꞌ so, bea riꞌ natuuꞌ nai mamanaꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ana mana tuka dea kasanahulu fekeꞌ ara ramanene dua si huhule na leo naꞌ, boe ma eteꞌ ao nara. ");
INSERT INTO rgu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tehuu Yesus naloo na basa si, boe ma nae, “Leo iaꞌ! Emi bubuluꞌ so, hete? Lahenda bau-inaꞌ fo riꞌ homu pareta biasa ranete anaraun ara, losaꞌ ta bisa rababale. Ma malaka reme lahenda nusaꞌ fo riꞌ ta ralelaꞌ Manetualain, ara fee pareta seli uukuꞌ a, losaꞌ sira anarau nara ta bisa botiꞌ laka nara. ");
INSERT INTO rgu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tehuu emi ta bole tao leo naꞌ! Neme emi mai bea nau dadi lahenda bau-inaꞌ, ana muste dadi sama leoꞌ ana uma daleꞌ fo nalalau lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma bea nau dadi malaka, ana muste tao aon sama leoꞌ ata. ");
INSERT INTO rgu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nenene, ee! Au boe leo naꞌ. Au, Ana Lahenda ia, mai fo alalau lahenda. Au ta mai fo lahenda ralalau Au. Au mai fo fee katemaꞌ soda Ka, ela soi-tefa lahenda dodouꞌ reme sira sala-siko nara mai.” ");
INSERT INTO rgu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Boe ma Yesus asa laꞌo raroo. Fai fo ara kalua reme kota Yeriko mai, lahenda dodouꞌ tuka si. ");
INSERT INTO rgu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nai naa, lahenda pokeꞌ dua ratuu rai enoꞌ a suu na. Ara ramanene rae, Yesus neme Nasaret mai riꞌ laꞌo nesiꞌ naa, boe ma ara bobouꞌ rambera rae, “Ramatuaꞌ! Daud tititi-nonosin, ee! Ami mahani Ramatuaꞌ a doꞌ a so! Kasian neuꞌ ami dei!” ");
INSERT INTO rgu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lahenda ra ramanenes bobouꞌ leoꞌ na, boe ma rasaꞌai si rae, “Ae! Emi dua bosoꞌ mahahara!” Tehuu ara bobouꞌ rambera ina bali rae, “Ramatuaꞌ! Daud tititi-nonosin, ee! Kasian neuꞌ ami dei!” ");
INSERT INTO rgu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus namanene leoꞌ na, boe ma nateꞌe de natane si nae, “Emi nau Au tao ubeaꞌ soa-neuꞌ emi?” ");
INSERT INTO rgu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ara rataa rae, “Ramatuaꞌ, ee! Tulu-fali ami, fo ela bisa mita-dae dei!” ");
INSERT INTO rgu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ana namanene si dedea rae leoꞌ na, boe ma Ana kasian neuꞌ asa. Ana nafaroe mata nara, boe ma rita-dae tutiꞌ a. Basa de ara laꞌo tuka Ni. ");
INSERT INTO rgu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus asa laꞌo raroo de losa rai koroꞌ esa nade Betfage, nai lete Saitun suu na. Koroꞌ ria naneneaꞌ noo kota Yerusalem. Ara hahae ao nara rai naa. Boe ma Ana nadenu ana mana tuka dean dua fo reu rauluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ana pareta si nae, “Emi dua leo koroꞌ a riꞌ eleꞌ meu. Emi meu, te neuꞌ ko mita keledei inaꞌ esa noo ana na, nanahekeꞌ rai naa. Emi meu sefi heni tali nara, fo hela meni si mai fee Au. ");
INSERT INTO rgu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tehuu maneniko lahenda natane emi nae, ‘Ubeaꞌ taon, de emi hela meni lahenda keledei na?’ Sona emi mataa mae, ‘Ramatuaꞌ a nau pake. Maneniko Ana pake basa, sona neuꞌ ko fee faliꞌ ana.’ ");
INSERT INTO rgu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Basa ia ra muste dadi, tuka hata fo Manetualain mana nesi mata nara duiꞌ memaꞌ rae, ");
INSERT INTO rgu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Ae, lahenda Yerusalem emin! Mai mete-relu nai ia dei! Huu fo emi Mane ma mai. Ana mai noo dale naloe-nadae aoꞌ. Ana mai saꞌe keledei anaꞌ.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Boe ma ana mana tuka dea sira reu, ma tao tuka basa-basan sama leoꞌ Yesus helu si a. ");
INSERT INTO rgu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ara hela reni keledei inaꞌ ria noo ana na leo Yesus reu. Boe ma ara bela lafa nara reuꞌ keledei ria, ela Yesus saꞌe neuꞌ lain fo sakaꞌ leo kota daleꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ara sakaꞌ masoꞌ kota daleꞌ, boe ma lahenda dodouꞌ hai ra lafa, ma lafa ana nara bela si reuꞌ enoꞌ lain. Ruma reu beta reni palam dooꞌ fo kakari neuꞌ enoꞌ a talada. No ria na, ara tao tanda nae, ara sipoꞌ Ana sama leoꞌ lahenda bau-inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lahenda ruma laꞌo uluꞌ Yesus resiꞌ mata, ma ruma resiꞌ deaꞌ boe. Ara heꞌi rame-rame rae, “Hosana! Ami io-oa Manetualain! Nana huu Daud tititi-nonosin mai! Hosana! Ami io-oa Manetualain! Nana huu Manetualain nadenu Lahenda ia mai. Hosana! Ami io-oa Manetualain! Nana huu Manetualain natuuꞌ pareta memaꞌ nai lalai poi na!” ");
INSERT INTO rgu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Fai fo Yesus masoꞌ Yerusalem no rame-rame leo naꞌ, boe ma basa kota isiꞌ a kalua mai de ratane rae, “Awii! Bea riꞌ maiꞌ ia?” ");
INSERT INTO rgu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lahenda makadotoꞌ sira rataa rae, “Ia nana, Manetualain mana nesi matan. Nade Yesus, lahenda Nasaret, neme propensi Galilea mai.” ");
INSERT INTO rgu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus asa laꞌo raroo, de masoꞌ leo Manetualain Uma Mamaso Yahudi Inan reu. Nai Uma Mamasoꞌ a kintal na, lahenda ra taon dadi neuꞌ pasar, de ara raseꞌo manupui kalasi fo riꞌ lahenda paken dadi tutunu-hohotuꞌ soa-neuꞌ huhule-haradoiꞌ. Yesus nita leoꞌ na, boe ma neu usi heni si. Ana rua nabuu mei fo riꞌ ara pake si ela lahenda nusa dea mai tukar doi nara a, ma fae naleka-natono baku fo ara pake si ela seꞌo reniꞌ manupuiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ana nafada si nae, “Manetualain mana nesi mata na duiꞌ nae, ‘Au afoa Uma ia, fo ela lahenda bisa mai hule-haradoi nai ia.’ Manetualain hihii-nanaun leo naꞌ, tehuu emi tao Uma ia dadi neuꞌ parampok ara mamana nabua-naesan!” ");
INSERT INTO rgu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Boe ma lahenda pokeꞌ, ma lahenda lukuꞌ ara leo Yesus mai nai Manetualain Uma Mamaso Yahudi na. De Ana puli na katemaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Malaka agama Yahudi malaka nara, ma mesen agama ra rai naa boe. Ara rita Yesus tao tanda heran leo naꞌ, boe ma eteꞌ ao nara. Lena-lenaꞌ bali, fai fo ramanene anaꞌ sira bobouꞌ rame-rame rai Uma Mamasoꞌ a rae, “Hosana! Ami io-oa Manetualain! Nana huu mane Daud a tititi-nonosin mai so!” ");
INSERT INTO rgu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Boe ma malaka sira rafada Yesus rae, “Ae! O mamanene anaꞌ sira dedean? Ria ta laꞌe fa!” Tehuu Yesus nataa si nae, “Au amanene. Te ubeaꞌ taon? Emi bei ta parnaa les nai Manetualain Susura Makamoi Na laꞌe-neuꞌ anaꞌ ara io-oa Manetualain, do? Mana duiꞌ nai naa nae, ‘Manetualain sadia memaꞌ ana boki beuꞌ ma ana aanaꞌ ara, fo ara io-oa Ni.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Boe ma Yesus asa kalua ela kota ria, de reu suku rai koro Betania. ");
INSERT INTO rgu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Balahaaꞌ balahaa anan, Yesus asa fali seluꞌ leo kota Yerusalem reu. Tehuu nai eno taladaꞌ, Ana namalaa. ");
INSERT INTO rgu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ana nita ai huuꞌ esa nai enoꞌ a suu na, lahenda biasa raa boan na. De Ana naneneaꞌ leo ai huuꞌ ria neu, fo nau mete nanenin, hapu boaꞌ, do taꞌa. Tehuu Ana losa ai huuꞌ ria, Ana ta nita boaꞌ esa boeꞌ, huu fo ai huuꞌ ria besaꞌ ko nadoo beu. Boe ma Ana dedea neuꞌ ai huuꞌ ria nae, “Huu no ta kalua boa ma fee Au, de neuꞌ ko o ta maboa soꞌ!” Ana dedea basa, boe ma ai huuꞌ ria namatuu tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ria ana mana tuka dea nara rita leo naꞌ, boe ma kekes ara. Ara ratane rae, “Ubeaꞌ taon, de kekeneu te, ai huuꞌ ia namatuu tutiꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Boe ma Ana nataa si nae, “Nenene matalolole! Kalu emi mamahere tebe-tebe Manetualain, ma dale mara ta kadudua fa, emi bisa tao sama leoꞌ Au tao a. Emi boe bisa tao lena neme na. Conto leo-leoꞌ: emi bisa pareta leteꞌ esa narali leo tasiꞌ a neu. Tantu Manetualain fee leteꞌ ria narali tutiꞌ a, sadi emi mamahere tebe-tebe neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Basa hihii-nanauꞌ fo emi hule neuꞌ Manetualain, neuꞌ ko emi sipo si, sadi emi mamahere tebe-tebe neuꞌ Ana.” ");
INSERT INTO rgu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Boe ma Yesus asa laꞌo raroo. Losa Yerusalem, boe ma ara masoꞌ seluꞌ leo Uma Mamaso Yahudi Ina a kintal na reu. Ana nanori-nafada laꞌenauꞌ Manetualain eno masoda Na, boe ma malaka agama Yahudi malaka nara, ma lasi hadas ara mai ratatane aoꞌ ro Ni rae, “Useleꞌ a bea riꞌ nadenu o mai tao liuaari nai ia? Bea riꞌ fee o haak ria?” ");
INSERT INTO rgu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tehuu Ana bubuluꞌ ara saka enoꞌ fo nau ratuda Ni. Boe ma Ana balas nae, “Au boe nau atane emi. Emi mataa Au dei, besaꞌ ko Au ataa emi. ");
INSERT INTO rgu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Au atane leo iaꞌ: Emi basa malelaꞌ Yohanis mana saraniꞌ a, hete? Bea riꞌ fee ni haak fo sarani lahenda? Manetualain do, lahenda dae-bafoꞌ a?” Boe ma ara afi reu-mai, ma ara dedearaoꞌ rae, “Awii! Nala seluꞌ ita ia so! Maneniko ita tataa tae, ‘Manetualain riꞌ fee haak’, neuꞌ ko Ana balas nae, ‘Kalu leoꞌ na, sona ubeaꞌ taon de emi ta mamahere Yohanis fa?’ ");
INSERT INTO rgu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tehuu ita boe ta bisa tae, ‘Lahenda nai dae-bafoꞌ a riꞌ fee haak’, neuꞌ ko basa lahenda fo rai ia mai suu ita. Nana huu ara ramahere rae, Yohanis nana, Manetualain mana nesi matan.” ");
INSERT INTO rgu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huu ria na, de ara rataa Yesus rae, “Ami ta bubuluꞌ fa.” Boe ma Yesus balas nae, “Kalu leoꞌ na, sona Au boe ta parluu afada ae bea riꞌ fee Au haak.” ");
INSERT INTO rgu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus dedea naroo no malaka sira nae, “Emi aafi ma leo beaꞌ neuꞌ nasasamaꞌ ia? Touꞌ esa no ana manen dua. Ana pareta ana uluꞌ a nae, ‘Ana ki on! Faiꞌ ia o muu moi nonoiꞌ nai okaꞌ dei.’ ");
INSERT INTO rgu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Anaꞌ ria nataa nae, ‘Eeh! Au ta uu fa.’ Tehuu basa boe ma ana nasale dale de neu. ");
INSERT INTO rgu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Boe ma touꞌ ria nadenu ana kadua a nae, ‘Ana ki on! Faiꞌ ia o muu moi nonoiꞌ nai okaꞌ dei.’ Anaꞌ ria nataa nae, ‘Malole a papa. Neuꞌ ko au uu’. Sekona te ta neu fa.” ");
INSERT INTO rgu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesus tui basa nae leoꞌ na, boe ma natane si nae, “Au sakaꞌ atane leo iaꞌ: Neme anaꞌ sira dua mai, bea riꞌ tao tuka papa na paretan?” Ara rataa rae, “Masososaꞌ a!” Boe ma Ana dedea nae, “Hoo. Tehuu nenene matalolole, huu fo Au dedea teteaꞌ. Lahenda fo emi mae sira lahenda masala-masikoꞌ, leo-leoꞌ mana susu bea, ma ina manasosoa, neuꞌ ko ara dadi reuꞌ Manetualain lahendan rauluꞌ reme emi mai. Huu fo emi mataa neuꞌ Manetualain mae ya, tehuu ta tao tuka Ria hihii-nanaun fa. ");
INSERT INTO rgu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Fai a ulu na Yohanis mana saraniꞌ a nanori-nafada emi eno na leo beaꞌ, fo emi bisa masoda roo-tetuꞌ. Tehuu emi ta nau mamahere ni. Sekona te, tepoꞌ fo lahenda masala-masikoꞌ ara ramanene Yohanis, sira saledale-tuꞌetei nara, de tuka ria nanori-nafadan. Emi bubuluꞌ basa sira so boe. Tehuu emi ta nau saledale-tuꞌetei mara, fo tuka Manetualain hihii-nanaun.” ");
INSERT INTO rgu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Boe ma Yesus tui seluꞌ nasasamaꞌ esa bali nae, “Manuu daeꞌ esa nau sele ai anggor neuꞌ ria daen bibiaꞌ esa. Ana heu kofeoꞌ naan, ma tao bak fo ela hee oe anggor neuꞌ daleꞌ. Ma nafoa uma nanea demaꞌ esa. Ana seba okaꞌ ria fee mana noi ra, fo ara roin ela rabatiꞌ buna-boaꞌ ro ni. Boe ma ana leo nusa dea neu. ");
INSERT INTO rgu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Losa fai eetu boa anggor, boe ma manuu okaꞌ a nadenu ata nara leo mana noi ra reu, fo hule ria nuu babati na. ");
INSERT INTO rgu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tehuu mana noi sira ta tao daleꞌ neuꞌ ana uma daleꞌ ara. Esa hapu fefepa-liliꞌu, fekeꞌ a raisa ni, ma fekeꞌ a bali roi piaꞌ ana reniꞌ batu. ");
INSERT INTO rgu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tehuu manuu okaꞌ ria, nadenu seluꞌ ana uma dalen bubuaꞌ esa dodouꞌ lena heni masososaꞌ a. Tehuu mana noi sira tao tadalu leo naꞌ neuꞌ basa si boe. ");
INSERT INTO rgu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mateꞌe na boe ma manuu okaꞌ a nadenu ana boki na. Ana afi nae, ‘Maneniko au fee ana boki ka neu, tantu ara sipoꞌ no malole, ma ramanene ni.’ ");
INSERT INTO rgu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tehuu mana noi ra rita anaꞌ ria, boe ma dedearao nara rae, ‘Ae, emi mete dei! Tou lasiꞌ a fee ana boki na mai so. Neuꞌ ko ria riꞌ sipo katemaꞌ tou lasiꞌ a posaka nara. De mai fo taisa ni, fo ela ita tanuu okaꞌ ia.’ ");
INSERT INTO rgu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Boe ma ara hopu ra anaꞌ ria tuꞌun leo okaꞌ deaꞌ neu de raisa ni.” ");
INSERT INTO rgu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus tui basa, boe ma Ana natane si nae, “Au nau atane leo iaꞌ: maneniko manuu okaꞌ ria fali main, sona ana tao mana noi sira leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lahenda Yahudi ra malaka nara rataa rae, “Tantu ana naisa basa lahenda tadaluꞌ sira. Boe ma ana seba okan ria neuꞌ lahenda fekeꞌ, fo neuꞌ ko naraa laꞌe ledo-fain, sona bati buna-boaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Boe ma Yesus dedea no si nae, “Bate emi bei ta parnaa lees hata fo manduiꞌ nai Manetualain Susura Makamoi Na nae, ‘Hapu batu esa, tukan batu a tuꞌu henin so, tehuu besaꞌ ia batu ria dadi neuꞌ uma a batu natenden! Manetualain riꞌ here batu ria, boe ma natende ni. Huu ria na, ita tita ni malole na seliꞌ!’ ” ");
INSERT INTO rgu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesus dedea naroo nae, “De, emi afi matalolole e. Fai a ulu na, Manetualain teka-here ita lahenda Yahudi a, fo dadi teuꞌ Ria lahendan. Tehuu no emi ta nau tao daleꞌ neuꞌ Au, de neuꞌ ko Manetualain teka-here lahenda fekeꞌ. Lahenda bea nasoda tuka Ria hihii-nanaun, riꞌ bisa dadi neuꞌ Ria lahendan. ");
INSERT INTO rgu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Au tui neuꞌ tea na. Au ia, nana riꞌ batu natendeꞌ ria. Lahenda bea tuda laꞌe batu ia, neuꞌ ko lahenda ria nalulutuꞌ. Ma kalu batu ria tuda laꞌe lahenda, neuꞌ ko lahenda ria nasosopuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Malaka agama Yahudi malaka nara, ma lahenda Farisi ra ramanene Yesus tutui Na, boe ma ara bubuluꞌ rae, Ana dedea laꞌe-neuꞌ sira. Sira sama leoꞌ mana noi ra, ma tukan batu fo tuꞌu heni batu natendeꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","De, ara ramanasa raan seli. Boe ma ara ator eno na fo nau hopu Ni. Tehuu ara bei lele lahenda kadodouꞌ, fo riꞌ rae Yesus nana Manetualain mana nesi matan. Huu ria na, de ara ta bisa tao Ni leoꞌ bea boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Boe ma Yesus dedea no si pake dedea nasasamaꞌ bali nae, ");
INSERT INTO rgu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Manetualain hohomu pareta na, sama leoꞌ maneꞌ esa kabi ana mane na. ");
INSERT INTO rgu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Faiꞌ fo feta a nanasadiaꞌ, boe ma nadenu ata nara reu rafada lahenda fo ara hapu nalooꞌ a rae, ‘Mai leo, te feta sakaꞌ mulai.’ Tehuu lahenda sira ta nau mai fa. ");
INSERT INTO rgu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ata sira fali mai si, boe ma rafada maneꞌ a. Maneꞌ a namanene leoꞌ na, boe ma nadenu ata feke nara nae, ‘Emi meu mafada lahenda ra, fo mai leo, te feta nanasadiaꞌ so. Au tati sapi, ma dode-nasu mina-malada so. Mafada si mai raa feta leo, huu fo basan nanasadiaꞌ so.’ ");
INSERT INTO rgu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ata sira reu rafada rae leo naꞌ. Tehuu lahenda fo hapu nalooꞌ a, ara ta nau tao daleꞌ neu fa. Ruma leo oka-tinen daleꞌ reu, ruma leo mamana nonoi-tatao nara reu, ");
INSERT INTO rgu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ma ruma hopu ra maneꞌ a ata nara, fo ese-rumu raisa si. ");
INSERT INTO rgu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Maneꞌ a namanene leoꞌ na, boe ma namanasa naan seli. De nadenu soldadu nara reu raisa lahenda fo riꞌ raisa ata nara. Boe ma soldadu ra hotu heni kota ria. ");
INSERT INTO rgu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Basa de maneꞌ a naloo na ata feke nara, nafada si nae, ‘Feta kakabiꞌ a nanasadiaꞌ so, tehuu lahenda fo au aloo si a, ta naraa mai raa au feta ka. ");
INSERT INTO rgu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Besaꞌ ia, emi kalua leo eno rame a meu, mafada sudi bea fo maneta mo si rai naa a.’ ");
INSERT INTO rgu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Boe ma ata sira leo eno rame a reu. Ara raneta ro lahenda fo rai naa, roo dodouꞌ leo feta kakabiꞌ a mai. Lahenda malole ma lahenda tadaluꞌ ara mai ratuu rahenu mamana feta a. ");
INSERT INTO rgu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Boe ma maneꞌ a masoꞌ leo mamana feta a neu, de memete naleleiꞌ fui ra. Ana nita fui esa ta pake papake feta-dote fa. ");
INSERT INTO rgu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Maneꞌ a natane ni nae, ‘Ae tia, ee! Ubeaꞌ taon, de o masoꞌ leo iaꞌ mai ta pake papake feta-dote fa?’ Tehuu lahenda ria noi namakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Maneꞌ a pareta ata nara nae, ‘Puputu ma lahenda ia ei-liman, fo tuꞌun leo deaꞌ neu. Nemeꞌ na ela ana dola ma doidoso nai mamana maiuꞌ ele daleꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Leoꞌ na boe, Manetualain naloo lahenda dodouꞌ, tehuu Ana teka-here noi bai anaꞌ fo dadi reuꞌ Ria lahendan.” ");
INSERT INTO rgu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lahenda Farisi ra ramanene Yesus dedea nae leoꞌ na, boe ma ara rala haraꞌ fo nau rahihiiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Boe ma radenu sira ata nara sama-sama ro lahenda reme Herodes partei politik na mai, fo reu ratatane aoꞌ ro Yesus. Ara io Ni rae, “Papa Mesen! Ami bubuluꞌ Papa dale ma roo-tetuꞌ. Papa ta mapuputaꞌ ma ta mete mataꞌ fa. Papa manori-mafada kokosen Manetualain Hara-dasin no matetuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Besaꞌ ia ami nau matane hihii-nanauꞌ esa. Tuka ita agama Yahudi, ami bole bae bea fee mane bau-ina Roma, do taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tehuu Yesus bubuluꞌ ara nau edi-fule Ni, ela Ana dedea soaꞌ mana pareta Roma. Boe ma nataa nae, “Iku a lahenda dea-mataꞌ! Ubeaꞌ taon, de emi nau mahihiiꞌ Au meniꞌ nataneꞌ ria? ");
INSERT INTO rgu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Soba matudu Au doi perak fo riꞌ lahenda bae reniꞌ doi bea nara!” Ara ratudu Ni doi perak esa. ");
INSERT INTO rgu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Boe ma Ana natane si nae, “Ia nana bea potreet na? Ma bea naden ia?” ");
INSERT INTO rgu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ara rataa rae, “Ria nana mane bau-ina Roma.” Boe ma Yesus nafada si nae, “Kalu leoꞌ na, sona emi fee mana pareta hata fo mana pareta haak na. Ma fee Manetualain hata fo Manetualain haak Na.” ");
INSERT INTO rgu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Basa si ramanene Ni nataa nae leoꞌ na, boe ma ara heran, huu fo Ana nafada neuꞌ matetu na. Huu ria na, de ara ta bisa rahihiiꞌ Ana. Boe ma ara laꞌo ela Ni. ");
INSERT INTO rgu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lahenda reme partei Saduki rai naa boe. Lahenda ia ra ranori-rafada rae, lahenda mana mateꞌ ara ta rasoda seluꞌ. Fai ria, ara saka enoꞌ boe, fo nau rahihiiꞌ Yesus. Huu ria na, de ara mai ratatane aoꞌ ro Ni rae, ");
INSERT INTO rgu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Papa Mesen! Baꞌi Musa duiꞌ ela ami hadas ia nae: maneniko touꞌ esa mate ela sao na, tehuu anaꞌ taꞌa, sona touꞌ ria fadi na muste sao na ina falu ria, fo ela boki fee aꞌa mana maten ria tititi-nonosiꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tebe, fai a ulu na baꞌi Musa nanori-nafada nae leo naꞌ, tehuu besaꞌ ia ami sakaꞌ matane leo iaꞌ: toranoo touꞌ hitu. Uluꞌ a sao, tehuu maten, ma anaꞌ taꞌa. Boe ma fadiꞌ mana tukaꞌ ria a, sao na seluꞌ ina falu ria. ");
INSERT INTO rgu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta doo bea boeꞌ te mate ni, ma anaꞌ taꞌa. Leoꞌ na boe neuꞌ fadi katelu a; sao na ina falu ria, tehuu mate ni, ma anaꞌ taꞌa boe. Leo-leo na losaꞌ fadi mateꞌa-teisusuꞌ a, boe mate ni. ");
INSERT INTO rgu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mateꞌe na boeꞌ ma ina falu ria mate ni. ");
INSERT INTO rgu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Besaꞌ ia ami sakaꞌ matane leo iaꞌ: inaꞌ ria parnaa sao touꞌ hitu so. Maneniko dae-bafoꞌ a noe, boe ma Manetualain fee lahenda mana mateꞌ ara rasoda seluꞌ, sona inaꞌ ria dadi neuꞌ bea sao ina na?” ");
INSERT INTO rgu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus nataa si nae, “Maneniko emi matane leo naꞌ, sona emi sala ria so! Huu fo emi ta bubuluꞌ Manetualain Susura Makamoi Na isi-liin. Ma emi ta bubuluꞌ Ria kuasa kahere Na! ");
INSERT INTO rgu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matetu na, leo iaꞌ. Maneniko Manetualain fee lahenda mana mateꞌ ara rasoda seluꞌ, sira boe ta sao soꞌ, sama leoꞌ Ria eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma Au boe sakaꞌ dedea laꞌe-neuꞌ lahenda mana mateꞌ ara rasoda seluꞌ, do taꞌa. Nai baꞌi Musa susura na, hapu tutuiꞌ ai huu anaꞌ fo ai-pilaꞌ a naa ni, tehuu ta putun fa. Neme tutuiꞌ ria mai ita bubuluꞌ tae, lahenda mana mateꞌ a bisa nasoda seluꞌ. Huu fo Manetualain nafada baꞌi Musa nae, ");
INSERT INTO rgu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au ia, nana o baꞌi mara Manetualain na. Siꞌ baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Basa si doꞌo-tabe raroo Au losaꞌ besaꞌ ia.’ Ita bubuluꞌ tae, tepoꞌ fo Manetualain dedea leo naꞌ, baꞌi sira mate si dooꞌ a so. Tehuu Manetualain nae Ria bei dadi neuꞌ sira Ramatuan laꞌo naroo. Huu ria na, de ita bubuluꞌ tae, sira sumane nara rasoda raroo, leo mae mate si dooꞌ a so. De leo mae lahenda mate, tehuu ana nasoda seluꞌ. Huu fo noi lahenda masodaꞌ a riꞌ doꞌo-tabe Manetualain, ta lahenda mana mateꞌ a fa, hete?” ");
INSERT INTO rgu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lahenda Saduki ra ramanene Yesus nanori-nafada leo naꞌ, boe ma ara ta bisa balas hata-hata esa boeꞌ. Tehuu lahenda kadodouꞌ sira heran, ma beidea rae, “Ae! Lahenda ia nanori-nafadan talalu kahereꞌ, oo!” ");
INSERT INTO rgu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lahenda Farisi ra ramanene rae, Yesus naseki lahenda Saduki ra, boe ma ara rame-rame rabua fo nau ratatane aoꞌ ro Ni. ");
INSERT INTO rgu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sira lahenda malela agaman esa nahihiiꞌ soba Ni nae, ");
INSERT INTO rgu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Papa Mesen! Au sakaꞌ atane leo iaꞌ: ami atoran hadas, ma agama a pareta nara, dodouꞌ naan seli. Neme basa baꞌi Musa pareta nara, bea riꞌ penting naan seli?” ");
INSERT INTO rgu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ana nataa ni nae, “Nai Manetualain Susura Makamoi Na daleꞌ, pareta fo penting naan seli a, nae leoꞌ ia: ‘Manetualain nana, emi Manetualain ma. De, emi muste sue-lai Ni lena heni basa-basan. Huu ria na, emi muste mahiiꞌ maroo Ni, bubulu-malelaꞌ Ana, moi-tao mahere tuka Ria hihii-nanaun.’ ");
INSERT INTO rgu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Pareta ria, riꞌ penting ma kahereꞌ naan seli! ");
INSERT INTO rgu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma pareta kadua riꞌ nae leoꞌ ia: ‘O muste sue-lai lahenda fekeꞌ ara, sama leoꞌ o sue-lai ao-ina heheli ma.’ ");
INSERT INTO rgu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Baꞌi Musa atoran na, ma Manetualain mana nesi mata nara nanori-nafadan katemaꞌ, huu na riꞌ pareta ia ra dua. Lahenda ta bisa tuka pareta fekeꞌ ara fa, kalu ana ta tuka nauluꞌ pareta bau-inaꞌ ia ra dua.” ");
INSERT INTO rgu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Faiꞌ ria lahenda Farisi ra bei rabua nai naa, boe ma Yesus natane natafaliꞌ asa nae, ");
INSERT INTO rgu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Neme fai a ulu na mai Manetualain helu memaꞌ, fee Kristus mai fo poꞌi-tata naa Ria lahenda nara. Tuka emi duduꞌa-aafim, Kristus nana bea tititi-nonosin?” Ara rataa Ni rae, “Ria, nana mane Daud a tititi-nonosin.” ");
INSERT INTO rgu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus dedea seluꞌ nae, “Kalu leoꞌ na sona ubeaꞌ taon, de Manetualain Dula-dale Malalao-malalafu Na nafada mane Daud a fo naloo Kristus nae, ‘Ramatuaꞌ’? Huu fo mane Daud a duiꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Manetualain nafada au Ramatua ka nae, “Mai ia fo matuuꞌ nai Au boboa ona Ka, nai mamana hada-horomata. Neuꞌ ko Au tao a musu-noo mara roi raeꞌ neuꞌ O.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Neme duduiꞌ ria mai, ita bubuluꞌ tae, mane Daud a riꞌ naloo Kristus nae ‘Ramatuaꞌ’. De maneniko lahenda rae Kristus nana, noi mane Daud a tititi-nonosin, sona bei ta dai! Huu fo Ria boe mane Daud *a Ramatua na!” ");
INSERT INTO rgu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lahenda Farisi ra ramanene Yesus dedea nae leoꞌ na, boe ma roi ramakokoaꞌ a, huu fo ta hapu lahenda esa bisa nataa Yesus boeꞌ. De mulai neme faiꞌ ria mai, boe ma ara biiꞌ nataneꞌ a, ma ta raparani rahihiiꞌ Ana soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Boe ma Yesus nanori-nafada ana mana tuka dea nara, sama-sama roo lahenda kadodouꞌ fo riꞌ tuka si. ");
INSERT INTO rgu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ana nafada nae, “Mesen agama, ma lahenda Farisi ra homu haak fo ranori-rafada baꞌi Musa atoran ara. ");
INSERT INTO rgu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huu ria na, de emi muste mamanene si ma tuka sira nanori-nafadan. Tehuu bosoꞌ tuka hata fo sira taon, nana huu ara ta tao tuka nanori-nafada nara fa. ");
INSERT INTO rgu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ara tao basa-basan, fo ela lahenda io si. Conto leo-leoꞌ: hata esa fo riꞌ Manetualain Hara-dasin manadui nai daleꞌ, lahenda Yahudi ra heken neuꞌ sira lakan, ma lima nara. Tehuu sira Farisi ra nuu nara tao si bau lena, fo ela lahenda io si rae, ‘Ae! Sira lahenda makamoiꞌ, oo!’ ");
INSERT INTO rgu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ara tao basa-basan, fo ela lahenda io si. Conto leo-leoꞌ: hata esa fo riꞌ Manetualain Hara-dasin manadui nai daleꞌ, ara heken neuꞌ sira lakan, ma lima nara. Tehuu sira nuu nara tao si bau lena, fo ela lahenda io si rae, ‘Ae! Sira lahenda makamoiꞌ, oo!’ ");
INSERT INTO rgu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Maneniko ara leo uma mamasoꞌ daleꞌ reu, do reu raa feta, ara saka mamana natuu malole inaꞌ, fo ela lahenda dodouꞌ rita si. ");
INSERT INTO rgu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Maneniko leo pasar reu, sona ara saka noi hada-horomata, ara saka noi lahenda doꞌo si rae, ‘Soda-moleꞌ, papa mesen hada-horomata.’ ");
INSERT INTO rgu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tehuu emi bosoꞌ tuka sira tataon ria! Ta bole lahenda raloo emi rae, ‘papa mesen’, huu fo emi Mesen ma noi esaꞌ a. Ma emi basa nana, toranooꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Bosoꞌ io lahenda nai dae-bafoꞌ ia mae, ‘papa’, huu fo emi Papam noi esaꞌ a nai nusatetu-ikutemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lahenda ta bole ralao emi rae, ‘malaka’ huu fo emi Malakam noi esaꞌ a, riꞌ Au ia emi Ramatuam fo neme fai a ulu na Manetualain helu memaꞌ, nau fee Ni mai. ");
INSERT INTO rgu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Huu ria na, de Au afada emi ta bole madedema ao mara sama leoꞌ lahenda mana saka hada-horomata sira. Neme emi bea mai nau dadi lahenda bau-inaꞌ, ria muste dadi sama leoꞌ ata fo nalalau lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Huu fo lahenda bea natutua-nadedema aon, neuꞌ ko Manetualain natuda ni. Tehuu lahenda bea naloe-nade aon, neuꞌ ko Manetualain soꞌu-fua ni.” ");
INSERT INTO rgu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Boe ma Yesus dedea naroo nae, “Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi hapu soe, huu fo emi ta nau mamahere Au, Lahenda fo riꞌ Manetualain helu memaꞌ, nau feen mai. Ma tadalu lena bali, emi matabaa ma lahenda ela bosoꞌ ramahere Au. Huu ria na, de ara ta bisa dadi reuꞌ Manetualain lahenda Na. ");
INSERT INTO rgu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi hapu soe, nana huu emi mapuputaꞌ ina falu ra, fo malea ma uma nara. Tehuu nai lahenda dodouꞌ matan, sona emi mapoti etu tadalu mara, mapadei hule-haradoi doo naa seli, ela lahenda rae emi dale mara makamoiꞌ. Tehuu neuꞌ ko Manetualain fee emi huhukuꞌ mabera ina. ");
INSERT INTO rgu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi hapu soe, huu fo emi saꞌe ofaꞌ sudi leo beaꞌ meu, ma onda-ae leteꞌ, fo saka noi lahenda esa, ela ana masoꞌ leo emi partei agama ma daleꞌ neu. Tehuu maneniko ana masoꞌ dadi neuꞌ Farisi, sona nonoi-tataon dadi tadalu lena bali. Neuꞌ ko ana hapu huhukuꞌ nai naraka bera lena laiꞌ dua neme emi mai. ");
INSERT INTO rgu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ae! Emi dale pokeꞌ, tehuu ubeaꞌ taon de emi bei nau matudu enoꞌ fee lahenda fekeꞌ bali? Neuꞌ ko emi hapu soe, nana huu emi manori-mafada mafararaꞌu mae, ‘Maneniko lahenda tao hehelu-barataaꞌ pake sosoo-susupaꞌ ma seseiꞌ Uma Mamaso Yahudi Ina a, sona lahenda ria ta nanahekeꞌ no hehelu-barataa na. Tehuu maneniko ana tao hehelu-barataaꞌ pake sosoo-susupaꞌ ma seseiꞌ lilo pilas fo nai Uma Mamasoꞌ daleꞌ, sona besaꞌ ko ana nanahekeꞌ no hehelu-barataa na.’ ");
INSERT INTO rgu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Emi lahenda pakanaaꞌ! Manetualain tao lilo pilas a neu hata ta penting lena neme Ria Uma Mamaso Yahudi Ina Na. Huu fo Manetualain Uma Mamaso Yahudi Ina Na riꞌ tao na hata ria dadi lalao-lalafuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Emi boe manori-mafada mafararaꞌu mae, ‘Maneniko lahenda tao hehelu-barataaꞌ pake sosoo-susupaꞌ ma seseiꞌ mei tutunu-hohotuꞌ fo riꞌ nai Uma Mamaso Yahudi Ina, sona lahenda ria ta nanahekeꞌ no hehelu-barataa na. Tehuu maneniko ana tao hehelu-barataaꞌ pake sosoo-susupaꞌ ma seseiꞌ tutunu-hohotuꞌ fo riꞌ nai mei lain, sona besaꞌ ko ria nanahekeꞌ no hehelu-barataa na.’ ");
INSERT INTO rgu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tebe-tebe emi pokeꞌ. Tantu mei tutunu-hohotuꞌ ria penting lena neme tutunu-hohotuꞌ fo riꞌ nai mei ria lain. Huu fo mei ria lalao-lalafuꞌ nai Manetualain matan, de Manetualain tao na basa tutunu-hohotuꞌ fo rai mei lain boe dadi lalao-lalafuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huu ria na, maneniko lahenda soo-supa ma seseiꞌ mei tutunu-hohotuꞌ a, sona malole lenaꞌ seseiꞌ mei ria, ma basa tutunu-hohotuꞌ fo rai mei a lain boe. ");
INSERT INTO rgu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma kalu soo-supa ma seseiꞌ Uma Mamaso Yahudi Ina a, sona malole lenaꞌ seseiꞌ Uma Mamasoꞌ a sama-sama no Manetualain nade Na. Huu fo Ria riꞌ leo-naparasa nai naa. ");
INSERT INTO rgu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma kalu lahenda soo-supa ma seseiꞌ nusatetu-ikutemaꞌ a, sona ria sama leoꞌ ana seseiꞌ Manetualain kadera pareta Na sama-sama no Ria nade Na, huu fo Ria riꞌ natuuꞌ homu pareta nai naa. ");
INSERT INTO rgu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi soe, nana huu emi fee Manetualain babatiꞌ esa neme babatiꞌ sanahulu mai, sona emi malela mara seli no bareken. Emi bareken basan-basan, losaꞌ leo bumbu mara rai emi oka-tinem boe hika-reke si. Conto leo-leoꞌ emi reke lutu-lutu emi darafoo ma, adas maꞌeeꞌ, ma jintan. Sekona te, emi mafarene heni Manetualain atoran penting nara! Huu fo emi ta masoda roo-tetuꞌ fa. Emi ta sue-lai lahenda kasian ara. Ma emi ta masoda tuka maroo Manetualain hihii-nanaun. Malole lenaꞌ emi tuka Manetualain atoran masososa Na dei, besaꞌ ko reke babatiꞌ esa neme babatiꞌ sanahulu mai fee neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Emi dale pokeꞌ, tehuu ubeaꞌ taon de emi bei nau matudu enoꞌ fee lahenda fekeꞌ? Emi tao atoran losa leo lulutu-raraeꞌ a neu, fo madenu lahenda fekeꞌ ara tuka, tehuu Manetualain atoran penting naan seli a, emi ta tukan fa. Sama leoꞌ emi see heni pena-mumuu reme emi oe nininu ma mai. Tehuu banda selaꞌ leo-leoꞌ apa a, emi odo katemaꞌ ana! ");
INSERT INTO rgu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi soe, nana huu emi safe noi bika-mako mara pooꞌ dea nara losa makadidilan tuka emi atoran agamam. Sekona te pooꞌ dale nara kekeoꞌ mesan, neniꞌ emi nonoi-tatao naꞌo, ma tendetuu-dalesala mara. ");
INSERT INTO rgu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lahenda Farisi pokeꞌ emin! makamomoi mauluꞌ dale mara, no ria na bika-mako boe makamoi nai Manetualain matan! ");
INSERT INTO rgu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi hapu soe, nana huu emi sama leoꞌ rates manacet fulaꞌ. Lahenda mete rita dea na, sona malole na seli. Tehuu nai daleꞌ, henuꞌ no lahenda mana mateꞌ a dui-aalun, ma basa maboo puruꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Emi leo naaꞌ boe! Emi mahiiꞌ tao ao mara dadiꞌ lahenda makamoiꞌ. Lahenda mete emi neme deaꞌ mai, sama leoꞌ lahenda dale roos. Sekona te emi dale mara, henuꞌ no hihii-nanauꞌ tadaluꞌ. Huu fo emi dedea fekeꞌ, tao fekeꞌ, ma mafarene heni Manetualain pareta nara. ");
INSERT INTO rgu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ae, emi mesen agama ma lahenda Farisi ra! Emi lahenda dea-mataꞌ! Neuꞌ ko emi hapu soe! Emi tao rates bau-inaꞌ soa-neuꞌ Manetualain mana nesi matan ma paroong matalolole lahenda roo-tetuꞌ ara roo-raten, tehuu emi bei madale tadaluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tehuu emi mae, ‘Uniꞌ ko leo ami masoda tepo leleꞌ esa moo ami bei-baꞌim, tantu ami ta tuka si fo maisa Manetualain mana nesi mata nara.’ ");
INSERT INTO rgu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","No ria na, emi manaku ao mara mae, emi boe tadaluꞌ a sama leoꞌ bei-baꞌi mara. ");
INSERT INTO rgu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","De malole lenaꞌ emi maruꞌu-malosaꞌ ara bei-baꞌi mara tadalun! ");
INSERT INTO rgu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tetebes ara emi tadaluꞌ sama leoꞌ meke manuu rasoꞌ. Bate emi mae Manetualain ta huku emi fa? Tantu Ana tuꞌu emi leo ai-pila naraka daleꞌ meu! ");
INSERT INTO rgu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nenene, ee! Neuꞌ ko Au fee emi Au lahenda nadedenu Kara, ela ara ranori-rafada ma ratudu emi Manetualain eno masoda roo-tetu Na. Tehuu neuꞌ ko emi maisa ruma, ma paku mamate ruma rai ai kakeꞌ. Emi liꞌu-fepa ruma rai uma mamasoꞌ ara daleꞌ, ma ruma bali emi ese-rumu si losaꞌ ara ralai reme kota esa mai leo kota fekeꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Fai a ulu na emi bei-baꞌim naisa Habel. Sekona te ria nana, lahenda dale roos. Emi bei-baꞌim raisa laꞌo raroo lahenda dale roo-tetuꞌ a neme tititi-nonosiꞌ esa leo tititi-nonosi fekeꞌ. Losa leo Sakaria, fo riꞌ Barakia ana na. Ara raisa ni nai Uma Mamaso Yahudi Ina a kintal na, naneneaꞌ mei tutunu-hohotuꞌ. Huu no emi tuka bei-baꞌi mara tadalu na, de emi muste lepa-masaa ma lahenda dale roo-tetuꞌ sira daa na katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tebe! Emi fo riꞌ bei masoda nai besaꞌ ia neuꞌ ko hapu huhukuꞌ, nana huu emi bei-baꞌi mara tao hihii-nanauꞌ tadaluꞌ sira nai fai a ulu na.” ");
INSERT INTO rgu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ae lahenda Yerusalem emin! Emi riꞌ maisa Manetualain mana nesi mata nara, ma pia maisa lahenda nadedenuꞌ fo nau mai tulu-fali emi. No ria na, au leleꞌo emi kose-kose fo leo Au mai, sama leoꞌ manu inaꞌ a nau nasuru-nahapaꞌ ana nara rai dila na daleꞌ. Tehuu emi ta nau fa. ");
INSERT INTO rgu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Huu ria na, Manetualain ta nau tao daleꞌ neuꞌ emi kotam ma Uma Mamaso Yahudi Inam soꞌ. De balahaa-binesaꞌ, te dadi reuꞌ lino-nees. ");
INSERT INTO rgu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nenene matalolole! Ta dooꞌ a soꞌ te emi ta mita Au, tehuu neu ko fai bea ma Au atafali seluꞌ mai, sona emi io-oa Au ia Manetualain Anan. Emi manaku leo naꞌ, besaꞌ ko emi mita seluꞌ Au.” ");
INSERT INTO rgu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Boe ma Yesus sakaꞌ laꞌo ela Uma Mamaso Yahudi Ina a. Ana kalua, boe ma ana mana tuka dea nara mai ratudun Uma Mamasoꞌ ria lole-napun. ");
INSERT INTO rgu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tehuu Ana nataa si nae, “Tebe Uma ia malole na seliꞌ! Tehuu nenene! Ta dooꞌ a soꞌ, te lahenda ra fate heni batu ia ra katemaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus neu natuuꞌ nai lete Saitun. Boe ma ana mana tuka dea nara mai dedea ro noi mesaꞌ Ana rae, “Papa! Soba mafada seluꞌ bisinaaꞌ a Papa dedea ma. Fai hidaꞌ riꞌ Papa matafali mai? Ma tanda nara leo beaꞌ e? Boe ma dae-bafoꞌ a nonoe na leo beaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus nataa si nae, “Manea matalolole ao mara, oo! Fo ela bosoꞌ lahenda tipu-dai ralaꞌ emi. ");
INSERT INTO rgu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Neuꞌ ko lahenda rupaꞌ ara mai fo fapa ara nara rae, ‘Au ia, nana Kristus, Lahenda fo riꞌ Manetualain helu neme uluꞌ mai.’ No ria na, ara tipu-dai lahenda dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maneniko emi mita lahenda ratatiao, do emi mamanene haraꞌ rae, natati aoꞌ nai basa mamanaꞌ ain, sona emi bosoꞌ bii. Huu fo hihii-nanauꞌ rupa leo naꞌ a, muste dadi. Tehuu dae-bafoꞌ a nonoe na bei ta losa fa. ");
INSERT INTO rgu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Neuꞌ ko leo esa natati soaꞌ leo fekeꞌ. Nusaꞌ esa natati soaꞌ nusaꞌ fekeꞌ. Dae natakeko nai basa mamanaꞌ ain. Ma fai laa-roes boe masalae naan seli! ");
INSERT INTO rgu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tehuu basa sira nana besaꞌ ko tanda masososaꞌ, fo natudu nae dae-bafoꞌ a nonoe na naneneaꞌ so. Ria sama leoꞌ inaꞌ fo nameda hedis bobokiꞌ, nana huu ria ledo-fai boboki na naneneaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","De emi muste manea matalolole ao mara! Huu fo neuꞌ ko ara mai ese-rumu raisa emi. Ma neuꞌ ko basa lahenda nusaꞌ ara eteꞌ ao nara ro emi, nana huu emi tuka Au. ");
INSERT INTO rgu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tepoꞌ ria, te lahenda dodouꞌ boꞌe heni ao nara, ma ta nau ramahere Au soꞌ. Ara ramananasaaoꞌ, ma esa naseꞌo esa. ");
INSERT INTO rgu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Neuꞌ ko manatipu-manadaiꞌ ara rae sira nana, Manetualain mana nesi matan. Ma lahenda dodouꞌ ramahere si. ");
INSERT INTO rgu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Neuꞌ ko lahenda ra tadalu nara boe-boe tamba dodouꞌ, losaꞌ ta rasue-ralai ao soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tehuu lahenda fo nanenete losaꞌ mate, tantu Manetualain poꞌi-tata naan. ");
INSERT INTO rgu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huu fo lahenda muste tui-beka Manetualain Tutui Malolen, losa dae-bafoꞌ a buku nara, fo ela basa lahenda bisa ralelaꞌ Manetualain eno masoda roo-tetu Na. Basa ria, besaꞌ ko dae-bafoꞌ a noe.” ");
INSERT INTO rgu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus dedea naroo nae, “Manetualain mana nesi matan Danial duiꞌ laꞌe-neuꞌ lahenda makaresiꞌ esa. Neuꞌ ko ana masoꞌ neu napadei nai mamana luli nai Manetualain Uma Mamaso Yahudi Ina na. De ana tao nakekeo-nakakanu mamanaꞌ ria. Huu ria na, Manetualain foa ela mamanaꞌ ria. Maneniko emi mita leo naꞌ, sona besa-besa, oo! (Bea riꞌ lees duduiꞌ ia, muste bubulu-nalelaꞌ natalolole!) ");
INSERT INTO rgu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Huu fo ria dadi tanda nae, fai susa-lela a nai lelesu bafaꞌ a so. Maneniko lahenda rai propensi Yudea rita leoꞌ na, sona ara ralai leteꞌ reu leo. ");
INSERT INTO rgu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Maneniko bea kalua neme uma mai, sona bosoꞌ fali neu hai hata bali. Nalale fo nalaiꞌ, ela bosoꞌ hapu soe. ");
INSERT INTO rgu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lahenda fo nai oka-tine, bosoꞌ fali hai lafa hanas bali. Nalai naroo leo! ");
INSERT INTO rgu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ina kairus ara, ma ina anutu ra kasian raan seli. Huu fo ara ta ralai rala fa. ");
INSERT INTO rgu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","De, malole lenaꞌ emi hule-haradoi fo ela soe ria, bosoꞌ naraa laꞌe fai uda, do fai mamasoꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Huu fo fai ria susa na masalae naan seli! Mulai neme Manetualain adu dae-bafoꞌ a losaꞌ besaꞌ ia, lahenda bei ta parnaa nita susa bau-ina rupa leo naꞌ. Ma neuꞌ ko lahenda ta nita seluꞌ susa rupa leo naꞌ a soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tehuu emi maua-manale maan seli, huu fo Manetualain tao eetu fai ria. Kalu taꞌa, sona ta hapu lahenda esa bisa nasoda boeꞌ. Tehuu no Manetualain sue-lai Ria lahendan teteka-hehere nara, de Ana tao eetu fai susa sira. ");
INSERT INTO rgu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Maneniko fai sira losa, sona emi mamanene lahenda rae, ‘Mete dei! Kristus nai ia!’ Ma lahenda fekeꞌ rae, ‘Kristus nai ele!’ Tehuu emi bosoꞌ mamahere! ");
INSERT INTO rgu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Huu fo neuꞌ ko lahenda kalua ma fapa ara na nae, ‘Au ia, Kristus!’ Ma fekeꞌ a bali nae, ‘Au ia, Manetualain mana nesi matan.’ Neuꞌ ko ara tao tanda heran rupaꞌ ara pake nitu a kuasa na, fo rapuputaꞌ lahenda. Ara soba tipu-dai Manetualain lahenda nara! ");
INSERT INTO rgu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","De emi muste manea matalolole ao mara! Fai susa sira bei ta losa fa, tehuu Au afarereneꞌ memaꞌ fee emi so! ");
INSERT INTO rgu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Maneniko lahenda rafada emi rae, ‘Kristus nai moo loan ele!’ sona emi bosoꞌ leo naꞌ meu. Ma kalu ruma rae, ‘Kristus nai uma ia daleꞌ!’, sona emi bosoꞌ mamahere sira napuputan. ");
INSERT INTO rgu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Huu fo Au ia, Ana Lahenda. Maneniko Au atafali seluꞌ leo dae-bafoꞌ ia mai, neuꞌ ko basa lahenda rita Au, sama leoꞌ lahenda rita relas a nahate neme dulu mai losa muri neu. ");
INSERT INTO rgu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maneniko Au atafali mai, neuꞌ ko emi bubuluꞌ Au nai bea. Sama leoꞌ lahenda bubuluꞌ rae, maneniko manupui mana naa poporaꞌ ara rabubuta rai mamanaꞌ esa, sona tantu hapu poporaꞌ nai naa.” ");
INSERT INTO rgu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Boe ma Yesus nafada selu ana mana tuka dea nara nae, “Maneniko basa fai susa-lela sira, ‘Neuꞌ ko ledo a dadi maiuꞌ, bulaꞌ a boe ta nahaa. Ruuꞌ ara ramomonuao reme lalai mai, ma basa-basa kuasa rai lalai liuaari.’ ");
INSERT INTO rgu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Boe ma basa lahenda ra rita tanda nai lalai rae, Ana Lahenda a sakaꞌ natafali mai. Basa lahenda nusaꞌ nai dae-bafoꞌ ia rita leoꞌ na, boe ma bii losaꞌ ara dola. Huu fo neuꞌ ko Au onda mai oo oaꞌ a, besaꞌ ko ara rita Au kuasa Ka ma Au marela-masaꞌa kara katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Faiꞌ fo fufuuꞌ a nalii bau-inaꞌ, boe ma Au pareta Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a, reu rabubua basa Au lahenda teteka-hehere kara reme dae-bafoꞌ a buku nara mai, neme dulu losa muri; ma neme ii losa ona.” ");
INSERT INTO rgu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Au hai conto neme ai huuꞌ a. Maneniko doo na mulai mofa, ria natudu tanda nae, fai hanas a naneneaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Leoꞌ na boe, kalu emi mita fai susa-lela sira mai, sama leoꞌ bisinaaꞌ a Au afada a, ria natudu tanda nae, Au mamai Ka naneneaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Besaꞌ ia, nenene matalolole! Neme basa lahenda fo rasoda nai besaꞌ ia, neuꞌ ko ruma bei ta mate fa, te fai susa-lela sira mai so. ");
INSERT INTO rgu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Leo mae lalai ma dae-bafoꞌ sapu-lalo, tehuu Au Dedea-nafada Ki natea-namepe ma ta moi-mosa.” ");
INSERT INTO rgu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ta hapu lahenda bubuluꞌ fai hidaꞌ Au atafali mai. Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a boe ta bubuluꞌ. Au boe ta bubuluꞌ. Noi Au Papa Ka riꞌ bubuluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Huu fo Au ia, Ana Lahenda. Maneniko Au atafali mai, ria sama leoꞌ fai a ulu na tepoꞌ fo Noh bei nasoda. ");
INSERT INTO rgu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Faa ina ria bei ta mai fa, te lahenda raa-rinu mina-malada, ma rasao aoꞌ sama leo biasa na. Ara tao leo naꞌ raroo losaꞌ Noh masoꞌ leo ofa bau-inaꞌ ria daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tehuu tepoꞌ fo faa ina a mai de lepa neni katemaꞌ asa, besaꞌ ko mata nara radilaꞌ, de bubuluꞌ mana dadi ubeaꞌ ria. Neuꞌ ko Au mamai Ka boe leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tepoꞌ ria kalu lahenda dua roi nonoiꞌ nai okaꞌ, kekeneu te Manetualain noo esa, tehuu fekeꞌ a sona Ana foa elan. ");
INSERT INTO rgu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maneniko inaꞌ dua rapau hade, kekeneu te, Manetualain noo esa, tehuu fekeꞌ a sona Ana foa elan. ");
INSERT INTO rgu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Huu ria na, emi boe muste manea hatu-leledon, huu fo emi ta bubuluꞌ mae fai hidaꞌ emi Ramatua ma natafali mai. ");
INSERT INTO rgu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Afi matalolole! Kalu uma ramatuaꞌ a bubuluꞌ nae selubaiꞌ hatu na naꞌo a sakaꞌ mai, sona tantu ana nanea naroo, fo ela naꞌo a bosoꞌ masoꞌ leo uman daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","De emi boe muste sadia. Huu fo Au natafali mai Ka, noi nakekeꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesus dedea tamba nae, “Emi muste dadi sama leoꞌ ata fo riꞌ tuka naroo ria malaka na hihii-nanaun. Maneniko malaka na sakaꞌ leo dae dooꞌ neu, ana soꞌu ata leo naꞌ, fo urus basa uma isiꞌ a nanaa-nininun katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maneniko ramatua na fali ma nita ria ata na noi-tao natalolole, tantu dale na namahoꞌo no lahenda ria. ");
INSERT INTO rgu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mamahere Au, huu fo neuꞌ ko malaka ria fee ata a kuasa fo urus ria hata-heton katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tehuu maneniko ata ria tadaluꞌ a, tantu ana dedea nai dale na nae, ");
INSERT INTO rgu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Malole a! Malaka a laꞌo so, bea bubuluꞌ nae fai hidaꞌ ana fali, oo!’ Afi nae leoꞌ na, boe ma ana mulai popoꞌo tia-lain ata fekeꞌ ara. Ma ana natuuꞌ naa-ninu mina-malada sama-sama no mana mafuꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tehuu ta bubuluꞌ fa, kekeneu te malaka na fali main. ");
INSERT INTO rgu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Boe ma malaka ria ese-rumu naan seli, basa te tuꞌun leo deaꞌ neu, fo ana leo sama-sama no lahenda dea-mataꞌ ara. Nai mamanaꞌ ria, basa si dola-ramatani, nana huu ara doidoso raan seli.” ");
INSERT INTO rgu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Boe ma Yesus tuti seluꞌ dedea Na nae, “Emi muste mahehere ao mara fo sipoꞌ Au natafali mai Ka, sama leoꞌ nasasamaꞌ ia. Leo iaꞌ: hatuꞌ esa boe ma ana fetoꞌ sanahulu reni dedede anaꞌ, kalua reu sipoꞌ mana kabi touꞌ a nai sira tia-lain uma na. ");
INSERT INTO rgu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tehuu neme sira sanahulu mai, lima pakanaaꞌ, ma lima malelaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pakanaaꞌ limas rafarene henin, de ta reni mina lenaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tehuu malelaꞌ limas, sona reni memaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Losa uma ria, te mana kabi touꞌ a bei ta mai boeꞌ. Doo-doo boe ma ana fetoꞌ sira teauꞌ, de suku renin. ");
INSERT INTO rgu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Fatilada boe ma kekeneu te ara ramanene lahenda raloo rae, ‘Ae! Mana kabi touꞌ a mai so! Mai fo ita teu sipoꞌ ana leo!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ana fetoꞌ sira ramanene leoꞌ na, boe ma ara foa belaꞌ a, de reu sadia dedede ana nara. ");
INSERT INTO rgu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tehuu ana feto pakanaaꞌ ara dedea ro tia-lai nara rae, ‘Ae, tia kara, ee! Bati fee ami mina baiꞌ dei, te ami dedede mara hii-hiiꞌ mate si!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tehuu ana feto malelaꞌ ara rataa rae, ‘Ae! Bosoꞌ mamanasaꞌ, te ta bisa fa. Huu fo ami mina ma ta dai soa-neuꞌ ita basa! Malole lenaꞌ emi meu asa nai kios.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Boe ma ara reu asa mina. Tehuu ara kalua, boe ma mana kabi touꞌ a losa. De ana feto malelaꞌ ara sama-sama ro mana kabi touꞌ a, ma basa fui ra masoꞌ leo mamana feta a daleꞌ reu. Basa si masoꞌ rala uma daleꞌ, boe ma lahenda ra ena lelesu a. ");
INSERT INTO rgu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ana feto pakanaaꞌ sira mai, boe ma ara dedelu lelesu a ma raloo rae, ‘Papa! Papa! Soi lelesu a dei!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tehuu ana nataa nae, ‘Ae, ta bisa fa. Huu fo au ta alelaꞌ emi!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Huu ria na, emi boe muste mahehere ao mara ma manea maroo, huu fo emi boe ta bubuluꞌ Au mamai Ka laꞌe fai bea, do liꞌu hida.” ");
INSERT INTO rgu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Boe ma Yesus tui seluꞌ nasasamaꞌ esa nae, “Maneniko Au laꞌo ela emi, sona emi muste moi-tao matalolole soa-neuꞌ Au, sama leoꞌ nasasamaꞌ ia. Leo iaꞌ: malaka esa sakaꞌ leo dae dooꞌ neu. Fai fo ana nahehere aon sakaꞌ laꞌo, naloo na ata nara de pareta si nae, ‘Emi pake doiꞌ ia ra dadi poko. Maneniko au fali, emi muste mafada au, emi onto hida.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Boe ma ana fee ata nara doi lilo pilas fo rabubunaꞌ asa. Ana fee ata masosoaꞌ a doi lilo pilas saku lima, ata kadua a saku dua, ma ata katelu a saku esa, tuka sira esa-esaꞌ ko bebeꞌi-baraain. Boe ma ana leo dae dooꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ata sira sipo ra doiꞌ ara, boe ma ata masososaꞌ a kalua tutiꞌ a neu dagan. Ta doo bea boeꞌ, te ana onto doiꞌ saku lima. ");
INSERT INTO rgu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Leoꞌ na boe ata kadua a. Ana onto doiꞌ saku dua bali. ");
INSERT INTO rgu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tehuu ata katelu fo riꞌ sipo doiꞌ saku esa a, ana neu ali boloꞌ, de nafuni malaka na doin ria. ");
INSERT INTO rgu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dooꞌ a, besaꞌ ko malaka ria fali main. Boe ma ana nabubua na ata nara, de mulai parisaꞌ ria doin fo riꞌ ara urus a. ");
INSERT INTO rgu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ata masososaꞌ a masoꞌ mai, ma neni feen doiꞌ saku sanahulu, ana nae, ‘Papa! Ia doi mara. Faiꞌ naa raa papa fee au doiꞌ saku lima. Tehuu besaꞌ ia au onto saku lima bali.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Malaka ria namanene leoꞌ na, boe ma namahoꞌo. Ana nafada nae, ‘Malole! O nana ata malole. O makate nonoi-tataoꞌ, ma o tuka maroo au pareta ka, leo mae au ta nai ia fa. Huu no o bisa urus hihii-nanauꞌ aana leo iaꞌ, neuꞌ ko au soꞌu o fo urus hihii-nanauꞌ bau-inaꞌ. Neuꞌ ko au tao feta fo ita basa tamahoꞌo rame-rame.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Boe ma ata kadua a mai neni fee malaka na doiꞌ saku haa ma nae, ‘Papa! Maulu na papa fee au doiꞌ saku dua. Mitaꞌ au onto doiꞌ saku dua bali.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Malaka ria boe namahoꞌo. Ana nafada nae, ‘Malole! O boe, ata malole. O makate nonoi-tataoꞌ, ma o tuka maroo au pareta ka, leo mae au ta nai ia fa. Huu no o bisa urus hihii-nanauꞌ aanaꞌ leo iaꞌ, neuꞌ ko au soꞌu o ela urus hihii-nanauꞌ fo bau lena ia bali. Neuꞌ ko au tao feta fo ita basa tamahoꞌo rame-rame.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Basa de ata katelu a mai. Boe ma ana nafada nae, ‘Papa! Au bubuluꞌ papa nana lahenda ta namiminaꞌ fa. Nana huu papa a hai hata fo lahenda fekeꞌ tao, ma etu-oru hata fo lahenda fekeꞌ sele-tande. ");
INSERT INTO rgu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Au biiꞌ, bosoꞌ losa doiꞌ ia ra mopo si, basa te papa a huku au. Huu ria na, de au afuni atalololen. Ia papa! Hai mafaliꞌ ana leo, te papa a doi saku isem ia tetu-tetu!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Malaka ria namanene leoꞌ na, boe ma nasapaa ni nae, ‘O nana ata tadaluꞌ, ma aomataꞌ! Kalu o bubuluꞌ mae, au hai hata fo lahenda fekeꞌ taon, ma etu-oru hata fo lahenda fekeꞌ sele-tande, ");
INSERT INTO rgu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ubeaꞌ taon de o ta muu peda au doi ka nai bank? Fo ela au fali, sona bisa hapu buna na, leo mae bai anaꞌ, boe malole a!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Boe ma malaka ria nadenu ata feke nara nae, ‘Hai ma doiꞌ sira remeꞌ ana mai, feen leo ata fo riꞌ onto doiꞌ saku lima a. ");
INSERT INTO rgu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te lahenda fo urus natalolole hata fo ana homu a, neuꞌ ko ana hapu tambaꞌ dodouꞌ. Tehuu lahenda fo ta nau urus hata fo ana homu a, neuꞌ ko ara hai raa katemaꞌ asa remeꞌ ana mai. ");
INSERT INTO rgu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hopu ma ata sosoa-raraaꞌ taꞌ ia. Roso menin fo tuꞌun leo deaꞌ neu. Pesin nemeꞌ na ela dola-namatani ma doidoso nai mamana maiuꞌ ele daleꞌ!’ ” ");
INSERT INTO rgu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesus dedea naroo nae, “Au, Ana Lahenda ia, neuꞌ ko onda faliꞌ mai pake Au Papa Ka kuasa marela-masaꞌa Na, sama-sama oo Ria eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a. Boe ma Au atuuꞌ nai kadera mana pareta marela-masaꞌ a Ka lain, ela parisaꞌ basa lahenda masodan. ");
INSERT INTO rgu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Neuꞌ ko basa lahenda fo parnaa rasoda nai dae-bafoꞌ ia, mai rasare Au. Boe ma Au heo heni si, sama leoꞌ mana foo a heo heni bibi-lopo ra reme bibi-kedaeꞌ ara mai, de dadi reuꞌ bubuaꞌ dua. ");
INSERT INTO rgu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Lahenda fo rasoda tuka Manetualain hihii-nanaun, Au fee si reuꞌ boboa ona Ka. Tehuu fekeꞌ ara, Au fee si reuꞌ boboa ii Ka. ");
INSERT INTO rgu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tepoꞌ ria, Au homu pareta sama leoꞌ Maneꞌ. Neuꞌ ko Au afada lahenda fo rai Au boboa ona Ka ae, ‘Emi riꞌ sipo ua-naleꞌ neme Au Papa Ka mai. Masoꞌ daleꞌ mai, leo Ria uman fo riꞌ Ana sadia memaꞌ neme masososa na soa-neuꞌ emi a, ");
INSERT INTO rgu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","nana huu fai fo Au amalaa-aparoe, emi riꞌ fee Au ua. Au maamada-metehedu, emi riꞌ fee Au inu. Au mai sama leoꞌ lahenda dea, tehuu emi sipoꞌ Au nai emi uma mara daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Au ta anuu kakao-papakeꞌ, tehuu emi riꞌ fee Au kakao-papakeꞌ. Au amahedi-aparau, tehuu emi riꞌ mai urus Au. Au nai bui daleꞌ, tehuu emi riꞌ mai dama Au.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Lahenda dale roos fo rai Au boboa ona ka ramanene leoꞌ na, boe ma ara rataa ratafaliꞌ Au rae, ‘Ramatuaꞌ a mae, Ramatuaꞌ mamalaa-maparoe, de ami fee Papa mua. Ramatuaꞌ a maamada-metihedu, de ami fee Papa minu. ");
INSERT INTO rgu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ramatuaꞌ a sama leoꞌ lahenda dea, de ami sipoꞌ Papa masoꞌ leo ami umam daleꞌ mai. Ramatuaꞌ a kakao-papakeꞌ taꞌa, de ami fee. ");
INSERT INTO rgu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ramatuaꞌ a mamahedi-maparau, de ami meu urus. Ramatuaꞌ a nai bui daleꞌ, de ami meu tulu-fali. Tehuu faiꞌ bea riꞌ ami tao hihii-nanauꞌ leo naꞌ ara?’ ");
INSERT INTO rgu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Neuꞌ ko Au ataa si ae, ‘Mamahere Au! Tepoꞌ fo emi tao hata leo naꞌ soa-neuꞌ Au lahendak fo riꞌ toꞌa-taa raan seli, sona emi tao soa-neuꞌ Au ria so!’ ");
INSERT INTO rgu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Boe ma Au afada lahenda fo rai Au boboa ii Ka ae, ‘He, lahenda tadaluꞌ emin! Manetualain kutuk emi so. Maheoꞌ meme iaꞌ mai! Neuꞌ ko Au adenu lahenda reu tuꞌu emi leo ai-pila naraka manabasa taaꞌ a daleꞌ meu. Huu fo Manetualain sadia mamana doidosoꞌ ria soa-neuꞌ nitu ra ro sira malaka bau-ina na. ");
INSERT INTO rgu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Au usi heni emi, nana huu tepoꞌ fo Au amalaa-aparoe, emi ta fee Au ua. Au maamada-metihedu, emi ta fee Au inu. ");
INSERT INTO rgu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au mai sama leoꞌ lahenda dea, tehuu emi ta sipoꞌ Au nai emi uma mara daleꞌ. Au ta anuu kakao-papakeꞌ, tehuu emi ta fee Au kakao-papakeꞌ. Au amahedi-aparau, tehuu emi ta mai urus Au. Au nai bui a, tehuu emi ta mai tulu-fali Au.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lahenda tadaluꞌ sira ramanene leoꞌ na, neuꞌ ko rataa Au rae, ‘Ramatuaꞌ a mae, Ramatuaꞌ a mamalaa-maparoe, tehuu ami ta fee Papa mua. Ramatuaꞌ a maamada-metihedu, tehuu ami ta fee Papa minu. Ramatuaꞌ a sama leoꞌ lahenda dea, tehuu ami ta sipoꞌ Papa masoꞌ leo ami uma mara daleꞌ muu. Ramatuaꞌ a ta manuu kakao-papakeꞌ, tehuu ami ta fee fa. Ramatuaꞌ a mamahedi-maparau, tehuu ami ta meu urus. Ramatuaꞌ a nai bui daleꞌ, tehuu ami ta meu tulu-fali. Tehuu fai hidaꞌ a riꞌ ami tao Ramatuaꞌ a leo naꞌ?’ ");
INSERT INTO rgu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Neuꞌ ko Au ataa si ae, ‘Mamahere Au! Fai fo emi ta tulu-fali lahenda manatoꞌa-manataaꞌ ara, sona ria sama leoꞌ emi ta tulu-fali neuꞌ Au.’ ");
INSERT INTO rgu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Boe ma lahenda tadaluꞌ sira hapu doidosoꞌ raroo losaꞌ doo na neu. Tehuu lahenda dale roos sira, rasoda ro Manetualain losaꞌ doo na neu.” ");
INSERT INTO rgu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus nanori-nafada si basa hihii-nanauꞌ sira katemaꞌ, boe ma Ana nafada ana mana tuka dea nara nae, ");
INSERT INTO rgu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Emi bubuluꞌ, bei faiꞌ dua bali, te ita fai malole na, nana riꞌ Feta Paska. Faiꞌ ria, te neuꞌ ko lahenda seꞌo heni Au, Ana Lahenda ia. Boe ma ara paku raisa Au nai ai kake a.” ");
INSERT INTO rgu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Faiꞌ ria, malaka agama Yahudi malaka nara, ma lasi hadas nara rabua rai Kayafas uman. Kayafas nana malaka agama Yahudi malaka bau-ina na. ");
INSERT INTO rgu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ara rasaka enoꞌ nau hopu ramanininoꞌ Yesus, fo raisa Ni. ");
INSERT INTO rgu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tehuu ara ator eno na rae, “Tahani dei! Ita bosoꞌ talale hopu Ni, huu fo fai malole a naneneaꞌ so. Bosoꞌ losa lahenda kadodouꞌ fo rahiiꞌ Ana, tao isu-oteꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Fai ria boe, Yesus asa reu raa-rinu nai lahenda esa uma na, nade Simon, nai koro Betania. Maulu na, lahenda rahiaꞌ Simon, nana huu ana hapu hedis kusta. Tehuu besaꞌ ia teꞌe na aon so. ");
INSERT INTO rgu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tepoꞌ fo ara bei raa-rinu, te inaꞌ esa mai naneta no Yesus. Ana homu neni boto esa, taon neme batu mabeli a mai. Boto ria isi na mina boo meniꞌ teaꞌ mabeli beraꞌ. Inaꞌ a beru natepa boto ria tatana na. Boe ma ana poꞌa mina a feen titi bai-bai nai Yesus laka Na, fo dadi tanda nae ana fee hada-horomata neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tehuu Yesus ana mana tuka dea nara rita inaꞌ ria tao leo naꞌ, boe ma ara ramanasa, de dedearao nara rae, “Ae! Bosoꞌ tuꞌu heni hihiiꞌ mina boo meniꞌ mabeli beraꞌ ria! ");
INSERT INTO rgu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Malole lenaꞌ ana seꞌo mina ria! Fo ela bati doi na, fee lahenda manatoꞌa-manataaꞌ ara!” ");
INSERT INTO rgu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tehuu Yesus bubuluꞌ sira duduꞌa-aafin, boe ma Ana dedea nae, “Emi bosoꞌ tao masususaꞌ inaꞌ ia! Pesin nemeꞌ na! Au amahoꞌo, nana huu ana poꞌa mina boo meniꞌ ia neuꞌ Au ao-ina Ka. ");
INSERT INTO rgu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Huu fo lahenda manatoꞌa-manataaꞌ ara tuka-tuka faiꞌ rai emi talada. Tehuu ta dooꞌ a, te Au ta sama-sama oo emi soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma inaꞌ a poꞌa mina ia neuꞌ Au, nana huu ana sadia na nalaesaꞌ ao-ina Ka, sama leoꞌ poporaꞌ de tao rampe neu. Huu fo Au masoda ka ta dooꞌ a soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mafarene matalolole! Nai mamanaꞌ bea a, maneniko Manetualain Tutui Malole Na tui-bekan rule-feo dae-bafoꞌ ia, tantu sira boe tui inaꞌ ia malole na! Fo ela basa lahenda ra rafarene ni.” ");
INSERT INTO rgu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lahenda esa neme Yesus ana mana tuka dea kasanahulu dua nara, nade Yudas Iskariot. Faiꞌ ria boe, ana kalua neu saka malaka agama Yahudi malaka nara, fo nau fee heni Yesus leo sira lima nara neu. ");
INSERT INTO rgu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ana losa, boe ma natane si nae, “Papa kara, ee! Kalu au fali emi fo hopu Yesus, sona emi fee au ubeaꞌ?” Ara rataa rae, “Kalu o nau seꞌo heni Ni fee ami, sona ami bae.” Boe ma ara reke ra doi perak telu hulu fo fee Yudas. ");
INSERT INTO rgu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yudas kalua, boe ma ana mulai saka enoꞌ fo nau fee heni Yesus leo sira neu. ");
INSERT INTO rgu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tuka-tuka teuꞌ, lahenda Yahudi ra fai malolen fo riꞌ fetan faiꞌ hitu lalaꞌen. Ara hule fai malole ria rae, ‘Feta Roti Ta Pake Ralu Teteiꞌ’. Fai fo sakaꞌ mulai feta Paska ria, boe ma Yesus ana mana tuka dea nara mai ratane Ni rae, “Papa! Hatun ia ita muste buka ita fai malole na. De Papa nau ami meu hala bibi-lopo, ma sadia mamana feta Paska nai bean?” ");
INSERT INTO rgu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ana nataa nae, “Emi leo kota daleꞌ meu, neuꞌ ko maneta mo touꞌ esa. Mafadan mae leo iaꞌ, ‘Aꞌa, ee! Papa Mesen nameda na ta doo a so te Ana maten. Ana hule mamanaꞌ nai aꞌa uma na, ela Ana paken fo tao feta Paska no Ria ana mana tuka dea nara.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ana mana tuka dea nara ramanene leoꞌ na, boe ma ara tao tuka Ria dedea Na, de ara sadia raa feta Paska nai naa. ");
INSERT INTO rgu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nahatu, boe ma Yesus no ana mana tuka dean sanahulu duas ratuuꞌ raa feta. ");
INSERT INTO rgu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ara raa, boe ma Ana dedea nae, “Emi nenene! Neme emi mai, neuꞌ ko esa riꞌ naseꞌo heni Au leo lahenda fekeꞌ ara uu.” ");
INSERT INTO rgu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ara ramanene leoꞌ na, boe ma dale nara susa. De sira esa-esa ratane Yesus rae, “Lahenda fo riꞌ Papa dedea ria a ta au fa, hete?” ");
INSERT INTO rgu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ana nataa nae, “Lahenda fo naboro roti na leo mako ia daleꞌ neu sama-sama no Au, ria riꞌ neuꞌ ko naseꞌo heni Au. ");
INSERT INTO rgu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mafarereneꞌ! Au, Ana Lahenda ia, muste mate sama leoꞌ ara duiꞌ memaꞌ nai Manetualain Susura Makamoi Na daleꞌ. Tehuu besa-besa! Lahenda fo sakaꞌ seꞌo heni Au, neuꞌ ko lepa na ria soe na! Malole lenaꞌ kalu mama na ta boki ni fa.” ");
INSERT INTO rgu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas boe natane nae, “Tantu lahenda fo Papa mafada a, ta au fa, hete?” Yesus nataa nae, “Tebe o riꞌ mafada mae leo naꞌ. Te bea bali?” ");
INSERT INTO rgu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ara bei raa, boe ma Yesus hai na roti baloꞌ esa, de hule makasi neuꞌ Manetualain. Ana tetebi roti ria, de loo fee ana mana tuka dea nara, ma nafada nae, “Roti ia, nana Au ao-paa Ka. Emi hai maan fo mia leo!” ");
INSERT INTO rgu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Basa de Ana hai na galas esa henuꞌ no oe anggor, boe ma Ana hule makasi neuꞌ Manetualain. Ana loo fee ana mana tuka dea nara, ma nafada nae, “Emi basa hai maan fo minu. ");
INSERT INTO rgu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Huu fo oe anggor ia, nana Au daa Ka. Neuꞌ ko Au mate, Au daa Ka faa ela poꞌi-tata naa lahenda dodouꞌ reme basa sala-siko nara mai. Au Daa Ka besaꞌ ia natetu na hata fo Manetualain helu memaꞌ nemeꞌ fai a uluꞌ na mai. Hai maan fo minu leo! ");
INSERT INTO rgu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tehuu nenene matalolole! Mulai neme hatun ia mai, Au ta inu oe anggor soꞌ. Neuꞌ ko Au oo Papa Ka nai nusatetu-ikutemaꞌ matuuꞌ fo homu pareta, sona besaꞌ ko Au inu oo emi bali.” ");
INSERT INTO rgu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Boe ma ara soda sosodaꞌ esa fo io-oa Manetualain. Hatun ria boe, ara kalua leo lete Saitun reu. ");
INSERT INTO rgu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ara laꞌo, boe ma Yesus nafada memaꞌ ana mana tuka dea nara nae, “Neuꞌ ko hatun ia, emi basa malai ela Au. Huu fo ara duiꞌ memaꞌ nai Manetualain Susura Makamoi Na nae, ‘Neuꞌ ko Manetualain naisa mana foo a, de bibi-lopo nara ralai kofela.’ ");
INSERT INTO rgu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tebe Au mate. Tehuu maneniko Au asoda seluꞌ, sona Au uu ahani emi nai propensi Galilea.” ");
INSERT INTO rgu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tehuu Petrus nadedea laka nae, “Leo mae lahenda fekeꞌ ara basa si ralai ela Papa, tehuu au sona taꞌa!” ");
INSERT INTO rgu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus nataa nae, “Petrus! Leoꞌ na do? Mamahere Au! Hatun ia, manuꞌ a bei ta koko-oa fa, te o mafada laiꞌ telu so, mae o ta malelelaꞌ Au!” ");
INSERT INTO rgu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tehuu Petrus nafada teteaꞌ nae, “Papa! Maneniko Papa mate, au boe mate sama-sama. Au ta alai ela Papa fa!” Petrus nonoo feke nara boe esaꞌ ko nafadaꞌ aon nae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Boe ma Yesus asa laꞌo raroo leo lete Saitun reu, ara losa okaꞌ esa, nade Getsemani. Nai naa, Ana nafada ana mana tuka dea nara nae, “Emi matuu mahani ia dei, huu fo Au sakaꞌ uuꞌ ele hule-haradoi.” ");
INSERT INTO rgu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tehuu Ana naloo no Petrus, Yakobis, ma Yohanis, fo telu si sama-sama ro Ni reu. Mulai neme oras ria mai, boe ma dale Na susa ma ta tama soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ara laꞌo raola baiꞌ, boe ma Ana nafada si nae, “Au dale Ka susa naan seli! Au ameda aan nonooꞌ nae Au sakaꞌ mate. Emi matuuꞌ maiꞌ ia, ma manea mo Au.” ");
INSERT INTO rgu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ana lali dooꞌ a bai anaꞌ leo mata neu, boe ma sundaꞌ undulaka Na fo hule-haradoi nae, “Papa manasue-manalai! Kalu Papa mataa, sona bosoꞌ Au lepa-asaa doidosoꞌ ia. Tehuu bosoꞌ tuka Au hihii-nanau Ki; ela tuka noi Papa hihii-nanaum.” ");
INSERT INTO rgu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ana hule-haradoi basa, boe ma fali leo ana mana tuka dean sira telu neu. Tehuu ara suku ramanee. Ana fafae nafoa si, boe ma Ana dedea no Petrus nae, “Ae, Petrus ee! Ubeaꞌ taon, de emi suku? Au nai naa noi hatemataꞌ, tehuu emi ta bisa manea baiꞌ boeꞌ! ");
INSERT INTO rgu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Madidilaꞌ mata mara dei, ma foa fo manea mo Au! Huu fo tebe emi dale mara rahiiꞌ tao malole, tehuu ao-paaꞌ a ta nabeꞌi fa. De malole lenaꞌ hule-haradoi, fo ela maneniko emi hapu sosobaꞌ boe oo, bisa manenete.” ");
INSERT INTO rgu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Boe ma Ana neu hule-haradoi seluꞌ nae, “Papa! Maneniko Au riꞌ muste lepa-asaa doidoso ia, sona ela tuka Papa hihii-nanaum.” ");
INSERT INTO rgu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hule-haradoi basa, boe ma Ana fali leo ana mana tuka dean sira telu neu. Tehuu ara suku seluꞌ bali, huu fo mata nara rambera. ");
INSERT INTO rgu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ana foa ela si, de neu hule-haradoi seluꞌ laiꞌ esa bali. Boe ma Ana hule seluꞌ Papa Na, fo bosoꞌ nataaꞌ Ana lepa-nasaa doidoso ria, tehuu ela tuka noi Papa hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hule-haradoi basa, boe ma Ana fali neu fafae ana mana tuka dea nara nae, “Emi bei suku maroo, do? Foa leo! Te lahenda fo riꞌ nau seꞌo heni Au, Ana Lahenda, naneneaꞌ so. Besaꞌ ia ara nau hopu ra Au, fo fee heni Au leo lahenda tadaluꞌ ara lima nara. ");
INSERT INTO rgu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Foa leo! Madidilaꞌ mata mara fo soba mete leo eleꞌ meu dei! Te lahenda fo riꞌ seꞌo heni Au a, ana mai so.” ");
INSERT INTO rgu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus bei dedea nae leo naꞌ, te Yudas no lahenda dodouꞌ mai so. Ara reni tafaꞌ, ma ai tutukuꞌ, fo sakaꞌ hopu Ni. Ara tao leo naꞌ, tuka pareta neme malaka agama Yahudi malaka nara, ma lasiꞌ hadas ara. ");
INSERT INTO rgu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas nafada memaꞌ asa nae, “Emi mete matalolole, ee! Au deꞌi lahenda bea, sona emi hopu maan leo! Huu fo emi saka lahenda a nana, ri naꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ara losa Yesus, boe ma Yudas laꞌo naroo mata Na neu, ma nae, “Soda-moleꞌ, Papa Mesen!” Boe ma Yudas holu Ni ma deꞌi. ");
INSERT INTO rgu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus natane ni nae, “Yudas! O holu ma deꞌi Au nana sosoa na riaꞌ, do?” Boe ma lahenda kadodouꞌ sira tuturu mata reu, fo nau hopu Ni. ");
INSERT INTO rgu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kekeneu te, Yesus ana mana tuka dean esa lesu na tafa na, de tati naetu lahenda esa ridoo na. (Lahenda fo riꞌ hapu hinaꞌ a, nana malaka agama Yahudi malaka bau-inaꞌ a ata na.) ");
INSERT INTO rgu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus nita leoꞌ na, boe ma nafada ni nae, “Sodoꞌ faliꞌ tafa ma neuꞌ mana na. Huu fo lahenda bea nai masoda na naminaꞌ tafaꞌ, neuꞌ ko raisan reniꞌ tafaꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O ta bubuluꞌ fa, do? Au bisa hule Papa Ka fo fee Ria eilaꞌo-limalopen rifu-natun reme nusatetu-ikutemaꞌ a mai, ela ara tulu-fali Au. ");
INSERT INTO rgu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tehuu bosoꞌ. Nemeꞌ na, fo ela lahenda ia ra hopu ra Au. Huu fo basa-basan manaduiꞌ memaꞌ nai Manetualain Susura Makamoi Na laꞌe-neuꞌ Au a, muste dadi.” ");
INSERT INTO rgu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Boe ma Yesus dedea no lahenda fo riꞌ mai hopu Ni nae, “Bate emi mae Au ia lahenda tadaluꞌ, de emi mai hopu Au meniꞌ tafaꞌ ma ai tutukuꞌ. Sekona te, tuka-tuka faiꞌ Au anori-afada emi nai Manetualain Uma Mamaso Yahudi Ina Na, tehuu ta hapu lahenda esa tao Au leoꞌ bea boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tehuu nemeꞌ na! Mai, hopu ma Au leo! Huu fo basa-basa ia ra manaduiꞌ memaꞌ neme uluꞌ mai nai Manetualain Susura Makamoi Na.” Yesus ana mana tuka dea nara rita leoꞌ na, boe ma bii raan seli, de ara ralai ela Ni. ");
INSERT INTO rgu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lahenda sira hopu ra Yesus, boe ma roo Ni leo Kayafas fo riꞌ malaka agama Yahudi malaka bau-ina na uman neu, nana huu lahenda bau-inaꞌ ara tesa rai naa so. Sira nana, malaka agama Yahudi malaka nara, mesen agama ra, ma lasiꞌ hadas ara. ");
INSERT INTO rgu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tepoꞌ fo ara hopu roo Yesus, Petrus boe tuka nafufuniꞌ losa malaka bau-inaꞌ a uma na. Petrus masoꞌ leo kintal daleꞌ neu, de natuuꞌ sama-sama no lahenda fo rai naa. Huu fo ana nau bubuluꞌ neuꞌ ko hata ubeaꞌ dadi. ");
INSERT INTO rgu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nai uma ria daleꞌ, malaka agama Yahudi malaka nara dedearaoꞌ ro basa lahenda fo urus dedea agama. Basa si saka buti fo ela huku ramate Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Leo mae sira ratutuluꞌ sakasii pepekoꞌ dodouꞌ, tehuu ara ta hapu buti esa boeꞌ, fo bisa paken. Mateꞌe na ara hapu lahenda dua sakasii. ");
INSERT INTO rgu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Dua si sakasii rae, “Ami parnaa mamanene Lahenda ia dedea nae, ‘Neuꞌ ko Au fate heni Uma Mamaso Yahudi Ina a. Tehuu nai faiꞌ telu dalen te, neuꞌ ko Au afoa aan seluꞌ.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Malaka agama Yahudi malaka bau-ina na foa napadei neuꞌ basa lahenda matuuꞌ sira mata, boe ma ana natane Yesus nae, “O mamanene lahenda dodouꞌ kolaaꞌ O so. Tehuu ubeaꞌ taon, de O moi neneeꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tehuu Yesus ta nataa hata-hata esa boeꞌ. Boe ma malaka bau-inaꞌ ria natane bali nae, “Au nau atane! Tehuu O muste mataa teteaꞌ sama leoꞌ O mataa neuꞌ Manetualain masodaꞌ nai nusatetu-ikutemaꞌ a. Lahenda rae, O ia nana Kristus, Manetualain Anan fo Ana helu memaꞌ neme fai a ulu na mai a. Tebe, do?” ");
INSERT INTO rgu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus nataa ni nae, “Tebe, sama leoꞌ papa dedea ma. Tehuu mafarereneꞌ! Huu fo neuꞌ ko emi basa mita Au, Ana Lahenda ia. Neuꞌ ko Au atuuꞌ nai nusatetu-ikutemaꞌ a nai Manetualain boboa ona Na, fo homu pareta sama-sama oo Ria fo riꞌ mana kuasa. Boe ma neuꞌ ko Au onda fali mai oo oaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Malaka bau-inaꞌ ria namanene Ni dedea nae leoꞌ na, boe ma namanasa naan seli, de noi siiꞌ badu manaru na. Ana dedea nambera, ma nafada basa lahenda fo ratuu rai naa nae, “Ae! Ita ta parluu mana sakasii soꞌ! Emi mamanene Ria dedea Na so. Ana soꞌu aon dadi neuꞌ Manetualain Anan. Ana namumulu-namamaeꞌ Manetualain ia so! Emi basa bubuluꞌ, tuka ita atoran agama na, maneniko bea tao aon sama no Manetualain, sona lahenda ria muste mate! ");
INSERT INTO rgu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","De besaꞌ ia emi sakaꞌ maetuꞌ mae, leoꞌ bea?” Basa si rataa rambera rae, “Tebe lahenda ia sala! De Ana muste hapu huhuku mamates!” ");
INSERT INTO rgu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Boe ma lahenda hida oruꞌ mata reu fo mudi radiu Yesus ape. Ara popoꞌo ramiminaꞌ Ana ma fapa Ni. ");
INSERT INTO rgu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ara ramumulu-ramamaeꞌ Ana rae, “O ia Kristus, hete? Soba O maneuꞌ masudin dei! Bea riꞌ poko O ia?” ");
INSERT INTO rgu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Faiꞌ ria Petrus bei natuu nai kintal daleꞌ. Boe ma ata inaꞌ esa mai de dedea no ni nae, “Bisinaaꞌ a o boe sama-sama mo Yesus, lahenda Nasaret ria, hete?” ");
INSERT INTO rgu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tehuu ana nalena nai lahenda kadodouꞌ sira matan nae, “Taꞌa! Ubeaꞌ taon, de o matane leo naꞌ! Au ta alelaꞌ Ana fa.” ");
INSERT INTO rgu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Petrus deaꞌ neu de napadeiꞌ nai lelesu bafaꞌ a. Boe ma inaꞌ fekeꞌ esa nita ni nai naa, de ana nafada lahenda fo riꞌ rai naa nae, “Ae, bisinaaꞌ a au ita lahenda ia sama-sama no Yesus, lahenda Nasaret ria.” ");
INSERT INTO rgu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Boe ma Petrus nadedea laka nae, “O bate mamulu! Au soo-supa! Au ta alelaꞌ Lahenda ria fa!” ");
INSERT INTO rgu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta doo bea boeꞌ, te lahenda fekeꞌ fo rai naa dedea ro ni rae, “O bosoꞌ boe tipu mae, o ta sama-sama mo lahenda ria! Huu fo ami mamanene o dedea ma, nana leoꞌ lahenda Galilea!” ");
INSERT INTO rgu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tehuu ana mulai nadedea laka nae, “Ae! Au soo-supa pake Manetualain nade Na! Au ta alelaꞌ Lahenda ria fa!” Naraa laꞌe ana dedea nae leoꞌ na, boe ma manuꞌ a koko-oa. ");
INSERT INTO rgu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petrus namanene manuꞌ a koko-oa, boe ma nafarene bisinaaꞌ a Yesus dedea na nae, “Manuꞌ a bei ta koko-oa fa, te o mafada laiꞌ telu so mae, o ta malelaꞌ Au.” Ana nafarene leoꞌ na, boe ma leo deaꞌ neu de dola nasaeedu. ");
INSERT INTO rgu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bei balahaa aanaꞌ, te basa lahenda fo riꞌ urus dedea agama, raetuꞌ raan nau raisa Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huu ria na, de ara heke roo Ni neu nataa gubernor Pilatus. Huu fo ara nau gubernor huku naisa Ni. ");
INSERT INTO rgu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas bubuluꞌ nae, Yesus hapu huhuku mamates, de ana nasale dale, nana huu ria riꞌ seꞌo heni Yesus. Boe ma ana fali leo malaka agama Yahudi malaka nara, ma lasiꞌ hadas ara neu, fo fee faliꞌ sira doi perak katelu hulun sira. ");
INSERT INTO rgu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana nafada nae, “Au sala so, nana huu au fee heni Lahenda salaꞌ taaꞌ ia.” Tehuu ara rataa rae, “Ae! Ami ta tao daleꞌ neuꞌ o soꞌ! O riꞌ lepa-masaa ma salaꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Boe ma Yudas tuꞌu heni doiꞌ sira leo Uma Mamaso Yahudi Ina a daleꞌ reu, de ana kalua neu londa naisa aon. ");
INSERT INTO rgu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Boe ma malaka agama Yahudi malaka nara reu hai ra doiꞌ fo riꞌ Yudas tuꞌu heni si a. Ara dedearao nara rae, “Ita ta bole peda faliꞌ doiꞌ ia ra leo peti doiꞌ daleꞌ reu, huu fo doi makekeo-makakanuꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Malole lenaꞌ ita teu asa ta mana tao ureꞌ daen bibia anaꞌ esa. Maneniko mate lahenda fui, ma lahenda ta ralelaꞌ ana, sona ita bisa tatoin neuꞌ naa.” ");
INSERT INTO rgu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Boe ma ara pake doiꞌ sira, de reu asa ra dae ria. Huu ria na, losa besaꞌ ia lahenda hule dae ria rae, ‘Dae Daa’. ");
INSERT INTO rgu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","No ria na, ara tuka hata fo baꞌi Yeremia dedea memaꞌ nae, “Ara pake doi perak katelu huluꞌ sira, de asa si reuꞌ dae. Ara pake doiꞌ sira, nana huu asa lahenda sona beli na desi ria, tuka lahenda Israel ara naetu na. ");
INSERT INTO rgu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ara asa dae ria neme mana tao ureꞌ mai, tuka Manetualain pareta Na neuꞌ au.” ");
INSERT INTO rgu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lahenda ra roo Yesus losa gubernor, boe ma ana natane Yesus nae, “Leoꞌ bea? Tebe-tebe O nana, lahenda Yahudi ra Mane na, do?” Ana nataa nae, “Tebe. Papa dedea laꞌe ria so.” ");
INSERT INTO rgu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Malaka agama Yahudi malaka nara, ma lasiꞌ hadas ara rapaneneoꞌ Yesus laꞌe-neuꞌ hihii-nanauꞌ dodouꞌ, tehuu Ana ta nataa hata-hata esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Boe ma gubernor a natane Ni nae, “O ta mamanene sira dedea na fa? Ara fee salaꞌ dodouꞌ soa-neuꞌ O. Tehuu ubeaꞌ taon de O ta sisipoꞌ asa fa!” ");
INSERT INTO rgu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tehuu Ana ta nataa baiꞌ boeꞌ, losaꞌ gubernor a heran. ");
INSERT INTO rgu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tuka-tuka teuꞌ, maneniko lahenda Yahudi ra tao feta Paska, sona lahenda kadodouꞌ ara biasa here lahenda mana hukuꞌ esa, ela gubernor a poꞌi ni. ");
INSERT INTO rgu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tepoꞌ ria, lahenda mana hukuꞌ esa, nade Barabas. Basa lahenda bubuluꞌ rae ria nana bea, huu fo makaresi na seli. ");
INSERT INTO rgu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Faiꞌ ria boe, lahenda dodouꞌ leo gubernor Pilatus reu, hule fo ana poꞌi lahenda mana hukuꞌ esa sama leoꞌ bale-bale. Boe ma Pilatus natane si nae, “Malole! Tehuu au poꞌi bea? Nai ia, Barabas, ma Yesus fo riꞌ lahenda hule rae, Kristus, de here ao mara leo.” ");
INSERT INTO rgu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubernor dedea leo naꞌ, huu fo ana bubuluꞌ nae malaka agama Yahudi malaka nara roo Yesus feen leo ria neu, nana huu ara ramanasaꞌ Ana.) ");
INSERT INTO rgu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gobernor a bei parisaꞌ dedeaꞌ ria, boe ma sao na haitua feen haraoeꞌ nae, “Papa! Besa-besa oo, huu fo Yesus nana Lahenda sala taaꞌ ria. Huu fo no Ria, de leodaeꞌ a au alamei, mei-afes tadaluꞌ. Losaꞌ besaꞌ ia boe au bei ameda aan ta malole a.” ");
INSERT INTO rgu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tehuu malaka agama Yahudi malaka nara, ma lasiꞌ hadas ara duduku-papauꞌ lahenda kadodouꞌ sira, hule gubernor a fo poꞌi Barabas, ma huku namate Yesus. ");
INSERT INTO rgu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Boe ma ana natane seluꞌ asa bali nae, “Neme lahenda ia ra dua si mai, au poꞌi bea?” Basa si rataa belaꞌ a rae, “Barabas! Poꞌi Barabas!” ");
INSERT INTO rgu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ana natane si nae, “Maneniko leoꞌ na, sona Yesus fo riꞌ lahenda hule rae Kristus a, au taon leoꞌ bea?” Basa si rahara belaꞌ a rae, “Paku maisa Ni neuꞌ ai kake a!” ");
INSERT INTO rgu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gubernor a natane bali nae, “Te Ana nasalaꞌ ubeaꞌ? Au parisaꞌ Ana so, tehuu au ta hapu Ni sala hata esa boeꞌ!” Tehuu basa si rahara rambera bali rae, “Maisa Ni! Paku Ni neuꞌ ai kake a leo!” ");
INSERT INTO rgu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ta doo bea boeꞌ, te bubuluꞌ nae, ana ta bisa tao hata-hata esa so boeꞌ, huu fo lahenda kadodouꞌ sira sakaꞌ tao tasibuꞌ. Huu ria na, de hai na oe fo safe lima na nai sira matan, ma nafada nae, “Au ta lepa-asaa Lahenda ia mamate Na! Emi riꞌ lepa-masaa man!” ");
INSERT INTO rgu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lahenda kadodouꞌ sira rataa rambera rae, “Hoo, nemeꞌ na! Ela ami mo upu-ana mara siꞌ lepa-masaa Ria daa Na!” ");
INSERT INTO rgu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatus namanene leoꞌ na, boe ma nae, “Neme emi mai!” Boe ma ana poꞌi Barabas, tuka sira hihii-nanaun. Boe ma ana pareta lahenda manea ra, fo fepa-liꞌu Yesus pake cambuk. Fepa-liꞌu basan, boe ma soldadu ra roo Yesus, fo sakaꞌ reu paku raisan nai ai kake. ");
INSERT INTO rgu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Boe ma soldadu ra hela roo Yesus leo sira kota musu na kintal maloa na neu. Nai naa, ara raloo ra sira nonoon batalyon esa. ");
INSERT INTO rgu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ara fee Ni pake badu manaru pilas makaderaꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ara hai ra ai makouꞌ a rana na, de ralanen tao silaka. Boe ma ara poroꞌ silaka makouꞌ ria neuꞌ Yesus laka Na, fo ramiminaꞌ Ana sama leoꞌ sakaꞌ soꞌu mane bebeuꞌ pake silaka mana pareta. Ara feen homu ai esa nai lima ona Na, sama leoꞌ teteꞌe mana pareta. Ara sundaꞌ undulaka nara rasare raan, ma ramumulu-ramamaeꞌ Ana rae, “Hada-horomata neuꞌ lahenda Yahudi ra Mane na.” ");
INSERT INTO rgu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ara mudi radiu Ni ape, ma hai ra teteꞌe ria nemeꞌ lima Na mai, fo fepa ramiminaꞌ laka Na. ");
INSERT INTO rgu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Soldadu ra ramumulu-ramamaeꞌ basa Ni, boe ma ara olu heni badu manaru ria. Ara fee Ni pake seluꞌ Ria kakao-papaken. Basa de ara roo Ni leo kota Yerusalem a deaꞌ neu, fo nau reu paku Ni nai ai kake a losaꞌ maten. ");
INSERT INTO rgu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ara roo Yesus, losa eno taladaꞌ ara raneta ro lahenda kota Kirene esa nade Simon, besaꞌ ko sakaꞌ masoꞌ leo kota daleꞌ neu. Ara raseti ni fo nasaa Yesus ai kake Na. ");
INSERT INTO rgu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ara losa mamanaꞌ esa, nade Golgotaa. (Dedea Aram, ria sosoa na nae, “Mamana laka duiꞌ.”) ");
INSERT INTO rgu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nai naa ara nau fee Yesus ninu anggor fo mana epoꞌ no modo-aidoo maliꞌ, ela Ana bisa nanenete hedis. Yesus mutiꞌ na baiꞌ, boe ma Ana natipa. ");
INSERT INTO rgu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Boe ma ara paku Ni nai ai kake a. Basa de ara hela lot fo nau bubuluꞌ bea riꞌ hapu Ria kakao-papaken. ");
INSERT INTO rgu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ara ratuu ranea Ni nai naa. ");
INSERT INTO rgu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ara duiꞌ nai papaꞌ esa boe nae, “IA NANA YESUS, LAHENDA YAHUDI RA MANE NA” Ara paku papaꞌ ria neuꞌ Ria laka Na pooꞌ lai, fo dadi nafafadaꞌ nae tute na huu ubeaꞌ de ara huku ramate Ni. ");
INSERT INTO rgu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nai naa, ara paku lahenda parampok dua nai ai kake a boe. Esa nai Ria boboa onan; esa nai boboa ii Na. ");
INSERT INTO rgu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Basa lahenda fo laꞌo resiꞌ naa, rita Ni. Ara peko bafa nara ma ramumulu-ramamaeꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ara bobouꞌ Ana rae, “He! O mae bisa fate heni Manetualain Uma Mamaso Yahudi Ina Na, boe ma noi faiꞌ teluꞌ a, te mafoa maan seluꞌ, hete? Kalu tetebes ara Manetualain Anan O, sona soba poꞌi ma aom fo onda memeꞌ ai kake ria mai leo.” ");
INSERT INTO rgu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Leoꞌ na boe, malaka agama Yahudi malaka nara, mesen agama, ma lasi hadas nara, ramamaeꞌ Ana rae, ");
INSERT INTO rgu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ana poꞌi-tata naa lahenda fekeꞌ a, tehuu Ana ta bisa poꞌi-tata naa ao-ina heheli Na. Ana nae, Ria nana lahenda Israel Mane na! Kalu leoꞌ na, sona malole lenaꞌ Ana onda nemeꞌ ai ria mai. Kalu ita tita leo naꞌ, besaꞌ ko tamahere Ni. ");
INSERT INTO rgu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tebe-tebe Ria nana Manetualain Anan, sona ela ‘Ana namahena neuꞌ Manetualain. De maneniko Manetualain nahiiꞌ Ana, nemeꞌ na fo ela Manetualain riꞌ poꞌi-tata naa Ni.’ ” ");
INSERT INTO rgu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lahenda parampok sira dua boe, ramamaeꞌ Ana leo naꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Boe ma maiuꞌ a napoti na mamanaꞌ ria neme ledo a namatetu losa liꞌu telu leodaen. ");
INSERT INTO rgu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Liꞌu telu leodaen, boe ma Yesus naloo nambera pake dedea Aram nae, “Eli! Eli! Lema sabaktani?” (Sosoa na nae, “Au Manetualain Ka! Au Manetualain Ka! Ubeaꞌ taon, de Papa foa ela Au leoꞌ ia?”) ");
INSERT INTO rgu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lahenda hida raneneaꞌ rai naa ramanene Ria haraoe Na. Boe ma ara rae, “Ae! Emi nenene dei. Ana naloo Elia, Manetualain mana nesi mata fai ulu na!” ");
INSERT INTO rgu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lahenda esa nalai neu hai lopu fo naboron leo anggor maꞌeis daleꞌ neu. Boe ma ana pau lopu ria neuꞌ teteꞌe a peda na, de loo ni neuꞌ Yesus bafa na, ela Ana nasamusi. ");
INSERT INTO rgu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tehuu lahenda fekeꞌ ruma bali dedea rae, “Tahani fo ela mete tasudi, Elia nau mai poꞌi-tata naa Ni do, taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus naloo nambera seluꞌ bali, boe ma mate Ni. ");
INSERT INTO rgu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nai Uma Mamaso Yahudi Ina a, tema bau-inaꞌ esa nanapepeleꞌ fo babaa Manetualain Kama Malalao-malalafuꞌ a. Naraa laꞌe Yesus maten, boe ma temaꞌ ria sii bati duan, neme lain losa daeꞌ. Dae a natakeko, losaꞌ batu bau-inaꞌ ara ratahea. ");
INSERT INTO rgu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rates ara boe ratahuꞌa. Manetualain lahendan fo mate si a, Ana fee ruma rasoda seluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Fai fo Yesus nasoda seluꞌ, boe ma ara kalua reme rates ara daleꞌ mai, de masoꞌ leo kota Yerusalem reu. Lahenda dodouꞌ rita si rai naa. ");
INSERT INTO rgu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nai Golgotaa, malaka soldadu a no ria ei-liman ranea Yesus ai kake Na. Ara rita dae-bafoꞌ a natakeko, ma basa hihii-nanauꞌ mana dadiꞌ sira, boe ma bii raan seli. Ara dedearao nara rae, “Awii! Tebe-tebe Lahenda ia nana, Manetualain Anan!” ");
INSERT INTO rgu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Inaꞌ hida rai naa boe, ara rita Yesus mamate Na, tehuu mete reme dooꞌ a mai. Ara tuka Ni neme Galilea, huu fo sira siꞌ ralalau-raoonon neme uluꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inaꞌ sira nana Maria neme koro Magdala, Maria esa bali (fo riꞌ Yakobis no Yusuf maman), ma Sabadeus sao na (fo riꞌ Yakobis no Yohanis maman). ");
INSERT INTO rgu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nai naa lahenda kamasuꞌi esa nade Yusuf, neme koro Arimatea mai. Ana tuka Yesus nanori-nafadan dooꞌ a so. Yesus mamate Na, laꞌe soda Limaꞌ. Balahaaꞌ laꞌe lahenda Yahudi ra fai huhule-haradoin. Huu ria na, de ledo a sakaꞌ tena, boe ma Yusuf saka enoꞌ fo nau naonda memaꞌ Yesus popora Na neme ai kake a mai. ");
INSERT INTO rgu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ana leo gubernor Pilatus neu, fo hule Yesus popora Na. Gubernor pareta fo ara fee ni poporaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Boe ma Yusuf leo Golgotaa neu. Ana naonda Yesus popora Na neme ai kake ria mai. Ana poti natalolole poporaꞌ ria neniꞌ tema bebeuꞌ mabeli. ");
INSERT INTO rgu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tepoꞌ ria, lahenda ra besaꞌ ko paa basa boloꞌ esa nai lete batu, fo sadia memaꞌ bolo natoiꞌ fee Yusuf no kileoboboki nara, kalu ara mate. De Yusuf asa oꞌo reni Yesus popora Na, de rapeuꞌ Ana neuꞌ boloꞌ ria daleꞌ. Ara loli ra batu bau-inaꞌ esa, de tatana matalolole boloꞌ ria. Basa boe ma Yusuf asa fali. ");
INSERT INTO rgu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Faiꞌ ria, Maria neme Magdala ma Maria fekeꞌ, tuka losa naa boe. Ara ratuu rasare leo boloꞌ ria reu. ");
INSERT INTO rgu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Balahaꞌ, naraa laꞌe lahenda Yahudi ra fai hahae aon. Boe ma malaka agama Yahudi malaka nara ro lahenda Farisi ra leo gubernor a reu. ");
INSERT INTO rgu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ara rafada rae, “Papa gubernor, ami mafarene tepoꞌ fo manatipu-manadaiꞌ ria bei nasoda a, ana parnaa nae leoꞌ ia: ‘Tebe Au mate, tehuu basa faiꞌ telu, te Au asoda seluꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huu ria na, papa madenu soldadu ra fo ranea ratalolole rates ria losa faiꞌ telu. No ria na, Ria ana mana tuka dea nara ta bisa ramanaꞌo ra popora Na, fo tipu lahenda rae, Ana nasoda seluꞌ so. Huu fo maneniko ara tipu leoꞌ na, sona sira tipu-dain ria tadalu lena neme maulu na sira manaku rae Ria nana Kristus.” ");
INSERT INTO rgu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Gubernor namanene leoꞌ na, boe ma nataa nae, “Malole a boe! Tehuu emi manuu lahenda manea. De malole lenaꞌ mafada si, fo reu ranea ratalolole mamanaꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ara roo sira lahenda manea nara leo mamanaꞌ ria reu. Losa naa, boe ma ara segel raisaꞌ batu fo nai rates a bafa na. Ara radenu lahenda sira fo ranea rahere mamanaꞌ ria, ela lahenda fekeꞌ bosoꞌ mai oꞌo ra poporaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mamaso na balahaan, boe ma Maria neme Magdala ma Maria fekeꞌ a, reu dama rates ria. ");
INSERT INTO rgu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kekeneu te, dae-bafoꞌ a natakeko naan seli. Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a, esa onda mai, de ana loli heni batu bau-inaꞌ fo riꞌ manatatanaꞌ nai boloꞌ a. Boe ma ana natuuꞌ neuꞌ batu ria lain. ");
INSERT INTO rgu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eilaꞌo-limalope ria mata-idun nahaa sama leoꞌ relas, ma kakao-papaken fula makadila. ");
INSERT INTO rgu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lahenda manea sira bii raan seli losaꞌ dere saꞌu-saꞌu, ma ara ta bisa rababale fa, sama leoꞌ lahenda mana mateꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eilaꞌo-limalope nai nusatetu-ikutemaꞌ fo riꞌ mai a, nafada inaꞌ sira nae, “Emi bosoꞌ bii! Au bubuluꞌ emi mai saka Yesus, Lahenda fo riꞌ ara paku ramaten nai ai kake a. ");
INSERT INTO rgu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tehuu Ana ta nai ia soꞌ. Huu fo Ana nasoda seluꞌ, sama leoꞌ nafada so a. Maiꞌ ia ela mita mataꞌ mamanaꞌ fo ara rapeuꞌ Ria popora Na. Mamanaꞌ ria rouꞌ so! ");
INSERT INTO rgu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Besaꞌ ia emi malale fo fali leo! Meu mafada Ria ana mana tuka dea nara mae, Yesus nasoda seluꞌ so. Ana laꞌo nauluꞌ leo Galilea neu so. Ara muste reu raneta ro Ni nai naa, sama leoꞌ maulu na Ana helu si a. Mamahere leo! Fali leo, ela tui hata fo riꞌ au afada a!” ");
INSERT INTO rgu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Boe ma inaꞌ sira laꞌo ela mamanaꞌ ria. Ara bii, tehuu sira boe ramahoꞌo. Ara ralale fo fali reu tui basa hihii-nanauꞌ sira reuꞌ Yesus ana mana tuka dea nara. ");
INSERT INTO rgu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tehuu losa eno taladaꞌ, boe ma kekeneu te Yesus mai naneta no si. Ana dedea nae, “Soda-moleꞌ!” Ara rita leoꞌ na, boe ma raneneaꞌ mata reu de holu ra ei Na, ma doꞌo-tabe Ni. ");
INSERT INTO rgu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Boe ma Ana dedea nae, “Bosoꞌ bii, ee! Meu mafada Au ana mana tuka dea kara, fo ara reu rahani Au nai Galilea.” ");
INSERT INTO rgu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Inaꞌ sira bei rai enoꞌ taladaꞌ, te lahenda manea ra fali leo bendar a reu. Ara reu rafada malaka agama Yahudi malaka nara, basa hihii-nanauꞌ mana dadi sira. ");
INSERT INTO rgu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Boe ma malaka sira ro lasiꞌ hadas ara ator raa eno na, de ena-oꞌo lahenda manea ra bafa nara reniꞌ doi dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Malaka sira rafada rae, “Leo iaꞌ. Maneniko lahenda ratane, sona emi muste mataa mae, hatu na emi suku mamanee. Boe ma Ria ana mana tuka dea nara mai ramanaꞌo reni popora Na. ");
INSERT INTO rgu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma kalu papa gubernor namanene hihii-nanauꞌ ria, sona emi bosoꞌ bii, huu fo neuꞌ ko ami ator tou lasiꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Boe ma lahenda manea sira sipo ra doiꞌ ria. Ara tao tuka malaka sira hihii-nanaun. Huu ria na, de losaꞌ besaꞌ ia lahenda Yahudi ra bei ramahere tutui napuputaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesus ana mana tuka dean lahenda kasanahulu esaꞌ ara, ramanene inaꞌ sira tutui na, boe ma ara leo propinsi Galilea reu, ela raneta ro Ni nai leteꞌ esa, tuka Ria hehelu Na. ");
INSERT INTO rgu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ara rita Ni nai naa, boe ma ara doꞌo-tabe neuꞌ Ana. Tehuu leo mae leoꞌ na boe oo, ruma dale nara bei kadudua. ");
INSERT INTO rgu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Boe ma Ana naneneaꞌ no si, ma dedea nae, “Manetualain fee Au kuasa, de Au pareta basa-basan fo rai lalai, ma basa-basan fo rai dae-bafoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","De emi leo basa mamanaꞌ ain meu, sona emi muste tui-beka Au Tutui Malole Ka soa-neuꞌ basa lahenda nusaꞌ ara. Emi muste manori-mafada matalolole si, fo ela ara dadi reuꞌ Au ana mana tuka dea kara. Ma emi muste sarani si fo dadi tanda nae, sira rabua-raesa ro Amaꞌ a, ma Ria Ana Na, ma Ria Dula-dale Malalao-malalafu Na. ");
INSERT INTO rgu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma manori-mafada si, ela ara tao tuka basa pareta fo Au afadan neuꞌ emi a. Mafarereneꞌ! Au sama-sama oo emi, losaꞌ dae-bafoꞌ ia noe.” ");
INSERT INTO rgu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tutui malole ia. Ia nana, Manetualain Ana Na tutuin. Nade na Yesus Kristus, fo Manetualain tudu memaꞌ Ana neme uluꞌ mai so. Tutuiꞌ a mulai na leo iaꞌ: ");
INSERT INTO rgu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus bei ta noi Ria nonoi-tataon fa, te Manetualain nadenu lahenda esa, nade Yohanis. Yohanis muste neu sadia enoꞌ fee Yesus mamai na. Huu fo nai fai a ulu na Manetualain pake mananesimatan, nade baꞌi Yesaya. Ana duiꞌ memaꞌ nae: “Nenene o! Au adenu Au lahenda ki, fo neu soi enoꞌ fee O. ");
INSERT INTO rgu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lahenda ria neuꞌ ko neu nai mamanaꞌ fo lahenda taꞌa na, de naloo-nakou, nae: ‘Basa lahenda ra mahehere ao mara tao matalolole eno-dalaꞌ, fo sipo Ramatuaꞌ a mamai na! Tao ma enoꞌ a roos a fo sipo-soruꞌ Ana!’ ” ");
INSERT INTO rgu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Lahenda biasa raloon sona rae Yohanis, Mana Saraniꞌ. Ana leo nai mamana lino-nees. Ria papake na tao neme banda unta a bulu na. Ria tali-ee na tao neme banda rouꞌ. Ria nanaa na, lamaꞌ ma fani oe nura. (Yohanis masoda na, sama leoꞌ fai a ulu na baꞌi Elia.) Tepoꞌ ria, lahenda dodouꞌ reme kota Yerusalem mai, ma propinsi Yudea a isi na katemaꞌ, mai raneta ro Yohanis nai ria mamana na. Ara mai nana nau rita Yohanis ma nau ramanene ria nonori-nafadan. Yohanis nafada si nae, “Emi muste manaku ma foa ela sala mara katemaꞌ, fo ela leoꞌ bea na Manetualain sae-safe heni salaꞌ sira. Basa sona emi muste sarani dei, fo dadi tanda, nae emi malolole mo Manetualain so.” Basa de ara manaku sala nara, boe ma ana sarani si nai lee Yarden a. ");
INSERT INTO rgu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana nafada, nae, “Neuꞌ ko lahenda esa kahereꞌ lena heni au, sakaꞌ mai. Leo mae dadi adaꞌ noi neuꞌ Ria lahenda nadedenun boe oo, au ta araa fa. ");
INSERT INTO rgu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au bisa sarani emi uniꞌ adaꞌ noi oe, tehuu neuꞌ ko Ria tao lena au, huu fo Ana tao nahenu emi dale mara neniꞌ Manetualain Dula-dale Malalao-malalafu Na.” ");
INSERT INTO rgu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tepoꞌ ria, Yesus nemeꞌ koro Nasaret nai propinsi Galilea, mai naneta no Yohanis. Boe ma Yohanis sarani Ni nai lee Yarden. ");
INSERT INTO rgu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Faiꞌ fo Yesus kalua nemeꞌ oe daleꞌ mai, kekeneu te, lalai natahuꞌa. Boe ma Manetualain Dula-dale Na onda neuꞌ Ana, sama leoꞌ manupui kalasi. ");
INSERT INTO rgu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Boe ma ramanene Manetualain haraoe Na nemeꞌ lalai mai nae, “O ia nana Au ana susue ka. O tao ma Au amahoꞌo laꞌo naroo.” ");
INSERT INTO rgu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Basa ria boe ma, Manetualain Dula-dale Na hela noo Yesus leo mamana lino-nees a neu. ");
INSERT INTO rgu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Banda fuiꞌ ara rai naa. Yesus leo nai mamanaꞌ ria faiꞌ haa hulu. Nai na, nitu ra malaka na mai soba neuꞌ Yesus ela tuka ni, tehuu ta nalan fa. Basa boe ma, Manetualain eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai rafaduli neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tepoꞌ fo, ara ena Yohanis Mana Saraniꞌ a nai bui daleꞌ, boe ma Yesus leo propinsi Galilea neu, fo nafada Manetualain Tutui Malole Na. ");
INSERT INTO rgu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana dedea nae, “Nenene, o! Besaꞌ ia Manetualain ledo-fain losa so! Besaꞌ ia basa lahenda ra bubuluꞌ rae, Manetualain homu pareta. Huu ria na, de emi muste hahae memeꞌ mapuputa mara mai leo, fo matafali mai tuka Manetualain. Basa sona, mamahere neuꞌ Ria Tutui Malolen ia, leo.” ");
INSERT INTO rgu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Faiꞌ esa boe ma Yesus laꞌo tuka dano Galilea suu na. Ana nita lahenda esa, nade Simon no fadi na, nade Anderias. Dua si dala ikaꞌ. Huu fo sira dua nonoi bale fain ria. ");
INSERT INTO rgu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus naloo si nae, “Ae! Mai fo tuka Au leo! Emi biasa saka ikaꞌ, tehuu besaꞌ ia Au nau tao fee emi dadi manasaka sumaneꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ramanene leoꞌ na boe ma dua si foa ela dala ria, de reu tuka tutiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Basa ria de, Yesus laꞌo naroo seluꞌ baiꞌ, boe ma Ana nita Sabadeus ana nara. Aꞌa na nade Yakobis, ma fadi na nade Yohanis. Dua si rahii pukaꞌ nai ofaꞌ daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus naloo dua si nae, “Ae! Mai fo tuka Au!” De, dua si foa ela papa na, no lahenda mana noi ra nai ofaꞌ lain. Boe ma reu tuka Ni. ");
INSERT INTO rgu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Basa boe ma, Yesus no lahenda kahaaꞌ fo riꞌ tuka Ni a, losa kota Kapernaum. Tepoꞌ fo lahenda Yahudi ra fai huhule-haradoin, boe ma Yesus leo uma mamasoꞌ daleꞌ neu, fo nanori-nafada nai na. ");
INSERT INTO rgu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ramanene dedea Na, basa lahenda ra roi ramakokoaꞌ a, huu fo Ana nalelaꞌ matetuꞌ nanoriꞌ ria isi na. Ta sama no lahenda Yahudi ra mese agama nara fa. ");
INSERT INTO rgu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Faiꞌ ria hapu lahenda esa nitu ra heke ran. Ana tuka leo uma mamasoꞌ dale neu boe, basa de nitu fo nai lahenda ria daleꞌ a nahara nae, ");
INSERT INTO rgu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ae! Yesus lahenda Nasaret! O manuu nafaduliꞌ ubeaꞌ moo ami? O mai fo nau tao malutu ami, do? Ami malelaꞌ O. Lahenda fo Manetualain helu feen mai. O ia nana, Manetualain Lahenda Malalao-malalafun, ta nanuu salaꞌ fa!” ");
INSERT INTO rgu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tehuu Yesus nasapaa ni nae, “Maꞌauꞌ bafa ma! Kalua meme lahenda ria mai!” ");
INSERT INTO rgu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nitu a tao na lahenda ria hede-hede mesan. Boe ma ana kalua neme lahenda ria mai, ma kasi namberaina. ");
INSERT INTO rgu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Boe ma, basa lahenda rai uma mamasoꞌ ria daleꞌ, roi ramakokoaꞌ a. Ara bai dea rae, “Ae! Ubea ia, e? Ana pareta nitu ra fo kalua, boe ma tuka Ria hihii-nanaun. Nanori bebeuꞌ ia, do? Tou lasiꞌ a dedea na kahereꞌ, ó!” ");
INSERT INTO rgu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Boe ma lahenda ra mulai ratui ao, neme bafaꞌ mai leo bafaꞌ neu, losaꞌ rule-feo nai propinsi Galilea. ");
INSERT INTO rgu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tepoꞌ fo ara reme uma mamasoꞌ ria mai, boe ma Yesus leo Simon no Anderias uma na neu. Yakobis no Yohanis sama-sama roo si. ");
INSERT INTO rgu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon arina na namahedi ao lumaiꞌ, de napeuꞌ nai koi lain. De, tepoꞌ fo Yesus no ana mana tuka dea nara kodi leo uma ria daleꞌ reu, boe ma lahenda mai rafadan rae, “Inalasiꞌ a namahedi ao lumaiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus neu dama inalasiꞌ a, boe ma tai na lima na, fo bifi nafoan. Boe ma ao lumai na mopoꞌ ana. Basa boe ma, inalasiꞌ a kalua neu nalalau si. ");
INSERT INTO rgu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ledo a sakaꞌ tena boe ma, lahenda ra roo sira lahenda kamahedi nara, ma lahenda nitu heke nara. Ara roo si leo Yesus mai fo hule tutulu-fafaliꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Losaꞌ kota esa lahenda nara mai, de tesa rai uma ria matan. ");
INSERT INTO rgu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lahenda sira hedi nara rupaꞌ ara, tehuu Yesus puli na basa si. Ma usi heni nitu makaresiꞌ dodou-inaꞌ. Tehuu Ana ta fee nitu sira lelaꞌ fo dedea fa, huu fo ara ralelaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Balahaꞌ dulupila na, bei maꞌiuanaꞌ, te Yesus foa de kalua neme uma ria mai so. Ana leo mamana lino-nees esa neu fo hule-haradoi, dedea no Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tepoꞌ fo Simon asa foa, te ara ta rita Yesus fa, boe ma reu saka Ni. ");
INSERT INTO rgu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Faiꞌ fo ara raneta roo Ni boe ma rae, “Papa, lahenda dodouꞌ saka Papa ka.” ");
INSERT INTO rgu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tehuu Ana sipoꞌ asa nae, “Ria malole a boe. Tehuu malole lenaꞌ ita leo koro fekeꞌ fo raneneaꞌ nai baianaꞌ ia dei. Huu fo Au nau afada si Tutui Malole a boe. Huu fo nana Au nonoi ki ria.” ");
INSERT INTO rgu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Basa boe ma, Ana laꞌo nafeo propinsi Galilea a, fo tui-nafada Tutui Malole neme Manetualain mai nai sira uma mamaso nara. Ma Ana usi heni nitu ra remeꞌ lahenda ra mai boe. ");
INSERT INTO rgu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tepoꞌ ria, hapu lahenda kamahedi kusta esa leo Yesus mai. Boe ma ana sundaꞌ undulaka na, fo hule neuꞌ Yesus nae, “Papa, é! Fali ma au dei! Huu fo au bubuluꞌ, Papa bisa tao mamopo hedi ki ia, ela leoꞌ bea na lahenda bosoꞌ rahiaꞌ au bali. Sadi Papa nau.” ");
INSERT INTO rgu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus kasian neuꞌ lahenda ria, boe ma Ana looꞌ lima Na neu, de nafaroe ni, ma nae, “Memaꞌ, Au nau! Naa, o malole leo.” ");
INSERT INTO rgu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kekeneu te, lahenda ria hedi na mopoꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Boe ma Yesus nadenu lahenda ria fali neun, tehuu feen nafarerene, ");
INSERT INTO rgu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","nae, “Mafarereneꞌ matalolole! O teꞌe ma aom so, tehuu ta bole mafada lahenda esa boeꞌ, e! O muste tuka baꞌi Musa pareta na dei. De, leo malaka agama ra muu, fo ana parisaꞌ o ao-ina ma, ela nita o hedi ma mopon matetuꞌ, do taꞌa! Basa sona, o muste fee tutunu-hohotuꞌ tanda makasi, ela basa lahenda ra bubuluꞌ rae, o teꞌe matetuꞌ so.” ");
INSERT INTO rgu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tehuu lahenda ria nala deaꞌ boe ma ana neu tui nafeo basa mamanaꞌ ara. Boe ma lahenda dodouꞌ saka Yesus fo nau raneta Roon, losaꞌ Ana ta bisa natudu mata-idun nai kota dale fa. De, Ana leo nahaniꞌ mamana lino-nees nai kota a deaꞌ. Tehuu sudi neme mamanaꞌ ain mai, lahenda roi faa-faaꞌ a mai, fo nau raneta roo Ni. ");
INSERT INTO rgu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Basa faiꞌ hida boe ma, Yesus fali seluꞌ leo Kaparnaum neu. Boe ma lahenda rafada nai basa mamanaꞌ ara rae, Ana nai uma so. ");
INSERT INTO rgu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Boe ma lahenda remeꞌ basa mamanaꞌ ain mai. Ara tesa rahenu naa, losa rakasekeꞌ uma daleꞌ. Rakasekeꞌ losa uma a bafa na. Yesus nafada si, Manetualain hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana bei dea-dea, te lahenda haa rolo reni tou lukuꞌ esa leo Yesus mai. ");
INSERT INTO rgu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tehuu, no lahenda dodouꞌ, de rina ara ta bisa roo lahenda ria losa Yesus mata Na fa. Boe ma ara ae leo uma lain reu, de ara fate heni uma a puni na, naraa no Yesus laka Na. Ara fate henin boe ma raꞌondan no nea na. ");
INSERT INTO rgu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus nita lahenda sira, Ana bubuluꞌ ara ramahereꞌ matetuꞌ neuꞌ Ana. Boe ma Ana nafada lahenda lukuꞌ ria nae, “Anaꞌ, on! Au fee ampon neuꞌ o sala-siko mara so!” ");
INSERT INTO rgu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tehuu hapu mese agama Yahudi hida ratuuꞌ rai ria. Ara ramanene Yesus nafada nae leoꞌ na, boe ma dale nara rababale. ");
INSERT INTO rgu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ara bai dea rae, “Lahenda ia naparani dedea nae leoꞌ na! Adaꞌ noi Manetualain riꞌ bisa fee ampon neu lahenda salan. Tehuu lahenda ia dedean ria, tao aon sama leoꞌ Manetualain. Ana namumulu-namamaeꞌ Manetualain ria so!” ");
INSERT INTO rgu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tehuu Yesus bubuluꞌ memaꞌ sira dale nara so. Boe ma Ana nafada nae, “Emi bosoꞌ afi leoꞌ naꞌ! ");
INSERT INTO rgu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Muda na riꞌ ubeaꞌ? Kalu Au afada neuꞌ lahenda lukuꞌ ia ae, ‘O sala ma hapu ampon so,’ emi ta bubuluꞌ maneniko dadi leoꞌ na, do taꞌa. Tehuu maneniko Au ae, ‘Foa leo! Hai ma nea ma fo fali leo.’ Kalu ana foa tutiꞌ a, emi besaꞌ ko mita buti mae, Au ia nana, Lahenda Teteaꞌ. Ma Au anuu kuasa ma hak fo fee ampon neuꞌ lahenda salan.” Basa ria boe ma Yesus nafada neuꞌ lahenda lukuꞌ ria nae, ");
INSERT INTO rgu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O nenene, e! Besaꞌ ia o malole a so! De, foa fo hai ma nea ma fali leo.” ");
INSERT INTO rgu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lahenda ria namanene leoꞌ na, boe ma foa tutiꞌ a. Boe ma hai na nea na, de laꞌo deaꞌ neu. Basa lahenda fo rai na, rita no mataꞌ. Roi ramakokoaꞌ a de rae, “Awi! Ita besaꞌ ko parna tita leo iaꞌ, o! Manetualain tebe kahereꞌ naan seli!” ");
INSERT INTO rgu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Basa ria, boe ma, Yesus fali seluꞌ leo dano Galilea a suu na neu. Lahenda dodouꞌ mai raneta roo Yesus. Boe ma nafada Manetualain hihii-nanaun neuꞌ lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nai naa, hapu lahenda esa nade Lewi, Alfius ana na. Ana noi-tao nai mamana babae bea a fee mana pareta Roma. Naraa no Yesus laꞌo nesiꞌ na, de nita Lewi. Boe ma nae, “Mai fo tuka Au!” Lewi namanene Yesus nae leoꞌ na, boe ma ana foa de neu tuka tutiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Basa ria boe ma, Yesus no ana mana tuka dea nara ratuuꞌ raa-rinu nai Lewi uman, sama-sama roo basa Lewi nonoo mana susu bea nara. Hapu lahenda fekeꞌ fo lahenda Yahudi ra rae sira tadaluꞌ, ara raa-rinu roo si. Neme lahenda fo ratuuꞌ raa-rinu a, kadodou na rahiiꞌ ramanene neuꞌ Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tepoꞌ ria, hapu mese agama lahenda hida remeꞌ partei Farisi, rita Yesus naa-ninu no lahenda mana susu bea, ma lahenda tadaluꞌ ara. Boe ma ara ratane Yesus ana mana tuka dea nara rae, “Ubeaꞌ taon de emi Mesen ma naa-ninu no mana susu bea ma lahenda tadaluꞌ ara?” ");
INSERT INTO rgu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tehuu Yesus namanene sira natane na, boe ma nataa nae, “Memaꞌ lahenda hediꞌ ara sona saka doter, tehuu lahenda fo ta namahedi fa sona ta parluu fa. Au mai fo afaduli neuꞌ lahenda tadaluꞌ ara. Tehuu ta mai fo afaduli lahenda riꞌ nameda aon nae sira roo-tetuꞌ fa.” ");
INSERT INTO rgu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Faiꞌ esa, boe ma lahenda reme partei agama Farisi ra puasa. Ara rita Yohanis Mana Saraniꞌ a, ana mana tuka dea nara puasa boe. Tehuu ara ta rita Yesus ana mana tuka dea nara puasa sama leoꞌ sira fa. Basa boe ma sira lahenda nara mai raneta roo Yesus de ratane rae, “Papa. Ami puasa. Yohanis lahenda nara boe puasa. Tehuu, ubeaꞌ taon de Papa ana mana tuka dea mara ta puasa fa?” ");
INSERT INTO rgu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Boe ma Yesus nataa nae, “Tebe emi bubuluꞌ so, kalu hapu feta kakabiꞌ, fui ra ta puasa fa, tehuu ara raa-rinu rabete. Maneniko manakabi touꞌ a bei nai naa, sona basa si raa-rinu belaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tehuu neuꞌ ko faiꞌ esa nai naa, kalu lahenda roo manakabi touꞌ a laꞌo dei, sona tia-lai nara rameda susa, besaꞌ ko ara puasa.” ");
INSERT INTO rgu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Basa boe ma Yesus tamba dedea nasasamaꞌ esa nae, “Lahenda ta tapa rabua tema bebeuꞌ a neuꞌ badu paraaꞌ a fa. Huu fo maneniko safe ni, te tema bebeuꞌ ria uꞌulu fo tao na badu paraaꞌ a sii nambera. ");
INSERT INTO rgu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Leoꞌ na boe, lahenda ta disi tua bebeuꞌ neuꞌ hai paraaꞌ a fa. Huu fo neuꞌ ko haiꞌ ria hea ni, boe ma tuaꞌ a nosi henin. De, tua bebeuꞌ sona disi ni neuꞌ hai bebeuꞌ.” Yesus nanori si leoꞌ na nae, Ria nanori bebeu na, bosoꞌ nabuan no lahenda Farisi ra nanori paraa nara. ");
INSERT INTO rgu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Faiꞌ esa, naraa laꞌe lahenda Yahudi ra fai huhule-haradoin, Yesus laꞌo nesiꞌ okaꞌ daleꞌ. Boe ma ana mana tuka dea nara etu ra hade gandum a, fo raa. ");
INSERT INTO rgu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tehuu lahenda Farisi a rita si, boe ma ara rafada Yesus rae, “Ubeaꞌ taon de O ana mana tuka dea mara ralena laka neuꞌ ita atoran agama na? Ara etu hade gandum naraa laꞌe fai hahae aoꞌ! Emi ta bole tao leoꞌ na fa!” ");
INSERT INTO rgu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ana nataa nae, “Leoꞌ bea, ó? Emi ta mafarene baꞌi Daud tutui na fa. Tepoꞌ fo, tou lasiꞌ Abiatar dadi neuꞌ malaka agama Yahudi ra Malaka Bauina na. Baꞌi Daud no ana mana tuka dea nara ramalaa mamateꞌ. Boe ma ara masoꞌ leo Manetualain Laa Huhule-haradoin daleꞌ reu, de hai ra roti fo riꞌ malaka agama ra fee basan neuꞌ Manetualain, de raa. Sekonaa te adaꞌ noi malaka agama ra siꞌ bole raa, tehuu lahenda fekeꞌ sona ta bole fa. Baꞌi Daud asa raa, tehuu ta hapu lahenda sale si fa.” ");
INSERT INTO rgu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Boe ma Yesus nafada tamba bali nae, “Emi bosoꞌ mafarene henin mae, Manetualain tao fai hahae aoꞌ fo dadi ua-naleꞌ ela tulu-fali ita lahenda dae-bafoꞌ a. Tehuu Ana ta adu ita lahenda dae-bafoꞌ a fo tuka adaꞌ noi fai hahae aoꞌ a atoran na. ");
INSERT INTO rgu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","De Au, Lahenda Teteaꞌ. Au anuu hak fo ae lahenda bole, do ta bole tao hata-hata esa naraa laꞌe fai hahae aoꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Basa ria, boe ma Yesus fali selu leo uma mamasoꞌ a neu. Nai na Ana nita lahenda esa mate liman seri. ");
INSERT INTO rgu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nai naa boe, hapu lahenda hida rasaka enoꞌ fo sale neuꞌ Yesus. De, ara mamaꞌu Ni, ela ara nau bubulu Ana puli lahenda ria naraa laꞌe fai hahae aoꞌ, do taꞌa. ");
INSERT INTO rgu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Boe ma Yesus naloo lahenda fo mate liman seri a nae, “Maiꞌ mata ia fo mapadeiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Boe ma Ana natane neuꞌ lahenda sira nae, “Kalu tuka ita atoran agama na, sona ita bole tao hata ubeaꞌ naraa laꞌe fai hahae aoꞌ? Ita tao malole, do taꞌa? Ita puli lahenda do, taisa lahenda?” Tehuu basa si roi neneeꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Boe ma Yesus dale Na susa naan seli, nana huu ara tao daleꞌ noi neuꞌ sira atoran agama na, tehuu ta tao daleꞌ neuꞌ lahenda fo mate liman seri a. Boe ma Ana namanasa, de relu naleleiꞌ asa. Basa de nafada lahenda ria nae, “Looꞌ lima ma mai leo!” Lahenda ria looꞌ lima na, kekeneu te lima na malole na tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Basa de, lahenda Farisi ra foa ela uma mamasoꞌ ria. Ara reu rala haraꞌ roo lahenda reme Herodes lahenda nara partei na, fo saka enoꞌ nau raisa Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Laiꞌ esa de, Yesus no ana mana tuka dea nara leo dano Galilea a suu na reu. Tehuu, no lahenda dodouꞌ ramanene hata fo Ana tao ni so a, huu ria na remeꞌ basa koroꞌ ara mai fo tuka Ni. Ara reme propinsi Galilea, propinsi Yudea, ma propinsi Idumea. Hapu lehenda fekeꞌ ruma boe remeꞌ kota Yerusalem mai, kota Sidon, ma kota Tirus. Ma hapu fekeꞌ boe reme lee Yarden pooꞌ dulu mai. Basa si saka Yesus fo nau raneta roon. ");
INSERT INTO rgu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huu no lahenda dodouꞌ, losaꞌ Yesus nadenu ana mana tuka dea nara fo sadia saka fee Ni ofaꞌ esa. Ana nau dedea nai ofaꞌ lain, ela basa si ramanene, ma Ana bosoꞌ nahapaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Maꞌulun na, Ana parna puli na lahenda kamahedis dodouꞌ. Huu ria na besaꞌ ia basa lahenda kamahedis ara raseti ao fo nau oi laꞌe Ni. ");
INSERT INTO rgu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tepoꞌ fo lahenda nitu hekeꞌ ara rita Ni, tutiꞌ a ara tuꞌu reu, losaꞌ mata-idu nara laꞌe dae a nai Yesus matan. Basa boe ma ara kasi rae, “O ia nana Manetualain Anan.” ");
INSERT INTO rgu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ana horo si nae, “Emi bosoꞌ mafada lahenda mae, Au ia nana bea.” ");
INSERT INTO rgu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Basa de Yesus ae leo leteꞌ esa lain neu. Ana naloo na lahenda hida fo laꞌe dale Na. Boe ma ara leo mata Na mai. ");
INSERT INTO rgu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tutiꞌ a Ana tudu na lahenda sanahulu dua. Ana nafada neuꞌ asa, “Au here a emi ela tuka mahere Au, dadi meuꞌ Au lahenda nadedenu ki. Au boe nau adenu emi fo meu tui-mafada Manetualain Tutui Malole Na neuꞌ basa lahenda ra. ");
INSERT INTO rgu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma Au nau fee emi kuasa, ela emi usi heni nitu ra reme lahenda ra mai.” ");
INSERT INTO rgu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Lahenda kasanahulu dua ara nade nara si ia: Simon (fo riꞌ Yesus feen nadeꞌ Petrus), Yakobis, Yohanis, (Yakobis no fadin Yohanis, dua si nana Sabadeos ana nara. Yesus fee si nade ‘Boanerges’, sosoa na ‘sama leoꞌ tatas’.) Anderias, Filipus, Bartolomeos, Mateos, Tomas, Yakobis (Alpius ana na), Tadius, Simon (fo tuka partei Selot), ma Yudas Iskariot, (ria riꞌ neuꞌ ko seꞌo heni Yesus Kristus). ");
INSERT INTO rgu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Basa ria boe ma, Yesus no ana mana tuka dea nara onda faliꞌ reme leteꞌ lain mai. Boe ma ara masoꞌ leo uma daleꞌ reu. Tehuu lahenda dodouꞌ mai eo raa Ni, losaꞌ Yesus asa ta hapu lelaꞌ fo raa-rinu soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lahenda ra rita leoꞌ na boe ma rae, “Soba mete neuꞌ Yesus dei. Ana nafarene henin de ta nafaduli ao-ina na.” Huu no kileoboboki nara ramanene lahenda dedea rae leoꞌ na, de ara nau mai roo faliꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tepoꞌ ria mese agama ra reme Yerusalem mai, de rafada lahenda fo rai naa rae, “We! Emi bosoꞌ tuka Yesus ria. Huu fo Ana bisa usi heni nitu leoꞌ na, nana huu Ana hapu kuasa neme nitu ra malaka na mai, fo riꞌ lehenda biasa raloon rae, Baalsebul.” ");
INSERT INTO rgu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus namanene leoꞌ na, boe ma Ana naloo na basa si, de nae, “Ta laꞌe fa. Tao leoꞌ bea de nitu ra malaka na bisa usi seluꞌ ria ao-ina na! ");
INSERT INTO rgu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Maneniko nai nusaꞌ esa daleꞌ, ana raun ara ranala ao seluꞌ, sona tao leoꞌ bea fo nusaꞌ ria bei bisa nanenete! ");
INSERT INTO rgu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma kalu uma isiꞌ ara rarau ao esa no esa, sona tao leoꞌ bea fo ara bei bisa ranenete! ");
INSERT INTO rgu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Leoꞌ na boe maneniko nitu ra esa musu no esa, tantu ara rabika-rabati. Kalu leoꞌ na sona ara ralulutuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Maneniko lahenda nau mai ofe neni hata nai lahenda baraꞌai esa uman, ana muste heke naisaꞌ lahenda ria dei. Besaꞌ ko ana bisa ofe neni lahenda ria hata-heton. ");
INSERT INTO rgu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","De, Au afada memaꞌ emi: Manetualain sadia sae-safe heni lahenda salan. Ma kalu lahenda dedea tadaluꞌ laꞌe lahenda fekeꞌ, Manetualain bei sadia fee ampon neuꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tehuu maneniko hapu lahenda raparani dedea tadalu laꞌe Manetualain Dula-dale Malalao-malalafu Na, sona losa dae-bafoꞌ a noe boe oo, Manetualain ta fee ni ampon fa.” ");
INSERT INTO rgu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus nae leoꞌ na, nana huu ara rae, “Lahenda ria nitu ra heke ran so!” ");
INSERT INTO rgu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Basa boe ma, Yesus mama na, no fadi nara, leo uma ria reu, fo nau raneta roo Ni. Nai na ara rapadei rahani uma deaꞌ de radenu lahenda reu raloo Ni. ");
INSERT INTO rgu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tepoꞌ ria Yesus natuuꞌ dedea no lahenda dodouꞌ. Boe ma lahenda mai rafada rae, “Papa, é! Mama ma no fadi mara rai deaꞌ. Ara nau raneta roo Papa.” ");
INSERT INTO rgu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tehuu Yesus nataa nae, “Au mama ka ma toronoo matetu kara siꞌ, bea?” ");
INSERT INTO rgu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Basa de Ana mete leo lahenda fo ratuuꞌ eo raa Ni a. Boe ma Ana dedea nae, “Emi basa ia, nana Au mama ka ma Au toronoo matetu kara. ");
INSERT INTO rgu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Huu fo bea riꞌ tuka Manetualain hihii-nanaun, sona sira nana tebe-tebe Au kileoboboki kara.” ");
INSERT INTO rgu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Laiꞌ esa de, Yesus leo dano Galilea a neu seluꞌ. Boe ma lahenda dodouꞌ mai eo raa Ni. Basa boe ma Ana ae leo ofa mananafuꞌ esa nai naa lain neu, de natuuꞌ fo nanori-nafada. Basa lahenda manai madaꞌ lain ramanene neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Boe ma Ana nanori si pake dedea nasasamaꞌ dodouꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Emi nenene matalole, o! Hapu lehenda esa neu kari bini-kee nai oka-tine na. ");
INSERT INTO rgu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tepoꞌ fo ana kari bini-kee ra hapu ruma tuda rai enoꞌ a. Manupuiꞌ ara mai de seseu rabasa bini-kee sira. ");
INSERT INTO rgu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tehuu hapu bini-kee ruma tuda rai dae batu. Bini-kee sira ranupu lalaiꞌ. Tehuu, no dae a niis a, ");
INSERT INTO rgu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","de tepoꞌ fo ledo a nahaa, boe ma nupu nara mamale de ramatuu henis. Huu fo oka nara ta losa dae daleꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hapu bini-kee ruma tuda rai dae matemaꞌ. Boe ma matemaꞌ ara amu raisa nupuꞌ sira losaꞌ ta bisa raboa fa. ");
INSERT INTO rgu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tehuu hapu bini-kee ruma tuda nai dae isiꞌ. Bini-kee sira ranupu, basa de rambau-ina losaꞌ raboa. Ruma reni faliꞌ buna-boaꞌ laiꞌ telu hulu, ruma laiꞌ nee hulu, ma ruma losa laiꞌ natun esa. ");
INSERT INTO rgu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","De, emi bea manuu ridooꞌ, sona, nenene matalolole, o!” ");
INSERT INTO rgu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Basa de, faiꞌ fo Yesus mesaꞌ ana, ana mana tuka dea kasanahulu duan sira, ma lahenda fekeꞌ hida fo riꞌ ramanene Yesus nanori-nafadan sira so a, ara mai raneta roo Ni. Ara hule fo Ana nafada dedea nasasamaꞌ ria sosoa na. ");
INSERT INTO rgu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Boe ma Yesus nataa nae, “Huu fo emi nau bubulu matetuꞌ Manetualain pareta na, huu ria na de Au afada memaꞌ dedea nasasamaꞌ ria sosoa na. Tehuu maneniko lahenda fekeꞌ, sona Au anori si pake dedea nasasama. ");
INSERT INTO rgu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Lahenda fekeꞌ sira sama leoꞌ Manetualain mana nesimata na duiꞌ memaꞌ so nae, ‘Ara rita so, tehuu ta nau bubuluꞌ fa. Ara ramanene so, tehuu ta nau ralelaꞌ fa. Nemeꞌ na fo ela ara bosoꞌ ramahere neuꞌ Manetualain, fo ta parluu Ana fee ampon neuꞌ asa bali.’ ” ");
INSERT INTO rgu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Basa boe ma, Yesus nafada si dedea nasasamaꞌ ria sosoa na nae, “Ae! Kalu emi bei ta mala dedea nasasamaꞌ ria sosoa na, sona tao leoꞌ bea fo emi bisa mala dedea nasasama fekeꞌ ara sosoa na? ");
INSERT INTO rgu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","De ria sosoa na leo iaꞌ: lahenda manakari bini-kee ria, nana sama leoꞌ lahenda fo tui-beka Manetualain Dedea-nafadan. ");
INSERT INTO rgu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma bini-kee fo tuda rai enoꞌ a losaꞌ manupuiꞌ ara raa henis, sama leoꞌ lahenda fo namanene Manetualain Dedea-nafadan. Tehuu ta doo bea boeꞌ, te nitu ra malaka na mai de hai neni Dedea-nafada a nemeꞌ lahenda ria dale na mai. ");
INSERT INTO rgu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bini-kee fo tuda rai dae batu, sama leoꞌ lahenda fo namanene, ma sipoꞌ Dedea-nafadaꞌ ria no namahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tehuu Dedea-nafadaꞌ ria ta naoka fa. Huu ria na, ta namanoso nai lahenda ria dale na. Faiꞌ fo lahenda fekeꞌ a tao nasususaꞌ ana, huu no ana sipoꞌ Dedea-nafadaꞌ ria, ana tuꞌu heni tutiꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma bini-kee fo tuda rai matemaꞌ a talada, sama leoꞌ lahenda fo namanene Dedea-nafadaꞌ ria so. ");
INSERT INTO rgu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tehuu ana nasapute no nafaduli rupaꞌ ara ela bisa nasoda rela-saꞌa a. Boe ma basa nafaduliꞌ sira, seti heni Dedea-nafadaꞌ ria neme dale na mai, losaꞌ ta hapu buna-boaꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tehuu bini-kee fo tuda nai dae isiꞌ a, sama leoꞌ lahenda fo namanene natalolole Dedea-nafadaꞌ ria, ma tuka Manetualain hihii-nanaun. Basa de ana tao hata malole, sama leoꞌ bini-kee mabuna-maboa ria. Hapu ruma rabuna-raboa laiꞌ telu hulu, ruma laiꞌ nee hulu, ma ruma laiꞌ natun esa.” ");
INSERT INTO rgu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus dedea naroo nemeꞌ ofaꞌ ria lain mai. Ana fee tamba seluꞌ dedea nasasamaꞌ esa bali nae, “Leoꞌ bea! Emi parna do taꞌa, mita lahenda pake dedede anaꞌ a, basa nana tatana etu ni nai lapaneu daleꞌ! Do, tao ni neuꞌ roaꞌ a fiki dale na? Taꞌa hete? Kalo tao leo naꞌ, sona ta nahaa soꞌ. Lahenda muste tao dededeꞌ ria neuꞌ mamana madema ela nahaa. ");
INSERT INTO rgu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","De, hata fo besaꞌ ia nananafuniꞌ boe, neuꞌ ko nananitaꞌ. Ma hata fo besaꞌ ia lahenda ta ralelaꞌ ana, neuꞌ ko nananalelaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","De, bea nanuu ridooꞌ, sona nenene natalolole. ");
INSERT INTO rgu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Naa, afi matalolole! Kalu emi uku-sudi lahenda fekeꞌ a nonoi-tataon, sona lahenda uku emi leoꞌ na boe. Manetualain boe uku emi leoꞌ na. Tehuu Ria uuku na bera lena bali. ");
INSERT INTO rgu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Maneniko lahenda nau saka matetuꞌ Manetualain hihii-nanaun, sona ana tamba malelaꞌ. Tehuu maneniko lehenda ta tao daleꞌ neuꞌ Manetualain hihii-nanaun, sona ana boe-boe pakanaa.” ");
INSERT INTO rgu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Basa boe ma Yesus dedea tamba bali nae, “Manetualain nusa Na tamba bauinaꞌ sama leoꞌ bini-kee fo lahenda kari ni nai oka-tine. ");
INSERT INTO rgu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Leo mae lahenda ria fali fo suku-foa, ta nafarene bini-kee sira soꞌ. Tehuu bini-kee sira ranupu ma rambau-ina raroo. ");
INSERT INTO rgu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Huu fo bini-kee sira mori ao nara rai dae a, mulai rarana, rabuna, losaꞌ raisi. ");
INSERT INTO rgu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maneniko hade a namatasa, sona manuu okaꞌ a noi mai oruꞌ a. Manetualain nusa Na leoꞌ na boe. Basa sira nana, Manetualain riꞌ nonoi-tataon.” ");
INSERT INTO rgu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Basa ria boe ma, Yesus dedea naroo nae, “Au tamba seluꞌ nasasamaꞌ esa bali, leo iaꞌ: emi bisa mararaaꞌ Manetualain lahenda nara. Ara mulai reme baianaꞌ a mai, tehuu doo-doo boe ma, ara tamba dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ria sama leoꞌ aidekeꞌ fo aanaꞌ a naan seli. ");
INSERT INTO rgu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tehuu kalu ita sele aidekeꞌ ria, sona ana mori mai te dadi neuꞌ ai-huu bauinaꞌ. Boe ma manupuiꞌ ara mai saka ailaoꞌ de rarunu reuꞌ na.” ");
INSERT INTO rgu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ria nana Yesus eno nanori na neuꞌ asa tuka sira duduꞌa-aꞌafin. ");
INSERT INTO rgu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kalu nanori lahenda ra, sona Ana biasa pake dedea nasasamaꞌ. Tehuu maneniko Ana nanori ana mana tuka dea nara, sona nafada dedea nasasamaꞌ ria sosoa na katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ledo leodaen ria, Yesus bei nai ofaꞌ lain. Boe ma Ana nadenu ana mana tuka dea nara nae, “Hela laa fo ita leo seriꞌ teu.” ");
INSERT INTO rgu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Basa de, ara saꞌe ofaꞌ sama-sama roo Yesus. Boe ma ara laꞌo ela lahenda kadodouianaꞌ sira reuꞌ na. Tehuu hapu ruma saꞌe tuka ofa fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Faiꞌ ria, Yesus fua laka Na neuꞌ ainulu a de suku namanee nai ofa buiꞌ. Ta doo bea boeꞌ te ruli a mai. Nafa ra totoꞌo de, oe a nala Yesus asa ofan daleꞌ, losaꞌ kura baiꞌ henun. De ana mana tuka dea ra bii mamateꞌ. Boe ma ara mai fafae Yesus rae, “Papa! Foa dei! Ita sakaꞌ bolo riaꞌ so. Tehuu Papa ta taoꞌ daleꞌ neuꞌ ami fa!” ");
INSERT INTO rgu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus namanene leoꞌ na, boe ma Ana foa, de nasaꞌai ani a nae, “Tena leoꞌ!” Basa boe ma ana pareta dano ria nae, “Mamate leo!” Ani ria namate tutiꞌ a, ma tasiꞌ a boe tena tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Basa boe ma Yesus nasaꞌai ana mana tuka dea nara nae, “Ubeaꞌ taon de emi basa biiꞌ leoꞌ na? Emi ta mamahere Au fa, do?” ");
INSERT INTO rgu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Basa si biiꞌ ma roi ramakokoaꞌ a, boe ma ara bei dea rae, “Ria nana bea, e? Losaꞌ ani a no nafa ra boe ramanene neuꞌ Ana, o!” ");
INSERT INTO rgu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Basa boe ma, Yesus no ana mana tuka dea nara losa dano Galilea a seriꞌ, rai mamanaꞌ esa nade Gerasa. ");
INSERT INTO rgu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Nai na hapu touꞌ esa nitu ra heke raan losa namulun. Ana leo nai rates ara. Hatu leledon leiꞌ-lei nafeo basa leteꞌ manai naa ra, ana poiraoꞌ, ma kasi-kasi mesan. Ma tututu na ao-ina na, hinaꞌ-hinaꞌ mesan neniꞌ batu. Tehuu baraꞌai na seli. Ta hapu lahenda bisa heke ran fa, leo mae reniꞌ rante besi boe ta ralan fa. Lahenda ra heke lima-ein kose-kose reniꞌ rante besi, tehuu rui naꞌetu rante besi ria, ma helu na tepa besi a neme ei na mai. Baraꞌai na seli losaꞌ ta hapu lahenda esa bisa ena ralan boeꞌ. Yesus asa onda reme ofa lain mai de molo ei nara nai madaꞌ lain, boe ma lahenda kamulus ria teo nita si reme doo a mai so. Basa de ana kalua neme rates sira, mai, de nalai leo Yesus neu, boe ma sundaꞌ undu laka na neu Yesus mata Na. ");
INSERT INTO rgu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus nita lahenda ria mata-idun leo naꞌ, boe ma nae, “We! Nitu makaresiꞌ! O kalua memeꞌ lahenda ia mai leo!” Boe ma, lahenda ria kasi namberaina nae, “He! O nau tao au leo beaꞌ! Au bubuluꞌ O ia, nana tebe Yesus, Manetualain Manakuasa a Anan. Au hule fo O bosoꞌ ese-rumu au, o!” ");
INSERT INTO rgu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Boe ma Yesus natane ni nae, “O nade bea?” Lahenda ria nataa nae, “Au nade Legion, huu fo ami ia nana dodouꞌ naan seli, nonooꞌ leo soldadu batalyon dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nitu ra pake lahenda ria fo hule Yesus bosoꞌ nadenu si kalua remeꞌ nusaꞌ ria mai. ");
INSERT INTO rgu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta dooꞌ a neme naꞌ mai hapu lahenda hida ranea bafi roka esa. Bafi sira bate rifun dua nuun. Ara totofi saka nanaaꞌ nai leteꞌ a suuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Boe ma nitu sira hule Yesus rae, “Madenu ami fo masoꞌ leo bafi sira daleꞌ meu.” ");
INSERT INTO rgu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus namanene leoꞌ na, boe ma nataa. Boe ma nitu sira kalua reme lahenda ria mai de leo bafi ra daleꞌ reu. Bafi rifu kaduaꞌ sira ralai ratotofaꞌ onda tuka leteꞌ a suu na leo dano daleꞌ reu, boe ma ara bolo de mate laesaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lahenda manea bafi ra rita leoꞌ na, boe ma ara bii mamateꞌ. Basa de ara ralai reu rafada basa lahenda rai koro maneneaꞌ sira. Boe ma lahenda dodouꞌ kalua mai fo nau reu rita hata manadadi ubeaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ara mai raneta roo Yesus, ara rita lahenda nitu hekeꞌ ria natuuꞌ nai na boe. Duduꞌa-aꞌafin malole a so, ma ana pake bua-loas so. Lahenda sira rita leoꞌ na, boe ma basa si bii, nana huu ara bubuluꞌ bea riꞌ bisa usi heni nitu dodouꞌ remeꞌ lahenda ria mai, sona memaꞌ ria lahenda kahereꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Boe ma basa si rafafada aoꞌ rae, ara rita mataꞌ lahenda kamulus ria malole na aon so, ma bafi sira bolo de mate basa si so. ");
INSERT INTO rgu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Boe ma lahenda koro isiꞌ ara mai hule Yesus fo foa ela sira mamana na. ");
INSERT INTO rgu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tepoꞌ fo Yesus sakaꞌ ae leo ofaꞌ lain neu, boe ma bisinaꞌ a lahenda nitu hekeꞌ a mai hule neuꞌ Ana fo ria nau tuka boe. ");
INSERT INTO rgu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tehuu Yesus ta nau fa. Ana nafada nae, “Malole lenaꞌ o fali fo mafada katemaꞌ kileoboboki mara, hata fo Manetualain tao ni soa neuꞌ o so a. Ma mafada mae Manetualain sue na o seliꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Basa boe ma, lahenda ria fali de neu nafeo basa nusaꞌ esa ma kota sanahulu fo riꞌ biasa rae, ‘Dekapolis’. Ana tui hata fo Yesus tao ni soa neuꞌ ana. Basa lahenda fo ramanene tutui ni ria, ara heran mamateꞌ rae, “Memaꞌ tebe, o!” ");
INSERT INTO rgu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Basa boe ma Yesus asa saꞌe ofaꞌ fali leo dano a seriꞌ reu. Faiꞌ fo ara onda reme ofaꞌ lain mai, lahenda dodou-inaꞌ mai eo raa Ni. ");
INSERT INTO rgu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nai na boe hapu lahenda esa nade Yairus. Ria nana malaka uma mamasoꞌ nai kota ria. Ana bei nita Yesus, boe ma ana sundaꞌ undu laka na neu mata Na ");
INSERT INTO rgu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","de ana hule nae, “Papa, é! Au anafeto ana ka besaꞌ ko teu ni sanahulu dua, namahedi noi mamaten. Papa tulu-fali fo mai puli maan dei.” ");
INSERT INTO rgu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Boe ma Yesus tuka leo Yairus uma na neu. Tehuu ara mulai laꞌo, lahenda dodouꞌ tuka Ni, losaꞌ ara raseti ao neme po ii ma po ona Na mai. ");
INSERT INTO rgu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nai lahenda kadodouꞌ ina sira talada, hapu inaꞌ esa namahedi ina na ta teꞌe matetuꞌ fa teuꞌ sanahulu dua so. ");
INSERT INTO rgu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana nabasa doi-talin ma hata-heton fo bae doter ara. Tehuu ta hapu esa bisa puli nan boeꞌ, hedi ni ria foe naroo. ");
INSERT INTO rgu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Inaꞌ ria namanene dodouꞌ laꞌeneuꞌ Yesus so. De, ana naseseti nai lahenda kadodouꞌ sira talada, fo nau naneneaꞌ nesiꞌ Yesus dea Na. Ana afi nai dale na nae, “Sadi au oi laꞌe badu Na boe oo, au muste teꞌe a ao ka.” Faiꞌ fo ana oi laꞌe Yesus badu Na, boe ma kekeneu te hedi na teꞌe tutiꞌ a. Ana nameda naan malole a matetuꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Naraa no besaꞌria boe, Yesus nameda nan hapu baraꞌai kalua neme ao Na daleꞌ mai. Boe ma Ana lipe dea Na de mete lahenda kadodouꞌ sira. Basa de Ana natane nae, “Emi bea riꞌ oi laꞌe Au badu ka, é?” ");
INSERT INTO rgu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana mana tuka dea nara rataa rae, “Papa ka mete aom leo. Lehenda desi-desi basa ia raseseti ao na. Papa matane mae, ‘Bea riꞌ oi laꞌe Au badu ka?’ ” ");
INSERT INTO rgu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tehuu Yesus mete naleleiꞌ, fo nau bubuluꞌ bea riꞌ bisi naꞌ a oi laꞌe Ni. ");
INSERT INTO rgu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Inaꞌ ria namanene Yesus natane nae leoꞌ na, boe ma ana bii mamateꞌ. Basa de ana sunda undu laka na neuꞌ Yesus mata Na de manaku basa-basan nae, “Papa! Au riꞌ oi laꞌe Papa badu ma.” ");
INSERT INTO rgu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus nataa ni nae, “Huu no mama mamahere tebe-tebe neuꞌ Au, de mama teꞌe ma aom so. Besaꞌ ia, mama fali no namahoꞌo leo.” ");
INSERT INTO rgu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus bei dea-dea nae leoꞌ na, te hapu lahenda esa neme Yairus uma na mai, de nafada nae, “Kasian, anafeto anaꞌ a maten so. De bosoꞌ tao masosota Papa Mesen, fo bosoꞌ neu bali.” ");
INSERT INTO rgu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tehuu Yesus ta tao daleꞌ neu lahenda ria dedea na fa. De, Ana nafada Yairus nae, “Bosoꞌ o bii, e! Mamahere neuꞌ Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Boe ma Yesus laꞌo ela ana mana tuka dea feke nara. Tehuu no Petrus, Yakobis no fadin Yohanis, fo laꞌo raroo. ");
INSERT INTO rgu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Faiꞌ fo ara losa Yairus uma na, ara rita lahenda dodouꞌ rapue raan seliꞌ, ma ramanene ruma boreu. ");
INSERT INTO rgu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus kodi uma daleꞌ neu. Boe ma Ana natane si nae, “Ubeaꞌ taon de emi mapue ma boreu leoꞌ ia? Anaꞌ ia ta maten fa. Ana adaꞌ noi suku ria!” ");
INSERT INTO rgu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ara ramanene Yesus dedea nae leoꞌ na, boe ma basa si hiꞌa ma ramumulu Ni. Basa de Ana nadenu basa si deaꞌ reu. Boe ma Ana naloo na anaꞌ ria ina-ama nara, ma ana mana tuka dean telu, de basa si masoꞌ leo kama daleꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesus tai na anaꞌ ria lima na, basa boe ma Ana pake sira dedea Aram a, de dedea neuꞌ anaꞌ a nae, “Talita kum!” (Sosoa na nae, “Anafeto anaꞌ! Foa leo!”) ");
INSERT INTO rgu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Kekeneu te, anafeto anaꞌ ria foa de mulai lalaꞌo. Boe ma Yesus nadenu anaꞌ a mama na nae, “Fee ni naa leo!” Basa lahenda fo rita hata mandadiꞌ ria, boe ma roi ramakokoaꞌ a. Tehuu Yesus horo si nae, “Emi bosoꞌ mafada lahenda esa boe mae, Au fee ni nasoda seluꞌ so!” ");
INSERT INTO rgu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Basa boe ma, Yesus no ana mana tuka dea nara fali leo Yesus koro na nai Nasaret. ");
INSERT INTO rgu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Naraa no lahenda Yahudi ra fai huhule-haradoin, Yesus masoꞌ leo uma mamasoꞌ daleꞌ neu de nanori-nafada. Faiꞌ ria lahenda dodou reu hule-haradoi. Ara ramanene Yesus nanori-nafadan, boe ma ara roi leleuꞌ laka nara, de rae, “Lahenda ia malela na seli! Ria boe nanuu kuasa! Tao leoꞌ bea de Ana bisa leoꞌ na? ");
INSERT INTO rgu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sekonaa te Ria adaꞌ noi tukan ai. Ita talelaꞌ Ria mama na riꞌ Maria; ma fadi nara siꞌ Yakobis, Yoses, Yudas no Simon. Ana nanuu fadiꞌ anafetoꞌ hida boe. Ita basa leo nai koro esa, na!” Huu ria na, de eteꞌ ao nara losa ara ta nau ramanene Ni soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Boe ma Yesus nafada nae, “Memaꞌ tebe! Lahenda rahiiꞌ fee hada-horomata neuꞌ Manetualain mananesimatan neme mamana fekeꞌ mai, lena neme nai koro-tadun.” ");
INSERT INTO rgu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Tehuu lahenda sira dale nara mepe na seli, losaꞌ ara ta nau ramahere neuꞌ Yesus soꞌ. Huu ria na Ana heran, boe ma ta natudu kuasa Na nai na soꞌ. Ana puli na adaꞌ noi lahenda kamahedis esa-dua. ");
INSERT INTO rgu_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Basa boe ma, Yesus laꞌo nafeo basa koro maneneaꞌ sira fo nanori lahenda ra Manetualain hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ana naloo na ana mana tuka dea kasanahulu dua nara, fo nadenu si laꞌo dua-dua, reu tui Manetualain Tutui Malole Na. Yesus fee si kuasa ela ara usi nitu. ");
INSERT INTO rgu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ana pareta si nae, “Emi bosoꞌ meni hata dodouꞌ nai enoꞌ. Boso meni tua-lepa, doiꞌ ma saku. Meni teteꞌe ma pake tabeis, ma badu bai esaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maneniko hapu lahenda sipoꞌ emi nai sira uma nara, sona emi muste leo mahaniꞌ naa, losaꞌ fai fo emi laꞌo. ");
INSERT INTO rgu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tehuu maneniko losa mamanaꞌ esa, boe ma lahenda manai naa ra ta sipoꞌ, ma ta nau ramanene neuꞌ emi fa, sona laꞌo ela mamanaꞌ ria. Basa sona mafada si mae, ‘Emi ta nau mamanene fa. De, ela leoꞌ bea na emi lepa ao mara natataaꞌ a!’ ” ");
INSERT INTO rgu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Basa boe ma, ara reu tui Tutui Malole ria. Ara rae basa lahenda ra muste hahae reme sala-siko nara mai, fo ratafali mai tuka Manetualain hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ara usi heni nitu ra boe. Ara tao mina neuꞌ lahenda kamahedis ara laka nara, fo hule-haradoi fee si. Boe ma ara teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tepoꞌ ria, lahenda nai basa mamana ara ralelaꞌ Yesus so. Tutuiꞌ laꞌeneuꞌ Ria kuasa Na boe, mane Herodes a namanenen so. Hapu lahenda rae, “Yohanis Mana Saraniꞌ a, nana nasoda seluꞌ nai Yesus ao-ina Na! Huu ria na, de Ana bisa tao tanda heran dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tehuu lahenda ruma rae, “Taꞌa! Ia nana Elia fo riꞌ nasoda seluꞌ nai Ria ao-ina na.” Lahenda ruma bali rae, “Fo, Manetualain mana nesimata feke nara reme fai a ulun mai.” ");
INSERT INTO rgu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tehuu tepoꞌ fo mane Herodes a namanene ara dedea Yesus leoꞌ na, boe ma ana nataa nae, “Ria nana tantu Yohanis Mana Saraniꞌ fo faiꞌ naa raa au adenu tete heni laka na. Besaꞌ ia ana nasoda seluꞌ bali, o!” ");
INSERT INTO rgu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mane Herodes a nadenu leoꞌ na, nana huu ana nala dedea bauinaꞌ no Yohanis. Tutui na leoꞌ ia: mane Herodes a sao na fadin Filipus saoina na, nade Herodias. Sekonaa te Filipus no Herodias beita ramaetuꞌ fa. Huu ria na de Yohanis nasaꞌai ni kokosen nae, “Papa Mane ta bole sao seluꞌ fadi ma sao na fa. Huu fo ria nanadadi nalena lakaꞌ neuꞌ ita hada Yahudi na!” Tehuu Herodes sao na inaꞌ ria. Basa boe ma, ana nadenu lahenda reu hopu ra Yohanis fo enan neuꞌ bui daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huu no Yohanis nasaꞌai kokosen leoꞌ na, boe ma rina Herodias napeda daleꞌ fo nau naisa ni. Tehuu beita hapu lelaꞌ fa, huu fo Herodes ena ni nai bui daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Boe ma ana nadenu soldadu ra fo ranea ratalolole ni. Memaꞌ Herodes lelee Yohanis. Ana bubuluꞌ nae, Yohanis nana, Manetualain riꞌ feen mai. Ma ria nana lahenda malole. Memaꞌ Herodes nahiiꞌ namanene Yohanis dedea-nafadan. Tehuu laiesa-laiesa nai ria, dale na ta nahiiꞌ namanene Yohanis dedea-nafadan fa. ");
INSERT INTO rgu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Basa ria, boe ma mama Herodias hapu lelaꞌ fo balas ria dale hedi na. Faiꞌ ria ara tao Mane Herodes a fai boboki na. Ara raloo lahenda bauinaꞌ ara mai raa fai bobokiꞌ. Manamai sira nana, mana pareta, soldadu ra malaka na, ma lasi hadas Galilea ra. ");
INSERT INTO rgu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Feta losa talada boe, mama Herodias anafeto ana na neu roke. Roroke na malole na seli, losaꞌ tao na Herodes no fui nara ramahoꞌo. Boe ma Herodes naloo nan, de natane ni nae, “O nau hule au sudi hata ubeaꞌ a, sona mafada! Neuꞌ ko au fee. ");
INSERT INTO rgu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Leo mae o hule au nusa pareta ka seri boe oo, au fee. Au soo-supa uniꞌ Manetualain nade na.” ");
INSERT INTO rgu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Boe ma anafeto anaꞌ ria neu natane mama na nae, “Mama! Au hule papa ka hata malole ubeaꞌ?” Boe ma mama na nataa nae, “Naa! Mu fo hule Yohanis laka na.” ");
INSERT INTO rgu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Basa boe ma, anafeto anaꞌ a neu nafada Maneꞌ a nae, “Papa! Au hule fo muni fee au Yohanis laka na, tao ni neuꞌ dulang esa dale. Besaꞌ ia boe!” ");
INSERT INTO rgu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes namanene na ria, boe ma mopo tutiꞌ aafi na. Tehuu ana ta bisa hela faliꞌ sosoo-susupan ria soꞌ, huu fo lahenda ra ramanene basa so. ");
INSERT INTO rgu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Basa boe ma, ana pareta malaka soldado esa fo neu tete na Yohanis laka na neme bui daleꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Boe ma ara tete ra Yohanis laka na, taon neuꞌ dulang esa daleꞌ, de feen leo anafeto anaꞌ a neu. Ana sipo na dulang ria, boe ma oꞌo nenin leo mama na neu. ");
INSERT INTO rgu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanis ana mana tuka dea nara ramanene rae, reni Yohanis laka na so, boe ma ara mai oꞌo ra popora na, fo reu ratoin. Yohanis mamate na, tutui na teꞌe adaꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Faiꞌ esa boe ma, ana mana tuka dea fo Yesus nadenu si a, basa si fali de rabua seluꞌ roo Ni. Ara tui basa-basan fo sira taon, ma hata fo sira ranori-rafadan neuꞌ lahenda ra so a. ");
INSERT INTO rgu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tehuu tepoꞌ ria, lahenda dodou-inaꞌ reu-mai fo saka Yesus, losaꞌ no ana mana tuka dea nara ta hapu lelaꞌ fo raa-rinu fa. Boe ma Yesus nafada ana mana tuka dea nara nae, “Mai ita teu saka mamana lino-nees fo hahae baiꞌ dei.” ");
INSERT INTO rgu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","De, basa si ae leo ofaꞌ lain reu fo saka mamana lino-nees dooꞌ a neme koroꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tehuu lahenda kadodouinaꞌ sira rita Yesus asa ofa na tuka-tuka dano ria suu na. Basa boe ma, ara kalua ela koroꞌ a de laꞌo tuka madaꞌ lain, ara losa raꞌuluꞌ Yesus asa. ");
INSERT INTO rgu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tepoꞌ fo Yesus onda neme ofaꞌ lain mai, te Ana nita lahenda dodouꞌ rahani Ni so. Boe ma Ana kasian neuꞌ asa, nana huu sira basa ta buluꞌ rae tao leo beaꞌ, sama leoꞌ bibi-lopo a ta nanuu manafoo fa. Boe ma Ana nanori-nafada si Manetualain hihii-nanaun, ");
INSERT INTO rgu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","nemeꞌ ledo hanan ria mai losa ledo leo daeꞌ. Boe ma ana mana tuka dea nara rafada Ni rae, “Papa! Malole lenaꞌ Papa madenu basa lahenda ia ra reu asa nanaaꞌ nai koroꞌ maneneaꞌ manai ia ra. Huu fo ledo leo daeꞌ ia so, ma ta hapu nanaaꞌ nai ia fa.” ");
INSERT INTO rgu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tehuu Yesus nataa nae, “Boso! Emi riꞌ mahao lahenda ia ra.” Tehuu ara ratane ratafaliꞌ Yesus rae, “Kalu ami mahao lahenda kakabainaꞌ ia ra, sona ami muste kalua doiꞌ dodouꞌ! Samaleoꞌ tukan esa kadi na teuꞌ esa! Ami hapu tao doi kakabainaꞌ sira leo bea?” ");
INSERT INTO rgu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Boe ma Yesus nataa nae, “Emi meu matatane dei, bate bea nanuu tua-lepa!” Ara reu ratatane fali boe ma, rafada rae, “Hapu roti lima, ma ikaꞌ boaꞌ dua.” ");
INSERT INTO rgu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Basa de, Yesus nadenu basa lahenda sira ratuuꞌ rabubua ao nara reu nau lain. ");
INSERT INTO rgu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Boe ma ara ratuuꞌ rabubua ao nara. Hapu bubuaꞌ ruma lahenda natun esa, ma ruma lima hulu. ");
INSERT INTO rgu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Basa de, Yesus hai na roti kalimaꞌ, ma ika kadua sira. Boe ma Ana nakanaro leo lalai neu fo hule makasi neuꞌ Manetualain. Basa ria, de Ana tetebi roti sira, boe ma loo leo ana mana tuka dea nara reu, fo babati fee basa lahenda sira. Ika kaduaꞌ sira boe babati si. ");
INSERT INTO rgu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Basa lahenda kadodouinaꞌ sira raa losaꞌ rabete. ");
INSERT INTO rgu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Raa basa boe ma, ana mana tuka dea ra rabubuaꞌ ra nanaa lenaꞌ ara, henu lapaneu sanahulu dua. ");
INSERT INTO rgu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sira nana bate lahenda rifun lima. Mananaa besaꞌ ko noi tou nara. Beita rekeꞌ ina ara ro ana nara fa. ");
INSERT INTO rgu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Basa ria boe ma, Yesus nadenu ana mana tuka dea nara saꞌe ra ofaꞌ a fo raꞌuluꞌ leo koro Betsaida a reu nai dano ria seriꞌ. Tehuu Ana bei nahaniꞌ na, ela nadenu faliꞌ lahenda kadodouinaꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Basa si fali, boe ma Ana ae leo leteꞌ esa lain neu, fo hule-haradoi. ");
INSERT INTO rgu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Sakaꞌ hatuꞌ boe ma, Yesus onda faliꞌ. Ana nita ana mana tuka dea nara ofa na losa nai dano a talada so. Tehuu ara sefe sota raan seli, nana huu ani a neme mata mai. Dulu pila boe ma, Yesus neu tuka si. Tehuu Ana laꞌo tuka oe lain. Ana sakaꞌ seli ofaꞌ ria, boe ma ana mana tuka dea nara ritan, de ara kekes ara. Boe ma ratatane aoꞌ rae, “Ae! Hata ubeaꞌ ia? Nitu, do ubeꞌ ia?” Tehuu Yesus dedea noo si tutiꞌ a nae, “We! Emi bosoꞌ biiꞌ, o! Te Au ia!” ");
INSERT INTO rgu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesus ae ofaꞌ lain neu, boe ma ani a namate tutiꞌ a. Ana mana tuka dea nara roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ara besaꞌ ko rita Yesus pake kuasa Na de nahao lahenda rifun lima lenaꞌ. Tehuu ara beita ralelaꞌ matetuꞌ Ria kuasa Na, nana huu dale nara tea-mepeꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tepoꞌ fo ara losa dano a seriꞌ, boe ma ara nafu rai kota Genasaret a namo sesee na. ");
INSERT INTO rgu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ara onda remeꞌ ofaꞌ lain mai, lahenda dodouꞌ rita si so. Boe ma ara bobouꞌ rae, “We! Yesus mai so!” ");
INSERT INTO rgu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Ara ralai reu rafafada aoꞌ esa no esa, boe ma lahenda ra rolo reni lahenda kamahedis ara mai. Eꞌetu dedea na, sadi ramanene rae, hapu Yesus nai mamanaꞌ esa, sona ara rolo reni lahenda kamahedis ara, fo rapeuꞌ asa reuꞌ moo loaꞌ a. Ara afi rae, “Sadi lahenda kamahedis sara oi laꞌe Yesus badu peda Na, tantu ara teꞌe.” Oi laꞌe leoꞌ na boe oo, ara teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lahenda Farisi bubuaꞌ esa, ma mese agama hida reme Yerusalem mai fo raneta ro Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Lahenda Farisi ra hopu rahere sira hada Yahudi nara. Nasasamaꞌ leoꞌ maneniko lahenda sakaꞌ raa-rinu, sona ara muste safe lima nara tuka sira hada na hihii-nanaun. Leoꞌ na boe, kalu fali remeꞌ pasar a mai, ara muste radiu oe dei. Losaꞌ sira rou-raaꞌ manai dapu a, leo-leoꞌ ureꞌ, bikaꞌ, galaas, cerek, muste safe katemaꞌ asa tuka hadas a hihii-nanaun, besaꞌ ko bole raa-rinu reniꞌ. Maneniko hapu lahenda Yahudi fekeꞌ fo ta tuka hadas ria, sona lahenda Farisi ra ramanasa. Huu ria na de, faiꞌ fo rita Yesus ana mana tuka dea nara raa-rinu, ta safe lima nara tuka hadas a hihii-nanaun. Boe ma, ara mai de sale Yesus rae, “Ubeaꞌ taon de o ana mana tuka dea mara raa-rinu, tehuu ta safe raꞌuluꞌ lima nara fa? Ria nana ara ralena laka ita hada na neme bei-baꞌi a mai so!” ");
INSERT INTO rgu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Tehuu Yesus nataa nae, “Emi ia nana tebe lahenda fo dedea fekeꞌ, tao fekeꞌ! Neme uluꞌ mai, baꞌi Yesaya duiꞌ na Manetualain dedea na so nae, ‘Lahenda ia ra io-oa neuꞌ Au, adaꞌ noi bafadoo peda nara, tehuu ta no dale nara fa. Ara tao leoꞌ na boe oo, sosoa-raraaꞌ taꞌa. Ara ta tao daleꞌ neuꞌ Au hihii-nanau Ka, tehuu ara tuka adaꞌ noi lahenda dae-bafoꞌ a hihii-nanaun.’ Emi sama leoꞌ ria boe. ");
INSERT INTO rgu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Emi foa ela Manetualain pareta na, fo nau tuka lahenda dae-bafoꞌ a hada na. Emi memaꞌ tao leo naꞌ sona malela mara seli! ");
INSERT INTO rgu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Fai ulu na baꞌi Musa nafada Manetualain pareta Na so nae, ‘Fee hadaꞌ neuꞌ ina-ama mara.’ Ma nafada seluꞌ bali nae, ‘Kalu lahenda esa doꞌi ina-ama nara, sona muste huku mateꞌ ana.’ ");
INSERT INTO rgu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Manetualain nanori nae leoꞌ na, tehuu emi manori fekeꞌ. Emi mae, ‘Kalu lahenda helu nau fee hata esa neuꞌ Manetualain, sona leo mae ina-ama mara doidoso mamateꞌ boe, tehuu ta bole pake hata sira fo tulu-fali si, huu fo emi helu basa nau fee Manetualain.’ ");
INSERT INTO rgu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Huu ria na bisi naaꞌ a Au afada, emi tuꞌu heni Manetualain hihii-nanaun so, fo katin neniꞌ atoran bebeuꞌ. Hapu atoran dodouꞌ emi kati si leo naꞌ so.” ");
INSERT INTO rgu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Basa boe ma, Yesus naloo na lahenda fekeꞌ manai naa ra de nae, “Pasaꞌ ridooꞌ mara dei, ela emi bubuluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hata fo masoꞌ leo teiꞌ a dale neu, ria ta tao nakekeo-nakakanu lahenda fa. Tehuu hata fo kalua deaꞌ mai, ria riꞌ tao makekeo-makakanuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Naa bea manuu ridooꞌ, sona namanene natalolole!” ");
INSERT INTO rgu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Basa boe ma, Yesus no ana mana tuka dea nara laꞌo ela lahenda sira, de kodi leo uma esa daleꞌ reu. Boe ma ana manatukadea nara ratane dedea nasasamaꞌ ria sosoa na. ");
INSERT INTO rgu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesus nataa nae, “Emi ta bubuluꞌ fa, do? Ria sosoa na leo iaꞌ: hata fo lahenda raa-rinun, nana malole a. Tehuu hata fo kalua mai, sona ta malole a fa. Hata fo ita taa-tinun, masoꞌ leo ita tei na daleꞌ neu, tehuu basa nate kalua mai bali. (Ramatua Yesus dale na nae, lahenda bole naa-ninu sudi laꞌe ubeaꞌ a, ta horo fa.) ");
INSERT INTO rgu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tehuu hata fo kalua neme lahenda dale na mai, ria tao makekeo-makakanuꞌ losaꞌ Manetualain nahiaꞌ ana, ma ta nau nabua noo ni fa. ");
INSERT INTO rgu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Huu fo dedea tadaluꞌ dodouꞌ kalua neme lahenda dale na mai. Samaleoꞌ: duduꞌa-aꞌafi tadaluꞌ, hohoke, naꞌo, kanisaꞌ, ");
INSERT INTO rgu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tendetuu, sosoa-piao, tadaluꞌ, mapuputaꞌ, tuka hihii-nanau aopaaꞌ, naꞌmutiꞌ, dedea natuda lahenda, koaoꞌ, manori taꞌ, laka batuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Basa tadalu leo naꞌ a, kalua remeꞌ lahenda dale na mai. Ria riꞌ tao nalutu ni. Manetualain boe oo nahiaꞌ ana.” ");
INSERT INTO rgu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Basa boe ma, Yesus foa ela mamanaꞌ ria, fo leo kota esa neu nade Tirus. Losa na boe ma, ara kodi leo uma esa daleꞌ reu, huu fo Yesus ta nau hapu lahenda bubuluꞌ Ana nai na. Tehuu ta nafuni nala ao Na fa. ");
INSERT INTO rgu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Naina hapu inaꞌ esa, fo ta lahenda Yahudi fa. Boki ni nai nusa Fenesia, nai propinsi Siria. Tepoꞌ fo ana namanene Yesus mai, boe ma neu hule Yesus fo usi heni nitu nemeꞌ anafeto na mai. ");
INSERT INTO rgu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tehuu Yesus tuꞌu dedeaꞌ nae, “Ana ara muste raa raꞌuluꞌ dei, besaꞌ ko tuꞌu nanaa lenaꞌ sira fee busa a.” Ma nai dale na nananafuniꞌ, Yesus muste tulu-fali naꞌuluꞌ Ria lahenda Yahudi nara dei, besaꞌ ko lahenda fekeꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tehuu inaꞌ ria balas nae, “Tebe leoꞌ na, Papa! Tehuu busa fo nai mei a fiki dale na. Ria boe naa nemeꞌ nanaaꞌ fo tuda nemeꞌ anaꞌ a bika na mai.” Sosoa na nae, faiꞌ fo ana ara raa a, nana busa ra hapu boe. Leo mae Yesus tulu-fali Ria lahenda nara, Ana muste tulu-fali lahenda fekeꞌ a boe. ");
INSERT INTO rgu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus namanene leoꞌ na, boe ma nafada nae, “Awi! Mama Ka dedea laꞌe ria so! De mama ka fali leo, huu fo nitu ria kalua neme anafeto ma mai so.” ");
INSERT INTO rgu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Boe ma inaꞌ ria fali neun. Losa uma te ana na suku namanee. Nitu ria memaꞌ kalua so. ");
INSERT INTO rgu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Basa ria, boe ma Yesus asa foa ela kota Tirus, ara laꞌo tuka tasi a suu na raroo kota Sidon. Reme naaꞌ mai, ara laꞌo raroo losa dano Galilea. Basa boe ma ara leo nusaꞌ esa no kota sanahulu, fo riꞌ rae, ‘Dekapolis’. ");
INSERT INTO rgu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nai naa, hapu lahenda esa pakeꞌ ma pakanaa ni. Nonoo nara roon leo Yesus neu. Ara hule fo Yesus fua lima Na neuꞌ ria laka na, fo puli nan. ");
INSERT INTO rgu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Boe ma Yesus foa ela lahenda kadodouinaꞌ sira, de neu noo noi lahenda ria. Yesus duku lima Na leo lahenda ria ridoon dua si daleꞌ neu. Basa de Ana tao ape neu lima uꞌu Na, boe ma nafaroe lahenda ria maa na. ");
INSERT INTO rgu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus nakanaro leo lalai neu, Ana hela hahae Na, boe ma pareta nae, “Efata!” (Sosoa na nae, “Matahuꞌa leo!”) ");
INSERT INTO rgu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesus nae leoꞌ na, boe ma lahenda ria ridoo na namanene tutiꞌ a. Lahenda ria maa bara-aꞌain na bala-nau tutiꞌ a, losaꞌ ana mulai dedea maloleinaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Basa boe ma, dua si fali leo lahenda kadodouinaꞌ sira reu. Yesus horo si nae, “Nenene, o! Emi bosoꞌ tui lahenda mae, Au puli a lahenda ia so.” Leo mae Yesus horo si boe oo, tehuu ara ratui aoꞌ nai basa mamanaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lahenda fo ramanene tutuiꞌ ria, ara heran mamateꞌ. Boe ma ara beidea rae, “Lahenda ia, kahereꞌ naan seli! Tao na basa hihii-nanauꞌ a dadi malole. Lahenda pakeꞌ ara ramanene. Ma lahenda pakanaaꞌ ara bisa dedea.” ");
INSERT INTO rgu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Laiꞌ esa de, hapu lahenda dodou-inaꞌ mai rabua ao nara fo ramanene neuꞌ Yesus. Ara tuka Ni losa faiꞌ telu so, huu ria na de ara ta ranuu nanaaꞌ soꞌ. Boe ma Yesus naloo na ana mana tuka dea nara, de nae, “Au kasian neuꞌ lahenda kadoduinaꞌ ia ra. Ruma reme dooꞌ a mai, ma nate ara rabua rai ia faiꞌ telu ian so, losaꞌ ta ranuu nanaa-nininuꞌ soꞌ. Malole lenaꞌ ara bosoꞌ fali no tei rorouꞌ. Boso losa ara saparao nai eno taladaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus ana mana tuka dea nara rataa rae, “Papa! Mamana ia dooꞌ a neme koro a mai. De leo mae leoꞌ bea oo, ita ta bisa tahao lahenda kakabainaꞌ ia ra fa.” ");
INSERT INTO rgu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus natane si nae, “Emi manuu roti hida nai naa?” Ara rataa rae, “Papa. Ami peda adaꞌ noi roti hituꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Basa boe ma Yesus nadenu lahenda sira basa si fo ratuuꞌ reuꞌ daeꞌ. Boe ma Ana hai na roti kahitu sira, de hule makasi neuꞌ Manetualain. Boe ma Ana tetebi matan roti sira de fee si leo ana mana tuka dea nara reu. Boe ma ara reu babati fee basa lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ara hapu ika boaꞌ hida boe. Basa de Yesus hule seluꞌ makasi neuꞌ Manetualain soa neuꞌ ikaꞌ sira. Tutiꞌ a Ana nadenu ana mana tuka dea nara, fo ara babati fee lahenda sira bali. ");
INSERT INTO rgu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Basa si bate lahenda rifun haa siran. Ara raa losaꞌ rabete. Raa basa boe ma, ana mana tuka dea ra reu rabubua ra nanaa lenaꞌ ara, henu lapaneu hitu. Basa ria, boe ma Yesus nadenu basa si fali. ");
INSERT INTO rgu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tepoꞌ fo ara fali, boe ma Yesus no ana mana tuka dea nara ae ofaꞌ lain reu, fo leo mamana esa reu, nade Dalmanuta. ");
INSERT INTO rgu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Faiꞌ fo Yesus no ana mana tuka dea nara losa Dalmanuta, boe ma hapu lahenda partei Farisi hida mai raneta roo Ni. Ara ratatane ao roo Ni fo nau rahii-hiiꞌ Ana. Ara hule Ni rae, “Papa! Matudu tanda heran fo dadi buti nae, Tebe O hapu kuasa nemeꞌ Manetualain mai.” ");
INSERT INTO rgu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus hela hahae Na nae, “Maneniko Au amanene emi dedea leo naꞌ, sona Au asaledale! Ubeaꞌ taon de emi hule tanda heran? Bosoꞌ tao leoꞌ na! Memaꞌ hapu tanda, tehuu Au ta tao fee emi fa.” ");
INSERT INTO rgu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basa boe ma, Yesus foa ela si de no ana mana tuka dea nara ae seluꞌ ofaꞌ lain reu. Boe ma ara leo dano a seriꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Faiꞌ fo Yesus asa losa dano a talada, besaꞌ ko ana mana tuka dea nara rafarene rae ta reni tua-lepa fa. Ara reni adaꞌ noi roti baloꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus namanene si dedea laꞌeneuꞌ roti, boe ma nae, “Emi muste besa-besa! Fo ela emi bosoꞌ laꞌe mane Herodes a no lahenda Farisi ra duduku-papau tadaluꞌ nara. Sira duduku-papau nara sama leoꞌ ralu teteiꞌ fo lahenda ame rabuan no uuꞌ ela roti a aifuu.” ");
INSERT INTO rgu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ramanene Ni dedea nae leoꞌ na, boe ma ana mana tuka dea nara roi ramakokoaꞌ a. Boe ma ara beidea rae, “Papa dedea ubeaꞌ ria? Bate Ana dedea nae leoꞌ na, nana huu ita ta teni roti fa na.” ");
INSERT INTO rgu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tehuu Yesus bubuluꞌ sira duduꞌa-aafi nara. De Ana dedea nae, “Ubeaꞌ taon de emi dedea adaꞌ noi roti a? Emi ta mala Au dale hihii Ka fa, do? Emi dodole mara memaꞌ ta tandeꞌ a fa! ");
INSERT INTO rgu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Emi mita no mataꞌ so, tehuu ta bubuluꞌ ria sosoa na fa! Samaleoꞌ ta mita fa. Emi mamanene ao mara boe, tehuu ta bubuluꞌ hata-hata esa boeꞌ. Samaleoꞌ emi ta mamanene fa. Emi mafarene heni ");
INSERT INTO rgu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","roti kalima ara fo riꞌ Au tetebi si de fee lahenda rifun lima raa a, do? Faiꞌ na emi mabubua ma roti lenaꞌ ara lapaneu hida?” Ara rataa rae, “Lapaneu sanahulu dua, Papa!” ");
INSERT INTO rgu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus natane seluꞌ nae, “Emi bei mafareneꞌ faiꞌ na Au tetebi roti balo ka hituꞌ ara fo fee lahenda rifun haa raa a, do? Emi mabubuaꞌ ma lena nara lapaneu hida?” Ara rataa rae, “Hitu, Papa!” ");
INSERT INTO rgu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Boe ma Yesus nae, “Memaꞌ tebe! Emi mita no mataꞌ so, tehuu ubeaꞌ taon de emi beita bubuluꞌ Au kuasa Ka neme beaꞌ mai fa?” ");
INSERT INTO rgu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Basa ria, boe ma Yesus asa losa rai koroꞌ Betsaida. Nai na lahenda ra hela roo lahenda pokeꞌ esa leo Yesus neu. Ara hule Yesus fo oi laꞌe lahenda pokeꞌ ria, ela nita dae. ");
INSERT INTO rgu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus hela na lahenda ria lima na, de noon leo koroꞌ a deaꞌ neu. Boe ma Ana mudi ape neuꞌ lahenda ria mata na, basa de nafaroe ni. Ana natane nae, “Leoꞌ bea? O bisa mita dae so, do?” ");
INSERT INTO rgu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lahenda ria botiꞌ laka na fo memete ii-onaꞌ, boe ma nataa nae, “Ee! Au ita lahenda ra lalaꞌo. Tehuu nonooꞌ leo ai huuꞌ ara lalaꞌo.” ");
INSERT INTO rgu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Boe ma Yesus tao seluꞌ lima Na neuꞌ lahenda ria mata na. Boe ma ana memete soba seluꞌ bali, te mata na teꞌe matetuꞌ so. Besaꞌ ia ana nita dae no matetuꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus nadenu lahenda ria fali, basa de nafarereneꞌ feen nae, “O fali leo, tehuu tuka eno fekeꞌ. Bosoꞌ fali seluꞌ leo Betsaida mu bali.” ");
INSERT INTO rgu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Basa ria, boe ma Yesus asa laꞌo rafeo koroꞌ manai Kaisarea Filipi. Nai eno taladaꞌ Yesus natane si nae, “Kalu tuka lahenda ra tutui na, ara rae Au ia nana, bea?” ");
INSERT INTO rgu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ara rataa rae, “Ruma rae ‘Yohanis Mana Saraniꞌ a’. Ruma rae ‘Baꞌi Elia’, Manetualain mananesi mata maꞌulu na. Hapu fekeꞌ ara rae Papa ia nana, Manetualain mananesi mata maꞌulu fekeꞌ nara esa ian.” ");
INSERT INTO rgu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Boe ma Yesus natane seluꞌ nae, “Tehuu, emi sona mae Au ia nana, bea?” Petrus nataa nae, “Papa ka nana Kristus! Fo Manetualain tudu memaꞌ ana neme uluꞌ mai so.” ");
INSERT INTO rgu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tehuu Yesus horo si nae, “Bosoꞌ mafada lahenda esa boeꞌ, e!” ");
INSERT INTO rgu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Basa ria, boe ma Yesus mulai nafada ana mana tuka dea nara nae, “Au ia, Lahenda Teteaꞌ. Neuꞌ ko Au hapu doidosoꞌ dodouꞌ, nana huu lasi hadas ara, malaka agama Yahudi ra malaka nara, ma mese agama ra, ara ta sipoꞌ Au fa. Neuꞌ ko raisa Au, tehuu naraa no fai binesaꞌ na, te Au asoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus nafada ledo-ledo leoꞌ na, boe ma Petrus hela non leo mamana fekeꞌ neu de nasaꞌain nae, “Papa! Bosoꞌ dedea leo naꞌ. Au ta ataaꞌ sira lima-ei nara dai Papa ka fa.” ");
INSERT INTO rgu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Petrus dedea ria, tehuu ta tuka Manetualain hihii-nanaun fa. Boe ma Yesus lipe aon fo mete ana mana tuka dea feke nara. Basa de Ana nasaꞌai Petrus no hara beraꞌ nae, “Hee! Nitu ra malaka nara dedean ria! Maheoꞌ meme iaꞌ mai! O afi adaꞌ noi dae-bafoꞌ a hihii-nanaun, te ta Manetualain hihii-nanaun fa.” ");
INSERT INTO rgu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Boe ma Yesus naloo na lahenda fekeꞌ ara fo mai rabua ro ana mana tuka dea nara. Ana nanori si nae, “Bea nau tuka Au, sona ana muste tuka nahere Au fai-faiꞌ! Ana muste nafarene heni ria hihii-nanaun mesan, fo tuka noi Manetualain hihii-nanaun. Leo mae lahenda nau raisa ni, ana muste tuka nahere, sama leoꞌ lahenda lepa na ai kake na fo neu mate. ");
INSERT INTO rgu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Lahenda fo pasaꞌ mamate na, nana huu ana tuka Au, ria hapu soda-moleꞌ manabasa taꞌa losaꞌ doo na neu. Tehuu lahenda fo nafarene ada noi ria ao-ina heheli na, sona neuꞌ ko ta hapu soda-moleꞌ manabasa taꞌa fa. ");
INSERT INTO rgu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nenene, e! Kalu o hapu katemaꞌ dae-bafoꞌ a oe-isin, tehuu Manetualain tipa heni o, sona onto ubeaꞌ? ");
INSERT INTO rgu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Leo mae o lepa muni katemaꞌ dae-bafoꞌ a oe-isin, tehuu o ta bisa seluꞌ sira reu sumane ma fa! ");
INSERT INTO rgu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mafarereneꞌ, é! Besaꞌ ia lahenda nai dae-bafoꞌ ia tadalu nara rupaꞌ ara. Ara ta tao daleꞌ fo tuka neuꞌ Manetualain. De, bea maeꞌ tuka Au, do maeꞌ homu Au nanori-nafada Ki, Au boe maeꞌ manaku ria nade na nai Manetualain matan. Huu fo Au ia, Lahenda Teteaꞌ, neuꞌ ko Au fali seluꞌ eme nusatetu-ikutemaꞌ a mai. Ma Manetualain eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai, ara tuka roo Au. Ami onda meme nusatetu-ikutemaꞌ a mai no Amaꞌ a kuasa kahere na, besaꞌ ko lahenda bubuluꞌ rae Au ia nana, bea. ");
INSERT INTO rgu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Emi bosoꞌ mafarene heni Au dedea Ki ia. Hapu lahenda neme emi basa ia mai, ana beita mate fa, tehuu neuꞌ ko nita Manetualain homu pareta no kuasa bau-ina Na.” ");
INSERT INTO rgu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Basa faiꞌ nee boe ma, Yesus hule Petrus, Yakobis ma Yohanis, fo ara sama-sama ae leo lete madema esa lain reu, nai na lahenda taꞌa. Ara losa lain boe ma, rita Yesus dadi feke so. ");
INSERT INTO rgu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma kakao-papaken fula makarela so. Nai dae-bafoꞌ ia, ta hapu hata esa fula naa lena heni Ria papake nara mai boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kekeneu te, rita Yesus dedea no baꞌi Elia ma baꞌi Musa. ");
INSERT INTO rgu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Petrus asa bii mamateꞌ. Boe ma Petrus noi namakokoaꞌ a so, losaꞌ ana dedea nafararaꞌu. Basa boe ma, ana nafada Yesus nae, “Papa! Nai ia malole na seli! De, malole lena ami mafoa ma laaꞌ telu. Esa fee Papa Ka, esa fee baꞌi Musa, ma esa bali fee baꞌi Elia.” ");
INSERT INTO rgu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Basa boe ma, oaꞌ a onda mai de napoti naa si. Boe ma ramanene haraoeꞌ esa neme oaꞌ ria daleꞌ mai nae, “Nenene, o! Yesus ia nana Au Ana susue Ka. Emi basa mamanene matalolole Ni!” ");
INSERT INTO rgu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Petrus asa ramanene haraoeꞌ ria, boe ma ara memete raleleiꞌ, tehuu kekeneu te ara ta rita lahenda fekeꞌ soꞌ. Adaꞌ noi Yesus mesaꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Basa ria boe ma, Yesus no ana mana tuka dea nara onda faliꞌ reme leteꞌ lain mai. Yesus helu ela si nae, “Hata fo bisinaꞌ a mita ni a, emi bosoꞌ mafada lahenda esa boe. Au ia, Lahenda Teteaꞌ, Au muste mate dei. Basa te maneniko Au asoda seluꞌ, besaꞌ ko emi bole mafada lahenda.” ");
INSERT INTO rgu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ara homu rahere Yesus hehelun ria, de ara ta tui lahenda fa. Tehuu telu si mulai ratatane aoꞌ rae, “Ria sosoa na leo beaꞌ nae, Ria nau ‘nasoda seluꞌ neme mamate Na mai.’ Leo beaꞌ ria, e?” ");
INSERT INTO rgu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Boe ma ara ratane Ni rae, “Mese agama ra rae, ‘Baꞌi Elia muste mai dei, besaꞌ ko Kristus mai.’ Tehuu tuka Papa ka, sona leo beaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus nataa nae, “Memaꞌ tebe! Baꞌi Elia muste mai dei, fo soi enoꞌ fee Kristus, Lahenda fo Manetualain tudu memaꞌ neme uluꞌ mai so. Tehuu ubeaꞌ taon? Emi beita bubuluꞌ hata fo ara duiꞌ ana nai Manetualain Susura Makamoi Na laꞌeneuꞌ Lahenda Teteaꞌ a, do? Huu fo ara duiꞌ memaꞌ rae, neuꞌ ko Ana mai, sona lahenda tao rasususaꞌ Ana losaꞌ ara nau raisan. ");
INSERT INTO rgu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tehuu emi muste pasa matalolole ridoo mara! Memaꞌ baꞌi Elia nana mai so. Tehuu lahenda tao rasususaꞌ ana tuka sira hihii-nanaun. Ria boe naraa no hata fo baꞌi ra duiꞌ memaꞌ neme uluꞌ mai so a.” ");
INSERT INTO rgu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tepo fo, Yesus no ana mana tuka dea katelun sira, raneta seluꞌ ro nono feke nara, ara rita lahenda dodouꞌ rabua rai na. Lahenda kadodouꞌ sira mai fo rita Yesus ana mana tuka dea feke nara ralelena aoꞌ ro mese agama ra. ");
INSERT INTO rgu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Lahenda kadodouꞌ sira rita Yesus boe ma, ara kekes ara, huu fo raendobuko Yesus bei nai leteꞌ lain. Basa boe ma ara ralai reu raneta roo Ni. ");
INSERT INTO rgu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Boe ma Yesus natane si nae, “Emi malelena aoꞌ ubeaꞌ nai ia?” ");
INSERT INTO rgu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lahenda esa mai de nae, “Papa, nenene dei! Au o anatou ana ka mai, fo Papa puli man dei. Pakanaa ni, ta bisa dedea fa, huu fo nitu a heke nan. ");
INSERT INTO rgu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maneniko nitu a masoꞌ, sona lokopiro ni neuꞌ dae a. Basa nana anaꞌ ria bafa na nafufude, ma heku nisi na. Boe ma ao-ina na baraꞌaain sama leoꞌ ai a. Au hule Papa ana mana tuka dea mara so, fo usi nitu ria, tehuu ta bisa fa.” ");
INSERT INTO rgu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus namanene leoꞌ na, boe ma nasapaa si nae, “Hee! Emi talalu so! Au anori emi kose-kose, tehuu emi ta bubuluꞌ matalole. Ma emi ta mamahere matetuꞌ neuꞌ Au. Au muste sabar neuꞌ emi losa fai hidaꞌ? Moo anaꞌ ria leo iaꞌ mai!” ");
INSERT INTO rgu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Boe ma ara oꞌo roo anaꞌ ria leo Yesus mata Na neu. Tehuu nitu ria nita Yesus, boe ma ana lokopiro anaꞌ a neuꞌ dae a losaꞌ nalololiꞌ ana, ma bafa na nafufude. ");
INSERT INTO rgu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus natane anaꞌ ria papa na nae, “O ana ma hapu hedis ia, riꞌ fai hidaꞌ a?” Boe ma papa na nataa nae, “Nemeꞌ aanan ria mai so. ");
INSERT INTO rgu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nitu ria nau namate anaꞌ a riꞌ dooꞌ a so. Ana natuda au ana ka kose-kose leo aipilaꞌ daleꞌ neu, ma nabolo ni nai oe daleꞌ. Papa tulu-fali dei! Kalu bisa, Papa kasian neuꞌ ami fo, puli ma ana ia dei.” ");
INSERT INTO rgu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus nataa nae, “Ubeaꞌ taon de o mae ‘kalu bisa’? Tebe Au bisa tao basa-basan, sadi lahenda ramahere dei.” ");
INSERT INTO rgu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Boe ma, toulasiꞌ a nataa ma hii-hiiꞌ dolaꞌ nae, “Papa! Tebe au amahere. Tehuu tulu-fali, fo au namahere ka boe-boe natea bali.” ");
INSERT INTO rgu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tepo ria Yesus nita lahenda dodouꞌ mulai mai tesa rai na. Boe ma Ana pareta nitu a nae, “He, nitu makaresiꞌ! O kalua ela ana ia leo, ela namanene, ma dedea. O bosoꞌ boe masoꞌ seluꞌ leo ria daleꞌ mu bali.” ");
INSERT INTO rgu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nitu ria namanene Yesus dedea nae leoꞌ na, boe ma ana kasi nambeberaina. Ana tao na anaꞌ ria bara neu ma hede, besaꞌ ko nalai elan. Boe ma anaꞌ ria hela naroroo aon sama leoꞌ mate ni so. Losaꞌ lahenda fo rai na ara beidea rae, “Naa! Mate ni so!” ");
INSERT INTO rgu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tehuu Yesus tai na anaꞌ ria lima na de hela nafoan. Boe ma ana foa tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Basa de Yesus no ana mana tuka dea nara laꞌo ela mamana ria, de kodi leo uma esa dale reu. Nai na ara ratane mataꞌ Yesus rae, “Papa! Ubeaꞌ taon de bisinaaꞌ a ami ta bisa usi mala nitu ria fa?” ");
INSERT INTO rgu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Boe ma Yesus nafada nae, “Nenene matalolole! Nitu ra nana tebe tadaluꞌ a. De, kalu emi ta hule tutulu-fafaliꞌ neme Manetualain mai fa, sona emi ta usi mala nitu rupa leo naꞌ a fa.” ");
INSERT INTO rgu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Basa boe ma, Yesus no ana mana tuka dea nara foa ela mamanaꞌ ria, de leo propinsi Galilea reu. Tepoꞌ ria, Yesus ta nau lahenda bubuluꞌ rae Ria nai naa, ");
INSERT INTO rgu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","huu fo Ana nau nanori-nafada adaꞌ noi ana mana tuka dea nara mesaꞌ asa. Ana nafada si nae, “Ta dooꞌ a soꞌ te ara nau seꞌo heni Au leo lahenda feke ara u. Basa nate raisa Au, Lahenda Teteaꞌ ia. Tebe Au mate, tehuu nai fai binesa na te, Au asoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus nafada nae leoꞌ na, tehuu ana mana tuka dea nara roi ramakokoaꞌ a. Ara ta raparani ratane Yesus ria sosoa na nae leoꞌ bea. ");
INSERT INTO rgu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Basa boe ma, Yesus no ana mana tuka dea nara laꞌo losa kota Kapernaum. Faiꞌ fo ara kodi leo uma daleꞌ reu, boe ma Yesus natane ana mana tuka dea nara nae, “Bisinaaꞌ a emi malelena aoꞌ ubeaꞌ nai eno taladaꞌ ria?” ");
INSERT INTO rgu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tehuu ta hapu esa naparani nataa boeꞌ, huu fo nai eno taladaꞌ ara ra sisipoꞌ bafaꞌ rae, neme sira basa mai nana bea riꞌ bau lena. ");
INSERT INTO rgu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Basa boe ma, Yesus natuuꞌ de nanori si nae, “Bea riꞌ nau dadi lahenda bauinaꞌ, sona ria masoda na tebe-tebe muste dadi sama leoꞌ lahenda aanaꞌ fo nalalau basa lahenda ra.” ");
INSERT INTO rgu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Boe ma, Yesus oꞌo na ana aanaꞌ esa nai na, de fali seluꞌ leo sira talada neu. Boe ma Ana dedea nae, ");
INSERT INTO rgu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bea riꞌ tuka Au fo nalalau lahenda aanaꞌ a sama leoꞌ anaꞌ ia, sona sosoa na nae, ana nalalau neuꞌ Au. Ma ria boe nalalau neuꞌ Au Ama ka, fo riꞌ nadenu Au leo dae-bafoꞌ ia mai.” ");
INSERT INTO rgu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Basa boe ma, Yesus ana mana tuka dean Yohanis, kolaaꞌ Yesus nae, “Papa! Laiꞌ esa de, ami mita lahenda esa pake Papa ka nade Na, de usi nitu. Tehuu ami horo ni, huu fo ita lahendan ta ria fa.” ");
INSERT INTO rgu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tehuu Yesus nataa nae, “Hee! Emi bosoꞌ horo lahenda ria. Huu fo bea pake Au nade Ka de tao tanda heran, neuꞌ ko ana ta dedea nalutu Au nade Ka fa. ");
INSERT INTO rgu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kalu ana ta soaꞌ ita fa, sosoa na nae ria boe ita lahendan. ");
INSERT INTO rgu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mafarerene matalolole, o! Kalu hapu lahenda bubuluꞌ nae emi tuka neuꞌ Kristus, basa boe ma ana tulu-fali neuꞌ emi, tantu Manetualain ta nafarene heni ria sosota na fa. Leo mae ana fee adaꞌ noi oe masufuꞌ galaas esa boe oo, Manetualain ta nafarene heni ni fa.” ");
INSERT INTO rgu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Basa boe ma, Yesus nafada seluꞌ asa nae, “Kalu hapu lahenda tao ana aanaꞌ esa laꞌo tuka eno masoda tadaluꞌ a, losaꞌ anaꞌ ria ta namahere neuꞌ Au fa, sona nataneneu, o! Malole lenaꞌ fee lahenda ria, hai na batu kabaꞌuina esa, heken neuꞌ bolii na fo tuꞌun leo tasiꞌ a talada neu. ");
INSERT INTO rgu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kalu o tao salaꞌ pake lima ma, sona tete heni limaꞌ ria. Huu fo malole lenaꞌ o masoꞌ nusatetu-ikutemaꞌ a adaꞌ noi limaꞌ seriꞌ a, lena heni ara tuꞌu o leo naraka a daleꞌ mu muni limam dua si.” ");
INSERT INTO rgu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka nana mamana doidoso. Aipila na ta maten fa, ma uleꞌ fo rai na boe ta hahae tao maboo puruꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kalu o tao salaꞌ pake ei ma, sona tete heni eiꞌ ria. Huu fo malole lenaꞌ o masoꞌ nusatetu-ikutemaꞌ a muni noi ei mi seriꞌ a, lena heni o muni eim dua si tehuu ara tuꞌu o leo naraka daleꞌ mu. ");
INSERT INTO rgu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka nana mamanaꞌ doidoso. Aipila na ta maten fa. Ma uleꞌ fo rai na boe ta hahae tao maboo puruꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kalu o tao salaꞌ pake mata ma, sona edo henin. Malole lenaꞌ o masoꞌ nusatetu-ikutemaꞌ a muni noi mataꞌ esaꞌ a, lena heni o muni matam dua si, tehuu ara tuꞌu o leo naraka daleꞌ mu. ");
INSERT INTO rgu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naraka nana, mamana doidoso. Aipila na ta maten fa. Ma uleꞌ fo rai na boe ta hahae tao maboo puruꞌ a.’ ");
INSERT INTO rgu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tebe, Au nanori-nafada ka beraꞌ a. De, bea nau tuka Au, sona ana muste nanenete fo tuka nahere, sama leoꞌ lahenda mamasi paaꞌ fo nunuu ni neuꞌ aipilaꞌ a, fo ela leoꞌ bea na paaꞌ ria nanenete dooꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masiꞌ a, nana malole a. Ita pake ni fo tao na nanaa-nininuꞌ malada a. Tehuu kalu masiꞌ a dadi mamin sona sosoa-raraan ubeaꞌ? Tapa henin leo. Emi boe muste dadi sama leoꞌ masiꞌ a, fo ela emi moo basa lahenda ra masue-malai ao. Naa! Emi hahae nalelena aoꞌ a mae, bea bauinaꞌ a, ma bea aanaꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Basa boe ma, Yesus asa leo propinsi Yudea a reu ma mamana fekeꞌ nai lee Yarden pooꞌ duluꞌ. Lahenda remeꞌ basa mamanaꞌ ara mai eo raa Ni. Yesus nanori-nafada si, sama leoꞌ bale-bale. ");
INSERT INTO rgu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hapu lahenda Farisi hida mai fo nau rahii-hiiꞌ Yesus. Ara ratane rae, “Tuka ita atoran agama na, kalu touꞌ a sao so, ana bole namaetuꞌ no saoina na, do taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus nataa nae, “Mafareneꞌ dei! Atoran ina-touꞌ fo baꞌi Musa feen neuꞌ ita a nae, leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ara rataa rae, “Baꞌi Musa atoran na nae, lahenda bole namaetuꞌ, sadi fee saoina na susura namaetuꞌ dei.” ");
INSERT INTO rgu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus balas nae, “Ae! Nenene, e! Huu no emi laka batu mara, de rina baꞌi Musa duiꞌ nae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Emi bosoꞌ mafarene heni tutui masososaꞌ ria, tepo fo Manetualain adu na lalai ma dae-bafoꞌ a! Hapu manaduiꞌ nae, ‘Manetualain adu na lahenda, touꞌ ma inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Huu ria na de touꞌ a foa ela ina-ama nara, fo neu nasoda daleꞌ esa no saoina na, ");
INSERT INTO rgu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","huu fo sira dua dadi esaꞌ so!’ ");
INSERT INTO rgu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Maneniko Manetualain riꞌ tao sira dua dadi esaꞌ, sona lahenda bosoꞌ fee si ramaetuꞌ bali!” ");
INSERT INTO rgu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Basa ria, boe ma Yesus no ana mana tuka dea nara mesaꞌ asa kodi leo uma esa daleꞌ reu. Nai naa ara ratane Yesus nanori-nafada bisinaa na. ");
INSERT INTO rgu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus nataa nae, “Bea namaetuꞌ no saoina na, basa boe ma sao seluꞌ bali, sona ana hohoke ria so. ");
INSERT INTO rgu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ina ara boe leo naꞌ. Kalu ana namaetuꞌ no saotou na, basa boe ma sao seluꞌ bali, sona hohoke ria boe!” ");
INSERT INTO rgu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Faiꞌ esa boe ma, hapu lahenda roo ana aana nara leo Yesus reu, fo hule Ni fua lima Na ela fee si ua-naleꞌ. Tehuu Yesus ana mana tuka dea nara rasaꞌai lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus nita leoꞌ na, boe ma Ana namanasa no ana mana tuka dea nara, naeꞌ, “Nemeꞌ na ela anaꞌ sira leo Au mai! Bosoꞌ horo si! Huu fo lahenda leoꞌ na a, riꞌ Manetualain lahendan sira. ");
INSERT INTO rgu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Emi mafarene matalolole! Bea nau mai toko-nakanaro neuꞌ Manetualain, ara muste rahii ra Ni seliꞌ sama leoꞌ ana aanaꞌ ara rahiiꞌ ra ina-ama nara seli. Kalu ta leoꞌ na fa, sona ta naraa dadi Manetualain lahendan.” ");
INSERT INTO rgu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Basa boe ma, Yesus holu na anaꞌ sira, de fua lima Na neuꞌ sira esa-esa, fo fee si ua-naleꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tepoꞌ fo Yesus asa sakaꞌ laꞌo, boe ma lahenda kamasuꞌi esa nalai mai fo naneta noo Ni. Ana sundaꞌ undulaka na nai Yesus matan, basa boe ma natane nae, “Papa Mesen manuu hada-hormata! Au nau atane baiꞌ. Leo iaꞌ, Papa. Au muste tao leo beaꞌ, ela au bubuluꞌ matetuꞌ ae, au masoꞌ nusatetu-ikutemaꞌ a, fo asoda sama-sama oo Manetualain?” ");
INSERT INTO rgu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus nataa nae, “Ubeaꞌ taon de o mafada Au mae, ‘manuu hada-horomata’? Ta hapu lahenda esa nanuu hada-hormata, noi Manetualain mesaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O bubuluꞌ, Manetualain pareta Na neme uluꞌ mai nae, ‘Bosoꞌ maisa lahenda; Bosoꞌ hohoke; Bosoꞌ mamanaꞌo; Bosoꞌ sakasii pepekoꞌ; Bosoꞌ tipu-dai lahenda fo hai ma hata-heto nara; Fee hada-horomata neuꞌ o ina-ama mara.’ ” ");
INSERT INTO rgu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Lahenda ria nataa nae, “Tebe, Papa Mesen! Mulai neme muri ana ka mai, au tuka katemaꞌ pareta sira so.” ");
INSERT INTO rgu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus kasian neuꞌ lahenda ria. Boe ma Ana nae, “Tebe! Tehuu bei hata esa bali. Besaꞌ ia o fali fo seꞌo heni katemaꞌ hata-heto mara. Doi nara, o mu babati fee lahenda manatoꞌa-manataaꞌ ara. Basa sona mai fo tuka Au leo. Neuꞌ ko Manetualain balas fee o hata fekeꞌ nai nusatetu-ikutemaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lahenda ria namanene Yesus dedea nae leoꞌ na, boe ma dale na nalulutuꞌ. Basa de ana fali no dale susa, huu fo namasuꞌi naan seli. ");
INSERT INTO rgu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Boe ma Yesus mete neu-mai, ma dedea no ana mana tuka dea nara nae, “Nenene, e! Susa laesaꞌ lahenda kamasuꞌi a masoꞌ nusatetu-ikutemaꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ana mana tuka dea nara Ramanene Ni dedea nae leoꞌ na, boe ma roi ramakokoaꞌ a. Tehuu Yesus nafada seluꞌ bali nae, “Nenene matalolole! Susa laꞌesa nau dadi Manetualain lahendan! Bosoꞌ afi mae ria nana mudaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lahenda kamasuꞌi a masoꞌ nusatetu-ikutemaꞌ a, fo dadi Manetualain lahendan, ria susa na sama leoꞌ banda onta bauinaꞌ esa fali leo oka na neu, kodi tuka rarau a bolo na.” ");
INSERT INTO rgu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus dedean ria, tao na lahenda sira tamba ramakoa. Boe ma ratatane aoꞌ rae, “Kalu memaꞌ tebe leoꞌ na, sona bea rina hapu sodaꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus mete esa-esa no si, boe ma Ana nae, “Soaneuꞌ lahenda sona taꞌa. Tehuu boso mafarene henin: soaneuꞌ Manetualain sona, basan bisa dadi!” ");
INSERT INTO rgu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Boe ma Petrus dedea nae, “Papa. Ami foa ela ami hata-heto mara katemaꞌ so, fo tuka Papa ka. Tehuu ami hapu ubeaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus nae, “Au nau afada emi ae leoꞌ ia: lahenda fo tuka Au, ma foa ela ina-aman, aꞌa-fadin, ana nara, oka-tinen, nonoi-tataon, ma uma na oe-isin katemaꞌ fo neu nafada lahenda rai basa mamanaꞌ ara Manetualain Tutui Malole Na, neuꞌ ko ana sipo faliꞌ laiꞌ natun esa. Basa hata fo ana foa ela si so a, neuꞌ ko sipo fali no lenaꞌ. Ma neuꞌ ko ana hapu eese-rurumuꞌ nana huu tuka Au. Tehuu maneniko dae-bafoꞌ ia noe, ana nasoda naroo noo Manetualain. Ria titifa-babae na ri naꞌ! ");
INSERT INTO rgu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mafarereneꞌ, e! Lahenda fo tao aon bauinaꞌ a, tuka Manetualain aafi Na, neuꞌ ko ana dadi neuꞌ lahenda fo aanaꞌ a naan seli. Tehuu lahenda fo tao aon aanaꞌ a, tuka Manetualain aafi Na, ria riꞌ neuꞌ ko dadi lahenda bauinaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tepoꞌ ria, Yesus asa leo Yerusalem reu. Yesus laꞌo nesiꞌ uluꞌ. Ana mana tuka dea kasanahulu dua nara ro lahenda fekeꞌ ara tuka Ni. Ara rafarene hata fo maꞌulu na Ana nafadan nae, lahenda nau raisa Ni nai Yerusalem. Huu ria na ara roi ramakokoaꞌ a, ma bii. Yesus namanene leoꞌ na, boe ma naloo na noi ana mana tuka dea nara mesaꞌ asa, de nafada si seluꞌ hata fo lahenda nau taon soaneuꞌ Ana nai Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ana dedea nae, “Emi nenene, e! Besaꞌ ia ita sakaꞌ leo Yerusalem teu. Au ia, Lahenda Teteaꞌ. Tehuu nai na ara seꞌo heni Au leo malaka agama Yahudi ra malaka nara, ma mese agama ra. Basa nate ara huku ramate Au. Boe ma ara tuluꞌ Au leo lahenda fekeꞌ fo ta ralelaꞌ neuꞌ Manetualain fa. ");
INSERT INTO rgu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Basa te ara dedea ramumulu-ramamaeꞌ Au. Ara mudi radiu Au ape. Ara fepa-liꞌu rasosopuꞌ Au ao-ina ka. Basa dei besaꞌ ko ara raisa Au. Memaꞌ Au mate tebe. Tehuu fai binesa na, te Au asoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Basa boe ma, Yakobis no Yohanis, fo riꞌ Sabadeus ana nara, ara leo Yesus mai. Ara hule Ni rae, “Papa Mesen! Ami parluu baiꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus natane si nae, “Emi parluu ubeaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ara rataa rae, “Leo iaꞌ, Papa. Maneniko, Papa ka natuuꞌ homu pareta, sona ami hule fo Papa natutuuꞌ ami, esa nai boboa ona Ma, esa nai boboa ii Ma, ela ami homu pareta boe.” ");
INSERT INTO rgu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus nataa nae, “Emi dua ta bubuluꞌ hata fo emi hule ni a. Au ia nana neuꞌ ko hapu doidoso dodouꞌ. De, leoꞌ bea? Bate mae emi boe mabeꞌi lepa doidoso ria sama-sama moo Au losa mate, do?” ");
INSERT INTO rgu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ara rataa rae, “Ami bisa, Papa!” Yesus nafada si bali nae, “Tebe, emi boe neuꞌ ko mabeꞌi lepa doidoso sama leoꞌ Au. ");
INSERT INTO rgu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tehuu bea fo riꞌ neuꞌ ko natuuꞌ nai Au boboa ii-ona Ka, Au ta aetuꞌ ria fa. Ria nana Manetualain hak na fo naetuꞌ memaꞌ, bea ra siꞌ ratuuꞌ rai mamanaꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tepoꞌ fo ana mana tuka dea fekeꞌ ara ramanene Yakobis no Yohanis huhulen ria, boe ma ramanasa. ");
INSERT INTO rgu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Basa de, Yesus naloo na basa si, boe ma Ana nae, “Leo iaꞌ! Emi bubulu so, hete? Lahenda bau-ina mana homu pareta ra biasa ese-rumu ana raun nara, losaꞌ ara ta rababale fa. Ma malaka remeꞌ lahenda nusaꞌ fo ta ralelaꞌ Manetualain fa, ara pareta ralalenaꞌ, losaꞌ ana raun nara ta bisa botiꞌ laka nara. ");
INSERT INTO rgu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tehuu emi ta bole tao leo naꞌ fa! Naa, neme emi bea mai nau dadi lahenda bauinaꞌ, sona ana muste dadi sama leoꞌ ana uma daleꞌ a fo nalalau lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma lahenda fo nau dadi malaka, sona ana muste tao aon sama leoꞌ ata a. ");
INSERT INTO rgu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Huu fo Au ia, Lahenda Teteaꞌ, Au ta mai fo lahenda ralalau Au fa. Tehuu Au mai fo alalau lahenda dodouꞌ. Au mai fo fee katemaꞌ masoda Ka, ela soi-tefaꞌ a lahenda dodouꞌ reme sala-siko nara mai.” ");
INSERT INTO rgu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus no ana mana tuka dea nara, ma lahenda dodou-inaꞌ ara losa rai kota Yeriko. Tepoꞌ fo ara sakaꞌ laꞌo raroo, hapu lahenda pokeꞌ esa natuuꞌ nai enoꞌ a suu na, soa nalamemeiꞌ a. Ria nade Bartimeos, papa Timeos ana na. ");
INSERT INTO rgu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana namanene nae, lahenda fo nesiꞌ na a, nana Yesus neme Nasaret mai, boe ma naloo namberaina nae, “Yesus! Daud tititi-nonosin, e! Ami mahani Papa Ka dooꞌ a so. Kasian neuꞌ au dei!” ");
INSERT INTO rgu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ramanene ni naloo leoꞌ na, boe ma ara rasaꞌain rae, “We! Neneeꞌ!” Tehuu ana boe-boe naloo namberaina nae, “Yesus! Daud tititi-nonosin, e! Kasian neuꞌ au dei!” ");
INSERT INTO rgu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Basa de Yesus nateꞌe. Boe ma Ana nae, “Emi moo ni leo iaꞌ mai!” Boe ma ara reu de rafada ni rae, “O neneeꞌ leo! Papa Mesen naloo o. Mai leo!” ");
INSERT INTO rgu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeos namanene leoꞌ na, boe ma tapa heni lafa na, ana nalale de foa napadei, fo neu naneta no Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus natane ni nae, “O mahiiꞌ ubeaꞌ?” Lahenda ria nataa nae, “Papa, e! Au hule fo bisa ita dae!” ");
INSERT INTO rgu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus nafada ni bali, “Huu no o mamahere mae, Au bisa puli a o, de besaꞌ ia boe teꞌe ma aom! Mu leo.” Boe ma Bartimeos mata na nita dae tutiꞌ a. Basa de, ana neu tuka noo Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Faiꞌ fo ara raneneaꞌ ro kota Yerusalem so, ara losa rai koroꞌ dua, Betfage no Betania, nai lete Saitun a suu na. Neme naꞌ mai Yesus asa bei rahani seluꞌ baiꞌ. Basa boe ma Ana nadenu ana mana tuka dean dua fo reu raꞌuluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ana helu si nae, “Emi dua maꞌulu koroꞌ ele. Maneniko losa na, neuꞌ ko emi mita keledai anaꞌ esa manahekeꞌ nai na. Lahenda bei ta parna saꞌe soba ni fa. Emi meu sefi maan fo hela menin leo iaꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tehuu maneniko lahenda ratane emi rae, ‘Ubeaꞌ taon de emi sefi meni keledai ria?’ Sona emi mataa mae, ‘Ami Ramatua ma nau pake ni. Maneniko pake basa, sona neuꞌ ko ami meni faliꞌ tutiꞌ ana.’ ");
INSERT INTO rgu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Basa de, lahenda kaduaꞌ sira reu, boe ma ara rita keledai anaꞌ ria manaheke nai uma esa mata na nai enoꞌ a suu na. Boe ma ara sefi renin. ");
INSERT INTO rgu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tehuu lahenda fo rapadeiꞌ rai na a ratane rae, “Ae! Ubeaꞌ taon de emi sefi meni lahenda keledai na?” ");
INSERT INTO rgu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Boe ma rataa rae, “Ami Ramatua ma nau pake ni. Kalu pake basa sona, neuꞌ ko ami meni faliꞌ tutiꞌ ana.” Boe ma lahenda sira roi rataaꞌ a fo hela reni keledai ria. ");
INSERT INTO rgu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ara hela renin leo Yesus neu. Basa de ara bela lafa nara reuꞌ keledai ria kotiꞌai na lain, boe ma Yesus saꞌe. ");
INSERT INTO rgu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tepoꞌ fo ara sakaꞌ masoꞌ leo kota daleꞌ reu, boe ma lahenda dodouꞌ hai ra lafa, lafa ana nasaa nara, de bela si reuꞌ enoꞌ a. Ruma reu beta ai-doo palam nai eno suuꞌ sira fo bela neuꞌ enoꞌ lain. No ria na, ara tao tanda nae, ara sipoꞌ Ramatua Yesus no hada-horomata. Samaleoꞌ ara biasa sipoꞌ lahenda bauinaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hapu lahenda ruma laꞌo raꞌuluꞌ nai Yesus mata Na, ma ruma resiꞌ deaꞌ. Ara mulai heꞌi-heꞌi mesan rae, “Hosana! Ita io-oa neuꞌ Manetualain! Manetualain fee ua-naleꞌ neuꞌ lahenda fo mai, pake nade Na, huu fo Manetualain nadenu Ni! ");
INSERT INTO rgu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Ita io-oa neuꞌ Manetualain! Huu fo Manetualain nau nafoa faliꞌ Mane Daud a pareta na! Hosana! Ita io-oa neuꞌ Manetualain! Huu fo Manetualain natuuꞌ pareta memaꞌ, nai lalai fo madema naan seli!” ");
INSERT INTO rgu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Losa kota daleꞌ, boe ma Yesus asa masoꞌ leo Manetualain Uma Mamaso Na mata na reu. Yesus rerelu naleleiꞌ bai naꞌ ke. Tehuu, no ledo-fai taꞌa so, boe ma ara fali seluꞌ Betania reu. ");
INSERT INTO rgu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Balahaꞌ balahaa ana na, ara kalua reme Betania mai fo fali seluꞌ leo kota Yerusalem reu. Tehuu nai eno taladaꞌ, Yesus namalaaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana nita ai huuꞌ esa nai enoꞌ a suu na. Lahenda biasa raa boa na. De, Yesus naneneaꞌ leo ai huuꞌ ria neu, fo nau mete nanenin hapu boaꞌ do taꞌa. Tehuu Ana losa ai huuꞌ ria, ta nita hata-hata esa boeꞌ. Huu fo bei ta losa ai huuꞌ ria fai naboa na fa. Besaꞌ ko mulai nadoo beuꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Boe ma Yesus dedea fee ai huuꞌ ria nae, “Huu no o ta fee Au boa ma fa, de mulai nemeꞌ besaꞌ ia mai, o ta bisa fee boa ma neuꞌ lahenda fekeꞌ fa!” Ria ana mana tuka dea nara ramanene Ni dedea nambera nae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Basa boe ma, ara laꞌo raroo, losa Yerusalem, boe ma Yesus masoꞌ leo Manetualain Uma Mamaso Ina na neu. Nai Uma Mamasoꞌ ria mata na, lahenda pedaꞌ pasar fo ara raseꞌo manupui kalasi fo riꞌ lahenda paken tao neuꞌ tutunu-hohotu huhule-haradoiꞌ. Yesus nita leoꞌ na, boe ma Ana neu usi heni si. Ana rua nabuu mei fo riꞌ ara pake si fo tukar doi neuꞌ lain, ma fae naleka baku fo ara pake si ela raseꞌo manupuiꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ana horo basa lahenda ra ta bole reni sira hata nara fo laꞌo tepa resiꞌ uma ria mata na. ");
INSERT INTO rgu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Boe ma Ana nanori-nafada si nae, “Emi bubuluꞌ memaꞌ hata fo Manetualain mana nesimata nara duiꞌ ran so rae, ‘Au afoa Uma Ki ia, ela lahenda remeꞌ basa nusaꞌ a mai hule-haradoi nai ia.’ Tehuu emi tao ma Uma ia dadiꞌ parampok ara mamana nabua na!” ");
INSERT INTO rgu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Malaka agama Yahudi a malaka nara ro mese agama ra ramanene Yesus tao leo naꞌ so, boe ma ara eteꞌ ao nara roo Ni. Basa boe ma, ara mulai saka enoꞌ fo nau raisa Ni. Tehuu ara lele, nana huu lahenda dodouꞌ rahiiꞌ Ria nanori-nafada Na. ");
INSERT INTO rgu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ledo a sakaꞌ tena, boe ma Yesus asa kalua reme kota Yerusalem mai, de ara fali reu suku nai koro Betania. ");
INSERT INTO rgu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Balahaꞌ balahaa ana na, boe ma ara fali seluꞌ Yerusalem reu. Nai eno taladaꞌ, ara laꞌo resiꞌ ai huuꞌ fo useleꞌ a Yesus dedea fee ni a. Ria ana mana tuka dea nara heran, nana huu ai huuꞌ ria mate ni so, namatuu losaꞌ oka nara. Boe ma Petrus nafarene Yesus dedea usele na. De ana nafada nae, “Papa! Soba mete! Aihuuꞌ fo riꞌ useleꞌ a Papa feen kutuk a, mate ni so.” ");
INSERT INTO rgu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Boe ma Yesus nataa, naeꞌ, “Memaꞌ tebe! Sadi emi mamahere neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kalu emi mamahere tebe-tebe, emi bisa madenu leteꞌ esa fo nanasoꞌu leo tasi a neu. Boe ma Manetualain narali leteꞌ ria, sadi boso emi mamahere dale poo seseriꞌ! Emi muste mamahere tebe-tebe neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Naa! Bosoꞌ mafarene henin, o! Sadi emi mamahere tebe-tebe mae, Manetualain nabeꞌi fee hata fo emi hule, tantu Ana fee emi. ");
INSERT INTO rgu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tehuu kalu emi ruma hule-haradoi, sekonaa te bei namanasa no lahenda fekeꞌ, sona ana muste malole no lahenda ria dei. Besaꞌ ko emi Amam nai nusatetu-ikutemaꞌ a sae-safe heni sala-siko mara. ");
INSERT INTO rgu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kalu neme emi mai mapeda daleꞌ, ma ta nau fee ampon neuꞌ lahenda, tantu emi Amam nai nusatetu-ikutemaꞌ a boe ta nau nafarene heni emi sala mara fa.” ");
INSERT INTO rgu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Basa boe ma, ara laꞌo raroo. Losa rai Yerusalem, ara masoꞌ seluꞌ leo Manetualain Uma Mamaso Ina Na reu. Ara losa uma a mata na, boe ma malaka agama Yahudi a malaka nara, mese agama ra, lasi hadas Yahudi ra mai, ");
INSERT INTO rgu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","fo ara ratatane aoꞌ ro Yesus rae, “Bea nadenu o usele a mai taohiro-taohariꞌ nai ia? Bea riꞌ fee o hak?” ");
INSERT INTO rgu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tehuu Yesus bubuluꞌ ara saka enoꞌ fo nau ratuda Ni. Basa de Ana nataa natafaliꞌ nae, “Au boe nau atane neuꞌ emi boe. Emi mataa Au dei, besaꞌ ko Au ataa neuꞌ emi. ");
INSERT INTO rgu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Au nau atane leo iaꞌ: emi basa malelaꞌ Yohanis Mana Saraniꞌ a, hetu? Naa, bea riꞌ nadenu ni fo sarani lahenda? Manetualain do, lahenda dae-bafoꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Basa boe ma ara doo-doo reu-mai, ma ara dedea raoꞌ rae, “Ae! Laꞌe seluꞌ ita so! Kalu ita tataa tae, ‘Manetualain riꞌ nadenu’, neuꞌ ko Ana nataa natafaliꞌ nae, ‘Kalu leoꞌ na, sona ubeaꞌ taon de emi ta mamahere neuꞌ Yohanis fa!’ ");
INSERT INTO rgu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tehuu ita boe ta bisa tataa tae, ‘Lahenda dae-bafoꞌ a riꞌ nadenu.’ Huu fo neuꞌ ko basa lahenda ra ramanasa. Huu fo ara ramahere rae, Yohanis nana, Manetualain mananesimatan!” ");
INSERT INTO rgu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Basa boe ma, ara rataa rae, “Ami ta malan fa!” Boe ma Yesus nataa natafali asa nae, “Kalu leoꞌ na sona, Au boe ta nau afada, ae bea riꞌ nadenu Au fa!” ");
INSERT INTO rgu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Basa ria, boe ma Yesus dedea seluꞌ no malaka agama Yahudi ria malaka nara, mese agama ra ma lasi hadas lahenda Yahudi ra. Ana pake dedea nasasamaꞌ nae, “Hapu lahenda esa tao okaꞌ fo sele ai anggor nai ria daen bibiaꞌ esa. Ana heu kofeoꞌ nan. Ma ana tao bak ela nau natanee anggor boaꞌ a oe na. Boe ma ana tao na uma naneaꞌ madema esa. Basa de ana seba okaꞌ ria fee lahenda fekeꞌ roi, fo ara rabatiꞌ buna-boaꞌ. Tutiꞌ a lahenda ria leo nusa dea a neu. ");
INSERT INTO rgu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Losa fai eꞌetu anggor boaꞌ a, boe ma manuu daeꞌ a nadenu ana uma dalen esa leo lahenda mana noi ra neu, fo hule ria nuu babati na. ");
INSERT INTO rgu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tehuu anaꞌ ria bei losa, boe ma lahenda mana noi ra homu raan, de popoꞌo ni. Basa boe ma, radenu faliꞌ ana noo lima rou na. ");
INSERT INTO rgu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Basa de manuu daeꞌ a fee seluꞌ ana uma dalen esa neu bali. Tehuu lahenda mana noi ra fepa rahea laka na. Basa de ramamaeꞌ ana, ma puu henin. ");
INSERT INTO rgu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Basa de, manuu daeꞌ a nadenu seluꞌ ana uma dale fekeꞌ esa neu bali. Tehuu ara raisa ni. Leo mae ara tao leoꞌ bea oo, manuu daeꞌ ria fee ana uma dale nara reu raroo. Tehuu mana noi sira popoꞌo ruma, ma raisa ruma. ");
INSERT INTO rgu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Besaꞌ ia bei ela adaꞌ noi lahenda esa a so. Riꞌ manuu daeꞌ a ana mane ise susue na. Huu no ta hapu eno fekeꞌ soꞌ, boe ma ana nadenu anaꞌ ria neu. Ana afi nae, ‘Kalu au fee anaꞌ ria neu, tantu ara sipoꞌ raan no malole, ma ramanene neuꞌ ana.’ ");
INSERT INTO rgu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","De, ana nadenu ana na neu. Tehuu lahenda mana noi ra rita anaꞌ ria mai, boe ma ara dedea raoꞌ nara rae, ‘Ae! Emi mete dei! Toulasiꞌ a adenu ana boki na mai so. Kalu toulasiꞌ a mate ni, sona anaꞌ ia riꞌ sipoꞌ katemaꞌ hata posakaꞌ ara. Mai taisa anaꞌ ria, fo ela leoꞌ bea na ita riꞌ soa ria posaka nara!’ ");
INSERT INTO rgu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Boe ma ara homu ra anaꞌ ria, de raisa ni. Tutiꞌ a ara tuꞌu popora na, leo okaꞌ a deaꞌ neu. Tutui nasasamaꞌ ria teꞌe adaꞌ ia!” ");
INSERT INTO rgu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Basa boe ma, Yesus natane neuꞌ lahenda bauinaꞌ sira nae, “Tuka emi dudua-aꞌafi mara, sona manuu daeꞌ a tao mana noi sira leoꞌ bea? Tuka Au, sona tantu ana mai fo naisa laꞌesa mana noi sira. Basa ria, baema ana seba okaꞌ anggor ria, leo lahenda fekeꞌ a neu. ");
INSERT INTO rgu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ita basa lees neme Manetualain Susura Makamoi Na mai so nae, ‘Hapu batu esa tukan ara tuꞌu henin so, Tehuu besaꞌ ia batu ria dadi neuꞌ sloof fo natende dii bukuꞌ a neu. ");
INSERT INTO rgu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Manetualain riꞌ here na batu ria, boe ma natende matalololen. Huu ria na de ita tita ni malole na seliꞌ!’ ” ");
INSERT INTO rgu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lahenda bauinaꞌ sira bubuluꞌ tutiꞌ a rae, Yesus tui dedea nasasamaꞌ ria nana laꞌe seluꞌ sira. Ara sama leoꞌ bisinaaꞌ a mana noi okaꞌ anggor sira. Basa boe ma, ara mulai saka enoꞌ fo nau hopu raa Ni. Tehuu ara lele lahenda kadodouinaꞌ, fo ara rahiiꞌ ramanene Yesus nanori-nafada Na. De ara foa ela mesaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Basa ria, boe ma lahenda Yahudi ra lahenda bau-ina nara radenu lahenda Farisi hida, ro lahenda reme Herodes partei na mai, reu ratatane aoꞌ roo Yesus, fo nau rahii-hiiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ara mai, boe ma ratatane aoꞌ roo Ni rae, “Papa Mesen! Ami basa bubuluꞌ Papa dale ma roos a, ma ta mapuputaꞌ fa. Papa mete noi lahenda dalen. Papa boe mafada ledo-ledo Manetualain hihii-nanaun, nana huu Papa ta mete mataꞌ fa. Naa! Besaꞌ ia, ami nau matane hata esa. Tuka ita atoran agama Yahudi na, sona ita muste bae bea fee mana pareta Roma a mane bau-ina na, do taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tehuu Yesus bubuluꞌ sira nau eediꞌ ralaꞌ Ana, ela Ana dedea soaꞌ mana pareta Roma a. Boe ma Yesus nataa nambera nae, “Ubeaꞌ taon de emi nau mahii-hii Au neniꞌ natatane ia! Soba matudu fee Au doi fulaꞌ esa fo ita anenin dei!” ");
INSERT INTO rgu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Basa de, ara loo fee Ni doi fulaꞌ esa. Boe ma Yesus hai na doiꞌ ria de parisaꞌ ana. Basa de Ana natane si nae, “Potoreet ia, nana bea mata-idun? Ma bea nade na ia?” Basa boe ma, ara rataa rae, “Ria nana mana pareta Roma a Mane Bauina na!” ");
INSERT INTO rgu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Boe ma Yesus nae, “Naa! Kalu leoꞌ na, sona emi meu fee leo mana pareta hata fo mana pareta hak na. Ma fee leo Manetualain hata fo Manetualain hak Na!” Ramanene Ni nataa nae leoꞌ na, boe ma basa si roi ramakokoaꞌ a, nana huu Ana nafada teaꞌ. Huu ria na, de ara ta bisa rahii-hiiꞌ rala Ni fa. ");
INSERT INTO rgu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hapu partei agama fekeꞌ, fo lahenda rae, partei Saduki. Ara ranori rae, lahenda mana mateꞌ ara ta rasoda seluꞌ soꞌ. Laiꞌ esa de, lahenda Saduki hida mai boe fo nau rahii-hiiꞌ Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ara dedea ro Yesus rae, “Papa Mesen! Baꞌi Musa duiꞌ fee ita, hadas ia nae: kalu saotouꞌ esa mate ela saoina na, tehuu anaꞌ taꞌa, sona touꞌ ria fadi na muste sao na ina falu ria, ela boki fee aꞌa mana maten ria anaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tebe baꞌi Musa nanori nae leoꞌ na. Tehuu ami nau matane leo iaꞌ: hapu touꞌ hitu toranooꞌ ara. Uluꞌ a sao naꞌuluꞌ, basa boe ma mate ni, tehuu anaꞌ taꞌa. ");
INSERT INTO rgu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Boe ma fadi mana tuka ria a, sao na seluꞌ ina falu ria. Ta doo bea boeꞌ te mate ni, ma ta hapu anaꞌ fa. Leoꞌ na boe fadi katelu a, ana sao na ina falu ria, tehuu mate ni, ma anaꞌ taꞌa boe. ");
INSERT INTO rgu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Leo-leoꞌ na losa fadi muri anaꞌ a boe mate ni. Basa de, ina falu ria boe maten. ");
INSERT INTO rgu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naa! Besaꞌ ia ami nau matane leo iaꞌ: Ina ria parna sao touꞌ hitu. Tehuu maneniko dae-bafoꞌ a noe fo Manetualain fee lahenda mana mateꞌ ara rasoda seluꞌ, neuꞌ ko nemeꞌ tou kahitu ara mai, inaꞌ ria dadi neuꞌ sira bea saoinan?” ");
INSERT INTO rgu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Basa boe ma, Yesus nataa nae, “Kalu emi matane leo naꞌ, sona sosoa na nae, emi bei ta bubuluꞌ matetuꞌ Manetualain Susura Makamoi Na isi na fa. Ma emi boe bei ta bubuluꞌ matetuꞌ Manetualain kuasa Na fa. De, emi sala ria so! ");
INSERT INTO rgu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nenene, e! Leo ia: nai nusatetu-ikutemaꞌ a sasao-aanaꞌ taꞌa. Basa lahenda mana mateꞌ fo Manetualain fee si rasoda seluꞌ a, ta hapu esa sao so boeꞌ. Leoꞌ na boe Manetualain ei-laꞌo-limalope nara rai nusatetu-ikutemaꞌ a ta sao fa. ");
INSERT INTO rgu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Au boe afada laꞌeneuꞌ lahenda mana mateꞌ ara rasoda seluꞌ, do taꞌa. Baꞌi Musa duiꞌ laꞌeneuꞌ ai-huu anaꞌ fo aipilaꞌ a naa ni tehuu ta putu ni fa. Emi mafarene tutuiꞌ ria, do taꞌa? Tepoꞌ fo ai a pila nai ai-huu ria, Manetualain nafada Musa nae, ‘Au ia nana, o bei-baꞌi mara Manetualain na. Riꞌ baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Sira basa doꞌo-tabe raroo neuꞌ Au losaꞌ besaꞌ ia.’ ");
INSERT INTO rgu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Naa! Ita bubuluꞌ tae, bei-baꞌi sira mate si dooꞌ a so. Tehuu, no Manetualain nae Ria bei dadi neuꞌ sira Ramatua na, huu ria na de ita bubuluꞌ tae, ara rasoda seluꞌ so. Tebe lahenda masodaꞌ a riꞌ doꞌo-tabe neu Manetualain, te ta lahenda mana mateꞌ a fa, hete? De, maneniko emi homu mahere nanori-nafadaꞌ fo riꞌ nae, lahenda mana mateꞌ ara ta rasoda seluꞌ fa, memaꞌ emi sala ria so!” ");
INSERT INTO rgu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tepoꞌ ria, mese agama esa tuka fo nenene Yesus natuuꞌ dedea no lahenda reme partei Saduki. Mese agama ria afi nae, Yesus nataa sira natatane na no malole. Basa boe ma, ana natane neuꞌ Yesus nae, “Papa! Au nau atane ae leoꞌ ia: ita hada na atoran na, ma agama a pareta na dodouꞌ nan seliꞌ. Neme basa pareta fo remeꞌ baꞌi Musa mai nana, bea riꞌ lena heni?” ");
INSERT INTO rgu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus nataa nae, “Pareta fo lena heni, nai Manetualain Susura Makamoi na, nae leoꞌ ia: ‘Basa lahenda manai Israel! Nenene matalolole! Manetualain nana, memaꞌ ita Ramatua na, ma ita Malaka na! Ta hapu fekeꞌ soꞌ, adaꞌ noi Ria mesaꞌ ana! ");
INSERT INTO rgu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","De, emi muste sue-lai neuꞌ Ana, lena neme basa-basan mai. Huu ria na, de emi muste mahiiꞌ Ana lao naroo, bubuluꞌ neuꞌ Ana, ma moi-tao mela-maku fo tuka Ria hihii-nanaun.’ ");
INSERT INTO rgu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma pareta kadua a nae leoꞌ ia: ‘Emi muste sue-lai lahenda fekeꞌ ara, sama leoꞌ o sue-lai neuꞌ ao-ina heheli ma.’ Pareta kadua ia ra riꞌ lena heni. Ta hapu pareta fekeꞌ fo lena heni neme pareta kaduaꞌ ia ra mai soꞌ!” ");
INSERT INTO rgu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Basa boe ma, mese agama ria nafada seluꞌ neuꞌ Yesus nae, “Memaꞌ! Papa mafada ria nana, tebe. Manetualain nanadadi neuꞌ ita Malaka na, ma ta hapu Ramatua fekeꞌ soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ita muste sue neuꞌ Ana lena heni basa-basan, losaꞌ ita tahiiꞌ tan seli too Ni, bubuluꞌ neuꞌ Ana, ma toi-tao mela-maku fo tuka Ria hii-nanaun. Ma ita boe muste sue lahenda fekeꞌ a, sama leoꞌ sue ita ao-ina heheli ara. Ria sona Manetualain sue ita lena neme kalu ita tuka adaꞌ noi atoran agama a. Ria malole lena neme ita fee banda tutunu-hohotuꞌ do, fee Ni hata fekeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Namanene ana nataa nae leoꞌ na, boe ma Yesus afi nae, mese agama ria bubuluꞌ no malole so. Boe ma, Yesus nae, “Hisadei na o dadi muꞌ Manetualain lahendan so.” Basa ria boe ma, ta hapu lahenda fekeꞌ naparani natatane aoꞌ no Yesus soꞌ, huu fo ara ta ralan fa. ");
INSERT INTO rgu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Basa ria, boe ma Yesus bei nanori lahenda ra nai Manetualain Uma Mamaso Ina Na. Boe ma Ana natane si nae, “Tuka emi dale dodoo mara sona, leo beaꞌ? Mese agama ra ranori laꞌeneuꞌ Kristus, fo riꞌ Manetualain tudu memaꞌ Ana neme fai a ulu na mai. Tuka sira, Ria nanadadi adaꞌ noi neuꞌ mane Daud a tititi-nonosin. Tehuu Ria ta tebe leoꞌ na fa. ");
INSERT INTO rgu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nana huu maꞌulu na Manetualain Dula-dale Malalao-malalafu Na pake Mane Daud a so, de duiꞌ nae, ‘Manetualain nafada neuꞌ au ramatua ka nae, “Mai fo matuuꞌ nai mamanaꞌ hada-horomata a nai Au boboa ona Ka. Neuꞌ ko Au tao a musunoo mara, raloe-radae ao nara neuꞌ o.’ ” ");
INSERT INTO rgu_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Neme ria mai ita bubuluꞌ tae, mane Daud a naloo neuꞌ Kristus boe nae, ‘Ramatuaꞌ’. Sosoa na nae, maneniko lahenda rae Kristus nana, adaꞌ noi mane Daud a tititi-nonosin, ria beita namadai fa. Nana huu Ria boe dadi neuꞌ mane Daud a Ramatua na.” ");
INSERT INTO rgu_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Yesus bisinaaꞌ a dedea nae leoꞌ na, boe ma lahenda dodouꞌ rahiiꞌ ramanene Ni. ");
INSERT INTO rgu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Basa boe ma, Ana nafada seluꞌ asa nae, “Emi muste besa-besa mo mese agama ra. Ara rahiiꞌ lalaꞌo, pake badu manaru fo roroso rarooꞌ a, reu raneta roo lahenda dodouꞌ ela lahenda rita si na rae, ‘Ae! Sira nana lahenda bauinaꞌ, o! ");
INSERT INTO rgu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Maneniko ara masoꞌ leo uma mamasoꞌ daleꞌ reu, do reu raa feta, sona ara saka mamana natuuꞌ maloleinaꞌ, ela lahenda dodouꞌ rita si. ");
INSERT INTO rgu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tehuu besa-besa, o! Huu fo sira boe rapuputaꞌ ina falu ra, fo ralea ra uma nara. Tehuu nai lahenda dodouꞌ matan, sona rapoti etu sira salan ria, rapadei hule-haradoi doo na seliꞌ. Ara nau lahenda rae sira dale nara makamoiꞌ a. Tehuu neuꞌ ko Manetualain fee si huhuku maberaina.” ");
INSERT INTO rgu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Basa ria, boe ma Yesus neu natuuꞌ nasare na peti derma fo nai Manetualain Uma Mamaso Ina Na. Ana nita lahenda ra mai rakodi doi kolete nara leo peti ria daleꞌ neu. Ana nita lahenda kamasuꞌi ara mai tuꞌu doiꞌ dodouꞌ nai na boe. ");
INSERT INTO rgu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Basa de, hapu ina falu kasian esa boe tuka mai hule-haradoi. Ana nakodi doi sen dua leo peti kolete daleꞌ neu. Doiꞌ ria beli na baianaꞌ naan seli. ");
INSERT INTO rgu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Basa boe ma, Yesus kape ana mana tuka dea nara ma nafada nae, “Emi mete matalolole ina falu kasian ria. Ana nakodi doiꞌ noi sen duaꞌ a, tehuu ana fee lena nemeꞌ basa lahenda sira mai. ");
INSERT INTO rgu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Basa lahenda fekeꞌ sira rakodi doi kolete neme sira doi lena nara mai. Tehuu ina falu ia, sona fee heni katemaꞌ doi nara leo Manetualain neu.” ");
INSERT INTO rgu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Basa ria, boe ma Yesus no ana mana tuka dea nara foa ela Uma Mamaso Ina a. Faiꞌ fo ara kalua, boe ma ana mana tuka dea Ni esa tudu leo Uma Mamasoꞌ Ria neu, boe ma nae, “Papa, e! Soba mete maneni ia dei! Uma ia malole inaꞌ! Ara ratutuleꞌ batu bauinaꞌ ara malole na seli!” ");
INSERT INTO rgu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tehuu Yesus nataa nae, “Tebe, Uma ia malole a! Tehuu ta dooꞌ a soꞌ, te rarerefaꞌ heni katemaꞌ batu ia ra.” ");
INSERT INTO rgu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Basa boe ma, Yesus asa leo lete Saitun a reu, ratuuꞌ rai mamanaꞌ fo nasare leo Uma Mamaso Ina a neu. Basa boe ma, ana mana tuka dea Ni haa mesaꞌ asa mai dedea raoꞌ roo Ni. Siꞌ Petrus, Yakobis, Yohanis ma Anderias. ");
INSERT INTO rgu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ara ratane, raeꞌ, “Papa! Soba Papa mafada seluꞌ bisinaꞌ a dedea ma. Tepo-tadaꞌ bea rina ledo-fai sira mai? Ma tanda nara leo beaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Basa boe ma Yesus nataa, naeꞌ, “Sadi emi manea matalolole, ó! Fo ela emi bosoꞌ nanatipu-nanadaiꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Huu fo neuꞌ ko hapu lahenda rupa ara mai fapa ara nara rae, ‘Au ia Kristus, riꞌ lahenda fo Manetualain helu memaꞌ neme fai a ulun na mai so a’. Basa te ara tipu-dai ra lahenda dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maneniko emi mita lahenda ratati ao, do emi mamanene fifoꞌ rae, natati aoꞌ a nai basa mamanaꞌ ara, sona emi bosoꞌ bii. Huu fo rupaꞌ leo naꞌ ara dadi raꞌulu dei, tehuu dae-bafoꞌ a nonoe na beita losa fa. ");
INSERT INTO rgu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Neuꞌ ko leo esa natati soaꞌ leo fekeꞌ. Nusaꞌ esa natati soaꞌ nusa fekeꞌ. Dae a natakeko nai basa mamanaꞌ ara. Fai laa-roes inaꞌ a! Basa ia ra dadi tanda, sama leoꞌ inaꞌ fo besaꞌ ko mulai nameda hedi bobokiꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","De emi muste manea matalolole, e! Huu fo neuꞌ ko ara mai hopu ra emi fo hela ro emi leo mamana naꞌetu dedea agama a meu. Ma ara popoꞌo emi nai uma mamasoꞌ ara daleꞌ. Boe ma heke ro emi leo mana homu kuasa ra meu nana huu emi tuka Au. Tehuu ria dadi salaak fo emi mafada si laꞌeneuꞌ Au. ");
INSERT INTO rgu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Huu fo Manetualain lahenda nara muste reu tui-beka raꞌuluꞌ Au Tutui Malole Ka neuꞌ basa leo nai dae-bafoꞌ ia, besaꞌ ko dae-bafoꞌ a nonoe na losa. ");
INSERT INTO rgu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mafarereneꞌ, ó! Kalu ara heke ro emi leo mamana naꞌetu dedeaꞌ a meu, emi bosoꞌ biiꞌ mae, ‘Neuꞌ ko au dedea ae leoꞌ bea? Do au ataa ae, leoꞌ bea?’ Maneniko ledo-fai na losa leoꞌ na, emi dedea tuka hata fo Manetualain Dula-dale Malalao-malalafu Na nafada emi a. ");
INSERT INTO rgu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nai uma esa daleꞌ, kalu hapu lahenda namahere neuꞌ Au, neuꞌ ko toranoo boki na boe saka enoꞌ fo naisa ni. Maneniko ana a namahere, neuꞌ ko papa boki na riꞌ naisa ni. Ma kalu hapu ina-ama a ramahere neuꞌ Au, neuꞌ ko ana nara raisa si. ");
INSERT INTO rgu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","De, neuꞌ ko lahenda eteꞌ ao nara ro emi, nana huu emi mamahere neuꞌ Au. Tehuu bea riꞌ nanenete losaꞌ babasa na, tantu Manetualain fee ni soda-moleꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus dedea naroo, naeꞌ, “Lahenda bauꞌmeruina esa neuꞌ ko mai. Ana kodi neu napadeiꞌ nai mamana luliꞌ nai Manetualain Uma Mamaso Ina Na, fo ta naraa soaneuꞌ ana fa, losaꞌ tao nakekeo mamanaꞌ ria. Huu ria na, de Manetualain nasadea laꞌo ela mamanaꞌ ria. Maneniko emi mita leoꞌ na, sona besa-besa, ó! (Bea fo riꞌ lees nita ia, boe muste besa-besa!) Ria dadi tanda nae, fai susa a losa nai lelesu bafaꞌ a so. Maneniko lahenda fo rai propinsi Yudea rita leoꞌ na, sona ara ralai leo leteꞌ lain reu. ");
INSERT INTO rgu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma muste ralai inaꞌ a, fo ela leoꞌ bea na ara bosoꞌ soe. Maneniko bea kalua ela uma a, sona bosoꞌ fali neu hai hata nai uma baliꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Boe ma lahenda fo nai oka-tine, bosoꞌ fali fo neu hai lafa hanas a bali. Tehuu nalai naroo leo! ");
INSERT INTO rgu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kasian naan seli a, nana neuꞌ ina kairus ara, ro inaꞌ fo bei anutu ana boki beuꞌ. Huu fo ara ta bisa ralai inaꞌ a fa. ");
INSERT INTO rgu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","De, malole lenaꞌ emi hule-haradoi fo ela hata tadaluꞌ ria boso dadi naraa laꞌe fai uda. ");
INSERT INTO rgu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Huu fo fai uda sona susa mamateꞌ! Mulai nemeꞌ Manetualain adu na dae-bafoꞌ a losaꞌ besaꞌ ia, lahenda beita parna rita susa bauinaꞌ rupa leo naꞌ a. Ma neuꞌ ko lahenda boe ta rita seluꞌ susa rupa leo naꞌ a soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kalu Manetualain ta tao eꞌetu fai ria fa, neuꞌ ko ta hapu lahenda esa nanenete nai soda na boeꞌ. Tehuu, no Manetualain sue-lai neuꞌ lahendan fo Ana here naa si so a, huu ria na de Ana tao eꞌetu fai susa sira. ");
INSERT INTO rgu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Maneniko faiꞌ ria losa, emi mamanene lahenda ra rae, ‘Mete dei! Kristus nai ia!’ Ma lahenda fekeꞌ ara rae, ‘Kristus nai ele!’ Tehuu emi bosoꞌ mamanene, e! ");
INSERT INTO rgu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Huu fo neuꞌ ko hapu lahenda kalua mai fo fapa ara na nae, ‘Au ia, nana Kristus!’ Fekeꞌ ara rae, ‘Au ia, nana Manetualain mananesimatan.’ Neuꞌ ko ara tao tanda heran rupaꞌ ara pake nitu a kuasa na, fo rapuputaꞌ lahenda. Ara soba-soba fo Manetualain lahenda nara nanatipu-nanadaiꞌ boe! ");
INSERT INTO rgu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tehuu emi muste manea matalolole, e! Fai-fai susa sira beita losa fa, tehuu Au afarereneꞌ memaꞌ fee emi so, ó!” ");
INSERT INTO rgu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Basa boe ma, Yesus tuti seluꞌ bali fo nafada ana mana tuka dea nara, naeꞌ, “Maneniko basa fai-fai susa sira so, ‘Neuꞌ ko ledo a dadi maꞌiu, bulaꞌ a boe ta nahaa soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ruuꞌ ara ramomonu ao remeꞌ lalai mai, ma kuasa fo rai lalaiꞌ ara taohiro-taohari.’ ");
INSERT INTO rgu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Basa ria nana, besaꞌ ko basa lahenda rita Au, Lahenda Teteaꞌ ia. Neuꞌ ko Au onda emeꞌ lalai mai. Ma basa lahenda ra rita Au kuasa Ka, ma Au kahere kara katemaꞌ! ");
INSERT INTO rgu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Basa te Au pareta Manetualain eilaꞌo-limalopen rai nusatetu-ikutemaꞌ a, fo reu rabubua ra basa lahenda fo Au here a si remeꞌ dae-bafoꞌ a bukun haa si mai, nemeꞌ dulu losa muri; ma neme ii losa ona.” ");
INSERT INTO rgu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus tuti naroo dedea na nae, “Au hai nasasamaꞌ neme ai huuꞌ a mai. Maneniko doo nara mulai mofa, ria tanda na nae, fai fanduꞌ a naneneaꞌ mamaiꞌ a so. ");
INSERT INTO rgu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Leoꞌ na boe, maneniko emi mita fai-fai susa a mai, sama leoꞌ bisinaꞌ a Au afada a, ria nanadadi tanda nae, Au mamai Ka naneneaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Besaꞌ ia, nenene matalolole! Neme basa lahenda fo rasoda rai besaꞌ ia, neuꞌ ko ruma beita mate fa, te fai-fai susa sira mai so. ");
INSERT INTO rgu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Leo mae lalai no dae-bafoꞌ ia sapu-lalo, tehuu Au dedea Ki ia nanenete losa doo-doo na neu.” ");
INSERT INTO rgu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus dedea tamba nae, “Ta hapu lahenda esa bubuluꞌ faiꞌ bea ma liꞌu hida fo Au atafali seluꞌ mai. Manetualain eilaꞌo-limalope nara rai nusatetu-ikutemaꞌ a boe, ta bubuluꞌ fa. Au boe ta bubuluꞌ fa. Adaꞌ noi Au Papa Ka riꞌ bubuluꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Huu ria na, emi muste manea matalolole, nana huu emi ta bubuluꞌ ria ledo-fain fa. ");
INSERT INTO rgu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta dooꞌ a soꞌ te Au foa ela emi, tehuu neuꞌ ko Au atafali seluꞌ mai. Samaleoꞌ manuu umaꞌ fo laꞌo ela uma na de leo mamanaꞌ dooꞌ a neu. Ana nadenu ana uma dale nara fo rafaduli ratalolole uma ria. Ma ana bati fee si esaꞌ ko nooꞌ ria nonoi-tataon. Ana pareta manea lelesu bafaꞌ a fo ranea ratalolole, losaꞌ ana fali main. ");
INSERT INTO rgu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Emi boe muste manea hatu-leledon, huu fo emi ta bubuluꞌ manuu umaꞌ a fai hidaꞌ fali main. Fali ledo leo dae na do, hatu na do, ledo hanan do, balahaa anan. Emi ta bubuluꞌ fai hidaꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bosoꞌ losa kekeneu te ana mai, boe ma hapu na emi suku mamanee. ");
INSERT INTO rgu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","De, hata fo Au afadan neuꞌ emi ia, Au boe afada basa lahenda fekeꞌ ara aeꞌ, ‘Emi muste manea matalolole fo sipoꞌ Au mamai Ka.’ ” Yesus dedea no ana mana tuka dea nara nai lete Saitun lain a, teꞌe adaꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Basa ria, boe ma malaka agama Yahudi ra malaka nara roo mese agama ra, rasaka enoꞌ fo hopu ramanininoꞌ Yesus. Huu fo ara nau raisa Ni. Tehuu ara dodoo-tatai eno na rae, “Mahani dei! Ita bosoꞌ talale hopu Ni, nana huu fai malole a naneneaꞌ so. Bosoꞌ losa neuꞌ ko lahenda kadodouinaꞌ sira rafarau ra ita fo tao nahuu-nalenaꞌ.” Ara dedea rae leoꞌ na, huu fo bei faiꞌ dua bali, te lahenda Yahudi ra fai malole na, fo riꞌ, rae ‘Fai Paska’ ma ‘Feta Roti Ta Pake Ralu Teteiꞌ fa.’ Ma fai malole ria, nana ara rafarene fai a ulu na, tepoꞌ fo bei-baꞌi nara kalua reme dae Masir a mai a. ");
INSERT INTO rgu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nai koro Betania, hapu lahenda esa, nade Simon. Maꞌulun na lahenda rahiaꞌ ana, nana huu hapu hedi kusta. Tehuu besaꞌ ia ao-ina na makamoiꞌ a so. Tepoꞌ fo, fai malole ria beita mai fa, Yesus asa reu raa-rinu nai Simon uma na. Faiꞌ fo ara raa-rinu, te inaꞌ esa mai naneta no Yesus. Ana homu neni boto fo taon nemeꞌ batu a mai. Isi na mina maboomeniꞌ teaꞌ mabeli a. Basa de, inaꞌ a beru natepa boto ria tatana na. Boe ma ana poꞌa mina ria, feen titi bai-bai neuꞌ Yesus laka Na, fo dadi tanda nae, ana fee hada-horomata neuꞌ Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tehuu lahenda fekeꞌ hida fo raa-rinu rai naa boe. Ara rita inaꞌ ria tao leo naꞌ, boe ma ara ramanasa, de ara dedeaꞌ koaoꞌ rae, “Ae! Ina ubeaꞌ ia, fo neu tuꞌu heni hihiiꞌ mina maboomeni mabeli beraꞌ ia! ");
INSERT INTO rgu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Malole lenaꞌ ana seꞌo mina ria! Fo neu babati doi kadodouinaꞌ sira fee lahenda hata taaꞌ ara! Huu fo mina maboomeniꞌ ria, beli na sama leoꞌ lahenda kadi na teuꞌ esa.” Boe ma ara rasaꞌai ni. ");
INSERT INTO rgu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tehuu Yesus nataa si nae, “Emi bosoꞌ tao masususaꞌ inaꞌ ia! Nemeꞌ na! Au amahoꞌo, nana huu ana poꞌa mina mabomeniꞌ ia neuꞌ Au ao-ina Ka. ");
INSERT INTO rgu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Lahenda kasian ara roo emi kose-kose. De, emi bisa tulu-fali sira nai fai bea a. Tehuu Au sona, ta dooꞌ a fa, te Au ta sama-sama oo emi soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Au soda Ka ta dooꞌ a soꞌ. Ma bisinaꞌ a inaꞌ ia poꞌa mina a, nana ana sadia naꞌulu Au ao-ina Ka, sama leoꞌ ria kari na laꞌesa rampe neuꞌ Au popora Ka. ");
INSERT INTO rgu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mafarereneꞌ matalolole, o! Sudi nai mamanaꞌ bea oo, Manetualain Tutui Malole Na tui-bekan rule-feo dae-bafoꞌ ia, tantu ara tui inaꞌ ia malole na boe. Fo ela basa lahenda rafareneꞌ neu ana.” ");
INSERT INTO rgu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Basa boe ma, neme Yesus ana mana tuka dea kasanahulu dua nara esa mai, nade Yudas Iskariot. Ana kalua neu saka malaka agama Yahudi ra malaka nara, fo nau seꞌo heni Yesus fee si. Losa si boe ma, nafada ria dale hihii na. ");
INSERT INTO rgu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Faiꞌ fo malaka ra ramanene Yudas dedea nae leoꞌ na, boe ma ramahoꞌo raan seli. Boe ma ara helu rae, “Kalu o nau seꞌo Yesus fee ami, tantu ami bae.” Yudas kalua, boe ma ana mulai saka enoꞌ fo nau fee heni Yesus neuꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Faiꞌ ria laꞌe fai masososaꞌ neme lahenda Yahudi ra fai malole na mai. De, nai faiꞌ ria, ara biasa tunu roti ta pake ralu teteiꞌ, ma hala bibi-lopo boe. Basa boe ma, Yesus ana mana tuka dea nara mai ratane Ni rae, “Papa! Faiꞌ ia, ita fai malole Paska na. De, Papa nau ami meuꞌ bea sadia mamana feta Paska?” ");
INSERT INTO rgu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Boe ma Yesus nadenu ana mana tuka dean dua nae, “Emi meu maꞌulu kota daleꞌ. Nai na neuꞌ ko emi maneta mo touꞌ esa, nasaa neni oe neuꞌ kusi anaꞌ esa. Emi meu tuka ni. ");
INSERT INTO rgu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Maneniko ana kodi leo uma bea daleꞌ neu, sona tuka leo naꞌ meu. Basa sona mafada manuu umaꞌ a mae, ‘Papa! Ami Mesen ma hule mamanaꞌ esa, fo Ana nau pake ni ela tao feta Paska no ana mana tuka dea nara.’ ");
INSERT INTO rgu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Neuꞌ ko lahenda ria natudu fee emi kama maloaina esa nai uma a huhurun lain. Ana sadia na kama ria namadai so. De, adaꞌ noi emi dua meuꞌ na fo sadia nanaaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Basa boe ma, dua si leo kota daleꞌ reu. Nai na dua si raneta roo basa-basan fo Yesus nafada so a. Boe ma ara sadia basa-basan, ela Yesus asa raa feta Paska reuꞌ na. Basa boe ma dua si reu raloo Yesus asa. ");
INSERT INTO rgu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ledo a mulai tena so, boe ma Yesus no ana mana tuka dean sanahulu dua si leo naꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Boe ma ara ratuuꞌ raa-rinu sama-sama. Faiꞌ fo ara raa, boe ma Yesus dedea nae, “Emi nenene, e! Hapu lalenda esa neme emi mai, neuꞌ ko ana seꞌo Au leo lahenda fekeꞌ ara u.” ");
INSERT INTO rgu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ramanene leoꞌ na, boe ma dale nara ta tama soꞌ. Tutiꞌ a sira esa-esa natane Yesus nae, “Lahenda fo Papa mafada a, ta au fa, hete?” ");
INSERT INTO rgu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus nataa nae, “Lahenda fo naboro roti na leo mako ia daleꞌ neu sama-sama no Au, ria riꞌ neuꞌ ko naseꞌo heni Au leo lahenda fekeꞌ ara u. ");
INSERT INTO rgu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mafarereneꞌ, é! Au, Lahenda Teteaꞌ, muste mate sama leoꞌ manaduiꞌ nai Manetualain Susura Makamoi Na daleꞌ so. Tehuu besa-besa! Lahenda fo nau seꞌo heni Au a, neuꞌ ko lepa na soe a! Malole lenaꞌ kalu mama na ta boki nan fa!” ");
INSERT INTO rgu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tepoꞌ fo ara bei raa, boe ma Yesus hai na roti baloꞌ esa, de hule makasi neuꞌ Manetualain. Basa boe ma Ana tetebi roti ria, de loo fee ana mana tuka dea nara, Ana nae, “Roti ia, nana Au ao-ina Ka. Hai man fo mia leo.” ");
INSERT INTO rgu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Basa ria, boe ma Ana hai na galaas fo anggor oeꞌ nai daleꞌ. Boe ma Ana hule makasi neuꞌ Manetualain. Basa de Ana loo galaas ria leo ana mana tuka dea nara neu fo rinu. ");
INSERT INTO rgu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Boe ma Ana nae, “Anggor ia, nana Au daa Ka. Neuꞌ ko ana faa fo fee lahenda dodouꞌ sodaꞌ a. Daa ia dadi buti fo fee nafarereneꞌ nae, hata fo Manetualain helu a, memaꞌ besaꞌ ia dadi so. Naa, hai maan fo minu leo. ");
INSERT INTO rgu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nenene matalolole dei! Mulai nemeꞌ hatun ia mai, Au ta inu anggor oe soꞌ. Losaꞌ Au atuuꞌ pareta sama-sama oo Papa Ka nai nusatetu-ikutemaꞌ a, besaꞌ ko Au inu bali.” ");
INSERT INTO rgu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Basa boe ma, ara soda sosodaꞌ esa, io-oa neuꞌ Manetualain. Tutiꞌ a hatun ria boe ara kalua de leo lete Saitun a reu. ");
INSERT INTO rgu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tepoꞌ fo ara laꞌo-laꞌo a, Yesus nafada memaꞌ asa nae, “Neuꞌ ko selubaiꞌ hatun ia, emi basa malai ela Au. Ria sama leoꞌ manaduiꞌ memaꞌ nai Susura Makamoiꞌ daleꞌ nae, ‘Neuꞌ ko Manetualain naisa manafoo a, de, bibi-lopo nara ralai tapasara.’ ");
INSERT INTO rgu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tebe Au mate. Tehuu maneniko Au asoda seluꞌ, Au auluꞌ emi leo propinsi Galilea u.” ");
INSERT INTO rgu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Basa boe ma, Petrus nadedea laka nae, “Papa! Leo mae lahenda fekeꞌ ara basa si ralai ela Papa, tehuu au sona taꞌa.” ");
INSERT INTO rgu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus nataa nae, “Petrus! Mafarerene, é! Hatun ia, manuꞌ ara beita kokoꞌoa kalaiꞌ dua na, te o mafada laiꞌ telu so mae, ta malelaꞌ Au fa.” ");
INSERT INTO rgu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tehuu Petrus nataa no hara bera nae, “Taꞌa, Papa! Kalu Papa Ka mate, au boe mate sama-sama. Tehuu au ta alai ela Papa ka fa, ma ta alena Papa boeꞌ.” Yesus ana mana tuka dea feke nara boe rae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Basa ria, boe ma Yesus asa losa mamanaꞌ esa nai lete Saitun, nade ‘Getsemani’. Yesus nafada ana mana tuka dea nara nae, “Emi mahani ia, e! Au nau uuꞌ hule-haradoi nai ele.” ");
INSERT INTO rgu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Boe ma Yesus naloo no Petrus, Yakobis ma Yohanis, fo laꞌo sama-sama roo Ni. Mulai neme naꞌ mai, boe ma dale Na susa ma ta tama fa. ");
INSERT INTO rgu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana nafada si nae, “Au dale Ka susa naan seli. Au ameda an nonooꞌ nae Au sakaꞌ mate! Emi matuuꞌ manea nai ia dei!” ");
INSERT INTO rgu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Basa de Ana lali nala dooꞌ a seluꞌ baiꞌ, boe ma Ana sundaꞌ undulaka Na, neuꞌ dae a fo hule-haradoi nae, “Papa manasue-manalai! Kalu Papa mataa, sona Au bosoꞌ lepa doidoso rupa leo iaꞌ a losa mate. Au bubuluꞌ memaꞌ so ae, ta hapu hata esa fo Papa ta bisa tao ni fa. De, kalu bole sona, Papa tuꞌu madoo doidoso ia nemeꞌ Au mai. Tehuu bosoꞌ tuka Au hihii-nanau Ka; ela leoꞌ bea na tuka noi Papa Ka hihii-nanaum.” ");
INSERT INTO rgu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Basa boe ma, Ana fali leo ana mana tuka dea kateluꞌ sira neu, tehuu ara suku ramanee. Boe ma Ana fafae nafoa si, de nafada neuꞌ Petrus nae, “Peꞌu! O suku, do! Au uꞌ ria adaꞌ noi hate mataꞌ boe, tehuu emi ta manea baiꞌ boeꞌ! ");
INSERT INTO rgu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Madidilaꞌ mata mara dei. Basa sona foa fo manea mo Au! Emi dale mara sona rahiiꞌ tao malole, te noi emi aopaa mara ta baraꞌai a fa. De, malole lenaꞌ hule-haradoi, ela maneniko hapu sosobaꞌ boe oo, ta naseki emi fa.” ");
INSERT INTO rgu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Basa boe ma Yesus neu hule seluꞌ laꞌesa bali. Ana hule seluꞌ neuꞌ Manetualain, bosoꞌ foa ela Ni fo lepa doidoso ria. ");
INSERT INTO rgu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Basa de Ana fali main leo ana mana tuka dea kateluꞌ sira. Tehuu ara suku seluꞌ bali, huu fo mata nara rambera. Ana fafae nafoa seluꞌ asa, tehuu ara ta bubuluꞌ rataa Ni rae leoꞌ bea soꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Boe ma, Yesus neu hule-haradoi seluꞌ kalaiꞌ telu na. Basa boe ma Ana fali de fafae nafoa si. Ana nae, “Emi bei suku bali, do? Dai so! Foa leo! Lahenda fo nau seꞌo heni Au Lahenda Teteaꞌ ia a, naneneaꞌ so. Besaꞌ ia ara nau hopu ra Au, fo fee Au leo lahenda tadalu ara lima dale nara uu. ");
INSERT INTO rgu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Foa leo! Madilaꞌ mata mara fo soba mete leo eleꞌ meu! Lahenda fo nau seꞌo heni Au a, mai so. Mai fo ita teu soruꞌ asa!” ");
INSERT INTO rgu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus bai dea-dea te Yudas noo lahenda dodou-inaꞌ mai so. Ara mai reni tafaꞌ, ai tutukuꞌ, fo nau hopu Yesus. Ara tao leo naꞌ tuka pareta neme malaka Yahudi ra mai. Sira nana siꞌ malaka agama ra malaka nara, mese agama ra, ma lasi hadas ara. ");
INSERT INTO rgu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas nalaisiꞌ mema asa so nae, “Emi mete matalolole! Au deꞌi bea, sona hopu maa Ni leo! Huu fo Ria riꞌ, lahenda fo emi saka ni a.” ");
INSERT INTO rgu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tepoꞌ fo Yudas asa losa na, boe ma ana nasare nasuu tinoꞌ Yesus. Basa de ana nateꞌa nae, “Papa Mesen!” Boe ma Yudas holu nan ma deꞌi Ni. ");
INSERT INTO rgu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tutiꞌ a lahenda kadodouinaꞌ sira tuturuu mata reu, de hopu ra Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tehuu Yesus lahendan esa lesu na fela lakatuku ana na, de seru naꞌetu lahenda esa ridoo na. Lahenda mananeni hinaꞌ ria, nana malaka agama Yahudi a malaka bau-ina na ana uma dalen. ");
INSERT INTO rgu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus dedea no lahenda fo ara mai hopu Ni a nae, “Leoꞌ bea? Emi mae Au ia nana lahenda tadaluꞌ, do? De, emi meni tafaꞌ ma aitutukuꞌ fo mai hopu Au? ");
INSERT INTO rgu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tuka-tuka faiꞌ Au anori-afada emi nai Manetualain Uma Mamaso Ina Na daleꞌ, tehuu ta hapu lahenda esa hopu na Au boeꞌ. Mai hopu ma Au leo! Huu fo ia nana manaduiꞌ memaꞌ neme uluꞌ mai so nai Manetualain Susura Makamoi Na daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus ana mana tuka dea nara bii mamateꞌ. Boe ma ara ralai foa elan mesaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nai na boe, hapu anatou muri anaꞌ esa, tutukaꞌ Yesus dea na. Ana naluse lafatende bibia anaꞌ esa. Lahenda sira nau homu ran boe. ");
INSERT INTO rgu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tehuu ara rano ra noi lafatende na. Basa de ana nalai poꞌiraoꞌ neu ni, huu fo ana bii mamateꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Basa ria boe ma, ara hela roo Yesus leo malaka agama Yahudi a malaka bau-ina na uma na neu. Nai naa, lahenda bauinaꞌ ara tesa so. Siꞌ malaka agama ra malaka nara, mese agama ra, ma lasi hadas ara. ");
INSERT INTO rgu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tepoꞌ fo hopu roo Yesus, Petrus boe tuka nafufuniꞌ nesi buiꞌ, losa nai malaka agama Yaudi a malaka bau-ina na uma na. Ana masoꞌ leo uma a mata na neu, de natuuꞌ namaneru ai sama-sama no lahenda manea fo rai na. ");
INSERT INTO rgu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nai uma ria daleꞌ, malaka agama ra malaka nara dedea rao nara roo lahenda fo ratuuꞌ rai mamana naꞌetu dedea agama. Sira basa saka buti fo nau fee Yesus salaꞌ a, nana huu ara nau huku raisa Ni. Tehuu ara ta hapu buti esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Boe ma raloo ra sakasii dodouꞌ fo nau ratuda Yesus. Tehuu sira dedean ria, esa ta naraa no esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hapu sakasii hida foa rapadeiꞌ de tui rapuputaꞌ rae, ");
INSERT INTO rgu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ami mamanene lahenda ia dedea nae, ‘Neuꞌ ko Au fate abuu Uma Mamaso Ina fo riꞌ rafoan pake lahenda dae-bafoꞌ a lima na. Basa faiꞌ telu bali, neuꞌ ko Au afoa faliꞌ Uma ria, tehuu ta pake lahenda dae-bafoꞌ a lima na fa.’ ” ");
INSERT INTO rgu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tehuu sira dedean ria, esa ta naraa no esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Boe ma Malaka Bauinaꞌ a foa napadeiꞌ nai lahenda mana ee dedea ara matan, ma natane Yesus nae, “Ubeaꞌ taon de O ta mahahara baiꞌ boeꞌ? O ta sipoꞌ lahenda ia ra kolaa nara esa boe?” ");
INSERT INTO rgu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus ta dedea baiꞌ boeꞌ. Basa de malaka agama Yahudi a malaka bau-ina na natane seluꞌ Ana nae, “Soba O mafada dei! Tetebes ara O ia, nana Kristus, Manetualain Anan fo helu memaꞌ neme uluꞌ mai a, do?” ");
INSERT INTO rgu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus nataa nae, “Memaꞌ tebe. Ria nana, riꞌ Au ia. Neuꞌ ko emi basa mita Au, Lahenda Teteaꞌ ia, atuuꞌ nai nusateta-ikutemaꞌ a nai Manetualain boboa ona Na. Ria kuasa Na kahereꞌ naan seli! Neuꞌ ko Au o Ni homu belaꞌ pareta a! Basa ria nate, neuꞌ ko Au onda emeꞌ nusatetu-ikutemaꞌ a mai, nai oaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ramanene Yesus dedea nae leoꞌ na, boe ma malaka agama Yahudi a malaka bau-ina na namanasa mamateꞌ, losaꞌ sii nalutu badu manaruina na. Basa boe ma ana naloo namberaina, nafada lahenda fo ratuuꞌ rai mamana naꞌetu dedea ria nae, “Ita ta parluu manasakasii soꞌ? ");
INSERT INTO rgu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Emi mamanene mataꞌ, Ria riꞌ nafada aon, hete? Ana soꞌu aon dadi neuꞌ Manetualain Ana Na. Dedea namamuluꞌ bauinaꞌ ia! Tuka atoran agama a, kalu hapu lahenda tao aon sama leoꞌ Manetualain, lahenda ria muste maten! De, besaꞌ ia emi nau maꞌetuꞌ mae, ubea?” Boe ma basa si raetuꞌ rae, “Lahenda ia memaꞌ sala! De, ana muste hapu huhuku mamates a!” ");
INSERT INTO rgu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Boe ma lahenda hida mata reu, de mudi radiu Yesus ape. Ara poti etu mata Na, ma fepa-liꞌu Ni. Basa de ara rafada Ni rae, “Kalu O nana Manetualain mananesimatan, sona soba maneuꞌ. Bea riꞌ fepa-liꞌu O ia?” Basa boe ma ara pareta lahenda fo ranea Uma Mamaso Ina a, fo mai hela roo Yesus. Ara roo Ni laꞌo, boe ma ara fepa ramiminaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Faiꞌ ria, Petrus bei natuuꞌ nai uma a matan. Basa boe ma, malaka agama Yahudi a malaka bau-ina na, ana ina uma dalen esa mai, nita ni namaneru ai. Ana bebesa natalolole Petrus mata-idun, basa boe ma ana dedea nae, “Bisinaaꞌ a, o boe tuka mo Yesus, lahenda Nasaret ria, hete?” ");
INSERT INTO rgu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tehuu Petrus nataa nae, “Taꞌa! Ubeaꞌ taon de o matane mae leoꞌ na? Au ta alelaꞌ Ana fa.” Basa boe ma, Petrus deaꞌ neu, de napadeiꞌ nai kota bafaꞌ a. Naraa no ria boe ma, manuꞌ a kokoꞌoa. ");
INSERT INTO rgu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Basa boe ma, ana uma daleꞌ ria nita seluꞌ Petrus bali. Boe ma ana nafada lahenda fo rai na nae, “Touꞌ ia nana esa neme lahenda sira mai boe.” ");
INSERT INTO rgu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Boe ma Petrus nadedea laka nae, “O bate mamulu? Au ta alelaꞌ lahenda ria fa!” Ta doo bea boeꞌ te, lahenda fekeꞌ esa nai na nafada neuꞌ Petrus nae, “Ae! O bei masararali bali mae, o ta sama-sama moo lahenda sira fa! Ae! Emi basa lahenda Galilea, hete?” ");
INSERT INTO rgu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tehuu Petrus nalena bali nae, “Ae! Au soo-supa au ta alelaꞌ lahenda Ria fa!” ");
INSERT INTO rgu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naraa no ana dedea nae leoꞌ na, boe ma manuꞌ a kokoꞌoa kadua na. Boe ma Petrus nafarene Yesus dedea bisinaa Na nae, “Manu ara beita kokoꞌoa laiꞌ dua, te o malena Au laꞌi telu so.” Petrus nafarene na leoꞌ na, boe ma ana dola nasaꞌeedu. ");
INSERT INTO rgu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bei balahaa anaꞌ te, basa lahenda fo rai mamana naꞌetu dedeaꞌ ria, rala hara na fo nau raisa Yesus. Basa boe ma, ara heke roo Ni neu nasare gubernor Pilatus a. ");
INSERT INTO rgu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ara losa, boe ma gubernor Pilatus a natane Yesus nae, “Leoꞌ bea? Tebe O ia nana lahenda Yahudi ra Mane na, do?” Yesus nataa nae, “Tebe. Papa gubernor dedea laꞌe ria!” ");
INSERT INTO rgu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Basa boe ma, malaka agama Yahudi ra malaka nara dedea ro gubernor a rae, “Lahenda ia tao salaꞌ ta baianaꞌ a soꞌ!” Boe ma ara tui esa-esa ro Yesus sala nara. ");
INSERT INTO rgu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Basa boe ma, gubernor a natane seluꞌ Yesus nae, “O ta mamanene sira dedea nara fa? Ara fee O salaꞌ ta baianaꞌ a soꞌ. Soba O sefi sira dedea nara dei!” ");
INSERT INTO rgu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tehuu Yesus ta nataa hata-hata esa boeꞌ, losaꞌ gubernor ria heran. ");
INSERT INTO rgu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tuka-tuka teuꞌ nana, maneniko lahenda Yahudi ra tao feta Paska, sona lahenda kadodouinaꞌ ara biasa here ra lahenda manahukuꞌ esa, fo gubernor a poꞌi nan nemeꞌ bui daleꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tepoꞌ ria, lahenda manahukuꞌ esa, nade Barabas. Maꞌulu na, hopu raa ni no nonoo nara, nana huu ana nalena laka neuꞌ mana pareta Roma, ma naisa lahenda boe. ");
INSERT INTO rgu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huu no feta Paska a naneneaꞌ so, boe ma lahenda kadodouinaꞌ sira leo gubernor Pilatus mai, fo bobouꞌ rae, “Papa gubernor! Fai Paska a mai so. Kalu bisa, sona Papa gubernor poꞌi lahenda manahukuꞌ esa sama leoꞌ bale-bale a!” ");
INSERT INTO rgu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Boe ma gubernor a nataa nae, “Naa! Au nau poꞌi bea? Leoꞌ bea sona au poꞌi Yesus, fo lahenda Yahudi ra Mane na? Emi mataa, do?” ");
INSERT INTO rgu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernor a dedea nae leoꞌ na, sekonaa te ana bubuluꞌ malaka agama Yahudi ra malaka nara, roo Yesus leo mata na mai nana huu eteꞌao nara raan seli ro Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tehuu malaka agama sira duduku-papauꞌ lahenda kadodouinaꞌ ara, fo basa si hule gubernor a, raeꞌ, “Ami ta mahiiꞌ Ana fa! Ami mahiiꞌ poꞌi Barabas!” ");
INSERT INTO rgu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Basa boe ma, gubernor a natane seluꞌ, naeꞌ, “Kalu leoꞌ na sona au tao Yesus leoꞌ bea, fo riꞌ raloo Ni, sona rae ‘Maneꞌ lahenda Yahudi?” ");
INSERT INTO rgu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Boe ma basa si rahara belaꞌ a, raeꞌ, “Maꞌisan leo! Paku Ni neuꞌ ai kakeꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Basa boe ma, gubernor a natane, naeꞌ, “Te Ana nasalaꞌ ubeaꞌ? Au parisaꞌ Ana so, tehuu ta hapu Ni sala hata esa boe!” Tehuu basa si rahara rambera ina rae, “Maisa Ni leo! Paku Ni neuꞌ ai kakeꞌ a leo!” ");
INSERT INTO rgu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Huu no gubernor a nau tao naloloa lahenda kadodouinaꞌ sira dale nara, de ana poꞌi Barabas, tuka lahenda sira hihii-nanaun. Basa boe ma, ana pareta lahenda manea ra fepa-liꞌu Yesus reniꞌ hataꞌ esa sama leoꞌ hai ikoꞌ a. Fepa-liꞌu basan, boe ma soldadu ra roo Yesus, fo nau reu paku raisa Ni nai ai kakeꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Basa ria, boe ma soldadu ra hela roo Yesus leo sira kintal maloa na neu. Nai na raloo ra sira nonoo nara batalyon esa. ");
INSERT INTO rgu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Boe ma ara olu fee Yesus badu pila barakeoꞌ manaru esa, sama leoꞌ biasa maneꞌ ara pake a. Basa boe ma, hai ra ai makouꞌ a rana nara, de ralanen tao silaka. Boe ma ara poroꞌ silaka makouꞌ ria neuꞌ Yesus laka Na, ma ara doꞌo-tabe ramimina Ana, sama leoꞌ ara sakaꞌ soꞌu mane bebeuꞌ, de feen pake silaka mana pareta. ");
INSERT INTO rgu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Boe ma basa si fee hada-horomata ramiminaꞌ neuꞌ Yesus ma rae, “Tabeꞌ, maneꞌ lahenda Yahudi!” ");
INSERT INTO rgu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Boe ma ara sundaꞌ fufudiꞌ undulaka nara nai Yesus matan, fo tao uni sira doꞌo-tabe Ni. Basa nana, ara mudi rasarerei ape neuꞌ mata-idu Ni. Ma ara pake ai, fo fepa reiꞌ-rei Roon. ");
INSERT INTO rgu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ara ramiminaꞌ basa Ni, boe ma ara olu heni badu manaru ria. De fee Ni pake seluꞌ papake nara. Basa boe ma, ara roo Ni kalua kota Yerusalem a, fo reu pakun ma londan nai ai kakeꞌ a, losaꞌ maten. ");
INSERT INTO rgu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Faiꞌ fo kalua reme kota Yerusalem mai, ara raneta ro lahenda esa nai eno taladaꞌ, besaꞌ ko nemeꞌ kota Kirene mai. Nade Simon. Ria nana Aleksander no Rufus papa na. Ana besaꞌ ko nae leo Yerusalem neu, tehuu soldadu ra homu raan, de raseti ni nasaa Yesus ai kake Na. ");
INSERT INTO rgu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ara roo Yesus losa mamana esa, nade Golgota. (Sosoa na nae, ‘Mamana laka duiꞌ’.) ");
INSERT INTO rgu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nai naa, ara nau fee Yesus ninu anggor maꞌeis, epoꞌ ana no ai-doo, fo ela leo bea na Ana nanenete hedi. Tehuu Yesus ta nau ninu fa. ");
INSERT INTO rgu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Basa boe ma, ara paku ralelekaꞌ Yesus neuꞌ ai kakeꞌ a. Boe ma ara rapadeiꞌ ai kakeꞌ ria, nana bate liꞌu sio balahaa na. Boe ma soldadu ra hela lot, fo ela nau bubuluꞌ bea riꞌ hapu Yesus papake nara. ");
INSERT INTO rgu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Basa de ara duiꞌ nai papaꞌ esa, fo paku ni nai Yesus laka na lain nae, “Ia nana, Maneꞌ lahenda Yahudi” Ara pake enoꞌ ria fo ela huku Yesus. ");
INSERT INTO rgu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nai ria boe, ara paku ramate lahenda parampok dua. Esa nai Yesus boboa ona Na, ma esa nai boboa ii Na. ");
INSERT INTO rgu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","No ria na ara tuka hata fo manaduiꞌ memaꞌ nai Manetualain Susura Makamoi Na nae, “Ara tao raan sama leoꞌ parampok.” ");
INSERT INTO rgu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Basa lahenda fo laꞌo resiꞌ naa, rita Yesus nanalondaꞌ nai ai kakeꞌ a. Ara leleuꞌ laka nara, ma dedea ramumulu-ramamaeꞌ Yesus rae, “Awe! O mae bisa rua mabuu Manetualain Uma Mamaso Ina Na, basa nate noi faiꞌ teluꞌ a, te mafoa mafaliꞌ ana, hete? ");
INSERT INTO rgu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Soba O onda memeꞌ ai kakeꞌ ria mai, fo poꞌi ma aom leo. Kalu leoꞌ na sona besaꞌ ko ami mamahere mae, O ia nana Manetualain Ana Na.” ");
INSERT INTO rgu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Malaka agama Yahudi a malaka nara boe ramumulu-ramamaeꞌ Yesus, ma beidea rae, “Ana tao na lahenda fekeꞌ a sodaꞌ so, tehuu ta bisa fee sodaꞌ neuꞌ ao-ina Na fa. ");
INSERT INTO rgu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hule aon nae, Ria nana ‘Kristus’, Lahenda fo Manetualain helu memaꞌ neme uluꞌ mai so. Lahenda fekeꞌ ara rae, Ria nana lahenda Israꞌel Mane Na. Kalu tetebe sara leoꞌ na, sona ela leoꞌ bea na onda nemeꞌ ai kakeꞌ a mai, fo ita tita dei. Leoꞌ na sona besaꞌ ko ita bisa tamahere Ni.” Lahenda kaduaꞌ fo londa bela asa roo Yesus nai ai kakeꞌ a, ara ramumulu-ramamaeꞌ Yesus boe. ");
INSERT INTO rgu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Basa ria, boe ma maꞌiuinaꞌ a napoti na mamanaꞌ ria nemeꞌ ledo namatetun a mai, losaꞌ liꞌu telu leodae na. ");
INSERT INTO rgu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Naraa no liꞌu telu leodae na, boe ma Yesus naloo nambera pake dedea Aram nae, “Eloi! Eloi! Lama sabaktani?” (Sosoa na nae, “Au Ramatua Ka! Au Manetualain Ka! Ubeaꞌ taon de O masadea Au leoꞌ ia?”) ");
INSERT INTO rgu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lahenda hida raneneaꞌ rai na, ramanene Yesus hara Na. Boe ma rae, “Ae! Emi nenene dei. Ana naloo Elia, Manetualain mana nesimata faiulun ria.” ");
INSERT INTO rgu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Basa boe ma, lahenda esa nalai-nalai mesan neu hai na lopu, de naboron neuꞌ anggor maꞌeis daleꞌ. Ana pau teteꞌe a peda na neuꞌ lopu ria, boe ma looꞌ ana neuꞌ Yesus bafa Na, fo ela nasamumusi. Basa de, lahenda baidea, raeꞌ, “Tahani fo tita tasudin! Bea bubuluꞌ bate Elia mai fo naꞌonda Ni nemeꞌ ai kakeꞌ ria mai.” ");
INSERT INTO rgu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Basa de Yesus naloo seluꞌ bali, boe ma mate Ni. ");
INSERT INTO rgu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nai Uma Mamaso Ina daleꞌ, hapu tema maloaina esa manapepeleꞌ fo ela babaa Manetualain Kama Malalao-malalafu Na. Naraa no Yesus etu hahae Na, boe ma temaꞌ ria sii batin neuꞌ dua, nemeꞌ lain losa daeꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nai Golgota, hapu soldadu ra malaka manean esa napadeiꞌ naneneaꞌ nai Yesus ai kake Na. Ana nita Yesus mamate Na, boe ma kekes ara. Basa de nae, “Awi! Lahenda ia nana, tebe-tebe Manetualain Ana Na, o!” ");
INSERT INTO rgu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ma hapu inaꞌ hida rita Yesus mamate Na, ara rai dooꞌ a. Sira nana, maꞌulun na ralalau Yesus asa nai Galilea. Siꞌ Salome, Maria nemeꞌ nusa Magdala, ma Maria esa bali (riꞌ Yakobis muriꞌ a no Yoses mama na), ma ina fekeꞌ fo tuka roo Yesus sama-sama leo Yerusalem mai. ");
INSERT INTO rgu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Basa ria, boe ma lahenda esa saka eno, fo nau naꞌonda na Yesus popora Na neme ai kake ria mai. Lahenda ria nade Yusuf, nemeꞌ kota Arimatea a mai. Ma ria boe ei-limaꞌ neme mana ee dedea agama Yahudi a. Dale na malole a. Ana nahani Manetualain pareta na mamain. Yesus mamate na laꞌe soda limaꞌ. Balahaa nate naraa no lahenda Yahudi ra fai huhule-haradoin. Huu ria na, de soda lima na Yusuf nau naꞌonda naꞌuluꞌ Yesus popora Na. Basa boe ma, ana napararani dale na, de neu hule Yesus popora Na nai gubernor Pilatus a. ");
INSERT INTO rgu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Faiꞌ fo Gubernor a namanene Yusuf hule nae leoꞌ na, boe ma ana heran. Basa de nae, “Awi! Te lahenda ria maten lai-lai a? Au ae bate ta leo naꞌ fa, o!” Boe ma ana nadenu lahenda reu raloo malaka soldadu ria, de natane ni nae, “Leoꞌ bea? Yesus, maten so, do beiꞌ?” ");
INSERT INTO rgu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Malaka soldadu ria nataa nae, “Memaꞌ mate Ni riꞌ bisinaaꞌ a so, papa.” Gubernor a namanene leoꞌ na, boe ma ana fee Yusuf lelaꞌ fo neu naꞌonda na Yesus popora Na. ");
INSERT INTO rgu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Boe ma Yusuf neu asa temaꞌ manaruina mabeli a. Tutiꞌ a ana leo Golgota neu. Boe ma naꞌonda na Yesus popora Na nemeꞌ ai kakeꞌ a mai. Ana popoti natalolole poporaꞌ ria neniꞌ tema bebeuꞌ. Tepoꞌ ria, ara besaꞌ ko paa basa bolo mamates esa nai lete batu a. Ara oꞌo reni Yesus popora Na de ratoin neuꞌ boloꞌ ria daleꞌ. Boe ma ara loli ra batu bebela kabaꞌuina esa, de ena ratalololen neu boloꞌ ria bafa na. Boe ma, Yusuf asa fali. ");
INSERT INTO rgu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Faiꞌ ria Maria neme Magdala no Maria (fo Yoses mama na), boe ara tuka losa na. Dua si rita ma rafarereneꞌ ratalolole mamanaꞌ fo riꞌ ara tao Yesus popora Na neu a. ");
INSERT INTO rgu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Balahaaꞌ, soda nee na, fo lahenda Yahudi ra fai huhule-haradoin. Ledo a tena so, boe ma Maria nemeꞌ nusa Magdala, Maria fekeꞌ (fo riꞌ Yakobis mama na), ma Salome, reu asa mina maboomeniꞌ, fo ela balahaa nana reu pisi neuꞌ Yesus popora Na, tuka lahenda Yahudi ra hada na. ");
INSERT INTO rgu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mamaso na, bei balahaa anaꞌ, te telu si leo rates ria reu so. ");
INSERT INTO rgu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ara beidea rai eno taladaꞌ raeꞌ, “Ae! Mai te bea riꞌ tulu-fali ita fo eso heni batu kabaꞌuina ria nemeꞌ rates a bafa na mai? Ita telu boe tantu ta bolen fa, te batu ria bauꞌbasa na.” Tehuu ara losa na, te rita batu a nanaesoꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Basa boe ma ara masoꞌ raroo leo rates daleꞌ reu. Tehuu ara kekesara, nana huu rita lahenda murianaꞌ esa natuuꞌ nai sira boboa ona na, pake papake fula makadilaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Boe ma lahenda murianaꞌ ria nafada si nae, “We! Emi bosoꞌ bii! Au bubuluꞌ emi mai fo nau saka Yesus, neme Nasaret, fo riꞌ ara londa ramaten nai ai kakeꞌ a. Ana ta nai ia so, te Ana nasoda seluꞌ so. Mai fo mita mataꞌ, mamanaꞌ fo ara rapeuꞌ Yesus popora Na, rouꞌ so. ");
INSERT INTO rgu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Naa, emi fali lai-lai leo! Meu mafada Petrus asa, maeꞌ, Yesus nasoda seluꞌ so. Ana laꞌo naꞌuluꞌ leo Galilea neu so. Neuꞌ ko ara raneta roo Yesus nai na, sama leoꞌ maꞌulu na Ana nafada si a. Naa, emi fali leo!” ");
INSERT INTO rgu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tepoꞌ fo inaꞌ ara rita mamanaꞌ ria rouꞌ, boe ma ara kekes ara. Tutiꞌ a ara ralai deaꞌ mai. Basa boe ma ara ralale de fali reu si. Ara ta tutui esa nai enoꞌ boeꞌ, nana huu ara bii mamateꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mamaso na balahaan ria, Yesus neu natudu naꞌuluꞌ mata-idun neuꞌ Maria neme Magdala, fo maꞌulu na parna Yesus usi heni nitu hitu reme ao-ina na mai. ");
INSERT INTO rgu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana nita basa Yesus boe ma, tutiꞌ a ana fali neu nafada basa lahenda fo riꞌ maꞌulun ria tuka Yesus a. Ara bei rabubua ao nara no dale susa, ma luu nara tuda nana huu rafarene Yesus mamate Na. ");
INSERT INTO rgu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Basa boe ma, Maria nafada si nae, “Ubeaꞌ taon de emi bei susa bali? Bosoꞌ boe susa, huu fo Yesus nasoda seluꞌ so! Bisinaaꞌ a, besaꞌ ko au aneta oo Ni!” Tehuu basa si rataa rae, “Ae! O fufudiꞌ ria!” ");
INSERT INTO rgu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Basa boe ma, Yesus ana mana tuka dean dua lalaꞌo leo koroꞌ esa reu. Losa eno taladaꞌ, boe ma Yesus natudu mata-idun neuꞌ dua si. Tehuu Ana dadi fekeꞌ. Tehuu ta doo bea boeꞌ, te ara ralelaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Basa boe ma, dua si fali reu rafada nonoo nara rae, “Ae! Emi nenene dei! Bisinaaꞌ a, besaꞌ ko ami maneta mo Yesus nai enoꞌ!” Tehuu nonoo nara basa si rataa rae, “Ae! Emi bosoꞌ dedea fufudiꞌ leo naꞌ, ó!” ");
INSERT INTO rgu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Basa boe ma, Yesus naneta no ana mana tuka dea kasanahulu esa nara, faiꞌ fo ara raa-rinu. Ana nasaꞌai si nae, “Ae! Emi laka batu mara seli! Lahenda rafada emi rae, ara rita mataꞌ Au so, tehuu emi ta nau mamahere fa! Emi mae, sira basa fufudiꞌ! Naa! Besaꞌ ia Au mai mata ki riaꞌ so. Au mate tebe, tehuu besaꞌ ia Au asoda seluꞌ so! Naa, emi mete ao mara leo. ");
INSERT INTO rgu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De, besaꞌ ia emi muste laꞌo rule-feo basa dae-bafoꞌ ia bukun haa si, fo meu mafada lahenda ra Au Tutui Malole Ki ia. ");
INSERT INTO rgu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lahenda fo namahere neuꞌ Au, ma ana sarani, neuꞌ ko Manetualain fee ni soda-moleꞌ a, fo ana leo naroo noo Manetualain nai nusatetu-ikutemaꞌ a. Tehuu lahenda fo ta namahere fa, neuꞌ ko ana hapu huhuku-lalakeꞌ, ma Manetualain tipa henin fo leo nahaniꞌ deaꞌ. ");
INSERT INTO rgu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma lahenda fo ramahere neuꞌ Au, neuꞌ ko ara tao tanda heran rupaꞌ ara, ela basa lahenda bubuluꞌ rae, sira kuasan ria, tebe nemeꞌ Manetualain mai. Leo-leoꞌ, neuꞌ ko ara bisa usi nitu pake Au nade Ka. Neuꞌ ko Manetualain tao naa si, bisa dedea pake dedea fekeꞌ fo ara ta ralelaꞌ ana fa. ");
INSERT INTO rgu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma, kalu ara hopu meke manuu rasoꞌ, do ara rinu roi raso, ara ta hapu soe fa. Boe ma kalu ara fua lima nara neuꞌ lahenda kamahedis ara, neuꞌ ko lahenda sira teꞌe ra ao nara.” ");
INSERT INTO rgu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus bei dea-dea no ana mana tuka dea nara, boe ma Manetualain soꞌu naꞌaeꞌ Yesus leo nusatetu-ikutemaꞌ a neu. Nai naa, Ana dadi neuꞌ Manetualain lima ona na, huu fo dua si pareta belaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Basa boe ma, ana mana tuka dea nara tuka Ria pareta na. Ara leo basa mamanaꞌ ara reu fo rafada basa lahenda ra Yesus Tutui Malole Na. Manetualain fee si kuasa, fo ara tao katemaꞌ tanda heran fo Yesus nafada si so a. Boe ma lahenda dodou-inaꞌ ramahere neuꞌ Yesus, huu fo ara bubuluꞌ so rae, Tutui Malole ria nana tebe leoꞌ na. Tepoꞌ fo inaꞌ kateluꞌ sira losa Petrus asa, boe ma rafada nai basa-basan laꞌeneuꞌ tou murianaꞌ fo riꞌ bisinaaꞌ a dedea nai rates a. Basa boe ma Yesus pareta matan ana mana tuka dea nara, fo ara reu tui-beka Ria Tutui Malolen ia nai basa mamanaꞌ ara, losa dae-bafoꞌ a bukun haas. Tutui Malole ia natudu enoꞌ fo Manetualain fee lahenda soda-moleꞌ neme sala-siko nara mai, fo ela rasoda raroo roo Ni. Tutui Malole ia, memaꞌ tebe. Huu ria na de ana nanenete naroo, losa doo-doo na neu. ");
INSERT INTO rgu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Papa Teofilus susuek. Soda-moleꞌ. Lahenda dodouꞌ usaha duiꞌ tutuiꞌ laꞌeneuꞌ hihii-nanauꞌ fo dadi nai ita talada. Ara duiꞌ tutuiꞌ fo ami bubuluꞌ neme Ramatua Yesus lahenda nara mai, ma neme lahenda fekeꞌ fo rita mataꞌ a. Tutuiꞌ ria tui-bekan nai ami talada neme masososan losaꞌ besaꞌ ia. Basa tutuiꞌ sira natetu no Manetualain hehelu Na neme uluꞌ mai. Au parisaꞌ besa-besa hihii-nanauꞌ ria neme dadadi masososa oe na mai so. Huu ria na, au aetuꞌ an duiꞌ atalololes tuka momori-dadadin. No ria na, papa bisa bubuluꞌ matetuꞌ mandadiꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma papa bisa mamahere mae, hata fo lahenda tui fee a, nana tutui napuputaꞌ ta ria fa. Tebe-tebe hapu basa sira! ");
INSERT INTO rgu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tutuiꞌ ia masososa na leo iaꞌ: Tepoꞌ fo mane Herodes pareta nai Propinsi Yudea, touꞌ esa nade Sakaria. Ria nana malaka agama Yahudi esa rian. Ma ria boe lima-eiꞌ neme lahenda nabuaꞌ malaka agama baꞌi Abia mai. Sakaria sao na nade Elisabet. Elisabet papa na malaka agama. Ria nana tititi-nonosiꞌ neme baꞌi Musa aꞌan Harun mai. ");
INSERT INTO rgu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sira dua masoda nara tuka matetuꞌ Manetualain pareta na ma atoran nara katemaꞌ. Lahenda ra hadaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dua si ramalasi so, tehuu anaꞌ taꞌa, huu fo Elisabet nana teditei-tamadaleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Laiꞌ esa de, Sakaria no Abia lahenda nabua nara fai nonoi lakan nai Uma Mamaso Ina a, nai kota Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tuka sira biasa na, malaka agama ra hela lot, ela bubuluꞌ fai ria bea riꞌ nonoi lakan fo masoꞌ leo Uma Mamaso Ina a Kama Malalao-malalafu na neu. Nai na lahenda ria muste hotu ai maboo-meniꞌ nai Manetualain mata Na. Fai ria Sakaria hela na lot a. ");
INSERT INTO rgu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Boe ma ana leo daleꞌ neu. Fai fo ana hotu ai maboo-meniꞌ nai Kama ria daleꞌ, lahenda dodouꞌ ara hule-haradoi rai uma a matan. ");
INSERT INTO rgu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kekeneu te, Manetualain eilaꞌo-limalopen esa neme nusatetu-ikutemaꞌ a mai, napadei nai mamana hohotu ai maboo-meniꞌ ria boboa ona na. ");
INSERT INTO rgu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria nita leoꞌ na, boe ma ana bii nan seli losaꞌ ta bubuluꞌ nae tao ubeaꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tehuu eilaꞌo-limalope ria dedea nae, “Sakaria! Bosoꞌ biiꞌ! Huu fo Manetualain namanene o huhule-haradoi ma so. De, neuꞌ ko sao ma boki fee o ana touꞌ esa. O muste foin nade Yohanis. ");
INSERT INTO rgu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Neuꞌ ko lahenda dodouꞌ ramahoꞌo sama-sama ro emi, huu no emi hapu anaꞌ so. Anaꞌ ia neuꞌ ko tao na o dale ma namahoꞌo-natadale. ");
INSERT INTO rgu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Manetualain Dula-dale Malalao-malalafu Na kuasa na sama-sama no ni, mulai neme mama na nairu ni a. Ana muste naluli ara-ralu. Tepoꞌ fo nambau ina mai, Manetualain pake ni dadi neuꞌ lahenda bauinaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Neuꞌ ko lea-nore noo lahenda Israel dodouꞌ ratafali mai tuka sira Ramatua na, fo riꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ria leleo-lalaꞌon ma kuasa na sama leoꞌ Manetualain mana nesi matan, baꞌi Elia. Ana mai naꞌuluꞌ ita Ramatua na. Ana tao na ina-ama a dale nara ratafali sue-lai ana nara. Ma lahenda fo rasadea Manetualain boe, ana tao na si ratafali fo tuka Manetualain hihii-nanaun. No ria na ana tao na lahenda ra sadia dale nara de sipoꞌ Ramatuaꞌ a mamai Na.” ");
INSERT INTO rgu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tehuu Sakaria natane natafaliꞌ eilaꞌo-limalope ria nae, “Hapu nai bea bisa leo naꞌ?! Au oo sao ka mamalasi so! Neme bea mai au bubuluꞌ ae basa ia ra dadi?” ");
INSERT INTO rgu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Basa boe ma eilaꞌo-limalope ria nataa nae, “Leo iaꞌ! Au ia Gabriel, Manetualain lahenda nadedenun. Ria riꞌ nadenu au mai, fo afada o Tutui Malole ia. ");
INSERT INTO rgu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tehuu o ta nau mamahere au dedea-nafada ki fa. De o hule a, tanda na leo iaꞌ! Mulai neme besaꞌ ia mai o dadi muꞌ pakanaꞌ, ta dedea fa losaꞌ emi hapu anaꞌ ria. Neuꞌ ko o mita mataꞌ. Huu no hata fo au afada ia a, naraa laꞌe ledo-fai na te ana dadi.” ");
INSERT INTO rgu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lahenda kadodouꞌ fo hule-haradoi rai uma a mata na a, roi ramakokoaꞌ a, huu fo Sakaria ta kalua deaꞌ mai fa. ");
INSERT INTO rgu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Faiꞌ fo ana kalua deaꞌ mai, te ta bisa dedea soꞌ. Ana noi tuduꞌ a, de ara bubuluꞌ rae, Manetualain natudu fee ni hihii-nanauꞌ mana dadi bebeuꞌ nai Kama Malalao-malalafuꞌ ria daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Basa nonoi lakaꞌ a, boe ma Sakaria fali leo uma na neu. ");
INSERT INTO rgu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ta doo bea boeꞌ te Elisabet nairu. De, nahaniꞌ uma na daleꞌ losaꞌ bulaꞌ lima. Ana dedea nae, “Io-oa Manetualain! Mateꞌe na Manetualain natudu dale malole Na neuꞌ au. Maneniko au hapu tititi-nonosiꞌ, sona lahenda ta ramamaeꞌ au soꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tepoꞌ fo Elisabet nairu, tei na laꞌo bulaꞌ nee, boe ma Manetualain fee eilaꞌo-limalopen esa neme nusatetu-ikutemaꞌ a mai, leo koroꞌ esa neu, nade Nasaret, nai propinsi Galilea. Eilaꞌo-limalope ria nade Gabriel. ");
INSERT INTO rgu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nai Nasaret hapu ana feto anaꞌ esa nade Maria. Maria no touꞌ esa nade Yusuf dua si rahihii aoꞌ. Yusuf nana mane Daud a tititi-nonosin. Gabriel neu naneta no ana feto ana Maria. ");
INSERT INTO rgu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ana natudu ao na neuꞌ ana fetoꞌ ria, boe ma nae, “Ana feto anaꞌ on, soda-moleꞌ neuꞌ o! Manetualain here na o, fo sakaꞌ tao fee o hihii-nanauꞌ malole esa. Maria, Manetualain sama-sama no o.” ");
INSERT INTO rgu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria namanene na eilaꞌo-limalope ria dedea na, boe ma noi namakokoaꞌ. Ana ta bubuluꞌ sosoa na ubeaꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Boe ma eilaꞌo-limalope ria sipoꞌ nae, “Maria! O bosoꞌ biiꞌ. Huu fo ia nana sosoa na nae Manetualain natudu dale malole Na neuꞌ o. ");
INSERT INTO rgu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta dooꞌ a soꞌ te o mairu, de neuꞌ ko boki ma ana touꞌ esa. O muste foin nade, Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Neuꞌ ko Ana dadi neuꞌ Lahenda bauinaꞌ. Neuꞌ ko Manetualain hule Ni sona nae, ‘Ria nana Au Ana boki Ka.’ Ria nana Manetualain Madema Ana Na. Neuꞌ ko Manetualain soꞌu nan fo pareta, sama leoꞌ baꞌin mane Daud a. ");
INSERT INTO rgu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Neuꞌ ko Ana pareta naroo lahenda Israel ara. Huu fo Ria pareta Na ta etu-basan fa.” ");
INSERT INTO rgu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tehuu Maria natane Gabriel nae, “Au bei ta parna suku abua oo touꞌ esa boeꞌ! Tao leoꞌ bea de au bisa airu?” ");
INSERT INTO rgu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Boe ma Gabriel nataa nae, “Leo iaꞌ! Manetualain Dula-dale Malalao-malalafu Na onda neuꞌ o. Ma Manetualain Madema a kuasa Na nasuru-nahapa o. No ria na, Anaꞌ fo neuꞌ ko o boki ma ni a, tebe-tebe malalao-malalafuꞌ. Huu fo Ria nana Manetualain Anan. ");
INSERT INTO rgu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bosoꞌ heran! Huu fo o toranoom esa nade Elisabet, nairu so boe. Lahenda rae ana ta boki fa, nana huu namalasi so. Tehuu besaꞌ ia ana nairu laꞌo bulaꞌ nee ian so. ");
INSERT INTO rgu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Huu fo soaneuꞌ Manetualain, basan bisa dadi!” ");
INSERT INTO rgu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Boe ma Maria sipoꞌ nae, “Malole a. Au ia nana Manetualain atan. De ela basan dadi tuka o dedeam ria. Au sadia tuka Manetualain hihii-nanaun.” Boe ma eilaꞌo-limalope ria laꞌo ela ni. ");
INSERT INTO rgu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Basa faiꞌ hida, boe ma Maria neme Nasaret mai nalale de leo Sakaria koro na neu, nai propinsi Yudea nusa lete malelepi nara. Losa na boe ma ana kodi leo Sakaria uman daleꞌ neu, ma nafada Elisabet nae, soda moleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet bei namanene Maria hara oe soda-molen ria, boe ma anaꞌ fo nai Elisabet tein daleꞌ a nababale. Ma Manetualain Dula-dale Malalao-malalafu Na onda neuꞌ Elisabet daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Boe ma ana dedea nambera nae, “Maria! Neuꞌ ko lahenda ra soꞌu ramadedema o nade ma lena heni basa inaꞌ nai dae-bafoꞌ ia! Neuꞌ ko lahenda ra boe soꞌu ramadedema Anaꞌ fo nai o teim daleꞌ a! ");
INSERT INTO rgu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Au boe nanasoꞌu-nanafuaꞌ, huu fo au Ramatua ka mama Na mai dama au. ");
INSERT INTO rgu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","O bei kodi losa uma daleꞌ de fee hara oe soda-moleꞌ neuꞌ au, tutiꞌ a anaꞌ fo nai au tei ki daleꞌ a, boe nababale nana huu namahoꞌo-natadale. ");
INSERT INTO rgu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Manetualain natudu dale malole Na neuꞌ o so, huu fo o mamahere mae, Ana nau tao tuka Ria hehelu Na.” ");
INSERT INTO rgu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria dedea nae, “Neme au dale ka mai, au io-oa Manetualain! ");
INSERT INTO rgu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au dale ka namahoꞌo-natadale, huu fo Manetualain au manasoi-manatefa ka! ");
INSERT INTO rgu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ana relu-natanae neuꞌ au, Ria ata sosoa-raraa tan ia. Mulai neme besaꞌ ia mai, neuꞌ ko basa lahenda ra tao au neuꞌ, ina maua-manaleꞌ, ");
INSERT INTO rgu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","huu fo Manetualain tao hihii-nanau bebeuꞌ soaneuꞌ au. Ria nana, Mana kuasa Bauinaꞌ ma Malalao-malalafuꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Manetualain natudu dale kasian Na neuꞌ basa lahenda fo hada-hormata ma doꞌo-tabe neuꞌ Ana, neme tititi-nonosiꞌ esa mai leo tititi-nonosiꞌ esa neu. ");
INSERT INTO rgu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ana pake kuasa Na, de tao na lahenda mana koaoꞌ ara rasidaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ana naonda heni mana pareta ra, huu no natutua-nadedema ao nara. Tehuu Ana soꞌu-fua lahenda dale maloe-madae aoꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ana nahao lahenda mamalaa-maparoeꞌ ara losa rabete, tehuu Ana usi heni lahenda kamasuꞌi ara fo fali no lima rouꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana tulu-fali Ria lahenda Israel nara, ma natudu kokosen dale kasian Na neuꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Maꞌulu na Ana tao hekene-barataꞌ no ita bei-baꞌi nara, riꞌ baꞌi Abraham no basa tititi-nonosi nara. Besaꞌ ia hekene-barataꞌ ria mana hekeꞌ losa doo-doo na neu.” ");
INSERT INTO rgu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Basa de Maria leo no Elisabet losa bulaꞌ telu. Boe ma ana fali leo uma na neu nai Nasaret. ");
INSERT INTO rgu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ledo-fain losa boe ma, Elisabet boki na ana touꞌ esa. ");
INSERT INTO rgu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kileoboboki nara ro koro isiꞌ ara ramanene tutuiꞌ ria rae, Manetualain natudu dale malole Na so, ma fee Elisabet anaꞌ esa. Boe ma basa si ramahoꞌo boe. ");
INSERT INTO rgu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Anaꞌ ria faiꞌ falu, boe ma ara sunat ana, tuka lahenda Yahudi ra atoran na. Ara nau foi anaꞌ ria nade Sakaria, tuka papa na nade na. ");
INSERT INTO rgu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tehuu mama na ta nataa fa, ana nae, “Muste foin nade Yohanis!” ");
INSERT INTO rgu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tehuu ara sipoꞌ rae, “Ubeaꞌ taon de here nade Yohanis a? Ta hapu lahenda esa nai emi kileoboboki mara pake nadeꞌ ria!” ");
INSERT INTO rgu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Boe ma ara tudu Sakaria, fo nau fee anaꞌ ria nade bea. ");
INSERT INTO rgu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria tudu fo hule lei no garefe. Ara feen, boe ma ana duiꞌ nae, “Yohanis!” Boe ma basa lahenda ra roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kekeneu te Sakaria bisa dedea seluꞌ. Boe ma ana io-oa neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Basa lahenda fo leo raneneaꞌ rai na, ara bii-ramataꞌu. Ma mana dadiꞌ ria tui-bekan nai sira talada, losaꞌ bisa lahenda rai propinsi Yudea lete malelepi nara boe, ratui hihii-nanauꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lahenda fo ramanene tutuiꞌ ria, aafi rae, “Makaledoꞌ a so, Manetualain kuasa Na sama-sama no anaꞌ ria. Neuꞌ ko nambau-ina mai, te ana dadi lahenda ubeaꞌ, oo?” ");
INSERT INTO rgu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Basa boe ma, Manetualain Dula-dale Malalao-malalafu Na onda neuꞌ Sakaria. Huu ria de ana dedea nae, ");
INSERT INTO rgu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Io-oa Ramatuaꞌ, lahenda Israel ara Manetualain na! Nana huu Ana mai so, fo soi-tefa na lahenda nara, ela ara bosoꞌ sama leoꞌ ata a. ");
INSERT INTO rgu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Manetualain soꞌu na Lahenda esa kuasa Na marela-masaꞌa, de neuꞌ ko fee ita sodaꞌ a. Ria nana neme mane Daud a tititi-nonosin mai. ");
INSERT INTO rgu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Manetualain helu memaꞌ basa ia ra neme uluꞌ mai so, pake Ria lahenda mana nesi mata teteka-hehere nara. ");
INSERT INTO rgu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Besaꞌ ia Ana nau poꞌi-tata na ita, teme ita musunoo nara mai, ma teme lahenda fo eteꞌ ao nara ro ita a. ");
INSERT INTO rgu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ana natudu dale malole Na neuꞌ ita bei-baꞌi nara, nana huu Ana nafarene nahere hehelu Na neuꞌ asa, fo Ana tao hekene-barataꞌ no baꞌi Abraham. ");
INSERT INTO rgu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ana poꞌi-tata na ita teme musunooꞌ ara mai, ela ita bisa doꞌo-tabe neuꞌ Ana, ma ta bii-tamataꞌu soꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ana poꞌi-tata na ita, ela ita bisa tasoda malalao-malalafuꞌ ma roo-tetuꞌ laꞌo naroo nai Ria mata Na. ");
INSERT INTO rgu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yohanis! O nana au ana ki. Neuꞌ ko lahenda ralelaꞌ rae, o nana Manetualain Madema a mana nesi mata Na. Neuꞌ ko muu mafada lahenda ra, fo ara sipoꞌ Ramatuaꞌ a mamai Na. ");
INSERT INTO rgu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Neuꞌ ko muu matudu enoꞌ fee Manetualain lahenda nara, ela ara bubuluꞌ rae, sira hapu sodaꞌ a, nana huu Manetualain sae-safe heni sala nara. ");
INSERT INTO rgu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Huu fo Manetualain dale balaroe-balanaun ma kasian Na neuꞌ ita, huu ria na Ana fee ita lelaꞌ, sama leoꞌ ledo a tii-toda de neni makaledo bebeuꞌ, Ita fo leo-laꞌo nai maiuꞌ a, ma biiꞌ mamates a, nana huu bei ta malole to Manetualain fa, neuꞌ ko hapu makaledoꞌ a, fo napipipi-nalalaꞌo ita leo eno mole-dame a teu.” ");
INSERT INTO rgu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yohanis tamba faiꞌ, tamba nambau-ina. Ma Manetualain Dula-dale Na feen mapii-baraꞌaiꞌ. Ana nambau-ina, boe ma neu leo nai mamana lino-nes, losaꞌ ana mulai noi ria nonoi laka na fee lahenda Israel ara. ");
INSERT INTO rgu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Tepoꞌ fo Korenius dadi malaka nai nusa Siria, laiꞌ esa de mane bauinaꞌ, nade Agustus, ana kalua pareta nae, “Basa lahenda fo rai mana pareta Roma a kuasa na daeꞌ, muste fali leo koro nara reu ela duiꞌ asa!” Ria nana besaꞌ ko masososa na mana pareta Roma reke anaraun ara. ");
INSERT INTO rgu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De, basa lahenda ra fali leo koro nara reu fo duiꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Tepoꞌ ria Yusuf leo nai koro Nasaret nai propinsi Galilea. Ana nahiiꞌ ana feto anaꞌ esa nade Maria, fo nairu so. Yusuf nana mane Daud a tititi-nonosin, de ana muste fali leo Daud kota Betlehem na neu, nai propinsi Yudea, ela duiꞌ asa. Huu ria na de, dua si leo kota Betlehem reu. ");
INSERT INTO rgu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tepoꞌ fo rai na, boe ma naraa no ledo-fai fo Maria noi boki. ");
INSERT INTO rgu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tehuu nai na ara ta hapu kama nai uma ofu a fa. Huu ria na de, ara masoꞌ leo bibi oka daleꞌ reu. Boe ma ana boki ana ulu na, ana touꞌ, raluse Ni reniꞌ taisaiꞌ, ma rapeuꞌ Ana neuꞌ haꞌo banda daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hatun ria, mana foo hida ranea bibi nara rai moꞌ nai kota a deaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kekeneu te, ara rita Manetualain eilaꞌo-limalopen neme nusatetu-ikutemaꞌ a mai. Boe ma Manetualain makaledo Na nahaa rule-feo na si, de ara biiꞌ raan seli. ");
INSERT INTO rgu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tehuu eilaꞌo-limalope ria nafada si nae, “Emi bosoꞌ bii! Nenene matalolole dei! Huu fo au mai afada emi tutui malole esa. Basa-basan fo ramanene tutuiꞌ ia, tantu ramahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tutui malole ia isi na leo iaꞌ: Faiꞌ ia boki Kristus so, nai Betlehem fo mane Daud a kota na. Kristus nana Lahenda fo Manetualain helu memaꞌ neme uluꞌ mai. Manetualain fee Ni mai, nana ela soi-tefa na lehenda reme sala-siko nara mai! Neuꞌ ko lahenda raloo Ni sona rae, ‘Ramatuaꞌ’! ");
INSERT INTO rgu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Neuꞌ ko emi malelaꞌ Ana leo iaꞌ: emi maneta mo Ana boki beuꞌ esa nananaluseꞌ neniꞌ taisaiꞌ. Ana napeuꞌ nai haꞌo banda daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ana dedea basa, boe ma kekeneu te, Manetualain eilaꞌo-limalopen dodouꞌ asa reme nusatetu-ikutemaꞌ a mai de rabua ro ni. Boe ma ara io-oa Manetualain ma soda rae, ");
INSERT INTO rgu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ami io-oa Manetualain nade Na! Ana natuuꞌ pareta nai lalai madema. Manetualain nau fee mole-dame neuꞌ lahenda nai dae-bafoꞌ a, fo tao ra dale Na namahoꞌo!” ");
INSERT INTO rgu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Basa de, Manetualain eilaꞌo-limalope nara fali leo nustetu-ikutemaꞌ a reu. Boe ma mana foo sira rafafada aoꞌ rae, “Ae! Mai ita leo Betlehem teu dama Anaꞌ ria dei! Huu fo Manetualain haitua fee ita tutuiꞌ ria so.” ");
INSERT INTO rgu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Boe ma ara ralale de leo Betlehem reu. Ara raneta ro Maria no Yusuf. Sira boe rita Ana bokibeuꞌ, fo napeuꞌ nai haꞌo banda daleꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ara rita Anaꞌ ria, boe ma tui basa-basan rae, “Bisinaꞌ a Manetualain eilaꞌo-limalope nara reme nusatetu-ikutemaꞌ a mai rafada ami laꞌeneuꞌ Anaꞌ ia so!” ");
INSERT INTO rgu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Basa lahenda ra ramanene mana foo sira tutui nara, roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tehuu Maria napeda basa mana dadiꞌ sira, neuꞌ dale na. Ma ana dodoo neuꞌ dale na fo nau bubuluꞌ ria sosoa na nae ubeaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Basa boe ma mana foo sira fali seluꞌ reu dama bibi nara. Ara io-oa Manetualain nade Na. Ma ara hule makasi neuꞌ Ana, nana huu hihii-nanauꞌ fo ramanene ma rita ni a, natetu no Manetualain eilaꞌo-limalope nara nafafadan. ");
INSERT INTO rgu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Boki basa faiꞌ falu, boe ma ara sunat Ana bokibeuꞌ ria, tuka baꞌi Musa atoran a. Boe ma ina-ama nara feen nade, ‘Yesus’. Nadeꞌ ria nana, tepoꞌ fo mama na bei ta nairu Ni fa, te eilaꞌo-limalope neme nusatetu-ikutemaꞌ a mai, nafada memaꞌ nadeꞌ ria so. ");
INSERT INTO rgu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hapu baꞌi Musa atoran esa nae, inaꞌ fo boki basa faiꞌ haa hulu, sona muste reu tao tuka hadas makamoi aoꞌ a nai Uma Mamaso Ina. No ria na, ara bisa masoꞌ leo uma mamasoꞌ daleꞌ reu sama leoꞌ bale-bale. Huu ria na Yusuf no Maria leo kota Yerusalem reu, ela tao tuka hadas ria. De ara roo sira Ana bokibeun ria leo Uma Mamaso Ina daleꞌ neuꞌ, fo fee henin dadi neuꞌ Manetualain nun. ");
INSERT INTO rgu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sira boe tuka Manetualain atoran a nae, “Basa inaꞌ fo boki na ana uluꞌ a, kalu touꞌ, sona muste fee heni anaꞌ ria ela dadi neuꞌ Manetualain nuun.” ");
INSERT INTO rgu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tuka Manetualain atoran na, kalu fee heni anaꞌ ria leo Manetualain neu, sona ina-ama nara muste fee tutunu-hohotuꞌ manupui kateu pasang esa, do kalasi anatenaꞌ dua. Huu ria de Yusuf no Maria tao tuka atoran ria boe. ");
INSERT INTO rgu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Tepoꞌ ria, hapu tou lasiꞌ esa, nade Simeon, leo nai kota Yerusalem. Ria nana lahenda dale roo-tetuꞌ, ma nahiiꞌ na Manetualain seli. Manetualain Dula-dale Malalao-malalafu Na nafada ni so nae, neuꞌ ko ana nita Kristus dei, besaꞌ ko mate ni. Kristus nana manasoi-manatefa lahenda Israel ara. ");
INSERT INTO rgu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tepoꞌ ria, Manetualain Dula-dale Na noo Simeon leo Uma Mamaso Ina a neu. Laꞌe fai ria boe, Yesus ina-ama nara roo Ni leo naꞌ neu, fo fee henin dadi neuꞌ Manetualain nuun. ");
INSERT INTO rgu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tou lasi Simeon a nita Anaꞌ ria, de oꞌo nan, boe ma ana io-oa neuꞌ Manetualain nae, ");
INSERT INTO rgu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Io-oa Manetualain! Manetualain tao tuka hehelu Na neuꞌ au so. De besaꞌ ia, Ana bisa poꞌi na au so, fo ela au mate no tesatei-tamadaleꞌ, ");
INSERT INTO rgu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","nana huu au ita Lahenda fo Manetualain feen mai so, ela soi-tefa na ami meme sala-sikoꞌ a mai! ");
INSERT INTO rgu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Manetualain nau pake Anaꞌ ia fo fee basa nusaꞌ a sodaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ria neuꞌ ko sama leoꞌ makaledoꞌ a, fo neni hada-horomata fee Manetualain lahenda Israel nara. Ria sama leoꞌ makaledoꞌ a boe, fo natudu Manetualain eno na fee basa nusa fekeꞌ ara.” ");
INSERT INTO rgu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yusuf no Maria, ramanene tou lasi Simeon a dedea nae leoꞌ na laꞌeneuꞌ sira Ana na, boe ma roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Basa boe ma, Simeon dedea fee si ua-naleꞌ. Ana nafada Maria nae, “Yesus maman, ee! Neuꞌ ko lahenda dodouꞌ rai Israel tipa heni Anam ia. Tehuu sira nonoi-tatao nara neuꞌ Ana, neuꞌ ko natuda seluꞌ asa. Anam ia, boe tao na lahenda dodouꞌ dale nara ramahoꞌo-ratadale. ");
INSERT INTO rgu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No ria na, neuꞌ ko Manetualain buka lahenda ra dale nara reu loan. Tehuu Maria, o neuꞌ ko hapu doidoso mabera a, sama leoꞌ tafaꞌ a pau losa ate-baa mi.” ");
INSERT INTO rgu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nai Uma Mamaso Ina a boe hapu ina lasiꞌ esa, nade Hana. Teu ni falu hulu haa so. Papa na nade Fanuel, neme Aser leo na mai. Ana sao teuꞌ hitu, boe ma saotou na mate ni de mesaꞌ ana. Besaꞌ Hana nana Manetualain mana nesi matan. Nonoi na, riꞌ hule-haradoi ma puasa nai Uma Mamaso Ina a, fo hatu-leledon doꞌo-tabe neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Fai fo Simeon dedea no Yusuf ma Maria, besaꞌ Hana naneneaꞌ leo mata neu, de namanene si. Boe ma ana io-oa neuꞌ Manetualain. Ana nafada neuꞌ lahenda kadodouꞌ fo rahani Kristus mamai Na. Ana nae, Ana ria nana Kristus, Maneꞌ fo riꞌ Manetualain helu basa neuꞌ ko poꞌi-tata na lahenda Israel ara. ");
INSERT INTO rgu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tepoꞌ fo Yusuf no Maria tao ratetu baꞌi Musa atoran ara katemaꞌ nai kota Yerusalem, boe ma ara fali leo sira koro Nasaret na reu, nai propinsi Galilea. ");
INSERT INTO rgu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yesus nambau-ina, boe ma Ana tamba mapii-baraꞌaiꞌ, malelaꞌ, ma bubuluꞌ hihii-nanauꞌ dodouꞌ. Huu fo Manetualain natudu dale malole Na neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tuka-tuka teuꞌ, Yusuf no Maria leo kota Yerusalem reu, fo raa feta Paska nai na. ");
INSERT INTO rgu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tepoꞌ fo Yesus teun sanahulu dua, faiꞌ esa boe ma ara leo Yerusalem reu belaꞌ a, fo raa feta sama leoꞌ bale-bale. ");
INSERT INTO rgu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Fai Paska a basa ni, boe ma Yusuf no Maria fali Nasaret reu sama-sama ro lahenda kadodou inaꞌ fo nau fali leo Galilea reu a. Tehuu ara ta bubuluꞌ, rae foa ela Yesus nai Yerusalem. Ara raendobuko Ana laꞌo sama-sama no tia-lai nara. Tehuu losa ledo leodae na, ara ta rita Ni fa. Boe ma ara mulai saka Ni reu-mai nai kileoboboki a ma tia-lai nara. ");
INSERT INTO rgu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Huu no ta raneta roon fa, boe ma ara ratafali reu saka Ni nai Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ara saka Ni nai na losa faiꞌ telu, besaꞌ ko raneta roon nai Uma Mamaso Ina daleꞌ. Ana natuuꞌ natatane aoꞌ no mesen agama Yahudi ra. ");
INSERT INTO rgu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Basa lahenda fo ramanene Ni a roi ramakokoaꞌ a, huu fo Ana bubuluꞌ matetuꞌ Susura Makamoiꞌ a isi na, ma Ana bisa nataa sira natatane nara no malole. ");
INSERT INTO rgu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ina-ama nara rita leoꞌ na, boe ma roi ramakokoaꞌ a. Boe ma mama Na nae, “Yesus! Ubeaꞌ taon de O tao masususaꞌ ami leoꞌ ia? Au oo papa ma laka mara dile meu-mai saka O!” ");
INSERT INTO rgu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tehuu Yesus nataa si nae, “Ubeaꞌ taon de mama ka mo papa ka sota maan seli saka Au? Mama ka mo papa ka ta bubuluꞌ fa? Au aparasa nai Au Amak Uman daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tehuu ara ta bubuluꞌ matetuꞌ Ria dedea Na sosoa-raraan fa. ");
INSERT INTO rgu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Boe ma basa si fali Nasaret reu. Yesus tuka ina-ama nara pareta na. Ma mama Na napeda basa hihii-nanauꞌ sira reuꞌ dale na. ");
INSERT INTO rgu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus boe-boe nambau-ina, ma tamba rolu-malelaꞌ. Manetualain ma lahenda dae-bafoꞌ a boe sue Ni. ");
INSERT INTO rgu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tepoꞌ fo, Tiberius dadi keser, ana pareta teu kasanahulu lima na nai Roma, ria te Pontius Pilatus dadi gubernor nai propinsi Yudea. Herodes dadi gubernor nai propinsi Galilea. Herodes aꞌan Filipus dadi gubernor nai propinsi Iturea no Trakonitis. Ma Lisanias dadi gubernor nai propinsi Abilene. Tepoꞌ ria boe Hanas no Kayafas dadi malaka agama bau-ina fee malaka agama Yahudi nai kota Yerusalem. Tepoꞌ ria riꞌ Manetualain nalosaꞌ Hara-dasin neuꞌ Yohanis, Sakaria ana na nai mamana lino-nees. ");
INSERT INTO rgu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanis namanene nan, boe ma ana laꞌo leo basa koroꞌ fo raneneaꞌ ro lee Yarden, de nafada lahenda ra nae, “Emi muste saledale-tuꞌetei mara, ela Manetualain sae-safe heni emi sala-sikom. Basa nana emi muste sarani dei, fo dadi tanda nae, emi malole mo Manetualain so.” ");
INSERT INTO rgu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Fai a ulu na, Manetualain mana nesi matan baꞌi Yesaya duiꞌ laꞌeneuꞌ Yohanis ia nae, “Hapu lahenda nai mamana lino-nes de bobouꞌ nae, ‘Basa lahenda ra mahehere ao mara sadia enoꞌ, fo sipoꞌ Ramatuaꞌ a mamai na! Enoꞌ pekoꞌ a taon dadi roos fo sipoꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bafaꞌ bea na pori matetun. Leteꞌ bea na ali matetun. Eno peko-pakiꞌ ara tao si dadi roos, enoꞌ boboloꞌ ara pori matetuꞌ si. ");
INSERT INTO rgu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ela lahenda reme basa nusaꞌ ara mai bisa bubuluꞌ rae, Manetualain nau soi-tefa lahenda reme sala-siko nara mai.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lahenda dodouꞌ reme basa mamanaꞌ ara mai hule Yohanis fo sarani si. Tehuu ana nasapaa si nae, “Ae! Maedi-mafuleꞌ emin! Emi sama leoꞌ meke maꞌaaꞌ! Mana saledale-tuꞌetei fufudiꞌ emin, boso mae emi lui meme Manetualain huhuku Na mai. Ta dooꞌ a soꞌ, te Manetualain huku lahenda fo ta saledale-tuꞌetein matetuꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bosoꞌ emi afi mae, ‘emi nana baꞌi Abraham tititi-nonosin’. Duduꞌa-aafi sira ta bisa tulu-fali emi, nana huu ta bisa tao malalao-malalafuꞌ emi fa. Manetualain bisa adu na batu ia ra dadi reuꞌ baꞌi Abraham tititi-nonosin. Au afada emi! Matudu nai leleo-lalaꞌom mae, emi saledale-tuꞌetei mara de tuka Manetualain so. ");
INSERT INTO rgu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Emi muste tao hihii-nanauꞌ malole. Taꞌa, sona Manetualain huku emi beraꞌ a, sama leoꞌ lahenda loꞌo heni ai huuꞌ a neme oka na mai, pake taꞌa. Ai huuꞌ fo ta neni buna-boa malole, sona sosoa-raraaꞌ taꞌa. De, malole lenaꞌ loꞌo henin fo tuꞌun leo ai-pilaꞌ daleꞌ neu.” ");
INSERT INTO rgu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Boe ma, lahenda kadodou inaꞌ sira ratane Yohanis rae, “De, ami muste tao ubeaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ana nataa nae, “Maneniko o manuu badu dua, sona fee esa leo lahenda fo ta nanuu badu fa. Maneniko o hapu nanaaꞌ, sona bati fee lahenda fo ta nanuu nanaaꞌ fa.” ");
INSERT INTO rgu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Basa de, mana susu bea ra mai boe, fo hule Yohanis sarani si. Ara ratane rae, “Papa mesen! Ami muste tao ubea?” ");
INSERT INTO rgu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana nataa nae, “Kalu mana pareta raetuꞌ ra raun ara doi bea na hida, sona ara bae tuka ria.” ");
INSERT INTO rgu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hapu soldadu hida rai na boe. Ara ratane Yohanis rae, “Kalu ami, leo beaꞌ? Ami muste tao ubeaꞌ?” Ana nataa nae, “Bosoꞌ masalaꞌo kokose lahenda doi-talin tuka emi hihii mara. Ma bosoꞌ mafararaꞌu kolaaꞌ lahenda. Emi muste hule makasi ma sipo noi kadi mara, ria dai so.” ");
INSERT INTO rgu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ramanene dedean sira, boe ma lahenda ra mulai esa dukuꞌ esa rae, “Ae! Bate Yohanis ia nana, Kristus, fo neme uluꞌ mai Manetualain helu nae fee Ni mai a!” ");
INSERT INTO rgu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tehuu Yohanis nasaꞌai si nae, “Nenene matalolole! Neuꞌ ko Lahenda esa mai kuasa Na lena au. Leo mae au dadi uꞌ Ria atan boe, ta araa fa. Au sarani emi pake oe, tehuu neuꞌ ko Ana tao lena au, huu fo tao na henu emi dale mara neniꞌ Manetualain Dula-dale Malalao-malalafu Na. Neuꞌ ko Ana tao makamomoi emi, sama leoꞌ lahenda hotu heni kadafuꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana huku lahenda mana tao salaꞌ ara, sama leoꞌ lahenda mana oru a teeꞌ heni hade a kikili-kauan. Basa nate Ana nadai hade neuꞌ ara, reuꞌ soꞌa ra daleꞌ, tehuu hotu heni kikili-kauan. Leoꞌ na boe, neuꞌ ko Kristus huku lahenda mana tao salaꞌ ara, ma tuꞌu si leo aipila mana basa taꞌa daleꞌ reu.” ");
INSERT INTO rgu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","No ria na, Yohanis fee nafarereneꞌ lahenda ra hihii-nanauꞌ rupaꞌ, ma tui si Manetualain Tutui Malole Na. ");
INSERT INTO rgu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Tepoꞌ ria boe, Yohanis mulai dedea lelekaꞌ laꞌeneuꞌ Herodes nonoi-tataon. Dedea na leo iaꞌ: Herodes nana gubernor nai propinsi Galilea. Ria sala na dodouꞌ. Leo-leoꞌ ana tonda na fadi na sao ina na, nade Herodias. Sekonaa te, fadi na bei nasoda, ma bei ta namaetuꞌ no Herodias fa. Herodes leleo-lalaꞌon ta laꞌe fa, de Yohanis nasaꞌai lelekaꞌ ana, losaꞌ Herodes eteꞌ ao na. Boe ma Herodes hopu nan, de tee ni leo bui daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Maꞌulu na, tepoꞌ fo bei ta hopu ra Yohanis fa, ana sarani lahenda dodouꞌ. Ma ana sarani Yesus boe. Basa ria de Yesus hule-haradoi, boe ma lalai natahuꞌa. ");
INSERT INTO rgu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tutiꞌ a Manetualain Dula-dale Malalao-malalafu Na onda neuꞌ Ana. Dula-daleꞌ ria rupa na sama leoꞌ manupui kalasi a. Boe ma hara oeꞌ esa neme lalai mai nae, “O nana Au Ana susue Ka. O tao ma Au amahoꞌo naroo.” ");
INSERT INTO rgu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tepoꞌ fo Yesus mulai nafada lahenda ra laꞌeneuꞌ Manetualain eno masoda na, nana teu Ni bate telu hulu. Lahenda ralelaꞌ rae, Yesus nana Yusuf Anan. Yusuf bei-baꞌi nara siiꞌ: Yusuf papa na riꞌ, Eli. ");
INSERT INTO rgu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli papa na riꞌ, Matat. Matat papa na riꞌ, Lewi. Lewi papa na riꞌ, Melki. Melki papa na riꞌ, Yanai. Yanai papa na riꞌ, Yusuf. ");
INSERT INTO rgu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf papa na riꞌ, Matatias. Matatias papa na riꞌ, Amos. Amos papa na riꞌ, Nahum. Nahum papa na riꞌ, Hesli. Hesli papa na riꞌ, Nagai. ");
INSERT INTO rgu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai papa na riꞌ, Maat. Maat papa na riꞌ, Matatias. Matatias papa na riꞌ, Semein. Semein papa na riꞌ, Yosek. Yosek papa na riꞌ, Yoda. ");
INSERT INTO rgu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda papa na riꞌ, Yohanan. Yohanan papa na riꞌ, Resa. Resa papa na riꞌ, Serubabel. Serubabel papa na riꞌ, Sealtiel. Sealtiel papa na riꞌ, Neri. ");
INSERT INTO rgu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri papa na riꞌ, Melki. Melki papa na riꞌ, Adi. Adi papa na riꞌ, Kosam. Kosam papa na riꞌ, Elmadam. Elmadam papa na riꞌ, Er. ");
INSERT INTO rgu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er papa na riꞌ, Yosua. Yosua papa na riꞌ, Elieser. Elieser papa na riꞌ, Yorim. Yorim papa na riꞌ, Matat. Matat papa na riꞌ, Lewi. ");
INSERT INTO rgu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi papa na riꞌ, Simeon. Simeon papa na riꞌ, Yahuda. Yahuda papa na riꞌ, Yusuf. Yusuf papa na riꞌ, Yonam. Yonam papa na riꞌ, Elyakim. ");
INSERT INTO rgu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim papa na riꞌ, Melea. Melea papa na riꞌ, Mena. Mena papa na riꞌ, Matata. Matata papa na riꞌ, Natan. Natan papa na riꞌ, Daud. ");
INSERT INTO rgu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud papa na riꞌ, Isai. Isai papa na riꞌ, Obet. Obet papa na riꞌ, Boas. Boas papa na riꞌ, Salmon. Salmon papa na riꞌ, Nahason. ");
INSERT INTO rgu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason papa na riꞌ, Aminadab. Aminadab papa na riꞌ, Admin. Admin papa na riꞌ, Arni. Arni papa na riꞌ, Hesron. Hesron papa na riꞌ, Peres. Peres papa na riꞌ, Yahuda. ");
INSERT INTO rgu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda papa na riꞌ, Yakob. Yakob papa na riꞌ, Isak. Isak papa na riꞌ, Abraham. Abraham papa na riꞌ, Tera. Tera papa na riꞌ, Nahor. ");
INSERT INTO rgu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor papa na riꞌ, Seruk. Seruk papa na riꞌ, Rehu. Rehu papa na riꞌ, Pelek. Pelek papa na riꞌ, Eber. Eber papa na riꞌ, Sela. ");
INSERT INTO rgu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela papa na riꞌ, Kenan. Kenan papa na riꞌ, Arpaksad. Arpaksad papa na riꞌ, Sem. Sem papa na riꞌ, Noh. Noh papa na riꞌ, Lamek. ");
INSERT INTO rgu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek papa na riꞌ, Metusalak. Metusalak papa na riꞌ, Henok. Henok papa na riꞌ, Yared. Yared papa na riꞌ, Mahalalel. Mahalalel papa na riꞌ, Kenan. ");
INSERT INTO rgu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan papa na riꞌ, Enos. Enos papa na riꞌ, Set. Set papa na riꞌ, Adam. Adam nana, riꞌ Manetualain ana aadu Na. ");
INSERT INTO rgu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yohanis sarani basa Yesus, boe ma Yesus laꞌo ela lee Yarden a. Manetualain Dula-dale Malalao-malalafu Na sama-sama no Ni. Basa boe ma Dula-daleꞌ ria noon leo mamana lino-nes a neu. ");
INSERT INTO rgu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus leo nai na losa faiꞌ haa hulu. Tepoꞌ ria ta naa-ninu hata esa boeꞌ, losa Ana namalaa naan seli. Boe ma malaka nitu mai soba Ni. ");
INSERT INTO rgu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana nafada Yesus nae, “Kalu tetebes ara O ia nana Manetualain Anan, O manuu kuasa. De, bisa mafada batu ia ra dadi roti, fo mua.” ");
INSERT INTO rgu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tehuu Yesus nataa ni nae, “O ta mae tao boeꞌ ma! Ta bubuluꞌ fa do? Mana duiꞌ nai Susura Makamoiꞌ daleꞌ nae, ‘Lahenda dae-bafoꞌ a nasoda, nana ta noi neme nanaa-nininuꞌ a mai fa.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Basa boe ma malaka nitu a noo Yesus leo mamana madema esa neu, de natudu Ni basa mane dae-bafoꞌ a nusa-namon. Ana nafada Yesus nae, “Basa kuasa sira ro marela-masaꞌan nana au nuu ki. De, au anuu hak ae fee bea boe neme au hihii ka mai. ");
INSERT INTO rgu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Au nau fee O katemaꞌ asa. Tehuu O muste tao hihii-nanauꞌ esa dei, besaꞌ ko au fee. Mudaꞌ lai esaꞌ! O doꞌo-tabe neuꞌ au. Noi ri naꞌ so!” ");
INSERT INTO rgu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tehuu Yesus nataa ni nae, “Hapun nai bea leo naꞌ? Huu fo mana duiꞌ nai Susura Makamoiꞌ daleꞌ nae, ‘O muste doꞌo-tabe noi neuꞌ Manetualain. Ma o muste malalau Ni.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Basa ria, boe ma malaka nitu noo Yesus leo kota Yerusalem a neu. Nai na, ana noo Yesus leo Uma Mamaso Ina a puni na lain neu. Boe ma ana nae, “Maneniko tebe-tebe O nana Manetualain Anan, sona parbokuꞌ daeꞌ mu leo! ");
INSERT INTO rgu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Huu fo mana duiꞌ nai Susura Makamoiꞌ daleꞌ nae, ‘Manetualain neuꞌ ko nadenu eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai, fo ranea O. ");
INSERT INTO rgu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Neuꞌ ko ara ratanee ra O, fo ela O ei ma ta tetaꞌ laꞌe batu ria baiꞌ boeꞌ.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tehuu Yesus nataa ni nae, “Mana duiꞌ nai Susura Makamoiꞌ daleꞌ nae, ‘Bosoꞌ soba neuꞌ Manetualain!’ ” ");
INSERT INTO rgu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Malaka nitu soba Yesus neniꞌ eno rupaꞌ ara, tehuu ta nala Ni fa. Basa boe ma ana foa ela Yesus, fo nahani ledo-fai malole. ");
INSERT INTO rgu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Huu no Manetualain Dula-dale Malalao-malalafu Na kuasan, boe ma Yesus fali leo propinsi Galilea neu. Ta doo bea boeꞌ te, Yesus nade Na tui-bekan rule-feo nusaꞌ ria, de lahenda ra bubuluꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana nanori-nafada nai lahenda Yahudi ra uma mamaso nara katemaꞌ. Boe ma ara io Ni rae, “Yesus nana Mana kuasa!” ");
INSERT INTO rgu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Laiꞌ esa de, Yesus leo koro Nasaret na mai. Laꞌe fai lahenda Yahudi ra fai huhule-haradoin, riꞌ ‘fai Sabat’, Ana leo uma mamasoꞌ daleꞌ neu, sama leoꞌ Ria biasa na. Basa de Ana foa napadeiꞌ fo nau lees neme Manetualain Susura Makamoiꞌ na mai. ");
INSERT INTO rgu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Boe ma ara fee Ni baꞌi Yesaya dudui na. Ana buka ni, de lees nai lalaneꞌ fo mana duiꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Manetualain Dula-dale Na kuasa Na nai Au. Huu ria na Ana tudu na Au, fo tui-beka Manetualain Tutui Malole Na neuꞌ lahenda manatoꞌa-manataꞌ ara. Ana nadenu Au, ela tui-beka ae, neuꞌ ko poꞌi mana hukuꞌ ara; neuꞌ ko pokeꞌ ara rita dae; neuꞌ ko poꞌi mana hapu eese-rurumuꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma besaꞌ ia losa Ramatuaꞌ ledo-fain, fo soi-tefa lahenda Nara.” ");
INSERT INTO rgu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus lees basa duduiꞌ ria, boe ma lulu faliꞌ ana de loo ni leo mana tao mamasoꞌ a neu, boe ma Ana natuuꞌ. Basa lahenda fo rai uma mamasoꞌ ria daleꞌ mete rahere Ni. ");
INSERT INTO rgu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Boe ma Ana nafada si nae, “Hata fo bisinaꞌ a emi mamanene ni neme Susura Makamoiꞌ a mai a, besaꞌ ia dadi so!” ");
INSERT INTO rgu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Basa lahenda fo rai na, mulai io Yesus rae, “Ae! Hata fo bisinaꞌ a Ana dedea ni a, malole na seli! Tehuu Ria nana, Yusuf anan, hete? Ubeaꞌ taon de bisa leo naꞌ?” ");
INSERT INTO rgu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Boe ma Yesus nafada si nae, “Tantu emi basa moi taoꞌ Au meniꞌ dedeaꞌ lasiꞌ a nae, ‘Dokter! Puli-mamodo ma ao-ina heheli ma dei! Ubeaꞌ taon de O ta tao tanda heran esa fee ami nai ia boeꞌ, sama leoꞌ O tao nai kota Kapernaum a?’ ");
INSERT INTO rgu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Matetu na leo iaꞌ: lahenda ta nau sipoꞌ Manetualain mana nesi matan nai ria koro-tadun fa. ");
INSERT INTO rgu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Hai natutuduꞌ neme Manetualain mana nesi matan, baꞌi Elia. Laiꞌ esa de uda a ta mai fa teuꞌ telu seseriꞌ. Tepoꞌ ria ina-falu dodouꞌ rai Israel. Tehuu Manetualain ta fee Elia neu tulu-fali lahenda Israel ara. Manetualain fee ni leo ina-falu esa neu, nai koro Sarfat naneneaꞌ kota Sidon. Sekonaa te inaꞌ ria, lahenda ta Yahudi fa. Tehuu ana namahere neuꞌ Manetualain kuasa Na. ");
INSERT INTO rgu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hai natutuduꞌ fekeꞌ neme Manetualain mana nesi matan Elisa mai. Tepoꞌ ria, lahenda Yahudi dodouꞌ ramahedi hedi kusta rai Israel. Tehuu Manetualain ta puli na si fa. Ana nadenu noi Elisa puli na lahenda kamahedi kusta esa, nade Naaman. Sekonaa te, ria nana lahenda Siria, ta Yahudi fa. Tehuu ana namahere neuꞌ Manetualain kuasa Na.” ");
INSERT INTO rgu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bei ramanene Yesus dedea nae leoꞌ na, boe ma basa si nasa nara lua. ");
INSERT INTO rgu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Boe ma ara foa belaꞌ a, de usi heni Ni neme uma mamasoꞌ daleꞌ mai. Tutiꞌ a hela roo Ni leo koroꞌ a suu-dea neu, fo nau ruan leo pere daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tehuu Ana kalua laꞌo nesiꞌ lahenda kadodouꞌ sira talada, de foa ela si reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Basa ria, boe ma Yesus onda leo Kapernaum neu, nai dano Galilea a suu na. Tuka-tuka fai huhule-haradoiꞌ, Ana nanori lahenda rai uma mamasoꞌ daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Lahenda ra roi ramakokoaꞌ a ramanene dedea-nafada Ni, huu fo Ana bubuluꞌ matetuꞌ nanoriꞌ ria isi na. ");
INSERT INTO rgu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laiꞌ esa de, Yesus nanori nai uma mamasoꞌ daleꞌ, hapu lahenda nitu hekeꞌ esa mulai naloo namberaina nae, ");
INSERT INTO rgu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae! Yesus, Lahenda Nasaret! O nau tao ubeaꞌ mo ami! O nau mai tao malulutuꞌ ami, do? Ami malelaꞌ O, nana Lahenda Malalao-malalafuꞌ fo fai a ulu na Manetualain helu nae fee Ni mai.” ");
INSERT INTO rgu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tehuu Yesus nasapaa ni nae, “Maꞌauꞌ bafa ma! Kalua meme lahenda ria mai!” Kekeneu te nitu a lokopiro lahenda ria neuꞌ daeꞌ, nai lahenda ra talada. Basa boe ma ana foa ela ni, ma ta nahehediꞌ ana soꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Basa lahenda ra roi ramakokoaꞌ a rae, “Heran lai esaꞌ! Lahenda ia dedea Na, nanuu kuasa bauinaꞌ! Losaꞌ nitu ra biin, de kalua reme lahenda ria mai!” ");
INSERT INTO rgu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Boe ma tutuiꞌ laꞌeneuꞌ Yesus, mulai tui-bekan nai nusaꞌ ria katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Faiꞌ fo ara kalua reme uma mamasoꞌ ria mai, boe ma Yesus leo Simon uma na neu. Simon arina na namahedi ao luumaiꞌ a, de ao-ina na nanaa na seli. Boe ma ara hule Yesus rae, “Ramatuaꞌ! Puli ma ina lasiꞌ a dei!” ");
INSERT INTO rgu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus neu de napadei neuꞌ koi a suu na, boe ma usi heni ina lasiꞌ a ao luumai na. Hatemataꞌ ria boe, inaꞌ a ao luumai na mopoꞌ ana. Boe ma ana foa, de neu sadia nanaaꞌ fee si. ");
INSERT INTO rgu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ledo a sakaꞌ tena, boe ma lahenda ra roo basa kamahedis ara leo Yesus reu. Hedi nara rupaꞌ ara. Boe ma Ana fua lima Na neuꞌ lahenda kamahedis ara de puli na katemaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Lahenda kamahedis sira, ruma nitu hekeꞌ ara. De, Yesus pareta nitu ra fo kalua remeꞌ lahenda sira mai. Ara kalua ma bobouꞌ rae, “O nana Manetualain Anan!” Huu fo nitu sira bubuluꞌ rae, Ria nana Kristus, fo neme fai a ulu na mai Manetualain helu nae fee Ni mai. Huu ria na, Yesus nasaꞌai si fo ta bole dedea hata esa laꞌeneuꞌ Ao-ina Na boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Balahaꞌ dulupila na, boe ma Yesus foa de leo mamana lino-nees esa neu, nai kota a deaꞌ. Lahenda ra saka raleleiꞌ Ana. Ara raneta ron, boe ma leleꞌo Ni rae, “Papa leo mo ami! Bosoꞌ leo mamana fekeꞌ mu bali!” ");
INSERT INTO rgu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tehuu Ana sipoꞌ asa nae, “Au muste leo koro fekeꞌ ara uu, fo tui-beka Tutui Malole laꞌeneuꞌ Manetualain pareta Na. Huu fo Manetualain nadenu Au uu alalaꞌo nonoi lakaꞌ ria.” ");
INSERT INTO rgu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Boe ma Ana laꞌo neme koroꞌ esa mai leo koroꞌ esa neu, fo nanori-nafada nai uma mamasoꞌ ara nai propinsi Yudea. ");
INSERT INTO rgu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Laiꞌ esa de Yesus nanori lahenda ra nai dano Galilea a suu na. Lahenda dodouꞌ mai fo nau nenene Manetualain Hara-dasin, losaꞌ ara raseseti ao, eo ra Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naneneaꞌ nai na hapu manadolu-manadala hida, rahii dala nara rai madaꞌ lain. Yesus nita ofaꞌ rouꞌ dua mana nafuꞌ rai na. ");
INSERT INTO rgu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Neme ofa kaduaꞌ sira mai, nana Simon nuun esa. Boe ma Yesus ae leo Simon ofan lain neu, Ana hule si fo tipa ofaꞌ a leo oe demaꞌ a neu. Boe ma Ana natuuꞌ de nanori-nafada lahenda kadodou inaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nanori basa, boe ma Ana nafada Simon nae, “Simon! Tuluꞌ leo mamanaꞌ fo oe na demaꞌ a seluꞌ baiꞌ, fo poꞌi pukaꞌ a neuꞌ na. Huu fo neuꞌ ko emi hapu ikaꞌ dodouꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon sipoꞌ nae, “Ramatuaꞌ! Ami puka hatuꞌ esa katemaꞌ, tehuu ta hapu ikaꞌ boaꞌ esa boeꞌ! Neu, Ramatuaꞌ mafada de au poꞌi seluꞌ pukaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Boe ma ara poꞌi pukaꞌ a. Ara sakaꞌ hela faliꞌ ana leo lain mai, te pukaꞌ ria ikaꞌ henun, losaꞌ kura baiꞌ sii heni pukaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Boe ma Simon naloo nonoo nara reme ofa fekeꞌ mai fali si. Ara poꞌa rahenu ofa kaduaꞌ sira ikaꞌ, de hisadeina ara bolo. ");
INSERT INTO rgu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Sabadeus anan Yakobis no Yohanis, fo Simon nonoo manadolu-manadalan rai na boe. Ara heran raan seli, huu fo ara hapu ikaꞌ dodouꞌ. Simon Petrus bei nita mana dadiꞌ ria, tutiꞌ a sundaꞌ undulaka na neuꞌ Yesus mata Na nae, “Au nana lahenda masala-masikoꞌ. De, malole lenaꞌ Ramatuaꞌ *a bosoꞌ maneneaꞌ mo au bali.” Tehuu Yesus nataa nae, “Simon! Bosoꞌ mae leoꞌ na, emi biasa puka ikaꞌ, tehuu besaꞌ ia Au anori emi saka lahenda fo tuka Au.” ");
INSERT INTO rgu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","No besaꞌ ria boe, hela sira ofa na leo madaꞌ lain neu. Boe ma ara foa ela basa-basan, de tuka Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nai koroꞌ esa, Yesus naneta no lahenda esa ao-ina na hedi kusta mesan. Ana nita Yesus, boe ma sundaꞌ undulaka na losaꞌ mata-idun neta dae neuꞌ Yesus matan. Ana nae, “Ramatuaꞌ! Kalu nau, sona tulu-fali au dei! Huu fo au bubuluꞌ, Ramatuaꞌ bisa puli ma au hedi ka, ela bosoꞌ lahenda rahiaꞌ au.” ");
INSERT INTO rgu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Boe ma Yesus looꞌ lima Na neu de nafaroe lahenda ria, ma Ana dedea nae, “Au nau! O teꞌe ma aom leo!” Hatemataꞌ ria boe, lahenda ria hedi kusta na mopoꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Boe ma Yesus horo ni nae, “Mafarereneꞌ matalolole! O teꞌe ma aom so, tehuu ta bole tutui esa boeꞌ! O muste tuka baꞌi Musa pareta na dei. De, leo malaka agama a muu, fo ana parisaꞌ ao-ina ma, ela ana bubuluꞌ nae, tebe teꞌe ma aom so, do beiꞌ. Ma o muste fee tutunu-hohotuꞌ tanda makasi, fo basa lahenda ra bubuluꞌ rae, o teꞌe ma oam matetuꞌ so.” ");
INSERT INTO rgu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Leo mae Yesus horo, tehuu tutuiꞌ laꞌeneuꞌ Ria kuasa Na, tui-bekan nai basa mamanaꞌ ara. De lahenda ra roi faa-faaꞌ a mai, ela ramanene Ana nanori-nafada si. Ma Ana puli na lahenda reme hedi rupa nara mai. ");
INSERT INTO rgu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tehuu Yesus heoꞌ neme lahenda kadodou inaꞌ sira mai, fo neu hule-haradoi nai mamana lino-nes. ");
INSERT INTO rgu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Laiꞌ esa de, Yesus nanori-nafada nai uma esa. Fai ria, sira lahenda agama Farisi ma mesen agama ra mai, fo nenene neuꞌ Ana. Ara reme basa koroꞌ nai propinsi Galilea, no propinsi Yudea ma reme kota Yerusalem mai. Manetualain fee Yesus kuasa fo puli na lahenda kamahedis ara. ");
INSERT INTO rgu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Fai ria, lahenda hida rolo reni lahenda lukuꞌ esa nai tandu, leo Yesus neu ela puli nan. Tehuu uma ria nakaseke no lahenda, de ara ta bisa masoꞌ leo daleꞌ reu fa. Huu ria na, ara saka enoꞌ de ae roo lukuꞌ ria leo uma a puni na neu. Boe ma ara fate boloꞌ, ela raꞌonda lahenda lukuꞌ ria no tandu na leo daeꞌ neu. Ara raꞌonda ni, nai lahenda kadodou inaꞌ sira talada, naraa no Yesus mata Na. ");
INSERT INTO rgu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus nita leoꞌ na, boe ma Ana bubuluꞌ nae, ara ramahere Ni bisa puli na sira nonoon ria. Boe ma Ana nafada lahenda lukuꞌ ria nae, “Ana ki on! Au sae-safe heni o sala-sikom so.” ");
INSERT INTO rgu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lahenda Farisi ra roo mesen agama ra ramanene Yesus dedea nae leoꞌ na, boe ma esa nafada esa rae, “Ae! Noi Manetualain riꞌ nanuu hak fo sae-safe heni lahenda sala-sikon. Te lahenda ia nana bea, de tao aon sama leoꞌ Manetualain! Namumulu-namamae bauinaꞌ ia!” ");
INSERT INTO rgu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tehuu Yesus bubuluꞌ sira duduꞌa-aafin. Boe ma Ana dedea nae, “Ubeaꞌ taon de emi duꞌa-afi nai dale mara mae Au amumulu-amamaeꞌ? ");
INSERT INTO rgu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Matetu na riꞌ ubeaꞌ? Maneniko Au afada lahenda lukuꞌ ia ae, ‘Au fee ampon neuꞌ o sala-sikom,’ do afada ae, ‘foa fo laꞌo leo!’ Maneniko ana foa fo laꞌo, sona besaꞌ ko emi mita buti mae Au, Ana Lahenda. Te Au anuu kuasa fee ampon neuꞌ lahenda sala-sikon.” Boe ma Ana nafada lahenda lukuꞌ ria nae, “Foa leo! Hai ma mamana napeu ma fo fali leo!” ");
INSERT INTO rgu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kekeneu te, lahenda ria foa napadeiꞌ neuꞌ lahenda kadodou inaꞌ sira matan, boe ma hai na mamana napeu na. Ana fali neun ma io-oa neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Basa lahenda ra rita leoꞌ na, boe ma roi ramakokoaꞌ a. Ara io-oa Manetualain nade Na rae, “Manetualain kuasa Na bauinaꞌ! Faiꞌ ia ita tita mataꞌ mana dadi bebeuꞌ!” ");
INSERT INTO rgu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Basa de, Yesus kalua neme uma ria mai, boe ma Ana nita lahenda mana susu bea esa, nade Lewi, natuuꞌ nai uma sususu bea daleꞌ. Yesus nafada ni nae, “Mai tuka Au!” ");
INSERT INTO rgu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi namanene, boe ma ana foa ela basa-basan reuꞌ na, de neu tuka Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Boe ma Lewi tao feta bauinaꞌ de naloo Yesus leo uma na neu. Ana naloo nonoo mana susu bea nara, ma lahenda fekeꞌ boe, fo mai raa feta. ");
INSERT INTO rgu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tehuu lahenda agama Farisi hida ma mesen agama ra, ramumuu neuꞌ Yesus ana mana tuka dea nara rae, “Ubeaꞌ taon de emi mia-minu sama-sama mo mana susu bea ra, ma lahenda masala-masikoꞌ ara? Lahenda roos a bosoꞌ rabua ro lahenda rupa leo naꞌ ara!” ");
INSERT INTO rgu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tehuu Yesus nafada si nae, “Tebe lahenda kamahedis a parluu dokter. Tehuu lahenda sodaꞌ a, sona ta parluu fa. ");
INSERT INTO rgu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au ta mai fo aloo-akou neuꞌ lahenda roos, tehuu Au mai soaneuꞌ lahenda masala-masikoꞌ, ela saledale-tuꞌetei nara.” ");
INSERT INTO rgu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Boe ma, lahenda agama Farisi ma mesen agama ra boe ramumuu neuꞌ Yesus rae, “Leo iaꞌ, Papa! Yohanis Mana Saraniꞌ a ana mana tuka dea nara puasa, ma hule-haradoi kose-kose. Lahenda Farisi ra ana mana tuka dea nara boe leo naꞌ. Tehuu ubeaꞌ taon de Papa ana mana tuka dea mara roi raa-rinu, raa-rinuꞌ a? Ara ta puasa ralelaꞌ fa, do?” ");
INSERT INTO rgu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tehuu Yesus sipoꞌ asa pake dedea nasasamaꞌ nae, “Emi bubuluꞌ, maneniko feta kakabiꞌ, sona fui ra ta puasa fa, tehuu ara raa-rinu rabete. Maneniko mana kabiꞌ a tou na bei sama-sama no si, tantu ara raa-rinu belaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tehuu faiꞌ esa nai na, maneniko heke reni mana kabiꞌ a tou na, sona besaꞌ ko tia-lai nara dale hedi, de ara puasa.” ");
INSERT INTO rgu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Boe ma, Yesus nafada si dedea nasasamaꞌ esa bali nae, “Ta hapu lahenda hai na posaiꞌ bebeuꞌ, fo tapa neuꞌ badu paraaꞌ a sai na fa. Huu fo neuꞌ ko safe badu ria te, posaiꞌ bebeuꞌ a leleꞌe, de badu paraaꞌ sai nan bera. ");
INSERT INTO rgu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Leoꞌ na boe, lahenda ta disi tua bebeuꞌ neuꞌ hai paraꞌ a fa. Huu fo neuꞌ ko haiꞌ ria hea ni, de nosi heni tuaꞌ a. No ria na, Yesus nanori si nae, Nanori bebeu Na, bosoꞌ rabua ni noo lahenda Farisi ra nanori paraa nara. ");
INSERT INTO rgu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lahenda fo parna ninu oe anggor paraaꞌ, ana ta nahiiꞌ ninu bebeuꞌ a fa. Huu fo ana bubuluꞌ nae, ‘Anggor fo peda ni dooꞌ a, sona malada na seli!” ");
INSERT INTO rgu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Laiꞌ esa de, laꞌe lahenda Yahudi ra fai hahae aon, Yesus no ana mana tuka dea nara laꞌo tuka lehenda oka-tinen daleꞌ. Boe ma ana mana tuka dea nara, etu ra hade gandum a pule na de raisi fo raa. ");
INSERT INTO rgu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tehuu lahenda agama Farisi fo riꞌ ta rapoꞌi hadas Yahudi, sira hida rai na de rita Yesus ana mana tuka dea nara tao leo naꞌ, boe ma rasaꞌai Ni rae, “Ubeaꞌ taon de O ana mana tuka dea mara ralena laka neuꞌ ita atoran agama na? Ara roi nonoiꞌ laꞌe fai hahae aoꞌ! Ara oru hade gandum. Ta bole leo naꞌ fa!” ");
INSERT INTO rgu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Boe ma Yesus sipoꞌ asa nae, “Emi ta lees mita baꞌi Daud tutui na fa? Fai fo no ana mana tuka dea nara ramalaa, boe ma leo bea, ana masoꞌ leo Manetualain Laa Huhule-haradoi na daleꞌ neu hai roti tutunu-hohotuꞌ fo naa, ma bati fee ana mana tuka dea nara. Sekonaa te lahenda fekeꞌ ta bole naa roti ria fa, noi malaka agama ra. ");
INSERT INTO rgu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nenene matalolole! Au nana Ana Lahenda. Au anuu hak fo aetuꞌ ae, lahenda bole tao ubeaꞌ laꞌe fai hahae aoꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Laꞌe fai hahae ao fekeꞌ esa, boe ma Yesus neu nanori-nafada nai uma mamasoꞌ daleꞌ. Nai na, hapu touꞌ esa mate liman seri. ");
INSERT INTO rgu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nai na boe, mesen agama ma lahenda agama Farisi ra saka lelaꞌ fo nau ratuda Yesus. De rahani kalu Ana puli na tou mana mate lima seseriꞌ ria laꞌe fai hahae aoꞌ. No ria na, ara bisa rahihiiꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tehuu Yesus bubuluꞌ matetuꞌ sira duduꞌa-aafi nara. Huu ria na Ana naloo lahenda ria nae, “Aꞌa! Mai mapadeiꞌ nai talada ia dei!” Boe ma ana neu tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Basa de, Yesus natane lahenda sira nae, “Au atane aneni emi, dei. Tuka ita atoran agama na, ita bole tao sudi ubeaꞌ a laꞌe fai hahae aoꞌ? Ita tao malole do, tadaluꞌ? Puli ta lahenda do, tao talulutuꞌ masoda na?” ");
INSERT INTO rgu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus mete naleleiꞌ asa, boe ma dedea no tou lima mana mate seseriꞌ ria nae, looꞌ lima ma mai!” Basa de ana looꞌ lima na boe ma teꞌe na aon. ");
INSERT INTO rgu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yesus musunoo nara, rita leoꞌ na boe ma ramanasa roo Ni. De ara mulai rabua fo saka eno tadaluꞌ rae,” Ami muste saka eno fekeꞌ bali fo matuda Ni!” ");
INSERT INTO rgu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Faiꞌ esa boe ma Yesus ae leo leteꞌ esa lain neu, fo hule-haradoi. Ana hule-haradoi nai na hatuꞌ esa katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Malua boe ma, Ana naloo na katemaꞌ ana mana tuka dea nara. Neme basa sira mai Ana here na lahenda sanahulu dua fo dadi reuꞌ Ria lahenda nadedenu nara. Ana here na lahenda ra siꞌ: ");
INSERT INTO rgu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (biasa Yesus naloon nae ‘Petrus’), Anderias (Simon fadi na), Yakobis. Yohanis (Yakobis fadi na), Filipus, Bertolomeos, ");
INSERT INTO rgu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateos, Tomas, Yakobis (Alpius ana na), Simon (fo tuka partei Selot), ");
INSERT INTO rgu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobis ana na), ma Yudas Iskariot (fo riꞌ ana seꞌo heni Yesus). ");
INSERT INTO rgu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Faiꞌ fo ara onda reme leteꞌ ria lain mai, Yesus no ana mana tuka dea nara rapadei nai dae matetuꞌ. Lahenda dodouꞌ rabua rai na boe. Ara reme propinsi Yudea, kota Yerusalem, ma reme Tirus ma Sidon, riꞌ kota kaduaꞌ fo rai tasiꞌ a suu na. ");
INSERT INTO rgu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ara mai nana nau ramanene neuꞌ Yesus, ma ruma hule fo Ana puli lahenda hedis ara, boe ma puli na si. Ana puli na lahenda nitu hekeꞌ ara ma usi heni nitu ra reme lahenda sira mai boe. ");
INSERT INTO rgu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Basa lahenda ra nau oi laꞌe Ni, huu fo maneniko ara oi laꞌe Ni, sona Ria kuasa Na kalua, de puli na si. ");
INSERT INTO rgu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Basa de, Yesus nasare na ana mana tuka dea nara, boe ma nanori-nafada si nae, “Lahenda manatoꞌa-manataaꞌ emin! Emi maua-manale, huu fo Manetualain, nana emi Mane manatulu-manafalim. ");
INSERT INTO rgu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lahenda mamalaa-maparoeꞌ emin! Emi maua-manale, huu fo neuꞌ ko Ramatuaꞌ a nahao-nafati emi. Lahenda mana luumata-pinuidu emin! Emi maua-manale, huu fo neuꞌ ko emi mamahoꞌo-matadale. ");
INSERT INTO rgu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Lahenda fo hapu susa nana huu tuka Au, Ana Lahenda ia! Emi maua-manale, huu fo neuꞌ ko Ramatuaꞌ a balas emi nai nusatetu-ikutemaꞌ a. Leo mae lahenda eteꞌ ao nara roo emi, fo dedea ramumulu emi, do ramolo-ratabuꞌ emi, do rausi-rapuuꞌ emi sama leoꞌ lahenda tadaluꞌ, emi maua-manale, huu fo Ramatuaꞌ a neuꞌ ko nafarene neuꞌ emi nai nusatetu-ikutemaꞌ a. De, leo mae lahenda tao rasususaꞌ emi boe oo, mamahoꞌo-matadale ma roke-foti nai basa ledo-fai! Bosoꞌ heran, huu no lahenda sira besaꞌ ia rasususaꞌ emi, sira bei-baꞌi nara boe tao rasususaꞌ Manetualain mana nesi mata faiꞌulu nara. De, maneniko emi hapu susa rupa leo naꞌ ara boe, noi mamahoꞌo-matadale neu, huu fo neuꞌ ko Ramatuaꞌ a bati-pala fee emi ua-naleꞌ dodouꞌ nai nusatetu-ikutemaꞌ a! ");
INSERT INTO rgu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tehuu lahenda kamasuꞌi emin! Emi soe, huu fo emi fai masoda namahoꞌo mara, teꞌe adaꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lahenda kamasuꞌi-mabeteꞌ emin! Emi soe, huu fo neuꞌ ko emi mamalaa-maparoe. Manahiꞌa-manasetelee emin! Emi soe, huu fo neuꞌ ko emi doidoso ma luumata-pinuidu. ");
INSERT INTO rgu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lahenda mana saka nade iꞌioꞌ emin! Emi soe, huu fo fai a ulu na emi bei-baꞌi mara boe, io mana nesi mata masarole-masaraliꞌ ara!” ");
INSERT INTO rgu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Boe ma Yesus dedea bali nae, “Nenene matalolole! O muste sue musunoo mara, ma tao malole soaneuꞌ lahenda fo eteꞌ ao nara ro o. ");
INSERT INTO rgu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hule-haradoi neuꞌ Manetualain ela Ana fee ua-naleꞌ neuꞌ lahenda fo kutuk o. Ma hule-haradoi fee lahenda fo rahehediꞌ o. ");
INSERT INTO rgu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Maneniko lahenda fapa o suke ii ma, sona soroꞌ suke ona ma neu bali. Maneniko lahenda ralea ra badu hanas ma, sona fee tamba seluꞌ ana badu. ");
INSERT INTO rgu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Maneniko lahenda hule o hatam esa, sona fee ni neu. Maneniko lahenda hai reni hatam esa, sona bosoꞌ hule faliꞌ ana bali! ");
INSERT INTO rgu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","O nau lahenda tao malole neuꞌ o, sona o muste tao malole neuꞌ lahenda boe. ");
INSERT INTO rgu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ma kalu o sue-lai lahenda fo sue-lai o, sona malole lena na riꞌ ubeaꞌ? Huu fo lahenda masala-masikoꞌ ara boe sue-lai neuꞌ lahenda fo sue-lai si a! ");
INSERT INTO rgu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Maneniko o tao malole noi neuꞌ lahenda fo tao malole neu o, malole na riꞌ ubea? Huu fo lahenda masala-masikoꞌ ara boe ratulu-rafali ao leo naꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Maneniko lahenda ra tonda doiꞌ, ma o fee noi lahenda fo bisa kati faliꞌ a, sona malole na riꞌ ubeaꞌ? Huu fo lahenda masala-masikoꞌ ara boe, fee lahenda ara tonda doi nara, sadi balahaaꞌ-binesaꞌ ara sipo fali asa katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tehuu malole na, leo iaꞌ: sue-lai o musunoo mara! Ma tao malole soaneuꞌ asa. Kalu sira parluu tonda ubeaꞌ, sona fee si. Boso afi mae, ara bisa kati faliꞌ, do taꞌa. No ria na, neuꞌ ko Manetualain balas o. Ma o dadi muuꞌ Manetualain Madema a anan. Huu fo masoda sama leoꞌ o Papa ma fo riꞌ nahiiꞌ tao malole soaneuꞌ lahenda masala-masikoꞌ a. Ana tao malole soaneuꞌ lahenda fo ta hule nalelaꞌ makasi fa. ");
INSERT INTO rgu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","De, o muste matudu dale kasian ma neuꞌ lahenda ra, sama leoꞌ o Papa ma nai nusatetu-ikutemaꞌ a boe natudu dale kasian Na neuꞌ o.” ");
INSERT INTO rgu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus nanori naroo nae, “Bosoꞌ uku-sudi lahenda, ela lahenda bosoꞌ uku-sudi ratafaliꞌ o. Bosoꞌ saka lahenda salan huu fo neuꞌ ko lahenda saka o sala ma boe. Mafarene heni lahenda salan, ela ara rafarene heni o sala ma. ");
INSERT INTO rgu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Maneniko o fee lahenda hata fo ara parluu, neuꞌ ko o sipo faliꞌ ana. Huu fo neuꞌ ko Manetualain bati-pala fee o henuꞌ-henu. Ria sama leoꞌ lahenda poꞌa hade leo balee uukuꞌ a daleꞌ neu, rakalelekoꞌ ana, ma poꞌa tamba seluꞌ neu losaꞌ sasi. De, neuꞌ ko o sipo leoꞌ na boe. Maneniko o fee baianaꞌ, sona o sipo faliꞌ baianaꞌ boe. Tehuu maneniko o fee dodouꞌ, sona o sipo faliꞌ dodouꞌ boe.” ");
INSERT INTO rgu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus nanori pake dedea nasasamaꞌ, Ana tui nae, “Lahenda pokeꞌ a ta bisa hela poke fekeꞌ a fa. Taꞌa sona dua si tuda belaꞌ a rala boloꞌ daleꞌ! ");
INSERT INTO rgu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ana sakola a ta bisa kahereꞌ lena neme ria mesen na mai fa! Tehuu maneniko ana tuka natalolole mesen a nanori-nafadan, sona ana bisa dadi sama leoꞌ ria mesen na boe. ");
INSERT INTO rgu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Lahenda sala na bau lima paꞌi keon ia, o mapeda maheren, tehuu o sala ma bauꞌ basa sona o mae salaꞌ ta ria fa. Ria sama leoꞌ o mita kadafu anaꞌ esa nai lahenda mata na. Sekonaa te baloꞌ kabaꞌuina a babaa etu mata ma, tehuu o ta bubuluꞌ fa! ");
INSERT INTO rgu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tao leoꞌ bea de o maparani mafada mae, ‘Toranooꞌ mai fo au kue heni kadafuꞌ a riꞌ mata ma daleꞌ ria dei.’ Sekonaa te o ta mita dae fa, huu fo baloꞌ a babaa etu o mata ma! Ae! Tebe o lahenda masarole-masarali! Kalua heni baloꞌ ria neme o mata ma mai dei, ela mita dae matetuꞌ, besaꞌ ko kue heni kadafu anaꞌ a neme toranoo ma mata na mai.” ");
INSERT INTO rgu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus tamba seluꞌ dedea nasasamaꞌ esa nae, “Ta hapu ai huuꞌ malole naboa boa tadaluꞌ. Ma ta hapu ai huuꞌ tadaluꞌ naboa boa malole. ");
INSERT INTO rgu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lahenda nalelaꞌ, ai huuꞌ a nana neme boa na mai. Basa lahenda bubuluꞌ rae, lahenda ta bisa seu ufa boaꞌ do anggor boaꞌ neme ai huu makouꞌ a mai fa. ");
INSERT INTO rgu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Leoꞌ na boe, lahenda dale malalao-malalafuꞌ bisa tao hihii-nanauꞌ malole. Tehuu lahenda dale makekeoꞌ a, sona tao hihii-nanauꞌ tadaluꞌ. Huu fo neme lahenda a dedea-nafadan mai, natudu fee ria dale tea na.” ");
INSERT INTO rgu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Boe ma Yesus dedea bali nae, “Emi maloo Au sona mae, ‘Ramatuaꞌ. Tehuu ubeaꞌ taon de emi ta nau tuka Au dedea-nafada Ki fa? ");
INSERT INTO rgu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Lahenda fo riꞌ mai ramanene Au, boe ma tao tuka Au dedea-nafada Ki, ria sama leoꞌ ");
INSERT INTO rgu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","lahenda fo nau nafoa uma tea-mepeꞌ. Ana ali fanderen na neuꞌ dae batu, dama nan, besaꞌ ko nafoa uma a neuꞌ lain. Maneniko faa ina a saꞌe na uma ria, tehuu uma ria ta naleuꞌ fa, huu fo fanderen na teaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tehuu lahenda fo namanene no dale poseseriꞌ ma ta tuka Au dedea-nafada Ki, sama leoꞌ lahenda fo nafoa uma no mudaꞌ. Ana ta dama fanderen a fa, noi nadiditeꞌ uma ria neuꞌ lee a suu na. Fai fo faa ina a saꞌe na uma ria, boe ma hea neu!” ");
INSERT INTO rgu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus nanori basa, boe ma Ana leo kota Kapernaum neu. ");
INSERT INTO rgu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nai na hapu soldadu Roma ra malakan esa. Nanuu ata kamaheren esa. Ata ria, namahedi de noi mamaten. ");
INSERT INTO rgu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Faiꞌ ria malaka soldadu a namanene laꞌeneuꞌ Yesus, boe ma ana nadenu lasi Yahudi hida fo reu hule Ni mai puli na atan ria. ");
INSERT INTO rgu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ara hule Yesus, fo tuka no si neu puli na lahenda ria. Ara leleꞌo Ni rae, “Ramatuaꞌ! Lahenda Roma ia, lahenda malole! Ria naraa, Ramatuaꞌ tulu-fali ni. ");
INSERT INTO rgu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Huu fo ana tao fee ita uma mamasoꞌ, te ana sue ita lahenda Yahudi a.” ");
INSERT INTO rgu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Boe ma Yesus tuka no si. Ara bei ta losa uma fa, tehuu malaka soldadu ria fee nonoo nara mai rafada Yesus rae, “Ramatuaꞌ *a bosoꞌ masosota aom mai bali, huu fo au ta araa sipoꞌ Ramatuaꞌ *a nai au uma ka fa. ");
INSERT INTO rgu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Ma au ta araa leo Ramatuaꞌ *a mai boeꞌ. Makaledo na riꞌ rae, Ramatuaꞌ *a manuu kuasa. De, sadi mafada memeꞌ naꞌ mai, tantu au ata ka teꞌe na aon. Au bubuluꞌ hihii-nanauꞌ ia ra, huu fo au malaka kara ranuu kuasa fo pareta au. Ma au boe anuu kuasa fo pareta soldadu kara. Maneniko au pareta soldadu esa ae, ‘Leo eleꞌ muu!’ sona neu. Maneniko au ae, ‘Mai dei!’ tantu ana mai. Ma kalu au adenu ata ka ae, ‘Moi ia!’ tantu ana noi-tao ni. De, sadi Ramatuaꞌ *a moi mafadaꞌ a, tantu au ata ka ria, teꞌe na aon.” ");
INSERT INTO rgu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus namanene na ria, boe ma Ana heran. Ana lipe aon de nasare na lahenda kadodouꞌ fo riꞌ tuka Ni a, boe ma nae, “Heran, e! Doo-naru basa ia, tehuu Au bei ta parna aneta oi lahenda Yahudi esa namahere tebe-tebe sama leoꞌ lahenda Roma ia!” ");
INSERT INTO rgu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","De, Yesus nahaniꞌ na. Basa de, malaka soldadu a nonoo nara fali reus. Losa malaka a uma na, te rita ata ria teꞌe na aon so. ");
INSERT INTO rgu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Balahaaꞌ, boe ma Yesus noo ana mana tuka dea nara leo koroꞌ esa reu, nade Nain. Lahenda dodouꞌ laꞌo sama-sama roo si. ");
INSERT INTO rgu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ara raneneaꞌ koroꞌ ria lelesu bafa na, boe ma lahenda bubuaꞌ esa rolo reni lahenda mana mateꞌ esa reu ratoi. Mana mateꞌ ria nana, ina-falu esa ana mane ise na. ");
INSERT INTO rgu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesus nita ina-falu ria, boe ma noi sueꞌ ana. De Ana nafada neuꞌ inaꞌ ria nae, “Mama! Bosoꞌ boe dola bali!” ");
INSERT INTO rgu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus naneneaꞌ leo mata neu, de oi laꞌe tandu fo rapeuꞌ mana mateꞌ a neu lain. De, lahenda fo riꞌ rolo mana mateꞌ a ara rateꞌe. Yesus dedea no mana mateꞌ ria nae, “Ana tou anaꞌ on! Foa leo!” ");
INSERT INTO rgu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Boe ma anaꞌ ria nasoda seluꞌ, ana foa de natuuꞌ ma mulai dedea no lahenda fo rapadeiꞌ eo ra ni a. Yesus nafada inaꞌ ria nae, “Mama! Sipoꞌ ma ana ma.” ");
INSERT INTO rgu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Basa lahenda fo rai na ara bii raan seli! Boe ma ara io-oa neuꞌ Manetualain rae, “Manetualain nadenu mana nesi mata kahere Ni esa mai soaneuꞌ ita!” Fekeꞌ ara bali sona rae, “Manetualain mai nai ita basa talada, fo natudu dale malole Na!” ");
INSERT INTO rgu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Boe ma tutuiꞌ ria beka ni nai propinsi Yudea, losa leo nusa fekeꞌ ara neu boe. ");
INSERT INTO rgu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Yohanis Mana Saraniꞌ a ana mana tuka dea nara ramanene hihii-nanauꞌ fo Yesus tao ni a. De ara reu tui Yohanis nai bui daleꞌ. Boe ma ana nadenu lahenda dua reu ratane Yesus rae, “Tebe-tebe Papa nana Kristus fo riꞌ ami mahanin a? Do ami muste mahani lahenda fekeꞌ?” Lahenda sira dua losa Yesus, boe ma ratanen rae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Fai fo lahenda nadedenuꞌ sira rai na, nana Yesus puli na lahenda dodouꞌ reme hedi rupa nara mai. Ma usi kalua nitu reme lahenda nitu hekeꞌ ara mai. Puli na lehenda pokeꞌ ara de bisa rita dae. ");
INSERT INTO rgu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Boe ma Yesus nafada Yohanis lahenda nadedenu nara nae, “Emi fali meu mafada aꞌa Yohanis basa-basan fo riꞌ emi mita mataꞌ ma mamanene a, sama leoꞌ Manetualain mana nesi matan Yesaya duiꞌ nae, ‘Lehenda pokeꞌ, rita dae. Lahenda lukuꞌ, lalaꞌo. Lahenda kamahedi kusta, teꞌe ra ao nara. Lahenda pakeꞌ, ramanene. Lahenda mana mateꞌ, rasoda seluꞌ. Lahenda manatoꞌa-manataꞌ ara tui-beka fee si Tutui Malole.’ ");
INSERT INTO rgu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ma fali meu mafada aꞌa Yohanis mae, ‘Tebe maua-manaleꞌ neuꞌ lahenda fo namahere tebe-tebe neuꞌ Au.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Basa de Yohanis lahenda nadedenu nara fali, boe ma Yesus dedea no lahenda kadodou inaꞌ sira laꞌeneuꞌ Yohanis nae, “Tepoꞌ fo emi meu saka Yohanis nai mamana lino-nes a, emi afi mae meu te mita mo lahenda rupa leo bea nai na. Emi ta meu fo mita lahenda rupa na leoꞌ oo a, de ani a fuun sona naleuꞌ neu-mai. ");
INSERT INTO rgu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Emi ta meu mita lahenda pake bua-loa mabeli, huu fo lahenda rupaꞌ leo naꞌ a leo nai uma maneꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","De, emi meu dama bea nai na? Emi afi mae meu saka Manetualain mana nesi matan? Tebe! Tehuu ria nana mana nesi mata nanuu kuasa bauinaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Huu fo mana duiꞌ memaꞌ nai Susura Makamoiꞌ a laꞌeneuꞌ Yohanis nae, ‘Nenene! Au adenu lahenda Ka, fo naole enoꞌ fee O.’ ");
INSERT INTO rgu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nai dae-bafoꞌ ia, ta hapu lahenda esa bau lena heni Yohanis boeꞌ. Tehuu nai Manetualain nusa-namon, lahenda hihika-rereka taꞌ a nanuu kuasa lena neme Yohanis mai.” ");
INSERT INTO rgu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lahenda kadodouꞌ sira ma mana susu bea ra oo ramanene Yesus dedea-nafadan, boe ma bubuluꞌ rae, Manetualain nana eno masoda matetuꞌ a. Huu fo maulu na Yohanis sarani si ma nanori-nafadas. ");
INSERT INTO rgu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tehuu lahenda agama Farisi, ma lahenda malela atoran agama Yahudi ra, ta nau tuka Manetualain hihii-nanaun soꞌ. Huu ria na de, ara ta hule Yohanis sarani si fa. ");
INSERT INTO rgu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Boe ma Yesus natane nae, “Au nau araraaꞌ lahenda besaꞌ ia a, no ubeaꞌ? Lahenda rupa leo beaꞌ ia ra? ");
INSERT INTO rgu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sira nana, sama leoꞌ ana aanaꞌ ara fo ratuu kukuaꞌ nai pasar a. Ara raloloo aoꞌ ma esa namuu esa rae, ‘Ami basa fuu suling, tehuu emi ta nau roke-foti fa. Boe ma ami soda sosoda luumata-pinuidu, tehuu emi ta dola fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Huu fo Yohanis Mana Saraniꞌ a ta ninu anggor fa, ma nahiiꞌ puasa sona emi mae, ‘Nitu ra heke raa ni!’ ");
INSERT INTO rgu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tehuu besaꞌ ia Au, Ana Lahenda, inu anggor ma ua roti leoꞌ bale-bale. Boe ma emi mafada Au mae, ‘Iku a lahenda maoroꞌ a! Mana mafu beraꞌ a! Neu natiaꞌ no mana susu bea ra! Ma partei esa no lahenda papake taꞌ ara bali! Ta dodoo aon nae bea ria fa!’ ");
INSERT INTO rgu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tehuu emi tanda Au dedea-nafada Ki, ee! Lahenda fo bubuluꞌ no matetuꞌ, ara tuka Manetualain hihii-nanaun.” ");
INSERT INTO rgu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nai kota ria, hapu lahenda Farisi esa, nade, Simon. Laiꞌ esa de, ana hule Yesus asa mai raa-rinu nai uma na. Yesus asa sipo ra nalooꞌ ria, boe ma ara reu fo sakaꞌ ratuuꞌ raa-rinu. ");
INSERT INTO rgu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tepoꞌ ria, hapu ina mana sosoa esa namanene nae, Yesus sakaꞌ neu naa-ninu nai na. Boe ma ana mai, ma homu neni mina maboo-meni mabeli boto esa. ");
INSERT INTO rgu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ana mai naneneaꞌ leo Yesus neu, nesiꞌ dea Na. Boe ma sundaꞌ undulaka na nai Yesus eidae na. Tutiꞌ a ana dola losaꞌ luu na titi laꞌe Yesus ei na. Ana seka Yesus ei na neniꞌ lakadoo na, ma deꞌi nasarerei Yesus ei na. Boe ma ana poꞌa mina maboo-meniꞌ ria neuꞌ Yesus ei Na. ");
INSERT INTO rgu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon bubuluꞌ inaꞌ ria leleo-lalaꞌon, de nita leoꞌ na, boe ma dodoo nai dale na nae, “Kalu tebe-tebe Yesus nana Manetualain mana nesi matan, sona Ana bubuluꞌ nae, inaꞌ fo riꞌ tatai laꞌe Ni ia, ina mana sosoa. Ia dadi buti so, Manetualain mana nesi matan ta ia fa! Huu fo lahenda malalao-malalafuꞌ ta bole nabua no lahenda masala-masikoꞌ ara!” ");
INSERT INTO rgu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tehuu Yesus lees nala hata fo Simon afi nan, boe ma Ana nae, “Aꞌa Simon! Leo iaꞌ. Au nau afada aꞌa ka hihii-nanauꞌ esa.” Boe ma Simon nataa nae, “Neuꞌ! Papa Mesen, mafada leo.” ");
INSERT INTO rgu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tutiꞌ a Yesus tuꞌu dedeaꞌ fee ni nae, “Hapu lahenda esa, biasa fee lahenda fekeꞌ a tonda doi nara. Ana parna fee lahenda dua tonda doi nara. Esa tonda na doifulaꞌ natun lima, ma esa sona noi lima huluꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tehuu losa fai na, boe ma dua si ta rabeꞌi fee faliꞌ doiꞌ sira so. Huu ria na, lahenda fo riꞌ fee dua si tonda doiꞌ a noi sueꞌ asa, de ana ta fee dua si bae huta nara soꞌ. Kalu tuka aꞌa Simon dale dodoo ma, neme lahenda mana tonda doiꞌ sira dua mai, bea riꞌ sue kadodou na neuꞌ lahenda fo fee si tonda doiꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon nataa tutiꞌ a nae, “Tantu lahenda fo riꞌ huta na dodouꞌ a!” Yesus nataa nae, “Tebe leoꞌ na, aꞌa!” ");
INSERT INTO rgu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Boe ma Ana lipe aon, de nasare na inaꞌ ria, ma nafada Simon nae, “Soba aꞌa Simon mete masudi inaꞌ ia. Bisinaꞌ a Au masoꞌ leo o uma ma mai a, aꞌa ka ta sadia oe, ela Au safe ei ka tuka ita hada na. Tehuu inaꞌ ia sona, naꞌoe Au ei ka neniꞌ ria luu na, ma ana seka makamomoi ni neniꞌ lakadoo na. ");
INSERT INTO rgu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma bisinaaꞌ a, aꞌa Simon sipoꞌ Au leo uma ma daleꞌ mai a, ta deꞌi Au tuka ita biasa na fa. Tehuu mulai Au masoꞌ leo uma ia daleꞌ mai, inaꞌ ia ta hahae dedeꞌi Au ei ka fa. ");
INSERT INTO rgu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bisinaꞌ a Au masoꞌ mai a, aꞌa Simon mafarene heni hadas a, de ta poꞌa mina neuꞌ Au laka Ka. Tehuu inaꞌ ia poꞌa mina maboo-meni mabeli neuꞌ Au ei Ka. ");
INSERT INTO rgu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aꞌa Simon nenene matalolole! Tebe inaꞌ ia sala na dodouꞌ, tehuu Manetualain sae-safe heni si katemaꞌ so, huu fo Ana natudu susue na no tanda makasi kadodou na neuꞌ Au. Lahenda fo nameda aon nae, ana ta tao salaꞌ dodouꞌ, sona ria boe ta hapu ampon dodouꞌ fa. Huu ria na, de ana ta sue ma ta hule nalelaꞌ makasi neuꞌ Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Boe ma Yesus nafada inaꞌ ria nae, “Au sae-safe heni o sala mara so!” ");
INSERT INTO rgu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lahenda fo ratuuꞌ raa-rinu belaꞌ a rai na a, esa nabobotoꞌ esa rae, “Ae! Te nae Ria nana bea? Ana naparani fee ampon neuꞌ lahenda salan, oo! Sekonaa te noi Manetualain riꞌ nanuu hak fo sae-safe heni lahenda salan!” ");
INSERT INTO rgu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tehuu Yesus nafada inaꞌ ria nae, “Huu no o mamahere neuꞌ Au, de Manetualain fee o sodaꞌ a so. Fali muuko no mole-dame leo!” ");
INSERT INTO rgu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ta doo bea boeꞌ, te Yesus no ana mana tuka dea lahenda kasanahulu dua nara, laꞌo rafeo basa kota ma koroꞌ manai naa ra. Ana laꞌo fo tui-beka fee lahenda ra, laꞌeneuꞌ Manetualain pareta na. Ria dadi neuꞌ Tutui Malole fee si. ");
INSERT INTO rgu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nai lahenda kabuaꞌ sira daleꞌ hapu inaꞌ hida tuka si boe. Inaꞌ ia ra, ruma parna ramahedi rupaꞌ, ma nitu ra heke ra ruma. Tehuu Yesus puli na katemaꞌ asa. Leo-leoꞌ Maria neme koro Magdala. Maꞌulu na, Yesus usi heni nitu hitu reme ao na mai. ");
INSERT INTO rgu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Boe ma Susana, ma Yohana. Mama Yohana nana, riꞌ papa Kusa sao ina na. Kusa nana, malaka malilisu nai mane Herodes a uma mana pareta na. Ma bei hapu ina fekeꞌ dodouꞌ bali, fo riꞌ laꞌo sama-sama ro Yesus asa. Inaꞌ ia ra pake doi nara, fo bae fee Yesus asa hata fo parluu nai enoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Laiꞌ esa de, lahenda kalua reme koroꞌ dodouꞌ mai, fo saka Yesus. Basa si tesa, boe ma Ana tui fee si dedea nasasamaꞌ nae, ");
INSERT INTO rgu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Lahenda maue-maosa esa neu kari bini-kee nai ria oka na. Bini ruma tuda rai enoꞌ a. Fai fo lahenda resiꞌ na, ara ramolo-ratabuꞌ bini sira. Basa boe ma manupuiꞌ ara mai de seseu rabasa si. ");
INSERT INTO rgu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bini ruma tuda rai dae batu. Bini sira mulai ranupu, tehuu ara mamale henis, nana huu oe baianaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bini ruma tuda laꞌe dae matemaꞌ. Tehuu fai fo bini sira mulai ranupu, matemaꞌ ara amuu raisa si. ");
INSERT INTO rgu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tehuu bini fekeꞌ ara bali, tuda laꞌe dae isi mana dadiꞌ a. Ara ranupu, basa de mori boe ma rambau-ina losaꞌ raboa. Bini sira fee faliꞌ buna-boaꞌ laiꞌ natun esa.” Yesus tui basa nae leoꞌ na, boe ma Ana nateꞌe dedea nasasamaꞌ ria, ma naloo nae, “Bea fo riꞌ namanene, sona afi natalolole!” ");
INSERT INTO rgu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Basa boe ma, Yesus ana mana tuka dea nara ratane nasasamaꞌ ria sosoa na. ");
INSERT INTO rgu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ana nataa nae, “Leo iaꞌ! Huu fo emi tuka matetuꞌ Manetualain hihii-nanaun, huu ria na de Au soi ni neuꞌ loa na ela emi bubuluꞌ, Manetualain nau pareta tao Ria lahenda nara leoꞌ bea. Tehuu lahenda fekeꞌ ara ta nau tao daleꞌ neuꞌ Manetualain hihii-nanaun. Huu ria na Au anori-afada si pake nasasamaꞌ. Huu fo Manetualain mana nesi mata nara duiꞌ memaꞌ laꞌeneuꞌ lahenda ia ra nae, ‘Ara rita, tehuu ta ralelaꞌ fa. Ara ramanene, tehuu ta bubuluꞌ fa.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Boe ma Yesus nafada nasasamaꞌ ria sosoa na nae, “Bini ria, nana riꞌ Manetualain Hara-dasin. ");
INSERT INTO rgu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bini fo tuda rai enoꞌ a, nana riꞌ lahenda fo ramanene Manetualain Hara-dasin, tehuu malaka nitu mai nalea neni Hara-dasiꞌ ria neme sira dale nara mai. No ria na, ta ramahere neuꞌ Manetualain, de ara ta sosoi-tetefaꞌ a fa. ");
INSERT INTO rgu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bini fo tuda nai dae batu a, nana riꞌ lahenda fo ramanene Manetualain Hara-dasin no namahoꞌo. Tehuu oka nara rakaꞌ batu. Ara ramahere, tehuu maneniko susa a saꞌe naa si, sona mudaꞌ lai esaꞌ ara tuda. ");
INSERT INTO rgu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bini fo tuda laꞌe mamana matemaꞌ a, nana riꞌ lahenda fo ramanene ma sipoꞌ Manetualain Hara-dasin, tehuu ta doo bea boeꞌ te rafarene henin, nana huu rasaliu noi sira nafaduli mesa nara, roo hata-heto nara, ma rahiiꞌ noi namahoꞌo-natadaleꞌ a. Huu ria na sira namahere na, buna-boaꞌ taꞌa marorooꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tehuu bini fo tuda nai dae isi mana dadiꞌ a, nana riꞌ lahenda dale roo-tetuꞌ ma dale malole. Tepoꞌ fo ara ramanene Manetualain Hara-dasin, boe ma ara rapeda-rahendan neuꞌ dale nara. No ria na, ara ramahere raroo, ma tao hihii-nanauꞌ malole.” ");
INSERT INTO rgu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesus dedea bali nae, “Ta hapu lahenda dede na dedede anaꞌ a, sona tatana etun neniꞌ ure dae, do peda dededeꞌ a neuꞌ roaꞌ a fiki dale na. Huu fo maneniko tao leo naꞌ, sona lahenda ta bisa rita makaledoꞌ a soꞌ. Dededeꞌ fo nanuu sosoa-raraaꞌ, nana riꞌ fua ni neuꞌ mamana madema, ela lahenda kodi mai boe makaledoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Besaꞌ ia basa-basan fo mana mafuniꞌ a, neuꞌ ko nana nitaꞌ. Ma basa hihii-nanauꞌ fo besaꞌ ia, lahenda ta ralelaꞌ ana, neuꞌ ko ralelaꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","De, emi muste dodoo-tatai matalolole hihii-nanauꞌ ia ra. Lahenda fo nau saka matetuꞌ Manetualain hihii-nanaun, ana boe-boe nalelaꞌ. Tehuu lahenda fo ta tao daleꞌ neuꞌ Manetualain hihii-nanaun, sona ana boe-boe pakanaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Laiꞌ esa de, Yesus mama Na ma fadi nara mai dama Ni. Tehuu ara ta bisa raneneaꞌ Ana fa, huu fo lahenda dodouꞌ eo ran. ");
INSERT INTO rgu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Boe ma lahenda reu rafada Yesus rae, “Papa! Mama ma no fadi mara rai deaꞌ. Ara nau raneta ro Papa.” ");
INSERT INTO rgu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Boe ma Ana nataa si nae, “Leo iaꞌ, Au mama Ka ma toranoo tetea Kara nana siꞌ lahenda fo ramanene Manetualain Hara-dasin ma tao tukan.” ");
INSERT INTO rgu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Laiꞌ esa de, Yesus hule ana mana tuka dea nara nae, “Mai ita saꞌe ofaꞌ, fo leo dano a seriꞌ teu.” Boe ma saꞌe ra ofaꞌ esa, de ara mulai laꞌo. ");
INSERT INTO rgu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ara laꞌo, boe ma Yesus suku. Ta doo bea boeꞌ, te ruli a mai de nafa ra totoꞌo rala ofaꞌ daleꞌ. Ara hihiiꞌ bolo. ");
INSERT INTO rgu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana mana tuka dea nara rita leoꞌ na, boe ma ara fafae Yesus rae, “Ramatuaꞌ! Ramatuaꞌ! Foa dei! Te ita sakaꞌ bolo riaꞌ so!” Boe ma Yesus foa, de Ana nasaꞌai nafa-ani nae, “Hahae leo!” Boe ma nafa-ani tena tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Boe ma Ana nafada ana mana tuka dea nara nae, “Ubeaꞌ taon de emi bei ta mamahere neuꞌ Au fa?” Ara bii ma roi ramakokoaꞌ a, de esa natane esa rae, “Awii! Yesus ia nana, bea? Tao leoꞌ bea de Ana bisa pareta nafa-ani, fo tuka Ria hihii-nanaun?” ");
INSERT INTO rgu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ta doo bea boeꞌ, te ara losa rai nusa Gerasa, nai dano Galilea a seriꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Nai na, hapu lahenda esa nitu ra heke ran dooꞌ a so. Ana ta nanuu uma fa, ma ana leo nahaniꞌ rates ara talada. Tuka-tuka faiꞌ ana leiꞌ-lei adaꞌ na ma poꞌiraoꞌ. Huu fo nitu ra pareta ni laꞌo naroo. Laꞌi-laꞌi lahenda heke ei-liman reniꞌ rante besi, tehuu rui na etu si. Ma nitu ra raseti ni, fo roon leo mamana lino-nes neu. Faiꞌ ria Yesus asa onda reme ofaꞌ lain mai, boe ma lahenda kamulus ria leo Yesus neu. Lahenda ria bou-bou, ma bara neuꞌ Yesus ei dae Na. Tutiꞌ a Yesus pareta nae, “Ae, nitu! Kalua memeꞌ lahenda ia mai!” Boe ma lahenda kamulus ria bobouꞌ nae, “Ae! Bosoꞌ tao mahehediꞌ au! Huu fo au bubuluꞌ O nana Yesus, Manetualain Madema a Anan! O bosoꞌ ese-rumu au!” ");
INSERT INTO rgu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus natane ni nae, “O nade bea?” Nitu a nataa nae, “Legion, nana huu ami dodou-inaꞌ, sama leoꞌ soldadu rifun.” Ana nae leoꞌ na, huu fo nitu dodouꞌ masoꞌ rai ria aon daleꞌ so. ");
INSERT INTO rgu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nitu sira hule neuꞌ Yesus fo bosoꞌ nadenu si leo Bolo Eese-Rurumuꞌ a reu, mamanaꞌ fo riꞌ ena kuasa tadaluꞌ ara reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naneneaꞌ nai naa, bafi bubuaꞌ esa totofi saka nanaaꞌ nai leteꞌ a suu na. Nitu ra hule Yesus rae, “Madenu ami masoꞌ leo bafi sira daleꞌ meu!” Boe ma Yesus nataa. ");
INSERT INTO rgu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Basa de, nitu ra kalua ela touꞌ ria, boe ma ara kodi leo bafi sira daleꞌ reu. Basa bafi sira ramulu si, de ralai ratotofaꞌ onda reme leteꞌ lain mai, ara tuda rala dano daleꞌ de mate katemaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Manea bafi ra rita mana dadi, boe ma ralai reu tui nai basa koro manai naa ra. ");
INSERT INTO rgu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lahenda dodou ramanene si tui rae leoꞌ na, boe ma ara kalua leo mamanaꞌ ria reu, ela rita mataꞌ mana dadiꞌ ubeaꞌ ria. Losa naa, te rita lahenda nitu hekeꞌ ria natuuꞌ neu-neu naneneaꞌ nai Yesus ei dae na. Ana pake bua-loas, ma kamulu na mopon so. Basa si rita ria, boe ma ara bii. ");
INSERT INTO rgu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lahenda fo rita mana dadiꞌ ria, ara tui lahenda fo besaꞌ ko mai a, eno na leo beaꞌ de lahenda kamulus ria teꞌe na aon so. ");
INSERT INTO rgu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Boe ma basa lahenda fo leo rai nusa Garasa a, ara hule Yesus foa ela si huu fo basa si biiꞌ raan seli. Boe ma Yesus asa ae ofaꞌ lain reu, fo sakaꞌ fali leo dano Galilea a seriꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tehuu lahenda nitu hekeꞌ ria hule Yesus nae, “Papa! Ela au tuka Papa boe!” Tehuu Yesus sipoꞌ ana nae, ");
INSERT INTO rgu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Leo iaꞌ dei! Malole lenaꞌ o fali leo kileoboboki mara muu, fo tui si laꞌeneuꞌ Manetualain malolen fo Ana taon soaneuꞌ o a.” Boe ma lahenda ria laꞌo nafeo basa kota ria, de tui basa lahenda ra laꞌeneuꞌ Yesus puli nan. ");
INSERT INTO rgu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Basa boe ma Yesus asa saꞌe ofaꞌ leo dano Galilea a seriꞌ reu. Ara onda reme ofaꞌ lain mai, te lahenda dodouꞌ rahani Ni so. Ara rarurupu mai fo nau sipoꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Touꞌ esa nade Yairus nai na boe. Ria nana malaka uma mamasoꞌ nai kota ria. Ana ni noi esaꞌ a; ana inaꞌ, teu ni sanahulu dua. Besaꞌ ia ana fetoꞌ ria hedi beraꞌ noi mamaten. Tepoꞌ fo Yairus nita Yesus mamai na, ana sundaꞌ undulaka na neuꞌ Yesus mata na. Ana hule fo Yesus leo uma na neu, ela tulu-fali na ana feto na. Yesus nataa ni, boe ma ara leo Yairus uma na neu. Tehuu lahenda dodouꞌ rapue nau tuka boe, huu ria na ara laꞌo raseseti ao. ");
INSERT INTO rgu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hapu inaꞌ esa laꞌo no si boe. Namahedi ina ta pake hahaeꞌ fa teuꞌ sanahulu dua so. Ana nabasa doi-talin ma hata-heton, fo bae doter a. Tehuu ta bisa puli rala ni fa, hedi na foa naroo. ");
INSERT INTO rgu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Boe ma ana naneneaꞌ nesiꞌ Yesus dea na. Basa de ana oi laꞌe Yesus badu peda na. Ana oi laꞌe, boe ma hedi ina na teꞌe tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kekeneu te Yesus napadei, basa de Ana natane nae, “Bea rina oi laꞌe Au ia?” Tehuu ta hapu esa manaku boeꞌ. Boe ma Petrus nae, “Ramatuaꞌ *a boe na! Te lahenda dodouꞌ laꞌo raseseti ao leoꞌ ia na! Ara ratipa ao reme deaꞌ mai.” ");
INSERT INTO rgu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tehuu Yesus nafada ni nae, “Taꞌa! Bisinaꞌ a Au ameda kuasa kalua neme Au mai. Au bubuluꞌ lahenda esa oi laꞌe Au.” ");
INSERT INTO rgu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Inaꞌ ria nameda nan ta bisa nafuni nala fa, boe ma ana biiꞌ mamateꞌ. Ana dere, de sundaꞌ undulaka na neuꞌ Yesus. Basa boe ma ana tui neuꞌ basa lahenda sira matan, ria hedi-raun huu-pedan. Nafada nae, laꞌe fai ana oi laꞌe Yesus, boe ma teꞌe na aon tutiꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Basa boe ma Yesus nafada ni nae, “Susi! O teꞌe so, huu fo mamahere neuꞌ Au. Fali no mole-dame leo!” ");
INSERT INTO rgu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus bei dedea noo inaꞌ ria, te Yairus lahendan esa mai nafada ni nae, “Adoo, Papa, ee! Papa ana ma neꞌes ana so! Maten so, de bosoꞌ masosota Papa Mesen bali.” ");
INSERT INTO rgu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tehuu Yesus namanene lahenda ria tutui na, boe ma Ana nafada Yairus, “Aꞌa! Nenee! Dale ma bosoꞌ dodaaꞌ! Mamahere neuꞌ Manetualain. Ria rina fee aꞌa ka ana ma sodaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ara losa Yairus uma na, te lahenda tesa rahenu naa so, Ara boreu. Boe ma Yesus nasaꞌai si nae, “Emi hahae boreuꞌ a leo! Anaꞌ ia ta maten fa. Ana suku ria!” Tehuu lahenda ra hiꞌa ma peko bafa nara roo Ni, huu fo rita mataꞌ anaꞌ ria etu hahae na so. Boe ma Yesus hule ana fetoꞌ a ina-aman, Petrus, Yohanis, ma Yakobis, fo roo Ni masoꞌ daleꞌ reu belaꞌ a. Fekeꞌ ara sona nadenu si rahani nai deaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ara daleꞌ reu, boe ma Yesus tai na anaꞌ ria lima na, ma naloo nae, “Ana fetoꞌ, on! Foa leo!” ");
INSERT INTO rgu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kekeneu te, ana feto anaꞌ ria nasoda seluꞌ, ma ana foa tutiꞌ a. Basa boe ma Yesus nafada ana fetoꞌ ria mama na nae, “Fee anaꞌ ia naa dei!” ");
INSERT INTO rgu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ana feto anaꞌ ria ina-ama nara roi leleuꞌ laka nara. Tehuu Yesus fee si nafarereneꞌ, fo bosoꞌ tui-beka mana dadiꞌ ria neuꞌ lahenda ra. ");
INSERT INTO rgu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Laiꞌ esa de, Yesus nabubua na ana mana tuka dea kasanahulu dua nara. Boe ma Ana fee si kuasa fo bisa usi nitu, ma bisa puli ra lahenda reme hedi rupa nara mai. ");
INSERT INTO rgu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ana nadenu si reu tui-beka fee lahenda laꞌeneuꞌ Manetualain hohomu pareta Na. Ana nadenu si fo puli ra lahenda kamahedis nai basa mamanaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tehuu Ana nafada si nae, “Mafarereneꞌ matalolole! Nai emi lalaꞌom ia, ta bole meni hata-hata esa boeꞌ. Meni noi badu nai ao-ina mara. Bosoꞌ meni teteꞌe, tas, tua-lepa, do doi-tali. Badu lenaꞌ boe, bosoꞌ meni! ");
INSERT INTO rgu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maneniko emi masoꞌ leo koroꞌ esa meu, ma lahenda sipoꞌ emi, leo nai sira uma nara, sona bosoꞌ madula fo leo meuꞌ na, losaꞌ emi kalua meme koroꞌ ria mai. ");
INSERT INTO rgu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Maneniko emi masoꞌ leo koroꞌ esa meu, boe ma lahenda fo rai na ta nau sipoꞌ, ma ta nau ramanene neuꞌ emi, sona kalua meme naꞌ mai. Ma kalu emi kalua meme naꞌ mai, sona tao tuka hadas a, fo sasapu heni afu a neme emi ei mara mai. Mafada si mae, ‘Emi ta nau mamanene fa, de dei mataa ao mara nai Manetualain matan.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Boe ma, ana mana tuka dea sira laꞌo reme koroꞌ mai leo koroꞌ reu. Ara tui-beka fee lahenda ra Manetualain Hara-dasin. Ma puli ra lahenda kamahedis ara boe. ");
INSERT INTO rgu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mane Herodes Antipas namanene tutui rupaꞌ laꞌeneuꞌ Yesus. Boe ma noi patararaaꞌ a, huu fo lahenda ruma rae, “Yesus nana, riꞌ Yohanis Mana Saraniꞌ a nasoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ruma bali rae, “Ria nana, baꞌi Elia a nasoda seluꞌ so.” Ma ruma bali rae, “Ria nana, Manetualain mana nesi mata fai ulu nara esa rian.” ");
INSERT INTO rgu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tehuu Herodes nafarene nae, “Maꞌulun ria, au tete heni Yohanis laka na so. Ana nasoda seluꞌ, do? Te bea ria bali?” De ana usaha fo nau naneta no Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Faiꞌ esa, boe ma ana mana tuka dea fo riꞌ Yesus nadenu si a, ara fali mai si, de rabua seluꞌ ro Ni. Ara tui Ni basa-basan fo sira tao a. Boe ma Yesus no ana mana tuka dea nara laꞌo rama nininoꞌ a leo mamanaꞌ esa reu naneneaꞌ no koro Betsaida, ela hahae ao nara reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tehuu lahenda dodouꞌ bubuluꞌ Yesus asa leo beaꞌ reu, de ara ranononda reu tuka Ni. Yesus sipoꞌ asa no malole. Ana puli na katemaꞌ lahenda kamahedis ara ma Ana tui si laꞌeneuꞌ Manetualain pareta nai dae-bafoꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ledo leodaeꞌ, boe ma Yesus ana mana tuka dea kasanahulu dua nara, rafada Ni rae, “Malole lenaꞌ Ramatuaꞌ *a madenu lahenda ia ra leo koro maneneaꞌ fo nai ia, ela bisa saka ao nara nanaa-nininuꞌ. Ma ara saka mamanaꞌ fo suku. Huu fo nai mamana lino-nes ia, de ara ta raa-rinu fa.” ");
INSERT INTO rgu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Tehuu Yesus sipoꞌ asa nae, “Leo iaꞌ! Emi riꞌ mahao si!” Boe ma ara rafada Ni rae, “Ramatuaꞌ! Ta bisa leo naꞌ fa? Lahenda rifun lima lenaꞌ ia! Noi tou nara sira, bei ta rekeꞌ inaꞌ ara ro ana nara fa! Ma ita tanuu noi roti bibiaꞌ lima ma ikaꞌ boaꞌ dua. Tao leoꞌ bea fo ami bisa asa tamba seluꞌ nanaaꞌ ela fee lahenda ia ra?!” Tehuu Yesus nadenu si nae, “Ator lahenda ia ra fo ratuu rabua ao nara, lima hulu na bubuaꞌ esa.” ");
INSERT INTO rgu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Boe ma ara ator asa leo naꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ara ratuu ra ao nara, boe ma Yesus hai na roti kalimaꞌ sira ma ika kaduaꞌ ara. Basa de Ana nasare leo lalai neu, fo hule makasi. Ana tetebi roti ma ikaꞌ sira, boe ma loo si leo ana mana tuka dea nara reu fo babati fee lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Basa si raa losaꞌ rabete. Basa de ara rabubua ra nanaa lenaꞌ ara, henu lapaneu sanahulu dua. ");
INSERT INTO rgu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Laiꞌ esa de, nai mamanaꞌ esa Yesus hule-haradoi mesaꞌ ana. Huhule-haradoi basa, boe ma ana mana tuka dea nara mai rabua ron. Boe ma Ana natane si nae, “Emi mamanene lahenda rafada rae, Au ia nana bea?” ");
INSERT INTO rgu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ara rataa rae, “Ruma rae Papa nana Yohanis Mana Saraniꞌ a, ma ruma bali rae, baꞌi Elia. Taꞌa na, Manetualain mana nesi mata fai ulu nara, esa nasoda seluꞌ ria so.” ");
INSERT INTO rgu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Boe ma Yesus natane si bali nae, “Kalu tuka emi, sona Au nana bea?” Petrus nataa nae, “Papa nana Kristus, Lahenda fo Manetualain here memaꞌ Ana neme fai a ulu na mai so.” ");
INSERT INTO rgu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Boe ma Yesus horo si fo bosoꞌ tutui rae, Ria nana Kristus. ");
INSERT INTO rgu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Boe ma, Yesus dedea tamba seluꞌ bali nae, “Au ia, Ana Lahenda. Au lepa doidoso mabera rupaꞌ ara. Neuꞌ ko lahenda Yahudi ra lasi nara, malaka agama ra malaka nara, ma mesen agama ra ta nau sipoꞌ rae, Au ia, Kristus. Ma neuꞌ ko raisa Au. Tebe Au mate, tehuu fai binesa na, te Au asoda seluꞌ!” ");
INSERT INTO rgu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Boe ma Ana nafada lahenda kadodou inaꞌ ara nae, “Lahenda fo nau tuka Au, sona ana muste tuka nahani Au fai-faiꞌ. Ana muste tuꞌu heni ria hihii-nanau mesa na. Ana muste tuka naroo, leo mae lahenda nau raisa ni, sama leoꞌ lahenda nasaa na aikake na, fo leo mamana mamate na neu. ");
INSERT INTO rgu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Huu fo lahenda bea sadia nau mate nana huu ana tuka Au, neuꞌ ko ana hapu soda-moleꞌ manabasa taaꞌ a. Tehuu lahenda fo nau nasoda soa noi ria ao-ina heheli na, neuꞌ ko ana bika-bati neme Manetualain mai. ");
INSERT INTO rgu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Leo mae lahenda nanuu katemaꞌ dae-bafoꞌ ia oe isin, tehuu maneniko Manetualain tipa heni ni, sona sosoa-raraaꞌ taaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Au ia, Ana Lahenda. De lahenda maeꞌ nana huu tuka Au, ma maeꞌ nana huu homu Au nanori-nafadak, neuꞌ ko Au maeꞌ manaku ria nai Manetualain mata Na fai fo Au fali eme nusatetu-ikutemaꞌ a mai. Huu fo neuꞌ ko Au onda mai noo Papa kuasa marela-masaꞌan, sama-sama eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai. ");
INSERT INTO rgu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tetebes ara Au afada emi. Lahenda hida rai emi talada ia, neuꞌ ko rita Manetualain pareta nai dae-bafoꞌ a, besaꞌ ko ara mate.” ");
INSERT INTO rgu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Basa faiꞌ falu, boe ma Yesus leꞌo noo Petrus, Yohanis ma Yakobis de ae leo leteꞌ esa lain reu fo hule-haradoi. ");
INSERT INTO rgu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus bei hule-haradoi, te Ana narupa fekeꞌ, ma papake nara dadi fula makadila. ");
INSERT INTO rgu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kekeneu te, lahenda dua toda mai, de dedea ro Yesus. Sira dua nana baꞌi Musa no baꞌi Elia. ");
INSERT INTO rgu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sira kahereꞌ raan seli boe. Telu si dedea rao nara laꞌeneuꞌ Yesus neuꞌ ko mate Ni nai Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nate Petrus no nonoo kaduan sira suku renin. Ara kekera ao nara, te rita Yesus napadeiꞌ no lahenda dua. Ara rita Yesus narela-nasaꞌa nan seli. ");
INSERT INTO rgu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tehuu Petrus noi patararaaꞌ a, ana ta bubuluꞌ nae tao ubeaꞌ fa. De, baꞌi Musa no baꞌi Elia sakaꞌ laꞌo, boe ma ana dedea nafararaꞌu nae, “Ramatuaꞌ! Ami nai ia nonooꞌ nae malole na seli! De malole lenaꞌ ami tao ma laaꞌ telu. Esa fee Ramatuaꞌ *a, esa fee baꞌi Musa, ma esa bali fee baꞌi Elia.” ");
INSERT INTO rgu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tehuu ana bei dea-dea nae leoꞌ na, te oaꞌ esa onda mai napoti na si, de Petrus asa bii. ");
INSERT INTO rgu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Boe ma ara ramanene hara oeꞌ esa nemeꞌ oaꞌ ria daleꞌ mai nae, “Ia nana Au Ana teteka-hehere ka! Ana dedea, sona mamanene matalolole Ni!” ");
INSERT INTO rgu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dedea basa, boe ma Petrus asa rita noi Yesus mesaꞌ ana. Hata fo telu si rita ni a, ara ta tutui esa boeꞌ. Doo inaꞌ a besaꞌ ko ara tui lahenda fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Balahaaꞌ, boe ma Yesus no Petrus asa, onda reme leteꞌ ria lain mai, faiꞌ ria lahenda dodouꞌ mai raneta ro Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Boe ma lahenda esa naloo Ni nae, “Papa Mesen! Au hule fo mete-relu neuꞌ au ana mane ise ka dei! ");
INSERT INTO rgu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huu fo nitu ra heke ra ni, de ana kasi nabekeꞌ a, ma feen hela-hela mesan losa fudeꞌ ara reme bafa na mai. Nitu ria fepa-liꞌun, ma duduku-papauꞌ ana laꞌo naroo. ");
INSERT INTO rgu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au hule Papa ana mana tuka dea mara so, fo usi heni nitu ria, tehuu ta rala ni fa!” ");
INSERT INTO rgu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus nasapaa basa si nae, “Ae! Emi ta mamahere kalu Manetualain bisa puli na lahenda fa, do? Emi nana, iku a lahenda fo ta masoda malelaꞌ tuka eno roos a! Au muste anenete o emi losa fai hidaꞌ bali?” Boe ma Ana lipe aon de dedea no anaꞌ a papa na nae, “Moo ana ma leo iaꞌ mai!” ");
INSERT INTO rgu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ara roo anaꞌ a leo Yesus neu, boe ma nitu a lokopiro anaꞌ ria neuꞌ dae a, tao nan roroda-roroda mesan. Tehuu Yesus pareta nitu a fo kalua ela anaꞌ ria, boe ma anaꞌ ria teꞌe tutiꞌ a. Basa boe ma Yesus fee anaꞌ a leo papa na neu. ");
INSERT INTO rgu_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Lahenda fo rita Manetualain kuasa kaheren ria, basa si roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Fai fo basa lahenda ra bei dedea rao nara, laꞌeneuꞌ tanda heran fo Yesus tao a, Ana nafada ana mana tuka dea nara nae, ");
INSERT INTO rgu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Emi tanda mahere Au dedea ki ia! Ta dooꞌ a soꞌ, te lahenda nau seꞌo heni Au, Ana Lahenda ia. Boe ma ara fee Au leo lahenda fekeꞌ ara uu.” ");
INSERT INTO rgu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tehuu ana mana tuka dea nara roi patararaaꞌ a, ara ta bubuluꞌ duduꞌa-aafin fa. Ara boe biiꞌ ratane hata ria sosoa-raraan ubeaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Laiꞌ esa de, Yesus ana mana tuka dea nara mulai ralelena aoꞌ laꞌeneuꞌ neme sira mai neuꞌ ko bea rina dadi neuꞌ lahenda masososaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tehuu Yesus bubuluꞌ hata fo sira ralelena aoꞌ ana. Ana naloo na ana aanaꞌ esa, de fee ni napadei neuꞌ boboa Na. ");
INSERT INTO rgu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Boe ma Ana nafada si nae, “Nenene matalolole! Lahenda fo tuka Au ma nalalau lahenda aanaꞌ a sama leoꞌ anaꞌ ia, sona sosoa na nae, ana nalalauꞌ Au ria boe. Ma ria boe nalalau Au Papa Ka nai nusatetu-ikutemaꞌ, fo riꞌ nadenu Au leo dae-bafoꞌ ia mai. Lahenda dodouꞌ ta tao hihika-rerekeꞌ neuꞌ lahenda manatoꞌa-manataꞌ, masala-masikoꞌ ma ua soe ra. De, lahenda fo nahiiꞌ nalalau lahenda rupa leo naꞌ a, sona Manetualain tao si reuꞌ lahenda manuu hadaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Boe ma Yohanis nafada Yesus nae, “Ramatuaꞌ! Laiꞌ esa de, ami mita lahenda esa usi heni nitu, ma ana seseiꞌ Papa nade ma. De, ami horo ni fo bosoꞌ seseiꞌ Papa nade ma, nana huu ita lahendan ta ria fa.” ");
INSERT INTO rgu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tehuu Yesus nataa si nae, “Bosoꞌ horo si! Huu fo bea ta nalena laka neuꞌ ita fa, sona ita lahendan sira.” ");
INSERT INTO rgu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus bubulu nae, Ria fai hehene-aaen leo nusatetu-ikutemaꞌ a neu, naneneaꞌ so. Boe ma Ana naetuꞌ nan fo leo Yerusalem neu. ");
INSERT INTO rgu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana nadenu lahenda reu raꞌuluꞌ asa, ela ara bisa ator nanaa-nininuꞌ. Boe ma ara masoꞌ leo koroꞌ esa reu nai propinsi Samaria, fo sadia mamanaꞌ ofu. ");
INSERT INTO rgu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tehuu lahenda Samaria ra ta nau sipoꞌ Yesus asa fa, nana huu Ana neu doꞌo-tabe Manetualain nai kota Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yakobis no Yohanis ramanene lahenda Samaria ra nonoi-tatao nara, boe ma ara leleꞌo Yesus rae, “Ramatuaꞌ! Leoꞌ bea na ita hule Manetualain fee aipilaꞌ a neme lalai mai, fo ela naa heni si?” ");
INSERT INTO rgu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tehuu Yesus nasare na dua si, ma nasaꞌai si nae, “Bosoꞌ tao aafi leo naꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Boe ma ara leo koro fekeꞌ reu. ");
INSERT INTO rgu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ara laꞌo-laꞌo rai eno taladaꞌ, te lahenda esa dedea no Yesus nae, “Ramatuaꞌ! Leo beaꞌ muu boe oo, au tuka ahere O!” ");
INSERT INTO rgu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tehuu Yesus nataa ni nae, “Malole a boe! Tehuu mafarereneꞌ leo iaꞌ. Basa lahenda ma banda ra, esaꞌ ko ranuuꞌ mamana leleon. Busa fuiꞌ ara fali leo bolo nara reu, manupuiꞌ ara fali leo runu nara reu. Tehuu Au, Ana Lahenda ia, ta anuu uma fo fali naꞌ uu fa. Ainulu lakaꞌ boe taꞌa.” ");
INSERT INTO rgu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Laiꞌ esa de Yesus naloo na lahenda fekeꞌ esa nae, “Mai tuka Au, fo dadi muuꞌ Au lahenda ki.” Lahenda ria nataa nae, “Neu! Tehuu leo iaꞌ Ramatuaꞌ. Ela au fali fo afaduli a ina-ama kara dei. Maneniko au papa ka mate ni sona, besaꞌ ko au tuka.” ");
INSERT INTO rgu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tehuu Yesus nafada ni nae, “Leo iaꞌ! Nemeꞌ na ela lahenda fo ta nanuu namahereꞌ neuꞌ Manetualain, rafaduli sira lahenda mana mate nara. Tehuu lahenda fo namahere neuꞌ Manetualain, emi nonoi laka ma riꞌ meu tui-beka laꞌeneuꞌ Manetualain hohomu pareta Na.” ");
INSERT INTO rgu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lahenda esa bali sona nae, “Malole a Ramatuaꞌ! Au nau tuka ahere Ramatuaꞌ *a. Tehuu poꞌi au fo uu deꞌi a teꞌa kileoboboki kara dei, besaꞌ ko au fali mai tuka Ramatuaꞌ *a.” ");
INSERT INTO rgu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Boe ma Yesus nafada ni nae, “Leo iaꞌ! Maneniko lahenda foi na dae a so, tehuu nasapute nonoi fekeꞌ, losaꞌ nafarene heni seseleꞌ a, sona oka-tinen ta dadi fa. Leoꞌ na boe lahenda fo naetuꞌ nan nau tuka Au, tehuu nafarene noi soda maꞌulu na, sona ana ta naraa dadi neuꞌ Manetualain atan fo nalalau basa lahenda rai Ria pareta na.” ");
INSERT INTO rgu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Basa ria, boe ma Yesus here na ana mana tuka dea fekeꞌ hitu hulu dua. Ana nadenu si laꞌo dua-dua raꞌuluꞌ leo mamanaꞌ fo Ana sakaꞌ neuꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ana nadenu si nae, “Hapu lahenda dodouꞌ sama leoꞌ hade modo pedaꞌ a. Rahani noi manuu okaꞌ a nadenu lahenda mana noi nara mai oru. De, emi muste hule-haradoi neuꞌ Manetualain fee tamba seluꞌ lahenda mana noi nara ela rabubua ra lahenda fo nau tuka Au a. Nana huu lahenda fo nau tuka Au a, dodou inaꞌ. Tehuu lahenda mana noi noi baianaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Besaꞌ ia emi meu leo! Au adenu emi fo leo lahenda kadodou inaꞌ ara meu. Tehuu mafarereneꞌ leo iaꞌ. Emi sama leoꞌ bibi-lopo anaꞌ dale balaroe-balanauꞌ a, leo busafui maꞌaaꞌ ara talada meu. ");
INSERT INTO rgu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Emi bosoꞌ meni doiꞌ, tas bua-loas, do sandaal lenaꞌ nai enoꞌ. Bosoꞌ tutuꞌu ledo-fai fo mateꞌa lahenda nai eno taladaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Maneniko masoꞌ leo koroꞌ esa meu, emi bosoꞌ boe lali meme uma esa mai leo uma fekeꞌ meu. Maneniko lahenda sipoꞌ emi no malole nai uma esa, sona leo meuꞌ na, losaꞌ emi laꞌo ela koroꞌ ria. Maneniko masoꞌ leo uma esa meu, emi muste hule fo Manetualain fee ua-naleꞌ neuꞌ lahenda rai uma ria daleꞌ. Maneniko manuu umaꞌ ria, sipoꞌ emi no malole, tantu Manetualain natudu dale malole Na neuꞌ uma isiꞌ sira. Tehuu maneniko ara ta nau sipoꞌ emi, sona nemeꞌ na fo ela Manetualain natudu fee noi emi dale malole Na. Maneniko emi masoꞌ leo uma esa, do koroꞌ esa meu, fo ara fee emi ubeaꞌ na mia-minu. Sipoꞌ no dale namahoꞌo, huu fo naraa ara fee emi leoꞌ na ela kati neuꞌ sosota mara. ");
INSERT INTO rgu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Puli ma lahenda kamahedis nara. Ma mafada si mae, ‘Manetualain pareta na nai mata so!’ ");
INSERT INTO rgu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tehuu koroꞌ ruma lahenda nara ta nau sipoꞌ emi boeꞌ. Maneniko ara tao emi leoꞌ na, sona meu mapadeiꞌ nai koroꞌ ria eno na fo dedea mae, ");
INSERT INTO rgu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nenene matalolole! Ami meni Manetualain Hara-dasin mai fee emi, tehuu emi ta nau tao daleꞌ neu fa. De, besaꞌ ia ami sasapu heni koroꞌ ia afu na nai ami ei mara, fo dadi tanda nae, neuꞌ ko emi lepa-masaa ao mara mana dadiꞌ a! Tehuu mafarereneꞌ matalolole! Manetualain pareta na nai dae-bafoꞌ a naneneaꞌ so!’ ");
INSERT INTO rgu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Emi bubuluꞌ kota Sodom a tadalu na, hete? Au afada emi! Neuꞌ ko naraa laꞌe dae-bafoꞌ a nonoe na, te lahenda fo ta sipoꞌ emi a, Manetualain huku si beraꞌ lena lahenda Sodom ara huhukun!” ");
INSERT INTO rgu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus dedea tamba seluꞌ nae, “Emi fo nai koro Korasin ma koro Betsaida besa-besa! Soe a laꞌe emi! Au tao tanda heran rupaꞌ ara nai emi mata mara so, tehuu ta nau mamahere neuꞌ Manetualain fa. Sekonaa te emi nana lahenda Yahudi fo manaku mae malelaꞌ Ana. Tehuu uniꞌ ko leo tanda heran fo Au tao ni nai emi koro mara laꞌe nai kota Tirus no Sidon, tantu doo basa ia nana lahenda fo rai na saledale-tuꞌetei nara, de ratafali fo tuka Manetualain. Ma tantu ara pake kakao-papake susa, ma tao afu neuꞌ laka nara, fo dadi tanda nae, ara saledale-tuꞌetei nara so. Sekonaa te lahenda Tirus asa ro Sidon asa nana lahenda ta Yahudi fa fo manaku rae ralelaꞌ neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tebe! Emi mete leo! Neuꞌ ko Manetualain naetuꞌ basa lahenda ra dedea nara, lahenda Tirus asa ro Sidon asa huhuku nara bei kafaꞌ a reme emi huhuku mara mai. ");
INSERT INTO rgu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Koro Kapernaum lahendan emin, besa-besa! Emi bosoꞌ mae, neuꞌ ko Manetualain hehene-naaeꞌ emi leo nusatetu-ikutemaꞌ a meu. Taꞌa! Neuꞌ ko Manetualain tuꞌu emi leo naraka a meu! ");
INSERT INTO rgu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mafareneꞌ matalolole! Te lahenda bea ramanene neuꞌ emi, sama leoꞌ ara ramanene neuꞌ Au. Ma lahenda bea ta nau ramanene neuꞌ emi, sama leoꞌ ara ta nau ramanene neuꞌ Au. Leoꞌ na boe, lahenda bea ta nau ramanene neuꞌ Au fa, sama leoꞌ ara ta nau ramanene neuꞌ Manetualain fo riꞌ nadenu Au leo dae-bafoꞌ ia mai.” ");
INSERT INTO rgu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tepoꞌ fo lahenda nadedenu kahitu hulu duaꞌ ara fali mai si, dale nara ramahoꞌo raan seli. Ma ara tui Yesus rae, “Awi! Kahereꞌ leon! Tepoꞌ fo ami pake Ramatuaꞌ *a nade ma de usi nitu ra, ara ramanene ami. Boe ma ara kalua tutiꞌ a! Talalu na!” ");
INSERT INTO rgu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Boe ma Yesus nataa si nae, “Tebe! Tepoꞌ fo emi tao leo naꞌ, Au ita Manetualain tuꞌu heni nitu ra roo sira malaka na reme lalai mai, sama leoꞌ relas a nahate iiꞌ-onaꞌ! ");
INSERT INTO rgu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mafarereneꞌ! Malaka nitu, nana ita musunoon. Ma nanuu kuasa boe! Tehuu Au fee emi kuasa so fo ela maseki ria kuasa na. Ma uniꞌ ko leo emi molo laꞌe meke marasoꞌ, do uraꞌ, tehuu ta hata-hata esa boeꞌ. Ta hapu esa tao soe neuꞌ emi boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Emi dale mara ramahoꞌo, huu fo nitu ra ramanene neuꞌ emi. Malole a boe, tehuu hihii-nanauꞌ aanaꞌ ria! Malole lenaꞌ emi dale mara ramahoꞌo, huu fo Manetualain duiꞌ na emi nade mara so, ela dadi meuꞌ Ria lahendan fo masoꞌ leo nusatetu-ikutemaꞌ a meu.” ");
INSERT INTO rgu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tepoꞌ ria, Manetualain Dula-dale Malalao-malafu Na tao na Yesus dale Na namahoꞌo. Basa boe ma Ana io-oa neuꞌ Manetualain nae, “Papa! Papa nana Ramatua nai lalai ma dae-bafoꞌ a. Au hule makasi dodouꞌ, nana huu Papa mafuni basa hihii-nanauꞌ ia ra neuꞌ lahenda fo nae ria malelaꞌ ma mana koaoꞌ ara. Tehuu Papa matudu hihii-nanauꞌ ia ra fee ana aanaꞌ ara ro lahenda maloe-madae aoꞌ ara. Tebe, Papa! Huu fo ria riꞌ tao na Papa dale ma namahoꞌo!” ");
INSERT INTO rgu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Basa boe ma Yesus nafada lahenda kadodou inaꞌ ara nae, “Nenene, o! Au Papa Ka nai nusatetu-ikutemaꞌ a fee Au kuasa a katemaꞌ so.” Noi Au Papa ka riꞌ bubuluꞌ matetuꞌ nae, Au ia nana bea. Ma noi Papa Ana na fo riꞌ Au ia, bubuluꞌ matetuꞌ ae, Papa nana bea. Ma Au here lahenda fekeꞌ, fo afada si, ela ara ralelaꞌ Ana boe.” ");
INSERT INTO rgu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Basa boe ma Yesus nasare na ana mana tuka dea nara, ma nafada si nae, “Emi maua-manale matetuꞌ, huu fo emi mita Manetualain kuasa na so. ");
INSERT INTO rgu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Maneꞌ ara ro mana nesi mata faiuluꞌ ara rahiiꞌ raan seli nau rita hata fo emi mita ni, tehuu ara ta bisa fa. Sira boe rahiiꞌ raan seli nau ramanene hata fo emi mamanene ni, tehuu ara ta bisa fa.” ");
INSERT INTO rgu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Laiꞌ esa de, mesen agama esa foa napadeiꞌ fo nau nahihiiꞌ Yesus. Ana natane nae, “Papa Mesen! Mafada fee au dei! Au muste tao ubeaꞌ, fo ela au bisa asoda aroo sama-sama o Manetualain nai nusatetu-ikutemaꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus nataa nae, “Baꞌi Musa duiꞌ ubeaꞌ laꞌeneuꞌ hihii-nanauꞌ ia? O bubuluꞌ ma leo beaꞌ ana?” ");
INSERT INTO rgu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lahenda ria nafada nae, “Ana duiꞌ, nae: ‘O muste sue neuꞌ Manetualain, o Malaka ma, lena neme basa-basan mai. Huu ria na, o muste mahiiꞌ Ana naroo, moi-tao mahere fo tuka Ria hihii-nanaun, ma malelaꞌ Ana.’ Hapu mana duiꞌ boe nae, ‘O muste sue toranoo mara, sama leoꞌ o sue-lai ao-ina heheli ma.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus sipoꞌ natafali nae, “Tebe! Maneniko o tao tuka ria, sona o masoda maroo mo Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tehuu lahenda ria nau tao aon leoꞌ lahenda roos a. Basa boe ma ana natane Yesus nae, “Tehuu, au ‘toranoo’ kara nana siꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus nataa nae, “Leo iaꞌ! Au nau afada dedea nasasamaꞌ esa. Neuꞌ ko o mafada, mae ‘toranoo’ tetea ma riꞌ bea. Tutui na leo iaꞌ: Lahenda Yahudi esa neme kota Yerusalem mai, onda leo Yeriko neu. Tehuu kekeneu te, parampok ara mai de rafaraꞌu raan. Ara popoꞌo ni, ma roso reni doi nara roo bua-loa nara katemaꞌ. Boe ma ara tuꞌun neuꞌ enoꞌ a suu na, de foa ela ni. Lahenda ria noi hahae na so. ");
INSERT INTO rgu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tehuu ta bubuluꞌ fa, te malaka agama Yahudi esa onda mai nesiꞌ na boe. Ana nita lahenda ria hina-hinaꞌ mesan, ma leka-leka nai enoꞌ a suu na, tehuu ta nateꞌe fo tulu-fali nan fa. Ana heo heni aon de laꞌo naroo. ");
INSERT INTO rgu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta doo bea boeꞌ, te lahenda fekeꞌ esa nesiꞌ na boe. Ria nana, lahenda neme Lewi leo na mai, biasa ana tulu-fali nai Manetualain Uma Mamaso Ina na daleꞌ. Ana bei nita lahenda ria leka-leka nai enoꞌ a suu na, boe ma tuturu mata neu bebesa ni, tehuu ana ta tulu-falin fa. Tutiꞌ a ana heo heni aon de laꞌo naroo. ");
INSERT INTO rgu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Ta doo bea boeꞌ, te lahenda esa neme nusa Samaria mai no keledei na nesiꞌ na. Ita basa bubuluꞌ tae, lahenda Yahudi ra biasa relu lahenda Samaria ra sona reniꞌ mata iko nara. Lahenda Samaria ia nita lahenda fo riꞌ parampok ara popoꞌon, ma roso reni hata nara a, boe ma noi sueꞌ ana, de naneneaꞌ mata neu ela tulu-fali ni. Ana safe makamomoi lahenda ria hina nara neniꞌ anggor, basa de tao mina neu, ma feo etu si. Boe ma fua nan neuꞌ keledei na lain, de noon leo kota daleꞌ neu. Ana fee lahenda ria leo lalai neuꞌ uma ofu esa, ela nafaduli natalolole ni. ");
INSERT INTO rgu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Balahaaꞌ, boe ma lahenda Samaria a fee lalai tali, doifulaꞌ dua neuꞌ manuu umaꞌ ria, ma nafada ni nae, ‘Pake doiꞌ ia ra fo mafaduli matalolole lahenda hedis ia losaꞌ teꞌe na aon. Maneniko ta dai fa, sona papa pake lalai doi mi dei. Faiꞌ bea au atafali mai, neuꞌ ko au kati faliꞌ papa doi mara katemaꞌ asa.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus dedea nasasama na teꞌe naꞌ so. Basa de Ana natane lahenda malela hohoro-lalaneꞌ ria nae, “Tuka o sona, ‘toranoo’ tetea ma riꞌ bea, soa neuꞌ lahenda fo bisinaꞌ a, parampok ara ralea reni hata nara a?” ");
INSERT INTO rgu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lahenda ria nataa nae, “Tantu, lahenda fo nanuu dale kasian neuꞌ ana a.” Yesus nae, “Tebe, aꞌa! Muu fo tao tuka ria leo.” ");
INSERT INTO rgu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Basa ria, boe ma Yesus no ana mana tuka dea nara laꞌo raroo leo Yerusalem reu. Ara tuli koroꞌ esa. Nai na hapu inaꞌ esa nade Marta ma toranoo na nade Maria. Marta hule Yesus asa fo tuli uma na. Yesus nanori-nafada si, de Maria natuuꞌ nanenea nai Yesus ei Na fo namanene Dedea-nafadan. Tehuu Marta sona nasapute nalisu tasaꞌ nai dapu daleꞌ. Ta doo bea boeꞌ, te ana masoꞌ mai de namumuu neu Yesus nae, “Ramatuaꞌ! Leo beaꞌ ia! Au asapute no nalisu tasaꞌ a, ma au fadi ka natuuꞌ hihiiꞌ maiꞌ ia. Mafada ni dei! Ela ana fali au nai dapu daleꞌ bai!” ");
INSERT INTO rgu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Boe ma Ramatua Yesus nataa ni nae, “Marta, Marta. O masapute marooꞌ a, daleꞌ ma dodaaꞌ neuꞌ hihii-nanauꞌ rupaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tehuu hihii-nanauꞌ esa lena heni, riꞌ Maria here na hihii-nanauꞌ ia malole inaꞌ, huu fo ana natuuꞌ ma namanene Au Dedea-nafada Ki. Lahenda ta bisa ralea ra Dedea-nafadaꞌ sira reme ana mai fa.” ");
INSERT INTO rgu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Laiꞌ esa de, Yesus neu hule-haradoi. Ana hule-haradoi basa, boe ma ana mana tuka dea Ni esa mai de hulen nae, “Ramatuaꞌ! Yohanis Mana Saraniꞌ a nanori ana mana tuka dea nara, de ara hule-haradoi ralelaꞌ. Ami hule fo Ramatuaꞌ *a *boe manori ami huhule-haradoiꞌ dei!” ");
INSERT INTO rgu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Boe ma Yesus nafada si nae, “Malole a! Hule-haradoi sona mae leoꞌ ia: ‘O, Amaꞌ! Nade ma malalao-malalafuꞌ. Ela leoꞌ bea na basa lahenda ra io-oa Amaꞌ a nade marela-masaꞌam. Ela leoꞌ bea na Amaꞌ a dadi Maneꞌ fee basa lahenda ra. ");
INSERT INTO rgu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amaꞌ, bati-pala fee ami nanaa-nininuꞌ mananoꞌu-manadaiꞌ nai tuka-tuka faiꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma fee ampon neuꞌ ami sala-sikom, sama leoꞌ ami boe fee ampon neuꞌ lahenda fo rasala ro ami a. Amaꞌ, manea ami fo ela ami bosoꞌ tao salaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Boe ma Yesus nanori tamba si laꞌeneuꞌ huhule-haradoiꞌ. Ana pake nasasamaꞌ nae, “Uniꞌ ko leo fatilada na tia-lai esa neme dooꞌ a mai, de hule fo suku neuꞌ o uma ma. Tehuu ta manuu hata-hata esa boeꞌ, fo fee ni naa. Boe ma o leo tia-lai feke ma uma na muu, de maloo meme deaꞌ mai mae, ‘Aꞌa, e! Fee lalai au roti baloꞌ telu dei! Huu fo fui nai au uma ka, tehuu ami ta hata esa boe! Aꞌa, fali ma au dei! Noi baloꞌ teluꞌ a! Au dei kati!’ ");
INSERT INTO rgu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bate neuꞌ ko tia mi ria nataa nae, ‘Aꞌa ka boe, na! Lahenda suku-soꞌo, tehuu aꞌa ka oda fafae-fafaeꞌ a! Lelesu ra mana koe naisaꞌ, so! Anaꞌ ara suku ramanee so. Bosoꞌ mamanasaꞌ, e! Fai fekeꞌ dei, aꞌa!’ ");
INSERT INTO rgu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mafarereneꞌ matalolole. Leo mae lahenda ria ta nau foa fo fee o fa, huu no o nana ria tia-lain, tehuu maneniko o hule maroo, tantu ana foa fo fee. ");
INSERT INTO rgu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Leoꞌ na boe, huhule-haradoiꞌ a. Hule maroo neuꞌ Ramatuaꞌ a; neuꞌ ko Ana fee. Saka maroo; neuꞌ ko Ana natudu enoꞌ a. Maloo maroo; neuꞌ ko Ana soi lelesu a. ");
INSERT INTO rgu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Te basa lahenda fo hule raroo neuꞌ Manetualain, neuꞌ ko ana sipo. Bea saka naroo, neuꞌ ko hapu. Bea naloo naroo, neuꞌ ko Ana soi lelesu a. ");
INSERT INTO rgu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Soba emi afi! Hapun nai bea, anaꞌ a hule ikaꞌ, sona papa na feen meke? ");
INSERT INTO rgu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Do, kalu anaꞌ a hule manutoloꞌ, sona feen uraꞌ? Leo mae leoꞌ bea boe, taꞌa hete? ");
INSERT INTO rgu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Iku lahenda dae-bafoꞌ a nana memaꞌ tadaluꞌ a. Tehuu emi Papa ma nai nusatetu-ikutemaꞌ a, memaꞌ tebe-tebe malole a. De, maneniko lahenda tadaluꞌ rupaꞌ emi a, mahiiꞌ fee ana mara hata malole, sona Papa lena ria bali! Ana ta fee noi hata fo emi parluu, tehuu lena neme naꞌ mai, Ana fee Ria Dula-dale Malalao-malalafu Na neuꞌ lahenda fo hule Ni a.” ");
INSERT INTO rgu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Laiꞌ esa de, Yesus usi heni nitu neme lahenda pakanaꞌ esa mai. Boe ma lahenda ria mulai dedea seluꞌ. Lahenda fo rai na roi ramakokoaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tehuu ruma rae, “Tebe sotee, Ana bisa usi nitu! Huu fo Ana hapu kuasa neme malaka nitu mai, riꞌ Balsebul.” ");
INSERT INTO rgu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lahenda fekeꞌ ara nau soba Yesus. Basa boe ma ara hule fo Ana tao tanda heran esa bali ela natudu si nae, Ria kuasa Na neme Manetualain mai. ");
INSERT INTO rgu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tehuu Yesus bubuluꞌ sira duduꞌa-aafi tadalu nara. Boe ma Ana dedea nae, “Maneniko nai nusaꞌ esa daleꞌ ana raun ara, ratati ao, tantu nusaꞌ ria nalulutuꞌ. Leoꞌ na boe, maneniko nai uma esa daleꞌ uma isi nara esa no esa ralelena aoꞌ raroo, sona tantu uma ria daleꞌ esa ta neu esa daleꞌ boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Maneniko nituꞌ a usi seluꞌ nitu, sona sira malaka na homu pareta ta namanoso fa! De, emi mae Au usi nitu pake nitu a kuasa na, sona ta laꞌe fa! ");
INSERT INTO rgu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mafarereneꞌ! Emi lahenda mara boe usi ralelaꞌ nitu, tehuu ta pake nitu a kuasa na fa. De, emi bosoꞌ dedea mafararaꞌuꞌ mae, Au usi nitu pake nitu a kuasa na. De, emi sale Au, tehuu neuꞌ ko emi lahenda mara siꞌ raetuꞌ rae, emi riꞌ sala. ");
INSERT INTO rgu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Maneniko tetebes ara Au usi nitu pake Manetualain kuasa na, ria natudu nae, Manetualain pareta na nai dae-bafoꞌ a naneneaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Maneniko lahenda baraꞌai inaꞌ esa pake tee-tafaꞌ, fo nanea neniꞌ uma na, tantu hata-heto nara ta mopo fa. ");
INSERT INTO rgu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tehuu maneniko lahenda esa baraꞌai na lena ria mai suu ni boe ma nasekin, sona roso reni lahenda ria tee-tafa nara. Ma huru reni hata-heto nara fo reu babati fee ana mana tuka dea nara. Doo-naru basa ia lahenda baraꞌai inaꞌ masososaꞌ ria tai-namahena neuꞌ ria tee-tafa nara. Tehuu besaꞌ ia ana ta bisa tai-namahena tee-tafaꞌ sira so. ");
INSERT INTO rgu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mafarereneꞌ matalolole! Lahenda fo ta sama-sama no Au fa, ria nana Au musunoo kara. Ma lahenda fo ta nau tulu-fali nai Au nonoi-tatao ki, sona ana nalai heni aon.” ");
INSERT INTO rgu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus dedea tamba seluꞌ bali nae, “Maneniko ita usi heni nitu a neme lahenda esa mai, sona ana leo mamana lino-nees a neu fo saka mamana hahaeꞌ. Huu no ana ta hapu mamanaꞌ fo naraa fa, boe ma ana afi nae, ‘Ee! Ta hapu mamanaꞌ fa leoꞌ ia, de malole lenaꞌ au fali uu leo seluꞌ nai lahenda mauluꞌ ria.’ ");
INSERT INTO rgu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Basa de ana fali, boe ma naneta noi mamanaꞌ ria, makamoiꞌ a ma mana ator matalololeꞌ so. ");
INSERT INTO rgu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Boe ma nitu ria neu naloo na nonoon hitu fo makaresiꞌ lena heni ria bali. Boe ma basa si reu leo nai lahenda ria, ara duduku-papauꞌ ana. De, besaꞌ ia lahenda ria masoda na soe lena bali.” ");
INSERT INTO rgu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus bei dedea no lahenda kadodou inaꞌ sira, te inaꞌ esa nai na ana naloo nae, “O mama Ma naua-nanale bau-ina, huu fo ana boki ma anutu na!” ");
INSERT INTO rgu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus nataa nae, “Tebe, mama! Tehuu maua-manale bauinaꞌ lena ria bali, nana lahenda fo namanene Manetualain Hara-dasin, ma ana tao tukan!” ");
INSERT INTO rgu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Faiꞌ fo Yesus bei dedea, nana lahenda dodouꞌ rarurupu eo raa Ni. Boe ma Ana dedea nae, “Lahenda besaꞌ ia ra, ralelaꞌ noi tatao tadaluꞌ a. Ara hule kokosen Au fo tao fee si tanda heran, ela ara bubuluꞌ rae Au ia, nana tetebes ara Manetualain lahendan. Sekonaa te fai a ulu na Manetualain fee si tanda heran so, pake mana nesi matan Yunus. Ria dai so! ");
INSERT INTO rgu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fai a ulu na Yunus nafada kota Niniwe lahenda nara nae, saledale-tuꞌetei mara dei. De, fai a ulu na hata fo dadi neuꞌ Yunus, dadi tanda soaneuꞌ asa nae, Manetualain riꞌ nadenu ni. Leoꞌ na boe neuꞌ Ana Lahenda. Au mai afada emi fo muste saledale-tuꞌetei mara. De, hata fo dadi neuꞌ Au, neuꞌ ko dadi tanda soaneuꞌ lahenda besaꞌ ia ra nae, tebe Manetualain riꞌ nadenu Au. ");
INSERT INTO rgu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Neuꞌ ko losa dae-bafoꞌ a nonoe na, maneniko Manetualain dadi neuꞌ Mana ee dedeaꞌ, neuꞌ ko ina maneꞌ neme ona mai, ana nasoda seluꞌ, fo dadi sakasii. Ana neo mata-mata emi basa fo riꞌ masoda nai besaꞌ ia nae, ‘Emi nana koa-pakanaꞌ!’ Huu fo faiꞌ a ulu na, ina maneꞌ ria neme dooꞌ a mai ela nita mataꞌ maneꞌ Soleman malela na. Sekonaa te, besaꞌ ia Lahenda esa nai emi talada malela Na lena heni mane Soleman. Tehuu emi ta nau tao daleꞌ neu Ana fa! ");
INSERT INTO rgu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma ta noi mesaꞌ ana fa! Neuꞌ ko lahenda reme Niniwe mai boe, ara neo mata-mata emi fo riꞌ masoda besaꞌ ia rae, ‘Emi nana koa-pakanaꞌ!’ Ara rae leoꞌ na, nana huu tepoꞌ fo Yunus neu nafada si Manetualain hihii-nanaun, boe ma ara saledale-tuꞌetei nara. Sekonaa te, besaꞌ ia Lahenda fo lena heni Yunus nana nai emi talada, tehuu emi ta nau saledale-tuꞌetei mara fa!” ");
INSERT INTO rgu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus tuti seluꞌ dedea Na nae, “Lahenda dede na dedede teioeꞌ a, basa nana fua ni neuꞌ mamana madema, ela nahaa nai kama ria daleꞌ fee basa lahenda fo kodi naꞌ reu a. Ta hapu lahenda dede na dededeꞌ a, sona tatana etu ni neniꞌ lapaneu, do nafuni naisaꞌ ana. Ria sosoa-raraan taꞌa! ");
INSERT INTO rgu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Emi mata mara boe sama leoꞌ dededeꞌ a. Ana nahaa-nakaledo nai emi dale mara. Maneniko mataꞌ a maꞌiu, sona lahenda mete basa-basan neniꞌ dale tadaluꞌ a. Tehuu maneniko mataꞌ a makaledoꞌ a, sona lahenda mete basa-basan neniꞌ dale malole a. ");
INSERT INTO rgu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Afi fo ela makaledoꞌ fo nai emi dale mara a, nahaa naan seli, sama leoꞌ ledo a. Makaledoꞌ fo nai emi dale mara a, bosoꞌ sama leoꞌ bulaꞌ a haa na, fo noi nasararaaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Maneniko emi dale mara makaledoꞌ a, losaꞌ ta hapu lela anaꞌ esa maiuꞌ a boeꞌ, tantu katemaꞌ emi masoda ma boe makaledoꞌ a, sama leoꞌ dedede bauinaꞌ a nahaa fee emi masoda ma.” ");
INSERT INTO rgu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus dedea basa, boe ma lahenda agama Farisi esa, ana hule Ni fo mai naa-ninu nai uma na. Losa na, boe ma Yesus kodi leo uma daleꞌ neu de natuuꞌ nai mei nanaaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tehuu manuu umaꞌ a heran, nita Yesus naa-ninu ta safe nauluꞌ lima na, tuka lahenda Farisi ra atoran a. ");
INSERT INTO rgu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Basa boe ma, Yesus nafada ni nae, “Emi lahenda Farisi ra kahereꞌ! Emi homu mahere atoran agama ma! Emi mafarereneꞌ safe noi bika-galas ara dea nara losaꞌ makadilaꞌ a, tehuu ta mafarene fo safe makamomoi emi dale makekeo-makakanum fo riꞌ tadaluꞌ ma mana tendetuuꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Koa-pakanaꞌ, emin! Bosoꞌ mafarene henin. Manetualain adu na pooꞌ dea, ma Ana adu na pooꞌ dale boe. ");
INSERT INTO rgu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tehuu malole lenaꞌ, emi fee lahenda kasian ara neme hata fo manuu ni, ela emi bisa makamoiꞌ a nai Manetualain mata Na. ");
INSERT INTO rgu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lahenda Farisi emin! Neuꞌ ko emi hapu soe! Laꞌeneuꞌ fee Manetualain babatiꞌ esa neme babatiꞌ sanahulu mai, emi bareken basa-basan, aana-bauinaꞌ. Losa leo bumbu aanaꞌ neme oka-tine mara mai boe, emi bareken mamateꞌ! Tehuu emi ta tao daleꞌ neuꞌ hihii-nanauꞌ fo lena heni a. Laꞌeneuꞌ hata fo sue Manetualain, ma hihii-nanauꞌ fo beibeberaꞌ a, nana emi mafarene heni si! Tebe ita muste fee taroo Manetualain nuu babati na neu, tehuu bosoꞌ mafarene heni hata fo lena heni a. ");
INSERT INTO rgu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Neuꞌ ko emi hapu soe! Huu no emi mahiiꞌ saka mamana malole inaꞌ nai uma mamasoꞌ dale, ma mahiiꞌ saka hada-horomata a nai mamanaꞌ fo soaneuꞌ basa lahenda ra. ");
INSERT INTO rgu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Neuꞌ ko emi hapu soe! Huu no emi sama leoꞌ rates mana lutu taaꞌ. Lahenda laꞌo resiꞌ na, tehuu ara ta bubuluꞌ rae, rates nai na, nana huu dae fo nai rates lain makamoiꞌ a, tehuu nai daleꞌ naboo puru. Sekonaa te tuka ita hada na, lahenda fo molo neuꞌ rates a fo tao nakekeo ria ao-ina na, de ta naraa masoꞌ leo uma mamasoꞌ daleꞌ neu fa. Emi lahenda Farisi ra sama leoꞌ rates ria! Nai dea mara sona nonooꞌ nae emi makamoiꞌ a naan seli. Tehuu nai emi dale mara henuꞌ no hihii-nanauꞌ maboo puruꞌ a. Lahenda fo raneneaꞌ ro emi a rakekeo-rakakanu boe.” ");
INSERT INTO rgu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lahenda malela atoran agama Yahudi esa nai na, ana naraufako Yesus dedea na nae, “Papa Mesen! Bisinaꞌ a Papa dedeam sira, liꞌu laꞌe ami boe!” ");
INSERT INTO rgu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tehuu Yesus sipoꞌ ana nae, “Tebe! Emi lahenda malela atoran agama Yahudi ra, ela emi hapu soe boe! Emi ta tulu-fali lahenda, ma tao mamakafa ria masoda na, tehuu emi tao tamba fee si susa neniꞌ emi tao atoran agama mabera a. Basa nana fee lahenda lepa emi atoran rupa mara. Tehuu emi ta lepa soba maneni lelepa mabera ria meniꞌ lima uꞌu esa boeꞌ! ");
INSERT INTO rgu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Neuꞌ ko emi hapu soe! Huu no emi masapute lutu rates fee Manetualain mana nesi mata fai ulu nara, fo fee hadaꞌ neuꞌ asa. Sekonaa te, emi bei-baꞌi mara riꞌ raisa mana nesi mata sira! ");
INSERT INTO rgu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Emi boe eiꞌ esa mo bei-baꞌim sira. Ara tipa heni Manetualain manesimata nara, ma raisa si. Basa boe ma emi lutu rates fee manesimata sira, fo dadi tanda nae, emi boe sipoꞌ no malole bei-baꞌim sira. ");
INSERT INTO rgu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Huu ria na, Manetualain fo riꞌ bubuluꞌ basa-basa ni a, parna nafada nae, Neuꞌ ko Au adenu mana nesi mata kara, ma lahenda nadedenu fekeꞌ ara fo leo lahenda dae-bafoꞌ a mai. Basa, te lahenda sira ese-rumu ramiminaꞌ ruma, ma raisa ruma.’ ");
INSERT INTO rgu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Lahenda fo rasoda nai besaꞌ ia, muste lepa ra natataa mabera neme basa lahenda fo raisa Manetualain mana nesi mata nara so a. Ria reke ni neme Manetualain adu na dae-bafoꞌ ia, mulai neme Habel mamate na, losa mateꞌe oe na, Sakaria. Ria nana, raisa ni nai mei tutunu-hohotuꞌ a no Kama Makamoiꞌ a talada, nai Manetualain Uma Mamaso Ina Na daleꞌ. Emi boe lepa ma sira huhukun ria! ");
INSERT INTO rgu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Lahenda malela atoran agama Yahudi emin! Neuꞌ ko emi hapu soe! Huu fo emi homu koeꞌ fo riꞌ bisa soi lelesu a ela lahenda bubuluꞌ ratalolole Manetualain hihii-nanaun. Tehuu emi ta nau masoꞌ leo naꞌ meu. Tadalu lena bali, riꞌ emi matabaa etu lahenda, ela ara bosoꞌ masoꞌ leo naꞌ reu!” ");
INSERT INTO rgu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus dedea basa, boe ma lahenda malela atoran agama Yahudi ria no lahenda Farisi ra ramumuu Ni. Mulai neme fai ria mai, ara soba Ni de ratanen rupaꞌ ara ela rahihiiꞌ Ana fo ratudan. Ara rasaka enoꞌ fo tao dedeaꞌ roo Ni. ");
INSERT INTO rgu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tepoꞌ ria, lahenda rifun hida mai fo nau nenene neuꞌ Yesus. Ara laꞌo raseseti ao rarurupu ra Yesus. Boe ma Ana dedea nauluꞌ no ana mana tuka dea nara nae, “Manea ao mara fo bosoꞌ tuka lahenda Farisi masarole-masaraliꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ara fufudiꞌ rae sira malole a, tehuu neuꞌ ko sira fufudin ria nananitaꞌ. Huu fo besaꞌ ia hata nafuniꞌ a neuꞌ ko nananitaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hata fo besaꞌ ia emi dedea mafufuniꞌ ana, neuꞌ ko lahenda ramanenen neuꞌ loa na. Hata fo emi mabobotoꞌ ana nai kama daleꞌ, neuꞌ ko lahenda dedea rambera ni nai lahenda dodouꞌ matan.” ");
INSERT INTO rgu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus dedea tamba nae, “Ana kara emin! Bosoꞌ bii kalu lahenda nau raisa emi. Huu fo ara raisa noi emi ao-paa mara, tehuu ta bisa tototo emi sumane mara fa. ");
INSERT INTO rgu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Au nau afada ae, emi muste bii neuꞌ bea. Emi muste bii neuꞌ Manetualain. Huu fo Ana bisa naisa emi, basa te tuꞌu emi leo naraka daleꞌ meu. De, Ria riꞌ emi muste bii-mamataꞌu Ni. ");
INSERT INTO rgu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Soba emi dodoo, manupui karutuꞌ a beli na bau bea? Beliꞌ bainaꞌ a, hete?! Manupuiꞌ lima sona sen dua, hete? Leo mae leoꞌ na, tehuu Manetualain ta nafarene heni esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Leoꞌ na boe Manetualain tao daleꞌ neuꞌ emi. Ana reke na emi laka doo mara dedesi na. De, emi bosoꞌ bii, huu fo tuka Manetualain sona emi beli mara lena manupui karutuꞌ kakabainaꞌ sira.” ");
INSERT INTO rgu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Basa boe ma Yesus dedea seluꞌ no ana mana tuka dea nara nae, “Nenene matalolole! Maneniko hapu lahenda naparani manaku neuꞌ Au, nai lahenda dodou matan nai dae-bafoꞌ ia, neuꞌ ko Au boe manaku neuꞌ ria, nai Manetualain eilaꞌo-limalopen nai nusatetu-ikutemaꞌ a ae, ria nana Au lahenda ki. ");
INSERT INTO rgu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tehuu maneniko lahenda fo dedea neuꞌ lahenda dae-bafoꞌ a mata na nae, ana ta nalelaꞌ Au, neuꞌ ko Au boe dedea neuꞌ Manetualain eilaꞌo-limalope na matan, nai nusatetu-ikutemaꞌ a ae, Au ta alelaꞌ ana fa. ");
INSERT INTO rgu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Au nana, Ana Lahenda. Maneniko lahenda dedea nakekeo Au nade malole ka, sona Manetualain bei sadia nafarene heni salan ria. Tehuu maneniko ana dedea nakekeo Manetualain Dula-dale Malalao-malalafu Na nade malole na, Manetualain ta nafarene heni ria sala na fa. ");
INSERT INTO rgu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Maneniko lahenda kolaaꞌ emi leo mamana parisa dedea agama a, do leo mana pareta ra meu, huu no emi mamahere neuꞌ Au, emi bosoꞌ biiꞌ, mae masalaꞌe tao ao-ina mara leoꞌ beaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Huu fo neuꞌ ko fai ria te, Manetualain Dula-dale Malalao-malalafu Na nanori emi dedea-nafada matetu-maraaꞌ a, fo emi bisa mataa si.” ");
INSERT INTO rgu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Basa ria, boe ma lahenda kadodou inaꞌ sira esa natane Yesus nae, “Papa Mesen! Mafada au aꞌa ka fo babati ami papa ma posaka nara no au dei.” ");
INSERT INTO rgu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tehuu Yesus nataa ni nae, “Ae! Bea rina soꞌu na Au dadi Mana ee Dedeaꞌ fo aetuꞌ emi dua dedea rupa leoꞌ na mara?” ");
INSERT INTO rgu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Basa boe ma Yesus dedea no lahenda kadodou inaꞌ sira nae, “Emi muste besa-besa ela bosoꞌ tendetuu. Huu fo hata-heto dodouꞌ a ta neni tetu-temaꞌ fa.” ");
INSERT INTO rgu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Basa boe ma, Ana tui dedea nasasamaꞌ esa nae, “Hapu lahenda kamasuꞌi esa, oka-tine ni reni buna-boaꞌ dodou-inaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Losaꞌ uma pepeda-fufua nara henu-sofeꞌ, ma ta buluꞌ nae tao leoꞌ bea soꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Basa boe ma ana naetuꞌ nan nae, ‘Au sakaꞌ tao leo ia! Au fate heni uma pepeda-fufua paraaꞌ ara, fo afoa seluꞌ kabaꞌuina, basa nana peda au oka-tine kara buna-boan ma basa hata-heto fekeꞌ ara reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Maneniko leo naꞌ, neuꞌ ko au dedea o ao-ina ka ae, ‘Ae! Uma pepeda-fufuaꞌ a henuꞌ so! Nanaaꞌ dai fo taa-tinu losa teu-toꞌ ara!’ De mua-minu malada ma matuu matuleꞌ ei ma leo!’ ");
INSERT INTO rgu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tehuu Manetualain nafada ni nae, ‘Ae! Pakanaꞌ on, e! Hatun ia boe, o mate. Basa, nana bea hapu o uma pepeda-fufua ma oe-isi nara, e?’ ");
INSERT INTO rgu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","De leo iaꞌ! Lahenda bisa ranuu-raena hata-heto dae-bafoꞌ dodouꞌ soaneuꞌ ria ao-ina heheli na, tehuu tuka Manetualain, ria nana lahenda hata taaꞌ, huu fo ana dooꞌ a neme Manetualain mai.” ");
INSERT INTO rgu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Boe ma Yesus nanori ana mana tuka dea nara nae, “Emi bosoꞌ dale mara dodaaꞌ laꞌeneuꞌ mia ubeaꞌ, do pake ubeaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Huu fo ita masodan ia, lena neme nanaa-nininu ma kakao-papake. ");
INSERT INTO rgu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mete maneni manupui kaaꞌ ara! Ara ta sele-tande, ta etu-oru, ma ta ranuu uma pepeda nanaaꞌ fa, tehuu Manetualain naboi si. Kalu leoꞌ na, tantu Ana nahao emi boe. Huu fo Ana uku-sudi emi lena memeꞌ manupuiꞌ sira mai. ");
INSERT INTO rgu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Maneniko lahenda titiro aon nai tiro ao a, basa boe ma dale na dodaaꞌ, sona ana bisa namananaru teu nara, do? Ta bisa fa! ");
INSERT INTO rgu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","De, maneniko emi dale mara dodaaꞌ neuꞌ hihii-nanauꞌ aanaꞌ fo ta neni buna-boaꞌ esa boeꞌ, ubeaꞌ taon de emi dale mara dodaaꞌ neuꞌ hihii-nanauꞌ bauinaꞌ ara? ");
INSERT INTO rgu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mete maneni buna nura a. Ara ta tao oka-tine fa, ma ta heke-tenu boeꞌ. Tehuu mane Soleman a papake rela-saꞌa na boe, ta dai buna nura ria lole na fa. ");
INSERT INTO rgu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huu fo Manetualain naboi nau lutuꞌ fo sosoa-raraaꞌ taꞌa, ana nasoda noi faiꞌ ia, basa nana balahaꞌ te mate ni, de lahenda ra hotu henin. Maneniko leoꞌ na sona, Ria boe bisa naboi emi fo beli mara lena neme nau a mai. Ubeaꞌ taon, de ta mamahena neuꞌ Ana fa? ");
INSERT INTO rgu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Leoꞌ na boe emi bosoꞌ masapute laꞌeneuꞌ nanaa-nininuꞌ a. Huu fo Manetualain riꞌ urus. ");
INSERT INTO rgu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Lahenda fo ta namahena neuꞌ Manetualain, ara sota raan seliꞌ fo rafaduli neuꞌ basa hata sira. Tehuu emi ia sona ta leo naꞌ fa, huu fo emi Papa ma nai nusatetu-ikutemaꞌ a bubuluꞌ basa-basan fo emi parluu a. ");
INSERT INTO rgu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Emi malalaꞌo mauluꞌ Manetualain nonoi-tataon, sona neuꞌ ko Ana urus fee emi, basa hihii-nanauꞌ ia ra.” ");
INSERT INTO rgu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesus dedea naroo nae, “Emi sama leoꞌ bibi-lopo, de baraꞌaiꞌ taꞌa. Tehuu bosoꞌ biiꞌ! Huu fo emi Papa ma nai nusatetu-ikutemaꞌ a nana, Mane Bauinaꞌ. Ana nanuu ubeaꞌ, sona dale Na namahoꞌo bati fee ana nara. ");
INSERT INTO rgu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","De, meu seꞌo heni emi hata-heto mara fo babati doi nara fee lahenda manatoꞌa-manataꞌ ara. No ria na emi peda hata nai nusatetu-ikutemaꞌ a nai mamana malolole, de nanenete naroo. Naꞌo ra ta bisa reu ramanaꞌo ni fa. Hihiki ra boe ta bisa raa ralutu ni fa. ");
INSERT INTO rgu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mafarereneꞌ matalolole! Emi hata-hetom nai bea, sona dale mara rai na boe.” ");
INSERT INTO rgu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus dedea bali nae, “Hatu-leledon emi muste sadia fo malalau neuꞌ Manetualain. Sama leoꞌ ata nanea nahani ria manuu uma na fali neme feta kakabiꞌ a mai. Maneniko manuu umaꞌ a dedelu lelesu a, sona ana bisa nalale fo soi ni. ");
INSERT INTO rgu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Maneniko manuu umaꞌ a mai, fo nita lahenda mana noi nara rahani leoꞌ na, tantu ara raua-ranale. Huu fo neuꞌ ko manuu umaꞌ a natudu fee si dale malole na. Ana pake papake nonoi-tataoꞌ a fo neu nalalau lahenda mana noi nara neniꞌ, nanaa-nininu malada. ");
INSERT INTO rgu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lahenda mana noi sira tebe raua-ranale, huu fo ara ralalau sira manuu uma na no malole. Leo mae manuu umaꞌ a mai liꞌu hida a, fatiladan do dulupilan, sira manasadiaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dodoo matalolole! Maneniko manuu umaꞌ fo bubuluꞌ matetuꞌ naꞌo ra mai liꞌu hida, tantu ana ta fee lelaꞌ fo naꞌo sira ofe uma na fa. ");
INSERT INTO rgu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","De, emi muste sadia kokosen, nana huu ta hapu lahenda esa bubuluꞌ matetuꞌ fai hidaꞌ Ana Lahenda natafali mai.” ");
INSERT INTO rgu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Boe ma Petrus natane Yesus nae, “Papa Mesen! Bisinaꞌ a Papa dedea nasasama ma nana laꞌe noi ita mesaꞌ kata, do laꞌe basa lahenda ra?” ");
INSERT INTO rgu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Boe ma Yesus nataa nae, “Dedea nasasamaꞌ ria laꞌe basa lahenda fo tao sama leoꞌ malaka urusan fo nafaduli nalelaꞌ, ma dite-tama nahere neuꞌ malaka na. Huu fo neuꞌ ko malaka na soꞌu nan ela bati nanaaꞌ fee basa ata ra. Maneniko ana nakate tao natetu ria nonoi laka na, sona leo mae malaka na mai fai bea a tehuu ana tao malole kokosen. De naua-nanale, huu fo neuꞌ ko malaka na soꞌu nan ela nafaduli ria hata-heton katemaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tehuu malaka urusan ria soe, kalu ana mulai afi nae, ‘Eh! Tantu tou lasiꞌ a dooꞌ a dei fali main.’ Boe ma ana nafero ata ina-tou fekeꞌ ara, fo popoꞌo si. Basa nana ana natuuꞌ naa-ninu nasosoe aon losaꞌ mafuꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tehuu neu faiꞌ fo malaka urusan ria ta bubuluꞌ hata esa boeꞌ, kekeneu te malaka na fali main. Boe ma malaka a popoꞌo tutiꞌ ana, basa nana usi henin, fo hapu babati na nai deaꞌ sama-sama no lahenda fo ta tao tuka malaka na hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Soaneuꞌ ata fo bubuluꞌ malaka na hihii-nanaun, tehuu ana ta sadia tao tukan, do ta nau tao tukan fa, neuꞌ ko ana hapu huhuku mabera. ");
INSERT INTO rgu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tehuu ata fo noi-tao nasalaꞌ, nana huu ana ta bubuluꞌ malaka a hihii-nanaun, neuꞌ ko huhuku na kafaꞌ a. Huu fo lahenda bea sipo dodouꞌ, sona partutu ni boe dodouꞌ. Lahenda fo sipo nonoi bauinaꞌ, ria lelepa na boe bauinaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus tuti naroo dedea Na nae, “Au mai fo ela tada heni lahenda kara reme lahenda fekeꞌ a nai dae-bafoꞌ ia. Ria sama leoꞌ lahenda pake ai, fo hotu heni kadafuꞌ a. Au ahiiꞌ kalu ai ria pila nai basa mamanaꞌ ain. ");
INSERT INTO rgu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tehuu Au muste lepa aꞌuluꞌ doidoso mabera a. Neuꞌ ko Au doidoso tebe, losaꞌ Au nonoi laka ka basa ni so. ");
INSERT INTO rgu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Emi afi mae Au mai nana uni mole-dame nai dae-bafoꞌ ia, do? Taꞌa! Au mai fo tao a lahenda rahuu-ralena, rasesefi bafaꞌ ma tao a si rasida-saiꞌ, huu no Au nanori-nafada ki. ");
INSERT INTO rgu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mulai neme besaꞌ ia mai toranooꞌ a no toranooꞌa ara sida-saiꞌ. Nai kileobobokiꞌ esa daleꞌ, telu soaꞌ dua, dua soaꞌ telu. ");
INSERT INTO rgu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Papaꞌ a soaꞌ ana na; anaꞌ a soaꞌ papa na. Mamaꞌ a soaꞌ ana na; anaꞌ a soaꞌ mama na. Arinaꞌ a soaꞌ manafeu na; manafeuꞌ a soaꞌ arina na.” ");
INSERT INTO rgu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Boe ma Yesus dedea no lahenda kadodou inaꞌ sira nae, “Maneniko emi mita oa keoinaꞌ a toda nai murii, emi mae, ‘Tanda ia nana nae, uda a sakaꞌ mai.’ Tebe leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Maneniko ani onas a fufuu mai, emi mae, ‘Tanda ia nana nae, faiꞌ ia makahana na seli.’ Tebe leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ae! Lahenda masarole-masaraliꞌ emin! Emi tanda malelaꞌ dae-bafoꞌ a ma oa-ani. Tehuu ubeaꞌ taon de emi ta nau bubuluꞌ Manetualain hihii-nanaun nai saman besaꞌ ia?” ");
INSERT INTO rgu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Yesus dedea tamba seluꞌ nae, “Maneniko emi madedea, sona ubeaꞌ taon de emi ta bisa maetuꞌ ao mara tuka matetu na fa! Malole lenaꞌ madame ao maꞌuluꞌ dei! Boso losa emi nai mana ee dedeaꞌ ara matan, boe ma ana naetuꞌ fo huku emi nai bui daleꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huu fo maneniko mana ee dedeaꞌ ara raetuꞌ ran leoꞌ na, sona emi ta bisa kalua fa, losaꞌ emi mahuta basa dei.” ");
INSERT INTO rgu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Faiꞌ ria, lahenda rafada Yesus rae, gubernor Pilatus a naisa lahenda Yahudi hida reme Galilea mai, tepoꞌ fo ara reni tutunu-hohotuꞌ nai Uma Mamaso Ina nai Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus namanene leoꞌ na, boe ma nafada ni nae, “Emi dale mara mae Manetualain namate lahenda Galilea sira, nana huu sala nara bau lahenda Galilea fekeꞌ? ");
INSERT INTO rgu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tuka Au sona sala ria! Tehuu kalu emi ta saledale-tuꞌetei mara meme sala-siko mara mai, sona emi malulutuꞌ leoꞌ sira boe. ");
INSERT INTO rgu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Boe ma lahenda kasanahulu faluꞌ fo riꞌ manara nai Siloam refa neu de nanete naisa si a, nana sira sala nara bau lena basa lahenda fo rai Yerusalem, do? ");
INSERT INTO rgu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tuka Au sona sala ria! Tehuu kalu emi ta saledale-tuꞌetei mara meme sala-siko mara mai, sona emi malulutuꞌ leoꞌ sira boe.” ");
INSERT INTO rgu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Boe ma Yesus nafada dedea nasasamaꞌ esa nae, “Lahenda esa nanuu ai huu esa nai oka na daleꞌ. Ana mai kokosen fo saka ai huuꞌ ria naboa na. Tehuu boaꞌ bei ta. ");
INSERT INTO rgu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Boe ma ana nafada mana noi okaꞌ a nae, ‘Teuꞌ telu ian, au mai kokosen fo saka ai huuꞌ ia boa na, tehuu au ta hapu boaꞌ esa boeꞌ. De loꞌo henin, huu fo ana naseseka nahenu mamanaꞌ a.’ ");
INSERT INTO rgu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tehuu mana noi okaꞌ a sipoꞌ nae, ‘Papa bosoꞌ mamanasaꞌ. Neme na fo teu ia au fufuꞌa-aali ai huuꞌ ia, ela nalole seluꞌ dei. ");
INSERT INTO rgu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bate manafaliꞌ boe ma ana naboa, sona malole a. Tehuu maneniko taꞌa, sona dei loꞌo henin.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Laiꞌ esa de, Yesus neu nanori-nafada nai uma mamasoꞌ daleꞌ, laꞌe lahenda Yahudi ra fai huhule-haradoin. ");
INSERT INTO rgu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nai naa hapu inaꞌ esa pukudou ni teuꞌ sanahulu falu so, huu fo nitu a tataon. Ana ta bisa napadei natetu fa. ");
INSERT INTO rgu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus nita inaꞌ ria, boe ma Ana naloo nan, de nafada ni nae, “Mama! Besaꞌ ia mama ka teꞌe ma aom so.” ");
INSERT INTO rgu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Boe ma Yesus fua lima na neuꞌ inaꞌ ria, no hatemataꞌ ria boe kotiꞌai pukudou na namaroo na aon tutiꞌ a. Boe ma ana hule makasi, ma io-oa neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tehuu uma mamasoꞌ ria malaka na namanasa, huu fo Yesus puli na lahenda laꞌe fai huhule-haradoiꞌ. Boe ma ana nafada lahenda kadodou inaꞌ ara nae, “Nai mamasoꞌ esa daleꞌ, fai nonoi-tataoꞌ faiꞌ nee. De, malole lenaꞌ lahenda kamahedis ara saka lahenda fo puli si, sona ara mai laꞌe fai sira. Bosoꞌ mai laꞌe fai huhule-haradoiꞌ!” ");
INSERT INTO rgu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tehuu Yesus nataa ni nae, “Ae! Lahenda masaroleꞌ masaraliꞌ emin. Nai fai huhule-haradoiꞌ boe emi moi nonoiꞌ, hete?! Huu fo emi meu poꞌi sapi mara ma keledei ra fo hani si, hete?! ");
INSERT INTO rgu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inaꞌ ia, nana baꞌi Abraham tititi-nonosin, sama leoꞌ ita. Malaka nitu heke nan teuꞌ sanahulu falu ian so. Maneniko Au poꞌi an laꞌe fai huhule-haradoiꞌ sona, sala do?” ");
INSERT INTO rgu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus musunoo nara ramanene ra ria, boe ma ara maeꞌ. Tehuu lahenda kadodou inaꞌ sira ramahoꞌo huu fo Ria nonoi-tatao malole nara. ");
INSERT INTO rgu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Boe ma Yesus dedea naroo nae, “Au asasamaꞌ Manetualain lahenda nara sama leoꞌ ubeaꞌ? ");
INSERT INTO rgu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Masososa na sira noi baianaꞌ asa, tehuu doo-doo boe ma ara tamba dodouꞌ. Sira mulai sama leoꞌ ai deke anaꞌ a. Lahenda sele ni nai okaꞌ. Basa de ana mori boe ma dadi neuꞌ ai huu bauinaꞌ. De, manupuiꞌ ara rarunu reuꞌ baꞌe nara.” ");
INSERT INTO rgu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Basa boe ma Yesus dedea bali nae, “Au asasamaꞌ Manetualain lahenda nara no ubeaꞌ bali? ");
INSERT INTO rgu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ria sama leoꞌ ralu teteiꞌ a fo inaꞌ ara ame rabua ni no uuꞌ saku dua, ela tao roti dodouꞌ. Boe ma uuꞌ mana ameꞌ ria ae losaꞌ bauꞌ basa, huu no ralu tetei kabaianaꞌ ria. Manetualain lahenda nara lelea-nonoren namaloa-namanaru leoꞌ na boe.” ");
INSERT INTO rgu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Basa ria boe ma, Yesus mulai laꞌo leo kota Yerusalem neu. Ana tuli lalaꞌo kota ma koroꞌ ara, fo nanori-nafada lahenda ra. ");
INSERT INTO rgu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nai mamanaꞌ esa, hapu lahenda esa natane Ni nae, “Papa Mesen! Noi lahenda baianaꞌ a riꞌ bisa hapu soda-moleꞌ a, do?” ");
INSERT INTO rgu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ana nataa nae, Lelesu fo leo nusatetu-ikutemaꞌ a neu a, loaanaꞌ a. De, tia mahereꞌ ei mara fo bisa kodi mesiꞌ na. Huu fo lahenda dodouꞌ soba nau masoꞌ reu, tehuu ta bisa fa. ");
INSERT INTO rgu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Maneniko manuu umaꞌ a, koe na lelesu a so, neuꞌ ko emi mapadei mahaniꞌ deaꞌ fo dedelu lelesu a, ma maloo hule tutulu-fafaliꞌ mae, ‘Ramatuaꞌ! Soi lelesu a dei!’ Tehuu neuꞌ ko ana nataa nae, ‘Emi nana, bea? Au ta alelaꞌ emi fa!’ ");
INSERT INTO rgu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tutiꞌ a emi mae, ‘Hapun nai bea papa ta malelaꞌ ami fa? Ami biasa mia-minu mo papa. Papa boe manori-mafada ami nai ami eno-dala mara.’ ");
INSERT INTO rgu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Boe ma neuꞌ ko Ana nataa nae, ‘Bisinaꞌ a au afada so, au ta alelaꞌ emi fa! Emi ia nana, lahenda mana tao tadaluꞌ. Madoo bai iaꞌ e!’ ");
INSERT INTO rgu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Faiꞌ bea ma Manetualain naetuꞌ basa lahenda ra dedea nara, emi boreu ma heku nisi mara. Huu fo emi mita baꞌi Abraham, baꞌi Isak, baꞌi Yakob ma Manetualain mana nesi mata nara basa si masoꞌ rai nusatetu-ikutemaꞌ a de ratuuꞌ so. Tehuu emi sona nanausi heniꞌ leo deaꞌ meu. ");
INSERT INTO rgu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Neuꞌ ko lahenda reme dae-bafoꞌ ia bukun haas mai, reme ledo a titii mai na losa tetena neu na; reme ii mai losa ona, fo ratuuꞌ raa-rinu reuꞌ esa, nai Manetualain uma mane na. ");
INSERT INTO rgu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tanda matalolole hata ia: Maneniko Manetualain naetuꞌ basa lahenda a dedea na, neuꞌ ko hapu lahenda fo maulu na naendobuko ria nana lahenda aanaꞌ, tehuu ana hapu hada-horomata bauinaꞌ a, sekonaa te Manetualain tao ni neuꞌ lahenda aanaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tepoꞌ ria, lahenda Farisi hida mai de rasare ra Yesus, boe ma rafada rae, “Malole lenaꞌ, Papa Mesen maheoꞌ dooꞌ a leo mamana fekeꞌ muu, huu fo mane Herodes a nau naisa Papa.” ");
INSERT INTO rgu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Boe ma Yesus nataa si nae, “Ae! Tou ria hada-parin sama leoꞌ ue a! Emi meu mafadan mae, ‘Fai ia no balahaaꞌ, Au usi nitu, ma puli a lahenda kamahedis ara. Binesaꞌ, dei basa Au nonoi Ka.’ Tehuu Au muste oi-tao a seluꞌ baiꞌ, fo dei leo Yerusalem uu. Huu fo nai Yerusalem nana mamanaꞌ fo raisa Manetualain mana nesi matan. ");
INSERT INTO rgu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Adoo, Yerusalem lahendan emin, e! Emi riꞌ maisa Manetualain mana nesi mata nara, ma pia maisa lahenda nadedenuꞌ fo nau mai ratudu emi enoꞌ a. Laꞌi-laꞌi Au anea-asalaꞌe emi neme tadaluꞌ a mai, sama leoꞌ manu inaꞌ a nasuru-nahapaꞌ ana nara rai dila na daleꞌ. Tehuu emi ta nau fa. ");
INSERT INTO rgu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Besaꞌ ia, Manetualain ta tao daleꞌ neuꞌ emi uma mamaso mara fa. Basa nate balahaa-binesaꞌ te rouꞌ so. Neuꞌ ko emi ta mita Au so, losaꞌ faiꞌ bea emi manaku mae, ‘Manetualain fee ua-naleꞌ neuꞌ lahenda fo, ana mai neni Ramatuaꞌ a nade na, huu fo Ramatuaꞌ a riꞌ nadenu Ni!’ ” ");
INSERT INTO rgu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Laiꞌ esa de, laꞌe fai huhule-haradoiꞌ, lahenda agama Farisi a lahenda nara malaka ni esa hule Yesus fo neu naa-ninu nai uma na. Ana naa-ninu, tehuu lahenda mamaꞌu Ni, fo nau ritan tao ubeaꞌ laꞌe fai huhule-haradoiꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Faiꞌ ria, lahenda kamahedis peta aoꞌ esa natuuꞌ nai na. ");
INSERT INTO rgu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Basa boe ma, Yesus natane lahenda malela atoran agama Yahudi ma lahenda Farisi fo raa-rinu rai na nae, “Tuka baꞌi Musa atoran a, bole puli lahenda kamahedis, laꞌe fai huhule-haradoiꞌ, do taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tehuu ta hapu esa huꞌa bafa na boeꞌ. Boe ma Yesus oi laꞌe lahenda hediꞌ ria, basa de ana teꞌe tutiꞌ a. Boe ma Yesus nadenu ni fo fali neun. ");
INSERT INTO rgu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Basa ria boe ma, Yesus natane si bali nae, “Maneniko hapu anaꞌ esa tuda nala oe dodoluꞌ daleꞌ, laꞌe fai huhule-haradoiꞌ, emi meu hela ni leo deaꞌ mai, do taꞌa? Maneniko sapi a tuda nala daleꞌ, emi mataaꞌ ana, do hela ni leo deaꞌ mai? Tantu emi hela ni deaꞌ mai. Naa, ria sosoa na nae, emi moi nonoiꞌ so, hete!” ");
INSERT INTO rgu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ramanene Yesus dedea nae leoꞌ na, tehuu ta hapu lahenda esa bisa sisipoꞌ Ana boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Faiꞌ ria, Yesus nita lahenda ra mai raa feta nai uma ria. Lahenda dodouꞌ here mamanaꞌ nai mata, fo reuꞌ na ratuuꞌ. Ana nita ria, boe ma dedea nae, ");
INSERT INTO rgu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Besa-besa, o! Maneniko lahenda raloo emi leo feta kakabiꞌ a meu, sona bosoꞌ saka lahenda bau-ina ara mamana nara. Huu fo bosoꞌ losa mana tao feta a naloo fui fo lena heni. ");
INSERT INTO rgu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Maneniko leoꞌ na, sona neuꞌ ko mana tao feta a mai nafada o nae, ‘Bosoꞌ mamanasaꞌ, e! Papa marali musiꞌ deaꞌ ele, huu fo au sadia kadera ia ra nana fee lahenda bauinaꞌ a.’ Boe ma o foa ela kadera ria de muu matuu nai deaꞌ, tehuu o maeꞌ so. ");
INSERT INTO rgu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","De, maneniko o hapu nalooꞌ de muu, sona matuuꞌ nai kadera manai dea ra. Neuꞌ ko mana tao feta a nita o, boe ma ana mai nae, ‘Eeh, Papa! Maiꞌ ia matuuꞌ.’ No ria na emi hapu hada-horomata nai basa fui ra matan. ");
INSERT INTO rgu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Huu fo lahenda bea namatutua-namadedema aon, neuꞌ ko Manetualain natuda ni. Tehuu lahenda fo tao aon sama leoꞌ lahenda aanaꞌ a, neuꞌ ko Manetualain soꞌu-fua ni.” ");
INSERT INTO rgu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Basa ria, boe ma Yesus dedea no manuu umaꞌ a nae, “Laiꞌ esa seluꞌ, maneniko papa tao feta, sona bosoꞌ maloo noi kileoboboki mara ro tia-lai lahenda kamasuꞌi ara! Huu fo tantu sira bisa raloo ratafaliꞌ papa. ");
INSERT INTO rgu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tehuu maneniko papa tao feta, sona maloo lahenda manatoꞌa-manataꞌ ara, ei helaꞌ ara, lahenda fo ta bisa laꞌo fa, ma pokeꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tantu ara ta bisa balas papa fa. Tehuu maneniko papa maloo si, sona Manetualain riꞌ balas. Maneniko Ana fee lahenda kamahereꞌ fo mate si a, ara rasoda seluꞌ, neuꞌ ko Ana ta nafarene heni papa malole ma fa.” ");
INSERT INTO rgu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hapu lahenda fo natuuꞌ no Yesus mei esa a namanene leoꞌ na, boe ma ana dedea nae, “Maua-manale a riꞌ, lahenda fo raa-rinu reuꞌ esa nai Manetualain uma mane Na, oo!” ");
INSERT INTO rgu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus nataa ni nae, “Au tui tutuiꞌ leo iaꞌ: lahenda esa tao feta bauinaꞌ, de naloo lahenda dodouꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Faiꞌ fo feta ria mana sadiaꞌ, boe ma ana nadenu lahenda nadedenu nara fo neu nafada lahenda fo ara hapu nalooꞌ a nae, ‘Mai leo, te basan mana sadiaꞌ de sakaꞌ mulai riaꞌ so,’ ");
INSERT INTO rgu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tehuu basa sira esaꞌko nafadaꞌ ria pupute-aain fo ela ara ta bisa mai fa. Esa nafada ria pupute-aai na nae, ‘Ae! Au besaꞌ ko asa a okaꞌ esa, de au muste uu dama asudi ni dei. Bosoꞌ mamanasaꞌ oo! Huu fo au ta bisa mai fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hapu fekeꞌ a fee pupute-aai na bali nae, ‘Au besaꞌ ko asa a sapi ruruluꞌ pasang lima, au ae uu dama asudi si, de bosoꞌ mamanasaꞌ, e!’ ");
INSERT INTO rgu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Fekeꞌ ara bali rae, ‘Au besaꞌ ko sao, de ta bisa fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Basa boe ma, lahenda nadedenuꞌ ria fali main de tui malaka na. Malaka feta a namanene na ria, boe ma namanasa mamateꞌ. Basa de ana pareta lahenda nadedenuꞌ ria nae, ‘Kalu leoꞌ na, sona o malale fo kalua! Leo basa eno laiꞌ ia ra muu, ma kota ia eno bafalutuꞌ ara fo maloo muni lahenda manatoꞌa-manataꞌ ara, ei helaꞌ ara, pokeꞌ ara, ma lukuꞌ ara.’ ");
INSERT INTO rgu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lahenda nadedenuꞌ a namanene na ria, boe ma neu naloo lahenda sira. Ana fali, boe ma nafada malaka na nae, ‘Papa! Basa si mai so, tehuu mamana rouꞌ bei dodouꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Boe ma malaka ria nae, ‘Kalu leoꞌ na, sona leo koroꞌ fo rai kota a deaꞌ, losa leo okaꞌ ara daleꞌ muu. Leleꞌo sudi bea a, moo si mai fo sadi ratuu rahenu mamana feta ia. ");
INSERT INTO rgu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mafarerene! Lahenda fo tipa au naloo ka a, ara ta raa rita au feta ka mina-maladan baiꞌ boeꞌ!’ ” ");
INSERT INTO rgu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Basa ria boe ma, Yesus asa laꞌo raroo leo Yerusalem reu. Lahenda dodouꞌ tuka Ni. Basa de Ana nasare naa si, boe ma dedea nae, ");
INSERT INTO rgu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lahenda fo tebe-tebe nau tuka Au, ana muste sue Au lena neme basa-basan mai: lena neme ina-ama nara mai, sao-ana nara, aꞌa-fadi nara, ma lena neme ao-ina heheli na mai. Kalu taꞌa, sona lahenda ria ta naraa dadi neuꞌ Au ana mana tuka dea ki fa. ");
INSERT INTO rgu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Lahenda fo ta nau lepa doidoso nana huu tuka Au, ana ta naraa dadi neuꞌ Au lahenda Ki. Leo mae lahenda raisa ni boe, ana muste lepa naroo. ");
INSERT INTO rgu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","De maneniko nau tuka Au, sona bareken matalolole dei. Leo-leoꞌ lahenda nau nafoa uma matatadaꞌ a. Ana muste reke nauluꞌ nae mai te uma ria nabasa doiꞌ hida losa leo lulutu-raraeꞌ a neu. Boso losa doiꞌ ta dai fa. ");
INSERT INTO rgu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Maneniko ta reke lutuꞌ fa, sona bate ana bei tao noi uma a fanderen a, te basa doiꞌ ara so. Boe ma lahenda hiꞌa ramamaeꞌ ana, ");
INSERT INTO rgu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","rae, ‘Emi mete masudi lahenda ria dei! Ana besaꞌ ko tao fanderen a, tehuu bei ta hata-hata esa boeꞌ, te basa doiꞌ ara so.’ ");
INSERT INTO rgu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Natutudu fekeꞌ, riꞌ laꞌeneuꞌ mana musu ra. Maneꞌ fo nau natati ao, ana muste bareken nauluꞌ no ria nonoo nara. Maneniko soldadu ni noi lahenda rifun sanahuluꞌ a, fo soaꞌ musunoo na lahenda rifun dua hulu na, ee naseki si, do taꞌa? ");
INSERT INTO rgu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ana bareken basa so, tehuu maneniko ta naseki musu a, sona malole lenaꞌ, faiꞌ fo musu a bei nai dooꞌ a, ana fee memaꞌ lahenda nadedenuꞌ ela ator fo mole-dame. ");
INSERT INTO rgu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Leoꞌ na boe lahenda fo nau tuka Au. Ana muste bareken neu-mai nae, ana sadia foa ela basa-basan, do taꞌa? Kalu taꞌa, sona lahenda ria ta naraa dadi neuꞌ Au ana mana tuka dea Ki fa.” ");
INSERT INTO rgu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yesus nafada seluꞌ dedea nasasama esa bali nae, “Tebe masiꞌ a malole. Nanaaꞌ mina-malada oo masiꞌ dei. Tehuu maneniko masiꞌ a dadi mamin sona sosoa-raraan ubeaꞌ? Ta bisa pake ni soꞌ. Tao ni neuꞌ pupuk boe ta bisa fa, de tuꞌu henin. De, emi musti dadi sama leoꞌ masiꞌ, fo ela masue-malai ao mo basa lahenda. Bea nanuu ridooꞌ, sona nenene natalolole!” ");
INSERT INTO rgu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tepoꞌ ria, lahenda mana susu bea ra ma lahenda mana dadi taaꞌ fekeꞌ ara, roi mai-maiꞌ a leo Yesus mai, fo nau nenene neuꞌ Ana. Tehuu lahenda Yahudi ra tao si reuꞌ lahenda ta malole fa. ");
INSERT INTO rgu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lahenda Farisi ra ma mesen agama Yahudi ra, rita leoꞌ na, boe ma ara ramumuu rae, “Ae! Lahenda ia natiaꞌ no lahenda mana dadi taaꞌ ara. Lena-lenaꞌ Ana natuuꞌ naa-ninu no si bali!” ");
INSERT INTO rgu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesus namanene leoꞌ na, boe ma Ana tui fee si dedea nasasamaꞌ esa nae, ");
INSERT INTO rgu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Uniꞌ ko leo neme emi mai lahenda esa nanuu bibi-lopo natun esa. Boe ma mopo esa. Besaꞌ ia lahenda ria muste tao ubeaꞌ? Tantu ana foa ela bibi-lopo kasio hulu sioꞌ sira reuꞌ mamana lino-nes a, fo neu saka bibi-lopo mana mopoꞌ ria losaꞌ hapun. ");
INSERT INTO rgu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maneniko hapu ni sona nasaa neni faliꞌ ana no namahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Losa uma, te naloo na tutiꞌ nonoo nara, boe ma nafada nae, ‘Ae! Emi mai fo ita tamahoꞌo dei! Huu fo au hapu faliꞌ bibi-lopo mana mopoꞌ ki ria so.’ ");
INSERT INTO rgu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Naa, nai nusatetu-ikutemaꞌ a boe leoꞌ na. Maneniko lahenda masalaꞌ esa saledale-tuꞌetei na, basa nana natafali leo Manetualain neu, sona nusatetu-ikutemaꞌ a isi na katemaꞌ asa ramahoꞌo. Ara ramahoꞌo raan seli nana huu lahenda esa natafali leo Manetualain neu, lena heni lahenda sio hulu sio fo masoda nara roos a, ma ara ta heo eno fekeꞌ a fa.” ");
INSERT INTO rgu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus tui seluꞌ dedea nasasamaꞌ esa bali nae, “Inaꞌ esa nanuu doifulaꞌ sanahulu. Kekeneu te mopo esa. De besaꞌ ia tao aon leoꞌ bea? Tantu ana dede dededeꞌ fo loti na basa mamanaꞌ ara, ma kakai uma ria losa buku nara lalaꞌen, ela saka natalolole doiꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ana nita doiꞌ ria, boe ma naloo uma maneneaꞌ sira lahenda nara, de nafada si nae, ‘Ae! Emi mai fo tamahoꞌo dei! Huu fo au hapu faliꞌ doi mana mopo ka so!’ ");
INSERT INTO rgu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nai nusatetu-ikutemaꞌ a boe leoꞌ na. Maneniko lahenda masalaꞌ esa saledale-tuꞌetei na, ma fali leo Manetualain neu, tantu eilaꞌo-limalope fo rai nusatetu-ikutemaꞌ a ramahoꞌo raan seli.” ");
INSERT INTO rgu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Basa boe ma Yesus tui seluꞌ dedea nasasamaꞌ fekeꞌ esa bali nae, “Amaꞌ esa nanuu ana touꞌ dua. ");
INSERT INTO rgu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Faiꞌ esa, boe ma ana muriꞌ a nafada papa na nae, ‘Papa! Besaꞌ ia bati fee au hata posaka kara mai leo!’ Boe ma papa na bati hata-heto sira fee anan dua si. ");
INSERT INTO rgu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ta doo bea boeꞌ, te ana muriꞌ a seꞌo heni nuu babati nara. Basa boe ma popoti na bua-loa nara, de leo nusa dooꞌ neu. Nai na, ana tutuꞌu-kakari doi-talin, ma nasosoe aon nai masoda taohiro-taohari na. ");
INSERT INTO rgu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nabasa doi nara, boe ma nusaꞌ ria hapu fai laa-roe inaꞌ a, losaꞌ ana toꞌa-taa nan seliꞌ boe. ");
INSERT INTO rgu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Basa de, ana neu saka nonoiꞌ. Boe ma hapu lahenda esa nai nusaꞌ ria sipoꞌ ana de nadenu ni hani bafi. ");
INSERT INTO rgu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huu no anaꞌ ria namalaa naan seli, boe ma nahiiꞌ naa bafi sira nanaa nara. Huu fo ta hapu lahenda nau rahao ni fa. ");
INSERT INTO rgu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Doo-doo boe ma ana afi neu-mai nae, ‘Nai au papa ka uma na, basa lahenda mana noi ra raa-rinu losaꞌ rabete. Sekonaa te au nai ia mate no laas a so. ");
INSERT INTO rgu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Malole lenaꞌ, au fali leo papa ka uma na uu. Basa nana afada ni ae, “Papa! Au tao sala bauinaꞌ neuꞌ Manetualain ma papa ka so. ");
INSERT INTO rgu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au ta araa dadi uu papa ana mi soꞌ. Leo mae papa ka sipoꞌ au fo dadi ata nai papa ka uman daleꞌ, boe malole a!’ ” ");
INSERT INTO rgu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Afi na ria, boe ma ana fali leo papa na uman neu. Bei nai dooꞌ a te papa na nita ni so, boe ma dale na tuda neuꞌ ana. Ana onda neme uman lain mai, de nalai neu soruꞌ anan fo riꞌ fali mai ni so a. Basa boe ma holu nan de deꞌin. ");
INSERT INTO rgu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Boe ma anaꞌ ria dedea no papa na nae, ‘Papa! Au tao sala bauinaꞌ neuꞌ Manetualain ma papa ka so. Au ta araa dadi uuꞌ papa ka ana mi so.’ ");
INSERT INTO rgu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tehuu papa na pareta tutiꞌ lahenda mana noi nara nae, Ae! Malaiꞌ a! Meu hai meni badu malole fo fee ni pake. Olu rereli neuꞌ lima uuꞌu nara, ma sopatu neuꞌ ei nara. ");
INSERT INTO rgu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Meu hela ma sapi boi ria fo hala ni, huu fo ita nau tao feta bauinaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nana huu au ana ki ia sama leoꞌ mate ni, tehuu besaꞌ ia ana nasoda seluꞌ so. Mopo ni, tehuu besaꞌ ia hapu faliꞌ ana so.’ Dedea basa nae leoꞌ na, boe ma ara mulai feta de ramahoꞌo-ratadale. ");
INSERT INTO rgu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Faiꞌ ria, ana uluꞌ a ta nai uma fa, huu fo noi nonoiꞌ nai okaꞌ. Ana fali neun, bei nai dooꞌ a te namanene meꞌo-labu liiꞌ, ma lahenda ra roke-foti. ");
INSERT INTO rgu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Boe ma naloo na lahenda mana noi esa, de natane ni nae, ‘Ae! Tao rame ubeaꞌ ia?’ ");
INSERT INTO rgu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Lahenda mana noi ria nataa nae, ‘Malaka a fadi ma fali main so. De, papa nadenu tati sapi fo tao feta bauinaꞌ, huu fo ana na fali main no soda-moleꞌ so.’ ");
INSERT INTO rgu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ana uluꞌ a namanene na ria, boe ma namanasa. Ana ta nau leo uma daleꞌ neu so baliꞌ. De papa na leleꞌo ni fo ela masoꞌ leo uma daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tehuu nasa na lua de nae, ‘Papa! Soba papa ka dodoo dei! Doo-naru basa ia au oi-tao fee papa ka, sota an seli sama leoꞌ ata a. Au ta alenalaka alelaꞌ neuꞌ papa ka hihi-nanaum fa. Leo mae leoꞌ na boe, tehuu papa ka bei ta parna fee bibi anaꞌ esa fo au tao feta ela o nonoo kara mamahoꞌo boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tehuu papa ka ana mana tutuꞌu-kakari doi-tali mi ria, neu namina inaꞌ de nabasa papa ka doi mara. Besaꞌ ia ana fali mai ni, boe ma papa ka tati sapi mapetaꞌ fo tao feta bauinaꞌ fee ni.’ ");
INSERT INTO rgu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tehuu papa na sipoꞌ ana nae, ‘Ana susueꞌ on! Nenene matalolole! Doo-naru basa ia nana o leo mo papa. Basa hata fo papa nanuu a, nana o nuu mi katemaꞌ sira. ");
INSERT INTO rgu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tehuu besaꞌ ia ita muste tao feta fo tamahoꞌo, nana huu o fadi ise mi ia. Maꞌulu na ana sama leoꞌ mate ni, tehuu besaꞌ ia nasoda seluꞌ so. Mopo ni, tehuu besaꞌ ia hapu faliꞌ ana so.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Boe ma Yesus tui fee ana mana tuka dea nara dedea nasasamaꞌ esa bali nae, “Lahenda kamasuꞌi esa nanuu malaka urusan esa. Tehuu doo-doo boe ma ana namanene fifoꞌ rae, malaka urusan ria naepoꞌ de tao narurugiꞌ ana. ");
INSERT INTO rgu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Boe ma ana naloo na malaka urusan ria, de nafada ni nae, ‘O leo beaꞌ ia, so? Au amanene rae o maepoꞌ au hata-hetok. Besaꞌ ia o duiꞌ ma si fo au parisaꞌ asa, huu fo au sakaꞌ hai heni o.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Malaka urusan ria namanene na, boe ma ana dodoo neu-mai nae, ‘Au soe ia so! Besaꞌ ia au tao ubeaꞌ? Foi dae o, au ta ala fa. Soa nalamemeiꞌ a oo, au maeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Au muste saka enoꞌ fo ela fai bea ma hai heni au boe, neuꞌ ko lahenda fekeꞌ ara bisa sipoꞌ au.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Boe ma ana mulai naloo esa-esa no basa lahenda fo rahuta malaka na a. Ana natane lahenda masososaꞌ a nae, ‘Ae! O mahuta au malaka ka hida?’ ");
INSERT INTO rgu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lahenda ria nataa nae, ‘Au ahuta mina saitun liter rifun haa.’ Boe ma malaka urusan ria nae, ‘Tebe. O susura huta ma ria. Sii henin besaꞌ ia leo, ma matuuꞌ fo malale tao susura huta bebeuꞌ, duiꞌ, noi liter rifun duaꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Basa boe ma ana natane lahenda kadua a nae, ‘Te o mahuta hida?’ Lahenda ria nataa nae, ‘Au ahuta hade karong rifun esa.’ Malaka urusan ria nafada ni nae, ‘O susura huta ma ria ana, de sii heni leo fo tao susura huta bebeuꞌ, duiꞌ, noi karong natun faluꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ana tao leo naꞌ, losaꞌ malaka na bubuluꞌ ria dodole na. Tehuu malaka ria muste manaku nae, malaka urusan tadaluꞌ ria, memaꞌ malela tipu-dai. Au afada nasasamaꞌ ia ela emi bubuluꞌ. Maneniko nararaaꞌ ana no lahenda kamahereꞌ ara, sona lahenda fo ta ramahere fa, sira soda nara nai raun besaꞌ ia a talada, memaꞌ malela tipu-dai na lena. ");
INSERT INTO rgu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","De, soba emi dodoo. Leo mae lahenda dae-bafoꞌ a ramina dodole tadaluꞌ pake sira hata-heto nara, tehuu malole lenaꞌ emi pake hata dae-bafoꞌ a fo tulu-fali lahenda. No ria na, emi hapu tia-lai dodouꞌ. Leo mae hata sira basa si, tehuu neuꞌ ko Manetualain sadia fee emi mamanaꞌ nai nusatetu-ikutemaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Maneniko lahenda tao tuka roo na nai hata aanaꞌ a, tantu ana tao tuka roo na, nai hata bauinaꞌ a boe. Tehuu maneniko lahenda naepoꞌ nai hata aanaꞌ a, tantu ana naepoꞌ nai hata bauinaꞌ a boe. ");
INSERT INTO rgu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Maneniko lahenda ta ramahere emi fo mafaduli hata aanaꞌ nai dae-bafoꞌ ia, tao leoꞌ bea de Manetualain bisa namahere emi neniꞌ hata bauinaꞌ a? ");
INSERT INTO rgu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Maneniko emi ta bisa mafaduli lahenda fekeꞌ a hata-heton, sona bea rina naparani nau fee emi hata-heton? ");
INSERT INTO rgu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ata esa ta bisa nalalau malaka dua fa. Huu fo neuꞌ ko eteꞌ ao na no esa, ma sue esa. Do, ana dite-tama nahere neuꞌ esa, tehuu ana ta tao daleꞌ neuꞌ esa fa. Leoꞌ na boe emi, huu fo lahenda ta bisa sue Manetualain sama-sama no doi-tali fa. ");
INSERT INTO rgu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tepoꞌ ria, lahenda Farisi hida ramanene bisinaꞌ a Yesus dedean sira. Boe ma ara ramamaeꞌ Ana, huu no ara tendetuu doiꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tehuu Yesus nataa nae, “Ae! Leo mae emi tao makamoi ao mara, nai lahenda matan, tehuu Manetualain bubuluꞌ emi dale mara, nana tadaluꞌ a. Hapu hata dodouꞌ lahenda soꞌu-fua si, sekonaa te Manetualain tao si reuꞌ hata tadaluꞌ, ma nahiaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Losa neuꞌ Yohanis Mana Saraniꞌ a mamai na, nana ita lahenda Yahudi a tasoda tuka baꞌi Musa no Manetualain mana nesi mata nara atoran. Tehuu besaꞌ ia Manetualain Tutui Malole Na nanatui-nanabekaꞌ nai basa mamanaꞌ ara. Lahenda dodouꞌ saka tao eno na leoꞌ bea, fo ela ara rasoda tuka Manetualain hihii-nanaun. ");
INSERT INTO rgu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Leo mae lalai no dae-bafoꞌ a mopo si, tehuu Manetualain atoran na baianaꞌ boe ta bisa mopon. Titiꞌ do koma esa boe ta mopo ni fa. ");
INSERT INTO rgu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Lahenda fo namaetuꞌ no sao ina na, boe ma sao seluꞌ ina fekeꞌ, sona ana hohoke ria. Ma lahenda bea sao na ina fo riꞌ sao tou na namaetuꞌ non a, sona ana hohoke ria boe.” ");
INSERT INTO rgu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus tui tamba seluꞌ nae, “Hapu lahenda kamasuꞌi esa. Ana nahiiꞌ pake bua-loa malole fo tao ni neme tema balanauꞌ a mai. Hatu-leledon ana naa-ninuu mina-malada ma nasosoe aon kose-kose. ");
INSERT INTO rgu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nai na hapu lahenda manatoꞌa-manataꞌ esa, nade Lasarus. Ao-ina na henuꞌ no bisu lama naꞌ a. Tuka-tuka faiꞌ nana tia-lai nara roo ni fo ratuuꞌ ana neuꞌ lahenda kamasuꞌi ria uma na lelesu bafan. ");
INSERT INTO rgu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana nahiiꞌ naan seli hapu nanaaꞌ neme lahenda kamasuꞌi ria nanaa lena nara mai, tehuu ana ta hapu hata-hata esa boeꞌ. Noi busa ra mai ralamomoi bisu nara. ");
INSERT INTO rgu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Basa de, Lasarus mate ni. Boe ma Manetualain eilaꞌo-limalopen reme nusatetu-ikutemaꞌ a mai de roo ni, fo ratutuuꞌ ana nai baꞌi Abraham boboa na. Ta doo bea boeꞌ te lahenda kamasuꞌi ria maten boe, basa de ratoi ni. ");
INSERT INTO rgu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tehuu ana ta masoꞌ nusatetu-ikutemaꞌ a fa, ana masoꞌ naraka, sama-sama no lahenda mana mateꞌ dodouꞌ. Nai na ana hapu eese-rurumuꞌ ma doidoso naroo. Laiꞌ esa de, ana botiꞌ laka na te nita Lasarus natuuꞌ no namahoꞌo nai baꞌi Abraham boboa na. ");
INSERT INTO rgu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Boe ma ana naloo nae, ‘Baꞌi Abraham, e! Kasian au baiꞌ dei! Madenu Lasarus naboro lima na neuꞌ oe a, fo mai naoe neuꞌ au maa peda ka boe malole a. Huu fo au doidoso mamateꞌ nai tasi aipilaꞌ ia daleꞌ!’ ");
INSERT INTO rgu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tehuu baꞌi Abraham nataa nae, ‘Ana ki, on! Mafarene matalolole dei. Faiꞌ fo o bei masoda nai dae-bafoꞌ a, o hapu katemaꞌ malole a. Tehuu Lasarus hapu noi susa a. De besaꞌ ia Ramtauaꞌa ooe-nanasi ni nai ia, tehuu o doidoso. ");
INSERT INTO rgu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lena-lenaꞌ, nai o mo ami talada, Manetualain tao pere maloaina a. De lahenda ta bisa neme iaꞌ mai leo naꞌ neu, ma neme naꞌ mai leo iaꞌ mai fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tutiꞌ a lahenda kamasuꞌi ria hule nae, ‘Kalu leoꞌ na, sona baꞌi Abraham madenu Lasarus leo au papa ka uma na neu dei. ");
INSERT INTO rgu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Huu fo au bei anuu fadi touꞌ lima rai na. Madenu Lasarus neu fee si nafarereneꞌ, fo ara ratafali leo Manetualain reu. Ela mate si sona, ara bosoꞌ masoꞌ leo mamana doidoso ia mai.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tehuu Abraham nataa nae, ‘Manetualain fee si baꞌi Musa no mana nesi mata ra dudui nara so. O fadi mara bisa lees rasarerein, de ara bubuluꞌ Manetualain hihii-nanaun.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tehuu lahenda kamasuꞌi ria, nadedea laka nae, ‘Baꞌi Abraham, e! Ria bei ta dai fa. Ara ta tao daleꞌ neuꞌ Manetualain Dedea-nafadan fa! Muste hapu lahenda mana mateꞌ, kalua neme rates daleꞌ mai fo neu nafada si, besaꞌ ko ara saledale-tuꞌetei nara.’ ");
INSERT INTO rgu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tehuu Abraham nataa nae, ‘Maneniko ara ta nau ramanene baꞌi Musa no Manetualain mana nesi mata nara dedea-nafadan fa, leo mae lehenda mana mateꞌ ara kalua reme rates daleꞌ mai fo reu dedea ro si boe, ara ta nau ramanene fa.” ");
INSERT INTO rgu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus nafada ana mana tuka dea nara nae, “Kadodou na hapu lahenda tuda rala salaꞌ dale, huu no lahenda fekeꞌ a duduku-papaun. Tehuu lahenda manaduduku-papauꞌ ria riꞌ hapu soe bauinaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maneniko lahenda ra duduku-papauꞌ, losa ana aanaꞌ ara ta nau ramahere neuꞌ Au, neuꞌ ko Manetualain fee ni huhuku mabera. Heke batu bauinaꞌ esa neuꞌ bolii na, fo tuꞌun leo tasiꞌ daleꞌ neu boe, ria nana bei kafaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","De, manea matalolole ao mara, ela emi bosoꞌ tao ma lahenda tuda leo salaꞌ a neu. Tehuu maneniko o toranoo ma tao nasalaꞌ, sona masaꞌai ni. Maneniko ana saledale-tuꞌetei na, ma ana hule ampon, sona mafarene heni sala na leo. ");
INSERT INTO rgu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maneniko nai faiꞌ esa dalen toranoo ma tao salaꞌ laiꞌ hitu, boe ma saledale-tuꞌetei na, basa de ana mai fo hule ampon laiꞌ hitu, sona o muste mafarene heni ria sala na laiꞌ hitu boe.” ");
INSERT INTO rgu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Faiꞌ esa, boe ma Yesus ana mana tuka dea nara mai rasare ran de hule rae, “Papa Mesen! Ami dale namahere ma ta teaꞌ a fa. De, tao matetea tamba ami namahere ma dei.” ");
INSERT INTO rgu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesus nataa nae, “Maneniko emi namahere ma neuꞌ Manetualain kuasa na, leo mae noi baianaꞌ a, tehuu emi bisa pareta ai huu inaꞌ ia mae, ‘Nanafaꞌu, fo marali tasiꞌ daleꞌ muu!’ Neuꞌ ko ai huuꞌ ria tuka tutiꞌ emi pareta ma.” ");
INSERT INTO rgu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Basa boe ma Yesus dedea bali nae, “Hai natutuduꞌ. Hapu ata fo foi dae nai okaꞌ, do nanea bibi-lopo nai mooꞌ a. Basa boe ma, ata ria fali uma neu. Leo mae leoꞌ bea boe, malaka na ta bisa nafada ni nae, ‘Mai fo ita dua taa-tinu sama-sama leo!’ ");
INSERT INTO rgu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Taꞌa! Naraa na, riꞌ malaka na nae, ‘Peda ma mei a fo au ua dei! Basa, sona besaꞌ ko o mua-minuuꞌ.’ ");
INSERT INTO rgu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Maneniko ata ria tao tuka malaka na hihii-nanaun, emi bate mae neuꞌ ko malaka ria hule makasi neuꞌ ana, do? Taꞌa! ");
INSERT INTO rgu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Emi leoꞌ na boe. Maneniko emi moi-tao ma basa-basan fo Manetualain pareta so a, sona emi mafada mae, ‘Ami nana noi lahenda nadedenuꞌ. Ami ta saka iꞌio fa. Ami malalaꞌo noi ami nonoi laka ma.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tepoꞌ fo Yesus asa leo Yerusalem reu, ara losa propinsi Galilea no propinsi Samaria a too na. ");
INSERT INTO rgu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ara sakaꞌ masoꞌ leo koroꞌ esa nai na reu, hapu lahenda kamahedi kusta sanahulu mai, fo nau raneta ro Yesus. Ara rapadei nai dooꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Basa boe ma ara raloo belaꞌ a rae, “Yesus! Ramatuaꞌ! Kasian neuꞌ ami dei!” ");
INSERT INTO rgu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus nita si, boe ma Ana nadenu nae, “Emi meu matudu ao-ina mara nai malaka agama ra dei, fo ela ara parisaꞌ rae, emi hedi kusta mara mopo si so, do beiꞌ.” Ramanene leoꞌ na, boe ma ara reu. Tehuu nai eno taladaꞌ, kekeneu te, basa si ao-ina nara makamoiꞌ tutiꞌ a so. ");
INSERT INTO rgu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ara laꞌo raroo no dale namahoꞌo. Tehuu sira esa fali seluꞌ leo Yesus neu. Ana heꞌi-heꞌi mesan nae, “Io-oa neuꞌ Manetualain! Huu fo au ao-ina ka makamoiꞌ a so!” ");
INSERT INTO rgu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Boe ma ana sundaꞌ undulaka na, fo hule makasi neuꞌ Yesus. (Sekonaa te ria, nana lahenda ta Yahudi fa. Ria lahenda Samaria fo radedea ro lahenda Yahudi ra laꞌo naroo.) ");
INSERT INTO rgu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Boe ma Yesus dedea no basa lahenda fo tuka Ni a nae, “Bisinaꞌ a Au puli a lahenda sanahulu, hete? Tehuu sio rai bea? ");
INSERT INTO rgu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ubeaꞌ taon de noi lahenda mana mai ia riꞌ natafali mai, fo hule makasi neuꞌ Manetualain, ma io-oa neuꞌ Ana?” ");
INSERT INTO rgu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Boe ma Ana nafada lahenda ria nae, “Huu no mamahere tebe-tebe neuꞌ Au, de o teꞌe ma aom. Foa fo fali no soda-moleꞌ leo!” ");
INSERT INTO rgu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Faiꞌ esa boe ma, lahenda Farisi hida mai ratane Yesus rae, “Papa Mesen! Soba mafada dei! Fai hidaꞌ rina Manetualain mai pareta nai dae-bafoꞌ a?” Yesus nataa nae, “Leo iaꞌ! Manetualain pareta nai dae-bafoꞌ a, ta mulai neniꞌ tanda fo lahenda bisa ritan. Boe ma lahenda ta bisa natudu buti nae, ‘Mita, Manetualain pareta nai ia, do nai ele!’ Huu fo Ana pareta nai emi talada nai lahenda dae-bafoꞌ a dalen.” ");
INSERT INTO rgu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Boe ma Yesus nafada ana mana tuka dea nara nae, “Ta dooꞌ a fa, te Au, Ana Lahenda, ta sama-sama oo emi soꞌ. Neuꞌ ko fai susa-lela a, te emi mahiiꞌ mita Au fai mamai Ka. Tehuu Au bei ta mai fa. ");
INSERT INTO rgu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kalu lahenda rafada rae, ‘Kristus nai ia!’, do, ‘Kristus nai ele!’ sona bosoꞌ kalua meu masakaꞌ, huu fo ara dedea fufudiꞌ ria. ");
INSERT INTO rgu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Huu fo neuꞌ ko Ana Lahendaꞌ a natafali mai, tanda na sama leoꞌ relas a narela nahaa-nakaledo nai lalai bukun haas. ");
INSERT INTO rgu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tehuu Ana lepa-nasaa masososa doidoso rupaꞌ dei. Ma lahenda besaꞌ ia tipa-tola Ana. ");
INSERT INTO rgu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Boe ma maneniko Ana sakaꞌ natafali mai, lahenda ra masoda nara sama leoꞌ nai Noh tepo na. ");
INSERT INTO rgu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noh tepo na nana lahenda ta nau ramanene fa, raa-rinu ma sao ana, losa Noh masoꞌ ofa daleꞌ neu. Boe ma, faa ina a mai, de namate basa si. ");
INSERT INTO rgu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ria sama leoꞌ nai Lot tepo na boe, lahenda ta nau ramanene fa. Ara raa-rinu, seꞌo-asa, sele-tande ma rafoa uma. ");
INSERT INTO rgu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tehuu fai fo Lot kalua ela Sodom, boe ma uda ai-pilaꞌ ma balerang onda neme lalai mai, de naa heni laiꞌ esaꞌ asa. ");
INSERT INTO rgu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","De, emi besa-besa, o! Boso losa fai fo Ana Lahendaꞌ a nau natafali mai, lahenda ra masoda nara leo-leoꞌ na. Tehuu kekeneu te Ana toda mai. ");
INSERT INTO rgu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Faiꞌ ria, lahenda fo nai uma a titise mata na, bosoꞌ boe uma daleꞌ neu fo nafafau bali. Lahenda mana noi nai oka-tine, bosoꞌ boe fali uma fo hai hata bali. ");
INSERT INTO rgu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mafarene hata fo maulu na dadi neuꞌ Lot sao na a. Ana mate, nana huu nafarene hata-heton nai uma. ");
INSERT INTO rgu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Lahenda fo ta nau tuka Au, huu no sue ao-ina na, neuꞌ ko soda na mana dadi taꞌ. Tehuu lahenda fo nau tuka Au losaꞌ fee heni ria ao-ina na nana huu sue Au, neuꞌ ko ana hapu sodaꞌ a, ma nasoda naroo no Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Au afada memaꞌ! Tepoꞌ fo Ana Lahendaꞌ a natafali mai, maneniko hapu lahenda dua suku rabua rai mamana susukuꞌ esa, kekeneu te Manetualain soꞌu naaeꞌ esa, ma foa ela esa. ");
INSERT INTO rgu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Maneniko hapu inaꞌ dua rapau sama-sama, neuꞌ ko Manetualain soꞌu naaeꞌ esa, ma foa ela fekeꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Maneniko hapu lahenda dua roi nonoi-tataoꞌ sama-sama nai oka-tine, neuꞌ ko Manetualain soꞌu naaeꞌ esa, ma foa ela fekeꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus ana mana tuka dea nara ramanene ra ria, boe ma ara ratane Ni rae, “Papa Mesen! Neuꞌ ko basa sira dadi rai bea?” Boe ma Yesus tuꞌu dedeaꞌ nae, “Leo iaꞌ. Maneniko emi mita manupui mana naa banda mates ara laa rabua rai bea, emi bubuluꞌ tanda ria so nae, tantu ara raa banda mates rai mamanaꞌ ria.” Ma sosoa-raraan mana mafuniꞌ, de neuꞌ ko Kristus natafali mai, ria tanda na ledo-ledo, maneniko lahenda lees ralelaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Laiꞌ esa de, Yesus nanori ana mana tuka dea nara pake dedea nasasamaꞌ, fo ela ara hule-haradoi bosoꞌ namaeetun, ma bosoꞌ mopo ao masee nara. Ara muste ramahere raroo neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tutui na leo iaꞌ: “Nai kota esa hapu mana ee dedeaꞌ esa, ana ta tao daleꞌ neuꞌ Manetualain fa. Ana ta nalelaꞌ neuꞌ lahenda esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nai na boe hapu ina-falu esa, ana mai kokosen leo mana ee dedeaꞌ ria mai fo hule ni nae, “Papa mana ee dedeaꞌ! Maetuꞌ au dedea ka no matetuꞌ, ó!’ ");
INSERT INTO rgu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Masososa na mana ee dedeaꞌ a, ta tao daleꞌ neuꞌ ina-falu ria fa. Tehuu doo-doo boe ma ana doaꞌ namanene neuꞌ ana. Ana natuuꞌ de aafi nae, ‘Tebe au ia nana ta tao daleꞌ neuꞌ Manetualain, lena-lenaꞌ neuꞌ lahenda dae-bafoꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tehuu ina-falu ia tao na au laka ka dile. Huu ria na, malole lenaꞌ au aetuꞌ ria dedea na no matetuꞌ dei. Taꞌa sona, neuꞌ ko noi mai-maiꞌ a fo tao nasosota au laꞌo naroo.’ ");
INSERT INTO rgu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Soba emi afi maneni mana ee dedeaꞌ tadaluꞌ ria dedea-nafadan. ");
INSERT INTO rgu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Doo-doo boe ma maneniko ana tulu-fali neuꞌ ina-falu ria, tantu Manetualain boe nau tulu-fali neuꞌ Ria lahendan, fo hatu-leledon hule-haradoi ma hule tutulu-fafaliꞌ neuꞌ Ana. Tehuu Manetualain ta eladeiꞌ fa. ");
INSERT INTO rgu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Huu fo Ana parisaꞌ lalaiꞌ sira dedea na. De, Au nau afada ae leoꞌ ia: maneniko Au, Ana Lahendaꞌ ia, atafali mai, sona bate Au bei bisa aneta oo lahenda kamahereꞌ nai dae-bafoꞌ a, do taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus tui seluꞌ nasasamaꞌ esa, laꞌeneuꞌ natutua-nadedema aoꞌ a, ma ta hika-hadaꞌ lahenda fekeꞌ a fa. Ana tui nae, ");
INSERT INTO rgu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Touꞌ dua reu hule-haradoi nai Uma Mamaso Ina a. Esa nana lahenda agama Farisi; esa bali, mana susu bea. Lahenda Yahudi ra tao lahenda Farisi ra neuꞌ, lahenda makamoiꞌ. Tehuu ara tao mana susu bea ra, reuꞌ lahenda tadaluꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Losa uma mamasoꞌ daleꞌ, boe ma lahenda Farisi ria mesaꞌ ana napedei fo hule-haradoi nae, ‘Makasi dodouꞌ Ramatuaꞌ, huu fo au ia, lahenda malole. Au ta tadaluꞌ a sama leoꞌ lahenda fekeꞌ ara. Au ta amanaꞌo fa. Au ta mana tendetuꞌ. Au ta hohoke fa. Makasi dodou, Ramatuaꞌ, huu fo au ta tadaluꞌ sama leoꞌ mana susu bea ia fa. ");
INSERT INTO rgu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Au makate puasa mamasoꞌ esa sona laiꞌ dua. Ma neme basa au hahapu ka mai, au fee laꞌo naroo babatiꞌ esa neme babatiꞌ sanahulu mai.’ Lahenda Farisi ria huhule-haradoi na nae leoꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tehuu mana susu bea ria napadei nahaniꞌ dooꞌ a nai lahenda Farisi ria dea na. Ana ta naparani botiꞌ laka na fo mete leo lalai neu. Ana naloe laka na de hule-haradoi no dale hediꞌ nae, ‘Oo! Manetualain. Kasian neuꞌ au, lahenda masala-masikoꞌ ia! Fee ampon neuꞌ au!’ ");
INSERT INTO rgu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Fai fo lahenda kaduaꞌ sira fali reu si, bea rina malole no Manetualain? Lahenda Farisi mana koaoꞌ ria, do lahenda mana susu bea ria? Tantu Ana sipoꞌ natalolole mana susu bea dale maloe-madae aoꞌ ria. Tehuu Ana ta tao daleꞌ neuꞌ lahenda Farisi ria fa. Huu fo Manetualain natuda lahenda manakoaoꞌ a, tehuu Ana soꞌu-fua lahenda maloe-madae aoꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Laiꞌ esa de, lahenda ra oꞌo roo ana boki beu nara leo Yesus reu, ela Ana fua lima Na neu ma nafada fee si ua-naleꞌ. Yesus ana mana tuka dea nara rita leoꞌ na, boe ma ara rasaꞌai lahenda sira. ");
INSERT INTO rgu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Tehuu Yesus sipoꞌ na ana mana maiꞌ sira. Basa boe ma Ana nasaꞌai ana mana tuka dea nara nae, “Nemeꞌna ela ana aanaꞌ sira leo Au mai. Bosoꞌ matabaa si. Mafarereneꞌ matalolole! Te lahenda fo nau dadi neuꞌ Manetualain lahendan, ana muste namahena neuꞌ Ana, sama leoꞌ ana aanaꞌ ara ramahena neuꞌ ina-ama nara.” ");
INSERT INTO rgu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Laiꞌ esa de, lahenda Yahudi ra lahenda bauinan esa mai natane Yesus nae, “Papa Mesen manuu hada-horomataꞌ! Au muste tao leo beaꞌ ela au bubuluꞌ matetuꞌ ae, au bisa masoꞌ nusatetu-ikutemaꞌ a fo asoda aroo oo Manetualain?” ");
INSERT INTO rgu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Boe ma Yesus nataa nae, “Ubeaꞌ taon de o hule Au mae, ‘manuu hada-horomataꞌ’? Noi esaꞌ a nanuu hada-horomataꞌ, nana riꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O, bubuluꞌ so hete, Manetualain atoran a neme uluꞌ mai, nae: Bosoꞌ hohoke; bosoꞌ maisa lahenda; bosoꞌ mamanaꞌo; bosoꞌ sakasii pepekoꞌ; ma fee hada-horomata neuꞌ o ina-ama mara.” ");
INSERT INTO rgu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lahenda ria nataa nae, “Tebe, Papa! Au tao tuka atoran sira mulai neme au bei aanaꞌ ki ria mai.” ");
INSERT INTO rgu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus namanene leoꞌ na, boe ma nae, “Malole a! Tehuu bei hihii-nanauꞌ esa bali. Riꞌ, besaꞌ ia o fali fo seꞌo heni katemaꞌ hata-heto mara. Basa ria, nana muu babati doiꞌ sira fee lahenda manatoꞌa-manataaꞌ ara. Besaꞌ ko o mai fo tuka Au. Huu fo neuꞌ ko Manetualain balas fee o hata nai nusatetu-ikutemaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lahenda ria namanene leoꞌ na, boe ma dale na hedis a, huu fo namasuꞌi naan seli. ");
INSERT INTO rgu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus nita ni fali tehuu dale na nalulutuꞌ, boe ma Ana nafada ana mana tuka dea nara nae, “Susa lai esaꞌ lahenda kamasuꞌi a masoꞌ nusatetu-ikutemaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ita tararaaꞌ ana no hihii-nanauꞌ fekeꞌ. Leo mae leoꞌ bea boe banda onta kabaꞌuina a, ta bisa kodi nesi rarauꞌ a bolo na, fo leo roka na neu. Leoꞌ na boe lahenda fo namahena noi hata-heto dae-bafoꞌ a, tehuu ta namahena neuꞌ Manetualain, sona leo mae leoꞌ bea boe ana ta bisa maso leo nusatetu-ikutemaꞌ a neu fa.” ");
INSERT INTO rgu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lahenda fo ramanene Yesus dedea nae leoꞌ na, ara ratane Ni rae, “Kalu memaꞌ susa neuꞌ lahenda kamasuꞌi a leo naꞌ, sona lahenda rupa leo beaꞌ a riꞌ bisa hapu sodaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus nataa nae, “Leo mae leoꞌ bea oo, soa neuꞌ lahenda dae-bafoꞌ a sona, hihii-nanauꞌ dodouꞌ ta bisa fa. Tehuu soa neuꞌ Manetualain sona basan bisa dadi.” ");
INSERT INTO rgu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Boe ma Petrus sipoꞌ nae, “Papa! Ami laꞌo ela ami hata-heto mara katemaꞌ so, fo tuka Papa. Tehuu neuꞌ ko ami hapu ubea?” ");
INSERT INTO rgu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus nataa nae, “Petrus! Nenene matalolole! Lahenda fo foa ela uma na, sao ina na, aꞌa-fadi nara, ina-ama nara, do ana nara, nana huu ana nalalaꞌo nonoi lakaꞌ neme Manetualain mai, ");
INSERT INTO rgu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tantu ana sipo faliꞌ desi lena nai dae-bafoꞌ ia. Basa te maneniko dae-bafo ia noe, ria boe nasoda naroo no Manetualain.” ");
INSERT INTO rgu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus noo ana mana tuka dea kasanahulu duaꞌ nara, fo dedea no noi mesaꞌ asa nae, “Emi basa bubuluꞌ so mae, besaꞌ ia ita leo kota Yerusalem teu. Losa na, te basa hihii-nanauꞌ fo Manetualain mana nesi mata nara duiꞌ ran nai maulu so a, laꞌeneuꞌ Ana Lahendaꞌ a, neuꞌ ko dadi sama leoꞌ hata fo ara duiꞌ ana so. ");
INSERT INTO rgu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Neuꞌ ko ara fee heni Au leo lahenda mana mai, fo ta ramahere neuꞌ Manetualain. Basa te ara ramumulu-ramamaeꞌ ma radadae rupaꞌ ara neuꞌ Au, mudi radiu Au ape, ");
INSERT INTO rgu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","fepa-liꞌu Au, basa nate raisa Au. Tehuu fai binesa na, te Au asoda seluꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ana mana tuka dea ra ramanene Yesus dedea nae leoꞌ na, boe ma roi patararaaꞌ a, nana huu ara bei ta bisa rala dedeaꞌ sira sosoa-raraan fa. ");
INSERT INTO rgu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Faiꞌ fo Yesus asa sakaꞌ masoꞌ leo kota Yeriko reu, ara raneta ro lahenda pokeꞌ esa natuuꞌ nai enoꞌ a suu na, fo nalamemei. ");
INSERT INTO rgu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ana namanene lahenda dodouꞌ resiꞌ na, boe ma natane nae, “Ae! Ubeaꞌ ia?” ");
INSERT INTO rgu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Boe ma lahenda rafada ni rae, “Yesus, neme Nasaret mai, nesiꞌ ia.” ");
INSERT INTO rgu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Lahenda pokeꞌ ria namanene leoꞌ na, boe ma ana naloo namberaina nae, “Yesus! Mane Daud a tititi-nonosin, e! Kasian neuꞌ au dei!” ");
INSERT INTO rgu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lahenda fo laꞌo rai Yesus mata na a, rasaꞌai ni fo neneeꞌ. Tehuu ana naloo namberaina bali nae, “Mane Daud a tititi-nonosin, e! Kasian neuꞌ au dei!” ");
INSERT INTO rgu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus namanene, boe ma Ana napadei. Basa de Ana nadenu lahenda relu hela ra lahenda pokeꞌ ria. Losa Yesus mata Na, boe ma Ana natane ni nae, ");
INSERT INTO rgu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O nau Au tao ubeaꞌ fee o?” Ana nataa nae, “Papa! Au hule fo bisa ita dae.” ");
INSERT INTO rgu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus nataa ni nae, “Malole a. Huu no o mamahere mae, Au bisa puli a o, de besaꞌ ia bisa mita dae so.” ");
INSERT INTO rgu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kekeneu te lahenda mata pokeꞌ ria, nita dae tutiꞌ a so. Boe ma ana tuka Yesus asa ma io-oa neuꞌ Manetualain. Basa lahenda fo rita leoꞌ na boe, ara io-oa neuꞌ Manetualain. ");
INSERT INTO rgu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Basa boe ma Yesus asa laꞌo raroo, ara masoꞌ tuka kota Yeriko. ");
INSERT INTO rgu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nai na hapu lahenda esa nade Sakeos. Ria nana malaka mana susu bea fee mana pareta Roma. Ma ria lahenda kamasuꞌi. ");
INSERT INTO rgu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ana namanene Yesus sakaꞌ nesiꞌ na, boe ma ana nahiiꞌ nita Yesus. Tehuu ana ta bisa nita no matetuꞌ fa, huu fo lahenda dodouꞌ eo ra Yesus, ma ria ao-ina na eetuanaꞌ a esan. ");
INSERT INTO rgu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huu ria na de ana nalai naꞌuluꞌ, boe ma ae neuꞌ ai huuꞌ esa lain nai enoꞌ a suu na, fo Yesus sakaꞌ nesiꞌ na a. ");
INSERT INTO rgu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus losa ai ria huu na, boe ma Ana relu leo lain neu. Basa de naloo Sakeos nae, “Sakeos! Onda leo! Malaiꞌ a, huu fo faiꞌ ia Au nau tuli o uma ma.” ");
INSERT INTO rgu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeos noi namakokoaꞌ a. Boe ma ana onda lai-lai, basa de ana noo Yesus leo uma na neu. Dale na namahoꞌo naan seli. ");
INSERT INTO rgu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tehuu lahenda kadodou inaꞌ ara ramumuu rae, “Ae! Sakeos ia, nana lahenda tadaluꞌ! Ubeaꞌ taon de Yesus neu tuli uma na?! Basa lahenda ra bubuluꞌ so!” ");
INSERT INTO rgu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Losa uma boe ma, Sakeos foa napadeiꞌ nai Yesus mata na, de ana dedea nae, “Papa Mesen! Mulai neme faiꞌ ia mai, au bati dua hata-heto kara katemaꞌ, fo fee lahenda manatoꞌa-manataaꞌ ara babatiꞌ esa. Maneniko au parna susu bea ala lenaꞌ, au fee faliꞌ asa laiꞌ haa.” ");
INSERT INTO rgu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus nataa nae, “Malole a. Faiꞌ ia Manetualain fee soda-moleꞌ neuꞌ o mo kileoboboki mara katemaꞌ, huu fo o mamahere neuꞌ Manetualain sama leoꞌ baꞌi Abraham. ");
INSERT INTO rgu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Huu fo Manetualain nadenu neuꞌ Au dadi uuꞌ Ana Lahenda nai dae-bafoꞌ ia. Au mai nana saka lahenda fo sala-mopo neme Manetualain eno na mai, ela poꞌi-tata a si.” ");
INSERT INTO rgu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Faiꞌ ria nana lahenda dodouꞌ ramanene neuꞌ Yesus. Ara raneneaꞌ kota Yerusalem. Ma sira dale nara rae Ana leo Yerusalem neu, nana ela pareta sama leoꞌ Maneꞌ fo Manetualain helu basa so a. Boe ma Yesus tui fee si dedea nasasamaꞌ esa bali, ");
INSERT INTO rgu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nae, “Lahenda bauinaꞌ esa sakaꞌ leo nusa dea neu, fo ara feo lesu ni dadi mane. Basa sona dei ana fali leo nusa na neu. ");
INSERT INTO rgu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Fai fo ana nahehere aon sakaꞌ laꞌo, ana naloo na ata ni sanahulu, de fee si lahenda esa na doi lilopilas esa. Ana pareta nae, ‘Emi pake doiꞌ ia ra fo papalele meniꞌ. Faiꞌ bea au fali mai, emi mafada au emi hapu doi bunaꞌ hida.” Basa boe ma ana laꞌo. ");
INSERT INTO rgu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tehuu lahenda nusa isi nara eteꞌ ao nara roon. De ara radenu lahenda tuka reu rafada rae, ‘Ami ta mahiiꞌ lahenda ia dadi maneꞌ fee ami fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Leo mae leoꞌ na, tehuu ara feo lesu ni nai na. Basa boe ma ana fali neun. Losa uma, boe ma naloo na lahenda mana noi kasanahuluꞌ sira, de natane si nae, ‘Emi hapu bunaꞌ hida neme doi lilopilas fo riꞌ au fee emi a?’ ");
INSERT INTO rgu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lahenda mana noi masososaꞌ a nafada nae, ‘Papa mane! Au onto laiꞌ sanahulu so, neme doi poko fo au sipo a!’ ");
INSERT INTO rgu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Boe ma maneꞌ a nafada ni nae, ‘Malole a! O ia, nana lahenda mana noi malole. Huu no au bisa amahere neuꞌ o neniꞌ hihii-nanauꞌ aanaꞌ ara, huu ria na de besaꞌ ia au soꞌu o fo pareta kota sanahulu.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lahenda mana noi kadua a nafada nae, ‘Papa maneꞌ! Au onto doi lilopilas lima neme doi poko fo au sipo a.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Basa, boe ma maneꞌ a io ni nae, ‘Malole a! Kalu leoꞌ na, sona au soꞌu o fo pareta kota lima.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tehuu lahenda mana noi katelu a neni faliꞌ ria doi lilopilas na. Ana nafada nae, ‘Papa ia doi ma! Au poti an, de afuni matalololen ela bosoꞌ mopo ni. ");
INSERT INTO rgu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au tao leo naꞌ, huu fo au biiꞌ. Au bubuluꞌ papa nana lahenda bita-bataꞌ. Huu no papa mahiiꞌ hai hata fo papa ta nuum fa, ma etu-seu hata fo papa ta sele-tande fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Maneꞌ a namanene leoꞌ na, boe ma nasapaa ni nae, ‘O ia, manori taꞌ! O dedea-nafadam huku seluꞌ ao-ina ma so. O bubuluꞌ au ia nana lahenda bita-bataꞌ, de hai hata fo au ta anuu ni, ma etu-seu hata fo au ta sele-tande ni. ");
INSERT INTO rgu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kalu leoꞌ na, sona ubeaꞌ taon de o ta muu peda doiꞌ ia neuꞌ bank a fa? Fo ela faiꞌ fo au fali mai ka, au bisa hapu buna na. Leo mae bai anaꞌ boe malole a.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Boe ma maneꞌ ria nadenu lahenda fekeꞌ manai na ra nae, ‘Hai ma doi ni ria, fo feen leo lahenda mana noi fo bisinaꞌ a ana onto laiꞌ sanahulu a.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tehuu ana nadedea laka nae, ‘Papa! Lahenda ria hapu nan nana dai so. Bosoꞌ boe fee tamba seluꞌ ana bali.’ ");
INSERT INTO rgu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tehuu maneꞌ a nataa nae, ‘Dodoo matalolole! Kalu lahenda bea urus nalelaꞌ hata fo ria homu a, neuꞌ ko ana hapu tamba seluꞌ bali. Tehuu lahenda bea ao na mataꞌ a urus, neuꞌ ko hai fali basa hata fo ana nanuu a. ");
INSERT INTO rgu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Besaꞌ ia au musunook fo ta rahiiꞌ au, dadi mane fee si a, moo si leo iaꞌ mai fo tati heni si naiꞌ au mata ka.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus tui basa, boe ma ara laꞌo raroo leo kota Yerusalem reu. Yesus laꞌo nesiꞌ uluꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Faiꞌ fo ara sakaꞌ raneneaꞌ roo koroꞌ dua, siꞌ Betfage no Betania, fo nai lete Saitun suu na, boe ma Ana nadenu ana mana tuka dean dua reu rauluꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ana nadenu si nae, “Emi dua leo koroꞌ fo nai mata ria meu. Neuꞌ ko emi mita keledei anaꞌ esa mana hekeꞌ nai na. Lahenda bei ta parna saꞌe ni fa. Emi dua sefi man fo hela meni ni leo iaꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tehuu maneniko lahenda ratane rae, ‘Ubeaꞌ taon de emi sefi heni keledei ria tali na?’ sona mafada si mae, ‘Ami Ramatua ma nau pake ni.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Basa de, dua si reu, boe ma raneta ro keledei anaꞌ ria, sama leoꞌ Yesus nafada na. ");
INSERT INTO rgu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dua si bei sefi heni keledei anaꞌ ria tali na, boe ma manuuꞌ a natane si nae, “Ubeaꞌ taon de emi sefi poꞌi keledei ia?” ");
INSERT INTO rgu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Boe ma ara rataa rae, “Ami Ramatua ma noi pake ni.” ");
INSERT INTO rgu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Manuuꞌ a sipoꞌ no malole, basa de dua si hela reni keledei anaꞌ ria leo Yesus neu. Ara bela lafa nara reuꞌ keledei anaꞌ ria koti ai na. Boe ma rasasaꞌe Yesus neuꞌ lain, ");
INSERT INTO rgu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lahenda dodouꞌ hai ra lafa nara, ma lafa ana nasaa nara, de bela si reuꞌ enoꞌ lain, fo sipoꞌ Yesus sama leoꞌ sipoꞌ lahenda bauinaꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Faiꞌ fo Ana mulai onda neme lete Saitun a mai, boe ma lahenda kadodou inaꞌ sira roo Yesus ana mana tuka dea nara mulai heꞌi ma io-oa neuꞌ Manetualain, nana huu basa tanda kuasa fo ara rita ni a. ");
INSERT INTO rgu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ara heꞌi rae, “Ia nana, Maneꞌ fo Manetualain nadenu ni mai! Manetualain fee Ni ua-naleꞌ! Besaꞌ ia, lahenda dae-bafoꞌ a bisa mole-dame ro Ramatuaꞌ a nai nusatetu-ikutemaꞌ a. Io-oa neuꞌ Ramatuaꞌ fo natuuꞌ pareta nai lalai madema ina a.” ");
INSERT INTO rgu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tehuu hapu lahenda Farisi rai lahenda kadodou inaꞌ sira talada. Ara rafada Yesus rae, “Papa Mesen! Masaꞌai si fo bosoꞌ ara heꞌi leoꞌ na, huu fo ia seli uukuꞌ a so!” ");
INSERT INTO rgu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tehuu Yesus nataa nae, “Ae! Au afada memaꞌ! Maneniko lahenda ia ra ta rahahara fa, sona batu ra io-oa neuꞌ Manetualain!” ");
INSERT INTO rgu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Faiꞌ fo ara sakaꞌ masoꞌ leo Yerusalem reu, Yesus nita kota ria, boe ma Ana dola, ");
INSERT INTO rgu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nae, “Adoo, lahenda Yerusalem, emin! Au nau faiꞌ ia emi sipo mole-dame fo Au uni a. Tehuu no emi ta taoꞌ daleꞌ neuꞌ Manetualain, besaꞌ ia emi mababakoꞌ, de mole-dame ria dooꞌ a neme emi mai so. ");
INSERT INTO rgu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Neuꞌ ko emi musunoo mara poꞌa dae feo kota a tembok na, basa nana ara masoꞌ reu suu emi. ");
INSERT INTO rgu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ara rarerefaꞌ heni emi kota ma nabebelaꞌ no dae a, basa nana raisa katemaꞌ emi mo ana mara. Ara ta foa ela batu esa napadei boeꞌ, nana huu Manetualain mai so fo nau fee emi sodaꞌ a, tehuu emi ta nau malelaꞌ Ana fa!” ");
INSERT INTO rgu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Basa boe ma Yesus masoꞌ leo Uma Mamaso Ina a daleꞌ neu. Nai uma ria mata na, lahenda ra taon dadi neuꞌ pasar so fo raseꞌo banda tutunu-hohotuꞌ. Yesus nita leoꞌ na, boe ma Ana neu usi heni si reme naꞌ mai. ");
INSERT INTO rgu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ana nasapaa nae, “Manetualain mana nesi mata nara duiꞌ memaꞌ rae, ‘Au afoa Uma ia, ela basa lahenda ra bisa mai hule-haradoi nai ia.’ Tehuu emi tao ni dadi neuꞌ parampok ara mamana nabuan.” ");
INSERT INTO rgu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Basa ria, boe ma tuka-tuka faiꞌ Yesus leo Uma Mamaso Ina a neu, fo nanori-nafada nai na. Tehuu malaka agama Yahudi a Malaka bau-ina nara, mesen agama ma lasi Yahudi ra, rasaka enoꞌ fo nau raisa Ni. ");
INSERT INTO rgu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tehuu ara ta hapu enoꞌ fa, nana huu lahenda kadodou inaꞌ sira ramahoꞌo raan seli nau ramanene Yesus dedea-nafadan. ");
INSERT INTO rgu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Faiꞌ esa boe ma, Yesus leo Uma Mamaso Ina a neu, basa de nanori-nafada Manetualain Tutui Malole Na, nai Uma a mata na. Boe ma malaka agama Yahudi a malaka bau-ina nara, mesen agama ra, ma lasi nara mai ratatane aoꞌ roo Ni. ");
INSERT INTO rgu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ara ratane rae, “Bea fee hak neuꞌ O fo useleꞌ a tao taohiro-taohari nai ia? Soba mafada dei!” ");
INSERT INTO rgu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Boe ma Yesus nataa nae, “Au boe nau atane hihii-nanauꞌ esa, basa dei Au ataa neuꞌ emi. ");
INSERT INTO rgu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Leo iaꞌ: emi malelaꞌ Yohanis Mana Saraniꞌ a, hete? Bea feen kuasa de ana sarani lahenda? Manetualain do, lahenda dae-bafoꞌ a?” ");
INSERT INTO rgu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Boe ma ara dedearaoꞌ reu-mai, ma beidea rae, “Ae! Laꞌe ita ia so. Maneniko ita tae, ‘Manetualain riꞌ nadenu’, neuꞌ ko Ana nataa natafaliꞌ ita nae, ‘Kalu leoꞌ na, sona ubeaꞌ taon de emi ta nau mamahere neuꞌ Yohanis fa?’ ");
INSERT INTO rgu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tehuu ita boe ta bisa tae, ‘lahenda dae-bafoꞌ a riꞌ nadenu’, te neuꞌ ko lahenda ia ra here batu fo pia raisa ita. Huu fo ara ramahere rae, Yohanis nana, Manetualain mana nesi matan.” ");
INSERT INTO rgu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Basa boe ma ara rataa Yesus rae, “Ami ta malelaꞌ fa.” ");
INSERT INTO rgu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Boe ma Yesus nataa natafaliꞌ asa nae, “Kalu leoꞌ na, sona Au boe ta nau afada ae bea riꞌ nadenu Au fa.” ");
INSERT INTO rgu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Basa boe ma, Yesus tui lahenda kadodou inaꞌ sira, dedea nasasamaꞌ esa bali nae, “Hapu lahenda esa nanuu oka anggor. Ana seba okaꞌ ria neuꞌ mana noi ra, fo ara rabatiꞌ buna-boaꞌ. Boe ma ana narali leo nusa dea neu de leo namanoso nai na. ");
INSERT INTO rgu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Losa faiꞌ eetu boa anggor, boe ma manuu okaꞌ a nadenu atan esa, fo neu sipo ria nuu babati na neme mana noi ra mai. Tehuu mana noi ra popoꞌo ataꞌ ria, basa boe ma ara usi henin neu ni no lima rou. ");
INSERT INTO rgu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Basa de, manuu okaꞌ a fee atan esa neu bali. Tehuu mana noi okaꞌ ara popoꞌo ni, ma ramamaeꞌ ana. Boe ma ara usi faliꞌ ana no lima rouꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Boe ma manuu okaꞌ a fee seluꞌ ria ata kateluꞌ a neu, tehuu ara popoꞌo ran hina-hinaꞌ mesan, basa boe ma tuꞌu ni leo deaꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Manuu okaꞌ a natuuꞌ de aafi nae, ‘Au muste tao leoꞌ bea bali? Malole lenaꞌ au fee ana susue ka neu. Tantu ara hadaꞌ ana, ma sipoꞌ ana no malole.’ De ana fee ana boki na leo naꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tehuu faiꞌ fo mana noi okaꞌ ara rita ni, boe ma ara beidea rae, ‘Ae, emi mete dei! Huu fo tou lasiꞌ a fee ana na mai mataꞌ. Ria riꞌ neuꞌ ko sipo tou lasiꞌ a pusaka nara katemaꞌ. De, mai fo ita taisa ni leo! Ela ita riꞌ soa okaꞌ ia.’ ");
INSERT INTO rgu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Anaꞌ ria bei losa, boe ma ara rosotatataꞌ renin neme okaꞌ ria daleꞌ mai leo deaꞌ neu, basa de raisa ni. Au nau atane leo iaꞌ: emi afi man nana manuu okaꞌ a tao mana noi sira leoꞌ bea? ");
INSERT INTO rgu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tuka Au, tantu ana mai fo naisa katemaꞌ asa, basa nate ana seba okaꞌ ria leo lahenda fekeꞌ neu.” Faiꞌ fo lahenda sira ramanene Yesus dedea nae leoꞌ na, boe ma ara bubuluꞌ rae, Yesus dedea laꞌeneuꞌ sira mauli-malaka nara. Boe ma ara rataa rae, “Kalu bisa, sona Manetualain bosoꞌ fee ami huhukuꞌ leo naꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Basa de Yesus mete nahere si, boe ma natane nae, “Kalu ta dadi fee huhuku leo naꞌ, sona ubeaꞌ taon de Manetualain mana nesi mata nara duiꞌ rae leoꞌ ia: ‘Hapu batu esa tukan ara tuꞌu henin so, tehuu besaꞌ ia dadi neuꞌ dii tokaꞌ a batu natende na so?’ ");
INSERT INTO rgu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lahenda fo natundu batu ria, tantu sopuꞌ, huu fo ana hapu huhukuꞌ. Ma maneniko batu ria tuda laꞌe lahenda, ria boe sopuꞌ henin, huu fo laꞌe huhukuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Faiꞌ fo mesen agama ra, ro malaka agama a malaka nara ramanene tutuiꞌ ria, ara bubuluꞌ rae, Yesus dedea soa neuꞌ asa pake dedea nasasamaꞌ ria. Sira nana sama leoꞌ mana noi okaꞌ a, de ramanasa mamateꞌ. Boe ma ara saka enoꞌ fo nau hopu ran. Tehuu ara lele lahenda kadodou inaꞌ fo rahiiꞌ Yesus nanori-nafadan. De, ara laꞌo elan mesaꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Basa ria, boe ma Yesus musunoo nara mamaꞌu Ni. Ara saka mana lalafa fo bisa tao ao nara leoꞌ lahenda neulauꞌ a, ela rahihiiꞌ Yesus. Ara ramahehenaꞌ Yesus bisa dedea soaꞌ mana pareta Roma, basa nana ara reu kolaaꞌ nai gubernor a, fo ela ana nadenu lahenda reu hopu ra Yesus. ");
INSERT INTO rgu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Boe ma ara fee mana lalafa ra reu fo ratatane aoꞌ ro Yesus rae, “Papa Mesen! Ami bubuluꞌ Papa dale ma roos a. Papa ta mapuputaꞌ fa, ma ta here mataꞌ fa. Papa manori-mafada Manetualain Dedea-nafadan no matetuꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Besaꞌ ia ami sakaꞌ matane hihii-nanauꞌ esa: tuka ita atoran agama Yahudi na, ee ita bole bae bea fee mana pareta Roma mane bau-ina na, do taꞌa?” ");
INSERT INTO rgu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tehuu Yesus bubuluꞌ sira duduꞌa-aafi tadalu nara fo nau rahihiiꞌ Ana. Boe ma Ana nataa nae, ");
INSERT INTO rgu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Soba matudu Au doi fulaꞌ esa dei.” Boe ma ara ratudu Ni doiꞌ ria. Basa de Ana natane nae, “Ia nana, bea mata-idu ni, ia? Ma bea nade ni ia?” Ara rataa rae, “Ria nana maneꞌ bau-ina Keser a.” ");
INSERT INTO rgu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Boe ma Yesus nae, “Kalu leoꞌ na, sona fee mana pareta hata fo mana pareta hak na. Ma fee Manetualain hata fo Manetualain hak na.” ");
INSERT INTO rgu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ramanene leoꞌ na, boe ma roi ramakokoaꞌ a, huu fo ara ta bisa rahihiiꞌ Ana nai lahenda dodouꞌ matan fa. Boe ma ara ena bafa nara leo. ");
INSERT INTO rgu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Basa ria, boe ma lahenda hida reme partei agama Saduki a mai, fo nau rahihiiꞌ Yesus. Lahenda Saduki ra ranori rae, lahenda mana mateꞌ a ta nasoda seluꞌ nai dae-bafoꞌ a nonoe na. Ara mai ratatane aoꞌ ro Yesus rae, ");
INSERT INTO rgu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Papa Mesen! Baꞌi Musa duiꞌ ela ita atoran nae: maneniko mate touꞌ a tehuu anaꞌ taꞌa, sona touꞌ ria fadi na muste sao na ina-falu ria, ela boki fee aꞌa mana mate na tititi-nonosiꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tebe fai a ulu na baꞌi Musa nanori nae leoꞌ na. Tehuu besaꞌ ia ami nau matane leoꞌ ia: touꞌ hitu toranooꞌ ara. Uluꞌ a sao, tehuu mate ni te anaꞌ taꞌa. ");
INSERT INTO rgu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Basa boe ma fadi mana tukaꞌ ria a, sao na ina-falu ria. Ta doo bea boeꞌ, te mate ni, tehuu anaꞌ taꞌa. ");
INSERT INTO rgu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Leoꞌ na boe neuꞌ ana katelu a. Ana sao na ina-falu ria, tehuu ria mate ni ma anaꞌ taꞌa boe. Leo-leo na losa fadi mateꞌa tei-susuꞌ a boe maten. ");
INSERT INTO rgu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Basa de ina-falu ria boe mate ni. ");
INSERT INTO rgu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Besaꞌ ia ami nau matane leo iaꞌ: inaꞌ ria parna sao touꞌ hitu. De neuꞌ ko dae-bafoꞌ a nonoe na, basa te Manetualain fee lahenda mana mateꞌ ara rasoda seluꞌ, sona inaꞌ ria dadi neuꞌ bea sao ina na?” ");
INSERT INTO rgu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Boe ma Yesus nataa nae, “Lahenda sao noi nai dae-bafoꞌ ia. ");
INSERT INTO rgu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Tehuu neuꞌ ko nai nusatetu-ikutemaꞌ a lahenda ta sao soꞌ. Ma nai na ara ta mate soꞌ. Sira sama leoꞌ Manetualain eilaꞌo-limalopen nai nusatetu-ikutemaꞌ a. Huu no tepoꞌ fo Manetualain fee mana mateꞌ ara rasoda seluꞌ, Ana teka-here naa si fo dadi reuꞌ Ria ana nara. ");
INSERT INTO rgu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nai baꞌi Musa dudui na hapu tutui ai huu anaꞌ, aipilaꞌ a naa ni tehuu ta putu ni fa. Neme tutuiꞌ ria mai ita bubuluꞌ tae, lahenda mana mateꞌ a bisa nasoda seluꞌ. Nai na Manetualain nafada baꞌi Musa nae, ‘Au ia, nana o baꞌi mara Manetualain na. Riꞌ baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Sira basa doꞌo-tabe raroo neuꞌ Au losaꞌ besaꞌ ia.’ ");
INSERT INTO rgu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sekonaa te baꞌi sira mate si reme fai a ulu na mai so. Tehuu no Manetualain nafada nae Ana bei dadi neuꞌ sira Ramatua na, huu ria na de ita bubuluꞌ tae, ara rasoda. Huu fo noi lahenda masodaꞌ a riꞌ doꞌo-tabe neuꞌ Manetualain, ta lahenda mana mateꞌ a fa, hete?!” ");
INSERT INTO rgu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ramanene Yesus nataa nae leoꞌ na, boe ma mesen agama a dedea nae, “Papa Mesen nataan ria, laꞌe matetuꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mulai neme fai ria mai, ta hapu lahenda esa naparani natane Yesus soꞌ, huu fo ara ta bisa rahihiiꞌ rala Ni fa. ");
INSERT INTO rgu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Basa ria, boe ma Yesus bei nanori-nafada lahenda kadodou inaꞌ sira nai Uma Mamaso Ina a. Boe ma Ana natane natafaliꞌ asa nae, “Tuka emi aafi mara, sona leo beaꞌ? Mesen agama ra ranori rae, Kristus nana riꞌ Lahenda fo Manetualain tudu memaꞌ ana neme fai a ulu na mai so. Tuka sira, sona Ria noi dadi neuꞌ mane Daud a tititi-nonosin. Tehuu ria bei ta dai fa. ");
INSERT INTO rgu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Huu fo fai a ulu na mane Daud a riꞌ duiꞌ aon nai susura Sosoda Iꞌio-oꞌoa ara daleꞌ nae, ‘Manetualain nafada au Ramatua ka so nae, “Mai fo matuuꞌ maiꞌ mamana hada-horomata ia nai Au boboa ona ka. ");
INSERT INTO rgu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Huu fo neuꞌ ko Au tao a O musunoo mara, losaꞌ ara raloe-radae ao nara neuꞌ O.’ ” ");
INSERT INTO rgu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Neme duduiꞌ ria mai, ita bubuluꞌ tae, mane Daud a riꞌ naloo neuꞌ Kristus sona nae, ‘Ramatuaꞌ’. Sosoa na nae, maneniko lahenda nae Kristus nana noi mane Daud a tititi-nonosin, sona ria bei ta dai fa! Huu fo Ria boe dadi neuꞌ mane Daud a Ramatua na!” ");
INSERT INTO rgu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Faiꞌ fo basa lahenda ra pasaꞌ ridoo nara ela ramanene neuꞌ Yesus, boe ma Ana dedea no ana mana tuka dea nara nae, ");
INSERT INTO rgu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Emi muste besa-besa mo mesen agama ra. Huu fo ara rahiiꞌ noi lalaꞌo daeꞌ a, pake badu manaruu seseka rarooꞌ a, reu raneta ro lahenda dodouꞌ, fo ela lahenda rita si rae, ‘Ae! Sira nana, lahenda bauinaꞌ, o!’ Ara rahiiꞌ saka mamana hada-horomata a nai uma mamasoꞌ ara, nai feta-dote, ma nai mamanaꞌ fo lahenda dodouꞌ rabua a. ");
INSERT INTO rgu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tehuu besa-besa, huu no ara rapuputaꞌ ina-falu ra fo roso ra uma nara. Tehuu nai lahenda dodouꞌ a matan, sona ara tatana etu sala nara ma rapadeiꞌ hule-haradoi doo na seli. Ara nau fo lahenda rae, sira nana, lahenda neulauꞌ ara. Tehuu Manetualain bubuluꞌ sira sala nara, de neuꞌ ko Ana fee si huhuku maberaina a.” ");
INSERT INTO rgu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Faiꞌ fo Yesus nanori-nafada nai Uma Mamaso Ina a, Ana nita lahenda kamasuꞌi ara mai tuꞌu doi kolete leo peti doiꞌ daleꞌ neu. ");
INSERT INTO rgu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ana nita ina-falu hata taꞌ esa, tuka mai hule-haradoi boe. Ana tuꞌu doiꞌ sen dua leo peti ria daleꞌ neu. Doiꞌ sira beli nara baianaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Basa boe ma Yesus dedea no ana mana tuka dea nara nae, “Nenene matalolole! Ina-falu hata taꞌ ia tuꞌu noi doiꞌ sen duaꞌ a, tehuu ana fee desi lena heni basa lahenda ra. ");
INSERT INTO rgu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Lahenda fekeꞌ ara tuꞌu kolete neme sira doi lena nara mai. Tehuu ina-falu ia, ana fee nabasa doi nara katemaꞌ. Sekonaa te, ana nasoda neniꞌ doiꞌ sira.” ");
INSERT INTO rgu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tepoꞌ ria, Yesus ana mana tuka dea nara dedea io Uma Mamaso Ina a rae, “Papa! Mete masudi Uma ia dei malole na seli! Ara tao ni pake batu mana sapiꞌ kabaꞌuina ra, basa de ratutuleꞌ raa si tama rede-rede. Ma hapu lahenda fee hata mabeli de parong neuꞌ Manetualain Uman ia!” Tehuu Yesus nataa nae, ");
INSERT INTO rgu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tebe uma ia malole a. Tehuu ta dooꞌ a soꞌ, te lahenda rarerefaꞌ heni batu ia ra katemaꞌ, losaꞌ natetu no dae a.” ");
INSERT INTO rgu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Basa boe ma Yesus ana mana tuka dea nara ratane rae, “Papa Mesen! Hata fo bisinaꞌ a Papa mafada a, neuꞌ ko fai hidaꞌ, dadi? Maneniko ledo-fai na naneneaꞌ, sona tanda nara leo beaꞌ?” ");
INSERT INTO rgu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Boe ma Yesus nataa nae, “Sadi emi manea matalolole fo bosoꞌ hapu eedi-fufuleꞌ a. Huu fo neuꞌ ko lahenda rupaꞌ ara mai fo fapa ara nara rae, ‘Au ia, nana Kristus.’ Ruma bali rae, ‘dae-bafoꞌ a nonoe na naneneaꞌ mamaiꞌ a so!’ Tehuu bosoꞌ mamahere! ");
INSERT INTO rgu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maneniko emi mamanene rae, lahenda ra ratati-rapau ao ma musu a nai basa mamanaꞌ ara boe, sona bosoꞌ bii-mamatau. Tebe basa sira muste dadi raꞌuluꞌ. Tehuu dae-bafoꞌ a nonoe na bei ta losa fa. ");
INSERT INTO rgu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Neuꞌ ko leo esa natati soaꞌ leo fekeꞌ. Nusaꞌ esa natati soaꞌ nusa fekeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Neuꞌ ko daeinaꞌ a natakeko naan seli. Laa-roe ma hedi-raus nai basa mamanaꞌ ara. Neuꞌ ko lahenda rita hihii-nanauꞌ fo riꞌ tao na ao bulu nara rapadei ma tanda kahereꞌ ara rai lalai. ");
INSERT INTO rgu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Basa hihii-nanauꞌ ia ra bei ta dadi fa, tehuu neuꞌ ko lahenda homu ra emi ma ese-rumu emi, nana huu mamahere neuꞌ Au. Ma hela roo emi meu mataa nai malaka uma mamasoꞌ fo urus emi ma ena emi nai bui daleꞌ. Basa nana, ara roo emi meu mataa nai maneꞌ ara ma gubenor asa, nana huu emi tuka Au. ");
INSERT INTO rgu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tehuu emi muste pake lelaꞌ ria fo mafada si Au Tutui Malole ka. ");
INSERT INTO rgu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","De bosoꞌ duꞌa-afi maꞌuluꞌ mae, emi masalaꞌe tao ao-ina mara leoꞌ bea. ");
INSERT INTO rgu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Huu fo neuꞌ ko Au fee emi dedea-nafada rolu-malelaꞌ. No ria na, emi musunoo mara ta sefi emi dedea-nafadam fa. ");
INSERT INTO rgu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Neuꞌ ko lahenda dodouꞌ eteꞌao nara ro emi, huu no emi tuka Au. Ruma reme emi kileoboboki mara mai, leo-leoꞌ ina-ama, aꞌa-fadiꞌ, toranooꞌ ara, ma tia-lai ra. Neuꞌ ko neme sira mai ruma saka enoꞌ fo seꞌo heni emi, losaꞌ ara raisa emi ruma. ");
INSERT INTO rgu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tehuu emi bosoꞌ biiꞌ, huu fo Manetualain ta nafarene heni emi fa. Laka dooꞌ esa boe ta ono henin neme emi laka mara mai, kalu Ria ta hihi-nanaun fa. ");
INSERT INTO rgu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Maneniko emi matetea-mamepe dale, tantu Manetualain fee emi sodaꞌ a.” ");
INSERT INTO rgu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus dedea tamba nae, “Maneniko emi mita musu a eo na kota Yerusalem, emi bubuluꞌ mae, ana sakaꞌ nalulutuꞌ ria so. ");
INSERT INTO rgu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lahenda Yudea ra mita leoꞌ na, sona malai leo leteꞌ a meu. Lahenda fo rai kota daleꞌ boe malai leo. Ma lahenda fo rai koroꞌ a bosoꞌ masoꞌ leo kota daleꞌ meu bali. ");
INSERT INTO rgu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Huu fo Manetualain fee fai susa-lela sira mai ela huku lahenda fo, ta nau ramanene neuꞌ Ana. Basa sira dadi laꞌe fai hata fo Manetualain mana nesi mata nara duiꞌ memaꞌ ana neme uluꞌ mai so a. ");
INSERT INTO rgu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tepoꞌ ria te, lahenda fo kasian naan seli a, nana riꞌ ina kairus ara, ma anutu muriꞌ ara. Tepoꞌ ria te katemaꞌ dae-bafoꞌ a hapu susa, ma lahenda Yahudi ra basa si doidoso raan seli, nana huu Manetualain namanasa no si. ");
INSERT INTO rgu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Neuꞌ ko musu a naisa ruma, ma heke roo ruma, fo dadi ata leo basa mamanaꞌ nai dae-bafoꞌ ia. Boe ma lahenda mana mai fo ta nalelaꞌ Manetualain, mai momolo-tatabu rakekeo kota Yerusalem a, ma ara pareta kota a oe-isi na, losaꞌ sira ledo-fain ria, basa ni.” ");
INSERT INTO rgu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Boe ma Yesus nafada laꞌeneuꞌ natafali mai Na nae, “Maneniko Ana Lahenda a sakaꞌ natafali mai, hapu tanda kalua nai ledo a, bulaꞌ a, ma nai ruuꞌ ara. Nai dae-bafoꞌ a boe hapu tanda, riꞌ tasiꞌ a nahoo ma nafa-ani lua dodopo. Basa ia ra tao ra lahenda bii ma roi ramakokoaꞌ a losaꞌ ara ta bubuluꞌ rae tao ubeaꞌ soꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Basa kuasa rai lalai ratakeko taohiro-taohari. Lahenda ra rita leoꞌ na, boe ma ara bii mamateꞌ, huu fo dae-bafoꞌ a sakaꞌ soe! ");
INSERT INTO rgu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Basa ria, besaꞌ ko lahenda rita Au, ‘Ana Lahenda, onda mai o oaꞌ a’. Au onda o basa kuasa ma marela-masaꞌak. ");
INSERT INTO rgu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Maneniko basa tanda ia ra sakaꞌ dadi, sona emi botiꞌ laka mara leo, huu fo losa Manetualain ledo-fain fo nau poꞌi-tata na emi.” ");
INSERT INTO rgu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Basa ria boe ma Yesus tui nasasamaꞌ esa nae, “Emi bebesa matalolole ai huuꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Maneniko doo nara mulai mofa, ria dadi tanda nae, fai fanduꞌ a mamai na naneneaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Leoꞌ na boe fai susa sira. Maneniko ara toda mai, ria dadi tanda nae, Manetualain pareta na mamai na naneneaꞌ so. ");
INSERT INTO rgu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Au afada memaꞌ! Neme basa lahenda fo rasoda nai besaꞌ ia, neuꞌ ko ruma bei ta mate fa, te fai susa sira toda mai so. ");
INSERT INTO rgu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Leo mae lalai no dae-bafoꞌ a sapu-lolo, tehuu Au Hara-dasik ta mei-mesa.” ");
INSERT INTO rgu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Basa boe ma Yesus dedea naroo nae, “Manea, huu fo kekeneu te Au toda mai so! Bosoꞌ losa emi ta afi no matetuꞌ soꞌ, basa boe ma masoda nai nininu mafuꞌ a daleꞌ, ma masaliu saka noi lole-napu dae-bafoꞌ a. Boso losa emi ta mala tanda na, huu no masapute malisu fekeꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maneniko Au atafali mai, ta hapu lahenda esa bisa nafuni nala ao na neme Au mata ka mai boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","De, manea maroo. Hule-haradoi bosoꞌ namaetun, ela emi bisa manenete nai basa susa sira talada. No ria na, maneniko Au atafali mai, sona emi ta maeꞌ mapadei nai Ana Lahenda mata na.” ");
INSERT INTO rgu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tuka-tuka faiꞌ Yesus neu nanori-nafada nai Uma Mamaso Ina a. Tehuu maneniko hatuꞌ, sona Ana kalua neme Yerusalem mai, fo neu suku nai koroꞌ manai lete Saitun a. ");
INSERT INTO rgu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bei balahaa anaꞌ, te lahenda dodouꞌ mai rabua so, fo nau ramanene Ni nanori-nafada nai Uma Mamaso Ina a. ");
INSERT INTO rgu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lahenda Yahudi ra fai malole fo riꞌ rae feta Roti Tua-lepa naneaꞌ so. Nai fai malole ria, ara pau bibi-lopo fo tao feta Paska. Ara tao leo naꞌ ela rafarene fai a ulu na, tepoꞌ fo bei-baꞌi nara kalua reme Masir mai a. ");
INSERT INTO rgu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Faiꞌ ria, malaka agama Yahudi a malaka nara, ma mesen agama ra rasaka enoꞌ fo nau raisa Yesus. Tehuu ara biiꞌ lahenda kadodou inaꞌ sira tao isuoteꞌ, huu fo ara rahiiꞌ ramanene neuꞌ Ana. ");
INSERT INTO rgu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Neme Yesus ana mana tuka dea kasanahulu dua nara, esa nade Yudas Iskariot. Fai fo malaka agama Yahudi a malaka nara saka enoꞌ ela raisa Yesus, malaka nitu maso neuꞌ Yudas dale na. ");
INSERT INTO rgu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Basa de ana kalua neu saka malaka agama a malaka nara, ma manea Uma Mamaso Ina a malaka na. Ana nau rala haraꞌ fo seꞌo Yesus fee si. ");
INSERT INTO rgu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Malaka sira ramanene Yudas dedea nae leoꞌ na, boe ma ara ramahoꞌo mamateꞌ. Ara helu rae, “Neu! Maneniko o nau seꞌo Yesus fee ami, tantu ami bae.” ");
INSERT INTO rgu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas nataa. Boe ma ana mulai saka enoꞌ fo seꞌo nafufuniꞌ Yesus fee si, ela lahenda kadodou inaꞌ ara bosoꞌ bubuluꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Boe ma losa lahenda Yahudi ra fai malolen fo riꞌ biasa ara pau bibi-lopo fo tao feta Paska. ");
INSERT INTO rgu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Boe ma, Yesus nadenu Petrus no Yohanis nae, “Emi dua meu mauluꞌ fo sadia fee ita nanaaꞌ feta Paska a, ela taa sama-sama.” ");
INSERT INTO rgu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dua si ratane Ni rae, “Papa! Ami meuꞌ bea sadia mei a?” ");
INSERT INTO rgu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ana nataa nae, “Maneniko emi masoꞌ leo kota Yerusalem a daleꞌ meu, neuꞌ ko maneta mo touꞌ esa nasaa neni kusi oe. Tuka ni leo uma meu. ");
INSERT INTO rgu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mafada manuu umaꞌ na mae, ‘Ami Papa Mesen ma hule kama fo ela ana mana tuka dea nara raa feta Paska reuꞌ na. Hapu, do?’ ");
INSERT INTO rgu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Neuꞌ ko manuu umaꞌ a natudu fee emi kama maloa esa nai uma a tadaꞌ lain. Ana sadia na basa-basan nai kama ria so. Emi dua meuꞌ na, fo sadia noi nanaaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Boe ma dua si reu. Ara raneta ro basa-basan fo Yesus nafada siꞌ a. De ara sadia feta Paska reuꞌ na. ");
INSERT INTO rgu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Faiꞌ fo basan mana sadiaꞌ, boe ma Yesus asa mai. Ana natuuꞌ naa feta Paska sama-sama no ana mana tuka dea nara. ");
INSERT INTO rgu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Boe ma Yesus nafada si nae, ‘Au ahiiꞌ an seli atuu oo emi ua feta Paska ia, nauluꞌ neme Au hapu doidoso a. ");
INSERT INTO rgu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tanda matalolole ia. Huu fo basa ia, te Au ta atuuꞌ seluꞌ oo emi, ua feta Paska ia soꞌ. Neuꞌ ko lahenda bubuluꞌ matetuꞌ Au Papa Ka homu pareta a, besaꞌ ko Au ua seluꞌ feta bali.” ");
INSERT INTO rgu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Boe ma Yesus hai na galas fo oe anggor nai daleꞌ. Ana hule makasi neuꞌ Manetualain, boe ma Ana loo fee si galas ria. Ana dedea nae, “Sipo ma galas ia, fo emi esa-esa minuu. ");
INSERT INTO rgu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mafarereneꞌ! Mulai neme hatun ia mai, Au ta inuu oe anggor soꞌ. Neuꞌ ko lahenda bubuluꞌ matetuꞌ Au Papa Ka homu pareta, besaꞌ ko Au inu bali.” ");
INSERT INTO rgu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Basa de Ana hai na roti baloꞌ esa, boe ma Ana hule makasi neuꞌ Manetualain. Ana tetebi roti ria, boe ma loo fee si. Ana nae, “Roti ia nana, Au ao-paa ka fo Au fee henin neuꞌ emi basa. Fai bea ma emi mia roti ia, emi muste mafarene neuꞌ Au.” ");
INSERT INTO rgu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ara raa basa, boe ma Ana soꞌu na galas fo oe anggor nai daleꞌ. Ana dedea bali nae, “Anggor ia nana, Au daa ka, fo faa neni fee emi sodaꞌ a. Manetualain pake daa ia ela heke hehelu bebeuꞌ no emi. ");
INSERT INTO rgu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tehuu besa-besa, te lahenda fo seꞌo heni Au a, ana natuuꞌ sama-sama no Au nai mei ia. ");
INSERT INTO rgu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tebe Au, Ana Lahenda, muste mate tuka Manetualain hihi-nanaun. Tehuu soe neuꞌ lahenda fo seꞌo heni Au a!” ");
INSERT INTO rgu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesus ana mana tuka dea nara ramanene ra ria, boe ma ara mulai ratatane aoꞌ rae, “Bea riꞌ tao tadalu neuꞌ Ana leo naꞌ?” ");
INSERT INTO rgu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Boe ma Yesus ana mana tuka dea nara mulai ralelena aoꞌ rae, neme sira mai bea rina bau lena. ");
INSERT INTO rgu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tehuu Yesus nafada si nae, “Nai nusaꞌ fo ta ralelaꞌ neuꞌ Manetualain, maneꞌ nara ese-rumu anaraun ara, ma pareta rala lenaꞌ. Sekonaa te ara nau anaraun nara raloo si rae, ‘Papa manatulu-manafali anaraun a’. ");
INSERT INTO rgu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tehuu emi ta bole leo naꞌ fa. Bea nau dadi lahenda bauinaꞌ, sona ria masoda na muste tetebes ara dadi sama leoꞌ lahenda aanaꞌ a fo nalalau basa lahenda ra. Bea nau dadi malaka muste nalalau sama leoꞌ lahenda nadedenuꞌ a. ");
INSERT INTO rgu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Soba emi dodoo, lahenda bauinaꞌ a, nana riꞌ bea? Lahenda fo natuuꞌ nai mei a, do nalalauꞌ a? Tantu lahenda fo natuuꞌ a, nana ria riꞌ lahenda bauinaꞌ, hete? Sekonaa te, Au ta tao ao ka leoꞌ na fa. Au mai fo alalau emi. ");
INSERT INTO rgu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Emi ia nana sama-sama mo Au kose-kose nai faiꞌ fo Au hapu doidoso a. ");
INSERT INTO rgu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Au Papa ka soꞌu na Au fo homu pareta nai Ria nusa-namon. De besaꞌ ia Au soꞌu a emi boe, ");
INSERT INTO rgu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","fo ela neuꞌ ko emi mia-minuu mo Au mei esa nai nusatetu-ikutemaꞌ a. Au fee kuasa boe ela emi pareta leo kasanahulu duaꞌ fo rai Israel.” ");
INSERT INTO rgu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Boe ma Yesus nafada Petrus nae, “Petrus, Petrus. Malaka nitu soba nau heoꞌ heni emi meme Au mai, sama leoꞌ lahenda dai isiꞌ de here heni kataaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tehuu Au hule-haradoi fee, Petrus o, ela mamahere maroo Au. Maneniko o matafali leo Au mai, sona o muste matetea toranoo mara dale nara.” ");
INSERT INTO rgu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus nataa nae, “Taꞌa, Ramatuaꞌ! Au ta foa ela Ramatua ka fa. Au sadia masoꞌ bui a, ma oo Ramatua ka mate belaꞌ boe malole.” ");
INSERT INTO rgu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tehuu Yesus nataa nae, “Petrus! Nenene matalolole. Hatun ia, manuꞌ ara bei ta kokoꞌoa fa, tehuu o malena laiꞌ telu so mae, o ta malelaꞌ Au fa.” ");
INSERT INTO rgu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Boe ma Yesus dedea no si nae, “Fai naa ra, Au adenu emi meu tui-beka Au Tutui Malole ka leo basa mamanaꞌ ara, Au ae bosoꞌ meni doiꞌ, tas, ma sandaal. Tepoꞌ ria, emi kura-kopo ubeaꞌ?” Boe ma ara rataa belaꞌ a rae, “Faiꞌ naa ra, ami ta kura-kopo hata esa boeꞌ!” ");
INSERT INTO rgu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Boe ma Ana nafada si nae, “Tehuu besaꞌ ia fekeꞌ so. Kalu emi manuu doiꞌ, sona meni. Bea manuu tas sona meni boe. Maneniko tafaꞌ taꞌa, sona meu seꞌo heni emi badu mi bei esaꞌ, fo asa. ");
INSERT INTO rgu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Huu fo lahenda Yahudi ra tao Au neuꞌ lahenda tadaluꞌ. Selu baianaꞌ ia te ara mai hopu Au so. Nana huu ria laꞌe fai hata fo baꞌi Yesaya duiꞌ memaꞌ ana, nae: ‘Ara tao Ni sama leoꞌ lahenda tadaluꞌ!’ ” ");
INSERT INTO rgu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ara rafada rae, “Ramatuaꞌ! Ami meni felas dua rai ia!” Yesus nataa nae, “Dai so. Bosoꞌ boe dedea ria bali!” ");
INSERT INTO rgu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Raa basa Paska, boe ma Yesus no ana mana tuka dea nara kalua, reu hule-haradoi nai lete Saitun a, sama leoꞌ bale-bale. ");
INSERT INTO rgu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Losa na, boe ma Ana nafada si nae, “Emi muste hule-haradoi fo ela emi bosoꞌ hapu sosobaꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Basa de Ana oruꞌ ela si dooꞌ a baiꞌ, boe ma sundaꞌ undulaka na, fo hule-haradoi nae, ");
INSERT INTO rgu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O, Amaꞌ! Kalu Amaꞌ a nau, sona hai heni doidoso ia neme Au mai. Tehuu bosoꞌ tuka Au hihii-nanau ka; ela leoꞌ bea na tuka noi Amaꞌ a hihii-nanaum.” ");
INSERT INTO rgu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Boe ma Manetualain eilaꞌo-limalopen neme nusatetu-ikutemaꞌ a mai, de natetea dale Na. ");
INSERT INTO rgu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Huu fo Ana doidoso naan seli, losaꞌ puse Na titi deaꞌ mai sama leoꞌ daa a. ");
INSERT INTO rgu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hule-haradoi basa, boe ma Ana foa neu dama ana mana tuka dea nara. Tehuu ara suku, huu fo ara sotaꞌ raan seli, ma dale nara susa. ");
INSERT INTO rgu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Boe ma Yesus nafada si nae, “Ubeaꞌ taon de emi suku?! Malole lenaꞌ emi hule-haradoi fo ela bosoꞌ tuda mala sosobaꞌ daleꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus bei dea-dea nae leoꞌ na, te Yudas (esa neme ana mana tuka dea kasanahulu duaꞌ ara mai), no lahenda dodouꞌ mai. Ana naneneaꞌ Yesus de nau holu nan fo deꞌi. ");
INSERT INTO rgu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tehuu Yesus nafada ni nae, “Ae, Yudas! O nau seꞌo heni Ana Lahenda neniꞌ dedeꞌi, do?” ");
INSERT INTO rgu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesus ana mana tuka dea feke nara bubuluꞌ Yudas duduꞌa-aafi tadalun ria, boe ma ara ratane Yesus rae, “Ramatuaꞌ! Ami soaꞌ asa meni felas dei!” ");
INSERT INTO rgu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Boe ma sira esa lesu na fela na, de tati naetu malaka agama Yahudi a malaka bauinan atan ridoo onan. ");
INSERT INTO rgu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tehuu Yesus nafada nae, “Nemeꞌ na leo! Bosoꞌ soaꞌ asa!” Boe ma Ana nafaroe lahenda ria ridoo na, de puli nan. ");
INSERT INTO rgu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lahenda fo mai hopu Yesus nana siꞌ: malaka agama Yahudi a malaka nara, lasi nara, ma Uma Mamaso Ina a manea nara. Yesus natane si nae, “Leo beaꞌ? Emi dale mara mae Au, lahenda tadaluꞌ, losaꞌ emi mai hopu Au pake tafaꞌ, ma ai tutukuꞌ? ");
INSERT INTO rgu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tuka-tuka faiꞌ Au anori-afada emi nai Uma Mamaso Ina a, tehuu ta hapu lahenda esa mai fo hopu na Au boeꞌ. Tehuu nemeꞌ na! Ia, nana emi ledo-faim. Besaꞌ ia malaka nitu kuasan ia!” ");
INSERT INTO rgu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ara hopu ra Yesus, de hela roo Ni leo malaka agama Yahudi a malaka bau-ina na uma na neu. Petrus boe tuka nafufuniꞌ nesiꞌ deaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nai uma ria mata na hapu lahenda raseraꞌ ai. Petrus neuꞌ na namaneru ai boe. ");
INSERT INTO rgu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hapu ata inaꞌ esa nita Petrus natuuꞌ naneneaꞌ ai ria. Ana bebesa natalolole Petrus mata-idun, boe ma nafada lahenda fekeꞌ fo rai na nae, “Ae! Lahenda ia boe ana tutukaꞌ Yesus!” ");
INSERT INTO rgu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tehuu Petrus nalena nae, “Taꞌa! Au ta alelaꞌ Lahenda ria fa. O bubuluꞌ ubea?” ");
INSERT INTO rgu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta doo bea boeꞌ, te lahenda esa mete leo Petrus neu, boe ma dedea nae, “Tebe, o nana Yesus lahenda nara esa ian, hete?” Tehuu Petrus nadedealaka nae, “Taꞌa! O mafararaꞌuꞌ!” ");
INSERT INTO rgu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bate basa jam esa, boe ma lahenda fekeꞌ esa dedea bali nae, “Ae! Au bubuluꞌ, lahenda ia nana, Yesus ana mana tuka dean esa ian, huu fo ria lahenda Galilea boe.” ");
INSERT INTO rgu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tehuu Petrus nalena mamateꞌ nae, “O maa ma ria!” Laꞌe fai Petrus dedea nae leoꞌ na, boe ma manuꞌ ara kokoꞌoa. ");
INSERT INTO rgu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Boe ma Yesus lipe ao na fo mete ni. Basa de Petrus nafarene Yesus nafada ni nae, “Hatun ia, manuꞌ ara bei ta kokoꞌoa boeꞌ, tehuu o malena Au laiꞌ telu so.” ");
INSERT INTO rgu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petrus nafarene na ria, boe ma ana kalua neme uma a mata na mai ma dola nasaeꞌedu. ");
INSERT INTO rgu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Basa ria, boe ma lahenda fo ranea Yesus a, ara mulai ramamaeꞌ Ana ma fepa-leꞌu Ni. ");
INSERT INTO rgu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ara poti etu mata Na pake temaꞌ, ma ratanen rae, “Ae! Kalu O nana Manetualain mana nesi matan, sona maneuꞌ masudin! Bea rina popoꞌo O ia?” ");
INSERT INTO rgu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ara ramumulu-ramamaeꞌ rahedi Ni. ");
INSERT INTO rgu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Balahaa anan ria, malaka agama Yahudi a malaka nara, mesen agama, ma lasi nara tesa fo parisaꞌ Yesus dedea na. Boe ma ara radenu fo lahenda ra, hela roo Yesus leo mamana parisa dedea agama a neu. ");
INSERT INTO rgu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ana masoꞌ leo daleꞌ neu, boe ma ara ratane Ni rae, “Soba O mafada dei! O ia nana tetebe sara Kristus, do?” Tehuu Yesus nataa nae, “Leo mae Au ataa ae tebe boe, emi ta mamahere fa. ");
INSERT INTO rgu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Boe ma maneniko Au atane emi hihii-nanauꞌ esa, tantu emi ta mataa fa. ");
INSERT INTO rgu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ta dooꞌ a soꞌ, te Manetualain nau pake Ria kuasa kahere na, fo soꞌu na aeꞌ Au, Ana Lahendaꞌ ia. Basa te Au atuuꞌ nai Ria boboa ona na fo oo Ni pareta sama-sama.” ");
INSERT INTO rgu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ramanene leoꞌ na, boe ma basa si ratane rae, “Kalu leoꞌ na, sona O nana Manetualain Anan, do?” Boe ma Yesus nataa nae, “Memaꞌ, tebe leoꞌ emi dedeam ria.” ");
INSERT INTO rgu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Boe ma lahenda mana parisa dedeaꞌ sira rahara belaꞌ a rae, “Ita basa tamanene mataꞌ, hete? Ana soꞌu aon nae Ria nana Manetualain Anan. Namumulu-namamaeꞌ ia! Tuka ita atoran agama na, kalu hapu lahenda tao aon sama leoꞌ Manetualain, lahenda ria muste mate. De, leoꞌ bea? Ita ta parluu mana sakasii soꞌ. Huku mateꞌ Ana leo.” ");
INSERT INTO rgu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tehuu, mana parisa dedea agama Yahudi sira, ta ranuu hak fo huku ramate lahenda fa. Huu ria na ara roo Yesus leo gubernor neme mana pareta Roma fo nai na, riꞌ Pilatus. Ara nau gubernor a huku na mate Ni. ");
INSERT INTO rgu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","De, losa gubernor a mata na, boe ma ara rafada Yesus sala nara rae, “Lahenda ia, nalena lakaꞌ neu mana pareta Roma. Ana horo lahenda bosoꞌ bae bea fee mana pareta. Ma io aon nae ria nana Kristus, maneꞌ lahenda Yahudi.” ");
INSERT INTO rgu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gubernor a namanene leoꞌ na, boe ma ana natane Ni nae, “Tebe, do? O nana maneꞌ lahenda Yahudi, do?” Yesus nataa nae, “Tebe. Leo papa hara ma.” ");
INSERT INTO rgu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Parisaꞌ basa, boe ma gubernor a nasare na malaka agama a malaka nara no lahenda kadodou inaꞌ sira. Ana nae, “Leo iaꞌ. Au ta hapu Lahenda ia sala na baiꞌ boeꞌ.” ");
INSERT INTO rgu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tehuu ara rahere rae, “Taꞌa, papa gubernor. Lahenda ia neu nanori-nafada nai basa mamanaꞌ ara, dudukuꞌ raun ara fo ralenalaka. Ana tao taohiru-taohariꞌ mulai neme propinsi Galilea losa leo kota Yerusalem iaꞌ mai.” ");
INSERT INTO rgu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Gubernor a namanene leoꞌ na, boe ma ana natane si nae, “Kalu leoꞌ na, sona ria nana lahenda Galilea, do?” Boe ma ara rataa rae, “Tebe, papa. Ria lahenda Galilea!” ");
INSERT INTO rgu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gubernor a bubuluꞌ leoꞌ na, boe ma ana fee Yesus neu nataa mane Herodes, fo ana pareta propinsi Galilea. Tepoꞌ ria, ana nai kota Yerusalem. ");
INSERT INTO rgu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mane Herodes a namanene lahenda dodouꞌ tui laꞌeneuꞌ Yesus so, ma neme uluꞌ mai ana nahiiꞌ nita na Yesus seli. Ana namahehenaꞌ bisa nita Yesus natudu tanda heran esa do dua. Huu ria na, de ara roo Yesus neu, boe ma dale na namahoꞌo. ");
INSERT INTO rgu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ana natane Yesus hihii-nanauꞌ rupaꞌ ara, tehuu Ana ta nataa hata-hata esa boeꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Herodes bei dea-dea no Yesus, tehuu malaka agama a malaka nara ro mesen agama ra mulai rapaneneoꞌ seluꞌ Yesus sala rupaꞌ ara. ");
INSERT INTO rgu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Basa de mane Herodes a no soldadu nara mulai ramumulu-ramamaeꞌ ma radadae Yesus. Ara ramumulu-ramamaeꞌ raroo Ni, feen pake badu malole esa sama leoꞌ biasa maneꞌ ara pake a. Basa boe ma ara roo faliꞌ Ana leo gubernor Pilatus a neu. ");
INSERT INTO rgu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Maꞌulu na, gubernor ria no mane Herodes a ramananasa aoꞌ. Tehuu mulai faiꞌ ria boe ma dua si ratiaꞌ. ");
INSERT INTO rgu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Boe ma gubernor Pilatus naloo na malaka agama Yahudi a malaka nara ma lasi fekeꞌ ara sama-sama ro lahenda kadodou inaꞌ sira, basa si rabua ela ramanene ria naetu na. ");
INSERT INTO rgu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ana nafada si nae, “Emi moo Yesus leo au mai, ma kolaꞌ mae, Ana dudukuꞌ raun a fo ralenalaka neuꞌ mana pareta Roma. Au parisaꞌ alulutuꞌ Ana nai emi mata mara so, tehuu au ta hapu Ni nasalaꞌ hata esa boe. ");
INSERT INTO rgu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mane Herodes a boe parisaꞌ Ana so, tehuu ta hapu sala na fa. Huu ria na, de ana fee faliꞌ Lahenda ia leo au mai. Lahenda ia sala ni taꞌa, de au ta bisa huku a mate ni fa ");
INSERT INTO rgu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","De, au nau aetuꞌ leo iaꞌ: au adenu fo fepa-liꞌun, basa nana au poꞌi Ni.” ");
INSERT INTO rgu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Ramanene leoꞌ na, boe ma ara mulai rahara belaꞌ a rae, “Ta bisa fa! Maisa Ni. Poꞌi Barabas.” Ara rahara rae leoꞌ na, huu fo tuka-tuka teuꞌ kalu lahenda Yahudi ra tao feta Paska, sona gubernor a biasa poꞌi lahenda mana hukuꞌ esa tuka sira hihii nara. ");
INSERT INTO rgu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas masoꞌ bui a, nana huu ana dadi mana kikifu, nalenalaka fo soaꞌ mana pareta Roma nai kota Yerusalem, ma naisa lahenda boe.) ");
INSERT INTO rgu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tehuu gubernor a nau poꞌi Yesus. De ana natane seluꞌ lahenda kadodou inaꞌ sira nae, “Au poꞌi Yesus na, leoꞌ bea?” ");
INSERT INTO rgu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tehuu basa si rahara belaꞌ a rae, “Taꞌa! Paku maisa Ni neuꞌ ai kakeꞌ a! Paku maisa Ni neuꞌ ai kakeꞌ a!” ");
INSERT INTO rgu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tehuu gubernor a nameda nan ria ta laꞌe fa, de ana natane si kalaiꞌ telu na bali nae, “Sala ubeaꞌ de au paku aisa Ni? Ana tao tadalu ubeaꞌ? Au parisaꞌ Ana so, tehuu ta hapu enoꞌ fo naraa laꞌe, nau huku ta mate Ni.” De, au adenu fo fepa-liꞌu Ni, basa nana au poꞌin.” ");
INSERT INTO rgu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tehuu basa lahenda sira rahara ramberaina bali, raseti fo nau paku raisa Ni neuꞌ ai kakeꞌ a. Mateꞌe oe na, ara raseki gubernor a, ");
INSERT INTO rgu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","boe ma ana naꞌetuꞌ tuka sira hihii nara. ");
INSERT INTO rgu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Basa de ana poꞌi Barabas, madedealakaꞌ ma kanisaꞌ ria. Tehuu ana fee Yesus leo lahenda sira lima dale nara neu, fo ela ara raisa Ni tuka sira hihii nara. ");
INSERT INTO rgu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Basa boe ma, ara hela roo Yesus kalua neme kota Yerusalem mai. Nai eno taladaꞌ ara raneta ro lahenda esa nade Simon, neme kota Kirene mai. Ana besaꞌ ko neme kota a deaꞌ mai. Ara raseti ran fo nasaa ai kakeꞌ a kati Yesus, ma ana laꞌo tuka Yesus dea na. ");
INSERT INTO rgu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Faiꞌ ria, lahenda dodouꞌ tuka ro Yesus. Inaꞌ ara dola Ni. ");
INSERT INTO rgu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus namanene si dola, boe ma Ana nasare naa si, ma dedea nae, “Ae! Mama Yerusalem kara emin. Bosoꞌ dola huu Au. Malole lenaꞌ dola huu ao-ina mara, ma emi ana mara. ");
INSERT INTO rgu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Huu fo balahaa-binesaꞌ susa bauinaꞌ a mai, neuꞌ ko lahenda rafada rae, ‘Ina maua-manaleꞌ a nana riꞌ inaꞌ fo ta parna boki, ma ta parna nasusuꞌ ana bokibeuꞌ fa.’ ");
INSERT INTO rgu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tepoꞌ fo susa bauinaꞌ a mai, lahenda ra doidoso mamateꞌ, losaꞌ ara hule rae, ‘Malole lenaꞌ, leteꞌ ara refa mai fo ranete ra ami leo!’ Ma ara dedea rae, ‘Noo doidoso leo iaꞌ a, malole lenaꞌ pupukuꞌ ara tatana ra ami leo!’ ");
INSERT INTO rgu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Huu fo lahenda bisa tao susa leo iaꞌ soa neuꞌ lahenda salaꞌ taꞌa, sona lahenda tadaluꞌ a leo beaꞌ bali?” ");
INSERT INTO rgu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Fai ria soldadu ra roo Yesus a, ara hela roo lahenda tadaluꞌ dua boe, fo nau huku ramate si sama-sama roo Ni. ");
INSERT INTO rgu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ara losa mamanaꞌ esa, nade ‘Laka Duiꞌ’. Boe ma ara paku Yesus no lahenda tadalu kaduaꞌ sira, esaꞌko neuꞌ ria ai kake na. Basa boe ma rapadeiꞌ ai kakeꞌ ara. Ara londa lahenda tadaluꞌ esa nai Yesus boboa ona na, ma esa bali nai boboa ii Na. ");
INSERT INTO rgu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Fai ria, Yesus hule-haradoi nae, “Papa! Fee ampon neuꞌ lahenda ia ra sala nara, huu no ara ta bubuluꞌ hata fo sira tao ni fa.” Basa boe ma, soldadu ra hela lot, ela ara bubuluꞌ bea riꞌ hapu Ria papake nara. ");
INSERT INTO rgu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lahenda dodouꞌ rapadei ranilu nai mamanaꞌ ria. Lahenda Yahudi ra malaka nara ramumulu-ramamaeꞌ Yesus rae, “Ana poꞌi-tata na lahenda fekeꞌ, tehuu Ana ta bisa poꞌi-tata na ao-ina heheli Na. Kalu tetebes ara Ria nana Kristus, fo Manetualain here memaꞌ ana so, sona nemeꞌ na ela Ana onda neme ai kakeꞌ ria mai leo.” ");
INSERT INTO rgu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadu sira boe ramumulu Ni. Ara raninuꞌ Ana anggor maꞌeis, ");
INSERT INTO rgu_v