﻿USE sofia;
DROP TABLE IF EXISTS sofia.rei_vpl;
CREATE TABLE rei_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rei_vpl WRITE;
INSERT INTO rei_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","యేసు క్రీస్తు వంసావలి యాకిరి రొయితవ్వి, ఎయ్యె దావీదు రొజా యింకా అబ్రాహాము వంసంలింకు చెందిలాలింకె. ");
INSERT INTO rei_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","అబ్రాహాము పో ఇస్సాకు. ఇస్సాకు పో యాకోబు. యాకోబు పో యూదా ఈనె తా అన్నబయినె. ");
INSERT INTO rei_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","యూదా తామారు వల్లరె పో పెరెసు ఈనె జెరహు. పెరసు పో ఎస్రోము పో ఆరాము ");
INSERT INTO rei_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ఆరాము పో అమ్మీనాదాబు. అమ్మీనాదాబు పో నయస్సోను. నయస్సోను పో సల్మాను ");
INSERT INTO rei_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","సల్మాను పో బోయజు. బోయజు మా రాహాబు. బోయజు పో ఓబేదు. ఓబేదు మా రూతు. ఓబేదు పో యెస్సయి. ");
INSERT INTO rei_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","యెస్సయి పో రొజా యిలా దావీదు. దావీదు పో సొలొమోను. ");
INSERT INTO rei_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","సొలొమోను పో రెహబాము. రెహబాము పో అబీయా. అబీయా పో ఆసా. ");
INSERT INTO rei_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ఆసా పో యెహోసాపాతు. యెహోసాపాతు పో యెహోరాము. యెహోరాము పో ఉజ్జియా. ");
INSERT INTO rei_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ఉజ్జియా పో యోతాము. యోతాము పో ఆహాజు. ఆహాజు పో హిజ్కియా. ");
INSERT INTO rei_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","హిజ్కియా పో మనస్సే తా పో ఆమోను. ఆమోను పో యోసియా. ");
INSERT INTO rei_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","యోసియా పో యెకొన్యా ఈనె తా బయినె. యంకె తల్లాబెల్లె ఇస్రాయేలీయులు బబులోను గాకు బందీలుగా రొయితవ్వె. ");
INSERT INTO rei_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","బబులోను గాకు జెల్లా తరవాతరె వంసం యాకిరి అచ్చి, యెకొన్యా పో సయల్తీయేలు. సయల్తీయేలు పో జెరుబ్బాబెలు. ");
INSERT INTO rei_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","జెరుబ్బాబెలు పో అబీహూదు. అబీహూదు పో ఎల్యాకీము. ఎల్యాకీము పో అజోరు. ");
INSERT INTO rei_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","అజోరు పో సాదోకు. సాదోకు పో ఆకీము. ఆకీము పో ఎలీహూదు. ");
INSERT INTO rei_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ఎలీహూదు పో ఎలియాజరు. ఎలియాజరు పో మత్తాను. మత్తాను పో యాకోబు. ");
INSERT INTO rei_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","యాకోబు పో యోసేపు. యోసేపు నెయిపొ మరియ. మరియ పో యేసు. తాకు క్రీస్తు బులుసె. ");
INSERT INTO rei_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ఈనె అబ్రాహాము దినోనె దీకిరి దావీదు జాంక పద్నాలుగు తరాలు. దావీదు తీకిరి యూదునె బబులోను గాకు బందీలుగా తల్లా దినోనె జాంక పద్నాలుగు తరాలు. బబులోను చెరకు జెల్లా దినోనె దీకిరి క్రీస్తు వరుకు పద్నాలుగు తరాలు. ");
INSERT INTO rei_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","యేసు క్రీస్తు జొర్నైవురొ యాకిరి అచ్చి, యేసు క్రీస్తు మా మరియకు, యోసేపు బుల్లా మనమ సంగరె ప్రదానమైకిరి అచ్చి. బ్యా కు అగరె పురువు ఆత్మసక్తి సంగరె మరియ పెట్టొ సంగరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ఈనె తా గొయిత యోసేపు బొల్టమనమ సడకు సెయ్యె తాకు సార్లింకె బిత్తరె అవమానం కొరిలాని. కాకు నా బుజ్జికుంటా తాకు సడదిమ్మంచి బులిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","సెయ్యె సా బులిగిల్లా తరవాతరె, దేవదూత తాకు సొప్నొరె దిగదీకిరి, దావీదు పో యీలా యోసేపు మరియ పురువు ఆత్మ సంగరె పనిదీగిచ్చి. తాకు తో నెయిపొగా అంగీకరించితె దొరితెనా. ");
INSERT INTO rei_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","మరియ జొనె వొండ్ర పోకు జొర్నొదూసి. సెయ్యె తా మనమానుకు తంకు పాపోనె దీకిరి రక్సించుసి. సడకు తాకు యేసు బులికిరి నా లొగు బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ప్రబువు తా ప్రవక్త సంగరె పలికిలా కొతా నెరవేరిలాపనికిరి యడల్లా జరిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ఈనె కన్యక పనిదీగికిరి వొండ్ర పోకు జొర్నొదూసి. తంకె తాకు ఇమ్మానుయేలు బులి నా సంగరె డక్కుసె. “ఇమ్మానుయేలు బుల్నే పురువు అముకు తోడు బులి అర్దం.” ");
INSERT INTO rei_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","యోసేపు గుమ్మొదీకిరి ఉటికిరి దేవదూత తాకు ఆజ్ఞాపించిలాపని కొరిసి. మరియకు బ్యా కొరిగీకిరి తా గొరొకు కొనిగీకిరి జేసి. ");
INSERT INTO rei_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ఈనె, సెయ్యె పో జొర్నైలా జాంక మరియ దీకిరి మిసిలాని. సెయ్యె సే వొండ్ర పోకు “యేసు” బులి నా లొగిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","రొజా యీలా హేరోదు దినోనె బెల్లె యూదయ దెసొరె బేత్లెహేమురె యేసు జొర్నైలా ఎంట్రాక ఇదిగొ తూర్పు దెసొలింకె యెరూసలేముకు అయికిరి. ");
INSERT INTO rei_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“యూదునెకు రొజగా జొర్నైలాట కేటె? తూర్పురె అమె నక్సిత్రం దిక్కిరి తాకు పూజించితె అయించొ” బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","రొజా యీలా హేరోదు యే కొతా సునిలా బెల్లె సెయ్యె, తాదీకిరి తల్లా యెరూసలేమురొ మనమానల్లా కలవరం పొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ఈనె హేరోదు ప్రదానయాజకూనెకు, మనమానె బిత్తరె తల్లా సాస్త్రీనెకు సొబ్బిలింకు సమకూర్చికిరి, క్రీస్తు కేటె జొర్నైవొ? బులి తంకు పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","తంకె “యూదయ దెసో బుల్లా బేత్లెహేమురె” బులి సమాదానం కొయిసె. ఎడగురించి ప్రవక్త యాకిరి రాసిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","యూదా దెసొరొ బేత్లెహేము! తూ యూదయ పాలకులకన్నా తక్కువ ఈలాటను! కిరుకుబుల్నే, తోబిత్తరెతీకిరి జొనె పాలకుడు అయివాసి. సెయ్యె మో మనమానె యీలా ఇస్రాయేలుకు జొగిలొతాగా తాసి. ");
INSERT INTO rei_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","సే తరవాతరె హేరోదు తెలివిలింకు రహస్యంగా డక్కిపించికిరి సే నక్సత్రం తంకు దిగదిల్లా కలొ తెలిసిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","తంకు బేత్లెహేముకు పొడదీసి. “సే జొర్నైలా పిల్ల గురించి పూర్తిగా తెల్సిగీండి, సే పిల్లాసుకు దిగిలా తరవాతరె మెత్తె అయికిరి కోండి, సెల్లె మియ్యంకా అయికిరి ఆరాదించుంచి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","తంకె రొజా కొతానె సునికిరి తంకె బట్టరె తంకె బాజీసె. తంకె తూర్పు దిక్కురె దిగిలా నక్సత్రం తంకు అగరె జేకిరి సే పిల్లాసొ రొల్లా గొరొ ఉంపరె టారిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","తంకె సే నక్సిత్రముకు దిక్కిరి బడే సంతోసించిసె. ");
INSERT INTO rei_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","గొరొ బిత్తరుకు జేకిరి సే సన్నిపిల్లాసుకు తంకె మా మరియ దీకిరి తవ్వురొ దిగిసె. తంకె తా అగరె మోకరించికిరి పురువుకు ఆరాదించిసె. సే తరవాతరె తంకె దన్నైలా మూటానె పిటికిరి తాకు విలువైలా కానుకానె సున్న, సాంబ్రాని, బోలం, పురువుకు సమర్పించిసె . ");
INSERT INTO rei_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","పురువు తంకు హేరోదు పక్కు జేతెనాబులి సే తెలివిలింకెకు హెచ్చరించిసి. సడకు తంకె దెసొకు తంకె ఇంగుటె బట్టరె బాజేసె. ");
INSERT INTO rei_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","తంకె బాజెల్లా తరవాతరె దేవదూత యోసేపుకు సొప్నొరె దిగదీకిరి, “ఉటు! హేరోదు పిల్లాసొకు మొరదిమ్మాసిబులి తా కోసం కుజ్జిలీసి. మా, పిల్లకు దరిగీకిరి ఐగుప్తు దెసొకు బాజా! మియి కొయిలా జాంక సెట్టాక రో” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","యోసేపు ఉటికిరి మా, పిల్ల దీకిరి సే రత్తిరాక ఐగుప్తు దెసొకు బయలుదేరిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","యోసేపు హేరోదు మొరిజిల్లా జాంక సెట్టాక రొయిజీసి. సెత్తెలె ప్రబువు ప్రవక్త దీకిరి, “మియి మో పోకు ఐగుప్తు దీకిరి డక్కించి” బులి కొయిలా కొత సొత్తయిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","జ్ఞానులు హేరోదుకు మోసం కొరిసె బులి రగ్గొ సంగరె సిజ్జిజేసి. సెయ్యె తంకె కొయిలా కొత దీకిరి బేత్లెహేమురె, సే పక్కరె గాన్రె దీట బొచ్చురోనె దీట బొచ్చురోనె కన్నా సన్ని వయస్సు రొల్లా వొండ్రపో పిల్లానుకల్లా మొరిదీపేండి బులి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","యాకిరి యిర్మీయా ప్రవక్త దీకిరి ప్రబువు కొయిల ఏ విసయం సొత్తయిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“రామా బుల్లా పట్టనంరె బడే దుక్కం తీకిరి కంద సుందీసి. రాహేలు తా పిల్లానె కోసం కందిలీసి. ఓదార్చితె కేసె నింతె. తా లింకె కేసె మిగిల్లానింతె.” ");
INSERT INTO rei_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","హేరోదు మొరిజిల్లా తరవాతరె దేవదూత ఐగుప్తురె రొల్లా యోసేపుకు సొప్నొరె దిగదీకిరి, ");
INSERT INTO rei_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ఉటు! పిల్లాసుకు పొర్నొ కడిమాబులి దిగిలాలింకె మొరిజీసె. ఈనె మాకు, పిల్లకు దరిగీకిరి ఇస్రాయేలు దెసొకు జా” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","సడుకు యోసేపు ఉటికిరి మాకు, పిల్లకు సంగరె ఇస్రాయేలు దెసొకు అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ఈనె యూదయ దెసొకు హేరోదు చోటురె తా పో అర్కెలా పాలించిలి బులికిరి సునికిరి సెట్టికు జేతె డొరిజేసి. తాకు గుటె సొప్నొ అయిసి. సే సొప్నొరె ప్రబువు తంకు బోదించిలందరె సెయ్యె గలిలయ ప్రాంతముకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","సెట్టికి జేకిరి నజరేతు బుల్లా గారె రొయితవ్వె. సెల్లె “సెయ్యె నజరేతురె రొల్లా మనమబులి” డక్కుసె బులి పురువురొ ప్రవక్తనె సంగరె కొయిలా కొత సొత్తయిసి. ");
INSERT INTO rei_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","సే దినోన్రె బాప్టీసం దిల్లా యోహాను, యూదయ దెసొరె బొనొరె వాక్యం ప్రకటించితవ్వి. ");
INSERT INTO rei_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","సెయ్యె పురువురొ రాజ్యొ అముకు పక్కరాక అచ్చి ఈనె తొమె చెడుపైటీనె సడదేండి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","యోహాను గురించి పురువు యెసయా ప్రవక్త సంగరె యాకిరి కొయిసి. “ప్రబువు కోసం బట్టొ సిద్దం కొరుబులికిరి, బట్టొ బొలుకొరుబులికిరి, బొనొరె గుటె గొలాసుందిసి.” ");
INSERT INTO rei_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","యోహాను పొగ్గిల్లా కొన్నానె ఒంటురొ బల్లోనె దీకిరి కొరిలాంచ. వొంటకు సొమ్మొ దొగుడి బందిగీకిరి, తా కద్ది మిడతానె, బొనొతేనె కైకిరి జీతై. ");
INSERT INTO rei_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","మనమానె యెరూసలేము తీకిరి, యూదయ, యొర్దాను వొద్దొ పక్కరెతల్లా గాండ్రెతీకిరి యోహాను పక్కరకు అయికిరి. ");
INSERT INTO rei_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","తంకె కొరిలా పాపోనె ఒప్పిగినికిరి యోహాను సంగరె యొర్దాను వొద్దొరె బాప్టీసం కడిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","యోహాను బాప్టీసం దిల్లబెల్లె సెటుకు పరిసయ్యునె, సద్దూకయ్యునె, అయిసె సెల్లె యోహాను “తొమె సప్పొపనా మనమనే! పురువురొ రగ్గొతీకిరి తప్పించిగిత్తే తొముకు బుద్ది కొయిలాలింకె కేసె? ");
INSERT INTO rei_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","తొమె పాపోనెకు సడదీకిరి తొమె మనుసు మార్చిగీకిరి యెడానె కొరండి. ");
INSERT INTO rei_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘అబ్రాహాము అం బొ’ బులి కొయిగీకిరి తొమె యే సిక్సతీకిరి తప్పించిగిమాసి బులి కొయిగిల్లీసొనా? ఈనె ఏ పొత్రొనె దీకిరి పురువు అబ్రాహామురొ పిల్లానె ఈలాపనికిరి కొరిపారి బులి మియి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ఉంచినాక గొడ్డలి గొచ్చొనె సెరోనె ఉంపరె అనితె అచ్చి. బొల్ట పొగలానె నాదిల్లా ప్రతీ గొచ్చుకు అనిపేకిరి నియ్యరె పొక్కదివ్వొ. ");
INSERT INTO rei_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","తొమె మారుమనుసు పొందిసొ గనుక మియి తొముకు పని సంగరె బాప్టీసం దిల్లించి. ఈనె మో తర్వాతరె అయితల్లాట మో కన్నా సక్తి యీలాట! తా చెప్పిలీనె బొయితె కూడా మియి సొరుపొడుని. సెయ్యె తొముకు పవిత్రాత్మ దీకిరి, నియ్యదీకిరి, బాప్టీసం దూసి. ");
INSERT INTO rei_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","తా కుల్ల తా అత్తరె అచ్చి తా కొలకు బొలికొరికిరి తా దన్నొకొట్టురె పొక్కిరి, పొట్టుకు నానూజిల్లా నియ్యరె పొక్కిరి పుడ్డిపీవొ” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","యేసు గలిలయ తీకిరి యొర్దాను వొద్దొ పక్కు అయికిరి సే సమయంరె యోహాను అత్తరె బాప్టీసం కడిగిత్తె అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ఈనె యోహాను తాదీకిరి, “తో సంగరె మియి బాప్టీసం కడిగిమాసి, ఈనె తువ్వు మో సంగరె బాప్టీసం కడిగిత్తె అయివురొ కిడా?” బులి కొయికిరి యేసుకు ఆపితె ప్రయత్నించిసి. ");
INSERT INTO rei_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","యేసు సమాదానం దీకిరి, “ఉంచునుకు ఎడ యీమురొ. నీతి కోసం యాకిరి కొరువురొ అముకు బొల్టాక!” బులి కొయిసి. ఎడకు యోహాను ఒప్పిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","యేసు బాప్టీసం పొందిగీకిరి ఎంట్రాక, పనిబిత్తరె తీకిరి దోరకు అయిసి, యిత్తో మెగొ పిటిగిచ్చి, పురువురొ ఆత్మ గుటె పావురం పనికిరి వొల్లికిరి తా ఉంపరకు అయివురొ యేసు దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ఈనె యిత్తో యెయ్యాక మో యిస్టమైలా పో, ఆ ద్వారాక మీ ఆనందించిలించి బులి గుటె సబ్దం మెగొతీకిరి అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","సే తరవాతరె అపవాది దిల్లా సోదనానె ఎదిరిగిమ్మాసి బులికిరి, పురువురొ ఆత్మ యేసుకు బొనొ ప్రదేసంకు కొనిగిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","సెట్టె యేసు నలపై దినొనే రత్తిదూసు ఉపాసం కొరిసి. సే తరవాతరె తాకు బొక్కొ లగిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","అపవాది తా పక్కు అయికిరి, “తూ పురువురొ పో యీనె ఏ పొత్రొరొనుకు రొట్టెలుగా ఆజ్ఞాపించు” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","యేసు సమాదానం దీకిరి, “మనమకు జీపించిలాట కేవలం కద్దాక నీయి. ఈనె లేకనానె తల్లాపనికిరి పురువు కొయిలా ప్రతీ కొత వలరె జీపారి బులి రాసికిరి అచ్చి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","సే తరవాతరె అపవాది పురువుకు పరిసుద్ద పట్నం ఈలా యెరూసలేముకు కొనిగిజేసి. సెట్టె మందిరం ఉంపరె గుటె సికరమంపరె టారదీకిరి, ");
INSERT INTO rei_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","తువ్వు పురువురొ పొ యీనె తొల్లుకు గెంతు, కిరుకుబుల్నే “తొత్తె సహాయం కొరుబులికిరి, పురువు తా దూతానెకు కొయివొ. తంకె అయికిరి తొ పాదంకు కే పొత్రొ నాబయికుంటా తొత్తె తంకె అత్తోనె దీకిరి టెక్కికిరి కొగ్గునుసె బులి రాసికిరి అచ్చి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","యేసు తా దీకిరి, “తో ప్రబుయీల పురువుకు పరిక్సించినాసి బులికిరంకా లేకనాల్రె రాసికిరి అచ్చి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","అపవాది తాకు బడే డెంగరొల్లా గుటె పొరొతొ ఉంపురుకు కొనిగి జేకిరి తాకు దెసోనెరో రాజ్యాలుకు, సడాన్రో మహిమకు దిగదీసి. ");
INSERT INTO rei_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“తూ మో అగరె ముడుకూనె పొక్కిరి మెత్తె పూజించినె ఎడల్లా తొత్తె దూంచి బులి” అపవాది కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","యేసు సమాదానం కొయికుంటా, “అపవాది! మో అగరెతీకిరి బాజా, కిరుకుబుల్నే ‘తొ ప్రబుయీల పురువుకాక మొక్కిమంచి. తా సేవ మాత్రమాక కొరుమంచి’ బులి కూడా లేకనాల్రె రాసికిరి అచ్చి.” ");
INSERT INTO rei_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","సెల్లె అపవాది తాకు సడదీకిరి బాజీసి. తర్వాతరె దేవదూతానె అయికిరి యేసుకు పరిచర్య కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","సెల్లె యోహాను చెరసాలరె అచ్చిబులికిరి సునికిరి యేసు గలిలయకు బుల్లికిరి అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","సెయ్యె నజరేతుకు సడదీకిరి, సెట్టెతీకిరి కపెర్నహూము బుల్లా గాకు జేకిరి సెట్టె రొయితవ్వి. కపెర్నహూము, జెబూలూను ఇంకా నప్తాలి గానె పక్కరె ఒద్దొ ఒడ్డురె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","యెయ్యె కొరివురొ వల్లరె పురువు యెసయా ప్రవక్త సంగరె కొయిల కొతానె సొత్తయిసి. యెసయా ప్రవక్త యాకిరి కొయిసి, ");
INSERT INTO rei_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","జెబూలూను ప్రాంతము, నప్తాలి ప్రాంతము, సోంద్రొ పక్కరె రొల్లా యే మనమానె, యొర్దాను ఒద్దుకు తెనాడె పొక్కరె రొల్లా గానె! యూదునెనీలాలింకె తంకె రొల్లా ఓ గలిలయా! ");
INSERT INTO rei_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","వొందార్రె రొల్లా మనమానె గొప్ప వెలుతురు దిగుసె! మొర్నొ పొడిల గాన్రె రొయితల్లా మనమానె వుంపరె వెలుతురు అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","సెల్లె తీకిరి యేసు, “పురువురొ రాజ్యొ పక్కరాక అచ్చి. ఈనె మారుమనుసు పొందిగీండి!” బులి వాక్యం ప్రకటించువురొ మొదలు కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","యేసు గలిలయ సొంద్రొ ఒడ్డురె సలుకుంటా పేతురు బులి డక్కితల్లా సీమోనుకు, తా బయి అంద్రెయకు దిగిసి. తంకె సెల్లె సోంద్రొ బిత్తరె వల పొక్కుంటా అచ్చె; తంకె మచ్చర్లింకె. ");
INSERT INTO rei_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","యేసు తంకు దిక్కిరి, “మెత్తె అనుసరించొండి! తొముకు మనమానుకు దరిలాపని కొరిమి” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ఎంట్రాక తంకె వలలకు సడిదీకిరి తా పొచ్చాడె జేసె. ");
INSERT INTO rei_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","యేసు సెట్టె దీకిరి జేకుంటా దీలింకు దిగిసి. తంకె కూడా బయినె. జొనెరొ నా యాకోబు, యింకజొనెరొ నా యోహాను. బోరొ నా జెబెదయి. సే అన్నబయినె తంకె బో దీకిరి మిసికిరి పడవరె బొసిరికిరి వలానె బొలికొరిగిల్లీసె. యేసు తంకు డక్కిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","తంకె ఎంట్రాక పడవకు, తా బోకు సడదీకిరి తా పొచ్చాడె జేసె. ");
INSERT INTO rei_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","యేసు యూదునెరొ ప్రార్దన స్దలమురె బోదించుకుంటా పురువురొ రాజ్యం గురించి సువార్త కొయికుంటా గలిలయ ప్రాంతమల్లా బుల్లిలీసి. సెయ్యె మనమాన్రొ ప్రతి రోగము యింకా జబ్బునుకు బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","తా కీర్తి సిరియా దెసల్లా యే వార్త వ్యాపించిసి. మనమాన్రొ రకరకాల రోగోనే రొల్లాలింకు, బాదపొడిలాలింకు, బుత్తోనె దరిలాలింకు, మూర్చ జబ్బులింకు, పక్సవాత జబ్బులింకు, తా పక్కు డక్కిగీకిరి అయిసె సెయ్యె తంకు బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","గలిలయ తీకిరి, దొస్ట పట్టనమూనె తీకిరి, యెరూసలేము తీకిరి, యూదయ తీకిరి, యొర్దాను ఒద్దొ తెనాడె రొల్లా ప్రాంతమూనె తీకిరి మనమానె గుంపునె గుంపునెగా తాకు అనుసరించిసె. ");
INSERT INTO rei_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ఈనె యేసు బడే మనమానుకు దిక్కిరి పొరొతొ ఉంపరకు జేకిరి బొసిరిసి. సే తరవాతరె తా సిస్యునె తా పక్కు జేసె. ");
INSERT INTO rei_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","యేసు యాకిరి ఉపదేసించివురొ మొదలు కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ఆత్మ విసయమురె దీనులుగా తల్లాలింకె దన్యూనె; పురువురొ రాజ్యం తంకట. ");
INSERT INTO rei_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","దుక్కొపొడిలాలింకు పురువు ఓదార్చుసి. ఈనె తంకె దన్యూనె. ");
INSERT INTO rei_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","నెమ్మది మనస్సు తల్లాలింకె బూమికి వారసులూసె. ఈనె తంకె దన్యూనె. ");
INSERT INTO rei_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","నీతి న్యాయం కోసం ఆసక్తి రొల్లాలింకె దన్యూనె. సడ వల్లరె తంకె త్రుప్తి పొడివె. ");
INSERT INTO rei_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","పొదర్లింకంపరె కనికరం తల్లాలింకె దన్యూనె. పురువురొ కనికరం పొందివె. ఈనె తంకె దన్యూనె. ");
INSERT INTO rei_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","పవిత్ర హ్రుదయం కల్గిలాలింకె దన్యూనె, తంకె పురువుకు దిగుసె. ");
INSERT INTO rei_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","సమాదానపర్చిలాలింకె దన్యూనె; తంకు పురువురొ పోనె బులి డక్కుసె. ");
INSERT INTO rei_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","పురువురొ ఇస్టంకు జరిగించితె హింస పొడిలాలింకె దన్యూనె; పురువురొ రాజ్యం తంకట. ");
INSERT INTO rei_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","మెత్తె అనుసరించువురొ వల్లరె మనమానె తొముకు నిందించుసె, హింసించుసె, తొమంపరె విరోదంగా నిందానె పొగిలా బెల్లె తొమె దన్యూనె. ");
INSERT INTO rei_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","సంతోసించొండి ఆనందించొండి, తొముకు పరలోకంరె తొం పలం బడేట వూసి. ఈనె తొమె దన్యూనె. యాకిరి తొముకు హింసించిలాపనికిరాక తొముకన్నా అగరె తల్లా ప్రవక్తానెంకా హింసించబొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","తొమె యే లోకంరె నున్నొపనాలింకె, ఈనె నున్నొరె తల్లా గునొ జెన్నే సడకు నున్నొగా క్యాకిరి కొరిపారొ? సడ కిరుకు నాపైటికైకుంటా ఈజుసి. మనమానె సడకు మండిపేకిరి సలుసె. ");
INSERT INTO rei_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","తొమె యే లోకంరె హల్లొ పనాలింకె. పొరొతొ ఉంపరె తల్లా పట్నంకు మరుగు పరుచువురొ సాద్యమైని. ");
INSERT INTO rei_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","మనమానె బొత్తికి పుడ్డికిరి కుంచ తొల్లె లొగినింతె ఈనె సడ గొరొ బిత్తరె తల్లాలింకల్లా హల్లొ దీతందుకు బొత్తి స్తంబమంపరె లొగివె. ");
INSERT INTO rei_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","సాకిరాక తొం జీకానె హల్లొదీకిరి ప్రకాసించుమాసి. సెల్లె పొదరలింకు తొమె కొరిలా బొల్ట పైటినె దిక్కిరి పరలోకంరె తల్లా తొం బో స్తుతించబొడివొ. ");
INSERT INTO rei_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","మియి దర్మసాస్త్రంకు ఈనన్నా, ప్రవక్తనెరొ కొతానెకన్నా రద్దు కొరితె అయించి బులి కొయిగిత్తెనాండి. మియి సడకు రద్దు కొరితె అయిలాని. సడకు కొరితాక అయించి. ");
INSERT INTO rei_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","మెగొ బూమి గతించుసి గాని, దర్మసాస్త్రమురె సన్ని అక్సరం ఈనెను, పొల్లు ఈనెను గుటె సున్నా ఈనెను తప్పిజెన్నీ బులి కచ్చితంగా తొముకు కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ఈనె యే ఆజ్ఞానెరె కే సన్నీట ఈనెను సారాక మిసికిరి, సెయ్యె పొదరిలింకు సాకిరి కొరుబులికిరి బోదించిలా మనమ పురువురొ రాజ్యంరె తక్కువ మనమపనికిరి బచ్చుసె. ఈనె సే ఆజ్ఞానె సొబ్బీ పాటించికిరి సడకు బోదించిలాట పురువురొ రాజ్యంరె గొప్పీటపనికిరి బులుగుచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","కిరుకుబుల్నే, తొమె సాస్త్రీనెకన్నా పరిసయ్యునెరొ నీతి కన్నా తొం నీతి ఎక్కువగా నారొన్నె పురువురొ రాజ్యం బిత్తురుకు జెన్నారొ బులికిరి తొం సంగరె కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","సే కలోనురె బొడిలింకె కొయిలాట తొమె సునిసొ నీనా మొరదిన్నాసి మొరదిల్లాలింకు సిక్స పొడుసి. ");
INSERT INTO rei_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","మియి కొయిలాట కిరబుల్నే, తా అన్నబయి ఉంపరె రగ్గోపొడిల ప్రతి మనమకు సిక్స తప్పిని. తా అన్నబయి పైటి నాఅత్తరైలా మనమ బులి కొయిల ప్రతి మనమ మహసబరే సమాదానం కొయిమంచి. తా అన్నబయికు మూర్కుడా బులి కొయిలా ప్రతి మనమ నరకంరె నియ్యపాలు వూసి. ");
INSERT INTO rei_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ఈనె తు, తొ కానుక బలిపీటం పక్కరె లొగిల అగరె, తో అన్నబయికు తోఉంపరె కిరన్నా కారనంరె రగ్గొ అచ్చి బులికిరి గుర్తు అయినె, ");
INSERT INTO rei_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","తో కానుక సెట్టాక బలిపీటం పక్కరె సడిదీకిరి బాజా. జేకిరి తో అన్నబయిదీకిరి అగరె రాజీపొడు. సే తరవాతరె అయికిరి తొ కానుకకు అర్పించు. ");
INSERT INTO rei_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“తూ తో ప్రతివాది దీకిరి బట్టరె తల్లబెల్లాక తాదీకిరి రాజీ పొడు”. ఈనె సెయ్యె సాకిరి నాకొరినె తొముకు న్యాయాదిపతికు అప్పగించుసి. సే న్యాయాదిపతి తొముకు బటుడుకు అప్పగించుసికివో, సే బటుడు తొముకు చెరసాలరె పొక్కదివొచ్చు. ");
INSERT INTO rei_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","యెడ సొత్తాక తొమె దివ్వలిసిలా చివరికాసు దిల్లాజాంక తొమె సే చెరసాలరె దీకిరి పొదరకు అయినారొ. ");
INSERT INTO rei_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","దర్నిపైటి కొరితెనాండి బులి కొయిలాట తొమె సునిసొ నీనా. ");
INSERT INTO rei_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ఈనె మియి కొయిలాట కిరబుల్నె, జొనె తిల్డ్రపిల్ల ఆడుకు కామం దీకిరి దిగినే, హ్రుదయంరె తాదీకిరి దర్నిపైటి కొరిలాపనికిరాక. ");
INSERT INTO rei_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","తు పాపం కొరితె తో కైలాఅంకి కారనంయినె సడకు కడికిరి పొక్కదేండీ. తో దే అల్లా నరకంబిత్తరె పోడిలకన్నా తో దేరె గుటె బాగం వొరదీగిన్నే బొల్ట. ");
INSERT INTO rei_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","తు పాపం కొరితె తో కైల అత్తొ కారనంయినె సడకు అనికిరి పొక్కదేండి. తో దే అల్లా నరకం బిత్తరె పొడిలాటకన్నా తో దేరే గుటె బాగం వొరదీగిన్నె బొల్ట. ");
INSERT INTO rei_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","తా నెయిపొకు విడాకులు దివ్వొలిసిలాట కేసన్నా తా నెయిపొకు విడాకులు పత్రం దిమ్మంచిబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ఈనె మియి కొయిలాట కిరబుల్నే నైపో ఉంపరె దర్నిపైటి కారనం నీకుంటా గొయిత తాకు విడాకులుదిన్నె సెయ్యె దర్నిపైటి కొరిలాపని‍ పరిగనింపబొడితె సెయ్యె కారనం ఊసి. సాకిరాక విడాకులు పొందిలా తిల్డ్రపిల్లకు బ్యా కొరిగిన్నె దర్నిపైటికొరిలపనికిరి పరిగనింపబొడుసె. దర్నిపైటి కారనంసంగరాక తా నెయిపొకు విడాకులు దిమ్మంచి గాని ఇంగుటె కారనం నీ. ");
INSERT INTO rei_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","సే మొక్కుబడి కొత తప్పితెనాండి. ప్రబువు దీకిరి కొరిలా మొక్కుబడి నెరవేర్చిగీండి, బులి సే కలొన్రె మనమానుకు కొయిలాట తొమె సునిసొ నీనా. ");
INSERT INTO rei_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ఈనె మియి కొయిలాట కిరబుల్నె, కెడవుంపరె మొక్కుబడి కోసం ప్రమానం కొరితెనాండి, మెగొ పురువురొ సింహాసనం ఈనె మెగొ ఉంపరె ప్రమానం కొరితెనాండి. ");
INSERT INTO rei_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","బూమి పురువురొ పాదపీటం ఈనె యెరూసలేము మహారొజారొ పట్టనం యీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","తొం ముండొ ఉంపరె తల్లా గుటె బల్లో కూడా దొగలైకిరి గాని, కలియేకిరి గాని, మార్చినారొ. ఈనె తొమె ముండొ ఉంపరె ప్రమానం కొరితెనాండి. ");
INSERT INTO rei_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","తొం కొతా వై బులి బులిమా బులిరొన్నె వై బులి కోండి. నీ బులి బులిమా బులి రొన్నే నీబులి కోండి. ఈనె ఎడకు మించికిరి కెటువంటి కొతన్నా తొం తీకిరి అయినె సడకు కారనం సే దుస్ట ఆత్మాక. ");
INSERT INTO rei_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","అంకికి అంకి, దంతొకు దంతొ కడిపిమంచె బుల్లా కొతా తొమె సునిసో నీనా. ");
INSERT INTO rei_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ఈనె మియి కొయిలాట కిరబుల్నే విరోది హానికొర్నే తాకు ఆపితె ప్రయత్నం కొరితెనాండి. తొముకు కేసన్నా కైల చెంపంపరె మరినె తొ దీటో చెంపంకా తాకు దిగదె. ");
INSERT INTO rei_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","కేసన్నా తొమంపరె కొలీ లగినె తో కొన్నానె కూడా జింకిగిమ్మాసి బులి దిగినె, తో కండువాంక దీపొండి. ");
INSERT INTO rei_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","కేసన్నా తొముకు తంకె దీకిరి గుటె మైలు దూరు ఆయిబులి బలవంతం కొర్నే, తాసంగరె దీట మైలు జాండి. ");
INSERT INTO rei_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","మగిలాలింకు దేండి తొం పక్కరె అప్పు కడిగిమాబులి బులిగీకిరి అయిలాలింకు దిక్కిరి నీబులితెనాండి. ");
INSERT INTO rei_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","జట్టుకారీనెకు ప్రేమించొండి. సత్రువూనెకు ద్వేసించోండి బులి కొయివురొ తొమె సునిసోనీనా. ");
INSERT INTO rei_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ఈనె మియి ఉంచినె కొయిలాట కిరబుల్నే తొం సత్రువూనెకు ప్రేమించోండి తొముకు హింసించిలాలింకు కోసం ప్రార్దించొండి. ");
INSERT INTO rei_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","సెల్లె తొమె పరలోకంరె తల్లా తొం బోరొ పిల్లానె యీపారొ. కిరుకుబుల్నే పురువు‍ చెడ్డలింకు కోసం, బొల్టలింకు కోసం సూర్యోదయం కలిగించిసి. చెడ్డలింకు కోసం, బొల్టలింకు కోసం బొరస పొడదిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","తొముకు ప్రేమించిలాలింకు తొమె ప్రేమించినె తొముకు ప్రతిపలం కలిగినీ? పన్నునె వొసులు కొరిలాలింకె కూడా సాకిరాక కొరివెనీనా! ");
INSERT INTO rei_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","తొమె తొం అన్నబయినెకాక అబివందనము కొర్నే పొదర్లింకె కన్నా గొప్ప కిర? పొదరెలింకె కూడా సాకిరాక కొరివెనీనా! ");
INSERT INTO rei_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","పరలోకంరె తల్లా తొం బో పరిపూర్నునుడు యిలాట. తొమ్మంకా తా పనికిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“జాగర్త! తొమె కొరిలా బక్తిపరమయిలా నీతి పైటీనె పొదరిలింకె దిగిలా పని కొరితెనాండి. సాకిరి కొర్నే పరలోకంరె తల్లా తొం బో తొముకు ప్రతిపలం దిన్నీ.” ");
INSERT INTO rei_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","సడకు తొమె దానం కొరిలాబెల్లె చాటింపు పొగ్గీకిరి సార్లింకూ బుజ్జిలాపనికిరి కొరితెనాండి. కపటలింకె సమాజం బిత్తరె, సెయీన్రె, మనమానె గౌరవించిమాసిబులికిరి సాకిరి కొరుసె. యెడ సొత్తాక, తంకు మిలివలిసిలా ప్రతిపలం సెల్లాక పూర్తిగా మిలుసి. ");
INSERT INTO rei_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ఈనె, నీలాలింకు తొమె దానం కొరిలాబెల్లె తో బత్తొ కయిల అత్తొ కిర దిల్లీవొ తో బాఅత్తొకు తెలిసిపించినాసి. ");
INSERT INTO rei_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","సెల్లె తో దానం కాకు నాఅరకైకుంటా తాసి. సెల్లె తొమె రహస్యంగా కొరిలాంచకు దిక్కిరి తో బో తొత్తె ప్రతిపలం దూసి. ");
INSERT INTO rei_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ఈనె తొమె ప్రార్దన కొరిలాబెల్లె వేసదారునె పనికి ప్రార్దించితెనాండి. తంకె సబాస్దలం, సెయీన్రె, పాకలురె టారీకిరి సార్లింకె దిగిమంచిబులికిరి ప్రార్దన కొరువురొ తంకు ఇస్టం. ఈనె ఎడ సొత్తాక తంకు మిల్లా పలితం సెల్లె తంకు పూర్తిగా మిలుసి. ");
INSERT INTO rei_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ఈనె తొమె ప్రార్దన కొరిలాబెల్లె గొరొబిత్తరకు జేకిరి తట్టీనె పొగ్గీకిరి రహస్యంగా తొం బోకు ప్రార్దన కొరొండి. సెల్లె రహస్యంరె తల్లా తొం బో తొముకు ప్రతిపలం దూసి. ");
INSERT INTO rei_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ఈనె తొమె ప్రార్దన కొరిలాబెల్లె నాపైటికైలా కొతానె పొదరెలింకె పనికిరి కొరినాసి. సాకిరి బొట్ట ప్రార్దన కొరిలాబెల్లె పురువు సునువొ బులి తంకె బులుగునుసె. ");
INSERT INTO rei_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","తొమె తంకెపనికిరి కొరితెనాండి. తొముకు కిర కావాలో తొమె నాపొచ్చర్లా అగరాక తొం బోకు తెలుసుసి. ");
INSERT INTO rei_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ఈనె తొమె యాకిరి ప్రార్దించిమంచె, పరలోకంరె పురువైలా మో బో, తో నా గౌరవింపబొడుమాసి. ");
INSERT INTO rei_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","తో రాజ్యం అయిమంచి, పరలోకంరె తో ఇస్టం నెరవేరిలాపని యే లోకంరె కూడా నెరవేరిమంచిబులి అమె ప్రార్దించిలించొ. ");
INSERT INTO rei_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","సొబ్బి దినోనె అముకు కావలిసిలా కద్ది అముకు దే. ");
INSERT INTO rei_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","పొదర్లింకె అమె పట్ల కొరిలా అపరాదమునె అమె క్సమించిలాపనికిరి, అమె కొరిలా అపరాదమునె క్సమించు. ");
INSERT INTO rei_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","అమె సోదనరె నాపొడుకుంటా అముకు దుస్టుడు తీకిరీ తప్పించు. ");
INSERT INTO rei_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","పొదర్లింకరొ తప్పునెకు తొమె క్సమించినె పరలోకంరె తల్లా తొం బో తొముకు క్సమించివొ. ");
INSERT INTO rei_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ఈనె పొదర్లింకు తొమె నాక్సమించినె తొం బో అంకా తొం తప్పునె క్సమించిని. ");
INSERT INTO rei_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","వేసదారునె ఉపాసం కొరిలాబెల్లె మనమానె దిగిమంచి బులి తంకె మూనే నీరసంగా దిగదిల్లాపనికిరి కొరుగునుసె. తొమె ఉపాసం కొరిలాబెల్లె సాకిరి కొరితెనాండి. యెడ సొత్తాక, తంకె తంకరొ ప్రతిపలం పొందిసె బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","తొమె ఉపాసం కొరిలాబెల్లె “మూ” దొయిగీకిరి ముండొ అంచిడిగీండి ");
INSERT INTO rei_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","సాకిరి కొర్నె తొమె ఉపాసం కొరిలాపనికిరి మనమానుకు దిగిదిన్ని. ఈనె రహస్యంగా దిగిలా తో “బో” తెలుసుగుచ్చి. సెల్లె తొం బో తొం ప్రార్దన దిక్కిరి ప్రతిపలం దూసి. ");
INSERT INTO rei_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","తొం కోసం యే లోకంరె పలియకు సంపాదించితెనాండి. ఎట్టె సే పలియకు చెదానె దరిపొసి. సే పలియకు తుప్పు కయిపీవొ. సొరోనె పొడికిరి దోచిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","తొమె పలియకు పరలోకంరె కూర్చుగునొండి. సెట్టె చెదానె దరిని, తుప్పు కయిపీని. సొరోనె పొడికిరి దోచిగిన్నింతె. ");
INSERT INTO rei_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","తో సంపద కేటె తన్నే తో మనుసు కూడా కెబ్బుకూ సెట్టాక తాసి. ");
INSERT INTO rei_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","అంకి దేకు గుటె బొత్తిపనాట. తో అంకీనె బొల్లేరోన్నె తో దేఅల్లా హల్లొగా తాసి. ");
INSERT INTO rei_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ఈనె తో అంకీనె నాబొల్లర్నే తో దేఅల్లా వొందారొ యీజోసి. తొం బిత్తరె తల్లా హల్లొ వొందారొ యిజిన్నే సే వొందారొ కెత్తో డొరొగా తాసి. ");
INSERT INTO rei_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","జొనె మనమ దీలింకు యజమానునెకు సేవ కొర్నారి. సాకిరి కొర్నే సెయ్యె జొనుకు ప్రేమించికిరి, యింకాజొనుకు ద్వేసంచికిరి తాసి. ఈనె జొనుకు అతిస్రద్దదీకిరి సేవ కొరికిరి, యింకాజొనుకు అస్రద్ద కొరుసి. తొమె పురువుకు, పలియకు సేవ కొరివురొ ఈని. ");
INSERT INTO rei_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","సడవల్లరె మియి కొయిలాట కిరబుల్నే, తొం జీకానుకు కావలిసిలా కద్ది గురించి కాని, తొం దేనుకు కావలిసిలా కొన్నానె గురించి కాని, చింతించితెనాండి. కద్ది కన్నా పొర్నొ విలువైలాట నీనా? సాకిరాక కొన్నానె కన్నా దే ముక్యమైలాట నీనా? ");
INSERT INTO rei_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","మెగోన్రె ఉడిల్లా పక్సినెకు గమనించోండి. సడానె విత్తనాలు జల్లినింతె పచ్చానె పచ్చదిన్నింతె. ఈనె దన్నొకు కొట్టురె కూర్చుగిన్నింతె. ఈనె పరలోకంరె తల్లా తొం “బో” సడానుకు పోసించిలీసి. తొమె సడకన్నా విలువైలాలింకె నీనా? ");
INSERT INTO rei_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","చింతించికిరి తా జీవిత కలొకు గుటె గడియకు బొడిదిగిల్లాలింకె తొంబిత్తరె కెసన్నా అచ్చెనా? ");
INSERT INTO rei_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","తొమె కొన్నానె గురించి కిరుకు చింతించిలీసో? గసొంపరె బొడిలా పుల్లోనుకు గమనించోండి. సడనె పైటి కొర్నింతె కొన్నానె కొరిగిన్నింతె. ");
INSERT INTO rei_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ఈనె మియి కొయిలాట కిర బుల్నే గొప్ప విలువ తల్లా సొలొమోను రొజంకా అలంకరనమురె యే పుల్లోన్రె గుటె పుల్లొదీకిరి కూడా సరితూగునారి. ");
INSERT INTO rei_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ఆజి రొయికిరి కల్లికి సుక్కిజీకిరి నియ్యబిత్తరె పొక్కదిల్లా యే గసొకు పురువు ఎత్తె అందంగా అలంకరించినె తొముకు యింకెత్తొ అందంగా అలంకరించివొయో నీ! తొమె అల్పవిస్వాసినె. ");
INSERT INTO rei_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ఈనె “కిర కయిమంచి? కిర పీమంచి? కే కొన్నానె పిందిగిమంచి? బులి చింతించితెనాండి.” ");
INSERT INTO rei_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","పురువుకు నాజనిలా మనమానాక సడపొచ్చాడె దొమిడితోసె. పరలోకంరె తల్లా తొం బోకు ఎడల్లా తొముకు అవసరం బులికిరి తెలుసు. ");
INSERT INTO rei_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ఈనె అగరె తా రాజ్యం కోసం, నీతి కోసం ప్రయాస పొడొండి; సెల్లె సడల్లా పురువు తొముకు దూసి. ");
INSERT INTO rei_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","సడుకాక కల్లికి గురించి చింతించితెనాండి. కల్లికిరొ చింత కల్లికిరోటాక. కే దినొకు తగిలా కొస్టోనె సే దినొకాక చాలు. ");
INSERT INTO rei_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","తొమె తీర్పు తీర్చితెనాండి. సాకిరి కొర్నె పురువొంకా తొముకు తీర్పు తీర్చిని. ");
INSERT INTO rei_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","తొమె పొదరలింకె ఉంపరె తీర్పు తీర్చినె తొముకంకా పురువు తీర్పు తీర్చివొ. తొమె నప్పిలా నప్ప దీకిరి పొదరలింకె తొముకు నప్పికిరి దూసె. ");
INSERT INTO rei_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","తొమె తో బయిరొ అంకిరె తల్లా నలుసుకు దిగిలీసొ. ఈనె తొం అంకిరె తల్లా దూలముకు దిగినార్లీసొ. ");
INSERT INTO rei_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","తో అంకిరె దూలము తన్నుగా తో బయిరొ అంకిరె తల్లా నలుసుకు కడిగిత్తు బులి క్యాకిరి కొయిపార్లీసు? ");
INSERT INTO rei_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","వేసదారీ! అగరె తో అంకిరె తల్లా దూలముకు కడిగిత్తు. సెత్తెలె తో బయిరొ అంకిరె తల్లా నలుసుకు కడితె తొత్తె తేటగా దిగదూసి. ");
INSERT INTO rei_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","పరిసుద్దమైలాట కుక్కురొనుకు దీతేనాండి. తొం ఉంపరె పొడికిరి తొముకు చీల్చిపూసె. తొమె మూత్యాలుకు గుసిరీనె అగరె పొగితెనాండి. పొగినె సడ సడానుకు గొడ్డొనె తొల్లె మండిపూసె. ");
INSERT INTO rei_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","మగినె దూసి. కుజ్జినె మిలుసి. మరినె తలుపు కడుసి. ");
INSERT INTO rei_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","మగిలా ప్రతీ మనమ పొందివొ, కుజ్జిలాటకు మిలివొ, తలుపు మరిలాటకు తలుపు కడివొ. ");
INSERT INTO rei_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","పో రొట్టెకు మగినె పొత్రొ దిల్లా బో తొంబిత్తరె కేసన్నా అచ్చెనా? ");
INSERT INTO rei_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","నీనే మచ్చొ మగినే సప్పొకు కేసన్నా దూసేనా? ");
INSERT INTO rei_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","దుస్టులైలా తొమె తొం పిల్లానుకు బొల్టాంచ దిమ్మాసిబులికిరి తెలుసు నీనా! ఈనె సాటబెల్లె పరలోకంరొ తొం బో తాకు మగిలాలింకు బొల్టాంచ దిన్నీనా? తప్పకుండా దూసి. ");
INSERT INTO rei_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ప్రతీ విసయంరె పొదరలింకె తొముకోసం కిర కొరిమాసిబులి తొమె ఆసించులీసొ తొమె పొదరలింకు కోసం సాకిరాక కొరిమాసి. ఎడ మోసే దర్మసాస్త్రంరె, యింకా ప్రవక్తానె యాకిరి కొయిలా అర్దం యెడాక. ");
INSERT INTO rei_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","నాసనముకు జెల్లా బట్టొ యిరుకుగా తాసి. సే బట్టొ విసాలంగా అచ్చి. బడేలింకె సే బట్టొతీకిరి ప్రవేసించుసె. ");
INSERT INTO rei_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ఈనె నిత్యజీవముకు జెల్లా బట్టొ కస్టంగా రొవ్వొ. సే బట్టొ ఇరుకుగా రోసి. కుండిలింకె మాత్రమాక సడకు కనుగునుసె. యెడ గమనించోండి ఇరుకు తల్లా బట్టరాక ప్రవేసించోండి. ");
INSERT INTO rei_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","సొరొప్రవక్తానె విసయంరె జాగర్తగా తాండి. తంకె గొర్రి సొమ్మోనె పనా కొన్నానె గుడిగీకిరి తొం పక్కు అయివె. ఈనె బిత్తరె క్రూరమైలా తోడేల్లు పనికిరి రొవ్వె. ");
INSERT INTO rei_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","తంకు కలిగిల పలము దిక్కిరి తంకు తొమె గుర్తించి గలిగిమాసి. కొంటానె గొచ్చొ తీకిరి ద్రాక్స పొగలానుకు, పల్లేరు గొచ్చోనె తీకిరి అంజూరొ పొగలానుకు కట్టివురొ సాద్యమాకనా? ");
INSERT INTO rei_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","బొల్ట గొచ్చొకు బొల్ట పొగలానె కాసివొ. పుల్ల పొగలానె కాసిలా గొచ్చొకు పుల్ల పొగలానాక కాసుసి. ");
INSERT INTO rei_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","బొల్ట గొచ్చొకు పుల్ల పొగలానె కాసినింతె. ఈనె పుల్ల పొగలానె కాసిలా గొచ్చొకు బొల్ట పొగలానె కాసిని. ");
INSERT INTO rei_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","బొల్ట పొగలానె నాదిల్లా గొచ్చొకు అనికిరి నియ్యరె పొక్కదూసి. ");
INSERT INTO rei_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","సడకాక తంకె తంకు కలిగిల పలాలుకు దిక్కిరి తొమె తంకు గుర్తించి గలిగివాసి. ");
INSERT INTO rei_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","మెత్తె ప్రబూ! ప్రబూ! బులి డక్కిలెత్తె మాత్రాన పురువురొ రాజ్యం బిత్తురుకు జోంచోబులికిరి బులిగితెనాండి. ఈనె మో బో ఇస్టప్రకారం సల్లాలింకె మాత్రమాక జేపారె. ");
INSERT INTO rei_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","సే తీర్పుదిన్రె బడేలింకె మెత్తె దిక్కిరి, ప్రబూ! ప్రబూ! తో నారె అమె సువార్త ప్రకటించించొ? బుత్తోనుకు సొడదిపించించొనీనా? బడే అద్బుతానె కొరిలానింతొనా? బులి బులుసొ. ");
INSERT INTO rei_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","సెల్లె మియి తంకదీకిరి తొమె కేసెవో మెత్తె తెలిసిని. సెడ్డలింకైలా తొమె మో అగరెతీకిరి బాజాండి బులి స్పస్టంగా కొయిమి. ");
INSERT INTO rei_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ఈనె మో కొతానె సునికిరి సడకు ఆచరించిలా ప్రతి మనమ పొత్రొ ఉంపరె తా గొరొ బందిగిల్లా బుద్దిమంతుడుకు పోలికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","సే గొరొ రాతి పొత్రొ ఉంపరె బందిలాట. ఈనె బొర్స పొడినన్నా, వరదానె అయికిరి తుపాను బానే అయికిరి సే గొరొకు మరినన్నా సే గొరొ పొడ్నీ. ");
INSERT INTO rei_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ఈనె మో కొతానె సునికిరి సడకు నాఆచరించిలా ప్రతీ మనమ బల్లి ఉంపరె తా గొరొ బందిగిల్లా బుద్దినీలాట దీకిరి సమానము. ");
INSERT INTO rei_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","బొర్స అయికిరి, వరదానె అయికిరి, తుపాను బానే అయికిరి సే గొరొకు మర్నే సే గొరొ కూలిజేసి సడ పతనం బయంకరమైలాట. ");
INSERT INTO rei_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","సెల్లె యేసు యే కొతానె కొయికిరి ముగించిలాబెల్లె, మనమానె తా బోద సునికిరి ఆచ్చర్యపొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","సెయ్యె తంకు సాస్త్రీనె పనికిరి నీకుంటా, అదికారం రొల్లాపనికిరి తంకు బోదించిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","యేసు పొరొతొ ఉంపరె దీకిరి వొల్లిలాబెల్లె మనమానె గుంపునె గుంపునెగా తా పొచ్చాడె అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","కుస్టురోగం రొల్లా మనమ జొనె అయికిరి తా అగరె మోకరించికిరి, “బో, తొత్తె ఇస్టమైనె మెత్తె బొలుకొరుపారు” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","“మెత్తె ఇస్టమాక” యేసు తా అత్తొ చాపికిరి తాకు సూగీకుంటా, “తొత్తె బొలైమంచి బులి కోరిగిల్లునా, ఈనె బొలైసు” బులి కొయిసి. ఎంట్రాక తా కుస్టురోగం తీకిరి బొలైజీసి. ");
INSERT INTO rei_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","సెల్లె యేసు తా దీకిరి, ఏ సంగతి గురించి కాకు కొయితెనా ఈనె యాజకుడు పక్కు జేకిరి తో దే దిగదీకిరి, తొత్తె బొలైలపనికిరి తంకు రుజువయితె మోసే ఆజ్ఞాపించిలా కానుక చెల్లించు బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","యేసు కపెర్నహూము బుల్లా గాకు అయిలాబెల్లె రోమా అదికారి జొనె తా పక్కరకు అయికిరి, తాకు సహాయం మగిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“బో! మో సేవకుడు పక్సవాతం సంగరె గొర్రె మొంచరె కదిలినారుకుంటా పొడికిరి అచ్చి. సెయ్యె బడే బాదపొడిలీసి బులి కొయిసి.” ");
INSERT INTO rei_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","యేసు, “మియి అయికిరి తాకు బొలికొరుంచి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ఈనె అదికారి, “బో! నా, తూ మో గొర్రె గొడ్డొ లొగితే కూడా మియి అర్హుడుని. ఈనె తువ్వు కొతాబుల్నే చాలు, మో సేవకుడుకు బొలైజీవొ. ");
INSERT INTO rei_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","కిరకుబుల్నే, మియి కూడా అదికారినె తొల్లె తల్లాటాక. మో తొల్లె కూడా సైనికునె అచ్చె. మియి యే సైనికుడు సంగరె ‘జా’ బుల్నే జోసి; సే సైనుకుడు ఆయి బుల్నే ఆసి. మో సేవకుడు దీకిరి ‘యెడ కొరు’ బుల్నే కొరువొ” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","యేసు యెడ సునికిరి ఆచ్చర్యపొడిసి. సెయ్యె తా పొచ్చాడె అయిలాలింకె దిక్కిరి, యెడ సొత్తాక. ఎత్తె గొప్ప విస్వాసము తల్లా మనమ మెత్తె ఇస్రాయేలురె కేసె దిగిదిల్లానింతె. ");
INSERT INTO rei_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","మియి కొయిలాట కిరబుల్నె, తూర్పు దీకిరి, పడమర దీకిరి, బడేలింకె మనమానె ఆసె. అయికిరి, అబ్రాహాము, ఇస్సాకు, యాకోబు దీకిరి మిసికిరి పురువు రాజ్యంరె జరిగిలా విందురె మిసిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ఈనె తా రాజ్యొ వారసునెగా తవ్వొలిసిలాలింకె నానమ్మిలందరె తంకు వొందార్రె బిత్తరె పొక్కదివ్వె. సెట్టె తంకె కందానె, దంతోనె కమిడిగీకుంటా బాదకు అనుబవించుసె. ");
INSERT INTO rei_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","యేసు సతాదిపతి సంగరె, తువ్వు “జా! విస్వాసించిలపనాక జరుగుసి” బులి కొయిసి. సే గడియరె తా సేవకుడుకు బొలైజీసి. ");
INSERT INTO rei_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","యేసు పేతురు గొరొకు అయికిరి తా ససు జొరొ సంగరె మొంచ దరికిరి రొల్లాట దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","యేసు తా అత్తొకు సూగిత్తల్లాబెల్లె, జొరొ తాకు సడదీకిరి బాజేసి. సెయ్యె ఉటికిరి పరిచర్య కొరువురొ మొదలు కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","మనమానె సొంజైతల్లాబెల్లె, బుత్తోనె దరిలా బడేలింకు యేసు పక్కు డక్కిగీకిరి అయిసె. సెయ్యె గుటె కొత సంగరె బుత్తొనుకు సొడిపించిసి. జబ్బూనె సంగరె రొల్లలింకల్లా బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","సడకాక “సెయ్యె అమె బాదలకు తావుంపరె పొగ్గీకిరి అమె రోగునుకు బరించిసి” ఈనె యెసయా ప్రవక్త సంగరె పలికిలా ఏ కొతానె సొత్తయితె యాకిరి జరిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","యేసు తా చుట్టు తల్లా మనమానె గుంపునెకు దిక్కిరి, గలిలయ సోంద్రొ తెనాడె పొక్కు జాండిబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","సెల్లె దర్మసాస్త్ర పండితుడు జొనె అయికిరి, “బోదకా! తువ్వు కేటికి జెన్నే మియి సెట్టుకు అయిమి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","యేసు, “నక్కానె నుచ్చుపొడుతందుకు గత్తోనె అచ్చె. బారె ఉడిల్లా పక్సీనె రొయితందుకు గూడినె అచ్చె. ఈనె మనమరొ పో ముండొ వాల్చిగిత్తె కూడ సోటునీ” బులి తాసంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ఇంకా జొనె సిస్యుడు, “ప్రబూ! అగరె మో బో కు బుజ్జదీతే అనుమతి దే బులి కొయిసి.” ");
INSERT INTO rei_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ఈనె యేసు తాసంగరె, “మొరిజిల్లాలింకు బుజ్జదీతె మొరిజిల్లాలింకె అచ్చెదె తువ్వు మో సంగరె ఆయి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","యేసు పడవ ఉటిలాబెల్లె సిస్యునె తాసంగరె జేసె. ");
INSERT INTO rei_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","సెత్తెలె అకస్మాత్తుగా గుటె బొట్ట తుపాను సే సోంద్రొ ఉంపరకు అయిలందరె సే పడవ అలానె వల్లరె బుడ్డిజెల్లాపనికిరి అచ్చి. ఈనె సే సమయంరె యేసు గుమ్ముకుంటా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","సిస్యునె తాపక్కు అయికిరి తాకు ఉడదీకుంటా, “ప్రబూ! రక్సించు మొరిలాపనికిరి అచ్చొ!” బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","యేసు, తొముకు యెత్తె అల్పవిస్వాసం? కిరుకు దొరొపొడిలిసో? బులికిరి ఉటికిరి బాకు, అలలకు సాంతించుబులికిరి ఆజ్ఞాపించిసి. సడ సాంతించిసి. ");
INSERT INTO rei_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","తంకె ఆచ్చర్యపొడికిరి, “ఎయ్యె కేటవో? బా, అలానె కూడా ఆ కొత సునిలీసె” బులి కొయిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","యేసు, సోంద్రొ తెనిపొక్కరె తల్లా గదరేనీయునె దెసొకు చేరిగిచ్చి. బుత్తోనె దరిలా మనమానె దీలింకె సమాదులు దీకిరి అయికిరి తాకు మిసిగిచ్చె. అంకె క్రూర ప్రవర్తన వల్లరె సే బట్టొదీకిరి కేసె జెన్నారిలీసె. ");
INSERT INTO rei_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","సే బుత్తోనె, పురువురొ పో! అముకు కిరకొరిమంచి బులి అయిసు? తగిలా సమయం నాయిలా అగరాక అముకు సిక్సించిమాసి బులికిరి ఎట్టికి అయిసునా? బులి గట్టిగా దొందరికుంటా బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","తంకు కుండె దూర్రె గుటె గుసిరీనె గుంపు మేసికుంటా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","సే బుత్తొనె యేసుకు దిక్కిరి, “తూ అముకు పొడిదిపీమంచి బులి బులిగిన్నే సే గుసిరీనె గుంపు బిత్తరకు పొడిదిపే” బులి బతిమాలిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","సెయ్యె సడికిరి, “బాజాండి!” బులి కొయిసి. సడకు సడనె దోరకు అయికిరి సే గుసిరీనె బిత్తరకు బాజీసె. సే గుసిరీనె గుంపు సొబ్బి అగరె తల్లా పొరొతొ ఉంపరెతీకిరి దొమిడి జేకిరి సొంద్రొ బిత్తరె పొడికిరి మొరిజీసె. ");
INSERT INTO rei_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","సే గుసిరీనె జొగిలాలింకె సెట్టె దీకిరి దొముడుకుంటా గా బిత్తరకు జేకిరి జరిగిలాటల్లా కొయికిరి, సే బుత్తొ దరిలాలింకు కిరైసొ సొబ్బి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","సెల్లె యెడ సునికిరి సే గా అల్లా యేసుకు మిసితె అయిసె. తంకె తాకు దిక్కిరి తంకె రొల్ల ప్రాంతం సడదీకిరి బాజా బులికిరి బతిమాలిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","యేసు పడవ ఉటికిరి సోంద్రొ దాటికిరి సెయ్యె రొల్లా గాకు అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","కుండిలింకె మనమానె మొంచదరిలా జొనె పక్సవాత రోగికు సొప్పంపరె యేసు పక్కు దరిగీకిరి అయిసె. యేసు తంకె విస్వాసం దిక్కిరి సే పక్సవాతవ రోగిసంగరె, మో పో “దైర్యంగా రో, తో పాపోనె క్సమించబొడిసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ఎడ సునికిరి కుండిలింకె దర్మసాస్త్ర పండితులు తంకె బిత్తరె తంకె “ఎయ్యె పురువుకు దూసించువురొ కొరిలీసి” బులి కొయిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","తంకె కిరబులిగిల్లీసెవొ యేసుకు బుజ్జికిరి సెయ్యె తంకెసంగరె, “తొం హ్రుదయంబిత్తరకు సొరొలోచనానె కైంకి అయిపించిలీసొ? ");
INSERT INTO rei_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ఉటికిరి సలు ‘తో పాపోనె క్సమించించి’ బులి కొయివురొ సులువునా? ");
INSERT INTO rei_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","పాపోనె క్సమించితె మనమరొ పోకు బూమంపరె అదికారం అచ్చిబులికిరి తంకు నిరూపించిమంచిబులి” పక్సవాత రోగిసంగరె, సడకు“వుటు! తో సొప్ప దరిగీకిరి గొరుకు జా!” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","పక్సవాతం సంగరె తల్లా మనమ ఉటికిరి గొరుకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ఎడ దిక్కిరి సెట్టెరొల్ల మనమానుకు డొరొమొందిసి. మనమానుకు యెడపనా అదికారందిల్లా పురువుకు తంకె స్తుతించిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","యేసు సెట్టిదీకిరి బయిలుదేరికిరి జేతన్నుగా, మత్తయి బుల్లా మనమ బొసిరీకిరి పన్నునె వసూలు కొరువురొ దిగిసి. యేసు తాదీకిరి, “మో పొచ్చాటె ఆయి” బులిసి. మత్తయి ఉటికిరి తా పొచ్చాడె జేసి. ");
INSERT INTO rei_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","యేసు, మత్తయి గొర్రె బత్తొకైతె బొసికిరి తల్లాబెల్లె, బడేలింకె పన్నునె వొసులుకొరిలాలింకె, పాపోనె అయిసె, తంకల్లా యేసుదీకిరి, తా సిస్యునెదీకిరి మిసికిరి బత్తొ కైతె బొసిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","పరిసయ్యునె ఎడ గమనించికిరి యేసు సిస్యునె సంగరె, “తొం బోదకుడు, పన్నునె వసూలుకొరిలాలింకె సంగరె, పాపోనె సంగరె మిసికిరి కిరుకు కద్ది కయితె బొసిరీసి?” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","యేసు ఎడ సునికిరి బొల్లెరొల్లాలింకు వైద్యుడు అవసరంనీ. జబ్బుదీకిరి తల్లలింకాక వైద్యుడు అవసరం తాసి. ");
INSERT INTO rei_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","లేకనాల్రె కిడచ్చో జేకిరి పరిసీలించొండి మియ్యి పాపోనెకు డక్కితె అయించి గని, నీతిమంతునెకు డక్కితె అయిలానీ. మీ దయకాక కోరిలించి గాని, జంతు బలినె కోరిలాటనీ. ");
INSERT INTO rei_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","సే తరవాతరె బాప్టీసం దిల్లా యోహానురొ సిస్యునె యేసు పక్కు అయికిరి, “అమె, పరిసయ్యునె కెబ్బుకూ ఉపాసం కొరిలించొ ఈనె తో సిస్యునె ఉపాసం కిరుకు కొర్నింతే?” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","యేసు, యాకిరి జవాబు దీసి. “బొర్రొ తంకసంగరె తల్లాబెల్లె బ్యా గొరొలింకె కిరకు ఉపాసం కొరువె? ఈనె బొర్రొకు తంకుపక్కరెతీకిరి కొనిబాజెల్లా సమయం ఆసి. సెత్తెలె తంకె ఉపాసం కొరుసె” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","కేసెయినెను “చిరిజిల్లా పుర్న కొన్నాకు నోకొన్న సంగరె మాసిక పొగినింతె. సాకిరి కొర్నే సే అతుకు చిరిజోసి. సెత్తెలె నోకొన్న సే కన్నంకు యింకా బొట్టకొరుపూసి. ");
INSERT INTO rei_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","సాకిరాక నోటైలా ద్రాక్సరసంకు పుర్న సొమ్మొసంచిరె నుచ్చినింతె. సాకిరి కొర్నే సే సొమ్మొసంచి చిరిజీకిరి సే ద్రాక్సరసము నాసనమైజీవొ. సెత్తాకనీకిరి సే సొమ్మొసంచి కూడా నాసనమైజివ్వొ. సడకు నోటైలా ద్రాక్సరసముకు నో సొమ్మొసంచిరాక నుచ్చికిరి రొయిదిమ్మాసి. సాకిరి కొర్నే దీటా బద్రంగా తాసె” బులి యేసు కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ఈనె యేసు యాకిరి కొతలగితల్లాబెల్లె యూదుల సమాజమందిరముకు అదికారిగా తల్లా జొనె అయికిరి, తా అగరె మోకరించికిరి, “మో జో ఉంచినాక మొరిజీసి. ఈనె తూ అయికిరి తో అత్తొ తా ఉంపరె లొగినే సెయ్యె జూసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","సెల్లె యేసు, తా సిస్యునె ఉటికిరి తా పొచ్చాడె జేసె. ");
INSERT INTO rei_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","తంకె జేతల్లాబెల్లె పన్నెండు బొచ్చొరోనెతీకిరి రొగొతొ జబ్బుసంగరె బాద పొడిలా జొనె మొట్ట పొచ్చాడెదీకిరి అయికిరి తా కొన్నా అంచుకు సూగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","సెయ్యె, “మియి తా కొన్నకు సూగిన్నే చాలు మెత్తె బొలైజీవొ” బులి మనసురె బులిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","యేసు పొచ్చాడుకు బులికిరి తాకు దిక్కిరి, మో జ్యో దైర్యంగా రో! తో విస్వాసమాక తొత్తె బొలికొరిసి బులి కొయిసి. సే కొయిలా ఎంట్రాక సెయ్యె బొలైసి. ");
INSERT INTO rei_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","యేసు సే అదికారి గొరొబిత్తురుకు జేతల్లాబెల్లె, సెట్టె బజన కొరిలాలింకె గోల తవ్వురొ దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","తంకె సంగరె, “బాజండి, సే జ్యో మొరిజిల్లాని గుమ్మిలీసి” బులి కొయిసి. తంకె తాకు బచ్చిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","సెయ్యె తంకు పొడదిపీకిరి బిత్తురుకు జేకిరి సే పిల్లరొ అత్తొ సూగిచ్చి సెయ్యె ఎంట్రాక ఉటిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ఏ సంగతి సే ప్రాంతమల్లా తెలిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","యేసు సెట్టెదీకిరి బయలుదేరికిరి జేతల్లాబెల్లె దీలింకె అంకీనె నీలాలింకె, “దావీదురొ పో! అమంపరె దయ దిగదే!” బులి కేకానె పొక్కుంటా తాకు అనుసరించిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","యేసు గొరొ బిత్తురుకు జేతల్లాబెల్లె దీలింకె అంకీనె నీలాలింకె తా పక్కరకు అయిసె. సెయ్యె తంకు సంగరె, “ఎడ మియి కొరిపారిబులి తొమె నమ్మిలీసొనా?” బులి పొచ్చరిసి. “వై ప్రబూ!” బులి తంకె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","సెల్లె సెయ్యె తంకె అంకీనె సూగీకుంటా, “తొముకు కెత్తె విస్వాసం తన్నే సెత్తె పలం మిలుసి” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","తాకు అంకీనె దిగదీసె. యేసు, “ఏ సంగతి కాకు నాతెలిసికుంటా జాగర్త పొడండి” బులి తంకు గట్టిగా కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ఈనె తంకె జేకిరి తా గురించి సే “ప్రాంతమల్లా” సాటిపీసె. ");
INSERT INTO rei_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","తంకె దోరకు జేతల్లాబెల్లె కుండె మనమానె బుత్తొ దరిలా మూగమనమకు యేసు పక్కు కొడిగీకిరి అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","యేసు బుత్తొకు సొడిపించిలా ఎంట్రాక సే మూగమనమ కొతలగివురొ మొదలు దీసి. సెట్టెదీకిరి మనమానల్లా ఆచ్చర్యపొడికిరి, “యెడపనా సంగతి ఉంచినెజాంక ఇస్రాయేలురె కెబ్బే జరిగిలాని”బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ఈనె పరిసయ్యునె, “సెయ్యె బుత్తోన్రొ అదికారి సహాయం సంగరె బుత్తొనుకు సొడిపించిలీసి”బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","యేసు యూదునెరొ సబాస్దలంరె బోదకొరుకుంటా బొట్ట గానె, సన్ని గానె బుల్లికిరి పురువురొ రాజ్యం గురించి సువార్త కొర్లీసి. సొబ్బి రకానె జబ్బూనె, బాదానెకు బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ఈనె యేసు సెట్టె తల్లా మనమానుకు దిక్కిరి, జొగులొతా నీలా గొర్రీనె పనికిరి అలసిజేకిరి, చెదిరిజేకిరి తవ్వురొ దిక్కిరి తంకంపరె జాలిపొడిసి. ");
INSERT INTO rei_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","సే తరవాతరె తా సిస్యునె సంగరె, బిల్లొ బొల్లె పచ్చిసి ఈనె కూర్చితందుకు, పైటిలింకె కుండెలింకె అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ఈనె “యజమానుడుకు ప్రార్దన కొరొండి సెల్లె సెయ్యె బిల్లొ కట్టితె పైటిలింకు పొడదూసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","యేసు తా పన్నెండు మంది సిస్యునెకు డక్కికిరి బుత్తోనుకు సొడిదీతందుకు, సొబ్బిరకానె జబ్బూనెకు, బాదానెకు బొలికొరితె తంకల్లా అదికారం దీసి. ");
INSERT INTO rei_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","సే పన్నెండులింకె అపోస్తులునె బులి నా లొగిసి, సీమోను బుల్లాటకు, పేతురు బులి డక్కితవ్వె. తా బై అంద్రెయ. జెబెదయి పో యాకోబు, తా బయి యోహాను. ");
INSERT INTO rei_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","పిలిప్పు, బర్తొలొమయి, తోమా, పన్నునె వొసులుకొరిలా మత్తయి, అల్పయి పో యాకోబు, తద్దయి. ");
INSERT INTO rei_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","కనానీయుడైలా సీమోను, యేసుకు ద్రోహం కొరిలా యూదా ఇస్కరియోతు. ");
INSERT INTO rei_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","సే పన్నెండు మందికి మనమానె పక్కు పొడిదికుంటా, తంకు యేసు యాకిరి ఆజ్ఞాపించిసి, “యూదునె నీలాలింకు పక్కరకు గాని, సమరయ దెసొరొ పట్టనమునెకు గాని జేతెనాండి” ");
INSERT INTO rei_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","సడకు బదులుగా నసించిజీతల్లా ఇస్రాయేలు మనమానె పక్కు జాండి. తంకె తప్పిజెల్లా గొర్రీనె పనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ఈనె జేకుంటా, “పురువురొ రాజ్యం పక్కరాక అచ్చి” బులి ప్రకటన కొరోండి. ");
INSERT INTO rei_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","జబ్బూనె సంగరె తల్లాలింకు బొలికొరండి. మొరిజిల్లాలింకు ఉడిదేండి, కుస్టురోగీనెకు సుద్ది కొరొండి. బుత్తొనుకు పొడదిపెండి. తొమె సుచ్చరాక పొందిలాట సుచ్చరాక దేండి. ");
INSERT INTO rei_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","సున్న గాని, వెండి గాని, రాగి పలియానె తొమె సొమ్మొసంచినెరె లొగ్గీకిరి జేతెనాండి, ");
INSERT INTO rei_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","తొమె ప్రయానం కొరితల్లాబెల్లె పలియసంచినె గాని, కొన్నానె గాని, జొడానె గాని, అత్తొబడ్డిగాని, తొం పొచ్చాడె యింగుటె కిచ్చి నీజీతెనాండి. పైటి కొరిలాలింకు కూలి మిలుసి నీనా! ");
INSERT INTO rei_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","తొమె కే గాకు జెల్లీసొవో, సే గారె కేసె తొముకు ఇస్టపొడికిరి డక్కిలీసెవొ సే చోటు సడదిల్లా జాంక తా గొరొ బిత్తరాక తాండి. ");
INSERT INTO rei_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","తొమె సే గొరొబిత్తరకు జెల్లాబెల్లె సే గొర్రె సమాదానం కలుగుమాసి బులి కోండి. ");
INSERT INTO rei_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","సే గొరొలింకె యోగ్యులైనే తొం కొయిలా సమాదానం సే గొరొబిత్తరాక కలుగుసి. నీనెమాను సే సమాదానం తొముకాక బుల్లికిరి ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ఈనె ఈనెమాకు, తొముకు కేసె స్వాగతం నాకొయినె సే గొరొకు గాని ఈనె సే గాకు గాని సడిదీకిరి జెల్లా అగరె తొం గొడ్డోన్రొ దుల్లి దులిప్పొండి. ");
INSERT INTO rei_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","యెడ సొత్తాక, తీర్పు తీర్చిలా దినొరె తొమె సడదిల్లా గానెరొ స్దితికన్నా సొదొమ, గొమొర్రా పట్టనమూనె దయ పొందిగివ్వె బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","సునొండి తోడేల్లు మొజుకు గొర్రీనుకు పొడిదిల్లాపనికిరి తొముకు పొడిదిల్లించి. ఈనె సప్పోనె పనికిరి తెలివిగా, పావురాలుపని నిస్కపటంగా తాండి. ");
INSERT INTO rei_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ఈనె, మనమానె విసయంరె జాగర్తగా రోండి. తంకె తొముకు దరిగీకిరి, బందించికిరి పక్కరె తల్లా న్యాయసబకు అప్పగించుసె. తంకె యూదునెరొ సబాస్దలంరె కొరడా మడ్డోనె మరివె. ");
INSERT INTO rei_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","మో వల్లరె తొముకు సాక్సంగా పాలకులు అగురుకు, రొజానె అగురుకు కొనిగిజోసె సెల్లె తంకు, యూదునె నీలాలింకు మో సువార్త ప్రకటించుసొ. ");
INSERT INTO rei_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","తంకె తొముకు అదికారినెకు అప్పగించిలాబెల్లె, కే విదంగా కొతలగిమంచో? కిరకొయిమంచో? బులి చింతించితెనాండి. తొమె కిర కొతాలగిమంచో సే సమయంరె తొముకు తెలియపర్చివొ. ");
INSERT INTO rei_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","కిరుకు బుల్నే కొతాలగిలాట తొమ్మెనీ. తో బోరొ ఆత్మ తొంబిత్తరెదీకిరి కొతలగువొ. ");
INSERT INTO rei_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","అన్నబయి అన్నబయికు, బో పోకు మొర్నుకు అప్పకొయివె. పిల్లానె తంకె మా, బోనుకు ఎదురు బుల్లికిరి తంకు మొరదూసె. ");
INSERT INTO rei_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","మనమానల్లా మో నా కారనంగా తొముకు ద్వేసించివె. ఈనె చివర జాంక సహనం సంగరె తల్లాట రక్సించుబొడివొ. ");
INSERT INTO rei_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","తొముకు గుటె గారె హింసించినె తప్పించిగీకిరి యింగుటె గాకు పొలిజాండి. యెడ సొత్తాక. తొమె ఇస్రాయేలు గానల్లా నాబుల్లిలా అగరాక మనమరొ పో ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“సుక్కిగిల్లా సిస్యునె గురువులుకన్నా గొప్పలింకెనింతె; సాకిరాక పైటికొరిలలింకె యజమానికన్నా గొప్పలింకెనింతె.” ");
INSERT INTO rei_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","సిస్యుడు తా గురువు పనికిరి తమ్మంచి. సాకిరాక పైటికొరిలాలింకె యజమానుడు పనికిరి తన్నే చాలు. గొరొ యజమానికి బయెల్జెబూలు బులి బుల్నే సే గొరొలింకు యింకెత్తో నానె లొగివేయో. ");
INSERT INTO rei_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ఈనె తొమె మనమానుకు డొరితెనాండి. రహస్యమైలాట పొదరెపొడివొ. నుచ్చిదిల్లాట నాతెలిసికుంటారొన్నీ.” ");
INSERT INTO rei_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","మియి రహస్యంగా కొయిలా కొతానె బాహాటంగా పొదరిలింకు కోండి. తొమె కన్నొరె కొయిలా కొతానె గొరొ ఉంపరె ఉటికిరి ప్రకటించొండి . ");
INSERT INTO rei_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","తంకె దేకు మొరదీపారె ఈనె ఆత్మకు మొరదిన్నారె. తంకు గురించి డొరితెనాండి. దేకు, ఆత్మకు నరకంరె పొక్కిరి నాసనం కొరిలా పురువుకు డొరొండి. ");
INSERT INTO rei_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","గుటె పైసాకు దీట పిచ్చుకానె బిక్కుసె. ఈనె తొం “బోకు” నా బుజ్జుకుంటా బూమి ఉంపరె గుట్టంకా పొడ్నీ. ");
INSERT INTO rei_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","తొం ముండొ ఉంపరె తల్లా బల్లోనంకా కెత్తో గొనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","సడకు డొరితెనాండి. బడే పిచ్చుకానె కన్నా తొమె విలువైలలింకె. ");
INSERT INTO rei_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","మెత్తె మనమానె సమక్సంరె వొప్పిగిల్లా ప్రతి మనమా పరలోకంరె రొల్ల మో బో అగరె మియి తాకు వొప్పిగిమ్మి. ");
INSERT INTO rei_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ఈనె మనమానె సమక్సంరె మెత్తె తిరస్కరించిలాలింకు మియి పరలోకంరె రొల్ల మో బో అగరె జన్నీ బులి కొయిమి. ");
INSERT INTO rei_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","మియి బూమింపరకు సాంతికు దన్నైతె అయించి బులిగిత్తెనాండి. కత్తికు దన్నైతె అయించి గాని సాంతికి నీ. ");
INSERT INTO rei_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","కిరుకుబుల్నే మియి, బోనుకు పోనుకు మొజిరె, మానుకు తా జోనుకు మొజిరె, ససుకు బూనెకు మొజిరె, విబేదం లొగితె అయించి. ");
INSERT INTO rei_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","గుటె గొరుకు చెందిలాలింకాక సే గొరొ బిత్తరెలింకు సత్రువూనె ఊసె. ");
INSERT INTO rei_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","తా మా బోకు మో కన్నా ఎక్కువగా ప్రేమించిలా మనమ మెత్తె సిస్యుడు ఈనారి. తా పోకు ఈనన్నా, జోకు ఈనన్నా మోకన్నా ఎక్కువగా ప్రేమించిలాట మెత్తె సిస్యుడు ఈని. ");
INSERT INTO rei_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","మెత్తె వెంబడించిలా మనమ మో సిలువకు బొయికిరి మెత్తె నాఅనుసరించినె మో సిస్యునె యీతె యోగ్యునె ఈనింతె. ");
INSERT INTO rei_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","పొర్నొకు కాపాడిగిల్లా మనమ సడకు వొరదీగివ్వొ. ఈనె మో కోసం జీకకు వొరదీగిల్లా మనమ సడకు సంపాదించిగునుసి. ");
INSERT INTO rei_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","తొముకు అంగీకరించిలలింకె మెత్తె అంగీకరించుసె. మెత్తె అంగీకరించిలలింకె మెత్తె పొడిదిల్లాటకు అంగీకరించిలపనాక. ");
INSERT INTO rei_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","జొనె మనమ ప్రవక్త ఈలందుకు తాకు చేర్చిగిల్లా మనమకు సే ప్రవక్త పొందిలా పలం పొందుసి. ఈనె జొనె మనమ నీతిమంతుడు ఈలందుకు తాకు చేర్చిగిల్లా మనమ నీతిమంతుడు పొందిలా పలం పొందుసి. ");
INSERT INTO rei_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","తొమె మో సిస్యునె యీలందుకు, తంకు కేసె గుటె గిన్నె పని దూసెవో తంకు ప్రతిపలం మిలుసి బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","యేసు తా పన్నెండు మంది సిస్యునెకు తంకె కొరివలిసిలా పైటీనె గురించి కొయికిరి, సే తరవాతరె సెయ్యె సెట్టి దీకిరి బయిలుదేరికిరి బోదించుకుంటా ప్రకటించుకుంటా సుట్టూ తల్లా బడే గానెకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","చెరసాలరె తల్లా యోహాను క్రీస్తు కొరిలా పైటీనె గురించి సునిసి. సెయ్యె కుండిలింకె సిస్యునెకు యేసు పక్కరకు పొడిదీసి. ");
INSERT INTO rei_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","తంకె జేకిరి, యోహాను “ఆసి బులి కొయిలాట తువ్వాకనా? నీనే యింకాజొనె కోసం అమె ఎదురు దిగిమంచినా?” అం సంగరె కోబులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","సడకు యేసు తంకె సంగరె యాకిరి కొయిసి. “తొమె జేకిరి సునిలాంచకు, దిగిలాంచకు, యోహానుకు కోండి. ");
INSERT INTO rei_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","అంకీనె నిలాలింకె దిగిలీసె, నాసల్లాలింకె సలిపార్లీసె, కుస్టురోగీనె బొలైలీసె, కల్లొలింకె సునిపారిలీసె, మొరిజిల్లాలింకె జీకిరి అయిలీసె, సువార్త పేదలింకు ప్రకటించిబొడిలీసి. ");
INSERT INTO rei_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","మో విసయంరె అబ్యంతరం నాపొడిలాట దన్యుడు.” ");
INSERT INTO rei_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","యోహాను సిస్యునె జేతల్లాబెల్లె, యేసు యోహాను గురించి సెట్టె తల్లా మనమానె సంగరె యాకిరి కొతాలగివురొ మొదలు దీసి, పొరొతొ ప్రాంతంరె కిర దిగిమంచి బులి జేసొ? బాకు పిట్టిగిల్లా గసొకు దిగిమంచి బులి జెల్లీసోనా? ");
INSERT INTO rei_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ఈనె కిర దిగిమంచి బులి జేసొ? విలువైల కొన్నానె పిందిగిల్ల మనమకు దిగిమాబులి జేసోనా? విలువైలా కొన్నానె పిందిగిల్లలింకె రొజా బవనాల్రె తాసె. ");
INSERT INTO rei_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ఈనె, కిర దిగిమంచి బులి జెసో? ప్రవక్తకునా? తొమె దిగిలాట ప్రవక్త కన్నా గొప్పీట బులి మీ కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","తా గురించి యాకిరి రాసికిరి అచ్చి తో కన్నా అగరె మో సలాదికు పొడదూంచి, సెయ్యె తో కన్నా అగరె జేకిరి తో బట్టొ సిద్దం కొరుసి. ");
INSERT INTO rei_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","తిల్డ్రంటకు జొర్నైలాలింకె బిత్తరె బాప్టీసం దిల్లా యోహాను కన్నా గొప్పీట జొన్నన్నా నీబులి తొం సంగరె కచ్చితంగా కొయిలించి. ఈనన్నా పురువురొ రాజ్యంరె తగ్గించిగిల్లాట యోహాను కన్నా గొప్పీట ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","బాప్టీసం దిల్లా యోహాను కలొనె దీకిరి, ఎత్తె జాంక పురువురొ రాజ్యం బలవంతంగా ఆక్రమించిగిల్లీసె. ఈనె బలం తల్లాలింకె సడ బిత్తురుకు అయిలీసె. ");
INSERT INTO rei_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","యోహాను కలోజాంక ప్రవక్తనె, మోసే దర్మసాస్త్రము పురువురొ రాజ్యం గురించి కొయికుంటా అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","తంకె కొయిలాట విస్వసించినె, యోహానుకు అయితల్లా ఏలీయా బులి తొముకు కొయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","సునితె కన్నోనె తల్లాలింకె సునొండి. ");
INSERT INTO rei_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ఉంచినె “ఏ తరంలింకు కిడసంగరె పోల్చిమంచి? తంకె సొంత సెయీన్రె బొసికిరి గట్టిగా కొతానె లగ్గిత్తల్లా పిల్లానె సంగరె సమానంగా అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘అమె పిల్లనగ్రోవి పుంకినన్నా; సాకిరాక తొమె నచ్చిలీనింతో, అమె విసాదమైలా గిత్తొ గయినన్నా, తొమె దుక్కించిలానింతొ.’ ");
INSERT INTO rei_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","కిరుకుబుల్నే యోహాను కయికిరి, పీకిరి అయిలానీ. ఈనె సొబ్బిలింకె తాకు బుత్తొ దరిగిచ్చి బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","మనమరొ పో కైకుంట, పీకుంటా అయిసి. ఈనె సొబ్బిలింకె,‘ఎయ్యె కద్దికారి, పీకారి ఈనె పన్నునె వొసూలు కొరిలాలింకు, పాపోనెకు జట్టుకారి’ బులి కొయిసె. పురువురొ జ్ఞానం సే పైటీనె వల్లరె తీర్పు పొందువొ బులిసి.” ");
INSERT INTO rei_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ఈనె బడే అద్బుతానె కొరినెను కుండె గానెరె మారుమనుసు పొందిలానింతె. ఈనె యేసు సడకు విమర్సించిసి. ");
INSERT INTO rei_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","అయ్యో! కొరాజీనా! అయ్యో! బేత్సయిదా పట్టనమూనె! తొముకు బడే స్రమ. మియి తొం బిత్తరె కొరిలా అద్బుతానె తూరు, సీదోను గాన్రె కొరికిరి తన్నే తంకె కెబ్బో పాపోనె సడిదీకిరి గోనిసంచి, పోసొ మక్కిగీకిరి, మారుమనుసు పొందిగీకిరి తైతవ్వె. ");
INSERT INTO rei_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ఈనె మియి కొయిలాట కిర బుల్నే తీర్పు కొయిలా దినొరె తూర్పు, సీదోను పట్టనమూనె మనమానె తొం కన్నా దయపొందిలా స్దితిరె తాసె. ");
INSERT INTO rei_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“ఈనె, ఓ కపెర్నహూము బుల్లా గా! తువ్వు మెగొకు ఉడిజెమ్మా బులిగిల్లునా? సాకిరి జరిగినీ! తువ్వు పాతాలలోకం బిత్తరె పొడిజెవ్వు. తో బిత్తరె కొరిలా మహాత్యాలు సొదొమ నగరంరె కొరికిరి తన్నే సడ ఉంచినె మిగిలికిరి రొయిత. ");
INSERT INTO rei_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ఈనె మియి తొముకు కొయిలాట కిరబుల్నే తీర్పు కొయిలా దినొ సొదొమ పట్నం కన్నా తొమె నాబరించిలా స్దితిరె తాసొ.” ");
INSERT INTO rei_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","సే సమయంరె యేసు యాకిరి బులిసి, “బో” మెగొకు బూమికి ప్రబువైలా తొత్తె స్తుతించిలించి. కిరకుబుల్నే, తువ్వు సడకు తెలివిగల్లాలింకు, తెలివిలింకె మరుగుకొరికిరి పామరులుకు తెలిసిలా పనికిరి కొరిసు. ");
INSERT INTO rei_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","వై బో! తువ్వు యాకిరి కొరువురొ తొత్తె బడే ఇస్టం. ");
INSERT INTO rei_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","మో బో మెత్తె సొబ్బి అప్పగించిసి. బోకు తప్ప పో గురించి కాకు తెలిసిని. పోకు తప్ప బో కేసొ కాకు తెలిసిని. పో బచ్చిగిల్లాటకు సొబ్బి తెలియపర్చుసి. ");
INSERT INTO rei_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","బారం బొయిగీకిరి అలసిజిల్లాలింకల్లా మో పక్కరకు అయిండి. మియి తొముకు విస్రాంతి దూంచి. ");
INSERT INTO rei_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","మీ దిల్లా కాడికు బొయిగీకిరి, సడకు దిక్కిరి సుగ్గీండి. ఈనె మియి సాత్వికుడు, దీన మనుసు గల్లాట. సడకు తొం ఆత్మకు విస్రాంతి మిలుసి. ");
INSERT INTO rei_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ఈనె మియి దిల్లా కాడికు బొయివురొ సులువుగా, మియి దిల్లా బారం తేలిగ్గా తాసి. ");
INSERT INTO rei_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","గుటె విస్రాంతి దిన్రె యేసు, తా సిస్యునె సంగరె మిసికిరి బిల్లోన్రె సలికుంటా జెల్లీసి. తా సిస్యునె బొక్కొ సంగరె రొల్లందరె ఎన్నూనె చిండిగీకిరి కయివురొ మొదలు కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","పరిసయ్యునె ఎడ దిక్కిరి యేసు సంగరె, దిగూ “విస్రాంతి దినొరె తో సిస్యునె నాకొరివలిసిలాపైటి కొరిలీసె” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","సెత్తెలె యేసు తంకసంగరె యాకిరి కొయిసి. దావీదుకు తా అనుచరూనెకు బొక్కిలాబెల్లె కిరకొరిసో తొముకు తెలిసినీనా? ");
INSERT INTO rei_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","సెయ్యె పురువురొ మందిరముకు జేకిరి యాజకులాక తప్ప సెయ్యన్నా తా సంగరె తల్లాలింకైనన్నా నాకైవలిసిలాంచ పురువుకు అర్పించిలా సముకపు రొట్టీనె సెయ్యె తా అనుచరూనె కైసె. ");
INSERT INTO rei_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","సెత్తాకనీ, గుడిరొ యాజకూనె విస్రాంతి దిన్రె పైటి కొరిసేబుల్లా వియం దర్మసాస్త్రంరె అచ్చి. సడ తంకె సాకిరి కొరికిరి దర్మసాస్త్రంకు తప్పిజిల్లీసె ఈనన్నా తూ తంకు తప్పు నాదర్నే తప్పాకనీనా. బులి దర్మసాస్త్రంరె రాసికిరి అచ్చినీనా? ");
INSERT INTO rei_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","మియి కొయిలాట కిరబుల్నే మందిరం కన్నా గొప్పమనమా ఎట్టె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ఈనె మీ కనికరముకాక కోరిలించి గాని బలి కోరిలాట నీ బుల్లా వాక్యంరొ అర్దం తొముకు తెలిసికిరి తన్నే తొమె నిర్దోసునెకు తీర్పు తీర్చినారొ. ");
INSERT INTO rei_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ఈనె “విస్రాంతి దినొకు మనమరొ పో ప్రబువు ఈకిరి అచ్చి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ఈనె సెయ్యె సెట్టెతీకిరి బయలుదేరికిరి యూదునెరొ ఆరాదన చోటుకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","సెట్టె అత్తొ పొడిజిల్లా మనమ జొనె అచ్చి. తంకె యేసు ఉంపరె తప్పు మోపుమాసి బులి ఎదురుదిగితల్లా పరిసయ్యునె, తాకు, “విస్రాంతి దినొరె బొలికొరువురొ న్యాయమాకనా?” బులి తాకు పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","సడకు యేసు, “తొం బిత్తరె కే మనమకైనన్నా, గుటె గొర్రితన్నే సడ విస్రాంతి దినొరె గత్తొరె పొడిజిన్నే సడకు దరిగీకిరి తొమె ఉంపురుకు జింకినింతొనా? ");
INSERT INTO rei_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ఈనె మనమ గొర్రికన్నా బడే రెట్లునె విలువైలాట నీనా? సడకు విస్రాంతి దినొరె బొలికొరువురొ‌ దర్మమాకనీనా” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","సాకిరి సే అత్తొ పొడిజిల్లా మనమ దీకిరి, “తో అత్తొ చాపు బులిసి.” సెయ్యె అత్తొ సాపిసి. అత్తొ పుర్తిగా బొలైజీకిరి దీటో అత్తొ పనికిరి ఈసి. ");
INSERT INTO rei_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ఈనె పరిసయ్యునె దోరకు జేకిరి, యేసుకు మొరదీతె పన్నాగం పన్నిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ఈనె యేసు సే సంగతి తెలిసిగీకిరి సెట్టిదీకిరి బాజేసి. బడేలింకె పురువు పొచ్చాడె జేసె. పురువు జబ్బూనె దీకిరి రొల్లలింకల్లా బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","సెయ్యె తా గురించి కాకు కొయితెనా బులి తంకు ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","యెసయా ప్రవక్త సంగరె పురువు కొయిలా యే కొతానె సొత్తయిలాపనికిరి యే విదంగా జరిగిసి, ");
INSERT INTO rei_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","సెయ్యె మో సేవకుడు! తాకు మీ బచ్చిగించి. తా ఉంపరె మెత్తె యిస్టమచ్చి సెయ్యె మో ఆత్మకు బడే ఆనందం కలిగించిసి. మో ఆత్మ తా ఉంపరకు అయిపించుంచి. సెయ్యె యూదునె నీలాలింకు న్యాయం కొరిపారి బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","సెయ్యె కొలి లగినీ, కేకానె పొగినీ, సెయీన్రె తా దొందరానె కాకు సుందిన్నీ. ");
INSERT INTO rei_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","న్యాయం కొరిలా జాంక నలిగిజిల్లా రెల్లుకు సెయ్యె బంగిని. నుగిజీతల్లా బొత్తి సెయ్యె నుగిదిన్ని. ");
INSERT INTO rei_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","తా నారె యూదునె నీలాలింకు నిరీక్సన కలుగుసి. ");
INSERT INTO rei_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","సే తరవాతరె కుండెలింకె, బుత్తొ దరిలా గుడ్డి మోపొకు, కొతానె నాఅయికుంటతల్లా జొనెకు యేసు పక్కరకు డక్కిగీకిరి అయిసె. యేసు తాకు బొలికొరిసి. సే కొతానె నాఅయిల మోపొకు కొతా, అంకీనె అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","మనమానల్లా యెడ దిక్కిరి ఆచ్చర్యపొడికిరి “ఎయ్యె దావీదు పో ఈకిరి తాసి” బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","పరిసయ్యునె యెడ సునుకిరి, “బుత్తోనె అదికారి బయెల్జెబూలు సహయం దీకిరి ఎయ్యె బుత్తోనుకు సొడిపించిలీసి” బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","తంకె ఆలోచనానె యేసుకు బుజ్జికిరి. తంకు సంగరె యాకిరి కొయిసి. తాకు సెయ్యాక, విరోదంగా తల్లా రాజ్యం నసించిజెవ్వొ. తాకు విరోదంగా తల్లా కే పట్నం ఈనన్నా, గొరొ ఈనన్నా కూలిజోసి. ");
INSERT INTO rei_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","సాతాను సాతానుకు గొడ్డదిన్నె సెయ్యె టారినారి. సెల్లె తా రాజ్యం క్యాకిరి టారుసి? ");
INSERT INTO rei_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","మియి బయెల్జెబూలు దీకిరి బుత్తోనుకు సొడిపించినె తొంలింకె కావల్లరె సొడిపించిలీసే? ఈనె తంకాక తొముకు తీర్పు తీర్చుసె. ");
INSERT INTO rei_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","బయెల్జేబూలునీ ఈనె మియి పురువురొ ఆత్మ దీకిరి బుత్తోనుకు పొడిదిన్నే పురువురొ రాజ్యం తొముకు అయిలాపనాక! ");
INSERT INTO rei_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","సాకిరాక అగరె బలం తల్లా మనమకు నాబందికుంటా తా గొరొబిత్తరకు జేకిరి తా వస్తువూనె కేసే చొరినారె. సే బలం తల్లా మనమకు బందిలా తరవాతరాక గొరొకు చొరిపారె. ");
INSERT INTO rei_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","మో సంగరె నాతల్లా మనమ మెత్తె విరోదంగా తాసి. మో సంగరె మిసికిరి నాతల్లా మనమ చెదిరిజోసి. ");
INSERT INTO rei_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","సడకు మీ కొయిలాట కిరబుల్నె మనమ కొరిలా పాపోనె సొబ్బిటికు, దేవదూసనకు పురువు క్సమించుసి. ఈనె పురువురొ ఆత్మకు వ్యతిరేకమైలా దూసనకు క్సమాపన మిల్నీ. ");
INSERT INTO rei_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","మనమరొ పోకు దూసించికిరి కొతలగిలాలింకు పురువు క్సమించుసి. ఈనె పవిత్రాత్మకు దూసించికిరి కొతాలగిలాలింకు ఉంచినె యింకెబ్బుకూ క్సమించిని. ");
INSERT INTO rei_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“తొముకు బొల్ట పొగలానె కావాలబులిగిన్నే, గొచ్చుకు బొల్లైకిరి కొరుమంచి. తో గొచ్చొ బొల్ట నీనే సడకు బొల్ట పొగలానె కాసిని. గొచ్చొకు సడరొ పొగలానె వల్లరె గుర్తించిమాసి. ");
INSERT INTO rei_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","తొమె సప్పొపనాలింకె. దుస్టులు బొల్ట కొతానె క్యాకిరి కొయిపారొ. హ్రుదయం బిత్తరె రొల్లాటాక తుండొ కొతాలగుసి. ");
INSERT INTO rei_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","బొల్ట మనమరె బొల్ట తాసి. సాకిరాక తా బిత్తరె దీకిరి బొల్ట బయలుకు ఆసి. దుస్టుడురె చెడు తాసి గనక తా దీకిరి చెడు బయలుకు ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ఈనె మియ్యి కొయిలాట కిరబుల్నే మనమానె పలికిలా సొబ్బి వ్యర్దమైలా కొతకు తీర్పు కొయిల దినొ లెక్క కొయివురొ ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","కిరుకుబుల్నే తో కొతానె వల్లరాక తొమె నిరపరాదులువొ, అపరాదులువొ తీర్పు పొందుసు” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","సే తరవాతరె కుండిలింకె సాస్త్రీనె, పరిసయ్యునె తా సంగరె, “బోదకా! తువ్వు గుటె అద్బుత కార్యము కొరిమంచి బులి పొచ్చిరిసె.” ");
INSERT INTO rei_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ఈనె ఉంచినె దుస్టులు, పురువుకు నా జనిలాలింకె తాకు అద్బుతం కొరుబులి పొచ్చరిసె. యోనా ప్రవక్త కోసం దిగదిల్లా అద్బుతం తప్ప యింకా కే అద్బుతం తొముకు దిగదిన్నీ బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","కిరుకుబుల్నే, యోనా బొట్ట మచ్చొ పెట్టొరె తింట రత్తి దూసునె గడిపిసి. సాకిరాక మనమరొ పో తింట రత్తి దూసునె బూగర్బంరె తాసి. ");
INSERT INTO rei_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","నీనెవె మనమానె యోనా కొయిలా చాటింపు సునికిరి మనుసు మార్చిగిచ్చె గనక తీర్పు కొయితల్లా దినె తంకె ఏ తరంలింకు సంగరె సహా టారికిరి ఏ తరంలింకె నేరస్తులుబులి నిర్నయించిసె. గాని ఉంచినె యోనా కన్నా గొప్పమనమ ఎట్టె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","దక్సిన దిక్కురె తల్లా సీబా దెసో రాని సొలొమోను జ్ఞానముకు దిగిమంచి బులికిరి బడే దూరు దీకిరి అయిసి. ఈనె తీర్పు కొయిల దినొ సెయ్యె పొదరెలింకె వుంపరె నేరం మోపిలీసి. ఈనె ఉంచినె సొలొమోను కన్నా బొట్ట మనమ ఎట్టె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“అపవిత్రాత్మ జొనె మనమకు సడికిరి బాజెల్లా తరవాతరె సడ విస్రాంతి కోసం కుజ్జిగీకుంటా పనినీలాచోటురె బుల్లిలీసి. ఈనె సడకు విస్రాంతి మిల్లాని. ");
INSERT INTO rei_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","సెల్లె ‘మియి సడికిరి బారైలా మో గొరుకు యింకా బుల్లికిరి జోంచి’ బులి కొయిగిచ్చి. సడ బుల్లికిరి అయికిరి, సే గొర్రె కేసే నీవురొ సొబ్బి జడికిరి తల్లాట దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","సెల్లె సడ జేకిరి తాకన్నా, దుస్టులైలా సత్ర బుత్తొనుకు డక్కిగీకిరి అయిలీసి. సొబ్బీ మిసికిరి సే గొరొబిత్తరకు జేకిరి రొయితె అయిసి. సెల్లె సే మనమ గతి అగరెకన్నా బడే అద్దానంగా తాసి. ఏ నాబొల్టైలా తరంలింకు సాకిరాక తాసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","యేసు మనమానె సంగరె యింకా కొతలక్కుంటా అచ్చి. సెల్లె తంక మా, అన్నబయినె తా సంగరె కొతలగిమంచి బులి అయికిరి బయిల్రె టారిసె. ");
INSERT INTO rei_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","జొనె మనమ యేసు సంగరె, తో మా, అన్నబయినె తో సంగరె కొతలగిమంచి బులి బయిల్రె టారికిరి అచ్చె! బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","యేసు సమాదానం కొయికుంటా, “కేసె మో మా? కేసె మో అన్నబయినె?” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","తా సిస్యునె ఆడుకు దిగిదీకుంటా, “ఇదిగొ మో మా, ఇదిగొ మో అన్నబయినె బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","కేసె పరలోకంరె తల్లా మో బోరొ ఇస్టంరె సలివేయో సెయ్యాక, మో మా సెయ్యాక మో అన్నబయి మో అప్పబొయిని” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","సే దిన్రె యేసు గొరొ దీకిరి జేకిరి సోంద్రొ ఒడ్డురె బొసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","తాచుట్టూ బడే మనమానె గుంపు కూడికిరి అచ్చె. సడకు సెయ్యె బోదకొరితె పడవ ఉటికిరి బొసిరిసి. మనమానె సొంద్రొ ఒడ్డురె టారికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","సెయ్యె తంకు బడే విసయోనె ఉపమానాలు పనికిరి బోదించిసి. జొనె రైతు విత్తనాలు జల్లితె జేసి. ");
INSERT INTO rei_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","సెయ్యె విత్తనాలు జల్లిలాబెల్లె కుండె విత్తనాలు బట్టొ పక్కరె పొడిసె. పక్సినె అయికిరి సడకు కైపీసె. ");
INSERT INTO rei_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ఈనె కుండె విత్తనాలు మట్టి బూతునీలా పొత్రొ బూమి ఉంపరె పొడిసె. సెట్టె మట్టి నీలందరె సెరోనె బిత్తురుకు నాటిలానీ. ");
INSERT INTO rei_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ఈనె సూర్యోదయం యీలా తరవాతరె సే మొక్కానె వాడిజీసె. సడ సెరోనె నాబొడిలందరె ఎంట్రాక సుక్కిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ఈనె కుండె విత్తనాలు కొంటానె తుప్పానె మొజిరె పొడిసె. యే కొంటానె తుప్పానె బొడికిరి మొలకలుకు అనిసిపేసె. ");
INSERT INTO rei_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ఈనె కుండె విత్తనాలు సారవంతమైలా మట్టి ఉంపరె పొడిసె. సడబిత్తరె కుండె సోయి వొంతూనె పచ్చిసి, కుండె అరవై వొంతూనె పచ్చిసి, కుండె ముప్పై వొంతూనె పచ్చిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","సునితె కన్నోనె తల్లాలింకె సునుసె! యేసు బోద కొరితె ఉపమానాలు ఉపయోగించిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","సిస్యునె అయికిరి యేసుకు, “తువ్వు మనమానె సంగరె ఉపమానాలు ఉపయోగించికిరి కిరుకు కొతలగిలీసు?” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","సెయ్యె యాకిరి సమాదానం కొయిసి, పురువు రాజ్యంరొ రహస్యంకు తెలిసిగిల్లా జ్ఞానం తొముకు దీసి. ఈనె తంకు దిల్లాని. ");
INSERT INTO rei_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ఈనె కాకు బూతు దీసో తాకు ఇంకా బూతు దూసి. నీలాలింకె పక్కరె దీకిరి తల్లాటంకా కడిగునుసి. ");
INSERT INTO rei_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","మియి తంకె సంగరె ఉపమానాలు దీకిరి కిరుకు కొతాలగిలించి బుల్నే, తంకె దిగిలాలింకె పనికిరి అచ్చెగాని దిగినింతె. సునిలా పనికిరి తాసె గని అర్దం కొరిగిన్నింతె, గ్రహించినింతె. ");
INSERT INTO rei_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","సాకిరాక యెసయా ప్రవక్త యంకోసం కొయిలా ప్రవచనం కొతానె సొత్తాక ఊసి, అంకె తప్పకుంటా సునుసె, ఈనె అర్దం కొరిగిన్నింతె. తంకె తప్పక దిగుసె ఈనె గ్రహించినింతె. ");
INSERT INTO rei_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","తంకె అంకీనెదీకిరి దిక్కిరి, కన్నోనెదీకిరి సునికిరి, హ్రుదయం సంగరె అర్దం కొరిగీకిరి మో ఆడుకు బుల్లినె మియి తంకు బొలుకొరిమి. ఈనె సాకిరి జరిగినాసి బులి యే మనమానె హ్రుదయమునె కటినము యీలందరె తంకు బొల్లకిరి సుందిన్నీ తంకు తంకె అంకీనె బుజ్జిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ఈనె తొం అంకీనె దిగిపారిలీసె సడానె దన్యమైలాంచ. తొం కన్నోనె సునుపార్లీసె సడానె దన్యమైలాంచ. ");
INSERT INTO rei_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ఎడ సొత్తాక కొయిలించి. కుండెలింకె ప్రవక్తానె, నీతిమంతునె తొమె దిగిలాంచ దిగిమంచిబులికిరి ఆసపొడిసె. ఈనె దిగినారిసె. తొమె సునిలాంచ సునిమ బులికిరి ఆసపొడిసె. ఈనె సున్నారిసె. ");
INSERT INTO rei_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ఈనె విత్తనాలు జల్లిలా రైతు ఉపమానం కోసం బోదించిలీసి. ");
INSERT INTO rei_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","కుండిలింకె పురువురొ రాజ్యం కోసం సునిసె. ఈనె అర్దం కొరిగిన్నింతె. సాట హ్రుదయం బిత్తరె నాటిజెల్లా దైవ సందేసంకు దుస్టుడు అయికిరి దరిగీకిరి బాజోసి. యంకు బట్టొ పొక్కరె పొడిలా విత్తోనె సంగరె పొల్చుగివొచ్చు. ");
INSERT INTO rei_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","దైవ సందేసంకు సునికిరి ఎంట్రాక ఆనందం సంగరె అంగీకరించుసె. పొత్రొ మట్టి ఉంపరె పొడిలా విత్తోనె సంగరె పొల్చువొచ్చు. ");
INSERT INTO rei_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","సడ సెరోనె బిత్తరకు నాజెవురొ వల్లరె సందేసం కెత్తోకలొ జీని కొస్టోనె కాని హింసానె కాని అయిలబెల్లె తంకె ఎంట్రాక సడకు సడిదిపీవె. ");
INSERT INTO rei_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","దైవ సందేసముకు సునికీరి జీవితంరె కొస్టొనుకు, పలియ వల్లరె కలిగిలా మోసంకు నిస్సహాయులైజీకిరి యింకెబ్బుకూ, తంకు కొంటానె మొక్కలరె పొడిలా విత్తనాలు సంగరె పోల్చువొచ్చు. ");
INSERT INTO rei_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ఈనె దైవ సందేసముకు సునికిరి సడకు అర్దం కొరిగిల్లాలింకు బొల్టబూమిరె పొడిలా విత్తనాలు సంగరె పొల్చువొచ్చు. తాండ్రె కుండె సోయి వొంతూనె పలించివె, కుండె అరవై వొంతూనె పనికిరి కుండెలింకె ముప్పై వొంతూనె పలించుసె. ");
INSERT INTO rei_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","యేసు తంకు యింగుటె ఉపమానం కొయిసి, పురువురొ రాజ్యంకు బొల్ట విత్తోనె బిల్లొరె నాటిల మనమ సంగరె పోల్చువొచ్చు. ");
INSERT INTO rei_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ఈనె గుటె రత్తిరె తావుంపరె నాపొడిలాలింకె అయికిరి గోదుము విత్తనాలు మొజిరె కలుపు విత్తోనె జల్లిపీకిరి బాజీసె. ");
INSERT INTO rei_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","గోదుములు బొడిలాబెల్లె సడసంగరె పాటు గసొ మొక్కానె కూడా దిగదీసి. ");
INSERT INTO rei_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","సెల్లె పైటిలింకె, తంకె బొడొమనమానె పక్కు అయికిరి బో! తో బిల్లోరె బొల్ట విత్తోనె నాటిసునీనా; ఈనె కలుపు మొక్కానె క్యాకిరి బొడిసె? బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","యెడ నాపొడిలాలింకె కొరిలా పైటి బులి సే యజమాని సమాదానం కొయిసి. అమె జేకిరి సడకు జింకికిరి పోదిమ్మోనా బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","సడకు సెయ్యె నా! ఉంచినె తొమె కలుపు మొక్కానె కడినె గోదుమ మొక్కానె కూడా జింకిపొక్కదిల్లా అవకాసం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ఈనె కట్టిలాకలొ అయిలా జాంక దీటాకూడా బొడిమురోండి. సెల్లె మియి కట్టిలాలింకె సంగరె, అగరె కలుపు మొక్కానె కట్టికిరి, పుడ్డిపీతె సడకు బిడ్డానె పని బందండి. సే తర్వాతరె గోదుమ గింజలుకు పోగుకొరికిరి మో దన్నొకొట్టురె రొయిదేండి బులి కట్టిలాలింకె సంగరె కొయిమి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","సెయ్యె తంకు యింగుటె ఉపమానం కొయిసి, పురువు రాజ్యంకు గుటె ఆవగింజ సంగరె పోల్చువొచ్చు. జొనె మనమ గుటె ఆవగింజ విత్తో తా తొటరె నాటిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","సడ విత్తోనె సొబ్బిటికన్న సన్నీట, బొడిలాబెల్లె మొక్కానె సొబ్బిటికన్న బొట్టగా బొడికిరి గుటె గొచ్చొవూసి. పక్సినె సే కొమ్మానె ఉంపరె గూడినె బందిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","యేసు తంకు యింగుటె ఉపమానం కొయిసి, “పురువు రాజ్యం పులిసిజెల్లా పిండిపనాట. జొనె మొట్ట పులిసిలాట కుండెపిండి కడిగీకిరి బడే పిండిరె మిసిలాబెల్లె సే పిండల్లా పుల్లగా యీజేసి.” ");
INSERT INTO rei_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","యేసు మనమానెకు సొబ్బి సంగతీనె ఉపమానాలు సంగరాక కొయిసి. ఉపమానం నీకుంటా తంకు కిచ్చీ కొయిలాని. ");
INSERT INTO rei_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","సడకు ప్రవక్త సంగరె సెయ్యె కొయిల కొతానె సొత్తాక ఊసి, “మియి ఉపమానాలు సంగరె కొతాలక్కిరి, లొకొ ఆరంబంతీకిరి నుచ్చిలా సొబ్బీ కొయించి. ");
INSERT INTO rei_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","సె తరవాతరె సెయ్యె మనమానుకు సడదీకిరి గొరొబిత్తరకు జేసి. సెయ్యె సిస్యునె అయికిరి తా బిల్లొరె కలుపు మొక్కానె ఉపమానం గురించి అముకు వివరంగా కోండి” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","యేసు యాకిరి సమాదానం కొయిసి, బొల్ట విత్తోనె నాటితల్లా మోపో మనమరొ పో. ");
INSERT INTO rei_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ఏ లొకొ బిల్లొ సంగరె పోల్చిసి. బొల్ట విత్తోనె పురువు రాజ్యంరె తల్లా మనమానెదీకిరి పొల్చువురొ ఈసి. బిల్లొరె కలుపు మొక్కానె దుస్టుడు సంబందూనె సంగరె పొల్చుసి. ");
INSERT INTO rei_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","సడకు నాటిల సత్రువు సాతాను సంగరె పొల్చిసె. కట్టిలాకలొ యుగాంతం సంగరె పోల్చిసె. కట్టిలాలింకె దేవదూతనె సంగరె పొల్చువురొ ఈసి. ");
INSERT INTO rei_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","కలుపు మొక్కానెకు జింకిపీకిరి నియ్యరె పొక్కిరి పుడ్డిలాపనికిరాక యుగాంతంరె కూడా సాకిరాక ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","మనమరొ పో తా దూతానెకు పొడిదీకిరి, తా రాజ్యంరె తల్లా పాపోనెకు, సెడ్డపైటీనె కొరిపించిలాలింకు పోగు కొరుసి. సాకిరి పొగుకొరికిరి ");
INSERT INTO rei_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","తంకు నియ్యగుండంరె పోదూసె. సెట్టె తంకె కందికుంట దంతోనె కముడుకుంటా బాద అనుబవించుసె. ");
INSERT INTO rei_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","సే తరవాతరె నీతిమంతునె తంకె బోరొ రాజ్యంరె సూర్యుడు పనికిరి ప్రకాసించుసె. కన్నోనె రొయికిరి సున్లాలింకె అర్దం కొరుగుచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","పురువు రాజ్యం బిల్లొరె నుచ్చిదిల్లా నిది పనాట. గుటె మనమ సే నిదికి కనిగిచ్చి. ఈనె వెంట్రాక సడకు నుచ్చిదీసి. సే తరవాతరె ఆనందంగా జేకిరి తా పక్కరె రొల్లాంచ సొబ్బీ బిక్కిపేకిరి సే బిల్లొకు గినిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","పురువురొ రాజ్యం బొల్ట ముచ్యాలు గురించి కుజ్జిల మనమ పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","జొనె బిక్కిగిల్లాట బొల్ట విలువైలా గుట్టె ముత్యం కనిగిసి. సె తరవాతరె జేకిరి తా పక్కరె రొల్లాటల్లా బిక్కిపేకిరి సడకు గినిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ఈనె “పురువురొ రాజ్యం సోంద్రొ బిత్తరె పొక్కిరి సొబ్బి రకాలు మచ్చొనె దరిలా గుటె వలకు పోలికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","వల మచ్చొనెదీకిరి పూరిజెల్లాబెల్లె మచ్చరిలింకె సడకు ఒడ్డుకు జింకికిరి బొల్ట మచ్చోనుకు బుట్టిరె పొక్కిరి నాపైటికైయిలా మచ్చోనుకు బిసురుదూసె. ");
INSERT INTO rei_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","సాకిరాక యుగాంతంరంకా దేవదూతనె అయికిరి బొల్టలింకె దీకిరి చెడ్డలింకు వేరుకొరుసి. ");
INSERT INTO rei_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ఈనె నానుగిజిల్లా నియ్యగుండమురె పోదుసే. తంకె దుక్కొపొడుసె, బాదకు అనుబవించుసె, దంతోనె కముడుసె.” ");
INSERT INTO rei_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“తొముకు సే సొబ్బీ అర్దమైసినా?” బులి యేసు పొచ్చరిసి. తంకె వై బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","సడుకు సెయ్యె తంకసంగరె, “పురువురో రాజ్యం గురించి ఉపదేసం పొందిలా ప్రతీ దర్మసాస్త్ర పండితుడు తా కజానా తీకిరి జొనెమోపొ పుర్నాంచకు, నోంచకు పొదురుకు దన్నైలా గొరొయజమాని పనికిరి అచ్చి” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","యేసు ఏ ఉపమానాలు కొయిలా తరవాతరె, సే చోటు సడికిరి బాజేసి. ");
INSERT INTO rei_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","సెయ్యె తా సొంత గాకు అయిసి. సెట్టె యూదునెరొ ఆరాదన చోటురె బోదించువురొ మొదలు దీసి. తంకె సే బోదానె సునికిరి బడే ఆచ్చర్యపొడికిరి, యే జ్ఞానం, యే అద్బుతానె యెడల్లా యాకు కేటెదీకిరి అయిసె? ");
INSERT INTO rei_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","యెయ్యె వడ్రంగిరొ పో నీనా? తా మారొ నా మరియ నీనా? తా అన్నబయినె యాకోబు, యోసేపు, సీమోను, యూదా నీనా? ");
INSERT INTO rei_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","తా అప్పబొయినీనె సొబ్బిలింకె అంసంగరె తల్లీసె నీనా? ఈనె యాకు యెడానల్లా కేటెతీకిరి అయిసె? బులి కొయిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","సాకిరి కొయిగీకిరి తాకు త్రునీకరించిసె. సెల్లె యేసు తంకసంగరె, “కొయికుంటా, ప్రవక్తకు తా దెసొరె తా గొర్రె తప్ప సొబ్బిలింకె గౌరవించుసె” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","తాకు తంకె విస్వసించిలానింతె గనక సెయ్యె సెట్టె బడే అద్బుతానె కొరిలాని. ");
INSERT INTO rei_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","సే కల్రె గలిలయకు అదికారియీలా హేరోదు యేసు గురించి సునిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","సెయ్యె తా అదికారినె సంగరె, “సెయ్యె బాప్టీసం దిల్లా యోహాను మొర్నో దీకిరి జీకిరి అయిసిబులి మో నమ్మకం. కాబట్టి అద్బుతానె కొరిలా సక్తి తా బిత్తరాక అచ్చి” బులి తా సేవకునెకు కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","సాకిరి కిరుకు బులిసి బుల్నే కుండెకలోనె అగరె హేరోదు యోహానుకు బందించికిరి చెరసాలరె పొగిపించిపీసి. యాకిరి జరిగితే కారనం హేరోదియ. ఎయ్యె హేరోదు బయిలా పిలిప్పుకు నెయిపో. ");
INSERT INTO rei_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","యోహాను హేరోదుదీకిరి, “తూ హేరోదియా సంగరె మిసికిరి రొవురొ న్యాయంని!” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","యే కారనంగా హేరోదు యోహానుకు మొరదిమ్మంచిబులిగిచ్చి. ఈనె మనమానె యోహానుకు జొనె ప్రవక్తగా దిగిలీసె కాబట్టి హేరోదు తంకు దిక్కిరి డొరిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","హేరోదు జొర్నైలా దినే పొరువొ జరిగిసి. సేదినె హేరోదియ జో సబరె నచ్చికిరి హేరోదుకు మెప్పించిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","సడకు సెయ్యె తా జోకు మగిలాట దూంచిబులికిరి కొతా దీసి. ");
INSERT INTO rei_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","సెయ్యె తా మా ప్రొత్సాహం వల్లరె, “బాప్టీసం దిల్లా యోహాను ముండొకు గుటె పల్లెంరె లోక్కిరి మెత్తెదేండి” బులి మగిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","యెడ సునికిరి రొజాకు బాద కలిగిసి. ఈనె అతిదులు అగరె కొతా దిల్లందరె, తా కోరిక తీర్చు బులి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ఎంట్రాక బటులుకు పొడిదీకిరి చెరసాలరెతల్లా యోహాను ముండొ అనిపించిపీసి. ");
INSERT INTO rei_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","జొనె బటుడు యోహాను ముండొకు గుటె పల్లెంరె దరిగీకిరి అయికిరి తాకు దీసి. సెయ్యె సడకు తా మా పక్కు దరిగీజేసి. ");
INSERT INTO rei_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","యోహాను సిస్యునె అయికిరి తా దేకు దరిగిజేకిరి సమాది కొరిసె. సే తరవాతరె జేకిరి యేసు సంగరె కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","సెల్లె యోహానుకు జరిగిలా సంగతి సునికిరి యేసు జొన్నాక పడవ ఉటికిరి కేసేనీలా చోటుకు జేసి. సెయ్యె జెల్లాట పట్నాల్రెతల్లాలింకల్లా సునికిరి మనమనె గుంపునె గుంపునెగా గాన్రెతీకిరి అయికిరి సలికుంటా తా పొచ్చాడెజేసె. ");
INSERT INTO rei_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","యేసు పడవరెతీకిరి వొల్లికిరి మనమానె గుంపునె గుంపునెగా సెట్టె రొవ్వురొ దిగిసి. తంకంపరె సెయ్యె జాలిపొడిసి. తంకె బిత్తరె జబ్బూనెదీకిరి తల్లాలింకు సెయ్యె బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","సొంజయిలాబెల్లె సిస్యునె తా పక్కు అయికిరి, “యే చోటు బొనొరె అచ్చి, ఈనె ఉంచునుకు బడేసొంజైజేసి. అంకు పొడదీపెండి. గానెబిత్తరకు జేకిరి కిరైనా కద్ది గినిగీకిరి కాసె” బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","యేసు, “తంకె జేతె అవసరంని. కైతె తొమె కిరైనా దేండి.” బులి తంకె సంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“అం పక్కరె పాట రొట్టినె, దీట మచ్చోనె మాత్రమాక అచ్చి” బులి తంకె సంగరె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“సడకు ఎట్టికి దరిగీరి అయిండి” బులి యేసు కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","సే తరవాతరె మనమానె సెట్టెరొల్ల గసొ బయల్లురె బొసొండిబులి కొయిసి. సే పాట రొట్టినె, దీట మచ్చోనె దరిగీకిరి మెగొ ఆడుకు దిక్కిరి పురువుకు స్తోత్రం కొయిసి. సే రొట్టినె బంగికిరి తా సిస్యునెకు దీసి. సిస్యునె మనమానుకు బంటదీసె. ");
INSERT INTO rei_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","సొబ్బిలింకె పెట్టొపూరు కయిసె. సే తరవాత సిస్యునె మిగిల్లా ముక్కలుకు పన్నెండు బుట్టీనెపూరు పూరిదీసె. ");
INSERT INTO rei_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","మొట్టానె, పిల్లనె నీకిరి ఇంచుమించు పాటవెయ్యి మంది జాంక వొండ్రపోనె సే దినె సెట్టె కద్దీనె కయిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","సే తర్వాతరె యేసు తా సిస్యునె సంగరె పడవ ఉటికిరి మోకన్నా అగరె తెనాడె ఒడ్డుకు జాబులి కొయిసి. సెయ్యె సెటె రొయికిరి మనమానుకు పొడిదిపీసి. ");
INSERT INTO rei_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","మనమానుకు పొడదిల్లాతర్వాతరె యేసు జొన్నాక ప్రార్దనకొరితె పొరొతొ ఉంపరకు జేసి. సొంజయిసి ఈనె సెయ్యె జొన్నాక సెట్టె రొయిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ఒడ్డుకు పడవ బడే దూర్రె అచ్చి. ఎదురు బా పొగిలందరె కెరటాలు సే పడవకు మరిలీసె. ");
INSERT INTO rei_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","సొక్కలెపైలా జామురె తింట తీకిరి సోగంటబెల్లె యేసు సోంద్రొ ఉంపరె సలికిరి సిస్యునె పక్కు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","సెయ్యె సోంద్రొఉంపరె సలివురొ దిక్కిరి సిస్యునె, బుత్తొ బులి కొయిగీకిరి డొరిజేకిరి బొట్టానె దొందరానె దొందిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","యేసు ఎంట్రాక, “మియ్యాక! దైర్యంగా తాడి! డొరితెనాండి!” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","పేతురు, “ప్రబూ తువ్వయినె, సోంద్రొఉంపరె సలిసు. మియ్యంకా సోంద్రొ ఉంపరె సలితందుకు అనుమతిదే! బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","పేతురు ఆయి బులి యేసు కొయిసి. సెల్లె పేతురు పడవ వొల్లికిరి పని ఉంపరె సలికిరి యేసు పక్కు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ఈనె బా పొగివురొ గమనించికిరి డొరికిరి పనిబిత్తరె బుడ్డిజీకుంటా, ప్రబూ, మెత్తె కాపాడు!” బులి దొందరిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","యేసు ఎంట్రాక తా అత్తొ చాపికిరి తాకు దరిగీకిరి, “అల్పవిస్వాసి, కైంకి సందేహించులీసు?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","తంకె పడవ ఉటిలా తరవాతరె బా తగ్గిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","పడవరెతల్లాలింకె యేసుకు మొక్కికిరి, “తువ్వు సొత్తాక పురువురొ పో!” బులి ఆచ్చర్యపొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","తంకె సోంద్రొ దాటికిరి గెన్నేసరెతు ఒడ్డుకు అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","సే గాలింకె యేసుకు గుర్తించికిరి చుట్టూ రొల్లా గాన్రె రొల్లలింకల్లా కబురు కొయికిరి. మనమానె జబ్బులునెదీకిరి తల్లాలింకె తా పక్కు డక్కిపించిసె. ");
INSERT INTO rei_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“తంకె తో కొన్నా అంచుకు ఈనెను సూగీపించు” బులి బతిమాలిగిచ్చె. తాకు సూగిల్లాలింకల్లా బొలైజీసె. ");
INSERT INTO rei_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","సెల్లె కుండెలింకె పరిసయ్యునె, సాస్త్రీనె యెరూసలేము దీకిరి అయికిరి యేసుకు పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“తో సిస్యునె కద్దికైలా అగరె అత్తోనె కిరుకు దొయిగినింతె? బొడిలింకె లొగిలా ఆచారమూనె తంకె కిరుకు నిర్లక్స్యం కొరిలీసె?” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","సడకు యేసు యాకిరి సమాదానం కొయిసి, తొం ఆచారమూనె కోసం పురువురొ ఆజ్ఞానెకు కిరుకు యాకిరి నిర్లక్స్యం కొరిలీసో? ");
INSERT INTO rei_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","పురువు మా, బోకు గౌరవించు బులిసి. సెత్తాకనీ మా, బోకు దూసించిలాలింకు మొర్నొసిక్స పొగిమాసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ఈనె జొనె తా బోకైనా మాకైనా సహాయం కొరితె దిల్లాట యెడ పురువురోట బులి కొయికిరి బోదించిలీసె. ");
INSERT INTO rei_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","తొమె తొం పారంపర్యాచారము కోసం పురువురొ కొతానుకు పొక్కరె దీపీలీసొ. సడ వల్లరె తంకె మాబోనుకు గౌరవించినార్లీసె. ");
INSERT INTO rei_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","తొమె మోసంకొర్లాలింకె. యెసయా తొం గురించి అగరె కొయిలాట సొత్తాకనీనా. ");
INSERT INTO rei_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","యే మనమానె మెత్తె కొతానె సంగరె గౌరవించుసె. ఈనె తంకె మనుసూనె మెత్తె దూరుగా తాసి. ");
INSERT INTO rei_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","తంకె ఆరాదనలు వ్యర్దం! తంకె బోదానె మనమానె కొరిలా ఆజ్ఞానె సంగరె సమానం బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","సెల్లె యేసు మనమానుకు తా పక్కరకు అయిబులి డక్కికిరి తంకెదీకిరి, “సునికిరి అర్దం కొరిగీండి. ");
INSERT INTO rei_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","మనమ తుండొబిత్తరెకు జెల్లాట కిరనెను తాకు అపవిత్రం కొరిని. తా తుండొదీకిరి అయిల కొతానె తాకు అపవిత్రం కొరివొ” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","సే తరవాత సెయ్యె సిస్యునె అయికిరి, “తూ కొయిలాట సునికిరి పరిసయ్యునె రగొపొడిసె బులి తొత్తె తెలిసినీనా?” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","యేసు, పరలోకంరె తల్లా మో “బో” నానాటిలా ప్రతి మొక్క సెరోనె సంగరె కడికిరి పొక్కదూసి. ");
INSERT INTO rei_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","తంకు జోలుకు జేతేనాండి. తంకె నాయికులు గుడ్డిలింకె. ఈనె తంకె పొదరలింకు బట్టొ దిగదీకిరి రొసి. గుడ్డిమనమ గుడ్డిమనమకు బట్టొ దిగదిన్నే దీలింకె గత్తొరె పొడుసె బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","పేతురు, “సే ఉపమానంకు అముకు విడమరికిరి కోండి” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","యేసు తంకసంగరె యాకిరి కొయిసి. తొముకూడా అర్దం యిలానీనా? పొదర్లింకన్నా తెలివినీలాలింకెపనికి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","కిరైనన్నా తుండొ బిత్తరుకు జెల్లాట పెట్టొబిత్తరకు జేకిరి సెల్లె “దే” దీకిరి బయలుకు జెల్లీసిబులికిరి తొముకు తెలిసినీనా. ");
INSERT INTO rei_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ఈనె తుండొదీకిరి బయలుకు అయిలా కొతానె హ్రుదయం దీకిరి ఆసి. మనమకు అపవిత్రం కొరిలాట యెడాక. ");
INSERT INTO rei_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","కిరుకుబుల్నే, చెడు ఆలోచన, హత్య, దర్నిపైటినె, లైంగిక దుర్నీతి, సొరొపైటీనె, సొరొసాక్సీనె, దైవదూసనానె హ్రుదయంతీకిరి ఆసె. ");
INSERT INTO rei_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","యెడ కారనంగా మనమ అపవిత్రం ఈలీసి. ఈనె అత్తోనె నాదొయిగికుంటా బత్తొ కైయిలెత్తె మాత్రంరె అపవిత్రం ఈని బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","యేసు సే చోటుకు సడదీకిరి తూరు, సీదోను ప్రాంతమూనెకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","సే ప్రాంతంరె తల్లా కనానుమొట్ట యేసు పక్కు కందికుంటా అయికిరి, “ప్రబూ! దావీదురొ పో! మో ఉంపరె దయ దిగదే. మో జోకు బుత్తొ దరిగీకిరి బడే బాద పొడిలీసి” బులి తాదీకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","యేసు కిచ్చి సమాదానం కొయిలాని. సడవల్లరె సిస్యునె అయికిరి, “సెయ్యె గట్టిగా దొందరికిరి అం పొచ్చాడె అయిలీసి. తాకు పొడదీపేండి” బులి విజ్ఞప్తి కొరిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","యేసు “తప్పిజెల్లా ఇస్రాయేలు వంసమురె వొరిజెల్లా గొర్రీనె కోసం మాత్రమాక మెత్తె పొడదీసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","సే మొట్ట అయికిరి యేసు అగరె ముడుకూనె పొక్కిరి, “ప్రబూ! మెత్తె సహాయం కొరండి!” బులి మగిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","యేసు, “పురువురో పిల్లానుకు చెందిలా బత్తొ కడికిరి కుక్కురొనుకు పొగువురొ నాయ్యంనీ” బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“సొత్తాక ప్రబూ! ఈనె, కుక్కురొనె కూడా తా యజమానిరొ బల్లంపరె దీకిరి పొడిలా ముక్కలుకు కైవెనీనా?” బులి సెయ్యె బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","సెల్లె యేసు, “మా! తోబిత్తరె తల్లా విస్వాసం బొల్ట. తూ కోరిలాపనాక జరుగుసి” బులి సమాదానం కొయిసి. సే గడియరాక తా జ్యోకు బొలియీజిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","యేసు సెట్టెదీకిరి బయిలుదేరికిరి గలిలయ సొంద్రొ ఒడ్డురెదీకిరి జేసి. పొరొతొ ఉంపరకు జేకిరి బొసిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","మనమానె గుంపునె గుంపునెగా సెట్టికు అయిసె. తంకె తా పొచ్చడె సొట్టలింకె, అంకీనె నీలాలింకె, గొడ్డత్తొనె పొడిజెల్లలింకె, కొతానె నాయిలలింకె యింకా బడే రకాలు రోగోనె రొల్లాలింకు దరిగీకిరి అయికిరి తా గొడ్డొనె అగరె పోదీసె. సెయ్యె తంకు బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","కొతానె నిలాలింకు కొతానె అయిసి. గొడ్డోనె అత్తోనె పొడిజెల్లాలింకె బొలైజీసె. కుంటిలింకె సలిసె. అంకీనె నీలాలింకు అంకీనె అయివురొ మనమానల్లా దిక్కిరి ఆచ్చర్యపొడికిరి ఇస్రాయేలు పురువుకు స్తుతించిసె. ");
INSERT INTO rei_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","యేసు తా సిస్యునెకు డక్కికిరి తంక సంగరె, “అంక ఉంపరె మెత్తె బడే జాలి కలిగిలీసి. తంకె తిందినెదీకిరి మోపక్కరాక అచ్చె. తంక పక్కరె కైతే కిచ్చినీ. తంకు బొక్కొరె పొడదీతె మెత్తె ఇస్టంనీ. సాకిరి పొడదిన్నే తంకె బట్టరె ముండొబించికిరి పొడుజూసె” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","తా సిస్యునె యేసుకు, “యే మారు మూల గాన్రె సొబ్బిలింకు సొరిపొడిలా రొట్టీనె కేటె మిలుసి?”బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“తొం పక్కరె కెత్తె రొట్టీనె అచ్చె?” బులి యేసు పొచ్చిరిసి. “సత్ర రొట్టీనె, కుండె సన్ని మచ్చోనె అచ్చె” బులి తంకె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","యేసు మనమానెకు నేలంపరె బొసిరొండి బులి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","సే తరవాత సత్ర రొట్టీనె, మచ్చోనె కడిగీరి పురువుకు క్రుతజ్ఞతలు కొయికిరి సడకు బంగికిరి సిస్యునెకు దీసి. సిస్యునె సడానె మనమానుకు బంటదీసె. ");
INSERT INTO rei_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","సొబ్బిలింకె సంత్రుప్తిగా కైలా తరవాతరె సిస్యునె మిగిలిజిల్లా ముక్కలల్లా సత్ర బుట్టీన్రె పూరదీసె. ");
INSERT INTO rei_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","మొట్టానె, సన్ని పిల్లానె నీకిరి చారవేయిమంది వండ్ర పోనె సేదినె సెట్టె కద్దీనె కైసె. ");
INSERT INTO rei_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","సెల్లె యేసు మనమానుకు పొడదిపేకిరి పడవ ఉటికిరి మగదాను ప్రాంతం జేసి. ");
INSERT INTO rei_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","సెల్లె పరిసయ్యునె, సద్దూకయ్యునె యేసుకు పరీక్సించిమాసి బులి అయికిరి, పురువు తొత్తె పొడదీసి బులి అముకు తెలివైలాపనికిరి“మెగొ తీకిరి గుటె అద్బుతంకు అముకు దిగదె” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ఈనె యేసు యాకిరి కొయిసి. “సొంజెబెల్లె మెగొ గొర్రయికిరి తన్నే సే దినె వాతావరనం బొల్లెతాసిబులి తొమె బులిగిల్లీసో. ");
INSERT INTO rei_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","సొక్కలె మెగొ గొర్రయికిరి తైకిరి, మెగో మబ్బునె తన్నే సే దినె బొర్సొ ఆసి బులి బులిగిల్లీసొ. మెగో ఆడుకు దిక్కిరి తొమె వాతావరనంకు సూచనకొయిపారొ ఈనె యే కలొ దిగదిల్లా అద్బుతంకు అర్దం కొరిగిన్నింతె. ");
INSERT INTO rei_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","దుస్టులు, బక్తినీలాలింకె యే తరంలింకె అద్బుత కార్యాలునె దిగదెబులికిరి మగుసె. పురువు యోనా ప్రవక్తకు కొరిలా అద్బుతం తప్ప మరి కే అద్బుతం దిగదిల్లాని.” బులి కొయికిరి సడకు యేసు తంకు సడదీకిరి బాజేసి. ");
INSERT INTO rei_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","సిస్యునె సోంద్రొదాటికిరి జెల్లాబెల్లె, అగరె తంకె నందిగిల్ల రొట్టినుకు దరిగిజెవ్వురొ పసిరిజేసె. ");
INSERT INTO rei_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","యేసు తంకెదీకిరి, “జాగర్త! పరిసయ్యునె కారనంగా, సద్దూకయ్యునె కారనంగా పులిసిలా పిండి విసయంరె దూరుగా టారించి” బులి తంకు కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","యే విసయం గురించి తంకె బిత్తరె తంకె కొతలగ్గీకిరి, “అమె రొట్టినె దన్నయిలానింతో బులి” సెయ్యె సాకిరి కొయిసి బులిగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","తంకె బులిగివురొ యేసుకు బుజ్జిసి. తంకె, “తొంబిత్తరె అల్పవిస్వాసంలింకె రొట్టినె నీబులికిరి తొంబిత్తరె తొమె కైంకి కొతాలగ్గిల్లీసో? ");
INSERT INTO rei_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","తొముకు యింకా తెలిసినీనా? పాటవెయ్యి మందికి పాట రొట్టినె బంటదిల్లాబెల్లె మిగిల్లా ముక్కలుకు తొమె కెత్తొ బుట్టీనె పూరదీసెవో తొమె పసిరిజీసోనా? ");
INSERT INTO rei_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ఈనె సత్ర రొట్టినుకు చారవెయ్యి మందికి బంటిలాబెల్లె మిగిల్లా ముక్కలు తొమె కెత్తె బుట్టినె పూరూ పూరదీసెవో గురుతు నీనా? ");
INSERT INTO rei_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","మియి తొముకు కొయిలాట రొట్టినె కోసం నీబులి తొమె కిరుకు అర్దం కొరిగిన్నార్లీసో? పరిసయ్యునె, సద్దూకయ్యునె వల్లరె కలిగిలా పులిసిలాటకు దూరుగా టారించి” బులి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","సెత్తెలె సెయ్యె రొట్టెలుకు‍‍‍‍ ఉపయోగించిలా పులిసిల విసయంరె జాగర్త పొడుబులి బుల్లానీ గాని పరిసయ్యునె బోద విసయంరె, సద్దూకయ్యునె బోద విసయంరె జాగర్త పొడుబులి తంకు అర్దమైసి. ");
INSERT INTO rei_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","యేసు కైసరియ పిలిప్పు పట్నం పక్కరె తల్లా గానె పక్కు అయిలాబెల్లె తా సిస్యునె సంగరె, “మనమరొ పో గురించి మనమానె కిరబులి కొయిగిల్లీసె?” బులి పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","తంకె “కుండె మనమానె బాప్టీసం దిల్లా యోహాను బులిసె. కుండె మనమానె ఏలీయా బులిసె. కుండె మనమానె యిర్మీయా బులిసె. ఇంకా కుండె మనమానె ప్రవక్తానెరె జొనైకిరి రొవ్వొచ్చు బులి బులిగిల్లీసె” బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","యేసు, ఈనె తొం విసయంకిర? మియ్యి కేసె బులి తొమె బులిగిలిసో? బులి తంకు పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","సడకు సీమోను పేతురు, తువ్వు క్రీస్తు సజీవుడైలా పురువురొ పో బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","సడకు యేసు యాకిరి కొయిసి, “యోనా పో! సీమోనూ, తూ దన్యుడు! యే విసయంకు తొత్తె మనమానె కొయిలానింతె ఈనె పరలోకంరె తల్లా మో బోకా కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ఈనె తూ పేతురు బులి మియి కొయిలించి. యే పొత్రొ ఉంపరె మియి మో సంగంకు బందుంచి. సే సంగం అగరె పాతాలలోకం కూడా ఎదిరించినారి బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","పురువురొ రాజ్యంరొ తాలమునె మియి తొత్తెదిమ్మి. యే బూమి ఉంపరె తూ నిరాకరించిలాలింకు పరలోకంరె కూడా నిరాకరించుంచి. యే ప్రపంచంరె తూ అంగీకరించిలాలింకు పరలోకంరె కూడా అంగీకరించుంచి” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","సే తరవాతరె, సెయ్యె క్రీస్తు బుల్లా విసయం కాకూ కొయితెనా బులికిరి సిస్యునె సంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","సెత్తెలె దీకిరి యేసు తా సిస్యునె సంగరె సెయ్యె యెరూసలేముకు జెవ్వొలిసిల సంగతి గురించి, సెట్టె తల్లా బొడిలింకె, ప్రదానయాజకూనె, సాస్త్రీనె తాకు హింసించిలా విసయం గురించి, సెయ్యె పొందివలిసిలా మొర్నొ గురించి, తింటో దినెరె జీకిరి అయితల్లాట గురించి కొయివురొ మొదలు కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","పేతురు తాకు గుటె పక్కు డక్కికిరి ప్రబూ సాకిరి కొతాలగితెనాబులి, “పురువు తాంపరె దయ దిగదిమంచె! సాకిరి కెబ్బుకు జరిగినాసి!” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","యేసు పేతురు ఆడుకు బుల్లికిరి, సాతాను “మో అగరె దీకిరి బాజా, తువ్వు మెత్తె ఆటంకం కలిగించిలీసు యే ఆలోచనానె మనమానె తీకిరి అయిలాంచ పురువుతీకిరి అయిలాంచనీ” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","సెల్లె యేసు తా సిస్యునె సంగరె, “మో పొచ్చాడె అయిమాసిబులిగిల్లాట సొబ్బీ సడదీకిరి, మో సిలువకు బొయికుంటా మెత్తె అనుసరించిమంచి. ");
INSERT INTO rei_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","కేసన్నా తా పొర్నొకు కాపాడిగిమాసి బులిగిల్లాట సడకు వొరదగివ్వొ. ఈనె మో కోసం తా పొర్నొకు సడదగిల్లలింకె సడకు పొందిగివ్వొ. ");
INSERT INTO rei_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","లొకొ అల్లా జయించికిరి తా పొర్నొకు వొరదగిన్నే మనమకు కిర లవొ కలుగుసి? సే పొర్నొకు బుల్లికిరి పొందిగిత్తే సెయ్యె కిరదీపారి? ");
INSERT INTO rei_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","మనమరొ పో తా దేవదూతానె సంగరె మిసికిరి, బో మహిమ సంగరె అయిలీసి. సెత్తెలె సెయ్యె ప్రతి మనమకు కొరిలా పైటినె వల్లరె ప్రతిపలం దూసి. ");
INSERT INTO rei_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ఎట్టె టారిలాలింకె బిత్తరె కుండెలింకె మనమరొ పో తా రాజ్యం సంగరె అయిలాట దిగిలాజాంక జీకిరి తాసె” బులి కచ్చితంగా కొయిలించి బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","యేసు సో దినోనె తరవాతరె పేతురుకు, యాకోబుకు, యాకోబు బయిల యోహానుకు, గుటె ఎత్తైలాపొరొతంపరకు తా పొచ్చాడె ప్రత్యేకంగా డక్కిగీకిరి జేసి. ");
INSERT INTO rei_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","సెయ్యె సెట్టె తల్లాలింకగరె దివ్యరూపం పొందిసి. తా మూ సూర్యుడుపని మెరిసి. తా కొన్నానె హల్లో పనికిరి దగదగా మెరిసె. ");
INSERT INTO rei_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","సే గడియరె తంకగరె మోసే, ఏలీయా ప్రత్యక్సమైసె. తంకె యేసు సంగరె కొతలగివురొ సిస్యునె దిగిసె. ");
INSERT INTO rei_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","సెల్లె పేతురు యేసు సంగరె, “ప్రబూ, అమె ఎట్టె రొవ్వురొ బొల్ట. తొత్తె ఇస్టమైనె తింట పర్నసాలానె బందిపించుంచి తొత్తె గుటె, మోసే గుటె, ఏలీయాకు గుటె” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","సెయ్యె యింకా కొతలగితల్లాబెల్లె గుటె కాంతివంతంమైలా మెగో సెట్టె టారిలాలింకు బుజ్జిపేసి. సెల్లె సే మెగో దీకిరి గుటె స్వరమైకిరి, “ఎయ్యె మో యిస్టమైలా పో, ఆ గురించి మీ ఆనందించిలించి, ఆ కొత సునొండి” బులి సుందీసి. ");
INSERT INTO rei_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ఎడ సునికిరి సిస్యునె డొరొసంగరె బొర్లాపొడిజీసె. ");
INSERT INTO rei_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","యేసు అయికిరి తంకు సుగీకిరి “ఉటోండి, డొరితెనాండి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ఈనె తంకె ఉటికిరి దిగిలాబెల్లె తంకు యేసుతప్ప యింకేసే దిగదిల్లానింతె. ");
INSERT INTO rei_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","తంకె పొరొతొ వొల్లికిరి తొల్లుకు అయితల్లాబెల్లె యేసు, “మనమరొ పో జీకిరి అయిలాజాంక తొమె దిగిలా యే దర్సనం గురించి కాకు కొయితెనాండి” బులి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","సెల్లె తా సిస్యునె “అగరె ఏలీయా అయిమంచి బులి సాస్త్రీనె కిరుకుబుల్లీసె” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","సడకు యేసు యాకిరి సమాదానం కొయిసి, “ఏలీయా తప్పకుండా ఆసి. అయికిరి అగరాక సొబ్బీ సిద్దపరిచివొ బుల్లా కొత సొత్తాక. ");
INSERT INTO rei_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","మియి కొయిలాట కిరబుల్నే, ఈనె ఏలీయా అగరాక అయిసి. ఈనె తంకె తాకు గుర్తించినారికిరి తాకు తంకె ఇస్టమైలాపనికిరి కొరిసె. సాకిరాక మనమరొ పో కూడా తంకవల్లరె స్రమ అనుబవించుసి బులి కొయిలించి.” ");
INSERT INTO rei_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","యేసు బాప్టీసం దిల్లా యోహాను గురించి కొయిసి బులి సిస్యునెకు సెల్లె అర్దమైసి. ");
INSERT INTO rei_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","సెల్లె తంకె మనమానె పక్కరెదీకిరి బుల్లికిరి అయిలాబెల్లె జొనె మనమ యేసు పక్కు అయికిరి మోకరించిసి, ");
INSERT INTO rei_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ప్రబూ! మో పో ఉంపరె దయ దిగదె. సెయ్యె మూర్చజబ్బుసంగరె బడే బాదపొడిలీసి. కొతకొతకు నియ్యరె, పనిరె పొడిజెల్లీసి. ");
INSERT INTO rei_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","తాకు తో సిస్యునె పక్కరకు దరిగీకిరి అయించి. ఈనె తంకె తాకు బొలికొరినారిసె” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","సెల్లె యేసు, “మూర్కులైలా తొంబిత్తరె విస్వాసంనీ. మియి కెత్తె కలొ తొంసంగరె తమ్మంచి? కెత్తె కలొ తొం కోసం ఓర్చిగిమ్మి? తాకు మో పక్కరకు డక్కిగీకిరి అయిండి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","యేసు సే బుత్తొకు బాజాబులికిరి గట్టిగా కొయిసి. సడ సే పిల్లాసొదీకిరి బయలుకు అయిసి. సే గడియరాక సే పిల్లాసుకు బొలైసి. ");
INSERT INTO rei_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","సిస్యునె సే తరవాతరె యేసు పక్కరకు ప్రత్యేకంగా అయికిరి, “అమె కిరుకు సడకు పొడదిన్నారించొ?” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","యేసు, తొంబిత్తరె ఆవగింజెత్తె విస్వాసం నీ గనుక తొమె సడకు పొడదిన్నారిసొ. ఈనె ఎడ సొత్తాక. ");
INSERT INTO rei_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","తొంబిత్తరె ఆవగింజెత్తె విస్వాసము రొన్నె చాలు. తొమె ఏ బొనో సంగరె సెటుకు జా బులి కొయినె జోసి. “తొముకు నాఅత్తరయిలాట తన్ని” బులి కొయిసి. ప్రార్దన వలరాక గానీ యింకా కిరసంగరె జెన్నీ బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ఈనె సిస్యునె గలిలయరె యింకా మిసిగిల్లబెల్లె యేసు తంకెసంగరె, “మనమరొ పో మనమానెకు అప్పగించబొడుసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","తంకె తాకు మొరుదూసె. ఈనె తింటో దిన్రె సెయ్యె మొర్నొ దీకిరి జీకిరి ఆసి” బులి కొయిసి. ఎడ సునికిరి సిస్యునె బడే దుక్కొపొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","యేసు, తా సిస్యునె కపెర్నహూముకు చేరిగిల్లాబెల్లె, సెట్టె మందిరంరొ పన్నునె వసూలు కొరిలాలింకె పేతురు పక్కరకు అయికిరి, “తొం బోదకుడు మందిరంరొ పన్ను చెల్లించిసినా?”బులి ప్రస్నించిసె. ");
INSERT INTO rei_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“దూసి” బులి పేతురు సమాదానం కొయికిరి గొరొబిత్తరకు జేసి. సెయ్యె కిచ్చి నా కొతలగిలా అగరె యేసు, “సీమోను తూ కిరబుల్లీసు? రొజానె యే బూమి ఉంపరె పన్నునె కా పక్కరె వసూలుకొరివె? తా స్వంత దేసొలింకె పక్కరె దీకిరినా? పొదర్లింకె పక్కరె దికిరినా?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“పొదర్లింకె పక్కరె” బులి పేతురు సమాదానం కొయిసి. యేసు సాకిరియినె పన్ను బందివలిసిలా అవసరం నీబులి కొత! ");
INSERT INTO rei_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ఈనె తంకు ఇబ్బంది లొగివురొ మెత్తె ఇస్టంనీ. సోంద్రొ పక్కరకు జేకిరి గేలం పొగు! అగరె దరిలా మచ్చొ తుండొ పిటికిరి దిగినే అముకు సొరిపొడిలా నానెం మిలివొ. సడకు దరిగీకిరి జేకిరి అం దీలింకె పన్ను బందిపే! బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","సె తరవాతరె సిస్యునె యేసు పక్కరకు అయికిరి, “ఈనె పురువురొ రాజ్యంరె సొబ్బిలింకె కన్నా గొప్పలింకె కేసే?” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","యేసు గుటె సన్ని పిల్లాసొకు పక్కరకు అయిబులి డక్కికిరి తాకు తంకె మొజిరె టారెదీకిరి యాకిరి కొయిసి, ");
INSERT INTO rei_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“తొమె మారికిరి, తొమె మనుసూనె బిత్తరె సన్ని పిల్లానె పని నారొన్నే పురువురొ రాజ్యంకు జెన్నారొ”బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","సడకు ఎ సన్ని పిల్లసుకు తల్లా మనస్సు కలిగికిరి తగ్గించిగిల్లా మనమ పురువురొ రాజ్యంరె సొబ్బిలింకె కన్నా గొప్పలింకెపని పరిగినింపబొడుసి. ");
INSERT INTO rei_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","సెత్తాకనీ యాట సన్ని పిల్లనెరె జొనుకు మో నారె చేర్చిగిన్నె మెత్తె చేర్చిగివ్వొ. ");
INSERT INTO rei_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ఈనె ఎ సన్ని పిల్లనె విస్వాసంకు కెసన్నా ఆటంకం కొరితె కారనం యీలకన్నా, బెక్కుకు తిరగలి పొత్రొ బందికిరి లోతైల సోంద్రొరె పొక్కదివురొ బొల్ట. ");
INSERT INTO rei_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","అబ్యంతరములు వల్లరె ఏ లొకొకు స్రమ; అబ్యంతరముకు యివురొ తప్పినీ. ఈనె కావల్లరె అబ్యంతరము ఆసొ సే మనమకు స్రమ. ");
INSERT INTO rei_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","తో గొడ్డొ, తో అత్తొ తొత్తె అబ్యంతరం కొర్నె సడకు అనికిరి పొక్కదెండి. దీట గొడ్డోనె దీట అత్తోనె రొయికిరి కెబ్బుకు పుడ్డయితల్లా నియ్యరె పొడిలాకన్నా, సొట్టమోపొగ ఈనె గొడ్డొనె అత్తోనె నీలా మోపొ పనికిరి రొయికిరి నిత్యజీవం పొందిగివురొ బొల్ట. ");
INSERT INTO rei_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ఈనె అంకి తొత్తె అబ్యంతరం కొర్నె సడకు జింకికిరి పొక్కదెండి. దీట అంకి రొయికిరి నరకంబిత్తరె నియ్యరె పొడివురొకన్నా గుటె అంకి దీకిరి పరలోకం బిత్తురుకు జెవురొ బొల్ట. ");
INSERT INTO rei_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ఏ సన్ని పిల్లాన్రె కాకు సన్ని దిగా దిగితెనాండి. మియ్యి కొయిలాట కిరబుల్నె పరలోకంరె తల్లా యే దూతానె పరలోకంరె తల్లా మో బో మూకు కెబ్బుకు దిక్కికుంటా తాసె. ");
INSERT INTO rei_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","గుటె పక్కరె సోయి గొర్రీనె అచ్చెబులిగీండి. సడాన్రె గుటె గొర్రి తప్పిజెన్నే, సెయ్యె సే తొంబైతొమ్మిది గొర్రీనె బొనొ ఉంపరె సడదీకిరి, సె తప్పిజెల్ల గొర్రె కోసం కుజ్జినీనా? తొమె కిరబులుసో? ");
INSERT INTO rei_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ఎడ సొత్తాక, సే గొర్రెమిల్నె సే తొంబైతొమ్మిది గొర్రీనె కన్నా సెయ్యె సడవల్లరె బడే ఆనందించుసి. ");
INSERT INTO rei_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","సాకిరాక పరలోకంరె తల్లా మో బో ఎ సన్ని పిల్లాన్రె కేసె తప్పిజెవురొ పరలోకంరె బో ఆనందించిని. ");
INSERT INTO rei_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","తొ బయి తోంపరె తప్పు కొర్నె తా పక్కరకు జేకిరి సెయ్యె కొరిలా తప్పు తాకు జొన్నే తల్లాబెల్లె కోండి. సెయ్యె తో కొతా సున్నే తాకు తూ బుల్లికిరి సంపాదించిగిల్లాపనికిరాక. ");
INSERT INTO rei_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","సెయ్యె తొం కొత నాసున్నే, జొన్నె, నీనె దీలింకు సాక్సీనె తొం పొచ్చాడె దరిగి జాండి. కిరుకుబుల్నే ప్రతి విసయముకు నిర్నయించితె లేకనానె కొయిలా పనికిరి దీలింకె నీనె తిల్లింకె సాక్సం కొయిమంచి. ");
INSERT INTO rei_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","తొం కొతా సునితె సెయ్యె నాఅంగీకరించినె జేకిరి తంకె సంగం కోండి. సెయ్యె సంగం కొయిలా కొతకూడ నాసున్నే తాకు తొమె పొదరెలింకెగా పన్నునె వొసులు కొరిలా పాపోనెగా బులిగీండి. ");
INSERT INTO rei_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ఈనె యే బూమంపరె తొమె కిరకు బందించువోయొ, సడ పరలోకంరె బందింపబొడివొ; బూమంపరె తొమె కిరకు పిటివొయొ, సడ పరలోకంరె పిటుసి బులి తొం దీకిరి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","సడాకనీ, మియ్యి కొయిలాట కిరబుల్నె తొంబిత్తరె దీలింకె మిసికిరి బూమంపరె ఏకమైకిరి కిరగురించన్నా ప్రార్దించినె, సెల్లె పరలోకంరె తల్లా మో బో సడ తొముకు సొత్తాక అనుగ్రహించుసి. ");
INSERT INTO rei_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","కిరుకుబుల్నే మో నారె దీలింకె నీనే తిల్లింకె కేటె మిసికిరితన్నే మియ్యి సెట్టె తంకెదీకిరి తాంచి. ");
INSERT INTO rei_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","సెల్లె పేతురు యేసు పక్కరకు అయికిరి, “ప్రబూ! మో బయి మెత్తె పాపం కొర్నే మియ్యి కెత్తెబెల్లె తాకు క్సమించిమాసి? సత్రబెల్లెనా?” బులి పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","సడకు యేసు యాకిరి సమాదానం కొయిసి. ఏడుసార్లునీ, డెబ్బది ఏడు సార్లు క్సమించిమాసి బులి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ఈనె పురువురొ రాజ్యం తా సేవకునె సంగరె లెక్కలు పరిస్కరించిగిమ్మంచి బుల్లా జొనె రొజా సంగరె పోల్చికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","సే రొజా లెక్కలు దిగివురొ మొదలు లొగిలాబెల్లె వేలకొలది సున్న నానేలు అప్పు తల్లా జొనె మనమకు బటులు రొజా పక్కరకు డక్కిగీకిరి అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ఈనె అప్పు తల్లా మోపొ పక్కరె అప్పు తీర్చితె పలియనీ. సడకు సే రొజా తాకు, తా నెయిపుకు, తా కుటుంబంకు, తాపక్కరె తల్లా సొరుకోనె సొబ్బి బిక్కిపీకిరి అప్పు తీర్చు బులికిరి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","సే సేవకుడు రొజా అగరె ముడుకూనె పొక్కిరి, కొద్ది కలొ దే, తొత్తె దివ్వలిసిలా పలియ సొబ్బీ దీపొంచి బులి బతిమాలిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","రొజా సే సేవకుడు ఉంపరె దయసంగరె కనికరంపొడికిరి క్సమించికిరి తాకు విడుదల కొరిసి. సడ వుంపరె తాకు అప్పు కూడా నాదీకుంట కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","సే సేవకుడు బయలుకు జేకిరి, తాదీకిరి మిసికిరి పైటికొరిలా సేవకుడుకు దిగిసి. తాకు వెయ్యి వెండినానేలు అప్పుతల్లా మొపొరొ బెక్కొ దరిగీకిరి, మో అప్పు తీర్చు బులి వేదించిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","అప్పుతల్లా సేవకుడు ముడుకూనెపొక్కిరి, కొద్ది కలొ గడువు దే తో అప్పు తీర్చుపూంచి బులి బతిమాలిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ఈనె అప్పుదిల్లా మోపొ సడకు అంగీకరించిలాని. ఈనె జేకిరి తా అప్పు తీర్చిల జాంక సె అప్పుతల్ల మొపొకు చెరసాలరె పొగిపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","తా సంగరె తల్లా సేవకుడు జరిగిలాట దిగిసి. తంకు బడె బాదపొడిసి. తంకె జేకిరి జరిగిలాటల్లా తంకె రొజా సంగరె కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","సెల్లె సే రొజా సే సేవకుడు డక్కికిరి, రగొ సంగరె దుర్మార్గుడా! తువ్వు మెత్తె బతిమాల్లందుకు తొ అప్పు అల్లా క్సమించించి. ");
INSERT INTO rei_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ఈనె మియ్యి తొ ఉంపరె దయ దిగదిల్లపని తాకు తోసంగరె తల్లా సేవకుడు ఉంపరె దయ దిగదిమ్మాసినీనా? బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","సే తరవాతరె రొజా బడే రగోసంగరె తా అప్పు అల్లా తీర్చిలా జాంక సిక్స లొగు బులికిరి సే సేవకుడుకు బటులుకు అప్పగించిసి. ");
INSERT INTO rei_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","సడకు యేసు, తొం బిత్తరె ప్రతిజొనె తొం బయికు మనసార నాక్సమించినె పరలోకంరె తల్లా మో బో తొం పట్ల సే రొజా పనాక కొరివొ. ");
INSERT INTO rei_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","యేసు కొతలగివురొ ఈజిల్లా తరవాతరె గలిలయ సడదీకిరి యొర్దాను వొడ్డుతెనాడె తల్లా యూదయ ప్రాంతంకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","మనమానె గుంపునె గుంపునెగా తా పొచ్చాడె జేసె. సెయ్యె తంకు బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","కుండెలింకె పరిసయ్యునె తాకు పరీక్సించిమాసి బులి తా పక్కు అయికిరి, “వొండ్రపో తా నైపోకు కే కారనం దిగదీకిరి విడాకులు దివ్వొచ్చునా?” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","సెయ్యె, “అగరె స్రుస్టకర్త వొండ్రపోకు, తిల్డ్రాంటకు కొరిసి బులి తొమె లేకనానెరె చదివిలానింతోనా? బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","సడవల్లరె వొండ్రపో తా మా, బోకు సడికిరి తా నైపో సంగరె గుట్టెవూసి. తంకె దీలింకె మిసికిరి గుటె దే గా జూసె. ");
INSERT INTO rei_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","సే కారనంరె తంకె యింక అగరె దీలింకెగా నీకుండా జొన్నెపనికిరి తాసె! పురువు ఏకం కొరిలాలింకు మనమానె వేరుకొరినాసి” బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“ఈనె వొండ్రపో యిడాకులు పత్రం తా నైపోకు దీకిరి తాకు పొడదిపించువొచ్చు బులికిరి మోసే కిరుకు ఆజ్ఞాపించిసి?” బులి పరిసయులు పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","యేసు, సే “కొయిలా కొతానె తొమె సునిలానింతొ గనక తో నైపోకు విడాకులుదీతె మోసే తొముకు అనుమతి దీసి. ఈనె అగరెదీకిరి యాకిరినీ. ");
INSERT INTO rei_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ఈనె మియ్యి కొయిలాట కిరబుల్నే, కే మనమైనా తా నైపోరొ దర్నిపైటి విసయంరె తప్ప నైపోకు విడాకులుదీకిరి యింగుటె మొట్టకు బ్యాకొరిగిన్నే తాదీకిరి దర్నిపైటి కొరిలాపని ఊసి.” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","సిస్యునె తాకు, “విడాకులుదీతె యడాక కారనం కావలసియీనె బ్యా నాకొరిగీకుంటా రొవ్వురొ బొల్ట”బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","యేసు, “తూ కొయిలా యే బోద సొబ్బిలింకు సాద్యంనీ. ఈనె పురువు అనుగ్రహించిలాలింకు మాత్రమాక. ");
INSERT INTO rei_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","బ్య నా కొరిగిత్తే బడే కారనాలు తాసె. కుండిలింకె మా పెట్రాక నపుంసకులుగా జొర్నైసె. ఈనె బ్య కొరిగిన్నింతె. ఈనె కుండిలింకె పొదరలింకు నపుంసకులుగా కొరుసె. ఈనె బ్య కొరిగిన్నింతె. ఈనె కుండిలింకె పురువురొ రాజ్యం గురించి బ్య కొరిగిన్నింతె. ఎ బోదకు అంగీకరించిలాలింకె అంగీకరించొండి” బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","సెల్లె యేసు తా అత్తొకు సన్ని పిల్లనెరొ ముండొంపరె లొక్కిరి తంకోసం ప్రార్దన కొరిమంచిబులి కుండిలింకె మనమానె తంకు దరిగి అయిసె. ఈనె సే డక్కిగీకిరి అయిలలింకు సిస్యునె గద్దించిసె. ");
INSERT INTO rei_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ఈనె యేసు, “పురువురొ రాజ్యం తంకపనాలింక్టాక. తంకు మో పక్కు అయిమురోండి తంకు ఆపితెనాండి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","తంకె ముండొంపరె అత్తొలొక్కిరి ఆసిర్వదించిలా తరవాతరె యేసు సెట్టెదీకిరి బాజేసి. ");
INSERT INTO rei_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","గుటెబెల్లె జొనె బెండకుర్ర యేసు పక్కరకు అయికిరి, “బొదకుడా! నిత్యజీవం పొందిమంచిబుల్నే మియి కిర బొల్ట పైటి కొరిమంచి?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","సడకు యేసు, “బొల్ట గురించి మెత్తెకిరుకు పొచ్చిరిలీసు? బొల్ట మనమ జొన్నాక అచ్చి. తూ నిత్యజీవం పొందిమంచిబుల్నే ఆజ్ఞానెకు పాటించిమంచి” బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“కే ఆజ్ఞానె?” బులి సే బెండకుర్ర పొచ్చరిసి. యేసు, “మనమకు మొరదిన్నాసి, దర్నిపైటి కొరినాసి, సొరొపైటి కొరినాసి, సొరొ సాక్సం కొయినాసి. ");
INSERT INTO rei_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","మాకు బోకు గౌరవించిమాసి. తోపనికిరాక తో పొరుగులింకు ప్రేమించిమంచి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","సే బెండకుర్ర, “మియి ఏ ఆజ్ఞలల్లా పాటించిలించి. యింకా కిరకొరిమంచి?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","సడకు యేసు, “తూ పరిపూర్నుడు ఈమాసి బులిగిన్నే, జేకిరి తో పక్కరె తల్లాట బిక్కికిరి నీలాలింకు దే! సాకిరి కొర్నే తొత్తె పరలోకంరె పలియ మిలుసి. సే తరవాతరె మెత్తె అనుసరించు” బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","సే బెండకుర్ర పక్కరె బడే పలియ తల్లందరె యేసు కొయిలాట సునికిరి విచారంసంగరె బాజేసి. ");
INSERT INTO rei_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","సే తరవాతరె యేసు తా సిస్యునెసంగరె, పలియ తల్లలింకె పురువురొ రాజ్యంబిత్తురుకు అయివురొ బడేకొస్టొ బులి మియి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","మియి యింకా కొయిలించి. పలియతల్లాట పురువురొ రాజ్యంబిత్తురుకు జెవురొకన్నా, ఒంటి సూదిబెజ్జంతీకిరి దూరిజెవురొ సులువు బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","సిస్యునె ఏ కొత సునికిరి బడే ఆచ్చర్యపొడిసె, “ఈనె కేసె రక్సన పొందుపారె?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","సెల్లె యేసు తంకాడుకు దిక్కిరి, “అడ మనమకు అసాద్యమాక ఈనె పురువుకు సొబ్బి సాద్యమాక” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","సెల్లె పేతురు, “తో పోచ్చాడె అయితె అమె సొబ్బి సడదిపించో. ఈనె, అముకు కిర మిలివో?” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","యేసు, నో ప్రపంచంరె మనమరొ పో తేజోవంతుడుయికిరి సింహాసనమంపరె బొసురుసి. మో పొచ్చాడె అయిలా తొమ్మంకా పన్నెండు సింహాసనాలు ఉంపరె బొసిరికిరి ఇస్రాయేలు మనమానెబిత్తరె పన్నెండు గోత్రాలులింకు తీర్పుకొయిసో బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","మో నా కోసం గొరొనెకన్నా, అన్నబయినెకన్నా, అప్పబొయినినెకన్నా, మా, బోకన్నా, పిల్లానుకు, బిల్లోనెకన్నా సడిదిగిల్లాలింకె సడకు సోయి వంతులు పలం నిత్యజీవం కూడా పొందిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ఈనె అగరె తల్లాలింకె బిత్తరె బడేలింకె పొచ్చుకు జూసె. పొచ్చాడె తల్లాలింకె బిత్తరె బడేలింకె అగురుకు ఆసె! బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","పురువురొ రాజ్యొ యాకిరి అచ్చి. గుటె ద్రాక్సతొట యజమానిసంగరె పొలికిరి అచ్చి. గుటెబెల్లె తొటరె పైటి కొరితె పైటిలింకు డక్కిమంచి బులి సొక్కలాక ఉటికిరి జేసి. ");
INSERT INTO rei_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","సే దినె పైటి కొరిలాలింకు గుటె వెండినానెం దూంచిబులి ఒప్పిగీకిరి తంకు తా ద్రాక్సతొటకు పొడదీసి. ");
INSERT INTO rei_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","సెయ్యె సొక్కలె తొమ్మిదిగంటలకు యింకా సొంతకు జేసి. సెట్టె కుండె మనమానె సుచ్చరాక టారికిరి రొవ్వురొ దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","సెయ్యె తంకెసంగరె తొమె కూడా జేకిరి ద్రాక్సతొటరె పైటి కొరొండి. తొముకు కూడ సమానంగా కూలి దూంచి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","తంకె సడకు అంగీకరించికిరి జేసె. సెయ్యె పన్నెండు గంటలయిలాబెల్లె, ఈనె తినిగంటలయిలబెల్లె కూడా జేకిరి యింకా సాకిరాక డక్కిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","సెయ్యె ఇంచుమించు పాట గంటలయిలాబెల్లె జేకిరి యింకా కుండె మనమానె సెట్టె టారికిరి తవ్వురొ గమనించిసి. సెయ్యె తంకెసంగరె తొమె దినొల్లా కిచ్చినాకొరుకుంటా కిరుకు ఎట్టె టారిసొ? బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","అముకు పైటికొరితె కేసే డక్కిలానింతె బులి తంకె సమాదానం కొయిసె. సెల్లె సెయ్యె తంకదీకిరి తొమె కూడా మో ద్రాక్సతొటరె పైటి కొరొండి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","సొంజైలాబెల్లె సే ద్రాక్సతొటరొ యజమాని తా అదికారి సంగరె పైటిలింకల్లకు డక్కికిరి చివరకు దీకిరి అయిలలింకె సంగరె మొదలుకొరికిరి కూలి దీపో బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","పంచ గంటయిలబెల్లె పైటి మొదలు లొగిల పైటిలింకె అయిసె. తంకు గుటె వెండినానెం దీసి. ");
INSERT INTO rei_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","అగరె పైటి మొదలు లొగిలలింకె అయికిరి తంకు బడేకూలి ఆసి బులికిరి ఆసపొడిసె. ఈనె తంకు కూడా గుటె వెండినానెం మిలిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","తంకె కూలి కడిగీకిరి అదికారి ఉంపరె సొనిగ్గిల్లీసె, ");
INSERT INTO rei_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","కొరకు బరించికిరి దినల్లా పైటికొరిల అముకు, గుటె గంట పైటి కొరిలాలింకు సమానంగా కిరుకు దిగిలీసు? ");
INSERT INTO rei_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ఈనె సెయ్యె జొనె కూలిపైటిమనమ సంగరె, స్నేహితుడా సును తొత్తె కిచ్చి అన్యాయం కొరిలాని. గుటె దినొకు గుటె వెండినానెం కు పైటి కొరుంచొ బులి తువ్వు ఒప్పిగిచ్చునీనా. ");
INSERT INTO rei_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","తో కూలి కడిగీకిరి బాజా! మో ఇస్టం తొత్తెదిల్లా కూలి అంకా పొచ్చాడె అయిలాలింకు కూడా దిమ్మాబులిగించి. ");
INSERT INTO rei_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","మో పలియ మో ఇస్టంమైలపనికిరి కర్చుకొరిలా అదికారం మెత్తె నీనా? మియి బొల్ట యివురొ తువ్వు వోదర్చినారిలిసునా? బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“యారక పొచ్చాడె రొల్లాలింకె అగురుకు ఆసె; అగరె రొల్లాలింకె పొచ్చాడుకు జోసే” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","యేసు యెరూసలేముకు జెమ్మాసి బులిగిల్లాబెల్లె పన్నెండు మంది సిస్యునెకు పక్కరకు డక్కికిరి యాకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","అం సొబ్బిలింకె యెరూసలేముకు జెల్లించొ. సెట్టె మనమరొ పో ప్రదానయాజకూనెకు, దర్మసాస్త్ర పండితునెకు అప్పగింపబొడువొ. తంకె తాకు మొర్నొసిక్స పొక్కిరి, ");
INSERT INTO rei_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","తాకు యూదునెనీలాలింకు అప్పగించుసె ఇంకా హేలన కొరికిరి, కొరడా మడ్డోనె మరికిరి సిలువకు పొగుసె. ఈనె తింటొదిన్రె సెయ్యె సజీవంగా ఉటికిరి ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","సే తరవాత జెబెదయి నైపో తా దీలింకె పోనె మిసికిరి యేసు పక్కు అయికిరి తా అగరె ముడుకూనె పొక్కిరి గుటె కొతా దేబులికిరి కోరిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","యేసు, “తొత్తె కిర కావాలి?” బులి ఎంట్రాక పొచ్చరిసి. సెయ్యె, తో రాజ్యంరె, మో దీలింకె పోనుకు జొనుకు తో‍ బత్తొకైలా అత్తొ పొక్కరె యింకజొనుకు తో బాఅత్తో ఆడుకు తల్లాపనికిరి కొతా దే బులి మగిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","సడకు యేసు, “తొమె కిడ పొచ్చిరిలీసొ తొముకు తెలిసిని. మో గిన్నెరె పురువురొ కస్టానె పూరికిరి మియ్యి పీతందుకు సిద్దంగా అచ్చి. తొమె పీపారొనా?” బులి పొచ్చిరిసి. పీపారొ బులి తంకె సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","సెయ్యె తొమె గిన్నెరొట పీపారొ ఈనె మో బత్తొకైల అత్తొ ఆడుకు, బా అత్తొ ఆడుకు బొసరదివురొ మో వసమురెనియ్యి. మో బో కా కోసం సిద్దపరిచివోయొ తాకాక సడ మిలివొ బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","మిగిల్లా దొస్టలింకె సిస్యునె ఎడ సునికిరి సెటెరొల్ల దీలింకె బయినె ఉంపరె రగ్గొపొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","యేసు తంకు పక్కు డక్కికిరి, “యూదునెనీలాలింకె రొజానె పనికిరి తంకె మనమ ఉంపరె అదికారం చెలాయించుకుంటా తాసె బులి తొముకు తెలుస్సు. ");
INSERT INTO rei_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ఈనె తొమె సాకిరి తన్నాసి. తొంబిత్తరె గొప్పమనమా ఈమాసిబులిగిల్లాట తొముకు సేవకుడుగా తమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","తొంబిత్తరె ముక్యుడుగా తమ్మాసిబులిగిల్లామనమ దాసుడుగా తమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","సాకిరాక మనమరొ ‘పో’ సేవ కొరిపించిగిత్తె అయిలాని గాని, సేవకొరితె అయిసి. సొబ్బిలింకు యిడిపించితె కోసం తా పొర్నొకు గుటె వెలగా చెల్లించితె అయిసి” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","యేసు, తా సిస్యునె యెరికో పట్నం తీకిరి బయలుదేరికిరి జేతల్లాబెల్లె బడే మంది మనమానె తా పొచ్చాడెజేసే. ");
INSERT INTO rei_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","బట్టొ పొక్కరె బొసిరిలా దీలింకె గుడ్డిలింకె యేసు సే బట్టరె అయిలీసి బులి సునికిరి, “దావీదు పో ప్రబూ అముకు కరునించు” బులి గట్టిగా కేకానె పొగిసె. ");
INSERT INTO rei_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","మనమానె తంకు సూతురోండి బులికిరి కొయిసె. ఈనె సే గుడ్డిలింకె యింకా గట్టిగా, “ప్రబూ! దావీదు పో! అమంపరె దయ దిగిపించు!” బులి బొట్ట కేకానె పొగిసె. ");
INSERT INTO rei_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","యేసు టారికిరి సే గుడ్డిలింకు డక్కికిరి, “మీ తొముకు కిర కొరిమాసిబుల్లీసో?” బులి పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ప్రబూ! అముకు అంకీనె దిగదిమ్మంచి! బులి తంకె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","యేసు తంకె ఉంపరె దయ కలిగికిరి తంకె అంకీనె సూగిచ్చి ఎంట్రాక తంకు అంకీనె దిగదీసె ఈనె తంకె తాకు వెంబడించిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","యేసు, తా సిస్యునె యెరూసలేముకు జేకిరి ఒలీవ బొనొ పక్కరె బేత్పగే బుల్లా గాకు చేరిగిచ్చె. యేసు తా సిస్యునె బిత్తరె దీలింకు సే గాకు పొడిదీకుంటా తంకు యాకిరి కొయిసి, ");
INSERT INTO rei_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","గాబిత్తురుకు జాండి సెట్టె దోరె బందిలా గుటె గొద్దొ, సడ పిల్లకు దిగివొ. సడానుకు పిటికిరి మో పక్కు వొడిగీకిరి అయిండి. ");
INSERT INTO rei_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","కేసన్నా పొచ్చిరినే, అడ ప్రబువుకు కావాలిబులి కోండి; సడ అవసరం తీరిలా ఎంట్రాక బుల్లీకిరి పొడదూ బులి కోండి. ");
INSERT INTO rei_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ప్రవక్త కొయిలా కొతా సొత్తెయితె యాకిరి జరిగిసి, ");
INSERT INTO rei_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","దిగూ “తో రొజా దీనుడైకిరి గొద్దొ, గొద్దొపిల్ల ఉటికిరి అయిలీసి” బులి సీయోను జో దీకిరి కోండి. ");
INSERT INTO rei_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","సెల్లె సిస్యునె జేకిరి యేసు ఆజ్ఞాపించిలాపనికిరి కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","గొద్దొకు, గొద్దొపిల్లకు కొడిగి అయికిరి సడ ఉంపరె తంకె కొన్నానె యించిసె యేసు సడంపరె ఉటికిరి బొసిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","సెటెతల్లా తంకెదీకిరి బడేమంది తంకె కొన్నానుకు, గొచ్చొన్రొ కొమ్మానె బట్టొరె యించిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","తాకు అగరె, పొచ్చాడె సలిలా మనమానె యాకిరి కేకానె పొగిసె. దావీదు పోకు మహిమ! ప్రబువు నారె అయిలాటకు సర్వోన్నతమైలా చోటూన్రె జయం బులి పురువుకు స్తుతించిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","యేసు యెరూసలేమునకు జేసి. సే గాఅల్లా ఆందోలన చెలరేగిసి, “ఎయ్యె కేసె?” బులి మనమానె పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“ఎయ్యె యేసు, గలిలయరె తల్లా నజరేతు గాకు చెందిలా ప్రవక్త” బులి తా పొచ్చాడె తల్లాలింకె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","యేసు మందిరంబిత్తురుకు జేకిరి, సెట్టె బిక్కిగిల్లాలింకు, గినిగిల్లాలింకు దోరకు పొడిదీపీసి. పలియ మార్చిలాలింకు బల్లానుకు, పావురాలు బిక్కిలాలింకురొ పిటముకు పొక్కదీసి. ");
INSERT INTO rei_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","సెయ్యె తంకు, యెడ “‘మో మందిరం సొబ్బిలింకూ ప్రార్దనాలయం’ గా తాసి బులిసి. ఈనె తొమె సడకు దోచిగిల్లా సొరొనె గొరొపనికిరి మార్చిపీసొ” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","అంకీనె నిలాలింకె, కుంటిలింకె మందిరంరె తల్లా తా పక్కరకు అయిసె. సెయ్యె తంకు బొలికొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ప్రదానయాజకూనె, సాస్త్రీనె సెయ్యె కొరిలా అద్బుతానె దిగిసె. మందిరం అగరె తల్లా పిల్లానె, “దావీదు పోకు జయం” బులి కేకానె పొగివురొ సునిసె. తంకు రగ్గొ అయిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“సన్ని పిల్లానె కిరబుల్లీసెవొ తువ్వు సునుసునా?” బులి తంకె యేసుకు ప్రస్నానె పొగిసె. సడకు యేసు, “సునించి, సన్నిపిల్లానె, పసిపిల్లానె కూడా తొత్తె స్తుతించిలాపని కొరు! బులి లేకనాల్రె రాసికిరి అచ్చి. ఎడ తొమె కెబ్బే చదివిలానింతోనా?” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","సెయ్యె తంకు సడదీకిరి, పట్నం బయల్రె రొల్లా బేతనియ గాకు జేకిరి సే రత్తిల్లా సెట్టె గడిపిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","సొక్కలెపైలా తరవాతరె సెయ్యె బుల్లికిరి పట్నం బిత్తరకు అయితన్నుగా తాకు బొక్కిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","యేసు బట్టొ పక్కరె తల్లా గుటె అంజూరొ గొచ్చొకు దిక్కిరి సడ పక్కుజేసి. ఈనె తాకు ఆకూనె తప్ప యింకా కిచ్చి మిల్లానీ. సెయ్యె సే గొచ్చొ సంగరె, యింకా కెబ్బుకు పొగలానె దిన్నారు బులిసి. ఎంట్రాక సే అంజూరొ గొచ్చొ సుక్కిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","సిస్యునె సడ దిక్కిరి బడే ఆచ్చర్యపొడిసె, “అంజూరొ గొచ్చొ ఎత్తెబేగ క్యాకిరి సుక్కిజేసి?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","యేసు, “ఎడ సొత్తాక తొమె అనుమానం నాపొడుకుం‍టా విస్వసించినె మియి అంజూరొ గొచ్చొకు కొరిలాపని తొమ్మంకా కొరిపారొ. సెత్తె మాత్రమాక నీ, ఏ బొనుకు, తువ్వు ఉటికిరి సోంద్రొరె పొడుబుల్నే; సడ సాకిరాక ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","పురువు తొమె పొచ్చిరిలాంచ దూసి బులి విస్వాసం సంగరె ప్రార్దన కొరండి. సెల్లె తొమె కిరమగినె సడ మిలుసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","యేసు మందిరంరె బోదించితల్లాబెల్లె ప్రదానయాజకూనె, బొడిలింకె అయికిరి, కే అదికారం సంగరె తువ్వు ఏ పైటినె కొరిలీసు? తొత్తె అదికారం కేసె దీసె? బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","యేసు సమాదానం కొయికిరి, “మియ్యి తొముకు గుటె ప్రస్న పొచ్చరుంచి. తొమె కొయినె మియి ఎడ కే అదికారం సంగరె కొరిలించొ కోంచి. ");
INSERT INTO rei_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","బాప్టీసం దిల్లా యోహానుకు కేసె పొడదీసే? పురువునా? మనమానె నా?”బులి పొచ్చరిసి. తంకె, “పురువు” బులి కొయినె తాకు కిరుకు నమ్మిలానింతొ? బులి పొచ్చరివొ. ");
INSERT INTO rei_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","మనమానె బులి కొయినె మనమనల్లా యోహాను జొనె ప్రవక్త బులి నమ్మిసె. ఈనె తంకె కిర కొరుసెవొ బులి డొరొసంగరె జొనుకు జొనె కొతలగ్గిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","సడకు తంకె, “అముకు తెలిసినీ” బులి కొయిసె. ఈనె, తొముకు మియి కే అదికారం సంగరె కొరిలించివొ కొయినీ బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ఉంచినె ఆలోచించికిరి కోండి. జొనుకు దీలింకె పోనె రొయితవ్వె. సెయ్యె బొడు పో పక్కరకు అయికిరి, పో! ఆజి జేకిరి ద్రాక్సతొటరె పైటి కొరుబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","సెయ్యె, మెత్తె ఇస్టంనీబులి కొయిసి. ఈనె ఎంట్రాక మనుసు మార్చిగీకిరి జేసి. ");
INSERT INTO rei_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","సెల్లె బో తా దీటో పో పక్కరకు అయికిరి సే విసయం కొయిసి. సే పో జెమ్మి బులి కొయికిరి జెల్లాని. ");
INSERT INTO rei_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","సే దిలింకె బిత్తరె కేసె బో కొత సునుసే? బులి యేసు పొచ్చిరిసి. తంకె బొడు పో బులిసె. యేసు తంకె సంగరె యాకిరి కొయిసి. మియి తొముకు సొత్తె కొయిలించి. సుంకరీనె, దర్నీనె తొం కన్నా అగరె పురువురో రాజ్యంకు జోసే. ");
INSERT INTO rei_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","యోహాను నీతిరొ బట్టొ దిగదీతె అయిసి. తొమె తాకు నమ్మిలానింతొ. ఈనె సుంకరీనె, దర్నినె తాకు నమ్మిసె. సడకు దిక్కిరంకా తొమె మనుసుమారిలానీ, విస్వసించిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","యింగుటె ఉపమానం సునొండి. జొనె యాజమాని రొయితవ్వి. సెయ్యె గుటె ద్రాక్సతొట నాటికిరి చుట్టూ గోడ బందిపించికిరి ద్రాక్సరసం కడితె గానుగ తొట్టుకు బందిపించిసి. జొగులొ జొగితె గుటె మంచె కొరుపించిసి. తరవాతరె తొట రైతులుకు దీకిరి దూరు ప్రయానంకు బాజేసి. ");
INSERT INTO rei_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","కట్టిలాదినొ అయిలాబెల్లె తా సేవకునెకు సే రైతులు పక్కరకు జేకిరి వాటా దరిగి అయిబులి పొడిదీసి. ");
INSERT INTO rei_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","సే రైతులు, సే సేవకుడుకు దరిగీకిరి జొనుకు మరిసె, జొనుకు మొరిదీసె, జొనుకు పొత్రొనె సంగరె మరిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ఆసామి యేసారి అగరె కన్నా బడేలింకు సేవకునెకు పొడిదీసి. తంకు కూడా సాకిరాక కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","సే ఆసామి ఆకరువురె తా పోకు గౌరవించుసెబులి బులిగీకిరి ఆకరువురె తా పోకు తంకె పక్కరకు పొడిదీసి. ");
INSERT INTO rei_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ఈనె సే రైతులునె తా పోకు దిక్కిరి ఎయ్యె వారసుడు. యాకు మొరదీకిరి తా ఆస్తికు కడిగిమంచి బులిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","సే తరవాతరె పోకు దరిగీకిరి మొరిదీకిరి ద్రాక్సతొట పొచ్చాడె పోదిపీసె. ");
INSERT INTO rei_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“సే ద్రాక్సతొట యజమానుడు అయికిరి సే రైతులుకు కిర కొరువొ?”బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","యజమాని సే దుస్టులుకు కచ్చితంగా మొరిదిపీవొ. పచ్చకలొరె తా బాగంకు తాకు దిల్లాలింకు సే ద్రాక్సతొటకు దూంచి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","యేసు తంకె దీకిరి యాకిరి కొయిసి గొరొ బందిలలింకె తిరస్కరిచిలా పొత్రొ సడకు ముక్యమైల పొత్రొవూసి. సడ ప్రబూ వల్లరె కలిగిలాట బులి సడ అంకీనెకు ఆచర్యమైలాటబులి తొమె కెబ్బె లేకనానె కొయిలాపని కెబ్బే చదివిలానింతోనా? ");
INSERT INTO rei_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","సడకు మియ్యి కొయిలాట కిరబుల్నే పురువు తా రాజ్యంకు తొమె పక్కరెదీకిరి కడిగికిరి, సే రాజ్యంకు బొల్ట పలం పలించిలాలింకు దూసి. ");
INSERT INTO rei_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ఈనె యే పొత్రొ ఉంపరె పొడిలాలింకె ముక్కలు ఈజుసె. కా అంపరె యే పొత్రొ పొడివోయో సెయ్యె నలిగిజివ్వొ. ");
INSERT INTO rei_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ప్రదానయాజకూనె, పరిసయ్యునె యేసు కొయిలా ఉపమానం సునికిరి సెయ్యె తంకె గురించి కొతలగిలపనికిరి గ్రహించిసె. ");
INSERT INTO rei_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","సెల్లె తంకె తాకు బందించితె సమయం కుజ్జిలీసె. ఈనె మనమానె తాకు జొనె ప్రవక్త బులిగిచ్చె గనక మనమానుకు దిక్కిరి డొరిజీసె. ");
INSERT INTO rei_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","యేసు ఉపమానాలు ఉపయోగించికిరి యాకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","పురువురొ రాజ్యంరె జొనె రొజా తా పోరొ బ్యా సందర్బంగా కద్దీనె కొరిలాటకు పోలికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","సే రొజా కద్దినెకు ఆహ్వానించిలాలింకు డక్కితె తా సేవకునె పొడిదీసి. ఈనె తంకె అయితె ఇస్టపొడిలనింతె. ");
INSERT INTO rei_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","సే రొజా కుండిలింకు సేవకునెకు పొడదీకిరి డక్కిలాలింకు కద్దీనె సిద్దంగా అచ్చి బులి కోండి. ఎద్దునెకు, బొల్లే బలిసిలా పసువునుకు కట్టికిరి సొబ్బీ తయారు కొరించొ బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ఈనె డక్కిలాలింకె లెక్క కొరిలానింతె. జొనె తా కొలకు, యింకాజొనె వ్యాపారంకొరిగితె బాజీసె. ");
INSERT INTO rei_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","మిగిల్లాలింకె సేవకునెకు దరిగీకిరి అవమానం కొరికిరి మొరిదీసె. ");
INSERT INTO rei_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","సే రొజాకు బడే రగ్గొ అయికిరి తా సైన్యముకు పొడదీకిరి సే హంతకులుకు నాసనం కొరికిరి, తంక పట్నంకు పుడ్డిపేసి. ");
INSERT INTO rei_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","సే తరవాతరె సేవకునె సంగరె, బ్యాకద్దీనె సిద్దంగా అచ్చి గాని మియి డక్కిలాలింకె అర్హులు నీ. ");
INSERT INTO rei_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ఈనె సెయీనంట జేకిరి తొముకు దిగిదిల్లాలింకల్లాకు బ్యాకద్దినెకు డక్కొండి బులి తా సేవకునె సంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","సే సేవకునె సెయీనె మొజుకు జేరికి తంకు దిగిదిల్ల బొల్టలింకు, చెడ్డలింకు, సొబ్బిలింకు డక్కిగీకిరి అయిసె. సే గొరొల్లా బ్యా విందుకు అయిలాలింకు సంగరె పూరిజేసి. ");
INSERT INTO rei_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","రొజా చుట్టాలకు దిగితె అయిసి. సెటె రొల్లాలింకె బిత్తరె జొనె బ్యా కొన్నానె నాపొగ్గికుంటా బొసికిరి తల్లాట సెయ్యె దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","స్నేహితుడా! బ్యా కొన్నానె నాపిందిగీకుంటా బిత్తరుకు క్యాకిరి అయిసు? బులి రొజా తాకు పొచ్చిరిసి. సే మనమ కిచ్చి నాకొతలక్కుంటా సూతిరికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ఎంట్రాక సే రొజా తా సేవకుల సంగరె, తా గొడ్డోనె, అత్తోనె బందికిరి వొందార్రె పొక్కదేండి. సెట్టె సెయ్యె కందికుంటా, దంతోనె కముడుకుంటా బాదకు అనుబవించుసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“పురువు బడేలింకు ఆహ్వానించిసి. ఈనె బచ్చిగిల్లాలింకె కుండిలింకె మాత్రమాక” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","సే తరవాతరె పరిసయ్యునె జేకిరి తాకు తా కొతాన్రె తప్పుదరిగిమంచి బులి ఆలోచన సంగరె యేసుకు ప్రస్నించిసె. ");
INSERT INTO rei_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","సెల్లె తంకె పరిసయులురొ సిస్యునెకూ, హేరోదురొ మనమానుకు కుండెలింకు పొడదీకిరి “బోదకుడా తూ సత్యవంతుడు బులి, పురువురొ బట్టొ తల్లాట తల్లాపనికిరి కొయిలీసు బులి అముకు తెలుస్సు. పొదరిలింకె కొతానె లెక్క కొరును బులి మొగమాటం దిగిపించునూబులి అముకు తెలుస్సు. ");
INSERT INTO rei_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ఈనె రోమా చక్రవర్తికు పన్నునె బందివురొ అం నియమం ప్రకారం దర్మంనా? నీనా? తో అబిప్రాయం కో” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","యేసుకు తంకె ఆలోచన బుజ్జికిరి, వేసం పొగ్గిల్లాలింకె! మెత్తె కిరుకు పరీక్సించిలీసో? బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","తొమె కే నానెం సంగరె పన్నునె బందిలీసెవొ మెత్తె దిగదేండి బులి కొయిసి. తంకె గుటె కాసు దన్నయికిరి తాకు దీసె. ");
INSERT INTO rei_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","సెయ్యె, ఎడ ఉంపరె రొల్లా “ఏ బొమ్మ, అక్సరాలు కాట?” బులి తంకు పొచ్చిరిసి. తంకె “సడ రోమా చక్రవర్తిరోట” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","సెల్లె సెయ్యె వెంట్రాక, “సాకిరియినె చక్రవర్తిరోట చక్రవర్తికు, పురువురోట పురువుకు చెల్లించొండి” బులి తంకసంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","యెడ సునికిరి బడే ఆచ్చర్యపొడికిరి తాకు సడిదీకిరి బాజీసె. ");
INSERT INTO rei_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","సే దినాక, సద్దూకయ్యునె యేసు పక్కు అయికిరి మొరిజిల్లాలింకె జీకిరి అయినింతె బులి వాదించిలాలింకు యాకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“బోదకా! జొనెమొట్ట పిల్లానె నీకిరి మొరిజిన్నే, తా బయి సే వితంతువుకు బ్యా కొరిగీకిరి మొరిజిల్లా అన్నకు సంతానం కలిగించిమాసిబులి మోసే కొయిసినీనా బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","అంబిత్తరె ఏడుగురు బయినె గుటె కుటుంబంరె అచ్చె. అగరె రొల్లట బ్యా కొరిగీకిరి పిల్లానె నీకుంటా మొరిజేసి. ఈనె సే వితంతువుకు మొరిజిల్లాటరొ బయి బ్యా కొరిగీసి. ");
INSERT INTO rei_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","సాకిరాక అగరోట, తింటొట, ఏడుగురు కూడా సాకరాక తాకు బ్యా కొరిగీకిరి పిల్లానెనీకుంటా మొరిజీసె. ");
INSERT INTO rei_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","చివరకు సే మొట్ట కూడా మొరిజీసి. ");
INSERT INTO rei_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ఈనె ఉంచినె సే ఏడుగురు సే మొట్టకు బ్యా కొరిగిచ్చెనీ, ఈనె పునరుత్తానం తరవాతరె సెయ్యె సే ఏడుగుర్రె కాకు నైపోగా తాసి?” ");
INSERT INTO rei_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","యేసు తంకె సంగరె “తొముకు లేకనానె గాని పురువురొ సక్తి గాని నాజనికిరి అపార్దం కొరిగిల్లీసొ. ");
INSERT INTO rei_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","పునరుత్తానంరె బ్య కొరిగివురొ గాని, నాకొరివురొ గాని తన్నీ. తంకె పరలోకంరె దేవదూతానెపనికిరి తాసె. ");
INSERT INTO rei_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ఈనె మొరిజిల్లాలింకె జీవురొ కోసం పురువు తొముకు కిర కొయిసివొ తొమె చదివిలానింతోనా? బులి సెయ్యె పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘మియ్యి అబ్రాహాముకు పురువు, ఇస్సాకుకు పురువు, యాకోబుకు పురువు’ బులి కొయిసి. మియి మొరిజిల్లాలింకు పురువు నీ, జీలాలింకాక మియి పురువు.” ");
INSERT INTO rei_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","సెల్లె యే బోద సున్లాలింకల్లా ఆచ్చర్యపొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","సెల్లె యేసు సద్దూకయ్యునెరొ తుండొ బుజ్జిపించిసి బులి పరిసయ్యునె సునికిరి పక్కరకు అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","తంకె బిత్తరె జొనె దర్మసాస్త్రపండితుడు తాకు పరిక్సించిమాసిబులి ప్రస్నించిసి, ");
INSERT INTO rei_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","బోదకా! దర్మసాస్త్రమురె ఆజ్ఞానెరె కే ఆజ్ఞ ముక్యుమైలాట బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","యేసు “తో బొల్ట హ్రుదయం సంగరె, తొ బొల్ట ఆత్మ సంగరె, బొల్ట బుద్ది సంగరె తో ప్రబువైలా పురువుకు ప్రేమించొండి. ");
INSERT INTO rei_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ఎడ సొబ్బి ఆజ్ఞలకన్నా ఏ ఆజ్ఞ గొప్పీట ముక్యమైలాట. ");
INSERT INTO rei_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","దీటొ ఆజ్ఞ కూడా సాటకా,‘తోపనాక తో పొరుగుతాకంకా ప్రేమించెమంచె.’ ");
INSERT INTO rei_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","మోసే దర్మసాస్త్రంరె ఈనె ప్రవక్తానెరొ బొదానల్లా యే దీట ఆజ్ఞనె ఉంపరె ఆదారపొడికిరి అచ్చి.” ");
INSERT INTO rei_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","యింగుటె సారి పరిసయ్యునె కూడిగీకిరి, యేసు పక్కు అయిలాబెల్లె తంకు యాకిరి పొచ్చరిసి, ");
INSERT INTO rei_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“తొమె క్రీస్తు గురించి కిర బులిగిల్లీసొ? సెయ్యె కా పో?” బులి పొచ్చిరిసి. “దావీదు పో” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","యేసు తంకె దీకిరి ఈనె దావీదు పురువు ఆత్మసంగరె కొతలక్కిరి ప్రబూ బులి కిరుకు డక్కిసి? ");
INSERT INTO rei_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ప్రబువు, మోప్రబువు సంగరె తో సత్రువునె తొ గొడ్డొ అగరె పొయిదిల్లాజాంక, మో కైయిలత్తొ ఆడుకు బొసురొసి బులి కొయిలానీనా. ");
INSERT INTO rei_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ఈనె దావీదు తాకు ప్రబూ బులి డక్కితల్లాబెల్లె సెయ్యె తాకు క్యాకిరి పో ఊసి? బులి తంకు పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","కేసె కిచ్చి కొయినారిసె. సే దినోదీకిరి తాకు కే ప్రస్నానె పొచ్చిరితందుకు కాకు దైర్యం చాల్లానీ. ");
INSERT INTO rei_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","సే తరవాతరె యేసు మనమానె గుంపుసంగరె, సిస్యునె సంగరె యాకిరి బులిసి, ");
INSERT INTO rei_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","సాస్త్రులూనె, పరిసయ్యునె మోసే దర్మసాస్త్రంకు తంకాక బోదించితె అదికారం అచ్చిబులి కొతలగ్గిలీసె. ");
INSERT INTO rei_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","సడకు తంకె తొముకు కొయిలాటల్లా సునికిరి విదేయత సంగరె కొరొండి. ఈనె తంకె బోదించిలాట తంకె ఆచరించినింతె గనక తంకె కొరిలంచ కొరితెనాండి. ");
INSERT INTO rei_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","నాబొయినార్లా గొబిరీనె తంకె మనమానెరొ కందొనె ఉంపరె లొగుసె, ఈనె తంకె సే గొబిరికు సిటికినంగిలిసంగరంకా సాయం కొర్నింతె. ");
INSERT INTO rei_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","తంకె మనమానె దిగిలాపనికిరి పైటీనె కొరుతోసె పురువురొ బొట్ట వాక్యమునె రాసిగీకిరి ముండొకు అత్తోనుకు రక్సరేకునె బందిగుచ్చె, బొట్ట అంచు యీల కొన్నానె పిందిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","కద్దీన్రె, సబాస్దలాల్రె ముక్యమైలా చోటున్రె బొసివురొబుల్నే తంకు బడే ఇస్టం. ");
INSERT INTO rei_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","సొంతసెయీన్రె, మనమానె తంకు ఉలంగదిమ్మంచిబులి, ఈనె గురువు బులి డక్కిపించిగివురొ తంకు ఇస్టం. ");
INSERT INTO rei_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","తొమె మాత్రం గురువు బులి డక్కిపించిగిత్తెనాండి. తొమల్లా అన్న బయినె గనక “తొం సొబ్బిలింకు బోదకుడు జొన్నాక.” ");
INSERT INTO rei_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ఈనె యే బూమంపరె కాకు తొమె “బో” బులి డక్కితెనాండి. పరలోకంరె తల్లా పురువు జొన్నాక తొం బో. ");
INSERT INTO rei_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","సాకిరాక తొమె నాయకుడు బులి డక్కిపించిగిత్తెనాండి. క్రీస్తు జొన్నాక నాయకుడు. ");
INSERT INTO rei_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","తొంబిత్తరె గొప్పీట తొముకు సేవకుడుపని తమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","తాకు సెయ్యె గొప్ప కొయిగిల్లాలింకు పురువు తగ్గించిపీవో. తగ్గించిగీకిరి తల్లాలింకు పురువు గొప్ప కొరుసి. ");
INSERT INTO rei_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","వేసదారులైలా సాస్త్రులూనె, పరిసయ్యునె తొముకు బడేస్రమ. పురువురొ రాజ్యంకు మనమానె నాజనికుంటా బట్టో బుజ్జిపీలీసొ. తొమె జెన్నింతొ, జమ్మా బులిగిల్లాలింకు జేపించిలీనింతొ. ");
INSERT INTO rei_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","రండిలింకు తొముకుఅనుకూలంగా లోపర్చిగీకిరి తంకరొ గొరోనుకు దోచిగిల్లీసొ, దీర్గ ప్రార్దనలు కొరికిరి మనమానుకు మెప్పించిమాసిబులిగిల్లీసొ గనక తొమంపరకు గొప్ప సిక్స ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","వేసదారులైలా సాస్త్రీనే, పరిసయ్యునే, తొముకు‍ సిక్స తప్పినీ. జొనెమోపుకు తొంబిత్తరె మిసిగిత్తె దెసొనల్లా బుల్లికిరి తొంప్రయత్నం కొరిలీసొ. తీరా సెయ్యె మిసిలాబెల్లె తొంపనాక తాకంకా దీటొంతు నరకముకు పాత్రుడుగా కొరిలీసొ. ");
INSERT INTO rei_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","అంకీనె నీకుంటా పొదర్లింకు బట్టొదిగదిమ్మంచిబులిగిల్లాలింకే, తొముకు సిక్స తప్పినీ. కేసైనా మందిరం ఉంపరె ఒట్టు లొగినె నస్టొనీ, గుడిబిత్తరె సున్నంపరె ఒట్టు లొగినె సే ఒట్టుకు కట్టుబొడికిరి తమ్మంచి బులి తొమె కొయివొ. ");
INSERT INTO rei_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","తెలివి నీలా గుడ్డిలింకె, కిర గొప్పా? సున్ననా సున్నకు పవిత్రం కొరిలా గుడినా? ");
INSERT INTO rei_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ఈనె బలిపీటం వుంపరె ఒట్టు లొగినె, నస్టంనీ గని, సడంపరె తల్లా కానుకంపరె ఒట్టు లొగినే సే ఒట్టుకు కట్టుబొడికిరి తమ్మంచి. బులి తొమె బోదించిలీసొ. ");
INSERT INTO rei_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","గుడ్డిలింకె, కిర గొప్ప? కానుకనా? సే కానుకకు పవిత్రం కొరిలా బలిపీటంనా? ");
INSERT INTO rei_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","సడకు బలిపీటమంపరె ఒట్టు లొగినె, సడంపరె తల్లా సొబ్బిటంపరె ఒట్టు లొగిలాపనాకనీనా. ");
INSERT INTO rei_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","సాకిరాక మందిరం ఉంపరె ఒట్టు లొగినె, సడ ఉంపరె, తాండ్రెతల్లా పురువుంపరె ఒట్టు లొగిలాపనాకనీనా! ");
INSERT INTO rei_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","సాకిరాక పరలోకమంపరె ఒట్టు లొగినె సెట్టె తల్లా సింహాసనమంపరె, సే సింహాసనమంపరె బొసికిరితల్లా పురువుంపరె ఒట్టు లొగిలాపనాకనీనా! ");
INSERT INTO rei_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","వేసదారులైలా సాస్త్రులూనె, పరిసయ్యునే, తొమె మోసం కొరిలాలింకె. తొముకు సిక్స తప్పినీ. తొమె పుదీనా, సోపు, జిలకర్ర సొబ్బిటిరె దసమబాగం దూసొ. ఈనె దర్మసాస్త్రంరె తల్లా ముక్యమైలాంచ కిరబుల్నే న్యాయం, దయ, నమ్మకత్వం, యెడానె సొబ్బీ సడదీసె. అగరె సడకు నాసడుకుంటా తొమె యెడకు కొరుమాసి. ");
INSERT INTO rei_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","అంకీనె నీకుంటా బట్టొదిగదిమ్మంచి బులిగిల్లాలింకే, దర్మసాస్త్రంరె అవసరం నీలా సన్నీంచకంకా తొముకు తొమ్మాక అనుసరించిలీసొ, ఈనె అత్యవసరమైలాంచకు నాతెలిసిగీకుంటాక సడదిల్లీసొ. ");
INSERT INTO rei_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","సాస్త్రులూనె, పరిసయ్యునే, తొమె మోసం కొరిలాలింకె. తొముకు సిక్స తప్పినీ. తొమె ముంతకు, పల్లెముకు దోరె బొలుకొరుసొ, ఈనె బిత్తరె అత్యాస, స్వార్దము సంగరె అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","గుడ్డి పరిసయ్యునే, అగరె తొమె ముంతానెకు, పల్లెంకు బిత్తరె‍ సుబ్రం కొరొండి. సెల్లె బయెల్రెంకా సుబ్రంగా తాసి. ");
INSERT INTO rei_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","సాస్త్రీనే, పరిసయ్యునే తొమె మోసం కొరిలాలింకె. తొముకు సిక్స తప్పినీ. తొమె సున్నొమరిలా సమాదులుపనాలింకె. సడ బయలుకు అందంగా దిగదూసి. ఈనె బిత్తరె మొరిజిల్లాలింకెరొ పియ్యైజిల్లా అడ్డోనె పనికిరి కల్మసం దీకిరి తాసె. ");
INSERT INTO rei_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","సాకిరాక తొమె బయలుకు నీతిమంతునెపని దిగదూసొ. ఈనె బిత్తరె వేసదారన, పాపం సంగరె పూరికిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","వేసదారులైలా సాస్త్రీనే, పరిసయ్యునె తొముకు స్రమ. తొమె ప్రవక్తానె సమాదులు బందికుంటా, నీతిమంతునెరొ సమాదీనెకు అలంకరించిలీసొ. ");
INSERT INTO rei_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","సెత్తాకనీకిరి, అమె తాత ముత్తాతనె కలొరె జీకిరి రొన్నే, తంకె దీకిరి మిసికిరి ప్రవక్తానెకు మొరదీకుంటా రొయితమ్మోనీనా. ");
INSERT INTO rei_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ఈనె సొత్తాక తొమె ప్రవక్తానెకు మొరదిల్లా వంసముకు చెందిలాలింకె బులి అంగీకరించికిరి తొముకు తొమ్మాక సాక్సం కొయిగిల్లీసొ. ");
INSERT INTO rei_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","తొం తాత ముత్తాతలు మొదలు కొరిసె. తొమె ముగించొండి. ");
INSERT INTO rei_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","తొమె సప్పొ సంతానం పనికిరితల్లా ప్రమాదకరమైలా ద్రోహీనే, నరక సిక్స తీకిరి క్యాకిరి తప్పించిగిమాసిబులిగిల్లీసో? ");
INSERT INTO rei_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","తొమె పక్కు ప్రవక్తానెకు, తెలివిలింకెకు, దర్మసాస్త్ర బోదకునెకు పొడదిల్లించి. తంకబిత్తరె కుండెలింకు సిలువ పొగివొ. ఇంకుండెలింకు సబాస్దలం సొబ్బిలింకగరె కొరడా మడ్డోనె మరిపించువొ. కుండెలింకు గానె తీకిరి పొల్జిల్లాపనికిరి గొడ్డిమరుసొ. ");
INSERT INTO rei_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","నీతిమంతుడైలా హేబెలు రొగొతొ దీకిరి గుడికు బలిపీటముకు మొజిరె తొమె మొరిదిల్లా బరకీయ పో ఈలా జెకర్యా రొగొతొ జాంక యే బూమంపరె నీతిమంతుడు వొల్లికించిలా రొగొతొకల్లా తొమ్మాక బాద్యులు. ");
INSERT INTO rei_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","యెడ సొత్తాక. యేతప్పల్లా యేతరంలింకంపరాక పొడుసి బులి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ఓ యెరూసలేము, యెరూసలేము తువ్వు ప్రవక్తానెకు మొరదీసు పురువు తోపక్కరకు పొడదిల్లాలింకు తూ పొత్రొనె సంగరె మరిసు. కూడ తా పిల్లానుకు తా రెక్కానె తొల్లె నుచ్చిలాపని మియ్యి తొ పిల్లానుకు నుచ్చిమా బులి కెత్తో సారులు ఆసించించి. ఈనె తువ్వు అంగీకరించిలాను. ");
INSERT INTO rei_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ఇదిగొ దిగూ, పాడియిజిల్లా తో మందిరముకు పురువు కాలీగా తొముకు సడదీసి. ");
INSERT INTO rei_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ఉంచినె తీకిరి “ప్రబువు నారె అయిలాట స్తుతించబొడుమాసి” బులి తొమె కొయిలా జాంక మెత్తె దిగినింతోబులి తొముకు కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","యేసు మందిరంకి సడికిరి జేతల్లాబెల్లె తా సిస్యునె అయికిరి సే మందిరంకి బందిలాట గురించి తాకు దిగదీసె. ");
INSERT INTO rei_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","సడకు యేసు, తొమె ఎడల్లా దిగిలీసొనీ, ఎడ సొత్తాక. పొత్రొ ఉంపరె పొత్రొ నాతారుకుంటా తంకె సొబ్బీ పొడుజూసి బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ఈనె యేసు ఒలీవపొరొతొ ఉంపరె బొసిరిసి. తా సిస్యునె తా పక్కరకు అయికిరి, “కోండి; ఎడ కెబ్బె కెబ్బుకు జరుగుసి? తూ అయిలా అగరె, యే యుగం అంతమైతె అగరె కిర ఆనవాలు దిగదూసి?” బులి పొచ్చరిసె. ");
INSERT INTO rei_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","యేసు యాకిరి కొయిసి. తొముకు కేసే మోసం నాకొరికుంటా జాగర్తగా టారించి. ");
INSERT INTO rei_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","కిరుకు బుల్నే బడేమంది మో నారె అయికిరి మియ్యి క్రీస్తు బులి కొయికిరి బడేలింకు మోసం కొరివె. ");
INSERT INTO rei_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","యుద్దాలు గురించి, యుద్దాలు లగివురొ గురించి సున్లాబెల్లె తొమె దిగులు పొడితెనాండి. ఎడ కచ్చితంగ వూసి. ఈనె అంతం ఉంచినాక అయిని. ");
INSERT INTO rei_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","దెసొ ఉంపరకు దెసొ లగానెకు ఆసి. రాజ్యం ఉంపరకు రాజ్యం లగానెకు ఆసె. పల్లెగాన్రె కరువునె, బూకంపాలు ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ఈనె పిల్లానె జొర్నైలా బెల్లె అయిలా బొత్తానె పని తాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","సే తరవాతరె తంకె తొముకు అదికారినెకు అప్పగించుసె. సే అదికారినె తొముకు హింసలొక్కిరి మొరదూసె. మో నా కారనంగా దెసోనల్లా తొముకు ద్వేసించుసె. ");
INSERT INTO rei_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","సే సమయంరె బడేమంది యే విస్వాసం దీకిరి తొలుగుజుసె. జొనుకు జొనె త్రునీకరించిగీకిరి, ద్వేసించిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","సొరొప్రవక్తానె బడే మంది అయికిరి మనమానుకు మోసం కొరివె. ");
INSERT INTO rei_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","అదర్మము ఎక్కువైవురొ వల్లరె బడేలింకెరొ ప్రేమనీకుంటా యీజోసి. ");
INSERT INTO rei_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ఈనె విస్వాసంరె ఉంచినెతీకిరి అంతము జాంక సహించిగిల్లాటాకాక రక్సన మిలివొ. ");
INSERT INTO rei_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","పరలోక రాజ్యొ సువార్త మనమానుకల్లా సాక్సిగా దెసోనుకల్లా ప్రకటించబొడుసి. సెత్తెలె అంతం అయివొ. ");
INSERT INTO rei_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ఈనె ప్రవక్త ఈలా దానియేలు సంగరె కొయిలాట బయంకరమైలా హేయవస్తువు పరిసుద్దస్తలమురె టారివురొ తొమె దిగిలాబెల్లె చదివిలాట గ్రహించిమాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","సెల్లె యూదయ ప్రాంతంరె తల్లా మనమానె పొరొతంపరకు పొలిజివురొ బొల్ట. ");
INSERT INTO rei_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","మిద్దంపరె తల్లాట తా గొరొ బిత్తురుకు జేకిరి కిచ్చీ కడిగిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","బిల్లొరె తల్లాట తా కొన్నానుకు కడిగిత్తె పొచ్చుకు జెన్నాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","అయ్యో, సే దినొరె పనిదీగిల్లాలింకె, పురటాలు మొట్టానుకు బడే బాద కలుగుసినీ. ");
INSERT INTO rei_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","సే దినొరె బడే కొస్టోతాసి. ఈనె సిత్తొకలొరె గాని, ఈనె విస్రాంతి దినెరె గాని పొలిజివ్వలిసిలా గతయినాసి బులి ప్రార్దనకొరొండి. ");
INSERT INTO rei_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","స్రుస్టి ఆరంబం తీకిరి ఆజి జాంక సెత్తొ కొస్టోనె కెబ్బే అయిలాని. యింకెబ్బుకూ యీని. ");
INSERT INTO rei_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","పురువు సే దినొ లెక్క తక్కువ నాకొరినే, కేసే జీకిరి తయితెని. ఈనె పురువు సెయ్యె బచ్చిగిల్లాలింకె కోసం సే దినొ లెక్క తగ్గించుసి. ");
INSERT INTO rei_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","సే దినొరె తొంబిత్తరె కేసన్నా, ఇదిగొ దిగొండి క్రీస్తు ఎట్టె అచ్చి బులి గాని, నీనే, సెట్టె అచ్చి బులి గాని బుల్నే నమ్మితెనాండి. ");
INSERT INTO rei_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","కిరుకు బుల్నే సొరొ క్రీస్తునె, సొరొప్రవక్తానె అయికిరి క్రీస్తుబులికిరి, ప్రవక్తానెబులికిరి కొయికుంటా పురువు బచ్చిగిల్లా మనమానుకంకా మోసం కొరితె, బడే మహత్కార్యాలు, అద్బుతానె కొరికిరి దిగదూసె. ");
INSERT INTO rei_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","సునొండి సే కలొ నాఅయిలా అగరాక తొముకు కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ఈనె తొమె సంగరె కేసన్నా అదిగొ సెయ్యె కేసేనీలా చోటురె అచ్చి బులి కొయినె సెట్టికు జేతేనాండి. ఈనె, ఎట్టె గదిరె అచ్చి బుల్నే నమ్మితెనాండి. ");
INSERT INTO rei_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","తూర్పురె జొర్నైకిరి పడమర దాకా మెగోరె మెరిసిలా మెరుపుపనికిరాక మనమరొ పో ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","మొడ కేటె తన్నే రాబందునె సెట్టె పోగైవె. ");
INSERT INTO rei_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","సే కొస్టొకలొ గడిచిల ఎంట్రాక సూర్యుడు వొందారొ ఈజుసి. చంద్రుడు వెలుగు దిన్నీ. నక్సత్రాలు మెగొనెదీకిరి జొడిజివ్వె. మెగొన్రొ సక్తులు కదిలిజివ్వె. ");
INSERT INTO rei_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","సెల్లె మనమరొ పో అయిలీసి బులి సూచన మెగొరె దిగదూసి. బూమంపరె దెసోనల్లా దుక్కొపొడివె. మనమరొ పో మహా మహిమసక్తి సంగరె, బడే తేజస్సు సంగరె మెగోన్రె అయివురొ తంకె దిగుసె. ");
INSERT INTO rei_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","సెల్లె పురువు తా దూతానెకు గొప్ప బూర పుంకుకుంటా పొడదూసి. సే దూతలు బూమంపరె చారదిక్కుతీకిరి బుల్నే, సే చివర దీకిరి యేచివరదాకా బుల్లికిరి పురువు బచ్చిగిల్లాలింకు పోగుకొరివె. ");
INSERT INTO rei_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ఈనె ఉంచినె అంజూరొ గొచ్చొరొ పటొ సుగ్గీండి. సడ కొమ్మానె కోలైలా ఆకూనె అయిలసంగరాక, కొర కలొ అయిలి బులి తొముకు తెలుసుగుసి. ");
INSERT INTO rei_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","సాకిరాక మియ్యి కొయిలాటల్లా దిగిలా వెంట్రాక సే కలొ తలుపు పక్కరె అచ్చి బులి తొమె తెలిసిగివ్వొ. ");
INSERT INTO rei_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","యెడ సొత్తాక. ఎడల్లా జరిగిలా జాంక యే తరంలింకె మొరిజిన్నింతె బులి కచ్చితంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","బూమి, మెగొ నసించిజివ్వొ ఈనె మో కొత కెబ్బుకు నసించిజెన్నీ. ");
INSERT INTO rei_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","సే దినెరె గురించి నీనే సే గడియరె గురించి పరలోకంరె దేవదూతలకు గాని, పోకు కాని కాకు బుజ్జిని. బోకు మాత్రమాక తెలుస్సు. ");
INSERT INTO rei_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","నోవహు కల్రె క్యాకిరి అచ్చివొ మనమరొ పో అయితల్లాబెల్లె కూడా సాకిరాక తాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","జలప్రలయంకు అగరె దినెజాంక నోవహు బొయితొ బిత్తరకు జెల్లాదినెజాంక మనమానె కైకుంట, పికుంటా, బ్యానె కొరిగీకుంటా రొయితవ్వె. ");
INSERT INTO rei_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ప్రలయం అయికిరి తంకల్లకు కొడిగీబాజిసి జాంక తంకు బుజ్జినీ. మనమరొ పో కూడా సాకిరాక నాబుజ్జికుంటా ఆసి. ");
INSERT INTO rei_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","సెల్లె దీలింకె వండ్రపోనె బిల్లొరె పైటి కొరుకుంటా రొసె. జొనె కొనిగిబాజివురొ యింకొ జొనుకు సడిదివురొ ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","దీలింకె తిల్డ్రాలింకె తిరగలి యిసురుకుంటా తన్నె జొనుకు కొనిగిబాజివురొ యింకా జొనుకు సడిదివురొ ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ప్రబువు కేదినొరె అయిలీసివొ తొముకు బుజ్జిని ఈనె సిద్దంగా టారించి. ");
INSERT INTO rei_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ఈనె యే విసయం తెలిసిగీండి. గొరొకు యజమాని సొరొ కెబ్బుకు ఆసివొ బుజ్జికిరి తన్నే, తా గొరొకు సోరొకు నాఅయిదీకుంటా సతనైకిరి కాపలాతాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","మనమరొ పో కూడా తొమె నాఅరకైలా గడియకు ఆసి. ఈనె తొమె కూడా సాకిరాక సిద్దంగా తమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ఉంచినె విస్వాసము తల్లా, తెలివివైలా సేవకుడు కేసే? గొరొ యజమాని తాకు తాగొరె పైటికురిలింకు బొల్ట సమయంరె బత్తొ దీతె లొగిసి. ");
INSERT INTO rei_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","గొరొ యజమానుడు మనమ అయిలబెల్లె సే పైటి మనమ యజమానుడు కొయిల పైటి కొరికిరి తన్నె సెయ్యె బడే దన్యుడు. ");
INSERT INTO rei_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","సాకిరి కొర్లాబెల్లె మియ్యి తొముకు సొత్తాక కొయిలించి, గొరొ యజమాని సే పైటి మనమకు తాకు తల్లా ఆస్తంపరె తాకు అదికారిగా నియమించుసి. ");
INSERT INTO rei_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ఈనె పైటి మనమ చెడ్డాట యీనె తాబిత్తరె సెయ్యె మోగొరొ యజమాని యింక అయిని బులి మనుసురె, బులిగీకిరి ");
INSERT INTO rei_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","తా సంగరె పైటికొరిలాలింకు మరివురొ మొదలు లొగిసి. సెత్తాకనీకిరి పీలాలింకె సంగరె మిసికిరి కైకిరి, తాసి. ");
INSERT INTO rei_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","యజమాని తా పైటి మనమ నాఎదురు దిగిలాదినె, తంకు నాబుజ్జిలా సమయంరె అయివొ. ");
INSERT INTO rei_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","తాకు ముక్కలు కొరికిరి నరకం బిత్తరె పొక్కదూసి. సే నరకంరె వేసదారులల్లా కందికుంటా దంతొనె కమిడిగీకుంటా బాదకు అనుబవించుసె. ");
INSERT INTO rei_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","పురువు రాజ్యంరె యాకిరి రొవ్వొ, దొసిలింకె దిండానె తంకె తంకరొ బొత్తీనె దరిగీకిరి బ్యాబొర్రుకు మిసిగిత్తే జెల్లాలింకు పోలికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","తంకె బిత్తరె పంచిలింకె తెలివినీలాలింకె; పంచిలింకె తెలిసిగల్లాలింకె. ");
INSERT INTO rei_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","తెలివినీలా దిండానె బొత్తీనె దరిగీకిరి జేసె. ఈనె తంకసంగరె తెల్లొ దరిగీకిరిజెల్లానింతె. ");
INSERT INTO rei_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","తెలివిరొల్లా దిండానె తంకె బొత్తీనె పాటు సీసాన్రె తెల్లొ కూడా దరిగీకిరి జేసె. ");
INSERT INTO rei_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","బొర్రొ అయితె ఆలస్యం ఈసి. సొబ్బిలింకె కునికిపాటుసంగరె గుమ్మో అయికిరి గుమ్మిజీసె. ");
INSERT INTO rei_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","మొజిరత్తిరె గుటె కేక సుందీసి, ఇదిగొ బొర్రొ అయిసి, అయికిరి మిసిగీండి బులి. ");
INSERT INTO rei_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","వెంట్రాక సే దొసిలింకె దిండానల్లా ఉటికిరి తంకె బొత్తీనె సరికొరిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ఈనె తెలివినీలా దిండానె అం బొత్తీన్రె తెల్లొ అల్లా యీజేసి తొం తెల్లొ కుండె అముకు దేండి బులి తెలివిగల్లా దిండానుకు మగిసె. ");
INSERT INTO rei_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","తెలివి గల్లా దిండానె, యే తెల్లో అముకల్లా సొరిపొడినీకివో, కొట్టుకు జేకిరి తొం కోసం తెల్లొ గినిగీకిరి అయిండి బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ఈనె తంకె తెల్లొ గినిగిఅయితే జెల్లాబెల్లెకు బొర్రొ అయిసి. సిద్దంగా తల్లా పంచిలింకె దిండానె బ్యాకద్దీనుకు తాదీకిరి మిసికిరి బిత్తురుకు జేసె. సేతర్వాతరె తట్టీనె పొగిపీసె. ");
INSERT INTO rei_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","తల్లా దిండానె అయికిరి బో, బో, తలుపు పిటు బులి బొట్ట కేకానె పొగిసె. ");
INSERT INTO rei_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ఈనె సెయ్యె మియ్యి సొత్తాక కొయిలించి; తొమె కేసెవో మెత్తె తెలిసిని బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","తొముకు సే దినొ, సే సమయం కెబ్బుకు ఆసివొ తెలిసిని గనక సిద్దపొడికిరి టారైంచి. ");
INSERT INTO rei_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","పురువురొరాజ్యం యాకిరి అచ్చి, జొనె మనమ దూరుదెసొకు ప్రయానం జేకుంటా తా సేవకుడుకు డక్కికిరి తా ఆస్తికు అప్పగించిలా యజమానుడుకు పొలికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","జొనుకు పాటవెయ్యి సున్న నానేలు దీసి. యింకజొనుకు దీటవెయ్యి సున్ననానేలు, తింటో మనమకు గుటెవెయ్యి సున్న నానెం. తంకు తంకె సామర్ద్యం దిక్కిరి దీసి. సే తరవాత ప్రయానం కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","పాట వెయ్యి సున్న నానేలు పొందిలా మనమ వెంట్రాక జేకిరి సే పలియసంగరె బొంజొకొరికిరి యింకా పాట వెయ్యి సున్ననానేలు సంపాదించిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","సాకిరాక దీట వెయ్యి సున్న నానేలు పొందిలాట జేకిరి యింకా దీట తలాంతులు సంపాదించిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ఈనె గుట్టె వెయ్యి సున్న నానేలు పొందిలాట జేకిరి గుటె గత్తొ కులికిరి తా యజమాని దిల్లా గుట్టె కూడా గత్తొరె నుచ్చిదీసి. ");
INSERT INTO rei_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","బడేకలొ తరవాతరె సే సున్న నానేలు దిల్లా సేవకునెరొ యజమానుడు అయికిరి లెక్కలు దిగిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","పాట వెయ్యి సున్న నానేలు పొందిలా మనమ యింకా పాట వెయ్యి సున్న నానేలు దన్నైకిరి బో, తూ మెత్తె పాటవెయ్యి సున్న నానేలు దీసు. సడసంగరె మియ్యి ఇంకా పాటసోయి సున్న నానేలు సంపాదించించి దిగు బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","సే యజమాని యాకిరి కొయిసి బడే బొల్ట పైటి కొరిసు తోబిత్తెరె బొల్టగునొ, విస్వాసం అచ్చి. తువ్వు కొంచెమురె నమ్మకంగా పైటి కొరిసు. గనక మియి తొత్తె బడేంచంపరె బొడొమనమగా కొరుంచి. తో యజమాని సంగరె మిసికిరి సంతొసంకు బంటిగును బులి కొయిసి . ");
INSERT INTO rei_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","దీట వెయ్యి సున్న నానేలు పొందిలా మనమంకా అయికిరి, బో, మెత్తె దీట వెయ్యి సున్న నానేలు దీసు. మియి యింకా దీట సంపాదించించి దిగుబులి బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","సే యాజమాని, బొల్ట పైటి కొరిసు తోబిత్తరె బొల్టగునో, విస్వాసం అచ్చి. తువ్వు కొంచెమురె నమ్మకంగా పైటి కొరిసు గనక తొత్తె యింకా బడేంచంపరె అదికారిగా కొరుంచి, తో యజమానిసంగరె మిసికిరి సంతోసంగా తా బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","సెల్లె గుట్టె వెయ్యి సున్న నానేలు పొందిలా మనమ అయికిరి బో, తూ బొల్టనీబులి మెత్తె తెలుసు. విత్తనం నాపొగిలా చోటురె తూ కట్టుసు బులి, నా జల్లిలాచోటురె పచ్చకు పోగు కొరిలాట బులి. ");
INSERT INTO rei_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","సడకు మియి డొరికిరి తో సున్న నానేలు దనిగిజేకిరి బూమిరె నుచ్చిదీంచి. ఇదిగొ తోట తూ కడుగును బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","సడకు సే యజమాని, తా సంగరె తూ బద్దకం మనమ, చెడ్డ దాసుడు మియి నాపొగిలా చోటురె కట్టిలాట, విత్తనం నాజల్లిలా చోటురె పొగుకొరిలాట బులి తొత్తె తెలుసునా? ");
INSERT INTO rei_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","సాకిరి కొరికిరి తన్నే మో పలియ వడ్డీలింకు పక్కరె సడదిన్నే మీ అయికిరి వడ్డీసంగరెసహా కడిగింతా బులికిరి, ");
INSERT INTO rei_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","తా పక్కరె తల్లాటకు కడిగీకిరి దొస్టవెయ్యి సున్న నానేలు తల్లాటకు దీసి. ");
INSERT INTO rei_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","రొల్లా ప్రతిమనమకు యింకా బడేంచదూసి. సెయ్యె సమ్రుద్ది కలిక్కిరితాసి. ఈనె నీలాట పక్కరెదీకిరి తాకు తల్లాటకుండాంక కడిగివురొ ఊసి. ");
INSERT INTO rei_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ఈనె సే నాపైటికైలా దాసుడుకు బయల్రె వొందార్రె పొక్కదేండి. సెట్టె కందికుంటా, దంతోనె కముడుకుంటా తాసి బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","తేజోవంతుడైలా మనమరొ పో తా దేవదూతల సంగరె మిసికిరి ఆసి. అయికిరి తేజోవంతమైలా తా రొజా సింహాసనం ఉంపరె బొసురుసి. ");
INSERT INTO rei_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","సెల్లె సొబ్బిదెసోన్రొ మనమానుకు పోగు కొరికిరి తా అగరె తారదీపించుసి. సెల్లె జొనె గొర్రీనె జొగిలొతా తా మందరె మేకనెకు, గొర్రీనుకు వేరు కొరిలాపనికిరి దీట గుంపునెగా కొరుసి. ");
INSERT INTO rei_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","సే తా నీతిమంతునెకు కైలత్తొ ఆడుకు, బాఅత్తొ ఆడుకు కు మిగిల్లాలింకు తల్లాపనికిరి తారొపించుసి. ");
INSERT INTO rei_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","సెల్లె రొజా తా కైయిలత్తాడుకు తల్లాలింకెసంగరె, మో బోరొ ఆసీర్వాదంకు పొందిగిల్లాలింకే. తొమె అయిండి, అయికిరి లొకొకు పునాది పొగిలాబెల్లాక తొం కోసం సిద్దపరిచిలా రాజ్యంకు రొయిదికిరి ఆంచి అయికిరి కడిగిండి. ");
INSERT INTO rei_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","కిరుకుబుల్నే, మియి బొక్కొసంగరె తల్లాబెల్లె తువ్వు మెత్తె కద్దిదీసొ. గొలారిలబెల్లె తువ్వు మెత్తె పనిదిసో. పరదేసియునిగా తో పక్కరకు అయిలాబెల్లె తొమె మెత్తె ఆతిద్యం దీసొ. ");
INSERT INTO rei_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","కొన్నానె కావలిసిలాబెల్లె తొమె మెత్తె కొన్ననెదిసో. జబ్బుసంగరె తల్లాబెల్లె తొమె మెత్తె సేవ కొరుసొ. మియి చెరసాలరె తల్లాబెల్లె అయికిరి పలకరించుసొ బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","సెల్లె నీతిమంతునె, ప్రబూ, తువ్వు బొక్కొసంగరె తల్లాబెల్లె అమె కెబ్బె తొత్తె కద్ది దీంచొ? తువ్వు గొలారిలబెల్లె తోత్తె పనికెబ్బె దీంచో? ");
INSERT INTO rei_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","తువ్వు పరదేసియునిగా కెబ్బె అయిసు? తొముకు కెబ్బె ఆహ్వానించించొ? తొత్తె కెబ్బె కొన్నానె కావాలిబులికిరి అయిసు? కొన్నానె తొత్తె కెబ్బెదీంచొ? ");
INSERT INTO rei_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","తువ్వు నాబొల్లరొకిరి రొల్లాబేల్లే అమె కెబ్బె దిగించో? తువ్వు చెరసాలరె కెబ్బె అచ్చు? తొముకు దిగితె కెబ్బె అయించొ? బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","సే రొజా, ఎడ సొత్తాక. హీన స్తితిరె తల్లా మా బయినుకు తొమె కొరిల ప్రతి సాయము మెత్తె కొరిలాపనాక బులిగుంచి బులి జవాబు కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","సే తరవాతరె సే రొజా తల్లాలింకు దిక్కిరి సాపగ్రస్తులింకె, మెత్తె సడికిరి జాండి! సాతానుకు, తా దూతలకు సిద్దం కొరిలా నిత్యమూ పుడ్డైతల్లా నియ్యబిత్తురుకు జాండి. ");
INSERT INTO rei_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","కిరుకుబుల్నే, మియి బొక్కొసంగరె తల్లాబెల్లె తొమె మెత్తె కద్ది దిల్లానింతొ. గొలారిలబెల్లె తొమె మెత్తె పీతె పనిదిల్లానింతొ. ");
INSERT INTO rei_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","మియి పరదేసిగా అయిలబెల్లె తొమె మెత్తె ఆహ్వానించిలానింతొ. మెత్తె కొన్నానె కావలిసిలాబెల్లె తొమె కొన్నానె దిల్లానింతొ. మియి జబ్బుసంగరె చెరసాలరె రొల్లాబెల్లే తొమె మెత్తె సేవకొరిలానింతొ బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","సెల్లె తంకె కూడా, ప్రబూ తువ్వు బొక్కొసంగరె గాని, ఈనె గొలారిల సంగరె రొల్లాబెల్లే కాని, ఈనె పరదేసియునిగా కాని, ఈనె జబ్బుసంగరె చెరసాలరె తల్లాపని కెబ్బె దిగించో? సాకిరి దిక్కిరి కూడా తొముకు కెబ్బె సాయం కొరిలానింతొ? బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ఈనె, ఎడ సొత్తాక. దీనస్తిదితిరె తల్లా జొనుకన్నా తొమె సాయం కొర్నే సెల్లె మెత్తె సాయం కొరిలాపనాక బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ఈనె “అంకె జేకిరి నిత్య సిక్సకు అనుబవించివె. ఈనె నీతిమంతునె నిత్యజీవంకు జోసే.” ");
INSERT INTO rei_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","సెల్లె యేసు తా బోదకు ముగించిలా తరవాతరె సిస్యునె సంగరె యాకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“దీట దినె తరవాతరె పస్కాపొరువొ అయిలబెల్లె తొముకు బుజ్జును. సెల్లె మనమరొ పోకు సిలువ పొగితె అప్పగించుసె” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ప్రదానయాజకూనె, బొడిలింకె, కయప బులి డక్కితల్లా ప్రదానయాజలుకుడురొ బవనం అగరె చేరిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","యేసుకు తంకె కిరొ గుట్టె కుట్రసంగరె బందించికిరి మొరదిమ్మంచిబులి కాకూ మాయోపాయం కొరుసె. ");
INSERT INTO rei_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“ఈనె పొరువొ దినొరె నాబులి, సాకిరి కొర్నే మనమాన్రె కొలీనె ఊసె” బులి బులిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","యేసు బేతనియరె కుస్టురోగైకిరి బొలైజిల్లా సీమోను గొర్రె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","యేసు కద్దికైతందుకు బొసిరికి తల్లాబెల్లె జొనె మొట్ట చలువరాతిబుడ్డిరె బడే కరీదైల అత్తరు సంగరె సెయ్యె పక్కరకు అయికిరి తా ముండొవుంపరె అత్తరు పొగిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","యెడ దిక్కిరి సిస్యునెకు రగొ అయిసి “కిరుకు యాకిరి వ్యర్దంకొరుసు? బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ఏ అత్తరు బడే బూతు బిక్కికిరి సే పలియ బీదలింకు దివ్వలిసిలాట” బులి తంకె కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","యేసు ఏ విసయం తెలిసిగీకిరి, తంకు యాకిరి కొయిసి “తాకు కిరుకు బులిసొ? సెయ్యె మోకోసం బొల్ట పైటి కొరిసి, ");
INSERT INTO rei_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","బీదలింకె కెబ్బుకు తొంసంగరె రొసె. ఈనె మియి తొంసంగరె కెబ్బుకు తొం సంగరె తన్నిని. ");
INSERT INTO rei_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","సెల్లె యేసు సెయ్యె సే అత్తరు మో దేంపరె వోడదీకిరి మెత్తె సమాది కొరితె తయారు కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ఎడ సొత్తాక యే సువార్తకు లొకొరె కే చోటురె కొయినెను సెయ్యె గురుతుకు ఆసి. సెయ్యె కొరిలాట కూడా కొయిగుచ్చె” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","సె తరవాతరె పన్నెండుగురు బిత్తరె యూదా ఇస్కరియోతు ప్రదానయాజకూనె పక్కరకు జేసి. ");
INSERT INTO rei_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“తాకు తో అప్పగించినె తొమె మెత్తె కిరదూసొ?” బులి ప్రదాన యాజకూనెకు పొచ్చిరిసి. తంకె ముపై వెండి కాసులు లెక్కకొరికిరి దీసె. ");
INSERT INTO rei_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","సెల్లిదీకిరి యూదా తాకు దరికిరి దిమంచెబులి సరైలా సమయం కోసం ఎదురు దీగిలీసి. ");
INSERT INTO rei_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","నాపులిసిల రొట్టినె కైలా పొరొవొ దినె అయిసి. సే పొర్రె తొలిదినె సిస్యునె యేసు పక్కరకు అయికిరి, పస్కాపొరువొ కద్దినె కేటె తయారు కొరుబులుసు? బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","యేసు యాకిరి జవాబు కొయిసి, పట్నం బిత్తురుకు మియి కొయిల మనమ పక్కరకు జాండి తాసంగరె మో సమయం పక్కారకు అయిసి. మియి మొ సిస్యునె సంగరె మిసికిరి పస్కాపొరువొ కద్ది తొ గొర్రె కొరిమంచె బులిగిలించొ బులి అం గురువు కొయిసి బులికిరి బులి కోండి. ");
INSERT INTO rei_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","సిస్యునె యేసు కొయిలాపనికిరి పస్కాపొరువొ కద్ది సిద్దం కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","సొంజయిలబెల్లె యేసు పన్నెండు లింకె సంగరె మిసికిరి కైయితందుకు బొసిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","సొబ్బిలింకె కైతల్లాబెల్లె యేసు తంకె సంగరె “తొంబిత్తరె జొనె మెత్తె దరిపించుసి” బులి కచ్చితంగా కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","తంకు బాద కలిగికిరి ప్రతి జొనె తంసంగరె, “ప్రబూ, మీ నా” జొనె తరవాతరె జొనె పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","యేసు సమాదానం కొయికుంటా, “మోసంగరె మిసికిరి గిన్నెరె రొట్టె ముంచిలాటాక మెత్తె అప్పకొరుసి. ");
INSERT INTO rei_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","మనమరొ పో లేకనాల్రె రాసికిరితల్లాపనికి మొరుజూసి. ఈనె మనమరొపోకు అప్పకొయిలా మనమకు బడేకస్టొ కలుగుసి. సెయ్యె నాజొన్నైకిరి తన్నే బొల్ట” బులి కొయిసి ");
INSERT INTO rei_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","సెల్లె సెయ్యె ద్రోహం కొరిల యూదా, బోదకుడా “మియ్యినా” బులి పొచ్చిరిసి. యేసు, తువ్వు కొయిలాపనికిరాక బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","తంకె కైతల్లబెల్లె యేసు గుటె రొట్టె కడికిరి క్రుతజ్ఞతాస్తుతులు అర్పించికిరి సడకు బంగికిరి సిస్యునెకు దీకుంటా, “ఎడ కడిగీకిరి కాండి! ఎడ మో దే” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","సే తరవాతరె పాత్రకు కడిగీకిరి క్రుతజ్ఞతాస్తుతులు అర్పించికిరి తంకు దీకుంటా, “సొబ్బిలింకె ఎ పాత్రరె తల్లాట పీండి. ");
INSERT INTO rei_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","యెడ మో రొగొతొ. సొబ్బిలింకు కోసం పాపక్సమాపన నిమిత్తం చిందించిలా పురువురొ నిబందన రొగొతొ. ");
INSERT INTO rei_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ఆజిదీకిరి మో బో రాజ్యంరె తొంసంగరె మిసికిరి ఎ నాట ద్రాక్సరసంకు యింకాపీలా జాంక పినీబులికిరి తొంసంగరె నిచ్చియంగా కొయిలించి” ");
INSERT INTO rei_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","సెల్లె తంకె కీర్తనకు గైకుంట ఒలీవపొరొతొ వుంపరకు జేసె. ");
INSERT INTO rei_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","సే తరవాతరె యేసు తంకె సంగరె, “ఏ రత్తిరె తొమె మో కారనం వల్లరె చెదరిజూసొ. కిరుకుబుల్నే, మియి గొర్రీనె జొగిలాటకు మరుంచి సెల్లె మందరొ గొర్రీనె చెదిరిజోసె బులి రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ఈనె మియి మొర్నొదీకిరి ఉటిలబెల్లె తొంకన్నా అగరె గలిలయకు జోంచి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","పేతురు, “సోబ్బిలింకె తొత్తె సడికిరి జెన్నెను మియి మాత్రం తొత్తె సడికిరి జెన్ని” బులి సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","యేసు, “ఎడ సొత్తాక. యే రత్తికి కూడ నాడక్కిలా అగరె మియి కేసెవొ బుజ్జినీబులి తింటసారి కొయివు” బులి పేతురుకు సమాదానం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ఈనె పేతురు, “మియి తొంసంగరె మిసికిరి మొరుజిన్నన్నా, తువుకెసో మెత్తె బుజ్జినిబులి కొయినీ” బులి బులిసి. సిస్యునె సొబ్బిలింకె సాకిరాక కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","సే తరవాతరె యేసు సిస్యునె సంగరె మిసికిరి గెత్సేమనే బుల్ల సొటుకు జేసి. తంకె సంగరె, “ఎట్టె బొసురొండి. మియి కుండెదూరు జేకిరి ప్రార్దనకొరుంచి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","యేసు పేతురుకు, జెబెదయి దీలింకె పోనె తా పొచ్చాడె డక్కిగీకిరి జేసి. సెయ్యె దుక్కొసంగరె, కలతసంగరె పూరికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","సెల్లె సెయ్యె తంకసంగరె, “మో ఆత్మ మొర్నొ వేదన పొడిలీసి. ఎట్టె తయికిరి మోసంగరె పాటు సతనైకిరి టారించి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","యేసు యింకా కుండె దూరు జేకిరి సాస్టంగపొడికిరి, “మో బో! సాద్యమైనె దుక్కొసంగరె పూరిలా యే పాత్రకు మో పక్కరె దీకిరి కడిపె! ఈనన్నా నెరవేరవలిసిలాట ఎడ మో ఇస్టంనీ, తో ఇస్టం సంగరాక” బులికిరి ప్రార్దించిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","సే తరవాతరె బులిక్కిరి అయికిరి సిస్యునె గుమ్ముకుంటా తవ్వురొ గమనించిసి. సెయ్యె, “మోసంగరె మిసికిరి గుటె గంట సేపంకా సతనైకిరి రొన్నారిసోనా?” బులి పేతురుకు పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","తొమె సోదనరె నాపొడుకుంటా “సెతనెసికిరి రొయికిరి ప్రార్దనకొరొండి! ఆత్మ సిద్దమాక ఈనె దేరె బలహీనంగా అచ్చి!” బులి పేతురు సంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","సెయ్యె దీటోసారి జేకిరి, “మో బో! ఎ స్రమ బుల్లా పాత్రరె తల్లాట పీమాసిబులి తన్నే మియి సడకు పూంచి. తో ఇస్టమాక నెరవేరిమాసి!” బులి ప్రార్దన కొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","సెయ్యె ఇంగుటె బులికిరి అయికిరి తా సిస్యునె యింకా గుమ్మికిరి రొవురొ దిగిసి. అంకీనె బరువైవురొవల్లరె తంకె గుమ్ము ఆపిగిన్నారిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","సెయ్యె తింటసారి తంకు సడికిరి అగరె ప్రార్దదించిలపనిక యింకా ప్రార్దనకొరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","సే తరవాతరె తా సిస్యునె పక్కరకు అయికిరి, “తొమెయింకా గుమ్మిలిసొనా, విస్రాంతి కడిగిల్లిసొనా? దిగొండి! మనమరొ పో పాపాత్మునెకు అప్పగించిల గడియ పక్కరకు అయిసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","యింకా జెమ్మా, ఉటండి. అదిగొ! మెత్తె అప్పగించిలాట అయిలీసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","సెయ్యె కొతలకుంట రొల్లాబెల్లె పన్నెండుగురు బిత్తరె జొనె యూదా అయిసి. ప్రదానయాజకూనె, ప్రజాప్రముకునె పొడదిల్లా బొడుమనమానె గుంపు గుటె తంకె పొచ్చడె అయిసి. తంకె అత్తొన్రె కత్తినె, బడ్డీనె, బల్లేలు సంగరె అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","సే అప్పగించిలాట, “మియి జేకిరి కాకు చుమ్మో లొగుంచువో, తాకు బందించొండి!” బులి అగరాక గుటె గుర్తు దీసి. ");
INSERT INTO rei_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","యూదా వెంట్రాక యేసు పక్కరకు జేకిరి, గురువు బులి “వందనము కొయికిరి” తాకు చుమ్మోలొగ్గిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","యేసు, “స్నేహితుడా! తువ్వు కొరితె అయిల పైటి కొరు” బులి కొయిసి. వెంట్రాక కుండెలింకె మనమానె అగురుకు అయికిరి తాకు దరిగీకిరి బందించిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","యేసు సంగరె రొల్లాలింకె బిత్తరె జొనె వెంట్రాక తా కత్తికు వరదికిరి కడికిరి, ప్రదానయాజకుడురొ పైటి మనమరొ కన్నొ అనిపేసి. ");
INSERT INTO rei_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","యేసు, తో “కత్తికు వరబిత్తరె లొగ్గి కత్తిట్టెక్కిల మనమా సే కత్తిసంగరాక మొరుజొసి. ");
INSERT INTO rei_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","మియి మో బో సహాయం కావాలబులి మగినారిబుగిల్లీసోనా? మియి మగిల వెంట్రాక పన్నెండు గుంపునె కన్నా బడేలింకు దేవదూతానెకు పొడిదిన్నీనా? ");
INSERT INTO rei_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","మియి సాకిరి కోరినె యాకిరి జరిగిమంచెబులి లేకనాల్రె రాసిలాట క్యాకిరి నెరవేరుసి?” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","సే తరవాతరె యేసు అయికిరి, మనమనెసంగరె, “దోపిడి సొరొకు దరిగిత్తె అయిలాపనికిరి కత్తీనె సంగరె, బడ్డీనె సంగరె అయిసొకిరా? మందిరంరె ప్రతిదినె బోదించించి. ఈనె సెల్లే తొమె మెత్తె బందించిలానింతొ ");
INSERT INTO rei_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ఈనె, ప్రవక్తానె రొంతిలంచ నెరవేరిమంచెబులి ఎడల్లా జరిగిసి” బులి కొయిసి. వెంట్రాక సెయ్యె సిస్యునె సొబ్బిలింకె తాకు సడికిరి పొలిజీసె. ");
INSERT INTO rei_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","తంకె యేసుకు బందించిలా ప్రదానయాజకుడైలా కయప పక్కరకు కొడిగీకిరి జేసె. సెట్టె సాస్త్రీనె, బొడిలింకె అగరాక కొడిగీకిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ఈనె పేతురు కుండె దూరు తీకిరి యేసుకు ప్రదానయాజకుడురొ గొరొ జాంక పొచ్చాడైసి. గొరెబిత్తరె కెర జరిగిలీసివో దిగిమంచెబులి బటునె సంగరె మిసికిరి గొరొ దోరె టారిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","మొర్నొసిక్స విదించిమంచిబులిగీకిరి ప్రదానయాజకూనె, మహాసబలింకె యేసుకు ప్రతికూలంగా, సొరొసాక్స్య కోసం దిగిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","బడే మంది సొర సాక్స్య కొయితె అగురుకు అయిసె. ఈనె మొరిదితె సారిల సాక్స్యం మిల్లనీ. చివరకు దిలింకె మనమనె అగురుకు అయిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","తంకె యాకిరి కొయిసె, “ఎ మొపో ‘మియి పురువురొ గుడికు నాసనం కొరికిరి తింట దిన్రె యింకా బందిపారి’ బులి కొయిసి.” ");
INSERT INTO rei_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","సెల్లె ప్రదానయాజకుడు ఉటికిరి టారికిరి యేసు, అంకె కొరిలా నేరారోపనకు తువ్వు సమాదానం కొయినూనా? బులి పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ఈనె యేసు జవాబు కొయిలాని. ప్రదానయాజకుడు, “సజీవుడైలా పురువుంపరె ప్రమానం కొరికిరి కో, తువ్వు పురువు పోయిలా క్రీస్తునా?” బులి పొచ్చరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","యేసు జవాబు కొయికుంటా, “వై! తువ్వు బుల్లాట సొత్తాక. తొంసంగరె కొయిలాట కిరబుల్నే యింక అగరె దీకిరి మనమరొ పో గొప్పఅదికారం సంగరె సెయ్యె కైయిలత్తొ ఆడుకు బొసిరికిరి రొవురొ ఆకాసమంపరొ మెగొన్రె అయివురొ తొమె దిగుసో” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ఎడ సునికిరి ప్రదానయాజకుడు తా కొన్నానె సిరిగీకిరి, యెయ్యె దైవదూసన కొరిలీసి. పొదరిలింకె సాక్సీనె కిరుకు? దిగొండి సెయ్యె పురువుకు దుసించిలాట సునిసోనీనా! ");
INSERT INTO rei_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ఈనె తొమె కిరబులిగిలిసో? బులి పొచ్చిరిసి. “తాకు మొర్నొదండన పొగిమంచెబులి” తంకె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","తంకె కుండెలింకె తా మూ ఉంపరె సెప్పొ పొక్కిరి మరిసె. ఈనె కుండిలింకె తాకు చెంప అంపరె మరికిరి. ");
INSERT INTO rei_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ఓ క్రీస్తూ! తొత్తె కేసె మరిసెవో కనుగును” బులి పొచ్చిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ఎట్టె పేతురు బయిల్రె బొసిరీకిరి తల్లాబెల్లె జొనె ప్రదానయాకుడొరొ పైటి మొట్ట తాపక్కు అయికిరి, “తువ్వు కూడా గలిలయుడైలా యేసుసంగరె తల్లా మనమాకనీనా?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ఈనె సెయ్యె తంకెల్లా అగరె, “తువుకిర కొతలగిలిసివొ మెత్తె బుజిని!” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","సె తరవాతరె తంకె అల్లా సెటె దికిరి ద్వారం పక్కరకు జేసె. సెట్టె తాకు యింకోదాసి పిల్ల దీకిరి, సెట్టెతల్లా మనమానె సంగరె, “యే మోపొ, నజరేయుడైలా యేసుసంగరె తల్లాటాకనీనా!” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","పేతురు ఒట్టులొగికిరి యింకా సెయ్యె తా కొతానుకు నిబులికిరి, “మెత్తె సే మనమా కేసెవొ బుజిని!” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","కుండె సేపైలా తరవాతరె సెట్టె టారికిరి తంకె పేతురు పక్కారకు అయికిరి, “సొత్తాక తువ్వాక తంకబిత్తరె జొన్నాక. తో కొతాతీరు దిగితన్నే గలలీయుడురె జొనె బులి తెలివైలీసి” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","సెల్లె పేతురు సొత్తాక కొయిలించి బులిసి. సెయ్యె పురువుంపరె ప్రమానం కొరికుంటా, “సే మనమ కేసెవో మెత్తె తెలిసిని” బులి కొయిసి. వెంట్రాక కూడ డక్కిసి. ");
INSERT INTO rei_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","“కూడ నాడక్కిలా అగరె మియి కేసెవో తెలిసినీబుల్లా కొత తినిబెల్లె బులుసు బుల్లా కొతా పేతురుకు జ్ఞాపకం అయిసి” పేతురు బయలుకు జేకిరి బొట్టగా కందిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","సొక్కలైలాబెల్లె ప్రదానయాజకూనె, బొడిలింకె సొబ్బిలింకే కూడికిరి యేసుకు మొరదితే నిర్నయించిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","తంకె తాకు బందించి కొడిజేకిరి రోమా ప్రదానఅదికారియీల పిలాతుకు అప్పగించిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","యేసుకు అప్పగించిలా యూదా యేసుకు మొర్నొసిక్స నిర్నయించించిసె బులి జనికిరి బాదపొడిసి. మనుసు మార్చిగీకిరి సెయ్యె కడిగిల్లా ముప్పై వెండినానేలు ప్రదానయాజకూనెకు, బొడిలింకు బులికిరి దిపికుంటా, ");
INSERT INTO rei_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“మియి కే తప్పు నాకొర్లా మనమరొ రొగొతొకు అప్పకొయికిరి పాపం కొరించి. సే అమాయిడుకు మొర్నొకు అప్పగించించి” బులి కొయిసి. తంకె, “సడ తో కొలి అముకు సంబందం నీ” బులి బాజాబులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","యూదా సే పలియకు దేవాలయంరె పొక్కదీకిరి, జేకిరి ఉరి పొగ్గిచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ప్రదానయాజకులూనె సే వెండి నానేలు కడిగీకిరి, “యెడ మనమకు మొరదీతే రొగొతొ దీకిరి గినిలా పలియ ఈనె యే పలియకు కానుకానెపెడిరె పొగివురొ బొల్టనీ” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","తంకె ఆలోచించికిరి సే పలియసంగరె పరదెసొరె తల్లాలింకు బుజ్జదీతెపైటికైలాపనికిరి జొనె కుమ్మరి మనమరొ పొలముకు గినిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","సడకు ఉంచునుకు కూడా “రొగొతొ బూమి” బులి కొయివె. ");
INSERT INTO rei_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","సడసంగరె “తంకె ముప్పై వెండి నానేలు కడిగీకిరి ఇస్రాయేలు మనమానె తా కోసం యిర్మీయా ప్రవక్త సంగరె పురువు పలికిలా యే కొతానె నెరవేరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ప్రబువు ఆజ్ఞాపించిలపనికిరి తంకె సే పలియసంగరె కుమ్మరి పొలముకు గినిసె.” ");
INSERT INTO rei_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","యేసు రోమా ప్రదాన అదికారియీలా పిలాతు అగరె టారిసి. సెయ్యె “తూ యూదునెరొ రొజానా?” బులి యేసుకు పొచ్చిరిసి. “తూ కొయిలాట సొత్తాక” బులి సే కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ప్రదానయాజకూనె, బొడిలింకె తాంపరె తప్పు పొగిలాబెల్లె కూడా కిచ్చి కొయిలాని. ");
INSERT INTO rei_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","సెల్లె పిలాతు, “తంకె తొ ఉంపరె ఎత్తె నేరమూనె మోపిలీసెనీ తువ్వు సునువురొనీనా?” బులి పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","యేసు తువ్వు గుటె కొతకు కూడా జవాబు కొయిలాను. సడకు పిలాతు బడే ఆచ్చర్యపొడిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","పొరువొ దినోన్రె మనమానె కోరిలా జొనె నేరస్తుడుకు సడిదిల్లా అలవాటు. సె ప్రదానఅదిపతి ఆచరించితవ్వి. ");
INSERT INTO rei_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","సే దినోన్రె బరబ్బా బుల్లా నా గల్లా జొనె నేరస్తుడు చెరసాలరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","సడకు మనమానె తా పక్కు అయిలాబెల్లె పిలాతు, “కాకు విడుదల కొరుబుల్లీసో? బరబ్బాకునా నీనె క్రీస్తు బులి డక్కిలా యేసుకునా?” బులి తంకు పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","అసూయవల్లరె యుదా అదికారినె యేసుకు అప్పగించిసె బులి పిలాతుకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","పిలాతు న్యాయపీటం ఉంపరె బొసితన్నుగా తా నైపో, “సే నీతిమంతుడు విసయంరె జోక్యం కొరిగిత్తెనా. మియి యే రత్తిరె తా గురించి సొప్నొరె కెత్తె కొస్టోనెకు అనుబవించించి” బుల్లా సందేసంకు పొడిదిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","బరబ్బాకు సడికిరి యేసుకు మొర్నొసిక్స పొగిలపని కోరిగిబులికిరి ప్రదానయాజకూనె, బొడిలింకె మనమానుకు రెచ్చమరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","పిలాతు “దీలింకెబిత్తరె మెత్తె కాకు సడదె బుల్లీసో?” బులి మనమానెకు పొచ్చిరిసి. బరబ్బాకు బులి తంకె సమాదానం కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“ఈనె ‘క్రీస్తు’ బులి డక్కితల్లా యే యేసుకు మెత్తె కిరకొరుబుల్లీసో?” బులి పిలాతు పొచ్చిరిసి. సొబ్బిలింకె, “సిలువ పొగండి!” బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","సడకు “సెయ్యె కిర తప్పు కొరిసి?” బులి పిలాతు పొచ్చిరిసి. ఈనె తంకె, “తాకు సిలువకు పొగొండి” బులి యింకా గట్టిగా దొందిరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","లబో కలిగితె మారుగా కొలినె మొదలైవురొ పిలాతు గమనించిసి. తరవాతరె సెయ్యె పని కడిగికిరి మనమానె అగరె సే పనిరె అత్తోనె దొయిగీకిరి, “తా రొగొతొకు మియి కారనం నీ. ఎడ తొం బాద్యత” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","మనమానె, “తా రొగొతొ అమంపరె, అం పిల్లానె ఉంపరె తమ్మాసిగాక” బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","సే తరవాతరె పిలాతు బరబ్బాకు సడిదీసె. ఈనె యేసుకు కొరడా మడ్డొనె మరికిరి సిలువకు పొగితె అప్పగించిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","సే తరవాతరె అదికారినె సైనికునె యేసుకు రొజాబవనం బిత్తరుకు దరిగిజేకిరి, సెల్లె సైనుకులల్లా తా చుట్టూ చేరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","తా కొన్నానెకు పిటికిరి, గొర్ర ఊదారంగు డెంగకొన్నాకు తాకు పిందిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","కొంటానె సంగరె గుటె కిరీటం బునికిరి తా ముండొంపరె లొగిసె. తా కైలా అత్తొకు గుటె రెల్లుబడ్డి దీసె. తా అగరె ముడుకూనె పొక్కిరి నమస్కారం కొరుకుంటా, “యూదునెరొ రొజా, జయము” బులి అవమానం కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","తావుంపరె సెప్పొ పొక్కిరి, సే రెల్లుబడ్డిదీకిరి తా ముండొంపరె మరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","తాకు అవమానం కొర్లా తరవాతరె సే డెంగకొన్నాకు కడిపికిరి తా కొన్నా తాకు పిందిసె. సేతర్వాతరె తాకు సిలువకు పొగితె కొనిగిజేసె. ");
INSERT INTO rei_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","తంకె బయలుకు జేతన్నుగా కురేనే ప్రాంతముకు చెందిలా సీమోను బుల్లా నా తల్లా మనమ దిగదీసి. తాకు బలవంతం కొరికిరి యేసు సిలువకు బొయిపించిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","తంకె గొల్గొతా బుల్లా చోటుకు చేరిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","సెట్టె చేదు మిసిలా ద్రాక్సరసంకు యేసుకు పీతె దీసె. ఈనె సక్కి దిక్కిరి సడకు పీతె సెయ్యె ఇస్టపొడిలానీ. ");
INSERT INTO rei_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","తాకు సిలువకు పొగిల తరవాతరె తా కొన్నానుకు చీటీనె పొగ్గీకిరి బంటిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","సే తరవాతరె సైనికునె బొసిరికిరి తాకు జొగులొ జొగిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","తావుంపరె, “యెయ్యె యూదునె రొజా యేసు” బులి నేరముకు గుటె చెక్కంపరె రాసికిరి తా ముండొంపరె లొగిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ఈనె తాసంగరె బందిపోటు దోపిడి సొరొనెదీలింకె జొనెకు కైలత్తాడుకు, యింకజొనుకు బాఅత్తాడుకు సిలువకు పొగిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","సే బట్టరె జెల్లాలింకె ముండొ బించుకుంటా తాకు అవమానం కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“గుడికి నాసనం కొరికిరి తింట దిన్రె ఇంకాబందిలాట, తొత్తె తువ్వు కాపాడిగిత్తు. తువ్వు పురువురొ పోయీనె సే సిలువుదీకిరి వొల్లికిరి ఆయి” బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ప్రదానయాజకూనె సాస్త్రీనె, బొడిలింకె మిసికిరి తాకు సాకిరాక అవమానం కొరిసె, ");
INSERT INTO rei_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“సెయ్యె పొదరిలింకు రక్సించుసి. ఈనె తాకు సెయ్యె రక్సించిగిన్నారి. సెయ్యె ఇస్రాయేలు రొజాపనైనే సిలువదీకిరి వొల్లికిరి అయినె సెల్లె తాకు నమ్ముంచొ.” ");
INSERT INTO rei_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","సెయ్యె పురువుకు నమ్మిసి, “సెయ్యె పురువురొ పో బులి కొయిసె. పురువుకు కావలిసిలాటయినె తాకు ఉంచినాక రక్సించుసి” బులి కొయిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","తాసంగరె సహా సిలువ పొగిలా దోపిడి సొరొనంకా సాకిరాక అవమానించిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","దిప్పోరుపన్నెండు గంటలదీకిరి తినిగంటజాంక సే దెసల్లా వొందారొకమ్మిపేసి. ");
INSERT INTO rei_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","సుమారు తినిగంటయీలబెల్లె యేసు, గట్టిగా “ఏలీ, ఏలీ, లామా సబక్తానీ” బులి బొట్ట కేక పొగిసి. సే కొతకు, మో దేవా, మో దేవా, మో అత్తొ కిరుకు సడిదీసు? బులి అర్దం. ");
INSERT INTO rei_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","సెట్టె టారికిరితల్లా కుండెలింకె ఎడ సునికిరి, “సెయ్యె ఏలీయాకు డక్కిలీసి” బులి బులిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","జొనె ఎంట్రాక దొమిడికుంటా జేకిరి గుటె స్పాంజి దన్నైసి. సడ పులిసిలా ద్రాక్సరసంరె బుడ్డికిరి గుటె రెల్లుబడ్డికు లొక్కిరి యేసుకు పీతే దీసి. ");
INSERT INTO rei_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ఈనె పొదరలింకె, “టారైసె, తాకు కాపాడితె ఏలీయా ఆసికీవొ దిగిమా” బులిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","యేసు యింకా గుటె కేక పొక్కిరి తా పొర్నొ సడిదీసి. ");
INSERT INTO rei_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","సే సమయంరె గుడిరొ తెర ఉంపరె దీకిరి తొల్లె జాంక దీటబాగంగా చిరిజీసి. బూకంపం అయికిరి బండలు బద్దలైజీసె. ");
INSERT INTO rei_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","సెల్లె సమాదీనె పిటిగిచ్చె. పురువురొ మొరిజిల్లా బడేలింకె పరిసుద్దులు దేనె ఉటిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","తంకె సమాదులు తీకిరి దోరకు అయిసె. ఈనె యేసు జీకిరి అయిలాబెల్లె తంకె పరిసుద్దపట్నముకు అయికిరి బడేలింకు దిగదీసె. ");
INSERT INTO rei_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","యేసుకు జొగులొ జొగిలా సతాదిపతి, సైనికులూనె బూకంపాలుకు, జరిగిలా సంగతీనెకు దిక్కిరి బడే డొరిజేకిరి, “యెయ్యె సొత్తాక పురువురొ పో” బులి కొయిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","బడేలింకె మొట్టానె దూరు తీకిరి దిక్కుంటా అచ్చె. అంకె యేసుకు పరిచర్యానె కొరితె గలిలయదీకిరి అనుసరించికిరి అయిలాలింకె. ");
INSERT INTO rei_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","తంకబిత్తరె మగ్దలేనే మరియ, యాకోబు యోసే రొ మా యీలా మరియ, జెబెదయి నైపొ అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ఈనె సొంజైలాబెల్లె, పలియ తా యీలా యోసేపు అరిమతయి గాతీకిరి అయిసి. సెయ్యెంకా యేసుకు వెంబడించిలాటాక. ");
INSERT INTO rei_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","సెయ్యె పిలాతు పక్కరకు జేకిరి యేసురొ దేకు దేబులి మగిసి. పిలాతు దే బులి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","యోసేపు సే దేకు కడిగీకిరి గుటె నోకొన్నరె చుట్టిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","సే తరవాతరె గుటె బొట్ట పొత్రొకు తొలిపించికిరి తా కోసం కొరిగిల్లా నో సమాదిరె సడకు రొయిదీసి. సెల్లె గుటె బొట్టపొత్రొకు సే సమాదికు అడ్డుగా దొర్లిలించికిరి బాజేసి. ");
INSERT INTO rei_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","మగ్దలేనే మరియ, యింకజొనె మరియ సే సమాది అగరె బొసిరికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","సడ విస్రాంతికి సిద్దమైలా దినో. మరదిన్రె ప్రదానయాజకూనె, పరిసయ్యునె, పిలాతు సమక్సంరె కూడిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“బో, సే సొరొకొతాలగిలాట జీకిరి తల్లాబెల్లె ‘తింటొదినొరె మియ్యి ఇంకా జీకిరి ఆంచి’ బులి కొయివురొ అముకు గుర్తు అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","సడకు తింట దినొ జాంక సె సమాదికు జాగర్తగా జొగులొ లొగు బులికిరి ఆజ్ఞాపించండి. సాకిరి నాకొర్నే తా సిస్యునె అయికిరి తా దేకు నుచ్చిదీకిరి,‘సెయ్యె జీకిరి ఉటిసి’ బులి మనమానుకు కొయివొచ్చు. ఏ చివరి సొరొకొతా అగరె సొరొకొతా కన్నా గోరంగా తాసి” బులి కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","పిలాతు, బటులుకు దరిగిజేసి. “తంకు సమాదికు జాగర్తగా జొగువురొ తొం బాద్యత” బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","తంకె జేకిరి సే సమాదికు ముద్ర పొక్కిరి బటులుకు సే సమాదికు జొగులొ లొక్కిరి సడకు బద్రం కొరిసె. ");
INSERT INTO rei_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","విస్రాంతి దినొ యీజేసి. అద్దారొ సొక్కలెపైతల్లాబెల్లె మగ్దలేనే మరియ, యింకజొనె మరియ సమాది దిగితె జేసె. ");
INSERT INTO rei_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","వెంట్రాక గుటె బూకంపం అయిసి పరలోకందీకిరి ప్రబువు దూత అయికిరి సే సమాది పొత్రొ దొర్లించికిరి సేడ ఉంపరె బొసిరిసి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","సడ రూపం మెరిసిలాపనచ్చి. తా కొన్నానె మంచుపని దొగలైకిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","సమాదికు జొగొలొ జొగిలా బటునె తాకు దిక్కిరి డొరొసంగరె వనికిజీకిరి, మొరిజిల్లాలింకె పని యీజీసె. ");
INSERT INTO rei_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","సే దేవదూత, మొట్టానె సంగరె యాకిరి బులిసి, “డొరితెనాండి, సిలువకు పొగిలా యేసు కోసం తొమె కుజ్జిలీసో బులి మెత్తె తెలుసు. ");
INSERT INTO rei_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","సెయ్యె యెట్టెని. సెయ్యె కొయిలాపనాక ఉటికిరి అచ్చి. తాకు రొయిదిల్లా సోటుకు దిగొండి. ");
INSERT INTO rei_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","వెంట్రాక జేకిరి తా సిస్యునె సంగరె కోండి,‘సెయ్యె మొర్నొ తీకిరి ఉటికిరైసి బులి. తొంకన్నా అగరె గలిలయకు జోసి. తొమె తాకు సెట్టె మిసిగుచ్చొ’ బులి కొయిసి. మియి కొయిలాట గుర్తు దీగిండి.” ");
INSERT INTO rei_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","తంకె తా సిస్యునుకు కొయిమంచి బులి సమాదిపక్కరెదీకిరి డొరొసంగరె, ఆనందం సంగరె దొముడుకుంటా జేకిరి తంకు కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","వెంట్రాక యేసు తంకు మిసిగీకిరి, “తొముకు సుబం” బులి కొయిసి. తంకె తా పక్కరకు అయికిరి తా గొడ్డోనంపరె పొడికిరి తాకు మొక్కిసె. ");
INSERT INTO rei_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","సెల్లె యేసు తంకసంగరె, “డొరితెనాండి. జేకిరి బయినె సంగరె గలిలయకు జాబులికొండి. తంకె సెట్టె మెత్తె మిసిగుచ్చె” బులిసి. ");
INSERT INTO rei_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","తంకె జేతన్నుగా. సెల్లాక కుండెలింకె సైనికునె పట్నంకు జేకిరి జరిగిలాటల్లా ప్రదానయాజకుడు సంగరె కొయిసె. ");
INSERT INTO rei_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ప్రదాన యాజకూనె, బొడిలింకె మిసికిరి గుటె కుట్రపన్నిసె. తంకె సైనికునెకు బడే పలియ దీసె. ");
INSERT INTO rei_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ఈనె “తా సిస్యునె,‘మొజిరత్తిరె గుమ్మితల్లా బెల్లె అయికిరి తా దేకు సొరిపీసె’ బులి కోండి. ");
INSERT INTO rei_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","యే సంగతి పిలాతు పక్కు జెన్నే తాకు సాంతిపరిచికిరి తొముకు కే కస్టం నాఅయికుంటా అమె దిగుంచొ” బులి రెచ్చమరిసె. ");
INSERT INTO rei_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","బటులు పలియ కడిగికిరి తంకె కొయిలాపని కొరిసె. యూదునెరె యేకొతా బొల్లె వ్యాపించికిరి ఆజిజాంక వాడుకరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","సే తరవాతరె సె పదుకుండుగురు సిస్యునె గలిలయకు జేకిరి, యేసు కొయిల పొరొతంపరకు జేసె. ");
INSERT INTO rei_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","సెట్టె యేసుకు దిక్కిరి తాకు మొక్కిసె. ఈనె తంకబిత్తరె కుండెలింకె అనుమానం పొడిసె. ");
INSERT INTO rei_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","సెల్లె యేసు తంకపక్కరకు అయికిరి యాకిరి కొయిసి. “పరలోకంరె, బూమంపరె తల్లా అదికారమల్లా పురువు మెత్తెదీసి. ");
INSERT INTO rei_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ఈనె జాండి తొమె సొబ్బి దెసోనుకు జేకిరి, తంకు మో సిస్యునెగా కొరొండి. బో నారె, పో నారె, పవిత్రాత్మ నారె తంకు బాప్టీసం దేండి. ");
INSERT INTO rei_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","మియి తొముకు కొయిలా కొతానల్లా తంకు ఆచరించు బులికిరి బోదకొరొండి. మియి కెబ్బుకూ యే యుగాంతం జాంక తొం పొచ్చాడె తాంచి” బులి కొయిసి.");
INSERT INTO rei_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","పురువురొ చిత్తంవల్లరె యేసు క్రీస్తురొ అపోస్తులుడైకిరి రొయితె డక్కిలా పౌలుకు, బయిలా సోస్తెనేసుకు. ");
INSERT INTO rei_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","కొరింతియరె తల్లా పురువురొ సంగముకు బుల్నే క్రీస్తుయేసురె పరిసుద్దులయిలలింకె పనికిరి పరిసుద్దులుగా రొయితె‍ డక్కితల్లలింకు తంకును అముకు ప్రబువుగా తల్లా అమె ప్రబువుయిల్లా యేసుక్రీస్తు నారె ప్రతి చోటురె ఆరాదనకొర్లాలింకల్లకు సుబం బులి కొయికిరి రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","అం బో యిలా పురువుదీకిరి, ప్రబువైలా యేసు క్రీస్తుదీకిరి క్రుపా, సాంతి తొముకు కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","క్రీస్తుయేసురె తొముకు దిల్లా పురువురొ క్రుపకు దిక్కిరి, తొం విసయమైలా మో పురువుకు కెబ్బుకు క్రుతజ్ఞతాస్తుతులు చెల్లించిలించి. ");
INSERT INTO rei_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","క్రీస్తుకు గురించి ఐక్యత తొంబిత్తరె రొవురొవల్లరె తాబిత్తరె తొమె ప్రతి విసయంరె బుల్నే సొబ్బి కొతానెరె, సొబ్బి జ్ఞానమురె అబివ్రుద్ది పొందిసొ. ");
INSERT INTO rei_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","సడుకాక ప్రబువైల యేసుక్రీస్తురొ కొత గురించి ఎదురు దిగిలీసొ గనక సెయ్యె దీతల్లా ఆసిర్వాదంకు కిచ్చీ వొరిదిగిన్నారొ. ");
INSERT INTO rei_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","సడకు కే ఆత్మీయమైలా వరాలు వల్లరె లోపం నీకిరి, తొమె అం ప్రబువైలా యేసు క్రీస్తు ప్రత్యక్సత కోసం ఎదురు దిగిలీసొ. ");
INSERT INTO rei_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","అం ప్రబువైలా యేసు క్రీస్తు దినెరె తొమె నేరం నీకుంటా తల్లాపనికిరి అంతముదాకా సెయ్యె తొముకు రక్సించువొ. ");
INSERT INTO rei_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","అం ప్రబువైలా యేసు క్రీస్తు బుల్లా తా పోరొ సహవాసముకు తొముకు డక్కిలా పురువు నమ్మకమైలాట. ");
INSERT INTO rei_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","అన్నబయినె అప్పబొయినీనె, తొమె సొబ్బిలింకె గుట్టాక కొతంపరె, తైకిరి నా యిడిజీకుంటా, గుట్టా బావము సంగరె కొతలగిమంచి బులి, గుట్టె మనస్సు సంగరె గుట్టె ఉద్దేసము సంగరె, తొమె సిద్దపొడికిరి రొమ్మంచె బులి అం ప్రబువైలా యేసు క్రీస్తు అదికారం సంగరె తొముకు కోరిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","మో అన్నబయినె అప్పబొయినీనె, తొంబిత్తరె కొలీనె అచ్చె బులి తొం గురించి క్లోయె గొరొబిత్తరిలింకె వల్లరె మెత్తె తెలిసి. ");
INSERT INTO rei_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","తొంబిత్తరె జొనె “మియి పౌలులింకె”బులి, జొనె, మియి అపొల్లోటా యింకాజొనె యే పేతురు బులి, యింకాజొనె, మియి క్రీస్తుయీట బులి కొయిగిల్లీసె బులిసి. ");
INSERT INTO rei_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","క్రీస్తు విబాజింపబొడికిరి అచ్చినా? పౌలుకు తొం కోసం సిలువ పొగిసేనా? పౌలు నారె తొమె బాప్టీసం పొందిసోనా? ");
INSERT INTO rei_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","మో నారె తొమె బాప్టీసం పొందిసొబులి కేసెనెను నాకొయిలపనికిరి, ");
INSERT INTO rei_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","క్రిస్పునకు గాయికి తప్ప యింక కాకు మియి బాప్టీసం దిల్లాని. సడకు పురువుకు క్రుతజ్ఞతాస్తుతులు చెల్లించిలించి. ");
INSERT INTO rei_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","స్తెపనాసు గొరొలింకు బాప్టీసం దీంచి తంకు తప్ప ఇంకా కాకు ఈనెను బాప్టీసం దించికీవో మెత్తె తెలిసినీ. ");
INSERT INTO rei_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","బాప్టీసం దీతె క్రీస్తు మెత్తె పొడదిల్లానీ ఈనె, మనమా జ్ఞానం సంబందం నీకుంటా క్రీస్తురో సిలువ వ్యర్దము నాయికుంటా, కొతకారితనం నీకుంటా సువార్త ప్రకటించితందుకాక సెయ్యె మెత్తె పొడదీసి. ");
INSERT INTO rei_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","సిలువరె క్రీస్తు మొర్నొ గురించి వార్త, నసించితల్లా తంకు బోడతనం ఈనె రక్సించబొడితల్లా అముకు పురువురొ సక్తి. ");
INSERT INTO rei_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","యే విసయంరె జ్ఞానులు “జ్ఞానముకు నాసనము కొరిమి. వివేకుల వివేకముకు నాపైటికైకుంటా కొరిమి” బులి రాసికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","జ్ఞాని కిరయిసి? సాస్త్రి కిరయిసి? ఏ లోకంరొ తర్కవాది కిరయిసి? ఏ లోక జ్ఞానముకు పురువు బొడయిలాటగా కొరికిరి అచ్చి నీనా! ");
INSERT INTO rei_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","పురువురొ జ్ఞానానుసారముగా లోకము తా జ్ఞానము సంగరె పురువుకు నాబుజ్జిలందరె, సువార్త ప్రకటన బుల్లా బోడతనం సంగరె నమ్మిలాలింకు రక్సించివురొ పురువుకు ఇస్టమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","యూదునె అద్బుతానె కొరుబులికిరి పొచ్చర్లీసె, గ్రీసు దెసొలింకె జ్ఞానము కుజ్జిలీసె. ");
INSERT INTO rei_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ఈనె అమె సిలువపొగిలా క్రీస్తుకు ప్రకటించిలించొ. సడ యూదునెకు ఆటంకము యీకిరి, అన్యమనమానెకు బోడాట పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ఈనె యూదునెకు కిర, గ్రీసుదెసొలింకు కిర, డక్కిలాలింకాక క్రీస్తురొ వార్త పురువురొ సక్తి, పురువురొ జ్ఞానమయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","పురువు బోడతనం మనమాన్రొ జ్ఞానముకన్నా జ్ఞానమైలాట. పురువురొ బలహీనత మనమాన్రొ బలముకన్నా బలమైలాట. ");
INSERT INTO rei_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","అన్నబయినె అప్పబొయినీనె, తొముకు డక్కిలా డక్కకు దిగొండి. తొంబిత్తరె లోకరీతిరె జ్ఞానులు ఈనన్నా, గనులైనన్నా, బొట్ట వంసములింకె బులికిరి డక్కిలానీ గని ");
INSERT INTO rei_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","పురువు తా ఉద్దేసం ప్రకారంగా తెలివిలింకు లజ్జొకొరితె లోకందికిరి బోడలింకు పురువు ఏర్పరిచిగీకిరి అచ్చి. బలవంతులులింకు లజ్జొకొరితె లోకమురె బలహీనులైలలింకు పురువు ఏర్పర్చికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","బచ్చిగిలలింకు వ్యర్దము నాకొరికిరి లోకమురె నీచమైలలింకు, త్రునికరింపబొడిలలింకు, పురువు ఏర్పర్చిగీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","సడకు కే మనమా పురువు అగరె గొప్పలు కొయిగిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ఈనె తావల్లరె తొమె క్రీస్తుయేసురె అచ్చొ. పురువు వల్లరె సెయ్యె అముకు జ్ఞానముకు నీతికి పరిసుద్దాతకు విమోచనముయిసి. ");
INSERT INTO rei_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","సడకు “కేసైనె గొప్పలు కొయిగిల్లీసొ సెయ్యె ప్రబువురె గొప్ప ఈవాసిబులి లేకనాల్రె రాసికిరి అచ్చి.” ");
INSERT INTO rei_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","జట్టుకారీనె, మియి తొం పక్కు అయిలబెల్లె కొతకారైకిరి గాని అదికజ్ఞానం సంగరె గాని నుచ్చిదిల్లా పురువురొ సత్యముకు తొముకు ప్రకటించితందుకు అయిలానీ. ");
INSERT INTO rei_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","మియి, తొం మొజురె రొల్లాబెల్లె యేసు క్రీస్తు, ఇంకా తా సిలువ మొర్నొగురించి తప్ప, యింకిచ్చీ మెత్తె తెలిసినీ బులి నిచ్చయం కొరిగించి. ");
INSERT INTO rei_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ఈనె బలహినత సంగరె డొరొ సంగరె బడే వనుకు సంగరె తొం పక్కు అయించి. ");
INSERT INTO rei_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","సడకు మియి కొతలగినన్నా సువార్త ప్రకటించినన్నా, జ్ఞానయుక్తమైల సోదకొతానుకు నాఉపయోగించుకుంటా, పురువురొ పరిసుద్దాత్మ సక్తి సంగరె దిగిదీతే వినియోగించించి. ");
INSERT INTO rei_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","తొం విస్వాసము మనమానెరొ జ్ఞానముకు ఆదారము నాకొరిగీకిరి, పురువురొ సక్తికు ఆదారము కొరిగీకిరి రొమ్మంచిబులి, మో ఉద్దేసం. ");
INSERT INTO rei_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","పరిపూర్నులైలా తెలివిలింకె మొజిరె తెలివి బోదించిలించొ, సడ ఏ లొకొ జ్ఞానమునీ, అంతరించిజిల్లాట యే లోక అదికారిరొ జ్ఞానం పనాటనీ. ");
INSERT INTO rei_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","పురువురొ జ్ఞానము మర్మమైలపనికిరి బోదించిలించొ. ఏ జ్ఞానం మరుగైకిరి అచ్చి. యే లొకొ ఆరంబముకు అగరాక అడకు పురువు అం మహిమ నిమిత్తము నియమించిసి. ");
INSERT INTO rei_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","సడ లోకాదికారీనుకు కాకు బుజ్జిని; సడ తంకు బుజ్జికిరి తన్నే మహిమాస్విరూపియైలా ప్రబువుకు సిలువ నాపొక్కింటా రొయితె. ");
INSERT INTO rei_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","సడ గురించి పురువు సెయ్యె ప్రేమించిలలింకె కోసం కిర సిద్దపరిచిసొ సడ “అంకికి దిగదిల్లానీ, కన్నొకు సుందిల్లానీ, మనమనె హ్రుదయంకు గోచరము ఈలాని” బులి లేకనులురె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","అముకు ఈనె పురువు సడకు తా ఆత్మవల్లరె బయిలుపరిచికిరి అచ్చి. సే ఆత్మ సొబ్బిటికు పురువు మర్మమునె కూడ పరిసోదించించిలీసి. ");
INSERT INTO rei_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","జొనె మనమరొ సంగితీనె తాబిత్తరెతల్లా మనమరొ ఆత్మకాక తెలుసు. సాకిరాక పురువురొ సంగతీనె పురువురొ ఆత్మకాక తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","పురువు వల్లరె అముకు కలిగిలాటకు తెలిసితే అం లౌకికాత్మకు నీకిరి పురువు పక్కరెతీకిరి అయిలా ఆత్మకు పొందిలించొ. ");
INSERT INTO rei_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ఈనె మనమాన్రొ జ్ఞానము సుక్కిల కొతానెసంగరె నీకరి ఆత్మ సంబందమైలా సంగతీనుకు ఆత్మ సంబందమైలా సంగతీనె సంగరె కొయికుంటా ఆత్మ సంబందమైలా సత్యాలు సుక్కిలా కొతానె సంగరె యెడ కోసమాక అమె బోదించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ప్రక్రుతి సంబందిమిల్లా మనమ పురువురొ ఆత్మ విసయములకు అంగీకరించిని, సడ తాకు బోడాటపనికిరి తాసి, సడ ఆత్మానుబవము సంగరాకా వివేచింబొడిసి. కాబట్టి సడకు సెయ్యె గ్రహించినారి. ");
INSERT INTO rei_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ఆత్మసంబందమైలాట సొబ్బిటికు పరిసిలించుసి గాని సెయ్యె కా సంగరె ఈనెను పరిసిలించబొడిని. ");
INSERT INTO rei_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ప్రబువురొ మనుస్సుకు జనికిరి తాకు బోదించిలాట కేసె? అమె ఈనె క్రీస్తు మనస్సు కలిగిలలింకె. ");
INSERT INTO rei_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","మో జట్టుకారీనె యీలా లింకె ఆత్మసంబందమైలా మనమానె సంగరె కొతలగిలపనికిరి మియి తొంసంగరె కొతలగినార్లించి. దేసంబందులైలా మనమానాక బులికిరి, క్రీస్తురొ విస్వాసమురె సన్నిపిల్లానె బులికిరి, లోకొ అనుసారంగా తొంసంగరె కొతలగించి. ");
INSERT INTO rei_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","తొముకు దుద్దొదీకిరి పుసించి, బలమైలా కద్దిదీకిరి తొముకు పుసిలాని, తొమె ఇంకా ఉంచునుకు సిద్దపొడిలనింతొ. ");
INSERT INTO rei_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","తొంబిత్తరె అసూయనె కలహము తన్నుగా తొమె దే సంబందులిల్లా మనమనె పనికిరి చలిలాలింకె నీంతొనా? ");
INSERT INTO rei_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","జొనె “మియి పౌలుత, ఇంగుటె మియి అపొల్లోటా” బులి కొయిలాబెల్లె తొమె ప్రక్రుతి సంబందులిల్లా మనమనె నీంతొనా? ");
INSERT INTO rei_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","అపొల్లో కేసె? పౌలు కేసె? అమె కేవలం సేవకునె నీనా. జోనుకు జొనె పురువు దిల్లా పైటికొరిసె. తంకె వల్లరె తొమె విస్వాసించుసొ. ");
INSERT INTO rei_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","మియ్యి నాటించి, అపొల్లోలింకె పనిపొగించి, సడకు బొడిపించిలాట పురువాక. ");
INSERT INTO rei_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ఈనె సడకు బొడిపించిలాట పురువాక గని, నాటిలాటరె పనిపొగిలాటరె కిచ్చినీ. ");
INSERT INTO rei_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","నాటిలాట పనిపొగిలాట గుట్టాక. సొబ్బిలింకె సెయ్యె సే కొరిలా కొస్టొ కొలిది బహుమతి కడుగునుసి. ");
INSERT INTO rei_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","అమె పురువు సంగరె మిసికిరి పైటిలింకె పనికిరి అచ్చొ; తొమె పురువు బిల్లొపనికిరి గొరొపనికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","పురువు మెత్తె అనుగ్రహించిలా క్రుపవల్లరె మియ్యి సుక్కిదిల్లా బొల్లపైటిత పనికిరి పునాది పొగించి, ఇంకా జొనె సెడవుంపరె బందిలీసి; సొబ్బిలింకె సెడవుంరె క్యేకిరి బందిలిసివో జాగర్తాగ దిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","పొగిలటా తప్ప, యింగుటె పునాది కేసెను పొగినరె; ఏ పునాది యేసు క్రీస్తాక. ");
INSERT INTO rei_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","కేసె యీనెను ఏ పునాది ఉంపరె సున్న, వెండి, విలువైలా పొతొరొనె, బడ్డి, గసొ, చెక్కానె యడనల్లాసంగరె బందినె, ");
INSERT INTO rei_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ఈనె, తంకె తంకె పైటి దిగదూసి, సె దినెరె సెడకు దిగదూసి, సెడ నియ్యసంగరె పొదరకు దిగదూసి. ఈనె తంకె తంకె పైటి కాటవొ నియ్యక పరీక్సంచుసి. ");
INSERT INTO rei_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ఈనె పునాదివుంపరె జొనె బందిలా పైటి టారినె సెయ్యె బహుమతి కడుగుసి. ");
INSERT INTO rei_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","తువ్వు జొనె పైటి పుడ్డిదిపినె తంకు నస్టం కలుగుసి; సెయ్యె తా మట్టుకు రక్సింపబొడుసి ఈనె నియ్యసంగరె తప్పించిగిల్లా పనికిరి రక్సంపబొడుసె. ");
INSERT INTO rei_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","తొమె పురువురొ మందిరం పనికిరి అచ్చొబులి, పురువురొ ఆత్మ తొం బిత్తరె తల్లీసిబులికిరి తొమె తెలిసిగిన్నింతొనా? ");
INSERT INTO rei_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","కెసినెను పురువురొ మందిరంకు పాడుకొరినె పురువు తాకు పాడుకొరసి. పురువు మందిరం పరిసుద్దుయికిరి అచ్చి; తొముకు తొమంకా మందిరమైకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","కేసెనె తంకు సెయ్యె మోసం కొరిగిన్నాసి. తొమె బిత్తరె కేసెను ఏ లోకంరె తా జ్ఞానమైలాట బులి కొయిగిన్నె, సెయ్యె బుద్దిహినుడు వుసి. ");
INSERT INTO rei_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ఏ లోకంరొ తెలివి పురువురొ ద్రుస్టిరె బుద్దిహినతా. తెలివిలింకె తంకె కుయుక్తిలురె సెయ్యె దరుగుసి; బులి లేకానము కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ఈనె జ్ఞానీనెరొ యోచనానె పైటికైని బులి ప్రబువుకు తెలుసు బులి యింగుటె లేకనమురె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","కాబట్టి కేసెను మనమనె కొరిలా పనికిరి అతిసయిపొడినాసి; సొబ్బి తొముకాక ");
INSERT INTO rei_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","పౌలుయినెను అపొల్లోయినెను, పేతురుయినెను, లోకొయినెను, జీవముయినెను, మొర్నొయినెను, ఉంచినెరొల్లాట కిర యినెను అయిలాట యినెను సోబ్బి తొమటాక. ");
INSERT INTO rei_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","తొమె క్రీస్తు లింకె; క్రీస్తు పురువురోట. ");
INSERT INTO rei_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","యాకిరి క్రీస్తు సేవకునె బులికిరి, పురువురొ మర్మమల విసయములురె నిర్వాహకునె పనికిరి తొమె పరిగినించొండి. ");
INSERT INTO rei_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ఈనె గ్రుహనిర్వాహకునెరె ప్రతిజొనె యాజమనుకు నమ్మకమైలటగా తవ్వురొ అవసరం. ");
INSERT INTO rei_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","తొమె వల్లరె యినెను, కే మనమ సంగరె యినెను మియ్యి విమర్మింపబొడివురొ మెత్తె సన్ని విసయాం; సాకరాక మెత్తె మియ్యెక తిర్పు తీర్చిగిని. ");
INSERT INTO rei_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","మొ హ్రుదయం బొల్లా, ఈనెను సెడకు మియి నీతిమంతుడు పనికిరి బచ్చిగివురొయిని, మెత్తె తిర్పు తిర్చిలాట ప్రబువుకా. ");
INSERT INTO rei_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","సెడకు సమయము నాయిలా అగరె, బుల్నే ప్రబువు అయిలా జాంక, కిడ కోసం తీర్పు తీర్చితెనాండి. తా వొందర్రె రహస్యములకు హల్లొబిత్తరకు దన్నెకిరి హ్రుదయలాబిత్తరె ఆలోచనానెకు దొరె పొడిలబెల్లే, సొబ్బిలింకు తగిలా మోప్పు పురువు వల్లరె కలుగుసి. ");
INSERT INTO rei_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","మో జట్టుకారీనె తొమె అముకు దిక్కిరి, లేకనమురె రాసికిరి తల్లా సంగతినెకు అతిక్రమించినాసి బులి సుగ్గికిరి, తొమె జొనె గొప్పకొరికిరి ఇంకజొనె ఉంపరె తునికరించిలీసొ, ఏ కొతానె తొ నిమిత్తమైల మో ఉంపరె అపొల్లో ఉంపరె లొగికిరి సుచ్చనగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","తొత్తె ఆదిక్యము కలిగించిలాట కేసె? తొత్తె కలిగిలా సొబ్బిటిబిత్తరె పురువు తొత్తె దిల్లాని కిర? సాకరాక తొత్తె రొల్లా సొబ్బి సుచ్చాటకా పొందిగిసు ఈనె కిరుకు గొప్ప కొయిగిల్లిసు? ");
INSERT INTO rei_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","సడకు అగరాక తొమెకెరైనా తక్కువ నీకుంట త్రుప్తుపొందికిరి అచ్చొ? సడకు అగరె‍ ఐస్వర్యవంతులైకిరి అచ్చొ? అముకు సడిదీకిరి తొమె రొజానైకిరి అచ్చొ? ఈనె బొల్టాక అమె తొం దీ కూడ రొజానెయితందుకు బులి తొమె రొజానెయివురొ మెత్తె సంతొసమా నీ. ");
INSERT INTO rei_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","మొర్నొ సిక్సి విదించిలాపనికి బులి పురువురొ అపొస్తులుమైల ఈలాలింకె అముకు సొబ్బిలింకె అగరె కడపటి రొయిదీసి బులి మెత్తె తోచిలీసి. అమె లోకొరె దేవదూతలకు మనమానెల్లకు వింత్తగా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","అమె క్రీస్తు వల్లరె బుద్దిహినులు, తొమె క్రీస్తురె బుద్దిమంతులు;అమె బలంనిలలింకె, తొమె బలంరొల్లలింకె; తొమె గనులు, అమె గనహీనులులింకె. ");
INSERT INTO rei_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ఏ గడియజాంక బొక్కొరె, సొసొ సంగరె, సిరిజీల్లాకొన్నానె నిలలింకె పని; కుందానె కయిలించొ; రొయితె గొరొనీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","అం సొంత అత్తోనెసంగరె పైటికొరికిరి కస్టపొడిలించొ. నిందపొడికిరి దీవించిలించ్చొ; హింసపొడికిరి ఓర్చిగిలించ్చొ. ");
INSERT INTO rei_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","దూసించిబొడికిరి బతిమలిగిలించ్చొ లోకొకు మురికి పనికిరి సొబ్బిలింకు పెంటపనికిరి ఉంచినె జాంక బచ్చికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","తొముకు లజ్జొకొరిమంచెబులి నీగాని మో యిస్టమైలా పిల్లనెకు బుద్ది కొయితె ఏ కొతానె రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","క్రీస్తురె తొముకు ఉపదేసకునె దొస్టఎయ్యిమంది పాలించిలాట రొన్నెను బో జొన్నాక. క్రీస్తు యేసురె సువార్తవల్లరె మియి తొముకు బొయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","సెడకు తొమె మెత్తె పొలికిరి సలిగిలలింకె పనికిరి రొమంచెబులి తొముకు బతిమాలిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ఎడ వల్లరె ప్రబువురె మెత్తె ప్రియుడు నమ్మకమైలా మో పొయిలా తిమోతికు తొమె పక్కరకు పొడదిలించి. సెయ్యె క్రీస్తురె మియి సలిగిలా విదమురె, బుల్నే ప్రతి చోటురె ప్రతి సంగమురె మియి బోదించిలా విదనము, తొముకు గుర్తు కొరుసు. ");
INSERT INTO rei_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","మియి తొమె పక్కు అయిని బులి బులిగికిరి కుండిలింకె విర్రవీగిలిసొ. ");
INSERT INTO rei_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ప్రబువు చిత్తమైనె బెగకా తొమె పక్కరకు అయికిరి, ఉప్పొంగిలలింకె కొతనెకు నీ తంకె సక్తికా తెలుసుగుంచు. ");
INSERT INTO rei_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","పురువురొ రాజ్యము కొతానె సంగరె నీ. సక్తి ఈకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","తొమెకిడ కోరిలిసెవో? బడ్డి సంగరె మియి తొమె పక్కు అయిమంచెనా? ప్రేమసంగరె సాత్వికమైల మనస్సుసంగరె అయిమంచెనా? ");
INSERT INTO rei_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","తొంబిత్తరె దర్నిపైటిలింకె అచ్చి బులి కచ్చితంగా తెలుసు. తొంబిత్తరె జొనె తా బోరొ నైపోకు రొయిదిగిసిపని. సడపనా దర్నిపైటి పురువుకు నానమ్మిగిల్లాలింకె బిత్తరె కూడ జరిగినీ. ");
INSERT INTO rei_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","యాకిరి రొయికిరి, తొమె విర్రవిగిలిసొ గాని తొమె కెమాత్రము దుక్కొపొడికిరి యాట పైటినె కొర్లలింకు తొంబిత్తరె దీకిరి వెలిపొగిలీనింతొ. ");
INSERT INTO rei_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","మియి దే విసయంరె దూరుగా రొంచి ఆత్మవిసయంరె పక్కరె రొయికిరి, తొంసంగరె కూడా రొల్లాపనికిరకా ఏ పైటి యాకిరి కొర్లలింకు గురించి యడకగరకా తీర్పు తీర్చికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","కిరబుల్నే, ప్రబువువైలా యేసు దినొనెరె తా ఆత్మ రక్సింపబొడిలా పనికిరి దేరొ కోరికానె నసించితే అం ప్రబువువైలా యేసుక్రీస్తు నారె తొమ్మంకా, ");
INSERT INTO rei_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","మో ఆత్మంకా అం ప్రబువువైలా యేసుక్రీస్తు బలంసంగరె కూడిగీకిరి అయిలబెల్లె, సాలింకు సాతానుకు అప్పగించిమంచె. ");
INSERT INTO rei_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","తొమె అతిసయపొడివురొ బొల్ట నీ, “పులిసిలా పిండి కుండె ఈనెను ముద్దల్లా పులిసికొరువొ బులి తొమెకు తెలిసినినా.” ");
INSERT INTO rei_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","తొమె పులిసిలా పిండి నిలాలింకె ఈనె నోముద్దఇత్తెకు సె పుర్నాటయిలా పులిసిల పిండికు కడికిరిపొయిదెండి. సెత్తనికిరి అమె క్రీస్తుబుల్లా పస్కా గొర్రె పిల్లకు బలికొరిసె. ");
INSERT INTO rei_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ఈనె పుర్నాటయిలా పులిసిల పాపంసంగరె ఈనె దుర్మార్గతము దుస్టత్వముకు పులిసిల పిండిసంగరెయినెను నికిరి, నిస్కపటంము సొత్తాక పులిసిలాని రొట్టిసంగరె పొరొవొ ఆచరించించొ. ");
INSERT INTO rei_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","జారులు సంగరె జట్టు కొరితెనా బులికిరి మో పత్రికరె తొముకు రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ఈనె ఏ లోకంరె జారుల సంగరె యీనెను, లోబునె సంగరె యీనెను, సొరొలింకె సంగరె యీనెను, విగ్రహానెకు పూజించిలలింకె సంగరె యీనెను, కే మాత్రము జట్టు కొరితెనాబులికిరి నీ. సాకిరి యీనె తొమె లోకము దీకిరి బాజీసొ నీనా. ");
INSERT INTO rei_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ఉంచినినె, అన్నబయినె అప్పబొయినినె బులితల్లా కెసినెను దర్నిపైటిగాని బొమ్మలకు పూజించివురొ గాని గలినెదిల్లాలింకె గాని పీకారి గాని దోచిగిలటగాని యినె, సాటలింకె సంగరె జట్టు కొరినాసి కైయినాసెబులి తొముకు రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","పొదరెలింకు తీర్పు తీర్చుల మెత్తె కిర? “తొమె బిత్తరెలింకు తీర్పు తీర్చులలింకె నీనా.” ");
INSERT INTO rei_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","పొదరెలింకు పురువాక తీర్పు తీర్చుసి. గనుక సే “దుర్మార్గులుకు తొం బిత్తరెదీకిరి కడిపివొ బులికిరి లేకనాల్రె రాసికిరి అచ్చి.” ");
INSERT INTO rei_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","తొంబిత్తరె జొనుకు ఇంకజొనె వుంపరె కొలీనె రొల్లబెల్లె సెయ్యె పురువురొ మనమానె అగరె నీకిరి యూదునెనీలలింకె పక్కరె తీర్పు తీర్చితె తెగించుసునా? ");
INSERT INTO rei_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","పురువురొ మనమానెయిలా తొమె లోకొకు తీర్పు తీర్చుమాసిబులి తొముకు తెలిసినినా? తొమెవల్లరె లోకొముకు తీర్పు రొల్లాబెల్లె, సన్ని సంగితినె గురించి తీర్పు తీర్చుతె తొముకు సక్తి నీనా? ");
INSERT INTO rei_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","అమె దేవదూతానెకు తీర్పు తీర్చుంచొబులి తెలిసినినా? ఏ జీవన సంబందమైలా సంగతినె గురించి యింకా ముక్యముగా తీర్పు తీర్చువచ్చు నీనా? ");
INSERT INTO rei_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ఈనె ఏ జీకాకు సంబందమైలా కొలీనె తొముకు కలిగినె సడక తీర్చితె సంగమురొ క్రమము నాజనిలాలింకు సంగరె బొసురుదుసొనా? ");
INSERT INTO rei_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","తొముకు లజ్జొ అయిమంచెబులి కొయిలించొ కిర తా అన్నబయినె మొజిరె కొలీనె తీర్చిలా బుద్దిమంతుడు తొంబిత్తరె జొన్నాన నీనా? ");
INSERT INTO rei_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","సాకిరాక అన్నబయి అన్నబయినె అంపరె కొలీనె లగిలిసి ఈనె తీర్పుపు కోసం అవిస్వాసినె అగరాక జెల్లిసొ. ");
INSERT INTO rei_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","జొనెవుంపరె జొనె కొలీనె లగువురొ తొంబిత్తరె ఉంచినెకాక బొల్టనీ. సడకన్నా అన్యాయముకు సహించివరొ మేలాకనీనా? సడకన్నా తొం ఆస్తి సొరుపివురొ మేలు నీనా? ");
INSERT INTO rei_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ఈనె తొమె అన్యాయము కొర్లీసొ, మోసంకొరిలిసొ, తొం సొంత అన్నబయినెకంకా యాకిరి కొరిలీసొ. ");
INSERT INTO rei_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","అన్యాయం కొర్లాలింకె పురువురొ రాజ్యముకు వారసునె యినింతెబులి తొముకు తెలిసినీనా? మోసం యీతెనాండి; జారిలైనెను విగ్రహానెకు పూజించిలలింకె ఈనెను దర్నిపైటి కొరిలలింకె, సొదిలింకె ఈనెను, వొండ్రపొ సంయోగులీనెను ");
INSERT INTO rei_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","సొరొనె యీనెను లోబునె యీనెను పీలలింకె యీనెను దూసించిలింకె యీనెను దొచుగిల్లలింకె యీనెను పురువురొ రాజ్యముకు అర్హులు ఈనింతె. ");
INSERT INTO rei_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","తొం బిత్తరె కుండిలింకె తంకెపనికిరి అచ్చె, ప్రబువు యీల యేసు క్రీస్తు నారె యీనెను అమె పురువురొ ఆత్మ తొముకు దొయిలందరె, పరిసుద్దులికిరి నీతిమంతునె పనికిరి ఈసొ. ");
INSERT INTO rei_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","జొనె మెత్తె సొబ్బి కొరువొచ్చు బులి కొయిలీసి “సొబ్బిటంపరె మెత్తె స్వాతంత్రము అచ్చి” గాని సొబ్బి కొరినాసి. సొబ్బిటంపరె మెత్తె స్వాతంత్రము అచ్చిగాని మియి సొబ్బిటుకు లోబొడిజిల్లాని. ");
INSERT INTO rei_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","కద్ది పెట్టొకు, పెట్టొ కద్దికోసం కొరికిరి అచ్చి; పురువు సెడకు ఎడకు నాసనము కొరిసి. దే జారత్వము కొరితె నిగానీ పురువుకు మహిమకొరితాక. ప్రబువు సెడకు పుసిలిసి. ");
INSERT INTO rei_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","పురువు ప్రబువుకు మొర్నొదీకిరి ఉటదీసి; అముకు కూడ తా సక్తిసంగరె ఉటదూసి. ");
INSERT INTO rei_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","తొం దేనె క్రీస్తుకు అవయవానె యికిరి అచ్చి బులి తొముకు తెలిసినీనా? మియ్యి క్రీస్తురొ అవయవానెకు కడిగీకిరి దర్నిరొ అవయవానె పనికిరి కొరిలీసునా? సడ కే మాత్రము యీని. ");
INSERT INTO rei_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","వేస్యసంగరె మిసిగిల్లాట తాదీకిరి గుట్టెదేయికిరి అచ్చి బులి తొమె తెలిసిగీనింతొనా? తంకె దీలింకె గుటె దేయికిరి రొసే బులి లేకనానెరె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","సాకరాక ప్రబువు సంగరె మిసిగిలటా తాసంగరె గుటె ఆత్మయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","జారత్వముకు దూరు పొలిజాండి. మనమ కొరిలా ప్రతి పాపముకు మానకు హనికొరిని గాని, జారత్వము కొరిలాట తా సొంత దేకు నస్టంగా పాపము కొరిలీసి. ");
INSERT INTO rei_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","తొమె దే పురువు వల్లరె తొముకు అనుగ్రహింపబొడిసి, తొమెబిత్తరె రొల్లా పరిసుద్దత్మకు మందిరం యికిరి అచ్చిబులి తొమె తెలిసిగీనింతొనా? తొమె, తొమె సొత్తు నీ, తొమె పురువులింకె. ");
INSERT INTO rei_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","విలువలొక్కిరి గినిలాలింకె సెడకు తొమె దేసంగరె పురువుకు మహిమకొరోండి. ");
INSERT INTO rei_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","తొమె రాసిలా విసయముకు; తిల్డ్రాటకు బ్య నాకొరిగివురొ వొండ్రొపొకు బొల్ట. ");
INSERT INTO rei_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ఈనెను జారత్వము జరిగితల్లా వల్లరె ప్రతిమనమకు సోంత నైపో రొమంచె, ప్రతి తిల్డ్రాటకు సొంతొ గొయిత రొమంచె, ");
INSERT INTO rei_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","గొయిత నైపోకు సాకిరాక నైపో గొయితకు తంకె తంకె దర్మముకు జరిగించిమాసి. ");
INSERT INTO rei_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","గొయితకాక గని నైపోకు తా దే ఉంపరె అదికారం నీ; సాకిరాక నైపోకాకు గని గొయితకు దే ఉంపరె అదికారం నీ. ");
INSERT INTO rei_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ప్రార్దన కొరివురొ తొముకు అవకాసం కలిగిలపనికిరి కుండెకలొ జాంక దీలింకె సమ్మతి చొప్పురె తప్ప, జొనుకు జొనె వేరుగా రొయితెనాండి; తొమె మనస్సు నాటారిదీగినె సాతాను తొముకు నాసోదించిల పనికిరి బుల్లికిరి మిసిగీండి. ");
INSERT INTO rei_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","మియ్యి కొయిలాట ఆజ్ఞ నిగానీ, సలహా మత్రమాక. ");
INSERT INTO rei_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","మనమానె అల్లా మోపన్నకా రొమంచె బుల్లిగిలిసె. ఈనె జొనె గుటె విదముకు ఇంకజొనె ఇంగుటె విదముకు ప్రతి మనమ తాకు రొల్లా క్రుపావరములకు పురువు వల్లరె పొందికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","మో పనికిరి రొవ్వురొ తంకు బొల్టబులి బ్య నాయిలలింకె సంగరె రండిలింకె సంగరె కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ఈనె మనస్సు నాఆపిగిన్నార్నే బ్యా కొరిగివొచ్చు; కామం సంగరె రొల్లకన్నా బ్యాకొరిగిన్నే బొల్ట. ");
INSERT INTO rei_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ఈనె బ్యయిలలింకు మియ్యి నీ ప్రబువుక ఆజ్ఞాపించిలాట కిరబుల్నే, నైపో గొయిత సడదిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","సడదిన్నే బ్య నాకొరిగీకుంటా రొమంచి; నీనె, తా గొయిత సంగరె సమాదానం పొడిమంచి. ఈనె గొయిత తా నైపోకు విడాకులు దిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ప్రబువు నీ మియ్యి తక్కిలాలింకె సంగరె బుల్లిలాట కిరబుల్నే కే బయికైనన్నా అవిస్వాసురాలైలా నైపో తన్నె, సెయ్యె తా సంగరె కాపురం కొరిమా బులి ఇస్టపొడినె, సెయ్యె తాకు విడాకులుదిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ఈనె కే తిల్డ్రాటకు అవిస్వాసమైలా గొయిత రొయికిరి, తా సంగరె కాపురం కొరిమా బులి ఇస్టపొడినె, సెయ్యె తాకు విడాకులు దిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","అవిస్వాసమైలా గొయిత నైపొ వల్లరె పురువుకు అంగీకరించబొడుసి; అవిస్వాసురాలైలా నైపొ విస్వాసమైలా గొయిత వల్లరె పురువుకు అంగీకరించబొడుసి. సాకిరి నీనె తొం పిల్లానె అపవిత్రులైకిరి తాసె. ఉంచినె ఈనె తంకె పవిత్రునె. ");
INSERT INTO rei_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ఈనె అవిస్వాసైలాట సడదిన్నెను సడుదూసి గని; సే సందర్బమురె బయికి యీనెను బొయినికి యీనెను వివాదమునీ. సమాదానముగా రొయితె పురువు అముకు డక్కిసి. ");
INSERT INTO rei_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","యే తిల్డ్రాట తో గొయితకు రక్సించుసునా నీనా? తొత్తె కిర తెలుసు. యే వొండ్రపొ తో నైపొకు రక్సించుసునా నీనా? తొత్తె కిర తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ఈనె ప్రబువు ప్రతి మనమకు కే స్తితి నియమించిసొ, పురువు ప్రతీలింకు కే స్తితిరె డక్కిసివొ సే వరమురె సలిగెండి; యే ప్రకారమాక సంగములు సొబ్బిటిరె నియమించిలించి. ");
INSERT INTO rei_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","సున్నతి పొందిలాట కాకు ఈనెను డక్కివురొ ఈసినా? సెయ్యె సున్నతి జేగొట్టిగిన్నాసి; సున్నతి నాపొందిలాట కాకైనెను డక్కివురొ ఈసినా? సున్నతి పొందివలిసిలా అవసరంనీ. ");
INSERT INTO rei_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","పురువురొ ఆజ్ఞానెకు అనుసరించివురొ ముక్యము గని, సున్నతి పొందిలాటరె కిచ్చీనీ. సున్నతి నాపొందిగిల్లాటరె కిచ్చీ నీ. ");
INSERT INTO rei_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ప్రతిలింకె కే స్తితిరె డక్కిసో సే స్తితిరాక రొమంచి. ");
INSERT INTO rei_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","దాసుడైకిరి రొయితె డక్కిసినా? చింతపొడితెనా గని స్వతంత్రుడైతె సక్తి కలిగీకిరి తన్నె, స్వతంత్రుడైనె ఇంకా బొల్ట. ");
INSERT INTO rei_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ప్రబువువలరె డక్కిలా దాసుడు ప్రబువు వలరె స్వతంత్రము పొందిలాట. సే ప్రకారము స్వతంత్రుడైకిరి డక్కిలాట క్రీస్తు దాసుడు. ");
INSERT INTO rei_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","పురువు తొముకు విలువ లొక్కిరి గినిసి సడకు మనమకు దాసునె యీతెనాండి. ");
INSERT INTO rei_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","జట్టుకారీనెలింకె, ప్రతి మనమ కే స్తితిరె డక్కిసెవొ సే స్దితిరాక పురువు సంగరె సహవాసము కలిగీకిరి రొమంచి. ");
INSERT INTO rei_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","బ్యా నా ఈలాలింకె విసయంరె, ప్రబువురొ ఆజ్ఞ మియ్యి పొందిలాని గాని నమ్మకమైలాట పనికిరి రొయితె ప్రబువు వలరె కనికరము పొందిలాటైకిరి మో ఉద్దేసం కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ఉంచినెరొ ఇబ్బంది వల్లరె వొండ్రపొ సెయ్యె తల్లా స్తితిరె రొవురొ మేలుబులి తలంచిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","నైపొకు కట్టుబొడికిరి అచ్చునా? సడివురొ కొరితెనా. నైపొకు సడికిరి వేరుగా అచ్చునా? బ్యా కోరిగిత్తెనా. ");
INSERT INTO rei_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ఈనెను తువ్వు బ్యా కొరిగినెను పాపం నీ, బ్యా నాయిలాట బ్యా కొరిగినెను తాకు పాపము నీ; బ్యా నాయిల పిల్ల బ్యా కొరిగిన్నెను తాకు పాపం నీ; ఈనె సాలింకు దేసంబందమైలా స్రమానె కలుగుసి; సెడ తొముకు నాకలిగికుంటా కొరిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","మో జట్టుకారీనెలింకె, మియి కొయిలాట కిరబుల్నె, కలొ కుండేకా అచ్చి కాబట్టి ఇంక అగరె బ్యా ఈలాలింకె బ్యా నాయిలపన జీవించువాసి. ");
INSERT INTO rei_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","కందిలాలింకె కందిలాపనికిరి సంతోసపొడిలాలింకె సంతోసపొడిలాపనికిరి గినిగిల్లాలింకె తంకె గినిలాట తంకటానీలాపనికిరి. ");
INSERT INTO rei_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ఏ లోకం అనుబవించిలాలింకె అమితంగా అనుబవించిలాపనికిరి తమ్మంచి; కైంకిబుల్నే ఏ లోకమురె నటన అంతరించిజిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","తొమె చింతనిలాపనికిరి తమ్మంచె బులి కొరిగిల్లించి. బ్యా నాయీలాట ప్రబువుకు కే విదంగా సంతోసం లొగిపారిబులికిరి పురువొ విసయంరె స్రద్ద కలిగీకిరి తమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ఈనె బ్యాయీలట నైపొకు క్యాకిరి సంతోసం పర్చిపారి బులి లోకవిసయాంరె సెడకు కోసం బాదపొల్లిసి. ");
INSERT INTO rei_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","సాకిరాక నా బ్యా యిలా మొట్ట, కన్యక తా దేరె ఆత్మరె పవిత్రం యిలాపనికిరి రోయితె ప్రబువు విసయరె కార్యములను గురించి దుక్కొపొడిలిసొ గాని బ్యాయికిరి, ");
INSERT INTO rei_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","తొముకు ఆటంకంగా రొమంచెబులి నీ, తొంబొల్ట కోసం కొయిలించి. తొమె బొల్టా పైటిసంగరె, పొదరటకు నా ఆస నాపొడుకుంటా ప్రబువుంపరె ద్రుస్ట లొక్కిరి సెయ్యె సేవ కొరిమంచెబులి మో ఆస. ");
INSERT INTO rei_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","జొనె తా సంగరె బ్య నిస్చయమైలాబెల్లే కన్యకు నాబ్యకొరిగికుండ రొవురొ అక్రమముబులి బులిగీనె, నీనె అముకు వయస్సు బొడిజెవ్వరొ వల్లరె బ్యాకొరిగివురొ అవసరముబులి బులిగిలించి. తంకె బ్యకొరిగివొచ్చు. సెడరె పాపం నీ. ");
INSERT INTO rei_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ఈనె కేసైనె తా జ్యోకు బ్యా కొరివురొ అవసరంనికుంట, సెయ్యె స్తిరచిత్తుడు, తా ఇస్టప్రకారం కొరిలా సక్తి తైయికిరి, తాకు నా బ్యా నీకుంట రొయిదిమంచె బులి తా మనస్సురె నిస్చయించిగినె బొల్లికిరి ప్రవర్తించిలిసి. ");
INSERT INTO rei_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","సడకు తా జ్యోకు బ్యా కొరిలాట బొల్లికిరి ప్రవర్తించిలీసి, బ్యా నాకొరిలాట యింకా బొల్లికిరి ప్రవర్తించిలిసి. ");
INSERT INTO rei_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","నైపో తా గొయిత జీకిరి రొల్లెత్తె కలొ బద్దురాలు యీకిరి తమ్మాసి, గొయిత మొరిజిన్నె తాకు ఇస్టమైలలింకు బ్యా కొరిగినితె స్వతంత్రురాలు యీకిరి తాసి గాని ప్రబువురె మాత్రమాక బ్యా కొరిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ఈనె సెయ్యె రండింట పనికిరిరొన్నె సెయ్యె దన్యురాలుబులి మో అబిప్రాయం. పురువు ఆత్మ మెత్తె కూడ కలిగికిరి అచ్చిబులి తలిసిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","విగ్రహానెకు బలిగా అర్పించిలా విసయంరె అమల్లా జ్ఞానము ఈలాలింకె పనికిరి తెలుసు. జ్ఞానము గర్వపొడిలా పనికిరి కొరివొ. గాని ప్రేమ క్సేమాబివ్రుద్ది కలిగించుసి. ");
INSERT INTO rei_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","కేసైనా తాకు కిర ఈనెను నాబుజ్జిలాటనీ బులికిరి కొయిగిన్నే, సెయ్యె తెలిసిగిల్లా పనికిరి ఇంక తాకు తెలిసిగిత్తే కిచ్చీ నీ. ");
INSERT INTO rei_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","జొనె పురువుకు ప్రేమించినే సెయ్యె పురువుకు తెలిసిలా పనికిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ఈనె విగ్రహానెకు బలిగా అర్పించిలాంచకు కైలాంచ విసయంరె లొకంరె విగ్రహాలు సుచ్చాంచ బులికిరి, పురువు జొన్నాక తప్ప ఇంగుటె పురువు నీబులికిరి తెలిసిగించొ. ");
INSERT INTO rei_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","పురువునె బులి డక్కితల్లాలింకెంక ప్రబువు బులి డక్కితల్లాలింకె బడేలింకె అచ్చె. మెగోనంపరె ఈనెను బూమి ఉంపరె ఈనెను పురువు బులి డక్కితల్లా సొబ్బిలింకు, ");
INSERT INTO rei_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ఈనె అముకు జొన్నాక పురువు అచ్చి. సెయ్యె బో; తాదీకిరి సొబ్బి కూడా కలిగిసి; తా నిమిత్తము అమె అచ్చొ. ఈనె అముకు ప్రబువు జొన్నాక; సెయ్యె యేసు క్రీస్తు; తాదీకిరి సొబ్బి కలిగిసి; అమె తా దీకిరాక జీలించొ. ");
INSERT INTO rei_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ఈనె సొబ్బిలింకె సత్యంకు నా తెలిసిగిల్లాలింకె పనికిరి అచ్చె. కుండిలింకె యెడకగరె తంకు విగ్రహానెకు ఆరాదించిలలింకె గనక తంకె కయిలా కద్దీనె విగ్రహానెకు బలి దిల్లాట బులి బచ్చికిరి కయితోసె. తంకు మనస్సాక్సి బలహినమైలందరె అపవిత్రమైజీసె బులిగిచ్చె; ");
INSERT INTO rei_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","కద్ది వల్లరె పురువు పక్కరె అమె మెప్పుపొందినింతొ; నాకయిలవలరె అముకు తక్కువని, కయిలందరె అముకు బూతునీ. ");
INSERT INTO rei_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ఈనె తొముకు కలిగిలా ఏ స్వాతంత్రము వల్లరె విస్వాసంరె బలంనిలాలింకె పాపంరె నాపొడుకుంటా దిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","కైంకిబుల్నే జ్ఞానము గలిగిలా తువ్వు విగ్రహాలు పక్కరె కద్దీనిరె బొసిలాబెల్లె జొనె దిగిలీసి, బలహీనమైలా మనస్సాక్సిగల్లా సెయ్యె విగ్రహానెకు బలిదిల్లా పదార్దములుకు కయితె దైర్యము దన్నైగిచ్చేనీనా? ");
INSERT INTO rei_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","సడకు కాకోసం క్రీస్తు మొరిజీసివొ సే నాబలం రొల్లా సే తో బయి తో జ్ఞానము వల్లరె నసించుజూసి. ");
INSERT INTO rei_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","యాకిరి బయినెకు విరోదముగా పాపము కొరిలందరె, తంకె బలహీనమైలా మనసాక్సికు బొత్తలొగివురొ వల్లరె, తొమె క్రీస్తుకు విరోదముగా పాపము కొరిలాలింకె ఈలీసొ. ");
INSERT INTO rei_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","కాబట్టి కద్ది పదార్దములు వలరె మో బయినెకు అబ్యంతరము కలిగివురొ వలరె, మో బయినెకు అబ్యంతరము నాకలిగికుంటా రొల్లపనికిరి మియి కెబ్బుకు మోసో కయినీ. ");
INSERT INTO rei_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","మియి స్వతంత్రుడు నీనా? మీయి అపొస్తులుడు నీనా? అమె ప్రబువైలా యేసుకు మీ దిగిలానినా? ప్రబువురె మోపైటినుకు పలము తొమె నీనా? ");
INSERT INTO rei_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","పొదరిలింకు మీయి అపొస్తులుడు నీనెను తొం మట్టుకినెను అపొస్తులు దీకిరి అచ్చి. ప్రబువురె మో అపోస్తులత్వముకు ముద్రగా రొల్లలింకె తొమె నీనా? ");
INSERT INTO rei_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","మెత్తె విమర్సించిలలింకు మీ కొయిలా సమాదానం ఎడాక. ");
INSERT INTO rei_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","కైతందుకు పీతందుకు అముకు అదికారం నీనా? ");
INSERT INTO rei_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","తల్లా పొదరె అపొస్తులులింకె పనికిరి, ప్రబువురొ బయినెపనికిరి, పేతురు పనికిరి విస్వాసురాలు ఈలా నైపోకు పొచ్చాడె నీజీతె అముకు అదికము నీనా? ");
INSERT INTO rei_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ఈనె పైటి నాకొరితె మీయి, ఇంకా బర్నబా మాత్రమాక అదికారం అచ్చినా? ");
INSERT INTO rei_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","కేసైనన్నా తా సోంత కర్చు లొగ్గీకిరి దండురె పైటికొరుసినా? ద్రాక్సతొట పొక్కిరి సడ పలము నాకైయిలాట కేసె? మందకు జొక్కిరి మందరొ దుద్దొ నాపీలాట కేసె? ");
INSERT INTO rei_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ఏ కొతానె లోకాచరము బట్టి కొయిలించినా? దర్మసాస్త్రమంకా యెడకు కొయిలీసి నీనా? ");
INSERT INTO rei_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","కొల మండితల్లా గయిరొ తుండొకు చిక్కము లొగితెనా బులి మోసే దర్మసాస్త్రమురె రాసికిరి అచ్చి. పురువు గయినె కొరకు విచారించిలినా? ");
INSERT INTO rei_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","కేవలం అమె కోసం ఎడకు కొయిలీసి అవును, అంకోసంనీనా ఏ కొత రాసికిరి అచ్చి? క్యాకిరిబుల్నే, దున్నిలాట ఆస సంగరె దున్నివాసి, కొల మండిలాట బిల్లొరె పాలుపొందిమంచెబులి ఆససంగరె మండిపించిమాసి. ");
INSERT INTO rei_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","తొము కోసం ఆత్మ సంబందమైలాంచ అమె పొగిలబెల్లె తొం వల్లరె దేసంబందమైలా పొగలానె కట్టిగిత్తె బొట్ట పైటికిరా? ");
INSERT INTO rei_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","పొదరలింకు తొమంపరె ఏ అదికారంరె పాలుకలిగినె అముకు బడేట తాసి నీనా? ఈనె అమె ఏ అదికారముకు ఉపయోగించిగిల్లానింతొ; క్రీస్తు సువార్తకు కే అబ్యంతరము ఈనన్నా నాకలుగుకుంటా సొబ్బి బరించిలించో. ");
INSERT INTO rei_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","మందిరంరె పైటి కొరిలాలింకె మందిరం దీకిరి కద్ది మిలుసి. బలిపీటం పక్కరె పైటికొరిలాలింకు బలిదిల్లాటరె వాటా మిలుసిబులి తెలుసునీనా? ");
INSERT INTO rei_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","సాకిరాక సువార్త కొయిలాలింకు సువార్త వల్లరె జీవించిమాసిబులి ప్రబువు నియమించిసి. ");
INSERT INTO rei_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","మీ ఈనె ఆండ్రె కిరయినెను ఉపయోగించిగిల్లాని; తొమె మోవల్లరె యాకిరి జరిగించిమాసి బులి యే కొతానె రాసిలాని. కేసె ఈనెను మో అతిసయ అదికారముకు వ్యర్దము కొర్నే మెత్తె మొరిజివ్వురాక బొల్ట. ");
INSERT INTO rei_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ఈనె మి సువార్త ప్రకటించిలందుకు గొప్పలు కొయిగిన్నీ. సువార్త బోదించివురొ మో బాద్యత. మియి సువార్త నాబోదించినె మెత్తె కొస్టొ. ");
INSERT INTO rei_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","యెడ మియి ఇస్టపొడికిరి కొరినె మెత్తె బొర్తొనొ మిలుసి. నాయిస్టపొడినెను పురువు యే బాజిత మెత్తె అప్పగించిసె. ");
INSERT INTO rei_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","సాకిరైనె మెత్తె బొర్తొనొ కిర? మియి సువార్త ప్రకటించిలబెల్లె సువార్తరె మెత్తె తల్లా అదికారముకు పరిపూర్నముగా నావినియోగించికిరి సువార్త సుచ్చరాక ప్రకటించివురొ మో బొర్తొనొ. ");
INSERT INTO rei_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","మియి సొబ్బిలింకె విసయంరె స్వతండైకిరి అచ్చి. బడెమందికు సంపాదించిగిత్తె సొబ్బిలింకు మెత్తె మీయి పైటిమోపొగా కొరిగించి. ");
INSERT INTO rei_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","యూదునెకు సంపాదించిగిత్తే యూదునెకు యూదుపనికిరాక రొల్లించి. దర్మసాస్త్రముకు నాలొబొడిలలింకు సంపాదించిగిత్తే మీ దర్మసాస్త్రముకు నాలొబొడిలాట ఈనెను, దర్మసాస్త్రముకు లోబొడిలాలింకె పనికిరి రొల్లించి. ");
INSERT INTO rei_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","పురువు విసయంరె దర్మసాస్త్రము నారొల్లాటనీ కాని క్రీస్తు విసయంరె దర్మసాస్త్రముకు లోబొడిలాట. ఈనెను దర్మసాస్త్రము నారొల్లాలింకు సంపాదించిగిత్తె దర్మసాస్త్రము నారొల్లాలింకు దర్మసాస్త్రము నారొల్లాట పనికిరి తల్లించి. ");
INSERT INTO rei_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","బలహీనులుకు సంపాదించిగిత్తే బలహీనులకు బలహీనుడుగా అచ్చి. క్యేకిరి ఈనెను కుండిలింకు రక్సించిమాసిబులి సొబ్బిలింకు సొబ్బి విదముగా తంకమనమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ఈనెను మీయి సువార్త వల్లరె తొమల్లా యే ఆసీర్వాదానె పొందిగిమ్మాసి బులి సొబ్బి కొరించి. ");
INSERT INTO rei_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","దొముడిల పందంరె దొముడిలాలింకె సొబ్బిలింకె దొముడువె గాని జొన్నాక బహుమనము పొందుగునుసి బులి తొముకు తెలిసినినా? సాకిరాక తొమె బహుమానము పొందిలాపనికిరి దొముడొండి. ");
INSERT INTO rei_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ఈనె పందెమురె పోరాడిలా ప్రతీలంకె సొబ్బి విసయములురె తగ్గికిరి తాసె. తంకె క్సయమైలా కిరీటంకు పొందిగితెను, అమె ఈనె అక్సయమైల కిరీటంకు పొందిగిత్తె తగ్గికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","సడుకాక మీ సరైలా గురి కలిక్కిరి దొమిడిలించి వ్యర్దముగా పోరాడిలాని. బా మరిలాపనికిరి మీ పోట్లాడనీ గని గుటెబెల్లె పొదరిలింకు ప్రకటించిలా తర్వాతరె ");
INSERT INTO rei_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","మీయి మో దేకు నలగమరిగీకిరి మో స్వాదీనంరె రొగ్గించి మో బహుమానంకు వొరదగిన్నాసి బులి ప్రయాస పొడిలించి. ");
INSERT INTO rei_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","మో జట్టుకారీనెలింకె మియ్యె తొత్తె గుర్తు కొరిగిల్లించి బులిగిల్లించి మోసే కల్లొరె సంగితెనే తొముకు సెడకిర బుల్నే, అమె పితురులునె మెగొనె తొల్లె కాపాడుబొడికిరి తంకె సొబ్బిలింకె గొర్రసొంద్రొరె ఉంపరె దీకిరి కిచ్చి నాయికుంటా సలికిరి జేసె, ");
INSERT INTO rei_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","మోసేకు సంగరె జెల్లాలింకె మేగొనెరె సొంద్రొరె బాప్టీసం పొందిగిసె, ");
INSERT INTO rei_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","సొబ్బిలింకె ఆత్మ సంబందమైలా గుట్టాక కద్ది కయిసె. ");
INSERT INTO rei_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","సొబ్బిలింకె ఆత్మ సంబందమైలా గుటె పానీయముకు పానము కొరిసె. కెడబుల్నే తంకె సంగరెజేల్లాలింకె ఆత్మ సంబందమైలా బండపొత్రొటా పీసె; సె బండ క్రీస్తాక. ");
INSERT INTO rei_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ఈనె తంకె బిత్తరె బడెలింకె పురువుకు ఇస్టంగా నింతె సెడకు బొనొరె మొరిజీసె తాత మొర్రిదే బొనొరె గతించిజీసి. ");
INSERT INTO rei_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","తంకె ఆసించిలా పనికిరి అమె నాబొల్లతల్లాట నా ఆసించిలా పనికిరి ఏ సంగితినె అమె అంకీనెకు దిగిలపనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","“మనమానె కయితె పితే బొసిరిసె, కెలితె వుటిసె.” లేకనానె బులికిరి రాసిలా పనికిరి తంకెబిత్తరె కుండిలింకె పనికిరి తొమె విగ్రహారదకులలైకిరి రొయితనాండి. ");
INSERT INTO rei_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ఈనె తంకె పనికిరి అమె దర్నిపైటి నాకొరికుంట తమ్మండి; తంకెబిత్తరె కుండిలింకె దర్నిపైటి కొరిలావల్లరె గుటెదినాక ఇరువది మూడువేల మంది మొరిజిసె. ");
INSERT INTO rei_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","అమె ప్రబువుకు బాదలొగిలా పనికిరి సోదించిలించొ, తంకె బిత్తరె కుండిలింకె సోదించికిరి సప్పొను వల్లరె మొరిజిసె. ");
INSERT INTO rei_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","తొమె నాసొనిగిండి; తంకె బిత్తరె కుండిలింకె సొనిగీకిరి మొర్నొదూత వలరె మొరిజిసె. ");
INSERT INTO rei_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ఏ సంగితినె అంకినె సంగరె దిగిలపనికిరి హెచ్చిరికగా అచ్చి తంకు సంబవించిసి, అంతంకలొరె తల్లాపనికిరి అముకు కలిగితె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","మియి టారికిరి అచ్చి బులికిరి తలంచిగిల్లాలింకె నాపొడిజికుంటా జాగర్తగా దిగెండి. ");
INSERT INTO rei_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","సాదారనంగా మనమనకు కలిగిల సోదనతప్ప ఈనె కిచ్చి తొముకు సంబవించిలానీ. పురువు నమ్మదగిలాట; తొమె సహింప గలిగిలెత్తుకన్న బూతు సెయ్యె తొముకు సోదింపబొడినీ. సెత్తనీ, సహింపకలిగితె తాకు సోదన సంగరె కూడ తప్పించిగిల్లా బట్టొ కొరుసి ");
INSERT INTO rei_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ఈనె మో జట్టుకారీనెలింకె, విగ్రహారాదనకు దూరు టారించి. ");
INSERT INTO rei_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","బుద్దిమంతులు సంగరె కొతలగిల పనికిరి తొమె సంగరె కొతలగిలించి, మీయి కొయిల సంగతకు తొమెకా ఆలోచించొండి. ");
INSERT INTO rei_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","అమె దీవించికిరి ఆసిర్వాచనపు పాత్రబిత్తెరొల్లాట పివురొ క్రీస్తు రొగొతొ పాలుపొందిగివ్వరొనినా! ఈనె అమె బంగిల్లా రొట్టె కైయివురొ క్రీస్తు దేరె పాలుపొందివ్వరొనినా. ");
INSERT INTO rei_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","అమె సొబ్బిలింకె సె గుట్టాక రొట్టెరె పాలుపొందిగిలించో, రొట్టె గుటె ఈనె బడేంచయీల అమె గుట్టాక దే యికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","దే ప్రకారముమైలా ఇస్రాయేలుకు దిగొండి. బలి అర్పించిలా సెడకు కయిలలింకె బలిపీటము సంగరె పాలుపొందిగిలీసొ. ");
INSERT INTO rei_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ఇంక మియ్యి కొయిలాట కిరబుల్నె? విగ్రహార్పిపించివురొ కిర రొల్లాటయినెను విగ్రహాములరె కిర రొల్లటయినెను కొయిలించొనా? ");
INSERT INTO rei_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","నీ గాని, పురువు నానమ్మిగిల్లాలింకె అర్పించిలా బలీనె పురువుకు నీ బుత్తొనుకు అర్పించిలిసెబులి కొయిలించి. తొమె బుత్తొనె సంగరె పాలుపొందిగీతె మెత్తె ఇస్టం నీ. ");
INSERT INTO rei_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","తొమె ప్రబు పాత్రరొల్లాట సాకరాక బుత్తొనె పాత్రరొల్లట కూడా పీనారొ ప్రబువురొ బల్లంపరెతల్లా తాండె సెడ బిత్తరొల్లటా బుత్తొనె బల్లవొంపరె తల్లా సెడబిత్తరె కూడ పాలుపొందిగీనాసె. ");
INSERT INTO rei_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ప్రబువుకు రగ్గొ దాన్నెపారొనా? తాకన్నా అమె బలంగలలింకెనా? ");
INSERT INTO rei_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","సోబ్బి విసయాంలరె మెత్తె స్వాతంత్రము కలిగినీ గాని సొబ్బి కొరిలంచ నీ. సొబ్బిటి బిత్తరె మెత్తె స్వాతంత్రము కలిగినీ గాని సొబ్బి క్సేమాబివ్రుద్ది దిన్ను. ");
INSERT INTO rei_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","కేసెనె తా కోసం నీ, ఎదుటి లింకె కోసం బొల్టా దిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","మనస్సాక్సి అబ్యంతరంనీనె సొంతరె బిక్కిలాట మోసొ కే ప్రస్న నాపొచ్చురుకుంట కెడయీనె కైయివొచ్చు. ");
INSERT INTO rei_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","“బూమి తాండె బిత్తరెరొల్లా సొబ్బి ప్రబువురోంచ బులి లేకనాన్రె రాసికిరి అచ్చి.” ");
INSERT INTO rei_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","అవిస్వాసినె సంగరె గుటె తొముకు కద్దికు డక్కిలాబెల్లె జేతె తొముకు మనస్సురొలబెల్లె తొముకు దిల్లాంచకిరయినెను సెడకు గురించి మనస్సాక్సి నిమిత్తము కే విచారన నాకొరుకుండ కాండి. ");
INSERT INTO rei_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ఈనె కేసినెను తొంసంగరె ఎడ బలి అర్పించిలాటబులి కొయినె సెటా తెలిసిలాబెల్లె మనస్సాక్సి నిమిత్తము నా కాండి. ");
INSERT INTO rei_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","మనస్సాక్సి నిమిత్తముగా తో సోంత మనస్సాక్సి నిమిత్తము నీ పొదరిలింకె మనస్సాక్సి నిమిత్తమకా యాకిరి కొయిలించి. కిరుకుబుల్నే పొదరిలింకె మనస్సాక్సబట్టి మో స్వాతంత్రము విసయంరె తీర్పు తీర్చువురొ క్యేకిరి? ");
INSERT INTO rei_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","మియ్యి క్రుతజ్ఞత సంగరె కడిగిన్నె మియ్యి కిడవల్లరె క్రుతజ్ఞతా చెల్లించిలించొ సెడ వల్లరె మియ్యి దూసింపబొడివురొ కిర? ");
INSERT INTO rei_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ఈనె తొమె కయినెను, పీనెను తొమె కిర కొరినెను సొబ్బి పురువొ మహిమ కోసం కొరొండి. ");
INSERT INTO rei_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","యూదునెకు యీనెను, గ్రీసుదెసొలింకు యీనెను, పురువురొ సంగముకు యీనెను అబ్యంతరము కొరితెనాండి. ");
INSERT INTO rei_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","యాకిరి మియ్యి కూడ సొంత ప్రయోజనాలు నాదిగీకుండా, బడేలింకె రక్సంపబొడిమంచె బులి తంకె ప్రయోజనం కలిగిమంచె బులి, సోబ్బి విసయములరె సొబ్బిలింకు సంతోసం లొగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","మియ్యి క్రీస్తు పోలికిరి సలిగిలా పనికిరి తొమెకూడ మెత్తె పోలికిరి సాలిగిండి. ");
INSERT INTO rei_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","తొమె సొబ్బి విసయాంలరె మెత్తె జ్ఞాపకం కొరిగికుంట, మియ్యి తొముకు అప్పగించిల బోదనుకు పాటించిలందుకు తొముకు మెచ్చిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ప్రతి మనమకు సిరస్సు క్రీస్తాక, తిల్డ్రాటకు సిరస్సు వొండ్రపోబులి, క్రీస్తుకు సిరస్సు పురువు బులి తొమె తెలిసిగిమంచె బులి కోరిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","కే వొండ్రపో ముండొవుంపరె ముసుకు పొగికిరి ప్రార్దన కొరుసివో నీనె ప్రకటనాకొరసొ, సె వొండ్రపో తా ముండొకు క్రీస్తుకు అవమానం కొరిలా పనికిరాక. ");
INSERT INTO rei_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ఏ తిల్డ్రాట ముండొవుంపరె ముసుకు పొగికిరి ప్రార్దనకొరిసివో నీనా ప్రకటనాకొరసొ, సె తా తిల్డ్రాట ముండొవుంపరె అవమానం కొరిసి; కెడబుల్నే సెడ తాకు గుండు కొరిలాపనికిరాక తాసి. ");
INSERT INTO rei_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","తిల్డ్రాట ముసుకు పొగినె తా ముండొరొ బల్లొనె కత్తిరించిగిమంచె. కత్తిరించిగినెను గుండు కొరిగితె యినెను తిల్డ్రాట అవమానముయినెను సెయ్యె ముసుకు పొగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","వొండ్రపోయినె పురువు పొలికిరి మాహిమయికిరి అచ్చి సెడకు ముండొవుంపరె ముసుకు పొగినాసి ఈనె తిల్డ్రాట వొండ్రపోకు మహిమయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","కెడబుల్నే తిల్డ్రాట వొండ్రపోదికిరి అయివొగని వొండ్రపో తిల్డ్రాట దీకిరి కలిగిలాని. ");
INSERT INTO rei_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ఈనె తిల్డ్రాటకు వొండ్రపో కోసం గాని వొండ్రపో తిల్డ్రాట కోసం కొరిలాని. ");
INSERT INTO rei_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","సెడకు దూతానె నిమిత్తము తిల్డ్రాలింకె యిల్లా తొమె ముండొవుంపరె ముసుకు పొగిండి సెడ గొయితకు గురించి రొసి. ");
INSERT INTO rei_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ఈనె ప్రబువురె తిల్డ్రాటకు వేరుగా వొండ్రపోనీ వొండ్రపోకు వేరుగా తిల్డ్రాటనీ. ");
INSERT INTO rei_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","తిల్డ్రాటకు వొండ్రపో దికిరి క్యాకిరి అయిసొ సాకిరి వొండ్రపో తిల్డ్రాటకు మూలముగా అయిసి, ఈనె సొబ్బికూడ పురువు మూలముగ కలిగీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","తొంబిత్తరె తొమె నిర్నయంకడిగెండి; తిల్డ్రాటకు ముసుకు నీకిరి పురువుకు ప్రార్దనకొరువురొ బొల్టనా? ");
INSERT INTO rei_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","వొండ్రపో ముండొరొ బల్లొనె పుసిగితె తాకు అవమానం బులి స్వబావసిద్దముగ తొముకు తెలిసినీనా? ");
INSERT INTO rei_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","తిల్డ్రాటకు ముండొరొ బల్లొనె పైటిసెంగు పనికిరి దివ్వరొయిసి సెడకు తా ముండొరొ బల్లొనె పుసిగివురొ తాకు గౌరవంగా తాసి. ");
INSERT INTO rei_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","కెసియీనెను సెడవల్లరె కొలీనెలగ్గిలాలింకె అమె బిత్తరెయినెను పురువు సంగమురె యినెను ఏటాపన ఆచారమూనె నిబులి సెయ్యె తెలిసిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","తొముకు ఏ ఆజ్ఞానెకు దీకుంటా తొముకు మెచ్చిగించి. తొంకూడికిరి అయివురొ బూతు కీడుకుగాని బూతు మేలుకు నీ. ");
INSERT INTO rei_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","అగరె సంగతి కిరబుల్నే, తొమె సంగమురె సొబ్బిలింకె రొల్లాబెల్లె తొమె బిత్తరె కక్సలు అయిలి బులి సునిలించి. కుండెమట్టుకు ఎడ సోత్తెబులికిరి నమ్మిలించి. ");
INSERT INTO rei_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","తొమె బిత్తరె యోగ్యులైలా తంకె కెసెవో దిగదిలపనికిరి తొమె బిత్తరె విరిజేవ్వొరొ తప్పినీ. ");
INSERT INTO rei_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","తొమెల్లా మిసికిరి అయిలబెల్లె తొమె ప్రబువు రాత్తి కద్ది బొల్టాట కొరిలాని. ");
INSERT INTO rei_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","కేడబుల్నె తొమె సె కద్ది కైలబెల్లె జొనెకంటా జొనె అగరె తా మట్టుకు సెయ్యె కద్ది కైయిలీసె; సెడకు జొనె బొక్కొలిసి ఇంకజొనె మత్తుయిలిసె. ");
INSERT INTO rei_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ఎడకిర? కైయితె పితే తొముకు గొరొనీనా? పురువు సంగముకు లెక్కనకొరుకుండ పేదలింకు లజ్జొకడిలిసొనా? తొమె సంగరె కిర కొయిలించి. ఎడకు గురించి తొముకు మెచ్చిగిమినా? మెచ్చిగినీ. ");
INSERT INTO rei_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","మీ తొముకు అప్పజెప్పిలా సెడకు ప్రబువువల్లరె పొందించి. ప్రబువుయిలా యేసు సెయ్యె అప్పిగించబొడిలా రాత్రిరె గుటె రొట్టెకు టెక్కికిరి, ");
INSERT INTO rei_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","క్రుతజ్ఞత చెల్లించిసి, సెడకు బగికిరి ఎడ తొమె కోసం యిలా మో దే; మెత్తె గుర్తు దనిగిత్తె ఎడకు కొరుబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","సెడ పనికిరి కద్దియీజిల్లా తర్వాతరె గిన్నె టెక్కికిరి ఎ గిన్నె మో రొగొతొయిలా నో నిబందన, “తొమె ఎడబిత్తరోట పీలాబెల్లెల్లా మెత్తె గుర్తు” దనిగిత్తె ఎడకు కొరుబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","తొమె ఏ రొట్టెకు కైకిరి, ఏ గిన్నెరొల్లాట పీలబెల్లెల్లా ప్రబువు అయిలజాంక తా మొర్నొకు ప్రకటించసో. ");
INSERT INTO rei_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","కాబట్టి కేసె అయోగ్యముగా ప్రబువురొ రొట్టెకు కైసివో, నీనె తా గిన్నెరొల్లాట పీసెవో, సెయ్య ప్రబువురో దేకు గురించి రొగొతొ గురించి పాపంకొరిలటా వుసి. ");
INSERT INTO rei_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","కాబట్టి ప్రతి మనమా తాకుసెయ్యె పరిక్సంచిగిమంచె; సాకొరికిరి సె రోట్టుకు కైకిరి, సె గిన్నెరొల్లాట పీమంచె. ");
INSERT INTO rei_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ప్రబువు దేబులి నాబులిగికుండ కైకిరి పీలటా సిక్సవిది కలిగితె కైకిరి పీలిసి. ");
INSERT INTO rei_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","యే కారనం తొమె బిత్తరె బడెలింకె బలహీనులికిరి జబ్బుగా అచ్చె; బడెలింకె మొర్నిజీసె. ");
INSERT INTO rei_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ఈనె అముకు అంకా పరీక్సంచిగినె తీర్పు నాపొందుకుంటా తాంచొ. ");
INSERT INTO rei_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","అమె తీర్పు పొందినె లోకొంసంగరె పాటు అముకు సిక్సవిది నాకలిగిలపనికిరి ప్రబువు అత్తరె సిక్సింపబొడిలించొ. ");
INSERT INTO rei_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ఈనె మో జట్టుకారీనెలింకె ఈనె, బల్ల విసయంరె తొమె మిసికిరి అయిలబెల్లె జొనెకోసం జొనె జొగ్గీకిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","తొమె మిసికిరి అయివురొ సిక్సవిదికు కారనం నీకుండ తల్లాపనికిరి, కేసినెను బొక్కొసంగరె రొల్లాబెల్లె తా గొరొరె కద్ది కైయిమంచె. మీయ్యె అయిలాబెల్లె మిగిల్లా సంగితినెకు ఆజ్ఞానె దూంచి. ");
INSERT INTO rei_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ఈనె మో జట్టుకారీనెలింకె ఆత్మసంబందమైలా వరమూనె కోసం తొముకు నాతెలిసిలాట మెత్తె ఇస్టం నీ. ");
INSERT INTO rei_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","తొమె యూదునెనీలాలింకె పనికిరి రొల్లబెల్లె నాకొతలాగిల విగ్రహముకు పూజాకొర్లినందుకు సెడకు సలిపించుబొడిసి బులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ఎడకు పురువు ఆత్మ వలరె కొతలాగిలాట కేసినెను యేసు సాపగ్రస్తుడుబులి కొయినీ, పరిసుద్దాత్మ వల్లరె తప్ప కేసినెను యేసు ప్రబువు బులి అంగీకరించిలీసె మియి తొత్తె కొయిపారి. ");
INSERT INTO rei_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ఆత్మసంబందమైలా వరమూనె బడేవిదలగా అచ్చి ఈనె సె గుటె ఆత్మ అముకు దూసు. ");
INSERT INTO rei_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ఈనె పరిచర్యానె బడే రకానెగా అచ్చె గని సే ప్రబువుకు జొన్నాకాక సేవ కొరిలీసె. ");
INSERT INTO rei_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","బడేరకానెపైటినె అచ్చి గాని సొబ్బిలింకె బిత్తరె సొబ్బిటికు జరిగించిలా పురువు జొన్నాక. ");
INSERT INTO rei_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ఈనెను సొబ్బిలింకె బిత్తరె ప్రయోజనము కోసం ప్రతిజోనుకు ఆత్మ ప్రత్యక్సత అనుగ్రహించికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","క్యాకిరి బుల్నే, జొనుకు ఆత్మ వల్లరె బుద్ది వాక్యముకు, ఇంక జొనెకు సె ఆత్మకు పాటించిలా జ్ఞానవాక్యము, దివ్వురూసి. ");
INSERT INTO rei_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ఇంకజొనుకు సె ఆత్మవల్లరాక విస్వాసముకు, ఇంకజొనుకు సె గుటె ఆత్మవల్లరాక స్వస్దపరిచిలా వరములకు, దివ్వురూసి. ");
INSERT INTO rei_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ఇంకజొనుకు అద్బుత పైటినె కొరిలా సక్తి, ఇంకజొనుకు ప్రవచన వరముకు, ఇంకజొనుకు ఆత్మల వివేచన, ఇంకజొనుకు నానావిద బసోనె, ఈనె ఇంకజొనుకు బసోనె అర్దం కొయిల్ల సక్తి అనుగ్రహించికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ఈనెను ఎడల్లకు సె ఆత్మ గుట్టాక తా చిత్తము చొప్పురె ప్రతిజోనుకు ప్రత్యేకంగ బంటిదీకిరి కార్యసిద్ది కలిగించిలీసి. ");
INSERT INTO rei_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","క్యాకిరి దే గుటెయిలాబెల్లె బడె అవయవమునెకు కలిగీకిరి అచ్చివొ, క్యాకిరి దేరో అవయవమునె సొబ్బి గుట్టాక దేయికిరి అచ్చి, సాకరాక క్రీస్తు అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","క్యాకిరి బుల్నే, యూదునె యీనెను, గ్రీసుదెసొలింకె యీనెను, దాసునె యీనెను, స్వతంత్రలుయినెను, అమల్లా గుటె దేబిత్తరకు సె ఆత్మరె బాప్టీసం కడిగించొ. అమల్లా గుట్టాక ఆత్మ సె అమె మనసురె పూరిపీసి. ");
INSERT INTO rei_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","దే అల్లా గుట్టాక అవయవముగా నారొయికిరి బడే అవయవమునె పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","మీయ్యె అత్తొనీ సేడకు దేబిత్తరొల్లటా నిబులి పాదము కొయిలైత్తు మాత్రము దే బిత్తరొల్లట నికిరినీ. ");
INSERT INTO rei_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ఈనె మియ్యి అంకి నీ సెడకు దే బిత్తరొటా నీబులి కన్నొ కొయిలైత్తమాత్రము దేబిత్తరొట యికిరిని. ");
INSERT INTO rei_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","దేల్లా అంకి సునివురొ కేటె? సొబ్బి సునివురొ ఈనె గొందొ దిగువురొ కేటె? ");
INSERT INTO rei_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ఈనె పురువు అవయవములరె ప్రతిటకు తా చిత్తప్రకారం దేరె రోయిదీసి. ");
INSERT INTO rei_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","సెడల్లా గుట్టాక అవయవమునె యినె దే తాసినా? ");
INSERT INTO rei_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","అవయవమునె బడెయినెను దే గుట్టాక. ");
INSERT INTO rei_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","సెడకు అంకి అత్తొ సంగరె తువ్వు మెత్తె అవసరం నీబులి కొయినాసె; ముండొ, పాదమూనె సంగరె మెత్తె అవసరం నీబులి కొయినాసె. ");
INSERT INTO rei_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","సెత్తనీ దే గుటె అవయవమునెరె కిచ్చి మరి బలహినంపనికిరి దిగదుసివొ సెడ మరి అవసరం. ");
INSERT INTO rei_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","దేరె కే అవయవమునె గనతనిలాటబులి తలించిగిలించొ సె అవయవమునెకు మరి బూతు గనపరిసిలించొ. నా సుందరముతల్లా అమె అవయవమునెకు బూతు ఈలా అందం కలిగిసి. ");
INSERT INTO rei_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","సుందరి తల్లా అమె అవయవమునెకు ఎక్కువగా సుంద్రికిరి తవ్వురొ అవసరం నీ. ");
INSERT INTO rei_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ఈనె దేరె వివాదము నీకిరి, అవయవమునెకు గుటెకు గుటె బూతుగా పరామర్సించిలాపనికిరి, పురువు తక్కుయిటికాక ఎక్కువ గనత కలిగించికిరి, దేకు అమర్చికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ఈనె గుటె అవయవము కొస్టొపొడిలాబెల్లె అవయవమునె సొబ్బి సెడసంగరె కొస్టొపొడిసి; గుటె అవయవము గనత పొందిల్లాబెల్లె అవయవమునె సొబ్బి సెడసంగరె సంతోసించుసి. ");
INSERT INTO rei_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","సెడపనికిరకా, తొమె క్రీస్తురో దేయికిరి రొయికిరి వేరు వేరుగా అవయవములీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ఈనె పురువు సంగమురె అగరె కుండిలింకు అపోస్తునె పనికిరి, సెడ తర్వాతరె కుండిలింకు ప్రవక్తానెపనికిరి, గురువు పనికిరి, అద్బుతానె కొరిలాపనికిరి, కుండిలింకు స్వస్దపరిచిల క్రుపావరమునె పనికిరి, కుండిలింకు సాయంకొరిల్లలింకె, కుండిలింకు ప్రబుత్వమునె కొరిలాపనికిరి, కుండిలింకు నానా బసొనె కొతాలగిల పనికిరి నియమించిసి. ");
INSERT INTO rei_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","సొబ్బి అపొస్తులునా? సొబ్బి ప్రవక్తానెనా? సొబ్బి గురువునెనా? సొబ్బి అద్బుతానె కొరిలాలింకెనా? సొబ్బి స్వస్దదపరిచిలా క్రుపావరమునె గలలింకెనా? ");
INSERT INTO rei_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","సొబ్బి బసొనె సంగరె కొతాలగిలలింసొనా? సొబ్బి సె బసొనె అర్దం కొయిలిసెనా? ");
INSERT INTO rei_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","క్రుపావరములరె స్రెస్టమైలట ఆసక్తిసంగరె పొందినిండి. యడ ఈనెను సర్వోత్తముమిలా బట్టొకు తొముకు దిగిదిలించి. ");
INSERT INTO rei_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","మనమారొ బసొ సంగరె దేవదూతలరొ బసొనె సంగరె మీయ్యె కొతాలగినెను, ప్రేమ నిలాటయినె మ్రోగెడు కంచును గనగనలాడిల తాలముయికిరి రొంచు. ");
INSERT INTO rei_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ప్రవచించిలా క్రుపావరము కలిగీకిరి మర్మములసొబ్బి జ్ఞానంసొబ్బి తెలిసిలాట యినెను, బొనొనుకు పెకలించలబెల్లె పరిపూర్న విస్వాసము గలిగిలట యినెను, ప్రేమ నారొలటయినే మీయ్యె వ్యర్దమిల్లాట. ");
INSERT INTO rei_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","నీలలింకె కద్ది కోసం మో ఆస్తల్లా దినెను, మో దే అప్పగించినెను మోబిత్తరె ప్రేమ నారొయినె ప్రయోజనము కిచ్చినీ. ");
INSERT INTO rei_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ప్రేమ జీవిత కలొ సహించిసి, దయ దిగిదూసి ప్రేమ యిర్సపొడిని; ప్రేమ డంబముగా ప్రవర్తించిని; సెడ ఉప్పొంగిని; ");
INSERT INTO rei_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","అమర్యాదగా సలినీ; స్వప్రయోజనముగా విచారించిగినీ; బేగ రగ్గొపొడినీ; అపకారముకు మనస్సురె రొయిదిగిన్ని. ");
INSERT INTO rei_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","దుర్నితి విసయంరె సంతోసంపొడితెనా సత్యముంరె సంతోసించుసి. ");
INSERT INTO rei_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","సొబ్బిటికు తెలిసి; సొబ్బిటికి నమ్మసి; సొబ్బిటికి నిరీక్సించిసి; సొబ్బిటికు ఓర్స. ");
INSERT INTO rei_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ప్రేమ జీవితాంతం రొసి. ప్రవచనములుయినెను నిరర్దకమునె ఊసి; బసొనినెను టారుజుసి; జ్ఞానంయినెను నిరర్దకమ వుసి; ");
INSERT INTO rei_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","అమె కుండేమట్టుకు తెలుసు, కుండేమట్టుకు ప్రవచించిలించొ గానీ ");
INSERT INTO rei_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","పూర్నమిల్లాట అయిలాబెల్లె నాపూర్నమిలట్టా అంతరించిజోసి. ");
INSERT INTO rei_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","మీ పిల్లాసొ యీకిరి రొల్లాబెల్లె పిల్లాసొ పనికిరి కొతాలగించి, పిల్లాసొ పనికిరి ఊహించిగించి, పిల్లాసొ పనికిరి ఆలోచించి. ఉంచినె బొట్టయికిరి పిల్లాసొరొ చేస్టలు మానిపెంచి. ");
INSERT INTO rei_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ఉంచినె అద్దమురె దిగిల పనికిరి సూచనగా దిగిలించొ; సెల్లె మూరె మూనొక్కిరి దుగుంచొ. ఉంచినె కుండెమట్టుకు తెలిసిగీకిరి అచ్చొ; సెల్లె మీ పూర్తిగా తెలిసిగిల్లా పనికిరి పూర్తిగా తెలిసిగుంచి. ");
INSERT INTO rei_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ఈనె విస్వాసము, ఆస, ప్రేమ ఏ తింట తారొసి; ఆండ్రె స్రేస్టమైలాట ప్రేమాక. ");
INSERT INTO rei_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ప్రేమ కలిగీకిరి రొయితె ప్రయత్నం కొరొండి. ఆత్మ సంబందమైలా వరములకు ఆసక్తితీకిరి కోరుగునొండి. విసేసముగ తొమె ప్రవచన వరముకు కోరుగునొండి. ");
INSERT INTO rei_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","కిరుకుబుల్నే బసో సంగరె కొతాలగిల్లాట మనమనె సంగరె నీ పురువు సంగరె కొతాలగిలిసు; మనమ కెసినెను గ్రహించిని గాని సెయ్యె ఆత్మవల్లరె మర్మములకు కొతాలగిలీసి. ");
INSERT INTO rei_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","క్సేమాబివ్రుద్ది హెచ్చరికయు ఆదరన కలిగిలాపనా, ప్రవచించలలింకె మనమసంగరె కొతానె లాగిలిసి. ");
INSERT INTO rei_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","బసొది కొతానగిలలింకె సెయ్యె క్సేమాబివ్రుద్ది కొరుగూసి గాని ప్రవచించలింకె సంగమురె క్సేమాబివ్రుద్ది కలుగుసు. ");
INSERT INTO rei_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","తొమె అల్లా బసొది కొతాలగిమంచెబులి కోరిగిల్లించి గాని తొమె ప్రవచించెమసి బులి మరి విసేసముగా కోరిగిల్లించి. సంగము క్సేమాబివ్రుద్ది కడిగీరి నిమిత్తము బసొది కొతాలగిలాలింకె అర్దం కొయినగాని తాపనా ప్రవచించులలింకె స్రేస్టుడు. ");
INSERT INTO rei_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","మో జట్టుకారీనెలింకె, ఆలోచించొండి; బసొది కొతాలకుంటా మియ్యె తొ పక్కు అయికిరి సత్యమును డొరొపొడిసిబులి జ్ఞానోపదేసం కొరిమంచెబులి ప్రవచించిమంచెబులి బోదించిమంచెబులి తొమె సంగరె నాకొతా నొగినె, మో వల్లరె తొముకు ప్రయోజనము కిర? ");
INSERT INTO rei_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","పిల్లనగొవిగాని వీనా గాని, నిర్జీవ వస్తువునె వాయించిలబెల్లె, గొలానె సంగరె బేదము నాకొరిలాబెల్లే, ఊదిలాటకిరొ వాయించిలటకిర బులి క్యేకిరి తెలుసు . ");
INSERT INTO rei_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ఈనె బూర స్వస్టము నీలా ద్వని దిలబెల్లె యుద్దమకు కేసె తయారు వూసె? ");
INSERT INTO rei_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","సాకరాక తొమె స్వస్టమైలా కొతానె జిబ్బొ సంగరె పలికినె గని పలికిలట క్యేకిరి తెలిసివో? తొమె బా సంగరె కొతాలాగిల పనికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","లోకొరె కెత్తొ బడే బసోనె అచ్చె, సెడ బిత్తరె గుటెనె స్పస్టమైకిరి తన్ని. ");
INSERT INTO rei_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","కొతానె అర్దం మెత్తె నాతెలిసినె. కొతలగిలాటకు మియ్యి పరదేసియిలా పనికరి తాసి, కొతాలాగిలాట మెత్తె పరదేసి పనికిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","తొమె ఆత్మసంబందమైలా వరమూనె విసయంరె అసక్తిగలిగిలాలింకె సెడకు సంగముకు అబివ్రుద్ది కలిగిలా నిమిత్తము సె తొముకు విస్తరించిలా పనికిరి ప్రయత్నము కొరొండి. ");
INSERT INTO rei_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","బసో సంగరె కొతాలగిలాట అర్దం కొయిలాపనికిరి సక్తికలిగిలపనికిరి ప్రార్దన కొరుమంచె. ");
INSERT INTO rei_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","మియ్యి బసో సంగరె ప్రార్దన కొరినె మో ఆత్మ ప్రార్దనకొరసి గాని మో మనస్సు పాలుపంచిగికిరి తన్ని. ");
INSERT INTO rei_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ఈనె ఆత్మసంగరె ప్రార్దనకొరొంచి, మనస్సు సంగమురె ప్రార్దన కొరుంచి; ఆత్మ సంగరె గాంచి, మనస్సు సంగరె గాంచి. ");
INSERT INTO rei_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","నీనె తువ్వు ఆత్మసంగరె స్తొత్రము కొయిలాబెల్లె ఉపదేసము పొందిలట తువ్వు కొయిలాటకు గ్రహించి నీ సెడకు, తువ్వు క్రుతజ్ఞతాస్తుతులు కొయిలాబెల్లె ఆమేను బులి సెయ్యె క్యేకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","తువుయినె బొల్లాకిరి క్రుతజ్ఞతాస్తుతులు చెల్లించిలీసు ఈనె అగరె తల్లాట క్సమబివ్రుది పొందినీ. ");
INSERT INTO rei_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","మియి తొమె సొబ్బిలింకె కన్నా బూతు బసోనె సంగరె కొతాలాగిలించి; సెడకు పురువు సుత్తించిలించి. ");
INSERT INTO rei_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ఈనెను సంగమురె బసొసంగరె దొస్టవేలు కొతానె కొతాలగువురొ కన్నా, పొదరలింకు బోదకలిగిలాపనికిరి మో మనస్సు సంగరె పాట కొతానె కొతాలగివురొ మేలు. ");
INSERT INTO rei_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","మో జట్టుకారీనెలింకె, తొమె బుద్దివిసయంరె సన్నిపిల్లనెనికిర దుస్టత్వము విసయంరె సిసువులుగా రొయికిరి; బుద్ది విసయంరె బొడిలింకె పనికిరి టారించి. ");
INSERT INTO rei_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","అన్యబసోనె కొతలగిల మనమనె దీకిరి, పొదరె మనమానె వొట్టోనె దీకిరి, ఏ మనమనె సంగరె కొతాలగిపించొంచి; సెల్లె ఈనెను తంకె మో కొతా సున్నింతె బులి ప్రబువు కొయిలీసి బులి లేకనానె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","సెడకు బసోనె విస్వాసునెకు నీ అవిస్వాసినె కాక సూచనయీకిరి అచ్చి. ప్రవచించివురొ అవిస్వాసులకు నీ విస్వాసులకు సుచనయికిర అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","సంగమల్లా గుటెసారి మిసికిరి సొబ్బిలింకె బసో సంగంరె కొతాలగితల్లబెల్లె, ఉపదేసము పొందిలటయినెను మమోలుమనమనె అవిస్వాసులీనెను బిత్తరకు అయిలబెల్లె, తొమె బోడ కొతాలగిలిసో బులి కొయిగిల్లీసొనా? ");
INSERT INTO rei_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ఈనె సొబ్బిలింకె ప్రవచించితలబెల్లె అవిస్వాసినె యినెను ఉపదేసము పొందిలటనెను బిత్తరకు అయిలబెల్లె, సొబ్బిలింకె బొదవలరె సెయ్యె పాపిబులి గ్రహించికిరి, సొబ్బిలింకె వలరె విమర్మింపబొడిసి. ");
INSERT INTO rei_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","సెల్లె సెయ్యె మనస్సు గుట్టునె దొరెపొడసి. ఎడవలరె “పురువు సొత్తకా తొంబిత్తరె అచ్చి!” బులి ప్రచురము కొరుకుంటా సెయ్యె సాగిలిపొడికిరి నమస్కారంకొరిసి. ");
INSERT INTO rei_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","మో జట్టుకారీనెలింకె, ఉంచినె తొంబిత్తరె కిర జరిగిలీసి? తొమె మిసికిరి అయిలాబెల్లె జొనె గుటె కీర్తన గైమంచె బులి అచ్చి; ఇంకజొనె బోదించిమంచెబులి అచ్చి; జొనె తాకు బయిలు పరిచిమంచెబులి ప్రకటనకొరిమంచెబులి అచ్చి; జొనె బసోసంగరె కొతాలగిమంచె బులి అచ్చి; జొనె అర్దం కొయిమంచి బులి అచ్చి;సారక సొబ్బి సంగముబివ్రుద్ది కలిగితె జరిగీవొరొ. ");
INSERT INTO rei_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","బసోసంగరె కెసినెను కొతాలగినె, దీలింకె అవసరమైనె తిల్లింకె మించుకుండ, వంతులు పనికిరి కొతలగిమంచె, జొనె అర్దం కొయిమంచి. ");
INSERT INTO rei_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","అర్దం కొయిలాట నీనె సెయ్యె సంగమురె వొల్లాగా తమ్మంచె గాని, తాసంగరె పురువు సెయ్యె కొతాలగ్గివొచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ప్రవక్తానె దీలింకె తిల్లింకె కొతాలాగివొచ్చు; తక్కిలాలింకె వివేచించిమంచె. ");
INSERT INTO rei_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ఈనె బొసిరిల్లా ఇంకజొనుకు కిరయినెను బయలుపొడినె అగరోట వల్లకిరి తమ్మంచె. ");
INSERT INTO rei_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","సొబ్బిలింకె సుక్కిగిల్లాపనికిరి సొబ్బిలింకె హెచ్చిరిక పొందిలపనికిరి తొమెసొబ్బిలింకె జొనె తర్వాతరె జొనె ప్రవచించివొచ్చు. ");
INSERT INTO rei_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ఈనె ప్రవక్తానె ఆత్మసంగరె ప్రకటించె వరము స్వాదినంరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","సాకరాక పరిసుద్దురొ సంగము సొబ్బిటిరె పురువు సమాదానముకు కర్త గాని అల్లరికు కర్త నీ. ");
INSERT INTO rei_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","తిల్డ్రాటలింకె సంగమురె వల్లాగా తమ్మంచె; తంకె లోబొడికిరి తమ్మంచి గాని, కొతలాగితె తంకు అదికారం నీ. యాకిరి లేకనములు కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","తంకె కిర యినెను సుగ్గిమంచెబులికిరి, గొరొరె తంకె తంకెరొ గొయితానెకు పొచ్చిరిమంచె; సంగమురె తిల్డ్రాలింకె కొతాలగివురొ అవమానము. ");
INSERT INTO rei_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","పురువురొ వాక్యము తొమె పక్కరె దీకిరకా బయలుకు జోసినా? తొమె పక్కు మాత్రమకా అయివొనా? ");
INSERT INTO rei_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","కెసినెను తా ప్రవక్తయినెను ఆత్మసంబందం యినెను బులిగినె, మియి తొముకు రసిలాట ప్రబువురె ఆజ్ఞలబులి సెయ్యె కచ్చితముగా తెలిసిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ఈనె కెసినెను నాతెలిసిలాట ఈనెను నాతెలిసిపనికిరి రొమ్మురొ. ");
INSERT INTO rei_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","కాబట్టి మో జట్టుకారీనెలింకె, ప్రవచించివురొ ఆసక్తి సంగరె అపేక్సించిచాండి, బసొనె సంగరె కొతలాగివురొ ఆపితెనాండి గాని, ");
INSERT INTO rei_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","సొబ్బిటికు మర్యాదగా క్రమముగా జరిగిమురొండి. ");
INSERT INTO rei_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ఈనె మో జట్టుకారీనెలింకె మీయి తొముకు కొయిలా సువార్తకు తొముకు తెలియపరిచిలీంచి తొమె అల్లా విస్వాసము నిలాకడగా టారించి. ");
INSERT INTO rei_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","తొమె సెడకు వొప్పిగినిసొ, సెడబిత్తరె బుల్లీకిరి అచ్చె. తొమె విస్వాసముకు నావ్యర్దమికుండ గాని, మియి కే ఉపదేసరూపంరె సువార్త తొముకు కొయించివొ సె ఉపదేసముకు తొమె గట్టిగా దరిగికిరిరొన్నె సె సువార్తవల్లరె తొముకు రక్సనకలిగిలాలింకె పనికిరి తాసొ. ");
INSERT INTO rei_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","మెత్తెదిల్లా ఉపదేసముకు అగరె తొముకు అప్పజెప్పించి. సాకరాక, లేకనములు ప్రకారము క్రీస్తు అమె పాపలకు వలరె మొర్నిజిసి, ");
INSERT INTO rei_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","లేకనములురె రాసిల పనికిరి సమాదికొరికిరి, సెయ్యె తింట దినొరె బుల్లికిరి జీవం సంగరె ఉటిసి. ");
INSERT INTO rei_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","సెయ్యె పేతురుకు, తర్వాతరె పన్నెండులింకు అపోస్తులుకు దిగదీసి. ");
INSERT INTO rei_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","సె తర్వాతరె తాకు వెంబడించిలా పంచసొయి కన్నా బుతులింకు గుటె గడియరాక దిగదీసి. యంకె తంకెబిత్తరె బడెలింకె ఉంచినెజాంక జీకిరి అచ్చె, ఈనె కుండిలింకె మొర్నిజిసె. ");
INSERT INTO rei_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ఈనె సెయ్యె తర్వాతరె యాకోబుకు, సె తర్వాతరె అపోస్తులు సొబ్బిలింకు దిగదీసి. ");
INSERT INTO rei_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","సొబ్బిలింకన్నా కడపటి కలొరె జొర్నైలా మెత్తెకూడ ఆకరుకు దిగిదీసి; ");
INSERT INTO rei_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","కిరబుల్నే మియి అపోస్తులు సొబ్బిలింకు బిత్తరె తక్కువైలాటని పురువు సంగముకు హింసించిలందరె అపొస్తులుబులిగితె అర్హతనిలాట. ");
INSERT INTO rei_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ఈనెను మియికిర యీకిరి అచ్చివొ సెడ పురువుకు క్రుపవల్లరాక యీకిరి అచ్చి. ఈనె మెత్తె అనుగ్రహింపబొడిలా తా క్రుప నిస్పలము యిలాటనీ గాని, తంకె సొబ్బిలికంటా మియిబుతు ప్రయాస పొడించి. ప్రయాసపొడిలటా మియినీ, మెత్తె తోడైకిరి తల్లా పురువురొ క్రుపాక. ");
INSERT INTO rei_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","మి యీనెకిర తంకె యీనెకిర, సాకరాక మియ్యి ప్రకటించిలించి, సాకరాక తొమెకూడ విస్వాసించొండి. ");
INSERT INTO rei_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","క్రీస్తు మొర్నొదీకిరి ఉటికిరి అచ్చిబులి ప్రకటింపబొడిలాబెల్లె తొమెబిత్తరె కుండెలింకె మొరిజిలలింకె పునరుత్దానముకు నీబులి క్యేకిరి కొయిలీసో? ");
INSERT INTO rei_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","మొరిజిలలింకె పునరుత్దానుముకు నారొన్నె, క్రీస్తు కూడ వుటికిరినీ. ");
INSERT INTO rei_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ఈనె క్రీస్తు వుటికిరి నాతన్నె అమె కొరిలా ప్రకటన వ్యర్దమకా, తొమె విస్వాసముకు వ్యర్దమెకా. ");
INSERT INTO rei_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","పురువు క్రీస్తుకు ఉటదీసిబులి, తా కోసం అమె సాక్సం కొయిలించొ నీనా? మొరిజిలలింకె ఉటినె పురువు తాకు ఉటిదిల్లనీ కాబట్టి అమ్మాక పురువురొ విసయంరె సొరొ సాక్సిలునె పనికిరి దిగదిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","మొరిజిలాలింకె నావుటినె క్రీస్తు కూడ వుటిలానీ. ");
INSERT INTO rei_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","క్రీస్తు ఉటికిరిరొన్నె తొమె విస్వాసము వ్యర్దమకా, తొమెయింక తొమె పాపంబిత్తరకా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","సెత్తనీ, క్రీస్తురె మొరిజీలాలింకె కూడా నసించిలా పనికిరిరాక. ");
INSERT INTO rei_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","అమె ఏ జీవిత కలొ వరకాక క్రీస్తురె నిరీక్సించిలాలింకె యీనె మనమానె సొబ్బిలింకె బిత్తరె అం కన్నా దౌర్బాగ్యులునె కేసే రొన్నింతె. ");
INSERT INTO rei_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ఉంచినినె మొరిజీలాలింకె బిత్తరె అగరె పలముగ క్రీస్తు మొర్నొదీకిరి ఉటికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","గుటె మనమ వల్లరె మొర్నొ అయిసి సెడకు గుటె మనమ వల్లరాక మొరిజిల్లాలింకు పునరుత్దానుము కలిగిసి. ");
INSERT INTO rei_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ఆదాముదీకిరి సొబ్బిలింకె క్యాకిరి మొరిజిల్లీసెవొ, సాకరాక క్రీస్తురె సొబ్బిలింకె జీవురొ వూసి. ");
INSERT INTO rei_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ప్రతిజొనె తా, తా వరసానె చొప్పురె జీవురొ వూసి; అగరె పలము క్రీస్తు; సెడ తరవాత క్రీస్తు అయిలాబెల్లె తల్లలింకె జీవురొ వూసి. ");
INSERT INTO rei_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","సె తర్వాతరె సెయ్యె సొబ్బిటికు ఆదిపత్యముకు, సొబ్బిటిరె అదికారముకు, బలముకు మరికిరి తా బోయిలా పురువుకు రాజ్యము అప్పగించుసి; సెల్లె అంతము ఆసి. ");
INSERT INTO rei_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","కిరుకుబుల్నే తా సత్రువుల సొబ్బిలింకు తా పాదము తొల్లె రొయిదిల్లాజాంక క్రీస్తు రాజ్యపరిపాలన కొరిసి. ");
INSERT INTO rei_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ఈనె చివరకు వొడించిబొడిలా సత్రువూనెకు మొర్నొ. ");
INSERT INTO rei_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","పురువు సొబ్బిటికు క్రీస్తు పాదము తొల్లె లోపరిచికిరి అచ్చి. సోబ్బిను లొబొడికిరి అచ్చిబులి కొయిలాబెల్లె తాకు సొబ్బికూడ లోపరిచిలాట తప్ప సొబ్బిను లోపరిచిబొడికిరి అచ్చిబుల్లా సంగతి వాస్తవమాక. ");
INSERT INTO rei_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ఈనె సొబ్బిను తాకు లోపరిచిబొడికిరి తల్లాబెల్లె పురువు సర్వమురె సర్వమైలా నిమిత్తము పో తాకు సొబ్బిను లొపరిచిలా పురువుకు సెయ్యెకా లొబొడుసి. ");
INSERT INTO rei_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","పున్నరుతనము నారొనె మొరిలలింకె కోసం బాప్టీసం కడిగిలలింకె కిరకొరిసె? మొరిలలింకె మాత్రమ జీనె మొరిలలింకె కోసం తంకె బాప్టీసం కడివురొ కిరుకు? ");
INSERT INTO rei_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ఈనె అమె గడిగడికు మొర్నొ దొరొసంగరె రొవ్వురొకిర? ");
INSERT INTO rei_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","మో జట్టుకారీనెలింకె అమె ప్రబువుయిలా క్రీస్తు యేసురె ఏకమైతె మియ్యి దినొదినొకు మొరిజీలించి బులి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","మనమా పనికిరి, మియ్యి ఎపెసురె మ్రుగముల సంగరె లాగినె మెత్తె లబ్బొకిర? మొరొజీలాలింకె బులికిరి నాజీనె “అయిండి కల్లికు కైయిమా పిమా.” ");
INSERT INTO rei_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","మోసజీతానాండి. దుస్టసాంగత్యము బొల్ట సలకు చెడమరుసి. ");
INSERT INTO rei_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","నీతి ప్రవర్తగలలింకె పనికిరి వుటికిరి, పాపము కొరితెనాండి; పురువు గురించి జ్ఞానము కుండిలింకు నీ. తొముకు లజ్జొ అయితె యాకిరి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ఈనె మొరిజీలాలింకె క్యేకిరి వుటసె? తంకె ఏటాపన దేసంగరె ఆసె బులి జొనె పొచ్చరిలిసి. ");
INSERT INTO rei_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ఓ బుద్దినిలాట, తువ్వు విత్తలట మొరిజినె గాని జీనీ నీనా. ");
INSERT INTO rei_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","తువ్వు విత్తిలాట గురించి దిగినె సెడ గోదుమ గింజ యినెను సరే, ఈనె కే గింజా యినెను సరే, సెడ గింజకాక విత్తిలీసి గాని జొర్నైలా దే విత్తువురొ నీ. ");
INSERT INTO rei_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ఈనె పురువు తా చిత్తప్రకారము తువ్వు విత్తలటకు దే దూసి. ఈనె ప్రతి విత్తోనెకు సడరొ సొంత దే దిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","మోసోబ్బి గుటె విదమైలాట నీ. మనమరొ మోసో వేరు, జంతువునె మోసో వేరు, పక్సీరొ మోసో వేరు, మచ్చొ మోసో వేరు. ");
INSERT INTO rei_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ఈనె మెగొనెరె దే అచ్చి, బూమిరొ దే అచ్చి; మెగొరొ దేనె మహిమ వేరు, బూమిరొ దే వేరు. ");
INSERT INTO rei_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","సూర్యని మహిమ వేరు, చంద్రుడురొ మహిమ వేరు, నక్సత్రమునె మహిమ వేరు, మహిమరె గుటె నక్సత్రముకు ఇంగుటె నక్సత్రముకు బేదము అచ్చి నీనా ");
INSERT INTO rei_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","మొరిజీలాలింకె పునరుత్దనుము సాకరాక. దే క్సయమైకిరి విత్తికిరి అక్సయమైల పనికిరి వుటసె; ");
INSERT INTO rei_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","గనహీనమైలాలింకె బుజ్జీదిలాలింకు గనులుపనికిరి ఉటువురొ వూసి; బలహినమైలా పనికిరి బుజ్జీకిరి, బలమైలపనికిరి వుటువురొ వుసి; ");
INSERT INTO rei_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ప్రక్రుతి సంబందమైలా దేపనికిరి బుజ్జీదికిరి ఆత్మసంబందమైలా దేపనికిరి వుటిసి. ప్రక్రుతిసంబందమైలా దేయిలటా సెడకు ఆత్మసంబందమైలా దే కూడ అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ఏ విసయంరె ఆదాముకు “అగరె మనమా జీకుంటా మనమాయిసి రాసికిరి అచ్చి”. అగరె ఆదాము జీవించిల ఆత్మ యిసి. ");
INSERT INTO rei_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ఆత్మ సంబందమైలాట అగరె కలిగిలాట నీనా, ప్రక్రుతి సంబందమైలా అగరె కలిగిలాట; తర్వాతరె ఆత్మసంబందమైలాట. ");
INSERT INTO rei_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","అగరె మనమా బూసంబందమైలా మట్టిదీకిరి జొర్నైలాట, దీటా మనమా పరలోకందికిరి అయిలాట. ");
INSERT INTO rei_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","మట్టిదీకిరి జొర్నైలాట కెసో మట్టిదీకిరి జొర్నైలాట సాటలింకాక, పరలోక సంబందం కేటవో పరలోక సంబందూనె సాటలింకాక. ");
INSERT INTO rei_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ఈనె అమె మట్టిదికిరి జొర్నైలాటకు పోలిక పొగిలపనికిరి పరలోక సంబందియిలా పోలిక దరించికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","మో జట్టుకారీనెలింకె మియ్యి కొయిలాట కిరబుల్నే రొగొతొ మోసొ పురువురొ రాజ్యముకు స్వతంత్రించుగిను; క్సయత అక్సయతకు స్వతంత్రించిగిను. ");
INSERT INTO rei_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ఇదిగొ తొముకు గుటె కొయిలించి; అమె సొబ్బిలింకె గుమ్మినింతొ గాని నిమిసమురె, గుటె రెప్పపాటురె, కడబూర మ్రోగలాబెల్లే అమె సొబ్బిలింకె మార్పు పొందుసి. ");
INSERT INTO rei_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","బూర మ్రోగుసి; సెల్లె మొర్నొకు అక్సయులుగా ఉటుసె, అమె మర్పు పొందుంచొ. ");
INSERT INTO rei_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","నాసించిలాట ఏ దే అక్సయతకు పిందిగివలిసిలా అవసరం అచ్చి; మర్త్యమైలా ఏ దేకు అమర్త్యతకు పిందిమంచి. ");
INSERT INTO rei_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ఏ నాసించిలాట పిందిగెల్లబెల్లె, ఏ మర్త్యమైలా అమర్త్యతకు పిందిగెల్లబెల్లె, విజయం అగరె మొర్నొ మింగిబొడుసు బులి రాసికిరిరొల్లా వాక్యము నెరవేరుసు. ");
INSERT INTO rei_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ఓ మొర్నొనొ, తో విజయం కేటె? ఓ మొర్నొ, తో కొంట కేటె? ");
INSERT INTO rei_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","మొర్నొ పాపము వల్లరె నాసినము కొరిలా సక్తి పొందుగుసి; పాపముకు దర్మసాస్త్రం వల్లరాక బలం పొందిగిలిసి. ");
INSERT INTO rei_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ఈనెను అమె ప్రబువుయిలా యేసు క్రీస్తు మూలమురె అముకు జయము అనుగ్రహించి తల్లా పురువుకు స్తొత్రము కలుగుసు గాక. ");
INSERT INTO rei_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ఈనె మో జట్టుకారీనెలింకె తో ప్రయాసము ప్రబువురె వ్యర్దమునీబులి తెలిసికిరి, స్తిరులుకు, నాకదిలాలింకె, ప్రబువు కార్యాబివ్రుద్దిరె కెబ్బుకును ఆసక్తి సంగరె రోండి. ");
INSERT INTO rei_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","పురువురొ మనమానె కోసం యిలా చందా విసయం యినె మియ్యి గలతీయ సంగమునెకు నియమించిలా పనికిరి తొమె కూడ కొరొండి. ");
INSERT INTO rei_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","మియ్యి అయిలాబెల్లె చంద నాపోగుకొరుకుండ సొబ్బి అద్దారొరె సొబ్బిలింకె సెయ్యె వర్దిల్లికొలది తాపక్కు కుండె పలియ్య రొయిదిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","మియ్యి అయిలబెల్లె తొమె కాకు యోగ్యునె బులి బచ్చిగీకిరి పత్రికలుదూసో, తంకె అత్తరె తొమె చందాకు యెరూసలేముకు పొడొదుంచొ. ");
INSERT INTO rei_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","మియ్యెకూడా జెవురొ బొల్లటయినె తంకె మోసంగరె కూడ ఆసె. ");
INSERT INTO rei_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ఈనె మాసిదోనియరె బులితె జెమ్మబులిగిల్లించి కాబట్టి మాసిదోనియరె బుల్లితె జెల్లాబెల్లె తొమె పక్కు అచ్చు. ");
INSERT INTO rei_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","సెల్లె తొమె పక్కరె కుండేకలొ రొవుచ్చు, గుటెబెల్లె సిత్తొ కలొల్లా తాంచికీవొ. సెల్లె మియ్యి జెల్లా చోటుకు తొమె మెత్తె పొడిదివొచ్చు. ");
INSERT INTO rei_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ప్రబువు అనుమతి దినె తొమె పక్కరె బుతుకలొ రొమ్మబులి కొయిగిల్లీంచి. సెడకు ఉంచినె బట్టొ మొజీరె తొముకు దిగితె మెత్తె మనస్సునీ. ");
INSERT INTO rei_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ఈనె పెంతెకొస్తు పొరొవొ దినొ జాంక ఎపెసురె రోంచు. ");
INSERT INTO rei_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","కార్యనుకులమైలా బొల్లట అవకాసం మెత్తె పిటికిరి అచ్చి; ఈనె ఎదిరించిలలింకె బడెమంది అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","తిమోతి అయిలాబెల్లె సెయ్యె తొమెపక్కరె నిస్చంతగా రొమంచెబులి దిగిండి, మోపనకా సెయ్యె కూడా ప్రబువు పైటికొరిలిసి. ");
INSERT INTO rei_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","సెడకు కెసన్నా తంకు సన్ని దిగ దిగితనాండి. మోపక్కు అయితె తాకు సమాదానుము సంగరె పోడదెండి; అన్నబయినె, అప్పబొయినినె సంగరె కూడ అయిమంచెబులి ఎదురు దిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","బయిల్లా అపొల్లోరె గురించి సంగతినె కిరబుల్నే, సెయ్యె బయినె సంగరె కూడ తొమె పక్కు జెమంచెబులి మియితాకు బడే బతిమాలిగించి గాని, ఉంచినె అయితె తాకు కే మాత్రము మనస్సునీ, వీలు అయిలాబెల్లె సెయ్యె ఆసి. ");
INSERT INTO rei_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","మెలుకువగా టారించి, విస్వాసంరె టారికిరి టారించి, పౌరుసముగలాలింకె పనికిరి టారించి, బలవంతలైకిరి టారించి; ");
INSERT INTO rei_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","తొమె కొరిలా పైటినల్లా ప్రేమసంగరె కొరొండి. ");
INSERT INTO rei_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","మో జట్టుకారీనెలింకె స్తెపనాసు గొరొలింకె అకయరొ ప్రదమపలమైకిరి అచ్చెబులి, తంకె పురువురొ మనమానెకు పరిచర్య కొరితె తంకు తంకె అప్పగించిగీకిరి అచ్చెబులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","సెడకు మో జట్టుకారీనెలింకె, సెటాలింకు, సహాయము కొరుకుంటా ప్రయసపొడుకుంటా రొయికిరి తంకెల్లకు తొమె విదేయులైకిరి రొమంచెబులి తొముకు బతిమాలిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","స్తెపనాసు, పొర్మూనాతు, అకాయికు బుల్లలింకె అయిలందరె సంతోసించిలించి. తంకెనీలా లోటు తొమె తిర్చిసొ. ");
INSERT INTO rei_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","మో ఆత్మకు తొం ఆత్మకు సుకము కలిగించిసె ఈనె సెటాలింకు సన్మానించొండి. ");
INSERT INTO rei_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ఆసియరె సంగములింకె తొముకు దండమూనె కొయిలీసె. అకుల ప్రిస్కిల్ల బుల్లలింకె, తంకె గొరొరె తల్లా సంగము, ప్రబువురె తొముకు బడే దండమూనె కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","మో జట్టుకారీనెలింకె తొముకు దండమూనె కొయిలీసె. పవిత్రమైల్లా చుమ్మోలొగీకిరి, తొమె జొనుకు జొనె దండమూనె కొయిగీండి. ");
INSERT INTO rei_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","పౌలు మియ్యి మో అత్తొసంగరాక వందనము రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","కెసినెను ప్రబువుకు నాప్రేమించినె సెయ్యె సపింపబొడుసి, ప్రబువు అయిలాబెల్లె ");
INSERT INTO rei_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ప్రబువుయిల్లా యేసుక్రీస్తు క్రుప తొముకు తోడుగా తాసి. ");
INSERT INTO rei_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","క్రీస్తుయేసురె మో ప్రేమ తొమె సొబ్బిలింకె సంగరె తాసి. ఆమేను.");
INSERT INTO rei_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","పురువు చిత్తమువల్లరె క్రీస్తు యేసురొ అపొస్తులుమైల పౌలుకు, అమె అన్న బయిలా తిమోతికు, కొరింతియరె రొల్ల పురువురొ సంగముకు, అకయరె రొల్ల పురువురె రొల్లలింకు సుబము బులి రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","అం బోయిలా పురువు దీకిరి ప్రబుయిలా యేసు క్రీస్తు దీకిరి క్రుప సమాదానముకు తొత్తె కలుగుసు గాక. ");
INSERT INTO rei_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","కనికరము దిగిదిల్లా బో, సొబ్బి ఆదరనకు అనుగ్రహించిలా పురువు, అమె ప్రబువు యీలా యేసు క్రీస్తు బో యీలా పురువు స్తుతింపబొడిమాసి. ");
INSERT INTO rei_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","పురువు అముకు కే ఆదరన దీకిరి ఆదరించిలీసొ, సే ఆదరన సంగరె యెడపనా కొస్టొనె రొల్లలింకె యీనెను ఆదరించిలాటకు సక్తి గలిగిలాట యీలపని, సెయ్యె మో కొస్టొ సొబ్బిటిరె అముకు ఆదరించిలీసి. ");
INSERT INTO rei_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","క్రీస్తురొ కొస్టొనె మోవల్లరె క్యాకిరి విస్తరించిలీసెవొ సాకిరాక క్రీస్తుసంగరె ఆదరనంకా అముకు విస్తరించిలీసి. ");
INSERT INTO rei_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","అమె కొస్టొ పొడినెను తో ఆదరనకోసం రక్సన కోసం పొందుంచొ అమె ఆదరన పొందినెను తో ఆదరన కోసం పొందుంచొ. యే ఆదరన అమె కూడ పొందిలపనా సె కొస్టొనె ఓపికదీ సహించితె కార్యసాదకము ఈలపనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","తొమె కొస్టొన్రె క్యాకిరి పాలివారైకిరి అచ్చొవొ, సాకిరాక ఆదరన తీకిరి పాలివారైకిరి అచ్చెబులి తెలుసును గనక తొముగురించి మో నిరీక్సన స్తిరమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","మో జట్టుకారీనెలింకె ఆసియరె అముకు తటస్తించిలా కొస్టొనె గురించి తొముకు నాతెలిసివురొ అముకు ఇస్టమునీ; సడ కిరబుల్నే అమె జీవించుంచొ బుల్లా నమ్మకము నీనన్నా రొల్లపనాక, మో సక్తికి మించిల అత్యదిక బారము వల్లరె క్రుంగిజిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ఈనె మొర్నొదీకిరి ఉటుదిల్లా పురువు వల్లరె గని, మో సంగరె అమె నమ్మకము నారొల్లపన మొర్నొవూంచుబులి నిస్చయముగా మో మట్టుకు అముకు కలిగికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","సెయ్యె సే గొప్ప మొర్నొదీకిరి అముకు తప్పించిసి, ఇంకా అగురుకంకా తప్పించుసి, ఇంకా అం కోసం ప్రార్దన కొరిలవలరె తొమె కూడ సహాయం కొరితందుకు సెయ్యె ఇంకా అగురుకు తొముకు తప్పించుసుబులి తా సంగరె నిరీక్సన గలిగికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","సడవలరె బడేమంది ప్రార్దనతీకిరి, అముకు కలిగిలా క్రుపావరము కోసం బడేమంది సంగరె అం విసయమైల క్రుతజ్ఞతలు చెల్లింపబొడిసె. ");
INSERT INTO rei_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","అం అతిసయం కిడబుల్నె, లౌకిక జ్ఞానము అనుసరించికిరి, పురువు గ్రహించిలా పరిసుద్దతతీకిరి నిస్కాపట్యముతీకిరి పురువురొ క్రుపకాక అనుసరించికిరి లోకంరె సలిలపనికిరి, విసేసముగా తో పనికిరి సలుంచొబులికిరి, అం మనస్సాక్సి సాక్స్యదీతందుకాక. ");
INSERT INTO rei_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","తొమె చదివిగీకిరి పూర్తిగా గ్రహించిలా సంగితీనె తప్ప, మరికిచ్చిను తొముకు రాసిలనీ చివర జాంక యెడ ఒప్పుగుసెబులి నిరీక్సించిలించో. ");
INSERT INTO rei_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ఈనె అమె ప్రబువైల యేసురొ దినొసంగరె తొమె అముకు కారొ, సాకిరాక అమె తొముకు అతిసయ కారనమైకిరి తాంచొ బులి, తొమె కుండె మట్టుకు అముకు ఒప్పిగీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ఈనె యే నమ్మిలాటపనికిరి తొముకు దీటొ ఆసీర్వాదము మిల్లాపనికిరి అగరె తొంపక్కుఅయికిరి. ");
INSERT INTO rei_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","తొం పక్కురెదీకిరి మాసిదోనియకు జేకిరి మాసిదోనియదీకిరి ఇంకా తొం పక్కుఅయికిరి, తొం సంగరె యూదయకు పొడిదిమ్మంచి బులి మీ బులిగించి. ");
INSERT INTO rei_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","సడకు మియ్యి యాకిరి ఉద్దేసించికిరి నాయికుంటా సలించినా? వై, వై బులికిరి, నీ నీ బులి ప్రవర్తింతించిమంచిబులి మో ఆలోచనానె దే అనుసారంగా యోచించిలించినా? ");
INSERT INTO rei_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","పురువు నమ్మిదగిలాట గనుక అమె తొముకు కొయిలా వాక్యము వైబులి కొయికిరి నీబుల్లాపనికిరి రొన్నాసి. ");
INSERT INTO rei_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","అం దీకిరి, బుల్నే మో దీకిరి సిల్వాను దీకిరి తిమోతి సంగరె, తొంబిత్తరె ప్రకటించిలాట పురువు పో యీలా యేసు క్రీస్తు వై బులి కొయికిరి నీబుల్లలింకె రొన్నింతె గాని సెయ్యె వై బుల్లలింకె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","పురువురొ వాగ్దానమూనె కెత్తెయినెను సొబ్బీ క్రీస్తుతీకిరి వైబుల్లాపనాక అచ్చి. గనుక అం ద్వారా పురువుకు మహిమ కలిగితందుకు సడా తా వలరె నిస్చయములైకిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","తొం దీకిరంకా క్రీస్తురె టారీకిరి అచ్చి బులి అముకు స్తిరపరచికిరి అబిసేకించిలాట పురువాక. ");
INSERT INTO rei_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","సెయ్యె అముకు ముద్రపొక్కిరి, అం హ్రుదయమురె అముకు ఆత్మ బుల్లా సంచకరువుకు అనుగ్రహించికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","తొమంపరె కనికరము కలిగితందుకు మియ్యి ఇంకా కొరింతియకు అయిలాని. మొ పొర్నొసంగరె పురువొ సాక్సిగా లోగిలించి. ");
INSERT INTO rei_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","తొం విస్వాసము ఉంపరె అమె ప్రబువులుబులి యాకిరి కొయిలాని. గాని తొం ఆనందముకు సహకారుగా అచ్చొ. విస్వాసము వల్లరాక తొమె టారీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ఈనె మియ్యె దుక్కొ దిన్నాసి బులి, మియి దుక్కొసంగరె తొం పక్కరకు బుల్లికిరి అయినాసిబులి మోమట్టుకు మియి నిచ్చయించిగించి. ");
INSERT INTO rei_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","మియి తొముకు దుక్కము కలిగించినె దుక్కొపొందిలాట తప్ప ఇంక కేసే మెత్తె సంతోసపరిచినారె? ");
INSERT INTO rei_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","మియి అయిలబెల్లె మెత్తె కావల్లరె మియి సంతోసం కలిగిమంచెవొ, తంకె వల్లరె మెత్తె దుక్కొ కలిగినాసిబులి ఏ సంగతీనె తొముకు రాసించి. ఈనె మో సంతోసం తొం అల్ల సంతోసం బులికిరి తొం సొబ్బిలింకంపరె నమ్మకం కలిగికిరి యాకిరి రాసించి. ");
INSERT INTO rei_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","తొముకు దుక్కొ కలిగిమంచెబులి నీగాని, తొంబిత్తరె కలిగిలా బడేబూతు ప్రేమకు తొమె, తెలిసిగిమంచెబులి, నిండు స్రమసంగరె మనోవేదన సంగరె బడే కందికుంటా రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","కేసైనన్నా దుక్కొ కలిగించికిరి రొన్నె, మెత్తె మాత్రము నీ కుండెమట్టుకు తొముకల్లకు దుక్కొ కలిగించికిరి అచ్చి. మియి విసేసబారము తాంపరె నామోపికిరి ఏ కొత కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","సాటకు తొంబిత్తరె బడేలింకు వల్లరె కలిగిలా ఏ సిక్సాక చాలు. ");
INSERT INTO rei_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ఈనె తొమె ఇంక తాకు సిక్స నాపొక్కిరి క్సమించికిరి ఆదరించువురొ బొల్ట. గుటెబెల్లె సెయ్యే అత్యదికమైలా దుక్కొరె క్రుంగిజివ్వొ. ");
INSERT INTO rei_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ఈనె తావుంపరె తొం ప్రేమకు దిగదిమ్మాసిబులి తొముకు బతిమాలిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","తొమె సొబ్బి విసయోనెరె విదేయులైకిరి అచ్చెకీవొ బులి తొం యోగ్యత తెలిసిగిత్తె అగరె రాసించి. ");
INSERT INTO rei_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","తొమె కిర గురించి ఈనెను కాకు క్సమించిలిసొవొ మియి కూడా తాకు క్రీస్తు అగరె క్సమించించి; ");
INSERT INTO rei_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","మియి కిరైనెను క్సమించికిరి తన్నె సాతాను అంవల్లరె మోసం నాకొరిలపనికిరి, తొం కోసం, సాతాను మాయకొతానె అముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","క్రీస్తు సువార్త ప్రకటించితె మియి త్రోయ పట్నముకు అయిలబెల్లె, ప్రబువు మెత్తె పైటి కొరితె బొల్ట అవకాసం దీసి. ");
INSERT INTO rei_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ఈనె మో బయిలా తీతు మెత్తె నాదిగదిలందరె మో మనస్సురె నెమ్మది నీకిరి తంకె పక్కరె సెలవు కడిగీకిరి సెట్టెతీకిరి మాసిదోనియకు బయలుదేరించి. ");
INSERT INTO rei_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","అం వల్లరె ప్రతి చోటురె క్రీస్తురొ జ్ఞానము సువాసనకు దిగిపించుకుంటా తావుంపరె అముకు కెబ్బుకు విజయోత్సవము సంగరె ఊరేగించుకుంటా తల్లా పురువుకు స్తోత్రము. ");
INSERT INTO rei_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","రక్సింపబొడితల్లాలింకు నసించిజీతల్లాలింకు అమె పురువుకు క్రీస్తు సువాసన యికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","నసించిలాలింకు మొర్నొర్దమైలా వాసనగా, రక్సింపబొడిలాలింకు జీవార్దమైలా జీవపు సువాసనగా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ఈనె యే సంగతీనె చాటిలాట కేసే? అమె పురువురొ వాక్యముకు మిసికిరి చెరిపిలా బడేలింకెపనికిరి నీకిరి, నిస్కాపట్యముమైలలింకె పనికిరి పురువు వల్లరె నియమించిలాలింకె బులికిరి, క్రీస్తురొ సేవకునె పనికిరి పురువు అగరె బోదించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","అముకు అమాక బుల్లికిరి మెప్పించిగివురొ మొదలు కొరిగిల్లించొనా? కుండిలింకు కావలిసిల పనికిరి తొం పక్కరకు ఈనెను తొం పక్కరెతీకిరి ఈనెను, ఉత్తరము పొడిదివ్వురొ అముకు అవసరమునా? ");
INSERT INTO rei_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","అమె హ్రుదయల ఉంపరె రాసికిరి అచ్చి, మనమనె సొబ్బిలింకె తెలిసిగికిరి చదివిగిల్లించొ అమె ఉత్తరము తొంనీనా? ");
INSERT INTO rei_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","పొత్రొపలక వుంపరెగాని సిరా సంగరె గాని నారాసికిరి మనమారొ హ్రుదయాం బుల్లా పలక ఉంపరె జీవంగలిగిలా పురువురొ ఆత్మ సంగరె, అం పరిచర్య మూలంగా రాసిలా క్రీస్తు ఉత్తరము యికిరి అచ్చొబులి తొమె తెలియపరిచిలీసె. ");
INSERT INTO rei_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","కైంకిబుల్నె క్రీస్తుద్వారా పురువుంపరె అముకు విస్వాసమచ్చి అమె కొయిలీంచొ. ");
INSERT INTO rei_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","అం వల్లరె కెడైనను ఈలాపనికిరి ఆలోసించితందుకు అం మట్టుకు అమ్మాక సక్తి గలిగిలాలింకె నింతొ అముకు యే సక్తి పురువుతీకిరి కలిగికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","సెయ్యాక అముకు నో నిబందనకు, బుల్నే రాసికిరిరొల్లా దర్మసాస్త్రం నీగని ఆత్మకాక సేవకులైతే అముకు సక్తి దీసి. రాసికిరిరొల్లా దర్మసాస్త్రం మొరుదూసి గని ఆత్మ జీలాపనికిరి కొరుసి. ");
INSERT INTO rei_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","మొర్నొకు కారనమైలా పరిచర్య, పొత్రోనంపరె చెక్కిలా అక్సరాలుకు సంబందించిలాట ఈనెను, మహిమ సంగరె మిసిలాటైసి. సడుకాక మోసే మో ఉంపరె ప్రకాసించితల్లా సే మహిమ తగ్గిజిల్లాట ఈనన్నా, ఇస్రాయేలు తా మోకు దిగినారిసె. ");
INSERT INTO rei_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","యాకిరి తన్నుగా ఆత్మసంబందమైలా పరిచర్య కెత్తె మహిమగా రొసో? ");
INSERT INTO rei_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","సిక్సావిదికి కారనమైలా పరిచర్యా మహిమ కలిగిలాటయినె నీతికు కారనమైనె పరిచర్య కెత్తో అదికమైల మహిమ కలిగిలాటగా రోసి. ");
INSERT INTO rei_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","అత్యదికమైలా మహిమ యెడకురొవ్వురొ వల్లరె యెడకు అగరె మహిమతల్లాటగా కొరువురొ ఈసి. యే విసయంరె మహిమ నీలాపన అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","నసించిజీతల్లాటాక మహిమగల్లాటైనె, టారిలాట ఇంకా బడే మహిమ కలిగిలాటైకిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","మెత్తె యే ఆస అచ్చి సాకరాక, బడే దైర్యముగా కొతలగిలించొ. ");
INSERT INTO rei_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","తగ్గిజీతల్లాట మహిమరొ అంతముకు ఇస్రాయేలు తేరికిరి నాదిగిలాపనికిరి మోసే తా మో ఉంపరె ముసుగు పొగ్గిచ్చి సాకిరక అమె నింతొ. ");
INSERT INTO rei_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ఈనె తంకె మనస్సునె కటినమైజీసె గనక ఆజిజాంక పుర్ననిబందన చదివితల్లాబెల్లె, సడ క్రీస్తురె సేరిపిసెబులి తంకు తెలియపర్చిబొడిలాని, సే ముసుగాక టారీకిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ఆజిజాంక మోసే గ్రందము తంకె చదివిలాబెల్లల్లా ముసుగు తంకె మనుసూనంపరె అచ్చి గని ");
INSERT INTO rei_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","“తంకె మనుసూనె ప్రబువాడుకు కెబ్బుకు బుల్లివేయో సెత్తెలె ముసుగు కడిపూసి.” ");
INSERT INTO rei_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ప్రబువాక ఆత్మ. ప్రబువురొ ఆత్మ కేటె తాసో సెట్టె స్వాతంత్ర్యం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","అమల్లా ముసుగు నీలా మోసంగరె ప్రబువురొ మహిమకు అద్దం పనికిరి ప్రతిపలింపకొరికుంటా, మహిమ తీకిరి బడే మహిమకు పొందికుంటా, ప్రబువురొ ఆత్మసంగరె సే పోలికగాక మార్చబొడిలించొ. ");
INSERT INTO rei_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ఈనె యే పరిచర్య పొందిలందరె కనికరం పొందిలాలింకైకిరి అదైర్యం పొడినింతొ. ");
INSERT INTO rei_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ఈనె కుయుక్తిగా నా సలికుంటా, పురువొ వాక్యమును వచనగా బోదకొయితనా, సత్యమును ప్రత్యక్సపరచిలందరె ప్రతి మనమకు మనస్సాక్సి అగరె అమె పురువు సముకంసంగరె మెప్పించిగీకుంటా, అవమానకరమైలా రహస్య కార్యమునెకు నిరాకించమాసి. ");
INSERT INTO rei_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","అమె సువార్త మరుగుకొరిలపనికిరి ఈనె నసించిలాలింకు విసయమురె మరుగుకొరిలాపనచ్చి. ");
INSERT INTO rei_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","పురువురొ మూ గలిగిలాటపనా రొల్ల క్రీస్తు మహిమరొ దిగిదిల్లా సువార్త ప్రకాసము తంకు ప్రకాసించికుంట నిమిత్తము యే యుగ సంబంద యీలా లోకొ పురువొ అవిస్వాసులలింకె అమె మనస్సురె అంకికి నాదిగిదెల్లాపని కొరుసి. ");
INSERT INTO rei_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ఈనె అమె అముకు గురించి, యేసు నిమిత్తము అమె తో పరిచారకులు బులి ప్రకటించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","వొందార్రెతీకిరి హల్లో ప్రకాసించిమాసి బులి పలికిలా పురువాక తా మహిమ గురించైలా జ్ఞానము యేసు క్రీస్తుదీకిరి బయలుపరిచితె అమె హ్రుదయలురె ప్రకాసించిసి. ");
INSERT INTO rei_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ఈనెను యే బలాదిక్యము అం వల్లరె నాకలిగిలాపనికిరి పురువురొ రొల్లపనా మట్టి అండీన్రె యే సంపద అముకు నీ. ");
INSERT INTO rei_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","క్యాకిరి జెన్నెనూ కొస్టొపొడిలించొ ఇరికించిలలింకె నింతె; అపాయమురె అచ్చొ కేవలం ఉపాయము నీలలింకె నింతె; ");
INSERT INTO rei_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","చిత్రహింసానె అనుబవించించొ గని దిక్కునిలాలింకైకిరి నింతొ. అముకు మరికిరి పొందిసె ఈనె నాసనం ఈలానింతొ. ");
INSERT INTO rei_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","యేసు జీవం అం దేరె దిగదిల్లాపనికిరి యేసురొ మోర్నొ అనుబవంకు అం దేనె కెబ్బుకు బొయిగీజెల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","క్యాకిరిబుల్నే, యేసురో జీవం కూడ అం మనమరొ దేరె దిగదిల్లాపనికిరి, జీకిరి తల్లా అమె కెబ్బుకు యేసు కోసం మొర్నొకు అప్పగింపబొడిలించొ. ");
INSERT INTO rei_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ఈనె అంబిత్తరె మొర్నొకు తొం బిత్తరె జీవముకు పైటి కొరిలీసి. ");
INSERT INTO rei_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ఈనె “మీ నమ్మించి గనకాక కొతాలగిలించి.” క్రుప బడే మనమానె దీకిరి ప్రజానె పురువురొ మహిమ నిమిత్తము క్రుతజ్ఞతాస్తుతులు విస్తరించిలాపనికిరి, సోబ్బి తొం కోసమాక. ");
INSERT INTO rei_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ప్రబువైలా యేసుకు ఉటదిల్లా యేసు దీకిరి అముకు కూడ ఉటిదీకిరి, తొంసంగరె కూడ తా అగరె టారదూసి బులి తెలిసి, అమె విస్వసించిలించొ గనక కొతలగిలించొ. ");
INSERT INTO rei_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ఈనె విస్వసించిలందరె కొతలగించి బులి రాసిలాపనికిరి సే విస్వాసముకు దీకిరి కూడిల ఆత్మగల్లాలింకయికిరి, ");
INSERT INTO rei_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ఈనె అమె అదైర్యపొడినింతొ; అం పొదరొ వొండ్రపో క్రుసించిజెన్నన్నా, బిత్తరె వొండ్రొపో దినెదినె సక్తికు పొందిలించి. ");
INSERT INTO rei_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ఈనె క్సనమాత్రమాక రొల్లా కుండె స్రమ, సడకు కెత్తోరెట్లునె అదికమైల అద్బుతమైల మహిమకు అముకు సిద్దం కొరుకుంటా తల్లీసి. సడ కెబ్బుకు రొల్లా గొప్ప మహిమ సంగరె అనుబవించితల్లా కొస్టోనె కిచ్చీనీ. ");
INSERT INTO rei_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","అమె దిగదిల్లాంచకు నాదిక్కుంటా అద్రుస్యమైలాంచ కోసం ఎదురు దిగిలించొ క్యాకిరి బుల్నే దిగదిల్లాంచ కుండె కలోక తాసి. ఈనె నాదిగదిల్లాంచ సాస్వతంగా తాసె. ");
INSERT INTO rei_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","బూమి ఉంపరె అం గొరొ, అం దే యీలా యే గొరొ బంగిజిన్నన్నా, పరలోకంరె అత్తొపైటినీకిరి పురువుదీకిరి బందిలాట నిత్యమైకిరి తల్లా గొరొ పరలోకంరె అముకు అచ్చి బులికిరి తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","అమె దిగంబరులుగా నీకిరి కొన్నానె పిందిగిల్లాపనికిరి దిగదిలించొ. ఈనె పరలోకందీకిరి అయిలా గొరొ ఎడంపరె దరించిగిల్లా గొప్ప ఆస సంగరె ఎడబిత్తరె ఎదురుదిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","సే దే దరించిగిల్లా బెల్లే అమె కొన్నానె నీలలింకె పనికిరి తన్నింతొ. ");
INSERT INTO rei_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","అమె యే లోకంరె తల్లా బెల్లే బౌతికమైలా దేకు దరించిగిమ్మో గని పరలోకంరె తల్లాబెల్లె పరలోక సాస్వతమైలా దేకు దరించిగీకిరి సాస్వతంగా జీలాట పనికిరి మార్పు చెందుంచొ. ");
INSERT INTO rei_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","సడ వల్లరె అముకు సిద్దపరిచిలాట పురువు; ఈనె సెయ్యె తా ఆత్మ బుల్నే సంచకరువుకు అముకు అనుగ్రహించిలీసి. ");
INSERT INTO rei_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ఈనె ఏ దే బిత్తరె రొల్లెత్తెకలొ ప్రబువుకు దూరుగా అయించొబులి తెలిసికిరి కెబ్బుకు దైర్యముగలలింకె పనికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ద్రుస్ట వల్లరె నీకిరి విస్వాసము వల్లరాక సలిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","యాకిరి దైర్యము గలిగీకిరి ఏ దేకు సడికిరి ప్రబువు పక్కరె రొయిత్తె ఇస్టపొడిలించొ. ");
INSERT INTO rei_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ఈనె సడకు దే బిత్తరె తన్నన్నా దేకు సడిదిన్నన్నా, తాకు ఇస్టులూగ తమ్మాసిబులికిరాక అం లక్స్యం. ");
INSERT INTO rei_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","అమల్లా క్రీస్తు న్యాయపీటం అగరె టారిమంచె. కిరుకుబుల్నే ప్రతిజొనె దేసంగరె జరిగించిలా సెడ్డపైటి ఈనన్నా, సడ బొల్ట పైటి ఈనన్నా, నాబొల్టయినెను, తగిలపనికిరి ప్రతిపలం పొందిమంచె. ");
INSERT INTO rei_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ఈనె అం ప్రబువు విసయమైలా డొరొ తెలిసికిరి మనమానుకు ప్రేరేపించిలించొ, అమె పురువుకు ప్రత్యక్సపరబొడిలాలింకైకిరి అచ్చొబులి నమ్మిలించొ. తొం మనుసూనంకా బొల్లె రొమ్మాసి బులి కోరిలించొ. ");
INSERT INTO rei_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","అముకు అమ్మాక తొం అగరె బుల్లికిరి మెప్పించుగిల్లానింతొ గాని, హ్రుదయంరె అతిసయంనాపొడికిరి ఉంపరె రూపంరె అతిసయపొడిలలింకు ప్రత్యుత్తరం దీతె తొముకు ఆదారము కలిగిమాసిబులి అం విసయంరె తొముకు అతిసయ కారనం కలిగించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","కెడబుల్నె అమె బోడలింకె అయించొనా పురువు నిమిత్తమాక; స్వస్దబుద్దిగలలింకె అయించొ తో నిమిత్తమాక. ");
INSERT INTO rei_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","క్రీస్తురొ ప్రేమ అముకు సలిపించిలీసి; క్యాకిరి బుల్నే సొబ్బిలింకె కోసం జొనె మొరిజీసి. సడకు సొబ్బిలింకె మొర్నొరె పాలుపొందిలీసె. ");
INSERT INTO rei_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","జీవించిలలింకె ఇంక అగరె తంకోసం నీకిరి, తంకోసం మొరిజికిరి బుల్లికిరి ఉటిలాట కోసం జీతె సెయ్యె సొబ్బిలింకె కోసం మొరిజేసి బులి నిచ్చయించిగించొ. ");
INSERT INTO rei_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ఈనె ఇంక అగురుకు అం దే వల్లరె కాకు ఈనెను తెలిసినీ. అమె క్రీస్తుకు దేరొ రీతిగా తెలిసిగీకిరితన్నె యెడకు అగరె తాకు సాకిరి తెలిసినీ. ");
INSERT INTO rei_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ఈనె కేసెయినెను క్రీస్తురె రొన్నె సెయ్యె నోస్రుస్టి; పుర్నాట గతించిసి, ఇదిగొ నోట ఈసి. ");
INSERT INTO rei_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","సొబ్బిను పురువు వల్లరాక ఈసి; సెయ్యె అముకు క్రీస్తు వల్లరె తా సంగరె స్రతువుగా రొల్లబెల్లె జట్టుకారీనెగా మార్చిగీకిరి, పరిచర్య అముకు అనుగ్రహించిసి. ");
INSERT INTO rei_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","సడకిరబుల్నే, పురువు తంక అపరాదములుకు తంకె ఉంపరె నామోపుకుంటా, క్రీస్తురె లోకముకు తాసంగరె స్రతువుగా రొల్లబెల్లె జట్టుకారీనెగా మర్చిచిసి వాక్యముకు అముకు అప్పగించిసి. ");
INSERT INTO rei_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ఈనె పురువు అం దీకిరి వేడిగిల్లాపనికిరి అమె క్రీస్తుకు రాయబారులుగా పురువు సంగరె స్రతువుగా రొల్లబెల్లె జట్టుకారీనెగా మారివాసి బులికిరి క్రీస్తు పక్సముగా తొముకు బతిమాలిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","కిరుకుబుల్నే అమె తాబిత్తరె పురువు నీతి ఈలాపనికిరి పాపం నాజనిలా తాకు అం కోసం పాపముగా కొరిసి. ");
INSERT INTO rei_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ఈనె అమె తాసంగరె పైటిలింకెయీకిరి తొమె పొందిలా పురువు క్రుపకు వ్యర్దము కొరిగిత్తెనాబులి తొముకు వేడిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","“అనుకూల సమయంరె తో ప్రార్దన సునిమి; రక్సన దినొరె తొత్తె ఆదిగించిబులి” సెయ్యె కొయిలీసి నీనా! ఇదిగొ వుంచినాక అనుకూలమైలా సమయంరె, ఇదిగొ ఎడాక రక్సన దినొ. ");
INSERT INTO rei_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","అమె పరిచర్య నింద నాపొడుకుంటా నిమిత్తము కే విసయంరె ఈనెను అనుమానం కిచ్చి నాకలిగించికిరి, ");
INSERT INTO rei_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ప్రతి విసయంరె పురువొ తాసేవకునె బులి దిగిదీతె స్రమలబిత్తరె ఇబ్బందులురె ఇరుకులురె, ");
INSERT INTO rei_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","మడ్డొనెబిత్తరె చెరసాలబిత్తరె కొలీనెబిత్తరె ప్రయాసముబిత్తరె జాగరములబిత్తరె ఉపవాసములబిత్తరె ఓర్పుగలలింకెపనికిరి, ");
INSERT INTO rei_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","పవిత్రత సంగరె జ్ఞానము సంగరె దీర్గసాంతము సంగరె దయసంగరె పరిసుద్దాత్మవల్లరె నిస్కపటమైలా ప్రేమసంగరె, పురువు పరిచారకులుయికిరి రొయికిరి సొబ్బి స్దితులరె అముకు అమ్మాక మెప్పుపొందిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","సత్యవ్యాకం బోదించిలావల్లరె పురువు బలమువల్లరె నాపొడికుంటా నీతి ఆయుదమునెకు కలిగికిరి కాపాడిగిల్లించొ, ");
INSERT INTO rei_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","గనత గనహీనతా వల్లరె సుకీర్తి దుస్కర్తులవల్లరె, అమె మోసంకొరిల్లలింకె పనికిరి రొయికిరి సత్యవంతునె ");
INSERT INTO rei_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","నాతెలిసిలా పనికిరి రొయికిరి బొల్లకిరి తెలిసిల్లలింకె; మొరిజిల్లలింకె పనికిరి రొయికిరి ఇదిగొ జీకిరి రొల్లాలింకె; సిక్సిపొడిల్లలింకె పనికిరి రొయికిరి మొరిజిలా పనాలింకె; ");
INSERT INTO rei_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","దుక్కొపొడిలాలింకె పనికిరి రొయికిరి కెబ్బుకు సంతోసంచిలలింకె పనికిరి; దరిద్రులమైకిరి బడేలింకు పలియతల్లలింకె కలిగించిలాలింకె; కిచ్చి నాతల్లలింకె పనికిరి రొయికిరి సొబ్బి కలిగిలాలింకె, అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ఓ కొరిందియులులింకె, పూర్తి సత్య కొతలగిలించొ, అమె హ్రుదయము విసాలంగా అర్దమైలపనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","తొం బిత్తెరె అం అంతరంగం ఇరుకుగా నీ గాని, అం అంతరంగం ఇరుకుగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","తొం బిత్తరె అముకుతల్లా అంతరంగం ప్రతిపలముగ తొముకు తొమె హ్రుదయములుకు విసాలపరిచిగెండి తొమె మో పిల్లనెబులి తొంసంగరె యాకిరి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","తొమె అవిస్వాసినె సంగరె జట్టుగా రొయితనాండి. నీతికి దుర్నీతిసంగరె కిర జట్టు? హల్లొకు వొందారుకు కిర జట్టు? ");
INSERT INTO rei_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","క్రీస్తుకు సాతాను సంగరె కిర సంబందము? అవిస్వాసిదీకిరి విస్వాసికు జట్టు కిర? ");
INSERT INTO rei_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","పురువురొ మందిరంరె పొదరెలింకెవిగ్రహముల సంగరె కిర జట్టు? అమె జీవమైలా పురువురొ మందిరం యీకిరి అచ్చొ; సడకు పురువు యాకిరి సెలవు దిల్లీసి. “మియి తంకెబిత్తరె రొయికిరి సంచరించికిరి, మియి తంకె పురువు యీకిరి రొంచి తంకె మో ప్రజలైకిరి తాసె.” ");
INSERT INTO rei_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ఈనె “తొమె తంకె మొజిరె దీకిరి బయలుకు అయికిరి వేరుగా రోండి. అపవిత్రమైలాంచకు సూగిన్నాసి బులి ప్రబువు కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ఈనె మియి తొముకు చేర్చిగిల్లించి, తొముకు బో యికిరిఅచ్చి, తొమె మెత్తె పోనె జ్యోనెయికిరి అచ్చొ బులి సర్వసక్తియిలా ప్రబువు కొయిలీసి.” ");
INSERT INTO rei_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ప్రియమైల జట్టుకారీనెలింకె, అముకు ఏ వాగ్దానమూనె అచ్చి సెడకు పురువు డొరొసంగరె పరిసుద్దత్మకు సంపూర్తి కొరికిరి, దేకు ఆత్మకు కలిగిలా సొబ్బి కల్మసము దీకిరి అముకు పవిత్రుల పనికిరి కొరిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","అముకు తొమె హ్రుదయములురె చేర్చిగీండి; అమె కాకు అన్యాయము కొరిలానింతొ, కాకు చెరిపిలానింతొ, కాకు మోసం కొరిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","తొముకు సిక్సావిది కలుగుసిబులి మియి యాకిరి కొయిలనీ. మొరిజినెను గాని జీనె గానీ తొమె అమె కూడ రొమ్మంచెబులి తొమె అమె హ్రుదయలురె అచ్చొబులి మియి తెలుసుబులి కొయించినీనా. ");
INSERT INTO rei_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","తొమె ఉంపరె మియి బడే దైర్యముగా కొతలాగిలించి, తొం కోసం మియి బడే గర్వించిలించి. ఆదరనసంగరె పూరికిరి అచ్చి, అం స్రమరె సొబ్బిటికి మించిలా బడే బూతు సంతోసం సంగరె బడే ఆనందించిలించి. ");
INSERT INTO rei_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","అమె మాసిదోనియకు అయిలాబెల్లె అముకు కెమాత్రము విస్రాంతి మిల్లాని. కాడుకు జెన్నెను అముకు కొస్టొనె; బయిలురె కొలీనె బిత్తరె డొరొ రొయితవ్వి. ");
INSERT INTO rei_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ఈనెను క్రుంగికిరి రొల్లబెల్లే ఆదరించిలా పురువు తీతు అయిలవల్లరె అముకు ఆదరించిసి. ");
INSERT INTO rei_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","తీతు కొయిలా కొతనెవల్లరె, సెయ్యె తొమె అత్యబిలాసకు తొమె అంగలార్పుకు మో విసయమైకిరి తొముకు కలిగీకిరి అత్యాసక్తికు అముకు కొయికుంట, సెయ్యె తొమె విసయంరె పొందిల ఆదరనవల్లరె కూడ అముకు ఆదరించిసి ఈనె మియి యింకా బూతు సంతోసించించి. ");
INSERT INTO rei_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","మియి రాసిలా పత్రిక వల్లరె తొముకు దుక్కొలొగిలవల్లరె మియ్యి బాదపొడిల నీ; మెత్తె దుక్కొ కలిగినెను సె పత్రిక తొముకు కుండె కలొమట్టుకు దుక్కొ లొగొసిబులి తెలిసిగికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","తొమె దుక్కొ పొడిలీసొ బులి సంతోసించిలాని గాని తొమె దుక్కొపొడికిరి మారుమాస్సు పొందిసొ బులి వుంచినె సంతోసంచించిలించి. కైంకిబుల్నె కే విసయలురె యినెను అంవల్లరె తొముకు నస్టం నాయీలాపనికిరి, పురువురొ చిత్తంరె దుక్కొపొడిసొ. ");
INSERT INTO rei_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","పురువురొ చిత్తానుసారమైలా దుక్కొ రక్సనర్దమైలా మనస్సుకు కలిగించిసి; ఏ మారుమనస్సు దుక్కొముకు జొర్నైదీన్ని. ఈనె లొకొసంబందమైల దుక్కొ మొర్నొకు కలిగించుసి. ");
INSERT INTO rei_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","తొమె పురువు చిత్తం ప్రకారం పొందిలా ఏ దుక్కొ కెటువంటి జాగర్తకు కెత్తె దోసనివారనకు ప్రతివాదమునెకు కేటా ఆగ్రహముకు కెత్తె డొరొకు కేటె అబిలాసకు కెత్తె ఆసక్తికు కెత్తె ప్రతిదండముకు తొంబిత్తరె జొర్నైపించిలీసొ దిగొండి. సె కార్యము గురించి సొబ్బి విసయానెరె తొమె నిర్దోసులైకిరి అచ్చొ బులి రుజువు కొరిగీసొ. ");
INSERT INTO rei_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","మియి తొముకు రాసిలా సె దుస్కార్యము కొరిలాట నిమిత్తము రాసిలా నీ; తావల్లరె అన్యాయము పొందిలా తా నిమిత్తమికిరి రాసిలా నీ; మోవల్లరె తొముకు ఆసక్తి పురువు అగరె తొమె మొజిరె తెలిసిగితె రాసించి. ");
INSERT INTO rei_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ఎడకు అమె ఆదరింపబొడించొ. సెత్త నీ, అముకు ఏ ఆదరన కలిగిలాబెల్లె తీతురొ ఆత్మ తొమె సొబ్బులింకె వల్లరె విస్రాంతి పొందిలా వల్లరె తాకు సంతోసముకు దిక్కిరి యింకా బూతు అమె సంతోసించించొ. ");
INSERT INTO rei_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","క్యాకిరిబుల్నె మియి తా అగరె తొమె విసయమైకిరి గొప్ప కొతానె కొయినెను మియి లజ్జొపొడిలానీ అమె యాకిరి సొబ్బిటికు తొమె సంగరె సొత్తె కొయించివొ సాకరాక అమె తీతు అగరె ఏ విసయమైకిరి కొయిలా గొప్ప కొతానె సొత్తాకబులి దిగిదీసి. ");
INSERT INTO rei_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ఈనె తొమె దొరొసంగరె వనుకుసంగరె తాకు చేర్చిగిల్లిసొ బులి సెయ్యె తొమె సొబ్బిలింకె విదేయతకు జ్ఞాపకము కొరితల్లబెల్లె, బొల్టా సంబందం యింకా బూతు తొమె పక్కరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","సొబ్బి విసయోనెరె తొమె ఉంపరె మెత్తె దైరం అచ్చి గనక సంతోసించిలించి. ");
INSERT INTO rei_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","మో జట్టుకారీనెలింకె మాసిదోనియ సంగముకు పురువురొ క్రుప దీసి బులి తంకు తెలియాకొరిలించొ మిత్తె కావాలి. ");
INSERT INTO rei_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","కారిబుల్నె, తంకె బడే కొస్టొవల్లరె పరీక్సంపబొడికిరి అత్యదికముగా సంతోసించిసె. ఈనె తంకె నిరుపేదలులినెను తంకె దాత్రుత్వము బడే విస్తరించిసి. ");
INSERT INTO rei_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","తంకె తా సామర్ద్యము వలరె నీకిరి సామర్ద్యము కన్నా బూతుగాను తా మట్టుకు సెయ్యె దీసె బులి తొముకు సాక్సం దిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","పురువురొ మనమానెకు సహాయం కొరిలాబిత్తరె తొమె కూడా పాలుయిలాలింకె పని తమ్మంచె బులి బ్రతిమాలిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","సెత్తెనికిరి అగరె ప్రబువుకు, పురువురొ చిత్తంవల్లరె అముకు తంకును తంకె అప్పగించిగిసె; యాకిరి కొరుసెబులి మియ్యి బులిగిల్లాని. ");
INSERT INTO rei_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","సెడకు తీతు ఏ క్రుపకు యాకిరి పూర్వము మొదలుకొరుసో సాకరాక సెడ తొమె ప్రేమపూర్వకము సేవా కొరుబులి అమె తాకు వేడిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","తొమె ప్రతివిసయమురె బుల్నే విస్వాసముబిత్తెరె ఉపదేసంరె జ్ఞానంరె సొబ్బి జాగర్త సంగరె తొముకు మోపక్కురొల్ల ప్రేమరె క్యేకిరి అబివ్రుద్ది యిలీసొ సాకరాక తొమె ఏ సేవా విసయంరె కూడ అబివ్రుద్ది యిలాపని దిగెండి. ");
INSERT INTO rei_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ఆజ్ఞపూర్వకముగా తొం సంగరె కొయిలానీ; పొదరిలింకురొ జాగ్రర్తకు తొముకు దిగిదీలా వల్లరె తొం ప్రేమ కెత్తొ యదార్దమైలాటవొ మి తెలిసిగిమండి బులిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","తొమె అమె ప్రబువైలా యేసు క్రీస్తు క్రుపకు తెలుసుకి అచ్చినీనా? సెయ్యె పలియగలిగిలాట రొయికిరి తొమె తా దరిద్రం వల్లరె పలియరొల్లలింకె యీమంచెబులి తొం నిమిత్తము దరిద్రుడు యీసి. ");
INSERT INTO rei_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ఎడ గురించి మో ఉద్దేసం కొయిలించి; బొచ్చురొ అగరాక తొమె కే ఉపకారం కొరువురొ మొదలదీసొ సెడకు ఇంకా కొరువురాక బొల్ట. ");
INSERT INTO rei_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","సెడకు ప్రారంబించితె మనస్సు తొంబిత్తరె క్యాకిరి కలిగిసొ సాకరాక కలిగిలాకొలిది సంపూర్తియిల పనికిరి తొమె సె పైటినె ప్రసిద్దంగా తొమె ఉంచినె నెరవేరుచొండి. ");
INSERT INTO rei_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","అగరె జొన్నె సిద్దమైలా మనస్సు కలిగీకిరి రొన్నె సక్తికి మించి నీ గాని కలిగిలాకొలిదీ దిల్లట ప్రీతికరమవుసి. ");
INSERT INTO rei_vpl VALUES ("C28_13","077_8_13","2CO","8","13","14","పొదరలింకు తేలికగాను తొమె బారముగాను రొమంచె బులి ఎడ కొయిలానీ గాని. ఉంచినె తొమె సమ్రుద్ది తంకె అవసరముకు యింకాకెబ్బుకు తంకె సమ్రుద్ది తొమె అవసరముకు సహయైకిరి రొమ్మంచెబులి యాకిరి కొయిలించి యాకిరాక దీటకు సమానంగా దిగువురొ వూసి. ");
INSERT INTO rei_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","“బూతు రొల్లటకు బూతు కిచ్చి మిగిల్లా నీ. తక్కువ రొల్లటకు తక్కువ కొదువ నీ” బులి లేకలురె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","తొమె విసయంరె మెత్తె కలిగిలా ఏ ఆసక్తికు తీతు హ్రుదయంరె జొర్నైపించిలా పురువుకు స్తొత్రము. ");
INSERT INTO rei_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","సెయ్యె మో విన్నపాముకు అంగీకరించిసి గాని తాకు విసేసాసక్తి కలిగిలా వల్లరె తా ఇస్టంచొప్పురె తొంపక్కరెకు బయిలుదేరికిరి అయిలీసి. ");
INSERT INTO rei_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ఈనె సువార్త విసయంరె సంగముల సోబ్బిటికు ప్రసిద్దియిలా తోటి పైటితాకు తాసంగరె కూడ పొడదిలించి. ");
INSERT INTO rei_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","సడనీకిరి అం ప్రబువుకు మహిమ కలిగిలా నిమిత్తము అమె సిద్దమైలా మనస్సు దిగిదీతె కోసం ఏ సహాయం కొరిలా విసయంరె పరిచారకులమైకిరి అంసంగరె కూడ సెయ్యె ప్రయానం కొరుమురొ బులి సంగమురె రొల్లాలింకె బచ్చిగీకిరి తాకు లొగ్గిచె. ");
INSERT INTO rei_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ఈనె అమల్లా విస్తారమైలా దర్మము విసయంరె పరిచారకులమైకిరి అచ్చొ సెడకు కోసం అముంపరె కేసె తప్పు నాపొక్కిరి అమె జాగర్తగా దిగ్గీకుంటా తాకు పొడిదిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","కెడబుల్నె ప్రబువు అంకి అగరె మాత్రమకా నీ మనమనె అంకి అగరె కూడ కెడ బొల్టవొ సెడకు కోసం బొల్లకిరి ఆలోచించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ఈనె తంకె సంగరె కూడ అమె అం బయికు పొడిదిల్లించొ. బడే సంగుతులురె బడే సారులు తాకు పరీక్సించికిరి తాకు సాయం కొరితె అసక్తిగలిగిలాట బులికిరి, ఉంచినెను తొమె ఉంపరె కలిగిలా విసేసామైలా నమ్మకంవల్లరె బూతు ఆసక్తికలిగిలీసి బులికిరి తెలిసిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","తీతు విసయంరె కేసె బులి కేసన్నా పొచ్చిరిలాబెల్లె సెయ్యె మో సంగరె తల్లాటబులి తొమె విసయమురె మో జత పైటితా యీకిరి అచ్చిబులి; అమె బయినె యీలలింకె పొచ్చిరినె తంకె సంగమురె చలితె క్రీస్తు మహిమమైకిరి అచ్చెబులి మియి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","సెడకు తంకు తొమె ప్రేమ దిగదేండి. పొదరె సంగమునె తొమె కోసం కైంకు గొప్పగా కొయినింతెవొ తంకు రుజువు కొరొండి. ");
INSERT INTO rei_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","యూదయరె క్రైస్తువులు విస్వాసునెకు సహయం కొరుబులికిరి తొముకు రాసివురొ అవసరం నీ ");
INSERT INTO rei_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","తొమె మనస్సు సిద్దమైకిరి అచ్చిబులి మెత్తె తెలుసు. సెడకు బొచ్చొరొ దీకిరి అకయ సిద్దపొడికిరి అచ్చి బులి కొయికిరి, మియి తొమె కోసం మాసిదోనియలింకె అగరె అతిసయపొడిలించి; తొమె ఆసక్తికు దిక్కిరి బడేలింకె ప్రేరేపింపబొడిసె. ");
INSERT INTO rei_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ఈనె తొం కోసం అమె అతిసయం యే విసయములురె వ్యర్దము నాయీకిరి, మియి కొయిల పనికిరి తొమె సిద్దముగా రొయితె ఏ విస్వాసునెకు పొడదించి. ");
INSERT INTO rei_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","తొమె నాసిద్దపొడినె గుటెకలొ మాసిదోనియలింకె యీనెను మోసంగరె కూడ అయికిరి తొమె సిద్దముగా నాతవ్వొరొ దిగిలాబెల్లె, ఏ నమ్మకము కలిగికిరి రొయికిరి అమె లజ్జొపొడిలించొ; తొమె కూడ లజ్జొపొడిసోబులి యింకా కొయివురొ కిర? ");
INSERT INTO rei_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","సెడకు కొతదిల్లా ప్రకారం దూంచొబులి తొమె కొయిలా దర్మము పిసనారితనముగా నాదీకిరి దారాలముగ దిమ్మంచెబులి కొయికిరి, విస్వాసులింకె తొమె పక్కరకు అగరాక అయికిరి సెడకు సిద్దం కొరితె తంకు కొయివురొ అవసరం బులిగించి. ");
INSERT INTO rei_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","కుండెమట్టుకు సాయం కొరిలాట కుండె లబ్బొకు బొల్ట పొందుగుసి, బొల్ట సహాయం కొరిలాట ప్రతిజోనె సెయ్యె దిమబులిగిలాట హ్రుదయం సంగరె దిమ్మంచె; ");
INSERT INTO rei_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","పురువు సంతోసం సంగరె దిలాలింకు ప్రేమించిసి. ");
INSERT INTO rei_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ఈనె సొబ్బిటిరె కెబ్బుకు తొంబిత్తరె తొమె సర్వసమ్రుద్దిగలలింకె బొల్ట యీల ప్రతిపైటి కొరితె పురువు తొం ఉంపరె సొబ్బి రకాలు క్రుపకు విస్తరించిపారి. ");
INSERT INTO rei_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ఏ విసయంరె “సెయ్యె వెదజల్లీకిరి దరిద్రునెకు దీసి తా నీతి కెబ్బుకూ టారుసి” బులి రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","విత్తులాటకు విత్తోనె కైయితె కద్ది దిల్లా పురువు తొముకు యిత్తనాము దయకొరికిరి విస్తరించికిరి, తొమె ప్రతి విసయాంరె బొల్ట బగ్యముగలలింకెయితె, తొమె నీతిపలము వ్రుద్దికొరసి. ");
INSERT INTO rei_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","యాకిరి, దారాలముగ దిల్లా మనస్సు వల్లరె అం దీకిరి పురువుకు క్రుతజ్ఞతాస్తుతులు చెల్లించిసె. ");
INSERT INTO rei_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","కెడబుల్నే ఏ సేవకు గురించి పరిచర్య పురువురొ మనమానె అవసరములు సహాయం కొరిలాట మాత్రమా నీకుండ, బడేలింకె పురువుకు చెల్లించిలా క్రుతజ్ఞతాస్తుతులు వల్లరె విస్తరించిలిసి. ");
INSERT INTO rei_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","కెడబుల్నె క్రీస్తుసువార్త అంగీకరించించొ బులి ఒప్పిగిలాట తొమె విదేయులులైలందరె, తంకె విసయముకు సొబ్బిలింకె విసయముకు ఎత్తె సహాయం కొరిలా వల్లరె, ఏ పరిచర్య వల్లరె తొమె యోగ్యత దిగదీలావల్లరె తంకె పురువుకు మహిమ పరిచిసె. ");
INSERT INTO rei_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ఈనె తొంవుంపరె పురువు దిగదిలా అత్యదికమైలా క్రుపకు దిక్కిరి, తంకె తొమె నిమిత్తము ప్రార్దన కొరుకుంట, తొముకు దిగిమంచెబులి బడే ఆస కలిక్కిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","వివరించి నారిలా తా బహుమానం కోసం పురువుకు దండము. ");
INSERT INTO rei_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","పౌలుబుల్లా మియి తోం అగరె రొల్లాబెల్లె తొంబిత్తరె తగ్గించిగికిరి రొల్లా పనికిరి అగరె నీలాబెల్లె తొ సంగరె దైర్యమునారొల్లపనా మియ్యి యేసు క్రీస్తురె రొల్లా సాత్వికముకు దీనమనస్సు వల్లరె తొముకు వేడిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","దే ప్రకారము సలిలలింకె బులి అముకు గురించి కుండెలింకె కొయిగిల్లీసె నీనా? సాలింకె అగరె మియి తెగించికిరి కాటిన్యము దిగిదీమంచె బులి తలించిగిల్లించి గాని మియ్యి అయిలాబెల్లె సాట కాటిన్యముకు దిగిదినాసి బులి కొరుబులి మియ్యి తొముకు బతిమాలిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","సెడ సొత్తకా లొకొరె జీవించినెను ఈనె లొకొసారముగా కొలీనెలగ్గినింతొ. ");
INSERT INTO rei_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","పురువురొ యుద్దోపకరనములు లొకొ సంబందమైలటా నీగని. సత్రుబలం పొక్కిదిలాపని బలమురొల్లాపని అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","అమె వితర్కములకు, పురువు గురించి జ్ఞానముకు అడ్డగించిలా ప్రతీ ఆటంకము పొక్కదీకిరి, ప్రతి ఆలోచనకు క్రీస్తుకు లొబొడిలాపనికిరి కొరిలించొ. ");
INSERT INTO rei_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","తొమె సంపూర్న విదేయతకు దిగదీలాబెల్లే సొబ్బిటికు అవిదేయతకు ప్రతిదండనకొరికిరి సిద్దపొడికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","సంగతీనెకు ఉంపరె తొమె దిగిలీసొ, కెసన్నాను తాకు క్రీస్తుతా బులి నమ్మకం నారొనె, సెయ్యె క్యేకిరి క్రీస్తుతా సాకరాక అమె కూడ క్రీస్తులింకె బులి తా మనస్సురె సెయ్యె బులికిరి ఆలోచించిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","పొక్కిదిత్తె నీకిరి తొముకు బందితాక ప్రబువు అముకు అనుగ్రహించిలా అదికారం కోసం మియ్యి గుటెకలొ కుండె అదికముగా అతిసయపొడినెను మియ్యి లజ్జొపొడిని. ");
INSERT INTO rei_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","మియ్యి రాసిలా పత్రికలు వల్లరె తొముకు డొరిపించిమంచె బులి నాదిగిదికుండ ఏ కొత కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","తా పత్రికానె గనమైలాట బలమీలాట పనికిరి అచ్చి గాని తా దే రూపమురె బలహీనుడు తా కొతానె నిచ్చరముగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","అమె తొం అగరె నీలాబెల్లె పత్రికలు సంగరె కొతానె ప్రకారము ఈలాలింకె పనికిరి అచ్చొ అగరె రొల్లబెల్ల పైటిసంగరె సాలింకె పనాక రొమ్మంచి బులి సాకిరి తంకె ఆలోచించిలీసె. ");
INSERT INTO rei_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","తాకు సెయ్యాక మెచ్చిగిల్లీసి కుండెలింకెదీ జతపరిచిగిత్తె ఈనెను తంకెది సరిదిగ్గిత్తె యీనెను అమె తెగించినింతొ గాని తంకె తొంసంగరె జొనె దీకిరి జొనె బచ్చిగీకిరి జొనుకు జొనె సరిదిగ్గిత్తల్లందరె గ్రహించిగినారికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","అమె ఈనె స్దాయికి మించికిరి అతిసయపొడినింతొ ఈనె తొమె రొల్ల గా జాంక అయిమంచిబులి పురువు అముకు నప్పికిరిదిల్లా స్దాయికి లోబొడికి అతిసయించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","అమె క్రీస్తు సువార్త ప్రకటించికిరి తొంజాంక అయికిరి అచ్చి గనుక తో పక్కు నా అయిలపనా అమె మొ స్దాయి దాటికిరి జెల్లాలింకె నింతొ. ");
INSERT INTO rei_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","అమె స్దాయికి మించికిరి ఎదుటలింకు ప్రయాస పలమూనెరె వొంతు రొల్లపనికిరి అతిసయపొడండి తొం విస్వాసము అబివ్రుద్ది యిలా కొద్ది అముకు అనుగ్రహించిలా స్దాయికి బిత్తరాక సువార్త ఇంకా విసేసముగా ప్రకటించిలించొ. ");
INSERT INTO rei_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","తొం చుట్టు పక్కరె తల్లా ప్రదేసమునెకు కూడ సువార్త ప్రకటించుబులి అమె తొం మూలముగా గనపరచబొడించొ బులి నిరీక్సించిలించో గాని మరి ఇంకాజొనెరె స్దాయికి చేరికిరి సిద్దముగా తల్లా పైటి గురించి అమె అతిసయపొడినింతొ. ");
INSERT INTO rei_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","“అతిసయపొడిలలింకె ప్రబువురె అతిసయపొడిమంచె బులి లేకనాన్రె రాసికిరి అచ్చి.” ");
INSERT INTO rei_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ప్రబువు మెచ్చిగిల్లాటాక యోగ్యుడు గాని తాకు సెయ్యె మెచ్చిగిల్లాట యోగ్యుడు నీ. ");
INSERT INTO rei_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","కుండె వివేకముగా మియ్యి కొతలగిలానీ తొమె సహించిమంచి బులి కొరిలించి మో గురించి తొమె కిడయినెను సహించిమంచి. ");
INSERT INTO rei_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","దేవాసక్తిది తొ వలరె ఆసక్తి కలిగీకిరి అచ్చి కైంకిబుల్నె పవిత్రమైలా కన్య జొనె వొండ్రపో బుల్నె క్రీస్తుకు సమర్పించిమాసిబులి తొముకు ప్రమానం కోరించి. ");
INSERT INTO rei_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","సప్పొ తా కుయుక్తి దీకిరి హవ్వకు మోసం కొర్లాపనాక తొం మనస్సునుకు చెరిపితె క్రీస్తువల్లరె రొన్నె సరలతదీకిరి పవిత్రత దీకిరి క్యాకిరి యీనెను తొలిగిజూసెకీవొ బులి డొర్లించి. ");
INSERT INTO rei_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","కెడబుల్నె అయిలలింకె కేసెనను అమె నాప్రకటించిలాట యింకజొనె యేసు ప్రకటించినెను నినె తొమె నాకడిగిల్లలింకె ఇంకాగుటె ఆత్మకు తొమె కడిగిల్లాట తొమె నా అంగీకరించిలాట యింకా గుటె సువార్త తొమె అంగీకరించితె తొమె తా గురించి సహించివురొ బొల్టాక. ");
INSERT INTO rei_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","మియినె స్రేస్టమైలా ఏ “అపొస్తులు” కన్నా మియి కెత్తె మాత్రము తక్కువతా నీబులి తలంచిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","కొతానెరె మియి ఓర్పునీలాట యినెను జ్ఞానమురె ఓర్పునీలాట నీ. ప్రతి సంగతినిరె సొబ్బిలింకె మొజీరె తొంనిమిత్తము అమె సే జ్ఞానముకు దిగిదీతె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","తొముకు హెచ్చించిమంచెబులి తొముకు పురువు సువార్తకు సుచ్చరాక ప్రకటించిల్లించి మెత్తె మియి తగ్గించిగిల్లా వల్లరె పాపము కొరించినా? ");
INSERT INTO rei_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","తొముకు పరిచర్య కొరితె మియి ఏతరం సంగములు వల్లరె బొరొతొనొ కడిగీకిరి, తొముకు సాయం కొరితె నుచ్చిలాటయించి. ");
INSERT INTO rei_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ఈనె మియి తొంపక్కరె రొల్లాబెల్లె మెత్తె అవసరం రొయికి తల్లాబెల్లె మియి కావుంపరె బారం మోపిలానీ; మాసిదోనియ దీకిరి బయినె అయికిరి మో అక్కర తీర్చిసె. ప్రతి విసయంరె మియి తొముకు బారముగా నారొయికుండా జాగర్తపొడించి, యింకా అగరె జాగర్త పొడుంచి. ");
INSERT INTO rei_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","క్రీస్తు సత్యము మోబిత్తరె రొల్లావల్లరె అకయ ప్రాంతములురె మియి యాకిరి అతిసయ నాపొడుకుంటా మెత్తె ఆటంకపర్చితె కా తరమునీ. ");
INSERT INTO rei_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","మియి కొయించినా తొముకు మియి ప్రేమించిలాని బులి? మియి తొముకు ప్రేమించిలించి బులి పురువుకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","అతిసయ కారనం కుజ్జిలాలింకె కే విసయమురె అతిసయించిలీసోవొ, సే విసయమురె తంకెను అంవల్లరాక అచ్చెబులి దిగిదిల్లా నిమిత్తము తంకు కారనం నామిలుకుంటా పిట్టిపీతె, మియి మో, ");
INSERT INTO rei_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","కెడబుల్నే సెటాలింకె క్రీస్తురొ అపొస్తులు వేసము దరించిగిల్లాలింకెపని రొయికిరి, సొరొ అపొస్తులునె మోసం కొరిలా పైటిలింకెపనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ఎడ ఆచర్యము నీ; సాతాను తా హల్లొ దూత వేసము దరించిగిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","సెడకు తా పరిచారకులకు నీతి పరిచారకులు వేసము దరించిగిత్తె గొప్ప సంగతినీ. తంకె పైటినె వల్లరె తంకు అంతము కలుగుసి. ");
INSERT INTO rei_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","మియి అవివేకి బులికిరి కేసె బులిగిత్తెనాబులి యింకా కొయిలించి. సాకిరి బులిగినె మియి కుండె అతిసయపొడిలాపనికిరి మెత్తె అవివేకియీల పనికిరాక చేర్చిగీండి. ");
INSERT INTO rei_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","మియి కొయిలాట ప్రబువు కొతా ప్రకారము కొయిలానీ గాని యాకిరి అతిసయపొడితె ఆదారము కలిగీకిరి అవివేకిపని కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","బడేలింకె దే విసయమురె అతిసయపొడిలీసె సెడకు సాకిరి అతిసయపొడుంచి. ");
INSERT INTO rei_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","తొమె వివేకులైకిరి సంతోసం సంగరె అవివేకులకు సహించిలించి. ");
INSERT INTO rei_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","జొనె తొముకు దాస్యముకు లోపరిచినెను, జొనె తొముకు మింగిపినెను, జొనె తొముకు వసపరిచిగినెను, జొనె తాకు గొప్పకొరిగినెను, జొనె మూవుంపరె తొముకు మరినెను తొమె సహించిలిసొ. ");
INSERT INTO rei_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","అమె బలహినులైకిరి రొల్లాపనికిరి అవమానంగా కొతలగిలించి. కే విసయంరే కేసినెను దైర్యము కలిగీకిరి అచ్చి, సే విసయంరె మియికూడ దైర్యము కలిగిలాట; అవివేకము పని కొతలగిలించి సుమా. ");
INSERT INTO rei_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","తంకె హెబ్రీయునె? మియి కూడ హెబ్రీ తా. తంకె ఇస్రాయేలీయులింకె నా? మియి కూడ ఇస్రాయేలీ తా. తంకె అబ్రాహాము సంతానము నా? మియి కూడ అబ్రాహాము తా. ");
INSERT INTO rei_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","తంకె క్రీస్తు పరిచారకులునెనా? బోడ తా పనికిరి కొతాలగిలించి, మియి కూడ మరి బూతుగా క్రీస్తు పరిచారకుడు. మరి విసయముగా ప్రయాసపొడించి, మరి బడే సార్లు చెరసాలరె అచ్చి; అపరిమితముగా మడ్డొనె కయించి, బడే సార్లు మొర్నొ అపాయం సంగరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","యూదునె వల్లరె పంచిబెల్లె గుటె తక్కువ ముప్పై తొమ్మిది మడ్డొనె కయించి. ");
INSERT INTO rei_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","తినిబెల్లె బడ్డీనె సంగరె మరిసె. గుటెసారి పొతొరోనె సంగరె మరిసె; తినిబెల్లె బొయితొ బంగిజేకిరి స్రమపొడించి; గుటె రత్తిదూసు సొంద్రొరె గడిపించి. ");
INSERT INTO rei_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","బడేసారులు ప్రయానములురె, వొద్దోనె వల్లరె ఆపదలునెరె, సొరోనె వల్లరె ఆపదానెరె, మో సొంత మనమానె దీకిరి ఆపదానెరె, అన్యజనులు వల్లరె ఆపదానెరె, పట్నమురె సె, ");
INSERT INTO rei_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ప్రయాసం సంగరె, కొస్టొనెసంగరె, తరచుగా జాగరనమునె సంగరె, బొక్కొ సొసొ సంగరె, తరచుగా ఉపవాసము సంగరె, సిత్తొ సంగరె, దిగంబరత్వము సంగరె రోంచి, యింకా కొయిలాంచ బడేంచ అచ్చె. ");
INSERT INTO rei_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ఎడాక నికిరి సంగము సొబ్బిటి కోసం బాద అచ్చి. ఏ బారము దినొ దినో మెత్తె కలిగిలీసి. ");
INSERT INTO rei_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","కెసినెను బలహీనుడు వూసి? మియినె బలహినుడు నీనా? కెసినెను తొట్రుపొడిని? మెత్తెను మంట కలిగినీనా? ");
INSERT INTO rei_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","అతిసయ పొడికిరి తన్నె మియి మో బలహీనత విసయమైకిరి సంతులు కోసం అతిసయపొడిలించి. ");
INSERT INTO rei_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","మియి సొరొకొతాలగిలాని బులి కెబ్బుకు స్తుతింపబొడితల్లా అమె ప్రబువుయిలా యేసురొ బోయిలా పురువు బుజ్జును. ");
INSERT INTO rei_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","దమస్కురె అరెత బుల్ల రొజా తొల్లా రొల్లా అదిపతి మెత్తె దరిగితె జొగలొదీకిరి దమస్కీయుల పట్నముకు బద్రము కొరించి. ");
INSERT INTO rei_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","సెల్లె మియి కిటికీదీ గోడ ఉంపరెదీకిరి గంపలరె వొల్లిపొడికిరి తా అత్తొదీకిరి తప్పించిగీకిరి బాజించి. ");
INSERT INTO rei_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","మియి అతిసయించిమాసి, ఈనె సడవల్లరె ప్రయోజనంకిచ్చి అయిని. ప్రబువు దర్సినానె ప్రత్యక్సతలు తొముకు కొయిమి. ");
INSERT INTO rei_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","క్రీస్తురొల్ల బెల్లె జొనె మనమకు తెలుసు సెయ్యె పదునాలుగు బొచ్చొరొనె అగరె తింటవొ మెగొరె కొనిగిబాజి సెయ్యె దే సంగరె కొనిగిబాజి బులి తెలిసినీ దే నీకిరి కొనిగిబాజీ బులి మెత్తె తెలిసినీ సెడ పురువుకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","సెట మనమానె తెలుసు సెయ్యె పరదైసురె కొనిగిబాజీ వచింప సక్యము కాని కొతనె సునిసి సె కొతనె మనమనె పలికినాసి. ");
INSERT INTO rei_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","తా దే సంగరె కొనిగిబాజీసినా దేనికుంటా కొనిగిబాజీసినా మెత్తె తెలిసినీ. సెడ పురువుకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","తా పనాట గురించి అతిసయించిలించి మో విసయము యినె మో బలహీనతరె నీకిరి యింగుటె విదముగా అతిసయించిని. ");
INSERT INTO rei_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","అతిసయపొడితె నిచ్చయించినెను మియి సత్యంకా పలుకుంచి సెడకు అవివేకినీకిరి మోవల్లరె కేసినెను దిగిలాట యీనెను మోవల్లరె సునిలాటయినెను మెత్తె మియి బూతు గనముగ ");
INSERT INTO rei_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","మెత్తె కలిగిలా ప్రత్యక్సతలు బహువిసేసముగా రొల్లావల్లరె మియి అత్యదికముగా హెచ్చినాపొడుకుంటా నిమిత్తము మెత్తె దేబిత్తరె గుటె కొంట, మియి అత్యదికముగా హెచ్చిపొకుంటా నిమిత్తము, మెత్తె నలగొటితె సాతానురొ దూతపనికిరి రొయిదీసి. ");
INSERT INTO rei_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","సెడ మోపక్కరెదీకిరి తొలిగిజిమంచెబులి సెడ విసయంయికిరి ముమ్మారు ప్రబువుకు వేడిగిలించి. ");
INSERT INTO rei_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","సెడకు మో క్రుప తొత్తె చాలు; బలహీనతరె మొ సక్తి పరిపూర్నమిలిసి బులి సెయ్యె మో సంగరె కొయిసి. సెడకు క్రీస్తు సక్తి మో ఉంపరె టారిలా వల్లరె, విసేసముగా బలహీనతలురె ");
INSERT INTO rei_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","మియి కెబ్బుకు బలహీనుడువొ సెల్లె బలవంతుడు గనక క్రీస్తు నిమిత్తము మెత్తె కలిగిలా బలహీనతలురె నిందలురె ఇబ్బందులురె హింసలురె ఉపద్రవములురె మియి సంతోసించిలించి. ");
INSERT INTO rei_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","మియి బుద్దిహితులుపన నటించిలించి తొమె మెత్తె బలవంతము కొరుసొ. మియి తొంవల్లరె మెప్పు పొందివలిసిలాట, క్యాకిరి బుల్నే మియి కెమాత్రము యిలాటానిననా మిక్కిలి స్రేస్టమైలా ఏ అపొస్తులుకన్నా మియి ఏ విసయంబిత్తరె తక్కువయిలాట నీ. ");
INSERT INTO rei_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","దిగిదిల్లాపైటీనె అద్బుతానె గొప్ప పైటీనె కొరివురొ వల్లరె అపొస్తులురొ గుర్తునె పూర్నమైలా ఓర్పు సంగరె తొం మొజిరె సొత్తుగా దిగిపించిసి. ");
INSERT INTO rei_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","మియి తొముకు బారముగా రొన్నిబుల్లా విసయంరె తప్ప, యింకా కే విసయంరెయినె, పొదరి సంగములు కన్నా తక్కువలింకె యిసొ? మియి కొరిలా ఏ అన్యాయముకు క్సమించొండి. ");
INSERT INTO rei_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ఇదిగొ, తినెబెల్లె తొంపక్కు అయితె సిద్దముగా అచ్చి. అయిలబెల్లె తొముకు బారముగా తన్ని. మియి సొత్తుకు నీగాని తొమెకాక మియి కొరిలించి. పిల్లనె మాబోనె కోసం నీగని బో మాక పిల్లనె కోసం ఆస్తి కూర్చిమంచెనీనా. ");
INSERT INTO rei_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","సెడకు మెత్తె కలిగిల సొబ్బిటికి తొం ఆత్మానె కోసం బడే సంతోసముగా కర్చు కొరిమి; మియి తొం కోసమాక కర్చుయీజిమి మియి తొముకు కెత్తె బూతు ప్రేమించిలించొ సెత్తె తక్కువుగా మెత్తె ప్రేమించువొనా? ");
INSERT INTO rei_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","సెడ సాకిరి తమ్మురొండి. మియి తొముకు బారముగా నీగాని, యుక్తియిలట పనికిరి తొముకు తొత్తె మాయకొరికిరి జింకిగిల్లించి బులి కొయిగిల్లీసె కీవొ. ");
INSERT INTO rei_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","మియి తొమె పక్కు పొడదిలాలింకె బిత్తరె కాసంగరె యినెను తొముకు మాయకొరించినా. ");
INSERT INTO rei_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","తోపక్కు జేతందుకు తీతుకు హెచ్చరించికిరి తా సంగరె కూడ గుటె బయికు పొడదించి తీతు తొముకు మోసం కొరికిరి తొంపక్కరె కిరయీనెను జింకిగిచ్చినా? అమె గుటె ఆత్మరె గుటె పనికిరి చలిజెల్లానింతొనా? ");
INSERT INTO rei_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","మో జట్టుకారీనెలింకె అమె ఎత్తెజాంక అమె విసయమైకిరి తొముకు సమాదానం కొయిలించొ బులి తొముకు తోసిలీసికీవొ. పురువు అగరాక క్రీస్తురె కొతాలగిలించొ; ఇస్టమైలలింకె తొమె బొల్లె రొమ్మంచెబులి తొం కోసం ఎడానల్లా కొయిలించొ. ");
INSERT INTO rei_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","కైంకిబుల్నే మియి అయిలాబెల్లె తొమె మెత్తె ఇస్టమైలాలింకె పనికిరి తన్నారొ కీవొబులి, మియి తొముకు ఇస్టమైలా పనికిరి తన్నికీవొ యింకా కొలీనె అసూయ క్రోదము కక్సానె కొండెమునె గుసగుసానె ఉప్పొంగువురొ అల్లరినె తాసె కిరవొ బులి, ");
INSERT INTO rei_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","మియి యింకా అయిలాబెల్లె మో పురువు తొంమొజిరె మెత్తె సన్నిట కొరువొ బులి అగరె పాపం కొరికిరి తంకె జరిగించిలా అపవిత్రత జారత్వము పోకిరి పైటినె నిమిత్తము పొచ్చుకు బుల్లికిరి నాపొందిలా బడేలింకె గురించి దుక్కొపొడివురొ అయివొకీవొబులి డొరిజీలించి. ");
INSERT INTO rei_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ఎ తింటసారి మియి తొముకు పక్కు అయిలించి దీలింకె తిల్లింకె సాక్సీనె తుండొరె ప్రతి కొతానె నిర్దారన వుసి యడ లేకనానెరె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","మియి అగరె కొయించి; మియి ఉంచినె తొంపక్క రె నీనెను దీటొసారి తొంపక్కరె రొల్లాపనికిరి, అగరెదీకిరి పాపము కొరితల్లాలింకు మిగిల్లలింకె సొబ్బిలింకు అగరె కొయిలాట కిరబుల్నే, మియి బుల్లికిరి అయిలబెల్లె కనికరము దిగిదినీ. ");
INSERT INTO rei_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","క్రీస్తు మోదీకిరి కొతలగిలిసిబులి రుజువు కోరిలిసొనా? సెయ్యె తొంవుంపరె బలహినుడు నీ గానీ, తొంవుంపరె సక్తిమంతుడైయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","బలహీనత వల్లరె సెయ్యె సిలువ పొగిసెగానీ, పురువు సక్తి వల్లరె జీలీసి. సాకరాక మియ్యె క్రీస్తురె గుటె యీలా కారనంగా బలహీనతరె అచ్చి సాకరాక తొత్తె సేవా కొరితె పురువు సక్తివలరె మియ్యె జీవించిలించి ");
INSERT INTO rei_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","తొమె విస్వాసముగల్లాలింకె పనికిరి అచ్చెనా నీనా తొముకు తొమ్మాక సోదించిగికిరి దిగండి; తొముకు తొమ్మాక పరిక్సించిగిండి; తొమె బ్రస్టునె నీనె యేసుక్రీస్తు తొంబిత్తరె అచ్చిబులి తొమె కోసం తొమ్మాక బుజ్జినింతొనా? ");
INSERT INTO rei_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","అమె బ్రస్టునె నీబులి తొమె తెలిసిగుంచొబులి మో నమ్మకం. ");
INSERT INTO rei_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","తొమె కే చెడ్డపైటి నాకొరుకుండ రొమ్మంచెబులి పురువుకు ప్రార్దంచిలించి. అమె యోగ్యునెపనికిరి దిగదీమంచెబులి నీ కాని, అమె అయోగ్యులుపనికిరి నాదిగదిల్ల తొమె బొల్లాక కొరిమంచెబులి అం ఉద్దేసం. ");
INSERT INTO rei_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","అమె కేవలం సొత్త కోసం గానీ సోత్తకు వేతిరెకంగ కిచ్చి కొరినారొ. ");
INSERT INTO rei_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","అమె బలహీనులిన్నెను తొమె బలవంతులులికిరి రొన్నె సంతోసించిమో. ఎడవల్లరె, బుల్నే సంపూర్నునె యిమంచెబులి ప్రార్దంచిలించి. ");
INSERT INTO rei_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","సెడకు మియి దూరగా రొల్లబేల్లకా ఏ సంగితినె రాసిలించి. సాకిరి కోరినె మియి అయిలాబెల్లె మో అదికారం ఉపయోగించిలబిత్తరె కాటిన్యత దిగదిల్లా అవసరం రొన్ని. ఏ అదికారం ప్రబువు తొముకు పొక్కదిత్తె నికిరి, బందిత్తె దీసి. ");
INSERT INTO rei_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ఆకరుకు, అన్నబయినె అప్పబొయినీనె, సంతోసించొండి! పునరుద్దన కోసం పాటుపొడొండి. ప్రోత్సహం పొందిగిండి. గుట్టె మనస్సు సంగరె రోండి. సాంతి సంగరె జీండి. ప్రేమ, సమాదానం పురువు తొంసంగరె రోసి. ");
INSERT INTO rei_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","పవిత్రమైల చుమ్మో లొగ్గికిరి జొనుకు జొనె దండము కొయిగీండి. ");
INSERT INTO rei_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","పరిసుద్దులల్లా తొముకు వందనమునె కొయిలీసె, ");
INSERT INTO rei_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ప్రబువైలా యేసు క్రీస్తు క్రుప పురువురొ ప్రేమ పరిసుద్దాత్మరొ సహవాసము తొముకల్లా తోడైకిరి రొమ్మంచె.");
INSERT INTO rei_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","మనమానె ద్వారా నీకుంటా కే మనమ సంగరె ఈనన్నా నీకుంటా యేసు క్రీస్తు ద్వారాగ, తాకు మొరిజిల్లాలింకె బిత్తరె తీకిరి సజీవంగా ఉడదిల్లా బో ఈలా పురువు ద్వారాగా అపోస్తులుడుగా డక్కిగిల్లా పౌలు బుల్లా మియ్యి, ");
INSERT INTO rei_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ఈనె మో సంగంరె పాటు తల్లా విస్వాసులల్లా గలతీయ ప్రాంతంరె తల్లా సంగాలుకు సుబాలు కొయికిరి రాసిలా విసయోనె. ");
INSERT INTO rei_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","బోయీలా పురువు తీకిరి అం ప్రబువైలా యేసు క్రీస్తు తీకిరి తొముకు క్రుప, సాంతి కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","అం బోయీలా పురువురొ ఇస్టం ప్రకారం క్రీస్తు అముకు ఉంచినె తల్లా దుస్టకలొ తీకిరి చొడిపించిమాసిబులి అం పాపోనె కోసం తాకు సెయ్యాక ఒప్పకొయిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","పురువుకు సొబ్బిబెల్లె మహిమ కలిగిమాసి. ఆమేను. ");
INSERT INTO rei_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","క్రీస్తు క్రుప ద్వారా తొముకు డక్కిలాటకు సడదీకిరి, ఇంగుటె సువార్త ఆడుకు తొమె ఎత్తొ బేగా బుల్లికిరి పొలిజెవురొ దిగితన్నే మెత్తె బడే ఆచ్చర్యం కలిగిలీసి. ");
INSERT INTO rei_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","అసలు “ఇంగుటె సువార్త బుల్లాట నీ,” ఈనె క్రీస్తు సువార్తకు వక్రీకరించికిరి తొముకు గలిబిలి కొరిలాలింకె వొదిలింకె అచ్చె. ");
INSERT INTO rei_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ఈనె అమె తొముకు ప్రకటించిలా సువార్త నీకుంటా ఇంగుటె సువార్తకు అమె యీనెను పరలోకం తీకిరి అయిలా దేవదూతన్నా తొముకు ప్రకటించినె, సెయ్యె పురువురొ నరకసిక్సకు జోసి. ");
INSERT INTO rei_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","సాకిరాక అమె అడకగరె కొయిలాపనికిరాక ఉంచినంకా ఇంకా కొయిలించొ. తొమె అంగీకరించిలా సువార్త నీకిరి ఇంగుటె కేసైనా ప్రకటించినె, తాకు పురువు నరకసిక్సకు పాత్రుడు. ");
INSERT INTO rei_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ఉంచినె మియి మనమాన్రొ మెప్పుకు కోరిగిల్లించినా? నోనె పురువురొ మెప్పుకు కోరిగిల్లించినా? మియ్యి మనమానుకు సంతోసపర్చిమాసి బులిగిన్నే క్రీస్తుకు దాసుడు ఈనారింత. ");
INSERT INTO rei_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","మానే బయినె, మియ్యి ప్రకటించిలా సువార్త మనమానె ద్వారా అయిలాటనీబులి తొముకు తెలిసిమాసి. ");
INSERT INTO rei_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","మనమ తీకిరి మియ్యి సడకు పొందిలానియ్యి, మెత్తె కేసే సడకు బోదించిలానింతె, యేసు క్రీస్తాక స్వయంగా మెత్తె బయలుపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","మో అగరొ యూదామత జీవితం గురించి తొమె సునిసొ. మీ పురువురొ సంగముకు గోరంగా హింసించుకుంటా నాసనం కొరుకుంటా రొయితమ్మి. ");
INSERT INTO rei_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","సెత్తెలె మెత్తె మో పూర్వికులురొ సాంప్రదాయాలంపరె బడే ఆసక్తి తవ్వి. యూదా మత నిస్ట విసయంరె మో సొంత జతి మనమాన్రె మో ఈడు కలిగిలా బడేలింకు మించిజేంచి. ");
INSERT INTO rei_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ఈనెను మా పెట్టొరె మెత్తె ప్రత్యేకపరిచిగీకిరి, తా క్రుప సంగరె మెత్తె డక్కిలా పురువు మీ యూదునెనీలాలింకు తా పో గురించి ప్రకటించిమాసి బులి ");
INSERT INTO rei_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","సెయ్యె తాకు మో బిత్తరె బయలుపరిస్తే ఇస్టపొడిసి. సెత్తెలె ఎంట్రాక మీ సలహా కోసం యూదునె సంగరె సంప్రతించిలానీ గని బో నిర్నయించిలా పోరొ సువార్త ప్రకటించితె పొదరెలింకె పక్కాక జేంచి. ");
INSERT INTO rei_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","మో కన్నా అగరె అపోస్తులైలాలింకు పక్కైనా, యెరూసలేముకైనన్నా జెల్లానీ, అరేబియా దెసొకు జేకిరి సే తర్వాతరె దమస్కు పట్నంకు బుల్లికిరి అయించి. ");
INSERT INTO rei_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","తింట బొచ్చురొ ఈలాబెల్లె పేతురుకు పరిచయం కొరిగిమ్మాసి బులి యెరూసలేముకు జేకిరి తా పక్కరె పదిహేను దినొనె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","తాకు తప్ప అపోస్తులునెరె ఇంకా కాకూ మీ దిగిలాని, ప్రబువురొ బయి యాకోబుకు మాత్రం దిగించి. ");
INSERT INTO rei_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","మీ తొముకు రాసితల్లా యే సంగతీనె గురించి పురువు అగరె నుచ్చిలానీ. ");
INSERT INTO rei_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","సే తర్వాతరె సిరియా, కిలికియ ప్రాంతమూనెకు అయించి. ");
INSERT INTO rei_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","క్రీస్తురె తల్లా యూదయ సంగంలింకు మో మూ పరిచయం నీ. ఈనె ");
INSERT INTO rei_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","“అగరె అముకు హింసించిలాట సెయ్యె అగరె పాడుకొరితందుకు అయిలాట మతముకు ప్రకటించిలీసి” బుల్లా సంగతి మాత్రమాక సునికిరి, ");
INSERT INTO rei_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","తంకె మో ద్వారా పురువుకు మహిమ పర్చిసె. ");
INSERT INTO rei_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","పద్నాలుగు బొచ్చురోనే ఈలా తర్వాతరె మీ తీతుకు దరిగీకిరి బర్నబా సంగరంకా యెరూసలేముకు బుల్లికిరి జేంచి. ");
INSERT INTO rei_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","అమె జెమ్మాసి బులి పురువు సొప్నొరె కొయిలందరాక జేంచి. మో ప్రయాస వ్యర్దమైజెల్లీకీవో బులి, నీనే వ్యర్దమైజేసి కీవో బులి మీ పొదరెలింకు ప్రకటించితల్లా సువార్త కోసం విస్వాసుల్రె ముక్యమైలా నాయికులుకు ప్రత్యేకంగా బోదించించి. ");
INSERT INTO rei_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ఈనె మో పక్కెరె తల్లా తీతు గ్రీసు దెసొతా ఈనన్నా సున్నతి పొందిమాసి బులి కేసే తాకు బలవంతం కొరిలానింతె. ");
INSERT INTO rei_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","క్రీస్తు యేసురె అముకు కలిగిలా స్వతంత్రముకు కనిపెట్టికిరి, అముకు బానిసలుగా కొరితె దిగితందుకు, రహాస్యంగా కపట సహోదరులునె ప్రవేసించిసె. ");
INSERT INTO rei_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","సువార్త సత్యం మార్పు నీకుంటా, తొముకు పైటికైలా పనికిరి రొయితందుకు తొం మొజిరె రొమ్మాసి బులి తంకె సంగరె అమె గుట్టె గడియన్నా ఏకీబవించిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ఈనె నాయికులుగా బచ్చిగిల్లాలింకె మీ కొయిలా సందేసాలుకు మార్పునె కిచ్చీ కొరిలానింతె. సే నాయకునె గొప్పలింకాక ఈనె తంకె మెత్తె ముక్యం నీ. పురువు మనమరొ పొదరె రూపు దిగిని. ");
INSERT INTO rei_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ఈనె సున్నతి పొందిలా యూదునెకు బోదించితె పురువు పేతురుకు క్యాకిరి ఒప్పకొయిసొ, సాకిరాక సున్నతి నాపొందిలా పొదరెలింకు బోదించితందుకు మెత్తె ఒప్పకొయిసి బులి తంకె గ్రహించిసె. ");
INSERT INTO rei_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","బుల్నే, సున్నతి పొందిలా యూదునెకు అపొస్తులుడుగా రొయితందుకు పేతురుకు సామర్ద్యం దిల్లాటాక, అన్యమనమానెకు అపోస్తులుడుగా రొయితందుకు మెత్తంకా సామర్ద్యం దీసి. ");
INSERT INTO rei_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","నాయకులుగా నా తల్లా యాకోబు, పేతురు, యోహాను బుల్లాలింకె పురువు మెత్తె అనుగ్రహించిలా ప్రత్యేకమైలా పైటికి జనికిరి, అమె అన్యమనమానెకాక నీకుంటా, సున్నతి పొందిలాలింకంకా అపోస్తులులుగా తమ్మాసి బులి కొయికిరి, తంకు సంగరె పాలిబాగస్తులైతే గుర్తుగా తంకె బత్తొకైలా అత్తోనుకు మో సంగరె, బర్నబా సంగరె దీసె. ");
INSERT INTO rei_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","తంకల్లా బీదలింకెరొ అవసరాలు తీర్చిమాసి బులికిరాక కోరిసె. సాకిరి కొరితందుకాక మీ ఆసక్తి కలిక్కిరి అచ్చి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ఈనె పేతురు, అంతియొకయకు అయిలబెల్లె సెయ్యె తప్పు కొరిసి గనక మీ తాకు మో అంపరె కొయించి. ");
INSERT INTO rei_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","కైంకిబుల్నే, యాకోబు పక్కరె తీకిరి కుండెమంది నాఅయిలా అగరె సెయ్యె పొదరెలింకె సంగరె కద్ది కైలీసి. తంకె అయిలాబెల్లె సున్నతి పొందిలాలింకు డొరికిరి పొచ్చుకు తైకిరి పొక్కు బాజేసి. ");
INSERT INTO rei_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","తల్లా యూదులంకా తా సంగరె మిసిజేకిరి కపట ఏసం పొగ్గిచ్చె. బర్నబా అంకా తంకపంట ఏసం వల్లరె మోసమైజేసి. ");
INSERT INTO rei_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","తంకె సువార్త సత్యంకు సల్లాంతె బులి, మీ దిక్కిరి సొబ్బిలింకగరె పేతురుసంగరె, “తూ యూదుడుగా తైకిరంకా యూదుడుపనికిరి నీకుంటా, అన్యుడుపనికిరి జీవించిలబెల్లె, పొదరెలింకెనె యూదునెపనికిరి జీవించిమాసి బులి కైంకి బలవంతం కొరిలీసు?” బులించి. ");
INSERT INTO rei_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","అమె జొర్నొతీకిరి యూదునెమాక ఈనె, “అన్యమనమానెరె పాపోనె” నింతొ. ");
INSERT INTO rei_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","మనమ యేసు క్రీస్తురె విస్వాసం రొగ్గువురొ వల్లరాక పురువు నీతిమంతుడుగా తీర్చుసి ఈనె, దర్మసాస్త్రం ద్వారానీ. సే సంగతి జనిలా అమ్మంకా దర్మసాస్త్రంరొ పైటీనె వల్లరె నీకుంటా క్రీస్తు వల్లరె విస్వాసం ద్వారా పురువు ద్వారా నీతిమంతునెగా తీర్పు పొందితందుకు యేసు క్రీస్తురె విస్వాసం రొగ్గించొ. దర్మసాస్త్రంకు సంబందించిలా పైటీనె వల్లరె కేసే నీతిమంతుడు బులి తీర్పు పొందినింతె నీనా. ");
INSERT INTO rei_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ఈనె, పురువు అముకు క్రీస్తురె నీతిమంతునెగా తీర్చిమాసి బులి కుజ్జితన్నుగా అమె పాపోనెగా దిగదెన్నే, క్రీస్తు పాపముకు సేవకుడైసినా? సాకిరి కొయినాసి. ");
INSERT INTO rei_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","మీ పొక్కదిల్లాంచకు ఇంకా బందినే మెత్తె మియ్యాక అపరాదిగా కొరుగుంచి నీనా. ");
INSERT INTO rei_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","మీ ఈనె, పురువు కోసం జీతె, దర్మసాస్త్రం వల్లరె దర్మసాస్త్రం ద్వారా మొరిజేంచి. ");
INSERT INTO rei_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","మీ క్రీస్తు సంగరంకా సిలువ మొర్నొ పొందిగించి. ఇంక జీతల్లాట మియ్యి నియ్యి, క్రీస్తాక మో బిత్తరె జీలీసి. మీ ఉంచినె దేరె జీతల్లా జీక మెత్తె ప్రేమించికిరి, మో కోసం తాకు సెయ్యాక ఒప్పగించిగిల్లా పురువురొ పో అంపరె తల్లా విస్వాసం వల్లరాక. ");
INSERT INTO rei_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","మీ పురువురొ క్రుపకు నిరర్దకం కొరిని. నీతి దర్మసాస్త్రం వల్లరె సాద్యమైనె క్రీస్తు మొరిజివ్వురొ అనవసరమాక నీనా. ");
INSERT INTO rei_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","తెలివినీలా గలతీయులింకె, తొముకు మోసం కొరిలాట కేసే? సిలువకు పొగిబొడిలాట పనికిరి యేసు క్రీస్తు తొం అంకీనె అగరె దిగిపించించొ నీనా! ");
INSERT INTO rei_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","తొం ద్వారా మీ గుటె తెలిసిగిమ్మాసి బులిగిల్లించి. సడ కిడబుల్నే, దర్మసాస్త్రంకు సంబందించిలా పైటినె వల్లరె ఆత్మకు పొందిసోనా నీనే విస్వాసం సంగరె? సునువురొ ద్వారా పొందిసోనా? ");
INSERT INTO rei_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","తొమె ఎత్తొ బుద్ది నీకుంటా అచ్చొ? అగరె పురువురొ ఆత్మ సంగరె మొదలుదీకిరి, ఉంచినె దేసంగరె పరిపూర్నులైవొనా? ");
INSERT INTO rei_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ఎత్తొ కొస్టోనె పొడ్లాంచల్లా సుచ్చాటాకనా? సడానల్లా సుచ్చరాక జోసెనా? ");
INSERT INTO rei_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ఆత్మకు తొముకు అనుగ్రహించికిరి, తొంబిత్తరె అద్బుతానె కొరిపించితల్లాట, దర్మసాస్త్రంకు సంబందమైల పైటినె వల్లరెనా నీనే విస్వాసం సంగరె సునువురొ వల్లరె కొరిపించిలీసినా? ");
INSERT INTO rei_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","అబ్రాహాము, “పురువుకు నమ్మిసి సడాక తాకు న్యాయంగా బచ్చిగీసి.” ");
INSERT INTO rei_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","సడుకాక, విస్వాసం రొగ్గిల్లాలింకాక అబ్రాహాము సంతానం బులి తొమె తెలిసిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","పురువు విస్వాసం ద్వారా యూదునెనీలాలింకు న్యాయంగా తీర్చిమి బులి లేకనమురె అగుంతాక దిక్కిరి, తో ద్వారా “మనమానల్లా ఆసీర్వదించబొడివె బులి అబ్రాహాముకు సువార్త అగుంతాక ప్రకటించిసి.” ");
INSERT INTO rei_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ఈనె విస్వాస సంబందులాక విస్వాసంగల్లా అబ్రాహాము సంగరంకా ఆసీర్వదించబొడివె. ");
INSERT INTO rei_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","దర్మసాస్త్రం విదించిలా పైటినుకు సంబందించిలాలింకల్లా సాపం తొల్లచ్చె. కైంకిబుల్నే “దర్మసాస్త్రగ్రందంరె రాసికిరితల్లా విదులల్లా కొరితందుకు నిలకడగా నీలా ప్రతీమనమ సాపగ్రస్తుడు” బులి రాసికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","దర్మసాస్త్రం వల్లరె కేసైనా పురువు అగరె నీతిమంతుడు బులి తీర్చబొడినీ బుల్లా సంగతి స్పస్టమాక. కైంకిబుల్నే “నీతిమంతుడు విస్వాసం వల్లరె జీవొ.” ");
INSERT INTO rei_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","దర్మసాస్త్రం విస్వాస సంబందమైలాటనీ గని సడరొ నియమానెకు ఆచరించిలాట సడవల్లరాక జీవించువొ. ");
INSERT INTO rei_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","ఆత్మ గురించి ఈలా వాగ్దానం విస్వాసం ద్వారా అముకు మిల్లాపనికిరి, సడుకాక, “మాను ఉంపరె యాలబొడిలా ప్రతీమనమ సాపగ్రస్తుడు” బులి దర్మసాస్త్రంరె రాసికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","అబ్రాహాము పొందిలా ఆసీర్వచనం క్రీస్తు యేసు ద్వారా అన్యమనమానెకు కలిగితందుకు, క్రీస్తు అముకోసం సాపమైకిరి, దర్మసాస్త్రంరొ సిక్సతీకిరి అముకు చొడిపించిసి. ");
INSERT INTO rei_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","మో జట్టుకారీనె, మనమ రీతిగా కొతలగిలించి; మనమానె నిర్నయించిలాట ఈనెను సడ స్తిరపరిచిలా తర్వాతరె ఇంకజొనెకేసే సడకు మరిపీనారె, సడకు కిచ్చీ మిసినారె. ");
INSERT INTO rei_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","అబ్రాహాముకు తా సంతానముకు పురువు వాగ్దానాలు దీసి. సెయ్యె బడేలింకు గురించి బుల్లాపనికిరి, తో పిల్లానుకు బులి నా కొయికిరి జొన్నె గురించి కొయిలా పనికిరాక, “తో సంతానముకు బులి కొయిసి.” “సే సంతానం క్రీస్తాక.” ");
INSERT INTO rei_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","మీ కొయిలాట కిడబుల్నే, చారసోయింపరె తిందొస్ట బొచ్చురోనె యీలా తర్వాతరె అయిల దర్మసాస్త్రం, పురువు అగుంతాక స్తిరపరిచిలా నిబందనకు పిట్టిపీని. సడరొ వాగ్దానంకు వ్యర్దం కొరిని. ");
INSERT INTO rei_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","సే వారసత్వం దర్మసాస్త్రం ద్వారా కలిగిలాపనికిరి ఈనె, ఇంక వాగ్దానము నా ఈలపనికిరాక. ఈనె పురువు అబ్రాహాముకు వాగ్దానము వల్లరాక వారసత్వం అనుగ్రహించిసి. ");
INSERT INTO rei_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","సాకిరైనే దర్మసాస్త్రం కైంకి? కాకోసం ఈనె సే వాగ్దానం కొరిసో సే సంతానం అయిలెత్తెజాంక సడ అమలురె అచ్చి. సడ మొజిమనమ ద్వారా దేవదూతానె సంగరె నియమించిసి. ");
INSERT INTO rei_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","మొజిరొమనమ అచ్చిబుల్నె జొనుకాక నీ గని, పురువు జొన్నాక. ");
INSERT INTO rei_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","దర్మసాస్త్రం పురువురొ వాగ్దానాలుకు వ్యతిరేకంనా? నీ. ఈనెమాను దర్మసాస్త్రం జీపించిగలిగిలాటైనె, సడవల్లరాక నీతి కలిగిత. ");
INSERT INTO rei_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ఈనె యేసు క్రీస్తు వల్లరె విస్వాసం ద్వారా కలిగిలా వాగ్దానం విస్వసించిలాలింకు అనుగ్రహించితె లేకనము సొబ్బిలింకు పాపంరె బందించిసి. ");
INSERT INTO rei_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","విస్వాసం పొదరెనాపొడిలాబెల్లె విస్వాసం ప్రత్యక్సమైలావరకూ, అమె దర్మసాస్త్రంకు మాత్రమాక పరిమితమైకిరి సడరొ చెరరె అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ఈనె పురువు అముకు విస్వాసం ద్వారా నీతిమంతునెగా కొరికిరి క్రీస్తు పక్కు సలిపించితె, దర్మసాస్త్రం అముకు ప్రాదమిక బోదకుడుగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ఈనె విస్వాసం పొదరకు అయిసి గనక ఉంచినె ప్రాదమిక బోదకుడు తొల్లె తన్నింతొ. ");
INSERT INTO rei_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","యేసుక్రీస్తురె విస్వాసం వల్లరె తొమల్లా పురువురొ పిల్లానె యికిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","క్రీస్తురె బాప్టీసం పొందిలా తొమల్లా క్రీస్తుకు పిందిగిచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","యాండ్రె యూదుడు బులి గ్రీసుదెసొట బులి నీ, దాసుడు బులి స్వతంత్రుడు బులి నీ. వొండ్రపో తిల్డ్రపిల్ల బులినీ, యేసుక్రీస్తురె తొమల్లా గుట్టైకిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","తొమె క్రీస్తుకు సంబందించిలాలింకైనే, అబ్రాహామురొ పిల్లానైకిరి, వాగ్దానం ప్రకారం వారసులైకిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ఈనె మీ కొయిలాట కిరబుల్నే, వారసుడు సొబ్బిటికి కర్త ఈకిరితన్నెనూ పిల్లాసొ ఈకిరి తల్లెత్తెకలొ తాకు దాసుడుకు కే బేదమునీ. ");
INSERT INTO rei_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","బో ద్వారా నిర్నయించిలా దినొ అయిలజాంక సెయ్యె సంరక్సకులురొ, గ్రుహనిర్వాహకునెరొ ఆదీనంరె తాసి. ");
INSERT INTO rei_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","సాకిరాక అమంకా పిల్లానైకిరి తల్లబెల్లె లోకసంబందమైలా మూలపటోనుకు లోబొడికిరి దాసులైకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ఈనె కలొ పరిపూర్నమైలాబెల్లె పురువు తా పోకు పొడిదీసి. సెయ్యె మనమగా మొట్టకు జొర్నైకిరి యూదునెరొ దర్మసాస్త్రం తొల్లె జీసి. ");
INSERT INTO rei_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","అమె పుసిగిల్లాపోనె ఈవాసిబులి, దర్మసాస్త్రముకు లోబొడికిరి తల్లలింకు చొడిపించితె దర్మసాస్త్రముకు లోబొడిలాటఈసి. ");
INSERT INTO rei_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","సడుకాక తొమె పురువురొ పోనె ఈకిరి అచ్చొ గనక “అబ్బా, బొ” బులి డక్కిలా తా పోరొ ఆత్మకు పురువు అం మనుసూనెబిత్తురుకు పొడిదీసి. ");
INSERT INTO rei_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ఈనె తు ఇంక దాసుడు నీ పోఆక. పో ఈనె పురువు ద్వారా వారసుడు. ");
INSERT INTO rei_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","సే కల్రె ఈనె తొమె పురువుకు నాజనికిరి, సొత్తాక పురువునె నీలాలింకు దాసులైకిరి అచ్చొ, ");
INSERT INTO rei_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ఈనె ఉంచినె తొమె పురువుకు జనిలాలింకె, ఇంకా ప్రత్యేకించికిరి పురువు తొముకు తెలిసిగిచ్చి గనక బలహీనమైలాంచ, నాపైటికైలా మూలపైటీనేపు కైంకి జెల్లీసొ? ఇంకా సడానుకు బానీసలుగా తమ్మాసిబులిగిల్లోనా? ");
INSERT INTO rei_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","తొమె దినోనుకు, మసోనుకు ఉత్సవకలోనుకు, బొచ్చురోనుకూ ప్రత్యేకంగా ఆచరించిలీసొపని. ");
INSERT INTO rei_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","తొం గురించి మీ పొడిలా కొస్టొ వ్యర్దమైజోసికీవోబులి తొం గురించి డొరిజిల్లించి. ");
INSERT INTO rei_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","మో జట్టుకారీనె, మీ తొం పనాట యీంచి గనక తొమ్మంకా మోపనాలింకె ఈవాసిబులికిరి తొముకు బతిమాలిగిల్లించి. తొమె మెత్తె అన్యాయం కొరిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","కైంకిబుల్నే అగరెసారి మెత్తె దేరెనాబొల్లరినన్నా, తొముకు సువార్త ప్రకటించించి బులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","సెత్తెలె మో దేరె నాబొల్లెరొన్నన్నా సడకు దరికిరి తొమె మెత్తె త్రునీకరించిలానింతొ, నిరాకరించిలానింతొ గని పురువురొ దూత పనికిరి, క్రీస్తుయేసు పనికిరి మెత్తె అంగీకరించిసొ. ");
INSERT INTO rei_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","తొమె కొయిగిల్లా దన్యత కిరైసి? వీలైనే తొం అంకీనె కడికిరి మెత్తె దీపేతొ బులి తొం గురించి సాక్సం కొయిపారి. ");
INSERT INTO rei_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","మీ తొముకు సొత్తొ కొయిలందరె సత్రుయీంచినా? ");
INSERT INTO rei_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","తంకె తొం మేలు కోరికిరి ఆసక్తి సంగరె వెంటాడిలాలింకెనింతె. తొమ్మాక తంకు పొచ్చాడె జెమ్మాసిబులికిరి తొముకు పొదురుకు వొంకిదీతె దిగిలీసె. ");
INSERT INTO rei_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","మీ తొం పక్కరె తల్లబెల్లెమాత్రమాకనీకిరి కెబ్బుకు బొల్లెవిసయోనెరె ఆసక్తిగా రొవురొ బొల్టాక. ");
INSERT INTO rei_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","మో సన్నిపిల్లానె, క్రీస్తు స్వరూపము తొం బిత్తరె దిగదిల్లజాంక తొం గురించి ఇంకామెత్తె ప్రసవవేదన కలిగిలీసి. ");
INSERT INTO rei_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","తొం గురించి మెత్తె కిచ్చీతోచిలీని. మీ ఉంచినాక తొం మొజుకు అయికిరి ఇంగుటెపనికిరి తొం సంగరె కొతలగిమాసిబులిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","దర్మసాస్త్రముకు లోబొడికిరి తమ్మాసిబులిగిల్లాలింకే, మెత్తెకోండి. తొమె దర్మసాస్త్రముకు సునిలీసొనింతోనా? ");
INSERT INTO rei_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","దాసి వల్లరె జొనె, స్వతంత్రరాలు వల్లరె జొనె, దీలింకె పోనె అబ్రాహాముకు కలిగిసె బులికిరి రాసికిరి అచ్చినీనా? ");
INSERT INTO rei_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ఈనె దాసివల్లరె జొర్నైలాట దే రీతిగా జొర్నైసి. స్వతంత్రురాలుకు జొర్నైలాట వాగ్దానం ద్వారా జొర్నైసి. ");
INSERT INTO rei_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ఏ సంగతీనె అలంకార రూపముగా కొయిపారొ. ఏ తిల్డ్రలింకె దీట నిబందనలైకిరి అచ్చె. తాండ్రె గుటె సీనాయి పర్వతొకు సంబందించికిరి బానిసత్వంరె రొయితందుకు పిల్లానుకు బేయిసి. యెయ్యె హాగరు. ");
INSERT INTO rei_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","ఏ హాగరు అరేబియా ప్రాంతంరె తల్లా సీనాయి పర్వతమాక. ప్రస్తుతం ఉంచినె తల్లా యెరూసలేము సడరొ పిల్లానెసంగరంకా బానిసత్వంరె అచ్చి. గనక సే నిబందంన సడకు పోలికగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ఈనె ఉంపరె తల్లా యెరూసలేము స్వతంత్రముగా అచ్చి. సడ అముకు మా. ");
INSERT INTO rei_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","సడకు “పిల్లానుకు నాబేయిలా గొడ్డింటా ఆనందించు,” బేయితె బొత్తానె నాయిలంటా, బొట్ట దొందరానె దొందరా; క్యాకిరిబుల్నే గొయిత రొల్లాటరొ పిల్లానెకన్నా గొయిత నీలాటరొ పిల్లానె బడేలింకె అచ్చెబులి రాసికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ఉంచినె తొమె మో జట్టుకారీనె, అమంకా ఇస్సాకుపనికిరి వాగ్దానం వల్లరె జొర్నైలా పిల్లానైకిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","సెత్తెలె దే ద్వారా జొర్నైలాట ఆత్మ ద్వారా జొర్నైలాటకు క్యాకిరి హింసించిసో ఉంచినంకా సాకిరాక జరిగిలీసి. ");
INSERT INTO rei_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ఈనె యెడ గురించి లేకనం కిరకొయిలీసి? “దాసికి తా పోకు గొడ్డిదె దాసి పో స్వతంత్రురాలురొ పో సంగరె వారసుడు ఈకిరి తన్ని.” ");
INSERT INTO rei_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","సడవల్లరె మో జట్టుకారీనె, అమె స్వతంత్రురాలురొ పోనాక గని దాసిరొ పోనెనింతొ. ");
INSERT INTO rei_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","స్వతంత్రంగా రొయితందుకాక క్రీస్తు అముకు చొడిపించిసి. గనక, తొమె స్తిరంగా టారికిరి, ఇంకా బానిసత్వం బుల్లా కాడితొల్లె చిక్కితెనాండి. ");
INSERT INTO rei_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","దిగోండి; తొమె సున్నతి పొందినె క్రీస్తు వల్లరె కిచ్చీప్రయోజనం నీబులికిరి పౌలుబుల్లా మియ్యి తొముకు కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","సున్నతి పొందిలా ప్రతిమనమ దర్మసాస్త్రమల్లా పాటించిమాసిబులికిరి మీ యింకా గట్టిగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","తొంబిత్తరె దర్మసాస్త్రం వల్లరె నీతిమంతునెగా ఈవాసిబులిగిల్లాలింకె కేసెవొ తంకె క్రీస్తుతీకిరి బొత్తిగా వేరైజీకిరచ్చె, క్రుప తీకిరి పొదురుకు బాజీసె. ");
INSERT INTO rei_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","క్యాకిరిబుల్నే, అమె విస్వాసం వల్లరె న్యాయం కలుగుసిబుల్లా నిరీక్సన సంగరె ఆత్మద్వారా ఎదురు దిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","యేసు క్రీస్తురె ఏకమైవురొ వల్ల సున్నతి పొందినన్నా కిచ్చినీ, నాపొందినన్నా కిచ్చీనీ, ఈనె ప్రేమసంగరె పైటికొరిలా విస్వాసమాక ముక్యం. ");
INSERT INTO rei_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","తొమె బొల్లాక దోండిలీసొ. సత్యముకు నాఅనుసరించికుంటా తొముకు కేసె ఆపిసె? ");
INSERT INTO rei_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ఏ ప్రేరన తొముకు డక్కిలా పురువు కే ఆటంకము వల్లరె కలిగిలాని. ");
INSERT INTO rei_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","పులిసిల పిండి కుండె ఈనన్నా ఉండల్లా పుల్ల కొరిపీవొ. ");
INSERT INTO rei_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","తొమె కెత్తెమాత్రం వేరేగా ఆలోసించినింతొబులికిరి ప్రబువురె తొం గురించి మీ గట్టిగా నమ్మిలించి. తొముకు కలవరం లొగిలాట కేసైనను సరాక సెయ్యె తగిల సిక్స అనుబవించుసి. ");
INSERT INTO rei_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","మో జట్టుకారీనె, సున్నతి పొందిమాసిబులి మీ ఇంకా ప్రకటంచితన్నే ఉంచినెకంకా కైంకి హింసించబొడిలించి? సిలువకు గురించి అబ్యంతరముకు సున్నతి కడిపీలీసి నీనా? ");
INSERT INTO rei_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","తొముకు అబ్యంతరం పరిచిలాలింకె తంకు తంకెక అనిపీగివురొ బొల్ట. ");
INSERT INTO rei_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","మో జట్టుకారీనె, తొమె స్వతంత్రులుగా రొయితె పురువు తొముకు డక్కిసి. ఈనె సే స్వతంత్రముకు దేరొ ఆసానెకు ఆదారం నాకొరిగీకిరి, ప్రేమ సంగరె జొనుకు జొనె సేవ కొరిగీండి. ");
INSERT INTO rei_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","దర్మసాస్త్రమల్లా “తో పనికిరాక తో పక్కారెలింకు ప్రేమించు” బులికిరి గుట్టె ఆజ్ఞరె సంపూర్నమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ఈనె తొమె జొనుకు జొనె కమిడిగీకిరి కైపీనె జొను వల్లరె జొనె బొత్తిగా నసించుజెవ్వొకీవో దిగ్గునొండి. ");
INSERT INTO rei_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","మీ కొయిలాట కిరబుల్నే ఆత్మద్వారా సలుగునొండి. సెత్తెలె తొమె దేరొ ఆసానెకు నెరవేర్చినింతొ. ");
INSERT INTO rei_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","దే ఆత్మకు ఆత్మ దేకు యిరోదంగా జింకుతోసి. ఎడానె గుటెకు గుటె వ్యతిరేకంగా అచ్చె. గనక తొమె కిర కొరివాసి బులి నిచ్చయించిగిచ్చొ సడానె కొరినింతొ. ");
INSERT INTO rei_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","తొమె ఆత్మ సంగరె సలిగిన్నే దర్మసాస్త్రముకు లోబొడిలాలింకెనింతొ. ");
INSERT INTO rei_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","దేకు సంబందించిలా కార్యానె స్పస్టంగా అచ్చె. సడానె కిరబుల్నే; జారత్వము, అపవిత్రత, కామవికారం, ");
INSERT INTO rei_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","విగ్రహరాదన, మాయకొతానె, ద్వేసం, కలహము, ఈర్స్య, రగ్గొ, మత్సరమునె, క్రోదమునె, కక్సానె ");
INSERT INTO rei_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","బేదమూనె, విమతానె, అసూయానె, గోల కొరిలా నచ్చొ గిత్తోనె ఎడానల్ల. ఎడానె గురించి మీ అగరె కొయిలా పనికిరాక ఎడానుకు కొరిలాలింకె పురువురొ రాజ్యొకు జెన్నారె బులికిరి తొముకు స్పస్టంగా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ఈనె ఆత్మ పలాలు కిరబుల్నే; ప్రేమ, ఆనందం, సమాదానం, దీర్గసాంతం, దయాలత్వం, బొల్టతనం, విస్వాసం, ");
INSERT INTO rei_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","సాత్వికము, ఆసానిగ్రహం. ఏటానెపనాంచకు విరోదమైలా నియమము కిచ్చీనీ. ");
INSERT INTO rei_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","క్రీస్తుయేసు సంబందీనె దేకు, సడరో దురాసానెకు సిలువ పొగిపీసె. ");
INSERT INTO rei_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","అమె ఆత్మ ద్వారా జీకిరి తన్నె సే ఆత్మ ద్వారా సలిగిమ్మా. ");
INSERT INTO rei_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","జొనుకు జొనె అహంబావం నీకుంటా కొలీనెనీకుంటా అసూయ నీకుంటా రొమ్మండి. ");
INSERT INTO rei_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","మో జట్టుకారీనె, తొం బిత్తరె జొనె కే తప్పునాకొరుకుంటా మిలిజిన్నే తొం బిత్తరె ఆత్మసంబందమైలాలింకె కేసన్నా, సాకిరి తప్పునాకొరుకుంటా బొల్టమనుసు సంగరె సే మనమకు బొల్టబట్టుకు దన్నైమాసి. తొమ్మంకా సడకు నాలొంగుకుంటా తాసొ. ");
INSERT INTO rei_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","జొనురొ బారముకు జొనె బరించిగీండి. సాకిరి కొరికిరి క్రీస్తు నియమముకు పూర్తిగా నెరవేర్చొండి. ");
INSERT INTO rei_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","కేసన్నా కిచ్చీనీకుంటాతైకిరి తాకు సెయ్యాక గొప్పీటబులికిరి బచ్చిగిన్నే, తాకు సెయ్యాక మోసం కొరిగిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ప్రతీ మనమ సెయ్యె కొరితల్లా పైటికి పరీక్సించికిరి దిగ్గిమ్మాసి; సెత్తెలె పొదరెలింకె విసయంరెనీకిరి తావల్లరాక తాకు అతిసయం కలుగుసి. ");
INSERT INTO rei_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ప్రతీ మనమ తా గొబిరి సెయ్యాక బరించిగిమ్మాసినీనా? ");
INSERT INTO rei_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","వాక్కు ఉపదేసము పొందిలా మనమ ఉపదేసించిలాటకు బొల్టపదార్దాలుబిత్తరల్లా బాగం దిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","మోసమైతెనా, పురువుకు ఎక్కిరించినారొ; మనమ కే విత్తోనె జల్లినే సే పచ్చాక కట్టుసి. ");
INSERT INTO rei_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","క్యాకిరిబుల్నే తా దేరొయిస్టప్రకారంగా విత్తోనె జల్లిలాట తా దేదీకిరి నాసనం బుల్లా పచ్చకు కట్టుసి, ఆత్మద్వారా విత్తోనె జల్లిలాట ఆత్మద్వారా నిత్యజీవం దిల్లా పచ్చకు కట్టుసి. ");
INSERT INTO rei_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","అమె మేలు కొరిలాటబిత్తరె నా యిసిగ్గీకుంటా రొమ్మండి. అమె నాఅలిసిజీకుంటా మేలు కొర్నే, తగిల కల్రె పచ్చ కట్టుంచొ. ");
INSERT INTO rei_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ఈనె అముకు కలొ మిల్లాబెల్లల్లా సొబ్బిలింకూ, మరీ ముక్యంగా సంగమురొ విస్వాసునెకు మేలు కొరిమండి. ");
INSERT INTO rei_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","మో సొంత అత్తోనె సంగరె తొముకు కెత్తొ బొట్టక్సరాలు సంగరె రాసిలించో దిగొండి. ");
INSERT INTO rei_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","దే విసయంరె బొల్లె దిగదిమ్మాసిబులికిరి కోరిగిల్లాలింకె కేసెవో, తంకె క్రీస్తు సిలువ విసయంరె హింస నాపొడుకుంటా రొయితందుకాక సున్నతి పొందిమాసిబులికిరి తొముకు బలవంతం కొరిలీసె. ");
INSERT INTO rei_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ఈనె తంకె సున్నతి పొందిలాలింకె ఈనన్నా దర్మసాస్త్రముకు పాటించినింతె; తంకె తొం దే విసయంరె గొప్పానె కొయిగినితె కోసం తొమె సున్నతి పొందిమాసిబులి కోరిలీసె. ");
INSERT INTO rei_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ఈనె అం ప్రబువైల యేసుక్రీస్తు సిలువ వల్లరె తప్ప మరి కేటగురించి అతిసయించువురొ మెత్తె దూరుయివాసి; సడవల్లరె మెత్తె లొకొ, లొకొకు మియ్యి సిలువ పొగ్గించొ. ");
INSERT INTO rei_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","నువస్రుస్టి పొందువుర్రాకగని సున్నతి పొందువుర్రె నాపొందువుర్రె కిచ్చీనీ. ");
INSERT INTO rei_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","యే పద్దతి చొప్పురె చలిలాలింకల్లా బుల్నే పురువురొ ప్రజానెకు సాంతి క్రుప కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","మీ యేసురొ గుర్తునె మో దేరె పిందిగించి గనక ఎట్టెతీకిరి కేసె యీనెనూ మెత్తె హింసించితేనాండి. ");
INSERT INTO rei_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","అన్నబయినె అప్పబొయినినె, అం ప్రబువైలా యేసుక్రీస్తు క్రుప తొం సంగరల్లా తమ్మాసి. ఆమేను.");
INSERT INTO rei_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","పురువురొ యిస్టముచొప్పురె క్రీస్తుయేసురొ అపోస్తులుడైలా పౌలు ఎపెసురె రొల్లా పురువురొ ప్రజానెకు క్రీస్తుయేసురె విస్వాసం రొల్లాలింకు సుబం కొయికిరి రాసిలాట. ");
INSERT INTO rei_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","అం బోయీలా పురువుతీకిరి ప్రబువైలా యేసుక్రీస్తు తీకిరి తొముకు క్రుపా, సమాదానము కలిగివాసిబులి. ");
INSERT INTO rei_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","అం ప్రబువైలా యేసుక్రీస్తురొ బోయీలా పురువు స్తుతింపబొడిమాసి. సెయ్యె క్రీస్తురె పరలోక విసయానెరె ఆత్మసంబందమైలా సొబ్బి ఆసీర్వాదానె అముకు అనుగ్రహించిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","అమె తా అగరె పవిత్రంగా, దోసం నీకుంటా రొమ్మాసిబులి జగత్తుకు పునాది నాపొగిలా అగుంతాక, సెయ్యె ప్రేమసంగరె క్రీస్తురె అముకు ఏర్పాటు కొరిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","తా యిస్టప్రకారమైలా దయాసంకల్పము చొపురె, యేసుక్రీస్తు ద్వారా తాకు పిల్లానె యీకిరి రొయితందుకాక, అముకు అగుంతాక తా కోసం నిర్నయించిగీకిరి, ");
INSERT INTO rei_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","సడుకాక తా ప్రియమైలా పో ద్వారా సెయ్యె సుచ్చరాక అముకు అనుగ్రహించిలా తా క్రుప మహిమకు కీర్తి చెల్లించిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","పురువురొ మహా క్రుప వల్లరాక, తా ప్రియమైలా పో యేసు రొగొతొ ద్వారా అముకు విడుదల, పాపక్సమాపన కలిగిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","అముకు సంపూర్నమైలా జ్ఞానవివేకము కలిగితె సేక్రుపకు అమంపరె విస్తరించిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","కలొ సంపూర్తయిజిల్లాబెల్లె ఈవలిసిలా ఏర్పాటు వల్లరె, పురువు తా దయాసంకల్పము చొపురె తా చిత్తము గురించి నుచ్చిదిల్లా ఉద్దేసము అముకు తెలియపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","యే సంకల్పమువల్లరాక పురువు పరలోకంరె తల్లాంచ ఈనన్నా, బూమంపరె తల్లాంచ ఈనన్నా, సొబ్బిటికు క్రీస్తురె సమకూర్చిమాసిబులి సెయ్యె తాబిత్తరె ముండొగా నిర్నయించిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","పురువు తాకు ఇస్టమైలా నిబందంన దీకిరి అముకు బచ్చిగీకిరి, వారసునెగా కొరిసి. సెయ్యె తా ఇస్టం చొప్పురె సొబ్బిపైటీనెకొరిలీసి. ");
INSERT INTO rei_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ఈనె క్రీస్తుకు అగుంతా నమ్మిలా అం ద్వారా పురువురొ మహిమకు గొప్ప కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","తొమ్మంకా సత్యవాక్కుకు బుల్నే రక్సన సువార్త సునికిరి, క్రీస్తురె నమ్మకం రొగ్గిచ్చొ. సడుకాక పురువు దిల్లా కొతా వల్లరె పరిసుద్దత్మసంగరె తొమంపరె ముద్రించబొడిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","పురువురొ మహిమకు కీర్తి కలిగిమాసిబులి సెయ్యె సంపాదించిగిల్లా మనమానుకు విడుదల కలిగిలాదాకా ఆత్మ అం వారసత్వముకు హామీగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","యే కారనం చొపురె ప్రబువైలా యేసురె తొం విస్వాసం గురించి పురువురొ ప్రజానె గురించి తొమె దిగిపించిలా ప్రేమ గురించి మియ్యి సునిలాబెల్లెతీకిరి ");
INSERT INTO rei_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","తొం విసయమురె నామానుకుంటా మో ప్రార్దనల్రె పురువుకు క్రుతజ్ఞత చెల్లించిలించి. ");
INSERT INTO rei_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ఈనె అం ప్రబువైలా యేసుక్రీస్తు పురువు, మహిమ గల్లా బో, తా జ్ఞాన ప్రత్యక్సతలుగల్లా మనుసుకు ఆత్మ తొముకు దిమ్మాసిబులి ప్రార్దించిలించి. ");
INSERT INTO rei_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","తొం మనోనేత్రాలూనె వెలిక్కిరి, అం డక్క గురించి నిరీక్సన కెటువంటిటవో, తా ప్రజానెరె తా మహిమగల్లా వారసత్వం కెత్తె ఐస్వర్యమో తొమె గ్రహించిమాసిబులి మో ప్రార్దన. ");
INSERT INTO rei_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ఈనె విస్వసించిల అంబిత్తరె పైటికొరిల గొప్ప సక్తి యెడాక సడ గొప్ప సక్తి అంబిత్తరె పైటికొరిలీసి, ");
INSERT INTO rei_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","సే సక్తి వలరాక క్రీస్తుకు మొర్నొదీకిరి ఉటిదీకిరి ఇంకా పరలోకంరె తా బత్తొకైలాడుకు బొసరదీగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","క్రీస్తురొ సొబ్బిఆదిపత్యం, అదికారం, ప్రబావం, ప్రబుత్వంకన్నా యే యుగంరె గానీ, అయితల్లా యుగంరె గానీ నాతల్లా సొబ్బినానెకన్నా బడే గొప్పగా తాకు హెచ్చించిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","తర్వాతరె పురువు సొబ్బిటుకు క్రీస్తు గొడ్డోనె తొల్లె రొక్కిరి, సంగముబిత్తరె సొబ్బిటంపరె తాకు ముండొగా నియమించిసి. ");
INSERT INTO rei_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","యే సంగం తా దే, సొబ్బిటికు సొబ్బివిదాలుగా పూరదీతల్లా పురువు పరిపూర్నతైకిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","అగరె తొమె అతిక్రమాల్రె పాపాల్రే ఆత్మీయతరె మొరిజీకిరి తల్లాపని అచ్చొ ");
INSERT INTO rei_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","సెల్లె పూర్వకలొరె తొమె యే లొకొ పద్దతీనుకు వాయుమండలసంబందమైలా అదిపతికి, బుల్నే అవిదేయతరె పైటికొరితల్లా ఆత్మకు అనుసరించికిరి చలిగిచ్చొ. ");
INSERT INTO rei_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","సొత్తాక అగరె అమల్లా యే అవిస్వాసినె సంగరాక అమె దేరో దుస్టస్వబావం అనుసరించికిరి జీంచొ. దేకు మనుసుకు నచ్చిలాపనికిరి కొరుకుంటా, పొదర్లింకెపనికిరి స్వబావసిద్దంగా పురువురొ రగ్గొకు కారకునెగా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ఈనె పురువురొ మహాకరున ఇంకా గొప్ప ప్రేమ తవ్వురొ వల్లరె, ");
INSERT INTO rei_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","అమె అం అతిక్రమానె సంగరె ఆత్మీయంగా మొరికిరితల్లాబెల్లె, పురువురొ క్రుపసంగరాక తొముకు రక్సన దీకిరి క్రీస్తుద్వారా అముకు జీపించిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","పురువు క్రీస్తుయేసురె అమె ఏకమైవురొ వల్లరె అముకు తాసంగరంకా ఉటిదీకిరి, పరలోకంరె తాసంగరెపాటు సింహసనం ఉంపరె బొసరదీగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","అయితల్లా యుగాల్రె క్రీస్తు యేసురె పురువు కొరిలా ఉపకారం ద్వారా అత్యదికమైలా తా క్రుపాసమ్రుద్ది అముకు దిగదీతే సెయ్యె యాకిరి కొరిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","తొమె విస్వాసం ద్వారా క్రుపసంగరాక రక్సన పొందిగిచ్చొ. యెడ తొము వల్లరె కలిగిలాటని, పురువాక బహుమానంగా దీసి. ");
INSERT INTO rei_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","సడ అం పైటీనె వల్లరె కలిగిలాటని గనక కేసే గొప్పానె కొయిగిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","అముకు పురువురొ స్రుస్టిగా, పురువు అగరాక సిద్దపరిచిలా బొల్టపైటీనె కొరితె కోసమాక అముకు క్రీస్తు యేసురె స్రుస్టించిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ఈనె పూర్వం తొమె దేకుఅనుసరించిలా పొదరెలింకెనె. “దేద్వారా మనమానె అత్తరె సున్నతి పొందిలా యూదునె” తొముకు “సున్నతి నీలాలింకె” బులి డక్కితవ్వె బులి గుర్తించిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","సే కలొరె తొమె క్రీస్తుకు ఏరుగా అచ్చొ. ఇస్రాయేలురె పౌరసత్వం నీలాలింకెపనికిరి వాగ్దాన నిబందనానెకు పొదర్లింకెపనికిరి, నిరీక్సన నీలాలింకెపనికిరి, లొకొరె పురువు నీలాలింకెపనికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ఈనెను అగరె పురువుకు దూరుగా తల్లా తొమె ఉంచినె క్రీస్తు యేసురె క్రీస్తు రొగుతొ ద్వారా పురువుకు పక్కరైసొ. ");
INSERT INTO rei_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","సెయ్యాక అముకు సాంతి. సెయ్యె యూదునెకు యూదునెనీలాలింకు ఏకం కొరిసి. అం దీలింకు మొజిరె విరోదంబుల్లా అడ్డు గోడకు తా దే ద్వారా కూలమరిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","యాకిరి సే ఉబయులు తీకిరి గుటె నో ప్రజకు స్రుస్టించితే విదులూనె, ఆజ్ఞానె తల్లా దర్మసాస్త్రముకు రద్దు కొరిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","తంకెబిత్తరె రొల్లా ద్వేసముకు క్రీస్తుసిలువ మొర్నొ ద్వారా సత్రుత్వముకు కడిపీకిరి, అంకు బయులుకు పురువు సంగరె ఏకం కొరికిరి మిసితె సాంతి కొరిమాసిబులి యాకిరి కొరిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","సడకాక యేసు అయికిరి పొదరెలింకెగా రొల్లా తొముకు పక్కరెగా రొల్లా తంకు సమాదాన సువార్త ప్రకటించిసి. ");
INSERT INTO rei_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","యేసు ద్వారాక తొమె అమ్మె గుట్టాత్మ ద్వారాక బోపక్కు చేరిగీపారొ. ");
INSERT INTO rei_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ఈనె పొదర్లింకైలా తొమె ఉంచినె తీకిరి పొదర్లింకె పొదరొదెసొలింకెనింతొ. పురువురొ మనమానె సమానమైలా పౌరులునె, పురువురొ కుటుంబం మనమానె. ");
INSERT INTO rei_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","క్రీస్తు యేసాక ముక్యమైలా మూలపొత్రొగా రొయికిరి అపోస్తులునె ప్రవక్తానె పొగిలా పునాదంపరె బందికరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","తా వల్లరాక తా కుటుంబం బుల్లా బంద బొల్లే అమిర్చికిరి, ప్రబువు కోసం పవిత్రమైలా దేవాలయంగా రూపొందుకుంటా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","తాబిత్తరె తొమ్మంకా ఆత్మరె పురువుకు నివాసంగా రొయితె ఏకమైలీసొ. ");
INSERT INTO rei_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","యే కారనం వల్లారాక యూదునెనీలాలింకె తొముగురించి క్రీస్తు యేసురో కైదీయైలా పౌలు బుల్లా మియ్యి ప్రార్దించిలించి. ");
INSERT INTO rei_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","తొముకోసం మెత్తె అనుగ్రహించిలా పురువురొ క్రుపవిసయమైలా తొం కోసం ప్రత్యేకమైలా బాద్యత దీసిబులి తొమె సునికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","పురువు నుచ్చిదిల్లా తా ప్రనాలిక మెత్తె తెలియపర్చిసి. అడ గురించి తొముకంకా తెలిసిలా సంగతి స్పస్టంగా రాసించి. ");
INSERT INTO rei_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","మీ రాసిలాంచకు తొమె చదివినె క్రీస్తు గురించి నుచ్చిదిల్లా సంగతీనె అర్దం కొరిగిపారొ. ");
INSERT INTO rei_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","యే నుచ్చిదిల్లా ప్రనాలిక ఉంచినె ఆత్మ ద్వారా పురువురొ పవిత్రమైలా అపోస్తులింకు ప్రవక్తానెకు వెల్లడికొరిలాపనికిరి పూర్వదినోనెరొ మనమానుకు బయలుపర్చిలాని. ");
INSERT INTO rei_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","యే నుచ్చిదిల్లా ప్రనాలిక కిడబుల్నే, సువార్త ద్వారా అన్యజనులంకా యూదునె సంగరె క్రీస్తు యేసురె సమానమైలా వారసులూనె, గుట్టె దేబిత్తరొ బాగాలునె, వాగ్దానంరె పాలిబాగస్తునె ఈకిరి అచ్చె బుల్లాటాక. ");
INSERT INTO rei_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","మియ్యి సే సువార్తకు పైటిమనమైంచి. పురువురొ సక్తిసంగరె తా క్రుప వల్లరాక యెడ సాద్యమైసి. ");
INSERT INTO rei_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","పురువురొ మనమానె సొబ్బిలింకెబిత్తరె అత్యల్పుడైలా మెత్తె అమె ఊహించినార్లా క్రీస్తు ఐస్వర్యముకు యూదునెనీలాలింకె సువార్త ప్రకటంచితె అవకాసం దీసి. ");
INSERT INTO rei_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","సొబ్బిటికి స్రుస్టికర్తైలా పురువురె అనాది తీకిరి నుచ్చుకిరి తల్లా సే నుచ్చిదిల్లా ప్రనాలికకు సొబ్బిలింకు వెల్లడి కొరితె పురువు సే క్రుపకు మెత్తె అనుగ్రహించిసి. ");
INSERT INTO rei_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","తా నుచ్చిదిల్లా ప్రనాలికరొ జ్ఞానం సంగము ద్వారా వాయుమండలమురొ ప్రదానులునె అదికారినె తెలిసిగిమ్మాసిబులి పురువురొ ఉద్దేసం. ");
INSERT INTO rei_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","సడ అం ప్రబువైలా క్రీస్తుయేసురె పురువు కొరిలా తా నిత్యమైలా ప్రనాలిక. ");
INSERT INTO rei_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","క్రీస్తంపరె అముకురొల్లా విస్వాసం వల్లరాక తాదీకిరి అముకు దైర్యం, పురువురొ సన్నిదికు ప్రవేసించితె స్వేచ్చ కలిగిసి. ");
INSERT INTO rei_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","సడవల్లరె తొముకోసం మెత్తె కలిగిలా హింసానె దిక్కిరి తొమె అదైర్యపొడితెనాండి. యెడానె తొముకు పైటికైతె కారనాలుగా తాసి. ");
INSERT INTO rei_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","యే కారనం వల్లరె బో అగరె మీ మోకాల్లు పొక్కిరి ప్రార్దించిలించి. ");
INSERT INTO rei_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","కైంకిబుల్నే పరలోకంరె, బూమంపరె తల్లా ప్రతీ కుటుంబం తా నారాక అంగీకరించబొడిలీసి. ");
INSERT INTO rei_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","పురువు తా బిత్తరె రొల్లా తా ఆత్మ ద్వారా తా గొప్ప మహిమకు తొముకు దీకిరి సక్తిసంగరె తొముకు బలపర్చుబులి మగిలించి. ");
INSERT INTO rei_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ఈనె క్రీస్తు తొం హ్రుదయాల్రె విస్వాసం ద్వారా నివసించిమాసి. తొమె తా ప్రేమరె సెరోనె సొచ్చికిరి స్దిరంగా రొమ్మాసి యెడాక మో ప్రార్దన. ");
INSERT INTO rei_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","సడవలరె పురువురొ మనమానె సొబ్బిలింకుసంగరె మిసికిరి క్రీస్తుప్రేమరె వొంచు, వెడల్పు, లోతు, ఎత్తు బడే పూర్తిగా గ్రహించిమాసి బులి, ");
INSERT INTO rei_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","జ్ఞానముకు మించిలా క్రీస్తు ప్రేమకు తెలిసిగిత్తే తగిలా సక్తి పొందివాసిబులి ఇంకా పురువురొ పోలికకు అయిమాసి బులి మో ప్రార్దన. ");
INSERT INTO rei_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","అం బిత్తరె పైటికొరిలా తా సక్తి ప్రకారం అమె మగిలాటకన్నా, ఊహించిలాటకన్నా బడే బూతు కొరిపారిలా సక్తి గలిగిలా, ");
INSERT INTO rei_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","పురువుకు, సంగమురె క్రీస్తు యేసురె తరతరమునెకు నిత్యము మహిమ కలిగిమాసి. ఆమేను. ");
INSERT INTO rei_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ఈనె ప్రబువు కోసం కైదీయైలా మియ్యి తొముకు బతిమాలిగిల్లాట కిడబుల్నే పురువు తొమె డక్కిలా డక్కకు తగిలపనికిరి జీవించండి ");
INSERT INTO rei_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ప్రేమసంగరె జొనుకు జొనె సహించిగీకుంటా సంపూర్న వినయం, సాత్వికం, సమాదానం కలిగికిరి రోండి, ");
INSERT INTO rei_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","సమాదానం బుల్లా బందందీకిరి ఆత్మకలిగించిలా ఐక్యతకు కాపాడిగీకుంటా స్రద్ద కలిగికిరి సలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","దే గుట్టాక, ఆత్మ గుట్టాక సాకిరాక పురువు తొముకు డక్కిలా డక్క గుట్టాక నిరీక్సన గుట్టాక ");
INSERT INTO rei_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ప్రబువు జొన్నాక, విస్వాసం గుట్టాక. బాప్టీసం గుట్టాక. ");
INSERT INTO rei_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","సొబ్బిలింకు బో ఈలా పురువు జొన్నాక. సెయ్యె సొబ్బిలింకన్నా ఉంపరె తల్లాట, సొబ్బిలింకె బిత్తరె అచ్చి సొబ్బిలింకె ద్వారా పైటి కొరిపించిలీసి. ");
INSERT INTO rei_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ఈనె క్రీస్తు అనుగ్రహించిలా క్రుప నప్పకు దరికిరి అం బిత్తరె సొబ్బిలింకూ వరం దీసి. ");
INSERT INTO rei_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","యెడ గురించాక సెయ్యె ఆరోహనమైలాబెల్లె బందీనుకు చెరబిత్తురుకు కొడిబాజేసిబులి తా మనమానుకు బహుమానాలు దీసిబులి లేకనంరె కొయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","“ఆరోహనమైజేసి” బుల్లా కొతకు అగరె సెయ్యె బూమి తొల్లుకు వొల్లిసి బులికిరంకా అర్దం దిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","సాకిరి వొల్లిలాటాక సెయ్యాక సొబ్బిటుకు వ్యాపించికిరి, మెగోనె మహా మెగొనల్లా దాటికిరి, బడే ఉంపురుకు ఎక్కికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","సెయ్యె వరమూనె దీకిరి కుండెలింకు అపోస్తునెగా, కుండెలింకు ప్రవక్తానెగా, కుండెలింకు సువార్తకులుగా, యింకుండెలింకు జొగులోనెగా, బొదకులుగా నియమించిసి. ");
INSERT INTO rei_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","సడద్వారా విస్వాసునెకు సేవా కార్యమునెకు సిద్దం కొరిమాసిబులి క్రీస్తు దేరె క్సేమాబివ్రుద్ది కలిగిమాసిబులి సెయ్యె యాకిరి కొరిసి. ");
INSERT INTO rei_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ఇంకా అమల్లా విస్వాసంరె, పురువురొ పో గురించైలా జ్ఞానంరె గుట్టాకబావం కలిక్కిరి రొమ్మాసిబులి క్రీస్తు కలిక్కిరి రొల్లా పరిపూర్న పరినతికి సమానమైలా వ్రుద్ది చెందిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","సెత్తెలె అమె పసిపిల్లానె పనికిరి నీకుంటా మనమానె కపటం సంగరె, కుయుక్తి సంగరె తప్పు బట్టొకు జింకిమాసిబులి కల్పించిగిల్లా సొబ్బిరకాల బోదానె బుల్లా కదిలితల్లా అలానె, బా మడ్డోనుకు పిట్టిగీకిరి నాబాజీకుంటా రొమ్మా. ");
INSERT INTO rei_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","సడకు బదులుగా ప్రేమ సంగరె సత్యమాక కొయికుంటా సొబ్బి విసయాల్రె అముకు సిరస్సు యీకిరి తల్లా క్రీస్తు పనికిరి బొడుమా. ");
INSERT INTO rei_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","సెయ్యాక. తా దీకిరి సంగం బుల్లా దే బొల్లే అమిర్చికిరి, తాండ్రెతీకిరి ప్రతీ బాగాలూనె కీల్లు సంగరె మిసికిరి రొయికిరి, సడ తా సక్తికొద్దీ పైటి కొరిలాబెల్లె ప్రేమరె సడకు క్సేమాబివ్రుద్ది కలిగిలాపనికిరి అబివ్రుద్ది చెందుసి. ");
INSERT INTO rei_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ఈనె తొమె ఎట్టెతీకిరి యూదునెనీలాలింకె సలిగిల్లాపనికిరి సలినాసిబులి ప్రబువు నారె తొముకు హెచ్చరించిలించి. ");
INSERT INTO rei_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","కైంకిబుల్నే తంకె మనుసూనె అందకారమైజీకిరి తంకె హ్రుదయం కటినమైజిల్లందరె తంకె అజ్ఞానం వల్లరె సలిగీకిరి పురువురొ జీవంతీకిరి వేరైజీసె. ");
INSERT INTO rei_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","తంకె లజ్జొనీకుంటా అత్యాస సంగరె బడేరకానెగా అపవిత్రమైలా పైటీనె కొరితె కోసం తంకె తంకాక కామవికారాలుకు ఒప్పకొయిగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ఈనె తొమె క్రీస్తు గురించి సుగ్గిల్లాట యెడనీ. ");
INSERT INTO rei_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","యేసురె సత్యం గురించి తల్లాట తల్లా పనికిరాక తొమె ఉపదేసం పొందిసొ. ");
INSERT INTO rei_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ఈనె తొమె అగరె జీవితముకు సంబందించిలాట, మోసకరమైలా దురాసవలరె చెడిజేకిరితల్లా తొం పుర్నస్వబావముకు సడదేండి. ");
INSERT INTO rei_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","తొం అంతరంగంరొ మనుసూనె నో ఈకిరి ఈవాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","నీతిరె యదార్దమైలా పవిత్రత కలిక్కిరి పురువు పొలికగా కొరిలా నో స్వబావంకు పిందిగివాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","అమె క్రీస్తు దేరె జొనుకు జొనె అవయవానె పనాలింకె. గనక తొమె సొరొకొతానె మానికిరి తొం సంగరొ మనమదీకిరి సత్యమాక కొయిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","రగొ పొడువొచ్చు గని సడ పాపముకు బట్టొకడినాసి. తొం రగొ బెల్లొ గుమ్మిలాదాకా రొన్నాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","అపవాదికు చోటు దీతేనాండి ");
INSERT INTO rei_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","చొరొపైటి కొరితల్లాట సడకు సడదిమ్మాసి. తా అత్తోనె సంగరె కొస్టొపొడికిరి పైటికొరికిరి అవసరం రొల్లాలింకు సాయం కొరిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","తొం తుండొతీకిరి చెడుకొతానె అయినాసి. సునిలాలింకు పైటికైలాపనికిరి తంకు అబివ్రుద్ది కలిగిలా కొతానాక కోండి. ");
INSERT INTO rei_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","పురువురొ పవిత్రాత్మకు దుక్కపరిస్తేనా. కైంకిబుల్నే తా నిచ్చయతముద్ర తొం విమోచన దినో దాకా తొమంపరె రోసి. ");
INSERT INTO rei_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","సమస్తమైలా దుస్టత్వం ద్వేసం, రగో, రౌద్రం, అల్లరి, దూసన బుల్లా సడానల్లా సడదేండి. ");
INSERT INTO rei_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","సడకు బదులుగా హ్రుదయంరె కరున కలిక్కిరి జొనంపరె జొనె దయ దిగదేండి. పురువు తొముకు క్యాకిరి క్రీస్తురె క్సమించిసొ సాకిరాక తొమ్మంకా పొదర్లింకు క్సమించిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ఈనె తొమె పురువురొ ప్రియమైలా పిల్లానెపనికిరి తాకు పోలికిరి సలిగీండి ");
INSERT INTO rei_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","క్రీస్తు అముకు ప్రేమించికిరి అముకోసం పురువుకు ఇస్టమైల పరిమలమైలా అర్పనగా, తాకు సెయ్యాక బలిగా అప్పకొయిగిచ్చి. సడపనా ప్రేమకాక తొమ్మంకా కలిక్కిరి రోండి. ");
INSERT INTO rei_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","తొం బిత్తరె దర్నిపైటి, అపవిత్రత, పిసినారితనం, యెడనల్లా తన్నాసి. కనీసం తొమె సే నానైనన్నా టెక్కినాసి. యెడాక పురువురొ మనమానెకు తగిలా ప్రవర్తన. ");
INSERT INTO rei_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","క్రుతజ్ఞత కొతానాక తొం తుండొ సంగరె అయిమాసి గని, అసబ్యమైలా కొతానె, మూర్కమైలా కొతానె, దీట అర్దాలు అయిలా కొతానె తొమె పలికినాసి. యెడానె తొముకు తగినింతె. ");
INSERT INTO rei_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","తొముకు తెలుసు దర్నిపైటిలింకు అపవిత్రమైలాలింకు, విగ్రహారదికులులింకు, అత్యాస కలిగిలాలింకు క్రీస్తుకు, పురువుకు చెందిలా దెసొకు అర్హత నీ. ");
INSERT INTO rei_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","నాపైటికైలా కొతానె కొయిలాలింకు వల్లరె పాడైజీతేనాండి. సడపనాంచ వల్లరె కొతా నాసున్లాలింకంపరకు పురువురొ ఉగ్రత ఆసి. ");
INSERT INTO rei_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","సడకాక తంకు దూరుగా రోండి. ");
INSERT INTO rei_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","అడకగరె కలొరె తొమె వొందారైకిరి అచ్చొ. ఈనె ఉంచినె ప్రబువురె హల్లొ యికిరచ్చొ. హల్లొకు సంబందించిలాలింకె పనికిరి సలిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","కైంకిబుల్నే హల్లొరొ పలం సొబ్బిరకాలుగా బొల్టతనం, న్యాయం, సత్యం దిగదెల్లీసి. ");
INSERT INTO rei_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ఈనె ప్రబువుకు కిడ ఇస్టమో సడ ద్వారాగా సలిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","నాపైటికైలా వొందారొ పైటీనెరె నారొయికుంటా సడానుకు బదులుగా హల్లోరె దన్నెయిండి. ");
INSERT INTO rei_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","కైంకిబుల్నే తంకె రహస్యంగా కొరితల్లా పైటీనె గురించి కొతాలగువురొ కూడా బడే అవమానం. ");
INSERT INTO rei_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ప్రతీ పైటీ హల్లొ సంగరె పొదరకు ఆసి. సాకిరి పొదరెపొడ్లా హల్లొ ప్రతీస్దలంరె సత్యరూపముకు ప్రకాసించుకుంటాక తాసి. ");
INSERT INTO rei_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","సాకిరి పొదరె పొడ్లాట ప్రతీటా హల్లాక. సడకాక, గుమ్మితల్లా తూ ఉటూ మొరిజెల్లాలింకబిత్తరె తీకిరి ఉటూ క్రీస్తు తొ ఉంపరె ప్రకాసించువొ బులి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","తెలివినీలాలింకెపనికిరినీకుంటా తెలివిగా జీతె జాగర్త పొడండి. ");
INSERT INTO rei_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","కలొకు బొల్టపైటీనె కోసం వాడిగీండి. కైంకిబుల్నే దినోనె బొల్టాంచనీ. ");
INSERT INTO rei_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","సడకాక తొమె తెలివినీలాలింకెపనికిరి నా తైకిరి ఈనె ప్రబువు ఇస్టం కిడవో తెలిసిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","మొద్దొ పీకిరి మత్తులైజీతేనాండి. సడ నాసనం కొరుసి. ఈనె సడకు బదులుగా ఆత్మసంగరె పూరికిరి తాండి. ");
INSERT INTO rei_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","గిత్తోనెసంగరె సంగీతం సంగరె ఆత్మ సంబందమైలా గిత్తోనెసంగరె జొనుకు జొనె బలపర్చిగీకుంటా, ప్రబువు గురించి తొమె మనుసూన్రె గైకుంటా కీర్తించొండి. ");
INSERT INTO rei_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","అం ప్రబువైలా యేసుక్రీస్తు నారె సొబ్బిటి గురించి బో ఈలా పురువుకు సొబ్బికల్రే క్రుతజ్ఞతాస్తుతీనె చెల్లించోండి. ");
INSERT INTO rei_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","క్రీస్తు ఉంపరె తల్లా బక్తి సంగరె జొనుకు జొనె లోబొడికిరి తాండి. ");
INSERT INTO rei_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","తిల్డ్రలింకె ప్రబువుకు లోబొడికిరి తల్లాపనికిరాక తంకు గొయితానుకు లోబొడిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","క్రీస్తు సంగముకు కేవిదంగా ముండొ యీకిరి అచ్చో సాకిరాక గొయిత తా నైపొకు ముండొ యీకిరి అచ్చి. తాకు సెయ్యాక సంగంకు రక్సకుడుగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","సంగం క్రీస్తుకు లోబొడిలా పనికిరాక నైపోనె కూడా సొబ్బి విసయాల్రె తంగొయితానుకు లోబొడిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","గొయితానె, తొమ్మంకా సంగముకు క్రీస్తు ప్రేమించికిరి పొర్నొ దిల్లాపనాక తొం నైపోనుకు ప్రేమించిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","యాకిరి కొరికిరి సంగముకు వాక్యంబుల్లా పనిసంగరె దొయికిరి, పవిత్రం కొరిసి, ");
INSERT INTO rei_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","సడకు కలంకమైనా, ముడతలన్నా, సడానె పనాంచ కిచ్చీ నీకుంటా పవిత్రంగా నిర్దోసంగా మహిమైలా పనికిరి తా అగరె తారదీగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","సాకిరాక వొండ్రపోనె కూడా తంక సొంత దేనె పనికిరాక తంక నైపోనుకు ప్రేమించివలిసిలా బాద్యత అచ్చి. తా నైపుకు ప్రేమించిలాట తాకు ప్రేమించిగిల్లాపనికిరాక. ");
INSERT INTO rei_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","కేసే తా దేకు ద్వేసించిగిన్నీ, క్రీస్తు సంగముకు పోసించికిరి సంరక్సించిగిల్లా విదంగా తంకె దే కు దిగుసు. ");
INSERT INTO rei_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","సడకాక అం అల్లా క్రీస్తు దేకు బాగాలైకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","“లేకనానెరె కొయిలాపన యెడవల్లరాక వొండ్రపో తా బోకు మాకు సడికిరి తా నైపుకు హత్తుగునుసి, తంకెదీలింకె గుట్టె దే ఊసె.” ");
INSERT INTO rei_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","యే లోతైలా సత్యం అర్దం కొరిగించి. ఈనె మియ్యి క్రీస్తు గురించి సంగం గురించి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ఈనె తొం బిత్తరె ప్రతీ గొయిత తాకు సెయ్యె కెత్తె ప్రేమించిగిల్లీసో తా నైపొకంకా సాకిరాక ప్రేమించిమాసి. సాకిరాక నైపొ తా గొయితకు గౌరవించిమాసి. ");
INSERT INTO rei_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","పిల్లానె, ప్రబువురె తొం మాబోనుకు లోబొడికిరి రోండి. క్రైస్తవుడుగా యెడ తొం పైటి. ");
INSERT INTO rei_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","“తొత్తె మేలు కలిగిలాపనికిరి తో బోకు మాకు గౌరవించు. యెడ వాగ్దానంరె మిసికిరి రొల్లా అగరొ ఆజ్ఞ పాటించిమాసి.” ");
INSERT INTO rei_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","సడ తొత్తె బూమంపరె దీర్గాయుసుకు దివ్వొ. ");
INSERT INTO rei_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","మాబోనే, తొం పిల్లానుకు రగొ పుట్టించితెనాండి. తంకు క్రీస్తురొ క్రమసిక్సనరె, బోదరె పుసొండి. ");
INSERT INTO rei_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","సేవకులింకే, డొరొసంగరె వనుకు సంగరె, క్రీస్తుకు లోబొడిలాపనికిరి, యే లొకొరె తొం యజమానునెకు హ్రుదయపూర్వకంగా లోబొడికిరి రోండి. ");
INSERT INTO rei_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","మనమానుకు సంతోసం పరిచిలా పనికిరి తంకె పొదర్లింకు దిగిదిల్లపని నీకుంట క్రీస్తు దాసునె బులి తెలిసిగీకిరి పురువుకు కెడ ఇస్టమొ సడ కొరండి, ");
INSERT INTO rei_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","ప్రబువుకు కొరిలాపనికిరాక యిస్టపూర్వకంగా కొరండి. ");
INSERT INTO rei_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","దాసుడైనన్నా, స్వతంత్రుడైనన్నా, తొం బిత్తరె ప్రతీ మనమ సెయ్యె కొరిలా బొల్ట పైటికు ప్రబువు వల్లరె ప్రతిపలం పొందిగివొబులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","యజమానునే, తొమ్మంకా తొం దాసునె గురించి సాకిరాక ప్రవర్తించొండి. తొముకు తొం దాసూనుకు జొన్నాక యజమాని పరలోకంరె అచ్చిబులి, సెయ్యె పక్సపాతం నీలాటబులి గ్రహించికిరి, తంకు బెదిరించివురొ మానిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","చివరకు, ప్రబువురొ మహాసక్తి ద్వారా తాబిత్తరె బలవంతులైకిరి రోండి . ");
INSERT INTO rei_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","తొమె సాతాను మాయకొతానెకు ఎదిరించితె సక్తి పొందిగిత్తందుకు పురువు దిల్లా సర్వాంగ కవచముకు పిందిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","కైంకిబుల్నే అం పోరాటం మనమానె సంగరె నీ. ఈనె వొందారొ సంబందమైలా లొకొనాదూనె సంగరె, ప్రదానునె సంగరె, అదికారినె సంగరె, మెగోమండలాల్రె బిత్తరె దురాత్మానె సమూహానె సంగరె అమె పోరాడిలించొ. ");
INSERT INTO rei_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","సడకాక తొమె యే ఆపదకలొరె తంకు ఎదిరించికిరి సక్తిమంతునెగా తారితె పురువు దీతల్లా సర్వాంగ కవచముకు పిందిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","తొం వొంటకు సత్యం బుల్లా దట్టీ, నీతి బుల్లా కవచం పిందిగీండి, ");
INSERT INTO rei_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","పాదమునెకు సాంతి సువార్త కోసం సిద్దమనుసు బుల్లా చెప్పిలీనె పిందిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","సడసంగరె పాటు సత్రువు బిసిరిలా నియ్య బానమునెకు అడ్డిగిత్తందుకు పైటికైలా విస్వాసం బుల్లా డాలు పిందిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ఈనె రక్సన బుల్లా సిరస్త్రానం, పురువురొ వాక్కు బుల్లా ఆత్మకడ్గం పిందిగీండి. ");
INSERT INTO rei_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ఆత్మరె సొబ్బి కలోన్రె సొబ్బిరకాల ప్రార్దనానె, విజ్ఞాపనానె కొరుకుంటా రోండి. సడకోసం పూర్తి పట్టుదల సంగరె పురువురొ మనమానె కోసం విజ్ఞాపనలూనె కొరుకుంటా సతనైకిరి రోండి. ");
INSERT INTO rei_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","సువార్త రహాస్యముకు దైర్యంగా కొయితె, మియ్యి కొతాలగితల్లాబెల్లె పురువు తా వాక్కుకు మెత్తె అనుగ్రహించిలా పనికిరి మో కోసమంకా ప్రార్దన కొరండి. ");
INSERT INTO rei_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","సంకెల్లు సంగరె రొల్లా మియ్యి యే సువార్త కోసం రాయబారి. మియ్యి యే సువార్తకు కెటువంటి దైర్యం సంగరె ప్రకటించిమాసో సెత్తాక దైర్యం సంగరె ప్రకటించిలపని మో కోసం ప్రార్దన కొరండి. ");
INSERT INTO rei_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","మో ప్రియమైలా బయి తుకికు ప్రబువురె నమ్మకమైలా సేవకుడు. తా ద్వారా మియ్యి క్యాకిరి అచ్చొ, కిడ కొరిలించొ తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","అం సంగతీనె తొమె జనితందుకు, తొం మనుసూనెకు ప్రోత్సహించితె తాకు తొం పక్కు పొడదీంచి. ");
INSERT INTO rei_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","బో యీల పురువు, ప్రబువైలా యేసు క్రీస్తు సాంతికు విస్వాసం సంగరె దిగిపించిలా ప్రేమకు అన్నబయినె అప్పబొయినినె అనుగ్రహించిమాసి గాక. ");
INSERT INTO rei_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","అం ప్రబువైలా యేసు క్రీస్తుకు నిత్యమైలాప్రేమ సంగరె ప్రేమించిలాలింకల్లా పురువు క్రుప కలిగిమాసి గాక.");
INSERT INTO rei_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","యేసుక్రీస్తుకు దాసులైలా పౌలు, తిమోతి పిలిప్పు పట్టనంరె క్రీస్తు యేసుకు చెందిలా పరిసుద్దులు సొబ్బిలింకు సంగరొ బొడిలింకూ పరిచారకులూనెకు సుబం కొయికిరి రాసిలా సంగతులూనె. ");
INSERT INTO rei_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","అం బో ఈలా పురువు తీకిరి ప్రబువైలా యేసు క్రీస్తు తీకిరి తొముకు క్రుప, సాంతి కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","మియ్యి తొముకు కెబ్బుకూ జ్ఞాపకం దన్నైగిన్నన్నా పురువుకు కృతజ్ఙత కొయిగిల్లీంచి. ");
INSERT INTO rei_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","మీ తొం కోసం ప్రార్దించిలా ప్రతీసారి సడ ఆనందంసంగరె ప్రార్దన కొరిలించి. ");
INSERT INTO rei_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","కైంకిబుల్నే సువార్త పైటి విసయంరె అగరె దినె తీకిరి ఉంచినె దాకా తొమె కొరిలా సహాయముకు దండము. ");
INSERT INTO rei_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","తొం బిత్తరె యే బొల్ట పైటి మొదలు కొరిలాట పురువాక. సడ యేసు క్రీస్తు బుల్లికిరి అయిల దినో వరకూ సే పైటి కొనసాగించికిరి పూర్తి కొరిపారొ బులి మో గట్టి నమ్మకం. ");
INSERT INTO rei_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","తొం గురించి మీ యాకిరి బావించువురొ న్యాయమాక. కైంకిబుల్నే తొమె మో మనుసురె అచ్చొ. మీ కైదురె తల్లాబెల్లె, మీ సువార్త తరుపురె వాదించుకుంటా సడకు నిరూపించితల్లాబెల్లే తొమల్లా యే క్రుపరె మో సంగరంకా పాలిబాగంలింకైకిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","క్రీస్తు యేసురొ ప్రేమతీకిరి తొం కోసం మీ కెత్తె ఆపేక్స కలిక్కిరచ్చో పురువాక మెత్తె సాక్సి. ");
INSERT INTO rei_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","తొం ప్రేమ జ్ఞానం సంగరె సంపూర్నమైలా వివేచనసంగరె ఇంకా, ఇంకా వ్రుద్ది చెందికుంటా తమ్మాసిబులి మీ ప్రార్దించిలించి. ");
INSERT INTO rei_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","సే విదంగా తొమె కెడ బొల్టొ బచ్చిగిల్లబెల్లె క్రీస్తు అయిల దినొరె తొమె సొబ్బి విడుల నిర్దోసం నీలపన తప్పు నీలపన తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","సడాకనీ పురువుకు మహిమ, స్తుతి కలిగిలాపని, తొమె యేసు క్రీస్తు ద్వారా కలిగిలా నీతి పలాలు సంగరె తొమె జీవితాలురె పరిపూర్నముగా పూరికిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","అన్నబయినె అప్పబొయినినె, మెత్తె సంబవించితల్ల సువార్త పైటి బడేవిస్తరించితాక బులి తొమె తెలిసిగిమాసి బులిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","క్యాకిరిబుల్నే, మో బందానె క్రీస్తు కోసమాక కలిగిసె బులి రొజాబవనం సొబ్బి స్దలాలురె తల్లా బతులుకు, సొబ్బిలింకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","సెత్తాకనీ, ప్రబువు బిత్తరె రొల్లా అన్నబయినెరె అప్పబొయినినెరె బడేలింకె మో బందకానె దీకిరి స్దిరమైలా విస్వాసం కలిక్కిరి, డొరొనీకుంటా పురువురొ వాక్కు ప్రకటించితె బడే దైర్యం దన్నైగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ఈనె కుండెలింకె అసూయసంగరె కలహబుద్దిసంగరె, ప్రకటించిలీసె ఈనె కుండె మంది బొల్టబుద్దిసంగరె బోదించిలీసె. ");
INSERT INTO rei_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ప్రేమసంగరె క్రీస్తుకు ప్రకటంచిలాలింకు మియ్యి సువార్త తరుపురె వాదించితందుకు నియమించిబొడించిబులి తంకు అరక. ");
INSERT INTO rei_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ఈనె తల్లలింకె బందకాల్రె రొల్లా మెత్తె ఇంకా బడే బాద కలిగించిమాసి బులి సుద్ద మనుసుసంగరె నీకుంటా కక్ససంగరె క్రీస్తుకు ప్రకటించిలీసె. ");
INSERT INTO rei_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ఈనన్నా పర్వానీ. కపటం సంగరె ఈనన్నా సత్యం సంగరె ఈనన్నా, క్యాకిరైనా క్రీస్తుకు ప్రకటించువురొ మాత్రం జరిగిలీసి. సడకు మియి సంతోసించిలించి. ఇంకా అగురుకు కూడ సంతోసించిమి. ");
INSERT INTO rei_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","తొం ప్రార్దనాన్రె వల్లరె, యేసు క్రీస్తు ఆత్మ సాయం వల్లరె మో యిడుదల కోసం యెడల్లా జరిగిలీసి బులి మెత్తె తెలుసు. ");
INSERT INTO rei_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","మియ్యి కే విసయంరైనన్నా లజ్జొపాలైనీబులి మెత్తె సంపూర్తిగా నిరీక్సన ఆసాబావం అచ్చి. ఈనె, సెత్తెలె పనికిరాక ఉంచినంకా మియ్యి జీక సంగరన్నా, మొర్నోవల్లరన్నా మో దే సంగరల్లా క్రీస్తుకు గనపర్చితల్లందుకు మెత్తె బడే దైర్యం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","మో మట్టుకైనే జీవురొ క్రీస్తాక, ఈనె మొరువురొ ఈనెనూ లబోఆక. ");
INSERT INTO rei_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ఈనన్నా దే సంగరె జీవించుకుంట మో ప్రయాసకు పలితం తన్నే, సెత్తెలె మీ కిడ కోరిగీవాసో మెత్తె తెలుసువురొనీ. ");
INSERT INTO rei_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","యే దీట మొజిరె మీ ఇరుకురె పొడిజేంచి. మీ లొకొకు సడికిరి క్రీస్తుసంగరె రొయిజిమ్మాసిబులి మో ఆస. సొబ్బిటికన్నా సడాక మెత్తె మేలైలాట. ");
INSERT INTO rei_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ఈనె మియ్యి దే సంగరె రొవ్వురొ తొం కోసం బడే అవసరం. ");
INSERT INTO rei_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","సడ ద్వారా, తొమె విస్వాసంరె అబివ్రుద్ది ఆనందం పొందితందుకు మీ జీకిరి తన్నే తొం సొబ్బిలింకు సంగరె మిసికిరితాంచి బులి మెత్తె తెలుసు. ");
INSERT INTO rei_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ఈనె మియ్యి తొం పక్కు బుల్లికిరి అయివురొవల్ల మో ద్వారా క్రీస్తు యేసురె తొమె గర్వించితె కారనమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","మియ్యి తొముకు దిగితె అయినన్నా, నా అయినార్నన్నా, సొబ్బిలింకె మిసికిరి సువార్త విస్వాసం ద్వారా పోరాడుకుంటా, గుట్టాకబావం సంగరె టారికిరి అచ్చెబులి తొమె క్రీస్తు సువార్తకు తగిలాపనికిరి సలిగిత్తండి మియ్యి సునిలాపనికిరి యెడ బడే ముక్యము. ");
INSERT INTO rei_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","తొమె సత్రువూనెకు డొరితెనాండి. తొమె దైర్యంగా రోండి తంకు అపజయం, తొముకు రక్సన కలిగివొబులి తంకు జనిలా సూచన. యెడ పురువు వల్లరె కలిగిలా విజయమాక. ");
INSERT INTO rei_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ఈనె తొమె క్రీస్తుకు విస్వసించిలాలింకాకనీ తా కోసం కొస్టొనె అనుబవించితె, సేవించితె, అవకాసమంకా దీసి. ");
INSERT INTO rei_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","అడకగరె మీ పోరాడిలా పోరాటంకు దిగిసొ. సడగురించి సునిలించి. తొమ్మంకా సడాక పోరాటంరె పాలిబాగస్తులు యీపారొ. ");
INSERT INTO rei_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ఈనె తొం జీవితాల్రె హెచ్చరించువురొ యీనెనూ ప్రోత్సాహం ఈనన్నా, ప్రేమదీకిరి కెటువంటి ఆదరన ఈనన్నా, పురువురొ ఆత్మ సంగరె కెటువంటి సహవాసం ఈనన్నా, దయ దిగిపించువురొ, ఆదరించువురొ ఈనన్నా తన్నే సడ క్రీస్తాక తొముకు బలపర్చిలీసి, ");
INSERT INTO rei_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","తొమల్లా గుట్టాక మనుసు, గుట్టాక రకమైలా ప్రేమ, ఆత్మరె ఏకత్వం, గుట్టాక ఉద్దేసం కలిగితైకిరి మొ ఆనందముకు సంపూర్నం కొరండి బులి తొం దీకిరి కోరిలించి. ");
INSERT INTO rei_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","కక్స సంగరైనా, స్వార్దం సంగరైనా కిచ్చీ కొరితెనా. వినయమైలా మనుసు సంగరె జొనుకు జొనె తొముకన్నా పొదరె గొప్పలింకెబులి బచ్చిగిత్తండి. ");
INSERT INTO rei_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","తొం బిత్తరె ప్రతీమనమ తా సొంతపైటీనాక నీకుంటా పొదర్లింకెరొ అవసరాలంకా దిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","క్రీస్తు యేసుకు తల్లా యే మనుసు తొమ్మంకా కలిక్కిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","సెయ్యె పురువురొ స్వరూపం కలిగిలాట. పురువు సంగరె సమానంగా తైతే సడదిగిన్నాసిబులి బులిగిల్లాని. ");
INSERT INTO rei_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","సడ బదులుగా, మనమ రూపంరె జొర్నైకిరి, దాసుడురొ రూపం దరించిగీకిరి తాకు సెయ్యాక సొబ్బిటికి సడదిపీసి. ");
INSERT INTO rei_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","సెయ్యె ఆకారంరె మనమగా దిగదీకిరి మొర్నొదాక, బుల్నే సిలువ మొర్నొకంకా సెయ్యె విదేయత సంగరె సలికిరి తాకు సెయ్యాక లోబొడిసి. ");
INSERT INTO rei_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","యే కారనం దీకిరి పురువు సొబ్బిటికన్నా సొబ్బి నానె కన్నా గొప్పగా హెచ్చించిసి. ");
INSERT INTO rei_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","సడుకాక పరలోకంరె, బూమంపరె, బూమి తొల్లె తల్లా ప్రతీ జొన్నె ముడుకూనె యేసు నారె వొంగిలాపనికిరి కొరిసి, ");
INSERT INTO rei_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ప్రతీ జొన్నె జిబ్బో బో ఈలా పురువురొ మహిమ కోసం యేసు క్రీస్తుకు ప్రబువుగా ఒప్పిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ఈనె మో ప్రియమైలాలింకె, తొమె కెబ్బుకూ లోబొడితల్లాపనాక, మీ తొం పక్కరె తల్లాబెల్లాకనీ, నీలాబెల్లంకా, డొరొ సంగరె వొనుకు సంగరె తొం సంపూర్నమైల రక్సన కోసం కొనసాగించొండి. ");
INSERT INTO rei_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","కైంకిబుల్నే తాకు ఇస్టమైలాట తొమె కొరితె, తొం బిత్తరె కెబ్బుకు పైటి కొరిలాట పురువాక. ");
INSERT INTO rei_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","తొమె కొరిలాంచల్లా, నాగల్డిగికుంట, నా సొనిగికుంట కొరండి. ");
INSERT INTO rei_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","సడవల్లరె తొమె మూర్కులైలా చెడ్డ మనమానె మొజిరె దోసము నీలలింకెగా, నిందనీకుంటా, నిస్కలంకులైకిరి పురువురొ పోనెగా జీవవాక్కుకు గట్టిగా దరిగీండి. లోకంరె తల్లాలింకె మొజిరె మెగోన్రొ చుక్కలు పనికిరి హల్లొగా రొమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","తొమె సాకిరి కొరిలాబెల్లె క్రీస్తు బుల్లికిరి అయిలా దినుకు మియ్యి సుచ్చరాక కొస్టొపొడిలానీ బులికిరి మో పైటి వ్రుదా అయిలానీబులి మెత్తె జనుంచి. సడ వలరె గొప్పగా కొయిగిత్తె మెత్తె గుటె కారనం తాసి. ");
INSERT INTO rei_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ఈనె తొం విస్వాసయాగంరె సడకు సంబందమైలా సేవరె మో పొర్నొ దారబోసినన్నా, మీ ఆనందించికిరి తొం సంగరల్లా సంతోసించిమి. ");
INSERT INTO rei_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","సాకిరాక తొమ్మంకా ఆనందించికిరి మో సంగరె సంతోసించండి. ");
INSERT INTO rei_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","తొం గురించి వార్త సునికిరి మెత్తె ప్రోత్సాహం కలిగిలాపనికిరి, ప్రబు చిత్తమైనె బేగా తిమోతికు తొం పక్కు పొడదిమ్మాసి బులిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","తిమోతి పనికిరి తొం గురించి పట్టించిగిల్లాట ఇంకా మో మనస్సుకు పంచిగిత్తె కేసే నింతె. ");
INSERT INTO rei_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","సొబ్బిలింకె తంకె సొంతపైటీనాక దిగిల్లీసేగని, యేసు క్రీస్తు పైటీనె దిగిలీనింతె. ");
INSERT INTO rei_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","తిమోతి తాకు సెయ్యాక రుజువు కొరిగిచ్చి. క్యాకిరిబుల్నే, బోకు పో క్యాకిరి సేవ కొరివొయో సాకిరాక సెయ్యె మో సంగరె సువార్తపైటిరె సేవ కొరిసి బులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","సడుకాక మెత్తె కిడ సంబవించిలీసొ తెలిసిలా వెంటరాక తాకు పొడదిమ్మాసి బులిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","మియ్యి బేగా ఆంచిబులి ప్రబువుద్వారా నమ్మిలించి. ");
INSERT INTO rei_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","మో బయి, మో సంగరె జతపైటితా, మో సంగరె సమానంగా పొరాడిలాట, తొం ప్రతినిది, మెత్తె అవసరమైలాబెల్లె సేవకొరిలాట యీలా ఎపప్రొదితుకు తొం పక్కు పొడదీతె అవసరం బులిగించి. ");
INSERT INTO rei_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","సెయ్యె జబ్బు పొడిసిబులి తొమె సునిసొ, గనక సెయ్యె తొముకు సొబ్బిలింకు దిగిమాసిబులి బడే బెంగదీగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","సొత్తాక సెయ్యె జబ్బైకిరి మొర్నుకు పక్కరచ్చి ఈనె పురువు తాకు కనికరంచిసి. తాకాకనీ, దుక్కమంపరె దుక్కం నాఅయినూ మో ఉంపరంకా కనికరించిసి. ");
INSERT INTO rei_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ఈనె తొమె తాకు ఇంకా దిక్కిరి సంతోసించిలాపనికిరి, మో చింత తీరిమాసిబులి తాకు బేగా పొడదిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","తాకు పూర్నానందం సంగరె ప్రబువు నారె మిసుగునొండి. సాలింకు గౌరంగా దిగోండి. ");
INSERT INTO rei_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","కైంకిబుల్నే సెయ్యె క్రీస్తు పైటిరె బడేమట్టుకు మొర్నొకంకా సిద్దమైసి. మెత్తె సేవ కొరితె తొమె నాతీర్చినార్లా మో అవసరాలు తొం బదులు తీర్చితె, సెయ్యె తా పొర్నొకంకా లెక్కకొరిలాని. ");
INSERT INTO rei_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ఆకరుగా, మో అన్నబయినె అప్ప బొయినీనే, ప్రబువురె ఆనందించొండి. యే సంగతీనాక తొముకింకా రాసివురొ మెత్తె సమస్య కిచ్చీనియ్యి. సడ తొముకు క్సేమమాక. ");
INSERT INTO rei_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","దుస్టులైలాలింకు పైటీనుకు జాగర్తగా తమ్మాసి. కుక్కురొనెపనాలింకోసం జాగర్త. తంకె తంకరొ ఆచారాలసంగరె చీరిపీలాలింకె గురించి జాగర్తగా తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","కైంకిబుల్నే, దే అంపరె ఆచారమూనె నమ్మకం నాదీగీకుంటా పురువురొ ఆత్మసంగరె ఆరాదించుకుంటా, క్రీస్తు యేసురె అతిసయించుతల్లా అమ్మాక అసలైలా సున్నతి పొందిలాలింకె. ");
INSERT INTO rei_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","సాకిరియిలపని ఈనె, మియ్యి దేకు ఆదారం కొరిగీపారి. కేసైనా దే కు ఆదారం కొరిగీమాసి బులిగిన్నే, మియ్యి తంకన్నా బూతు కొరిగీపారి. ");
INSERT INTO rei_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","మియ్యి అట్టదినొరె సున్నతి పొందిగీంచి. ఇస్రాయేలుగా జొర్నైంచి. బెన్యామీను గోత్రముకు చెందిలాట. హెబ్రీ సంతానమురె జొర్నైలా హెబ్రీట. దర్మసాస్త్రం పాటించిలా విసయంరె పరిసయ్యుడుగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ఆసక్తి విసయంరె సంగముకు హింసించితే దర్మసాస్త్ర నీతి విసయంరె తప్పునీకుంటా సంపూర్నవిదేయత సంగరె పాటించించి. ");
INSERT INTO rei_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ఈనన్నా కిరకిర మెత్తె లవొగా అచ్చెవొ సడానుకల్లా క్రీస్తు గురించి నాపైటికైలాంచ బులిగించి. ");
INSERT INTO rei_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","సడ మాత్రం నీ మో ప్రబువైలా యేసు క్రీస్తుకు జనివురాక బడే బొల్ట సంగతి. సడకాక మరి నిచ్చయముగా మో ప్రబువైలా యేసుక్రీస్తురొ బడేవిలువైలా జ్ఞానం కోసం సొబ్బిటికూ నొస్టొగా బచ్చిగిల్లించి. తా కోసం సొబ్బిటికు ఇస్టపూరకంగా తిరస్కరించించి. క్రీస్తుకు మాత్రమాక సంపాదించిగిత్తే, సడానుకు చెత్త సంగరె సమానంగా బచ్చిగించి. ");
INSERT INTO rei_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","దర్మసాస్త్రంకు సంబందించిలా మో స్వనీతి నీకిరి, క్రీస్తుబిత్తరె విస్వాసము సంగరొ నీతి, బుల్నే విస్వాసం ద్వారా పురువు అనుగ్రహించిలా నీతికలిగిలాటైకిరి తాబిత్తరె దిగదిమ్మాసి బులి కొరించి. ");
INSERT INTO rei_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","క్యాకిరైనా, తా మొర్నొ విసయంరె సమానఅనుబవం కలిగిలాటైకిరి, తాకు తా పునరుత్తానం బలముకు తెలిసిగిత్తందుకు, తా స్రమానెరె పాలుపొందితందుకు. ");
INSERT INTO rei_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","మెత్తె మీయాక మొర్నొతీకిరి ఉటికిరి జీకిరి అచ్చిబులి నిరీక్సనరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","యెడానుకల్లా మీ యింకా పొందిగిల్లాని గనక మీ యింకా సంపూర్నుడైలాని. క్రీస్తు మెత్తె కిడకోసం దరిగిచ్చో సడకు మీ సొంతం కొరిగిమ్మాసి బులి ప్రయత్నం కొరుకుంటా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ఈనెను అన్నబయినె అప్పబొయినినె, సడకు మియ్యి ఉంచునాక సాదించించి బులి బులిగిల్లాని. ఈనె గుటె మాత్రం కొరిలించి. అడకగరె జరిగిలాంచ పసిరిజేకిరి, అగురుకు తల్లాంచ పొందితె కోసం బడేప్రయాస పొడిలించి. ");
INSERT INTO rei_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","సడకు క్రీస్తు యేసురె పురువురొ డక్కకు సంబందించిలా పరలోకబహుమతి పొందితె కోసం గురి పక్కాక దొమిడిలించి. ");
INSERT INTO rei_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ఈనె అంబిత్తరె ఆత్మరె సంపూర్నమైలాలింకల్లా యాకిరాక ఆలోసించిమాసిబులి ప్రోత్సహించిలించి. మరి కే విసయం గురించైనా, తొమె ఇంగుటె పనికిరి ఆలోసించినె సడకంకా పురువు తొముకు బయలు పరిచివొ. ");
INSERT INTO rei_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ఈనన్నా ఉంచినెజాంక అముకు మిల్లా నియమాలు దరికిరాక క్రమముగా సలిగిమ్మా. ");
INSERT INTO rei_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","అన్నబయినె అప్పబొయినినె, తొమె మెత్తె పోలికిరి సలుగునోండి. అమె తొముకు మాదిరిగా తల్లా ప్రకారం సలిగిల్లాలింకు తంకు ఎంబడించోండి. ");
INSERT INTO rei_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","బడేలింకె క్రీస్తు సిలువకు మొర్నొకు సత్రువూనెగా సలిగిల్లీసె. యెడానె గురించి తొముకు బడేసార్లు కొయికిరి, ఉంచినంకా కందికుంటా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","నరకమాక తంకు అంతం. తంకు దేఆసలాక తంకు పురువు. తంకె తంకె లజ్జొపొడివలిసిలా సంగతీనె గురించి గొప్పగా కొయిగిల్లీసె. బూ సంబందమైలా సంగతీనంపరె మనస్సు దీగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","అమె పరలోకపౌరులునె. అం రక్సకుడైలా యేసు క్రీస్తు ప్రబువు సెట్టెతీకిరాక ఆసిబులి తా కోసం ఎదురు దిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","సొబ్బిటుకు తా అదికారం తొల్లె లోపరిచిగిత్తల్లా తా సక్తి సంగరె అం బలహీనమైలా దేనుకంకా తా మహిమ దేనెగా మార్చుసి. ");
INSERT INTO rei_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","సడుకాక మో ప్రియమైలా అన్నబయినె అప్పబొయినీనె, తొంబుల్నే మెత్తె బడే ఇస్టం. తొముకు దిగిమాసిబులి మెత్తె బడే ఆసగా అచ్చి. మో ఆనందం మో కిరీటమైకిరి తల్లా మో ప్రియస్నేహితులూనే ప్రబువురె స్తిరమైకిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ప్రబువురె గుట్టాక మనుసు సంగరె మిసికిరి తమ్మాసి బులి యువోదియకు, సుంటుకే సోదరినెకు బతిమాలిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","వై, సొత్తయిల సహకారీ, తొత్తంకా పొచ్చర్లించి. సే మొట్టానె క్లెమెంతొ సంగరంకా, మిగిల్లా మో సహకారీనె సంగరె సువార్త పైటిరె మో సంగరె ప్రయాసపొడిసె గనక, తంకు సహాయం కొరుబులి కోరిలించి. తంకునానె జీవగ్రందంరె రాసికిరచ్చె. ");
INSERT INTO rei_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","సొబ్బిబెల్లె ప్రబువురె ఆనందించొండి. ఇంకా కొయిలించి, ఆనందించొండి. ");
INSERT INTO rei_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ప్రబువు బేగా అయిలీసి. తొం మ్రుదుమైలా ప్రవర్తన సొబ్బిలింకూ తెలియపర్చొండి. ");
INSERT INTO rei_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","కేటగురించి చింత పొడితెనాండి ఈనె సొబ్బి విసయానెరె ప్రార్దనా విజ్ఞాపనానె సంగరె క్రుతజ్ఞతా పూరకంగా తొం విన్నపానె పురువుకు మగొండి. ");
INSERT INTO rei_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","సెత్తెలె సొబ్బిజ్ఞానముకు మించిలా పురువురొ సాంతి, యేసు క్రీస్తురె తొం మనుసూనుకు తొం ఆలోచనానెకు జొగులొ తాసి. ");
INSERT INTO rei_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","చివరకు, అన్నబయినె అప్పబొయినీనె, కే యోగ్యతన్నా, మెప్పన్నా తన్నామాను, కేట సత్యమైలాంచో, కేట గౌరమైలాంచో, కేట న్యాయమైలాంచో, కేట పవిత్రమైలాంచో, కేట రమ్యమైలాంచో, కేట బొల్ట నా కలిగిలాంచొ, సడంపరె మనుసు లొగొండి. ");
INSERT INTO rei_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ఈనె మో కొతానె వల్లరె పైటినె వల్లరె తొమె కిడ సుక్కిగీకిరి అంగీకరంచిసెవో, మో బిత్తరె తల్లాపనికిరి కేట సునిసేవో, కేట దిగిసెవో, సడానుకు కొరండి .సెత్తెలె సాంతికర్తయైలా పురువు తొముకు తోడైకిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","మో గురించి తొమె ఉంచినెకైనన్నా ఇంకా ఆలోసించిలీసొబులి ప్రబువురె బడే సంతోసించించి. అడకగరె తొమె మో గురించి ఆలోసించిసొ గని తొముకు సరైలా సమయం మిల్లాని. ");
INSERT INTO rei_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","మెత్తె తక్కువైసిబులి మి యాకిరి కొయిలానియ్యి. మీ కే పరిస్దితిరె తన్నాన్నాసరాక, సే పరిస్దితిరె సంత్రుప్తి కలిక్కిరి తవ్వురొ సుగ్గించి. ");
INSERT INTO rei_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","దీనస్తితిరె తవ్వురొ తెలుసు, సంపన్న స్దితిరె తవ్వురొ తెలుసు. ప్రతీ విసయంరె సొబ్బి పరిస్దతిన్రె పెట్టొ పూరికిరి తవ్వురొ, బొక్కొసంగరె తైతందుకు, సమ్రుద్ది కలిక్కిరితైతె, కిచ్చీనీకుంటా లేమిరె తవ్వురొ సుగ్గించి. ");
INSERT INTO rei_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","మెత్తె బలపరిచిలా క్రీస్తు వల్లరాక మీ సొబ్బి కొరిపారిలించి. ");
INSERT INTO rei_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ఈనన్నా మో కొస్టోనెరె పాలుబంటిగివురొ తొమె బొల్టపైటి కొరిసొ. ");
INSERT INTO rei_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","పిలిప్పీలింకే, మియ్యి సువార్తకు బోదించువురొ మొదలుదీకిరి మాసిదోనియ తీకిరి బయలుదేరిలాబెల్లె తొం సంగం గుట్టాక మెత్తె సహాయం కొరికిరి ఆదిగిచ్చి. యేసంగతి తొముకల్లా తెలుసు. ");
INSERT INTO rei_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","కైంకిబుల్నే తెస్సలోనీకరంకా తొమె బడేసార్లు మో అవసరం తీర్చితె సాయం కొరిసొ. ");
INSERT INTO rei_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","మీ బహుమానంకు ఆసించికిరి యాకిరి కొయివురొనీ, తొముకు ప్రతిపలం బడేట మిలిమాసిబులి ఆసించికిరి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","మెత్తె సొబ్బీ సొరిపొడిలెత్తచ్చి. తొమె పొడదిల్లా సొరొకోనె ఎపప్రొదితు సంగరె అందిసె. మెత్తె లోటు కిచ్చీనీ. సడానె ఇంపైలా సువాసనగా, పురువుకు ఇస్టమైలా అర్పనగా అచ్చె. ");
INSERT INTO rei_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ఈనె మో పురువు తా ఐస్వర్యం సంగరె క్రీస్తు యేసు మహిమరె తొం సొబ్బి అవసరాలుకల్లా తీర్చుసి. ");
INSERT INTO rei_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","అం బో ఈలా పురువుకు కెబ్బుకూ మహిమ కలిగిమాసి గాక. ఆమేను. ");
INSERT INTO rei_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","పురువురొ ప్రజానెకల్లా క్రీస్తు యేసురె దండము కోండి. మో సంగరె తల్లా అన్నబయినె అప్పబొయినినల్లా తొముకు దండము కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ఎట్టె తల్లా పురువురొ ప్రజానెల్లా ముక్యంగా రొజా గొర్రె తల్లా తొముకు అబివందనము కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ప్రబువైలా యేసుక్రీస్తు క్రుప తొం సొబ్బిలింకె సంగరె తమ్మాసి గాక.");
INSERT INTO rei_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","పురువురొ చిత్తప్రకారం యేసు క్రీస్తురొ అపోస్తులుడైలా పౌలు అం బయి తిమోతి, ");
INSERT INTO rei_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","క్రీస్తురె నమ్మకస్తులైలా అన్నబయినుకు అప్పబొయినీనెకు కొలస్సీరె తల్లా క్రీస్తురొ ప్రియమైలా పురువురొ ప్రజానెకు సుబం కొయికిరి రాసిలా సంగతీనె. అం బోయీలా పురువు తీకిరి క్రుపా సాంతి కలిగిమాసి గాక. ");
INSERT INTO rei_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","అమె కెబ్బుకూ తొముగురించి ప్రార్దన కొరితల్లాబెల్లల్లా ప్రబువైలా యేసుక్రీస్తు ద్వారా పురువుకు క్రుతజ్ఞతలు చెల్లించిలించొ ప్రార్దన కొరిలించొ. ");
INSERT INTO rei_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","యెడ వలరె క్రీస్తు యేసంపరె తొమె దీగిల్లా నమ్మకం గురించి పురువురొ మనమానెంపరె తొమె దైపించిలా ప్రేమ గురించి అమె సునించొ. ");
INSERT INTO rei_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","యే సత్యవాక్కు బుల్లా సువార్త తొం పక్కు అగుంతా అయిలాబెల్లె యే నిరీక్సన సంగరె తల్లా ప్రేమ. విస్వాసం పరలోకంరె తొంకోసం రొయిదీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","యే సువార్త లొకొకల్లా పలించుకుంటా, వ్యాపించిలాపనికిరి తొమె పురువురొ క్రుప గురించి సునికిరి సత్యముగా గ్రహించిలాబెల్లెతీకిరి తొం బిత్తరంకా పలించుకుంటా వ్యాపించిలీసి. ");
INSERT INTO rei_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","అం ప్రియమైలా ఎపప్రా అం సంగరె పైటికొరిలా సహదాసుడు, సెయ్యె యేసుక్రీస్తుకు నమ్మకమైలా సేవకుడు తా ద్వారా తొమె యే సంగతీనె సుగ్గిచ్చొ. ");
INSERT INTO rei_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","సెయ్యాక ఆత్మబిత్తరె పొందిల తొం ప్రేమకు అముసంగరె తెలియపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","సడుకాక యే సంగతి సునిలాబెల్లెతీకిరి అమె తొం కోసం ప్రార్దన కొరివురొ మానిలానింతొ, తొమె సంపూర్న జ్ఞానం, ఆత్మసంబందమైలా వివేకం కలిగిలాలింకైమాసిబులి, తా చిత్తముకు పూర్తిగా గ్రహించిలాలింకైమాసిబులి పురువుకు కోరిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","సెల్లె సొబ్బి బొల్టపైటిన్రే తొమె పలించుకుంటా, పురువుకు సంబందించిలా జ్ఞానం బిత్తరె బొడుకుంటా, సొబ్బి విసయోనెరె ప్రబువు సంతోసించిలా పనికిరి, తాకు తగిలాపనికిరి తొమె సలిగీండి. ");
INSERT INTO rei_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","మహిమా ప్రబావములుసంగరె కలిగిలా తా సక్తి తొముకు సొబ్బివిదమైలా సామర్ద్యం దీకిరి బలపరిచిమాసిబులి పురువుకు కోరిగిల్లించొ. సడాక తొముకు ఓర్పుకు, పట్టుదలసంగరె సలిగిత్తే సక్తికు కలిగించుసి. ");
INSERT INTO rei_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","హల్లొ సంబందించిలా తా మనమానెరొ వారసత్వమురె అముకు పాలిబాగస్తులుగా కొరిలా బోకు తొమె సంతోసం సంగరె క్రుతజ్ఞతా చెల్లించిమాసి. ");
INSERT INTO rei_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","సెయ్యె అముకు వొందారొ సంబందమైలా రాజ్యొఅదికారంతీకిరి చొడిపించికిరి, తా ప్రియమైలా పోరొ రాజ్యొరె రొయిదీసి. ");
INSERT INTO rei_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","సే పో బిత్తరాక అముకు విడుదల పాపక్సమాపన కలిగిలీసి. ");
INSERT INTO rei_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","క్రీస్తు నాదిగదిల్లా పురువురొ స్వరూపం. సొబ్బిస్రుస్టికల్లా అదికారిగా సెయ్యె అగరె పోగా జొర్నొ యికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","క్యాకిరిబుల్నే మెగొన్రెతల్లాంచన్నా బూమంపరెతల్లాంచన్నా, అంకికి దిగదిల్లాంచనె నాదిగదిల్లాంచనె, సడానె సింహాసనానైనా, ఆదిపత్యాలైనా, ప్రబుత్వానైనా, అదికారినైనా యే ప్రపంచమురె సొబ్బీ తా ద్వారా కలిగిసె. తా కోసమాక కలిగిసె. ");
INSERT INTO rei_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","క్రీస్తు సొబ్బిటికి అగరె తల్లాట. సెయ్యె సొబ్బి సడ సడరొ చోటురె నిర్నయించిబొడిసి. ");
INSERT INTO rei_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","సెయ్యాక సంగంబుల్లా దేకు ముండొ. సొబ్బి అదికారినెకు మూలమైలాట సెయ్యాక. సొబ్బిటరె తాకు అగరె స్తానం కలిగితందుకు మొరిజిల్లాలింకుబిత్తరెతీకిరి సజీవుడుగా ఉటువురొబిత్తరె సెయ్యె మొదటీట. ");
INSERT INTO rei_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","పో బిత్తరె పురువుతత్వం సర్వసంపూర్నత నివసించిమాసిబులి పురువాక స్వయంగా నిర్నయించిసి. ");
INSERT INTO rei_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","పో ద్వారా లొకొకల్లా తా సంగరె సమాదానపరిచిగిత్తే పురువు ఇస్టపొడిసి. మెగోబిత్తరె, బూమంపరె తల్లా సొబ్బీటకు తా పోరొ రొగుతొ సిలువంపరె వొలికించువురొ ద్వారా కొడిగీకిరి అయిమాసిబులి పురువురొ నిర్నయమైసి. ");
INSERT INTO rei_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ఈనె గుటెబెల్లె తొమ్మంకా పురువుకు దూరుగా నాజనిలాలింకెపనచ్చొ. తొం చెడ్డపైటీనె వల్లరె విరోదబావం సంగరె పురువుకు సత్రువూనెగా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ఈనె ఉంచినె తా అగరె తొమె పరిసుద్దులుగా, నిర్దోసీనెగా, అపరాదాలు నీకుంట తైతందుకు తా పోరొ దేమొర్నొసంగరె, తొముకు పురువు తా జట్టుకారీనెగా కొరిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","యెడ ఈవాసిబుల్నే తొమె విస్వాసంరె స్తిరంగా తైకిరి, తొమె సునిలాంచ మెగొతొల్లె తల్లా స్రుస్టికల్లా తొముకు ప్రకటించిలా సువార్త వల్లరె కలిగిలా నిరీక్సన తీకిరి నాబాజీకుంటా స్తిరంగా తమ్మాసి. యే సువార్తకు పౌలు బుల్లా మియ్యి సేవకుడైకిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ఉంచినె తొం కోసం మీ పొడితల్లా హింసాన్రె సంతోసించిలించి. సంగంబుల్లా తా దే కోసం క్రీస్తు పొడిలా కొస్టొన్రె తక్కువైలాంచబిత్తరె మో వొంతు మో దే ద్వారాగా సంపూర్తి కొరిలించి. ");
INSERT INTO rei_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ఈనె ప్రకటించవలిసిలా పురువురొ వాక్కుకు సంపూర్తిగా తెలియపర్చితందుకు పురువు మెత్తె ఒప్పకొయిలా బాద్యతప్రకారం మియ్యి సంగముకు పరిచారకుడైంచి. ");
INSERT INTO rei_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","యే రహాస్యం యుగయుగాలు తీకిరి తరతరమునె తీకిరి మర్మమైకిరి అచ్చి. ఈనె ఉంచినె సడకు పురువు తా మనమానుకు బయలుపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","మనమానె సొబ్బిలింకు యే మర్మంరొ మహిమైస్వర్యం క్యాటవొ తెలియపర్చిమాసిబులి పురువు తలంచిసి. యే మర్మం తొం బిత్తరె తల్లా యేసు క్రీస్తాక .సెయ్యాక పురువురొ మహిమ. తొమె తా మహిమరె పాలిబాగస్తులు యీసొ. ");
INSERT INTO rei_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","తా గురించాక అమె ప్రకటించిలించొ. సొబ్బి మనమానుకు క్రీస్తురె పరిపూర్నులుగా కొరికిరి పురువు అగరె టారదిమ్మాసిబుల్లా యే ఉద్దేసం సంగరాక అమె సొబ్బి విదమైలా జ్ఞానం సంగరె సొబ్బిలింకూ హెచ్చరించుకుంటా బోదించిలించొ. ");
INSERT INTO rei_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","యెడకోసమాక మీ స్రమపొడిలించి. మో బిత్తరె బలంగాపైటి కొరితల్లా తా మహాసక్తి వల్లరాక మీ పోరాటంపైటి కొరితె ప్రయాసపొడ్లించి. ");
INSERT INTO rei_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","తొం కోసం, లవొదికయ గాలింకె కోసం, మెత్తె నాతెలిసిలలింకె కోసం మీ కెత్తె పోరాడిలించో తొముకు కొయిమా బులిగిలించి. ");
INSERT INTO rei_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","తంకల్లా ప్రేమరె గుట్టైకిరి, సంపూర్నంగా గ్రహించికిరి, ఆసీర్వాదానెకల్లా పొందిగీకిరి, పురువురొ మర్మమైకిరితల్లా క్రీస్తుకు స్పస్టముగా జనివురొ వల్లరె, తంకె మనసునురె ఆదరన పొందిమాసిబులి తంకసొబ్బిలింకోసం పోరాడిలించి. ");
INSERT INTO rei_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","జ్ఞానం, తెలివితేటలునె సొబ్బిసంపదలల్లా క్రీస్తు బిత్తరాక నుచ్చికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","సోద కొతానె కొయికిరి కేసైనా తొముకు మాయ నాకొరుకుంటా తమ్మాసిబులి యే సంగతీనె తొముకు కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","మియ్యి దే విసయంరె దూరుగా తన్నన్నా, ఆత్మవిసయంరె తొం సంగరాక తైకిరి, తొం బొల్టప్రవర్తన, క్రీస్తురె తొముకు తల్లా బలమైలా విస్వాసం దిక్కిరి ఆనందించిలించి. ");
INSERT INTO rei_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ఈనె తొమె ప్రబువైలా క్రీస్తు యేసుకు అంగీకరించిలాపనికిరి తాబిత్తరె మిసికిరి టారించి. ");
INSERT INTO rei_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","తా బిత్తరె స్తిరంగా నాటిగీకిరి టారించి. తాంపరాక తొం జీకానుకు బందిగీండి. తొముకు బోదించిలా రీతిగా విస్వాసంరె సెరోనె పారికిరి టారించి. క్రుతజ్ఞతలు చెల్లించువురొ విసయమురె విస్తరించికిరి టారించి. ");
INSERT INTO rei_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","క్రీస్తుకు నా అనుసరించుకుంట మనమాన్రో సాంప్రదాయానెకు, యే లొకొ సంబందమైలా మూలపటొనెకు అనుసరించికిరి, మోసకరమైలా నిరర్దకమైలా తత్వజ్ఞానం సంగరె తొముకు మాయ కొరికిరి కేసే నాలొంగదీగీకుంటా జాగర్తగా రోండి. ");
INSERT INTO rei_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","కైంకిబుల్నే దైవత్వమురొ సొబ్బిసంపూర్నతల్లా తా దేగా క్రీస్తురె నివసించిలీసి. ");
INSERT INTO rei_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ఈనె తా బిత్తరె తొమ్మంకా సంపూర్నులైకిరి అచ్చొ. సెయ్యె సొబ్బి ప్రదానులంపరె, అదికారినెంపరె సిరసైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","మనమాన్రొ అత్తోనె సంగరె కొరిలాపనికిరినీకుంటా, పురువు తా బిత్తరె తొముకు సున్నతి కొరిసి. స్వబావ రీతిగా దే బిత్తరె తల్లా పాప స్తితి కడిపీవురాక క్రీస్తురె తొమె పొందిలా సున్నతి. ");
INSERT INTO rei_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","తొమె బాప్టీసం ద్వారా తా సంగరె కుంతిదీకిరి, ఈనె మొరిజిల్లాలింకుతీకిరి తాకు సజీవంగా ఉడదిల్లా పురువు సక్తంపరె తొముకు తల్లా విస్వాసం వల్లరె తొమంకా తా సంగరె సజీవంగా ఉటిసొ. ");
INSERT INTO rei_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ఈనె గుటెబెల్లె తొమె కొరిల అపరాదాలు వల్లరె ఇంకా దర్మసాస్త్రం నీలా పొదరెలింకెగా తొమె మొరికితన్నుగా, సెత్తెలె సెయ్యె క్రీస్తురె తొముకు జీపించిసి. అం అపరాదములుకు క్సమించిసి. ");
INSERT INTO rei_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","అముకు విరోముగా రాసికిరి తల్లా రునపత్రముకంకా, సడకు సంబందించిలా నియమ నిబందనానెకు సెయ్యె పుంచిపేసి. సెయ్యె సడానుకల్లా కడికిరి సిలువంపరె మేకూనె సంగరె మరిసి. ");
INSERT INTO rei_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ఈనె సిలువంపరె సెయ్యె బొడిలింకు, అదికారినెకు ఓడించికిరి, తంకు బందీలుగా కొరికిరి తా విజయోత్సవము ఊరేగింపురె సొబ్బిలింకె అగరె దిగదీకిరి తంకెదీకిరి విడుదల ప్రకటించిసి. ");
INSERT INTO rei_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ఈనె కైలా విసయమురె, పీలా విసయమురె, పొరువొ దినోనె, ఆమాస, విస్రాంతి దినొ పనా విసయమూనెరె తొముకు కేసే నియమాలు నా దీకుంటా దిగ్గునొండి. ");
INSERT INTO rei_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","యెడానల్లా జరగవలిసిలాంచకు నీడపనాంచ. సడరొ సొత్తయిలా స్వరూపం క్రీస్తురె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","దేవదూతలకు ఆరాదన కొరుకుంట బడే వినయం దిగిదీకుంట ప్రత్యకమైల దర్సనం గలిగిలలింకెపన గొప్పలు కొయికుంట రొల్లలింకె తొం ఉంపరె తొముకు తీర్పు నాకొయిలపన దిగొండి యే కారనం వలరె దే సంబందమైల ఆసానె తొలుగుజూసె. ");
INSERT INTO rei_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","తాపనాట సిరసుగా తల్లా క్రీస్తు యేసుకు అంటిగీకిరి తన్నీ. సే సిరసు వల్లరాక దేఅల్లా పోసించబొడిలీసి. సే సిరసు వల్లరాక కీల్లు సంగరె, నరమూనె సంగరె దే గుట్టెగా తల్లీసి. పురువు వలరె వ్రుద్ది సంగరె అబివ్రుద్ది చెందిలీసి. ");
INSERT INTO rei_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","తొమె క్రీస్తు సంగరంకా లొకొరొ సాంప్రదాయానె విసయంరె మొరిజిల్లలింకె, ఇంకా సడానె తొల్లె జీలాపనికిరి మనమానె నియమానెకు కైంకి అనుసరించిలీసొ? ");
INSERT INTO rei_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","“సడ దరిగిన్నాసి, చక్కి దిగినాసి, సడ సూగిన్నాసి.” సే విదులుకు లొబొడివురొ కైంకి? ");
INSERT INTO rei_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","యే ఆజ్ఞానె, సొబ్బీ, నా పైటికైలాంచ కోసం మనమానె కొరిలాంచాక. సడానల్లా పద్దతీనె, బోదానె మాత్రమాక. ");
INSERT INTO rei_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ఆండిబిత్తరె మనమానె తంకె ఇస్టమైలా దేవదూత ఆరాదనలు సంగరె దేకు కటినంగా అదుపురె దీగిత్తందుకాక. ఈనె దే కోరికానెకు అదుపురె దీగిల్లా విసయంరె సడానె కేమాత్రము పైటికైనీ. ");
INSERT INTO rei_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ఈనె తొముకు క్రీస్తు సంగరె సజీవులుగా ఉటదీసి గనక ఉంపరె తల్లాంచకాక కుజ్జండి. సెట్టె క్రీస్తు పురువురొ బత్తొకైలాడుకు బొసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ఉంపరె తల్లాంచంపరాక మనుసు లొగ్గునండి. బూ సంబందమైలాంచంపరె మనుసు లొగ్గిత్తెనాండి. ");
INSERT INTO rei_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","కైంకిబుల్నే తొమె మొరిజీసొ, ఈనె తొం జీవం క్రీస్తు సంగరె పురువురె నుచ్చిదీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","అముకు జీవమైకిరి తల్లా క్రీస్తు ప్రత్యక్సమైలాబెల్లె తొమ్మంకా తా సంగరె మహిమరె ప్రత్యక్సమైవొ. ");
INSERT INTO rei_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ఈనె బూలొకొరె తల్లా తొ అవయవానెరె పైటికొరితల్లా, దర్నిపైటికు, అపవిత్రతకు, కామాతురతకు, దురాసకు, విగ్రహారాదనైలా పలియఆస మొరదీపేండి. ");
INSERT INTO rei_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","సడానె వల్లరె పురువురొ ఉగ్రత రగ్గొ తా కొతా నాసున్లాలింకంపరకు ఆసి. ");
INSERT INTO rei_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","పూర్వం సడ అమె వుంపరె ఏలుబడిరొల్లబెల్లె తొమె సడనెరొ ఆసానె అనుసరించికిరి సలిగిచ్చొ. ");
INSERT INTO rei_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","ఉంచినైనె తొమె రగ్గొ, ఆగ్రహము, దుస్టత్వము, దూసన, కచడ కొతానె కల్లా సడదిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","జొనుసంగరె జొనె సొరుకొతానె నాలగండి. కైంకిబుల్నే తొమె తొం పూర్వస్వబావముకు సడరొ పైటీనుకు కడిపీసొ. ");
INSERT INTO rei_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","జ్ఞానము కలిగిల నిమిత్తము సడకు స్రుస్టించిలాట పోలికచప్పురె నోయికిరి కొరిలాంచ నో స్వబావము దరించిగీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","యెడపనా యూదునె నీలలింకె బులి, యూదుడు బులి బేదంనీ. సున్నతి పొందిలాటబులి సున్నతి నాపొందిలాటబులి బేదంనీ. పరదేసిబులి, సొదేసస్తుడు బులి, దాసుడుబులి స్వతంత్రుడుబులి నియ్యి. క్రీస్తాక సర్వం, సొబ్బిలింకెబిత్తరె తల్లాట సెయ్యాక. ");
INSERT INTO rei_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","ఈనె పురువు ఏర్పాటు కొరిగిల్లాలింకె తంకె పరిసుద్దులు ప్రియమైలాలింకెపనికిరి, తొమె కనికరం గల్లా మనుసుకు, దీనత్వంకు, సాత్వికంకు, సహనముకు దరించిగిత్తండి. ");
INSERT INTO rei_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","కేసైనన్నా తాకు కీడు కొరిసె బులి జొనె బులిగిన్నే, జొనుకు జొనె సంహించిగీకుంటా జొనుకు జొనె క్సమించిగునొండి. ప్రబువు తొముకు క్సమించిలాపనికిరి తొమ్మంకా క్సమించొండి. ");
INSERT INTO rei_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","యెడానుంపరకల్లా పరిపూర్నతకు సంబందించిలా ప్రేమకు దరించుగునొండి. ");
INSERT INTO rei_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","క్రీస్తు అనుగ్రహించిలా సమాదానం తొం మనుసూనురె ఏలుమురోండి. యెడకోసమాక తొముకు గుట్టె దే గా డక్కిసి. ఇంకా క్రుతజ్ఞతగా తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","క్రీస్తు వాక్కు తొం బిత్తరె సమ్రుద్దిగా తమ్మురోండి. సంపూర్నజ్ఞానం సంగరె జొనుకుజొనె బోదించుగునొండి. బుద్ది కొయిగిత్తెనాండి. తొం మనుసూన్రె క్రుతజ్ఞత కలిక్కిరి గిత్తోనె సంగరె, పద్యాలు సంగరె ఆత్మ సంబందమైలా రాగానె సంగరె పురువుకు గిత్తోనె గాండి. ");
INSERT INTO rei_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","ఈనె కొతా సంగరె ఈనన్నా, పైటిసంగరె ఈనన్నా, తొమె కేట కొరినన్నా ప్రబువైలా యేసు ద్వారా బో యీలా పురువుకు క్రుతజ్ఞతాస్తుతులు చెల్లించుకుంటా తా నారె కొరండి. ");
INSERT INTO rei_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","నైపోనే, తొం గొయితానుకు లోబొడికిరి రొమ్మంచి. యెడ ప్రబువుకు తగిలా ప్రవర్తన. ");
INSERT INTO rei_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","గొయితానె, తొం నైపోనుకు ప్రేమించండి. తంకు సంగరె కటోరంగా తైతెనాండి. ");
INSERT INTO rei_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","పిల్లానె, సొబ్బి విసయోనెరె తొం మాబోరొ కొతా సునండి. యెడ ప్రబువు వల్లరె మెచ్చిగీవలిసిలాట. ");
INSERT INTO rei_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","బోనే మానే, తొం పిల్లాన్రొ మనుసు నిరాసనాపర్చుకుంట తంకు రగ్గొ రేపితెనాండి. ");
INSERT INTO rei_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","దాసులూనె, మనమానుకు మెప్పించిమాసిబులి బయలుకు దిగిదిమ్మాసిబులి నీకుంటా ప్రబువుకు దొరుపొడుకుంటా అంగీకరించిలపన సొబ్బి విసయానెరె తొం ఉంపరె నాయకునెకు లోబొడికిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","తొమె కే పైటికొరినన్నా మనుసుపూర్తిగా కొరండి. మనమానె కోసం నీకిరి ప్రబువు కోసం బులి బావించికిరి కొరండి. ");
INSERT INTO rei_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ప్రబువుతీకిరి వారసత్వం తొముకు బహుమతిగా మిల్లీసిబులి తొముకు తెలుసు. ప్రబువైలా క్రీస్తుకు తొమె సేవ కొర్లీసొ బులి గుర్తులొగ్గీండి. ");
INSERT INTO rei_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","అన్యాయం కొరిలాటకు సెయ్యె కొరిలా అన్యాయముకు తగిలా పలం మిలివొ. కైంకు బుల్నె పురువురొ తీర్పురె పక్సపాతం రొన్ని. ");
INSERT INTO rei_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","యజమానులునే, పరలోకంరె తొముకు జొనె యజమాని అచ్చిబులి గుర్తించిగీండి. తొం దాసునెకు న్యాయమైలాట, సరైలాట కొరండి. ");
INSERT INTO rei_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ప్రార్దనరె స్తిరంగా తైకిరి, క్రుతజ్ఞతానె చెల్లించుకుంటా సతనైకిరితాండి. ");
INSERT INTO rei_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","మీ బందకాలురె తైతందుకు కారనమైలా క్రీస్తురొ మర్మము గురించి బోదించిలా పనికిరాక మో కోసం ప్రార్దన కొరండి, ");
INSERT INTO rei_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","పురువురొ వాక్కుకంకా ప్రకటించితే మెత్తె అనుకూల సమయం దిమ్మాసిబులి మో కోసం పురువుకు ప్రార్దన కొరొండి. ");
INSERT INTO rei_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","సమయముకు నా వొరదగీకిరి సద్వినియోగం కొరిగీకుంటా, సంగముకు బయలురె తల్లాలింకె పక్కరె జ్ఞానం సంగరె మసులుగునొండి. ");
INSERT INTO rei_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","తొం కొతానె కెబ్బుకూ సమాదానంగా తమ్మాసి. తొం కొతాలగిలాట నున్నొ పొగిలా పనికిరి రుచిగా తల్లాపని దిగ్గిమ్మాసి. సాకిరాక తొమె కాకు కెటువంటి జవాబు దిమంచె బులి తెలిసిగీపారొ. ");
INSERT INTO rei_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ప్రియమైలా బయి నమ్మకమైలా సేవకుడు ప్రబువురె మో సహదాసుడైలా తుకికు మో సంగతీనల్లా తొముకు కొయివొ. ");
INSERT INTO rei_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ప్రత్యేకించికిరి తొముకు అం సంగతీనె కొయితందుకు తొం మనుసూనుకు ప్రోత్సహించితె ఆకు తో పక్కు పొడదిల్లించి. ");
INSERT INTO rei_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","ఆ సంగరంకా తొం గా మనమ, నమ్మకమైలా ప్రియమైలా బయి ఒనేసిముకు తొం పక్కు పొడదిల్లించి. తంకె యిట్టెరొ సంగతీనల్లా తొముకు కొయివొ. ");
INSERT INTO rei_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","మో సంగరంకా చెరసాలరె తల్లా అరిస్తార్కు, బర్నబాకు పక్కరె బందువైలా మార్కు తొముకు దండము కొయిలీసె. యే మార్కు తొం పక్కు అయిలాబెల్లె చేర్చిగీండి. బులి తొముకు అగరాక కొయించినీనా. ");
INSERT INTO rei_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ఈనె యూస్తు బులి నా తల్లా యేసు కూడా తొముకు దండము కొయిలీసి. అంకల్లా సున్నతి పొందిలా యూదునెరొ విస్వాసునెరె తల్లాలింకె. అంకాక పురువురొ రాజ్యొ కోసం మో సంగరె పైటి కొరిలాలింకె. అంకె మెత్తె ఆదరనగా అచ్చె. ");
INSERT INTO rei_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","తొం బిత్తరంకా జొనె క్రీస్తు యేసు సేవకుడైలా ఎపప్రా తొముకు దండము కొయిలీసి. పురువురొ చిత్తంసొబ్బిటిరె తొమె సంపూర్నులైకిరి నిచ్చయత కలిగికిరి నిలకడైకిరి తమ్మాసిబులి యెయ్యె కెబ్బుకూ తొం కోసం తా ప్రార్దనాన్రె పోరాడిలీసి. ");
INSERT INTO rei_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","యెయ్యె తొం కోసం, లవొదికయలింకె కోసం, హియెరాపొలి లింకె కోసం బడే ప్రయాస పొడిలీసి. యెడ తా గురించి మో సాక్సం. ");
INSERT INTO rei_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ప్రియమైలా వైద్యుడు లూకా, దేమా తొముకు దండము కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","లవొదికయరె తల్లా అన్నబయినుకు, నుంపాకూ, తంగొరొబిత్తరె తల్లా సంగముకు దండము కోండి. ");
INSERT INTO rei_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","యే పత్రిక తొమె చదివిలా తర్వాతరె లవొదికయ సంగంరంకా చదివిపించొండి. సాకిరాక మియ్యి లవొదికయ సంగముకు రాసికిరి పొడదిల్లా పత్రికకు తొమె దన్నైపించిగీకిరి చదువుగునొండి. ");
INSERT INTO rei_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","ఈనె సాకిరాక, “ప్రబువుబిత్తరె తొత్తె ఒప్పకొయిలా పరిచర్య నెరవేర్చితె జాగర్తపొడు” బులి అర్కిప్పు కు కోండి. ");
INSERT INTO rei_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","పౌలు బుల్లా మియ్యి మో అత్తొ రాత సంగరె తొముకు దండము కొయిలించి. మో బందకానెకు గేపకం కొరుగునండి. పురువురొ క్రుప తొముకు తోడుగా తమ్మాసి గాక.");
INSERT INTO rei_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","బో యీలా పురువురె ప్రబువైల యేసుక్రీస్తు దీకిరి రొల్ల తెస్సలోనిక రొ సంగముకు పౌలు, సిల్వాను, తిమోతి సుబం బులి కొయికిరి రాసిలాట. క్రుప, సమాదానం తొముకు ఈవాసి. ");
INSERT INTO rei_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","అం బో యీలా పురువొ అగరె తొం కోసం జ్ఞాపకము కొరిగీకిరి, అం ప్రార్దనల్రె విజ్ఞాపనము కొరిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","విస్వాసముదీకిరి కూడిల తో పైటి, ప్రేమదీకిరి కూడిల తో ప్రయాసముకు, అం ప్రబువైలా యేసుక్రీస్తురె నిరీక్సనదీకిరి కూడిల తో ఓర్పుకు, తొం సొబ్బిలింకె కోసం కెబ్బుకూ అం బో యీలా పురువు అగరె క్రుతజ్ఞతాస్తుతులు చెల్లించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","క్యాకిరిబుల్నే పురువు వల్లరె ప్రేమించబొడిలా అన్న బయినె అప్పబొయినీనె తొముకు ఏర్పరిచిగిల్లా సంగతి అముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","అం సువార్త, కొతాదీకిరి మాత్రమాక నీ. సక్తిదీకిరి, పరిసుద్దాత్మదీకిరి, సంపూర్న సత్యందీకిరి తొం పక్కు అయికిరి తొం గురించి అమె తొం వల్లరె క్యాకిరి సలిగించెవో తొముకోసమాక బులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","పరిసుద్దాత్మ వల్లరె కలిగిలా ఆనందం దీకిరి గొప్ప కొస్టొనెరె, తొమె అమె కొయిలా బోదకు అంగీకరించికిరి, అం పనికిరాక యీనె ప్రబువుకు పోలికిరి సలిలాపనికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ఈనె మాసిదోనియరె అకైయరె తల్లా విస్వాసినె సొబ్బిలింకు తొమె మాదిరిగా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","కైంకిబుల్నే తొం పక్కరెతీకిరి ప్రబువు వాక్యము మాసిదోనియకు అకైయకు జేసి. సెట్టె మాత్రమాకనీ, ప్రతీ చోటురె పురువుంపరె తొముకు తల్లా విస్వాసము పొదురుకయిసి గనక, అమె కిచ్చీ కొయివలిసిల అవసరంనీ. ");
INSERT INTO rei_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","తొం పక్కరె అముకు కెటువంటి ఆహ్వానం మిలిసో, సెట్టెరొ మానమానె తొంకోసం అముకు కొయిలీసె. ఈనె తొమె విగ్రహానెకు సడిదీకిరి, జీవముగలిగిలా సత్యవంతుడైలా పురువుకు దాసులైతందుకు. ");
INSERT INTO rei_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ఈనె పురువు, మొర్నొ తీకిరి ఉటిపించిలా తా పో యేసు బుల్నే అయితల్లా ఉగ్రత తీకిరి అముకు తప్పించితల్లాట సెయ్యాక పరలోకం తీకిరి ఆసి బులి తా గురించి ఎదురుదిగితె. తొమె పురువాడుకు క్యాకిరి బుల్లిసోవో సే సంగతి తంకాక కొయిలీసె. సెయ్యాక అయితల్లా ఉగ్రత తీకిరి తప్పించుసి. ");
INSERT INTO rei_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","అన్నబయినె అప్పబొయినీనె, తొం పక్కరకు అమె అయిలాట వ్యర్దము ఈలాని బులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","ఈనె, యెట్టెకు నా అయిలా అగరె, అమె పిలిప్పు గారె అగరె కొస్టొనె పొడికిరి, అవమానము పొడికిరి, కెత్తో వ్యతిరేకమురొన్నన్నా, తా సువార్త తొముకు బోదించితాకా అముకు పురువు దైర్యము దీసిబులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","కైంకి బుల్నే అం బోద కపటమైలాట నీ బులి, అపవిత్రమైలాట నీ, మోసమైలాట నీ, ");
INSERT INTO rei_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","సువార్తకు అముకు అప్పగించితె యోగ్యునె బులి పురువు వల్లరె బచ్చిలలింకె యీకిరి, మనమానుకు సంతోసపర్చిలాలింకెపనినీకిరి, అం మనుసూనెకు పరీక్సించిలా పురువుకాక సంతోసపరిస్తే బోదించింలించొ. ");
INSERT INTO rei_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","తొమె జనికిరి రొల్లాపనికిరి అమె పొంగిపించిలా కొతా ఈనెను, పలియంపరె ఆస సంగరె నుచ్చిదిల్లాకొతానె ఈనెను కెబ్బే ఉపయోగించిలాని సడకు పురువాక సాక్సి. ");
INSERT INTO rei_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","ఈనె తొం వల్లరె గాని తంకె వలరె గాని, కావల్లరైనన్నా గనత పొందిమాసి బులి అమె కోరిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","అమె క్రీస్తుకు అపొస్తులునె ఈకిరి తల్లందుకు బొడుతనం కొరితందుకు సమర్దునె యీకిరి తన్నన్నా, అమె తగ్గించిగీకిరి దుద్దొదిల్లమా తా సొంత పోనుకు దిగిల్లాపనాక, అమె తొం మొజిరె సాదువునె యీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","తొమె అముకు బడే ప్రియులైకిరి అచ్చొ గనుక తొమంపరె బడే సొరద గల్లాలింకయీకిరి పురువురొ సువార్తకు మాత్రమాక నీకుంటా అం పొర్నొనె కూడ తొముకు దీతె సిద్దపొడికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","అన్నబయినె, అం ప్రయాస, కొస్టొనె తొముకు జ్ఞాపకము అచ్చినీనా. అమ్మె తొముకు పురువురొ సువార్త ప్రకటించిలా బెల్లె కాకూ బారమైకిరి తన్నాసి బులి రత్తిదూసు కొస్టొపొడించొ. ");
INSERT INTO rei_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","విస్వాసులైలా తొం అగరె అమె కెత్తో పవిత్రంగా, నీతిగా, నిందనీకుంటా సలిగించొ సడకు తొమ్మాక సాక్సినె, పురువొంకా సాక్సాక. ");
INSERT INTO rei_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","బో తా పిల్లానె సంగరె సలిలాపనికిరాక అమె తొం బిత్తరె ప్రతిలింకె దీకిరి సలిగిల్లించొబులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","తా రాజ్యముకు, మహిమకు తొముకు డక్కితల్లా పురువుకు తగిలాపనికిరి తొమె సలిగిమ్మాసి బులి అమ్మె తొం బిత్తరె ప్రతీలింకు హెచ్చిరించికుంటా, దైరపర్చుకుంటా సాక్సం దీకుంటా ");
INSERT INTO rei_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","తొమె అగరె అం దీకిరి పురువురొ కొతయీల సందేసముకు అంగీకరించిలబెల్లె సడ మనమాండ్రొ కొత పనకా నీకుంటా పురువురొ కొతపనికిరి అంగీకరించిసొ. సే కారనం సంగరె, అమ్మె కెబ్బుకు పురువుకు క్రుతజ్ఞతాస్తుతులు చెల్లించిలించొ. తొమె అంగీకరించిలా సే సందేసముకు సొత్తాక సడ పురువురొ కొతాక. సడ విస్వసించిల తొంబిత్తరె పైటి జరిగించిలీసి. ");
INSERT INTO rei_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","వై అన్నబయినె, అప్పబొయినీనె, తొమె యూదయ ప్రాంతంరె క్రీస్తుయేసురె తల్లా పురువురొ సంగమునెకు పోలికిరి చలిగిల్లీసొ. తంకె యూదునె వల్లరె అనుబవించిల హింసానాకా ఉంచినె తొమ్మంకా తొం సొంతదెసొలింకువల్లరె అనుబవించిలీసొ. ");
INSERT INTO rei_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","సే యూదునె తంకె పాపోనె కెబ్బుకు సంపూర్తి కొరితందుకు ప్రబువైలా యేసుకు, ప్రవక్తానెకు మొరదీకిరి అముకు హింసించిసె, ");
INSERT INTO rei_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","పురువుకు నా నమ్మిలా పొదరెలింకె రక్సన కలిగితందుకు తంకెదీకిరి అమె నా కొతాలగుకుండా అముకు ఆటంకపర్చిసె, పురువుకు నాయిస్టమైలలింకు మనమానె సొబ్బిలింకు పగస్తునె యీకిరి అచ్చె. పురువురొ రగ్గొ చివరకు తంకెంపరకు ఆసి. ");
INSERT INTO rei_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","అన్నబయినె, అప్పబొయినీనె అమె దే వల్లరె కుండె కలొ తొముకు ఎడబాసికిరి తన్నెను, మనస్సుదీకిరి తొమె పక్కరె రొయికిరి, బడే ఆస సంగరె తొం మూ దిగిమాసి బులి బడే ప్రయత్నంకొరించొ. ");
INSERT INTO rei_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ఈనె అమె తొం పక్కు అయివాసిబులిగించొ; పౌలు బుల్లా మియ్యి బడే సార్లు అయివాసి బులి బులిగించి ఈనె, సాతాను ఆటంకపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","కైంకిబుల్నే మో నీరీక్సనైనన్నా, ఆనందం ఈనన్నా, అతిసయమైనన్నా కిర? అం ప్రబువైలా యేసు అయిలా సమయమురె తా అగరె టారెలాలింకె తొమ్మాకనీనా? ");
INSERT INTO rei_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","సొత్తాక అం గనత ఆనందం తొమ్మాక యీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ఈనె అమె సహించినారీనన్నా ఏతెస్సు పట్నంరె అమె జొన్నె ఈనెను తమ్మాసి బులి నిచ్చయించిగీకిరి, ");
INSERT INTO rei_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","యే హింసానే మూలముగా తొం బిత్తరె కేసె కూడ విస్వాసం విసయమురె తొమె పొచ్చుకు నాబాజీకుంటా ఆదరించితె, బలపరిచితె క్రీస్తు సువార్తరే పురువురొ సేవకుడు అం సంగరె పైటికొర్లా అన్నబయి యీలా తిమోతికు తొం పక్కు పొడిదీంచొ. ");
INSERT INTO rei_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","ఈనె ఏ సోదనానె అయిలాబెల్లె పొచ్చుకు నాబాజీకుంటా తైతే, యే కొస్టొనె అనుబవించిమంచి బులి పురువాకా నియమించిసి బులి తొమె తెలిసిగీండి. ");
INSERT INTO rei_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","అమె తొం పక్కరె తల్లాబెల్లె “అమె స్రమానె పొడిమాసి బులి” అగరాక తొం సంగరె కొయించొ నీనా! తొముకు తెలిసిలా పనాక ఉంచినె సాకిరాక జరిగిసి. ");
INSERT INTO rei_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","సడకాక మియ్యి ఇంక తన్నారికిరి, సోదకుడు తొముకు సోదించుసి కీవోబులి, అం ప్రయాస వ్యర్దమైజెవ్వొకీవో బులికిరి, తొం విస్వాసముకు క్యాకిరచ్చొ తెలిసిగిమ్మాసిబులి తిమోతికు పొడిదీంచి. ");
INSERT INTO rei_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","తిమోతి ఉంచినె తొం పక్కరతీకిరి అం పక్కు అయికిరి, తొం విస్వాస ప్రేమ గురించి అముకు కొయిసి. అమె తొముకు దిగిమాసిబులి ఆస పొడిలా పనాక తొమ్మంకా అముకు దిగిమాసిబులి ఆస పొడిలీసొ బులి, అముకు ప్రేమ సంగరె కెబ్బుకూ జ్ఞాపకం కొరిగిల్లీసొ బులి తొం గురించి సంతోసమైలా కబురు అముకు దన్నైసి. ");
INSERT INTO rei_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","సడవల్లరె అన్నబయినె అప్పబొయినీనె, అం యిబ్బంది సొబ్బిటిరె కొస్టొనె సొబ్బిటిరె తొం విస్వాసముకు దిక్కిరి తొం విసయమురె ఆదరన పొందించొ. ");
INSERT INTO rei_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","కైంకిబుల్నే, తొమె ప్రబువుబిత్తరె స్తిరముగా టారీకిరి తన్నే అమంకా సంతోసంగా జీకిరితల్లాపనాక. ");
INSERT INTO rei_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","పురువు అగరె తొం వల్లరె అమె కడిగిల్లాంచ యావత్తు ఆనందము సంగరె పురువుకు తగిలపనికిరి క్రుతజ్ఞతాస్తుతులు క్యాకిరి కొయిపారొ ");
INSERT INTO rei_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","అమె తొం మో దిక్కిరి తొం విస్వాసంరె రొల్లా లోపముకు తీర్చిలాపనికిరి అనుగ్రహించుబులి రత్తి, దూసు నాచడదిన్నూ పురువుకు మనుసుపూర్తిగా పొచ్చర్లించొ. ");
INSERT INTO rei_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","అం బో యీలా పురువొకు అం ప్రబువైల యేసుకు అముకు నిరాటంకముగా తొంపక్కు కొడిగీకిరి ఆసి. ");
INSERT INTO rei_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","తా పరిసుద్దులు సొబ్బిలింకె సంగరె మిసికిరి అయిలబెల్లె అం బో యీలా పురువు అగరె తొం హ్రుదయనె పరిసుద్దత విసయంరే నిందనీలపనికిరి రొల్లాపని ప్రబువు స్దిరపరచుసి. ");
INSERT INTO rei_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","సాకిరాక అం ప్రబువైలా యేసు తా పరిసుద్దులు సొబ్బిలింకు సంగరె అయిలాబెల్లె అం బో యీలా పురువు అగరె తొం మనుసూనెకు పరిసుద్దముగాను కెటువంటి నింద నీలాపనికిరి సెయ్యె తొముకు స్తిరపర్చుసి. ");
INSERT INTO rei_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","చివరిగా అన్నబయినె, అమె ప్రబువైయిలా యేసు ద్వారా తొముకుదిల్లా ఆజ్ఞానె తొముకు తెలుసు. ఈనె తొం యాకిరి సలికిరి పురువుకు సంతోసంకొరిలపని అంవల్లరె సుగ్గిల్లాపనికిరి తొమె సలిగిల్లీసో. ");
INSERT INTO rei_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","ఏ విసయమురె తొమె సెల్లెసెల్లెకు అబివ్రుద్ది పొందిమాసిబులి ప్రబువైల్లా యేసురె ప్రోత్సహించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","తొమె పరిసుద్దునె యీతాక, తొమె జారత్వముకు దూరుగా రొవ్వురొ పురువురొ యిస్టంయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","తొంబిత్తరె ప్రతిలింకె, తా నైపొ సంగరె క్యాకిరి రొమ్మాసొ పరిసుద్దంగా గౌరవంగా రొమ్మాసొ తెలిసిగునోండి. ");
INSERT INTO rei_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","తొమె పురువుకు నా జనిలా పొదరెలింకె పనికిరి కామాబిలాస కలిక్కిరి రొయితెనాండి. ");
INSERT INTO rei_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","యే విసయంకు కేసె అతిక్రమించినాసి. తా అన్నబయినెకు మోసం కొరినాసి; కైంకుబుల్నే మియి అడకగరె తొముకు కొయికిరి సాక్స్యముదిల్ల ప్రకారము ప్రబువు యడసొబ్బి విసయంరె ప్రతిదండన కొరుసి. ");
INSERT INTO rei_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","పరిసుద్దులైకిరి జీతాక పురువు అముకు డక్కిసి, కామవికారునె పనికిరి రొయితందుకు డక్కిలాని. ");
INSERT INTO rei_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ఈనె ఉంచినె కేసె మో బోదకు అంగీకరించినివొ తంకె మనమానుకు అంగీకరించివురొ నీ గని, అముకు తా పరిసుద్దాత్మకు అనుగ్రహించిలా పురువుకాక నిరాకరించిలీసె. ");
INSERT INTO rei_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","అన్న బయినె ప్రేమ గురించి తొముకు కేసె రాసితె అవసరము నీ; తొమె జొన్నెకు జొన్నె క్యాకిరి ప్రేమించిగిమంచెవొ పురువు తొముకు కొయిసి. ");
INSERT INTO rei_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","సాకిరి తొమె మాసిదోనియరె తల్లా అన్న బయినె సొబ్బిలింకు తొమె ప్రేమించిలీసొ. అం అన్న బయినె, తొమె ప్రేమ దికిరి ఇంక బూతుగా రొమంచె బులి ప్రోత్సహించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","తొ సొంతపైటినె కొరిగిల్లాటరె తో అత్తోనెసంగరె పైటికొరిగిమంచె బులి ఆస కలిగికిరి రొమ్మాసిబులి, తొముకు ప్రోత్సహించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","సంగము బయిల్రె రొల్లాలింకె ఉంపరె మర్యాదగా సలిగీకిరి, తొముకు తక్కువ కిచ్చి నికుండ అమె తొముకు ఆజ్ఞాపించిలా ప్రకారము తొమె పొదరిలింకంపరె ఆదారపొడితెనాండి. ");
INSERT INTO rei_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","అన్నబయినె అప్పబొయినీనె, నిరీక్సన నీలా పొదరిలింకె పనికిరి తొమె బాద నాపొడికుంటా, మొరిజిల్లాలింకు గురించి తొముకు నా తెలిసివురొ మెత్తె ఇస్టంనీ. ");
INSERT INTO rei_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","యేసు మొరిజీకిరి బుల్లికి ఉటిసిబులి అమె నమ్మిలాపనికిరి, సే ప్రకారము యేసురె మొరిజిల్లాలింకు పురువు తాసంగరె కూడ దరిగీకిరి ఆసిబులి విస్వసించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","అమె ప్రబువు కొతా ప్రకారం తొముకు కొయిలాట కిరబుల్నే ప్రబువు అయిలాజాంక జీకిరితల్లా అమె మొరిజిల్లాలింకె కన్నా అగరాక చేరిగిన్నింతొ. ");
INSERT INTO rei_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","ఆర్బాటముదీకిరి, ప్రదానదూత సబ్దముదీకిరి, పురువు బూర దీకిరి పరలోకందీకిరి ప్రబువు వొల్లికి ఆసి. క్రీస్తురె మొరిజిల్లాలింకెల్లా అగరె ఉటుసె. ");
INSERT INTO rei_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","సె తర్వాతరె సజీవులైకిరి తల్లా అమె తంకె సంగరె ఏకముగా ప్రబువుకు ఎదిరిగిత్తె ఆకాసమండలముకు మెగోనె ఉంపరె కొడుజోసి. ఈనె అమె కెబ్బుకూ ప్రబువు సంగరె కూడ రొంచొ. ");
INSERT INTO rei_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","ఈనె తొమె ఏ కొతానె సంగరె జొనుకు జొనె ఆదరించిగీండి. ");
INSERT INTO rei_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","అన్నబయినె అప్పబొయినీనె, కలోనె గురించి, సేసమయానె గురించి మియి తొముకు రాసితె అవసరంనీ. ");
INSERT INTO rei_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","సాకిరి రత్తిబెల్లె సొరొ క్యాకిరి ఆసొ ప్రబువు దినొ సాకిరి ఆసిబులి తొముకు బొల్లకిరి తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","మనమానె “నెమ్మదిగా అచ్చి, డొరొకిచ్చినీబులి కొయిగీకుంట” పనిదీగీకిరి తల్లా మొట్టకు ప్రసవవేదన బొత్తానె అయిలాపనికిరి తంకు అకస్మాత్తుగా నాసనము ఆసి గనక తంకె కెమాత్రము తప్పించిగిన్నారె. ");
INSERT INTO rei_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","అన్న బయినె అప్పబొయినీనె, తొమె రత్తిసంబందమైలలింకెనింతొ గనక సెయ్యె అయిలా దినొ తొముకు సొరొ అయిలాపనికిరి తన్ని. ");
INSERT INTO rei_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","తొమె సొబ్బిలింకె హల్లొ పిల్లానె దూసి పిల్లానెయీకిరి అచ్చొ గనక తొమె రత్తి సంబందించిలాలింకెనింతొ వొందారెలింకె నింతొ. ");
INSERT INTO rei_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","ఈనె పొదరెలింకెపని నాగుమ్మిజీకిరి మత్తులుపని నారొయికిరి సతనైకిరి రొండి. ");
INSERT INTO rei_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","గుమ్మిజిల్లాలింకె రత్తిబెల్లె గుమ్మిజోసె, మత్తుగా తల్లాలింకె రత్తిబెల్లె తంకె పీకిరి మత్తుగా తాసె. ");
INSERT INTO rei_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","అమె హల్లొ సంబందికులుగా అచ్చొ గనుక మత్తులునాయికుంటా, విస్వాస ప్రేమబుల్లా కవచము, రక్సనబుల్లా నిరీక్సన సిరస్త్రానముకు పిందిగిమండి. ");
INSERT INTO rei_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","కైంకిబుల్నే అం ప్రబువైలా యేసు క్రీస్తు సంగరె రక్సన పొందిగిత్తాక అముకు బచ్చిగిచ్చి ఈనె ఉగ్రతకు ఎదిరిగిత్తె నీ. ");
INSERT INTO rei_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","అమె మొరిజీకిరి తన్నెను, జీకిరి తన్నెను సె అయిలబెల్లె తాసంగరె మిసికిరి జీతాక అం కోసం సెయ్యె మొరిజీసి. ");
INSERT INTO rei_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","సడకు తొమె ఉంచినె కొరిలాపనాక జొనుకు జొనె ఆదరించిగీకిరి జొనుకు జొనె క్సేమాబివ్రుద్ది కలిగికిరి రోండి. ");
INSERT INTO rei_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","ఈనె అన్నబయినె అప్పబొయినీనె, తొమె ప్రయాసపొడుకుంటా ప్రబువురె తొముకు ఉంపరెలింకెపని రొయికిరి తొముకు బుద్దికొయిలలింకు గౌరవించొండి. ");
INSERT INTO rei_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","తంకె పైటిబట్టి తంకు ప్రేమసంగరె మిక్కిలి గనముగా బచ్చిగిమంచెబులి కోరిగిల్లించొ; ఈనె తొంబిత్తరె తొమె సమాదానముగా రొండి. ");
INSERT INTO rei_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","అన్నబయినె, అమె తొముకు బోదించిలించి కిరబుల్నే అక్రమముగా సలిగిలలింకు బుద్దికొండి, దైర్యము చెడిలాలింకు దైర్యముకొండి, బలహీనులుకు ఊత దెండి, సొబ్బిలింకె ఉంపరె దీర్గసాంతిముగలిగి రొండి. ");
INSERT INTO rei_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","కేసైనా కీడుకు ప్రతికీడు కాకైనను నా కొరుకుంట దిగెండి; తొమె జొన్నెఉంపరె జొనె మనమానె సొబ్బిలింకె ఉంపరె కెబ్బుకు బొల్టకొరితె అనుసరించికిరి సలండి. ");
INSERT INTO rei_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","కెబ్బుకు సంతోసంగా రొండి; ");
INSERT INTO rei_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","నా సడిదికుండ కెబ్బుకు ప్రార్దన కొరొండి; ");
INSERT INTO rei_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","ప్రతి విసయంరె క్రుతజ్ఞతాస్తుతులు చెల్లించొండి. యాకిరి కొరువురొ పురువురొ ఇస్టంకు కొరికిరి యేసు క్రీస్తురె మిసికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","పురువురొ ఆత్మ వెలిగించిమాసి బొత్తి నుగిదీతెనాండి. ");
INSERT INTO rei_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ప్రవచించువురొ నిర్లక్స్యము కొరితెనాండి. ");
INSERT INTO rei_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","సొబ్బిటికు పరీక్సించికిరి కిర బొల్టవొ సడకు కొరొండి. ");
INSERT INTO rei_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ప్రతి విదమైల కీడుకు దూరుగా రొండి. ");
INSERT INTO rei_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","సమాదానకర్తయిల్లా పురువు తొముకు సంపూర్నంగా పరిసుద్దపరిచివురొ గాక. తో ఆత్మ, జీవము దేకు అమె ప్రబువుయిలా యేసుక్రీస్తు అయిలబెల్లె నిందానీలపనికిరి, సంపూర్నంగా రొల్లపనికిరి కాపాడిమాసి. ");
INSERT INTO rei_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","తొముకు డక్కిలాట నమ్మకం యీలాట గనక సెయ్యె సాకిరి కొరుసి. ");
INSERT INTO rei_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","అన్నబయినె, అమె కోసం ప్రార్దన కొరండి. ");
INSERT INTO rei_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","పవిత్రమైలా చుమ్మోలొగ్గికిరి అన్నబయినె సొబ్బిలింకె దండమూనె కొరొండి. ");
INSERT INTO rei_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","అన్నబయినె సొబ్బిలింకె ఏ పత్రిక చదివికిరి సుందెమంచెబులి ప్రబువు నారె తొముకు ఆదేసించిలించి. ");
INSERT INTO rei_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","అమె ప్రబువైలా యేసుక్రీస్తు క్రుప తొముకు తోడైకిరి రొమ్మాసి.");
INSERT INTO rei_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","అం బో యీల పురువు దీకిరి ప్రబువైల యేసుక్రీస్తురె రొల్ల తెస్సలోనిక సంగముకు పౌలు, సిల్వాను, తిమోతి సుబం బులి కొయికిరి రాసిలాట. ");
INSERT INTO rei_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","బో యీల పురువుదీకిరి ప్రబువైల యేసుక్రీస్తుదీకిరి క్రుప సమాదానము తొముకు కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","అన్న బయి అప్పబొయినినె, అమె కెబ్బుకు తొం గురించి పురువుకు క్రుతజ్ఞతాస్తుతులు చెల్లించితె ప్రేమకలిక్కిరి అచ్చొ. యెడ బొల్టాక క్యాకిరిబుల్నే తొం విస్వాసము దినొదినొ బడే అబివ్రుద్ది కలిగిలీసి. తొమె సొబ్బిలింకె బిత్తరె ప్రతిలింకె ఎదుటిలింకె ఉంపరెదిగిదెల్లా ప్రేమా విస్తరించిలీసి. ");
INSERT INTO rei_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","సడవల్లరె తొం హింసలు సొబ్బిటిరె, తొమె సహించితల్లా స్రమానెబిత్తరె, తొం ఓర్పుకు విస్వాసముకు దిక్కిరి, అమె పురువురొ సంగములురె తొం వల్లరె అతిసయపొడిలించొ. ");
INSERT INTO rei_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","కెడకోసం తొమె స్రమపొడిలీసొవొ సె పురువురొ రాజ్యముకు తొమె యోగ్యునె బులి బచ్చిగివురొవల్లరె, తొమె యాకిరి ఓర్చుగివురొ పురువురొ న్యాయమైలా తీర్పురె తొమె యోగ్యులైకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","తొముకు స్రమలొగిలాలింకు స్రమానె, స్రమపొడితల్లా తొముకు అం దీకిరి కూడ విస్రాంతి దీతందుకు పురువుకు న్యాయమాక. ");
INSERT INTO rei_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","పురువుకు నాజనిలాలింకు, అం ప్రబువైలా యేసు సువార్తకు నాలోబొడిలలింకు ప్రతిదండన కొరుసి. ");
INSERT INTO rei_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","ప్రబువైలా యేసు తా ప్రబావంకు దిగిదిల్లా దూతలసంగరె కూడ పరలోకముదీకిరి నియ్యజొల సంగరె దిగిదీకిరి, ");
INSERT INTO rei_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","సెయ్యె తా ప్రబావం తీకిరి ఏర్పరిచిగిల్లాలింకు నిత్యమైలా సిక్సకు ఒప్పకొయివొ. ");
INSERT INTO rei_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","తా సముకము దీకిరి సెయ్యె ప్రబావమురొ మహిమదీకిరి గొడ్డికిరి, నిత్యనాసనము బుల్లా సిక్స పొందిగివ్వె. క్యాకిరిబుల్నే అమె తొముకు దిల్లా సాక్స్యము తొమె నమ్మిసొ. ");
INSERT INTO rei_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","సడసంగరె అం పురువువల్లరె ప్రబువైలా యేసు క్రీస్తువలరె క్రుప దీకిరి తొంబిత్తరె అం ప్రబువైలా యేసు నారె తా సంగరె తొమె మహిమపొందిలాపనికిరి, ");
INSERT INTO rei_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","మేలు కొరిమాసిబులి తొముకు కలిగిలా ప్రతి ఆలోచనకు, విస్వాసయుక్తమైలా ప్రతీ కార్యముకు బలందీకిరి సంపూర్నము కొరికుంటా, అం పురువు తా డక్కకు తొముకు యోగ్యునెగా బచ్చిగిల్లాపనికిరి తొం కోసం కెబ్బుకూ ప్రార్దన కొరిలించొ. ");
INSERT INTO rei_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","ఈనె మో అన్నబయినె, అప్పబొయినినె అం ప్రబువైలా యేసుక్రీస్తు అయిలాబెల్లె, అమల్లా తా సంగరె మిసికిరి తైతందుకు, తొముకు బతిమాలిగిల్లించి తొమె బేగా మనుసూన్రె కలవరం నీకుంటా, నా బెదురుకుంటా తమ్మాసిబులి కోరిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","ఈనె యెడ కోసం అం బోదరె, ప్రవచనాల్రె, ఇంకా ఉత్తరాల్రె కొయివురొ ఈనన్నా అం ప్రబువు దినొ ఉంచినాక అయిలాపనికిరి కొయినెను తొం ఆలోచనల్రె గాని కొతాన్రె గాని కలవర పొడితెనాండి. ");
INSERT INTO rei_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","దర్మసాస్త్రముకు నాలోబొడిలాట చివరి విరోదినాయికుంటా సే దినొ అయిని. సడవల్లరె కేసైనను, కేవిదంగా యీనెను మోసం నాయీజీకుంటా దిగ్గునొండి. తా గమ్యం నరకం. ");
INSERT INTO rei_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","యెయ్యె పురువుబులి కోసి, కిర పూజింపబొడుసొ, సడానుకల్లా ఎదిరించుకుంటా, సడంపరల్లా తాకు సెయ్యాక హెచ్చించిగీకుంటా, సెయ్యె పురువుబులి, పురువొ మందిరంరె బొసురుసి. ");
INSERT INTO rei_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","మియ్యి తొంసంగరె తల్లబెల్లె ఎడల్లా తొముకు కొయించి. సడ తొముకు గుర్తునీనా? ");
INSERT INTO rei_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","ఈనె దర్మవిరోది తా సొంత కల్రె పొదరె పొడుసిబులి. తాకు అడ్డగించిలాట కిడో తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","ఈనె సెయ్యె ఉంచినె స్రమపొడితల్లాలింకు అం దీకిరి కూడా నెమ్మది దూసి. ఈనె యెడానెల్లా ప్రబువైలా యేసు తా గొప్ప దేవదూతానె దీకిరి దిగిదిల్లాబెల్లె కొరుసి. ");
INSERT INTO rei_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","సెయ్యె నియ్యజొలానె సంగరె అయిలాబెల్లె కేసైనే పురువుకు నిరాకరించిలీసెవొ ఈనె అం ప్రబువైలా యేసుక్రీస్తు సువార్తకు నాఅంగీకరించిలాలింకు సిక్సించుసి. ");
INSERT INTO rei_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ప్రబువు తాగొప్ప మహిమ అగరె తంకు ప్రత్యేకపర్చికిరి నిత్యమైలా సిక్సదీకిరి నాసనముకు పొడదూసి. ");
INSERT INTO rei_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","తా మహిమదీకిరి అయిలా దిన్రె విస్వసించిలాలింకల్లకు ఇంకా తా ప్రజానెకు ప్రసంసించుసి. కైంకిబుల్నే అమె తొముకు కొయిలా సందేసం తొమె నమ్మిసొ. ");
INSERT INTO rei_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","మేలు కలిగిమాసిబులి తొంబిత్తరె విస్వాసం సంగరె కలిగిలా ప్రతీ ఆలోచన, ప్రతీపైటి బలముసంగరె సంపూర్తి కొరితల్లా అం పురువురొ డక్కకు తొమె యోగ్యులుగా బచ్చిమాసిబులి తొంకోసం కెబ్బుకూ ప్రార్దనకొరిలించొ. ");
INSERT INTO rei_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","యే విదంగా అం పురువురొ, అం ప్రబువైలా యేసుక్రీస్తురొ క్రుప వల్లరె తొందీకిరి అం ప్రబువైలా యేసురొ నా ఇంకా తాదీకిరిపాటు తొమ్మంకా మహిమపొందివొ. ");
INSERT INTO rei_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","ప్రబువు ప్రేమించిలా అన్నబయినె అప్పబొయినీనె, ఆత్మ తొముకు పరిసుద్దపర్చిలందరె, తొమె సత్యముకు నమ్మిలందరె, రక్సన పొందితె పురువు తొముకు అగుంత దీకిరి బచ్చిగిచ్చి గనక అమె తొంవల్లరె కెబ్బుకు పురువుకు క్రుతజ్ఞతాస్తుతులు చెల్లించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","తొమె యాకిరి రక్సంపబొడికిరి అం ప్రబువైలా యేసుక్రీస్తురొ మహిమకు పొందిమాసిబులి, సెయ్యె అం సువార్త వల్లరె తొముకు డక్కిసి. ");
INSERT INTO rei_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","ఈనె అన్నబయినె అప్పబొయినీనె, కెబ్బుకు గుటెపనాక రొయికిరి అమె తుండొ కొతవల్లరె యీనెను అం పత్రిక వల్లరె యీనెను తొముకు సత్యమురె బోదించిలా విదానాల్రె స్తిరంగా రొండి. ");
INSERT INTO rei_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","అం ప్రబువైలా యేసు క్రీస్తుకు, అముకు ప్రేమించికిరి, తా క్రుపరె నిత్యమైలా ఆదరన, ఇంకా నిచ్చయత, నిరీక్సనకు అనుగ్రహించిమాసి. ");
INSERT INTO rei_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","సాకిరాక బొల్టకొయివురొ విసయంరె కెబ్బుకూ జొనుకు జొనె ప్రోత్సాహించిగీకుంటా బలపర్చిగీండి. ");
INSERT INTO rei_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","చివరగా అం అన్నబయినె అప్పబొయినీనె, తొం మొజిరె జరిగితల్లా పనికిరి ప్రబువు వాక్యము బడే వ్యాపించికిరి మహిమపర్చిలా నిమిత్తం అం కోసం ప్రార్దన కొరొండి. ");
INSERT INTO rei_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","సాకిరాక అమె మూర్కులు ఇంకా దుస్టులుతీకిరి తప్పించిగిల్లా పనికిరి అమె కోసం ప్రార్దన కొరొండి; ఈనె అంకొతానంపరె తంకు సొబ్బిలింకు విస్వాసంనీ. ");
INSERT INTO rei_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","ఈనె ప్రబువు నమ్మదగిలాట; సెయ్యె తొముకు స్తిరపర్చికిరి దుస్టుడుతీకిరి కాపాడువొ. ");
INSERT INTO rei_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","అమె తొముకు ఆజ్ఞాపించిలాంచకు తొమె కొరిలీసొ బులి, ఇంకా కొరువొబులి ప్రబువురె తొం గురించి నమ్మకము కలిగికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","పురువురె ప్రేమ, క్రీస్తు దిగిపించిలా ఓర్పు తొముకు కలిగిలాపనికిరి ప్రబువు తొమె మనుసూనెకు ప్రేరెపించుసి. ");
INSERT INTO rei_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","అం అన్నబయినె అప్పబొయినీనె, అంవల్లరె పొందిలా బోద ప్రకారము నాకొరికిరి బద్దకముగా సలిగిల్లా ప్రతి అన్నబయినె పక్కరెతీకిరి తొలగిజిమ్మాసిబులి అమె ప్రబువు యీల యేసు క్రీస్తు నారె తొముకు ఆజ్ఞాపించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","అముకు పోలి క్యాకిరి సలిగిమ్మాసివొ తొముకు తెలుసు. అమె తొం మొజిరె బద్దకముగా సలిగిల్లానింతొ. ");
INSERT INTO rei_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","కాపక్కరె సుచ్చరె కద్ది కడిగిల్లానింతొ. అమె తొంబిత్తరె కాకూ బారంగా రొన్నాసిబులి ప్రయాస సంగరె కస్టాలుసంగరె రత్తిదూసు పైటికొరికుంటా జీంచొ. ");
INSERT INTO rei_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","తొమె అముకు పోలికిరి సలిగిమంచెబులి అముకు అమె మాదిరిగా దిగిపించిగిమ్మాసిబులి యాకిరి కొరించొ. ఈనె అముకు తొంవుంపరె అదికారం నీకిరి నీ. ");
INSERT INTO rei_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","ఈనె అమె తొంపక్కరె తల్లాబెల్లె కేసైనెను నాపైటికొర్నే సెయ్యె కద్దికైనాసిబులి తొముకు ఆజ్ఞదీంచొ నీనా! ");
INSERT INTO rei_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","తొంబిత్తరె కుండెలింకె కేపైటి నాకొరికుంటా పొదలింకె జోలుకు జేకుంటా, బద్దకముగా సలిగిల్లీసొబులి సునిలించొ. ");
INSERT INTO rei_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","సాలింకె మెల్లిగ పైటికొరికుంటా, సొంతముగ సంపాదించిగిల్లా కద్ది కైమంచిబులి అం ప్రబువైలా యేసుక్రీస్తు నారె తంకు ఆజ్ఞపూర్వకముగా హెచ్చరించిలించొ. ");
INSERT INTO rei_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","ఈనె అన్నబయినె తొం యీనె బొల్ట పైటినె కొరితె విసిగితెనాండి. ");
INSERT INTO rei_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","ఏ పత్రికవల్లరె అమె కొయిలా కొతానుకు కేసైనెను నాలొబొడినె తంకు కనిపెట్టికిరి, సెయ్యె లజ్జొపొడిలపనికిరి తాసంగరె స్నేహం కొరితెనాండి. ");
INSERT INTO rei_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","ఈనెను తంకు సత్రువూనెగా నాదిక్కిరి అన్నబయినె బులిగీకిరి బుద్దికొండి. ");
INSERT INTO rei_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","సమాదానకర్తైలా ప్రబువు సెయ్యాక కెబ్బుకూ ప్రతి విదముసంగరె తొముకు సమాదానం అనుగ్రహించుసి. ప్రబువు తొముకు తోడైకిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","పౌలు బుల్లా మియి మో సొంత అత్తొ సంగరె వందనముబులి రాసిలించి. ప్రతి పత్రికరె మీ క్యాకిరి రాసించొ యెడాక ప్రత్యేకించితె గుర్తు. ");
INSERT INTO rei_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","అం ప్రబువైలా యేసుక్రీస్తు క్రుప తొముకల్లా తోడైకిరి రొమ్మాసి.");
INSERT INTO rei_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","అం రక్సకుడైలా పురువు వల్లరె అం నిరీక్సన యీల క్రీస్తుయేసు రొ ఆజ్ఞ ప్రకారము క్రీస్తుయేసు రొ అపొస్తులుడు యీలా పౌలు రాసితల్లా సంగతీనె. ");
INSERT INTO rei_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","విస్వాసము వల్లరె మో సొత్తైల పో యీలా తిమోతికు సుబం బులి కొయికిరి రాసిసి. బో యీలా పురువుసంగరె అమె ప్రబువైల క్రీస్తుయేసు దీకిరి క్రుప కనికరముకు సమాదానము తొత్తె కలుగుసి గాక. ");
INSERT INTO rei_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","మియ్యి మాసిదోనియకు జేతన్నుగా సొరొబోదానె కొరితల్లా కుండెలింకు హెచ్చరించితందుకు మియి తొత్తె ఎపెసురె రొమ్మాసిబులి ఆజ్ఞాపించించి. ");
INSERT INTO rei_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","కల్పించిల కతానె హద్దులునీలా వంసావలీనె, విస్వాస సంబందమైలా పురువురొ ఏర్పాటు నీకుంటా వివాదము పుట్టించితల్లా ఎడానుకు సడదిమ్మాసిబులి తంకసంగరె కో బులిసి. ");
INSERT INTO rei_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","ఉపదేసం సారము కిరబుల్నే, బొల్ట హ్రుదయందీకిరి, బొల్ట మనసాక్సిదీకిరి, నిస్కపటమైలా విస్వాసముదీకిరి కలిగితల్లాట ప్రేమాక. ");
INSERT INTO rei_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","కుండెలింకె యెడానుకు సడికిరి బాజీకిరి, తంకె నాపైటికైలా బోదానెరె పొడిజీసె. ");
INSERT INTO rei_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","తంకె కొయిలాట యీనెను, నిచ్చయమైలపనికిరి రూడిగా కొతానెకైనెనూ అర్దం నాకొరిగిన్నార్నన్నా దర్మసాస్త్రంరొ ఉపదేసకులైకిరి రొమ్మాసి బులిగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","దర్మసాస్త్రము సడ ఉపయోగించిలాటకు దరికిరి, సడ బొల్టబులి అముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","ఈనె యే దర్మసాస్త్రము బొల్టలింకు కోసం దిల్లానీబులి జ్ఞాపకం దీగీండి. దర్మవిరోదూనెకు, అవిదేయునెకు, బక్తిహీనునెకూ, పాపోనెకూ, అపవిత్రూనెకు, మతదూసకునెకూ, మా బోనుకు మొరదిల్లాలింకూ, నరహంతకునెలింకాక. ");
INSERT INTO rei_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ఇంకా దర్నిపైటికొర్లాలింకు, పురుసుసంయోగులుకు మనమానుకు చొరిపీలాలింకు, చొరొకొతానె కొయిలాలింకు, చొరొకొతాలగిలలింకు, చొరొసాక్సం కొయిలాలింకు, ఇంకా బొల్టబోదకు విరోదంగా కొతలగిలాలింకు దీసి. ");
INSERT INTO rei_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","మహిమగల్లా ఆసీర్వాదముకు కారనమైలా పురువుదీకిరి మెత్తె ఒప్పకొయిలా యే ఉపదేసము సువార్తలురె రొయిదివ్వురొ ఈసి. ");
INSERT INTO rei_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","మెత్తె బలపరిచికి తా పరిచర్యకు నియమించికిరి అమె నమ్మకైలాట పనికిరి బచ్చిగిల్లా ప్రబువుయిలా క్రీస్తు యేసుకు క్రుతజ్ఞతలు చెల్లించిలించి ");
INSERT INTO rei_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","కైంకిబుల్నే అగరె కల్రె దూసించిలాట, హింసిచిలాట, బాదించిలాటైలా మెత్తె, పురువుంపరె విస్వాసం నీనన్ననూ, కిరకొరిలించొ మీ నాజనినన్నా. పురువు మో ఉంపరె కనికరము దిగదీసి మియి నా తెలిసికిరి అవిస్వాసము వల్లరె కొరించి గనక కనికరింపబొడించి. ");
INSERT INTO rei_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","ఈనె అం ప్రబువురొ క్రుప, క్రీస్తు యేసు ద్వారా విస్వాసమును ప్రేమ, అత్యదికముగా అనుగ్రహించిసి. ");
INSERT INTO rei_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","మియి సొత్తాక కొయిలించి పాపోనెకు రక్సంచితె క్రీస్తుయేసు లొకొకు అయిలాపని వాక్యము నమ్మితె పూర్నాంగీకారమైలాట. సే పాపోనె బిత్తరె మియ్యి అగరోట. ");
INSERT INTO rei_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","ఈనెను నిత్యజీవము నిమిత్తము తాకు విస్వాసించిలాలింకు మియ్యి మాదిరిగా రొల్లపనికిరి యేసు క్రీస్తు తా పూర్నమైలా దీర్గసాంతముకు సె ప్రదాన పాపియిలా మోవుంపరె దిగిదీలాపనికిరి మియ్యి కనికరింపబొడించి. ");
INSERT INTO rei_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","సకల యుగమునెరె రొజైకిరి, అద్రుస్యుడైలా అద్వితీయ పురువుకు గనత మహిమ కెబ్బుకూ కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","మో పోయీలా తిమోతి, తువ్వు విస్వాసమురె బొల్ట మనస్సాక్సి కలిగిలాటయీకిరి, తో కోసం అగరాక కొయిలా ప్రవచనములు, ఏ బొల్ట పోరాటం పోరాడివాసిబులి సడకు ఏ ఆజ్ఞకు తొత్తె అప్పగించిలించి. ");
INSERT INTO rei_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","బొల్ట మనస్సాక్సికు కుండిలింకె వొంకిదీకిరి, విస్వాసంరె తొలిగిజికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","తంకె బిత్తరె హుమెనై, అలెక్సంద్రు అచ్చె. అంకె ఇంకా నాదూసించకుంటా సిక్సింపబొడితాక సాతానుకు అప్పగించించి. ");
INSERT INTO rei_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","అగుంతా తొమల్లా ప్రజానె కోసం పురువుకు ప్రార్దనలు, విజ్ఞాపనలు, క్రుతజ్ఞతలు కొరుమాసిబులి ఆజ్ఞాపించిలించి. ");
INSERT INTO rei_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","అమె నెమ్మదిగా, సుకముగా జీతే నిమిత్తము, బుల్నే, రొజానె కోసం, అదికారినెసొబ్బిలింకె కోసం, పొదరలింకె కోసం విజ్ఞాపనానె, ప్రార్దనలు కొరొండి. ");
INSERT INTO rei_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","యడ బొల్టట అమె రక్సకుడుయిలా పురువురొ అంకికి అనుకూలమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","తా, మనమానె సొబ్బిలింకె రక్సనకడిగీకిరి సత్యము గురించి అనుబవజ్ఞానముగలిగిల పనికిరి రొమ్మంచెబులి ఆసపొడిలీసి. ");
INSERT INTO rei_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","పురువు జొన్నాక, పురువుకు మనమానెకు మొజిరె తల్లాట జొన్నాక; సెయ్యె క్రీస్తుయేసు బుల్లా మనమ. ");
INSERT INTO rei_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","సెయ్యె సొబ్బిలింకు కోసం విమోచన కలిగిమంచెబులి తాకు సెయ్యాక సమర్పించిగినిసి. యడ గురించిలా సాక్య్సము దీతె సరైలా కలొరె దివ్వొరొయిసి. ");
INSERT INTO rei_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","ఏ సాక్య్సము దీతందుకు మియ్యి ప్రకటించిలలింకెపని, అపొస్తులుడుగా, విస్వాసము, సత్యము విసయమురె పురువుకు నా నమ్మిగిలలింకు బోదకొలలింకెగాను నియమించిసి. మియ్యి సొరొకొతా కొయిలాని సొత్తాకా కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ఈనె ప్రతిస్తలమురె వొండ్రపొ రగ్గొకు వాదనలకు సడికిరి, పవిత్రమైలా అత్తోనె సంగరె ప్రార్దన కొరిమంచెబులి కోరిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","ఈనె తిల్డ్రపిల్లానె అనుకువుగా తైకిరి, స్వస్తబుద్దీ గలిగిలాట ఈకిరి, సరైలా కొన్నానె పిందిగీకిరి, సోకుజటానెదీకిరి ఈనెను, సున్నదీకిరి ఈనెను, ముత్యములుదీకిరి ఈనెను బడే కరీదైల కొన్నానె సంగరె అలంకరించిగిన్నాసి. ");
INSERT INTO rei_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","ఈనె పురువురొబక్తి కలిగిలా తిల్డ్రాపిల్లనుకు, తగిలపనికిరి బొల్టపైటీనె సంగరె తంకు తంకాక అలంకరించిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","తిల్డ్రపిల్ల వల్లాగ రొయికిరి, సంపూర్న విదేయతదీకిరి సుగ్గీమంచి. ");
INSERT INTO rei_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","తిల్డ్రాట వల్లగా రొమ్మంచిగాని, ఉపదేసంచితె ఈనెను, వండ్రపొ ఉంపరె బొడతనం కొరితె ఈనెను తాకు అదికారం దిల్లానీ. ");
INSERT INTO rei_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","అగరె ఆదాముకు తరువాతరె హవ్వకు నిర్మించబొడిసె నీనా? ");
INSERT INTO rei_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ఈనె ఆదాము మోసపొడిచిలాని గాని, తిల్డ్రాట మోసపొడికిరి పురువురొ ఆజ్ఞకు మీరిసి. ");
INSERT INTO rei_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","ఈనెను తంకె స్వస్తబుద్ది కలిగికిరి, విస్వాస ప్రేమ, పరిసుద్దతసంగరె నిలకడగాటారికిరి తన్నె, సిసుప్రసూతి సంగరె సెయ్యె రక్సింపబొడిసి. ");
INSERT INTO rei_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","కేసెనైను సంగమురె బొడొపదవి ఆసించిలపనా సెటెలింకు బొడొపైటి అపేక్సించించిలీసొ బులి కొతా నమ్మదగిలాట. ");
INSERT INTO rei_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","బొడ మనమ యీలట నిందారహితుడును, జొన్నాక నైపొ వండ్రపొకు, మితానుబవుడును, స్వస్దబుద్దిగలిలలింకె, మర్యాదదిల్లలింకె, అతిదిప్రియుడుకు, బోదించితె తగిలాటైకిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","మొద్దొ నాపీలాటైకిరి తవ్వాసి, రగ్గొ తన్నాసి, సాత్వికుడైకిరి మర్యాద తైకిరి, కొలీనె నాలగిలాట పనికిరి, పలియ ఆస తన్నాసి. ");
INSERT INTO rei_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","సంపూర్న మాన్యత కలిగికిరి, తా పిల్లానుకు బొల్ట బట్టొరె సలిపించిగీకిరి, తా గొరొలింకు బొల్లెఏలిలాటైకిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","కేసైనెనూ తా గొరొలింకు సరిగా దిగినార్నే, సెయ్యె పురువురొ సంగముకు క్యాకిరి దిగిపారి? ");
INSERT INTO rei_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","సెయ్యె గర్వాందుడైకిరి తన్నాసి, అపవాదికు కలిగిలా సిక్సావిదికి నాలోబొడిలాపనికిరి పరిపూర్న విస్వాసం కలిక్కిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","ఈనె సెయ్యె నిందపాలు నాయీకిరి, మనమానె సొబ్బిలింకు సంగరె గౌరవించబొడిమాసి. అపవాది వలరె నా పొడుకుంటా, సంగము బయలురె బొల్ట సాక్స్యము కలిగిలాటపనికిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","సాకిరాక పరిచారకులు మాన్యులైయికిరి, దీరజిబ్బొ కలిగిలాలింకె, మొద్దొపీకారీనె, దుర్లాబముకు ఆసించిలాలింకె పనికిరి రొన్నాసి. బొల్ట బుద్ది కలిక్కిరి రొమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","తంకె పవిత్రమైలా విస్వాస సత్యంకు పవిత్రమైలా మనస్సాక్సి దీకిరి కొయితె కలిక్కిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","ఈనె తంకె అగరె పరీక్సింపబొడిమంచి. తరువాత తంకె అనింద్యులు ఈనె పరిచారకులుగా రొవ్వొచ్చు. ");
INSERT INTO rei_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","సాకిరాక పరిచర్యకొరిలాలింకెరో నైపోనె పొదరలింకు గౌరవించికిరి, బొల్ట గునొ కలిక్కిరి, నీలాకొతానె నాకొయిలలింకె పనికిరి, తగ్గించిగిల్లా స్వబావము కలిగీకిరి, సొబ్బి విసయములరె నమ్మకంగా రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","పరిచర్య కొరిలాలింకు జొన్న నైపోక తవ్వాసి. సెయ్యె తా పిల్లలకు తా గొరొలింకు బొల్లె దిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","పరిచారకులు ఈలలింకె సే తా పైటి బొల్లే కొరిలాటైకిరి తమ్మాసి. బొల్ట పదవికు సంపాదించిగీరి క్రీస్తుయేసు బిత్తరె విస్వాసం దీకిరి బడే దైర్యము కలిగిలాలింకె యీపారె. ");
INSERT INTO rei_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","తో పక్కు బేగా అయికిరి తొత్తె దిగిమాసిబులి నిరీక్సన సంగరె యే ఉత్తరం తొత్తె రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","ఈనెను మియ్యి ఆలస్యం కొరువురొ వల్లరె పురువురొ మందిరమురె, జీవముగల పురువురొ సంగమురె, తువ్వుకాకిరి ప్రవర్తించిమాసొ సెడ తొత్తె జనిమంచి బులి యే సంగతినెకు తొత్తె రాసిలించి. సె సంగము సత్యమునకు ఆదారమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","దైవ బక్తి గురించి కేసే నిరాకరించినార్లా నుచ్చిదిల్లా సంగతి అచ్చి. సెయ్యె ఆత్మద్వారా నీతిపరుడుబులి దిగిపించబొడికిరి మనమరూపం దరించిగీకిరి దేవదూతానె సంగరె దిగదూసి. సెయ్యె ప్రపంచరె రొల్లాసొబ్బిలింకె నమ్మిలాపనికిరి సొబ్బి దెసోన్రె రక్సన ప్రకటించికిరి సెత్తెలెపరలోకముకు ఆరోహనమైజోసి. ");
INSERT INTO rei_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","ఈనె ఆత్మ తేటగా కయివురొ కొయిలాట కిరబుల్నే, యే చివరి దినోన్రె కుండెలింకె సొరొకొతా వేసదారన వల్లరె మోసంకొర్లా ఆత్మలదీకిరి. బుత్తోనె బోదరె లక్స్యం లొక్కిరి, విస్వాస బ్రస్టునె ఈజేసె. ");
INSERT INTO rei_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","సె సొరొకొతా, సుర్రకా పొగిల మనస్సాక్సియీలాలింకె పని చెడు బోద కొరిలీసె. ");
INSERT INTO rei_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","బ్యా నిసేదించికిరి, సత్యవిసయమైకిరి అనుబవజ్ఞానముగల విస్వాసీనె క్రుతజ్ఞతాస్తుతులు చెల్లించికిరి కడిగిల్లా నిమిత్తము పురువు స్రుస్టించిలా కద్ది వస్తువునుకు కుండె కైయివురొ మానిపింమంచెబులి కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","పురువు స్రుజించిలా ప్రతి వస్తువు బొల్టాక. క్రుతజ్ఞతాస్తుతులు చెల్లించికిరి కడిగిల్లాబెల్లె కిచ్చి కూడా నిసేదించిలాటనీ. ");
INSERT INTO rei_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","క్యాకిరిబుల్నే సడ పురువురొ వాక్యము వల్లరె ప్రార్దన వల్లరె యీనెను పవిత్రం కొరివురొ ఊసి. ");
INSERT INTO rei_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","ఏ సంగతీనెకు అన్నబయినెకు వివరించినె, తువ్వు అనుసరించికిరి అయితల్లా విస్వాస సుబోద సంబందమైలా వాక్యము సంగరె బొడుకుంటా క్రీస్తుయేసుకు బొల్ట పరిచారకుడయికిరి తాసు. ");
INSERT INTO rei_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","అపవిత్రమైలా మొంత్రినె కొతానె సడిదికిరి, దేవబక్తి విసయమురె తొత్తె తువ్వు సాదకము కొరిగును. ");
INSERT INTO rei_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","దే సంబందమైలా పైటి కుండెమట్టుకు ఉపయోగంవుసిగాని దైవబక్తి ఉంచినె జీవం విసయమురె అయితల్లా విసయమునెరె వాగ్దానము సంగరె కూడా సొబ్బి విసయమురె ఉపయోగకరంగా ఊసి. ");
INSERT INTO rei_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","ఏ వాక్యము సత్యమైలాట సడకు నమ్మిలాట పూర్నాంగీకారముకు యోగ్యమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","మనమానెసొబ్బిలింకు రక్సకుడు, ఈనె విసేసముగా విస్వాసులకు రక్సకుడైలా జీవముగల పురువురె అమె నిరీక్సన రొగ్గించొ గనుక యడ నిమిత్తము ప్రయపొడికిరి పాటుపొడిలించొ. ");
INSERT INTO rei_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","ఏ సంతులు తంకు కొయికిరి బోదించొండి. ");
INSERT INTO rei_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","తొ బెండకలో కేసెను తొత్తె సన్నిదిగ నాదికుంటా, కొతానెదీ, ప్రవర్తనదీ, ప్రేమదీ, విస్వాసముదీ, ప్రవిత్రరె, విస్వాసునెకు మాదిరిగా రోండి. ");
INSERT INTO rei_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","మియ్యి అయిలా జాంక చదివిలాటరె, హెచ్చరించిటిరె బోదించుటరె జాగర్తాగ రొండి. ");
INSERT INTO rei_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","బొడిలింకె హస్తనిక్సేపనము కొరిలాబెల్లె ప్రవచనము తొత్తె అనుగ్రహించబొడిలాబెల్లె తొబిత్తరె ఆత్మ వరముకు నిర్లక్స్యం కొరితెనా. ");
INSERT INTO rei_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","తో అబివ్రుద్ది సొబ్బిలింకు తేటగా దిగిదిల్లా నిమిత్తము ఎడకు మనుసుపూరు సాదన కొరొండి. ");
INSERT INTO rei_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","తో గురించి తో బోద గురించి జాగర్త కలిక్కిరొ. ఎడబిత్తరె బొల్లకిరి రొ; తువ్వు యాకిరి కొరికిరి తువ్వు తో బోద సునిలాలింకు రక్సించుగునుసు. ");
INSERT INTO rei_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","బొడిలింకు నాగద్దించుకుంటా బోపనికిరి బావించికిరి కోండి. బెండలింకు అన్నబయినెగా బావించిగీండి. ");
INSERT INTO rei_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","వయసురె బొడుమొట్టానెకు మానె పనికిరి బులిగీండి, పూర్తిపవిత్రతరె దిండ మొట్టానెకు అప్పబొయినినె బులిగికిరిబావించొండి. ");
INSERT INTO rei_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","సొత్తాక అనాదులైలా రండిలింకు గౌరవించొండి. ");
INSERT INTO rei_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","ఈనె కె రండిలింకె యీనెను పిల్లానె గాని నత్తిని గాని నత్తి గాని రొల్లాపనైనే, అంకె అగరె తా గొరొలింకు బక్తి దిగదీతె, తంకె మా బోకు ప్రత్యుపకారము కొరితందుకు సుగ్గిమ్మంచె; యెడ పురువురొ అంకికి బొల్టైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ఈనె సొత్తాకా కేసేనీలా రండింట జొన్నాక తన్నె, పురువు ఉంపరె తా నిరీక్సనరొయిదిగీకిరి, విజ్ఞాపనలబిత్తరె ప్రార్దనబిత్తరె రత్తిదూసు పురువు సహాయం కోసం దిగిమంచె. ");
INSERT INTO rei_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","సుకబోగములుబిత్తెరె ప్రవర్తించిలాట జీకిరి రొన్నన్నా మొరిజిల్లాలింకె పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","తంకె నిందారహితులైకిరి రొల్లాపని యాకిరి ఆజ్ఞాపించండి. ");
INSERT INTO rei_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","ఈనె కేసె యీనెను స్వకీయునెకు, విసేసముగా తా గొరొలింకు, నాసంరక్సించిగిన్నే సెయ్యె విస్వాసత్యాగము కొరిలాటపనికిరి అవిస్వాసికన్నా చెడ్డాటైకిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","అరవై బొచ్చొరోనె కన్నా తక్కువ వయస్సు నీకుంటా, జొనె వండ్రపోకాక నైపోయీకిరి తన్నే రండింటగా గొనివొచ్చు. ");
INSERT INTO rei_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ఈనె బొల్టక్రియలకు నా కడిగిల్లా రండింట తా పిల్లనెకు పుసికిరి, పరదేసునెకు ఆతిద్యందీకిరి, పరిసుద్దులురొ గొడ్డొనె దొయికిరి, స్రమపొడిలాలింకు సహయము కొరికిరి, ప్రతి సత్కార్యము కొరితె సమర్పించిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","ఈనె బెండలింకయిలా రండిలింకు లెక్కరె చేర్చిగిత్తెనాండి; కిరకుబుల్నే అంకె క్రీస్తుకు సడికిరి లొకొ ఆసానెరె పొడికిరి ఇంకా బ్యా కొరిగిమ్మాసి బులిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","ఈనె తంకె అగరెకొరిలా ప్రమానంకు సడదీసెబులి తీర్పుపొందిలాలింకైకిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","ఈనె తంకె గొరొ గొరొకు బుల్లుకుంటా, సొమరులయితె మాత్రమాక నీకిరి, నాకొతలగిలా కొతానెకొయికుంటా, పొదర్లింకెజోలికు జేకుంటా అచ్చె. సమాయంకు వ్యేదం కొరికుంటా కలిగిలలింకె పనికిరి తాసె. ");
INSERT INTO rei_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","గనక దిండతిల్డ్రపిల్లనె బ్యాకొరిగీకిరి పిల్లానె బేయికిరి గొరొకు జాగర్తాగ దిగ్గీకుంటా, నిందించితె విరోదికు అవకాసం దివ్వురొ బొల్టనీబులికోరిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","యెడకగరాక కుండిలింకె బట్టొదీకిరి బాజీకిరి సాతానుకు వెంబడించిసె. ");
INSERT INTO rei_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","విస్వాసురాలైలా కె మొట్టరొ గొరొయీనెను కుటుంబంరె యీనెనూ రండిలింకె తన్నెమాను, సంగముకు బారమునీకుంటా రండిలింకు సహాయము కొరొండి. సెల్లె సంగం సొత్తాక దిక్కునీలాలింకు సాయంకొరిపారి. ");
INSERT INTO rei_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","బొల్లకిరి పాలనకొరిలా బొడిలింకె, విసేసముగా వాక్యమురె సుక్కిలాబిత్తరె, ఉపదేసము కొయిలాటబిత్తరె ప్రయాసపొడిలాలింకె, దీటొంతునె సన్మానముకు అర్హులుగా బచ్చిమంచె. ");
INSERT INTO rei_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","సడకు లేకనము కొయిలాపనికిరి నూర్చితల్లా ఎద్దురొమూతికు చిక్కము పొగితెనాండి కిరుకుబుల్నే పైటితా బొర్తొనొకు అర్హతయిలాట. ");
INSERT INTO rei_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ఈనె దీలింకె తిల్లింకె సాక్సీనెరొన్నె గాని బొడిలింకె ఉంపరె నిందకు అంగీకరించితెనా. ");
INSERT INTO rei_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","పొదరిలింకె డొరెపొడిలా పనికిరి పాపము కొరిలాలింకు సొబ్బిలింకె అగరె గద్దించు. ");
INSERT INTO rei_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","దుస్టబుద్ది సంగరెయీనెను పక్సపాతము సంగరెయీనెను కిచ్చినాకొరుకుంటా, మియ్యి మీ కొయిలా కొతానుకు సునిమంచెబులి పురువు అగరె, క్రీస్తుయేసు అగరె, బచ్చిగిల్లా దేవదూతానె అగరె తొత్తె గద్దించిలించి. ");
INSERT INTO rei_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","పురువు పైటికోసం బచ్చిగిత్తె బేగా కా అంపరె యీనెను అత్తొపొగితెనాండి. పొదరిలింకెరొ పాపమురె పాలితాయీకిరి రొయితనాండి. తువ్వు పవిత్రముగా రొల్లాపనికిరి దిగ్గును. ");
INSERT INTO rei_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ఈనె పనినాపీకుంటా తో పెట్టొ జబ్బుకు కెబ్బుకూ అయిలా బలహీనతానె కోసం ద్రాక్సారసము కూడా కుండె కడిగునొండి. ");
INSERT INTO rei_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","కుండెలింకె పాపము బొల్లె దోరెపొడికిరి న్యాయపు తీర్పుకు అగరాక సలిలీసె, ఈనె ఇంకా కుండిలింకెరొ పాపోనె తంకె సంగరె జెల్లీసె. ");
INSERT INTO rei_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","సాకిరాక బొల్ట పైటీనె బొల్లె దీగదిల్లీసె, నుచ్చిలాట కిచ్చి దోరెనాపొడుకుంటా రొన్ని. ");
INSERT INTO rei_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","పురువురొ నాకు, తా బోదకు నాదూసించిలాపనికిరి దాస్యత్వముబుల్లా కాడి తొల్లె రొల్లాలింకె తంకరొ యజమానులుకు సంపూర్నమైలా గనతకు అర్హులుబులి బచ్చిమంచె. ");
INSERT INTO rei_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","విస్వాసులైలా యజమానునె గల్లా దాసునె తంకె యాజమానునె అన్నబయినె బులిగీకిరి తంకు నాసడిదీకిరి, తంకె సేవాపలము పొందిలాలింకె విస్వాసునెకు ప్రియులైకిరి అచ్చెబులి ఇంక బడే ఎక్కువుగా తంకు సేవ కొరిలాపనికిరి రొమ్మంచి. ఏ కొతానె బోదించిలింకు హెచ్చరించొండి. ");
INSERT INTO rei_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","కేసైయీనెను అం ప్రబువైలా యేసుక్రీస్తురొ గుటె బొల్టకొతానెకు, దైవబక్తికి అనుకూలమైలా బోదకు నాఅంగీకరించుకుంటా, బిన్నమైలా బోదానె కొర్నే, ");
INSERT INTO rei_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","సెయ్యెకిచ్చి నాజనికిరి కొలీనె గురించి వాగ్వాదమునె గురించి అనవసరంగా ప్రయాసపొడుకుంటా గర్విస్టుడైవొ. ఎడవల్లరె దిగినార్లాబుద్ది, కలహము, దూసనానె దురనుమానాలు, ");
INSERT INTO rei_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","తంకె చెడిజిల్లా మనస్సు కలిక్కిరి సత్యమునీలా బడేవివాదాలు దీగీకిరి పురువురొ బక్తి కొరువురొ వల్లరె బడే లవొ ఆసి బులిగిత్తోసె. ");
INSERT INTO rei_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","అమె కలిక్కిరితల్లాట సంగరె, సొత్తయిల పరిసుద్దత తాకు కెత్తోలవొ. ");
INSERT INTO rei_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","అమె యే లోకొకు కిచ్చి దన్నయిలనింతొ, ఆండ్రెదీకిరి కిచ్చి దరిగిజెన్నారొ. ");
INSERT INTO rei_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","ఈనె కద్ది, కొన్నానె కలిగికిరితన్నె సడసంగరె త్రుప్తి పొడికిరి రొమ్మండి. ");
INSERT INTO rei_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","పలియగలిగిలాలింకె ఈవాసి బులి ఆసపొడిలాలింకె తంకె సోదనరె, మోసంరె, అవివేకమైలా కొస్టోనెరె దురాసలురె పొడుసె. ఈనె సాటానె మనమానుకు నస్టమురె నాసనమురె బుడ్డిపూసె. ");
INSERT INTO rei_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","క్యాకిరిబుల్నే పలియాస సమస్తమైలా కీడుకు కారనం. కుండిలింకె సడకు ఆసించికిరి విస్వాసముదీకిరి బాజీకిరి బడే బాదానె వల్లరె తంకు తంకాక బుసిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","ఈనె పురువురొ మనమా! తూ ఈనె యెడకల్లాసడిదీకిరి, నీతికి, బక్తికి, విస్వాసముకు, ప్రేమకు, ఓర్పుకు, సాత్వికముకూ సంపాదించిగిత్తె ప్రయాసపొడండి. ");
INSERT INTO rei_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","నిత్యజీవము పొందితె తొత్తె తువ్వాక బొల్ట పోరాటం పోరాడు. సడకు పొందిగినితే తువ్వు పురువుదీకిరి డక్కబొడికిరి బడే సాక్సులగరె తువ్వు బొల్ట ఒప్పుకోలు కలిగీకిరి తల్లందరె సే జీవం కోసం తొత్తె డక్కిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","సొబ్బిజీవీనెకు ఆదారమైలా పురువు అగరె, క్రీస్తుయేసు అగరె, పొంతి పిలాతు పక్కరె దైర్యముగా ఒప్పిగీకిరి, సాక్సం దిల్లా క్రీస్తుయేసు అగరె తొముకు ఆజ్ఞాపించిలించి. ");
INSERT INTO rei_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","అం ప్రబువైలా యేసుక్రీస్తు అయిలాజాంక తువ్వు నిస్కలంకముగా, నిందనీకుంటా యే ఆజ్ఞానె అంగీకరించికిరి సలిగీకిరి విస్వాసం సంగరె రొమ్మాసి బులి తొత్తె ఆజ్ఞాపించిలించి. ");
INSERT INTO rei_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","ఆసీర్వాదం కారకుడు, సర్వాదికారి సరైలకలొరె సే ప్రత్యక్సతకు దిగుదూసి. సెయ్యాక సర్వాదిపతి రొజానుకు రొజా, ప్రబువూనెకు ప్రబువైకిరి ఆసీర్వాదానెకు కారకుడైకిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","కేసే నాజెన్నార్లా తేజస్సురె సెయ్యె మాత్రమాక తైకిరి మొర్నొనీలాట యికిరచ్చి. మనమాన్రె కేసే తాకు దిగిలాంతె, కేసే దిగినారె. తాకు గనత సాస్వతమైలా ప్రబావము కలిగీకిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","యే లొకొరె పలియగలిగిలాలింకె గర్వంనాపొడుకుంటా, స్తిరమునీలా పలియంపరె నమ్మకం నారొగ్గీకుంటా, సుకముగా అనుబవించితె సొబ్బీఅముకు బడే బూతు దీతల్లా పురువుంపరె నమ్మకము దీగిమంచిబులి ఆజ్ఞాపించు. ");
INSERT INTO rei_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","బొల్ట పైటీనె బుల్లా పలియ కలిగిలాలింకె, దానగునం కలిక్కిరి, తంకపలియరె పొదర్లింకు బాగందిల్లాలింకైకిరి తమ్మాసిబులి తంకు ఆజ్ఞాపించు. ");
INSERT INTO rei_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","తంకె సత్యమైలా నిత్యజీవమును సంపాదించిగిత్తె నిమిత్తము, అయితల్లా కలొకు బొల్టపునాది తంకోసం పొగ్గుచ్చె. ");
INSERT INTO rei_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","ఓ తిమోతి, తొత్తె అప్పగించిలాటకు కాపాడిగీకిరి, అపవిత్రమైలా సుచ్చు కొతానుకు, జ్ఞానం బులి మాయకొతానె కొయిలా మూర్కంగా దొందర్లాలింకు దూరుగాతాండి. ");
INSERT INTO rei_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","సే విసయమురె ప్రవీనునె బులి కుండిలింకె కొయిగీకిరి విస్వాసవిసయమురె తప్పిజీసె. పురువురొ క్రుప తొత్తె తోడుగా తమ్మాసి.");
INSERT INTO rei_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","క్రీస్తుయేసురె రొల్లా జీవము గురించి వాగ్దానము దీకిరి పురువురొ చిత్తము వల్లరె క్రీస్తుయేసు అపొస్తులుడైలా పౌలు, ");
INSERT INTO rei_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ప్రియమైలా పో యీల తిమోతికు సుబం బులి రాసివురొ. బో యీల పురువు దీకిరి అమె ప్రబువైలా క్రీస్తుయేసు దీకిరి క్రుప, కనికరము సమాదానము కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","మీ సేవించితల్లా పురువుకు పూర్న ఆత్మ సంగరె మో పితరులు పనికిరి క్రుతజ్ఞతలు చెల్లించిలించి. మో ప్రార్దనల్రె నాపసిరిజీకిరి తొత్తె జ్ఞాపకము కొరిగీకిరి రత్తి దూసు కెబ్బుకూ, తాకు క్రుతజ్ఞత చెల్లించిలించి. ");
INSERT INTO rei_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","సాకిరి మో సంతోసం పరిపూర్నమైలా పనికిరి తో అంకీనెరె పని తల్చిగీకిరి, మెత్తె సంపూర్నానందము కలిగితె తొత్తె ఇంకా బేగా దిగిమాసి బులిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","సే విస్వాసము అగరె తో అవ్వ ఈలా లోయికు, తో మా యీల యునీకేకు తల్లా విస్వాసము తువాంక కలిక్కిరి అచ్చు బులి నిచ్చయముగా మీ నమ్మిలించి. ");
INSERT INTO rei_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","సే కారనం వల్లరె మీ తో ఉంపరె మో అత్తోనె లొక్కిరి అబిసేకించికిరి, తోత్తె కలిగిల పురువురొ క్రుపావరముకు అబివ్రుద్ది కొరిగిమ్మాసి బులి తొత్తె జ్ఞాపకము కొరిలించి. ");
INSERT INTO rei_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","పురువు అముకు సక్తి, ప్రేమ, ఇంద్రియనిగ్రహము గల ఆత్మకాక దీసి గాని పిరికిలింకె యీల ఆత్మదిల్లాని. ");
INSERT INTO rei_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ఈనె తువ్వు అం ప్రబువు విసయమైలా సాక్స్యము గురించి, తా కైదీయైలా మో గురించి ఈనెను, నాలజ్జొపొడికుంటా, పురువురొ సక్తి వల్లరె సువార్త నిమిత్తమైల స్రమానుబవంరె అం సంగరె బాగస్తుడైకిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","అం పైటినె బట్టి నీకిరి, తా సొంత సంకల్పము వల్లరె, క్రుప వల్లరె, అనాది కలోరాక క్రీస్తుయేసు వల్లరె దిల్లా క్రుప సంగరె అముకు రక్సించికిరి తా సొంతమనమానెగా కొరిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","ఈనె ఉంచినె అం రక్సకుడు క్రీస్తు యేసురె ప్రత్యక్సపర్చిలా యే సువార్త వల్లరె మొర్నొకు ఓడించికిరి నిత్యజీవముకు బయలుపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","పురువు మెత్తె అపోస్తులుడుగా, బోదకుడుగా సువార్త ప్రకటించితె బచ్చిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ఈనె సే కారనం వల్లరె యే కొస్టోనె అనుబవించిలించి గాని, మియ్యి నమ్మిలాట తెలుసు గనుక సెయ్యె మెత్తె అప్పగించిలా పైటి మెత్తె నియమించిలా దినొజాంక కొనసాగించుసి బులి పూర్తిగా నమ్మిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","క్రీస్తుయేసురె రొవ్వొలిసిలా విస్వాసము, ప్రేమ కలిగిలాలింకైకిరి, తువ్వు మో వల్లరె సునిలా సత్యవాక్కుకు మాదిరిగా కడిగీకిరి సడకు పాటించు. ");
INSERT INTO rei_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","తొత్తె అప్పగించిలా సే బొల్ట విసయోనె అం బిత్తరె నివసించిల పరిసుద్దాత్మ సక్తి సంగరె కాపాడిగీండి. ");
INSERT INTO rei_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","ఆసియరె తల్లలింకల్లా మెత్తె సడిదికిరి బాజీసె బుల్లాసంగతి తొత్తె తెలుసు. తంకె పుగెల్లు హెర్మొగెనే బుల్లాలింకె సెట్రొలింకాక. ");
INSERT INTO rei_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","ప్రబువు ఒనేసిపోరు గొరొలింకల్లా ప్రబువు కనికరము దిగదిమ్మాసి. కైంకిబుల్నే సెయ్యె బడేసార్లు మెత్తె ఆదరించిసి. మియ్యి కైదీరె తల్లాబెల్లెంక సెయ్యె లజ్జొపొడిలాని, ");
INSERT INTO rei_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","ఈనె సెయ్యె రోమాకు అయిలా ఎంట్రాక మీ మిల్లెత్తెవరకూ మెత్తె స్రద్దగా కుజ్జిసి. ");
INSERT INTO rei_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","ఈనె సెయ్యె ఎపెసురె కెత్తె ఉపచారం కొరిసో సడ తువ్వు బొల్లె జనిసు. సే దినొరె సెయ్యె ప్రబువు వలరె కనికరము పొందిమాసి. ");
INSERT INTO rei_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","మో పో, తూ ఉంచినె క్రీస్తుయేసురె క్రుపదీకిరి బలవంతుడుయికిరి రో. ");
INSERT INTO rei_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","తువ్వు బడేలింకె సాక్సీనె అగరె మోవల్లరె సునిలా సంగతీనెకు పొదరిలింకు బోదించితె సామర్ద్యముగల నమ్మకమైలా మనమానెకు అప్పగించు. ");
INSERT INTO rei_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","క్రీస్తుయేసురొ బొల్ట సైనికుడుపనికిరి మో దీకిరికూడ కొస్టొనుకు అనుబవించు. ");
INSERT INTO rei_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","సైనికుడు కేసెయీనెను యుద్దముకు జేతల్లాబెల్లె, తా దండురె చేర్చిగిల్లా అదికారికు సంతోసం కొరిమంచె బులికిరి, ఏ జీవనపైటినిరె చిక్కిగిన్నీ. ");
INSERT INTO rei_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","ఈనె కెలొకారి నియమంప్రకారం నాకెలినె, తాకు బహుమానం మిల్నీ. ");
INSERT INTO rei_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","కొస్టొపొడిలా వ్యవసాయకుడాక అగుంతా పచ్చపలితం పొందిగివ్వొ. ");
INSERT INTO rei_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","మియ్యి కొయిలా కొతా ఆలోచించిగీండి; సొబ్బి విసయాల్రె అర్దం కొరిగిత్తె ప్రబువు తొత్తె వివేకం దూసి. ");
INSERT INTO rei_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","దావీదు సంతానమురె జొర్నైకిరి మొర్నొదికిరి ఉటిలా యేసుక్రీస్తు కోసం కొయితల్లా సువార్తాక మీ ప్రకటించిలించి బులి జ్ఞాపకం కొరిగీండి. ");
INSERT INTO rei_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","మీ నేరస్దుడు ఈకిరి తల్లపనికిరి, సే సువార్త విసయంరె గొలుసునె సంగరె బందించిగీకిరి కొస్టొపొడిలించి, ఈనెను పురువురొ వాక్యముకు బందించినారిసె. ");
INSERT INTO rei_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","సడవల్లరె పురువుసంగరె ఏర్పర్చిగిల్లా మనమానె కోసం, నిత్యమైలా మహిమ సంగరంకా క్రీస్తుయేసు వల్లరె రక్సన పొందిమాసిబులి మియ్యి సొబ్బిటికు ఓర్చిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","యే కొతా నమ్మకమైలాట, క్యాకిరి బుల్నే, అమె తాదీపాటు మొరిజెల్లాలింకె ఈనె తాదీకిరికూడ జీమో. ");
INSERT INTO rei_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","అమె సహించిలా లింకె ఈనె, తాదీకిరాంక ఏలుంచొ. తాకు అమె తెలిసినీబులి కొయినె, సేయంకా అముకు తెలిసిని బులి కొయివొ. ");
INSERT INTO rei_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","అమె నమ్మకం నీలాలింకె ఈనెను, సెయ్యె అమంపరె నమ్మకంగా తాసి; సెయ్యె తా ప్రవర్తనకు విరోదముగా కిచ్చీకొరినారి. ");
INSERT INTO rei_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","సునిలాలింకు చెడమరితాక గాని మరి కిడకు నాపైటికైలా కొతానె కోసం వాదం లొగ్గిత్తెనాండిబులి, ప్రబువు అగరె తాకు యదార్దంగా గద్దించికిరి ఏ సంగతీనె తంకు జ్ఞాపకము కొరొండి. ");
INSERT INTO rei_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","పురువు అగరె అంగీకరించబొడిలా పైటితా పనికిరి, నాలజ్జొపొడిలా పైటితా పనికిరి, సత్యవాక్యముకు బొల్లకిరి వివరించువురొ బిత్తరె తొత్తె తువ్వు పురువుకు దిగిపించిగిత్తే జాగర్తపొడు. ");
INSERT INTO rei_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","నాపైటికైలా సుచ్చ కొతానెకు దూరుగతాండి. సా కొతలగిలాలింకె మరి బడే బక్తినీలాలింకె ఊసె. ");
INSERT INTO rei_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","దేకు కైపీలా గా పాకిర్లాపనికిరి, తంకొతానె పాకుసె, తంకబిత్తరె హుమెనైయు, పిలేతు సాబోదకొరిలీసె. ");
INSERT INTO rei_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","తంకె పునరుత్దానము గతించిజేసిబులి కొయికుంటా సత్యం విసయమురె తప్పిజీకిరి, కుండిలింకురొ విస్వాసముకు చెడమరిలీసె. ");
INSERT INTO rei_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ఈనెను పురువురొ స్తిరమైలా పునాది నిలకడగా అచ్చి. ప్రబువు తా లింకు ఎరక బుల్లాట ప్రబువు నాకు ఒప్పిగిల్లా సొబ్బిలింకు దుర్నితిదీకిరి బాజిమ్మాసి బుల్లాట సడకు ముద్రగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","గుటె గొర్రె బడే పాత్రనె తాసె. తాండ్రె కుండె వెండి గిన్నానె, కుండె సున్న గిన్నానె, ఇంకాకుండె బడ్డీనెదీకిరి, మట్టిదీకిరాంక కొర్లాంచ తాసె, తాండెబిత్తరె కుండె విలువరొల్లా పనికిరి ఇంకుండె విలువనీలాంచ పనికిరి ఉపయోగించబొడివె. ");
INSERT INTO rei_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","కేసెయీనెను ఎడబిత్తరె నాచేరికిరి తాకు సెయ్యాక పవిత్ర పర్చిగిన్నె సెయ్యె పరిసుద్దంకొరిగీకిరి, యజమానుడు వాడిగిత్తే అర్హతయిలా సొబ్బి సత్కార్యములుకు సిద్దపర్చిబొడికిరి విలువ నిమిత్తమైలా పాత్రయికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","తువ్వు బెండరొ ఆసానె సడదీకిరి, పవిత్ర హ్రుదయం కలిగీకిరి నీతిరె, విస్వాసమురె, ప్రేమరె, సమాదానముకు సంపాదించిగిత్తె ప్రబువుకు ప్రయత్నం కొరొండి. ");
INSERT INTO rei_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","బుద్దిహీనిలైలాపనికిరి నాపైటికైలా లగానుకు దూరుగాతా సాటనెల్లా కొలీనెకు బట్టొ కడుసె. ");
INSERT INTO rei_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","ప్రబువురొ దాసుడు, కొలీనె నాలక్కుంటా సొబ్బిలింకె ఉంపరె దయగలికిరి బొల్ట సహనము సంగరె బోదించితె సమర్దుడైకిరి రొమ్మాసి. ఇంకా కీడు సహించిలాటైకిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","సత్యంకు తెలిసిగీకిరి మారుమనుసు పొందితె పురువు తంకు అవకాసం దీసి బులి వివేకం కలిక్కిరి తో విరోదీనెకు సరికొరుమాసి. ");
INSERT INTO rei_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","సడవల్లరె అపవాది తా ఇస్టము చొప్పురె బందించికిరి అంకె సడరొ ఉరి తీకిరి మెలుకువ కలిక్కిరి తప్పించిగిపారె. ");
INSERT INTO rei_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","ఆకరుదినోన్రె అపాయకరమైల కలోనె ఆసెబులి తెలిసిగీండి. ");
INSERT INTO rei_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","కైంకిబుల్నే మానమానె స్వార్దపరులులింకె, పలియంపరె ఆసగల్లాలింకె, బడాయిలింకె, గొప్పానె కొయిగిల్లాలింకె, దూసించిలాలింకె, మా బోనుకు అవిదేయునె, క్రుతజ్ఞతనీలాలింకె, బక్తినీలాలింకె. ");
INSERT INTO rei_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","అనురాగం నీలాలింకె, దయనీలాలింకె, అపవాదిలింకె, నాపొడిలాలింకె, క్రూరులు, సత్యముకు ద్వేసించిలాలింకె. ");
INSERT INTO rei_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","మోసం కొరిలాలింకె, మూర్కులింకె, గర్వం రొల్లలింకె, పురువుకన్నా సుకోనెకు బడేప్రేమించిలలింకె. ");
INSERT INTO rei_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","తంకె ఉంపరకు బక్తిరొల్లాలింకెపనికిరి రొయికిరి సడరొ సక్తంపరె ఆదారపొడినింతె. సాలింకు దూరుగా రోండి. ");
INSERT INTO rei_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","తంకె కుండెలింకెరొ గొరోనె బిత్తరెకు అయికిరి బడే దురాసలసంగరె పాపం సంగరె చిక్కిగీకిరి బలహీనమైలా మొట్టానుకు లోపర్చిగీకిరి తంకంపరె లవొకు పొందుసె. ");
INSERT INTO rei_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","కుండెలింకె మొట్టానె కెబ్బుకు సుగ్గిమ్మాసిబులివివ్వె గని ఈనె సత్యంకు తెలిసిగిన్నారె. ");
INSERT INTO rei_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","ఈనె యన్నే, యంబ్రే నా గల్లాలింకె మోసేకు ఎదిరించిలాపనికిరి అంకె చెడిలా మనస్సు కలిగీకిరి, విస్వాసవిసయమురె బ్రస్టులైకిరి సత్యముకు ఎదిరించిలీసె. ");
INSERT INTO rei_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","ఈనెను తంకరొ అవివేకము క్యాకిరి దొరెపొడిలీసో సాకిరాక అంకె దీలింకె కూడా సొబ్బిలింకగరె దొరెపొడుసె. గనుక అంకె ఇంక అగురుకు జెన్నారె. ");
INSERT INTO rei_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","ఈనె తువ్వు మో బోదకు, మో ప్రవర్తనకు, మో ఉద్దేసముకు, మో విస్వాసముకు, మో దీర్గసాంతముకు, మో ప్రేమకు, మో ఓర్పు సంగరె సలుగునోండి, ");
INSERT INTO rei_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","అంతియొకయ, ఈకొనియ, లుస్త్ర బులి కొయిలా పట్నముల్రె మెత్తె కలిగిలా హింసలుకు ప్రమాదాలుకు, తెలిసిగిల్లాటయికిరి మెత్తె వెంబడించిసు. సే హింసలకు సహించించి గాని, సడబిత్తరెదీకిరి ప్రబువు మెత్తె తప్పించిసి. ");
INSERT INTO rei_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","క్రీస్తుయేసురె బొల్టబక్తి సంగరె జీమాసిబులి బులిగిల్లాలింకు హింసలు ఆసె. ");
INSERT INTO rei_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ఈనె దుర్మార్గునె, వంచకునె పోదరిలింకు మోసం కొరుకుంటా తంకెంకా మోసం యీజీకిరి చెడిజూసె. ");
INSERT INTO rei_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","తువ్వు సుగ్గీకిరి సత్యంబులి తెలిసిగిల్లాంచ కా వల్లరె సుగ్గిచ్చో సే సంగతి తెలిసిగీకిరి, సడబిత్తరె నిలకడగా రొండి. ");
INSERT INTO rei_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","క్రీస్తుయేసురె రొవ్వలిసిలా విస్వాసము సంగరె రక్సనార్దమైలా జ్ఞానము తొత్తె కలిగించితె సక్తిగల పరిసుద్ద లేకనానెకు సన్నిబెల్లె దీకిరి తూ తెలిసిగిసు గనుక, ");
INSERT INTO rei_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","పురువురొ ప్రేరేపన వల్లరె అయిలా లేకనానెకు ఉపదేసించితె, కండించితె, తప్పు దిద్దితె, నీతిసంగరె జీతె ఉపయోగకరంగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","సడవల్లరె దైవజనుడు సిద్దపొడికిరి ప్రతి బొల్టపైటికు పరిపూర్నముగా సిద్దపొడికిరి అర్హత కలిక్కిరి రొమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","పురువు అగరె జీకిరితల్లాలింకు, మొరిజిల్లాలింకు తీర్పు తీర్చితె క్రీస్తుయేసు అగరెకు, సే అయిలాబెల్లె తా రాజ్యముతోడుగా, మియ్యి తొత్తె కచ్చితంగా కొయిలాట కిరబుల్నె. ");
INSERT INTO rei_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","వాక్యము ప్రకటించొండి; సొబ్బి సమయాల్రె ప్రయాసపొడికుంటా, సంపూర్నమైలా దీర్గసాంతముదీకిరి ఉపదేసించికిరి కండించికిరి గద్దించికిరి బుద్దికోండి. ");
INSERT INTO rei_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","కైంకిబుల్నే మనమానె బొల్టబోదకు సహించినారికిరి, సునితె నాయిస్టపొడిలా కన్నోనెగలిగిలాలింకె యీకిరి తంక చెడుకోరికలూనె కోసం అనుకూలమైలా బోదకొరిలాలింకు తంకోసం పోగుకొరిగుచ్చె. ");
INSERT INTO rei_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","తంకె సత్యముకు నాసునుకుంటా పుట్టిగించిలాకొతానె సునితందుకు ఇస్టపొడుసె. ");
INSERT INTO rei_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","ఈనె తువ్వు సొబ్బి విసయాల్రె తగ్గించిగీరి తమ్మాసి. సువార్త పైటిరె కొస్టొపొడికిరి, తో పరిచర్యకు సంపూర్తిగా నెరవేర్చు. ");
INSERT INTO rei_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","మియి ఉంచినాక మో పొర్నొకు అర్పించిలా కలొ అయిసి, మియి జెవ్వొలిసిలా కలొ పక్కరకు అచ్చి. ");
INSERT INTO rei_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","బొల్ట పోరాటం పొరాడించి. మో పైటిముగించించి. మో విస్వాసముకు కాపాడిగించి. ");
INSERT INTO rei_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","ఉంచినె మో కోసం విజయకిరీటం రొయిదీకిరి అచ్చి. సే దిన్రె నీతిగల్లా న్యాయదిపతియైలా ప్రబువు సడ మెత్తెనూ, మెత్తాకనీకిరి తా రాకడకోసం ఎదురుదిగిలా సొబ్బిలింకూ అనుగ్రహించుసి. ");
INSERT INTO rei_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","మో పక్కరకు బేగా అయితె ప్రయత్నము కొరు. ");
INSERT INTO rei_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","దేమా ఏ లొకొకు ప్రేమించికిరి మెత్తె సడికిరి తెస్సలోనీకకు జేసి. క్రేస్కే గలతీయకు, తీతు బుల్లాట దల్మతియకు జేసె. ");
INSERT INTO rei_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","లూకా మాత్రమాక మో పక్కరె అచ్చి. మార్కుకు తో సంగరె దనిగీకిరి ఆయి, సెయ్యె పరిచారముకు నిమిత్తము మెత్తె ప్రయోజనకరమైలాట. ");
INSERT INTO rei_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","తుకికు బుల్లాటకు ఎపెసుకు పొడదీంచి. ");
INSERT INTO rei_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","తువ్వు అయిలాబెల్లె మియ్యి త్రోయరె కర్పు పక్కరె సడిదిల్లా మో అంగీకు, పుస్తకమునెకు, ముక్యమైలా చొమ్మో కయితోనుకు దరిగీకిరి ఆయి . ");
INSERT INTO rei_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","అలెక్సంద్రు బుల్లా కంచరీట మెత్తె బడే కీడు కొరిసి. తా పైటివలరె ప్రబువు తాకు ప్రతిపలము దూసి. ");
INSERT INTO rei_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","తా విసయంరె తువ్వు జాగర్తాగ తా, సెయ్యె మో కొతానుకు బడే ఎదిరించిసి. ");
INSERT INTO rei_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","మియ్యి అగరె సమాదానము కొయిలాబెల్లె కేసైనెనూ మో పక్సమురె తారిలానింతె, సొబ్బిలింకె మెత్తె సడిదీకిరి బాజీసె. యెడ సెల్లె తంకు పురువు నేరముగా బచ్చినాసి. ");
INSERT INTO rei_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","ఈనె మో దీకిరి సువార్త సంపూర్నముగా ప్రకటింబొడిలా నిమిత్తము, పురువుకు నా నమ్మిగిలలింకు సడ సునిలా నిమిత్తము, ప్రబువు మో ప్రక్కరె టారికిరి మెత్తె బలపర్చిసి గనక మియ్యి సింహము తుండొ దీకిరి తప్పించబొడించి. ");
INSERT INTO rei_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ప్రబువు ప్రతి మోసకరమైలా పైటినెదీకిరి మెత్తె తప్పించికిరి తా పరలోకరాజ్యముకు జెల్లాపనికిరి మెత్తె రక్సించుసి. కెబ్బుకూ తాకు మహిమ కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ప్రిస్కిలకు, అకులకు, ఒనేసిపోరు గొర్లింకు దండమూనె ");
INSERT INTO rei_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ఎరస్తు కొరింతియరె రొయిజీసి. త్రోపియు జబ్బుపొడిలందరె తాకు మిలేతు గారె సడిదీకిరి బారైంచొ. ");
INSERT INTO rei_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","చిత్తొకలొ నా అయిల అగరె తువ్వు అయితందుకు ప్రయత్నము కొరు. యుబూలు, పుదే, లీను, క్లౌదియ ఇంకా అన్నబయినె సొబ్బిలింకె తొత్తె దండమూనె కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ప్రబువు తో ఆత్మకు తోడైకిరి రొమ్మాసి. క్రుప తొముకు తోడైకిరి రొమ్మాసి.");
INSERT INTO rei_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","పురువురొ దాసుడు యేసుక్రీస్తు అపొస్తులుడైలా పౌలు పురువుదీకిరి బచ్చిగిల్లా మనమానుకు విస్వాసంరె సలిపించుకుంటా సత్యమైలా బట్టొకు బోదింతె బచ్చిగిల్లాటైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","సొరొకొతా నాకొయిలా పురువు అముకు అనాది కలొరాక అముకు వాగ్దానము కొరిలా సే జీవమాక నిరీక్సనదీకిరి కూడిలా నిత్యజీవము. ");
INSERT INTO rei_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","ఈనె సే సమయంరె తా వాక్యము ద్వారా యెడ కోసం తెలియపర్చిసి. యెడ అం రక్సకుడైలా పురువురొ ఆజ్ఞ ప్రకారం మెత్తె అప్పగించిలాటకు మియ్యి ప్రకటించిలించి. ");
INSERT INTO rei_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","యెట్టె అం సొబ్బిలింకె విస్వాస విసయంరె మో సొత్తాయిల పో తీతుకు సుబం బులి కొయికిరి రాసిలించి. అం బోయిలా పురువు ఇంకా అం రక్సకుడైలా క్రీస్తుయేసురొ క్రుప కనికరము సమాదానముకు తొత్తె అనుగ్రహించిమాసి. ");
INSERT INTO rei_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","మియ్యి తొత్తె ఆజ్ఞాపించిలా పనికిరి తువ్వు లోపాలు రొన్నే సరికొరికిరి, సొబ్బి పట్నములురె సంగబొడలింకెకు నియమించితె నిమిత్తము మియ్యి క్రేతురె తొత్తె సడిదీకిరి అయించి. ");
INSERT INTO rei_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","కేసైనెనూ కేవిదమైలా నిందానె నీకుంటా జొనె నైపోకాక కలిక్కిరి, అవిదేయునెగా నీకిరి విస్వాసినె గల్లాపిల్లానె కలిక్కిరి తల్లాలింకు సంగబొడలింకెగా రొయిదివ్వొచ్చు. ");
INSERT INTO rei_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","కైంకిబుల్నే అద్యక్సుడు పురువురొ గ్రుహనిర్వాహకుడు గురించి నిందనీలాపనికిరి తమ్మాసి. సెయ్యె యదార్దంగా రొల్లాటైకిరి రొమ్మంచి. రగ్గొనీకుంటా తమ్మాసి. పీకారైకిరి తన్నాసి. మరిలాటైకిరి తన్నాసి. దుర్లాబముకు నాఆసించిలాటైకిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","చుట్టాలుకు గౌరవించిలాటైకిరి, బొల్టబుద్దిగలిగిలాటైలిరి, నీతిమంతుడైకిరి, పవిత్రుడుగా, ఆసానెకు అదుపురె లొగ్గిల్లాటైకిరి, బొల్టప్రవర్తన కలిక్కిరి రొమ్మాసి ");
INSERT INTO rei_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","సెయ్యె బొల్ట బోద విసయంరె మనమానుకు హెచ్చరించికుంటా, ఎదిరించిలాలింకు ఒప్పించితె సక్తికలిగిలాటైకిరి, ఉపదేసము ప్రకారం నమ్మిలా బోదకు గట్టిగా దరిగీకిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","కైంకిబుల్నే యూదుల్రె బడేలింకె, ప్రత్యేకంగా సున్నతికు ఆదారం కొరిగిల్లాలింకె, అవిదేయులైకిరి, తిరుగుబాటు కొరికిరి మోసం కొరిలాలింకె పనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","తంక తుండోనె బుజ్జిపించిమాసి. కైంకిబుల్నే తంకె పలియ కోసం నాఉపదేసించివలిసిలాంచకు ఉపదేసించుకుంటా అక్రమము కోసం బడే కుటుంబానెకు పాడుకొరిలీసె. ");
INSERT INTO rei_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","తంకెబిత్తరె బుల్నే తంకె సొంత ప్రవక్తానెరె జొనె యాకిరికొయిసి క్రేతీయులునె కెబ్బుకూ సొరొకొతాలగిలాలింకు, చెడమరిలాలింకెగా, దేబద్దకం రొల్లాలింకె, కద్దికారిలింకెపనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","ఏ సాక్స్యము సొత్తాక. ఏ హేతువు సంగరె తంకె యూదుల కల్పనా కతలకు, ");
INSERT INTO rei_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","సత్యము సంగరె తొలిగిజీసిబులి మనమానె కట్టడలకు లక్స్యమునాలొకొండ, విస్వాసవిసయమురె స్వస్దులగు నిమిత్తము తంకు కటినముగా గద్దించొండి. ");
INSERT INTO rei_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","బొల్టలింకు సొబ్బి బొల్టాట గాని, చెడిలా అవిస్వాసముదీకిరి రొల్లలింకు సొబ్బి అపవిత్రమాక. తంకె హ్రుదయంరె తంకె మనస్సాక్సిరె చెడిజీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","పురువుకు తెలుసును బులి తంకె కొయిగుసె గాని, అసహ్యులు, అవిదేయునె, ప్రతి బొల్ట పైటినె విసయమురె చెడిజిల్లాలింకె యికిరి, తంకె పైటినెవల్లరె నిర్లక్సంగా అచ్చె. ");
INSERT INTO rei_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","తువ్వు బొల్ట ఉపదేసంకు సొబ్బిలింకూ అనుకూలమైలా బొల్ట నియమానె బోదించు. ");
INSERT INTO rei_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","కైంకిబుల్నే బొట్టలింకె బడే అనుబవం కలిగిలాలింకె, మర్యాదగా రొయికిరి, స్వస్దబుద్ది కలిగిలాలింకె యీకిరి, విస్వాస ప్రేమ, సహనములురె లోపమునీలాలింకె పనికిరి రొమ్మంచి బులి బుద్దికోండి, ");
INSERT INTO rei_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","సాకిరాక మొంత్రి మొట్టానె గొరొపుడ్డీనె, బడే మొద్దొ పీకారీనె పనికిరి నా రొయికుంటా, బొల్టప్రవర్తన దీకిరి డొరొబీతి గలిగిలలింకె పనికిరి రొమ్మంచిబులి, పురువురొ వాక్యము అవమానంగా నారొయికుంటా దిగిమ్మంచి బులి బుద్ది కోండి. ");
INSERT INTO rei_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","సాకిరాక దిండ మొట్టానె తా గొయితానుకు లోబొడికిరి, తా గొయితకు పిల్లలనెకు ప్రేమించిలాపనికిరి, ");
INSERT INTO rei_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ఇంకా తంకె మనుసుకు ఆదీనంరె దీగీకిరి పవిత్రంగా బొల్ట ఇల్లాలుగా తంకె గొయితానుకు లోబొడికిరి పురువురొ కొతానుకు అవమానం నాఅయికుంటా సిక్సన దేండి. ");
INSERT INTO rei_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","సాకిరాక స్వస్దబుద్ది గలిగిలాలింకె పనికిరి రొమ్మంచెబులి బెండలింకు హెచ్చిరించొండి. ");
INSERT INTO rei_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","తో బోదరె నీతిసంగరె నమ్మకంరె తొత్తె తువ్వాక తో బొల్ట ప్రవర్తనరె పొదరిలింకు మాదిరిగా రో. ");
INSERT INTO rei_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","తో ఉపదేసము మోసంనీలాటైకిరి, బొల్టపనికిరి కేసే అవమానం నాకొరుకుంటా తొం విరోదూనె అం గురించి లజ్జొపొడివలిసిలాట కిచ్చీనాకొయినార్లా విదంగా తో ఉపదేసంరె పొదర్లింకు అవమానం నాకొర్లాపనికిరి తొ బోదానె తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","దాసులైలలింకె సొబ్బి విసయోనెదీకిరి ఉపదేసముకు, తో యాజమానులకు ఎదురుకొతా నాకొయికుంట తాకు సంతోసపర్చొండి, ");
INSERT INTO rei_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","సాకిరాక కెడయీనెను అపహరింపక, సంపూర్మమైలా బొల్ట నమ్మకము దిగిదీకిరి, సొబ్బి పైటినెదీకిరి అం రక్సకుడు యీల పురువు తంకు సంతోసము లొక్కుంటా, తంకు లోబొడికిరి తల్లాపనికిరి హెచ్చరించొండి. ");
INSERT INTO rei_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","కైంకిబుల్నే మనమానె సొబ్బిలింకు రక్సన కలిగిలాపనికిరి పురువు తా క్రుప దిగిదీసి. ");
INSERT INTO rei_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","అమె బక్తినీలా, యే లోకొ సంబందమైలా దురాసలకు సడిదీకిరి, పురువుకు ఇస్టమైలా బొల్టజీకానె జీలాపనికిరి సేక్రుప అముకు సలిపించుసి. ");
INSERT INTO rei_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ఈనె మహపురువూ అమె రక్సకుడుయిలా యేసుక్రీస్తురొ మహిమ ప్రత్యక్సమైలా సే దినో కోసం నిరీక్సనదీకిరి ఎదురుదిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","సెయ్యె సమస్తమైలా చెడ్డపైటినెదీకిరి అముకు విమోచించికిరి, బొల్టపైటి కొరితందుకు సక్తిగల మనమానుకు తా కోసము పవిత్రం కొరిగీకిరి తా సొత్తుగా కొరిగిత్తందుకు తాకు సెయ్యాక అం కోసం అర్పించిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","యడ గురించి బోదించికుంటా, హెచ్చరించుకుంటా సంపూర్న అదికారముదీకిరి సున్లాలింకు కండించికుంట. తొత్తె కేసే నాత్రునీకరించుకుంటా దిగ్గిత్తు ");
INSERT INTO rei_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","అదిపతినుకు అదికారినెకు లోబొడికిరి విదేయులుగా రొమ్మంచెబులి, ప్రతి బొల్టపైటికొరితె సిద్దపొడికిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","మనమానె రొల్లాపనికిరి సంపూర్నమైలా సాత్వికముకు దిగిదీకుంట, కాకును నా దూసించికుంటా, కొలీనె నా లక్కుండ సమాదానమైయికిరి రొమ్మంచె బులి, తంకు జ్ఞాపకము కొరు. ");
INSERT INTO rei_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","కైంకిబుల్నే అమె కూడ గతంరె అవివేకులైకిరి, అవిదేయులైకిరి మోసమైజీకిరి, బడేవిదములైలా దురాసలుకు, బోగములకు బానిసలుగా రొయికిరి, దుస్టత్వముదీకిరి అసూయదీకిరి కలోగడుపుకుంటా, అసహ్యంగా జొన్నెకు జొనె ద్వేసించుకుంటా రొయితమ్మొ. ");
INSERT INTO rei_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","అమె రక్సకుడుయిలా పురువు బిత్తరె దయ, మనమానె పక్కరె తాకురొల్ల ప్రేమరె ప్రత్యక్సమైలాబెల్లె. ");
INSERT INTO rei_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","అమె నీతిరె సలికుండ కొరిలా పైటినె మూలమురె కాక, తా కనికరము సంగరె మారుమనుసు సంబందమైలా పని వల్లరె, పరిసుద్దాత్మ అముకు నోస్వబావము కలిగించితె అముకు రక్సించిసి. ");
INSERT INTO rei_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","7","అం రక్సకుడైలా యేసుక్రీస్తు ద్వారా. పురువు పరిసుద్దాత్మ సమ్రుద్దిగా దీసి. అమె తా క్రుపవల్లరె నీతిమంతునె పనికిరి తీర్చబొడి, నిత్యజీవమురొ నిరీక్సన ద్వారా వారసునెగా కొరిసి. ");
INSERT INTO rei_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","ఏ కొతా నమ్మకమైలాట గనుక పురువురె విస్వాసలొగిలలింకు సత్క్రియలకు ఇస్టం సంగరె కొరితందుకు మనస్సులొక్కిరి రొల్లాపనికిరి తో ఏ కొతానుకు ద్రుడముగా కొయిమంచి బులి కోరిగిల్లించి. యడ బొల్ట మనమానెకు ప్రయోజనకరంగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","గాని, అవివేక వాదములుకు వంసావలీనెకు, లగానెకు, దర్మసాస్త్రముకు సంబందమైలా కొలీనెకు గురించి నాపైటికైలా పనికిరి అచ్చి గనుక సడకు దూరుగా రోండి. ");
INSERT INTO rei_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","విబేదమునె కలిగించిల మనమానెకు గుటె దీటా బేల్లే బుద్దికొయిలా తరువాత తంకు సడిదెండి. ");
INSERT INTO rei_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","సెటువంటీట బట్టొతప్పిజేకిరి తాకు సెయ్యె సిక్స విదించిగిత్తె పాపము కొరిలీసె బులి తువ్వు తెలిసిగిత్తు. ");
INSERT INTO rei_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","ఈనె నికొపొలికు అయికిరి సిత్తొకల్రె సెట్టె గడిపిమంచిబులి మియ్యి నిర్నయించిగించి గనుక మియ్యి అర్తెమానుకు యీనెను, తుకికు యీనెను తో పక్కరకు పొడదిల్లించి సెట్టె మో పక్కరకు అయితందుకు ప్రయత్నము కొరు. ");
INSERT INTO rei_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","న్యాయవాదియైలా జేనాను అపొల్లోనుకు బేగా పొడదే; తంకు కిచ్చి తక్కువ నీకుంటా దిగు. ");
INSERT INTO rei_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","అంలింకె పలింపు నీలా నిమిత్తము తంకె అవసరముకు దీకిరి సమయానుకూలంగా బొల్టక్రియలక బొల్ట కొరువురొ సుగ్గిమంచె. ");
INSERT INTO rei_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","మో పక్కరె రొల్లా సొబ్బిలింకె తొత్తె దండమూనె కొయిలీసె. విస్వాసము వల్లరె అముకు ప్రేమించిలాలింకు మో వందనములు కోండి. క్రుప తొం సొబ్బిలింకు తోడైకిరి రొమ్మంచి.");
INSERT INTO rei_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","క్రీస్తుయేసు కోసం కైదీయైలా పౌలు, ఈనె అం అన్నబయిల తిమోతి అం ప్రియుడు అందీకిరి పైటి కొరితల్లా పిలేమోనుకు, ");
INSERT INTO rei_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ఈనె అం అప్పబొయిని యీలా అప్పియకు మిసికిరి పోరాడిలా అర్కిప్పుకు, ఇంకా తో గొర్రె రొల్లా సంగముకు సుబం బులి కొయికిరి రాసితల్లా సంగతీనె. ");
INSERT INTO rei_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","అం బో యీలా పురువు పక్కరెదీకిరి ప్రబువైలా యేసుక్రీస్తు దీకిరి క్రుప సమాదానము తొముకు కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","బైయీలా పిలోమోను, తోకోసం మీ ప్రార్దన కొరిలా ప్రతీసారి పురువుకు క్రుతజ్ఞతలు చెల్లించిలించి. ");
INSERT INTO rei_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","కైంకి బుల్నే పురువురొ మనమానెంపరె తొత్తె తల్లా ప్రేమ, ఇంకా అం ప్రబువైలా యేసంపరె తొముకు తల్లా విస్వాసముకు మీ సునించి. ");
INSERT INTO rei_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","క్రీస్తు దీకిరి తొమె రొవ్వురొ వల్లరె తొముకు కలిగిలా ప్రతి స్రేస్టమైలా ఆసీర్వాదము విసయంరె తువ్వు అనుబవపూర్వకంగా జనువురొ వల్లరె తొందీకిరి తల్లాలింకె తో విస్వాసంరె బాగస్తులు యీమంచి బులి మో ప్రార్దన. ");
INSERT INTO rei_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","అన్నబయి, పురువురొ మనమానెరొ హ్రుదయమునె తో ద్వారా విస్రాంతి పొందిలందుకు తో ప్రేమ వల్లరె మెత్తె గొప్ప ఆనందము ఆదరన కలిగిసి. ");
INSERT INTO rei_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","యే కారనం దీకిరి కొరివలిసిలా సడ గురించి తొత్తె ఆజ్ఞాపించితె క్రీస్తురె మెత్తె బడె దైర్యము కలిగికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ఈనె, మియ్యి తొత్తె ప్రేమించిలించి గనుక బొడ్డూటైనన్నా మియ్యి ఉంచినె క్రీస్తుయేసు కోసం కైదీ యీకిరి రొల్లా పౌలు బుల్లా మియ్యి ఒనేసేము కోసం ప్రేమసంగరె విజ్ఞాపన కొరిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","మో బందకాలురె మియ్యి జొర్నొకొరిలా ఆత్మీయ పో ఒనేసిము కోసము తొత్తె విజ్ఞాపన కొర్లించి. ");
INSERT INTO rei_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","సెయ్యె గుటెబెల్లె తొత్తె నాపైటికైలాటాక గని, ఉంచినె తొత్తె, మెత్తె పైటికైలాటగా యీసి. ");
INSERT INTO rei_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","మో పొర్నొ పనాట యీలా తాకు తో పక్కు బుల్లికిరి పొడదిల్లించి. ");
INSERT INTO rei_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","మియ్యి సువార్త కోసం బందికానారె రొల్లాబెల్లె తో బదులుగా సెయ్యె మెత్తె పరిచారము కొరితె తాకు మోపక్కరె రొయిదిగిమంచిబులిగించి. ");
INSERT INTO rei_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ఈనె తో మేలు బలవంతముగా, మెత్తెనాకొరుకుంటా ఇస్టపూరకమైలాటగా రొమ్మాసిబులి తో అనుమతి నీకుంటా కొరితందుకు మెత్తె ఇస్టము నీ. ");
INSERT INTO rei_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","సెయ్యె తో పక్కరె కెబ్బుకూ రొయితాక కుండె కలొ తొత్తె దూరైసి. ");
INSERT INTO rei_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","సెయ్యె కెబ్బుకు దాసుడుగా నా రొయికుంటా దాసుడు కన్నా బడే ప్రియమైలా అన్నబయిగా విసేసముగా ప్రబువురె తొత్తె మెత్తె బడే పైటికైలాట. ");
INSERT INTO rei_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","కాబట్టి తువ్వు మెత్తె తో తోటి పైటిలింకె పని బులిగిన్నే మెత్తె చేర్చిగిల్లాపనాక తాకు చేర్చుగును. ");
INSERT INTO rei_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","సెయ్యె తొత్తె కీ నస్టమైనన్నా కలిగించినె తొత్తె కిరైనా రునము రొన్నన్నా సడ మో లెక్కరె రాసుగును. ");
INSERT INTO rei_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","పౌలు బుల్లా మియ్యి మో స్వహస్తముదీకిరి యే కొతా రాసిలించి సడ మియ్యాక తీర్చిమి. ఈనెను తో ఆత్మ విసయంరె తువ్వు మెత్తె రునపొడికిరి అచ్చు బులి మియ్యి ప్రత్యేకముగా కొయితెవసరంనీ. ");
INSERT INTO rei_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","సడకు మో అన్నబయి, ప్రబువు తో వల్లరె మెత్తె ఆనందము కలిగిమురొ క్రీస్తుదీకిరి మో హ్రుదయమురె త్రుప్తి కలిగించు. ");
INSERT INTO rei_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","మియ్యి కొర్లాటకన్నా తువ్వు బడేట కొరువు బులి జనికిరి మో కొతా సునుసుబులి తొత్తె రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","సడాక నీ, తో ప్రార్దన మూలముగా మియ్యి తో పక్కరకు అయివురొ జరుగుసి బులి నిరీక్సించిలించి గనుక మో కోసం బొస తయారు కొరు. ");
INSERT INTO rei_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","క్రీస్తు యేసుసంగరె మో దీకిరి కైదీయైలా ఎపప్రా తొత్తె దండము కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ఈనె మో దీకిరి పైటికొరిలా మార్కు, అరిస్తార్కు, దేమా, లూకా దండమూనె కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","అం ప్రబువువైలా యేసుక్రీస్తు క్రుప తొముకల్లా తోడైకిరి తమ్మాసి.");
INSERT INTO rei_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","పూర్వకల్రె బడే సమయాల్రె బడే విదాలుగా పురువు ప్రవక్తానె ద్వారా అం పితురులు సంగరె కొతాలగిసి. ");
INSERT INTO rei_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","ఈనె యే కల్రె చివరగా తా పోకు సొబ్బిటంపరె వారసుడుగా నియమించిసి. తా ద్వారా ప్రపంచముకల్లా కొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","సెయ్యె పురువు మహిమ దీకిరి తేజస్సుకు, సెయ్యె దైవత్వము గల్లా పోలిక పిందిగీకిరి, తా సక్తిగల కొతాదీకిరి సొబ్బిటుకు నిర్వహించికిరి మనమాన్రొ పాపం విసయమురె క్సమించిలాటైకిరి సొబ్బిటంపరె అదికారి యీకిరి, తంకె కన్నా కెత్తో స్రేస్టమైకిరి, రొల్లా పరలోకంరె గొప్పతా యీలా పురువురొ బత్తొకైలా అత్తొఆడుకు బొసిరిసి. ");
INSERT INTO rei_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","పురువు తా పోకు దేవదూతలకన్నా కెత్తో స్రేస్టమైలా నా దీసి. సే నా సొబ్బిటకన్నా గొప్పీట. ");
INSERT INTO rei_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","ఈనె పురువు తా దూతానె సంగరె కొయిలాని. తువ్వు మో పో, మియ్యి ఆజి తొత్తె బో యీంచి. మియ్యి తొత్తె బోబులి ఇంకా సెయ్యె మెత్తె పోబులికిరి. ");
INSERT INTO rei_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","ఈనె పురువు తా అగుంతా పోకు యే లొకొకు ఇంకా పొడదిల్లాబెల్లె పురువురొ దూతలల్లా తాకు నమస్కారము కొరిమంచిబులి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","ఈనె తా దూతానె ఆత్మ యీకిరి, తా సేవకునెకు నియ్య జొలానెగా కొరిగిల్లాట బులి తా దూతానె గురించి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","ఈనె తా పో గురించి ఈనె పురువు తో సింహాసనము కెబ్బుకూ తాసి, తో పరిపాలన తో ప్రజానెకు న్యాయమైలాటగా తాసి బులిసి. ");
INSERT INTO rei_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","తువ్వు నీతికి ప్రేమించికిరి దుర్నీతికు ద్వేసించుసు సడకాక పురువు తో తోటిలింకెంపరల్లా తొత్తె హెచ్చించిలాపనికిరి ఆనందపొడిలాపనికిరి ఏర్పర్చిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","ఈనె ప్రబూ తువ్వు ఆదిరాక బూమికి పునాది పొగిసు. మెగొనంకా తో అత్తోనె సంగరాక కొరిసు. ");
INSERT INTO rei_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","సడ అంతం యీజూసి ఈనె తువ్వు తాసు. సడానల్లా కొన్నానెపనాక పుర్నయిజెవొ. ");
INSERT INTO rei_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","చొక్కాపనాక సడకు మడిచిపూసు. సడకు కొన్నపనాక మార్చిపీవు ఈనె తువ్వు కెబ్బుకూ గుట్టెపనాక తాసు. తో బొచ్చొరోనె తగ్గినింతె బులి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","ఈనె మియ్యి తో సత్రువూనెకు తో గొడ్డోనెకు పిడచెక్కపనికిరి కొర్లాజాంక మోబత్తొ కైల అత్తొ ఆడుకు బొసురొబులి తా దూతానె సంగరె కా గురించి ఈనెన్నా కెబ్బైనన్నా కొయిలాని. ");
INSERT INTO rei_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","ఈనె ఉంచినె యే దేవదూతానె కేసెబుల్నె పురువుకు సేవకొరిలా ఆత్మానెగా రక్సన పొందిలాలింకు పురువు పొడదిల్లా పరిచారకులైకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","సడకు అమె అగుంతా సునిలా సంగతీనెకు సడదీకిరి నాతప్పిజీకుంటా తాండ్రొ విసయాల్రె బడే జాగర్త కలిగికిరి రొమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","కైంకిబుల్నే దేవదూతానె సంగరె అం పూర్వికులుకు దిల్లా వాక్యము సత్యమైలాట. సడకు అంగీకరించికిరి నాచలిగిల్లాలింకె సడకు తగిలా సిక్స పొందిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","ఎత్తె గొప్ప రక్సనకు అమె నిర్లక్స్యము కొర్నే క్యాకిరి తప్పించిగీపారొ? సా రక్సన ప్రబువు బోదించిలందరె ఆరంబమైకిరి, తంకెదీకిరి కూడ సున్లాలింకెదీకిరి అముకు సొత్తొబులికిరి నిరూపించబొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","పురువు తా చిత్తందీకిరి అద్బుతానెదీకిరి ఆచ్చర్యకార్యాలుదీకిరి బడే పరిసుద్దాత్మ వరాలు సంగరె తా సాక్సం దీసి. ");
INSERT INTO rei_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","అమె కొతాలగితల్లా యే లోకం బుల్నే అయితల్లా సే లోకముకు పరిపాలించితె పురువు తా దూతానెకు అదికారం దిల్లాని. ");
INSERT INTO rei_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","ఈనె జొనె గుటెపక్కరె యాకిరి ద్రుడముగా సాక్స్యం కొయిలీసి. ఓ దేవా తువ్వు మనమకు జ్ఞాపకము కొరిగిత్తె సెయ్యె కేపాటీట. సాదారనమైలా మనమకు దరిపించిగిత్తె కేపాటీట. ");
INSERT INTO rei_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","తువ్వు తంకు దేవదూతనెకన్నా కొంచెము తక్కువగా కొరిసు. మహిమ గౌరవం సంగరె తాకు కిరీటం లొగిసు. ");
INSERT INTO rei_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","తో అత్తొపైటంపరె తంకు అదికారం దీసు. తా గొడ్డొనెతొల్లె సొబ్బి రొయిదీసు. సెయ్యె సొబ్బి లోపర్చిలాబెల్లె తంకు నాలోపర్చికుంటా కేటకు సడదిల్లాని. ఉంచినె అమె సొబ్బి తాకు లోపరచబొడువురొ ఇంకా దిగిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","ఈనె పురువురొ క్రుపవలరె సెయ్యె‍ ప్రతి మనమ కోసం మొర్నొ అనుబవించిలపనికిరి దూతానెకన్నా కుండె తక్కువలింకెపనికిరి కొర్లా యేసు మొర్నొ పొందిలా వల్లరె మహిమా ప్రబావము దీకిరి కిరీటం పిందిలాపనికిరి తాకు దిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","కా నిమిత్తము సొబ్బి అచ్చొ కా వలరె సొబ్బి కలిగిలీసొ సెయ్యె బడెలింకయిలా పోనుకు మహిమకు దన్నెతందుకు తా రక్సనకర్తకు కొస్టోనె ద్వారా సంపూర్నుడుగా కొరితె తాకు ఇస్టమైసి. ");
INSERT INTO rei_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","పరిసుద్దం కొరిలాలింకు పరిసుద్దం యీలాలింకు సొబ్బిలింకు జొన్నాక బో. యే కారనం దీకిరి తంకు అన్నబయినె, అప్పబొయినీనెగా డక్కితందుకు యేసు లజ్జొపొడిలాని. ");
INSERT INTO rei_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","సడకు సెయ్యె పురువుదీకిరి తూ కొరిలాంచ గురించి, తో నా గురించి మో అన్న బయినుకు ప్రకటించిమి. ఈనె సమాజం మొజిరె తో గిత్తొ గైకిరి స్తుతించుంచి బులిసి. ");
INSERT INTO rei_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","ఈనె “మియ్యి తాకు నమ్మిగీకిరి అచ్చి” బులి ఇత్తొ “మియ్యెను పురువు మెత్తె దిల్ల పిల్లానెను బులి కొయిలీసి.” ");
INSERT INTO rei_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","ఈనె సే పిల్లానె మనమరొ దేకు పిందిగిల్లా యేసురొ రొగొతొ మొసొ గలిగిలాలింకె యీలందరె సే ప్రకారమాకా మొర్నొరొ అదికారం కలిగిలా అపవాదిరొ సక్తికు మొర్నొదీకిరి నాసనం కొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","ఈనె యాకిరి జీవిత కలొ అల్లా మొర్నొడొరొదీకిరి దాస్యముకు లోబడిలాలింకు చొడిపించిసి. ");
INSERT INTO rei_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","సెయ్యె దేవదూతానె సాయం కొరితందుకునీ. ఈనె యెడకు బదులుగా అబ్రాహామురొ సంతానముకు సాయం కొరితందుకాక అయిసి బులి స్పస్టమైలీసి. ");
INSERT INTO rei_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","ఈనె మనమానె పాపం క్సమాపన కలిగితె పురువురొ దయగల నమ్మకమైలా ప్రదానయాజకుడుగా రొయికిరి సొబ్బి విసయాల్రె సెయ్యె తా అన్నబయినె అప్పబొయినినుకు పాలివాడుగాయీసి. ");
INSERT INTO rei_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","సెయ్యె సోదింపబొడికిరి స్రమపొడిసి గనుక, సోదింపబొడిలాలింకు సహాయము కొరితె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","పురువుసంగరె డక్కబొడిలా మో తోటి విస్వాసులైలా అన్నబయినె అప్పబొయినీనె! అమె పొందిగిల్లా విస్వాసము వల్లరె అం ప్రదానయాజకుడుగా పురువు ద్వారా పొడదిల్లా యేసంపరె మనుసు దీగునొండి. ");
INSERT INTO rei_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","పురువురొ గొర్రె మోసే నమ్మకముగా రొల్లపనాక యెయ్యెకూడ సెయ్యె నియమించిలా సొబ్బిపైటిరె నమ్మకముగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","యెయ్యె మోసేకంటె బడే మహిమకు అర్హుడుగా యేసుకు బచ్చిగిచ్చి. గొరొకన్నా సడ బందిలాట బడే గనత పొందుసి. ");
INSERT INTO rei_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","ఈనె ప్రతీగొరొకు కేసోజొనెదీకిరి బదింపించుసె. యెడసొబ్బి బందిలాట పురువు జొన్నాక. ");
INSERT INTO rei_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","పురువు అగురుకు కొయితల్లా సంగతీనెకు సాక్స్యార్దముగా మోసే పరిచారకుడైకిరి పురువు గొరొబిత్తరల్లా నమ్మకముగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","ఈనె క్రీస్తు పో యీకిరి తా గొరొ వుంపరె నమ్మకముగా అచ్చి. దైర్యము, నిరీక్సన వలరె ఉత్సాహముకు చివరదాకా స్దిరముగా రొన్నే అమ్మాక తా గొరొ యీకిరచ్చొ. ");
INSERT INTO rei_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","ఈనె సడకు పరిసుద్దాత్మ యాకిరి కొయిలీసి. ఉంచినె తొమె పురువురొ స్వరము సునిలపనైనే ");
INSERT INTO rei_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","ఈనె బొనొరె సోదన దినొరె తొం పితరులు పురువుకు విరోదంగా రగ్గొ పుట్టించిలాపనికిరి తొం మనుసునుకు కటినము కొరిగిత్తెనాండి. ");
INSERT INTO rei_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","నలపై బొచ్చొరొనె మో కార్యమునెకు దిక్కిరి, తొం పితురూనె మెత్తె పరీక్సించికిరి సోదించిసె. ");
INSERT INTO rei_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","ఈనె మియ్యి సే తరములింకె వల్లరె విసిగిజేంచి తొమె కెబ్బుకు తొం హ్రుదయ ఆలోచనరె తప్పిజిల్లీసొ. మో బట్టోనుకు తెలిసిగిన్నార్లీసొ. ");
INSERT INTO rei_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","గనక మియ్యి రగ్గొసంగరె తంకు ప్రమానము కొర్లాపనికిరి తంకె మో విస్రాంతిరె ప్రవేసించినింతె బులి కొయిలించి. ");
INSERT INTO rei_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","అన్నబయినే జీవముగల్లా పురువు సడికిరిబాజిల్లాపనికిరి విస్వాసమునీల దుస్టహ్రుదయము తొంబిత్తరె కేసెయినెను గుటెబెల్లె అచ్చికీవొబులి బులి జాగ్రర్తగా దిగ్గునోండి. ");
INSERT INTO rei_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","యెడకు బదులుగా పాపము వల్లరె కలిగిలా బ్రమదీకిరి తొంబిత్తరె కేసైనను కటినపర్చిగీకిరి నారొల్లపనికిరి ఆజి బుల్లా సమయము తల్లాబెల్లాక ప్రతిదినె జొనుకు జొనె బుద్దికొయిగీండి. ");
INSERT INTO rei_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","కైంకిబుల్నే అగరెదీకిరి అముకు తల్లా ద్రుడ విస్వాసము అంతముదాకా గట్టిగా దరిగిన్నే క్రీస్తురె బాగస్తులైకిరి రోంచొ. ");
INSERT INTO rei_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","ఆజి తొమె తా స్వరం సునిలాపనైనే తొం పితరులు పనికిరి పురువుకు విరోదంగా బుల్లికిరి, తొం హ్రుదయములుకు కటినపర్చిగిన్నాసి బులి లేకనాల్రె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","పురువురొ గొల సునికిరి తాకు విరోదంగా రగో పుట్టించిలా యే ప్రజానె కేసే? అంకల్లా మోసే ద్వారా ఐగుప్తు దీకిరి బయలుదేరికిరి అయిలాలింకాక నీనా? ");
INSERT INTO rei_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","కా అంపరె నలపై బొచ్చొరోనె సెయ్యె రగో పొడిసి? పాపము కొర్లాలింకంపరాక నీనా? తంకల్లా మొడానెగా బొనొరె జొడిజీసె. ");
INSERT INTO rei_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","తా విస్రాంతిరె ప్రవేసించినింతెబులి కా గురించి ప్రమానము కొరిసి? అవిదేయులైలలింకె గురించాకనీనా. ");
INSERT INTO rei_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","ఈనె అవిస్వాసము సంగరె తంకె జెన్నారిసెబులి గ్రహించిలించొ. ");
INSERT INTO rei_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","తా విస్రాంతిరె ప్రవేసించిమంచి బుల్లా వాగ్దానము ఇంకా టారికిరిరొల్లా తొంబిత్తరె కేసైనెను గుటెబెల్లె సే వాగ్దానము నాకడిగీకుంటా తప్పిజిమ్మొకీవో బులి డొరొ కలిగికిరి తమ్మంచి. ");
INSERT INTO rei_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","తంకె ప్రకటించిలాపనికిరి అముకంకా సువార్త ప్రకటించబొడిసి. ఈనె తంకె సునిలలింకెదీకిరి విస్వాసము కలిక్కిరి మిసికిరినింతే గనుక సునిలా వాక్యము తంకు వ్యర్దమైజేసి. ");
INSERT INTO rei_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","ఈనె స్రుస్టి ఆరంబం తీకిరి తా సొబ్బిపైటినె సంపూర్తి కొరికిరి అచ్చి. యే విస్రాంతి గురించి గనక మియ్యి రగోసంగరె తంకు ప్రమానము కొర్లాపనికిరి తంకె మీ విస్రాంతి దూంచిబుల్లా దెసొరె తంకె ప్రవేసించినింతె బులి కొయిలించి. సెయ్యె కొయిలా కొతా సునికిరి విస్వాసులైలా అమె సే విస్రాంతిరె ప్రవేసించిలించొ. ");
INSERT INTO rei_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","ఈనె “పురువు సత్తరొ దినోరె తా కార్యముసొబ్బి ముగించికిరి విస్రమించిసి” బులి సత్తర దినొగురించి సెయ్యె గుటె పక్కరె కొయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","యెడానీకిరి యేచోటురాక తంకె మోవిస్రాంతిరె ప్రవేసించినింతె బులి కొయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","ఈనెను కేసో కుండె మంది విస్రాంతిరె ప్రవేసించుసెబుల్లా కొతా నిచ్చయము గనక అగరె సువార్త సునిలాలింకె విస్వసించిలానింతె గనక ప్రవేసించిలానింతె. ");
INSERT INTO rei_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","“ఆజి తొమె పురువురొ కొతా సునిలాపనైనే తొం మనుసూనెకు కటినపర్చిగిత్తెనాండి” బులి బడే పొచ్చాడె కొయిలా ప్రకారము ఎత్తెకలో అయిలా తరువాత దావీదు గ్రందమురె ఆజి బుల్లా గుటె దినొరె నిర్నయించిసి. ");
INSERT INTO rei_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","యెహోసువ తంకు విస్రాంతి కలిగించినె సే తరువాతరె పురువు వాగ్దానం కొరిలా ఇంగుటె దినొగురించి సెయ్యె నాకొయికుంటా రొయిత. ");
INSERT INTO rei_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","గనక పురువు సత్తరొ దినొరె విస్రాంతి కడిగిల్లాపనాక పురువురొ మనమానుకంకా విస్రాంతి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","కైంకిబుల్నే పురువు తా పైటీనుకు ముగించికిరి విస్రమించిలా ప్రకారము తా విస్రాంతిరె ప్రవేసించిలాట కూడ తా పైటీనుకు ముగించికిరి విస్రమించుసి. ");
INSERT INTO rei_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","గనక అవిదేయత వల్లరె తంకె పొడిజెల్లపనికిరి అంబిత్తరె కేసైనను నాపొడిజీకుంటా సే విస్రాంతిరె ప్రవేసించితందుకు ప్రయత్నం కొరిమండి. ");
INSERT INTO rei_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","కైంకిబుల్నే పురువురొ వాక్యము సజీవమైలా బలముగలిగిలాటైకిరి దీటఅంచుగలిగిలా కత్తిపనాట కెటువంటి కడ్గముకన్నా వాడిగా రొయికిరి పొర్నొఆత్మానెకు కీల్లుకు మూలుగునెకు యిడకడుకుంటా దూరికిరి హ్రుదయమురొ తలంపూనెకు ఆలోచనానెకు పరిక్సించిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","ఈనె పురువురొ ద్రుస్టిరె నాదిగిదిల్లాట కిచ్చినీ. అమ్మె సొబ్బీ దిగితల్లా పురువుకాక లెక్క కొయిమాసి. సే పురువురొ అంకీనెకు యే స్రుస్టిరె రొల్లా సొబ్బి మరుగునీకిరి తేటగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","పురువురొ సముకముద్వారా జెల్లా పురువురొ పో యీలా యేసు బుల్లా గొప్ప ప్రదానయాజకుడు అముకు అచ్చి గనక అమె పొందిగిల్లా విస్వాసముకు గట్టిగా దరిగిమ్మా. ");
INSERT INTO rei_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","అం ప్రదానయాజకుడు అం బలహీనతానె దీకిరి, అం దీకిరి సమాన అనుబవం కలిగిలాట. సొబ్బివిసయాల్రె అంపనాక సోదింపబొడినన్నా సెయ్యె పాపం నీలాటైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","గనక అమె కనికరం పొందికిరి సమయానుకూలమైల సహాయము కోసం క్రుప పొందితె దైర్యము సంగరె క్రుపా సింహాసనం పక్కరకు జెమ్మా. ");
INSERT INTO rei_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","ప్రతి ప్రదానయాజకుడు మనమానెతీకిరి ఏర్పాటు కొరిగీకిరి పాపోనె కోసం అర్పనానెకు బలీనెకు అర్పించితె పురువు విసయమైలా కార్యములు జరిగించితె మనమానె గురించి నియమించబొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","సెయ్యంకా బహీనతసంగరె ఆవరింపబొడికిరి తల్లందరె సెయ్యె కిచ్చి నాఅరకైలాలింకంపరె బట్టొతప్పిలాలింకంపరె ఓర్పుకలిగిలాటైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","సే కారనం వల్లరె మనమానె పాపోనె కోసం క్యాకిరొ సాకిరాక తా కోసంకూడా కోసం అర్పనము కొరివలిసిలాటైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","ఈనె కేసైనన్నా యే గనత తాకు సెయ్యాక పొందిగిన్ని గని అహరోనుకు డక్కిపించిలాపనికిరిరాక పురువుదీకిరి డక్కిపించిగీకిరి ప్రదానయాజకుడుగా యే గనత పొందుసి. ");
INSERT INTO rei_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","సాకిరాక క్రీస్తుకూడ ప్రదానయాజకుడైతందుకు తాకు సెయ్యాక గౌరవించబొడిలాని గని, తువ్వు మో పో బులి మియ్యి ఉంచినె తొత్తె జొర్నొకొరించి బులి తాదీకిరి కొయిలాపనాక తాకు పురువు హెచ్చించిసి. ");
INSERT INTO rei_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","సే ప్రకారమాక తువ్వు మెల్కీసెదెకురొ క్రమము చొప్పురె నిరంతరము తల్లా యాజకుడుగా అచ్చు బులి ఇంగుటె పక్కరె కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","యేసు బూమంపరె రొల్లా దినోన్రె గొప్ప కందసంగరె అంకిరె పని కడిగీకిరి, తాకు మొర్నొ తీకిరి రక్సించిలాటకు ప్రార్దన కొరిసి. యాచనలకు సమర్పించికిరి తగ్గింపు జీక కలిగికిరి రొల్లాబల్లె సెయ్యె అంగీకరించబొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","సెయ్యె పో గా రొయికిరి సెయ్యె పొడిలాస్రమవల్లరె విదేయతకు సుగ్గిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","ఈనె సెయ్యె సొబ్బి విసయాల్రె సంపూర్నసిద్ది పొందిలాటైకిరి తాకు విదేయులైలాలింకు నిత్యమైలా రక్సనకు దీతందుకు కారకుడైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","ఈనె తాకు పురువు యాజకుడైలా మెల్కీసెదెకురొ క్రమము చొప్పురె ప్రదానయాజకుడుగా పురువు నిర్నయించిసి. ");
INSERT INTO rei_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","యెడగురించి అమె కొయివలిసిలాంచ బడే సంగతీనె అచ్చెగాని తొమె సునితె బద్దకస్తులైలందరె వివరించువురొ కొస్టొ. ");
INSERT INTO rei_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","కలొసంగరె దిగినె తొమె బోదకునెగా తమ్మాసి గని పురువురొ కొతానె విసయంరె అగరొ మూలపటొనెకు తొముకు ఇంకా జొనె కొయివురైలీసి. తొమె దుద్దొపిలాలింకెపనాక అచ్చొ గాని బలమైలా కద్ది కైలాలింకె పనికిరినింతొ. ");
INSERT INTO rei_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","ఈనె దుద్దొపీలా సొబ్బిలింకె పిల్లానాక గనక నీతి వాక్యవిసయమురె తప్పు ఒప్పునె గురించి అనుబవజ్ఞానం నీలాటపనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","పరిపూర్నులు అయిలాలింకె తంకె అనుబవం సంగరె మేలు కీడులుకు ఆలోసించిలా జ్ఞానం కలిగికిరి తాసె. తంకాక బలమైలా కద్ది కావాలి. ");
INSERT INTO rei_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","కాబట్టి క్రీస్తు బోదరొ మూలపటోనె గురించి పదేపదే చర్చించువురొ మానిగీకిరి పరిపూర్నత పొందితే అగురుకు పరిపూర్నత పొందితందుకు కొనసాగించిమా. గోరమైలా పైటినె సడికిరి, మారుమనస్సు పొందివురొ, పురువురె విస్వాసము. ");
INSERT INTO rei_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","బాప్టీసం గురించి బోద, ముండొంపరె అత్తోనెపొగిలాట గురించి మొర్లిలింకె పునరుత్దానముకు నిత్యమైలాతీర్పు బుల్లా యే పునాదీనె ఇంక ఇంకా నాపొక్కుంటా రొమ్మండి. ");
INSERT INTO rei_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","పురువు అనుమతిదిన్నే అమె అగురుకు సాకిరి కొరిమండి. ");
INSERT INTO rei_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","విస్వాసంరె తొలిగిజిల్లా జొనె ఇంకా పచ్చాత్తాపం బిత్తురుకు క్యాకిరి అయిపారి? గుటె సారి ఎలిగించబొడికిరి, పరలోకసంబందమైలా వరముకు చక్కిదిక్కిరి పరిసుద్దాత్మరె పాలుపొందికిరి. ");
INSERT INTO rei_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","పురువురొ వాక్యముకు అయితల్లా కలొరొ సక్తుల గురించి అనుబవపూర్వకంగా తెలిసిగిల్లాలింకె. ");
INSERT INTO rei_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ఈనె తంకవిసయమురె పురువురొ పోకు ఇంకా సిలువపొగితె సొబ్బిలింకగరె తాకు అవమానము కొరిలీసె గనుక సాలింకు ఇంకా మారుమనుసు పొందిలాపనికిరి కొరువురొ అసాద్యము. ");
INSERT INTO rei_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","కైంకిబుల్నే నేల సడంపరె అత్తమానూ పొడిలా పనిపీకిరి కేసె బిల్లోకొరిలీసో తంకు అనుకూలమైలా పచ్చకు పచ్చిపించికిరి పురువు ఆసీర్వాదం దూసి. ");
INSERT INTO rei_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","ఈనె కొంటానె తుప్పానె గచ్చ తీగానెకు సడుంపరె బొడదిల్లాబెల్లె సడ నాపైటికైలాట బులి విసర్జించిలాటబులి సాపము పొందిలాట బులి ఆకరుకు నియ్య దీకిరి పుడ్డుపూసె. ");
INSERT INTO rei_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","గనక ప్రియమైలాలింకే, అమె యాకిరి కొయినన్నా తొమె అడకన్నా బొల్టైలా రక్సనకరమైలా స్దితిరాక అచ్చొబులి గట్టిగా నమ్మిలించొ. ");
INSERT INTO rei_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","తొమె కొర్లా కార్యముకు తొమె విస్వాసునెకు పరిచర్య కొరికిరి ఇంక పరిచర్య కొరువురొ వల్లరె తా నా దీకిరి దిగిదిల్లా ప్రేమకు పసిరిజీతె పురువు అన్యాయస్తుడునీ. ");
INSERT INTO rei_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","అమె కేట గురించి ఎదురు దిగిలించో సడ పొందితె ఆసక్తి దిగిపించిలాలింకెపనికిరి ఆకరి వరకూ రొమ్మాసి బులి మో గొప్ప ఆస. ");
INSERT INTO rei_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","తొమె బద్దకస్తులైకిరి నీకుంటా విస్వాసం దీకిరి, ఓర్పుదీకిరి పురువు దిల్లా వాగ్దానముకు పొందిగిమ్మాసి బులి అం ఆస. ");
INSERT INTO rei_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","పురువు అబ్రాహాముకు వాగ్దానము కొరిలాబెల్లె తాకన్నా గొప్పీటనీ గనక స్వయంగా తా తోడు బులికిరాక యే ప్రమానము కొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","కచ్చితముగా మియ్యి తొత్తె ఆసీర్వదించుంచి బులి సొత్తాక తొత్తె బడేజనముగా విస్తరించుంచి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","సే కొతా నమ్మిలా అబ్రాహాము ఓర్పుదీకిరి ఎదురు దిగిసి. గనక పురువురొ వాగ్దానపలము పొందిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","మానమానె తంకన్నా గొప్పీట తోడు బులి ప్రమానము కొరుసె. తంకె ప్రతీ వివాదముకు ప్రమానం దీకిరాక పరిస్కారము జరిగివొ. ");
INSERT INTO rei_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","పురువు తా వాగ్దాన విసయమురె తా ఉద్దేసముకు నామార్చిగిల్లాటైకిరి, వాగ్దానముకు పొందిగిత్తె వారసులైలాలింకు సడ స్పస్టము కొరిగిచ్చి. సడవల్లె వాగ్దానముకు తా ఉంపరె ప్రమానం కొరికిరి ద్రడపర్చిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","సడకు మార్పునీలా యే దీట విసయాల్రె పురువు సొరొకొతాకొయిని. సెయ్యె దిల్లాంచ కోసం ఎదురు దిగిలాలింకు గొప్ప ప్రోత్సాహం కలిగిలాపనికిరి యాకిరి కొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","యే నిరీక్సన అం జీకానెకు నాపిట్టిగిబాజీకుంటా స్దిరముగా రొయిదీతె లంగరు పనికిరి. సడ కచ్చితముగా స్తిరముగా, తెరబిత్తరెకు ప్రవేసించిలాపనికిరి కొరిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","కెబ్బుకు మెల్కీసెదెకు క్రమము చొప్పురె ప్రదానయాజకుడైలా యేసు తాండ్రెబిత్తరె అంకన్నా అగరె అమె పక్సముగా ప్రవేసించిసి. ");
INSERT INTO rei_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","అబ్రాహాము యుద్దంరె చార్లింకు రొజానుకు ఓడించికిరి బుల్లికిరి అయితల్లాబెల్లె సాలేముకు రొజా ఇంకా గొప్ప పురువురొ యాజకుడైలా మెల్కీసెదెకు అబ్రాహాముకు మిసిగీకిరి తాకు ఆసీర్వదించిసి. ");
INSERT INTO rei_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","సెల్లె అబ్రాహాము సొబ్బిఆండ్రె దొస్టొవొంతు తాకు దీసి. సెయ్యె సాలేము రొజాయిలందరె తా నా కు అగరె నీతికి రొజాబులికిరి తరువాత తా నాకు సమాదానపు రొజాబులి అర్దం. ");
INSERT INTO rei_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","మెల్కేసెదెకు బో గురించైనన్నా మా గురించైనన్నా వంసావలి కోసమైనా జొర్నొ మొర్నొ గురించన్నా ఆదారానె నీలాటైకిరి, జీలాకలొల్లా నిత్యము యాజకుడైలా పురువురొ పో కు పోలికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","దిగోండి యెయ్యె కెత్తొ గొప్పీటొ. మూల పురుసుడైలా అబ్రాహాము యుద్దమురె సెయ్యె పొందిగిల్లా సొబ్బివస్తువూనెరల్లా దొస్టొవొంతు దీసి. ");
INSERT INTO rei_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","ఈనె లేవి‍రొ పోనె యాజకత్వము పైటి పొందిలాలింకె తంకన్నబయినె అబ్రాహాము వంసమురె జొర్నైనన్నా, దర్మసాస్త్రము చొప్పురె తా సొంత మనమానైలా ఇస్రాయేలు ప్రజానె పక్కరె దొస్టొవొంతుకు కడిగిత్తందుకు ఆజ్ఞకు పొందికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","గాని మెల్కేసెదెకు లేవీ వంసముకు నాచెందినన్నా, పురువురొ వాగ్దానాలు పొందిగిల్లా అబ్రాహాము పక్కరె దొస్టొవొంతు కడిగీకిరి తాకు ఆసీర్వదించిసి. ");
INSERT INTO rei_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","ఆసీర్వాదం పొందిలాటకన్నా ఆసీర్వాదం దిల్లాట గొప్పీటబులి కొయితె సందేహం నియ్యి. ");
INSERT INTO rei_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","ఈనె లేవి క్రమముకు దిగినె మొర్నొకు గురైలాలింకె దొస్టొవొంతు కడిగిల్లీసె. గాని మెల్కేసెదెకు క్రమము చొప్పురె దిగినె కెబ్బుకూ జీవించిలాట కడిగిచ్చి బులి లేకనము కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","ఈనెమాను గుటె విదముగా కొయిమాసిబుల్నే అబ్రాహాము దొస్టొవొంతు దిల్లాపనికిరైనే దొస్టొవొంతు కడిగిత్తల్లా లేవియులుకూడా దొస్టొవొంతు పురువుకు దిల్లాపనికిరాక. ");
INSERT INTO rei_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","క్యాకిరిబుల్నే అమె సడ గురించి కొతాలగినె మెల్కీసెదెకు అబ్రాహాముకు మిసిగిల్లాబెల్లె లేవీ ఇంకా జొర్నైలాని గాని తా పితరులురొ దేరాక అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","సె లేవీయులు యాజకూనెగా సంపూర్నముగా కొర్నే అహరోనుకు బదులుగా, మెల్కీసెదెకు యాజకుడు క్రమమురె ఇంకాజొనె యాజకుడు అయివలిసిలా అవసరం రొయితానీ. ");
INSERT INTO rei_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","ఎడానీకిరి యాజకూనె మార్చబొడినే యాజకదర్మము కూడా మార్చుబొడుసి. ");
INSERT INTO rei_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","కా గురించి యే సంగతీనె కొయిసెవొ సే అం ప్రబువు వేరె వంసమురె జొర్నైసి. సే వంసమురోట కేసైనను కెబ్బే బలిపీటము పక్కరె పరిచర్య కొరిలానింతె. ");
INSERT INTO rei_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","అం ప్రబువు యూదా సంతానమురె జొర్నైసి బుల్లాట స్పస్టమాక .సె గోత్రవిసయమురె యాజకూనె గురించి మోసే కిచ్చికొయిలాని. ");
INSERT INTO rei_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","మెల్కీసెదెకు పోలికిరి రొల్ల వేరె యాజకుడు అయికిరి అచ్చి బులి అమె కొయిలా సంగతీనె బడే స్పస్టముగా అచ్చె. ");
INSERT INTO rei_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","సెయ్యె మనమాన్రొ ఆజ్ఞానెకు నియమాలు వల్లరె యాజకుడుగా నియమించబొడిలాని గాని నిత్యము జీకిరిరొల్ల సక్తిదీకిరి యాజకుడుగా నియమించబొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","క్యాకిరిబుల్నే తువ్వు నిరంతరము మెల్కీసెదెకు క్రమము చొప్పురె యాజకుడైకిరి అచ్చుబులి తా విసయంరె లేకనానె కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","సె దర్మసాస్త్రము కేటకు సంపూర్నసిద్ది కలిగించిలాని గని అగరెదిల్లా ఆజ్ఞ బలహీనమైలాటైలందరె ప్రయోజనంనీలందరె సడకు నివారనకొరికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","కైంకిబుల్నే మోసేకు దిల్లా దర్మసాస్త్రం కేటకు పరిపూర్తి కొరిలాని. ఈనె అముకు గొప్ప నిరీక్సన దీసి సడ ద్వారా అమె పురువు పక్కు చేరిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","యెడ విసయంరె పురువు ప్రమానము కొరిసి. ఈనె పొదర్లింకె యాజకూనెగా రొయితె కేసే ప్రమానం కొరిలానింతె. ");
INSERT INTO rei_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","ఈనె యేసు ప్రమానము ద్వారా యాజకుడు యీసి. ఆ విసయమురె పురువు తాసంగరె తా కొతా నామార్చిగీకుంటా కెబ్బుకూ యాజకుడుగా తాసు బులి ప్రబువు ప్రమానం కొరిసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","యే ప్రమానం ద్వారా యేసు స్రేస్టమైలా నోనిబందనకు బాద్యుడైసి. ");
INSERT INTO rei_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","ఈనె బడేలింకె యాజకూనె యీసెగాని మొర్నొ వల్లరె సే యాజకపైటికి కొనసాగించినారిసె. ");
INSERT INTO rei_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","ఈనె యెయ్యె నిరంతరము జీకిరిరొల్లాట గనుక మార్పునీలా యాజకత్వము కలిగిలాటయీసి. ");
INSERT INTO rei_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","యెయ్యె తా సంగరె పురువు పక్కు అయిలాలింకు పక్సముగా, విజ్ఞాపనము కొరితందుకు నిరంతరము జీవించిలీసి గనుక తంకు సంపూర్నముగా రక్సించితె సమర్దుడైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","యేసు పవిత్రుడు, నిర్దోసి, కల్మసంనీలాట, పాపోనెరె, నాచేరుకుంటా ప్రత్యేకముగా రొల్లాట మెగొమండలముకన్నా వేరుగా హెచ్చయిలాటైకిరి యాట ప్రదానయాజకుడు అముకు సొరిపొడిలాట. ");
INSERT INTO rei_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","యెయ్యె పొదరె ప్రదానయాజకూనె వల్లరె అగరె తా సొంత పాపోనె కోసం తర్వాతరె ప్రజానె పాపోనె కోసం దినెదినెకు బలీనెకు అర్పించితె అవసరంనీకుంటా సొబ్బిలింకుకోసం గుట్టెబెల్లాక తాకు సెయ్యాక బలి అర్పించిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","దర్మసాస్త్రము బలహీనమైలా మనమానుకు ప్రదానయాజకూనెగా నియమించిసి. గాని దర్మసాస్త్రము తర్వాతరె అయిలా ప్రమానము తా పో ద్వారా నియమించబొడికిరి సంపూర్నము కొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","అమె వివరించితల్లా సంగతీనె సారాంసం కెడబుల్నే, అముకు సాటపనా ప్రదానయాజకుడు జొనె అచ్చి. సెయ్యె పరలోకంరెరొల్లా గొప్పీటసింహాసమునకు బత్తొకైలా అత్తొ ఆడుకు ఆసీనుడైకిరి బొసిరికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","సెయ్యె అతిపరిసుద్దస్తలమురె బుల్నే మనమసంగరె నీకిరి ప్రబువాక స్దాపించిలా సొత్తాయిలా గుడారముకు పరిచారకుడు యీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","ప్రతీ ప్రదానయాజకుడు అర్పనలకు ఇంకా బలీనెకు పురువుకు బలిదీతె నియమించబొడిసి. సాకిరాక అం ప్రదానయాజకుడు కిడైనా అర్పించవలిసికిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","దర్మసాస్త్రం ప్రకారము అర్పనానె అర్పించితె యాజకూనె అచ్చె. గనుక యెయ్యె బూమంపరె రొన్నే కెబ్బుకూ ప్రదానయాజకుడుగా రొయితాని. ");
INSERT INTO rei_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","మోసే గుడారము అమర్చిగిల్లాబెల్లె పొరొతొ ఉంపరె తొత్తె దిగిదెల్ల మాదిరి చొప్పురె సమస్తముకు కొరితందుకు జాగర్తపొడు బులి పురువుదీకిరి హెచ్చిరింపబొడిల ప్రకారమురె యే యాజకూనె పరలోకసంబందమైలా వస్తువూనెరొ నీడ రూపమైలా గుడారము బిత్తెరె సేవ కొరిలీసె. ");
INSERT INTO rei_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","ఈనె యేసు ఉంచినె మరిబూతుయీల వాగ్దానాలురె నియమించిలా మరిబూతుయీల నిబందనకు పురువుకు మనమానెకు మొజిరొవ్యక్తిగా గొప్ప సేవకత్వము పొందికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","కైంకిబుల్నే సే అగరె నిబందన లోపము నీలాట యీనె దీటోనిబందనకు అవకాసం రొయితని. ");
INSERT INTO rei_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","ఈనె పురువు తా మనమాన్రొ తప్పూనె తెలిసిగీకిరి యాకిరి కొయిలీసి “ప్రబువు ఇదిగొ గుటె కలొ అయిలీసి. సెల్లె ఇస్రాయేలు గొరొలింకెదీకిరి యూదా గొరొలింకెదీకిరి మియ్యి నో నిబందన కొరుంచి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","ఎడ మియ్యి ఐగుప్తు దెసొ దీకిరి అంకె పితరులుకు దోరకు రప్పించితె తంకు అత్తొ దరిగిల్లా దినో దీకిరి మియ్యి కొరిలా నిబందనపనాట నీ. కెడబుల్నే తంకె మో నిబందనరె నమ్మకంగా నింతె గనుక మియ్యి తంకు విసయంరె పట్టించిగిల్లానీ బులి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","సె దినో ఈనె తరువాత ఇస్రాయేలు గొరొలింకు సంగరె మియ్యి కొరిలా నిబందన కిడబుల్నే తంకె మనసురె మో దర్మవిదీనె రొయిదీంచి తంకె హ్రుదయము ఉంపరె సడ రాసుంచి మియ్యి తంకు పురువొ యీకిరి తాంచి తంకె మెత్తె జనముగా తాసె. ");
INSERT INTO rei_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","తంకె బిత్తెరె కేసెను ‘ప్రబువుకు తెలిసిగిన్నెంతె’ బులి తా పట్టనంలింకె యీనెను తంక అప్ప బోయినీనె ఈనెను బోదించినీ ఈనె తంకెబిత్తరె చెన్నిలింకె మొదలుదీకిరి బొడొలింకె జాంక సొబ్బిలింకె మెత్తె తెలిసిగివ్వె. ");
INSERT INTO rei_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","మియ్యి తంకె తప్పూనె క్సమించికిరి ఇంకా తంకె పాపోనె కెబ్బుకూ గుర్తు కొరిగిన్ని బులి కొయిసి.” ");
INSERT INTO rei_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","పురువు నో నిబందన బులి కొయివురొ వల్లరె అగరోట పుర్ననిబందనగా కొరిసి. కిడబుల్నే కిడపుర్నాటవొ సడ అంతరించిజీతె సిద్దముగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","అగరె నిబందనరె ఆరాదనకు నియమానె ఈనె యేలొకో కూడ పరిసుద్దస్తలం నియమాలు దివ్వురొ యీసి. ");
INSERT INTO rei_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","కైంకిబుల్నే అగరె గుటె గుడారము ఏర్పర్చబొడిసి తాండ్రె బొత్తిస్తంబముకు, బల్లకు, సడ వుంపరె రొయిదిల్లా పురువుకు అర్పించిలా రొట్టీనె అచ్చె. సడకు పరిసుద్దచోటు బులి నా. ");
INSERT INTO rei_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","దీటొ తెరకు తెనిపొక్కరె అతిపరిసుద్దమైలా చోటురె గుడారము తాసి. సడ బడే అతిపరిసుద్దస్తలం. ");
INSERT INTO rei_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","తాండ్రె సాంబ్రానీ దూపంపొగిలా సున్న పెడి అచ్చి. సొబ్బియాడుకూ సున్నరేకులుదీకిరి రొల్లా నిబందన మందసము అచ్చి. సే మందసమురె మన్నా సంగరె తల్లా సున్నరొ గిన్నె, చిగిరించిలా అహరోను అత్తొబడ్డి, రాసికిరి రొల్లా దీట నిబందన పలకలు అచ్చె. ");
INSERT INTO rei_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","సడంపరె కరునాపీటముకు ఉంపరె మహిమ సంగరె రెక్కానె పిటిగీకిరి రొల్లా కెరూబులు అచ్చె. ఈనె ఉంచినె వివరముగా కొయివురొ యీనీ. ");
INSERT INTO rei_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","యెడ యాకిరి ఏర్పాటు కొరిలాబెల్లె యాజకూనె సేవకొరికుంటా, నిత్యము అగరె గుడారము బిత్తురుకు జోసె. ");
INSERT INTO rei_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","గాని బొచ్చుర్రె గుటెబెల్లె మాత్రమాక ప్రదానయాజకుడు జొన్నె తా కోసం తా మనమానె కోసం నాతెలిసికుంటా కొరిలా పాపోనె కోసం పురువుకు అర్పించిలా రొగొతొ దరిగీకిరి దీటొవ గుడారమురె ప్రవేసించివొ. ");
INSERT INTO rei_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","ఎడవల్లరె సే అగరె గుడారము ఇంకా నియమించిలాబెల్లె అతిపరిసుద్దచోటురె ప్రవేసించిలా బట్టరె డొరొపొడిలానీ బులి పరిసుద్దాత్మ తెలియపర్చిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","సె గుడారము వుంచినె కలోకు ఉదాహరనగా అచ్చి. యే ఉదాహరనరొ అర్దం కిడబుల్నే మనస్సాక్సి విసయమురె ఆరాదికుడైలాటకు సంపూర్నత నాకలిగించినార్లా అర్పనానెకు, జంతుబలీనెకు అర్పించిసె. ");
INSERT INTO rei_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","ఎడ నో క్రమము జరిగిలా కలొ అయిలాజాంక నియమించిబొడిసి. కైకుంట, పీకుంటా బడే విదములయిలా సుద్దీకరన పద్దతీనె సొబ్బీ దేరొ ఆచారమూనె మాత్రమాక. ");
INSERT INTO rei_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","ఈనె క్రీస్తు అయితల్లా మేలులువిసయమురె ప్రదానయాజకుడుగా అయికిరి, సెయ్యె నిత్యమైలా విమోచన సంపాదించికిరి అత్తోనెదీకిరి నాకొర్లాట నీకిరి, యే స్రుస్టికి నాసంబందించిలాట, మరి గనమైలా పరిపూర్నమైలా గుడారము సంగరె సేవకొర్లీసి. ");
INSERT INTO rei_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","మేకలురొ గయినెరొ రొగొతొసంగరె నీకిరి సొబ్బిలింకరొ నిత్యమైలా రక్సన కోసం తా సొంత రొగొతొదీకిరి గుట్టెబెల్లాక అతిపరిసుద్దచోటుకు ప్రవేసించిసి. ");
INSERT INTO rei_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","కైంకిబుల్నే మేకలరొ, ఎద్దులరొ రొగొతొకు మలినమైలాలింకంపరె గయిదూడరొ పోసొ జల్లువురొ వలరె దే బయల్రె పవిత్రం కలిగిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","నిత్యుడైలా ఆత్మ సంగరె తాకు సెయ్యె పురువుకు నిర్దోసిపనికిరి అర్పించిగిల్లా క్రీస్తురొ రొగొతొ నిర్జీవమైలా ఆచారమూనె సడికిరి అమె జీవముగలిగిలా పురువుకు సేవించితె తో మనస్సాక్సికి కెత్తో బడే సుద్దికొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","యే కారనం వలరె అగరె నిబందన కలోరె జరిగిలా అపరాదము దీకిరి విడుదల కలిగితె సెయ్యె మొర్నొ పొందితందుకు పురువుసంగరె డక్కబొడిలాలింకెపనికిరి నిత్యమైలా వారసత్వం గురించి వాగ్దానము పొందితె నిమిత్తము సెయ్యె నో నిబందనకు మొజిరొ మనమగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","మొర్నొసాసనం కేటె అచ్చొ సెట్టె మొర్నొ సాసనం రాసిలాలింకెరొ మొర్నొ అవసరము. ");
INSERT INTO rei_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","సె నియమం రాసిలాలింకె మొర్నొ పొందినాక సడ చెల్లుసి. సడ రాసిలాలింకె నామొర్జిన్నే సడ కెబ్బుకైనన్నా చెల్లునీ. ");
INSERT INTO rei_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","ఈనె యే కారనం వలరె అగరె నిబందనకూడ రొగొతొ నాఉపయోగించిలాపనైనే చెల్లుబాటు యిలానీ. ");
INSERT INTO rei_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","దర్మసాస్త్రం ప్రకారమురె మోసే ప్రతి ఆజ్ఞకు మనమానె సంగరె కొయిలా తరువాత సెయ్యె పనిదీకిరి, రొగొతొరంగు గల్లా, గొర్రెబల్లోనెదీకిరి, హిస్సోపు దీకిరి, గయీన్రొ, మేకలురొ రొగొతొనె కడిగీకిరి మనమానంపరె దర్మసాస్త్రం ఉంపరె జల్లిసి. ");
INSERT INTO rei_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","“సే తరువాత మోసే తంకసంగరె పురువు యే నిబందన రొగొతొ తొముకు దిల్లీసి యెడకు నిబందన గుర్తుగా ఆచరించు బులి కొయిసి.” ");
INSERT INTO rei_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","సాకిరాక గుడారము ఉంపరె సేవ పాత్రానె సొబ్బిటంపరె సే రొగొతొ జల్లిసి. ");
INSERT INTO rei_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","ఈనె దర్మసాస్త్రప్రకారమురె సొబ్బి వస్తువూనెకు రొగొతొదీకిరి సుద్ది కొరిమంచిబులి, రొగొతొ నాచిందించికుంటా పాపక్సమాపన కలిగినీ బులి కొయిపారొ. ");
INSERT INTO rei_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","పరలోకంరె రొల్లాంచకు పోలికిరి రొల్లా వస్తువూనె యాంచ బలీనె వలరె సుద్దికొరువురొ అచ్చి బులి ఈనె పరలోక సంబందమైలా యెడకంటె స్రేస్టమైలా బలినె వలరె సుద్దికొరుమాసి. ");
INSERT INTO rei_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","సడ వల్లరె సొత్తయిలా పరిసుద్దచోటురె పోలికిరి మనమానె అత్తోనె సంగరె కొరిలా పరిసుద్దచోటురె క్రీస్తు ప్రవేసించలానీ గాని, ఉంచినె అం కోసం పురువుకు సన్నిదిరె దిగిదీతందుకు పరలోకమురె ప్రవేసించిసి. ");
INSERT INTO rei_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","సెత్తాక నీ, ప్రదానయాజకుడు ప్రతీ బొచ్చురొ గయీన్రొ రొగొతొ కడిగీకిరి అతిపరిసుద్దచోటురె ప్రవేసించిసి, ఈనె క్రీస్తు సాకిరి బడేసార్లు తాకు సెయ్యె అర్పించిగిత్తె ప్రవేసించిలానీ. ");
INSERT INTO rei_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","సాకిరి ఈనెమాను జగత్తుపునాది మొదలు దీకిరి సెయ్యె బడే సారులు స్రమపొడివురొ యీసి. ఈనె సెయ్యె యుగములు సమాప్తిరె తాకు సెయ్యె బలిగా అర్పించిగిత్తందుకు పాపం కడిగిత్తె గుటెసారి ప్రత్యక్సపర్చబొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","మనమానల్లా గుటె సారి మొర్నొపొందిమంచి బులి నియమించబొడిసి. సే తరువాత పురువు సంగరె తీర్పు తీర్చబొడుసి. ");
INSERT INTO rei_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","దీటోసారంకా క్రీస్తుకూడ బడే పాపోనె బరించితె గుటెసారి అర్పించిబొడికిరి తా కోసం కనిపెట్టికిరి రొల్లాలింకు రక్సన నిమిత్తము పాపము నీకుంటా ప్రత్యక్సమైసి. ");
INSERT INTO rei_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","దర్మసాస్త్రము అయితల్లా మేలులురొ నీడగలిగిలాటాక గాని సే వస్తువూనెరొ సొత్తయిలా స్వరూపముగలిగిలాట నీ. ఈనె సే యాజకూనె ప్రతి బొచ్చొరొ అర్పించిలా గుటె విదమైలా బలీనె సడానుకు దన్నైలాలింకు కెబ్బుకు పరిపూర్నం కొరినారిసె. ");
INSERT INTO rei_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","సాకిరి కొరిలాలింకు సేవించిలాలింకె గుటె సారి సుద్దికొరిలా తరువాతరె తంకమనస్సాక్సికు పాపం కోసం జ్ఞాపకం రొన్ని ఈనె సడకు అర్పించితె మానిపూసె నీ. ");
INSERT INTO rei_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","ఈనె సే బలీనె అర్పించివురొ వల్లరె పాపోనె జ్ఞాపకము అయిలీసె. ");
INSERT INTO rei_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","కైంకిబుల్నె గయీన్రొ, మేకలురొ, రొగొతొ పాపోనెకు కడువురొ అసాద్యము. ");
INSERT INTO rei_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","ఈనె యే కారనం వల్లరె సెయ్యె యే లొకొరె ప్రవేసించిలాబెల్లె యాకిరి కొయిలీసి. “బలి కు అర్పనకు తువ్వు కోరిలాను గని మెత్తె గుటె దేకు‍ సిద్దం కొరిసు. ");
INSERT INTO rei_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","బలిపీటమంపరె గయీనుకు పుడ్డువురొ ఇంకా పాపం కోసం బలీనె అర్పించువురొ తొత్తె ఇస్టమైలాటనీ. ");
INSERT INTO rei_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","సెల్లె మియ్యి గ్రందపుచుట్టరె మోగురించి రాసిలా ప్రకారము దేవా, తో చిత్తము నెరవేర్చిలాపనికిరి ఇదిగొ మియ్యి అయించి.” ");
INSERT INTO rei_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","దర్మసాస్త్రం ప్రకారం అర్పించితల్లా యెడానల్లా ప్రకారం, బలీనె అర్పనానె బలిపీటమంపరె గయీనె పుడ్డువురొ పాపం కోసం బలీనె అర్పించివురొ తువ్వు కోరిలాను బులి సడ తొత్తె ఇస్టమైలాటనీ బులి అగరె కొయిలాపనాక. ");
INSERT INTO rei_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","తరువాత సెయ్యె తో చిత్తము నెరవేర్చితె ఇదిగొ మియ్యి అయికిరి అచ్చి బులి కొయిలీసి. సెయ్యె అగరోటకు మరిపీకిరి దీటోటకు స్తిరపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","ఈనె యేసుక్రీస్తు గుటె దే రె గుటె సారాక సొబ్బిటి కోసం పురువుకు అర్పించిగివురొ వలరె అమె అల్లా పాపందీకిరి పవిత్రపర్చబొడించొ. ");
INSERT INTO rei_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","ఈనె ప్రతీ యాజకుడు ప్రతీ దినె తా సేవరె, గుటె విదమైలా బలీనె బడేసార్లు అర్పించిసి కాని అర్పన ద్వారా పాపోనెకు కెబ్బుకూ కడువురొ యీలానీ. ");
INSERT INTO rei_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","యెయ్యె ఈనె పాపోనె కోసం కెబ్బుకూ టారిలా గుట్టాక బలి అర్పించికిరి పురువు బత్తొకైలా అత్తొ ఆడుకు బొసికిరి అచ్చి, ");
INSERT INTO rei_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","సెల్లె దీకిరి తా సత్రువూనె తా పాదమునెకు పాదపీటము కొర్లాజాంక కనిపెట్టిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","కైంకిబుల్నే గుటె అర్పనవల్లరె యెయ్యె పరిసుద్దపరిచిలాలింకు కెబ్బుకూ సంపూర్నునెగా కొరిసి. ");
INSERT INTO rei_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","యే విసయంరె పరిసుద్దాత్మకూడ అముకు సాక్సం దిల్లీసి. ");
INSERT INTO rei_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","సెయ్యె అగరె యాకిరి కొయిసి. ఈనె సె దినోయిలాబెల్లె తరువాత మియ్యి తంకెదీకిరి కొర్లా నిబందన యెడ మో దర్మనియమానెకు తంక హ్రుదయమునెరె రొయిదీసె తంక మనసూన్రె రాసుంచి బులి కొయిలా తరువాతరె. ");
INSERT INTO rei_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","తంక పాపోనెకు “తంక అక్రమమునెకు ఇంక కెబ్బుకూ జ్ఞాపకము కొరిగిన్నీ బులి” ప్రబువు కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","యెడ క్సమాపన కేటె కలుగుసొ సెట్టె పాపం కోసం బలీనె అర్పించివురొ ఇంక కెబ్బుకూ రొన్నీ. ");
INSERT INTO rei_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","అన్నబయినె, అప్పబొయినీనె అమె అతిపరిసుద్దచోటురె ప్రవేసించితందుకు యేసు మొర్నొ ద్వారా పరిపూర్నమైలా స్వాతంత్రం కలిగికిరి అచ్చొ, ");
INSERT INTO rei_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","నోట, ఇంకా జీవంగలిగిలాటైలా, తా దే బుల్లా తెర ద్వారా అముకు బట్టొ పిటిగీకిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","పురువురొ గొరొంపరె అముకు గొప్ప యాజకుడు అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","గనుక మనస్సాక్సిరె కల్మసము నీకుంటా ప్రోక్సింపబడిలా సుద్దహ్రుదయము గలిగిలాలింకె, నిర్మలమైలాబొల్ట పనిసంగరె గద్దిగిల్లా దే సంగరె గలిగిలాలింకెపని రొకిరి, విస్వాసవిసయమురె సంపూర్న నిరీక్సన కలిగికిరి యదార్దమైలా హ్రుదయము సంగరె అమె పురువురొ సన్నిదికి జెమ్మా. ");
INSERT INTO rei_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","వాగ్దానము కొర్లాట నమ్మకమైలాట ఈనె అమె నిరీక్సన విసయమైలాట అమె ఒప్పిగిన్నె కచ్చితంగా దరిగిమా. ");
INSERT INTO rei_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","ఇంకా ప్రేమించికుంట, బొల్టపైటీనె కొరితందుకు జొనెకు జొనె ప్రొత్సహించిగిమ్మండి. ");
INSERT INTO rei_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","కుండెలింకె సంగంగా కూడిగిల్లాపనికిరి తొమె కూడ సంగమురె కూడిగిత్తె మానిగితెనాండి ప్రబువు అయిల దినొ సమీపించిలీసి గనుక మరి బూతు జొనుకు జొనె ప్రొత్సాహించిగీండి. ");
INSERT INTO rei_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","అమె సత్యము గురించి అనుబవజ్ఞానం పొందిగిల్లా తరువాత బుద్దిపూర్వకముగా పాపము కొర్నే పాపోనెకు బలి ఇంక రొన్ని. ");
INSERT INTO rei_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","గాని న్యాయపు తీర్పుకు డొరొసంగరె ఎదురుదిగిమంచిబులి విరోదీనెకు నియ్యపనా సిక్స ఇంకా రోసి. ");
INSERT INTO rei_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","కేసెయీనెను మోసే దర్మసాస్త్రముకు నా ఆచరించికుంటా రొన్నే దీలింకె తిల్లింకె సాక్సీనెరొ కొతంపరె, నాకనికరించికుంటా తంకు మొర్నొ సిక్స పొగుసె. ");
INSERT INTO rei_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","సాకిరితన్నుగా పురువురొ పోకు గొడ్డోనెతొల్లె మండిపీకిరి, తాకు పవిత్రపర్చిలా నిబందన రొగుతొ అపవిత్రం బులి బావించికిరి క్రుపకు మూలమైలా పురువురొ ఆత్మకు దూసించిలాట కెత్తొ బూతు సిక్సకు పాత్రుడో తొమె ఆలోసించుగునోండి. ");
INSERT INTO rei_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","పగతీర్చువురొ మోపైటి, మియ్యాక ప్రతిపలం దూంచి బులి ప్రబువు కొయిలీసి. ఈనె ప్రబువు తా మనమానుకు తీర్పు తీర్చుంచి బులికిరి కొయిలాట అముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","జీవముగలిగిలా పురువురొ అత్తరె పొడువురొ బడే గోరము. ");
INSERT INTO rei_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","ఈనె పురువు తొముకు వెలిగించిలాతర్వాతరె స్రమదీకిరి కూడిల గొప్ప పోరాటము సహించిగిల్లా పూర్వదినోనుకు జ్ఞాపకము దన్నెగీండి. ");
INSERT INTO rei_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","గుటె విదముగా దిగినె, తొమె సొబ్బిలింకెదీకిరి నిందానె, బాదానె అనుబవించువురొ వల్లరె, సే సమయంరె స్రమానె అనుబవించిలాలింకెదీకిరి పాలిబాగస్తులైసొ. ");
INSERT INTO rei_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","క్యాకిరిబుల్నే తొమె కైదురె స్రమపొడిలాలింకు ఆదరించిసొ తొమె ఇంకా స్రేస్టమైలాట స్తిరమైలాటకు వారసత్వం పొందిగిమ్మొ బులి జనికిరి, తొం ఆస్తికు వొరిదీగిత్తందుకంకా సంతోసముగా ఒప్పిగిచ్చొ. ");
INSERT INTO rei_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","ఈనె తొం దైర్యముకు సడదీతెనాండి. సడకు ప్రతిపలముగా గొప్ప బహుమానము మిలుసి. ");
INSERT INTO rei_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","తొమె పురువురొ చిత్తముకు నెరవేర్చిలాలింకైకిరి తా వాగ్దానముకు పొందితె తొముకు ఓర్పు అవసరమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","“లేకనానెరె కొయిలాపనికిరి ఇంక కలొ బడే కొంచెమాక అచ్చి. అయితల్లాట ఆలస్యం నా కొరికుంటా ఆసి. ");
INSERT INTO rei_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","మోఅగరె నీతిమంతుడైలాట విస్వాసమూలంగాక జీవించుసి గాని సెయ్యె పొచ్చుకు బాజిన్నే తా వల్లరె మెత్తె సంతోసము రొన్నీ.” ");
INSERT INTO rei_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","ఈనె అమె నసించిజీతందుకు పొచ్చుకుబాజిల్లాలింకెనింతో గాని ఆత్మకు రక్సించిగిత్తందుకు విస్వాసము కలిక్కిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","విస్వాసము బుల్లాట నిరీక్సింపబొడిలాట సత్యస్వరూపముకు, అంకికి నా దిగిదెల్లాట దిగిదిల్లీబులి రుజువైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","ఏ విస్వాసం ద్వారా అం పూర్వికులు పురువు దీకిరి మెప్పుపొందిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","లొకొ పురువురొ వాక్యము వల్లరె నిర్మానమైనకిరిఅచ్చి. సడబట్టాక అంకికి దిగిదిల్లాటల్లా నాదిగిదిల్లా పదార్దాలుసంగరె నిర్మించబొడిసి బులి విస్వాసముసంగరె గ్రహించిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","విస్వాసముసంగరె హేబెలు కయీను కన్నా స్రేస్టమైలా బలి పురువుకు అర్పించిసి. పురువు తా అర్పనానె కోసం సాక్సం దిల్లాబెల్లె సెయ్యె తా విస్వాసముసంగరె నీతిమంతుడుబులి సాక్స్యము పొందిసి. సెయ్యె మొర్జిన్నన్నా తా విస్వాసముగురించి కొతాలగిలీసె. ");
INSERT INTO rei_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","విస్వాసముసంగరె హనోకు నామొర్జిల్లా అగరాక పురువు కొనిగీబాజీసి. సెయ్యె కాకు దిగదిల్లానీ కైంకి బుల్నే లేకనానె కొయిలాపనాక సెయ్యె నామొర్జిల్లా అగరె పురువుకు ఇస్టంగా రొయితై. ");
INSERT INTO rei_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","విస్వాసమునీకుంటా పురువుకు ఇస్టంగా రొవ్వురొ అసాద్యము పురువుపక్కు అయిలాలింకె సెయ్యె అచ్చిబులికిరి తాకు కుజ్జిలాలింకు పలితం దూసిబులి నమ్మిమంచి. ");
INSERT INTO rei_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","విస్వాసముసంగరె నోవహు సడ నా దిగిలా సంగతీనె గురించి పురువుసంగరె హెచ్చరించబొడిలా బెల్లె బయబక్తులు గలిగిలాలింకె తా గొరొలింకు రక్సన కోసం గుటె పడవ సిద్దం కొరిసి సడసంగరె సెయ్యె లొకొ ఉంపరె నేరం మోపికిరి విస్వాసము సంగరె కలిగిలా నీతికి వారసుడు యీసి. ");
INSERT INTO rei_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","పురువు అబ్రాహాము డక్కిలాబెల్లె విస్వాసము సంగరె సె డక్కకు లోబొడికిరి సెయ్యె స్వాస్ద్యముగా కడిగిల్లా చోటుకు బయలుదేరికిరి జేసి. ఈనె కేటికి జెమ్మంచో సెడ నా తెలిసిగీకుంటా బయలుదేరికిరి జేసి. ");
INSERT INTO rei_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","విస్వాసము సంగరె సెయ్యె తా సంగరె సే వాగ్దానముకు సమాన వారసుడు యీలా ఇస్సాకు యాకోబు బుల్లాలింకె గుడారమురె రొల్లాబెల్లె పొదరెలింకెరొ దెసొరె రొల్లాపనాక వాగ్దాన దెసొరె పరదేసులుగా జీవించిసె. ");
INSERT INTO rei_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","ఈనె పురువు కిడకు సిల్పిగా నిర్మానకుడైకిరి అచ్చొ సాస్వతమైల పునాదీనె పనికిరి సే పట్నము కోసం అబ్రాహాము ఎదురు దిక్కికుంటా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","విస్వాసము సంగరె అబ్రాహాము మొంత్రకలోరె బో యీసి ఇంకా సారా గర్బము అయినెను సక్తి పొందిసి సెయ్యె పురువుకు నమ్మిసి తా వాగ్దానము నెరవేర్చిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","సెడసంగరె మొర్నొకు పక్కుయీనెను సె జొన్నెదీకిరి సంక్యకు మెగొరె నక్సత్రములుపనికిరి, సొంద్రొ బల్లిపనికిరి గొనినార్లా సంతానము కలిగిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","అంకె సె వాగ్దానము బుల్లా పలము నా అనుబవించుకుంటా బాజీసె, దూరుతీకిరి దిక్కిరి వందనము కొరికిరి సెయ్యె బూమి అంపరె పరదేసులైకిరి యాత్రికులైకిరి అచ్చెబులి ఒప్పిగీకిరి, విస్వాసము గలిగిలాలింకైకిరి మొరిజేసె. ");
INSERT INTO rei_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","యాకిరి కొయిలాలింకె తంకస్వదేసముకు కుజ్జిలించొ బులి తంకె నిరూపించిగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","తంకె కే దెసోదీకిరి అయిసెవొ సే దెసొకు జ్ఞాపకం కొరిగిన్నే ఇంకా జేతందుకు తంకు అవకాసం కలిగికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","ఈనె తంకె ఇంక స్రేస్టమైలా దెసొ బులి పరలోకసంబంమైలా దెసొకు కోరిగిల్లీసె. సడసంగరె సెయ్యె తంకె పురువు బులిగిత్తందుకు పురువు తంకు కోసం లజ్జొపొడిని కైంకిబుల్నే తంకోసం గుటె పట్నము సిద్దిపర్చికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","పురువు వాగ్దానము కొరిలా అబ్రాహాముకు తా జొర్నైలా జొన్నె పో కు బలిదేబులి మగిలాబెల్లె సెయ్యె తాకు జొర్నైలా ఏకైక పోకు బలిదీతె సంతోసముగా ఒప్పిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","ఈనె పురువు తాసంగరె ఇస్సాకువలరె తొత్తె జొర్నైలా సంతానంవల్లరె కలిగిలాటాక మియ్యి వాగ్దానం కొరిలా సంతానం ఊసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","పురువు మొర్జిల్లాలింకంకా జీపించితందుకు సక్తిగల్లాటబులికిరి జనిలాటైలా అబ్రాహాము తా పో యీలా ఇస్సాకుకు మొర్నొతీకిరి బుల్లికిరి దీసి. ");
INSERT INTO rei_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","విస్వాసముసంగరె ఇస్సాకుకు జరగవలిసిలా సంగతీనె విసయమైకిరి యాకోబుకు ఏసావుకు ఆసీర్వదించిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","విస్వాసముసంగరె యాకోబు మొర్నొ కలొ అగరె యోసేపు పోనె జొనెజొనుకు ఆసీర్వదించికిరి తా అత్తొబడ్డి మొదలు ఉంపరె ఆనిగీకిరి పురువుకు పూజించిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","యోసేపు తాకు మొర్నొ కలో అయిలాబెల్లె విస్వాసముసంగరె ఇస్రాయేలు పోనె ఐగుప్తుకు సడదీకిరి జెవ్వురొ గురించి కొతాలక్కిరి తా అస్తికానె తంకె సంగరె దనిజాండిబులి ఆజ్ఞాపించిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","మోసే జొర్నైలాబెల్లె తా మా బో సె సన్నిపిల్లకు బొల్లెరొవురొ దిక్కిరి విస్వాసముసంగరె రొజాజ్ఞకు నాడొరొకుంటా తింటమసోనె తాకు నుచ్చిదీసె. ");
INSERT INTO rei_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","మోసే బొట్ట యీలాబెల్లె విస్వాసముసంగరె రొజారొ జో రొ పో బులి కొయిగిత్తె ఇస్టపొడిలానీ. ");
INSERT INTO rei_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","కుండె కలొ పాపబోగము అనుబవించువురొకన్నా పురువురొ మానమానెదీకిరి కొస్టొనె అనుబవించువురొ బొల్టబులిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","ఐగుప్తురొ పలియ సంపద అల్లా అనుబవించువురొకన్నా క్రీస్తుకోసం గొప్ప అవమానం పొందితె బొల్టబులి, అగురుకు పొందిగివ్వొలిసిలా బహుమానం కోసం ద్రుస్టిరెదీగీకిరి యాకిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","విస్వాసము సంగరె మోసే నాదిగదిల్లా పురువుకు దిక్కుంటా స్తిరమైలాబుద్దికలిక్కిరి రొజా ఆజ్ఞకు నాడొరికిరి ఐగుప్తుకు సడదీకిరి బాజీసి. ");
INSERT INTO rei_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","ఇస్రాయేలురొ తొలిచూరు పిల్లానుకు మొర్నొదూత నామొరదీకుంటా విస్వాసముసంగరె పస్కాకు ఆచరించికిరి సే రొగుతొకు ద్వారాలుకు మక్కిసె. ");
INSERT INTO rei_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","విస్వాసముసంగరె తంకె ఆరిజిల్లా నేలంపరె సలిలాపనికిరాక గొర్ర సొంద్రొతీకిరి సలిగీకిరి బాజీసె. ఐగుప్తులింకె సాకిరికొరితెజేకిరి బుడ్డిజీసె. ");
INSERT INTO rei_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","విస్వాసముసంగరె సత్రదినోజాంక ఎరికో పట్నం చుట్టూ బుల్లిలా తరువాతరె యెరికో గోడానె కూలిజీసె. ");
INSERT INTO rei_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","విస్వాసముసంగరె రాహాబు బుల్లా దర్నింట దెసొకుపరిసీలించిలాలింకు సమాదానంగా నుచ్చిదిల్లందరె అవిదేయులైలాలింకెదీకిరి నానసించుకుంటా తప్పించబొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","ఇంక కెడ కొయిమంచి? గిద్యోనుకు, బారాకు, సమ్సోను, యెప్తా, దావీదు, సమూయేలు తంకు గురించి ప్రవక్తానె గురించి వివరించితందుకు సమయం చాలిని. ");
INSERT INTO rei_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","తంకె విస్వాసముదీకిరి రాజ్యాలుకు జయించిసె. నీతికార్యమునెకు జరిగించిసె. వాగ్దానాలుకు పొందిగిచ్చె. సింహాలురొ తుండొనె బుజ్జిపించిసె. ");
INSERT INTO rei_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","నియ్యకు రొల్లా బలము చల్లార్చిసె. టికిలి బుసానెకు తప్పించిగిచ్చె. బలహీనునెగా రొయికిరి బలపర్చబొడిసె. యుద్దంరె పరాక్రమసాలులైసె. సత్రుసేనలుకు పొక్కదీసె. ");
INSERT INTO rei_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","విస్వాసందీకిరి మొట్టానె మొర్నిజిన్నె తంకలింకు పునరుత్తానమువలరె ఇంకా పొందిగివ్వె. ఇంకాకుండెలింకె యీనె ఇంకా స్రేస్టమైలా పునరుత్తానము పొందిగిమ్మాసిబులికిరి విడుదల కావాలిబులి కొరిలాని. ");
INSERT INTO rei_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","ఇంక కుండె లింకె అవమానాలుకు, కొరడామడ్డొనె ఇంకా బందకాలుకు కైదికు అనుబవించిసె. ");
INSERT INTO rei_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","పొత్రొనె సంగరె మరిపించిసె, రంపాలుసంగరె కట్టిపించిగిచ్చె, సోదింపబొడిసె, కడ్గము సంగరె మొరిదీపించిగిచ్చె, గొర్రె చొమ్మోనె మేక చొమ్మోనె పొగ్గీకిరి, దరిద్రులుగా రొయికిరి కొస్టోనె పొడికిరి హింసించబొడిసె, ");
INSERT INTO rei_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","బొనొరె పొరొతొంపరె గొరోనెరె బూమి తొల్లె రొల్ల సొరంగమురె బుల్లికుంటా అచ్చె. సాలింకు యే లోకొ యోగ్యమైకిరి నీ. ");
INSERT INTO rei_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","అంకె అల్లా విస్వాసముసంగరె సాక్సం కడిగిల్లాలింకె ఈనెను, అంకె పురువుసంగరె వాగ్దానపలము అనుబవించినారె. ");
INSERT INTO rei_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","కైంకిబుల్నే అమె నీకుంటా తంకె సంపూర్నునె యీనాసి బులి పురువు అం కోసము ఇంక స్రేస్టమైలాటకు అగరాక సిద్దపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","ఎత్తె గొప్ప సాక్సిసమూహం అం చుట్టూ ఆవరించికిరితల్లందుకు తేలికగా చిక్కూనె దిల్లా పాపముకు సడదీకిరి, అం అగరె రొయిదిల్ల పందెమురె ఓపికదీకిరి దొమిడిమా. ");
INSERT INTO rei_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","విస్వాసముకు కర్తైకిరి సడకు కొనసాగించిలా యేసు ఆడుకు దిక్కుంటా, సెయ్యె అమె అగరె రొయిదిల్ల ఆనందం కోసం అవమానముకు లెక్కనాకొరుకుంటా సిలువుకు సహించికిరి పురువు సింహాసనంరొ బత్తొకైలా అత్తొ ఆడుకు ఆసీనుడు యీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","తొమె నాఅలిసికిరి తొం పొర్నొనె నావిసుకుపొడికుంట రొల్లపని పాపాత్ములు తాకు వ్యతిరేకముగా కొరిలాంచకు సహించిగిల్లాటకు గురించి ఆలోచించోండి. ");
INSERT INTO rei_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","తొమె పాపము సంగరె పోరాడుటరె రొగొతొ గొలిలాపన ఇంక సడకు ఎదురించిలానీ. ");
INSERT INTO rei_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","పురువు తా పోనె జో నె సంగరె కొతాలగినె ప్రొత్సాహపరిచిలా కొతానె పసిరిజీసోనా? మో పో ప్రబువు కొరిలా సిక్సకు నాత్రునికరించికిరి సెయ్యె తొత్తె హెచ్చిరించిలాబెల్లె విసిగితెనా. ");
INSERT INTO rei_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","కైంకి బుల్నె ప్రబువు సెయ్యె ప్రేమించిలా పతీలింకు సిక్సించికిరి తాకు స్వీకరించిలా ప్రతీ పోకు సరికొరుసి. ");
INSERT INTO rei_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","సిక్సాపలము పొందితె తొమె సహించిలీసొ. పురువు పోనెపనాక తొముకు దిగిలీసి. బో నాసిక్సించిలా పో కేసైనా అచ్చెనా? ");
INSERT INTO rei_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","పో యీలాలింకె అల్లా సిక్సరె పాలుపొందిలీసె, తొమె నాపొందినె పొదర్లింకాక గాని పోనె నీ. ");
INSERT INTO rei_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","ఈనె దే సంబందులైకిరి బోనె తంకు సిక్సంచిలాపన అచ్చె. తంకె బిత్తెరె డొరొబీతి కలిగికిరి అచ్చొ సాకిరి ఈనె ఆత్మానెకు బో యిలా తాకు మరి బడే లోబొడికిరి జీమంచి నీ! ");
INSERT INTO rei_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","తంకె కుండె దినోనె తాకు యిస్టము యీలబెల్లె అముకు సిక్సించిసె గాని అమె తా పరిసుద్దతరె పాలుపొందిమంచిబులి అం మేలు కోసమాక సెయ్యె సిక్సించిలీసి. ");
INSERT INTO rei_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","ఈనె ఉంచినె సొబ్బిసిక్స బాదగా దిగదూసి సంతోసముగా దిగిదిన్నీ. ఈనె తాండె అబ్యాసము కలిగిలాలింకు సడ నీతిబులి సమాదానమైల పలాలు దూసి. ");
INSERT INTO rei_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","ఈనె అలిసిజిల్లా అత్తోనె నీరసించిజిల్లా మోకాల్లుకు బలపరచోండి. ");
INSERT INTO rei_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","ఈనె సొట్టగొడ్డొ నా బెనుక్కుంటా బొల్లెయిజిల్లా నిమిత్తము తొం గొడ్డొనుకు బట్టోనె తిన్నగా కొరిగీండి. ");
INSERT INTO rei_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","సొబ్బిలింకె సంగరె సమాదానముగా పరిసుద్దత కలిగిరొయితందుకు ప్రయత్నించొండి. పరిసుద్దత నీకుంటా కేసె ప్రబువుకు దిగినింతె. ");
INSERT INTO rei_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","తొమె కేసెయీనెను పురువురొ క్రుపకు నా పొందికుంటా తప్పుజూసుకివో బులి చేదు యీలా సెరొ కిరయీనెను తొంబిత్తరె మొలిచికిరి బడేలింకె అపవిత్రూనె యీజోసొ కీవో దిగ్గీండి, ");
INSERT INTO rei_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","గుటె పూట కద్దికోసం తా జ్యేస్టత్వపు హక్కు బిక్కిలా ఏసావుపనా దైవబీతినీలా దర్నిట పనాట అచ్చెకీవొ బులి జాగర్తగ దిగ్గీండి. ");
INSERT INTO rei_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","ఏసావు సే తరువాత బో పక్కరె ఆసీర్వాదము కడిగిమంచి బులి అంకీనెరె పని సడదీకిరి కెత్తో స్రద్దసంగరె కుజ్జినన్నా సెయ్యె మారుమనుసు పొందితె అవకాసం మిల్లాని సెయ్యె సడదీసి బులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","తొమె ఇస్రాయేలులింకె అత్తొ సంగరె సుంగీకిరి తెలిసిగిల్లపన, పుడ్డితల్లానియ్య, వొందారొ కమ్మిల మెగొకు సంగరె ఆక్రమించిలా, తుపానుకు కమ్మిల సీనాయి పొరొతొ పక్కు అయిలానీ. ");
INSERT INTO rei_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","బూరసబ్దముకు, కొతానె సబ్దముకు తొమె అయికిరినింతొ. సే సబ్దము సునిలాలింకె మరి కే కొతా కొయినాసి బులి బతిమాలిగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","కైంకిబుల్నే తంకె సే కొయిలా ఆజ్ఞానెకు సునితె తట్టిగిన్నారిసె ఇంకా సే పొరొతొకు సుంగిల్లా జంతువుయీనెనూ పొత్రొనె సంగరె మరికిరి మొరదిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","ఈనె సడ దిగితే కెత్తో బయంకరముగా రొల్లందరె మోసే మియ్యి కెత్తో డొరిజేకిరి వొనికిలించి బులిసి. ");
INSERT INTO rei_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","ఉంచినైనె తొమె అయిలాట, సీయోను బుల్లా పొరొతొకు జీవం కలిగిలా పురువురొ పట్నము బుల్లా పరలోకపు యెరూసలేముకు హొజారొజారు కొల్దీ దేవదూతానె పక్కు అయిసొ. ");
INSERT INTO rei_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","పరలోకమురె రాసికిరి రొల్లా పురువురొ అగరొ పోరొ సంగముకు, తంకె మహోత్సవముకు సొబ్బిలింకూ న్యాయాదిపతి యీలా పురువు పక్కరకు సంపూర్నస్తితి పొందిలా నీతిమంతునెరొ ఆత్మానె పక్కరకు అయిసు, ");
INSERT INTO rei_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","నోనింబందనకు మొజిరెమనమైలా యేసుపక్కరకు హేబెలుకన్నా ఇంకా స్రేస్టముగా పలికిలా వొలికించిలా రొగుతొ పక్కు తొమె అయికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","తొముకు బుద్ది కొయిలాలింకు ఎదురునాకొయికుంటా దిగ్గీండి. తంకె బూమంపరె తీకిరి బుద్ది కొయిలాలింకు కొత నాసునుకుంటా తప్పించిగిన్నె పరలోకం దీకిరి బుద్దికొయిలాటకు విసర్జించిలా అమె తప్పించిగిన్నారొ బుల్లాట మరి సొత్తాకనీనా. ");
INSERT INTO rei_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","సెల్లె సెయ్యె సబ్దము బూమికి కదిలించిసి ఈనె ఉంచినె మియ్యి ఇంకగుటె సారి బూమికు మాత్రమాకనీ గని మెగొకూడ కదిలించిమి బులి కొతాదీసి. ");
INSERT INTO rei_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","“ఇంకగుటె బెల్లె” బుల్లా కొతా కెడ కొయిలీసి బుల్నె, కదిలించినార్లాంచ మిగిల్లాపనికిరి, కదిలించబొడిలంచకు బుల్నె స్రుస్టించబొడిలాంచకు కడిపెవురాక. ");
INSERT INTO rei_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","సడవల్లరె అమె నిచ్చలమైలా రాజ్యము పొందిగీకిరి, పురువుకు ఇస్టమీలపన తాకు హెచ్చించుకుంటా డొరొసంగరె క్రుతజ్ఞతలు చెల్లించిమండి. ");
INSERT INTO rei_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","కైంకిబుల్నే అం పురువు దహించిలా నియ్యైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","క్రీస్తురె అన్నబయినె అప్పబొయినీనె పనికిరి జొనుకు జొనె ప్రేమించిగీండి. ");
INSERT INTO rei_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","ఆతిద్యము కొరువురొ పసిరిజీతెనాండి సడవలరె కుండెమంది నాజనికిరి దేవదూతానెకు ఆతిద్యం దీసె. ");
INSERT INTO rei_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","తొమె తంకె సంగరె బందింపబొడిలాపనాక బందకమురొల్లలింకు జ్ఞాపకము కొరిగీండి. తొమె స్రమల్రె అచ్చొబులిగీకిరి, ఈనె స్రమల్రె రొల్లాలింకు జ్ఞాపకము కొరిగీండి. ");
INSERT INTO rei_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","బ్యా సొబ్బి విసయాల్రె గనమైలాట, గొయిత, నెయిపొ దీలింకె జొనంపరె జొనె నమ్మకంగా రొమ్మంచి. నీతినీలాలింకు దర్నిపైటికొరిలాలింకు పురువు తీర్పు దూసి. ");
INSERT INTO rei_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","పలియాసనీకుంటా తొముకు కలిగిలాటదీకిరి త్రుప్తిపొందిగీండి తొత్తె కేమాత్రము సడిదిన్నీ, తొత్తె కెబ్బుకూ ఎడబాసినీ బులి సెయ్యె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","ఈనె ప్రబువు మెత్తె సాయం కొరిలాట. మియ్యి డొరినీ మెత్తె కేసైనెను కిడకొరిపారె? బులి బొల్ట దైర్యముదీకిరి కొయిపారి. ");
INSERT INTO rei_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","తొముకు పురువురొ వాక్యము బోదించికిరి, తోవుంపరె బొడిలింకెగా రొల్లలింకు జ్ఞాపకము కొరిగీకిరి, తంకె మొర్నొజాంక తంకరొ జీవించిలా ప్రవర్తనపలముకు‍ స్రద్దగా తలంచిగీకిరి తంకె విస్వాసముకు అనుసరించొండి. ");
INSERT INTO rei_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","యేసుక్రీస్తు కాలె, ఆజి గుటెపనాక అచ్చి కెబ్బుకు గుటెపనాక తాసి. ");
INSERT INTO rei_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","బడెరకాలుయిలా పొదరొ బోదసంగరె తొం బట్టొదీకిరి నాబుల్లిజాండి. కద్దివల్లరె నీకుంటా, క్రుపసంగరె హ్రుదయము బొల్లెకొరిగినె బొల్టాకద్దినెవల్లరె ప్రవర్తించిలాలింకు కిచ్చి ప్రయోజనము కలిగిలానీ. ");
INSERT INTO rei_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","యూదునెరొ ప్రార్దన చోటురె సేవ కొరువురొ యాజకూనెకు అమె బలిపీటము ఉంపరె అర్పించిలాట కైతె అదికారము నీ. ");
INSERT INTO rei_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","ఉంచినెజాంక పాపపరిహారార్దచోటురె యూదు ప్రదానయాజకుడు పసువుల రొగొతొ దన్నెలిసె, సె జంతువుల కలేబరమునె గుడారము దోరె పుడ్డిపీలీసె. ");
INSERT INTO rei_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","సడవల్లరె యేసుకూడ తా రొగొతొ సంగరె మనమానెకు పరిసుద్దం కొరితె పట్నం దోరె కొస్టొపొడిసి. ");
INSERT INTO rei_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","ఈనె అమె తా నింద పొడికిరి బరించిగీకిరి గుడారము దోరకు తా పక్కు జెమ్మా. ");
INSERT INTO rei_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","స్తిరమైలా పట్నము అముకు బూమంపరె నీ గాని అయితల్లా పట్నం కోసం ఎదురు దిగిలించొ. ");
INSERT INTO rei_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","ఈనె తా సంగరె అమె పురువుకు కెబ్బుకు స్తుతియాగము కొరిమా బులి తా నామముకు ఒప్పిగిల్లా జిబ్బొపలము అర్పించించొ. ");
INSERT INTO rei_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","బొల్టకొరువురొ, జొనుకు జొనె సాయం కొరువురొ తొమె పసిరిజేతేనాండి. సాకిరి కొరువురొ తాకు ఇస్టమైలా బలి. ");
INSERT INTO rei_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","తొం ఉంపరె నాయకులుగా రొల్లాలింకె లెక్క ఒప్పకొయిలాలింకెపనికిరి తొం ఆత్మానెకు జొగిలీసె తంకె బాదసంగరె సే పైటి కొర్నే తొత్తె ప్రయోజనమునీ గని ఈనె బాదసంగరె నీకిరి ఆనందము సంగరె కొరిలాపనికిరి తంక కొతా సునికిరి తంకు లోబొడికిరి రోండి. ");
INSERT INTO rei_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","అం కోసం ప్రార్దనకొరండి అమె సొబ్బి విసయమురె యోగ్యముగా ప్రవర్తించిలాపని బొల్ట మనస్సాక్సి కలిక్కిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","ఈనె మియ్యి మరి బేగా తొం పక్కు అయిలాపనికిరి బడే ప్రార్దన కొరుబులి తొముకు బతిమాలిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","అం గొప్ప జొగులొతాయీలా యేసు బుల్లా అం ప్రబువు నిత్యమైలా నిబందంన సంబందమైలా రొగొతొవల్లరె మొర్నొదీకిరి ఉటిలా సమాదానకర్తైలా పురువు. ");
INSERT INTO rei_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","ప్రతీ బొల్టవిసయమురె తా చిత్తప్రకారము కొరితందుకు తొముకు సిద్దపరిచిమాసి. యేసు క్రీస్తుద్వారా తాకు అనుకూలమైలాంచకు తొంబిత్తరె జరిగించిలీసి. యేసుక్రీస్తు ద్వారా యుగయుగములుకు మహిమ కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","అన్నబయినె అప్పబొయినీనె తొమె, ఈనె యే హెచ్చరిక కొతా సహించిగీండి తొముకు బతిమాలిగిల్లించి. సడకాక యెడకు బొడ్డూట కొరిలాని. ");
INSERT INTO rei_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","అం అన్నబయిల తిమోతికు విడుదల కలిగిసి బులి తెలిసిగీండి సెయ్యె బేగా అయిలాబెల్లె తా సంగరె అయికిరి తొముకు దిగుంచి. ");
INSERT INTO rei_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","తొమంపరె నాయకులైలాలింకల్లా పురువురొ మనమానెకు మో దండము కోండి. ఇటలీలింకంకా తొముకు దండమూనె కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","క్రుప తొం సొబ్బిలింకు తోడైకిరి రొమ్మాసి.");
INSERT INTO rei_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","జీవవాక్యము గురించి అగరె దీకిరి కిడ అచ్చివొ, అమె కెడ సునిలించొవొ అంకీనె పూరు కెడ దిగించొవొ కెడ పరిసీలించికిరి తెలిసిగించొవొ, అం అత్తోనె కెడకు సుంగీకిరి దిగిసేవొ సడ తొముకు తెలియపర్చిలించొ. ");
INSERT INTO rei_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","సే జీవం ప్రత్యక్సమైసి. బో పక్కరెదీకిరి ప్రత్యక్సమైలా సే నిత్యజీవము అమె దిక్కిరి సే జీవమును గురించి సాక్సం దీకుంటా, సడ తొముకు తెలియపర్చిలించొ. ");
INSERT INTO rei_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","అం దీకిరి కూడ తొముకు సహవాసం కలిగిలాపనికిరి అమె దిగిలాటకు సడ సున్లాటకు తొముకు తెలియపరిచిలీంచొ అమె సహవాసమీనె బో దీకిరి కూడ తా పోయీలా యేసుక్రీస్తు దీకిరి కూడ అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","అం సంతోసము పరిపూర్నమైనె అమె యే సంగతీనె రాసిలించొ. ");
INSERT INTO rei_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","అమె తావల్లరె సునికిరి తొముకు ప్రకటించిలా వర్తమానం కిడబుల్నే పురువు హల్లొయీకిరి అచ్చి తాసంగరె వొందారొ కే మాత్రం నీ. ");
INSERT INTO rei_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","తా దీకిరి కూడ సహవాసముగలిగిలింకె బులి కొయిగీకుంటా వొందార్రె సలిలాపనైనె అమె సొరొకొతాలగినె సత్యంకు అనుసరించికిరి జీవించిలానింతొ. ");
INSERT INTO rei_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","ఈనె సెయ్యె హల్లొరెరొల్లా ప్రకారము అమ్మంకా హల్లొరె సల్నే అమె అన్యోన్యసహవాసము గలిగిలాపనికిరి రొమ్మా. సెల్లె సెయ్యె పోయీలా యేసురొ రొగుతొ సొబ్బిపాపముదీకిరి అముకు పవిత్రులుగా కొరుసి. ");
INSERT INTO rei_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","అమె పాపం కొర్లాలింకె నీ బులి కొయిగిన్నే అముకు అమ్మాక మోసంకొరుగుంచొ ఇంకా అం బిత్తరె సత్యమురొన్నీ. ");
INSERT INTO rei_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","అం పాపోనె అమె ఒప్పిగిన్నె సెయ్యె నమ్మకమైలాట నీతిమంతుడు గనుక సెయ్యె అమె పాపోనెకు క్సమించికిరి పవిత్రులుగా కొరుసి. ");
INSERT INTO rei_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","అమె పాపము కొరిలానింతొ బులి కొయిగిన్నే తాకు సొరొకొతాలగిలాపన ఊంచొ. ఈనె తా వాక్యము అం సంగరె రొన్నీ. ");
INSERT INTO rei_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","మో సన్నిపిల్లానె, తొమె పాపము నాకొరుకుంటా యే సంగతీనె తొముకు రాసిలించి. కేసైనను పాపము కొర్నే నీతిమంతుడైలా యేసుక్రీస్తు బుల్లా సహాయకుడు అం తరుపురె కొతలగిలాట బో పక్కరె అముకు అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","సెయ్యాక అం పాపోనెకు పరిహారమైకిరి అచ్చి. అం పాపోనెకు మాత్రమాక నీ సర్వలోకముకు క్సమించికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","ఇంకా అమె తా ఆజ్ఞానెకు అమె పాటించినె యడ వల్లరె తాకు జనికిరి అచ్చొ బులి తెలిసిగుంచొ. ");
INSERT INTO rei_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","తాకు జనికిరి అచ్చొ బులి కొయిగీకుంటా తా ఆజ్ఞానెకు నాపాటించిలాట సొరొకొతాలగిలాట. తా బిత్తరె సత్యము నీ. ");
INSERT INTO rei_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","తా వాక్యము కేసె సునివొయొ తంకెబిత్తరె పురువొ ప్రేమ సొత్తాక పరిపూర్నమైవొ. ");
INSERT INTO rei_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","తా బిత్తరె అచ్చొబులికిరి కొయిగిల్లాట సెయ్యె క్యాకిరి సల్లీసో సాకిరాక సెయ్యె సలిగివ్వొలిసిలాటైకిరి అచ్చి. అమె తా బిత్తరె అచ్చొ బులి యడవల్లరె జనిలించొ. ");
INSERT INTO rei_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","ప్రియమైలాలింకే, అగరెదీకిరి తొముకు రొల్లా పూర్వపు ఆజ్ఞాక గాని నోఆజ్ఞకు మియి తొముకు రాసివురొనీ. ఏ పూర్వపు ఆజ్ఞ తొమె సునిలా వాక్యమాక. ");
INSERT INTO rei_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","ఈనె నోఆజ్ఞ తొముకు రాసిలించి. వొందారొ బాజెల్లీసి. సొత్తైలా హాల్లొ ఉంచినె ప్రకాసించిలీసి ఈనె సడ తాబిత్తరె తొంబిత్తరె సొత్తాక. ");
INSERT INTO rei_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","హల్లొరె అచ్చిబులి కొయిగీకుంటా, తా అన్నబయికు ద్వేసించిలాట ఉంచినెజాంక వొందారెరాక అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","తా అన్నబయికు ప్రేమించిలాట హల్లురె అచ్చి. తాబిత్తరె అబ్యంతరం కిచ్చినీ. ");
INSERT INTO rei_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","ఈనె తా అన్నబయికు ద్వేసించిలాట వొందార్రె రొయికిరి, వొందార్రె సల్లీసి. వొందారొ తా అంకీనుకు గుడ్డిలింకె పని కొరికిరి సెయ్యె కేటికి జెల్లీసివొ తాకు తెలిసినీ. ");
INSERT INTO rei_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","సన్ని పిల్లానే, క్రీస్తువల్లరె తొం పాపోనె క్సమించబొడిసి సడకు తొముకు రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","బోనె, తొమె అగుంతతీకిరి రొల్లాటకు జనికిరి అచ్చొ సడకు తొముకు రాసిలించి. కుర్రానె, తొమె దుస్టుడుకు జయించికిరి అచ్చొ సడకు తొముకు రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","సన్నిపిల్లానె, తొమె బోకు జనికిరి అచ్చొ. గనుక తొముకు రాసిలించి. బోనే, తొమె అడకు అగరె తల్లాంచల్లా జనికిరి అచ్చొ సడకు తొముకు రాసిలించి. కుర్రానే, తొమె బలమైలాలింకె, పురువురొ వాక్యం తొమంపరె టారికిరి‍ అచ్చి. తొమె దుస్టుడుకు జయించికిరి అచ్చొ సడకు తొముకు రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","ఏ లోకముకైనన్నా లోకంరె తల్లాంచకైననూ ప్రేమించితెనాండి. కేసైనెనూ లోకముకు ప్రేమించినె బోరొ ప్రేమ తాబిత్తరె రొన్నీ. ");
INSERT INTO rei_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","లోకమురె రొల్లాటల్లా, బుల్నే దేరొ ఆస అంకీనె ఆస జీవితమురె కలిగికిరితల్లాంచ వల్లరె గర్వించువురొ బో వల్లరె అయిలాట నీ. సడ లోకసంబందమైలాట. ");
INSERT INTO rei_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","లోకముకు సడరొ ఆస గతించిజివ్వొ గాని, పురువురొ చిత్తముకు జరిగించిలాట కెబ్బుకూ టారొసి. ");
INSERT INTO rei_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","సన్నిపిల్లానె, యెడ చివరి గడియ. క్రీస్తు విరోది ఆసిబులి సునిసొనీనా ఉంచినంకా బడేలింకె క్రీస్తు విరోదూనె బయలుదేరికిరి అచ్చె. ఎడ వల్లరె చివరి గడియ బులి తెలిసిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","తంకె అం బిత్తరెదీకిరి బయలుదేరికిరి జేసె గాని తంకె అం సంబందూనె నీ. తంకె అమె సంబందులైనె అం సంగరె కూడ టారికిరి రొయితె. ఈనె తంకల్లా అం సంబందీనెనీబులి తెలియపర్చబొడిలాపనికిరి తంకె బయలుదేరికి బాజీసె. ");
INSERT INTO rei_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","ఈనె తొమె క్రీస్తు వల్లరె పరిసుద్దాత్మసంగరె పూరిలాలింకె గనుక సడవల్లరె తొమల్లా సత్యముకు తెలిసిగిచ్చొ. ");
INSERT INTO rei_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","తొముకు సత్యము తెలిసినీబులి మీ రాసిలించినీ,గాని తొమె జనిలందరె కెడ సొరొకొత కెడ సత్యముకు సంబందించిలాంచవొ తెలిసిగినితె మీ రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","యేసు, క్రీస్తు నీబులి కొయిలాట తప్ప కేసె సొరొకొతాలగిలాట? బోకు పోకు నాఒప్పిగిల్లాటాక క్రీస్తు విరోది. ");
INSERT INTO rei_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","పోకు నా ఒప్పిగిల్లాట ప్రతిజొనె బోకు నాఒప్పిగిల్లాట. పోకు ఒప్పిగిల్లాటాక బోకు ఒప్పిగిల్లాట. ");
INSERT INTO rei_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","ఈనె తొమె అగరెదీకిరి కిర సునిసెవో సడ తొమ తొంబిత్తరె మనుసురె రొమ్మురోండి. తొమె అగరెదీకిరి సునిలాట తొం మనుసురె తన్నే, తొమెకూడా. ");
INSERT INTO rei_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","నిత్యజీవము దూంచి బులి కొయిలాటాక సెయ్యె అముకు దిల్లా వాగ్దానము. ");
INSERT INTO rei_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","తొముకు మోసపరిచిలాలింకె దరికిరి ఏ సంగతీనె తొముకు రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","ఈనె తావల్లరె తొమె పొందిలా అబిసేకం క్రీస్తు వలన తొమె పరిసుద్దత్మసంగరె పూరికిరి అచ్చొ. గనుక సడకు కేసే తొముకు బోదించితె అవసరంనీ. సెయ్యె దిల్లా ఆత్మ సత్యమాక గానీ సొరొకొతా నీ; సడ తొముకు బోదించిలా పనికిరి, క్రీస్తు బిత్తరె తొమె టారికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","ఈనె సన్నిపిల్లానె, సెయ్యె ప్రత్యక్సమైలాబెల్లె తా అయిలాబెల్లె అమె తా అగరె నాలజ్జొపొడికిరి దైర్యముగా తల్లాపనికిరి తొమె తా వల్లరె టారొండి. ");
INSERT INTO rei_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","క్రీస్తు నీతిమంతుడు బులి తొమె బుజ్జికిరి రొన్నే నీతికు జరిగించిలా ప్రతీజొనె పురువురొ పో బులి డక్కబొడుసొ. ");
INSERT INTO rei_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","అమె పురువురొ పిల్లానెబులి డక్కిలాపని బో అముకు కెత్తె ప్రేమ దిగదీసివొ దిగోండి. అమె పురువురొ పిల్లానాక. ఏ కారనము వల్లరె లోకము అముకు జన్నీ, కైంకిబుల్నే సడ తాకు జన్నీ. ");
INSERT INTO rei_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","ప్రియమైలాలింకె, ఉంచినె అమె పురువురొ పిల్లానెయీకిరి అచ్చొ. అమె యింకా కిర ఊంచొవొ సడ యింకా పొదెరెపొడిలానీ గాని, సెయ్యె ప్రత్యక్సమైలాబెల్లె సెయ్యెతల్లాపనికిరాక తాకు దిగుంచొ. సడకాక తాకు పోలికిరిఅచ్చొ బులి అమె తెలిసిగిమ్మొ. ");
INSERT INTO rei_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","తాబిత్తరె యే నిరీక్సన దీగిల్లా సొబ్బిలింకె సెయ్యె పవిత్రుడైకిరి తల్లాపనికిరి తాకు పవిత్రుడుగా కొరిగివ్వొ. ");
INSERT INTO rei_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","పాపము కొరిలా ప్రతీజొనె ఆజ్ఞకు సునిలీనింతె. ఆజ్ఞకు నాసునువురాక పాపము. ");
INSERT INTO rei_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","పాపోనెకు కడితాక సెయ్యె అయిసి బులి తొముకు తెలుసు. తాబిత్తరె పాపముకిచ్చీ నీ. ");
INSERT INTO rei_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","తాబిత్తరె తల్లాలింకె కేసైనెనూ పాపము కొరినీ. ఈనె పాపముకొరిలాటకేసైనెనూ తాకు దిగిలానీ తెలిసిగిల్లానీ. ");
INSERT INTO rei_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","మో సన్నిపిల్లానె, కేసైనన్నా తొముకు మోసము నాకొరుకుంటా దిగ్గునోండి. సెయ్యె నీతిమంతుడైకిరి తల్లాపనికిరి నీతికు జరిగించిలా ప్రతీజొనె నీతిమంతుడు. ");
INSERT INTO rei_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","అపవాది అగరెతీకిరి పాపము కొరిలీసి గనుక పాపము కొరిలాట అపవాది సంబంది. అపవాదిరొ పైటీనె నాసనం కొరితాక పురువురొ పో అయివురొ యీసి. ");
INSERT INTO rei_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","పురువు మూలముగా జొర్నైలా ప్రతిజోనెరె తా స్వబావం అచ్చి గనుక సడకు సెయ్యె పాపము కొరిని. సెయ్యె పురువు వల్లరె జొర్నైలాట గనుక పాపము కొరిని. ");
INSERT INTO rei_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","యెడవల్లరె పురువురొ పిల్లానెకేసెవొ, అపవాది పిల్లానెకేసెవొ పొదరెపొడ్లీసి. నీతికు జరిగించిలా ప్రతీజొనె, తా బయినెకు నాప్రేమించిలా ప్రతీజొనె పురువురొ పిల్లానె యీనింతె. ");
INSERT INTO rei_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","అమె జొనుకు జొనె ప్రేమించిగిమ్మంచి బుల్లాట అగరెదీకిరి తొమె సున్లా సందేసమాకనీనా. ");
INSERT INTO rei_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","అమె కయీను లింకె పనికిరి రొన్నాసి. సెయ్యె దుస్టుడిరొ సంబందయికిరి తా బయికు మొరదీసి. సెయ్యె తాకు కిరుకు మొరదీసి? తా పైటీనె చెడ్డాంచ, తా బయిరొ పైటీనె నీతియీలాంచ సడకాక నీనా? ");
INSERT INTO rei_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","అన్నబయినె అప్పబొయినీనె లోకము తొముకు ద్వేసించిలాబెల్లె ఆచర్యపొడితెనాండి. ");
INSERT INTO rei_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","అమె బయినుకు ప్రేమించిలించో సడకు మొర్నొదీకిరి జీవముకు దాటికిరి అచ్చొ బులి తెలుసు. ప్రేమనీలాట మొర్నొరె టారేకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","తా బయికు ద్వేసించిలాట నరహంతకుడు. కే నరహంతకుడిరె నిత్యజీవము రొన్నీబులి తొముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","క్రీస్తు అమె సొబ్బిలింకు కొరకు తా పొర్నొ దీసి గనుక ఎడవల్లరె ప్రేమ క్యాటవొ తెలిసికిరి అచ్చొ. అమెకూడ అన్నబయినె గురించి అమె పొర్నొకు దిల్లాపనికిరి తమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","యే లోకమురొ సంపదకలిగికిరి రొయికిరి, తా బయినుకు కిచ్చీ నీవురొ దిక్కిరి, తాఉంపరె కే మాత్రము కనికరము నాదిగిదిల్లాలింకె ఉంపరె పురువురొ ప్రేమ క్యాకిరి టారుసి? ");
INSERT INTO rei_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","సన్ని పిల్లానె, కొతానెదీకిరి జిబ్బొదీకిరి నీకుంట పైటినె సంగరె సత్యముకు ప్రేమించు. ");
INSERT INTO rei_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","యెడ వల్లరె అమె సత్యసంబందమైలాలింకెబులికిరి అముకు తెలుస్సు. తా అగరె అమె మనుసూనె ప్రసాంతముగా రొయిదీగీపారొ. ");
INSERT INTO rei_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","అం హ్రుదయం అమంపరె నిందమోపితన్నే పురువు అం హ్రుదయంకన్నా గొప్పీట తాకు సొబ్బీ తెలుసు. ");
INSERT INTO rei_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","ప్రియమైలా అన్నబయినె అం హ్రుదయం అమంపరె నింద నామోపినే పురువు అగరె దైర్యంగా రొయిపారొ. ");
INSERT INTO rei_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","ఈనె అమె తా ఆజ్ఞలకు ఒప్పిగీకిరి తాకు ఇస్టమైలాంచకు కొర్నే అమె కిర మగినన్నా సడ తావల్లరె అముకు మిలుసి. ");
INSERT INTO rei_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","తా ఆజ్ఞ కిరబుల్నే తా పోయీలా యేసుక్రీస్తు నాకు నమ్మిగిల్లాలింకు, సెయ్యె అముకుదిల్లా ఆజ్ఞ ప్రకారము జొనుకు జొనె ప్రేమించిగిమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","తా ఆజ్ఞానెకు ఒప్పిగిల్లాలింకె తా బిత్తరె టారికిరి తాసె. సెయ్యె తంక బిత్తరె టారికిరి తాసి; అం బిత్తరె అచ్చి బులి సెయ్యె అముకు అనుగ్రహించిలా ఆత్మవల్లరె తెలిసిగిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","ప్రియమైలలింకె, బడేలింకె సొరొప్రవక్తానె లోకముబిత్తరకు బయలుదేరికిరి జేసె సడకు ప్రతి ఆత్మకు నానమ్మికిరి, సే ఆత్మానె పురువుకు సంబందమైలాటవొ నీవొ పరిక్సించొండి. ");
INSERT INTO rei_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","యేసుక్రీస్తు దేయికిరి అయిసిబులి, కే ఆత్మ ఒప్పుగివ్వొ సడ పురువురొ సంబందమైలాట బులి తెలుసుగునుంచొ. ");
INSERT INTO rei_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","కాని కే ఆత్మ యేసుకు నాఒప్పిగివ్వొ సడ పురువురొ సంబందమైలాటనీ. ఎడవల్లరె పురువురొ ఆత్మకు తొమె తెలిసిగీపారొ. క్రీస్తు విరోది ఆత్మ అయిసిబులి తొమె సునిలా సంగతి యెడాక. ఎడకగరాక సడ లోకమురె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","మో పిల్లానె, తొమె పురువు సంబందూనె. తొంబిత్తరె రొల్లా ఆత్మ లోకమురె రొల్లట ఆత్మ కన్నా గొప్పీట గనుక తొమ సొరొప్రవక్తానె ఓడించికిరి జయించికిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","సొరొప్రవక్తానె లోక సంబందూనె సడకు లోకొ సంబందుయిలా పనికిరి కొతలగుసె, లోకము తంకె కొత సునుసి. ");
INSERT INTO rei_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","కాని అమె పురువు సంబందూనె; పురువుకు జనిలాట అం కొత సునుసి, పురువు సంబంది నీలాట అమె కొత సున్ని. ఎడకు అమె సత్య స్వరూపియైలా ఆత్మ కిరవొ, సొరొఆత్మ కిరవొ అమె తెలిసి గిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","అన్నబయినె, అమె జొనుకు జొనె ప్రేమకలిక్కిరి రొమ్మా. కిరబుల్నే ప్రేమ పురువు వల్లరె కలిగిలీసి. ప్రేమించిలా ప్రతిజొనె పురువు వల్లరె జొర్నైలాటైకిరి పురువుకు జనిసి. ");
INSERT INTO rei_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","పురువు ప్రేమాస్వరూపి, ప్రేమనీలాట పురువుకు జన్నీ. ");
INSERT INTO rei_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","అమె తాదీకిరి జీవించిలాపనికిరి, పురువు తా గుట్టాక తల్లా పోకు లోకముకు పొడదీసి. యెడవల్లరాక పురువురొ ప్రేమ అంబిత్తరె ప్రత్యక్సపర్చబొడిసి. ");
INSERT INTO rei_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","అమె పురువుకు ప్రేమించిలించొబులి నీ, సెయ్యాక అముకు ప్రేమించిలీసి, అమె పాపోనెకు క్సమించికిరి కడిపితె తా పోకు పొడదీసి. యెడబిత్తరె ప్రేమ అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","ప్రియమైలాలింకే, పురువు అముకు యాకిరి ప్రేమించినే అమె జొనుకు జొనె ప్రేమించిగిల్లా పనికిరి రొమ్మాసి. ");
INSERT INTO rei_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","కే మనమ పురువుకు కెబ్బుకు దిగిలానీ. అమె జొనుకు జొనె ప్రేమించిల్లాబెల్లె పురువు అమంపరె టారొసి. తా ప్రేమ అమంపరె సంపూర్నంగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","ఎడవల్లరె అమె తా బిత్తరె టారికిరి అచ్చొ బులి సెయ్యె అమె పక్కరె అచ్చిబులి జనికిరి అచ్చొ. క్యాకిరిబుల్నే సెయ్యె అముకు తా ఆత్మరె బాగం దీసి. ");
INSERT INTO rei_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","ఈనె బో తా పోకు లోకొ రక్సకుడు పని రొయితే పొడదివురొ అమె దిక్కిరి, సాక్సం దిల్లించొ. ");
INSERT INTO rei_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","యేసు పురువు పోబులి కేసె ఒప్పిగుసెవొ, తాబిత్తరె పురువు టారికిరి అచ్చి. సెయ్యె పురువురె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","అమంపరె పురువుకు రొల్లా ప్రేమకు అమె జనిలా పనికిరి సడ నమ్మిగీకిరి అచ్చొ. పురువు ప్రేమైకిరి అచ్చి. ప్రేమరె రొల్లాట పురువురె టారికిరి అచ్చి. పురువు తాబిత్తరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","తీర్పుదినొరె అముకు దైర్యము కలిగిలాపనికిరి ఎడవల్లరె ప్రేమ అంబిత్తరె పరిపూర్నము కొరికిరి అచ్చి. క్యాకిరిబుల్నే యేలోకమురె అమె తాకు పోలికిరి అచ్చొ ");
INSERT INTO rei_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","ప్రేమరె డొరొ రొన్నీ. సెత్తాకనీ, పరిపూర్నమైలా ప్రేమ డొరొకు గొడ్డిదూసి. డొరొ సిక్సకు సంబందమైలాట. డొరిలాట ప్రేమరె పరిపూర్నము కొరిలాట నీ. ");
INSERT INTO rei_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","సెయ్యె అగరె అముకు ప్రేమించిసి గనక అమె ప్రేమించిలించొ. ");
INSERT INTO rei_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","కేసైనెనూ మియ్యి పురువుకు ప్రేమించిలించిబులి కొయిగీకిరి, తా బయికు ద్వేసించిలాబెల్లె సెయ్యె సొరొకొతాలగిలాట ఊసి. సెయ్యె దిగిలా తా బయికు నాప్రేమించిలాట సెయ్యె నాదిగిలా పురువుకు ప్రేమించినారి. ");
INSERT INTO rei_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","పురువుకు ప్రేమించిలాట తా అన్నబయికు అప్పబొయినీనెకు కూడ ప్రేమించిమాసి బుల్లా ఆజ్ఞకు అమె తావల్లరె పొందిగీకిరి అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","యేసాక క్రీస్తుయీకిరి అచ్చిబులి నమ్మిలా ప్రతిజొనె పురువు మూలమురె జొర్నైకిరి అచ్చి. బోకు ప్రేమించిలా ప్రతిజొనె తావల్లరాక జొర్నైలాటకు ప్రేమించుసి. ");
INSERT INTO rei_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","అమె పురువుకు ప్రేమించికిరి తా ఆజ్ఞానెకు నెరవేర్చిలాలింకె అయించొ పురువురొ పిల్లానెకు ప్రేమించిలించొ బులి సడవల్లరాక తెలిసిగించొ. ");
INSERT INTO rei_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","అమె తా ఆజ్ఞానెకు పాటించువురాక పురువుకు ప్రేమించివురొ. తా ఆజ్ఞానె కస్టమైలాట నీ. ");
INSERT INTO rei_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","పురువు వల్లరె జొర్నైలా సొబ్బిలింకె లోకముకు జయించుసె. లోకముకు జయించిలా విజయమాక అం విస్వాసం. ");
INSERT INTO rei_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","యేసు పురువురొ పోబులి నమ్మిలాట తప్ప, లోకముకు జయించిలాట కేసె? ");
INSERT INTO rei_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","పని ద్వారా రొగొతొ ద్వారా అయిలాట యెయ్యాక, బుల్నే యేసుక్రీస్తుక. యెయ్యె తా బాప్టీసం పనిసంగరె మాత్రమాకనీ తా మొర్నొబుల్లా రొగొతొ సంగరె అయిసి. ఆత్మ సత్యము గనక సాక్సం దిల్లాట ఆత్మాక. ");
INSERT INTO rei_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","సాక్సం దిల్లాలింకె తిల్లింకె, ");
INSERT INTO rei_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","బుల్నే ఆత్మ, పని, రొగొతొ, ఏ తిల్లింకె గుట్టాక సాక్సం దిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","అమె మనమాన్రొ సాక్సీనె అంగీకరించిలించొనీనా! ఈనె పురువురొ సాక్సము బలమైలాట. సడవల్లరె పురువు తా పో గురించి సాక్సం దీల్లీసి. ");
INSERT INTO rei_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","సడవల్లరె పురువురొ పో ఉంపరె విస్వాముదీగిల్లాలింకె తంకల్లా యే సాక్సం కలిగికిరి అచ్చె. ఈనె పురువుకు నమ్మిలాలింకె సెయ్యె తా పో గురించి దిల్లా సాక్సము నమ్మిలానీ గాని సెయ్యె పురువుకు సొరొకొతా లగిలపనాక కొరిలాలింకె. ");
INSERT INTO rei_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","సే సాక్సము యెడాక పురువు అముకు నిత్య జీవముకు దీసి, యే జీవము తా పో పక్కరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","పురువు పో అంగీకరించిలలింకె నిత్యజీవము గలిగిలాలింకె పురువు పోకు నాఅంగీకరించిలాలింకె నిత్యజీవము నీలాలింకె. ");
INSERT INTO rei_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","పురువురొ పోరొ నారె విస్వాసము రొగ్గీకిరి తొమె నిత్యజీవము రొల్లాలింకె బులి తెలిసిగిల్లాపనికిరి మియ్యి యే సంగతీనె తొముకు రాసిలించి. ");
INSERT INTO rei_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","తా వల్లరె అముకు కలిగిలా దైర్యం కిరబుల్నే, తా ఇస్టప్రకారం అమె కెడ మగినెను సెయ్యె అం మనవి సునుసి. ");
INSERT INTO rei_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","అమె తాకు కిడమగినన్నా అం విన్నపం సునివొబులి అమె జనికిరి తన్నే తాకు మగిలాంచ మిలిసె బులి కూడ జనిమాసి. ");
INSERT INTO rei_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","తా బయి నామొరివొలిసిలా పాపము కొరిలాటకు సే మనమకు దరికిరి పురువు జీవం దూసి. మొర్నొకరమైలా పాపం అచ్చి సడకోసం సెయ్యె ప్రార్దించివాసి బులి మియ్యి కొయివురొనీ. ");
INSERT INTO rei_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","సొబ్బి దుర్నీతిరొ పాపము. ఈనె మొర్నొనీలా పాపము కూడా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","పురువురొ పిల్లానె బుల్లాలింకె పాపము కొరుకుంట తన్నింతె బులి అముకు తెలుసు. ఈనె పురువుమూలంగా జొర్నైలాటకు బద్రము కొరుసి. దుస్టుడు తంకు నస్టము కొర్నీ. ");
INSERT INTO rei_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","అమె పురువురొ సంబందూనె బులి అముకు తెలుసు, ఈనె లోకమల్లా దుస్టుడురొ ఆదీనంరె అచ్చి బులి అముకు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","అమె సత్యమైలా పురువుకు తెలిసిగిమ్మాసిబులి, పురువురొ పో అయికిరి అముకు బుద్ది దీసిబులి అముకు తెలుసు. అమె పురువురొ పో యీల యేసుక్రీస్తురె తల్లాలింకైకిరి సత్య వంతులుగా అచ్చొ. సెయ్యాక సత్యమైలా పురువు నిత్యజీవమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","మో పిల్లానె సొరొ పురువునుకు దూరుగా రోండి.");
INSERT INTO rei_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","బొట్ట యీలా మియి, పురువు ద్వారా బచ్చిగిల్లా మాకు తా పిల్లానుకు సుబం బులి కొయికిరి రాసిలించి. మియ్యాక, మియి మాత్రమాక నీ గని సత్యము జనిలా సొబ్బిలింకె, అమె, అం దీకిరి కెబ్బుకూ రొల్లాలింకె తొముకు ప్రేమించిలీసె. ");
INSERT INTO rei_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","కిరకుబుల్నే సత్యము అం దీకిరాక అచ్చి. సడ కెబ్బుకూ అం సంగరాక తాసి. ");
INSERT INTO rei_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","సొత్తైల ప్రేమానె అంబిత్తరె రొల్లాబెల్లె బో యీల పురువు పక్కరె దీకిరి, బోరొ పో యీలా యేసుక్రీస్తు పక్కరె దీకిరి క్రుప, కనికరము, సమాదానము అం సంగరె తాసి. ");
INSERT INTO rei_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","బో వల్లరె అమె ఆజ్ఞకు పొందిలా పనికిరి తో పిల్లానె కుండెలింకె సత్యముకు అనుసరించికిరి చలిగివురొ జనికిరి బడే సొరదపొడిలించి. ");
INSERT INTO rei_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","ఈనె మా, నో ఆజ్ఞ తొత్తె రాసిలాపనికిరి నీ గని, అగరెదీకిరి అముకు కలిగిలా ఆజ్ఞాక రాసికిరి, అమె జొనుకు జొనె ప్రేమించిమంచెబులి తొత్తె బతిమాలిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","అమె తా ఆజ్ఞానె ప్రకారంగా చలువురాక ప్రేమ; తొమె అగరెదీకిరి సునిల పనికిరి ప్రేమరె చలిమంచె బుల్లాటాక సే ఆజ్ఞ. ");
INSERT INTO rei_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","యేసుక్రీస్తు దేకు దరించిగినికిరి అయిసిబులి నాఒప్పిగిల్లా సత్రువూనె బడేలింకె లోకమురె బయలుదేరికిరి అచ్చె. సాకిరినీబులి కొయిలాలింకె క్రీస్తుకు విరోదులైకిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","అమె తొం మొజిరె పూర్తికొరిలా పైటీనె నాచెడిదీకుంటా, తొమె‍ పూర్తిపలము పొందిలాపనికిరి జాగర్తగా దిగ్గునోండి. ");
INSERT INTO rei_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","క్రీస్తు బోదరె నాటారేకిరి సడకు సడికిరి అగురుకు జేతల్లా ప్రతి మనమ, పురువుకు నాఒప్పిగిల్లాట. సే బోదరె టారేలాట బోకు, పోకు ఒప్పిగిల్లాట. ");
INSERT INTO rei_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","కేసైనెను ఏ బోదకు నాదన్నెకిరి తొం పక్కు అయిలబెల్లె తాకు తో గొరొబిత్తరె చేరిగినితెనాండి; ");
INSERT INTO rei_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","సుబం బులి తాసంగరె కొయిలాట తా దుస్టపైటినిరె బంటిగునుసి. ");
INSERT INTO rei_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","బడే సంగతీనె తొముకు రాసివురొ అచ్చి గని, సిరాసంగరె కాగితము సంగరె రాసితె మనస్సునీకిరి తొం సంతోసము పూర్తయిలాపనికిరి తొముకు మిసిగీకిరి ప్రత్యక్సంగా కొతలగితె ఆసగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","బచ్చిగిల్లా తొం, ప్రియమైలా తొం అప్పబొయినిరొ పిల్లానె తొముకు సుబానె కొయిలీసె.");
INSERT INTO rei_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","బొట్టయీలా మియి సత్యమువల్లరె ప్రేమించిలా ప్రియుడైలా గాయుకు సుబం బులి రాసిలాట కిరబుల్నే. ");
INSERT INTO rei_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","ప్రియుడా, తో ఆత్మ వర్దిల్లిలాపనికిరి తువ్వు సొబ్బి విసయాల్రె వర్దిల్లికిరి బొల్లె రొమ్మంచిబులి ప్రార్దంచిలించి. ");
INSERT INTO rei_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","తువ్వు సత్యముకు అనుసరించికిరి సలిగిల్లీసు బులి సడకోసం బయినె అయికిరి తో సత్యప్రవర్తన కోసం సాక్సం కొయిలాబెల్లె సునికిరి బొల్లె సంతోసించించి. ");
INSERT INTO rei_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","మో పిల్లానె సత్యముకు అనుసరించికిరి చలిగిల్లీసె బులి సునిలకన్నా మెత్తె ఎక్కువైలా సంతోసము నీ. ");
INSERT INTO rei_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","మో జట్టుకారీనె, తంకె పరదేసులైనన్నా బయినెపనికరి రొల్లాలింకు తువ్వు కొరిలాటల్లా విస్వాసికు తగిలాపనికిరి కెత్తొ నమ్మకముగా సాయం కొరిలీసు. ");
INSERT INTO rei_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","తంకె తో ప్రేమ కోసం సంగము అగరె సాక్సం కొయిసె. తంకె సాకిరాక పురువురె హెచ్చింపబొడిలాపనికిరి తంకు సాయం కొరు. ");
INSERT INTO rei_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","ఈనె తంకె క్రీస్తురొ సేవరె కొనసాగించితె బచ్చిగీకిరి అచ్చె. అవిస్వాసులైలాలింకు పక్కరె కేవిదమైలా సాయం ఆసించిలానింతె. ");
INSERT INTO rei_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","అమె సత్యము విసయంరె తంకె దీకిరి పాటు పాలిబాగస్తులైలాపనికిరి సాలింకు ఆతిద్యం దేండి. ");
INSERT INTO rei_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","మియి సంగముకు గుటె సంగతి రాసించి. ఈనె తంకె బిత్తరె దియొత్రెపే నాయకుడుగా తమ్మాసి బులి కొయిగీకిరి అముకు ఒప్పిగిల్లీని. ");
INSERT INTO rei_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","సెయ్యె అం కోసం సెడ్డకొతానె కొయికుంటా, సడ నాసలిలాపనికిరి, బయినుకు సెయ్యాక నాచేర్చిగీకిరి, తంకు చేర్చిగిల్ల మనస్సుగల్లలింకు కూడ ఆటంకం కొరికుంటా సంగముదీకిరి తంకు వెలివేసిపిలీసి సడకు మియి అయిలబెల్లె సెయ్యె కొరితల్లా పైటీనెకు గుర్తు కొరుగుంచి. ");
INSERT INTO rei_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","ప్రియమైలా స్నేహితుడూ, సెడ్డపైటీనె నీకిరి బొల్ట పైటినె అనుసరించికిరి సలండి. మేలు కొరిలాట పురువు సంబంది, కీడు కొరిలాట పురువుకు దిగిలాటని. ");
INSERT INTO rei_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","దేమేత్రియు సొబ్బిలింకె వల్లరె సత్యమువల్లరె బొల్ట సాక్సము పొందిలాట, అమె కూడ తాకు సాక్సం దిల్లీంచొ అం సాక్సం సత్యమైలాటబులి తువ్వు తెలుసు. ");
INSERT INTO rei_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","బడే సంగతీనె తొత్తె రాసివురొ అచ్చి ఈనె సిరా సంగరె, కలము సంగరె తొత్తె రాసివురొ మెత్తె యిస్టము నీ. ");
INSERT INTO rei_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","బేగా తొత్తె దిగితందుకు ఎదురుదిగిలించి సెల్లె మూకు మూ కొతలగ్గిమ్మండి. ");
INSERT INTO rei_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","తొత్తె సమాదానము కలిగిమాసి, అం జట్టుకారీనె తొత్తె దండమూనె కొయిలీసె. తో పక్కరె రొల్లా జట్టుకారీనెకు నా, నారె వరసగా వందనములు కో.");
INSERT INTO rei_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","యేసుక్రీస్తు దాసుడు, యాకోబు బయిలా యూదా, బోయిలా పురువురె ప్రేమించికిరి, యేసుక్రీస్తురె బద్రముకొరికిరి డక్కిలాలింకు సుబం బులి కొయికిరి రాసివురొ. ");
INSERT INTO rei_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","తొముకు కనికరము సమాదానం ప్రేమ కలిగిమాసి. ");
INSERT INTO rei_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","మో ప్రియమైలా స్నేహితులూనె, అం సొబ్బిలింకు కలిగిలా రక్సనకోసం తొముకు రాసిమాసి బులి, ఆసక్తి సంగరె ప్రయత్నించితల్లాబెల్లె తా ప్రజానెకు గుటెబెల్లాక అప్పగించిలా బోద గురించి తొమె పోరాడిమాసిబులి ప్రోత్సాహపర్చికుంటా తొముకు రాసివురొయీసి. ");
INSERT INTO rei_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","క్యాకిరిబుల్నే కుండిలింకె రహస్యముగా చొరబొడికిరి అచ్చె. తంకె బక్తిహీనులైకిరి అం పురువు క్రుపకు కామాతురత్వముకు దుర్వినియోగ పరిచ్చికుంటా, అమె అద్వితీయనాదుడు ప్రబువైలా యేసు క్రీస్తుకు విసర్జించిలీసె; ఏ తీర్పుపొందితె తంకె యెడకు అగరె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","ఏ సంగతులల్లా తొమె అగరాక తెలిసికిరి రొన్నన్నా, మియి తొముకు జ్ఞాపకం కొరిలించి కిరబుల్నే, ప్రబువు ఐగుప్తుదీకిరి మనమానుకు రక్సించినెను, తంకె బిత్తరె నానమ్మిలాలింకు తర్వాతరె నాసనము కొరిసి. ");
INSERT INTO rei_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","ఈనె తంకె ప్రదానత్వము నాటారదీకిరి, తంకె రొల్లచోటు సడిదిల్లా దేవదూతానెకు, మహాదినోరె, జరిగితల్లా తీర్పుజాంక కటికవొందార్రె కేసె నా సొడిల బందకాలు సంగరె సెయ్యె బందించికిరి బద్రముకొరిసి బులి గుర్తుదీగీండి. ");
INSERT INTO rei_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","సాకిరి సొదొమ గొమొర్రానుకు సడ చుట్టూతల్లా గానుకు యంకె పనికిరి దర్నిపైటికొరుకుంటా, పొదరలింకె పనికిరి దేఆసానెకు తొలిగిజెల్లలింకెగా తల్లావల్లరె, కెబ్బుకూ పుడ్డితల్లా నియ్యరె అనుబవించితల్లాట తొముకల్లా గుటె హెచ్చరికపనికిరి గుర్తు రొయిదిగీండి. ");
INSERT INTO rei_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","సాకిరాక యంకె కూడా సొప్నొనె పైకుంట, దేకు అపవిత్రం కొరిగీకుంటా, పురువురొ అదికారముకు నిరాకరించికుంటా, ఉంపరెతల్లా మహిమగల్లాలింకు దూసించికుంటా అచ్చొ. ");
INSERT INTO rei_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","ఈనె ప్రదాన దూత యీల మికాయేలు అపవాది దీకిరి వాదించికుంటా మోసేరొ దే గురించి తర్కించిలాబెల్లె, దూసించికిరి తీర్పు తీర్చితె నాతెగించికిరి ప్రబువు తొత్తె గద్దించిమాసి బులిసి. ");
INSERT INTO rei_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","అంకె ఈనె తంకె నా గ్రహించినర్లా సంగతీనె గురించి దూసించిలాలింకె వివేక సూన్యములింకె మ్రుగముపనికిరి కేటకు స్వాబావికముగా జనినె సడ వల్లరె తంకు తంకాక నాసనము కొరిగిల్లీసె. ");
INSERT INTO rei_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","అయ్యో తంకు స్రమ తంకె కయీను సలిలా బట్టొరె సలిసె, బహుమానము పొందిమాసిబులి బిలాము సలిలా తప్పుబట్టొరె ఆసక్తిగా దొమిడిసె, కోరహు కొర్లాపనికిరి తిరస్కారము కొరికిరి నసించిజీసె. ");
INSERT INTO rei_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","యంకె లజ్జొనీకుంటా తొం సంగరె కద్ది కొరుకుంటా, తంకె తంకాక బొల్లకిరి పోసించిగికుంటా, తొం ప్రేమకద్దినిరె సొరొ పొత్రొనె పనికిరి అచ్చె. యంకె బాసంగరె యాడుకు సాడుకు మరిగిబాజిల్లా నిర్జల మెగొనె పనికిరి, కాయానె జొడిలా పొగలానె నీకిరి, దీటోసారి మొరిజీకిరి సెరోనె సంగరె జింకిపీలా గొచ్చొనెపనికిరి. ");
INSERT INTO rei_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","తంకరొ అవమానము సోంద్రొర్రొ నురగ ఒక్కిల్లా ప్రచండమిల్లా ఆలలుపనికిరి, బట్టొ తప్పిజేకిరి బుల్లిలా చుక్కలుపనికిరి అచ్చొ. తంకె కోసం గాడాందకారం కెబ్బుకూ బద్రము కొరికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","ఆదాము మొదలుదీకిరి సత్రొయీటయిలా హనోకుకూడా యంకె కోసం ప్రవచించికిరి యాకిరి కొయిసి ఇదిగొ సొబ్బిలింకు తీర్పు తీర్చితె, ");
INSERT INTO rei_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","తంకె బిత్తరె బక్తిహీనమైలా పైటినె సొబ్బిటికోసం, బక్తిహీనూనె యీల పాపోనె తాకు విరోదంగా కొయిల కటినమైలా కొతానెల్ల తంకు ఒప్పించితె, ప్రబువు తా వొజారొజారు పరిసుద్ద దూతానె సంగరె అయిసి. ");
INSERT INTO rei_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","తంకె తంకరొ దురాసలవల్లరె సలుకుంటా, లవొ గురించి మనమానుకు పొగిడికుంటా, సొనిగిలాలింకె తంకె స్తితికు నిందించిలాలింకె పనికిరి అచ్చె తంకె తుండొ బడాయి కొతానె పలుకుసి. ");
INSERT INTO rei_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","ఈనె మో ప్రియమైలా స్నేహితులూనె, అమె ప్రబువైలా యేసుక్రీస్తు అపొస్తులు పూర్వంరె తొం సంగరె కొయిలా కొతానె జ్ఞాపకము కొరిగీండి. ");
INSERT INTO rei_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","అంత్యకలొరె తంకె బక్తిహీనమైలా దురాసలు దీకిరి సలిగిల్లాలింకె, అవమాన పర్చిలా సొబ్బిలింకె సెట్టె దిగదూసె. ");
INSERT INTO rei_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","సాలింకె‍ ప్రక్రుతి సంబందమైలా పురువు ఆత్మనీకుంటా ప్రజానెకు యిడమర్లీసె. ");
INSERT INTO rei_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","ఈనె మో ప్రియమైలా స్నేహితులూనె, తొమె తొమ్మాక విస్వసించిలా అతిపరిసుద్దమైలాటంపరె తొముకు తొమె బందిగికుంటా, ");
INSERT INTO rei_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","ఇంకా తొముకు తొమ్మాక పురువురొ ప్రేమ సంగరె ప్రార్దనకొరికుంటా, తా నిత్యజీవార్దమైలా అం ప్రబువుయిలా యేసుక్రీస్తు కనికరము కోసం కనిపెట్టిగికుంటా, తా ప్రేమసంగరె జొక్కుంటా ఎదురు దిగోండి. ");
INSERT INTO rei_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","అనుమానం పొడిలాలింకంపరె కనికరము దిగదేండి. ");
INSERT INTO rei_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","నియ్యబిత్తరెతీకిరి జింకిలాపనికిరి కుండిలింకు రక్సించొండి, దేసంబందమైలా అపవిత్ర ప్రవర్తనకు కే మాత్రము నాఒప్పిగీకుంటా సడకు అసహ్యించిగీకుంటా డొరొసంగరె కుండిలింకు కరునించొండి. ");
INSERT INTO rei_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","నా తడబొడికుంటా తొముకు కాపాడితె, తా మహిమ అగరె ఆనందంసంగరె తొముకు దోసం నీకుంటా టారదీతె, ");
INSERT INTO rei_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","సక్తిగల్లా అం రక్సకుడైలా అద్వితీయ పురువుకు, అం ప్రబువువైలా యేసుక్రీస్తు వల్లరె, మహిమ మాహాత్మ్యముకు ఆదిపత్యముకు అదికారముకు యుగములకు పూర్వముకు ఉంచినె సర్వయుగములకు కలిగిమాసి.");
INSERT INTO rei_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","యే పుస్తకమురొ సంగతీనె యేసుక్రీస్తు తా దాసునుకు దిగిపించితె పురువు తాకు అనుగ్రహించిలా ప్రత్యక్సత. సంగతీనె అగురుకు సంబవించుసె బులి పురువు తా దూత సంగరె వర్తమానం పొడిదీకిరి తా దాసుడైలా యోహానుకు తెలియపర్చిసి. ");
INSERT INTO rei_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","యోహాను పురువురొ వాక్కు గురించి, యేసుక్రీస్తురొ సాక్సము గురించి సెయ్యె దిగిలత్తెమట్టుకు సాక్సం కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","కైంకిబుల్నె సమయము సమిపించిలిసి గనుక యే ప్రవచన వాక్కులుకు చదివిలాట, సడానె సునికిరి సడకు లోబొడికిరి సలిగిల్లాలింకె దన్యూనె. ");
INSERT INTO rei_vpl VALUES ("RV1_4","096_1_4","REV","1","4","4","ఆసియరె తల్లా సత్తర సంగలుకు యోహాను సుబాలు కొయికిరి రాసివురొ కిరబుల్నే, జరిగితల్లా కలొ జరిగిజిల్లా కలొ అయితల్లా కలొరె తల్లా తా తీకిరి, తా సింహాసనం ఎదురుగా తల్లా సత్తర ఆత్మల తీకిరి, ");
INSERT INTO rei_vpl VALUES ("RV1_5","096_1_5","REV","1","5","5","నమ్మకమైలా సాక్సిగా, మొర్జిల్లలింకె తీకిరి సే అగరె తీకిరి ఉటిలాట, రొజానుకు అదిపతి యీలా యేసుక్రీస్తు తీకిరి క్రుప, సమాదానాలు తొముకు కలిగిమాసి. అముకు ప్రేమించికిరి తా రొగొతొ వల్లరె అం పాపోనె తీకిరి అముకు చొడిపించితె. ");
INSERT INTO rei_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","అముకు ప్రేమించికుంట తా రొగొతొవలరె అం పాపము దీకిరి మహిమ ప్రబావములు యుగయుగాలు కలిగిమాసి ఆమేను. సే అముకు తా బొ యీల పురువుకు గుటె రాజ్యముపనికిరి యాజకూనెపనికిరి కొరిసి. ");
INSERT INTO rei_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","ఇత్తొ సెయ్యె మెగోనంపరె అయిలీసి. ప్రతి అంకి తాకు దిగుసి. తాకు బుసిలాలింకె కూడా దిగుసె. బూమంపరె మనమానల్లా తాకు దిక్కిరి గుండెలు బాదుగుచ్చె. యడ జరిగివాసి. ");
INSERT INTO rei_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","అగరె మియ్యాక చివర్రె మియ్యాక, జరిగితల్లా జరిగిజిల్లా అయితల్లా కలొరె తల్లాట మియ్యాక బులి సర్వసక్తుడైలా ప్రబువు కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","యోహాను బుల్లా మియ్యి తొం బయి. యేసువల్లరె కలిగిలా స్రమరె రాజ్యంరె సహనంరె పాలిగిల్లాట మియ్యి పురువురొ వాక్కు గురించి యేసురొ సాక్సం గురించి పత్మాసు దీవిరె పరవాసైకిరచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","పురువురొ దినొరె మియ్యి పురువు ఆత్మసంగరె తన్నుగా బూర సబ్దంపనాట మో పొచ్చాడె బొట్టగొలాసంగరె కొతలగివురొ సుందీసి. ");
INSERT INTO rei_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","తు దిగిలాట పుస్తకమురె రాసికిరి, ఎపెసు, స్ముర్న, పెర్గము, తుయతైర, సార్దీసు, పిలదెల్పియ, లవొదికయ బుల్లా సత్తర సంగలుకు పొడిదే. ");
INSERT INTO rei_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","సడ సున్లాబెల్లె మో సంగరె కొతాలగితల్లా గొలా కిడవొబులి బుల్లిలాబెల్లుకు సున్నసంగరె కొర్ల సత్తర సున్న బొత్తి స్తంబలు దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","సే సత్ర సున్న బొత్తి స్తంబలు మొజిరె మనమరొ పో పనాటకు జొనుకు దిగించి. సెయ్యె పాదాలంపరెకు పొడిలా కొన్న పిందిగీకిరి బుక్కొఉంపరె సున్నకొన్న పట్టి బందిగీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","తా ముండొ ముండ్రొబల్లొ దొగలా ఉన్నిపనికిరి మంచు పనికిరి దొగలైకిరి అచ్చి. తా అంకీనె నియ్య జొలానె పనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","తా పాదాలు కొలిమిరె పుడ్డికిరి మెరిస్తల్లా కంచుపనికిరి అచ్చె. తా సొరము విస్తార జలప్రవాహము ద్వని పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","సెయ్యె తా కైలత్తరె సత్తర నక్సిత్రమునెకు దరిగీకిరి అచ్చి. తా తుండొతీకిరి దీట అంచునె గల పదునైలా గుటెకడ్గం పొదరుకైలీసి. తా మూ తేజస్సు సంగరె ప్రకాసించితల్లా సూరిడు పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","మీ తాకు దిగిలాసంగరాక మొర్లాటపనికిరి తా పాదానె పక్కరె పొడిజేంచి. సెయ్యె తా కైలత్తొకు మో ఉంపరె లొక్కిరి మెత్తె యాకిరి కొయిసి “డొరితెనా! మీ అగరోట, ఆకరువీట.” ");
INSERT INTO rei_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","గాని వుంచినె జీతల్లాట మియ్యాక! మొరిజీంచి గాని ఇత్తొ యుగయుగాలుకూ జీకుంటా అచ్చి. ఇంకా మొర్నొ, పాతాలమురె తాలం అదికారం మోపక్కరాక అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","ఈనె తూ దిగిలాటల్ల, తల్లటల్ల, అడతర్వాతరె ఈవలిసిలా సంగతీనెకు రాసు. ");
INSERT INTO rei_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","తూ మోకైలత్తరె దిగిలా సత్ర నక్సిత్రాలు, సె సత్ర సున్న బొత్తిస్తంబాలునె కిరబుల్నే, సె సత్ర నక్సిత్రాలు సత్ర సంగాలుకు దూతానె. తూ దిగిలా సె సత్ర బొత్తిస్తంబాలునె కిరబుల్నే సతర సంగాలునె. ");
INSERT INTO rei_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","ఎపెసురె తల్లా సంగం దూతకు యాకిరి రాసు, సత్తర నక్సిత్రాలు తా కైలత్తరె దరిగీకిరి సత్తర బొత్తిస్తంబానె మొజిరె బుల్లితల్లాట కొయితల్లా సంగతీనె కిరబుల్నే, ");
INSERT INTO rei_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","తో పైటీనె తో కొస్టొనె తో ఓర్పు మెత్తె అరక, తూ దుస్టులుకు సహించినారు బులి, అపోస్తులు నీకిరాక తంకె అపోస్తులు బులికిరి కొయిగీకుంట మాయ కొరితల్లాలింకు పసిబందుసుబులి మెత్తెరక. ");
INSERT INTO rei_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","తూ ఓర్పు సంగరె మో నా కోసం బారం బరించుకుంటా అలిసిజిల్లాను బులి మెత్తెరక. ");
INSERT INTO rei_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","ఈనెను అగరె తొత్తె తల్లా ప్రేమ తూ సడదీసుబులి తో ఉంపరె మెత్తె గుటె అబ్యంతరం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","సడుకాక తూ కే పరిస్తితిరె పొడిజేసివొ సడకు జ్ఞాపకం కొరిగీకిరి మనుసు మార్చిగీకిరి సె అగరె పైటీనె కొరు. సాకిరి తూ మనుసు మార్చిగిన్నే సాకిరి; నీనె మీ తో పక్కు అయికిరి తో బొత్తిస్తంబముకు సడపక్కరతీకిరి కడుపూంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","ఈనె తోబిత్తరె గుటె అచ్చి. సడ కిరబుల్నే, నీకొలాయితునె బుల్లాలింకెరొ పైటీనుకు తూ అసాయ పొడ్లీసు. సాకిరాక మియ్యంకా అసాయించిగిల్లించి. ");
INSERT INTO rei_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","కన్నోనె రొల్లాట ఆత్మ సంగలు సంగరె కొయిలా కొత సునుమాసి. జయించిలాటకు పురువు పరదేసిరె తల్లా జీవగొచ్చొరొ పొగలానుకు కయిపించుంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","స్ముర్నరె తల్లా సంగమురొ దూతకు యాకిరి రాసు. అగరోట ఆకరీట, మొర్నొతీకిరి ఇంకా జీకిరితల్లాట కొయితల్లా సంగతీనె కిరబుల్నే, ");
INSERT INTO rei_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","తూ పొడితల్లా స్రమకు బీదరికముకు మీ జని. ఈనెను తూ పలియతల్లాటాక. తంకె యూదునె నీనన్నా యూదునె బులికిరి కొయిగిల్లాలింకు యే సాతాను సంబందకులుకు తొత్తె కలిగితల్లా దూసన మెత్తె తెలుసు. ");
INSERT INTO rei_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","తొముకు అయితల్లా కొస్టోనె గురించి డొరిజీతెనాండి. సునొండి, తొముకు పరీక్సించితె సాతాను తొంబిత్తరె కుండెలింకు చెరరె పొగిపించుసి. దొస్టదినొ స్రమ కలుగుసి. ఈనన్నా మొర్నొదాకా నమ్మకంగా తా. మీ తొత్తె జీవకిరీటం దూంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","సంగలు సంగరె ఆత్మ కొయితల్లా కొతా కన్నోనె తల్లాట సునుమాసి. జయించిలాతాకు దీటొ మొర్నొవల్లరె కెటువంటి బాద తన్నీ. ");
INSERT INTO rei_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","పెర్గమురె రొల్లా సంగమురొ దూతకు యాకిరి రాసు. పదునైల దీటాంచురొ కత్తి తల్లాట కొయితల్లా సంగతీనె కిరబుల్నే, ");
INSERT INTO rei_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","సాతాను సింహాసనం ఉంపరె తల్లా చోటునురె తూ కాపురం తల్లీసుబులి మీ జని. ఈనె సాతాను కాపురం తల్లా సె చోటునురె, మో ఉంపరె విస్వాసిగా తైకిరి మో కోసం సాక్సియీల అంతిపయ బుల్లాటతా. ");
INSERT INTO rei_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","ఈనన్నా మెత్తె నానచ్చిలా పైటీనె తూ కొరిలీసు. సడానె కిరబుల్నే విగ్రహాలునుకు బలి దిల్లటకు కైలపనికిరి, దర్నిపైటికొరితె, తంకు బట్టొమల్లించితందుకు బాలాకు సుక్కిలా బిలామురొ బోద సున్లాలింకె తొం మొజిరె అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","సాకిరాక నీకొలాయితునె బుల్లా మనమానురో కొతానె సున్లాలింకె తొంబిత్తరె అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","ఈనె మారుమనుస్సు పొందొండి; నొయినె మీ తొంపక్కు బేగా అయికిరి మో తుండొదీకిరి అయిల కడ్గముసంగరె అంకె సంగరె యుద్దముకొరిమి. ");
INSERT INTO rei_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","సంగముసంగరె ఆత్మ కొయిల కొత కన్నొతల్లాట సునుసి గాక. జయించిలాటకు మరుగైకిరి తల్లా మన్నాకు కైపించుసి. యింక తాకు దొగల పొతొరొ దూంచి; సె పొతొరొఉంపరె చెక్కికిరితల్ల గుటె నోట నా తాసి; పొందిలతాకు తప్ప యింక సడ కాకు తెలిసిని. ");
INSERT INTO rei_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","తుయతైరరె తల్లా సంగంరొ దూతకు యాకిరి రాసు అగ్నిజొలపని అంకీనె అపరంజికు పోలికిరి తల్లా పాదమూనె గలిగిలా పురువురొ పో కొయిల సంగతీనె కిరబుల్నె, ");
INSERT INTO rei_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","తో పైటినె, తో ప్రేమకు, తో విస్వాసముకు, తో పరిచర్యికు, తో సహనముకు మెత్తెఅరక; తో అగరె పైటినె కన్నా తో పొచ్చాడె పైటినె యింక బడెంచ యీసెబులి తెలుసు. ");
INSERT INTO rei_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","ఈనెను తో ఉంపరె తప్పు గుటె మీ మోపివాసెబులి అచ్చి; కిరబుల్నె, సే ప్రవక్త్రిబులి కొయిగిల్లాట యెజెబేలుకు బుల్ల తిల్డ్రమొట్టకు తూ రొయిదిల్లీసు, దర్నిపైటి కొరితందుకు, విగ్రహాలకు అర్పించిలాంచ కయివురొ సుక్కిదీకుంట తంకు మోసం కొరుకుంట అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","మారుమనుసు పొందుబులి మీ తాకు సమయముదీంచిగాని సడ తా దర్నిపైటికి సడిదీకిరి మారుమనుసు పొందిగిన్ని. ");
INSERT INTO rei_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","ఇత్తొ మీ తాకు మొంచదరిపించికిరి సడ సంగరె నీ బులి దర్నిపైటి కొర్లలింకె తా పైటినెవిసయమురె మారుమనుసు కడిగిన్నె నొయినె తంకు కెత్తొ స్రమానె కొరుంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","సే మొట్టరొ పిల్లనాకు కచ్చితముగా పొర్నొకడిమి. సడవల్లరె అంతరింద్రియములుకు మనుసునుకు పరిక్సించిలట మీయాకా బులి సంగమునె సొబ్బి తెలిసిగినివొ. యింక తొంబిత్తిరె సొబ్బిలింకు తా, తా పైటినెవల్లరె ప్రతిపలము దూంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","ఈనె తుయతైరరె ఆకరిలింకెయీల తొమెసంగరె, ఈనెమాకు యె బోదకు నాఅంగీకరించికిరి సాతాను గుటె గూడమైల సంగతీనుకు తెలిసినీబులి కొయిగిత్తల్ల సొబ్బిలింకు సంగరె మీ కొయిలాట కిరబుల్నె తొమంపరె యింక కే బారం నొగినీ. ");
INSERT INTO rei_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","మీ అయిలజాంక తొముకు కలిగికిరితల్లాట గట్టిగా దరిగినోండి. ");
INSERT INTO rei_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","మీ మో బోవల్లరె అదికారం పొందిలపనికిరి జయించుకుంట, అంతముదాకా మో పైటినె జాగర్తాగ కొరిలాటకు మనమానె ఉంపరె అదికారం దూంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","సె ఇనుముదండము సంగరె తంకు ఏలుసి; తంకె కుమ్మరతారొ పాత్రనెపనికిరి బంగిపేవురొవూసి; ");
INSERT INTO rei_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","ఈనె మి మో బోవలరె పొందిగిల్లాట మి తాకు వేకువ చుక్కకు దూంచి. ");
INSERT INTO rei_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","సంగమునె సంగరె ఆత్మ కొయిల కొతకిరబుల్నె కన్నొ తల్లాట సునుసి. ");
INSERT INTO rei_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","సార్దీసురె తల్లా సంగము దూతకు యాకిరి రాసు సత్ర నక్సత్రమునెకు పురువురొ సత్ర ఆత్మానెకు గల్లాట కొయిల సంగతీనె కిరబుల్నె తో పైటినె మెత్తె అరక. కిరబుల్నె, జీవించిలు బులి నాక అచ్చిగాని తూ మోరిజెల్లటాక. ");
INSERT INTO rei_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","తో పైటినె మో పురువు పారె సంపూర్నమీలటపనికిరి మెత్తె దిగిదీవినీ ఈనె జాగర్త పొడికిరి, మోరిజేతెతల్లటకు కన్నా తక్కిలాటల్లాకు బలపరుచు. ");
INSERT INTO rei_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","తూక్యాకిరి ఉపదేసం పొందిసివొ క్యాకిరి సునిసివొ జ్ఞాపకం కొరిగినికిరి సడకు పాటించుకుంట మారుమనుస్సు పొందు. తూ జాగర్తగా తైకిరి తన్నె మీ సొరొపనికిరి ఆంచి; కే గడియకు తో ఉంపురుకు ఆంచొవొ తొత్తె అరకనీకుంట తాసి. ");
INSERT INTO rei_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","ఈనె తంక కొన్నానుకు అపవిత్రం నాపరుచుకుంట కుండెలింకె సార్దీసురె తోపారె అచ్చె. తంకె అర్హులు గనుక దొగలాట కొన్నానె పిందిగినికిరి మో సంగరెకూడ సంచరించుసె. ");
INSERT INTO rei_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","జయించిలాట సాకరాక దొగల కొన్నానె పిందిగినికిరి; జీవ గ్రందంరె తీకిరి తా నా కెత్తెమాత్రం పుంచిపేని, మో బో పారె కూడ తా దూతనె పారె కూడ తా నా మీ ఒప్పుగినిమి. ");
INSERT INTO rei_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","సంగముసంగరె ఆత్మ కొయిల కొత కన్నొనెతల్లాట సునుసి. ");
INSERT INTO rei_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","పిలదెల్పియరె తల్లా సంగము దూతకు యాకిరి రాసు దావీదురా తాలము తల్లటకు, కేసెకూడ నా పొక్కుండ కడ్లాటకు, కేసెకూడను నాకడుకుంట పొగిలితాకు సత్య స్వరూపియీల పరిసుద్దుడు కొయిలా సంగతీనె కిరబుల్నె. ");
INSERT INTO rei_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","తో పైటినె మెత్తె తెలుసు; తొత్తె తల్లా సక్తి కుండెయీకిరి తన్నెను; తూ మో వాక్యముకు తెలిసిగీకిరి మో నారె ఎరకనీ బులికిరి; ఇత్తొ తలుపు తో అగరె కడికిరి అచ్చి; సడకు కేసెనేను తిరస్కరించిలానింతె. ");
INSERT INTO rei_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","యూదునె నొయిలలింకె తంకె యూదునెబులి సొరొకొత లగిల సాతాను సామజమురె తల్లలింకు దన్నెపించుసి; తంకె అయికిరి తో పాదామూనె ఉంపరె పొడికిరి నమస్కారము కొరికిరి, ఇత్తొ, మీ తొత్తె ప్రేమించిలించిబులి తెలిసిలాపనికిరి కొరుంచి. ");
INSERT INTO rei_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","తూ మో ఓర్పు విసయమురె తెలుసుగినిసు గనుక బూమి ఉంపరె జీవించిలాలింకు సోదించితె లొకొఉంపురుకు అయిల సోదన కలొరె మీకూడ తొత్తె కాపాడుంచి. ");
INSERT INTO rei_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","మీ బేగా అయిలించి; కేసెనెను తు గెలిసిగిల్లా బహుమానం జాగర్తగా నొగ్గును. ");
INSERT INTO rei_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","గెలిసిలతాకు మో పురువురొ మందిరంరె గుటె స్తంబముపనికిరి కొరుంచి; తాండె బిత్తరె తీకిరి సే యింక కెబ్బుకు పొదురుకు జెన్ని. యింక మో పురువురొ నా, పరలోకమురె మో పురువు తీకిరి ఒల్లికిరి అయితల్లాట నాటయీల యెరూసలేముకు మో పురువురొ పట్టనపు నాకు, మో నాట నాకు తాఉంపరె రాసుంచి. ");
INSERT INTO rei_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","సంగముసంగరె ఆత్మ కొయిల కొత కన్నొతల్లాట సునివొగాక. ");
INSERT INTO rei_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","లవొదికయరె తల్లా సంగము దూతకు యాకిరి రాసు ఆమేను బుల్లతాకు నమ్మకమైలా సత్య సాక్సియీల పురువురొ ద్రుస్టికి అగుంత యీల తాకు కొయిల సంగీతీనెకిరబుల్నె. ");
INSERT INTO rei_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","తో పైటినె మెత్తెఅరక, తూ కకొరొ యీకిరియినెను తత్తికిరి యినెను నీ తు, మొజిరె రకముగా అచ్చు, తూ కకొరొ యీకిరియినెను తత్తికిరి యినెను తన్నె మేలు. ");
INSERT INTO rei_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","తూ తత్తికిరి యీనెనెను కకొరొ యికిరి యినెను నాతైకుంట, కే పొక్క నా పైటికైలతాపనికిరి అచ్చు యీనె మీ తొత్తె మో తుండొతీకిరి సొప్పొ పొగిమి బులి కొయిగిల్లీంచి. ");
INSERT INTO rei_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","తూ దౌర్బాగ్యుడవుకు దిక్కుమాలిట బులి గుడ్డితాబులి కొన్నానె నొయికుంట అచ్చిబులి నా తెలిసికిరి మీ పలియతాబులి, పలియ సంపదించిగించి బులి, మెత్తెకిచ్చి కొదువనీబులి కొయిగిల్లీసు. ");
INSERT INTO rei_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","తూ పలియగాలత యీతె జొలరె పుటముపొగిలా సున్నాకు, తో అవమాన మీల దేకు లజ్జొ నాదీదిల్లపనికిరి పిందిగినితుకు దొగలాట కొన్నానెకు, తొత్తె ద్రుస్టికలిగినిపనికిరి తో అంకీనెకు కాటుకనె మోపారె గినుబులి తొత్తె బుద్దికొయిలించి. ");
INSERT INTO rei_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","మీ ప్రేమించిలాలింకల్ల గద్దించికిరి సిక్సించిలించి గనుక తూ ఆసక్తి కలిగికిరి మారుమనుసు పొందుగును. ");
INSERT INTO rei_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","ఇత్తొ మీ తలుపు పక్కరె టారెకిరి తలుపుకు మల్లించి, కేసెనెను మో గొల సునికిరి తలుపు కడ్నె, మీ తాపక్కు అయికిరి తాసంగరె మీకూడ, మోసంగరె సేకూడ కద్ది కాంచో. ");
INSERT INTO rei_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","కేసె గెలిసిలవొ తాకు మో బోసంగరె కూడ తా సింహాసనమురె బొస్సికిరి తల్లా పనికిరి గెలిసిలతాకు మోసంగరె కూడ మో సింహాసనమురె బొసిపించుచి. ");
INSERT INTO rei_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","“సంగముసంగరె ఆత్మ కొయిల కొత కిరబుల్నె కన్నొతల్లాట సునివొ.” ");
INSERT INTO rei_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","యే సంగతీనె జరిగిల తరువాతరె మీ యింకగుటె దర్సనము దిగినాక, అత్తొ పరలోకమురె గుటె తలుపు పిటికిరిఅచ్చి. యీనె మీ అగరె సున్లి గొల బూరసబ్దముసంగరె మోసంగరె కొతలగిలీట సునించి. సె కొతలగిలీట ఎట్టికి ఉటికిరి అయిబులి యింకగరె జరిగిలాట గురించి తొత్తె దిగి దూంచి ");
INSERT INTO rei_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","వెంటనాక మీ ఆత్మసంగరె పూరికిరి, అత్తొ పరలోకమురె గుటె సింహాసనము పొక్కిరి అచ్చి. సింహాసనమురె జొనె ఆసీనుడుయికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","సాకిరి బొసిల మనమా ద్రుస్టికి సూర్యకాంత పనికిరి కెంపు పద్మరాగమునె బుల్ల విలువైల వజ్రాలు పొతొరొనె పనికిరి పోలికిరి అచ్చి. సే సింహాసనము చుట్టు ఇంద్రదనుస్సు పనికిరి అలంకరించికిరి ప్రకాసించుకుంట బొసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","ఇంకా సే సింహాసనముచుట్టు ఇరువది నాలుగు సింహాసనములు అచ్చి, యే సింహాసనములు పక్కరె ఇరువది నలుగురు బొడిలింకె దొగలాట కొన్నానె పిందిగినికిరి, తంక ముండొనొంపరె సువర్న కిరీటమునె నొగ్గినికిరి బొసికిరిఅచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","సే సింహాసనముతీకిరి మెరుపునె ద్వనులు ఉరుమునెకూడ అయిలీసి. యింక సే సింహాసనము అగరె సత్రబొత్తినె లక్కుంటఅచ్చి; సడ పురువురొ సత్ర ఆత్మానె. ");
INSERT INTO rei_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","యింక సే సింహాసనము అగరె స్పటికాన్ని పోలికిరి గాజు పనికిరి సొందొరొపనికిరి అచ్చి. సింహాసనము మొద్యిరె, సడ చుట్టు చార జీవజంతువూనె అచ్చి, సే జీవీనెకు అగరె పొచ్చుకు సొబ్బిటికి అంకీనె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","అగరె జీవి బగొ పనికిరి అచ్చి దీట జీవి దూడ పనికిరి అచ్చి తింట జీవి మనమార మూపనికిరి మూయీకిరి అచ్చి సారోట జీవి ఉడ్డిల పక్సిరొజ పనాట. ");
INSERT INTO rei_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","యే చార జీవులురె ప్రతి జీవికి సోట రెక్కానె అచ్చె, సడ చుట్టూకూడ రెక్కనెండ్రె బిత్తరె అంకినె సంగరె పూరికిరి అచ్చె. సడ రత్తి దూసి నామానుకుంటా యాకిరి కొయిలీసి. “పూర్వంరె అచ్చి ఉంచినె కూడ అచ్చి బవిసత్తు కలొరె తల్లా పురువుయీల ప్రబువు పరిసుద్దుడు, పరిసుద్దుడు, పరిసుద్దుడు” బులి కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","సే సింహాసనమురె బొసికిరి యుగయుగములు జీవించిల తాకు మహిమయు గనతయు క్రుతజ్ఞతా స్తుతులు కూడ గలిగిమాసి బులి సే జీవినె గయికుంట, ");
INSERT INTO rei_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","సే ఇరవై నలుగురు బొడిలింకె సింహాసనము పారె బొసికిరి తల్లతాకు అగరె సాగిలపొడికిరి, యుగయుగములు జీవించికిరి తల్లాటకు నమస్కారము కొరుకుంటా, ");
INSERT INTO rei_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","ప్రబువా, మో దేవా, తూ సొబ్బికూడ స్రుస్టించిలు తో చిత్తమువల్లరె సడచ్చి సడబట్టాక సుస్టించిబొడిసి గనుక తో వల్లరాక స్రుస్టింపబొడిసి ఈనె మహిమ గనత తువ్వాక. ");
INSERT INTO rei_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","యింక బిత్తరె పొదిరె రాసికిరితల్ల, సత్ర ముద్రనె గట్టిగా పొక్కిరి తల్లా గుటె గ్రందము సింహాసనమురె బొసికిరితల్లతాకు కైలత్తొ దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","యింక తాండ్రొ ముద్రనె కడికిరి సే గ్రందము పిటితె యోగ్యుడు యీలట కేసెబులి బలిస్టుడి యీల గుటె దేవదూత గట్టిగా కొయిలాట దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","యీనె పరలోకమురె గాని బూమిఉంపరెగాని బూమితొల్లెగాని సే గ్రందము పిటితెయినెను దిగితెయీనెను కాకు హక్కు నీ. ");
INSERT INTO rei_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","సే గ్రందము పిటితెకినెను దిగితెయినెను యెగ్యుడుకేసె నా దిగిదిలందుకు మీ బూతుగా కందితన్నుగా, ");
INSERT INTO rei_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","సె బొడిలింకెబిత్తరె జొనె కందితెనా; ఇత్తొ దావీదుకు వంసమైల యూదా గోత్రముకు సింహము సత్ర ముద్రనె కడికిరి సే గ్రందముకు పిటితె జయముపొందుసిబులి మో సంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","యీనె సింహాసనముకు సే సారా జీవికిను బొడిలింకె మొజిరె, బలియీకిరి తల్లా గొర్రిపిల్ల టారేకిరి తల్లాట దిగించి. సే గొర్రిపిల్లకు సత్ర కొమ్మునె సత్ర అంకీనె అచ్చి. సే అంకీనె బూమిఉంపురుకు పొడిదిల్ల పురువురొ సత్ర ఆత్మానె. ");
INSERT INTO rei_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","సె అయికిరి సింహాసనమురె బొసికిరి తల్లటతాకు కైలత్తొరె తీకిరి సే గ్రందముకు కడిగినిసి. ");
INSERT INTO rei_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","సే సడనుకు కడిగిల్లాబెల్లె సే సారాజీవినుకు; వీననె, దూప ద్రవ్యము సంగరె పూరిల సువర్నపాత్రనుకు దరిగికితల్ల సె ఇరువది నలుగురు బొడిలింకె, సే గొర్రిపిల్ల పారె సాగిలికిరి పొడిసె. యే పాత్రనె పురువురొ ప్రజానాండ్రా ప్రార్దనానె. ");
INSERT INTO rei_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","సే బొడిలింకె తూ సే గ్రందముకు కడిగీకిరి తాండ్రొ ముద్రనె పిటితె యోగ్యుడవు, తూ బలిదీతుకు తో రొగొతొ దీకిరి, ప్రతి వంసమురె, వేరు వేరు బసొనె కొతలగిలింకెబిత్తరె, ప్రతి మనమానె బిత్తిరె, ప్రతిజనమురె, పురువు కోసం మనమానుకు గినికిరి, ");
INSERT INTO rei_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","అం పురువుకు సేవ కొరితె తంకు గుటె రాజ్యంగాను యాజకూనెపనికిరి కొరిసు. కాబట్టి తంకె బూలొకొరె ఏలుసె బులి నా గిత్తొ గాసె. ");
INSERT INTO rei_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","మీ యింక దిగినాక సింహాసనముకు జీవీనెకు, బొడిలింకె ఆవరించి తల్లా బడే దూతనె స్వరము సుందిల, తంక లెక్క కోట్లు సంగరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","తంకె బలియీల గొర్రెపిల్ల, సక్తి ఐస్వర్యముకు జ్ఞానముకు గనత మహిమకూడ స్తోత్రమునె పొందిగినితె అర్హుడుబులి గొప్ప స్వరముసంగరె కొయిలీసె. ");
INSERT INTO rei_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","సెత్తిలె పరలోకమురె బూలొకమురె బూమి తొల్లె సొందొరెబిత్తిరె తల్లా ప్రతి సుస్టించికిరిబొడిల, ఈనె తాండె బిత్తరె తల్లా సొబ్బి సింహాసనాము ఉంపరె బొసికిరి తల్లటకు గొర్రిపిల్లకు స్తోత్రం. ");
INSERT INTO rei_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","సె సారా జీవినె ఆమేను బులి కొయినాక సె బొడిలింకె సాగిలపొడికిరి నమస్కారముకొర్లె. ");
INSERT INTO rei_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","సె గొర్రిపిల్ల సె సత్ర ముద్రండ్రె అగరెతల్లాట పిటిలంపరె మీ దిగినాక సె సత్ర జీవిండ్రె గుటె అయిబులి ఉరుముపనికిరి స్వరముసంగరె కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","యీనె మీ దిగినాక ఇత్తొ గుటె దొగలాట గొడ దిగిదిల్ల; సడంపరె జొనె బానం దరిగినికిరి బొసికిరి అచ్చి. తాకు గుటె కిరీటం దీసె; సే జయించికుంట బయలుదేరిసి. ");
INSERT INTO rei_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","సె దీట ముద్ర పిటిలంపరె ఆయిబులి దీట జీవి కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","సెత్తిలె గొర్రటయీల ఇంకగుటె గొడ బయిలుదేరికిరి జేసి; మనమానె జొనెకుజొనె పొర్నొ కడిగిల్లాపనికిరి బూలోకమురె సమాదానమునీకుంట కొరితె యే గొడంపరె బొసిరికిరి తల్లాటకు అదికారం దీకిరి అచ్చి. యీనె తాకు బొట్ట కడ్గము దివ్విరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","సె తింట ముద్ర పిటిలబెల్లె ఆయిబులి తింటజీవి కొయిలాట సునించి. మీ దిగినాక, ఇత్తొ గుటె కలియాట గొడ దిగిదిల్ల; సడంపరె జొనె తక్కిడి అత్తరె దరిగినికిరి బొసికిరి అచ్చి ");
INSERT INTO rei_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","యీనె గుటె వెండినానెముకు గుటె సేరు గోదుమబులి, గుటె వెండినానెముకు దీట సేర్లు యవలుబులి, తెల్లొ ద్రాక్సారసముకూడ పాడుకొరితె నా బులి, సె సారా జీవినె మొజిరె గుటె గొల పలికిల పనికిరి మెత్తె సుందిల ");
INSERT INTO rei_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","సే సారా ముద్ర పిటిలంపరె ఆయిబులి సారా జీవి కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","సెత్తిలె మీ దిగినాక, ఇదిగొ పోసో రంగు బుల్ల గుటె గొడ దిగిదిల్ల; సడంపరె బొస్సికిరితల్లటర నా మోరొనొ. పాతాల లోకము తా సంగరె జెల్ల. కడ్గముసంగరె యినెను, కరవు సంగరె యినెను, జబ్బునె సంగరె యినెను, క్రూరజంతువు సంగరె యినెను పొర్నొకడితె బూమిఉంపరె సారోబాగమంపరె తాకు అదికారం దివ్వొరొ జరిగిల ");
INSERT INTO rei_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","సే పాట ముద్రకూడ పిటిలంపరె, పురువురొ వాక్యము కోసం, తంకె దిల్లట సాక్స్యము కోసం మొరిజిల్లాలింకె ఆత్మానె బలిపీటము తొల్లె దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","తంకె నాదా, సత్యవంతుడు, పరిసుద్దడా, ఎత్తెవరుకు తీర్పు నా కొరుకుంట, అం రొగొతొ గురించి బూమి ఉంపరె జీలాలింకు ప్రతిదండన నాకొరుకుంట తాసుబులి గట్టిగా కేకానె పొగించి. ");
INSERT INTO rei_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","దొగలాట కొన్నానె తంకెబిత్తరె సొబ్బిలింకు దివ్వొరొ జరిగిల; ఈనె తంక పనికిరాక మొరివలిసిలలింకె కూడ దాసునెసంగరె అన్నబయినెసంగరె లెక్క పూర్తిలవరుకు యీనె కుండె కలొ విస్రమించివాసెబులి తంక సంగరె కొయివురొ యీసి. ");
INSERT INTO rei_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","సె సోట ముద్ర పిటిలబెల్లె మీ దిగినాక బొట్ట బూకంపము జరిగిల. సూర్యుడు గొంగలి దుప్పటిపనికిరి కలియాకిరి మారిజెసి. చంద్రబింబ అల్లా రొగొతొ పనికిరి గొరైకిరి యీజేసి. ");
INSERT INTO rei_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","బొట్ట బాసంగరె ఊపుకుంటతల్ల అంజూరపు గొచ్చొతీకిరి కొంచ కాయనె జొడిలాపనికిరి మెగొరెతల్ల నక్సత్రములు బూమిఉంపరె జొడి జేసి. ");
INSERT INTO rei_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","ఇంక మెగొ చుట్టిల కైతొపనికిరి అద్రుస్యమైజీసి. పర్వతాలూ, సారపక్కరె పనిసంగరెతల్ల బాగం సొబ్బికూడ తాండె చోటుతీకిరి కదిలిజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","సెత్తిలె బూరొజానె, ప్రముకునె, దనికునె, సైన్యాదిపతీనె, బలిమీలలింకె, ప్రతి దాసుడు ప్రతి స్వతంత్రుడు గుహండ్రె, పొరొతొనె బండనె మొజిరి నుచ్చిపొల్లె. ");
INSERT INTO rei_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","బండనెసంగరె, పొరొతొనెసంగరె తంకె యాకిరి కొయిసె; అం ఉంపరె పొడొండి, సింహాసనం ఉంపరె బొస్సికిరి తల్లా సడరొ మూ తీకిరి గొర్రెపిల్ల రగ్గొతీకిరి అముకు నుచ్చిదేండి. రగ్గొకు మహా గొప్పదినొ ఆసి; సడకు ఎదిరించిలాట కేసె? ");
INSERT INTO rei_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","సె మహాఉగ్రత దినొరె సడకు ఓర్పుకగిలాటాత కేసె. ");
INSERT INTO rei_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","సే తరువాత బూమి చార దిక్కుండ్రె చార దేవదూతనె టారేకిరి, బూమి ఉంపరెనెను సొంద్రొ ఉంపరెనెను కే గొచ్చొ ఉంపరెనెను బా నా అయిలాపనికిరి బలంగా అడ్డిగిచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","ఈనె సజీవుడుయీల పురువురొ ముద్రయీల ఇంకగుటె దూత సూర్యోదయ దిసతీకిరి ఉంపురుకు అయిలాట దిగించి, బూమికి సొంద్రొకు హాని కొరితె అదికారం పొందిల సే సారా దూతనెసంగరె సెయ్యె బొట్ట స్వరంసంగరె కొయిలాట సునుంచి. ");
INSERT INTO rei_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","యే దూత అమ్మె అం పురువురొ దాసునె తంక చిత్తంరె ముద్రించిలజాంక బూమికీనెను సొంద్రకీనెను గొచ్చొనె కినెను హాని నా కొరుబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","ఈనె పురువురొ ముద్ర తంక చిత్తంపరె ముద్రింపబొడిల లెక్క కొయినాక సునించి, తంకె లెక్కకు గుటె లక్స నలపై నాలుగువేల మంది. తంకె ఇస్రాయేలు గోత్రమురె తల్లలింకె. ");
INSERT INTO rei_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","యూదా గోత్రంరె ముద్రించిలింకె పండెండువేలమంది. రూబేను గోత్రంరె పండ్రెండు వేలమంది, గాదు గోత్రంరె పండ్రెండు వేలుమంది, ");
INSERT INTO rei_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","ఆసేరు గోత్రంరె పండ్రెండు వేలుమంది, నప్తాలి గోత్రంరె పండ్రెండు వేలుమంది, మనస్సే గోత్రంరె పండ్రెండు వేలుమంది. ");
INSERT INTO rei_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","సీమ్యోను గోత్రంరె పండ్రెండు వేలుమంది, లేవి గోత్రంరె పండ్రెండు వేలుమంది, ఇస్సాకారు గోత్రంరె పండ్రెండు వేలుమంది, ");
INSERT INTO rei_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","జెబూలూను గోత్రంరె పండ్రెండు వేలుమంది, యోసేపు గోత్రంరె పండ్రెండు వేలుమంది, బెన్యామీను గోత్రంరె పండ్రెండు వేలుమంది, ");
INSERT INTO rei_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","సె తరువాత మి దిగినాక, ఇత్తొ, ప్రతిమనమానెబిత్తితీకిరి ప్రతివంసముతీకిరి ప్రజలతీకిరి, బడే బసోనె కొతలగిలలింకెబిత్తరె తీకిరి అయికిరి అచ్చె. తంకె దొగలా కొన్నానె పిందిగినికిరి అత్తోనెరె కర్జూరం మట్టనె దరిగికిరి అచ్చె. గొప్ప సముహము మెత్తె దీదిల్ల. ");
INSERT INTO rei_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","సింహాసనము ఉంపరె బొస్సికిరి తల్లా అం పురువుకు గొర్రెపిల్లకు అం రక్సనగూరించి సోత్రంబిలి మహాసబ్దంసంగరె ఎలుగెత్తికిరి కొయిలె. ");
INSERT INTO rei_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","దేవదూతనె సొబ్బిలింకె సింహాసనముచుట్టుకూడ బొడిలింకెచుట్టు సె చార జీవినె చుట్టుకూడ టారెకెరి అచ్చె. తంక మూనె బూమికి ఆనిగీకిరి పురువుకు ఆరాదించిలీసె. ");
INSERT INTO rei_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","యుగయుగమునె జాంక అం పురువుకు సోత్రముబిలి మహిమ జ్ఞానముకూడ క్రుతజ్ఞతా స్తుతి గనతకు సక్తికి బలము కలిగివాసి బులి కొయికుంట పురువుకు ఆమేను బులి కొయిసె; ");
INSERT INTO rei_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","బొడిలింకెబిత్తిరె జొనె దొగల కొన్నానె పిందిగినికిరితల్ల యేకేసె? కేటితీకిరి అయిసిబులి మెత్తె పొచ్చిరిసి. ");
INSERT INTO rei_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","సడకు మీ అయ్యా, తొత్తాక తెలుసుబులి కొయినాక సే యాకిరి మో సంగరె కొయిల అంకె మహోస్రమతీకిరి అయిలలింకె; గొర్రెపిల్లరొగొతొరె తంక కొన్నానె కచ్చిగినికిరి సడకు దొగలకొరిగిల్లె. ");
INSERT INTO rei_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","సడవల్లరె తంకె పురువురొ సింహాసనము అగరె తీకిరి రత్తిదూసి తా మందిరంరె తాకు మొక్కికుంట అచ్చె. సింహాసనము ఉంపరె బొస్సికిరి తల్లతా సేయాక తా గుడారము ఉంపరెతల్లలింకు బుజ్జిపీసి. ");
INSERT INTO rei_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","తంకు ఇంక బొక్కొయీనెను గొలారివురొ తన్ని, సూరిడురొ కొర యీనెను కే వడబా యీనెను తంకు బైని, ");
INSERT INTO rei_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","కిరబుల్నే సింహాసనము మొజిరె బొసికిరి తల్లా గొర్రెపిల్ల తంకు కాపరియీకిరి, జీవజలముల బుగ్గనెపక్కు తంకు సలిపించుసి, పురువాక తంక అంకీనెతీకిరి ప్రతి బాస్పబిందువుకు పుంచిపోసి. ");
INSERT INTO rei_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","సె సత్ర ముద్రకు పిటిలబెల్లె పరలోకమురె ఇంచుమించు అరగంట సేపు నిస్సబ్దముగా అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","సెత్తిలె మీ పురువు అగరె టారెకిరి తల్లా సత్ర దూతనుకు దిగించి; తంకు సత్ర పుంకిల బొట్ట తూతురునె దిల్లె. ");
INSERT INTO rei_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","ఇంక సువర్న సాంబ్రాని దివిటి అత్తరె దరిగీకిరి తల్లా ఇంకగుటె దూత అయికిరి బలిపీటము అగరె టారెకిరి తన్నుగా సింహాసనము అగరె తల్లా సున్న బలిపీటము ఉంపరె పురువురొ ప్రజానెకు ప్రార్దనానె సంగరె మిసితె తాకు బడే దో ద్రవ్యమునె దివ్విరొయీల. ");
INSERT INTO rei_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","సెత్తిలె సాంబ్రాని దివిటిరె దో పురువురొ ప్రజానె ప్రార్దననెసంగరె మిసికిరి దూత అత్తరెతీకిరి ఉంపురుకుజేకిరి పురువురొ సన్నిదికి బాజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","సే దూత సాంబ్రాని దివిటి కడిగినికిరి, బలిపీటము ఉంపరె తల్లా నియానెసంగరె సడకు పూరుదీకిరి, బూమిఉంపరె పొక్కిదిన్నకా ఉరుమునె ద్వనినె మెరుపునె బూకంపములు కలిగిల. ");
INSERT INTO rei_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","సెత్తిలె సత్ర పుంకిల తూతురునె దరిగినికిరి తల్లా సే సత్రలింకె దూతనె పుంకితె సిద్దపొడిలె. ");
INSERT INTO rei_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","అగరె దూత బూర పుంకిల బులి రొగొతొ సంగరె మిసికిరి తల్లా నియ్యా వడగండ్లునె కలిగిల, సడకు బీ ఉంపురుకు పొక్కిదివురొ జరిగిసి, సెత్తిలె గొచ్చొనె తింటబాగం పుడ్డిజేసి, పచ్చగస్సొ సొబ్బిపుడ్డిజేసి. ");
INSERT INTO rei_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","దీట దూత తూతురునె పుంకిలబిలె నియ్యాసంగరె మండికుంటతల్ల బొట్ట బొనొపనికిరితల్ల గుటె సొంద్రొరె పొక్కిదివ్వొరొ జరిగిల, సడవల్లరె సొంద్రొరె తింటబాగం రొగొతొ యీజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","సొంద్రొరెబిత్తిరె పొర్నొకలిగికిరి తల్లా జంతువూండ్రె తింట బాగం మొరిజెల్ల, పడవానెండ్రె తింట బాగం నాసనము యీల. ");
INSERT INTO rei_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","తింట దూత తూతురు పుంకిలపారె దివిటీనెపనికిరి మండితల్ల గుటె బొట్ట నక్సత్రం మెగొతీకిరి రాలికిరి నదినె తింటబాగం ఉంపరె పనిబుగ్గనె ఉంపరెకు పొల్ల. ");
INSERT INTO rei_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","సె నక్సత్రముకు చేదుబులి నా, సడవల్లరె పనిబిత్తిరె తింటబాగం చేదు యీజెల్ల; పని చేదు యిజెవ్వొరొ సె పని పీలలింకెల్ల బడె మంది మనమానెబిత్తరె కూడా మొరిజెల్లె. ");
INSERT INTO rei_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","చార దూత తూతురు పుంకిలబులి సూర్య చంద్ర నక్సత్రమురె తింటబాగం వొందారొ కమ్మిలపనికిరి, దూసిబెల్లె తింటబాగముకు సూరిడు నా ప్రకాసింపలపనికిరి, రత్తిరె తింటబాగం చంద్ర నక్సత్రములు నా ప్రకాసింపలపనికిరి తాండె బిత్తరె తింటబాగం హల్లొ నీకుంట యీజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","యింక మీ దిగినాక మెగొమొజ్యిరె గుటె పక్సిరొజా ఉడ్డుకుంట తూతురునె పుంకెతె తల్లా తిల్లింకె దూతనె తూతురునె సబ్దమునెబట్టి బూమిఉంపరె జీలాలింకు అయ్యో, అయ్యో, అయ్యో బులి గొప్ప స్వరము సంగరె కొయిలాట సునించీ. ");
INSERT INTO rei_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","పాట దూత తూతురు పుంకిలబులె మెగొతీకిరి బుమిఉంపరె రాలిల గుటె నక్సత్రముకు దిగించి, అగాదమురొ తాలము తాకు దీకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","సె అగాదము పిటినాక బొట్ట కొలిమితీకిరి ఉటిలా దోపనికిరి దో సె అగాదముతీకిరి ఉటిసి; సే అగాదముబిత్తరె దోసంగరె సూరుడుకు వాయుమండలముకు వొందారొ కమ్మిల, ");
INSERT INTO rei_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","సే దో బిత్తరె తీకిరి మిడతానె బూమిఉంపురుకు అయిసి, బూమిరె తల్లా పొటినుకు బలముతల్లపనికిరి సడనుకు బలము దివ్వురొయీల. ");
INSERT INTO rei_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","ఈనె చిత్తంపరె పురువురొ ముద్రనీల మనమానుకు తప్ప బూమి ఉంపరెతల్ల గసొకు యినెను కే మొక్కనెకు యినెను ఇంక కే గొచ్చొకు యినెను నస్టము యీనాసె బులి సడకు ఆజ్ఞ దివ్విరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","ఈనె తంకు మొరిదీతె అదికారం దివ్వినీంతె యీనె పాట మసొజాంక బాదనొగితె సడకు అదికారం దివ్విరొ యీల. సడవల్లరె కలిగిలా బాద, పొటియ మనమకు బుసిలాబెల్లె తల్లా బాదపనికిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","సె దినోండ్రెరె మనమానె మొరిజెమ్మ బులి కుజ్జుసె యీనె సడ తంకు మిలిని; మొరిజెవ్వాసెబిలి ఆసపొడుసె యీనె మోరొనొ తంకతీకిరి పొలిజోసి. ");
INSERT INTO rei_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","సె మిడతానె రూపునె యుద్దముకు సిద్దపొడికిరితల్ల గొడానెకు పోలికిరి అచ్చి సున్నాపనికిరి మెరిసిల కిరీటముపనికిరితల్ల సడరొ ముండొనొంపరె తాసి; తాండ్రొ మూనె మనమారొ మూనెపనికిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","తిల్డ్రాంట ముండొరొబల్లొపనికిరి బల్లొనె సడనాకు అచ్చి, తాండ్రొ దాంతోనె సింహము కోరనెపనికిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","సడనెకు ఇనుము బుక్కొరొ కవచము పనికిరి కవచానె అచ్చి. తాండ్రొ రెక్కనె చప్పుడునె యుద్దముకు దోండుకుంట తల్లా బడే గొడానె తల్లా రదమునె చప్పుడుపనట. ");
INSERT INTO rei_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","పొటియ లెంజొనె పనికిరి లెంజొనె కొంటానె సడనుకు అచ్చి. పాట మసొజాంక తాండ్రె లెంజొనె సంగరె మనమానకు హాని కొరితె సడనాకు అదికారం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","పాతాలపు దూత సడనెంపరె రొజాగా అచ్చి; హెబ్రీ బాసేరె తాకు సొరొరాట నా, గ్రీసుదెసొ బాసరె తా నా అపొల్లుయోను. సడకు అర్దం నాసనము కొరిలాట బులి. ");
INSERT INTO rei_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","అగరె స్రమ గతించిజెల్ల; ఇత్తొ ఇంక దీట స్రమనె తరువాత ఆసి. ");
INSERT INTO rei_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","సోట దూత తూతురు పుంకిలబిలె పురువు అగరె తల్లా సున్న బలిపీటము మూలనె తీకిరి గుటె స్వరము సుందిల. ");
INSERT INTO rei_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","సె స్వరం మహనది “యూప్రటీసు పక్కరె బందిల చార దూతనుకు సడిదే” బులి తూతురు దరిగినికిరి తల్లా సోట దూతసంగరె కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","మనమానెబిత్తిరె తింటబాగముకు పొర్నొ కడివాసిబులి సె బొచ్చొరొకా సె మసొరాక సె దినొకా, సె గంటకు సిద్దపొడికిరి తల్ల సె చార దూతానె సడిదివ్వొరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","గొడానె రౌతుల సైన్యముర తల్లా దలం సంక్య ఇరువై కోట్లు, తంక సంక్య యడబులి మీ సునించి. ");
INSERT INTO rei_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","యీనె మెత్తె కలిగిల దర్సనమురె యాకిరి దిగించి, సె గొడానుకు తాండ్రెంపరె బొస్సిలలింకు, నియపనికిరి గొర్రాట వర్నము, నీలవర్నము, గందకవర్నమునె కవచము అచ్చి, సె గొడానె ముండొనె బగొనె ముండొనెపనట, తాండ్రొ తుండొనె తీకిరి నియ్య దో గందకమూనె బయలు జేతవ్వి. ");
INSERT INTO rei_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","యే తింట మడ్డొనె వల్లరె, బుల్నె ఆండ్రె తుండొనెతీకిరి బయిలు జేతల్ల నియ్య దో గందకమూనె సంగరె, మనమానె బిత్తిరె తింటబాగం మొరిజెవొరొ యీసి. ");
INSERT INTO rei_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","సె గొడాన్రె బలము సడరొ తుండొరె తాండె లెంజొనెండ్రె అచ్చి, కిరుకుబుల్నే తాండె లెంజెనె సప్పొనెపనికిరి తైకిరి ముండొనె తల్లందుకు సడసంగరె సడ నస్టము కొరుసి. ");
INSERT INTO rei_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","యే మడ్డొనెవల్లరె నా మొరిజీకుంట మిగిలలింకె మనమానె, బుత్తొనొకు, దుగుసె సునుసె సలుసె సక్తి నీకుంట, సున్నా వెండి కంచు పొత్తొరొ కట్టొనెసంగరె కొరిల తంక అత్తోనెసంగరె కొరిల విగ్రహాలు నా పూజించికుంట సడదిల్లపనికిరి మారుమనసు పొందివినీంతె. ");
INSERT INTO rei_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","ఈనె తంకె కొరుకుంట తల్లా నరహత్యనుకు మాయమంత్రమునెకు సొర్నిపైటినె, సోరొపైటినె నా కొరుకుంట తంకె మారుమనుసు పొందివి నీంతె. ");
INSERT INTO rei_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","బడె బలమీల ఇంకగుటె దూత పరలోకముతీకిరి వల్లిలట దిగించి. సె మెగొ దరించిగినికిరి అచ్చి, తా సిరస్సుంపరె ఇంద్రదనుస్సు అచ్చి; తా మూ సూర్యబింబముపనికిరి తా పాదమునె నియ్య స్తంబమూనె పనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","తా అత్తరె పిటికిరి తల్ల గుటె సన్ని పుస్తకం అచ్చి. సెయె తా కైలపాదము సొంద్రొరెంపరెను బాగొడ్డొ పాదము బూమింపరె మోపికిరి రొయిదీసి. ");
INSERT INTO rei_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","బగొ గర్జించిలపనికిరి గొప్ప సబ్దము సంగరె దొందిరిల, సె దొందిరిల పారె సత్ర ఉరుమునె సెడ సడరొ సబ్దమునె పలుకుసి. ");
INSERT INTO rei_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","సె సత్ర ఉరుమునె పలికిల బెల్లె మీ రాస్తన్నాగా సత్ర ఉరుమునె పలికిల సంగితినెకు ముద్రపొగు, సడనకు నారాసుబులి పరలోకము తీకిరి గుటె స్వరము పలికిలట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","ఇంక సొంద్రొంపరె బూమింపరె టారేకిరితన్నుగా మీ దిగిల సే దూత తా కైలత్తొ మెగొకాసి టెక్కిల. ");
INSERT INTO rei_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","పరలోకమురె తాండె బిత్తరె తల్లాట గురించి, బూమికి తాండె బిత్తరె తల్లాట గురించి, సొంద్రొకు తాండె బిత్తరె తల్లాట గురించి, యుగయుగములు జీవించి తల్ల సడంపరె ఒట్టునొక్కిరి ఇంక ఆలస్యం యీనిబులి దూత కొయిసి! ");
INSERT INTO rei_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","తెలిసిలా ఈనె సత్ర దూత పలికిల దినొరె సె తూతురు పుంకితన్నుగా, పురువు తా దాసునుకు ప్రవక్తనుకు సువార్తప్రకారం పురువురొ నుచ్చిల ప్రనాలిక సమస్తము యీలపనికిరి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","సెత్తెలె పరలోకము తీకిరి మీ సునిల స్వరము ఇంక మో సంగరె కొతలగుకుంట “తూ జేకిరి సొంద్రొంపరెను బూమింపరెను టారేకిరితల్ల సే దూత అత్తరె పిటికిరి తల్లా సే సన్ని పుస్తకము పిటికిరి అచ్చిబులి మెత్తె కొయిసి.” ");
INSERT INTO rei_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","మి సె దూత పక్కు జేకిరి యే సన్ని పుస్తకము మెత్తె దేబులి మగినాక సే సడకు కడిగినికిరి కాబులి, సడ తో పెట్టొకు అసాయంపనికిరి యినె తో తుండొకు తేనెపనికిరి మదురుముపనికిరి తాసిబులి మోసంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","సెత్తిలె మీ సే సన్ని పుస్తకము దూత అత్తరెతీకిరి కడిగినికిరి సడకు కైపించి; సడ మో తుండొకు తేనెపనికిరి మదురుగా తాసిగాని మీ సడకు కైపీల తరువాతరె మో పెట్టొకు అసాయమైల. ");
INSERT INTO rei_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","సెత్తిలె తంకె తూ మనమానె గురించిగాని, జనమునె గురించి గాని, వేరు వేరు బసొనె కొతలగిలలింకు గురించి, బడేమనమానెకు రొజానె గురించి, ఇంక పురువురొ సందేసము కొయివాసి బులి మో సంగరె కొయిసె. ");
INSERT INTO rei_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","ఇంక జొనె అత్తొబడ్డిపంట నప్పిలాబడ్డి మెత్తెదీకిరి తూ టారెకిరి పురువురొ మందిరముకు బలిపీటముకు నప్పాపొక్కిరి, మందిరంరె పూజించిలలింకు లెక్కకొరు. ");
INSERT INTO rei_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","మందిరముకు పొదిరె ఆవరనముకు కొలత పొగివిని సడిదె; సడ అన్యమనమానెకు దివ్విరియీసి, తంకె చార దొస్టంపరె దీట మసో పరిసుద్ద గాకు గొడ్డొసంగరె మండివె. ");
INSERT INTO rei_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","మీ మో దీలింకు సాక్సులింకు అదికారం దిమ్మి; తంకె గోనిసంచి పిందిగినికిరి పండ్రెండు వందలు అరవై దినొనె పురువురొ కొతనె ప్రవచించుసె. ");
INSERT INTO rei_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","అంకె బూలొకొకు ప్రబూయీల తా అగరె టారేకిరితల్ల దీట సాక్సీనె ఒలీవగొచ్చొనుకు బొత్తి స్తంబము పనికిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","కేసెనెను తంకు నస్టము కొరిమంచె బులి కొయిగిన్నె తంక తుండొ దీకిరి నియ బయలుదేరికిరి తంక సత్రువూనెకు పుడ్డిపోసి గనక కేసెనెను తంకు నస్టము కొరుమండి బులి కొయిగిన్నె సాకరాక సె మొరిజెవొరొ వూసి. ");
INSERT INTO rei_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","తంకె ప్రవచించిల దినోనె బొరొసొ నా అయికుంటా మెగొకు బుజ్జితె తంకు అదికారం అచ్చి. యీనె తంకు ఇస్టమీలబెల్లె పనికి రొగొతొపనికిరికొరితె, నానావిదమైల తెగులుసంగరె బూమికి బాదనొగితె తంకు అదికారం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","తంకె సాక్సము కొయితె ముగించినాక అగాదము తీకిరి అయిల క్రూరమ్రుగము తంకెసంగరె యుద్దము కొరికిరి జయించికిరి తంకు మొరిదివ్వె. ");
INSERT INTO rei_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","తంక మొడనె సె మహోపట్టనముకు సంత సైయినెండ్రె పొడికిరితాసి; తంకు ఉపమానము పనికిరి సొదొమ బులిగినికిరి నా; సెట్టె తంక ప్రబువుకు కూడ సిలువపొగివొరొయీల. ");
INSERT INTO rei_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","యీనె ప్రజలకు, వంసోనెకు, వేరు వేరు బసొనె కొతలగిలలింకు, మనమానుకు సంబందించిలలింకు తింట దినొన్నార సంగరె తంక మొడనుకు దిక్కుంట తంక మొడనుకు సమాదిరె నొగిపించినింతె. ");
INSERT INTO rei_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","యే దీలింకె ప్రవక్తనె బూమిఉంపరె తల్లమనమానుకు బాద నొగిలందుకు బూమిరె జీలలింకె తంక గతి దిక్కిరి సంతోసించుకుంట, ప్రోత్సహించుకుంట, జొనుకు జొనె బహుమతినె పొడిదిగునుసె. ");
INSERT INTO rei_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","యీనె సె తింట దినొన్నార యీల తరువాత పురువుపారె తీకిరి జీవాత్మ అయికిరి తంకె బిత్తిరె ప్రవెసించుసి గనుక తంక పాదాలునె డొరొసంగరె టారెసె; తంకు దిగిలలింకు మిగుల డొరొ కలుగుసి. ");
INSERT INTO rei_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","సెల్లె ఎట్టికి ఉటికిరి అయిబులి పరలోకముతీకిరి గొప్పస్వరము తంకెసంగరె కొయిలాట తంకె సునికిరి, మెగొనె దీకిరి పరలోకముకు బాజెల్లె; తంకె జేతన్నుగా తంక సత్రువునె తంకు దిగిసె. ");
INSERT INTO rei_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","సే గడియరాక గొప్ప బూకంపము కలిగిలవలరె సే పట్నమురె దొస్టబాగం కూలిజేసి, సె బూకంపమువలరె సత్రవెయ్యి ప్రజనె మొరిజెవ్వొరొ యీసి, మిగిలలింకె డొరొజేకిరి పరలోకమురె తల్లా పురువుకు మహిమపరిచిలె. ");
INSERT INTO rei_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","దీట స్రమ గతించిల; ఇత్తొ తింట స్రమ బేగా అయిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","సత్ర దూత తూతురు పుంకిలబిలె పరలోకమురె గొప్ప సబ్దము పుట్టిసి, సె సబ్దములు యే లొకొ రాజ్యము అం ప్రబువు రాజ్యముకు సే క్రీస్తు రాజ్యముకు యీల; సే యుగయుగమునె జాంక ఏలుసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","సెత్తిలె పురువు అగరె సింహాసనమురె బొసిలలింకు సే యిరువది చారలింకె బొడిలింకె సాస్టాంగ పొడికిరి పురువుకు నమస్కారము కొరిసి. ");
INSERT INTO rei_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","జరిగితల్లా కలొరె జరిగిజెల్లారె కలొరె తల్లా పురువు యీల ప్రబూ, సర్వాదికారీ, తూ తో మహాబలముకు స్వీకరించికిరి ఏలిలీసు యీనె అమె తొత్తె క్రుతజ్ఞతా స్తుతులు చెల్లించిలించొ. ");
INSERT INTO rei_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","మనమానె రగ్గొ పొడిలందుకు తొత్తె రగ్గొ అయిసి, మొరొజిలింకె తీర్పు పొందిగినితుకు, తో దాసునెయీల ప్రవక్తానెకు పరిసుద్దులకు, తో నా కు డొరొజెల్లాలింకు తగిలా పలము దీతె, గొప్పలింకె యీనెను నొయిలలింకె యీనెను బూమికి నాసనము కొరిలాలింకు నాసనము కొరితె సమయము అయిల బులి కొయిల. ");
INSERT INTO rei_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","యీనె పరలోకమురె పురువురొ మందిరము పిటినాక పురువురొ నిబందనమందసము తా మందిరంరె దీదిల్ల, సెత్తిలె మెరుపునె సబ్దమునె ఉరుమునె బూకంపమూనె గొప్ప వడగండ్లునె కూడ పుట్టిసె. ");
INSERT INTO rei_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","సెత్తిలె పరలోకమురె గుటె గొప్ప అద్బుతం దీదిల్ల; సడకిరబుల్నె సూరిడికు దరించిగిల్ల గుటె మొట్ట తా పాదమూనె తొల్లె చంద్రుడుకు సిరస్సుంపరె పండ్రెండు నక్సత్రములడ్ర కిరీటం అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","సే మోట్ట గర్బివతి యీకీరి ప్రసవవేదన పొడుకుంట సే బొత్తనుకు కేకానె పొగిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","సెత్తిలె పరలోకము తీకిరి యింగుటె దిగిదీల్ల. ఇత్తొ గొర్రాట రక్కెసంగరె తల్లా బొట్ట సప్పొ; సడకు సత్ర ముండొనె దొస్ట కొమ్మునె అచ్చి; తాండె ముండొనంపరె సత్ర కిరీటమునె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","తాండె లెంజో మెగొ నక్సత్రములురె తింట బాగం యీడ్చికిరి సడకు బూమిఉంపరె పొక్కిదిల్ల. బేవలిసిలా సే మొట్ట బేలాబెల్లె, సె మొట్ట సిసువుకు గిల్దిమంచి బులి సే రెక్కనె సంగరె తల్లా గొర్ర సప్పొ సే మొట్ట అగరె టారేకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","సొబ్బి దెసోనుకు ఇనుము దండము సంగరె ఏలితె తల్లా గుటె సిసువుకు సె మొట్ట బేకిరి, సె మొట్ట సిసువుకు పురువు పక్కుకు తా సింహాసనముకు దరిగినికిరి బాజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","సె మొట్ట బొనుకు పొలిజెల్ల; సెట్టె తంకె పండ్రెండు వందలు అరువది దినొనె సె మొట్టకు పోసించిమాసెబులి పురువు సె మొట్టకు గుటె స్తలము సిద్దము కొరికిరి నొగిసి. ");
INSERT INTO rei_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","సెత్తిలె పరలోకమురె యుద్దము జరిగిల. మికాయేలుకు తా దూతనుకు సె రెక్కనెసంగరె తల్లా సప్పొ యుద్దము కొరివాసి బులి తన్నుగా, ");
INSERT INTO rei_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","సె రెక్కనె సంగరె తల్లా సప్పొ సడరొ దూతనె యుద్దము కొరిసి గాని గెలిసినారిసె గనుక పరలోకమురె తంకు స్తలము నొయికుంట యీజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","ఈనె సర్వలోకముకు మోసము కొరుకుంట, అపవాదిబులి సాతానుబులి నా బుల్లట ఆదిసర్పమైల సె బొట్ట రెక్కనె సంగరె తల్లా సప్పొ పొక్కిదిల్లె. సడకు బూమిఉంపరె పొక్కిదివ్వొరొయీల; తాండె దూతనె సడసంగరాక పొక్కిదివ్విరొయీల. ");
INSERT INTO rei_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","యీనె గుటె గొప్ప స్వరము పరలోకమురె యాకిరి కొయిలాట సునించి, రత్తిదూసి అం పురువు అగరె అం అన్నబయినంపరె నేరము మోపిలాట యీల అపవాదికు పొక్కిదివ్వురొ జరిగిల గనుక ఉంచినె రక్సనకు పొక్కిదీకిరి అచ్చి గనుక యించిని రక్సన సక్తి రాజ్యముకు అం పురువురొ యీల; వుంచినె అదికారం తా క్రీస్తురొట యీల. ");
INSERT INTO rei_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","తంకె గొర్రెపిల్ల రొగొతొ వల్లెను, సె దిల్ల సాక్సమువల్లరె తాకు జయించికిరి అచ్చి గాని, మోరొనొజాంక తంక పొర్నొనుకు ప్రేమించిలలింకె నీంతె. ");
INSERT INTO rei_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","సడవల్లరె పరలోకము, పరలోకమురె జీలలింకె, సంతోసము పొడొండి; బూమి, సొంద్రో, తొముకు స్రమ; అపవాది తాకు సమయము కుండేకా అచ్చి బులి తెలిసిగినికిరి బడె రగ్గొగల్లట యీకిరి తొమపక్కు ఒల్లికిరి అయిసి. ");
INSERT INTO rei_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","సె రక్కనెసంగరెతల్ల సప్పొనె సె బూమిఉంపరె పొక్కిదిల్లాట దిక్కిరి, సె సిసువుకు బేలా సె మొట్టకు హింసించిల; ");
INSERT INTO rei_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","సడవల్లరె సె మొట్ట బొనొరె తల్లా తా చోటుకు ఉడ్డిలపనికిరి గొప్ప పక్సిరొజా రెక్కనె దీట సే మొట్టకు దివ్వొరొయీల. సెత్తిలె సే రెక్కనెసంగరె తల్లా సప్పొ నాదిక్కికుంట సే మొట్టకు చారదొస్టంపొరె దీట మసొ పోసించివొరొ ఏర్పాటుయీల. ");
INSERT INTO rei_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","యీనె సె మొట్ట, ప్రవాహముకు మరిగినికిరి బాజెమంచె బులి సె రెక్కనెసంగరె తల్లా సప్పొ తా తుండొదీకిరి పనికి నదిప్రవాహముపనికిరి సె మొట్ట పొచ్చాడె పొడిదీసి ");
INSERT INTO rei_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","కాని బూమి సె మొట్టకు సహయము కొరిల. తా తుండొ పిటికిరి సె రెక్కనె సంగరె తల్లా సప్పొ, తా తుండొదీకిరి ఒక్కిల్సి ప్రవాహముకు మింగిపేల. ");
INSERT INTO rei_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","సడవల్లరె సే రెక్కనె సంగరె తల్లా సప్పొ రగ్గొ దనెగినికిరి, పురువురొ ఆజ్ఞానె తెలిసిగినికిరి యేసుగూరించి సత్యముకు కొయిల తల్లలింకు సే మొట్టరొ సంతనముసంగరె మిసిలలింకు యుద్దము కొరితె బయలుదేరిల. ");
INSERT INTO rei_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","సెతెలె సె రెక్కనె సంగరె తల్లా సప్పొ సొంద్రొ ఒడ్డురె టారెకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","ఈనె దొస్ట కొమ్మూనె సత్ర ముండునె బిల్ల గుటె క్రూరమ్రుగము సొంద్రొతీకిరి ఉంపురుకు అయిలాట దిగించి. తాండె కొమ్మానుంపరె దొస్ట కిరీటమునె తాండె ముండునెంపరె దేవదూసనకరమైల నానే అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","మి దిగిల సె మ్రుగము చిరుతబగొకు పోలికిరి అచ్చి. సడరొ పాదమునె ఎలుగుబంటి పాదమూనెపనట, తాండె తుండొ బొడబగొ తుండొపనట, సడకు సె రెక్కానె సంగరె తల్లా సప్పొ తా బలముకు తా సింహాసనముకు గొప్ప అదికారం దీసె. ");
INSERT INTO rei_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","తాండె ముండోనెరె గుటెకు మొరిజెల్లమడ్డొ బైలపనికిరి అచ్చి; ఈనె సే మొరిజెల్లమడ్డొ మానిజెల్ల గనుక బూ జనుమునల్ల మ్రుగము పొచ్చడె జేకుంట ఆచర్యపొల్లె. ");
INSERT INTO rei_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","సె మ్రుగముకు అదికారముదిల్లందరె తంకె రెక్కనె సంగరె తల్లా సప్పొకు నమస్కారము కొరిసె. ఈనె తంకె యే మ్రుగము సంగరె సాటి కేసె? సడసంగరె యుద్దము కొర్లట కేసె? బులి కొయిగినికుంట సె మ్రుగముకు కూడ నమస్కారము కొరిసె. ");
INSERT INTO rei_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","పోజు కొతనుకు పురువుకు దూసించివురొ పలికిలాట గుటె తుండొ సడకు దివ్వొరొ యీల. ఈనె చార దొస్టంపొరె దీట మసోనె తా పైటి జరిపిగిల్ల అదికారం సడకు దివ్విరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","గనుక పురువుకు దూసించివురొ, తా నామముకు, తా గుడారముకు, పరలోకమురె జీలలింకు దూసించివురొ సడ తా తుండొ పిటిల. ");
INSERT INTO rei_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","ఈనె పురువురొ ప్రజానె సంగరె యుద్దము కొరిని తంకు జయించిని సడకు అదికారం దివ్వొరొ యీల. ప్రతి వంసము ఉంపరెకు ప్రతి ప్రజంపరెకు వేరువేరు బసొనె కొత లగిలలింకుంపరెకు ప్రతి జనముంపరెకు సడకు అదికారం దివ్వొరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","బూమి ఉంపరె జీలా లింకల్ల, బుల్నె సుస్టి మొదులుతీకిరి వదింప బొడికిరితల్ల గొర్రెపిల్లరొ జీవగ్రందమురె కా నా రాసికిరి నీవొ తంకె, సె మ్రుగముకు నమస్కారము కొరుసె. ");
INSERT INTO rei_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","కేసెనెను కన్నొనె తల్లటత యీనె సునుసె గాక. ");
INSERT INTO rei_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","కేసెనెను చెరబిత్తురుకు జెవ్వలిసిలాట చెరబిత్తురుకు జోసి. కత్తిసంగరె హతం యీవలసిలటతా సెయె కత్తిసంగరాక హతమూసి. పురువురొ ప్రజానె విసయమురె సహనం, విస్వాసము కలిగికిరి తాసె. ");
INSERT INTO rei_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","ఈనె బూమిరె తీకిరి ఇంకగుటె క్రూరమ్రుగము ఉంపురుకు అయిలాట దిగించి. గొర్రెపిల్ల కొమ్ముపనికిరి దీట కొమ్మునె సడకు అచ్చి; సడ రెక్కనె సంగరె తల్లా సప్పొపనికిరాక కొత లగిలిసి; ");
INSERT INTO rei_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","సడ సె అగరె క్రూరమ్రుగముకు తల్ల అదికారం చేస్టలల్ల తా అగరె కొరిలీసి; ఇంక మొరిజెల్ల మడ్డొ బైకిరి బొలి యీజేకిరి తల్లా సె అగరె మ్రుగముకు బూమిరె తాండె బిత్తరె జీలాలింకెల్ల బలవంతము కొరిల. ");
INSERT INTO rei_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","దీటట మ్రుగము మెగొ తీకిరి బూమికి మనమానె అగరె నియ్య ఒల్లిలపనికిరి గొప్ప అద్బుతానె కొరిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","కత్తి మడ్డొ బైనెనూ జీల యే క్రూరమ్రుగముకు విగ్రహాలు కొరివాసి బులి సడ బూమింపరె జీలాలింకు సంగరె కొయికుంట, అగరె మ్రుగము అగరె కొరితె తాకు దిల్ల అద్బుతకార్యోనె వల్లరె బూమింపరె జీలలింకు మోసము కొరిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","ఈనె సె మ్రుగమురా బొమ్మకు కొత లగిలపనికిరి, సె మ్రుగమురా బొమ్మకు నమస్కారము నా కొర్లలింకు హతము కొరిలాపనికిరి, సె దీట మ్రుగమురొ బొమ్మకు పొర్నొ దీతందుకు సడకు అదికారం దివ్వొరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","సడ నీకుంట, మనమానె కిరి తక్కువ లింకె కిర దనికునె కిర దరిద్రునె కిర స్వతంత్రునె కిర దాసునె కిర సొబ్బిలింకు తంక కైలత్తొంపరె నెత్తింపరె ముద్రపొల్ల పనికిరి సె బలవంతము కొరుకుంట అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","సె ముద్ర, బుల్నె సె మ్రుగము నా యీనెను తా నారె సంక్యయీనెను తల్లటతా తప్ప, బిక్కితె గినితె కొరితె ఇంక కాకు అదికారం నోయికుంట యీజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","బుద్దితల్లాట తా మ్రుగమురా సంక్యకు లెక్కకొరుమురు; సడ గుటె మనమార సంక్యకా; సె సంక్య అరువందల అరవై ఆరు; ఆండ్రె జ్ఞానము అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","ఈనె మీ దిగినాక, ఇత్తొ, సే గొర్రిపిల్ల సీయోను పర్వతముంపరె టారేకిరి అచ్చి. తా నామముకు తా బో నామముకు నొసల్లపారె రాసికిరి తల్ల, సొయి సారా దొస్టంపొరె సారా వేల మంది తాసంగరె కూడ అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","ఈనె విస్తారమీల జలముల ద్వనిసంగరె గొప్ప ఉరుము ద్వనిసంగరె సమానమీల గుటె సబ్దము పరలోకము తీకిరి అయిలాటకు సునించీ. మీ సునిల సె సబ్దము వీనానె వాయించిల లింకెరొ సబ్దముపనికిరి పోలికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","తంకె సింహాసనము అగరె, సే చార జీవి అగరె, బొడిలింకె అగరె గుటె నాట కీర్తన గైలీసె; బూలోకము తీకిరి గినిల సే సొయి చార దొస్టంపొరె చారవేయి మంది తప్ప యింక కేసెను సే కీర్తన సుక్కగిన్నంతె. ");
INSERT INTO rei_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","అంకె తిల్డ్రాపిల్ల సాంగత్యముకు అపవిత్రూనె నాయీలలింకె, తిల్డ్రాపిల్ల సాంగత్యముకు నాతెలిసిలాలింకె పనికిరి తైకిరి, గొర్రెపిల్ల కేటికి జోసివో సెట్టికి తాసంగరె జోసె; అంకె పురువు కోసం గొర్రె పిల్ల కోసం ప్రదమ పలము పనికిరి తొత్తె మనమానె బిత్తరె తీకిరి రక్సనపొందిలలింకె. ");
INSERT INTO rei_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","అంకతుండొ దీకిరి కే సుచ్చటకు దిగిదిలానీ; అంకె కే నిందనె నొయిలలింకె. ");
INSERT INTO rei_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","సెత్తిలె ఇంకగుటె దూతకు దిగించీ. సె బూ నివాసులుకు, బుల్నె ప్రతి జనముకు ప్రతి వంసముకు వేరు వేరు బసొనె లగిలలింకు ప్రతి ప్రజకు ప్రకటించిల పనికిరి సాస్వత సువార్త కొడిగీకిరి మెగొరె ఉడ్డిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","సెయె, తొమె పురువుకు డొరికిరి తాకు మహిమపరుచోండి; సె తీర్పు తీర్చిల గడియ ఆసి గనుక మెగొకు బూమికు సొంద్రొకు పనిదారానెకు కొరిలతాకు తాకాక ఆరాదించొండి బులి గొప్ప సొరము సంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","ఇంకగుటె దూత, బుల్నె దీట దూత తా సంగరె అయికిరి కామము ఎక్కువ సంగరె కూడిల తా దర్నిపైటికు మొద్దొకు సమస్త జనముకు పీదిల్ల యే మహా బబులోను కూలిజోసి, కూలిజోసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","ఈనె ఇంక గుటె దూత, బుల్నె తింట దూత అంకె పొచ్చడె అయికిరి గొప్ప స్వరము సంగరె యాకిరి కొయిసి. సె క్రూర మ్రుగముకు గాని తాండె బొమ్మకు గాని కేసెనె నమస్కారముకొరినె, తా చిత్తంపరెకిర అత్తొంపరెకిర సె ముద్రపొగ్గినె. ");
INSERT INTO rei_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","కిచ్చి నామిసికుండ పురువురొ ఉగ్రతపాత్రరె పొగిల పురువురొ రగ్గొబుల్ల పాత్రామొద్దొకూడ సే పూసి. పరిసుద్ద దూతానెపారె గొర్రిపిల్ల అగరెకు నియ్య గందకమూనె సంగరె తంకె బాదించిపొడువొ. ");
INSERT INTO rei_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","తంక బాదసంబందమీల దో యుగయుగములుకు ఉటుసి; సె క్రూర మ్రుగముకు గాని తాండె ప్రతిమకుగాని నమస్కారముకొరిల లింకె, తా నా గల ముద్ర కేసెనెను పొగ్గినె సెయెకూడ రత్తిదూసి బాదనెసంగరె తాసె. ");
INSERT INTO rei_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","పురువురొ ఆజ్ఞలకు యేసు గురించి నమ్మకముగా తెలిసిగించి పురువురొ ప్రజానెరె యడబట్టి ఓర్పు దీదుసి. ");
INSERT INTO rei_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","సాకిరి వుంచినె తీకిరి ప్రబువు పైటి కోసం మొరిజిల్లాలింకె దన్యూనెబులి రాసుబులి పరలోకము తీకిరి గుటె స్వరము కొయినాక సునించి. సొత్తాక; తంకె తంక ప్రయాసానె మానికిరి విస్రాంతి పొందుగునుసె కైంకిబుల్నె తంకె కొర్ల పైటినె తంకెసంగరె జోసిబులి ఆత్మ సమదానుము కొయిలీసి. ");
INSERT INTO rei_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","ఈనె మి దిగినాక, ఇత్తొ దొగలాట మెగొ దీదిల్ల. మనమారొ పోకు పోలికిరి తల్లా జొనె సె మెగొంపరె బొసికిరి అచ్చి. తా ముండొంపరె సున్న కిరీటం, అత్తరె పదును యీల కొడవలి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","సెత్తిలె ఇంకగుటె దూత దేవాలయము తీకిరి పొదురుకు అయికిరి బూమిపంట పండికిరి అచ్చి, కట్టిలా కలొ అయిసి, తో కొడవలి నొక్కిరి కట్టు బులి గొప్ప స్వరము సంగరె సె మెగొంపరె బొసికిరి తల్లలింకెసంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","మెగొంపరె బొసికిరితల్లటతా తా కొడవలి బూమింపరె పొగినాక బూమిపంట కట్టివురొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","సెత్తెలె ఇంకగుటె దూత పరలోకముతీకిరి తల్లా మందిరం తీకిరి పొదురుకు అయిసి ఆ పక్కరె గుటె పదునీల కొడవలి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","ఇంకగుటె దూత బలిపీటము తీకిరి పొదురుకు అయిల. ఆకు నియ్యంపరె అదికారం పొందిగిల్లట; యే పదునీల కొడవలిగల తాకు గొప్ప స్వరముసంగరె డక్కికిరి బూమింపరె తల్లా ద్రాక్సపొగలానె పచ్చిలబులి; పదునీల తో కొడవలి నొక్కిరి తాండె గెలిసినె కట్టుబులి కొయిల. ");
INSERT INTO rei_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","ఈనె సె దూత తా కొడవలి బూమింపరె పొక్కిరి బూమింపరె తల్ల ద్రాక్సపొగలనే కట్టికిరి, పురువురొ రగ్గొబెల్ల ద్రాక్సనె తొట్టిరె పొయిదిపేసి. ");
INSERT INTO rei_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","సె ద్రాక్సనె తొట్టి పట్నముకు పొదిరె మండివురొ జరిగిసి; దీట మీటరు ఎత్తురె తింట సొయి కిలోమీటరు దూరు గొడానె కల్లెము మట్టుకు ద్రాక్సనె తొట్టిరె తీకిరి రొగొతొ పారిసి. ");
INSERT INTO rei_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","సెతెలె ఆచర్యమైల ఇంకగుటె గొప్ప అద్బుతానె మెగొరె దిగించీ, సడ కిరబుల్నె, సత్ర తెగుల్లు అత్తరె దరిగికిరి తల్లా సత్రలింకె దూతనె, యడక చివరితల్ల తెగుల్లు; యడసంగరె పురువురొ రగ్గొ సమాప్త మీల. ");
INSERT INTO rei_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","ఈనె నియ్యసంగరె మిసికిరితల్ల స్పటికపు సొంద్రొపనికిరి గుటె మీ దిగించి. సె క్రూరమ్రుగముకు తా పలితముకు తా నాగల సంక్యకు నా లోబొడికిరి సడకు జయించిలాలింకె పురువు దిల్ల వీనానె సంగరె టారెవురొ, సె స్పటికపు సొంద్రొపారె టారెకిరి తల్లాట దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","తంకె ప్రబువా, దేవా, సర్వదికారీ, తో క్రియానె గనమిలాట, ఆచర్యమైలాట; యుగయుగమునుకు రొజా, తో బట్టొనె న్యాయము యీకిరి సత్యము యీకిరి అచ్చి; ");
INSERT INTO rei_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","ప్రబువా, తూ మాత్రము పవిత్రుమైలాట, తొత్తె నా డొరిలాతా కేసె? తో నామముకు మహిమపర్చిలతా కేసె? తో న్యాయవిదులు ప్రత్యక్సమీల యీనె జనమునె సొబ్బలింకె అయికిరి తో సన్నిదికి నమస్కారము కొరుసెబులి కొయికుంట, పురువురొ దాసుడీల మోసే కీర్తనకు గొర్రిపిల్ల కీర్తనలు గైలీసె. ");
INSERT INTO rei_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","సె తరువాత మి దిగినాక, పరిసుద్ద గుడార సంబందమీల మందిరము పరలోకమురె పిటివురొ వూసి. ");
INSERT INTO rei_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","సత్ర తెగుల్లు అత్తరె దరిగినికిరి తల్లా సె సత్ర దూతనె, నిర్మలమైల మెరిసిజెల్ల నారకొన్ననె పిందిగినికిరి, గుండెంపరె సున్నా బెల్టు బందిగినికిరి సె మందిరంతీకిరి పొదురుకు అయిసి. ");
INSERT INTO rei_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","సెత్తిలె చార జీవిండ్రె గుటె జీవి, యుగయుగమునె జీవించిల పురువురొ రగ్గొసంగరె పూరికిరితల్ల సత్ర సున్నా పాత్రలకు సె సత్రలింకె దూతనుకు దిల్లె. ");
INSERT INTO rei_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","సాకిరి పురువురొ మహిమతీకిరి తా సక్తితీకిరి అయిల దోసంగరె మందిరము పూరికిరితవ్విరొ సె సత్ర దూతానెరె తల్లా సత్ర తెగుల్లు పూర్తి యీలవరుకు మందిరముకు కేసె జెన్నారిసె. ");
INSERT INTO rei_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","ఈనె తొమె జేకిరి పురువురొ రగ్గొసంగరె పూరిల సే సత్ర పాత్రనెకు బీ ఉంపరె పొగుబులి మందిరంతీకిరి గొప్ప స్వరము సె సత్ర దూతనె సంగరె కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","సాకిరి అగరె దూత పొదురుకు అయికిరి తా పాత్రకు బూమిఉంపరె పొగినాక సె క్రూర మ్రుగమురొ ముద్రగల్లటాకు సడరొ ప్రతిమకు నమస్కారము కొర్లలింకు బాదకరమైలా, వికారమైలా కురుపు పుట్టిల. ");
INSERT INTO rei_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","దీట దూత తా పాత్రకు సొంద్రొరె పొగినాక సొంద్రొ మొరిజెల్ల మనమరొ రొగొతొ పనికిరి యీల, సడవల్లరె సొంద్రొరె తల్లా జీవ జంతువూనె మొరిజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","తింట దూత తా పాత్రకు నదినెబిత్తిరె జలదారులురె పొగినాక సడ రొగొతొ యీజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","సెత్తిలె జలములకు అదికారమీల దేవదూత యాకిరి కొయిలాట సునించి యించిని యే కలొరె జరిగిజెల్ల కలొరె తల్లా పవిత్రుడా! తు న్యాయవంతుడు. ");
INSERT INTO rei_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","సడకు పురువురొ మనమానెండ్రా రొగొతొ ప్రవక్తానెరొ రొగొతుకు తంకె కార్చిలందుకు తీర్పు తీర్చికిరి తంక రొగొతొ తంకు పీపించిపేసు సడకు తంకె అర్హులాక. ");
INSERT INTO rei_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","సడకు సాకరాక ప్రబువా, దేవా, సర్వాదికారి, తో తీర్పూనె సత్యమీకిరి న్యాయములుకిరి అచ్చిబులి బలిపీటము దీకిరి గుటె సొరము కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","చార దూత తా పాత్ర సూరిడిఉంపరె పొగినాక మనమానుకు నియ్యసంగరె పుడ్డితె సూరిడికు అదికారం దివ్విరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","యీనె మనమానె తీవ్రమైల తత్తిలాట సంగరె పుడ్డిజెల్లె, యే తెగుల్లుంపరె అదికారముసంగరె పురువురొ నామముకు దూసించికిరి గాని, తాకు మహిమ పరిచిలపనికిరి తంకె మారుమనుస్సు పొందిల లింకెనీంతె. ");
INSERT INTO rei_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","పాట దూత తా పాత్రకు సె క్రూరమ్రుగమురొ సింహాసనముంపరె పొగినాక, తా రాజ్యం వొందారొ కమ్మిపేసి; మనమానె తంకు కలిగిల బాదనెసంగరె తంక జిబ్బొనె కమిడిగిల్లె. ");
INSERT INTO rei_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","తంకు కలిగిల వేదనానెబట్టి కురుపూనె బట్టి పరలోకమురెతల్ల పురువుకు దూసించిసె గాని తంక పైటినె మానికిరి మారుమనస్సు పొందిలలింకె నీంతె. ");
INSERT INTO rei_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","సోట దూత తా పాత్రకు యూప్రటీసు బుల్ల మహోనదింపరె పొగినాక తూర్పుదీకిరి అయిల రొజానుకు బట్టొ సిద్దపొల్లపనికిరి నదిరొపని సుక్కిజెల్ల. ");
INSERT INTO rei_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","ఈనె సె రెక్కనెసంగరె తల్లా సప్పొ తుండొదీకిరి క్రూరమ్రుగము తుండొదీకిరి సొరొప్రవక్త తుండొదీకిరి కప్పానెపనికిరి తింట చెడు ఆత్మానె బయలుకు జెల్లాట దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","సడ అద్బుతానె కొరిలాపని బుత్తొనె ఆత్మనాక; సడ సర్వదికారమైల పురువురొ మహోదినొరె జరిగిల యుద్దముకు లొకొరె తల్లా రొజానుకు పోగుకొరివాసె బులి తంకుపక్కు బయలుజెల్ల ఆత్మలాక. ");
INSERT INTO rei_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","ఇత్తొ మి సొరొపనాక అయిలించి; సె సుచ్చదేరె సంచరించిలందురె మనమానె సె కొన్నానె నొయికుంట తల్లాట దిగివొకీవొ బులి సతనీకిరి తైకిరి తా కొన్న కాపాడిగిల్లాట దన్యుడు. ");
INSERT INTO rei_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","సే దూతానె రొజానెకల్ల కొడిగీకిరి హెబ్రీ బాసెరె హారమెగిద్దోను బుల్ల చోటుకు తంకు పోగు కొరిల. ");
INSERT INTO rei_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","సత్ర దూత తా పాత్రకు వాయుమండలుంపరె పొగినాక పూర్తియీజెల్లబులి కొయితల్ల గుటె గొప్పస్వరము మందిరమురెతల్ల సింహాసనము తీకిరి అయిల. ");
INSERT INTO rei_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","సెత్తిలె మెరుపూనె ద్వనినె ఉరుమునె పుట్టిల, బొట్ట బూకంపము కూడ కలిగిల. మనమానె బూమింపరె జొర్నొలదీకిరి సాట మహాబూకంపము కలిగివినీ, సెడొ బూకంపము సడ. ");
INSERT INTO rei_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","గొప్ప మహోపట్నము తింట బాగలు యీల, సొబ్బి దెసోనుడ్రె పట్నములు కూలిజెల్ల, తా అదికమైల రగ్గొకు మద్యముమైల పాత్రకు మహో బబులోనుకు దివ్వాసేబులి సడకు పురువు పారే జ్ఞాపకము కొరిసి. ");
INSERT INTO rei_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","ప్రతి ద్వీపాకండలు పొలిజేసి, పొరుతోనె నాదిదికుంట యీజేసి. ");
INSERT INTO rei_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","పాంట మనుగులు గొబ్బిరి యీల బొట్ట వడగండ్లునె మెగొదీకిరి మనమానెంపరె పొడిసె; సే వడగండ్లునెరొ మడ్డొ బడే గొప్పీట యీలందరె మనమానె సె మడ్డొనె బట్టి పురువుకు దూసుంచిలె. ");
INSERT INTO rei_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","సె సత్ర పాత్రనె దరిగినికిరి తల్లా సత్రలింకె దేవదూతండ్రె జొనె అయికిరి మో సంగరె కొతలక్కుంట యాకిరి కొయిసి. తు ఎట్టికి ఆయి, బడె నదినెంపరె బొసిలా గొప్ప నా పొందిల వేస్యకు పొగిలా సిక్స తొత్తె దిగుదూంచి. ");
INSERT INTO rei_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","బూమంపరె రొజానె సె మొట్ట సంగరె దర్నిపైటికొర్లె, బూమింపరెతల్ల మనమానె సె మొట్టసంగరె దర్నిపైటికి బిల్ల మొద్దొకు మత్తులీలె. ");
INSERT INTO rei_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","సెత్తిలె సెయె ఆత్మకు పూనిగీకిరి తల్లా మెత్తె బొనుకు కొడిగీకిరిజెన్నాక, పురువుకు దూసన నామముసంగరె పూరుకిరి, సత్ర ముండొనె దొస్టకొమ్మునెతీకిరి గొర్రాట మ్రూగముంపరె బొసికిరి తల్లా గుటె మొట్టకు దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","సె మొట్ట గొర్ర రంగు కొన్నానె పిందిగినికిరి, సున్నసంగరె రత్నము సంగరె ముత్యమునె సంగరెను అలంకరించికిరి, అసాయమైల పైటినె సంగరె సె మొట్ట కొరితల్ల దర్నిపైటికి సంబందమీల చెడుపైటినె సంగరె పూరిల గుటె సువర్న గిన్నెకు తా అత్తరె దరిగినికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","తాండె సిత్తంపరె తాండె నా యాకిరి రాసికిరి అచ్చి రాహస్య మీల అర్దం కిరబుల్నె? దర్నినుకు బుమి బిత్తరె వ్యర్దమీలటకు మా యీల మహో బబులోను. ");
INSERT INTO rei_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","యీనె సే మొట్ట పురువురొ ప్రజానెకు రొగొతొసంగరెను, యేసురొ హతసాక్సిండ్రా రొగొతొసంగరెను మత్తికిరి తవ్వురొ దిగించి. మీ సడకు దిక్కిరి బడె ఆచర్యపొడించి. ");
INSERT INTO rei_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","సె దూత మోసంగరె యాకిరికొయిసి, తూ కైంకి ఆచర్యపొల్లు? యే మొట్టగూరించి రాహస్యముమీల, సత్ర ముండొనె దొస్ట కొమ్మునె తల్లా సడకు బొయిగినికిరితల్ల క్రూరమ్రుగముకు తల్లా రాహస్యమీలట తొత్తె తెలియపరుచుంచి. ");
INSERT INTO rei_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","తు దిగిల సె మ్రూగము అచ్చి యీనె యించిని నీ; యీనె అగాద జలమురె తీకిరి ఉంపురుకు అయితందుకు నాసనముకు జేతందుకు సిద్దముయికిరి అచ్చి. బుమింపరె జీల మనమానె స్రుస్టి అగరెతీకిరి జీవగ్రందంరె కా నా రాసికిరి నీవొ తంకె, సె మ్రూగముకు దిక్కిరి ఆచర్యపొడిసె సడ అగరె తవ్వి గాని యించినీ సడ బులికిరి ఆసి. ");
INSERT INTO rei_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","ఆండెబిత్తరె అర్దం కొరిగీతె జ్ఞానము అచ్చి. సె సత్ర ముండొనె సె మొట్ట బొస్సిల సత్ర పొరుతోనె;తంకాక సత్ర రొజానె. ");
INSERT INTO rei_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","ఇంక సత్రలింకె రొజానె కేసెబుల్నె? పాంటలింకె కూలిజేసె, జొనె అచ్చి, ఆకరితా ఇంకా అయిలాని, అయిలాబెల్లె సెయె కుండె కలొ పరిపాలించుసి. ");
INSERT INTO rei_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","తల్లాట యించిని నొయిలట యీల యే క్రూరమ్రుగము సె సత్రలింకెసంగరె కూడ జొనెయీకిరితైకిరి, సెయెక అట్ట రొజా యీకిరి నాసనము యీజోసి. ");
INSERT INTO rei_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","తూ దిగిల పది కొమ్మునె దొస్ట మంది రొజానె. తంకె యడ అగరె రాజ్యము పొందిగినివినీంతె యీనె గుటె గంటరె క్రూరమ్రుగము సంగంరె కూడ రొజానెపని అదికారం పొందుగునుసె. ");
INSERT INTO rei_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","అంకె గుట్టాక అబిప్రాయం గలలింకె యీకిరి తంక బలముకు సె మ్రుగముకు అప్పగించుసె. ");
INSERT INTO rei_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","అంకె గొర్రిపిల్లసంగరె యుద్దము కొరుసె గాని, గొర్రిపిల్ల ప్రబువుకు ప్రబువు రొజానుకు రొజానీకిరి తల్లందెరె, తాసంగరెకూడ తల్లలింకె డక్కిగిల్లలింకె యీకిరి, ఏర్పర్చిలాలింకె యీకిరి, నమ్మకమీలలింకె పనికిరి తల్లందెరె, సెయె సె రొజానుకు జయించుసి. ");
INSERT INTO rei_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","యీనె సె దూత మోసంగరె యాకిరి కొయిసి. సెయె దర్ని బొసికిరితల్ల చోటు, తు దిగిల జలములు దెసోనె ప్రజనె జనసమూహమునెకు వేరు వేరు బసొనె కొతలగిలలింకె. ");
INSERT INTO rei_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","తూ సె దొస్ట కొమ్మునె తల్లా సె మ్రూగముకు దిగిసిను, తంకె సె వేస్యకు దేసించికిరి, సడకు దిక్కు నొయిలటపనికిరి సుచ్చదేరె తల్లపనికిరి కొరికిరి, తా మోసొ కైకిరి నియ్యసంగరె సడకు కిచ్చి నొయికుంట పుడ్డిపోసె. ");
INSERT INTO rei_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","పురువురొ కొతనె నెరవేరిల జాంక తంకె గుట్టాక అబిప్రాయం సంగరె తైకిరి తంక రాజ్యముకు సె మ్రూగముకు అప్పగించితందుకు తా సంకల్పము కొనసాగించిలపనికిరి పురువు తంకు బుద్ది పుట్టించుసి. ");
INSERT INTO rei_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","యీనె తూ దిగిల సెయె మొట్ట బూరొజానుకు పాలించిలట సే మహోపట్టనమాక. ");
INSERT INTO rei_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","సె తరువాత బడె అదికారముగలిగిల ఇంకగుటె దూత పరలోకముతీకిరి ఒల్లికిరి అయిలాట దిగించి. తా మహిమసంగరె బూమి ప్రకాసించిల. ");
INSERT INTO rei_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","సె గొప్ప స్వరముసంగరె దొందిరికిరి యాకిరి కొయిసి. గొప్ప బబులోను కూలిజేసి; సడ బుత్తొనుకు తొత్తె చోటు యీజెల్ల, ప్రతి చెడుఆత్మకు నివాస స్తలము యీల. చెడుకు అసహ్యము యీల ప్రతిపక్సికి గూడు యీల. ");
INSERT INTO rei_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","కిరుకుబుల్నే సమస్తమీల దెసోనె సెయె మొట్టరొ మొద్దొ పీలె. సడ బడె బూతు కామంసంగరె కూడిల సెయె మొట్టరొ దర్నిపైటికి బుల్ల మొద్దొకు పీకిరి పొడిజెల్లె, బూరొజానె సడసంగరె దర్నిపైటి కొర్లిసె, బూలొకొరె వర్తకునె సెయె మొట్టరొ సుకబోగములు వల్లరె పలియ గల తా ఈసి. ");
INSERT INTO rei_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","యీనె ఇంకగుటె స్వరము పరలోకము తీకిరి యాకిరి కొయిలాట సునిలించొ బులి మో ప్రజానె! తొమె సెయె మొట్టరొ పాపమురె పాలిబాగస్తులు నాయిండి, సెయె మొట్టరొ తెగుల్లురె కెడగుటె తొముకు పాలిబాగస్తులు నాయీకుండ సడకు సడిదీకిరి అయిండి. ");
INSERT INTO rei_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","సె మొట్టరొ పాపోనె మెగొజాంక జేసి, సె మొట్టరొ తప్పూనె పురువు జ్ఞాపకము కొరిగిచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","సెయె మొట్ట దిల్లప్రకారము సెయె మొట్టకు దేండి; సెయె మొట్టరొ పైటినె చొప్పురె సడకు రెట్టంపు కొరండి; సెయె మొట్ట మిసిల పాత్రరె సెయెమొట్టకొరుకు దీటవంతు మిసికిరి నొగొండి. ");
INSERT INTO rei_vpl VALUES ("RV18_7","096_18_7","REV","18","7","7","సెమొట్ట మి రానిపనికిరి బొసికిరి తల్లతాని! మి విదవరాలు నీ, దుక్కొ దిగిని దిగినిబులి సెమొట్టరొ మనస్సురె కొయిగిచ్చి గనుక, సడ తా మట్టుకు సె కెత్తొవొ గొప్పకొరిగినికిరి సుకబోగమునె అనుబవించివొ, సెతె తాకు దుక్కము బాదాలు కలుగుసి. ");
INSERT INTO rei_vpl VALUES ("RV18_8","096_18_8","REV","18","8","8","సడవల్లరె గుట్టె దినొరాక తా తెగుల్లు, బుల్నె మొరొనో దుక్కొ కరువు కూడ అయిల; సెమొట్టకు తీర్పుతీర్చిల పురువు యీల ప్రబువు బలిమీలట గనుక సడ నియ్యసంగరె పూర్తికిరి పుడ్డిజోసి. ");
INSERT INTO rei_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","సడ సంగరె దర్నిపైటి కొరికిరి సుకబోగానెకు అనుబవించిల బూ రొజానె సె మొట్టరొ బాద దిక్కిరి సె మొట్టరొ దహనం కొర్ల దోకు దిగిలాబెల్లె సె మొట్ట కోసం గుండె బాదిగీకుంటా కందుసె. ");
INSERT INTO rei_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","సె మొట్టరొ విసయమీకిరి రొమ్ము మరిగినికుంట కందికుంట అయ్యో, అయ్యో, డొరొపొడికిరి దూరురె టారెకిరి బబులోను మహాపట్టనమూ, బలమీలపట్టనమూ, గుట్టె గడియరాక తొత్తె తీర్పు అయిలాని బులి కొయిగునుసె. ");
INSERT INTO rei_vpl VALUES ("RV18_11","096_18_11","REV","18","11","11","లొకొరె బొంజొ బిక్కిలలింకె, సడ తంకె దిక్కిరి కందికుంట, తంక వస్తూవూనె గిల్లాలింకె నీంతె బులి దుక్కంచిలిసె. ");
INSERT INTO rei_vpl VALUES ("RV18_12","096_18_12","REV","18","12","12","తంక సరుకూనె బుల్నె ఊదారంగు కొన్నానె సున్న వెండి రత్నలు ముత్యమునె సన్ని నారకొన్నానె బుల్నె ప్రతివిదమైల దబ్బమ్రానుకు ప్రతి విదమైల దంతొనెరొ వస్తువునె, బడె విలువీల బడ్డినె ఇత్తడి యినుము చలువపొత్రొనె బడేంచసంగరె కొరిల ప్రతివిదిమీల వస్తువూనె. ");
INSERT INTO rei_vpl VALUES ("RV18_13","096_18_13","REV","18","13","13","ఈనె దాల్చినచెక్క, దూపమునె పొగిల తెల్లొ, అత్తరు, సాంబ్రాని, ద్రాక్సరసం, ఓలీవతెల్లొ, మెత్తలటపిండి, గోదుమూనె, పసువూనె గొర్రినె, రదుమూనె, గొడానె దాసునెకు, మనమాండ్రా పొర్నొనె యింక కేసె గిన్నింతె. ");
INSERT INTO rei_vpl VALUES ("RV18_14","096_18_14","REV","18","14","14","తో పొర్నొకు యిస్టమీల పొగలానె తొత్తె సడిదీకిరి బాజెల్ల, రుచి యీలటల్ల దివ్యమైలటల్ల తొత్తె నామిలికుండ నసించిజెల్ల, సడ యింక దిగిదిన్ని బులి తంకె కోసె. ");
INSERT INTO rei_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","సె పట్టనమునకు సరుకునె బిక్కిల సడవల్లరె సంపాదన కూర్చిగిల్ల బొంజొలింకె దూరికిరి టారెకిరి సెయె మొట్టకు నాజరిగిల స్రమకు దిక్కిరి డొరొసంగరె తంకె కందికుంట దుక్కించికుంట, ");
INSERT INTO rei_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","అయ్యో, అయ్యో, సన్నిట నారకొన్నానె ఊదారంగు కొన్నానె పిందిగినికిరి, సున్నాసంగరె, రత్నములుసంగరె ముత్యమునెసంగరె అలంకరించికిరి తల్లా గొప్పపట్నమా, ఎత్తె ఐస్వర్యం గుటె గంటరాక మాయమీజెల్ల బులి కొయిగునుసె. ");
INSERT INTO rei_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","ప్రతి నావికూడుకు, కేటెకైనెను ప్రయనము కొరిల ప్రతి తా, ఓడలింకె, సొంద్రొంపరె పైటికొరికిరి జీవనముకొర్ల సొబ్బిలింకె, ");
INSERT INTO rei_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","టారెకిరి సెమొట్టరొ పుడ్డితల్ల దేకు దిక్కిరి, యే గొప్పపట్నం సంగరె సమానమీల కెడ బులి కొయిగినికుంట కేకానె పొగుసె. ");
INSERT INTO rei_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","తంక ముండొంపరె దుల్లిపొగ్గీకిరి కందుకుంట, దుక్కొపొడుకుంట అయ్యో, అయ్యో, సే మహోపట్నము; తాండె బిత్తరె సొంద్రొఉంపరెతల్ల ఓడలులింకెల్ల, తాపక్కరె బూతు లవొసంగరె పలియగలట ఈసి; సడ గుటె గడియరాక పాడియీజివొ బులి కొయికుంట కేకానెపొక్కిరి దుక్కొపొల్లె. ");
INSERT INTO rei_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","పరలొకొరె, పురువురొ మనమానె, అపొస్తులు లింకె, ప్రవక్తానె లింకె సడగూరించి ఆనందముపొడొండి, కిరబుల్నె తాసంగరె తొముకు కలిగిల తీర్పుకు బదులుగా పురువు సె పట్టనముకు తీర్పు తీర్చికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","తరువాత బలమీల గుటె దూత రుబ్బురోలు పనట పొతొరొ టెక్కికిరి సొంద్రొరె పొక్కిదీకిరి యాకిరి మహాపట్నమీల బబులోను బడె బేగ పొక్కిదివ్వురొ యీల ఇంక కెబ్బుకు దిగిదిన్ని. ");
INSERT INTO rei_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","ఈనె వాయించిలలింకె, గైలాలింకె, పిల్లనగ్రోవి పుంకిలలింకె, తూతురునె పుంకిలాలింకె సబ్దము ఇంక కెబ్బుకు తోబిత్తరె సుందిన్ని. ఇంక కే సిల్పముకు కొరిల కేసెనెకు తోబిత్తరె కెత్తెమాత్రం దిగిదిన్ని. బుల్లటద్వని ఇంక కెబ్బుకు తోబిత్తరె సుందినీ. ");
INSERT INTO rei_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","తో బొంజొలింకె బూమింపరె గొప్ప ముక్యమికిరి అచ్చె; జనమునె సొబ్బిలింకె తో మాయమంత్రోనె సంగరె మోసజోసె. బొత్తిరొ హల్లొ తోబిత్తరె ఇంకకెబ్బుకు ప్రకాసించిని, బ్యా బొర్రొరొ స్వరము బ్యా కొనియపిల్ల స్వరముకూడ తోబిత్తరె ఇంక కెబ్బుకు సుందిన్ని బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","ఈనె ప్రవక్తానెరొ, పురువురొ ప్రజానె, బూమింపరె మొరిజెల్లసొబ్బిలింట రొగొతొనె సే పట్నమురె దిగిదిసి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","సే తరువాత బడెజనుమునె సబ్దము బిల్లట గుటె గొప్పస్వరము సంగరె పరలొకొముతీకిరి యాకిరి కొయిలాట సునించి ప్రబువుకు స్తుంచిచో, రక్సనమహిమ ప్రబావములు అం పురువుకాక చెల్లుసి; ");
INSERT INTO rei_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","తా తీర్పునె సత్యమునె న్యాయమీకిరి అచ్చి; తా దర్నిపైటిసంగరె బూలొకొకు చెరిపిల గొప్ప దర్నికి సే తీర్పు తీర్చికిరి తా దాసునె రొగొతొ వల్లరె సడకు బదులుగా సిక్స కొరిసె; ");
INSERT INTO rei_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","ఇంక దీట సారి ప్రబువుకు స్తుతించొ బులి కొయిసె. సె పట్నపు దో యుగయుగమునె ఉంపరుకు ఉటిలిసి. ");
INSERT INTO rei_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","సెత్తిలె సె ఇరువది నాలుగురు బొడిలింకెను చార జీవీనెకు సాగిలపొడికిరి ఆమెను, ప్రబువుకు స్తుతిసించు బులి కొయికుంట సింహాసనముంపరె బొస్సికిరితల్ల పురువుకు నమస్కారము కొర్లె. ");
INSERT INTO rei_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","ఇంక అం పురువురొ దాసులింకె, తాకు డొరొపొడిలాలింకె, బీదలింకె కిర గొప్పలింకె కిర తొమల్లా పురువుకు స్తుతించోండి బులి కొయితల్ల గుటె స్వరము సింహాసనముతీకిరి అయిసి. ");
INSERT INTO rei_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","సెత్తిలె గొప్ప జనసముహమురొ సబ్దముకూడ, విస్తరామీల జలమునె సబ్దము, బలమీల ఉరుమునె సబ్దముకు పోలికిరి తల్లా గుటె స్వరము సర్వదికారము ప్రబువురొ యీల అం పురువు ఏలిలీసి .తాకు స్తుతించొండి ");
INSERT INTO rei_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","గొర్రిపిల్ల బ్యా సంతోసం సమయము అయిసి, తా నైపో తా మట్టుకు సె సిద్దపొడికిరి అచ్చి; ఈనె అమ్మె సంతోసము పొడికిరి ఉత్సహించికిరి తాకు మహిమ పరిచిమా బులి కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","ఈనె సెయె మొట్ట పిందిగినువురొ మెరిసిల సొచ్చమీల సన్నపు నారకొన్ననె సెయె మొట్టకు దివ్వురొయీసి; సడ పురువురొ ప్రజానెరొ నీతిక్రియనె. ");
INSERT INTO rei_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","ఈనె సెయె మోసంగరె యాకిరి కొయిసి, గొర్రిపిల్ల బ్యా కద్దికు డక్కిలలింకె దన్యూనె బులి రాసు; ఈనె యే కొతనె పురువురొ యదార్తమైలా కొతనెబులి మోసంగరె కొయిల. ");
INSERT INTO rei_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","సడకు మి తాకు నమస్కారము కొరితందుకు తా పాదమూనె అగరె సాగిలిపొన్నకా సెయె నా బిల్ల, మి తోసంగరె, యేసు గురించి సాక్సము కో తొ అన్నబయినె సంగరె సమానుత బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","ఇంక పరలోకము పిటికిరి తల్లాట దిగించి. సెత్తిలె సడ, దొగలాట గొడగుటె దిగిదిల్ల. సడంపరె బొస్సికిరితల్లట నమ్మకమీలటతా సత్యమీలటతా బిల్ల నామముగలట, తా నీతిబట్టి విమర్సకొరుకుంట, యుద్దము కొరుకుంట అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","తా అంకీనె నియ్యపనట, తా సిరస్సుంపరె కెత్తొ కిరీటమునె అచ్చె. రాసికిరి తల్లా గుటె నా తాకు అచ్చి, సడ తాకాక గాని ఇంక కాకు కూడ తెలిసినీ. ");
INSERT INTO rei_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","రొగొతొరె బుడ్డుకిరి తల్లా కొన్నా సెయె పిందిగినికిరి అచ్చి. ఈనె పురువురొ వాక్యము బిల్ల నామము తాకు నొక్కిరిఅచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","పరలోకమురె తల్లా సేనానె సుబ్రమీల దొగలనారకొన్నానె పిందిగినికిరి దొగలాట గొడానె ఉటికిరి తాసంగరె జేకుంట అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","జనములుకు మరితె తా తుండొతీకిరి పదునీల కడ్గము బయలు దేరిలిసి. సెయె ఇనుము సంగరె తంకు ఏలుసి; సెయ్యకా సర్వదికారిబిల్ల పురువురొ ఎక్కువ రగ్గొ బిల్ల మొద్దొబిల్ల బుట్టి తొక్కుసి. ");
INSERT INTO rei_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","రొజానుకు రొజా ప్రబువూనుకు ప్రబువు బిల్ల నామము తా కొన్నంపరె తొడంపరె రాసికిరిఅచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","ఈనె గుటె దూత సూర్యబింబముసంగరె టారేకిరి తల్లాట సెయె గొప్పసబ్దము సంగరె కేకానె పొక్కిరి మెగొరె ఉడ్డితల్ల సమస్త పక్సినె పురువురొ గొప్పవిందుకు అయిండి. ");
INSERT INTO rei_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","రొజానె మోసోనె సహస్రాదిపతిండ్రొ మోసోనె బలమైలలింకెరొ మోసోనె గొడండ్రొ మోసోనె సడంపరె బొసిలాలింకెరొ మోసోకు, స్వతంత్రుమైకిరి కైమండి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","ఈనె సె గొడంపరె బొస్సిలటతాసంగరె తా సేనా సంగరె యుద్దము కొరితె సె క్రూరమ్రుగముకు బూ రొజానుకు తంక సేనానెకు కూడికిరితన్నుగా దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","సెత్తిలె సె మ్రుగము, సడ అగరె సూచక క్రియానె కొరికిరి తా ముద్రకు పొగ్గిలలింకు సే బొమ్మకు నమస్కారించిలింకు మోసపరిచిల సె సొరొప్రవక్తకు, మిలిజేకిరి యే దీలింకె గందకము సంగరె మండికిరి తల్లా నియ సరుసురె పొర్నొసంగరాక పొక్కిదివ్వురొయీసి. ");
INSERT INTO rei_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","ఆకరి తా గొడంపరె బొస్సికిరి తల్లాటరొ తుండొదీకిరి అయిల కడ్గముసంగరె వదించిబొడిలె; తంక మోసోకూడ పక్సినెల్ల పెట్టొపుల్లగా కైసె. ");
INSERT INTO rei_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","ఈనె బొట్ట గొలుసూనె అత్తరె దరిగినికిరి అగాదమురొ తాలము గల గుటె దేవదూత పరలోకముతీకిరి అయిలాట దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","సె అగరెతల్ల సప్పొకు, బుల్నె అపవాదికు సాతానుకు బుల్ల సె రెక్కనెసంగరె తల్లా సప్పొదరిగినికిరి వెయ్యిబొచ్చొరొనె తాకు బందిచికిరి అగాదమురె పొక్కిదిసి. ");
INSERT INTO rei_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","సె వెయ్యి బొచ్చొరోనె యీలజాంక ఇంక మనమానుకు నామోసముకొరుకుంట అగాదము బుజ్జికిరి సడకు ముద్రపొగిలె; సడతరువాత సెయె కుండెకలొ సడిదీవ్వొరొ యీల. ");
INSERT INTO rei_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","సాకరాక సింహాసనమునె దిగించి; సడంపరె బొస్సికిరి తల్లలింకు విమర్సకొరితె అదికారం దివ్వొరొయీల. యేసుకోసం తంకె కొయిల సాక్సముకోసం, పురువురొ వాక్యము ప్రకటించిలందుకు ముండొ అనిపించిగిల్లా బక్తిగలలింకెరొ ఆత్మానె దిగించి. తంకె క్రూర మ్రుగముకు గాని, తా బొమ్మకు గాని మొక్కివినీంతె. తంక చిత్తంపరె గాని అత్తొంపరె గాని ముద్ర నాపొగ్గిల్లాలింకె, తంకె ఉంచినె సజీవూలుయీకిరి క్రీస్తుసంగరె మిసికిరి వెయ్యిబొచ్చొనె పరిపాలించిసె. ");
INSERT INTO rei_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","సె వెయ్యిబొచ్చొరొనె యీలజాంక చివరి మొడనె జీలానీ; యడక అగరె పునరుత్దానము. ");
INSERT INTO rei_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","యే అగరె పునరుత్దానమురె పాలిగిల్లలింకె దన్యూనె బులి పరిసుద్దలీకిరి తాసె. యాలింకెంపరె దీటో మొర్నొకు అదికారమునీ; అంకె పురువుకు క్రీస్తుకు యాజకూనెకిరి క్రీస్తుసంగరె కూడ వెయ్యి బొచ్చొరోనె రాజ్యము పాలించుసె. ");
INSERT INTO rei_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","వెయ్యి బొచ్చొరోనె యీల తరువాత సాతాను సెయెతల్ల చెరతీకిరి సడిదివ్వొరొయీల. ");
INSERT INTO rei_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","బూమి చార మూలండ్రేతల్ల మనమానుకు, లెక్కకుసొంద్రొర బల్లిపనక తల్లా గోగు మాగోగు బుల్లలింకు మోసముకొరికిరి తంకు యుద్దముకు పోగుకొరితికి తంకె బయలుదేరిలె. ");
INSERT INTO rei_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","తంకె బూమిల్ల చెదిరికిరి అచ్చె, పురువురొ ప్రజానెరొ గొరోనెకు ప్రియమీల పట్టముకు ముట్టడికొర్నకా పరలొకొముతీకిరి నియ ఒల్లికిరి తంకు పుడ్డిపేల. ");
INSERT INTO rei_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","తంకు మోసముకొర్ల అపవాది నియ్య గందకమూనె బుల్ల గుండమురె పొక్కిదివ్వొరొ యీల, సెట్టె సె క్రూరమ్రుగముకు సొరొప్రవక్తబుల్లలింకె అచ్చె; తంకె యుగయుగములుతీకిరి రత్తిదూసి బాదపొడుసె. ");
INSERT INTO rei_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","ఈనె దొగలయీలాట మహా సింహాసనముకు సడంపరె బొస్సికిరి తల్లా జొనుకు దిగించి; బూమి మెగొనె తా అగరెదీకిరి పొలిజెల్ల; సడకు తల్లా చోటు దిగిదిల్లనీ. ");
INSERT INTO rei_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","ఈనె గొప్పలింకె కిర బీదలింకె కిర మొరిజెల్లలింకెల్ల సె సింహాసనము అగరె టారేకిరి తల్లాట దిగించి. సెత్తిలె గ్రందమునె పిటిలట దిగించి; ఈనె జీవగ్రందము ఇంగుటె గ్రందము పిటివురొవూసి; సె గ్రందంరె రాసికిరితల్లా సడనె గురించి తంక క్రియనెవల్ల మొరజిలలింకె తీర్పు పొందిలె. ");
INSERT INTO rei_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","సొంద్రొ తా బిత్తిరె తల్లా మొడనె అప్పగించిల; మోడనుకు పాతాలలొకొకు తాండె వసమురె తల్లా మొడనె అప్పగించిల; తంకెబిత్తరె ప్రతి మనమా తా పైటినె వల్లరె తీర్పుపొందుసె. ");
INSERT INTO rei_vpl VALUES ("RV20_14","096_20_14","REV","20","14","14","మొర్నొకు మొడనె లొకొకు నియగుండమురె పొక్కిదివ్వురొ యీసి; యే నియగుండమాక దీట మొరొనొ. ");
INSERT INTO rei_vpl VALUES ("RV20_15","096_20_15","REV","20","15","15","కా నాయీనెనెను జీవగ్రందమురె రాసికిరి నా తల్లపనికిరి తన్నె సె నియ గుండమురె పొక్కిదివ్వొరొ వూసి. ");
INSERT INTO rei_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","సాకిరి మీ నొ మెగొకు నొ బూమికి దిగించి, అగరె మెగొకు, అగరె బూమి గతించిజోసి. సొంద్రొ బుల్లట ఇంకా నీ. ");
INSERT INTO rei_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","ఈనె మీ నోటయీల యెరూసలేము బుల్ల సే పరిసుద్ద పట్నము తా గొయిత కోసం అలంకరించికిరితల్ల కొనియపిల్లపనికిరి సిద్దపొడికిరి పరలొకొరె తల్లా పురువుతీకిరి ఒల్లికిరి అయిలాట దిగించి. ");
INSERT INTO rei_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","సెత్తిలె ఇత్తొ పురువురొ నివాసము మనమానె సంగరంకా అచ్చి, సే తంకెసంగరె మిసికిరి తాసి. తంకె తా ప్రజలీకిరి తాసె, పురువు తంక పురువు యీకిరి తంకు తోడు యీకిరి తాసి. ");
INSERT INTO rei_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","ఈనె తంక అంకీనెరొ పని అల్లా పుంచిపోసి, మొర్నొ ఇంక తన్ని, దుక్కొ యీనెను, కందివురొ యీనెను, కిరయీనెను ఇంక తన్ని, అగరె సంగతీనె గతించిజోసిబులి సింహాసనముతీకిరి అయిల గొప్ప స్వరము కొయిలాట సునించి. ");
INSERT INTO rei_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","సెత్తిలె సింహాసనముంపరె బొసికిరి తల్లాట ఇత్తొ సొబ్బికుడ నోట యీలపనికిరి కొర్లించి బులి కొయిసి; ఈనె యే కొతనె నమ్మకమీకిరి సొత్తాక యీకిరి అచ్చి గనుక రాసుబులి మోసంగరె కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","ఈనె సెయె మోసంగరె యాకిరి కొయిసి సమస్తమీలట; మియ్యక అల్పాయు ఓమెగయు, బుల్నె అగుంతతీకిరి అంతము యీకిరి తల్లటతా; గొలారిలాలింకు జీవజలమురొ బుగ్గతీకిరి జలముకు మీ సుచ్చరాక అనుగ్రహించుంచి. ");
INSERT INTO rei_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","జయించిలాటతా యడకు సొంతము కొరుగునిసి; మీ తంకు పురువు యీకిరి తాంచి తంకె మెత్తె పోనె యీకిరి తాసె. ");
INSERT INTO rei_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","పిరికిలింకె, అవిస్వాసములింకె, అసహ్యులుకు, మనమానుకు పొర్నొకడిలలింకు, దర్నిపైటినెకొర్లిలింకు, మంత్రించిలింకు, బొమ్మలకు పూజించిలింకు, సొరొకొతనె లగిలలింకుల్ల నియగ్రందముసంగరె పుడ్డిల గుండమురె పొగువురొ వూసి; యడ దీట మోరొనొ. ");
INSERT INTO rei_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","సాకిరి సే చివరి సత్ర తెగుల్లుసంగరె పూరిల సత్ర పాత్రనుకు దరిగినికిరి తల్లా సత్రలింకె దేవదూతనె జొనె అయికిరి ఏ పక్కు ఆయి; కొనియపిల్లకు, బుల్నె గొర్రిపిల్లరొ నైపొకు తొత్తె దిగిదుంచి బులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","ఆత్మసంగరె పూరికిరితల్ల మెత్తె ఎత్తైలా గొప్ప పొరుతొంపరెకు దంజేకిరి, యెరూసలేము బిల్ల పరిసుద్ద పట్టనము పురువురొ మహిమగలట పరలొకొరె తల్లా పురువు తీకిరి ఒల్లికిరి అయిలాట మెత్తె దిగిదీసె. ");
INSERT INTO rei_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","యెరూసలేముపారె హల్లొ దగదగ మెరిసిల సూరుడురొ కాంతి పనాట అమూల్యమైలా రత్నముకు పోలికిరిఅచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_12","096_21_12","REV","21","12","12","సే గాకు ఎత్తై బొట్ట గోడ, పండ్రెండు దోరమునె అచ్చి;గుటె, గుటె దోరముకు గుటె, గుటె దేవదూతనె అచ్చె. ఇస్రాయేలీయుల పండ్రెండు గోత్రమూనె నామమూనె సే దోరానెంపరె రాసికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_13","096_21_13","REV","21","13","13","తూర్పు ఆడుకు తింట గుమ్మానె, ఉత్తరము ఆడుకు తింట గుమ్మానె, దక్సినం ఆడుకు తింట గుమ్మానె, పచ్చిమం ఆడుకు తింట గుమ్మానె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","సే గారొ గోడ పండ్రెండు పునాదులు గల్లాట, సే పునాదీనె ఉంపరె గొర్రిపిల్లరొ పండ్రెండు అపొస్తులురొ పండ్రెండు నానె దీదిల్లిసి. ");
INSERT INTO rei_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","సే పట్నముకు తాండ్రె దోరమునె గోడకు నప్పితె మోసంగరె కొతలగిలాట తాపక్కరె సున్నాకొలత బడ్డి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","సె పట్నము చార పక్క సమానంగా అచ్చి, తాండ్రె డెంగ ఎడల్పు సంగరె సమానము, సెయె సె కొలబడ్డిసంగరె పట్నముకు నప్పినాక తాండె నప్పిలాకొలత దీట వెయ్యింపరె సారా సోయి అచ్చి; తాండె డెంగ ఎత్తుకు వెడల్పులు సమానముకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","ఇంక సె గోడకు నప్పినాక సడ మనమరొ కొలత చొప్పురె సొయి చార దొస్టంపరె చార మూరలీకిరి అచ్చి; సె కొలత దూత కొలతాక. ");
INSERT INTO rei_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","సె పట్నము గోడ సూరిడురొ కాంతినె సంగరె తల్లా పొత్తొరొ సంగరె బందికిరి అచ్చి; పట్నము స్వచ్చమీల స్పటికముసంగరె సమానమీల సుద్దసువర్నమీలపనికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","సె పట్టనము గోడ పునాదీనె ఆమూల్యమైల వేరు వేరు రకానె రత్నమునె సంగరె అలంకరించికిరి అచ్చి, అగరె పునాది సూరిడురొ కాంతియీల పొత్తొరొ, దీటట నీలము, తింటట యమునా పొతొరొ, చారట పచ్చట. ");
INSERT INTO rei_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","పాంటోట వైడూర్యము, సోటట కెంపు, సత్రట సువర్నరత్నము, అట్టట గోమేదికము, నోటట పుస్పరాగము, దొస్ట సువర్నలసునీయము, పదకొండుట పద్మరాగము, పండ్రెండుట సుగందకము. ");
INSERT INTO rei_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","సడరొ పన్నెండు దోరానె పన్నెండు ముత్యమునె; గుటె, గుటె దోరము గుటె, గుటె ముత్యమునెసంగరె బందికిరి అచ్చి. పట్నమురొ రొజసై స్వచ్చమీల సున్నకు స్వచ్చమీల స్పటికముకు పోలికిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","తాండ్రె కే దేవాలయం మెత్తె దీదివి నీ. గొప్ప అదికారి యీల పురువు యీల ప్రబువుకు గొర్రిపిల్లరొ సడకు దేవాలయము యీకిరి అచ్చె. ");
INSERT INTO rei_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","సే పట్నమురె ప్రకాసించితె సూరిడు యీనెను చంద్రుడు యీనెను సడకు అక్కర నీ; పురువురొ మహిమాక తాండ్రె ప్రకాసించిలీసి, గొర్రిపిల్లాక సడకు బొత్తి. ");
INSERT INTO rei_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","జనమునె సడరొ హల్లొరె చలుసె, బూ రొజానె తంక సంపద తాండె బిత్తురుకు కొడిగీకిరి ఆసె. ");
INSERT INTO rei_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","సెట్టె రత్తినొయిలందరె సడరొ దోరమునె దూసిబెల్లె కెత్తెమాత్రం బుజ్జికిరి తన్ని. ");
INSERT INTO rei_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","దెసోనె ప్రజనె మహిమకు గనతకు తాండ్రెబిత్తురుకు కొడిగినికిరి ఆసె. ");
INSERT INTO rei_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","గొర్రిపిల్లరొ జీవగ్రందమురె రాసికిరి తల్లలింకాక తాండె బిత్తురుకు జోసె. ఈనె వ్యర్దమైల కెడైనెకీ, అసహ్యమైలాటకు సొరొకొతైలాట జరిగించిలాటతా యీనెను సడరొ బిత్తురుకు జెవ్వొరొ యీని. ");
INSERT INTO rei_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","ఈనె స్పటికముపనికిరి మెరిసిల జీవజలమునె నది పురువురొ గొర్రిపిల్లరొ సింహాసనముతీకిరి, సె నది బయలుదేరికి, సె దూత మెత్తె దిగిదీసి. ");
INSERT INTO rei_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","సె పట్నము సైయి మొజిరె ప్రవహించిలాట దిగిదీసి. సె నదిరొ ఏపొక సేపొక జీవగొచ్చొ తవ్వి; సడ మసొ మసొకు పలించికుంట పన్నెండు పచ్చానె పచ్చుసి. సె గొచ్చొరొ ఆకూనె మనమానుకు బొలికొరితందుకు వినియోగించుసె. ");
INSERT INTO rei_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","ఇంక సాకరాక సాపగ్రస్తుమైల కెడగుటెకూడ తాండ్రె తన్ని, పురువురొ గొర్రిపిల్లరొ సింహాసనము తాండ్రె తాసి. ");
INSERT INTO rei_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","తా దాసునె తాకు సేవించుకుంట తా మూ దిక్కుకుంట తాసె; తా నామము తంక చిత్తనెంపరె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","రత్తి ఇంక కెబ్బుకు తన్ని; బొత్తిహల్లొయీనెను సూరిడురొహల్లొ యీనెను తంకు అక్కర నీ; పురువు యీల ప్రబువాక తంకెంపరె ప్రకసించుసి, తంకె యుగయుగమునె దెసొ పరిపాలించుసె. ");
INSERT INTO rei_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","ఈనె సే దూత యాకిరి మోసంగరె కొయిసి, యే కొతనె నమ్మకముమీకిరి సత్యముమికిరి అచ్చి; ప్రవక్తానె ఆత్మానెకు పురువు యీల ప్రబువు, బేగా జరిగిలాటకు సడకు తా దాసునుకు దిగిదీతె తా దూతకు పొడిదీసి. ");
INSERT INTO rei_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","ఇత్తొ మి బేగా అయిలించి, యే గ్రందమురె ప్రవచన వాక్యమునుకు తెలిసిగిల్లట దన్యుడు. ");
INSERT INTO rei_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","యోహాను బుల్లట మి యే సంగీతీనె సునిలాట దిగిలాట; మీ సునికిరి దిగిలాపరె సడకు మెత్తె దిగిదిల్ల దూత పాదాలునె అగరె నమస్కారము కొరితె సాగిలిపొడించి. ");
INSERT INTO rei_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","సెయ్యె నాబులి, మీ తోసంగరె, ప్రవక్తానె యీలలింకె తో అన్నబయినె, యే గ్రందమురెతల్ల వాక్యమునె తెలిసిగిల్లలింకెసంగరె సహదాసుడు; పురువుకు నమస్కారము కొరుబులి కొయిసి. ");
INSERT INTO rei_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","ఈనె సెయె మో సంగరె యాకిరి కొయిసి యే గ్రందమురెతల్ల ప్రవచనవాక్యమునెకు ముద్ర పొగితనా; యీనె కలొ సమిపించికిరి అచ్చి; ");
INSERT INTO rei_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","అన్యాయముకొర్లాట ఇంక అన్యాయము కొరుమురొ, అపవిత్రుడు యీలాట ఇంక అపవిత్రుడు పనికిరాక తమ్మురొ, నీతి మంతుడు ఇంక నీతిమంతుడు పనికిరాక తమ్మురొ. పరిసుద్దలింకు ఇంక పరిసుద్దలుపనికిరి తమ్మురొ. ");
INSERT INTO rei_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","ఇత్తొ బేగా అయిలించి, తా, తా పైటిచొప్పురె ప్రతిమనమాకు దీతె మీ సిద్దము కొర్ల బహుమతినె మో పారె అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","మీ అల్పాయు ఓమెగయు, అగరెతా ఆకరితా, అగుంతా అంతమైకిరి అచ్చి. ");
INSERT INTO rei_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","జీవ గొచ్చొకు హక్కుగలలింకె యీకిరి, దోరములుదీకిరి సె పట్నము బిత్తురుకు ప్రవెసించిలపనికిరి తంక కొన్నానెకు కచ్చిగిల్లలింకె దన్యూనె. ");
INSERT INTO rei_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","కుక్కురొనుకు, మంత్రించిలింకు, దర్నిపైటికొర్లలింకు, మనమానుకు పొర్నొకల్లలింకు, బొమ్మనుకు పూజించిలలింకె, సొరొరాటకు ప్రేమింకిరి జరిగించిల ప్రతిమనమ పొదెరె తాసె. ");
INSERT INTO rei_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","సంగమునె కోసం యే సంగతీనెగూరించి తొముకు సాక్సం దీతెకు యేసు బిల్ల మీ మో దూతకు పొడిదీకిరి ఆంచి. మీ దావీదు వంసముతీకిరి సె వంసము సొబ్బిలింకు, హల్లొయీల వేకువ చుక్కయీకిరి ఆంచి. ");
INSERT INTO rei_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","ఆత్మ ఇంక బ్యాకొనియ అయిబులి కొయిలీసె; సునిలటతాకూడ అయిబులి కొయివాసె; గొలారిలలింకు అయిమురొ; యీవలసిటకు జీవజలము సుచ్చరాక కడిగిమ్మురు. ");
INSERT INTO rei_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","యే గ్రందమురెతల్ల ప్రవచనవాక్యములుకు సునిల ప్రతితాకు మి ఎచ్చరించలాట కిరబుల్నె కేసైనా అడసంగరె ఇంక కిరయీనెను మిసినె, యే గ్రందంరె రాసికిరి తల్లా తెగుల్లు పురువు తాకు కలిగిదివొ; ");
INSERT INTO rei_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","కేసైనా యే ప్రవచన గ్రందమురెతల్ల వాక్యమురె కిరయీనెను కడిపెనె, పురువు యే గ్రందమురె రాసికిరి తల్లా జీవగొచ్చొండ్రె పొగలానె కైపించినీ సెయ్యె పరిసుద్దపట్నముకు తాకు అయిపించినీ. ");
INSERT INTO rei_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","యే సంగీతీనె గురించి సాక్సం దిల్లటతా వై, బేగా అయిలించి బులి కొయిలీసి, ఆమేను; ప్రబూవీల యేసు, అయి. ");
INSERT INTO rei_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","ప్రబుయీల యేసురొ క్రుప పురువురొ ప్రజలల్లకు తోడుయీకిరి తమ్మాసి ఆమేను.");
ALTER TABLE rei_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
