﻿USE sofia;
DROP TABLE IF EXISTS sofia.ram_vpl;
CREATE TABLE ram_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ram_vpl WRITE;
INSERT INTO ram_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pê nee jũm Pahpãm ton nare, ne nee jũ caxuw amji ton nare, ne ramã pjê ton xwỳjrea na ihkrĩ rohnỳtti mã. Pê mam Pahpãm côjkwa me pjê me, ampo cunea to. Ne nee pê ampo to, ampo itajê ton nare. ");
INSERT INTO ram_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pê pjê ata kam ampo hamreare, ne caprỳ, ne kam awcapàtkuti, ne cô me pjê cormã ajcacwa tu. Pê Pahpãm Carõ Pejti ata, cô me pjê picacwỳr ata cwỳrpê, curia ajco apu ipa. ");
INSERT INTO ram_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mã Pahpãm te hũjarẽn to: — Imã hàhcujro xà nõ na prãm! — hajỹr me ajkaam, mã amcro pyrentu. ");
INSERT INTO ram_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mã Pahpãm te amcro ita pupun, mã cumã impeaj to impej, mã cute amcro me caxwa to ipicapôn. ");
INSERT INTO ram_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ne cute amcro mã haprỳ to: “Apẽ” hajỹr, ne awcapàtkô mã haprỳ to: “Caxwa” hajỹr. Hõhõ, amcro cakônĩ ita na, pê hapên xà itajê kwỳ ton to hane. ");
INSERT INTO ram_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ne amcro pijakrut jõ iràrà na, pê Pahpãm cô mã harkwa to: — Amji to ajcapô, ne kỳj rũm côjkwa wỳr akwỳ api ne ahtwỳ, ne harã mã pjê kam akwỳ ahtwỳ — hane. ");
INSERT INTO ram_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mã cô te amji to ipicapôn pyrentu, ne kỳj pê ita jàhhuc, ne harã mã ita jàhhuc. ");
INSERT INTO ram_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mã Pahpãm te kỳj rũm ita mã haprỳ to: “Côjkwa” hajỹr. Hõhõ, amcro pijakrut kam pê hàpên xà itajê kwỳ ton to hane. ");
INSERT INTO ram_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ne ahna amcro incrê jõ iràrà na, pê Pahpãm pjê kam cô me amcrà mã harkwa to: — Me amji to ajcapô, ne ita wỳr amcrà, ne ita wỳr cô — hane me ajkaam, mã cute amji to ipicapôn. ");
INSERT INTO ram_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mã cute amcrà mã haprỳ to: “Pjê” hajỹr. Ne cute cô te cuprõn ata mã haprỳ to: “Côxwa” hajỹr. Ne cute hõmpun, mã cumã impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Pê Pahpãm pjê mã harkwa to: — Amji kam pĩhhy me, pĩhhô me, ahpỹanre na ajpẽn caxuw me hàprà hy cunea to — hane. ");
INSERT INTO ram_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Mã cute amji ton pyrentu, ne pjê kam apu hapôj. Ne ahpỹanre na ajpẽn caxuw kam ihhy, ne kam hô ne hapôj. Mã cute hõmpun, mã cumã impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Hõ, ahna amcro incrê itajê kam, pê hàpên xà itajê kwỳ ton to hane. ");
INSERT INTO ram_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ne ahna amcro te cwat jõ iràrà na, pê Pahpãm côjkwa mã harkwa to: — Amji kam gàhcujro xà nõ to, mãr quê pjê cujro, ne caxwa me amcro to ajcapô, ne amcro me, putwrỳ jõ amcro me, caku jõ putwrỳ cahyt — hane. Mã cute amji ton pyrentu ne ajêt. ");
INSERT INTO ram_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ne cute hàhcujro xà catia to ipijakrut ne ton. Pê amcro to ihhimpej catê ata ri ampeaj kam cati, ne caxwa to ihhimpej catê ata ri hapyre mã incrire. Ne hanea ne cute caxêre ton. ");
INSERT INTO ram_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Ne ma côjkwa kam apu haxôr, cute pjê cujro, ne caxwa me apẽ to ihhimpej, ne amcro me awcapàtkô to ipicapôn prãmte. Mã cute hõmpun, mã cumã impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hõ, ahna amcro te cwat itajê kam, pê hàpên xà itajê kwỳ ton to hane. ");
INSERT INTO ram_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ne ahna amcro te xĩc jõ iràrà na, pê Pahpãm côxwa me côjkwa mã harkwa to: — Hã, ate amji kam ampo to me apijapar xà atajê to amji kam me hipu tu ne, côjkwa kam pryjara tor xà me, cô kam ampo cunea prar xà atajê mea mã — hane. ");
INSERT INTO ram_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ne Pahpãm te cô kam ampo te amji to ipijapar xà atajê cunea ton, côxwa kam ampo catia atajê mea mã, ahpỹanre na ajpẽn caxuw, mã hàhtôa to hàhtô. Ne hanea ne, ajpẽn caxuw pryjara cunea ton, ne hõmpun, mã cumã impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mã cute ihcunea caxuw carôt jõr ne cumã harkwa to: — Me akra to me hàhtôa, ne ma cô kam me apicamẽn to me mõ, ne me cô to hipu tu ne. Ne kỳj pê cuwênre tore to hàhtôa ne, ne ma me apicamẽn to me mõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Hõ, ahna amcro te xĩc itajê kam, pê hàpên xà itajê kwỳ to hane. ");
INSERT INTO ram_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ne ahna amcro te xêj jõ iràrà na, pê Pahpãm pjê mã harkwa to: — Hã, pjê, amji kam ampo cunea capônỹre te amji to ipijapar xà atajê to, ne pjê na ampo apu ipa atajê to, ne ampo pry jàprêhti atajê to, ne ahpỹanre na ajpẽn caxuw — hane. Mã cute amji ton pyrentu. ");
INSERT INTO ram_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ne Pahpãm te ampo pryre jàprêhti itajê ton, ne ampo capônỹre itajê ton, ne pjê kam ampo apu ipa itajê cunea ton, ne ahpỹanre na ajpẽn caxuw. Ne cute hõmpun, mã cumã impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Jirô pê mã ri Pahpãm te ajpẽn mã: — Ita caxuw cu ha amji kôat me hũmre nõ to, quê ha cupê me pahpyràac, ne ihtỳj amji kampa. Ne quê ha hanea ne côxwa kam tep me, côjkwa kam pryjara me, pjê kam ampo capônỹre atajê me, pryre jàprêhti atajê me, pjê kam ampo apu ipa itajê jamãr to ipa, ne me to ihhimpej to ipa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ne cute amji kôat jũm xũmre ata ton, ne cahãj ita ton. ");
INSERT INTO ram_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ne cute me cumã harkwa to: — Me akra to me hàhtôa to hàhtô to me mõ, ne ma me apicamẽn to me mõ, ne pjê to me hipu to me mõ, ne amji mã me hũtà ne me to ahimpej to me mõ. Ne côxwa kam tep to me ahimpej, ne côjkwa kam cuwênre to me ahimpej, ne ampo cunea pjê kam apu ipa atajê to me ahimpej. ");
INSERT INTO ram_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","— Ne ate me gõ to, me gàpàn xà caxuw, ite me amã ihhy cunea me, pĩxô cunea ton, ate mehkur xà caxuw. ");
INSERT INTO ram_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ne pryre me, pryjara me, pjê kam ampo ipa atajê me, por ampo cunea amji cajpẽ ne incaca atajê mã, ite ahtu me ahtetet cunea ton, cute ihkur xà caxuw — hajỹr. Hõ, pê ampo itajê cunea ton to hane. ");
INSERT INTO ram_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ne cute ihcunea pupun, mã cumã impeaj to impej. Hõ, ahna amcro te xêj atajê kam, pê hàpên xà atajê kwỳ ton to hane. ");
INSERT INTO ram_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Pê Pahpãm côjkwa me, pjê me, côxwa jipêj, ne kam ampo te amji to ipijapar xà atajê cunea to. ");
INSERT INTO ram_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pahpãm te amcro te xêj atajêa kam, cute hàpên xà itajê cunea jipêj. Cwỳrjapê ri cute amcro te xet ton ita kam ri ihkôt xà, na ri nee kam hàpên xà nare. ");
INSERT INTO ram_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ne cute amcro kam ihkôt xà ata to ajteare mã, ne cute to impejti, kam ihkôt xà na. Ampo na? He cute amcro ata xwỳjrea na ampo cunea jipêj, na quê ha cute xet ata kam cama kôt. ");
INSERT INTO ram_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Pê Pahhiti pê Pahpãm côjkwa me pjê to. Pê harẽn xà catia hane he: ");
INSERT INTO ram_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","Pê nee cormã kam ampo hiprãj nare, ne nee kam ahkêt tetetti nõ hamreare. Pê cormã Pahpãm nee kam ta to iwrỳc nare, ne ahcakũm kam atàr ata pê ajco pjê inco. Ne hanea ne cormã pjê kam jũmjê jàpên xà caxuw me hamreare. ");
INSERT INTO ram_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mã Pahpãm te pjê te mehĩ ton ne pea hĩjakre jakôr, mã hĩa na cute amji ton. Hõ, pê mehĩ ton xà ita hane. ");
INSERT INTO ram_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mã Pahhiti te pjê impejti japrỳ te Etẽ ita kam hàhkre, pyt japôj xà rũm, ne kam pjê te mehĩ xũmre jĩa mã hikran, kam ihkrĩ xà caxuw. ");
INSERT INTO ram_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mã Pahhiti pê Pahpãm te Etẽ jõ pjê kam ampo pej pit kre. Mã ahpỹanre na ajpẽn caxuw pĩxô pàr pej pit japôj ne hiprãj, ne ihkur xà caxuw ihcunea impeaj. Ne pjê ata jipôc ri Pahpãm te pĩxô pàr to ipijakrut ne ihkre, atajê ri ihkwỳ pê ajteare mã. Ne pyxit ne cupê mehtĩr rohnỳtti mã xà jõ pĩxô. Na quê ha jũm te pĩxô ata nõ krẽr na, quê ha jũ caxuw ihtyc nare, ne quêt ihtĩr rohnỳtti mã. Ne ihnõ ata pê ri ampo pej me, ampo kên jahkre pej xà jõ pĩxô pàr. Na quê ha jũm te pĩxô ata nõ krẽr na, quê ha ihcunea na amji jahkre pej ne ihkrã kre. ");
INSERT INTO ram_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ne pjê ata kam Pahpãm te cô ton, mã ajpjê, cute pjê inco xà caxuw. Ne Etẽ jõ pjê ata pĩn pê cô ata cato, ne kaam ihcahkũm, ne cute amji to cwat ne ajpjê. ");
INSERT INTO ram_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","14","Atajê ri ahpỹanre na haprỳ itajê te hajỹr he: Pixõ jõ cô me, Gijõ jõ cô me, Ticre jõ cô me, Cômpejti jõ cô. ");
INSERT INTO ram_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","17","Mã Pahpãm pê Pahhiti te pjê ata kam hũmre pê Atãw xwỳ ata mã hikran, kam ihkrĩ ne cute hamãr, ne kam hàpên xà caxuw. Ne cumã pĩxô pàr pyxit ne ihcawpa ne cumã: — Ca ha gapacta ne atỳj pĩxô pàr itajê xô cunea ku, ne por ampo pej me, ampo kên jahkre pej xà jõ pĩxô ata, ca ha nee ihnõ krẽr nare. Ampo na? Ca ha ate ihnõ krẽr na, ca ha ramã impejti xà jahkre pej, ne ihkêanre xà jahkre pej, ne hanea ne amcro ata kam atỳj atyc kam tẽ — hane. ");
INSERT INTO ram_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","20","Ne pê ramã pjê ata kam ahpỹanre na ajpẽn caxuw pjê kam pryre atajê to, ne kỳj pê ahpỹanre na pryjara ton pa. Ne ma ihcunea to mõ, Atãw wỳr, ne cumã ihcunea jahkre, mãr quê Atãw ahpỹanre na ihcunea mã haprỳ jõr pa. Mã cute amji mã ampo mã haprỳ jõr prãmti ata na, cute cumã hõr partu. Ne haprỳ ata na quê ha ipa rohnỳtti mã. Ne cute pryre capônỹre mã haprỳ, ne ahkêt kam pryre atajê mã haprỳ, ne kỳj pê pryjara cunea mã haprỳ jõr partu. Ne ampo itajê cunea jipôc ri, Atãw te nee amji caxuw ampo pê ihnõ ata mã cator nare. Jirô pê mã ri Pahpãm pê Pahhiti te amji mã: — Imã hũmre ita ahte apu ipa ita na to prãm nare, na wa ha hĩa na cumã catê nõ to — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ne jũ mã cute Atãw ton ne to hõtxwaa to hõtxwa, mã hõt mã ihtyctu, ne ihtỳj nõ ne gõr. Mã Pahpãm te hiwrỳhhi nõ caxàr, ne hacpỹa mã haxà to cumã ipijapỳn. ");
INSERT INTO ram_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ne hiwrỳhhi ata to cumã cahãj ton, ne ma hỹrmã to mõ, mã ramã ipimprar, mã cute cumã hõr. ");
INSERT INTO ram_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mã Atãw te harkwa to: — Taamã! Pahpãm te ijiwrỳhhi kwỳ caxàr ne to imã cahãj, na ri quêt cupê ijĩa kwỳ, cwỳrjapê wa ha cumã haprỳ to: “Cahãj” — hane. ");
INSERT INTO ram_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Cwỳrjapê quê ha ita caxuw me hũmre menxyrxwỳ me, me hũmjê jicu, ne me hikwa tuw, ne ma mehprõ wỳr me rê, ne mehprõ me, me ajcaxê ne ajpẽn kam me pyxit peaj. ");
INSERT INTO ram_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Pê Atãw me hĩxi nee mehkà to me amji pro nare, ne mehcakrô ame ipa, ne nee ajco ajpẽn kam amehpahàm nare. ");
INSERT INTO ram_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ne pjê kam Pahpãm te ampo cunea ton atajê jirôa pê cagãti ita te amji jahkre kitre nare. Ne ma cahãj ata wỳr tẽ ne ahna hàhtêp, ne cute ihcukij, ne cumã: — Xà ampeaj kam Apãm Cati te, ate me pĩxô itajê cunea kur tête me amãn? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Mã cahãj ata cumã: — Quê, itỳj ite mehcunea kur xà. Ne por ipàr pyxit peaj ne ihkwỳ jipôc ri xa ata ri, Inxũ Cati te intête me imãn, wa nee mehnõ krẽr nare, ne nee ahna me ijũhkra nõr nare, ne amehcupên nare. Nãmri wa ha mempar nare na, wa ha itỳj me ty, ita na ri Inxũ Cati pê Pahhiti te me imã harẽn — hane. ");
INSERT INTO ram_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","Mã cagãti cumã: — Quê! Ame amã ihhêj, ca nee me atyc nare! Ampo na ri ame amã ihcawpa? Nee mã ampo na nare. He ate mehnõ krẽr, ne cume, me apipẽan, ne mempej jahkre pej ne mehkên jahkre pej cupate ri ame amã ihhêj — hane. ");
INSERT INTO ram_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mã cahãj ata te ihtỳj harkwa kôt pĩxô ata kur xà na impeaj na amji mã to hajỹr. Ne cute pĩxô ata pupun, mã cumã impejti, ne ihtỳj amji mã cute amji jahkre pej xà caxuw impej na cute to hajỹr. Ne cute hô nõ hyr ne ihkrẽr, ne hanea ne impjên mã ipyr ne cumã hõr, mã cute ihkrẽr. ");
INSERT INTO ram_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Me ajkaam cute ampo cunea jahkre pej kam ihtẽm, ne cute mehcakrô na me amji jahkre pej, ne amehpahàm pyrentu. Cwỳrjapê ri cute me pĩhhô kẽhkẽn, ne me cahyr, ne me to amji pro. ");
INSERT INTO ram_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ne pyt ata kam ramã ahpreprer to mõr kam, mã cute pjê impejti ata kam, me Pahhiti pê Pahpãm mõr na me kam hapac, ne ajwar cupê pĩ catàtkre na me ipimxur. ");
INSERT INTO ram_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mã cute me cumã hàkjêr ne me cumã: — Atãw, ampo na mã ca apu ipê amxu? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mã Atãw cumã: — Wa ite ajpên amõr na me apar, ne ate icakrô na me ipupun cupate, wa apê me ipimxur — hane. ");
INSERT INTO ram_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mã cumã: — Jũm te mã acakrô na garẽn? Xà ajkĩ ate, ite amã pĩxô pàr cawpa ata nõ krẽr? — hane. ");
INSERT INTO ram_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mã Atãw cumã: — Ỹhỹ, por ate imã cahãj jõr ata te ri imã hõr, wa ite ihkrẽr — hane. ");
INSERT INTO ram_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mã Pahhiti pê Pahpãm te cahãj ita mã: — Pỳhàpà, ampo na mã ajte ate me hajỹr? — hajỹr. Mã cumã: — Por cagãti ata te ri imã ihhêj, wa ite ihkrẽr — hane. ");
INSERT INTO ram_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mã Pahpãm te cagãti ata mã: — Ca ate me cumã amji kam gapac xà to hajỹr cwỳrjapê, wa ha acrôn xà kêanre ita to acrô he. Ampo pryre capônỹre me hàprêhti atajê jirôa pê akêanre. Na quê ha apa xà ita pê ajteare mã, na ca ha pjê kam atu na apu pra, ne pjê jacrô pit kur to apu apa rohnỳtti mã. Quê ha ampo pryre kwỳ cunea, ma ame acaca, ca ha ahnaa jũ caxuw gamre. ");
INSERT INTO ram_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Hamre, ita caxuw ca ha cahãj ita me apê ajpẽn curê xwỳn. Quê ha hanea ne me atàmxwỳ me, mehtàmxwỳ pê ajpẽn curê xwỳn. Ne ca ha jũ caxuw amcro nõ na, cahãj ita tàmxwỳ tàmxwỳ nõ par kat kam ihtõc, quê ha taa mã ato hajỹr nare, ne quêt akrã gãntu — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ne cute hanea ne cahãj ita crôn xà ita to incrôn, ne cumã: — Ita caxuw wa ha amã akra xà to ajcamẽ, ne kypê amã to hà nare. Cakrô ca ha atỳj cormã amã apjên kĩn, ca ha atỳj ahna amji to pôj, quê ha cupê ato ihhimpej catê. Na quê ha me atàmxwỳ me acukwa kam, ahnaa me to hãm ita na — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","Ne cute Atãw mã hajỹar ne cumã: — Ca ate gĩxia kôt amji kam gapac, ne ite amã pĩxô pàr cawpa ata krẽr, cwỳrjapê wa ha ita caxuw apê pjê ita to kêanre ne. Quê ha kam hômjĩ pàr hapôj, ne kam ahkêt kêanre hapôj, na ca ha pĩhhô me ampo hy pit kur to apa, ne apêa to apê, ne akuc na cô pra, mãr quê me amã gõ, ca me apà. Hõ, ca ha hajỹr to acuhhê ita kam ahnaa awej ne jũ caxuw ty, quê ha pjê ita to me garêt, ca ha hacpỹ mã pjê ita na amji jahkre. Ne pjê ata to pê wa ato, na ca ha hacpỹa mã pjê ita mã axà — hajỹr. Mã ajwar cute mempar. ");
INSERT INTO ram_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ne Atãw te hĩxi mã haprỳ to Ewakwỳj, ne haprỳ ita kôt harẽn xà te “Mehcunea menxi”. ");
INSERT INTO ram_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mã Pahpãm pê Pahhiti te ampo pry curan, ne ihkà to me cumã mehkà. ");
INSERT INTO ram_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ne cute amji mã: — Ita caxuw quê ha mehĩ itajê pê me pahpyràac, ne ihtỳj ihkên jahkre pej ne impej jahkre pej. Cwỳrjapê ri cute pĩxô pê mehtĩr rohnỳtti mã xà ata nõ krẽr xà nare. Nãmri quê ha cute ihnõ krẽr na, quê ha ihtỳj cute ihkên mã hàr xà ita kam amji to ipijapar to ipa rohnỳtti mã — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Cwỳrjapê ri Pahpãm te pjê impejti japrỳ te Etẽ ata tête me cator, ne ampỳa mã pjê nõ ata wỳr mehkujahêc, mãr quê, cute pjê to Atãw ton ata, curi kam apê ne apà. ");
INSERT INTO ram_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Cute me cator jirô pê mã ri, pyt japôj xà rũm, Pahpãm te côjkwa kam cumã hàprê catêjê kwỳ pyxwỳr, cute me harkwa jamãr xà na. Ne hanea ne cute wapo xwahhihti pôr ata xãm, cute mehtĩr rohnỳtti mã xà ata jõ pĩxô pàr jamãr prãmte. Mã pra ne ipu na ajrõ ita na. ");
INSERT INTO ram_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Mã Atãw hĩxi me hikwa, ne cute kam ihkra, mã cumã ihkra xũmre pỳm. Mã cute cumã haprỳ to Cãn. Mã Ewakwỳj te amji jarẽn to: — Pahhiti te itehcajpar, mã imã ikra xũmre ita cator — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Jirô pê mã ri hipêr cumã ihkra xũmre nõa pỳm ata japrỳ te ri Aper. Ne ajwar mehkà. Mã Aper pê carà cahàcre to ipijapar catê, ne Cãn pê ri pur to hàpên catê. ");
INSERT INTO ram_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ne amcro nõ na Cãn te Pahhiti mã hàprà ata jõ xô nõ pyr ne to mõ, ne cama cumã hõr prãmte, to kam hapac. ");
INSERT INTO ram_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Mã hanea ne Aper te Pahhiti mã hõ parxare nõ cakônĩ pỳm ata curan ne hĩ pejti kwỳ pyr, ne to mõ, ne to Pahhiti kam hapac. Mã cumã Aper jõ hĩ ata kĩnti, mã cute ahna amji caxàr. ");
INSERT INTO ram_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ne ma apu Cãn pê hàprà xô ata caca. Mã Cãn incryac kam, ihkuc kêan kam, apu amji kam hapac to mõ. ");
INSERT INTO ram_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mã Pahhiti cumã: — Ampo na mã ca apu acryc, ne akuc kêan kam apu mõ? ");
INSERT INTO ram_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ca ha ate icajpuaw ampo ton na, wa ha itỳj ahna amji capa. Nãmri ca ha ate apu amji kam gapac xà kêanre ton to apa na, quê ha akên xà ata pê ihhêj rũm ampo pry jàprê kêanre ata pyràac, ne ihtỳj apro to prãm, ne taa ato ihhimpej to ipa. Na ca ha caa, akên itajê to amji mã capônỹre ne, ne tohjê, ne caa to ahimpej to apa — hajỹr. Mã Cãn te impar, ne nee ihkôt amji kam hapac nare. ");
INSERT INTO ram_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ne amcro nõ na cormã ihtõ kam incryc, mã cumã: — Hacu ne põ kam apu mõ — hane. Mã ma ihtõ pê Aper ihkôt mõ, mã põ kam hamreare ata kam, Cãn te Aper kam ihtẽm ne ihcuran. ");
INSERT INTO ram_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mã ahna ahtũm nare mã Pahhiti Cãn mã: — Jõ ri mã atõ Aper? — hane. Mã cumã: — Pỳpỹn, wa ite nee hõmpun nare. Xà ajkĩ ipê itõ jamãr catê, mã ca apu ahna icukij? — hane. ");
INSERT INTO ram_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mã Pahpãm cumã: — He pỳhàpà! Ampo caxuw mã ate atõ to hajỹr? Pom atõ caprô ita ihtỳj pjêa kam imã akij, ne imã ate to kên jahpan xà ite ato kên na, awjahkre ita? ");
INSERT INTO ram_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","Atea amji mã acrôn xà kêanre na gàhwỳr, ne por ate pjê kam atõ caprô jaxwỳr, mã cute to ihkõm ata, quê ha nee hipêr amã gàprà xô nõ jõr nare. Na ca ha ita caxuw cama apu amji jacjê, pjê cunea kam — hane. ");
INSERT INTO ram_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Mã cumã: — Ite ikên mã ijũcanãr xà ita jirôa pê, ate imã ton. ");
INSERT INTO ram_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ca ha pjê ita pê ikujate, wa ha itỳj apê ampỳa mã pjê cunea kam ipa. Quê ha jũ ri cute me icajpar atajê cunea ihtỳj me icuran to prãm — hane. ");
INSERT INTO ram_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","16","Mã Pahhiti cumã: — Hãpà, nee cute ahna hajỹr nare. Wa ha gĩ kam, cute me gahkre pej xà na amã ihhôc, quê ha mehcunea me hõmpu ne me gahkre pej, ne nee me acuran nare. Nãmri quê ha jũm te acuran na, wa ha ihcura, ne ihkôt cormã mehkwỳa kwỳ to xêj ne me hipej — hane. Ne cute Cãn jahkre pej xà ita na kam ihhôc, mã ma Cãn Pahhiti pê tẽ, ne pyt japôj xà rũm, pjê nõa kam ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Mã hipêr Atãw te Ewa kam ihkra, mã cumã ihpỳm, mã cute me cumã haprỳ to Xet. Mã Ewa te harkwa to: — Pahhiti te Cãn te Aper curan ata jaxà kam hipêr imã ikra xũmre ita jõr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Mã Xet ita ihkà, ne hikwa tuw, mã hanea ne cumã ihkra xũmre nõ cator, mã cute me cumã haprỳ to Enotti. Ne caku atajêa kam ri cute me Pahpãm cukij to: “Ihtĩr Rohnỳtti Mã Ata” hajỹr, ne ahnaa me cukij kam ihtẽm. Hamre. ");
INSERT INTO ram_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mã Pahhiti te me ton catê ata ramã me kam ihpeacre, ne me kam cumã amji kĩn nare. Na ri cute me caxuw amji kam hapac xà nõ to ipintuw, ne ahna jêt, cute me hajỹr xà ita kam. ");
INSERT INTO ram_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Cwỳrjapê ri cute amji mã harkwa to: — Ite me ton xà ita kam amji jũ na ipeacre, na wa ha pjê kam mehcunea to hamre tu. Ne pom wa ite mehĩ ton itajê me, pryre me, pryjara me, wa ha mehcunea to hamre tu. Nãmri ramã ite me caxuw amji kam ijapac xà nõ na ijêt, ne imã me hapê nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pê por me hũmre nõ pyxit peaj ne haprỳ Nowe ata pê Pahpãm cajpuaw. ");
INSERT INTO ram_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ne pê Nowe ata quêt pyxit peaj ne ajco catyt kam ipa, ne ihcunea na impejti ne ajteare mã, pjê kam me hũmre atajê cunea cote na. Ne Pahpãm te amji kam hapac xàa to, ajco amji mã ihhimpej to ipa. ");
INSERT INTO ram_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ne cumã ihkra xũmre incrê, ne me haprỳ pê Xẽm me, Cãw me Jape. ");
INSERT INTO ram_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","13","Ne pê pjê cunea kam mehcunea ajpẽn to me hàprê to me ipa. Ne Pahpãm mã, ramã cute amji kam me hapac xà cunea kêanre, ne ihhêj ne ihcacu, ne ramã ihkro. Na pê Pahpãm Nowe mã amji jarẽn to: — Wa ha pjê kam mehcunea to hamre tu. Ampo na? He imãa ramã pjê kam mehcunea kêanre. Me hàprê me, cute me ajpẽn curê me, ihcunea na cute amji kam me hapac xà kên itajê te ramã ihhêj ne me to ihkro. Cwỳrjapê wa ha itỳj pjê kam me hũmre me, ampo tĩr itajê cunea to hamre tu. ");
INSERT INTO ram_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","15","— Ne Nowe, wa ha itỳj me akra me apytà. Na ca ha pĩ tỳj to pit mã, amji mã pàr kreti nõ to, ne to catia to cati to hane he. Ca ha iry na to gara capô to xetẽnta ne ihkôt xĩc, ne ihpo na to gara capô to cwatôxi, ne ihkà na to gara capô to ôjtô. Ne ca ha ihkre cahty xà tôti pê penhôc hôc ata to cô mã hàr xà mã ihcahty. Ne põ rũm to ihcahty, ne caxwãm pê to ihcahty, cô te cumã hàr cupate. ");
INSERT INTO ram_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ne ca ha kam pĩ to ikre, ne pĩ to hahêr to kam ikre ata tipre to gũhkra capô to incrê. Ne ca ha kam to ihkre to incrê, harã mã me ita to, ne ihcote na me ita to, ne kỳj rũm me ita to, ne ahpỹanre na kam to caxwỳn partu. Ne hĩpê kam ca ha harkwa to pyxit peaj. ");
INSERT INTO ram_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nãmri wa ha cô catia ne ihkujate, quê ha pjê kam ampo cunea pĩr pa. ");
INSERT INTO ram_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","— Ne wa ha ana amji ton to hane he. Ca ha ca me, aprõ me, me akra me, mehprõ me, ca ha me acunea pàr kreti mã me axà, mãr wa cô pê to me apytà. ");
INSERT INTO ram_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ne pryre xwỳjê ca ha ajpẽn caxuw hũmre me cahãj to apijakrut partu, ne pàr kreti mã to axà, ne kỳj pê ampo jara to ne pra itajê, ca ha ajpẽn caxuw hũmre me cahãj to apijakrut partu ne to axà, mãr quê me acahê na ihtyc xà jahpa. Ne pom ite ampo na amẽn itajê, quê ha amji to ajkrut pa, ne amjia kôt awỳr ipa ne acjêj. ");
INSERT INTO ram_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ca ha cumã hõ cunea to cuprõ ne to axà, ne amji mã me gõ catia ne to cuprõ ne me to axà — hane. ");
INSERT INTO ram_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Hõhõ, pê Pahpãm Nowe mã harkwa hyr to hane, pê harkwa kôt ampo atajê cunea ton pa. ");
INSERT INTO ram_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ne pê Nowe jàpên xà ita kam ahna caku hàhtôa, pê hipêj pa. Mã Pahhiti te Nowe mã: — Hã, hamre, gapacta ne ajpên me akra mea mã pàr kreti ita mã me axà. Nãmri apyxit peaj, ca me hũmre itajê cunea cote na catyt kam ijarkwa kôt apa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Mã Nowe me, hĩxi me, mehkra me, mehprõ me, mehcunea xàr, cute cô catia te me hipej xà pê me amji pytàr prãmte. ");
INSERT INTO ram_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Mã pryre cunea me, pryjara cunea te ahpỹanre na amji to ipijakrut par, ne hỹrmã incjêj par, Pahpãm te ahna me mẽn xà ata na. Mã Pahhiti pê Pahpãm te me ahna to harkwa jihê. ");
INSERT INTO ram_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","11","Mã ramã me ahna amcro te xet, mã kam mehkrĩ ne me côhti jikaj. Ne pê caxuaw ramã Nowe na caku xêjxẽnta. Mã ihprõt pê hatuj xà cunea pĩn cô catõtõc, ne cute amji mã hũhhyr, mã côjkwa pĩn hanea ne ta catia te iwrỳc kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ne wrỳa to wrỳ, ne cute iwrỳc ita to amcro to cwarẽnta, ne hanea ne to caxwa to cwarẽnta. ");
INSERT INTO ram_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","20","Mã tàkamrỳ cô catihti ita te pjê jaxir to mõ, ne pea cute pjê cutor tu. Ne ihtua to ihtu, ne cute kẽn kàhti atajê cunea cutor tu, ne cormã kàj mã ihtu na me pajara capô te cwat. Mã pàr kre ihtỳj ihcajcoc, ne cô kam apu mõ. ");
INSERT INTO ram_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Mã pjê kam ampo cunea incaca atajê tyc par ne me hamre tu. Pryre me, pryjara me, ampo to me ipijapar xà me, ampo jàprê me, mehĩ me, ampo kra me, ampo cunea jamre tu. Cô te me hipej tu. Mã Nowe pyxit peaj ne ihtĩr, mehkra me, por ampo cunea cahê na pàr kre kam hàhhuc atajê me. ");
INSERT INTO ram_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pê cô pjê cunea to hipu ita na ahna putwrỳ xĩc. ");
INSERT INTO ram_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","2","Mã nee Pahpãm te Nowe me, mehkra me cahê na pryre atajê to hapac kêt nare. Ne cute pjê caxwãm pê cô jatuj xà jihê ne kôcti kujahêc, cute cô cajpêr, ne to incrà xà caxuw. ");
INSERT INTO ram_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","5","Mã ihcajpê, ne tàkamrỳ cute to inxô ne to incrà to mõ, mã pàr kreti ata mõ, ne kẽnti kàhti catia japrỳ te Ararati ata na hàhhuc. Mã hipêr pjê kam cô ita te amji to putwrỳ to incrê, ne cormã inxô to mõ. ");
INSERT INTO ram_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Ne me ahna amcro te cwarẽnta, mã Nowe te harkwa krare nõ ita jihê mẽn, ne ma põ mã xônti cahàc nõ kujahêc. Mã ihtẽm rohnỳtti mã, ne nee hacpỹ ne cute amji jaxàr nare. ");
INSERT INTO ram_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","9","Mã ihkôt cute tutti kujahêc, mã cute amji jaxàr pyrentu. Ampo na? Cormã nee pjê incrà nare ita kam, jõ ri quê ampo na xa? ");
INSERT INTO ram_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Mã me ahna amcro te xet jirô pê mã ri, hipêr cute tutti kujahêc. ");
INSERT INTO ram_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mã ramã ahna pyt xàr xàa kam, mã cute amji jaxàr, ne ihkrỳt kam pĩ hô nõ tetetti ita xa, mã to tẽ. Mã Nowe te ramã pjê kam cô incrà to mõr na hahkre pej pyrentu. ");
INSERT INTO ram_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ne cute amji to amcro to xet jirô pê mã ri, ma hipêr cute tutti kujahêc, mã nee hacpỹ ne cute amji jaxàr nare. ");
INSERT INTO ram_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","14","Mã hipêr Nowe te pàr kreti ata kam amji to putwrỳ to ipijakrut, cô incrà jikaj xà, mã caxuaw ramã ahna caku te xêjxẽnta ne ihkôt pyxit. Mã cute pĩ te harkwa jihê ita jihê mẽn, ne pjê kam ramã cô incrà na hõmpun. ");
INSERT INTO ram_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","17","Mã Pahpãm te Nowe mã: — Ajpên pàr kreti pê põ mã me acato. Ca me, gĩxi me, me akra me, mehprõ me, pryre me, pryjara me, me acunea me acato. Ne pjê cunea kam atỳj me apicràn to me mõ, ne me gàhtô to mõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","20","Mã mehcunea japôj. Mã Nowe Pahpãm pyrên hakrya to hakry, na ri cute ampo pry ita curan, ne Pahpãm mã hõr prãmte to caxàr. ");
INSERT INTO ram_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","22","Mã Pahpãm te ampo pry to me kam hapac xà ita na cumã ihkĩn, mã cute amji mã harkwa to: — Wa ha nee jũ caxuw hipêr pjê ita to kêanre nare, ne nee mehcunea jipej nare. Ampo na? He cute me hajỹr tũam, ne mehkêanre. Ne wa ha ita caxuw pjê kam me caxuw ampo to ajpẽn catê partu. Na quê ha caku cunea kam me hàhkre xà caxuw, me cumã cô me amco, ne cute me hõ kẽhkẽn xà caxuw amcrà me amcro, ne hanea ne, ajpẽn caxuw, amcro me caxwa. Na quê ha to hajỹr ita kam, ahnaa ampo cunea jicu xà mã to cumẽ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ne Pahpãm te Nowe to impejti ne cumã: — Hamre, ita caxuw ca ha me gàhtô to mõ, ne pjê cunea kam, quê ha me atàmxwỳ me hàhtôa to me hàhtô to me mõ, ne mehcahkũm to me mõ. ");
INSERT INTO ram_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ne quê ha pryre cunea ihtỳj amji mã megĩ itajê cupa, ne me cupê me gõ tekjê, na ca ha me caa me to ahimpej. ");
INSERT INTO ram_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Na ca ha gapacta ne atỳj me ampo itajê cunea ku. Nãmri pê wa mam me amã, ate me ampo hô kur xà itajê to pit mã hahkre. Ne ita caxuw ca ha atỳj me ampo cunea ku. ");
INSERT INTO ram_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","— Ne nee ca ha cormã ne apu hĩ caprô pijaxwỳr nare itajê kur nare. Ampo na? Kam caprô ata pê incaca xà xakat. ");
INSERT INTO ram_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","— Ne pê wa amji kôat me ato, ne megĩa na me ato, cwỳrjapê ri nee me ate me ajpẽn curan xà nare. Nãmri quê ha ampo jàprê te me anõ curan na, nare quê ha jũm jĩa te megĩa nõ curan na, ca ha hanea ne atỳj mehcura, cute ihcuran jahpan xà na. ");
INSERT INTO ram_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","17","— Ne wa ha me amã amji jarẽ, ne jũ caxuw hipêr cô to pjê kam ampo cunea to ipictor to hajỹr nare. Cwỳrjapê wa ha côjkwa kam ta jõxwỳn xô, mãr wa hõmpu, ne amji mã: — “Pê wa me cumã to awjahkre xà ata mã ajêt he. Na wa ha nee jũ caxuw hipêr cô to pjê to ipictor nare” — hane. Hõhõ, pê Pahpãm me Nowe, ita na me amji ton to hane. Hamre. ");
INSERT INTO ram_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mã Ixaher catêjê cunea mehpec xà to cute mencwỳr kam mehtẽm. Ne kỳj cati pêa mã ame amrã, ne cute mencwỳar to me apẽ. ");
INSERT INTO ram_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ne mehcunea te me Mojxe me Arãw cuna mã me cumã amji capẽr kam mehtẽm, ne me cumã: — Wa nee pjê mã me paxàr xà ita kam ame ityc prãm nare. Wa rỳ mã curia Ejit jõ pjê kam ame ty. Nare, wa põti kam me hamreare ata kam ame ty. ");
INSERT INTO ram_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ihhêj ne me pajõ Pahhiti te pjê ita kam mehkrĩ catêjê jõ krãhtare te me pajipej na, cama me hamãr xà caxuw ri cute me pahto cator. Ne quê ha me pahto hajỹr jirô pê mã, quê ha cama me pahkra me, me pahprõ amji to me cumã me hàpên catêjê. Na cu ha pahtỳj ma hacpỹ mã Ejit jõ pjê wỳr me amji jaxà — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ne me ajpẽn mã harkwa to: — Cu ha amji mã me pajõ pahhi tuw nõ xãm, quê ha hacpỹa mã me pahto amji jaxà, Ejit jõ pjê wỳr — hane. ");
INSERT INTO ram_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mã Mojxe me Arãw, Ixaher catêjê kam mare mã pjê kam mehpỳm, ne me hõpôrpo ne me nõ, mehpec xàhte. ");
INSERT INTO ram_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","7","Mã cute me pjê pupun catêjê pijakrut itajê japrỳ pê Jojuw, me Carep atajê me cute amji pê mehkà cokjêr, mehpec xàhte, ne mehkwỳ mã hũjarẽn to: — Pom wa ite me pjê pupun ita peaj to impej. ");
INSERT INTO ram_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Cu ha me pajõ Pahhiti cajpuaw na, quê ha ihtỳj me pamã pjê pejti ata gõ, cu ha pahtỳj amji mã me hũtà. Ne pjê ata kam me hõa to me hõ, ne ampeaj kam, kam pryti to ipijapar xà me, pur caxuw impej. ");
INSERT INTO ram_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nee ca amji tête ame Pahpãm jarkwa curê nare. Ne nee cuna mã ame acryc nare, ne nee ame, por curi amehkrĩ atajê cupa nare. Ampo na? Cu ha me pahtỳj me to cô, ne me hipej ne me hirô pê xa. He me pajõ Pahhiti ihtỳj ame pahkôt ipa, ne cute me pahpãm cahàc krekà pê me pahcurê xwỳn pytàr catêjê atajê cunea rẽn. Cwỳrjapê wa me amã, ca ame hũpa nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","11","Mã me hàhtôti atajê ajwar kẽn to ame capêr, ne to mehcuran prãm to pit mã amehcakôc. Mã Pahpãm carôt cati jàhcujrohti ata ampo kà te hũrkwa mã Ixaher catêjê cunea te cuprõn ata wỳr iwrỳc, ne Pahhiti te Mojxe mã harkwa to: — Me hàhtôti itajê ma ame icurê! Ne cute me hajỹr ita kam ri ihtỳj amji caxuw me icyt to me ipa. Ne jũ caxuw mã quê ha ajte, ite me kam ampo to amji to ipipẽ xà ita kôt me ijahkre pej, ne ikôt me amji to? ");
INSERT INTO ram_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Wa ha hà kên cunea to me kam icryc, ne ame to kên, ne ite me cumã ampo jõr xà to ijũjahkre ata xwỳjrea na me hipej. Ne akam wa ha quêt me to hàhtô, quê ha mam itajê jirôa pê me atàmxwỳ itajê cunea me carôt tỳj — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mã Mojxe te Pahhiti pê Pahpãm mã harkwa to: — Jũ mã quê ha Ejit catêjê cahhur me ita jarẽn pa, ne kam me amji cajpẽr to? Ne ramã Ejit catêjê te acarôt tỳjti to me akwỳ to acator ata na me gõmpun, ne me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ne ma cute pjê ata kam me ipa catêjê mã me garẽn. Ne hanea ne Ixaher catêjê kôt apê me hõ Pahhiti te amõr na, ne hũ na pire mã ajpẽn mã me acakôc na me cumã me garẽn. Ne ihtỳj me cumam ahcakrã kam apê me hõ Pahhiti te amõr na, cute me gõmpun. Ne ihtỳj amcro me caxwa ri ahcakrã ata te cuhy na amji jahkre ne harij na, cute me hõmpun. ");
INSERT INTO ram_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ne ca ha ate me akwỳ jipej pyrentu na, quê ha pjê ata kam, krĩxàre kwỳ me ahna me garẽn pa, ne me ahna amji mã me garẽn kên to, ");
INSERT INTO ram_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“He pê ihtỳj me hõ Pahhiti me cumã pjê to awjahkre ata wỳr me to mõr cakrô, nee cute amji mã hamãr, ne me to hàr nare. Cwỳrjapê ri cute ahkêt me põti jipôac ri mehcunea jipej” hane. ");
INSERT INTO ram_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","— Na ca ha acarôt jàhcaprĩhti to me cumã ajpẽ, ne cute mehkên ton xà itajê to tojnõ, ne cama amã mehkĩnti ne. Ne pê ca ramã amji jarẽn to: “Imã me akĩnti ita kam, wa nee me akam icryc pyrentu nare, ne ca hame ate me ito kên, ne amji tête me ijarkwa curê jicu na, wa ha itỳj me ate ito kên ita to tojnõ ne hicu. Nãmri ca ha me ate amji tête me icurê to me axãm ita na, wa ha itỳj hahpan xà na me akên mã me amẽ, me akra me, me atàmxwỳ mea mã” hane. ");
INSERT INTO ram_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","— Na ite apar xàa na wa awỳ, pom hõtpê amã me ikĩnti rohnỳtti mã, ca atỳj cute mehkên ton itajê cunea to tojnõ ne hicu to hanea, pom ahnaa mã ca ajpên Ejit jõ pjêa rũm mehkên na me to tojnõ to mõ he, ita na ca ha ita kam me ito — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","23","Mã Pahhiti te Mojxe mã amji jarẽn to: — Hã, wa ha itỳj, pom ate iwỳr xà ita na me ato, ne cute me ito kên itajê to tojnõ. Ne wa ha pa amji japrỳa na me ahna amji to. Quê ha nee jũ caxuw, por pê wa me hũmjê mã pjê to ijũjahkre xà ata mã me hàr nare. Ne põti kam me hamreare ata kam, quê ha mehtyc pa. — Ampo na wa ha me to hane? Nee mã ampo na nare. He pê ramã me icarôt tỳjti jàhcujro itajê kwỳ na me ipupu. Pê wa ramã me cumã me hõ japrỳ te mana ita gõ, ne me cumã cô gõ, mã ajte nee ite Ejit jõ pjê me põti ita kam me cumã ampo ton xà itajê na, ito me amji japackre nare. Ne ajte cormã cute me icapi prãmte, icuna mã me ampo kên ton to me tej to me ipa, ne nee me ijarkwa par nare. Ne por me ijarkwa par nare atajê, quê ha nee, por pê wa me hũmjê mã pjê to awjahkre ata mã, me hàr nare. Ne pom ma ame icurê itajê nõ, quê ha nee mehnõ pjê ata pupun nare. ");
INSERT INTO ram_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","— Ne pom imã hàpên catê pê Carep ita nare, ajteare mã quêt amji kampa, ne quêt cute ihtỳj ipar xà cunea to ipar. Na quê ha ihtỳj cute pjê pupun ata wỳr axà, quê ha mehtàmxwỳ ihtỳj hakàn pê pjê ata kam me ipa, ne kam me amji to ajpa. ");
INSERT INTO ram_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","— Ne apẽ quê ha ajte ma Amarec catêjê me, Canãn catêjê, por caprũm kam mehkrĩ atajê japy, hacpỹ mã põ kam hamreare ata wỳr me amji jaxà. Ne Côxwatepti cajpuw quê ha me mõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","27","Jirô pê mã ri Pahhiti te hipêr Mojxe me Arãw mã hũjarẽn to: — Jũ caxuw mã quê ha ajte cute me imã amji kôt harẽn jàhcahhõn xiti itajê mã me hikra? Wa ite ramã cute imã me hàhcahhõn na mempar, ne ahna imã mehkĩn nare. ");
INSERT INTO ram_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Na ca ha me cumã ijarẽn to: “Ipê me gõ Pahhiti pê Pahpãm. Wa ha itỳj me amã, por me amã ampo cupahti na, ate me amji jarẽn ata to. ");
INSERT INTO ram_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","30","Na ca ha me acunea põti kam me hamreare ata kam me atyc pa, por ramã me ana caku te winti jirô pê atajê, ca ha me atyc pa. Ampo na? Me acunea te imã me gàhcahhõn par, na ca ha me atyc pa, quê ha me ahkrare pit ite me cumã pjê to ijũjahkre xà ata mã me axà. Ne mehkà pijakrut japrỳ te Carep me Jojuw itajê, quê ha mehkà na me ajkrut peaj ne mehkôt pjê ata mã me axà. ");
INSERT INTO ram_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","“Ne me acunea te me akra pê, por Canãn jõ pjê kam me xa atajê mã, cama me hàpên catêjê na ate me harẽn cakrô, wa ha itỳj me hamã, ne pjê ata wỳr me to icato, quê ha quêt kam me ipa. Ne ate me pjê kêanre na me harẽn ata kam, quêt ihcunea na me amji pupun pejti to me ipa. ");
INSERT INTO ram_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ne me ca nare. Quê ha me gĩ itajê ajhu ne ty, põti kam me hamreare ata kam. ");
INSERT INTO ram_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ne quê ha me apê amji jahkre kêt, ca ha atỳj me akra me, põti kam me hamreare ata kam me apa to me caku to me cwarẽnta. Ne me akôt quê ha me akra me amji pupun xà kêanre to me ipa, ne ate amji mã me ito ahimpej nare ita kam, ca ha xa me acunea me atyc pa, jirô pê mã quê ha cormã me akra me, me atàmxwỳ pit pjê ata mã me axà. ");
INSERT INTO ram_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","35","“Ne ca ha me apê, por pê me pjê pupun catêjê atajê pyràac, pê me mõar to me amcro to cwarẽnta, jĩkjê na ca ha põti kam me hamreare ita kam ame apa to me caku to cwarẽnta. Ampo na? He wa ha ita caxuw me ato impej jicu, ca ha ame akên xà pytĩti atajê to ame acuhkwỳr. Quê ha ahpỹanre na ate me ina ajpẽn par xà atajêa me gipej, põti kam me hamreare ata kam. He ipê me gõ Pahhiti, na wa itea me amã icakôc xà ita ton, na ca ha atỳj põti ita kam ame ty” — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","38","Mã cute me tej te me pjê pupun catêjê atajê te me mõr tête mehcunea hi kwĩn, ne mehcunea to me hàhcahhõn xi, na ri mehtyc xà kêanre kam mehcunea tyc pyrentu, me pajõ Pahhiti kam mare mã. Mã Carep me Jojuw pijakrut peaj ne mehtĩar na me hàhhuc. ");
INSERT INTO ram_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mã Mojxe te mehkwỳ mã Pahpãm jarkwa ita jarẽn, mã me hũpar xà ita kam amehpeacre, ne me cumã amji kĩn nare. ");
INSERT INTO ram_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mã amcro nõ na iràrà na mehcunea jỹr, ne ma, por pjê kam awjarô to cute me cumã hũjahkre ata wỳr, cute me mõr na me ipyr. Ne cute me Mojxe mã me harkwa to: — Wa itỳj ite me Pahpãm cuna mã me ikêanre na me amji pupun, na wa ha itỳj ita caxuw, por me pajõ Pahhiti te me pamã pjê to hũjahkre ata wỳr me ikràr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mã Mojxe te me cumã harkwa to: — Ca rỳ mã mam me hane na mã, ca nee ajte ate me Pahpãm par nare. Mã ramã ahna ahtũm rytu, ne ramã hõ amcro jirô pê ihpỳm ita kam, jũ wỳr ca ha curi me mõ. Ca ha ita kam me ate me amõr na, ca ramã ate me pajõ Pahhiti pê Pahpãm jarkwa par nare. ");
INSERT INTO ram_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne pom curmã ate amji kam me gapac xà jarẽn itajê, ca nee kam me to acrà nare, ne me hicu. Nãmri ca ha ate pjê kam awjarô ata pytàr prãm kam me to acrà na, quê ha me acurê xwỳn me ato hamre. Ampo na? He me pajõ Pahhiti pê Pahpãm nee me akôt mõr nare ita kam, quê ha ihtỳj me gipej. ");
INSERT INTO ram_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Xà ca nee me Amarec catêjê me, Canãn catêjê to me amji japackre nare? He cormã me pahcumam me xa! Ca ate me pajõ Pahhiti pê Pahpãm mã hikran, cwỳrjapê quê ha hanea ne me amã hikra, ne nee me apijapu xà kam me atehcajpar nare, quê ha me acurê xwỳn ihtỳj me acura — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ne tee Mojxe te me cumã me cawpa cakrô, mã ajte ma me mõr kam mencrà, pjê kam kẽnti atajê cajpuw. Mã curia me hakàn pê Mojxe me Pahpãm jàmcjên xà jàhhuc, mã me hàhtôa ne amũ me pra. ");
INSERT INTO ram_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Mã kẽnti na Amarec catêjê me, Canãn catêjê mehkrĩ atajê mehwỳr me iwrỳc, ne cute me Ixaher catêjê curan kam mehtẽm, ne ma mehcuran to mõ. Mã ma me hũpate mehprõt. Mã ihtỳj mehcuran to me mõ, ne cute mehcuran itaa to, ma Horma jõ krĩ mã me cator. Ne Ixaher catêjê cahhur te ma Mojxe kôt põti kam me hamreare wỳr me amji jaxàr, ne kam ajco ame ipa. ");
INSERT INTO ram_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Mã ma Ixaher catêjê te me mõr kam mencrà, ne cute me Côxwatepti jõ pry kôt, me Hôr jõ kẽnti jakren. Ne ma Etõ jõ pjê pu na me ipijarõ prãmte me mõ. ");
INSERT INTO ram_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Mã amehpec ne nee hipêr cumã me hikaj prãm nare, mã ajpẽn mã ame Pahpãm jarẽn to amehkêanre, ne cute me Mojxe to me hajỹar, ne ajpẽn mã ame harẽn to kêanre, ne me cumã harkwa to: — Ampo na mã ate põti ita mã, Ejit jõ pjê pê me ito acator, ita ri me ityc xà ita caxuw? Ita ri ite me ampo krẽr xà hamreare, ne nee me ikõm xà hamreare. Ne ramã me imã kwỳr pê mana ita kĩn nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Mã Pahpãm te me hàhcahhõn xà kêanre ata jahpan xà na, mehwỳr cagã jàhtôa ne kujahêc, cute mehcãmxar prãmte. Mã ramã cute ame hàhtôa ne amehcãmxar, mã amehtyc. ");
INSERT INTO ram_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Cwỳrjapê ri ma Mojxe wỳr mehprõt, ne cute me cumã me amji jarẽn to: — Wa ame amji pupun kêanre! Wa ite Pahpãm me, me acuna mã me ikên xà kêanre itajê ton, cwỳrjapê ri me ikêanre. Na ca ha Pahpãm mã acakôc, ne cumã me icajrẽn, quê me itête cagãti itajê to hawry — hajỹr. Mã Mojxe te Pahpãm mã mehcajrẽn. ");
INSERT INTO ram_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mã Pahpãm te Mojxe mã harkwa to: — Wakỳre nõ to cagã, quê ha cagã xàhti itajê mehcãmxa, quê ha me wakỳre te cagã ita pupu, ne nee amehtyc nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mã Mojxe te Pahpãm jarkwa na wakỳre to cagã, ne me hipôc ri inxôr. Mã cagã xàhti atajê mehcãmxa, mã me wakỳre te cagã ita pupu, ne hacpỹa mã mempej. Hamre. ");
INSERT INTO ram_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Pê amcro nõ na Xãnxã hũm me inxi me krĩ nõ japrỳ te Timna wỳr me mõ. Pê me mõr xà kôt me pĩxô intepre amji cwỳrpê me hõmpun to mõ. Mã hamre, ihprõt pê hỹrmã rop cahàc xãm tuwti nõ kam intoj. ");
INSERT INTO ram_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Mã Pahpãm Carõ Pejti te Xãnxã mã carôt catia ne hõr. Na ri Xãnxã te hũhkraa to rop cati ata curan. ");
INSERT INTO ram_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Pê Pahpãm ta nõ kujahêc nare to caku to incrê, ne ihkôt to hĩkjê. Ampo na? Pê nee me Pahpãm jarkwa par nare, ne pahpãm cahàc krekà kôt pit mã me amji kampa na pê. Jirô pê mã ri Pahpãm te cumã ihcakôc catê pê Erij kujahêc, Acapê pê pjê jõ pahhi ata wỳr, quê cumã awjarẽ, mãr quê Carer jõ kẽnti na mehkwỳ to cuprõn tu ne. Mã ma Erij tẽ, ne cute pahhi pê Acapê mã hũjarẽn. Mã Acapê te mehkwỳ pê Ixaher catêjê cunea to cuprõn tu, me pahpãm cahàc krekà pê Pahar ata mã me hàpên catêjê me, cute Carer jõ kẽnti na me to cuprõn. ");
INSERT INTO ram_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Mã Erij te me hàhtôti atajê mã harkwa to: — Jũ mã ca ha amji to me gàhtũm ry to, ne amji mã me ipijakrut itajê nõ te amji kam hapac xà nõ capi, ne mehnõ pyxit peaj kôt me amji kampa? Quê ha Pahpãm pê ijõ Pahhiti pê Pahpãam to Pahpãm na, taa mã ca ha me hũnã! Nãmri quê ha pahpãm cahàc krekà pê Pahar ata pê pahpãm na, taa mã ca ha me hũnã! — hajỹr. Mã nee jũm te cumã jũ mãn nare. ");
INSERT INTO ram_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Mã hipêr me cumã: — He wa me acatàtkre na, ipê Pahpãm pê ijõ Pahhiti mã ijàpên catê pyxit peaj ne ijàhhuc. Ne Pahar mã me hàpên catêjê mã ajte me hàhtôa to me hàhtô, ne cute me cwatxẽnta ne ihkôt xĩncwẽnta. ");
INSERT INTO ram_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Hã, ajpên me pryti xũmti to me ajkrut ne me to mõ. Quê Pahar mã me hàpên catêjê amji mã mehnõ capi, ne mehcura, ne me to ihkryj ne to caxàr xà kam pĩ ata jipy me haxwỳ. Ne nee ajco, ihkrac ri pĩ ata kam me cuhôn nare. Wa ha hanea ne ihnõ to hanea ne ihcura, ne to ihkryj, ne Pahpãm mã to caxàr xà kam pĩ ata jipy haxwỳ, ne nee ihkrac ri cuhôn nare. ");
INSERT INTO ram_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Ca ha me gõ pahhiti pê pahpãm cahàc krekà pê Pahar ata na ahwỳ, jirô pê mã, wa ha hanea ne ijõ Pahpãm pê Pahhiti na ahwỳ. Ne por quê ha me Pahpãm nõ me pahkampa, ne cuhy kujate, quê ha pĩ ita na cupỳ ne to capa ata pê, quê ha quêt Pahpãm peaj — hajỹr. Mã ipu na amehcuhhê itajê cunea te ita na me amji caxàr, ne me cumã: — Pom ate harẽn xà ita na ihkênre nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Jirô pê mã ri Erij te Pahar mã me hàpên catêjê mã harkwa to: — Ampeaj kam me gàhtô, cwỳrjapê ca ha me caa mam me pryti ita nõ capi ne mehcura, ne mam me apãm pê me gõ pahhiti pê Pahar ata mã me acakôc, ne nee me pĩ jakôt ata krac ri me cuhôn nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Mã cute me pryti ata curan, ne ame ton, ne cute me to caxàr xà ata jipy me haxwỳr. Ne pea iràràtia na, me hõ pahpãm cahàc krekà pê Pahar ata pejti na me harẽn kam mehtẽm, ne tàkamrỳ cute me to pyt jàpir to me mõ, ne me caràr to: — Hàpà, me ijõ inxũ pê Pahar, me ikampa, pom wa me awỳ ita? Me ijõ pahhiti, me ikampa ne ajpên cuhy kujate! — hane. Mã nee cute me kam hapac nare. Mã cute me pryti to caxàr xà ata pu na me hàkrun kam mehtẽm, me cumã cuhy cator prãmte. ");
INSERT INTO ram_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Ne cute me hàkruan to ramã me pahkrã jimoc kam pyt to me hajỹr to mõ. Mã Erij te me ahna xwỳ kam ihtẽm, ne me cumã harkwa to: — Ca cormã kyre pê ame acaràr, me acaràr to mehtỳaj ne — hajỹr. Ne me ahna ahtũm ryre mã hacpỹ ma mã cute me cumãn kam ihtẽm, ne me cumã harkwa to: — Me gõ pahhiti pê Pahar ita mã me acaràr to ihtỳaj ne, mãr quê me akampa. Mõrmõ cormã apu jũm mã ihcakôc, na ri nee cute me apar nare. Nare, mõrmõ ma ihkwỳr xà wỳr mõ, nare, mõrmõ ma jũ kam ihtẽm xà ata na tẽ, nare, mõrmõ ihtỳj nõ ne gõr, na ca ha ate mehcujrõn xà na me akrãhhia kam me cumã me acaràr! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Mã mehkrãhhia kam me cumã me caràr, ne cute amji kam me hapac xàa na, ihtỳj wapo xwahhihti to me amji jĩ jakep, ne me hõ kruwxwa to me amji caxwỳ, ne ajco me amji caprô jaxwỳr to me ipa. ");
INSERT INTO ram_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Ne cute me caràr tỳj ita to me pyt to mõ. Mã nee me hõ pahpãm cahàc pê Pahar ata te mempar ne me cumã jũ mãn nare, ne nee cute me caràr par nare, ne nee jũm par nare. Ne hamre, ramã pyt pec to mõr xà ata kam ri, quêt me Pahpãm peaj mã cute me ampo to caxàr xàa kam hàhhuc. ");
INSERT INTO ram_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Mã Erij te mehcunea mã hàkjêr to: — Ajpên me mõ, ne me ina ahtipre ne, mãr ca ahna me ipupun peaj ne — hajỹr. Ne cormã cute ame Pahpãm mã ampo to caxàr xà hur ata to impej kwỳa kam, mã cute ahna me cuprõn. ");
INSERT INTO ram_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Mã cute kẽn te tôxi atajê japỳn. Ne kẽn atajê pê ahpỹanre na me hakrã pê Ixaher kra te tôxi atajê. ");
INSERT INTO ram_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Ne Pahpãm jarkwa kôt cute ahpỹanre na Ixaher kra atajê na kẽn te tôxi atajê nõr par, Pahpãm mã cute ampo to caxàr xà to impej prãmte. Jirô pê mã ri hõtpê cute ipu na cô mã hahkwỳn to kre ryre. ");
INSERT INTO ram_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Ne cute kẽn jipy pĩ kwỳ jakôt, ne kam pryti jĩ kryj ne hakôt, ne cumã harkwa to: — Me cô jacjên xà catia nõ to me cwat, ne me to hipu, ne pryti jĩ kam me haxwỳ, ne pĩ kam me haxwỳ, ne me to inco tu ne — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Mã cute me ton jirô pê, hipêr cute me cumã harkwa to: — Hipêr kam me cô kwỳ jaxwỳ — hajỹr. Mã cute hipêr kam me haxwỳr. Mã hipêr me cumã: — Kam me haxwỳr to incrê mã — hane. Mã cute hipêr kam me haxwỳr. ");
INSERT INTO ram_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Mã kẽn te tôxi atajê kam pryti jĩ ata pĩn, cô ajxwỳ ne tàkamrỳ cute ipu na kre jahkwỳn ata to hipu. ");
INSERT INTO ram_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Mã pyt pec kam, cute me Pahpãm mã ampo to caxàr xà to me amji pyràc xà ata kam hàhhuc. Mã Erij xãm ne mõ, ne Pahpãm mã ampo to caxàr xà jĩkjê rũm hàhhuc ne xa, ne Pahpãm mã ihcakôc, ne cumã: — Hàpà, me ijõ Pahhiti. Por apê Aprãw me, Ixac me, Ixaher pê me apynã atajê jõ Pahpãm. Ne ita kam me cumã apê Ixaher catêjê jõ Pahpãm na amji to ajpẽ, ne hanea ne ipê amã ijàpên catê na me cumã ito ajpẽ. Pom ite ampo cunea ton itajê, wa nee amjia kôt ite ton nare, ne garkwa kôt wa ite ton! ");
INSERT INTO ram_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Ijõ Pahhiti ikampa, mãr quê itajê cunea apê ampeaj kam Pahhiti pê Pahpãm na, me gahkre pej, ne caa pê ca, amji wỳr, amji mã mehĩ to apkjê — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Me ajkaam mã côjkwa pĩn cuhy pỳm! Ne cute pryti me pĩ to caxàr, ne kẽn to caxàr, ne pjênxôm to caxàr, ne hanea ne cute cô to incrà tu, kre ata kam! ");
INSERT INTO ram_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Mã mehcunea te me ita pupun, ne hũpate, pjê kam, mehcunea mehkuc to mehpỳm, ne me hũjarẽn to: — Côjkwa kam me pajõ Pahhiti ita pê ri Pahpãam to Pahpãm! Côjkwa kam me pajõ Pahhiti ita pê ri Pahpãam to Pahpãm! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Mã Erij te me cumã harkwa to: — Me pahpãm cahàc krekà pê Pahar mã me hàpên catêjê cunea pro, mãr quê nee jũ kam jũm pyxit ne ihtẽm nare! — hajỹr. Mã cute mehcunea pro, mã ma Erij Quixõ jõ kàj mã nõre wỳr me to mõ, ne curi cute mehcunea jipej. ");
INSERT INTO ram_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Mã Erij te Acapê mã harkwa to: — Ita caxuw gapacta ne tẽ ne apà ne ikõ. Ampo na? He ramã ite ta nõ pahtỳjti jàhkrihkrit kam ijapac, mã ajpên mõ! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Mã ma Acapê tẽ, hỹr ne hàpàn ne ihkõm prãmte. Mã ma Erij Carer jõ kẽnti ata jimoac wỳr cumã hàpên catê me hàpir, ne pjê kam hỹr, ne cute ihkuc to ihkõn krã catêc ne to jỹ. ");
INSERT INTO ram_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Jirô pê mã ri cute cumã hàpên catê mã harkwa to: — Mõ ne côxwa wỳr rĩt! — hajỹr. Mã ma tẽ, ne irĩt ne hacpỹa ne cute Erij wỳr amji jaxàr ne cumã: — Wa nee ite ampo pupun nare — hajỹr. Mã Erij te ampo pupun xà atawỳr ihkujahêc to xet, mã cute amji jacjên to xet. ");
INSERT INTO ram_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Mã cumã hàpên catê te amji jacjên to xet ita kam ri, cute cumã hũjarẽn to: — Wa ite côxwa pĩn ahcakrã nõ incrire pê me hũmre jũhkra pyràcti incrire jàpir to mõr na hõmpun — hajỹr. Mã Erij te cumã hàpên catê ata mã: — Atẽm pyrentu, ne Acapê mã awjarẽ, quê hõ cawrô jõ kàhà kam jỹ, ne kẽnti pê to wrỳ, mãr quê nee côhtàm cupê pry jahêr nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Mã nee harkwa cràre nare. Ne côjkwa kam awcapàtkô pyrentu, ahcakrã kam. Mã kôc pahtỳjti ata cator, ne pahhàjê kypê iwrỳc nare. Mã Acapê hũjarêan kam Jexer jõ krĩ wỳr ihtẽam to tẽ. ");
INSERT INTO ram_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Mã Pahpãm te Erij mã ipicahur xà caxuw, carôt tỳj jõr. Mã cute Acapê jakren, ne ma mam hamrea kam tẽ, ne mam Jexer jõ krĩ mã cator. ");
INSERT INTO ram_vpl VALUES ("R220_1","015_20_1","2CH","20","1","1","Pê harã mã hĩkjê pê Juta jõ pjê kam Joxap pê Xarômãw xwỳ tàmxwỳ tàmxwỳ nõ, ne cupê Juta catêjê jõ pahhi. Ne ajco catyt kam Pahpãm jarkwa kôt ipa, na pê Pahpãm ajco ihtehcajpar to ipa. Ne amcro nõ na Mowap catêjê jõ krãhtare me, Amonit catêjê jõ krãhtare me, Etõ catêjê te, ma pahhi Joxap me, Juta catêjê wỳr me harkwa kujahêc, ne me cumã: — Wa ha me gapu ne me ato hamre tu — hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_2","015_20_2","2CH","20","2","2","Mã pahhi Joxap wỳr hanea ne cute me harẽn catêjê cator, ne me cumã: — Ihmat rũm ajpên Côxwatycti jĩkjê pĩn krãhtare jàhtôa ne me cator, Xiri jõ pjê me, Geti jõ cô kôt pjê ata pĩn — hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_3","015_20_3","2CH","20","3","3","Mã Joxap te me harẽn par, mã cupê amji jahkre kêatre, ne cumã pa. Mã cute amji tehcajpar xà na Pahpãm wỳr na amji kam hapac, ne Juta catêjê cunea mã harẽn to hajỹr he: — Cu ha me pajàpàn nare kam, Pahpãm mã me pahcakôc ne cumã me amji cajrẽn, me pamã amji kĩn nare kam — hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_4","015_20_4","2CH","20","4","4","Mã cute me kam hapac ne Juta jõ pjê kam krĩ cunea pĩn, Krĩpinkrên wỳr me cator, cute me cahê na me ipijacri xà ata kam me Pahpãm te mehtehcajpar xà na hàhwỳr prãmte. ");
INSERT INTO ram_vpl VALUES ("R220_5","015_20_5","2CH","20","5","5","Mã Joxap mehcunea jipôc ri hãm, cute Pahpãm to me amji kam hapac xà jũrkwa tuw kam, ne Pahpãm mã ihcakôc to: ");
INSERT INTO ram_vpl VALUES ("R220_6","015_20_6","2CH","20","6","6","— Me ijõ Pahhiti pê me iquêtjê jõ Pahpãm! He apyxit peaj ne côjkwa kam apê Pahhiti, ne apê pjê cunea kam Pahhiti. Ne apê pjê cunea kam pahhi catêjê cunea jõ Pahhiti. Ne ampeaj kam acarôt tỳj, ne ampeaj kam quêt atỳj. Ne jũm quê ato cô? Hamreare! ");
INSERT INTO ram_vpl VALUES ("R220_7","015_20_7","2CH","20","7","7","Me ijõ Pahpãm, pom pê ca pjê ita kam mehkrĩ catêjê to me akwỳ mã to hamre ita? Ne akwỳ nõ Aprãw tàmxwỳ catêjê mã, pê ca pjê ita to awjahkre, mãr quê me to hõ tekjê rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("R220_8","015_20_8","2CH","20","8","8","Ne me akwỳ itajê mehkrĩ, ne cute gaprỳ to me cati prãmte me amã gũrkwa ita xãm, ne me amã amji jarẽn to hajỹr he: ");
INSERT INTO ram_vpl VALUES ("R220_9","015_20_9","2CH","20","9","9","“Quê ha me ikam me ixà nõ cato, nare, quê ha me ipijapu xà nõ cato, nare, prãm cato, wa ha itỳj gũrkwa ita kam me acuna mã me icuhhê, ne ate itehcajpar xà na me ana ahwỳ, ca ha atỳj me ikampa ne me ikên xà nõ itajê pê me ipytà” hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_10","015_20_10","2CH","20","10","10","Ne ita caxuw, pjê incrê pĩn ajpên cute me ito hamre xà caxuw me mõr na, ca me hõmpu. Ne pjê incrê atajêa inquêtjê tête, pê came iquêtjê jiprõ, pê nee me hipej nare, Ejit jõ pjê pĩn me cator xà ata kam, ne quêt cama me ipu na me ajrõ. ");
INSERT INTO ram_vpl VALUES ("R220_11","015_20_11","2CH","20","11","11","Ne hamre, ita kam mehtàmxwỳ te me iquêtjê kĩnte, me ijipej to prãm to ajpên me mõr na, ca me hõmpu he! Hamre, ramã cute, pom ate me imã pjê jõr ita tête me icator xàa caxuw ri, ajpên me mõ. ");
INSERT INTO ram_vpl VALUES ("R220_12","015_20_12","2CH","20","12","12","Me ijõ Pahpãm, ca ha me hõmpu ne me to amji kampa, ne me imã jũ mã me to, ne me cupê me ipytà. Ampo na? Me ipê krãhtare pahtỳjti ita pê jũ mã ite me amji ton, ne me cupê me amji pytàr xà jahkre kêatre cakrô, wa itỳj apê me ijõ Pahhiti te me cupê me ipytàr na me gikaj — hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_13","015_20_13","2CH","20","13","13","Ne Juta jõ pjê cunea pĩn me hũmre cunea me, mehprõ me, mehkra mea mã cute me cuprõn, ne Pahpãm cuna mã me hãm. ");
INSERT INTO ram_vpl VALUES ("R220_14","015_20_14","2CH","20","14","14","Mã Pahhiti Carõ Pejti ata mehcote na jũm xũmre nõ japrỳ te Jajiwer ata mã amji jõr, mã cute mehcunea mã harkwa kôt hũjarẽn to hajỹr he: ");
INSERT INTO ram_vpl VALUES ("R220_15","015_20_15","2CH","20","15","15","— Me acunea me apê Juta catêjê me, Krĩpinkrên catêjê me, pahhi Joxap me, me acunea me ikampa! Pahpãm pê Pahhiti te me pamã hũjarẽn to hajỹr he: “Nee ca ame pa nare! Ne nee krãhtare jàhtôa to hàhtô ne carôt tỳjti ita jarẽn par xà to ame amji mã me apec xà crỳn nare! He me ipijapu xà ita, nee cupê me atekjê nare, ne cupê ipê me Apãm Cati tekjê, wa ha pa me to amji pytà. ");
INSERT INTO ram_vpl VALUES ("R220_16","015_20_16","2CH","20","16","16","“Ne apẽ quê ha Xic jõ caprũm jatuj xà kôt, me awỳr kàj mã me mõ, ca ha ajpẽan kam, ajpẽn wỳr ahpar mã me mõ, ne Xeruwew jõ põ jahkà kam me ajpẽn cajpa, ne cama me ajpẽn to xa. ");
INSERT INTO ram_vpl VALUES ("R220_17","015_20_17","2CH","20","17","17","Ne nee ame apijapu nare, ca ha cama ame acuhhê ne ite me apytàr xà ita na, me ipupu. Me apê Juta catêjê me, me apê Krĩpinkrên catêjê me, nee ca ame hũpa nare, ne nee ca ame apeacre nare! Ca ha apẽ na curi me hỹrmã me mõ, wa ha hanea ne ipê me gõ Pahhiti me acahê na me hỹrmã mõ” hane — hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_18","015_20_18","2CH","20","18","18","Mã pahhi Joxap jũpar, ne Pahpãm to cati prãmte, pjê kam ihkõn krã to ihpỳm. Mã Juta catêjê me, Krĩpinkrên catêjê te me hajỹar, ne ame Pahpãm kĩn to amji kampa. ");
INSERT INTO ram_vpl VALUES ("R220_19","015_20_19","2CH","20","19","19","Jirô pê mã ri Rewi catêjê pê Cowat me Côre tàmxwỳ tàmxwỳ atajê te me amji to caprãr ne me xa, cute me Ixaher jõ Pahpãm pê me hõ Pahhiti cati na ame harẽn prãmte, ne kypê me cumã mencrer nare, cute me harẽn xàa to. ");
INSERT INTO ram_vpl VALUES ("R220_20","015_20_20","2CH","20","20","20","Mã apẽ mã iràràtia na, ma Juta jõ krãhtare me hỹrmã põ ata wỳr me mõ, mã pry kôt Joxap jàhhuc ne cute me hapackre to: — Me ikampa, me apê Juta catêjê me, me apê Krĩpinkrên catêjê, Pahhiti pê me pajõ Pahpãm to, ca amji mã me ahimpej kam me to acrà tu ne, quê ha taa me apytà! Ne Pahpãm jarkwa to mehcakôc catêjê to me amji mã me ahimpeaj ne, quê ha ampo cunea me pamã impej pit! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("R220_21","015_20_21","2CH","20","21","21","Ne cute ame hõ pahhi catêjê cunea me, me ajpẽn par jirô pê mã ri, Pahpãm mã mencrer kam cute me to ihtẽm, ne ma me cumã increr to mõ, ne mencrer xà kôt me to cahi rẽn to mõ. Mã mam mencrer catêjê mencrer to mõ. Ne cute me to increr catêjê kà itajê ajteare mã, ne Pahpãm to amji kam me hapac xà caxuw pit mã impej, mã me cumã increr to: “Hõtpê ampeaj kam, me amã ikĩn rohnỳtti mã pyrên me ijakry!” to hajỹr to mõr kwỳa kam, cute me Pahpãm mã amji jarẽn, pry kôt. ");
INSERT INTO ram_vpl VALUES ("R220_22","015_20_22","2CH","20","22","22","Ne cute me Pahpãm mã mencrer kam ihtẽm, me ajkaam mã Pahpãm te Amonit me, Mowap me, Etõ jõ krãhtare te ame ipijapu na me ton. Mã cutea me ajpẽn kam ihtẽm, ne me cutea me amji jipej tu, ne me amji to hamre tu. ");
INSERT INTO ram_vpl VALUES ("R220_23","015_20_23","2CH","20","23","23","Mã Amonit catêjê me, Mowap catêjê te Etõ catêjê kam mehtẽm ne cute me hipej tu. Jirô pê mã ri cute ajpẽn kam mencryc ne me ajpẽn kam ihtẽm, ne cute me ajpẽn jipej tu! ");
INSERT INTO ram_vpl VALUES ("R220_24","015_20_24","2CH","20","24","24","Mã ma Juta catêjê hawênti nõ kàa na me hàpir, ne ahpar mã me irĩt, ne cute me pjê kam mehtyc pit pupun, mã pjê kam mehtyc pit ame hikwa. Ne nee krãhtare pê me curê xwỳn catêjê atajê nõ cator ne ihtĩr nare, ne cute amjia kôt me amji jipej tu. ");
INSERT INTO ram_vpl VALUES ("R220_25","015_20_25","2CH","20","25","25","Mã pahhi Joxap na kjêjê me hỹrmã me cator, ne cute me krãhtare tyc catêjê pê me hàhcukrêj cunea to me cutor tu, ne me to ihcuhkwỳr he. Ne cute me ampo na hĩ jàhwỳrti atajê to ame amji jahêr partu. Ne cute me ampo itajê to me ipa to me amcro to incrê! ");
INSERT INTO ram_vpl VALUES ("R220_26","015_20_26","2CH","20","26","26","Ne me ahna amcro te cwat kam ri Perac jõ caprũm kam cute me cuprõn, ne Pahpãm catihti na me cumã harẽn. Cwỳrjapê ri cormã ita kam caprũm ita japrỳ te “Pahpãm to me cati xà jõ caprũm”. ");
INSERT INTO ram_vpl VALUES ("R220_27","015_20_27","2CH","20","27","27","Ne ma cute me amji jaxàr, Krĩpinkrên wỳr, mã Joxap mehkwỳ mã mam mõ, ne ampeaj kam me cumã amji kĩn. Ampo na? Pahpãm te me curê xwỳn pê hũtàr xà impejti ata to me hũtàr na ri. ");
INSERT INTO ram_vpl VALUES ("R220_28","015_20_28","2CH","20","28","28","Ne me cahi rẽn to mõ, ne Krĩpinkrên mã me hàr, mã mehkôt me hàkôr xà japàre me, hõhhi me pàtwỳ to me hàkôr to me mõ, ne me catyatre na Pahpãm to cute me amji japackre xà jũrkwa wỳr me mõ. ");
INSERT INTO ram_vpl VALUES ("R220_29","015_20_29","2CH","20","29","29","Mã pjê kwỳ jõ pahhi catêjê te me Ixaher catêjê jõ Pahpãm te mentête me curê xwỳn catêjê cunea jipej na me harẽn par, ne ampeaj kam me cumã Pahpãm cupa. ");
INSERT INTO ram_vpl VALUES ("R220_30","015_20_30","2CH","20","30","30","Hõ, ita na pê Pahpãm Joxap himpej xà carĩcti na to, mã kam ahcarĩcti. Pê nee hipêr me curê xwỳn nõ me kam ihtẽm nare. Hamre.");
INSERT INTO ram_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ỹhỹ me ikwỳ, ca hãn ne me icukij to: “Jũ mã cu ajte ame, ne ame pajakryti, ne me pamã amji kĩnti ne?” hane. Ne ite me gapackre xà ita na, me ikampa he: Ca ha nee mehkrã kên catêjê te me pajapackre xà na, me amji to pôj nare. Ne nee mehkrã kên catêjê te amji kam hapac xà kôt, me amji ton nare. Ne nee hanea ne, cute me Pahpãm to me amji japackre prãm nare, mã cama me ahna xwỳ xi atajê kwỳ mã me acjêj nare. Ampo na? Ca ha ate me krã kên kôt me ampo itajê ton to me apa na, ca ha nee jũ caxuw me amã amji kĩnti nare. ");
INSERT INTO ram_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Ca ha quêt me hane he: Ca ha atỳj me amã amji kĩan kam, me amã ihkàhhôc cahyt prãam kam, me Pahpãm jarkwa pejti ita cahyt, ne ihkôat me apa. Ne amcro me caxwa cunea kam, ca ha Pahpãm jarkwa cupahti jõ kàhhôc ita cahyt, ne ampeaj kam ihkôt me hakop to me apa. Ne ate ihkôt hakop xà ata kam, ca ha atỳj me gakry, ne me amã amji kĩnti kam me apa. ");
INSERT INTO ram_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Ne ca ha me apê cô tohkà na pĩxô pàr amji to ajpa ata pyràac. Por pĩxô pàr hô xà jõ amcroa kam hãn ne hô, ne ampeaj kam ihrôt, ne nee jũ caxuw ihhô incrà nare. Ata jĩkjê na, ca ha Pahpãm jarkwa cahyt ne ihkôt hakop, ne catyt kam ihkôt apa na, ca ha ampo cunea to me apê ata, quê ha ihtỳj ahnaa me amã, ne nee jũ caxuw me apê ihkôt hamre nare. ");
INSERT INTO ram_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Nãmri ca ha ate ma ame amji pê Pahpãm jarkwa curê na, ca ha me apê mehkrã kên catêjê atajê pyràac, ne nee me apê pĩxô pàr pejti ata pyràc nare. Ampo na? He mehkrã kên atajê pê arỳjhy krekà pyràac, mã ihtỳj kôc mehcarê. ");
INSERT INTO ram_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Jĩkjê na, quê ha Pahpãm mehkrã kên atajê kên mã me curẽ, ne quêt amji mã me to hõ tekjê catêjê juwahi. ");
INSERT INTO ram_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Quê ha ihtỳj catyt kam me ipa catêjê atajê jamã, ne mehkên pê me hũtà. Ne mehkrã kên catêjê, quê ha mehkĩnte ame to kêanre ne, quê ha me acto. ");
INSERT INTO ram_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Ampo na mã amji caprỳ to krĩxàre kôt ame côjkwa kam Pahhiti pê Pahpãm kam mencryc, ne cute ame hapu prãmte ame cuprõ? Jũ wỳr quê ame amji mã hamã. ");
INSERT INTO ram_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Ne ampo na mã me cupê mehcahkrit atajê jõ pahhi kwỳ, hãn ne Pahhiti te me cumã hõ pahhi xãm ata cuna mã ame cuprõ, ne ahna ame ajpẽn pa? Ne me hõ pahhi catêjê me amji to cuprõ, ne tee ahna me ajpẽn cukij to: “Jũ mã cu ha ajte me, ne cute me pahto ihhimpej xà ita pê me pahcato?” hane. ");
INSERT INTO ram_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Ne amji caprỳ to me amji mã: “Jũ wỳr cu ha me harkwa kôt ame papa! Ne nee quê ha me cupê me pajõ pahhi nare! Ne nee cu ha me pahnõ amji mã me hũpa to ame papa nare! Quê ha pea cute me pahto ihhimpej xà ita caxuw me cupê me carôt hamre, na cu ha pahtỳj ame papa” hane. ");
INSERT INTO ram_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Mã côjkwa kam Pahhiti, cute me to ihhimpej xà krĩ xà impejti ata kam jỹ, ne nee me harkwa ita kam apu amji to hàptõ nare, ne cama ame ahna acxa, ne ame ahna xwỳ, ne amji mã: “Me cumã ipar prãm nare catêjê amji caprỳ to ame ijũhhyr prãm, ne jũ wỳr quê me ito cô, ne me ijũhta” hane. ");
INSERT INTO ram_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","6","Pahhiti te me cumã me hõ pahhi xãm, mã mehkwỳ ma amehcaca atajê kam ri incryac to incryc. Na quê ha ihtỳj jũ caxuw incryac kam, ame cumãn kam tẽ, ne me cumã: “He itea wa amji mã me gõ pahhi ata capi, cupê pjê cunea kam me gõ pahhi xà caxuw! Ne quê ha ihtỳj Xijãw jõ kẽn kam ihkrĩ xà ata kam ihkrĩ, quê ha pjê cunea kam mehcunea me kampa!” hane. Quê ha me hũpar nare atajê me kampa, ne ampeaj kam me cumã hũpaa to hũpa, ne mehkrã acto tu ne. ");
INSERT INTO ram_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Mã Pahhiti te pjê cunea caxuw, me cumã me hõ pahhi xãm ata te mehkwỳ mã amji jarẽn to: “Wa ha Pahhiti te ito hũjarẽn xà ata kôt me amã harẽ. He cute cumã: ‘Apê ikra, ne ita caxuw ipê Apãm Cati. ");
INSERT INTO ram_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Na ca ha ate mehcunea to ahimpej xà caxuw ina ahwỳ. Wa ha amã krĩxàre cunea jahkre ne amã cugõ, ca ha me to ahimpej to apa, quê ha me akampa. ");
INSERT INTO ram_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ne ca ha acarôt tỳjti ita to me to ahimpej to ihtỳaj to apa. Ne me hũpar nare atajê, ca ha me to pjê te pot pyràac, ne cute me amji kam me hapac xà kên mea mã, me kam acryac kam me gãn partu’ hane”. Hõ, pê Pahhiti me to hũjarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Cwỳrjapê ca ha me apê pjê jõ pahhi catêjê, me amji to akrã kre japêa ne me ikampa! Ne me apê me to ahimpej catêjê cunea, ajco me ikam gapac peaj ne! ");
INSERT INTO ram_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Na ca ha amji mã me Pahhiti cupa to kryjre nare. Ne ate amji mã hũpahti na cute gahkre pej prãmte, ca ha cuna mã akõn krã na jỹ, ne cumã amji jarẽn to: “Wa ha ite amji kam ijapac xà cunea kam, itỳj ihcunea na akampa” hane. ");
INSERT INTO ram_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Hõhõ, ca ha ita to hajỹr nare na, quê ha ihprõt pê akam incryc pyrentu, ne ihtỳj akên catia mã amẽ, ca ha gamre. Ne por me amji pytàr prãmte, Pahhiti wỳr me pra atajê, quê ha quêt ame hakry. ");
INSERT INTO ram_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Ỹhỹ côjkwa kam Pahhiti, apê me ijõ Pahhiti. Ne ampeaj kam pjê cunea kam, mehcunea mã gaprỳ ita catia to cati, ne impeaj to impej! Apej cati ita pê ihhêj rũm pyt me côjkwa jàhcujro pyràac, ne ampo cunea jirôa pê cati ne impej. ");
INSERT INTO ram_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Mã mehcunea acatihti ita na ihtỳj me ana cre, me ahkrare me, mehkà na kjê kryjre atajê mea mã. Ca ate me acurê xwỳn mã acarôt tỳjti ita to apipẽ, mãr quê acuna mã amehcuhhê catêjê atajê cunea carĩcti na me to, quê mehcarĩc. He ate me cupê amji tête gàmtàr, quê nee jũm, jũ mã aton nare. ");
INSERT INTO ram_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Wa hãn ne ate côjkwa ton ita wỳr rĩt, ne pom pê ca caa putwrỳ me caxêre to, ne ihkrĩ xàa kam ihkrĩ na me to, mã ihkrĩ atajê pupu. ");
INSERT INTO ram_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Wa ampo itajê pupu ne amji mã: “Pỳhàpà, he Pahpãm kĩnte me ipê me hũmre pit, ne taa mã ri quêt ampeaj kam cati. Ne mẽr ampo na mã, ma me ito amji japackre ne me ijamã?” Hõhõ, wa amji mã hane. ");
INSERT INTO ram_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Pê ca me ijĩa na me ito ixũmre. Ne ate, cute amji mã me icupahti xà to ate me cumãn to hajỹr, pom quê amji mã me pahhi cupa he. Ne apyxit peaj ne me ijirôa pê acati. ");
INSERT INTO ram_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ne ate, ite ampo cunea to me ihimpej xà na me ixãm. Ne ate ampo cunea ton itajê to ite me ihimpej, ne hirô pê me icuhhê na me iton. ");
INSERT INTO ram_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","8","Atajê pê carà cahàcti hôhti me, pryti me, hanea ne ahkêt jõ ampo jàprê itajê me, pryrejara me, tep me, hanea ne, pom cô kam ampo cunea amji to ajpa itajê cunea jirô pê me icuhhê xà na, ate me iton. ");
INSERT INTO ram_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Ỹhỹ Pahhiti, apê me ijõ Pahhiti! Ne ampeaj kam pjê cunea kam mehcunea mã gaprỳ ita catia to cati, ne impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Pom me amji mã: “Pahpãm nee ite amji kam me ijapac xà na, me ito amji japackre nare” hane. Itajê krã nare, ne cute amji kam me hapac xà maj pit. Ne ihcunea na mehkêanre. Ne nee jũm pyxit ne catyt kam ipa nare. ");
INSERT INTO ram_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Mã côjkwa kam Pahpãm ihkrĩ ne mehkôpĩ, ne tee apu jũm krã kreti te catyt kam ipa ata japê, ne nee cute jũm te to amji kam hapac ata mã cator nare. ");
INSERT INTO ram_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Mã mehcunea te me pry cupan, ne ihcunea na mehcunea kêanre, ne nee mehnõ pyxitre catyt kam ipa nare. Ne ampeaj kam ri, nee jũm catyt kam ipa nare! ");
INSERT INTO ram_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Ne Pahpãm te mehkrã kên itajê jarẽn to hajỹr he: “Imãa ihcunea na me cupê amji jahkre kêatre! Ne ihtỳj cute amji to me ipijapar xà caxuw, me ikwỳ pê me hàhkĩj to me ipa, ne nee jũ caxuw ite me to ipijapar xà na, amji mã me ina hàhwỳr nare” hane. ");
INSERT INTO ram_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Ne cute mehkên ton to me ipa xà ata kam, quê ha ihtỳj jũ caxuw Pahpãm cupate, amehterteat to amehtertet. Ampo na? Pahpãm ihtỳj catyt kam harkwa kôt me ipa catêjê cahê na ipa, ne ma me hamã. ");
INSERT INTO ram_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Mehkrã kên catêjê mã, ampeaj kam catyt kam me ipa atajê me, me cupê hamreare catêjê atajê cahpêrkàr prãm, mã ihtỳj Pahpãm me cupê mempej pytà. ");
INSERT INTO ram_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Wa itỳj Pahpãm mã me ikwỳ cajrẽn to hane he: “Ỹhỹ, ijõ Pahhiti. Jamã ne ca, ite me ato amji kam ijapac xà jũrkwa ita pĩn, me ijõ pjê cunea kam, me cupê me ikwỳ pê Ixaher catêjê te me icurê xwỳn atajê tohjê na, me itehcajpa” hane. Ỹhỹ, quê ha ampeaj kam me pajõ Pahhiti te hacpỹ mã me pampej pêa mã me papa na me pahton na, cu ha pahtỳj hũrên me pajakryti to me cumã cre, ne ampeaj kam me pamã amji kĩn. ");
INSERT INTO ram_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Pahhiti, apê me ijõ Pahpãm! Mẽr itajê cunea jipôc ri, jũmjê mã ca ha garkwa to: “Ajpên ijũrkwa wỳr me mõ, ne icahê na ame apa”? hane. Ne jũmjê mã ca ha garkwa to: “Ajpên ijõ hàpkàjti pê Xijãw ata na me api, ne kam me akrĩ, ne ito me amji kampa”? hane. ");
INSERT INTO ram_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Ne cute hajỹr he, quê ha jũm ihcunea na catyyt kam ipa, ne hãn ne ihcunea na akam hapac to ipa, ne ampo pej pit ton to ipa, ne ampeaj kam caxwãm catia mã, to ihcakôc to ipa ata, quê ha ma amã axà. ");
INSERT INTO ram_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Ne hanea ne nee amehkwỳ kôt harẽn hêj xi xà atajê jarẽn nare, ne nee hanea ne mehkwỳ kên mã me irẽn prãm nare, ne nee jũmjê jarẽn kên cràn to ipa nare ata, quê ha ma amã axà. ");
INSERT INTO ram_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Ỹhỹ ijõ Pahhiti, pom ca ha ma apu jũm kên curê ata, quê ha hanea ne ma jũm acuxà, apu jũm kên ata curê. Ne hanea ne, ihtỳj quêt cumã ihcunea na, catyt kam cute me apar catêjê atajê te amji mã acupahti xà. Ne quê ha jũm mã cute ampo na, amji to hũjahkre xà ata kam, ihkên mã hàr cakrô, ihtỳj cormã cute ahna cumã amji ton xà ata na to, ata quê ha amã axà. ");
INSERT INTO ram_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Ne hanea ne cute me cumã ampo jõr atajê, quê ha hacpỹ ne cute hõr xà ata na, taa pit cwa, ne nee hipy kam ihkwỳ mẽn nare. Ne hanea ne, quê jũm cumã, cute jũm pejti ata kôt harẽn kêanre to prãmte, cumã ampo gõ, quê ha nee ahna amji caxàr ne ipyr, ne hahpan xà na jũm pejti ata kên mã mẽn nare. Quê ha ma apu ampo jõr xà ata caca. Ỹhỹ ijõ Pahhiti, he cute me hajỹr catêjê, quê ha nee akrac ri ampo ihcaxun nare. Ne quê ha quêt catyt kam acahê na ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Ỹhỹ me ikwỳ, wa ha me amã ite Pahpãm to amji kam ijapac xà na harẽ. Cu me côjkwa pupu ita, ihtỳj hirã pê me pamã Pahpãm catia to cati na harẽ. Ne Pahpãam te ri kam caxêre me, kam ampo itajê cunea ton. ");
INSERT INTO ram_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Ne cu hãn ne amcro cunea kam, me pyt japôj xà na me hõmpu, ne amji mã me harẽn to: “Ampeaj kam ri Pahpãm mã ihtỳj ampo cunea ton xà” hane. Ne hanea ne cu caxwari côjkwa kam me caxêre me, putwrỳ pupu, ne hacpỹ ma mã me amji mã: “Nee Pahpãm mã ampo pyxit ne hahkre pej nare, ne cumã ampo cunea ton jahkre pej” hane. ");
INSERT INTO ram_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","He nee côjkwa kam ampo ihkrĩ itajê me pamã harkwa to ihcakôc nare, cakrô cu me rĩt ne me hõmpu atajê kôat, ramã me pamã Pahpãm catia to cati na hahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Ne côjkwa kam ampo pejti catihti itajê te amcro me caxwa cunea kam, ramã pjê cunea kam Pahpãm catia to cati na harẽn cràn. Ne nee jũ ri me cupê ita jahkre kêatre nare, ne mehcunea te me hahkre pej xà. Ne Pahpãm te côjkwa kam pyt mã ihkrĩ xà ton, mã kaam ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Ne pom cu me pajikwa tuw xà wỳr, me pamã amji kĩan kam me pahprõ wỳr me pra ita na ri cute, ne amcro cunea kam, ihkrĩ xà pê hapôj, ne cumã amji kĩan kam catyatre na ma hàpir to impraar to pra. ");
INSERT INTO ram_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Ne me pahnõ imprar tỳjti, mã ihcuhhê pê cumã ipicahur prãmti, jĩkjê na mã, hãn ne pyt hapôj pê ma cumã côjkwa cahpêrkàr to prãam kam, ihtỳj catyatre na ihcahpêrkà. Ne jũ wỳr quê jũm apu amji mã hamã, ne cacro pê amji to amxu, quê nee cacro nare. ");
INSERT INTO ram_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Ỹhỹ me ikwỳ, pom wa ite me amã harẽn ita jĩkjê na, cu nee me pahnõ amji mã hamã, ne Pahpãm pê me papimxur nare. Cwỳrjapê cu ha pahtỳj me pajõ Pahhiti jarkwa pejti, kam ampo kên nare ata kam, me pajapac na me amji to prãm. Ne cute me pajapackre xà ata, ihtỳj me pamã me pahcarôt to intuw. Ne quê ha me pahnõ pê hahkre kêatre, quê ha me pajõ Pahhiti te ampeaj kam me pamã harkwa jirên atajê pictor, ne ihkôt hamre xà nare atajêa to cumã hahkre, quê ha hahkre pej, na cu ha pahtỳj amji mã me to pahhimpej. ");
INSERT INTO ram_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Ne me pajõ Pahhiti te me pamã ampo to hahkre xà ata ri quêt catyt kam ihcuhtacti. Ne pahte me kam pajapac catêjê ri, ampeaj kam me pajakry. Ne cute me pajapackre xà kam ampo kên nare itajê, ihtỳj pahte ampo cunea jahkre pej na me pahto, cu me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Cu ha pahte amji mã Pahhiti cupahti to me papa na, cu ha kam me pajapac to me papa rohnỳtti mã. Ne me pajõ Pahhiti ita pê ihhêj xi jahkre kêatre, ne cumã ampo cunea jahkre pej. Cwỳrjapê quê ha mehcukij xà jõ amcro kam, cute jũm pejti na harẽn to: “Ampeaj kam jũm ita pej” hane. Ne hanea ne jũm krã kên ata jarẽn to: “Jũm ita krã kêanre” hane. ");
INSERT INTO ram_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Ne cu wakỳre prà tepti pê ôr na hĩ jàhwỳrti ata jirôa pê me Pahpãm jarkwa na prãm. Ne pen cacô jirôa pê ri Pahpãm jarkwa me pahcajpuaw. ");
INSERT INTO ram_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Ỹhỹ côjkwa kam ijõ Pahhiti pê Pahpãm. Ate ijapackre xà itajê te ipê ampo kên cunea cawpa, ne ikên mã ixàr cupate, cute intête ito hũjawry tu. Ne wa itỳj amji mã acupahti to ipa, ca cormã ita jipy, hahpan xà na ito impej. ");
INSERT INTO ram_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Ne wa hãn ne me to ihcupan xà na me amji jahkre pej nare kam, me to ihcupa, ne hãn ne imã garkwa itajê jahkre pej nare kam, hirô pê me ipỳpỳm to ipa ata to tojnõ, ne nee ca hahpan xà na ito kên nare. ");
INSERT INTO ram_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ne hanea ne ite garkwa jirô pê ipỳpỳm, ne garkwa kaj na ampo kên ton prãmti ata na ijamãr, wa ton nare. Ne intête ipê amtà, mãr quê nee ampo kên itajê ito ihhimpej nare. Ca ha ito hane, wa ha itỳj amã ipej, ne nee ampo kên pyxitre nõ ton nare, ca ha ina amji capa. ");
INSERT INTO ram_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Ijõ Pahhiti, apê ikên pê itête gàmtàr catê, na ca atỳj ikên xà cunea pê ipytà. Imã icakôc xà me, ite amji kam ijapac xà cunea te acajpuaw na to prãm. ");
INSERT INTO ram_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Inxũ Cati! Inxũ Cati! Ampo na mã ahte ate irer to hajỹr? Wa tee ate itehcajpar xà na icagãgãa kam ana ahwỳ, ca nee ate ipar nare! Ca ihhêj ne ipê ampỳa mã apu mõ. ");
INSERT INTO ram_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Wa ihcaprỳ na ite amã icwỳr to pyt, ne ite amã ijàkjêar to apẽ, ca nee ate imã jũ mãn nare. Cakrô wa itỳj cormã amã akij, ne nee wa ha uu ne ijàkjêr jicu nare. Wa cormã pa xàhte ikrihkrit ita na ikrĩ, ne ramã ijõt nare na, ina amcro jàhtô. ");
INSERT INTO ram_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Cakrô, wa itỳj ate apejti, mehcunea na atetetti to Pahhiti krĩ xà catihti ata kam gỹr na, imã gahkre pej. Ne Ixaher catêjê cunea acatihti na amji mã me garẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Pê me iquêtjê ihtỳj ajco amji mã me ato ihhimpej to me ipa, cwỳrjapê pê ca atỳj mehkên pê me to acato. ");
INSERT INTO ram_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Pê ajco me amã akij, pê ca ajco atỳj mehkên xà atajê pê me to gapôj. He nee cute ihcaprỳ na amji mã me ato ihhimpej nare. ");
INSERT INTO ram_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Ne mehkĩnte nee ipê me hũmre te ihkên xà pê amji pytàr xà ata nare. Ne ihhêj rũm ipê ampo cô pyràac, ne icrire, ne icarôt peacre. Mã mehcunea ame ixũn, ne ma amji tête ame icurê. ");
INSERT INTO ram_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Ne ame ipupu atajê cama ame ina xwỳ, ne ame ina acxa, ne me imã: “Gõ Pahhiti ita te ramã amã hikran! ");
INSERT INTO ram_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Pom ca ate gõ Pahhiti to amji mã hajỹr ita? Mẽr ampo na mã nee akên mã axàr xà ita pê cute ato cator nare? Quê gõ Pahhiti ita mã akĩn na mã, quê ha rỳ pêa mã atehcajpa, ne akên mã axàr xà ita pê apytà!” hane. Hõ, ame ina xwỳ to hane. ");
INSERT INTO ram_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Ne cute me ijarẽn to hajỹr cakrô, pê ca caa, ipỳm pêa mã, ajpên itehcajpar kam tẽ, ne imã icaca xà gõ, ne icrire naa mã ijamãr kam tẽ, ne cormã ijamãr to apa. ");
INSERT INTO ram_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Ne ipỳm pêa mã ri, ipê atekjê, ne apê ijõ Pahpãm rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ne hamre, wa ramã ikêan kam ipa, na ca nee irer ne ipê gũjawry nare. Ampo na? He nee aràn xà na jũm te itehcajpar xà caxuw hamreare. ");
INSERT INTO ram_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Ramã me icurê xwỳn catêjê te me ito kên prãmte me ikrãhtu, ne me cupê ihhêj rũm Paxã jõ pjê jõ pryti xũmti jàprêhti te apu ikam imprar atajê pyràac. ");
INSERT INTO ram_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Ne me cupê rop tycti hãn ne pryre mã wa japrã, ne cumã carõrõ, ne kam intoj ne ihcakê, ne ihcãmxa ita kôpit na mã, ihtỳj me ito kên to prãm. ");
INSERT INTO ram_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Ramã icarôt jamre xà ita pê ihhêj rũm cô te pjê kam ipijaxwỳr ne hamre. Ne ajpẽn kam ihi ihcuhhê xà itajê, ramã apu ajpẽn pê hapôj partu, ne ihcuhhê xà kaj na apu ihcuhhê. Ne ina cuhkõnre pê ihhêj rũm amcro te apu penhê to ihhorhot, ne ramã ipigãn to mõ. ");
INSERT INTO ram_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Ne ramã imã kôar to kôr, ne ijõkre kam ihhêj ne pjê jacrô ne incràre. Mã ijõhto te ijapto na impỳn ita kam, ca ihhêj ne ityc na apu icãmjĩ, ne ihhêj ne ate pjê jacrô ita kam irer. ");
INSERT INTO ram_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Ne mehkrã kên catêjê te me ito kên prãmte, me ina cuprõn. Ne me cupê ihhêj rũm rop te apu pryre na cuprõn ne ihkrã, ne ajpẽn pê ihcyt to ipa atajê pyràac. Ne ramã cute ame ipê ipar me ijũhkra caxwỳrti. ");
INSERT INTO ram_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ne wa icakrô te amji capô, ne ihire ita kam, quê ha ihtỳj me ihi cunea pupu. Ne me icurê xwỳn catêjê cama ame ikôpĩr to me ipa, ne ite amji pupun xà kêanre ita pyrên ame hakry. ");
INSERT INTO ram_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ne cute ikà to ajpẽn mã me ipicràn, ne ihkôt kẽn to ajpẽn pê me hũhkàr. ");
INSERT INTO ram_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Ijõ Pahhiti! Nee ca ipê gũjawry nare, ne apu awjarêa ne itehcajpa! He apêa ri ikên mã ixàr xà ita pê ipytàr catê! ");
INSERT INTO ram_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Ityc xà ita pê ipytà! Ne me icurê xwỳn pê me ikwỳ nare pê rop pyràc itajê pê ipytà. ");
INSERT INTO ram_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","He me cupê ihhêj rũm rop tycti pyràac, ne me wa te icaxwỳr xà ata pê ipytà! Ne jũ wỳr wa ahte me cupê ihhêj rũm pryti xũmti jàprê jĩpàr te icaxwỳr xà ata pê amji pytà! Ne caa, ca ha atỳj me icurê xwỳn itajê pê ipytà! ");
INSERT INTO ram_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ca ha ito hane, wa ha me ikwỳ cunea mã ate ikên mã ixàr xà ata pê ito acator na garẽ, ne itỳj cute me cuprõn xà kam mehcunea mã apejti na garẽ, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","“Me apê Pahhiti kôt me apa catêjê, ca ha me gõ Pahhiti to me gàmnãn prãmte me cumã: ‘Imã acupa hyre nare, na wa itỳj garkwa kôt ipa!’ hane. Ne me apê Jaco tàmxwỳ tàmxwỳ atajê, ate me amji mã Pahpãm cupa prãm to, ca ha me cumã: ‘Apeaj to apej! Ne ampo cunea jirôa pê acati!’ hane. Ne me apê Ixaher catêjê pê Pahpãm na mehkwỳ atajê, ca ha Pahpãm to ate me cati prãmte me cumã: ‘Apyxit peaj pê ri me ijõ Pahhiti pê Pahpãm!’ hane” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Ỹhỹ me ikwỳ, he Pahpãm nee amji tête me cupê hamreare atajê curê to ipa nare. Ne nee cute me amji pupun xà kêanre to me amji pupun to me ipa atajê to hãn ne hapac kêt nare. Ne nee me cupê amji to ipimxur to ipa nare. Na quê ha jũm amji tehcajpar xà na cumã akij, quê ha ihtỳj jũm ata kampa. ");
INSERT INTO ram_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Ỹhỹ Ijõ Pahhiti, pê wa ikên kam ipa xà ata kam amã: “Ate itehcajpar jahpan xà na, wa ha itỳj amã ampo gõ” hane. Cwỳrjapê wa ha cute me cuprõn xà kam, cute me ato amji kam hapac prãmti atajê cunea kam mare mã, amã ite ampo na amji ton xà ata to. ");
INSERT INTO ram_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Ne wa ha mehcunea mã amji kĩn nõ to, ne me cupê hamreare atajê mã harte. Quê ha me cumã akĩn atajê me amã: “Mehcunea jirô pê apej ne acati” hane. Na quê ha hõtpê amji to ipijapar pej rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Ỹhỹ me ikwỳ, quê ha pjê cunea kam krĩxàre Pahpãm to amji kampa, ne to amji japackre. Quê ha jũa ri amehkrĩ atajê, ihtỳj Pahpãm wỳr me apkjê. Ne quê ha ampo kra cunea me hõmpun xà ata kôt, Pahpãm to cute amji kam me hapac prãmte me cumã: “Apêa ri me ijõ Pahhiti, na ri mehcunea jirôa pê me imã me akĩn” hane. ");
INSERT INTO ram_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Pahpãm pê me pajõ Pahhiti, ne cupê pjê kam mehcunea to ihhimpej catê, ne ihtỳj ampo kra cunea to ihhimpej. ");
INSERT INTO ram_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Ne cute amji to me cati prãmti atajê, quê ha ihtỳj cuna mã mehpỳpỳm, ne mehkryjre na cumã me amji jarẽ. Ne cu me pahcunea me pahtyc to mõ atajê, quê ha Pahpãm cuna mã mehkõn krã na me jỹ ne me cumã: “Wa itỳj amji mã me acupa” hane. ");
INSERT INTO ram_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Na quê ha mehtàmxwỳ tàmxwỳ ihtỳj amji mã me hũpa, ne me kam hapac to me ipa, ne ihtỳj mehkra mã me Pahhiti jarẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Quê ha me kampa, ne hanea ne cormã nee mehpỳpỳm nare atajê mã me harẽn to: “Me pajõ Pahhiti pê Pahpãm pê ajco mehkwỳ kên mã mencjêj xà atajê pê me hũtà” hane. ");
INSERT INTO ram_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ihhêj rũm ipê carà cahàcre hôhti pyràac, mã Pahpãm pê ijamãr catê. Cwỳrjapê ri nee ipê ampo jamre nare. ");
INSERT INTO ram_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ne pom carà cahàcre hôhti jamãr catêjê cama hõ ahtu kukũmti rericre kam hikwa na hamã, mã kam hikwa, ita na mã Pahpãm ito, ne ihtỳj imã ite ijikwa ne ikôt xà ita gõ. Ne pom carà cahàcre hôhti jamãr catêjê cô pinkrinti wỳr, hõ carà cahàcre hôhti to ipa, mã to ikõ, ita na mã ihhêj ne Pahpãm ito, ne ihtỳj ite amji kam ijapac xà kam ikrihkritti ita to imã ihcarĩc, ne imã to ankrê. ");
INSERT INTO ram_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ne hõtpê imã, ite amji kam ijapac xà to intuw. Ne carà cahàcre jamãr catêjê hãn ne pry cuhtacti kôt catyt kam ipa na to, mã ihkôt ipa, ita kôpit na mã, Pahpãm catyt kam ite ipa na ito ipa, mãr wa ampo pej pit ton to ipa. Hõ, pê cute ijamãr na amji to awjahkre ata na mã ijamãr to ipa. ");
INSERT INTO ram_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ỹhỹ ijõ Inxũ Cati, pom hãn ne carà cahàcre hamãr catê cãmtà rũm, nee cumã awcapàtkô cupa nare, ita na mã ite. He apê ijamãr catê, ne wa itỳj akôt cormã caprũm kôt ityc xà jõ awcapàtkô jakren to ipa. Ne ca icumam apa ita kam ri, acãmtà rũm, nee imã ampo kên te icuran xà ata cupa nare. Ne pom carà cahàcre jamãr catêjê hõ parxare jamãr caxuw, hõ kôtàre incwa ne to ipa, mã curê xwỳn hỹrmã hapôj, mã kô ata to ihcura, ita na mã ate, ne ramã ate icurê xwỳn catêjê caxuw amji mã gàhcuprõn hiahpuro. Mã ihhêj ne, gõ kôtàre ma icurê xwỳn pê itête hàmtàr to ipa. Ne ca hanea ne gõ pĩcajrer ita to, prya kôt icapôr to apa. Na ri ate ijamãr xà ita pyrên, imã amji kĩnti. ");
INSERT INTO ram_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ne pom carà cahàcre jamãr catêjê, hãn ne ampo pê curê xwỳn atajê cunea jipôc ri cumã harte, ita kôpit na mã, ca ate cute me icurê xwỳn catêjê kam mare mã, gàpàn xà wỳr ijator. Ne ate ijator ita kam, quê nee me icurê xwỳn itajê nõ jũ mã iton nare. Ca hãn ne ina amji tohpôj to hanea, pom quê hãn ne me catia na me amji tohpôj he. Ne gõtpê ikõm xà kam imã ampo cacô impejti ata to hipu tu, mã ajxwỳ, ca imã agõ. ");
INSERT INTO ram_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ne quê ha amã ikĩnti itaa na, imã gahkre pej. Na ca ha imã gàhcajrẽn to axãm itaa na, wa ha ahnaa ty, ne itỳj gũrkwa kam amji to ipijapar rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Ỹhỹ me ikwỳ! Ampo pyrên cu ha ame pajakry? He Pahpãm te me pamã, por pahte harkwa jirô pê me pahpỳm, ne ihkaj na me pahkên xà ton atajê jicu, ne to tojnõ ne ihhur ata pyrên, cu ha ame pajakry. ");
INSERT INTO ram_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Por Pahpãm te ampo kên ton atajê na me pajarẽn kên nare atajê pyrên, cu ha ame pajakry. Por me pahcaxwãm pê me pahte amji kam me pajapac xà hêj xi nare atajê pyrên, cu ha ame pajakry. ");
INSERT INTO ram_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ne pê wa cumã ite ikên ton xà to icakôc nare ri mã, ajco amcro cunea kam icwỳr to amji pectu, ne ipeacre. ");
INSERT INTO ram_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Ỹhỹ, ijõ Inxũ pê Pahpãm, wa itỳj ite ikên ton jahpan xà na, ajco amcro me caxwa cunea kam ate ito kên xà atajê cajpẽ, ne ramã ipê icarôt jamre to mõr te hajỹar, pom quê pyt cacro atàr to incrà to ipa he. ");
INSERT INTO ram_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Jicu xà kam, pê wa amji mã: “Wa ha Pahpãm mã ite to kên na amji jarẽ” hane. Pê wa amã ikên xà cunea na amji jarẽ. Ne nee pê wa ite ampo kên ton xà atajê nõ to apê ipimxur nare. Ne ite amã ihcunea to icakôc xà ata kam, pê ca ampo to ite ato kên atajê cunea to tojnõ, ne hicu. ");
INSERT INTO ram_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Ne por mehcunea mã akĩn, mã amji mã me ato ihhimpej atajê te ri, ihtỳj me amã amji cajrẽn to ipa xà. Mãr quê jũ caxuw me hỹrmã ampo kên catia te cator xà ata kam, nee cute me amã amji cajrẽn catêjê wỳr cator nare. ");
INSERT INTO ram_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","He apêa ri ito apimxur catê. Ca ampo kên atajê cunea pê ito amxu ne itête amtà. Wa ate itête me cupê gàmtàr xà ita pyrên ijakry to kỳj cati pêa mã, amã cre. ");
INSERT INTO ram_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Ỹhỹ me ikwỳ, Pahpãm te me pamã amji jarẽn to: “Wa ha jũ ri me amõr xà ata jõ pry to me amã hahkre, ca ha ihkôt me mõ. Wa ha pa me gapackre, ne me gamãr to mõ. ");
INSERT INTO ram_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Na ca ha nee me apê cawrô me, cawrô cahàcre jũpar nare atajê te mempar prãmte, mehkrã na hê, ne jũ kam me to mõr xà ata wỳr mehkjên to me ipa atajê pyràc nare” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Ỹhỹ me ikwỳ, ampeaj kam ri, mehkên catêjê hãn ne me amji pupun kên to ihkryjre nare. Ne quêt me Pahpãm to amji mã mehhimpej catêjê atajê ri, Pahpãm te me to ihhêj rũm pryjara pyràc, ne ma mentête hara to kwỳc to ipa ita na, ampo kên atajê cupate. Ne ihtỳj hàhcajrẽan kam, cumã mehkĩan kam, mentête hàmtàr to ipa. ");
INSERT INTO ram_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Ne pom ca me acunea catyt kam me apa atajê, me acunea me gakry! Ne Pahpãm te me ato impejti xà atajê pyrên hanea ne me amã amji kĩan ne! Pom ca me amji mã kam gapac pejti, ne catyt kam me apa itajê, me gakrya ne, ne pom me gakryti itajê to, me cumã cre! ");
INSERT INTO ram_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ỹhỹ me ikwỳ, por ca me acunea catyt kam me apa atajê, Pahpãm pyrên me gakrya ne. Mempejti catêjê te me Pahpãm mã catihti, ne impejti jarẽn xà ri quêt ahnaa. Na ca ha atỳj me cumã cati ne impejti jarẽ. ");
INSERT INTO ram_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Ca ha Pahpãm mã catihti ne impejti jarẽn xà ata kam, atỳj me cumã cre ne me gàkôr xà cakô, ne cumã cuhkõnre cakô. ");
INSERT INTO ram_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Ne Pahpãm mã me acrer xà intuwti to kỳj cati pêa mã, me cumã cre, ne cuhtõj cajrõn pejti ata to, ca ha me gakryti to me cumã cre. ");
INSERT INTO ram_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Ne mẽr ampo na mã cu ha me to hajỹr to prãm? Nee mã ampo na nare, he Pahpãm jarkwa pê ri quêt, ampeaj kam, ne catyt kam, ne quêt cute ampo cunea ton xà na, ihtỳj amji jarkwa na amji kampa. ");
INSERT INTO ram_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Ne Pahpãm mã, pjê kam mehkrĩ atajê cunea kĩn, mã me hamãr to impejti. Ne cumã ihtỳj catyt kam me ipa atajê kĩn, ne catyt kam, cute mehkwỳ to amji kam hapac na cumã me to prãm. ");
INSERT INTO ram_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Pê Pahpãm ihcakôc xàa to, cama ihcakôc, ne ramã côjkwa to, ne kam caxêre me ampo cunea ihkrĩ atajê to. ");
INSERT INTO ram_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Pê Pahpãm côxwa cunea to cuprõ, ne hỹr xàa kam hỹr, mãr quê hàhhuc tu rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","9","Pê cama Pahpãm pjê ton xà ata to cumã ihcakôc, pê ramã pjê amji to, ne ampo cunea te amji ton xà na cumã harkwa, pê ramã ampo cunea amji to. Na ca ha pjê cunea kam me akrĩ itajê, ate atỳj amji mã me Pahpãm cupa xà. He me pahcunea mã, pahte amji mã me Pahpãm cupahti kam me cumã amji jarẽn xà. ");
INSERT INTO ram_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Ne mẽr ampo na mã pahte me to hajỹr xà? Nee mã ampo na nare. Pahpãm ihtỳj krĩxàre te me ajpẽn par xà kêanre atajê to me cupê hamre, mãr quê nee ihkôt me ampo kên ton to me ipa nare. ");
INSERT INTO ram_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Ne quêt Pahpãm te ampo na amji ton xà ata ri, nee ihkôt hamre xà nare, ne ihtỳj quêt cute ahna amji ton xà, ne ahna to hãm ita na. ");
INSERT INTO ram_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Pê Pahpãm cute me pahto hõ tekjê xà caxuw amji mã me pahcapi, na ri hũrên me pajakryti. He ampeaj kam quê ha jũ ri, krĩ nõ kam, Pahpãm to amji mã me hõ Pahhiti, ne por toa amji mã mehhimpej atajê, quê ha ihtỳj hanea ne me hakry. ");
INSERT INTO ram_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Ne ampo na mã cu ha cumã cati me impejti to cumã me cre? Nee mã ampo na nare. Côjkwa pĩn Pahhiti pjê kam mehcunea mehkrĩ atajê cunea pupu. ");
INSERT INTO ram_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","15","Ne cutea ri me pamã pahte amji kam me pajapac xà ton, ne ihtỳj pahte me ampo cunea ton atajê na me pahpupu, ne kam amji kampa. Ne ihtỳj ihkrĩ xà ata pĩn pjê kam, por mehcunea mehkrĩ atajê pupu, cwỳrjapê cu ha pahtỳj me cumã cre. ");
INSERT INTO ram_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ne mẽr ampo na mã cu ha me cumã cre? Nee mã ampo na nare. Jũ wỳr quê Pahpãm krãhtare jõ pahhi tehcajpar nare kam, quê apu amji mã hamã, ne curê xwỳn tohjê. Ne quê ha tee krãhtare pahtỳj cakrô, quê Pahpãm cumã carôt jõr nare, quê nee ihtyc xà ata jahpan nare. ");
INSERT INTO ram_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Quê me pamã cawrô carôt tỳjti cati cakrô, jũ wỳr quê Pahpãm ihtehcajpar nare kam, quê cawrô ata me pahcurê xwỳn pê me pahpytà. ");
INSERT INTO ram_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Ne Pahpãm ihtỳj quêt amji mã me hũpahti atajê jamã. Cu ha me Pahpãm jàhcaprĩa kam, cumã me pahkĩn rohnỳtti mã ata te, me pahtehcajpar xà na aracri me hikaj, quê ha ihtỳj me pajamãr to ipa. ");
INSERT INTO ram_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Ne quê ha ihtỳj pahte me pahtyc xà jahpan na me pahto, cu ha me hahpa. Ne prãm catia te cator xà ata kam, quê ha nee prãm ata te me pajipej na hamãr nare. Ỹhỹ me ikwỳ, cu ha Pahpãm te me pahto impejti itajê cunea pyrên me pajakryti na cumã me amji jarẽ, ne cumã me cre to hane he. ");
INSERT INTO ram_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","“Ỹhỹ me ijõ Pahhiti, apê me itehcajpar catê, ne apê ampo kên pê itête gàmtàr catê. Na wa itỳj aracri ahna me gikaj to me ipa ita na. ");
INSERT INTO ram_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","He apyrêan ri me ijakryti. Na wa itỳj apejti ita to amji mã me ihimpej to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Ne wa itỳj cormã aracri me gikaj to ipa ita kam, ca ha gàhcaprĩa kam, amã me ikĩn ita na” hane. ");
INSERT INTO ram_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Ỹhỹ me ikwỳ, nee ca mehkrã kên catêjê jũ na ame akrihkrit to me apa nare. Ne nee ame hũ na cute mehkên ton atajê kĩn nare. ");
INSERT INTO ram_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Ampo na? He me cupê ahtu te êê ne apu incrà pyràac, quê ha me ahna ahtũm nare quê ha me hamre. He ampeaj kam ri me cupê põre pit, na quê ha ihtỳj me hamre tu. ");
INSERT INTO ram_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Ca ha côjkwa kam me Pahhiti pê Pahpãm to amji mã me ahimpej, ne me ampo pej pit ton to me apa. Mã cute me amã pjê jõr, ca kam me akrĩ, mã kam me atête ampo kên pê amtà. Ne ca ha hàmtàr xà ata kĩan kam, kam me akrĩ. ");
INSERT INTO ram_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ca ha Pahhiti cukwa kam, me amã amji kĩnti kam me apa na, quê ha ihtỳj me amã, ate amji mã me ampo na prãmti xà atajê cunea gõ. ");
INSERT INTO ram_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Ne ca ha Pahhiti mã me ate amji kam me gapac xà cunea gõ, mãr quê taa, ate amji kam me gapac xà to ihhimpej. Ne ca ha ate amji mã me to ahimpej to me apa na, quê ha me ato impejti to hane he. ");
INSERT INTO ram_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Pom quê pyt hapôj mã mehcunea me hàhcujro pupu, ita jĩkjê na, quê ha Pahhiti mehcunea te me apupun na me to, mãr quê cutea me ana amji caxàr na me gahkre pej. Ne me pahkrã jimoc kam pyt ihkrĩ, mã me ihprà pupu, ita jĩkjê na, quê ha Pahhiti ihtỳj mehcunea te catyt kam me apa na, cute me gahkre pej na me to, quê ha me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Na ca ha aracri, amji mã me aprĩa kam, me Pahhiti te me atehcajpar xà na me hikaj. Ne quê mehkrã kên catêjê hãn ne me ampo kên ton to me ipa xà ata kôt, amji to me cati to me ipa, ca ha nee me hũ na ame akrihkrit to me apa nare. ");
INSERT INTO ram_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ne nee ca ame kam acryc, ne me kam acàcàc nare. Ne nee ame hũ na ame akrihkrit nare. Ampo na? Ca ha ate, cute me ampo kên ton ata kam akrihkrit na, quê ha ihtỳj ate ampo kên ton wỳr ato mõ. ");
INSERT INTO ram_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Ne quê ha Pahhiti mehkrã kên atajê mõr pejti kam, me to hamre hiahpuro. Ne por ca quêt me Pahhiti te mehkên mã me hàr xà pê me hũtàr xà na me hikaj atajê, quê ha ihtỳj cute pjê to me cumã hũjahkre ata kam me amji to ajpa. ");
INSERT INTO ram_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Ne quê ha mehkrã kên atajê na ahtũm nare, quê ha me hamre partu. Ca ha tee ame hapê, ne nee hipêr me jũm mã acator nare. ");
INSERT INTO ram_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Ne quêt cute amji to mehkryjre prãm atajê, quê ha ihtỳj cute pjê to me cumã hũjahkre ata kam me amji to ajpa. Ne curia, quê ha mehcarĩcti kam, nee amji mã me ampo kên cupa nare kam me ipa. ");
INSERT INTO ram_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Ne mehkrã kên catêjê tee cute catyt kam me ipa itajê to kên prãmte, ahna ame ajpẽn kampa. Ne ihtỳj me kam incryac kam ame wa gyj to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Ne Pahhiti mã ramã mehkrã kêanre atajê jamre xà jõ amcro jahkre pej, na ri cama ame ahna acxa. ");
INSERT INTO ram_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Ne ramã mehkrã kên catêjê te me hõ wapo xwahhihti tohpôj, ne ramã me hõ cuhê na cute ame amji cohe, cute me cupê hamreare atajê me, catyt kam me ipa atajê jipej prãmte. ");
INSERT INTO ram_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Cakrô, quê ha nee me to hajỹr nare. He quê ha me hõ wapo xwahhihti atajêa me ahna cuhkõnre japôc, ne me hõ cuhê itajê, quê ha hanea ne me cupê impàt pa. ");
INSERT INTO ram_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Pahpãm mãa, catyt kam me ipa itajê pê ampo crêre atajê ri, mehkrã kên mã ampo jàhtôti itajê jirôa pê impej. ");
INSERT INTO ram_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Ampo na? He quê ha Pahhiti mehkrã kêanre atajê pê me carôt to hamre, ne quêt catyt kam me ipa atajê, quê ha mehtehcajpar to impeaj ne. ");
INSERT INTO ram_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Quê ha Pahhiti amcro cunea kam, catyt kam me ipa atajê jamãr to ipa, quê ha ihtỳj cute me cumã pjê jõr xà ata kam, amji to me ipijapar to me ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Ne quê ha me hỹrmã ampo kên catia te cator xà ata kam, quê ha nee me to hamre nare. Ne quê ha me hỹrmã prãm catia cato, quê ha ihtỳj me cumã hõ. ");
INSERT INTO ram_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Ne mehkrã kêanre catêjê, quê ha me acto tu. Ne Pahhiti curê xwỳn atajê, quê ha me cupê põ kam pĩrã pejti atajê pyràac, ne êê ne me hamre. Ne me cupê cuhy kũm te apu hamre pyràac, ne ma jũ kam me acto. ");
INSERT INTO ram_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Ne mehkrã kên catêjê hãn ne mehkwỳ pê ampo cwa, ne nee hacpỹ mã me hõr na me amji to hũjahkre ata na, me amji jarkwa par nare. Ne quêt catyt kam me ipa catêjê ri me hàhcajrẽan kam, ampo to mehkwỳ tehcajpar to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Pahhiti te mehkrã kam harcô mẽn atajê, quê ha pjê to cute me cumã hũjahkre ata kam me amji to ipijapar rohnỳtti mã, ne mehkĩnte, cute mencrôn atajê, quê ha me mõr pejti kam me to hamre. ");
INSERT INTO ram_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Ne quê ha Pahhiti pry kam jũm mẽ ata, quê ha catyt kam pry ata kôt ipa, quê ha jũm ata mã cute amji kam hapac xà kĩn hyre nare. ");
INSERT INTO ram_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ne Pahhiti me hũhkra na cucwa ita kam, quê ha me ajhu, ne nee me ipihur tu nare. ");
INSERT INTO ram_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Pê wa ituwre na, Pahhiti te jũmjê pejti te catyt kam me ipa atajê mã hikran na me hõmpun nare, ne ahnaa ramã iwej. Ne nee hanea ne, rỳ ite mehkra nõ te apu hõ na hàhwỳr to mõr na hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Ne ihtỳj cumã ampo, mã hàhcajrẽnti kam to mehkwỳ tehcajpar to ipa. Ne quê ha Pahhiti ihtỳj mehkra itajê to impej, ne ma me hamã. ");
INSERT INTO ram_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ne ca ha ate ampo kên ton to apa ata pê amji to awpjê, ne quêt ate ampo pej pit ton to apa xà ata kam, quê ha Pahhiti ihtỳj gõ pjê kam me akrĩ rohnỳtti mã na me ato, ne ampo kên cunea pê atête hàmtàr to ipa. ");
INSERT INTO ram_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Ampo na? He Pahhiti mã catyt kam, cute mehkwỳ to impejti atajê kĩn, mã me to impejti to ipa. Na quê ha nee cute amji mã me to hajỹr to ipa catêjê mã hikran nare, ne ma mentête ampo kên pê hàmtàr to ipa rohnỳtti mã. Ne quê ha mehkĩnte mehkrã kên tàmxwỳ atajê me mõr pejti kam, mehcunea me hamre. ");
INSERT INTO ram_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Ne catyt kam me ipa atajê, quê ha Pahhiti te me cumã pjê to hũjahkre ata mã me axà, ne kam mehkrĩ rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","31","Ne catyt kam me ipa catêjê kam ri, ihtỳj hõ Pahpãm te amji kam hapac xà, na quê ha nee catyt kam ipa xà ita to ihcupan nare. Ne ihtỳj mehcakôc xà te amji jahkre pejti to mehcakôc to me ipa, ne cute me hapackre xà atajê, quê ha mehcajpuaw. ");
INSERT INTO ram_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ne mehkrã kêanre atajê ri, ihtỳj pry cahtiri, catyt kam me ipa atajê jikaj, cute me hipej prãmte. ");
INSERT INTO ram_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Cakrô, quê ha nee Pahhiti mehkrã kên jũhkra mã, catyt kam me ipa atajê incjêj na me hamãr nare. Quê ha ma cute mehcukij catêjê wỳr me to axà, quê ha Pahhiti, cute mehkên mã me mẽn xà ata na nee me hamãr nare, ne taa mentête amtà. ");
INSERT INTO ram_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Ca ha atỳj me Pahhiti jikaj, ne cute amji kam hapac xàa kôt me apa. Quê ha ihtỳj jũ caxuw ato acati, ne cute amã pjê to hũjahkre ata, quê ha ihtỳj amã cugõ, ca ha to gõ tekjê. Ne quê ha akam mare mã, mehkrã kên mõr pejti kam me hipej. ");
INSERT INTO ram_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","He pê wa ramã ito jĩa to, cute ita ton na hõmpu. Pê hũmre nõ ata ihkrã kêanre, ne hàprêa kam ajco mehkwỳ to kên to ipa. Ne cute me to kên to ipa xà ata kôt, cute amji to cati to hajỹar, pom quê pjê impejti kam pĩ ihkà to ipa, ne catia to cati he. ");
INSERT INTO ram_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Cakrô, mã ahna ahtũm nare, mã hamre, ata jĩkjê na ri cute hajỹr. Wa tee apu hũmre ita krĩ xà japê, mã ramã hamre, wa nee ite hipêr hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Ne ca ha catyt kam me ipa catêjê me, mempejti, ne nee ame ipijapu to ipa nare atajê kôpĩr to me apa. Quê ha ihtỳj cumã mehtàmxwỳ hàhtôa. ");
INSERT INTO ram_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Ne mehkĩnte, cute mehkên ton to me ipa catêjê atajê, quê ha ihtỳj me to hamre. Quê ha mehkĩnte nee me cumã mehtàmxwỳ nare. ");
INSERT INTO ram_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Ne quê ha ihtỳj Pahhiti, ampo kên pê catyt kam me ipa catêjê pytà, ne ampo kên te me hỹrmã hapôj xà atajê kam, quê ha cupê ikre tỳjti ata pyràac, ne ihtỳj mentête amtà. ");
INSERT INTO ram_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ne ma Pahhiti te mentête hàmtàr xà ata wỳr me pra, quê ha taa mehtehcajpa, ne mehkrã kêanre atajê pê me hũtà, ne mentête amtà. ");
INSERT INTO ram_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ỹhỹ, Inxũ Cati, ca ihhêj ne ipê ampỳa mã apa. Pom côjkwa crà kam, carà mã hatuj xà jõ cô to kôrti, ita na mã ite, ne wa apê ampỳa mã apu ipa. Na wa hacpỹa mã awỳr amji jaxàr to prãam to prãm, mãr cu hipêr ajpẽn pupu, ne ajpẽn cahi na papa. ");
INSERT INTO ram_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Inxũ tĩr rohnỳtti mã ata, he ihhêj rũm apê cô, ne imã ato kôar to kôr. Ne jũ caxuw mã wa ha ajte awỳr icato, ne ite ato acati prãmte imã akĩnti ita na amã amji jarẽ? ");
INSERT INTO ram_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Me icurê xwỳn catêjê me icukij to: “Mẽr jõ ri mã côjkwa kam Apãm Cati ita? Ihhêj ne hamreare” hane. Cwỳrjapê ri imã amji kĩn nare, ne ipeacre, ne wa ijàpàn nare kam, amcro me caxwa cunea kam amrã. Mã ito cacô pit ajxwỳ. Ne ito cacô pijaxwỳr ita pê ihhêj rũm ijõ, wa to pit mã apà. ");
INSERT INTO ram_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Wa hãn ne ituwre na mam ite ato amji kam ijapac xà atajê to amji japackre, ne ijĩ cunea kam ikàj xà pyrentu. Pê wa me ikjêjê jàhtôa to ajco amji kôt ipa, ite me ato amji kam ijapac xà jũrkwa wỳr. Ne me icuhtom pej pêa mã, me imã amji kĩan kam me ipa, ne ajco me icrear kam apê Inxũ Catihti na me ato ijũjarẽn to me ipa. Ata to wa amji japackre. ");
INSERT INTO ram_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Ne mẽr ampo na mã wa imã amji kĩn nare ne ikrihkrit ita na ipa? Xà quê ha ajkĩ Inxũ Catihti ita hipêr itehcajpar nare? Hãpà! Quê ha ihtỳj hacpỹa mã imã amji kĩnti na ito. Cwỳrjapê wa ha hacpỹa mã Inxũ Cati to amji mã ihhimpej, ne to amji japackre, ne to cati prãmte wa ha cumã: “Apeaj to apej, ne apê Inxũ Cati pê Pahpãm pê ikên pê ipytàr catê rohnỳtti mã” hane. ");
INSERT INTO ram_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","7","Wa Pahpãm jũrkwa me, me ikjêjê pê, ampỳa mã ipa, ne Côpijapjêr jõ cô jatuj xà na kẽnti itajê kam ikrĩ. Mã kẽn cati itajê pĩn, cô catia ne ikam ajxwỳ, ne kypê hàhkrihkrit nare, ne tee icuran prãm. Ita pê ihhêj rũm imã amji kĩn nare te ikam ipijaxwỳr. Cwỳrjapê ri imã amji kĩn nare ita pê ihhêj rũm ijĩ cunea kam ikàj xà, ne Pahpãam te ri imã amji kĩn nare ita na iton, na wa itỳj to amji japackre. ");
INSERT INTO ram_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Ne amcro cunea kam Pahpãm imã: “Imã akĩn rohnỳtti mã” hajỹar to pyt. Ne wa caxwa ri cumã cre, ne cumã: “Mehcunea jirôa pê apeaj to apej” hane. Ne itỳj cumã icakôc ne cumã: “Apê ite amji kam ijapac xà xakat, na ca ha atỳj ijamãr rohnỳtti mã” hane. ");
INSERT INTO ram_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Pahpãm pê ikên pê ipytàr catê, na wa cumã: “Ca ihhêj ne ate ito gapac kêt! Mã me icurê xwỳn catêjê ame ito kêanre, wa imã amji kĩn nare kam ipa” hane. ");
INSERT INTO ram_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Mã amcro cunea kam me icurê xwỳn catêjê ame ina xwỳ, ne me imãn to: “Jõ ri mã Apãm Catihti ita? Ihhêj ne hamreare ita kam, jũ wỳr quê ha atehcajpa” hane. Ne cute me imãn xà ita pê ihhêj ne ramã me icuran to mõ. ");
INSERT INTO ram_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Ne mẽr ampo na mã wa imã amji kĩn nare, ne ikrihkrit ita na ipa? Xà quê ha ajkĩ Inxũ Catihti ita hipêr itehcajpar nare? Hãpà! Quê ha ihtỳj hacpỹa mã imã amji kĩnti na ito. Cwỳrjapê wa ha hacpỹa mã Inxũ Cati to amji mã ihhimpej, ne to amji japackre, ne to cati prãmte cumã: “Apeaj to apej, ne apê Inxũ Cati pê Pahpãm pê ikên pê ipytàr catê rohnỳtti mã” hane. ");
INSERT INTO ram_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Ỹhỹ, ijõ Pahhiti pê Inxũ Cati, me icurê xwỳn itajê kêanre, ne ampeaj kam mehhêj xi, ne nee me ato amji japackre prãm nare. Ne cute me ijarẽn to kêanre atajê pê ipytà. Ne me cumã ijarẽn to: “Imãa cupê jũm pejti ata” hane. ");
INSERT INTO ram_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","He pom apê ampo kên pê ipytàr catê ita? Nõ na mã ihhêj ne ate imã hikran. Mã me icurê xwỳn imã amji kĩn nare na me ito, wa imã amji kĩn nare kam ipa, ca ihhêj ne nee ita na ito amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Pom hãn ne hàhcujro xà, awcapàtkô kam jũm pictor ata tehcajpa mã hacpỹa mã pry kam ajhu, ita kôpit na, ca ha iwỳr garkwa te ijapackre xà nõ hêj xi nare, pê ihhêj rũm gàhcujro xà nõ ata kujate, mãr quê hacpỹa mã awỳr ito amji jaxà. Ne ate ijapackre xà ita kôt, wa ha hacpỹa ne Xijãw jõ hàpkàjti na ite ato amji japackre xà jũrkwa kam akrĩ xà ata wỳr amji jaxà. ");
INSERT INTO ram_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Ne ate imã amji kĩnti wỳr ito amji jaxàr xà ata pyrên ijakryti, ne hahpan xà na wa itỳj amã ampo gõ. Ne amã ijàkôr xà cakô, ne amã icrer to: “Apê imã amji kĩnti jõr catê xakat” hane. ");
INSERT INTO ram_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Ne mẽr ampo na mã wa imã amji kĩn nare ne ikrihkrit ita na ipa? Xà quê ha ajkĩ Inxũ Catihti ita hipêr itehcajpar nare? Hãpà! Quê ha ihtỳj hacpỹa mã itehcajpa ne imã amji kĩnti na ito. Cwỳrjapê wa ha hacpỹa mã Inxũ Cati to amji mã ihhimpej, ne to amji japackre, ne to cati prãmte wa ha cumã: “Apeaj to apej. Ne apê Inxũ Cati pê Pahpãm pê ikên pê ipytàr catê rohnỳtti mã” hane. ");
INSERT INTO ram_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Ijõ Inxũ pê Pahpãm, icaprĩa ne. Wa itea ikên xà pê ampo kên ita to amji tũm. Ne amã ikĩn ne amã ijapê rohnỳtti mã ita kam, ca ha imã ikên cunea cuhhõ, ne nee hipêr to amji japackre nare. Ite acuna mã ampo kên ton ita kam ri amã ikêanre. Na ca ha imã ite amji kam ijapac xà kên kam, ite ikên ton ata to caprã. ");
INSERT INTO ram_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ne gàhcaprĩa kam, ite ikên ton ata cunea pê icuhhõ, ne ite garkwa jirô pê ipỳm ata hur pa, ne to tojnõ, mãr wa hacpỹa mã itetet. ");
INSERT INTO ram_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","He ramã imã, ite to ihcupan xà itajê cunea na, amji jahkre pej, na wa amã ahna amji jarẽ. Ne ikên xà itajê, ihhêj ne icunaa mã imã hikwa, na wa hõtpê to amji japackre. ");
INSERT INTO ram_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","He wa ite nee jũmjê cuna mã ikên xà ita ton nare, ne acuna mã wa ite ton. Ne itỳj ate ita cwỳrjapê ito kên xà na ramã gahkre pej. Ne ca catyt kam apa na ri ate icurê mã imẽn xà ita caxuw, quêt ampeaj kam apejti. ");
INSERT INTO ram_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Pê wa ipỳm pêa mã ramã ite amji kam ijapac xà kêanre. Ne ampeaj kam pê wa ipỳm pêa mã, ramã ajpên acuna mã ampo kên itajê ton to mõ. ");
INSERT INTO ram_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ne amã, ate amji kam gapac xà impejti, hêj xi nare ita pyr na ito prãm, mãr wa catyt kam, ihêj xi nare to ipa. Na ca ha imã ate amji kam gapac xà impejti, krã kreti ita to hahkre, ne imã agõ. ");
INSERT INTO ram_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ne itête imã, ite amji kam ijapac xà kên tũm ita cuhhõ, wa itetetti to hanea, pom quê hàcwỳn jaka he. ");
INSERT INTO ram_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ite ato kên jahpan xà na, ate imã amji kĩn nare ne ipeacre na iton. Ne ita caxuw ca ha hacpỹa mã imã amji kĩnti na ito. Mãr wa ate ito impejti ita pyrên ijakryti to amã cre. ");
INSERT INTO ram_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ne ate imã ikên cunea ton itajê to caprãr ne ihhur partu na, imã ato prãm, mãr ca nee hipêr hõmpun nare. Ne ite acuna mã ikên ton ita to tojnõ, ne nee hipêr to amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ỹhỹ, ijõ Inxũ Cati, imã ite amji kam ijapac xà tetetti impejti gõ, mãr wa ato pit mã hupkre cahkô to ipa ita na. Ne ite ato amji kam ijapac pejti xà caxuw, imã ite amji kam ijapac xà tuwti gõ. ");
INSERT INTO ram_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Ne nee amji tête põ mã imẽn nare, ne nee ipê ikam Acarõ Pejti ita caxàr nare, ne quêt hipêr ajpẽn kam pahhônco na ito. ");
INSERT INTO ram_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ne cama hipêr imã ate ipytàr pyrên ijakryti na ito, ne ita caxuw ite akam ijapac prãm na ito, mãr wa akampa. ");
INSERT INTO ram_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ca ha ito hajỹr jirô pê mã, wa ha itỳj cute mehkên ton catêjê mã, ate me imã garkwa jirên itajê to hahkre, quê ha me gahkre pej, ne hacpỹa mã awỳr me amji jacjê. ");
INSERT INTO ram_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Ijõ Inxũ Cati, apê ampo kên pê ipytàr catê, ne nee ca ite jũm curan xà ata kôt amji mã ihcuhtom nare. Wa ha imã amji kĩan kam, mehcunea mã, ca catyt kam apa, ne apejti na garẽn to ipa. ");
INSERT INTO ram_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ijõ Pahhiti, mehcunea mã icakôc na itehcajpa, mãr wa itỳj me cumã acatihti ne apejti na ato ijàmnãn to ipa. ");
INSERT INTO ram_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ne ite amã ampo to acajpuaw prãmte, ite amã ampo pijapar to caxàr xà ata na, nee amã ihkĩn nare. Ca ha ma apu ite amã ampo jõr xà atajê caca nare na mã, wa ha ramã amã cugõ ne to capa. ");
INSERT INTO ram_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Ỹhỹ ijõ Inxũ Cati, wa ite ampo to acajpuaw prãm xà ata na amã ihprãm nare, ne quêt amã icrire na ito prãm. He wa ite ikên ton ita to amji japackre, ne imã amji kĩn nare, ne ipeacre ata na ri amã ito prãm. Ne ite ikên ton jicu ne akôt pit mã ipa to prãm ata kôt, ca ha ina amji capa. ");
INSERT INTO ram_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ỹhỹ Pahpãm, ate itehcajpar xà ita na, ca ha hanea ne me akwỳ cunea tehcajpa. Ne por ramã Krĩpinkrên tête kwỳc nare, mã me curê xwỳn te ame to kêanre, na ca ha hipêr gàhcajrẽan kam Xijãw jõ kẽn cahê na krĩ ata to impej, ne ihtehcajpa. ");
INSERT INTO ram_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ate me itehcajpar jahpan xà na, wa ha ihcunea na me amã amji gõ. Ne ahna ate me ijahkre pej xà na, wa ha me amã pryti krahti xũmti nõ to capa, ne catyt kam me to akam ijapac to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Ỹhỹ, me ijõ Inxũ Cati, me icaprĩa ne, ne me ikrã kam garcô mẽ, ne me ito impej, mãr wa me ipej. ");
INSERT INTO ram_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Mãr quê pjê cunea kam, mehcunea, krĩxàre mea mã, ate amji kam gapac xà impejti na me gõmpu, ne mehcunea apê me hũtàr catê na me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Ỹhỹ, me ijõ Pahpãm, imã krĩxàre cunea te acatihti na me garẽn na me to prãm. Ne hanea ne imã ampo kra cunea te apejti na me garẽn na me to prãm. ");
INSERT INTO ram_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Imã mehcunea mã amji kĩn, ne me hakryte amencrer na me to prãm. Ampo na? He caa ca ha quêt catyt kam mehcukij jirô pê mempej to impej, ne mehkrã kên to kên, ne pjê cunea kam mehkrĩ atajê japackre ne ma me to ahimpej to apa. ");
INSERT INTO ram_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Ỹhỹ, imã krĩxàre cunea te acatihti na me garẽn na me to prãm. Ne hanea ne imã ampo kra cunea te apejti na me garẽn na me to prãm. ");
INSERT INTO ram_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Ỹhỹ me ikwỳ, pê Pahpãm me pamã me pajõ pjê gõ. Ne ramã cute me pahkrã kam harcô mẽn, ne me pamã pajàprà cunea jõr. ");
INSERT INTO ram_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Pê Pahpãm ramã me pahto impej. Ne imã pjê cunea kam, mehcunea te amji mã me hũpa to ipa na me to prãm! ");
INSERT INTO ram_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","He imã, Ixaher catêjê te amji kam hapac xà cunea kam mehkên nare, ne mehtetetti atajê caxuw ri, Pahpãm peaj to impej na, imã hahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","3","Ne mam pê wa nee hahkre pej to hajỹr nare. Pê wa mehkrã kên me, amjia kôt ame ipa catêjê atajê jũ na, apu cute me amji kam hapac xà pê me hàhcukrêj cati atajê kĩn. Na pê wa ajmãr Pahpãm kôt ipa xà ita na atij, ne ipỳm, ne ajmãr ikên mã axà. ");
INSERT INTO ram_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Ampo na? Me cumãa, cute me amji kam hapac xà cunea kam mehcarĩcti. Ne nee ame hà nare, ne me capẽnti, ne mehtỳjti. ");
INSERT INTO ram_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Ne me cumãa, cute me amji pupun xà kêanre nõ hamreare. Pom ahnaa mã mehkwỳ te me amji pupun xà kêanre to me amji pupu ita na, cute me hajỹr nare. ");
INSERT INTO ram_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Ne por me hakràj cati na amji to me ipipẽ to me ipa atajê ri, ihhêj ne me cumã impeaj to impej. Ne ramã cute me cupê hamreare, ne me cupê mehkryjre atajê to me hàprê to me ipa to cute me amji pyràc tu. ");
INSERT INTO ram_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Ne cute amji kam me hapac xà kên to pit mã, cute ame caxwỳn to hipu tu. Ne ramã amji jirôa pê cute me amji kam hapac xà kên jàhtôa to amji to mehhimpej to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Ne mehcunea mã xwỳ xà kêanre to me ipa, ne ampo kên to pit mã mehcakôc to me ipa. Ne ihtỳj mehcunea jirôa pê amji to me cati prãm to me ipa. Ne cute me cupê hamreare, ne mehpeacre atajê mã mehhêj, ne mehkên mã me irẽn to pit mã me amji kampa. ");
INSERT INTO ram_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Ne ihtỳj côjkwa kam Pahpãm to mehcakôc kêanre to me ipa. Ne cute amji to me cati prãmte, ihtỳj pjê kam mehcunea mã me harkwa jirê, ne tee ampo cunea to mehhimpej to me ipa prãm. ");
INSERT INTO ram_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Hõhõ, ata to ri Pahpãm na mehkwỳ to ihcuhhê ne mehhi kẽhkẽ, mã ma mehkôt me ipa, ne ihtỳj cute me ampo jarẽn xà atajê kôt me ipa. ");
INSERT INTO ram_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Mã ajpẽn mã ame hũjarẽn to: “Quê ha nee Pahpãm ampo itajê nõ na me pajahkre pej nare. Quê ha Carôt Tỳjti ata nee ampo itajê nõ na me pamã cator nare” hane. ");
INSERT INTO ram_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Mehkrã kên catêjê te me hajỹr he. Me cumã ampo catia, ne ma hõtpê me ipicamẽn to me ipa, ne ampeaj kam me hakràj. ");
INSERT INTO ram_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Cwỳrjapê wa ajmãr ite amji jarẽn to hajỹr he: “He wa ihhêj ne amji caprỳ to, ite ikên ton tête amji jiprõn to ipa. Ne mẽr ampo caxuw mã wa ikên pê ijũhkra to awpjê, ne to ihtetetti to prãm? ");
INSERT INTO ram_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Ne pom ite ipej cwỳrjapê amji cajpẽr xà kêanre itajê to, ite amji pupuan to pyt ita? Ne wa ipej ton to ipa cakrô, amcro cunea kam ajte ihhêj ne ampo kên mã icjêj to ipa” hajỹr. Hõ, wa ajmãr ite amji jarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Ỹhỹ ijõ Pahhiti, wa ha ampo itajê na amji jarẽ na mã, wa ha ramã ipê aracri me akwỳ kên mã me irẽn catê hiahpuro. ");
INSERT INTO ram_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Cwỳrjapê wa ite ampo itajê cunea jahkre pej xà na, ite amji to hahkre ne hahkre pej. Na ri imãa ampo itajê jahkre pej xà nee hirã pê nare. ");
INSERT INTO ram_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Ỹhỹ me ijõ Inxũ Cati, wa amã icakôc prãmte gũrkwa mã ixàr, ne ite mehkrã kên catêjê te amji kam me hapac xà jicu xà mã mẽn na, me hahkre pej pyrentu. ");
INSERT INTO ram_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Ca ate mehkrã kên catêjê itajê kên mã me irẽn xà itajê pê ihhêj rũm ate pry cuwrỳhti kôt ame hũxwỳr, mã me hàtij to me ipa, ne ma mehkên xà ata mã mehpỳpỳm, ne me hamre ata pyràac. ");
INSERT INTO ram_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Ne quê ha ihprõt pê, me mõr pejti kam, por amji mã me ampo cupahti ata pê Pahhiti te me to hamre xà ata, me hỹrmã cato ne me kam tẽ, ne me to hamre partu. ");
INSERT INTO ram_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Ỹhỹ me ijõ Pahhiti, he ihhêj rũm mehkrã kên atajê pê, pom me amti, ne me ahna apẽ, mã jũ kam me cupê pra ata pyràac. Wa ha amti ne ampra ne to ijapac kêt, ita jĩkjê na, ca ha ma amji cuna mã amehkrã kên catêjê atajê caca. ");
INSERT INTO ram_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Ne pa, pê wa ajmãr acuna mã ixãm tỳj pyrentu, ne ajmãr akêanre na ato amji kampa. ");
INSERT INTO ram_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Ne pê wa ihhêj rũm ipê ampo jũpar nare ta, ne ihhêj rũm ipê mehkrã nare ata pyràac, ne nee ajte ate amji kam gapac xà itajê na gahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Cakrô ca atỳj icahi na apa, ne awpôc rũm ate ipa na ijuwahi tu, na wa ha nee ikên mã ipỳm nare. Ne ikĩnte nee ate mehkrã kên atajê juwahi nare. ");
INSERT INTO ram_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Na ca ha ate amji jahkre pejti ita to ijapackre to mõ, ite amji kam ijapac xà itajê cunea kam. Jirô pê mã, ca ha ma amji wỳr ijaprô, ne côjkwa kam, amji jĩkjê rũm ijỹr. Quê ha mehcunea acahê na me ipupu. ");
INSERT INTO ram_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ne jũm to wa aràn xà na amji mã ijõ Inxũ Cati? He aràn xà na jũm hamreare! Ca imã akrĩ ita kam, wa nee pjê me côjkwa kam imã jũm na prãm nare. Ne ampo na wa amji cuna mã ihprãam to prãm? Ampo nare, he ca! Ana wa ihprãam to prãm! ");
INSERT INTO ram_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Quê icapẽnti xà ita ihtỳj ipê hamre, quê ha ijĩ cunea ihtỳj ipê hà, ne apê ri imã ijĩ to ihtỳj catê. Ne apêa ri côjkwa kam imã, ite amji kam ijapac xà to impej, ne to hakràj catê rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Ne por jũm apu amji tête acurê ne ma apu acaca ata, quê ha ihtỳj hamre. Ne por quê ha jũm amã hikra ne apê hawry ata, ca ha ihkên mã amẽ, ne to hamre. ");
INSERT INTO ram_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Ne wa pa ate amji cahi na ito apijapar ita na ite amji cajpẽr, ne ahna imã impeaj to impej. Ỹhỹ me ikwỳ, Pahpãm pê ri me pantête hàmtàr catê, cwỳrjapê wa mehcunea mã, cute imã ampo ton itajê cunea na, harẽn to ipa. ");
INSERT INTO ram_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Ỹhỹ Pahpãm, apê ampo cunea jõ Pahhiti, ne mehcunea jirôa pê ampeaj kam quêt acarôt tỳj. Ne ampeaj kam imã ite me ato amji kam me ijapac xà jũrkwa kĩn. ");
INSERT INTO ram_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ne imã gũrkwa ata ri apu imõr prãmti, ne ampeaj kam to ijapac xà. Wa ite amji kam ijapac xà cunea to, wa apê me ijõ Inxũ Cati tĩar ata pyrên ijakryti to amã cre. ");
INSERT INTO ram_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Apê ijõ Pahhiti pê Pahpãm! Quêt ampeaj kam acarôt tỳjti! Acatihti cakrô, mã ihtỳj cute me ato me amji kam hapac xà jũrkwa kam cuwênre me, xiprôre amji mã hahê to, cute kam amji mã intore to ipijapar xà caxuw. ");
INSERT INTO ram_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Por cute me ato amji kam hapac prãmte, gũrkwa mã hãn ne me acjêj, ne me hapôj atajê ri hãn ne ampeaj kam me hakry xà, ne hõtpê acatihti na me amã cre! ");
INSERT INTO ram_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Ne por apĩn amji mã me carôt cwa, ne ma Krĩpinkrên jõ hàpkàjti pê Xijãw na me to hàpir, gũrkwa wỳr me to cator prãmte atajê ri, ampeaj kam me hakry xà. ");
INSERT INTO ram_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Ne caprũm cràre nõ kôt me mõr xà ata kam, ca ha atỳj me cumã ihkôt cô catõc ne ipijapjêr na to, quê ha ajpjê. Ne quê ha hanea ne ta cakônĩ nõ wrỳ, quê ha ampeaj kam hĩpô hàhtô. ");
INSERT INTO ram_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Ne me mõr kwỳa kam, quê ha ihtỳj me carôt ita me cumã ipicamẽn to mõ. Ne ma Krĩpinkrên kam, cute me ato amji kam me hapac xà jũrkwa wỳr me cato, ne me apê pahpãm cahàc krekà cunea jirôa pê acati ne apê Pahhiti impeaj na me apupu. ");
INSERT INTO ram_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Mehcunea jirôa pê ijõ Pahhiti pê Pahpãm carôt tỳjti ita, ite amã icakôc xà ita na, ikampa. Apê iquêtti pê Jaco xwỳ jõ Pahpãm ita, ikampa. ");
INSERT INTO ram_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Pahpãm, ate amji mã me ijõ pahhi capi ne hãm ata krã kam garcô mẽ, ne to impeaj ne. ");
INSERT INTO ram_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Wa ite jũ ri amji to amcro jàhtô to mir romã, wa ha gũrkwa kam amji to amcro pyxit peaj. Ne mehkrã kên jũrkwa pejti kam ijàhhuc romã ri, imã cormã gũrkwa jarkwa mã mencjêj xà kam ixãm na amji to prãam to amji to prãm. ");
INSERT INTO ram_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Pahpãm, apê me ijõ Pahhiti, ne apê pyt pyràac, ne ampeaj kam acati ne apràti, ne apê me itête gàmtàr catê. Ne gàhcajrẽnti to, amã me ikĩnti kam, ca hãn ne me ito impej, ne mehcunea kam mare mã me ito me icati. Ne por catyt kam, mempejti to ame ipa atajê pê ri, nee ate ampo pejti intê xà nare. ");
INSERT INTO ram_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Mehcunea jirôa pê apê ijõ Pahhiti carôt tỳjti ita. He ampeaj kam ri amji mã me ato ihhimpej atajê cunea jakry pit. ");
INSERT INTO ram_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Ỹhỹ me ikwỳ! Quê ha me anõ mã, ampo kên pê amji pytàr to prãm na, ca ha Pahpãm mã amji cajrẽn, quê ha Pahpãm pê me pahcunea jõ Pahhiti pahtỳjti ata, ihtỳj atête amtà. Cwỳrjapê ca ha gapacta ne me pajõ Pahhiti pê mehcunea jirôa pê ihpahtỳjti ata mã me amji jarẽn to, ");
INSERT INTO ram_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","“Apê ipytàr catê, ne apê ampo kên cunea pê itête gàmtàr catê, ne apê ijõ Pahpãm, na wa itỳj ate ijamãr na amji mã ato hane” hane. ");
INSERT INTO ram_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Quê ha Pahpãm ihtỳj ampo kên pimxur te akên mã amẽn xà ata pê apytà, ne atête axà te acuran xà ata pê amtà. ");
INSERT INTO ram_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Quê ha ihtỳj amji jarkwa pa, ne ampo te ato kên xà ata pê apytà. Quê ha ihhêj rũm cupê ampo jara, ne hara to apro, quê ha nee ihkrac ri ampo acaxun nare. ");
INSERT INTO ram_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Cwỳrjapê quê ha nee amã caxwa ri ampo kên awỳr pra atajê cupa nare. Ne quê ha ihprõt pê amcro kam ampo kêanre ata awỳr cato, ca ha nee hũpate apu akrihkrit nare. ");
INSERT INTO ram_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Ne nee amji mã, por awcapàtkô kam, hà kêanre picràn ata cupa nare, ne nee amji mã amcro kam ampo te ame ato hamre xà ata cupa nare. ");
INSERT INTO ram_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Ne quê ha me mir ne me ty, ne awke rũm me ajxwỳ, ne me tej mir ne me ty, ne awpôc rũm me ajhu cakrô, quê ha nee ampo kên ato kên nare! ");
INSERT INTO ram_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Na ca ha cama xa ne ankrêre ne apu rĩt. Ne ca ha atỳj Pahpãm te me hũpar nare me, mehkrã kên te ampo kên ton atajê jahpan xà na, cute ame to kên na me to ihtỳj tu na me hõmpu. ");
INSERT INTO ram_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","10","Ate amji jarẽn to: “Pahpãm catia pê ijõ Pahhiti ata pê ri, por curi ipimxur xà ata, ne cupêa ri itête hàmtàr catê!” hajỹr. Cwỳrjapê quê ha nee ampo kên gũrkwa wỳr cator ne jũ mã aton nare. ");
INSERT INTO ram_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","He quê ha Pahpãm côjkwa kam cumã me hàpên catêjê mã harkwa ta, quê ha harkwa kôt, por ca jũ ri apu amõr xà ata kam me gamã, ne me atête me hàmtàr to ipa. ");
INSERT INTO ram_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Ne quê ha me gamãr to hanea, pom quê jũm xũmre pry kam kẽn te ihkra par tõc cupate, ma hũhkra to, to huphê ne hamã he. ");
INSERT INTO ram_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ca ha Pahpãm cãmtàa rũm atỳj me acurê xwỳn pê rop jõkre hôhti me, me cupê cagã kêanre pyràc atajê me, me ajpu, ne me kam acuhhê, ne me tohjê. Quê ha nee jũmjê itajê nõ ato kên nare. ");
INSERT INTO ram_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Na quê ha Pahpãm amji mã garẽn to: “Wa ha itỳj me cumã ikĩnti itajê pytà. Ne cute amji mã me ito ihhimpej atajê, wa ha itỳj mentête amtà! ");
INSERT INTO ram_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ne quê ha kam ampo kên cato, quê ha imã amji cajrẽn, wa ha kampa ne ramã curia cahê na xa, ne pa ampo kên pê hũtà, ne pa mehcunea te amji mã me hũpahti xà na me to, quê ha amji mã me hũpa. ");
INSERT INTO ram_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Wa ha cute amji to ipijapar to irya na to, ne cute amji to ipijapar xà ata kam, ahnaa mã, wa ha itỳj hũtàr to ipa” hane. ");
INSERT INTO ram_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Hacme, ne me pajõ Pahhiti pê Pahpãm to me cati prãmte, me cumã me pahcakôc! Ne cupê me pahpytàr catê pyrên me pajakryti to, cu me cumã cre! ");
INSERT INTO ram_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Hacme, ne Pahpãm to me amji kam hapac xà jũrkwa mã me axà! Ne curia cu ha cuna mã, cute me pahto impejti ita pyrên me pajakryti to cumã me amji jarẽ, ne pahtỳj me cumã cre! ");
INSERT INTO ram_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Ne mẽr ampo na mã cu ha me to hane? Nee mã ampo na cu ha me to hajỹr nare. He me pajõ Pahhiti pê Pahpãm carôt tỳjti ata ri, pjê cunea kam, pahpãm cahàc cunea jõ pahhiti carôt tỳjti atajê jirôa pê cati. ");
INSERT INTO ram_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Ne pjê cunea to ihhimpej, ne ahkre ryti rũm to ihhimpej kam pra, ne ma kẽn kàhti ata mã to hahê. ");
INSERT INTO ram_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Ne taa cute côxwa ton ata to ihhimpej, ne taa hanea ne cute pjê ton ita to ihhimpej. ");
INSERT INTO ram_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Cwỳrjapê cu ha ma me pra ne Pahhiti cuna mã me pahkõn krã na me jỹ, ne cumã impejti na me harẽ. Hacme ne me cumã: “Apê me ijõ Pahhiti pê me iton catê” hane. ");
INSERT INTO ram_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","He cupê me pajõ Pahpãam to Pahpãm, ne me papê mehkwỳ, mã me pajamã. Ne me papê hõ parxare pyràac, mã ihtỳj me pamã me pahte ampo pej na prãm xà atajê gõ. Cwỳrjapê cu ha ita kam cute me pamã ihcawpa xà atajê na me kampa: ");
INSERT INTO ram_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Nee ca me apê me aquêtjêa ne me gàprãr xi nare. He pê me aquêtjê me hàprãr xi cwỳrjapê pê põti kam me hamreare ata kam, ajco amji caxuw cô na me icyt to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Pê wa caku te cwarẽnta kam, me kam mare mã icarôat kôt ajco ampo catia pihhoti atajê ton to ipa, ne ajco me cumã harte, ne ajco me cumã cô gõ, ne ajco me curê xwỳn pê mentête amtà. Pê mento jĩa to ahna me ipupun cakrô, cute me icapi prãmte amji caxuw me icyt, ne ajpẽn mã me ijarẽn to: ‘Nee Pahpãm me pajamãr pej nare’ hane. ");
INSERT INTO ram_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Pê wa caku jàhtôti ita cunea kam me aquêtjê itajê kam icryc, ne ma amehcaca ne pa amji mã me to icakôc to: ‘Mehkrã kên atajê te amji kam hapac xà kêanre, ne cama ijarkwa jirô pê mehpỳpỳm to me mõ, ne ma ame ijarkwa par caca’ hane. ");
INSERT INTO ram_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Ne wa me kam icryac to icryc, ne ampeaj kam ite me cumã amji jarẽn, ne me ahna amji jarẽn tu, ne me cumã: ‘He me gũpar nare ita kam, ite pjê to me amã ijũjahkre ata mã me acunea xàr. Ne kam me akôt xà ata kam, ca ha nee jũ caxuw curi me axàr nare. Na ca ha ita ri põti ita kam me atyc pa, quê ha me akra pit pjê ata mã me axà’ hane”. Hõ, me pajõ Pahhiti, amcro ita kam me pamã ihcawpa to hane, na cu ha pahtỳj me kampa. ");
INSERT INTO ram_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Pahpãm pê Pahhiti te ijõ Pahhi mã: “Icahê na, Pahhi jỹr xà kam, awpôc rũm jỹ. Wa ha apar krac ri me acurê xwỳn atajê cunea nõr na me to, quê ha me nõ. Ca ha ate me tohjê na cute me gahkre pej xà na, me hipy apar xãm” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Quê ha Pahpãm Krĩpinkrên pĩn, ijõ Pahhi mã, cute pjê to ihhimpej xà ata caxuw carôt cunea gõ, ne cumã: “Apê pjê jõ Pahhi ne acarôt tỳj. Ne acarôt tỳjti ita to, ca ha acurê xwỳn catêjê cunea jirô pê acuhhê partu, ne me to ahimpej. ");
INSERT INTO ram_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ne ca ha me cume apijapu kam me tẽ me ajkaam, quê ha me acahê na me ipijapu xà caxuw, me akwỳ me hàhtôa ne me amji to ajpẽ. Ne me cupê pĩhhô na atàr pyràac, ne pjê cunea kam me hàhtôa to me hàhtô. Quê ha mentuwjê, me cumã amji kĩan kam, Krĩpinkrên jõ kẽn pejti atajê kam me acajpa, akôt me ipijapu xà caxuw” hane. ");
INSERT INTO ram_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Ne Pahpãm pê Pahhiti te ampeaj kam ijõ Pahhi na amji jarẽn to hajỹr, na quê ha nee jũ caxuw amji pê cute cumã amji jarẽn xà ata to hapac kêt nare. Na ri Pahpãm te ijõ Pahhi mã: “Ca ha gõtpê apê me akwỳ jõ Pahhi. Ne hanea ne apê imã mehcajrẽn catê rohnỳtti mã. Ca ha apê mam imã mehcajrẽn catê pê Merquixê pê Pahhi ata pyràac, ne hapua na apê imã mehcajrẽn catê pê Pahhi” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Ỹhỹ Pahpãm, ca ijõ Pahhi tehcajpar xà caxuw, cahê na akrĩ ita na. Ne ca ha jũ caxuw pjê jõ pahhi kwỳ kam acryc, ne mehcunea to hamre. ");
INSERT INTO ram_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Ne quê ha cute jũ caxuw pjê cunea kam ate mehcunea cukij, ne me to apicokjêr xà jõ amcro kam ahtwỳ, ca ha mehkên jahpan xà na, pjê kam me hàhtôa ne mehcura ne me to hakôat to hakôt, ne pjê cunea kam pahhi catêjê cunea to hamre partu. ");
INSERT INTO ram_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ne quê ha ijõ Pahhi pry cahê na cô ajpjê ata to ikõ, quê ha cumã carôt catia to cati, cute me hirô pê ihcuhhê xà caxuw. ");
INSERT INTO ram_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Ỹhỹ me ijõ Inxũ Cati, wa ha garkwa na amã amji jarẽ. He ampeaj kam imã acaca xà itajê cunea kĩn! Wa to amji japackrea to pyt. ");
INSERT INTO ram_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Ca gõtpê ate imã, ate ijapackre xà jõr, wa ite amji mã huwahi ata kôt, ca ha me icurê xwỳn jirôa pê hãn ne ito amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Wa cute me imã ampo to hahkre catêjê jirôa pê hãn ne imã hahkre pej. Ampo na? Wa hãn ne ate imã ampo itajê to hahkre xà impejti itajê to amji kampa na wa. ");
INSERT INTO ram_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Wa itỳj acaca xà kampa, ne amji mã hũpahti to ipa, na ri mehwej jirôa pê imã hahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Itỳj imã garkwa par to prãm, cwỳrjapê wa nee ampo kên ton to ipa nare. ");
INSERT INTO ram_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ne nee wa ate ampo na garkwa atajê ton jicu nare. Ampo na? He caa pê ca imã to hahkre na ri. ");
INSERT INTO ram_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Ne ate imã garkwa jirên itajê cunea inxô pit! Ne imã ihhêj ne pen jirôa pê inxô. ");
INSERT INTO ram_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","He ate imã ampo to hahkre xà kôt ri imã hahkre pej, na wa ma apu cute me amji kam hapac xà hêj xi xà atajê cunea impar caca, ne ma ame curê. ");
INSERT INTO ram_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Garkwa ita pê ihhêj rũm hàhcujro xà nõ te imã gõ pry cujro, ihkôt imõr xà caxuw. Na wa ihkôat amji kam ijapac xà to impejti to ipa. ");
INSERT INTO ram_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Na wa ite apar na amã amji to ijũjahkre, ne wa ha itỳj ampeaj kam, amji mã ate ito ahimpej xà cuhtacti itajê kampa! ");
INSERT INTO ram_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Ijõ Pahhiti, imã ite amji pupun xà itajê kêanre! Ne pom ca ate imã ampo pejti na amji to gũjahkre ita na ca ito, ne imã icarôt gõ, mãr wa ityc xà jahpa. ");
INSERT INTO ram_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Ỹhỹ, Pahpãm, ate ito kênre nare ita pyrên wa ijakryti to, ite amã amji jarẽn xà ita na, ca ha atỳj amji capa, ne ate ampo to imã ahimpej xà ita to imã hahkre. ");
INSERT INTO ram_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","He ihtỳj hõtpê jũmjê atajê ame icuran prãm cakrô, wa nee ate amji kam gapac xà to, ite amji pê ijapac kêt nare. ");
INSERT INTO ram_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Ne mehkrã kêanre atajê te me imã ipro xà ton, ne me imã hãm, cute me to ipro prãmte, cakrô wa nee ite, ate ampo na ito ahimpej xà atajê kam ijapac jicu nare. ");
INSERT INTO ram_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Ate imã ampo to hahkre xà itajê pê itekjêa. Na wa ha itỳj amji mã me huwahi, ne amji caxwãm pê me cunõ, mã ihtỳj ina cuhkõnre kam me imã ijakryti to. ");
INSERT INTO ram_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Na wa ite amji mã garkwa ita par to ikrĩ, ne ahnaa to hicu xà mã mẽn na amji ton. ");
INSERT INTO ram_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Wa hãn ne rĩt ne hàhkà jakôt pupu ne pa amji cukij to: “Xà quê ha ajkĩ hàhkà jakôt ita pĩn, cute itehcajpar catê ata cato?” hane. ");
INSERT INTO ram_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Hãpà! He quêt Pahpãm pê Pahhiti pê pjê me côjkwa to ata pê ri itehcajpar catê! ");
INSERT INTO ram_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Ne cupê me pajamãr catê, mã ma me pahto huphê ita kam, quê nee ampo te me pahnõ mẽn na hamãr nare. ");
INSERT INTO ram_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Ne cupê me pahkwỳ pê Ixaher catêjê jamãr catê ita kam, quê nee jũ caxuw hõtxwa quê nõ ne apu hõt nare. Ne nee apu hõt nare, ne irĩat na quêt ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Me pajõ Pahhiti pê me pajamãr catê, quê ha ihtỳj me pahcahê na ipa ne me pahpytàr to ipa. ");
INSERT INTO ram_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Quê ha nee pyt cacro me pahnõ mẽn nare, ne nee quê ha caxwa ri, putwrỳ na, ampo xà me pahwỳr cator nare. ");
INSERT INTO ram_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Quê ha me pajõ Pahhiti ampo te me pahto jũ mãn xà atajê cunea pê me pahpytà, ne nee quê ampo te me pahnõ to jũ mãn na hamãr nare. ");
INSERT INTO ram_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Ne cu ha ma jũ kam me pra, quê ha ihtỳj me pajamãr to mõ, ne cu ha hacpỹ ne me amji jaxà, quê ha hanea ne ihtỳj me pajamãr to mõ. Ne quê ha me pahto hajỹr to hãm ita na, ne nee jũ caxuw me pajicu nare. ");
INSERT INTO ram_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Ijõ krĩ kam cute Pahpãm jũrkwa wỳr me ijator, ne me imã: “Hacme, Pahpãm to cute me amji kam hapac xà jũrkwa wỳr!” hajỹr, ata pyrên ijakry, ne imã amji kĩn crire nare. ");
INSERT INTO ram_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Na wa ramã hỹrmã me icator, ne itỳj Krĩpinkrên kam ame ipa. ");
INSERT INTO ram_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Ne ramã hacpỹ mã cute me Krĩpinkrên to impej. Mã ramã Ixaher catêjê jakrã amehcuhhê atajê te hỹrmã me cuprõn. Mã jũm te mehcukij to, ");
INSERT INTO ram_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","“Mẽr ampo na mã me hõ krĩ cunea pĩn, Krĩpinkrên wỳr, me hàpir to me ipa?” hane. Wa cumã: “Nee mã ampo na nare! He cute ampo pej cunea pyrên me hakryti na, me Pahhiti pê Pahpãm mã me amji jarẽn prãmte ri me ipa” hane. Hõ, ita na ri cute mehcunea mẽn, mã harkwa kôt cute me ton. ");
INSERT INTO ram_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ne ita ri mehcukij xà kam hõtpê me pajõ pjê jõ pahhi. Ne cute ajpẽn kôt me harẽn catêjê atajê kampa, ne catyt kam mehcukij, ne ajkam me to impej. Ne ita ri me cupê pro kam atajê ihcunea na, ihtỳj me ajpẽn kampa. ");
INSERT INTO ram_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Hacme, ne Pahpãm mã Krĩpinkrên kam amehkrĩ atajê cajrẽn. Cu ha mehcajrẽn to hane he: “Ca ha ma me hamã, mãr quê ajpẽn na mehhôncoti to me ipa. Ne por krĩ kwỳ mã, Krĩpinkrên kam amehkrĩ catêjê kĩn atajê, ca ha hanea ne me to impej, mãr quê me cuxà mempej pêa mã me ipa. ");
INSERT INTO ram_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Ne imã Krĩpinkrên tête kwỳc tỳjti me, cute me hamãr catêjê jũrkwa tỳjti atajê to, cute me curê xwỳn pê, me amji pytàr pejti na me to prãm, mãr quê ikre atajê cunea kôt me ankrê, ne nee ame amji mã ampo cupa nare, ne mehcarĩcti ne. ");
INSERT INTO ram_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Ne por krĩ ata kam, me ikwỳ me, me ikjêjê ame ipa atajê, ca ha hanea ne me to impej, quê mempej pêa mã ame ipa. ");
INSERT INTO ram_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Ne mẽr ampo na mã wa ame ana ijàhwỳr to hane? He apê me ijõ Inxũ Cati pê Pahhiti to ite amji kam me ijapac xà jũrkwa ita, ita ri krĩ ita kam ihcuhhê, na ca ha ipu na amehkrĩ atajê to hanea ne impej, mãr quê me cumã amji kĩn jakryti kam me ipa” hane. ");
INSERT INTO ram_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Ite me ikwỳ cukij to hajỹr he: “Ỹhỹ, me ikjêjê, wa ha me acukij, ca ha me imã me amji jarẽ. Quê ha me parũm Pahpãm hamreare na mã, jũ mã quê ha ampo te me pahto kên xà ata me pahto?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","5","Mã me ikwỳ te imã me amji jarẽn to: “Quê ha me parũm Pahpãm hamreare na mã, quê ha me pahcurê xwỳn te me pahkam incryc to imprar xà ata pê ihhêj rũm, cute me pahtĩar na me pahkur xà pyràac. Nare, quê ha cupê ihhêj rũm cô te hipu ne me pahcutor tu, ne ma ahpar mã hũwrya wỳr me pahto imprar, ne irorocti pahtỳjti to cute me papĩr pyràac” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Ite mehkwỳ mã harkwa to hajỹr he: “Pê me pajõ Pahhiti te me pahcurê xwỳn te me pahto hamre na hamãr nare pyrên me pajakryti to, cu ha cumã me amji jarẽ. ");
INSERT INTO ram_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Pê cu ihhêj ne me papê cuwênre pyràac. Pê Pahpãm cuwênre jahêr catêjê te me pahpro xà ton atajê pê me pahpytà. Ne ihhêj rũm me pahte na hê xà ata ta, pê pàt, ne hamre, pê cu pahtỳj ame papa. ");
INSERT INTO ram_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Me pajõ Pahhiti pê côjkwa me pjê ton catê, ne cupêa ri me pahtehcajpar catê ata pyrên me pajakryti na, cu ha me cumã amji jarẽ” hajỹr. ");
INSERT INTO ram_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Quê me pajõ Pahhiti pê Pahpãm ikre xãm na ikre pyxwỳr catêjê ràn nare na mã, quê nee me amji mã hamãr, ne me hãm nare, quê tee ame to hahkree, ne me to hàpên jicu. Quê me pajõ Pahhiti krãhtare pê krĩ jamãr catêjê te krĩ tête hàmtàr na mehràn nare na mã, quê tee ame krĩ tête hàmtàr to hahkree ne me hicu. Ne jũ wỳr quê apu amji mã hamã ne me hũtàr to impej. ");
INSERT INTO ram_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Jũ wỳr cu me pajàpên pejti to prãm to, iràràa na me pahkrĩ, ne me pajàpêan pê me pajàpên kam pra, ne me pajàpên to awcapàtkô rytu ne me cumã hikra ne pra, ne me pajikwa ne ame amji mã hamã. Ampo na? He Pahpãm mã mehkĩnti atajê te me hàpên xà jicu jirô pê me hikwa ne ame hõt. Mã cutea me cumã harte xà caxuw ihtỳj me cumã hõ to. ");
INSERT INTO ram_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Ne me pahkra pê ri ihhêj rũm Pahpãm te me pamã ampo pejti jõr xà atajê, mã ihtỳj me pamã cugõ. Cwỳrjapê ri ihtỳj amji kôt me pahwỳr me pamã ampo pejti jàhtôa ne me to hapôj. ");
INSERT INTO ram_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Ne me hũmre, mentuw kwỳa kam me cumã mehkra hàhtôa to me hàhtô. Ne hãn ne mehwej mã me taa me hũtà, ne me hamã. Atajê pê ri ihhêj rũm krãhtare jũhkra kam cute amji tête hàmtàr xà caxuw me cumã hõ kruw jàhtôa pyràac, na quê ha mehkra atajêa to amji tête hàmtàr to ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Por me hũmre mã mehkra jàhtôa to me hàhtô atajê pyrên ampeaj kam me hakry. Ampo na? He me cupê ihhêj rũm krãhtare mã hõ kruw jàhtôa to hàhtô pyràac. Ne jũ wỳr quê curê xwỳn nõ amji mã hamã ne me tohjê. Jĩkjê na mã me hũmre mã mehkra jàhtôa to me hàhtô atajê te me hajỹr. Quê ha mehcukij xà kam curê xwỳn nõ me ajpẽn kam tẽ, quê ha cumã hamãr catêjê pê mehkra jàhtôti itajê me hũtà, quê ha nee jũm tohjê nare. ");
INSERT INTO ram_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Pỳj me hêj xi ijõ Pahhiti! He ityc xàa wỳr ikrã pictor tu ata kam, wa itỳj ate itehcajpar prãmte ana ijàhwỳr. ");
INSERT INTO ram_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Ijõ Pahhiti, ite amã icaràr xà ata na ikampa! Ne ite amji pytàr xà na ijàhwỳr xà ata to, ca ipytà! ");
INSERT INTO ram_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Ca ha ite ato kên xà itajê to, ate amji japackre prãmte ahna ihkàhhôc to na mã, jũ mã wa ha, ne ate icurê mã imẽn xà ata pê icato, ne ma jũ kam tẽ? Hamreare! Ca ha atỳj hahpan xà na ikên mã imẽ. ");
INSERT INTO ram_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Cakrô, ca nee ate ito hajỹr nare. Ne quêt cama atỳj, ite ato kên xà itajê to tojnõ, ne nee hipêr to amji japackre nare, mãr wa ihkôt amji mã acupahti to ipa. ");
INSERT INTO ram_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ỹhỹ me ikwỳ, wa ite amji kam ijapac xà cunea to Pahhiti te itehcajpar na hikaj. Ne ampeaj kam wa itỳj cute ampo na imã amji to hũjahkre xà ata na amji mã to hane. ");
INSERT INTO ram_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Ne pom krãhtare pê caxwari krĩ jamãr catêjê apẽ xà jikaj ata jirôa pê, wa itỳj ijõ Pahhiti jikaaj to hikaj. ");
INSERT INTO ram_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Me ikwỳ pê Ixaher catêjê atajê, ca ha atỳj ampeaj kam Pahpãm to me amji mã hanea to me hane. Ampo na? He cumã me akĩn rohnỳtti mã, ne hõtpê ihtỳj cumã me apytàr prãm. ");
INSERT INTO ram_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Na quê ha ihtỳj Ixaher catêjê pê mehkwỳ atajê te ame to kên jahpan xà na, cute mehkên mã me hàr xà ata pê me hũtà. ");
INSERT INTO ram_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Ijõ Pahhiti, ca ramã ate ipupun pejtu na ri amã ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ne ramã ite ampo ton xà atajê cunea na amã ijahkre pej. Ne ampỳa mã amã ite amji kam ijapac xà cunea na ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ca ijàpên xà cunea me, ite apu ikôt xà atajê cunea kam ipupu, ne ite ampo ton xà atajê cunea na amã ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Ne ite jũm mã ampo jarẽn xà ata xwỳjrea na, ramã ite harẽn xà ata na amã ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ne jũ ri apu imõr xà ata ri, ca atỳj ipu na apa, ne acarôt to itête gàmtàr to apa, ne imã ijõ pry to hahkre to apa. ");
INSERT INTO ram_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Ne ramã ate ijahkre pej xà ita pupun pejtu, wa nee ajte akĩnte ite amji pupun pej xà ita na, ite amji jahkre pej nare. Ne ite ahna amji jahkre pej xà ita ipê ipimxur tu. ");
INSERT INTO ram_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ne jũ kam wa ha apê tẽ? Ca pjê cunea kam apa xà ita kam, jũ mã wa ha ajte ne jũ kam apê hawry? He wa nee jũ kam, apê ijũjawry nare. ");
INSERT INTO ram_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Wa ha ma côjkwa wỳr api, ca ha curia ramã apu mõ. Nare, wa ha ma pjê krac ri mehtyc krĩ xà wỳr wrỳ, ca ha curia ramã apu mõ. ");
INSERT INTO ram_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","10","Wa ha pyt japôj xà wỳr ite itor ne itẽm na, nare, ampỳa mã pyt cjêj xà kam amji to ipijapar cakrô, quê ha cormã gũhkra imã ijõ pry to hahkre to mõr ita na. Ne wa ha jũ ri cormã apu mõ, ca ha curi atỳj itehcajpa. ");
INSERT INTO ram_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Wa ha awcapàtkô mã ijarkwa to: “Ito amxu” hane, ne hanea ne amcro mã ijarkwa to: “Amji to awcapàtkô” hane, quê ha kam awcapàtkô cakrô, wa ha nee apê ipimxur nare. ");
INSERT INTO ram_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Ampo na? He amã awcapàtkô kam ampo pimxur ata pimxur nare. Ne amã awcapàtkôti ata pê amcro jõ apẽ. Ne amã awcapàtkô me amcro pipẽan. ");
INSERT INTO ram_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Ne caa pê ca ahpỹanre na imã icukrã xà ton pa, ne inxê cahã xà caxwãm pê ajkam ipyxwỳr pa. ");
INSERT INTO ram_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Na wa itỳj amji mã apejti na garẽ. Ampo na? He ate ampo ton xà atajê cunea pihho ne hahkre pej xà pimxur tu, ne ajtea mã, ne quêt impejti. Wa ite amji kam ijapac xà cunea to gàpên xà ita na, ite gahkre pej pejtu. ");
INSERT INTO ram_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Pê ca inxê tu kam ihi ton xà me, ite amji jipêj xà na ipupu. Pê wa aracri, jũm te ipupun nare kam, inxê cahã xà kam ipicamẽn to icati to mõ. ");
INSERT INTO ram_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Ne pê ca ipỳm xwỳjrea na ramã ipupu. Ne caa ramã imã jũ mã ite amji to ipijapar xà na amcro atajê na gõ kàhhôc kam ihhôc hiahpuro, mã hikwa, cormã amcro jamre reria mã. ");
INSERT INTO ram_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Pỳhàpà ijõ Pahpãm, ate amji kam gapac xà itajê cunea jahkre pej xà jahkre kêatre! Ne ampeaj kam hàhtô ne impej pit. ");
INSERT INTO ram_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Wa ha hàhtô na ite hahkre pej prãmte cahyt xà na mã, quê ha imã hàhtô pê ihhêj rũm pjênxôm carôt jàhtô. Wa cahyt, ne cahyt, ne nee jũ caxuw cahyt jicu xà mã to mẽn nare, ne kaam gõr. Ne wa iràrà na ampra, ne hãn ne acahê na ipa, ne ato amji japackre pyrentu. ");
INSERT INTO ram_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Ỹhỹ ijõ Pahpãm, he imã ate atỳj mehkrã kên te ampo kên ton to ipa atajê curan, ne me to hamre na to prãm. Ne imã ate me hàprêhti jũhcaprô prãmti atajê to ipê gũjawry tu na to prãm, mãr quê me hawry, wa icarĩcti na ipa. ");
INSERT INTO ram_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Ne me acurê xwỳn atajê ato mehcakôc xà kêanre to me ipa, ne ihcaprỳ na gaprỳ to mehkêanre to me ipa. ");
INSERT INTO ram_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Ijõ Pahhiti, pom ma ame acurê, ne ma ame apynãr caca itajê ri, ite hajỹar ne ihtỳj imã me curê, wa ma amehcaca! ");
INSERT INTO ram_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Wa me curê xà cunea to me curê to ipa. Ampo na? He acurê xwỳn itajê pê hanea ne icurê xwỳan to icurê xwỳn. ");
INSERT INTO ram_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Ỹhỹ, ijõ Pahpãm! Gapacta ne ikôpĩ ne icaxwỳn na awcapi, ne ite amji kam ijapac xà cunea na ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Ne imã, ihhêaj to ite ijõ pry cupan xà nõ ata jarẽ, ne quêt mehtĩr rohnỳtti mã xà ata jõ pry wỳr ca ito mõ, ne kam imẽ, wa ihkôt mõ. ");
INSERT INTO ram_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Ijõ Pahpãm pê ri ijõ Pahhiti, wa ha mehcunea kam mare mã acatihti ita na ana cre! Wa ha jũ caxuw acati na garẽn to amji pê ijapac kêt nare, wa ha quêt garẽn to ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Ne amcro cunea kam wa apyrên ijakryti na amji jarẽ, ne ato amji kam ijapac to ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Ijõ Pahhiti, ampeaj kam acati! Na wa ite amã acatihti to icakôc xà ata na amã ihkên nare, ne quêt acajpuaw. Ne jũ wỳr wa me inõ amji mã hamã ne acatihti ita na gahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Ne pom ate ampo pejti carôt tỳjti ton itajê cunea, quê ha ihtỳj me hũmre mehkra mã me harẽ, quê ha me kampa. Ne me taa, hanea ne mehkra mã me harẽ, ne me to hajỹr to mõr rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Quê ha gàhcujrohti me apê Pahhiti pejti ita to mehcakôc. Wa ha pa gàpên xà impejti itajê cunea kôt itỳj ato amji kam ijapac to ipa. ");
INSERT INTO ram_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Ne quê ha me taa mehcunea mã gàpên xà carôt tỳjti atajê cunea kôt harẽn to me mõ. Na wa ha hanea ne me cuxà gàpên xà catia na garẽ, ne mehcunea mã ato icakôc pejti ne. ");
INSERT INTO ram_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Ne quê ha mehcunea ihtỳj me hirôa pê apejti ita na me ato amji japackre xà kôt me amji mã, amji kĩn ton to me ipa. Ne ihtỳj ate amji kam gapac xà cuhtacti ita na me cre. ");
INSERT INTO ram_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Ỹhỹ me ikwỳ, Pahhiti pê jũm peaj to impej ata. Ne nee cupê ampo kam incryc kam imprar pyrentu catê nare. Ne cumã me pahkĩan to me pahkĩn, mã ihtỳj me pahcaprĩ. Ne hãn ne hõtpê pahte me pahkên ton jicu jirô pê mã, ihtỳj me pahkên to tojnõ, ne hicu. ");
INSERT INTO ram_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Ne mehcunea mã impeaj to impej. Ne cumã cute ampo cunea ton itajê caprĩ xà. ");
INSERT INTO ram_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Hàpà me ijõ Pahhiti pê Pahpãm! Wa ha pjê kam me icunea itỳj amji mã me acupa, ne ato amji kam me ijapac prãmte me ana cre. Ne me akwỳ cunea, quê ha apyrên me hakryti na me amã amji jarẽ. ");
INSERT INTO ram_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Quê ha me hirôa pê apê Pahhiti ita na mehcunea amji mã me ato ihcakôc. Ne ihtỳj acarôt tỳjti ita na amji mã me garẽ. ");
INSERT INTO ram_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Mãr quê mehcunea ate acarôt to gàpên xà ton atajê cunea na me apupu, ne apê Pahhiti catihti ata na me gahkre pej. Ne quê ha ihtỳj mehcunea mã ahimpej xà jàhcujro tetetti carôt tỳjti ata jahkre pej. ");
INSERT INTO ram_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Ne ate me ito ahimpej xà ita jamre xà hamreare. Ne apê Pahhi pê Pahhiti rohnỳtti mã. Ỹhỹ me ikwỳ, Pahpãm hãn ne ampo to awjahkre, ne ihtỳj hõtpê harkwa ata to amji japackrea rũm ihkrĩ. Ne cute ampo ton xà atajê cunea kam, cumã me pahkĩn pit. ");
INSERT INTO ram_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Ne ihtỳj ampo kên mã mencjêj atajê tehcajpa, ne ihtỳj hanea ne cute me to ihcupan atajê tehcajpa, ne hacpỹa mã catyt kam me ipa na me to. ");
INSERT INTO ram_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Por ampo cunea tĩar atajê, ihtỳj hõ to hàpàn xà ata kôt Pahpãm pupu. Ne cute me cumã ampo na me prãmti jõr xà atajê na ihtỳj me hikaj. Mã hãn ne cute me cumã me hõ jõr xàa jõ amcro na me cumã cugõ. ");
INSERT INTO ram_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ne ihtỳj hãn ne hũhkra mã hikra, ne nee apu hũ intê nare, cute ampo cunea tĩr atajê mã ampo na prãmti atajê jõr prãmte. ");
INSERT INTO ram_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Pahhiti te ampo cunea ton xà caxuw ihcunea na catyt kam ipa, ne ampeaj kam hàhcaprĩ. Ne ampo cunea na cute me pahto impej, ne cumã me pahkĩn. ");
INSERT INTO ram_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Ne por amji tehcajpar xà na ampeaj kam me cuwỳ atajê cahi na ipa, cute mehtehcajpar prãmte. ");
INSERT INTO ram_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Pahhiti ihtỳj cute amji mã me hũpahti atajê mã ampo na me prãmti atajê gõ. Ne ihtỳj me caràr kampa, ne hãn ne me hũtà. ");
INSERT INTO ram_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Pahhiti ihtỳj me cumã ihkĩnti atajê tête amtà, ne mehkĩnte mehkêanre atajê intête nee hàmtàr nare, ne cama hãn ne me to hamre. ");
INSERT INTO ram_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Ne ampo itajê cunea cwỳrjapê, wa ha ijõtpê Pahhiti catihti na harẽn to ipa rohnỳtti mã. Ne imã pjê ita cunea kam, icuxà cute me Pahhiti japrỳ pejti na me harẽn na me to prãm rohnỳtti mã.");
INSERT INTO ram_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Pê pahhi Xarômãw xwỳ pê pahhi Tawi xwỳ kra, ne cupê Ixaher catêjê jõ pahhiti. Ne pê ihkrã krea to ihkrã kre, mehcunea jirôa pê, ne ajco cute me hapackre xà jarẽ, ne ahna ihhôc. ");
INSERT INTO ram_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Ne cute me pajapackre xà itajê, ihtỳj me pahkrã kreti me, cute me pajapackre xà impejti itajê jahkre pej na me pahtehcajpa, ne hanea ne cute me pajapackre xà kam me pajapac jahkre kêatre atajê jahkre pej na, me pahtehcajpa. ");
INSERT INTO ram_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Ne cute me pajapackre xà itajê, ihtỳj ihcunea na catyt kam pahte amji to me papijapar pejti to me pamã hahkre. Ne hanea ne me pahkwỳ to me pahhêj xi nare kam, catyt kam pahte me to papipẽnti to me papa to me pamã hahkre. Ne pê Xarômãw xwỳ mã, cute me amji kam me hapac xà impejti to me ipa na me to prãm, na pê me hapackre to hane he. ");
INSERT INTO ram_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Imã me cupê ampo jahkre kêatre atajê te me ampo cunea jahkre pej na me to prãm. Ne imã cormã mentuwre, mehkà to me ipa atajê jũpar pejti na me to prãm to, wa me cumã mehkrã kên cawpa to ipa. Ne imã catyt kam, cute amji kam me hapac xà to, amji to me ipijapar na me to prãm. ");
INSERT INTO ram_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","6","Ne por ramã mehkrã kre atajê ri, cute mehkrã kreti to me amji mã me ipicamẽn na, imã me to prãm. Ne imã cormã cute mehkrã kre itajê to me hahkre, ne caxwãm catia mã me hũpar na, imã me to prãm, cwỳrjapê wa itajê cunea na me cumã ihhôc. ");
INSERT INTO ram_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Ỹhỹ, ca ha akrã kre to prãm, ne mam cati mã Pahhiti pê Pahpãm to amji mã ahimpej to apa, ne amji mã hũpahti to apa. Ne nee apê, por cute me amji jahkre kêatre te ma ame hũpar pejti caca atajê pyràc nare. ");
INSERT INTO ram_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","9","Ne anã me apãm te amã ampo to hahkre xà atajê na, ca impar to impeaj ne. Quê ha mehcunea ahna me apupu, ne me gahkre pej, ne apejti na amji mã me garẽ. ");
INSERT INTO ram_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Quê ha jũmjê krã kêanre atajê kwỳ me acapi prãmte, cute me amji kam hapac xà kêanre ton xà ata wỳr me gato, ca ha ma apu gitõt. ");
INSERT INTO ram_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","15","Quê te me amã: — Hacme ne amji kĩn ata na ame jũmjê cura, ne ame cupê ampo kwỳ to ahkĩ, ne amji mã ame to ajcrà, ne ahnaa me pajũrkwa to amji mã me hakràj — hajỹr cakrô, ca ha nee mempar nare, ne nee mehkôt amji ton nare. Ca ha me cupê ampỳa mã apu apa. ");
INSERT INTO ram_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","Ne pom mehkêanre itajê mã me hũjarêan kam, cute ampo kên to mehcuran to prãm, ne ihtỳj toa mehcura. ");
INSERT INTO ram_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Quê ha pryjara nõ te, ate cumã to catêc xà inxôr na apupun na, quê ha nee hỹrmã ihtẽm nare, ne ma tẽ ne hawrya ne apu kwỳ. ");
INSERT INTO ram_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Ne me hũmre itajê te ihtỳj mehkwỳ mã me catêtêc xà jaxôr na amji to me hane, ne aracri cute amji mãa me to haxôr. ");
INSERT INTO ram_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Ne por amji to me hakràj prãmte mehcuran to me ipa itajê, quê ha ihtỳj jũm me hipej xà kêanre to me hipej. ");
INSERT INTO ram_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Ỹhỹ me ikra, nee ca ite me gapackre xà ita to amji pê me gapac kêt nare, ne ite me amã ijarkwa jirên itajê, ca ha amji mã me huwahi. ");
INSERT INTO ram_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Ampo na? He quê ha ihtỳj ate amji to me apijapar to me caku jàhtôa na, me atehcajpa. Na ca ha ate ihkôt me ampo ton to me hahkre na, quê ha ihtỳj ihkôt me amã ampo. ");
INSERT INTO ram_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Ne quê hõtpê amã mehcunea kĩnti ne, ne hanea ne jũm mã ampo to awjahkre, ne atỳj ate amji ton xà ata na amji jarkwa na amji par to apa. Ne hõtpê ita to apa to, nee amji pê gapac kêt nare. ");
INSERT INTO ram_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Hõ, ca ha ate hajỹr to apa na, quê ha Pahpãm ihtỳj ato impej. Ne Pahpãm me, mehcunea, quê ha me garẽn pejti to me ipa. ");
INSERT INTO ram_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Ca ha gĩ cunea to Pahpãm tĩr rohnỳtti mã ata kam gapac to impeaj to apa, ne nee ca amjia kôt akrã kre na amji ton to apa nare. ");
INSERT INTO ram_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Ne ca ha ate ampo ton xà atajê cunea kam amji caxuw Pahpãm cukij na, quê ha ihtỳj amã hõ prya jahkre. ");
INSERT INTO ram_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Ne nee ca ate amji jahkre pejti na apu amji to hajỹr nare, ne cama amji mã Pahpãm tĩr rohnỳtti mã ata cupa to apa. Ne nee ate ampo to ihcupan xà atajê nõ ton nare. ");
INSERT INTO ram_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Ca gõtpê mehxêt cahê xà pejti to amji mã axêt cahhê, mãr quê amã to incri, ca quêt acapẽnti na apu apa, ita jĩkjê na, ca ha ite amã ate ampo ton xà na ijũjahkre itajê kôt ate apa na, quê ha ihtỳj amã, ate amji kam gapac xà kêanre to impej. ");
INSERT INTO ram_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Ne Pahpãm mã ca ha impejti to acakôc to apa. Ne cumã mam gõ pjê kam gàprà kam gõ atajê jõr to apa. ");
INSERT INTO ram_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Ca ha ate itajê to hajỹr na, quê ha gũrkwa kam amã arỳjhy hipu tu ne, ne ampeaj kam gõ pur kam amã pĩxô hàhtôa to hàhtô, quê ihhêaj to gũrkwa nee amã cahuc nare. ");
INSERT INTO ram_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Ikra, quê hãn ne Pahpãm pê Pahhiti ata gũpar pejti xà caxuw, amji mã ato ihhimpej xà to, ca ha ate kam gapac nare na, quê ha ihtỳj akàj xà na ato, ca ha akàj xà. Ne akàj xà ata kôt ca ha ampeaj kam amji mã kampa, ne cute amji to amã hahkre na amji mã to hane. ");
INSERT INTO ram_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Nãmri Pahpãm pê Pahhiti ata mã mehkĩnti atajê to ihtỳj hàpên xà ton to ipa, ahnaa mã me hũmjê amji mã mehkra to impejti prãmte, hãn ne mehkra to me hàpên to me ipa he, me hũpar prãmte. Ampo na? He cumã mehkĩnti na ri ihtỳj me to hajỹr to ipa. ");
INSERT INTO ram_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Ne por mehkrã kreti atajê ri me hakryti, ne ihtỳj me cumã ampo cunea kôt hakop jahkre pejti. ");
INSERT INTO ram_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Ne pom mehkrã kreti itajê mã ri ihpore cati ata me, kẽn prà tepti pê ôr atajê jirôa pê cati ne impej, ne ahna hĩ jàhwỳrti. ");
INSERT INTO ram_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Ne pom me hũpar te amji jahkre pejti itajê ri me hõkre xê xà pràti itajê jirôa pê impej. Ne pom cu amjia kôt ame ampo pejti na prãm itajê, nee impej te me pahte amji kam me pajapac xà impejti ita cahuc, ne to ipipẽn nare. ");
INSERT INTO ram_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","He me pahkrã kreti ita ihtỳj caku jàhtôa kam, pahte amji to papijapar na me pahto, ne hanea ne me pajakràj na me pahto, ne mehcunea te me pampejti na me pahpupun na me pahto. ");
INSERT INTO ram_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Ne me pahkrã kreti ita ihtỳj me pamã pahte amji mã, pahte amji kam me pajapac xà kĩnti ata na me pahto, ne ihtỳj catyt kam, me pahcarĩcti kam, me pahte ampo cunea ton xà atajê na me pahtehcajpar to ipa. ");
INSERT INTO ram_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Ne por ampeaj kam me hũpar te amji jahkre pej krã kre atajê ri me hakrya to me hakry, mã ihtỳj mehkrã kre ita me cumã cute amji kam me hapac xà jõr to ipa. ");
INSERT INTO ram_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Ỹhỹ ikra, ite amã ampo jarẽn itajê to amji japackrea ne, ne nee jũ caxuw ite gapackre xà itajê to gapac kêt nare. ");
INSERT INTO ram_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Ne pom wa amã ampo jarẽ itajê, ca ha to, ne atĩar na amji to apijapar ita na. Ne ite amã ampo to hahkre itajêa kôt, ca ha amji to guphê to hanea, pom ca ato to guphê he. ");
INSERT INTO ram_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Wa amã ampo jarẽ itajê, ca ha akrãa kam amji mã anõ, ne ma gĩ cunea to, amcro cunea kam, gàpên xà cunea kam to amji japackre. ");
INSERT INTO ram_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Ne ate ampo jahkre pejti ita to, ca ha ihhêj rũm amji mã atõj, ne cahi na apu apa. Ne ate ampo par pejti ita to, ca ha amji mã akwỳ nõ to impeaj ne, ne cume ajwar apu apa. ");
INSERT INTO ram_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","Quê ha pyjê inxyre kêanre atajê pê ampỳa mã ato ajrõ. Ne pyjê te mehhêj xi to me hũmre mã amji to hàkjêr prãmti atajê pê, ampỳa mã ato ipa. ");
INSERT INTO ram_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Pê wa jũ ata caxuw ijũrkwa jarkwa mã xa, ne apu rĩt. ");
INSERT INTO ram_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","Ne mentuwjê jàhtôa ne me hõmpu, por cormã mehkrã kre nare atajê kwỳ. Ne ite mehnõ pyxit krã nare ata mã icator ne hahkre pej, ne ampeaj kam ri ihkrã nare. ");
INSERT INTO ram_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","9","Pê mentuwjê nõ ita apu krĩ cape na mõ, pry japôj na, ne ma, por jũm cahãj ihkrĩ ata jũrkwa cahi na mõ, mã ramã ahna caxwa to mõ. ");
INSERT INTO ram_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Mã pyjê nõ inxyre pijapit te amji kam hapac xà kêanre ata te ihkà impejti nõ ata mã amji jaxàr, ne ma cuna mã mõ, ne cute me ajpẽn cajpar. ");
INSERT INTO ram_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Ne cahãj xyre pijapit ata pê amji wỳr me hũmre na hàhwỳr catê, na pê nee ihpahàm nare, ne ihkrãhhia kam ajco me hũmre cukij, ne ma ajco krĩ cape na apu ipa. ");
INSERT INTO ram_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Ne hãn ne ajco pry japôaj na hirãa pê ame hikaj to ipa, ne por jũ ri me hũmre me cuprõ ata ri, hirãa pê ame hikaj to ipa. ");
INSERT INTO ram_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Ne mentuwjê nõ ita cator, mã cute impỳn ne cahôr, ne ihcakôc xà na ihpahàm nare ata to cumã: ");
INSERT INTO ram_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","— Ita caxuw imã amji kĩn jõ catia ne hàhhuc, ne imã hĩa to hĩ. ");
INSERT INTO ram_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Cwỳrjapê wa ajpên apu gapên to mõ. Ne wa tee apu acajpar to prãm to ipa. Ne hamre, ita caxuw pahte ajpẽn cajpar! ");
INSERT INTO ram_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Ne ramã ite, por ihneat rũm cupẽhkà impejti krorti cator ata to panõr xà cahty. ");
INSERT INTO ram_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Ne ite ampo cacô cuxwati ata to panõr xà ita cuxwa. ");
INSERT INTO ram_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Ajpên ikôt mõ, cu ha ita kam amji to pahpahàm nõa to apẽ, ne ajwar ajpẽn pyrên pajakryti ne. ");
INSERT INTO ram_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Ipjê nee ijũrkwa kam apu mõr nare, ne ma ihtẽm xà jũwrya wỳr amũ tẽ. ");
INSERT INTO ram_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Ne cute ihpore catia ne ipyr ne amũ to tẽ, ne quê ha jũ mã amji to amcro to, ne cormã hacpỹ ne amji jaxà — hajỹr. ");
INSERT INTO ram_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Ne cute ihhêj xi xà atajê to ihcajpẽar prãmte cama cumã ihhêj xi. Mã pea cute ahna amji caxàr. ");
INSERT INTO ram_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Ne ahna ahtũm nare mã ma ihkôt mõ, ne ihhêj rũm cupê pryti te apu ihcuran xà wỳr ipa, ne ihhêj rũm cupê ampo pry te catêtêc xà wỳr apu ipicahur. ");
INSERT INTO ram_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","Por curi ampo te hapôc tu xà ata wỳr. Ne ihhêj rũm cupê cuwênre te ihpro xà na, nee amji jahkre pej nare kam apu imprar ata na, pê wa hõmpun to hane. ");
INSERT INTO ram_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Ikra, ita caxuw ikam gapac to impeaj ne, ne ma ihkôt hakop, pom wa amã ampo jarẽ itajê kôt. ");
INSERT INTO ram_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Ne nee amji na pyjê nõ te hajỹr ata jamãr quê apê gĩ te amji kam hapac xà pyr nare, ne nee apu pyjê te hajỹrjê kôt apa prãm nare. ");
INSERT INTO ram_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Ramã me hũmre kwỳ te pyjê nõ ata cwỳrjapê amji na mehpahàm catia incwỳr. Ne ramã incwỳrjapê mehtyc atajê jàhtôa, ca nee me hàhtô na me cahyt par nare. ");
INSERT INTO ram_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Ca ha ate pyjê te hajỹrjê jũrkwa wỳr apa na, ca ha ramã mehtyc jõ pjê wỳr, ca ha apa, ne amã gõ pry hatujre ne. ");
INSERT INTO ram_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","2","Pahpãm pyxit peaj ne cute amji jahkre pej catia to cati. Ne cumãa ri jũ mã pahte amji kam me pajapac xà ata na me pajahkre pej. Ne cupêa ri me pahkrã kreti to cute me pamã hahkre catê, na cu catyt kam ihkôt me papa jahkre pej. Pahpãm te amji jahkre pej catia ata pê me hũmre nõ te hũrkwati catia ton, ne kam amji kĩn nõ ton ata pyràac. Ne cute me hõ jàhtôa to cuprõn, ne hàpàn xà na me cumã hãm. ");
INSERT INTO ram_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","6","Ne hanea ne cute cumã me hàpên catêjê kwỳ kujahêc, krĩ cape na, mã ame cumã me hàkjêr to me pra, mã cute me to cuprõn xà caxuw me cumã: — Me amã prãm, ne me amã kôr atajê! Ajpên ijũrkwa wỳr ame pra ne ame apà ne ame ikõ! — hajỹr. Ita jĩkjê na mã Pahpãm te me pamã ampo to hahkre xà itajê pê me pajõ pyràac. Ne ihtỳj me pamã to hàkjêr to ipa ne me pamã: — Ate me amji jahkre kêatre ne me akrã nare atajê! Ajpên iwỳr me apkjê, ne ite me amã ikrã kreti to hahkre xà ita na me ikampa, ne ate me amji jahkre kêt itajê mã me hikra. Ne catyt kam amji to me ajpa. Ne me akrã kreti itajê to me hahkre, ne me hahkre pej. Ampo na? Me akrã kreti itajêa kôt ca ha quêt me apej pêa mã me apa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Ỹhỹ me ikwỳ, ca ha mehkêanre nõ to ate impejti to prãmte cumã, cute amji kam hapac xà pejti to hahkre, quê ha cama ajte apu akam incryc, ne ihtỳj apu ato kên prãm. Ca ha ate jũm te hajỹr to impej prãm to apu amõr na, ca ha caa apu amji to akên japên to mõ, ne apu apahàm. ");
INSERT INTO ram_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Cwỳrjapê ca ha cute me hajỹr catêjê to tojnõ, ne nee apu catàtkre na me acjêj nare. Ampo na? Nee mã ampo na nare, ca ha ate ampo kên tête cumãn jahpan xà na, quê ha ihtỳj apu acurê. Ne mehkrã kreti te nee me hajỹr nare. Ca ha ampo kên tête cumã, quê ha ate ampo kên tête cumãn xà ita jahpan xà na, ihtỳj cumã akĩn. ");
INSERT INTO ram_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Ne me hũpar pejti catêjê ca ha me jũm japackre, quê ha hipêr me hũpar krã kreti ata to amji mã me ajcamẽ. Ne me hũmre catyt kam me ipa atajê quê ha hipêr me hũpar to me ajcamẽ, ne catyt kam ame ipa. ");
INSERT INTO ram_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Ne quê ha jũmjê amji to ihkrã kreti to prãm, ne mam cati mã amji mã Pahpãm cupahti to ipa. Ỹhỹ, por jũm amji mã Pahpãm pejti cupa ata, quê ha ihtỳj cute amji kam hapac xà impejti te Pahpãm cajpuaw ata to amji to ajpa. ");
INSERT INTO ram_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Ne mehkrã kreti atajê, mehkrã kre atajêa mehtehcajpa, mã amji to me ipijapar to me irya to me iry. ");
INSERT INTO ram_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Ca ha ate amji mã Pahpãm krã kre te amji jahkre pejti ata pyr na, ca ha atỳj to amji mã ampo pejti jàhtôa ne to. Nãmri ca ha ate amji pê Pahpãm krã kreti ita caca na, ca ha me pahcurê xwỳn pê Xatanaj te amji kam hapac xà kêanre ata py ne caa akên mã amji jaxà. ");
INSERT INTO ram_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Ne Xatanaj ata pê ihhêj rũm jũm cahãj xyre ata pyràac, mã me hũmre to hapactu to pit mã amji kampa, ne ma apu Pahpãm kôt ampo pej krã kreti itajê to amji kam hapac caca. ");
INSERT INTO ram_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Ne hãn ne ikre jarkwa mã ihkrĩ to ipa, ne krĩ cape te amji jacjên kam ipa. ");
INSERT INTO ram_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","Ne hãn ne me hũmre, cute amji kam me hapac xà wỳr me pra atajê jator to me cumã hàkjêr to ipa. ");
INSERT INTO ram_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","Ne cute me amji cajpẽr, krã kre nare atajê mã harkwa to: — Ajpên ijũrkwa wỳr ikôt mõ, ne ipjê pê ina gũhkra! ");
INSERT INTO ram_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","He, ampo to me pajàhkĩj itajê ri quêt impej! Ne kwỳr te pro to me pajàhkĩj itajê ri quêt papimxuar pê pahte mehkur xà, ne ampeaj kam cuxwa! — hane. ");
INSERT INTO ram_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Mã me hũmre jàhtôa ne hãn ne ihtỳj me kampa, ne amji mã me to hane, ne ma mehtyc xà wỳr me pra, cute me amji jahkre pej nare kam. Ne ramã me hàhtôa te amji mã mehkên xà ita capi, na quê ha ma jũ caxuw cuhy tyc xà nare ata wỳr me pra. ");
INSERT INTO ram_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Ỹhỹ, jũm xũmre mã ihkra krã kreti ata pê, hũm me inxi mã amji kĩnti ton catê. Ne ihkĩnte jũm kra krã kêanre, jũpar nare ata pê ri hũm me inxi mã amji kĩn nare ton catê. ");
INSERT INTO ram_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Ne por mehhêj xi xà jàhkĩj kôt amji to me hakràj atajê, mã nee me hakryti xà nare. Ne quêt catyt kam me ipa xà ata pê ri me hakryti me, me caxwãm pê me carĩcti ton xà. ");
INSERT INTO ram_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Ne Pahpãm pê Pahhiti ata nee hãn ne prãm te mempejti curan na me hamãr nare. Ne mehkên catêjê te amji mã ampo na mehprãmti atajê ri, Pahpãm ma ame cupê intê, ne intête ame to jũa mã, mempejti atajê kĩnte. ");
INSERT INTO ram_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Ne cute me xuwcacati atajê pê ri ampo hamreare. Ne quêt me hàpên prãmti catêjê mã ri, ampeaj kam ampo mã me to hakràj. ");
INSERT INTO ram_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Ne por jũm ampeaj kam amji kampa ata ri, hãn ne hàprà kẽhkẽn xàa jõ amcro na ihkẽhkẽ. Mã hàprà kẽhkẽn xà jõ amcro kam hãn ne hõtxwaa to hõtxwa mã gõr ata ri, cama ihkĩnte amji na ihpahàm rẽ. ");
INSERT INTO ram_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Pahpãm hãn ne ihcunea na mempejti catêjê to impej. Ne mehkêanre catêjê ri mempejti kĩnte me harkwa pejti kam, cute amji kam me hapac xà jàprêhti itajê to me amxu. ");
INSERT INTO ram_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Ne mempejti catêjê to, nee me hapac kêt xà nare. Kĩntee mã ri mehkêanre catêjê to, ihtỳj me hapac kêt xà. ");
INSERT INTO ram_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Me hũmre krã kreti atajê ri, ihtỳj me hakrya kam amji mã, cute me hapackre xà atajê incwa. Kĩntee mã, quê ha jũmjê amji to mehkrã kreti pyrentu prãm atajê me amji jarẽn to: “Wa ramã ite itajê impar jahkre pejtu” hajỹr na, quê ha taa ramã amjia pê, cute amji kam hapac xà caca to mõ. ");
INSERT INTO ram_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Ne por jũm mã cute amji kam hapac xà impejti jahkre pejti ata, quê ha nee apu amji mã ampo cupa to hajỹr nare. Kĩntee mã quê ha jũm apu ihhêj xi to mõ ata, quê ha ihtỳj ihkên mã me axà. ");
INSERT INTO ram_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Quê ha jũm te ampo kên na jũm pupun, ne nee intête cumãn nare na, quê ha ihtỳj jũm ata cama amji mã ihkên to ajcamẽ. Ne quêt quê ha jũm ampo kên tête me cumãn kam incrà, quê ha cama mehkwỳ to impejti japên to ipa. ");
INSERT INTO ram_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Ne por catyt kam me hũmre cakôc xà impejti ata, ihtỳj mehkwỳ te catyt kam me ipa na mehtehcajpa. Kĩntee mã ri me hũmre cakôc xà kêanre atajê, cama mehkwỳ to kêanre to prãm to me ipa, ne cumã hàwxũn me, me to kên pit jahkre pej. ");
INSERT INTO ram_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Me pancryc me, pahte me pahkwỳ curê me, pahte me ajpẽn par nare ita, ihtỳj me papijapu na me pahto. Ne me pahte me ajpẽn kĩnti ata pê ri quêt pahte me pahkên cunea to me pajapac kêt xà. ");
INSERT INTO ram_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Ne mehkrã kre cakôc xà atajê cunea kam ri quêt me pamã amji jahkre pej pit. Ne mehcakôc xà krã kêanre atajê pê ri mehkĩnte cama mehkên mã me irẽn xà. ");
INSERT INTO ram_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Ne cute me amji jahkre pejti atajê ri, hãn ne amji mã, cute mempejti atajê pupun xà cunea kôt amji mã me nõr to me ipa. Ne mehkrã kêanre catêjê ri, mehkĩnte nee me harkwa kôt hakop nare kam, hãn ne me to ihcakôc to me ipa, ne toa amji mã mehpahàmti ton to me ipa. ");
INSERT INTO ram_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Ne me hakràjti atajê ri, me hakràj te amji kam hapac xàa to me amji kampa. Ne me cupê hamreare atajê ri, mehkĩnte hãn ne me cupê hamreare te amji kam hapac xàa to me amji kampa. ");
INSERT INTO ram_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Ne mempejti jàpên xà atajêa, hãn ne me to ajcamẽ. Ne mehkêanre atajê ri mehkĩnte, pom mam mehkên xà itajê jirôa pê, amji mã mehkên to me ajcamẽ. ");
INSERT INTO ram_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Ne por ampo kên tête mehkwỳ mã, mã ahnaa me ampo jicu atajê, quê ha me hõ pry pejti kôt me ipa. Ne por ampo tête me cumã, mã nee me hũpar nare atajê, quê ha mehkĩnte me hõ pry cupa ne mehkên mã me acjêj. ");
INSERT INTO ram_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Ne mehhêj xiti atajê ri hãn ne me harkwa hêj xia to mehkwỳ kam incryc to me amxu. Ne hãn ne ampo kên na mehkwỳ jarẽn pa, ne amjia kôt hãn ne me to cati to mencràn to ipa atajê ri mehkrã nare. ");
INSERT INTO ram_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Ca ha acakôc xà to ihcupan to cati, ca ha amji mã akên xà to cati. Nãmri ca ha ate akrã kre na, ca ha ma garkwa kên to acakôc na amji jamã, ne garkwa cakôc xà impej to pit mã acakôc to apa. ");
INSERT INTO ram_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Ne mempejti cakôc xà kôt ihtỳj ampo pejti hapôj, ne cupê ihhêj rũm wakỳre prà pejti ata, ne cupê ahna hĩ jàhwỳrti ata pyràac. Ne mehkên catêjê cakôc xà ri ihkĩnte ihkôt hamreare. ");
INSERT INTO ram_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Ne mempejti cakôc xà ri me hàhtôa ne me to impej. Ne mehkêanre catêjê cakôc xà ri mehkĩnte, ma mehtyc xà wỳr me to ipa. ");
INSERT INTO ram_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Ne me Pahpãm tĩr rohnỳtti mã ata, ihtỳj caku cunea kam amã ate amji kam me gapac xà to ipicamẽn to ihcuhhê tu. Ne jũ wỳr quê iràn xà na, ampo me amã acaca xà te hajỹr xà ita to. ");
INSERT INTO ram_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Ne me hàprêhti atajê mã, me hàprê xà ata pê ihhêj rũm me hapactu xà, ne me cumã ihkĩn. Jĩkjê na ri, mehkrã kreti atajê mã cute amji kam me hapac xà impejti atajê, mã hũrên ame hakry. ");
INSERT INTO ram_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Mehkên catêjê mã ihtỳj ampo cupaa to hũpa, ne cumã hũpahti ata quê ha ihtỳj to hanea to, to hane. Ne mempejti atajê ri quêt ihtỳj cute me amji kam hapac xà impejti na me hapôj. ");
INSERT INTO ram_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Quê ha kôc pahtỳjti ajpên mõ ne cato, ne mehkên to hamre tu. Ne quêt mempejti krã kreti atajê, quê ha ihtỳj amehcuhhê, quê ha nee kôcti ata jũmjê atajê rẽn, ne me to ihtẽm nare. ");
INSERT INTO ram_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Ca ha nee jũ caxuw ampo ton xà ata wỳr jũm te xuwcacati ata kujahêc nare. Ampo na? He cute me hajỹr catêjê pê ihhêj rũm ampo cacô te me wa cahhêc xà, nare, me cupê ihhêj rũm me panto kam cuhy kũm, ne ihtỳj ihhahac. ");
INSERT INTO ram_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Ne por jũm amji mã Pahpãm tĩr rohnỳtti mã cupahti ata mã, cute amji to ipijapar xà japjêa to hapjê. Ne por mehkrã kêanre, ne nee amji mã Pahpãm cupa nare atajê, quê ha mehkĩnte, cute amji mã me to amcro hyr xà ata japyre mã me ty. ");
INSERT INTO ram_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Ne por mempejti atajê ri ihtỳj cute me ampo pejti cwỳr xà atajê jikaj, ne ihtỳj hãn ne me cucwa. Ne mehkên catêjê te nee me hajỹr nare, na quê ha nee jũ caxuw me ampo pyr nare. ");
INSERT INTO ram_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Pahpãm tĩr rohnỳtti mã ata ihtỳj mempej pytà. Ne mehkĩnte mehkên catêjê mã ihtỳj mehpahàmti gõ. ");
INSERT INTO ram_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Ne por catyt kam me ipa atajê mã ri ihtỳj mehkrĩ xà. Ne mehkĩnte mehkêanre atajê pê ri mehkrĩ xà hamreare, ne nee mehkrĩ kam mencrà xà hamreare. ");
INSERT INTO ram_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Ne por mehkrã kre te amji jahkre pejti atajê mã ri, ihtỳj mehcakôc xà krã kreti to me hapackre xà. Ne por mehkêan kam ampo kêanre to me hapackre to me ipa atajê, quê ha ihtỳj mehkên xà kêanre atajê mã me amji gõ. ");
INSERT INTO ram_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Me hũmre krã kreti atajê, ihtỳj hãn ne mehcakôc xà kam me hapac prãmti atajê to, me cumã mehcakôc. Ne mehkrã kêanre atajê ri ihkĩnte cama me harkwa kêanre to mehkwỳ kên mã curẽ. ");
INSERT INTO ram_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Me ikampa. He wa ha me amã mehkrã kreti te me hapackre xà itajê to hahkre. Ca ha ampeaj kam, cute me hapackre xà impejti itajê to me hahkre, ne ate me hahkre pej na, ca ha ihkôat me amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","Ne ate to amji japackre xà ata kam, quê ha ampeaj kam amã mehkĩn na, ca ha atỳj ihkôat me apa, ne toa me acakôc to me apa. ");
INSERT INTO ram_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","20","Wa ha ita kam me amã me hapackre xà itajê to hahkre, mãr ca Pahpãm to pit mã amji mã me ahimpej, ne toa amji mã me ahimpej to me apa. Ne wa ha, ite me gapackre xà te trĩnta itajê na, me amã ihhôc. Quê ha taa amji to me amã hahkre, ne ihtỳj me gapackre xà impejti to me gapackre. ");
INSERT INTO ram_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Ata quê ha ihtỳj catyt kam ate amji kam gapac xà impejti to me apa jahkre pej na, me atehcajpa. Quê ha jũm te ahna me acukij na, quê ha ihtỳj amã catyt kam, ate me cumã harẽn xà atajê hahkre pej. ");
INSERT INTO ram_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","23","Nee ca ha me cupê hamreare atajê pê hamreare na harẽn xà kôt ame to kêanre nare. Ne nee cute mehcukij xà kam, cute me amji pytàr xà caxuw me cupê hamreare atajê to, ame amji to pejpej nare. Côt mã Pahpãm ihkrĩ rohnỳtti mã ata me hũtà, ne mencwỳrjapê cute me cupê hamreare atajê mã amji cawpa catêjê atajê to kêanre ne. ");
INSERT INTO ram_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","25","Ne nee me hũmre jàprêhti incryc xiti atajê to ame amji kwỳ nõ prãm nare. Côt ca ihhêaj to amji mã cute amji kam hapac xà atajê incwa, ne ihkôt apu apa, ne nee jũ caxuw cupê acator nare. ");
INSERT INTO ram_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","27","Ca ha nee jũm jũ jahpan xà na, gàmjõr na amji ton nare. Ampo na? Ca ihhêaj to gàmjõr nare, quê ha ihtỳj cute to new ata jahpan xà na, amji mã apê gikwa xà cunea to cutor tu. ");
INSERT INTO ram_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Ca ha nee me aquêtjê te me amã pjê rer ata hyr xà jirô pê to apỳm nare, ne nee acahê na jũm jõ pjê ata to cupê incri nare. ");
INSERT INTO ram_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Xà ajkĩ jũm te hàpên xà to impejti ata na amã hahkre pej? Quê ha ahtũm nare, quê ha hàpên xà impejti to cute hàpên xà ton ata na, me hõmpu. Quê ha pahhi cati impej nõ amji mã to cumã hàpên catê, quê ha cumã apê. ");
INSERT INTO ram_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","3","Quê ha jũm jàmkrã cati te amji cahê na gàpên xà na gator na, ca ha ma hàmkrã cati ata na to amji japackrea ne. Ca ha ate gàpàn cati na, ca ha nee cuna mã gàpàn cati nare. Ca ha nee cupê cute hõ kur xà ata kur to gũjarên nare. Ampo na? Quê ihhêaj to cute amã ihhêj prãmte quê gato. ");
INSERT INTO ram_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","5","Nee ca amji to gakràj prãmte, gàpên xà to amji curan prãm nare, ne nee to pit mã, amji mã ahimpej to apa nare. Ampo na? Quê ihhêaj to gõ pore ita ihtỳj kam hara to hanea, pom quê hàcti kam hara mã to he. Ne ma to, ne apê ampỳa mã apu ipa. ");
INSERT INTO ram_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","8","Ne nee ca cute me hakràj cati to pit mã me amji kam hapac atajê cahê na gàpàn to prãm nare. Ca ihhêaj to ate cahê na gàpàn na, ca ha nee cumã hõ impejti ata kur to gũjarên prãm nare. Côt mã amã: — Hipêr incrire ne krẽ — hane, ne cama apu amã ihhêj. Cute hõ ata jahpan xà na apê ampo catia pyr prãmte ri amã ihhêj. Ca ha ate ihkôt amji kam gapac, ne atỳj garte cati na, quê ha pea hõ ata jahpan xà na ana ahwỳ. Ca ha ate hacpỹa mã cumã hõ ata jõr xà na, atỳj to gõjahĩr prãm. Quê ha ampeaj kam cama akam incryc, ne nee ate cumã acakôc xà ata na apar nare. ");
INSERT INTO ram_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Nee ca apu cute me amji mã hamãr nare atajê me, nee catyt kam me ipa to prãm nare atajê mã, acakôc xà krã kreti atajê to acakôc nare, cute me apar to mã apu. ");
INSERT INTO ram_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","11","Ne nee ca me huwatĩ atajê pê me hõ pur to gàhkĩj prãmte, gõ pur hyr xà to apintuw, ne me hõ pur kam hãm nare. Ampo na? He por ihtỳj Pahpãm me huwatĩ to ajpa, ne me hamã, ata quê ihtỳj mehtehcajpa, quê me ahna apupu ne ate me to amji kam gapac xà ata to ana apkjê, ne to akên mã amẽ. ");
INSERT INTO ram_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Ampeaj kam cute me amji jahkre pej catêjê te me amã ampo to hahkre xà atajê na me kampa, ne hahkre pej ne amji mã anõ, ca ha quêt mã ca, amji krã krea japê. ");
INSERT INTO ram_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","14","Ne nee ca akra japackre jicu nare. Nãmri quê ha cute apar nare na, ca ha atỳj hũhcatêtêc. Quê ha ate hũhcatêtêc ita nee ihcuran nare. Quê ha cama to ihtyc xà jahpa. ");
INSERT INTO ram_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","16","Ỹhỹ, ikra xũmre. Ca ha ate akrã kreti na, wa ha ampeaj kam apyrên ijakry, ate acakôc xà krã kreti to acakôc ata pyrên. Ne wa ha itỳj ijakryti na amji cajpẽ. ");
INSERT INTO ram_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","18","Nee ca mehkên ton catêjê jũ na, cute amehkên ton xà atajê kĩn nare. Ate amji mã Pahpãm cupahti na, ca ha amcro cunea kam amji to ahcukij. Ita na quê ha acumam amã ate amji kam gapac xà impejti ne, ne por ca ampo pejti jikaj atajê, ca ha atỳj acwa. ");
INSERT INTO ram_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","21","Ỹhỹ, ikra xũmre ikampa. Ca ha ate amji jahkre pej na, ca ha atỳj caxwãm catia mã amji kampa. Ne nee apu cute me côxỳhti xenti catêjê kôt apa nare, ne nee ame hõ to mehtũm prãmti jàpàn catihti atajê kôt me apa na me amji to prãm nare. Ampo na? Pom cute me côxỳhti xenti atajê me, caxuw me hàpàn catihti atajê, ampeaj kam me hõtxwa, mã cama me hikwa ne ame gõr. Ne me cupê ampo hamreare, mã mehkà kêanre kam ame ipa. ");
INSERT INTO ram_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","25","Apãm kampa, cute gapackre xà atajê cunea na. Ampo na? Ate impar na ri amã impej. Ne anã krã kreti ata, ca ha atỳj kampa, ne nee ca ramã ihwej kam apu impar caca nare. Ne por ampeaj kam ampo pejti to hahkre xà atajê, ca ha kampa, ne amji mã huwahi, ne catyt kam apejti na apa, ne nee jũ caxuw amji pê to gapac kêt nare. Por me hũmjê nõ mã ihkra xũmre te catyt kam ipa, ne ihkrã kre ata, quê ha ampeaj kam hũrên hakry. He apyrên apãm jakryti na to, quê gũrên hakryti ne. Ne anã to hanea, ne cumã amji kĩnti jakryti to. ");
INSERT INTO ram_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","28","Ỹhỹ ikra xũmre, acaxwỳn cunea to, ite gapackre xà itajê kôt ca amji to, ne ampeaj kam ahna ikampa. Ne mempijapit pê ampỳa mã apu apa. Nãmri me cupê me gõ pry tête me akên mã me arẽn catêjê. He me cupê ihhêj rũm aracri cute me apê ampo to hàhkĩj catêjê pyràac. Ne cute me hũmre jàhtôa ne ramã me cumã ihhêj, côjkwa kam Pahpãm me, mehprõ mã cute mehhêj prãmte. ");
INSERT INTO ram_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","35","Jũm mõrmõ hĩ kam cute amji pupun xà kêanre me, ihkàj xà te cumã hipu? Mẽr jũm mã ihtỳj ame ipijapu xà mã incjêj to ipa, ne mehkên mã incjêj to ipa? Ne mẽr jũm mã hõtpê me haxôp, mã ihkàj xàa na ipa? Ne mẽr jũm mã hõtpê into kàhtuhti ita na apu ipa? He jũm nare, por me hũmre nõ me hàkrun xà kam apu ipa, ne cormã mã ihtỳj ajpẽn caxuw côxỳhti to ajcacwa, ne to ikõ ata te ri hajỹr. Ne nee acuhhê ne mehkõm xà kam ampo cacô xỳre jiwrỳhti ata pupun nare, nãmri ampeaj kam hỳ pahtỳj. Ampo na? Quê ha ihtỳj itajê cunea jicu xàa kam hacpỹa mã cupê cagã kêanre ata pyràc, ne ihtỳj axa ne acura! Ca ha ampo te jũa na ata pupu, ne atỳj garkwa te amji jahkre kêatre ata nõ to acakôc. Ne ato kam waj akam tẽ, ca ha apê ihhêj rũm cô harô to imprar kam, pàr kre kam me ipa atajê pyràac, ne atỳj ampo kam garij to apa, ne to amji jahyr to apa, ne atỳj apu apỳpỳm to mõ. Ne ampo na mã ca ha apy ne ahna amji juwahi? Ne ana ahtũmre, ca ha cormã jũm ata te acahhyr na amji cajpẽ, ne amji mã garkwa to: — Mõrmõ jũm aracri apu icahhy, wa nee ite ikàj xà nõ na amji cajpẽr nare — hane. Ne cormã akrã ajrõ, ca ha amji mã garkwa to: — Jũ caxuw wa ha ajte ikrã impej ne xa? Wa tee apu ixãm to hahkre. Wa ha to xa ne itỳj hipêr ihkwỳ incrire ne to ikõm prãm — hane. ");
INSERT INTO ram_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","2","Nee apu mehkên catêjê jũ na mehkên kĩn nare, ne nee ame to amji kwỳ prãm nare. Ne mehkên catêjê me hàprê to pit mã ame amji kam me hapac to me ipa, ne mehcakôc xà kên to pit mã mehcakôc to me ipa. ");
INSERT INTO ram_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","4","Ca ha ate ampo pejti to acukrêj to prãm na, ca ha xa akrã kreti to gakràj, ne cormã ampo pejti pê acukrêj atajê to gakràj. Hõhõ, ita na ca ha me akra te me amã ampo na prãm xà atajê cunea to me cumã, ne me cumã agõ. ");
INSERT INTO ram_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","6","Ne quêt mehkrã kreti ita ri mehhi tỳj jirôa pê impej. Ca ha jũ caxuw apijapu prãmte me ipijapu catêjê wỳr axà, ne nee amji pê cute me amã ihkrã kreti to hahkre catêjê atajê to gapac kêt nare, mãr quê me amã akrã kreti to hahkre. Quê me amã ampo to hahkre catêjê me hàhtôa to me hàhtô, ca ha cute me ampo to hahkre xà itajêa kôt atỳj me hirô pê xa. ");
INSERT INTO ram_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Ne por amjia kôt ame ipa to prãm atajê, quê ha jũ caxuw mehkrã kre nare, cwỳrjapê ca ha nee cute amã ate catyt kam ampo to hahkre xà na ihwỳr nare. Ampo na? Ampo to quê amã hahkre? ");
INSERT INTO ram_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","9","Por me hũmre hãn ne mehkwỳ cuna mã amji mã, cute amji kam me hapac xà kêanre capô, mã ahna me hahkre pej, atajê ri hãn ne mehcunea kam mencryc, ne me cupê ampo kên cunea xakat. Ne por mehkrã nare atajê cakôc xà kêanre, mã hãn ne ihtỳj mehkên mã me curẽ. Ne por mehcunea ihtỳj ame cumãn to, me cumã me hàhcahhõn to me ipa atajê kam ri, mencryc pit. ");
INSERT INTO ram_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Quê ha akam ampo kên te cator xà ata kam, ate kam akrã pictor tu na, ca ha apê jũm peacre caprĩ xàre ata. ");
INSERT INTO ram_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","12","Ne por cute me jũm curan xà caxuw me cupjê ata, ca ha ajte mehtehcajpar ne me hũtàr to hahkre xà kaj na, ca ha ajte ahna me amji jarẽn to: — Xà aracri ite amji kam ijapac xà, wa ajte ihcote na axà? — hajỹr na, ca ha atỳj Pahpãm te me pahcunea mã, me pahte amji kam me pajapac xà pupun na, me to amji japackrea ne. Ampo na? He quê ha ihtỳj Pahpãm te ampo kên na me pahpupun xà atajêa jahpan xà na, me pamã me pahkên atajêa to amgõ. ");
INSERT INTO ram_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","14","Ỹhỹ ikra, pen ca ku, ne inxôti ita na ihcajpẽ, quê ha acajpuaw. Ahnaa mã ca me pen cajpẽ mã garkwa kam inxôti he. Jĩkjê na mã, ate me amji jahkre pej krã kreti ita me acaxwỳn mã impeaj to impej. Ca ha ate to hamãr na, quê ha acumam amã ate amji kam gapac xà cunea amã ihkênre nare. Na ca ha nee amji pê ate hikaj ata to apictor prãm nare. ");
INSERT INTO ram_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Ne ca, me hũmre nõ kêanre ita! Nee ca apu hũmre krã kre te amji jahkre pejti ata jũrkwa wỳr arĩt nare, ca ate cupê ampo pytàr, ne cupê ipyr prãmte, ca apu hỹrmã rĩt. ");
INSERT INTO ram_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","He mehkrã kre catêjê ihtỳj me hipy mã me acjêj, ne hõtpê hacpỹa mã mempej mã me acjêj, ne mehcuhhê. Ne mehkên catêjê, quê ha mehkĩnte mehkên kam mehpahàmti atajêa kam me hamre. ");
INSERT INTO ram_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","18","Pahpãm ihtĩar ihkrĩ rohnỳtti mã ata mã mehkêanre catêjê to hamre prãm nare, ne quêt cama cumã cute mehkên ton jicu na to prãm. Na ca ha nee ame acurê xwỳn kên xà kam mehpahpahàmti atajêa kam me hamre atajê pyrên ame gakry nare. Mã Pahpãm ahna me gahkre pej, ne ahna cumã me akĩn nare ne, quê ihhêaj to cute gahpan xà na acurê xwỳn to kên xà ata jicu. ");
INSERT INTO ram_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","20","Ne nee cute ame to kên xà kôt, cute amji to me cati atajê jũ na apu akrihkrit nare. Ne nee me hũ na amehkên to atajê kĩn nare. Ne cute mehkên ton catêjê cumam me cumã, nee cute me amji kam hapac xà impejti hamreare. Ne ihhêj rũm me cupê ramã ihpôc xà tyc xàa wỳr, ne ihpôc crire ne. ");
INSERT INTO ram_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","22","Ỹhỹ ikra, he amji mã, por Pahpãm tĩar rohnỳtti mã ata cupaa ne, ne amji mã pahhi catêjê cupa. Ne nee, por ame pahhi cuna mã, ame kam incryc atajê mã acjêj nare. Ampo na? He Pahpãm pê Pahhiti, quê ha cute me hajỹr catêjê to hamre, me mõr pejti kam. ");
INSERT INTO ram_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Ỹhỹ ikra, ita caxuw wa ha aprõ na ato ihimpej, ne amã to hahkre. Pyjê jàhtôa to hàhtô, ne jũ wỳr ca ha uu ne me catàtkre na aprõ nõ impejti ata mã acator pyrentu. Nãmri ca ha ate me catàtkre na cumã acator na, ca ha amji mã huwahi to impeaj ne, nãmri ihpore jakôtti ita jirôa pê impej. He me pahprõ pejti te hajỹr, pom quê ite me amã ampo jarẽn itajê he. ");
INSERT INTO ram_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Mã ramã impjên te hĩxi pejti ita pupun pejtu ihcunea na, na ri nee jũ caxuw cupê ampo hamreare nare. ");
INSERT INTO ram_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Mã amcro cunea kam, cute amji kam hapac xà cunea kam to impejti to ipa, rỳ jũ caxuw cute apu amji pê to kên nare. ");
INSERT INTO ram_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Ne hõtpê ampo cunea to hàpên to catia to ipa, ne mehkra mã cupẽhkà te mehkà ton to ipa. ");
INSERT INTO ram_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Ne cupê, pom hãn ne pàr kre hũwry catia pĩn ampo to ipa atajê pyràac, ne hũwry catia pĩn hãn ne hũrkwa wỳr amji mã hõ to hapôj, mehkra wỳr. ");
INSERT INTO ram_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Ne hãn ne awcahti xà wỳr ihkrĩ, ne mehkra mã apu hõ ton to ipa. Ne ma cumã hàpên catê pupu, ne hamãr to ipa, ne ma cumã harkwa jirê, ne to ihhimpej to ipa. ");
INSERT INTO ram_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Ne por hàpên to ipa ita jõ porea to, me cupê amji mã hõ pjê jũhkà, ne kam amji mã pĩxô pejti kre to ipa. ");
INSERT INTO ram_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Ne hàpên xà cunea caxuw ihcuhtỳjre. ");
INSERT INTO ram_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Ne cumã hàmjixur pejti na hahkre pej. Na ri ihtỳj to hĩ to ahwỳa to ahwỳ. Ne ampo pej pit japrôr to ipa, ne hãn ne hàpên to caxwa rytu. ");
INSERT INTO ram_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Ne taa amji mã to cupẽhkà hy, ne amji mã to ihkà. ");
INSERT INTO ram_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Ne hãn ne me cupê ampo jamreare atajê tehcajpa, ne me cumã ampo jõr to ipa, ne ame hàhwỳr to ipa atajê mã ampo jõr to ipa. ");
INSERT INTO ram_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Quê ha krya to kry, quê ha nee apu amji mã hũpa nare. Ampo na? Ihtỳj mehkra mã mehkà. ");
INSERT INTO ram_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Ne ihtỳj amji mã me hàhpro xà to, na ri ihtỳj taa amji mã ihkà hẽrhẽtre tỳjre ata to, ne to ihkà. ");
INSERT INTO ram_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Mã mehcunea amji mã mempjên pejti na harẽ, ne ihtỳj amji mã me hũpa to me ipa. Ne ampeaj kam me cumã cati, hõ krĩ ata kam. ");
INSERT INTO ram_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Ne ihtỳj ahhy, ne cute me hũhkàr catêjê mã ihpore na to ahpa. ");
INSERT INTO ram_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Ne catyt kam ipa. Ne nee cumã cute amji to ipijapar cupa nare, ne cumã ahna mehpahàmti xà. ");
INSERT INTO ram_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Mã ihcakôc xà te amji jahkre pejti, jàhcaprĩhti to ihcakôc to ipa. ");
INSERT INTO ram_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Ne jũ caxuw apu xuwcaca nare, ne ihtỳj mehkra jamãr to ipa. ");
INSERT INTO ram_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Mã mehkra amji mã me harẽn pejti to me ipa. Mã impjên ihtỳj amji mã hĩxia jarẽ, ne amji mã harẽn to: ");
INSERT INTO ram_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","— Mehprõ kwỳ kên nare cakrô, ca me hirôa pê apê iprõ impejti — hane. ");
INSERT INTO ram_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Ỹhỹ, ikra, pyjê jĩ cunea na impeaj to mempej cakrô, quê ha impejti ita ihtỳj jũ caxuw ihwej, ne ihcunea na impejti ita hamre. Ne por pyjê kwỳ quêt amji mã Pahpãm tĩar cupahti atajê, quê ha ihtỳj quêt amji mã mempejti na me harẽn rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Ỹhỹ ikra, ca ha ate amji mã aprõ te hajỹr nõ mã acator na, ca ha amji mã to impeaj ne, ne hãn ne cumã garkwa to: — Ihcunea na imã akênre nare gàpên xà me, acakôc xà cunea kam. Mã mehcunea amji mã me garẽn to impejti to me ipa — hane. Hamre.");
INSERT INTO ram_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Pê Pahpãm hipêr harkwa to ihcakôc catê pê Ixaj ata mã harkwa kujahêc to hane he: “Quê ha jũm pĩ pàr nõ kat na hakep, quê ha ihtỳj ipàr wej ata kat kam, haxà kam hitêr, ne kam ipàr tuw nõ cato. Jĩkjê na, quê ha pahhi xwỳ pê Tawi tàmxwỳ tàmxwỳ nõa cato. Ne quê ha ramã pahhi xwỳ pê Tawi ihtyc cakrô, quê ha ihtỳj ihtàmxwỳ tàmxwỳ nõa cato, ne cupê imã hàpên catê. ");
INSERT INTO ram_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","“Quê ha ipê Pahhiti Carõ Pejti ata cumã amji gõ, ne ihkôt cumã ihkrã kre te amji jahkre pejti gõ, mãr quê carôt tỳjti to me hapackre, ne ihtỳj cumã ijahkre pej, ne cumã icupa. ");
INSERT INTO ram_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","Ne quê ha ampeaj kam ihcunea na, cumã ipar prãm pit. Ne cupê ajpẽn pê mehkrã kên me, me mempejti to ipicokjêr catê impeaj. Ne nee quê ha cute mempar xà kôt pit mã, põ rũm cute me hõmpun xà kôt mehkên mã me irẽn, ne mempej mã me irẽn nare. ");
INSERT INTO ram_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","Ne quêt cute catyt kam, me cupê ampo hamreare atajê tehcajpar prãmte, cute ame to kên catêjê atajê kên mã me curẽ. Ne harkwa to cute me cumã ihcakôc xà to, quê ha me hipej. ");
INSERT INTO ram_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Ne ihtỳj catyt kam ahpỹanre na, mehcunea to impej to ipipẽnti to ipa. Ne ihtỳj cute ampo to hũjahkre xà ata na, amji jarkwa par to ipa. Quê ha mehcunea ahna me hõmpu, ne me cumã impejti ne. ");
INSERT INTO ram_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","“Ne quê ha pahhi xwỳ pê Tawi tàmxwỳ tàmxwỳ ata himpej xà jõ amcro ata kam, quê ha ampo cunea hacpỹa mã, mam cute amji ton pê mã, amji ton xà ata na quê ha. Ne rop cahàc jàprêhti atajê hacpỹa mã capônỹre ne, ne ihtỳj carà cahàcti hôhti atajê cahê na apu ipa. Ne ropkror jàprêhti atajê hacpỹa mã capônỹre ne, ne ihtỳj carà cahàcre atajê cahê na apu hikwa. Ne hanea ne rop cahàc jõkre hôhti atajê, quê ha ihtỳj pryti krahti atajê me ajpẽn cahê na apu hàpàn to ipa. Quê ha hanea ne, ihtỳj ahkrare kwỳ amji kôt ame to ipa. ");
INSERT INTO ram_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Ne quê ha ihtỳj ampo jàprêhti pê uxô atajê hacpỹa mã capônỹre ne, ne ihtỳj pryti cahãjti atajê cahê na apu hàpàn to ipa. Quê ha pryti krare me uxô kra xwỳjê ihtỳj ajpẽn cahê na hikwa. Ne rop cahàc jõkre hôhti atajê, quê ha cupê prytia pyràc, ne ihtỳj ahtu pit kur to ipa. ");
INSERT INTO ram_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Ne me ahkrare kryjre itajê, quê ha ihtỳj cagã pahtỳj ihkrĩ xà atajê cahê na ame hàkrun to me ipa, ne ahkrare kàre itajê, ihtỳj hũhkra to parpup krĩ xà kam hahê atajê caxun to me ipa, quê ha nee mehcãmxar nare. ");
INSERT INTO ram_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","Ne quê ha ijõ pjê impejti ita kam, nee ampo te me to kên xà caxuw hamreare ne, ne nee kam ampo jamre xà nare. Ne mẽr ampo na mã quê ha ampo itajê cunea to hane? Nee mã ampo na nare. Pom côxwa hãn ne hipu, ne ampo cunea pro ne inco, mã nee incrà nare, ita jĩkjê na, quê ha pjê kam mehkrĩ atajê cunea ipê Pahhiti na me ipupu, ne me ijahkre pej pejtu ne, na quê ha nee jũm pê ijahkre kêt nare. ");
INSERT INTO ram_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","“Ne amcro ata kam, quê ha pahhi xwỳ pê Tawi ata tàmxwỳ tàmxwỳ ata pê pjê cunea jõ Pahhiti catia. Quê ha krĩxàre cunea me, pjê cunea kam ampo kra cunea, hỹrmã me cuprõ, ne me cumã amji kĩan kam ihhimpej xà krac ri me axà. Ne ihtỳj ihkrac ri mempejti to ame kôt. ");
INSERT INTO ram_vpl VALUES ("IS11_11","024_11_11","ISA","11","11","11","Ne amcro ata kam, quê ha pjê cunea pĩn, hipêr Pahhiti na mehkwỳ pê Juta catêjê me Ixaher catêjê cahhur to caprã, ne amji na me to cuprõ, mãr quê hanea ne ihhimpej xà krac ri me axà” hane. ");
INSERT INTO ram_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","2","Ỹhỹ me ikwỳ, Pahpãm te me acaxuw ito cumã ihcakôc catê na, ne imã ampo jarẽn ata, wa ha me amã harẽ. Cute imã hajỹr he: “Ca ha Krĩpinkrên kam me ikwỳ pê Juta catêjê mã ito gũjarẽn picre to awjarẽ, ne me cumã: ‘Ate me amji pupun kên tỳjti ata hamre. Ne ate me ito kên jahpan xà na, wa ramã ite me amji pupun xà kêanre na me aton to ipijakrut, na wa nee hipêr ate me ito kên ita to amji japackre nare’ hane” hajỹr. ");
INSERT INTO ram_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Ne Pahpãm te imã harkwa to imprar catê nõ kujahêc, mã cute imã caràr to: “Me pajõ Pahhiti mã, ate amji kam me gapac xà kên atajê jicu, ne me to impej xà te hajỹr he: Ca ha gõ pahhi mã põti kam, pjê kam me hamreare ata kam pry nõ to, mãr quê cumã ihcuhtacti ne, ne ajpẽnti ne. ");
INSERT INTO ram_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Ne hanea ne me caprũm to hipu, ne me kẽn to hõkre nõ, ne ahkre jituw to me hipu pa, ne me awjarô to ajpẽn pa, ne cumã pry jikôtti atajê to ihcuhtac, mãr quê ahna mõr xà ata cumã ajpẽnti ne. Jĩkjê na, ca ha me cumã ate amji kam gapac xà impejti ton to me apa, ne catyt kam me apa. ");
INSERT INTO ram_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Ne quê ha pjê kam mehcunea mehkrĩ atajê me pajõ Pahhiti carôt jàhcujro ata pupu. Ne Pahpãam te ri ita ton na amji jarẽn, na quê ha ihtỳj ton to hane” hajỹr. ");
INSERT INTO ram_vpl VALUES ("IS40_6","024_40_6","ISA","40","6","7","Mã jũm ita te imã: “Acaràr!” hajỹr. Wa cumã: “Mẽr icaràr xà jũ to mã, wa ha icaràr?” hane. Mã cute imã: “Ca ha acaràr to hane he: ‘Pom mehcunea pjê kam mehkrĩ atajê pê ihhêj rũm ahtu pyràc, ne me hàpên xà impejti atajê pê pĩrã pejti pyràc! Ne quê ha ahtu me pĩrã incrà, ne cyt ne hamre, ita jĩkjê na, quê ha mehcunea cyt ne me hamre, me hàpên xà mea mã! Quê ha hanea ne ahtu me pĩrã põ kam kôc pahtỳjti cacrohti ita apê, ne to incrà pyrentu, ita jĩkjê na, quê ha Pahpãm me hakô, quê ha me hamre pyrentu! ");
INSERT INTO ram_vpl VALUES ("IS40_8","024_40_8","ISA","40","8","8","Ne ihtỳj jũ caxuw ahtu incrà xà, ne hanea ne ihtỳj ampo rã inxô, ne hamre xà. Ne quêt me pajõ Pahpãm jarkwa nare, quê ha quêt ihtỳj ihkrĩ rohnỳtti mã!’ hane” hajỹr. ");
INSERT INTO ram_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Mã hipêr jũm ita te imã: “Ca ha ate me gũjarẽn pejti to me gũjarẽn catêjê nõ, hawênti nõ kàa na api, ne Krĩpinkrên kam mehkrĩ atajê mã acaràr, ne akrãhhia kam me cumã acaràr, ne nee apu amji mã me ampo cupa nare. Ne Juta jõ pjê kam krĩ cunea kam mehkrĩ atajê mã: ‘Ramã me gõ Pahpãm cator to mõ!’ hane” hajỹr. ");
INSERT INTO ram_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Ỹhỹ, Pahhiti pê Pahpãm ri ramã carôt tỳjti catia to cator to mõ! Ne quê ha carôt kam ihhimpej xà tỳjti ata me to ihhimpej. Ne quê ha ahpỹanre na cute me ampo ton atajê jahpan xà na, me cumã hàmjõr xà impejti ata to ajpên ahpar mã mõ. ");
INSERT INTO ram_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Ne pom hãn ne carà cahàcre hôhti jamãr catêjê hamãr prãmte to ipa, ita jĩkjê na, quê ha ihtỳj mehkwỳ atajê to amji pytà, ne taa cupê me hamãr catê impejti ata na amji to. Ne ihpa kam quê ha mehkrare japỳ ne me to ipa, ne ma menxyrxwỳ me, me hamãr peaj to ipa. ");
INSERT INTO ram_vpl VALUES ("IS40_12","024_40_12","ISA","40","12","12","Ne jũm te mõrmõ Pahpãm cuxà, hũhkra to côxwa to ipipẽn? Hamreare, nee jũm te cuxà ton nare! Nare, jũm te mõrmõ Pahpãm cuxà, hũhkra to côjkwa to ipipẽn? Hamreare, nee jũm te cuxà ton nare! Ne jũm te mõrmõ Pahpãm cuxà, hõ kàhà kam pjê jacrô cunea to cuprõn? Hamreare! Nare, jũm te mõrmõ, cute ampo to ipipẽn xà kam, hawênti jõ kẽn cunea to ipipẽn ne hũtĩ na hahkre pej? Hamreare! ");
INSERT INTO ram_vpl VALUES ("IS40_13","024_40_13","ISA","40","13","13","Ne jũm te mõrmõ Pahpãm cuxà, Pahhiti Carõ Pejti ata jahkre pej pejtu? Hamreare! Ne jũm te mõrmõ Pahpãm Carõ japackre prãmte, cumã ampo to hahkre? Hamreare! ");
INSERT INTO ram_vpl VALUES ("IS40_14","024_40_14","ISA","40","14","14","He xà ajkĩ Pahhiti te, jũm te cumã ampo to hahkre xà na, jũm na hàhwỳr? Hãpà! He xà ajkĩ jũm te Pahhiti mã catyt kam ipa to hahkre? Hãpà! He xà ajkĩ jũm te, cute ampo jahkre pej xà to cumã hahkre, mã cute hahkre pej? Hãpà. He xà ajkĩ jũm te cumã cute amji jahkre pejti ita to hahkre? Hãpà! ");
INSERT INTO ram_vpl VALUES ("IS40_15","024_40_15","ISA","40","15","15","He Pahpãm mã pjê kam ampo cunea na, krĩxàre mehkrĩ itajê jamreare. Ne cumã me cupê cuhkõn kam, cô kryjre ne ahtwỳ ne ihpehpec pyxit peaj ata pyràac, ne ihcunea na me hamreare. Ne cumã me cupê ihhêj rũm ampo te ipipẽn xà kam pjê jacrô to amji japackre xà nare ata pyràac. Ne cumã cô jipôc ri pjêncrà itajê to ipipẽn xà te hajỹar, pom quê ampo cajcucre to ipipẽn xà nare he. ");
INSERT INTO ram_vpl VALUES ("IS40_16","024_40_16","ISA","40","16","16","Quê ha te kẽn catia atajê na pĩ cunea to me cuprõ, ne cumã kẽn atajê kam pryre apu ipa atajê cunea jõr prãmte, pĩ ata kam haxwỳ ne me to caxàr cakrô, quê ha nee Pahhiti mã ihnõ na cormã cati nare! ");
INSERT INTO ram_vpl VALUES ("IS40_17","024_40_17","ISA","40","17","17","Ne cumã ampo na, krĩxàre atajê jamreare ata, ne cumã me cupê ampo kôt hamreare atajê japyre mã me. ");
INSERT INTO ram_vpl VALUES ("IS40_18","024_40_18","ISA","40","18","18","Ne mẽr ampo me ca ha Pahpãm ita to me ajpẽn? Xà ajkĩ pahpãm cahàc krekà me ipipẽan? Hãpà! ");
INSERT INTO ram_vpl VALUES ("IS40_19","024_40_19","ISA","40","19","19","He pahpãm cahàc krekà ton catêjê, ihtỳj hãn ne carẽc to me to, ne wakỳre prà tepti pê ôr ata to hipy me ahna pra ne me to incururo, ne ihkôt wakỳre jakati to, cumã me hakrô xà to. ");
INSERT INTO ram_vpl VALUES ("IS40_20","024_40_20","ISA","40","20","20","Ne me cupê hamreare pê wakỳre prà tepti pê ôr me, wakỳre prà jakati na hĩ jàhwỳr atajê jamreare, na quê ha ihtỳj amji mã pĩ impejti atajê nõ capi, cute cumã pahpãm cahàc krekà na ton prãmte. Ne cute me pĩ to ipihho catêjê nõ te amji jahkre pejti nõ mã cugõ, mãr quê cumã pahpãm cahàc krekà cuhhê impejti nõ to. Ne nee ampo itajê nõ pê Pahpãm pyràc nare. ");
INSERT INTO ram_vpl VALUES ("IS40_21","024_40_21","ISA","40","21","21","He xà nee jũ caxuw ate Pahpãm jahkre pej nare? He xà nee ajkĩ jũm te me amã harẽn nare? He pom pê mam me amã Pahpãm to hahkre ita? He xà pê ca, pjê te amji ton pê mã, ramã cute ihcakôc xà ton ata na, ate hahkre pej nare? ");
INSERT INTO ram_vpl VALUES ("IS40_22","024_40_22","ISA","40","22","22","He Pahpãm ri pjê jajoti ita jipy ihkrĩ, ne cumã me pahkryjre te hajỹar, pom quê me pamã xycxycre kryjre he. Ne taa mã ri côjkwa capô, ne ihkrac ri ihkrĩ to hanea, pom cu ahpykrã xà caxuw me cupẽhkà capô, ne ihkrac ri me pahkrĩ he. ");
INSERT INTO ram_vpl VALUES ("IS40_23","024_40_23","ISA","40","23","23","Ne taa mã ri pjê kam, pahhi carôt tỳjti me, me to ihhimpej catêjê catia atajê to ihkryjre, mã cumã me ampo na me hamreare. ");
INSERT INTO ram_vpl VALUES ("IS40_24","024_40_24","ISA","40","24","24","Ne cumã me cupê ampo kre xà ata pyràac, ne pom me ampo hy kre, mã kam harê me ajkaam, mã kôc to incrà, mã carĩjre ma to ahhi, ne to cuto ita na mã, cumã pahhi atajê te hajỹr, mã cyt ne me to hamre. ");
INSERT INTO ram_vpl VALUES ("IS40_25","024_40_25","ISA","40","25","25","Ampo cunea jirô pê Pahpãm pejti ata te amji na hàhcukjêr to hajỹr he: “He ampo me, ca ha me ito ajpẽn? He xà ajkĩ ipê ampo pyràc? He xà ajkĩ jũm me ipipẽan? Hãpà” hane. ");
INSERT INTO ram_vpl VALUES ("IS40_26","024_40_26","ISA","40","26","26","Ne ca ha caxwa ri côjkwa wỳr rĩt, ne caxêre jàhtôti atajê cunea pupu, ne jũm te mõrmõ ton? He Pahpãm te ri ton, ne ahpỹanre na haprỳ atajêa na, cute cumã hàkjêr par, ne ihkrĩ xàa kam ihkrĩ par. Ne carôt pahtỳjti catihti ata kôt, nee ihnõ jamre nare. ");
INSERT INTO ram_vpl VALUES ("IS40_27","024_40_27","ISA","40","27","27","Hàpà, Pahpãm na mehkwỳ pê Juta catêjê itajê! Ampo na mã ca ame Pahpãm mã me gàhcahhõn itajê to ame amji jarẽn to: “He Pahhiti te nee ite amji kam ijapac xà na ijahkre pej nare, ne cupê ipimxur tu. Mã nee cute, ite ampo na prãm ata na ito amji japackre nare” hane? ");
INSERT INTO ram_vpl VALUES ("IS40_28","024_40_28","ISA","40","28","28","He xà apê Pahpãm jahkre kêatre? Xà nee jũ caxuw ate harẽn par nare? He Pahhiti pê Pahpãm tĩr rohnỳtti mã ata, ne cupê pjê me kam ampo cunea ton catê. Ne nee quê ha jũ caxuw ihtycrĩ, ne ihpeacre nare. Ne nee jũm te, Pahpãm te amji jahkre pej krã kreti atajê cunea na hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("IS40_29","024_40_29","ISA","40","29","29","Ne taa mã ri mehtycrĩ atajê mã carôt to ihtỳj, ne mehpeacre atajê mã carôt to ajcamẽ. ");
INSERT INTO ram_vpl VALUES ("IS40_30","024_40_30","ISA","40","30","30","Ne mentuwjê intuw cakrô, ihtỳj jũ caxuw mehtycrĩ, ne mehpeacre xà. Ne mentuw picahur na mehte tỳjti cakrô, quê ha ihtỳj jũ caxuw ame ajhu, ne ame hikwa. ");
INSERT INTO ram_vpl VALUES ("IS40_31","024_40_31","ISA","40","31","31","Ne quêt Pahhiti to amji mã mehhimpej, ne me hikaj to me ipa atajê, quê ha ajteare mã me, ne hõtpê amji mã me carôt to intuw. Ne me cupê hàcti jara tỳjti, mã to ne kỳaj pê apu ipa to pyt ata pyràac, ne ampo cunea mã me hũcanãr to ipa. Na quê ha Pahpãm jarkwa na memprar catêjê na ame pra, ne nee amehtycrĩ nare. Ne quê ha harkwa kôt catyt kam ame ipa xà ata caxuw, nee me cupê me carôt hamre nare. ");
INSERT INTO ram_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Pahpãm te jũm ita na, me pamã harkwa kujahêc, cu pahte ahna mehkwỳ mã me harẽn cakrô, mã ihhêj ne, nee cute mempar, ne amji mã me to hajỹr nare. He Pahhiti te me cumã mehkritxwỳ to hũjahkre ata to ipipẽ cakrô, mã ma hỹrmã ame irĩt, ne ame hõmpun caca. ");
INSERT INTO ram_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Ne pom pjê incrà kam me ahkêt jakep, mã kam harê ahtwỳ, ne hacpỹa mã kam hitêr ne hapôj, ita jĩkjê na mã, jũm ita te Pahhiti kam mare mã, ampo kên cunea jipôc ri, amji to ipijapar ne ihkà. Ne põ rũm pê hĩ kam, ihhêj ne nee impej nare. Ne ihhêj ne, nee cupê jũm catihti ata nare, ne cupê me pajĩ te hajỹrỹre ata pyràac. Na ri nee ihhêj ne cute amji wỳr me pahto hàhtêp xà caxuw, hirã pê impej ne cati nare. ");
INSERT INTO ram_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Ne cupê hũmre te amji pupun xà kêanre kam ipa catê, cama hanea ne amehcaca, ne ame curê. Na ri nee hỹrmã me irĩt, ne me hõmpun prãm nare, ne ma amehcaca. Cu nee ajte pahte amji mã me to cati nare. ");
INSERT INTO ram_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Ne me pahte hajỹr cakrô, mã ihtỳj cutea me pahte me amji pupun xà kêanre ata mã amji jõr, ne cutea amji kam me pahte me amji cajpẽr xà kàj xàhti atajê cunea jaxwỳr. Cakrô, cu pahtỳj ajpẽn mã me harẽn to: “Pahpãm ri apu hũmre ita to kên he, ne taa mã ri apu ihcahhy, mã ihkàj xà” hane. ");
INSERT INTO ram_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","He pahte ajpẽn mã me harẽn to hajỹr cakrô, mã nee cute hajỹr nare. Ne pahte me to kên, ne me to ihcupan xà atajê cwỳrjapê ri, cute me hũmre ata caxwỳr. He pahte me ampo kên ton atajê jahpan xà na ri, ma cute me to irô, ne cupê me hĩ to kêanre. Ne cute me to kên xà ita kôt ri, cute me pamã ampo cupa nare na me pahton, mãr cu me pahcarĩcti kam me papa. Ne cute me haxôp xà ata kôt ri, ihhêj ne hacpỹa mã, me pahcaprãr, ne me pahcapẽnti. ");
INSERT INTO ram_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Ne pom carà cahàcre hôhti me hamãr catêjê kaj na apu ipa, ne cute amji to ipictor, ita jĩkjê na mã, cu pahte me Pahpãm jõ pry cupan, ne amjia kôt me pajõ pry itajê pynãr. Ne Pahhiti te, pahte me to kên ne me to ihcupan xà atajê jahpan xà na, nee me pahto kên nare, ne ma jũm pê me pahkritxwỳ ata to irô, ne cute apu to kêanre. ");
INSERT INTO ram_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Mã cute mehkôt harẽn hêj xi xà kêanre to me harẽn, ne to me cumã ihkàj xà catia ton cakrô, mã nee cute amji pytàr xà na me cumã ampo to ihcakôc nare, ne nee amji jahpan xà na mencrôn nare. Ne pom ma carà cahàcre kra curan xà wỳr me to ipa, mã aracri ipa, ita jĩkjê na ri cute mehcuran na, cama amji na me hamãr, mã cute mehcuran. Ne pom me carà cahàcti hôhti hô jakep, mã nee incwỳr nare, ita jĩkjê na mã cute, ne nee amji jahpan xà na cute ame to kên catêjê mãn kên nare. ");
INSERT INTO ram_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Ne cute mehpro, ne mehhêj xia to cute me to ihhêj xi, ne mehcukij xà kêanre to mehcukij, ne nee cormã ihkra nare kam mehcuran, mãr quê nee hipêr ita ri me hipôc ri apu ipa nare. Ne me pahkwỳ te me to kên, ne me to ihcupan xà cwỳrjapê ri amehcahhy. ");
INSERT INTO ram_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Ne nee apu hàprê to ipa nare, ne nee apu ihhêj xia to ihcakôc to ipa nare cakrô, mã ihtỳj cute me hàhcuran catêjê cahê na me harêt na harkwa cakrô, mã me hakràjti jarêt xàa kam, cute me harêt. ");
INSERT INTO ram_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Ne nee cute ampo to kên nare cakrô, mã Pahhiti te to mehkên catêjê pyràac, ne cumã ihkàj xà ton. Ne pê mam ramã Pahhiti ita ton xà ita na amji kampa, na pê to hane. Ihhêj ne Pahhiti te, jũm te me to ihcupan xà jahpan xà na, cute me hũmre ita curan na me hamãr, mã cute mehcuran cakrô, quê ha ihtỳj hacpỹa mã ihtĩr, ne ihtĩar na apu ipa rohnỳtti mã. Na quê ha ihtỳj jũ caxuw cumã mehkra jàhtôti atajê pupu, ne Pahhiti mã ihkôt pjê kam me hàhtôa to ihkra prãm. ");
INSERT INTO ram_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Ne cute amji cajpẽr xà kêanre to amji cajpẽr xà ata jakàn pê, quê ha cormã me hàhtôa atajê, cute amji cajpẽr xà kên ata cwỳrjapê cupê Pahpãm kra na me hahkre pej, na quê ha ampeaj kam hũrên me hakry. Ne quê ha cupê Pahpãm mã hàpên catê, ne catyt kam ipa. Na quê ha me hàhtôa ne, cupê mehkritxwỳ ita na me hahkre pej, ne ihtỳj amji mã me to ihhimpej. Ne quê ha taa, cute me to ihcupan xà jahpan xà na, ihkên cunea mã amji gõ, mãr quê Pahhiti me ahna amji capa, quê ihtỳj mempej pêa mã ame ipa. ");
INSERT INTO ram_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Cute mehcuran xà mã amji jõrtu. Mã cute me to ihcupan catêjê cahê na cute mehcuran xà ata pê, cute amji mã mehkên ton xà atajê cunea juwahi, ne ihtỳj cute me to ih cupan catêjê cajrẽn. Na quê ha Pahpãm pê Pahhiti itajê cunea jahpan xà na to catia to cati, ne ampeaj kam to carôt tỳj. ");
INSERT INTO ram_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","Ỹhỹ me ikwỳ, cormã Pahhiti te ita ri apu mõr ita kam, ca ha atỳj me hapê, ne cormã ame acahê na mõr xà ita kam, ca ha atỳj cute me apytàr xà na me wỳ. ");
INSERT INTO ram_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Ne quê ha mehkrã kên catêjê, cute me amji kam hapac xà kên ton jicu, ne nee hipêr cute me ton na me amji to amji japackre nare, ne rỳ mã me pajõ Pahhiti pê Pahpãm wỳr me apkjê na mã, quê ha taa ame caprĩ, ne cute me to kên atajê to tojnõ hiahpuro, ne nee hipêr to amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Pahhiti te me pamã, me pahna amji jarẽn to: “Ite amji kam ijapac xà pê nee me ate amji kam me gapac xà pyràc nare. Ne nee ijàpên xà pê me gàpên xà pyràc nare. ");
INSERT INTO ram_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Pom pjê jirôa pê côjkwa te pjê jirãr, ita jĩkjê na mã, ijàpên xà te me gõ tekjê jirãr. Ne ite amji kam ijapac xà te gõ tekjê jirãr. ");
INSERT INTO ram_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Ne pom hãn ne côjkwa pĩn cô carôt wrỳ, ne ta wrỳ, ne xa pjê inco, mãr quê pjê kam ampo cunea to ajcamẽ, quê ha me cumã cute me hõ kur xà atajê, ne cute mehkre xà caxuw me cumã ihhy, ne cormã hacpỹa mã api, ita jĩkjê na, quê ha ijarkwa hane he. ");
INSERT INTO ram_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","Ne ipĩn, ijarkwa hapôj ata, quê ha nee hacpỹ ne caprỳ iwỳr amji jaxàr nare. Ne cute me kam hapac prãmte, wa ite mehwỳr ihkujahêc, na quê ha nee ahna mehprãr nare ne ihtỳj me kampa. ");
INSERT INTO ram_vpl VALUES ("IS55_12","024_55_12","ISA","55","12","12","Na ca ha atỳj, jũ caxuw, me gakrya kam, me acurê xwỳn catêjê jõ pjê pê me acato, ne me acarĩcti kam, me amã ampo cupa nare kam, ma me gõ pjê impejti ata wỳr me axy. Na quê ha, me amãa ihhêj ne hàhkà jakôt me, awjarô atajê cunea, ate me amji jaxàr xà ita pyrên hakryte apu cre. Quê ha hanea ne pĩ cunea me apyrên cumã amji kĩnte, ihhêj ne apu hũhkra cahhy. ");
INSERT INTO ram_vpl VALUES ("IS55_13","024_55_13","ISA","55","13","13","Ne curi hômjĩ jaxà kam, quê ha quêt pĩ tỳjti pejti cuhtacti atajê hapôj. Ne curi pĩhhô jàprêhti hapôj ata jaxà kam, quê ha quêt ampo pĩhhô cuxwati atajê hapôj. Ne ampo pejti itajê, quê ha quêt ijaprỳa na hapôj. Ne ipê Apãm Cati pê Pahhiti to ate me amji japackre rohnỳtti mã xà na, quê ha ita hane. Na quê ha nee jũ caxuw hamre nare” hajỹr. ");
INSERT INTO ram_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Ỹhỹ me ikwỳ, por Pahpãm te me pamã jũm kujahêc na to hũjahkre ata te amji jarẽn to: “Pahhiti te ampo cunea to ihhimpej catê ata te me cupê hamreare atajê mã, ite ijũjarẽn xà pejti jarẽn catê na ixãm, cwỳrjapê ri Carõ Pejti te imã amji jõr. Ne cutea ri mehkwỳ wỳr ikujahêc, mãr wa mehpeacre me, me cumã amji kĩn nare atajê caprĩ, ne hacpỹa mã me cumã me carôt gõ. Ne hanea ne cute awcapàtkôti kam me hacjên catêjê mã: ‘Gapacta ne me gapôj’ hajỹr to ipa. ");
INSERT INTO ram_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Ne wa hanea ne mehcunea mã Pahhiti jarẽ, ne me cumã: ‘Quê ha caku itajêa kam Pahhiti me akên cati pê me gapôj ne me ato impej, ne amji jahpan xà na, mehkrã kêanre atajê to kên’ hane. Ne wa hanea ne mehcunea ame amrã atajê mã caprĩ. ");
INSERT INTO ram_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","“Ne por Xijãw jõ kẽn cahê na Krĩpinkrên kam mehkrĩ ne ame amrã atajê, wa ha itỳj cute ame ampo na prãm atajê, me cumã cugõ. Ne me cumã amji kĩn nare na cute me hahkre pej prãmte, pro to cute me amji krã cunea jipro atajê, wa ha quêt me cumã pahhi krãhkà impejti gõ, hacpỹa mã me cumã amji kĩn na, cute me hahkre pej prãmte. Ne mehpeacre atajê, wa ha me cumã ampo cacô cuxwati gõ, mãr quê me hakry. Ne jũm mã amji kĩn nare ne cupê amji jahkre kêatre atajê, wa ha me cumã cupẽhkà impejti gõ, ne cute me Pahpãm pej na hũrên hakryti na harẽn na me to. Ne pom hãn ne me ampo pĩxô pejti pàr kre, mã cati ne ihkô, mã mehcunea amji mã ihkre catê jarẽn pejti, ita jĩkjê na, quê ha mehcunea me Pahhiti na mehkwỳ pê catyt kam me ipa na ame hõmpu atajê, ihtỳj me Pahpãm jarẽn to impejti ne. ");
INSERT INTO ram_vpl VALUES ("IS61_4","024_61_4","ISA","61","4","4","“Ỹhỹ me ikwỳ, por pê mam me curê xwỳn me panquêtjê pê me hõ krĩ to kên ne me to hamre atajê, ca ha hacpỹa mã me to impej. ");
INSERT INTO ram_vpl VALUES ("IS61_5","024_61_5","ISA","61","5","5","Quê ha me cupê mehcahkrit atajê, ihtỳj me amã me aparxare jamãr to me ipa. Ne me cupê me akwỳ nare atajê, quê ha ihtỳj me gõ pur kam me amã me apê. ");
INSERT INTO ram_vpl VALUES ("IS61_6","024_61_6","ISA","61","6","6","Ne quê ha mehcunea mã me apê Pahhiti mã amehcajrẽn catêjê, ne apê cumã me gàpên catêjê na me gahkre pej. Ne ca ha krĩxàre cunea jõ to amji mã garte, ne to garte tu. Ne ca ha me hàhcukrêj atajê pê me atekjêa na ahna me amji jarẽ. ");
INSERT INTO ram_vpl VALUES ("IS61_7","024_61_7","ISA","61","7","7","“Ampeaj kam quê ha me ikwỳ te amehpahàm catia pro xà kaj na, mehcunea kam mare mã me ampo pejti catia pyr to me ajkrut. Ne mehpahàm xàhte amencwỳr xà kaj na, quê ha cute me ampo pejti ita pyr pyrên ame hakryte ame cre. Ne quê ha pjê to hõ tekjê ata kam me to ajkrut ne me cukwa. Na quê ha hũrên cumã amji kĩn rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("IS61_8","024_61_8","ISA","61","8","8","“Ne ampo na mã quê ha me hane? Nee mã ampo na nare. Pahhiti te me ahna amji jarẽn to hajỹr he: ‘He ipêa ri me hõ Pahhiti, ne quêt imã, catyt kam jũm te me ampo kên ton jahpan xà na, cute mehcukij xà hêj xi nare kam mehcukij ata na ri, imã ihprãm. Newa ma apu hàhkĩj xi me, ampo kên cunea caca. Ne wa itỳj ite me cumã ampo to ijũjahkre ata na, amji jarkwa kampa, ne wa ha itỳj ite me cumã ijàmjõr xà gõ. Ne itỳj me ajpẽn pa. Ne quê ha ite me ajpẽn par xà ata kôat me ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("IS61_9","024_61_9","ISA","61","9","9","Ne quê ha pjê cunea kam, krĩxàre cunea, me ikwỳ tàmxwỳ tàmxwỳ jahkre pej. Ne quê ha mehcunea ame hõmpu atajê me amji mã harẽn to: “Itajêa kam ri Pahpãm te harcô mẽn, ne me to impej he” hane’ hajỹr. Hõ quê ha ihtỳj amji jarẽn to hane” hane. ");
INSERT INTO ram_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","Na quê ha Pahpãm na mehkwỳ me amji jarẽn to: “Pahhiti pê Pahpãm pyrên me ijakrya to me ijakry, ne me imã amji kĩn hyre nare” hane. Ampo na? He pom me hakràjti me cupê hamreare tehcajpar prãmte, me cumã ihkat kà impejti me, hitô kà pejti gõ, mãr quê impej pêa mã apu kam me ipa, ita jĩkjê na ri, Pahpãm te me itehcajpar prãmte, ampo kên catia pê me ipytàr, ne catyt kam me ipa na me ito, mãr wa catyt kam ame ipa. Ne pom me hikwa tuw catêjê me amji krã jakrô, ne me hakrô xà to me amji cũmpej, ita jĩkjê na mã, Pahpãm te me ito impej, mãr wa me ipej pêa mã ame ipa. ");
INSERT INTO ram_vpl VALUES ("IS61_11","024_61_11","ISA","61","11","11","Ne pom pjê kam me ampo hy kre, mã huprãj hapôj, ita jĩkjê na mã, Pahhiti te ampo cunea to ihhimpej catê ata, pjê cunea kôt krĩxàre cunea te catyt kam me ipa na me to, quê ha catyt kam me ipa. Ne quê ha Pahpãm to cute me cati prãmte, ihtỳj cumã impej ne cati na me harẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("IS65_17","024_65_17","ISA","65","17","17","Ne Pahpãm pê Pahhiti pê ampo cunea to ihhimpej catê ata te amji jarẽn to: “Wa ha ijàpên xà to ita ca hõmpu he: Wa ha côjkwa tuw me, pjê tuw to, ne ramã ampo cunea tuw pit ita kam, quê ha nee jũm hipêr mam ihtũm atajê to me amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("IS65_18","024_65_18","ISA","65","18","18","Ne ite me amã ampo tuw ton itajê pyrên, ca ha ame gakry, ne me amã amji kĩn rohnỳtti mã. Ne quê ha pjê cunea kam me hàhtôa Krĩpinkrên me, kam mehkrĩ atajê pyrên me cumã amji kĩn, ne ame hakry. ");
INSERT INTO ram_vpl VALUES ("IS65_19","024_65_19","ISA","65","19","19","Ne pa, ite hajỹar, Krĩpinkrên pyrên ijakry, ne hanea ne kam mehkrĩ atajê pyrên imã amji kĩn. Na quê ha nee hipêr jũm incwỳr nare, ne nee hipêr jũm, amji japête incwỳr kam hapac nare. ");
INSERT INTO ram_vpl VALUES ("IS65_20","024_65_20","ISA","65","20","20","“Ne nee quê ha hipêr jũm krare amji to ipijapar to incri ne hacpỹ ma mã ihtyc nare, ne ihtỳj amji to ipijapar to ipa. Ne mehwej catêjê, quê ha ihtỳj mehwej to me ipa, ne maa, cute me to hõ caku mã hahêr xà ata mã me to hahêr tu, ne cormã mehweaj to ihwej, ne mehtyc to hane he. Ne cormã jũm na caku te xẽj ne ihtyc ata, quê ha me amji mã harẽn to: ‘Pỳhàpà, nee cormã ihwej nare, ne intuw kwỳa kam ihtyc’ hane. Ne nee cormã ahna caku te xẽj nare, ne ihtyc ata, quê ha me amji mã harẽn to: ‘Ihhêj ne ihkrã kêanre, ne cute Pahpãm to kên cwỳrjapê ri, intuw kwỳa kam cute ihcuran’ hane. ");
INSERT INTO ram_vpl VALUES ("IS65_21","024_65_21","ISA","65","21","22","Ne pom pĩ tỳjti, ihtỳj caku jàhtôa kam awcanã ne ihcuhhê, ita jĩkjê na, quê ha ihtỳj me ikwỳ caku jàhtôa kam me awcanã, ne mempej pêa mã me amji to ipijapar to me ipa. Ne por wa ite amji caxuw me ikwỳ capi atajê, quê ha ihtỳj caku jàhtôa kam, cute hũhkra to hàpên xà ton atajê to me amji cajpuaw to me ipa. Ne nee hipêr amji mã me ikre nõ xãm, quê kam jũmjê mehkrĩ nare. Ne nee hipêr kam amji mã pĩxô kre, quê ha ajteare mã jũmjê cupê mehkrẽr nare. Ne quêt amji mã me hũrkwa pyxwỳ, ne me taa kam mehkrĩ. Ne kam me amji mã pĩxô kre, ne quêt me taa me cuku. ");
INSERT INTO ram_vpl VALUES ("IS65_23","024_65_23","ISA","65","23","23","“Ipê me hõ Pahhiti, ne hanea ne ipê mehtàmxwỳ jõ Pahhiti. Ne paa, wa ha me kam ijarcô mẽ, ne me to impej ita kam, jũ wỳr quê me apê, ne me hàpên xà kôt hamreare ne. Ne quê ha mehkra ihpỳpỳm, quê ha nee ampo kêanre mehwỳr cator nare. Ne mehkra hãn ne me cumã me ajhu, ne mempejti kam me amji to ajpa. ");
INSERT INTO ram_vpl VALUES ("IS65_24","024_65_24","ISA","65","24","24","Ne hãn ne ampo na me icukij, wa ha itỳj me kampa. Ne cute amji tehcajpar xà na me iwỳr xwỳjrea na, wa ma ramã ite mehtehcajpar xà caxuw me cahê na ipa. ");
INSERT INTO ram_vpl VALUES ("IS65_25","024_65_25","ISA","65","25","25","“Hõhõ, amcro atajêa kam, quê hacpỹa mã rop cahàc jàprêhti atajê, carà cahàcre kra me ajpẽn cahê na hàpàn to ipa. Ne rop cahàc jõkre hôhti, quê ha cupê pryti pyràac, ne ahtu pit kur to ipa. Quê ha mehkĩnte cagã, pjê jacrô pit kur to ipa ita na. Ne quê ha ijõ pjê pejti ita kam, nee ampo te to kên xà hamreare, ne nee jũ caxuw ampo te to hamre xà nare” hajỹr. Hõ, Pahhiti te amji jarẽn to hajỹr.");
INSERT INTO ram_vpl VALUES ("HK3_1","036_3_1","HAB","3","1","1","Ỹhỹ, Hapakuc pê Pahpãm jarkwa to me cumã ihcakôc catê ata te Pahpãm to cati prãmte, cumã increr xà to increr to hane he: ");
INSERT INTO ram_vpl VALUES ("HK3_2","036_3_2","HAB","3","2","2","“Ỹhỹ Pahhiti Cati, ca ate imã ate amji kam gapac xà na amji jarẽn. Ne ca ate gàpên xà ton xà ata catia to cati, na wa itỳj amji mã hũpa to catia to ipa. Ne pom pê ca mam me iquêtjê tehcajpar to catia, pê wa ahna garẽn pa, ita na ca ha hipêr ita kam me itehcajpa, mãr wa hanea ne me cuxà me ahna me apupu. Ne wa ite me ato kên jahpan xà na me ikam acryc cakrô, ca ha atỳj ate me icaprĩ na amji to amji japackre. ");
INSERT INTO ram_vpl VALUES ("HK3_3","036_3_3","HAB","3","3","3","“Wa ite Etõ jõ pjê kam kẽnti japrỳ te Parã ata pĩn, ate apejti to ajpên iwỳr amõr na apupun. Mã acarôt prà jàhcujro te côjkwa cunea cujro. Mã pjê cunea kam me amã acatihti to mehcakôc. ");
INSERT INTO ram_vpl VALUES ("HK3_4","036_3_4","HAB","3","4","4","Ne apê pyt japôj pê mã hàhcujro pyràac, ne ate gũhkra kam acarôt tỳjti to apimxur ata pĩn gàhcujro catia cator. ");
INSERT INTO ram_vpl VALUES ("HK3_5","036_3_5","HAB","3","5","5","Ne acumam me hà catia mõ, ne hanea ne akôt me hà nõ kêanre ata ajpên mõ. ");
INSERT INTO ram_vpl VALUES ("HK3_6","036_3_6","HAB","3","6","6","Ne gàhhuc ne apinkrên me ajkaam mã pjê te hàhcujrõn kam ihtẽm. Ca ate krĩxàre pupun ne mehkôpĩr, mã acupate amehtertet. Mã rỳ pêa mã kẽnti kàhti ihkrĩ atajê pijaxwỳr par. Mã hanea ne rỳ pêa mã awjarô ihkrĩ atajê acupate pỳpỳm ne hamre par. Ne ate amji kam gapac xà atajê, jũ caxuw hamre xà nare, ne quêt ihkrĩ rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("HK3_7","036_3_7","HAB","3","7","7","“Ite Cuxã catêjê krã pictor na me hõmpun. Ne hanea ne ite Mitij catêjê te acupate amencwỳr na me hõmpun. ");
INSERT INTO ram_vpl VALUES ("HK3_8","036_3_8","HAB","3","8","8","Ne ate cô cunea te apu amji hohoc na ton, mã apu amji hohoc na ite hõmpun. He xà ajkĩ côxwa me cô cunea kam acryc na mã, ca apu to hane? Hãpà! He ca ate amã me hàprê catêjê jõ cawrô me, hõ kujti kam mehkrĩ atajê te me ipytàr xà ata caxuw ihkujahêc, na ri cô cunea apu ahhohoc. ");
INSERT INTO ram_vpl VALUES ("HK3_9","036_3_9","HAB","3","9","9","Ate to gõ cuhê xê kre tỳj, ne ate kruw jàhtôa na gàhwỳr, ate to acurê xwỳn catêjê jipej prãmte. Ne ate pjê cunea kôt cô pijapjêr na cumã gũjahkre, mã ihtỳj pjê cunea kôt apu ajpjê ne cute capahkre ton par. ");
INSERT INTO ram_vpl VALUES ("HK3_10","036_3_10","HAB","3","10","10","Mã kẽnti te ihhêj ne apupun, ne acupate apu ihtertet, mã cô catia ne cator ne ihpahtỳjti to ajpjê, ne cute pjê to hipu par. Mã côxwa ihhêj ne caràr, ne kàj mã harôti catia to pra. ");
INSERT INTO ram_vpl VALUES ("HK3_11","036_3_11","HAB","3","11","11","“Ne pyt me putwrỳ jirôa pê gõ kruw me, gõ kruwxwa pràti ita te pyt me, putwrỳ jirãr, mã ihhêj ne kam awcapàtkô. ");
INSERT INTO ram_vpl VALUES ("HK3_12","036_3_12","HAB","3","12","12","Ne ca pjê kam, me kam acryac kam apu mõ, ne ate acàcàac kam, krĩxàre kam axãm. ");
INSERT INTO ram_vpl VALUES ("HK3_13","036_3_13","HAB","3","13","14","“Ne ca ate amji mã me akwỳ capi, ne me cumã pahhi na me hũxwỳr atajê pytàr prãmte, ca me hỹrmã acator. Wa me icurê xwỳn catêjê jõ krãhtare cupate ame amxu. Mã ihtỳj cute me ijipej jahkre kêt nare kam, me ijipej na amji to ame hajỹr. Ne cute me icràn prãmte me cupê carĩjti pyràc, ne me ikam ihtẽm. Ca ate me kam atẽm, ne me hõ pahhi jõ kruw xwaa to ate me hõ pahhi krã caxwỳr. Ne ate hĩ gãn par, ne mehhi pit juwahi. ");
INSERT INTO ram_vpl VALUES ("HK3_15","036_3_15","HAB","3","15","15","Ne ca côxwa kam gõ cawrô to apu gàhhuc, na ri cô ita apu ahhohoc. ");
INSERT INTO ram_vpl VALUES ("HK3_16","036_3_16","HAB","3","16","16","“Ne wa ite ampo itajê kam ijapac, ne apu itertet pyrentu. Mã ijahkà ampo itajê cupate apu ihtertet, ne icahi apu amji cahhy ne icarôt peacre” hane. Hõ, pê Hapakuc Pahpãm mã increr to hane. Pê hanea ne ihkwỳ mã amji jarẽ ne me cumã: “Ỹhỹ me ikwỳ! He Pahpãm te imã, por rỳ nee ampo te jũ mãn nare atajê jahkre, wa ite hõmpun, ne quê ha cormã me pahwỳr cato. Ne wa ha apu hũpa cakrô, itỳj aracri hikaj to ipa, quê ha ahnaa Pahpãm, cute ame pahto kên prãm catêjê to hamre partu. ");
INSERT INTO ram_vpl VALUES ("HK3_17","036_3_17","HAB","3","17","18","“Quê ha pĩxô pàr cunea irã nare, ne hanea ne pĩxô krô na hô nare, ne pur cunea kam me hõ nare, ne nee ikre pu na carà cahàcre hamreare, ne nee kwỳc kam pryti hamreare cakrô, wa ha itỳj Pahhiti pyrên ijakryti ne. Ne Pahpãm te ipytàr catê ata kam ri ijakryti ne. ");
INSERT INTO ram_vpl VALUES ("HK3_19","036_3_19","HAB","3","19","19","Pahhiti Cati pê mehcunea to ihhimpej catê ata pê ri icarôt. Ne pom hĩjaxy kẽnti kàa jimoc na, carôt tỳj imprar tỳjti to apu ipa, ne nee ihpỳpỳm nare, ita jĩkjê na ri Pahpãm ito, ne ite ampo kên cunea mã ijũcanãr xà caxuw imã icarôt gõ” hane. Hamre.");
INSERT INTO ram_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Pê Jeju Crixtô pỳm xà hane he. Pê Marijkwỳj me Joje ramã ihcunĩ kam, cute me hikwa xà na, me ajpẽn par pejtu. Ne me hikwa xwỳjrea na, cormã Marij cunĩ kam, ramã Pahpãm Carõ Pejti kôt ihkra ne ihtic. ");
INSERT INTO ram_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ne Joje pê hũmre pê catyt kam ipa catê, ne hàhcaprĩ, ne hàhcajrẽnti, na pê Marij te apu ihpahàm cupate, nee mehcunea kam mare mã, jũm te ahti na kam ihkra na ihkôt harẽn kêanre prãm nare. Cwỳrjapê ri aracri cute Marij me hikwa tuw na me ajpẽn par xà ata to hamre to prãm. ");
INSERT INTO ram_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ne caxwa ata kam, nõr xà kam nõ ne ita to amji kampaa, ne hõt. Mã ipimtir kam, côjkwa pĩn Pahhiti pê Pahpãm jarkwa na imprar catê nõ hỹrmã iwrỳc ne cumã: — Hàpà Joje, apê pahhi xwỳ pê Tawi tàmxwỳ tàmxwỳ ita! Nee ca apu amji mã pa nare, ne atỳj Marij pê gĩxi ita na amji capa. He nee jũm te kam ihkra nare, ne Pahhiti Carõ Pejti kôt ri ihkra. ");
INSERT INTO ram_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Quê ha cumã ihkra xũmre nõ ihpỳm, ca ha caa cumã haprỳ to Jeju. Ne haprỳ ita kôt harẽn xà te “Pahpãm te me hũtàr catê”. Ampo na? He quê ha akra ita ihtỳj mehkwỳ kên catia ata pê me hũtà. ");
INSERT INTO ram_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ne ampo na ri gĩxi te hajỹr? Pê ramã Pahpãm jarkwa to ihcakôc catê japrỳ te Ixaj xwỳ ata gĩxi to awjarẽ, na quê ha hane. Na pê to hũjarẽn to: ");
INSERT INTO ram_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Quê ha jũm cuprỳ ne ihcunĩ kam ihkra, ne cumã ihkra xũmre nõ cato, quê ha cumã haprỳ to Emanew” hane. Ne Emanew ita kôt harẽn xà te “Pahpãm me pahcotea na ipa” — hajỹr. Hõhõ, Pahhiti jarkwa to imprar catê te Joje mã hũjarẽn to hajỹr, ne ma hacpỹ mã côjkwa wỳr cute amji jaxàr. ");
INSERT INTO ram_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mã Joje pimprar, ne cute Pahhiti jarkwa na imprar catê ata jarkwa kam hapac pyrentu. Ne ihtỳj cute Marij pê hĩxi na ahna amji caxàr, ne nee cute me ajpẽn par xà ata to hamre nare. ");
INSERT INTO ram_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Cakrô, pê nee cormã hĩxi tic ata na ihcaxun nare, pê ahnaa cumã ihkra xũmre pỳm, pê cumã haprỳ to Jeju. ");
INSERT INTO ram_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pê Juta jõ pjê kam, Pãw jõ krĩ kam Jeju ihpỳm. Pê caxuaw Heroti pê Juta jõ pjê to ihhimpej catê. Ne amcro ata kam me hũmre krã kreti te amji jahkre pejti kwỳ ajco me caxêre cunea te amji kam hapac xà to me hahkre to me ipa. Ne cute me pyt japôj xà rũm, Juta jõ pjê kam, Krĩpinkrên wỳr me caxêti pupun, ne ma ihkôat pyt cjêj xà wỳr me pra. Ne krĩ mã me cator. ");
INSERT INTO ram_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne curia amehkrĩ catêjê cukij ne me cumã: — Jõ ri mõrmõ jũm krare pê Juta catêjê jõ pahhi ata pỳm? He wa ite ihmat ri pyt japôj xà rũm, me ijõ pjê pĩn, ite me hõ caxêti pupun, na wa ajpên ite amehkĩn, ne amji mã hũpahti to prãmte hỹrmã me pra — hane. ");
INSERT INTO ram_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mã Heroti pê Juta jõ pjê jõ pahhi ata te me hũjarẽn xà ita par, ne ampeaj kam, jũm te hũhhyr ne haxà kam pahhi na hàr na, cumã hũpa. Mã curia mehkrĩ catêjê cunea mã, pahhi ata te me kam incryc cumã hũpa. ");
INSERT INTO ram_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mã cute Pahpãm mã mehcajrẽn catêjê jõ pahhi me, me cumã Mojxe xwỳ te me hapackre xà to hahkre catêjê te me cuprõn, ne pahhi pỳm xà na me hàhcukjêr to: — Jõ ri quê ha Crixtô pê pahhi na Pahpãm te capi ne ihkujahêc ita ihpỳm? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mã cute me cumã harẽn to: — Ita ri Juta jõ pjê kam, Pãw jõ krĩ kam ri ihpỳm xà. Ampo na? He pê ramã Pahpãm jarkwa to mehcakôc catêjê Pahpãm jõ kàhhôc kam ita na mehhôc to me hane he: ");
INSERT INTO ram_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Pãw jõ krĩ, acrire cakrô, krĩ cunea jirôa pê acati. Ampo na? He akaam ri me ijõ Pahhiti cator xà. Ne quê ha cato, ne me ikwỳ pê Ixaher catêjê cunea to ihhimpej, ne me hamã” hane — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mã aracri Heroti te pyt japôj xà rũm me hũmre krã kreti me mõ atajê na hàhwỳr, ne cute me ajpẽn par, mã cute caxêti na mehcukij to: — Jũ caxuw mã caxêti ata cator? — hajỹr. Mã me cumã: — Caku pyxit jirôa pê ri ramã cator — hane. ");
INSERT INTO ram_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jirô pê mã ri cute Pãw jõ krĩ wỳr mehkujahêc, ne me cumã harkwa hêj xia hyr to: — Ca ha me pra ne jũm krare ita na me acato, ne me imã harẽn par peaj ne. Mãr wa hanea ne me acuxà hõmpu, ne itỳj amji mã hũpa, ne imã ihkĩnti ne — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mã cute me pjê jõ pahhi ata jarkwa par jirô pê mã ma me pra, ne pry kôt hipêr cute me pyt japôj xà rũm caxêti ata pupun. Ne cute me caxêti pupun xà ata pyrên ampeaj kam me hakry, ne me cumã amji kĩn. Mã caxêti ata me cumam tẽ, ne Marij ikre kam ihkra to hỹr xà ata cwỳrpê hàhhuc. ");
INSERT INTO ram_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mã ikre mã me hàr, ne cute me Marij me ihkra ata pupun, ne cute amji mã me hũpahti na amji to me ipipẽ prãmte, cuna mã mehkõn krã na me hỹr. Ne me cumã mehkĩnti na me amji jarẽn jirô pê, cute me cumã ampo cjên xà jihê mẽn, ne me cumã me ampo pejti jõr xà atajê jõr. Atajê pê wakỳre prà tepti pê ôr me, ampo jacrô cuxwati ata me, ampo pê pĩhhôc pê ràm jĩn pyràc, ne cuxwati ata me. Ne ampo atajê cunea na hĩ jàhwỳar to hàhwỳr. ");
INSERT INTO ram_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mã caxwa ata kam Pahpãm te me hõt kam me cumã hũjarẽn, ne me cumã: — Me apê pyt japôj xà pĩn me acator catêjê, ca ha nee hacpỹ mã Heroti pê pjê jõ pahhi ata wỳr me amji jaxàr, ne me cumã ahkrare nõ ata jarẽn nare — hajỹr. Cwỳrjapê ri me hõ pjê wỳr, ma pry nõa kôt, cute me amji jaxàr. ");
INSERT INTO ram_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mã me hõmpun catêjê, ma ramã memprar jirô pê, côjkwa pĩn Pahpãm mã memprar catê nõ te Joje jõt kam cumã ihkra to hũjarẽn to: — To jỹ ne gĩxi me ihcãmter to atẽm pyrentu, ma Ejit jõ pjê wỳr, ne curia me ahtwỳ ne me akrĩ. Wa ha pa jũ caxuw ate me amji jaxàr xà to me amã awjarẽ! Ampo na? Nee mã ampo na nare. Pjê jõ pahhi pê Heroti ihtỳj apu ahkrare ita japê, cute ihcuran prãmte — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mã Joje jũjarêan kam hỹr ne cute ihkra impỳn, ne ma caxwaa ri inxi me, Ejit jõ pjê wỳr me to tẽ, ne amcro nõa na curi me cator. ");
INSERT INTO ram_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne curia me hàhhuc ne mehkrĩ, ne curi mehkrĩ ita na mã me ahnaa Heroti tyc, mã cormã hacpỹ mã, cute me amji jaxàr. Ne pê rỳ pêa mã ramã Pahpãm jarkwa to ihcakôc catêjê Jeju na, me hõ kàhhôc kam, mehhôc ata harẽn to hane he: “Ite, por Ejit jõ pjê kam apu ikra mõ ata na, ijàhwỳr” hane. Pê ihkàhhôc kam ahna mehhôc xà ata na pê hane. ");
INSERT INTO ram_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mã Heroti te pyt japôj xà rũm cute amji jahkre pejti te caxêti pupun catêjê te mempar nare na, me hahkre pej, ne ame kam incryac to me kam incryc. Ne cute hõ krãhtare mã ahkrare xũmre curan na harkwa hyr to: — Ca ha Pãw jõ krĩ me, krĩ ajpẽn cahi na ihcuhhê atajê cunea kôt me ahkrare xũmre na caku pijakrut nare atajê cunea curan to me mõ — hajỹr. Mã harkwa kôt cute me hipej. ");
INSERT INTO ram_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ne pê Jeremij pê Pahpãm jarkwa to ihcakôc catê ata ramã rỳ pea mã ita jarẽn to hane he: ");
INSERT INTO ram_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Quê ha krĩ ata kam ame amrãhti. Quê ha pyjê cunea amehkra japê xà to amencwỳr to me ipa kam me to incrà tu. Ne tee ame hõhtỳj to prãm. Ampo na? Nee mã ampo na nare. Quê ha me cupê mehkra xũmre cunea me ty, cwỳrjapê quê ha cama amencwỳr to ame ipa” hane. Mã hũjarẽn xà ata na cute hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mã Heroti tyc jirô pê mã, côjkwa pĩn Pahpãm mã memprar catê nõ te Joje jõt kam hỹrmã cator, Ejit jõ pjê kam, ne cute cumã hũjarẽn to: ");
INSERT INTO ram_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","— To jỹ ne gĩxi me ihcãmter to ma hacpỹ mã me gõ pjê wỳr amji jaxà. Ampo na? He nee mã ampo na nare, ramã, por cute me akra curan prãm atajê tyc par — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mã Joje jỹr, ne cute ihkra impỳn, ne ma inxi me, hacpỹ mã me to amji jaxàr, ne me to mõ, Juta jõ pjê wỳr. ");
INSERT INTO ram_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ne cute me Arquirãw pê Heroti xwỳ kra pê hũm jaxà kam pahhi na me harẽn par. Na ri curi me mehkrĩ na me cumã hũpaa to hũpa. Cwỳrjapê ri hipêr Pahpãm te Joje jõt kam Hĩpôjajo jõ pjê wỳr me hator. ");
INSERT INTO ram_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mã ma harkwa kôt hacpỹ mã Hĩpôjajo jõ pjê wỳr cute me amji jaxàr. Ne curia hipêr Naxare jõ krĩ kam mehkrĩ. Ne pê Pahpãm jarkwa to ihcakôc catêjê nõ ramã rỳ pêa mã Pahpãm kra pê ahkrare ata jarẽn to hane he: “Naxare jõ krĩ pĩn pê cato” hane. ");
INSERT INTO ram_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ne Jeju hanea ne me cumã: — Nee ca, ite Mojxe xwỳ me, Pahpãm jarkwa to mehcakôc catêjê te me hapackre xà ata to hamre prãmte icator na, ame icãmjĩ nare. Wa quêt catyt kam, cute me hapackre xà ita kôt ipa, ne me amã ihkôt harẽn to impej to ihcuhtacti, ca ate kam me gapac, ne icuxà catyt kam me apa prãmte, wa icator. ");
INSERT INTO ram_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","— He wa nee ame amã ihêj xi jarẽn nare, ne ampeaj kam wa me amã awjarẽ. Quê ha nee côjkwa me, pjê kam ampo cunea jamre xà wỳr Mojxe xwỳ me Pahpãm jarkwa to mehcakôc catêjê te me amji kam hapac xà na ihkàhhôc ata hôc pyxitre nõ ipictor nare. Quê ha hajỹr to ihcuhhê rohnỳtti mã, ne ihkàhhôc kam cute mehhôc catêjê te ampo te jũ mãn xà atajê quê ha ihtỳj hane. ");
INSERT INTO ram_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na quê ha jũm te Pahpãm te me pamã harkwa jirên xà ata par nare, ne amjia kôt, amji kôat jũm jũpar nare to cumã hahkre na, quê ha ihtỳj côjkwa kam Pahpãm himpej xà kam incrire ne, ne Pahpãm cuna mã ihkêanre. Jĩkjê na, quê ha jũm te Pahpãm te me pamã harkwa jirên atajê kam hapac, ne amji kôat catyt kam, jũm jũpar to cumã hahkre ata, quê ha côjkwa kam Pahpãm himpej xà kam catia to cati. ");
INSERT INTO ram_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","— He ampeaj kam wa me amã harẽ. Parixêw catêjê me, Mojxe xwỳ te me hapackre xà to hahkre catêjê me, me cumãa ihhêj ne catyt kam me ipa. Ne Pahpãm mãa nee catyt kam me ipa nare. Na ca ha Pahpãm himpej xà mã me acjêj prãm na, ca ha itajê jirôa pê catyt kam me apa to prãm. ");
INSERT INTO ram_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","— Xà pê ca nee Pahpãm te me aquêtjê mã harkwa hyr to: “Nee ca amehcuran nare. Quê ha jũm ahcura, ca ha ma cute mehcukij catê wỳr me to pra, mãr quê mehkên na me hahkre pej, ne mehkên jahpan xà na mehkên mã me cumẽ” hajỹr kam me gapac nare? ");
INSERT INTO ram_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ne wa ha me amã ihkwỳ jirô pê tỳj ita jarẽ he: “Quê ha jũm te apu mehkwỳ nõ kam incryc na, quê ha ihtỳj cute apu kam incryc ita na hanea ne mehcukij. Ne quê ha jũm mehkwỳ nõ mã harkwa to: ‘Ampo cunea na gamreare’ hajỹr na, quê ha ihtỳj cute cumãn xà ita jahpan xà na cute mehcukij catê wỳr me to mõ. Ne por jũm apu mehkwỳ nõ mã haprỳ kêanre pyxwỳ ata, quê ha ramã me pahcurê xwỳn pê Xatanaj jõ cuhy wỳr mõr xàa kam ipa”. ");
INSERT INTO ram_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","— Na ri cute hajỹr. Nãmri ca ha ate Pahpãm mã hũrkwa kam ampo jõr to amõr na, ne curia ate me akwỳ nõ te ampo na akam incryc na to amji japackre na, ca ha curia ate Pahpãm mã ampo jõr xà ata jicu, ne ma tẽ ne mam me akwỳ nõ me ajpẽn mã acaprĩ, jirô pê ca ha amji jaxà, ne cormã ate Pahpãm mã ampo jõr xà ata gõ. ");
INSERT INTO ram_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","— Ne quê jũm akam incryc na, ato xwahna prãmte, ma mehkên cukij xà wỳr me ato mõr kwỳa kam, ca ha me amji to impej. Ampo na? Ca ha ate me amji to impej nare kam ahnaa mehkên cukij catê acato, ne cumã me agõ, quê ha ma krãhtare mã me agõ, quê ha me gaxà. ");
INSERT INTO ram_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","He ampeaj kam wa ha me amã awjarẽ. Quê nee gàmjõr par nare kam, jũm amã hikran nare. ");
INSERT INTO ram_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","— He xà cute me amã Pahpãm jarkwa jarẽn to: “Nee ca ahti na ame pyjê to me axy nare” hajỹr na gũpar nare? ");
INSERT INTO ram_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","He wa ha me amã ihkwỳ jirôa pê ihpa tỳj ita jarẽ he: “Quê ha jũm cama pyjê nõ pupu, ne kam cumã amji caprẽp ata, pê ihhêj ne ramã cute ahna hũhkra” hane. ");
INSERT INTO ram_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","— Cwỳrjapê quê ihhêaj to awpôc rũm ato akên na aton prãmte ampo kên pupu, ca capa ne to awcapê. Nãmri ca ha ate caxàr nare na, quê ha gĩ cunea ihkên mã axà. ");
INSERT INTO ram_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne quê ihhêaj to awpôc rũm gũhkra akên na aton prãmte ampo kên to, ca hanea ne hakep ne to awcapê. Nãmri ca ha ate hakep nare na, quê ha gĩ cunea ihkên mã axà. He me pamã me pahcukrã xà te amji jĩkjê ita na, cute jũ mãn nare, ne Xatanaj jõ cuhy kam me pajĩ cunea pỳpỳm xà ata ri ampo kên itajê cunea jirôa pê ihkêanre. ");
INSERT INTO ram_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","— Pê Mojxe xwỳ me panquêtjê mã: “Ca ha ate Pahpãm japrỳ na ampo na cumã amji ton na, ca ha atỳj to” hane. ");
INSERT INTO ram_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ne pa, wa ha quêt cama amã to hahkre to hane he: “Ca ha ate ampo na amji ton xà ata kam, ca ha nee ihkaj na Pahpãm japrỳ to acakôc to, ‘Ỹhỹ, wa ha Pahpãm japrỳa na itỳj to’ hajỹr nare. Ne nee ca hanea ne ihcaprỳ na côjkwa pê Pahpãm krĩ xà to amji mã acakôc nare. Ampo na? He curũam ri me pahto ihhimpej. ");
INSERT INTO ram_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ne nee hanea ne pjê to amji mã acakôc nare. Ampo na? He pjê ita pê ri ihhêj rũm ihpar pyxwỳr xà. Ne nee ca Krĩpinkrên to amji mã acakôc nare. Ampo na? He cupê Pahpãm pê Pahhiti jõ krĩ. ");
INSERT INTO ram_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne hanea ne nee ampo kôt akrãa to amji mã acakôc nare. Ampo na? Jũ wỳr ca me anõ amjia kôt me pahkĩ nõ pyxit peaj to haka, nare, to ihtycti ne. ");
INSERT INTO ram_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ne quêt ca ha cama harẽn to, ‘Ỹhỹ, wa ha to’, nare, ‘Quê, wa ha nee ton nare’, hane. Ne nee hirô pê mã garkwa nõ to acakôc nare. Ampo na? Pom ca me acakôc to impejti jirô pê, hipêr me ampo na me amji to itajê, Xatanaj pê me pahcurê xwỳn pĩn ri hapôj” hane. ");
INSERT INTO ram_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","— Ne wa ha hanea ne me amã ihnõ ita cawpa he. Co he! Nee ca cute ahna me apupun prãmte me kam mare mã Pahpãm mã hàpên xà impejti atajê ton to apa nare. Nãmri ca ha ate me ita to hajỹr na, ca ha nee me côjkwa kam Apãm Cati te me amã ampo pejti jõr xà ata cwỳr nare. ");
INSERT INTO ram_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","— Ne ca ha ate jũm pê hamreare ata mã cute ampo na ihprãm ata jõr na, ca ha aracri cumã agõ. Ne nee ca ha apê jũm pê caxwãm pê cute amji kam hapac xà kên, ne põ rũm ihhêj ne impej atajê nõ pyràc nare. Ne nee ca me cuxà Pahpãm mã mehcakôc xà jũrkwa me, krĩ cape na apu amji pejti jarẽn to amõr nare. He jũm te impejti na amji mã me harẽn prãmte ri, ame hajỹr to mõ. Ne cute amji mã me harẽn pejti ata pê ri ihhêj rũm hàmcwỳr xà. Na quê ha nee Pahpãm hipêr cumã ampo jõr nare na, ca me to amji japackrea ne. ");
INSERT INTO ram_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","— Ne ca ha cute ampo na me prãm catêjê mã ampo gõ, ne ate cumã ampo jõr xà ata na amji to amxu, quê nee gõ ikwỳ nõ peaj ahna gahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ca ha ampo pejti to, ne atỳj to amxu, ne ahna amji to apimxur peaj ne, quê nee jũm ahna gahkre pej nare, quê ha Apãm Cati pit ate apimxuar pê ampo ton xà ata na apupu, ne hahpan xà na amã amgõ. ");
INSERT INTO ram_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","— Ca ha Apãm Cati mã acakôc prãm, ne nee apê me caxwãm pê mehkêanre, ne põ rũm mempejti atajê pyràc nare. He mehkêanre itajê me kam mare mã Pahpãm mã mehcakôc xà jũrkwa kam mehcuhhê, ne krĩ cape kam mehcuhhê, ne me kam mare mã me cumã Pahpãm mã mehcakôc, ahna mehcunea te me hõmpun prãmte. Ne cute amji mã me harẽn pejti ata pê ri ihhêj rũm me hàmcwỳr xà na, ca me to amji japackrea ne. ");
INSERT INTO ram_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na ca ha, jũm te Apãm Cati pupun xà nare ata mã, me acakôc to prãm, ne gũrkwa caxwỳn mã me acjêj ne amji na me to hihê. Ne curia ca ha aracri jũm te, me ate me Apãm Cati mã me acakôc na, me apupun nare xà ata mã me acakôc. Quê ha me Apãm Cati ata aracri cumã me acakôc na me apupu, ne hahpan xà na cute me amã hàmjõr xà ata to me amã amgõ. ");
INSERT INTO ram_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","— Ne ate Pahpãm mã me acakôc xà atajê kam, ca ha nee me apê mehcahkrit pê Pahpãm jahkre kêatre atajê pyràc, ne amji cuxà cumã me acakôc xà atajê pit jarẽn nare. He ihtỳj amji mã cute me Pahpãm mã mehcakôc to iryti ata kôt, cute me kam hapac na amji mã me to hane. ");
INSERT INTO ram_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne me apê me hũràc nare. Ampo na? He ate me Apãm Cati wỳr xà atajê xwỳjrea na, ramã ahna cumã me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","— Ca ha gàpàn nare kam apijacria kam, Pahpãm mã amji cajrẽn kam pra, ne nee apê jũm pê põ rũm ihhêj ne impej ata ne aracri caxwãm pê cute amji kam hapac xà kên ata pyràc nare. Ampo na? He cute me hajỹr catêjê quê ha Pahpãm mã mehcakôc tỳaj kam pra, ne ihtỳj pro to ame amji kuc jipro, mãr quê mehcunea ahna me hõmpu, ne cute me ipijacri tỳaj kam Pahpãm mã mehcakôc na mehcãmjĩ. Ne cute ampo na amji mã me harẽn pejti ata pê ri ihhêj rũm me hàmcwỳr xà. Na ca me to amji japackrea ne. ");
INSERT INTO ram_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ca ha Pahpãm mã acakôc prãm, ne quêt akuc cuhhõ, ne akĩ pê, ne amji cũmpej, mãr quê nee jũm apijacria kam Pahpãm mã me acakôc xà ata na me gahkre pej nare. Quê ha Apãm Cati pupun xà nare ata pit, ate cumã me acakôc xà ata na me gahkre pej. Ne quê ha ate apimxuar pê ampo pejti ton atajê jahpan xà na, cute amã ampo pejti jõr xà ata gõ. ");
INSERT INTO ram_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","— Me ate ito amji mã me ahimpej xà ata pê ihhêj rũm Pahpãm wỳr pry me harkwa hire, ne ipimxurure ata. Mã nee ahna me hàhtôa ne mencjêj nare, ne me pyxitre ne ahna me acjêj. Ne amjia kôt me ipa xà ata pê ihhêj rũm me pahcurê xwỳn jõ cuhy wỳr pry, me harkwa pohti ne catihti ne hirãa pê hikwa ata. Mã me hàhtôa ne ahna me acjêj. Na ca ha me pry hire pimxurure me harkwa hire ata japê — hane. ");
INSERT INTO ram_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Ne cute me cumã ampo to hahkre jicu, mã me hàhtôti atajê te, cute mempar xà ata to amji mã me ipikrar, ne me ajpẽn mã: — Pỳhàpà, mã ajte hũmre ita te me pamã ampo to hahkre xà ita, pê nee cute me pamã Mojxe xwỳ te me pajapackre xà to hahkre catêjê atajê pyràc nare, ne quêt amjia kôt, harkwa kôt, me pamã ampo to hahkre to ipa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pê pjê nõ kam Jeju apu mõ. Mã mento tũm pijakrut ne ihkôt me cumã hàkjêr to mõ, ne me cumã caràr to: — Pahhi Tawi xwỳ tàmxwỳ ita, me icaprĩa ne — hane. ");
INSERT INTO ram_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mã ma Jeju mõ ne ikre nõ mã me to hàr, mã mento tũm atajê hũ na pire mã me xa. Mã cute mehcukij to: — Xà ca ampeaj kam ajkĩ amji mã me ito ahimpej? Xà ampeaj kam ite me acaprãr na ate amji mã me ito hajỹr? — hajỹr. Mã me cumã: — Ỹhỹ pahhi, ca ha atỳj me icaprã — hane. ");
INSERT INTO ram_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mã Jeju te hũhkrahhi to mento huc, ne me cumã harkwa to: — Pom ca ampeaj kam ito amji mã me ahimpej xà ita te ri me acaprãr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mã hamre, mento itajê caprãr pyrentu, mã ihtỳj me rĩt. Mã Jeju te me cumã harkwa to: — Ca ha nee jũm mã ite me ato hajỹr xà ita na me ijarẽn nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mã ma me pra, ne cute me to ihhimpej xà ata kaj na, ihtỳj pjê ata kam mehcunea mã Jeju jarẽn to me mõ. ");
INSERT INTO ram_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","33","Ne memprar jirô pê mã ri ajpên Jeju wỳr me jũm xũmre kam ampo carõ kên, mã ipẽrkêt ne nee ihcakôc nare to me mõ. Mã Jeju te intête ampo carõ kên ata cator. Mã cute ihcakôc kam ihtẽm. Mã cute me hõmpun catêjê atajê te amji mã me to ipikrar, ne me ajpẽn mã: — Wa rỳ jũ caxuw ite me pajõ pjê ita kam, ite me ampo pejti te hajỹrjê nõ pupun nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cakrô mã Parixêw catêjê te ajteare mã me harẽn to: — Ampo carõ kên jõ pahhi te ri cumã cute mehkwỳ japôj xà caxuw carôt jõr, ne nee mã Pahpãm te cumã hõr nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mã Jeju krĩ cati me krĩ kryjre cunea pupun to ihkôt hapôj to ipa. Ne ihtỳj Juta catêjê te me cuprõn xà atajê kôt, me cumã Pahpãm te me to ihhimpej xà jarẽn xà impejti na harẽn to ipa. Ne ihtỳj Hũm carôt kôt hàpên xà pihho ton, ne me hà catêjê cunea caprãr to ipa. ");
INSERT INTO ram_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mã Jeju te me hàhtôti atajê pupun, ne ampeaj kam cumã me caprĩ xà. Ampo na? Por atajê mã amji kĩn nare, ne me caxwãm pê mehpeacre, mã cama mehkrĩ ne ame ajkampa. Ne me cupê ihhêj rũm carà cahàcre pê hamãr catê nare ata pyràac, ne ihtỳj ame ipa, na ri ampeaj kam cumã me caprĩ xà. ");
INSERT INTO ram_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne cute ihkôt me ipa catêjê mã harkwa to: — Ampeaj kam me pajàpên xà pê Pahpãm wỳr me to me papipkjêr xà ita cati. He me pajàpên xà ita pê ihhêj rũm pur kam ampo hy to cuprõn xà pyràac. Ne me to hàpên catêjê ri cormã mencrêre. ");
INSERT INTO ram_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Na ca ha côjkwa kam Pahhiti na me ahwỳ, mãr quê hipêr ajpên me pamã me hàpên catêjê kwỳ kujate, quê me cumã hàpên xà ita to apê — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pê Jeju ihkôt me ipa catêjê te tôxi japackre to hane he: — Ca ha ma Juta catêjê jõ krĩ atajê wỳr me pra, ne mehcunea mã ijarẽ. Ne quê ha me ana amji to pôj me ajkaam, ramã hanea ne ina me amji to pôj. Ne hãn ne ina me amji to pôj me ajkaam, hanea ne ramã, por Inxũ Cati te ajpên pjê wỳr ikujahêc ata na me amji to pôj. ");
INSERT INTO ram_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","— Ne por quê ha jũm, jũm pê Pahpãm jarkwa to ihcakôc catê cwỳrjapê ahna amji capa ata, quê ha ihtỳj jũ caxuw cuxà, Pahpãm te cumã hàmjõr xà ata cwa. Ne quê ha jũm, jũm xũmre impejti incwỳrjapê ahna amji capa ata, quê ha hanea ne cuxà, Pahpãm te cumã hàmjõr xà ata cwa. ");
INSERT INTO ram_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne quê ha jũm te, jũm pê ikôt ipa catê cwỳrjapê, cumã cô pit jõr cakrô, quê ha hanea ne, me cuxà, Pahpãm te hahpan xà na jũm ata mã hàmjõr xà ata cwa. Ita to ca me amji japackrea ne — hane. ");
INSERT INTO ram_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Mã Jeju te amji na Parixêw catêjê te amehcuran prãm na me hahkre pej, ne ma tẽ. Mã me hàhtôa ne ma ihkôt me mõ. Mã cute me hà catêjê cunea caprãr, ne me to impej, ne me cumã: — Ca ha nee me cumã ite me acaprãr ita na me ijarẽn nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ne ampo na ri cute me to hajỹr? He pê rỳ pêa mã ramã Pahpãm jarkwa to ihcakôc catê pê Ixaj xwỳ ata, ita na ihhôac na ri cute hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ne pê ihhôc to hane he. Pahpãm hũjarẽn to: “Ihnãm hã, ite amji mã imã hàpên catê capi ita he. Ne taa mã ri imã ihkĩnti. Ne taa mã ri imã amji kĩnti to ne amji to icajpuaw. Ne wa ite cumã Icarõ Pejti kujahêc, mã cute cumã amji jõr, mãr quê ha Icarõ Pejti ata kôat mehcukij, ne me to ajcokjê. Ne quê ha me cupê mehcahkrit atajê pê Juta catêjê nare pê me ijahkre pej nare atajê mã, ite catyt kam me to ipicokjêr xà jarẽ. ");
INSERT INTO ram_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ne nee cute amji to cati prãmte jũm me ajpẽn krac ri ihcakôc nare, ne nee apu hàkjêr nare, ne nee quê ha cà pê cute mempar prãmte ihcakôc to iryti nare. ");
INSERT INTO ram_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne quê ha jũm pê ihhêj rũm cajcaj hô nõ ata pyràc, ne cajõc ne ihcapa na xa, quê ha nee ihkwĩn pej nare, ne quêt hacpỹa mã hãm to impej, ne ihcuhtac. Jĩkjê na, quê ha jũm, cute amji kam hapac xà ramã ihpeacre, quê ha nee jũm ata mã hikran nare, ne quêt hacpỹa mã to impej. Ne quê ha jũm pê ihpôc xà nõ pyràac, ne ramã kyre pê pôr ne ihpôc crire ne, quê ha nee ipĩr quê ha ihtyc nare, ne quêt to ihpôc cati, quê ha pôr. Jĩkjê na, quê ha jũm, cute amji kam hapac xà kêanre to apu ipa, quê ha taa ihtehcajpa, quê ha catyt kam apu ipa. Ne quê ha catyt kam me to hajỹr to hãm ita kam, ahnaa me curê xwỳn tohjê. ");
INSERT INTO ram_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne quê ha pjê cunea kam, krĩxàre pê mehcahkrit atajê cunea jũm ata jikaj, ne to pit mã amji mã mehhimpej to me ipa” hane. Hõhõ, pê Ixaj xwỳ Jeju na ihhôc to hane. ");
INSERT INTO ram_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ne Jeju te hipêr me cumã hũjarẽn xà nõ jarẽn, mãr quê ampeaj kam hũjarẽn xà ita to me amji kampa, ne me cumã: — Ỹhỹ, côjkwa kam Pahpãm himpej xà ata pê ihhêj rũm me hũmre te ame pjê impejti kam ame arỳjhy impejti kre pyràac. Ne me hõ pur kam arỳjhy pit, ne nee kam ampo hy cahàc nõ te ihho nare. ");
INSERT INTO ram_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mã caxwa ata kam ihtỳj nõ ne gõr. Mã ihwỳr curê xwỳn cator, ne aracri cute arỳjhy cahê na ampo hy kên ata kre, ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne ahna putwrỳ pyxit, mã pea arỳjhy cahkô ata kà, ne cute amji to ihhy, mã hanea ne ampo hy kêanre pê ahkêt ita cator ne kam ihhy. ");
INSERT INTO ram_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","— Mã hamre pur kam me hàpên catêjê atajê te me hõmpun, ne ma hõ pahhi wỳr me cator, ne me cumã: “Me ijõ pahhi, mãr ca ate gõ pur kam arỳjhy impejti kre ita? Nõ na mã ajte jũ rũm ampo hy kên ita cator?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","— Mã me hõ pahhi me cumã: “Me pahcurê xwỳn nõ te mõrmõ ita ton” hajỹr. Mã cute mehcukij to: “Xà wa itỳj me ampo hy kêanre ita to pôj pyrentu?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","— Mã me cumã: “Quê. Ampo na? Ca ha me to pôj pyrentu ne aracri ihkôt mempej nõ capa. ");
INSERT INTO ram_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Quêt taa ampo hy kên ita ihcuhhê, quê ha ahnaa ampo tep xà kam ahtwỳ, wa ha cormã me amã harẽ, ca ha mam me ampo hy kên ata jarê ne mehpre ne cuhy kam me haxwỳ. Jirô pê ca ha cormã me arỳjhy impejti ata jirê ne mehpre, ne nõr xà kam me haxwỳ” — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mã Jeju te me hàhtôti atajê jicu, ne ma ikre nõ ma hàr. Mã ihkôt me ipa catêjê te ahna me hàhtêp, ne mehcukij to: — Me ijõ pahhi, ampo jarẽn mã ca ame imã harẽ? Ampo kôt harẽn xà mã ampo hy kêanre ita? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mã Jeju me cumã: — Ipê me Ahàkà pê ampo hy impejti kre catê ata pyràac. ");
INSERT INTO ram_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ne pur ata pê pjê pyràac. Ne ampo hy impejti itajê pê me hũmre pê Pahpãm tekjê atajê pyràac. Ne ampo hy cahàc kêanre ita pê me hũmre kêanre atajê pyràac. Ne me cupê me pahcurê xwỳn pê Xatanaj tekjê, na ri taa me to ihhimpej. ");
INSERT INTO ram_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ne arỳjhy kẽhkẽn xà ita pê ri ampo cunea jamre xà kam Pahpãm te ajpẽn pê me ato ipicokjêr xà pyràac. Ne me hàpên catêjê itajê pê côjkwa pĩn Pahpãm mã memprar catêjê. ");
INSERT INTO ram_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","— Ahnaa mã ampo hy kên ata te caxàr xà na cuhy kam me haxwỳr xà he, jĩkjê na quê ha ampo cunea jamre xà ata kam, ihtỳj me hũmre kêanre itajê to hane. ");
INSERT INTO ram_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Quê ha ipê me Ahàkà pjê ita wỳr cumã memprar catêjê kujate, quê ha Pahpãm pê Pahhiti himpej xà ata pê, cute mehkwỳ kên na me ton catêjê atajê me, cute me ampo kên ton to me amji pyràc catêjê atajê mea mã, me to pôj partu. ");
INSERT INTO ram_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne jũ caxuw Xatanaj jõ cuhy prà tyc xà nare ata kam me haxwỳ, quê ha ame amrã, ne me wa gyj, mehkàj xàhte. ");
INSERT INTO ram_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ne Pahpãm na mehkwỳ, quê ha quêt Pahpãm pê Pahhiti himpej xà ata kam mehtetetti ne, ne curia ihhimpej xà ata krac ri, cahê na mehkrĩ. Ne quê me gũpar xà caxuw me akam me gapac na, ca ha atỳj me awpa. ");
INSERT INTO ram_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","— He côjkwa kam Pahpãm himpej xà pê ihhêj rũm jũm xũmre nõ te jũm jõ pjê kam wakỳre prà tepti pê ôr na hĩ jàhwỳr catia mã cator, ne hacpỹa mã curia to ipimxur pyràac. Ne cumã amji kĩan kam cumã hàhcukrêj atajê cunea to ihpore na hàhpan, ne hàhcukrêj jõ pore ata to, cute pjê kam ôr jĩ jàhwỳr catia to pimxur ata japrôr. Ne cute pjê ata to hõ tekjê jirô pê mã ri cormã cute ôr jĩ jàhwỳr catia caxàr. ");
INSERT INTO ram_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","— He hanea ne Pahpãm himpej xà pê ihhêj rũm jũm te kẽn jaka pràti japrôr catê nõ pyràac. ");
INSERT INTO ram_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Quê ha jũ ri ihnõ impejti na, hĩ jàhwỳrti ata nõ pupu, ne ma tẽ ne caxuw cumã hàhcukrêj atajê cunea to ihpore na ahpa, ne ma to tẽ, ne to kẽn jaka pràti ata japrô. ");
INSERT INTO ram_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","— Ne hanea ne Pahpãm himpej xà pê ihhêj rũm cô kam kryhti to tep pro xà ata pyràac, ne ajpẽn caxuw tep cunea na ihpro. ");
INSERT INTO ram_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ne quê ha tep to hipu, quê ha cumã ipẽr catêjê amcrà wỳr me cupjê, ne me to api, ne me to ihkrĩ, ne tep to ame ajcokjê pyràac. Ne impej catêjê quê ha kàhà kam me cucjê, ne ihkêanre catêjê quê ha ma põ mã me to awcapê. ");
INSERT INTO ram_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","— Ita jĩkjê na quê ha ampo cunea jamre xà wỳr, quê ha Pahpãm mã memprar catêjê, côjkwa pĩn me hapôj, ne mempej pê Pahpãm na mehkwỳ tête me hũmre kên to haprãr partu. ");
INSERT INTO ram_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne Xatanaj jõ cuhy tyc xà nare ata kam mehkên catêjê cunea to me awcapê, quê ha curia mehkàj xàhte ame amrã, ne ame wa gyj — hane. ");
INSERT INTO ram_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mã Jeju te ihkôt me ipa catêjê cukij to: — Xà ca ate me ampo ita par? — hajỹr. Mã me cumã: — Ỹhỹ — hane. ");
INSERT INTO ram_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mã me cumã: — Ca ha me ate, ite amji kam ijapac xà kam me gapac, ne hanea ne ate me Mojxe xwỳ te me hapackre ne me cumã to hahkre na, ca ha me apê ihhêj rũm jũm pê mehkra mã hũrkwa pĩn cute ampo wej me ampo tuw to hapôj pyràac. Ne ihtỳj me cumã mam cute amji kam me hapac xà wej me hapu na, curmã cute amji kam me hapac xà intuw ita to hahkre — hane. ");
INSERT INTO ram_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mã Petrô Jeju mã: — Quê ha apê ijõ pahhi na mã, ca ha imã garkwa ta, wa ha awỳr mõ, cô cwỳrpê — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mã Jeju cumã: — Mẽr hõhõ, ajpên iwỳr mõ! — hane. Mã Petrô pàr kre pĩn iwrỳc ne ma cô cwỳrpê Jeju wỳr mõ. ");
INSERT INTO ram_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hamre, mã kôc apêa to apê, mã Petrô mã hũpaa to hũpa, ne ma mrõr to mõ. Mã hamre, caràr kam cute ihtẽm ne Jeju mã: — Pahhiti, ipytà! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mã ata caxuaw, Jeju te Petrô mã hũhkra pẽr ne cute hũhkra na ipyr ne hũtàr ne cumã: — Ampo na mã ca cormã kyre pê ito amji mã ahimpej? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mã ajkam pàr kre kam me hàpir. Mã hamre, kôc te amji to pec. ");
INSERT INTO ram_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mã Jeju kôt me ipa catêjê te me Jeju pejti na me harẽn ne cumã: — Xãmte ampeaj kam apê Pahpãm kra to ihkra — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mã Jeju me, ihkôt me ipa catêjê me, ma Capernam jõ krĩ wỳr me cator. Mã me hõ pahhiti jarkwa kôt me hũhkra kam me hàmcwỳr catêjê nõ te me Petrô cukij to: — Xà quê ha gõ pahhi, Pahpãm jũrkwa jamãr catêjê jõ pahhiti mã hàmjõr nare? — hajỹr. Mã Petrô cumã: ");
INSERT INTO ram_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","— Quê ha ihtỳj me cuxà hàr jahpan xà na amgõ — hane. Ne cormã ikre mã Petrô xàr, mã Jeju te ihcukij pyrentu, ne cumã: — Jũ mã mã ca ita to amji kam gapac to? Ne jũmjê quê ha krĩ ita jõ pahhi mã me amgõ? Xà ajkĩ krĩ kam mehkrĩ catêjê nõ, nare, jũm cahkrit mã curi ihkrĩ prãm ata quê ha ajkĩ amgõ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mã Petrô cumã: — Mehcahkrit catêjê quê ha me amgõ — hane. Mã Jeju cumã: — Ate to hamãrti mã ne harẽn, ampeaj kam ri ita! Ne ita jarẽn xà te, quê nee curia mehkrĩ catêjê nõ hàmjõr to prãm nare. Cwỳrjapê ri nee ijàmjõr xà nare. Ampo na? Inxũ Cati jũrkwa ri, ne ipê ihkra. ");
INSERT INTO ram_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","— Ne nee imã me hũhkra kam me hàmcwỳr catê ita te, pahte amji mã me Pahpãm cupa nare na, cute me pahto amji kam hapac na to prãm nare. Cwỳrjapê ca ha ma hĩpô wỳr tẽ ne kam ajore mẽ. Ne mam ate to tep pro ne to gàpir ata jarkwa kam, ca ha ihpore hy pupu ne capa, ne ma hàmcwỳr catê wỳr to tẽ, ne paxàr jahpan xà na to amgõ — hane. Pê harkwa ita kôat ita hane. ");
INSERT INTO ram_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ne Jeju te hanea ne ihkôt me ipa catêjê mã: — Quê Pahpãm na mehkwỳ nõ acuna mã ihkên xà nõ to, ca ha ma hỹrmã mõ, ne ahte ajpẽn na me ajkrut peaj ne cumã cute ato kên xà ata jarẽ. Quê ha cute apar na, ca ha curia hacpỹ mã me ajpẽn to impej. ");
INSERT INTO ram_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","— Quê apar nare, ca hacpỹa mã amji jaxà ne amji caxuw jũmjê to ajkrut, nare, mencrê ne me haprô, ne ma hỹrmã me to mõ. Quê ha cute ato kên xà na me hõmpun xà atajêa na me cumã harẽ. Nãmri pê mam ramã Pahpãm jõ kàhhôc harẽn to hane he: “Quê jũm pyxit peaj mehcukij catê wỳr tẽ, ne cumã jũm jarẽn to kên na, quê ha nee impar nare, nãmri quê ha jũmjê incrê ne cute hõmpun xàa na ajpẽan kôt me harẽn na, quê ha ihtỳj me kampa” hane. Quê ihhêaj to me akampa ne ihkên ton jicu, ca ha hacpỹa mã me ajpẽn to impej. ");
INSERT INTO ram_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","— Quê ihhêaj to me akwỳ nõ ata me apar nare, ca ha Pahpãm na mehkwỳ mã ihcunea na harẽn pa, mãr quê taa me acuxà cumã mehcakôc. Quê ha nee Pahpãm na mehkwỳ par nare na, quê ha cupê mehcahkrit pyràc, ne cupê Pahpãm jarkwa jahkre kêt catêjê nõ, ne cupê Pahhiti jarkwa jirô pê ihpỳpỳm catê. Ne cupê amjia kôt ipa to prãm catê, ne ihtỳj ampo kêanre ton to ipa. ");
INSERT INTO ram_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","— Ỹhỹ, pom ate pjê kam ampo kên cahpêrhyr ita, hanea ne côjkwa kam ate ihcahpêrhyr. Ne hanea ne ate pjê kam ampo pej to tojnõ ita, hanea ne côjkwa kam ate to tojnõ. ");
INSERT INTO ram_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","— Ne hanea ne pjê kam cute ito amji mã mehhimpej atajê, quê ha jũmjê ajkrut ne ijaprỳa na, ajpẽan kôt me hàhwỳr na, quê ha côjkwa kam Inxũ Cati ihtỳj ampo na me hàhwỳr xà ata to me cumã. ");
INSERT INTO ram_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ne quê jũ ri jũmjê incrêre cakrô, amji mã ijaprỳ to pôj xà ata kam, wa ha ramã ame cahê na ipa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mã Petrô Jeju na hàhtêp ne ihcukij ne cumã: — Ijõ Pahhi, jũ mã wa ha? Xà wa ha ikjê te ito kên to xet xà ata na kam icryc jicu, ne cute ito kên atajê na to tojnõ to xet? — hane. ");
INSERT INTO ram_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mã cumã: — Jũ wỳr ca cute ato kên xà ata jahpan xà na, kam acryc jicu to xet peaj. Ca ha cute ato kên ata na to tojnõ to xetxẽnta, ne nee cormã kam acryc jicu to tojnõ nare — hane. ");
INSERT INTO ram_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ne Jeju mehcunea mã ihkôt harẽn to: — He côjkwa kam Pahpãm himpej xà te amji kam hapac xà pê ihhêj rũm jũmjê te hõ pahhi mã me hàpên, ne cute ajpẽn mã me hõ new to mehcakôc, ne ahna me ajpẽn par ata pyràac. ");
INSERT INTO ram_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ne mam cute ihpore to, cute to new to mirjãw ata, pahhi ata wỳr cator. ");
INSERT INTO ram_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mã cumã hàpên catê ata pê cute to new catihti ata caxuw ihpore jamreare. Mã hamre, hõ pahhi te jũm te to new ata to ampo na hàhpan na me mẽn, hĩxi me mehkra mea mã. Ne hanea ne hàhcukrêj cunea to hõ new ata caxuw ihpore na me to hàhpan par na, cute me mẽn. ");
INSERT INTO ram_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","— Mã cumã hàpên catê ita hõ pahhi cuna mã ihkõn krã na hỹr, ne cute ahna hàhwỳr ne cumã: — “Ijõ pahhi, ito amji mã awjamã, wa ha itỳj amã ijàmjõr to imõr ita kam ijàmjõr pa!” hane. ");
INSERT INTO ram_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mã hõ pahhi mã caprĩ xà, mã cute hõ new catihti ata mea mã, ihcunea na to tojnõ. ");
INSERT INTO ram_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","— Mã ma cute hõ pahhi to new ata na tẽ. Ne cute jũm te ihpore hy te xẽj peaj to, to new ata cajpar. Mã cute jũm ita jõkre ri ihcuhtom, ne apu to ahcujrõ ne cumã: — “Imã amgõ! Ampo to ate ito new ata jahpan xà na imã amgõ!” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","— Mã jũm ita cuna mã ihkõn krã na hỹr, ne ahna hàhwỳr, ne cumã harkwa to: — “Ito amji mã awjamã, wa ha itỳj amã ijàmjõr to imõr ita kam ijàmjõr pa!” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","— Cakrô, mã nee ajte cute impar nare, ne ihkên mã mẽn. Ne cute me hacjên xà kam haxàr, mãr quê curia ihcuhhê, ne ihcuhhê xà ata to cumã amgõ. ");
INSERT INTO ram_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","— Mã hamre, me hàpên catêjê na mehkwỳ nõ, cute ihkên ton ita na hõmpun, ne apu kam incryac to incryc, ne ma hõ pahhi te to tojnõ ata wỳr tẽ, ne cute cumã harẽn par. ");
INSERT INTO ram_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","— Mã pahhi te hipêr cumã hàpên catê ata na hàhwỳr ne cumã harkwa to: — “Imã hàpên catê kêanre ita! Ca ate iwỳr, wa ite ate ito new catihti ata na ato tojnõ, ca ma tẽ. ");
INSERT INTO ram_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne nee ate amji cuxà akwỳ nõ ata caprĩ, ne to tojnõ nare icuxà, pom wa ite acaprĩ ne amã hikran, ca ma tẽ ita? Ampo na mã ate icuxà to hajỹr nare?” hane. ");
INSERT INTO ram_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne hõ pahhi ita apu kam incryac to incryc, ne ma me hacjên xà wỳr cute cumã hàpên catê ata kujahêc, mã cute me haxàr. Na quê ha curia ihcuhhê, ne amji pupun to kêanre to ihcuhhê, ne xa cute ampo to hõ pahhi to new atajê cunea jahpan xà na hàmjõr pa, ne cormã amji caprã — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ne Jeju te me cumã hũjarẽn jicu xàa kam me cumã: — Ca ha cute me ato new catêjê me, cute me ato kên catêjê atajê to tojnõ ne me hicu nare na, quê ha côjkwa kam Inxũ Cati me acuxà nee ate me to kên atajê to tojnõ ne hicu nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mã Jeju te hipêr me cumã hũjarẽn ne me cumã: — Côjkwa kam Pahpãm himpej xà te amji kam hapac xà pê ihhêj rũm pĩxô krô kre catêjê jõ pahhi pyràac. Ne ma hãn ne iràràtia na, cumã me hàpên catêjê japên to pra, cute mehkwỳ cajpar, ne hàpên xà na me ajpẽn par prãmte. ");
INSERT INTO ram_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne pê pjê ata kam, pê amcro pyxit to me hàpên jahpan xà na ihpore hy pyxit to ajco me amji mã amgõ. Na ri mehkôat amcro pyxit to me hàpên to pyt jahpan xà na ihpore ihhy pyxit to me cumã hàmjõr xà na cute me ajpẽn par. Ne ma cute me hàpên xà wỳr mehkujahêc, mã me hàpên to mõ. ");
INSERT INTO ram_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","— Mã ramã ahna pyt jàpir, mã ma krĩ cape na hipêr cumã me hàpên catêjê japên to tẽ. Ne curi cute me hũmre kwỳ te nee ampo to me hàpên nare, ne cama ame ipa atajê kwỳ pupun. ");
INSERT INTO ram_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mã me cumã: “Ca ha me hanea ne me imã ijõ pĩxô to apê, wa ha ate me gàpên xà atajê jahpan xà na catyt kam me amã amgõ” hane. ");
INSERT INTO ram_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mã ma me mõ. — Mã ramã pyt me pahkrã jimoc kam hỹr xàa kam, cute hipêr itajê to hajỹar, ne cute me haprôr, cumã me hàpên xà caxuw. Ne ramã pyt pec to mõ, mã cute hipêr itajê to hajỹar. ");
INSERT INTO ram_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ne ramã pyt xàr xàa wỳr, mã ma hacpỹ mã curi cute me cumã hàpên catêjê japrôr xà wỳr amji jaxàr. Ne cute hipêr me hũmre kwỳ pupun, mã mehkrĩ, mã cute mehcukij to: “Ampo na mã ita kam ampo to me gàpên nare kam, me ana pyt?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","— Mã me cumã: “Ampo na? He nee jũm te me imã me ijàpên xà nõ jarẽn nare na ri” hajỹr. Mã pĩxô na pur jõ pahhi te mempar ne me cumã: “Ca ha hanea ne imã me apê” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","— Mã pyt xàr xàa kam, mã pĩxô na pur jõ pahhi te cumã me hàpên catêjê jõ pahhi na hàhwỳr ne cumã: “Me hàpên catêjê mã akij, ne me cumã gàmjõr pa. Ne ca ha hapua na ite me haprôr atajê mã mam gàmjõr kam tẽ, ne hapua na ite mam me haprôr itajê mã amgõ” hajỹr. Mã harkwa kôt cute ton. ");
INSERT INTO ram_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","— Mã ramã pytre kam, me hàpên kam cute me to ihtẽm catêjê atajê te ahpỹanre na ihpore ihhy pyxit ne mencwỳr par. ");
INSERT INTO ram_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mã iràràtia na cute me hàpên kam ihtẽm catêjê atajê, ihtỳj me hirôa pê me hàmcwỳr na me amji cãmjĩ cakrô, mã cute me cumã ihpore ihhy to ihcahkũm atajêa jõr. ");
INSERT INTO ram_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mã cute amencwỳr, ne me hõ pahhi na mehcakôc kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne me cumã: “Pỳhàpà! Pom hapua na me hũmre jàpên kênre itajê jàmcwỳr xà me, me ijàmcwỳr xà ita pipẽan ajte? Wa iràràtia na ite me ijàpên kam itẽm. Ne amcro mã me ijũcanãar kam, ite me ijàpên to pyt cakrô, mã ajte me ijàmcwỳr xà itajê pipẽan!” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","— Mã pĩxô na pur jõ pahhi te me cumã harkwa to: “Me ikwỳ nõ catêjê me ikampa, wa nee ite to ihnõ cupan nare. Mãr cu pahte ihpore hy pyxit peaj na ate me gàpên to pyt na, pahte me ajpẽn par ta? ");
INSERT INTO ram_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Me gõ pore incwa, ne ma me gũrkwa wỳr me to pra. Wa mam ite hũmre mã ijõ pore to ijàmjõr to prãm ata to, wa ite hapua na hũmre itajê mã ijàmjõr, ne me ato ipipẽn partu. ");
INSERT INTO ram_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Xà wa ha nee ajkĩ ite ijõ pore to ijàmjõr na prãm ata to ijàmjõr nare? Xà ca ite me to impejti xà ita jũ na, ca ame kam acryc?” — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne Jeju te harẽn jicu xà kam me cumã: — Quê ha jũ caxuw Pahpãm pê pĩxô na pur jõ pahhi ata pyràac. Ne mehkryjre me, me cati to ajpẽan. Ne hapua na me ipa itajê me, mam me ipa catêjê to ajpẽan — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ne Jeju te cute amehcukij catêjê mã ampo to hahkre prãmte me cumã: — He pê hũmre nõ mã ihkra xũmre ajkrut. Mã cute mam ihkà ita mã harkwa to: “Ikra, ita kam ca ha imã ite pĩxô krô kre xà ata kre” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","— Mã ihkra ita te impar ne cumã harkwa to: “Imã imõr prãm nare” hane. Ne hapu na cute amji kam hapac, ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","— Mã hanea ne ihkra nõ mã cute harkwa to: “Ikra, ita kam ca ha imã ite pĩxô krô kre xà ata kre” hajỹr. Mã ihkra ita te impar ne cumã: “Ỹhỹ inxũ, wa ha itỳj tẽ” hajỹr cakrô, nee mõr nare. ");
INSERT INTO ram_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","— Mẽr hõhõ, wa ha ita na me acukij. Me amã, jũm mã pê hũm te amji mã ampo na to prãmti xà ata to? Xà mam kà ita, nare, hapu na ita? — hane. Mã cute impar ne cumã: — Por mam ihkra xũmre kà ata — hajỹr. Mã Jeju cumã: — He me apê hapu na jũm mã ihkra ata pyràac. Ne atỳj me garkwa to me apê Pahpãm kôt me apa catêjê na me amji jarẽ, ne nee ihkôt me apa nare. Me amãa me hũhkra kam me hàmcwỳr catêjê atajê me, pyjê inxyre atajê me girôa pê mehkêanre cakrô, mãramã me acumam Pahpãm himpej xà mã mencjêj to me mõ. ");
INSERT INTO ram_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ampo na? Pê Jowãw ajpên me awỳr mõ, cute me amã pry ata jarẽn prãmte, ca ajte nee ate mempar ne amji mã me to me ahimpej nare. Ne me hũhkra kam me hàmcwỳr catêjê me, pyjê inxyre atajê te mempar pyrentu. Ca ate me ita pupun cakrô, ca nee ate me to amji mã me ahimpej ne mempar nare — hane. Mã ma me pra, ne nee hipêr cute mehcyt nare. ");
INSERT INTO ram_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mã Jeju te, cute amji jaxàr xà to me cumã hahkre prãmte me cumã: — Amcro ata kam, quê ha côjkwa kam Pahpãm himpej xà ata pê ihhêj rũm me cuprỳ te tej atajê pyràc. Ne cute ahpỹanre na me hõ pôc xà incwỳr, ne pry cahti ri me to jũm xũmre jikwa tuw xà ata jikaj. Ne caxwa ri ihtỳj mehkrĩ ne me hikaj, cute me hũnãr ne mehkôt cahãj ata jũrkwa kam amji kĩn wỳr me hàr prãmte. ");
INSERT INTO ram_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","— Ne me cuprỳ te xĩc ne mehkrã nare, ne mehkwỳ te xĩc itajê quêt mehkrã kre te amji jahkre pejti. ");
INSERT INTO ram_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ne por mehkrã nare atajê te ame hõ pôc xà incwỳr, ne nee caxuw amji mã me cacô incwỳr nare. ");
INSERT INTO ram_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mã quêt mehkwỳ te amji mã me cacô incwỳr. ");
INSERT INTO ram_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mã cormã hũmre jikwa tuw xà na mehkwỳ itajê apu mehkên, mã ame hõt ne pry cahti ri ame hikaj xà ame hikwa ne ame gõr. ");
INSERT INTO ram_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","— Mã ramã caxwa picapôn kam, cute mehkrãhhia kam mencrer na mempar. Mã me cumã caràr to: “Ramã me hikwa tuw xà na mehkwỳ me amji to mõ! Ajpên cuna mã me pra!” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","— Mã me cuprỳ te me tej itajê amehkrĩ, ne ame ipimprar, ne cute ame hõ pôc xà atajê to impej par, mãr quê me cumã ihpôc pej. ");
INSERT INTO ram_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mã hamre me cuprỳ krã nare atajê pê ihpôc xà cacô jamre, mã me cupê ihtyc, mã mehkwỳ mã: “Me imã gõ pôc xà cacô kwỳ incrire ne. Ampo na? Ramã me ipê me ijõ pôc xà cacô jamre, ne ramã ihtyc to mõ” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","— Mã me cuprỳ krã kreti atajê me cumã: “Jũ wỳr quê. Hamreare, jũ wỳr quê incrire ita kam me pahcatwỳ. Ca ha ma me pra ne caxuw amji mã mehkwỳ japrô” hane. ");
INSERT INTO ram_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","— Mã ma ihpôc xà cacô kwỳ japrôr to me pra, mã me hakàn pê me hikwa tuw xà na mehkwỳ cator. Mã cute me cumã me hikwa tuw atajê jũrkwa jarkwa jihê mẽn, mã amji kĩn wỳr mehkôt me hàr. Mã me ahna cute me to hihê. ");
INSERT INTO ram_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","— Mã me ahna ahtũmre, mã mehkrã nare atajê te amji mã me cacô japrôr, ne me cator, ne ame caràr to: “Pahhi, pahhi, cama me ijamã, wa me cuxà me acjêj!” hane. ");
INSERT INTO ram_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","— Mã me cumã: “Ipê me gahkre kêatre, wa nee ite pry cahti ri me anõ pupun nare. Ne ramã ikre mã mencjêj xà jirô pê ihpỳm, mã hihê” hane. ");
INSERT INTO ram_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","— Hõhõ, cwỳrjapê ca ha me amji jamã, ne me gàhcuprõn hiahpuro, nãmri me apê ipê me Ahàkà te amji jaxàr xà jõ amcro ata jahkre kêatre, côt ca ihhêaj to ahtwỳ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mã Jeju te me cumã Pahpãm te mehcukij xà to hahkre prãmte me cumã: — Quê ha me Ahàkà amji to Pahhiti, ne ajpên ahpar mã mõ, cumã memprar catêjê cunea me, ne pahhi krĩ xà catia ata kam me jỹ. ");
INSERT INTO ram_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Quê ha pjê kam mehkrĩ atajê cunea cuna mã me cuprõ, quê ha me to ajcokjê. Pom ahnaa mã carà cahàcre hôhti to me ipijapar catêjê, hãn ne ihhôhti ita pê, increcrerti to caprã ne to ajcokjê he, ita na quê ha me ato. ");
INSERT INTO ram_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne quê ha awpôc rũm carà cahàcre hôhti to cuprõ, ne awke rũm ihhô nare itajê to cuprõ. ");
INSERT INTO ram_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","— Ita na wa ha ipê me gõ Pahhiti awpôc rũm me xa itajê mã ijũjarẽn to: “Por Inxũ te me ato impej atajê, ajpên me mõ. Ajpên me mõ ne ihhimpej xà krac ri me axà. Por pê mam pjê te amji ton xwỳjrea na, Inxũ me amã ihhimpej xà to ata mã, ca me acjêj. ");
INSERT INTO ram_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ampo na? Nee mã ampo na nare. He pê imã prãm, pê ca me imã ijarte. Ne imã kôr, pê ca me ikõm. Ne icahkrit cakrô, pê ca me gũrkwa wỳr me ijaprô. ");
INSERT INTO ram_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne pê ipê ikà nare, pê ca me imã ikà gõ. Ne pê wa ixà, pê ca me ijamã. Ne pê me hacjên xà kam me ijaxà, pê ca ma me ipupun to me apa” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","— Mã mempejti atajê te mehcukij to: “Pahhiti, jũ caxuw ri amã prãm, wa ite me amã gõ jõr? Ne amã kôr, wa ite me amã cô jõr? ");
INSERT INTO ram_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ne jũ caxuw ri acahkrit, wa ite me ijũrkwa wỳr me gaprôr? Nare, apê akà nare, wa ite me amã me akà ita jõr? ");
INSERT INTO ram_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ne jũ caxuw ri axà, nare, cute me gaxàr, wa ite me apupun prãmte awỳr me mõ?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mã Pahhiti te impar ne me cumã: “Ampeaj kam wa ha me amã awjarẽ, por ikôt me ipa catêjê kryjre nõ mã ate me acaca xà ton ata, imãa ca ate me ton” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","— Jirô pê mã ri cute awke rũm amehcuhhê atajê mã: “Icuna mã me akêanre atajê, ipê me ajcamẽ. Ne ma Xatanaj me, cumã memprar catêjê mã, ite me to kên xà na cuhy tyc xà nare ton ata wỳr me pra. ");
INSERT INTO ram_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ampo na? Nee mã ampo na nare. He pê imã prãm, pê ca nee me imã ijarte nare. Ne imã kôr, pê ca nee me ikõm nare. ");
INSERT INTO ram_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne pê icahkrit, pê ca nee me gũrkwa wỳr, me ijaprôr nare, ne ipê ikà nare, pê ca nee me imã ikà jõr nare. Ne pê ixà, pê ca nee me ijamãr nare, ne pê me hacjên xà kam me ijaxà, pê ca nee kam me ito amji japackre ne me ipupun nare” hane. ");
INSERT INTO ram_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","— Mã mehkên catêjê te mehcukij to: “Pahhi, jũ caxuw wa ite me amã prãm na me apupun, ne amã kôr me, acahkrit me, apê akà nare me, axà me, me hacjên xà kam ite me apupun, ne nee ite me atehcajpar nare?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","— Mã Pahhiti me cumã: “Ampeaj kam wa ha me amã awjarẽ, ca hãn ne mehkryjre atajê tehcajpar prãm nare, ne me hicu ita kam, nee ate me itehcajpar nare, ne hanea ne ate me ijicu, ne me icaca” hane. ");
INSERT INTO ram_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","— Hõhõ, pom mehkên te me hajỹrjê, quê ha ma mehkên mã mencjêj xà ata wỳr me pra, ne curia quê ha amji pupun to kêanre to mehcuhhê rohnỳtti mã. Quê ha hanea ne, mempejti atajê ma mencaca xà impejti tĩr rohnỳtti mã xà ata wỳr me pra — hane. ");
INSERT INTO ram_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pê Juta Carijot xwỳ ata te Jeju curê xwỳn catêjê mã hahkre. Mã cute ihkên mã me mẽn. Mã cute nee me curê xwỳn pê amji pytàr nare na hahkre pej, me ajkaam amji mã: — An! Wa ite to ihcupan crire nare! Ne ite ijõ Pahhiti kên mã mẽn. Ne quê ha ihtỳj xãmte mehcura! Wa ha tẽ ne intête mehcahpêrta — hajỹr. Ne cute ihpore hy te trĩnta atajê pyr, ne ma hacpỹ mã Pahpãm to amji kam me hapac xà jũrkwa wỳr, cute Pahpãm mã mehcajrẽn catêjê jõ pahhi me, prohti kam wỳr to tẽ. ");
INSERT INTO ram_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne curi to cator ne me cumã: — Pom ite me amã ihpore hy te trĩnta na ijõ Pahhi kên nare ata jõr ita. Nãmhã he, mĩ! Hacpỹa mã me apy! Imã ihkĩn nare. Wa ite to ihcupan. Ampo na? He nee hũmre ita kên nare, ne impejti cakrô, wa ite me amã hõr xà ita kôt ca ha xãmte mehcura — hajỹr. Mã me cumã: — Wa nee ita na me ato amji japackre prãm nare, atea ca amji mã ita ton — hane. Ne nee me cumã hacpỹ mã me ihpore pyr prãm nare. ");
INSERT INTO ram_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mã Juta te Pahpãm to me amji kam hapac xà jũrkwa kam ihpore hy ata to me cumã hũcapêr, ne ma tẽ. Ne jũ ita ri cute amji jõkre kwỳr ne ihtyc. ");
INSERT INTO ram_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mã cute mehpore ata to cuprõn ne me ajpẽn mã: — Ihpore ita te ri jũm tyc xà ata japrôr, na ri cupê me caprô jõ pore. Na ri Mojxe xwỳ te me pajapackre xà kam, Pahpãm jũrkwa kam pahte me ihpore ita to me pajàhhuc xà na ihkaj na — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cwỳrjapê ri cute ihpore ata na me ajpẽn par, ne cute me to carẽc te pot ton catê ata pê, hõ pjê ata japrôr, mehcahkrit jarêt xà caxuw. Ne cute mehcahkrit jarêt xà na me ton. ");
INSERT INTO ram_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cwỳrjapê ri ita kam cormã cute me pjê ata mã haprỳ to: “Me caprô jõ pjê” hane. ");
INSERT INTO ram_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ne pê ramã rỳ pêa mã Jeremij xwỳ pê Pahpãm jarkwa to ihcakôc catêjê nõ ata Pahpãm jarkwa na hõ kàhhôc kam, ita na ihhôc to hane he: “Mã Juta catêjê te me hõ pahhi kên mã me mẽn jahpan xà na, mehpore hy te trĩnta jõr na me ajpẽn par, ata ri hacpỹa ne cute me ipyr, ne me to pjê te pot ton catê pê hõ pjê japrôr” hane. Mã ahnaa cute hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ne cormã Pirat pahhi krĩ xà kam jỹ ne apu Jeju cukij, me ajkaam mã hĩxi te harkwa kujahêc ne cumã: — Ca ha nee hũmre pejti te jũ caxuw ampo kên ton nare ata to kên nare. Ampo na? He caxwa ri ite hũtir kêanre — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mã Pirat te nee me cupê Jeju mã hikran nare na amji jahkre pej. Mã ame hàhkrihkrit catia kam, me hàhtôti atajê ihtỳj me pahhi jũhhyr prãm. Mã pahhi ata te nee Jeju curan na me cumã hũjahkre nare na amji jarẽn xà caxuw, cô na hàhwỳr, ne kam hũhkra cuhhõn, mehcunea kam mare mã. Ne hũhkra cuhhõn kwỳa kam cute me cumã: — Wa nee ite hũmre ita curan na me amẽn nare, ne me atea ri mehcuran xà — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne mehcunea te caràr to: — Me imã, ite mehcuran jahpan xà na, ihtỳj me ikam me ikên pỳm, ne hanea ne me itàmxwỳ kam ihpỳm na to prãm — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mã Pirat pê pahhi ata te me cumã Parapa mã hikran. Ne cute pryti kà to Jeju cahhyr na me mẽn, ne pea cute krãhtare mã me hõr, mãr quê mehcahhy catia, ne pĩ na me cuxô ne mehcura. ");
INSERT INTO ram_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mã ma krãhtare atajê me to ihhimpej catê pê Pirat ata jũrkwa wỳr Jeju to me mõ, ne curia cute krãhtare cunea to cuprõn, mã cute mehkrã tu ne to xa. ");
INSERT INTO ram_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne cute me cupê ihkà to pôj, ne me ahna pahhi kà tepti japjêhti ata mẽn, ne me cumã to ihkà. ");
INSERT INTO ram_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne hômjĩ to me pahhi krãhkà ne ihkrã mã me haxàr. Ne awpôc rũm hũhkra mã pĩ nõ to pahhi jõ kô ne me haxàr. Mã curia me cuna mã to xa. Ne me to hapactu xà kêanre ata kam me to incrà, ne cuna mã mehkõn krã na mehkrĩ ne me cumã: — Apê Juta catêjê jõ pahhi catia ne apej! — hane. ");
INSERT INTO ram_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ne kam me harcô rẽ, ne hũhkra kam me cupê pĩ ata to pôj, ne ihkrã kam me to ihcahhy. ");
INSERT INTO ram_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ne cute me to hapactu xà kêanre ata jirô pê intête me cupê pahhi kà tepti ata caxàr, ne hacpỹa mã ihkàa to me cumã ihkà. Ne ma pĩ na cute menxôr ne mehcuran xà ata wỳr me to mõ. ");
INSERT INTO ram_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mã ramã pyt me pahkrã jimoac kam hỹr xàa kam, cute hàhcujro to hicu, ne ampeaj kam awcapàtkô, ne awcapàtkô ita na pyt pipkjêr. ");
INSERT INTO ram_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ne pyt pec pejti kam Jeju kỳjti pêa mã caràr ne: — Inxũ Cati, Inxũ Cati! Ampo na mã ahte ate irer to hajỹr? — hane. ");
INSERT INTO ram_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ne ramã Juta catêjê kôt xà jõ amcro ata cator. Ne Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, Parixêw catêjê me, Pirat pê pahhi me, cute me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ne me cumã harkwa to: — Me ijõ pahhiti, wa ite cormã me Jeju xwỳ hêj xi xà ata to me amji japackre, nãmri cute amji jarẽn to: “Quê ha ina amcro incrê, wa ha hacpỹa mã itĩr” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ne cu ha pahtỳj me harêt xà ata jamãr to impeaj ne, quê ha xa ahna amcro incrê, cu ha cormã me hamãr jicu. Nãmri cu ha me ita ton nare, quê ihhêaj to ihkôt me ipa catêjê me hĩ to ahkĩ, ne me harẽn to: “Hacpỹa mã ihtĩr!” hane. Quê ha mehhêj xi xà ita, mam ita jirôa pê ihkêanre ne — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mã Pirat te me cumã harkwa to: — Nãmhã ijõ krãhtare catêjê amehcuhhê he. Ca ha me haprô, ne me to mõ, ne cute me harêt xà ata jamãr na me amẽ, quê me hamãr to mempeaj ne — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mã ma cute me haprôr, ne me to pra. Ne cute me kẽn kre kam me harêt xà ata jarkwa na, me ihtô xà to me ihtô, jũm te aracri ihcaxun cupate. Ne curia ame ahna me ipa, ne ame hamãr to ame ipa, ne ma mehcuhhê ne me hõmpu, ne me hamã. ");
INSERT INTO ram_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ne cormã pyjê krĩ wỳr pry kôt me mõr kwỳa kam, mã krãhtare te Jeju kre jamãr atajê kwỳ te Juta catêjê jõ pahhi kwỳ atajê mã Jeju kre te jũ mãn xà atajê cunea na harẽn par. ");
INSERT INTO ram_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jirô pê mã ri cute jũ mã me ton xà ata na ahna me ajpẽn par, ne me krãhtare kwỳ mã ihpore catia ne hõr, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","— Ca ha me gũjarẽn to ame apa to me hane he: “Wa me ijikwa ne me gõr, mã Jeju kôt me ipa catêjê cator, ne ma cute me hĩ to hàhkĩj ne me to tẽ” hane. ");
INSERT INTO ram_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","— Quê ha me pajõ pjê jõ pahhiti ita kampa, ne ajteare mã ampo to kam amji kampa, wa ha me cumã ate me harẽn xà itajêa na harẽ. Hamre quê ha cute, me ite me to amji kam me ijapac xà ita na to amji kampa, quê ha nee me amã ihkên xà nõ cator nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mã pea Jeju kre jamãr catêjê atajê te me ihpore ita pyr, ne ihtỳj ame cumã mehhêj xi xà na cute me ajpẽn par atajê jarẽn to me ipa. Mã mehhêj xi xà atajê Juta jõ pjê cunea kôt ihcahkũm. Ne cormã ita kam mehhêj xi xà ita ipa. ");
INSERT INTO ram_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mã Jeju kôt me ipa catêjê te me õxi atajê, ma, por pê Jeju Hĩpôjajo jõ kẽn to me cumã ihcakôc ata wỳr me mõ. Mã curia Jeju te me cumã amji to ipipẽ. ");
INSERT INTO ram_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mã cute me hõmpun ne cuna mã mehcunea pỳpỳm, ne Jeju to cute me cati prãmte me to ihcakôc pejti. Mã cormã mehkwỳ me amji mã: “Xà Jejua mõrmõ ajkĩ?” hane. ");
INSERT INTO ram_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mã ma Jeju me hỹrmã mõ, ne me cumã: — Inxũ te imã pjê me côjkwa kam ampo cunea to ite ihimpej xà caxuw imã carôt jõr, ne ahna imã harkwa. ");
INSERT INTO ram_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cwỳrjapê ca ha pjê cunea kam mehkrĩ atajê wỳr me pra, ne catyt kam ijarkwa kôt me ipa catêjê na me to, quê catyt kam ikôt me ipa. Ca ha Inxũ me, Carõ Pejti me, ipê ihkra japrỳ na cô kam mehcumrã. ");
INSERT INTO ram_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ne ite me amã ampo cunea to ihimpej atajê to me cumã hahkre, mãr quê catyt kam ihcunea kam me hapac to me ipa. Ne wa ha itỳj amcro cunea kam me acahê na ipa, quê ha ahnaa ampo cunea jamre xà kam hàhhuc na, ca me to amji japackrea ne — hane.");
INSERT INTO ram_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mã Jeju me, ihkôt me ipa catêjê ma Hĩpôjajo jõ pjê wỳr me pra ne me cator, ne hĩpô tohkà na ame ipa. Mã krĩ kwỳ kôt cute me Jeju te curi apu mõr na me harẽn par, ne cute ahna me cuprõn tu. ");
INSERT INTO ram_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mã Hĩpôjajo catêjê jàhtôa te me cuprõn. Ne hanea Juta jõ pjê me, Krĩpinkrên me, Côpijapjêr jõ cô jĩkjê pĩn hanea ne cute me cuprõn, Pjêhcaprêcti me, Kẽn jõ krĩ me, Teppro jõ krĩ me. Ne pê mehcunea, cute me Jeju cajpar prãmte, hỹrmã me mõ. Ampo na? Pê ajco me Jeju te ampo ton xà atajê cunea na me harẽn pa na pê. ");
INSERT INTO ram_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mã Jeju ma ame hàhtôti te me ahna ihtỳj ita na ihcaca, na ri cute ihkôt me ipa catêjê nõ mã harkwa, quê pàr kre nõ na ahwỳ, quê kam jỹ ne me cupê to ajcamẽ crire ne. Mã harkwa kôt cute me ton. ");
INSERT INTO ram_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ne pê Jeju ajco me hà jàhtôa ne me caprã. Na pê me hà catêjê jàhtôa ne cute Jeju tàt ne me amji caprãr prãmte, me hĩ to intête hỹrmã me amji pê amtà. ");
INSERT INTO ram_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne me kam me pahcurê xwỳn carõ kên atajê pê ajco me Jeju pupu, ne ajco cuna mã me ajhu, ne me caràr to: — Apêa ri Pahpãm kra — hane. ");
INSERT INTO ram_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pê Jeju ita tête incryac kam me cumã: — Nee hipêr ipê Pahpãm kra na me ijarẽn nare — hane. Ne pê mehcahpêrta. ");
INSERT INTO ram_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pê Jeju me cumã harkwa to: — He Pahpãm himpej xà pê ihhêj rũm me hũmre te pjê kam ampo hy kre. ");
INSERT INTO ram_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ne ma tẽ ne ihtỳj apu ipa. Mã pjê krac ri ampo hy ata aracri huprãj to mõ, cute huprãj to mõr xà ata na hahkre pej nare kam. ");
INSERT INTO ram_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","He pjê ita ri cumã hô gõ, quê ha mam hiprãj cato, jirô pê mã, quê ha kam ihhy krekà cato, ne ahna ahtũm nare quê ha kam ihhy, ");
INSERT INTO ram_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ne intep, quê ha caxuw wapo py ne to hakep. Ampo na? Ramã intep ne hakep xàa kam na ri — hane. ");
INSERT INTO ram_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pê ramã putwrỳ nõ na pahhi Heroti ita Jowãw pê me cumrãr catê ata pro na to awjahkre. Pê me hũhkra cajpre ne hacjên xà mã me haxà. Ne ampo na mã pê me to hane? Nee mã ampo na nare. Pê pahhi Heroti tõ japrỳ pê Pirip ata prõ japrỳ Herotijkwỳj. Pê Heroti mã ihtõ prõ ata kĩnti, mã cute cupê caxàr ne cume hikwa. Mã ihtõ pê Pirip ata ahte apu ipa. ");
INSERT INTO ram_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mã Jowãw pê me cumrãr catê ata te me hõmpun, ne ma pahhi pê Heroti ata wỳr tẽ ne cumã: — Ampo na mã ate atõ pê ihprõ caxàr? He ate Mojxe xwỳ te me pajapackre xà kaj na ton — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mã pahhi prõ pê Herotijkwỳj te harẽn xà ita par, ne ahna cupê ihkaj na. Na ri ma apu Jowãw curê ne ihtỳj cumã ihcuran prãm. ");
INSERT INTO ram_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mã jũ wỳr quê ihcura. Ampo na? He Jowãw pê hũmre impeaj ne ajco catyt kam ipa, na pê Heroti mã hũpa, ne ihtỳj ihkên pê hũtàr to prãm. Pê ajco Jowãw pahhi japackre, pê kampa ne cupê amji jahkre kêatre cakrô, ihtỳj kam hapac to prãm. ");
INSERT INTO ram_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ne pê amcro nõ na pê pahhi ata pỳm xà jõ amcro cator, cwỳrjapê ri cute amji kĩn catia ton, ne cute me cupê pahhi cati catêjê cunea na me hàhwỳr. Ne hanea ne krãhtare jõ pahhi kwỳ me, Hĩpôjajo jõ pjê catêjê jõ pahhi kwỳ na me hàhwỳr, cahê na cute ame amji kĩn prãmte. Mã mehcunea te amji kĩn ata wỳr mehcuprõn, ne ihtỳj cute ame ampo kur catia ne ame ikõm catia to prãm to, cute mehcuprõn. ");
INSERT INTO ram_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ne ihprõtpê Herotijkwỳj kra cahãj cuprỳ japrỳ te Xarõmkwỳj ata me amji kĩn ata wỳr hàr, ne me cuna mã hàkrun to mõ. Mã pahhi Heroti me pahhi cati kwỳ atajê cunea mã Xarõmkwỳj jàkrun xà ita kĩn, ne ahna me hakry. Ne pea pahhi te cuprỳ ata mã harkwa to: — Wa ite me gàkrun xà ata kĩnti jahpan xà na, gapacta ne ampo na ihprãm xà ata na iwỳ, wa ha itỳj me akampa ne amã cugõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mã cuprỳ ata xa ne kampa. Mã pahhi te hipêr cumã amji ton ne amji ton tu ne cumã: — He ampeaj kam! Ca ha ijàhcukrêj jĩkjê na ahwỳ, wa ha itỳj amã cugõ! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mã cute impar ne ma inxi pê Herotijkwỳj ata wỳr tẽ ne cumã: — Ampo na mã wa ha ahwỳ? — hajỹr. Mã inxi cumã: — Ca ha cumã: “Ajpên ca ha imã Jowãw pê me cumrãr catê krã to tẽ, crat kam” hane — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mã hacpỹ ma mã hũjarêan kam, cute amji jaxàr ne pahhi mã: — Ajpên ca ha imã Jowãw pê me cumrãr catê krã to tẽ, crat kam — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mã Heroti te impar ne cumã amji kĩn nare, ne nee cumã Jowãw curan to prãm nare. Ne cute me kam mare mã amji ton ita kam, ihpahàm cupate, cute ihcuran na harkwa hyr. ");
INSERT INTO ram_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Mã pyt jỹr xà ata kam, cute krãhtare pê hamãr catê ata kujahêc ne cumã: — Hacjên xà wỳr tẽ ne ajpên cumã Jowãw krã jakep, ne crat kam to tẽ — hajỹr. Mã krãhtare ata wrỳc ne ma hacjên xà wỳr tẽ, ne cute Jowãw krã jakep, ne crat kam to tẽ ne cahãjre mã hõr. Mã cute inxi mã hõr. ");
INSERT INTO ram_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mã Jowãw kôt me ipa catêjê atajê te ihtyc xà ata jarẽn par, ne ma me hacjên xà wỳr me pra, ne cute me hĩ pỳn ne cute me harêt. Hõhõ, pê Jowãw pê me cumrãr catê tyc xà ita hane. Cwỳrjapê pê Heroti Jeju to amji mã Jowãw xwỳ te hacpỹ mã ihtĩr na ihcãmjĩ. ");
INSERT INTO ram_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mã cute Hũm carôt kôt hàpên xà pihho ata ton, ne ame harte jirô pê Jeju me, ihkôt me ipa catêjê me, ma Hĩpôjajo jĩkjê rũm, pjê japrỳ te Pĩrã jõ pjê ata wỳr me irêr, ne curia cute me pàr kre mã hê, cô tohkà na. ");
INSERT INTO ram_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mã pàr kre pê Jeju cator, mã me hàhtôti atajê te me Jeju pupun pyrentu. ");
INSERT INTO ram_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mã pea curia pjê ata kam cute me amji rẽc, ne ihtỳj krĩ cunea kôt me hà catêjê kôt ame pra. Ne ma me hà jikwa xà kam me cunõ, ne me ahna ahwỳ ne ma curi, por cute me Jeju jàhhuc xà na, jũ ri me hahkre pej xà ata wỳr me to pra. ");
INSERT INTO ram_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pê krĩ jacot me krĩ cunea kôt ipa xà ata ri pê ajco hãn ne prya kam, cumã me hà nõ, ne me cumã Jeju na ahwỳ, ne ajco me cumã: — Cama amji na me ijamã, wa akà jahkà cyt — hane. Ne por mehcunea te me Jeju kà jahkà cyt atajê cunea mempej pyrentu. ");
INSERT INTO ram_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Pê Parixêw catêjê kwỳ me, cute me cumã Mojxe xwỳ jõ kàhhôc to me hahkre catêjê atajê me, Krĩpinkrên pĩn me cato. Pê Parixêw catêjê ajco Juta catêjê cunea mã mam cute ampo to me hahkre xà atajêa to ihhimpej. Na quê ha menquêtjê te me to amji pyràc xà te me amji ton xàa kôt, me hàpàn curê, ne mam me amji mã ampi ne hũhkra cuhhõ, ne cormã me apà. Ne por me hõ japrôr xà pĩn cute me ampo xô japrôr atajê, quê ha cute mehkur xwỳjrea na cuhhõ. Ne cormã, rỳ pêa mã cute ampo to me amji pyràc xà atajê ton to me ipa, ne mehkõm xà cuhhõn xà ata na mehcuhhõ, ne me pjê te pot cuhhõ, ne wakỳre te me hàwmrõ xà atajê cuhhõ. Parixêw catêjê atajê kwỳ te me Jeju kôt me ipa catêjê nõ ata te menquêtjê te me amji pyràc xà ata kôat nee hũhkra cuhhõn pej nare kam, ahnaa hàpàn na me hõmpun. Por pê Parixêw catêjê ajco ahna me cumã awjahkre ata kaj na, cute ton. Mã cute Jeju na me cuprõn ne mehkrã. ");
INSERT INTO ram_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mã pea Mojxe xwỳ jõ kàhhôc to me cumã hahkre catêjê nõ te Jeju mã harkwa to: — Ampo na mã ajte akôt me ipa catêjê nee me panquêtjê te ampo to me amji pyràc xà atajê kam me hapac, ne ihkôat me hũhkra cuhhõn nare, ne ahnaa me apà? Jũ wỳr quê ha cute me hajỹr xà ita kam me Pahpãm cajpuaw me — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mã Jeju te me cumã harkwa to: — Põ rũm ri ihhêj ne ate amji kam me gapac xà impej, ne me acaxwãm pê me akêanre! Xãmte ampeaj kam pê Pahpãm jarkwa to ihcakôc catê japrỳ te Ixaj xwỳ me ate amji kam me gapac xà ita na me garẽ, ne me ana ihhôc to hane he: “Mehkwỳ Pahpãm mã me harkwa to: ‘Pahpãm, apeaj to apej, ne imã akĩn’ hane, ne ajte cute amji kam me hapac xà to, ampỳa mã cupê me ipa. ");
INSERT INTO ram_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ne cute me Pahpãm to mehcakôc xà impejti ita kôt hamreare. Ampo na? He me cumã me hũmre te amji kam hapac xà to pit mã hahkre to hãn ne me ipa, ne cute me cumã to hahkre xà ata kam, quê ha ihtỳj mehkwỳ mã mehhêj xia jarẽn to: ‘Pom wa me amã ampo to hahkre itajê pê Pahpãm te amji kam hapac xà’ hane”. Hõ, pê Ixaj xwỳ me ato hũjarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","— Ca ma ame ihimpej xà caca, ne ajte me aquêtjê te amji kam me hapac xà to pit mã, cute me hahkre xà ata na ca me prãm. ");
INSERT INTO ram_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ca gõtpê jũ mã me, ne amji tête me Pahpãm jarkwa himpej xà to ne me hũrê, ne amji tête me hajo, me ate me aquêtjê te amji kam hapac xàa kôt me apa prãmte. ");
INSERT INTO ram_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","11","— Pê Mojxe harkwa hyr to: “Amji mã me apãmjê cupa, ne amji mã me axyrxwỳ cupa, quê ha ihtỳj cute me hũmxwỳ mãn catêjê curan partu” hajỹr cakrô, ca ate me amji kam me gapac xà to me amji pyràc xà ata kôt, ajte ajteare mã me cumã to hahkre, ne me cumã: “Quê ha jũm mã ampeaj kam hàhcukrêj, quê ha ihtỳj to hũm me inxi tehcajpa. Nãmri quê ha cute Pahpãm jũrkwa jamãr catêjê mã, cute hũm me inxi mã ampo jõr xà atajê jõr na, amji to hũjahkre na, quê ha xwahna nee hũm me inxi mã ampo jõr xà atajê nõ nare. Ne cama me cumã harkwa to: ‘Wa ramã me Pahpãm mã ite ijàhcukrêj ita to ijũjahkre, na wa ha nee amã ampo ata jõr nare’ ” hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ne me ate amji kam me gapac xà ita kam quê ha nee hipêr me hũmjê me, menxyrxwỳ tehcajpar to prãm nare. ");
INSERT INTO ram_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","— Ca ha ate me hajỹr na, ca ha ma amji tête ame Pahpãm te amji kam hapac xà curê, ate me aquêtjê te amji kam hapac xàa to ate me amji kam me gapac, ne me cumã to hahkre prãmte. Ne ramã ate amji to me hajỹr to me amji pyràc tu, na ca atỳj me ampo itajê cunea ton to me apa — hane. ");
INSERT INTO ram_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na pê hipêr Jeju me hàhtôa na ahwỳ, ne me cumã harkwa to: — Ampo to icakôc xà ita na me ipar mã hamãa ne, mãr ca me kampa. ");
INSERT INTO ram_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","He xà cu me pajõ ku itajê, ihtỳj pahte me pahkên ton na me pahto? Hãpà! Pom hãn ne põ rũm me pajarkwa wỳr me pajõ pra ne acjêj itajê, nee me pahto kên nare. Ne pom me pahte amji kam me pajapac xà pĩn hapôj itajê ri ihtỳj me pahto kên. Xà me gũpar xà caxuw me amã me gapackre nare? Me ikampa ne ite me amã ampo to icakôc xà atajê kôt hakop to mempeaj ne — hane. ");
INSERT INTO ram_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mã Jeju te me hàhtôti atajê mã ihcakôc jicu, ne me huwahi, ne ma ikre mã hàr. Mã ihkôt me ipa catêjê te hũjarẽn xà ata na mehcukij. ");
INSERT INTO ram_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Mã cute me cumã harẽn to: — Pỳhàpà, me hũmre itajê! Xãmte nee cormã ate me icakôc xà ita na me ipar nare. Me apê me ikwỳ kwỳa cakrô, ca ajte nee ijũjarẽn xà atajê na me ipar nare. Pom ampo me garkwa mã acjêj ca me ku itajê, quê nee ame ato kên nare. Ampo na? Quê ha nee ate amji kam me gapac xà mã hàr nare, ne atu mã quê ha axà, jirô pê mã quê ha gĩ pê cato — hajỹr. Por pê Jeju me pajõ to hũjarẽn to hane ata kôt, cu pahtỳj me pajõ itajê cunea ku, ne nee ampo itajê nõ ihkên nare na, ramã me pamã hahkre pej. Ne cormã Jeju me cumã: ");
INSERT INTO ram_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","— Ne por quê ha jũm te amji kam hapac xà pĩn ampo cato ata, quê ha jũm ata to kêanre ne. Ampo na? Cute amji kam me hapac xà ata pĩn, quê ha cute ampo to amji kam hapac xà kêanre ata cato. Atajê pê ri cute amji kam hapac xà kên me; ampo kam me pahpahàm kêanre ata me; me hàhkĩj me; me hàhcuran me; amji pê mehprõ caxun me; ");
INSERT INTO ram_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cute mehpore me, me hàhcukrêj kĩn me; mehkwỳ to kên xà caxuw me hũ na hàhtàt nare me; mehhêj xi me; mehpahàm nare me; hũ na amji mã ampo kĩn me; mehkwỳa mã mehkwỳ to mehcakôc kên me; amji to me hàmra me; mehkrã nare me. ");
INSERT INTO ram_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ne ampo itajê quê ihtỳj ate amji kam me gapac xà cunea pĩn hapôj, ne quê ihtỳj me ato kêanre ― hane. ");
INSERT INTO ram_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jirô pê, pê ma Jeju krĩ pê cato ne mõ, Kẽn jõ krĩ pu na pjê ata wỳr. Ne pea ikre nõ ita mã hàr, ne tee ame hàhtôti atajê pê amji to ipimxur to hahkre, ne jũ wỳr quê amji mã hamã ne amxu. ");
INSERT INTO ram_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pê cahãj nõ pê ihkra cahãj kam, me pahcurê xwỳnti carõ kên ata te Jeju jarẽn par. ");
INSERT INTO ram_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cupê krĩxàre pê côxwa cahê na Xiri jõ pjê catêjê nõ, ne nee cupê Juta catêjê nõ nare cakrô, mã ma hỹrmã tẽ, ne cuna mã ihkõn krã na hỹr ne ahna hàhwỳr ne cumã: — Ikra intête ampo carõ kên ita capa — hane. ");
INSERT INTO ram_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mã Jeju te cahãj ata capi prãmte cumã: — Ite ato hajỹr xà ita na ihkaj na. Ampo na? Nee apê Juta catêjê nare, ne acahkrit, cwỳrjapê ri apê roap pyràc. Ne wa ite mam mehkra mã harte xà caxuw wa ajpên me hỹrmã mõ, ne nee rop mã mam ite harte xà caxuw wa ajpên me hỹrmã imõr nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mã cahãj cumã: — Ỹhỹ pahhi, he ampeaj kam ri icahkrit ne Juta catêjê kĩnte ipê roap pyràac cakrô, wa itỳj hanea ana prãam to prãm. Pom quê hãn ne ahkrare hàpàn xà pê ampo krut cupa mã ajhu, mã rop krare cuku, ita jĩkjê na ite hajỹar. Na wa ate itehcajpar xà kênre ita na ahna awỳ — hane. ");
INSERT INTO ram_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mã Jeju cumã: — Ate acakôc xà ita ton, cwỳrjapê gapacta ne amji jaxà gũrkwa wỳr, ne ramã me pahcurê xwỳn carõ kên, akra cahãj ita pê cator — hane. ");
INSERT INTO ram_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mã ma pyjê nõ ata te amji jaxàr, ikre wỳr, ne cator. Ne cute me hikwa xà kam ihkra pupun, mã ihtỳj nõ, mã ma cupê me pahcurê xwỳn carõ kên cator. ");
INSERT INTO ram_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jirô pê mã ri ma Jeju krĩ pê cator ne mõ. Ne ma Kẽn jõ krĩ jõ pjêa na mõ, krĩ atajê kôt, ne Teppro jõ krĩ na mõ. Ne cute Krĩtetej jõ pjê jakren, ne ma Hĩpôjajo jõ pjê na cator. ");
INSERT INTO ram_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mã jũmjê itajê te Jeju wỳr me jũm xũmre japac tu, ne nee ihcakôc pej nare ata to me cator. Ne cute Jeju na me hàhwỳr, quê ahna hũhkra xi ne to impej. ");
INSERT INTO ram_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mã Jeju te me hàhtôti ata pê to cator, ne pea cute hũhkrahhi to ajpẽn cuna mã hapac jũjê. Ne cute hũhhi kam harcô mẽn, ne cute harcô ita to hũmre ata jõhto cupên. ");
INSERT INTO ram_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jirô pê mã ri kàj mã, côjkwa wỳr irĩt ne cute higẽc mẽn, ne Juta catêjê jarkwa to cumã: — Epata! — hajỹr. Ita jũjarẽn xà te: “Amji jihê mẽ, ne akre!” ");
INSERT INTO ram_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Me ajkaam mã, hapackre ne hõhto jirot, mã cute ihcakôc kam ihtẽm pyrentu, ne nee hipêr ihcakôc kên nare. ");
INSERT INTO ram_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mã Jeju te amji jarẽn tête me cumã harkwa to: — Nee ame cumã ijarẽn nare — hajỹr cakrô mã tàkamrỳ cute me harẽn to cati to mõ. ");
INSERT INTO ram_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ne por pê ajco me harẽn pa atajê to pê ajco me amji mã ajkra, ne ajpẽn mã me harẽn to: — He cumã ampo pej cunea ton jahkre pej, na ri ihtỳj to, ne me to impej! Ne ihtỳj hacpỹa mã me hapactu jũpar na me to, mã me awpa, ne jũ mã me ipẽrkêt to, mã hacpỹa mã mehcakôc! — hane. ");
INSERT INTO ram_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mã me ahna amcro jàhtô nare, mã ma põ kam, mũhũràn me hàhtôa ne cute Jeju na me cuprõn. Ne me hàpàn xà caxuw ampo hamreare xà ata kam, mã Jeju te ihkôt me ipa catêjê mã: ");
INSERT INTO ram_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","— Ampeaj kam imã me caprĩ xà. Ampo na? Ramã ikôt ame ipa ita to cute me amcro to incrê, ne põti ita kam me cupê me hàpàn xà caxuw ampo hamreare. ");
INSERT INTO ram_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wa me hàpàn nare kam me hũrkwa wỳr ame cucrà, quê ha pry cahti ri prãm ame curẽ, nãmri mehkwỳ hũwrya pĩn me hapôj — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mã ihkôt me ipa catêjê te mehcukij ne me cumã: — Jõ ri wa põ ita kam, me hamreare ita kam me hàhtôti itajê mã harte xà caxuw me hõ nõ mã me icato? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mã Jeju me cumã: — Jũ mã ri me amã kwỳr te pro jàhtô na cute? — hane. Mã me cumã: — Imã kwỳr te pro te xet — hane. ");
INSERT INTO ram_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mã cute pjê kam me hàhtôti atajê jỹr na me cumã hũjahkre, mã me hỹr. Mã cute kwỳr te pro te xet ata cwỳr, ne to Pahpãm mã hũrên hakryti to ihcakôc. Jirô pê mã ri cute me cumã ihkryj par, ne ihkôt me ipa catêjê mã hõr, mã cute me cumã to ipicràn par. ");
INSERT INTO ram_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ne hanea ne caxuw tep xêt nõ atajê, mã Jeju te to Pahpãm mã hũrên hakryti to ihcakôc, ne ihkryj ne ihkôt me ipa catêjê mã hõr. Mã hanea ne cute me cumã to ipicràn. ");
INSERT INTO ram_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mã mehcunea jàpàn kênre nare, ne ame harte. Mã cormã ihkôt me ipa catêjê te ihcahhur jàhhuc itajê to me kàhà to xet ne me to hipu partu. ");
INSERT INTO ram_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Ne pê me apà atajê pê me hàhtô na me mir to cwat. Mã ma Jeju te mehkujahêc par, jirô pê mã ri pàr kre mã hàr, ihkôt me ipa catêjê me, ne ma Tarman jõ pjê wỳr cô ita na me irêr, ne me cator. ");
INSERT INTO ram_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mã Parixêw catêjê kwỳ hỹrmã cator, ne cute me Jeju te ampo pihho catia ton na me ahna hàhwỳr kam ihtẽm. Ne nee mã cute amji mã me to ihhimpej xà caxuw amehcukij nare. Ne cama cute mehkên mã mẽn prãmte ri amehcukij, ne me cumã: — Mẽr me imã côjkwa pĩn ampo pihho catia to, wa ha me hõmpu, ne cormã me Pahpãm te me iwỳr akujahêc na me gahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mã Jeju te caxwãm catia mã incaca mẽn, ne me cumã harkwa to: — Ampo na mã ca me akwỳ mea mã, ite ampo pihho catia ton na me ina gàhwỳr to ame apa? Wa ramã ite, me ate amji mã me ito ahimpej nare na me gahkre pej. Cwỳrjapê wa ha nee me amã, ate ampo pihho catihti na me gàhwỳr xà itajê nõ ton nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ne ihkôt me ipa catêjê me pàr kre mã me hàr, ne ma hacpỹ mã hĩpô jĩkjê wỳr me to tẽ. ");
INSERT INTO ram_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mã ihkôt me ipa catêjê te me kwỳr te pro to me hapac kêt, ne pyxit peaj ne pàr kre mã me to hàr. ");
INSERT INTO ram_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mã Jeju te me cumã mehcawpa to: — Co he, ma amji na me Parixêw catêjê me, pahhi Heroti jõ kwỳr te pro to me guphêa ne! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mã ihkôt me ipa catêjê te ita to ajpẽn mã mehcakôc kam ihtẽm, ne me ajpẽn mã: — Pahte me kwỳr te pro nõ pyr nare, na ri apu hũjarẽn xà ita to hane — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mã Jeju te mehcakôc xà ita na me hahkre pej, ne mehcukij to: — Ampo na mã ca me apê kwỳr te pro nare ata na ame ajpẽn cukij to ame apa? He xà ajkĩ me apê ijũjarẽn xà ita par kôt hakop jahkre kêatre? Xà wa ajkĩ amji jarte to pit mã amji japackre to ipa prãm? Ampeaj kam ate me ampo par xà itajê cunea na me akrã tỳj. ");
INSERT INTO ram_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xà nee me arĩt xà caxuw me ato nare? Ne nee me gapac nare, me gũpar xà caxuw? ");
INSERT INTO ram_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","He xà ca nee ajte me kwỳr te pro te xĩc to, ite me hàhtôa mã harte xà ata na, me ito amji japackre nare? Jũ mã ca ate mehcahhur to me kàhà to me hipu ton? — hajỹr. Mã me cumã: — Kàhà te tôxi — hane. ");
INSERT INTO ram_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mã hipêr cute mehcukij to: — Ne por wa ite mam me hàhtôti te me mir te cwat mã kwỳr te pro te xet kryj xà ata, jũ mã ri ihcahhur na kàhà jàhtô na cute, ca ate me to hipu? — hajỹr. Mã me cumã: — Kàhà te xet — hane. Mã Jeju me cumã: ");
INSERT INTO ram_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","— Mẽr hõhõ, xà ca ajte cormã nee ite me amã Parixêw jõ kwỳr te pro jarẽn xà ita jahkre pej nare? — hane. Mã cormã ihkôt me ipa catêjê te Parixêw te amji kam me hapac xà kên pê kwỳr te pro cawpa xà ata na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jirô pê mã ri Jeju me, ihkôt me ipa catêjê me, ma krĩ jacot pê Tep jõ krĩ mã me cator. Mã curi catêjê te me jũm to tũm japrôr ne hỹrmã me to cator, Jeju te ihcupên prãmte. ");
INSERT INTO ram_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mã Jeju te into tũm ata jũhkra na ipyr, ne ma krĩ pê to cator. Ne cute hũmre ata to na harcô to ihtẽm, ne ahna hũ xir ne cumã: — Xà ca atỳj ita caxuw ampo pupu? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mã hũmre ita rĩt ne apu rĩt, ne cute cumã harkwa to: — Wa itỳj me hõmpu, ne cama me hõmpun xà ita pê ihhêj rũm me hũmre pê pĩ pàr te ipa pupun — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mã hipêr Jeju te into na hũ xir. Mã pea hũmre ata rĩt pej, ne caprãr, ne ihtỳj ihcunea na irĩt pej. ");
INSERT INTO ram_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ne ma cute krĩ pê hũmre ata kujahêc, hũrkwa wỳr, ne cumã: — Tẽ ne nee hacpỹ ne Tep jõ krĩ wỳr amji jaxàr nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mã ma Parixêw catêjê kwỳ Jeju wỳr me mõ, cute ampo na mehcukij prãmte. Ne nee mã cute me ampo jahkre pej prãmte hỹrmã me mõr nare, ne cute me Jeju te ihcakôc xà nõ to ihcupan na me ton to prãmte ri, hỹrmã me mõ. Ne hỹrmã me cator, ne me cumã: — Xà cu ha ajkĩ Mojxe xwỳ te me pajapackre xà ata kôt, pahtỳj me pahprõ mã me hikra? — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mã Jeju te mehcukij to: — Jũ mã pê Mojxe ita na ihhôc to? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mã me cumã: — Pê Mojxe me pamã to hahkre to hane he: “Ca ha aprõ mã hikran prãm, ne ate cumã hikran xà na cumã ihkàhhôc to, ne cumã agõ, ne atỳj jũ kam ihkujate” — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mã Jeju me cumã: — He me akrã tỳj, ne me gũpar nare kam pê Mojxe me gapackre xà ita to hane. ");
INSERT INTO ram_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","Ne rỳ pêa mã, mam Pahpãm te pjê ton xà ata kam, pê mam hũmre to ne ihkôt cahãj to, ne ajteare mã quêt harẽn to hane he: “Quê ha ita caxuw me hũmre menxyrxwỳ me, me hũmjê jicu, ne me hikwa tuw, ne ma mehprõ wỳr me rê, ne mehprõ me, me ajcaxê, ne ajpẽn kam me pyxit peaj” hane. Cwỳrjapê ri nee ita caxuw Pahpãm mã ajpẽn kam me ipijakrut nare, ne ajpẽn kam me pyxit peaj. ");
INSERT INTO ram_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cwỳrjapê quê nee Pahpãm te ajkam me to cuprõn ne me to pyxit peaj ata to, hipêr ajpẽn pê me ipicapôn xà nare — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ne Jeju te me cumã hũjarẽn to hajỹr jirô pê mã, ma hacpỹ mã ikre wỳr, ihkôt me ipa catêjê me, me mõ. Ne ikre mã me hàr, mã ihkôt me ipa catêjê te me hahkre pej prãmte ahna mehcukij. ");
INSERT INTO ram_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mã Jeju me cumã: — Ỹhỹ, quê ha jũm xũmre hĩxi mã hikra, ne ajteare mã cahãj nõ me hikwa na, quê ha ramã hĩxi ata cuna mã ihkên xà ton ata kôt, Pahpãm mã cupê cute amji kam hapac xà kam inxyre kêanre atajê ton catê. ");
INSERT INTO ram_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nare quê ha jũm cahãj te impjên mã hikran, ne ajteare mã jũm xũmre me hikwa na, quê ha ramã impjên ata cuna mã ihkên xà ton ata pê Pahpãm mãa, cupê cute amji kam hapac xà kam inxyre kêanre atajê ton catê — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jirô pê mã ri Tijac me Jowãw pê Xeptew kra atajê mehkwỳ pê ampỳa mã, ahte Jeju wỳr me hàhtêp, ne me cumã: — Me ijõ Pahhi, ate amji kam gapac xà na, ite me ana ijàhwỳr xà kampa, ne nee me ipê jũ mãn nare ajco — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mã Jeju me cumã: — Ampo to wa ha me amã? — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mã me cumã: — Ca ha amcro nõ na ate pjê cunea to ahimpej xà caxuw gỹr xà catia carôt tỳjti ata kam jỹ, ne ca ha pijamã amji na me inõ jamã, wa ha me inõ acahê na awpôc rũm jỹ, ne me inõ awke rũm jỹ, ne acahê na me ihimpej! — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mã Jeju me cumã: — Pom ca ate ampo na me gàhwỳr xà ita, ca ate nee me hahkre pej nare kam, atỳj ahna me iwỳr. Xà ca ha ajkĩ atỳj icuxà me ikên xà itajê mã me awcanã? Ỹhỹ, wa ha ihimpej xwỳjrea na itỳj amji pupun xà kêanre to amji pupu. Ne por ite amji pupun xà kêanre ata pê ihhêj rũm ite ampo kêanre te ito kên xà to ite ikõm, ne kam amji cumrãr xà ata — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mã me cumã: — Wa ha itỳj me awcanã — hane. Mã Jeju me cumã: — Ampeaj kam ca ha atỳj icuxà me amji pupun xà kêanre to me amji pupu. ");
INSERT INTO ram_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","He wa nee pa me amã jũ mãn nare, nãmri ramã Pahpãm te amji mã icahê na mehkrĩ ne mehhimpej catêjê atajê capi, ne por cute amji mã jũmjê capi atajê mã quê ha ihkrĩ xà itajê jahkre, quê ha kam mehkrĩ — hane. ");
INSERT INTO ram_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mã ihkôt me ipa catêjê kwỳ te me ita par, ne ame Tijac me Jowãw kam mencryac to amencryc. ");
INSERT INTO ram_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mã Jeju te amji wỳr mehcunea to cuprõn ne me cumã: — He me amã pjê ita kam krĩxàre jõ pahhi catêjê te kypê mehkwỳ to ihhimpej nare na, me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na wa ha intête me amã, mãr quê nee jũ caxuw me akam ampo itajê nõ hajỹr nare. Nãmri quê ha me anõ mã amji to acati to prãm na, ca ha me akwỳ cunea mã gàpên to apa. ");
INSERT INTO ram_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne por quê ha mam jũmjê mã amji to prãm atajê, quê ha nee pahhiti na me amji to prãm nare, ne quêt amji to cama mehcunea mã hàpên catêjê. ");
INSERT INTO ram_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","— He nee jũm xũmre te ito impejti xà caxuw wa ajpên pjê ita wỳr, ipê me Ahàkà cati te me hũmre na amji ton, ne iwrỳc nare. Ne quêt ite me atehcajpar prãmte wa ite amji to me akritxwỳ, ne me gaxà kam ityc xà caxuw, wa icator, mãr wa me hàhtôa ne me hũtà ne me to impej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ne jũ mã me ahna amcro te, mã ma hacpỹ mã Mehkênpupunxà jõ krĩ pĩn cute me amji jaxàr ne me mõ, mã ramã Jeju mã prãm. ");
INSERT INTO ram_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mã ampỳa mã cute pĩxô pàr nõ hôncoti pupun, ne ma hỹrmã mõ ne cator, cute ahna hô japên prãmte, mã ahna hô nare. Pê cormã hô xà kaj na, na pê nee hô nare. ");
INSERT INTO ram_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mã Jeju te harkwa to pĩxô pàr ata crôn to: — Quê ha nee hipêr jũ caxuw jũm apàr xô nõ krẽr nare — hajỹr. Mã ihkôt me ipa catêjê te incrôn xà ita na mempar. ");
INSERT INTO ram_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mã apẽ mã iràrà na, ma hacpỹ mã Jeju me ihkôt me ipa catêjê pry ata kôt me mõ, pĩxô pàr ata na, ne cute me hõmpun, mã harê mea mã incrà tu ne xa. ");
INSERT INTO ram_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mã Petrô te pĩxô pàr crà ata pupun, ne Jeju te cumã harkwa hyr na to amji japackre ne Jeju mã: — Ijõ Pahhi, hõmpu he, mãr ca ate pĩxô pàr crôn ta, incrà tu ne xa he — hajỹr. ");
INSERT INTO ram_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Mã Jeju cumã: — Ita to amji japackrea ne he, ca ha ate ampeaj kam Pahpãm to amji mã ahimpej na, ca ha hàhkà jakôtti ita mã garkwa to: “Amji capa, ne côxwa kam amji to awcapê” hane, quê ha hàhkà jakôtti ata ihtỳj akampa, ne garkwa kôt amji capa ne amji to awcapê. Ỹhỹ, ca ha ate gũjarẽn xà ata kam ramã amji caxwãm pê amji mã: “Wa ramã ite Pahpãm te ita to hajỹr to prãm na hahkre pej” hajỹr na, quê ha ihtỳj garkwa kôt amji to awcapê. Nãmri ca ha ate gũjarẽn xà ata kam, amji mã: “Mõrmõ Pahpãm mã ajkĩ ita na to prãm nare, mõrmõ ajkĩ ahna cumã to prãm” hajỹr na, quê ha nee apar nare. ");
INSERT INTO ram_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","— Cwỳrjapê wa me amã awjarẽ, ca ha me Pahpãm mã acakôc ne ampo na me wỳ, ne atỳj cute me amã hõr na amji mã me to hajỹr pyrentu, mãr quê ihtỳj me amã cugõ, ca ha me acwa. ");
INSERT INTO ram_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ca ha hãn ne Pahpãm mã me acakôc kam pra, ne atỳj jũm te me anõ to kên xà atajê jicu, ne to tojnõ, mãr quê côjkwa kam Inxũ Cati jỹ ata hanea ne, me acuxà, ate me akên ton atajê cunea jicu, ne to tojnõ. ");
INSERT INTO ram_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nãmri ca ha ate me jũm te me anõ to kên ata to tojnõ nare na, quê ha Inxũ Cati, côjkwa kam ihkrĩ ata, me acuxà, nee ate me to kên atajê to tojnõ nare — hane. ");
INSERT INTO ram_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jeju te pjê jamre na harẽn jicu xà to: — Nee jũm mã amcro me, caxwa me, pyt jỹr xà nõ jahkre pej nare, Inxũ te amji mã ihhyr xà ata na. Ne nee côjkwa kam cumã me hàpên catêjê nõ me, ipê ikra mã, cute amji mã amcro hyr xà ata jahkre pej nare. Ne Inxũ pyxit peaj mãri cute amji mã amcro hyr xà ata jahkre pej. ");
INSERT INTO ram_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cwỳrjapê ca ha me guphêa rũm me apa, ne nee ca atỳj ame apa nare, ne ma me amji jamãr to me apa. Ampo na? He nee me anõ mã hõ amcro ata cator xà jahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","35","— Quê ha ihhêj rũm me Ahàkà cator xà ata pê jũa kam, hũwrya kam me hũmre nõ tẽ, ihtẽm xà ata to ihtẽm pyràac. Ne ihtẽm xà ata wỳr, quê ha ahpỹanre na cumã me hàpên catêjê mã, me hàpên xà jõr partu. Ne pea hũrkwa jamãr catê mã harkwa to: “Ma ijũrkwa ita jamã, nãmri me apê hacpỹ ne icator xà na ijahkre kêatre, mõrmõ wa ha pyt kam icato, nare, wa ha caxwa picapôn kam icato, nare wa ha awcapàtkô cahtiri icato, nare, wa ha iràràtia na ajkĩ icato” hane. — He me apê ikre jamãr catêjê atajê pyràac, ne ipê ikre jõ pahhi ata pyràac. Cwỳrjapê ca ha me gũjamãr pejti to me apa, ne ma me ijikaj. ");
INSERT INTO ram_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ca ihhêaj to me ijikaj nare kam, wa ha krãa me awỳr icato, ne nee me gõt na icator, ne me gõt na me apupun nare! ");
INSERT INTO ram_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ne pom wa amã awjarẽ ita, wa nee apyxit peaj mã harẽn nare, wa mehcunea mã harẽ, ca ha nee atỳj ame apa nare, ne ma me amji jamãa ne! — hane.");
INSERT INTO ram_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Taamã Tejopir, ipê Ruc, pa wa Jeju na amã ihhôc. Pê ampeaj kam me hàhtô ne hãn ne Jeju na, ame ampo pupu atajêa na mehhôc to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pê mam cumã kat kam jũmjê itajê ampo cunea pupu, ne ajco mehcunea mã ampo itajê jarẽn to me ipa. Ne cute me imã ampo itajê cunea jarẽn. Na wa ite ampo itajê cunea na amã ihhôc. ");
INSERT INTO ram_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ỹhỹ, pahhi Tejopir, wa ite amji mã iprĩa ne ampo itajê to hahkre. Ne ampo itajê ri, cute mam, cumã kat kam, mam me hõmpun xà. Ita cwỳrjapê ri ahna imãa impejti, na wa catyt kam ite ihcunea na amã ihhôc to impejti. ");
INSERT INTO ram_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ihhêj ne ramã jũm te amã ampo itajê to hahkre. Na wa ite ita kam ahna amã ihhôc, ca ampo itajê cunea pupu ne hahkre pej pêa ne, nãmri ampeaj kam ri. ");
INSERT INTO ram_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ỹhỹ, pê cormã Heroti pê pjê jõ pahhi, Juta jõ pjê kam, pê curi Pahpãm mã mehcajrẽn catêjê nõ ita japrỳ pê Xacarij. Pê cupê Apij xwỳ kwỳ kwỳ nõ. Ne hĩxi japrỳ pê Ixapewkwỳj, ne cupê Arãw xwỳ tàmxwỳ tàmxwỳ nõ. ");
INSERT INTO ram_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ne pê ajwar catyt kam me ipa, ne mempejti to me amji kampa, Pahpãm cuna mã. Ne ajco me Pahpãm jarkwa cunea kampa. ");
INSERT INTO ram_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ne pê Ixapewkwỳj ita ihkra nare. Ampo na? Pê hahũm ita na ipa, ne ramã ajwar mehwejtu. ");
INSERT INTO ram_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mã hamre, Apij xwỳ kwỳ jàpên xà jõ amcroa kam hàhhuc, mã Xacarij Pahpãm cuna mã apu hàpên to mõ, Pahpãm to amji kam hapac xà jũrkwa kam. ");
INSERT INTO ram_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mã jũm ita te Xacarij capi, hàr ne cute Pahpãm cuna mã ampo kũm cuxwati ita mã haxàr, mã cute caxàr prãmte. Ata to pê Pahpãm mã mehcajrẽn catêjê kwỳ hãn ne ame. Mã hamre, ma hàr, Pahpãm to amji kam me hapac xà jũrkwa caxwãm pê. ");
INSERT INTO ram_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mã jũmjê atajê jàhtôa ne cute me cuprõn, ne põ pê me xa, ne Pahpãm mã mehcakôc. Mã Xacarij xàr ne xa, ne apu ampo kũm cuxwati ata to capa. ");
INSERT INTO ram_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mã ihprõt pê, Pahpãm jarkwa to memprar catêjê nõ côjkwa pĩn cator, ne ampo kũm cuxwati te caxàr xà ata cuna mã awpôc rũm xa. ");
INSERT INTO ram_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mã Xacarij te hõmpun, ne ampeaj kam cumã hũpa, ne cupê amji jahkre kêatre, ampo to mõrmõ quê ha ajte. ");
INSERT INTO ram_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mã Pahpãm jarkwa to imprar catê cumã: ― Xacarij, nee ca apu icupa nare, ca ate Apãm Cati mã acakôc, mã cute apar. Na quê ha gĩxi mã ihkra xũmre nõ, ca ha me cumã haprỳ to Jowãw. ");
INSERT INTO ram_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Quê ha ihpỳm xà ata kam ca ha gakry, ne amã amji kĩn. Quê ha hanea ne jũmjê hàhtôa ne ame hakry. ");
INSERT INTO ram_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","― Ampo na? Quê ha Pahpãm cuna mã cupê hũmre catia. Quê ha nee ampo te ame to ipipãn xà ata to apu ihkõm nare. Ne quê ha ihpỳm ata caxuw, quê ha Pahpãm Carõ Pejti cumã amji gõ, ne to hipu tu ne, ne to carôt tỳj. ");
INSERT INTO ram_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne quê ha Pahpãm wỳr, Juta catêjê jàhtôa ne to amji jaxà, quê ha hipêr Pahpãm to me amji japackre. ");
INSERT INTO ram_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","― Ne quê ha Pahpãm Erij xwỳ cuxà to ihtỳj, quê ha cupê Pahpãm jarkwa to imprar catê, ne ampo to impej pa, Pahpãm kra cator xà jahkà na. Pom pê Pahpãm jarkwa to ihcakôc catê Erij xwỳ ata mã mam carôt tỳjti gõ ata cuxà, quê ha cumã hĩ cunea kam carôt tỳjti gõ. Ne hacpỹa mã ajpẽn na me cumẽ, quê ha me hũmjê me, mehkra hacpỹa mã me cumã ajpẽn kĩn. Ne mehkrã kên atajê, quê ha hacpỹa mã catyt kam me ipa catêjê atajê krã kre te amji jahkre pejti kôt me to impej, quê ha mempej pynã. Ne quê ha hanea ne Pahpãm na mehkwỳ mã, quê me amji to impeaj ne, nãmri quê ha côjkwa pĩn, Pahhiti cato ata ri, hãn ne me hõmpu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mã Xacarij te Pahpãm jarkwa to imprar catê cukij, ne cumã: ― Pỳhàpà, jũ mã wa ha ajte, ne ate imã harẽn xà ita to amji mã hane? Jũ mã wa ha ajte ne hahkre pej, mõrmõ ajkĩ gũjarẽn xà ita ampeaj kam? Ramã iwej, ne iprõ te hajỹar ne ramã ihwej, nõ na mã ca imã ikra pỳm na ijarẽ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mã Pahpãm jarkwa to imprar catê cumã: ― Pỳhàpà, Ipê Caprer. Wa ijõtpê Pahpãm capi na apu ipa, ne cutea ri ikujahêc, wa xa ne amã icakôc, ne amã ampo pejti te hajỹr xà ita jarẽ. ");
INSERT INTO ram_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ca ate nee ite amã harẽn xà ata na ipar nare, ne quê ha ihtỳj hane, amcro ata kam. Ca nee ate ipar nare, incwỳrjapê ca ha apẽrkêt, ne ahnaa apa, quê ha ahnaa amã akra ihpỳm ― hane. Ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mã cormã apu ihkên, mã põ pê me xa atajê cormã me xa ne me Xacarij jikaj, ne me amji mã: ― Pỳhàpà, ampo to mã apu, ne apu ihkên? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mã cator, ne ipẽrkêt ita kam, jũ wỳr quê ihcakôc. Mã ipẽrkêt ita kôt cute me Xacarij te irĩat kam Pahpãm to me amji kam hapac xà jũrkwa kam, cute ampo pupun ata na me hahkre pej pyrentu, ne jũ wỳr quê amji mã hamã ne ihcakôc, ne cama hũhkra to ame cumã ihhimpej. ");
INSERT INTO ram_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ne Xacarij te hàpên xà jipêj, mã hamre, ne hõ amcro jamre, mã cute amji jaxàr ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mã ahna ahtũm nare mã hĩxi mã ihkra ajêt, mã nee põ mã to hapôj nare, ne ahnaa cute amji to putwrỳ to xĩc. Mã Ixapewkwỳj amji jarẽn to: ");
INSERT INTO ram_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","― Hamre, ramã ijahũm ita na iwej, ne ityc xàa wỳr ajte ikra. Ne Pahpãm te ri itehcajpar ne imã ikra jõr. Ne hamre, ita caxuw, quê ha hipêr nee jũm imãn nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mã cormã Ixapewkwỳj mã ihkra ajêt, ne ramã ahna putwrỳ te xêj, mã Pahpãm te hipêr côjkwa pĩn harkwa to imprar catê pê Caprer kujahêc, mã ma Hĩpôjajo jõ pjê kam, krĩ nõ japrỳ te Naxare jõ krĩ ata wỳr tẽ. ");
INSERT INTO ram_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ỹhỹ, pê curia cahãj nõ japrỳ te Marijkwỳj ita ihkrĩ, ne cormã increcrer, ne ramã Joje me ajpẽn pa, cume hikwa xà caxuw. Pê Joje pê pahhi Tawi xwỳ tàmxwỳ tàmxwỳ nõ. Mã Pahpãm jarkwa to imprar catê te Marij mã Pahpãm jarkwa par. ");
INSERT INTO ram_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ne côjkwa pĩn hỹrmã to cator ne cumã: ― Hàpà Marij! Gakry! Ampo na? He Pahpãm te apej mã amẽn. Xãmte ihtỳj Pahhiti acahê na apu ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mã Marij te ita par, ne hamre, ihkrã pictor tu, ne amji mã: ― Pỳhàpà, ampo na mã apu imã hane? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mã cormã Caprer cumã: ― Nee apu pa nare, Marij. Apyrên Pahpãm jakry, na ri cute ato impejti. ");
INSERT INTO ram_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ne quê ha amã akra xũmre gõ, quê ha harij ne amã ihpỳm, ca ha cumã haprỳ to Jeju. ");
INSERT INTO ram_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Quê ha cupê hũmre catia, quê ha me cumã haprỳ krut gõ, ne me cumã “Pahpãm Catia Kra” hane. Quê ha Pahpãm acãmter to pahhi, quê ha cupê mam aquêt xwỳ Tawi pê pahhi ata pyràac. ");
INSERT INTO ram_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne quê ha hõtpê cupê Juta catêjê jõ Pahhiti ita na. Ne cupê Pahhiti rohnỳtti mã, ne nee jũ caxuw cute ihhimpej xà ita cupê hamre nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mã Marij Caprer mã: ― Mẽr jũ mã wa ha ajte? Nãmri wa cormã itỳj apu ipa, ne cormã icunĩ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mã cumã: ― Pom Pahpãm me hirôa pê cati ita Carõ Pejti quê ha amã axà. Ne carôat kôt, quê ha akra. Ita cwỳrjapê quê ha acãmter ita pê Pahpãm kra impeaj, ne ajtea mã, ne impej, ne cupê catyt kam ipa catê. ");
INSERT INTO ram_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","― Mẽr hõhõ Marij, pom Ixapewkwỳj pê gũkjê wej ita, mehcunea me harẽ, xwahna hahũm na ipa. Ne ramã ihkra, ne ramã ahna putwrỳ te xêj mã ihkra cumã harij ita. ");
INSERT INTO ram_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ampeaj kam Pahpãm mã ampo cunea ton jahkre pej, quê ihtỳj me hũmre nare kam jũm cunĩ mã ihkra to ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mã hamre, Marij cumã: ― Ỹhỹ, ipê Pahpãm mã ijàpên catê. Quê ha Pahpãm ito hane, wa ha ahnaa mã ― hane. Mã ma Pahpãm jarkwa to imprar catê tẽ. ");
INSERT INTO ram_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ita jirô pê mã amcro nõ na, Marij te amji cũmpej, ne ma hũjarêan kam tẽ, Juta jõ pjê kam kẽnti jõ pjê ata wỳr. ");
INSERT INTO ram_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ne Xacarij jũrkwa wỳr cator ne hàr, ne cute Ixapewkwỳj cukij ne cumã: ― Hàpà, hàpà ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mã hamre, Ixapewkwỳj te Marij jõkre par me ajkaam mã ihtu kam ihkra jàhcujrõn. Mã Pahpãm Carõ Pejti te Ixapewkwỳj mã amji jõr, mã cute kỳj cati pêa mã ihcakôc kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne Marij mã: “Ỹhỹ, quê ha pyjê kwỳ cunea jirôa pê Pahpãm quêt ato impejti ne. Ne pom akra ita, quê ha hanea ne Pahpãm mehkwỳ jirôa pê quêt to impejti ne. ");
INSERT INTO ram_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ne akĩnte icrire. Ampo na? Quêt apê ijõ Pahhiti menxi cakrô, ca ahnaa iwỳr tẽ ne ate ipupun, ne ampeaj kam apyrên ijakry. ");
INSERT INTO ram_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne ca ate icukij, mã ikra ita hakryte itua kam hàhcujrõn. ");
INSERT INTO ram_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ca ate Pahpãm to amji mã ahimpej, cwỳrjapê quê ha ihtỳj amã to, pom cute amã amji jarẽn xà ita na, ca ha hũrên gakryti ne” hane. ");
INSERT INTO ram_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mã Marij te Pahpãm pejti na harẽn to: “Ỹhỹ, wa ha ite amji kam ijapac xà cunea to Pahpãm jarẽ. Pahpãm ri quêt cati ne impej. ");
INSERT INTO ram_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ne Pahpãm pê ikên pê ito cator catê, na ri hũrên ampeaj kam ijakry. ");
INSERT INTO ram_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mã cute ito amji japackre, ihkĩnte icrire na, ne ipê cumã ijàpên catê wa. Ne ita caxuw quê ha mehcunea, pjê cunea kam, Pahpãm mã ikĩn, mã cute ito impej na, me ito awjarẽ. ");
INSERT INTO ram_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pahpãm carôt tỳjti, na ri cute imã ampo catia ne ton. Ne Pahpãm quêt ajteare mã, ne impej. ");
INSERT INTO ram_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pahpãm hõtpê me pahcunea caprĩ, pom cu ampeaj kam me kampa atajê ri, ihtỳj me caprĩ. Mam me panquêtjê me, hapu na me pajĩ itajê me, ne quê ha hapua na me pahtàmxwỳ to hanea ne cumã mehcunea te kam me hapac atajê caprĩ. ");
INSERT INTO ram_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pahpãm te hũhkra to hàpên xà catia ne ton. Pahpãm te, cute amji to me cati prãm catêjê atajê cunea incràn. Cute hirôa pê amji to me cati prãm catêjê atajê te me amji kam hapac xà mea mã, Pahpãm te mencràn. ");
INSERT INTO ram_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pahpãm te me hõ pahhi carôt catihti atajê jũrên partu, ne me to ihkryjre. Ne amji to me cati prãm nare atajê ri, cute me to ihkà. ");
INSERT INTO ram_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pahpãm te me cupê hamreare atajê me, me cumã prãmti atajê mã harte, ne me cumã harte kam to incrà tu. Ne me hakràj catêjê atajê, Pahpãm te hũ kam amencràn. ");
INSERT INTO ram_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ne Pahpãm pê me panquêtjê mã, mehtehcajpar xà to awjahkre. Ne hamre, ihtỳj cute me cumã ton, quê ha ihtỳj Juta catêjê tehcajpa. ");
INSERT INTO ram_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ne cute Aprãw xwỳ me, ihtàmxwỳ tàmxwỳ caprĩ na amji to amji japackre, por pê ramã ahna amji jarẽ ata na” hajỹr. Hõ, Marij te Pahpãm to hũjarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ne cute Ixapewkwỳj cahê na amji to putwrỳ to incrê jirô pê ma amji jaxàr, hũrkwa wỳr. ");
INSERT INTO ram_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mã hamre, Ixapewkwỳj mã ihkra pỳm xà jõ amcro kam hàhhuc, mã cumã ihkra pỳm. ");
INSERT INTO ram_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mã cahê na amehkrĩ catêjê me, me hũkjê me, cute Pahpãm te Ixapewkwỳj to amji kam hapac xà impejti na me harẽn par. Mã hamre, mehcunea ame hakry, Ixapewkwỳj mea mã. ");
INSERT INTO ram_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mã ihkra xũmre ita na amcro te ôjtô, mã hamre cute me cumã haprỳ jõr xàa kam hàhhuc, ne hanea ne cute mempy kà incrire ne me hitep xàa kam hàhhuc. Pê me cupê Juta catêjê incaca xà ita ajteare mã me cumã. Pê ajco me cumã ihkra xũmre ajhu, pê ajco me cumã impy kà jakep, mehcunea te me cupê Juta catêjê na me hahkre pej prãmte, nãmri ajteare mã me. Mã hamre, me cumã hũm japrỳ pê Xacarij xãm prãm. ");
INSERT INTO ram_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mã inxi me cumã: ― Hamreare, hamreare, quê ha haprỳ Jowãw ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mã me cumã: ― Hamreare, gũkjê nõ japrỳ te Jowãw nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mã cute hũhkra to hũm cukij, haprỳ jũ ri cumã hõr prãm. ");
INSERT INTO ram_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mã Xacarij te ihhôc xà na hàhwỳr, ne cute kam ihhôc to hajỹr he: “Ỹhỹ, haprỳ te Jowãw” hane. Mã hamre, mehcunea krã pictor. ");
INSERT INTO ram_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Me ajkaam mã hacpỹa mã Xacarij te ihcakôc kam ihtẽm, ne Pahpãm mã ihcakôc, ne cute Pahpãm peaj na cumã harẽn. ");
INSERT INTO ram_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mã cahê na mehkrĩ catêjê cunea mã ampeaj kam pa cati. Mã hamre, apu harẽn xà ita cahkũm, Juta jõ pjê kam, kẽnti jõ pjê ata cunea kôt. ");
INSERT INTO ram_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mã mehcunea te me ita par atajê, ita to pit mã ame amji kampa, ne ahna me amji cukij, ne me amji mã: ― Pỳhàpà, jũ mã mõrmõ quê ha hũmre krare ita ajte? ― hajỹr. Ampo na mã ame amji cukij to hane? Pê hirã pê hũmre krare ita kam Pahhiti carôt catia na pê. ");
INSERT INTO ram_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mã Xacarij pê hũmre krare ata me hũm, hacpỹa mã ihcakôc. Ne Pahpãm Carõ Pejti jarkwa kôt cute hacpỹa mã Pahpãm to hũjarẽn kam ihtẽm, ne harẽn to: ");
INSERT INTO ram_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hacme, ne me pajõ Pahhiti to me awjarẽ, por Pahhiti catihti ne impejti pê me papê Juta catêjê Pãm Catihti ata to me awjarẽ. Ỹhỹ, Pahpãm te me pahtehcajpar prãmte cator, ne cute pahte me to ihcupan xà pê me pahto cator. ");
INSERT INTO ram_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pê Tawi xwỳ pê Pahpãm mã hàpên catê, mã Pahpãm te ihtàmxwỳ tàmxwỳ nõ, cute me pahkên pê me pahto hapôj catê na hãm, mã ampeaj kam carôt tỳj. ");
INSERT INTO ram_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ne pê ramã rỳ pêa mã Pahpãm ita jarẽ. Pê Pahpãm jarkwa to me cumã ihcakôc catêjê impejti atajê harkwa na ahna mehhôc pa. Ne pê Pahpãm jarkwa na mehhôc catêjê ajco ita to me hane. ");
INSERT INTO ram_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Pê Pahpãm me pahcurê xwỳn pê me pahto cator xà to hane, ne me pahcurê xwỳn carôt pê me pahto hapôj pa. ");
INSERT INTO ram_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pê Pahpãm me panquêtjê mã jũ caxuw cute me caprĩ to cator xà ata to awjahkre. Ne me cumã awjarẽ, mãr quê me to amji japackrea rũm me ipa, ne nee jũ caxuw me to hapac kêt nare. ");
INSERT INTO ram_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Pê Pahpãm me panquêtti Aprãw xwỳ mã ita to awjahkre, ne to awjahkre tu. Ne ampeaj kam cumã harẽ, quê ha me pahcurê xwỳn tête me pahto pôj pa. Cu ha me Pahpãm mã me apê, ne nee ame pahcurê xwỳn cupa nare. ");
INSERT INTO ram_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ne cu ha Pahpãm mã me pajàpên catêjê na ame papa. Ne catyt kam ame papa, ne me pancaca xà impeaj to amji kam me pajapac to me papa, ne ahnaa Pahpãm krac ri me pajamre. ");
INSERT INTO ram_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ỹhỹ ikra, hamre, ca ha jũ caxuw Pahpãm me hirôa pê catia ita jarkwa kôt acakôc catê na apa, ne ca ha tẽ ne me pajõ Pahhiti cator xwỳjrea na apu carã pa. ");
INSERT INTO ram_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ca ha me Pahpãm krac ri me ipa atajê mã me awjarẽ, quê ha Pahpãm nee mam cute ame to kên xà ton ata to amji japackre nare, ata kôt quê ha Pahpãm mehkên pê me to pôj pa. ");
INSERT INTO ram_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Me Pahpãm jàhcaprĩ cati, ne cupê me pamã impej pit ton catê, cwỳrjapê quê ha me pamã hàhcujro gõ. Cu ha me pahte amji kam me pajapac xà impejti pupu, ne catyt kam me papa, ne me pampej pêa mã me papa. Ne me pamã pahtyc cupa itajê, quê ha Pahpãm me pahpupu ne me pamã incaca xà gõ, cu ha nee ame pahtyc xà ita cupa nare, ne cama me pahcaxwãm pê me pahcarĩcti na me papa” hane. ");
INSERT INTO ram_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mã hamre, Xacarij kra xũmre ita ihkà to mõ, ne carôt tỳj to mõ. Ne pê hanea ne cute amji kam hapac xà cati ne impej to mõ. Ne ramã ihkàa kam pê põti kam me hamreare ata kam ihkrĩ. Ne cormã Juta catêjê mã amji to ajpẽ. ");
INSERT INTO ram_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Caku ata kam, putwrỳ atajê nõ na, pê pjê cunea jõ pahhiti japrỳ te Xexa Aguxô ita harkwa ta, mehcunea mã, por hõ pjê kam krĩ atajê cunea kôt, quê mehcunea me amji japrỳ nõr pa, ne me amji cahyt, ne me hàhtô na me amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ne pê mam ramã me amji cahyt, pê Xiren pê Xiri jõ pjê to ihhimpej catê ata kam, pê mam me amji cahyt pyxit, ne me hàhtô na me amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mã hamre, mehcunea te me amji japrỳ nõr partu, ahpỹanre na me hõ krĩa kam, menquêtjê ihpỳpỳm xàa kam. ");
INSERT INTO ram_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ita cwỳrjapê ri Joje pê Hĩpôjajo jõ pjê kam, Naxare jõ krĩ kam, ihkrĩ catê, na ri ma Juta jõ pjê wỳr, Pãw jõ krĩ ata wỳr tẽ. Ampo na? Pê curia inquêt xwỳ pê pahhi Tawi xwỳ ihpỳm, ne cupê ihtàmxwỳa, na ri ma Pãw jõ krĩ wỳr tẽ, hĩxi Marijkwỳj me. ");
INSERT INTO ram_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ne cute me amji japrỳ xir. Ne pê ramã me hikwa na me ajpẽn pa. Mã ramã Pahpãm Carõ Pejti to Marij tictu. ");
INSERT INTO ram_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ne pê cormã Pãw jõ krĩ kam ame mõr reria mã, ramã cumã ihkra pỳm xàa kam hàhhuc. ");
INSERT INTO ram_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ne cumã ihcãmter pỳm, mã cute cupẽhkà to ihcupu, ne pĩ po te crat kam ampo jàpàn xà ata kam hir. Ampo na? Ramã me hàhhuc xà cunea te hipu partu, ita kam, jũ ri quê me ahtwỳ? Cwỳrjapê ri ampo jũrkwa kam me hõt. ");
INSERT INTO ram_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mã pjê ata kam, carà cahàcre jamãr catêjê hõtpê ame hamãr to me ipa. Ne amcro me caxwa kam, hõtpê ame to ipa. Ne caxwa ri, pjê ata kam, põ pê ame hamãr to ame ipa. ");
INSERT INTO ram_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mã ihprõt pê Pahpãm jarkwa to imprar catê cator, côjkwa pĩn. Mã hàhcujro pê Pahhiti jàhcujro impejti ata hàhcujro pyrentu, ne ipu na hàhcujrohti, ne ihpràti. Mã cute me hõmpun ne me cumã hũpaa to hũpa. ");
INSERT INTO ram_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mã Pahpãm jarkwa to imprar catê me cumã: ― Nee ame icupa nare. Wa ite me amã ijũjarẽn pejti to prãm to, wa me awỳr icator. Ne wa ha me amã awjarẽ, ca ha me ijũjarẽn xà ita kôt, ca ha me gakry, quê ha ampeaj kam mehcunea mã amji kĩan to amji kĩn, me cati me, mehkryjre me, quê ha mehcunea mã amji kĩan to amji kĩn. ");
INSERT INTO ram_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ỹhỹ, ita kam, caxwa ita kam, me gõ Pahhiti pê me akên pê me ato hapôj catê pỳm, Tawi xwỳ jõ krĩ kam. Ne cupê, por pê Pahpãm me amã to awjahkre ata. ");
INSERT INTO ram_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne ampeaj kam ca ha ita kam me hõmpu. Quê ha ahkrare xũmre nõ cupẽhkà ihcupu, ne ampo jàpàn xà kam nõ, ca ha hỹrmã me acato ne me hõmpu, ne me hahkre pej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mã hamre, ihprõt pê côjkwa rũm Pahpãm jarkwa to memprar catêjê jàhtôa ne hipêr me iwrỳc, ne me hỹrmã me cator. Ne côjkwa kam mehkrĩ catêjê pê me pajõ Pahhiti jarkwa to memprar catêjê itajê te me Pahpãm na mencrer kam mehtẽm, ne increar kam me harẽn to: ");
INSERT INTO ram_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Quê ha côjkwa kam mehcunea jirôa pê Pahpãm pejti ne cati na me harẽ. Ne pjê kam, quê ha Pahpãm me to impej atajê, quê ha me caxwãm pê mehcarĩcti ne” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mã hamre, Pahpãm jarkwa to memprar catêjê hacpỹa mã cute me amji jaxàr, ne me hàpir, côjkwa wỳr. Mã carà cahàcre jamãr catêjê, hakàn pê ame amji mã harẽ, ne me amji mã: ― Hacme, Pãw jõ krĩ wỳr, ne Pahpãm te me pamã ampo jarẽn xà ita pupu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ne ma me hũjarêan kam me pra, ne ame hapê, ne Joje me Marij wỳr me cator, ne cute mehkrare pupun, mã ampo jàpàn xà kam nõ. ");
INSERT INTO ram_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mã cute me hõmpun, ne ma me pra ne mehcunea mã, Pahpãm jarkwa to memprar catêjê te me cumã ahkrare jarẽn xà ata jarẽn to me mõ. ");
INSERT INTO ram_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mã hamre, mehcunea te mempar atajê te amji mã me ipikrar, ne me amji mã: ― Pỳhàpà? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mã Marij apu carà cahàcre jamãr catêjê atajê te cumã ampo jarẽn xà atajê cunea to apu amji japackre, ne to amji japackre ita na. ");
INSERT INTO ram_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mã ma carà cahàcre jamãr catêjê te amji jaxàr, ne ma me Pahpãm pejti, ne catihti na me harẽn to me mõ. Pom Pahpãm jarkwa to imprar catê te me cumã hũjarẽn xà atajêa na, cute me hõmpun, mã ahnaa. Na ri ame hakry ne ma Pahpãm pejti na me harẽn to me mõ. ");
INSERT INTO ram_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mã ramã ihkrare ata na amcro te ôjtô, mã cute mempy kà incrire ne me hitep xàa kam hàhhuc, mã cute me cumã haprỳ jõr, ne me cumã Jeju. Ne haprỳ ita pê Pahpãm jarkwa to imprar catê cormã jêt nare kam, Marij mã harẽ. ");
INSERT INTO ram_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ne ita jirô pê mã ri ahna putwrỳ pyxit, mã cute me ipijacri xà to hamre xà jõ amcro kam hàhhuc. Mã caxuaw ma Krĩpinkrên wỳr me ihkrare ata to me mõ, Pahpãm to cute me amji kam hapac xà jũrkwa wỳr. Ne me to cator, ne cute Pahpãm mã me ihkrare xũmre ata pẽr ne me cumã: ― Atea ri me imã me ikra ita jõr, ne cupê atekjêa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ampo na ri cute me to hajỹr? Pê rỳ pêa mã Pahpãm Mojxe xwỳ kôt Juta catêjê mã harkwa ta, ne me cumã: “Mam me akra xũmre me hapôj atajê cunea pê itekjê” hane. Pê Pahpãm jarkwa na mehhôc catêjê me ita pa, ne ahna mehhôc pa. ");
INSERT INTO ram_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mã cute me Pahpãm mã me ihkra pẽr, ne harkwa kôt me ipijacri xà to me hamre xà caxuw, cute me Pahpãm mã tutti into to me ipijakrut ne me hõr. ");
INSERT INTO ram_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ỹhỹ, pê Krĩpinkrên kam hũmre japrỳ te Ximãw ita ihkrĩ. Ne ampeaj kam impej, ne ihtỳj ajco Pahpãm kampa, ne to amji mã ihhimpej. Ne ajco Pahpãm te Juta catêjê kên tête me to pôj xà jõ amcro ata jikaj. ");
INSERT INTO ram_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mã Pahpãm Carõ Pejti apu Ximãw cahê na mõ, ne pê ramã Ximãw mã ihtyc xà nare to awjahkre ne cumã: ― Ca ha xaa, por pê Pahpãm Juta catêjê mã mehkên pê me to hapôj catê to awjahkre ata pupu, jirô pê ca ha cormã ty ― hane. ");
INSERT INTO ram_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ne Pahpãm Carõ Pejti te Ximãw japrôr ne ma to mõ, Pahpãm to me amji kam hapac xà jũrkwa wỳr. Mã Joje me Marij hanea ne ma curi me ihkra pê Jeju to me mõ, cute me Pahpãm jarkwa kôt me ipijacri xà to me hamre xà wỳr, ata wỳr. ");
INSERT INTO ram_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Mã Ximãw te me hõmpun, ne ihpa kam ihkrare ita pỳn, ne Pahpãm mã harẽn pejti, ne cumã: ");
INSERT INTO ram_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Hamre, ijõ Pahhiti, pê ca ito gũjahkre xà ata ramã kaam hàhhuc. Ne pê ca ito gũjahkre xà ata na ate ton, wa ite hõmpun. Ne atea ca me iwỳr me ikên pê me ito hapôj catê ita kujahêc, wa ite ito jĩa to hõmpun. Ỹhỹ, ipê amã ijàpên catê, ne hamre, ramã iwej, ne icaxwãm pê icarĩcti, ne gapacta ne ityc na ito tojnõ, wa ty. ");
INSERT INTO ram_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","33","Ne ca ate mehcunea kam mare mã me ikên catia pê me ipytàr catê ita me iwỳr ihkujahêc. Na quê ha pjê kam mehcunea mehkrĩ atajê mã hàhcujro catê na ipa. Ne quê ha me cumã mempejti to hahkre, quê ha mehcahkrit atajê, por me cupê Ixaher catêjê nare atajê mã hanea ne ato ajpẽ, mãr quê me hanea ne me gahkre pej. Ne quê ha hanea ne me akwỳ pê Juta catêjê pê Ixaher catêjê mã impejti ne. Quê ha mehcunea me akwỳ jarẽn pejti to me harẽ” hajỹr. Mã inxi me hũm te Ximãw te ihkra to ihcakôc xà ata na mempar, ne to amji mã me ipikrar. ");
INSERT INTO ram_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mã Ximãw te mehcajrẽn, ne Marij pê Jeju menxi mã: ― Pahpãm te akrare incrire ita capi. Ne quê ha akra ita Juta catêjê jõ pjê kam me hàhtôa to hõkre nõ, ne me to hamre, ne hanea ne me hàhtôa kwỳ to ihkà, ne me to impejti ne, ne ma mehkên pê me to hapôj. Ne Pahpãm te ri akra ita kujahêc, mãr quê me cumã Pahpãm cawpa. Ne quê ha me hàhtôa ne ahna amehcakôc kên, ne ame curê. ");
INSERT INTO ram_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ita kôt quê ha me hàhtôa mã cute amji kam hapac xà pẽ. Pom amji caxwãm pê cute me amji kam hapac xà to me ipimxur to ipa prãmti atajê to, quê ha mehkwỳ mã ajpẽ. Ne ca, quê ha amã apec xà catia to cati, ne ajkam gapac xà hyre nare. Quê ha amã hà pê ihhêj rũm wapo xwahhihti te ana cuhkõnre jitep, ne hà. Hõhõ, ita na quê ha ana cuhkõnre kam amã hà ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ỹhỹ, pê hanea ne curi cahãj wejti japrỳ te Anakwỳj ita apu ipa. Ne Pahpãm to me amji kam hapac xà jũrkwa kam apu ipa. Ne cupê Paner xwỳ kra, ne cupê menquêtti Axer xwỳ tàmxwỳ tàmxwỳ nõ. Pê hikwa tuw ne ahna caku xet, pê cupê impjên ihhi. Hamre, pê apu increcrer ipa, ne cormã ahnaa apu ipa, pê ramã ahna caku ôjtẽnta ne ihkôt cute cwat, ne ramã ihwejtu. Ne pê cupê Pahpãm jarkwa to me cumã ihcakôc catê, ne rỳ jũ caxuw Pahpãm to me amji kam hapac xà jũrkwa pê cator nare. Ne amcro me, caxwa me, pyt cunea kam ipijacri to ipa. Ne ajco ipijacri kam, Pahpãm to amji kampa ne cumã ihcakôc to ipa. ");
INSERT INTO ram_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mã Ximãw cormã apu Marij mã ihcakôac kam, mã me hỹrmã Anakwỳj ata cator, ne cute mehkra ata pupun, ne Pahpãm mã hũrên hakryti na amji jarẽn pyrentu. Ne ihtỳj cute, por Krĩpinkrên kam mehkrĩ ne me Pahpãm te mehkên tête me to pôj catê to me cumã hũjahkre, mã me hikaj atajê mã, harẽn kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mã hamre, Joje me Marij te me Pahpãm te amji kam hapac xà cunea ton partu, ne ma ihkra me, cute me hũrkwa wỳr me amji jaxàr, Hĩpôjajo jõ pjê wỳr, Naxare jõ krĩ kam. ");
INSERT INTO ram_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mã ihkra ita ihkà to mõ, ne carôt tỳj to mõ. Ne ampeaj kam cute amji jahkre pej cati. Mã Pahpãm te to impejti. ");
INSERT INTO ram_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ỹhỹ, pê caku cunea kam Jeju hũm me inxi ajco Krĩpinkrên wỳr me ipa, me Hakren xà jõ amji kĩn wỳr. Ne me hõ amji kĩn ita pê, por pê Pahpãm Ejit jõ pjê pê mam menquêtjê to cato ata. ");
INSERT INTO ram_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mã hamre, ramã Jeju na caku te tôxi, mã hanea ne mehkôt amji kĩn ata wỳr mõ, ne cator. ");
INSERT INTO ram_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ne ramã amji kĩn jamre jirô pê, cute me amji jaxàr, me hũrkwa wỳr. Mã xãmte aracri Krĩpinkrên kam Jeju jàhhuc. Mã nee hũm me inxi te hàhhuc xà ita na me hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ne ihtỳj me hàhtôti atajê kôt cute amji jaxàr na amehcãmjĩ. Ne ihtỳj cute me mõr to pyt, ne cormã ne, nee me hapên nare, ne ma me hũkjê me, me hõ ihkwỳ nõ catêjê kôt ame hapê. ");
INSERT INTO ram_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ne nee cute me cumã cator nare, na ri ma cute me amji jaxàr, Krĩpinkrên wỳr, cute curi me hapên prãmte. ");
INSERT INTO ram_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ne me ahna amcro incrê jirô pê mã ri cute me Jeju cajpar, Pahpãm to me amji kam hapac xà jũrkwa kam. Mã Jeju ihtỳj me cumã ampo to hahkre catêjê jipôc ri jỹ, ne ame kampa, ne amehcukij. ");
INSERT INTO ram_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mã mehcunea te Jeju te amji jahkre pejti to me cumã ihcakôc atajê to amji mã me ipikrar. ");
INSERT INTO ram_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mã inxi me hũm te me hõmpun, mã inxi cumã: ― Ikra, ampo na mã ate me ito hajỹr? Ate me ijigẽc hyr, na wa apãm me apu gapên to mõ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mã Jeju me cumã: ― Ampo na mã ca ame ijapê? Pom wa ita ri Inxũ Cati to me amji kam hapac xà jũrkwa kam jỹ, ne hàpên xà to apu cumã apê ita? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mã nee hũm me inxi te me hũjarẽn xà ita kam hapac, ne kam me amji jahkre pej nare, ne me cupê hahkre kêatre. ");
INSERT INTO ram_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mã ma Jeju te mehkôt amji jaxàr, Naxare jõ krĩ wỳr. Ne pê ihtỳj ajco hũm me inxi kampa. Na pê inxi ihtỳj ampo itajê cunea to amji japackre to ipa. ");
INSERT INTO ram_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pê Jeju hĩ to ipicamẽn to mõ, ne ajco ihkà to mõ, ne hanea ne ihkrã kre te amji jahkre pej to amji kà to mõ. Ne pê mehcunea mã ihkĩn, ne hanea ne côjkwa kam Pahpãm jỹ ita mã ihkĩn. ");
INSERT INTO ram_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ỹhỹ, caku jàhtôa jirô pê, pê Tiperij ata pê Roman catêjê jõ pahhiti, ne pê ramã ahna caku quĩxi, pê hanea ne Juta jõ pjê kam Pirat pê pahhi. Pê hanea ne Hĩpôjajo jõ pjê kam Heroti pê pahhi. Pê hanea ne Heroti tõ pê Pirip pê Iturij jõ pjê me Taconiti jõ pjê kam pahhi, ne Rixin pê Apirẽn jõ pjê jõ pahhi. ");
INSERT INTO ram_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pê hanea ne Anati me Cajpa pê me Pahpãm mã cute mehcajrẽn catêjê kwỳ jõ pahhi. ");
INSERT INTO ram_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ỹhỹ, pê cormã Jowãw pê Xacarij kra ata, ahkêt kam ihkrĩ, põti kam me hamreare ata ri. Pê amcro ata na, Pahpãm Jowãw mã harkwa ta, quê Côpijapjêr jõ cô kôt cute me ihcajpar atajê mã harkwa jarẽ. Pê Pahpãm jarkwa kôt harẽn to hane he, ne me cumã: ― Me akên mã hikra, ne amji tête me ate amji kam me gapac xà kên jũrê, wa ha ahna cute me gahkre pej xà na cô kam me acumrã, quê ha Pahpãm me akên to hapac kêt, ne to tojnõ ne me amã to impej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","5","Ne pê hanea ne Jowãw me cumã Ixaj xwỳ pê Pahpãm jarkwa na ihcakôc catê ata jõ kàhhôc cahyt. Ne me cumã cahyt to hane he: “Ỹhỹ, põti kam me hamreare ata ri jũm apu caràr to mõ, ne apu hũjarẽn to hane he: ‘Pom ca me pry kên to impej prãm ne atỳj me hituw cunea to me hipu pa, ne me hakôt cunea pên pa, ne pry jikôtti atajê, ca ha hanea ne me to ihcuhtac pa, ne pry kên kam kre atajê, ca ha me to impej ne me to increcrer pa. Ita jĩkjê na, ca ha me ate amji kam me gapac xà kên to mempej, ne intête me ampo kên cunea to pôj pa. ");
INSERT INTO ram_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Quê ha mehcunea Pahpãm te me akên pê me ato hapôj xà ita na, me gahkre pej’ ” hane. ");
INSERT INTO ram_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","8","Mã hamre, me hàhtôa ne cute me Jowãw cajpar, cute cô kam mehcumrãr prãmte. Ne cute mehcunea mã harẽn to hajỹr he: ― Ỹhỹ, me apê cagã kên kra kwỳ pyràac! Mã ihhêj ne jũm te me amã ite cô kam me acumrãr xà na ijarẽn. Wa xwahna ite me acumrãr xà ita kôt, ca ha xwahna Pahpãm te ame ato kên xà ata pê me acato. Hamreare, cute ahna hajỹr xà nare! Ca ha xa me akên ton jicu, jirô pê mã wa ha cormã cô kam me acumrã. Ne me apê pĩxô pàr kam hô impej nare ata pyràac, ne ca ha xaa me amji kampa, ne me apej wỳr me apkjê, ne me kam mare mã me akên jicu, ne atỳj me akên pê me acato. Hõhõ, quêt cute hajỹr. Ne nee ca me amji mã: “Aprãw pê me panquêtti, incwỳrjapê ri hũne mã me papê Pahpãm na mehkwỳ, ne jũ wỳr quê Pahpãm mehkwỳa nõ to kên” hajỹr nare. Ampeaj kam wa me amã awjarẽ. Nãmri nee Pahpãm me ana prãm nare, he quê tee me apê Aprãw tàmxwỳ tàmxwỳ cakrô, quê ihtỳj ame ato kêanre ne. Quê Pahpãm Aprãw tàmxwỳ tàmxwỳ na prãm na mã, quê ha ramã kẽn apu krĩ itajê nõa to Aprãw tàmxwỳ na mehkwỳ. Cwỳrjapê ca nee me amji mã hajỹr nare. ");
INSERT INTO ram_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","― Ỹhỹ, he me apê pĩxô xỳhti atajê pàr pyràac. Co he! He ramã ihhêj ne wakỳ te harê jakep xà ata na hàhtêp. Ne pĩxô pàr kêanre atajê cunea kam hô impej nare atajê, quê ha hitep ne cuhy kam me haxwỳ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mã cute me Jowãw cukij, ne me cumã: ― Mẽr hõhõ, ampo to wa ha ajte me? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mã Jowãw me cumã: ― Me anõ mã hitô kà pijakrut ata, ca ha jũm pê hamreare ata mã ihnõ. Ne hanea ne me anõ mã gõ ata, ca ha me cupê hamreare atajê mã to ajcokjê ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mã hanea ne pahhi mã me hũhkra kam me hàmcwỳr catêjê cator, ne cute me Jowãw cukij, ne me cumã: ― Hàpà, me to ihhimpej catê, ne me pa, ampo to wa ha me? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mã Jowãw me cumã: ― Ca ha nee gõ pahhi jarkwa jirôa pê me hũhkra kam me gàmcwỳr nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mã hanea ne krãhtare kwỳ cator, ne cute mehcukij, ne me cumã: ― Ne me pa, ampo to wa ha me? ― hajỹr. Mã Jowãw me cumã: ― Hã, ca ha me hane he, ca ha nee me gàprêa kam me cupê ihpore to pôj nare. Ne nee ca ha mehcukij catê cuna mã jũm to ame ahêj nare. Ne ca ha me gàmcwỳr xà ata pyrên me gakry ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mã mehcunea ramã me Pahpãm te jũm catihti impejti ata kujahêc prãm ata jikaj, na ri ihtỳj ame Jowãw cãmjĩ, ne me amji mã: ― Pỳhàpà, côt mã pê Jowãw ita to Pahpãm awjahkre? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mã Jowãw mehcunea mã amji jarẽ ne me cumã: ― Hamreare, quê ha cormã jũm ita cato, ne jũm ata ri ijirôa pê cati, ne ihkĩnte icrire. Jũ wỳr wa icrire ita kam cupê hõ par kà to pôj. Ỹhỹ, wa ha cô cakrô to me acumrã, quê ha cormã jũm catihti cato ata, quê ha quêt cormã Pahpãm Carõ Pejti me, cuhy kam me acumrã. ");
INSERT INTO ram_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Co he, nãmri me apê arỳjhy pyràac. Na quê ha ihtỳj ajpẽn pê me ato haprã. He ihhêj ne ramã hũhkra kam cumã crat cute kam arỳjhy ata carêr xà caxuw. Quê ha kam ihcarê, ne ihhy caxwỳn to cuprõ, ne huwahi, ne ihkrekà to cuprõ ne cuhy kam haxwỳ, quê ha to capa. Ne cuhy te to caxàr xà ata, quê ha jũ caxuw ihtyc nare. Ne quê ha ihtỳj me ato hane ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hõhõ, pê Jowãw hane, ne ajco me hapackre ne me cumã awjarẽ. Ne me cumã hũjarẽn xà itajê jàhtôa to hàhtô, pê ajco me cumã harẽ. Ne ajco me cumã mehkên pê me hapôj xà to hahkre. ");
INSERT INTO ram_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ỹhỹ, pê hanea ne Jowãw pjê jõ pahhi pê Heroti ita mãn kêanre. Ampo na? Pê Heroti ihkên ton to hàhtôa, ne ihtõ pê hĩxi capa, ne cume hikwa, cwỳrjapê pê Jowãw cumãn to kêanre. ");
INSERT INTO ram_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pê hamre ita cwỳrjapê Heroti mam cute to kên xà ata jirôa pê to kên, ne Jowãw na harkwa ta, pê me Jowãw pro, ne me hacjên xà mã me haxà. ");
INSERT INTO ram_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ỹhỹ, cormã cute me Jowãw jaxàr nare kam ri mehcunea mã awjarẽ, ne cô kam me cumrã. Mã hanea ne Jeju hỹrmã cator, mã Jowãw te cô kam ihcumrãr. Mã cute ihcumrãr xà ata ri xa, ne Pahpãm mã ihcakôc. ");
INSERT INTO ram_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mã hamre, côjkwa te amji jihê mẽn, mã Pahpãm Carõ Pejti te tutti na amji ton, ne cupê tuttia pyràc, ne ajpên ahpar mã tẽ, ne Jeju na hãm. Mã hamre, côjkwa rũm Pahpãm Jeju mã ihcakôc, ne cumã cupê Hũm Cati na amji jarẽn to: ― Ỹhỹ, apê ikraa to ikra, ne apê ikra impeaj to impej ata, ne imã akĩnti, ne apyrên ijakryti ― hane. ");
INSERT INTO ram_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ỹhỹ, pê ramã Jeju na caku trĩnta pê hàpên xà kam to tẽ, ne Joje kôt Jeju mã menquêtjê japrỳ te hajỹr he, ne ahpỹanre na mehkra itajê japrỳ partu. Pê mehcunea ihtỳj Jeju pê Joje kra na amehcãmjĩ. Ỹhỹ, pê Joje pê Eri kra, ");
INSERT INTO ram_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ne Eri pê Matat kra, pê Rewi kra, pê pahhi Merqui kra, pê Jana kra, pê Joje kra, ");
INSERT INTO ram_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","pê Matatij kra, pê Amoti kra, pê Nahũm kra, pê Eti kra, pê Naca kra, ");
INSERT INTO ram_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","pê Mate kra, pê Matatij kra, pê Xemi kra, pê Joje kra, pê Juta kra, ");
INSERT INTO ram_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","pê Jowanakwỳj kra, pê Rexa kra, pê Xoropapew kra, pê Xarati kra, pê Neri kra, ");
INSERT INTO ram_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","pê Pahhi Merqui kra, pê Ati kra, pê Coxam kra, pê Ermatãw kra, pê Er kra, ");
INSERT INTO ram_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","pê Jojuw kra, pê Erixê kra, pê Jorim kra, pê Matat kra, pê Rewi kra, ");
INSERT INTO ram_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","pê Ximãw kra, pê Juta kra, pê Joje kra, pê Jonã kra, pê Eriquim kra, ");
INSERT INTO ram_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","pê Merej kra, pê Mena kra, pê Matat kra, pê Natã kra, pê Tawi kra, ");
INSERT INTO ram_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","pê Jexê kra, pê Opet kra, pê Powa kra, pê Xara kra, pê Naxon kra, ");
INSERT INTO ram_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","pê Aminati kra, pê Atmin kra, pê Arni kra, pê Exom kra, pê Pere kra, pê Juta kra, ");
INSERT INTO ram_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","pê Jaco kra, pê Ixac kra, pê Aprãw kra, pê Tera kra, pê Naco kra, ");
INSERT INTO ram_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","pê Xeruque kra, pê Racaw kra, pê Parec kra, pê Epew kra, pê Xara kra, ");
INSERT INTO ram_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","pê Cana kra, pê Arpaxat kra, pê Xẽm kra, pê Nowe kra, pê Ramec kra, ");
INSERT INTO ram_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","pê Matuxarem kra, pê Enoc kra, pê Jaret kra, pê Marer kra, pê Cana kra, ");
INSERT INTO ram_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","pê Enotti kra, pê Xet kra, pê Atãw kra, pê Pahpãm kra. Hõhõ, Joje quêtjê itajê pê me haprỳ itajê hane. ");
INSERT INTO ram_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mã hamre, Pahpãm Carõ Pejti te Jeju mã amji jõr, ne to ihhimpej, mã ma cute Côpijapjêr jõ cô pĩn amji jaxàr, ne põ kam me hamreare ata wỳr mõ. Ne Pahpãm Carõ Pejti pê põ mã Jeju to mõ, Xatanaj te ihcajpẽr prãmte. ");
INSERT INTO ram_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne pom Xatanaj pê me pahcurê xwỳn ita pê Jeju to kên prãm. Mã ramã Jeju te hàpàn nare na amji to amcro to cwarẽnta, jirô pê mã ramã cumã prãam to prãm. ");
INSERT INTO ram_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mã hỹrmã me pahcurê xwỳn cator, ne cute capi. Ne cute Jeju kên mã mẽn prãmte cumã: ― Quê ha ampeaj kam apê côjkwa kam Apãm Cati ihkrĩ ita kra na, ca ha atỳj kẽn itajê mã, quê amã pãw na amji to, ca ha krẽ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mã Jeju cumã: ― Jũ wỳr wa akampa ne ita to hane. Ampo na? Inxũ Cati jarkwa na, hõ kàhhôc kam harẽn te hajỹr he: “Ỹhỹ, ca ha atỳj me apà, ne nee me gõ to pit mã me amji japackre nare. Jũ wỳr quê jũm hõ pit to amji to ajpa” hajỹr. Hõ, cute harẽn to hajỹr, cwỳrjapê wa ha nee akôt amji kam ijapac nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mã me pahcurê xwỳn te Jeju japrôr, ne ma kẽn kàhti ata na to hàpir. Ne cute cumã pjê cunea kam, krĩ cunea jahkre, ne cumã: ");
INSERT INTO ram_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","― Pjê itajê cunea itekjê pit, ne wa itỳj jũm mã cugõ. Na ca ha xa icuna mã akõn krã na jỹ ne ipejti na ijarẽ, wa ha amã ampo pejti itajê cunea gõ. ");
INSERT INTO ram_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ca ha ate ito hajỹr na, wa ha amã pjê ita kam krĩ itajê cunea jahkre, ca ha ihcunea to ahimpej to apa, quê ha cupê atekjêa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mã Jeju Xatanaj mã: ― Jũ wỳr wa ha ato hane. Ampo na? Inxũ Cati jarkwa jõ kàhhôc kam harẽn te hajỹr he: “Ca ha apu Pahpãm pit kĩn, ne amji mã taa pit cupa, ne impejti na me harẽ, ne to pit mã me amji kampa, ne cumã me apê” hajỹr. Hõ, cute harẽn to hajỹr, cwỳrjapê wa ha nee akôt amji kam ijapac nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jirô pê mã ri me pahcurê xwỳn te Jeju japrôr ne ma Krĩpinkrên wỳr to mõ, ne me kam mare mã, kỳaj pê Pahpãm to me amji kam hapac xà jũrkwa cwỳrpê hãm, ne cumã: ― Krãa caxi, quê ha ampeaj kam apê côjkwa kam Apãm Cati ata kra na, ca ha ita ri ahpar mã amũ amji to awcapê, ne nee atyc nare. ");
INSERT INTO ram_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Ampo na? Apãm Cati jarkwa jõ kàhhôc kam, cute ihkra jarẽn to hajỹr he: “Quê ha côjkwa kam ijarkwa to memprar catêjê ikra jamãr to mõ, ne ma me hũhkra to ihpỳm cupate me to huphê to ipa, mãr quê nee kẽn nõ ihpar tõc nare” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mã Jeju cumã: ― Jũ wỳr wa ha hane. Ampo na? Inxũ Cati jarkwa jõ kàhhôc kam harẽn te hajỹr he: “Ca ha nee gõ Pahhiti cajpẽr nare, ne nee Apãm Cati capi nare” hajỹr. Hõ, cute harẽn to hajỹr, cwỳrjapê wa ha nee akôt amji kam ijapac nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pê me pahcurê xwỳn pê Xatanaj tee apu Jeju to hahkre, ne apu ihcajpẽr pa jirô pê mã, ma cure ne tẽ, ne quê ha ihtỳj jũ caxuw hipêr capi. ");
INSERT INTO ram_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pê Pahpãm Carõ Pejti Hĩpôjajo jõ pjê wỳr hacpỹa mã Jeju to amji jaxà. Pê Jeju jarẽn pjê ita cunea kôt apu ihcahkũm. ");
INSERT INTO ram_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pê Juta catêjê te cuprõn xà jũrkwa kam ajco me cumã ampo to hahkre. Pê mehcunea ajpẽn mã me Jeju jarẽn to: ― Ampeaj kam Jeju te amji kam hapac xà ita pej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pê Jeju ma Naxare jõ krĩ wỳr mõ, por pê curi ihkà ata ri. Ne mehkôt xà jõ amcro kam, ma Juta catêjê te cuprõn xà jũrkwa wỳr mõ. Ampo na? Pê ramã ita ton to amji pyràc na pê mõ, ne axà ne jỹ. Ne cute Pahpãm jarkwa jõ kàhhôc cahyt prãmte hãm. ");
INSERT INTO ram_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mã cute me cumã, por Pahpãm jarkwa to ihcakôc catê ata pê Ixaj xwỳ jõ kàhhôc jõr. Mã cute ihkàhhôc ita capô, ne por kam ihhôc te hajỹr ata mã cator ne me cumã cahyt to: ");
INSERT INTO ram_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ỹhỹ, Pahpãm Carõ Pejti icahê na ipa, ne cute icapi, mãr wa me cupê hamreare atajê cunea mã Pahpãm jũjarẽn xà impejti itajê jarẽ. Ne me hacjên xà kam mehkrĩ atajê japôj, quê ha amjia kôt põ pê ame ipa. Ne mento tũm atajê mã mento to impej, quê me rĩt. Ne mehkwỳa te ame to kêanre atajê tehcajpa, quê cute ame to kên itajê pê me cato. ");
INSERT INTO ram_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wa ha itỳj me cumã ijũjarẽn xà impejti itajê to awjarẽ. Ampo na? He caku ita kam quê ha me pajõ Pahhiti mehkwỳ tehcajpa” hane. ");
INSERT INTO ram_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ne Jeju te cahyt jicu, ne hacpỹa mã ihkàhhôc ita krã ne hacpỹa ne hamãr catê mã hõr, ne hỹr. Mã cuprõn xà kam me jỹ atajê cunea ampeaj kam me Jeju pupu. ");
INSERT INTO ram_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mã Jeju te me cumã harẽn kam ihtẽm, ne harẽn to: ― Ỹhỹ, me ikampa. Pom ite ita kam ihkàhhôc cahyt ita, Pahpãm te ita kam amji jarkwa kôt ton ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mã mehcunea te amji mã me ipikrar ne me amji mã: ― Pỳhàpà, ampeaj kam hũjarẽn xà ita pej, ne Jeju pê hũmre impej. He cupê Joje kra cakrô, ahnaa hũjarẽn xà itajê impej ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mã Jeju me cumã: ― Mõrmõ ca me imã: “Por hà caprãr catê ata ihtỳj mehcunea caprã, ne quê ha jũ caxuw hà, quê ha ihtỳj hanea ne taa amji caprã. Ata cuxà ca ha ita ri, gõ pjêa kam me akwỳ mã ampo pihhoti to, quê me hõmpu. Por ate amji jahkre pejti kôt ramã Capernam jõ krĩ kam ampo ton, wa ite ahna me garẽn par, ata cuxà” hane. Hõhõ, mõrmõ ca me imã garkwa to hane. ");
INSERT INTO ram_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","― Ne ampeaj kam wa ha me acunea mã amji jarẽ. He ihtỳj pjê cunea kam Pahpãm jarkwa to mehcakôc catêjê na me amji to pôj, mã ajte mehkĩnte, hõ krĩa kam mehkwỳa mã nee ahna me amji caxàr prãm nare. ");
INSERT INTO ram_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Me ikam gapac to impeaj ne he. Ampeaj kam pê Erij jõ amcro ata kam, Juta jõ pjê kam me cahãj pijapit wej atajê me hàhtô. Pê hanea ne nee ta iwrỳc nare to caku to incrê ne ihkôt hĩkjê jirô pê mã, pê pjê ata kam prãm catia cato. Pê nee Pahpãm mempijapit wej cunea tehcajpar na Erij mẽn nare. Ne por pê Xarep jõ krĩ me, Teppro jõ krĩ kam ihkrĩ ata, pyxit peaj ne ihtehcajpar na Pahpãm cumẽ. ");
INSERT INTO ram_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne pê hanea ne Erixêw xwỳ jõ amcro kam, Juta jõ pjê kam, mehkà xêtti atajê jàhtôa ne ame ipa. Pê Erixêw nee mehkwỳ cunea caprãr nare. Pê hũmre nõ japrỳ te Namã xwỳ ata pyxit peaj ne ihkà xêtti, ne Xiri jõ pjê catêjê ata rũm cato. Pê Erixêw pyxit peaj ne caprã, pê impej. Ata cuxà wa ha nee ita ri, ijõ krĩa kam ampo pej catia ton nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mã cute me cuprõn xà kam me jỹ atajê cunea te Jeju cakôc xà na mempar, ne ame kam incryc. ");
INSERT INTO ram_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Ne me hãm, ne cute me Jeju pro, ne põ mã me cupjê. Ne krĩ pê, põ mã me to cator, ne krĩ cahê na hàpkàjti ata wỳr me cupjê, cute ahna me mẽn, mã ihpỳm ne ihtyc prãmte. Mã me hàhtôa jipôc ri me hũhkra pê cator, ne ma jũ kam tẽ. ");
INSERT INTO ram_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mã ma Jeju Hĩpôjajo jõ pjê ata kam, Capernam jõ krĩ ata wỳr mõ, ne cator ne ame cumã ampo to hahkre, mehkôt xà jõ amcro kam. ");
INSERT INTO ram_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne ampo to hahkre xà impejti to me cumã hahkre. Mã mehcunea te Jeju catia to cati na me to amji mã me ipikrar. Ne pê Jeju carôt tỳj, ne Pahhiti jarkwa kôt ipa, ne harkwa kôt ihcakôc. ");
INSERT INTO ram_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mã cute me cuprõn xà ata kam, hũmre nõ ata kam, me pahcurê xwỳn carõ kên nõ hĩ mã axà, ne caxwãm pê ihkrĩ, na pê cupê to ipijapar catê. ");
INSERT INTO ram_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Mã caràr, ne Jeju mã: ― Pỳhàpà, Jeju pê Naxare jõ krĩ kra ita, ampo wỳr mã ca ita ri mõ? Ampo to mã ca ha ita ri apu? Côt mã ca ita ri me ijipej prãmte mõ? Wa ite ramã apê côjkwa kam Apãm Cati kra, ne acati, ne apejti, mã Apãm Cati te rĩn wỳr akujahêc na, gahkre pej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mã Jeju cumã: ― Mẽr kêt! Ne hũmre ita pê acato! ― hane. Mã me kam mare mã me pahcurê xwỳn carõ kên ata te hũmre ita mẽn, mã pjê kam ihpỳm. Ne hamre, me pahcurê xwỳn carõ kên nõ ata te hũmre ata jaxôp nare kam cupê cator. Mã hũmre ata pej pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hamre, mã mehcunea te amji mã me ipikrar, ne me amji mã: ― Pỳhàpà, Jeju te amji jahkre peaj to amji jahkre pej, cama ihcakôc, mã hũmre ita pej pyrentu. Mõrmõ hũmre ita carôt catia to cati, ne ihtỳj cama hãn ne ihcakôc, mã me pahcurê xwỳn carõ kên ita hapôj pyrentu ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne Jeju jarẽn ita pjê cunea kam apu ipicràn. ");
INSERT INTO ram_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mã Jeju ma cute me cuprõn xà pê cator, ne hũmre nõ japrỳ te Ximãw ata jũrkwa wỳr mõ, mã hũpãn cacroa to cacro. Mã cute Jeju mã harẽn, ne me ahna hàhwỳr quê cahãj ita caprã. ");
INSERT INTO ram_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mã Jeju hỹrmã mõ, ne hikwa xà ata jĩkjê rũm xa, ne cute cacro ita mã harkwa cator ne cumã: ― Cahãj ita pê acator pyrentu! ― hajỹr. Mã cacro ita cupê cator pyrentu, mã cahãj ita xãm, ne cute me cumã harte kam ihtẽm pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ne ramã pyt xàr xàa kam, cute Hũm Cati carôt kôt hàpên xà pihho ton. Mã mehcunea Jeju wỳr me hà cunea na me to pra. Mã cute mehcunea na hũ xir, ne mehcunea caprãr. ");
INSERT INTO ram_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mã me pahcurê xwỳn carõ kên me hàhtôa pĩn hapôj, ne hãn ne me cupê hapôj xàa kam mã me caràr to: ― Apê côjkwa kam Apãm pejti kra ― hane. Pê me pahcurê xwỳn carõ mã Jeju pê Pahpãm kra na hahkre pej. Ne cumã Jeju pê Crixtô, por pê Pahpãm me cumã hũmre to awjahkre ata na hahkre pej. Cwỳrjapê ri Jeju te mehcakôc tête me cumã harkwa hyr, quê nee me to ihcakôc nare. ");
INSERT INTO ram_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mã apẽ, mã ma Jeju krĩ pê cator, ne põ kam me hamreare ata wỳr tẽ. Mã cute me huwahi prãmte, me hapên kam ihtẽm, ne cute me cumã cator. Ne ma ame huwahi, quê nee jũ kam ihtẽm nare, ne curia ame cahê na ipa. ");
INSERT INTO ram_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mã Jeju me cumã: ― Wa ha hanea ne krĩ nõ kam, Pahpãm te ampo cunea to ihhimpej xà na harẽn xà impejti to harẽn to mõ. Ne wa ite mehcunea mã ita jarẽn to ipa xà caxuw ri cute ikujahêc ― hane. ");
INSERT INTO ram_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne hũjarẽn xà ita kôt, cute Juta jõ pjê kam, cute me cuprõn xà cunea kam, me cumã Pahpãm jarẽn pejti jarẽn par. ");
INSERT INTO ram_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ỹhỹ, pê amcro nõ na Jeju Hĩpôjajo tohkà na xa, ne ampo to ame cumã hahkre. Pê me hàhtôa ne ahna me cuprõn tu, ne me hĩ to ajpẽn wỳr mehkujahêc to me mõ, cute me Pahpãm jarkwa par prãmte. ");
INSERT INTO ram_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pê Jeju pàr kre pijakrut caprỳ pupu, pê cô tohkà na ajêt. Pê ramã tep pro catêjê cupê me cato ne jũ ita ri ame hõ kryhti cuhhõn to mehcuhkwỳr. ");
INSERT INTO ram_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mã Jeju te Ximãw jõ pàr kre pupun ne cumã hàr, ne cute ahna hàhwỳr, quê pàr kre to ipicamẽn crire ne, cô tohkà pê. Mã to ipicamẽn. Mã pàr kre kam hỹr, ne cute me hàhtôti atajê mã ampo to hahkre kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ne cute ampo to me cumã hahkre partu, ne cute ihcakôc to ihhi, ne Ximãw mã: ― Ca ha côhtu wỳr me akwỳ me, me to pàr kre cakrỳ ne cô kam me gõ kryhti mẽ, ate me to tep nõ pro xà caxuw ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mã Ximãw cumã: ― Pahhi, ita kam, caxwa ita kam, ite me ijàpêan to me apẽ, ne nee ite me to tep ita nõ ihpro nare. Wa ha pijamã amcroa kam me to tep ita nõ mẽ? Wỳr wa ha me ihnõ mẽ! Cakrô ca ha caa me ikujate, wa ha itỳj me mõ, ne mũhũràn me ijõ kryhti mẽ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne cute harkwa kôt me ampo na mẽn xà atajê ton to hajỹr, ne me to tep jàhtôa na kryhti to me ipixêr, ne me to pro. Mã ampeaj kam hũtĩ, ne ajmãr cute ame cupê hõ kryhti cokjêr. ");
INSERT INTO ram_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mã cute mehkwỳ mã hũ to hàpêr, quê me hỹrmã pàr kre nõ to me tẽ, ne tep na me to ihtehcajpa. Mã ma hỹrmã me to tẽ. Mã tep jàhtôa to hàhtô, ne hũtĩ te ajmãr cô mã pàr kre ajwar to mrõr. ");
INSERT INTO ram_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mã Ximãw te ita pupun, ne Jeju cuna mã ihkõn krã na hỹr, ne cumã: ― Me ijõ Pahhi, imã acupa hyre nare. Ampo na? Acatia to acati ne akĩnte icrire, ne ikêanre ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ampo na ri cute cumã harkwa ton to hajỹr? Cute me tep jàhtôa ne me to pro na ri, ne cute to amji mã ame ipikrar crire nare. Mã mehkwỳ te me hajỹar, ne me to tep jàhtôa ne me to pro, na ri cute amji mã ame to ipikrar. ");
INSERT INTO ram_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mã Jeju Ximãw mã: ― Apu pa nare. Ita caxuw ca ha quêt mehĩ to pit mã cuprõn kam tẽ ― hane. Mã cute mempar. ");
INSERT INTO ram_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ne ma pàr kre atajê to me hàpir amcrà wỳr, ne ampo cunea to me tojnõ, ne ma Jeju kôt me pra. ");
INSERT INTO ram_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mã ma Jeju krĩ nõ wỳr mõ, ne curia apu ipa. Mã curi me hũmre kà xêtti nõ ita ihkrĩ. Ne cute Jeju pupun, ne pjê kam ihpỳm, ne cute pjê na ihkuc xir ne amji na cumã awjahkre, ne cumã: ― Pahhi, ca ha icaprãr prãm, ne atỳj icaprã ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mã Jeju te hũhkra curor ne ahna hir ne cumã: ― Ỹhỹ, imã acaprãr prãm, cwỳrjapê wa ite ramã acaprãr ― hajỹr. Mã hamre, ihkà xêt ita hũmre ita pê cator pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mã Jeju cumã: ― Ca ha nee mõ ne apu jũm mã ite acaprãr ita na ijarẽn to amõr nare, ne ma Pahpãm mã mehcajrẽn catê wỳr tẽ, ne cumã amji jarẽ, ne cumã amji to ajpẽ, quê apupu ne akôpĩr to impej. Jirô pê mã ca ha Pahpãm mã ampo gõ. Por pê Mojxe xwỳ ramã me panquêtjê mã Pahpãm mã ampo jõr xà na ihkàhhôc juwahi ata na, ca ha cumã ampo gõ. Jirô pê quê ha mehcunea ramã acaprãr ita na me gahkre pej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pê pjê ata cunea kôt Jeju te Hũm carôt kôt hàpên xà pihho ton xà jarẽn apu ihcahkũm. Pê me hàhtôa ne mehkrĩ atajê ajco Jeju wỳr me pra, cute mempar prãmte. Ne hanea ne me hà hỹrmã me pra, cute me caprãr prãmte. ");
INSERT INTO ram_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pê Jeju ma ajco põ mã hapôj, me hamreare ata wỳr, ne ahte ajco Hũm Cati mã ihcakôc. ");
INSERT INTO ram_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pê amcro nõ na Jeju ikre kam jỹ, ne ame cumã ampo to hahkre. Pê Parixêw catêjê me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê hanea curi me jỹ. Pê Hĩpôjajo jõ pjê me, Juta jõ pjê pĩn, krĩ cunea me hỹrmã cutor tu. Pê Pahpãm Jeju mã carôt to ihtỳj, ne cumã cute amji jahkre pejti gõ, cwỳrjapê ri ihtỳj me hà caprã. ");
INSERT INTO ram_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mã me hũmre cukrã xà peacre nõ pàrkwỳc kam nõ. Mã hũmre kwỳ pê me hõ kwỳ nõ atajê te me to cator, ne tee ame to hàr to hahkre, Jeju cuna mã cute me hir prãmte. Ne jũ wỳr quê harkwa na me to axà, cute me hipu tu, ne me hahêr tu ita kam. ");
INSERT INTO ram_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cwỳrjapê ri tee Jeju wỳr ame to hàr to hahkre. Ne ma me to hàpir, ikre jimoc na. Ne cute me kẽn po te ikre ton ata nõr par, ne me to ihkre, ne pàrcuxê to me hũmre nõr xà ata na hê, ne ma me to iwrỳc, me hàhtôti atajê jipôc ri, ne Jeju cuna mã me hir. ");
INSERT INTO ram_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mã Jeju te ampeaj kam, cute amji mã me Pahpãm to ihhimpej na me hõmpun, na ri cute hũmre cukrã xà peacre nõ ata mã: ― Ikwỳ nõ, wa ha ita kam ate Pahpãm to kên xà ita to tojnõ, ne nee hipêr to amji japackre nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mã hamre, Parixêw catêjê me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, me amji mã: ― Pỳhàpà, Jeju ita apu ihcakôc to kêanre. Ne ihtỳj Pahpãm to ihcakôc kêanre. Xà ajkĩ cupê Pahpãm, quê hũmre te ihkên ton xà ita to tojnõ? Pahpãm quê ha quêt ihtỳj jũm te ihkên ton xà nõ to tojnõ, ne me paxũmre nõ te ita ton xà nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mã Jeju te me hahkre pej pyrentu, cute amji kam me hapac xà ata na, ne me cumã: ― Pỳhàpà, ampo na mã ca ame amji cajpẽr xà ita to me acaxwãm pê ame amji cajpẽ? ");
INSERT INTO ram_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Ikam me gapac peaj ne he. Ipê me Ahàkà, wa itỳj jũm te Pahpãm to kên xà ata to tojnõ. He me ikampa, ne me ipupu, ne me ijahkre pej to impeaj ne. Harẽn xà jũ ri amji jirôa pê ihtỳj? Xà wa ha ajkĩ hà ita mã: “Ate Pahpãm to kên xà ita, wa ha to tojnõ?” nare, wa ha ajkĩ cumã: “To xa ne anõr xà py ne atẽm pyrentu?” hane. Harẽn xà itajê nõ ri amji jirôa pê ihtỳj? He pom harẽn xà te: “To xa ne tẽ” ata ri, ite harẽn xà nõ ata jirôa pê ihtỳj ita? Ne hamre, ita caxuw ca ha me ijahkre pej to impej, wa itỳj jũm te Pahpãm to kên xà ata to tojnõ ― hane. Ne cute cukrã xà peacre ata mã harkwa to: ― To xa ne anõr xà py, ne atẽm pyrentu, gũrkwa wỳr ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mã hà ita me kam mare mã hãm pyrentu, ne cute nõr xà pyr, ne ma hũrkwa wỳr tẽ. Ne ampeaj kam Pahpãm te cumã ampej pyrên hakryti na cumã amji jarẽn to tẽ. ");
INSERT INTO ram_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mã mehcunea te ita to amji mã me ipikrar, ne mehcunea mã hũpaa to hũpa. Mã cute me Pahpãm to amji kam hapac pyrentu, ne me amji mã: ― Pỳhàpà, rỳ jũ caxuw me pahnõ te ampo pejti itajê nõ pupun nare, ne ita kam mã rỳ pahte me hõmpun ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ita jirô pê mã ri ma Jeju cator, ne cute, por Rewi pê pjê jõ pahhi jarkwa na me hũhkra kam hàmcwỳr catêjê nõ ata pupun. Mã me hũhkra kam hàmcwỳr xà kam jỹ, mã Jeju te hõmpun ne cumã: ― Ajpên ikôt mõ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mã Rewi xãm ne cute ihcunea jicu, ne ma ihkôt mõ. ");
INSERT INTO ram_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne cute hũrkwa kam, Jeju mã amji kĩn catia ton. Mã pahhi mã me hũhkra kam me hàmcwỳr catêjê jàhtôa ne me cahê na me jỹ. Pê mehkwỳ hanea ne mehkrĩ. ");
INSERT INTO ram_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mã me cumã Mojxe caca xà to hahkre catêjê me, Parixêw catêjê te me amji kĩn ita pupun. Ne ame Jeju kôt me ipa catêjê kam mencryc, ne ame hũn, ne me cumã: ― Pỳhàpà, ampo na mã ca ame cahê na ame apà, ne ame ikõ? Pom me hàmcwỳr catêjê pê mehkrã kên catêjê ita? Pom hõtpê pahhi jarkwa jirôa pê ame hàmcwỳr to me ipa ita? Pom me cupê mehkên ton catêjê ita? Ampo na mã ca me cahê na ame hane? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mã Jeju Parixêw catêjê kwỳ mã: ― Ỹhỹ, me ikampa! Me capẽn catêjê me, mempej catêjê, nee mehcahhê catê na prãm nare. Ne me hà catêjê ri quêt ihtỳj mehcahhê catê na mehprãm. Na ri ita pê hũràc ne ipê mehcahhê catê pyràac. ");
INSERT INTO ram_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na wa ite mehkrã kên catêjê to impej prãam to wa ajpên mõ, mãr quê mehkên pê amji to me antuw, ne mempej. Wa nee mempej catêjê to impej to icator nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mã amcro nõ na jũmjê itajê Jeju wỳr pra, ne me cumã: ― Ỹhỹ, Jowãw kôt me ipa catêjê ihtỳj me ajcri to ame ipa, ne hõtpê me ipijacri to me ipa xà ata kam, ihtỳj Pahpãm mã mehcakôc to me ipa. Mã hanea ne Parixêw catêjê kôt me ipa catêjê ihtỳj me ajcri. Ne akôt me ipa catêjê, mã ajte nee mehkĩnte me ipijacri nare. Ne mẽr ampo na mã akôt me ipa catêjê nee itajê cuxà ame ipijacri to me ipa nare? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mã Jeju me cumã: ― Ỹhỹ, amji kĩn catia kam, quê ha pijamã jũm ipijacri to ipa? Jũ wỳr quê jũm amji kĩn kam hàpàn nare ne apu ipa. Quê ha ihtỳj mehcunea me hàpàn to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ne quê ha amji kĩn jõ pahhi ma jũ kam tẽ, quê ha amji kĩn hamre, jakàn pê quê ha ihtỳj me ipijacri to ame ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne hanea ne Jeju te me cumã, cute amji kam me hapac xà capô to impej partu, mãr quê me hahkre pej pej, ne me cumã: ― Ỹhỹ, jũ wỳr quê jũm cupẽhkà wej to impej prãmte, cupẽhkà tuw kwỳ jakep, ne ihwej ita na cuxô ne to ajpỳ. Quê ha to hane, quê ha intuw ita ihwej ita to kên nare ne hipô, jũ wỳr quê ha cupẽhkà wej ita intuw ita mã awcanã. ");
INSERT INTO ram_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne jũ wỳr quê ha jũm pryti kà te ampo cacô cjên xà wej ita kam ampo cacô tuw ru. Quê ha jũm te incjêj xà wej kam irun na, quê ha incjên xà wej ita ajcahte, quê ha ampo cacô ita acto. ");
INSERT INTO ram_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","39","Ne jũ wỳr quê jũm ampo itajê nõ to hane, ramã me pahcunea te me hahkre pej. Cu ha ampo cacô incjên xà intuw pit kam ame ampo cacô tuw ru. Pê mã nãm ampo cacô wej ata, ampo cacô tuw jirôa pê impej. Na ri jũ wỳr quê jũm ampo cacô tuw ita na prãm, cormã intuw na ri, ne quêt ampo cacô wej ata ri ramã impejtu ― hajỹr. Ita jĩkjê na mã, ramã cute me amji kam hapac xà tũm wej to me amji pyràc xà ata pit kĩn, nare, nee cumã to ipintuw prãm nare. ");
INSERT INTO ram_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ne amcro nõ na, mehkôt xà jõ amcroa kam, Jeju na mehkwỳ te pur nõ ita cajpuw me arỳjhy cahàc ata jakren to me mõ. Mã ihkôt me ipa catêjê te mehkẽhkẽn ne me caxwỳn kur kam me to ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mã Parixêw catêjê kwỳ te me hõmpun, ne me cumã: ― Ampo na mã ca ajte ame gàpên to me apa to hane? Ca ihhêj ne ate me pancaca xà kaj na, hirô pê me apỳm, ne ma ame pahkôt xà jõ amcro caca. Pom pê me panquêtti pê Mojxe xwỳ me pamã Pahpãm jarkwa jõ kàhhôc gõ ne hõ amcro ata juwahi ata kam, me gàpên xà ita na ihkaj na, me pahkôt xà jõ amcro kam ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mã Jeju me cumã: ― Nee ite Pahpãm jarkwa jirô pê me to ipỳm nare. Atea ca me hirô pê me to apỳm. Xà ate me panquêtti pê Tawi xwỳ jõ kàhhôc cahyt nare? Pê Tawi xwỳ me, mehkwỳ itajê mã prãm. ");
INSERT INTO ram_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pê me Pahpãm to me amji kam me hapac xà jũrkwa mã me axà. Pê curi Pahpãm mã hõ pyxwỳr xà na pãw pejti itajê hikwa. Ne por pãw hikwa atajê quê nee jũm pê Pahpãm mã mehcajrẽn catêjê nare ihnõ krẽr xà nare. Cakrô pê ihtỳj Tawi cucwa ne mehkwỳ atajê mã cugõ, pê me cukrẽ. ");
INSERT INTO ram_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","― Ỹhỹ, ipê me Ahàkà, na pê wa ixũmre na amji to. Na wa Pahhiti jarkwa kôt ipa, ne taa mã pê ite me pahkôt xà jõ amcro to ihimpej catê na ixãm ― hane. ");
INSERT INTO ram_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mã mehkôt xà jõ amcro nõ na, ma Jeju Juta catêjê te cuprõn xà mã hàr, ne cute me cumã ampo to hahkre kam ihtẽm. Pê hanea ne curi hũmre nõ awpôc rũm hũhkra kên ita jỹ. ");
INSERT INTO ram_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mã hanea ne Parixêw catêjê kwỳ me, me cumã Mojxe xwỳ caca xà to hahkre catêjê kwỳ curi amehkrĩ, ne ame Jeju pupu, ne ihtỳj amehkôpĩr to me ipa, cute ihkên mã me mẽn prãmte. Quê ihhêaj to Jeju mehkôt xà jõ amcro kam jũm caprã, quê ha hàhcaprãr xà ata kôt me to ihtỳj tu ne, cute mencaca xà jirô pê ihpỳm cwỳrjapê. ");
INSERT INTO ram_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pê Jeju ramã amji na cute me amji kam hapac xà ita na me hahkre pej partu cakrô, cute hũmre jũhkra kên ata mã: ― To xa, ne me hipôc ri ca xa ― hajỹr. Mã hũmre ata xãm, ne me hipôc ri xa. ");
INSERT INTO ram_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mã Jeju te, por ame hõmpu atajê cukij, ne me cumã: ― Ỹhỹ, me pahkôt xà jõ amcro kam, por ihkàhhôc kam me pancaca xà jõ amcro ata, ampo pê Mojxe xwỳ Pahpãm jarkwa kôt me pamã to hahkre? Xà cu ha pahtỳj amcro ita kam ame ampo pej to? Nare, xà cu ha me pahtỳj amcro ita kam ame ampo kên to? Xà cu ha pahtỳj amcro ita kam me jũm tehcajpa ne me to ihtyc xà jahpa? Nare, xà cu ha pahtỳj amcro ita kam me jũm cura? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne Jeju mehcunea kôt into to amji jacjê, ne cute hũmre jũhkra kên ita mã: ― Gũhkra curor ― hajỹr. Mã hamre, hũmre ita te hũhkra curor, ne hũhkra impej pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mã Parixêw catêjê kwỳ atajê ame Jeju kam mencryc, ne cute Jeju to amehkên na me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ne pê amcro atajê nõa kam Jeju kẽn na api, Pahpãm mã ihcakôc prãmte. Ne curia Pahpãm mã ihcakôc to apẽ. ");
INSERT INTO ram_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ne cute ihkôt me ipa catêjê mã hàkjêr, ne me to tôxi ne me to caprãr. Ne cute me tôxi atajê to ri cute amji mã harkwa na memprar catêjê. ");
INSERT INTO ram_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ne Jeju mã memprar catêjê japrỳ itajê pê Ximãw, por pê Jeju cumã haprỳ krut pê Petrô gõ ata me, Ximãw tõ pê Antre ata me, Tijac me, Jowãw me, Pirip me, Partômew me, Matew me, Tome me, Tijac pê Arpew kra me, Ximãw, por cumã hõ pjê kĩnti ata me, Juta pê Tijac kra me, Juta Carijot pê Jeju curê xwỳn ata me. ");
INSERT INTO ram_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne Jeju te kẽn pĩn mehcunea to iwrỳc, ne me to mõ, ne pjê impejti pipẽnti ata kam me to hàhhuc. Mã curi pjê cunea rũm cute me cuprõn, ne me hàhtôa ne ame ipa. Juta jõ pjê pĩn me cator, ne Krĩpinkrên pĩn me cator. Ne côxwa cahê na krĩ pijakrut pê Kẽn jõ krĩ me, Teppro jõ krĩ ata pĩn me cator. Ne krĩ jàhtôa pĩn cute me cuprõn. ");
INSERT INTO ram_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ampo na? Cute Jeju kam me hapac ne me amji caprãr prãmte me cuprõn. Mã Jeju ihtỳj ame caprãr to mõ. Ne ihtỳj cute me pahcurê xwỳn carõ kên atajê mã, me hĩ tête harkwa japôj to mõ. Mã mentête hapôj, mã amempej pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Cwỳrjapê ri mehcunea ame Jeju tàt to prãm. Ampo na? He ihtỳj Jeju jĩ pê Pahpãm carôt hapôj, ne mehcunea caprã. ");
INSERT INTO ram_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mã Jeju te ihkôt me ipa catêjê pupun, ne me cumã harkwa to: ― Ỹhỹ, me akwỳ pê ampo hamreare atajê, ame gakry! Ampo na? He me caa, ca ha quêt Pahhiti pê Pahpãm himpej xà ata kam ame akrĩ, na ca ha ame gakrya ne! ");
INSERT INTO ram_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","― Me akwỳ mã prãm atajê, ame gakry! Ampo na? He me caa, ca ha quêt me garte tu ne, na ca ha ame gakrya ne. Ne ca me akwỳ ame amrã atajê, me gakry! Ampo na? He me caa, ca ha me hirôa pê ame acxa, na ca ha ame gakrya ne. ");
INSERT INTO ram_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","― Ne ca me akwỳ ampo kêanre kam me amji pupu atajê, ame gakry! Ampo na? He ma ame acurê, ne ma ame acaca, ne ame axũn, ne akên na ame garẽn cakrô, Inxũ mã nee me akên nare. Ca ipê me Ahàkà kôt ame apa, ita cwỳrjapê ri ame ato hane, ne ame ato kêanre. ");
INSERT INTO ram_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ne cute ame ato kên jõ amcro itajêa kam, ca ha ame gakry! Gapacta ne me gakryte ame atoj. Ampo na? He quê ha jũ caxuw Pahpãm hahpan xà na, côjkwa kam me amã hàmjõr catia, ne me amã impejti gõ. Na ca ame gakrya ne! Ampo na? He me cupê menquêtjê pyràac, ne ihtỳj me ato kên to me ipa, pom pê mam menquêtjê ajco me Pahpãm to mehkên to me ipa ata na ri me ato he. ");
INSERT INTO ram_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","― Pỳj me hêj xi, me akwỳ pê me gakràj atajê, ca ha atỳj ame amrã! Ampo na? He amcro ita pyxit peaj kam ri me gakryti ita. Na ca ha atỳj ame amrã! ");
INSERT INTO ram_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","― Pỳj me hêj xi, me akwỳ mã ampo cunea atajê, ca ha atỳj ame amrã! Ampo na? Quê ha cormã jũ caxuw me amã prãm catia me awỳr cato, na ca ha atỳj ame amrã! ― Pỳj me hêj xi, me akwỳ ame acxa atajê, ca ha atỳj me apicxar jicu ne cama ame amrã! ");
INSERT INTO ram_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","― Pỳj me hêj xi, me akwỳ pê, pom mehcunea me apejti na ame garẽn catêjê atajê, ca ha me amrã! Ampo na? He me cupê menquêtjê pyràac. Pom pê mam menquêtjê ajco mehhêj xi catêjê pejti na ame harẽ, ata cuxà ri ihtỳj me apejti na me garẽn to me ipa. Na ca ha atỳj ame amrã! ");
INSERT INTO ram_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","― Ỹhỹ, ampeaj kam wa ha me amã Pahpãm jarkwa jarẽ. Ca ha me amã me acurê xwỳn kĩn. Ne ame acaca atajê, ca ha me to impeaj ne. ");
INSERT INTO ram_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","― Ca ha cute me acrôn atajê jahpan xà na, me to impejti to prãm, ne Pahpãm mã mehcajrẽn. Ne cute me ato kên atajê, ca ha Pahpãm mã mehcajrẽn, quê me to impeaj ne. ");
INSERT INTO ram_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","― Quê jũm apahàm prãmte akuc kam acakwĩ, ca ha hĩkjê to cumã apkjê, quê hanea ne kam cakwĩ. Ne quê jũm apê gitô kà capa, ca ha hanea ne akat kà caxàr na to tojnõ, quê amji mã capa ne to tẽ. ");
INSERT INTO ram_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","― Ne atỳj me cumã, por ampo na me awỳ atajê gõ. Ne quê jũm apê ampo capa, ca nee hacpỹ ne ahna gàhwỳr nare. ");
INSERT INTO ram_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","― Ne quê ha amã cute me ato amji kam hapac to impejti to prãm na, ca ha atỳj me to amji kam gapac to impejti to apa. ");
INSERT INTO ram_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","― Quê ha amã cute me acurê atajê kĩn na, quê ha Pahpãm ihtỳj ate mehkĩn jahpan xà na amã amgõ. Nee quê ate amji mã mehkĩnti atajê pit kĩn jahpan xà na, quê Pahpãm me amã hàmjõr nare. Quê ha amã cute me akĩn catêjê atajê pit kĩn na, ca ha me apê mehkên catêjê jõ ikwỳ nõ pyràac, ne me cuxà akêanre ne. ");
INSERT INTO ram_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","― Ca ha cute me ato kên atajê to impejti na, quê ha Pahpãm ihtỳj hahpan xà na me amã amgõ. Ne jũ wỳr quê ha Pahpãm ate, cute me ato impej catêjê pit to impejti jahpan xà na, me amã amgõ. Ca ha cute me ato impej catêjê pit to impejti na, ca ha me apê mehkên catêjê jõ ikwỳ nõ pyràac, ne me cuxà akêanre ne. ");
INSERT INTO ram_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","― Ca ha atỳj mehcunea mã ampo gõ, por ampo na me ahwỳ atajê, ca ha me cumã agõ. Ne nee hacpỹa ne cute me amã ampo jõr catêjê mã pit mã ame ampo jõr nare. Ca ha jũmjê te jũ caxuw hacpỹa ne amã ampo jõr nare atajê mã ampo jõr na, quê ha Pahpãm ihtỳj hahpan xà na me amã amgõ. Ne jũ wỳr quê ha Pahpãm hõtpê hacpỹa ne cute me amã ampo jõr atajê jahpan xà na me amã amgõ. Ca ha ate hajỹr na, ca ha me apê mehkên catêjê jõ ikwỳ nõ pyràac, ne me cuxà akêanre ne. ");
INSERT INTO ram_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","― Ne ca ha atỳj amã me acurê xwỳn catêjê kĩn, ca ha me to impej. Ne ampo cunea na me ahwỳ atajê, ca ha atỳj agõ, ne nee hacpỹa ne cute amã ampo jõr na amji mã to hajỹr nare. Ca ha me ate ite me amã ampo jarẽn itajê cunea to hajỹr na, quê ha Pahpãm hũrkwa kam, me acunea mã hàmjõr xà impejti to hàmjõr to catia, ca ha me to amcwa, ne ca ha apê Pahpãm me hirôa pê cati ata kra impeaj. Pahpãm mã mehcunea kĩn, ne hàhcajrẽn cati, ne ihtỳj cute me to kên catêjê caprĩ, ne ihtỳj cumã cute me ampo cwỳr atajê jahpan xà na me hakryti na me amji jarẽn nare atajê caprĩ. ");
INSERT INTO ram_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","― Na ca ha Pahpãm cuxà me gàhcajrẽnti ne, ne mehcunea caprĩ to me apa. Hõhõ, ita to ca ha me hajỹr to me apa. ");
INSERT INTO ram_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","― Ca ha ate nee ampo na amehpro rẽn nare na, quê ha Pahpãm me acuxà nee ame apro rẽn prãm nare. Ca ha nee ame curê mã me irẽn nare na, quê ha Pahpãm me acuxà nee me acurê mã me arẽn nare. Ca ha ate cute ame ato kên ita to tojnõ ne hicu na, quê ha ihtỳj Pahpãm me acuxà, ate me to kên ita to tojnõ ne hicu. ");
INSERT INTO ram_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","― Ca ha gõtpê me cumã ampo jõr to apa na, quê ha ihtỳj Pahpãm hõtpê me acuxà me amã ampo jõr to ipa. Ne ampeaj kam ca ha atỳj me amcwa. Quê ha Pahpãm me amã me acrat to hipu, ne to hipu tu ne, ne ampeaj kam quê ha me acrat kam me amã cucjê, ne kam me amã curua to curu. Ne pom ca ampo kam me akwỳ mã ampo to ajpẽn ata kam, quê ha Pahpãm hanea ne me amã ampo to ajpẽn ne cunõ. Ca ha jũm mã ampo crire ne agõ, quê ha Pahpãm ate ton xà ita na, acuxà hanea ne amã ampo crire ne cugõ. Nãmri ca ha ate jũm mã ampo catia ne hõr na, quê ha Pahpãm hanea ne acuxà amã ampo catia ne cugõ. ");
INSERT INTO ram_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","― Ỹhỹ, jũ wỳr quê jũm to tũm, amji kôt into tũam nõ to mõ. Quê ha mento tũam me ajpẽn to mõ, ne ajwar ihtỳj kre nõ mã mehpỳm. ");
INSERT INTO ram_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","― Ne por me cumã ampo to hahkre atajê ri cute ampo to hahkre catêjê japyre mã me. Na quê ha xa ampo to hahkre ne hahkre pej jirô pê, quê ha cormã cute cumã to hahkre catê ata me ajpẽan. ");
INSERT INTO ram_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","― Ca me akwỳ jirôa pê akên ton to me apa cakrô, ca atỳj me akwỳ te ampo kên kryjre ton atajê to me cumã acakôc to me apa. Ne ca ihhêj ne me akjêjê into kam me ahhi kryjre pupu, ne nee mehkĩnte amji toa kam pĩ kwỳcti ata pupun nare. ");
INSERT INTO ram_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne jũ mã ca me akjêjê mã harẽn to, ne ajte ne me cumã: “Ikjê, cama amji na ijamã, wa ato kam amã ahhi kryjre ita to pôj” hane. Ne mẽr ampo na ca caa, atoa kam amji mã pĩ kwỳcti ita caxàr nare? Ne ihcaprỳ na amji pej na ame amji jarẽn to me apa, ne mehkĩnte me akêanre. Ca ha mam me ato kam amji mã pĩ kwỳcti itajê to pôj, ne me arĩt pej, ne cormã me akjêjê into kam ahhi kryjre ita pupu, ne me cumã to pôj. ");
INSERT INTO ram_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","― Ỹhỹ, jũ wỳr ca ha pĩxô impejti pàr nõ intête, pĩxô kên nõ capa, ne jũ wỳr ca ha pĩxô kên pàr tête, pĩxô impejti nõ capa. ");
INSERT INTO ram_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ca ha ampo pĩxô pàr cahkrit nõ pupu, ne ramã hahkre pej pyrentu, xà pĩxô pàr ita ajkĩ impej, nare, mõrmõ ihkêanre. Ne jũ wỳr ca ha hômjĩ pàr kam ahkrỳt nõ ta, ne jũ wỳr ca ha ahkrô kam crowkwỳj xô nõ ta. ");
INSERT INTO ram_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jĩkjê na, jũm xũmre impejti ata hõtpê amji caxwãm pê cute amji kam hapac xà pĩn ampo pejti to hapôj, mã ihkĩnte jũm xũmre kên ata hõtpê amji caxwãm pê cute amji kam hapac xà pĩn ampo kên to hapôj. Ỹhỹ, ampeaj kam pahte amji kam me pajapac xà me, me pahcakôc xà te hipu, cu ihkôat me pahcakôc ― hane ");
INSERT INTO ram_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ne Jeju me cumã: ― Ampo na mã ca ame imã: “Me ijõ Pahhiti” hane, ne nee ijarkwa kôt ame apa nare? ");
INSERT INTO ram_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wa ha me amã ijũjarẽn xà ita jarẽ, mãr ca me amã ahna icaca xà jahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ỹhỹ, quê ha jũm te ijarkwa kam hapac ne ijarkwa kôt ipa na, quê ha cupê ihhêj rũm hũmre te pjê tỳjti kam ikre xãm ata pyràac. Mã cô te hipu, ne ma ikre wỳr cô tẽ, ne cute ikre ata cakwĩn, mã nee hàhcujrõn nare, ne hãm peaj na ihtỳj xa. ");
INSERT INTO ram_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mã ihkĩnte jũm te cama ijarkwa kam hapac, ne nee to amji japackre, ne ihkôt ipa nare, ata pê ihhêj rũm hũmre nõ te pjênxôm cràre kam ikre xãm pyràac. Mã cô te hipu ne ma ikre wỳr tẽ, ne cute ikre ata cakwĩn, mã ihpỳm pyrentu, ne ikre ata jamre ― hane. Hõ, pê Jeju hũjarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mã Jeju te me cumã ampo itajê jarẽn jicu, ne ma Capernam jõ krĩ wỳr mõ. ");
INSERT INTO ram_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ne pê curi Roman catêjê nõ ihkrĩ, ne cupê krãhtare te xẽj jõ pahhi. Pê pahhi mã hàpên catê hà, ne ramã ihtyc xàa kam nõ. ");
INSERT INTO ram_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mã pahhi ata te Jeju jarẽn par, ne ihwỳr Juta catêjê pê pahhi kwỳ kujahêc, cute me Jeju japrôr, mã cute hà ata caprãr prãmte. ");
INSERT INTO ram_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mã cute me Jeju cajpar, ne me ahna hàhwỳr crire nare, ne me cumã: ― Ỹhỹ, Roman catêjê nõ ita peaj to impej, cwỳrjapê ca ha ihtehcajpa. ");
INSERT INTO ram_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nãmri cumã me papê Juta catêjê kĩan to ihkĩn, ne cutea ri me imã ite me cuprõn xà jũrkwa ton. Cwỳrjapê ca ihtehcajpa, ne me ikôt mõ, ne hà ata caprã ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mã ma Jeju mehkôt mõ. Ne ramã cute ikre têp, mã krãhtare jõ pahhi te hõ ikwỳ nõ catêjê kujahêc, cute me Jeju mã hũjarẽn prãmte. Mã cute mehcajpar ne me cumã: ― Me ikwỳ nõ te amã harkwa kujahêc to hajỹr he: “Pahhi, akĩnte icrire ne ikêanre ita kam, wa nee acahpêrkàr prãm nare. Cwỳrjapê ca ha nee ijũrkwa mã axàr nare. ");
INSERT INTO ram_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne jũ wỳr wa ijĩa kam amã icakôc, nãmri apê Pahhiti ne akĩnte jũ na xà na ijamreare, ne ipahàm crire nare. Ca ha cama hà ata mã garkwa ta, quê ha imã hàpên catê ita impej pyrentu, ne capẽn. ");
INSERT INTO ram_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ne wa hanea ne me ijõ pahhi jarkwa kôt ipa, ne wa ha ijõ krãhtare catêjê mã ijarkwa ta, quê ha ihtỳj me ikampa ne ijarkwa kôt me ipa. Ne wa ha jũm mã, ‘Tẽ!’ hane, quê ha ihtỳj tẽ. Ne wa ha mehnõa mã, ‘Ajpên tẽ!’ hane, quê ha ihtỳj ajpên iwỳr tẽ. Ne hanea ne wa ha imã hàpên catê mã, ‘Ca ha to hane!’ hane, quê ha ihtỳj to. Ne ijirôa pê acati ita kam, ca ha cama hà ata mã garkwa ta, quê ha imã hàpên catê ita impej, ne capẽn pyrentu” ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mã Jeju xa, ne cute hũpar xà ita to hũpar, ne to amji mã ipikrar. Ampo na? Cumã hũpar xà ita peaj to impej. Na ri cute amji mã ipikrar, ne me hàhtôa ne ihkôt me mõ atajê wỳr ipipkjêr, ne me cumã: ― Ỹhỹ, ampeaj kam wa me amã awjarẽ, Roman jõ krĩ kra ita ihtỳj ikampa, ne ihtỳj amji mã ito ihhimpej. Wa rỳ Juta jõ pjê kam jũ caxuw, ampeaj kam jũm te amji mã ito ihhimpej to hajỹr nõ na, impar nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mã Roman jõ krĩ kra ita jõ ikwỳ nõ itajê, hacpỹa mã me hũrkwa wỳr cute me amji jacjên, mã hamre ramã cumã hàpên catê ata pej, ne capẽn pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ỹhỹ, pê nee curi Jeju na amcro hàhtô nare, pê ma Põre jõ krĩ wỳr mõ. Pê ihkôt me ipa catêjê me, me hàhtôa ne ihkôt me mõ. ");
INSERT INTO ram_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pê Jeju ramã krĩ jõ harkwa têp, pê cute me harêt catêjê krĩ jarkwa na, jũm tyc jarêt to me cato. Por pê cahãj pê ihkra ty ata pê ihcãmter cumã pyxit peaj. Ne iràn xà na cumã mehkjêjê nõ hamreare. Ne pê rỳ pêa mã ramã impjên cupê ty. Pê cute me ihkra jarêt catêjê kôt incwỳr to mõ. Pê hanea ne me hàhtôa ne krĩ pĩn, mehkôt me mõ. ");
INSERT INTO ram_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mã Jeju te cahãj ita cwỳr na hõmpun, ne ampeaj kam cumã caprĩ xà, mã cumã: ― Apu acwỳr nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne ihkra jarĩj xà ata na hàhtêp, ne cute me to hàhhuc prãmte ahna hũ xir, mã me to hàhhuc, mã Jeju ihtyc ata mã: ― Hũmre, wa ha amã ijarkwa ta. To xa! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mã hũmre ita jỹr pyrentu, ne cute ihcakôc kam to ihtẽm. Mã Jeju te inxi mã hõr. ");
INSERT INTO ram_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mã mehcunea mã hũpaa to hũpa. Ne ame hakry pyrên ajpẽn mã Pahpãm to me hàmnãn to me mõ, ne me ajpẽn mã: ― Me pamã Pahpãm jarkwa to ihcakôc catê catia nõ ita cator! Me Pahpãm mõrmõ cator, cute me pahtehcajpar xà caxuw ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pê Jeju jarẽn pejti ita pjê ata cunea kam apu ajcrà. Pê hanea ne cahê na pjê atajê kôt harẽn apu ajcrà. ");
INSERT INTO ram_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ỹhỹ, por Xacarij me Ixapewkwỳj kra pê Jowãw ata, cormã apu ipa, ne ihtỳj mehcunea mã Pahpãm cator xà caxuw ame amji cũmpej to hũjarẽn to ipa. Ne por Jowãw kôt me ipa catêjê na cute me amji ton to prãm atajê ri, Jowãw te amji caxuw cô kam mehcumrãr. Cwỳrjapê ri cute me cumã haprỳ krut jõr, ne me cumã: “Jowãw te me cumrãr catê” hajỹr. Mã hamre, Jowãw kôt me ipa catêjê nõ te Jeju pupun, ne ma amji jaxàr ne cumã Jeju jarẽn. ");
INSERT INTO ram_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mã Jowãw te ihkôt me ipa catêjê to ipijakrut ne me cumã hàkjêr, ne me cumã harkwa hyr to: ― Jeju wỳr me tẽ ne mehcukij, ne me cumã: “Xà apê hũmre cator xà ata mã ca? Xà Jowãw te me imã garẽn ata mã ca ramã acator? Nare xà wa ha pijamã ajkĩ cormã me jũm xũmre nõ ata jikaj?” hane ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mã hamre, ma Jeju wỳr me pra, ne me cumã: ― Ỹhỹ, Jowãw te me cumrãr catê te me imã harkwa hyr, wa me acukij: “Xà apê hũmre cator xà ata mã ca? Xà Jowãw te me imã garẽn ata mã ca ramã acator? Nare xà wa ha pijamã ajkĩ cormã me jũm xũmre nõ ata jikaj?” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mã amcro ata kam Jeju te me kam mare mã me hà catêjê jàhtôa ne me caprãr. Ne hanea ne cute me pahcurê xwỳn carõ kên jàhtôa mã me hĩ tête hapôj na harkwa hyr, mã me cupê hapôj. Ne hanea ne cute mento tũm jàhtôa ne me caprãr, mã ihtỳj me irĩt. ");
INSERT INTO ram_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne Jeju te ame to hajỹr jirô pê mã ri, cute Jowãw kôt me ipa catêjê mã: ― Ỹhỹ, me amji jaxà, ne ate mempar atajê me, ate me hõmpun atajê to Jowãw mã me awjarẽ. Pom mento tũm catêjê ihtỳj me irĩt he, ne mehkjê te xwỳ catêjê ihtỳj me capẽn, ne me hapactu catêjê ihtỳj me awpa, ne mehtyc catêjê hacpỹa mã mehtĩr, ne me cupê hamreare atajê ihtỳj me Pahpãm himpej xà jarẽn xà impejti kampa. ");
INSERT INTO ram_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Quê ha jũmjê ikampa, ne cute ikam hapac mã hũcanãr, ne nee ito amji pê hapac kêt nare na, quê ha hakrya to hakry ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mã ma Jowãw kôt me ipa catêjê te me amji jaxàr ne me pra. Mã Jeju te me hàhtôti atajê mã Jowãw jarẽn kam ihtẽm, ne me cumã: ― Ỹhỹ, pê ca me Jowãw cajpar prãmte ma põ kam me hamreare ata wỳr me pra. Ne ampo pupun prãm to mã, pê ca ame pra? He pê ca nee me hũmre nõ pê kôc te apu pĩhhô to tertet pyràcti ata pupun nare. ");
INSERT INTO ram_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ne mẽr ampo pê ca me hõmpu? Pê ca nee me hũmre ata na cupẽhkà impejti nõ pupun nare. Ne por mehkà impejti kam ame ipa atajê, ihtỳj quêt ampo pejti cunea jipôc ri, pahhi jũrkwa pejti ne catihti ata kam mehkrĩ. ");
INSERT INTO ram_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ne me imã amji jarẽ, ampo pupun prãm to mã pê ca me pra ne me hõmpu? Xà Pahpãm jarkwa to mehcakôc catê nõ pupun prãmte pê ca ajkĩ me pra? Ỹhỹ, ampeaj kam ri Jowãw pê Pahpãm jarkwa to ihcakôc catêjê nõa, ne mehkwỳ jirôa pê cati. ");
INSERT INTO ram_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","He pê rỳ pêa mã ramã Pahpãm jõ kàhhôc Jowãw jarẽn to hane he: “Ỹhỹ, pê Pahpãm ihkra mã: ‘Wa ha acumam ijarkwa na ipa catê kujate, quê ha amã gõ pry to impej’ ” hane. Hõhõ, pê Pahpãm ramã Jowãw jarẽn to hanea, na ri cator. ");
INSERT INTO ram_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","― Ne ampeaj kam wa ha me amã awjarẽ. Jowãw ri catia to cati, ne taa mã ri quêt me aquêtjê jirôa pê cati cakrô, quê ha jũm crire ramã Pahpãm himpej xà krac ri ipa ata, quê ha Jowãw jirôa pê cati ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ne pê mehcunea me ampo ita kampa. Pê ihtỳj hanea ne pahhi jarkwa na me hàmcwỳr catêjê atajê me Pahpãm jarkwa kampa ne hỹrmã me apkjê. Cwỳrjapê pê ramã Jowãw caxuw, cô kam mehcumrã. ");
INSERT INTO ram_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pê mehkĩnte Parixêw catêjê me, cute me Mojxe xwỳ jõ kàhhôc to me cumã hahkre catêjê me, ma ame Pahpãm te me to ihhimpej xà ita caca, na pê nee amji na me Jowãw to tojnõ, pê cô kam me cumrãr nare. Na pê Jeju me cumã: ");
INSERT INTO ram_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","― Ỹhỹ, me atoa wa ha me amã icakôc. Pom ca amcro ita kam, pjê kam ame apa itajê, me apê ahkrare te xuwcacati atajê pyràac. ");
INSERT INTO ram_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ne me apê me ahkrare te ame hàkrun pyràac. Ne me akwỳ amji mã me acaràr to: “Wa ite me amji kĩn jõ increr to me icrer, ca ajte nee me icuxà me acrer nare. Ne ite me harêt japête mencwỳr to me icwỳr, ca ajte nee me icuxà me acwỳr nare, ne cama ame xuwcaca to ame apa”. ");
INSERT INTO ram_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ỹhỹ, me apê ahkrare kwỳ te xuwcacati atajê pyràac. Ampo na? Pê Jowãw cato ne ihtỳj ajco ipijacri to ipa, ne nee ampo cacô to ihkõm nare. Cakrô, ca nee ajte ate mempar ne me hũnãr nare, ne cama me to gũjarẽn to: “Cupê me pahcurê xwỳn carõ kên to ipijapar catê” hane. ");
INSERT INTO ram_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wa quêt ipê me Ahàkà, itỳj ampo cunea ku, ne ampo cunea to ikõm to ipa cakrô, ca ajte nee hanea ne ate me ipar ne me ipynãr nare, ne cama me ito gũjarẽn to: “Hõmpu he, hũmre ita jàpàn cati, ne ihkõm cati, ne me cupê pahhi jarkwa na me hàmcwỳr catêjê me, jũmjê kêanre itajê jõ ikwỳ nõ nõ” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ỹhỹ, he Pahpãm te amji kam hapac xà cunea impej pit, quê ha jũm Pahpãm te amji kam hapac xàa kôt ipa na, quê ha cumã amji jahkre pej pejti ne ― hane. Hõ, pê Jeju me cumã hũjarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mã Parixêw catêjê nõ japrỳ te Ximãw te, Jeju te hũrkwa kam cahê na ampo krẽr prãmte, hator. Mã ma Jeju hũrkwa wỳr ihkôt mõ. ");
INSERT INTO ram_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pê krĩ ata kam cahãjre inxyre nõ ihkrĩ, ne cumã Jeju te Parixêw catêjê nõ jũrkwa kam apu mõr na hahkre pej. Ne cute ampo cacô incjên xà kam, ampo cacô cuxwati ata to hipu tu, ne ipyr ne ma hỹrmã to tẽ. ");
INSERT INTO ram_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ne cute Jeju na hàhtêp, ne ihkõn krã na hỹr, ne cute ihkên ton xà atajê jũ na ihpahàm te incwỳr kam to ihtẽm, ne into cacôa to Jeju par co, ne ihkĩa to cumã incrà. Ne ma hõtpê ihpar pã, ne cute kam ampo cacô cuxwa pejti ata jaxwỳr. ");
INSERT INTO ram_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mã Ximãw te ita pupun, ne amji caxwãm pê amji mã: ― Pỳhàpà, xà mõrmõ ajkĩ hũmre ita pê ampeaj kam Pahpãm jarkwa to ihcakôc catê? Quê cupê Pahpãm jarkwa to ihcakôc catê na mã, quê ha ihtỳj cahãj ita kêanre na hahkre pej. Wỳr quê cupê Pahpãm jarkwa to ihcakôc catê quê amji na cahãj kêanre inxyre ita jamã, quê ihtêp ne ihcupê ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mã Jeju te Ximãw caca xà ita na hahkre pej pyrentu, ne cumã: ― Ỹhỹ, Ximãw, wa ha amã ampo jarẽ ― hajỹr. Mã cumã: ― Hã, gapacta ne imã harẽ, pahhi ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mã Jeju cumã: ― Ỹhỹ, pê hũmre ajkrut ne ihpore to jũm jakràjti ata to new. Pê ita to new cati to quĩjẽnta, ne ita hapyre mã to new to xĩncwẽnta. ");
INSERT INTO ram_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ne pê ajwar me cupê ihpore hamreare, me cumã hàmjõr xà caxuw. Ne ampo to quê me hũhkra kam hàmcwỳr catê ita mã amgõ? Mã me hũhkra kam hàmcwỳr catê mã me caprĩ, mã cute ajwar me to tojnõ. Mẽr hõhõ, wa ha me ahna acukij, mẽr jũm quê ha amji jirôa pê hakry, ne cumã to new catê ata kĩn? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mã Ximãw cumã: ― Imãa, pom cute to new catihti ata ri hakry ― hane. Mã cumã: ― Ỹhỹ, ate to hamãar ne harẽn ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ne Jeju cahãj ita wỳr ipipkjêr ne Ximãw mã: ― Cahãj ita pupu he. Wa ixàr, ca ate ihkĩnte nee imã cô kwỳ nare, ite to ipar tũm cuhhõn xà caxuw, mã quêt cahãj ita te into cacôa to imã ipar cuhhõn, ne ihkĩa to imã incrà. ");
INSERT INTO ram_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wa icator, ca nee ate ihkĩnte ijũhkra na ipyr nare, ne nee ate ipãr nare. Mã quêt cahãj ita te nee ipar pãr jicu nare. ");
INSERT INTO ram_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne nee ate ihkĩnte imã ikrã caxuw ampo cacô cuxwati nõ jõr nare. Ne cutea ri quêt ipar kam ampo cacô cuxwati jaxwỳr. ");
INSERT INTO ram_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ỹhỹ, he ampeaj kam wa me amã awjarẽ, Pahpãm te cahãj ita to impej ne cute to kên catihti ita to tojnõ, ne hicu, cwỳrjapê ri ampeaj kam cumã Pahpãm kĩn. Ne jũm te Pahpãm to kên crire ata, quê ha cute cumã to tojnõ na, quê ha kyre pê cumã Pahpãm kĩn ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne Jeju cahãj ita mã: ― Ite ramã ate ampo to Pahpãm to kên ita to tojnõ ne hicu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mã me hàpàn xà na mehkrĩ atajê te me amji mã harẽn kam mehtẽm, ne me amji mã: ― Pỳhàpà, jũm xũmre mã ajte, mã ihtỳj cute jũm te Pahpãm to kên ita to tojnõ ne hicu? Côt mã cupê Pahpãm? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mã Jeju cahãj ita mã: ― Ampeaj kam ate ito amji mã ahimpej, cwỳrjapê ri Pahpãm te apytàr. Na ca ha apej pêa mã mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pê amcro nõ na, ma Jeju krĩ jàhtôa kôt mõ, ne ma krĩ wên kôt me hapôj to me mõ, ne Pahpãm pê Pahhiti na harẽn xà impejti atajê jarẽn to mõ. Pê ajco ihkôt me ipa catêjê te tôxi atajê ihkôt me mõ. ");
INSERT INTO ram_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pê hanea ne pyjê kwỳ cahãj tête Jeju me pahcurê xwỳn carõ kên kwỳ japôj atajê me, hà kwỳ na me caprã atajê me, ihkôt me mõ. Atajê japrỳ pê hane he: Marij Matarkwỳj, pom pê Jeju cupê me pahcurê xwỳn carõ kên te xet japôj ata me, ");
INSERT INTO ram_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jowanakwỳj pê Cuxa pê pahhi Heroti mã hàpên catê ata me hĩxi me, Xuxankwỳj me. Mehkwỳ jàhtôa itajê pê ihtỳj ajco me Jeju tehcajpa, ne pyjê atajê pê ihtỳj Jeju kôt me ipa catêjê ajco me hamãr to me ipa, ne me hàhcukrêj to mehtehcajpar to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ỹhỹ, pê krĩ jàhtôa pĩn, cute me Jeju pupun prãmte, me cuprõ. Mã Jeju ame cumã ampo to hahkre, ne me cumã hũjarẽn xà jarẽ, quê mempar to impeaj ne, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","― Ỹhỹ, ampo hy kre catê ma hõ pur wỳr tẽ. Ne hỹrmã cator, ne ampo hy kre to mõ. Ne pê ihkre xà ata hane he, pê cama ihcahkũm to mõ. Mã hamre, ampo hy itajê kwỳ prya kam ipijaxwỳr, mã incwỳar pê me pra, mã hanea ne pryjara te ihkwỳ krẽr, mã hamre. ");
INSERT INTO ram_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mã ampo hy ita kwỳ pjê kam kẽnti ata kam ipijaxwỳr, ne huprãj pê incrà pyrentu. Ampo na? Kẽnti kam pjê ita pururure, ne incràre, ne nee inco nare, na ri incrà ne hamre. ");
INSERT INTO ram_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ne ampo hy ita kwỳ hômjĩ me hipe kam ipijaxwỳr itajê, hipe me ajkaam huprãj. Mã hipe te hipej, mã hamre. ");
INSERT INTO ram_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mã hõtpê ampo hy ita kwỳ pjê impejti kam ipijaxwỳr, ne huprãj, ne cati to mõ, ne ipicamẽn to mõ, ne apu ihkà, ne hàhtôa to hàhtô. Ỹhỹ, ca ha me ikam gapac to impejti na, ca ha atỳj me hahkre pej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mã me cumã hũjarẽn jirô pê, ihkôt me ipa catêjê te mehcukij, ne me cumã: ― Ỹhỹ, ampo to mã ca ame imã hahkre? Gũjarẽn xà jũjê to mã ca ame imã awjarẽ? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mã Jeju me cumã: ― Ỹhỹ, quê ha catyt kam Pahpãm me amã ampo cunea to hahkre, ne me amã to capô to impej partu ne. Ne pom Pahpãm me apê ampo cunea jarẽn to amxu atajê, quê ha me amã harẽn to capô partu ne. Na wa ha nee jũmjê atajê mã hirã pê ampo itajê to hahkre nare, wa ha cama me cumã hũjarẽn xà itajê incwỳrpê harẽn to ipa, mãr quê ha cama me ikampa, ne nee me hahkre pej pej nare, ne me rĩt, ne nee me ampo pupun pej nare. ");
INSERT INTO ram_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","― Ỹhỹ, wa ha me amã côjkwa kam Inxũ Cati himpej xà jũjarẽn xà pê ampo hy kre catê jarẽn xà itajê capô pa. Ne pom ampo hy itajê pê ihhêj rũm Pahpãm jarkwa pyràac, ne pom pjê kam ipijaxwỳr itajê pê ihhêj rũm, mehĩ pyràac. ");
INSERT INTO ram_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","― Ne pom pry kam ampo hy pijaxwỳr itajê pê ihhêj rũm jũmjêa pyràc, ne cute me Pahpãm jarkwa par pyrentu. Ne me ahna ahtũm nare mã me pahcurê xwỳn te mentête Pahpãm jarkwa to pôj. Ne ampo na ri cute me to hajỹr? Quê nee hipêr me Pahpãm jarkwa kôt ame ipa nare to prãm to ri, cute me to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","― Ne pom pjê kam kẽnti atajê pê jũmjê pyràac, ne cute me Pahpãm jarkwa par, ne kam me hapac to impejti, ne hũrên ame hakry, ne me hũpar kam mehtẽm. Ne me ahna ahtũm nare mã me pahcurê xwỳn te me capi, ne ame to kên, mã cute ahna ame amji jicu, ne me hamre. ");
INSERT INTO ram_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","― Hanea ne, pom hipe kam hômjĩ kam ipijaxwỳr atajê pê jũmjê pyràac, ne cute me Pahpãm jarkwa par pyrentu, ne me hũpar kam mehtẽm. Ne hanea ne me ahna ahtũm nare, mã me caxwãm pê mehkrihkrit te me kam ihtẽm, mã ihtỳj amji to me hakràj cati prãm, ne me hakràj atajêa to hãn ne amji mã me amji kĩn ton to me ipa to prãm. Ne cute me hajỹr itajê te me to hamre. Cwỳrjapê, quê nee jũm ata ihkà ne ampo pejti ton nare. ");
INSERT INTO ram_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","― Ne pom pjê impejti kam ipijaxwỳr itajê pê jũmjê pyràac, ne cute me Pahpãm jarkwa par, ne me hũpar pyrentu, ne Pahpãm jarkwa kôt me mõ. Ne ihtỳj harkwa kôt me hũcanãr to me mõ, ita kam cute me ampo pej jàhtôa ne me ton ― hane. Hõ, Jeju te hũjarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pê cormã Jeju me cumã: ― Ỹhỹ, jũ wỳr quê ha jũm ihpôc xà nõ jàhcujro xà caxuw ihpôc, ne paraj krac ri hãm, nare pàrkwỳc krac ri hãm. Quê nee jũm ihpôc xà nõ to hajỹr nare. Quê ha quêt hàhcujro xà ata pôc ne hãm xàa kam hãm, cute mehcujro mã mencjêj, ne me hàhcujro pupun prãmte. ");
INSERT INTO ram_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ne por jũ ri ampo pimxur atajê, quê ha ihtỳj mehpro mẽ, ne me hõmpu. Ne hanea ne awcapàtkô kam ampo pimxur atajê, quê ha ihtỳj me hõmpu, ne me hahkre pej. Ampo na? Ramã hàhcujro xà ata te ihcujro na ri, cute me hõmpun. ");
INSERT INTO ram_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","― Cwỳrjapê ca ha me ikampa, ne ikam me gapac peaj ne. Pom ramã jũm mã ampo ata, quê ha Pahpãm cumã ata jirôa pê, hipêr cumã cugõ, ne por ramã jũm pê ampo kryjre, ne cupê hamreare ata, quê ha ihtỳj hacpỹa mã Pahpãm cupê to pôj pa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mã hamre, Jeju menxi me, mehkjêjê me, hỹrmã me mõ. Ne jũ wỳr quê cute ahna me hipu tu ita kam hỹrmã me axà. ");
INSERT INTO ram_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mã jũm te Jeju mã me harẽn to: ― Ỹhỹ, ihmat xà põ pê anã me, me akjêjê me, mehcuhhê ne me gikaj, cute me amã mehcakôc prãmte ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mã Jeju mehcunea mã: ― He quêt Pahpãm jarkwa kam me hapac catêjê me, me hũpar to me ipa atajê pê ri ijõ inxê me, me ikjêjê ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ne amcro nõ na Jeju pàr kre mã hàr, ihkôt me ipa catêjê me, mã me cumã: ― Hacme, ne hĩpô jĩkjê mã me rê ― hane. Ne ma me mõ. ");
INSERT INTO ram_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ne cormã me irêr to me mõ, mã Jeju jõt, mã kôc pahtỳjti te hàpêr kam ihtẽm, mã ramã cô harô to pra, ne ihtu to pra, ne ihtỳj pàr kre mã incjêj to mõ. Ne tàkam ry cute pàr kre to hipu to mõ, ne ramã mehkên mã me hàr xàa kam me mõ. ");
INSERT INTO ram_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mã Jeju kôt me ipa catêjê ma hỹrmã me tẽ, ne cute mehcujrõn, ne me cumã: ― Me ijõ Pahhi, cu ramã me papictor xàa kam me mõ ― hajỹr. Mã Jeju jỹr, ne cute kôc me cô mã harkwa to: ― Me ankrê! ― hajỹr. Mã pea kôc me cô pinkrên pyrentu, ne ihcunea pinkrên. ");
INSERT INTO ram_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mã ihkôt me ipa catêjê mã: ― Ampo na mã ca nee amji mã me ito ahimpej nare ― hane. Mã cute amji mã me ipikrar crire nare, ne ame hũpa, ne me amji mã: ― Pỳhàpà, jũm xũmre mã ajte? Mã ihtỳj ajte kôc me cô te impar ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ne ma, Querat catêjê jõ pjê kam, Hĩpôjajo jõ pjê jĩkjê kam me cator. ");
INSERT INTO ram_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Mã Jeju pàr kre pê cator pêê mã hũmre nõ hỹrmã cator, ne cute ihcajpar. Ne pê kam me pahcurê xwỳn kwỳ carõ kên jàhtôa ne cumã acjêj ne kam ihkrĩ. Cwỳrjapê pê ihcakrô apu ipa, ne nee ihkà kam apu ipa nare, ne nee ikre nõ kam ihkrĩ nare, ne ma me harêt xà, pê kẽn kre kam pê ihkrĩ. Ne pê ramã me pahcurê xwỳn carõ kên itajê, hũmre ita mã incjêj to hàhtôa to hàhtô, ne ihtỳj ajco cute amji to kên na cumã hũjahkre to ipa. Pê amji caprỳ to me hũkjê atajê ajco mehpro, ne wakỳre te me huwapre xà to me hũhkra me, mehpar juwapre. Pê ajco ampo carõ kên atajêa me cumã hirên pa, ne ma põ mã haprô ne ajco to ipa. Mã Jeju te hũmre nõ ata kam me pahcurê xwỳn carõ kên pupun, ne cupê cator na cumã harkwa hyr. Mã hamre, hũmre ita te Jeju pupun, ne cute caràr kam ihtẽm, ne cuna mã ihpỳm, ne kỳj cati pêa mã cumã: ― Pahhiti me hirôa pê cati kra pê Jeju, ampo to ca ha me imã? Wa ha me awỳ, ca nee ame ito kên nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mã Jeju te ihcukij, ne cumã: ― Jũ mã mã gaprỳ te? ― hajỹr. Mã Jeju mã: ― Ijaprỳ te Me Hàhtôti ― hane. Ne ampo na pê amji jarẽn to hane? Pê ramã me pahcurê xwỳn carõ jàhtôa ne hũmre ita mã acjêj, na pê amji jarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mã me pahcurê xwỳn carõ kên itajê kwỳ Jeju na ahwỳa to ahwỳ, mãr quê nee pjê ata tête ihkãkãnti kam cuhyhti ata wỳr mehkujahêc nare. ");
INSERT INTO ram_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne pê curia hàhkà jakôt na crô hàhtôa ne apu hàpàn to ipa. Mã ampo carõ kên atajê te cumã incjêj prãmte ahna Jeju wỳr, quê me to tojnõ, quê crô atajê mã ame acjêj. Mã Jeju te ahna me cumã harkwa, ne me to tojnõ. ");
INSERT INTO ram_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mã me pahcurê xwỳn carõ kên jàhtôti atajê cunea me hũmre nõ ata pê cator, ne ma crô mã incjêj. Mã ma cô mã ihprõt, ne hàpkàjti pĩn hĩpô kam ihpỳpỳm, mã cô te hipej tu. ");
INSERT INTO ram_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mã crô jamãr catêjê te ita pupun, ne ampeaj kam me cumã hũpa. Mã ma hũpate me pra, ne pry me, pur me, krĩ kôt ame harẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mã cute mempar catêjê ma Jeju pupun prãmte, ma hỹrmã mehprõt. Ne me cator, ne ahna me hàhtêp, ne cute me Jeju te hũmre intête me pahcurê xwỳn carõ kên to pôj ata pupun, ne hõmpun xà ata to amji mã me ipikrar crire nare, ne me cumã hũpa. Ampo na? He hũmre ita aracri ihkàa kam ihcarĩcti jỹ, Jeju cahê na. ");
INSERT INTO ram_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mã cute me ampo ata pupun atajê te mehcunea mã Jeju te hũmre caprãr ata na harẽn. ");
INSERT INTO ram_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mã Querat catêjê jõ pjê kam mehcunea mehkrĩ atajê mã Jeju jũpaa to hũpa, mã cute me hõ pjê pê cator na hàhwỳr. Mã Jeju pàr kre mã hàr. ");
INSERT INTO ram_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mã hũmre pê ampo carõ kên japôj ata te Jeju na hàhwỳr, ne cumã: ― Ito tojnõ, wa akôt mõ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Mã Jeju cumã: ― Hãpà, ca ha amji jaxà, ne ma gũrkwa wỳr tẽ, ne me akwỳ wỳr acato, ne me cumã Pahpãm te ato impej na amji jarẽ ― hane. Ne ma ihkôt me ipa catêjê me, me mõ. Mã ma hũmre ita krĩ cunea kôt Jeju te cumã ampo pejti ton xà ata na me cumã amji jarẽn to mõ. ");
INSERT INTO ram_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mã ma Jeju te hĩpô jĩkjê wỳr amji jaxàr. Mã curi mehcunea jàhhuc. Ne por curi ame Jeju jikaj to me ipa atajê, cute amji jaxàr xà pyrên ame hakry. ");
INSERT INTO ram_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mã hũmre nõ japrỳ te Jajrô hỹrmã cator, ne cupê Juta catêjê te me cuprõn xà kam me to ihhimpej catê, krĩ ata kam. Ne Jeju wỳr cator, ne cuna mã ihpỳm ne cute ahna hàhwỳr, mãr quê hũrkwa wỳr mõ. ");
INSERT INTO ram_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ampo na ri cute to hajỹr? Nee mã ampo na nare, cumã ihkra cuprỳre pyxit peaj na caku te tôxi ata caxuw ri, cute to hajỹr. Pê cupê hà ne ramã ihtyc xàa kam nõ na pê. Mã ma Jeju ihkôt mõ. Mã me hàhtôa ne ihkôt me mõ, ne me hĩ to amji wỳr me Jeju kujahêc to me mõ. ");
INSERT INTO ram_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mã me hàhtôti ata catàtkre na cahãj nõ ata cator, ne pê cahãj ata ramã hà ita na ahna caku tôxi, mã hà ita na ipa. Pê ajco caprô ajxwỳ, pê ramã amji na caj jàhtôa ne cumẽ, pê tee ame caprã, pê nee impej nare. Pê cama amji na ramã hõ pore cunea rẽn pa, ne nee impej nare. ");
INSERT INTO ram_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ne Jeju kôt mõ, ne cute ahna hàhtêp tu, ne hõ kôt ahna hitô kà cyt. Mã caprô crà pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mã Jeju te mehcukij to: ― Jũm te mã ikà cyt? ― hajỹr. Mã mehcunea amji na me hàprãr pit, mã Petrô cumã: ― Pỳhàpà me ijõ pahhi, pom mehcunea apu ajpẽn wỳr me hĩ to me akujahêc to me ipa ita? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mã Jeju me cumã: ― Jũm te icyt, mã ipê icarôt cator, wa ite amji cajpẽr ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mã cahãj ata te cupê amji to ipimxur nare na amji jahkre pej, ne ma Jeju wỳr ihtertet to mõ, ne mehcunea jipôc ri, cuna mã ihpỳm, ne cute ihcyt na cumã amji jarẽn. ");
INSERT INTO ram_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mã Jeju cumã: ― Ikra, ca ate ito amji mã ahimpej to hajỹr, cwỳrjapê ri ramã apej. Na ca ha apej pêa mã mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ne cormã Jeju apu cumã ihcakôac kam, mã Jajrô wỳr cumã hàpên catê ata cator, ne cumã: ― Ijõ pahhi, hamre, ramã akra cuprỳre ata tyc, na ca ha nee hipêr apu Jeju cahpêrkàr to amõr nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mã Jeju te kam hapac, ne Jajrô mã: ― Apu pa nare, ne cama ito pit mã amji mã ahimpej, quê ha ihtỳj amã akra impej ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ne ma curi Jeju cator, ne amji kôt Petrô me Jowãw me Tijac me, me to hàr, mã nee mehkôt hũm me inxi me, jũmjê xàr nare. ");
INSERT INTO ram_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pê mehcunea ikre kam ame amrã, ne me hàhkrihkrit catia to cati, pê ramã cuprỳre ata ty na pê ame amrãhti. Mã Jeju te me cumã: ― Hamre, me acwỳr jicu, he nee cuprỳ ita tyc nare, ne cama nõ ne gõr ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mã mehcunea, cute me cuprỳ ata tyc na me hahkre peaj xà na ame cumã. ");
INSERT INTO ram_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mã Jeju hỹrmã mõ, ne cute hũhkra na ipyr, ne kỳj cati pêa mã cumã: ― Cuprỳ ita, to xa! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mã cuprỳ ita hacpỹa mã ihtĩr, ne hãm pyrentu. Mã Jeju te cumã harte na me cumã harkwa. ");
INSERT INTO ram_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mã hũm me inxi te amji mã ipikrar, ne me cumã paa to pa, mã Jeju te me cumãn, quê nee jũm mã hacpỹa mã cuprỳ ita tĩr na me harẽn nare. ");
INSERT INTO ram_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Amcro nõ na Jeju te ihkôt me ipa catêjê mã hàkjêr, ne cute me cumã harkwa hyr to: ― Ca ha ma krĩ kôt me ajcrà, ne me kam me pahcurê xwỳn carõ kên atajê, ca ha mentête mehcunea japôj, ne me hà catêjê cunea caprã ― hajỹr. Ne cute ampo na me cumã hũjahkre ata caxuw carôt tỳj catia ne hõr. ");
INSERT INTO ram_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne cute me cumã harkwa, quê mehcunea mã Pahpãm pê Pahhiti na me harẽn to me mõ, ne hanea ne me hà catêjê caprãr to me mõ. ");
INSERT INTO ram_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne cute me cumã harẽn to hajỹr he: ― Ỹhỹ, ca ha nee amji mã ampo catia tur nare. Ne nee pĩ cajrer to ame aprar nare, ate ahna me amji cajpar xà caxuw. Ne nee akàhà me, me gõ me, ihpore to me aprar nare. Ca ha me akatkà pyxit peaj to me pra, ne nee amehkwỳ incwỳr nare. ");
INSERT INTO ram_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ne ca ha jamã ne krĩ mã me gapôj, ne jũ ri ikre kam, cute me guwahi xà ata ri ame apa, ne ahnaa krĩ ata pê me gapôj. ");
INSERT INTO ram_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Quê ma krĩ nõ kam ame acurê, ca ha cupê me gapôj pyrentu. Ne me gapôj xà wỳr hãn ne me apar tête me pro jacrô capĩ, ne me hũrê. Ne me hũrêan kam me cumã gũjarẽn to hane he: “Ỹhỹ, ca nee me gũpar nare, ne nee me ipar nare ijũjarẽn xà ita na, cwỳrjapê wa ha nee hipêr ita ri ame imõr nare!” hane ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mã ma ihkôt me ipa catêjê cahkũm, ne ame pra, krĩ kryjre cunea kôt, ne me Pahpãm jarkwa pejti jarẽn to ame ipa. Ne pjê cunea kam me hà caprãr to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pê Heroti pê Hĩpôjajo jõ pjê jõ pahhi, ne ajco Jeju te Pahpãm carôt kôt ampo pihho jàhtôa ne ton atajê na harẽn pa. Ne hũpar xà atajê na, cupê amji jahkre kêatre. Pê ajco ame cumã hũjarẽn to hane he: ― Ỹhỹ, Jowãw xwỳ te me cumrãr catê ri hacpỹa mã ihtĩr ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pê ajco mehkwỳ me hũjarẽn to, quê Erij xwỳ te ri amji pẽr, nare, mam Pahpãm jarkwa to ihcakôc catê nõ ata mõrmõ hacpỹa mã ihtĩr. ");
INSERT INTO ram_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pê pahhi Heroti ajco taa amji mã: ― Pỳpỹn, pê wa pa Jowãw xwỳ krã jakep na ijarkwa ta, pê me hakep ta? Ne mẽr jũm xũmre mã ajte? Pom wa ampo itajê na harẽn pa ita? ― hane. Ne tee pahhi Heroti apu Jeju pupun prãm. ");
INSERT INTO ram_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mã ma Jeju kôt me ipa catêjê te me amji jaxàr, ne Jeju mã cute me ampo cunea ton atajê na me amji jarẽn partu. Mã ma Jeju te me haprôr, krĩ jacot japrỳ te Tep jõ krĩ ita wỳr, ne ahte curi ame ipa xà. ");
INSERT INTO ram_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mã me hàhtôti atajê te mempar, ne ma me hũnãr. Mã Jeju te ihtỳj me ahna amji caxàr, ne me cumã Pahpãm pê pjê cunea jõ Pahhiti na harẽn, ne cute me amji caprãr prãm catêjê atajê caprãr. ");
INSERT INTO ram_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mã ramã caxwa xàa kam, mã ihkôt me ipa catêjê te tôxi atajê ma hỹrmã me pra, ne me cumã: ― Ỹhỹ, ca ha me cumã quê ame ajcrà ne ihtỳj ame pra, me pahcahê na krĩ kryjre apu ihcuhhê itajê kôt, ne curia quê ha ame apà, ne curia ame ahtwỳ, nãmri ita ri põ pê ampo hamreare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mã Jeju me cumã: ― Ca ha me caa me cumã harte ― hane. Mã me cumã: ― Pỳhàpà, ampeaj kam me hàhtôa to me hàhtô, ne me pamã kwỳr te pro te xĩc peaj ne tep pijakrut peaj ita kam, jũ wỳr quê me catwỳ. Ca ha pijamã me hàhtôti itajê mã ite ihpore to me hõ japrôr na me ito? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pê curi me hũmre me hàhtô na me mir to xĩc, mã Jeju te ihkôt me ipa catêjê mã harkwa hyr, ne me cumã: ― Ame cumã, quê ame amji jakrã ne amehkrĩ. Quê ahpỹanre na ame xĩncwẽnta partu ne amehkrĩ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mã ihkôt me ipa catêjê te mempar, ne cute me cumãn, mã cute ahpỹanre na me amji jakrã ne amehkrĩ. ");
INSERT INTO ram_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mã Jeju te kwỳr te pro te xĩc itajê, me tep pijakrut atajê incwỳr, ne kàj mã côjkwa wỳr to irĩt, ne Hũm Cati mã to ihcakôc. Jirô pê mã ri cute kwỳr te pro kryj, ne tep pijakrut ita kryj, ne ihkôt me ipa catêjê mã hõr, mãr quê ame cumã me cugõ. Mã cute ame cumã me hõr. ");
INSERT INTO ram_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mã amehcunea jàpàn, ne ame harte partu. Mã ihkôt me ipa catêjê te me hõ cahhur to me kàhà to tôxi ne me to hipu. ");
INSERT INTO ram_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ne amcro nõ na Jeju ahte mehkwỳ to pit mã cator, ne apu Hũm mã ihcakôc, mã ihkôt me ipa catêjê te me hàhtêp. Mã cute mehcukij, ne me cumã: ― Jũ mã mã me hàhtôti atajê ito amji kam me hapac to? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mã me cumã: ― Mehkwỳ me garẽn to, apê Jowãw xwỳ te me cumrãr catê ata, ne mehkwỳ me garẽn to, apê Erij pê rỳ pêa mã Pahpãm ihtĩar to api ata, ne mehkwỳ me garẽn to, apê mam Pahpãm jarkwa to mehcakôc catêjê nõ, ca hacpỹa mã atĩr ― hane. Mã Jeju me cumã: ");
INSERT INTO ram_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","― Ne me ca? Jũ mã mã ca ito amji kam me gapac to? ― hane. Mã Petrô cumã: ― Apê Crixtô, ne apê, pom pê Pahpãm me panquêtjê mã jũm to awjahkre ata mã ca ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Mã Jeju te me cumã harkwa hyr, ne me cumãn, quê nee cormã ne jũm mã ita na me harẽn nare, ne hanea ne me cumã: ― Ỹhỹ, wa ha ipê me Ahàkà cati, cormã jũmjê jũhkra kam amji pupun xà kêanre to amji pupu. Quê ha Juta catêjê pê prohkam atajê ma ame ipê Ahàkà curê. Quê ha hanea ne me cuxà Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, ma ame icurê. Quê ha me Ahàkà ty, ne ahna amcro incrê jirô pê hacpỹa mã ihtĩr. Na wa me amã awjarẽ. ");
INSERT INTO ram_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","― Ỹhỹ, quê ha jũm mã ikôt amji ton to prãm na, quê ha amjia kôt apu ipa jicu, ne ikôat amji kampa, ne icuxà amji mã ihtyc cupa nare to ipa. Quê ha jũm ata pê ihhêj rũm cute amcro cunea kam hõ pĩ na ihtyc xà ata japjêr to ipa. ");
INSERT INTO ram_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","― Ỹhỹ, quê ha jũm te amji to ipijapar prãm to, cama apu amji jamãr to ipa na, quê ha ihtỳj ty. Ne por quê ha quêt jũm icwỳrjapê ty ata, quê ha icahê na ihtĩr na ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","― Xà quê ajkĩ jũm pjê cunea kam amji mã ampo pejti atajê cunea to hõ tekjê xà caxuw to cuprõ, ne nee iràn xà na Pahpãm to amji kam hapac nare, ne ihkaj na apu ipa ne ahnaa ty, quê ha pijamã cute ampo pejti to cuprõn atajê cunea, ihtyc jirô pê ihtehcajpa? Hãpà, quê ha cama amji to acto, ne nee Pahpãm cahê na amji to ipijapar nare. ");
INSERT INTO ram_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","― Ne por quê ha jũm ijũ na apu ihpahàm, ne hanea ne ite ampo to hahkre xà ita jũ na apu ihpahàm na, quê ha ipê me Ahàkà hanea ne jũm ita jũ na apu ihpahàm. Por côjkwa pĩn me Ahàkà te Pahpãm pê Pahhiti mã me ipijapu catêjê jàhcujro impejti ata to cute amji jaxàr xà ata kam, quê ha hanea ne apu jũm ita jũ na ihpahàm. ");
INSERT INTO ram_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","― Ỹhỹ, me ikampa, ne me ipar xà ita to amji japackrea ne, he wa nee me amã ihêj xi xàa jarẽn nare. He ca ha me anõ atỳj atĩar kam Pahpãm te ihhimpej xà ata na hõmpu ne cormã ty ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ne amcro te xet jirô pê, Jeju te Petrô me Jowãw me Tijac me, me haprôr. Ne ma kẽn nõ ita wỳr me to mõ, ne cute Pahpãm mã ihcakôc prãmte, hàhkà jakôtti nõ na me to hàpir. Ne curia Hũm Cati mã ihcakôc, mã ihkôt me ipa catêjê jõtxwa te me kam ihtẽm, mã ihtỳj me hikwa ne ame gõr. ");
INSERT INTO ram_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mã cormã Pahpãm mã ihcakôac kam, Jeju kuc pintuw ne ihkà te amji to hakati, ne ihpràti. ");
INSERT INTO ram_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mã côjkwa pĩn me hũmre pijakrut pê Mojxe xwỳ me Erij te amji to me ipipẽ, ne me cumã ihcakôc kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ne pê ajwar mempeaj to mempej, ne me ipu na côjkwa pĩn hàhcujrohti ita impejti. Ne ame Jeju mã, por quê ha putwrỳ nõ na Krĩpinkrên kam ihtyc xà ata to mehcakôc. ");
INSERT INTO ram_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mã Petrô na mehkwỳ ramã ame hõtxwa mã ame hikwa, ne amentohkà to ipijapỳn, ne ihprõt pê ame ipimprar, ne cute me Jeju jàhcujrohti ata pupun, ne hanea ne cahê na ajwar me xa atajê pupun. ");
INSERT INTO ram_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mã me hũmre pijakrut atajê te me Jeju mã ihcakôc jicu xàa wỳr, mã Petrô te Jeju mã: ― Me ijõ Pahhi, ita ri me pahkrĩ na ri imãa impejti, na wa ha me amã ikrere nõ xãm, ne Mojxe xwỳ mã mehnõ xãm, ne Erij mã mehnõ xãm ― hajỹr. Ne pê Petrô ihtỳj xa ne apu ihcakôc, ne nee ihcakôc xà ata na amji par nare. ");
INSERT INTO ram_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ne cormã Petrô apu ihcakôc kwỳa kam, mã ahcakrã cator, mã ihkôt me ipa catêjê mã ampeaj kam ahcakrã te mehpro ata cupa. ");
INSERT INTO ram_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mã ahcakrã pĩn cute me jũm jõkre ata par, mã me cumã: ― Hũmre ita pê ikra. Pom pê wa amji mã capi ata. Ne quê hãn ne ihcakôc, ca atỳj me kampa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ne ihkêt, mã mehcarĩcti, mã ihkôt me ipa catêjê te me Jeju pit pupun, ne nee cute me amcro atajê nõ na, jũm mã cute me ampo pupun xà ata jarẽn nare. ");
INSERT INTO ram_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ne amcro nõ na, hàhkà jakôt pê me iwrỳc, mã me hàhtôa ne cute me Jeju cajpar. ");
INSERT INTO ram_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mã me hàhtôti atajê jipôc ri me hũmre nõ ata te caràr kam ihtẽm, ne kỳj cati pêa mã Jeju mã: ― Pahhi! Wa ha icãmter caxuw ana ahwỳ! ");
INSERT INTO ram_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nãmri ampeaj kam ikra pyxit peaj ata kêan to kên. Pê me pahcurê xwỳn carõ kên nõ ihpro, pê mõr pejti kam, ihprõt pê caràr kam tẽ, ne amji rẽn kam tẽ, ne ajco ihhàr to ipa, ne apu catàt tỳj, ne harkwa na hàmprô. Ne ampo carõ kên nõ ita apu to kêanre, mã amji cahhy, ne nee jũ caxuw rỳ cute to tojnõ nare. ");
INSERT INTO ram_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne wa ramã amji caprỳ to ite akôt me ipa catêjê mã harẽn ne me ahna ijàhwỳr, cute ampo carõ kên ita to pôj prãmte, mã nee cute me to pôj nare. Ne jũ wỳr quê ame amji mã hamã, ne intête me cator ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mã Jeju me cumã: ― Pỳhàpà, ampeaj kam ri pjê ita kam, me acunea kêanre. Ca nee ajte ito amji mã me ahimpej nare ita kam, xà wa ha itỳj ajkĩ me amã awcanã? Jũ mã wa ha ajte ne awcanã, ne me acahê na jũ mã amji to amcro to? ― hane. Ne cute hũmre ata mã: ― Ajpên acãmter to mõ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mã cute Jeju wỳr me haprôr, mã me pahcurê xwỳn carõ kên ita te hipêr pjê kam ihkra ita mẽn. Mã Jeju te carõ kên ita mã harkwa hyr, quê cupê cato. Mã hamre, cupê cator pyrentu, mã ihkra ita capẽn pyrentu. Mã Jeju te hũm mã hõr. ");
INSERT INTO ram_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mã mehcunea te Pahpãm carôt catia ata to amji mã me ipikrar. Ne ma cormã Jeju te ampo ton xà ata to me amji mã me ajkra, mã Jeju te ihkôt me ipa catêjê mã hũjarẽn to hajỹr he: ");
INSERT INTO ram_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","― Ỹhỹ, ikam me gapac to impeaj ne. Quê ha jũ caxuw jũmjê ihtỳj Ahàkà cati curê xwỳn jũhkra mã me cugõ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mã nee cute me ita par pej nare, ne nee me hahkre pej nare. Cute me hahkre pej xà ita me cupê ipimxur tu ne nõ ita kam, jũ wỳr quê me hahkre pej. Ne mehpahàm cupate nee cute ampo ata na me Jeju cukij nare. ");
INSERT INTO ram_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mã ihkôt me ipa catêjê te ajpẽn jirôa pê me cati to ajpẽn mã mehcakôc kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mã Jeju te ramã, por ampo to ame amji kampa ata na me hahkre pej. Na ri cute ahkrare nõ ita pỳn, ne amji cape na hãm, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","― Ỹhỹ, me ahkrare nõ ita pupu he, incrire ne capônỹre. Ne imã quêt ahkrare ita cati, ne ihkĩnte me acunea kryjre. Ne quê ha jũm te icwỳrjapê ahkrare nõ ita na amji caxàr na, quê ha hanea ne ina amji capa. Ne quê ha jũm te ina amji caxàr na, quê ha hanea ne cute ajpên ikujahêc catê ata na amji capa. Ne por me akam me gapyre mã mehkryjre atajê ri, imã me catia to me cati ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mã Jowãw Jeju mã: ― Ỹhỹ, me ijõ Pahhi, wa ite me hũmre nõ ita pupun, mã ihtỳj gaprỳa to ame pahcurê xwỳn carõ kên to pôj to mõ. Wa ite ahna me hõmpun ne me cupê ihcahpêrhyr. Ampo na? Nee cupê me pahkwỳ nare na ri ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mã Jeju me cumã: ― Nee ca me jũm ita cahpêrhyr nare. Ampo na? Quê ha jũm nee ame ato kên nare na, quê ha ihtỳj me atehcajpar to ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mã ramã côjkwa wỳr Jeju jàpir xà jõ amcro na hàhtêp to mõ. Cwỳrjapê ri Jeju te Krĩpinkrên wỳr amji kràr. ");
INSERT INTO ram_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ne cute mam ihkôt me ipa catêjê nõ kujahêc. Ne ma me mõ ne Krĩrĩtpej jõ pjê kam, krĩ jacot ata na me cator, cute me hàhhuc xà to me hàhcuprõn prãmte. ");
INSERT INTO ram_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mã xãmte curi mehkrĩ catêjê atajê ma ame Jeju na amji caxàr caca. Ampo na? He cute me Jeju te Krĩpinkrên wỳr ihkràr na me hahkre pej na ri. Pê ajco Krĩrĩtpej jõ pjê kam mehkrĩ catêjê atajê ma ame Juta catêjê curê, na pê ma ame Jeju na me amji caxàr caca. ");
INSERT INTO ram_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mã Tijac me Jowãw te ita na mempar, ne me Jeju cukij to: ― Xà ajkĩ amã ite côjkwa pĩn cuhy pỳm na ijàhwỳr, mã cute krĩ ita kam mehcunea to caxàr na me ito prãm? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mã Jeju ihkôt me ipa catêjê wỳr ipipkjêr, ne hõtpê me kam incàcàcre, mã me cumã: ― Me apê ite amji kam ijapac xà na ijahkre kêatre. Ampo na? He nee me Ahàkà ita me hipej xà caxuw mehwỳr cator nare, ne me hũtàr xà caxuw ri mehwỳr cator ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne ma krĩ jacot nõ ita wỳr me mõ. ");
INSERT INTO ram_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mã Jeju ihkôt me ipa catêjê me, me mõ, mã mam jũm xũmre nõ me hỹrmã cator, ne Jeju mã: ― Ỹhỹ, wa ha itỳj ma akôt mõ, ca ha jũ ri tẽ, wa ha ma akôt tẽ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mã Jeju cumã: ― Xà ca ha pijamã awcanã? He hõtpê xore mã ihkre, mã kam ihkrĩ, ne hõtpê cuwênre mã hahê, mã kam hikwa, ne ihkĩnte ipê me Ahàkà pê hũrkwa kam hàhhuc xà caxuw hamreare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne ihkôt Jeju te ihnõ cator ata pupun ne cumã: ― Mẽr ikôt mõ ― hajỹr. Mã cumã: ― Wa ha itỳj akôt mõ, mẽr ito tojnõ wa ha ma amji jaxà, ne inxũ tyc xà na hõmpu ne harêt, ne cormã me akôt mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mã Jeju cumã: ― Quêt taa ty, quê ha mehtyc catêjê kwỳa me harêt. Ne ca nare, ca ha quêt ikôt tẽ, ne me cumã Pahpãm pê pjê cunea jõ Pahhiti na harẽn to mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mã jũm xũmre nõ mehkôt Jeju wỳr cator ne cumã: ― Ỹhỹ, wa ha ma amji jaxà ne tẽ, ne inxê me inxũ mã amji jarẽ, ne me akôt imõr pyrentu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mã Jeju cumã: ― Quê ha jũm hàpên xà kam apu pjê to ipipkjêr to ihcuhtacti to mõ, ne hacpỹ mã amji jahpan xà rĩt, ne amji pê to hikôt, ne ahna cupê ihkaj na. Jĩkjê na quê ha jũm te Pahpãm pê Pahhiti ata mã hàpên kam ihtẽm, ne cumã hàpên cahtiri cute hicu na, quê ha nee jũm xũmre ata Pahpãm mã hàpên xà caxuw impej nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ita jirô pê mã pê Jeju me hũmre to xetẽnta ne ihkôt me to ajkrut ne me capi, cute amencràn xà caxuw. Ne cute me hũmre to ipijakrut partu ne amehkujahêc par, quê mam ame pra ne krĩ cati me krĩ jacot cunea kôt, por jũ ri Jeju apu ipa prãm ata wỳr, cute amji cumam amehkujahêc. ");
INSERT INTO ram_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne me cumã: ― Ỹhỹ, pom me gàpên xà pê Pahpãm wỳr ate me to apipkjêr xà ita pê arỳjhy intep to cuprõn xà pyràac. Ne pur catia to cati, ne ramã inteptu, ne cute me to cuprõn catêjê ri cormã mencrêre. Cwỳrjapê ca ha me pur catihti to hõ tekjê ata na ahwỳ, quê hipêr me amã me to cuprõn catêjê kwỳ kujate. ");
INSERT INTO ram_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ne wa ha me ato ampo pryre capônỹre atajê kra pyràac, ne rop cahàc jàprêhti atajê cajpuw me akujate. ");
INSERT INTO ram_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ca ha nee ame kàhà cwỳr nare, ne nee amehpore incjên xà me, ihpar kà incwỳr nare. Ne me acatyatre na krĩ wỳr me pra, pom ite me amã krĩ to ihimpej xà atajêa wỳr. Ne nee pry kôt ame gàhhuc, ne cama ame acakôc to me apa nare. ");
INSERT INTO ram_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","― Ne ca ha krĩ ata kam ikre nõ mã axà, ne mehcajrẽn, ne me cumã: “Hàpà, quê ha Pahpãm ikre ita kam me ato impejti ne, ne me acaxwãm pê me ato acarĩcti ne” hane. Quê ha jũmjê nee cumã amji caxwãm pê amji carĩcti na prãm nare na, quê ha ate mehcajrẽn xà ita hacpỹa ne me awỳr amji jacjê. ");
INSERT INTO ram_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne por curi me gàhhuc xà nõ ata ri, quê ha jũmjê mã amji caxwãm pê amji carĩcti na prãm na, quê ha Pahpãm ihtỳj jũmjê itajê to mehcarĩcti ne. ");
INSERT INTO ram_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ca ha ikre ata kam me ahtwỳ, ne kaam me apà, ne kaam me ikõ, ne por cute me amã me hõ jõr atajê, ca ha atỳj me ku. Me apê me gàpên catêjê, ne me hàpên catêjê cunea hõtpê ihtỳj me hàpên jahpan xà na me apà, ne me ikõ. Ne ikre kam me gàhhuc xà ata ca ha kam me gàhhuc tu, ne nee atỳj ihkwỳ kôt ame gapôj to me apa nare. ");
INSERT INTO ram_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","― Ne hãn ne krĩ atajê mã me gapôj, quê me ana me amji to pôj, ne me amã ampo gõ atajê, ca ha atỳj me ku. ");
INSERT INTO ram_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ne curia krĩ kam me hà atajê, ca ha atỳj me caprã, ne krĩ kam atajê cunea mã atỳj gũjarẽn to hane he: “Ỹhỹ, por Pahpãm pê Pahhiti te pjê to ihhimpej xà ata ri, ramã hàhtêp” hane. ");
INSERT INTO ram_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ne ca ha jũ ri krĩ nõ kam me acato, quê jũmjê mehkĩnte curi mehkrĩ catêjê ma ame acaca, ne nee me ana amji caxàr nare na, ca ha krĩ cape wỳr me gapôj, ne me cumã gũjarẽn to hane he: ");
INSERT INTO ram_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Me amã me ipar prãm nare ita kam, wa ha itỳj me ipar tête pro jacrô jũrê, ne me acunaa mã me gõ krĩ ita jacrô capĩ. Quê ha te me amã me ipar prãm nare cakrô, ca ha atỳj Pahhiti te pjê to ihhimpej xà ata te me awỳr cator xà ata to me amji japackrea ne” hane. ");
INSERT INTO ram_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","― Ỹhỹ, ampeaj kam wa ha me amã awjarẽ, quê ha cute me acukij ne me ato ipicokjêr xàa jõ amcro kam ahtwỳ, quê ha Pahpãm nee krĩ ata caprĩ nare. Ne quê ha krĩ ata jirôa pê cumã Krĩhpôc jõ krĩ wej ata caprĩ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","― Pỳj me hêj xi Coraxim jõ krĩ, me Tep jõ krĩ ata, ca ha atỳj amji kên mã me amji jaxà. Ne wa ha me amã mam krĩ wej itajê jarẽ. Pê krĩ wej itajê japrỳ pê Kẽn jõ krĩ me Teppro jõ krĩ. Pê ajco cama ame Pahpãm to kên, pê Pahpãm cute ame to kên jahpan xà na, me hipej tu. Ỹhỹ, ampeaj kam wa ha me amã awjarẽ, quê ha mam krĩ wej atajê kam, pom curmã me akam ame hàpên xà pihho impejti ton to ipa itajê to me apê na mã, quê ha rỳ pêa mã ihkên jicu, ne quêt catyt kam, impejti na ipa, ne caxuw hihô na ipa, ne hipro na ipa, ne ihkà kên na ipa. ");
INSERT INTO ram_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ne mehcukij ne me to ipicokjêr xà jõ amcro kam, quê ha Pahpãm mã me girôa pê Kẽn jõ krĩ me, Teppro jõ krĩ caprĩ. ");
INSERT INTO ram_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne ca Capernam jõ krĩ ita, ca atỳj kàj mã, côjkwa wỳr gàpir na amji cãmjĩ cakrô, quê ha Pahpãm ahpar mã akujate, ne mehtyc jaxà kam amẽ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne Jeju ihkôt me ipa catêjê mã: ― Ne por jũmjê me akampa atajê, quê ha hanea ne me ikampa, ne por jũmjê ame acurê atajê, quê ha hanea ne ma ame icurê. Ne por jũmjê me icurê atajê, quê ha hanea ne ma ame Inxũ Cati te ikujahêc ata curê ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mã ma ihkôt me ipa catêjê te me xetẽnta ne ihkôt me ipijakrut itajê me cutor, ne ma pjê cunea kôt ame ipa. Ne amcro nõa na cute me amji jacjên, ne me hakrya to me hakry, mã cute Jeju mã me amji jarẽn to: ― Ỹhỹ, me ijõ Pahhi, wa me gaprỳ to pôj, mã me pahcurê xwỳn carõ kên kwỳ ihtỳj me ikampa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mã Jeju me cumã: ― Ỹhỹ, wa ite me pahcurê xwỳn jõ pahhiti pê Xatanaj ata pupun. Mã côjkwa pĩn ihpỳm xà ita pê ihhêj rũm pahhàjê cuxê pyràac ne ihpỳm. ");
INSERT INTO ram_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Me ikam gapac to impeaj ne he. Wa ite me amã icarôt catia me, ite amji jahkre pej catia jõr, na ca atỳj gapacta ne cagã me, pacti kam ame gàhhuc to me apa, ne ate atỳj me pahcurê xwỳn pê me carôt to ihpec. Na quê ha nee jũ caxuw ampo itajê nõ me anõ to kên nare. ");
INSERT INTO ram_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nee ca me pahcurê xwỳn carõ kên te me apar xà pyrên ame gakry nare. Ne quêt Pahpãm te mehkwỳ caxuw me acapi, ne amji mã côjkwa kam hõ kàhhôc kam me gaprỳ nõr pyrên, ca ame gakry ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mã pyt jỹr xà ata kam, Pahpãm Carõ Pejti kôt Jeju jakrya to hakry, mã cute harẽn to hajỹr he: ― Inxũ, apê côjkwa me pjê kam Pahhiti. Ne ate me cupê hahkre kêatre atajê mã ampo pimxur atajê cunea capô, ne me cumã to apipẽ. Ne mehkĩnte ate me cumã hahkre pej catêjê me, cute me amji jahkre pej catêjê pê ampo itajê to apimxur. Ỹhỹ Inxũ, pom ite ampo na garẽn par itajêa to, pê ca ramã amji to ahimpej. Ne imã acaca xà ita cunea impej pit. ");
INSERT INTO ram_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","― Inxũ, ca ramã ate imã ampo cunea jõr. Ne amã pit mã ijahkre peaj to ijahkre pej, ne nee aràn xà na jũm mã ijahkre pej nare. Ne hanea ne imã pit mã gahkre peaj to gahkre pej. Na wa ha jũm mã ato hahkre, quê ha hanea ne jũm ita mã gahkre pej pejti ne ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne cute ihkôt me ipa catêjê mã pit mã harẽn, ne me cumã: ― Me gakry, hamre me apej mã me apỳm. Por ate me ampo pupun ata pyrên ca ame gakry. ");
INSERT INTO ram_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ampeaj kam wa me amã harẽ, Pahpãm jarkwa to ihcakôc catêjê jàhtô, ne pjê jõ pahhi catêjê jàhtô, ne tee ame ampo itajê pupun prãm cakrô, quê me hõmpun nare. Ne me ca nare, ca atỳj me hõmpu ne me kampa. Mã me akĩnte tee ame ampo ita par prãm cakrô, nee cute mempar nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mã amcro nõ na me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê nõ xãm, cute Jeju capi ne ihkên mã mẽn prãmte ihcukij, ne cumã: ― Ỹhỹ, Pahhi, wa ha acukij, jũ mã wa ha ajte ne Pahpãm cahê na itĩr rohnỳtti mã na ipa? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mã Jeju cumã: ― Ỹhỹ, pom pê Pahpãm Mojxe xwỳ mã harẽ, pê harkwa kôt ahna ihhôc ita? Ne mẽr ampo ca ate hõ kàhhôc kam cahyt ne kam gapac? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mã hũmre ita cumã: ― Ỹhỹ, wa ite cahyt, mã harẽn to: “Ca ha ate gĩ cunea me, acarôt cunea me, acaxwỳn cunea me, ate amji kam gapac xà cunea to, amã Pahpãm pê Pahhiti ata ihkĩn. Ne hanea ne amã amji kĩnti ita na, quê amã me akwỳ kĩn” hajỹr ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mã Jeju cumã: ― Ỹhỹ, ca ate to hamãr, ca ha ate ampo itajê cunea ton to apa na, ca ha Pahpãm cahê na atĩr rohnỳtti mã na apa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mã me cumã Mojxe xwỳ jõ kàhhôc to hahkre catê ita te cute amji mã ihpahàm hi prãmte, hipêr Jeju cukij, ne cumã: ― Mẽr jũmjê mã me ikwỳ itajê? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mã Jeju te cumã jũmjê pê mehkwỳ atajê to hahkre to impejti prãmte, cumã hũjarẽn xà ita jarẽn, mã cumã: ― Ỹhỹ, hũmre nõ ma Krĩpinkrên pĩn, Krĩcuxwati wỳr iwrỳc. Mã pry cahtiri me hàhkĩj xi catêjê te me kam ihtẽm, ne amehcahhy, ne me cupê ihkà caxàr, ne ma me to mõ. Ne curia cute me hicu mã ihtyc cahàc ne nõ. ");
INSERT INTO ram_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","― Mã ahna ahtũmre mã hũmre nõ ita pry ata kôt mõ, ne por me hũmre nõ pry kôt mõ ita pê Pahpãm mã mehcajrẽn catêjê nõ. Ne cute hũmre ata pupun, mã pry kam ihcujpàt ne ihtyc cahàc ne nõ. Mã ajte nee cute ihtehcajpar nare, ne cute pry hyr, ne pry jĩkjêa rũm tẽ ne hakren, ne ma mõ. ");
INSERT INTO ram_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","― Mã ahna ahtũm nare, mã ihkôt me hũmre nõa cator. Ne por hapu na cator ata pê Pahpãm jũrkwa jamãr catêjê nõ. Mã ma mõ ne cute hũmre ata pupun, mã ihtyc cahàc ne nõ. Mã cupê mam ihnõ ita pyràac, ne ajte nee cute ihtehcajpar nare, ne cute pry hyr, ne pry jĩkjêa rũm tẽ ne hakren, ne ma mõ. ");
INSERT INTO ram_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","― Mã ahna ahtũm nare, mã me hũmre nõa pry ata kôt mõ, ne curi cator. Ne cupê nee Juta catêjê nõ nare mehkĩnte, ne cupê Krĩrĩtpej jõ pjê catêjê jõ xũmre nõ, ne ihcahkrit. Mã cute hõmpun, ne ampeaj kam cumã caprĩ. ");
INSERT INTO ram_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mã ahna hàhtêp, ne cute ihtehcajpar pyrentu. Ne cumã inxec ata cuhhõn, ne ampo cacô xỳhti ata to cumã ihcahhê. Ne hanea ne ampo twỳm to cumã ihcahhê, ne cupẽhkà to cumã ihcupu, ne hõ cawrô cahàcre kam hỹr, ne ma to mõ. Ne me hàhhuc xà wỳr to cator, ne curia cute hamãr to apẽ. ");
INSERT INTO ram_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","― Ne apẽa kam, cute ikre jõ pahhi mã ihpore hy pijakrut ata to hàmjõr, ne cute cumã: “Hamre, ca ha hamã, ne ahna gõ pore kwỳ rẽ, wa ha hacpỹ ne amji jaxà, ne itỳj amã amgõ” hajỹr ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ne Jeju te me cumã Mojxe xwỳ jõ kàhhôc to hahkre catê ita cukij ne cumã: ― Mẽr hõhõ, imã amji jarẽ, mencrê atajê nõ te mõrmõ jũm xũmre ihtyc cahàc ne nõ ita to amji kwỳ? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mã cumã: ― Por cumã caprĩ ata te ri hũmre ata to amji kwỳ ― hane. Mã Jeju cumã: ― Mẽr hõhõ, ca ha tẽ, ne cuxà ate amji kam gapac xà to hanea, ne amã me akwỳ kĩn ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ita jirô pê mã pê ma Jeju ihkôt me ipa catêjê me pry kôt me mõ, ne ma krĩ jacot ita mã me cator. Mã curi cahãj japrỳ te Martakwỳj ata te hũrkwa kam me ahna amji caxàr, mã me hàhhuc. ");
INSERT INTO ram_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mã Marta tõj japrỳ te Marijkwỳj ita Jeju cape na hỹr ne jỹ, ne apu cute ampo to hahkre xà na kampa. ");
INSERT INTO ram_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mã ihkĩnte Marta ikre kam hàpên xà jàhtôti atajê to apu amji to ahtwỳ, ne apu ihkrihkrit, na ri Jeju na hàhtêp ne cumã: ― Xà ca nee ito amji kam gapac nare, pom wa itõj kĩnte ahte ijàpên xà jàhtôti to apu apê ita? Na ca ha ijàpên xà ita caxuw imã itõj kujate, quê itehcajpa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mã Jeju cumã: ― Marta, Marta, ampeaj kam ca apu amji to ahtwỳa to amji to ahtwỳ, ne apu akrihkrit, ne to apu amji cahpêrkà. Ne ca atõj kĩnte, gàpên xà to pit mã amji kam gapac to apa. ");
INSERT INTO ram_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","He quêt atõj te amji mã ampo pyxit peaj catihti ata capi ata pê ina hỹr, ne cute ikam hapac. Ne jũ wỳr quê jũm cupê ihkrã kam, cute ipar xà itajê to pôj ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Amcro nõ na Jeju apu Hũm mã ihcakôc, ne cute cumã ihcakôc jicu, mã ihkôt me ipa catêjê nõ te Jeju mã: ― Pahhi, Jowãw xwỳ cuxà me imã Apãm Cati mã me icakôc to hahkre. Pê ajco ihtỳj ihkôt me ipa catêjê mã to hahkre ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mã Jeju me cumã: ― Ỹhỹ, ca ha Inxũ Cati mã me acakôc prãm, ne me gũjarẽn to hane he: “Me ijõ Inxũ, wa me icunea quêt acatihti ne apejti na, me gahkre pej to prãm. Ne wa ate pjê kam mehcunea to ahimpej na me prãm. ");
INSERT INTO ram_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ne ahpỹanre na, amcro cunea kam, me imã me ijõ gõ. ");
INSERT INTO ram_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ne ite me ato kên itajê, ca ha me icuxà to tojnõ ne hicu, ahnaa mã wa ite ramã cute me ito kên atajê to tojnõ ne me hicu. Ne me ipytà me pahcurê xwỳn pê, quê nee me imã incaca xà kêanre to hahkre nare. Hamre” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne Jeju te ihkôt me ipa catêjê mã hũjarẽn xà ita jarẽn, mãr quê cute Pahpãm mã mehcakôc, mã ihtỳj me kampa na me hahkre pej, ne me cumã: ― Me ita to amji kampa, ne ihkôt me hakop. Quê ha me anõ mã gõ ikwỳ nõ nõ, ca ha caxwa cahtiri ahna gàhwỳr xà na hũrkwa wỳr tẽ, ne cumã: “Ikwỳ nõ, imã kwỳr krã to incrê ne agõ, wa ha amcro nõ na hacpỹa mã amã cugõ. ");
INSERT INTO ram_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Curmã ihmat pĩn, iwỳr ikwỳ nõ cator, ne ipê cumã ampo jõr xà jamreare, na ca ha imã ihnõ, wa cumã cugõ” hane. ");
INSERT INTO ram_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","― Quê ha akwỳ nõ ita ikre caxwãm pê amã: “Quê, hamreare, nee ca ame icahpêrkàr nare, wa ramã ite to harkwa jihê, ne ramã me ikra mea mã ame ijikwa, jũ wỳr wa to xa ne amã kwỳr krã itajê nõ gõ” hane. ");
INSERT INTO ram_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","― Ne ampeaj kam wa me amã awjarẽ, quê ha ate cupê hõt cahpêrkàr cupate, ihtỳj to xa ne amã ate ampo cunea na prãm atajê gõ. Ne nee mã apê hõ ikwỳ nõ cwỳrjapê quê ha amã hõr nare. ");
INSERT INTO ram_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","― Cwỳrjapê wa me amã awjarẽ, ca ha ate me gàhwỳr na, ca ha atỳj me acwa, ne ate me hapên na, ca ha atỳj me cumã gapôj, ne ate me harkwa cahhyr na, quê ha ihtỳj me amã amji jihê mẽ. ");
INSERT INTO ram_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","― Ỹhỹ, mehcunea ame ampo na ahwỳ atajê, quê ha ihtỳj me cucwa, ne mehcunea ame hapê atajê, quê ha ihtỳj me cumã hapôj, ne ame harkwa cahhy atajê mã, quê ha ihtỳj amji jihê mẽ. ");
INSERT INTO ram_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","― Mẽr hõhõ, xà quê me anõ kra tep na ahwỳ, ca ha tep kaj na ajkĩ cumã cagã nõ gõ? ");
INSERT INTO ram_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nare quê akra hĩ xêt kwỳ na ahwỳ, ca ha ajkĩ ihkaj na cumã pacti nõ to irô ne agõ? Jũ wỳr ca me anõ akra to hane. ");
INSERT INTO ram_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","He me apê me hũmre pit, ne Pahpãm kĩnte me akêanre cakrô, ca atỳj hõtpê me akra mã me ampo pej pit gõ. Mẽr hõhõ, quê ha quêt Pahpãm côjkwa kam ihkrĩ ata, ihtỳj me amã, por ca Carõ Pejti na me ahwỳ ata gõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ne amcro nõ na Jeju ame hũmre nõ pẽrkêt ita pê me pahcurê xwỳn carõ kên to pôj. Pê ampo carõ kên nõ ata nee ajco hũmre ata cakôc na hamãr nare, na pê nee ihcakôc nare. Pê Jeju cupê cator pêê, pê ihcakôc kam ihtẽm pyrentu. Mã me hàhtôti atajê te ahna me hõmpun, ne hõmpun xà ata to cute amji mã me ipikrar. ");
INSERT INTO ram_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ne mehkwỳ ajpẽn mã me harẽn kên to: ― Ỹhỹ, Jeju ihtỳj ame pahcurê xwỳn carõ kên to pôj to ipa. He nee me Pahpãm carôt to ame hapôj nare. Ampo carõ kên jõ pahhiti japrỳ pê Perxep pê Xatanaj te ri Jeju mã me caxuw carôt jõr ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne cute Jeju kên mã me mẽn prãmte mehkwỳ ihtỳj hipêr mehcukij, cute me kam mare mã ampo pihho catia ton, mã mehcunea te me hõmpun, ne cormã quêt Pahpãm te cumã carôt jõr na me hahkre pej prãmte. ");
INSERT INTO ram_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mã ramã Jeju te cute amji kam me hapac xà ata na me hõmpun, ne me cumã ihkôt harẽn to hajỹr he: ― Ỹhỹ, quê pjê nõ kam amehkrĩ catêjê atajê me amji jakrã, ne me taa me ajpu ne ihtỳj me amji jipej. Ne quê ikre ry nõ kam mehkjêjê atajê me, me amji jakrã, ne taa me ajpu, ne hanea ne ihtỳj me amji jipej. ");
INSERT INTO ram_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ita pyràc pej ne, quê Perxep pê Xatanaj, pê me pahcurê xwỳn atajê me mehkwỳ me, me amji jakrã, ne taa ame ajpu, ne ihtỳj me taa me amji jipej. Ca me pahcurê xwỳn carõ kên jõ pahhi te imã icarôt jõr, wa carôt kôt ampo carõ kên to pôj na, ame ijarẽ. ");
INSERT INTO ram_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne mẽr jũm te ri me akôt me ipa catêjê mã me carôt jõr, cute ampo carõ kên to pôj xà caxuw? Xà Xatanaj te ri ajkĩ me cumã carôt jõr? He quê ha taa me amã amji jarẽ, ca ha me caa ate me to ihcupan xà ita na me amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ne ampeaj kam, wa quêt Pahpãm carôat to ampo carõ kên japôj to ipa, cwỳrjapê ri ihkôat ramã me acunea te me Pahpãm pê Pahhiti himpej xà te me awỳr cator na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","― Ỹhỹ, quê ha jũm xũmre tỳjti mã hàprê xà cunea, quê ha hàprê xà atajêa to amji jamãr to impeaj to ipa, quê ha nee jũm cupê hõ tehkrêj nõ caxàr nare. ");
INSERT INTO ram_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nãmri quê ha me hũmre nõ te jũm xũmre ata jirôa pê ihtỳjti na, quê ha kam tẽ, ne to apkjê, ne cupê hàprê xà itajê cunea pytà, ne amji mã cupê hõ tehkrêj cunea pytà, ne ma to tẽ. ");
INSERT INTO ram_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","― Ỹhỹ, quê ha jũmjê te itehcajpar to prãm nare na, quê ha me cupê icuna mã hàprê catêjê. Ne quê ha jũmjê imã ampo to cuprõn nare na, quê ha me cupê ito me ipicràn catêjê. ");
INSERT INTO ram_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","― Quê ha jũm pê me pahcurê xwỳn carõ kên nõ te cator na, quê ha carõ kên ata ma amcràti kam apu ipa, ne apu ihkôt xà japên to ipa. Ne nee ihkôt xà nõ na cator nare, ne taa amji mã: “Wa ha ma, por hũmre jĩ pê ijũrkwa pê icator ata wỳr amji jaxà” hane. ");
INSERT INTO ram_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ne amji jaxà, ne ihhêj ne ikre caprỳ, ne ihcapõn pejti te hãm na hõmpu. ");
INSERT INTO ram_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ne ma tẽ, ne cute hirôa pê me pahcurê xwỳn carõ kên te xet atajê japrôr, ne mehcunea ikre pê hĩ ata mã me acjêj, ne curia amehkrĩ. Mã hũmre mã mam ampo carõ kên xàr ata kam, cute amji cajpẽr xà ata jirôa pê kam cute amji cajpẽr xà, ne ihkêanre ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ne Jeju te itajê jarẽn jirô pê mã ri me cahãj nõ te me hàhtôa jipôc ri kỳj cati pêa mã, cumã harkwa to: ― Jeju ampeaj kam apej. Ne mõrmõ pê ca anã kam apỳm ata ihtỳj ajco ato pijahô, ne ampeaj kam apejti ita kam apyrên hakry ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mã Jeju cumã: ― He cute me Pahpãm jarkwa par ne me hũpar tu, ne ihkôat me ipa catêjê atajê ri, inxê jirôa pê me hakry ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mã me hàhtôa te Jeju pu na me cuprõn tu, mã cute me cumã ihcakôc kam ihtẽm, ne me cumã: ― Ỹhỹ, amcro ita kam me apê Juta catêjê, ca pjê kam ame akrĩ atajê cunea kêanre. Na ca ajte me ina gàhwỳr to me hane he: “Me imã ampo pihho catihti me ampo pejti to, wa ha me hõmpu, ne cormã Pahpãm te akujahêc na me gahkre pej” hane. Cakrô wa ha nee me amã ampo pihho catihti, impejti atajê nõ ton nare. Ne wa ha cama amji to irô, ne me amã Jona xwỳ jarẽn xà ita jarẽ. Ampo na? He ipê hũràac, na wa ha me amã harẽ. ");
INSERT INTO ram_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","― Ỹhỹ, pê me cumã Pahpãm jarkwa to ihcakôc catê na Jona xwỳ ata ipa, ne ma Ninew jõ krĩ catêjê wỳr tẽ. Ne curi mehkrĩ catêjê mã Pahpãm jarkwa jarẽ, por pê Pahpãm Jona mã harẽn xà atajêa na me cumã harẽn pa. Na quê ha me Ahàkà Jona xwỳ cuxà ita kam amehkrĩ itajê mã Pahpãm jarkwa jarẽ. ");
INSERT INTO ram_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Ne Pahpãm te mehcukij ne me to ipicokjêr xà jõ amcro kam, quê ha Ninew jõ krĩ kam mehkrĩ catêjê me acuna mã me hãm pyrentu, ne ame ana mehcakôc kêanre ne, ne ihtỳj me acurê mã me amẽ. Ampo na? Pê Ninew jõ krĩ catêjê atajê ihtỳj me ampo kên ton jicu, pê Jona xwỳ me cumã Pahpãm jarkwa jarẽn xà atajê kôt, pê me hicu. Ne wa ampeaj kam me amã amji jarẽ. He ipê me Ahàkà, wa amcro ita kam, pjê ita kam apu ipa, ne me Ahàkà ita ri Jona xwỳ jirôa pê cati. Ne ihnõ xwỳjê, pê Juta catêjê jõ pahhi pê Xarômãw xwỳ ita, me cupê pahhi catêjê kwỳ jirôa pê amji jahkre pej. Mã me cupê pahhi catêjê jàhtôa ne hỹrmã me cator, cute cukwa kam ame ampo jahkre pej prãmte. Ne pê cô cati jĩkjê rũm pjê xa ata jõ pahhikwỳj cahãj, ne ma Xarômãw wỳr tẽ, cute krã kre te amji jahkre pejti to hahkre xà atajê na impar prãmte. Ne Pahpãm te mehcukij ne me to ipicokjêr xà jõ amcro ata kam, quê ha pahhikwỳj cahãj ata, ihtỳj me acuna mã ihcakôc kêanre, ne me acurê mã me amẽ. Ampo na? He amcro ata kam, pjê ita kam, ipê me Ahàkà ihtỳj me amã ampo itajê to hahkre to ipa, ne pa wa Xarômãw xwỳ jirôa pê icati cakrô, ca nee me ipar prãm nare. ");
INSERT INTO ram_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","― Ne ihnõ xwỳjê, jũ wỳr quê jũm hàhcujro xà nõ pôc ne hãm xà kam hàhcujro impejti kaj na hãm, ne jũ wỳr quê paraj krac ri hãm. Quê ha quêt hàhcujro xà ata xãm xàa kam hãm, quê ha mehcunea me acjêj atajê hàhcujro kam me irĩt pejti ne. ");
INSERT INTO ram_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","― He me panto pê me pajĩ mã hàhcujro xàa. Quê ha me panto irĩt pejti, ne ampeaj kam me pajĩ kam me pamã me pajàhcujro hipu. Nãmri quê ha me panto te ihkêanre na, quê ha me pajĩ cunea kam awcapàtkô. Jĩkjê na ca ha ite amji kam ijapac xà pejti pupu, ne mehkôpĩ ne ihkôat me apa na, ca ha atỳj kam me gapac to me apa. Nãmri ca ha ate me hajỹr nare na, ca ha atỳj ame apa, ne me apê amji jahkre kêatre ne. ");
INSERT INTO ram_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","― Cwỳrjapê ca ha ma me amji jamã, ne ma ihhêj rũm me gĩ kam me gàhcujro xà ita jamã, côt mã ca gàhcujro xà ata to amji pê kam awcapàtkô. ");
INSERT INTO ram_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Quê ha me gĩ cunea kam hàhcujro xà ita te me ato hipu na, quê ha nee me gĩ kam awcapàtkô nare, ne me gĩ cunea kam hàhcujro ita ihpràti ne. Ne ihhêj ne me acaxwãm pê hàhcujro xà nõ xa ne ahcujro ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mã Jeju te ihcakôc jicu, mã Parixêw catêjê nõ te hũrkwa ri hàpàn prãmte hator. Mã ma Jeju ihkôt mõ, ne hõ pyxwỳr xà na hỹr. ");
INSERT INTO ram_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pê nee Jeju Parixêw catêjê te me amji ton xà ata kôt, hũhkra cuhhõn nare. Mã Parixêw catêjê nõ ita te, cute nee hàpàn xà wỳr hũhkra cuhhõn nare ita na hõmpun, ne to amji mã ipikrar. ");
INSERT INTO ram_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mã Jeju te me cumã: ― Ỹhỹ, me apê Parixêw catêjê, ca nee ampo caxwãm pê me to amji japackre nare, ne põ rũm pit mã me to amji japackre. Ca põ rũm me gõ cuhkõn me, me gõ incrat catut cuhhõn to pit mã me amji japackre. Ne me caa, põ rũm pit mã me ate me gàhcukrêj cuhhõn ata kĩnte, me acaxwãm pê me akên te me ato hipu tu. Cakrô ca ajte nee me acaxwãm pê ate amji kam me gapac xà kên itajê to me amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","― Ne ampeaj kam ca ame ato kam waj, ne pom Pahpãm te põ rũm aton ita te ri hajỹar ne acaxwãm pê aton. ");
INSERT INTO ram_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ne gapacta ne me gõ incrat caquẽc cuhhõn to me gapac kêt, me akõm xà me. Ne impejti ita ri quêt me amã impej he, ca ha me gõ incrat kam ampo itajê me, me akõm xà kam ampo itajê, ca ha me cupê hamreare atajê mã me agõ. Ca ha ate me cupê hamreare atajê caprĩ na, quê ha põ rũm ampo itajê cunea me amã ihtetetti ne. ");
INSERT INTO ram_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","― Pỳj me hêj xi Parixêw catêjê kwỳ! Ca ha atỳj me akên mã me axà ne me gamre! He pê ihtỳj Pahpãm me amã ampo cati me ampo kryjre ton na awjahkre. Na ca gõtpê Pahpãm mã, por ca ihcunea to me ajpa atajê jĩkjê kryjre ne me agõ. Pom ca pàrhyre me, ampo kwỳ na kyre pê hĩ jàhwỳr atajê pyxit ne hãn ne me cumã agõ, ne icahhur to me gõ tekjê na ri Pahpãm mã impej. Cakrô, ca nee me akwỳ to impej nare, ata pê me amã Pahpãm kĩn nare. Na ri Pahpãm mã, me ate amji kam me gapac xà itajê na me akam, cupê ihkaj na. Ampo na? He cumã ampo ita catia to cati, ihkryjre itajê jirôa pê. Na ri cumã me ate ajwar me ton na, me ato prãm. ");
INSERT INTO ram_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","― Pỳj me hêj xi Parixêw catêjê kwỳ! He ca gõtpê me hũjamãr catêjê catia krĩ xà ata kam me cahê na me akrĩ prãm, ate me cuprõn xà kam. Ne ca gõtpê krĩ cape na cute me apejti na me garẽn na me to prãm. ");
INSERT INTO ram_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","― Pỳj me hêj xi! He me apê mehtyc kre kam me hikwa, mã nee me hõmpun ne me hahkre pej nare kam, incwỳrpê me pra atajê pyràac. Ne ihhêj ne põ rũm me apejti, ne me acaxwãam pê ate amji kam me gapac xà kên pit apu hikwa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mã me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê nõ hanea ne curi jỹ, ne cute Jeju jũjarẽn xà ita kam hapac, ne cumã: ― Pỳhàpà, Pahhi, ca acakôc xà ita to ate acakôc ne hanea ne me ixũn ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mã Jeju cumã: ― Pỳj me hêj xi me apê me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê! Ca hãn ne mehcunea mã harẽn to hajỹr to me apa ne me cumã: “Ỹhỹ, ca ha atỳj Pahpãm jarkwa cunea kôt me apa. Nãmri ca ha nee ihcunea na, catyt kam ihkôt me apa nare, quê ha ihtỳj Pahpãm me ato kêanre ne” hane. Me gũjarẽn xà itajê ihtỳaj to ihtỳj, ne cupê ihhêj rũm ate me kam me hõ kàhà pytĩa pyxwỳr. Jũ wỳr quê jũm awcanã, quê jũm hũcanãr nare. Ne por ca ihhêj ne nee me to ipa xà caxuw gũhkrahhi pyxit to mehtehcajpar prãm nare ata pê nee ate Pahpãm jarkwa na mehtehcajpar, mã catyt kam ihkôt me ipa xà nare. ");
INSERT INTO ram_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","― Pỳj me hêj xi! He ca ha atỳj me akên mã me apỳm! Ne ca gõtpê Pahpãm jarkwa to mehcakôc catêjê tyc atajê jarêt xà caxuw me cumã kre pejti to. ");
INSERT INTO ram_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","He ca atỳj me aquêtjê japua na ita to me hajỹr to me apa, ahnaa mã pê me aquêtjê me acumam ajco me Pahpãm jarkwa to mehcakôc catêjê cura he. Pê taa mehcura, pê ca me caa ajco me harêt. ");
INSERT INTO ram_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","― Cwỳrjapê pê Pahpãm, cute amji jahkre pejti te hajỹr romã mã, ramã harkwa to: “Wa ha me cumã me ijarkwa to mehcakôc catêjê me, me imã memprar catêjê kujate. Quê ha me jũm cura, ne ame jũm to kên” hane. ");
INSERT INTO ram_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hajỹr cwỳrjapê quê ha amcro ita kam, cute harkwa to mehcakôc catêjê curan jahpan xà na, ame ipa itajê cunea to hanea, ne ame to kêanre ne. ");
INSERT INTO ram_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pê mam pjê intuw kam me Aper xwỳ cura, ne caxuaw ajpên me amji curan na me cupy, ne ajpên me amji curan to me mõ. Ne Pahpãm to amji kam me hapac xà jũrkwa kam, cute me amji curan jicu xà to me Xacarij xwỳ curan. He ampeaj kam wa me amã awjarẽ. Na quê ha Pahpãm, cute mehcuran jahpan xà na, pom ita kam mehtĩar ame ipa itajê to apu ihkêanre ne. ");
INSERT INTO ram_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","― Pỳj me hêj xi me apê me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê! Ca ha me akên mã me apỳm! Ampo na? Ca nee me Pahpãm jarkwa jahkre pej prãm nare, ne nee me amã jũmjê te hahkre pej na me to prãm nare. Na ri ihhêj rũm me apê cute me ikre jihê rẽn xà incwỳr, ne ma amentê, mã nee me to incjêj nare, ne nee jũm mã me hõr, mã cute to hihê mẽn, ne hàr na me amã to prãm nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ne ma Jeju me cupê mõ, mã Parixêw catêjê me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, cama ame cumãn to mehcyt to amencrôn to me ipa. Ne mencryac kam ampo jàhtôa na mehcukij. ");
INSERT INTO ram_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ne tee Jeju jarkwa nõ to me to ipipkjêr, ne cute mehpro prãmte ame to hahkre. ");
INSERT INTO ram_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ne pê me hàhtôa ne me cuprõ, ne me hàhtô kam, ihtỳj ajco amji kam mehcuhhê. Mã Jeju te ihkôt me ipa catêjê mã mam harẽn, ne me cumã: ― Co he, ma amji na me Parixêw catêjê to me guphêa ne, nãmri ihhêj ne ampeaj kam põ rũm mempej, ne me caxwãm pê mehkêanre. Ne amehhêj xia jarẽn to me ipa, ne me cupê pàrhyre xỳ pahtỳjti to me hõ cunea to hỳ ita pyràac. ");
INSERT INTO ram_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ne hanea ne ihtỳj ampo cunea to me ipimxur to ipa. Quê ha amcro nõ na cute ampo to me ipimxur itajê cunea pro mẽ, ne ampo cunea pupu. ");
INSERT INTO ram_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ỹhỹ, ca ate awcapàtkô kam me ampo cunea jarẽn atajê, quê ha ihtỳj amcroa kam me kampa. Ne ca ate ikre caxwỳn kam ampo cunea to me apimxur, ne ahna me to hihê ne caxwãm pê me harẽn atajê, quê ha ihtỳj cà pê mehcunea me harẽ, ne me kampa. ");
INSERT INTO ram_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","― Me ijõ ikwỳ nõ, ampeaj kam wa ha me amã awjarẽ, nee ame, por me gĩ pit cura atajê cupa nare. He quê ha nee hipêr me ato kên nare. ");
INSERT INTO ram_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne Pahpãm ca ha quêt amji mã me hũpa. Pahpãm quê ha ihtỳj quêt jũm jĩ cura, ne cormã hipêr apu to kên, ne ma ihkãkãnti kam cuhy kam cumẽ. Cwỳrjapê wa ha hipêr me amã harẽ, na ca ha quêt amji mã me Pahpãm pit cupa. ");
INSERT INTO ram_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","― Ỹhỹ, por hãn ne cuwênre te xĩc to ihpore pijakrut peaj na me hàhpan cakrô, quê ha nee Pahpãm cuwênre ata nõ to hapac kêt nare. ");
INSERT INTO ram_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne hanea ne Pahpãm te ahpỹanre na me akĩ cunea cahyt par. Ne me caa ri cuwênre jàhtôti itajê jirôa pê me acati. Cwỳrjapê ca ha nee amji mã ampo cupa nare. ");
INSERT INTO ram_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","― Ỹhỹ, he ampeaj kam wa me amã awjarẽ, quê ha jũm me akam mare mã cute ijahkre pej na amji jarẽn na, quê ha me Ahàkà hanea ne côjkwa kam Pahpãm jarkwa to imprar catêjê kam mare mã, cute jũm ata jahkre pej na amji jarẽ. ");
INSERT INTO ram_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne por quê ha me kam mare mã, ma ame icaca atajê, quê ha me Ahàkà hanea ne côjkwa kam Pahpãm jarkwa to imprar catêjê kam mare mã, ma apu jũm ata caca. ");
INSERT INTO ram_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","― Ỹhỹ, he quê ha jũmjê ipê me Ahàkà na ihcakôc kên na, quê ha Pahpãm ihtỳj ihkên ata to tojnõ ne hicu. Nãmri quê ha jũmjê te Pahpãm Carõ Pejti na ihcakôc kên na, quê ha nee Pahpãm ihkên ata to tojnõ ne hicu nare. ");
INSERT INTO ram_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","― Ne quê ha amcro nõ na me acukij xà caxuw, cute me cuprõn xà jũrkwa wỳr me gaprô. Ne cute me akên mã me amẽn prãmte, pahhi catêjê me, me cupê pahhiti catêjê cuna mã me apyxwỳ, ne me acukij. Ne amcro ata na, ca ha nee ame akrihkrit nare, ne nee amji caxwãm pê me amji mã: “Jũ mã wa ha ajte amji jarẽn to, ne pahhi catêjê itajê pê amji pytà?” hajỹr nare. ");
INSERT INTO ram_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","He Pahpãm Carõ Pejti quê ha amcro ata kam, me amã me ate me amji jarẽn xà to hahkre, cwỳrjapê ca ha nee ame akrihkrit nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mã me hàhtôa jipôc ri hũmre nõ xãm, ne Jeju mã ihcakôc ne cumã: ― Ỹhỹ, Pahhi! Ca ha itõ mã garkwa ta, quê imã hũm xwỳ jàhcukrêj to ajcapô ― hane. ");
INSERT INTO ram_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mã Jeju cumã: ― Pỳhàpà, xà ajkĩ jũm te me amã ampo to ipicràn catê na ixãm? Hãpà. Nee ipê ampo to ipicràn xà caxuw me acukij catê nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne me hàhtôti atajê japackre, ne me cumã: ― Krãa, me ikampa! Ca ha nee ame hàhcukrêj to me acukrêj to prãm to me apa nare. Gapacta ne ampo to amji mã me cuprõ, ne nee me acukrêj itajê to pit mã ame amji japackre nare. He ampeaj kam ri me pahcukrêj itajê pê nee pahte amji kam me pajapac xà to ihhimpej catê nare. ");
INSERT INTO ram_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","― Ỹhỹ, wa ha me amã jũm jakràjti nõ jarẽ, ca ha me hahkre pej, ite me amã harẽn xà ita kôt. ― Ỹhỹ, hakràj cati ita mã hõ pur catia, ne hõ pur ita kam cumã ampo jàhtôa to hàhtô. ");
INSERT INTO ram_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mã cute pur kam ampo itajê cunea pupun, ne to amji kam hapac pyrentu, ne amji mã: “Pỳhàpà, ampeaj kam ipur kam ampo jàhtô, ne ipê caxuw nõr xà cati nare ita kam, jũ mã wa ha ajte to? ");
INSERT INTO ram_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ỹhỹ, wa ha to hane he. Wa ha nõr xà incrire ita hu, ne amji mã nõr xà catia nõ xãm, ne curia wa ha ijõ cunea jaxwỳ. ");
INSERT INTO ram_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne wa ha amji mã, ‘Hamre, ramã imã ijõa to ijõ, ne ijakràj catia, na wa ha nee hipêr pur nõ xir, ne kam ijàpên nare. Ita caxuw wa ha caku jàhtôa kam cama ikrĩ ne cuku, ne apu to ikõm to ipa, ne ijakry ita na apu ipa’ ” hane. ");
INSERT INTO ram_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","― Mã côjkwa kam Pahpãm jỹ, ne cute amji kam hapac xà ita na hõmpu, ne cute hakràj cati ita mã: “Ate amji jahkre kêatre. Pê wa amã acaca xà gõ, ne ita kam ca ha caxwa ri ty, ne hacpỹa mã imã agõ. Quê ha jũmjê amji mã gõ jàhtôti ita to me ahtwỳ” hajỹr. Hõhõ, Inxũ te hakràj cati ata mã harkwa to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","― He Pahpãm to ate amji kam me gapac to me apa xà ata pê ihhêj rũm côjkwa kam ate amji mã me gàhcukrêj pejti to me cuprõn. Kĩn pej ne, ca ajte pjê ita kam me gàhcukrêj me, me gõ to pit mã me amji kam me gapac to me apa, ne nee hĩkjê na, hõtpê Pahpãm to me amji kam me gapac nare na, ca ha me apê hakràj cati ata pyràac, ne me amji to acto ― hane. ");
INSERT INTO ram_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne Jeju te ihkôt me ipa catêjê mã, cute ampo kên na ame amji to hàptõ to me ipa nare xà jarẽn, ne me cumã: ― Cwỳrjapê wa ijõtpê me amã harẽ, ca ha nee me gõ me, me gàpàn me, me akà to pit mã me amji to gàptõ to me apa nare. ");
INSERT INTO ram_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","He me pajĩ ri me pahkà jirôa pê cati, ne pahte amji kam me pajapac xà ri me pajõ jirôa pê cati, na ca ha itajê to pit mã me amji kam me gapac to me apa jicu. ");
INSERT INTO ram_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","― Ca me wakê pupu, mã nee amji mã pur ton nare, ne nee kam hàhkre nare, ne nee amji mã to cuprõn nare, ne nee caxuw amji mã hõ nõr xà pyxwỳr nare. Cakrô mã Pahpãm hõtpê me cumã harte. Ne mẽr hõhõ, Pahpãm mã wakê itajê jirôa pê me acati. Cwỳrjapê quê ha ate ampo itajê cunea na, amji to me gàhhuc xà nare kam, quê ha me gamã. ");
INSERT INTO ram_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Xà ca ha me atyc nare na, amji to me gàhhuc xà ata to, ajkĩ atỳj amji mã me atĩr jõ caku to ajcamẽ? Hamreare, ca ha nee amji mã me to apicamẽn nare. ");
INSERT INTO ram_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mẽr hõhõ, he ca ramã nee ampo to ate amji kam me gapac xà atajê to, amji mã me apicamẽn nare ita kam, ampo caxuw mã ca cormã ampo kryjre na me amji to me gàhhuc to me apa? ");
INSERT INTO ram_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","― He pĩrã te hajỹar he. Nee hàpên nare, ne nee amji mã ihkà ton nare cakrô, mã ihtỳj ajcamẽ ne impejti. Ỹhỹ, ampeaj kam wa me amã awjarẽ, por pê pahhi xwỳ pê Xarômãw jakràj jàmkrã catia ata, pê te ihkà impejti cakrô, pê pĩrã kà ata Xarômãw kà jirôa pê impej. ");
INSERT INTO ram_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ne Pahpãm ri, pom ahkêt amcro kam ihcuhhê ne ajcamẽ atajê mã ihkà to. Mã hãn ne ahna apẽ mã cuhy to capa. Mẽr hõhõ, quê ha Pahpãm ihtỳj me amã me akà to. He ca ihhêj ne cormã kyre pê Pahpãm to amji mã me ahimpej, mã Pahpãm ihtỳj me gamãr to prãm. ");
INSERT INTO ram_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","― Cwỳrjapê ca nee ame akrihkrit nare, ne nee ate me ampo kur xà me, me akõm xà to pit mã na, ame amji to hàptõ nare. ");
INSERT INTO ram_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Por pjê kam krĩxàre mehkrĩ, Pahpãm to amji kam me hapac nare atajê ri me hõ me, mehkà to pit mã ame amji kam hapac to me ipa. Ne me Apãm Cati mã, ate ampo na me prãm atajê na me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ca ha mam cati mã Pahpãm pê pjê cunea jõ Pahhiti to amji kam me gapac to me apa, ne harkwa kôt ame apa, jahpan xà na, quê ha Pahpãm cormã hipêr me amã ampo cunea na, ate me ahna prãm atajê gõ. ");
INSERT INTO ram_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","― Ỹhỹ, tee me acrêre cakrô, ca nee ame hũpa nare. He Pahpãm te amji cahê na, me apê pahhi na me apyxwỳr to amji kam hapac. ");
INSERT INTO ram_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gapacta ne me acukrêj to ihpore na me ahpa, ne ihpore ata, ca ha gapacta ne me cupê hamreare atajê mã me agõ. Ca ha ate me ita to hajỹr na, ca ha côjkwa kam amji mã ampo jàhtôa ne me to acukrêj. Ne ihpore incjên xà itajê, quê ha côjkwa kam me gõ pore me amã to hipu tu rohnỳtti mã. Wỳr quê curi me hàhkĩj xi nõ apê ihnõ to ahkĩ, ne nee quê ha krir nõ curi apê ampo pejti ihkrẽr nare. ");
INSERT INTO ram_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ne côjkwa kam ca quêt me acukrêj pejti itajê to me amji kam gapac to me apa. ");
INSERT INTO ram_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","― He me apê ihhêj rũm me gõ pahhi jikwa tuw mã me gàpên catêjê pyràac. Ne ate hahkà na hõ amji kĩn ata to me gàhcuprõn, ne me amji cũmpej, ne me hikaj na cute me amẽn. Cwỳrjapê ca ha me amji cũmpeaj ne. Ne me atu na hê xà to me akat kà juwahi, ne me gàhcujro xà nõ mã me haxà, ne mehpôc. Quê ha cato ne ikre jarkwa cahhy, ca ha me cumã hihê mẽn pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ca ha me apê cumã me gàpên catêjê me hikaj, ne nee ame gõt pej nare, ne quêt me arĩat ame apa, ne ampo cunea caxuw ame apa, cwỳrjapê ca ha quêt me apej mã me apỳm. Na quê ha me gõ pahhia, amji tu na, ihtu na hê xà to ihtỳj, ne me apê me cumã hàpên catêjê atajê mã hàpàn xà na me akrĩ na awjahkre, ca ha me akrĩ, quê ha taa me amã me garte. ");
INSERT INTO ram_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Quê ha tee awcahti xà wỳr awcapàtkô picapôn kam, me gõ pahhi me awỳr cator cakrô, me arĩat wỳr cato, ca ha me apej mã me apỳm. Ca ha to hane, ne me apê me gõ pahhi jikwa tuw ata mã me gàpên catêjê impejti pyràac. ");
INSERT INTO ram_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","― Ỹhỹ, quê ha ikre jõ pahhi nõ, me hàhkĩj xi catêjê cator xà na me hahkre pej na, quê ha nee ikre mã jũm xàr, ne jũm te cupê ampo pyr na hamãr nare. ");
INSERT INTO ram_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ne me ca xwỳjê, ca ha me arĩat ame apa. Co he, quê ha me Ahàkà cati ate me hikaj xà jahkre pej nare ata kam, ihprõt pê me awỳr cato. Hõhõ, ata to ca ma me amji japackrea ne ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mã Petrô Jeju cukij, ne cumã: ― Ijõ pahhi, pom ca ame imã ampo jarẽ ita, xà me imã pit mã, nare, xà ajkĩ mehcunea mã? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mã nee Jeju te cumã jũ mãn nare, ne cama cumã: ― Ỹhỹ, wa ha amã ikre jamãr catê nõ jarẽ. Por quê ha hõ pahhi ikre jamãr na cumẽ ata, quê ha catyt kam, ahpỹanre na mehkwỳ mã me hõ jõr to ipa. ");
INSERT INTO ram_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Quê ha cute hõ pahhi cator xàa kam, catyt kam cumã hàpên to hajỹr na, quê ha impej mã ihpỳm. ");
INSERT INTO ram_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ỹhỹ, quê ha hõ pahhi ihtỳj cumã hàpên catê ita te ikre me, pjê me, ampo cunea jamãr catê na hãm. Quê ha ihtỳj hũpar pyrentu, ne me hàpên catêjê to kênre nare. ");
INSERT INTO ram_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","― Nãmri quê ha cute hũpar nare, ne me hàpên catêjê to impejti nare na, quê ha ihkên mã axà. Quê ha ikre jamãr catê ata amji mã: “Pỳhàpà, ijõ pahhi cator xà ita jũwrya to hũwry, ne ramã cator xà jirô pê ihpỳm, cwỳrjapê wa ha ipyxit peaj ne amji to pit mã amji kampa” hane. Ne cute hàpàn ne ihkõm kam ihtẽm, ne ipipãn kam ihtẽm, ne hõ pahhi mã hàpên catêjê kwỳ xũmre me, me cahãj cahhyr kam ihtẽm na, quê ha ihkên mã axà. ");
INSERT INTO ram_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ampo na? Quê ha nee jũ caxuw hõ pahhi te hỹrmã cator xà jõ amcro jahkre pej, ne nee hikaj nare ata kam, quê ha amji jaxà ne cato, quê ha mehpro mẽ. Quê ha ihkên ton jahpan xà na ihcura, ne cute me Pahpãm par nare atajê cuhhê xà kam cumẽ. ");
INSERT INTO ram_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","― Ỹhỹ, quê ha me hàpên catêjê nõ mã hõ pahhi jarkwa jahkre pej nare, ne cupê hahkre kêt kam nee cute amji cũmpej nare, ne apu hàpên to kêanre ata jahpan xà na, quê ha hõ pahhi nee ihcahhyr to ihtỳj nare, ne kyre pê ihcahhy. Nãmri quê ha me hàpên catêjê nõ te hõ pahhi jarkwa jahkre pej cakrô, nee amji cũmpej nare, ne nee hàpên xà to impej nare, quê ha hõ pahhi hahpan xà na, ihcahhyr to catia. Ne quê ha jũm, jũm jũhkra kam, ampo catia ne cupy, quê ha hahpan xà na hacpỹ ne ampo catia ne ahna ahwỳ. Ne quê ha jũm ampo crire ne cupy ne hahpan xà na hacpỹ mã incrire ne cugõ. Jĩkjê na mã Pahpãm me ato hanea. ");
INSERT INTO ram_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","― Ỹhỹ, ite pjê ita to cuhôn prãmte wa hỹrmã icator. Ne ramã ihpôc to mõr na ri imã to prãm. ");
INSERT INTO ram_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wa ha cormã amji pupun xà kêanre to amji pupun to hanea, pom quê, cô kam cute me amji cumrãr xà ita na, wa ha ite amji pupun xà kêanre ita kam amji cumrã. Ne imã amji kĩn nõti ita kam ahnaa ikên na amji pupun to ihhi. ");
INSERT INTO ram_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","― Mõrmõ ca atỳj amji mã me ito, ite me amã me acarĩcti jõr, ca nee ame apijapu nare prãmte, mõrmõ wa me awỳr icator na, ca me ito amji kampa. Hamreare, wa nee ita caxuw me awỳr icator nare. He wa ita kaj na, ite me ato ipicokjêr xà caxuw wa quêt icator. ");
INSERT INTO ram_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ỹhỹ, ita caxuw quê ha icwỳrjapê ikre kam cute me xĩc atajê ame ajcokjê, quê ha mencrê itajê me ipijakrut atajê kam mencryc kam ame ipa. ");
INSERT INTO ram_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ne quê ha me hũmjê xwỳjê mehkra xũmre kam incryac kam ame ipa. Quê ha mehkra xwỳjê me hũmjê kam mencryac kam ame ipa, ne mehkra cahãj atajê, quê ha menxyrxwỳ kam mencryac kam hanea ne ame ipa. Quê ha me hũprequêj hanea ne me wỳjxwỳ kam mencryac kam ame ipa. Quê ha me wỳjxwỳ hanea ne me hũprequêj kam mencryac kam ame ipa. ");
INSERT INTO ram_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","― Ỹhỹ, ca ha ita ri Juta catêjê jõ pjê kam pyt cjêj xà rũm me ahcakrã nõ pupu, quê ha hàpir to mõ, ca ha me amji mã harẽn to hane he: “Quê ha ta wrỳ” hane. Quê ha ihtỳj wrỳ. ");
INSERT INTO ram_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne ca ha hanea ne me crôtre jõ kôc cajpẽ, ne amji mã me harẽn to: “Quê ha ita kam ampeaj kam me pahcacro” hane. Quê ha ihtỳj me pahcacro. ");
INSERT INTO ram_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mẽr hõhõ, pom ihtỳj me amã ampo itajê cunea jahkre pej, ne me amã pjê me, côjkwa jarẽn jahkre pej ita. Ne mẽr ampo na mã me apê amcro ita kam, ite ampo to ijàpên xà itajê jahkre kêatre? He ca cama ame ahêaj to ame ahêj! ");
INSERT INTO ram_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","― Ne mẽr ampo na mã ca catyt kam me apa na me apê amji jahkre kêatre? ");
INSERT INTO ram_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ỹhỹ, quê ha jũ caxuw acurê xwỳn nõ apro mẽn prãmte mehcukij xà wỳr gaprôr prãm, ne gaprô. Ne pry kôt cormã ato mõr kwỳa kam, ca ha cume ajpẽn par peaj ne, ne me acator xàa kam me amji to impej. Nãmri ca ha ate me ita to hajỹr nare, ne nee me amji to impej nare na, quê ha acurê xwỳn nõ ita, mehcukij catê mã agõ, quê ha mehcukij catê ma krãhtare mã agõ, quê ha ma krãhtare me hacjên xà mã gaxà. ");
INSERT INTO ram_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","He wa ampeaj kam me amã awjarẽ, ca ha me hacjên xà kam akrĩ ita kam ahnaa, por ate acurê xwỳn to new ata to gàmjõr par nare kam, quê nee me acator nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ne amcro ata na jũmjê atajê te Jeju mã Hĩpôjajo catêjê curan xà jarẽn, ne me cumã: ― He ma Hĩpôjajo catêjê kwỳ Krĩpinkrên wỳr me mõ, cute me ampo curan, ne Pahpãm mã me hõr prãmte. Ne cormã Pahpãm mã me ampo jõr prãam kam, mã pahhi Pirat te me hipej na harkwa hyr. Mã cute me hipej ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mã Jeju me cumã: ― Ỹhỹ, Hĩpôjajo catêjê itajê tyc xà kêanre, ne mõrmõ ca me amji mã me to: “Cute mehkwỳ jirôa pê mehkên ton, cwỳrjapê ri cute me amji pupun xà kêanre ita to ame amji pupun, ne amehtyc” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hamreare, he nee mehkwỳ jirôa pê mehkrã kên nare. Ampeaj kam wa me amã awjarẽ, ca ha me caa me acunea te me akên ton jicu nare na, ca ha atỳj me cuxà ame ty. ");
INSERT INTO ram_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","― Ne por Krĩpinkrên cahê na cute me tejôjtô ne mehkrĩ atajê kam kẽn te ikre kàhti ata pỳm, ne cute me hipej atajê, mõrmõ ca amji mã me to: “Krĩpinkrên kam mehkwỳ mehkrĩ atajê jirôa pê cute mehkên ton, cwỳrjapê ri cute me amji pupun xà kêanre ita to ame amji pupun ne amehtyc” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hamreare, he nee mehkwỳ jirôa pê mehkrã kên nare. Ampeaj kam wa me amã awjarẽ, ca ha me caa me acunea te me akên ton jicu nare na, ca ha atỳj me cuxà amehtyc xà ita to ame ty ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne hipêr cute me cumã me hũjarẽn xà nõ jarẽn, cute ame hahkre pej prãmte, ne me cumã: ― Ỹhỹ, pê jũm xũmre nõ mã hõ pur kam pĩxô pàr ramã hô xàa kam, ne nee cormã hô nare. Pê ajco hô japê, tee hõmpu, ne nee ihnõ na hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ne cute pur jamãr catê mã: “Hõmpu he, ramã pĩxô pàr ita na caku crê, wa tee apu hô japê, ne nee rỳ ite hô nõ pupun nare. Ne hamre, gapacta ne pĩxô pàr ita jakep pyrentu. Cama ihcuhhê ne pjê pytà, ne nee hô nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","― Mã hamãr catê cumã: “Ijõ pahhi, ca nee ite hakep na imã gũjahkre nare caku ita kam, wa ha xa ipu na hahkwỳ, ne kam ampo jĩn to hipu. ");
INSERT INTO ram_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Quê ha ajpên caku mõ ita kam, cute hô na, quê ha ahna impej, nare, quê ha cute hô nare na, ca ha gapacta ne cormã hakep na imẽ, wa ha itỳj hakep” hane. Ne cute to hajỹr. Jĩkjê na mã Pahpãm me ato hanea, ne ihtỳj cormã me ato hamre xà to ipinhuc to mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ne mehkôt xà jõ amcro nõ na Jeju ame cumã ampo to hahkre, Juta catêjê te cuprõn xà jũrkwa kam. ");
INSERT INTO ram_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mã curi me cahãj nõ kam me pahcurê xwỳn carõ kên, ne cute apu to kêanre, mã ihkô cajõc ne cumã hà, ne jũ wỳr quê capô. Ne pê ramã ihkô ita capô nare na ahna caku te tejôjtô. ");
INSERT INTO ram_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mã Jeju te hõmpun ne cumã hàkjêr, ne cumã: ― Ỹhỹ, cahãj ita, ramã acaprãr ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne cute ahna hũ xir, mã ihkô capô pyrentu, mã cahãj ita te amji jahpan xà na, côjkwa kam Pahpãm mã impejti jarẽn to mõ, ne cumã: ― Ỹhỹ, me ijõ Inxũ Cati, ampeaj kam apej ne acati, ne ate icaprãr pyrên ijakry! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mã cuprõn xà jõ pahhi apu, Jeju te mehkôt xà jõ amcro kam jũm caprãr ata na, apu kam incryac to incryc, cwỳrjapê ri mehkwỳ mã: ― Pỳhàpà, pom me pajàpên xà caxuw amcro te xêj ita? Mẽr hõhõ, amcro te xêj itajê kam, ca ajpên me ate me amji caprãr prãm catêjê me apa, ne nee me pahkôt xà jõ amcro kam ajpên me amji caprãr prãmte me apa nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mã Jeju me cumã: ― Me apê me cumã mehhêj xi catêjê, me ahêj xi hyre nare. Pom ca me acunea me pahkôt xà jõ amcro ita kam atỳj me gõ pryti me, cawrô cahàcre mã me hê pô, ne me to apa, mã ikõ ita? Nõ na mã ca ame hane? ");
INSERT INTO ram_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mẽr hõhõ, me cahãj ita pupu he, taa xwỳjê pê me panquêtti Aprãw xwỳ tàmxwỳ tàmxwỳ nõ. Pê Xatanaj pê me pahcurê xwỳn carõ kên ihpro ne huwapre, ne ramã huwapre ita na ahna caku te tejôjtô. Xà wa ha ajkĩ me pahkôt xà jõ amcro kam nee cumã hê pôn, ne caprãr nare? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mã Jeju jarkwa ata kam Jeju curê xwỳn itajê amehpahàm. Mã me hàhtôti atajê Jeju te ampo pejti ton ata pyrên quêt ame hakry. ");
INSERT INTO ram_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mã Jeju me cumã: ― Wa ha me amã Pahpãm pê Pahhiti te pjê to ihhimpej xà ata to hahkre, ca ha me hahkre pej. He ihhimpej xà ita pê ampo hy pyràac. ");
INSERT INTO ram_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ỹhỹ, cupê ampo hy kryjre pyràac. Mã hũmre nõ te ipyr, ne hõ pur kam ihkre. Mã ampo hy kryjre ita hiprãj ne ihkà, ne ipàr pê pĩ catia pàr. Mã pryre jara ihtỳj ihpa atajê kam amji mã hahê to. Hõhõ, ita na quê ha Pahpãm te pjê to ihhimpej xà ata. ");
INSERT INTO ram_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","― Ne hanea ne cupê cuhy incrire ata pyràac. Quê ha cuhy incrire ata to me ahkêt mã haxà, quê ha ahna ahtũm nare, quê ha ihtỳj ahkêt apu ihpôc to ipa. Ita na mã Pahpãm himpej xà te hajỹr, ne mam cupê ampo kryjre pyràc, ne ma ihtỳj cati to ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pê ma Jeju Krĩpinkrên wỳr mõ, ne ajco krĩ atajê cunea kôt me cumã ampo to hahkre to ipa. ");
INSERT INTO ram_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pê jũm ata Jeju cukij ne cumã: ― Ỹhỹ, Pahhi, xà mehkên catia ata pê cute me amji pytàr xà atajê incrêre? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Mã Jeju cumã: ― Ỹhỹ, côjkwa kam Pahpãm wỳr harkwa ata jatàtre. Ca ha ate amji mã ame acarôt na, ca ha atỳj harkwa ata na ame acjêj. Wa ampeaj kam me amã awjarẽ, he me hàhtôa ne tee ame hàr to prãm, ne jũ wỳr quê me axà. ");
INSERT INTO ram_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","― Quê ha ikre jõ pahhi ikre jarkwa na ahtwỳ ne xa, ne to harkwa jihê. Ca ha põ pê ame apa, ne tee cumã me harkwa cahhy, ne tee me cumã amji jarẽn to: “Pahhi, me imã hihê mẽ, wa me axà” hane. Quê ha me amã: “Jũmjê mã ca me? Ca jũmjê itajê ame apa, ipê me gahkre kêatre” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","― Ca ha me cumã: “Por pê wa ramã me acahê na me apà, ne ame ikõ ata? Por pê ca ramã me ijõ krĩa kam ampo to me imã hahkre ata?” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","― Quê ha hipêr me amã: “Ipê me gahkre kêatre. Wa ite rỳ jũ caxuw jũmjê itajê me apupun nare. Ne me acuto, ate ame ampo to kêanre atajê!” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","― Ca ha me Pahpãm te pjê to ihhimpej xà ata kam, me Aprãw xwỳ me, Ixac xwỳ me, Jaco xwỳ me, pê mam Pahpãm jarkwa to mehcakôc catêjê atajê cunea pê me panquêtjê na me hõmpu. Ne mehkĩnte põ pê ca ha ame acwỳr to ame apa, ne me akàj xàhte me axwa gyj to me apa. ");
INSERT INTO ram_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Quê ha me hàhtôa ne me cato, pjê cunea pĩn, quê ha pyt japôj xà me, pyt cjêj xà me, ne kỳj rũm me cato, ne harã rũm me cato, ne me hàpàn xà na amehkrĩ, Pahpãm te pjê to ihhimpej xà ata ri, ca ha cama ame hõmpun to me apa. ");
INSERT INTO ram_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","― Ỹhỹ, ita kam, por hapua na me ipa atajê, quê ha jũ caxuw mam ihkrãa ri amehcuhhê, ne pjê ita kam mam mehcuhhê itajê, quê ha hapua na jũ caxuw me ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ne Jeju xa ne apu awjarẽ ata caxuw ri hỹrmã Parixêw catêjê kwỳ cator, ne Jeju wỳr me hàhtêp ne me cumã: ― Atẽm pyrentu, nãmri Heroti apu acuran to prãm ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mã Jeju me cumã: ― Me pra ne me cagã ata mã me ijarkwa jarẽn to hane he: “Wa ha ita kam ame pahcurê xwỳn carõ kên japôj to mõ, ne ame hĩ caprãr to mõ. Ne amcro incrê kam wa ha cormã ijàpên xà ita jicu” hane. ");
INSERT INTO ram_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ne wa ha itỳj ijàpên xà ita kam to icrà, ne cormã ma Krĩpinkrên wỳr ikràr, ne amcro nõ na wa icator to prãm. Nãmri rỳ jũ caxuw Krĩpinkrên kaj na Pahpãm jarkwa to mehcakôc catêjê nõ tyc nare, na wa ha curia me cuxà ty ― hane. ");
INSERT INTO ram_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ne cute Krĩpinkrên kôt harẽn to hajỹr, ne cumã: ― Krĩpinkrên, Krĩpinkrên, por akam mehkrĩ catêjê atajê hõtpê Pahpãm jarkwa to mehcakôc catêjê cura, por me Pahpãm te me amã ihkujahêc atajê, ca gõtpê ate kẽn to mehcuran prãmte ame to capê. He wa tee ame ato cuprõn prãm to hanea, pom quê hôxãhxãc hãn ne intore to hara krac ri cuprõ he. Ne ipê hôxãhxãc ata pyràac, ca ma ajte ame icaca. ");
INSERT INTO ram_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ne ita caxuw quê ha gõ krĩ caprỳ, ne kam hamreare ne. Ampeaj kam wa me amã awjarẽ, ca ha hipêr me ipupun nare ita kam, ahnaa jũ caxuw me ijarẽn to: “Por jũm Pahpãm jarkwa kôt me iwỳr tẽ ata pê impejti” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mã mehkôt xà jõ amcro nõ na Parixêw catêjê nõ te Jeju jator, hũrkwa kam me cahê na hàpàn prãmte. Mã ma Jeju ihkôt mõ, ne cator, ne hàr ne hỹr. Mã me hàhtôa ne me xa atajê ame Jeju kôpĩ. ");
INSERT INTO ram_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mã hũmre jara me ihkjê tuhti Jeju na hàhtêp. ");
INSERT INTO ram_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mã Jeju te Parixêw catêjê me, Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, mehcukij ne me cumã: ― Xà quê ha ihtỳj ajkĩ Mojxe xwỳ jõ kàhhôc ata kôt me pahte amji kam me pajapac xà na, me pahkôt xà jõ amcro kam jũm caprãr na me jũm jamã? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mã nee jũm te cumã jũ mãn nare. Mã Jeju te hũmre ata cupên ne caprãr, ne ma ihkujahêc, mã ma tẽ. ");
INSERT INTO ram_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jirô pê mã me cumã: ― Xà quê ha me anõ jõ cawrô cahàcre me, pryti nõ, me pahkôt xà jõ amcro ita kam, kwa mã mrõ, ca ha nee ajkĩ me anõ caxàr nare? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mã nee jũm te cumã ampo jarẽn nare, ne aracri mehkrĩ. ");
INSERT INTO ram_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jirô pê mã ri Jeju jỹ ne apu cute me hator atajê kôpĩ, mã ihtỳj amji mã me hỹr xà impeaj japên to me mõ. Mã Jeju te me hàpàn xà na mehkrĩ atajê japackre, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","― Ỹhỹ, quê jũm me hikwa tuw jõ amji kĩn wỳr gato, ca nee gỹr xà impeaj kam gỹr nare. Quê ihhêaj to me girôa pê jũm catia ata jato, quê ha curi cato. ");
INSERT INTO ram_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Quê ha ikre jõ pahhi te gator catê ata amã harkwa to: “Cumã gỹr xà impejti ita jahkre, quê kam jỹ” hane. Hamre, ca ha cama apu apahàm to mõ, ne mõ ne me hõa kam hapua na jỹ. ");
INSERT INTO ram_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cupate ca ha nee hajỹr nare, ne quêt hane he. Quê jũm gato, ca ihkôt mõ ne hapua na me hõa kam, gỹr xà ata kam ca jỹ. Quê ha ikre jõ pahhi ata apupu ne amã: “Ikwỳ nõ, ajpên mõ ne ita ri ca gỹr xà impejti ita kam jỹ” hane. Ita na quê ha quêt mehcunea jipôc ri me kam mare mã acati. ");
INSERT INTO ram_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","― Ỹhỹ, pom me amji to cati prãm itajê, quê ha Pahpãm me to ihkryjre ne. Ne pom amji to mehkryjre prãm atajê, quê ha quêt me to cati ― hane. ");
INSERT INTO ram_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jirô pê mã ri Jeju te ikre jõ pahhi japackre ne cumã: ― Ỹhỹ, ca ha jũ caxuw me gàpàn xà catia ton to prãm, ne nee me akwỳ nõ catêjê jator, ne me akjêjê me, me gũkjê jator nare. Ne hanea ne nee me acahê na me hakràj catêjê mehkrĩ atajê jator nare. Ca ha ate me hator na, quê ha ate me hator jahpan xà na, cute me amã hàmjõr xà na ihtỳj amcro nõ na me gato. Na ca ha nee ita to me hajỹr nare, ne quêt me to hane he. ");
INSERT INTO ram_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","― Ca ha jũ caxuw amji kĩn nõ ton to prãm, ne me cupê hamreare atajê ca ha me hato, ne cute me xwỳ jato, ne mehkjê xà jato, ne mento tũm jato. ");
INSERT INTO ram_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ca ha ate ita to hajỹr na, quê ha Pahpãm quêt apej mã amẽ. Ne jũ wỳr quê me cupê hamreare atajê, ate ame to hajỹr ata jahpan xà na, me amã amgõ. Cwỳrjapê quê ha Pahpãm, catyt kam ame ipa catêjê te hacpỹa mã mehtĩr xà jõ amcro ata kam, ihtỳj me amã amgõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mã por jũmjê me hàpàn xà na me jỹ atajê nõ te ita na Jeju par, ne cumã harẽn to: ― Taamã, por jũ caxuw Pahpãm pê pjê jõ Pahhiti te me hator, mã me hàpàn xà na me jỹ atajê ri mempej mã mehpỳm xà ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mã Jeju me cumã to hũjarẽn to: ― Ỹhỹ, por me hũmre nõ te me hàhtôa ne me hator, quê me cuprõ, quê me cumã hõ amji kĩn to. ");
INSERT INTO ram_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mã ramã amji kĩn jõ amcroa kam hàhhuc, mã cute cumã hàpên catê kujahêc, cute ame hator atajê jator prãmte. Ne me cumã harkwa kujahêc to: “Ajpên ame aprar pyrentu, nãmri ramã ampo cunea te amji jipêj” hane. ");
INSERT INTO ram_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","― Mã xãmte aracri ahpỹanre na cute me cumã amji jarẽn xà atajê. Mã mam pyxit ita te hàpên catê ita mã: “Wa ite pur jũhkàr, ne wa ita kam hõmpun prãm, cwỳrjapê wa ha nee gõ pahhi jõ amji kĩn ita wỳr imõr nare. Na wa ha awỳ, ca nee ikam acryc nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","― Mã ihnõ ita te hajỹar ne cumã: “Wa ite pjê to ipipkjêr xà caxuw pryti to tej ne hũhkàr, ne wa ita kam hàpên xà to capi prãm, cwỳrjapê wa ha nee gõ pahhi jõ amji kĩn ita wỳr imõr nare. Na wa awỳ, ca nee ikam acryc nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","― Mã ihnõ ita te hajỹar ne cumã: “Wa curmã ijikwa tuw, cwỳrjapê wa ha nee imõr nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","― Mã cumã hàpên catê ita te amji jaxàr, ne hõ pahhi mã me harẽn. Mã ame kam incryac to incryc, ne cumã: “Atẽm pyrentu, ijõ amji kĩn ita caxuw, ne pry me krĩ cape kôt ajpên me cupê hamreare atajê japrô, ne cute me xwỳ me, mento tũm me, mehkjê xà me, ca ha ame haprô” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","― Mã ma tẽ, ne ahna ahtũm nare mã cumã hàpên catê ita hacpỹ ne tẽ ne hõ pahhi mã: “Hamre, wa ite, por ate ampo na imẽn ata ton cakrô, mã cormã nee cute me ikre to hipu nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","― Mã hõ pahhi cumã: “Hipêr tẽ ne krĩ catut na pry atajê kôt ame pra atajê jator to ihtỳaj ne, ne hanea ne pur kam ne ahkêt kam ame ipa atajê jator to ihtỳaj ne, mãr quê ijũrkwa ita to me hipu tu ne. ");
INSERT INTO ram_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne ampeaj kam wa amã awjarẽ, quê ha nee mam ite ame hator atajê nõ ipê ijõ ita kwỳ krẽr nare” hane. Jĩkjê na mã quê ha Pahpãm me ato hanea ― hajỹr. Hõ, Jeju te me cumã hũjarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mã amcro nõ na hipêr me hàhtôa ne ma Jeju kôt me mõ, mã me hỹrmã ipipkjêr ne cute me cumã hũjarẽn to: ");
INSERT INTO ram_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","― Ỹhỹ, ca ha me anõ te ikôt apa prãm na, quê ha ihtỳj me anõ mã ikĩn, ca ha ikôt apa. Ne me apãmjê jirôa pê amã ikĩn, ne me axyrxwỳ me, me aprõ me, me akra me, me akjêjê me, me akjêjê cahãj jirôa pê me amã ikĩn. Nãmri ca ha itajê jirôa pê amã ikĩn nare, ne amji jirôa pê amã ikĩn nare na, ca ha nee apê ikôt ipa catê nare. ");
INSERT INTO ram_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne quê ha jũm mã ikôt amji ton to prãm na, quê ha jũm ata ihtỳj amjia kôt ipa jicu, ne ikôt pit mã ipa, ne amcro cunea kam icuxà, hõ pĩ na ihtyc xà ita japjê. Nãmri quê ha amã ita to hajỹr prãm nare na, ca ha nee jũ caxuw apu ikôt apa nare. ");
INSERT INTO ram_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","― Ỹhỹ, ca ha me anõ ikre kàhti nõ xãm prãm, ne mam jỹ ne amji kampa, ne gõ pore cahyt, mãr ca hahkre pej, jũ mã quê ha gàpên xà ata hàhwỳr to. Ne jũ mã quê ha apê gõ pore to ne capa. ");
INSERT INTO ram_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ca ha nee apu amji mã hahkre pej par nare ne kam to tẽ, ne apu ihhê pit pyxwỳ, ne nee hipêj nare. Quê ha mehcunea me ikre ita pupu, ne me ato hapactu kam tẽ, ne me ajpẽn mã, ");
INSERT INTO ram_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Me hõmpu he, hũmre ita te ikre ton kam ihtẽm, ne nee cute hicu xà mã to mẽn nare” hane. Ca ha atỳj apu apahàam to apahàm. ");
INSERT INTO ram_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","― Ne ihnõ xwỳjê te hajỹar he. Quê ha krĩ pijakrut jõ pahhiti atajê me ipijapu to prãm, ne ihnõ mã hõ krãhtare jàhtô te mir te tej, ne hirôa pê ihnõ ita mã hõ krãhtare te mir te winti. Quê ha me harẽn pa, ne jỹ ne to amji kampa, ne amji mã: “Pỳhàpà, me ijirôa pê me icatêjê jàhtô, wa ha pijamã me cuna mã mencrêre itajê to ahtwỳ? Jũ wỳr wa ha me to amji mã hamã” hane. ");
INSERT INTO ram_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ne ihtỳj me catêjê jõ pahhiti nõ ata mã harkwa kujahêc pyrentu, cormã ampỳre mã apu mõr reria mã, mãr quê nee ame ipijapu nare. ");
INSERT INTO ram_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","― Mẽr hõ, ca ha me amji kampa, ne me gàhcukrêj cunea mã me hikra, ne cormã ikôt me apa catêjê na me amji to. Nãmri ca ha ate me to hajỹr nare na, ca ha nee me apê me ikôt me apa catêjê nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ne hipêr Jeju me cumã: ― Hõtpê caaxwa pê ampo pejti ata, ne quê ha hàn nõ mã axà, jũ mã cu ha me to, ne hacpỹ mã me to wa? ");
INSERT INTO ram_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Hamre, quê ha ihkên mã axà, ne ampo cunea caxuw ramã ihkêanre, ne nee ampo xô mã cute pjê to caxà xà na impej nare. Na cu ha me pahtỳj caaxwa xen nỹre ata to me awcapê. Por ate me ipar xà na, me akam me gapac ihcuhhê ata, mẽr me to ikam gapac to impeaj ne ― hane. ");
INSERT INTO ram_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ne amcro nõ na Jeju wỳr me hàhtôa ne me mõ, cute mempar prãmte, mã pahhiti jarkwa na me hũhkra kam me hàmcwỳr catêjê jàhtôa ne ihwỳr me mõ, ne mehkwỳ te amji kam me hapac xà kêanre. ");
INSERT INTO ram_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mã Parixêw catêjê me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, cute me Jeju te mehkrã kên catêjê mã ampo to hahkre na me hõmpun, ne me ahna xwỳ kam mehtẽm, ne me ajpẽn mã: ― Me hõmpu he, hũmre ita ihtỳj mehkên na amji to pôj, ne me cape na apà ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mã Jeju te me hapackre kam ihtẽm, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","― Ỹhỹ, quê me anõ mã carà cahàcre hôhti te xẽj, ne pyxit ne apê acto, xà ca ha ajkĩ nee hapên nare? Ca ha atỳj cute nowẽntinowi atajê mã põ kam hikra, ne ma pyxit ata japên to mõ, ne cumã acato. ");
INSERT INTO ram_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ne hũrên gakry, ca ha apỳ ne ma to amji jaxà. ");
INSERT INTO ram_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ne ikre mã to acato, ne acahê na gõ ikwỳ nõ mehkrĩ atajê to cuprõ, ne me cumã: “Me gakry, nãmri wa ite carà cahàcre hôhti pictor ata mã icator” hane. ");
INSERT INTO ram_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","― He me apê carà cahàcre hôhti jàhtô na, cute nowẽntinowi atajê pyràac, ne atỳj amji pej na me amji cãmjĩ. Ne por me anõ pyxit te ihkên jicu, ne hacpỹa mã Pahpãm wỳr amji jaxàr ata pê ri carà cahàcre hôhti pyxit pictor ata pyràac. ― He wa ampeaj kam me amã awjarẽ, ita kôpit na, quê ha côjkwa kam mehkrĩ atajê ihtỳj me apej catêjê pyrên ame hakry. Ne por quê ha jũm pyxit peaj ne ihkên jicu, ne catyt kam ipa kam tẽ, ata pyrên quê ha côjkwa kam mehkrĩ atajê me girôa pê me hakry. ");
INSERT INTO ram_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","― Ne ihnõ xwỳjê, quê ha cahãj nõ mã wakỳre prà jakare te ihpore hy tej, ne cupê pyxit ne acto, quê ha ihtỳj hapê. Ne cute cumã cator xà caxuw, quê ha hàhcujro xà nõ pôc, ne ikre capõ ne hapên to impeaj to mõ, ne ihtỳj cumã cato. ");
INSERT INTO ram_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne me hõ ikwỳ nõ catêjê me, me cahê na amehkrĩ atajê to cuprõ, ne me cumã: “Me gakry, ite ihpore hy pictor ata mã icator” hane. ");
INSERT INTO ram_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","― He wa ampeaj kam me amã awjarẽ, ihpore hy pictor ata pê jũm te ihkên ton to ipa ata pyràac. Ata kôpit na, quê ha Pahpãm jarkwa to imprar catêjê côjkwa kam, por jũm pyxit peaj te amji kam hapac xà kên mã hikran, ne hacpỹa mã Pahpãm wỳr amji jaxàr ata pyrên, quê ha ame hakry. ");
INSERT INTO ram_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","12","― Ne ihnõ xwỳjê te hajỹar. Ỹhỹ, pê jũm xũmre nõ mã ihkra xũmre ajkrut. Pê amcro nõ na hapu na ihkra intuw ita hũm ita mã: “Inxũ, ita kam imã ate atyc jirô pê imã ampo jõr xà atajê gõ. Jũ wỳr wa ha atyc xà ita jikaj” hane. Mã hũm te cume amji mã ampo to ipicapôn. ");
INSERT INTO ram_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","― Mã ahna amcro jàhtô nare, mã hapu na ihkra ita te ampo to hõ tekjê ita to cuprõn, ne ma pjê nõ wỳr to mõ. Ne curia ihkrĩ, ne cute ihkên to amji to hipu tu, ne por cute hũm pê ampo cwỳr atajê to ampo kên cunea na hamre partu. ");
INSERT INTO ram_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","― Ne hamre, cute ampo to hamre jirô pê, ampeaj kam pjê ata kam me cumã prãm cati. Mã prãm te kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mã cute pjê ata kam jũmjê krĩ atajê na hàhwỳr, cute me cumã hàpên ne amji mã harte prãmte. Mã cute crô to ipijapar xà wỳr mehkujahêc, cute crô mã harte, ne me cumã hamãr xà na. ");
INSERT INTO ram_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mã curia apu crô jamãr to ipa, ne ampeaj kam cumã prãm. Mã tee crô jõ ata kwỳ krẽr to prãm cakrô, mã nee jũm te cumã crô jõ ita kwỳ jõr nare. ");
INSERT INTO ram_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","― Mã cute hỹr, ne amji kam hapac ne amji mã: “Ampeaj kam inxũ mã me hàpên catêjê jàhtô, ne me cumã hõ cati, ne cute me hakren tu. Wa mehkĩnte ajte ita ri tee prãm to amji curan prãm. ");
INSERT INTO ram_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ne wa ha ma inxũ wỳr amji jaxà, ne cumã amji jarẽn to hane he: ‘Inxũ, wa ite côjkwa kam Pahpãm me, acuna mã ikêanre ton. ");
INSERT INTO ram_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na wa nee hipêr ate ito amji kra na ana ijàhwỳr nare. Ca ha ito amji mã cama amã ijàpên catê’ ” hane. ");
INSERT INTO ram_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne ma hacpỹ mã hũm wỳr cute amji jaxàr. ― Ne hũm wỳr cator to mõ, mã hũm te pry cãmpun, mã cormã ampỳa mã mõ. Ne cumã caprĩ, mã hỹrmã tẽ ne cute impỳn, ne cahôr. ");
INSERT INTO ram_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","― Mã cumã: “Inxũ, wa ite côjkwa kam Pahpãm me acuna mã ikêanre ton. Na wa nee hipêr ate ito amji kra na ana ijàhwỳr nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","― Mã hũm te cumã me hàpên catêjê nõ mã harkwa hyr, ne me cumã: “Ame kware ne ajpên me cumã ihkà impeaj nõ to tẽ, ne me cumã haxà, quê to ihkà. Ne hũhhi na hê xà nõ to cumã me hũhkrahhi na hê, ne hanea ne ihpar kà nõ mã me haxà. ");
INSERT INTO ram_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne hanea ne ajpên me pryti krahti nõ jicotti to me mõ, ne mehcura, cume to amji kĩn to. ");
INSERT INTO ram_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nãmri, wa ikra pictor ita tyc na amji mã to hajỹr cakrô, mã ihhêj ne hacpỹa mã ihtĩr ne mõ ne cator, cwỳrjapê ri hũrên ijakry” hane. Ne cute amji kĩn kam me to ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","― Ne cormã ame amji kĩn ita toan kam, mã ihkra kà ita pur kam apu apê. Ne cute amji jaxàr, ne ramã ikre na hàhtêp to mõ, ne cute me hõkrepôj me, me hàkrun jàhkrihkrit kam hapac. ");
INSERT INTO ram_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne cute me hàpên catêjê nõ na hàhwỳr, ne ihcukij ne cumã: “Ampo na mã ame hane?” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","― Mã hàpên catê nõ ata cumã: “Gapyre te amji jaxàr ne impej pêa mã cator. Cwỳrjapê ri apãm te amji kĩn ita caxuw pryti kra jicotti curan na me imẽn, wa ite mehcuran, mã ame to amji kĩn” hane. ");
INSERT INTO ram_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","― Mã ihkra kà te ita kam hapac, ne apu kam incryc. Ne ma apu ikre mã hàr caca, ne ma amehkôt amji kĩn ita na amji ton caca. Mã hũm põ mã cator, ne tee apu to hàr to hahkre. ");
INSERT INTO ram_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mã cute hũm mã: “Rỳ pêa mã wa ipê amã ijàpên catê pyràac, ne amã ijàpên to ipa. Ne nee wa rỳ jũ caxuw ite garkwa par caca nare cakrô, ca rỳ jũ caxuw ate imã carà cahàcre nõ jõr, wa ite ijõ ikwỳ nõ catêjê me, me to amji kĩn nõ ton nare. ");
INSERT INTO ram_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mã akra kêanre ita te, por me cahãj pijapit xyre atajê na, ate cumã ampo jõr atajê rẽn partu. Ne cute amji jaxàr, ca ate quêt cumã pryti jicotti ita curan, ne ame to amji kĩn” hane. ");
INSERT INTO ram_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","― Mã hũm te cumã: “Ikra, apu hajỹr nare, ca gõtpê icahê na apu apa. Ne wa ampo cunea to itekjê itajê, pê atekjêa ri. ");
INSERT INTO ram_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ne ampeaj kam wa ite amji kĩn ita ton na amji mã prãm, me pajakry prãmte. Ampo na? He me pamã amji kĩn nõti ita na ipê ihkaj na. Ne ampo na wa ite ita ton? He gapyre ita ramã ihhêj ne ihtyc, ne hacpỹa mã ihtĩr, ne hanea ne ipictor ne hacpỹa ne cator cwỳrjapê wa ite ton” ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ne Jeju te hipêr ihkôt me ipa catêjê mã hũjarẽn, ne me cumã: ― Ỹhỹ, por hakràj cati nõ mã hũrkwa jamãr catê. Mã jũmjê atajê te ikre jõ pahhi mã, cama cute apu cupê hõ tehkrêj rẽn to ipa na harẽn to kêanre. ");
INSERT INTO ram_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mã cute ahna hàhwỳr ne cumã: “Pỳhàpà, xà ampeaj kam mã me garẽ? Krãa caxi, imã amji jarẽ, ne imã ijõ ampo itajê cunea na ihhôc. Ne cute me ito new catêjê japrỳ atajê cunea na imã ihhôc, wa gàpên xà jahkre pej. Ne ca ha nee hipêr apê imã ijũrkwa jamãr catê nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","― Mã hũjamãr catê ita mõ ne hỹr, ne cute amji kam hapac ne amji mã: “Pea hito, wa itea amji pê ijàpên xà ita to ipictor. Ne nee imã icarôt cati nare ite pjê jahkwỳn xà caxuw, ne me ahna ijàhwỳr na ipahàmti ita kam, ampo to mã wa ha ajte? ");
INSERT INTO ram_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ỹhỹ, wa ite hajỹr ita kam, quê ha ijõ pahhi ikujate, wa ha nee hipêr cute me to new catêjê jũhkra kam ijàmcwỳr to ipa nare. Ne wa ha to hane, wa ha mam cute me ijõ pahhi to new catêjê to impeaj ne, mãr quê cute ijàpên xà pê icator jirô pê, ihtỳj me hũrkwa kam me ijuwahi. Ne me taa me itehcajpa” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","― Ne cute me hõ pahhi to new catêjê cunea na hàhwỳr. Mã cute me cuprõn, mã cute ahpỹanre na mehcukij par. Ne cute mam ita cukij ne cumã: “Jũ mã ca ate ijõ pahhi to new ton?” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","― Mã cumã: “Hàhcujro xà cacô incjên xà te xẽj to wa ite to new” hane. Mã cumã: “Ihnãm ate new na gõ kàhhôc ita he, to jỹ ne cute xĩncwẽnta peaj na, ca ihhôc” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","― Ne cute ihnõ ita mã: “Ne ca, jũ mã ca ate new ton?” hajỹr. Mã cumã: “Arỳjhy incjên xà te mir to wa ite to new” hane. Mã cumã: “Cute ôjtôxẽnta peaj na ca ihhôc” hane. Ne cute me to new catêjê cunea to hajỹr partu. ");
INSERT INTO ram_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","― Mã hõ pahhi te ita par, ne cumã: “Ahêj xi cakrô, ampeaj kam ate amji jahkre pej” ― hajỹr. Ne Jeju te ihkôt me ipa catêjê mã: ― Ỹhỹ, ihhêj ne catyt kam me ipa nare catêjê atajê te ri, catyt kam me ipa catêjê jirôa pê me amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cwỳrjapê wa me amã: “Gapacta ne amji to me gakràj, ne gapacta ne catyt kam me ipa nare catêjê to me amji kwỳ nõ. Quê ha jũ caxuw amã ampo atajê cunea apê hamre, quê ha me gõ ikwỳ nõ catêjê ihtỳj me hũrkwa kam me ana amji to pôj” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","― Ỹhỹ, quê ha jũm hõtpê ampo kryjre atajê jamãr to impejti na, quê ha hanea ne ampo catia jamãr to impeaj ne. Quê ha jũm apu ampo kryjre atajê to ihhêj to ipa na, quê ha hanea ne ampo catia to ihhêj to ipa. ");
INSERT INTO ram_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ỹhỹ, ca ha pjê ita kam me gàhcukrêj to ame ahêj to me apa, quê ha nee jũm me amã Pahpãm jàhcukrêj nõ jõr nare. ");
INSERT INTO ram_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na ca ha jũm jàhcukrêj to ate ame ahêj to me apa na, ca ha nee me gàhcukrêj cwỳr nare. ");
INSERT INTO ram_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","― Ne jũ wỳr quê jũmjê hõ pahhi pijakrut jarkwa kôt me ipa. Ampo na? Quê ha cumã hõ pahhi pyxit nõ ata pit kĩn, quê ha cumãa apê. Ne ma apu ihnõ ita caca, ne hicu ne cumã hikra. Ita jĩkjê na, ca ha Pahpãm mã me apê, ne nee ate mehpore catia ne ipyr na, me amji cãmjĩ nare. Nãmri ca ha ate ihpore ita to pit mã me amji japackre na, quê ha cupê ihhêj rũm me gõ pahhi, ca ha ihkôat me apa ne atỳj Pahpãm mã hikra ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mã Parixêw catêjê mã ihpore pit kĩn atajê te me ita par, na ri ame Jeju xũn. ");
INSERT INTO ram_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mã Jeju me cumã: ― Ihhêj ne mehcunea cuna mã me apê me hũmre impejti, ne Pahpãm mã ri quêt me ate amji kam me gapac xà cunea jahkre pej. Ỹhỹ, me hũmre mã pjê kam ampo pej ne cati na prãm atajê ri, Pahpãm mã ihkĩn nare, ne ahna cupê ihkêanre. ");
INSERT INTO ram_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","― Pê Jowãw te me cumrãr catê cator xà wỳr, ihtỳj ajco me Mojxe xwỳ jõ kàhhôc kampa, ne me Pahpãm jarkwa na ihcakôc catêjê kampa, ne ajco ihkôat ame ipa. Ata japu na, wa mehcunea mã Pahpãm pê pjê jõ Pahhiti na harẽn to mõ, ne ahpỹanre na Pahpãm himpej xà mã mencjêj prãmte ame amji mã carôt. ");
INSERT INTO ram_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Xà quê ha pijamã jũ caxuw côjkwa me pjê hamre? He quê ha ihtỳj jũ caxuw hamre, ne Pahpãm jarkwa nare, quê ha quêt jũ caxuw hamre nare. Quê ha nee Mojxe xwỳ jõ kàhhôc kam hàhhôc kryjre hikwa itajê nõ ipictor nare. ");
INSERT INTO ram_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","― Ne quê ha me hũmre nõ apu hĩxi caca ne cumã hikra, ne ma tẽ ne ajteare mã cahãj nõ me hikwa na, quê ha cupê hũmre inxyre ata, ne ihkêanre ne. Quê ha cupê hũmre nõa te cahãj mã hikran ata me hikwa ata, ne hanea ne cuxà inxyre ne, ne ihkêanre ne. ");
INSERT INTO ram_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","― Ỹhỹ wa ha me amã me hakràj te amji kam hapac xà kôt harẽ. Ỹhỹ, pê hũmre nõ jakràj cati, ne ajco ihkà impej to pit mã ihkà, ne ajco amcro cunea kam hõ impej pit kur to ipa, ne ajco amji kĩn catia ton to ipa. ");
INSERT INTO ram_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pê hanea ne hũmre nõ pê hamreare ata japrỳ Raxaro. Ne ihkà xêt, ne hĩ cunea kam ahna cuhê. Pê Raxaro jũkjê atajê ajco hũmre jakràj cati ata wỳr me to pra, ne hũrkwa jarkwa mã me cunõ. ");
INSERT INTO ram_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pê ajco curia harkwa mã hikwa. Por hakràj catê ata jàpàn xà pê hõ pihur, mã cute to harte prãmte ajco hikwa. Pê hanea ne rop ajco hỹrmã pra ne cumã cuhê atajê cũmtwỳ. ");
INSERT INTO ram_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","― Ne ty, pê me hĩ jarêt, pê Pahpãm mã imprar catêjê côjkwa pĩn, ma mempejti tyc atajê krĩ xà wỳr me caxwỳn to tẽ, ne me panquêtti Aprãw xwỳ kjê kam me hỹr, pê huwahi ne to jỹ. Pê hanea ne hakràj catê ata ty, pê me hĩ jarêt. ");
INSERT INTO ram_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","― Pê Raxaro kĩnte mehtyc kêanre atajê krĩ xà kam, cute me amji pupun xà kêanre xà ata kam amji pupu. Ne irĩt, ne ihmat ri cute Aprãw xwỳ pupun, ne cute hĩkjê rũm Raxaro xwỳ pupun. ");
INSERT INTO ram_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ne cumã caràr to: “Quêtti Aprãw, icaprĩa ne! Imã Raxaro kujate, quê cô to hũhkrahhi inco ne to ijarkwa jakry! Ampo na? He wa cuhy ita kam amji pupun xà kêanre to amji pupu!” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","― Mã Aprãw cumã: “Itàmxwỳ, he pê ca cormã atĩr reria mã ajco quêt amji mã ampo pejti cunea incwa ata to ca amji japackrea ne. Pê Raxaro ajco akĩnte girôa pê amji mã ihkên pit cwa. Ne ita caxuw ri quêt imã caprĩ, mã apu hakry ne ampo ita cunea to amji mã amji kĩn. Ca ihkĩnte, ita caxuw amji pupu he. ");
INSERT INTO ram_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne xwỳjê mã, me pahcote na pjê catacti ita kam, cu nee me pahnõ ajpẽn wỳr parêr nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","― Mã hakràj cati ita cumã: “Ỹhỹ, quêtti Aprãw, wa ha awỳ, ca kepê inxũ jũrkwa wỳr Raxaro kujate. ");
INSERT INTO ram_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Quê cormã curi me ikjêjê te xĩc ne me hàhhuc atajê mã mehkên cawpa, mãr quê mehkên ton jicu, ne nee ikrĩ xà kêanre ita wỳr memprar, ne icuxà me amji pupun xà kêanre to hajỹr nare” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","― Mã Aprãw cumã: “Pom ramã me akjêjê mã Mojxe jõ kàhhôc me, Pahpãm jarkwa na mehcakôc catêjê jõ kàhhôc itajê. Ne quê ha taa me cumã ita to hahkre, ne me hapackre ne me cumã ihcawpa. He me cumã ihcawpa xà ita caxuaw ri ihkàhhôc atajê” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","― Mã cumã: “Hamreare quêtti, jũ wỳr quê ha ihkàhhôc itajê kampa. Quê ha quêt jũm tyc ata hacpỹa mã ihtĩr, ne me hỹrmã cato, quê ha ihtỳj me kampa, ne mehkên itajê jicu” hane. ");
INSERT INTO ram_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","― Mã Aprãw cumã: “Quê ha cute nee Mojxe jõ kàhhôc par nare, ne hanea ne nee me Pahpãm jarkwa na ihcakôc catêjê jõ kàhhôc par nare na, quê ha nee jũm hacpỹa mã jũm tĩr ata kam hapac nare” ― hane. Hõ, Jeju te Parixêw catêjê mã hũjarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Ne Jeju te hipêr ihkôt me ipa catêjê mã: ― Ỹhỹ, ampeaj kam quê ha hõtpê mehkwỳ, Pahpãm cuna mã mehkên xà kêanre to. Ne pỳj me xi, por cute me cumã mehkên to hahkre, ne me cumã to mehhimpej atajê, quê ha ame amrãa to ame amrã. Ampo na? He quê ha Pahpãm, por cute jũmjê kryjre mã mehkêanre to hahkre atajê, quê ha Pahpãm mehkên mã me cumẽ. Ne mehkên mã me hàr xà ata ri ihkêanre. Quê rỳ mã mehkên kêanre ata xwỳjrea na memput na kẽn pytĩa nõ mã hê, ne côxwa tua kam ahna me cumẽ, quê cô me hipej. ");
INSERT INTO ram_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Co he, me guphê! Quê ha atõ ampo to ato kên, ca ha intête cumã. Quê ha ihkên ita jicu, ca ha cute ato kên ata to tojnõ, ne nee to amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Quê ha atõ, amcro pyxit kam, ato kên to xet, ne awỳr pra ne amã: “Wa ha ite ato kên ita jicu. Ne nee hipêr ato hajỹr nare. Ikam acryc nare” hane. Ca ha atỳj cute ato kên ita to tojnõ, ne nee to amji japackre nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mã ihkôt me ipa catêjê te ita na me Jeju kam hapac, cwỳrjapê ri cute ahna me hàhwỳr to: ― Ỹhỹ, me ijõ Pahhi. Wa me hirôa pê amji mã me ato ihimpej na me itehcajpa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mã me cumã: ― Ca nee cormã ito amji mã me ahimpej nare. Kepê ca ito amji mã me ahimpej kryjre to hanea, pom quê ampo hy kryjre ita he, ne atỳj ampo pĩ pàr catia xa ita mã garkwa ta, ne cumã: “Garê mea mã amji capa, ne ma côxwa kam amji kre” hane. Quê ha pĩ pàr ita ihtỳj me akampa, ne me akam hapac to kênre nare, ne ma côxwa kam amji kre ― hane. ");
INSERT INTO ram_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ne hipêr me cumã: ― Quê jũm cama me anõ mã hàpên catê na ipa, ne amã pur kam apê, ne amã carà cahàcre hôhti jamã, ne pyt xàr xàa wỳr pur pĩn amji jaxà, ca ha ajkĩ cumã: “Hamre, ate gàpên xà jicu ita kam gapacta ne gàpàn xà na jỹ ne apà” hane? ");
INSERT INTO ram_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jũ wỳr ca ha cumã hane. Ca ha ajteare mã cumã garkwa to: “Hamre, ita caxuw ca ha akà pro xà to amji pro, ne imã ijõ nõ to, ne imã agõ, wa ha apà ne ikõ, jirô pê mã ca ha gapacta ne apà” hane. ");
INSERT INTO ram_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nare ca ha ajkĩ amã hàpên catê ata mã: “Ca ate ipar pejti, ne ate itehcajpar to catia, cwỳrjapê ri apyrên ijakry” hane? Jũ wỳr ca ha cumã garkwa to hane. ");
INSERT INTO ram_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","― Mẽr hõhõ, he me apê hàpên catê nõ ata pyràac. Na ca ha ate me, pom ite ampo cunea na me amẽn itajê ton na, ca ha me amji jarẽn to hane he: “Me ipê me amã me ijàpên catêjê kêanre, wa me ite, por ampo na ate me imẽn ata to pit mã me ijàpên, ne nee garkwa jirô pê, amjia kôt hipêr me ijàpên nare” ― hane. Hõ, Jeju te ihkôt me ipa catêjê mã to hahkre to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pê ma Jeju Krĩpinkrên wỳr mõ, ne Krĩrĩtpej me Hĩpôjajo jõ pjê te ajpẽn mã ahhyr cajpuw mõ. ");
INSERT INTO ram_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ne ramã krĩ jacot mã hàr xàa kam, pê mehkà xêt catêjê me tej ne hỹrmã me pra. Ne ampỳa mã me ahtwỳ ne me xa. ");
INSERT INTO ram_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ne ame caràr, ne me caràar kam me Jeju na hàhwỳr to: ― Pahhi pê Jeju! Me icaprĩa ne! ― hane. ");
INSERT INTO ram_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mã Jeju te me hõmpun, ne me cumã: ― Amũ me pra, ne Pahpãm mã mehcajrẽn catêjê wỳr me axà, quê me gaxàjre ata jakàn pê ame apupu, ne ame akôpĩr to impej, ne ame gakrô ― hajỹr. Mã me hỹrmã memprar kwỳa kam, mã ramã mehcunea impej to mõ. ");
INSERT INTO ram_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mã mehkà xêtti atajê nõ te ramã caprãr na amji cajpẽr, ne amji kà pupun, ne Jeju wỳr amji jaxàr pyrentu, ne kỳj cati pêa mã caprãr pyrên hakryti na, côjkwa kam Pahpãm to hàmnãn to mõ. Ne jũm ata pê nee Juta catêjê nõ nare, ne cupê Krĩrĩtpej jõ pjê catêjê nõ. ");
INSERT INTO ram_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne Jeju wỳr cator, ne cuna mã hõ pôrpo ne nõ, ne cumã: ― Ỹhỹ, ikrã tũm ampeaj kam apej, ne ate icaprãr xà ita pyrên ampeaj kam ijakry ― hane. ");
INSERT INTO ram_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mã Jeju te ihcukij ne cumã: ― Pỳhàpà, jõ ri mã me akwỳ cahhur? Xà nee ite me acunea caprãr nare na mã apyxit peaj te amji jaxàr? Jõ ri mã me akwỳ kwỳ te me nowi atajê? ");
INSERT INTO ram_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ampo na mã apê mehcahkrit pê nee Juta catêjê nõ nare ita te pit mã amji jaxàr, ne Pahpãm mã hũrên gakry na amji jarẽn to mõ? ");
INSERT INTO ram_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","To xa ne mõ. Ca ito amji mã ahimpej, cwỳrjapê ri ramã acaprãr pejtu ― hajỹr, mã ma tẽ. ");
INSERT INTO ram_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mã amcro nõ na Parixêw catêjê nõ te Jeju cukij, ne cumã: ― Jũ caxuw mõrmõ quê ha Pahpãm pjê cunea to ihhimpej kam tẽ? ― hajỹr. Mã Jeju cumã: ― Quê ha ihtỳj Pahpãm cato, cute pjê ita to ihhimpej xà caxuw. He jũ wỳr ca ha ampo pupu, ne ihkôt amcro nõ na cator xà ata jahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Quê ha ihprõt pê cato. Cwỳrjapê jũ wỳr quê ha jũm amã harẽn to: “Hõmpu he, pjê ita to ri Pahpãm himpej xà” hane. Nare, quê ha amã: “Hõmpu he, ihmat ri pjê ata to quê ha ihhimpej” hane. He ramã Pahpãm te me acaxwãm pê, me anõ mã, cute amji kam hapac xà to ihhimpej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mã cute mehkôt me ipa catêjê mã: ― Quê ha jũ caxuw ipê me Ahàkà jõ amcro kam ahtwỳ, ca ha amcro atajê pupun prãm cakrô, nee hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Quê ha mehkwỳ me amã: “Ita ri ca Pahpãm pupu he” nare quê ha me amã: “Ihmut ri ca hõmpu he” hajỹr cakrô, quê ha nee cator xà hajỹr nare. Cwỳrjapê ca ha nee me harkwa kôt apu hapên to apa nare. ");
INSERT INTO ram_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Quê ha ipê me Ahàkà jõ amcro ihprõt pê cato. Quê ha me icator xà pê ihhêj rũm pahhàjê cuxê pyràac. Pom pahhàjê cuxê ne côjkwa cunea cujro ita na, quê ha icator xà hane. ");
INSERT INTO ram_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ne icator xà ita wỳr, quê ha xa me amji pupun xà kêanre to me amji pupu, ne ame icurê. ");
INSERT INTO ram_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","― Ne por pê me panquêtti Nowe xwỳ jõ amcro ajco hapôj ata na, quê ha me ijõ amcro hane. ");
INSERT INTO ram_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ne por ihtỳj ajco mehcunea me apà ne me ikõ to me ipa. Ne nee amji na me ampo cãmjĩ nare kam, me hũmre me pyjê ajco me hikwa tuw to mõr ata kam, pê ahnaa Nowe xwỳ te pàr kreti mã hàr jõ amcro kam ahtwỳ. Ne me hàr jirô pê, pê cô cati cato, ne mehkwỳ jipej tu. ");
INSERT INTO ram_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","― Ne menquêtti Ro xwỳ jõ amcro ata kam pê me hanea. Ne nee amji na me ampo cãmjĩ nare kam mehcunea ajco me apà, ne ajco me ikõ, ne ajco ame ampo jũhkàr to me ipa, ne ajco ihpore to ampo na me hàhpan to me ipa, ne ajco pur kam ame ampo hy kre to me ipa, ne ajco amji mã me ikre pyxwỳr to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ata jõ amcro kam, pê Ro xwỳ Krĩhpôc jõ krĩ pê cato, pê ihprõt pê kẽn te cuhy côjkwa pĩn ihpỳm, ne krĩ me, mehkwỳ cunea to caxàr tu. ");
INSERT INTO ram_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","― Hõ, quê ha me Ahàkà cator xà jõ amcroa kam ahtwỳ, quê ha hanea. ");
INSERT INTO ram_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ne amcro ata kam, ca ha me anõ ikre jõ mã ahtyc mã apu mõ, ne ma atẽm pyrentu, ne nee ampo pyr prãmte gũrkwa mã axàr nare. Ne me anõ pur kam apu apê, ne nee hacpỹ ne gũrkwa wỳr atẽm nare. ");
INSERT INTO ram_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Co he, Ro xwỳ prõ te hacpỹ mã Krĩhpôc jõ krĩ wỳr ihtẽm prãm, cwỳrjapê ri ihtyc, na ca me to amji japackre. Na ca ha nee me hajỹr nare! ");
INSERT INTO ram_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Quê ha jũm apu ihtĩr prãm, ne ihtỳj amji to acto. Ne jũm te amji to ipictor prãm ata, quê ha Pahpãm cahê na ihtĩr rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","― Ne caxwa ata kam, quê ha me hũmre ajkrut ne me nõ, me hikwa xà kam, quê ha pyxit ne me haprô, quê ha pyxit ne ahtwỳ. ");
INSERT INTO ram_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Quê ha me cahãj me ajkrut ne ame arỳjhy twỳ, quê ha me pyxit ne me haprô, quê ha pyxit ne ahtwỳ. ");
INSERT INTO ram_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ne me hũmre ajkrut ne pur kam ame apê, quê ha me pyxit ne me haprô, quê ha pyxit ne ahtwỳ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mã ihkôt me ipa catêjê te mehcukij, ne me cumã: ― Jeju, jõ ri quê ha ita hane? ― hajỹr. Mã Jeju me cumã: ― He me apê xônti pyràc, ne nee cormã ne ate me hahkre pej xà nare cakrô, quê ha jũ ri cumã ampo ty, quê ha ihtỳj ahna cuprõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Quê hãn ne hõtpê Pahpãm mã mehcakôc, ne nee quê jũ caxuw intête me amji hi kwĩn nare, prãmte ri Jeju te me cumã hũjarẽn xà ita jarẽn. Hõ, cute harẽn to hajỹr he: ");
INSERT INTO ram_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","― Ỹhỹ, pê hũmre nõ ata pê mehcukij catê, ne cupê me hõ pahhi. Ne nee ajco amji mã Pahpãm cupa, ne harkwa kôt ipa nare. Ne hanea ne nee cumã jũm cupa nare, ne krĩ nõ ita kam ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pê hanea ne krĩ ata kam jũm cahãj pê impjên ty ata ihkrĩ. Ne ahte ajco apu ipa. Ne ajco mehcukij catê wỳr pra ne cumã: “Itehcajpa, ne icurê xwỳn ata na ahcukij, ne cumã garkwa ta, quê hacpỹa ne imã ampo pê itekjêa atajê gõ” hane. ");
INSERT INTO ram_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","― Pê amcro jàhtôa kam ma mehcukij catê ita apu cahãj ita tehcajpar caca. Pê ajco mãnea mã cahãj ata amji caxuw ihcukij to ipa. Mã jũ ita caxuw cute amji mã: “He nee imã Pahpãm cupa nare, ne nee imã jũm cupa nare cakrô, wa ha itỳj cahãj ita tehcajpa. ");
INSERT INTO ram_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ampo na? Cahãj ita cama apu icahpêrkàr to ipa, cwỳrjapê wa ha ahcukij ne hũtà. Nãmri wa ha ite to hajỹr nare na, quê ha ihtỳj ito hamre” ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne Jeju ihkôt me ipa catêjê mã: ― He mehcukij catê kêanre ita jarẽn kam me gapac to impeaj ne. ");
INSERT INTO ram_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","He Pahpãm pê nee mehcukij catê kêanre ata pyràc nare. Ne quêt ihtỳj mehkwỳ, caxwa me, amcro kam amji tehcajpar xà caxuw ame cumã caràr to me ipa atajê tehcajpa ne me hũtà. Xà quê ha ajkĩ cute mehtehcajpar xà ita wỳr apu ihkên? Quê nare! ");
INSERT INTO ram_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ampeaj kam wa me amã awjarẽ, Pahpãm quê ha ihtỳj mehkwỳa pytà, ne mehtehcajpa, mehcukij ne me to ipicokjêr xà jõ amcro kam, ne hũjarêan kam to. ― Ne quê ha pijamã pjê kam jũm ipê me Ahàkà cator xà ata jõ amcro kam, amji mã ito ihhimpej? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ne pê me hũmre kwỳ atajê mehkwỳ jirôa pê mempej na me amji to hane. Cwỳrjapê ri Jeju te me cumã hũjarẽn xà ita to hũjarẽn to hajỹr he: ");
INSERT INTO ram_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","― Ỹhỹ, me hũmre pijakrut ne ma Pahpãm to me amji kam hapac xà jũrkwa wỳr me tẽ, cumã mehcakôc prãmte. Ne ihnõ ata pê ri Parixêw catêjê nõ, ne ihnõ ita pê ri pjê jõ pahhi jarkwa kôt me hũhkra kam hàmcwỳr catê. ");
INSERT INTO ram_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","― Mã Parixêw catêjê nõ ita xa, ne hirãa pê Pahpãm mã ihcakôc, ne ampo pyrên hakry na cumã amji jarẽn to: “Ỹhỹ, me ijõ Inxũ, nee mã ipê ijàhkĩj xi catê nare, ne nee ipê me cumã ihêj xi catê nare, ne nee wa apu, por me ikwỳ amji pê mehprõ caxun to ipa atajê cuxà me cupê mehprõ caxun to ipa nare, wa nee hajỹr nare. Nee mã ipê pjê jõ pahhi jarkwa na me hũhkra kam hàmcwỳr catê xa ata pyràc nare pyrên ijakry. ");
INSERT INTO ram_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wa ijõtpê ipijacri impejti to ipa, ne amcro te xet ita kam, amcro pijakrut ita kam, wa nee ampo kur to ipa nare. Ne wa hanea ne ampo cunea to itekjê atajê, quê ha imã ihkrã tej wa ha ijõtpê to ajcrà, ne hãn ne pyxit ne gũrkwa mã hacjê. Cwỳrjapê ca ha ito impejti ne” hane. Hõ, cute Pahpãm mã ihcakôc xà to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","― Mã me hũhkra kam hàmcwỳr catê ita ihpahàmte, ihkĩnte ampỳa mã xa, ne nee kàj mã, côjkwa wỳr, ihkuc to irĩt nare. Ne cama apu hitôhkre kam amji cahhy, cumã amji kĩn nõ xàhte, ne ma Pahpãm mã ihcakôc ne cumã: “Ijõ Inxũ, he ipê ikên ton catê, icaprĩa ne” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mã Jeju me cumã: ― Ampeaj kam wa me amã awjarẽ. Pom hũmre te Pahpãm mã ihkêanre na amji jarẽn ita ri, cuna mã cumã impej, ne nee ihkên nare. Ne ma quêt impej pêa mã, cute amji jaxàr ikre wỳr. Mã ihkĩnte Parixêw catêjê nõ ata ri Pahpãm mãa ihkêanre, na ri nee impej nare. ― Ỹhỹ, quê ha jũm apu amji to cati prãm to ipa, quê ha ihtỳj Pahpãm to incri. Ne jũm amji to incrire prãm to ipa ata, quê ha ihtỳj Pahpãm to cati ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mã krĩ ata kam mehkwỳ te me ahkrare kwỳ japỳn, ne ma Jeju wỳr me to pra, cute me ahna hũ nõr, ne Hũm mã mehcajrẽn prãmte. Mã ihkôt me ipa catêjê te ahna me hõmpun, ne ame kam mencryc, ne ma intête ame huwahi. ");
INSERT INTO ram_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mã quêt Jeju te amji wỳr me ahkrare na hàhwỳr, ne ihkôt me ipa catêjê mã harkwa to: ― Quêt taa me ahkrare itajê ajpên iwỳr me mõ, amehcahpêrkàr nare. Quê ha jũmjê itajê pê me ahkrare itajê pyràac, ne ihtỳj jũmjê itajê Pahpãm himpej xà mã me axà. ");
INSERT INTO ram_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ita to me amji japackrea ne, quê ha jũm Pahpãm himpej xà na amji caxàr to hanea, pom quê ahkrare te ahna me amji caxàr he, ita na quê ha ihtỳj jũ caxuw Pahpãm krac ri me axà ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mã Juta catêjê nõ pê pahhi cator, ne cute Jeju cukij, ne cumã: ― Me imã ampo to hahkre catê, pom quêt apejti ita, jũ mã wa ha ne ityc jirô pê me Pahpãm jõ krĩ kam apu ipa to? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mã Jeju cumã: ― Ampo na mã ca apu ipej na ijarẽ? Ampo na? Nee me pahnõ impej nare. Me Pahpãm pyxit peaj ri ne impeaj to impej. ");
INSERT INTO ram_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pom ramã ate me Pahpãm jarkwa jahkre pej ita, pê me pamã harkwa to hane he: “Nee ame cupê mehprõ caxun nare, ne nee amehcuran nare, ne nee apu gàhkĩj nare, ne nee apu ahêj xi jarẽn nare, ne atỳj me apãmjê me, me axyrxwỳ jarkwa to me amji japackre to me apa” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mã hũmre ita cumã: ― Ỹhỹ, icrire naa mã, wa Pahpãm jarkwa kôt amji to ihimpej to ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mã Jeju te ita na impar ne cumã: ― Ỹhỹ, ca ha cormã ampo pyxit peaj ata to. Ca ha amũ tẽ, ne amji pê ampo cunea to ihpore na ahpa, ne me cupê hamreare atajê mã ihpore cunea jõr pa. Ca ha ate ampo itajê to hajỹr na, wa ha côjkwa kam ate amji pê ampo jõr atajê jirôa pê amã ampo pej pit gõ. Ỹhỹ, ca ha ate hajỹr ne ampo itajê to amji caprãr na, ca ha ajpên tẽ, ne atỳj amji to ikôt apa catê na ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mã hũmre ita te ita na impar, ne cumã amji kĩn nare, ne ihpeacre. Ampo na? Cupê hakràj cati na pê cumã hàhcukrêj atajê japê. ");
INSERT INTO ram_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mã Jeju te cumã amji kĩn nare na hõmpun, ne ihkôt me ipa catêjê mã: ― Hamreare, jũ wỳr quê jũm jakràj cati ihtỳj Pahpãm te ihhimpej xà ata mã axà. ");
INSERT INTO ram_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ampeaj kam, quê ha nee jũm jakràj cati nõ Pahpãm te ihhimpej xà ata mã hàr nare to hane, pom quê nee cawrô cahàc kô jarôti nõ aguj te kre na cator xà nare he ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mã cute me ita par catêjê ita na me ahcukij, ne me cumã: ― Mẽr, jũ mã quê ha me, ne jũm amji pytà, ne cumã axà? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mã Jeju me cumã: ― Jũ wỳr quê me hũmre nõ ampo itajê nõ to. Ne quêt me Pahpãm mã ri ihtỳj ampo itajê cunea ton jahkre pej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mã Petrô cumã: ― Me ipupu he, wa ite me ijũrkwa jicu, ne me apynãr ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Mã Jeju cumã: ― Ỹhỹ, ampeaj kam wa ha me amã awjarẽ, quê ha jũm te Pahpãm himpej xà ata cwỳrjapê hũrkwa jicu, ne ihprõ rer, ne mehkjêjê rer, ne me hũmjê rer, ne menxyrxwỳ rer, ne mehkra rer na, quê ha pjê ita kam ampo itajê jirôa pê cucwa, ne ihtyc jirô pê mã Pahpãm cahê na ipa, ne ihtĩr rohnỳtti mã ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mã ma Jeju te me hàhtôa atajê intête ihkôt me ipa catêjê te tôxi atajê japrôr ne me to mõ, ne me cumã: ― Me ikampa! Cu ha ma Krĩpinkrên wỳr me mõ, por pê rỳ pêa mã Pahpãm jarkwa to ihcakôc catêjê ahna ihhôc ata wỳr, ne curia quê ha ame ipê Ahàkà to kên. ");
INSERT INTO ram_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Quê ha Roman catêjê jũhkra mã me haxà, quê ha ame cumã, ne ame hũn, ne ame kam harcô rẽ, ne amehcahhy, jirô pê mã quê ha mehcura. Quê ha ahna amcro incrê, quê ha hacpỹa mã ihtĩr ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mã ihkôt me ipa catêjê te me ita par pej nare, ne nee cute me Jeju jũjarẽn xà ata jahkre pej pej nare. Ne cute me hahkre pej xà ita me cupê ipimxur tu. ");
INSERT INTO ram_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pê Jeju Krĩcuxwati na hàhtêp to mõ, pê hũmre into tũm nõ pry jahkà kam jỹ, ne ajco me ahna ahwỳ. ");
INSERT INTO ram_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ne cute cahê na amji to me mõr na mempar, ne cute mehcukij, ne me cumã: ― Ampo mã? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mã me cumã: ― Pom Naxare jõ krĩ pĩn Jeju cator ita ri mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mã into tũm ita jũpar, ne cute caràr kam ihtẽm, ne Jeju mã: ― Jeju! Apê pahhi Tawi xwỳ tàmxwỳ ita, icaprĩa ne! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mã mam me mõ itajê cama ame kam incryc, ne ame cumã: ― Kêt! Ne aracri jỹ! ― hane. Mã hipêr cute caràr to: ― Pahhi Tawi xwỳ tàmxwỳ ita, icaprĩa ne! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mã Jeju te impar ne hàhhuc, ne cute cumã hàkjêr na me mẽn. Mã ajpên into tũm ata to me mõ, ne Jeju na me to hàhtêp. Mã cute ihcukij ne cumã: ");
INSERT INTO ram_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","― Ampo na ca prãm? Ampo to wa amã? ― hajỹr. Mã cumã: ― Ỹhỹ, Jeju, wa hacpỹa mã irĩt prãm ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mã Jeju cumã: ― Rĩt! Ramã acaprãr. Ate ito amji mã ahimpej, cwỳrjapê wa ite hacpỹa mã ato to amã impej ― hane. ");
INSERT INTO ram_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mã hũmre ita irĩt pyrentu, ne ma cute Jeju pynãr, ne hacpỹa mã cumã into impej ita jahpan xà na côjkwa kam Pahpãm pejti, ne catihti na harẽn to mõ, ne cumã into impej pyrên hakryti na amji jarẽn to mõ. Mã mehcunea te me ita pupun, ne Pahpãm pejti na cute me harẽn kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pê Jeju Krĩcuxwati mã axà ne ma krĩ japôc to mõ. ");
INSERT INTO ram_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pê curi hũmre nõ japrỳ pê Xaquêw ita ihkrĩ. Ne pê hũmre ata pê hakràj catê. Ne cupê pjê jõ pahhi jarkwa kôt me hũhkra kam hàmcwỳr catêjê jõ pahhi, ne ajco hõ pahhi jarkwa jirôa pê me hũhkra kam amcwa, ne amji mã huwahi. Cwỳrjapê pê mehcunea mã ihkĩn nare ne ma ame curê. ");
INSERT INTO ram_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pê tee ajco apu Jeju pupun ne hahkre pej prãm, ne jũ wỳr quê hõkre nõre ita kam, ipu na me hàhtôti ita kam hõmpu. ");
INSERT INTO ram_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ne ma cute hõmpun prãmte, hĩpê cumam ipicahur ne pĩxô pàr na hàpir, por pê ihkrac ri mõr xà ata na. ");
INSERT INTO ram_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mã Jeju mõ ne kàj mã irĩt, ne cute Xaquêw pupun, ne cumã: ― Xaquêw, awrỳc pyrentu, wa ita kam gũrkwa kam ijàhhuc to prãm ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mã Xaquêw jũjarêan kam iwrỳc, ne cute cumã amji kĩan kam hũrkwa kam ahna amji caxàr. ");
INSERT INTO ram_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mã mehcunea te me ita pupun, ne ahna me cupê ihkaj na, cwỳrjapê ri cute ahna mehcakôc kên kam mehtẽm, ne me amji mã: ― Pỳhàpà, quê ha Jeju ajte ihkrã kên catê ita jũrkwa kam ahtwỳ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ne me hàpàn jirô pê mã ri Xaquêw xãm, ne cute Jeju mã amji jarẽn, ne cumã: ― Ijõ Pahhi, ikampa, wa ha me cupê hamreare atajê mã ijàhcukrêj jĩkjê gõ. Ne me cupê ijàhkĩj atajê, wa ha hacpỹa mã me cupê ijàhkĩj pyxit jahpan xà na, me cumã ijàmjõr to cwat ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mã Jeju cumã: ― He ampeaj kam ate amji kam gapac xà ton ita na impej. Ne toa ca ate mehcunea mã hanea ne apê Aprãw xwỳ tàmxwỳ na amji jarẽn. Cwỳrjapê quê ha ita kam, Pahpãm ikre ita kam mehkrĩ catêjê itajê kên catia pê me hũtà. ");
INSERT INTO ram_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ỹhỹ, ampo na ri ipê me Ahàkà pjê ita kam cator? He cute me ipictor catêjê japên, ne Pahpãm wỳr me haprôr xà caxuw ― hane, ne ma ihkôt me ipa catêjê me, me mõ. ");
INSERT INTO ram_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ne ramã Krĩpinkrên na hàhtêp, cwỳrjapê ri me cumãa ramã Pahpãm te ihhimpej xà ata cator xà kam hàhhuc xàa kam na amehcãmjĩ. ");
INSERT INTO ram_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Cwỳrjapê ri Jeju te me cumã Pahpãm himpej xà to hahkre prãmte me cumã hũjarẽn xà nõ ita jarẽn, ne me cumã: ― Ỹhỹ, pê hũmre ita cati, ne cupê pahhi nõ ita kra. Ne ajco amji to pjê jõ pahhi to prãm, cwỳrjapê pê ma pjê nõ jũwrya kam pahhiti cati ihkrĩ ata wỳr tẽ, cute amji to pjê jõ pahhi prãmte. Ne hỹrmã ihtẽm jirô pê, quê ha cupê pahhi ne amji jaxà. ");
INSERT INTO ram_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ne ihtẽm xà wỳr, cute cumã me hàpên catêjê te tej atajê capi, ne me hahkre pej prãmte me ahna hàhwỳr, ne cute ahpỹanre na me cumã ihpore hô catia pyxit ne hõr par. Ne cute me cumã harkwa hyr, ne me cumã: “Ihpore hô cati ita py ne to tẽ, ne gapacta ne kam me to apixô to mõ. Krãa caxi, jũ mã ca ha me, ne ihpore hô ita kam me to hàhtô to amõr to? Mãr wa amji jaxà, ne cormã me gahkre pej” hajỹr. Ne ma pjê nõ wỳr tẽ. ");
INSERT INTO ram_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","― Pê hõ pjê kam me curê xwỳn kwỳ amehkrĩ atajê ma hũmre ita pê me hõ pahhi na amehcaca. Ne ma ihkôt me jũmjê itajê kujate, cute pahhiti mã me hũjarẽn prãmte, ne me cumã: “Wa ma ame me ijõ pahhi na me hũmre ita caca” hajỹr cakrô, mã hũmre ita ihtỳj amji caxuw hõ pahhiti cukij, mã cute pjê jõ pahhi na ton. ");
INSERT INTO ram_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","― Mã cupê pahhi, ne hũrkwa wỳr cute amji jaxàr. Ne cute me cumã hàpên catêjê mã ihpore hô cati jõr atajê na hàhwỳr, cute me hahkre pej prãmte, jũ mã mõrmõ cute me, ne ihpore ita to me ipicamẽn. ");
INSERT INTO ram_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","― Mã mam ita hỹrmã cator, ne cute hõ pahhi mã: “Ỹhỹ, ijõ pahhi, ate imã ihpore hô pyxit ne hõr ata, hamre, wa ite kam to ipixô, ne hipêr hipy to tej ne kam incwỳr” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","― Mã cumã: “Ahnaa ri ita! Apê imã gàpên catê impeaj to impej. Ne apê ampo kryjre jamãr pejti catê, na ca ha ita caxuw ampo catia jamã. Wa ha krĩ te tej jõ pahhi na axãm” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","― Mã cumã me hàpên catêjê nõ ita hỹrmã cator, ne cumã: “Ỹhỹ, ijõ pahhi, ate imã ihpore hô pyxit ne hõr ata, hamre, wa ite kam to ipixô, ne kam to xĩc ne incwỳr” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","― Mã pahhi ata cumã: “Taamã, ita caxuw wa ha krĩ te xĩc jõ pahhi na axãm” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","― Mã hapua na cumã hàpên catê ita hỹrmã cator, ne cute hõ pahhi mã: “Ỹhỹ, ijõ pahhi, ate imã ihpore hô pyxit ne hõr ata, wa ite cupẽhkà kam harĩj ne ma apu intê. Na wa ha hacpỹa mã amã cugõ. ");
INSERT INTO ram_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ne acupate wa ite nee kam ampo to ipixô nare. Wa ite ramã gahkre pej pejtu, apê hũmre jàprêhti na. Ne ca atỳj me cupê ampo to ate atekjê nare atajê to pôj. Ne ate ampo kre nare atajê, ca gõtpê ame cupê ihkẽhkẽ” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","― Mã cumã: “Apê imã gàpên catê kêanre, wa ha garkwa ita kôt apu ato kên. Pom ramã ate ijàprêhti ita na ijahkre pej pejtu ita? Pom wa me cupê ampo to itekjê nare atajê incwỳr to ipa, ne pom wa ite ampo kre nare itajê, wa hãn ne me cupê ihkẽhkẽn to ipa ita? ");
INSERT INTO ram_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mẽr ampo na mã ate nee me ihpore jamãr catêjê mã ijõ pore ita jõr, mã kam cute me to imã ipicamẽn crire nare? Mẽr ampo na mã ate me cumã hõr nare? Ca ha kepê to hane na mã, wa ha ijõtpê hipêr ihkwỳ incrire ne kam cupy” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","― Ne cute cahê na mehcuhhê atajê mã: “Intête me ijõ pore hô ita capa, ne jũm mã cute tej ata mã, ca me agõ” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","― Mã me cumã: “Pỳhàpà, me ijõ pahhi, pom ramã cumã ihpore hô te tej ita” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","― Mã me hõ pahhi me cumã: “Ampeaj kam wa me amã awjarẽ, por ampeaj kam me cumã hàhtô atajê, quê ha me cumã hàhtô atajê jirôa pê me cucwa. Ne mehkĩnte me cupê ihkryjre atajê, quê ha me cupê capa. ");
INSERT INTO ram_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ne hamre, ita caxuw, ajpên me icurê xwỳn atajê cunea japrô ne me to mõ, por ma me hõ pahhi na ame icaca atajê, ne icunaa mã, ikam mare mã me hipej tu!” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ne hamre, Jeju te me cumã hũjarẽn xà ita jarẽn jicu jirô pê, ma Krĩpinkrên wỳr ihkôt me ipa catêjê me, me pra. ");
INSERT INTO ram_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mã ramã krĩ jacot japrỳ to ame Pĩxô jõ krĩ me, Mehkênpupunxà jõ krĩ na me hàhtêp, por Pĩxô jõ kẽn cahê na krĩ atajê na. Ne ma mam cute ihkôt me ipa catêjê to ipijakrut ne mehkujahêc, ne cute me cumã harkwa hyr to: ");
INSERT INTO ram_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","― Mam me tẽ, me pahcumam krĩ jacot ata wỳr, ne ca ha ramã me axàr xàa kam, me cawrô cahàcre kam nee cormã jũm jỹr nare ata pupu, ne ramã cumã hê hiahpuro ne xa. Ca ha me cumã hê pô, ne ajpên me to tẽ. ");
INSERT INTO ram_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Quê ha jũm ate me cumã hê pôn na me apupu, ne ahna me acukij, ca ha me cumã: “Pahhi ri apu ahna prãm, ne cute hỹrmã me ikujahêc” ― hane. ");
INSERT INTO ram_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mã ma ajwar me tẽ, ne Jeju te hũjarẽn xà atajêa na cute me hõmpun. ");
INSERT INTO ram_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ne cormã ame cawrô cahàcre mã hê pôan kam, mã cute me to hõ tekjê catêjê te ahna me hõmpun, ne mehcukij to: ― Ampo na mã ca ame cawrô cahàcre ita mã hê pô? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mã me cumã: ― Pahhi ri apu ahna prãm, ne cute hỹrmã me ikujahêc ― hane. ");
INSERT INTO ram_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne ma Jeju wỳr me to mõ ne to cator. Ne kam cute me cumã cupẽhkà jaxwỳr, ne cute kam hỹr na mehtehcajpar, mã kam hỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ne cormã to mõr prãam kam mã, cumam me cumã me hõ cupẽhkà capô, ne pry kôt me cumã nõr to mõ. ");
INSERT INTO ram_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ne ma ramã Krĩpinkrên na me hàhtêp to mõ, ne ramã Pĩxô jõ kẽn jõ ajpô xà mã me iwrỳc to mõ. Mã ihkôt me ipa catêjê jàhtôa ne ihkôt me mõ. Ne cute me Pahpãm carôt kôt Jeju jàpên xà pihho catia pupun atajê pyrên ame hakrya to ame hakry. Cwỳrjapê ri kỳj cati pêa mã cute me Pahpãm pejti na me harẽn kam me to ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ne me caràr to me hane he: “Me pajõ Pahhiti me pahwỳr cator! Ne Pahpãm jarkwa kôt hãn ne ipa! Mã côjkwa kam mehkrĩ catêjê atajê cunea pinkrinti. Ne mehcunea te ramã cupê Pahpãm catia na me hahkre pej” hane. ");
INSERT INTO ram_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mã Parixêw catêjê kwỳ me hàhtôa jipôc ri amehcuhhê atajê ame Jeju mã, ne me cumã: ― Me cumã ampo to hahkre catê, akôt me ipa catêjê mã garkwa ta, quê me kêt ― hane. ");
INSERT INTO ram_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mã Jeju me cumã: ― Ampeaj kam wa ha me amã awjarẽ, quê ha me kêt, quê ha ihtỳj kẽn itajê me haxà kam, caràr kam ihtẽm pyrentu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ne Jeju te Krĩpinkrên na hàhtêp, ne cute hõmpun ne apu caprĩ, ne apu kam amrã. ");
INSERT INTO ram_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ne incwỳar kam cute hũjarẽn to: ― Pỳj me hêj xi! Krĩpinkrên kam me akrĩ catêjê, he me apê amji jahkre kêatre. Wa tee me amã, me ate amji kam me gapac xà carĩcti to hahkre, ca ajte nee me amji caxwãm pê me amji to me acarĩcti prãm nare. Me apê amji jahkre kêatre! ");
INSERT INTO ram_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ỹhỹ, quê ha amcro nõ na me acurê xwỳn me akrã tu ne, ne me ana ajxê. Quê ha ame ana pjê hakôt ne ajpẽn wỳr me gagã, ca ha nee ame gapôj nare. ");
INSERT INTO ram_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Quê ha me gũrkwa cunea to amehkêanre ne, ne me to hamre tu. Ne por kẽn te kwỳc caxwãm pê amehkrĩ atajê, quê ha mehkrare me, me hamre tu. Nee quê ha krĩ ita jaxà kam kẽn nõ hàhhuc nare. Ne nee hakàn pê cumã hãm xà nõ hàhhuc ne hãm nare. Me apê amji jahkre kêatre to, ca nee ate me ipupun pej nare, cwỳrjapê ca ha me akên mã me axà. Ne nee me amã Pahpãm jõ amcro cator xà ata na hahkre pej nare. Ne cute me apytàr xà jõ amcro ata kam, ca ha ma hỹrmã ame apipkjêr caca ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ne Jeju Pahpãm to me amji kam hapac xà jũrkwa wỳr mõ ne cumã hàr, ne cute kam ihpore to ampo na me hàhpan catêjê japôj kam ihtẽm. ");
INSERT INTO ram_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne cute me cumã harkwa to: ― Inxũ Cati jõ kàhhôc kam, ihhôc te harẽn xà ata te hajỹr he: “Ỹhỹ, ijũrkwa pê kam imã mehcakôc xà” hajỹr. Ca ajte ate harkwa kaj na me to me hàhkĩj xi jũrkwa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ne pê Jeju ajco amcro cunea kam me cumã ampo to hahkre. Pê Parixêw catêjê me, me cumã Mojxe jõ kàhhôc to hahkre catêjê me, me hõ pahhi me, ajco tee ame Jeju curan prãm. ");
INSERT INTO ram_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ne jũ wỳr quê me ita to. Ampo na? Pê mehcunea mã Jeju par prãm na pê. ");
INSERT INTO ram_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ne amcro nõ na, Jeju ame cumã ampo to hahkre, ne ame cumã Pahpãm jarẽn to mõ. Mã mehkwỳ cator, Jeju cukij prãmte. Ne mehkwỳ atajê pê Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, Mojxe xwỳ jõ kàhhôc to hahkre catêjê kwỳ me, me prohti kam kwỳ. ");
INSERT INTO ram_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ne hỹrmã me cator, ne cute me Jeju cukij to: ― Ỹhỹ, me imã amji jarẽ, jũm jarkwa kôt mã ca apu ampo itajê to? Ne jũm te mã ahna amã harkwa? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mã Jeju mã cormã cute mehpro na to prãm nare, na ri me cumã: ― Ỹhỹ, wa ha hanea ne me acukij pyxit, ca ha me imã amji jarẽ, jirô pê wa ha itỳj hanea ne me amã amji jarẽ. ");
INSERT INTO ram_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ỹhỹ, jũm te mã Jowãw mã harkwa, mã cute cô kam me cumrãr? Xà côjkwa kam Pahpãm te mã cumã harkwa? Nare xà ajkĩ pjê kam me hũmre nõ te mã cumã harkwa? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mã cute me ajpẽn cukij kam mehtẽm, ne me ajpẽn mã: ― Ampo cu ha ajte me cumã harẽ? Cu me cumã: “Pahpãm te ri Jowãw mã harkwa” hajỹr na, quê ha hipêr me pahcukij, ne me pamã: “Mẽr hõhõ, ampo na mã ca nee ate amji mã me Jowãw to hajỹr nare?” hane. ");
INSERT INTO ram_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nare, cu ha me cumã: “Me hũmre nõa te ri Jowãw mã harkwa” hajỹr na, quê ha me hàhtôti itajê ma ame pahcaca, ne kẽn to ame pahcapê. Ampo na? Ampeaj kam ri me cumã Jowãw pê Pahpãm jarkwa na ihcakôc catê ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Cwỳrjapê ri me Jeju mã: ― Wa nee ite me jũm te Jowãw mã harkwa hyr ata na me hahkre pej nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mã Jeju me cumã: ― Ca ma ame imã amji jarẽn caca, cwỳrjapê wa ha hanea ne nee me amã, por wa jũm jarkwa kôt apu ampo itajê ton to ipa ata na amji jarẽn nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ita jirô pê mã ri Jeju te me cumã hũjarẽn xà itajê nõa jarẽn, ne me cumã: ― Ỹhỹ, hũmre nõ te hõ pur ata cunea kam amji mã pĩxô krô japrỳ te uwa atajê kre. Ne cute pur jamãr catêjê kwỳ mã hõ pur ata jahkre, mãr quê ma me hamã, quê hô ne intep. Ne ma pjê nõ wỳr tẽ, ne curi cute amji to putwrỳ jàhtôa. ");
INSERT INTO ram_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","― Mã cute uwa to cuprõn xà jõ amcroa kam ramã hàhhuc, mã cute me hỹrmã cumã me hàpên catêjê nõ kujahêc, mãr quê pur jõ pahhi mã ihkwỳ ta, ne cute me hamãr catêjê mã cute me to hàpên jahpan xà na ihcahhur cunea juwahi prãmte. Mã ajte pur jamãr catêjê atajê amji mã pĩxô atajê cunea juwahi prãmte, cama amehcahhy, ne ma cute hũre kam mehkujahêc. ");
INSERT INTO ram_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mã cute hipêr me cumã hàpên catêjê nõ kujahêc, mã cute me to hajỹar ne me cumã ihpahàm catia ton, ne hanea ne amehcahhy, ne ma hũre kam cute mehkujahêc. ");
INSERT INTO ram_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mã hipêr cute cumã me hàpên catêjê nõa kujahêc, mã pur jamãr catêjê te me to hajỹar, ne hanea ne ame to kêanre, ne ma pur pê me to cator. ");
INSERT INTO ram_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","― Mã pur jõ pahhi ita te amji kam hapac, ne amji mã: “Jũ mã wa ha ajte? Ỹhỹ, wa ha hane, ne ma mehwỳr imã ikra kĩnti ata kujate. Quê ha ihhêaj to amji mã me hũpa, ne nee amehcaxun nare” hane. Ne ma cute me hỹrmã ihkra ita kujahêc. ");
INSERT INTO ram_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","― Mã pur jamãr catêjê itajê te amji wỳr mehkra ata pupun, ne me ajpẽn mã: “Me hõmpu he, pom ihkra xũmre ajpên mõ ita pê pur jõ pahhi kra. Hacme ne mehcura, ne me to hamre, quê ha pur ita pê me pahtekjêa” hane. ");
INSERT INTO ram_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","― Ne cute pur pê mehkra xũmre ata to me cator, ne cute amji mã me mẽn, ne mehcuran ― hajỹr. Hõ, Jeju te me cumã hũjarẽn xà ita to hajỹr jirô pê mã ri cute mehcukij to: ― Jũ mã mõrmõ quê ha pur jõ pahhi ita cute amji kam hapac xà ita to? ");
INSERT INTO ram_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ỹhỹ, quê ha me to hane he. Quê ha mehwỳr cato ne me hũjamãr catêjê kêanre atajê cunea jipej tu, ne ajteare mã me hũjamãr catêjê kwỳ mã pur ita jahkre ― hajỹr. Mã cute me ita par ne me cumã: ― An! Ampo na mã cute mehkra ita curan? Quê me pa mã mã, wa ha nee mehcuran nare! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mã Jeju me hõmpun tỳjti, ne me cumã: ― He ihhêj ne me caa, ca ha ito me jũm kra ata pyràc ne me icura. Ampo na? Pahpãm jõ kàhhôc kam ramã harẽn xà ita te hajỹr he: “Pom ikre to me hàpên catêjê ma ame ikre mã hãm xà caxuw kẽn pejti caca ita te ihkwỳ jirôa pê amji to cati, ne ihcuhtac tỳjti” hane. ");
INSERT INTO ram_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ne ihhêj rũm ipê ikre mã hãm xà caxuw mam kẽn pejti cuhtacti ata pyràac, mã ma ame icaca, ne cute me ijicu. Co he, por quê ha jũm kẽn ata kam ihpỳm ata, quê ha apu hirên tu. Nare, quê ha kẽn ata jũm kam ihpỳm ne to hacrôre ne ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mã me cupê Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, me cupê Pahpãm mã mehcajrẽn catêjê atajê te, Jeju te me to hũjarẽn xà ata na amji na me hahkre pej pyrentu, cwỳrjapê ri ma ame curê, ne cama mehpro ne me haxàr pyrentu to prãm. Mã me hàhtôti te me Jeju par atajê mã ampeaj kam ihkĩn. Ne Jeju curê xwỳn atajê mã ampeaj kam me hàhtôti atajê cupa, cwỳrjapê ri nee cute me Jeju pro nare. ");
INSERT INTO ram_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ne ihtỳj cama amehkôpĩr to me ipa. Ne cute mehkôpĩr catêjê atajê mã me hàmjõr, mãr quê amehkôpĩ, ne ihtỳj ampo na mehcukij to ipa, ne ampo kênre kôt mehpro, ne krĩ jõ pahhi jũhkra mã me haxàr to prãm to ri ame ipa. Ỹhỹ, ihhêj ne põ rũm kam mempejti, ne me caxwãm pê, kam cute me amji kam hapac xà kêanre. ");
INSERT INTO ram_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mã me hũmre atajê ame Jeju cukij, ne me cumã: ― Ỹhỹ, ampo to hahkre catê, wa ite ramã me acakôc xà me, ate ampo to me imã hahkre xà atajê pê ampeaj kam na me hahkre pej. Ne nee amã jũm cupa nare, na ca mehcunea to amji kam gapac xà to apipẽnti to apa. ");
INSERT INTO ram_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ne ampeaj kam caxi me imã awjarẽ. Xà wa ajkĩ itỳj me pjê cunea jõ pahhiti mã pjê jahpan xà na me ijàmjõr xà ata to me amgõ? ― hane. Ne pê cute mehcukij xà ata to, ihkên mã me mẽn prãmte pê amehcukij. Ampo na? Quê ihhêaj to Jeju me cumã: “Ca ha atỳj me amgõ” hane, quê ha me hàhtôti atajê ihtỳj ame kam incryc. Ampo na? He me cumã hàmjõr prãm nare, na quê ha ame kam incryc. Nare, quê ihhêaj to me cumã harkwa to: “Ca ha nee me gàmjõr nare” hajỹr na, quê ha pjê jõ pahhi mã me hàpên catêjê atajê ihtỳj ame kam incryc, na pê amehcukij to hane. ");
INSERT INTO ram_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mã Jeju te me cumã, cute amji kam me hapac xà kêanre ita na hũcapi pyrentu, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","― Ajpên me imã ihpore hy nõ, wa hõmpu ― hajỹr. Mã cute me cumã hõr. Mã cute me cumã: ― Mẽr jũm japrỳ me, ampo carõ mã ihpore hy ita kam nõ? ― hajỹr. Mã me cumã: ― Pjê cunea jõ pahhiti pê Xexa carõ me haprỳ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mã Jeju me cumã: ― Mẽr hõhõ, ca ha me pjê cunea jõ pahhiti pê Xexa mã me hàhcukrêaj gõ, ne hanea ne Pahpãm mã me hàhcukrêaj gõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mã mehcukij catêjê itajê pê ihpro jahkre kêatre mã aracri mehcuhhê ne me ajpẽn mã: ― Pỳhàpà, cu amehpro prãm cakrô, mã cute ihcakôc xà ita to hamãr kênre nare ita kam, jũ mã cu ha me to, ne mehpro? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mã Xato xwỳ kôt me ipa catêjê ma apu mehtyc te hacpỹ mã ihtĩr na ame ahna aprã atajê kwỳ Jeju na me hàhtêp. Ne cute hanea ne me hàhcukjêr xà ata to, Jeju kên mã me mẽn prãmte, cute mehcukij to: ");
INSERT INTO ram_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","― Ỹhỹ, ampo to me cumã hahkre catê, pê Mojxe xwỳ me pamã incaca xà ita na ihhôc to hane he: “Quê jũm ihprõ nõ me hikwa, ne nee kam ihkra nare kam ty, quê ha hĩxi ahte apu ipa. Quê ha impjên tyc ita tõa cahãj pijapit ata me hikwa, ne kam ihkra. Quê ha ihkra ita to amji mã me mam impjên tyc ata kra” hane. ");
INSERT INTO ram_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hõ, pê me pamã ahna ihhôc to hane. Ne pê xwahna jũmjê itajê me xet ne ajpẽn to mehkjêjê pit. Pê mam ihtõ kà ita hĩxi ata me hikwa, ne nee kam ihkra nõ juwahi nare kam ty. ");
INSERT INTO ram_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Mã hanea ne ihtõ te amji to hapu te hajỹar ne cume hikwa, ne hanea ne kaam ihtyc. Ne pê me xet itajê cunea mehprõ pyxit ata me, me hikwa partu, ne mehprõ ita kam jũm te mehkra nõ rer nare kam mehcunea mehhi. ");
INSERT INTO ram_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mã hapu na mehkôt mehprõ ita te hajỹar ne ihtyc. ");
INSERT INTO ram_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ne mehtyc jirô pê, hacpỹa mã amehtĩr jõ amcro kam, cute me xet itajê cunea cume hikwa ita kam, jũm quê ha mehprõ ata to ihprõ? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mã Jeju me cumã: ― Me amãa, nee hacpỹ mã mehtyc tĩr xà nare, na mã ca ame icukij to hane. Ne ca ihkaj na ame to. He pjê ita kam pyjê me, me hũmre ihtỳj ame hikwa. ");
INSERT INTO ram_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ne por me Pahpãm kampa, ne catyt kam me ipa, ne me ty, ne hacpỹa mã mehtyc xà jahpa ne mehtĩr, ne Pahpãm wỳr me api, ne cahê na mehkrĩ atajê ri, nee me hikwa tuw xà nare. ");
INSERT INTO ram_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ne me cupê côjkwa kam Pahpãm jarkwa to memprar catêjê pyràac. Jũ wỳr quê jũm ty, ne jũ wỳr quê hanea ne jũm hikwa tuw. Ne me cupê Pahpãm kra. Ampo na? Hacpỹa mã amehtĩr, cwỳrjapê ri me cupê Pahpãm kra. ");
INSERT INTO ram_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","― He pê Mojxe xwỳ hirãa pê me amã hacpỹa mã mehtyc ne mehtĩr na to hahkre. Xà ca nee me aprêj pôc ne nee cute caxàr nare ata jarẽn to me amji japackre nare? Pê aprêj pôc te caxàr nare ata kam Pahpãm jõkre Mojxe mãaw jarẽ, ne cumã: “Ipê apãm Pãm Cati, ne cormã ipê me aquêtjê Aprãw me, Ixac me, Jaco Pãm Cati wa” hane. Ne nee pê amji jarẽn to: “Pê ipê Aprãw me, Ixac me, Jaco Pãm Cati” hajỹr nare. ");
INSERT INTO ram_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ne cute amji jarẽn xà ita kôt ri me pamã Pahpãm pê mehtĩr jõ Pahpãm na hahkre pej, ne nee cupê mehtyc jõ Pahpãm nare. Pahpãm mã mehcunea tĩr pit, ne nee cumã jũm tyc nare. Cwỳrjapê cu me pahte me Aprãw xwỳ me, Ixac xwỳ me Jaco xwỳ tĩar na me harẽn par ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mã Mojxe jõ kàhhôc to hahkre catêjê nõ kwỳ hanea ne curi mehcuhhê itajê te me cumã: ― Nee ate gũjarẽn xà ita to ihcupan nare. Ne gũjarẽn xà ita peaj to impej ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hamre, mã hipêr jũm mã ihcukij xà nõ to ihcukij prãm nare. ");
INSERT INTO ram_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mã Jeju cormã me cumã: ― Wa ha por pê Pahpãm jũm pê Crixtô to awjahkre ata na me acukij. He ca ajte Crixtô pê Tawi xwỳ tàmxwỳ tàmxwỳ na me harẽ. ");
INSERT INTO ram_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ne pê Tawi xwỳa ajco ihkàhhôc kam increr xà kam ihhôc to hane he: “Ijõ Pahhiti te ijõ pahhi mã harkwa to hajỹr he: ‘Icahê na, Pahhi jỹr xà kam, awpôc rũm jỹ. ");
INSERT INTO ram_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Wa ha apar krac ri me acurê xwỳn atajê cunea nõr na me to, quê ha me nõ, ca ha ate me tohjê na cute me gahkre pej xà na, me hipy apar xãm’ ” hane. ");
INSERT INTO ram_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pom pê Tawi xwỳ Crixtô to hõ pahhi na ihcukij ita kam, jũ mã quê ne cupê ihtàmxwỳ? Ampo na? He cormã Tawi ihtĩar na Pahpãm cahê na côjkwa kam apu ipa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mã me hàhtôti atajê ame Jeju kampa, mã Jeju te ihkôt me ipa catêjê mã harkwa to: ");
INSERT INTO ram_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","― Co he, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê to me guphêa ne, nãmri mehkà impeaj kam hãn ne ame ipa to prãm, ne hãn ne cute me hũpa kam me cumã mehcakôc na me to prãm. Ne ma hãn ne cute me cuprõn xà kam apu pjê kam mehkrĩ caca, ne mehkrĩ xà impeaj kam hãn ne mehkrĩ to prãm. Ne hanea ne me hõ pahhi jõ amji kĩn kam, hãn ne me hõ impeaj na mehprãm. ");
INSERT INTO ram_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ne hãn ne pyjê pê impjên tyc ne impijapit atajê mã amehhêj, ne hãn ne me cupê ampo to ahkĩ. Ne me cupê me hàhkĩj xi na amji to me ipimxur prãmte, hãn ne mehcunea kam mare mã Pahpãm mã mehcakôc to mehkrỹnre nare. Cwỳrjapê quê ha mehkên xà te me kam ipihur xà atajê me cumã ihkêanre ne ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ne amcro nõ na Jeju, Hũm Cati to me amji kam hapac xà jũrkwa kam hãm ne xa, ne ame hakràj catihti atajê te mehpore jõr na me hõmpu, mã ihpore incjên xà kam me cucjê. ");
INSERT INTO ram_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne hanea ne cute jũm cahãj pê impjên tyc ne impijapit ata pupun, mã cute ihpore incjên xà kam ihpore hy to ipijakrut peaj ne hàr. ");
INSERT INTO ram_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mã Jeju te ihkôt me ipa catêjê mã harkwa to hajỹr he: ― Ampeaj kam wa ha me amã awjarẽ. Cahãj pê hamreare ata te ri mehcunea jirôa pê ihpore jõr. ");
INSERT INTO ram_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ne mehkwỳ jakràjti catêjê te me hõ pore cahhur jàhhuc atajê pit jõr. Ne cahãj ita nare, cute to amji to ipijapar xà ita ri, cute amji pê ihcunea jõr ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mã mehkwỳ Pahpãm to me amji kam hapac xà jũrkwa to amehcakôc to: ― Ampeaj kam ikre ita pej! Ne ahna kẽn itajê impejti! Ne kam cute ame Pahpãm mã ampo pejti jõr atajê cunea impejti ― hane. Mã Jeju te mempar ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","― Ỹhỹ, pom ampo cunea impejti ca ame hõmpu itajê, quê ha ihtỳj jũ caxuw ihcunea hamre tu, ne nee pom ca ame kẽn pupu itajê nõ hàhhuc, ne amji jipy nõr nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mã cute me Jeju cukij to: ― Me imã ampo to hahkre catê, jũ caxuw quê ha ita hane? Ampo quê ha jũ na me imã, wa ha ihkôt me ita te hajỹr xà ita jahkre pej? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mã Jeju me cumã: ― Me guphêa ne, quê nee jũm me anõ mã ihhêj nare. Ampo na? He quê ha me hàhtôa ne ijaprỳ na ame amji to mehhêj to me ipa, ne me amã: “Hamre, ramã amcro hyr xàa kam hàhhuc” hane, nare, quê ha me amã: “Ipê Pahpãm te Crixtô to côjkwa pĩn me amã hũjahkre ata mã, wa he” hane. Cakrô, ca nee me anõ ihkôt amji kam gapac nare. ");
INSERT INTO ram_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ca ha jũ ri me ipijapu nõ jarẽn pa, ne nee ame hũpa nare. Nare, quê jũ ri, krĩ nõ kam pahhi na ame ajpẽn jũrê, ca me harẽn pa, ne nee ame hũpa nare. Quê ha ampo itajê cunea hane cakrô, nee cormã me hamre xà kam hàhhuc nare, ne ihtỳj hõtpê ita hapôj to ipa. ");
INSERT INTO ram_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","― Quê ha krĩxàre kwỳ me, mehkwỳa ame ajpu, ne krĩ kwỳ me, krĩ kwỳa me ajpẽn kam pra. ");
INSERT INTO ram_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ne pjê jàhtôa kam pjê ahcujrõ, ne pjê jàhtôa kam prãam to prãm, ne pjê jàhtôa kam quê ha ame hà catia to cati. Quê ha ihprõt pê côjkwa kam ame ampo kêanre pupu, ne pjê kam cute me ampo kêanre pupun xà ata, quê ha mehcunea mã hũpaa to hũpa. ");
INSERT INTO ram_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","― Ne ita te hajỹr xwỳjrea na, ca ha ame amji pupun xà kêanre to ame amji pupu. Quê ha ame gahê ne me apro, ne hãn ne ame acahhy, ne me hacjên xà mã me gacjê, ca ha kam me acuhhê. Jirô pê mã quê ha, cute me cuprõn xà jũrkwa kam mehcukij catêjê jũhkra mã me gacjê, quê ha me acukij pa, jirô pê mã quê ha hipêr me hacjên xà kam hãn ne me ato awcapê. Ne icwỳrjapêa quê ha pjê jõ pahhi cuna mã me apyxwỳ. ");
INSERT INTO ram_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ca ha cuna mã me acuhhê, ne me ijarẽn pejti to me cumã ijarẽ. ");
INSERT INTO ram_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ne nee me acakôc xà to ate ame amji pytàr xà atajê to cormã ne ame amji japackre nare. ");
INSERT INTO ram_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ampo na? He wa ha cormã me amã acakôc xà gõ, ne me amã ate me amji jahkre pejti gõ, quê ha nee me acurê xwỳn atajê ame ato hũràc nare. ");
INSERT INTO ram_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","― Ne quê ha ajte me apãmjêa me, me akjêjêa me, me gũkjê catêjêa me, me gõ ikwỳ nõ catêjêa me, amjia kôt me hacjên xà kam me ato awcapê, ne ihtỳj me anõ cura. ");
INSERT INTO ram_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ne icwỳrjapêa quê ha mehcunea ame acurê. ");
INSERT INTO ram_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ne me awcanãa ne. Ampo na? Quê ha nee me apê akĩ nõ pyxitre nõ ipictor nare. ");
INSERT INTO ram_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na ca ha ampeaj kam me awcanã, ne atỳj me amji pytà. ");
INSERT INTO ram_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","― Ca ha krãhtare me, me hàprê catêjê me, cute me Krĩpinkrên krã na me hõmpu, ne krĩ ata jamre na me to amji japackre pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Por ca jũmjê Juta jõ pjê kam ame apa atajê, kẽnti wỳr me aprar pyrentu! Ne Krĩpinkrên jõ krĩa kam ame apa atajê, krĩ pê me gapôj, ne me aprar pyrentu! Ne por ca pur kam ame apa atajê krĩ wỳr me aprar nare! ");
INSERT INTO ram_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ampo na? He amcro atajê pê quê ha Pahpãm te Juta catêjê to kên xà jõ amcro. Ne pê ramã Pahpãm hõ kàhhôc kam, amcro atajê na, ampo cunea kên xà te hajỹr na to awjahkre. ");
INSERT INTO ram_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","― Pỳj me hêj xi, pyjê mehkra to tic atajê, ne hanea ne pyjê mã me kra kryjre atajê me, mehkà na kjê catêjê atajê! Ne pjê ita kam, quê ha me ate amji pupun xà kên crire nare me awỳr cator. Quê ha Pahpãm me awỳr me akên xà kêanre kujate, pjê ita wỳr. ");
INSERT INTO ram_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Quê ha me hàhtôa ne wapo xwahhi to mehcura, ne hanea ne me hàhtôa ne mehpro ne pjê cunea wỳr ame to ajcrà. Por krĩxàre pê mehcahkrit te me Pahpãm jahkre kêatre atajê, quê ha ihtỳj Krĩpinkrên kam ame ipa ita na, quê ha ahnaa hõ amcro cahhur kam ahtwỳ. ");
INSERT INTO ram_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","― Ne itajê cunea te hajỹr xà wỳr, ate me hahkre pej xà, quê ha pyt kam hapôj, ne putwrỳ kam hapôj, ne caxêre kam hapôj, na quê ha pjê kam itajê mehkrã acto tu ne. Côxwa jàhkrihkrit kêanre ata cupate, quê ha nee jũm cute amji kam hapac xà nõ na amji jahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ne mehcunea mã, quê ha pjê wỳr ampo kên cator xà ata hũpaa to hũpa. Na quê ha pjê kam me ajhu ne me hikwa. Ampo na? He quê ha côjkwa kam caxêre cunea amji mã ihkrĩ xà to ahpa, cwỳrjapê quê ha hũpate amjia kôt pjê kam ame ajhu. ");
INSERT INTO ram_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","― Ata caxuw quê ha côjkwa pĩn ahpar mã ipê me Ahàkà carôt tỳjti me, hàhcujrohti ata mea mã, ahpar mã iwrỳc to mõ, ahcakrã kam. Quê ha mehcunea me hõmpu ne me Ahàkà pê Pahhiti catia na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Quê ha ampo itajê hajỹr kam tẽ, ca me awcanãa ne, ne me amji tỳaj ne, ne côjkwa wỳr, ca kàj mã me rĩt. Ampo na? He ahtũm nare wa ha me apytà. Ne por ite me apytàr xà ata kôt harẽn xà te hajỹr he. ");
INSERT INTO ram_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","― Por pĩxô pàr nõ ata, nare, ampo pàr ata he. ");
INSERT INTO ram_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Quê ha ramã ihhô tetet cato, ca ha me hõmpu, ne me amji jahkre pej pyrentu, ne me amji mã harẽn to: “Ahtũm nare, quê ha ta iwrỳc pyrentu” hane. ");
INSERT INTO ram_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Quê ha ampo itajê cunea apu hane, ca ha me hõmpun to hane, ne me to amji japackre pyrentu, nãmri Pahpãm te pjê to ihhimpej xà jõ amcro ata ramã cator xàa kam. ");
INSERT INTO ram_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","― Ne me to amji japackre peaj ne, nãmri quê ha mehtĩr itajê tyc xwỳjrea na ampo itajê cunea hajỹr to hane. ");
INSERT INTO ram_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","He me ijarkwa ita to amji japackrea ne, nãmri quê ha pjê me côjkwa ihtỳj jũ caxuw hamre, ne icakôc xà ita, quê ha quêt hàhhuc rohnỳtti mã, ne nee jũ caxuw hamre nare. ");
INSERT INTO ram_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","― Ne me ca, me amji kôt hakop to impeaj to me apa. Ne nee amji kĩn na me gàkrun to pit mã me amji japackre to me apa nare. Ne nee côxỳhti to amji to me apipãn to pit mã ame amji japackre nare. Ne nee me ate amji to ame apijapar xà to pit mã ame amji japackre to me apa nare. Ca ha itajê to pit mã ate ame amji japackre to me apa na, quê ha ampo cunea jamre xà jõ amcro awỳr cato, ne amõr pejti kam apro to hane, pom quê ampo pro xà ihpro he. ");
INSERT INTO ram_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ne quê ha pjê cunea kam amehkrĩ atajê cunea wỳr amcro ata cato. ");
INSERT INTO ram_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cwỳrjapê ca ha gõtpê me amji kôpĩr peaj to me apa, ne ma Pahpãm mã me amji cajrẽn, mãr ca xwỳ mã ampo itajê pê me amji pytà, ne cupê me gapôj, ne icuna mã me acuhhê tu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pê Jeju amcro cunea kam ajco me cumã ampo to hahkrea to pyt, Pahpãm to me amji kam hapac xà jũrkwa kam. Ne ahna caxwa, pê ma krĩ pê hapôj, Pĩxô jõ kẽn wỳr, ne curia hãn ne amji to apẽ. ");
INSERT INTO ram_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pê côjkwa caprêc kôt ajco me hàhtôa ne ma Pahpãm to me amji kam hapac xà jũrkwa wỳr me pra, cute me Jeju kam hapac prãmte. ");
INSERT INTO ram_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pê ramã me Hakren xà jõ amji kĩn ata wỳr amcro incrêre ne nõ. ");
INSERT INTO ram_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pê ajco Pahpãm mã mehcajrẽn catêjê jõ pahhi me, Mojxe xwỳ jõ kàhhôc to me cumã hahkre catêjê me, ihtỳj ame Jeju curan prãm, ne tee ame to hahkre. Ampo na? Pê ampeaj kam ihkôt me cumã me hàhtôti atajê cupa na pê. ");
INSERT INTO ram_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pê me pahcurê xwỳn pê Xatanaj carõ kên ata Jeju kôt me ipa catêjê te tôxi atajê nõ, pê Juta Carijot ata mã axà. ");
INSERT INTO ram_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pê ma Juta tẽ, ne Pahpãm mã mehcajrẽn catêjê jõ pahhi me, Pahpãm to me amji kam hapac xà jũrkwa jamãr catêjê me, Jeju na cute me ajpẽn par. Mã Juta te me hũhkra mã Jeju to hahkre ne haxàr na, me cumã amji ton. ");
INSERT INTO ram_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mã ame hakry, ne cute me Juta mã ihpore jõr na me amji ton. ");
INSERT INTO ram_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mã hamre, Juta te ihpore pyr na ihtỳj cute me cumã Jeju jõr na amji ton. Quê ha nee me hàhtôti atajê nõ Jeju pupun nare kam, cute jũ ri ahte me cumã hõr na, me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mã ramã me Hakren xà to cute ame amji japackre xà jõ amcroa kam hàhhuc. Mã amcro ata kam, amji kĩn ata caxuw Juta catêjê te ahpỹanre na ame carà cahàcre hôhti kra pê mehkritxwỳ ata curan. ");
INSERT INTO ram_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mã Jeju te Petrô me Jowãw kujahêc, ne me cumã: ― Me mõ ne me pamã pyt caxuw me Hakren xà jõ amji kĩn jõ nõ to ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mã cute me Jeju cukij ne me cumã: ― Jõ ri wa ha mẽr ame pajõ ita to? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mã Jeju me cumã: ― Me ikampa, ca ha ramã krĩ mã me axàr xàa kam, quê ha me hũmre nõ ata cô jacjê ne to ipa, ca ha me ajpẽn cajpa, ne ma me hũnã, ne ihkôt me mõ. Quê ha jũ ri ikre nõ mã axà, ca ha hanea ne ihkôt me axà. ");
INSERT INTO ram_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ne me ikre jõ pahhi ata cukij, ne me cumã: “Me cumã ampo to hahkre catê te me acukij xà na me ikujahêc, wa me acukij, jũ ri mõrmõ ikre caxwỳn nõ ita, pom quê ha ihkôt me ipa catêjê me kam me me Hakren xà jõ to apà ita?” hane. ");
INSERT INTO ram_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Quê ha kỳaj pê me amã ikre caxwỳn cati nõ ata jahkre, ne ramã kam ampo cunea, kam cuhôn xà, ne kam ahna mehkrĩ xà, ne kam ahna me hàpàn xà, quê ha me amã hahkre. Ca ha curia pyt caxuw me me Hakren xà jõ nõ to ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mã hamre, ma me pra, ne krĩ mã me hàr, ne Jeju te me cumã ampo cunea jarẽn xà atajê cunea na me cator, ne cute pyt caxuw me hõ ita ton. ");
INSERT INTO ram_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mã ramã kaam hàhhuc, mã Jeju me, ihkôt me ipa catêjê me, me hàpàn xà na me hỹr, me hàpàn xà caxuw. ");
INSERT INTO ram_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mã Jeju me cumã: ― Wa ijõtpê ikên mã ixàr xwỳjrea na, me acahê na me Hakren xà jõ ita kur na amji to prãm. ");
INSERT INTO ram_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","He ampeaj kam wa ha me amã amji jarẽ, wa ha hipêr me Hakren xà jõ ita nõ krẽr nare, quê ha ahnaa Pahpãm pjê kam mehcunea to ihhimpej kam tẽ, wa ha cormã ihnõ krẽ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne cute mehkõm xà pyr, ne cute Pahpãm mã to hũrên hakryti na amji jarẽn, ne ihkôt me ipa catêjê mã: ― Mĩ, me akõm xà ita py, ne me acunea me to akõm pa. ");
INSERT INTO ram_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ampeaj kam wa ha me amã amji jarẽ, wa ha hipêr jũ caxuw pĩxô cacô ita kwỳ to ikõm nare, quê ha ahnaa Pahpãm mehcunea to ihhimpej kam tẽ, wa ha cormã ihnõ kwỳ to ikõ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jirô pê mã ri cute pãw pyr, ne Pahpãm mã to hũrên hakryti na cumã amji jarẽn, ne ihcokjêr ne ihkôt me ipa catêjê mã hõr par, ne me cumã: ― Pom pãw ita, ijĩa mã he, wa hãn ne me amã cugõ, ca atỳj me ku. Jirô pê mã, ca ha ate me ito amji japackre prãmte, atỳj pĩxô cacô ita to me ikõ, ne me pãw ita kur to me acuhhê tu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ne me hàpàn jirô pê, cute hajỹar ne pĩxô cacô na me cumã ihkõm xà jõr, ne me cumã: ― Pom pĩxô cacô ita, icaprôa mã he, ne me anaa wa ha haxwỳ. Ata to wa ha me amã ite amji kam ijapac xà intuw to awjahkre. ");
INSERT INTO ram_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","― He ramã, pom ca me jỹ itajê nõ te icurê xwỳn catêjê jũhkra mã ijaxàr, mã cute me icuran na, imã hahkre pej. ");
INSERT INTO ram_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ỹhỹ, wa ha itỳj ipê me Ahàkà cati ityc to prãm. Ampo na? Pê ramã Pahpãm ityc xà ata na amji mã to ihhimpej hiahpuro. Pỳj me hêj xi, por quê ha me ikên mã ijaxà ata, quê ha ijirôa pê amji pupun xà kêanre to amji pupu ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mã ahpỹanre na, cute me ajpẽn cukij kam mehtẽm, ne me ajpẽn mã: ― Pỳhàpà, jũm mã quê ha ajte me hũhkra mã haxà? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mã me ahna ahtũmre, Jeju kôt me ipa catêjê te ajpẽn jirôa pê me cati na me amji jarẽn kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mã ahna Jeju pê ihkaj na me kam, mã me cumã: ― Ỹhỹ, pjê ita cunea kam krĩxàre jõ pahhi cati catêjê cunea mã amji to me catia prãm. Ne cumã mehcunea te hàpên na to prãm, na ri ihtỳj me to ihhimpej. Ne por mehcunea tehcajpa atajê te ri amji to me cati prãmte amji mã me haprỳ to: “Mehcunea Tehcajpar Catêjê” hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","― Itajê cunea te hajỹr pit, ne me akwỳa kam, quê nee itajê nõ hajỹr nare. Me akwỳa kam, quê ha jũm catihti ata pê curmã jũm tuw ata pyràac. Ne por me gõ pahhi ata, quê ha ihhêj rũm cupê me amã hàpên catê pyràac. ");
INSERT INTO ram_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mẽr jũm ri, me hũmre mã amji jirô pê cati? Xà ajkĩ hàpàn xà na jỹ ata? Nare, xà ajkĩ me cumã me hõ jõr to pra ata? Ỹhỹ, por hàpàn xà na jỹ ata ri, me hũmre mã me hirôa pê cati. Ne Pahpãm mã ita na ihkaj na. Ne cumãa, por me cumã hõ jõr to pra ata ri quêt cati. Ne ipêa ri me amã hàpên catê ata pyràc. ");
INSERT INTO ram_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ca gõtpê ikôt me apa, ne icahê na ramã me ate me amji pupun xà kêanre kwỳ to ame amji pupun. ");
INSERT INTO ram_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Cwỳrjapê ri Pahpãm te me acunea to ihhimpej xà na ixãm. Ne pa, wa ha hanea ne me ate me to ahimpej xà na me apyxwỳ. ");
INSERT INTO ram_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ca ha, por curi ite ihimpej xà kam, ijàpàn xà na me akrĩ xà ata kam me apà, ne ahna me ikõ. Ne ca ha hanea ne me Pahhiti krĩ xàhti catia ata kam me akrĩ, ne Ixaher catêjê kwỳ te tôxi atajê mã cute amji kam me hapac xà na awcapi, ne ahna mehcukij, ne me cumã to ahimpej to me akrĩ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ne cute Ximãw Petrô mãn ne cumã: ― Ximãw, Ximãw, nãmri ajco, nãmri ramã me pahcurê xwỳn pê Xatanaj te ato arỳjhy, ne acarêr ne acajpẽr prãmte acaxuw amji mã Pahpãm na hàhwỳr. ");
INSERT INTO ram_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wa ramã ite, ca nee ate ito amji mã ahimpej jicu nare na, Pahpãm mã acajrẽn. Na ca ha gõtpê ipê ampỳre mã apu mõ, ne ana ahtũm nare, ca ha hacpỹa ne iwỳr amji jaxà, ne acato, ne me akwỳ mã hũcanãr xà to ihtỳaj ne ajco ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mã Petrô Jeju mã: ― Ỹhỹ, wa ita kam ihcunea caxuw apu mõ. Quê ha hapacta ne akôt me ijaxà, ne jũ na me ito. Wa ha itỳj awcanã ne akôt ty. Ne nee imã ihnõ na hũpa kênre hamreare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mã Jeju cumã: ― Petrô, ampeaj kam wa amã awjarẽ. Ca ha caxwa ita kam, hôxãhxãc kàr xwỳjrea na ate ijahkre pej nare na, amji to ahêj to incrê ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jirô pê mã ri Jeju te ihkôt me ipa catêjê cukij, ne me cumã: ― Xà ca gõtpê amcro ata to me amji japackre, mãr pê wa me akujate ata to? Pê wa me apê ihpore cjên xà nare kam me akujate, ne me apê me akà nare kam me akujate, ne me apê ampo hamreare kam me akujate. Xà ca gõtpê ajkĩ ite me apê ampo hamreare kam me akujahêc ata to me amji japackre? Xà pê ajkĩ hõtpê me apê ampo hamreare? ― hajỹr. Mã me Jeju mã: ― Quê, me ipê ampo hamreare nare, pê hõtpê me imã ampo cunea ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mã Jeju me cumã: ― Por me amã ihpore cjên xà atajê me, me gàhcukrêj atajê me, gapacta ne ita caxuw me acwa. Ne por me apê wapo xwahhi nare atajê, atỳj me gitô kà to ihpore na me ahpa, ne amji mã me to wapo xwahhihti japrô. ");
INSERT INTO ram_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pê ramã Pahpãm jarkwa na mehcakôc catêjê nõ hõ kàhhôc kam, ina ihhôc to hane he: “Quê ha mehkên catêjê me, me to ajpẽan” hane. Ampeaj kam wa me amã awjarẽ, por pê ramã ihkàhhôc ina ampo to hũjarẽn xà to awjarẽ ata, quê ha ihtỳj ito hanea to ito hane ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mã ihkôt me ipa catêjê me cumã: ― Me ijõ Pahhi, nãmhã, ramã wapo xwahhihti pijakrut he ― hane. Mã Jeju me cumã: ― Mẽr nãmhã, quê ha taa mã ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mã hamre, ma caxwa ri Jeju Pĩxô jõ kẽn wỳr mõ. Pê ramã curi ipa to amji pyràac, na pê mõ. Pê ma ihkôt me ipa catêjê ihkôt me mõ. ");
INSERT INTO ram_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ne curi me cator, mã cute amji mã hỹr xà ata mã cator ne kam hỹr, ne ihkôt me ipa catêjê mã: ― Ma Pahpãm mã me acakôc, ne cumã me amji cajrẽn, ne ahna me ahwỳ, mãr quê ma me atête me pahcurê xwỳn to pên to mõ, mãr quê nee me acyt, ca ame cumã me apec nare prãmte ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ne hãm, ne cute cahi rẽn to trĩnta ne ihkõn krã na hỹr, ne cute Hũm Cati mã ihcakôc kam ihtẽm, ne cumã: ");
INSERT INTO ram_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","― Inxũ Cati, pom wa ikên xà na amji pupu ita pê ihhêj rũm ikõm xà pyràac. Wa ma apu ikên ita cunea to ikõm caca. Quê ha amã itête ikên to ikõm xà ita camẽn prãm na, ca ha gapacta ne atỳj itête camẽ, nãmri quê ha amã ite to ikõm na ito prãm na, wa ha itỳj to ikõ. Ampo na? Por ate ampo to amji mã ina prãm xà ata na, wa ha itỳj ahnaa mã akôt amji kampa ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mã côjkwa pĩn Pahpãm jarkwa na imprar catê nõ hỹrmã iwrỳc, cute cumã hũcanãr xà to ihtỳj prãmte. ");
INSERT INTO ram_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mã cumã amji kĩn nare ata te ihcãmxêr, ita pê ihhêj rũm ampo xà ihtỳaj te ihcãmxêr. Mã hũcanãar kam cormã Hũm Cati mã ihcakôc. Mã ahna cô pehpec ita pê ihhêj rũm caprô te pjê kam apu ihpehpec pyràac. ");
INSERT INTO ram_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mã cute cumã ihcakôc jirô pê hãm, ne ma ihkôt me ipa catêjê wỳr mõ. Ne me hõt wỳr cator, mã ihtỳj me hikwa ne ame gõr, ne pê me cumã amji kĩn nare, na pê me hikwa ne ame gõr. ");
INSERT INTO ram_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mã cute me cumã harkwa cator, ne me cumã: ― Ampo na mã ca me gikwa ne ame gõr? Ame ampra ne ame to acuhhê, ne Pahpãm na ame ahwỳ, mãr quê nee me pahcurê xwỳn me amã ampo kên to hahkre nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ne Jeju cormã ame cumã ihcakôc kwỳa kam, mã me hàhtôa ne hỹrmã me cator. Ne pê Juta Carijot ita pê Jeju kôt me ipa catêjê te tôxi atajê nõa, Jeju wỳr me hàhtôa ne me to mõ, ne ma Jeju wỳr tẽ, ne cute cahôr prãmte ahna hàhtêp. ");
INSERT INTO ram_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mã Jeju cumã: ― Xà ca ha ajkĩ atỳj ipê me Ahàkà cahôr xà ita to kên mã amẽ? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mã Jeju kôt me ipa catêjê te ita na me hõmpun to hajỹr, ne cute me Jeju mã: ― Me ijõ Pahhi, xà wa ha itỳj me ijõ wapo xwahhihti ita to me kam tẽ? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mã mehnõa te wapo xwahhihti to Pahpãm mã mehcajrẽn catêjê jõ pahhi mã hàpên catê nõ ata kam ihtẽm, ne cupê hapac jakep, awpôc rũm. ");
INSERT INTO ram_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mã Jeju cumã: ― Ame hajỹr nare! ― hane. Ne cute hapac jakep ita na hũ xir, ne cumã ihcupên, ne cumã to impej pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jirô pê mã ri Pahpãm mã mehcajrẽn catêjê jõ pahhi me, Pahpãm jũrkwa jamãr catêjê me, prohti kam me, cute mehpro. Mã Jeju te me cumã harkwa to: ― Pỳhàpà, xà ajkĩ ipê cute me pahhi jũhhyr na me to ihhimpej catê jõ pahhi na mã, ca me gõ kôtàre me, me gõ xwapo xwahhihti itajê to me ipro to me mõ? ");
INSERT INTO ram_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pom wa amcro cunea kam Pahpãm to me amji kam hapac xà jũrkwa kam me acape na apu ipa ita? Ca rỳ jũ caxuw ate me ipro prãm nare. Ne hamre ita kam ri me gõ amcro, ne me pahcurê xwỳn jõ amcro, na ca ha atỳj me pahcurê xwỳn jõ awcapàtkôa kam ame apê ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ne hamre, cute me Jeju pro, ne ma cute Pahpãm mã mehcajrẽn catêjê jõ pahhi jũrkwa wỳr me to mõ, ne me to hàr. Mã Petrô hapua na Jeju na mehkôt mõ. ");
INSERT INTO ram_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mã ikre jarkwa cahê na, carã ata kam cute me cuhôn, ne ipu na amehkrĩ, mã ma Petrô mehwỳr mõ, ne me cahê na cuhy na hỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mã ikre kam hàpên catêjê cahãj nõ ata te Petrô pupun, ne xa ne hõmpun tỳjti, ne cumã: ― Pom jỹ ita pê Jeju na mehkwỳ nõa ri ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mã Petrô cumã: ― Pỳhàpà, pyjê nõ ita, wa nee ite jũm ita jahkre pej nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ne ahna ahtũmre mã mehkwỳa xũmre nõ ita tẽ ne cumã: ― Apê mehkwỳ nõa mã ca ― hane. Mã Petrô cumã: ― Hũmre nõ ita, nee ipê mehkwỳ nare, ipê jũmjê itajê jahkre kêatre ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ne hamre, ahna ahtũm rya mã mehnõa hỹrmã mõ, ne cute Petrô mã: ― Ỹhỹ, he ampeaj kam ri cupê mehkwỳa nõ mã, pom hanea ne cupê Hĩpôjajo catêjê nõ ita? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mã Petrô amji tête apu cumã ihhêj, ne cumã: ― Hãpà, hũmre nõ ita, pom ca apu ampo jarẽ ita, ipê hahkre kêatre, wa nee ite hahkre pej nare ― hane. Ne cormã jỹ ne apu ihcakôc kwỳa kam mã hôxãhxãc kàr. ");
INSERT INTO ram_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mã ikre kam, hacpỹ ne Jeju Petrô wỳr ipipkjêr ne hõmpun tỳjti. Mã cute Jeju te cumã: “Caxwa ita kam, hôxãhxãc kàr xwỳjrea na, ca ha ate ijahkre pej nare na amji to ahêj to incrê” hajỹr na, to amji japackre pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ne ma hãm ne cator ne mõ. Mã ihpahàm te ihcãmxêr pyrentu, mã amrãa to amrã. ");
INSERT INTO ram_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mã me hũmre ame Jeju jamã atajê ame hũn kêanre, ne amehcahhy. ");
INSERT INTO ram_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne mento pro ne mehcukij to: ― Mẽr jũm te mã acakwĩn? Harẽ! ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mã hamre, me hũmre itajê ame hapactua kam ame ahna xwỳ. ");
INSERT INTO ram_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mã apẽ, mã cute me amji to cuprõn. Prohti kam me, cute Pahpãm mã mehcajrẽn catêjê jõ pahhi me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, cute me amji to cuprõn. Ne cute me cuprõn jirô pê mã ri cute me Jeju na hàhwỳr, prohti kam me hipôc ri hãm prãmte. Mã cute me hãm. ");
INSERT INTO ram_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mã cute mehcukij, ne me cumã: ― Me imã amji jarẽ, xà apê, por pê Pahpãm Crixtô capi ne to awjahkre ata mã ca? ― hajỹr. Mã Jeju me cumã: ― Ỹhỹ, xà wa me amã amji jarẽ, ca me ikampa ne gõtpê amji mã me ito ahimpej? Hãpà. ");
INSERT INTO ram_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Xà wa hanea ne me acukij, ca ajkĩ me imã ampo jarẽ? Hãpà. ");
INSERT INTO ram_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ne hamre, quê ha hãn ne ipê me Ahàkà, Pahpãm carôt catia kam, awpôc rũm, hĩkjê rũm jỹ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mã mehcunea me cumã: ― Pỳhàpà, xà ampeaj kam apê Pahpãm kra? ― hane. Mã Jeju me cumã: ― Ỹhỹ, pom ca me caa ipê Pahpãm kra na me ijarẽ ita? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mã cute mempar ne ajpẽn mã me harkwa to: ― Ỹhỹ, ita caxuw cu nee jũ rũm me jũm te harẽn xà kên nõ kam me pajapac prãm nare. Ampo na? Ramã harkwa te harẽn xà kêanre to harẽn, cu pahte me pajapac jĩa to mempar ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mã prohti kam mehcunea xãm, ne ma Jeju to, por Pirat pê Roman jõ pahhiti jarkwa kôt krĩ to ihhimpej catê ata wỳr me mõ, ne cuna mã cute me hãm. ");
INSERT INTO ram_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne cute me Jeju kôt harẽn to me hêj xi xà kêanre kam me to ihtẽm, ne me cumã: ― Ỹhỹ pahhi Pirat, wa ampo na ite me hũmre ita pro ne awỳr me to imõr nare. Wa ite me ijapac jĩa to mempar, mã apu Roman catêjê jõ pahhiti pê Xexa jũhhyr prãm. Ne hanea ne, me ikam mare mã, quê nee pjê jahpan xà na me Roman catêjê jõ pahhiti mã me hàmjõr nare na, me to ihcakôc to ipa. Ne hanea ne apu cupê Crixtô na amji jarẽ, ne quê ha xwahna ihtỳj amji to me ijõ pahhiti ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mã Pirat te Jeju cukij ne cumã: ― Xà ajkĩ apê Juta catêjê jõ pahhiti? ― hajỹr. Mã Jeju cumã: ― Pom ca caa ijarẽ ita? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mã Pirat te Pahpãm mã mehcajrẽn catêjê jõ pahhi me, me hàhtôa atajê mã: ― Ampo cwỳrjapê wa ihcuran na me cumẽ? Wa nee ite hũmre ita kam ampo kên pupun nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mã hipêr Pirat cunaa mã, cute me harẽn kam mehtẽm ne me harẽn to: ― Krĩ cunea kôt cute ampo to hahkre xà itajê to ajpẽn caxuw me irẽc to ipa. Hĩpôjajo jõ pjê kam ri cute kam to ihtẽm, ne ramã me pajõ krĩ pê Krĩpinkrêan kam, cute ton kam ihtẽm he ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mã Pirat te me kam hapac ne me cumã: ― Pỳhàpà, xãmte hũmre ita pê Hĩpôjajo jõ pjê catêjê nõ mã? ― hajỹr. Mã me cumã: ― Ỹhỹ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mã Pirat te Jeju pê Hĩpôjajo catêjê nõ na hahkre pej, ne ma pahhi Heroti pê Hĩpôjajo jõ pjê jõ pahhi mã ihkujahêc. Pê ramã Krĩpinkrên kam Heroti apu mõ, na pê hỹrmã ihkujate. ");
INSERT INTO ram_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mã curi me to cator, mã Heroti apu hakry. Ampo na? Cumã Jeju pupun prãm, cwỳrjapê ri apu hakry. Ne rỳ pêa mã hãn ne Heroti Jeju te ampo cunea pihho impejti ton xà atajê na harẽn pa. Ne rỳ jũ caxuw cute hõmpun nare, ne cormã cute hõmpun, cwỳrjapê ri apu hakry. Ne apu Jeju cukij, Jeju te kam mare mã cumã ampo pihho pejti ton, mã cute hõmpun prãmte. ");
INSERT INTO ram_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne cute ampo jàhtôa ne ahna ihcukij, mã nee Jeju te cumã jũ mãn nare, ne aracri cupê xa. ");
INSERT INTO ram_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mã hamre, Pahpãm mã mehcajrẽn catêjê jõ pahhi me, me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, Heroti wỳr me cator, ne Heroti kam mare mã cute me Jeju to mehhêj xi xà kêanre to mehhêj xi kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mã Heroti jõ krãhtare atajê cama apu Jeju to hapactu xà kêanre to me hapactu. Ne ame ahna xwỳ, ne pea cute me pahhi kà mã haxàr, ne me hapactua kam ame to pahhi. Ne pahhi kà impejti ata mã cute me haxàr, jirô pê mã ri hacpỹa mã cute pahhi Pirat mã mehkujahêc. ");
INSERT INTO ram_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mã hamre, amcro ata kam, Heroti me Pirat te amji to me ikwỳ nõ. Pê mam nee amji to me hõ ikwỳ nõ nare. Pê mam nee me amji cajrẽn nare, ne ajco me ajpẽn curê. ");
INSERT INTO ram_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mã Pirat te me Pahpãm mã mehcajrẽn catêjê jõ pahhi me, Juta catêjê jõ pahhi me, por curi me hàhtôa ne ahna me xa atajê me, cute me to cuprõn, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","― Pom ca iwỳr me hũmre to mõ, ne ate me imã cute pahhi jũhhyr na harẽn ata na, ite ramã ihcukij, ne nee ite kam ampo kên mã icator ne hõmpun nare, pom ca ampo na ame imã to awjarẽ atajê na. ");
INSERT INTO ram_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mã hanea ne Heroti te harkwa kên nõ na impar nare, cwỳrjapê ri hacpỹa ne cute imã ihkujahêc. Ne nee me anõ kam mare mã hũmre ita te ampo to kên nare. Ne mẽr ampo cwỳrjapê wa ha ajte ahna me cumẽ, quê mehcura? ");
INSERT INTO ram_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wa ha cama pryti kà kam wakỳre to ihcahhyr na me cumẽ, quê ha amehcahhy, jirô pê mã wa ha ma ihkujate, quê ha tẽ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ne me Hakren xà jõ amcroa kam ri cute ampo to me amji pyràc xà ata pê hane he. Pê Pirat hãn ne hõtpê me harkwa kôt me cumã me hacjên catêjê pyxit ne hapôj. ");
INSERT INTO ram_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mã me hàhtôti atajê te me caràr kam mehtẽm, ne ame caràr to: ― Me imã hũmre ita tyc na to prãm, ne Parapa mã ca ha me imã hikra ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ne pê Parapa ata pê apu pahhi jũhhyr prãm, pê hanea ne ramã jũm ita cura, cwỳrjapê pê me haxà, pê ajco hikwa. ");
INSERT INTO ram_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mã hacpỹ ma mã Pirat te me hàhtôa atajê cukij, cute Jeju mã hikran prãmte. ");
INSERT INTO ram_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mã hipêr mehcunea te me caràr to: ― Pĩ kam me axô, quê ty! Pĩ kam me axô, quê ty! ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mã hamre, Pirat te mehcukij to incrê ita caxuw ri me cumã: ― Nee cute ampo to kên nare, wa ha ajte ihcuran na me cumẽ. Wa ha cama pryti kà to apu ihcahhyr na pit mã me cumẽ, quê ha amehcahhy, wa ha ma cumã hikra, quê ha tẽ ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hamre, mã kỳj cati pêa mã ame caràr, ne pĩ kam menxôr na awjahkre, me caràar kam. Ne cute me caràr ita to me Pirat hi kwĩn. ");
INSERT INTO ram_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mã Pirat te Jeju curan na me mẽn. Pom pê ahnaa ajco me to prãm ata na ri cute ahna me mẽn. ");
INSERT INTO ram_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ne cute Parapa te apu pahhi jũhhyr prãm, ne ramã jũm curan ata mã hikran. Ne me hũhkra mã Jeju jaxàr, quêt taa jũ na me to, por jũ mã cute ame ton prãm xà ata na. ");
INSERT INTO ram_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mã hamre, ma Jeju to me mõ. Ne me to mõr kwỳa kam cute pry kôt me Xiren jõ krĩ catêjê nõ cajpar, pê haprỳ Ximãw. Pê pur pĩn mõ, pê mehcajpa ne mehpro ne pĩhti ata krac ri me haxà, ne ahna me cumã quêt to mõ, pê ma Jeju kôt to kwỳ. ");
INSERT INTO ram_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mã me hàhtôa ne hapu na Jeju na me hõmpun to me mõ. Mã pyjê kwỳ Jeju kôt me mõ atajê ahna ame hõmpu, ne cama ame caprĩ ne ame kam amrã. ");
INSERT INTO ram_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mã hacpỹ mã me hỹrmã pipkjêr, ne cute me cumã harkwa to: ― Krĩpinkrên jõ pyjê itajê, nee ca ikam ame acwỳr nare, ne me akra kam ca quêt ame amrã. ");
INSERT INTO ram_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ampo na? He quê ha cormã krĩ ita jõ amcro kêanre kam ahtwỳ, quê ame garẽn to: “Por jũ caxuw pyjê itajê nõ mã ihkra nare, mã nee cute to pijahôr nare, ne nee to ipijapar nare atajê, quê ha ame hakrya to ame hakry” hane. ");
INSERT INTO ram_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Quê ha jũ caxuw amcro ata kam ahtwỳ, quê ha me hũmre kwỳ me kẽnti nõ mã: “Hã, kẽnti ita me ijipy apỳm” hane. ― Quê ha hanea ne me hũmre kwỳ kẽn jawênre atajê mã: “Me ito amxu” hane. ");
INSERT INTO ram_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ỹhỹ, me papê cuhy caxuw pĩ pyràac, ne pa ri cormã icoti na wa apu amji pupun xà kêanre to amji pupu. Ne me ca nare, ca ha jũ caxuw me acrà, ne ijirôa pê ame amji pupun xà kêanre nõ to ame amji pupu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ne Jeju kôt me hàhkĩj xi pijakrut ne me to mõ, cute mehcuran prãmte. ");
INSERT INTO ram_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ne kẽn japrỳ te Corcota ata kôt harẽn xà te “Mehkrãhhi jõ kẽn” ata wỳr me to cator. Ne pĩ na cute wakỳti to me Jeju jũhkra me ihpar cuhhêc, ne ahna me hãm. Ne hanea ne me hàhkĩj xi atajê to cute me hajỹar ne pĩ na me haxôr, ne awpôc rũm me ita xôr, ne awke rũm me ita xôr. ");
INSERT INTO ram_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mã Jeju te Hũm Cati mã mehcajrẽn to: ― Inxũ Cati, pom ame ito kên itajê pê ijahkre kêatre, cwỳrjapê ri ame ito hane, na ca ha nee ame kam acryc nare, ne cute me ito kên ita to tojnõ ― hajỹr. Mã krãhtare atajê te Jeju kà to ame ipicràn, ne kẽn te amji pê hũhkàr xà to ihkôt ame amji pê hũhkà, jũm mõrmõ quê ha amji pê to ihkà itajê jũhkà. ");
INSERT INTO ram_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mã me hàhtôa ne ahna me xa, ne ame hõmpu. Mã me kam mare mã, Juta catêjê jõ pahhi kwỳ apu Jeju na xwỳ, ne me cumã: ― Pỳhàpà, pom ca atỳj mehkwỳ pytàr to apa ita? Pom apê Pahpãm kra ita, ca mẽr pĩ ita pê amji capa ne wrỳ ne amji pytà. Me imã nee apê Pahpãm kra nare. Quê ha apê Pahpãm kra na mã, ca ha atỳj pĩ ita pê wrỳ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mã hamre, krãhtare catêjê ame ahna xwỳ ne ame cumã. Mã mehkwỳ xwỳjê ame cumãn kêanre, ne me hapactua kam ame ahna xwỳ. Mã krãhtare nõa Jeju wỳr pĩxô cacô xỳre ata to tẽ, ne cute to kam hapac, ne cumã: ");
INSERT INTO ram_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","― Krãa, pom apê Juta catêjê jõ pahhi ita, mẽr ampo na mã ca pĩ ita pê ate amji caxàr ne awrỳc nare? ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ne Jeju krã incwỳrpê pĩ na ihkàhhôc ajêt ata pê hũjarẽn to hane he: “Cupê Juta Catêjê Jõ Pahhiti” hane. ");
INSERT INTO ram_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mã me hàhkĩj xi pijakrut ne pĩ na Jeju cahê na me ajêt atajê nõ apu Jeju mã, ne cumãn to: ― Pỳhàpà, pom apê Crixtô ita? Xà ca ha amji pytàr ne amji kôt me ipytàr nare? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mã me hàhkĩj xi catê nõ Jeju jĩkjê rũm ajêt ata apu Jeju cwỳrjapê ihnõ ita kam incryc, ne cumã: ― Pỳhàpà, xà nee amã Pahpãm cupa nare? Ampo na mã ca apu cumã? Pom cu me pancrê itajê cunea me amji pupun xà kêanre to me amji pupu ita? ");
INSERT INTO ram_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pahte ri ampo kêanre ton, ne hũmre ita te nee ampo kên ton nare cakrô, ihtỳj me pahcunea kên xà ita mã hàr. Ne pahkên xà ita pê cu ajco amji to hapê, ne hũmre impejti ita pê nee ajco amji to kên xà ita japên nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne cute Jeju mã amji jarẽn, ne cumã: ― Jeju, ca ha jũ caxuw Juta catêjê jõ pahhi na amji to, ne hacpỹ ne ate amji jaxàr xà ata kam, ito amji japackrea ne ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mã Jeju cumã: ― Ỹhỹ, wa ha ampeaj kam amã awjarẽ, ca ha ita kam icahê na, por curi mempejti tyc caxwỳn tĩar ame ipa ata ri, cu ha ajwar apu mõ ― hane. ");
INSERT INTO ram_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Mã Pahpãm to me amji kam hapac xà jũrkwa kam Pahpãm jũrkwa caxwỳn me, me hũmre tekjê ata te amji mã ahhyr xà na, cupẽhkà pohti ajêt ata te awryc mã amji jipôn, ne ajpẽn wỳr ihkre. ");
INSERT INTO ram_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mã hamre, Jeju hipêr kỳj cati pêa mã caràr, ne caràar kam cute Hũm Cati mã harkwa to: ― Inxũ Cati, hamre, wa ha ty, ne icarõ quê ha ma awỳr api ― hajỹr. Ne cute amji jarẽn jirô pê mã ihtyc. ");
INSERT INTO ram_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mã Roman catêjê nõ pê krãhtare jõ pahhi cati ata te Pahpãm pej na amji mã harẽn, ne taa amji mã: ― Xãmte ampeaj kam hũmre ita peaj to impej ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ne por cute mehtyc xà na me hõmpun xà caxuw me cuprõn atajê te me ita pupun, ne ma ame amji jacjên, ne me cumã amji kĩn nõ xàhte, amji jõkôt kam ame amji cahhyr to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mã Jeju jõ ikwỳ nõ catêjê me, pyjê me, por pê Hĩpôjajo jõ pjêa rũm ajpên ihkôt me mõ atajê, ampỳa mã mehcuhhê ne ahna ame hõmpu. ");
INSERT INTO ram_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pê me hũmre ihnõ japrỳ pê Joje, ata pê Krĩhkàhti catêjê nõ, ne ajco catyt kam ipa. Ne cupê hũmre impejti, cute amji kam hapac xà cunea to, ne ajco Pahpãm himpej xà kujahêc xà ata japên to hikaj to ipa. Ne nee cupê mehkwỳ, ne Jeju cuna mã harkwa kên nõ to ihcakôc nare, ne catyt kam ahna ihcakôc, ne mehkwỳ te amji kam hapac xà kaj na ajco amji kampa. ");
INSERT INTO ram_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ne ma Pirat jũrkwa wỳr tẽ, cute Jeju na ihwỳr, ne pĩ pê ihtyc caxàr prãmte. ");
INSERT INTO ram_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mã Pirat te cumã hahkre, mã ma tẽ ne cute pĩ pê caxàr. Ne cute cupẽhkà jakati impejti ata to Jeju jĩ cunea cupu, ne ma rỳ jũ caxuw jũm te kẽn kre ita kam amji jarêt nare, ne cormã intuwti ata wỳr to kwỳ, ne cute kam hir, ne ahna to hihê. ");
INSERT INTO ram_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ne mehkôt xà jõ amcro xwỳjrea na pê ita hane. ");
INSERT INTO ram_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ne por Hĩpôjajo jõ pjê rũm, pyjê Jeju kôt me mõ atajê te Joje te kẽn kre ata kam Jeju jarêt na me hõmpun. ");
INSERT INTO ram_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ne ma ikre wỳr cute me amji jacjên ne me mõ. Ne cute me to amji pyràc xà ata kôt, cute me Jeju jĩ cuxwa prãmte ame ampo cacô cuxwati, incoti ita cwỳr, ne ame to ipicacwỳr. Ne nee amcro ata kam hacpỹ mã cute me to amji jacjên nare, ne curia amehkôt to ame ipa, mehkôt xà jõ amcro atajê kam. ");
INSERT INTO ram_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ne mehkôt xà jõ amcro atajê jirô pê mã ri, iràrà na, ma Jeju kre wỳr pyjê atajê ampo cacô atajê to me pra. ");
INSERT INTO ram_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ne ramã kre na me hàhtêp to pra, ne ampỳa mã cute me kre pupun. Mã kre jihê xà pê kẽn te kujti pyràcti ata jũm te ramã hihê mẽn, mã hihê mẽn xa. ");
INSERT INTO ram_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mã kẽn kre mã me hàr, ne nee cute me Jeju jĩ pupun nare, ne mehkrã pictor tu. ");
INSERT INTO ram_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mã krãa, me hũmre pijakrut ne mehkà jakati pràti kam me cuna mã me xa. ");
INSERT INTO ram_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mã hamre, me hũpate pjê kam ame ipihur. Mã me hũmre itajê te pyjê itajê mã me harkwa to: ― Ampo caxuw mã ca amehtyc cote na ramã hacpỹa mã jũm tĩr ata japê? ");
INSERT INTO ram_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","He ramã hacpỹa mã ihtĩr, ne nee ita ri apu mõr nare, ne por Hĩpôjajo jõ pjê kam cute me amã amji jarẽn ata na ca me to amji japackre. ");
INSERT INTO ram_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pê me amã amji jarẽn to hane he: “Quê ha ihtỳj jũm mehkên catêjê jũhkra mã, ipê me Ahàkà jaxà, quê ha mehkên catêjê pĩ na me cuxô. Quê ha ty ne ahna amcro incrê, quê ha hacpỹa mã ihtĩr” ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mã pyjê itajê te harkwa to me amji japackre pyrentu. ");
INSERT INTO ram_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ne ma ikre wỳr me pra ne me cator, ne Jeju kôt me ipa catêjê te õxi atajê me, mehkwỳ mã, ame awjarẽ. ");
INSERT INTO ram_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ne pyjê itajê pê ame awjarẽ he: Marij Matarkwỳj me, Jowanakwỳj me, Tijac menxi pê Marij me, por pê mehkwỳa kwỳ mehkôt me mõ atajê mã, pê ihtỳj hanea ne ame harẽ. ");
INSERT INTO ram_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mã Jeju kôt me ipa catêjê te nee me pyjê atajê te me cumã hũjarẽn xà itajê na me kam hapac nare, ne ihtỳj cute ame hũjarẽn to ame ipa na, amji mã me to hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ne Petrô nare, pê hãm pyrentu ne ma kẽn kre wỳr ajcahu. Ne kẽn kre ri cator, ne cumã nõr, ne nee Jeju jĩ pupun nare, ne cupẽhkà te hĩ cupu, mã cupê cator ata na, ahnaa hakàn pê nõ. Mã ma hacpỹ mã ikre wỳr cute amji jaxàr ne tẽ, ne ita to cama apu amji kam hapac to amji mã ipikrar to mõ. ");
INSERT INTO ram_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mã amcro ata na ma krĩ wên japrỳ te Mewỳrcacro ata wỳr Jeju kôt me ipa catêjê pijakrut ne me mõ. Pê krĩ wên ita hõtpê Krĩpinkrên pê ampỳre mã xa, mõrmõ pê hỹrmã rec pyxit ne ihkôt hĩkjê kam pê xa. ");
INSERT INTO ram_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ne pry kôt ihtỳj Jeju pupun xà kêanre atajê to, ajco amji mã me hũjarẽn to me mõ. ");
INSERT INTO ram_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ne cormã amji mã me hũjarẽn to me hàhpan to me mõar kam, mã krãa, Jeju me ahna cator ne ma mehkôt mõ. ");
INSERT INTO ram_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mã cute me hõmpun, mã jũa mã cute amji tête mehkrã ton, mã nee cute me cupê Jeju na me hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mã me cumã: ― Ampo ca pry kôt amji mã me harẽn to me mõ ata? ― hane. Mã me hàhhuc ne me cumã amji kĩn nare. ");
INSERT INTO ram_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mã ihnõ japrỳ te Cripa ita cumã: ― Pỳhàpà, xà ca apyxit peaj ne ajte Krĩpinkrên kam akrĩ, ne nee ate cormã amcro incrê cahhur ita kam ampo te hajỹr xà ata na hahkre pej nare? ― hane. ");
INSERT INTO ram_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mã Jeju cumã: ― Ampo? ― hane. Mã cumã: ― Por Naxare jõ krĩ pĩn Jeju cator ata pê me pamã hũmre pê Pahpãm jarkwa to ihcakôc catê. Ne ampeaj kam Pahpãm jarkwa to ihcakôc, ne hàpên xà to into hihtỳj, ne me pamã cupê Pahpãam to Pahpãm. ");
INSERT INTO ram_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mã ajte Pahpãm mã mehcajrẽn catêjê jõ pahhi me, me pajõ pahhi me, cute me hũhkra mã me haxàr, mã cute ame to kêanre. Ne cute pĩ kam me inxôr, ne hũhkra me ihpar kam me wakỳre cuhhêc, ne toa mehcuran. ");
INSERT INTO ram_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ne pê wa ajco cute Juta catêjê to amji pytàr na mehcãmjĩ, ne ahna me hikaj. Ne cormã ampo te hajỹr xà ita na amcro incrê peaj. ");
INSERT INTO ram_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ne me ikwỳa kam pyjê nõ ma kẽn kre kam cute me harêt ata wỳr me pra. Ne nee cute hipêr me Jeju jĩ pupun nare. Cwỳrjapê wa me icunea amji mã me to ijapôj to me ipa. ");
INSERT INTO ram_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ne pyjê atajê te me amji jaxàr ne ame imã awjarẽ, xwahna cute me côjkwa pĩn Pahpãm jarkwa to memprar catêjê pit pupun. Mã xwahna ramã hacpỹa mã ihtĩr na ame cumã harẽ. ");
INSERT INTO ram_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mã me ikwỳa kwỳ te me hahpan, ne pyjê te me harẽn xà atajêa na cute me hõmpun, ne nee cute me Jeju jĩ pupun nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mã Jeju te me cumã hũjarẽn to: ― Pỳhàpà, mã ajte ca nee uu ne ame pamã Pahpãm jarkwa to mehcakôc catêjê jarkwa kam me gapac nare. ");
INSERT INTO ram_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pê ihtỳj Crixtô ata kên na amji pupun to prãm. Ne quê ha cute amji pupun xà kêanre na amji pupun ata jahpan xà na, quê ha mehcunea jirôa pê hàmtàr cati na, hãn ne mehcunea me hahkre pej ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne cute ihkrãa kam me cumã Mojxe xwỳ jõ kàhhôc rũm cahyt kam ihtẽm, ne ihkôt harẽn, ne ihkôt Pahpãm jarkwa to mehcakôc catêjê cunea jõ kàhhôc kwỳ cahyt par. Ne me cumã, por ampo te ihkàhhôc kam jũ mã ton xà atajêa na amji kôt harẽn partu. ");
INSERT INTO ram_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ne krĩ wên ata na ramã me hàhtêp, ne ramã me cator xàa kam, mã Jeju ma mehhyr ne ihtẽm prãm. ");
INSERT INTO ram_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mã ma amji na ame huwahi, ne me cumã: ― Atẽm nare, ne ita ri me ina ahtwỳ, nãmri ramã pyttu ― hane. Mã Jeju me ipijakrut atajê cahê na hàhhuc. ");
INSERT INTO ram_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ne me cahê na hỹr, ne cute pãw pyr ne to Pahpãm mã hũrên hakryti na amji jarẽn jirô pê, cute ihcokjêr ne me cumã hõr. ");
INSERT INTO ram_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ne cute me cumã hõr me ajkaam mã cormã mehkrã kre, mã cute cupê Jeju na me hahkre pej, me ajkaam, mã hãm xà ata kam hamre, ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mã ajwar ajpẽn mã me harẽ, ne me ajpẽn mã: ― Pỳhàpà, pry kôt pamã ihkàhhôc krã krutre jarẽn to mõr ata kam, cu ramã pahna cuhkõnrea kam amji mã to hajỹr pyrentu ― hane. ");
INSERT INTO ram_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ne me hãm pyrentu, ne ma hacpỹ mã Krĩpinkrên wỳr me pra, ne ihkôt me ipa catêjê kwỳ wỳr me cator, ne ame cumã harẽ. ");
INSERT INTO ram_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mã mehkwỳ me ipijakrut atajê mã: ― Ampeaj kam ri me pajõ Pahhiti hacpỹa mã ihtĩr! He hanea Petrô te hõmpun! ― hane. ");
INSERT INTO ram_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mã me ipijakrut itajê te hajỹar ne, por pry kôt cute me hõmpun, ne hanea ne ikre kam me cumã pãw cokjêr na cute me hõmpun ata na, cute me cumã harẽn. ");
INSERT INTO ram_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ne cormã me amji mã harẽn kwaa kam, mã krãa, mehcote na Jeju cator, ne cute me cumã harkwa to: ― Hàpà, mãr me apeaj? Nee ca icupate ame akrihkrit nare ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mã mehcunea pikrar ne mehcunea mã paa to pa. Ampo na? He ihtỳj cute me jũm carõ pupun na ame amji cãmjĩ, na ri ame paa to ame pa. ");
INSERT INTO ram_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mã Jeju me cumã: ― Ampo na mã ca ito ame amji mã ajkra, ne ame ahkrihkrit? Ampo na mã ca cormã nee me akrã kam amji mã me ito hajỹr nare? ");
INSERT INTO ram_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Me ijũhkra pupu, ne me ipar pupu. He ipê Jeju, pa wa. Me icupê ne me ijahkre pej, pom wa ijĩa xa ita. He me carõ jĩ nare, ne nee mehhi nare ― hane. ");
INSERT INTO ram_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ne cute ita jarẽn jirô pê cute me cumã hũhkra me ihpar jahkre, mã cute ihtỳj me wakỳre te caxwỳr xà xwa kre pupun. ");
INSERT INTO ram_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ne me hakryte ma ajmãr cupê Jeju na ame ahna aprã. Ne ihtỳj cormã amji mã me ajkra. Cwỳrjapê ri Jeju te mehcukij ne me cumã: ― Xà ajkĩ ita ri me apê ampo krẽr xà hamreare? Wa ihkwỳ krẽ, ca ihkur na me ipupu ― hajỹr. ");
INSERT INTO ram_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mã cute me cumã tep xêt nõ ita kwỳ. ");
INSERT INTO ram_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mã me kam mare mã xa ne cuku. ");
INSERT INTO ram_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne me cumã: ― Ne por wa ame acahê na imõr kwỳa kam, amji na ite me amã ampo jarẽn atajê te ito hajỹr to prãm, ata na ri cute ito hajỹr. Por pê Mojxe xwỳ jõ kàhhôc me, Tawi xwỳ jõ kàhhôc me, mehkwỳ jõ kàhhôc ito hũjarẽn xà to awjarẽ atajêa na mã, cute ito hajỹr ― hane. ");
INSERT INTO ram_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne jũa mã cute mehkrã ton, mã ihtỳj me Pahpãm jarkwa par pejti. ");
INSERT INTO ram_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mã hacpỹ mã Krĩpinkrên wỳr cute me amji jaxàr ne me cator. Mã hipêr Jeju te curi me cumã amji to ipipẽ, ne me cumã: ― Por pê Inxũ Cati jõ kàhhôc kam ito hũjarẽn to: “Quê ha, pê Pahpãm Crixtô cator na me amã to awjahkre ata, ihtỳj amji pupun xà kêanre to amji pupu ne ty. Ne amcro incrê kam hacpỹa mã ihtĩr” hane. ― Ne hanea ne ihkàhhôc ata ito hũjarẽn to hane he: ");
INSERT INTO ram_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Hamre, quê ha cute harkwa jarẽn xà itajê cunea, krĩxàre cunea kôt ajcrà. Ne Krĩpinkrên kam quê ha ipicràn kam tẽ, quê ha me harkwa itajê cunea jarẽn pa, ne me hahkre pej, ne mehkên ton jicu, ne amji mã me Pahpãm na ahwỳ, quê ha mehkên to tojnõ ne me to impej” hane. ");
INSERT INTO ram_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","― Ne me ca, ate me ijarẽn pej xà caxuw ca ate me ato jĩa to me ipupun, ampo atajê cunea na. ");
INSERT INTO ram_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne me ca, por Inxũ Cati te ate me ijarẽn xà caxuw me amã carôt tỳjti to hũjahkre ata, quê ha ihtỳj me amã cugõ. Ne pa wa ha itỳj hanea ne me amã cugõ, ne ahna me ato ihimpej. Na ca ha ita ri, Krĩpinkrên kam, me hikaj. Quê ha ita ri côjkwa pĩn, me amã me acarôt tỳjti ata wrỳ, ca ha me acwa ― hane. ");
INSERT INTO ram_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ne Jeju te krĩ pê me to cator, ne ma amji kôt Mehkênpupunxà jõ krĩ wỳr me to mõ, ne curia ri cute mencwỳrpê hũhkra curor, ne cute mehcajrẽn. ");
INSERT INTO ram_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ne cute mencwỳrpê hũhkra curor me ajkaam, ma côjkwa wỳr hàpir to mõ. ");
INSERT INTO ram_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mã ame Jeju pejti na harẽ, ne ma Krĩpinkrên wỳr cute me amji jaxàr. ");
INSERT INTO ram_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne amcro cunea kam, ma Pahpãm to me amji kam hapac xà jũrkwa wỳr me ipa, Pahpãm mã mempejti to mehcakôc prãmte. Hamre.");
INSERT INTO ram_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Mam, ampo cunea cumam, pê ramã me pajõ Pahhiti ipa. Ne me pamã cupê Pahpãm cakôc xà me harkwa. Ampo na? Taa mã ri me pamã Pahpãm te amji kam hapac xà me, incaca xà to ipipẽ to ipa. Ne pê Pahpãm cahêa na maam ajco apu ipa ne me ajpẽan. ");
INSERT INTO ram_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na pê me pajõ Pahhiti Hũm Cati jarkwa kôt ampo cunea ton partu, pê nee iràn xà na, ampo hũhkra kaj na, amjia kôt amji ton nare. ");
INSERT INTO ram_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na ri cupê me pahte amji kam me pajapac xà cunea xakat. Ne pom hãn ne pyt pjê cunea cujro, cu hàhcujro kôt me ampo cunea pupu, ita na mã me pajõ Pahhiti me pahcunea mã pahte me hahkre pej xà gõ, mãr cu ihcunea na me Pahpãm pê Hũm na me hahkre pej ne me hõmpu, ne cahê na me papa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pyràc pej na mã me pajõ Pahhiti pê me pahcujro xà, ata kôt cu me Hũm Cati jahkre pej ne me hõmpu. He jũ wỳr quê mehkên ton catêjê nõ, pê ihhêj rũm awcapàtkô kam mehkrĩ catêjê atajê kwỳ, me pahte me Pahpãm pupun nare prãmte, me papê cute me pahcujro xà ita pro ne cupĩ. ");
INSERT INTO ram_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ne pê me pajõ Pahhiti cator xwỳjrea na, mam Pahpãm me pamã harkwa na imprar catê pê Jowãw te cô kam me cumrãr catê ata kujate, cute me pamã me pahcujro xà pê me pajõ Pahhiti ita to hũjarẽn, ne to hahkre xà caxuw. ");
INSERT INTO ram_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","9","Ne pê Jowãw xwỳ pê me cumrãr catê ata nee ihcakôc xà to: — Ipê ihhêj rũm me acujro xà — hajỹr nare, ne cama harkwa to: — Quê ha cormã me pamã me pajõ Pahhiti cato, ata pê ri ihhêj rũm me pahte amji kam me pajapac xà cunea cujro xà, pjê cunea kam. He cupêa ri quêt me pahcujro xàa to me pahcujro xà — hane. Ne pê Jowãw me pamã me pajõ Pahhiti to hahkre, pahte me hahkre pej ne to amji mã me pahhimpej xà caxuw, pê me pahwỳr cato. ");
INSERT INTO ram_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ne me pajõ Pahhiti pê Hũm cakôc xà me harkwa ata pê mam ampo cunea to, ne taa mã pê pjê ita wỳr wrỳ ne apu ipa. Mã xãmte pjê kam mehcunea te nee cupê ampo cunea ton catê na me hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ne ma Juta catêjê jõ pjê wỳr cator, mã nee ajte cute ahna me amji caxàr nare. ");
INSERT INTO ram_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mã mencrêre pyxitre te ahna me amji caxàr, ne cumã me amji jõr, ne toa amji mã mehhimpej to me ipa, ne me cumã: — Apê Pahpãm kraa to ihkra — hajỹr. Cwỳrjapê ri Hũm te ihtỳj ihkôt me to amji kra. ");
INSERT INTO ram_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Cu me paxũmre nee ame pahkra ton to hajỹr nare, ne ajteare mã me. Quê ha me paxũmre nõ mã ihkra prãm, quê ha xa ihprõ nõ me hikwa, ne ajpẽn kam mehkra, quê ha cormã me cumã ihkra. Ne Pahpãm te nee hajỹr nare. Quê ha cama, por jũmjê me pajõ Pahhiti to amji mã mehhimpej atajê mã harkwa to: — Imã me ato amji kra to prãm. Na wa ha amã Icarõ Pejti kôt, ate amji kam gapac xà tuw pejti gõ, mãr ca apê ikra — hane. Pea quê ha jũmjê atajê amji to Pahpãm kra pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ne pê me pajõ Pahhiti pê Hũm Cati cakôc xà me harkwa ata, me pahwỳr wrỳ, ne me pajĩa na amji to, ne ajco apu ipa. Pê wa me hõmpu. Pê cupê Hũm mã ihkra pyxit peaj ata. Cwỳrjapê ri carôt tỳj me Hũm carôt tỳj pipẽan, ne impej me Hũm pej pipẽan. Na ri cute Hũm cuxà amji mã me pajapêti to cator, ne cute me pahpytàr catê na amji ton. Ne cupê Hũam, ne nee apu ihhêj xi jarẽn nare, ne quêt catyt kam, ampeaj kam mehcunea mã Hũm Cati jarkwa to hũjarẽn to ipa. ");
INSERT INTO ram_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne pê Jowãw pê me cumrãr catê ramã ita na me cumã to hũjarẽn to hane he: — Pom Jeju ita pê Pahhiti, pê wa ramã me amã to icakôc ne harẽn to: “Taa mã quê ha hapu na ikôt cator cakrô, ijirôa pê cati. Ampo na? He pê ramã ipỳm xwỳjrea na ajco apu ipa, na ca ha ijirôa pê amji mã me hũpa” — hane. ");
INSERT INTO ram_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ne Jeju mã ri ampeaj kam me pahcunea caprĩ, ne cumã me pahkĩn. Cwỳrjapê ri hõtpê me pamã ampo pej cunea ton to ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ne pê rỳ pêa mã Mojxe xwỳ ramã me cumã Pahpãm harkwa jirên xà atajê gõ, ne pyxit peaj to me cumã hahkre. Ne Jeju nare, quêt ihtỳj cumã me pahcaprĩ, mã me pahtehcajpa. Ne me pamã Pahpãm jarkwa pejti pê ampeaj kam ata to hahkre. ");
INSERT INTO ram_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ne rỳ jũ caxuw jũm te pjê kam Pahpãm pupun nare. Mã ihkra pejti pyxit peaj ata pê Hũam pyràc ne cume ipipẽan. Na pê cu hĩa na me hõmpu, ne taa mã ri Hũm cahê na amji kôt me pamã Hũm to hahkre, ne ihkôat cu ha me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mã Krĩpinkrên kam Juta catêjê jõ pahhi kwỳ te Jowãw te me cumrãr catê wỳr, Pahpãm mã mehcajrẽn catêjê me, Rewi catêjê pê Pahpãm jũrkwa jamãr catêjê me, mehkujahêc, cute me Jowãw cukij prãmte. Mã cute mehcukij to: — Me anõ mã ca? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mã Jowãw te hirãa pê me cumã amji jarẽn to: — Nee ipê, por pê Pahpãm mehkwỳ mã me hũtàr catê to awjahkre ata nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mã hipêr cute mehcukij ne me cumã: — Ne mẽr me anõ mã ca? Xà ajkĩ apê Erij xwỳ mã ca hacpỹa mã atĩr? — hajỹr. Mã Jowãw te me cumã harkwa to: — Quê, ipê jũm ata nare — hajỹr. Mã me cumã: — Xà apê, por pê Pahpãm me imã harkwa to ihcakôc catê to awjahkre, wa me hikaj ata mã ca? — hane. Mã Jowãw me cumã: — Quê! Pa nare! — hane. ");
INSERT INTO ram_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mã hipêr cute me Jowãw mã harkwa to: — He me anõ mã ca? Me imã amji jarẽ. Wa me gahkre pej ne ma hacpỹ mã cute awỳr me ikujahêc atajê wỳr me pra, ne me cumã garẽ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mã Jowãw te me cumã Ixaj xwỳ jõ kàhhôc kôt harẽn to: “Ipê, por põ kam me hamreare kam me cumã ijũjarẽn to hajỹr to ipa catê ata he: ‘Me pajõ Pahhiti mã me hõ pry to ihcuhtac ne, mãr quê ihtỳj ihkôt mõr pejti ne’ hajỹr. Jĩkjê na quê ha mehcunea cator xà ata caxuw cute me amji kam hapac xà to impejti to me ipa, ne catyt kam me ipa” hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ne por pê ame Jowãw cukij atajê pê Parixêw catêjê kwỳ. ");
INSERT INTO ram_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ne hipêr cute mehcukij to: — Pom nee apê, por pê Pahpãm me pamã jũm to awjahkre ata nare, ne nee apê Erij xwỳ ata nare, ne nee apê Pahpãm jarkwa to ihcakôc catê wa me hikaj ata nare, nõ na mã ca atỳj cô kam me cumrã? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mã Jowãw te me cumã harkwa to: — He wa cô cakrô kam me cumrã, ne por me acote na quêt jũm apu ipa ata, ca nee rỳ ate me hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ne taa mã quê ha ijakàn pê cator cakrô, wa nee ite hũpa cahi ne cupê hõ par kà tũm caxàr xà caxuw ipej nare. Ampo na? He taa mã ri ijirôa pê cati — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hõhõ, ita pê hane, ma Côhnameirêrxà jõ krĩ kam, Côpijapjêr jõ cô jĩkjê rũm. Por pê curi Jowãw ajco apu cô kam me cumrãr to ipa ata ri. ");
INSERT INTO ram_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mã amcro nõ na Jowãw te amji wỳr Jeju mõr na hõmpun, ne me cumã harẽn to: — Me Pahpãm jõ Caràcahàcre Kra ca me hõmpu he, ramã ajpên mõ he. Ne taa mã quê ha pjê kam me pahcunea kên jũhta ne to hamre! To hanea, pom cu pahte amji kam me pajapac xàa na, me pahkên jahpan xà na, Pahpãm mã me pajàmjõr xà caxuw me ampo pê me pahkritxwỳ cura, ne me cumã to amgõ he. Ita jĩkjê na, quê ha me pajaxà kam ty, ne me pahkên cunea to hamre. ");
INSERT INTO ram_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wa ite ramã catyt kam me amã to icakôc to: “Quê ha cormã ikôt hapua na jũm xũmre cato ata, quê ha ijirô pê cati. Ne ampo na mã ijirôa pê cati? Nee mã ampo na ijirôa pê cati nare. He pê quêt ramã ixwỳjrea na apu ipa, cormã ipỳm nare kam” hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Pê wa nee cupê jũm te hajỹr xà ata na hahkre pej nare cakrô, pê wa itỳj cô kam ihcumrã. Ne nee mã pê wa ampo na apu to hajỹr nare. Ite Juta catêjê mã cupê jũm te hajỹr xà ata na to ipipẽ to hajỹar prãmte, pê wa to hane. ");
INSERT INTO ram_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","— Ne pê wa nee cute hajỹr xà ata na hahkre pej nare, mã Pahpãm te cô kam mehcumrãr catê na imẽn ata te imã harẽn to: “Ca ha Icarõ te tutti na amji jahkre, ne côjkwa pĩn ahpar mã pjê wỳr tẽ, ne jũm xũmre cwỳrpê hàhhuc na hõmpu ata, quê ha cupê me cumã Icarõ Pejti jõr catê. Mãr quê Icarõ Pejti ata me cumã ite amji kam ijapac xà to hahkre” hajỹr. Wa irĩt, ne ite côjkwa pĩn Pahpãm Carõ Pejti te tutti na amji jahkre ne ajpên ihtẽm, ne Jeju cwỳrpê hàhhuc na hõmpun. ");
INSERT INTO ram_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne ite hõmpun xà ata kôt wa ite hirãa pê me amã Jeju pê Pahpãm kra na harẽn — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mã hipêr amcro nõ na Jowãw curia apu ihkôt me ipa catêjê pijakrut atajê me, ame ipa. ");
INSERT INTO ram_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mã hipêr cute me ahnaa Jeju mõr na hõmpun, ne me cumã harẽn to: — Nãmhã, Pahpãm jõ Caràcahàcre Kra apu mõ he! Cupêa ri me pahkritxwỳ, ne taa mã quê ha me pahkên jahpan xà na ty — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mã ihkôt me ipa catêjê pijakrut atajê te mempar, ne ma me Jeju pynãr ne ihkôt me mõ. ");
INSERT INTO ram_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mã hacpỹ mã Jeju rĩt, ne cute me hõmpun, ne mehcukij to: — Ampo japên to mã ca ikôt ame mõ? — hajỹr. Mã me cumã: — Ikrã tũmti, jõ ri mã ca akrĩ? — hane. ");
INSERT INTO ram_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mã Jeju me cumã: — Ajpên ikôt me mõ, ne imã me ikrĩ xà pupu — hane. Mã ma ihkôt me mõ, ne cute me cumã ihkrĩ xà pupun. Ne curia pyt xà wỳr, cahê na ame mõ, pê ramã me ahna pyt to mõ. ");
INSERT INTO ram_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pê me ajkrut ne Jowãw te Jeju jarẽn na me kampa, ne me Jeju pynã atajê nõ pyxit ata japrỳ pê Antre, ne cupê Ximãw Petrô tõ te amji to hapu na kjê. ");
INSERT INTO ram_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ne ma Antre ihtẽm pyrentu, ne mam ihtõ kà Ximãw wỳr cator ne cumã hũjarẽn to: — Wa ite, por pê Pahpãm me pamã me pajõ Pahhiti pê Mexij to awjahkre ata na icator — hane. Por pê Juta catêjê jarkwa na haprỳ Mexij, ne Crec catêjê jarkwa na me cumã haprỳ to Crixtô ata. Ne pê haprỳ pijakrut itajê kôt harẽn xà pê “Cute capi ne ahna hãm” hane. ");
INSERT INTO ram_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne ma Antre te ihtõ kà japrôr ne to mõ, Jeju wỳr. Mã Jeju te Ximãw pupun ne cumã: — Gaprỳ te Ximãw, ne apê Jona kra, ne hamre ita caxuw quê ha gaprỳ pê Xepa — hajỹr. Pê Crec jarkwa na Xepa ita pê Petrô, ne ihkôt harẽn xà te “Kẽn”. ");
INSERT INTO ram_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ne amcro nõ na Jeju te ma Hĩpôjajo jõ pjê wỳr mõr to amji kam hapac. Ne mõr xwỳjrea na cute hũmre nõ japrỳ te Pirip ita cajpar ne cumã: — Ajpên ikôt mõ! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ne Pirip ata pê Tep jõ krĩ kam mehkwỳ nõ, por pê curi Antre me Petrô ihkrĩ atajê kwỳ nõ. ");
INSERT INTO ram_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mã Pirip apu hõ kwỳ nõ pê Natanew japê, ne cute ihcajpar ne cumã: — Wa ite, por pê Mojxe xwỳ me pahte amji kam me pajapac xà jõ kàhhôc kam, jũm na ihhôc ata na icator. Ne cupê, por pê hanea ne Pahpãm jarkwa na mehhôc catêjê ahna mehhôc ata! Ne cupê Jeju, ne cupê Naxare jõ krĩ kam, Joje ihkrĩ ata kra — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mã Natanew te ahna ihcukij to: — Xà quê ajkĩ ihtỳj Naxare jõ krĩ pĩn ampo pejti cato? Jũ wỳr quê ampo pej cato! — hajỹr. Mã Pirip cumã: — Ajpên mõ ne hõmpu mã — hane. Mã ma ihkôt Jeju wỳr tẽ. ");
INSERT INTO ram_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mã Jeju te ajpên Natanew te hỹrmã mõr na hõmpun, ne mehkwỳ mã to hũjarẽn to: — Me hõmpu he! Ajpên hũmre pê quêt catyt kam ipa catê nõ ata mõ he. Ne nee quêt ihhêj xi nare, ne cupê Ixaher catêjê nõa, ne impejti! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mã Natanew te impar ne cumã: — Jũ mã mã ate ne ijahkre pej? — hajỹr. Mã Jeju cumã: — Wa Pirip te gaprôr xwỳjrea na ite apupun, ca ihmat ri pĩxô pàr krac ri jỹ — hane. ");
INSERT INTO ram_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mã Natanew Jeju mã: — Ikrã tũmti, apê Pahpãm kraa to ihkra! Ne wa itỳj apê Juta catêjê jõ Pahhiti na amji mã ato hane! — hane. ");
INSERT INTO ram_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mã Jeju cumã: — Xà wa ite ihmat ri pĩxô pàr krac ri ajỹr na apupun ne garẽn xà ita kôt mã ca cormã ate ito amji mã ahimpej? Ca ha cormã jũ caxuw quêt ampo ita jirôa pê ihnõ catia ata pupu — hane. ");
INSERT INTO ram_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne cute mehkwỳ mã harẽn to: — Wa ha ampeaj kam me amã awjarẽ, ca ha atỳj côjkwa te amji jihê mẽn na me hõmpu, ne ajpên iwỳr Pahpãm mã hàpên catêjê te me irôrôc, ne hacpỹ mã me hàpir na me hõmpu. Ampo na? He ipê côjkwa kam me Ahàkà cati ata wa, ne cama ite me hũmre na amji ton ne me awỳr iwrỳc — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Ne ahna amcro pijakrut jirô pê mã ri cute me hikwa tuw catêjê nõ jõ amji kĩn jarẽn par, Têtêc jõ krĩ wên kam, Hĩpôjajo jõ pjê kam. Mã cute amji kĩn ata caxuw me Jeju me, me ipê ihkôt me ipa catêjê jator. Wa ma ihwỳr me mõ ne me icator. Mã ramã curia Jeju menxi apu mõ. ");
INSERT INTO ram_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mã amji kĩn ita cahti ri ampo pĩxô cacô xỳre ata jamre. Mã Jeju menxi te pĩxô cacô jamre na hõmpun, ne ma ihcãmter wỳr tẽ ne cumã: — Ikra, hamre, me cupê pĩxô cacô jamre — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mã Jeju te impar ne cumã: — Ampo caxuw mã ca inxê apu imã ita jarẽ? Nee ate imã ita jarẽn xà hamreare, wa ramã ite hahkre pej. Ne cuna mã cormã nee ite ampo itajê nõ ton xà kam hàhhuc nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mã ma inxi amji kĩn jõ pahhi mã me hàpên catêjê wỳr tẽ, ne cute me cumã: — Ca ha atỳj ikra te ampo na me amã hũjahkre xà atajê to me cumã — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pê curia kẽn te pot catia to cati te xêj atajê ihcuhhê. Ne ihkwỳ ihtỳj cô to rit to ôjtẽnta ne cucwa, ne ihkwỳ ihtỳj cô to rit to xẽj ne cucwa. Pê Juta catêjê ihtỳj ajco cô ata to me amji cuhhõ, cute to me amji pyràc xà ata kôt. ");
INSERT INTO ram_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mã ahtũmre mã, Jeju amji kĩn jõ pahhi mã me hàpên catêjê atajê wỳr tẽ, ne cute me cumã harkwa to: — Cô to me pot itajê to me hipu partu — hajỹr. Mã ihtỳj harkwa kôt cute me to hipu partu. ");
INSERT INTO ram_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jirô pê mã ri cute me cumã harkwa to: — Caxi me cô ita crire ne me haxà, ne amji kĩn jõ pahhi wỳr me to tẽ, ne me cumã agõ, quê capi — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mã jũm ita te ihkwỳ jaxàr, ne hỹrmã to ihtẽm kwỳa kam, mã ramã cute pĩxô cacô na amji ton. Mã cute amji kĩn jõ pahhi mã hõr, mã cute capi, ne nee cute cô te ampo pĩxô cacô xỳre na amji jahkre ata na hahkre pej nare. Ne nee cute jũ rũm cator xà ata na hahkre pej nare. Ne cumã me hàpên catêjê mã ri quêt hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Na ri amji kĩn jõ pahhi te hikwa tuw catê ata na hàhwỳr ne cumã: — Pỳhàpà, ajte ihhêj ne mam ate me cumã kyre pê pĩxô cacô impej ata jõr, mã cute ame to ihkõm. Jirô pê mã ca ate cormã me cumã impeaj ita jõr. Ne ihhêj ne ate pahte me to amji pyràc xà ata to gàhpan, ne ate hicu xà caxuw impejti ata juwahi — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hõhõ, pê Jeju carôt kôt ampo pihho ton kam to tẽm to hane, ne ajco carôt to ipipẽ to ipa, Têtêc jõ krĩ kam, Hĩpôjajo jõ pjê kam. Ne pê carôt tỳjti impejti ata to me cumã ajpẽ. Pê wa me ipê ihkôt me ipa catêjê, itỳj amji mã me to ihimpej, ne mempar pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ita jirô pê mã wa me ipê ihkôt me ipa catêjê me, Jeju me, inxi me, mehkjêjê me, ma Capernam jõ krĩ wỳr me mõ, ne curia wa ite ijõtpê me amji to amcro kwỳ kujahêc. ");
INSERT INTO ram_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ne Juta catêjê jõ amji kĩn japrỳ te, me Hakren xà jõ amji kĩn jõ amcro ata, pê ramã cator xàa kam, ne ramã hũ na pire mã. Ne amji kĩn ata pê, por pê Ejit jõ pjê kên pĩn, menquêtjê cator xà atajê jõ amji kĩn. Na wa ma Jeju me Krĩpinkrên wỳr mõ. ");
INSERT INTO ram_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne Pahpãm to me amji kam hapac xà jũrkwa kam, Jeju te jũmjê te carà cahàcre hôhti me, pryti me, tutti to ihpore na ame hàhpan na me hõmpun. Ne hanea ne cute jũmjê atajê te mehkrĩ ne me hàhtôa mã ihpore to hàhpan na me hõmpun. ");
INSERT INTO ram_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne ame kam incryc, ne me caxuw cute pàrcuxê to mehcahhyr xà ton, ne põ mã mehcunea to cator, ampo atajê mea mã. Ne cute ihpore to me hàhpan catêjê pê ihpore pyxwỳr xà mẽn, ne pjê kam hõ pore jaxwỳr partu. ");
INSERT INTO ram_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne cute, por ihpore na me tutti to hàhpan to me ipa atajê mã harkwa to: — Ikre ita pê ampo itajê cunea to me gapôj partu! Ne nee ca Inxũ jũrkwa kam apu amji mã ampo itajê to ihpore na me gàhpan to me apa nare. Xà aracri Inxũ jũrkwa ita pê ampo to ihpore na kam me hàhpan xà? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cwỳrjapê wa me ipê ihkôt me ipa catêjê te Pahpãm jõ kàhhôc kam ita to hũjarẽn na me to amji japackre, pê ramã harẽn to: “Imã Pahpãm to amji kam me hapac xà jũrkwa ita kĩan to ihkĩn. Na wa nee kam ampo kên xãm na hõmpun prãm nare, ne wa ampo pej to pit mã kam me amji japackre” hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mã Juta catêjê jõ pahhi kwỳ te ita na harẽn par ne mehcukij to: — Jũm te mã, ate ame to hajỹr xà ita na, amã harkwa? Jũm te mã ahna amẽn? Xà ajkĩ Pahpãm te mã ahna amẽn? Mẽr hõhõ, acarôt cati pahtỳjti ita to me imã ajpẽ, wa ha ahna me apupu, ne cormã Pahpãm te ahna amẽn na me gahkre pej — hajỹr. Mã Jeju te me cumã amji jarẽn to: ");
INSERT INTO ram_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","— Ca ha me Pahpãm jũrkwa ita hu, wa ha hacpỹa mã amcro incrê peaj kam hãm, ca ha cormã ihkôt Pahpãm te ahna imẽn na me ijahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mã cute me Jeju mã ikre jarẽn to: — Pê me Pahpãm to pahte me amji kam me pajapac xà jũrkwa ita to me hàpêan to me caku to cwarẽnta ne ihkôt xêj, ne me hipêj, nõ na mã ca ajte amcro incrê peaj kam hacpỹa mã ate hãm na amji jarẽ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Por pê Pahpãm jũrkwa to Jeju ihcakôc ata pê nee kẽn te ikre ata nare, ne amji jĩa to pê me cumã ihcakôc. ");
INSERT INTO ram_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ne pê hacpỹa mã ihtĩr, pê wa cormã hũjarẽn xà ata to me amji japackre, ne itỳj me ihkàhhôc kam Pahpãm jarkwa kampa, ne Jeju cakôc xà na me kampa. ");
INSERT INTO ram_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pê Jeju me Hakren xà jõ amji kĩn na Krĩpinkrên kam apu ipa xà ata kam, pê me hàhtôa ne ihtỳj cupê Pahpãm kra na amji mã me to hane. Ampo na? Nee mã ampo na nare. Pê ajco Jeju ihtỳj Hũm carôt kôt, rỳ jũ caxuw, jũm te ampo cupahti pihho pupun nare atajê to na pê. ");
INSERT INTO ram_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Cakrô pê nee Jeju cormã amji mã me hàhtôti atajê to taa mã nare. Ampo na? Pê ajco mehcunea mã cute me amji kam hapac xà pupu, ne me hahkre pej to ipa na pê. ");
INSERT INTO ram_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne pê jũm te cumã me harẽn nare kam, pê ajco taa cute me amji kam hapac xà na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ne pê hũmre nõ japrỳ te Nicotem ata pê Juta catêjê jõ pahhi na mehkwỳ nõa, ne cupê Parixêw catêjê kwỳ nõ, ne cupê Mojxe xwỳ jõ kàhhôc to me cumã hahkre catêjê nõa. ");
INSERT INTO ram_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ne ma caxwa ri Jeju wỳr mõ, cute hõmpun, ne cumã ihcakôc prãmte. Ne hỹrmã cator ne cumã: — Ỹhỹ Jeju, wa ite, Pahpãm te me imã apê ampo to hahkre catê na akujahêc na gahkre pej. Ampo na? Ca atỳj Pahpãm carôat to ampo pihhoti jàhtôa ton to apa atajê, ihtỳj Pahpãm carôt tỳjti to ipipẽ to mõ. Jũ wỳr quê Pahpãm jũm kujahêc nare, quê jũm ampo itajê nõ to — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mã Jeju cumã: — Ỹhỹ, wa ha nee amã ihêj xi jarẽn nare. Quê ha jũmjê mã Pahpãm himpej xà mã mencjêj to prãm na, quê ha xa hacpỹa mã amehpỳpỳm — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mã Nicotem cumã: — Pỳhàpà, jũ wỳr quê ha ramã jũm kàhtu ata amji mã hamã, nehacpỹa mã inxi tu mã axà ne hipêr ihpỳm — hane. ");
INSERT INTO ram_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Mã Jeju te cumã ihkôt harẽn to: — Ỹhỹ, wa nee apu amã ihêj xi jarẽn nare. Quê ha jũmjê te Pahpãm himpej xà mã incjêj prãm na, quê ha xa hacpỹ mã amehpỳpỳm, jirô pê mã quê ha cormã me acjêj. Pê ca mam gĩ to, anã tu kam cô ata kôt apỳm, ne apê anã kra. Jĩkjê na, ca ha hipêr Pahpãm Carõ Pejti kôt, acaxwỳn carõ to amji mã intuw, ne apê Pahpãm kra. ");
INSERT INTO ram_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","— Nee ca ite amã hacpỹa mã, me acunea pỳpỳm na me garẽn ita to amji mã ame apikrar nare. ");
INSERT INTO ram_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ampo na? He Pahpãm Carõ Pejti kôt amehpỳpỳm xà ata pê ihhêj rũm kôc pyràac. Jũ wỳr ca ha jũ kam kôc te hàpêr xà na amji mã prãm xà ata wỳr hàpêr na hõmpu. Ca ha me hàmcoco pit kampa, ne nee hõmpun nare. Ne nee ca ha jũ pĩn cator xà me, jũ kam ihtẽm xà ata na hahkre pej nare. Jĩkjê na mã, Pahpãm Carõ Pejti jàpên xà pê hũràac. Ne nee quê ha jũm Pahpãm Carõ Pejti te jũm to amji mã ihkra xà ata na hahkre pej ne hõmpun nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mã Nicotem cumã: — Jũ mã quê ajte ita, ne hane? — hane. ");
INSERT INTO ram_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mã Jeju cumã: — Pỳhàpà, pom apê Juta catêjê mã ampo to hahkre catê ita! Nõ na mã apê ampo ita jahkre kêatre? ");
INSERT INTO ram_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wa ha nee amã ihêj xi jarẽn nare. He wa amcro cunea kam me akwỳ mã, ite ampo jahkre pej itajê to hahkre to ipa. Ne hanea ne ite ito jĩa to ampo pupun atajê pupun xàa kôt, wa me amã harẽn to ipa cakrô, ca ajte nee cormã ate me ipar nare. ");
INSERT INTO ram_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne wa ramã ite me amã pjê ita kam ampo te jũ mãn xà ata na harẽn, ca nee ajte ate ikam me gapac nare. Ita kam, ca ha pijamã ite me amã côjkwa kam ampo jarẽn xà atajê cunea na me ikampa? Me gũpar nare ita kam, ca ha nee me ikam gapac nare. ");
INSERT INTO ram_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ne rỳ jũ caxuw côjkwa wỳr jũm jàpir ne hacpỹ ne cute amji jaxàr nare. Ne pa nare, he ipê kỳj pê, côjkwa kam me Ahàkà, cwỳrjapê wa curũam ite me hũmre na amji ton ne iwrỳc. ");
INSERT INTO ram_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","— Ne pê Mojxe xwỳ mat ri, põ kam me hamreare ata ri, wakỳre te cagã to, ne pĩ na cuxô. Ampo na? Nee mã pê ampo na wakỳre te cagã ata xôr nare. Pê cagã ajco me cãmxa, pê me wakỳre te cagã ata pupu, ne hacpỹa mã mempej. Ita jĩkjê na wa ha hanea. Quê ha jũ caxuw me ito wakỳre te cagã ata pyràac, ne me icuran xà caxuw, pĩ na me ixô. ");
INSERT INTO ram_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Quê ha jũm ito cagã ata ne ipupu, ne ito amji mã ihhimpej, quê ha ihtỳj ihtyc xà jirô pê ampo kên catia ata pê amji pytà, ne Pahpãm cahê na amji to ipijapar rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","— He ampeaj kam Pahpãm mã pjê kam mehcunea ame ipa itajê kĩn, mã cute me cumã, ipê cumã ihkra pyxit peaj kĩnti ata to hũjahkre ne hõr, ne pjê wỳr ajpên ikujahêc. Mãr quê cute ito amji mã mehhimpej atajê me ty, ne nee mehtyc tu ne Pahpãm kaj na ame ipa nare, ne quêt hacpỹa mã mehtĩr, ne Pahpãm cahê na me ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pê nee Inxũ imã harkwa to: “Cute mehkên ton jahpan xà na, pjê wỳr wrỳ ne curê mã me amẽ” hajỹr nare. Ne quêt cama imã: “Ca ha wrỳ ne mehkên pê me hũtà” hane. ");
INSERT INTO ram_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","— Na quê ha jũmjê te, ipê Pahpãm kra na amji mã ito mehhimpej na, quê ha nee Inxũ cute cuna mã ihkên ton xà atajê to me cumã ihcakôc, ne curê mã me irẽn nare. Ne por nee amji mã me ito mehhimpej nare atajê ri, ramã curê mã cute me mẽn na, me ahna me amji ton. Ampo na? Nee cute amji mã me ito ihhimpej nare, na quê ha curê mã me cumẽ. ");
INSERT INTO ram_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","— Cu ha ampo kên tũmti ata wỳr me pajàhcujro xà nõ, pôc pejti ata to mõ, ne me to ihtũmti ata pupun pyrentu. Jĩkjê na ri ipê pjê kam mehcunea jàhcujro xà. Ampo na? He wa itỳj me cumã cute mehkên ton xà atajê jarẽ, mã me hõmpu, ne cute me hahkre pej xà ita caxuw wa me hỹrmã iwrỳc, ne amehcujro to mõ. Mã ma mehkwỳ apu ite mehcujro ita na mehcaca, ne me cumã amji kam awcapàtkôti ita na pit mã me to prãm. Ampo na? Awcapàtkô ita kam ri hãn ne ihtỳj ame ampo kên ton to me ipa, cwỳrjapê ri ma ame icaca. Ne quê ha, cute me icaca catêjê cute me ampo kên ton atajê jahpan xà na, Pahpãm ame to kêanre ne. ");
INSERT INTO ram_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","— Ỹhỹ, por awcapàtkô kam ame ampo kên ton to me ipa atajê mã amji cujro prãm nare. Ampo na? Cute ampo kên ton atajê na me hahkre pej cupate ri ma ame amji cujro caca. Cwỳrjapê ri mehkên catêjê ipê ampỳa mã ame ipa. ");
INSERT INTO ram_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ne por catyt kam Pahpãm jarkwa kôt me ipa atajê ri, ijàhcujro impejti ata kam ihtỳj ame ipa xà. Mãr quê mehcunea catyt kam, Pahpãm jarkwa kôt me ipa na me hõmpu, quê nee ame ampo kên ton nare, na ri ihtỳj ame ipa. Na ri hanea ne ihtỳj mempejti catêjê atajê ikôt me ipa — hane. ");
INSERT INTO ram_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ita jirô pê mã, wa ma Jeju me, me ipê ihkôt me ipa catêjê me, Krĩpinkrên pê me icator, ne ma põ pê Juta jõ pjê kam ame ipa. Ne curia me cahê na ite jũ mã amji to me amcro ton, wa itỳj harkwa kôt cô kam amehcumrãr to me ipa. ");
INSERT INTO ram_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pê hanea ne ihtỳj Jowãw, cô japrỳ te Enõ pê Xarim jõ krĩ na pire mã xa ata kam, cô kam amehcumrãr to mõ. Ampo na? Ampeaj kam quêt curi cumã cô cati. ");
INSERT INTO ram_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ne pê caxuw cormã nee me Jowãw jaxàr nare. ");
INSERT INTO ram_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mã amcro nõ na Jowãw kôt me ipa catêjê kwỳ atajê me, Juta catêjê jõ pahhi kwỳ te ajpẽn mãn kam mehtẽm, Pahpãm mã cute me amji cũmpej xà na cô kam me amji cumrãr xà ata ri. Ne nee jũmjê te me ajpẽn par pej nare. ");
INSERT INTO ram_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Cwỳrjapê ri ma Jowãw te mehcumrãr catê pê me hõ pahhi ata wỳr, me amji to mõ, ne cute me cumã amji jarẽn to: — Me ijõ pahhi, wa ite me amji cũmpej xà ita kam, nee ite me ampo par pej nare, ne me ikrã pictor tu. Ne por pê ca jũm xũmre to me imã awjarẽ ata, ihtỳj mehcũmpej prãmte, acuxà Côpijapjêr jõ cô kam ame cumrãr to mõ, mã quêt mehcunea ihtỳj hỹrmã me pra! Ne jũ mã mã cu ha ajte me? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mã Jowãw te me cumã harkwa to: — Nee ca ita to ame amji kam gapac nare. Côjkwa kam Pahpãm te ahpỹanre na me hũmre mã me hàpên xà jõr par. ");
INSERT INTO ram_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","He ijàpên xà ita pê Jeju pê hũmre ata mã ite pry to impej xà, mãr quê pry ata kôt me hàhtôa ne ihwỳr me apkjê. Ne nee ipê, por pê Pahpãm me pamã to awjahkre ata nare, ne ite amji jarẽn xà na ramã ate me ipar. Ne hõ pry to ite cumã impej xà caxuw pê wa mam icato. ");
INSERT INTO ram_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ne quê ha jõ ri me hàhtôa mã jũm pyxit peaj ne me hirôa pê impej, quê ha hỹarmã me pra. Ita jĩkjê na, quê ha jũm hikwa tuw, quê ha hĩxi impjên ata wỳr pit mã tẽ, ne nee impjên jõ ikwỳ nõ atajê wỳr ihtẽm nare cakrô, quê ha ihtỳj hũ na hõ ikwỳ nõ atajê ame hakry. Ita jĩkjê na wa itỳj Jeju jũ na ijakry. ");
INSERT INTO ram_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Na quê ha ihtỳj quêt Jeju ipicamẽn to mõ, ne cati to mõ, ne pa nare, wa ha ihkĩnte cama hacpỹa mã icri to mõ. ");
INSERT INTO ram_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","— Ne Jeju quêt côjkwa pĩn cator ata ri ijirôa pê cati. Ne pa nare, pê wa ihkĩnte pjê ita kam icato, ne imã pjê kam ampo itajê to pit mã icakôc jahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ne taa mã nare, quêt cute côjkwa kam ampo par ne hõmpun atajêa to hãn ne ihcakôc to ipa cakrô, mã ajmãr nee jũm te ahna amji caxàr nare. ");
INSERT INTO ram_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Ne mencrêre te cute ampo jarẽn xà atajê na me kam hapac, ne ihtỳj ampeaj kam cute me Pahpãm catyt kam ihcakôc ata kam me hapac. Ne Pahpãam te ri ihkujahêc na, cute me hahkre pej. He ampeaj kam ri Pahpãm cakôc xàa to Jeju ihcakôc to ipa. Ampo na? Nee mã ampo na nare. Pahpãm Carõ Pejti catia te cumã amji jõr na ri, ne nee kam Pahpãm Carõ Pejti ata crire nare. ");
INSERT INTO ram_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","— Ne Hũm mã ihkra ita kĩan to ihkĩn, mã cute cumã hõ tekjêa na ampo atajê cunea jõr, ne taa mã ri ita caxuw to hõ tekjê, ne ihcunea jamã. ");
INSERT INTO ram_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na quê ha jũmjê te amji mã Pahpãm kra te me hũtàr catê na me to amji mã hajỹr na, quê ha quêt Pahpãm cahê na mehtĩr rohnỳtti mã na ame ipa. Ne por nee me kam hapac nare, ne nee amji mã me harkwa cupa nare atajê, quê ha nee côjkwa wỳr me hàpir, ne me Pahpãm pupun nare. Quê ha cama me kam Pahpãm cryc ata me hỹrmã apkjê, ne ame to kêanre ne — hajỹr. Hõhõ, Jowãw te ihkôt me ipa catêjê mã hũjarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jeju te Jowãw jirôa pê mecumrãr, ne hirôa pê cumã ihkôt me ipa catêjê jàhtô. Mã Parixêw catêjê te ahna harẽn par. ");
INSERT INTO ram_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ne nee pê Jejua ajco me cumrãr nare, me ipê ihkôt me ipa catêjê pê wa ajco me cumrã. ");
INSERT INTO ram_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mã Jeju te ita na Parixêw catêjê jahkre pej, ne me harẽn par, ne ma Juta jõ pjê pê cator, ne ma Hĩpôjajo jõ pjê wỳr ihkôt me ipa catêjê me, me mõ. ");
INSERT INTO ram_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne Krĩrĩtpej jõ pjê cajpuaw pry nõ ata kôt pê me imõr xà. ");
INSERT INTO ram_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ne ma Krĩrĩtpej jõ pjê kam krĩ japrỳ te Xica ita mã me icator, por pê Jaco xwỳ ihkra pê Joje xwỳ mã pjê jahkre ata cahi na. ");
INSERT INTO ram_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Mã curia cormã Jaco jõ côhkre ata ihcuhhê. Mã pyt ramã me pahkrã jimoac kam jỹ, wa curi Jeju me, me icator, mã ramã mõr mã ihpeacre, mã côhkre ata cahê na hỹr. Wa ma me ikwỳ me krĩ ata kam ite me ampo krẽr xà japrôr to me pra, mã ahte hàhhuc. Mã pyjê nõ pê Krĩrĩtpej jõ pjê catêjê nõ ata, cute cô jaxàr prãmte hỹrmã tẽ, mã Jeju cumã: — Ate amji kam gapac xàa na, imã cô ita kwỳ incrire ne, wa to ikõ — hane. Mã jũm cahãj ata Jeju mã: ");
INSERT INTO ram_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","— Apê Juta catêjê nõ, ne ipê Krĩrĩtpej jõ pjê catêjê nõ, ne mẽr ampo na mã ca apu cô ita na iwỳ? — hane. Ne ampo na pê cumã ihcakôc xà ita to? Nee mã ampo na nare, pê ajco Krĩrĩtpej jõ pjê catêjê me, Juta catêjê me ajpẽn kaj na me amji kampa, na pê cumã hane. ");
INSERT INTO ram_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mã Jeju cumã: — Ca ate côjkwa kam Pahpãm te amã ampo jõr xà ata na hahkre pej na mã, ca ha ahna iwỳ. Ca ate ite cô na awỳr xà ata na ijahkre pej na mã, ca ha mehtĩr xà rohnỳtti mã xà jõ cô na iwỳ, por ca ha cô to ikõ ne atĩr rohnỳtti mã na apa xà ata na iwỳ — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mã pyjê nõ ata cumã: — Amã cô jacjên xà hamreare, ne côhkre ita rya to iry. Ne mẽr jũ mã ca ha, ne mehtĩr rohnỳtti mã xà ita jõ cô ita kwỳ py, ne imã ihkwỳ? ");
INSERT INTO ram_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Xà ajkĩ gõ cô ita me panquêt xwỳ pê Jaco jõ cô jirôa pê impej? He pê me panquêtti Jaco me imã côhkre ita jahkwỳ, ne mehkra me, cute me ampo to ipijapar xà mã hahkre, mã ihtỳj me to ikõ. Ne xà ajkĩ Jaco xwỳ jirôa pê acati, mã ca ha ajte imã cô impejti nõ ita gõ? — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mã Jeju cumã harkwa to: — Quê ha jũm, pom cô ita kwỳ to ikõ, ne hacpỹ ma mã cumã kôr. ");
INSERT INTO ram_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ne por wa ha jũm mã cô kwỳ, quê ha to ikõ ata, quê ha quêt nee hipêr cumã kôr nare. Ampo na? Quê ha jũm kam cô ata ipijapjêr rohnỳtti mã xà ata pê ihtĩar na ipa xà ata, na quê ha nee jũ caxuw ihtyc nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mã cahãj ita cumã: — Mẽr imã cô ita kwỳ, mãr wa imã kôr nare ne, nãmri wa nee hipêr hacpỹ ne cô ita jaxàr to imõr prãm nare — hane. Mã Jeju cumã: ");
INSERT INTO ram_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","— Mõ ne apjên japrô, ne hacpỹ ne to amji jaxà mã — hane. Mã cahãj ata Jeju mã: ");
INSERT INTO ram_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","— Ipê ipjê nare — hane. Mã ramã Jeju te hahkre peaj xà na cumã harkwa to: — Ampeaj kam ca apjê nare na ate imã amji jarẽn. ");
INSERT INTO ram_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ne pom ramã ate apjê to xĩc, ne cumã hikran ita. Ne pom cute ihkwỳ to xêj ca apu cume apa ita te hajỹar, ne nee cupê apjên nare. Wa nee ato ahêj xi nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mã cahãj ita Jeju mã: — Ampeaj kam ca ate ijarẽan to ijarẽn. Ne ita caxuw wa ite apê Pahpãm jarkwa to acakôc catê na gahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ne caxi imã awjarẽ. Jõ ri mõrmõ cu ha ajte ame Pahpãm to ame amji kam pajapac to me papa? Wa me ipê Krĩrĩtpej jõ pjê catêjê Pahpãm to amji kam me ijapac, ne catihti to me cumã icakôc prãmte, ma hàhkà jakôtti ita wỳr ijõtpê me pra. Ca ajte me apê Juta catêjê Krĩpinkrên kam ajte, me pahte Pahpãm to amji kam pajapac xà na me harẽ. Ne amãa, jũ ri mõrmõ Pahpãm to pahte amji kam me pajapac xà? — hane. Mã Jeju cahãj ita mã: ");
INSERT INTO ram_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","— Ikam gapac to impeaj ne he. Ca me apê Krĩrĩtpej jõ pjê catêjê ate Pahpãm to amji kam me gapac xà atajê na, me amji jahkre pej nare kam me to amji kam gapac to me apa. Ne me pa nare, wa itỳj quêt ite me Pahpãm to amji kam me ijapac xà ita na, me imã amji jahkre pej. Ampo na? Nee mã ampo na nare. He pê me apytàr catê ita, me ipê Juta catêjê pĩn me awỳr cato. Na cu ha nee jũ caxuw hipêr hàhkà jakôtti ata me, Krĩpinkrên kam, ame Pahpãm kĩnti na jũm te cumã me amji jarẽn xà hamreare. ");
INSERT INTO ram_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ne hamre, ramã pahte Pahpãm to amji kam me pajapac xà cunea pintuw. Na quê ha ita caxuw jũm ampeaj kam Pahpãm to amji kam hapac na, quê ha Pahpãam amji caxuw cumã cute to amji kam hapac xà to hahkre, mãr quê ha harkwa kôt to amji kampa. Hõhõ, cute me hajỹr catêjê ri Pahpãm amji mã me hapê, cute me to amji kam hapac xà caxuw. ");
INSERT INTO ram_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Inxũ pê Pahpãm ata nee hĩa na ipa nare, ne quêt cupê Carõ Pejti ata, ne pjê cunea kam ipa. Na quê ha hanea ne cute me to amji kam hapac catêjê me carõ caxwỳn cunea to me to amji kampa, pjê cunea kam — hane. Mã cahãj ata te cumã harkwa to: ");
INSERT INTO ram_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","— He imã, por jũm pê me pahpytàr catê japrỳ te Crixtô ata to Pahpãm te hũjahkre ata cator xà na imã hahkre pej. Ne quê ha cato, ne me pamã ampo cunea to hahkre partu ne — hajỹr. Mã Jeju te cumã amji jarẽn to: ");
INSERT INTO ram_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","— He ipê jũm ata, ne ipê Crixtô, ne pa wa amã icakôc — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wa caxuaw ramã curi me ipê ihkôt me ipa catêjê cator, ne ite amji mã ame ipikrar kryjre nare. Ampo na? Ite me Jeju te Krĩrĩtpej jõ pyjê nõ mã apu ihcakôc na me hõmpun, na wa ite amji mã me ipikrar. Ne nee ajte me inõ te ampo ata na cahãj ata cukij to: — Ampo na mã ca prãm? — hajỹr nare. Ne nee me inõ te Jeju cukij to: — Ampo na mã ca apu jũm cahãj ita mã acakôc? — hajỹr nare, ite me hahkre pej xà na. ");
INSERT INTO ram_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mã ma cahãj ata te hõ pot rer, ne krĩ kam mehkrĩ atajê wỳr tẽ, ne cator ne cute me cumã hũjarẽn to: ");
INSERT INTO ram_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","— Ajpên me mõ ne me hũmre nõ ita pupu, cute ite ampo ton xà atajê cunea na ijarẽn partu. Ne mõrmõ ajkĩ cupê, por pê Pahpãm Crixtô to awjahkre ata? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mã ma me hàhtôa ne krĩ pĩn, por curi Jeju apu mõ ata ri, ihwỳr me mõ. Ne cormã ajpên me iwỳr me mõr kwỳa kam, wa ite me Jeju mã: ");
INSERT INTO ram_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","— Me ijõ Pahhi, ampo krẽ! — hajỹr. Mã Jeju te me imã harkwa to: ");
INSERT INTO ram_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","— Imã ijõ, wa cuku, ca nee ite ihkur xà na me ijahkre pej nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wa ite mempar, na wa ahna ite me ajpẽn cukij to: — Xà ramã ajkĩ jũm te cumã hõ nõ rer? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mã Jeju te me ipar ne me imã: — Por Inxũ te ikujahêc ata te amji mã ampo kĩnti ata to wa cumãn to mõ, ne ata pê ri ihhêj rũm ijõ, wa to amji mã ijarte, mã itỳj. Ne wa ha itỳj cute imã ijàpên xà jõr ata to cumã ihkrã cura, cupêa ri ihhêj rũm ijõ. ");
INSERT INTO ram_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","— Ca ramã ate me harẽn to hajỹr to me amji pyràc tu he: “Cormã pahte me pajõ kẽhkẽn xà wỳr putwrỳ te cwat ne nõ” hane. Ne mẽr me hàhtôti itajê pupu he. He me cupê ijõ pur pyràac. Ne ihhêj rũm me cupê ramã ampo hy inteptu, ne ramã ihkẽhkẽn xàa kam hàhhuc atajê to ri pahte amji mã me cuprõn xà. ");
INSERT INTO ram_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Quê ha jũm te, jũm mã pur to hàpên na, quê ha ihtỳj amji mã ampo cwa. Ita jĩkjê na, quê ha jũm te imã me to cuprõn to ipa na, quê ha ihtỳj, cumã cute me to cuprõn to ipa jahpan xà na, hàmcwỳr xà. Na quê hame hàhtôa ne mehtĩr ita na ame ipa, Pahpãm cahê na. Ne quê ha imã me hàpên catêjê hakrya to me hakry to hanea, pom quê cute me ampo hy kre catêjê me, cute mehkẽhkẽn catêjê he, ne ajwar me hakry. ");
INSERT INTO ram_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ampo na? He hũjarẽn xà ita nee ihhêj xi jarẽn nare, ne ampeaj kam ri awjarẽ: “Quê ha mam jũmjê te hàhkre na, quê ha ihtỳj ihkôt cormã ihkẽhkẽn catêjê ihkẽhkẽ” hane. ");
INSERT INTO ram_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wa ite ramã me ate iwỳr me to apipkjêr na me amẽn. Ne pê mam rỳ pêa mã, Pahpãm jarkwa to mehcakôc catêjê pê me hàhkre catêjê atajê pyràac, ne ramã me cumã Pahpãm jarkwa jarẽ. Na ca ha mehkôt cama iwỳr me to apipkjêr to me apa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mã Krĩrĩtpej jõ pjê catêjê kam me hàhtôa ne, ampeaj kam cute Jeju to amji mã me hajỹr tỳj pyrentu. Ampo na? Por cahãj te harẽn to: “Cute imã ite ampo cunea ton atajê to ihcakôc partu” hajỹr, na ri mehcunea te amji mã me to hajỹr pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mã Krĩrĩtpej jõ pjê catêjê kwỳ cator, ne cute me Jeju wỳr, quê me cahê na amji to jũ mã amcro to. Wa curia me cahê na me ijàhhuc, ne ite me amji to amcro to me ipijakrut. ");
INSERT INTO ram_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mã hũjarẽn xà atajê kôt, me hàhtôa ne cute Jeju mã me amji jõr, ne mempar pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne cute me cahãj ata mã harkwa to: — Wa itỳj ita caxuw me kampa. Ampo na? Wa ramã ite me hĩa kam ijapac, ne nee mã ate me imã harẽn xà ita kôt pit mã, ite mempar nare. He ampeaj kam ri me imãa Jeju pê me pahkên catia pê me pahto hapôj catê, pjê cunea kam — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ne wa ite amji to me amcro to ipijakrut jirô pê mã, wa ma ite Jeju me, Hĩpôjajo jõ pjê wỳr me iprar kam me itẽm. ");
INSERT INTO ram_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ne pê Jejua ajco me imã amji jarẽn to: — Ipê Pahpãm jarkwa to mehcakôc catêjê nõ. Ne ipê me ikwỳ pyràac, mã ijõ krĩ kaj na ihtỳj me ikampa. Ne ijõ pjêa kam, nee amji mã me icupa, ne nee ikam me hapac prãm nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wa curi me icator, ne curia me cahê na me ijàhhuc. Mã curi mehkrĩ catêjê te meito kênre nare. Ampo na? Pê ramã Krĩpinkrên kam Hĩpôjajo catêjê mam me Hakren xà jõ amji kĩn ata na me Jeju te ampo pejti atajê ton na me hõmpu na pê. ");
INSERT INTO ram_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jirô pê mã wa ma Têtêc jõ krĩ wỳr Jeju me, me pra, por pê curi cô to ampo cacô xỳre na ata ri. Mã curi pahhi mã hàpên catê nõ catia, Capernam jõ krĩ kam ihkrĩ ata pê ihkra xà, hũrkwa kam. ");
INSERT INTO ram_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ne cute Jeju te Juta jõ pjê pĩn mõr na harẽn par, ne ma Jeju wỳr Têtêc jõ krĩ wỳr tẽ, cute ahna hàhwỳr mã ihkôt Capernam jõ krĩ wỳr mõr. Ne cute cumã ramã ihkra ihtyc xàa kam ata caprãr prãmte. ");
INSERT INTO ram_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mã Jeju te pahhi mã hàpên catê ata mã: — Xà wa icarôt to ampo pihho catia to, ca ahna me ipupu ne cormã ihkôt me ikampa? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mã Jeju mã: — Ijõ Pahhiti, ikra tyc xwỳjrea na, ajpên gũjarêan kam atẽm pyrentu! — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mã Jeju cumã: — Gapacta ne ikre wỳr amji jaxà! Hamre, ramã akra caprãr, ne quê ha ihtỳj amã impej, nee quê ha ihtyc nare — hane. Mã cute Jeju par pyrentu, ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mã ikre wỳr pry cahtiri cumã me hàpên catêjê kwỳ te mehcajpar, ne me cumã ihkra jarẽn to: — Hamre, hacpỹa mã akra impej — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mã cute pyt jỹr xà jũ kam ri ihkra te amji cajpẽr na, mehcukij. Mã me cumã harẽn to: — Ihnõ kam ri, ramã pyt te ihcahpa crire kam ri, akra mã kry jamre — hane. ");
INSERT INTO ram_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mã pyt jỹr xà ata kam hũm te, Jeju te cumã harkwa to: — Quê ha ihtỳj akra amã impej — hajỹr na to amji japackre pyrentu. Cwỳrjapê ri curi ikre kam cahê na mehkrĩ atajê cunea te ihtỳj Jeju to amji mã me hajỹr pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pê Jeju ramã carôt to ampo pihho catia ton to ajkrut, Hĩpôjajo jõ pjê pĩn mõr xà ata kam. ");
INSERT INTO ram_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ne ita jirô pê mã ri Juta catêjê te amji mã me amji kĩn nõ ata ton, wa ma me hỹrmã Jeju me, me ikwỳ me, Krĩpinkrên wỳr me mõ. ");
INSERT INTO ram_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ne krĩ ata pê kẽn to mehcunea intête kwỳc, ne mencjêj xà na hõtpê me harkwa jàhtôa ne me to. Atajê nõ na pê carà cahàcre hôhti jamãr catêjê ajco hapôj ne me to acjêj. Cwỳrjapê ri cute me cumã haprỳ to Caràcahàcre Hôhti Jõ Harkwa. Ne cahi na kẽn te kwỳc kam cô ata ri me ijarkwa na haprỳ te Krĩjàhcaprĩ. Mã ipu na hàhpykrã xà na kẽn po te ikre po atajê te xĩc ne ihcuhhê. ");
INSERT INTO ram_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Mã me hà cunea cô ata pu na me nõ, ne me Pahpãm mã imprar catê te côjkwa pĩn iwrỳc, ne cô ata to ipicwrỳc na me hikaj. Pê ajco hãn ne hõtpê jũa mã ahna amcro pê ajco irôrôc, ne cô ata to acwrỳc. Ne pê ampo na me hikaj nare. Quê ha cô ata acwrỳc, quê ha me hà atajê nõ mam cumã mrõ, ne impej pyrentu. Na pê ipu na mento tũm me, cute me xwỳ me, me cukrã xà pec me, me nõ. ");
INSERT INTO ram_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mã curia me cahê na jũm xũmre xà na, ramã ahna caku te trĩnta ne ihkôt ôjtô ata nõ. ");
INSERT INTO ram_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mã Jeju curi cator ne cute ramã hà ita na ahna caku jàhtôa na hõmpun, ne hahkre pej. Ne cute ihcukij to: — Xà amã amji caprãr na amji to prãm? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mã cute Jeju par ne cumã: — Hewhỹ, jũm te cô ita kam ito mrõr xà caxuw hamreare. Cwỳrjapê ri hãn ne acwrỳc, wa tee hỹrmã icuhkwỳr, mã ma mam me ikwỳ kwỳ me ire ne kam me mrõ. Ne quêt mempej ne ma me pra, wa ita ri mehkĩnte ijikwa xà ita kam ijikwa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mã Jeju cumã: — Hã to xa, ne anõr xà ata py ne to amõr pyrentu — hane. ");
INSERT INTO ram_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Me ajkaam mã hũmre ata pej ne hãm, ne cute nõr xà ata pyr ne ma to ihtẽm pyrentu. Ne mehkôt xà jõ amcro pê xap na, pê ita hane. ");
INSERT INTO ram_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mã Juta catêjê jõ pahhi catêjê kwỳ te jũm ata te nõr xà pyr ne to ihtẽm na me hõmpun, ne me cumã harkwa to: — Pỳhàpà, he ita kam me pahkôt xà jõ amcro pê xap, nõ na mã ca ajte ate anõr xà ita pyr ne to tẽ? He ate amji kam gapac xà ita nee me pahte amji kam me pajapac xà cajpuaw nare, ne ihkaj na! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mã cute mempar ne me cumã: — Por hũmre te icaprãr ata te imã harkwa to: “Anõr xà py ne to amõr pyrentu” hajỹr. Wa harkwa kôt tẽ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mã cute mempar ne mehcukij to: — Jũm te mã anõr xà ita pyr ne to atẽm na amẽn, mã ca apu to tẽ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mã me cumã: — Pỳhàpà, nee cute icaprãr catê ata te imã amji japrỳ jarẽn nare, ne ite hõmpun pej nare kam, ma me hàhtô mã hàr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mã ramã ahna ahtũm ryre mã Jeju te Pahpãm to me amji kam hapac xà jũrkwa kam ihcajpar ne cumã: — Ramã acaprãr ne apej ita na amji pupun peaj ne he. Ne hipêr mõ ne amji caxuw ampo kên nõ ton nare. Nãmri ca ha ate ihnõ ton na, quê ha mam ata jirôa pê acaxuw ihkêanre ne — hajỹr, ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mã hũmre ata xwỳjê cator ne ma tẽ, ne cute me cupê Juta catêjê jõ pahhi kwỳ mã amji jarẽn to: — Xãmte nee jũm te icaprãr nare, Jeju te ri icaprãr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ne cute me Jeju te mehkôt xà jõ amcro na, cute hàhcaprãr na me harẽn par ne me ajpẽn mã: — Cute me pahkôt xà jõ amcro kam hàhcaprãr, ne apu to kên, cwỳrjapê cu ha hanea ne ame to kêanre ne — hajỹr. Ne ma Jeju wỳr me pra, ne cute me cumãn kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mã Jeju me cumã: — Me ikampa, rỳ jũ caxuw côjkwa kam Inxũ Cati te ihkôt xà caxuw hàpên xà impejti atajê to hàpên jicu nare. Na wa ha hanea ne cuxà hàpên xà ita to ijàpên to ipa kam to icrà tu — hane. ");
INSERT INTO ram_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pê me cupê pahhi catêjê kwỳ harkwa ita na me kampa ne ame kam incryac to ame kam incryc, na pê me cumã ihcuran prãam to ihcuran prãm. Ampo na? Nee mã ampo na nare, pê mehkôt xà jõ amcro kam hà ata caprã, ne cormã hipy cupê Pahpãm kraa to ihkra na me cumã amji jarẽ, ne Hũm me ipipẽan na amji jarẽ. Na pê ihtỳj cupê Pahpãm kra na cute amji jarẽn to apu ihhêj na amehcãmjĩ, cwỳrjapê pê kam amencryac to amencryc. ");
INSERT INTO ram_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mã Jeju cormã me cumã: — Ikam me gapac to impeaj ne he. Ipê Pahpãm kra, na wa ha nee amjia kôt ampo itajê nõ ton nare. Ne por Inxũ ampo to, wa ahna hõmpu atajêa to wa ijàpên to ipa. Ne por Inxũ ampo cunea to atajê, wa itỳj hanea ne to. ");
INSERT INTO ram_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ampo na? Inxũ mã ikĩnti, na ri ihtỳj imã cute ampo cunea ton xà itajê to ipipẽ to ipa, wa hõmpu. Ne quê ha cormã imã cute ampo ton xà itajê jirôa pê cute ton xà atajê to ajpẽ, wa ha to, ca ha ahna me ipupu. Ne atỳj hõmpun xà ata to me amji mã ajkra. ");
INSERT INTO ram_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ne pom Inxũ hacpỹa mã mehtyc to ihtĩr, ita na wa ha ipê hũràac ne ite amji mã jũm tyc to ihtĩr prãm ata to, itỳj hacpỹ mã ihtĩr. ");
INSERT INTO ram_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ne nee Inxũ Cati pê mehkên me, mempej to ipicokjêr catê nare. Ampo na? He ite ita to ijàpên xàa caxuw ri cute imã hõr. Ne pa wa ha cute mempejti ton atajê jahpan xà na, me cumã ijàmjõr xà impejti atajê to amgõ. Ne cute mehkên ton atajê jahpan xà na, wa ha me cumã ijàmjõr xà kêanre atajê to amgõ, ne cama mehkên mã ame curẽ. ");
INSERT INTO ram_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Quê ha icati na me ipupu, ne amji mã me icupa to hanea, pom quê amji mã me Inxũ cupa he. Ne por jũm amji mã ipê Pahpãm kra na icupa nare ata ri, hanea ne nee amji mã, por Inxũ te ikujahêc ata cupa nare. ");
INSERT INTO ram_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","— He ampeaj kam wa ha me amã awjarẽ. Por quê ha jũm icakôc xà itajê cunea to amji mã ihhimpej ne kampa, ne Inxũ te ajpên ikujahêc na amji mã ito ihhimpej ata, quê ha ihtỳj ihtĩr rohnỳtti mã. Ampo na? He wa nee ite jũm ata kên mã mẽn nare, ne cama quêt to ihtyc xà jahpan, na quê ha ihtĩr rohnỳtti mã na ipa, Inxũ cahê na. ");
INSERT INTO ram_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","He ampeaj kam wa ha me amã awjarẽ. Quê ha ita caxuw, por cormã mehtĩar na ame ipa, mã ramã Inxũ mã mehtyc itajê, jũ caxuw ipê ihkra na me ijõkre kampa, ne hacpỹ mã ihcunea na amehtĩr pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ne pom Inxũ pê mehcunea mã, cute me amji kam hapac xà jõr catê xakat ata te ri imã hõr. Na wa itỳj hacpỹ mã mehtyc to ihtĩr. ");
INSERT INTO ram_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne ampeaj kam ri ipê Pahpãm kra, ne hanea ne ipê me Ahàkà, cwỳrjapê ri hajỹar ne Inxũ Cati te ito mempej me, mehkên catêjê cukij ne me to ipicokjêr catê. ");
INSERT INTO ram_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","— Ne nee ca ite icakôc xà to icakôc itajê impar xà to ame amji mã me apikrar nare. Ampo na? He ramã amehtyc catêjê te me ijõkre par, ne hacpỹa mã amehtĩr ne kre pê me hapôj xàa kam ri ramã hàhhuc to mõ. ");
INSERT INTO ram_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ne por mempejti ton to me ipa atajê, quê ha mehtyc xà jirô pê hacpỹa mã mehtĩr, ne Pahpãm cahê na amji to me ipijapar rohnỳtti mã. Ne por mehkĩnte mehkêanre ton to me ipa atajê, quê ha mehtĩr, ne cama mehkên mã me axà, ne ampỳa mã, Pahpãm pê amji to me acto. ");
INSERT INTO ram_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","— Ne pa wa nee amjia kôt jũm kên mã mẽn nare, ne Inxũ te catyt kam amji jahkre pejti te me hahkre pej xà ata kôt, wa ha me to ajcokjê. Na wa nee apu ampo itajê to ihcupan nare. Ampo na? He wa nee ite amji kam ijapac xàa na jũm kên mã mẽn nare. Ne por Inxũ te ikujahêc ata te amji kam hapac xàa kôt wa hãn ne mehkên catêjê kên mã me curẽ, ne mempejti catêjê atajê impej mã me curẽ. ");
INSERT INTO ram_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","— Ne wa ha pa ipyxit peaj ne me amã amji kôt harẽ na mã, quê ha ite amji jarẽn xà itajê kôt hamreare ne. ");
INSERT INTO ram_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ne nee mã ipyxit peaj nare, ne ihtỳj icaxuw jũm ata, ne cupê ijõ Inxũ. Ne por ito ampo na awjarẽ atajê, ampeaj kam ri, nee mã Inxũ apu ihhêj xi jarẽn nare na, ramã imã hahkre pej. Inxũ te ijarẽn xà ata ampeaj kam ri, ne nee ihkôt hamre xà nare. ");
INSERT INTO ram_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","— Ne ate me ina gàhcukjêr ne me ijarẽn par prãmte, Jowãw te me cumrãr catê wỳr me jũmjê kujahêc, mã cute me cumã ito hũjarẽn par atajê ri nee ihhêj xi xà nare, ne ampeaj kam ri. ");
INSERT INTO ram_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ne nee imã pjê ita kam, cute me cumã me ito hũjarẽn xà ita na prãm nare, ne quêt Inxũ te ito hũjarẽn xà atajê ri imã impej, ne nee ihkôt hamre nare. Ne mẽr ampo na ri Jowãw te me cumrãr catê te me amã ijarẽn to hajỹr? He ca ihhêaj to ijarẽn par xà atajê kôt me ikampa, ne ate amji mã meito ahimpej na, ca ha nee me akên mã me axàr nare, ne atỳj me atyc xà jahpa. ");
INSERT INTO ram_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","— Ne pom ihpôc xà hãn ne amji na ampo jarare jàhtôa ne to cuprõ, ita jĩkjê na ri Jowãw te me cumrãr catê ata amji na me ato cuprõ. Ne cupê ihpôc xà pyràac ne me amã ahcujro, ca atỳj ahna ate me cuprõn to amcro to incrêre xà, mãr quê me amã ampo to hahkre. Ca hũrên ame gakry cakrô, ca ajte nee ate me hũjarẽn xà atajê cunea na me kam gapac nare. ");
INSERT INTO ram_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ne ampeaj kam pê Jowãw hirãa pê me amã ijarẽ. Mã cormã Inxũ Cati te ijàpên xà catia ita na imẽn, wa to ijàpên to ipa, atajê ri Jowãw jirôa pê, hirãa pê ijarẽ, ne hanea ne ihtỳj ajpên Inxũ te ikujahêc na ijarẽ. ");
INSERT INTO ram_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ne hanea ne Inxũ te ikujahêc ata, ihtỳj ito me amã awjarẽ cakrô, ca rỳ jũ caxuw ate me hõkre par ne me hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ca nee ajte icakôc xà itajê na me ipar, ne amji mã me ito ahimpej nare. Ne ca rỳ jũ caxuw ate me Inxũ te ajpên ikujahêc ata jõkre me, cute me amã harkwa jirên atajê nõ impar nare. ");
INSERT INTO ram_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ne cormã ihnõ xwỳjê, he ca atỳj me Inxũ pê Pahpãm jarkwa na ihkàhhôc to hahkre to me apa. Ne ate me to hahkre xà atajê kôt atỳj nee jũ caxuw ate ame atyc nare na, ame amji cãmjĩ. Ne por ihkàhhôc ata ihtỳj ito awjarẽ. ");
INSERT INTO ram_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Cakrô ca ma ajte ite me amã me atĩr rohnỳtti mã xà ata jõr xà wỳr ame gitõt. ");
INSERT INTO ram_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","— Ne imã Inxũ te ito ihcakôc to impejti naa pit mã to prãm. Cwỳrjapê ri imã pjê kam me hũmre te ikôt me harẽn to impejti na me to prãm nare. ");
INSERT INTO ram_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ne wa ite ramã me akrãhky na me amã Pahpãm kĩn na me gahkre pej, ne nee me amã caxwãm catia mã Pahpãm kĩn nare. ");
INSERT INTO ram_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne wa Inxũ te amji kam hapac xàa na ajpên me awỳr icator cakrô, ca ajte ma ame icaca. Ne quê ha pjê ita kam, ita ri, ajte jũm xũmre amjia kôt cute amji kam hapac xàa na me awỳr cato, ca ha atỳj ahna me amji capa, ne ihkôat me amji to. ");
INSERT INTO ram_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ne ate pjê kam me hũmre te me apejti na me garẽn na ri, me amã impar prãm. Ne Pahpãm te me apejti na me garẽn na ri, nee amji to me amã gàhcukjêr to prãm nare, ita kam jũ mã ca ha ne ito amji mã me ahimpej? Wỳr ca ha amji mã hamã ne me to. ");
INSERT INTO ram_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","— He xà pa wa ha ajkĩ Inxũ cuna mã me garẽn to kêanre ne? Hãpà. Ne pom ca me Mojxe xwỳ te me hapackre xà to me amji kampa, ne cute me atehcajpar xà na amji mã me to hane ita, quê ha Pahpãm mã me apê mehkên ton catêjê na me amã hacjê. ");
INSERT INTO ram_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nãmri ca ha me ate caxwãm catia mã amji mã me Mojxe kam gapac na, ca ha atỳj hanea ne ito amji mã hane. Ampo na? Taa mã pê ina ihhôc. ");
INSERT INTO ram_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ca nee ramã Mojxe to amji mã me ahimpej nare ita kam, jũ wỳr ca ha ito amji mã me ahimpej — hajỹr. Hõ, Jeju te Juta catêjê jõ pahhi kwỳ mã harkwa to hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ita jirô pê mã, wa ma Jeju me, me ikwỳ me, Hĩpôjajo jõ cô na me irêr, ata japrỳ nõ te Tiperij jõ cô. ");
INSERT INTO ram_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mã me ikôt me hàhtôa ne me mõ. Ampo na? Cute me Jeju te me hà caprãr, ne me to impej pyrentu na me hõmpun na ri. ");
INSERT INTO ram_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wa hàhkà jakôt nõ na Jeju me, me ipê ihkôt me ipa catêjê me, me ijàpir ne me ijỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pê caxuw ramã me Hakren xà jõ amji kĩn me Pãwtỳjre jõ amji kĩn na ahtipre. ");
INSERT INTO ram_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mã Jeju te amji wỳr, por ihkôt me hàhtôa ne me mõ atajê pupun, ne cute Pirip mã harkwa to: — Jõ ri cu ha ajte me hàhtôti itajê mã me hõ nõ mã me pahcato, ne me hũhkà? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ne pê ramã cute me cumã pãw kryj ata kam to hàhtô to amji kampa, ne cama cute Pirip cajpẽar prãmte pê cumã hane. ");
INSERT INTO ram_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mã Pirip cumã: — Ahpỹanre na me pyxit te me pãw kryjre ne mencwỳr xà caxuw, cu ha me putwrỳ te ôjtô jàpên xà jõ pore jirôa pê ahna me cumẽ cakrô, quê ha nee me cahuc nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Mã Antre pê Petrô tõ te cumã harkwa to: — Ihnãm hã ahkrare xũmre nõ ita mã pãw kryjre te xĩc, ne caxuw cumã tep pijakrut ne hàr hiahpuro mã to jỹ he, ne jũ wỳr quê me hàhtôti itajê catwỳ! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mã Jeju te me imã harkwa to: — Me cumã, quê mehcunea pjê kam me to jỹ — hajỹr. Ne pê ampeaj kam pjê ata kam põre. Mã mehcunea jỹr, pjê kam, ne por me hũmre me hỹr atajê pê me hàhtô na me xĩc mir, me hũmre pit. ");
INSERT INTO ram_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mã Jeju te pãw kryjre atajê incwỳr ne hũrên hakryti na Hũm pê Pahpãm mã to amji jarẽn. Ne cute ihcokjêr ne me imã hõr, wa ite me cumã hõr par, mã cute tep pijakrut atajê to hajỹar. ");
INSERT INTO ram_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mã ajte me hõ pãw kryjre itajê to mehcunea jarte partu. Ne cute me hàpàn tohhi jirô pê mã ri, Jeju te me imã harkwa to: — Cute ame cahhur tohhi itajê to kàhà kam me cuprõ, quê nee ihnõ ipictor nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wa ite me to cuprõn, ne me to kàhà to tôxi ne me to hipu par, por pãw kryjre te xĩc atajê cahhur to. ");
INSERT INTO ram_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mã cute Jeju te ampo pejti ton xà ita na me hõmpun, ne amji mã me harẽn to: — He ampeaj kam ri hũmre ita pê me pamã Pahpãm jarkwa to ihcakôc catê, por pê Pahpãm me pamã cator xà na to awjahkre ata mã he — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mã Jeju te, cute me hàprêa kam amji mã me to hõ pahhi na me hahkre pej, ne ma ahte tẽ, ne kẽnti kàa nõ na hàpir. ");
INSERT INTO ram_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mã ramã me ina caxwa, wa curia ite me Jeju rer, ne ma me iwrỳc, hĩpô tohkà wỳr. ");
INSERT INTO ram_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ne pàr kre mã me icjêj, ne ma Capernam jõ krĩ wỳr ite me to irêr na me amji to hajỹr. Ne ramã ihcajpuaw pàr kre to me mõ, mã ramã awcapàtkô, mã nee cormã me iwỳr Jeju cator nare. ");
INSERT INTO ram_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mã kôc pahtỳjti ata te hàpêr kam ihtẽm, ne cô to harô to pra. ");
INSERT INTO ram_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wa ramã ite me imõr jũwry to me rec pyxit, cô kam, ne ma me to cakrỳn to mõ. Ne me ite amji wỳr ajpên cô jipy Jeju te mõr na me hõmpun, ne ampeaj kam me imã hũpa. ");
INSERT INTO ram_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mã pea me ina hàhtêp, ne cute me imã harkwa to: — Ame icupa nare, pa wa mõ, nee mã ipê me carõ nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wa ite me hahkre pej, ne hacpỹa mã hũrên ame ijakry, ne itỳj ite ahna me amji caxàr. Mã me iwỳr hàr, ne jũ mã cute pàr kre ton, mã cyt ne me imõr xà ata wỳr me ito icator. ");
INSERT INTO ram_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ne pê Jeju curi me cumã harte xà ata ri, wa ahte ite pàr kre pyxit peaj mã me icjêj na cute me ipupuan na, curia cormã me ahtwỳ, ne me Jeju jikaj. Ne nee pê ramã me iwỳr Jeju cator na me hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mã ma me ijakàn pê Tiperij jõ krĩ jõ pàr kre kwỳ cator, por curi Jeju te Hũm mã pãw pyrên hakryti jarẽn, ne me cumã kryj, mã cute ame to harte tu ata ri. ");
INSERT INTO ram_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ne cute me ijapên, ne curia ame Jeju jikaj atajê kwỳ te pàr kre kwỳ mã mencjên, ne ma me ikôt Capernam jõ krĩ wỳr me to cator, cute me Jeju japên prãmte. ");
INSERT INTO ram_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ne curia ri me hàhtôti atajê te me Jeju mã cator ne me cumã: — Hàpà me Ikrã tũm! Jũ caxuw mã ca ita ri acator? Wa ihcaprỳ na curi ame gikaj, ca ate jũ mã ajte ne ramã ita ri acator? — hajỹr. Mã Jeju me cumã: ");
INSERT INTO ram_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","— Ampeaj kam wa ha me garẽ! Ca ate ijàpên xà catia na me ipupun, ne Pahpãm kra na ate amji mã me ito hajỹr to, ca ikôt me acator nare. Ne ame garte prãm ita to pit mã, ca ikôt me acator. ");
INSERT INTO ram_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","He ame hajỹr nare! Nee ca pjê ita kam, ate amji to me apijapar prãmte, me gàpàn to pit mã ame amji kam gapac nare. Ne quêt Pahpãm cahê na ate amji to me apijapar rohnỳtti mã xà ata to, ca ha me amji kampa. Ampo na? He ate me to amji kam me gapac ata pê ihhêj rũm me gõ te me ato me atĩr rohnỳtti mã xà. He ipê me Ahàkà, na wa ite me axũmrea na amji ton, ne me amã Inxũ Cati to hahkre, ca ate cahê na amji to me apijapar rohnỳtti mã xà caxuw. Mã ihtỳj Inxũ pê Pahpãm te, ite to ijàpên xà caxuw imã carôt jõr. Ampo na? He cumã ipej na ri — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mã cute ita na mehcukij to: — Ampo ton na ri Pahpãm mã me ito prãm, wa me cumã to? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mã Jeju te me cumã harkwa to: — Ate ito amji mã me ahimpej na ri, Pahpãm mã me ato prãm, cwỳrjapê ri cute me awỳr ikujahêc — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mã me cumã: — Ca ha hipêr acarôat to ampo pihho pejti to! Wa ha ahna me apupu, ne itỳj amji mã me ato ihimpej! ");
INSERT INTO ram_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","He pê me panquêtjê põ kam me hamreare ata kam ajco me hõ pê mana ata pit kur to me ipa, ata pê Pahpãm jõ kàhhôc kam harẽn to: “Cute côjkwa pĩn me cumã me hõ jõr, mã cute mehkrẽr” hajỹr. Na ca ha pijamã ajkĩ cuxà me imã to? Wa ha me hõmpu, ne me cukrẽ, ne itỳj amji mã me ato ihimpej — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Mã Jeju me cumã: — Ỹhỹ, ampeaj kam wa ha me amã côjkwa jõ ata kôt harẽ. Pê rỳ pêa mã Mojxe xwỳ jõ caku kam, cute pjê kam amji to me ipijapar xà caxuw pit mã, pê Pahpãm me cumã me hõ japrỳ te mana ata gõ. Ne nee mã pê Mojxe me cumã hõ ata jõr nare, Pahpãm pê me cumã cugõ. Ne pom curmã côjkwa pĩn Pahpãm jõ intuwti cator ita pê ri côjkwa kam Pahpãm cahê na ate amji to me apijapar rohnỳtti mã xà caxuw impej — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mã me cumã: — Me Ikrã tũmti, gõtpê amcro cunea kam, mẽr me imã Pahpãm jõ intuwti ita gõ! — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mã me cumã: — He ipê ri ihhêj rũm côjkwa pĩn Pahpãm jõ intuwti ata, na wa ha me to ihtĩr rohnỳtti mã. Quê ha jũm ty, ne ihtyc jirô pê hacpỹa mã ihtĩr, ne nee hipêr jũ caxuw ihtyc nare. Quê ha prãm na jũm te apu ipa na, quê ha apà ne hacpỹa mã ihtỳj, ne cumã amji kĩn, ne harte pyrên hakry. Ne quê ha hanea ne jũm kôr na apu ipa ne ikõ, ne hacpỹa mã ihtỳj ne cumã amji kĩn. Jĩkjê na, quê ha jũm te Pahpãm jahkre pej ne cumã amji jõr, ne ahna mehkwỳ mã hàr to prãm na, quê ha iwỳr apkjê ne ito amji mã ihhimpej, ne Pahpãm jahkre pej, ne ahna mehkwỳ mã hàr pyrên hakry. ");
INSERT INTO ram_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","— Wa ramã ite me amã me atoa icakôc to, ca atỳj me ipupun cakrô, ca nee cormã me ikam gapac nare. ");
INSERT INTO ram_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ne por Inxũ te ijũhkra mã me hacjên xà atajê, quê ha ihtỳj ijũhkra mã me acjêj, wa ha itỳj amji mã me huwahi, ne jũ caxuw põ mã, amji pê, jũm to ijũcapêr, quê ha ipictor nare. ");
INSERT INTO ram_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ne por Inxũ te ampo na amji mã ito prãmti xà ata wỳr pê wa côjkwa pĩn wrỳ. Ne nee amjia kôt ite amji mã ampo na prãmti ata wỳr, iwrỳc nare. ");
INSERT INTO ram_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne ite, cute ijũhkra mã me hacjên atajê to hajỹr xà caxuw ri, cute me awỳr ikujahêc he. Quê ha nee jũm ipê ipictor nare. Wa ha jõ ri pjê jamre xà ata kam, me to ipicokjêr xà jõ amcro kam, itỳj amji kôt hacpỹa mã mehcunea to ihtĩr. Hõhõ, ita caxuw ri Inxũ te ikujahêc. ");
INSERT INTO ram_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ita na ri Inxũ ito prãm he. Quê ha ihtỳj ipê Pahpãm kra te hajỹr romã mã iwỳr me apkjê. Ne por quê ha ito amji mã mehhimpej atajê, wa ha jũ caxuw, pjê jamre xà ata kam, hacpỹa mã me to ihtĩr. Quê ha me to ipicokjêr xà jirô pê Inxũ cahê na mehtĩr rohnỳtti mã na ame ipa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mã Juta catêjê kwỳ te ajpẽn mã me Jeju to ihcakôc kên kam mehtẽm. Ampo na? Cute côjkwa pĩn cupê me hõ tuaw pyràc ne iwrỳc na amji jarẽn, na ri ame ajpẽn mã harẽn to hane he: ");
INSERT INTO ram_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","— Pom cupê Joje me Marij kra ita? He wa ramã ite me hõmpun pejtu, nõ na mã ajte côjkwa pĩn iwrỳc na amji jarẽ? — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mã Jeju te mempar ne me cumã: — Nãmhã ne apu ihêj xi na amji mã me ito hajỹr jicu. ");
INSERT INTO ram_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jũ wỳr quê jũm amjia kôt amji to ikôt ipa catê. Nãmri quê ha Inxũ te jũm pê ikôt ipa catê na ton na, quê ha ihtỳj cupê ikôt ipa catê. Na wa ha itỳj hacpỹa mã to ihtĩr, ampo cunea jamre xà ata kam. ");
INSERT INTO ram_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ne Pahpãm jarkwa to mehcakôc catêjê jõ kàhhôc kam hũjarẽn xà te hajỹr he: “Quê ha Pahpãm pê mehcunea mã ampo to hahkre catê” hane. Quê ha cute me kam hapac, ne amji mã me to ihhimpej atajê, quê ha ajpên iwỳr me apkjê, ne iwỳr me pra, ne ihtỳj amji mã me ito ihhimpej. ");
INSERT INTO ram_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ne rỳ jũ caxuw ita ri, pjê kam catêjê nõ te Inxũ pupun nare, ne pa nare. Wa ipyxit peaj ne itỳj quêt hõmpu. Ampo na? He curũam wa icator, na ri imã hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","— He wa ampeaj kam me amã awjarẽ, quê ha jũm te amji mã ito ihhimpej na, quê ha ihtyc jirô pê hacpỹa mã ihtĩr, ne ihtĩr ita na apu ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na ri ipê me gõ te me ato atĩr rohnỳtti mã xà ata. ");
INSERT INTO ram_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ne pê mam me panquêtjê põ kam me hamreare ata kam ame hõ pejti japrỳ te mana ata pit ku cakrô, pê ihtỳj amehwej ne amehtyc partu, ne nee cama hacpỹa mã jũm tĩr nare. ");
INSERT INTO ram_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ne por mehwỳr côjkwa pĩn me hõ tuwti wrỳc ata, quê ha jũm te ihkwỳ krẽr na, quê ha Pahpãm cahê na ihtĩr ita na apu ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne ipêa ri côjkwa pĩn me cumã me hõ tĩar wrỳc ata. Ne ipêa ri me to ihtĩr rohnỳtti mã xà. Wa ha pa, pjê kam mehcunea mã amji gõ. Na quê ha jũm te ihhêj ne ikwỳ krẽr na, quê ha Pahpãm cahê na ihtĩr ita na apu ipa rohnỳtti mã — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mã Juta catêjê kwỳ ame kam incryac to ame kam incryc, na ri cute me ajpẽn mã harẽn kên kam ihtẽm, ne me harẽn to: — Jũ mã quê ajte hũmre ita ne me pamã amji jĩa gõ, cu ame cuku? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mã Jeju me cumã: — He ampeaj kam wa ha me amã amji jarẽ, ca ha me ate ame ipê Ahàkà jĩ kur nare, ne nee ame icaprô ita to ame akõm nare na, ca ha nee Pahpãm cahê na amji to ame apijapar kam me to acrà nare, ne atỳj ame atyc pa, ne me akôt hamre rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ne quê ha jũm te ijĩ kwỳ krẽr, ne icaprô ita kwỳ to ihkõm na, wa ha itỳj jũm ata to hacpỹa mã ihtĩr, por jũ caxuw me to ipicokjêr xà jõ amcro pê ampo cunea jamre xà ata kam. ");
INSERT INTO ram_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quêt ijĩ ita ri pjê kam me hõ itajê jirôa pê impej. Ampo na? He ijĩ ita pê ri quêt me hàpàn xà impejti ata, ne icaprô ita pê ri quêt mehkõm xà impejti ata, me to ihtĩr rohnỳtti mã xà caxuw. ");
INSERT INTO ram_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na quê ha jũmjê te ijĩ kwỳ krẽr, ne icaprô to mehkõm na, wa ha ramã me ajcacwa, ne ajpẽn kam me ihônco tu ne. Quê ha ramã Icarõ Pejti me cumã acjêj, quê ha Icarõ Pejti ata carôat kôt me ipa. ");
INSERT INTO ram_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ne por Inxũ pê mehtĩr xà cunea xakat ata te ri ajpên ikujahêc, na wa itĩar na ipa. Na quê ha jũm te ijĩ kwỳ krẽr na, quê ha hanea ne ihtĩr ita na apu ipa. ");
INSERT INTO ram_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hõhõ, pê mam me panquêtjê me hõ pejti pê mana krẽr cakrô, ihtỳj amehwej pa, ne amehtyc partu. Ne pom curmã côjkwa pĩn ipê me hõ intuwti wrỳc ita caca xà te nee hajỹr nare, ne ajteare mã, wa quêt mehtĩr rohnỳtti mã na me to — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pê Capernam jõ krĩ kam, cute me cuprõn xà jũrkwa kam Jeju me cumã hũjarẽn xà ata to awjarẽ to hane. Ne nee pê cormã ne Jeju me cumã amji to ipipẽ nare, mehcunea te me hahkre pej cupate. Cwỳrjapê pê ajco cute me cumã amji jarẽn xà itajê cwỳrpê me cumã amji jarẽn to ipa. Ne Jeju jĩ kur xà ata kôt harẽn xà te hajỹr he. Quê ha ihtỳj jũm amji mã Jeju to ihhimpej, ne ihkôat ipa, ne ihkôt ipa xà ata pê ri cute hĩ kur xà. ");
INSERT INTO ram_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mã Jeju kôt me ipa catêjê jàhtôa ne cute me ita par, ne ajpẽn mã me harẽn to: — Pom me pamã ampo to hahkre itajê impar kôt hakop jahkre kêatre! Ne jũ mã quê ha jũm kam hapac to, ne hahkre pej ne ahna amji capa? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ne nee jũm te Jeju mã me harẽn nare kam, mã cutea ramã me ahna ihcakôc xà ata jahkre pej, cwỳrjapê ri cute mehcukij to: — Xà ita cwỳrjapê mã ca ame icaca, ne ame imã hikran prãm? ");
INSERT INTO ram_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","He ca ha atỳj jũ caxuw côjkwa wỳr ipê me Ahàkà te hacpỹa mã hàpir na me hõmpu. Jirô pê mã ca ha cormã me ijũjarẽn xà itajê kôt me hakop, ne me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ne Pahpãm Carõ Pejti ata ri cahê na me ato ipijapar rohnỳtti mã. Ne jũ wỳr ca me anõ amjia kôt amji mã hamã ne ca amji to ajpa, ne me ca ajpẽn to me ajpa. Ne ca ha ate me icakôc xà ita na ikam me gapac na, quê ha Pahpãm Carõ Pejti me amã acjêj, ne me ato ipijapar rohnỳtti mã. Hõhõ, ita pê ri ate me ijĩ kur xà ata, pom wa me amã harẽ ita. Ne wa ampeaj kam me amã ampo itajê jarẽn cakrô, ca ajte nee me akwỳ ito amji mã me ahimpej nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ampo na pê Jeju me cumã ita jarẽ? Nee mã ampo na nare. He pê ramã rỳ pêa mã, mam jũmjê atajê te to amji mã mehhimpej xà nare na me hahkre pej, ne hanea ne jũm te ihkên mã mẽn xà ata na hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne cute me cumã: — Cwỳrjapê wa ite ramã me amã harẽn xà ata na, quê ha Inxũ te ikôt jũm te ipa catê na hãm nare na, quê ha nee cupê ikôt ipa catê nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na ri Jeju kôt me ipa catêjê jàhtôa ne cute ihkôt me ipa jicu, ne nee hipêr ihkôt me ipa nare. ");
INSERT INTO ram_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mã cute me ipê ihkôt me ipa catêjê te tôxi itajê cukij to: — Xà ca ha hanea ne me ijicu, ne ma me aprar prãm? — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mã Ximãw Petrô te cumã harkwa to: — Jũm wa ha ajte me hũnã? Me ijõ Pahhiti, pom acakôc xà itajêa ri quêt me imã ite amji to me ipijapar rohnỳtti mã xà to hahkre. ");
INSERT INTO ram_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wa ite me Pahpãm te apê jũm pejti ata kujahêc na me gahkre pej, na wa itỳj ite amji mã me ato hajỹr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mã Jeju me imã harkwa to: — Ỹhỹ ita cwỳrjapê wa ite amji mã me ate tôxi itajê capi cakrô, mã me anõ pyxit ne kam me pahcurê xwỳn carõ kên jõ pahhi — hane. ");
INSERT INTO ram_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ne pê Jeju, Juta Carijot pê Ximãw Carijot kra ata to, pê me imã ihcakôc. Ampo na? Juta ata pê ihkôt me ipa catêjê te tôxi atajê nõa cakrô, quê ha ihtỳj jũ caxuw Jeju curê xwỳn tehcajpa, ne ihkên mã cumẽ. ");
INSERT INTO ram_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ita jirô pê mã ri ma Jeju ame ito mõ, Hĩpôjajo jõ pjê kam, ne pê nee Juta jõ pjê kam ajco apu ipa nare. Ampo na? Pê curi me hõ pahhi catêjê apu mehcuran prãm na pê. ");
INSERT INTO ram_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mã ramã caxuaw Juta catêjê jõ amji kĩn nõ japrỳ te Ikrere jõ amji kĩn ata to me cator xàa kam. Pê ajco me hõ amji kĩn ton xàa na, ihtỳj ikrere atajê kam amehkrĩ, ne nee me hũrkwa pej kam amehkrĩ nare. ");
INSERT INTO ram_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Mã cormã hapu na Jeju kôt mehkjêjê atajê te ihtõ kà pê Pahpãm kra na amji mã me to hajỹr nare, na ri cute me hapactua kam cumã harkwa to: — Juta jõ pjê wỳr atẽm pyrentu, ne curi acato, ne acarôat to me cumã ampo pihho catihti itajê cunea to, quê me hàhtôti atajê me hõmpu! Quê ha jũm mã amji to cati prãm na, quê ha nee apu ipimxur to ihcuhkwỳr nare. Ne mẽr ampo na quê ate ampo jahkre pej xà itajê na me apupun nare? Me cumã to, quê ahna mehcunea me apupu! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mã Jeju me cumã: — He cormã nee ite mehcunea mã amji to ipipẽ xà jõ amcro kam hàhhuc nare! Ne me amã amji kĩn wỳr me aprar xà caxuw amcro cunea impej. ");
INSERT INTO ram_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mã pjê kam catêjê itajê nee quêt ame acurê nare. Ne pa nare, me ikam incryc kam ame ipa. Cwỳrjapê ri ma ame icurê, ne ma ame icaca! Ampo na? Wa itỳj me cumã, cute me ampo to kên atajê jarẽn to ipa na ri, ma ame icurê. ");
INSERT INTO ram_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ne me ca nare, gapacta ne amji kĩn ita wỳr me mõ. Waha ita ri apu mõ. Ampo na? He cormã amji kĩn wỳr imõr xà caxuw nee ijõ amcro kam hàhhuc nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hõ, Jeju te me cumã amji jarẽn to hajỹr, ne curia Hĩpôjajo jõ pjê kam hàhhuc, ne apu mõ, me hakàn pê. ");
INSERT INTO ram_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wa me hakàn pê ame ipa, mã me ina jũ mã amcro te, wa ma me ipimxuar pê Jeju me, me mõ. Mã nee jũm te me imõr xà na me ipupun, ne me ijahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mã tee Juta catêjê jõ pahhi kwỳ amji kĩn ata na, me hàhtôti atajê catàtkre na ame Jeju japê. Ne ame hapên to me ahna hàhcukjêr to hajỹr to me ipa he: — Jõ ri mõrmõ Jeju apu mõ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mã me hàhtôti atajê kwỳ kàjpej pê, ajpẽn mã me Jeju jarẽn to: — Ampeaj kam jũm ita pej — hane. Ne mehkwỳ ajpẽn mã me harẽn to: — Quê, he jũm ita ihtỳj mehkwỳ mã ihhêj xi to ipa — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mã Juta catêjê jõ pahhi kwỳ mã Jeju kĩn nare na, cute me hahkre peaj xà na, nee jũm me kam mare mã ajpẽn mã Jeju kôt harẽn nare, me hõ pahhi kwỳ te ame kam incryc, ne ame to kên cupate. ");
INSERT INTO ram_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ne ramã cute me to amji kĩn ata krã curan xà wỳr, ihcahti na cute me to hajỹr. Mã ma Jeju Pahpãm to me amji kam hapac xà jũrkwa wỳr mõ ne hàr, ne curia hỹr ne ame cumã ampo to hahkre. ");
INSERT INTO ram_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mã Juta catêjê kwỳ te mehcakôc xà atajê na mempar, ne me amji mã harẽn to: — Pỳhàpà! Pê nee ihkàhhôc to hahkre cati nare cakrô, ampeaj kam cute amji jahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mã Jeju me cumã amji jarẽn to: — Pom wa me amã ampo to hahkre itajê, wa nee amjia kôt hahkre pej, ne me amã to hahkre nare, ne nee cupê itekjê nare. Ne cupê Pahpãm te ikujahêc ata tekjê. Ne curũam ri ajpên ampo itajê pra, wa cama me amã to hahkre. ");
INSERT INTO ram_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ne quê ha jũm mã Pahpãm te amji kam hapac xà jahkre pej, ne ihkôt amji ton to prãm na, quê ha ite ampo to hahkre xà itajê na ikampa, ne hahkre pej pyrentu, Pahpãm pĩn hapôj na, ne nee ikrã pĩn hapôj nare. ");
INSERT INTO ram_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","— Ne quê ha mehcunea te amji mã me jũm cupa to prãm to, quê ha ihtỳj amjia kôt, ihkrãa kam me cumã ampo jarẽn to ipa. Ne pa nare, wa nee ite hajỹr nare. Ampo na? Imã ate amji mã me icupa ita na me ato prãm nare, quêt ate me amji mã me Pahpãm te ikujahêc ata cupahti na ri, imã me ato prãm. Na wa itỳj catyt kam me amã ijũjarẽn xà, hêj xi nare ita to ijũjarẽn to ipa, ne nee wa ame amã ihêj xi jarẽn to ipa nare. ");
INSERT INTO ram_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ne pê ramã Mojxe xwỳ me panquêtjê mã Pahpãm jarkwa gõ cakrô, ca ajte nee amji mã me kam gapac nare, ne mẽr ampo cwỳrjapê mã ca tee ame icuran to hahkre? — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mã mehcunea te Jeju mã me harkwa to: — Mõrmõ ca apu akrã kam waj, na mã ca apu amji na me ikraj! Jõ ri mã jũm apu acuran prãm ita? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mã Jeju me cumã: — Por wa ite me pahkôt xà jõ amcro na icarôat to ampo pihho pyxit peaj ton, ne ite jũm xà ata caprãr, ne to me amã ipikrar ata to, wa ite amji na me amẽn, ca ajte ame ikam acryc. ");
INSERT INTO ram_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ne ca hanea ne atỳj me pahkôt xà jõ amcro na me apê. Ampo na? Quê ha me pahkôt xà jõ amcro na jũm cahãj mã ihkrare ihpỳm, ca ha atỳj ajte me pahkôt xà jõ amcro itajê nõ na me cumã impy kà kwỳ jakep, pê Mojxe xwỳ me amã to hahkre xàa na. Ne nee mã pê Mojxea ita to ipipẽ nare, ne mam Mojxe quêtti pê Aprãw xwỳ ata mã pê ita to me amã ajpẽ. ");
INSERT INTO ram_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ne Mojxe xwỳ te me hapackre xà ita kôt, mã ca atỳj me pahkôt xà ita na me ahkrare mã mempy kà jakep. Ne nee ipê me apyràc, wa ite jũm ita pê ihkà kwỳ jakep nare, ne quêt cumã ihkà cunea na to impejti, ca ajte ita na ame ikam acryc? ");
INSERT INTO ram_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ne ca hãn ne ajte ampo na me hõmpun pyxit peaj kam, ramã ihkêanre na me harẽ. Ahna cute hajỹr nare, ca ha xa ate hõmpun xà ata kôt to amji kampa, ne ihkôt hakop, ne impejti na hahkre pej, nare, ihkêanre na hahkre pej jirô pê, ca ha cormã atỳj harẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mã Krĩpinkrên catêjê kwỳ Jeju na me ajpẽn cukij to: — Xà Jeju ita mã me pajõ pahhi catêjê amehcuran prãm? Ne mẽr ampo na mã cute mehpro nare? ");
INSERT INTO ram_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pom me pahcunea jipôc ri xa ne ame pamã ihcakôc ita? Mã nee ajte jũm te cumã ampo jarẽn nare? Nare, mõrmõ me pajõ pahhi catêjê, por pê Crixtô toPahpãm me pamã awjahkre ata na, mõrmõ amji mã me to hane? ");
INSERT INTO ram_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","He me imãa, nee cupê Crixtô nare! Quê ha jũ caxuw me pahwỳr Crixtô ata cato, cu ha nee jũ rũm cator xà na me hahkre pej nare. Ne pom jũm xũmre ita ri ihtỳj jũ rũm cator xà ata na me pamã hahkre pej, he cupê Naxare jõ krĩ catêjê nõ — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mã cormã Jeju Pahpãm to me amji kam hapac xà jũrkwa kam xa, ne cute me cumã ampo to hahkre xà ata kam, ihkrãhhia kam me cumã: — Xà ajkĩ ampeaj kam me amã jũ rũm icator xà ita na ijahkre pej? Hãpà! Wa nee amjia kôt icator nare, ne me apê, por ajpên cute ikujahêc ata jahkre kêatre. Ne por jũm te ikujahêc catê ata pê ri amji jarkwa par catê, ne catyt kam ipa! ");
INSERT INTO ram_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne imãa ri quêt hahkre pej. Ampo na? He ihpĩan wa icator, ne cutea ri ajpên ikujahêc — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mã cute mempar, ne tee amehpro to hahkre, ne nee jũm te ihcupên nare. Ampo na? He nee cormã cute mehpro, ne ihkên mã me mẽn xà kam hàhhuc nare na ri. ");
INSERT INTO ram_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mã me hàhtôti atajê jipôc ri me hàhtôa te ihtỳj Pahpãm te Jeju to me cumã hũjahkre na amji mã meto ihhimpej. Na ri me ajpẽn mã harẽn to: — He ihhêj ne me imãa, cupê, por pê Crixtô to Pahpãm me pamã awjahkre ata! Ne quê ha jũ caxuw ajkĩ Crixtô cato, ne ajkĩ, pom Jeju te ampo ton xà itajê jirôa pê ajkĩ to? Hãpà. Taa mã ri ramã cator — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mã Parixêw catêjê kwỳ te kàjpej pê cute amji mã me harẽn to hajỹr na mempar, cwỳrjapê ri cute Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, cute Jeju pro na me ajpẽn par. Ne cute hỹrmã me hõ krãhtare kwỳ kujahêc, cute mehpro ne me haxàr prãmte. Mã hỹrmã me cator ne cama mehcuhhê ne me kampa. ");
INSERT INTO ram_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mã cormã Jeju me hàhtôti atajê jipôc ri xa ne me cumã: — Wa ha itỳj cormã ijõtpê ame acahê na imõr crire ne, ne quê ha ina ahtũm nare, wa ha ma hacpỹ mã cute ajpên ikujahêc ata wỳr amji jaxà ne tẽ. ");
INSERT INTO ram_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ca ha me ipupun prãmte, tee ame ijapê ne nee me ipupun nare. Ampo na? Jũ wỳr ca me anõ, por wa curi apu mõ ata ri ikôt acato! Na ca ha nee me imã acator nare! — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mã Juta catêjê te ajpẽn mã me harẽn kam mehtẽm, ne me ajpẽn mã harẽn to: — Jũ kam mã quê ha ajte tẽ, cu ha ajte nee cumã me pahcator nare? Xà quê ha ajkĩ ma me cupê Crec catêjê jõ pjê wỳr tẽ, ne curia me cupê Juta catêjê kwỳ mã apu ampo to hahkre to ipa? ");
INSERT INTO ram_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ne mẽr ampo mã hãn ne harẽn kam pra ne harẽn to: “Wa ha ma tẽ, ca ha tee ame ijapê, ne nee hipêr me imã acator nare”, ne “Jũ wỳr ca me anõ curi itẽm xà ata wỳr ikôt tẽ” hane? — hajỹr. Hõhõ, pahhi catêjê te ajpẽn mã harẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ne pê me hõ amji kĩn cahhur ata, cute kam me to ihtẽm xà jirôa pê impej, na pê Jeju me hipôc ri xa, ne ihkrãhhia kam me cumã hũjarẽn to: — Quê ha me anõ mã, Pahpãm jahkre pej xà pê amã kôr pyràcti ata na prãm na, ca ha iwỳr tẽ, wa ha amã Pahpãm to ajpẽ, ca ha hahkre pej pyrên gakry. ");
INSERT INTO ram_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","He pê ramã Pahpãm jarkwa ita jarẽn to hane he: “Quê ha jũm te amji mã ito ihhimpej na, quê ha cute amji kam hapac xà tuw pejti atakôt me hàhtôa ne Pahpãm wỳr me apkjê, quê ha taa mehtĩr rohnỳtti mã na me to. Quê ha cute amji kam hapac xà tuw pejti ata pê cô catia pijapjêr ata pyràac, ne ipijapjêr ita na” — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ne por cô to mehkõm xà to Jeju te me cumã ihcakôc ata pê Pahpãm Carõ Pejti incwỳr xà. Ampo na? Por quê ha jũmjê amji mã me Jeju to mehhimpej atajê, quê ha ihtỳj me Pahpãm Carõ Pejti ata cwa. Ne ampo na pê cormã ne nee ame Pahpãm Carõ Pejti ita cwỳr nare? Pê cormã Jeju nee hacpỹ mã ihtĩr ne Hũm wỳr amji jaxàr, ne hacpỹa mã amji to cati nare na pê. ");
INSERT INTO ram_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ne pê me hàhtôa ne cute cô to mehkõm to me cumã ihcakôc na me kampa, atajê ajco ajpẽn mã me harẽn to: — Ampeaj kam ri hũmre ita pê me pamã Pahpãm jarkwa to ihcakôc catê catia, cu me hikaj ata, ne taa mã ri cator — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne pê mehkwỳ ajpẽn mã me harẽn to: — Me imã cupê Crixtô to Crixtô, ne toa pê Pahpãm me pamã awjahkre — hane. Ne mehkwỳ ajco ajpẽn mã me harẽn to: — Pom Jeju pê Hĩpôjajo catêjê nõ ita? Xà quê ha ajkĩ ihtỳj Crixtô jũ caxuw Hĩpôjajo jõ pjê pĩn cato? Jũ wỳr quê ha curũm cato! ");
INSERT INTO ram_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ampo na? Pê ramã Pahpãm jõ kàhhôc kam to hũjarẽn to hane he: “Quê ha ihtỳj jũ caxuw pahhi pê Tawi xwỳ tàmxwỳ nõ kam Crixtô cato, ne por pê curi Juta jõ pjê kam, Pãw jõ krĩ kam Tawi xwỳ ihkrĩ ata kam, quê ha ihpỳm” — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mã pea me hàhtôti atajê te Jeju to me amji kam hapac xà to me ipicapôn. ");
INSERT INTO ram_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ne pê mehkwỳ ihtỳj me pro ne ihkên mã me mẽn prãm, ne me hacjên xà mã me haxàr prãm. Ne pê nee jũm ajte ihcupên nare. ");
INSERT INTO ram_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na ri ma hacpỹ mã krãhtare atajê te me amji jaxàr, ne me hũ kam me pra, Pahpãm mã cute mehcajrẽn catêjê jõ pahhi kwỳ me, Parixêw catêjê atajê wỳr. Mã cute me Jeju japên ne ahna mehcukij to: — Ampo na mã ca nee ate mehpro ne ajpên iwỳr me to amõr nare, ne ajpên gũ kam me pra? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mã krãhtare atajê me cumã harẽn to: — Wa rỳ jũ caxuw ite me jũm te ihcakôc xà nõ to ihcakôc to hajỹr na mempar nare, ne ihcakôc xà itajê ajteare mã — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mã Parixêw catêjê atajê krãhtare atajê mã: — Pỳhàpà? Xà hanea ne ajte cute me amã ihhêj? ");
INSERT INTO ram_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Xà ajkĩ me ipê pahhi catêjê kwỳ me Parixêw catêjê kwỳ nõ te mã amji mã Jeju to ihimpej? Hãpà! ");
INSERT INTO ram_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","He por Jeju to amji mã mehhimpej to me ipa atajê pê me pahte amji kam me pajapac xà jõ kàhhôc jahkre kêatre! Cwỳrjapê quê ha Pahpãm ame to kêanre ne, ne mehkên mã me cumẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pê Nicotem ramã jũ caxuw caxwa ri Jeju mã ihcakôc ata pê mehkwỳa nõ, ne cute mehkwỳ mã harkwa to: ");
INSERT INTO ram_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","— He cu nee me pajõ kàhhôc kam pahte amji kam me pajapac xà ata rer, ne me jũm ata cukij ne mempar nare kam ihkên mã me mẽn nare. Cu ha xa mehcukij, ne me kampa, ne ihkên na me hahkre pej, ne cormã ihkên mã me cumẽ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mã mehkwỳ me cumã harkwa to: — Pỳhàpà, xà ajkĩ apê Hĩpôjajo jõ pjê catêjê nõa, mã ca atỳj apu Hĩpôjajo jõ pjê pĩn Crixtô ata cator na amji mã to hane? Apu hajỹr nare, ne cama Pahpãm jõ kàhhôc to ca hahkre ne hahkre pej, he nee rỳ jũ caxuw Pahpãm jarkwa to mehcakôc catêjê nõ te Hĩpôjajo jõ pjê pĩn cator nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jirô pê mã ri ikre wỳr mehcunea cutor, mã ma Jeju Pĩxô jõ kẽn wỳr mõ. ");
INSERT INTO ram_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mã amcro nõ na, awcahti xà wỳr, Jeju te amji jaxàr, Pahpãm to me amji kam hapac xà jũrkwa wỳr, ne hàr ne jỹ. Mã me hàhtôa ne ahna me ipixêr, ne me xa, ne cute ampo to me cumã hahkre xà atajê na ame kampa. ");
INSERT INTO ram_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mã cute me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, Parixêw catêjê te me pyjê nõ te ahti na impjê kaj na jũm me nõ ata pro, ne ma me to mõ. Ne cute Jeju cuna mã me hãm xà caxuw, ame cumã quêt. Mã mehcunea jipôc ri hãm ne xa. ");
INSERT INTO ram_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mã cute Jeju mã me harẽn to: — Me Ikrã tũm, pom cahãjre ita ihtỳj ahti na mõ ne hũmre ita to nõ, impjên kaj na. Mã jũm te ajpẽn kam me hõmpun, wa ite mehpro, ne ajpên awỳr me to mõ. ");
INSERT INTO ram_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ne pê Pahpãm jõ kàhhôc kam Mojxe xwỳ me pamã pyjê te hajỹrjê atajê kẽn to curan to hajỹr na, awjahkre he: “Quê ha pyjê nõ apu hajỹr to mõ ata ri kẽan to cute mehcuran xà” hane. Ne ca? Jũ mã ca ha cute hajỹr xà ita na me imã ihkôt harẽn to? — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ampo na pê pyjê nõ ata kôt ame Jeju mã harẽn to hane? Nee mã ampo na nare. Jeju te me hapackre xà nõ to ihcupan, mã cute mempar ne mehpro prãmte, pê tee ame to hahkre. Mã Jeju te cama hỹr ne me kam hapac, ne pjê na hikôt ne hũhkrahhi to kam ihhôc to mõ. ");
INSERT INTO ram_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mã mehcukij ita na. Mã cute amji capô ne hỹr pej, ne me cumã harkwa to: — Por rỳ jũ caxuw me anõ te Pahpãm cuna mã ampo kên ton nare ata, ca ha mam kẽn nõ to cahãjre ita kam awcapê, ate to ihcuran xà caxuw — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jirô pê mã ri hacpỹa mã pjê na hikôt, ne ihtỳj jỹ ne kam ihhôc. ");
INSERT INTO ram_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mã cute me Jeju te me cumã hũjarẽn to hajỹr na kam me hapac atajê, ma me pyxit ne me pra. Ne por mam jũm kàhtu ata ri ma mam me cumã tẽ. Ne ahnaa me pyxit ne ajkôt memprar ita kam me cutor. Mã ahte Jeju me jũm cahãjre ata pit jàhhuc. ");
INSERT INTO ram_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mã Jeju te amji capô ne hỹr pej, ne jũm cahãjre ata mã: — Hàpà? Ne mẽr jõ ri mã kẽn to cute ame acapêr prãm atajê? Ne mẽr jõ ri mã ame akôt harẽn to kêanre atajê? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mã jũm cahãjre ata Jeju mã: — Hamreare, nee jũm jàhhuc nare — hane. Mã cumã: — Wa nee pa xwỳjê ato kên nare. Mẽr gapacta ne tẽ, ne nee hipêr mõ ne ampo kên ton nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jeju te hipêr me hàhtôa mã ampo to hahkre kam ihtẽm, ne me cumã amji jarẽn to hajỹr he: — Ipê, pom hàhcujro xà ampo cunea cujro, ca me hõmpu ne me hahkre pej ita pyràac. Ipê Pahpãm wỳr me amã ijàhcujro catê. Na ca ha ate me amji mã ito me ahimpej na, ca ha jũ caxuw awcapàtkôti kam, me apê amji jahkre kêatre kam, mePahpãm pê apictor xà ata kam ame apa nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mã Parixêw catêjê kwỳ te me Jeju kam hapac ne me cumã: — Ca ramã ca apu amji to acakôc, na ri acakôc xà itajê kôt hamreare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mã Jeju me cumã: — Pom wa ampeaj kam me amã amji jarẽn to ipa itajê kôt nee hamre nare. Ampo na? He ampeaj kam, wa nee apu ihêj xi nare. Ne pa ri quêt imã, por jũ rũm icator xà ata na amji jahkre pej, ne hanea ne imã hacpỹ mã ite amji jaxàr xà ata na amji jahkre pej. Ne me ca nare, me apê jũ rũm icator xà ata na ijahkre kêatre, ne hanea ne jũ kam itẽm xà ata na me apê ijahkre kêatre. ");
INSERT INTO ram_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Na ca me ate amji kam me gapac xàa kôt, amji mã me ikêanre na me ito hane, nare, mõrmõ ca amji mã me ipej na me ito hane. Ne imãa, ate me ijarẽn xà itajê cunea kôt hamreare. Ne nee cormã ite mehkên me, mempejti cukij ne me to ipicokjêr xà jõ amcro cator nare. ");
INSERT INTO ram_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wa ha ite ramã me ato ipicokjêr xà na mã, wa ha itỳj catyt kam me akên me, me apejti to ipicokjêr to ipa. Ampo na? He wa ha ite ton xà ata kam, nee ahte ton nare. Quê ha hanea ne, por Inxũ te ikujahêc ata icahê na jỹ, ne ite me ato hajỹr xà to imã hahkre. ");
INSERT INTO ram_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ne Mojxe xwỳ te me amã incaca xà te hajỹr ata rer, na quê ha jũmjê ajkrut ne jũm te ampo ton xà ata na me hõmpu, ne cute me hõmpun xà ata na ajwar ajpẽan kôt me harẽn na, quê ha me amã ampeaj kam ri cute ton. ");
INSERT INTO ram_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ita jĩkjê na wa Inxũ te ikujahêc ata me ajwar me ijũjarẽn xà caxuw me ipijakrut, cwỳrjapê ca ha atỳj ite amji jarẽn xà itana me ikampa — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mã me cumã: — Jõ ri mã apãm ita? — hane. Mã Jeju me cumã: — He me apê Inxũ jahkre kêatre, ne hanea ne me apê ijahkre kêatre, quê ha me amã ijahkre pej na mã, quê ha hanea ne me amã Inxũ jahkre pej — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ne por cute Pahpãm to amji kam me hapac xà jũrkwa kam, cute me cumã ihpore to cuprõn xà ata cahê na, pê Jeju me cumã hũjarẽn xà itajê to awjarẽ. Mã nee cute mehpro ne me haxàr nare, me hacjên xà kam. Ampo na? Pê cormã nee cute mehpro xà jõ amcro hỹrmã cator nare, na pê. ");
INSERT INTO ram_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mã Jeju te hipêr me cumã amji jarẽn to: — He wa ha ma tẽ, ca ha ate me ipupun prãmte, tee ame ijapê, ne nee me ipupun nare. Ampo na? Jũ wỳr ca me anõ, por wa ha curi tẽ ata ri, ikôt acato. Na ca ha ita ri ame apa, ne ca ha atỳj me akên itajêa kam ame ty. Ampo na? He Pahpãm te nee me amã me akên itajê to impej ne to tojnõ nare ata kam, ca ha ame ty — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mã Juta catêjê ajpẽn mã me harẽn to: — Jũ kam mã quê ha ajte tẽ? Cu ha nee hipêr me hõmpun nare? Xà quê ha ajkĩ amji cura? — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mã Jeju me cumã: — He me apê pjê kam me apa catêjê, ne quêt ipê kỳj pê, côjkwa kam Pahpãm na mehkwỳ, na ri nee ipê pjê kam me akwỳ nare. Ne ate amji kam me gapac xà itajê pê pjê te amji kam hapac xà, ne ite amji kam ijapac xà pê ri kỳj pê, côjkwa kam, Pahpãm te amji kam hapac xà. ");
INSERT INTO ram_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ca ate nee ite me amã amji jarẽn xà ita to amji mã me hajỹr nare, cwỳrjapê wa ite me akên atajêa kam me atyc na me amã harẽn. Ca me ate, por Pahpãm te ajpên ikujahêc ata to amji mã me hajỹr nare, ne amji mã me ito ahimpej nare na, ca ha atỳj me atyc partu, ne nee hacpỹa mã me atĩr ne Inxũ cahê na me akrĩ nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mã cute me Jeju cukij to: — Ne mẽr me anõ mã ca? — hajỹr. Mã Jeju me cumã amji jarẽn to: — He ipê, por pê wa mam ramã me amã amji jarẽ ata, nepa wa cormã. ");
INSERT INTO ram_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne wa ha cormã, hipêr me amã me ate me akên ton itajê cunea jarẽ. Ne nee wa ahte cama me amã me akên xà itajê to icakôc to ipa nare. Ampo na? He wa, por Inxũ Cati pê cute amji jarkwa par catê, ne catyt kam ipa, ne ajpên cute ikujahêc ata jarkwa to, wa pjê kam mehkrĩ atajê cunea mã icakôc to ipa. Ne wa ha itỳj jũ caxuw amjia kôt me amã me akên xà ton itajê cunea jarẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pê nee cute me cumã côjkwa kam Hũm to ihcakôc xà ata na me hahkre pej, ne me kam hapac nare. ");
INSERT INTO ram_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Cwỳrjapê pê Jeju me cumã amji jarẽn to: — He ca ha jũ caxuw, ipê me Ahàkà te me hũmre na amji jahkre, mã cute pĩ na menxôr na me hõmpu, ne cormã me ijahkre pej pej. Na wa nee amjia kôt ampo itajê ton to ipa nare, ne Inxũ te ahna imã harkwa ne to imã hahkre atajê to pit mã ijàpên to ipa. ");
INSERT INTO ram_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne ampo na ri ajpên cute ikujahêc ata nee amji pê irer nare, ne ihtỳj apu icahê na ipa? Wa cumã cute amji mã ampo na prãmti xà atajê to pit mã ijàpên to ipa na ri — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ne Jeju te ihcakôc xà to hajỹr jirô pê mã ri me hàhtôa te cupê Pahpãm kra na amji mã me to ihhimpej kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mã Jeju te Juta catêjê kwỳ te amji mã me to ihhimpej kam mehtẽm atajê mã: — Ca ha ate amji mã me ito ahimpej kam me to acrà na, ca ha me apê ikôt me apa catêjê impej pit. ");
INSERT INTO ram_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na ca ha me ite amji kam me ijapac xà impejti itajê cunea jahkre pej partu. Na ca ha nee me apê cama me jũm jarkwa kôt me cumã hàpên catêjê atajê pyràc nare, ne atỳj quêt ame apa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mã me cumã: — He me ipê Aprãw xwỳ tàmxwỳ tàmxwỳ, mã nee rỳ jũ caxuw jũm te amji mã me ito cama me harkwa kôt me cumã hàpên catêjê nare, ne wa itỳj ame ipa, nõ na mã ca ajte jũm pê ate me ipytàr na amji jarẽ? — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mã Jeju me cumã: — Jũ wỳr quê cama jũm pê me cumã hàpên catê ata apu hàpên to mõ, ne amjia kôt hicu. Quê ha hõ pahhi cute hicu na cumã harkwa, quê ha cormã hicu. Ita jĩkjê na mã, me pahcurê xwỳn pê Xatanaj me ato hane, ne ihtỳj cormã me ato ihhimpej ita kam, ca nee me akên ton jicu nare. Ne ampeaj kam wa me amã awjarẽ, wa nee ame amã ihêj xi jarẽn nare. ");
INSERT INTO ram_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ne ihnõ xwỳjê te hajỹar he. Quê ha nee cama me hõ pahhi jarkwa kôt me cumã hàpên catêjê nõ hõ pahhi jũrkwa kam ihkrĩ kam incrà nare. Ampo na? Quê ha ramã hõ pahhi mã ihkĩn nare, quê ha ihtỳj hũrkwa tête cator, ne jũ kam ihkujate. Ne quêt ihkra ata quê nee amji tête cator nare, ne nee jũm mã ihpore na to hàhpan nare. Ampo na? Cupê ihkra, na quê ha hũrkwa kam ihkrĩ rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ne ipêa ri Inxũ Cati kra. Nãmri wa ha itea me acurê xwỳn pê Xatanaj pê me apytàr na, ca ha atỳj cama ame apa rohnỳtti mã, quê ha nee iràn xà na hipêr jũm me ato ihhimpej nare. ");
INSERT INTO ram_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","— He ampeaj kam ri me apê me panquêt xwỳ Aprãw tàmxwỳ tàmxwỳ, wa ramã ite me gahkre pej. Nõ na mã ca ajte ame icuran prãm. Ne mẽr ampo na mã ca ame icuran prãm? Nee mã ampo na nare, ca ma ame ite me amã ampo to hahkre xà itajê caca, na ca ame icuran prãm. ");
INSERT INTO ram_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne Inxũ te imã ampo jahkre, ne imã to hahkre xà atajêa na wa to icakôc to ipa. Ne me amã ajtea mã, me apãm pê Xatanaj ata ihkrĩ, ne me ato ihhimpej. Na ca ihkôat me amji kampa, ne atỳj me ampo kên ton to me apa — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mã me Jeju mã: — He me ipãm pê Aprãw xwỳ — hane. Mã Jeju me cumã: — Quê ha me apê Aprãw xwỳ kra na mã, ca ha cute amji kam hapac xàa to amji kam me gapac to me apa. Ne imãa, nee me apê ihkra nare. Ampo na? Ca nee me cute amji kam hapac xà to me amji kam gapac nare. ");
INSERT INTO ram_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na wa ite ampeaj kam me amã Inxũ te imã ampo to hahkre na harẽn. Atajê jarẽn cwỳrjapê mã, ca ame icuran prãm. He pê Aprãw xwỳ nee jũ caxuw jũm pejti curan prãm nare. ");
INSERT INTO ram_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ne ajteare mã, Inxũ Cati kaj na me apãm te me amã ampo ton to hahkre xà atajêa mã, ca me ton to me apa he — hane. Mã Juta catêjê Jeju mã: — Ne nee me ipê jũm mã ajteare mã hũm ata nare. He Pahpãm ita pê ri me ipãm, wa me to amji mã me ijõ Pahpãm, ne me ipê mehkra impeaj wa me — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mã Jeju me cumã: — Hamreare, me apê Pahpãm pê Inxũ Cati kra nare. Quê ha me apê Pahpãm kra na mã, quê ha ihtỳj me amã ikĩn. Ampo na? He ihpĩan wa icator. Ne nee wa amjia kôt apu ipa nare, ne cute amji kam hapac xàa to wa apu ipa. Ne cutea ri ajpên ikujahêc. ");
INSERT INTO ram_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ne ampo na mã ca nee me icakôc xà itajê impar jahkre pej nare? Nee mã ampo na nare. Ca nee caxwãm catia mã ito amji kam me gapac prãm nare. Cwỳrjapê ca ha nee me icakôc xà itajê impar jahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ne me apê Pahpãm curê xwỳn pê Xatanaj ata kra, na ca cumã ampo kĩnti itajê to pit mã me gàpên to me apa. Ne cute amji kam hapac xà ato, ca me amji kam gapac to me apa he. Ne pjê te amji ton pê mã, pê ramã me apãm ita mehcuran kam tẽ. Ne nee cupê catyt kam, ampeaj kam ampo to ihcakôc catê nare, ne amji cãmtàa rũm ri cupê ampo cunea to ihhêj xi to ihcakôc to ipa catê. Ne cupê ampo cunea hêj xi pãm, na ri ampo hêj xi xà to pit mã ihcakôc to ipa. Ne rỳ jũ caxuw ampeaj kam ampo to ihcakôc nare. Ne ramã cute me acaxuw incaca xà ita ton to amji pyràc tu. ");
INSERT INTO ram_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne wa quêt catyt kam, ampeaj kam ampo hêj xi xà nare to ijũjarẽn to ipa, ca ampo ita na ajte ma ame ipar caca. Ampo na? Ca nee caxwãm catia mã ito amji mã me ahimpej, ne me ipar nare to prãm to mã ca ame hane. ");
INSERT INTO ram_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ne gapacta ne ite ampo to kên japê ame amji cukij, ca ha nee me anõ amji mã ite ampo to kên xà nõ na ijarẽn nare. Ampo na? He wa rỳ jũ caxuw ite ampo kên ton nare. Na wa hãn ne catyt kam ampo atajê jarẽ, ca ma ajte ame ipar caca. Ne mẽr ampo na mã ca ajte nee amji mã ito me ahimpej nare? ");
INSERT INTO ram_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ne me cupê Pahpãm kra catêjê ihtỳj amji mã me harkwa cunea na me kampa, ne mempar to kênre nare. Ne me ca nare, nee me apê ihkra nare, na ca ma amempar caca — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mã me Jeju mã: — Nee mã apê Juta catêjê kra impeaj nare, ne me ikĩnte apê Krĩrĩtpej jõ pjê catêjê nõ, ne ihpĩan pê ca acato, ne akam ampo carõ kên te hipu tu — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mã Jeju me cumã: — Hamreare, ikam quêt ampo carõ kên hamreare, na wa quêt amji mã, por Inxũ te ajpên ikujahêc ata pit cupahti to ipa, ne ma haprỳ to cati to ipa. Ne me ca nare, ca ajte nee amji mã me icupa nare, ne cama me ito icrire to prãm. ");
INSERT INTO ram_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","He wa nee cute amji mã me icupa to prãm to icator nare cakrô, quê ha ihtỳj Inxũ Cati ata, por nee amji mã me icupa nare itajê cukij, ne mehkên mã me cumẽ. ");
INSERT INTO ram_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne ampeaj kam wa ha me amã awjarẽ. Por quê ha me ijarkwa kampa, ne amji mã me icupahti to me ipa atajê, quê ha jũ caxuw amehtyc nare, ne mehtĩr ita na ame ipa rohnỳtti mã, Pahpãm cahê na — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mã me cumã: — Hamre, ita caxuw wa ite me akam ampo carõ kên na me gahkre pej pejtu. Ne pê ramã Aprãw xwỳ me, por me cupê Pahpãm jarkwa to mehcakôc catêjê catia atajê mehtyc partu. Nõ na mã ca ajte amji jarẽn to: “Quê ha jũm amji mã ikampa, ne cute ijarkwa kôt ipa na, quê ha nee jũ caxuw ihtyc nare” hane? ");
INSERT INTO ram_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Pom me ipãmjê pê Aprãw me, cute Pahpãm jarkwa to mehcakôc catêjê atajê ihtỳj ramã amehtyc par ita? He xà ajkĩ me hirôa pê acati? Jũ mã mã ca apu amji to, amji kam gapac xà itajê to? Mõrmõ ca atỳj apu amji catia na amji cãmjĩ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mã Jeju me cumã: — He wa ha ipyxit peaj ne amji mã ipejti to icakôc to ipa na mã, quê ha icakôc xà atajê kôt hamreare ne. Ne pom ca Inxũ to amji mã me Apãm ata ri ihtỳj ijaprỳ to cati to mõ. ");
INSERT INTO ram_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ne ikĩnte me apê Pahpãm jahkre kêatre, ne imãa ri quêt hahkre pej. Wa ha ipê hahkre kêatre na amji jarẽ na mã, wa ha ipê me apyràac ne ampeaj kam ihêj xi. Ne nee ite hajỹr nare, ne itỳj quêt imã hahkre pej, na wa amji mã harkwa na kampa, ne amji mã hũpahti to ipa. ");
INSERT INTO ram_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ne me aquêt xwỳ pê Aprãw ata pê ramã icator xà ata na ipupu ne ijahkre pej, cwỳrjapê pê ampeaj kam hũrên hakry — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mã me Jeju mã: — Pỳhàpà? Xà pê ca atỳj ajte Aprãw xwỳ pupu? Pom nee cormã ana caku te xĩncwẽnta nare ita? Ne cormã atuwre, nõ na mã ca ajte ate Aprãw xwỳ pupun na amji jarẽ? — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mã Jeju me cumã: — He wa ha ampeaj kam me amã amji jarẽ. Pê wa ramã Aprãw pỳm xwỳjrea na apu ipa, ne cormã apu ipa rohnỳtti mã — hane. ");
INSERT INTO ram_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mã Juta catêjê te mempar, ne caxuw kẽn to me amji tỳj, cute me to kam hũcapêr, ne to mehcuran prãmte. Ampo na? Cupê Pahpãm pyràac ne rỳ pêa mã mam ipa rohnỳtti mã na cute amji jarẽn, na ri kẽn to amehcuran prãm. Mã me cupê Jeju pimxur ne ma Pahpãm jũrkwa pê cator ne tẽ. ");
INSERT INTO ram_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ne Jeju cormã mõr kwỳa kam, cute jũm to tũam na ihpỳm ata pupun. ");
INSERT INTO ram_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wa me ipê ihkôt me ipa catêjê te ahna mehcukij, ne me cumã: — Me ijõ Pahhi, ampo na mã pê hũmre ita into tũm ita na ihpỳm? Xà pê ajkĩ ihkên xà nõ to jahpan xà na mã cute hajỹr? Nare, xà ajkĩ hũm me inxi te ihkên xà nõ ton jahpan xà na mã into tũam na ihpỳm? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mã Jeju te me ipar ne me imã: — Nee mã ihkên nõ cwỳrjapê into tũm nare, ne nee mã hũm me inxi kên nõ cwỳrjapê cute hajỹr nare. Ampo na ri into tũm? He Pahpãm te hũmre ita kôt carôt tỳjti to ipipẽ to prãm to ri, cute to into tũm. ");
INSERT INTO ram_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pom hãn ne ihtỳj amcro kam me hàpên xà to me hàpên to me ipa, ne caxwari nee me hàpên nare. Ita jĩkjê na mã ite hajỹar. Na wa ha cormã ita ri pjê kam apu imõr reria mã itỳj, por cute ajpên ikujahêc ata mã, apu ijàpên to ipa. Ne wa ha ma jũ caxuw hacpỹ mã tẽ, ne nee hipêr ita ri cumã ijàpên nare. ");
INSERT INTO ram_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne pom pyt me parĩt xà caxuw me pamã pjê cujro, cu me rĩt, ne me ampo pupu ne me hahkre pej, ita jĩkjê na mã ipê me cumã Inxũ te amji kam hapac xà cunea to hahkre catê, mãr quê mehcunea me hahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hõ, cute ita jarẽn to hajỹr jirô pê mã ri cute pjê kam harcô mẽn, ne to pjê to incrire ne to ihtô, ne to carẽc ne cumã into na to ihtẽm, ne cumã harkwa to: ");
INSERT INTO ram_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","— Tẽ ne Kujahêc jõ cô kam akuc cuhhõ — hajỹr. Mã into tũm ata te mõr ne ihkuc cuhhõn, ne hacpỹ ne amji jaxàr, ne ramã ampo cunea pupun to mõ. ");
INSERT INTO ram_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mã cahi na mehkrĩ catêjê me, hàhwỳr na cute me hõmpun pejtu atajê te me hõmpun, ne ahna me ajpẽn cukij to: — Xà into tũm ihkrĩ ne me pahna ahwỳ ata mã? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mã mehkwỳ me cumã: — He taa mã ri! — hane. Mã mehkwỳ me cumã: — Quê nare! Taa mã nare! — hane. Mã mehkwỳ me cumã: — He mã ajte cupê hũràcti — hane. Mã me cumã amji jarẽn to: — He pa wa! — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mã cute mehcukij ne me cumã: — Ne mẽr jũ mã mã ate ne atỳj rĩt? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mã me cumã: — He jũm japrỳ te Jeju ata te ri harcô to pjê incrire ne carẽc na ton, ne ito na imã to ihtẽm ne imã: “Tẽ ne Kujahêc jõ cô kam ca akuc cuhhõ” hane. Wa ma mõ ne ite ikuc cuhhõn, ne amji jaxàr, ne ramã ampo cunea pupun to imõr pyrentu — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mã ahna mehcukij ne me cumã: — Jõ ri mõrmõ jũm xũmre ita apu mõ? — hane. Mã me cumã: — Pỳpỹn — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mã ma me cupê Parixêw catêjê wỳr, por pê mam into tũm ata to me mõ. ");
INSERT INTO ram_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ne por pê amcro nõ na Jeju carẽc to ihtô, ne hũmre into tũm ata na to tẽ, ne hacpỹa mã cumã irĩt to impej jõ amcro ata kam pê mehkôt xà jõ amcro. ");
INSERT INTO ram_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mã Parixêw catêjê kwỳ te ahna mehcukij ne me cumã: — Jũ mã mã cute aton ne acaprãr? — hajỹr. Mã me cumã: — Pjê kam cute harcô mẽn ne to carẽc to ihtô, ne ito na imã to ihtẽm, wa ma tẽ ne ite ihcuhhõn ne irĩt pej pyrentu — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mã Parixêw catêjê kwỳ ajpẽn mã me harẽn to: — Por jũm te ita ton ata pê nee Pahpãm tekjê nare. Xà ajkĩ Pahpãm jarkwa kôt mã cute hàpên xà ita to hajỹr? Ne mẽr ampo na mã nee me pahkôt xà jõ amcro ita pupun, ne amji mã hũpa nare, ne ihtỳj apu ahna apê? — hane. Mã mehkwỳa nõ te me cumã harẽn to: — Xà quê ajkĩ jũm kêanre ata ihtỳj carôat to ampo pihho catia pejti atajê nõ ton to hane? — hajỹr. Ne ajpẽn mã me harẽn ita cwỳrjapê cute amji to me ipicapôn. ");
INSERT INTO ram_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mã hipêr Parixêw catêjê atajê te ahna mehcukij ne me cumã: — Ca ate cute amã ato tũm caprãr na amji jarẽn, nejũ mã mõrmõ ca to amji kam gapac to? — hajỹr. Mã me cumã: — Imã cupê Pahpãm jarkwa to ihcakôc catêjê nõa ri — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mã Juta catêjê jõ pahhi kwỳ te nee amji mã, jũm te into tũm caprãr, mã hacpỹa mã irĩt na, amji mã me to hajỹr nare. Cwỳrjapê ri cute hũm me inxi na me hàhwỳr, cute ahna mehcukij prãmte. ");
INSERT INTO ram_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mã hỹrmã me cator, mã cute ahna mehcukij to: — Xà me akra mã ita? Pê ca into tũm ita na ihpỳm na me imã harẽ, nõ na mã ajte ihtỳj rĩt? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mã hũm me inxi atajê me cumã: — Wa cupê me ikra na ite me hahkre pej, ne pê into tũam na ihpỳm. ");
INSERT INTO ram_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ne pom jũm te caprãr, mã hacpỹa mã irĩt ita na ri, me ipê hahkre kêatre. Ne ramã ihkàhtu. Mehcukij, quê ha taa me amã amji jarẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ampo na pê hũm me inxi me cumã harẽn to hane? Nee mã ampo na nare. Quê ha jũm te Jeju pê, por pê Crixtô to Pahpãm awjahkre ata jarẽn pejti to harẽn na, quê ha ma cute me cuprõn xà pê me jũm cator, quê ha jũ caxuw hacpỹ ne amji jaxàr nare na, cute me hahkre pej. Na ri nee me kam mare mã me cumã Jeju pê me pahkritxwỳ jarẽn xà impejti nõ jarẽn nare. ");
INSERT INTO ram_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Cwỳrjapê pê me hũpate hũm me inxi me cumã harẽn to: — Ramã ihkàhtu, mehcukij, quê ha taa me amã amji jarẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ne hipêr cute me hũmre into tũm ne hacpỹa mã irĩt ata na hàhwỳr, ne me cumã: — Me imã ahêj jicu ne Pahpãm kam mare mã ampeaj kam me imã gũjarẽn na amji to. Ampo na? He wa ite me Jeju kêanre na me hahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mã into tũm ne hacpỹa mã irĩt ata me cumã: — Pỳpỹn, ipê Jeju kêanre ita na hahkre kêatre, ne ampo pijakrut ita na ri imã amji jahkre pej he, mam ito tũm, newa itỳj ita caxuw rĩt — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mã hacpỹ ma mã cute mehcukij to: — Jũ mã ri cute aton ne amã ato tũm ita to impej? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mã hipêr me cumã: — Wa ite ramã me amã amji jarẽn, ca ma ame ipar caca. Ne mẽr ampo caxuw mã ca hipêr ahna me icukij? Xà ca ha ajkĩ hanea ne amji to ihkôt me apa catêjê na me amã amji to prãm? — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mã cute me hũn kam ihtẽm, ne me cumã: — He apêa ri ihkôt apa catê, ne me ipê ri Mojxe xwỳ te amji kam hapac xà kôt me ipa catêjê. ");
INSERT INTO ram_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ne wa ite me Pahpãm te Mojxe xwỳ mã ihcakôc, ne cumã ampo to hahkre na me hahkre pej. Ne jũm xũmre ita, wa nee ite jũ rũm cator na me hahkre pej nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mã me cumã: — Pỳhàpà! Xãmte me apê jũ rũm cator xà ita na hahkre kêatre? Cakrô mã ihtỳj cute icaprãr, wa hacpỹa mã itỳj rĩt. ");
INSERT INTO ram_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","He me pahcunea mã Pahpãm te mehkên catêjê impar nare na me pamã hahkre pej. Ne por amji mã me Pahpãm cupa, ne me cumã, cute ampo na ihprãmti xà ton to me ipa atajê ri, ihtỳj quêt me kampa. ");
INSERT INTO ram_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ne cu rỳ jũ caxuw pjê te amji ton pê mã, me pahnõ te jũm te jũm to tũam na ihpỳm ata caprãr na me harẽn par nare. Mã ihtỳj Jeju te icaprãr, ne imã ito to impej. ");
INSERT INTO ram_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Xà quê ajkĩ Pahpãm ihkujahêc nare, quê ihtỳj ajkĩ ampo itajê nõ to? Hãpà, ne imãa ampeaj kam ri Pahpãm te ihkujahêc — hane. ");
INSERT INTO ram_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mã cute mempar, ne me cumã harkwa to: — Pê ca apỳm pê akên ton kam tẽ, nõ na mã ca ajte cormã me ipê pahhi catêjê mã ampo to hahkre prãm? Me ipê ahna ihkaj na! — hajỹr. Ne ma cute põ mã cute me cuprõn xà jũrkwa pê me into tũm ata to cator. Cwỳrjapê quê ha nee jũ caxuw hipêr cute me cuprõn xà ata mã hàr nare. ");
INSERT INTO ram_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mã Jeju te, cute me cuprõn xà jũrkwa pê põ mã me hũmre ata cator na harẽn par. Na ri apu hapê ne ahna cator ne cute ihcukij to: — Xà ca ha ajkĩ atỳj Pahpãm kra to amji mã ahimpej? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mã cute Jeju mã harkwa to: — Ijõ Pahhi, jũm pê mã Pahpãm kra ita? Wa itỳj amji mã to ihimpej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mã Jeju te cumã amji jarẽn to: — Pom ca ipupu ita! He pa wa amã icakôc — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mã hũmre ata te Jeju kĩnte amji crire na Jeju mã amji jarẽn prãm to, cuna mã ihkõn krã na hỹr, ne cumã: — Wa ha itỳj ato amji mã ihimpej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mã Jeju te cumã hũjarẽn to: — He wa nee mento tũm caprãr to pit mã pjê ita wỳr icator nare. Ne ite mempej te amji kam me hapac xà me, mehkên te amji kam me hapac xà pupun prãmte wa icator. Ne wa itỳj mento tũm caprã, mãr quê hacpỹa mã me irĩt pej, ne ihtỳj me ampo cunea pupun to me ipa. Ita jĩkjê na mã wa itỳj me cumã Pahpãm te amji kam hapac xà to hahkre to ipa, mãr quê me hahkre pej, ne ihtỳj ihkôt me ipa. Mã mehkwỳ ihtỳj, cute ramã me Pahpãm jarkwa cunea jahkre pej na ame amji cãmjĩ, atajê pê ihhêj rũm mento tũm pyràac. Ampo na? He nee cormã me cumã Pahpãm jarkwa jahkre pej nare, na wa ite me cuna mã icakôc to prãm to, wa mehwỳr icator — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mã curi me cahê na Parixêw catêjê kwỳ ihcuhhê atajê te me Jeju cukij to: — Pỳhàpà! Xà mõrmõ ajkĩ hanea ne me ipê mento tũam pyràac, ne me ipê Pahpãm jarkwa jahkre kêatre? Hãpà! He wa itỳj ite me Pahpãm jarkwa jahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mã Jeju me cumã: — Quê ha jũm to tũm amji jarẽn to: “Me anõ itehcajpa, jũ wỳr wa ito tũm ita kam ahte mõ” hane, ne me kam mare mã kre kam ihpỳm na, quê ha nee taa amji curê caxàr nare. Ne me apê Parixêw catêjê te nee me hajỹr nare. Me apê jũm to tũm te amji jahkre kêatre ata pyràac. Ne ihtỳj irĩt na amji jarẽ, ne ma jũm te ihtehcajpar na apu ihcaca, ne amjia kôt kre kam ihpỳm ata pyràac. Ne ca me amji jarẽn to: “Ramã me imã Pahpãm jahkre pej” hajỹr cakrô, cormã me apê Pahpãm jahkre kêatre. Cwỳrjapê ca rỳ ate me amji curê caxàr ne me akên mã me axàr — hane. ");
INSERT INTO ram_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mã Jeju te hipêr mehcunea mã harẽn to: — Wa ha me amã ijũjarẽn xà nõ ita jarẽ. Ca ha ihkôat me ijahkre pej. He Pahpãm himpej xà ata pê ihhêj rũm kwỳc kam, cute me carà cahàcre hôhti jamãr xà ata pyràac. Ne hỹrmã harkwa pyxit peaj. Ne por quê ha jũm nee carà cahàcre jõ kwỳc jarkwa na hàr nare, ne ihtỳj intoj ne hàr ata pê ri me hàhkĩj xi, ne cupê me hàprêa kam me cupê ampo cwỳr catê. ");
INSERT INTO ram_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ne por quê ha harkwa na axà ata pê ri carà cahàcre hôhti jamãr catê. ");
INSERT INTO ram_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Quê ha harkwa jihê rẽn catê caxwãm pê jỹ ata ihtỳj cumã harkwa jihê mẽ, quê ha axà ne hõ carà cahàc mã haprỳa na akij, quê ha ihtỳj hõkre kampa. ");
INSERT INTO ram_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ne hỹrmã pra, quê ha ma kwỳc pê to cato, põ mã, ne ma mam cumã mõ, quê ha ihtỳj ihkôt ipa. Ampo na? Ihtỳj hõkre kampa na ri. ");
INSERT INTO ram_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ne jũ wỳr quê ajteare mã jũm kôt pra. Quê ha ma cama jũ kam cupê pra. Ampo na? Jũ wỳr quê cute jũm cahkrit jõkre par nare ne hahkre pej nare kam ihkôt pra — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Hõ, Jeju te me cumã hũjarẽn xà ita to hajỹr. Mã nee cute mempar ne me hahkre pej nare cormã, por cute me cumã ampo jarẽn xà ata na. ");
INSERT INTO ram_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Cwỳrjapê ri hipêr Jeju te me cumã hũjarẽn xà ita kôt harẽn to impej ne me cumã: — Wa ampeaj kam me amã amji jarẽ. He ipê, por harkwa na carà cahàcre incjêj xà ata pyràac. Cwỳrjapê wa ha nee me hỹrmã me curê xwỳn cjêj na me hamãr, quê ha me hỹrmã mencjêj nare. ");
INSERT INTO ram_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","— Ne por quê ha icumam ramã me pra atajê pê ri me hàhkĩj xi, ne me cupê me hàprêa kam me cupê ampo cwỳr catê, mã me ikwỳ pê carà cahàcre pyràc atajê te nee me hõkre par nare. ");
INSERT INTO ram_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ỹhỹ, ipê Pahpãm te me hamãr xà ata wỳr harkwa. Ne quê ha jũm ina Pahpãm wỳr axà ata, quê ha ampo kên cunea pê amji pytà. Quê ha cupê hõ parxa pyràc ne ihtỳj acjêj ne hapôj, ne apu hàpàn to ipa. ");
INSERT INTO ram_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ne ikĩnte me hàhkĩj xi atajê quê ha cama me hàhkĩj me, cute me carà cahàcre hôhti curan ne me to hamre to prãm to, quê ha hỹrmã me pra. Ita jĩkjê na mã me ikwỳ curê xwỳn me hỹrmã pra, cute me to kên prãmte. Ne pa, wa quêt ajpên mehwỳr icator, cute catyt kam amji to me ipijapar xà impejti cunea to me amji to ipijapar prãm to. ");
INSERT INTO ram_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","— Ipê me ikwỳ pê carà cahàcre hôhti jamãr catê impeaj ata pyràc. Ne ipê cumã cute amji kam hapac xà jõr catê, na wa itỳj me hũtàr prãmte ityc to prãm. ");
INSERT INTO ram_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ne por ihpore na pit mã me hàpên catêjê atajê ikĩnte nee me carà cahàcre jamãr to impejti nare. Ampo na? Carà cahàcti hôhti atajê pê nee me hõ tekjê nare. Cwỳrjapê quê ha rop cahàc jàprêhti nõ ihwỳr cato ne apu cucrà, quê ha cute me hamãr to kêanre atajê hũpate nee me to amji japackre nare, ne me cumã hikra, ne ma ame pra. Quê ha pea rop cahàcti jàprêhti ata carà cahàcre hôhti atajê kam tẽ, ne ihtỳj apu cucrà ne ihcura. ");
INSERT INTO ram_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ampo na? Ihpore na pit mã me apê, na ri nee me cumã carà cahàcre hôhti jamãr to impej prãm nare. ");
INSERT INTO ram_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","— Ne ipê carà cahàcre hôhti jamãr catê impejti ata pyràac na Inxũ mã ijahkre pej, ne hanea ne imã Inxũ jahkre pej. Ita jĩkjê na mã ite hajỹar, ne imã me ikwỳ pê carà cahàcre jahkre pej, ne hanea ne me cumã ijahkre pej. Na wa itỳj me hamãr to impejti to prãm to ityc to prãm. ");
INSERT INTO ram_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ne mehkwỳ pê itekjê atajê, nee ite me hamãr xà ita mã cormã mencjêj nare. Na wa itỳj hanea ne ajpên amji wỳr me to ijàhtêp prãm. Na wa ha me cumã akij, quê ha me ijõkre kampa, ne mehkwỳ me ina me cuprõ, ne ajkam me pyxit peaj. Na wa ha ipê me hamãr catê pyxit peaj ata. ");
INSERT INTO ram_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","— Ne pê Inxũ ramã imã harkwa to: “Ca ha ate jũm te acuran na hamãr nare na, quê ha nee acuran nare. Nãmri ca ha ate cute acuran na amji na hamãr na, quê ha ihtỳj acura, ca ha atỳj hacpỹa mã atĩr. Xà caxuw wa ite amã icarôt cunea jõr, ne ate hajỹr xà na ri imã ato prãm” hane. Wa ite Inxũ jarkwa kôt hajỹr, cwỳrjapê ri cumã ikĩn — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mã Juta catêjê te me ita par, ne hipêr amji to me ipicapôn. ");
INSERT INTO ram_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ne me hàhtôa ne ajpẽn mã me harẽn to: — Apu into kam waj! Ne kam ampo carõ kên! Ampo kôt mã ca, cute me amã ampo jarẽn xà itajê na ame kampa? — hane. ");
INSERT INTO ram_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mã mehkwỳ ajpẽn mã me harẽn to: — Jũ wỳr quê jũm kam ampo carõ kên quê ihcakôc xà to hane! Xà quê ajkĩ jũm kam ampo carõ kên quê ihtỳj jũm to tũm caprãr to hane? — hane. ");
INSERT INTO ram_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ne pê hacpỹa mã Pahpãm jũrkwa to impej xà jõ amji kĩn na, Jeju Krĩpinkrên kam apu mõ, ta jõ putwrỳa kam. ");
INSERT INTO ram_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pê Jeju Pahpãm to amji kam me hapac xà jũrkwa jarkwa mã mencjêj xà cwỳrpê hàmkrã xà japrỳ te Xarômãw Jõ Amkrã ata krac ri apu mõ. ");
INSERT INTO ram_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mã Juta catêjê kwỳ te Jeju na me cuprõn, ne ahna me ipixêr, ne cute mehcukij to: — Ne rỳ pêa mã wa tee ate me imã amji jarẽn, wa ite me apar pej japê tee me akampa. Ne jũ caxuw ca ha me imã amji jarẽn to impej, wa me akampa ne me gahkre pej to impej? Ne me imã amji jarẽ, xà ampeaj kam ri ajkĩ apê Crixtô pê, por pê Pahpãm me imã ato awjahkre ata mã ca? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mã Jeju te me cumã amji jarẽn to: — Wa ite ramã me amã amji jarẽn, ca nee ate ijũjarẽn xà ata kôt amji mã ito me ahimpej nare. Ne pom wa Inxũ carôt kôt ijàpên xà pihho pejti ton to ipa itajê, hanea ne ihtỳj ito awjarẽ. ");
INSERT INTO ram_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ca nee ajte ikam me gapac nare. Ampo na? Me apê me ikwỳ nare, na ca nee me ikam gapac nare. ");
INSERT INTO ram_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ne quêt me ikwỳ atajê pê carà cahàcre hôhti atajê pyràac, ne ipê me hamãr catê impejti ata pyràac. Na wa ite ramã me ikwỳ pê me ijõ parxa kwỳ pupun pejtu, mã ihtỳj me ijõkre kampa, ne ma ikôt me ipa. ");
INSERT INTO ram_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Cwỳrjapê wa ha nee ampo te me to hamre na me hamãr nare, quê ha Pahpãm cahê na amji to me ipijapar rohnỳtti mã, ne nee jũ caxuw Inxũ pê me ipictor nare. Ne jũ wỳr quê jũ caxuw ijũhkra pê jũm mehnõ capa. ");
INSERT INTO ram_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","Ampo na? Por Inxũ te imã me hõr ata ri quêt mehcunea carôt jirôa pê carôt tỳj, cwỳrjapê quê nee jũm hũhkra kam cupê jũm caxàr nare. Ne taa mã pê imã icarôt ita gõ, na wa me ipipẽan. Ne quê ha nee jũ caxuw jũm ijũhkra kam ipê jũm caxàr nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mã hacpỹ ma mã Juta catêjê kwỳ te kẽn to me amji tỳj, cute me to capêr, ne me to ihcuran prãmte. ");
INSERT INTO ram_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mã Jeju te me cumã harkwa to: — Wa ite me akam mare mã icarôat to ampo pejti pihho jàhtôa ne ton, por Inxũ te ton xà na imã harkwa atajêa na. Ne mẽr ampo pejti itajê nõ incwỳrjapê mã, ca kẽn to ame ikam gũcapêr prãm? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mã Juta catêjê te me cumã: — Wa nee ampo pejti itajê nõ incwỳrjapê apu kẽn to me acapêr prãm nare, ne pom ca apu apê Pahpãm na amji to acakôc, ita to ca ramã apu Pahpãm mãn kêanre. Ne ihkĩnte apê me hũmrea to me hũmre, nõ na mã ca ajte apu amji to Pahpãm to apa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Mã Jeju te me cumã harkwa to: — Pê Pahpãm me panquêtjê mã cute amji kam hapac xà me harkwa gõ, pê me amã ihkàhhôc kam ihhôc. Cu me pahcunea te ihkàhhôc ita kam ihhôc itajê nõ te ihhêj xi xà nõ jarẽn nare na me pamã hahkre pej. Ne catyt kam ampeaj kam hũjarẽn rohnỳtti mã. Ne pê Pahpãm me panquêtjê te me kam hapac xà caxuw me cumã ihkàhhôc ita gõ, ne me cumã: “Me apê me ikraa to me ikra, cwỳrjapê ri me ate amji kam gapac xà me, ite amji kam ijapac xà pipẽan” hane. ");
INSERT INTO ram_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","— Ne pa nare, pê Pahpãm icapi ne ajpên ikujate, ite ate me harkwa ita par na me atehcajpar xà caxuw. Cwỳrjapê ri me panquêtjê jirôa pê icati. Na wa itỳj ipê Pahpãm kra impeaj na amji to icakôc. Ne mẽr ampo na mã ca ame ikam acryc? ");
INSERT INTO ram_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nãmri wa ha ite Inxũ jàpên xà ton nare na, ca ha nee me ikam gapac nare. ");
INSERT INTO ram_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nãmri wa ha ite hàpên xà ton na, ca ha atỳj ite Inxũ Cati carôt kôt jàpên xà pihho ton ata kôt me ikampa. Ca ha ate ite me amã ijũjarẽn xà to ijũjarẽn ita na me ikam gapac nare cakrô, ca ha atỳj, pom wa hàpên xà to apê itajê kôt me ikampa. Ne ihkôat ca ha Inxũ me ipipẽan, ne me ipyxit peaj na me ijahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mã hacpỹ ma mã amehpro prãm cakrô, mã ma me hũhkra pê cator. ");
INSERT INTO ram_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ne ma Jeju te amji jaxàr, Côpijapjêr jõ cô jĩkjê wỳr, mãr pê curi Jowãw xwỳ ajco cô kam mehcumrã ata ri. Ne curia apu ipa. ");
INSERT INTO ram_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mã me hàhtôa ne hỹrmã me ipa, ne ajpẽn mã me harẽn to: — Pê Jowãw xwỳ pê me cumrãr catê ata, nee Pahpãm carôt kôt hàpên xà pihho pejti te hajỹrjê nõ ton nare cakrô, pê ihcunea na ihtỳj Jeju jarẽn xà to harẽ atajê, ampeaj kam pê — hane. ");
INSERT INTO ram_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mã curi me hàhtôa ne cute me Jeju kam hapac, ne amji mã me to ihhimpej to me ipa. ");
INSERT INTO ram_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pê hũmre nõ ita japrỳ te Raxaro ita xà. Ne pê mehkjêjê pê Marij me Marta mea mã krĩ jacot japrỳ te Mehkênpupunxà jõ krĩ ata kam mehkrĩ. ");
INSERT INTO ram_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ne Marij ata pê amcro ata na Jeju par kam ampo cacô cuxwati ata jaxwỳ, ne ihkĩa to cumã incrà. ");
INSERT INTO ram_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mã Raxaro kjêjê cahãj itajê te Jeju mã hũjarẽn to hajỹr xà ata kujahêc he: — Me ijõ Pahhi, por amã gõ ikwỳ nõ kĩnti ata xà! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mã Jeju jũpar ne cute harkwa to: — Quê ha nee hicu xà kam hà ita ihcuran nare. Ne hà ata kôt quê ha me hàhtôa ne quêt ipê Pahpãm kra carôt tỳjti na me ijahkre pej. Ne hà ata kôt quê ha me hàhtôa ne quêt me Pahpãm carôt tỳjti ata pupu ne amji mã me hũpa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ne pê ihtỳj Jeju mã Marta me ihtõj Marij ata kĩn, ne hanea ne cumã Raxaro kĩn. ");
INSERT INTO ram_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mã Jeju te Raxaro xà na harẽn par cakrô, curia hàhhuc xà ata kam apu mõ, ne apu ihkên, ne ahna amcro pijakrut. ");
INSERT INTO ram_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jirô pê mã ri cute me ipê ihkôt me ipa catêjê mã harkwa to: — Hacme, hacpỹ mã Juta jõ pjê wỳr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wa me cumã: — Me ijõ Pahhi, mãr curmã curi Krĩpinkrên catêjê kẽn to ame acapêr prãm ta? Ca ajte ramã hacpỹa mã amji jaxàr prãm? — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Mã Jeju me imã: — Nee ita na cute imã jũ mãn nare, ne jũ wỳr quê jũ na me ito. Pom ca me pyt pupu, mã hapôj ne ma acjêj mã caxwa ata jĩkjê na ri ite hajỹar. Ne wa cormã ite ijàpên xà jipêj nare kam, quê nee jũ na me iton nare. Ne hanea ne cu caxwari me papa, ne pahtỳj me papihur to ame papa. Ne pom pyt me pamã ahcujro, cu kam ame papa, ne me pamã papa xà jahkre pej, ne nee ame papihur, ne me pahkên mã me pancjêj nare. Ita jĩkjê na mã Inxũ te ito hajỹar. Mã Pahpãm te ikrã kam imã ite amji jahkre pej jõr, cwỳrjapê ri imã ampo te amji kam hapac xà cunea jahkre pej, na wa nee ikên mã icjêj nare. ");
INSERT INTO ram_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","— Me pajõ ikwỳ nõ Raxaro ramã nõ ne apu gõr cakrô, wa ha itỳj ihcujrõ ne hỹr — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na wa me cumã: — Pahhi, quê ha cute nõ ne hõt na, quêt taa nõ ne gõr, ne amji cajpẽ. Ampo na? He cormã me hỹrmã me pahcator xà ita ampỳa mã — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ne pê tee Jeju ame imã ramã Raxaro tyc na harẽn to hahkre, na wa itỳj amji mã me to hõtxwa mã hõt na amji mã ame to hane! ");
INSERT INTO ram_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Mã Jeju hirãa pê me imã: — Ramã Raxaro tyc, ne me acwỳrjapêa ri, ampeaj kam hũrên ijakry. Quêt taa ty, wa nee curi apu imõr nare na ri ihtyc. Ne ihkôat ca ha atỳj ito amji mã me ahimpej. Hacme, ne me hõmpu — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mã Tome ita me imã: — Hacme, me pajõ Pahhi kôt, quê cuxà me pajipej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mã ramã cute kẽn kre kam me Raxaro jarêt na amcro te cwat, wa Jeju me, me icator. ");
INSERT INTO ram_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mã Mehkênpupunxà jõ krĩ ata ri rec pyxit jĩkjê kam xa, Krĩpinkrên wỳr. ");
INSERT INTO ram_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Cwỳrjapê pê Juta catêjê hàhtôa ne me cato, cute me Marta me Marij pupun, ne me cupê hũjapê cutor prãmte. ");
INSERT INTO ram_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mã Marta te Jeju te ajpên hàhtêp to mõr na harẽn par, ne ma hỹrmã tẽ ne cute pry kôt ihcajpar. Pê Marij curia ikre kam jỹ. ");
INSERT INTO ram_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mã Marta Jeju mã: — Ijõ Pahhi, ca ha ita ri apu mõ na mã, quê ha nee ikjê ipê ihtyc nare, ne ramã ihtyc, ca hakàn pê acator. ");
INSERT INTO ram_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Cakrô ca ha ahnaa Pahpãm na ahwỳ, quê ha amã ate ampo cunea na gàhwỳr xà atajê gõ — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mã Jeju cumã: — Quê ha akjê ihtỳj hacpỹa mã me amã ihtĩr — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mã Marta cumã: — Quê ha ampo cunea jamre xà ata jõ amcro kam ihtỳj hacpỹa mã ihtĩr na, imã hahkre pej — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mã Jeju cumã: — He ampeaj kam ri, ipê hacpỹa mã mehtyc to ihtĩr catê. Na quê ha jũm te ihkên ton to ipa na, quê ha ramã Pahpãm mãa jũm ata tyc pyràc. Cakrô quê ha ito amji mã ihhimpej na, wa ha cumã cute amji kam hapac xà tuw pejti gõ, quê ha Pahpãm mã jũm ita ihtĩr rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne por jũm ito amji mã ihhimpej to ipa ata, quê ha nee jũm ata ihtyc ne ihtyc tu nare. Ne ca? Xà ca ha ajkĩ pijamã ijũjarẽn xà ita to amji mã ahimpej? — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mã cumã: — Ỹhỹ ijõ Pahhi, wa itỳj apê Pahpãm kraa to ihkra na amji mã ato hane, ne imãa apê Crixtô pê, por pê Pahpãm pjê ita kam ate me ito ahimpej xà na ato awjahkre ata mã ca — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jirô pê mã ri Marta te amji jaxàr ne ihtõj mã hàkjêr ne kyre pê cumã hũjarẽn to: — Pajõ Pahhi cator ne cute ana hàhwỳr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mã Marij te harẽn par, ne hãm pyrentu, ne ma Jeju wỳr tẽ. ");
INSERT INTO ram_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pê nee cormã krĩ mã hàr nare, ne cormã Marta ihcajpar xà ata kam, curia pry kam apu mõ. ");
INSERT INTO ram_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ne pê ramã hõtpê Juta catêjê kwỳ ikre kam ame ipa, cute me Marij jũjapê tête me cumãn prãmte. Ne cute me Marij xãm na me hõmpun, mã hũjarêan kam hãm ne ma tẽ, mã ma ihkôt me pra. Ne pê ihtỳj cute kre wỳr ihtẽm ne kam apu incwỳr na amji mã me to hane. ");
INSERT INTO ram_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mã Marij Jeju wỳr cator, por curi xa ata ri, ne ihpar cahê na ihkõn krã na hỹr, ne cumã: — Ijõ Pahhi, ca ha ita ri apu mõ na mã, quê ha nee ikjê ipê ihtyc nare, ne ramã ihtyc, ca hakàn pê acator — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mã Jeju te Marij cwỳr na hõmpun. Ne hanea ne cute Juta catêjê kwỳ incwỳr na me hõmpun. Ne hõtpê ahna incrycre, ne cumã amji kĩn nare. ");
INSERT INTO ram_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mã cute mehcukij, ne me cumã: — Mẽr jõ ri ca ate me hir? — hajỹr. Mã Marij cumã: — Ajpên mõ ne hõmpu — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mã Jeju te ahna kẽn kre pupun ne apu kam amrã. ");
INSERT INTO ram_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mã Juta catêjê me ajpẽn mã: — Me hõmpu he, cumã Raxaro kĩan to ihkĩn na mã apu kam amrã! — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mã mehkwỳ me harẽn to: — Hõtpê cute into tũm caprãr, ne quê rỳ mã Raxaro tyc xwỳjrea na jũ na to, quê ha nee ihtyc nare. Ne hamre ramã ihtyc, ne jũ mã mã quê ha to? — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mã hipêr ahna Jeju crycre, ne cumã amji kĩn nare, mã ma kẽn kre wỳr tẽ, ne cute kẽn kre jarkwa pupun, mã kẽn nõa te kre ata jarkwa jihê, Juta catêjê te amji jarêt xà ata kôt. ");
INSERT INTO ram_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mã cute kre na harkwa hyr to: — Me kẽn te kre jarkwa jihê ita capa — hajỹr. Mã Raxaro kjê pê Marta ita te cumã harẽn to: — Ijõ Pahhi, ramã harêt na amcro te cwat ita kam ramã ihkro — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mã Jeju cumã: — Xà wa ite curmã me amã amji jarẽn to: “Ca ha ate me ipar na, ca ha atỳj me Pahpãm carôt pupu” hajỹr nare? — hane. ");
INSERT INTO ram_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mã cute me kẽn kre ata jihê mẽn. Mã Jeju kàj mã irĩt ne cute Hũm mã harkwa to: — Inxũ, wa hõtpê amã icakôc, ca atỳj ikampa pyrên ri ijakry. ");
INSERT INTO ram_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ampo na mã wa ite icakôc xà ita ton? He me hàhtôti atajê mã wa ite icakôc xà ita ton, mã cute me ipar. Ne ate ikujahêc na me ijahkre pej to prãm to wa ite me cumã hajỹr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ne cute hũjarẽn to hajỹr jirô pê mã ri cute Raxaro mã hàkjêr to: — Ikwỳ nõ Raxaro, ajpên põ mã acato! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mã por Raxaro tyc ata tĩr pyrentu. Mã cupẽhkà te ihpar me hũhkra cunea cajpre ita kam, jũ wỳr quê mõr pej, na ri ajpên põ mã to amji rẽn to mõ. Mã hanea ne ihkuc na hê. Mã Jeju te ame hõmpu atajê mã harkwa to: — Intête me cupẽhkà te ihcupu ata pô, quê ihtỳj tẽ — hajỹr. Mã cupê ipôt par, mã ma põ mã tẽ. ");
INSERT INTO ram_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mã Juta catêjê jàhtôa ne me Marij pupun to mõ atajê, te me Jeju te Inxũ carôt kôt hàpên xà pihho pejti ton ata na me hõmpun, ne ihtỳj amji mã me to ihhimpej pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ne mehkwỳ te nee me hajỹr nare, ne ma cute me amji jacjên, ne Parixêw catêjê mã, Jeju te ampo ton xà atajê na harẽn. ");
INSERT INTO ram_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mã Parixêw catêjê me, cute Pahpãm mã mehcajrẽn catêjê jõ pahhi me, cute me cuprõn, prohti kam catêjê me, ne cute me ajpẽn par, ne me ajpẽn mã: — Ampo to mã cu ha ajte me? Nãmri jũm xũmre ita carôt catia to hàpên xà pihho pejti pit ton to mõ. ");
INSERT INTO ram_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Cu cama ahna me hamã, ne nee intête mehcahpêrkàr nare, quê ihtỳj me cumã ton to mõ, quê ha mehcunea ahna me hõmpu, ne me kampa, ne ihkôat me amji kampa. Quê ha Roman catêjê jõ pahhi me hõmpu, ne ihtỳj hacpỹa mã me pahna apkjê, ne me pahkam tẽ, ne me papê Pahpãm to amji kam me hapac xà jũrkwa pytà, ne ame pajõ krĩ to kêanre ne — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mã caku ata na Cajpa ata pê Pahpãm mã cute mehcajrẽn catêjê jõ pahhiti. Na ri cute harkwa to: — Pỳhàpà, ajte me acunea pê amji jahkre kêatre! ");
INSERT INTO ram_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ne imãa ite amji kam ijapac xà te hajỹr he. Quê ha jũm xũmre pyxit peaj ne ty, cu ha nee me pahcunea me pahtyc nare. Nãmri quê ha pyxit peaj te ihtyc nare na, cu ha me pahcunea me pahhi tu. Cwỳrjapê ri Jeju pyxit peaj ne ihtyc xà — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ne pê Cajpa ihcakôc xà ata kam, nee amjia kôt ihcakôc nare, Pahpãm pê cumã ihcakôc xà ita to hahkre. Ne pê cupê Pahpãm mã cute mehcajrẽn catêjê jõ pahhiti. Cwỳrjapê pê Jeju te Juta catêjê cunea incwỳrjapê ihtyc na, me cumã amji jarẽ. ");
INSERT INTO ram_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","He nee mã Juta catêjê incwỳrjapê pit mã ihtyc xà nare. Ne pjê cunea kam, mehcunea pê Pahpãm kra ame ipicràn atajê to cute cuprõn, ne me to pyxit peaj prãm to, quê ha ihtỳj ty. ");
INSERT INTO ram_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ne amcro ata kam cute me Jeju curan prãmte pê me cupê Juta catêjê jõ pahhi kwỳ cunea ahna me ajpẽn pa. ");
INSERT INTO ram_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Cwỳrjapê pê nee Jeju hirã pê ajco apu Juta jõ pjê kam ipa nare. Na wa ma, por põ na pire mã, pjê kam põ kam me hamreare ata wỳr Jeju me, me mõ, por Pĩxôhrôt jõ pjê ata wỳr, ne curia wa me ijàhhuc. ");
INSERT INTO ram_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ne pê ramã amcro incrêre me Hakren xà jõ amji kĩn wỳr. Pê amji kĩn ata xwỳjrea na Juta catêjê jàhtôa ne Krĩpinkrên wỳr me cato, cute ame ampo kên ton atajê to me hapac kêt, ne ame amji cũmpej. Ne amji kĩn ata na mempejti na ame ipa xà caxuw. ");
INSERT INTO ram_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne pê mehcunea ame Jeju japên to me ipa, ne ajco ahna ame ajpẽn cukij, Pahpãm to me amji kam me hapac xà jũrkwa kam. Ne me ajpẽn mã: — Pỳhàpà, mõrmõ quê ha ajkĩ ihtỳj ajpên Jeju amji kĩn ita wỳr mõ, nare, quê ha nee mõr nare? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Me Pahpãm mã cute mehcajrẽn catêjê jõ pahhi kwỳ me, me cupê Parixêw catêjê kwỳ me, cute me Jeju jaxàr na me ajpẽn par. Cwỳrjapê ri cute ahna me harkwa, quê jũ ri jũm hõmpu, ne uua ne me cumã harẽ, por jũ ri apu mõr xà ata ri. ");
INSERT INTO ram_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ne ramã me Hakren xà jõ amji kĩn wỳr amcro te xêj, wa ma Jeju me, Mehkênpupunxà jõ krĩ wỳr me mõ. Por pê curi hacpỹa mã Raxaro to ihtĩr mã ihkrĩ ata ri. ");
INSERT INTO ram_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mã cute Jeju te hacpỹa mã Raxaro to ihtĩr na me to amji japackre, ne amji mã me to catia to prãm to ri, cute me cumã hõ ton. Mã Marta apu mehtehcajpa, mã Raxaro me cahê na me hàpàn xà na jỹ. ");
INSERT INTO ram_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mã Marij te ampo cacô cuxwati ata japrỳ te nartô cacô te rit cahti na hajỹr ata pyr. Ne pê ampeaj kam nartô cacô ata na hĩ ahwỳ. Mã cute Jeju par kam haxwỳr, ne ahna haxwỳr partu ne cute to cumã ihpar cuhhõn, ne ihkĩa to cumã incrà, mã ikre cunea cuxwaa to cuxwa. ");
INSERT INTO ram_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mã me ikwỳa nõ pê Juta Carijot te cormã Jeju kên mã mẽn catê ata te harkwa to: ");
INSERT INTO ram_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","— Pom ampo cacô ita na ihpore jàhtô na cute xẽj crê, ne cupê caku pyxit jàpên xà jõ porea. Ne mẽr ampo na mã cama cute haxwỳr, ne nee cute ihpore na to hàhpan ne imã hõr, wa ite me cupê hamreare atajê mã hõr nare? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ampo na pê Juta Carijot ihcakôc xà ita to hane? Nee mã pê ampo na nare. Pê hàhkĩj xi, na pê harkwa ita to hane. Pê nee cute me cupê hamreare atajê tehcajpar prãmte harkwa ita to hajỹr nare. Pê ajco me cupê me hõ pore incjên xà cwa, ne ajco me cupê ihpore to ahkĩ na pê. Pê ramã hàhkĩj ita to amji pyràc tu. ");
INSERT INTO ram_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mã Jeju te cumã harkwa to: — Quêt taa Marij ito hane! Cute ijarêt xwỳjrea na ramã icuxwa, me panquêtjê te amji ton xàa kôt. ");
INSERT INTO ram_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ne me cupê hamreare atajê, quê ha hõtpê ame ipa me acahê na. Ne pa nare, wa ha nee ame acahê na imõr kam to icrà nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mã Juta catêjê jàhtôti atajê te me Jeju te Mehkênpupunxà jõ krĩ kam apu mõr na me harẽn par. Ne ma curi me cator. Ne nee pê Jeju pit wỳr me mõr nare, ne Raxaro me ajwar hỹrmã me mõ, por hacpỹa mã Jeju te to ihtĩr ata. ");
INSERT INTO ram_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mã hamre, Pahpãm mã cute mehcajrẽn catêjê jõ pahhi kwỳ te me ajpẽn par, ne hanea ne ihtỳj me Raxaro curan prãm. Ampo na? Nee mã ampo na nare. ");
INSERT INTO ram_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pê Juta catêjê jàhtôa ne Raxaro tĩr xà ata kôt, me hõ pahhi mã me hikra, ne Jeju to amji mã mehhimpej to me ipa na pê. ");
INSERT INTO ram_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ne amcro ata na, pê me hàhtôa ne me Hakren xà jõ amji kĩn na ame ipa. Ne cute me Krĩpinkrên wỳr Mehkênpupunxà jõ krĩ pĩn Jeju mõr na me harẽn par. ");
INSERT INTO ram_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ne cute me ampo hô pê crowràti hô pyràcti ita to me amji tỳj, ne ma hỹrmã me to pra, cute me to ihcajpar prãmte. Ne me to ihcajpar, ne me hakryte cama cumã ame to hàpêr to me ipa, ne ame cumã caràr to: — Pahpãm cati ne impej! Pahpãm ri me pahwỳr mõ! Pahpãm te amji japrỳa na me pahwỳr me pajõ Pahhiti kujahêc! Me imã Pahpãm te me pajõ pjê to ihhimpej na to prãm! — hane. ");
INSERT INTO ram_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mã Jeju cawrô cahàcre nõ ita na cator, ne kam hỹr ne to mõ. Por ahnaa rỳ pêa mã ramã Pahpãm jõ kàhhôc kam harẽn to: ");
INSERT INTO ram_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Krĩpinkrên pê Xijãw jõ hàpkàjti me, ca kam me akrĩ atajê, ca ha nee hipêr amji mã ame ampo cupa nare. Nãmri ramã ajpên me gõ Pahhiti cawrô cahàcre intuwre nõ kam hỹr ne to mõ he” hane, mã ahnaa. ");
INSERT INTO ram_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ne amcro ata kam pê wa nee me ipê ihkôt me ipa catêjê nõ ampo atajê nõ kam ijapac, ne hahkre pej nare. Mã Jeju tyc, ne hacpỹa mã ihtĩr, ne ma Pahpãm wỳr hàpir, wa cormã ite me ita to amji japackre, por ramã ampo te to hajỹr xà ata na Pahpãm jõ kàhhôc kam ahna ihhôc ata to. Na pê ihtỳj to hanea to hane. ");
INSERT INTO ram_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mã me hàhtôa ne Jeju kôt me mõ, mã me kam mare mã cute carôt tỳjti to Raxaro mã hàkjêr, ne hacpỹa mã to ihtĩr ata na, cute me hõmpun catêjê te ihtỳj me harẽn cràn. ");
INSERT INTO ram_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mã me hàhtôa te me harẽn par, na ri ma mehcajpar to me mõ. ");
INSERT INTO ram_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mã Parixêw catêjê kwỳ ajpẽn mã me harẽn to: — Me hõmpu he, wỳr cu ame amji mã hamã ne intête me cuta. Ne ramã pjê cunea pĩn mehcunea ihkôt ame ipa — hane. ");
INSERT INTO ram_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ne por Krĩpinkrên wỳr, amji kĩn wỳr me mõ atajê kôt hõtpê Crec jõ pjê catêjê kwỳ me mõ. ");
INSERT INTO ram_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Atajê ma me ikwỳa nõ japrỳ pê Pirip ata wỳr me pra. Ne Pirip ata pê Tep jõ krĩ kam Hĩpôjajo jõ pjê kam me xa atajê jõ xũmre nõ. Mã cute ahna me hàhwỳr, ne me cumã: — Jeju pupun prãmte wa me mõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mã Pirip hõ ikwỳ nõ Antre wỳr tẽ, ne cute cumã hũjarẽn, ne ma ajwar Jeju wỳr me mõ, ne me cumã: — Crec catêjê kwỳ cator, ne ame amã ihcakôc to prãm — hane. ");
INSERT INTO ram_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mã me cumã: — Ipê me Ahàkà, ne ipê, por pê côjkwa kam amji to incrire ne hũmrea na amji to, ne me awỳr wrỳ ata. Ne hamre ramã ite hacpỹ mã amji jaxàr, ne icati taa to, icati xàa kam ramã hàhhuc to mõ. ");
INSERT INTO ram_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wa nee ame amã ihêj nare, ampeaj kam wa me amã awjarẽ. Quê ha pjê kam jũm ampo hy kre, quê ha cute amji to ipixô nare na, quê ha nee kam hiprãj ne ihhy nare, ne ihhy atapit cormã nõ. Nãmri quê ha cute me hàmĩr na, quê ha amji to ajxô ne kam hiprãj ne ihtỳj kam ihhy hàhtôa to hàhtô. Jĩkjê na mã ite hajỹr. Wa ityc ne amji jarêt nare na mã, wa ha nee hacpỹa mã me acunea to atĩr nare. ");
INSERT INTO ram_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jĩkjê na mã me acunea te me hajỹar. Ca ha me amã mam ate amji kam me gapac xà kên tũm ata kĩn, ne me amã hapêti na, ca ha nee me amji mã intuw pejti ita nõ pyr nare. Nãmri ca ha ate mehcaca, ne me cumã hikran na, ca ha hirôa pê me amji mã ate amji kam me gapac xà tuw pejti ita py. Ata quê ha me amã irya to iry, ca ha côjkwa kam Pahpãm cahê na ame apa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ne quê ha jũm te ikôt amji ton, ne imã hàpên prãm na, quê ha jũm ata ipynã, ne ikôt amji to. Ne wa ha jũ ri apu mõ, quê ha hanea ne ikôt imã hàpên catê apu mõ. Quê ha Inxũ pê Pahpãm, por jũm imã apê ata to impejti ne. ");
INSERT INTO ram_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","— Wa ita kam imã amji kĩn nare catia na ite amji cajpẽr. Ne jũ mã wa ha ajte? Xà wa ha ajkĩ amji mã Inxũ na ahwỳ ne cumã: “Inxũ, itête ampo kên te ito jũ mãn xà ita camẽ” hane? Hãpà, jũ wỳr wa ha cumã ijarkwa to hane, he ita caxuw wa icator, pjê ita kam — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ne cute Hũm mã: — Inxũ, imã ate amji mã gaprỳ to catia to cati na ato prãm — hajỹr. Mã côjkwa pĩn jũm jõkre ita te cumã: — Wa ramã ite to cati, ne wa ha cormã hipêr itỳj to cati to mõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mã me hàhtôti atajê te me hõkre ita par, ne mehkwỳ ajpẽn mã me harẽn to: — Pahhàjê jàwrãrãc mõrmõ — hane. Mã mehkwỳ amji mã me to: — Côjkwa kam Pahpãm jarkwa to imprar catê nõ te cumã ihcakôc — hane. ");
INSERT INTO ram_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mã Jeju te me cumã harẽn to: — Nee mã icwỳrjapê jũm jõkre ita cakôc nare, me acwỳrjapêa ri hõkre ita cakôc. Ampo na? Ate me hõkre par xà ata kôt ca ramã ate Pahpãm te ihtỳj ikam hapac na, me ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ne ramã pjê cunea kam ame icurê catêjê cukij ne mehkên mã me hàr xàa kam ri hàhhuc. Ne por me pahcurê xwỳn pê Xatanaj pê pjê kam me to ihhimpej catê ata, quê ha Pahpãm mentête hũrê. Quê ha nee hipêr me kam ihhimpej nare. ");
INSERT INTO ram_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Quê ha pĩ na me ixô, ne kỳj pê ina me hãm, wa ha kam ityc to imõr me ajkaam amji wỳr me hàhtôa ne me to apkjê, mãr quê ito amji mã ihhimpej to me ipa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ne hũjarẽn xà ata to pê ajco cute jũ mã mehcuran xà ata to amji jarẽn to ipa. ");
INSERT INTO ram_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mã me hàhtôti atajê te me Jeju kam hapac ne me cumã: — Pỳhàpà! He wa ijõtpê hãn ne me Mojxe xwỳ jõ kàhhôc cahyt, ne kam me, por pê ramã Pahpãm me pamã jũm te jũ caxuw me pahto ihhimpej xà to me pamã awjahkre ata jarẽn par. Ca ajte côjkwa pĩn me hũmrea na ate amji ton, ne awrỳc ne apu apa na, me imã amji jarẽ. Cwỳrjapê ri apê ihhêj rũm, por pê Pahpãm jũm to me pamã awjahkre ata. Ne quê ha apê Pahpãm te ato hũjahkre ata mã impàràpên, ca ha atyc nare, ne me icunea to ahimpej kam acrà tu ne, ne jũ caxuw atyc xà nare. Nõ na mã ca ajte, cute me acuran ita na amji jarẽ ita kam, me icunea pê gahkre kêatre. Na ca ha hirãa pê me imã apê jũm te côjkwa pĩn me hũmrea na amji jahkre ne iwrỳc ita na amji jarẽ, wa me gahkre pej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mã Jeju me cumã: — He cormã nee ate me ite me amã ampo jarẽn xà itajê cunea par xà hamreare, ne jũa caxuw ca ha cormã me kampa ne me hahkre pej. Ne me ijũjarẽn xà ita kampa ne mehkôt hakop. Ne me hõmpu he, cu ha hàhcujro xà nõ to ampo cujro, ne hõmpun kênre nare, quê ha ampo kêanre na, cu ha me hõmpu ne me hahkre pej pyrentu. Na ri ipê hàhcujro xà nõ ata pyràac. Na wa ha ihhêj ne me acujro, ne me amã ate amji kam me gapac xà pupu, mõrmõ ajkĩ impej, nare, mõrmõ ajkĩ ihkêanre. Na ca ha ihkôat amji mã ate amji kam me gapac xà jahkre pej. Ampo na? He wa ha nee ita ri me acahê na apu imõr kam to icrà nare, ite me amã ijàhcujro xà caxuw. Na wa ha ita ri cormã apu imõr kwỳa kam, ca ha amji mã ate amji kam me gapac xà to antuw, ne me to intuw. Nãmri quê ha ahtũm nare wa ha ma me apê tẽ, quê ha me apê awcapàtkô, ne jũ mã ca ha me, ne ite me atehcajpar nare kam, ame amji mã hamã? Ne jũ mã ca ha me amji mã me ate amji kam me gapac xà to me antuw? Wỳr ca ha ame amji mã hamã. ");
INSERT INTO ram_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nãmri ca ha ate amji mã me ito ahimpej na, ca ha gàhcujro jarwrỳhti ita na me akrĩ, ne icuxà jũmjê kwỳ cujro, mãr quê cute amji kam me hapac xà to me antuw — hane. Hõ, Jeju te me cumã ihcakôc xà to hajỹr, ne ma tẽ, ne me cupê ipimxur. ");
INSERT INTO ram_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ne pê ramã me kam mare mã Pahpãm carôt tỳjti ata to hàpên xà pihho catia to, pê me hõmpu cakrô, nee me kam hapac ne amji mã me to ihhimpej nare. ");
INSERT INTO ram_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na pê Ixaj xwỳ pê Pahpãm jarkwa to ihcakôc catêjê nõ ata ramã ita na ihhôc to hane he: “Ỹhỹ me ijõ Pahhiti, ca ate me cumã acarôt tỳjti ata to apipẽ, ne to gàpên xà catia ton na ite me cumã garẽn cakrô, mã nee jũm te me ipar nare” hane. Hõ, ita na pê Ixaj xwỳ ihhôc, mã ahnaa cute. ");
INSERT INTO ram_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ampo na? He mehkwỳ amjia kôt ma amempar caca, na pê Ixaj xwỳ me ahna ihhôc to hane he: ");
INSERT INTO ram_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pahpãm te cute ampo pupun cupate, ihhêj ne me to into puror, ne cute mempar cupate, ihhêj ne me to me hapactuare. Cute amji kam hapac xà to me ipintuw ne hỹrmã amji to me ipipkjêr, mã cute me to impej cupate” hane. Hõ, pê ma ame Pahpãm par caca, na pê me to hane. ");
INSERT INTO ram_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ampo na pê Ixaj xwỳ ihhôc to hane? Nee mã ampo na nare, pê ramã mam rỳ pêa mã Jeju te carôt tỳjti to ampo catia to hàpên xà ata na me hõmpu, na pê ahna ihhôc to hane. ");
INSERT INTO ram_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mã me hàhtôa ne nee me Jeju par nare cakrô, mã Juta catêjê jõ pahhi kwỳ te hõtpê mempar. Ne nee cute me kam mare mã, amji mã me Jeju pejti na me harẽn nare. Ampo na? Nee mã ampo na nare. Parixêw catêjê te cute me cuprõn xà intête, põ mã me hapôj mã hipêr na mencjêj nare cupate. ");
INSERT INTO ram_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ne me cumã Pahpãm te mempejti na me harẽn na ihkĩn nare, ne ajte me cumã me hũmre te mempejti na me harẽn na, amji to prãm. ");
INSERT INTO ram_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mã Jeju te ihkrãhhia kam mehcunea mã hũjarẽn to: — Quê ha jũm te amji mã ito ihhimpej na, quê ha nee ipyxit peaj ne amji mã ito ihhimpej nare. Quê ha cute ito amji mã ihhimpej me ajkaam, por cute ajpên ikujahêc ata to hanea ne amji mã ihhimpej. ");
INSERT INTO ram_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne hanea ne, por jũm ipupu ata, ramã ajpên cute ikujahêc catê ata pupu. ");
INSERT INTO ram_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne pjê ita kam cute me amji kam hapac xà kêanre jàhtô, ne me cupê cute amji to me ipintuw jahkre kêatre. Na ri ihhêj ne awcapàtkô kam ame ipa. Na wa ihhêj rũm ipê mehcujro xà, ne me hỹrmã icator, ite cute amji kam me hapac xà to ipintuw ne ihhêj ne awcapàtkôti to mentête hamre xà caxuw. Na quê ha jũm te amji mã ito ihhimpej na, wa ha itỳj cumã cute amji kam hapac xà to antuw. ");
INSERT INTO ram_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","— Ne por ma ame icaca atajê me, ma apu ite me hapackre xà itajê caca atajê, quê ha ihtỳj jũ caxuw hahpan xà na Pahpãm mã me amgõ. Ne pa nare, wa nee ite me hũhkra kam ijàmcwỳr xà caxuw pjê ita wỳr icator nare. Quêt ite me to impej ne mehkên catia pê me hũtàr xà caxuw wa icator. Ne pom wa me cumã icakôc xà ton to ipa itajê, quê ha me ahna ahwỳ, quê ha, por jũ caxuw ampo cunea jamre xà ata kam, ihtỳj me cumã amgõ. ");
INSERT INTO ram_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","— Ampo na? Inxũ rũm ri ajpên icakôc xà itajê imã pra. Na wa Inxũ te ampo to, ite icakôc xà na irẽn atajê to pit mã, me cumã icakôc to ipa. Wa nee amjia kôt icakôc to ipa nare. ");
INSERT INTO ram_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na quê ha jũm te icakôc xà atajê kam hapac, ne to amji mã ihhimpej na, quê ha Inxũ cahê na amji to ipijapar rohnỳtti mã. Caxuw ri, Inxũ te imã ite to ijũjarẽn xà itajê jõr — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pê ramã me Hakren xà jõ amji kĩn jõ amcro wỳr amcro pyxit peaj ne nõ. Pê Jeju te ihtyc, ne pjê ita rer, ne ma hacpỹ mã côjkwa wỳr, Hũm wỳr cute ihtẽm jõ amcro ramã hàhtêp na, cumã hahkre pej. Ne pê hõtpê cumã pjê kam me cupê me hõ tekjê atajê kĩn, ne cumã mehkĩan to mehkĩn ita na mã ahnaa ihtyc xà ita mã cute to hahêr. Mã cute me ikĩnti ita to me imã hahkre to hajỹr he. ");
INSERT INTO ram_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wa Jeju me, me ipê ihkôt me ipa catêjê me, ramã caxwa xàa kam, me ikrĩ ne ame apà. Pê ramã caxuaw me pahcurê xwỳn pê Xatanaj ata me ikwỳ nõ japrỳ pê Juta Carijot ata mã, cute amji kam hapac xà kêanre ata jõr, mã ihkôt aracri cute Jeju kên mã mẽn xà caxuw. ");
INSERT INTO ram_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mã Jeju te, Hũm te cumã carôt cunea jõr na, cumã amji jahkre pej. Ne hanea ne cumã Hũm pĩn cator, ne quê ha hacpỹa mã hỹrmã api na, cumã amji jahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Cakrô mã hãm ne cute ihkà ata caxàr, ne cute cupẽhkà nõ ita to amji cahti na hê. ");
INSERT INTO ram_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne cute crat nõ ita kam cô kwỳ mẽn, ne ahpỹanre na kam me imã me ipar cuhhõn kam ihtẽm. Ne ihcuhhõ ne ma cupẽhkà ata to me imã incrà. ");
INSERT INTO ram_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ne ma Ximãw Petrô na to cator, mã cute Jeju cukij to: — Pỳhàpà ijõ Pahhi, pom ampeaj kam acati ita, nõ na mã ca ha ajte me ipar cuhhõ? — hajỹr. Mã Jeju te cumã harkwa to: ");
INSERT INTO ram_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","— Ca ha nee ita kam ampo caxuw ite amã apar cuhhõn xà ita jahkre pej nare, ne jũa caxuw ca ha hahkre pej. Na ca ha ito tojnõ wa amã apar cuhhõ — hajỹr. Mã Petrô cumã: ");
INSERT INTO ram_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","— He apêa ri ijõ Pahhi, na wa ha nee ate imã ipar cuhhõn ita na ato tojnõ nare — hane. Mã Jeju cumã: — Wa ha ite amã apar cuhhõn nare na, ca ha nee hipêr apê ikôt apa catê nare — hane. Mã Petrô te ahna hàhwỳr to: ");
INSERT INTO ram_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","— Ijõ Pahhi, mẽr imã ipar pit cuhhõn nare, ne hanea ne imã ijũhkra me ikrã cuhhõ! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mã Jeju cumã: — Hamreare, nee mã gĩ cunea xwỳr xà nare, ne apar pit cuhhõn xà. Por ramã jũm xwỳr ata tũm nare, ne cumã ihpar pit cuhhõn xà. Ampo na? Pjê kam apu to ipa mã ihtũm, cwỳrjapê ri cumã ihpar pit cuhhõn xà. Ne imã ihhêj ne ramã me acunea tetet pit, ne por jũm ata ri pyxit peaj ne nee ihtetet nare ne ihtũmti — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ne pê ramã Jeju cute ihkên mã mẽn catê ata jahkre peaj, na pê harkwa ita to hane he: — Ramã me acunea tetet, ne jũm ata ri pyxit peaj, ne nee ihtetet nare ne ihtũmti — hajỹr. Ne nee mã mehtũm to pê Jeju hũjarẽn to hajỹr nare, ne cute me amji kam hapac xà kên to pê hũjarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mã cute me imã ipar cuhhõn par jirô pê mã ri hacpỹa mã cute ihkà mã amji jaxàr, ne me ijàpàn xà na hỹr, ne cute me icukij to: — Xà ate me ite curmã ampo ton xà ita kam me gapac, ne me hahkre pej? Mõrmõ nee ate me hahkre pej nare, cwỳrjapê wa ha me amã ihkôt harẽ. ");
INSERT INTO ram_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ca me ito amji mã: “Me imã ampo to hahkre catê” hane. Ne hanea ne amji mã me ito: “Ijõ Pahhi” hane. Ne ampeaj kam ri ate me ijarẽan to me ijarẽan. ");
INSERT INTO ram_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ỹhỹ, he tee ipê me gõ pahhi, ne ipê me amã ampo to hahkre catê cakrô, wa itỳj me amã ijàpên, ne ite me amã me apar cuhhõn par. Cwỳrjapê ca ha me caa icuxà ajpẽn mã me apar cuhhõn pa. Ne ampo cunea na me ajpẽn tehcajpa, ne ajpẽn to me acati, ne ajpẽn mã me apê. ");
INSERT INTO ram_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ne ite me amã to hahkre na, ca ha ikôat me to, ne ajpẽn mã me apar cuhhõn pa. ");
INSERT INTO ram_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wa ampeaj kam me amã awjarẽ, he me hàpên catêjê nõ hõ pahhi jirôa pê cati nare. Ne nee hõ pahhi japyre mã hàpên nare. Ne quêt hõ pahhi ri me hirôa pê cati. Ne hanea ne, por harkwa na cumã imprar catê ata, nee cute ihkujahêc catê ata jirôa pê cati nare. ");
INSERT INTO ram_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hamre, ita caxuw ca ha ite amji kam ijapac xà na me ijahkre pej kam me to tẽ. Na ca ha ate ikôat me ton to me amji pyràc na, ca ha atỳj hũrên me gakry. ");
INSERT INTO ram_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","— Wa nee ite me acunea to icakôc nare. Ampo na? Wa itỳj ite amji mã me acapi atajê pupu, ne imã me gahkre pej. Ne pê Pahpãm jõ kàhhôc kam ramã me anõ ata to hũjarẽn to: “Por icahê na ijõ pãw ku ata, quê ha ihtỳj icuna mã ahtwỳ ne amji to icurê xwỳn” hane. Ne ampeaj kam quê ha caxwa ita kam, jũm ita ito hane. ");
INSERT INTO ram_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ne wa ha ita kam ampo te ito hajỹr xà ita xwỳjrea na, me amã harẽ. Mãr quê jũm ita ito hane, ca ha ramã me ipê Pahpãm kraa to Pahpãm kra na me ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ne ampeaj kam wa me amã awjarẽ, quê ha jũm te, por ite jũm kujahêc ata na amji caxàr me ajkaam, hanea ne ina amji capa. Ne quê ha jũm te ina amji caxàr me ajkaam, hanea ne Inxũ te ajpên ikujahêc ata na amji capa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cute ita jarẽn jirô pê mã ri cumã amji kĩn nare, ne hĩ cunea kam ihpeacre. Mã hirãa pê me imã amji jarẽn to: — Wa ampeaj kam me amã amji jarẽ, ca ha atỳj me anõ me icurê xwỳn tehcajpa ne me cumã igõ, neikên mã imẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wa tee ame ajpẽn pupu, ne nee me ite, por cute jũm to ihcakôc ata jahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ne pê ampeaj kam Jeju mã ikĩn, cwỳrjapê pê wa cahi na jỹ. ");
INSERT INTO ram_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mã Ximãw Petrô te hũhkra to imã hàpêr, ne hũhkra to imã, ite jũm ata na Jeju cukij na awjahkre. ");
INSERT INTO ram_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wa Jeju wỳr ipipkjêr ne ite kyre pê ihcukij to: — Ijõ Pahhi, jũm mã ajte? — hajỹr. Mã Jeju imã: ");
INSERT INTO ram_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","— Por wa ha jũm mã pãw co ne cugõ ata — hajỹr. Ne cute pãw kwỳ hyr ne crat kam cô cacro to inco, ne Juta Carijot mã hõr. ");
INSERT INTO ram_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mã cute pãw ata pyr me ajkaam mã Xatanaj te cumã amji jõr. Mã Jeju te cumã harkwa to: — Gapacta ne ate amji mã acaca xà nõ na prãm ata ton pyrentu — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mã me ikwỳ me ijàpàn xà na me jỹ atajê te nee me ita jahkre pej nare, por Jeju te imã harẽn xà ata na. ");
INSERT INTO ram_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ne pê Juta ihpore incjên xà to amji pytà, ne ajco apu to ipa na, pê ihtỳj cute amji kĩn caxuw cute ampo japrôr na Jeju te cumã harkwa na amehcãmjĩ, nare, cute me cupê hamreare atajê mã ihpore nõ jõr na amehcãmjĩ. ");
INSERT INTO ram_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mã Juta te pãw pyr, ne ihkrẽr ne ma ihtẽm pyrentu. Mã ramã awcapàtkô ne caxwa. ");
INSERT INTO ram_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ne ma Juta tẽm jakàn pê ri Jeju te me imã hũjarẽn to: — He ipê me Ahàkà ata pê wa me hũmre na amji to, ne côjkwa pĩn wrỳ. Ne ita caxuw quê ha mehcunea me hirôa pê icati na me ijahkre pej. Ne icwỳrjapêa quê ha hanea ne me Inxũ japrỳ to me catia to me cati na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wa ha mehcunea mã Inxũ carôt catihti impejti cupahti ata to ajpẽ, ne ahtũm nare, quê ha hanea ne me cumã icarôt catihti impejti cupahti ata to ajpẽ. ");
INSERT INTO ram_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Me apê me ikrare pyràac. Ne wa ha nee me acahê na apu imõr kam icrà nare, ne ahtũm nare wa ha ma tẽ. Na ca ha tee ame ijapê. Ne por wa ite ramã Juta catêjê mã amji jarẽn xà ata to, wa ha me amã amji jarẽ, ne me amã: “Jũ wỳr ca ha curi imõr xà ata ri me mõ” hane. ");
INSERT INTO ram_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","— Na wa ha me amã ite ijarkwa hyr xà intuwti ita ta, ne me amã harẽn to: “Atỳj me acunea mã ajpẽn kĩnti, to hanea, pom quê wa me akĩnti to amji kampa he, ita to quê ha hanea ne me amã ajpẽn kĩnti ne” hane. ");
INSERT INTO ram_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Quê ha me acunea mã ajpẽn kĩnti na, quê ha mehcunea ajpẽn na me apupu, ne me apê ikôt me apa catêjê na me gahkre pej pyrentu — hane. ");
INSERT INTO ram_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mã Ximãw Petrô te Jeju cukij to: — Jõ ri ca ha ajte mõ? — hajỹr. Mã Jeju cumã: — Jũ wỳr ca ha ita kam curi imõr xà ata ri mõ, ne jũa caxuw ca ha atỳj curi ikôt acato — hane. ");
INSERT INTO ram_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mã hipêr Petrô Jeju cukij to: — Mẽr ampo na wa ha nee ita kam akôt imõr nare? Pom ipê akôt ipa catê ita, cwỳrjapê wa ramã ita kam akôt ityc xàa caxuw apu mõ — hane. ");
INSERT INTO ram_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mã Jeju cumã: — He xà ca ajkĩ ampeaj kam ikôt atyc xàa caxuw apu mõ? Hamreare. Wa ha amã ijũjarẽn hiahpuro. Ca ha ita kam, hôxãhxãc kàr xwỳjrea na, ate ipupun nare, ne apê ijahkre kêatre na, amji jarẽn to incrê — hane. ");
INSERT INTO ram_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jirô pê mã ri cute me pahcunea mã harkwa to: — Nee ca me amji mã pa, ne ame akrihkrit nare. Ne Pahpãm to ca quêt amji mã me ahimpej, ne hanea ne ito amji mã me ahimpej. ");
INSERT INTO ram_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ne Inxũ krĩ xà kam ampeaj kam mehkrĩ xà caxuw mehkrĩ xà jàhtô, na wa ha ma hacpỹ mã tẽ, ne me amã ihnõ cũmpej hiahpuro. Wa nee ame amã ihêj xi jarẽn nare, quê ha curi mehkrĩ xà caxuw ikre caxwỳn atajê hamreare na mã, wa ha nee me amã harẽn to hajỹr nare. ");
INSERT INTO ram_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na wa ha ihcũmpej par jirô pê mã, wa ha hacpỹa ne me awỳr amji jaxà, ne me gaprô, mãr wa curi apu ipa ata ri, ca hanea ne ikôt curi ame apa. ");
INSERT INTO ram_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","— Ne ramã me amã jũ kam itẽm xà ata jõ pry jahkre pej — hajỹr. Mã me ikwỳ nõa pê Tome ata te ihcukij to: ");
INSERT INTO ram_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","— He me ipê cormã jũ kam atẽm xà ita na gahkre kêatre ita kam, jũ mã wa ha ajte me, ne me gõ pry ita jahkre pej? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mã Jeju cumã: — He Pahpãm wỳr pry pyxit peaj. Ne ipêa ri pry ata. Cwỳrjapê ca ha ipyxit peaj kôt Inxũ wỳr me acato. Ne ipê me amã ite Inxũ to ipipẽ xà to ihêj xi nare xà xakat. Ne ipê me ate amji kam me gapac xà impejti cunea xakat. ");
INSERT INTO ram_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ne ramã ate me ipê Pahpãm kra na me ijahkre pej, na ca ha atỳj hanea ne ita caxuw me Inxũ jahkre pej. Ỹhỹ, he pê ca ramã me hõmpu — hane. ");
INSERT INTO ram_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mã me ikwỳ nõa pê Pirip ata te Jeju mã: — Me ijõ Pahhi, me imã Apãm to ajpẽ, wa me hõmpu, ne tahnaa mã ihkôt me amji kampa, ne nee wa iràn xà na me ampo pupun prãm nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mã Jeju cumã: — Pỳhàpà, he rỳ pêa mã wa me acahê na ipa, ca ajte nee cormã ate me ipupun nare? Por jũm ipupu ata, ihtỳj hanea ne Inxũ pupu, ne mẽr ampo na mã ca cormã imã: “Me imã Apãm to ajpẽ, wa me hõmpu” hane? ");
INSERT INTO ram_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pirip, xà ca nee ajte, wa Inxũ me ajpẽn kam ihônco, ne ajkam me ipyxit peaj na amji mã me ito hajỹr nare? — hane. Ne Jeju me icunea mã: — Ne pom wa me amã awjarẽ itajê, wa nee amjia kôt harẽn nare. Ne wa ite Inxũ me ajpẽn mã amji jõr, ne ajpẽn kam me ihônco, na ri taa hàpên xà itajê cunea to. ");
INSERT INTO ram_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","He, wa Inxũ me ite ajpẽn mã amji jõr, ne ajkam me ipyxit peaj, na wa me amã amji jarẽ, ca atỳj me ikampa. Nãmri quê ha me amã icakôc xà itajê na ipar jahkre kêatre na, ca ha me ijàpên xà itajê pupu, ne ihkôat amji mã me ito ahimpej ne me ikampa. ");
INSERT INTO ram_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","— Wa ampeaj kam me amã awjarẽ, quê ha jũm te ampeaj kam ito amji mã ihhimpej na, quê ha, pom wa ijàpên xà to itajê jirôa pê hàpên xà ton to ipa. Ampo na? Wa ha ma Inxũ wỳr hacpỹ mã tẽ, na quê ha ajpên me amã icarôt kujate. ");
INSERT INTO ram_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ne wa me ato amji kwỳ cwỳrjapê ca ha ampo na me iwỳ, wa ha itỳj me amã hõr pa, mãr quê mehcunea me acwỳrjapê Inxũ catia to cati na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ne wa me ato amji kwỳ cwỳrjapê, ca ha ampo na me iwỳ, wa ha itỳj me amã cugõ. ");
INSERT INTO ram_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","— Nãmri quê ha me amã ikĩn na, ca ha atỳj ite ampo na me amã ijarkwa jirên atajê na me ikampa. ");
INSERT INTO ram_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne wa ha me amã Inxũ na ahwỳ, quê ha ijakàn pê ijaxà kam, me amã jũm kujate, quê ha me atehcajpa. Ne taa mã quê ha quêt me acahê na ipa rohnỳtti mã. Ne jũm ata pê ri Inxũ Carõ Pejti. ");
INSERT INTO ram_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ne taa mã quê ha me amã Inxũ te amji kam hapac xà impejti to ipipẽ to mõ. Ne por me cupê Inxũ tekjê nare, ne hanea ne me cupê me ikwỳ nare atajê, quê ha nee amji mã me Inxũ Carõ Pejti itacwỳr nare. Ampo na? Jũ wỳr quê ha me hahkre pej, ne me hõmpu. Ne me ca nare, ca ha atỳj quêt me hõmpu. Ampo na? He quê ha ihtỳj quêt me acaxwãm pê ihkrĩ, quê ha me acahi na ipa. ");
INSERT INTO ram_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","— Ne quê ha ina ahtũm nare, wa ha ma tẽ cakrô, wa ha nee me ato tojnõ ne me amã hikran, ca ha ahte ame apa nare. Ne itỳj me awỳr amji jaxà, ne me acahê na apu ipa. ");
INSERT INTO ram_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ne quê ha ina ahtũmre quê ha me cupê Pahpãm tekjê nare atajê nee hipêr me ipupun nare, ne me ca nare, ca ha quêt atỳj hipêr me ipupu. Ne wa ha itỳj hacpỹa mã itĩr ne Pahpãm cahê na apu ipa. Cwỳrjapê ca ha icuxà hanea ne hacpỹa mã me atĩr, ne me atĩr ita na Pahpãm cahê na ame apa. ");
INSERT INTO ram_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ne quê ha jũ caxuw, amcro nõ na me awỳr Pahpãm Carõ Pejti cato, ca ha Inxũ me ite ajpẽn mã amji jõr, ne ajkam me ipyxit peaj na me ijahkre pej. Ne hanea ne me amã, wa Inxũ Carõ Pejti kôt, me akam ikrĩ na ijahkre pej, na cu ha ajpẽn mã me amji gõ, ne ihhêj ne ajkam me pahpyxit peaj. ");
INSERT INTO ram_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","— Ne por quê ha jũmjê ito amji kampa, ne ijarkwa kôt me ipa atajê, quê ha me cumã ikĩnti na me to ipipẽ to ipa. Ne quê ha hanea ne Inxũ mã, por jũmjê mã ikĩnti atajê kĩn, wa ha hanea ne imã mehkĩn, na wa ha me cumã amji to ajpẽ, mãr quê me ipupu ne me ijahkre pej pejtu ne — hane. ");
INSERT INTO ram_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mã me ikwỳ nõa pê ajtea mã Juta nõ ata, pê nee Juta Carijot nare ata te Jeju cukij to: — Jũ mã ca ha ajte ne me imã pit mã amji to ajpẽ? Ne nee me cupê me akwỳ nare atajê mã amji to apipẽ nare? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mã Jeju cumã: — Quê ha jũm mã ikĩn na, quê ha ihtỳj ite cumã ampo na ijarkwa jirên itajê na ikampa. Cwỳrjapê quê ha ihtỳj Inxũ mã ihkĩn, wa ha Inxũ me ajwar me cumã amji to ajpẽ, ne ajpẽn kam me ihônco, ne me cahê na me ipa rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nãmri quê ha jũm mã ikĩn nare na, quê ha nee ite ampo na cumã ijarkwa jirên atajê na ipar nare. Ne cute hajỹr xà ita kam jũmã wa ha ajte, ne me cumã amji to ajpẽ, ne ajpẽn kam me ihônco to ipa? Jũ wỳr wa ha me to hane — hane. Ne cute me icunea mã: — He wa ampeaj kam me amã awjarẽ. Pom wa icakôc xà to icakôc, ca ahna me ikampa itajê nee cupê icakôc xà nare, ne cupê, por pê Inxũ ajpên ikujate ata cakôc xà. ");
INSERT INTO ram_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","— Ne wa ita ri cormã ame acahê na imõr xà ita kam, ramã ite me amã ampo itajê cunea to icakôc partu. ");
INSERT INTO ram_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na quê ha Inxũ hacpỹ ne ajpên ijarkwa kôt me awỳr Carõ Pejti kujate, quê ha taa me atehcajpa, ne me amã ampo cunea to hahkre. Ne taa ite ampo to me amã icakôc xà itajê to, ate me amji japackre na me ato, ca ha me to amji japackre. ");
INSERT INTO ram_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","— Ne wa ha me amã, pom wa icarĩcti kam ipa ita gõ, mãr ca nee amji mã ame ampo cupa nare, ne nee ampo cupate ame akrihkrit nare. Ampo na? He wa ha pa me apê ate amji mã me ampo cupa, ne ame akrihkrit xà atajê to hamre, ca ha atỳj ame apa. Ne wa ha nee ipê me cupê Inxũ na mehkwỳ nare atajê pyràc, ne ijarkwa cakrô to me amãn, ca ha me anõ akên nõ mã axàr nare, ne me apej pêa mã ame apa, ne quêt me acarĩcti kam ame apa. ");
INSERT INTO ram_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ne wa ramã ite me amã: “Wa ha ma tẽ, ne hacpỹa ne me awỳr amji jaxà, ne me acahê na apu ipa” hajỹr na, ate me ipar. Ampo na? He wa ha ma, por ijirôa pê Inxũ Cati ata wỳr amji jaxà. Ne quê ha me anõ mã ikĩn na, ihtỳj itẽm xà ita pyrên hakry. ");
INSERT INTO ram_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Wa ha ampo itajê te ito hajỹr xà xwỳjrea na me amã harẽn to ipa, mãr quê jũ caxuw ito hane, ca ha amji mã me ito ampeaj kam pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Ne jũ wỳr wa ha ahkri xa ne ame amã icakôc. Ampo na? Quê ha ahtũm nare, quê ha me pahwỳr me cupê Pahpãm na mehkwỳ nare atajê jõ pahhi, pê me pajõ xwỳn cato. Ne cupê me pajõ xwỳn cakrô, quê ha nee jũ na iton nare. Ampo na? Hirôa pê icarôt cati na ri. Ne pê ramã Inxũ imã: “Cama amji na me pajõ xwỳn jamã, quêt taa acura” hane. Na wa ha itỳj Inxũ te imã harkwa to hajỹr xà ita na kampa. Ampo na? Mehcunea te imã Inxũ kĩnti na me ijahkre pej prãmte, wa ha hane. Me to xa cu uu ne me — hajỹr. Wa ite me ajpẽn mã: — Mẽr hacme — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ne wa cormã pry kôt me imõar kam, mã Jeju te me imã amji jarẽn to: — He ipê pĩxô pàr ata pyràac, mã Inxũ pê pĩxô pàr ata jamãr catê ata pyràac, ne ma ijamã. ");
INSERT INTO ram_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ne por amji mã me ito ihhimpej catêjê atajê pê ihhêj rũm ipajũhtê atajê pyràac. Cwỳrjapê quê ha nee jũm te amji mã ite amji kam ijapac xà impar nare na, quê ha ihtỳj Inxũ itête põ mã mẽn to hanea, pom quê hãn ne pĩxô pàr pajũhtê hô nare, mã hamãr catê hakep ne curẽ, ata jĩkjê na Inxũ te hajỹar. Ne quê ha pĩxô pàr nõ pajũhtê na hô pyxitre apu harij, quê ha hamãr catê hõmpu, ne intête ahna xà me, ahna ampo kên cunea harij atajê jũrên pa, cute cumã hô to hàhtôa to prãm to. Ita jĩkjê na mã Inxũ hãn ne cute amji mã me ito ihhimpej catêjê atajê to hane. Cute amji kam hapac xà kam, cute me ampo kên to me amji kam hapac atajê cunea jũrê, mã mempej, ne ma ijarkwa kôt, me hàpên xà impejti to amji mã me ipicamẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ne ramã Inxũ te, ite me amã ampo to hahkre itajêa kôt, cute me amã ate amji kam me gapac xà kên jũrên ne to impej. ");
INSERT INTO ram_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nãmri quê ha pĩxô pàr pajũhtê nõ te impàt ne ihpỳm na, quê ha nee hô nare, ne cama incrà. Ita jĩkjê na, ca ha me anõ, ate ijarkwa kôt gàpên xà impejti to gàpên to apa nare, ne amjia kôt gàpên na, quê ha gàpên xà ata kôt apê hamreare ne. Cupate ca ha ikam me akrĩ kam me to acrà, wa ha hanea ne me akam ikrĩ kam to icrà. Na cu ha me ajpẽan, ne ajkam me pahpyxit peaj, ne atỳj ijarkwa kôt me apê. Ne me apê pĩxô pàr pajũhtê pejti ata pyràac, ne ampeaj kam me axô hũhhĩc itajê pê me gàpên xà jàhtôa ne impej. ");
INSERT INTO ram_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","— Ipê pĩxô pàr cati pyràac, ne me apê ihpajũhtê pyràac. Quê ha pĩxô pàr pajũhtê nõ ipàar kam ihcuhhê, ne ihtỳj ahna hô. Ita jĩkjê na, ca ha ikam me akrĩ kam me to acrà, ne atỳj ijarkwa kôt me gàpên xà impejti to me gàpên to me apa. Nãmri ca ha ate ikam me akrĩ kam me to acrà nare, ne amjia kôt ame apa na, ca ha nee me ampo pejti ton nare. ");
INSERT INTO ram_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Quê ha jũm te ijicu, ne nee ikam ihkrĩ kam to incrà nare na, quê ha cupê, cute me pĩxô pajũhtê jakep mã incrà, mã cute me to cuprõn, ne cuhy kam me haxwỳr, ne me to caxàr ata pyràac. Quê ha jũm te ipê ampỳa mã apu ipa na, quê ha ihtỳj amji to acto. ");
INSERT INTO ram_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ca ha ate amji mã me ito ahimpej kam me to acrà, ne atỳj ikam me gapac kam me to acrà na, cu ha me ajpẽan, ne ajkam me pahpyxit peaj, ca ha ampo na me iwỳ, wa ha itỳj me amã cugõ. ");
INSERT INTO ram_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na ca ha ate ijarkwa kôt gàpên xà impejti jàhtôa to gàpên to apa na, quê ha ahna me apupu, ne apê ikôt me apa catêjê na me gõmpu, ne me akam ihtỳj me Inxũ catia to cati. Ne cute amji kam hapac xà impejti ata na me gahkre pej, ne hanea ne Inxũ, ihtỳj jũm te amji kam hapac xà to impej na hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","— Ne pom Inxũ mã ikĩnti, mã ma ipupu ne ijamã ita na, wa ha hanea ne me ato, ne imã me akĩn, wa ha ma me apupu, ne ma me gamã. Cwỳrjapê ca ha nee amji tête ame ijarkwa curê nare, ne ikôat quêt ame apa, mãr wa imã me akĩn ita na. ");
INSERT INTO ram_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wa hãn ne amji mã Inxũ jarkwa na kampa, na ri cumã ikĩn, ita na ca ha icuxà hãn ne ijarkwa na me ikampa, wa ha imã me akĩn ita na. ");
INSERT INTO ram_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","— Ne mẽr ampo na mã wa ame amã icakôc xà ita to icakôc? He icuxà me gakryti cunea kam me apa rohnỳtti mã na me ato prãm, cwỳrjapê wa ame amã icakôc xà ita to icakôc. ");
INSERT INTO ram_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","— Ne wa hãn ne ijõtpê me amã ijũjarẽn to: “Pom imã me akĩnti ita cuxà, ca ha me amã ajpẽn kĩnti ne” hane. ");
INSERT INTO ram_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Imã me akĩn cràti ita kam, wa ha pa me icurê xwỳn mã amji gõ, quê ha me acwỳrjapê me icura. Ca ha cormã imã me akĩn cràti ita na me ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","— Ca ha ate ijarkwa kôt me gàpên na, ca ha me apê me ikwỳa to me ikwỳ. ");
INSERT INTO ram_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne imã, nee me apê cama me imã me gàpên catêjê atajê nare, ne me apê me ikwỳa to me ikwỳ. Ampo na? Nee mã ampo na nare. He cama me cumã me hàpên catêjê atajê pê me hõ pahhi te amji kam hapac xà jahkre kêatre, ne me ca nare. Wa itỳj quêt me amã, por Inxũ te imã ampo cunea jarẽn atajê jarẽn to ipa. ");
INSERT INTO ram_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","He pê ca nee amji mã me icapi nare, ne pa pê wa quêt amji mã me acapi. Ampo na? Nee mã ampo na nare. He ijarkwa kôt ate me gàpên xà pejti ton to me apa to prãm to, pê wa amji mã me acapi. Ne me gàpên xà impejti atajê pê quê ha ampo pĩxô pejti te jũ caxuw hamre xà nare ata pyràac, ne ihcuhhê rohnỳtti mã. Cwỳrjapê ca ha ijaprỳa na ampo na me Inxũ wỳ, quê ha ihtỳj me amã cugõ. ");
INSERT INTO ram_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ne wa ha hipêr me amã me ate me ajpẽn kĩnti xà ita na awjahkre. ");
INSERT INTO ram_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","— Ne wa ha ma itẽm jakàn pê, quê ha me cupê Pahpãm na mehkwỳ nare atajê, ma ame acurê. Ca ha me acumam cute ame icurê na me to amji japackrea ne. ");
INSERT INTO ram_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ne me cupê Pahpãm na mehkwỳ nare atajê mã mehkwỳ pê me hũràcti catêjê pit kĩn. Na quê ha me apê me hũràc na mã, quê ha ihtỳj me cumã me akĩn. Ne cama nee me apê me hũràc nare. Ampo na? He wa ite amji tekjêa na amji mã me acapi. Cwỳrjapê ri ma ame acaca ne ame acurê. ");
INSERT INTO ram_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ne curmã ite me amã ijũjarẽn xà ata to ca me amji japackrea ne. “Me cumã hàpên catêjê, nee me hõ pahhi catêjê jirôa pê me cati nare. Ne hanea ne nee me hõ pahhi japyre mã, me amji pupun to kên to me ipa nare” hajỹr. Na quê ha me cupê Pahpãm na mehkwỳ nare atajê, me imã ite amji pupun xà kêanre na me ito. Cwỳrjapê quê ha hanea ne ame ate amji pupun xà kêanre na me ato, ca ha ahna me amji pupu. Ne por me pyxitre amji mã me ijarkwa kampa atajê, quê ha hanea ne ihtỳj amji mã me akampa. ");
INSERT INTO ram_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ne mẽr ampo na mã quê ha ate me amji pupun xà kêanre na me ato? Nee mã ampo na nare. He me apê ikôt me apa catêjê, na quê ha me ato hane. Ne hanea ne me cupê Inxũ te ajpên ikujahêc ata jahkre kêatre, na quê ha ma ame acurê. ");
INSERT INTO ram_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","— Na wa ite me cumã cute mehkên ton xà atajê intête me cumãn, ne me cumã harẽn prãmte, wa me hỹrmã icator. Mã cute me hahkre pej cakrô, ajte nee cute me ton jicu nare. Cwỳrjapê quê ha Pahpãm ame to kêanre ne. Wa ha icator ne me cumã, cute mehkên xà ton ita jarẽn nare na mã, quê ha nee me hahkre pej nare, quê ha Pahpãm xwỳjê nee ame to kên nare. Ne hamre, jũ wỳr quê ita caxuw, cute mehkên ton xà ata pê jũ kam me cato. ");
INSERT INTO ram_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ne por ma ame icaca, ne ame icurê atajê, hanea ne ma ame Inxũ caca ne ma ame curê. ");
INSERT INTO ram_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wa icator, ne me kam mare mã ite icarôt tỳjti to, rỳ jũ caxuw jũm te ampo pejti pihho ton nare atajê cunea ton par. Wa ha me kam mare mã ampo itajê ton nare na mã, quê ha nee Inxũ me cumã harkwa to: “Me apê ate me akên ton catêjê” hajỹr nare. Mã ajte cute ita na me ipupun cakrô, ajte ma Inxũ me ajwar ame icurê. ");
INSERT INTO ram_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ne pê ramã rỳ pêa mã Mojxe xwỳ ina ihhôc to hane he: “Wa ite ampo kên ton nare cakrô, mã ajte ma ame icaca, ne ma ame icurê” hane. Hajỹr ata na mã cute me iton he. ");
INSERT INTO ram_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","— Ne quê ha ampo kên itajê te ame ato hajỹr cakrô, ca ha nee ame amji mã pa, ne nee ame akrihkrit nare. Ampo na? He wa ha itỳj me amã Pahpãm Carõ Pejti te catyt kam me amã ampo to hahkre catê ata kujate. Quê ha me atehcajpa, ne me amã ihcunea na ikôt harẽn to hahkre. ");
INSERT INTO ram_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ne me ca, ca ha hanea ne mehcunea mã ikôt harẽn to me apa. Ampo na? He pê ca mam quêt ikôt me apa, na ri ihcunea na ramã me amã ijahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","— Ne wa ha jũ caxuw ampo te ito hajỹr xà ata kam, ate ame icaca, ne ame imã hikran cupate, wa ite ramã me amã ampo itajê cunea jarẽn hiahpuro. ");
INSERT INTO ram_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nãmri quê ha ihtỳj ikôt me cumã me acurê, ne quê ha cute me cuprõn xà jũrkwa pê, ihtỳj me gapôj. Ne quê ha mehkwỳ kwỳ te amji to me Pahpãm cajpuaw na me amji cãmjĩ xà to, quê ha ihtỳj hanea ne me acura. ");
INSERT INTO ram_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ne ampo na quê ha ame ato hane? He me cupê ijahkre kêatre, ne me cupê Inxũ jahkre kêatre, na quê ha ame ato hane. ");
INSERT INTO ram_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ne quê ha ampo itajê me ato hane, ca ha ite ramã me amã harẽn hiahpuro na, me ito amji japackre pyrentu. He pê wa mam aracri ame akôt ipa, ne nee ajco me amã ampo itajê jarẽn to hajỹr to ipa nare. Ampo na? Pê wa pa me apytàr to ipa na pê. ");
INSERT INTO ram_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","— Ne hamre, ramã ma hacpỹ mã ajpên cute ikujahêc catê ata wỳr ite amji jaxàr xàa kam ramã hàhhuc to mõ, na wa itỳj me amã ampo itajê cunea jarẽn to mõ. Ca nee ajte jũ kam itẽm xà ita na me icukij nare. ");
INSERT INTO ram_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne wa ramã ite me amã hacpỹa mã amji jaxàr xà ata na amji jarẽn, cwỳrjapê ri ajte me amã amji kĩn nare, ne me apeacre. He nee ame apec nare! ");
INSERT INTO ram_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","He ampeaj kam wa me amã amji jarẽ, ne wa nee apu ihêj xi jarẽn nare he. Imãa hacpỹ mã ite amji jaxàr xà ita na ri me amã ihkênre nare. Ampo na? He wa hacpỹa ne amji jaxàr nare, quê ha nee ajpên Pahpãm Carõ Pejti te me atehcajpar catê ata me awỳr iwrỳc nare. Na wa ha ma tẽ, ne itỳj ajpên hacpỹ ne amji jaxà kam me amã ihkujate. ");
INSERT INTO ram_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","— Ne quê ha Inxũ Carõ Pejti te catyt kam me amã ampo to hahkre catê ata te me awỳr cator na, quê ha taa me cupê Pahpãm na mehkwỳ nare atajê mã ampo crê atajê to hahkre, quê hame hahkre pej. Atajê pê, cute me ampo kêanre ton xà na cute me amji jahkre pej xà me, cute catyt kam imã ite amji kam ijapac xà to impejti jahkre pej xà me, jũ caxuw Pahpãm te, cute me hàpên xà ton na amehcukij na cute me hahkre pej xà. Hõ, ampo crê itajê to, quê ha Inxũ Carõ Pejti ata cute me hahkre pej na me to he. ");
INSERT INTO ram_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Quê ha Carõ Pejti, por nee ito amji mã mehhimpej nare ne ame ampo kêanre ton to ame ipa atajê na, cute me amji jahkre pej na me to. ");
INSERT INTO ram_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ne quê ha hanea ne ipê Pahpãm mã catyt kam ipa catê na, cute me ijahkre pej na me to. Na wa hama hacpỹ mã Inxũ wỳr tẽ, ca ha nee me ipupun to acuhhê tu nare. ");
INSERT INTO ram_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne quê ha hanea cute mehkên ton xà atajê jahpan xà na, Inxũ te mehcukij ne mehkên mã me irẽn na, cute me hahkre pej na me to. Na ri cute me ampo kên ton xà itajê jõ pahhi pê Xatanaj ata kên mã mẽn xàa kam xa. ");
INSERT INTO ram_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","— Ne cormã ampeaj kam imã me amã ampo jarẽn xà itajê jàhtô, wa me amã ampo itajê cunea jarẽ na mã, ca ha nee mempar, ne me hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ne nee ita na cute me amã jũ mãn nare. Ampo na? Quê ha jũ caxuw Inxũ Carõ Pejti te catyt kam me amã ampo to hahkre catê ata ajpên me awỳr cato, ne ta ame amã ampo itajê cunea to hahkre pa. Ne catyt kam, harkwa kôt, Inxũ te amji kam hapac xà impejti itajê to pit mã me amã hahkre, ne nee mã, quê ha amjia kôt me amã to hahkre nare. Ne me amã, por ajpên cormã me awỳr ampo cator nare atajê to hahkre. ");
INSERT INTO ram_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ne me akam mare mã amji mã icatia to icati na ijarẽ, ne cute amji mã me icupa na me to, quê ha ihtỳj amji mã me icupa. Ampo na? He quê ha icakôc xà to pit mã ihcakôc, na quê ha hane. ");
INSERT INTO ram_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ne por Inxũ mã ampo cunea atajê te hajỹar, ne cupê itekjê. Na wa ha Pahpãm Carõ Pejti mã ampo jarẽ, quê ha ma me amã to awjarẽ. ");
INSERT INTO ram_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","— Ne quê ha ina amcro hàhtô nare, ca ha nee hipêr me ipupun nare. Ne hanea ne ina amcro hàhtô nare, ca ha hacpỹa mã me ipupu — hajỹr. Jeju te me imã amji jarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wa ite me ajpẽn cukij kam me itẽm, ne me ajpẽn mã: — Ne mẽr ampo na mã tee ame pamã amji kôt harẽn to hahkre. Ne ajte amji jarẽn to: “Quê ha ina amcro hàhtô nare, ca ha nee hipêr me ipupun nare. Ne hanea ne ina amcro hàhtô nare, ca ha hacpỹa mã me ipupu” hane. Ne hanea ne ajte amji jarẽn to: “Ita cwỳrjapê wa ha ma hacpỹ mã Inxũ wỳr tẽ” hane. ");
INSERT INTO ram_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ne mẽr ampo jarẽn xà pê mã: “…amcro hàhtô nare…” ita? Wa nee me ite ihcakôc xà itajê nõ na mempar, ne me hahkre pej nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mã ampo na ite me Jeju cukij prãm ata na cute me hahkre pej pyrentu, cwỳrjapê ri me imã: — Xà ite me amã: “Quê ha amcro hàhtô nare, ca ha nee me ipupun nare, ne ina amcro hàhtô nare ca ha hipêr me ipupu” ata na mã ca ame ajpẽn cukij? ");
INSERT INTO ram_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ampeaj kam wa ha me amã ijũjarẽn xà ita to awjarẽ. Ca ha atỳj jũ caxuw ame amrã, ne me amã amji kĩn nare ne, ne me apeacre ne. Ne me cupê Pahpãm na mehkwỳ nare atajê, quê ha ihtỳj quêt ame hakry. Cakrô, quê ha hacpỹ ma mã mam me amã amji kĩn ata jirôa pê me amã amji kĩn. ");
INSERT INTO ram_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","He pom hãn ne me cahãj mã mehkra hà mã me cumã amji kĩn nare, mã me cumã ajhu, mã hacpỹ ma mã mehkàj xà to me hapac kêt, ne me cumã amji kĩn, ne me cumã mehkra pỳpỳm pyrên ame hakry, ita jĩkjê na ca ha me hanea. ");
INSERT INTO ram_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ne amcro itajê kam me amã amji kĩn nare cakrô, cu ha hipêr me ajpẽn pupu. Jirô pê mã quê ha me amã amji kĩan to amji kĩn ata, quê ha nee jũm me apê caxàr, ne me apê to hamre nare. ");
INSERT INTO ram_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","— Ata caxuaw ca ha nee hipêr ampo na me iwỳr nare, ne me apê me ikwỳ te hajỹr romã mã, ca ha ijaprỳa na, ampo cunea na ate Inxũ na me gàhwỳr xà atajê, quê ha ihtỳj me amã cugõ. ");
INSERT INTO ram_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ca ajte nee cormã me ate ijaprỳa na ampo na me Pahpãm wỳr nare. Na ca ha ita caxuw atỳj ijaprỳa na ampo na me Inxũ wỳ, quê ha ihtỳj me amã cugõ, ca ha me acwa, ne me to mam me amã amji kĩnti ata ràn, quê ha me girô pê ihpỳm tu ne. ");
INSERT INTO ram_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","— He wa nee cormã hirãa pê me amã ijũjarẽn xà itajê jarẽn to ipa nare, ne incwỳrpê me amã harẽn to ipa. Ne wa ha jũ caxuw quêt hirãa pê me amã Inxũ te amji kam hapac xà jarẽ, ne me amã to ajpẽ. ");
INSERT INTO ram_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ne ca ha jũ caxuw me apê me ikwỳ te hajỹr romã mã ijaprỳa na ampo na me Pahpãm wỳ, wa ha nee hipêr ahna cumã me acajrẽn to prãm nare. ");
INSERT INTO ram_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ampo na? He ihtỳj ita caxuw cumã me akĩn, cwỳrjapê quê ha taa me akampa, ne me amã ampo atajê gõ. Ampo na ri cumã me akĩn? He ca ihpĩan icator xà na amji mã me ito me ahimpej, ne me amã ikĩnti incwỳrjapê ri ihtỳj cumã me akĩn. ");
INSERT INTO ram_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne wa Inxũ pĩn ajpên pjê ita wỳr icator, na wa ha ita caxuw pjê ita re, ne ma hacpỹ mã hỹrmã tẽ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wa ite me cumã: — Hamre, ca ita caxuw hirãa pê gũjarẽn xà itajê kôt harẽn to mõ. Ne nee incwỳrpê me imã ihkôt harẽn to amõr nare. ");
INSERT INTO ram_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na wa ita caxuw, ite me ate ampo cunea jahkre pej na me gahkre pej, ne amã cute ampo na me acukij xà xwỳjrea na, ramã amã me hahkre pej, me hàhcukjêr xà atajê na. Cwỳrjapê wa ita caxuw itỳj Pahpãm pĩn acator na amji mã me ato ihimpej — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mã me imã: — Xà ita kam cormã, ajkĩ ate amji mã ito me ahimpej? ");
INSERT INTO ram_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Co he, nãmri ramã ihhêj ne ipê me apicràn xàa kam hàhhuc to mõ. Ca ha atỳj me irer pa, ne ma ame gũrkwa wỳr me pra, wa ha ahte ahtwỳ cakrô, wa ha nee ahte ijàhhuc nare. Ampo na? Quê ha ihtỳj Inxũ icahê na apu mõ. ");
INSERT INTO ram_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ne ame akrihkrit cupate, wa mam ite me amã ijũjarẽn xà itajê to ijũjarẽn. Mãr ca ikam me amji hônco, ne me acaxwãm pê me acarĩcti ne. Ne pjê ita kam, me cupê Pahpãm na mehkwỳ nare atajê kam, ca ha ame amji pupun xà kêanre to ame amji pupu. Cakrô, ca ha nee ame cumã me apec nare, ne me cumã amji to ihtỳaj ne. Ampo na? He wa ramã me hõ pahhi mea mã ite me tohjê, ne me hirô pê ixãm — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jeju te me imã hũjarẽn to hajỹr jirô pê mã ri kàj mã, côjkwa wỳr irĩt, ne cute Hũm mã: — Ỹhỹ Inxũ, hamre ramã ityc xàa kam hàhhuc. Inxũ, ipê akra catia to icati na, cute me ijahkre pej xà na me to, quê mehcunea me ijahkre pej, mãr wa hanea ne acatia to acati na, cute me gahkre pej xà na me to, quê mehcunea gahkre pej. Cwỳrjapê ca ha hacpỹa mã ityc jirô pê ito itĩr ne amji wỳr ijaprô. ");
INSERT INTO ram_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne pê ca imã garkwa hyr to hane he: “Pjê wỳr ate acator, ne ate amji to me hõ Pahhiti na, ne mehcunea to ahimpej xà caxuw, ramã ite amã acarôt jõr. Ne wa ha amã me hàhtôa ne cugõ, ate me to gõ tekjê xà na, quê ha ato amji mã mehhimpej, mãr quê pahcahê na amji to me ipijapar rohnỳtti mã” hane. ");
INSERT INTO ram_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","He apyxit peaj ne quêt apê Pahpãm, ne nee aràn xà na jũm pê Pahpãm nare. Ne ipê por ate Jeju Crixtô kujahêc ata. Ne me pahkwỳ te me pajahkre pej, cwỳrjapê quê ha me pahcahê na amji to me ipijapar rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ite ramã acatia to acati na pjê ita kam, cute me gahkre pej xà na me ton. Ne ate imã ijàpên xà jõr ata, ramã ite hipêj xàa kam. ");
INSERT INTO ram_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ne pê wa ramã ate pjê ton xwỳjrea na mam acahê na ipa, pê amã icatia to icati. Na wa ha ita caxuw ma awỳr amji jaxà, ca ha amji cuna mã hacpỹa mã ito icatia to icati. ");
INSERT INTO ram_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","— Ỹhỹ, pê ca imã me cupê me akwỳ atajê gõ, ite me cumã ate amji kam gapac xà to hahkre, mã cute me gahkre pej prãmte. ");
INSERT INTO ram_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na ri ihtỳj cute me garkwa kam hapac. Ne ihtỳj ita caxuw arũam iwỳr me cumã ampo cunea imprar na hahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na wa ite, ate me cumã icakôc xà na gũjahkre xà atajêa to, wa ite me cumã icakôc, mã ihtỳj cute mempar, ne ahna me amji caxàr. Ne ihtỳj amji mã ate ajpên me hỹrmã ipyxit peaj ne ikujahêc na me ato hane. Ampo na? He nee mã ita pê ahêj xi xà nare, ne ampeaj kam ri. ");
INSERT INTO ram_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","— Ne wa itỳj amã mehcajrẽn, ne nee mehkôt amã mehcunea pê me pahkwỳ nare atajê cajrẽn nare, ne por ate me imã hõr atajê pit, wa amã mehcajrẽn. Ampo na? Me cupê gõ tekjêa, na wa apu mehcajrẽn. ");
INSERT INTO ram_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ne mehcunea pê itekjê atajê pê atekjê, ne mehcunea pê atekjê atajê pê itekjêa. Cwỳrjapê ri pahkôt me ipa catêjê atajê kôt, cute ramã icarôt tỳjti, ne icatia to icati na me ipupun. ");
INSERT INTO ram_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne wa ha ma hacpỹ mã awỳr amji jaxà, quê ha ahte pjê kam cormã me ahtwỳ ne ame ipa. Inxũ, ampeaj kam apeaj to apej. Cwỳrjapê ca ha ca atỳj acarôat to me pahkwỳ jamã. Ampo na? He ampeaj kam acarôt tỳj, na pê ca imã icarôt tỳjti ita gõ. Cwỳrjapê ri ajkam pahpyxit peaj. Mãr quê me pahkwỳ itajê pê me pahpyràac, ne me ajpẽn hônco tu ne, cute pahcuxà ajkam me pyxit peaj prãmte. ");
INSERT INTO ram_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pê wa pjê kam cormã ame cahê na imõr reria mã, itỳj, por ate imã acarôt jõr ata to ajco me hamãr to me hũtàr to ipa. Mã nee ijũhkra pê mehnõ cator, ne ipictor nare. Ne por ramã gõ kàhhôc te jũm pyxit peaj ne, ne cupê Juta Carijot ata ipictor na harẽn ata ri, amjia kôt ahnaa cute amji to ipictor. ");
INSERT INTO ram_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","— Ne wa hacpỹ mã ite awỳr amji jaxàr xwỳjrea na, cormã pjê kam ame cahê na imõr reria mã me cumã garkwa cunea to hahkre to ipa, mãr quê me hahkre pej, ne me cumã amji kĩnti ne. Pom wa ahnaa mã imã amji kĩn na amji cajpẽ ita na, quê icuxà me amji cajpẽ. ");
INSERT INTO ram_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Wa ite ramã me cumã garkwa to hahkre, ne me cumã hõr. Mã me cupê ipyràac, ne nee me cupê pjê ita tekjê nare, cwỳrjapê ri me cupê pjê tekjê atajê ma amehcaca, ne ame curê. ");
INSERT INTO ram_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne wa ha me cumã ana ahwỳ, ca nee cormã ne pjê ita pê amji wỳr me haprôr nare, ne ma cama me ahna me pahcurê xwỳn jamã, ne me cupê me hũtà, mãr quê nee ihkôt me amji kam hapac nare. ");
INSERT INTO ram_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ne cute me amji kam hapac xà pê ite amji kam ijapac xàa pyràc, na ri nee me cupê pjê tekjê atajê te amji kam hapac xà pyràc nare. ");
INSERT INTO ram_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ne garkwa cakôc xà itajê nee ihhêj xi jarẽn nare, ne ihtỳj cute catyt kam me ipa xà caxuw me hapackre, mãr quê ihtỳj me awpa, ne catyt kam me ipa. Na quê ha me cupê atekjê. ");
INSERT INTO ram_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne pom pê ca pjê wỳr ikujate ita na, wa ha me to, ne pjê cunea kôt ame cucrà, quê ha ame cumã pajarkwa pejti ita to hahkre to me ipa. ");
INSERT INTO ram_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ne wa ite ijàpên xà caxuw amã amji jõr ita na quê ha me amã amji gõ, ne ihtỳj me amã me hàpên to me ipa. ");
INSERT INTO ram_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","— Ỹhỹ Inxũ, wa ha nee me pahkwỳ crêre itajê caxuw pit mã ana ijàhwỳr nare. Ne hanea ne cute cormã jũ caxuw mehkôt me ikam hapac ne ito amji mã mehhimpej atajê mã, wa ha ana ahwỳ. ");
INSERT INTO ram_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ne imã cute me amji kam hapac xà pyxit peaj na mehhôncoti na me to prãm. Pom ahnaa mã pamã pahte amji kam pajapac xà pyxit peaj he, ita to cute me amji kam me hapac na ri, imã me to prãm. Ita na quê ha me cupê me pahkwỳ nare atajê cute amji kam me hapac xà pyxit peaj na me hõmpu, ne ihtỳj ate ikujahêc na me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne pom ate ito icati ita na, wa ite me to cati, na ri cute amji kam me hapac xà pyxit peaj na me amji hônco tu, ne me pyxit peaj te hajỹar, pom cu ajkam pahhônco, ne pahpyxit peaj he. ");
INSERT INTO ram_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne ampo na mã wa ame cumã ana ijàhwỳr to hane? Nee mã ampo na nare. He mehcunea mã cute amji kam me hapac xà pyxit peaj to prãm to, wa ame cumã ana ahwỳ, mãr quê mehcunea me hõmpu ne ate ikujahêc na me gahkre pej. Ne pom amã ikĩnti ita na, quê ha amã mehkĩnti na cumã me gahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","— Ỹhỹ Inxũ, por ate imã me hõr atajê me pahcahê na amji to me ipijapar na, imã to prãm. Ne ca ha me kam mare mã ate ito icati, mã cute me ipupun, ne me ijahkre pej. Na ca ha atỳj ito hane. Ampo na? Pê ca ramã mam pjê ton xwỳjrea na amã ikĩnti, na ca ha ito hane. ");
INSERT INTO ram_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","— Inxũ, he ca quêt catyt kam akrĩ ita na, ne ita ri pjê kam mehcunea pê gahkre kêatre. Ne pa nare, ihtỳj quêt imã catyt kam akrĩ ita na gahkre pej. Ne por ate imã me hõr atajê te hajỹar ne ihtỳj ate ikujahêc na me cumã gahkre pej. ");
INSERT INTO ram_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","He wa ite me cumã garẽn, mã cute me gahkre pej. Ne wa ha me cumã garẽn to ixãm ita na, mãr quê me cumã ajpẽn kĩn to hanea, pom quê amã ikĩn he. Ne ite amji kam ijapac xà pyxit peaj ata to pit mã me amji kam hapac to me ipa, mãr wa ajpẽn kam me ipyxit peaj — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ne Jeju te Hũm mã ihcakôc to hajỹr jirô pê mã ri ma me ipê ihkôt me ipa catêjê to mõ, Kỳhti jõ caprũm jĩkjê wỳr. Mã curi pĩxô jõ pjê ata, wa cumã me ixàr. ");
INSERT INTO ram_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pê Juta pê Jeju kên mã mẽn catê ata ramã pjê ata jahkre pej. Ampo na? Pê Jeju ramã curi me ito ipa to hàhtôa na pê. ");
INSERT INTO ram_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mã ma me iwỳr Juta ata krãhtare kwỳ to mõ, mã hanea ne mehkôt Pahpãm jũrkwa jamãr catêjê kwỳ me mõ. Ne pê Pĩxô jõ pjê ata wỳr me mõ atajê pê, me cumã Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, Parixêw catêjê kwỳ me, me ajpẽn pa, na pê me harkwa kôt me iwỳr me hàprê xà me, ihpôc xà me, cuhy pàr kwỳ me, me to mõ. ");
INSERT INTO ram_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pê ramã Jeju ampo te to hajỹr xà atajê cunea jahkre pej. Cwỳrjapê ri me cuna mã mõ, ne cute mehcukij to: — Jũm mã ca ame hapê? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mã me cumã: — Naxare jõ krĩ pĩn Jeju cator ata wa ame hapê — hane. Mã hanea ne Juta pê Jeju kên mã mẽn catê ata me cahê na xa. Mã Jeju me cumã: — He pa wa! — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mã Jeju te me cumã amji jarẽn to: “He pa wa” hajỹr, me ajkaam mã hũpate Juta kôt me ipa catêjê cunea, hacpỹ mã pjê kam me hõ to ame ipihur. ");
INSERT INTO ram_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mã hipêr Jeju te mehcukij to: — Jũm mã ca ame hapê? — hajỹr. Mã me cumã: — Naxare jõ krĩ pĩn Jeju cator ata wa ame hapê — hane. Mã me cumã amji jarẽn to: ");
INSERT INTO ram_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","— Wa ite ramã me amã amji jarẽn, he pa wa. Ne ca ha ate ame pamãn japên na, ca ha nee ame ikwỳ caxun nare, quêt taa ame pra — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ampo na ri cute ita ton? Nee mã ampo na nare. He pê ramã taa me ahna Hũm mã amji jarẽn to: “Ijõ Inxũ Cati, ate imã me hõr itajê, ite nee amji pê mehnõ to ipictor xà nare” hane. ");
INSERT INTO ram_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mã Ximãw Petrô te wapo xwahhihti caxàr, ne to hũmre nõ japrỳ te Marco ita jaxôp, ne awpôc rũm to hapac jakep. Ne pê hũmre ata pê Pahpãm mã mehcajrẽn catêjê jõ pahhi mã hàpên catê. ");
INSERT INTO ram_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mã Jeju te Petrô mã harkwa to: — Ajõ wapo xwahhihti ita xi, nee ca apu to me cupê ipytàr prãm nare. He ite amji pupun xà kêanre xà ita caxuw ri Inxũ te ajpên iwỳr mehkujahêc. Xà wa ha ajkĩ nee cumã ixàr nare? Wa ha itỳj cumã axà — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mã krãhtare me, to ihhimpej catê me, Pahpãm jũrkwa jamãr catêjê jõ pahhi kwỳ me, cute me Jeju pro, ne hũntỳj na mehcajpre. ");
INSERT INTO ram_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ne pê Cajpa pê caku ata kam, me cupê Pahpãm mã cute mehcajrẽn catêjê jõ pahhi. Ne ma Cajpa ata jũprequêt pê Anati ata jũrkwa wỳr me to mõ. ");
INSERT INTO ram_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ne Cajpa pê pahhi ata pê ramã me hapackre to hane he: “Quê ha jũm xũmre pyxit peaj ne ty, cu ha nee me pahcunea me pahtyc nare” hane. ");
INSERT INTO ram_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Wa ma Ximãw Petrô me, Jeju kôt me mõ. Pê ramã Pahpãm mã cute mehcajrẽn catêjê jõ pahhiti ata ipupun pejtu. Cwỳrjapê wa ma Jeju kôt ixàr, pahhi jũrkwa jarkwa mã carã intête kwỳc ata wỳr. Mã cormã curia, põ pê Petrô xa. ");
INSERT INTO ram_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wa ite harkwa jamãr catê cahãj nõ ata mã icakôc, ikwỳ nõ Petrô te ikôt hàr xà caxuw. Mã ihtỳj cute hàr na hamãr, mã hàr. ");
INSERT INTO ram_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mã cahãjre te hõmpun ne cumã harkwa to: — Xà apê, por cute me jũm pro ata kôt apa catêjê nõ amã ca? — hajỹr. Mã cumã: — Quê! — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ne ampeaj kam kry, cwỳrjapê ri pahhi mã me hàpên catêjê me, krãhtare te me cuhôn, ne mehkrã ne ahna me xa, ne ame amji cro. Mã hanea ne me cahê na Petrô xa ne amji cro. ");
INSERT INTO ram_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mã Pahpãm mã mehcajrẽn catêjê jõ pahhiti te Jeju cukij ne cumã: — Jũmjê pê mã akôt me ipa catêjê? Ne ampo to mã ca amehcunea mã hahkre to apa? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","Mã Jeju te cumã amji jarẽn to: — He wa ijõtpê mehcunea kam mare mã icakôc to ipa. Ne ramã cute Pahpãm to me amji kam hapac xà jũrkwa me, cute me cuprõn xà jũrkwa atajê kam, ite me cumã ampo to hahkre to amji pyràc tu. Ne rỳ jũ caxuw ite ampo to ipimxur pêa mã apu harẽn to imõr nare, nõ na mã ca ajte apu icukij xà ita to icukij? Ne cute me ipar catêjê ca mehcukij, wa ite ampo jarẽn xà atajê na, cute me ipar to kênre nare. Na ca ha mehcukij — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jeju te ihcakôc to hajỹr. Mã cahi na krãhtare xa ata te cakwĩn, ne cumã harkwa to: — Xà ajkĩ Pahpãm mã mehcajrẽn catêjê jõ pahhi mã me pahcakôc xà te hajỹr? — hajỹr. Mã Jeju cumã: ");
INSERT INTO ram_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","— Wa ihhêaj to ampo jarẽn xà kaj na harẽ, ca ha mẽr imã harẽ, wa hahkre pej. Nãmri wa ha ite ampeaj kam ijũjarẽn na, ca ha nee icakwĩn nare. Ne mẽr ampo na mã ate icakwĩn? — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jirô pê mã ri Anati pê amji jahkre kêatre, mã cute Jeju cajprea na Cajpa, pê cute Pahpãm mã mehcajrẽn catêjê jõ pahhi ata mã ihkujahêc. ");
INSERT INTO ram_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mã curia cormã cuhy na Petrô xa, ne amji cro. Mã cute mehcukij to: — Xà apê cute me jũm pro ata kôt me apa catêjê nõa mã ca? — hajỹr. Mã me cumã amji jarẽn to: — Quê, he nee ipê mehnõ nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mã pahhi mã hàpên catêjê nõ pê, por Petrô te jũm japac jakep ata jũkjê nõ ata, te Petrô jarẽn to: — Mãr wa ite Pĩxô jõ pjê kam ihkôt apupun ta? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mã hipêr Petrô cumã: — Quê — hane, me ajkaam mã hôxãhxãc kàr. ");
INSERT INTO ram_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jirô pê mã ri Roman catêjê nõ pê krĩ jõ pahhi jũrkwati ata wỳr Jeju to me mõ, ramã apẽ intuwti kam. Mã nee ikre ata mã Juta catêjê nõ xàr nare. Ampo na? Cute me amji to me amji kam hapac xàa na pê me hane. Quê ha ramã amji kĩn ata na ahtêp, quê ha nee Juta catêjê me, mehcahkrit catêjê atajê pê Juta catêjê nare atajê jũrkwa mã amencjêj nare. Ampo na? Cute amji kĩn ata japy ame amji to kên cupate. Na pê nee ikre ata mã Juta catêjê nõ hàr nare, cute ihtỳj me Hakren xà jõ atajê kur prãmte. ");
INSERT INTO ram_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mã Pirat pê Roman catêjê nõ pê krĩ jõ pahhi ata cator, põ mã, cute mehcajpar prãmte. Ne cute mehcajpar ne me cumã: — Hũmre ita jarẽn kên jũ to mã, ca ha ame imã harẽ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mã me cumã harẽn to: — Quê ihkên nare na mã, wa ha nee mehpro ne awỳr me to imõr nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mã Pirat me cumã: — Ca ha caa quêt, ate me amji kam me gapac xàa kôt, me ate me amji ton xàa kôt, mehcukij ne ihkên mã me amẽ — hane. Mã Juta catêjê me cumã: — Pom hũmre ita te ihkên xà ton xà ita ihtỳj ihcuran na awjahkre. Cakrô wa nee amjia kôt ite mehcuran xà nare, ne apêa ri pahhi, cwỳrjapê ca ha caa amji kampa, ne ihcuran na me imẽ, wa ha cormã mehcura — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ne pê ramã Jeju kỳj pê, pĩ na ajêt ne ihtyc to mõr na amji jarẽa na pê, Juta catêjê cakôc xà ata ramã cute amji jarẽn xà ata na to ipipẽ to mõ. ");
INSERT INTO ram_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mã hacpỹa mã Pirat xàr, hũrkwa mã, ne cute Jeju mã hàkjêr ne ihcukij to: — Xà apê Juta catêjê jõ Pahhi? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mã Jeju cumã: — Xà amjia kôt ate icukij xà ita to hajỹr? Nare jũmjê te amã ijarẽn xà kôt mã ca ate icukij ita to hajỹr? — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mã Pirat cumã: — Côt mã ca atỳj ipê Juta catêjê nõ na apu icãmjĩ? He me akwỳa kwỳ me, me hõ pahhi catêjê te ri imã me gõr. Ne mẽr ampo to mã ate jũ mãn? — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mã Jeju cumã: — He ihimpej xà ita pê nee pjê ita tekjê nare, ne quêt côjkwa kam ri ihimpej xà. Wa ha ipê pjê ita kam pahhi xà na mã, quê ha ramã ikôt me ipa catêjê ihtỳj itête me ajpu, Juta catêjê mã cute me ijõr to hajỹr cupate. Ne nee pjê ita kam ipê pahhi xà nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mã Pirat cumã: — Xà mẽr apê pahhi? — hane. Mã Jeju cumã: — Pom ca atea ita na ijarẽn ita? Ampeaj kam ri ipê Pahhi, ne ite catyt kam amji kam ijapac xà jarẽn to ipa xà caxuw, wa pjê ita wỳr icator, ne caxuaw pê wa ipỳm, ne pjê ita wỳr ajpên mõ. Ne por quê ha jũm ampeaj kam ite catyt kam amji kam ijapac xà ata na ito amji mã ihhimpej ata, quê ha ihtỳj ikôat amji to — hane. ");
INSERT INTO ram_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mã Pirat cumã: — Ne mẽr ampo pê mã “…ampeaj kam…” me “…catyt kam…” ita? — hane. Jirô pê mã ri hipêr Juta catêjê wỳr cator, cute me cumã ihcakôc prãmte, ne me cumã: — Wa nee ite hũmre ita curan xà caxuw kam ampo kên nõ mã icator nare. ");
INSERT INTO ram_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ne me Hakren xà jõ amji kĩn ita cunea kam wa hãn ne itỳj me amã me hacjên catêjê pyxit ne hapôj. Xà wa ha ajkĩ Juta catêjê jõ Pahhi ita mã hikra? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mã mehcunea ame caràr to: — Quê, nee ca cumã hikran nare, Parapa mã, ca ha hikra — hane. Ne por Parapa ata pê ri hàprêa kam me cupê ampo to pôj catê. ");
INSERT INTO ram_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mã Pirat te krãhtare kwỳ mã pryti kà kam wakỳre to Jeju cahhyr kêanre na harkwa. ");
INSERT INTO ram_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mã krãhtare te me to hapactu na me ajpẽn par, ne me amji mã: — Hacme, ne ame to pajapactu — hajỹr. Ne cute hômjĩ to me cumã pahhi krãhkà, ne ihkrã mã me haxàr. Ne cute me hõ pahhi kà intepti ata mã me haxàr, ne ahna me hãm, mã xa. ");
INSERT INTO ram_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mã hỹrmã me pra ne ahna me ahtêp ne me ahna xwỳ to: — Hàpà Juta catêjê jõ pahhi, ampeaj kam apej, ne ampeaj kam atỳj! — hane. Ne ajco me hũhkra krã to mehcahhy. ");
INSERT INTO ram_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mã hipêr me hàhtôti atajê wỳr Pirat cator, ne me cumã: — Me ikampa! Wa ha ajpên Jeju ita to mõ, ne me acuna mã hãm. Ne imãa ihhêj ne nee cute ampo kên ton nare, ite ihcuran xà caxuw. Ne mẽr ampo na wa ha ajte ihcura? — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mã Jeju cator, ne ihkrã na hômjĩ te me hõ pahhi krãhkà ata ajêt, mã ihkà intepti kam xa. Mã Pirat te me cumã harẽn to: — Nãmhã hũmre ita xa he! Me hõmpu, imãa ramã ihhêj ne cute amji pupun xà kêanre na amji pupun — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mã Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, cute me Pahpãm jũrkwa jamãr catêjê me, cute me Jeju pupun, ne me caràr kam me to ihtẽm, ne me caràr to: — Pĩ kam me axô! Pĩ kam me axô quê ty! — hane. Mã Pirat me cumã: — Wa nee ite kam ampo kên mã icator nare ita kam, wa nee ihcuran nare. Quê ha me amã ihcuran prãm na, ca ha me caa, ate amji kam me gapac xàa to me to mõ, ne pĩ kam me axô ne mehcura — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mã Juta catêjê me cumã: — Me icaca xà jõ kàhhôc kam, cute harẽn to: “Quê ha jũm te cupê Pahpãm kra na amji jarẽn na, quê ha ihtỳj mehcura” hajỹr. Cwỳrjapê ca ha atỳj ite mehcuran xà na me imẽ, wa ha mehcura — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mã Pirat te, Jeju te Pahpãm kra na amji jarẽn na, me harẽn par, ne ampeaj kam cumã hũpa. ");
INSERT INTO ram_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mã ma hacpỹ mã hũrkwa mã hàr, ne cute Jeju cukij to: — Jũ pĩn mã ca ajte acator? — hajỹr. Mã nee Jeju te cumã jũ mãn nare. ");
INSERT INTO ram_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mã Pirat te cumã harkwa to: — Xà amã imã acakôc prãm nare? He xà amã itỳj ite acuran xà me, amã hikran xà na, apê ijahkre kêatre? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mã Jeju cumã: — Quê ha kỳj rũm côjkwa kam Inxũ pĩn ate ito hajỹr xà ita caxuw amã acarôt cator nare na mã, ca ha nee ito jũ mãn nare. Ne por jũmjê te amã ijõr atajê te ri girôa pê ito kêanre — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mã Pirat te ihcakôc xà ata na kam hapac, cwỳrjapê ri ihtỳj cumã Jeju mã hikran prãm cakrô, mã Juta catêjê ame cumã caràr to: — Ca ha ate cumã hikran na, ca ha nee ramã apê pjê cunea jõ pahhiti pê Xexa ata jõ ikwỳ nõ nare! Ne por jũm amã cupê pahhi na amji jarẽ ata pê ri gõ pahhiti, ne cupê Xexa curê xwỳn! — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mã Pirat te ita kam hapac, ne põ mã Jeju to cator. Por põ pê kẽn te ihcahty, mã Juta catêjê te me harkwa na me cumã haprỳ to Capata ata wỳr Jeju to cator, mã xa. Mã Pirat te ihkrĩ xà kam mehkên catêjê cukij xà ata kam hỹr, cute Jeju kên mã mẽn xà caxuw. ");
INSERT INTO ram_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ne pê amcro ata kam, cute me Hakren xà jõ amji kĩn kam me to ihtẽm xwỳjrea na, ramã pyt ajmãr me pahkrã jimoac kam hỹr kam pê me to hane. Mã Pirat te Juta catêjê mã hũjarẽn to: — Ihnãm hã, me gõ Pahhi xa he! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mã cute me caràr to: — Quê ha ty! Pĩ kam me axô, quê ty! — hajỹr ita na. Mã Pirat me cumã: — Xà me amã pĩ na me gõ Pahhi ita xôr, mã kam ihtyc na to prãm? — hane. Mã Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ te me cumã harkwa to: — Me imã Roman jõ krĩ kam, pjê cunea jõ pahhiti pê Xexa pê me ijõ pahhiti ata pyxit peaj. Na ri nee iràn xà na me imã me ijõ pahhi nõ hamreare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mã hamre Pirat te pĩ na cute me Jeju xôr xà caxuw me cumã hõr, mã ma me to mõ. Ne cute me Jeju mã pĩhti catia te amji kam ihcapa ata jõr. ");
INSERT INTO ram_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ne ma kẽn nõ ata wỳr me to mõ. Ne Juta catêjê jarkwa na kẽn ata japrỳ te Corcota, ne ihkôt harẽn xà te “Mehkrãhhi jõ kẽn”. Mã ma cute hõ pĩhti ata pỳn ne cupjê. ");
INSERT INTO ram_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mã curi me to cator, ne cute pĩ na me hir, ne ahna hũhkra me ihpar kam wakỳre cuhhêc, ne ahna me hãm, mã kỳaj pê kam ajêt. Ne hanea ne cute ihkôt me hũmre to me ipijakrut, ne hajỹar ne ajtea me hõ pĩa kam me haxôr, ne ahna me hũxwỳr. Mã Jeju mehcote na ajêt, mã cute me hũjê ne me to ajêt. ");
INSERT INTO ram_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mã Pirat te Jeju na ihkàhhôc jipêj, ne cute ihkrã cwỳrpê pĩ na inxôr na hũjahkre. Ne pê krĩxàre incrê jarkwa na ihhôc atajê pê Juta catêjê jarkwa me, Roman catêjê jarkwa me, Crec catêjê jarkwa. Ne ihkàhhôc ata hũjarẽn to: — Naxare jõ krĩ pĩn hũmre pê Jeju cator, ita pê ri Juta catêjê jõ Pahhi — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pom curi cute pĩ na me Jeju xôr ata, krĩ na pire mã, na ri ihtỳj Juta catêjê jàhtôa ne cute mehkàhhôc ata cahyt. ");
INSERT INTO ram_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mã Pahpãm mã mehcajrẽn catêjê jõ pahhi catêjê te Pirat mã ihkàhhôc ata to mehhimpej to: — Pom ate ahna ihhôc to: “Cupê Juta Catêjê Jõ Pahhiti” hajỹr to ita ca ha antuw, ne “Cutea amji jarẽn to, ‘Ipê Juta Catêjê Jõ Pahhiti’ ” hajỹr na, ca ha ihhôc — hajỹr. Mã Pirat me cumã: ");
INSERT INTO ram_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","— Pom wa ite ahna ihhôc ita, quê ha hàhhuc rohnỳtti mã — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mã krãhtare atajê te pĩ na me Jeju cakrô inxôr, mã ihcakrô ajêt. Jirô pê mã ri cute me cwat itajê te ahpỹanre na ihkà to me amji tỳj. Ne hanea ne cute me ihkà te ihpar kõn na iwrỳc tu ata pyr. ");
INSERT INTO ram_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ne cute me ajpẽn par to: — Cu ha nee ame ihkà impejti pijapỳn xà nare ita cokjêr nare, ne cama kẽn to ihkôt me amji pê hũhkà. Ne me pahnõ te amji pê to hũhkàr na, cu ha me pahnõ amji mã ihcunea na cupy — hajỹr. Hõ, pê ramã Pahpãm jõ kàhhôc ita jarẽan xà na pê hane, pê harẽn to: “Cute ikà to me amji tỳj, ne ihkôt kẽn to ame amji pê hũhkà” hane. Ne ampeaj kam pê cute harẽn xà ata. Na ri krãhtare te hahkre pej nare kam ihtỳj ton. ");
INSERT INTO ram_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mã pĩ na Jeju ajêt ata krac ri cuna mã wa Jeju menxi me, ihtõj xa, mã hanea ne me cahi na Marij Matarkwỳj me, Marij nõ pê Cropa me hĩxi ata, hanea ne xa. ");
INSERT INTO ram_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mã Jeju te ipupun, ne icahê na inxi pupun, ne cumã: — Inxê, por ijaxà kam acahê na akra xa ata — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne imã: — Jowãw, por ana acahê na xa ata — hane. Cwỳrjapê wa ite ahna amji caxàr, mã ijũrkwa kam hõtpê icahê na ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jirô pê mã ri Jeju te ramã pjê kam hàpên xà cunea jipêj na amji jahkre pej, na ri cute harkwa to: — Ampeaj kam imã kôr — hajỹr. Ne pê ramã Pahpãm jõ kàhhôc harkwa jarẽan xà na ri cute ihcakôc xà ita to hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mã curia ampo cacô xwa xỳre na kyre pê hĩ ahwỳ ata xa, mã cute ampo pĩhhê nõ na, me ampo rerecti ita xôr, ne me to inco, ne Jeju jarkwa mã me haxàr. ");
INSERT INTO ram_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mã cute to ihkõm ne harkwa to: — Hamre, ramã ite ijàpên xà cunea jipêj, mã hamre! — hajỹr. Ne pea imput pec to mõ ne ihtyc. ");
INSERT INTO ram_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mã Juta catêjê te Pirat na me hàhwỳr, quê me hũmre incrê ne pĩ na me harij atajê te kẽhkẽ, mãr quê cyt ne amehtyc pa, quê pĩ pê me to irôrôc pa. Ampo na? Ramã mehkôt xà jõ amcroa kam hàhhuc to mõ, na ri ma apu pĩ kam me jũmjê tyc ne ame harij na ame to ihcaca. Ampo na? Por ajpên iràrà mõ ata na ri ramã cute me amji kĩn catia kam me to ihtẽm xà. Na ri Pirat te mehte kẽhkẽn na hõ krãhtare mã harkwa kujahêc. ");
INSERT INTO ram_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mã krãhtare te, por pĩ kam ame harij atajê te kẽhkẽn. Ne mam cute, por cute me ipijakrut to me Jeju jũjê atajê nõ te kwĩn, ne ihkôt cute me ita te kwĩn. ");
INSERT INTO ram_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jirô pê mã ri ma Jeju wỳr me mõ, ne ahna me hàhtêp ne cute me hõmpun, mã ramã ihtyc tu ne ajêt. Cwỳrjapê ri nee cute mehte kwĩn nare. ");
INSERT INTO ram_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mã krãhtare nõ te hõ kruwxwa to Jeju jĩpê kam caxwỳr, ne cumã caxàr, mã ihkôt mare mã caprô me cô ajxwỳ. ");
INSERT INTO ram_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","He wa ite ito ita to hõmpun, na wa ite ihkàhhôc ita kam me amã harẽn, mãr ca hanea ne me kampa, ne catyt kam Jeju to amji mã me ahimpej. He wa nee ame amã ihêj xi jarẽn nare. ");
INSERT INTO ram_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pê Pahpãm jõ kàhhôc Jeju jarẽn to: — Quê ha nee ahi nõ impàt nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ne pê hanea ne kam harẽn to: — Quê ha me, por kruwxwa to cute me jũm caxwỳr ata pupu — hane, ata na ri cute hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ne pê Joje pê Krĩhkàhti jõ krĩ catêjê nõ ata mã, Juta catêjê jõ pahhi kwỳ cupa, na pê aracri cupê Jeju kôt ipa catê. Mã cator ne cute Jeju jĩ na Pirat wỳr. Mã Pirat te cumã hahkre. Mã ma Joje tẽ. Mã ma ihkôt, por pê caxwa ri Nicotem mõ ne Jeju pupu ata tẽ, ne cute pĩ pê me Jeju jĩ caxàr. ");
INSERT INTO ram_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ne Nicotem ata ampo pĩ pàrkà cuxwati ata me, ampo pĩhhô pê ràm cuxwa pyràcti ata pỳ, ne to kwỳ ata pê hũtĩ trĩnta quir. ");
INSERT INTO ram_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ne me hũmre pijakrut atajê te me Jeju jĩ na hàhwỳr, ne ma me to kwỳ, ne cute ampo kà ata me, ihnõ cuxwa pê ràm cuxwa pyràcti ata to me Jeju cunea cukên, ne cupẽhkà jakati impejti to mehcupu. Hõhõ, pê Juta catêjê cute me amji jarêt xà caxuw ajco me amji to hane. ");
INSERT INTO ram_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ne por pê curi pĩ na me Jeju xô ata cahê na, pĩxô jõ pjê kam, cute me amji jarêt xà caxuw kẽn kre tuwti nõ ata, mã rỳ nee jũm te kam amji jarêt nare. ");
INSERT INTO ram_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ne pê Juta catêjê mã amcro te amji mã incjêj xà pê, ajco pytre kam ajpẽn mã acjêj. Ne caxwa pê, pê ajco ramã amcro intuw amji mã acjêj. Ne ma apu amji kĩn kam mehkôt xà kam mehtyc to me hàpên tête me ajpẽn mã. Na pê me hũjarêan kam pĩxô jõ pjê kam kẽn kre nõ ata kam, me Jeju jĩ xi. ");
INSERT INTO ram_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mã mehkôt xà jõ amcro jirô pê, tômĩc na, iràràtia na cormã ahkũmti kam, ma Marij Matarkwỳj kre wỳr tẽ. Ne cute, por kẽn to cute me Jeju kre jarkwa jihê ata pupun, mã ajte hihê mẽn na xa. ");
INSERT INTO ram_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mã cute hõmpun ne ma Petrô me, iwỳr ipicahur. Ne me iwỳr cator ne cute me imã hũjarẽn to: — Cute kre pĩn me pajõ Pahhi jĩ caxàr ne jũ ri me hir! — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Wa ma Petrô me ajwar kẽn kre wỳr me ipicahur, waite irer ne mam kre wỳr icator. ");
INSERT INTO ram_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ne kẽn kre jarkwa mã inõr, ne tee apu Jeju jĩ japê, ne nee ite hõmpun nare. Ne ite cupẽhkà pit pupun, ne nee hỹrmã ixàr nare. ");
INSERT INTO ram_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mã hapu na ikôt Petrô tẽ ne cator, ne ma kre mã hàr. Ne cute cupẽhkà pit pupun, nõr xà kam. ");
INSERT INTO ram_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ne hanea ne, por pê cupẽhkà ihkrã jarij ata, curia hakàn pê ajtea ihkrã pejti ne nõ. ");
INSERT INTO ram_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wa hanea ne ihkôt ixàr ne ite cupẽhkà pit pupun, ne ite hacpỹa mã Jeju tĩr na amji mã to hajỹr pyrentu. ");
INSERT INTO ram_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ne nee ajte cormã me Pahpãm jõ kàhhôc kam cute harẽn xà to: “Quê ha ihtỳj hacpỹa mã Jeju ihtĩr” hajỹr ata na ihkôt me hakop to impej nare. ");
INSERT INTO ram_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ne ma hacpỹ mã ikre wỳr ite me amji jaxàr. ");
INSERT INTO ram_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Mã Marij Matarkwỳj curia xa ne põ pê apu amrã. Mã aracri ramã côjkwa pĩn Pahpãm mã memprar catêjê pijakrut ne Jeju nõr xà kam me jỹ. Mã Marij Matarkwỳj te Jeju japên prãmte kre mã nõr, ne cute Pahpãm mã memprar catêjê pupun. Mã ihkrã nõr xà kam ita jỹ, mã ita ihpar nõr xà kam jỹ, mehkà jakati kam, cute me hũjê ne me to jỹ. ");
INSERT INTO ram_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne cute me Marij cukij to: — Ampo na mã ca apu amrã? — hajỹr. Mã me cumã: — Jũ kam cute me ijõ Pahhi jĩ caxàr ne me to tẽ, ne jũ ri mõrmõ cute me hir, ipê hir xà na hahkre kêatre! — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ne cute me cumã ita jarẽn jirô pê mã ri ipipkjêr ne cute Jeju pupun, mã xa, mã nee cute cupê Jeju na hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mã cute ihcukij to: — Ampo na mã ca apu amrã? Ne jũm mã ca apu hapê? — hajỹr. Mã ihtỳj apu to pĩxô jõ pjê jamãr catêjê nõ, ne cumã: — Ca ha ate mãn caxàr ne jũ ri hir na, ca ha imã harẽ, wa ha capa ne hacpỹa mã kẽn kre wỳr to mõ — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mã Jeju cumã: — Marij — hane. Mã hỹrmã ipipkjêr, ne cute Juta catêjê jarkwa na cumã: — Rapõn! — hane, ne Rapõn ita jũjarẽn xà te “Ikrã tũmti!” ");
INSERT INTO ram_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mã Jeju cumã: — Nee ca icupên nare, nãmri wa cormã nee Inxũ wỳr ijàpir nare. Ne cama atẽm pyrentu ne me ikjêjê mã ijarẽn to: “Wa ha ma Inxũ pê me Apãm, pê ijõ Pahhiti pê me gõ Pahhiti wỳr tẽ” — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mã ma Marij ihtẽm pyrentu, ne cute me imã hũjarẽn to: — Wa ite me pajõ Pahhi pupun — hajỹr. Ne cute me imã Jeju te cumã harkwa hyr xà atajê jarẽn par. ");
INSERT INTO ram_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mã amcro ata na, me ipê Jeju kôt me ipa catêjê te ramã caxwa ryre kam me cuprõn, ne ite amji na me to harkwa jihê, Juta catêjê kwỳ cupate. Mã ihprõt pê, krãa, me iwỳr Jeju cator ne me icote na xa, ne me imã: — Hàpà, mãr me apeaj? Nee ca icupate ame akrihkrit nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jirô pê mã ri cute me imã hũhkra me hĩpê caxwỳr xwakre jahkre, wa ite me hõmpun, ne ampeaj kam hũrên me ijakry. ");
INSERT INTO ram_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mã hipêr Jeju me imã: — Inxũ mã, me amã ampo cupa nare na me ato prãm. Ampo na? Pom ahnaa mã Inxũ te ajpên ikujahêc ita na, wa ha me ato, ne pjê cunea kôt ame acrà ne ame akujate — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jirô pê mã ri cute me icunea jakôr, ne me imã harkwa to: — Imã me ate me Inxũ Carõ Pejti incwỳr na me ato prãm. ");
INSERT INTO ram_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na ca ha me cumã acakôc ne ijaprỳa na me cumã acakôc. Ne ita caxuw, ca ha ate jũm te Inxũ Cati to kên ata mã: “Ca ate Pahpãm to kên ata, cute to tojnõ ne hicu” hajỹr na, quê ha Inxũ Cati acuxà ihtỳj cute to kên ata to tojnõ ne hicu. Nãmri ca ha ate jũm mã: “Pahpãm te nee ate to kên xà ata to tojnõ ne hicu nare” hajỹr na, quê ha Inxũ Cati acuxà, garkwa kôt nee to tojnõ ne hicu nare — hajỹr, ne curia hamre, ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ne me iwỳr Jeju cator xà ata kam, ne pê nee me ijõ ikwỳ nõ japrỳ te Tome pê, por ajkrut ne ihpỳm ata, ame icahê na mõr nare, ne jũ ri apu mõ. ");
INSERT INTO ram_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Na wa ite me cumã ijũjarẽn to: — Wa ite me pajõ Pahhi pupun! — hajỹr. Mã me imã: — Wa ha nee ate me imã gũjarẽn xà ita kam ijapac ne amji mã to hajỹr nare. Ne xa hũhkra caxwỳr xwakre pupu, ne kam ijũhkrahhi xi, ne hĩpê caxwỳr xà kôt ijũ jaxà ne ihcupê, ne cormã ita na amji mã to hane — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mã me ina amcro te xet, wa hacpỹa mã ite me cuprõn, mã ita caxuw curia hanea ne me icahê na Tome apu mõ. Wa ite me to harkwa cunea jihê partu cakrô, mã krãa, Jeju me ijipôc ri cator ne xa, ne me imã: — Hàpà, mãr me apeaj? Nee ca icupate ame akrihkrit nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne Tome mã: — Tome, mẽr ijũhkra pupu ne caxwỳr xà xwakre mã gũhkrahhi jaxà ne to ihcupê. Ne ijĩpê caxwỳr xà xwakre mã gũ jaxà ne ihcupê ne ijahkre pej. Nãmhã ne gàprãr xi ita mã hikra, ne ito ca amji mã ahimpej! — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mã Tome cumã: — Apê ijõ Pahhiti pê Pahpãm — hane. ");
INSERT INTO ram_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mã Jeju cumã: — Ca ate ato jĩa to ipupun, cwỳrjapê mã ca cormã ate ito amji mã ahimpej. Por jũmjê me ipupun nare kam ihtỳj ito amji mã mehhimpej atajê ri ampeaj kam me hakry! — hane, jirô pê mã ri hamre ne ma tẽ. ");
INSERT INTO ram_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ỹhỹ, he me ikam mare mã Jeju te Hũm carôt kôt hàpên xà pihho catia jàhtôa ne ton atajê, wa nee ite me amã ihkàhhôc ita kam nõr nare. ");
INSERT INTO ram_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ne pom ca ame cahyt itajê, wa ite ihkàhhôc ita kam me amã nõr partu, mãr ca ate me Jeju Crixtô pê Pahpãm kra, mã cute me pahpytàr catê na me pamã to hũjahkre ata to, ate amji mã me ahimpej prãmte, wa ite ahna me amã ihhôc. Ampo na? He ca ha ate Jeju to amji mã me ahimpej na, ca ha atỳj cukwa kam Pahpãm cahê na amji to me apijapar rohnỳtti mã. ");
INSERT INTO ram_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jirô pê mã ri Jeju te me ipê ihkôt me ipa catêjê mã hipêr amji to ipipẽ, Hĩpôjajo jõ pjê pê Tiperij jõ krĩ ata cahê na. Hõ, pê hane. ");
INSERT INTO ram_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ite me xet itajê wa ame ipa he: Wa itõ pê Tijac me ipê Xeptew kra me, Ximãw Petrô me, Tome pê ajkrut ne ihpỳm ata me, Têtêc jõ krĩ pĩn Natanew cator ata me, me ikwỳa kwỳ pijakrut atajê me. ");
INSERT INTO ram_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mã Ximãw Petrô te me imã: — Wa ha ma mõ ne tep pro xà to ihnõ pro — hajỹr. Wa me cumã: — Wa ha hanea ne me akôt me to ihnõ pro — hane. Ne ma me icunea me mõ, ne pàr kre mã me ixàr. Ne caxwa ri ihpro xà to ite me hapêan to apẽ, ne nee ite me to ihnõ pro nare. ");
INSERT INTO ram_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mã ramã apẽ to mõ, mã ramã xãmte aracri Jeju cô tohkà na xa. Wa nee ite me cupê Jeju na hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mã me imã caràr to: — Hàpà me hũmre itajê? Ampo ca ate me to ihpro? — hane. Wa me cumã: — Hamreare, wa tee ite me to hapêan to apẽ, ne nee ite me to ihnõ pro nare — hane. ");
INSERT INTO ram_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mã Jeju me imã: — Mẽr cô kam awpôc rũm, pàr kre jĩkjê rũm me gõ tep pro xà ita to me awcapê, ca ha atỳj me to ihkwỳ pro — hane. Wa ite cô kam me ijõ kryhti to me ijũcapêr, ne ite me to ihkjên, ne nee hacpỹ ne pàr kre wỳr me to ijàpir nare. Ampo na? Ampeaj kam, tep itajê cati ne hàhtô, na ri hũtĩ. ");
INSERT INTO ram_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wa ite Petrô mã ijarkwa to: — He me pajõ Pahhiti pê Jejua ri xa! — hajỹr. Mã Ximãw Petrô ihcakrô apu kwỳ ne cute Jeju jarẽn par, ne hitô kàhti ata mã amji jaxàr, ne ma mrõr ne ihpa na kwỳ ne ma Jeju wỳr cô tohkà na cator. ");
INSERT INTO ram_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wa ma hapu na me ikwỳ me pàr kre to ajpên me tep na, ihpro xà kjên to me mõ, por hỹrmã hũwry na me pajara capô te xĩncwẽnta ata wỳr, ne hỹrmã me to icator. ");
INSERT INTO ram_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ne põ mã pàr kre pê me ijapôj pê, ite me cuhy prà kam tep kwỳ krĩ na me hõmpun. Ne hanea ne ite me pãw pupun, mã hikwa. ");
INSERT INTO ram_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mã Jeju me imã: — Ajpên me imã, pom curmã ate me to tep pro itajê kwỳ to tẽ — hane. ");
INSERT INTO ram_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mã ma Ximãw Petrô pàr kre mã hàr, ne cute hõ na tep pro xà mã hê, ne ajêt ata mã hê pôn, ne ma pjê wỳr to hàpir. Mã kam tep cati pit jàhtô na cute xẽj ne ihkôt xĩncwẽnta ne ihkôt incrê ne to hipu tu, ne nee ajte cute tep pro xà ata jipôn nare. ");
INSERT INTO ram_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mã Jeju me imã: — Ajpên me mõ ne me apà — hane. Wa ramã ite cupê me ijõ Pahhiti na me hahkre pej. Ne hũpate, nee me inõ te cupê jũm ata na ihcukij nare. ");
INSERT INTO ram_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mã Jeju te me imã pãw me tep ata kryj, ne ahpỹanre na me imã hõr par. ");
INSERT INTO ram_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hõ, pê Jeju hacpỹ mã ihtĩr jirô pê me imã amji to ipipẽ to incrê to hane. ");
INSERT INTO ram_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wa me ijàpàn jirô pê mã ri Jeju te amji na Ximãw Petrô cukij to incrê ne cumã: — Ỹhỹ Ximãw Petrô pê Jowãw kra ita, xà ajkĩ me akwỳ jirôa pê amã ikĩn? — hajỹr. Mã Ximãw cumã: — Ỹhỹ ijõ Pahhi, imã akĩn na ramã atea ijahkre pej — hane. Mã Jeju cumã: — Ỹhỹ, ca ha me cupê ijahkre kêatre, mã nee cute me ipupun nare atajê mã ijarẽ, ne me cumã ijarkwa gõ. Ampo na? He me cupê carà cahàcre hôhti kra pê hamãr catê nare ata pyràac, ne amjia kôt ikaj na ame ipa — hane. ");
INSERT INTO ram_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ne cute ihcukij to ipijakrut ita kam ri hipêr cumã: — Ximãw xà ajkĩ ampeaj kam amã ikĩn? — hajỹr. Mã Petrô cumã: — Ỹhỹ ijõ Pahhi, imã akĩn na ramã atea ijahkre pej — hane. Mã Jeju cumã: — Ca ha me ikwỳ pê carà cahàcre pyràc pê hamãr catê nare atajê to amji pytà ne me hamã — hane. ");
INSERT INTO ram_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne hipêr Jeju te ihcukij to: — Ximãw, xà ajkĩ ampeaj kam amã ikĩn? — hajỹr. Mã Petrô mã amji kĩn nare, mã apu ihpec. Ampo na? Nee mã ampo na nare, Jeju te cumã ihkĩn na ihcukij to incrê, na ri cumã amji kĩn nare, mã cumã: — Ijõ Pahhi, amã ampo cunea jahkre pej, na ri atỳj amã ite akĩn na ijahkre pej! — hane. Mã Jeju cumã: — Ca ha me ikwỳ pê carà cahàcre pyràc pê hamãr catê nare atajê to amji pytà ne me hamã. ");
INSERT INTO ram_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","— Ỹhỹ, wa ha amã awjarẽ, pê ca atuwre na, ajco akà to amji cũmpej, ne ma jũ ri amã amõr xà na ihprãmti ata wỳr ajco pra. Ne ampeaj kam wa ha ita caxuw amã awjarẽ. Ca ha awej, quê ha jũmjê gara cajpre, ne jũ ri amã amõr prãm nare, ne hỹrmã gitõtti ata wỳr me ato mõ — hane. ");
INSERT INTO ram_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pê Jeju hũjarẽn xà ata to ramã Petrô mã, jũ caxuw cute mehcuran xà ata to hahkre. Ne quê ha Jeju cwỳrjapê Petrô tyc xà ata kôt, quê ha mehcunea me Pahpãm cati na me hahkre pej. Ne cute Petrô mã: — Ita caxuw ca ha ito pit mã amji mã ahimpej, ne ikôat apa! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mã hacpỹ mã Petrô pipkjêr ne amji jõ kôt cute ipupun. Ne pê ramã Petrô mã Jeju mã ikĩnti na ijahkre pej. Ampo na? He pê wa me Hakren xà jõ amji kĩn na me ijàpàn xà na cahê na jỹ ne ihcukij to: “Jũm mã quê ha ajte akên mã amẽ?” hane cwỳrjapê. ");
INSERT INTO ram_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mã Petrô te ipupun, ne ina Jeju cukij to: — Pahhi, ne mẽr hũmre ita, jũ mã quê ha ajte? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mã Jeju cumã: — Quê imã ihtĩr ita na ipa, wa ahnaa hacpỹ ne ite amji jaxàr na to prãm na mã, quê ihtỳj ipa, ca ha nee ahna ihho nare. Ne ca, ca ha ito pit mã amji mã ahimpej to apa — hane. ");
INSERT INTO ram_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mã Jeju kôt me ipa catêjê te amji mã me ijarẽn cràn, Jeju te xwahna ityc xà nare na ijarẽn ata na. Ne nee cute harẽn to hajỹr nare. Ne nee ito Petrô mã: — Quê ha nee Jowãw ihtyc nare — hajỹr nare. Ne cama cute ijarẽn to hajỹr he: — Quê imã ihtĩr ita na ipa, wa ahnaa hacpỹ ne ite amji jaxàr na to prãm na mã, quê ihtỳj ihtĩr ita na ipa, ca ha nee ahna ihho nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","He ipê Jowãw, pê wa ito ita jĩa to ampo itajê pupu, ne impar xàa na wa ite ahna pit mã me amã ihhôc par. Ne ramã ate me ipupun pejtu, ihêj xi nare na, na ri ampeaj kam cute hajỹr. ");
INSERT INTO ram_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ne cormã Jeju te ampo jàhtôa ne ton atajê, wa nee ite ihkàhhôc ita kam ahna ihhôc nare. Quê jũm ahna ihhôc na mã, quê ha nee pjê cunea kam ihkàhhôc itajê nõ hàhtô na cahuc nare. Hamre.");
INSERT INTO ram_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ỹhỹ, Tejopir, ipê Ruc, ne pa wa ha amã ihhôc. Ne wa ramã ite mam amã ijõ kàhhôc ita kujahêc. Pom pê Jeju ampo to, ne me cumã to hahkre itajê na wa ite ihhôc, ne amã ihkujahêc. ");
INSERT INTO ram_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ne pê mam Jeju cato pjê ita kam, ne ajco hàpên xà ton to ipa, pê ma Pahpãm côjkwa wỳr to api, na wa ite amã ahna ihhôc, ne amã ihkujahêc. Ne hàpir xà xwỳjrea na cute ihkôt me ipa catêjê mãn, Pahpãm Carõ Pejti jarkwa kôt, mãr quê harkwa na cumã memprar catêjê na me ipa. ");
INSERT INTO ram_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ne pê Jeju ihtyc jirô pê hacpỹa mã ihtĩr, ne ihtĩar na cute mehcunea mã amji to ipipẽ to amcro to cwarẽnta. Mã ihkôt me ipa catêjê te me hõmpun, ne Pahpãm himpej xà ata to me cumã ihcakôc. ");
INSERT INTO ram_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ne amcro ata na, hacpỹa mã Jeju tĩr jirô pê mã, ihkôt me ipa catêjê me, mehkrĩ ne ame apà. Mã cute me cumãn to: — Ita ri, Krĩpinkrên kam me ahtwỳ, ne ita ri Inxũ Cati te me amã ampo to hũjahkre, wa ite me amã harẽn atajê jikaj, mãr quê me amã cugõ, quê ame ato ihtỳj. ");
INSERT INTO ram_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ne hõtpê Jowãw te cô kam me acumrãr, ne quê ha me ana ahtũm nare, quê ha Pahpãm amji Carõ Pejti carôt kam me acumrã. Ne me amã carôt gõ, ca ha Carõ Pejti carôt kam me atỳjti ne — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mã ihkôt me ipa catêjê te cormã ahna me cuprõn tu ne mehcukij, ne me cumã: — Xà ita kam, quê ha Pahpãm pjê ita kam, Juta catêjê to ihhimpej kam tẽ? — hane. ");
INSERT INTO ram_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mã Jeju me cumã: — Nee ate me hahkre pej xà nare. Ne Inxũ Cati mã ri cutea amji mã amcro hyr xà ata jahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ne quê ha Pahpãm me amã Carõ Pejti carôt gõ, ca ha me acwa ne me to apa, quê ha taa me ato ihhimpej, ne me ato atỳjti ne. Ne ita caxuw ca ha me apê ijarẽn catêjê. Na ca ha ita caxuw Krĩpinkrên me, Juta jõ pjê me, Krĩrĩtpej jõ pjê me, pjê cunea kam amũ pjê jũwry catia kam me ijarẽn to me apa ― hane. ");
INSERT INTO ram_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ne pê Jeju ita jarẽn jirô pê mã me kam mare mã ma côjkwa wỳr hàpir to mõ. Mã hamre, ahcakrã te cutor, mã nee hipêr cute me hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ne cama me xa ne Jeju jàpir xà na, côjkwa wỳr, kàj mã me ahna ahcakrã pupu. Mã ihprõt pê me hũmre pijakrut ne mehkà jakati kam me xa, me cahê na, ne cute me cumã harkwa to: ");
INSERT INTO ram_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","— Hĩpôjajo jõ pjê catêjê, ampo na mã ca me acuhhê ne côjkwa wỳr ame rĩt? Por Jeju ame acahê na mõ ata, ma côjkwa wỳr tẽ, ne quê ha ihtỳj jũ caxuw amji jaxà, ne hàpir xà ita na, quê ha amji jaxà ne wrỳ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mã ma Jeju jarkwa na memprar catêjê te Pĩxô jõ kẽn pĩn hacpỹa mã hũ na pire mã, Krĩpinkrên xa ata wỳr, me amji jaxàr. ");
INSERT INTO ram_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","19","Ne krĩ kam me cator, ne ma kỳj pê me hàhhuc xà ata wỳr me mõ, ne cute me cuprõn ne kam me hàhhuc. Curi Petrô me, Jowãw me, Tijac me, Antre me, Pirip me, Tome me, Partômew me, Matew me, Tijac pê Arpew kra me, Ximãw mã hõ pjê kĩnti ita me, Juta pê Tijac kra me, Jeju menxi me, mehkjêjê me, pyjê kwỳ me cute me cuprõn. Ne curia mehkrĩ, ne hõtpê Pahpãm mã mehcakôc. Ne pê Juta Carijot xwỳ, Jeju pro jahpan xà na ihpore py ata to pjê japrô. Ne pjê ita kam pê ihpỳm, ne apu amji kẽhkẽ, ne ihcahti na hĩn apu hapôj, ne ty. Pê Krĩpinkrên kam, mehkrĩ atajê cunea me ita pa, ne me hahkre pej. Cwỳrjapê pê me pjê ita mã haprỳ to, Purcaprô jõ pjê. Ne me ahna amcro jàhtô nare, mã Jeju na mehkwỳ jàhtô na cute me xẽj ne ihkôt cute winti ne me cuprõn. Mã Petrô xãm ne cute me cumã harkwa to: — Me ikjêjê, wa ha me amã Juta xwỳ ata jarẽ. Juta ata pê amji kôt jũmjê to mõ, cute me Jeju pro, ne mehcuran prãmte. Ne pê cupê me pahkwỳ nõ, ne ihtỳj ajco me pahcape na me pajàpên xà ita to apê. ");
INSERT INTO ram_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","— Pê Tawi xwỳ rỳ pêa mã Pahpãm Carõ Pejti jarkwa kôt Juta na ihhôc, pê Pahpãm ramã ita to amji kampa. Ampo na? He ita na pê cumã to prãm. Pê cute to prãm xà ata na ihkên mã axà, ne ty. Pê Tawi xwỳ Juta na ihhôc to hane he: “Quê ha hũrkwa jicu, quê ha nee jũm kam ihkrĩ nare” hane. Ne ihhô nõ kam hanea ne ahna ihhôc to hane he: “Quê ha ihtỳj jũm haxà kam axà, ne hàpên xà ita to apê” hane. ");
INSERT INTO ram_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Cwỳrjapê cu ha me jũm xũmre capi, quê jũm axà, ne haxà kam hacpỹa mã Jeju tĩr na harẽn to ipa. Pê cu me pahnõ cumã kaat kam Jowãw te cô kam mehcumrãr na hõmpu, mã ahnaa ihtyc, ne hacpỹa mã hàpir na me pahnõ te hõmpun ata, cu ha me capi, quê Jeju mã imprar catê na axà — hane. ");
INSERT INTO ram_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mã cute me hũmre pijakrut mã me cator, ita japrỳ te Joje Parxap, ne haprỳ krut te Catytkam, ne hanea ne ihnõ ita japrỳ te Matij. ");
INSERT INTO ram_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Mã cute me ahna Pahpãm mã mehcakôc, ne me cumã: — Me ijõ Inxũ Cati, ca ha ca me imã me icaca xà cunea pupu. Ne me imã to hahkre, me ipijakrut itajê nõ ca ha amji mã capi, ne to me imã hahkre, quê jũm me ikôt apê, ne jũm akra jarkwa na imprar catê na ipa. Nãmri Juta te ampo kêanre ton, ne me gàpên xà ita pê ihpỳm, ne ihtyc, ne ma ihkrĩ xà kêanre ata wỳr tẽ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ita jirô pê mã ri, cute amji to me hỹr, ne cute me ipijakrut itajê nõ capi. Ne hamre, mehkwỳ te me hũmre nõ ita pyxit ne me capi, ata japrỳ te Matij, mã cute Juta xwỳ jaxà kam Jeju jarkwa na cumã memprar catêjê mã me haxàr. ");
INSERT INTO ram_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ramã me Hõ Kẽhkẽn xà jõ amji kĩn jõ amcroa kam hàhhuc, mã Jeju na mehkwỳ te me cuprõn xà ata kam me cuprõn. ");
INSERT INTO ram_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mã ihprõt pê côjkwa pĩn, krã, ampo jàhkrihkrit pê kôcti jàhkrihkrit pyràacti ata cator. Ne hàhkrihkrit ata te ikre kam me jỹ atajê cunea mã amji jõr. ");
INSERT INTO ram_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mã cute me ihpôc pê cuhy pôc te cajõhjõtre pyràcre ata pupun. Mã apu ihcahkũm ne cute ahpỹanre na mehtàt par. ");
INSERT INTO ram_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mã Pahpãm Carõ Pejti carôt te mehcunea to hipu. Ne cute ahpỹanre na me cumã mehcakôc xà jõr par. Na ri cute mehcakôc xà cunea to mehcakôc kam me to ihtẽm. ");
INSERT INTO ram_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mã curi Krĩpinkrên kam Juta catêjê jàhtôa ne me hàhhuc atajê, hõtpê Pahpãm to me amji kampa. Ne pê pjê cunea rũm hũwry catia rũm ajco me hapôj, amji kĩn ata wỳr. ");
INSERT INTO ram_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ne cute me ampo jàhkrihkritti ata par, ne hỹrmã me cuprõn. Ne mehcunea te amji mã me ipikrar. Ampo na? He pê ihtỳj mehcunea me amji cakôac kampa, na pê me cupê hahkre kêatre. ");
INSERT INTO ram_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mã me hàhtôti itajê cunea te amji mã me ipikrar, ne mehkrã pictor tu, ne ajpẽn mã me harẽn to: — Pom me hũmre itajê pê Hĩpôjajo jõ pjê catêjê na ri amehcakôc. ");
INSERT INTO ram_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Jũ mã mã cute me, ne me pahcakôac to amehcakôc? ");
INSERT INTO ram_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pom cu Partij jõ pjê catêjê me, Metij jõ pjê catêjê pĩn me pahcator, ne me pahkwỳ Erãw jõ pjê pĩn me pahcator, ne pom cu Côpihpo jõ pjê ata pĩn me pahcator, ne Juta jõ pjê pĩn me pahcator ita, ne Cawrôpejti jõ pjê pĩn me pahcator, ne me pahkwỳ Axij jõ pjê pĩn me pahcator ita? Pom cu ita pĩn me pahcator ita, ne hanea ne Ponto jõ pjê pĩn me pahcator. ");
INSERT INTO ram_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ne hanea ne Amcràti jõ pjê pĩn me pahcator, ne Panpir jõ pjê pĩn me pahcator ita, ne hanea ne Ejit jõ pjê pĩn me pahcator. Ne Pjêhpôc jõ pjê pê, por Xiren jõ krĩ cahi na xa ata pĩn me pahcator, ne hanea ne me pahkwỳ pyxitre Roman jõ krĩ pĩn ame pajapôj. ");
INSERT INTO ram_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ne hanea ne Kẽnpojre jõ pjê pĩn me cator, ne hanea ne Põcaprỳhti jõ pjê pĩn me cator. Ne me pahkwỳ pê Juta catêjê impeaj, mã hanea ne curmã me pahkwỳ itajê te Juta catêjê na me amji ton. Ne me pahcunea, ahpỹanre na me pajarkwa to me pahcakôc cakrô, mã ajte ihtỳj me pajarkwaa na cute me pamã Pahpãm jàpên xà itajê jarẽn na mempar — hane. ");
INSERT INTO ram_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mã mehcunea te me ampo ita jahkre pej nare kam amji mã me ipikrar, ne nee kam cute ampo to me amji kam hapac nare, ne tee ame ajpẽn cukij, ne me ajpẽn mã: — Ampo mã ajte? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jirô pê mã ri mehkwỳ ame hũn ne me cumã: — Mõrmõ me hũmre itajê amehkõm ne ame ajpã, na ri amehcakôc pihhoti ita to hane — hane. ");
INSERT INTO ram_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mã Petrô pê cute me tôxi atajê kwỳ nõa, ne me cape na xa, ne kỳj cati pêa mã, cute me hàhtôa mã hũjarẽn kam ihtẽm, ne me cumã: — Me ikwỳ pê Juta catêjê me, pom ca me acunea ita ri Krĩpinkrên kam me akrĩ itajê! Me ipar peaj ne! Wa ha me amã awjarẽ! ");
INSERT INTO ram_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ampo na? He ca atỳj me hũmre itajê pipãn na amehcãmjĩ. Hãpà, nee me ipipãn nare. Me hõmpu he. Pom cormã pyt jàpir pejti ita? Quê ajte iràràtia na ame ajpã? ");
INSERT INTO ram_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pom ca me ipupu, ajteare mã me icakôc xà, ne cupê rỳ pêa mã Pahpãm jarkwa na ihcakôc catê ita japrỳ te Jôwer ata pê ahna ihhôc to hane he: ");
INSERT INTO ram_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ỹhỹ, Pahpãm te amji jarẽn to hajỹr he: ‘Me hõmpu he, wa ha ihmat ri, hicu xàa kam, ramã ampo cunea jamre xàa kam wa ha hane he: Wa ha ma me hỹrmã Icarõ Pejti kujate, quê ha pjê cunea kam mehcunea mã amji gõ, quê ha me cucwa. Quê ha me akra xũmre me, me akra cahãj me, Icarõ Pejti jarkwa kôt me ijarẽn to me ipa. Ne wa ha mentuwjê mã, me irĩat kam, icaca xà to ajpẽ. Ne mehwej te hajỹar, wa ha me ipimtir kam me cumã icaca xà to hahkre. ");
INSERT INTO ram_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ne wa ha imã me hàpên catêjê atajê mã Icarõ Pejti kujate. Quê ha me hũmre me, pyjê atajê ijarkwaa kôt ijarkwa to amehcakôc. ");
INSERT INTO ram_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Wa ha hanea ne kỳj rũm, côjkwa pĩn, pjê kam, rỳ jũ caxuw jũm te ampo pihhoti pupun nare ata to ajpẽ, quê ha hane he: Quê ha me caprô catia ne kam cuhy, ne kam ihkũm cati. ");
INSERT INTO ram_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ne quê ha pyt kam awcapàtkô, ne quê ha putwrỳ intepti ne, ne cupê me caprô pyràac. Hõ, ata quê ha pjê wỳr ipê me gõ Pahhiti te amji jaxàr xà wỳr ihkên to hane. Ne amcro ata kam quê ha Pahhiti carôt catia to ajpẽ, quê ha mehcunea me hõmpu ne me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne quê ha cute me iwỳr na, wa ha me kampa, ne mehkên pê mentête amtà, ne me to ikra’ ” hane. Hõhõ, Pahpãm cakôc xà itajê na, pê Jôwer xwỳ ihhôc, hõ kàhhôc kam. ");
INSERT INTO ram_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","— Na ca me ikampa, me ikwỳ pê Ixaher catêjê, pom pê Jeju Naxare jõ krĩ kam ipa ata, wa ame amã harẽ. Pahpãm te me pamã Jeju kujahêc, mã Jeju te Hũm Cati carôt kôt ampo pej pihho jàhtôa ne ton. Por rỳ jũ caxuw jũm te ampo pupun nare atajê pê ajco to. Ne ampo na ri hãn ne ampo itajê to? Nee mã ampo na hãn ne ampo itajê ton nare. He pahte me Pahpãm te ihkujahêc na me hahkre pej prãmte, pê hãn ne ajco ampo itajê to. ");
INSERT INTO ram_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ca ate ahnaa mehcuran. Pê Pahpãm rỳ pêa mã ramã ita to amji kampa, ne ahna amji ton. Ne ahnaa cute me amã ihkra jõr. Ca ate Roman catêjê mã me Jeju jõr, mã cute pĩ na menxôr, ne mehcuran. ");
INSERT INTO ram_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","— Ne jũ wỳr quê ty ne ihtyc tu, cwỳrjapê ri Pahpãm te hacpỹa mã to ihtĩr. ");
INSERT INTO ram_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ỹhỹ, pê rỳ pêa mã me panquêtti pê Tawi hacpỹ mã Jeju tĩr xà na hõ kàhhôc kam ahna ihhôc. Ne pê Jeju cakôc xà na ihhôc to hane he: “Ỹhỹ Inxũ, apê ijõ Pahhiti, na wa ijõtpê akôat ipa. Ne ca amcro cunea kam itehcajpa, na ri imã ampo cupa nare. ");
INSERT INTO ram_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ne ampeaj kam ijakry, ne icakôc xà kam ijakry pit. Na wa ha cormã amcro nõ na ty, ne itỳj gikaj. Wa ijõtpê ato amji japackre. Ne jũ wỳr ca ha ijarêt xà ata kam ijicu, ne imã hikra, cwỳrjapê ri ijakry. Ne jũ wỳr ca ha me carõ kwỳ jipôc ri icarõ to tojnõ, ne cumã hikra. ");
INSERT INTO ram_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","28","Ampo na? Quê ha ramã ikà cacu xàa kam, ca ha hacpỹa mã ito itĩr. Ne atea ca, catyt kam ipa to imã hahkre. Cwỳrjapê wa itỳj ijakry, ne ipej pêa mã ipa. Ne ijakryti to wa amã icakôc to ipa. Na ca ha hacpỹa mã ito itĩr. Ne ma kàj mã, côjkwa wỳr amji wỳr ijaprô. Wa ha cormã apupu, ne ampeaj kam apyrên ijakry” hane. Hõ, pê pahhiti pê Tawi xwỳ jõ kàhhôc kam Pahpãm kra to hũjarẽn to hane. ");
INSERT INTO ram_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","— Ỹhỹ, me ikjêjê, wa me amã me panquêtti xwỳ kôt harẽn to impejti to prãm. Pê me pajõ pahhi pê Tawi xwỳ ty, pê me harêt, ne ihkre cormã me pahcote na ihkrĩ. ");
INSERT INTO ram_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ne pê cupê Pahpãm jarkwa to ihcakôc catê, cwỳrjapê pê cumã Pahpãm te jũ caxuw mehkra tàmxwỳ tàmxwỳ nõ to pahhi na awjahkre ata na hahkre pej. Ne cupê mam Tawi pê pahhi ata pyràac ne cupê pahhi. ");
INSERT INTO ram_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ne pê Tawi ramã Pahpãm te jũ caxuw hacpỹa mã pahhi na to hũjahkre ata to ihtĩr na hahkre pej. Ne nee pê Tawi taa amji to hũjarẽn to hajỹr nare, ne quêt ihtàmxwỳ tàmxwỳ nõ na pê Jeju to awjarẽ. Ne pê harẽn to hane he: “Jũ wỳr ca ha me carõ kwỳ jipôc ri icarõ to tojnõ. Ampo na? Quê ha ramã ikà cacu xàa kam ca ha hacpỹa mã ito itĩr” hane. ");
INSERT INTO ram_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","— Mẽr hõhõ, Pahpãm te hacpỹa mã Jeju taa to ihtĩr, na ramã me icunea te me hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mã ma Pahpãm te côjkwa wỳr to hàpir, mã Pahpãm jĩkjê rũm, awpôc rũm jỹ. Ne cute Hũm te Carõ Pejti to cumã hũjahkre ata pyr, ne me imã ihkujahêc. Ne por ampo cunea pihho, ca me hõmpu, ne me kampa itajê pê Pahpãm Carõ Pejti jàpên xà. ");
INSERT INTO ram_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ne pê Tawi xwỳ nee côjkwa wỳr hàpir nare, ne Jeju pê quêt api. Por pê ramã Tawi harẽn to: “Pahpãm pê Pahhiti te ijõ Pahhiti mã: ‘Ca ha ijĩkjê rũm, awpôc rũm jỹ, wa ha xa apar krac ri acurê xwỳn catêjê jaxà, ca ha cormã me hõ pahhi na jỹ’ ” hane. ");
INSERT INTO ram_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","— Pom me apê Juta catêjê, itajê wa me amã awjarẽ, ca ha me hahkre pej peaj ne. Mãr pê ca pĩ kam me Jeju cura ata to ri Pahpãm te mehcunea jõ pahhiti. Ampo na? He toa pê ramã rỳ pêa mã Pahpãm awjahkre — hane. Hõ, Petrô te me hàhtôa mã harẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mã cute me ita par ne amehpec, ne me cumã amji kĩn nare, ne cute me Petrô me, Jeju jarkwa na memprar catêjê kwỳ cukij, jũ mã quê ha me, ne mehkên pê me cato, ne me cumã: — Me ikjêjê, jũ mã wa ha ajte me, ne me ikên ita pê me icato? — hane. ");
INSERT INTO ram_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mã Petrô me cumã: — Ỹhỹ, ca ha me hane he. Ca ha me akên jicu, wa ha Jeju jarkwa kôt cô kam me acumrã, quê ha mehcunea Pahpãm te, ate ame Jeju to kên atajê to tojnõ ne hicu tu na me gahkre pej. Hõhõ, ca ha me hane, ne me Pahpãm Carõ Pejti incwa, ne pê ramã Pahpãm to awjahkre. ");
INSERT INTO ram_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ne me ca me, me akra me, por cormã mehcunea ampỳa mã ame ipa atajê mã, pê Pahpãm to awjahkre. Pê hanea ne cute cormã me hator atajê mã Carõ Pejti ita to awjahkre — hane. ");
INSERT INTO ram_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mã hipêr Petrô me hapackre, ne me cumã ahcawpa ne me cumã: — Cute me hapackre xà kên kam me ipictor itajê pê me gapôj, ne me amji pytà — hane. Hõ, me hapackre xà ita to ri cute me hapackre, ne cormã me hapackre xà kwỳ jàhtôa to cute me hapackre. ");
INSERT INTO ram_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mã me hàhtôa ne cute me Petrô jarkwa par, ne cute mehkên ton jicu, mã cute cô kam mehcumrãr. Mã amcro ata na, me hàhtôa ne Jeju na mehkwỳ mã me hàr. Ne atajê pê me hàhtô na me mir crê ne me axà. ");
INSERT INTO ram_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na pê Jeju jarkwa na cumã memprar catêjê te tôxi atajê cunea mã Pahpãm te amji kam hapac xà to hahkre to me ipa. Ne pê ajco mehcunea ajpẽn na mehhônco tu, ne ajpẽn kam me apà, ne ihtỳj ajco Pahpãm mã mehcakôc. ");
INSERT INTO ram_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne pê Jeju jarkwa na cumã memprar catêjê ajco Pahpãm carôat kôt me hàpên xà catia pihhoti impejti ton to me ipa. Ita cwỳrjapê pê mehcunea mã me hũpa, ne mehcunea mã mempej pit. ");
INSERT INTO ram_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na pê mehkwỳ cunea mehkôat me ajrõ, ne me cumã ajpẽn kĩn. Cwỳrjapê pê me cumã ampo atajê, ihtỳj me cupê hamreare atajê me ajco me ajpẽn mã me hàhcukrêj to me ajcokjê. ");
INSERT INTO ram_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ne pê ajco me cumã ampo atajê to ihpore na ahpa, ne me cupê ampo jamreare atajê caxuw amji mã mehpore to ajcrà. ");
INSERT INTO ram_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ne mehcunea, amcro cunea kam ajco Pahpãm to me amji kam hapac xà jũrkwa kam me cuprõ. Jirô pê mã pê ihtỳj ajco ajpẽn jũrkwa kôt ame apà, ne ihtỳj ajpẽn pyrên me hakry, ne nee jũm amji to cati prãm nare. ");
INSERT INTO ram_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na pê Pahpãm to me hàmnãn ne cumã impejti na me harẽ. Ne pê mehcunea Jeju na mehkwỳ impejti na me to amji kampa. Pê amcro cunea kam Pahpãm me capi, ne me to cuprõ, ne ma Jeju na mehkwỳ mã me hacjê, na pê ma me to ipicamẽn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ỹhỹ, pê amcro ata na, pyt pejti kam, Petrô me Jowãw ma Pahpãm to me amji kam hapac xà jũrkwa wỳr me mõ. Ne amcro ata na, pê pyt pejti kam Pahpãm mã mehcakôc prãmte, ajco me curi cuprõn to me ipa. ");
INSERT INTO ram_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pê amcro cunea kam hũmre nõ ihkjê te xwỳa na ihpỳm ata, harkwa japrỳ te Impejti ata jarkwa mã ajco ihkrĩ, cute mencjêj mã cute me ahna hàhwỳr prãmte. ");
INSERT INTO ram_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ne cute Petrô me Jowãw xàr na me hõmpun, ne me ahna hàhwỳr. ");
INSERT INTO ram_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mã cute me hõmpun, mã Petrô cumã: — Me ipupu — hane. ");
INSERT INTO ram_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mã hũmre ata te me hõmpun, ne cute me cumã ampo jõr, mã cute ipyr prãmte, ahna me hikaj. ");
INSERT INTO ram_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mã Petrô cumã: — Ipê ihpore hamreare, ne wa ha itỳj amã ampo gõ. Ne ite amã ampo jõr xà ita pê Jeju mã ri quêt carôt cati, incwỳrjapê quê ha ihtỳj ato impej. Pê Pahpãm Jeju to awjahkre, pê Naxare jõ krĩ pĩn cato ata jarkwa na wa ha amã: “To xa ne mõ” — hane. ");
INSERT INTO ram_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne Petrô te awpôc rũm hũ na ipyr, ne ihtehcajpar. Mã hamre, ihpar kõn pej pyrentu, mã ihtỳj intoj ne hãm, ne apu mõr pyrentu. ");
INSERT INTO ram_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jirô pê mã ri ma mehkôt Pahpãm to me amji kam me hapac xà jũrkwa mã hàr, ne apu intoj to mõ, ne apu Pahpãm to hàmnãn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mã me hàhtôa ne cute me harkwa mã hũmre te ihkrĩ ne hàhwỳr catê ata pupun, mã ikre kam apu intoj to mõ, ne apu Pahpãm pej na harẽn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Me kam mare mã impej, cwỳrjapê ri cute me hõmpun xà ata te ame to hàpêt, ne amji mã me to ipikrar. Ne me amji mã: — Rỳ jũ caxuw me pahnõ te ampo te hajỹr nõ pupun nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mã hũmre te xwỳre ita ramã caprãr ne impej, ne ma cute Petrô me Jowãw pynãr, mã hamre, mehcunea te ita to amji mã me ipikrar ne amehprõt. Ne ma Pahpãm to amji kam me hapac xà jũrkwa jarkwa mã, Xarômãw jõ amkrã ata wỳr mehprõt. ");
INSERT INTO ram_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mã Petrô te amji wỳr mehprõt na me hõmpun, ne me cumã: — Pỳhàpà, me ikwỳ pê Ixaher catêjê, ampo na mã came iwỳr ame aprõt to hane? Ne ampo na mã ca amji mã ame apikrar to ame hane, ne kypê me ipupun nare? Côt ca atỳj me itea, me icarôat kôt me hũmre ita caprãr na ame icãmjĩ? Xà mõrmõ me ipej cwỳrjapê wa ite me hũmre ita caprãr? Hãpà, nee mã me icarôt to ite me hũmre ita caprãr nare. ");
INSERT INTO ram_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jeju pê Pahpãm kra impeaj ata te ri caprãr. Ne cupê me panquêtjê Aprãw xwỳ me, Ixac xwỳ me, Jaco xwỳ Pãm Cati, ne cutea ri ihkra Jeju to cati, na ri impeaj to impej. Ne ca ate ahnaa amji pê mehcaca, ne me gõ pahhi pê Pirat mã me hõr, cute ihcuran xà caxuw. Mã tee apu cumã hikran prãm. Ca ma ihkĩnte ame cumã hikran caca. ");
INSERT INTO ram_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ne ate me jũm kêanre pê mehcuran catê ata me Jeju pejti ata to me gàhpan, ne ate mehcuran catê ata mã hikran na Pirat na me gàhwỳr. Mã cute me amã cumã hikran. ");
INSERT INTO ram_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ca ate me Jeju pê me pamã pahte amji kam me pajapac xà jõr catê ata curan. Mã Pahpãm te hacpỹa mã to ihtĩr, wa ite ihtĩar na me hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jeju te ri hũmre ita caprãr. Wa me ajwar ite, cute caprãr na me hahkre pej. Na ri ita caxuw me akam mare mã, me acunaa mã hũmre ita pej. ");
INSERT INTO ram_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","— Me ikjêjê, he imã, ate me gõ pahhi me Jeju curan na, me gahkre pej. Ne me apê cupê Pahpãm kra na hahkre kêatre, na ca ate me to hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pê rỳ pêa mã ramã Pahpãm jarkwa na ihhôc catêjê Jeju tyc xà na mehhôc. Ne cute me ahna ihhôc xà ata kôt ri ihkên mã hàr. Ne pê ihkàj xà incrire nare ata na, pê rỳ pêa mã ahna mehhôc, na ca ate ahnaa me to hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na ca ha me akên itajê mã me hikra, ne ate amji kam me gapac xà to me antuw, ne Pahpãm wỳr me apkjê, ne Pahpãm jĩkjê rũm me ahtwỳ, quê ha ate me to kên atajê to tojnõ ne hicu, ne me ana amji capa. ");
INSERT INTO ram_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ca ha ame gakry, ne atỳj me apej pêa mã me amji to me ajpa. Ne quê ha Pahpãm amcro nõ na hipêr me pahwỳr Jeju kujate. ");
INSERT INTO ram_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Quê ha nee cormã ne amji jaxàr pyrentu nare, ne quêt côjkwa kam ahtwỳ. Quê ha jũ caxuw Pahpãm ampo cunea to impej, ne to ipintuw jõ amcro kam ahtwỳ, quê ha cormã amji jaxà. Ne rỳ pêa mã pê Pahpãm jarkwa na mehhôc catêjê impejti atajê, ramã ita to mehcakôc, ne ahna mehhôc. ");
INSERT INTO ram_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pê ramã me panquêtti pê Mojxe xwỳ ita to ihcakôc, ne me cumã: “Ỹhỹ, quê ha amcro nõ na me pajõ Pahhiti pê Pahpãm me pamã me pahnõa kujate to hanea, pom pê mam ikujate he. Quê ha pahnõ pyxit ata me pamã Pahpãm jarkwa to ihcakôc, ne harẽn to apu mõ, ca ha mempar to impeaj ne. ");
INSERT INTO ram_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nãmri ca ha ate nee me jũm ata par, ne harkwa kôt me apa nare na, quê ha Pahpãm ihtỳj ahna me apupu, ne mehkwỳ intête me anõ jũpar nare ata cator pyrentu, quê ha acto” hane. ");
INSERT INTO ram_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ita to pê Mojxe me panquêtjê mã ihcakôc. — Ỹhỹ, he nee pê Mojxe pyxit peaj ne ihcakôc to hajỹr nare. Pê Pahpãm jarkwa na mehhôc catêjê cunea mehcakôc to hajỹr pit. Ne mam haprỳ to Xamer xwỳ kôt me hapôj itajê, pê hanea ne ajco mehcakôc xà ita to mehcakôc to me ipa. Pom cu amcro ita kam me harkwa to hàpên xà pupu, itajêa to pê mehcakôc, ne ahna mehhôc. ");
INSERT INTO ram_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pê Pahpãm ramã Jeju to awjahkre na pê harkwa na mehhôc catêjê, harkwa kôt me pamã Jeju to awjahkre. Ỹhỹ, pê rỳ pêa mã Pahpãm me panquêtti Aprãw xwỳ mã ihcakôc ne cumã: “Ỹhỹ, quê ha amcro nõ na me atàmxwỳ tàmxwỳ me ikampa, wa ha mehkôt pjê cunea kam me to impejti ne” hane. ");
INSERT INTO ram_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ne pê Jeju hõtpê Pahpãm kampa, pê cute to hũjahkre xà ata na capi, ne ma me amã ihkujate, cute me ato impej, ca me acunea te me akên mã hikran, ne Pahpãm wỳr ate me amji jaxàr prãmte — hane. Ata to ri Petrô te mehkwỳ mã hũjarẽn. ");
INSERT INTO ram_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","4","Ỹhỹ, Petrô me Jowãw cormã Jeju to me cumã ihcakôc, ne me cumã: — Ỹhỹ, Jeju tyc mã Pahpãm te hacpỹa mã to ihtĩr — hane. Mã me hàhtôa ne amehcuhhê ne me kampa atajê te amji mã me to hajỹr pyrentu, ne ihtỳj me Petrô jũjarẽn xà atajê kampa. Na ri me hàhtôa ne Jeju to amji mã mehhimpej, ne ramã me hũmre te mir te xĩc ne mehkwỳ mã me hàr. Mã me hõ pahhi catêjê kwỳ japôj, ne cute me Petrô me Jowãw cakôc xà na mempar. Ne cute mempar catêjê itajê pê Xato xwỳ kôt me ipa catêjê kwỳ me, cute Pahpãm mã mehcajrẽn catêjê kwỳ me, me Pahpãm jũrkwa jamãr catêjê jõ pahhi. Ne ame Petrô me Jowãw kam mencryac to mencryc. Na ri cute mehpro, ne me haxàr. Mã ramã me ahna pytre, mã ri curia cute me hacjên xà kam me ahna apẽ. Ampo na? Pahhi catêjê cunea te iràrà na me hacjên atajê cakôc xà kam me hapac prãmte. Ne pê cute amji mã me Jeju to mehhimpej, ne mempar atajê pê me hàhtô na me xĩc mir. ");
INSERT INTO ram_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mã apẽ na iràrà na, prohti kam mehkwỳ jakrã jõ pahhi catêjê me, Mojxe xwỳ te me hapackre xà to me cumã hahkre catêjê cunea te Krĩpinkrên kam amji to me cuprõn, cute me Petrô me Jowãw cakôc xà na mempar prãmte. Mã Juta catêjê jõ pahhi me, cute me cumã Mojxe xwỳ jõ kàhhôc to hahkre catêjê me, ");
INSERT INTO ram_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","me Pahpãm mã mehcajrẽn catêjê jõ pahhi japrỳ te Anati ata me, mehkjêjê me, Cajpa me, Jowãw me, Arexãnre me, prohti kam mehcunea te me cuprõn, cute me Petrô me Jowãw cakôc xà na impar prãmte. ");
INSERT INTO ram_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mã pahhi te me ahna harkwa hyr. Mã cute me haprôr ne me cuna mã me hãm. Mã pahhi te mehcukij kam ihtẽm, ne me cumã: — Ỹhỹ, ita caxuw ca ha me imã me amji jarẽ. Jũm jarkwa kôt mã ate me hũmre te xwỳ ita caprãr? Jũm te mã me amã me acarôt jõr ne ahna me amẽn, ca ate me caprãr? — hane. ");
INSERT INTO ram_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mã Pahpãm Carõ Pejti te Petrô mã amji jõr, ne incaca xà mã hàr, ne cute to ihtỳj, cute me cumã ihcakôc xà caxuw. Na ri Petrô te prohti kam me cupê pahhi catêjê mã ihcakôc to hajỹr he, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","— Ỹhỹ, menxũjê me, me to ahimpej catêjê, mõrmõ ca amji mã me ito: “Cutea ri me hũmre ita to impej ne caprãr” hane, incwỳrjapê mã ca ame icukij xà ita to me icukij? Ne ajte me imã: “Jũm carôt to mã ate me cute xwỳ ita caprãr?” hane. ");
INSERT INTO ram_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mẽr hõhõ, me ikam gapac to mempeaj ne. Ne wa ite, me cupê Juta catêjê mea mã, ate me hũmre ita jahkre pej prãmte, wa me amã harẽn to, Jejua te ri caprãr. Por pê Pahpãm Jeju to awjahkre, pê cato ne Naxare jõ krĩ kam apu ipa ata te ri caprãr. Ne taa mã ca ate pĩ kam mehcuran. Ne taa mã ri Pahpãm te hacpỹa mã to ihtĩr, ne cutea ri hũmre te xwỳ ata caprãr. Ne harkwa kôt wa icakôc, cwỳrjapê ri cute caprãr. ");
INSERT INTO ram_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","— Pê Pahpãm jõ kàhhôc ramã harẽn to hane he: “Ihhêj rũm me apê, por ikre pyxwỳr catêjê kêanre atajê pyràac. Ne me apê hahkre kêatre. Na ca ame ikre mã hãm xà impejti ata caca, ne ate me mẽn. Mã me akwỳ pê jũmjê itajê te me ikre mã hãm xà impejti ita pỳn, ne me cumã hãm, mã impeaj to impej, ne ihkwỳ jirôa pê impej ne ihtỳj” hane. — Ne Jeju pê ikre mã hãm xà impejti ata pyràac. Ca ma ame curê ne ate me mẽn. ");
INSERT INTO ram_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne Jeju ita ri pyxit peaj, ne me pahkên pê me pahpytà. Ne jũm mã ri pjê ita kam me pahkên pê me pahpytàr jahkre pej? Hamreare, jũm mã hahkre pej nare. Na ri Pahpãm te caxuw Jeju pyxit peaj ne hãm. Na ri pyxit peaj ne cumã me pahkên pê me pahpytàr jahkre pej — hane. Ita to ri Petrô te ihcakôc, ne me cumã harẽn. ");
INSERT INTO ram_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mã cute me Petrô par, ne me hõmpun, mã me ipijakrut ne me xa, mã me ajpẽn mã: — Pỳhàpà, xà ajte nee me cumã me pahcupa nare, na mã ame pamã mehcakôc xà ita to hajỹr to ajwar ame mõ? Pom me pahcati pit ita! Ne me pamã hahkre pej pit ita! Ne cormã me pahkĩnte mencrire ita cakrô, mã ajte nee amji mã me pahcupa nare. Ampo na? Hõtpê Jeju me ajwar amcro atajê nõ na apu ipa na ri, nee cumã me pahcupa nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ne hanea ne hũmre te xwỳ caprãr ata, hanea ne mehcunea cuna mã Petrô me Jowãw cahê na impeaj xa. Na pê me cupê pahhi catêjê nee Petrô me Jowãw na mehcakôc kên nare. ");
INSERT INTO ram_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ne ma cama cute me Petrô me Jowãw cator, põ mã, cute me cuprõn xà pê. Ne me ajpẽn mã: ");
INSERT INTO ram_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Pỳhàpà, jũ mã cu ha me ipijakrut itajê to me? Nãmri ramã mehcunea te Krĩpinkrên kam harkwa to cute me hũmre te xwỳ caprãr na me hahkre pejtu ita kam. Jũ wỳr cu ita to me amxu, ne jũ wỳr cu mentête mehcakôc xà ita capa. ");
INSERT INTO ram_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Hamre, cu ha cama me cumã amji cawpa, quê nee hipêr amji mã me Jeju jarẽn nare. Mãr quê nee krĩ kôt harẽn ipicràn nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ne ma cute me Petrô me Jowãw to me hàr, ne amji jipôc ri, amji kuc ri me hãm. Ne me cumã: — Hã, ca ha nee hipêr me cumã Jeju jarẽn nare, ne ca ha ma me tẽ — hane. ");
INSERT INTO ram_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mã Petrô me Jowãw, me hõ pahhi catêjê mã: — Pỳhàpà, xà ajkĩ me acakôc xà ita pej? Wa ha pijamã me garkwa kôt amji to, ne nee Pahpãm jarkwa kôt amji ton ne ihkôt me ipa nare? Quê ha pijamã Pahpãm mã ita na impej? Hãpà, quê ha cupê ita na ihkaj na. ");
INSERT INTO ram_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pê wa Jeju me ajco ame ipa, ne ihkôt me ampo jàhtôa kampa, ne ito jĩa to me ampo jàhtôa ne me hõmpu. Ita kam jũ wỳr wa me ita jicu, ne me to tojnõ, ne me to icakôc jicu nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mã me hàhtôa atajê ame Pahpãm to ajpẽn mã me amnã, ne ajpẽn mã: — Ampeaj kam Pahpãm cati ne carôt tỳj, cute ihtỳj hũmre te xwỳ ita caprãr — hane. Cwỳrjapê ri me cupê pahhi catêjê, me hàhtôti atajê cupate, cute me Petrô me Jowãw mã me amji cawpa, ne ihtỳj jũ na me ton to prãm, ne ma cute mehkujahêc. ");
INSERT INTO ram_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ỹhỹ, pê me hũmre te xwỳ caprã ata pê ramã ahna caku cwarẽnta. Pê mehcunea Petrô me Jowãw te Pahpãm carôt kôt, cute me hũmre te xwỳ ata caprãr na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ne cute me Petrô me Jowãw mã hikran, mã ma me tẽ, hacpỹ mã mehkwỳ wỳr. Ne cute mehkwỳ cunea mã, pahhi me prohti kam, cute me ahna ihcakôc xà kên to, cute me ahna mehcakôc xà atajê cunea na, me amji jarẽn. ");
INSERT INTO ram_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mã cute me Petrô me Jowãw par. Ne mehcunea te me cuprõn, ne Pahpãm mã amehcakôc ne me cumã: — Hàpà, me ijõ Pahhiti. Ỹhỹ, apê me icunea ton catê. Pê ca côjkwa to, ne pjê to, ne cô to, ne kam ampo tĩar na amji to ajpa atajê cunea to. ");
INSERT INTO ram_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ỹhỹ, pê rỳ pêa mã me iquêtti pê amã hàpên catê pê Tawi xwỳ ihhôc, ne Acarõ Pejti jarkwa kôt ihhôc to hane he: “Ampo na mã amji caprỳ to krĩxàre kôt ame côjkwa kam Pahhiti pê Pahpãm kam mencryc ne ame hapu prãmte ame cuprõ? Ne jũ wỳr quê ame amji mã hamã. ");
INSERT INTO ram_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ne ampo na mã me cupê Ixaher catêjê nare atajê jõ pahhi kwỳ, hãn ne Pahhiti te me cumã hõ pahhi pyxwỳr ata me cuna mã me cuprõ, ne ahna ame ajpẽn pa?” hane. — Ita na pê Tawi xwỳ, Acarõ Pejti jarkwa kôt ihhôc. ");
INSERT INTO ram_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","— Ne cute ame Jeju na me ajpẽn par ne kam amencryc prãmte ri, krĩ ita kam me cuprõ. Ne ita na ri pahhi Heroti me, pahhi Ponti Pirat me, mehcahkrit pê Juta catêjê nare atajê me, me cupê Juta catêjê me, mehcunea te me cuprõn, krĩ ita kam. Ne mãr pê ca me imã Acãmter pejti capi ne to awjahkre, ne hãm ata kam hanea ne apu mencryc. ");
INSERT INTO ram_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pom pê ca ramã rỳ pêa mã to amji kampa ata na ri mehkêan kam, cute me cuprõn. ");
INSERT INTO ram_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mẽr he, me hõmpu he! Cormã me pahkam mencryc. Ne cormã imã me amji cawpa. Ne ita caxuw, ca ha hipêr me ipê me amã me ijàpên catêjê mã acarôt gõ, wa me cumã garkwa to icakôc, ne me icakôc kam pra, ne kypê me cumã me icakôc nare. ");
INSERT INTO ram_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne ca ha me cumã acarôt pẽ, wa akra Jeju jarkwa kôt me hà catêjê caprã. Ne akra jarkwa kôt me icakôc to me ipa, ne ampo to mempej, ne me to ijàpên xà impejti ton to me ipa, quê me hõmpu, ne me acarôt jahkre pej — hane. ");
INSERT INTO ram_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ita na ri Jeju na mehkwỳ Pahpãm mã me amji cajrẽn. Ne cute Pahpãm mã mehcakôc jicu, me ajkaam cute me cuprõn xà jàpêt. Mã Pahpãm Carõ Pejti te mehcunea mã amji jõr ne me to hipu tu. Na pê nee me cumã me hũpa nare, ne mehtỳj pit. Mã nee mehcakôc xà na me hàhtàt nare. ");
INSERT INTO ram_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","33","Ne Jeju jarkwa na memprar catêjê hõtpê mehcunea mã Pahpãm Carõ Pejti carôt tỳjti jarkwa kôt hacpỹa mã Jeju tĩr na me harẽ. Mã Pahpãm hõtpê me to kênre nare. Ne me hàhtôa cakrô, cute amji kam me hapac xà itajê pit, ne pyxit peaj, ne cute me amji kam hapac xà pipẽn pit. Mã nee ame amji pê hõxỳ nare. ");
INSERT INTO ram_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ne pê hõtpê me cumã ampo to ajcrà. Ne pê ajco me cupê ihpore hamre, pê ajco mehkwỳ mã, ikre me pur me ampo atajê to ajco ihpore na me ahpa, ne mehpore incwa, ne Jeju jarkwa na memprar catêjê mã me cugõ. Pê me cupê hamreare atajê mã me to ajcrà. Na pê Jeju na mehkwỳ kam jũm pê ampo hamreare nare. ");
INSERT INTO ram_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Ỹhỹ, mehcote na hũmre apu mõ ata japrỳ te Joje. Ne cupê Rewi xwỳ tàmxwỳ tàmxwỳ nõ. Ne cupê Xipre jõ pjê catêjê nõ, ne kaam ihpỳm. Mã cute me cumã haprỳ krut jõr, ne me cumã “Parnap Jũcanãr”. Ampo na? Hõtpê apu mehkôt ipa ne apu mehkwỳ mã hũcanãr ton to ipa, na pê haprỳ hane. Mã cute hanea ne pur to ihpore na hàhpan, ne ma Jeju jarkwa na memprar catêjê mã hõr, cute me cupê hamreare atajê mã apu to ipicràn xà caxuw. ");
INSERT INTO ram_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mã hũmre nõ ita japrỳ te Anana, ne hĩxi japrỳ te Xapirkwỳj, te hanea ne pur to ihpore na me hàhpan. ");
INSERT INTO ram_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ne aracri cute me ihpore jĩkjê juwahi, ne Jeju mã memprar catêjê mã me hĩkjê pit jõr. Ne cute mehcunea jõr na me amji jarẽn. Pê ihtỳj Xapirkwỳj mã impjên te me cumã ihpore jĩkjê pit jõr na hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mã Petrô te Anana cukij to: — Pỳhàpà, ampo na mã ate cama me pahcurê xwỳn jamãr, mã cute amã amji kam hapac xà ita to hahkre? Ne ampo na mã ate Pahpãm Carõ Pejti mã ahêj? Ampo na mã aracri ate pur jõ pore jĩkjê juwahi? ");
INSERT INTO ram_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","He ate pur to ihpore na gàhpan xwỳjrea na, pur atekjêa ri, ne hanea ne, pom ate ihpore me pur to gàhpan ita atekjêa ri. Ca rỳ mã hĩkjê pit jarẽ, quê ha ahna amã ihkênre nare. Ne ampo na mã ate ita to hajỹr? He nee ate jũm mã ahêj nare, Pahpãm mã ca ate ahêj — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mã Anana te ita par pê ihpỳm ne ihtyc pyrentu. Mã cute me ita jahkre pej catêjê atajê cunea mã ampeaj kam ita cupa. ");
INSERT INTO ram_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mã mentuwjê kwỳ te mehtyc cupu, ne ma põ mã me to kwỳ, ne cute me harêt. ");
INSERT INTO ram_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mã ahna ahtũm ryre mã curi ihkôt hĩxi cator, ne nee cormã cute ampo te impjên to jũ mãn xà ata na hahkre pej nare. ");
INSERT INTO ram_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mã Petrô te ihcukij ne cumã: — Hã, imã awjarẽ, xà ampeaj kam mã ihpore ita na pit mã ate apjên me pur to gàhpan? — hajỹr. Mã cumã: — Ỹhỹ — hane. ");
INSERT INTO ram_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mã Petrô cumã: — Ampo na mã ate apjên me amji caxuw Pahpãm Carõ Pejti inxỳj? Xà ate mehcajpẽr prãmte mã ca ate me to hajỹr? Pom mentuwjê te me apjên jarêt ne ramã hacpỹ ne ame ipa ita, quê ha hanea ne ihkôt me ato kwỳ ne me garêt — hane. ");
INSERT INTO ram_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Me ajkaam mã Petrô cuna mã ihpỳm ne ihtyc. Mã mentuwjê cator, ne cute me hõmpun, ne ma me to kwỳ ne cute impjên cahêa na me harêt. ");
INSERT INTO ram_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mã Jeju na mehkwỳ cunea te me ita par, ne me cumã hũpaa to hũpa. ");
INSERT INTO ram_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ỹhỹ, Jeju jarkwa to memprar catêjê te Pahpãm carôt kôt me hàpên xà pihho catia ton. Ne cute me hàhtôa jipôc ri me hàpên xà impej jàhtôa ne me ton. Mã mehkwỳ cunea te me cuprõn, Xarômãw jõ amkrã kam. ");
INSERT INTO ram_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mã me hàhtôa ne me cupê Jeju na mehkwỳ nare atajê mã ampeaj kam me hũpa, na ri nee Jeju na mehkwỳ mã jũm xàr nare. Ne mehcunea amji mã me Jeju na mehkwỳ cupa to hũpa to me ipa. ");
INSERT INTO ram_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Quê ha jũm te amji kam hapac xà to ipintuw prãm na, quê ha ihtỳj jũm me hỹrmã axà. Ne por me hũmre me, pyjê jàhtôa ne ampeaj kam me Pahpãm kampa atajê ri, Pahpãm wỳr me ipipkjêr xà, na ri ma Jeju na mehkwỳ me ipicamẽn to me mõ. ");
INSERT INTO ram_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ne por Jeju jarkwa na memprar catêjê atajê, Pahpãm carôat kôt me hàpên xà pihho catia ton to me ipa. Cwỳrjapê quê ha me hà japỳ, ne krĩ cape na me cunõ, quê me hikwa, quê Petrô apu mõ ne mencwỳrpê mõ, quê ha carõ pykrã me hà atajê pro, quê ha mempej pyrentu, ne amehcuhhê. ");
INSERT INTO ram_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mã me hàhtôa ne Krĩpinkrên wỳr me hà catêjê me, me kam me pahcurê xwỳn carõ kên catêjê atajê to me mõ, mã cute mehcunea caprãr. ");
INSERT INTO ram_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mã cute Pahpãm mã mehcajrẽn catêjê jõ pahhi me, Xato xwỳ kôt me ipa catêjê kwỳ me, ma ame Jeju jarkwa na memprar catêjê jũ na me amji to prãm ne ma ame curê. Ne mehkwỳa kwỳ cunea mã Jeju jarkwa na memprar catêjê kĩn, cwỳrjapê ri me curê xwỳn itajê kwỳ ame hũ na mehkĩn ne ame curê. Na ri cute ame to kêanre xà na me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ne cute mehkujahêc, mã mehwỳr me pra, ne cute me Jeju jarkwa na memprar catêjê pijakrut pê Petrô me Jowãw atajê pro, ne me haxàr. ");
INSERT INTO ram_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mã caxwa ata kam, côjkwa pĩn, Pahpãm mã memprar catêjê nõ cator, me hacjên xà kam, ne cute me cumã harkwa jihê mẽn, ne põ mã ajwar me cator, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Hã, cute Pahpãm to me amji kam hapac xà jũrkwa wỳr me tẽ, ne me cumã Jeju te amji kam hapac xà intuw pejti ita na harẽn pa — hane. ");
INSERT INTO ram_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mã me hũpar pyrentu, ne apẽ mã, iràràtia na, ma Pahpãm to me amji kam hapac xà jũrkwa mã me hàr, ne cute me cumã hũjarẽn kam mehtẽm. Mã Pahpãm mã mehcajrẽn catêjê jõ pahhi te me ajpẽn par prãmte me cuprõn, ne prohti kam me hõ pahhi kwỳ na me hàhwỳr, cute me cuprõn xà ri. Ne cute me cuprõn jirô pê mã ma me hacjên xà wỳr, cute me Petrô me Jowãw japrôr na me harkwa kujahêc. ");
INSERT INTO ram_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mã me hacjên xà jamãr catêjê curi me cator, ne nee cute me hõmpun nare. Ne ma cute me amji jaxàr, cute me cuprõn xà wỳr, ne me cator ne cute me cumã me harẽn to: ");
INSERT INTO ram_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Ỹhỹ, wa ma me hacjên xà ri me mõ, mã me hacjên xà jihê pejti xa, wa ite me hõmpun, mã me hũjamãr catêjê harkwa mã amehcuhhê, ne me awjamã. Wa ite me hihê mẽn, ne nee ite caxwãm pê, kam me jũm pupun nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mã Pahpãm mã mehcajrẽn catêjê jõ pahhi kwỳ me, me hõ pahhi me, me hũjamãr catêjê jõ pahhi atajê me, me hũpar, ne mehkrã pictor tu, ne me cupê me hahkre kêatre. ");
INSERT INTO ram_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Me ajkaam mã jũm ata cator ne me cumã: — Me ikampa, por ca ate me hũmre jacjên atajêa ri ma ramã me hàhtôa mã Pahpãm jarẽ, Pahpãm to me amji kam hapac xà jũrkwa kam — hane. ");
INSERT INTO ram_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mã me hamãr catêjê jõ pahhi me, mehkwỳ ma me pra ne hỹrmã me cator, ne cute me haprôr. Ne me cumã ampeaj ne me to mõ. Ne nee ame to kên nare, me hàhtôti te kẽn to me hamãr catêjê kwỳ jipej cupate. ");
INSERT INTO ram_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ne cuprõn xà wỳr me to cator, ne cute me hãm, cute me ajpẽn par catêjê cuna mã. Mã me hõ pahhi me cumã: ");
INSERT INTO ram_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— Pỳhàpà, wa ite Jeju japrỳ jarẽn tête me amãn, nõ na mã ca ramã ame harẽn to me apa! He ramã Krĩpinkrên cunea kôt ate me harẽn cràn! Ne cormã hipy ate Jeju curan na, amji mã me icuhtom tu — hane. ");
INSERT INTO ram_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mã Petrô me, Jeju jarkwa na cumã memprar catêjê atajê kwỳ me, me hõ pahhi catêjê kwỳ mã: — Cu pahtỳj me Pahpãm kampa, ne me hũmre cu nee mempar nare. ");
INSERT INTO ram_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ne Pahpãm pê me panquêtjê Pãm Cati, ne cutea ri hacpỹa mã Jeju to ihtĩr, na wa ame amã harẽ. Ca me ate pĩ na me Jeju xôr, ne mehcuran, mã Pahpãm te hacpỹa mã to ihtĩr. ");
INSERT INTO ram_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ne cute me pajõ Pahhiti catia na hãm, mã cupê me pahkên to pôj catê. Ne cute amji jĩkjê rũm Jeju jỹr, awpôc rũm. Ampo na ri Pahpãm te to hajỹr? Ma ame pahkên na ihcaca na ri pahte me pahkên mã hikran, mã cute me pahkên to tojnõ to prãm to ri cute to hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ne wa ite me hacpỹa mã me Jeju tĩr na me hõmpun. Ne ite Jeju tĩr na me hahkre peaj na wa mehcunea mã ame harẽn to me ipa. Mã hanea ne Pahpãm Carõ Pejti ame cumã harẽ. Mã hõtpê Pahpãm, cute mempar catêjê mã Carõ Pejti gõ — hajỹr. Hõ, ita na ri Petrô te me cumã harẽn. ");
INSERT INTO ram_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mã Juta catêjê jõ pahhi catêjê te me ita par, ne ame kam mencryac to amencryc. Ne me cumã Jeju jarkwa na memprar catêjê ihcuran prãm pit. ");
INSERT INTO ram_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mã hũmre nõ japrỳ te Camar ita me cumã ihcakôc prãmte hãm ne xa. Ne cupê Parixêw catêjê nõa, ne cupê Mojxe xwỳ jõ kàhhôc to me cumã hahkre catê. Ne mehcunea mã ihkĩn, ne me cumã hũpa. Mã ma cute Jeju jarkwa na memprar catêjê to me hamãr catêjê kujahêc, quê põ mã me to cato, ne põ pê me to hikaj. Mã ma põ mã me to cator. Mã Camar te pahhi catêjê mã ihcakôc kam ihtẽm, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","— Me ikwỳ pê Ixaher catêjê, me hũmre itajê to impeaj ne, nee ca ame to kên nare. ");
INSERT INTO ram_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xà ca nee me Tewta xwỳ ata to amji japackre nare? Pê tee apu amji to cati prãm to mõ. Ne ihkôt me ipa catêjê to cwatxẽnta ne amji mã me to cuprõ, ne ame to ipa. Pê jũm Tewta ata cura, pê pea ihkôt me ipa catêjê cunea ame ajcrà. Pê me ipijapu xà hamre. ");
INSERT INTO ram_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jirô pê mã pê Hĩpôjajo jõ pjê pĩn Juta ata cato, pahhi mã me hakrã cahyt xà jõ putwrỳa kam. Ne hanea ne cute pahhi jũhhyr prãmte amji mã me hàhtôa ne me to cuprõ. Pê hanea ne me Juta ata cura, pê ihkôt me ipa catêjê ma ame ajcrà. ");
INSERT INTO ram_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na cu Jeju kôt me ipa catêjê to ame tojnõ, ne nee jũ mã ame hũmre itajê ton nare, ne me cumã hikra, quê ha me pra. Quê ha me hàpên xà ita pê me hũmre itajêa jàpên xà na, ca ha me to tojnõ quê ha taa me ipictor to me hanea, pom pê mehkwỳ he. ");
INSERT INTO ram_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nãmri quê ha me Pahpãm jàpên xà na, jũ wỳr ca me to cô ne me to hamre. Me to impeaj ne, ca ha ate Pahpãm jàpên xà to amehkên na, ca ha atỳj me Pahpãm cujtê, ne jũ wỳr ca ha me ampo pupu — hajỹr. Ne Camar te pahhi mã ihcakôc to hajỹr, mã cute me kam hapac, ne me ajpẽn mã: — Cu ha nee mehcuran nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mã cute me Jeju jarkwa na memprar catêjê na me hàhwỳr, mã me hàr. Mã pahhi catêjê kwỳ te amehcahhyr na me cumã harkwa. Ne hanea ne cute me cumã harkwa hyr, quê nee hipêr jũ caxuw Jeju to amehcakôc to me ipa nare. Ne ma cute mehkujahêc, mã ma me mõ. ");
INSERT INTO ram_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ne me cator, ne ame hakry, ne me ajpẽn mã: — Cute Jeju cwỳrjapê me pahcahhyr ita na ri impej. Ampo na? He cute me pahcahhyr xà ita pê Jeju ihhêj rũm cahhyr xà jõ amcro ata pyràac. Ne ihcahhyr cumam mãa ri ita kam ame pahcahhy, ne ahnaa ri me pamã impej. Wa Jeju jarkwa na ame cumã awjarẽ, na ri ame pahcahhy. Ne mõrmõ ihtỳj Jeju me papipẽan na ame pahcãmjĩ, ne ame pahcahhy. Ne ahna ri me pajakry — hane. ");
INSERT INTO ram_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne amcro cunea kam me cumã Jeju to mehcakôc to me ipa, Pahpãm to me amji kam hapac xà jũrkwa kam. Ne hanea ne me hũrkwa kam me Jeju jarẽn to me ipa. Ne ihtỳj hipêr cute mehcunea mã Jeju cwỳrjapê Pahpãm te me ahna amji caxàr to hahkre to me ipa kam me to incrà. ");
INSERT INTO ram_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ne amcro nõ na hipêr Jeju na mehkwỳ picamẽn. Mã mehkwỳ pê Crec jarkwa to mehcakôc catêjê me, Ixaher jarkwa to mehcakôc catêjê me, cute me ajpẽn mãn kam mehtẽm. Ampo na? Xwahna amcro cunea kam Crec jarkwa to mehcakôc catêjê cahãj impijapit wej mã cute me hõ jõr xà ata to me hapac kêt to me mõ, na ri. ");
INSERT INTO ram_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mã Jeju jarkwa na memprar catêjê te tôxi atajê te me amji kwỳ cunea to me cuprõn, ne cute me cumã amji jarẽn, ne me cumã: — Ỹhỹ Pahpãm jarkwa to ite me ijàpên jicu, ne me pajõ to pit mã me amji japackre, ita na me ipê ihkaj na. ");
INSERT INTO ram_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Cwỳrjapê, ca me ikjêjê me amji capi, ne Pahpãm Carõ Pejti carôt te me hũmre to xet ne me amji jõr atajê to me caprã. Ampeaj kam cute me amji kam hapac xà impejti, ne cute me amji jahkre pej catêjê kwỳ cu ha me cumã me hõ jõr catêjê na me hũxwỳ. ");
INSERT INTO ram_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ne me pa, wa ha hõtpê me Pahpãm mã mehcajrẽn, ne mehcunea mã harkwa to hahkre me to wa ha me ijàpên to ipa, ne nee wa ha iràn xà na ampo to amji japackre nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mã mehcunea te mehkôt me amji ton, ne cute me hũmre te xet capi ne me hũxwỳr. Ne jũm pyxit ata pê Tewãw, ne cute Jeju to amji mã ihhimpej to tỳj, mã Pahpãm Carõ Pejti carôt te to hipu. Mã mehcahhur atajê pê Pirip me, Procor me, Nicanõr me, Timãw me, Parmena me, Nicoraw pê Antijoc catêjê nõ, ne nee cupê Juta catêjê nõ nare, mã cute amji to Juta catêjê. ");
INSERT INTO ram_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mã cute Jeju jarkwa na memprar catêjê cuna mã, cute me xet itajê xãm. Mã cute me Pahpãm mã mehcajrẽn, ne mehkrã na me hũ xir. ");
INSERT INTO ram_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne cute me ajpẽn par jirô pê mã ri, ihtỳj hõtpê Pahpãm jarkwa picràn. Mã Jeju na mehkwỳ hõtpê me ajcamẽ, Krĩpinkrên cunea kôt. Mã me Pahpãm mã cute mehcajrẽn catêjê jàhtôa ne hanea ne cute me Jeju te amji kam hapac xà kam hapac, ne ihkôat me amji ton, ne mehkwỳ mã me hàr. ");
INSERT INTO ram_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Pê Pahpãm mã Tewãw ihkĩan to ihkĩn. Ne pê Tewãw mã Carõ Pejti carôt gõ, pê Tewãw ajco carôat kôt mehcunea jipôc ri hàpên xà pihho impej catia ton to ipa. ");
INSERT INTO ram_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pê ajco Juta catêjê kwỳ kwỳ ame Tewãw na mehcakôc kêanre to me ipa. Pê mehkwỳ itajê ajco me cuprõ atajê japrỳ te “Amjia kôt ame ipa catêjê na mehkwỳ”. Ne mehkwỳ itajê pê Xiren jõ krĩ me, Mehtehcajpar jõ krĩ me, Quiriti jõ pjê me, Axij jõ pjê rũm me cato. Ne me hũmre itajê pê ampeaj kam me harkwa to Tewãw me ajco me ajpẽn mãn to me ipa. ");
INSERT INTO ram_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mã Pahpãm te me caxuw Tewãw mã cute amji jahkre pej catia ne hõr, mã Carõ Pejti kôt cute me cumã ihcakôc xà ata na nee cute mehcapên nare. ");
INSERT INTO ram_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mã cute, jũmjê atajê te Tewãw cuna mã amehcakôc kên prãmte, me cumã hàmjõr. Mã cute mehcunea mã Tewãw to ihhêj to hajỹr he: — Wa ite me hũmre ita te ame panquêtti Mojxe xwỳ me, Pahpãm cuna mã ihcakôc kêanre to mõr na mempar — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mã mehcunea te, cute me Tewãw to mehhêj xi xà ita par atajê te ri amji mã me ipikrar, ne mehkôat kam mencryc. Ne prohti kam me to ihhimpej catêjê me, Mojxe xwỳ jõ kàhhôc to me cumã hahkre catêjê me, mehcunea mehkôt kam mencryc. Ne cute me amji kam me hapac xàa to, cute me to cuprõn, ne me to mõ, ne me Tewãw pro, ne ma me to mõ, prohti kam mehwỳr. Ne cute me hapackre xà jũrkwa kam, me cupê pro kam me cuna mã me Tewãw xãm. ");
INSERT INTO ram_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne cute me hũmre kwỳ japrôr, cute me Tewãw to ihhêj xi xà caxuw. Mã Tewãw to cute mehhêj xi to me hajỹr: — Ỹhỹ, hũmre ita nee ihcakôc xà kên itajê to ihcakôc jicu nare, ne cama apu Pahpãm to me amji kam hapac xà jũrkwa me, Mojxe xwỳ jõ kàhhôc na ihcakôc kêanre to ipa. ");
INSERT INTO ram_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ne hanea ne cute, pom pê Naxare jõ krĩ rũm Jeju cato ita, cute harẽn quê ha xwahna Pahpãm to me amji kam hapac xà jũrkwa hu, ne hanea ne Mojxe te amji kam hapac xà to antuw ita na ri harẽn, wa ite mempar — hane. ");
INSERT INTO ram_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mã mehcunea ne me jỹ, cute me ajpẽn par xà jũrkwa kam, ne me Tewãw kuc pupu. Mã ihkuc pê ihhêj rũm côjkwa pĩn Pahpãm mã imprar catê kuc pyràac, ne ihpràti. ");
INSERT INTO ram_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mã prohti kam me hõ pahhi pê Pahpãm mã mehcajrẽn catêjê jõ pahhiti ata te Tewãw cukij ne cumã: — Hàpà, me imã harẽ. Xà ajkĩ ampeaj kam me ato awjarẽ? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mã Tewãw me cumã: — Ỹhỹ, wa ha me amã icakôc, ca me ikampa. Me ikjêjê, menxũjê, me ikampa. Pê rỳ pêa mã Pahpãm pejti catihti ata me panquêtti Aprãw xwỳ mã amji to ajpẽ. Ne pê cormã Côpihpo na pjê ata kam ihkrĩ, ne nee cormã Pjêncràti jõ krĩ kam ihkrĩ nare. ");
INSERT INTO ram_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Pê Pahpãm cumã ihcakôc ne cumã: “Ỹhỹ, ca ha me akwỳ jicu, ne krĩ ita pê acato ne ma jũ kam tẽ. Wa ha amã pjê nõ jahkre ca ha kam akrĩ” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","— Pê Aprãw Pahpãm par pyrentu, ne Cartêj jõ pjê mã hikra ne ma cato. Ne ma Pjêncràti jõ krĩ wỳr mõ, ne curia ihkrĩ. Pê hũm ty. Pê cormã Pahpãm Aprãw kujate, me pajõ pjê wỳr, pê cato. ");
INSERT INTO ram_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pê nee cormã Pahpãm Aprãw mã pjê kwỳ jahkre nare. Ne nee cormã cumã ihkwỳ incrire ne hõr nare. Pê cormã ne Aprãw mã ihkra nõ hamreare. Pê ahnaa Pahpãm cumã pjê to awjahkre, ne to ihcakôc ne cumã: “Ỹhỹ, wa ha jũ caxuw amã pjê ita gõ. Quê ha me akra nõ tàmxwỳ atajê hanea ne pjê ita to me hõ tekjê” hane. Hõhõ, ita to pê Pahpãm Aprãw mã awjahkre, cormã ihkra nare kam, ne cumã: ");
INSERT INTO ram_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Ỹhỹ, wa ha me atàmxwỳ tàmxwỳ mã pjê ita gõ, quê ha me to hõ pjê, ne quê ha cormã ite me cumã pjê jõr xwỳjrea na, quê ha jũ caxuw jũa kam pjê nõ wỳr me mõ, ne curia mehkrĩ. Ne nee hanea ne me to hõ pjê nare. Jũm jõ pjê kam quê ha mehkrĩ, ne ampeaj kam me apêa to me apê. Ne me hõ na pit mã me cumã me hàpên catêjê na me ipa. Quê ha cormã pjê ata jõ pahhi ame to kêanre ne. Quê ha me to kên ita to caku to hàhtô to cwatxẽnta. ");
INSERT INTO ram_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jahpan xà na wa ha apu pjê ata jõ pahhi na mehkwỳ cunea to kên. Jirô pê mã, quê ha me atàmxwỳ tàmxwỳ me pjê ata jicu, ne ma hacpỹ ne rĩn wỳr me amji jaxà. Ne ita ri quê ha mehkrĩ ne me awpa, ne me ikampa” hane. Ita to pê Pahpãm Aprãw xwỳ mã ihcakôc, ne cumã to awjahkre. ");
INSERT INTO ram_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","— Ne hipêr cumã ihcakôc ne cumã amji ton to hane: “Ỹhỹ, cu ajpẽn pa. Ca ha me atàmxwỳ tàmxwỳ me, me gũpar to impeaj to me apa, ne ampeaj kam me ikampa, wa ha me ato ikra kênre nare. Ne quê ha ita na amã impej, ca ha apy kà kwỳ incrire ne hitep. Ne quê akra pỳm, ne hũmre, ca ha hanea ne impy kà kwỳ incrire ne hitep. Mãr quê mehcunea me apupu, ne me cumã me apê me ikraa to me ikra na me gahkre pej” hane. Ita na pê Pahpãm Aprãw xwỳ mã amji to, ne ahna me ajpẽn pa. Na pê Aprãw ihkra Ixac xwỳ kà incrire ne hitep, cormã incrire ne ahna amcro te ôjtô kam. Pê hanea ne Ixac kra pê Jaco xwỳ mã kà kwỳ incrire ne hitep. Pê hanea ne Jaco ihkra te tôxi atajê cunea kà kryjre ne hitep pa. ");
INSERT INTO ram_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","— Ne pyxit ata pê ri Joje xwỳ, pê cupê Jaco xwỳ kra. Ne pê mehkjêjê kà itajê ma ame ihtõ pê Joje te amji to hapu na kjê ata jũ na me amji to prãm, na pê ihpore na ampo kra mã me to ahpa. Pê ma ampo kra Joje japrô, ne to mõ, ampỳa mã hõ pjê pê Ejit jõ pjê ata wỳr. Ne curia pê ma irô mã jũm ita mã ihpore na to ahpa, pê ajco me hõ na pit mã, me cumã hàpên catê na ipa. Ne pê Pahpãm ihkôt mõ, ne cume ipa. ");
INSERT INTO ram_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ne pê Pahpãm Ejit jõ pjê kam ampo kên cunea pê Joje capa. Ne cumã amji jahkre pej catia ne cugõ. Ne cumã amji kam hapac xà impej pit gõ. Jirô pê mã, pê Ejit catêjê jõ pahhi japrỳ te Paro xwỳ ata Joje pupu, ne cumã ihkĩn, pê amji cahê na Joje xãm, cute ihtehcajpar prãmte. Pê Paro Ejit catêjê kam pahhi na Joje xãm, ne hanea ne amji jũrkwa jamãr catê na hãm. ");
INSERT INTO ram_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","— Hamre, pê caku te xet itajê jirô pê mã, me cupê me hõ hamre, Ejit jõ pjê kam, ne hanea ne me panquêtjê jõ pjê pĩn Joje cator xà japrỳ te Cana jõ pjê ata kam, me cupê me hõ hamre. Pê prãm na ame ipa. ");
INSERT INTO ram_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na pê me panquêtjê ihtỳj ame hõ na me hàhcukjêr to me ipa. Pê me panquêtti Jaco japrỳ nõ pê Ixaher ata Ejit jõ pjê kam, cormã me cumã me hõ na me harẽn pa, na pê ma curi mehkra kujate, pê ma curi me mõ. ");
INSERT INTO ram_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne pê me mõr to ajkrut kam, pê Joje cormã me cumã cupê mehkjê na amji jarẽ. Pê Paro me hõmpu ne me cupê Joje kjêjê na me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ne pê ma Joje hũm me, mehkjêjê cahhur wỳr mehkjêjê kujate, Cana jõ pjê pĩn cute me haprôr prãmte. Pê me mõ ne me cato, ne me hũm japrô, ne ma hacpỹ mã Ejit jõ pjê wỳr me to mõ, ne me to cato. ");
INSERT INTO ram_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pê me hàhtô na mehcunea me xetẽnta ne ihkôt xĩc, ne curi me cato, ne mehkrĩ. Ne curia mehkrĩ, pê me panquêtti Jaco pê Ixaher ihwej ne ty. Jirô pê mã, pê mehkra cunea me, me tàmxwỳ mea mã Ejit jõ pjê kam mehhi. ");
INSERT INTO ram_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pê me panquêtti ty pê ma ihmat ri, me hõ pjê wỳr, mehtàmxwỳ me to kwỳ. Ne Krĩjikre jõ krĩ kam me to cato, ne curia me harêt. Pom pê rỳ pêa mã, Aprãw Emõr kra jũhkra kam kẽn kre jũhkà ata kam. Ne ma me amji jaxà, hacpỹ mã Ejit jõ pjê wỳr. ");
INSERT INTO ram_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","— Pê me pahkwỳ pê Jaco tàmxwỳ tàmxwỳ pê Ixaher catêjê caku ata na ramã me ajcamẽ, ne me hàhtôa to me hàhtô. Pê ramã Pahpãm Aprãw mã Cana jõ pjê jahkre xà ata na caku hàhtêp to mõ. Por pê ampeaj kam cumã to awjahkrea to awjahkre ata wỳr. ");
INSERT INTO ram_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ne pê Ejit jõ pjê jõ pahhi tuw nõ hõ pjê ata jamãr na cupy. Ne nee pê Joje pupun nare, ne nee to amji japackre nare, pê rỳ pêa mã ramã Joje ty na pê. ");
INSERT INTO ram_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ne pê Paro ma apu Joje na mehkwỳ caca, ne me cumã ihhêj ne me to kên crire nare. Pê me cumã mehkra pỳpỳm atajê na harkwa, quê mehkra kryjre itajê cunea to cô kam me awcapê, quê mehhi. ");
INSERT INTO ram_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","— Pê amcro ata na Mojxe ihpỳm, ne impejti. Pê hũm me inxi ikrea kam me to ajrõ, pê ramã ahna putwrỳ incrê. ");
INSERT INTO ram_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jirô pê mã ri cute me mehkra curan catêjê cupate me to mõ, ne põ pê me cuxi, pê nõ. Pê ma hacpỹ mã me mõ, pê Ejit jõ pjê jõ pahhi tuw pê Paro kra cahãj ita cato, ne mõ, ne Mojxe pupu, ne cupỳ ne ma to mõ, ne to ihkra. ");
INSERT INTO ram_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pê Mojxe, curia Ejit catêjê jipôc ri ihkà. Pê Ejit catêjê Mojxe mã cute me amji jahkre pej cunea to hahkre. Pê Mojxe amji jahkre pej, ne ihcakôc pej, ne hàpên pej cati. ");
INSERT INTO ram_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","— Hamre, pê ramã ahna caku cwarẽnta ne ihkàhtu. Ne pê mehkjêjê me, mehkwỳ pê Ixaher catêjê pupun prãm. ");
INSERT INTO ram_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ne pê ma hacpỹa mã mehkwỳ wỳr amji jaxà. Ne me hõmpu, pê Ejit catêjê nõ apu Ixaher catêjê nõ to kêanre. ");
INSERT INTO ram_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pê Mojxe me hõmpu ne amji mã: “Hamre, ita caxuw wa ha Ejit catêjê nõ ita cura. Ita caxuw quê ha me ikwỳ me ijàpên xà pupu, ne me Pahpãm te ikujahêc me ijahkre pej, ite Ejit catêjê te ame to kên pê me caxàr xà na” hane. Na pê ma me hỹrmã tẽ, ne Ejit catêjê nõ ita cura. Ne pê Mojxea me hamãr catê na amji to. ");
INSERT INTO ram_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pê apẽ pê Mojxe ma hipêr Ixaher catêjê wỳr mõ. Pê ramã mehkwỳa nõ me ajkrut ne ame ajpu. Pê Mojxe me hõmpu, ne ahna cupê ihkaj na. Pê ma me hỹrmã cato, cute ajpẽn kam me to impej prãmte. Ne me cumã: “Pỳhàpà, ajwar me apê Ixaher catêjê, ne ca ajpẽn to me akjê. Ne ampo na mã ca ame ajpu?” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","— Pê apu mehkwỳ nõ to kên to mõ ata ma apu Mojxe curê, ne cumã: “Nee jũm te me ijõ pahhi na axãm nare. Ca ame ijapackre to mõ, ne ita ri ate me icukij xà hamreare. ");
INSERT INTO ram_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Xà ca ha pijamã ihnõ kam ate Ejit catêjê nõ curan ata cuxà icura?” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pê Mojxe kampa, ne cumã hũpa pê ma acto, Mitij jõ pjê ata wỳr. Ne curi cato, ne curia ihkrĩ. Ne curia hikwa tuw, pê cumã ihkra xũmre ajkrut ne cato. Ne curia pê amji to ajpa, Mitij jõ pjê kam. ");
INSERT INTO ram_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","— Ne pê pjê ata kam amji to caku to cwarẽnta. Ne ajco apu ipa, por põti kam me hamreare ata ri, kẽnti catia japrỳ te Ihcuhhyt jõ kẽn ata kam. Hamre, pê Pahpãm côjkwa pĩn cumã memprar catê nõ na amji jahkre, ne cumã amji to ajpẽ. ");
INSERT INTO ram_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Pê Mojxe hỹrmã cato, ne xa, ne cuhy pôc pupu, pê aprêj pôr ata, ne nee caxàr nare. Pê cuhy caxwãm pê Pahpãm mã imprar catê nõ pupu. Pê higẽc ta, pê hỹrmã ahtêp, cute hõmpun pej prãmte. ");
INSERT INTO ram_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Mã Pahpãm te cumã ihcakôc ne cumã: “Hàpà, pa wa, ne ipê me aquêtjê Pãm cati. Ne ipê Aprãw me, Ixac me, Jaco Pãm cati” hajỹr. Hamre, pê Mojxe kampa ne hũpate apu ihtertet, ne nee hipêr hõmpun nare. ");
INSERT INTO ram_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","— Hamre, pê Pahpãm cumã: “Hamre, ita caxuw ca ate ipeaj to ipej na, ijahkre pej. Cwỳrjapê ca ha apar kà capa, ne apar cakrô icuna mã xa. Wa ha ate ito impejti na gahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ne ramã ite me ikra pê Ixaher catêjê pupun. Mã Ejit jõ pjê kam ame ipa. Mã Ejit catêjê ame to kêanre, wa ite mencwỳr par, ne me hỹrmã iwrỳc. Na wa ha Ejit jõ pjê intête, mehkên ita pê me capa. Ne caa, ca ha ita caxuw ma me hỹrmã tẽ, Ejit wỳr” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","— Ne pom pê Pahpãm me cumã Mojxe xãm ata pê ma Ixaher catêjê ame curê. Ne pê amcro ata na me Mojxe mã: “Pê nee jũm me ijõ pahhi na axãm nare, ate me ijapackre xà na. Ne nee ita ri ate me icukij xà nare” hane. Pê ahnaa Pahpãm me hõ pahhi na me cumã Mojxe xãm, pê cupê me hõ pahhi, ne cupê mehkên pê me to hapôj catê. Ita na pê côjkwa pĩn Pahpãm mã imprar catê harkwa kôt Mojxe xãm. Ne hamre, pê Mojxe Pahpãm jarkwa kôt hacpỹa mã Ejit jõ pjê wỳr cato. ");
INSERT INTO ram_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne cupê me to cato. Ne pê carôt kôt rỳ jũ caxuw jũm te ampo pihho pupun nare atajê ton to hàhtôa to hàhtô. Ne pê harkwa to Ejit jõ pjê kam hàpên xà to, ne hanea ne côxwa japrỳ te Côxwatepti ata kam to. Jirô pê mã pê pjê caprỳhti ata kam, curia me amji to caku to cwarẽnta, ne curia cormã ame ipa. ");
INSERT INTO ram_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","— Pê Mojxe me panquêtjê mã ita jarẽ, ne me cumã: “Ỹhỹ, quê ha jũ caxuw Pahpãm me amã jũm te harkwa na me amã ihcakôc catê ata kujate. Quê ha me anõ capi, ne me anõ xãm, hàpên xà ita caxuw. Ahnaa mã pê ixãm he” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na pê Mojxe ajco Ixaher catêjê pê me panquêtjê to ipa, pjê caprỳhti ata kam. Ne côjkwa pĩn Pahpãm mã imprar catê me ajco ipa, por pê kẽnti japrỳ te Ihcuhhyt jõ kẽn kam xa, ne Mojxe mã ihcakôc ata me. Na pê Mojxe Pahpãm jarkwa pejti incwa, cute me cumã harẽn xà caxuw. Ne me cumã harẽ, ne ma me pamã ahna ihhôc. ");
INSERT INTO ram_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","— Na pê ma ame Mojxe curê, ne ma amempar caca. Ne ma hacpỹ mã Ejit jõ pjê wỳr me amji jaxàr prãm. ");
INSERT INTO ram_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hamre, pê Pahpãm mã Mojxe ihcakôc prãmte me cupê cato. Pê ma ihtõ kà japrỳ te Arãw wỳr me pra. Ne me cumã: “Ỹhỹ, jũ kam Mojxe pictor. Mãr cute Ejit jõ pjê pĩn me pajaprôr ne me pahto mõ, taa ri jũ kam ipictor. Arãw, me imã wakỳre te pahpãm cahàc krekà nõ to. Quê ha wakỳre te pahpãm cahàc krekà ita me ito ipa. Ne taa me pajamã” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","— Pê amji cunea mã me wakỳre to me pryti krahti pê me hõ pahpãm cahàc krekà ata to, ne me to cati prãmte, cumã mehcakôc pejti. Ne ajco me cumã pryre ihcura, cute mehkĩn prãmte. Ne wakỳre te pryti kra pê pahpãm cahàc krekà ata pyrên me hakryte ajco me cumã me hàkrun xà ita to. ");
INSERT INTO ram_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pê ma Pahpãm ame curê, ne me to tojnõ, mãr quê ha me taa amji mã mehkên ton to me ipa. Na pê amjia kôt amji mã caxêre to me hõ pahpãm cahàc. Na pê Pahpãm jarkwa na ihcakôc catê ita na me ahna ihhôc. Ne hõ kàhhôac kam pê ihhôc to hane he: “Pỳhàpà, me apê Ixaher catêjê. Rỳ pêa mã ca pjê caprỳ catihti ita kam ame apa, ne ramã ame apa xà ita kam me ana caku te cwarẽnta. ");
INSERT INTO ram_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Xà ite pryre kĩn prãmte ca amehcura? Hãpà. Hamreare, ca cormã atỳj me to ihcupan to me apa. Ne ca cormã me akrãa kam ca me to amji kampa. Hõhõ, ita cwỳrjapê pê ca amjia kôt amji mã me wakỳre to me apãm cahàc krekà itajê to me hàhtôa to me hàhtô. Ne pê ca hanea ne me apãm cahàc japrỳ te Moroc ata mã me pryre itajê cura, cute ihcajpuaw prãmte. Ne pê ca me apãm cahàc krekà ita cjên xà kam ajco me acjê, ne ma me to apa. Ne pê ca hanea ne me apãm cahàc krekà japrỳ te Renpa pê caxêre pyràcti nõ ata pê ca me to. Hõhõ, me akên xà itajê to, pê ca ajco me hajỹr to me apa. Ita cwỳrjapê wa ha me ana me acurê xwỳn mẽ, ne me ato mehkujate, Papirõn jõ krĩ jĩkjê wỳr ampỳa mã ata wỳr, quê ha ma me to mõ” hane. — Ita na pê Pahpãm jarkwa na ihhôc catê harkwa kôt ihhôc. ");
INSERT INTO ram_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","— Ne cormã ita jamreare kam, pê Pahpãm Mojxe mã, pê ampo kà to, cute me to amji kam hapac xà jũrkwa to. Pê Mojxe Pahpãm jarkwa ata na, ahnaa to. Pê me panquêtjê ajco ampo kà te Pahpãm jũrkwa to ame hy, pjê caprỳhti ata kam. ");
INSERT INTO ram_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ne hamre, ramã me ahna caku jàhtôa kam pjê ata mã me hàr xàa wỳr pê Mojxe xwỳ ihhi. Ne hamre, pê Jojuw xwỳ haxà na axà, ne ma me panquêtjê to hy, pjê ata wỳr. Por pê Pahpãm me cumã pjê jõr xà na to awjahkre ata wỳr. Ne pê ramã Pahpãm pjê ata kam mehkrĩ catêjê cunea japôj pa. Ne kam Ixaher catêjê jỹr, pê me haxà kam me xa. Pê ahnaa me hõ pahhi Tawi jõ amcro kam ahtwỳ. Pê cormã ampo kà te Pahpãm jũrkwa ata me cumã ahtwỳ ne ihcuhhê. ");
INSERT INTO ram_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","— Ỹhỹ, pê Pahpãm pê Jaco jõ Pahpãm mã Tawi kĩnti. Pê Tawi, cute cumã ikre nõ impejti xãm prãmte ahna ahwỳ. ");
INSERT INTO ram_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ne pê Tawi kra japrỳ te Xarômãw ata pê ikre pyxwỳr catê, na pê cumã ikre xãm. ");
INSERT INTO ram_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","— Quê ha pijamã me pajõ Inxũ pê Pahpãm ne mehcunea jirôa pê cati ata, cute me hũhkra na me ikre xãm, ata kam ihkrĩ? Quê! Hamreare! Wỳr quê kam ihkrĩ! Me Pahpãm ata côjkwa kam ihkrĩ. Pê ramã harkwa na ihcakôc catê ita na ihhôc. Pê harkwa na ihhôc to hane he: ");
INSERT INTO ram_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ipê me gõ Pahhiti pê Pahpãm. Ne côjkwa kam ikrĩ xà, ne pjê kam ri ipar pyxwỳr xà. Ne côjkwa pĩn wa me ato ihimpej. Xà ikre ita kam ikrĩ xà na mã ate me imã ton? Jũ wỳr ca me imã to, wa kam ikrĩ ne kôt. Hamreare! Wa nee ahna prãm nare. ");
INSERT INTO ram_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","He pa pê wa ampo itajê cunea to” hane. ");
INSERT INTO ram_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","— Hamre, he ramã me apê me panquêtjê pyràac, ne me akêanre! Ca nee me Pahpãm jarkwa par nare. Ne hanea ne ma apu amji tête me Pahpãm Carõ Pejti curê. Ne nee mehcakôc par nare. ");
INSERT INTO ram_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ne amjia kôt ate me amji kam me gapac xàa to ame amji kam gapac to me apa. Pê Pahpãm jarkwa na mehcakôc catêjê me panquêtjê mã amcro nõ na Pahpãm kra impejti cator na to awjarẽ, pê ca nee mempar nare. Ne atỳj me Pahpãm jarkwa na mehhôc catêjê atajê jipej. Ne pê jũm to awjahkre ata na, ihtỳj me pahwỳr iwrỳc. Ne Pahpãm kra pê cato, pê ca mehcura. Ahnaa mã pê Pahpãm ajpẽn harkwa na cumã ihhôc catêjê kujate, pê me panquêtjê me hipej he, ata na ca ate me Pahpãm kra ton, ne ate mehcuran. ");
INSERT INTO ram_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ne côjkwa pĩn Pahpãm mã imprar catêjê pê me amã harkwa ita jarẽ, pê ca nee ajte me gũpar nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mã hamre, prohti kam te me Tewãw jũjarẽn xà ita par. Ne ame kam incryac to amencryc, ne kam mencryc xà to ame wa gyj. ");
INSERT INTO ram_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mã Pahpãm Carõ Pejti te Tewãw carôt to hipu tu, mã côjkwa wỳr irĩt, ne cute Pahpãm jàhcujro pejti pupun, ne hanea ne cute Jeju pupun, mã Pahpãm jĩkjê rũm xa, awpôc rũm. ");
INSERT INTO ram_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mã Tewãw te me cumã harẽn to: — Mẽr he. Wa itỳj côjkwa catac pupu, ne itỳj me Ahàkà pê Jeju pupu he, mã Hũm Cati jĩkjê rũm xa, awpôc rũm — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Me ajkaam mã cute me hapac jihê par, ne kỳj cati pêa mã ame caràr, ne Tewãw wỳr mehprõt ne cute mehpro. ");
INSERT INTO ram_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ne cute krĩ pê me to cator, me ajkaam kẽn to kam me hũcapêr kam mehtẽm, cute me to curan prãmte. Mã mehhêj xi catêjê te me hõ hitô kà caxàr, ne me jũm tuwre japrỳ te Xawrô ata mã me hõr, me hahkà na, cute me cumã hamãr prãmte. ");
INSERT INTO ram_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ne cute kẽn to Tewãw curan prãmte kam me to awcapê, mã Jeju mã akij ne cumã amji jarẽn to: — Jeju, icarõ japrô — hane. ");
INSERT INTO ram_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jirô pê ihkõn krã na hỹr, ne kỳj cati pêa mã caràr ne Pahpãm mã: — Cute ame ito kên itajê kam acryc nare — hane. Hõ, cute ita to ihcakôc to hajỹr ne ihtyc. Mã ampeaj kam cama Xawrô mã Tewãw curan na impej. ");
INSERT INTO ram_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mã amcro ata na, Krĩpinkrên kam, cute me Jeju na mehkwỳ to mehkên kam mehtẽm ne ame to kêanre. Ne cute amehkwỳ incràn, Krĩpinkrên pê. Mã mehkwỳ curia Juta jõ pjê kam ame ipa, ne ma mehkwỳ Krĩrĩtpej jõ pjê mã ame incjêj, mã Jeju mã memprar catêjê pit jàhhuc. ");
INSERT INTO ram_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mã me hũmre te Pahpãm to me amji kam hapac catêjê atajê te me Tewãw to me hapac xàhte me amrã, ne cute me harêt. ");
INSERT INTO ram_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mã Xawrô te Jeju na mehkwỳ to hamre prãmte, hãn ne ihtỳj hõtpê ame ahna hàhcukjêr to ipa, ne ikrea mã incjêj to ipa, ne me hũmre pro, ne pyjê pro, ne me hacjên xà mã me hacjê. ");
INSERT INTO ram_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mã ame ipicràn atajê pê Jeju na mehkwỳ, ne mehcunea mã, pjê cunea kôt ame Jeju jarẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mã ma Pirip Krĩrĩtpej wỳr iwrỳc, ne curia mehkrĩ atajê mã apu Jeju jarẽn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mã me hàhtôa ne cute me Pirip jũjarẽn xà impar to impejti, ne harkwa to cute hàpên xà ton ata na me hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mã Pirip te me kam ampo carõ kên atajê jàhtôa ne mentête hapôj, mã ma me caràr to pra. Mã cute me xwỳ me, me cukrã xà pec catêjê jàhtôa ne hanea ne caprãr. ");
INSERT INTO ram_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mã mehcunea jakry pit, Krĩrĩtpej kam. ");
INSERT INTO ram_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pê curia hũmre japrỳ te Ximãw ata ihkrĩ, ne ampeaj kam hũxy xi, ne amcro jàhtôa kam ajco me to hy. Ne ihtỳj ajco amji to cati prãm. Na pê Krĩrĩtpej catêjê cunea Ximãw cati na amehcãmjĩ, ne ampeaj kam amji mã me to hane. ");
INSERT INTO ram_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne ampeaj kam ajco me kampa. Mehkà me, ahkrare me, mehcunea ajco me kampa. Ne ajco me ajpẽn mã: — Ỹhỹ, ihhêj ne hũmre ita kam Pahpãm carôt, ne ampeaj kam cati, ne ihhêj ne Pahpãam pĩn ri cator — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ampo na? Rỳ pêa mã ri Ximãw ata mehkwỳ to hy na ri, ihtỳj me kampa. ");
INSERT INTO ram_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mã hanea ne cute me Pirip jũjarẽn xà impar, Jeju pê me pahkritxwỳ na harẽn xà impejti ata na. Mã Pirip te cute Pahpãm himpej xà mã mencjêj na me amji jarẽn prãmte, harkwa na me hũmre me, pyjê me, cô kam mehcumrãr, mã cute me Jeju te amji kam hapac xà pynãr. ");
INSERT INTO ram_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mã hanea ne, Ximãw te Pirip jũjarẽn xà impar, ne ihtỳj Jeju na mehkwỳ mã hàr prãm. Mã Pirip te cô kam ihcumrãr, mã cute hũnãr ne hũ na pire mã apu ihkôt ipa, ne hãn ne Pirip te harkwa to hàpên xà impejti ton to ipa atajê to amji mã ipikrar catia to ipa. ");
INSERT INTO ram_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mã Jeju jarkwa na cumã memprar catêjê, Krĩpinkrên kam ame ipa atajê, te me Krĩrĩtpej catêjê te hanea ne Pahpãm jarkwa par pejti na, cute me harẽn par. Mã ihtỳj Jeju na mehkwỳ mã me acjêj. Mã ma cute me Petrô me Jowãw kujahêc, Krĩrĩtpej wỳr. ");
INSERT INTO ram_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mã curi me cator, ne Pahpãm na me ahwỳ, quê Krĩrĩtpej catêjê te Jeju to amji mã mehhimpej atajê mã Carõ Pejti gõ. ");
INSERT INTO ram_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ampo na? Nee Pahpãm Carõ Pejti ata cormã mehwỳr iwrỳc, ne cute me cumã amji jõr nare. Mã ihtỳj Pirip te Jeju jarkwa na cô kam mehcumrãr. ");
INSERT INTO ram_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Cwỳrjapê ri Petrô me Jowãw te me ahna hũ xir, ne me ahna Pahpãm wỳr, mã Pahpãm te me cumã Carõ Pejti jõr. ");
INSERT INTO ram_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mã Ximãw jũxy xi ata te Petrô me Jowãw te jũmjê atajê na hũ xir, mã mehkôt Pahpãm te jũmjê atajê mã Carõ Pejti jõr na me hõmpun. Ne ma me hỹrmã tẽ, ne ihpore to ame kampa, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","— Petrô me Jowãw, wa hanea ne me acarôt ita na prãm. Wa ha me amã ihporea gõ, ca ha me imã Pahpãm carôt gõ, mãr wa me acuxà jũm na ijũ xi, quê amji mã Pahpãm Carõ Pejti py — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mã Petrô te cumã harkwa to: — Akên xà wỳr, ca gõ pore ita to tẽ! Mõrmõ ca amji mã: “Wa ha itỳj ihpore to Pahpãm carôt japrô” hane. ");
INSERT INTO ram_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","He nee ate me ijàpên xà jĩkjê to amji pytàr xà hamreare. Ne Pahpãm mã ate amji kam gapac xà hêj xi xà ita nee impej nare. ");
INSERT INTO ram_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nãmhã, ne ate amji kam gapac xà kên ita jicu, ne Pahpãm na ca ahwỳ, quê atête akên ita camẽ, ne akên ita to tojnõ ne amã to impej. ");
INSERT INTO ram_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","He ramã ate akên ita to amji krãhtu, na ca ajte me ijũ na apu ita kĩn, ramã ite me gahkre pej — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mã Ximãw te me cumã: — He nãmri! Ca ma imã Pahpãm wỳ, quê nee ate me imã ampo kên jarẽn xà itajê nõ to, ito kên nare — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mã Petrô me Jowãw te me cumã Pahpãm jarkwa jarẽn par, ne ma Krĩpinkrên wỳr cute me amji jaxàr. Ne pry kôt, Krĩrĩtpej jõ pjê kam ihtỳj me Pahpãm jarẽn pejti atajê jarẽn cràn to me mõ. ");
INSERT INTO ram_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mã côjkwa pĩn Pahpãm mã imprar catê Pirip wỳr iwrỳc ne cumã: — To xa, ne ma Krĩpinkrên me Krĩhtỳj jõ pry kôt tẽ, por curi põti kam me hamreare, ata wỳr — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Mã Pirip xãm ne ma ihtẽm pyrentu. Ne pea curi cator. Mã cupẽtycre nõ ita te Krĩpinkrên kam Pahpãm to amji kam hapac jirô pê, ma hacpỹa mã hõ pjê japrỳ te Cupẽtycre jõ pjê ata wỳr amji jaxàr. Ne pê hũmre ata pê pahhikwỳj catia japrỳ te Cantikwỳj ata tehcajpar catê, ne ajco cumã hõ pore jamã. Ne cawrô jõ kujti kam jỹ, ne apu ihkàhhôc ata cahyt. Ne ihkàhhôc ata pê Pahpãm jarkwa to ihcakôc catê japrỳ te Ixaj xwỳ, ata jõ kàhhôc, pê jỹ ne apu cahyt. ");
INSERT INTO ram_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mã Pirip te hõmpun, mã Pahpãm Carõ Pejti cumã: — Tẽ ne cawrô jõ kujti wỳr acato — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","33","Mã Pirip ma hỹrmã ipicahur ne ahna cator. Ne cute cupẽtycre ata Ixaj xwỳ pê Pahpãm jarkwa to ihcakôc catê jõ kàhhôc to jỹ ne apu cahyt na kam hapac. Pê Pahpãm jũm capi ne to awjahkre ata na ri ihkàhhôc ata cahyt, ne cahyt to: “Ỹhỹ, jũm ata pê pryre capônỹre pyràac, ne cupê carà cahàcre hôhti pyràac. Mã ma ihcuran xà wỳr me to mõ, mã capônỹre mõ. Me to mõ ne ame cupê ihhô ata jakep, mã aracri xa, jĩkjê na ri jũm ita pê carà cahàcre hôhti pyràac, ne nee ihcakôc nare, ne aracri xa. Mã cute me jũm ata to incrire, ne me kam mare mã cute me cuprãr tu, mã cute ihpahàm catia ne ipyr, ne apu ihpahàm. Ne nee cute me jũm ata to impej nare, ne cute ame to kêanre. Ne nee cormã ihkra nare kam, cute mehcuran, mã pjê kam cute amji to ipijapar xà ata jamre” hane. Mã Pirip cumã: — Hàpà, xà ca atỳj, pom ca apu ihkàhhôc cahyt ita kampa? — hane. Mã cumã: — Quê, hamreare, wa itỳj cahyt ne nee impar nare. Ipê jũm te imã ihkôt harẽn xà nare ita kam, jũ mã wa ha ne hahkre pej? Ca ha pijamã imã to hahkre? Gapacta ne api ne icahê na jỹ, ne imã to hahkre — hane. Mã Pirip jàpir ne cahê na hỹr, mã cumã: ");
INSERT INTO ram_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","— Imã to hahkre, xà amji naa mã pê ihhôc? Nare xà ajteare mã jũm na pê ihhôc? — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mã Pirip te cumã Jeju jarẽn kam ihtẽm, ne cumã: — Ỹhỹ, pom jũm ita nee mã jũm nare, Jeju jarẽn mã he, ne curmã wa ite me hõmpun — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ne ma ajwar me mõ, mã ihtỳj Pirip cumã to hahkre to mõ, ne pea cô jarare na me iwrỳc. Mã cupẽtycre ita Pirip mã: — Cô he, hõmpu. Ne imã Jeju na mehkwỳ mã ixàr prãm. Ca pijamã caxuw icumrã? — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mã Pirip cumã: — Ca ha ampeaj kam Jeju to amji mã ahimpej, ne mehkwỳ mã axàr prãm, wa ha itỳj caxuw acumrã — hane. Mã cumã: — Ỹhỹ, wa ha itỳj amji mã to ihimpej, ne ampeaj kam ri cupê Crixtô pê Pahpãm kraa to ihkra, na wa itỳj ahna mehkwỳ mã ixàr prãm — hane. ");
INSERT INTO ram_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mã kujti to hàhhuc, ne ajwar cô mã me iwrỳc, mã pea Pirip te cô kam cupẽtycre ata cumrãr. ");
INSERT INTO ram_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ne cô pê me hàpir, mã Pahpãm Carõ Pejti te ma Pirip japrôr ne to tẽ. Mã cupẽtycre te nee hipêr hõmpun nare, ne ampeaj kam Jeju pyrên hakry, mã ma hõ pjê wỳr tẽ. ");
INSERT INTO ram_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mã ihprõt pê Pirip Axoti jõ krĩ kam cator. Ne ma Xexa jõ krĩ wỳr tẽ, ne pry kôt krĩ ihcuhhê atajê cunea mã Jeju jarẽn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ata jõ amcro kam ri Xawrô cormã Jeju na mehkwỳ curan prãm to ipa. Mã Tamatcô jõ krĩ kam hanea ne Jeju na mehkwỳ jàhtôa ne mehkrĩ. ");
INSERT INTO ram_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Cwỳrjapê ri Xawrô ma Pahpãm mã mehcajrẽn catêjê jõ pahhi wỳr tẽ, ne cute ahna hàhwỳr, quê cumã cute Jeju na mehkwỳ pro xà na ihkàhhôc to, quê mehpro pa. Mã hõ pahhi te Tamatcô jõ krĩ kam Juta catêjê te me cuprõn xà kam me hõ pahhi catêjê atajê mã ihhôc, quê me cahyt, ne me Xawrô tehcajpa. Ne me cupê Jeju na mehkwỳ xũmre me, pyjê me, mehpro ne me huwapre, ne ajpên Krĩpinkrên wỳr me to pra. Hõhõ, pê me caxuw mehcajrẽn catêjê jõ pahhi mã ihhôc to hane, ne me cumã cugõ. ");
INSERT INTO ram_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mã Xawrô na mehkwỳ ramã Tamatcô jõ pry kôt, krĩ ata na me hàhtêp tu, mã krã, côjkwa pĩn ampo pràti ata te ahna ipixêr. ");
INSERT INTO ram_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mã Xawrô pjê kam ihpỳm, ne cute côjkwa pĩn jũm ata par, mã cute cumã harkwa to hajỹr: — Xawrô, Xawrô, ampo na mã ca apu ito kên to apa? — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mã cumã: — Me anõ mã ca? — hane. Mã cumã amji jarẽn to: — Ipê Jeju, mãr ca ate apu ito kên ata! ");
INSERT INTO ram_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","To xa ne krĩ mã axà, quê ha jũm amã ate ampo ton xà ata to awjarẽ — hane. ");
INSERT INTO ram_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mã Xawrô na mehkwỳ xũmre atajê cunea te amji mã me ipikrar, ne me ipẽrkêt ne me ipẽrkêatre. Ne ihtỳj cute me hõkre par, ne nee cute me jũm pupun nare. ");
INSERT INTO ram_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Mã pjê pê Xawrô xãm, ne into catac, ne nee irĩt nare. Mã cute me hũhkra na ipyr, ne ma Tamatcô jõ krĩ wỳr me to mõ. ");
INSERT INTO ram_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mã irĩt nare na amcro incrê, ne cama jỹ ne apu Jeju to amji kampa, ne nee hàpàn nare, ne nee ihkõm nare, ne cama jỹ ne apu ajkampa. ");
INSERT INTO ram_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mã Tamatcô jõ krĩ ata kam Jeju na mehkwỳ nõ ita ihkrĩ, ne haprỳ te Anana. Ne irĩat kam cute Jeju pupun, mã cumã akij ne cumã: — Anana — hane. Mã cumã: — Ampo? Ita ri wa xa — hane. Mã cumã: ");
INSERT INTO ram_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","— Apu amji mã ahcuprõ ne ma Juta jũrkwa wỳr pry cuhtacti ata kôt tẽ. Curia ri, por pê Krĩjara kam Xawrô ihpỳm ata jỹ, ne apu imã ihcakôc. ");
INSERT INTO ram_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ne cute irĩat kam amji na apê Anana pupun, mã hỹrmã hàr ne cute into na cumã hũ xir, mã hacpỹa mã irĩt. Na ca ha caa tẽ, ne Xawrô na gũ xi ne caprã — hane. ");
INSERT INTO ram_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mã Anana cumã: — Ijõ Pahhiti, ramã mehcunea te me imã hũmre ita te Krĩpinkrên kam ampo cunea to kên ata na me harẽn, ne cute ame akwỳ to kêanre. ");
INSERT INTO ram_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne cute mehcajrẽn catêjê jõ pahhi kwỳ jõ kàhhôc pyr, ne ajpên to tẽ, Tamatcô jõ krĩ wỳr, cute me akwỳ te, ate mehtehcajpar xà na me awỳr atajê jacjên prãmte — hane. ");
INSERT INTO ram_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mã Pahhiti pê Jeju te Anana mãn, ne cumã: — Wa ite amji mã hũmre ata te ijarkwa na imprar catê na capi ne ahna hãm, mãr quê ijarkwa na mehcahkrit me, me cupê pahhi cati me, Juta catêjê mã ihcakôc. ");
INSERT INTO ram_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","He wa ha pa Xawrô mã ijàpên xà to hahkre, quê ha imã apê. Ne icwỳrjapê cupê cute amji na ihkên xà cunea pupun catê — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mã ma Anana mõ ne ikre mã hàr, ne cute Xawrô na hũhkra xir ne cumã: — Itõ Xawrô, pom ate pry kôt Pahhiti pê Jeju pupun ita te ri ajpên awỳr ikujahêc, ca hacpỹa mã rĩt, quê hanea ne Pahpãm Carõ Pejti carôt ato hipu — hane. ");
INSERT INTO ram_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mã ampo pê tep kà pyràcti ita into pĩn cumã ihpỳm, mã hacpỹa mã irĩt pyrentu. Hamre, ita jirô pê mã ri Xawrô xãm, mã Anana te cô kam ihcumrãr. ");
INSERT INTO ram_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mã hàpàn jirô pê, hacpỹa mã ihtỳj taa to ihtỳj. Ne cute amji to amcro jàhtôa Jeju na mehkwỳ kam, Tamatcô jõ krĩ kam. ");
INSERT INTO ram_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Xawrô te Jeju na mehkwỳ na amji ton, ne Juta catêjê te me cuprõn xà kam, ihcakôc kam ihtẽm pyrentu, ne cute me cumã: — Jeju pê Pahpãm kraa to ihkra — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mã mehcunea te me Xawrô par, ne amji mã me ipikrar, ne me ajpẽn cukij to: — Pỳhàpà, mãr hũmre ita pê Krĩpinkrên kam Jeju na mehkwỳ curan catê ta? Pom hãn ne Jeju na mehkwỳ pro ne mehcajpre, ne ma hõ pahhi cati wỳr me to ipa prãm ita? Taa mã ri cator — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mã Xawrô amcro cunea kam me cumã carôt tỳaj kam hũjarẽn to ihcuhhê tu. Ne cute hũjarẽn to: — Ỹhỹ, por pê rỳ pêa mã Pahpãm Crixtô cator xà na to awjahkre ataa ri cator, ne cupêa ri Jeju — hajỹr. Ne cute Juta catêjê pê Jeju na mehkwỳ nare atajê mã caxwãm catia mã Jeju jarẽn. Mã nee jũm te cumã jũ mãn nare, ne aracri mehkrĩ. ");
INSERT INTO ram_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mã ahna amcro jàhtôa jirô pê Juta catêjê te amji na me cuprõn, ne Xawrô curan na me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mã Xawrô te amcro me caxwa cunea kam, krĩ cati jõ kwỳc jarkwa mã me hikaj ne mehcuran prãm na, cute me hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mã caxwa ata kam, Jeju na mehkwỳ kwỳ te kàhà catia kam Pawrô jỹr, ne ma krĩ pê, kẽn te kwỳc catia ata pê me to iwrỳc. ");
INSERT INTO ram_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mã Xawrô ma Krĩpinkrên wỳr tẽ, cute curi Jeju na mehkwỳ mã hàr prãmte. Mã Jeju na mehkwỳ ma ame hũpa. Ne nee mempar nare, ne nee cupê Jeju na mehkwỳ na, cute amji mã me to hajỹr nare. ");
INSERT INTO ram_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mã Parnap te Xawrô tehcajpar, ne ma to mõ, ne cute me to cuprõn, ne Jeju jarkwa na memprar catêjê mã Xawrô jarẽn, cute me hahkre pej prãmte. Ne cute me cumã Xawrô te pry kôt Pahhiti pê Jeju pupun, mã cute cumã ihcakôc na harẽn. Ne hanea ne Parnap te Xawrô Tamatcô jõ krĩ kam Juta catêjê mã, Jeju jarkwa to ihcakôc tỳaj na me cumã harẽn. ");
INSERT INTO ram_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jirô pê mã ri Xawrô te Krĩpinkrên kam me hũnãr, ne ma mehkôt mõ, krĩ cunea kôt, ne caxwãm catia mã apu Jeju jarẽn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mã Xawrô me, Juta catêjê kwỳ pê Crec jarkwa to mehcakôc catêjê me, me ajpẽn mã me Jeju jarẽn xà atajê to me ajpẽn mã me harẽn to me mõ. Ne ihtỳj me Xawrô curan to prãm. ");
INSERT INTO ram_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mã Jeju kam ajpẽn to mehkjêjê te ahna mempar, ne ma Xexa jõ krĩ wỳr me Xawrô japrôr. Ne ma Krĩjara jõ krĩ wỳr mehkujahêc. ");
INSERT INTO ram_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mã Jeju na mehkwỳ, Juta jõ pjê me, Hĩpôjajo jõ pjê kam, me ipinkrên, ne hanea ne Krĩrĩtpej jõ pjê kam, mehcunea pinkrênti. Mã nee jũm te ame to kên nare. Ne pê ajco me ajcamẽ, ne me hàhtô, pê Pahpãm Carõ Pejti me to ihtỳj, na pê mehcunea ajco me Pahhiti pê Jeju kampa, ne amji mã me hũpa. ");
INSERT INTO ram_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mã Petrô ihtỳj pjê cunea kam apu mõ, ne amcro nõ na ma Rita jõ krĩ wỳr tẽ, cute curi Jeju na mehkwỳ amehkrĩ atajê pupun prãmte. ");
INSERT INTO ram_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ne cute hũmre haprỳ te Enêj ata cukrã xà peacre, ne nee ipa nare ata cajpar. Pê ramã Enêj ata hikwa xà ata kam ahna caku ôjtô. ");
INSERT INTO ram_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mã Petrô te cumã harkwa to: — Enêj, quê ha Jeju acaprã, ca ha axãm pyrentu, ne gikwa xà to ahcuprõ — hajỹr. Mã Enêj xãm pyrentu. ");
INSERT INTO ram_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mã Rita jõ krĩ ata me, põ japrỳ te Xaron jõ pjê kam mehkrĩ atajê te me ampo ton xà ata pupun, ne ma Jeju na mehkwỳ wỳr me ipipkjêr, ne cumã me hàr. ");
INSERT INTO ram_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mã Krĩmpejre kam Jeju na mehkwỳ nõ cahãj ihkrĩ ata japrỳ te Tapita Caràhkwỳj, ne Crec jarkwa na haprỳ te Torca, ne amcro cunea kam hõtpê me cumã ampo pej pit ton to ipa, ne me cupê hamreare atajê tehcajpar to ipa. ");
INSERT INTO ram_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ne amcro ata na Caràhkwỳj xà, ne ihtyc. Mã cute mehcuhhõn ne mehcũmpej, ne ma kỳj pê ikre caxwỳn kam me hir. ");
INSERT INTO ram_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mã Jeju na mehkwỳ te me Petrô te Rita jõ krĩ kam apu mõr na me harẽn par. Pê Krĩmpejre me ajpẽn na pire mã krĩ ata xa, na ri cute Petrô japrôr to hỹrmã me hũmre to ipijakrut ne mehkujahêc. Mã me tẽ, ne hỹrmã me cator, ne me cumã: — Ỹhỹ Petrô, ate amji kam gapac xàa to Krĩmpejre wỳr atẽm pyrentu — hane. ");
INSERT INTO ram_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mã apu Petrô jàhcuprõn, ne ma me pra. Ne curi me cator, mã cute me haprôr ne ma kỳj pê, ikre caxwỳn wỳr me to mõ. Mã me cahãj wej pijapit atajê cunea Petrô na me ipixêr, ne ame amrãhti. Ne me Caràhkwỳj te apu ihtĩr ne mõr reria mã, hitô kà ton atajê jahkre, ne mehkà kwỳ jahkre, ne ame amrã. ");
INSERT INTO ram_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mã Petrô te ikre caxwỳn pê mehcunea cator, ne ihkõn krã na hỹr, ne cute Pahpãm mã ihcakôc, ne Caràhkwỳj tyc wỳr ipipkjêr ne cumã: — Caràhkwỳj, to xa — hajỹr. Mã into catac, ne cute Petrô pupun ne hỹr. ");
INSERT INTO ram_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mã Petrô te Caràhkwỳj jũ na ipyr ne hãm na ihtehcajpar, mã hãm. Mã cute Jeju na mehkwỳ cunea me, me cahãj wej pijapit atajê mea mã ahna hàhwỳr, ne cute me hũhkra mã cahãj tĩar na haxàr. ");
INSERT INTO ram_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mã me harẽn pejti ita Krĩmpejre cunea kôt ipicràn, mã me hàhtôa ne ihtỳj me Jeju to amji mã mehhimpej. ");
INSERT INTO ram_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mã Petrô curia ampo kà cajror catê japrỳ te Ximãw ata jũrkwa kam hàhhuc, ne curia cute cahê na amji to amcro jàhtôa. ");
INSERT INTO ram_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ỹhỹ, pê Xexa jõ krĩ kam, Krĩrĩtpej jõ pjê kam, hũmre ihkrĩ ata japrỳ te Coner. Ne cupê krãhtare catêjê to ihhimpej catê. Pê Prytikra jõ pjê pê Roman catêjê jõ pjê rũm cato. Ne cupê mehcahkrit atajê nõ, ne nee cupê Juta catêjê nõ nare. ");
INSERT INTO ram_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ne pê ihtỳj ajco mehkra mea mã, Pahpãm to me amji kampa, ne me cumã Pahpãm kĩn. Ne ajco me Juta catêjê pê hamreare atajê tehcajpar to catia to ipa, ne ajco Pahpãm mã mehcakôc. ");
INSERT INTO ram_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ne amcro nõ na, pyt pejti kam, Coner te irĩat kam Pahpãm mã imprar catêjê nõ pupun, mã côjkwa pĩn cator ne hỹrmã hàhtêp ne cumã: — Coner — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mã cute Pahpãm mã imprar catê nõ ata cupa kam hõmpun, ne ihcukij to: — Ampo, Pahhi? — hajỹr. Mã cumã: — Ỹhỹ, Pahpãm mã ate amji kam gapac xà jahkre pej, ne ate me cupê hamreare atajê mã ampo pejti ton na, cute ato amji japackre. Cwỳrjapê ri apyrên Pahpãm jakry. ");
INSERT INTO ram_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ne hamre, ita caxuw me jũm xũmre kujate, Krĩmpejre wỳr, quê hũmre japrỳ te Ximãw Petrô ata japrô. ");
INSERT INTO ram_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Por ampo kà cajror catê japrỳ te hanea ne Ximãw ata jũrkwa kam ri hàhhuc, côxwa cahê na — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ne ma Pahpãm mã imprar catê tẽ. Mã Coner te me hàpên catêjê to ipijakrut, ne hanea ne krãhtare nõ pyxit ne me cumã hàkjêr. Ne krãhtare ita pê Coner tehcajpar catê, ne ihtỳj Pahpãm to amji kam hapac to ipa. ");
INSERT INTO ram_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ne Coner te me cumã hũjarẽn xà caxuw, cute ampo pupun atajê cunea jarẽn. Ne ma cute Krĩmpejre wỳr mencrê itajê kujahêc, mã ma me pra. ");
INSERT INTO ram_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mã Krĩmpejre kam, amcro nõ na, ramã Petrô krã cajpuw pyt jỹ, mã ikre jimoc na, cute Pahpãm mã ihcakôc prãmte hàpir, ne Pahpãm mã ihcakôc. Mã ramã Coner te Petrô wỳr mehkujahêc atajê Krĩmpejre na me hàhtêp. ");
INSERT INTO ram_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Mã ramã Petrô mã prãm, mã ihtỳj ampo krẽr prãm. Mã cormã ame hõ toan kam, mã Petrô te irĩat kam côjkwa kre pupun. Mã cupê cupẽhkàhti, ne catia to cati, ne hõxwahhi te cwat na hê, mã kỳj rũm, côjkwa pĩn ahpar mã ajpên mõ. ");
INSERT INTO ram_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ne cupẽhkà ita caxwãm pê cute ampo pryre cunea pupun. Mã kam ampo pryre cunea, ne kam ampo kên pjê kam cajõhjõt to ipa ita, ne kam ampo pryjara. ");
INSERT INTO ram_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mã Pahpãm Petrô mã: — Petrô, to xa ne ampo cura, ne krẽ — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mã cumã: — Pỳhàpà, ijõ Pahhiti! Jũ wỳr wa amji mã hamã ne ampo kên ita nõ krẽ. Wa rỳ jũ caxuw ite ampo kên krẽr nare ita kam — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mã Pahpãm hipêr cumã: — Wa jamã ne ampo pej na harẽ, ca nee hipêr ihkên na harẽn nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hamre, cute cumã ihcakôc to incrê. Jirô pê mã ri cute cupẽhkàhti ita to hacpỹa mã côjkwa wỳr amji jaxàr. ");
INSERT INTO ram_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mã Petrô cama apu irĩat kam, côjkwa kam cute ampo pupun xà atajê to amji japackre to mõ, ne amji mã: — Pỳhàpà, ampo to mã Pahpãm apu imã hahkre? — hane. Mã pyt jỹr xà ata kam, Coner te me hũmre kujahêc atajê harkwa mã me hàhhuc. Ne cute me Ximãw pê pryre kà cajror catê ata jũrkwa na me hàhcukjêr. ");
INSERT INTO ram_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mã cute me cumã harẽn, mã ma hũrkwa ri me cator, ne cute ikrea kam, me jũm ita mã hàkjêr, ne me jũm ata cukij to: — Xà ajkĩ ita ri mã hũmre japrỳ te Ximãw Petrô ata jàhhuc ne apu mõ? — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mã Petrô cormã apu cute ampo pupun xà ata to amji japackre to mõ. Mã Pahpãm Carõ Pejti cumã: — Awpa! Ita ri me hũmre incrê, ne ame ana hàhcukjêr to me ipa. ");
INSERT INTO ram_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Apu ahcuprõ ne wrỳ, ne mehkôt mõ. Nee ca apu gũpar nõ nare, ne nee ame hũpa nare. Ampo na? Itea wa awỳr mehkujahêc — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Mã Petrô wrỳc, ne me hũmre atajê mã: — Xà ina ca ame ahcukij? Ampo wỳr mã ca ita ri me mõ? — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mã me cumã: — Ỹhỹ, pahhi Coner te ri awỳr me ikujahêc. Ne Coner ita peaj, ne cupê Pahpãm to amji kam hapac catê impeaj, mã Juta catêjê cunea me kampa. Mã Pahpãm mã imprar catê côjkwa pĩn cator, ne apu cumã ana awjahkre, quê ana ahwỳ, ca hũrkwa ri acato, quê akampa, ate cumã ampo jarẽn xà atajê na — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mã Petrô te me hũmre atajê mã me hàr na hũjahkre, mã me hàr, ne caxwa ata kam cahê na me hàhhuc. Mã me ahna apẽ, mã ame hàhcuprõn, ne ma me mõ. Mã Jeju na mehkwỳ kwỳ, Krĩmpejre kam mehkrĩ atajê, hanea ne mehkôt me mõ. ");
INSERT INTO ram_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Me mõ ne me ahna apẽ nõ ma Xexa jõ krĩ kam me cator. Mã ramã Coner te mehkjêjê me, me hõ ikwỳ nõ peaj catêjê me, me hator, mã ramã cute me cuprõn ne me Petrô jikaj. ");
INSERT INTO ram_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mã ramã Petrô to me mõ, mã hàr, mã Coner mõ ne cute ihcajpar, ne cuna mã ihkõn krã na hỹr. ");
INSERT INTO ram_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mã Petrô te hacpỹa mã hãm ne cumã: — To xa, nee mã ipê Pahpãm nare. Ampo na? Hanea ne ipê me axũmre nõa wa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mã Petrô apu Coner mã ihcakôc jirô pê mã, ma ikre mã me hàr. Mã me hàhtôa te me cuprõn tu curi. ");
INSERT INTO ram_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mã mehcunea mã awjarẽ, ne me cumã: — Ramã me amã Juta catêjê te amji kam hapac xà jahkre pej. Ne jũ wỳr quê mehcahkrit itajê me, me cuprõ ne me ajcacwa. Ne Pahpãm te quêt imã mehcunea to hahkre to hajỹr he, wa nee amji kĩnte hipêr jũm kên me, ihtũm na, to amji kam ijapac nare. Ita to ri Pahpãm te curmã imã hahkre. ");
INSERT INTO ram_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na ca ate me ina gàhwỳr, wa ajpên ite amji kam ijapac xà impejti na prãm to wa mõ. Na wa itỳj amji jahkre pej to prãm, ampo na mã ca ate me ina gàhwỳr? — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mã Coner te Petrô mã ihcakôc, ne cumã: — Ramã ina amcro incrê, wa ita ri ijũrkwa kam jỹ, ne pyt pejti kam apu Pahpãm mã icakôc. Mã ihprõt pê hũmre ita te ihkà jakati ihpràti ita to ihkà, ne icuna mã cator, ne cute imã hũjarẽn to: ");
INSERT INTO ram_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","— “Coner, Pahpãm te acakôc xà impar, ne cute ato amji japackre, ca ate me cupê hamreare atajê mã cute ampo na ihprãm ata jõr na. ");
INSERT INTO ram_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ne me jũm kujate, Krĩmpejre wỳr, quê me jũm xũmre japrỳ te Ximãw Petrô ata japrô. Ne Ximãw nõ apê ampo kà cajror catê jũrkwa kam ri hàhhuc, côxwa cape na” hane. ");
INSERT INTO ram_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Na wa ite ana ijàhwỳr pyrentu. Mã ate to hamãrti mã, ne ajpên tẽ ne acator, ne ahnaa ri impeaj to impej. Ne hamre, ramã mehcunea te me cuprõn, Pahpãm cuna mã. Ne Pahpãm te amã harẽn ne amã to hahkre atajê par prãmte, wa ramã ite me cuprõn. Na ca ha ate impar xà ata jarẽ, wa me akampa — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mã Petrô me cumã: — Ỹhỹ, he ita caxuw Pahpãm mã mehcunea pipẽn pit na imã hahkre pej. Pahpãm te ramã cumã mehcunea kĩn pipẽn pit to imã hahkre, na ri imã hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ampeaj kam, quê ha pjê cunea kam jũmjê mã Pahpãm kĩn, ne me cumã kam hapac prãm, quê ha Pahpãm jũmjê atajê pupu, ne ihtỳj jũmjê atajê na amji capa. ");
INSERT INTO ram_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ne ramã cute me ikwỳ pê Juta catêjê me, me pahcunea mã Jeju kujahêc, me pahcarĩcti prãmte. ");
INSERT INTO ram_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ne ramã ate me Jeju jarẽn pejti ita par, ne me hahkre pej, por pê Jowãw ajco Jeju pê me pahcunea jõ Pahhiti na me cumã harẽn to ipa, ne cô kam ajco mehcumrã. Ne pê Jeju Naxare jõ krĩ pĩn cato, ne ajco mehcunea mã ihcakôc to ipa, Hĩpôjajo jõ pjê me, Juta jõ pjê kam. ");
INSERT INTO ram_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ỹhỹ, pê Pahpãm Jeju mã Carõ Pejti me carôt tỳjti gõ. Pê Carõ Pejti jarkwa kôt ajco hàpên xà impejti ton to apu ipa. Ne ajco Pahpãm jarkwa kôt mentête me curê xwỳn carõ kên to pôj to ipa. Atajê na ramã me amã hahkre pej. ");
INSERT INTO ram_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","— Mã me ikwỳ te Krĩpinkrên me ipu na krĩ kwỳ atajê cunea kam, cute ampo ton xà atajê cunea na me hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mã cute pĩ na me inxôr, mã kam ajêt, ne ihtyc. Mã cute me harêt, mã ahna amcro incrê, mã Pahpãm te hacpỹa mã to ihtĩr, ne ma me iwỳr ihkujahêc. ");
INSERT INTO ram_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wa me pa pit te me hõmpun, mã nee mehcunea te me hõmpun nare. Mã cute hacpỹa mã ihtĩr jirô pê me pa pit mã amji to ipipẽ, ne me icape na hàpàn ne ihkõm, wa ite me hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","43","Ne ampo na ri Jeju me iwỳr cator? Pahpãm te mam me icapi, ne me ito caprãr, ite mehcunea mã Jeju pê me pahkritxwỳ na harẽn to ipa xà caxuw. Ne hanea ne cute Jeju to me pahcukij ne me pahto ipicokjêr catê na hãm na, me cumã harẽn xà na amji na me icapi. Pê rỳ pêa mã Pahpãm jarkwa na mehhôc catêjê ajco Jeju jarẽn to ame ipa, ne me harẽn to: “Ỹhỹ, quê ha ihtỳj amcro nõ na jũm me awỳr cato. Ca me akên jicu, ne hỹrmã me apkjê, ne me kampa, mãr quê ate me to kên atajê to tojnõ ne hicu, ne me ana amji capa” hane. — Ita na pê Pahpãm jarkwa na mehcakôc catêjê rỳ pêa mã mam Jeju to mehcakôc. Ne Pahpãm te Jeju to me pahcukij catê. Ne taa mã quê ha amcro nõ na me pahpupu ne cormã me pahcunea tĩr itajê me, ramã me pahtyc itajê mea mã me pahcukij. Me pahtĩar kam, pahte me ampo kên ton, ne pahte me ampo pej ton ata na, me pahcunea cukij, cute me pajahkre pej prãmte. Ne ite me amã ita jarẽn xà caxuw ri Pahpãm te me ipyxwỳr — hane. ");
INSERT INTO ram_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","46","Mã Petrô cormã apu ihcakôc, ne apu ita jarẽ, mã Pahpãm Carõ Pejti me hipôc ri hàr. Ne cute, por me Petrô kam hapac atajê cunea mã amji jõr. Mã mehcunea te me to ihcakôc kam ihtẽm. Ne Pahpãm cati ne impej na me harẽ. Ne me harkwa pihho cunea to mehcakôc. Mã cute me Krĩmpejre pĩn, Juta catêjê kwỳ pê Jeju na mehkwỳ te Petrô pynãr atajê to amji mã me ipikrar. Ne me ajpẽn mã: — Pỳhàpà, xãmte Pahpãm te hanea ne mehcahkrit itajê mã Carõ Pejti jõr? — hane. Mã Petrô te mehcunea mã harẽn to: ");
INSERT INTO ram_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","— Hanea ne mehcahkrit itajê te ihtỳj me Pahpãm Carõ Pejti incwỳr to hajỹar xà, pom pê cu me cumam me cucwa he. Xà quê ha ajkĩ jũm cô kam me cumrãr tête mehcahpêrta? Hãpà! — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ne cute cô kam, Jeju jarkwa kôt, mehcumrãr na me cumã harkwa hyr. Mã harkwa kôt cute mehcumrãr. Jirô pê mã cute me, Petrô te hipêr me cahê na amji to amcro nõ kujahêc prãmte, me ahna hàhwỳr. Mã curia me cahê na hàhhuc. ");
INSERT INTO ram_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mã Juta jõ pjê kam Jeju jarkwa na memprar catêjê atajê te Coner me, mehkra pê mehcahkrit atajê te hajỹar ne Pahpãm jĩkjê rũm me hàhhuc ne mehkwỳ mã mehcunea xàr na cute me harẽn par. ");
INSERT INTO ram_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mã Krĩpinkrên kam Petrô cator. Mã Jeju na mehkwỳ te me Mojxe xwỳ kam me hapac prãm atajê te me Petrô cukij, ne me cumãn to: ");
INSERT INTO ram_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","— Pỳhàpà, ca mehcahkrit itajê kam gàhhuc ne me cape na gàpàn, ita na ihkaj na! Rỳ pêa mã pê Pahpãm Mojxe xwỳ to ihhimpej, ne me pamã awjarẽ, cu nee mehcahkrit atajê cape na ame papa nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mã Petrô te cumã kat kam ampo cunea ton atajê na, me cumã amji jarẽn to impejti partu, ne me cumã: ");
INSERT INTO ram_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","— Ỹhỹ, wa Krĩmpejre kam apu ipa, ne Pahpãm mã icakôc, ne irĩat kam ite ampo pupun. Ne ampo ita pê cupẽhkàhti pyràac, ne côjkwa pĩn iwỳr iwrỳc. Ne hõxwahhi te cwat itajê na hê, wa ite ihcunea kam apẽhti na hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne kam irĩt, ne ite kam ampo pryre cunea pupun. Hõmpry tàmre me, ampo kên pjê kam cajõhjõt to ipa ita me, pryrejara me, ite ihcunea pupun. Pom pê hanea ne Pahpãm mam ampo pryre kur tête me pamã atajê, wa ite hõmpun. ");
INSERT INTO ram_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ne ite côjkwa rũm jũm jõkre par, mã imã: “Petrô, to xa ne atỳj ampo cura ne krẽ” hane. ");
INSERT INTO ram_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","— Wa cumã: “Pahhiti, jũ wỳr wa amji mã hamã ne me iquêtjê te me imã ampo kên cawpa xà itajê nõ krẽ. Wa rỳ jũ caxuw ite ampo kên krẽr nare ita kam” hane. ");
INSERT INTO ram_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","— Mã hipêr côjkwa pĩn imã: “Wa jamã ne ampo pej na harẽ, ca nee hipêr ihkên na harẽn nare” hane. ");
INSERT INTO ram_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ne cute imã harẽn to incrê, mã cupẽhkà te hacpỹa mã amji jaxàr, côjkwa wỳr. ");
INSERT INTO ram_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","— Me ajkaam mã Xexa jõ krĩ pĩn, cute iwỳr me hũmre to incrê ne mehkujahêc atajê me cator. ");
INSERT INTO ram_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mã Pahpãm Carõ Pejti te, ite pa nare to imã ihcakôc, ne ikujahêc, wa ma mehkôt Xexa jõ krĩ wỳr mõ. Ne cute me xêj itajê pê Jeju na mehkwỳ Krĩmpejre kam, ne hanea ne ma me ikôt me mõ. Wa me icunea curi me icator, ne Coner jũrkwa mã me ixàr. ");
INSERT INTO ram_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","— Mã Coner te me imã côjkwa pĩn Pahpãm mã imprar catê te hũrkwa kam cumã amji pẽr, ne cumã hũjarẽn na me imã harẽn. Cute cumã hũjarẽn to: “Hàpà, Krĩmpejre wỳr jũm kujate, quê tẽ ne hũmre japrỳ te Ximãw Petrô atajaprô. ");
INSERT INTO ram_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Quê cato, ne me acunea te Pahpãm to kên jahpan xà na, me akên catia mã me axàr xà ata pê, cute me apytàr xà to me amã hahkre” hajỹr. Hõ, Coner te me imã hũjarẽn to hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","— Na wa ite me cumã Jeju jarẽn kam itẽm. Ne cormã ite icakôc kam itẽm, mã por pê mam Pahpãm Carõ Pejti me pahwỳr wrỳ, ata na ri me pahcuxà me hỹrmã iwrỳc. ");
INSERT INTO ram_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na wa ite, pom pê Pahhiti Jeju me pamã hũjarẽn to: “Ỹhỹ, pê Jowãw pê cô kam me acumrãr catê. Ne Pahpãm quê ha jũ caxuw me amã Carõ Pejti kujate, quê ha taa amji carôat kam me acumrã” hane ata to, ite amji japackre pyrentu. ");
INSERT INTO ram_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pom pê mam Pahpãm me pamã Carõ Pejti gõ, ata cuxà hanea ne cute mehcahkrit mã Carõ Pejti jõr. Ne Pahpãm te me cumã hõr ita kam, jũ wỳr wa Pahpãm cuna mã ikên to amji kampa — hane. ");
INSERT INTO ram_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hõ, Petrô te me cumã hũjarẽn to hajỹr, mã mehcunea te me kam hapac, ne me cumãn jicu, ne ramã ajtea mã me, ne ampeaj kam cute Pahpãm pej na me harẽn kam to ihtẽm. Ne cute me hũjarẽn to hajỹr he: — Tahnaa mã, Pahpãm te hanea ne mehcahkrit to impeaj to impej. Na quê ha mehkên ton jicu, ne Pahpãm mã me amji jarẽ, quê ha cute me to kên atajê cunea jicu ne to tojnõ. Na quê ha hanea ne Pahpãm cahê na ame ipa rohnỳtti mã — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ỹhỹ, Tewãw curan xà jirô pê mã cute me Jeju na mehkwỳ to kên kam mehtẽm. Mã Jeju na mehkwỳ ma amehcahkũm ne ame ipicràn. Ne ma Kuhkũmtyc jõ pjê wỳr me pra, mã itajê ma Xipre jõ pjê wỳr me pra, mã itajê ma Antijoc jõ krĩ wỳr me pra. Ne cute me cupê Juta catêjê mã pit mã me Pahpãm jarkwa jarẽn, ne nee mehcahkrit atajê mã harẽn nare. ");
INSERT INTO ram_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mã pom pê Xipre jõ pjê me, Xiren jõ krĩ pĩn me cato atajê kwỳ kwỳ, ma Antijoc jõ krĩ wỳr me pra ne me cator. Ne cute ajtea mã hanea ne mehcahkrit mã Pahpãm jarkwa jarẽn, ne me cumã Jeju pê me pahkritxwỳ jarẽn xà impejti jarẽn. ");
INSERT INTO ram_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ne mehkwỳ atajê pê Pahpãm Carõ Pejti me cumã amji gõ, mã carôat kôt ame ipa. Cwỳrjapê ri me hàhtôa ne cute mempar, ne hỹrmã me ipipkjêr. ");
INSERT INTO ram_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mã ma me harẽn picràn, ne ma Krĩpinkrên kam cator, Jeju na mehkwỳ te cuprõn xà kam, na ri ma cute me hỹrmã, Antijoc jõ krĩ wỳr Parnap kujahêc. ");
INSERT INTO ram_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mã Parnap curi cator, ne cute Pahpãm te me to impejti, ne cute Pahpãm te me ahna amji caxàr, mã ampeaj kam me hakry na me hõmpun. Ne cute ita kam me to incrà tu to mehcunea japackre, mãr quê me Pahpãm kampa, ne cute me amji kam me hapac xà cunea to me Pahpãm caca xà pynã. ");
INSERT INTO ram_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ỹhỹ, pê Parnap ita pê hũmre impejti, ne pê Pahpãm Carõ Pejti cumã amji gõ ne amji jõrtu, na pê hãn ne Jeju to amji mã ihhimpej to tỳj. Ne incwỳrjapêa ri me hàhtôa ne Pahpãm wỳr me ipipkjêr. ");
INSERT INTO ram_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jirô pê mã ri, ma Parnap Krĩjara wỳr mõ, ne kam apu Xawrô japê, ne cute ihcajpar, ne ma Antijoc jõ krĩ wỳr me tẽ. ");
INSERT INTO ram_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ne caku pyxit ata na cute me cuprõn, cuprõn xà kam, ne cute me hàhtôa mã Pahpãm jarkwa to hahkre. Ne Antijoc jõ krĩ ata kam, pê mam Jeju kôt me ipa catêjê japrỳ to ajco me “Jeju na mehkwỳ” hane. ");
INSERT INTO ram_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mã amcro ata na Pahpãm jarkwa to mehcakôc catêjê kwỳ Krĩpinkrên pĩn me mõ, ne Antijoc jõ krĩ wỳr me cator. ");
INSERT INTO ram_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ne pyxit ata pê haprỳ Agap, ne cator ne xa ne Pahpãm Carõ Pejti jarkwa kôt me cumã awjarẽ, ne me cumã: — Ỹhỹ, quê ha pjê cunea kam prãm — hane. Ne por Crawti pê Roman catêjê jõ pahhiti jõ caku ata kam pê ita hane. ");
INSERT INTO ram_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mã Jeju na mehkwỳ te Juta jõ pjê kam Jeju na mehkwỳ tehcajpar na me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ne ahpỹanre na, me pyxit ne cute me ihpore jõr par, ne mempeaj kam me cugõ. Ne cute me ihpore ata to Parnap me Xawrô kujahêc, cute me Jeju na mehkwỳ to mehhimpej catêjê mã hõr xà caxuw. ");
INSERT INTO ram_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ỹhỹ, pê amcro ata na pjê jõ pahhi ata haprỳ Heroti, ne cute Jeju na mehkwỳ na harkwa hyr, cute ame to kêanre prãmte. ");
INSERT INTO ram_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ne Heroti te Jowãw tõ pê Tijac na harkwa hyr, quê mehpro ne mehcura, wapo xwahhihti to. Mã cute mehcuran. ");
INSERT INTO ram_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mã Juta catêjê mã cute mehcuran ita na kĩn. Cwỳrjapê ri Heroti te hajỹar ne hipêr Petrô pro, ne me huwapre ne me haxàr na harkwa hyr, Juta catêjê pijacri xà jõ amji kĩn jõ amcro ata kam. ");
INSERT INTO ram_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ne cute krãhtare pê me hamãr catêjê te tejixêj jũhkra mã haxàr, ne me cumã: — Me hamãr peaj ne, quê nee jũ kam ihtẽm nare, nãmri amji kĩn jirô pê wa ha me cuna mã hãm, ne ihcukij, ne ihcura — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mã Petrô nõ, mã hamãr catêjê ihtỳj me hamã. Mã Jeju na mehkwỳ ihtỳj Petrô na Pahpãm na me ahwỳ, quê nee me Petrô curan nare. ");
INSERT INTO ram_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ne amcro ata na pahhi Heroti te Petrô cukij, ne mehcuran xà jõ caxwa ata kam pê me hamãr catêjê cote na nõ ne gõr. Pê wakỳre ajkrut ne ihcajpre, ne cormã harkwa mã hamãr catêjê ahna mehcuhhê. ");
INSERT INTO ram_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mã ihprõt pê caxwa ata kam, Pahpãm mã imprar catêjê nõ ata côjkwa pĩn me hacjên xà wỳr iwrỳc, ne cute cumã amji to ipipẽ. Mã hàhcujro kam apẽhti pyrentu. Mã cute Petrô jikre kam ihtàt, ne ihcujrõn ne cumã: — Hã, axãm pyrentu — hane. Mã wakỳre te ihcajpre itajê cunea apu ipijaxwỳr. Mã cormã ihtỳj hamãr catêjê ame hikwa ne ame gõr. ");
INSERT INTO ram_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mã Pahpãm mã imprar catê cumã: — Atu na hê xà to apre, ne gõ par kà mã amji jaxà ne ahna to huwapre — hane. Mã cute ahna to huwapre par mã cumã: — Gõ hitô kà mã amji jaxà ne ajpên ikôt mõ — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ne ma mam Pahpãm mã imprar catê cator, ne cumã mõ, mã hapu na Petrô ihkôt mõ. Ne nee cator xà ata na cute amji jahkre pej nare kam, ihtỳj ipimtir na apu amji cãmjĩ. ");
INSERT INTO ram_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ne ma ihkôt mõ, ne cute me hamãr catêjê cuhhê xà jakren, ne hirô pê ihnõ ita jakren, ne ma wakỳti te harkwa catia ata wỳr me mõ. Mã amjia kôt cute me cumã amji jihê mẽn, mã ma me cator. Ne ma krĩ cape kôt me mõ, mã ihprõt pê ma Pahpãm mã imprar catê tẽ. ");
INSERT INTO ram_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mã cormã Petrô te amji cajpẽr ne amji mã: — Pỳhàpà, xãmte ampeaj kam ri Pahpãm mã imprar catê te Heroti me, Juta catêjê jõ pahhi kwỳ jũhkra pê icaxàr! Nee mã ijõt kam nare, ne nee mã ipimtir kam nare — hane. ");
INSERT INTO ram_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ne cormã cute to amji japackre, ne ma Marij jũrkwa wỳr tẽ, por Jowãw Macô menxi ata jũrkwa wỳr. Ne hỹrmã cator, mã cormã cute me cuprõn ne mehkrĩ, ne ma hõtpê Pahpãm mã me Petrô cajrẽn. ");
INSERT INTO ram_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mã pea Petrô te me cumã harkwa cahhyr kam ihtẽm. Mã cuprỳre japrỳ te Rotihkwỳj te impar, ne ma hỹrmã tẽ ne cute ihcukij, ne cumã: — Me anõ mã ca? — hajỹr. Mã cumã: — Pa — hane. ");
INSERT INTO ram_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mã cute impar pyrentu ne hakry mã ma ipicahur, ne nee cute cumã hihê mẽn nare, ne ma tẽ ne ame cumã harẽ, ne me cumã: — Ma xà, põ pê Petrô harkwa mã xa — hane. ");
INSERT INTO ram_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mã me cumã: — Hamreare, ca apu ato kam waj — hane. Mã me cumã: — Quê, wa nee apu ito kam waj nare, ne nee wa apu ipimtir nare, ampeaj kam wa me amã harẽ. Ma xà, põ pê xa he! — hane. Mã me ajpẽn mã: — Hamre, Petrô carõ mõrmõ xa — hane. ");
INSERT INTO ram_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mã cormã Petrô apu harkwa cahhy, mã cute me cumã harkwa jihê mẽn, ne me hõmpun, ne me amji mã ipikrar. ");
INSERT INTO ram_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mã cute hũhkra to mehcuhhêc ne me cumã: — Me kêt, ne me ankrê, wa me amã amji jarẽ — hajỹr. Mã me kêt, mã ame cumã Pahpãm mã imprar catê kujahêc, mã cute me hacjên xà pĩn to cator na, ame cumã amji jarẽ. Ne amji jarẽn kôt me cumã: — Ca ha me anõ tẽ, ne Jeju na mehkwỳ to ihhimpej catê, pê Tijac ata me, me ikjêjê mã ijarẽ — hane. Ne ma jũ kam tẽ. ");
INSERT INTO ram_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mã apẽ, mã me hamãr catêjê te Petrô japê me amji caprãr, ne me cupê amji jahkre kêatre. ");
INSERT INTO ram_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mã Heroti te Petrô na hàhcukjêr to mehkujahêc. Mã nee cute me Petrô mã cator nare, mã Heroti te Petrô na me hamãr catêjê cukij, mã nee jũm te cumã harẽn nare. Na ri cute me tejixêj itajê cunea na harkwa hyr, quê me hipej, mã cute me hipej tu. Jirô pê mã ri, Heroti Juta jõ pjê pê cator, ne ma Xexa jõ krĩ kam hàhhuc, ne jũ mã curi cute amji to amcro ton. ");
INSERT INTO ram_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ỹhỹ, ampeaj kam ri, Heroti mã Kẽn jõ krĩ me Teppro jõ krĩ kam mehkrĩ catêjê kam incryc. Ampo na? He mehkwỳ japyre mã me cumã ihpore jõr prãm to me ipa, cwỳrjapê ri ame kam incryc. Na ri krĩ jõ pahhi catêjê atajê te amji to cuprõn, ne ma Praxô pê Heroti jarkwa kôt mehcunea to ihhimpej catê ata wỳr me mõ. Ne hỹrmã me cator, ne ame ajpẽn mã ihcakôc, cute hacpỹa mã ajpẽn to me hõ kwỳ nõ prãmte. Ne ampo na ri cute me ajpẽn to hajỹr? Nee mã ampo na nare. Pê Heroti pê pahhi ata jõ pjêa pĩn ajco me cumã me hõ to hapôj, cwỳrjapê pê me ajpẽn to hane. ");
INSERT INTO ram_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mã Heroti te me cumã ihcakôc xà na me cumã amcro hyr, mã ramã amcro hyr xà ata kam hàhhuc. Mã cute hõ pahhi kà impejti ata mã amji jacjên ne to amji cũmpej, ne pahhi krĩ xà catia ata kam hỹr, ne cute me cumã ampo kwỳ to ihcakôc to irya. ");
INSERT INTO ram_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mã cute mempar pejti atajê te ihcakôc ata jahpan xà na me cumã caràr ne me cumã: — Pỳhàpà, nee mã me hũmre nõ ihcakôc nare! Me pahpãm nõ mã ca ajte acakôc! — hane. Mã Heroti te ita par, ne cumã amji jarẽn xà ita na ihkĩn. ");
INSERT INTO ram_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mã cute cupê Pahpãm na me harẽn ata na, ihtỳj me to tojnõ, na ri ihtỳj cupê Pahpãm na me harẽ. Cwỳrjapê ri côjkwa pĩn Pahpãm mã imprar catê te to kên pyrentu. Mã cutõ te ihkrẽr mã ihtyc. ");
INSERT INTO ram_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pê ajco Pahpãm jarkwa ma ihkà to mõ, ne ipicràn to mõ. ");
INSERT INTO ram_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mã Parnap me, Xawrô te me hàpên xà krã curan, ne mehkjêjê mã ihpore jõr, ne ma Krĩpinkrên pĩn hacpỹa mã Antijoc jõ krĩ wỳr cute me amji jaxàr. Ne cute me Jowãw Macô japrôr ne ma me to mõ. ");
INSERT INTO ram_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ỹhỹ, Antijoc jõ krĩ kam Jeju na mehkwỳ kam, hõtpê Pahpãm jarkwa to mehcakôc catêjê me, me cumã ampo to hahkre catêjê te xĩc atajê japrỳ te hajỹr he: Parnap me, Ximãw japrỳ krut te Tycre me, Ruxô pê Xiren catêjê nõ ata me, Manem, por pê me hõ pahhi Heroti cape na amji to ajpa ata me, Xawrô. Atajê pê ri me cumã ampo to hahkre catêjê. ");
INSERT INTO ram_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mã amcro nõ na, Pahpãm pê Pahhiti to ame amji kampa, ne ame cumã ihcakôc xà caxuw ame ajcri, ne nee ame hàpàn nare. Mã Pahpãm Carõ Pejti te me cumã: — Me imã Parnap me Xawrô ta. Ampo na? Wa ramã ite me hàpên xà nõ caxuw amji mã me capi — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mã cormã me ipijacri xà ata kam, cute Pahpãm mã me Parnap me Xawrô na mehcakôc, jirô pê mã ri cute me ahna hũ xir, ne mehcajrẽn jirô pê, ma cute mehkujahêc. ");
INSERT INTO ram_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mã Pahpãm Carõ Pejti te Parnap me Xawrô kujahêc, mã ma Xeruxij jõ krĩ wỳr me tẽ, ne curia ri cute me pàr kre pro, ne ma me tẽ, Xipre jõ pjê pê cô jipôc ri pjê ata wỳr, ne me cator. ");
INSERT INTO ram_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ne krĩ japrỳ te Côjarô jõ krĩ mã me cator, ne cute Pahpãm jarkwa to mehcakôc kam mehtẽm, Juta catêjê te cuprõn xà kam. Pê hanea ne Jowãw Macô apu mehkôt mõ, cute mehtehcajpar, ne me Jeju pê me pahkritxwỳ jarẽn xà impejti incràn prãmte. ");
INSERT INTO ram_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ne ma cô jipôc ri pjê ata wỳr me irêr, ne hanea ne ma krĩ japrỳ te Papo ata mã me cator. Mã Papo jõ krĩ ata kam hũmre jũxy xi japrỳ te Parjeju ata ihkrĩ. Ne Crec jarkwa na caj ata japrỳ pê Erima. Ne cupê Juta catêjê nõa ne ihkêanre, ne ajco ihkrĩ ne mehcunea mã ihhêj. Pê ajco me cumã ihhêj to: — Ipê me amã Pahpãm jarkwa to icakôc catê — hane. ");
INSERT INTO ram_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ne cupê pjê ata jõ pahhi jõ ikwỳ nõ. Mã pjê jõ pahhi ata japrỳ te Xerjô, ne cupê hũmre krã kreti. Ne cute Parnap me Xawrô na hàhwỳr, cute Pahpãm jarkwa na hũpar prãmte. ");
INSERT INTO ram_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mã hũxy xi ata ma apu Jeju jarkwa na memprar catêjê caca. Ne ihtỳj cumã pahhi ata te Jeju jarẽn xà ata caca na to prãm. Mãr quê nee pjê jõ pahhi ata to amji me ihhimpej nare. ");
INSERT INTO ram_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pê Xawrô japrỳ nõ pê Pawrô, ne kam Pahpãm Carõ Pejti te hipu tu, mã cute Erima ata pupun tỳjti, ");
INSERT INTO ram_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ne cumã: — Apê me pahcurê xwỳn pê Xatanaj kra. Ne apê ampo pejti to kên catê, ne akêan to akên, ne ampeaj kam ahêj xi. Ampo na? Apê ampo pejti kẽhkẽn catê, na ca gõtpê Pahpãm caca xà impejti to kên to apa. ");
INSERT INTO ram_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na quê ha ita caxuw ato hy. Ca ha ato tũm pyrentu, ne ato tũm ita na jũ mã ana amcro, ca ha cormã hipêr pyt pupu — hane. Mã hũxy xi ita te amji cajpẽr pyrentu, mã ramã into kam awcapàtkô to mõ, mã cute amji jacjên kam ihtẽm, ne ame hapê hàpên to mõ, jũm te hũhkra na ipyr ne apu to mõr prãmte. ");
INSERT INTO ram_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mã pjê jõ pahhi te ita pupun, ne ihtỳj ampeaj kam caxwãm catia mã Pahpãm jarkwa par, ne amji mã to ihhimpej. Ne amji mã ipikrar, ne jỹ ne amji mã: — Ampeaj kam Jeju jũjarẽn xà pihho ne impejti pit, na wa ha itỳj ita caxuw Jeju to amji mã ihimpej — hane. ");
INSERT INTO ram_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mã Pawrô me, me mõr catêjê me, pàr kre mã me hàr, ne ma Papo pĩn, krĩ nõ japrỳ te Pjêjôti ita me, Panpir jõ pjê wỳr me tẽ, ne me cator. Mã Jowãw Macô te mehhyr ne ma hacpỹ mã amji jaxàr, Krĩpinkrên wỳr. ");
INSERT INTO ram_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mã ma ihtỳj mehtẽm kam cute me to incrà tu, Pjêjôti jõ krĩ pĩn, ne ma Antijoc jõ krĩ wỳr, Pixitij jõ pjê wỳr me cator. Ne jũ mã amcro mã, mehkôt xà pê xap jõ amcro na, ma Juta catêjê te cuprõn xà wỳr me mõ, ne me hàr, ne me hỹr. ");
INSERT INTO ram_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mã mam jũm ita te menquêtti Mojxe jõ kàhhôc cahyt, ne ihkôt cute me Pahpãm jarkwa na mehcakôc catêjê jõ kàhhôc cahyt. Jirô pê mã ri, cute me cuprõn xà jõ pahhi kwỳ te me hũjarẽn na me mẽn, ne me cumã: — Hã, me ikwỳ, xà hõtpê me amã ampo pejti jarẽn xà? Gapacta ne me imã harẽ, wa me awpa ne me ijakry — hajỹr. ");
INSERT INTO ram_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mã Pawrô xãm ne cute hũhkra to mehcuhhêc, ne ihcakôc kam to ihtẽm ne me cumã: — Ỹhỹ, me apê Ixaher catêjê pê Juta catêjê me, me apê mehcahkrit atajê me, pjê nõ rũm me acator atajê me, me amã Pahpãm kĩn catêjê atajê, me ikampa. ");
INSERT INTO ram_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ỹhỹ, pê Pahpãm amji mã me papê Ixaher catêjê capi. Ne hanea ne amji mã me panquêtjê me, me pampupxwỳjê capi, ne me to ipicamẽn to mõ. Pê Ejit jõ pjê kam mehkrĩ, pê me to ipicamẽn to mõ catia to cati. Jirô pê mã pê ihtỳj Pahpãm carôat kôt Ejit jõ pjê pĩn me to cuto. Ne ma me to mõ, pjê impejti japrỳ te Cana jõ pjê ata wỳr. Pê nee pry kôt me Pahpãm par nare, ne ame to kên. ");
INSERT INTO ram_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pê Pahpãm põti kam hamreare ata kam me cumã hũcanãr to caku to cwarẽnta. ");
INSERT INTO ram_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jirô pê mã pê Pahpãm Canãn jõ pjê kam krĩxàre te xet atajê to acto, ne me hipej tu. Hamre, pê me panquêtjê mã pjê ata jahkre. Ne cute me cumã hahkre jirô pê mã ri me ahna caku te cwatxẽnta ne ihkôt xĩncwẽnta mã cormã cute me cumã hõr. ");
INSERT INTO ram_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","— Pê Pahpãm ajco me cumã me to ihhimpej catêjê pyxwỳr to mõ, ne ahnaa Xamer pê mam Pahpãm jarkwa to ihcakôc catê ata jõ amcro kam to ahtwỳ. ");
INSERT INTO ram_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pê me hõ pahhi cati na me Pahpãm wỳ. Pê Pahpãm Xawrô xwỳ pê Quiti kra, pê Pẽnjamĩ tàmxwỳ tàmxwỳ nõ to me cumã me hõ pahhi cati na hãm, pê ihhimpej to caku to cwarẽnta. ");
INSERT INTO ram_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jirô pê mã pê Xawrô nee Pahpãm par kam to incrà nare, cwỳrjapê pê pahhi tête me camẽ, ne haxà kam Tawi xãm, me hõ pahhi cati na. Pê ampeaj kam Pahpãm mã Tawi kĩn. Na pê ramã harẽn to hane he: “Ỹhỹ, Tawi pê Jexê kra ata, ito pit mã amji kam hapac to ipa. Ne ite ampo na prãm atajê to pit mã hàpên to ipa” hane. ");
INSERT INTO ram_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","— Pê rỳ pêa mã ramã Pahpãm jũm te me pahkên pê me pahpytàr catê ata to awjahkre. Ne Jeju pê Tawi tàmxwỳ tàmxwỳ nõa ata to pê me pamã awjahkre. ");
INSERT INTO ram_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ne pê Jeju cator xwỳjrea na mam Jowãw cato. Ne ame hapackre to mõ. Ne Juta catêjê mã harẽ, ne me cumã: “Me akên itajê jicu. Ne me apej to pit mã me amji kampa, wa ha cô kam me acumrã” hane. ");
INSERT INTO ram_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne ramã cute hàpên xà jipêj xàa kam, pê me cumã harẽn to hane he: “Ỹhỹ, me ipupu, he nee ipê jũm to cute me hũjahkre ata nare. Quê ha cormã ikôt hapu na jũm ata cato. Ne cupê me pahkên pê me pahpytàr catê, ne impeaj to impej. Ne taa mã ri quêt ijirôa pê cati. Ne cumã amji jahkre pej catia to cati. Ne ijirôa pê cumã hahkre pej catia to cati, ne ihkĩnte icrire, ne ikêanre. Na ri hàpên xà impejti itajê kam ipahàm pit” hane. ");
INSERT INTO ram_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","— Ne me papê Aprãw tàmxwỳ tàmxwỳ me, me cupê mehcahkrit te ihtỳj catyt kam Pahpãm kôt me ipa atajê mã ri, hanea ne harkwa hyr xà ita. Ne Pahpãm te me pahwỳr harkwa kujahêc, mãr cu me kampa ne me pahcunea me pahkên pê me pahcato. ");
INSERT INTO ram_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ne Krĩpinkrên kam ame ipa atajê me, me cupê pahhi catêjê me, me cupê Jeju pê me pahkên pê me pahpytàr catê na hahkre kêatre. Ne hõtpê hãn ne me ikôt xà jõ amcro kam me cuprõ, ne mehkrĩ ne mehkàhhôc cahyt. Ne pê Pahpãm jarkwa na mehcakôc catêjê ramã Jeju na mehhôc. Cakrô, mã me cahyt catêjê atajê pê impar pej jahkre kêatre, ne me cupê Jeju pê Pahpãm kra na hahkre kêatre. Mã Jeju curan xà jõ amcro kam, mam ihkàhhôc te to hũjarẽn xà atajêa na cute me ton. ");
INSERT INTO ram_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pê nee Jeju ihkên xà nõ ton nare. Pê ahnaa me pro ne pahhi Pirat mã me cugõ. Ne pê hũ na ame amji to prãm, na pê ame kam incryc. Ne cute mehcuran prãmte me ahna me Pirat wỳ. ");
INSERT INTO ram_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ne cute me Jeju curan ita na, pê Pahpãm jarkwa na mehcakôc catêjê rỳ pêa mã ramã mehhôc. Mã ihcuran xà jirô pê cute mehtyc caxàr, pĩ pê, ne ma hĩ to me mõ. Ne cute kẽn kre caxwãm pê me hir. ");
INSERT INTO ram_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mã Pahpãm te hacpỹa mã hipêr Jeju to ihtĩr. ");
INSERT INTO ram_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mã Jeju kôt me ipa catêjê Hĩpôjajo jõ pjê rũm, ihkôt Krĩpinkrên wỳr me mõ atajê wỳr hapôj jàhtôa, amcro jàhtôa kam. Mã cute me hõmpun atajê ri ihtỳj ame harẽn to me ipa. ");
INSERT INTO ram_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","— Jirô pê mã wa ite me amã ijũjarẽn xà pejti ita jarẽn prãmte, ita caxuw ita ri ame ipa. ");
INSERT INTO ram_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Pê rỳ pêa mã Pahpãm ramã me panquêtjê mã, hacpỹa mã cute Jeju to ihtĩr to ihcakôc. Na ri cormã cute me pamã ita ton. Na pê Tawi xwỳ Pahpãm jarkwa kôt ihhôc, pê Pahpãm Jeju mã hane he, ne cumã: “Ỹhỹ, apê ikraa to ikra” hane. ");
INSERT INTO ram_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","— Pê Ixaj xwỳ hanea ne Pahpãm jarkwa na, Jeju jĩ cormã ihcacu nare kam, hacpỹa mã to ihtĩr xà na harẽ, ne harẽn to: “Wa ha itỳj acũmpej, ne amã ampo pej cunea gõ. Pom pê wa Tawi mã to awjahkre atajê, wa ha amã cugõ” hane. ");
INSERT INTO ram_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","— Na pê Tawi xwỳ hanea ne Jeju na Pahpãm mã harkwa to hane he: “Jũ wỳr ca ha amã hàpên catê impejti to tojnõ, quê ha ty ne hĩ ihcacu” hane. ");
INSERT INTO ram_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mã hõ amcro ata na Tawi te Pahpãm te ahna mẽn xà ata cunea ton. Ne pê ty, pê menquêtjê capea na me harêt, pê hĩ ihcacu. ");
INSERT INTO ram_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ne pê Jeju ajtea mã. Ampo na? Pê Pahpãm hipêr to ihtĩr, na pê hĩ nee ihcacu nare. Ne ihkĩnte Tawi jĩ pê ihtỳj ihcacu. ");
INSERT INTO ram_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ne ita caxuw ca ha me ipar peaj ne. He Jejua pê ri me pahkên pê me pahpytàr catê. Ne por pê me panquêtti Mojxe me pamã incaca xà kujate ata, hõtpê impej. Ne jũ wỳr quê Pahpãm te me pahkên ton jicu na to. Ne cu ha me pahnõ me pahkên mã hikra, ne Jeju wỳr apkjê, ne to amji mã me pahhimpej, quê ha ihtỳj quêt me pahte to kên ata to tojnõ ne hicu. ");
INSERT INTO ram_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ne me amji mã hamãa ne, ne me awpa, côt mã ihhêaj to jũ caxuw me akam ampo kên catia cato, nãmri pê ramã Pahpãm jarkwa na mehcakôc catêjê ita na mehhôc, pê mehhôc to hane he: ");
INSERT INTO ram_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Hã, me hàwxũn xi catêjê atajê me, por ca Pahpãm jarkwa to ame acakôc kêanre atajê, ca ha atỳj jũ caxuw me amji mã ajkra ne me ahi. Ampo na? He wa ha apu gõ amcro kam ampo pej catia ne to ata, quê ha jũm cati na me amã harẽ, ca ha nee mempar ne amji mã me to hajỹr nare. Na ca ha atỳj me ahi” — hane. Ne cute me cumã hũjarẽn jicu. ");
INSERT INTO ram_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ne ma Pawrô me Parnap me cator, cuprõn xà pê, mã cute me cumãn, quê hacpỹa ne me mõ, xap nõ na, ne hipêr me hũjarẽn xà atajêa to me awjarẽ. ");
INSERT INTO ram_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ne cute me cuprõn jirô pê, Juta catêjê jàhtôa me, hanea ne mehcahkrit catêjê te amji to me Juta catêjê, ne ma cute me Pawrô me Parnap pynãr. Mã Pawrô me Parnap me cumã ihcakôc, ne cute amji to mehtỳj na me cumã awjahkre, quê Pahpãm jarkwa kôt kam me to incrà. ");
INSERT INTO ram_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ne xap na, krĩ kôt mehcunea te me cuprõn, cute me Pahpãm jarkwa par prãmte. ");
INSERT INTO ram_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mã Juta catêjê atajê kwỳ te me hàhtôa pupun, ne Pawrô na mehkwỳ jũ na ame amji to prãm. Mã Pawrô jarkwa ata na cute mehcakôc kam mehtẽm, ne me hũn kam mehtẽm. ");
INSERT INTO ram_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mã Pawrô me Parnap te me cumã ihcakôc to tỳaj kam, me cumã hũjarẽn to: — Quêt me ca, pê mam Pahpãm me apê Juta catêjê mã harkwa ta. Ca ajte ma apu mehcaca, ne ahêj ne ma ame Pahpãm te me akên pê me ato hapôj na mehcaca. Ne ahêj ne ma ame Pahpãm te amji kam hapac xà intuw pejti ita caca. Na wa ha ita caxuw me gicu, ne mehcahkrit atajê mã, wa ha awjarẽ. Pê Pahpãm me imã harkwa hyr to: ");
INSERT INTO ram_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“Wa ate me mehcahkrit atajê mã, pjê cunea kam gàhcujro xà na, ite me apyxwỳr. Mãr quê mehcunea ipê mehkên pê me hũtàr catê na me ijahkre pej” — hane. ");
INSERT INTO ram_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mã mehcahkrit atajê te me ita par, ne ame hakry ne me amji mã Pahpãm jarkwa cupa, ne me amji mã: — Ampeaj kam Pahpãm jũjarẽn xà impej — hajỹr. Ne cute amji to me Jeju na mehkwỳ. Pê me Pahpãm cute amji mã me to ihhimpej xà caxuw amji mã me capi atajê cunea te me amji kam hapac xà intuw mã me hàr. ");
INSERT INTO ram_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mã Pahhiti pê Jeju jarkwa pjê ata cunea kam ihcahkũm. ");
INSERT INTO ram_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mã Juta catêjê cormã Pawrô kwỳ jũ na ame kam mencryc, cwỳrjapê ri cute me krĩ jõ pahhi catêjê me, pyjê cati mã Pahpãm kĩn atajê rẽc. Mã hanea ne Juta catêjê kôat pyjê atajê ma ame Pawrô me Parnap curê. Ne ma cute mehkujahêc, pjê nõ wỳr. ");
INSERT INTO ram_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mã Pawrô me Parnap te mehpar tête pro jacrô capĩr, cute me hõmpun prãmte. Ampo na? Nee cute mempar nare na ri, ne me cumã: — Hã, gapacta ne me hane, ne ca ihnõ na me, ca ha gõtpê amcro nõ na, jũ caxuw me akên mã axà ne me hõmpu, wa ha nee me atehcajpar nare. Ampo na? Ramã ite me amã harẽn — hane. Ne ma krĩ japrỳ te Ampokrekà jõ krĩ ata wỳr me mõ. ");
INSERT INTO ram_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mã ampeaj kam Jeju na mehkwỳ jakry, mã Pahpãm Carõ Pejti te me cumã me carôt to hipu tu. ");
INSERT INTO ram_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ne Ampokrekà jõ krĩ kam cute me hajỹar. Pawrô me, Parnap Juta catêjê te me cuprõn xà mã me hàr, ne cute me cumã Pahpãm jarkwa jarẽn. Mã me cupê Juta catêjê jàhtôa me, mehcahkrit atajê me, cute ihtỳj mempar, ne me hũpar xà ata kôt cute me hũnãr. ");
INSERT INTO ram_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mã me cupê Juta catêjê kwỳa te mempar nare atajê te Jeju jarkwa na memprar catêjê kam mencryc prãmte, cute mehcahkrit atajê rẽc. ");
INSERT INTO ram_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mã Jeju jarkwa na memprar catêjê amcro jàhtôa kam me hàhhuc, Ampokrekà jõ krĩ kam, ne cute me hũcanãar kam Jeju pê Pahhiti to me hũjarẽn. Mã Pahpãm te me cumã carôt jõr, cute me to hàpên xà pejti pihhoti ton xà caxuw. Mã mehcakôac to me ampo pejti ton to me ipa. Mã me hàhtôa ne cute me hàpên xà ata pupun, ne me hahkre pej pyrentu, me hũjarẽn to me awjarẽ ata kôt, nãmri ampeaj kam ri Jeju pê Pahhiti. ");
INSERT INTO ram_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ne krĩ kam mehkrĩ atajê te mencwỳrjapê amji to me ipicapôn. Ne mehkwỳ Jeju jarkwa na cumã memprar catêjê rũm me hàhhuc, ne mehcahhur Juta catêjê rũm me hàhhuc. ");
INSERT INTO ram_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mã mehcahkrit kwỳ me, me cupê Juta catêjê kwỳ me, me hõ pahhi kwỳ mea mã, cute me Jeju jarkwa na memprar catêjê to amehkên, ne cute kẽn to me hipej prãmte, cute ahna me ajpẽn par. ");
INSERT INTO ram_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mã Pawrô me Parnap te ramã me hahkre pej, cwỳrjapê ri ma me cator, ne ma Ritij jõ krĩ me, Terpe jõ krĩ wỳr me tẽ. Ne ma Ropcahàc jõ pjê kam, krĩ atajê wỳr me tẽ. ");
INSERT INTO ram_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ne krĩ ajpẽn na pire mã apu ihcuhhê atajê kôt cute me cumã Jeju pê me pahkritxwỳ jarẽn xà impejti jarẽn. ");
INSERT INTO ram_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ne Ritij jõ krĩ ata kam, pê hũmre par me ihpar kõn te xwỳ ita ihkrĩ. Pê xwỳ ita na ihpỳm, na pê jũ caxuw hãm ne apu mõr nare. ");
INSERT INTO ram_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ne hũmre ita te Pawrô cakôc xà na impar, mã cute hõmpun, ne ramã cute ihtỳj Jeju to amji mã ihhimpej na hahkre pej, ne ihtỳj hanea ne Pahpãm te caprãr na cute amji mã to hajỹr na hahkre pej pyrentu. ");
INSERT INTO ram_vpl VALUES ("AC14_1