﻿USE sofia;
DROP TABLE IF EXISTS sofia.rai_vpl;
CREATE TABLE rai_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rai_vpl WRITE;
INSERT INTO rai_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","U ra turpaaina God i waki a maup ma a rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ma i laklagon ma pa ta utnaa uni, ma a baboto i burung baat a ngaala na polo. Ma a Nion God i rowo taltalili nate u ra polo. ");
INSERT INTO rai_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ma God i piri naa, “A kaapa in waan paat.” Ma a kaapa i waan paat. ");
INSERT INTO rai_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God i baboi naa a kaapa i koina ma i weraana wa a kaapa ko ra baboto. ");
INSERT INTO rai_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ma God i waatung a kaapa baa “keke,” ma a baboto i waatungi baa “marum.” A bung na keke ma ra bung na marum ia raap. Io, a mugaana bung ia waan. ");
INSERT INTO rai_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ma God i piri naa, “Raa utnaa in waan paat kupi in weraana polo kupi in rudi.” ");
INSERT INTO rai_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Io, God i paam a utnaa maa kupi in weraana wa a polo baa i ki napia ko ra polo baa i ki nate. Ma i waan paat lenutmaa. ");
INSERT INTO rai_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God i waatung a utnaa maa “a maup.” A bung na keke ma ra bung na marum ia raap. Io, a weru bung ia waan. ");
INSERT INTO rai_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ma God i piri naa, “A polo natudaangi ra maup in waan ungaai un raa wanua ma a pia in waan paat.” Ma i waan paat lenutmaa. ");
INSERT INTO rai_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God i waatung a utnaa mi baa i mamaa paat naa “a pia.” Ma a polo baa i ki ungaai taau i waatungi baa “a pakaana taai.” Ma God i baboi naa i koina. ");
INSERT INTO rai_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ma God i piri naa, “A kum aalawur mangaana diwaai ma ra wali in tawa paat ko ra pia.” Ma i waan paat lenutmaa. ");
INSERT INTO rai_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A diwaai ma ra wali i tawa paat ko ra pia. Ma God i baboi naa i koina. ");
INSERT INTO rai_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","A bung na keke ma ra bung na marum ia raap. Io, a wetula bung ia waan. ");
INSERT INTO rai_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ma God i piri naa, “A kum kaapa diat a waan paat u ra maup kupi diat a weraana a keke ma ra marum ma diat a wakilang a kum bungbung, a kum kalkalaang ma a kum kilakilaala. ");
INSERT INTO rai_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ma diat a kup u ra maup kupi diat a wakaapa a rakrakaan buaal.” Ma i waan paat lenutmaa. ");
INSERT INTO rai_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God i paam paa a ru ngaala na kaapa, a ngaala aakit kupi in naagagon a keke, ma ia baa i kinalik taana in naagagon a marum. Ma i paam kaai a kum naangnaang. ");
INSERT INTO rai_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God i waki ta diat u ra maup kupi diat a wakaapa a rakrakaan buaal, ");
INSERT INTO rai_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kupi diat a naagagon a keke ma ra marum, ma kupi diat a weraana a kaapa ko ra baboto. Ma God i baboi naa i koina. ");
INSERT INTO rai_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","A bung na keke ma ra bung na marum ia raap. Io, a wewaat na bung ia waan. ");
INSERT INTO rai_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma God i piri naa, “A pakaana taai in teng ma ra kum lalaaun na utnaa ma a kum pika diat a rowrowo nate u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Io, God i waki a kum aalawur ngaalangaala na wewagua u ra pakaana taai. Ma i waki kaai a kum aalawur mangaana lalaaun na utnaa raap baa diat teng u ra pakaana taai. God i waki kaai a kum aalawur mangaana pika. Ma God i baboi naa i koina. ");
INSERT INTO rai_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God i pir wadaan diat ma i piri naa, “Muaat a babuta ma muaat a wabure muaat ma muaat a wateng a pakaana taai. Ma a kum pika kaai diat a wabure diat u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","A bung na keke ma ra bung na marum ia raap. Io, a welima na bung ia waan. ");
INSERT INTO rai_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma God i piri naa, “A kum aalawur mangaana wewagua diat a waan paat kupi diat a lalaaun nate u ra pia: A kum laa na wewagua, a kum wewagua baa diat kakakaa u ra pia, ma a kum lomlom na wewagua.” Ma i waan paat lenutmaa. ");
INSERT INTO rai_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God i waki a kum aalawur mangaana wewagua raap, a kum lomlom na wewagua, a kum laa na wewagua, ma a kum wewagua baa diat kakakaa u ra pia. Ma God i baboi naa i koina. ");
INSERT INTO rai_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ma God i piri naa, “Datul a paam a taara welaar ma datul, ma welaar ma ra malalarindatul. Diat a naagagon a kum ian ko ra pakaana taai, ma a kum pika ko ra maup, ma ra kum laa na wewagua. Diat a naagagon a rakrakaan buaal ma ra kum wewagua raap baa diat lalaaun uni.” ");
INSERT INTO rai_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Io, God i waki a taara welaar ma ra malalarina. I waki a muaana ma ra tabuan, welaar ma ra malalarina ut i waki diat. ");
INSERT INTO rai_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God i pir wadaan diaar ma i piri taan diaar, “Mur a babuta ma mur a wabure muaat ma muaat a wateng a rakrakaan buaal ma muaat a naagagoni. Muaat a naagagon a kum ian ko ra pakaana taai, a kum pika ko ra maup ma a kum lalaaun na wewagua raap baa diat lalaaun u ra pia.” ");
INSERT INTO rai_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ma God i piri naa, “Baboi, iaau tabaara mur ma ra kum waina diwaai raap u ra rakrakaan buaal. Diat maa mur a wangaan kon diat. ");
INSERT INTO rai_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma karom a kum wewagua, ma ra kum pika ko ra maup, ma ra kum wewagua baa diat kakakaa u ra pia, karom diat raap baa diat lo a dadaip na lalaaun iaau tabaara diat ma ra wali ma ra kum dondona gilaai baa andiat utnaa na winangaan.” Ma i waan paat lenutmaa. ");
INSERT INTO rai_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God i babo a kum utnaa raap baa ia paam taai. Ma i baboi naa i koina aakit. A bung na keke ma ra bung na marum ia raap. Io, a we-6 na bung ia waan. ");
INSERT INTO rai_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Io, God i waki raap taa a maup, ma ra rakrakaan buaal ma ra kum utnaa raap baa diat ki uni. ");
INSERT INTO rai_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Baa ia waraap wa a kum pinapaam baa i paami, io, u ra we-7 na bung i ngo. ");
INSERT INTO rai_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God i pir wadaan taa a we-7 na bung ma i waatung taai naa a gomgom na bung, kabina maa i ngo uni. I ngo ko ra nuna kum pinapaam na wawaki raap. ");
INSERT INTO rai_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Bi ia a aakaakur u ra wawaki i ra rakrakaan buaal ma ra maup. Baa a Tadaaru God i paam a rakrakaan buaal ma ra maup, ");
INSERT INTO rai_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","pa ta diwaai ma pa ta utnaa utbaai i tawa u ra pia, maa a Tadaaru God pa i taar utbaai ta baata urin napia, ma pa ta muaana baa in papaam u ra pia. ");
INSERT INTO rai_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Iaku a kum daanim liklik diat waan paat ko ra pia kupi diat a wamamawok a pia raap. ");
INSERT INTO rai_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ma namur a Tadaaru God i kaut paa a pia ma i paam paa a muaana koni. I ip aruk taa a dadaip na lalaaun u ra in ngirngirono, ma a muaana i lo dadaip ma i lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ma a Tadaaru God ia maarut raap taa a wanua na diwaai irong Iden, u ra mataana taubaar, ma matira i waki taa a muaana baa ia paam taai. ");
INSERT INTO rai_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","A Tadaaru God i watawa a kum aalawur mangaana diwaai u ra pia. A kum diwaai diat babo wakwakaak ma diat topaa a winangaan. Ruin diwaai kaai diaar tur naliwan u ra wanua maa, in diwaai na lalaaun, ma raain kaai baa i taar a manaana u ra koina ma ra aakaina. ");
INSERT INTO rai_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Raa daanim i kalaa naliwan u ra wanua Iden ma i laana wamamawok a pia. A daanim maa baa i kalaa pari kon Iden i waan weraan kup waat na gagaana. ");
INSERT INTO rai_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","A mugaana daanim a iaana maa Pison, ma i kalaa naliwan u ra papaar Aawilaa baa a goled kuraa iaai. ");
INSERT INTO rai_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A goled taanga Aawilaa i koina aakit. A bulit na diwaai baa i aangawian wakwakaak, ma ra kum ngaatngaat na waat di waatungi naa oniks kuraa kaai matira. ");
INSERT INTO rai_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","A weru daanim a iaana maa Gion baa i kalaa naliwan u ra papaar Kus. ");
INSERT INTO rai_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","A wetula daanim a iaana Tigris, baa i kalaa u ra mataana taubaar i ra papaar Aasiria. Ma a wewaat na daanim a iaana maa Eupraat. ");
INSERT INTO rai_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","A Tadaaru God i ben paa a muaana ma i waki taai u ra wanua Iden kupi in papaam uni ma in babourai kaai. ");
INSERT INTO rai_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","A Tadaaru God i taar a dekdek na pirpir karom a muaana lenbi, “U laangalaanga kupi un wangaan ko ra kum diwaai na winangaan raap min Iden. ");
INSERT INTO rai_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Iaku in diwaai baa i taar a manaana u ra koina ma ra aakaina, koku u wangaan koni. Baa un wangaan koni, lingtatuna aakit un maat.” ");
INSERT INTO rai_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ma a Tadaaru God i piri naa, “Wakir i koina kupi a muaana in lalaaun ia ot ku. Ang paam taa anuna ta tena wewaraaut baa in welaar mai.” ");
INSERT INTO rai_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Io, i kaut paa a pia ma i paam a kum aalawur mangaana wewagua raap baa diat lalaaun u ra pia, ma ra kum aalawur mangaana pika raap. Ma i lo pa diat karom a muaana kupi in baboi baa aawa ma a muaana in waatung diat mai. Ma a iang baa i waatung raaraa mai, maa ut ia a iaandiat. ");
INSERT INTO rai_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Io, a muaana i taar raap taa a iaa ra kum aalawur wewagua raap, a kum laa na wewagua, a kum lomlom na wewagua, ma ra kum pika ko ra maup. Iaku karom a muaana ut, pa te kon diat i welaar mai kupi in tena wewaraaut mulu anuna. ");
INSERT INTO rai_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Io, a Tadaaru God i taar a ngaala na ininep karom a muaana. Ma baa i inep duman, i lo paa raaina re ko ra muaana, ma i paam banoto taa balet a wanua baa i lo paai taanga iaai. ");
INSERT INTO rai_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","A Tadaaru God i paam paa a tabuan ko ra ina re baa i lo paai ko ra muaana, namur i ben taai karomi. ");
INSERT INTO rai_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ma a muaana i piri naa, “Ia maraagaam mi! Maa a urina ko ra uring, ma panina ko ra paning. Din waatungi baa a tabuan, kabina maa di paam paai ko ra ina ur i ra muaana.” ");
INSERT INTO rai_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mari ia a kabina baa a muaana in waan paa kon tamaana ma naana, ma in ki ungaai ma ra nuna tabuan, kupi diaar a raa maku. ");
INSERT INTO rai_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","A muaana ma ra tabuan diaar towaturia, iaku pa diaar wawirwir. ");
INSERT INTO rai_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Io, ina wui ia raa ngaala na tena manaana u ra warwaruga ko ra kum lomlom na wewagua raap baa a Tadaaru God ia waki pa diat. Ina wui i tiri a tabuan, “I dowot ut maa God i piri naa koku mur wangaan ko ra kum diwaai raap u ra wanua mi?” ");
INSERT INTO rai_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A tabuan i baalui naa, “Mir a wangaan ko ra kum diwaai raap, ");
INSERT INTO rai_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","iaku raain diwaai ku kuri naliwan baa God i piri naa koku mir wangaan koni, ma koku utkaai mir paami, kaduk mir a maat.” ");
INSERT INTO rai_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Iaku ina wui i piri taa ra tabuan, “Painte, pa mur a maat. ");
INSERT INTO rai_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God i piri lenmaa kabina i nunurai naa baa mur a wangaan koni, a mataamur in tapalaa, ma mur a welaar mulu ma God ma mur a nunura a koina ma ra aakaina.” ");
INSERT INTO rai_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A tabuan i babo in diwaai baa waina i babo wakwakaak ma i koina aakit kup a winangaan, ma i koina kaai kupi din lo a manaana koni. Io, i lo paa raa kum waina diwaai ma i aani ma i taar taa kaai raa mangaan taa ra nuna muaana baa kuraa ut i tur naana, ma ia kaai i aani. ");
INSERT INTO rai_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Io, a kiok na mataandiaar i tapalaa, ma diaar babo lele paai naa diaar towaturia. Io, diaar ingit ungaai paa a kum dondona fig, ma diaar gopi. ");
INSERT INTO rai_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","U ra bung na maluraap maa, baa i madiring a buaal, diaar waana walangoro paa a Tadaaru God baa i waan waanwaan nabalaara wanua, ma diaar paraau koni naliwan u ra kum diwaai. ");
INSERT INTO rai_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma a Tadaaru God i wewataai ma i piri taa ra muaana, “Kuraa ui awaai?” ");
INSERT INTO rai_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A muaana i baalui naa, “Iaau walangoro pa ui baa u waan urin, ma iaau burut ma iaau paraau kon ui, kabina maa iaau towaturia.” ");
INSERT INTO rai_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God i tiri naa, “Woi maa i piri taam naa u towaturia? Lelawaai, u aa wangaan paa ko rin diwaai baa iaau piri naa koku u wangaan koni?” ");
INSERT INTO rai_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A muaana i baalui naa, “A tabuan baa u waki taai karom iaau, i taar taa kum waina diwaai taang ma iaau aan paai.” ");
INSERT INTO rai_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","A Tadaaru God i tiri a tabuan, “Aawa mulu mi u aa paam taai?” A tabuan i baalui naa, “Ina wui i waruga ta iaau uni, ma iaau aani.” ");
INSERT INTO rai_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ma a Tadaaru God i piri karom ina wui naa, “Ang taar a naagagon na binabaalu taam, kabina u ra utnaa mi u aa paam taai. Ui ot ku ko ra kum wewagua raap, a kum laa na wewagua ma ra kum lomlom na wewagua, un lo a naagagon na binabaalu mi. Turpaai umari un laana kakaa ma ra in balaam, ma un laana aan a kabu u ra kum bungbung raap u ra num kinkini na lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Anung naagagon karom ui baa mur ma ra tabuan mur a nget wetalaai mur, a kum taptabu ra tabuan ma a kum taptabum kaai diat a ki na ebaar. A tabu ra tabuan in paa ginagina in lorim ma ui un karaat a kakina.” ");
INSERT INTO rai_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ma God i piri taa ra tabuan, “Anung naagagon na binabaalu karom ui, baa un kipbaala un kariaana a kum mawaat, ma u ra bung baa un babuta un kariaana a ngaala na ngunungut. Iaku anum ngaala na nemnem kup anum muaana in ki ut, ma ia ut in naagagon ui.” ");
INSERT INTO rai_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ma God i piri taa ra muaana, “U walangoro paa anum tabuan ma u wangaan ko ra in diwaai baa iaau piri naa koku u wangaan koni. Io, anung naagagon na binabaalu in ki u ra pia, kabina u ra utnaa baa u aa paam taai. Un laana papaam dekdek kup a maam winangaan, ma un kariaana a ngunungut uni a kum bungbung raap u ra num kinkini na lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kum barudu ma ra kum katkadaa diat a tawa paat u ra maam wanua, ma un papaam dekdek kupi un wangaan ko ra wai ra kum diwaai baa u aa maarut paai. ");
INSERT INTO rai_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Un laana papaam dekdek ma un wangaan ko ra maakmaagonim, tuk un maat, io, un waan talili balet kup a pia, baa di aa paam pa ui koni. Di paam ui ko ra pia, io, un waan talili balet kup a pia.” ");
INSERT INTO rai_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aadaam i taar a iaa ra nuna tabuan baa Iwa, kabina maa ia naa ra kum taara raap baa diat a lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","A Tadaaru God i paam maalu ko ra pani ra wewagua ma i wagop taa Aadaam diaar waana mai. ");
INSERT INTO rai_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","A Tadaaru God i piri lenbi, “Baboi, a muaana ia waan paat welaar ma datul ma ia manaana u ra koina ma ra aakaina. Koku di maadek taai kupi in lo ta wai ra in diwaai na lalaaun, kaduk in wangaan koni ma in lalaaun takum.” ");
INSERT INTO rai_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Io, a Tadaaru God i lu wa Aadaam ma Iwa ko ra wanua Iden. Ma Aadaam i papaam u ra pia baa God i paam paai koni. ");
INSERT INTO rai_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Baa God i lu wa diaar, i ung taa a kum aangelo ma ra in liwan baa i kupkup u ra papaara taubaar u ra wanua Iden. Ma in liwan maa i papakaat taltalili kupi in tur baat a taara baa koku diat waan marawaai naa ra in diwaai na lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Io, Aadaam i ki ungaai ma nuna tabuan Iwa, ma Iwa i kipbaala ma i buta paa a naat muaana ma i waatungi naa Kaain. Iwa i piri lenbi, “A Tadaaru i waraaut iaau ma iaau buta paa a naat muaana.” ");
INSERT INTO rai_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Namur Iwa i buta paa balet raa naat muaana, Aabel, a tein Kaain. Baa diaar ngaala, Aabel a tena baboura sip ma Kaain a tena minamaarut. ");
INSERT INTO rai_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Raa bung, Kaain i lo paa a kum utnaa ko ra ana pinapaam, ma i wetabaar mai karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ma Aabel kaai i aak doko a kum mugaana sip baa nuna kum sip diat buta diat, ma i lo paa a kum kokoina pakpakaana ma i wetabaar mai karom a Tadaaru. A Tadaaru i gaaia aakit un Aabel ma ra nuna wetabaar. ");
INSERT INTO rai_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Iaku pa i gaaia un Kaain ma ra nuna wetabaar. Io, Kaain i kaankaan dekdek ma a mataana i aaka taau maku. ");
INSERT INTO rai_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","A Tadaaru i piri taan Kaain naa, “I lawaai maa u kaankaan? Ma i lawaai maa a mataam i aaka taau maku? ");
INSERT INTO rai_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Lelawaai, pa u nunurai naa baa un paam a takado, io, ang gaaia un ui? Baa pa un paam a takado, a aakaina mangamangaan i waninaar kupi in naagagon ui, welaar ma ra ebaar baa i waninaar kupi in uwia pa ui. Iaku un ongor kupi un uwia paai.” ");
INSERT INTO rai_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Namur Kaain i piri taan Aabel naa, “Le, daar a waan unabuaal.” Baa diaar ki nabuaal, Kaain i tapuku ma i aak doko wa Aabel. ");
INSERT INTO rai_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Namur a Tadaaru i tiri Kaain lenbi, “Temlik Aabel kuraa waai?” Ma Kaain i baalui naa, “Pa iaau nunurai. Lelawaai, iaau ku maa a tena binaboura anun tenglik?” ");
INSERT INTO rai_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","A Tadaaru i piri taan Kaain, “Aawa maa u paam taai? Baboi, a gaapin temlik baa i talabo taau napia, i welaar ma ra in ingaana baa i kulkulaai karom iaau kup a binabaalu. ");
INSERT INTO rai_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kabina baa u aa aak doko wa temlik ma a gaapina i talanger u ra pia, io, mi a naagagon na binabaalu in ki un ui ma pa un papaam balet u ra pia. ");
INSERT INTO rai_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Baa un maarut utnaa u ra pia, pain ta utnaa in tawa paat. Mi pa un ki wowon taau un ta wanua, un waan taltalili ku u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaain i piri taa ra Tadaaru lenbi, “A naagagon mi i dekdek aakit karom iaau, ma pang pet laar paai. ");
INSERT INTO rai_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Baboi, mi u aa lu wa iaau ko ra pia kupi koku iaau papaam balet uni, ma pang tur balet u ra mugaana mataam. Ang waan taltalili ku u ra rakrakaan buaal, ma pang ki wowon taau un ta wanua. Baa te in baraata pa iaau, in aak doko wa iaau.” ");
INSERT INTO rai_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A Tadaaru i piri taana, “Pate, baa te in aak doko wa ui, a naagagon baa din taari karomi, din wangaalai 7 na pakaan nate u ra naagagon baa i ki un ui.” Io, i ung taa a wakilang un Kaain kupi a weturbaat karom te baa in waan taau uni, koku i aak dokoi. ");
INSERT INTO rai_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Io, Kaain i waan ingen ko ra mataa ra Tadaaru ma i lalaaun u ra papaar Nod, u ra mataana taubaar ko ra wanua Iden. ");
INSERT INTO rai_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaain i ki ungaai ma ra nuna tabuan, ma anuna tabuan i kipbaala, ma i buta paa a naat muaana, ma i waatungi naa Enok. Kaain i paam raa taamaan ma i ung taa iaan natunalik Enok uni. ");
INSERT INTO rai_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok a tamaan Irad, Irad a tamaan Mekuiaael, Mekuiaael a tamaan Metusaael, ma Metusaael a tamaan Laamek. ");
INSERT INTO rai_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laamek i taulaa ma ru tabuan, raa a iaana maa Aadaa ma raa paan diaar kaai Silaa. ");
INSERT INTO rai_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aadaa i buta paa Iaabaal, a tamaa ra taara baa diat bababoura a kum wewagua ma diat ki u ra kum ruma na sel. ");
INSERT INTO rai_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Iaabaal diaar tenalik ma Iubaal. Iubaal a tamaandiat baa diat ogogo a kum gitaa ma diat ipip a kum tulaal. ");
INSERT INTO rai_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silaa kaai i buta paa raa naat muaana, a iaana maa Tubaal-Kaain, ia baa i paam apaat paa a kum utnaa na pinapaam ko ra braas ma ra aaen. Tubaal-Kaain diaar tenalik ma raa tabuan, a iaana Naamaa. ");
INSERT INTO rai_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laamek i piri taa ra nuna ru tabuan naa, “Aadaa ma Silaa mur a walangoro iaau. Anung ru taulaa mur a walangoro anung pirpir. Iaau aa aak doko wa raa muaana baa i paar ta iaau ku, maia, iaau aak doko wa raa baarmaan baa i um iaau. ");
INSERT INTO rai_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Baa te in aak doko wa Kaain, a naagagon baa din taari karomi, din wangaalai 7 na pakaan nate u ra naagagon baa i ki un Kaain. Iaku baa te in aak doko wa iaau, a naagagon baa din taari taana in aaka aakit, din wangaalai 77 na pakaan.” ");
INSERT INTO rai_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aadaam i ki ungaai ma Iwa, ma Iwa i kipbaala, ma i buta paa balet raa naat muaana, ma i taar taa iaana baa Set. Iwa i piri naa, “God i tabaara iaau balet ma raa naat muaana, baa i kiaana Aabel baa Kaain ia aak doko wai.” ");
INSERT INTO rai_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Namur Set i wangaala paa raa naat muaana, ma i taar taa iaana baa Enos. U ra pakaana bung maa a taara diat turpaai kupi diat a waatung a iaa ra Tadaaru, baa diat lotu karomi. ");
INSERT INTO rai_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Bi ia a aakaakur i ra wuna taara anun Aadaam. Baa God i waki a taara, i paam diat welaar ma ra malalarina ut. ");
INSERT INTO rai_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I waki ta diat in muaana ma in tabuan, ma i pir wadaan ta diat, ma i waatung diat baa a taara. ");
INSERT INTO rai_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Baa a kilaala na lalaaun anun Aadaam i 130, di buta paa natuna, a naat muaana. I welaar ut ma Aadaam ma i lo a malalarina, ma Aadaam i taar taa iaana baa Set. ");
INSERT INTO rai_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Baa di aa buta paa Set, Aadaam i lalaaun paa balet 800 na kilaala, ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Io, a kum kilaala na lalaaun raap anun Aadaam i welaar ma 930, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Baa a kilaala na lalaaun anun Set i 105, di buta paa natuna, a naat muaana, a iaana Enos. ");
INSERT INTO rai_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Baa di aa buta paa Enos, Set i lalaaun paa balet 807 na kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Io, a kum kilaala na lalaaun raap anun Set i welaar ma 912, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Baa a kilaala na lalaaun anun Enos i 90, di buta paa natuna, a naat muaana, a iaana Kaainaan. ");
INSERT INTO rai_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Baa di aa buta paa Kaainaan, Enos i lalaaun paa balet 815 na kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Io, a kum kilaala na lalaaun raap anun Enos i welaar ma 905, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Baa a kilaala na lalaaun anun Kaainaan i 70, di buta paa natuna, a naat muaana, a iaana Maalelel. ");
INSERT INTO rai_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Baa di aa buta paa Maalelel, Kaainaan i lalaaun paa balet 840 kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Io, a kum kilaala na lalaaun raap anun Kaainaan i welaar ma 910, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Baa a kilaala na lalaaun anun Maalelel i 65, di buta paa natuna, a naat muaana, a iaana Iaared. ");
INSERT INTO rai_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Baa di aa buta paa Iaared, Maalelel i lalaaun paa balet 830 kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Io, a kum kilaala na lalaaun raap anun Maalelel i welaar ma 895, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Baa a kilaala na lalaaun anun Iaared i 162, di buta paa natuna, a naat muaana, a iaana Enok. ");
INSERT INTO rai_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Baa di aa buta paa Enok, Iaared i lalaaun paa balet 800 na kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Io, a kum kilaala na lalaaun raap anun Iaared i welaar ma 962 kilaala, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Baa a kilaala na lalaaun anun Enok i 65, di buta paa natuna, a naat muaana, a iaana Maatuselaa. ");
INSERT INTO rai_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Baa di aa buta paa Maatuselaa, Enok diaar weur ma God 300 na kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Io, a kum kilaala na lalaaun raap anun Enok i welaar ma 365. ");
INSERT INTO rai_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok diaar weur ungaai ma God. Namur i panaai maut, kabina maa God ia lo paai. ");
INSERT INTO rai_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Baa a kilaala na lalaaun anun Maatuselaa i 187, di buta paa natuna, a naat muaana, a iaana Laamek. ");
INSERT INTO rai_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Baa di aa buta paa Laamek, Maatuselaa i lalaaun paa balet 782 kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Io, a kum kilaala na lalaaun raap anun Maatuselaa i welaar ma 969, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Baa a kilaala na lalaaun anun Laamek i 182, di buta paa natuna, a naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Laamek i taar taa a iaan natuna lik baa Noaa, ma i piri naa, “Noaa in taar taa a kinalik na ningo karom daat ko ra nundaat kum dekdek na pinapaam u ra pia, a pia baa a Tadaaru i taar a dekdek na naagagon uni.” ");
INSERT INTO rai_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Baa di aa buta paa Noaa, Laamek i lalaaun paa balet 595 na kilaala, ma i wangaala balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Io, a kum kilaala na lalaaun raap anun Laamek i welaar ma 777, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Baa a kilaala na lalaaun anun Noaa i 500, namur di buta paa tula natnatuna, tula naat muaana, Sem, Aam ma Iaapet. ");
INSERT INTO rai_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","A niluluk i ra taara i ngaala waanwaan u ra rakrakaan buaal, ma di buta a kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Io, a kum natnatun God, a kum muaana, diat babo a kum tabuan maa baa a kum garaana tabuan. Ma diat taulaa ma diat, raaraa i pilak paa raa baa i nemi. ");
INSERT INTO rai_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ma a Tadaaru i piri lenbi, “A dadaip na lalaaun baa iaau ip aruk taai u ra taara, pa in ki takum un diat, maa diat a maat ku. Diat a lalaaun paa ku 120 kilaala.” ");
INSERT INTO rai_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","A kum ngaalangaala na muaana pipi baa di waatung diat naa a kum Nepilim diat ki u ra rakrakaan buaal u ra kum bungbung maa, ma u ra kum bungbung kaai namur. A kum muaana mi, a kum tabuan diat buta ta diat u ra kum natnatun God. A kum muaana maa, a iaandiat i rarang u ra rakrakaan buaal, diat a kum loklok na taara taanga namuga. ");
INSERT INTO rai_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","A Tadaaru i babo a aakaina mangamangaan anu ra taara u ra rakrakaan buaal i aaka aakit, ma a nuknukindiat raap kaai i nuknuk ku aakaina a pakpakaana bung raap. ");
INSERT INTO rai_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","A Tadaaru i tapunuk ma i kariaana a ngaala na mawaat, ma i nuki naa, “Gun in koina baa pang waki taa a taara u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Io, a Tadaaru i piri naa, “A taara baa iaau aa waki ta diat, ang kamaar wa diat ko ra rakrakaan buaal. Ang kamaar raap wa a taara, a kum wewagua, a kum wewagua baa diat kakakaa u ra pia, ma ra kum pika ko ra maup, kabina maa iaau tapunuk baa iaau aa waki ta diat.” ");
INSERT INTO rai_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Iaku Noaa, a Tadaaru i gaaia uni. ");
INSERT INTO rai_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Bi ia a aakaakur in Noaa. Noaa ia raa muaana baa a tena takado, ma diaar weur ma God. Pa te i takuna laar paai un ta aakaina mangamangaan naliwan taa ra taaun taara baa diat lalaaun ungaai. ");
INSERT INTO rai_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Tula natun Noaa, tula naat muaana, a iaanditul maa Sem, Aam ma Iaapet. ");
INSERT INTO rai_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","A taara ko ra rakrakaan buaal diat paam a mangamangaan baa i aaka namataan God, ma a rakrakaan buaal i teng ma ra wineium. ");
INSERT INTO rai_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God i baboi naa aakaina mangamangaan u ra rakrakaan buaal ia ngaala, kabina maa a taara raap diat murmur maku aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Io, God i piri karom Noaa naa, “Ang kamaar wa ma a taara raap, maa kabina diat wateng a rakrakaan buaal ma ra kum wineium. Maia, ang kamaar wa diat ungaai ma ra rakrakaan buaal raap. ");
INSERT INTO rai_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Un paam ta paraau ko ra in diwaai di waatungi ma saipres. Un babaat kutkutui, ma un bulit baati ma ra koltaa naruma ma nataamaan. ");
INSERT INTO rai_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Un paam a ngaalai lenbi: 75 babaluka a iokaanaina, 12 babaluka a parereina, ma 7 na babaluka a turturina. ");
INSERT INTO rai_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Un paam ina ulungan ira paraau ma un maadek wa ta kolo welaar ma 18 na ins, nate u ra papaara paraau. Un paam taa ta tula aandek ira paraau, raa napia, raa naliwan ma raa nate ma un paam taa kaai ta bonanaaka u ra papaara paraau. ");
INSERT INTO rai_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Ma iaau ang taar wa a ina ngaala na lomon u ra rakrakaan buaal, kupi ang kamaar raap wa a kum utnaa baa diat lo a dadaip, baa diat ki u ra rakrakaan buaal. A utnaa raap u ra rakrakaan buaal in maat. ");
INSERT INTO rai_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Iaku ang paam ta kunubu ungaai ma ui. Ui, anum taulaa, a tula natnatum ungaai ma anunditul tula taulaa, muaat a ruk raap u ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ma un ben aruk rurudi ko ra kum aalawur mangaana wewagua raap unaanga u ra paraau, a tabuanina ma ra muaanaina, kupi diat a lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Rurudi ko ra kum mangaana pika raap, ma ko ra kum mangaana wewagua raap, ma ko ra kum mangaana wewagua raap baa diat kakakaa u ra pia, diat a waan karom ui, kupi koku diat maat. ");
INSERT INTO rai_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma un lo paa kaai aalawur mangaana utnaa na winangaan raap, ma un ung ungaai u ra paraau, kupi a maamuaat ma ara kum wewagua raap.” ");
INSERT INTO rai_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma Noaa i paam raap paa a kum utnaa welaar ut ma God ia pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","A Tadaaru i piri taan Noaa, “Iaau baboi baa ui ku raa takado na muaana ko ra taaun taara mi. Io, muaat a tamtamaana raap muaat a ruk unaruma u ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Un ben paa ta kum wewagua ko ra kum mangaana wewagua raap baa diat gomgom namataang, 7 na muaanaina ma 7 na tabuanina. Un ben kaai ruru wewagua ko ra kum mangaana wewagua raap baa pa diat gomgom namataang, raa muaanaina ma raa tabuanina. ");
INSERT INTO rai_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ma ta kum pika ko ra kum mangaana pika raap, 7 na muaanaina ma 7 na tabuanina. Un paami lenmaa kupi a kum mangaana wewagua raap diat a lalaaun ma diat a wangaala diat balet u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","7 na bung kuraa utbaai, io, namur ang taar apari ina baata u ra rakrakaan buaal. In baata 40 bung na mage ma 40 bung na marum, ma ang kamaar raap wa a kum lalaaun na utnaa ko ra rakrakaan buaal, a kum utnaa baa iaau aa paam ta diat.” ");
INSERT INTO rai_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noaa i paam raap paa a kum utnaa baa a Tadaaru ia pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Baa a kilaala na lalaaun anun Noaa i 600, ina lomon i waan paat u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noaa, ma ra nuna taulaa, ma tula natnatuna ma tula taulaa anunditul, diat ruk u ra paraau kupi koku diat wirua u ra lomon. ");
INSERT INTO rai_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","A kum wewagua baa diat gomgom namataan God, a kum wewagua baa pa diat gomgom namataan God, a kum pika ma a kum wewagua raap baa diat kakakaa u ra pia, ");
INSERT INTO rai_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","diat waan karom Noaa ma diat ruk rurudi u ra paraau, a muaanaina ma a tabuanina. Ma i lenutmaa God ia pir taai karom Noaa. ");
INSERT INTO rai_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Io, namur baa 7 na bung ia raap, ina lomon i waan paat. ");
INSERT INTO rai_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Baa a kilaala na lalaaun anun Noaa i 600, u ra 17 na bung u ra weru kalaang, ina lomon i turpaai. U ra bung ut maa a pia i tapaapa ma a polo i waan paat ko ra kum mataana daanim taangine aakit napia, ma a kum mataana kalaangaar inaanga u ra baakut i tapaapa, ma a ngaala na baata i waan pari. ");
INSERT INTO rai_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ina baata i puka u ra rakrakaan buaal welaar ma 40 bung na mage ma 40 bung na marum. ");
INSERT INTO rai_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Noaa ma anuna taulaa, tula natnatuna, Sem, Aam ma Iaapet ma anunditul tula taulaa diat ruk u ra paraau. U ra bung ut maa, a baata i turpaai. ");
INSERT INTO rai_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","A kum aalawur mangaana wewagua raap diat ki u ra balaara paraau ungaai ma Noaa diat, a kum lomlom na wewagua, a kum laa na wewagua, a kum wewagua baa diat kakakaa u ra pia, ma ra kum aalawur mangaana pika. ");
INSERT INTO rai_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","A kum aalawur mangaana wewagua raap baa diat lo dadaip diat ruk rurudi karom Noaa u ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Raa muaanaina ma raa tabuanina ko ra kum aalawur mangaana wewagua raap diat ruk, ma i lenutmaa God ia pir taai karom Noaa. Namur a Tadaaru i balbalaat. ");
INSERT INTO rai_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","A lomon i lubu tato waanwaan welaar ma 40 bungbung, ma baa a palaa i waan tato waanwaan, i lo tato wa a paraau ko ra pia. ");
INSERT INTO rai_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Baa a palaa i waan tato waanwaan utbaai, a paraau i aalir maku nate u ra ina lubu. ");
INSERT INTO rai_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","A palaa i waan tato dekdek ma i pulu baat raap paa a kum ngaalangaala na taangaai u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","A palaa i waan tato utbaai, tuk i welaar ma waat na babaluka nate ko ra kum taangaai. ");
INSERT INTO rai_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","A kum aalawur mangaana lalaaun na utnaa u ra rakrakaan buaal diat maat, a kum pika, a kum laa na wewagua, a kum lomlom na wewagua, a kum wewagua baa diat kakakaa u ra pia, ma ra taara raap kaai, diat maat. ");
INSERT INTO rai_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","A kum utnaa raap baa diat lalaaun nate u ra pia ma diat lo dadaip diat maat. ");
INSERT INTO rai_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","God i kamaar raap wa a kum lalaaun na utnaa ko ra rakrakaan buaal. I kamaar wa a kum taara, a kum wewagua, a kum wewagua baa diat kakakaa u ra pia, ma ra kum pika ko ra maup. Noaa maku ungaai ma diat baa diat ki u ra paraau diat lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ma a palaa i pulu baat raap paa a rakrakaan buaal welaar ma 150 bungbung. ");
INSERT INTO rai_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Iaku God i nuk paa Noaa ma ra kum lomlom na wewagua ma ra kum laa na wewagua, baa diat ki ungaai mai u ra paraau, ma i tula wa a dadaip u ra rakrakaan buaal ma a palaa i waan pari waanwaan. ");
INSERT INTO rai_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Io, a palaa baa i waan ko ra kum mataana daanim taanga napia i ngo, ma a kum mataana kalaangaar inaanga u ra baakut i balbalaat balet, ma a baata i ngo. ");
INSERT INTO rai_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","A palaa i turpaai kupi in waan pari waanwaan balet ko ra rakrakaan buaal. Namur taan 150 na bungbung a palaa i ki pari waanwaan, ");
INSERT INTO rai_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ma u ra 17 na bung u ra we-7 na kalaang a paraau i ki nate un raa taangaai ko ra kum taangaai Aararat. ");
INSERT INTO rai_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","A palaa i ki pari waanwaan utbaai. U ra mugaana bung u ra wenoina kalaang, a kum galgali ra kum taangaai diat waan paat. ");
INSERT INTO rai_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Baa 40 na bungbung i raap, Noaa i paapa a mataana kalaangaar baa ia paam taai u ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ma i tula wa a kotkot. I rowo taltalili tuk a palaa i magege paa ko ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ma i tula wa bulung ina buna kupi in babo paa baa a pia ia magege, baa pate. ");
INSERT INTO rai_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Iaku ina buna pa i baat paa ta wanua kupi in ki uni, maa a palaa i pulu utbaai a rakrakaan buaal, io, i waan talili balet kup Noaa u ra paraau. Noaa i ung pari a limaana, ma i lo paa ina buna ma i lo ruk paai balet. ");
INSERT INTO rai_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noaa i walaanga paa balet 7 na bung, namur i tula wa balet ina buna ko ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ina buna i rowo talili balet karomi u ra maluraap, ungaai maku ma ra matakina dona diwaai na oliwa u ra waana. Ma Noaa i nunurai naa a palaa ia waan pari maraagaam ko ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","I walaanga paa balet 7 na bung, ma i tula wa balet ina buna, iaku ina buna wakir ma i waan talili karomi. ");
INSERT INTO rai_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","U ra kilaala baa Noaa i 601 kilaala na lalaaun anuna, u ra mugaana bung u ra mugaana kalaang, a palaa ia magege ko ra rakrakaan buaal. Io, Noaa i rakaan wa ina ulungan i ra paraau ma i baboi baa a pia ia magege. ");
INSERT INTO rai_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","U ra 27 na bung u ra weru kalaang, a rakrakaan buaal i magege raap mulu maraagaam. ");
INSERT INTO rai_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ma God i piri karom Noaa lenbi, ");
INSERT INTO rai_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ui ma ra num tabuan, a tula natnatum ma anunditul tula tabuan, muaat a pari ko ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ben apari kaai a kum wewagua raap ko ra paraau. Ben apari a kum pika ma ra kum wewagua, ma ra kum wewagua baa diat kakakaa u ra pia, kupi diat a babuta, ma diat a wabure diat balet u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Io, Noaa ma anuna tabuan, tula natnatuna ma anunditul tula tabuan diat pari ko ra paraau. ");
INSERT INTO rai_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","A kum wewagua raap baa diat lalaaun u ra rakrakaan buaal: A kum wewagua, a kum wewagua baa diat kakakaa u ra pia, ma a kum pika, diat raap diat pari ko ra paraau. Ma raaraa mangaana wewagua diat ut, diat pari ungaai. ");
INSERT INTO rai_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noaa i paam paa raa wunuwung na waat kup a tuntun wetabaar karom a Tadaaru. I lo paa raaraa wewagua ko ra kum mangaana gomgom na wewagua raap, ma raaraa ina pika ko ra kum mangaana gomgom na pika raap, ma i tun diat nate u ra wunuwung na waat, welaar ma ra wetabaar karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","A Tadaaru i gaaia u ra aangawian i ra wetabaar anun Noaa. Ma i piri u ra in balaana naa, “Pang baanaakaka balet a rakrakaan buaal un ta utnaa baa a taara diat a paami. Iaau aa nunura nuknuk i ra taara, turpaai baa diat naat liklik utbaai a nuknukindiat raap i nuknuk ku aakaina. Iaku, pang kamaar balet a taara ma ra kum wewagua, welaar ma iaau aa paam taai mi. ");
INSERT INTO rai_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Turpaai mi ma namur, tuk u ra bung baa a rakrakaan buaal in raap, a minamaarut ma ra tinangaa, a madiring ma ra wuwan, a taubaar ma ra labur, a bung na mage ma ra bung na marum, in waan ut lenmaa ma pa in ngo.” ");
INSERT INTO rai_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ma God i pir wadaan taa Noaa ma a tula natnatuna, ma i piri taan diat naa, “Muaat a babuta ma muaat a wabure muaat ma muaat a wateng a rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","A kum wewagua raap ko ra rakrakaan buaal, a kum pika raap ko ra maup, a kum wewagua raap baa diat kakakaa u ra pia, ma a kum ian raap u ra pakaana taai, diat a burut karom muaat. Iaau taar araap taa diat u ra limaamuaat. ");
INSERT INTO rai_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","A kum lalaaun na utnaa raap baa diat welia taltalili, a maamuaat kup a winangaan. Namuga mun iaau taar taa a kum waina diwaai, io mi, iaau taar a utnaa raap taa muaat. ");
INSERT INTO rai_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Iaku, koku muaat aan a naangnaangin baa pa di gi wakaak wa a gaap koni, maa a lalaaun i ki u ra gaap. ");
INSERT INTO rai_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","A gaapimuaat kaai i ngaatngaat. Iaau ang babaalu ma ra dekdek na naagagon karom ta muaana baa in aak doko wa tapaamuaat, ma ang babaalu kaai ma ra dekdek na naagagon karom ta wewagua baa in aak doko wa tapaamuaat. ");
INSERT INTO rai_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Te baa in aak doko wa te, ia kaai a taara diat a aak dokoi, kabina maa God i paam a taara welaar ut ma ra malalarina. ");
INSERT INTO rai_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Muaat a babuta ma muaat a wabure muaat, ma muaat a wateng a rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Namur God i piri karom Noaa ma tula natnatuna naa, ");
INSERT INTO rai_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Mi iaau paam anung kunubu ungaai ma muaat, ma ungaai kaai ma ra kum taptabumuaat namur. ");
INSERT INTO rai_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ma ungaai ma ra kum wewagua raap baa muaat pari ungaai ko ra paraau, a kum pika, a kum laa na wewagua ma ra kum lomlom na wewagua, a kum lalaaun na utnaa raap u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Bari ia anung kunubu ang paami ungaai ma muaat: Pang kamaar wa balet ma kum lalaaun na utnaa raap ma tina lomon. Painte. Ma pang baanaakaka balet a rakrakaan buaal ma ra tina lomon. ");
INSERT INTO rai_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","“Ang paam a kunubu naliwan taang ma muaat ma ra kum lalaaun na utnaa raap baa diat ki karom muaat, turpaai mi ma in waan waanwaan karom a kum taaun taara raap namur. Ang ung taa in tinaagagol naliwan u ra kum pakpakaana baakut, kupi a wakilang i ra nung kunubu karom a rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Baa ang taar wa ta kum baakut na baata nate u ra rakrakaan buaal, ma in tinaagagol in waan paat uni, ");
INSERT INTO rai_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ang nuk paa nung kunubu naliwan taan daat, muaat ma ra kum lalaaun na utnaa raap. Pa ta lomon balet ma in kamaar wa muaat. ");
INSERT INTO rai_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Baa in tinaagagol in waan paat naliwan u ra kum pakpakaana baakut, ma ang baboi, ang nuk paa a kunubu takum naliwan taang ma ra kum lalaaun na utnaa raap u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ma God i piri taan Noaa naa, “In tinaagagol ia a wakilang i ra kunubu baa iaau paami naliwan taang ma ra kum utnaa raap baa i lalaaun u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","A tula natun Noaa baa ditul pari ko ra paraau a iaanditul maa Sem, Aam ma Iaapet. Ma Aam a tamaan Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","A tula muaana mi, tula natun Noaa, a taara raap diat waan paat kon ditul, ma diat ki weraan u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noaa a tena minamaarut. Ia a mugaana muaana baa i maarut a wanua na waain. ");
INSERT INTO rai_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Raa bung, baa i inim paa a polo na waain, i sipaak uni, ma i inep towaturia taai u ra nuna ruma na sel. ");
INSERT INTO rai_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Aam, a tamaan Kaanaan, i babo taau un tamaana Noaa i towaturia, ma i wapua taa ru tateina nataamaan. ");
INSERT INTO rai_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem ma Iaapet diaar lo paa ina maalu ma diaar ung paakpaak paai u ra ru pupuakindiaar, ma diaar waan ruk ma ra tamarundiaar u ra ruma na sel, ma diaar burung baat taa tamaandiaar maa i towaturia. Diaar babo ingen, maa pa diaar nemi naa diaar a babo tamaandiaar baa i towaturia. ");
INSERT INTO rai_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Baa sipaak ia raap, Noaa i tawaangun paat, ma i walangoro a utnaa baa a murmur na natuna ia paam taai karomi. ");
INSERT INTO rai_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ma i piri naa, “A dekdek na naagagon in lo Kaanaan! In wilawilaau biaa ku karom a kum tateina.” ");
INSERT INTO rai_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","I piri kaai lenbi, “Din pir walaawa paa a Tadaaru, a God anun Sem. Kaanaan in wilawilaau anun Sem. ");
INSERT INTO rai_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God in wangaala paa a taara anun Iaapet, ma a taara anun Iaapet diat a ki wakaak ungaai ma ra taara anun Sem, ma Kaanaan in wilawilaau anun Iaapet.” ");
INSERT INTO rai_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Namur taa ra ina lomon, Noaa i lalaaun paa balet 350 kilaala. ");
INSERT INTO rai_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Io, a kum kilaala na lalaaun raap anun Noaa i welaar ma 950, ma namur i maat. ");
INSERT INTO rai_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Bi ia a aakaakur u ra tula natun Noaa, a iaanditul Sem, Aam ma Iaapet. Namur taa ra ina lomon ditul wangaala a kum naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","A kum natnatun Iaapet, a kum naat muaana, bi ia a iaandiat: Gomer, Maagog, Maadaai, Iaawaan, Tubaal, Mesek ma Tiraas. ");
INSERT INTO rai_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A tula natun Gomer, tula naat muaana, bi ia a iaanditul: Aaskenas, Ripat ma Togaarma. ");
INSERT INTO rai_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","A kum natnatun Iaawaan, a kum naat muaana, bi ia a iaandiat: Elisa, Taarsis, Kitim ma Dodaanim. ");
INSERT INTO rai_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Namur a taara baa diat waan paat kon diat, diat ki wawaal nakono ma u ra kum lolo. Io, a kum aapaapik na taara mi, diat ki weraan ut u ra nundiat kum pakpakaana, ma diat pirpir utkaai ma ra nundiat kum pirpir raaraa. ");
INSERT INTO rai_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","A kum natnatun Aam, a kum naat muaana, bi ia a iaandiat: Kus, Misraim, Put ma Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A kum natnatun Kus, a kum naat muaana, bi ia a iaandiat: Sebaa, Aawilaa, Saabtaa, Raamaa ma Saabteka. A ru natun Raamaa, a ru naat muaana, bi ia a iaandiaar: Sebaa ma Dedaan. ");
INSERT INTO rai_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus a tamaan Nimrod, ma Nimrod ia a mugaana muaana baa a dekdek na tena wineium u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ia raa dekdek na tena nilebe namataa ra Tadaaru. Maa ia a kabina baa di laana piri un te baa a dekdek na tena nilebe naa, “I welaar ma Nimrod raa dekdek na tena nilebe namataa ra Tadaaru.” ");
INSERT INTO rai_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A kum taamaan bi, Baabel, Erek, Aakad ma Kaalne u ra papaar Sinaar, diat raap diat a kum mugaana taamaan baa Nimrod i naagagon diat. ");
INSERT INTO rai_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Taanga matira i waan urong Aasiria, ma i paam a kum taamaan bi: Niniwe, Reobot-Ir, Kaala ");
INSERT INTO rai_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen, a ngaala na taamaan naliwan taan Niniwe ma Kaala. ");
INSERT INTO rai_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim a tamaa ra taara bi: a taara Lud, a taara Aanaam, a taara Leaab, a taara Naaptu, ");
INSERT INTO rai_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","a taara Paatrus, a taara Kaaslu ma ra taara Kaaptor. A taara Pilistia diat waan paat ko ra taara Kaaslu. ");
INSERT INTO rai_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Sidon a mugaana natun Kaanaan, ma Kaanaan a tamaa ra taara kaai bi: a taara Ket, ");
INSERT INTO rai_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","a taara Iebus, a taara Aamor, a taara Girgaas, ");
INSERT INTO rai_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","a taara Kiwi, a taara Aarkaa, a taara Sin, ");
INSERT INTO rai_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","a taara Aarwaad, a taara Semaar ma ra taara Kaamaat. Namur a kum aapaapik na taara anun Kaanaan diat waan weraan. ");
INSERT INTO rai_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","A pia Kaanaan i tur paai irong Sidon ma i waan tuk Geraar marawaai Gaasaa, ma i waan tapuku kup Sodom, Gomoraa, Aadmaa ma Seboim ma i waan tuk Laasa. ");
INSERT INTO rai_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","A taara mi, a wuna taara anun Aam. Namur, a kum aapaapik na taara mi diat ki weraan ut u ra nundiat kum pakpakaana ma diat pirpir utkaai ma ra nundiat kum pirpir raaraa. ");
INSERT INTO rai_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, a mugaana tein Iaapet. Sem kaai i wangaala raa kum naat muaana, ma ia a tabu ra kum natnatun Eber. ");
INSERT INTO rai_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","A kum natnatun Sem, a kum naat muaana, bi ia a iaandiat: Elaam, Aasur, Aapakaad, Lud ma Aaraam. ");
INSERT INTO rai_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","A kum natnatun Aaraam, a kum naat muaana, bi ia a iaandiat: Us, Kul, Geter ma Maas. ");
INSERT INTO rai_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aapakaad, a tamaan Selaa, ma Selaa a tamaan Eber. ");
INSERT INTO rai_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber i wangaala ru naat muaana. Raa di waatungi maa Pelek, kabina maa a taara u ra rakrakaan buaal diat waan weraan u ra kilaala na lalaaun anuna. Ma raa paan dina kaai a iaana maa Ioktaan. ");
INSERT INTO rai_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ioktaan a tamaa ra kum naat muaana, bi ia a iaandiat: Aalmodaad, Selep, Kaasarmaawet, Ieraa, ");
INSERT INTO rai_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Aadoraam, Usaal, Diklaa, ");
INSERT INTO rai_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obaal, Aabimaael, Sebaa, ");
INSERT INTO rai_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Aawilaa ma Iobaab. Diat raap bi a kum natnatun Ioktaan. ");
INSERT INTO rai_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","A kum taara mi, diat ki u ra pia i turpaai irong Mesa, ma i tuk u ra taamaan Sepaar, u ra wanua na taangaai u ra papaar ra taubaar. ");
INSERT INTO rai_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","A taara mi a wuna taara anun Sem. Namur, a kum aapaapik na taara mi diat ki weraan ut u ra nundiat kum pakpakaana, ma diat pirpir utkaai ma ra nundiat kum pirpir raaraa. ");
INSERT INTO rai_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Bi ia a iaa ra kum wuna taara ko ra tula natnatun Noaa, murmur ut anundiat kum wunwuna taara, ma anundiat kum aapaapik na taara. A taara raap diat waan paat ko ra kum taara mi, ma diat waan weraan u ra rakrakaan buaal raap, namur taa ra ina lomon. ");
INSERT INTO rai_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","U ra kum kilaala maa, a taara raap u ra rakrakaan buaal diat pirpir ku ma raa pirpir. Diat pirpir ku ma raa liu na pirpir. ");
INSERT INTO rai_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Baa a taara diat kakaraai kup a papaar ra taubaar, diat baat paa raa koina welaar na wanua u ra papaar Sinaar, ma diat ki matira. ");
INSERT INTO rai_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Diat pirpir wetwetalaai karom diat naa, “Daat a paam a kum briks ma daat a tun diat kupi diat a dekdek.” Io, pa diat papaam ma ra waat, diat papaam maku ma ra briks. Ma diat bulit ungaai a kum briks ma ra koltaa. ");
INSERT INTO rai_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ma diat piri kaai naa, “Daat a paam anundaat ta ngaala na taamaan ma daat a paam kaai ta turtur na ruma, ma ina ulunganina in tuk paa a baakut, kupi a iaandaat in rararang, ma koku daat waan weraan u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","A Tadaaru i waan pari kupi in babo a turtur na ruma ma ra ngaala na taamaan baa kuraa utbaai diat paampaami. ");
INSERT INTO rai_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","A Tadaaru i piri naa, “Mi a turturpaai ra kum utnaa baa diat nemi naa diat a paami. Baa a taara mi diat tur ungaai, ma diat pirpir ku ma raa pirpir, i tale ku diat a paam ta mangaana utnaa baa diat nemi. ");
INSERT INTO rai_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Datul a waan pari ma datul a walaklagon anundiat pirpir, kupi koku diat nunura lele aawa baa diat pirpir wetwetalaai uni.” ");
INSERT INTO rai_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Io, a Tadaaru i lu weraana wa diat u ra rakrakaan buaal raap, ma diat ngo paa maut ko ra pinapaam u ra ngaala na taamaan maa. ");
INSERT INTO rai_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Di waatung a taamaan mi baa Baabel, kabina maa a Tadaaru i walaklagon a pirpir anu ra taara raap u ra rakrakaan buaal matira. A Tadaaru i lu weraana wa diat u ra rakrakaan buaal raap ko ra taamaan maa. ");
INSERT INTO rai_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Bi ia a niluluk i ra wuna taara anun Sem. Baa ia ru kilaala namur taa ra ina lomon, a kilaala na lalaaun anun Sem i 100, io, di buta paa natuna, a naat muaana, a iaana Aapakaad. ");
INSERT INTO rai_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Baa di aa buta paa Aapakaad, Sem i lalaaun paa balet 500 na kilaala, ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Baa a kilaala na lalaaun anun Aapakaad i 35, di buta paa natuna, a naat muaana, a iaana Saalaa. ");
INSERT INTO rai_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Baa di aa buta paa Saalaa, Aapakaad i lalaaun paa balet 403 kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Baa a kilaala na lalaaun anun Saalaa i 30, di buta paa natuna, a naat muaana, a iaana Eber. ");
INSERT INTO rai_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Baa di aa buta paa Eber, Saalaa i lalaaun paa balet 403 kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Baa a kilaala na lalaaun anun Eber i 34, di buta paa natuna, a naat muaana, a iaana Pelek. ");
INSERT INTO rai_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Baa di aa buta paa Pelek, Eber i lalaaun paa balet 430 kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Baa a kilaala na lalaaun anun Pelek i 30, di buta paa natuna, a naat muaana, a iaana Reu. ");
INSERT INTO rai_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Baa di aa buta paa Reu, Pelek i lalaaun paa balet 209 na kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Baa a kilaala na lalaaun anun Reu i 32, di buta paa natuna, a naat muaana, a iaana Seruk. ");
INSERT INTO rai_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Baa di aa buta paa Seruk, Reu i lalaaun paa balet 207 na kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Baa a kilaala na lalaaun anun Seruk i 30, di buta paa natuna, a naat muaana, a iaana Naakor. ");
INSERT INTO rai_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Baa di aa buta paa Naakor, Seruk i lalaaun paa balet 200 na kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Baa a kilaala na lalaaun anun Naakor i 29, di buta paa natuna, a naat muaana, a iaana Teraa. ");
INSERT INTO rai_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Baa di aa buta paa Teraa, Naakor i lalaaun paa balet 119 na kilaala ma i wangaala paa balet raa kum naat muaana ma raa kum tabuan. ");
INSERT INTO rai_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Baa a kilaala na lalaaun anun Teraa i 70, namur di buta paa tula naat muaana, a iaanditul, Aabraam, Naakor ma Aaraan. ");
INSERT INTO rai_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Bi ia a niluluk i ra wuna taara anun Teraa. Teraa a tamaan Aabraam, Naakor ma Aaraan. Ma Aaraan a tamaan Lot. ");
INSERT INTO rai_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aaraan i maat, baa tamaana Teraa pa i maat utbaai. Aaraan i maat irong u ra taamaan Ur irong Kaaldea, a wanua baa di butai iaai. ");
INSERT INTO rai_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aabraam ma Naakor diaar taulaa ma ru tabuan. Aabraam i taulaa ma Saaraai, ma Naakor i taulaa ma Milka. Milka ma Iska a ru natun Aaraan. ");
INSERT INTO rai_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saaraai i bi, pa i babuta. ");
INSERT INTO rai_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teraa i ben paa natunalik Aabraam ma tabuna Lot, a natun Aaraan, ma a tabuan anun Aabraam, Saaraai. Diat waan pari taangirong Ur irong Kaaldea ma diat nemi kupi diat a waan urong Kaanaan. Iaku baa diat tuk paa a taamaan Aaran, diat ki okot matira. ");
INSERT INTO rai_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teraa i maat irong u ra taamaan Aaran, baa i 205 anuna kum kilaala. ");
INSERT INTO rai_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","A Tadaaru i piri karom Aabraam lenbi, “Un waan ko ra num taamaan, ma anum wuna taara, ma a taara baa diat ki u ra ruma anun tamaam, ma un waan kup a pakaana baa ang waiaa ta ui uni. ");
INSERT INTO rai_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ang wangaala anum wuna taara namur, ma diat a waan paat a ngaala na taara. Ma ang pir wadaan ui. Ang wangaala paa a iaam. A taara diat a daan, kabina un ui. ");
INSERT INTO rai_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ang pir wadaan diat baa diat pir wadaan ui, ma ang baanaakaka diat baa diat pirpir aakaka un ui. Ma un ui ang pir wadaan a taara raap u ra rakrakaan buaal.” ");
INSERT INTO rai_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Baa Aabraam i 75 kilaala anuna, i waan taangirong u ra taamaan Aaran, welaar ma ra Tadaaru ia pir taai taana. Lot kaai i waan ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aabraam i ben paa anuna taulaa Saaraai, natuna pi Lot ma ra nuna kum tultul baa i ben pa diat taangirong Aaran. Ma diat lo paa kaai anundiat kum utnaa raap, ma diat waan kup Kaanaan. Baa Aabraam diat, diat waan paat irong Kaanaan, ");
INSERT INTO rai_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","diat waan waanwaan u ra pia Kaanaan tuk diat waan paat u ra taamaan Sekem. Raa ina ngaala na diwaai i tur matira u ra wanua di waatungi ma More. U ra kum kilaala maa a taara Kaanaan diat ki u ra pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Io, a Tadaaru i waan paat karom Aabraam ma i piri taana naa, “Bi ia a pia maa ang taari karom anum wuna taara namur.” Io, matira Aabraam i paam taa a wunuwung na waat na tuntun wetabaar karom a Tadaaru, baa ia waan paat paa karomi. ");
INSERT INTO rai_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Namur diat kakaraai kup a taamaan na taangaai u ra mataana taubaar taan Betel. Ma diat ki paa matira naliwan naan Betel baa i ki u ra papaara labur, ma Aai u ra papaara taubaar. Matira i paam paa a wunuwung na waat na tuntun wetabaar ma i lotu karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ma Aabaraam diat, diat tur paa ma diat kakaraai waanwaan urong u ra papaar Negeb. ");
INSERT INTO rai_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Io, a ngaala na minolo i waan paat irong, ma Aabraam diat, diat waan kumun urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Baa marawaai diat a waan paat irong Aaigipto, Aabraam i piri karom anuna tabuan naa, “Saaraai, iaau nunurai naa a garaana tabuan aakit ui. ");
INSERT INTO rai_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Baa a taara Aaigipto diat a babo pa ui, diat a piri naa, ‘Anuna tabuan ut manaanga,’ ma diat a aak doko wa iaau, iaku maa ui, un lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Un piri ku naa daar tenalik, kupi din baboura wakaak iaau ma ang lalaaun kabina un ui.” ");
INSERT INTO rai_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Baa Aabraam diat, diat waan paat irong Aaigipto a taara Aaigipto diat babo anuna tabuan baa a garaana tabuan pi. ");
INSERT INTO rai_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ma baa a kum mukmuga anun Paraao diat babo paa Saaraai, diat wapua Paraao uni naa, a koina tabuan aakit, ma di ben ruk paai u ra ruma anun Paraao. ");
INSERT INTO rai_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ma Paraao i baboura wakaak Aabraam kabina un Saaraai. I tabaara Aabraam ma ra kum sip, a kum bulumakaau, a kum muaana na dongki ma ra kum tabuanina, a kum tultul na muaana ma ra kum tultul na tabuan ma ra kum kaamel. ");
INSERT INTO rai_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Iaku, a Tadaaru i wakadik Paraao ma ra taara raap u ra nuna ruma ma ra kum aakaina malaapaang, kabina un Saaraai, a taulaa anun Aabraam. ");
INSERT INTO rai_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Io, Paraao i wataa paa Aabraam ma i piri taana naa, “Aawa mi u paami un iaau? I lawaai maa pa u wapua iaau naa Saaraai anum tabuan? ");
INSERT INTO rai_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","I lawaai maa u piri ku naa mur tenalik, ma iaau ben paai kupi anung taulaa? Io, ben paa anum tabuan bi, ma mur a waan.” ");
INSERT INTO rai_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Io, Paraao i taar a naagagon karom anuna kum mukmuga kupi diat a tula wa Aabraam ma anuna taulaa, ma ra nuna kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Io, Aabraam ungaai ma ra nuna tabuan diaar waan paa taangirong Aaigipto, ungaai ma ra nuna kum utnaa raap, urong kup a papaar Negeb. Ma Lot kaai i waan ungaai ma diat. ");
INSERT INTO rai_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aabraam ia raa tadaaru na muaana. I tadaaru ma ra kum wewagua ma ra silwa ma ra goled. ");
INSERT INTO rai_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","I waan paa taangirong Negeb ma i ki waanwaan u ra kum wanua tuk i waan paat u ra taamaan Betel, kup a wanua naliwan taan Betel ma Aai, baa ia ki paa mun iaai. ");
INSERT INTO rai_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A taamaan baa i paam taa anuna wunuwung na waat na tuntun wetabaar iaai. Ma matira Aabraam i lotu karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot kaai i waan ungaai ut ma Aabaraam. Ia kaai anuna kum sip, a kum bulumakaau ma ra kum ruma na sel. ");
INSERT INTO rai_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Iaku, u ra nundiaar kinkini ungaai, a pia pa i welaar ma diaar raap, maa kabina anundiaar kum wewagua i bure aakit. ");
INSERT INTO rai_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","A taara na baboura wewagua anun Aabraam diat kaankaan karom a kum tena baboura wewagua anun Lot. Ma u ra kum kilaala maa, a taara Kaanaan ma a taara Peris kaai kuraa ut diat lalaaun matira. ");
INSERT INTO rai_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Io, Aabraam i piri karom Lot naa, “Koku ta kaankaan naliwan karom daar, baa naliwan karom anundaar kum tena baboura wewagua, maa daar tamaana ku. ");
INSERT INTO rai_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Baboi, a ngaala na pia bi ia namuga taam. Io, daar a waan weraan. Baa un waan u ra papaara maira, iaau ang waan u ra papaara ot. Baa un waan u ra papaara ot, iaau ang waan u ra papaara maira.” ");
INSERT INTO rai_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot i babo taptapuku, ma i babo a maale u ra papaara daanim Ioridaan, baa i waan kup a taamaan Soaar. A kum utnaa i tawa wakwakaak, maa a kum daanim i teng matira, welaar ma ra wanua anu ra Tadaaru, ma i welaar kaai ma Aaigipto. A utnaa mi i waan paat namuga baa a Tadaaru pa i kamaar utbaai Sodom ma Gomoraa. ");
INSERT INTO rai_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Io, Lot i pilak paa a maale Ioridaan, ma i waan kup a mataana taubaar. Io, diaar waan weraan. ");
INSERT INTO rai_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aabraam i ki u ra pia Kaanaan, ma Lot i ki naliwan u ra kum taamtaamaan irong u ra maale Ioridaan, ma i watur anuna kum ruma na sel marawaai Sodom. ");
INSERT INTO rai_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A taara Sodom diat teng ma ra mangamangaan aakaina, ma anundiat aakaina i ngaala aakit namataa ra Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Namur baa Lot i waan koni, a Tadaaru i piri karom Aabraam lenbi, “Un babo, ma un babo taltalili u ra waat na mataana dadaip. ");
INSERT INTO rai_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","A kum pia raap baa u baboi, ang taar raap taai taam, ma anum takum, ma anu ra num wuna taara namur. ");
INSERT INTO rai_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ang wabure anum wuna taara namur welaar ma ra kabu ko ra rakrakaan buaal. Pa te in luk laar paa a kabu ko ra rakrakaan buaal, lenmaa pa te kaai in luk laar paa anum wuna taara namur. ");
INSERT INTO rai_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Un waan ma un waan murmur a iokaana ma ra parere i ra pia baa ang taari taam.” ");
INSERT INTO rai_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Io, Aabraam i gaat paa anuna kum ruma na sel, ma i waan kupi in ki naa ra kum ngaalangaala na diwaai anun Maamre, u ra taamaan Ebron. Matira i paam paa a wunuwung na waat na tuntun wetabaar karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","U ra kum bungbung maa, Aamraapel a king ko ra taamaan Sinaar, Aariok a king ko ra taamaan Elaasaar, Kedolaame a king ko ra taamaan Elaam, ma Tidaal a king ko ra taamaan Goim, ");
INSERT INTO rai_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","a waat na king mi, diat waan na wineium kup lima na king kaai bi, Beraa a king ko ra taamaan Sodom, Birsa a king ko ra taamaan Gomoraa, Sinaap a king ko ra taamaan Aadmaa, ma Semebaa a king ko ra taamaan Seboim, ma ra king ko ra taamaan Belaa. Belaa di laana waatungi kaai baa Soaar. ");
INSERT INTO rai_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Lima na king mi, diat waan ungaai ma ra nundiat taara na wineium u ra maale Sidim, baa mari di waatungi baa Minaat na Taai. ");
INSERT INTO rai_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","A kum king mi, namuga diat ki naatudaangi ra naagagon anun Kedolaame welaar ma 12 kilaala, iaku mi u ra we-13 kilaala pa diat nem na ki ma naatudaangi ra nuna naagagon ma diat tur kupi diat a weium mai. ");
INSERT INTO rai_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","U ra we-14 na kilaala, king Kedolaame ungaai ma ra tula king baa diat tur ungaai mai, diat um a taara Repaaim u ra taamaan Aastaarot-Kaanaaim, a taara Sus u ra taamaan Aam, a taara Em u ra maale Kiriataaim, ");
INSERT INTO rai_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma ra taara Or irong Seir, a wanua na taangaai, ma diat lu diat kup a taamaan Elpaaraan, marawaai a bil na wanua. ");
INSERT INTO rai_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ma a taara anun Kedolaame diat tapuku balet ma diat waan kup a taamaan En-Mispaat, baa di waatungi kaai baa Kaades. Ma diat uwia paa a taara Aamalek ma a taara Aamor baa diat ki u ra taamaan Aaseson-Taamaar, ma diat kale raap paa anundiat kum pia. ");
INSERT INTO rai_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Io, a kum king taanga Sodom, Gomoraa, Aadmaa, Seboim ma Belaa baa di waatungi kaai baa Soaar, diat waan ungaai kup a maale Sidim, ma diat waninaar diat kup a wineium ungaai ma ");
INSERT INTO rai_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedolaame a king ko ra taamaan Elaam, Tidaal a king ko ra taamaan Goim, Aamraapel a king ko ra taamaan Sinaar ma Aariok a king ko ra taamaan Elaasaar. Waat na king maa diat tur na wineium kup lima na king kaai. ");
INSERT INTO rai_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","A maale Sidim i teng ma ra kum tung na koltaa, ma baa a ru king taanga Sodom ma Gomoraa, diaar welulu ino ko ra wineium, raa taara na wineium anundiaar diat katuk u ra kum tung na koltaa. Ma raa taara kaai diat welulu tato kup a kum taangaai. ");
INSERT INTO rai_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A kum king baa diat tur ungaai ma Kedolaame, diat uwia paa a taara Sodom ma Gomoraa, ma diat lo raap paa kum wuwuwung ko ra ru taamaan maa, ungaai ma ra andiat kum utnaa na winangaan raap, ma diat waan. ");
INSERT INTO rai_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ma diat paam koto paa kaai Lot, baa diaar tamaana pi ma Aabraam, ma diat lo raap paa nuna kum utnaa, baa i lalaaun ungaai mai irong Sodom. ");
INSERT INTO rai_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Raa kon diat baa diat welulu ino ko ra wineium, i kalaa paat karom Aabraam a te Ebraaio, ma i wapuai un Lot. Aabraam i lalaaun naa ra kum ngaala na diwaai anun Maamre a te Aamor, ditul tenalik ma Eskol ma Aaner. Ditul tepaana ma Aabraam. ");
INSERT INTO rai_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Baa Aabraam i walangoroi naa di aa aal paa Lot kupi in karabus, i wetulaa ungaai paa anuna 318 a dekdek na taara na wineium baa di buta diat ut u ra nuna kum ruma na sel. Ma diat murmur a taara na wineium anu ra waat na king maa, tuk irong u ra taamaan Daan. ");
INSERT INTO rai_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Io, u ra marum Aabraam i weraana anuna taara kupi diat a um diat. Ma diat lu a taara na wineium anu ra waat na king tuk u ra taamaan Kobaa, baa i marawaai karom Damaasko u ra papaar ra labur. ");
INSERT INTO rai_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ma Aabraam i lo talili raap paa balet a kum utnaa anu ra taara, ma i ben talili paa kaai Lot natun tenalik, ungaai ma anuna kum utnaa raap. Ma i ben talili paa kaai a kum tabuan ungaai ma raa taara kaai, baa waat na king diat aa aal pa diat. ");
INSERT INTO rai_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Namur baa Aabraam ia uwia paa Kedolaame ma ra tula king baa diat tur ungaai mai, i waan talili. Ma a king ko ra taamaan Sodom i waan baraata paa Aabraam u ra maale Saawe, di waatungi kaai baa Maale anu ra King. ");
INSERT INTO rai_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek kaai, a king ko ra taamaan Saalem, i waan baraata Aabraam, ma i lo kaai a bred ma ra waain. Melkisedek ia raa tena wetabaar karom God a Ngaala Aakit. ");
INSERT INTO rai_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melkisedek i pir wadaan Aabraam, i piri naa, “Aabraam, God a Ngaala Aakit, a Tena Wawaki ko ra maawa ma ra rakrakaan buaal, in pir wadaan ui. ");
INSERT INTO rai_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","A pir walaawa karom God a Ngaala Aakit, baa i ung taa anum kum ebaar u ra limaam.” Ma Aabraam i taar raaraa ko ra nonoina ko ra nuna kum utnaa raap karom Melkisedek. ");
INSERT INTO rai_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A king ko ra taamaan Sodom i piri karom Aabraam naa, “Iaau nem ku anung taara urin, iaku a kum utnaa raap un paam akotoi, kupi anum.” ");
INSERT INTO rai_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Iaku Aabraam i piri taa ra king taangirong Sodom naa, “Iaau aa weweliman taau karom a Tadaaru God a Ngaala Aakit, a Tena Wawaki ko ra maawa ma ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Anung weweliman i lenbi: Pang paam akoto mulu paa anum ta utnaa, baa tin teret lik maku, baa tina aaru ko ra su, kaduk un piri naa iaau tadaaru ku kon ui. ");
INSERT INTO rai_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Pang paam akoto paa anum ta utnaa, iaku aawa baa anung taara diat aa aan paai, i welaar ku, ma karom Aaner, Eskol ma Maamre un taar taa anunditul ta kukura utnaa ko ra kum utnaa baa miaat aa uwia paai, kupi anunditul.” ");
INSERT INTO rai_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Namur baa a kum utnaa mi ia raap, Aabraam i babo a binabo ma i walangoro a Tadaaru i pirpir karomi, “Aabraam, koku burut, iaau anum baakbaakit, anung wetabaar karom ui in ngaala aakit.” ");
INSERT INTO rai_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Iaku Aabraam i baalui naa, “Ngaala na Tadaaru, aawa mulu maa un tabaara iaau mai? Maa iaau pa ta natunglik. Ma ia baa in kale anung kum utnaa raap baa ang maat, Elieser ku taanga Damaasko. ");
INSERT INTO rai_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pa u taar taa anung ta naat, io, raa maku ko ra nung kum tultul in kale anung kum utnaa raap.” ");
INSERT INTO rai_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","A Tadaaru i piri balet karomi naa, “Elieser pa in kale anum kum utnaa. Ta natumlik ut baa un wangaala paai maa in kale anum kum utnaa.” ");
INSERT INTO rai_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","A Tadaaru i ben pari paa Aabraam ko ra ruma na sel ma i piri taana naa, “Babo unaanga u ra baakut, ma un walaari kupi un luk a kum naangnaang. Anum wuna taara namur, a nilulukindiat in welaar ma ra kum naangnaang.” ");
INSERT INTO rai_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aabraam i nurnur u ra Tadaaru, ma u ra nuna nurnur ut, a Tadaaru i waatungi baa a tena takado. ");
INSERT INTO rai_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ma i piri kaai taana naa, “Iaau a Tadaaru baa iaau ben apari pa ui taangirong Ur a taamaan anu ra taara Kaaldeaa, kupi ang taar taa a pia bi baa anum.” ");
INSERT INTO rai_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Iaku Aabraam i piri, “Ngaala na Tadaaru, ang nunurai lelawaai naa namur anung a pia mi?” ");
INSERT INTO rai_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Io, a Tadaaru i piri taan Aabraam lenbi, “Un lo paa ta tabuan na bulumakaau, ma ta tabuan na me, ma ta muaana na sip, ditul raap in tula kilaala na lalaaun anunditul, ma tina buna ma ta baarmaan na kuwur kaai. Ma un lo diat karom iaau.” ");
INSERT INTO rai_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aabraam i lo raap taa a kum wewagua karom a Tadaaru. Ma Aabraam i poko diat, ruru papaar kon raa wewagua. Ma i ung kado ta diat, raa papaarina marawaai karom raa papaarina kaai koni. Iaku ruina pika maku pa i poko diaar. ");
INSERT INTO rai_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ma a kum kotkot diat rowo pari kupi diat a aan a kum pakpakaana wewagua maa, iaku Aabraam i lulu wa diat ku koni. ");
INSERT INTO rai_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Baa in mataana mage i marawaai kupi in lop, Aabraam i inep duman, ma ra ngaala na baboto baa i urugian aakit i pulu baat paai. ");
INSERT INTO rai_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Namur a Tadaaru i piri karom Aabraam, “Un nunurai baa anum wuna taara namur diat a ki na waira u ra taamaan baa wakir anundiat. Din pet na bilbil un diat ma diat a papaam na karabus, in welaar ma 400 na kilaala. ");
INSERT INTO rai_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Iaku namur ang taar a dekdek na naagagon na binabaalu karom diat baa diat wakarabus diat. Ma baa diat a pari ko ra taamaan maa, diat a lo a ngaala na wuwuwung. ");
INSERT INTO rai_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Iaku ui, Aabraam, anum kilaala na lalaaun in iok, ma un maat ma ra maalmaal ma din punang wa ui. ");
INSERT INTO rai_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Anum taara diat a ki na karabus 400 na kilaala, kabina maa a aakaina mangamangaan anu ra taara Aamor pa i ot utbaai kupi din kamaar wa diat. Iaku a taara u ra wewaat na taaun taara diat a waan talili balet urin u ra taamaan mi.” ");
INSERT INTO rai_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","A mataana mage i lop ma ra baboto i waan paat. Nabalaara baboto ru utnaa diaar waan paat, a kuro baa a tubal i waan paat koni, ma ra kupkup i ra nguan, diaar waan naliwan u ra kum pakpakaana wewagua. ");
INSERT INTO rai_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Io, u ra bung maa a Tadaaru i paam anuna kunubu ungaai ma Aabraam. Ma a Tadaaru i piri naa, “Ang taar a pia mi karom anum wuna taara namur, a pia naliwan taa ra ru daanim, a daanim irong Aaigipto ma ra ngaala na daanim Eupraat. ");
INSERT INTO rai_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","A pia mi anu ra taara Ken, taara Kenis, taara Kaadmon, ");
INSERT INTO rai_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","taara Ket, taara Peres, taara Repaaim, ");
INSERT INTO rai_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","taara Aamor, taara Kaanaan, taara Girgaas ma a taara Iebus.” ");
INSERT INTO rai_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saaraai, a taulaa anun Aabraam, pa i buta paa ta naat. Anuna raa tultul na tabuan taangirong Aaigipto a iaana Aagaar. ");
INSERT INTO rai_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ma Saaraai i piri taan Aabraam naa, “A Tadaaru ut maa i naagagon taai baa pang babuta. Io, koina baa un inep ungaai ma anung tultul Aagaar kupi in buta taa anung ta naat.” Ma Aabraam i paami lenmaa Saaraai i pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saaraai i tula taa Aagaar, anuna tultul taangirong Aaigipto, karom Aabraam kupi in taulaa mai. A utnaa mi i waan paat baa i 10 kilaala baat Aabraam irong Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Aabraam i inep ungaai ma Aagaar, ma namur Aagaar i kipbaala. Baa i kariaanai naa ia kipbaala, i turpaa milikuaana Saaraai, anuna mukmuga. ");
INSERT INTO rai_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saaraai i piri karom Aabaraam lenbi, “Ui maa u kabina maa Aagaar i milikuaana iaau. Iaau taar taa a tabuan mi taam, iaku mi ia kipbaala, io, i milikuaana iaau maku. Iaku a Tadaaru ut in naagagon kado daar.” ");
INSERT INTO rai_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aabraam i piri karom Saaraai naa, “Ui ut u naagagon anum tultul. Aawa baa u nemi un paami uni, un paami ku.” Ma Saaraai pa i koina paa ma Aagaar, io, Aagaar i kalaa ino paa koni. ");
INSERT INTO rai_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Aangelo anu ra Tadaaru i waan paat karom Aagaar marawaai naan raa mataana daanim lik u ra bil na wanua, naa ra aakapi urong Sur. ");
INSERT INTO rai_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ma i piri taana naa, “Aagaar, ui a tultul anun Saaraai, u waan taangawaai mi, ma un waan ma uwaai?” Aagaar i baalui naa, “Iaau welulu ino kon Saaraai, anung mukmuga.” ");
INSERT INTO rai_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Aangelo anu ra Tadaaru i piri taana naa, “Un waan talili balet kup anum mukmuga, ma un taraam taana.” ");
INSERT INTO rai_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","I piri kaai taana naa, “Iaau ut ang wangaala paa a kum taptabum namur, kupi diat a bure aakit ma pa te in luk laar pa diat.” ");
INSERT INTO rai_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Aangelo anu ra Tadaaru i piri kaai taana lenbi, “U aa kipbaala, ma un buta paa a naat muaana. Ma un waatung taa a iaana baa Ismaael, maa a Tadaaru ia walangoro taa anum niluan u ra kum mawaat baa u kariaanai. ");
INSERT INTO rai_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ismaael in welaar ma ra lomlom na dongki, in weweium ungaai ma ra taara raap, ma ra taara kaai diat a weweium ungaai mai, ma in ki na ebaar ma ra kum tateina liklik raap.” ");
INSERT INTO rai_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ma Aagaar i waatung a iaa ra Tadaaru baa i pirpir paa karomi naa, “Ui a God baa u babo iaau.” Maa i piri naa “Iaau aa babo taa ia baa i bababo iaau.” ");
INSERT INTO rai_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Io, di waatung a daanim maa baa “Biaar Laakaairoi.” Kurong utbaai a daanim maa, i ki naliwan taan Kaades ma Bered. ");
INSERT INTO rai_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Io, Aagaar i buta taa raa naat muaana un Aabraam, ma Aabraam i waatung taa a iaana baa Ismaael. ");
INSERT INTO rai_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","A kilaala na lalaaun anun Aabaraam i welaar ma 86 baa Aagaar i babuta taau uni. ");
INSERT INTO rai_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Baa a kilaala na lalaaun anun Aabraam i welaar ma 99, a Tadaaru i waan paat karomi ma i piri, “Iaau God baa i Dekdek Aakit. Un taraam taang, ma un paam a takado na mangamangaan. ");
INSERT INTO rai_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Iaau ang walingtatuna anung kunubu naliwan karom daar, ma ang wabure anum taara, ma a nilulukindiat in ngaala.” ");
INSERT INTO rai_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aabraam i ki but keke ma i ung pari a mataana unapia. Ma God i piri karomi naa, ");
INSERT INTO rai_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Karom iaau, anung kunubu ungaai ma ui i lenbi: Namur ui a tamaa ra kum mongoro na wunwuna taara. ");
INSERT INTO rai_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mi din kiaana a iaam. Namuga di waatung ui baa Aabraam, ma mi din waatung ui baa Aabaraam, maa iaau aa pilak pa ui kupi ui a tamaa ra mongoro na wunwuna taara. ");
INSERT INTO rai_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Iaau ang wabure a kum taptabum, ma a kum king ma ra kum wunwuna taara diat a waan paat kon ui. ");
INSERT INTO rai_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Iaau ang walingtatuna paa anung kunubu naliwan taan daar, ma ra num wuna taara kaai namur, ma anung kunubu in tur takum. Anung kunubu i lenbi: iaau anum God, ma ra God anu ra kum taptabum namur. ");
INSERT INTO rai_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","A kudulaana pia Kaanaan baa mi u ki na waira uni, ang taari taam kupi anum takum, ma anu ra kum taptabum namur. Ma iaau ut anundiat God.” ");
INSERT INTO rai_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Namur God i piri balet taan Aabaraam naa, “Bi ia anung pirpir karom ui: Un murmur anung kunubu, muaat ma ra kum taptabum, ma diat kaai a kum taaun taara baa diat a waan paat namur. ");
INSERT INTO rai_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Anung kunubu ungaai ma ui ma ra kum taptabum raap namur taam in lenbi: A kum muaana raap kon muaat din poko kikil diat. Muaat a taraam u ra kunubu mi. ");
INSERT INTO rai_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Muaat a poko a pani ra kum muaana kupi a wakilang baa muaat murmur a kunubu naliwan taan daat. ");
INSERT INTO rai_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Turpaai mi, ma karom a kum taaun taara namur, baa a naat muaana lik i 8 na bung anuna, muaat a poko kikili. A kum natnatumuaat raap, ma woi na naat muaana kaai, natun ta tultul baa di butai naliwan naamuaat, ma diat kaai baa muaat kul pa diat ma ra maani kupi diat a tultul, ma wakir ko ra numuaat wuna taara, din poko kikil a kum muaana raap. A poko kikil u ra panimuaat ia a wakilang i ra kunubu takum. ");
INSERT INTO rai_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ta muaana baa pa di poko kikili u ra panina, din rakaan wai ko ra nuna taara, maa pa i murmur anung kunubu.” ");
INSERT INTO rai_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God i piri kaai karom Aabaraam naa, “Bi ia anung pirpir karom anum tabuan, Saaraai: Mi pa un waatungi balet ma baa Saaraai. Un waatungi ma naa Saaraa. ");
INSERT INTO rai_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Iaau ut ang pir wadaani, ma in buta paa ta natum, a naat muaana. Ang pir wadaan Saaraa kupi ia a naa ra mongoro na wuna taara. Ma a kum king anu ra kum wuna taara diat a waan paat koni.” ");
INSERT INTO rai_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aabaraam i ki but keke ma i ung pari a mataana unapia, ma i nangon ma i piri balet karom ia ut naa, “Lelawaai, din buta ku ta naat u ra muaana baa ia 100 na kilaala anuna? Lelawaai, Saaraa in babuta baa ia 90 kilaala anuna?” ");
INSERT INTO rai_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ma Aabaraam i piri karom God naa, “I koina ku baa Ismaael maku in lalaaun naatudaangi ra num pir wadaan.” ");
INSERT INTO rai_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma God i piri, “Pate, iaku anum tabuan Saaraa in buta paa ut ta natum, a naat muaana, ma un ung taa a iaana naa Aaisaak. Ang walingtatuna anung kunubu un Aaisaak ma ra kum taptabuna namur, ma a kunubu maa in tur takum ma pa in raap. ");
INSERT INTO rai_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“Bi ia anung pirpir un Ismaael: Iaau aa walangoro ta ui, iaau ut ang pir wadaan Ismaael, iaau ut ang wabure a kum natnatuna ma ang wangaala anundiat niluluk. Ismaael in waan paat a tamaa ra 12 a kum ngaalangaala na mukmuga. Iaau ang wabure pa diat kupi diat a ngaala na wuna taara. ");
INSERT INTO rai_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Iaku anung kunubu ang walingtatunai ut un Aaisaak, baa Saaraa in buta taai un ui. In butai u ra kalaang lenmi, u ra kilaala namur.” ");
INSERT INTO rai_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Baa God ia pirpir raap paa ma Aabaraam, i waan koni. ");
INSERT INTO rai_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","U ra bung ut maa, Aabaraam i ben paa natuna lik Ismaael, ma diat kaai baa di buta diat matira u ra nuna kum ruma na sel, ma diat kaai baa i kul pa diat ma ra nuna maani, kupi anuna kum tultul. A kum muaana raap baa diat ki ungaai mai, di poko kikil diat, welaar ut ma God ia wapua taai uni. ");
INSERT INTO rai_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","A kilaala na lalaaun anun Aabaraam i welaar ma 99 baa di poko kikili. ");
INSERT INTO rai_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ma kilaala na lalaaun kaai anun natunalik Ismaael i 13 baa di poko kikili. ");
INSERT INTO rai_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aabaraam ma natunalik Ismaael di poko kikil diaar un raa bung ku, ");
INSERT INTO rai_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ungaai ma ra kum muaana raap baa diat ki u ra kum ruma na sel anun Aabaraam, ma diat kaai baa di buta diat matira naana, ma diat a kum tultul baa di kul pa diat ko ra kum waira na taara. ");
INSERT INTO rai_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","A Tadaaru i waan paat karom Aabaraam marawaai naa ra kum ngaalangaala na diwaai anun Maamre. U ra pakaana bung maa a mage i dekdek aakit ma Aabaraam i ki taau naa ra bonanaaka i ra nuna ruma na sel. ");
INSERT INTO rai_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Baa Aabaraam i babo kado, i babo paa tula muaana, ditul tur taau. Baa i babo pa ditul, i tur gagaa paa ko ra bonanaaka, ma i kalaa baraata ditul, ma i ki but keke ma ra mataana unapia karom ditul. ");
INSERT INTO rai_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ma i piri lenbi, “Anung tadaaru, baa u maari iaau, koku u waan aakit wa iaau, anum tultul. ");
INSERT INTO rai_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ang wetulaa kup ta lik palaa, ma mutul a gi paa kakimutul mai, ma mutul a ngo paa u ra ororo i ra in diwaai mi. ");
INSERT INTO rai_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ang lo paa ta utnaa na winangaan baa mutul a aani, kupi mutul a wadekdek paa mai. Io namur, mutul a waan balet u ra numutul winawaan. Ma mi mutul aa waan paat naa ra numutul tultul.” Ma ditul baalui naa, “Wakaak, un paami ku lenmaa u piri.” ");
INSERT INTO rai_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Io, Aabaraam i welulu ruk u ra nuna ruma na sel karom Saaraa, ma i piri taana naa, “Aiaap gagaa, lo paa ta ngaala na bek na koina palawaa, ma un paam paai ma un tun taa ta bred koni.” ");
INSERT INTO rai_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ma i kalaa kup anuna kum wewagua ma i pilak paa raa naat na bulumakaau baa i tubu wakwakaak, i taar taai karom anuna tultul kupi in waninaar gagaa paai. ");
INSERT INTO rai_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ma Aabaraam i lo paa a polo na tu i ra bulumakaau, ma ra polo na tu baa i katian, ma ra bulumakaau baa anuna tultul ia tun taai, ma i ung taai namuga naan ditul. I tur taau marawaai naan ditul baa kuraa ditul wangaan natudaangi ra in diwaai. ");
INSERT INTO rai_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ditul tiri naa, “Waiaa anum taulaa, Saaraa?” Aabaraam i baalu ditul naa, “Kuaa naruma u ra ruma na sel.” ");
INSERT INTO rai_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ma a Tadaaru i piri naa, “Iaau ang waan talili balet karom ui, u ra bung lenbi, u ra kilaala namur, ma baa ang waan talili, anum tabuan Saaraa ia buta paa a naat muaana.” Saaraa i walangoroi taanga naruma naa ra bonanaaka i ra ruma na sel, baa kuraa namur taa ra muaana maa. ");
INSERT INTO rai_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aabaraam ma Saaraa diaar aa takaana, ma Saaraa anuna kilaala pa i ot balet ma kupi in babuta. ");
INSERT INTO rai_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Io, Saaraa i nangon ino, maa i nuki naa, “Pa i tale iaau balet ma kupi ang babuta, maa iaau aa takaana, ma Aabaraam kaai ia takaana. Lelawaai, ang gaaia maraagaam?” ");
INSERT INTO rai_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ma a Tadaaru i piri karom Aabaraam, “I lawaai maa Saaraa i nangon ma i piri naa, ia takaana, ma in babuta maraagaam? ");
INSERT INTO rai_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Pa ta utnaa i dekdek karom a Tadaaru. Ang waan talili balet kup ui, u ra bung baa iaau aa kubu taai u ra kilaala namur, baa Saaraa ia buta paa a naat muaana.” ");
INSERT INTO rai_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saaraa i burut, io, i warwaruga ma i piri lenbi, “Pa iaau nangon.” Iaku a Tadaaru i piri, “I dowot ut, u nangon.” ");
INSERT INTO rai_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Baa tula muaana ditul tur paa ma ditul waan, Aabaraam i weur ungaai ma ditul kupi in tur tula wa ditul. Diat tur taau un raa wanua ma diat babo pari kup Sodom. ");
INSERT INTO rai_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ma a Tadaaru i piri naa, “Koku duk iaau walipa a utnaa mi kon Aabaraam baa kuri iaau nem na paami. ");
INSERT INTO rai_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Maa a kum taptabun Aabaraam namur diat a waan paat a ngaala na dekdek na wuna taara, ma kabina un Aabaraam din wadaan a kum wunwuna taara raap u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ma iaau aa pilak paai kupi in wer wakaak a kum natnatuna, ma ra kum taptabuna kaai namur, kupi diat a taraam karom iaau ma diat a paam a mangamangaan baa i koina ma i takado. Baa diat a paami lenmaa, ang taar taa a utnaa baa iaau aa weweliman taau uni karom Aabaraam.” ");
INSERT INTO rai_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ma a Tadaaru i piri lenbi, “Iaau aa walangoro taa a ngaala na tinaangi na wetakun u ra taara Sodom ma Gomoraa, maa anundiat mangamangaana aakaina i ngaala aakit. ");
INSERT INTO rai_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ang waan pari ma ang babo aawa baa diat aa paam taai, kupi ang nunurai baa i welaar ut ma ra tinaangi baa iaau aa walangoro taai, baa pate.” ");
INSERT INTO rai_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","A ru muaana diaar waan kon Aabaraam, ma diaar waan kup Sodom. Iaku a Tadaaru i tur okot karom Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ma Aabaraam i waan marawaai karomi ma i wetiri naa, “Lelawaai, un kamaar wa ma a takado na taara, ungaai ma ra aakaina taara? ");
INSERT INTO rai_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kaduk ta 50 takado na taara kuraa diat lalaaun u ra taamaan maa. Lelawaai, un kamaar wa ut a taamaan, baa un walaauni kabina un 50 takado na taara maa? ");
INSERT INTO rai_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Koku mulu ut u paam a utnaa mi, baa un kamaar a takado na taara ungaai ma ra aakaina taara. Koku u baanaakaka a takado na taara ungaai ma ra aakaina taara. Ui u naagagon a rakrakaan buaal ma u laana paam ku a utnaa baa i takado.” ");
INSERT INTO rai_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","A Tadaaru i piri, “Baa ang baat paa ta 50 takado na taara u ra taamaan Sodom, io ang walaaun a kudulaana taamaan kabina un diat.” ");
INSERT INTO rai_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma Aabaraam i piri balet, “Iaau a ling biaa ku, iaau welaar ku ma ra kabu i ra nguan. Iaku iaau walaari ut kupi ang pirpir karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Baa a niluluk i ra kum tena takado in 45, lelawaai, un kamaar a kudulaana taamaan, kabina a niluluk i iba kup a lima na muaana ku?” A Tadaaru i baalui naa, “Baa ang baat paa ta 45, pang kamaar a taamaan.” ");
INSERT INTO rai_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Raa pakaan balet Aabaraam i tiri a Tadaaru, “Lelawaai, baa un baat paa ku ta 40 takado na taara?” I baalui, “Baa ta 40 taara ku, pang kamaar a taamaan.” ");
INSERT INTO rai_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ma Aabaraam i piri naa, “Tadaaru, koku u kaankaan karom iaau. Un maadek wa iaau ku baa ang pirpir. Lelawaai, baa un baat paa ku ta 30?” I baalui, “Pang kamaar Sodom baa ang baat paa ta 30 takado na taara.” ");
INSERT INTO rai_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aabaraam i piri, “Iaau burut kupi ang pirpir karom a Tadaaru, iaku iaau wadekdek pa iaau ku kupi ang tiri balet. Lelawaai baa un baat paa ku ta 20 takado na taara?” I baalui, “Baa ang baat paa ta 20, pang kamaar a taamaan.” ");
INSERT INTO rai_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Namur Aabaraam i piri, “Tadaaru, koku u kaankaan karom iaau. Iaku ang wetiri balet raa pakaan maku. Baa ta noina taara ku un baat pa diat?” I baalui lenbi, “Baa ta noina ku, pang kamaar a taamaan.” ");
INSERT INTO rai_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Baa a Tadaaru ia pirpir raap ma Aabaraam, i waan. Ma Aabaraam kaai i waan talili balet kup anuna ruma. ");
INSERT INTO rai_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","U ra bung na maluraap ut maa, baa Lot i ki taau naa ra bonanaaka i ra taamaan Sodom, a ru aangelo diaar waan paat. Baa i babo pa diaar i waan baraata diaar ma i ki but keke taau ma ra mataana unapia. ");
INSERT INTO rai_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ma i piri lenbi, “Anung ru tadaaru, iaau anumur tultul. Datul a waan kup anung ruma, ma mur a gi paa a ru kakimur, ma mari u ra marum, mur a inep kumun naang. Io, u ra malaana mur a waan balet u ra numur winawaan.” A ru aangelo diaar baalui naa, “Pate, i koina ku, mir a inep ku min nataamaan umari u ra marum.” ");
INSERT INTO rai_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Iaku Lot i worwor pa diaar ut kup diaar a inep paa kumun u ra nuna ruma. Io, diaar taraam ma ditul ruk. Lot i waninaar paa andiaar winangaan, ungaai ma ra bred baa pa ta is uni, ma diaar aani. ");
INSERT INTO rai_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Baa pa diat inep utbaai, a kum muaana raap, a kum ngaalangaala ma ra kum baarmaan taanga matira u ra taamaan Sodom, diat waan paat ma diat tur lili paa a ruma anun Lot. ");
INSERT INTO rai_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Diat ge karom Lot naa, “Waiaa a ru muaana baa diaar waan paat karom ui mi ut u ra maluraap? Ben ta diaar urin, ma miaat a paam aakaina un diaar.” ");
INSERT INTO rai_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot i pari karom diat, ma i balbalaat a bobonaaka. ");
INSERT INTO rai_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ma i piri, “Pate, kum teptepaang, koku muaat paam aakaina mangamangaan maa. ");
INSERT INTO rai_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Baboi, a ru natnatung, a ru tauraara kuri, pa ta muaana utbaai i inep ungaai paa ma diaar. Ang ben pari ta diaar karom muaat, ma muaat a paam aawa maa muaat nem na paami un diaar. Iaku koku muaat paam ta utnaa karom a ru muaana bi, maa diaar ki u ra nung binaboura.” ");
INSERT INTO rai_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","A taara Sodom diat baalui ku naa, “Tur aara miaat!” Ma diat piri kaai lenbi, “A muaana mi Lot, a waira pi ku, ma mi i nemi naa in naagagon daat! Aakaina baa miaat a paami karom ui, in aaka aakit ko ra aakaina baa miaat a paami karom diaar.” Ma diat tul talili wa Lot unamur kup a balbalaat, ma marawaai diat a reng paa a balbalaat. ");
INSERT INTO rai_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Iaku a ru muaana diaar paapa ma diaar aal aruk paa balet Lot unaruma, ma diaar balbalaat balet. ");
INSERT INTO rai_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma diaar wapula a mataandiat baa diat tur naa ra bonanaaka, a kum ngaalangaala ma ra kum baarmaan, kupi koku diat babo paa a bonanaaka. ");
INSERT INTO rai_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","A ru muaana diaar piri karom Lot, “Baa te kon ui kuri min, ta nimum, ta kum natnatum a kum muaana baa a kum tabuan, ma baa ta kakum kaai kuri min u ra taamaan mi, un ben pari pa diat taanga min. ");
INSERT INTO rai_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Mir a kamaar wa ma a taamaan mi. A tinaangi na wetakun u ra taamaan mi i ngaala aakit, ma a Tadaaru ia walangoroi. Io, i tula wa mir kupi mir a kamaar wai.” ");
INSERT INTO rai_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Io, Lot i waan, ma i pirpir karom a ru nimnimuna baa di pet baat taa a ru natnatuna, a ru tabuan karom diaar. I piri taan diaar, “Mur tur gagaa, mur a pari ko ra taamaan mi, maa a Tadaaru in kamaar wai ma.” Iaku a ru nimnimuna diaar nuki naa i tataur ku. ");
INSERT INTO rai_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Baa ina laar i aali, a ru aangelo diaar wararaak Lot naa, “Aiaap gagaa, ben pari paa anum taulaa ungaai ma ru natnatum baa kuri diaar, kaduk muaat a wirua ungaai ma ra taamaan mi baa din kamaari.” ");
INSERT INTO rai_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Baa pa i taraam gagaa, a ru aangelo diaar paam paa a limaana, a limaa ra nuna tabuan, ma a ru limaa ra ru natnatuna. Ma diaar ben pari wakaak wa diat ku ko ra taamaan Sodom, maa a Tadaaru i maari aakit diat. ");
INSERT INTO rai_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Baa ku diat aa pari, raa ko ra ru aangelo i piri taan diat, “Muaat a welulu, muaat a nuk paa anumuaat lalaaun. Koku muaat babo talili balet ma koku muaat ngo un ta wanua naliwan u ra maale. Muaat a welulu kup a kum taangaai, kaduk muaat a wirua.” ");
INSERT INTO rai_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Iaku Lot i piri ku lenbi, “Painte, anung ru tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mur a maari iaau, anumur tultul, maa anumur koina mangamangaan karom iaau i ngaala aakit, baa mur walaaun pa iaau. Iaku pa i tale iaau baa ang welulu kup a kum taangaai, kaduk a winirua bi in um pa iaau ku naliwan ma ang maat. ");
INSERT INTO rai_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Baboi, a taamaan lik banaanga ku ia, i koina kupi ang kalaa taau iaai. Maadek wa iaau baa ang kalaa taau u ra naatnaat na taamaan lik manaanga kupi ang lalaaun.” ");
INSERT INTO rai_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","A aangelo i piri taana naa, “Io, unaanga. Iaau aa taraam u ra num nemnem. Iaau pang baanaakaka a taamaan lik baa u pirpir uni. ");
INSERT INTO rai_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Io, un kalaa gagaa kupi, maa iaau pang paam gagaa ta utnaa tuk baa u aa waan paat.” Di waatung a taamaan mi maa Soaar, kabina i kinalik aakit. ");
INSERT INTO rai_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","U ra pakaana bung baa Lot i waan ruk u ra taamaan Soaar, in mataana mage i waan paat. ");
INSERT INTO rai_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","A pakaana bung ut maa, a Tadaaru i taar pari wa a sulfaa baa i kupkup un Sodom ma Gomoraa. I waan pari welaar ma ina baata taanginaanga u ra maawa ko ra Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Io, i kamaar wa a ru taamaan, Sodom ma Gomoraa, ungaai ma ra kum taamaan liklik u ra maale maa, ma ra taara raap baa diat lalaaun matira. Ma i kamaar wa kaai a diwadiwaai liklik raap. ");
INSERT INTO rai_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Iaku a tabuan anun Lot i babo talili, ma u ra pakaana bung ut maa a panina i tapuku, ma i tur takum welaar ma ra toro na sol. ");
INSERT INTO rai_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","U ra bung namur taana, u ra malaana, Aabaraam i tur paa ma i waan kup a wanua baa diaar tur paa mun iaai ma ra Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Aabaraam i babo pari kup Sodom ma Gomoraa ma kup a maale maa. I babo a ngaala na tubal i tur ko ra pia, i welaar ma ra tubal i ra ngaala na nguan pi. ");
INSERT INTO rai_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Io, baa God i kamaar wa a kum taamtaamaan u ra maale maa, i nuk paa Aabaraam. Ma i ben pari paa Lot ma i walaaun paai. Iaku ia kamaar wa ut a kum taamtaamaan baa Lot i ki uni. ");
INSERT INTO rai_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot i burut baa i ki liklik irong Soaar ma i ben paa ru natnatuna a ru tabuan, ma ditul ki inaanga u ra kum taangaai. Ditul lalaaun un raa maata na waat. ");
INSERT INTO rai_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Raa bung a ru natnatun Lot, a ru tabuan, diaar wepaak paa. A mugaana i piri taa ra murmurina naa, “A tamaandaar ia takaana. Ma u ra kum wanua raap u ra rakrakaan buaal a tabuan ma ra muaana diaar taulaa, iaku pa ta muaana kuri baa daar a taulaa mai. ");
INSERT INTO rai_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Daar a wainim taa tamaandaar ma ra waain kupi in sipaak, ma daar a inep ungaai mai, kupi daar a babuta taau uni, kupi anundaat taara koku i raap.” ");
INSERT INTO rai_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","U ra marum, a ru tabuan diaar wainim alonglong taa a tamaandiaar, io a mugaana i waan ma i inep ungaai mai. Iaku Lot pa i nunura natuna baa i inep ungaai paa mai, ma baa i tur balet koni. ");
INSERT INTO rai_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","U ra bung namur, a mugaana i piri taa ra murmurina naa, “Nabari iaau inep ungaai ma tamaandaar. Mari u ra marum daar a wainim alonglong taai balet, kupi ui bulung un inep ungaai mai, ma u ra mangamangaan mi daar a warwangaala taau un tamaandaar, kupi anundaat taara koku i raap.” ");
INSERT INTO rai_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Io, u ra bung na marum maa, diaar wainim alonglong taa balet a tamaandiaar ma ra waain, io a murmurina bulung i waan ma i inep ungaai ma tamaana. Ma i lenutmaa, Lot pa i nunura raa natuna bulung baa i inep ungaai mai, ma baa i tur balet koni. ");
INSERT INTO rai_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Io, a ru natun Lot raap diaar kipbaala taau un tamaandiaar. ");
INSERT INTO rai_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","A mugaana i buta paa a naat muaana, ma i taar taa a iaana baa Moaab. Moaab a tabu ra taara Moaab baa diat lalaaun tuk umari. ");
INSERT INTO rai_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A murmur na natun Lot i buta paa kaai raa naat muaana ma i taar taa iaana baa Ben-Aami. Ben-Aami a tabu ra taara Aamon baa diat lalaaun tuk umari. ");
INSERT INTO rai_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aabaraam i waan ko ra taamaan Maamre ma i waan kup a papaar Negeb, i ki kinalik paa naliwan taa ra ru taamaan Kaades ma Sur, ma namur i kakaraai kup a taamaan Geraar. ");
INSERT INTO rai_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Aabaraam i wapua a taara un Saaraa, anuna taulaa, naa diaar tenalik. Baa Aabimelek, a king ko ra taamaan maa, i walangoroi, i wetulaa paa Saaraa kupi anuna tabuan. ");
INSERT INTO rai_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Iaku God i waan paat karom Aabimelek un raa bung na marum u ra beberon, ma i piri taana naa, “Un maat, maa a tabuan baa u ben paai a tinaulaa na tabuan.” ");
INSERT INTO rai_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Iaku Aabimelek pa i inep ungaai utbaai mai, io, i piri naa, “Tadaaru, lelawaai, un kamaar wa ma anung taara mi? Maa pa iaau nunura anung ta aakaina. ");
INSERT INTO rai_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Aabaraam ut i wapua iaau naa a tabuan mi diaar tenalik. Ma a tabuan kaai i piri naa diaar tenalik ma Aabaraam. Pa iaau raara, iaau nuki naa iaau paam ut a takado na pinapaam.” ");
INSERT INTO rai_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ma God i piri balet karom Aabimelek u ra beberon naa, “Maia, iaau nunurai naa u paam a utnaa mi ma ra koina ninunuk, ma pa iaau maadek ta ui kupi un paam a utnaa baa pa i takado na mataang. Io, iaau tur baat ui kupi koku u inep ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Un tula talili wai balet karom Aabaraam, maa anuna taulaa ut. Maa Aabaraam a propet, ma baa in aaraaring un ui, un lalaaun. Ma baa pa un tula talili wai, un maat, muaat raap ma ra num taara.” ");
INSERT INTO rai_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","U ra malaana kinalik, Aabimelek i wataa raap paa anuna kum mukmuga ma i wapua diat u ra kum utnaa raap baa ia babo taai u ra beberon, ma diat burut aakit uni. ");
INSERT INTO rai_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ma Aabimelek i wataa paa Aabaraam ma i piri taana naa, “Aawa mi u paami un miaat? Ma aawa maa miaat paam aaka taai karom ui, baa u lo taa a mawaat mi urin karom iaau ma ra nung mataanitu? U aa paam taa raa aakaina mangamangaan karom iaau baa pa i takado kupi din paami. ");
INSERT INTO rai_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Aawa maa i pet ta ui kupi un paami lenmi?” ");
INSERT INTO rai_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ma Aabaraam i baalui naa, “Iaau nuki naa pa te kuri u ra taamaan mi i urur karom God, ma iaau nuki kaai naa kaduk te in aak doko wa iaau ma in ben paa Saaraa. ");
INSERT INTO rai_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","I dowot ut baa mir tenalik, maa raa tamaamir ku, iaku Saaraa raa naana ut, iaau kaai raa naang ut. Ma mir taulaa. ");
INSERT INTO rai_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","God i piri naa ang waan ko ra taamaan anun tamaang ma ang waan taltalili u ra kum wanua. Baa iaau paami lenmaa, iaau wapua Saaraa naa, ‘Baa u maari iaau, un wapua a taara u ra kum taamtaamaan raap baa daar waan paat iaai, naa iaau temlik.’” ");
INSERT INTO rai_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ma Aabimelek i tabaara Aabaraam ma ra kum sip, a kum bulumakaau, ma ra kum tultul, in muaana ma ra in tabuan. Ma i tula taa balet kaai Saaraa karom Aabaraam anuna muaana. ");
INSERT INTO rai_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Aabimelek i piri kaai naa, “Baboi, anung pia raap ku maa namuga taam, ma un ki un woi na pakaana baa u nemi.” ");
INSERT INTO rai_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ma i piri kaai karom Saaraa naa, “Ang taar taa raa aarip na pakaana silwa karom Aabaraam temlik. Ang paami lenmi kup a winekul i ra nung niraara, kupi a taara raap kaai diat a nunurai naa ui pa anum ta niraara.” ");
INSERT INTO rai_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ma Aabaraam i aaraaring karom God, ma God i walaangalaanga paa Aabimelek, ma i walaangalaanga paa kaai anuna tabuan, ma anuna kum tultul na tabuan, kupi diat a babuta balet. ");
INSERT INTO rai_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Maa kabina un Saaraa, a tabuan anun Aabaraam, a Tadaaru i balbalaat baat wa a balaara kum tabuan raap baa diat ki u ra ruma anun Aabimelek, kupi koku diat babuta. ");
INSERT INTO rai_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","A Tadaaru i wagaaia Saaraa lenutmaa ia pir taai, ma aawa baa a ia weweliman taai karomi, i paam ot paai ut. ");
INSERT INTO rai_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saaraa i kipbaala ma i buta paa a naat muaana u ra kilaala baa Aabaraam ia takaana. I babuta ut u ra pakaana bung baa God i weweliman taai. ");
INSERT INTO rai_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aabaraam i waatung taa a iaa ra naat muaana baa Saaraa i buta paai naa Aaisaak. ");
INSERT INTO rai_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Baa i 8 na bung anun Aaisaak, Aabaraam i poko kikili, welaar ma God ia pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","A kilaala na lalaaun anun Aabaraam i welaar ma 100 baa di buta taa Aaisaak uni. ");
INSERT INTO rai_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saaraa i piri naa, “God ia taar taa a utnaa na ninangon karom iaau, ma a taara raap baa diat a walangoro a utnaa mi diat a nangon ungaai ma iaau.” ");
INSERT INTO rai_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma i piri kaai lenbi, “Baa pa iaau babuta utbaai, woi maa in piri taan Aabaraam naa Saaraa in wangaau a naat? Iaku mi, iaau aa buta taa a naat uni, baa ia takaana.” ");
INSERT INTO rai_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aaisaak i ngaala waanwaan, ma baa ia paki wa in tu, Aabaraam i paam a ngaala na lukaara uni. ");
INSERT INTO rai_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Iaku, Saaraa i babo paa Ismaael i tataur. Ismaael a natun Aagaar a tabuan Aaigipto, baa i buta taai un Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ma Saaraa i piri taan Aabaraam, “Un tula wa a tultul na tabuan mi, ungaai ma natunalik, maa natu ra tabuan na tultul maa, pain kakale ungaai ma natunglik u ra num kum utnaa.” ");
INSERT INTO rai_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Aabaraam i tapunuk dekdek aakit u ra pirpir mi, kabina Ismaael a natunalik utkaai. ");
INSERT INTO rai_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Iaku God i piri karomi naa, “Koku u tapunuk un natumlik ungaai ma ra num tultul na tabuan. Un walangoro ku aawa baa Saaraa i piri taam, maa un Aaisaak ku anum wuna taara diat a waan paat welaar ma ra nung weweliman. ");
INSERT INTO rai_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Iaau ang paam apaat a ngaala na wuna taara ko ra natu ra tultul na tabuan kaai, kabina maa ia natumlik.” ");
INSERT INTO rai_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","U ra bung namur taana u ra malaana, Aabaraam i lo paa a kum utnaa na winangaan, ma ra palaa baa di labo taai u ra in palaa di paami ko ra panina wewagua, ma i ung taai u ra pupuakin Aagaar. Namur i tula wa dinaana. Aagaar dinaana diaar waan waanwaan u ra bil na wanua, a iaana Ber-Sebaa. ");
INSERT INTO rai_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Baa andiaar palaa na ininim ia raap, Aagaar i waki taa a naat natudaangi ra in naatnaat na diwaai. ");
INSERT INTO rai_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ma i waan welwelik kinalik, ma i ki pari taau ma i nuknuk naa, “Pa iaau nem na babo a naat baa in maat.” Ma baa i ki matira i tur paa tinaangi. ");
INSERT INTO rai_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God i walangoro a naat i taangi, ma aangelo anun God i wataa Aagaar taanginaanga u ra maawa, ma i piri taana naa, “Aagaar, u lawaai maa? Koku u burut. God ia walangoro a tinaangi anu ra num naat barong i inep taau. ");
INSERT INTO rai_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Waan urong, ma un aal atur paa a naat, ma un taal paai ma ra limaam. Ma iaau ut ang wangaala a taara baa diat a waan paat koni, kupi diat a waan paat a ngaala na wuna taara.” ");
INSERT INTO rai_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","God i palaa a mataan Aagaar, ma i babo paa a daanim. Io, i waan ma i itup paa andiaar in palaa, ma i wainim taa a naat. ");
INSERT INTO rai_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Baa a naat i ngaala waanwaan, God i ki ungaai mai. I lalaaun u ra bil, ma i laa aakit u ra papanaak ma ra bunaaraa. ");
INSERT INTO rai_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Baa i ki matira u ra bil irong Paaraan, naana i ben paa raa tabuan taangirong Aaigipto karom natuna Ismaael. ");
INSERT INTO rai_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Un raa bung, king Aabimelek ma Pikol a mukmuga anu ra taara na wineium anun Aabimelek, diaar piri taan Aabaraam lenbi, “God i ki ungaai ma ui u ra kum utnaa raap baa u paami. ");
INSERT INTO rai_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Mi un weweliman karom iaau namataan God, naa koku u papaam na warwaruga karom iaau, baa karom a kum natnatung ma ra kum taptabung. Un waiaa anum koina mangamangaan karom iaau ma karom a taamaan mi u ki na waira uni, lenutmaa iaau aa paam taai mun karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aabaraam i piri naa, “Iaau weweliman naa ang paami lenmaa karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ma Aabaraam i pirpir na uraai karom Aabimelek u ra daanim baa a kum tultul anun Aabimelek diat raa paai koni. ");
INSERT INTO rai_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Iaku Aabimelek i piri naa, “Pa iaau nunura woi ma i paam a pinapaam maa. Pa u wapua iaau uni, telek mi iaau walangoroi.” ");
INSERT INTO rai_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Io, Aabaraam i lo paa a kum sip, ma ra kum bulumakaau ma i taar taai taan Aabimelek, maa diaar paam a kunubu. ");
INSERT INTO rai_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Io, Aabaraam i weraana 7 na naatnaat na tabuan na sip ko ra nuna kum sip. ");
INSERT INTO rai_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ma Aabimelek i tiri naa, “Aawa kabina maa u watur ingen wa 7 na naat na sip bi?” ");
INSERT INTO rai_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Aabaraam i baalui naa, “Un gaaia paa 7 na naat na sip bi ko ra limaang, welaar ma ra nung wewapua kaapa naa iaau, iaau kil a daanim mi.” ");
INSERT INTO rai_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Io, a iaa ra wanua maa, Ber-Sebaa, kabina maa a ru muaana mi diaar paam a weweliman matira. ");
INSERT INTO rai_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Baa diaar aa paam taa a kunubu matira Ber-Sebaa, Aabimelek ma Pikol, a mukmuga anu ra taara na wineium anun Aabimelek, diaar waan talili balet urong Pilistia. ");
INSERT INTO rai_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aabaraam i maarut taa in diwaai, di waatungi baa taamaariska irong Ber-Sebaa, ma matira i aaraaring karom a Tadaaru, a God baa i lalaaun takum. ");
INSERT INTO rai_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ma Aabaraam i ki iwan irong Pilistia. ");
INSERT INTO rai_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Namur taa ra kum utnaa mi, God i walaar Aabaraam. Ma i wataai naa, “Aabaraam!” Io, Aabaraam i baalui naa, “Mi ut iaau.” ");
INSERT INTO rai_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Io, God i piri lenbi, “Ben paa natumlik Aaisaak, raa natum ku, baa u nemnem aakiti, ma mur a waan urong u ra papaar Moria. Un aak doko paa Aaisaak ma un tuni welaar ma ra wetabaar karom iaau, u ra taangaai baa iaau ut ang pir taai taam.” ");
INSERT INTO rai_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","U ra bung namur taana, u ra malaana kinalik, Aabaraam i tawaangun ma i waninaar paa anuna dongki. Ma i ben paa kaai anuna ru tultul ma natunalik Aaisaak. Ma baa i woto paa anuna kewe na diwaai kup a tun wetabaar, diat turpaa winawaan kup a wanua baa God ia pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","U ra wetula bung baa Aabaraam i babo kado urong namuga, i babo paa a wanua baa diat waan kupi, i welwelik utbaai. ");
INSERT INTO rai_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Aabaraam i piri karom anuna ru tultul naa, “Mur a ki ut min, mutul ma ra dongki. Mir ma Aaisaak, mir a waan ubarong ma mir a lotu, ma namur mir a waan talili balet urin.” ");
INSERT INTO rai_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aabaraam i lo paa a kewe na diwaai, baa in tun wetabaar mai, ma i ung taai nate u ra pupuakin Aaisaak, ma ia ut i lo a nguan ma ra in liwan, ma diaar waan. ");
INSERT INTO rai_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Baa diaar waan waanwaan, Aaisaak i tiri tamaana naa, “Tataa?” Ma Aabaraam i baalui, “Aawa, natunglik?” Aaisaak i piri taana naa, “A nguan ma ra diwaai bi ut ia, iaku waiaa a sip baa din tun wetabaar mai?” ");
INSERT INTO rai_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aabaraam i baalui naa, “God ut in taar ta sip baa din tun wetabaar mai.” Io, diaar waan balet. ");
INSERT INTO rai_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Baa diaar aa tuk paa a wanua baa God ia pir taai taana, Aabaraam i paam paa wunuwung na waat na tuntun wetabaar, ma i ung taa a diwaai nate uni. Ma i paam paa Aaisaak, ma i wi paai ma i wainep taai nate u ra wunuwung na waat, nate u ra kum diwaai. ");
INSERT INTO rai_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Io, Aabaraam i rakaan paa in liwan kupi in go doko natunalik mai. ");
INSERT INTO rai_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Iaku, a aangelo anu ra Tadaaru i wewataai karomi taanginaanga u ra maawa lenbi, “Aabaraam! Aabaraam!” Ma i baalui naa, “Mi ut iaau.” ");
INSERT INTO rai_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ma a aangelo i piri lenbi, “Koku u aak doko a natumlik. Koku u paam ta utnaa uni, ma mi iaau nunurai naa u urur karom God, maa pa u maari baat natumlik, anum kapuaana naat, koni.” ");
INSERT INTO rai_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aabaraam i babo kado, ma i babo paa a muaana na sip a komina i kaai taau u ra kum buaal. Aabaraam i waan karomi, i lo paai ma i tun wetabaar mai karom a Tadaaru. A sip maa i lo a kolo anun natunalik. ");
INSERT INTO rai_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Io, Aabaraam i waatung taa a wanua maa baa “A Tadaaru in wetabaar.” Ma tuk u ra kum bung mi, a taara diat piri utbaai, baa “A Tadaaru in wetabaar u ra nuna taangaai.” ");
INSERT INTO rai_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","I weru pakaan a aangelo anu ra Tadaaru i wewataai balet karom Aabaraam taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Ma i piri naa, “Iaau a Tadaaru mi iaau pirpir, iaau paam anung weweliman u ra iaang, naa ang wadaan ui. Ang wadaan ui kabina maa u paam a utnaa mi, ma wakir u paam koto natumlik, a kapuaana naat, kon iaau. ");
INSERT INTO rai_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ang wadaan mulu ui, ma ang wabure anum wuna taara kupi diat a bure welaar ma ra naangnaang inaanga nate, ma welaar kaai ma ra woio taanga nakono. Anum wuna taara diat a lo a kum taamtaamaan ko ra nundiat kum ebaar. ");
INSERT INTO rai_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","U ra num wuna taara ku, a kum wunwuna taara raap u ra rakrakaan buaal din wadaan diat, kabina u taraam karom iaau.” ");
INSERT INTO rai_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Io, Aabaraam diaar tamaana diaar waan talili balet kup anuna ru tultul, ma diat waan talili balet urong Ber-Sebaa, baa Aabaraam i ki iaai. ");
INSERT INTO rai_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Namur di wapua Aabaraam naa, “Milka kaai ia taulaa. Ia babuta taau un temlik Naaor.” ");
INSERT INTO rai_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Bi diat a kum natnatun Naaor: Us, a mugaana, Bus, a tein Us, Kemuel, ia baa tamaan Aaraam, ");
INSERT INTO rai_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Aaso, Pildaas, Gidlaap ma Betuel. ");
INSERT INTO rai_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ma Betuel ia a tamaan Rebekaa. Milka i buta taa 8 na naat muaana mi un Naaor, a tein Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Raa tabuan kaai anun Naaor, a iaana baa Reumaa, ia kaai i babuta un Naaor. I buta a kum naat muaana, ma bi a kum iaandiat: Tebaa, Gaam, Taaraas ma Maakaa. ");
INSERT INTO rai_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saaraa i lalaaun paa 127 na kilaala. ");
INSERT INTO rai_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ma namur i maat, ma Aabaraam i waan ma ra tapunuk kupi in babo taa minaatin Saaraa, ma in luani. Saaraa i maat irong Kiriaat-Aarbaa, baa di waatungi kaai baa Ebron u ra pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ma Aabaraam i tur paa ko ra minaatin Saaraa, ma i waan ma i piri karom a kum taara Ket naa, ");
INSERT INTO rai_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Iaau a waira ku naliwan taamuaat, muaat a wiura iaau un ta pakaana pia ma ta maata na waat, baa ang waruk taa a minaat i ra nung tabuan iaai.” ");
INSERT INTO rai_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","A taara Ket diat baalui naa, ");
INSERT INTO rai_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tadaaru, un walangoro miaat. Ui a ngaala na mukmuga naliwan taamiaat, waruk taa a minaat un ta koina maata na waat, pa te kon miaat in patut ta maata na waat taam.” ");
INSERT INTO rai_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ma Aabaraam i tur ma i pun pari namuga taan diat a taara Ket, baa anundiat pia maa. ");
INSERT INTO rai_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Aabaraam i piri karom diat, “Baa muaat aa taraam ta iaau kupi ang waruk taa anung tabuan min un ta maata, io, muaat a walangoro iaau. Muaat a wapua Epron, natun Soaar, u ra nung nemnem, ");
INSERT INTO rai_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kupi in taar taa a maata na waat baa di waatungi naa Maakpelaa, baa kurong ut u ra tuktuki ra nuna pakaana pia. Muaat a tiri uni kupi in wiurai karom iaau, ma ang kuli ma ra kudulaana winekulina namataamuaat, kupi a maata na waat maa anung ma.” ");
INSERT INTO rai_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Epron a te Ket, i ki taau naliwan naa ra nuna taara baa diat walangoro Aabaraam. Epron i baalu Aabaraam namataa ra taara Ket, baa diat ki ungaai mai naa ra bonanaaka i ra taamaan. ");
INSERT INTO rai_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","I piri naa, “Koku, anung tadaaru. Un walangoro iaau, ang taar taa a pia taam ma ra maata na waat. Iaau taari taam namataa ra nung taara. Un waruk ku a minaat uni.” ");
INSERT INTO rai_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Raa pakaan balet Aabaraam i pun pari ma ra urur namuga namataa ra taara baa anundiat pia. ");
INSERT INTO rai_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ma namataa ra taara i piri karom Epron naa, “Walangoro iaau. Mi ang kul a pakaana pia kon ui. Un taraam paa a winekulina, ma ang waruk taa anung tabuan iaai.” ");
INSERT INTO rai_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron i baalu Aabaraam, ");
INSERT INTO rai_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Walangoro iaau, anung tadaaru. A pia maa din kuli ma 400 na pakpakaana silwa, iaku 400 maa a ling biaa ku naliwan taan daar. Un waruk ku anum tabuan.” ");
INSERT INTO rai_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aabaraam i taraam u ra pirpir anun Epron, ma i taar taa taiaadi baa Epron ia waatung taai namataa ra taara Ket, 400 na pakpakaana silwa, a mawaatin raaraa pakaana silwa i welaar ut ma ra mataa ra silwa baa a taara diat laana kukul mai. ");
INSERT INTO rai_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Io, a pia ma ra maata na waat anun Epron irong Maakpelaa marawaai Maamre, ungaai ma ra kum diwaai raap baa diat tawa matira, i wiura wai ");
INSERT INTO rai_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","karom Aabaraam, kupi anuna ma, namataa ra taara Ket, baa diat waan paat ungaai matira naa ra bonanaaka i ra taamaan. ");
INSERT INTO rai_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Namur Aabaraam i waruk taa a minaat in Saaraa, anuna tabuan, u ra maata na waat u ra pia Maakpelaa, marawaai Maamre baa di waatungi kaai baa Ebron, u ra pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Io, a pia ma ra maata na waat maa, a taara Ket diat wiura wai karom Aabaraam kupi anuna taamaan na minaat ma. ");
INSERT INTO rai_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aabaraam ia takaana aakaka, ma a Tadaaru i wadaani u ra kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Aabaraam i pirpir karom a mukmuga anu ra nuna kum tultul, baa i naagagon a kum utnaa raap u ra nuna ruma. I piri lenbi, “Ung pari a limaam naatudungi ra paraagum na kaking. ");
INSERT INTO rai_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Iaau nemi naa un weweliman u ra iaa ra Tadaaru, a God baa i naagagon a maawa ma ra rakrakaan buaal, naa koku u ben paa ta tabuan anu ra nung naat ko ra kum tabuan taanga min Kaanaan, baa kuri iaau ki naliwan taan diat. ");
INSERT INTO rai_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Iaku un waan kup anung taara kurong u ra nung taamaan ma un ben paa ta tabuan anun Aaisaak.” ");
INSERT INTO rai_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A tultul i tiri Aabaraam, “Lelawaai baa a tabuan maa pa in taraam kupi in waan ungaai ma iaau urin, in koina ku baa ang ben ut natumlik Aaisaak kup a taamaan baa u waan taanga iaai?” ");
INSERT INTO rai_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aabaraam i piri, “Koku! Koku u ben anung naat urong. ");
INSERT INTO rai_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","A Tadaaru, a God taanga u ra maawa, baa i ben pari pa iaau ko ra kum kakung, ma ko ra pia anumiaat, ma i pirpir karom iaau, ia ut maa i weweliman taau karom iaau lenbi, ‘Iaau ang taar a pia bi karom anum wuna taara namur.’ A Tadaaru ut in tula wa anuna aangelo in muga taam, kupi un ben paa ta tabuan anu ra nung naat taanga matira. ");
INSERT INTO rai_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Baa a tabuan in patut ku kupi in waan talili ungaai ma ui, io u aa laangalaanga ko ra weweliman mi. Iaku, koku u benben taa natung lik urong.” ");
INSERT INTO rai_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Io, a tultul i ung a limaana naatudaangi ra paraagum na kakin Aabaraam, anuna ngaala, ma i weweliman, murmur a pirpir Aabaraam i pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Namur a tultul i ben paa noina kaamel ungaai ma ra kum wakwakaak na utnaa na wetabaar ko ra nuna ngaala, ma i waan kup Mesopotaamia. Ma i waan paat u ra taamaan anun Naaor. ");
INSERT INTO rai_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Baa i waan paat matira, i watur taa a kum kaamel naa ra daanim marawaai naa ra taamaan. I waan paat u ra maluraap, u ra pakaana bung baa in tabuan diat laana waan na itup palaa. ");
INSERT INTO rai_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ma i aaraaring lenbi, “Tadaaru, a God anu ra nung ngaala Aabaraam, a bung mi un walingtatuna anung winawaan urin. Un maari anung ngaala Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Baboi, iaau tur marawaai naa ra daanim, ma ra kum tauraara ko ra taamaan mi, diat a waan pari kupi diat a itup palaa. ");
INSERT INTO rai_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Baa ang piri karom te kon diat a kum tauraara naa, ‘Maari iaau, un itup paa anum in palaa ma un wainim ta iaau,’ ma a tauraara maa in piri karom iaau naa, ‘Inim paa, ma iaau ang wainim taa anum kum kaamel kaai,’ io, maa ut ia a tauraara maa u aa pilak paai kup anum tultul Aaisaak. Ma ang nunurai kaai naa u maari anung ngaala, Aabaraam.” ");
INSERT INTO rai_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Baa kuraa utbaai i aaraaring, Rebekaa i waan pari ko ra taamaan ma ra nuna in palaa na initup u ra pupuakina. Rebekaa a natun Betuel, ma Betuel a natun Milka ma Naaor baa dina ma Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A tabuan mi Rebekaa a gaugauwen na tabuan, ma a tauraara kubaai, pa i inep ungaai paa utbaai ma ta muaana. I waan pari kup a daanim, ma i itup paa anuna in palaa, ma namur i waan tato balet. ");
INSERT INTO rai_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","A tultul anun Aabaraam i kalaa karom Rebekaa ma i piri taana naa, “Maari iaau, iaau nem ta lik palaa ko ra num in palaa.” ");
INSERT INTO rai_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekaa i tur ma i rakaan pari gagaa ain palaa ko ra pupuakina ma i piri taana, “Inim, anung tadaaru.” Ma i wainimi ma ra palaa. ");
INSERT INTO rai_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Namur baa ia inim paa, Rebekaa i piri taana naa, “Ang itup taa kaai ta palaa ara num kum kaamel, tuk diat a maaur.” ");
INSERT INTO rai_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ma i langer gagaa wa mun a palaa baa i taana u ra in palaa u ra utnaa na ininim ara kum kaamel, ma i kalaa pari, i itup palaa balet ko ra daanim tuk i wainim raap taa a kum kaamel. ");
INSERT INTO rai_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Pa ta magil i ra tultul, i babo urura ku Rebekaa u ra kum utnaa raap baa i paami, maa i nemi naa in kaapa baa a Tadaaru in walingtatuna anuna winawaan baa pate. ");
INSERT INTO rai_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Namur baa a kum kaamel diat aa inim raap, a tultul anun Aabaraam i lo paa a ring ko ra ngirngirondi, di paami ko ra goled, a mawaatina i welaar ma 5 na grem, ma i taar taai taana. Ma i taar taa kaai ru tabaara, di paami kaai ko ra goled. Raaraain tabaara, a mawaatina i welaar ma 100 na grem. ");
INSERT INTO rai_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","24","Ma i tiri Rebekaa naa, “Ui a natun woi?” Rebekaa i baalui naa, “Tamaang Betuel, baa a natun Milka ma Naaor.” Ma a tultul i tiri balet naa, “Pa ta pakaana kuaa u ra ruma anun tamaam, kup miaat a ngo paa iaai mari u ra marum?” ");
INSERT INTO rai_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ma Rebekaa i baalui naa, “A pakaana i ki ut kupi muaat a ngo paa iaai mari u ra marum, ma a kura kup a ininep anu ra kum kaamel, ma ra andiat utnaa i teng.” ");
INSERT INTO rai_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","A tultul maa i ki but keke ma i lotu karom a Tadaaru. I piri naa, ");
INSERT INTO rai_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“A pir walaawa karom a Tadaaru, a God anu ra nung ngaala Aabaraam. A Tadaaru pa i patut baat anuna koina mangamangaan ko ra nung ngaala, ma pa i dumaana wa anuna weweliman. A Tadaaru ia muga ta iaau u ra aakapi karom a ruma anu ra wuna taara anu ra nung ngaala.” ");
INSERT INTO rai_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebekaa i kalaa uaa karom a taara u ra ruma anun naana ma i wewapua u ra kum utnaa raap baa i waan paat. ");
INSERT INTO rai_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Raa tein Rebekaa a iaana Lebaan i walangoro taa a kum utnaa baa Rebekaa i wewapua uni, ma i babo paa kaai a ring baa i kete u ra ngirngirono ma ru tabaara baa i taana u ra ru limaana. Lebaan i welulu pari aakit ku, kup a muaana maa. I welulu taau uni kuaa ut i tur taau naa ra kum kaamel marawaai naa ra papaara daanim. ");
INSERT INTO rai_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lebaan i piri karomi naa, “Le, waan urin. A Tadaaru ia wadaan ta ui. Lelawaai maa u tur ku min nataamaan? A ruma iaau aa waninaar taai, ma ra wanua kaai anu ra kum kaamel baa diat a inep iaai.” ");
INSERT INTO rai_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","A tultul anun Aabaraam i waan tato unaanga u ra ruma. Lebaan i tula taa a kum tultul kupi diat a wapari raap wa a kum utnaa ko ra kum kaamel, ma namur diat a tabaara ta diat ma ra andiat utnaa na winangaan, ma ra kura kupi diat a inep uni. Io, baa diat aa tabaara raap taa a kum kaamel, diat lo paa palaa ma diat gi a kum kaki ra kum tultul anun Aabaraam mai. ");
INSERT INTO rai_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Namur diat ruk unaruma ma di waninaar andiat utnaa na winangaan. Io, baa diat ki na winangaan, a tultul anun Aabaraam i piri lenbi, “Iaau pang wangaan utbaai, tuk ang wewapua taau u ra utnaa baa iaau waan urin kupi.” Lebaan i piri taana, “Io, wapua miaat ma.” ");
INSERT INTO rai_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","I piri naa, “Iaau a tultul anun Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","A Tadaaru i wadaan anung ngaala u ra kum utnaa raap, ma ia a tadaaru na muaana. A Tadaaru i tabaarai ma ra kum sip, a kum bulumakaau, a silwa ma ra goled, a kum tultul na muaana ma ra kum tultul na tabuan, a kum kaamel ma a kum dongki. ");
INSERT INTO rai_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saaraa, a taulaa anu ra nung ngaala, i babuta baa ia takaana. I buta paa raa naat muaana. Io, anung ngaala i taar araap taa kum utnaa raap baa i naagagoni karom natunalik. ");
INSERT INTO rai_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Anung ngaala i aaring iaau kupi ang weweliman karomi, ma i piri lenbi naa, ‘Koku u ben paa ta tabuan karom anung naat, ko ra kum tabuan taanga min Kaanaan, ko ra pia mi iaau ki uni. ");
INSERT INTO rai_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Iaku, un waan talili kup a kum natnatun tamaang ma nung aapik na taara, ma un ben paa ta tabuan anu ra nung naat.’ ");
INSERT INTO rai_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Iaau baalu anung ngaala lenbi, ‘In pet lelawaai baa a tabuan maa pa in waan ungaai ma iaau?’ ");
INSERT INTO rai_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Iaku, i piri naa, ‘A Tadaaru baa iaau tartaraam karomi, in tula wa anuna aangelo ungaai ma ui, ma in walingtatuna anum winawaan, kupi un ben paa ta tabuan karom natunglik ko ra taara anun tamaang, ko ra nung aapik na taara. ");
INSERT INTO rai_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Baa un waan karom anung aapik na taara, io un laangalaanga ko ra num weweliman. Ma baa pain diat a taar ta tabuan kupi anung naat in taulaa mai, io un laangalaanga kaai ko ra num weweliman.’ ");
INSERT INTO rai_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mi ut u ra maluraap, baa iaau waan paat naa ra daanim, iaau aaraaring lenbi, ‘Tadaaru, a God anu ra nung ngaala Aabaraam, baa u taraam, un maari iaau, ma un walingtatuna anung winawaan urin. ");
INSERT INTO rai_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Baboi, kuri ma iaau tur naa ra papaara daanim, ma ang tur walaanga ta tauraara na tabuan baa in waan na initup. Ma ang piri taana naa, “Maari iaau. Un wainim iaau ma ta lik palaa ko ra num in palaa na initup.” ");
INSERT INTO rai_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ma baa a tabuan maa in piri karom iaau naa, “Inim, ma iaau ang itup paa kaai ta palaa ara kum kaamel,” io, u ra pinapaam mi ang nunurai naa a Tadaaru ia pilak paai kupi in taulaa ma natu ra nung ngaala.’ ");
INSERT INTO rai_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Baa kuraa utbaai iaau aaraaring u ra nuknuking, Rebekaa i waan paat ma ra nuna in palaa na initup nate u ra pupuakina. Baa ia itup paa u ra daanim, iaau piri karomi naa, ‘Maari iaau. Tabaara iaau ma ta lik palaa.’ ");
INSERT INTO rai_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Aiaap gagaa ku, i ung pari in palaa ko ra pupuakina, ma i piri, ‘Un inim paa, ma namur ang wainim taa kaai anum kum kaamel.’ Iaau inim, ma Rebekaa i itup palaa ma i wainim a kum kaamel mai. ");
INSERT INTO rai_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Iaau tiri naa, ‘Ui a natun woi?’ Rebekaa i baalu iaau naa, ‘Iaau a natun Betuel, ma Betuel a natun Naaor ma Milka.’ Io, iaau ung taa ring u ra in ngirngirono ma ruin tabaara u ra ru limaana. ");
INSERT INTO rai_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ma iaau ki but keke ma iaau lotu karom a Tadaaru. Iaau pir walaawa paa Tadaaru a God anu ra nung ngaala Aabaraam baa ia u ra ta iaau u ra takado na aakapi, kupi ang ben paa tabu ra tei ra nung ngaala karom natuna. ");
INSERT INTO rai_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Mi, baa muaat nem na waiaa a koina mangamangaan ma ra maarmaari karom anung ngaala, ma muaat mulaaot u ra nung pirpir, io, muaat a wapua iaau. Ma baa pate muaat a wapua iaau kaai, kupi ang nuknuk kup ta aakapi baa ang murmuri.” ");
INSERT INTO rai_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lebaan ma Betuel diaar baalui naa, “A utnaa mi i waan ko ra Tadaaru, pa mir a puku ta utnaa. ");
INSERT INTO rai_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Bi ia Rebekaa, un ben paai urong, kupi in taulaa ma natu ra num ngaala, welaar ut ma a Tadaaru ia muga ta ui kupi.” ");
INSERT INTO rai_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Baa a tultul anun Aabaraam i walangoro taa anundiaar pirpir, i ki but keke ma i lotu karom a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Namur i lo pari paa a kum utnaa na minong di paami ko ra goled ma ra silwa, ma ra kum kokoina maalu kaai ma i taar taai taan Rebekaa. I taar taa kaai raa kum ngaatngaat na utnaa karom naan Rebekaa ma tenalik Lebaan. ");
INSERT INTO rai_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Baa i taar raap taa a kum utnaa maa, io diat ma ra kum muaana baa diat weur, diat wangaan, diat inim ma namur diat inep. Baa diat tawaangun u ra malaana kinalik, a tultul anun Aabaraam i piri naa, “Muaat a tur tula wa miaat u ra numiaat winawaan kup anung ngaala.” ");
INSERT INTO rai_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Iaku, Lebaan ma naana diaar piri naa, “Rebekaa in ki paa balet ta noina bung, ma namur muaat a waan.” ");
INSERT INTO rai_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Iaku a tultul anun Aabaraam i baalu diaar naa, “Pang ki walaang balet. A Tadaaru ia walingtatuna taa anung winawaan ma mi muaat a maadek wa miaat baa miaat a waan kup anung ngaala.” ");
INSERT INTO rai_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ma diaar piri naa, “Daat a wataa paa Rebekaa ma daat a tiri u ra nuna nemnem.” ");
INSERT INTO rai_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Io, diaar wataa paa Rebekaa ma diaar tiri naa, “Lelawaai, mur a weur maut ungaai ma ra muaana mi?” I baalu diaar, “I koina ku, mir a weur maut.” ");
INSERT INTO rai_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Io, diat waninaar kupi diat a tula wa teindiat Rebekaa u ra nuna winawaan, ungaai ma ra tabuan baa i baboura Rebekaa tur paai baa i naat. Diat a waan ungaai ma ra tultul anun Aabaraam ma ra kum muaana baa diat patpataapi. ");
INSERT INTO rai_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ma a taara anun Rebekaa diat pir wadaani lenbi, “Teimiaat, un wabure aarip nate u ra aarip. Anum wuna taara diat a lo paa a kum taamaan anu ra nundiat kum ebaar.” ");
INSERT INTO rai_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekaa ma ra nuna kum tultul na tabuan diat waninaar paa, ma diat kaa u ra nundiat kum kaamel ma diat waan ungaai ma ra tultul anun Aabaraam ma ra nuna taara. ");
INSERT INTO rai_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ma Aaisaak i waan taangirong Biaar Laakaairoi, ma i lalaaun maku irong Negeb. ");
INSERT INTO rai_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Raa bung na maluraap i waan nabalaara ana pinapaam, ma i nuknuk. Ma baa i ong kado a mataana i babo paa a kum kaamel diat waan urin. ");
INSERT INTO rai_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekaa kaai i babo kado, ma i babo paa Aaisaak. I irok pari ko ra kaamel, ");
INSERT INTO rai_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ma i tiri a tultul anun Aabaraam naa, “Woi na muaana manaanga u ra pinapaam, mi i waan urin kupi in baraata daat?” A tultul anun Aabaraam i baalui naa “Anung ngaala manaanga.” Io, Rebekaa i aal baat paa a mataana ma ra pakaana maalu, baa i taana ut u ra in lorina. ");
INSERT INTO rai_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ma a tultul anun Aabaraam i wapua taa Aaisaak u ra kum utnaa raap baa i waan paat. ");
INSERT INTO rai_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Io, Aaisaak i ben aruk paa Rebekaa u ra ruma na sel anun naana Saaraa, ma diaar taulaa, ma Aaisaak i nem aakiti. Ma i ngo ko ra tapunuk u ra minaatin naana. ");
INSERT INTO rai_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aabaraam i taulaa balet ma raa tabuan a iaana Ketura. ");
INSERT INTO rai_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura i buta taa raa kum naat muaana uni. Bi ia a kum iaandiat: Simraan, Ioksaan, Medaan, Midian, Isbaak ma Suaa. ");
INSERT INTO rai_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ioksaan a tamaan Sebaa ma Dedaan. Dedaan i wangaala a taara Aasur, a taara Letus ma a taara Leum. ");
INSERT INTO rai_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","A kum natnatun Midian maa Epaa, Eper, Aanok, Aabidaa ma Eldaa. Diat raap mi diat waan paat kon Ketura. ");
INSERT INTO rai_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aabaraam i maadek raap taa anuna kum utnaa karom Aaisaak. ");
INSERT INTO rai_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Iaku, baa i lalaaun utbaai i taar a kum wetabaar karom a kum natnatu ra raa ru tabuan utkaai, ma i tula wa diat kon natunalik Aaisaak, kup a pia u ra papaara taubaar. ");
INSERT INTO rai_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","A niluluk i ra kum kilaala na lalaaun anun Aabaraam i welaar ma 175. ");
INSERT INTO rai_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Namur i ung wa anuna lalaaun, ma i maat wakaak u ra koina kilaala na takaana anuna. Ma ia raa takaana muaana i lalaaun mongoro na kilaala. Baa i maat, i ngo welaar ma ra nuna taara baa diat maat muga taana. ");
INSERT INTO rai_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ru natnatuna, Aaisaak ma Ismaael, diaar waruk taai u ra maata na waat di waatungi ma Maakpelaa marawaai Maamre, u ra pia anun Epron, a natun Soaar, a te Ket. ");
INSERT INTO rai_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","A pia baa Aabaraam ia kul paai ko ra taara Ket. Ma di waruk taa a minaat in Aabaraam u ra babaang baa a minaat in Saaraa anuna taulaa kuraa i inep iaai. ");
INSERT INTO rai_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Namur taa ra minaat in Aabaraam, God i wadaan natunalik Aaisaak, baa i lalaaun marawaai Biaar Laakaairoi. ");
INSERT INTO rai_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Bi ia a kum natnatun Ismaael, a natun Aabaraam, baa Aagaar, a tabuan Aaigipto, i buta taai uni. Aagaar a tultul na tabuan anun Saaraa. ");
INSERT INTO rai_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Bi ia a iaa ra kum natnatun Ismaael, a kum naat muaana. Di timu a kum iaandiat murmur ut anundiat binabuta, lenbi: Nibaaiot a mugaana, pataap Kedaar, Aatbel, Mibsaam, ");
INSERT INTO rai_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mismaa, Dumaa, Maasaa, ");
INSERT INTO rai_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Aadaad, Temaa, Ietur, Naapis ma Kedemaa. ");
INSERT INTO rai_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Diat raap mi, a kum natnatun Ismaael. Diat raap 12 mukmuga kon 12 wunwuna taara, ma ra kum iaandiat kaai a iaa ra 12 taamaan baa diat lalaaun iaai. ");
INSERT INTO rai_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","A niluluk raap u ra kilaala na lalaaun anun Ismaael i welaar ma 137, ma i ung wa nuna lalaaun. Baa i maat i ngo welaar ma ra nuna taara baa diat maat muga taana. ");
INSERT INTO rai_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Anuna wuna taara diat lalaaun u ra pia Aawilaa i waan tuk urong Sur, marawaai u ra laangun Aaigipto baa i waan kup Aasiria. Ma a wuna taara anun Ismaael diat ki na ebaar wetwetalaai karom diat balet ut. ");
INSERT INTO rai_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Bi ia aakaakur un Aaisaak, a natun Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Baa Aaisaak i 40 kilaala na lalaaun anuna i taulaa ma Rebekaa, tein Lebaan. Rebekaa a natun Betuel, a te Aaraam baa i ki u ra papaar Mesopotaamia. ");
INSERT INTO rai_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aaisaak i aaraaring karom a Tadaaru u ra nuna taulaa maa i bi. A Tadaaru i taraam u ra nuna niaaring ma Rebekaa i kipbaala paa a kataai. ");
INSERT INTO rai_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ma a ru naat diaar weium u ra in balaana, ma i piri naa, “Aawa kabina maa a utnaa mi i waan paat un iaau?” Ma i tiri a Tadaaru uni. ");
INSERT INTO rai_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","A Tadaaru i piri karomi naa, “A ru naat kuraa u ra in balaam, diaar a waan paat a ru wuna taara ma pain diaar a ki ungaai, raa wuna taara diat a dekdek kon raa wuna taara, ma a mugaana naat in papaam karom a murmur na naat.” ");
INSERT INTO rai_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Baa a bung i ot kupi in babuta, i buta paa a kataai, a ru naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A mugaana naat baa i buta wai, panina i taar, ma i weweu, welaar ma ra weweu na siot. Io diat waatung taa a iaana baa Esaau. ");
INSERT INTO rai_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Namur ku taana, Rebekaa i buta wa bulung a murmur na naat kuraa ut i paam akoto paa a kakin Esaau. Io, di waatung taa a iaana baa Iaakob. U ra kilaala baa Rebekaa i buta diaar, a kilaala na lalaaun anun Aaisaak i 60. ");
INSERT INTO rai_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","A ru naat diaar ngaala waanwaan, ma Esaau ia raa muaana baa i manaana aakit u ra nilebe, ma ia a tena winawaan taltalili u ra kum bil na wanua. Ma Iaakob a tena ki wowowon, i laana ki ku nataamaan. ");
INSERT INTO rai_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aaisaak i namene taa a kamanong i ra kum kuaabaar na wewagua baa Esaau i umum pa diat, ma raa ia a kabina baa i nemnem aakit Esaau. Iaku Rebekaa i nemnem aakit Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Raa bung baa Iaakob i tun a sup ko ra mangaana bin baa i taar, di waatungi naa lentil, Esaau i waan talili ko ra nilebe. A panina i bengbeng, maa i molo dekdek aakit. ");
INSERT INTO rai_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Io, i piri taan Iaakob, “Aai, iaau molo aakit. A ngaang ta utnaa ko ra taar na sup maa u tuni.” Maa ia a kabina baa di waatungi kaai ma Edom. ");
INSERT INTO rai_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma Iaakob i piri ku taan Esaau naa, “Un wiura muga wa anum kinkini na munuga karom iaau.” ");
INSERT INTO rai_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaau i baalui naa, “Baboi, marawaai ma ang maat ma ra minolo. Baa ang maat, anung kinkini na munuga in waraaut iaau lelawaai?” ");
INSERT INTO rai_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iaakob i piri balet taana naa, “Un weweliman muga taau mun karom iaau.” Io, Esaau i weweliman taau karom Iaakob, ma i wiura wa anuna kinkini na munuga karom Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Io, Iaakob i tabaara Esaau ma ra bred ma ra taar na sup. I wangaan ma i inim, namur i tur ma i waan. I nuki naa anuna kinkini na munuga a ling biaa ku. ");
INSERT INTO rai_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","A ngaala na minolo i waan paat u ra kudulaana pia maa. I welaar ma ra ngaala na minolo baa i waan paat namuga u ra kilaala baa Aabaraam i lalaaun. Ma Aaisaak i waan kup Aabimelek, a king anu ra taara Pilistia u ra taamaan Geraar. ");
INSERT INTO rai_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","A Tadaaru i waan paat karom Aaisaak ma i piri taana naa, “Koku u waan urong Aaigipto, un lalaaun ut u ra pia, baa ang piri naa un lalaaun iaai. ");
INSERT INTO rai_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Un ki kumun min u ra pia mi, ma iaau ang ki ungaai ma ui ma ang wadaan ui. Ma karom ui ma ra num wuna taara baa diat a waan paat namur taam, ang taar raap taa a pia mi. Ang paam ot paa ut a weweliman baa iaau weweliman taai karom tamaam Aabaraam. ");
INSERT INTO rai_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Iaau ang wabure a niluluk i ra num wuna taara baa diat a waan paat namur taam. Diat a bure welaar ma ra kum naangnaang inaanga nate, ma ang taar a raap taa a pia bi taan diat. Ma kabina u ra num wuna taara ang wadaan a kum wunwuna taara raap u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ang paami lenbi kabina un Aabaraam baa i taraam taang, ma i murmur anung kum wetulaa ma ra nung kum naagagon raap.” ");
INSERT INTO rai_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Io, Aaisaak i ki okot irong Geraar. ");
INSERT INTO rai_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Baa a taara taanga Geraar diat tiri Aaisaak u ra nuna taulaa, i baalu diat naa, “A tabuan mi mir tenalik.” I burut kupi in piri naa, “A tabuan mi anung taulaa.” I nuki lenbi baa, “A taara ko ra taamaan mi diat a aak doko wa iaau kabina un Rebekaa maa a wakwakaak na tabuan pi.” ");
INSERT INTO rai_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Baa Aaisaak ia ki iwan irong Geraar, raa bung Aabimelek a king anu ra taara Pilistia i babo pari ko ra nuna mataana kalaangaar ma i babo paa Aaisaak ma Rebekaa kuraa ut diaar wepapaam paa. ");
INSERT INTO rai_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Io, Aabimelek i wetulaa paa Aaisaak ma i piri lenbi, “A tabuan mi anum taulaa mulu ut. I lawaai maa u piri naa mur tenalik ku?” Aaisaak i baalui naa, “Kabina iaau nuki naa din aak doko wa iaau baa ang piri naa anung tabuan.” ");
INSERT INTO rai_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ma Aabimelek i piri naa, “Aawa mi u paami karom miaat? Kaduk baa te ko ra kum muaana bi in inep ungaai ma ra num taulaa, io, baa a dekdek na naagagon na binabaalu in waan paat karom miaat, ui ku a kabina.” ");
INSERT INTO rai_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Io, Aabimelek i taar wa a pirpir karom a taara raap naa, “Te baa in paam ta utnaa u ra muaana mi baa u ra nuna taulaa, din aak doko wai.” ");
INSERT INTO rai_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aaisaak i maarut a utnaa na winangaan u ra pia Geraar, ma u ra kilaala balet ut maa i tangaai. Baa i tangaai, a maarmaar raap ut ko ra kum utnaa baa i maaruti, kabina a Tadaaru i wadaani. ");
INSERT INTO rai_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A wuwuwung anun Aaisaak i tawa waanwaan ma i ngaala, ma Aaisaak i waan paat a tadaaru na muaana. ");
INSERT INTO rai_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","A taara Pilistia diat nuknuk aakaka un Aaisaak, kabina maa anuna mongoro na sip, bulumakaau, ma ra nuna mongoro na taara na pinapaam kaai. ");
INSERT INTO rai_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Io, a kum daanim raap baa a kum tultul anun tamaana Aabaraam diat kil tataai u ra kum kilaala baa Aabaraam i lalaaun utbaai, a taara Pilistia diat aa punang raap wa diat ma ra pia. ");
INSERT INTO rai_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Io, Aabimelek i piri taan Aaisaak lenbi, “Un waan ingen kon miaat. A dekdekim ia ngaala aakit taa miaat.” ");
INSERT INTO rai_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Aaisaak i lo raap paa anuna kum utnaa ma i waan urong u ra maale in Geraar ma diat watur anundiat kum ruma na sel matira. ");
INSERT INTO rai_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A kum tung na daanim baa a kum tultul anun Aabaraam diat kil tata diat u ra kum kilaala anun Aabaraam, baa a taara Pilistia diat punang wa diat balet, mi Aaisaak diat, diat kil aara raap pa diat balet. Ma i waatung diat ma ra kum iaandiat baa tamaana Aabaraam i waatung ta diat mun mai. ");
INSERT INTO rai_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","A kum tultul anun Aaisaak diat kil paa raa matakina tung na daanim naliwan u ra kum taangaai ma diat baat paa a palaa uni. ");
INSERT INTO rai_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Iaku a kum tena baboura wewagua taanga Geraar diat piri naa anundiat ut a daanim maa, ma diat wengangaar ma ra kum tena baboura wewagua anun Aaisaak. Io, Aaisaak i waiang taa a daanim maa baa “Wengangaar”. ");
INSERT INTO rai_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Diat kil taa balet raa ma diat wengangaar balet uni, io Aaisaak i waiang taa a daanim maa baa “Kini na ebaar”. ");
INSERT INTO rai_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Diat kakaraai ko ra taamaan maa ma diat kil paa balet raa daanim ma pa diat wengangaar balet ma uni. Io, Aaisaak i waiang taai baa “Pia i laangalaanga,” ma i piri naa, “A Tadaaru ia taar taa a pia baa i laangalaanga karom daat, ma daat a papaam u ra pia mi kup anundaat koina kini in waan paat uni.” ");
INSERT INTO rai_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Taanga matira i kakaraai unaanga Ber-Sebaa. ");
INSERT INTO rai_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A Tadaaru i waan paat karomi u ra marum ma i piri taana lenbi, “Iaau a God anun tamaam Aabaraam. Koku u burut, iaau ki ungaai ma ui. Iaau ang wadaan ui ma ang wangaala a niluluk i ra num wuna taara kabina u ra nung tultul Aabaraam.” ");
INSERT INTO rai_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Matira Aaisaak i paam paa a wunuwung na waat na tuntun wetabaar, ma i aaraaring karom a Tadaaru. I watur paa anuna ruma na sel ma anuna kum tultul kaai diat kil paa balet raa daanim matira. ");
INSERT INTO rai_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Raa bung na wanua, Aabimelek, Aakusaat anuna tena manaana, ma Pikol a mukmuga anu ra kum taara na wineium anun Aabimelek, ditul waan taangirong Geraar karom Aaisaak. ");
INSERT INTO rai_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aaisaak i tiri ditul, “Kup aawa maa mutul waan urin karom iaau, maa namuga muaat nget iaau ku, ma muaat lu wa iaau?” ");
INSERT INTO rai_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ditul baalui naa, “Miaat babo kaapakaapa maku a pinapaam anu ra Tadaaru karom ui. Io, mitul nuki lenbi, i koina baa daat a paam ta weweliman naliwan karom daat, karom ui ungaai ma miaat. Daat a paam a kunubu lenbi: ");
INSERT INTO rai_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Pa un baanaakaka miaat, lenbaa miaat mun pa miaat baanaakaka ui. Miaat paam ku a koina karom ui baa miaat tula wa ui ku ma ra maalmaal. Ma mi a Tadaaru i wadaan ui.” ");
INSERT INTO rai_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aaisaak i paam a ngaala na winangaan un ditul ma diat wangaan ma diat inim. ");
INSERT INTO rai_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","U ra bung namur taana u ra malaana, waat na muaana maa diat paam a kunubu karom diat wetwetalaai. Baa ia raap anundiat pinapaam, Aaisaak i tur tula ta ditul u ra aakapi urong Geraar ma ditul waan koni ma ra maalmaal. ");
INSERT INTO rai_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","U ra bung maa a kum tultul anun Aaisaak diat wapuai u ra daanim baa diat kili. Diat piri taana naa diat aa baat paa a palaa. ");
INSERT INTO rai_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Aaisaak i waiang taa a daanim maa, baa Sibaa. Kumari a iaa ra taamaan di waatungi baa Ber-Sebaa. ");
INSERT INTO rai_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Baa ia 40 kilaala na lalaaun anun Esaau, i taulaa ma ru tabuan, Iudit a natun Beri a te Ket, ma Baasemaat a natun Elon a te Ket utkaai. ");
INSERT INTO rai_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","A ru tabuan anun Esaau diaar watapunuk Aaisaak ma Rebekaa. ");
INSERT INTO rai_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Baa Aaisaak i takaana a ruin mataana pa i babo wakaak ma. Raa bung na wanua Aaisaak i wataa paa anuna mugaana naat muaana Esaau karomi, ma i piri taana naa, “Natunglik!” Ma Esaau i baalui naa, “Bi ku iaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aaisaak i piri naa, “Iaau aa takaana, pa iaau nunurai unaangaian ang maat. ");
INSERT INTO rai_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Un lo paa anum bunaaraa na nilebe ma un lebe paa ngaang ta wewagua matira u ra bil na wanua. ");
INSERT INTO rai_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Un waninaar paa ta koina namnamian na winangaan baa iaau nemnemi, ma un loi karom iaau kupi ang aani. Ma ang pir wadaan ta ui baa ang maat maku.” ");
INSERT INTO rai_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekaa i walangoro taa Aaisaak baa i pirpir karom natunalik Esaau. Io, baa Esaau i waan kup a bil na wanua, kupi in lebe paa ta wewagua, ");
INSERT INTO rai_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekaa i wapua natuna Iaakob naa, “Baboi, iaau walangoro taa tamaam i piri karom temlik Esaau lenbi, ");
INSERT INTO rai_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Un lebe paa ta wewagua urin ma un waninaar paa ta koina namnamian na winangaan kupi ang aani. Io, ang pir wadaan ta ui namataa ra Tadaaru baa ang maat maku.’ ");
INSERT INTO rai_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Io, natunglik, un walangoro iaau ma un paam a kum utnaa raap baa ang piri naa un paami. ");
INSERT INTO rai_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Un waan ubarong naa ra kum wewagua ma un babo paa ta ru tubutubu na baarmaan na me, ma un lo diaar urin. Ma iaau ang waninaar paa ta koina namnamian na winangaan an tamaam, lenutmaa i nemnemi. ");
INSERT INTO rai_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Io, un loi karom tamaam kupi in aan paai ma in pir wadaan ta ui baa in maat maku.” ");
INSERT INTO rai_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Iaakob i piri karom naana Rebekaa naa, “Iaau wakir a paning i weweu, iaku Esaau a panina i weweu. ");
INSERT INTO rai_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Baa tamaang in paam a paning ma in baat pa iaau naa iaau warugai, io, wakir in pir wadaan iaau, in taar ku ta dekdek na naagagon karom iaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Naana i piri taana, “Natunglik, maadek wa a naagagon baa iaau ang lo paai. Un paam ku a kum utnaa baa iaau aa pir taai taam. Un waan ma un lo paa ta ru me urin karom iaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Io, Iaakob i waan ma i lo paa a ru me, ma i taar taai karom naana. Ma naana i waninaar paa a koina winangaan lenutmaa tamaandiat i nemnemi. ");
INSERT INTO rai_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ma Rebekaa i lo paa in koina maalu anu ra nuna mugaana naat Esaau, baa i walwalaaingi ku u ra ruma, ma i wamong taa Iaakob a murmur na natuna mai. ");
INSERT INTO rai_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ma i burung baat taa kaai a panpanin Iaakob baa pa i weweu, ma ra pani ra me, a ru limaana ma ra in kabarono. ");
INSERT INTO rai_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Io, i taar taa ma a koina namnamian na winangaan ungaai ma ra bred baa ia paam taai kupi natuna Iaakob in loi karom tamaana. ");
INSERT INTO rai_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iaakob i waan karom tamaana ma i piri lenbi, “Tamaang!” Ma tamaana i baalui naa, “Aawa, natunglik? Ui woi?” ");
INSERT INTO rai_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iaakob i piri taan tamaana, “Iaau Esaau anum mugaana naat, iaau aa waninaar paa a kum utnaa baa u pir taai taang. Wakaak, un ki ma un wangaan ko ra wewagua bi iaau aa lebe paai, ma namur un pir wadaan ta iaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aaisaak i tiri natunalik Iaakob, “Le, u baat gagaa paa ku a wewagua mi lelawaai?” Iaakob i baalui naa, “A Tadaaru anum God i waraaut iaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ma Aaisaak i piri taan Iaakob naa, “Waan marawaai urin baa ang paam lele a panim, baa ui mulu ut a natunglik Esaau, baa pate.” ");
INSERT INTO rai_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Iaakob i waan marawaai karom tamaana Aaisaak, ma tamaana i paam lele a panina ma i piri naa, “In ingaam in ingaan Iaakob, iaku a limaam a limaan Esaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aaisaak pa i nunurai naa Iaakob, maa i pula ma a ru limaan Iaakob i weweu welaar ma ra ru limaan tenalik Esaau. Io, Aaisaak i pir wadaani. ");
INSERT INTO rai_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aaisaak i wetiri, “A lingtatuna ut, ui natunglik Esaau?” Iaakob i baalui, “Iaau ut mi.” ");
INSERT INTO rai_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ma Aaisaak i baalui naa, “Natunglik, lo ta utnaa urin ko ra utnaa baa u lebe paai kupi ang aani, ma ang pir wadaan ta ui.” Iaakob i lo tabaara taai ma i wangaan, ma i lo tabaarai ma ra waain ma i inim. ");
INSERT INTO rai_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Io, Aaisaak i piri naa, “Waan urin, natunglik, ma un dum a papaar a waang.” ");
INSERT INTO rai_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Io, Iaakob i waan karom tamaana ma i dum a papaara waana. Baa Aaisaak i lung lele paa a maalu anun Esaau, i pir wadaan Iaakob ma i piri naa, “Maia, aangawin natunglik i welaar ma ra aangawi ra buaal, baa a Tadaaru ia wadaan taai. ");
INSERT INTO rai_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ma God in tabaara ui ma ra ngaala na maaok taanginaanga u ra maawa, ma ra koina pia, ma ra koina tinawa na wit, ma ra waain in wa mongmongoro na waina. ");
INSERT INTO rai_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ma a kum wunwuna taara diat a taraam taam, ma diat a ki but keke karom ui. Un naagagon a kum tatem liklik, Ma a kum taptabun naam diat a ki but keke karom ui. Ma diat raap baa diat pir aakaka ui, din baanaakaka diat. Ma diat raap baa diat pir wadaan ui, din pir wadaan diat.” ");
INSERT INTO rai_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aaisaak i pir wadaan taa Iaakob, ma baa ku i pari paa kon tamaana, Esaau kaai i waan paat ko ra nilebe. ");
INSERT INTO rai_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esaau bulung i waninaar paa a kokoina utnaa na winangaan ma i loi karom tamaana. I piri naa, “Tamaang, un tur ma, un ki baa un aan a winangaan baa iaau, natumlik, iaau lebe paai naa a maam, ma un pir wadaan iaau.” ");
INSERT INTO rai_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aaisaak i wetiri naa, “Woi ui?” Esaau i baalui naa, “Iaau natumlik Esaau, anum mugaana naat.” ");
INSERT INTO rai_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ma Aaisaak i kakaian, ma i dadader ma i piri naa, “Woi kumun maa i lebe paa a wewagua ma i lo tabaara iaau mai? Iaau aan raap paai, ma mi ut ku maa iaau pir wadaan taai. Io, ui kaai u waan paat. Ma ia baa iaau aa pir wadaan taai, in daan ut.” ");
INSERT INTO rai_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Baa Esaau i walangoro a kum pirpir anun tamaana, i ung pulaanga wa a niluan, ma i piri naa, “Un pir wadaan ta iaau utkaai, tamaang.” ");
INSERT INTO rai_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Iaku Aaisaak i piri taana naa, “Temlik i waruga mulu pa iaau, ma ia walong paa anum pir wadaan.” ");
INSERT INTO rai_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaau i piri naa, “I dowot aakit a iang baa di taar taai un Iaakob. Ia ru pakaan i waruga iaau. Ia lo paa anung kini na munuga, io mi bulung i lo paa anung pir wadaan.” Ma i tiri tamaana naa, “Pa ta pir wadaan mulu ma kuraa, baa un pir wadaan ta iaau mai?” ");
INSERT INTO rai_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aaisaak i baalu Esaau naa, “Iaau aa pir wadaan taai naa in naagagon ui, ma ra kum kakuna ut diat a ki na tultul anuna. Ma iaau taar taa a koina tinawa na wit taana, ma ra waain kaai baa in wa a mongmongoro na waina. Io, aawa balet ma maa ang taari taam, natunglik?” ");
INSERT INTO rai_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaau i piri taan tamaana, “Tamaang, pa ta pir wadaan mulu ma kuraa? Un pir wadaan ta iaau kaai, tamaang.” Ma Esaau i luan balet. ");
INSERT INTO rai_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aaisaak i piri karom Esaau, “Un lalaaun ingen ko ra koina pia, ma welwelik kaai ko ra maaok taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Un lalaaun ko ra num in liwan na wineium, ma un ki naatudaangi ra naagagon anun temlik. Iaku, namur baa u nem na laangalaanga, un palaa pa ui ko ra nuna naagagon.” ");
INSERT INTO rai_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Namur Esaau i nget Iaakob, kabina u ra pir wadaan baa Iaakob i lo paai kon tamaandiaar. Esaau i piri karom ia ut naa, “Tamaang marawaai in maat ma miaat a tapunuk uni. Baa a kum bungbung na tapunuk maa in raap, ang aak doko wa tenglik Iaakob.” ");
INSERT INTO rai_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Baa Rebekaa i walangoro baraata a pirpir baa Esaau a mugaana natuna i piri, i wetulaa kup Iaakob a murmur na natuna. Rebekaa i piri taan Iaakob naa, “Walangoroi, temlik Esaau i nemi naa in aak doko ui kupi a nuknukina in ngo. ");
INSERT INTO rai_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Io, natunglik, un paam a utnaa baa ang piri taam. Tenglik Lebaan kurong ut u ra taamaan Aaraan. Mi ut un waan kupi. ");
INSERT INTO rai_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Un ki kumun marong tuk baa temlik in dumaana wa a utnaa baa u paam taai karomi. ");
INSERT INTO rai_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ma baa pa in kaankaan ma, io, kuraa ku ang taar wa ta pirpir kup ui baa un waan talili balet urin. Pa iaau nemi baa ang luan mur raap un raa bung ku.” ");
INSERT INTO rai_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Io, Rebekaa i piri karom Aaisaak naa, “Anung lalaaun pa i koina ma kabina u ra ru tabuan anun Esaau, a ru tabuan Ket. Ma baa Iaakob bulung in taulaa ku ma ta tabuan ko ra taamaan mi, iaau pang lalaaun liklik.” ");
INSERT INTO rai_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aaisaak i wataa paa Iaakob ma i pir wadaani ma i pir baat adekdeki baa, “Koku u taulaa ma ta tabuan Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Un waan ut urong Mesopotaamia, kup a taamaan anun tabum Betuel, ma un baat paa anum ta tabuan marong ko ra kum natnatun labaam Lebaan. ");
INSERT INTO rai_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","God baa i Dekdek Aakit in pir wadaan ui ma in tabaara ui ma mongoro na natnatum, un wabure, ma un waan paat a tamaa ra mongoro na wunwuna taara. ");
INSERT INTO rai_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","God in tabaara ui ungaai ma ra num wuna taara ma ra pir wadaan baa i pir wadaan mun Aabaraam mai. Io, un kale a pia mi u lalaaun na waira uni, maa mari ut ia a pia baa God i taari karom Aabaraam.” ");
INSERT INTO rai_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Baa Aaisaak i pirpir paa karom Iaakob, i tula wai urong Mesopotaamia. Iaakob i waan karom Lebaan, a natun Betuel a te Aaraam. Lebaan a tein Rebekaa, baa naandiaar ma Esaau. ");
INSERT INTO rai_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaau i walangoroi naa tamaana Aaisaak ia pir wadaan taa Iaakob ma ia tula wai urong Mesopotaamia kupi in baat paa nuna ta tabuan matira. I nunurai kaai naa Aaisaak ia tur baat adekdek taai baa koku i taulaa ma ta tabuan Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ma Esaau i walangoroi baa Iaakob i taraam karom tamaana ma naana ma ia waan urong Mesopotaamia. ");
INSERT INTO rai_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Baa i nunurai naa Aaisaak pa i gaaia uni baa i taulaa ma ra ru tabuan Kaanaan, ");
INSERT INTO rai_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","i waan balet karom Ismaael a natun Aabaraam ma i taulaa ma natuna Maakaalat. Maakaalat anuna wetula tabuan. Maakaalat dina ma Nibaaiot, a naat muaana, a natun Ismaael. ");
INSERT INTO rai_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iaakob i waan ko ra taamaan Ber-Sebaa ma i waan urong kup a taamaan Aaraan. ");
INSERT INTO rai_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","U ra nuna winawaan i ngo paa un raa wanua kupi in inep, maa in mage ia lop. I baat paa ina waat matira kupi in ululaangi baa in inep. ");
INSERT INTO rai_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Iaakob i beberon ma i babo paa a kaakaatato, i tur paai matira napia, ma i waan tato unaanga u ra maawa. Ma i babo a kum aangelo anun God diat waanwaan tato ma diat waanwaan pari uni. ");
INSERT INTO rai_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma inaanga nate u ra kaakaatato, Iaakob i babo a Tadaaru i tur taau ma i piri lenbi, “Iaau a Tadaaru, a God anun tabum Aabaraam, ma a God anun Aaisaak. Ang tabaara ui ma ra num wuna taara ma ra pia maa u inep iaai. ");
INSERT INTO rai_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Anum wuna taara diat a welaar ma ra kabu i ra pia ma diat a ki werweraan raap un waat na mataana dadaip. A kum wunwuna taara raap din pir wadaan diat kabina un ui ma ra num wuna taara. ");
INSERT INTO rai_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Iaau ang ki ungaai ma ui, ma ang baboura ui u ra kum wanua raap baa un waan iaai. Ma ang ben talili ta ui balet kup a pia mi. Pang waan ingen paa kon ui tuk baa ang paam ot paa anung weweliman mi iaau aa paam taai karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Io, Iaakob i tawaangun ko ra nuna ininep ma i piri naa, “Dawot aakit, a Tadaaru kuri ut u ra wanua mi, iaku pa iaau nunurai.” ");
INSERT INTO rai_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I burut aakit ma i piri balet lenbi, “Iaau burut aakit u ra wanua mi! I dowot aakit a wanua mi a ruma anun God ma a bonanaaka i ra maawa.” ");
INSERT INTO rai_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Iaakob i tur u ra malaana kinalik ma i lo paa ina waat baa i ululaangi, ma i watur taai, ma i langer taa a wel na oliwa nate uni. ");
INSERT INTO rai_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Namuga a iaa ra wanua maa Lus, iaku Iaakob i kiaana wa a iaa ra wanua maa naa Betel. ");
INSERT INTO rai_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Io, Iaakob i paam a weweliman ma i piri naa, “Baa God in ki ungaai ma iaau, ma in baboura iaau u ra nung winawaan, ma baa in tabaara iaau ma ra utnaa na winangaan kupi ang aani, ma ra maalu kupi ang mong mai, ");
INSERT INTO rai_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ma ang pet laar paai baa ang waan talili kup a ruma anun tamaang, io, a Tadaaru in waan paat anung God. ");
INSERT INTO rai_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ma ina waat mi iaau aa watur taai, in waan paat a ruma anun God, ma iaau ang tabaara God balet ma raaraa utnaa ko ra kum noina utnaa raap baa i tabaara iaau mai.” ");
INSERT INTO rai_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iaakob i tur paa balet anuna winawaan, ma i waan paat taau u ra pia anura taara u ra papaara taubaar. ");
INSERT INTO rai_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","I babo paa a daanim matira ungaai ma ra tula kikil na sip, diat inep marawaai naa ra daanim. Diat inep walaanga a pakaana bung na ininim. Maa ina waat ko ra mataara daanim maa i ngaala ma i mawaat. ");
INSERT INTO rai_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Baa a kum kikil na sip raap diat aa waan ungaai taau matira, io, a kum tena baboura sip diat a lo wa ina waat ko ra mataa ra daanim ma diat a wainim diat. Namur diat a ung baat taa balet a mataa ra daanim mai. ");
INSERT INTO rai_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iaakob i tiri a kum tena baboura sip naa, “A kum tateng liklik, taanga waai muaat?” Diat baalui naa, “Miaat taangirong Aaraan.” ");
INSERT INTO rai_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I tiri diat naa, “Muaat nunura ut Lebaan, baa a tabun Naaor?” Diat baalui naa, “Miaat nunurai ut.” ");
INSERT INTO rai_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Namur Iaakob i tiri diat, “Lelawaai, i lalaaun wakaak ku?” Diat baalui naa, “I lalaaun wakaak ku. Baboi, natunalik a tabuan barong i waan urin ungaai ma ra kum sip, a iaana Raakel.” ");
INSERT INTO rai_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","I piri taan diat, “Muaat baboi, a ngaala na mage utbaai mi, pa i ot utbaai a pakaana bung baa muaat a waruk a kum sip u ra liplip. Muaat a wainim ta diat ku, io, muaat a ben ta diat balet kup a wanua baa diat a aan wali iaai.” ");
INSERT INTO rai_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Diat baalui, “Pain miaat a pet laar paai. Miaat a ki walaanga paa ut a kum kikil na sip anu ra kum tena baboura sip raap. Baa diat a waan paat ungaai, io, miaat a lo wa ina waat ko ra mataara daanim, ma miaat a wainim diat.” ");
INSERT INTO rai_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Baa kuraa utbaai i pirpir ma diat, Raakel i waan paat ma ra kum sip anun tamaana, maa ia a tabuan na baboura sip. ");
INSERT INTO rai_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Baa Iaakob i babo paa Raakel, natun Lebaan, ma ra nuna kum sip, i waan ma i lo wa ina waat ko ra mataara daanim, ma i wainim a kum sip anun labaana Lebaan, a tein Rebekaa, naan Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Iaakob i dum a papaara waan Raakel ma i luan dekdek. ");
INSERT INTO rai_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I wapua taa Raakel naa ia a natun Rebekaa, ia raa kakun tamaana Lebaan. Io, Raakel i kalaa kupi in wapua taa tamaana uni. ");
INSERT INTO rai_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Io, baa Lebaan i walangoro a wewapua un Iaakob, a natun tenalik Rebekaa, i welulu gagaa, ma i gaaia baraatai. I raat paai ma i dum a papaara waana, ma i ben paai uaa u ra nuna ruma. Ma namur Iaakob i wapuai u ra kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Io, Lebaan i piri taana naa, “Ui, daar raa gaap ku.” Ma Iaakob i ki ungaai ma Lebaan welaar ma raain kalaang. ");
INSERT INTO rai_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Namur Lebaan i piri taana, “Ui a kakung, iaku pa un papaam biaa paa ku karom iaau. Aawa maa u nemi ang dok ui mai?” ");
INSERT INTO rai_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","A ru natnatun Lebaan, a ru tabuan, a iaa ra mugaana maa Leaa, ma a iaa ra murmurina Raakel. ");
INSERT INTO rai_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","A binilua i taana u ra mataan Leaa, iaku Raakel panina i babo wakwakaak, ma a gaugauwen. ");
INSERT INTO rai_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iaakob i nem aakit Raakel, io, i piri karom Lebaan naa, “Ang papaam karom ui ta 7 na kilaala, kupi un taraam taa a murmur na natumlik Raakel baa ang taulaa mai.” ");
INSERT INTO rai_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lebaan i piri karom Iaakob, “I koina aakit baa un taulaa mai. Pa iaau nemi naa in taulaa ma ta muaana ingen. Io, un ki ut min naang.” ");
INSERT INTO rai_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Io, Iaakob i papaam paa 7 na kilaala, kupi Lebaan in taraam taa Raakel karomi. Witu na kilaala maa i welaar ku ma kabaana bung karomi, kabina ku u ra nuna ngaala na nemnem kup Raakel. ");
INSERT INTO rai_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Io, Iaakob i piri karom Lebaan naa, “Un taar taa ma anung tabuan. Anung kum kilaala na pinapaam ia raap, ma iaau nemi naa mir a taulaa ma.” ");
INSERT INTO rai_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Io, Lebaan i ben ungaai paa a kum taara raap ko ra taamaan maa, ma i paam a ngaala na winangaan. ");
INSERT INTO rai_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","U ra marum i ben paa ku natuna Leaa, ma i tula taai karom Iaakob ma diaar taulaa. ");
INSERT INTO rai_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lebaan i taar taa anuna tultul na tabuan Silpaa karom Leaa kupi in tultul anuna. ");
INSERT INTO rai_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","U ra malaana, Iaakob i baboi naa Leaa ku ma diaar taulaa. Io, i piri karom Lebaan naa, “Aawa mi u paami karom iaau? Iaau papaam karom ui kupi ang taulaa ma Raakel, naka? I lawaai ma u waruga iaau?” ");
INSERT INTO rai_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lebaan i baalui naa, “U ra numiaat taamaan, pa miaat wataulaa a kum murmur na natnatumiaat muga, a kum mugaana ut diat a taulaa muga. ");
INSERT INTO rai_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","A kudulaana wik mi un ki ungaai kumun ma Leaa, namur miaat a taar taa a murmur na natumiaat Raakel kaai, kup ta 7 na kilaala balet un papaam paai.” ");
INSERT INTO rai_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ma Iaakob i paami ut lenmaa, diaar ki ungaai ma Leaa raa wik, ma namur Lebaan i taar taa bulung natuna Raakel kupi anuna taulaa utkaai. ");
INSERT INTO rai_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lebaan i taar taa anuna tultul na tabuan Bilaa karom Raakel kupi in tultul anuna. ");
INSERT INTO rai_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Io, Iaakob i taulaa kaai ma Raakel. I nem dekdek aakit Raakel kon Leaa, ma i papaam karom Lebaan 7 na kilaala balet. ");
INSERT INTO rai_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Baa a Tadaaru i baboi naa Iaakob pa i nem wakaak Leaa, i paapa a baa ra naat u ra in balaan Leaa. Iaku maa Raakel i bi. ");
INSERT INTO rai_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leaa i kipbaala, ma i buta paa raa naat muaana, ma i waatung taa iaana baa Ruben, ma i piri lenbi, “A Tadaaru i babo anung mawaat. Io, mi anung muaana in nem aakit iaau ma.” ");
INSERT INTO rai_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leaa i kipbaala balet, ma i buta paa balet raa naat muaana, ma i piri naa, “A Tadaaru i walangoroi naa Iaakob pa i nem iaau, io, i taar taa balet raa naat mi.” Ma i waatung taa a iaana baa Simion. ");
INSERT INTO rai_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leaa i kipbaala balet ma i buta paa raa naat muaana. Leaa i piri naa, “Kumari anung muaana in ki marawaai ma karom iaau, maa iaau aa buta paa tula naat muaana uni.” Io, i waatung taa a iaana baa Lewi. ");
INSERT INTO rai_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Leaa i kipbaala balet, ma i buta paa raa naat muaana. Ma i piri naa, “U ra pakaana bung mi ang pir walaawa paa a Tadaaru.” Ma i waatung a iaana baa Iuda. Namur i ngo ko ra binabuta. ");
INSERT INTO rai_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Baa Raakel i baboi naa pa i buta taa ta kum naat un Iaakob, i nuknuk aakaka karom Leaa, ma i piri karom Iaakob naa, “Un wangaala taa anung ta kum naat, kaduk ang maat ma ra tapunuk.” ");
INSERT INTO rai_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iaakob i kaankaan ma karom Raakel, ma i piri naa, “Iaau pang paam laar paa ta utnaa baa i tale God ku in paami, baa i naagagon baat ui kupi koku u babuta.” ");
INSERT INTO rai_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ma Raakel i piri naa, “Bi ia Bilaa, anung tultul na tabuan, un inep ungaai mai kupi in buta taa anung ta kum naat, kupi iaau kaai ang wagua paa ta kum naat.” ");
INSERT INTO rai_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Raakel i taar taa anuna tultul na tabuan karom Iaakob ma i inep ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ma Bilaa i kipbaala ma i buta paa raa naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raakel i piri naa, “God i naagagon iaau naa iaau takado. Ia walangoro anung aaraaring ma ia taar taa raa naat muaana taang.” Ma i waatung taa a iaana naa Daan. ");
INSERT INTO rai_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilaa i kipbaala balet, ma i buta taa a weru naat un Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raakel i piri naa, “Iaau ongor kupi ang uwia paa tenawawing, ma iaau aa uwia paai.” Io, i waatung taa a iaana naa Naaptaali. ");
INSERT INTO rai_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Baa Leaa i baboi naa pa i babuta ma, i taar taa anuna tultul na tabuan Silpaa taan Iaakob kupi anuna tabuan. ");
INSERT INTO rai_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpaa i buta paa raa naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leaa i piri naa, “Iaau daan.” Ma i waatung taa a iaana naa Gaad. ");
INSERT INTO rai_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpaa i buta paa balet raa naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leaa i piri naa, “Iaau gaaia aakit. A kum tabuan diat a piri un iaau naa iaau gaaia.” Io, i waatung taa iaana naa Aaser. ");
INSERT INTO rai_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","U ra pakaana bung baa i ot kupi din tangaa wit, Ruben i waan kup a pinapaam ma i baat paa raa kum diwaai na binabuta, ma i lo paati karom naana Leaa. Iaku Raakel i piri taan Leaa lenbi, “Le, maari iaau ma ta kum diwaai na binabuta kon natum.” ");
INSERT INTO rai_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leaa i baalui naa, “U aa ben paa mun anung taulaa kon iaau, io, mi u nemi bulung naa un lo paa ta kum diwaai na binabuta kon natunglik.” Iaku Raakel i piri naa, “Baa un taar taa ta diwaai na binabuta kon natum, io, un inep ungaai ma Iaakob umari u ra marum.” ");
INSERT INTO rai_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Io, baa Iaakob i waan talili ko ra pinapaam u ra maluraap, Leaa i waan baraata paai, ma i piri taana, “Un inep ungaai ma iaau mari u ra marum. Iaau aa kul pa ui ma ra kum diwaai na binabuta anun natunglik.” Io, Iaakob i inep ungaai mai u ra bung na marum maa. ");
INSERT INTO rai_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God i walangoro a aaraaring anun Leaa, ma Leaa i kipbaala balet, ma i buta paa a welima na naat muaana un Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leaa i piri naa, “God ia dok ta iaau, kabina maa iaau taar taa anung tultul na tabuan taa ra nung muaana.” Io, i waatung taa a iaana naa Isaakaar. ");
INSERT INTO rai_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leaa i kipbaala balet, ma i buta paa a we-6 na naat muaana. ");
INSERT INTO rai_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Namur Leaa i piri naa, “God ia taar taa a koina wetabaar karom iaau. U ra pakaana bung mi, anung muaana in papaam karom iaau ma ra urur, maa iaau aa buta taa nom na naat muaana uni.” Io, i waatung taa a iaana naa Sebulon. ");
INSERT INTO rai_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Namur Leaa i buta paa raa tabuan, ma i waatung taa a iaana Dina. ");
INSERT INTO rai_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","God i nuk paa Raakel, i walangoro anuna aaraaring, ma i palaa baa ra naat u ra in balaana. ");
INSERT INTO rai_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Io, i kipbaala, ma i buta paa raa naat muaana, ma i piri naa, “God ia rakaan wa a wawirwir kon iaau.” ");
INSERT INTO rai_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Io, i waatung taa a iaana naa Iosep, ma i piri naa, “A Tadaaru in taar taa maku ta naat muaana balet taang.” ");
INSERT INTO rai_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Namur baa Raakel ia buta paa Iosep, Iaakob i piri karom Lebaan naa, “Iaau nemi naa un taraam wa iaau ma, kupi ang waan talili balet kup anung taamaan. ");
INSERT INTO rai_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ang waan u ra nung winawaan. Un maadek taa anung ru tabuan, ma ra nung kum naat kaai karom iaau, maa iaau aa papaam paa karom ui kup diaar. Ui ut u nunura a kum ngaala na pinapaam iaau aa paam taai karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Iaku Lebaan i piri taana naa, “Baa u maari iaau, io, un ki kumun karom iaau. Iaau paam uraura ma iaau nunurai naa a Tadaaru i wadaan iaau, kabina un ui.” ");
INSERT INTO rai_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Lebaan i piri kaai naa, “Un wapua iaau baa taiaadi maa u nemi kupi ang dok ui mai, ma ang taari taam.” ");
INSERT INTO rai_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iaakob i piri taana, “Ui ut u aa nunura anung pinapaam baa iaau aa paam taai, ma ra num kum wewagua diat bure u ra nung binaboura. ");
INSERT INTO rai_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Baa iaau waan paat min anum kum sip pa diat mongoro, ma mi anum kum sip diat aa mongoro aakit. Pakpakaana bung raap baa iaau paam raa utnaa anum, Tadaaru i wadaan ui. Ma unaangaian maa ang paam ta utnaa kup anung kum naat?” ");
INSERT INTO rai_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lebaan i wetiri, “Aawa maa ang taari taam?” Iaakob i babaalu naa, “Koku u taar taa ta utnaa taang. Iaku un taraam u ra nuknuking bi, baa ang baboura balet anum kum sip. ");
INSERT INTO rai_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Un maadek wa iaau baa mari ang waan naliwan u ra num kum sip ma ra kum me, ma ang lo wa a kum tukatuka na sip ma ra kum me, ma ra kum marut na naatnaat na sip. Diat maa anung wedok. ");
INSERT INTO rai_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Namur baa un waan urin ma un babo anung kum sip, un nunurai baa iaau dowot baa pate. Baa un babo paa ta sip baa ta me baa pa i tukatuka ma ta sip baa pa i marut, io, un nunurai naa iaau walong paai.” ");
INSERT INTO rai_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lebaan i piri taana naa, “Koina ku, daar a paami lenutmaa u aa piri.” ");
INSERT INTO rai_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Iaku u ra bung ut maa, Lebaan i rakaan raap wa a kum muaana na me baa a weuindiat i tukatuka ma i aalaal na liklik kabaang kuraa un diat, ma ra kum tabuan na me baa i tukatuka, ma i lo raap paa a kum marut na sip kaai. Namur i wapua taa a kum natnatuna baa a kum muaana kupi diat a baboura diat un ta wanua ingen. ");
INSERT INTO rai_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ma Lebaan i weur ungaai ma diat i welaar ma tula bung na winawaan ma diat ki matira, ma Iaakob i baboura a kum wewagua baa diat ki talili. ");
INSERT INTO rai_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iaakob i lo paa a kum matakina gagaana diwaai, ko ra tuluin mangaana diwaai, i paal kutkutu a panindiat, kup a kum gagaana diwaai in kabaang ma in marut. ");
INSERT INTO rai_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","I wainep taa a kum gagaana diwaai u ra kum utnaa na ininim ara kum wewagua, kupi diat a taana takado namataan diat baa diat waan na ininim. Diat waan ungaai, ");
INSERT INTO rai_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ma diat taulaa namuga naa ra kum gagaana diwaai maa. Ma a kum wewagua raap baa diat buta pa diat matira, a panindiat i aalaal, i tukatuka ma a liklik kabaang un diat, ");
INSERT INTO rai_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ma Iaakob i rakaan ingen wa a kum naatnaat na sip kupi diat ut. Iaku a kum wewagua baa diat tukatuka ma diat marut, baa diat taulaa diat raap diat webabo ungaai ma ra kum sip anun Lebaan. I paam a mangamangaan mi kupi a kum sip ma ra kum me anuna diat a mongoro, ma in weraana wa diat ko ra kum sip ma ra kum me anun Lebaan. ");
INSERT INTO rai_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Baa a kum dekdek na tabuan na wewagua diat taulaa ma ra kum muaanaina, io, Iaakob i ung a kum gagaana diwaai namuga namataan diat kupi diat a baboi ma diat a taulaa naa ra kum gagaana diwaai maa. ");
INSERT INTO rai_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Baa a kum binilua na wewagua diat taulaa, Iaakob pa i ung taa ta kum gagaana diwaai. I paami lenmi kupi a kum binilua na wewagua anun Lebaan, ma a kum dekdekina anun Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","U ra mangamangaan mi, Iaakob i waan paat a tadaaru na muaana. Anuna mongoro na wewagua, mongoro na tultul na muaana ma ra kum tultul na tabuan, a kum kaamel ma ra kum dongki. ");
INSERT INTO rai_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Raa bung na wanua, Iaakob i walangoro taa a kum natnatun Lebaan, a kum muaana, diat piri lenbi, “Iaakob ia lo raap paa a kum utnaa baa tamaandaat i naagagoni, ma u ra kum utnaa anun tamaandaat i lo paa a ngaala na wunuwung koni.” ");
INSERT INTO rai_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ma Iaakob ia babo lele paa kaai a mangamangaan anun Lebaan karomi, wakir ma i welaar ma namuga. ");
INSERT INTO rai_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ma a Tadaaru i piri taan Iaakob naa, “Un waan talili kup a pia anu ra kum tamtamaam ma ra num wuna taara, ma iaau ang ki ungaai ma ui.” ");
INSERT INTO rai_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Io, Iaakob i taar wa a pirpir kup Raakel ma Leaa baa diaar a waan kupi, u ra pakaana baa anuna kum wewagua diat ki iaai. ");
INSERT INTO rai_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Iaakob i piri taan diaar lenbi, “Iaau baboi naa a mangamangaan anun tamaamur karom iaau wakir ma i welaar ma namuga, iaku a God anun tamaang kuri ut i ki ungaai ma iaau. ");
INSERT INTO rai_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mur nunurai naa iaau papaam karom tamaamur ma ra dekdeking raap, ");
INSERT INTO rai_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ma a tamaamur ia waruga ta iaau ma i puku anung wedok welaar ma noina pakaan. Iaku God pa i maadek wai kupi in baanaakaka iaau. ");
INSERT INTO rai_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Baa i piri naa, a kum tukatuka na wewagua raap maa anung wedok, io, a kum wewagua raap diat buta utkaai a kum naat na tukatuka na wewagua. Ma namur i pukui bulung ma i piri naa, a kum wewagua baa i aalaal na liklik kabaang kuraa un diat, maa anung wedok. Io, a kum wewagua raap diat buta a kum naat na wewagua baa i aalaal na liklik kabaang kuraa un diat. ");
INSERT INTO rai_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Io mi, God ia lo wa a mongoro na wewagua kon tamaamur ma ia taar ta diat taang. ");
INSERT INTO rai_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“U ra kalaang baa a kum wewagua diat laana taulaa uni, iaau beberon. Ma u ra nung beberon iaau babo a kum muaana na me, a kum tukatuka ma diat baa i aalaal na liklik kabaang kuraa un diat, diat taulaa ma ra kum tabuan na me. ");
INSERT INTO rai_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","U ra nung beberon a aangelo anun God i wataa iaau naa, ‘Iaakob.’ Iaau baalui naa, ‘Mi ut iaau.’ ");
INSERT INTO rai_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ma aangelo i piri naa, ‘Babo tato ma un babo a kum muaana na me raap baa diat taulaa ma ra kum tabuan na me, diat a kum tukatuka ma diat kaai baa i aalaal na liklik kabaang kuraa un diat, maa iaau aa babo a kum utnaa raap baa Lebaan i paampaami karom ui. ");
INSERT INTO rai_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Iaau a God taanga Betel, a wanua baa u langer taa a wel u ra toro na waat iaai, ma u paam taa a weweliman karom iaau iaai. Io, tur paa, ma un waan taanga min. Un waan talili kup a pia baa di buta ui iaai.’” ");
INSERT INTO rai_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raakel ma Leaa diaar baalu Iaakob lenbi, “Mir a ki balet ma kup aawa? Maa pain mir a kale ta utnaa ko ra kum wunuwung anu ra tamaamir. ");
INSERT INTO rai_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Maa i babo mir ku welaar ma ra ru waira. Wakir i taraam wa mir ku kupi un kul pa mir, i waraap wa utkaai a winekul baa u kul pa mir mai. ");
INSERT INTO rai_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Lingtatuna aakit, God ia lo wa a wuwuwung kon tamaamir ma ia taar taai baa anundaat ma ra kum natnatundaat. Io, un paam ku a utnaa baa God ia pir taai taam.” ");
INSERT INTO rai_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ma Iaakob i wakaa taa anuna ru tabuan ma ra kum natnatuna u ra kum kaamel. ");
INSERT INTO rai_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ma i lu ungaai muga paa anuna kum wewagua kupi diat a muga, ma diat waan. I lo raap paa kaai a kum utnaa liklik baa i kalei baa i ki utbaai irong Mesopotaamia. Ma diat waan kup Aaisaak, a tamaan Iaakob, baa i ki irong u ra pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Namuga taa ra nundiat winawaan, baa Lebaan i waan kupi in gele anuna kum sip, Raakel i walong paa a kum naatnaat na taabataaba liklik, a kum god anun tamaana Lebaan. ");
INSERT INTO rai_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iaakob i waruga taa Lebaan, a te Aaraam, ma i kalaa ino paa koni, ma pa i nemi naa in wapua kaapa taai. ");
INSERT INTO rai_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Io, i tur paa ma i waan ungaai ma ra nuna kum utnaa raap, i waan likaai a daanim Eupraat, ma i waan tutunga ku a kum taangaai u ra papaar Giliaad. ");
INSERT INTO rai_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Baa ia tula bung u ra winawaan anun Iaakob, di wapua Lebaan naa Iaakob ia kalaa ino paa. ");
INSERT INTO rai_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Namur Lebaan i ben paa anuna taara ma diat murmur kup Iaakob welaar ma 7 na bung, ma diat waan paat karomi u ra kum taangaai irong u ra papaar Giliaad. ");
INSERT INTO rai_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","U ra marum God i waan paat karom Lebaan a te Aaraam u ra beberon, ma i piri taana naa, “Baboura ui u ra num pirpir karom Iaakob. Koku u maangi ma ta mangaana pirpir baa in burut uni.” ");
INSERT INTO rai_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Io, Lebaan i waan paat matira u ra kum taangaai irong u ra papaar Giliaad, baa Iaakob diat, diat aa watur paa anundiat kum ruma na sel iaai. Io, Lebaan ma ra nuna taara diat kaai diat watur anundiat kum ruma na sel matira. ");
INSERT INTO rai_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lebaan i piri karom Iaakob lenbi, “Aawa mi u paami karom iaau? U waruga iaau, ma u aal paa a ru natnatung lenbaa naa u aal pa diaar u ra purpuruan. ");
INSERT INTO rai_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","I lawaai maa u waruga iaau lenmi? U welulu ino paa ku, ma pa u wapua ta iaau kupi ang tula wa muaat ma ra gaaia ma ra kelekele u ra tinaangi i ra gitaa ma ra taambarin. ");
INSERT INTO rai_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","U aa paam wa a longlong na mangamangaan, baa pa u ki pa iaau kupi ang dum taa a papaara waa ra kum taptabung ma a ru natnatung ma ang tur tula wakaak wa diat. ");
INSERT INTO rai_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","A dekdeking kuri ut, i tale ku baa ang baanaakaka ui, iaku nabari a God anun tamaam i piri taang lenbi, ‘Baboura ui u ra num pirpir karom Iaakob. Koku u maangi ma ta mangaana pirpir baa in burut uni.’ ");
INSERT INTO rai_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","U aa waan kabina maa u nemi naa un waan talili ma kup a taamaan anun tamaam, iaku kup aawa maa u walong paa anung kum god?” ");
INSERT INTO rai_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Iaakob i baalu Lebaan naa, “Iaau burut, maa iaau nuki naa un ben talili paa a ru natnatum kon iaau ma ra kaankaan. ");
INSERT INTO rai_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Iaku baa un baat paa te baa anum kum god kuaa taana, in maat. Namuga u ra mataara kum kakundaar, ui ut un baat kup ta utnaa baa anum, kuri min naang. Ma baa u aa baat paa ta utnaa, io, un lo paai.” Iaakob pa i nunurai naa Raakel ia walong paa a kum god. ");
INSERT INTO rai_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Io, Lebaan i ruk u ra ruma na sel anun Iaakob ma u ra ruma na sel anu ra ru tabuan na tultul anun Raakel ma Leaa, ma pa i baat paa ta utnaa. I ruk kaai u ra ruma na sel anun Leaa. Baa i pari, i ruk bulung u ra ruma na sel anun Raakel. ");
INSERT INTO rai_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raakel ia wapari wa a kum taabataaba na god maa, ma ia waruk taai u ra nuna kiki, baa i laana ki uni nate u ra kaamel, ma i ki baat pa diat. Lebaan i taakit pukpuku raap taa a kum utnaa u ra ruma na sel ma pa i baat paa ta utnaa. ");
INSERT INTO rai_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raakel i piri taan tamaana naa, “Anung tadaaru, koku u kaankaan karom iaau baa pa iaau tur u ra mugaana mataam, maa anung kalaang i um iaau.” Io, i baat papaa ma pa i baat paa ta utnaa. ");
INSERT INTO rai_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iaakob i kaankaan ma i pirpir dekdek karom Lebaan lenbi, “Aawa maa iaau paam aaka taai, ma woi na mangaana aakaina maa iaau paam taai mi, u lu murmur iaau uni? ");
INSERT INTO rai_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mi baa u aa baat pukpuku taa anung kum utnaa raap, aawa ma maa u baat paai ko ra num ruma? Ung taai bin namuga naa ra kum kakum ma ra kum kakung, kup diat ut diat a naagagoni baa woi na paan daar maa i takado. ");
INSERT INTO rai_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Iaau aa ki paa karom ui 20 kilaala ma. Anum kum sip ma ra kum me diat lalaaun wakwakaak ma diat babuta wakaak u ra nung binaboura. Pa iaau aan paa ta naat na muaana na sip kon ui. ");
INSERT INTO rai_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Pa iaau lo taa ta wewagua karom ui baa ta kuaabaar na wewagua i aak doko taai, iaau ut iaau laana kiaanai. Baa te i raara, baa di walong paai u ra marum baa u ra keke, u nemi naa iaau ut ang baalui. ");
INSERT INTO rai_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","U ra bungbung na keke, a mage i raang aakaka iaau, ma u ra bungbung na marum iaau madiring ma pa iaau ininep wakaak. ");
INSERT INTO rai_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I lenmi karom iaau u ra 20 kilaala raap baa iaau ki karom ui. U ra 14 na kilaala iaau papaam karom ui kup a ru natnatum, ma 6 na kilaala iaau papaam kup anung kum wewagua. Iaku ui, u puku anung wedok noina pakaan. ");
INSERT INTO rai_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Iaku God anun tamaang i ki ungaai ma iaau, a God anun Aabaraam, ma a God anun Aaisaak. Baa gun pa in ki ungaai ma iaau, kuri un tula wa iaau ku ma ra pabono limaang. God ia babo anung kum mawaat ma ra dekdek na pinapaam baa iaau paami ma ra ru limaang, ma nabari u ra marum i taar a dekdek na pirpir karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lebaan i piri karom Iaakob lenbi, “A ru tabuan baa a ru natnatung, ma anundiaar kum naat kaai a kum taptabung. A kum wewagua kaai anung ut, io, a utnaa raap baa u watur akotoi, anung ut. Iaku pang paam ta utnaa kabina u ra ru natnatung ma ra kum taptabung baa diaar aa buta pa diat. ");
INSERT INTO rai_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Io mi, daar a paam ta kunubu. Ma a kunubu maa in papaam lenbaa a wewapua kaapa naliwan karom daar.” ");
INSERT INTO rai_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Io, Iaakob i lo paa ina waat ma i watur taai lenbaa a toro. ");
INSERT INTO rai_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma i piri taa ra kum kakuna naa, “Muaat a lo ungaai a waatwaat urin.” Io, diat lo ungaai taa a kum waat, ma diat paam paa a aaim mai. Namur diat wangaan naa ra aaim maa. ");
INSERT INTO rai_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lebaan i waatung taa a waat na aaim maa baa Iegaar-Saadutaa, ma Iaakob i waatungi naa Gaaled. ");
INSERT INTO rai_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lebaan i piri, “A waat na aaim mi in lenbaa a wewapua kaapa naliwan karom daar u ra bung mi.” Maa ia a kabina baa di waatungi naa Gaaled. ");
INSERT INTO rai_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Di waatungi kaai naa Mispaa, maa Lebaan i piri kaai naa, “A Tadaaru in babo daar u ra nundaar kinkini weraan. ");
INSERT INTO rai_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Baa pa un waki wakaak a ru natnatung ma baa un taulaa ingen balet kon diaar, nuk paai, God in nunura a weweliman naliwan taan daar, baa pa te i ki ungaai ma daar.” ");
INSERT INTO rai_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lebaan i piri kaai karom Iaakob lenbi, “Bi ia a aaim ma bi ia a toro na waat. Iaau aa watur taai naliwan taan daar. ");
INSERT INTO rai_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","A aaim, ma a toro na waat mi diaar wewapua kaapa baa iaau pang waan likaai a aaim mi kup anum pakaana kupi ang baanaakaka ui iaai. Ma ui kaai pa un waan likaai a aaim mi ma ra toro na waat mi kup anung pakaana kupi un baanaakaka iaau iaai. ");
INSERT INTO rai_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","A God anun Aabaraam, ma a God anun Naaor, ma a God anu ra kum tamtamaandiat, in naagagon naliwan taan daar.” Io, Iaakob i paam a weweliman u ra iaan God anun tamaana Aaisaak. ");
INSERT INTO rai_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ma i aak doko paa raa wewagua ma i wetabaar mai karom God, matira u ra kum taangaai. Ma i aaring Lebaan ma ra nuna taara baa diat raap diat a wangaan ungaai. Baa diat aa wangaan raap, diat inep paa balet matira. ");
INSERT INTO rai_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","U ra malaana kinalik, u ra bung namur taana, Lebaan i dum taa a papaa ra waa ra kum taptabuna, a ru natnatuna ma i pir wadaan ta diat ma i waan talili kon diat kup anuna taamaan. ");
INSERT INTO rai_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Baa Iaakob i waan waanwaan, a kum aangelo anun God diat baraatai. ");
INSERT INTO rai_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ma baa i babo pa diat, i piri naa, “A wanua mi anun God baa i ki iaai.” Ma i waatung taa a wanua maa naa Maanaaim. ");
INSERT INTO rai_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Iaakob i tula muga wa a kum tena wewapua karom tenalik Esaau, irong u ra pia Seir, baa di waatungi kaai naa Edom. ");
INSERT INTO rai_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I wapua ta diat lenbi, “Bi ia a utnaa maa muaat a piri taa ra nung ngaala Esaau, ‘Iaau anum tultul Iaakob, iaau aa ki iwan ungaai paa ma Lebaan, ma mi iaau nem na waan talili ma, ");
INSERT INTO rai_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ungaai ma ra nung kum bulumakaau, kum dongki, kum sip ma ra kum me, a kum tultul na muaana ma ra kum tultul na tabuan. Io, mi iaau taar a pirpir kup ui, anung tadaaru, kupi un maari iaau ma un maraam pa iaau.’” ");
INSERT INTO rai_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Baa a kum tena wewapua diat waan talili karom Iaakob, diat piri naa, “Temlik Esaau kuraa i waan urin kupi in baraata ui, ma 400 na muaana kuraa diat weur mai.” ");
INSERT INTO rai_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Iaakob i burut dekdek aakit, ma i laklagon a nuknukina. Io, i weraana wa a taara baa diat ki ungaai mai un ru kikil. I weraana kaai a kum bulumakaau, a kum kaamel ma ra kum wewagua raap. ");
INSERT INTO rai_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I nuknuk lenbi naa, “Kaduk baa Esaau in waan paat ma in weium ma ra mugaana kikil, io, a weru kikil diat a welulu ino.” ");
INSERT INTO rai_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Iaakob i aaraaring lenbi, “A God anun tabung Aabaraam, ma a God anun tamaang Aaisaak, ui a Tadaaru baa u piri taang naa, ang waan talili balet kup anung taamaan ma ra kum kakung, ma ui ut un waraaut iaau. ");
INSERT INTO rai_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Iaau anum tultul ku, iaku pa iaau koina kup anum maarmaari ma ra num lingtatuna na mangamangaan baa u paampaami karom iaau. Namuga baa iaau waan likaai a daanim Ioridaan, pa iaau lo ta kum utnaa, anung ina buka ku. Ma mi baa iaau waan talili, miaat ru kikil ma. ");
INSERT INTO rai_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Iaau aaraaring baa un walaaun iaau ko ra limaan tenglik Esaau, maa iaau burut kaduk in waan urin ma in um iaau ungaai ma ra kum naat liklik ma ra kum nanaandiat. ");
INSERT INTO rai_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Iaku ui ut u aa pir taai taang naa, un waraaut iaau ma un wabure anung wuna taara, welaar ma ra woio taanga nakono, baa pa in te in luk laar paai.” ");
INSERT INTO rai_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","U ra bung na marum maa, Iaakob i ngo matira. Ma ko ra nuna kum wewagua ut i pilak paa raa kum wewagua baa in tabaara tenalik Esaau mai: ");
INSERT INTO rai_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 na tabuan na me, ma 20 muaanaina, 200 na tabuan na sip, ma 20 muaanaina, ");
INSERT INTO rai_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 tabuan na kaamel ma ra kum natnatundiat, 40 tabuan na bulumakaau ma 10 muaanaina, 20 tabuan na dongki ma 10 muaanaina. ");
INSERT INTO rai_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Iaakob i maadek taa a kum wewagua mi u ra binaboura anu ra kum tultul, ma i piri taan diat naa, “Muaat a muga taang, ma muaat a weraana a kum wewagua, ma muaat a taar ta kum kolo naliwan taa ra kum kikil na wewagua.” ");
INSERT INTO rai_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","I wapua taa a tultul baa i muga taan diat naa, “Baa tenglik Esaau in baraata ui, ma in tiri ui naa, ‘Ui anun woi, ma un waan uwaai, ma anun woi a kum wewagua mi diat mukmuga taam?’ ");
INSERT INTO rai_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Io, un piri naa, ‘Anu ra num tultul Iaakob, kuraa i murmur taamiaat. Ma a kum wewagua mi a kum wetabaar anuna karom ui, anuna tadaaru.’” ");
INSERT INTO rai_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","I wapua taa kaai a weru tultul, a wetula tultul, ma diat raap baa diat weur ungaai ma ra kum kikil na wewagua naa, “Muaat raap muaat a pir ku raa pirpir mi, baa tenglik Esaau in baraata muaat. ");
INSERT INTO rai_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ma muaat a nuk paai, muaat a piri naa, ‘Anum tultul Iaakob kuraa i murmur taamiaat.’” I nuki naa, “Ang wamaalmaal muga paa a nuknukina ma ra kum wetabaar bi ang taar muga wai karomi. Namur baa ang baraata paai, kaduk in gaaia pa iaau.” ");
INSERT INTO rai_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Io, a kum wetabaar anun Iaakob diat muga waanwaan taana, iaku ia ut i ki akot ku matira u ra bung na marum maa. ");
INSERT INTO rai_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","U ra bung na marum ut maa, Iaakob i tawaangun ma i ben paa anuna ru tabuan, a ru tultul na tabuan ma noina ma raa natnatuna, ma i tula bolo wa diat kup raa papaara daanim Iaabok u ra wanua baa di waanwaan bolo iaai. ");
INSERT INTO rai_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Baa ia tula bolo wa diat, i taar bolo wa bulung anuna kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Iaakob maku i ki matira, ma raa muaana i waan paat karomi ma i raat paai ma diaar wegunaar taltalili maku matira, tuk baa i keke taau un diaar. ");
INSERT INTO rai_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Baa a muaana maa i kariaanai naa pa i dekdek paa ma Iaakob, i papaam pari kup a kakanaawa u ra titin Iaakob ma i biu puku taai ma i takiraa. ");
INSERT INTO rai_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","A muaana maa i piri naa, “Un paki wa iaau baa ang waan maa ia keke.” Iaku Iaakob i baalui naa, “Pang paki wa ui, tuk ut baa un pir wadaan ta iaau.” ");
INSERT INTO rai_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Io, a muaana maa i tiri naa, “Woi na iaam?” Iaakob i baalui naa, “A iaang Iaakob.” ");
INSERT INTO rai_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","A muaana maa i piri naa, “A iaam wakir balet ma Iaakob, a iaam Israael, kabina maa u wegunaar ungaai ma God, ma ra taara, ma u aa uwia paai.” ");
INSERT INTO rai_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iaakob i piri naa, “In koina baa un waatung taa a iaam taang.” Iaku i baalui naa, “I lawaai maa u wetiri kup a iaang?” Ma i pir wadaan taa Iaakob matira. ");
INSERT INTO rai_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Io, Iaakob i waatung taa a wanua maa Peniel, ma i piri naa, “A kabina maa iaau babo a mataan God, ma iaau aa lalaaun pilaa.” ");
INSERT INTO rai_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","A mage i waan tato waanwaan ma Iaakob i waan paa ko ra wanua maa baa i waatung taai ma Peniel, ma i waan bukabuka maku, kabina u ra kakanaawa u ra titina baa i takiraa. ");
INSERT INTO rai_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Io, tuk u ra bung mi, a taara Israael pa diat aan a lolo ko ra kakanaawa i ra titi ra kum wewagua, maa kabina di biu puku taa a kakanaawa u ra titin Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Iaakob i babo kado, ma i babo paa Esaau diat waan karomi ungaai ma ra nuna 400 na muaana. Io, i weraana a kum natnatuna karom a kum nanaandiat, Leaa, Raakel ma ra ru tultul na tabuan kaai. ");
INSERT INTO rai_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","I watur taa a ru tultul na tabuan ma ra kum natnatundiaar namuga, namur Leaa ma ra kum natnatuna, io, Raakel ma Iosep namur aakit. ");
INSERT INTO rai_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Iaakob i muga pa diat kupi diat a waan baraata tenalik. Baa i marawaai karomi, i maatudung waanwaan ma ra mataana unapia ma ra urur karomi welaar ma 7 na pakaan. ");
INSERT INTO rai_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Iaku Esaau i gaaia paa Iaakob, i welulu baraatai, i raat paai, ma i dum a papaara waana ma diaar luan. ");
INSERT INTO rai_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Baa Esaau i babo paa a kum tabuan ma ra kum naat liklik, i wetiri naa, “Woi diat mi ungaai ma ui?” Iaakob i baalui naa, “Anung tadaaru, anung kum naat ut mi. God i maari iaau ma i tabaara iaau ma diat.” ");
INSERT INTO rai_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Io, a ru tultul na tabuan ma nundiaar kum naat diat waan marawaai karom Esaau, ma diat kaai diat maatudung karomi. ");
INSERT INTO rai_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Namur Leaa ma ra nuna kum naat bulung diat maatudung karomi, ma namur aakit Raakel ma Iosep diaar waan ma diaar maatudung karomi. ");
INSERT INTO rai_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaau i tiri Iaakob lenbi, “Iaau baraata muga anum kum wewagua. Aawa kabina maa u tula muga wa diat?” Iaakob i baalui naa, “Anung tadaaru, iaau tula muga wa diat kupi un maraam pa iaau.” ");
INSERT INTO rai_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaau i baalui balet naa, “Tenglik, anung kum wewagua kaai diat teng. Aawa baa anum un paam kotoi.” ");
INSERT INTO rai_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Iaakob i worwor ku naa, “Painte, baa u aa maraam pa iaau, un taraam paa anung kum wetabaar. Ma baa iaau babo ui, i lenkubaa iaau babo a mataan God, ma mi u aa maraam mulu pa iaau. ");
INSERT INTO rai_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Un taraam paa anung kum wetabaar baa iaau tabaara ui mai. Maa God i maari aakit iaau, ma aawa raap baa iaau nemi iaau aa watur kotoi.” Baa ut Iaakob i worwor liklik, io, Esaau i taraam maraagaam. ");
INSERT INTO rai_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ma Esaau i piri taana naa, “Io, daat a waan. Daat a weur maku.” ");
INSERT INTO rai_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Iaakob i piri karomi naa, “Anung tadaaru, u nunurai naa anung kum naat diat aa bilua u ra winawaan, ma ang baboura diat ungaai ma ra kum sip ma ra kum bulumakaau baa diat wewangaau. Baa din wararaak diat un raa kudulaana bung, a kum wewagua raap diat a maat. ");
INSERT INTO rai_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Un maadek wa iaau anum tultul. Un muga, ma iaau ang waan murmur a winawaan i ra nung kum wewagua ma ra nung kum naat liklik, tuk baa miaat a waan paat karom ui irong Seir.” ");
INSERT INTO rai_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaau i piri naa, “Ang maadek taa anung ta taara ungaai ma ui.” Iaakob i baalui, “Anung tadaaru, maadek wai. A utnaa ku baa iaau nemi maa u aa maraam pa iaau.” ");
INSERT INTO rai_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Io, u ra bung ut maa Esaau i tur paa ma i waan talili balet urong Seir. ");
INSERT INTO rai_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Iaku Iaakob i waan urong Sukot, ma matira i watur anuna ruma na sel ma ra kum palpalip anu ra nuna kum wewagua. Io, di waatung taa a wanua maa ma Sukot. ");
INSERT INTO rai_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Baa Iaakob i waan taangirong Mesopotaamia, i waan paat irong u ra pia Kaanaan, ma pa i baraata ta mawaat u ra nuna winawaan. Ma i watur anuna ruma na sel marawaai naa ra taamaan Sekem. ");
INSERT INTO rai_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Iaakob i kul paa a pakaana pia baa i watur a kum ruma na sel iaai, ma 100 na pakaana silwa ko ra kum natnatun Aamor, Aamor a tamaan Sekem. ");
INSERT INTO rai_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Matira i paam paa a wunuwung na waat na tuntun wetabaar, ma i waatung taa a wuwuwung maa baa El Eloi Israael. ");
INSERT INTO rai_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, a tauraara, a natun Leaa ma Iaakob, i waan kupi in lauma a kum tabuan irong u ra taamaan Sekem. ");
INSERT INTO rai_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Aamor, a te Kiwi ma a mukmuga ko ra taamaan maa. Natunalik Sekem i babo paa Dina, i paam koto paai, ma i paam aakaina uni. ");
INSERT INTO rai_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Namur anuna nemnem kup Dina a natun Iaakob i ngaala aakit. I nem aakiti, ma i pir a kum wakwakaak na pirpir karomi. ");
INSERT INTO rai_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ma Sekem i piri karom tamaana Aamor lenbi, “Un kul taa a tabuan mi, kupi anung taulaa.” ");
INSERT INTO rai_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Baa Iaakob i walangoroi naa di aa paam taa aakaina un Dina, i ki wowon paa a kum natnatuna, baa kuraa utbaai diat ma ra kum wewagua nabuaal. ");
INSERT INTO rai_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Namur tamaan Sekem i waan paat kupi in pirpir ungaai ma Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ma a kum natnatun Iaakob kaai diat waan paat ku taanga nabuaal. Baa diat walangoro aawa baa ia waan paat, diat tapunuk ma diat kaankaan dekdek aakit, kabina Sekem ia paam taa raa utnaa karom diat a taara Israael, i raat paa natun Iaakob, a mangamangaan baa i taabu baa te in paami. ");
INSERT INTO rai_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Iaku Aamor i piri taan diat naa, “Natunglik Sekem i nem dekdek aakit a natumuaat. Iaau aaring na maarmaari pa muaat, muaat a mulaaot taa Dina kupi anuna taulaa. ");
INSERT INTO rai_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Daat a taulaa wetwetalaai. Muaat, muaat a taulaa ma ra kum natnatumiaat, ma miaat, miaat a taulaa ma ra kum natnatumuaat. ");
INSERT INTO rai_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Muaat a ki ma naliwan taamiaat. A pia i laangalaanga ku karom muaat, muaat a ki uni, muaat a wiura uni, ma muaat a kul paa ta pia kupi anumuaat.” ");
INSERT INTO rai_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekem i piri karom tamaan Dina ma ra kum tatein Dina naa, “Baa muaat maari iaau, io, aawa baa muaat nemi ang taari. ");
INSERT INTO rai_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Muaat a luk taa a winekul i ra tabuan, ma ta utnaa kaai baa muaat nemi naa ang taari, baa in lelawaai, ang kuli ut. Iaku muaat a mulaaot taa ku a tabuan kupi anung taulaa.” ");
INSERT INTO rai_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","A kum natnatun Iaakob pa diat pir ma ta lingtatuna na pirpir karom Sekem ma tamaana Aamor, kabina maa di aa paam taa aakaina karom a teindiat Dina. ");
INSERT INTO rai_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Diat piri karom diaar naa, “Pate, a utnaa na wawirwir baa miaat a taar a teimiaat karom ta muaana baa pa te i poko kikili. Mi ia a naagagon baa i ngaatngaat karom miaat. ");
INSERT INTO rai_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Miaat a mulaaot taa a teimiaat karom ui, baa un paam ku raa utnaa bi: A kum muaana raap kon muaat din poko kikil diat welaar ma miaat. ");
INSERT INTO rai_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Io, muaat a taulaa ma ra kum natnatumiaat, ma miaat a taulaa ma ra kum natnatumuaat. Ma daat a ki ungaai main, ma daat a raa maku. ");
INSERT INTO rai_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Baa pa muaat a taraam kupi din poko kikil muaat, io, miaat a ben paa a teimiaat ma miaat a waan.” ");
INSERT INTO rai_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Aamor ma natunalik Sekem diaar gaaia u ra pirpir maa. ");
INSERT INTO rai_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekem ia a mugaana natun Aamor, baa diat raap u ra ruma anun Aamor diat rui, pa i ki wa ta pakaana bung, i taraam gagaa, maa kabina i nem dekdek aakit a natun Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Io, Aamor ma natunalik Sekem diaar waan kup a bonanaaka i ra taamaan, kupi diaar a wewapua uni karom a taara ko ra taamaan maa. ");
INSERT INTO rai_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Diaar piri lenbi, “A taara mi, anundiat koina mangamangaan karom daat. Daat a maadek wa diat baa diat a ki min u ra nundaat kum pia, ma diat a wiura uni, maa mongoro na wanua kupi diat a lalaaun uni. Daat a taulaa ma ra kum natnatundiat, ma diat kaai diat a taulaa ma ra kum natnatundaat. ");
INSERT INTO rai_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Iaku raa utnaa diat nemi kon daat, naa daat raap din poko kikil daat welaar ma diat, kupi daat a lalaaun ungaai ma diat, ma daat a raa maku. ");
INSERT INTO rai_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nuk paai! Baa daat a taraam, anundiat kum wewagua, ma ra kum utnaa raap, anundaat raap maku. Io, daat a mulaaot taau karom diat, kupi diat a lalaaun naandaat.” ");
INSERT INTO rai_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","A kum muaana raap baa diat waan ungaai naa ra bonanaaka i ra taamaan, diat mulaaot ungaai ma Aamor ma natunalik Sekem, ma a kum muaana raap ko ra taamaan maa, di poko kikil diat. ");
INSERT INTO rai_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tula bung baat taai, baa kuaa utbaai diat kariaana a ngunungut, a ru natun Iaakob, Simion ma Lewi, a ru tatein Dina mulu baa raa naanditul, diaar lo paa anundiaar ruin liwan na wineium, ma diaar waan paat kakaian irong Sekem. Ma diaar aak doko wa a kum muaana raap. ");
INSERT INTO rai_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Diaar aak doko wa kaai Aamor ma natunalik Sekem, ma diaar ben paa Dina ko ra nuna ruma, ma ditul waan. ");
INSERT INTO rai_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Namur a kum natnatun Iaakob balet diat waan taau u ra kum minaat, ma diat walong u ra taamaan, baa di paam aakaina karom a teindiat Dina iaai. ");
INSERT INTO rai_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Diat walong raap paa a kum sip, a kum me, a kum bulumakaau ma ra kum dongki, ma ra kum utnaa raap baa ko ra nundiat taamaan, ma ko ra andiat kum pinapaam kaai. ");
INSERT INTO rai_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Diat lo raap paa anundiat kum utnaa raap, ungaai ma ra utnaa kaai ko ra kum rumruma. Ma diat aal paa kaai anundiat kum tabuan ma ra kum naat liklik. ");
INSERT INTO rai_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ma Iaakob i piri karom Simion ma Lewi lenbi, “Mur aa paam taa a mawaat karom iaau. Ma mi, iaau aa welaar ma ma ra aangina na utnaa u ra mataa ra taara Kaanaan ma Peris, a taara baa kuri diat lalaaun u ra pia mi. Daat pa daat ngaala, ma diat baa diat a tur ungaai, ma diat a weium ungaai ma daat, daat raap daat a maat.” ");
INSERT INTO rai_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Iaku diaar baalui naa, “Lelawaai, mir a maadek wa ku a teimir baa din paam aakaina uni, welaar ma ra paamuk na tabuan?” ");
INSERT INTO rai_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","God i piri karom Iaakob naa, “Un waan ma un ki irong Betel ma un paam ta wunuwung na waat na tuntun wetabaar karom iaau, u ra wanua baa iaau aa waan paat paa mun karom ui iaai, baa u welulu ino paa kon temlik Esaau.” ");
INSERT INTO rai_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Io, Iaakob i piri karom diwaatamaana ut, ma diat kaai baa diat ki u ra nuna naagagon naa, “Muaat a rakaan wa a kum taabataaba na god anu ra taara ingen baa kuraa ut naamuaat, muaat a wagomgom pa muaat, ma muaat a kiaana wa anumuaat kum maalu. ");
INSERT INTO rai_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ma daat a waan tato unaanga Betel, ma ang paam ta wunuwung na waat na tuntun wetabaar karom God. Maa i waraaut iaau u ra bung baa anung lalaaun i purpuruan, ma i ki ungaai ma iaau u ra kum wanua raap baa iaau aa waan paa iaai.” ");
INSERT INTO rai_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Io, diat taar raap taa a kum taabataaba na god, ma ra kum ring ko ra talingaandiat karom Iaakob, ma Iaakob i punang wa diat natudaangi ra in ngaala na diwaai irong Sekem. ");
INSERT INTO rai_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ma namur diat waan. Ma a dekdek na bunurut baa God i taar wai, i lo a kum taamtaamaan baa a taara Israael diat waan marawaai naan diat, ma pa diat baanaakaka a taara Israael. ");
INSERT INTO rai_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Iaakob ma ra taara raap baa diat weur mai, diat waan paat irong u ra taamaan Lus, baa di waatungi kaai baa Betel, u ra pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Matira i paam taa a wunuwung na waat na tuntun wetabaar karom God, ma i waatung taa a wanua maa baa El Betel, kabina maa God ia waan paat paa karomi iaai, u ra pakaana bung baa i welulu paa kon tenalik. ");
INSERT INTO rai_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deboraa, a tabuan baa i baboura Rebekaa tur paai baa i naat, i maat, ma di punang taai natudaangi ra in diwaai matira marawaai Betel. Io di waatung in diwaai maa baa In Diwaai na Niluan. ");
INSERT INTO rai_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ma un raa bung balet, baa Iaakob i waan talili taangirong Mesopotaamia, God i waan paat paa karomi a weru pakaan, ma i pir wadaan taai. ");
INSERT INTO rai_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ma i piri taana naa, “A iaam Iaakob, iaku wakir balet ma din waatung ui baa Iaakob, a iaam maa Israael.” Io, i waatung taai baa Israael. ");
INSERT INTO rai_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma God i piri taana kaai lenbi, “Iaau God baa iaau Dekdek Aakit. Muaat a babuta ma muaat a wabure muaat. Ma a kum ngaala na wunwuna taara diat a waan paat kon ui. Ma un waan paat a tamaa ra kum king kaai. ");
INSERT INTO rai_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","A pia baa iaau taari taan Aabaraam ma Aaisaak, mi iaau taari taam, ma karom anum wuna taara namur taam.” ");
INSERT INTO rai_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ma God i waan tato balet koni, ko ra wanua baa diaar pirpir iaai. ");
INSERT INTO rai_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Iaakob ia watur taa a toro na waat u ra wanua baa God ia pirpir paa karomi iaai, ma i labo taa a waain ma ra wel nate uni, welaar ma ra wetabaar karom God. ");
INSERT INTO rai_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ma i waatung taa a wanua baa diaar pirpir ungaai ma God iaai, naa Betel. ");
INSERT INTO rai_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Diat waan ko ra taamaan Betel, ma baa diat waan waanwaan marawaai kup a taamaan Epraat, Raakel i kariaanai naa marawaai ma in babuta, iaku anuna binabuta pa i koina. ");
INSERT INTO rai_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Baa i kariaana a ngaala na ngunungut, a tabuan baa i waraauti u ra binabuta i piri taana naa, “Koku u burut, maa u aa buta paa balet raa naat muaana.” ");
INSERT INTO rai_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Baa marawaai ma in maat, i lo dadaip tintinip paa, ma i waatung taa a iaan natunalik baa Benoni. Io, i maat. Iaku tamaana i taar taa a iaa ra naat baa Beniaamin. ");
INSERT INTO rai_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Baa Raakel i maat, diat punang taai u ra papaara aakapi baa i waan kup Epraat, baa di waatungi kaai naa Betilem. ");
INSERT INTO rai_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Iaakob i watur taa a toro na waat nate u ra tung na minaat in Raakel, ma tuk mari a toro na waat maa i tur na aaim u ra nuna tung na minaat. ");
INSERT INTO rai_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israael i kakaraai balet ma i watur anuna ruma na sel namur taan Migdaal Eder. ");
INSERT INTO rai_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Baa Israael diat, diat ki u ra taamaan maa, Ruben i ruk ma i inep ungaai ma Bilaa a tabuan anun tamaana, ma Israael i walangoro a pirpir u ra pinapaam mi Ruben i paami. A 12 a kum naat muaana, a kum natnatun Iaakob, bari diat: ");
INSERT INTO rai_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","A kum natnatun Leaa: Ruben, a mugaana natun Iaakob, pataap Simion, Lewi, Iudaa, Isaakaar, ma Sebulon. ");
INSERT INTO rai_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","A ru natun Raakel: Iosep ma Beniaamin. ");
INSERT INTO rai_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","A ru natun Bilaa, a tultul na tabuan anun Raakel: Daan ma Naaptaali. ");
INSERT INTO rai_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","A ru natun Silpaa, a tultul na tabuan anun Leaa: Gaad ma Aaser. Bi diat a kum natnatun Iaakob, a kum naat muaana baa di buta diat irong Mesopotaamia. ");
INSERT INTO rai_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iaakob i waan paat karom tamaana Aaisaak u ra taamaan Maamre, marawaai Kiriaat-Aarbaa, baa di waatungi kaai baa Ebron, a taamaan baa Aabaraam ma Aaisaak diaar ki paa iaai. ");
INSERT INTO rai_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Aaisaak i takaana aakaka. I lalaaun paa 180 kilaala. Ma i ung wa anuna lalaaun, ma i maat. Ma a ru natnatuna, Esaau ma Iaakob diaar punang wai. Io, Aaisaak i ngo welaar ma ra nuna taara baa diat maat namuga taana. ");
INSERT INTO rai_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Bi ia a niluluk i ra wuna taara anun Esaau, baa di waatungi kaai naa Edom. ");
INSERT INTO rai_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaau i taulaa ma tula tabuan Kaanaan, Aadaa, Olibaamaa ma Baasemaat. Aadaa a natun Elon a te Ket, ma Olibaamaa a natun Aanaa, ma Aanaa a natun Sibion a te Kiwi. ");
INSERT INTO rai_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ma Baasemaat a tein Nibaaiot, a ru natun Ismaael. ");
INSERT INTO rai_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aadaa i buta taa Elipaas un Esaau, ma Baasemaat i buta Rewel. ");
INSERT INTO rai_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ma Olibaamaa i buta Ieus, Iaalam ma Koraa. Bi a kum natnatun Esaau, a kum naat muaana baa di buta ta diat uni irong Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaau i ben paa anuna tula tabuan, a kum natnatuna a kum muaana ma ra in tabuan, ma diat raap baa diat ki ungaai mai, ungaai ma ra nuna kum wewagua raap. Ma i lo paa anuna kum utnaa raap taangirong Kaanaan, ma i kakaraai kup a pakaana i ki welwelik kon tenalik Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Anundiaar kum utnaa ma ra kum wewagua raap i bure aakit, ma a pia baa diaar ki uni pa i ngaala kup diaar a ki ungaai uni. ");
INSERT INTO rai_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Io, Esaau baa di waatungi kaai naa Edom, i lalaaun irong Seir, a wanua na taangaai. ");
INSERT INTO rai_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Bi ia a niluluk i ra wuna taara anun Esaau, a tamaa ra taara Edom, baa diat ki irong Seir, a wanua na taangaai. ");
INSERT INTO rai_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Bi diat a iaa ra kum natnatun Esaau a kum naat muaana: Elipaas a natun Aadaa, a tabuan anun Esaau, ma Rewel a natun Baasemaat, a tabuan utkaai anun Esaau. ");
INSERT INTO rai_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Bi diat a iaa ra kum natnatun Elipaas a kum naat muaana: Temaan, Omaar, Sepo, Gaataam ma Kenaas. ");
INSERT INTO rai_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipaas a natun Esaau i taulaa utkaai ma raa tultul na tabuan, a iaana Timnaa, ma i buta taa raa naat muaana un Elipaas, a iaana baa Aamalek. Diat bi a kum taptabun Aadaa a tabuan anun Esaau. ");
INSERT INTO rai_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Bi diat a iaa ra kum natnatun Rewel a kum naat muaana: Naakat, Seraa, Saamaa ma Misaa. Diat bi a kum taptabun Baasemaat, a tabuan anun Esaau. ");
INSERT INTO rai_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Bi ditul a iaa ra tula natnatun Olibaamaa, a tabuan anun Esaau: Ieus, Iaalaam ma Koraa. Olibaamaa a natun Aanaa, ma Aanaa a natun Sibion. ");
INSERT INTO rai_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","A kum natnatun Elipaas, a mugaana natun Esaau, diat a kum mukmuga u ra kum aapaapik na wuna taara kon Esaau. Diat a kum mukmuga kon Elipaas baa diat ki irong Edom, a kum taptabun Aadaa. Bi diat: Temaan, Omaar, Sepo, Kenaas, Koraa, Gaataam ma Aamalek. ");
INSERT INTO rai_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Bi diat a kum natnatun Rewel a natun Esaau: Naakat, Seraa, Saamaa ma Misaa. Diat a kum mukmuga i ra kum aapaapik na taara kon Rewel irong Edom, diat a kum taptabun Baasemaat a tabuan anun Esaau. ");
INSERT INTO rai_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Bi ditul a kum natnatun Olibaamaa a tabuan anun Esaau: Ieus, Iaalaam ma Koraa. Ditul bi a tula mukmuga i ra tula aapaapik na taara ko ra tabuan anun Esaau, Olibaamaa, a natun Aanaa. ");
INSERT INTO rai_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Diat raap mi a kum mukmuga i ra kum aapaapik na taara ko ra wuna taara anun Esaau, baa di waatungi kaai naa Edom. ");
INSERT INTO rai_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Bi diat a kum natnatun Seir a te Orit: Lotaan, Sobaal, Sibion, Aanaa, Dison, Eser ma Disaan. Diat bi kuraa diat lalaaun u ra pia Seir, ma diat a kum mukmuga baa diat ki irong Edom. ");
INSERT INTO rai_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Bi diaar a iaa ra ru natun Lotaan, a ru naat muaana: Ori ma Emaan. Lotaan diaar tenalik ma Timnaa, a tabuan. ");
INSERT INTO rai_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Bi diat a iaa ra kum natnatun Sobaal a kum naat muaana: Aalwan, Maanaat, Ebaal, Sepu ma Onaam. ");
INSERT INTO rai_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Bi diaar a iaa ra ru natun Sibion a ru naat muaana: Aaia ma Aanaa. Aanaa, baa i baat paa a polo wuwan baa i waan paat ko ra pia, u ra bil na wanua, baa i bababoura a kum dongki anun tamaana Sibion. ");
INSERT INTO rai_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Bi diaar a iaa ra ru natun Aanaa: Dison ma Olibaamaa a tabuan. ");
INSERT INTO rai_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Bi diat a iaa ra kum natnatun Dison: Emdaan, Esbaan, Itraan ma Keraan. ");
INSERT INTO rai_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Bi ditul a iaa ra tula natnatun Eser: Bilaan, Saawaan ma Aakaan. ");
INSERT INTO rai_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Bi diaar a iaa ra ru natun Disaan: Us ma Aaraan. ");
INSERT INTO rai_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Bi diat a kum mukmuga ko ra taara Orit: Lotaan, Sobaal, Sibion, Aanaa, ");
INSERT INTO rai_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser ma Disaan. A kum mukmuga mi, diat tur wakilang ut nundiat kum aapaapik na taara u ra pia Seir. ");
INSERT INTO rai_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Bi diat a kum king baa diat naagagon namuga irong Edom, baa a taara Israael pa nundiat ta king utbaai. ");
INSERT INTO rai_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Belaa, a natun Beor, ia a mugaana king irong Edom. Anuna taamaan di waatungi baa Dinabaa. ");
INSERT INTO rai_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Baa Belaa i maat, Iobaab a natun Seraa taanga Bosraa, ia bulung i king. ");
INSERT INTO rai_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Baa Iobaab i maat, Usaam ko ra pia anu ra taara Temaan, ia bulung i king. ");
INSERT INTO rai_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Baa Usaam i maat, Aadaad a natun Bedaad, baa i uwia paa a taara Midian u ra pia Moaab, ia bulung i king. Anuna taamaan di waatungi baa Aawit. ");
INSERT INTO rai_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Baa Aadaad i maat, Saamlaa ko ra taamaan Mesrekaa, ia bulung i king. ");
INSERT INTO rai_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Baa Saamlaa i maat, Saaul ko ra taamaan Reobot, naa ra daanim Eupraat, ia bulung i king. ");
INSERT INTO rai_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Baa Saaul i maat, Baal-Aanaan a natun Aakbor, ia bulung i king. ");
INSERT INTO rai_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baa Baal-Aanaan a natun Aakbor i maat, Aadaad bulung i king. Anuna taamaan di waatungi baa Paau. A iaa ra nuna tabuan Metaabel a natun Maatred, ma Maatred a naatun Mesaab. ");
INSERT INTO rai_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esaau a tamaa ra taara Edom. Ma diat bi a kum mukmuga u ra kum wunwuna taara anun Esaau. Diat ki wemur welaar ut ma ra nundiat kum aapaapik na taara, ma welaar utkaai ma ra kum pakpakaana pia anundiat. A iaa ra kum mukmuga bi diat: Timnaa, Aalwaa, Ietet, Olibaamaa, Elaa, Pinon, Kenaas, Temaan, Mibsaar, Maagdiel ma Iraam. Diat bi maa a kum mukmuga kon Edom, welaar ut ma ra nundiat kum kinkini u ra kum pakpakaana pia baa diat papaam iaai. ");
INSERT INTO rai_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iaakob i ki u ra pia baa tamaana i ki paa iaai, a pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Bi ia a aakaakur in Iaakob diwaatamaana. Iosep a baarmaan na muaana, 17 na kilaala anuna, ma i laana baboura a kum wewagua, ungaai ma ra kum tateina a kum naat muaana diat baa a kum natnatun Bilaa ma Silpaa, a ru tabuan anun tamaana Iaakob. Ma i laana wapua a tamaandiat u ra kum aakaina utnaa baa a kum tateina diat laana paami. ");
INSERT INTO rai_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iaakob, baa raa iaana kaai Israael, i nem dekdek aakit Iosep ko ra kum natnatuna raap, kabina maa di buta paai baa Iaakob ia takaana. Ma i taar taa in koina maalu na minong karomi. ");
INSERT INTO rai_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Baa a kum tatena liklik diat baboi naa tamaandiat i nem dekdek aakit Iosep kon diat, diat nget Iosep ma pa diat laana pir ta koina pirpir karomi. ");
INSERT INTO rai_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Iosep i beberon ma i wapua taa a kum tateina uni. Baa diat walangoroi, diat nget dekdek aakiti maraagaam. ");
INSERT INTO rai_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I piri taan diat lenbi, “Muaat a walangoro a beberon bi. ");
INSERT INTO rai_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Daat wi ungaai taa a kum pakpakut na wit u ra pinapaam. Pa i iwan ku, anung raa pakut i tur takado ma anumuaat raa mangaan diat tur lili paa anung raa, ma diat talukun karomi ma ra urur.” ");
INSERT INTO rai_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Baa kum tateina diat walangoroi, diat piri karomi naa, “U nuki naa ui ma maa a king anumiaat? A dawotina ut maa un naagagon miaat?” Ma diat nget dekdek aakiti kabina u ra beberon ma u ra aawa baa ia pir taai. ");
INSERT INTO rai_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ma namur i beberon balet, ma i wapua a kum tateina uni lenbi, “Muaat a walangoro anung raa beberon balet. A kalaang, in mataana mage ma noina ma raa ina naangnaang diat ki but keke karom iaau.” ");
INSERT INTO rai_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Baa i wapua tamaana ma ra kum tateina uni, tamaana i kaankaan karomi ma i piri lenbi, “U nuki naa miaat ma naam ma ra kum tatem liklik, miaat a waan paat ma miaat a ki but keke unapia karom ui?” ");
INSERT INTO rai_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A kum tateina diat nuknuk aakaka karomi, iaku a tamaandiat i paam akoto a utnaa mi u ra nuknukina. ");
INSERT INTO rai_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Io, a kum tatein Iosep diat waan kupi diat a baboura a kum wewagua anu ra tamaandiat marawaai Sekem. ");
INSERT INTO rai_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ma Iaakob, baa di waatungi kaai naa Israael, i piri karom Iosep, “U nunurai naa a kum tatem liklik kuraa diat baboura a kum wewagua marawaai Sekem. Ang tula wa ui karom diat.” Iosep i baalui naa, “Koina ku.” ");
INSERT INTO rai_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ma i piri karomi naa, “Waan ma un babo taa a kum tatem liklik ungaai ma ra kum wewagua, diat koina ku, baa pate. Ma un waan talili ma un wapua iaau.” Io, i tula wai taangirong u ra maale in Ebron, ma i waan urong Sekem. Baa Iosep i waan paat, ");
INSERT INTO rai_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","raa muaana i waan taau uni kuraa ma i baat taltalili u ra kum wanua, ma i tiri naa, “Aawa maa u baatbaat kupi?” ");
INSERT INTO rai_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","I baalui naa, “Iaau babo kup a kum tateng liklik. I koina ku baa un pir waiaa taa a wanua baa kuraa diat baboura a kum wewagua iaai?” ");
INSERT INTO rai_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","A muaana maa i baalui naa, “Diat aa waan karaai taanga min. Iaau walangoro ta diat, diat piri naa diat a waan urong Dotaan.” Iosep i waan murmur a kum tatena liklik, ma i baat pa diat marawaai Dotaan. ");
INSERT INTO rai_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Diat babo wai taanga welwelik utbaai ma diat wepaak paa naa, diat a aak doko wai. ");
INSERT INTO rai_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Diat pirpir ungaai paa lenmi, “A tena beberon bari ma ia i waan urin. ");
INSERT INTO rai_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Muaat iaap, daat a aak doko wai ma daat a ong ruk taai u ra tung na daanim baa pa ta palaa uni, ma daat a piri naa raa lomlom na wewagua ia aak doko wai. Namur daat a babo aawa in waan paat ko ra nuna kum beberon.” ");
INSERT INTO rai_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Baa Ruben i walangoroi i nuknuk kup ta aakapi kupi in walaaun paa Iosep kon diat, ma i piri lenbi, “Koku daat aak dokoi. ");
INSERT INTO rai_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Koku ta gaap i waan koni. Daat a ong ruk taai ku u ra tung na daanim baa pa ta palaa uni, bari ia u ra bil. Iaku koku te i baanaakakai.” Ruben i piri lenmi kupi in walaaun paai kon diat ma in ben talili taai karom tamaana. ");
INSERT INTO rai_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Baa Iosep i waan paat karom a kum tatena liklik, diat paam koto paai, ma diat paa wa anuna koina maalu na minong, baa i ruk uni. Ma diat ong darong taai u ra tung na daanim baa pa ta palaa uni. ");
INSERT INTO rai_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Baa diat ki kupi diat a wangaan, diat babo kado ma diat babo paa raa kikil na taara Ismaael diat waan taanga Giliaad. Anundiat kum kaamel i teng ma ra kum kokoina aangaangawian na utnaa, a ngaatngaat na marasin ma ra mira, ma diat waan waanwaan kupi diat a lo a kum utnaa maa urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Iuda i piri karom a kum tatena liklik naa, “In waraaut daat lelawaai baa daat a aak doko wa a teindaat, ma daat a walipa paa anundaat mangamangaan? ");
INSERT INTO rai_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Muaat iaap gagaa, daat a wiura paai karom a taara Ismaael ma koku daat aak dokoi, maa teindaat mulu ut mi, raa gaapindaat ma raa panindaat ku.” Ma a kum tatena liklik diat taraam. ");
INSERT INTO rai_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Baa a taara Ismaael, baa a kum tena kunukul taangirong Midian diat waan marawaai, a kum tatena liklik, diat aal tato paa Iosep ko ra tung na daanim, ma diat wiura paai ma ru noina silwa karom a taara Ismaael. Ma diat ben paai urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Baa Ruben i waan talili kup a tung na daanim maa, ma i baboi naa Iosep panaai ma iaai, i rabaana wa anuna maalu, maa kabina i tapunuk aakit. ");
INSERT INTO rai_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I waan talili balet karom a kum tatena liklik ma i piri taan diat, “Iosep panaai ma iaai, ang lawaai ma mi?” ");
INSERT INTO rai_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Io, diat aak doko paa raa me, diat lo paa a minong anun Iosep, ma diat gul paai u ra gaapi ra me. ");
INSERT INTO rai_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Diat loi karom tamaandiat, ma diat piri naa, “Bi ia, miaat baat paai. Un babo lelei kaduk a minong bi anun natumlik?” ");
INSERT INTO rai_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","I babo lele paai ma i piri lenbi, “A minong ut anu ra nung naat mi! Raa karangaap na wewagua ia aan paai. Lingtatuna ut, ia karaat ginagina wa Iosep.” ");
INSERT INTO rai_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ma Iaakob i rabaana wa anuna maalu, ma i ruk paa u ra nuna maalu na tinobo, ma mongoro na bung i ki na tapunuk kup natunalik. ");
INSERT INTO rai_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A kum natnatuna liklik raap, a kum muaana ma ra in tabuan, diat waan karomi kupi diat a wamaraami, iaku pa i taraam karom diat. I piri ku lenbi, “Painte. U ra nung kini na tapunuk mi, ang waan pari ut mai u ra tung na minaat kup anung naat.” Ma i luan kup Iosep. ");
INSERT INTO rai_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","U ra pakaana bung maa, a taara Midian diat wiura wa Iosep irong Aaigipto karom Potipaar. Potipaar a mukmuga anu ra kum tena wineium baa diat laana baboura a ruma anun Paraao. ");
INSERT INTO rai_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","U ra kilaala maa, Iuda i waan paa ko ra kum tatena liklik ma i waan pari kup raa muaana a te Aadulaam a iaana Iraa ma i ki ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Iuda i baraata paa raa tabuan matira, a natun Sua, raa te Kaanaan, ma i taulaa mai. ");
INSERT INTO rai_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A tabuan maa i kipbaala ma i buta paa raa naat muaana ma di taar taa a iaana baa Er. ");
INSERT INTO rai_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I babuta balet ma i buta paa raa naat muaana ma di taar taa a iaana baa Onaan. ");
INSERT INTO rai_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Namur i buta paa balet raa naat muaana ma di taar taa a iaana baa Selaa. I buta paai irong Kesib. ");
INSERT INTO rai_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iuda i baat paa raa tabuan kupi a taulaa anun Er, anuna mugaana naat muaana. Ma a iaa ra tabuan maa Taamaar. ");
INSERT INTO rai_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Iaku Er ia raa tena aakaina namataa ra Tadaaru. Io, a Tadaaru i rakaan wa anuna lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ma Iuda i piri karom Onaan, “Un taulaa ma ra tabuan anun temlik welaar ma ra nundaat mangamangaan. Baa raa muaana i maat paa ko ra nuna tabuan ma pa ta natuna, tenalik in taulaa ma ra tabuan maa, kupi in wangaala taa ta kum natnatun tenalik baa ia maat.” ");
INSERT INTO rai_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Iaku Onaan i nunurai naa a kum naat baa in wangaala diat wakir anuna, io, a pakpakaana bung raap baa i inep ungaai ma ra taulaa anun tenalik, i laana pet biaa wa ku a polo na panina u ra pia kupi koku i wangaala ta kum naat anun tenalik. ");
INSERT INTO rai_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A utnaa baa i paami i aaka namataa ra Tadaaru, io, a Tadaaru i rakaan wa kaai anuna lalaaun. ");
INSERT INTO rai_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ma Iuda i piri taan raa paan diaar tabuna Taamaar naa, “Un ki kumun welaar ma ra walaa u ra ruma anun tamaam tuk natunglik Selaa in ngaala.” Iaku u ra nuknukina, Iuda pa i nemi naa Taamaar in taulaa ma Selaa, maa i nuki lenbi, “Kaduk in maat ku kaai welaar ma ra ru tatena liklik.” Io, Taamaar i waan kupi in ki u ra ruma anun tamaana. ");
INSERT INTO rai_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Namur baa raa kum kilaala i raap, a taulaa anun Iuda, a natun Sua, i maat. Baa Iuda i waraap wa anuna kinkini na tapunuk, i waan tato kup a taamaan Timnaa, kupi in babo a kum muaana baa diat gele anuna kum sip, ma tepaana Iraa a te Aadulaam i waan ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Di wapua taa Taamaar lenbi, “Raa paa mur tabuna in waan lenbi kup a taamaan Timnaa kupi in gele anuna kum sip.” ");
INSERT INTO rai_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Baa Taamaar i walangoroi, i rakaan wa anuna minong na walaa, i burung baat paa a mataana ma raa in mangaana maalu, kupi koku di babo lelei. Ma i ki taau u ra bonanaaka i ra taamaan Enaaim u ra aakapi baa i waan kup a taamaan Timnaa. Maa i baboi naa Selaa ia ngaala ma pa te i taar taai kupi Selaa in taulaa mai. ");
INSERT INTO rai_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Baa Iuda i babo paai i nuki naa raa paamuk na tabuan maa i burung baat paa mataana, ");
INSERT INTO rai_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ma wakir i nuki naa raa paan diaar tabuna. I waan bolo karomi u ra papaara aakapi ma i piri lenbi, “Waan urin ma ang inep ungaai ma ui.” Ma raa paan diaar tabuna i wetiri, “Aawa ma un taari taang baa ang inep ungaai ma ui?” ");
INSERT INTO rai_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Iuda i baalui lenbi, “Ang taar taa anum ta baarmaan na me ko ra nung kum wewagua.” Ma Tamaar i piri naa, “Un taar ta utnaa taang kupi a pet webaat tuk baa un taar wa ta me taang.” ");
INSERT INTO rai_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iuda i piri naa, “Woi na utnaa na pet webaat maa ang taari taam?” I baalui lenbi, “Anum wakilang baa u waketei u ra in kabarom ungaai ma ina aaruina, ma num ina buka baraa ia u ra limaam.” Io, tabuna i taar baat taai ma ra kum utnaa maa, ma i inep ungaai mai, ma Taamaar i kipbaala taau uni. ");
INSERT INTO rai_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Baa Taamaar i waan koni i rakaan wa ina maalu baa i burung baat paa mataana mai, ma i ung paa balet anuna minong na walaa. ");
INSERT INTO rai_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Baa ta kum bung i raap, Iuda i tula wa tepaana a te Aadulaam ma ra baarmaan na me kupi in lo talili paa balet anuna utnaa na pet webaat ko ra paamuk na tabuan, iaku pa i baat paai. ");
INSERT INTO rai_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A te Aadulaam i tiri a taara baa diat lalaaun matira, “Waiaa a paamuk na tabuan baa i laana kiki min u ra papaara aakapi Enaaim?” A taara diat baalui naa, “Pa ta paamuk na tabuan main.” ");
INSERT INTO rai_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Io, a te Aadulaam i waan talili balet karom Iuda ma i piri naa, “Pa iaau baat paai. A taara kaai baa diat lalaaun marong diat piri naa pa ta paamuk na tabuan marong.” ");
INSERT INTO rai_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ma Iuda i piri lenbi, “Maadek wai, in paam koto a kum utnaa maa ia lo paai, kaduk a taara diat a tataur un daar. Iaau taar wa ut a baarmaan na me, iaku a paamuk na tabuan maa panaai ma iaai.” ");
INSERT INTO rai_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Namur baa tula kalaang i raap, Iuda i walangoroi naa, “Taamaar, raa paa mur tabuna, ia paam wa aakaina mangamangaan baa i paam a pinapaam na paamuk, ma ia kipbaala.” Iuda i piri naa, “Din ben pari paai ma din tun doko wai!” ");
INSERT INTO rai_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Baa di ben pari paai, i taar wa a pirpir karom raa paan diaar tabuna lenbi, “Iaau kipbaala taau u ra muaana baa anuna a kum utnaa bi.” I piri kaai naa, “Un babo lele a kum utnaa bi, anun woi a wakilang ma ra ina aaruina, ma ra ina buka kaai?” ");
INSERT INTO rai_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Iuda i babo lele paa a kum utnaa maa, ma i piri naa, “Taamaar i takado aakit kon iaau, kabina maa pa iaau paam ot paa anung weweliman kupi ang taar taai kupi in taulaa ma natung lik Selaa.” Ma Iuda pa i inep ungaai paa balet ma Taamaar. ");
INSERT INTO rai_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Baa a pakaana bung i ot kupi in babuta, i kariaanai naa a ru kataai ut kuraa diaar u ra in balaana. ");
INSERT INTO rai_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Baa i babuta, raa paa ra ru kataai i ung pari muga wa raa limaana. Io a tabuan baa diaar babuta ma Taamaar i lo paa in taar na aaru ma i do taai u ra limaa ra naat, ma i piri lenbi, “Raa bi i pari muga.” ");
INSERT INTO rai_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Iaku baa i aal ruk paa balet a limaana raa paan diaar tenalik i pari, ma a tabuan maa i piri naa, “Ui u aa wowo pari muga pa ui.” Ma di taar taa a iaana naa Peres. ");
INSERT INTO rai_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ma tenalik baa di do taa in taar na aaru u ra limaana, di buta murmuri, ma di waatung taa a naat muaana maa a iaana Seraa. ");
INSERT INTO rai_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Di ben paa Iosep urong Aaigipto. Ma Potipaar a te Aaigipto, a mukmuga anu ra kum tena wineium baa diat laana baboura a ruma anun Paraao, i kul paa Iosep ko ra taara Ismaael baa diat beni urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","A Tadaaru i ki ungaai ma Iosep ma i waraauti kupi anuna pinapaam i taar a waina, ma i lalaaun u ra ruma anun Potipaar, anuna ngaala. ");
INSERT INTO rai_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Baa anuna ngaala i baboi naa a Tadaaru i ki ungaai mai ma i waraauti u ra kum utnaa raap baa i laana paami, ");
INSERT INTO rai_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potipaar i gaaia aakit un Iosep, ma i ung taai kupi in mukmuga anu ra kum tultul raap. I ung taai kupi in naagagon a kum tultul raap u ra nuna ruma, ma i nurnur uni kupi in baboura kaai anuna kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Turpaai u ra bung baa di ung taai kupi in naagagon a ruma ma ra kum utnaa raap anun Potipaar, a Tadaaru i wadaan a utnaa raap u ra ruma maa, kabina un Iosep. A Tadaaru i wadaan a kum utnaa raap anun Potipaar u ra nuna ruma ma u ra ana pinapaam. ");
INSERT INTO rai_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Io, Potipaar i maadek taa a kum utnaa raap baa anuna u ra binaboura anun Iosep. Baa Iosep i naagagon, Potipaar pa i nuknuk balet ma un ta pinapaam, i nuknuk maku u ra utnaa na winangaan baa i aani. Iosep i tawa ma i koina baarmaan aakit. ");
INSERT INTO rai_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ma namur a tabuan anun Potipaar i babo nemnem paai un Iosep ma i piri lenbi, “Aiaap ma un inep ungaai ma iaau!” ");
INSERT INTO rai_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Iaku Iosep pa i taraam, ma i piri lenbi, “Iaau baa iaau naagagon, anung ngaala pa i nuknuk balet ma un ta utnaa. A kum utnaa raap anuna, ia maadek taai u ra nung binaboura. ");
INSERT INTO rai_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Pa te kuri u ra ruma mi baa i ngaala taang. Anung ngaala pa i paam koto ta utnaa kon iaau, raa utnaa maku maa pa iaau naagagoni, maa ui anuna taulaa. I papet lelawaai baa ang paam aakaina mangamangaan mi? Maa bi ia aakaina mangamangaan karom God.” ");
INSERT INTO rai_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ma a bungbung raap i pirpir karom Iosep, i benbeni naa diaar a inep ungaai baa diaar a ki ungaai, iaku Iosep pa i taraam mulu ut karomi. ");
INSERT INTO rai_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Raa bung Iosep i ruk u ra ruma kupi in paam anuna pinapaam, ma naruma u ra ruma pa ta tultul kaai kuraa. ");
INSERT INTO rai_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","A tabuan anun Potipaar i paam koto paa ina maalu anun Iosep ma i piri naa, “Aiaap ma un inep ungaai ma iaau!” Iaku i welulu paa ko ra nuna ina maalu na minong baa a tabuan maa i paam koto paai, ma i kalaa pari unataamaan. ");
INSERT INTO rai_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Baa i baboi naa Iosep ia welulu paa ko ra nuna ina maalu na minong baa kuraa u ra limaana, ma ia kalaa pari ko ra ruma, ");
INSERT INTO rai_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","i wewataai kup anuna kum tultul ko ra ruma, ma i piri taan diat naa, “Muaat babo a te Ebraaio bi, baa di ben taai urin karom daat, i nem na pet awawirwir daat. I ruk baat iaau kupi in inep ungaai ma iaau, iaku iaau kulkulaai. ");
INSERT INTO rai_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Baa i walangoro iaau iaau kulkulaai kup ta wewaraaut, i welulu bia taa anuna ina maalu naa ra titing, ma i kalaa pari ko ra ruma.” ");
INSERT INTO rai_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A tabuan anun Potipaar i ung taa ut ina maalu anun Iosep lenmaa u ra titina tuk baa anuna muaana i waan paat. ");
INSERT INTO rai_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ma i wapuai u ra aakaakur mi, “A te Ebraaio a tultul baa u ben paai urin, i pet awawirwir iaau, baa i ruk baat pa iaau. ");
INSERT INTO rai_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Iaku, baa iaau kulkulaai kup ta wewaraaut i welulu bia taa anuna ina maalu naa ra titing ma i kalaa pari ko ra ruma.” ");
INSERT INTO rai_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Baa anuna muaana i walangoro a aakaakur baa anuna taulaa i wapuai uni, u ra aawa baa Iosep i paami karomi, in balaan Potipaar i kup ma i kaankaan dekdek. ");
INSERT INTO rai_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potipaar i ben paa Iosep ma i waruk taai u ra ruma na karabus, a ruma baa a kum karabus anu ra king diat laana karabus iaai. Baa Iosep i ki u ra ruma na karabus, ");
INSERT INTO rai_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","a Tadaaru i ki ungaai mai, i maari ma i waraauti kupi a tena binaboura ko ra ruma na karabus in gaaia uni. ");
INSERT INTO rai_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Io, a tena binaboura i ung taa Iosep baa in tena naagagon u ra kum karabus raap naruma u ra ruma na karabus, ma i naagagon a kum utnaa raap baa di paami matira. ");
INSERT INTO rai_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","A tena binaboura pa i balaan balet u ra kum utnaa baa i ki u ra binaboura anun Iosep, kabina a Tadaaru i ki ungaai mai ma i waraauti kupi anuna pinapaam in taar a waina u ra kum utnaa raap baa i paami. ");
INSERT INTO rai_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Namur, a mukmuga anu ra kum tena baboura waain ma ra mukmuga anu ra kum tena tuntun bred anun Paraao diaar pet akaankaan paa Paraao, anundiaar mukmuga. ");
INSERT INTO rai_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ma i ung ta diaar u ra ruma na karabus, u ra ruma anu ra mukmuga anu ra kum tena wineium baa diat laana baboura ruma anun Paraao, a ruma baa Iosep kaai i karabus iaai. ");
INSERT INTO rai_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","A mukmuga anu ra kum tena wineium i tula wa diaar karom Iosep kupi in baboura diaar. Baa ia iwan anundiaar kinkini na karabus, ");
INSERT INTO rai_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","a ru muaana, a mukmuga anu ra kum tena baboura waain ma ra mukmuga anu ra kum tena tuntun bred, diaar raap mi diaar babo a ru beberon un raa bung na marum ku. Anundiaar ru beberon raap i taar kukuraaina ut. ");
INSERT INTO rai_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Baa Iosep i waan karom diaar u ra malaana i baboi naa a ngaala na tapunuk i lo diaar. ");
INSERT INTO rai_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ma i tiri diaar naa, “I lawaai ma a ru mataamur i babo na tapunuk u ra bung mi?” ");
INSERT INTO rai_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ma diaar baalui, “Mir raap mir beberon, iaku maa pa te baa in palaa a kukuraaindiaar karom mir.” Ma Iosep i piri taan diaar, “God ku in pet laar paai baa in palaa a kukuraai ra kum beberon. Mur a wapua iaau u ra numur ru beberon.” ");
INSERT INTO rai_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Io, a mukmuga anu ra kum tena baboura waain i wapua Iosep u ra nuna beberon naa, “U ra nung beberon iaau babo in diwaai na waain namuga taang. ");
INSERT INTO rai_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ma u ra in diwaai na waain maa, tula gagaana. Baa ditul takaana ibul tato, ditul pupu ma ditul ung maut a kum wainditul, ma ra kum wainditul maa ia mugaan. ");
INSERT INTO rai_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Iaau paam paa a kaap anun Paraao, ma iaau lo paa a kum waina waain maa, ma iaau wiwingi u ra kaap an Paraao ma iaau taar taa a kaap taana.” ");
INSERT INTO rai_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Iosep i baalui naa, “A kukuraaina i waan lenbi: A tula gagaana i welaar ma tula bung. ");
INSERT INTO rai_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tula bung in raap, io, Paraao in watur pa ui balet, ma in ung ta ui u ra num pinapaam, ma un lolo balet ana kaap na waain karomi, lenutmaa u paampaami baa u papaam mun karomi, welaar ma ra tena baboura waain. ");
INSERT INTO rai_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ma baa a kum utnaa raap i koina ku karom ui, un nuk pa iaau, ma un maari iaau. Un wapua Paraao un iaau kupi in wapari wa iaau ko ra karabus. ");
INSERT INTO rai_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Maa di walong pa iaau ku taangirong u ra pia Ebraaio, ma pa iaau paam taa ta utnaa, ma kuri di ung ta iaau u ra ruma na karabus.” ");
INSERT INTO rai_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Baa a mukmuga anu ra kum tena tuntun bred i walangoroi naa a kukuraai ra beberon i koina, i piri karom Iosep naa, “Iaau kaai iaau beberon naa iaau ununa paa tula kaa na bred. ");
INSERT INTO rai_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nabalaa ra kaa baa i taana nate aakit, a kum koina aalawur mangaana bred an Paraao, iaku a kum pika diat aan wa ku a bred koni.” ");
INSERT INTO rai_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Iosep i baalui, “A kukuraaina i waan lenbi: Tula kaa i welaar ma tula bung. ");
INSERT INTO rai_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tula bung in raap, io, Paraao in watur pa ui, ma in wakete ta ui nate un tin diwaai, ma ra kum pika diat a aan wa a panim.” ");
INSERT INTO rai_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","U ra wetula bung, a bung na binabuta anun Paraao, i paam a ngaala na winangaan a ra nuna kum mukmuga. I watur paa kaai a mukmuga anu ra kum tena baboura waain ma ra mukmuga anu ra kum tena tuntun bred namuga namataa ra nuna kum mukmuga. ");
INSERT INTO rai_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","I waki taa balet a mukmuga anu ra kum tena baboura waain u ra nuna pinapaam, kupi in lolo balet a kaap an Paraao karomi. ");
INSERT INTO rai_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma karom a mukmuga anu ra kum tena tuntun bred, di wakete taai nate u ra in diwaai. Ma i lenutmaa Iosep ia pir taai taan diaar baa i palaa anundiaar ru beberon. ");
INSERT INTO rai_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Iaku a mukmuga anu ra kum tena baboura waain pa i nuk paa balet ma Iosep, i dumaana wai maku. ");
INSERT INTO rai_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Baa ru kilaala ia raap, Paraao i beberon. I babo paai naa i tur taau u ra papaara daanim Naail. ");
INSERT INTO rai_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ma i babo pari paa 7 na bulumakaau ko ra daanim, diat tubu ma diat babo wakaak, ma diat aan wali marawaai naa ra daanim. ");
INSERT INTO rai_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Namur taan diat maa, raa 7 na bulumakaau bulung diat waan paat ko ra daanim Naail. Diat babo ururian ma diat mariri, ma diat tur ungaai taau ma raa 7 na bulumakaau kaai u ra papaara daanim. ");
INSERT INTO rai_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ma 7 na bulumakaau baa diat babo ururian ma diat mariri, diat kanom raap paa 7 na bulumakaau baa diat tubu ma diat babo wakwakaak. Ma Paraao i tawaangun. ");
INSERT INTO rai_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Paraao i inep balet ma i beberon a weru pakaan, i babo 7 na turu na wit diat wa wakwakaak ma diat koina aakit. Diat tawa paat ku kon raain diwaaina. ");
INSERT INTO rai_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Namur taan diat raa 7 na turu na wit bulung diat ilak paat. Diat mariri ma pa diat tawa wakaak u ra mage ma ra dadaip na taubaar. ");
INSERT INTO rai_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","A kum mariri na wit diat kanom raap paa 7 na kokoina wit baa diat tawa wakwakaak. Ma Paraao i tawaangun, ma i nunura lele paai naa, a beberon ku mi. ");
INSERT INTO rai_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","U ra malaana a nuknukina i laklagon, io, i wetula kup anuna kum tena paam uraura ma ra kum tena manaana raap taanga Aaigipto. Paraao i wapua ta diat u ra nuna ru beberon, iaku pa te kon diat i palaa laar pa diaar karomi. ");
INSERT INTO rai_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ma a mukmuga anu ra kum tena baboura waain i piri karom Paraao naa, “Iaau nuk paa anung niraara u ra bung mi. ");
INSERT INTO rai_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Raa bung na wanua, u kaankaan karom iaau, ma u ung ta iaau u ra karabus, mir ungaai ma ra mukmuga anu ra kum tena tuntun bred, u ra ruma anu ra mukmuga anu ra kum tena wineium. ");
INSERT INTO rai_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Mir raap mir beberon un raa bung na marum ku. Ma anumir ru beberon a ru kukuraain diaar ut. ");
INSERT INTO rai_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Raa baarmaan a te Ebraaio i ki ungaai ma mir, a tultul anu ra mukmuga anu ra kum tena wineium. Mir wapuai u ra numir ru beberon ma i pir palaa ta diaar karom mir. I pir palaa wakwakaak taa a kukuraai ra ru beberon raap anumir. ");
INSERT INTO rai_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma ra kum utnaa raap i waan paat lenutmaa ia pir palaa taai karom mir. Iaau waan talili balet kup anung pinapaam, ma raa paa mir di wakete taai nate u ra in diwaai.” ");
INSERT INTO rai_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Io, Paraao i wetulaa kup Iosep ma di ben gagaa paai ko ra ruma na karabus. I kakaa wa ana kaabe, i kiaana wa anuna maalu na minong, ma namur i tur namuga naan Paraao. ");
INSERT INTO rai_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Paraao i piri karom Iosep lenbi, “Iaau babo a beberon, ma pa te i palaa laar paai. Iaku iaau walangoroi naa ui, baa di wapua ui un ta beberon, i tale un palaai.” ");
INSERT INTO rai_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Iosep i baalu Paraao naa, “Iaau pang pet laar paai, iaku God ut in taar a kukuraai i ra beberon baa in koina karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ma Paraao i piri taan Iosep, “U ra nung beberon iaau babo pa iaau naa iaau tur taau u ra papaara daanim Naail. ");
INSERT INTO rai_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Iaau babo pari paa 7 na bulumakaau ko ra daanim, diat tubu ma diat babo wakwakaak. Diat aan wali marawaai naa ra daanim. ");
INSERT INTO rai_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ma namur iaau babo paa balet raa 7 na bulumakaau bulung diat waan pari ko ra daanim. Diat babo ururian, diat mariri, ma pa diat babo wakaak. Pa iaau babo mulu taa ta kum ururian na bulumakaau lenmi u ra pia Aaigipto raap. ");
INSERT INTO rai_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","A kum ururian na bulumakaau baa diat mariri, diat kanom raap paa 7 na tubutubu na bulumakaau baa diat muga taau. ");
INSERT INTO rai_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Iaku baa diat aa kanom pa diat, pa diat tubu. Diat babo ururian lenutmaa iaau babo paat pa diat. Ma iaau tawaangun paat. ");
INSERT INTO rai_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“U ra nung weru beberon, iaau babo paa kaai 7 na turu na wit, diat tawa wakwakaak, diat koina aakit ma diat tawa paat ku kon raain diwaaina. ");
INSERT INTO rai_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Namur taan diat raa 7 na turu na wit bulung diat ilak paat. Diat mariri, ma pa diat tawa wakaak u ra mage ma ra dadaip na taubaar. ");
INSERT INTO rai_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","A kum mariri na turu na wit diat kanom raap paa 7 na koina turu na wit. Iaau pir taa anung beberon taa ra kum tena paam uraura, iaku pate kon diat i pir palaa laar paai taang.” ");
INSERT INTO rai_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Io Iosep i piri taan Paraao naa, “Diaar welaar ku anum ru beberon, ma i raa kukuraain diaar ku. God ia waiaa ta ui u ra aawa baa marawaai in paami. ");
INSERT INTO rai_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","7 na kokoina bulumakaau i welaar ma 7 na kilaala, ma 7 na kokoina turu na wit kaai i welaar ma 7 na kilaala. Diaar welaar ku. ");
INSERT INTO rai_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","7 na ururian na bulumakaau baa diat mariri, baa diat waan paat namur, ma 7 na turu na aakaakaina wit baa pa diat tawa wakaak u ra mage ma ra dadaip na taubaar, diat welaar ma 7 na kilaala na minolo baa diat a waan paat. ");
INSERT INTO rai_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","I lenutmaa iaau aa pir taai taam, God ia waiaa ta ui u ra aawa baa in paami. ");
INSERT INTO rai_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","7 na kilaala in waan paat baa a utnaa na winangaan in bure aakit u ra pia Aaigipto raap. ");
INSERT INTO rai_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Iaku 7 na kilaala na minolo in waan paat namur. Ma ra ngaala na minaaur irong Aaigipto in panaai, ma a dekdek na minolo in baanaakaka a kum taamtaamaan raap. ");
INSERT INTO rai_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Pa te balet ma in nuk paa a kum kilaala na minaaur, kabina a minolo baa in waan paat in aaka aakit. ");
INSERT INTO rai_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“God i wababo ui ma ra ru beberon raap baa kukuraaindiaar i welaar, kupi un nunurai naa God ia naagagon taai baa a kum utnaa mi in waan paat ut, ma marawaai in taar pari wai. ");
INSERT INTO rai_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“I koina baa ui ut un baat kup ta muaana baa i manaana ma i laana nuknuk wakaak, ma un ung taai kupi in naagagon u ra pia Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma un pilak paa ta taara kupi diat a mukmuga u ra pia Aaigipto, ma diat a lo paa raaraa utnaa ko ra kum limlima na utnaa raap, baa a taara diat a tangaai u ra 7 na kilaala na minaaur. ");
INSERT INTO rai_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","A kum mukmuga diat a lo ungaai a kum utnaa na winangaan maa ko ra kum kokoina kilaala mi baa in waan paat, ma diat a ung ungaai a kum wit naatudaangi ra num naagagon. A utnaa na winangaan maa in ki na baboura un raaraa taamaan. ");
INSERT INTO rai_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","In taana kupi a taara diat a aani u ra 7 na kilaala na minolo baa in waan paat min Aaigipto, kupi koku a minolo i baanaakaka a taara.” ");
INSERT INTO rai_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","A ninunuk maa i koina karom Paraao ma ra nuna kum mukmuga raap. ");
INSERT INTO rai_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Io, Paraao i tiri anuna kum mukmuga, “Lelawaai, i tale daat baa daat a baat paa ta muaana welaar ma ra muaana bi, baa a nion God i ki uni? Painte.” ");
INSERT INTO rai_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Io, Paraao i piri karom Iosep, “God ia wakaapakaapa taa a kum utnaa mi karom ui. Pa ta muaana balet i manaana ma i nuknuk wakaak welaar ma ui. ");
INSERT INTO rai_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ui un naagagon u ra nung ruma, ma anung taara raap diat a taraam u ra num kum naagagon. Raa utnaa ku, un ru anung kiki na king, kupi iaau ut ang ngaala taam.” ");
INSERT INTO rai_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Io, Paraao i piri karom Iosep, “Kumari iaau ung ta ui kupi un naagagon u ra kudulaana pia Aaigipto raap.” ");
INSERT INTO rai_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ma Paraao i rakaan paa ring ko ra in kaalkaali na limaana baa anuna wakilang na king i ki uni, ma i waruk taai u ra in kaalkaali na limaan Iosep. I wamong taai ma ra kum wakwakaak na minong ma i ung taa kaai a sen di paami ko ra goled u ra in kabarono. ");
INSERT INTO rai_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Paraao i waki taa Iosep u ra kaaris ma di waan taltalili mai, kupi in waiaai karom a taara naa Iosep a weru tena naagagon. Ma a kum muaana diat ge ma ra pirpir namuga naana lenbi, “Muaat a tur aara aakapi!” Paraao ia ung taa Iosep kupi in naagagon u ra kudulaana pia Aaigipto raap. ");
INSERT INTO rai_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma Paraao i piri karom Iosep, “Iaau a king iaau piri naa, pain te taanga min Aaigipto in paam ta utnaa u ra nuna nemnem, baa pa i tiri muga ta ui.” ");
INSERT INTO rai_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Paraao i taar taa a matakina iaan Iosep baa Saapenaat-Paanea, ma i taar taa kaai a tabuan karom Iosep, a iaana Aasenaat, kupi anuna taulaa. Aasenaat a natun Potiperaa. Potiperaa a tena tuntun wetabaar karom anundiat god, irong u ra taamaan On. Ma Iosep i waan taltalili u ra pia Aaigipto raap. ");
INSERT INTO rai_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","I tula noina kilaala na lalaaun anun Iosep baa i turpaa a pinapaam karom Paraao, a king anu ra taara Aaigipto. Ma Iosep i waan pari ko ra ruma anun Paraao ma i waan taltalili u ra kudulaana pia Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","U ra 7 na kilaala na minaaur a kum utnaa raap i tawa wakaak ma diat wa mongoro na waindiat. ");
INSERT INTO rai_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Iosep i lalo raap ko ra kum utnaa na winangaan baa i tawa u ra 7 na kilaala na minaaur maa, ma i ung ungaai diat u ra kum taamtaamaan. Un raaraa taamaan i ung ungaai a utnaa na winangaan ko ra andiat kum pinapaam ut. ");
INSERT INTO rai_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Iosep i ung ungaai a ngaala na wit welaar ma woio taanga nakono. Baa i bure aakit, ma pa i luk laar paai, io, pa i timu koto ma a nilulukindiat. ");
INSERT INTO rai_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Namuga taa ra kum kilaala na minolo, Aasenaat a taulaa anun Iosep i buta paa ru naat muaana. Aasenaat a natun Potiperaa, a tena tuntun wetabaar taangirong u ra taamaan On. ");
INSERT INTO rai_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Iosep i taar taa a iaa ra nuna mugaana naat muaana baa Maanaase, ma i piri lenbi, “A kabina maa God ia waduman iaau ko ra nung kum mawaat raap, ma a taara kaai u ra ruma anun tamaang.” ");
INSERT INTO rai_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A weru naat muaana i taar taa a iaana baa Eparaaim, ma i piri lenbi, “A kabina maa God i tabaara iaau ma ra ru naat mi, u ra pia baa iaau aa kariaana taa a kum mawaat iaai.” ");
INSERT INTO rai_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Baa 7 na kilaala na minaaur i raap irong Aaigipto, ");
INSERT INTO rai_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","a 7 na kilaala na minolo bulung i waan paat. I lenutmaa Iosep ia pir taai. A minolo i waan u ra kum taamtaamaan raap, iaku irong u ra pia Aaigipto a utnaa na winangaan i ki ut. ");
INSERT INTO rai_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Baa a taara Aaigipto diat kariaana a minolo, diat taangi karom Paraao kup ta utnaa na winangaan. Ma Paraao i piri ku taa ra taara Aaigipto raap lenbi, “Muaat a waan karom Iosep ma muaat a paam aawa baa in piri taa muaat.” ");
INSERT INTO rai_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Baa a minolo i manong a taara raap u ra kum taamtaamaan irong Aaigipto, Iosep i paapa a kum ruma baa ia ung ungaai taa a kum utnaa na winangaan uni, ma i wiurai karom diat. ");
INSERT INTO rai_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ma a kum taara ko ra kum taamtaamaan ingen kaai diat waan urong Aaigipto, kupi diat a kul utnaa na winangaan kon Iosep, maa a minolo i waan paat dekdek u ra rakrakaan buaal raap. ");
INSERT INTO rai_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Baa Iaakob i nunurai naa a wit kurong Aaigipto, i piri karom a kum natnatuna naa, “I lawaai maa muaat ki biaa ku? ");
INSERT INTO rai_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Iaau aa walangoro taai naa a wit kurong Aaigipto. Muaat a waan ma muaat a kul paa andaat ta wit, kupi daat a lalaaun mai ma koku daat maat.” ");
INSERT INTO rai_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ma noina tatein Iosep diat waan urong Aaigipto kupi diat a kul paa ta wit. ");
INSERT INTO rai_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Iaku Iaakob pa i tula Beniaamin, ia baa raa naandiaar ma Iosep, kupi in waan ungaai ma diat, maa i nuki naa kaduk ia bulung in wirua ku. ");
INSERT INTO rai_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Io, a kum natnatun Iaakob, baa raa iaana kaai Israael, diat weur ungaai ma raa taara kaai baa diat waan na kul wit, maa a minolo ia waan paat kaai irong Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Iosep ma maa a mukmuga ko ra pia Aaigipto raap, ia baa i laana wiura wit karom a taara raap. Io, baa a kum tatena liklik diat waan paat, diat ki but keke karomi ma ra mataandiat unapia. ");
INSERT INTO rai_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Baa Iosep i babo paa a kum tatena liklik, i babo lele wa diat maut, iaku i papaam karom diat lenbaa pa i nunura diat, ma i pirpir ma ra dekdek karom diat. I tiri diat naa, “Muaat taangawaai?” Diat baalui naa, “Miaat waan taangirong Kaanaan kupi miaat a kul paa ta utnaa na winangaan.” ");
INSERT INTO rai_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosep ia babo lele wa a kum tatena liklik, iaku diat ut pa diat babo lele paai. ");
INSERT INTO rai_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Namur i nuk paa anuna kum beberon un diat, ma i piri taan diat naa, “Muaat a kum tena babo ino! Muaat waan urin kupi muaat a babo ino anumiaat taamaan kup ta wanua baa muaat a ruk iaai!” ");
INSERT INTO rai_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Diat baalui, “Pate, tadaaru! Miaat waan urin kupi miaat a kul ta utnaa na winangaan. ");
INSERT INTO rai_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Miaat raap a kum natnatun raa muaana ku. Ma miaat a kum dowot na muaana, wakir a kum tena babo ino.” ");
INSERT INTO rai_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iosep i piri taan diat, “Muaat warwaruga! Muaat waan kupi muaat a babo ino anumiaat taamaan.” ");
INSERT INTO rai_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Iaku diat baalui naa, “Raa noina ma rudi miaat, a kum natnatun raa muaana ot ku, baa i lalaaun u ra pia Kaanaan. A murmur lik maku kurong diaar ma ra tamaamiaat, ma raa kon miaat i maat.” ");
INSERT INTO rai_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Iosep i piri taan diat, “Mi ut ia iaau piri taamuaat, naa muaat a kum tena babo ino. ");
INSERT INTO rai_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Iaku din walaar muaat lenbi: U ra iaan Paraao iaau piri taamuaat, pain muaat a waan ko ra taamaan mi, tuk muaat a ben a murmur na teimuaat urin. ");
INSERT INTO rai_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Muaat a tula wa te kon muaat, kupi in ben paa a teimuaat, ma muaat raap mi muaat a ki u ra karabus, kupi din walaar muaat baa anumuaat pirpir i lingtatuna, baa pate. Baa pate, io u ra iaan Paraao, iaau nunurai naa muaat a kum tena babo ino.” ");
INSERT INTO rai_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Io, i waruk ta diat u ra ruma na karabus welaar ma tula bung. ");
INSERT INTO rai_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","U ra wetula bung, Iosep i piri taan diat, “Muaat a murmur anung pirpir, kupi muaat a lalaaun, kabina maa iaau burut karom God. ");
INSERT INTO rai_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Baa muaat a kum dowot na muaana, muaat a maadek wa te kon muaat in ki na karabus, ma muaat raap muaat a waan ma muaat a lo paa ta wit kup anumuaat taara baa kuraa diat molo u ra numuaat taamaan. ");
INSERT INTO rai_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Iaku muaat a ben taa a murmur na teimuaat karom iaau, kupi din nunurai naa anumuaat kum pirpir i dowot, ma kupi koku di aak doko muaat.” Ma diat mulaaot kupi diat a paami lenmaa. ");
INSERT INTO rai_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Diat pirpir wetwetalaai karom diat naa, “Maia, di wakarabus daat kabina u ra kum pinapaam daat paami u ra teindaat Iosep. Daat babo ut anuna tapunuk baa i luan na maarmaari naandaat, iaku pa daat walangoroi. Lenkaai mi daat bulung daat a kariaana a dekdek.” ");
INSERT INTO rai_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben i baalu diat, “Iaau piri taamuaat naa koku muaat paam ta aakaina mangamangaan uni, iaku pa muaat walangoro iaau! Io, mi ma ia a binabaaluina di taari karom daat.” ");
INSERT INTO rai_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Pa diat nunurai naa Iosep i walangoro lele ku aawa maa diat piri, kabina maa i pirpir karom diat ma ra pirpir Aaigipto, ma raa muaana ingen i puku a pirpir karom diat u ra pirpir Ebraaio. ");
INSERT INTO rai_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Baa Iosep i walangoro taa anundiat kum pirpir, i tapuku paa kon diat ma i luan. Namur i tapuku balet karom diat ma i pirpir karom diat. I pilak paa Simion kon diat, ma di do koto taai namataan diat. ");
INSERT INTO rai_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Iosep i wetulaa kupi din wateng taa anundiat kum bek ma ra wit, ma din ung talili taa anundiat kum kelom na maani u ra nundiat kum bek, ma din taar taa andiat kiniwa kup anundiat winawaan. Baa di aa paam raap taa a kum utnaa mi, ");
INSERT INTO rai_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","diat wakaa paa anundiat kum utnaa u ra kum dongki ma diat waan. ");
INSERT INTO rai_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Baa diat ngo paa u ra wanua baa diat ngo aagil paa iaai u ra marum, raa kon diat i paapa anuna bek kupi in tabaara anuna dongki. I babo paa anuna kelom na maani kuraa ut naruma u ra nuna bek. ");
INSERT INTO rai_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I piri karom a kum tatena liklik naa, “Aai, muaat baboi! Anung kelom na maani bari balet ma ia, u ra nung bek na wit.” A balaandiat i laklagon ma diat babo wetwetalaai diat ma diat dadader ma ra bunurut ma diat piri, “Aawa mi God i paami un daat?” ");
INSERT INTO rai_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Baa diat waan paat karom a tamaandiat Iaakob irong Kaanaan, diat wapuai u ra kum utnaa raap baa i waan paat un diat. Diat piri naa, ");
INSERT INTO rai_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“A muaana baa i naagagon raap u ra taamaan Aaigipto i pirpir dekdek aakit karom miaat, ma i takuna miaat naa miaat babo ino anundiat taamaan. ");
INSERT INTO rai_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Iaku miaat piri karomi, ‘Miaat a kum dowot na muaana, wakir miaat a kum tena babo ino. ");
INSERT INTO rai_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Raa noina ma rudi miaat, raa tamaamiaat ku, ma raa kon miaat i maat. A murmur taamiaat maku kurong diaar ma ra tamaamiaat irong Kaanaan.’ ");
INSERT INTO rai_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ma a muaana baa i naagagon u ra taamaan Aaigipto i piri karom miaat, ‘Muaat a paami lenbi kupi ang nunurai naa muaat a kum dowot na muaana: Muaat a maadek taa ta teimuaat in ki min, ma muaat a lo paa ta utnaa na winangaan kup anumuaat taara baa diat molo u ra numuaat taamaan, ma muaat a waan. ");
INSERT INTO rai_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Iaku muaat a ben taa a murmur na teimuaat urin karom iaau, kupi ang nunurai naa muaat a kum dowot na muaana, ma wakir a kum tena babo ino. Io, ang walaangalaanga wa balet a teimuaat karom muaat, ma muaat a laangalaanga kupi muaat a kul utnaa ko ra taamaan mi.’” ");
INSERT INTO rai_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Namur baa diat labo anundiat kum bek na wit, diat labo aara paa balet anundiat kum kelom na maani. Baa diat ungaai ma ra tamaandiat, diat babo paa a kum kelom na maani maa, diat burut. ");
INSERT INTO rai_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","A tamaandiat Iaakob i piri taan diat naa, “Muaat ku muaat pet taa anung ru naat baa pa iaau babo diaar ma. Iosep mun ia panaai, Simion bulung panaai ma iaai, ma mi muaat nem na ben bulung Beniaamin. A kum utnaa raap mi i manong iaau.” ");
INSERT INTO rai_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ma Ruben i piri taan tamaana lenbi, “Un maadek taa Beniaamin u ra nung binaboura, ma iaau ang ben talili taai balet karom ui. Baa pang ben talili Beniaamin, un aak doko anung ru naat muaana.” ");
INSERT INTO rai_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Iaku Iaakob i piri naa, “Natunglik pa in waan ungaai ma muaat. Raa tenalik mun ia maat, Beniaamin maku mi i lalaaun. Iaau aa takaana, ma baa ta utnaa in waan paat karomi u ra numuaat winawaan ma in wirua, io muaat ma maa a kabina un iaau baa ang maat ma ra tapunuk.” ");
INSERT INTO rai_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","A minolo i waan utbaai u ra kum taamtaamaan raap. ");
INSERT INTO rai_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Io, baa andiat wit i raap, baa diat kul paai taangirong Aaigipto, Iaakob i piri karom a kum natnatuna naa, “Muaat a waan talili balet ma muaat a kul paa balet andaat ta utnaa na winangaan.” ");
INSERT INTO rai_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Iaku Iuda i piri taana naa, “A muaana maa i pirpir dekdek karom miaat naa, pa in babo ta miaat balet ma, baa pa miaat a ben a teimiaat urong. ");
INSERT INTO rai_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Baa ut un tula wa a teimiaat ungaai ma miaat, io, miaat a waan ma miaat a kul paa a maam ta utnaa na winangaan. ");
INSERT INTO rai_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Baa pa un tulai, pain miaat a waan, maa a muaana maa i piri karom miaat lenbi, pa in babo ta miaat balet baa pa miaat a ben a teimiaat.” ");
INSERT INTO rai_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israael baa raa iaana kaai Iaakob i wetiri, “Kup aawa maa muaat taar taa a mawaat mi karom iaau, baa muaat wapua a muaana maa naa raa teimuaat kuri?” ");
INSERT INTO rai_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Diat baalui naa, “A muaana maa i tiri liklikina miaat ku un miaat ut, ma un daat tamaana raap. I tiri miaat, ‘A tamaamuaat kuraa utbaai i lalaaun? Ta teimuaat utkaai kuraa?’ Miaat baalu ku anuna kum wetiri. Pa miaat nunurai naa in piri taa miaat kupi miaat a ben taa a teimiaat karomi.” ");
INSERT INTO rai_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Iuda i piri balet karom tamaana Israael, “Un maadek taa Beniaamin karom iaau, ma mi ut miaat a waan, kupi daat ungaai ma nundaat kum naat, daat a lalaaun ma koku daat maat. ");
INSERT INTO rai_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Iaau weweliman baa iaau ut ang babourai. Ma baa pang ben talili urin karom ui, iaau ut ang lo wetakun uni u ra nung kum bungbung na lalaaun raap. ");
INSERT INTO rai_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Baa gun pa un turbaat miaat, kuri ia ru pakaan na winawaan, miaat aa waan paa ma miaat aa waan talili balet urin.” ");
INSERT INTO rai_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ma a tamaandiat Israael i piri taan diat naa, “Iaau pa nung ta pirpir ma. Muaat a paami ku lenmaa: Muaat a ung ta kum kokoina utnaa taanga main u ra pia Kaanaan u ra numuaat kum bek, ta ngaatngaat na marasin, ta bulit baa a kum bi diat paami, kum koina aangawian na utnaa, a mira, ma ra ru mangaana waina baa diaar welaar ma ra tamaap. Ma muaat a loi kup a muaana maa, welaar ma ra wetabaar. ");
INSERT INTO rai_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Muaat a lo talili taa balet a maani baa muaat baat paai u ra numuaat kum bek, kaduk diat ung banaa taai ku, ma muaat a lo kaai ta maani kupi muaat a kul paa balet andaat ta utnaa na winangaan mai. ");
INSERT INTO rai_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Muaat a ben paa a teimuaat, ma muaat a waan talili gagaa balet urong kup a muaana maa. ");
INSERT INTO rai_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ma God baa i Dekdek Aakit, in maari muaat kupi a muaana maa in palaa wa a teimuaat Simion ma in maadek taa Beniaamin, ma diaar a waan talili ungaai balet ma muaat urin. Baa anung kum naat diat a raap kon iaau, io koina maku.” ");
INSERT INTO rai_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Io, diat lo paa a kum wetabaar, a maani na kunukul ma ra maani baa diat a lo talili taai, ma diat ben paa kaai Beniaamin, ma diat waan gagaa urong Aaigipto. Ma diat waan paat ma diat tur namataan Iosep. ");
INSERT INTO rai_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Baa Iosep i babo paa Beniaamin ungaai ma diat, i piri karom a tena baboura ko ra nuna ruma naa, “Ben taa a kum muaana bi kup anung ruma, aak doko paa ta wewagua ma un waninaar a utnaa na winangaan, maa diat a wangaan ungaai ma iaau u ra mage.” ");
INSERT INTO rai_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","A tena baboura maa i paami lenutmaa Iosep i pir taai taana, ma i ben pa diat kup a ruma anun Iosep. ");
INSERT INTO rai_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Io, diat burut baa di ben pa diat kup a ruma anun Iosep. Diat nuki lenbi naa di ben pa diat kabina u ra maani baa di ung taai u ra nundiat kum bek u ra mugaana pakaan. Diat pirpir wetwetalaai karom diat, ma diat piri naa, “A muaana mi i nemi naa in um daat ma in paam koto daat kupi daat a papaam na wilawilaau karomi ma in lo paa anundaat kum dongki.” ");
INSERT INTO rai_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Io, diat waan karom a tena baboura ko ra ruma anun Iosep, ma diat pirpir karomi naa ra bonanaaka i ra ruma. ");
INSERT INTO rai_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Diat piri naa, “Le, maari miaat. Miaat waan paat min a mugaana pakaan kupi miaat a kul paa ta utnaa na winangaan. ");
INSERT INTO rai_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Iaku u ra numiaat winawaan talili, u ra wanua baa miaat ngo iaai u ra marum, miaat paapa numiaat kum bek ma raaraa kon miaat i baat paa anuna kelom na maani naruma u ra nuna bek. Ma a nilulukina i lenutmaa miaat kukul mun mai. Ma kuri miaat lo talili balet urin. ");
INSERT INTO rai_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Pa miaat nunurai woi maa i ung taa anumiaat kum kelom na maani u ra numiaat kum bek. Ma mi miaat lo utkaai raa maani kupi miaat a kul paa balet a maamiaat ta utnaa na winangaan mai.” ");
INSERT INTO rai_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A tena baboura i piri, “I koina raap ku. Koku muaat burut. Anumuaat God, a God anu ra tamaamuaat, i ung taa balet anumuaat maani u ra numuaat kum bek. Iaau aa lo paa anumuaat maani.” Namur i ben pari taa Simion karom diat. ");
INSERT INTO rai_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","A tena baboura maa i ben aruk pa diat u ra ruma anun Iosep, ma i taar taa a palaa taan diat kup diat a gi a kum kakindiat mai, ma i tabaara taa kaai anundiat kum dongki. ");
INSERT INTO rai_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Baa diat aa walangoro taai naa diat a wangaan ungaai ma Iosep, io, diat waninaar anundiat kum wetabaar kup anuna winawaan paat u ra mage. ");
INSERT INTO rai_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Baa Iosep i waan paat, diat tabaara taai ma ra kum wetabaar baa diat loi kupi, ma diat ki but keke ma ra mataandiat unapia namuga taana. ");
INSERT INTO rai_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I tiri diat naa, “Muaat koina ku? Lelawaai, a takaana tamaamuaat baa muaat wapua iaau uni, i lalaaun utbaai?” ");
INSERT INTO rai_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Diat baalui lenbi, “Anum tultul, a tamaamiaat, i lalaaun wakaak utbaai.” Ma diat ki but keke ma ra mataandiat unapia kupi diat a taar a urur karomi. ");
INSERT INTO rai_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Baa i babo diat, i babo paa tenalik Beniaamin, ia baa raa naandiaar ku, ma i wetiri lenbi, “Mi ut ia a murmur na teimuaat baa muaat wapua iaau uni?” Ma i piri karom Beniaamin naa, “God in wadaan ui, natunglik!” ");
INSERT INTO rai_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Baa Iosep i babo tenalik, i maari aakiti ma i tapunuk uni, ma i welulu pari gagaa ma i babo kup ta wanua baa in luan iaai. Io, i ruk taau u ra nuna kukura ruma ma i luan matira. ");
INSERT INTO rai_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Namur baa ia gi paa a mataana, i wadekdek paai ku ma i waan balet karom diat, ma i piri naa, “Muaat a paamtagono a utnaa na winangaan.” ");
INSERT INTO rai_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Diat oko ingen taa a utnaa an Iosep, ma i wangaan ingen. Ma a kum tatena liklik kaai ingen ut, ma a taara Aaigipto kaai diat ut, maa a taara Aaigipto diat milikuaana a taara Ebraaio, ma pa diat laana wangaan ungaai ma diat. ");
INSERT INTO rai_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Di waki taa a kum tatena liklik namuga naana, di waki wemur diat welaar ut ma ra nundiat kum kilaala na lalaaun. Baa diat babo lele paai naa diat ki wemur ut a mugaana kup a murmur aakit, diat kakaian ma diat babo wetwetalaai diat. ");
INSERT INTO rai_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Baa di aa oko raap taa andiat utnaa na winangaan u ra luwu na winangaan anun Iosep, a utnaa na winangaan an Beniaamin i ngaala taan diat raap. Pa i welaar ma ra mangaana okoko baa di paami karom a kum tatena liklik, ma karom Beniaamin i welaar ma 5 na pelet na utnaa raap. Io diat wangaan ma diat inim a waain ma diat gaaia ungaai ma Iosep. ");
INSERT INTO rai_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Io, Iosep i taar taa a pirpir karom a tena baboura ko ra nuna ruma lenbi, “Wateng wakaak taa anundiat kum bek ma ra utnaa na winangaan, ma un ung taa anundiat kum kelom na maani balet u ra nundiat kum bek raaraa. ");
INSERT INTO rai_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ma un ung taa ngaang kaap baa di paami ko ra silwa u ra bek anu ra murmur na teindiat, ungaai ma ra nuna kelom na maani baa i kul wit mai.” Ma i paami lenutmaa Iosep i pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Baa i keke paat u ra malaana, di tula wa a kum muaana maa u ra nundiat winawaan ungaai ma ra nundiat kum dongki. ");
INSERT INTO rai_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pa diat waan welwelik utbaai ko ra taamaan, io, Iosep i piri taa ra nuna tena baboura, “Waan gagaa, ma un kalaa murmur a kum muaana baa, ma baa u aa lu koto pa diat un piri taan diat, ‘I lawaai ma muaat baalu a koina ma ra aakaina? ");
INSERT INTO rai_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Muaat lo paa a kaap baa anung ngaala i laana inim koni, ma i laana papaam mai kupi in pir palaa a utnaa baa in waan paat namur. Aakaina mangamangaan mulu mi muaat paami.’” ");
INSERT INTO rai_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Baa a tena baboura maa ia lu koto pa diat, i piri karom diat welaar ma ra pirpir baa Iosep ia pir taai taana. ");
INSERT INTO rai_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Iaku diat piri taana naa, “I lawaai maa anumiaat tadaaru in pir ta kum utnaa lenmaa? Pain te mulu ut kon miaat in paam a mangamangaan lenmaa! ");
INSERT INTO rai_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Miaat lo talili balet a kum kelom na maani taangirong Kaanaan, baa miaat baat paai ko ra numiaat kum bek. Io, kup aawa maa miaat a walong ta silwa baa goled ko ra ruma anu ra num ngaala? ");
INSERT INTO rai_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Baa te kon miaat din baat paa a kaap maa u ra nuna bek, in maat. Ma miaat raap miaat a papaam na karabus karom anum ngaala.” ");
INSERT INTO rai_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A tena baboura i baalu diat lenbi, “Koina ku, din paami lenmaa muaat piri. Te ku kon muaat baa di aa baat paa a kaap u ra nuna bek, ia ku maa in papaam na karabus karom iaau, ma muaat raap muaat a laangalaanga ko ra wetakun mi.” ");
INSERT INTO rai_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Diat raap raaraa diat ung apari gagaa anundiat kum bek unapia ma diat paapai. ");
INSERT INTO rai_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma a tena baboura anun Iosep i turpaai kupi in babo a kum bek. I turpaai u ra mugaana naat ma i waan kup a murmurina. Baa i babo a bek anun Beniaamin i baat paa a kaap. ");
INSERT INTO rai_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ma a kum tatena liklik raap diat tapunuk ma diat rabaana wa anundiat kum maalu. Namur diat ung tato paa anundiat kum utnaa u ra nundiat kum dongki ma diat waan talili balet kup a taamaan baa Iosep i ki iaai. ");
INSERT INTO rai_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Iosep kuraa ut naruma u ra nuna ruma baa Iuda ma ra kum tatena liklik diat ruk, ma diat raap diat ki but keke ma ra mataandiat unapia namuga naana. ");
INSERT INTO rai_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Iosep i piri taan diat naa, “Aawa mi muaat aa paam taai? Lelawaai, pa muaat nunurai naa a mangaana muaana lenmi iaau, i tale in nunura ot paa ku a kum utnaa baa te i paam ino taai?” ");
INSERT INTO rai_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Iuda i baalui, “Tadaaru, woi na mangaana pirpir balet maa miaat a piri karom ui? Miaat a weoro balet ma lelawaai? God ia wakaapakaapa wa a mangamangaan anu ra num kum tultul. Mari miaat raap anum kum wilawilaau, ungaai ma ia baa di baat paa a kaap koni.” ");
INSERT INTO rai_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Iaku Iosep i piri naa, “Pain te, pang paam ta utnaa lenmaa! Ia ku baa di aa baat paa a kaap koni, in papaam na karabus karom iaau. Muaat raap, muaat a waan talili ma ra maalmaal karom a tamaamuaat.” ");
INSERT INTO rai_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ma Iuda i waan marawaai karom Iosep ma i piri, “Maari iaau, anung tadaaru, maadek wa iaau, anum tultul, ang pir ta pirpir karom ui. Koku u kaankaan karom iaau, maa i dowot aakit baa mur welaar ku ma Paraao. ");
INSERT INTO rai_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","U aa tiri taa miaat mun naa, ‘A tamaamuaat ma ta teimuaat kurong utbaai?’ ");
INSERT INTO rai_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ma miaat baalu ui lenbi, ‘Tamaamiaat ia takaana, ma raa natunalik baa di buta i baa tamaamiaat ia takaana. Anuna raa tabuan i buta taa ru naat uni. Iaku raa mun ia maat, ma a murmur maku kurong ma tamaamiaat i nem aakiti.’ ");
INSERT INTO rai_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Namur u piri naa miaat a ben taai urin, kupi ui ut un baboi ma ra mataam. ");
INSERT INTO rai_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ma miaat piri karom ui, ‘A naat pa in waan kon tamaana. Baa in waan kon tamaana, tamaana in maat.’ ");
INSERT INTO rai_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Iaku u piri taa miaat naa, baa a murmur na teimiaat pa in waan urin, pa un babo ta miaat balet ma main. ");
INSERT INTO rai_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Baa miaat waan talili karom a tamaamiaat, miaat wapuai u ra aawa baa u aa pir taai. ");
INSERT INTO rai_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Namur a tamaamiaat i piri taamiaat naa, ‘Muaat a waan ma muaat a kul paa balet andaat ta utnaa na winangaan.’ ");
INSERT INTO rai_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Iaku miaat piri taana naa, ‘Baa pa miaat a ben a murmur na teimiaat ungaai ma miaat, pa miaat a waan urong, maa a muaana maa i piri naa, baa pain miaat a ben a teimiaat, pa in babo ta miaat balet.’ ");
INSERT INTO rai_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","A tamaamiaat i piri lenbi taa miaat, ‘Muaat nunurai naa anung raa tabuan kaai i buta taa ru naat muaana ot ku un iaau. ");
INSERT INTO rai_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Raa kon diaar mun ia maat kon iaau, ma iaau nuki naa raa wewagua ia karaat ginagina wai. Taanga matira pa iaau babo taai balet ma. ");
INSERT INTO rai_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Iaau aa takaana, ma baa muaat a ben paa kaai raa bi kon iaau, ma ta utnaa in waan paat karomi ma in wirua, io, muaat ma maa a kabina un iaau baa ang maat ma ra tapunuk.’ ");
INSERT INTO rai_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Io, mi baa miaat a waan talili karom a tamaamiaat, ma in baboi baa a naat pa i waan ungaai ma miaat, in maat. Maa a tamaamiaat anuna lalaaun raap kuri u ra naat mi. Io, miaat ma maa a kabina u ra tamaamiaat baa in maat ma ra tapunuk. ");
INSERT INTO rai_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Iaau aa weweliman taau karom a tamaamiaat baa ang baboura wakaak a naat bi. Iaau piri karom tamaang, baa pang ben talili karomi, iaau ut ang lo a wetakun uni u ra nung kum bungbung na lalaaun raap. ");
INSERT INTO rai_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ma mi un maari miaat, un mulaaot pa iaau maku kupi ang ki talili main karom ui, anung tadaaru, kupi ang papaam na karabus milon taa Beniaamin, ma un maadek wai in waan talili ungaai ma ra kum tateina. ");
INSERT INTO rai_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ang waan talili balet karom tamaang lelawaai, baa a naat bi pa in waan ungaai ma miaat? Painte! Koku maadek wa iaau kupi ang babo a ngaala na tapunuk baa in waan paat un tamaang.” ");
INSERT INTO rai_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ma Iosep pa i wadekdek baat laar paai ma namuga naa ra nuna kum tultul, ma i ge karom diat lenbi, “Muaat raap muaat a pari kon iaau!” Baa pa te maa i ki ungaai ma diat matira, io, i pir apuaana ia ut karom a kum tatena liklik. ");
INSERT INTO rai_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I taangi dekdek ma a taara Aaigipto diat walangoroi, ma a taara kaai u ra ruma anun Paraao diat walangoro a pirpir uni. ");
INSERT INTO rai_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Iosep i piri karom a kum tateina naa, “Iaau Iosep. Tamaang i lalaaun utbaai?” Iaku a kum tateina pa diat baalu laar paai, maa diat burut dekdek aakit namataana. ");
INSERT INTO rai_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ma Iosep i piri karom a kum tatena liklik, “Muaat a waan marawaai urin.” Baa diat aa tur marawaai i piri lenbi, “Iaau a teimuaat Iosep, baa muaat wiura wa iaau urin Aaigipto! ");
INSERT INTO rai_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ma mi koku muaat tapunuk ma koku muaat takuna muaat ut u ra kum utnaa baa muaat aa paam taai un iaau. God ut i tula muga wa iaau taamuaat, kupi din walaaun pa muaat. ");
INSERT INTO rai_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","A minolo mi ia ru kilaala uni, ma 5 na kilaala kuraa utbaai baa pain ta minamaarut u ra pia, ma pain ta tinangaa. ");
INSERT INTO rai_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Iaku God i tula muga wa iaau urin kupi ang walaaun pa muaat, ma muaat a taara Israael, koku muaat wirua ko ra rakrakaan buaal. God i paam a ngaala na utnaa na kakaian mi kupi in walaangalaanga pa muaat raap. ");
INSERT INTO rai_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Io, wakir muaat maa muaat tula wa iaau urin. God ut i ung ta iaau kupi ang welaar ma tamaan Paraao, ma ang mukmuga u ra kum utnaa raap u ra nuna ruma, ma ang tena naagagon anu ra taara Aaigipto raap. ");
INSERT INTO rai_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Mi muaat a waan talili gagaa karom tamaang, ma muaat a piri karomi naa, ‘Iosep baa a natumlik i pir taai lenbi: God ia ung ta iaau kupi ang tena naagagon min Aaigipto raap. Un waan gagaa urin karom iaau! ");
INSERT INTO rai_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Un lalaaun u ra papaar Gosaan ma un ki marawaai iaau, ungaai ma ra kum natnatum, kum taptabum, anum kum sip ma ra kum bulumakaau ma aawa raap baa anumuaat. ");
INSERT INTO rai_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Iaau ang taptabaara ui marong, maa 5 na kilaala na minolo kuraa utbaai. Kaduk ui, ma ra num taara, ma num kum tultul, muaat a pot na maarmaari ma ra kini na niba.’” ");
INSERT INTO rai_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ma Iosep i piri kaai karom a kum tatena liklik lenbi, “Muaat ut muaat a babo lele iaau, ma ui kaai tenglik Beniaamin, naa iaau mulu ut mi, iaau pirpir karom muaat. ");
INSERT INTO rai_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Muaat a wapua tamaang naa iaau aa lo paa a ngaala na kini na tena naagagon min raap Aaigipto, ma muaat a wapuai u ra kum utnaa raap mi muaat aa babo taai. Ma muaat a ben gagaa taa tamaang urin.” ");
INSERT INTO rai_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ma i kado a ru limaana karom tenalik Beniaamin, i raat paai ma i luan. Ma Beniaamin kaai i raat paai ma i luan. ");
INSERT INTO rai_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma karom a kum tatena likik raap, i dum a kum papaara waandiat ma i luan diat. Namur a kum tatena liklik diat pirpir ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Baa a wewapua i tuk paa a ruma anun Paraao, naa a kum tatein Iosep diat aa waan paat, Paraao ma anuna kum mukmuga raap diat gaaia. ");
INSERT INTO rai_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Paraao i piri karom Iosep, “Wapua a kum tatem liklik naa diat a paami lenbi: Diat a lo paa ta kum utnaa na winangaan ma diat a wakaai u ra kum wewagua, ma diat a waan talili urong Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ma diat a ben paa tamaamuaat ma anundiat kum naat karom iaau. Ang taar a koina pakaana aakit ko ra pia Aaigipto karom diat, ma diat a aan a koina utnaa ko ra pia maa. ");
INSERT INTO rai_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Un wapua diat kaai naa diat a paami lenbi: Diat a lo paa ta kum kiki na winawaan taanga min Aaigipto kup a kum natnatundiat ma ra nundiat kum taulaa, ma diat a ben paa tamaamuaat ma diat a waan urin. ");
INSERT INTO rai_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Diat a maadek wa anundiat kum utnaa raap, maa a kokoina utnaa raap taanga Aaigipto din taari taandiat.” ");
INSERT INTO rai_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Io, a kum natnatun Israael diat paami lenmaa. Iosep i taar taa a kum kiki na winawaan taan diat, lenutmaa Paraao ia naagagon taai, ma i taar taa kaai andiat kiniwa kup anundiat winawaan u ra aakapi. ");
INSERT INTO rai_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ma karom diat raap raaraa i taar a kum matakina maalu na minong, iaku karom Beniaamin i taar tula maar na pakpakaana silwa ma limnain maalu na minong. ");
INSERT INTO rai_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ma bi kaai ia i taar wai kup tamaana: 10 dongki baa di wakaa a kum kokoina utnaa taanga Aaigipto uni, ma 10 tabuan na dongki kaai baa di wakaa taa wit, a bred ma raa kum utnaa na winangaan kaai uni kup a winawaan anun tamaana urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Namur i tula wa a kum tatena liklik, ma baa diat aa waninaar na winawaan, i piri karom diat lenbi, “U ra numuaat winawaan, koku muaat kaankaan wetwetalaai karom muaat.” ");
INSERT INTO rai_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Io, diat waan taanga Aaigipto ma diat waan paat karom Iaakob a tamaandiat irong u ra pia Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Diat wapuai naa, “Iosep kurong utbaai i lalaaun! Ia lo paa a kiki na tena naagagon irong raap Aaigipto.” Iaakob i kakaian ma a nuknukina i tabanot ma pa i pirpir laar paai. Pa i nurnur un diat. ");
INSERT INTO rai_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Iaku baa diat wapuai u ra kum pirpir raap baa Iosep ia wapua ta diat uni, ma baa i babo a kum kiki na winawaan baa Iosep i taar wai kupi din wakaa talili paai mai, a nuknukina i ki balet. ");
INSERT INTO rai_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ma i piri lenbi, “Iaau nurnur maraagaam! Natunglik Iosep i lalaaun utbaai. Ang waan ma ang babo muga taai, baa ang maat maku.” ");
INSERT INTO rai_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Io, Israael i waan ungaai ma ra nuna kum utnaa raap, ma baa i waan paat irong Ber-Sebaa i tun wetabaar karom a God anun tamaana Aaisaak. ");
INSERT INTO rai_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma u ra marum God i pirpir karom Israael u ra binabo lenbi, “Iaakob! Iaakob!” Iaakob i baalui, “Mi ut iaau.” ");
INSERT INTO rai_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","God i piri naa, “Iaau God, a God anun tamaam. Koku u burut kupi un waan urong Aaigipto, maa iaau ang wangaala anum wuna taara, ma diat a waan paat a ngaala na wuna taara marong. ");
INSERT INTO rai_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Iaau ang waan ungaai ma ui urong Aaigipto, ma iaau ut ang ben talili ui balet. Ma Iosep ut in paam doko pa ui.” ");
INSERT INTO rai_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ma Iaakob baa raa iaana kaai Israael, i waan kon Ber-Sebaa. Ma a kum natnatuna diat wakaa paa tamaandiat, anundiat kum taulaa ma ra kum natnatundiat u ra kum kiki na winawaan baa Paraao i taar wai kupi din wakaa diat uni. ");
INSERT INTO rai_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Diat ben paa kaai anundiat kum wewagua ma ra kum utnaa raap baa diat kalei irong Kaanaan. Io, Iaakob ma diat raap baa i wangaala diat, diat waan urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","I ben a kum natnatuna a kum muaana ma a kum tabuan, ma ra kum taptabuna a kum muaana ma a kum tabuan ma diat raap baa i wangaala diat. ");
INSERT INTO rai_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Bi ia a iaa ra kum natnatun Israael, baa raa iaana kaai Iaakob, baa diat waan urong Aaigipto: Ruben a mugaana naat muaana anun Iaakob. ");
INSERT INTO rai_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Bi diat a iaa ra kum natnatun Ruben a kum naat muaana: Aanok, Paalu, Esron ma Kaarmi. ");
INSERT INTO rai_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Bi diat a iaa ra kum natnatun Simion a kum naat muaana: Iemuel, Iaamin, Oaad, Iaakin, Soaar ma Saul. Saul a natu ra tabuan Kaanaan. ");
INSERT INTO rai_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Bi ditul a iaa ra tula natnatun Lewi a tula naat muaana: Gerson, Koaat ma Meraari. ");
INSERT INTO rai_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Bi diat a iaa ra kum natnatun Iuda a kum naat muaana: Er, Onaan, Selaa, Peres ma Seraa. Iaku Er ma Onaan diaar maat utbaai irong u ra pia Kaanaan. A ru natnatun Peres a ru naat muaana: Esron ma Aamul. ");
INSERT INTO rai_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Bi diat a iaa ra kum natnatun Isaakaar a kum naat muaana: Tolaa, Puaa, Iaasub ma Simron. ");
INSERT INTO rai_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Bi ditul a iaa ra tula natnatun Sebulon a tula naat muaana: Sered, Elon, ma Iaalel. ");
INSERT INTO rai_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bi diat a kum naat muaana baa Leaa i buta ta diat un Iaakob irong Mesopotaamia, ma ra kum taptabuna. Ma raa natuna a tabuan a iaana Dina. Ain tabuan ma ra in muaana raap 33 diat. ");
INSERT INTO rai_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Bi diat a iaa ra kum natnatun Gaad a kum naat muaana: Sepon, Aagi, Suni, Esbon, Eri, Aarodi ma Aareli. ");
INSERT INTO rai_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Bi diat a iaa ra kum natnatun Aaser a kum naat muaana: Imnaa, Iswaa, Iswi ma Beriaa. Ma a teindiat a tabuan a iaana Sera. Bi diaar a iaa ra ru natnatun Beriaa a ru naat muaana: Eber ma Maalkiel. ");
INSERT INTO rai_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bi diaar a ru natun Silpaa a ru naat muaana baa i buta ta diaar un Iaakob, ma ra kum taptabuna. Silpaa a tultul na tabuan baa Lebaan i taar taai karom natuna Leaa. Diat raap 16 diat. ");
INSERT INTO rai_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Bi diaar a iaa ra ru naat muaana a ru natun Raakel a taulaa anun Iaakob: Iosep ma Beniaamin. ");
INSERT INTO rai_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Irong Aaigipto, Aasenaat, a natun Potiperaa a tena tuntun wetabaar taangirong On, i buta taa a ru naat un Iosep, a ru naat muaana. A iaandiaar Maanaase ma Eparaaim. ");
INSERT INTO rai_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bi diata iaa ra kum natnatun Beniaamin, a kum naat muaana: Belaa, Beker, Aasbel, Geraa, Naamaan, Eki, Ros, Mupim, Upim ma Aared. ");
INSERT INTO rai_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bi diaar a ru natnatun Raakel baa i buta ta diaar un Iaakob, ma ra kum taptabuna. Diat raap 14 diat. ");
INSERT INTO rai_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Raa natun Daan a naat muaana a iaana Usim. ");
INSERT INTO rai_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Bi diat a iaa ra kum natnatun Naaptaali a kum naat muaana: Iaasiel, Guni, Ieser ma Silem. ");
INSERT INTO rai_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bi diaar a ru natnatun Bilaa a ru naat muaana baa i buta ta diaar un Iaakob, ma ra kum taptabuna. Bilaa a tultul na tabuan baa Lebaan i taar taai karom natuna Raakel. Diat raap 7 diat. ");
INSERT INTO rai_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Io, a niluluk raap i ra wuna taara anun Iaakob baa diat waan urong Aaigipto i welaar ma 66 diat. A kum tabuan anu ra kum natnatun Iaakob pa te i luk diat u ra niluluk bi. ");
INSERT INTO rai_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Irong Aaigipto kaai Iosep ma ru natnatuna, a nilulukindiat raap a wuna taara anun Iaakob irong Aaigipto i welaar ma 70. ");
INSERT INTO rai_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iaakob i tula muga wa Iuda karom Iosep kupi in waiaa taai u ra aakapi urong Gosaan. Baa diat waan paat irong Gosaan, ");
INSERT INTO rai_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Iosep i waninaar paa nuna kiki na winawaan ma i waan urong kupi in babo tamaana Israael. Baa i babo paa tamaana, i raat paai ma i luani a ngaala na iwan. ");
INSERT INTO rai_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ma Israael i piri taana lenbi, “Iaau ut, iaau aa babo taa a mataam ma iaau nunurai naa kuri utbaai u lalaaun. Io, i koina ku baa ang maat.” ");
INSERT INTO rai_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Iosep i pirpir karom a kum tateina ma a taara baa diat weur ma tamaana lenbi, “Iaau ang waan ma ang wapua taa Paraao naa, ‘A kum tateng liklik ma ra taara baa diat weur ma tamaang diat aa waan taangirong Kaanaan ma kuri ma diat naang. ");
INSERT INTO rai_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","A kum muaana mi diat a kum tena baboura sip ma ra kum bulumakaau. Ma a kum utnaa raap anundiat, diat lo raapi ut urin, a kum sip, a kum bulumakaau ma raa kum utnaa utkaai.’ ");
INSERT INTO rai_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Baa Paraao in wataa pa muaat ma in tiri muaat naa, ‘Aawa maa anumuaat pinapaam?’ ");
INSERT INTO rai_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","muaat a baalui lenbi, ‘Miaat anum kum tultul, miaat laana baboura a kum wewagua turpaai ko ra kum kilaala baa miaat naat utbaai, lenutmaa a kum tamtamaamiaat kaai diat laana paami.’ Io, din mulaaot pa muaat kupi muaat a lalaaun u ra papaar Gosaan. In welwelik ko ra taara Aaigipto, maa diat milikuaana a kum tena baboura wewagua.” ");
INSERT INTO rai_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Iosep i waan ma i wapua Paraao naa, “Tamaang ma ra kum tateng liklik ungaai ma ra nundiat kum sip, kum bulumakaau ma ra nundiat kum utnaa raap, diat aa waan paa taangirong Kaanaan ma mi kurong ma diat Gosaan.” ");
INSERT INTO rai_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Iosep i pilak paa lima na tatena liklik ma i ben ta diat karom Paraao. ");
INSERT INTO rai_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Paraao i tiri diat lenbi, “Aawa maa anumuaat pinapaam?” Diat baalui naa, “Miaat anum kum tultul, miaat a kum tena baboura wewagua, lenutmaa a kum tamtamaamiaat diat laana paami.” ");
INSERT INTO rai_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ma diat piri kaai lenbi karomi, “Miaat waan kupi miaat a ki kumun min, kabina maa a minolo i waan paat kaai irong Kaanaan, ma anumiaat kum sip pa andiat ta koina wali na winangaan. Io, mi miaat aaring na maarmaari karom ui kupi un maadek ta miaat baa miaat a ki kumun irong Gosaan.” ");
INSERT INTO rai_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Paraao i piri karom Iosep, “Tamaam ma ra kum tatem liklik diat waan urin karom ui. ");
INSERT INTO rai_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ma a pia Aaigipto i ki u ra num naagagon, un waki taa tamaam ma ra kum tatem liklik un ta koina wanua. Taar taa a pia Gosaan kupi diat a lalaaun iaai. Ma baa u nunura ta taara kon diat baa diat kaapa wakaak kup a baboura wewagua, io, ung ta diat kupi diat a baboura anung kum wewagua.” ");
INSERT INTO rai_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ma Iosep i ben paa tamaana Iaakob ma i waiaa taai karom Paraao. Namur Iaakob i pir wadaan taa Paraao. ");
INSERT INTO rai_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Paraao i tiri Iaakob, “Taiaadi ma anum kilaala na lalaaun?” ");
INSERT INTO rai_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ma Iaakob i piri karom Paraao naa, “Anung kum kilaala na winawaan min u ra rakrakaan buaal i welaar ma 130. Anung winawaan na lalaaun pa i iok welaar ma ra lalaaun anu ra kum tamtamaang, ma iaau aa baraata taa mongoro na mawaat.” ");
INSERT INTO rai_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ma Iaakob i pir wadaan taa balet Paraao ma i pari ko ra mugaana mataana. ");
INSERT INTO rai_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Io, Iosep i waki taa tamaana ma ra kum tatena liklik irong Aaigipto ma i tabaara diat ma ra koina pakaana pia irong u ra taamaan Raameses, baa i koina ko ra kum pia raap irong Aaigipto, lenutmaa Paraao ia naagagon taai. ");
INSERT INTO rai_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Iosep i tabaara tamaana, a kum tatena liklik ma ra taara raap baa diat ki ungaai ma tamaana, ma ra utnaa na winangaan. I tabaara diat welaar ut ma ra niluluk in raaraa kaba tamaana. ");
INSERT INTO rai_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","A minolo mi i dekdek aakit maraagaam ma pa ta utnaa na winangaan u ra kum taamtaamaan raap. A taara raap irong u ra pia Kaanaan ma Aaigipto diat pot na maarmaari ma ra minolo. ");
INSERT INTO rai_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","A taara Aaigipto ma Kaanaan diat waraap wa anundiat maani u ra kul wit, ma Iosep i lo raap wa a maani karom Paraao. ");
INSERT INTO rai_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Baa a taara Aaigipto ma a taara Kaanaan diat baboi naa anundiat maani ia raap, diat waan karom Iosep ma diat piri lenbi, “Miaat aa waraap wa anumiaat maani. Un tabaara miaat ma ta utnaa na winangaan. Kup aawa maa u babo miaat ku lenmi baa miaat a maat namataam?” ");
INSERT INTO rai_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Iosep i piri ku taandiat naa, “Baa muaat aa waraap wa anumuaat maani, io iaau ang wiura utnaa na winangaan karom muaat ma muaat a kuli ma ra numuaat kum wewagua.” ");
INSERT INTO rai_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Io, diat ben taa anundiat kum wewagua karom Iosep ma i kiaana diat kup a utnaa na winangaan. Ma u ra kilaala maa, Iosep i kiaana anundiat kum os, kum dongki, kum bulumakaau, kum sip ma ra kum me, kup a utnaa na winangaan. Ma a taara diat lalaaun raap. ");
INSERT INTO rai_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Baa a kilaala maa ia raap, io, diat waan balet karom Iosep, ma diat piri naa, “Tadaaru, pa miaat a walipa laar paa ta utnaa kon ui, anumiaat maani ia raap, ma anumiaat kum wewagua kaai anum maku. Pa ta utnaa ma kuri baa miaat a kukul mai, miaat maku ma ra numiaat pia. ");
INSERT INTO rai_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Kup aawa maa u babo miaat ku lenmi baa miaat a maat namataam, ma ra numiaat kum pia kaai in buaal maku? Un kul pa miaat ungaai ma ra numiaat pia kupi a wekiaa i ra utnaa na winangaan. Ma miaat ma ra numiaat pia, miaat a ki u ra naagagon anun Paraao. Un tabaara miaat ma ra wit kupi miaat a lalaaun mai ma koku miaat maat, ma kupi a pia kaai koku i buaal.” ");
INSERT INTO rai_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Iosep i kul raap paa a pia Aaigipto kupi anun Paraao. A taara Aaigipto raap diat wiura wa anundiat kum pia, maa a minolo i dekdek aakit karom diat. ");
INSERT INTO rai_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A taara Aaigipto raap kon raa kukura taamaan kup raa kukura taamaan kaai, diat papaam na wilawilaau karom Paraao. ");
INSERT INTO rai_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Iaku a pia anu ra kum tena tuntun wetabaar karom anundiat kum god, Iosep pa i kuli. Kabina maa diat kulkul utnaa na winangaan ut ma ra maani baa Paraao i laana dok diat mai u ra nundiat pinapaam. Bi ia a kabina baa pa diat wiura anundiat kum pia. ");
INSERT INTO rai_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Iosep i piri taa ra taara lenbi, “Mi iaau aa kul pa muaat ungaai ma ra numuaat kum pia karom Paraao. Bi ia a waina wit baa muaat a maaruti u ra numuaat kum pinapaam. ");
INSERT INTO rai_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Iaku baa a utnaa u ra numuaat kum pinapaam ia mugaan, muaat a taar raaraa kon limlima na utnaa na winangaan karom Paraao. Ma a utnaa baa i ki walili muaat a paam kotoi kup a maamuaat winangaan ungaai ma ra numuaat taara ma ra numuaat kum naat liklik, ma ta mangaan muaat a ung ingen wai kaai kup a minamaarut.” ");
INSERT INTO rai_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Diat piri naa, “Tadaaru, miaat aa baat paa a maarmaari namuga na mataam. U aa walaaun pa miaat. Koina ku, miaat a papaam na wilawilaau karom Paraao.” ");
INSERT INTO rai_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Io, Iosep i taar a naagagon mi karom a taara u ra kum taamtaamaan raap irong Aaigipto, naa raaraa kon limlima na utnaa na winangaan raap in waan karom Paraao. Tuk mi diat murmur utbaai a naagagon maa. A pia maku anu ra kum tena tuntun wetabaar karom anundiat kum god, Paraao pa i kakale uni. ");
INSERT INTO rai_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Io, a taara Israael diat ki ma matira u ra pia Aaigipto u ra papaar Gosaan. Diat lo paa a kum pia matira, diat babuta burbure, ma a nilulukindiat i tawa waanwaan. ");
INSERT INTO rai_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iaakob i lalaaun irong Aaigipto 17 na kilaala, ma a kilaala na lalaaun anuna i welaar ma 147 na kilaala. ");
INSERT INTO rai_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Baa a pakaana bung i marawaai waanwaan kup Iaakob, baa raa iaana kaai Israael, in maat, i wetulaa paa natuna Iosep ma i piri karomi, “Baa u maari iaau, un taraam u ra nung niaaring bi. Un ung pari a limaam natudaangi ra paraagum na kaking, ma un weweliman ma ra lingtatuna karom iaau, naa koku u punang iaau min Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Iaku baa iaau aa ngo welaar ma ra kum tamtamaang, un lo a minaating taanga min Aaigipto, ma un punang iaau u ra pakaana baa di aa punang taa a kum tamtamaang iaai.” Iosep i baalui naa, “Ang paami lenutmaa u aa pir taai.” ");
INSERT INTO rai_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Iaakob i piri naa, “Un weweliman karom iaau.” Ma Iosep i weweliman. Ma Iaakob i inep ukaal taau u ra nuna ina buka, ma i lotu. ");
INSERT INTO rai_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Namur Iosep i walangoroi naa tamaana i malaapaang. Io, i ben pa ru natnatuna, Maanaase ma Eparaaim, ma ditul waan. ");
INSERT INTO rai_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Baa di wapua taa Iaakob naa, “Natumlik Iosep mari ut ia,” io, Iaakob i wadekdek paai ku, ma i ki tur u ra baana. ");
INSERT INTO rai_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Iaakob i piri karom Iosep naa, “God baa i Dekdek Aakit i waan paat karom iaau irong Lus u ra pia Kaanaan ma i pir wadaan ta iaau marong. ");
INSERT INTO rai_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ma i piri taang lenbi, ‘Iaau ang tabaara ui ma mongoro na natnatum, un wabure, ma un waan paat a tamaa ra mongoro na wunwuna taara. Ma iaau ang taar a pia Kaanaan kupi anum takum ma karom anum taara namur taam.’ ");
INSERT INTO rai_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Baa pa iaau waan utbaai urin, u aa wangaala taa a ru natnatum a ru naat muaana min Aaigipto. Ma mi iaau nemi naa din luk diaar ungaai ma ra kum natnatung. Eparaaim ma Maanaase diaar aru natnatung, welaar ma Ruben ma Simion diaar aru natnatung. ");
INSERT INTO rai_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ta kum naat baa din buta ta diat un ui namur taan diaar bi, diat a kum natnatum. Diat a kakale u ra kum taamtaamaan baa Maanaase ma Eparaaim diaar a naagagoni. ");
INSERT INTO rai_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","“U ra nung winawaan talili taangirong Mesopotaamia, Raakel i maat taau taandaat irong u ra pia Kaanaan, ma iaau tapunuk aakit uni. Daat welwelik kinalik utbaai kon Epraat, io iaau punang taai maku u ra papaa ra aakapi baa i waan kup Epraat.” (A taamaan baa mari di waatungi ma Betilem.) ");
INSERT INTO rai_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Baa Israael i babo paa a ru natnatun Iosep, i wetiri naa, “Woi diaar mi?” ");
INSERT INTO rai_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iosep i baalu tamaana naa, “A ru natnatung baa God i tabaara ta iaau ma diaar min.” Io, Israael i piri, “Ben ta diaar urin karom iaau, baa ang pir wadaan ta diaar.” ");
INSERT INTO rai_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israael ia takaana ma pa i babo wakaak ma, maa a ruin mataana diaar aa gawul. Io, Iosep i ben taa a ru natnatuna marawaai karomi, ma tamaana i dum a papaara waandiaar ma i raat pa diaar. ");
INSERT INTO rai_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israael i piri karom Iosep lenbi, “Pa iaau nuki balet ma naa ang babo taa a mataam, iaku God ia mulaaot ta iaau kupi ang babo kaai a ru natnatum mi.” ");
INSERT INTO rai_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ma Iosep i aal atur paa ru natnatuna baa diaar ki naa ra kakin Israael, ma i ki but keke ma ra mataana unapia karom tamaana. ");
INSERT INTO rai_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ma namur Iosep i watur taa Eparaaim u ra papaara ot na limaana kup a maira na limaan Israael, ma Maanaase i watur taai u ra maira na limaana kup a ot na limaan Israael, ma i ben marawaai diaar karomi. ");
INSERT INTO rai_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Iaku Israael i kado bolo a ot na limaana ma i ungi u ra in lorin Eparaaim, a murmur. Ma i kado bolo a maira na limaana ma i ungi u ra in lorin Maanaase, a mugaana. ");
INSERT INTO rai_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Ma i pir wadaan Iosep lenbi, “A God baa tabung Aabaraam ma tamaang Aaisaak, diaar tartaraam karomi, in wadaan a ru naat bi. Ia a God baa anung tena baboura u ra nung lalaaun raap tuk u ra bung mi, a Aangelo baa i walaaun pa iaau ko ra nung kum mawaat. Diaar a wabure u ra rakrakaan buaal. Ma a taara pa diat a dumaana a iaang ma a iaan tabung Aabaraam ma ra iaan tamaang Aaisaak.” ");
INSERT INTO rai_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Baa Iosep i babo tamaana i ung a ot na limaana u ra in lorin Eparaaim, pa i gaaia. I piri naa, “Pate, tamaang, bi ia a mugaana naat. Un ung a ot na limaam u ra in lorina.” Io, i paam paa a limaan tamaana kupi in rakaan wai ko ra in lorin Eparaaim ma in ung taai u ra in lorin Maanaase. ");
INSERT INTO rai_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Iaku tamaana pa i mulaaot ma i piri, “Iaau aa nunurai, natunglik, iaau aa nunurai. A bure na taara diat a waan paat ut kon Maanaase. Iaku a murmur na tenalik in ki na ngaala taana, ma anuna wuna taara diat a waan paat mongoro na wunwuna taara.” ");
INSERT INTO rai_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Israael i pir wadaan ta diaar u ra bung maa ma i piri naa, “Baa a taara Israael diat a pir wadaan wetwetalaai diat, diat a waatung a ru iaamur, lenbi, ‘God in pir wadaan ui welaar ma i wadaan Eparaaim ma Maanaase.’” Io lenmaa, i ung taa Eparaaim a mugaana taan Maanaase. ");
INSERT INTO rai_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ma Israael i piri karom Iosep lenbi, “Iaau kariaana iaau naa ang maat ma, iaku God in ki ungaai ma muaat, ma in ben ta muaat balet kup a pia anu ra kum tamtamaamuaat. ");
INSERT INTO rai_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ma karom ui, anung wetabaar in ngaala taa ra wetabaar baa ang taari karom a kum tatem liklik. Ang tabaara ui ma ra koina pia irong Sekem, baa iaau lo paai ko ra taara Aamor ma ra nung in liwan na wineium ma ra nung panpanaak.” ");
INSERT INTO rai_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Namur Iaakob i wetulaa kup a kum natnatuna ma i piri lenbi, “Muaat a waan ungaai urin ma ang wapua muaat u ra aawa baa in waan paat un muaat u ra kum bungbung kuri namuga. ");
INSERT INTO rai_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","A kum natnatung, muaat a tur ungaai ma muaat a walangoro iaau, a tamaamuaat Iaakob. Muaat a walangoro a tamaamuaat Israael. ");
INSERT INTO rai_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, ui a mugaana natunglik, ui a dekdeking, ui a mugaana wakilang i ra dekdeking. Ui a ngaala baa a taara diat urur karom ui, a dekdekim i ngaala aakit. ");
INSERT INTO rai_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","U welaar ma ra in aal na daanim baa i dekdek aakit, baa pa te in paam kado paai. Iaku, pa un lo ma a kini na munuga, kabina maa u inep ungaai ku bulung ma ra nung taulaa, pa u ru a baang. ");
INSERT INTO rai_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simion ma Lewi diaar tenalik. Anundiaar ruin liwan na wineium pa diaar ngo ma ra wineium. ");
INSERT INTO rai_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Pang tur ungaai ma diaar baa diaar wepaak un ta utnaa baa diaar a paami. Pang taraam u ra nundiaar kum ninunuk, kabina maa diaar aa aak doko wa mongoro na muaana u ra nundiaar kaankaan, ma diaar bur a kum kaki ra kum karabaau u ra nundiaar kum gaaia biaa ku. ");
INSERT INTO rai_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","A naagagon karom diaar in aaka aakit, kabina u ra nundiaar kum kaankaan. Maa anundiaar mangaana kaankaan pa ta maarmaari uni. Iaau ang weraana wa a kum natnatundiaar, ma diat a ki werweraan. Diat a ki werweraan naliwan karom a taara Israael raap. ");
INSERT INTO rai_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Iuda, a kum tatem liklik diat a pir walaawa pa ui. U ra ru limaam un uwia paa anum kum ebaar. A kum tatem liklik diat a ki but keke karom ui. ");
INSERT INTO rai_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda, u welaar ma ra baarmaan na laaion. Natunglik, u welaar ma ra laaion baa i waan talili ko ra aan wirua, ma i inep wowowon, welaar ma ra tabuan na laaion baa pa te in pet reke taau naana, kaduk in kaankaan. ");
INSERT INTO rai_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ina buka na king pa in waan kon Iuda. Ina buka na king pa in kakaraai ko ra nuna wuna taara, tuk baa ia baa anuna ina buka maa in waan paat, ma a kum taamtaamaan raap diat a taraam karomi. ");
INSERT INTO rai_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Anuna mongoro na diwaai na waain aakit, io, in do biaa ku anuna dongki u ra kum diwaai na waain. In do biaa ku a naat na dongki u ra kum kokoina gagaana waain. Ma in gi maku anuna maalu u ra polo na waain, anuna iokaana maalu na minong u ra polo na waain baa i taar. ");
INSERT INTO rai_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A ruin kiok na mataana in taar dekdek taa ra polo na waain, ma a kaba lakono kaai in kabaang dekdek taa ra polo na tu i ra bulumakaau. ");
INSERT INTO rai_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulon in lalaaun nakono, ma anuna ina waalwaalian in koina ololo anu ra kum paraau. A tuktuk i ra nuna pia in marawaai naa ra taamaan Sidon. ");
INSERT INTO rai_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isaakaar i welaar ma ra dekdek na dongki, baa i inep pari naliwan u ra nuna ru kaa na nilalo. ");
INSERT INTO rai_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Baa i baboi naa i koina aakit anuna wanua na ningo, ma i koina aakit anuna pia, in taar taa a pupuakina kupi in lo a kum mawaat, ma in wakinalik paai karom te baa in wowo taai kupi in papaam karomi. ");
INSERT INTO rai_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Daan in naagagon anuna taara, maa diat kaai kon diat a taara Israael. ");
INSERT INTO rai_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan i welaar ma ra ina aakaina wui u ra papaara aakapi, baa in karaat a kaki ra os, kupi ia baa i kaa u ra os in katuk tataada unamur. ");
INSERT INTO rai_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Tadaaru, iaau ki walaang kup anum warwalaaun. ");
INSERT INTO rai_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaad, a kikil na taara na winalong diat a tur na wineium kupi, iaku in um diat ma in lu diat. ");
INSERT INTO rai_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aaser, ana pinapaam in wa wakaak, a kum utnaa na winangaan maa in topaa a king. ");
INSERT INTO rai_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naaptaali in welaar ma ra lomlom na diaa, baa i murmur anuna nemnem. Ma i buta paa a kum wakwakaak na naat. ");
INSERT INTO rai_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Iosep, in welaar ma ra in diwaai na waain baa i wa mongoro na waina, ain diwaai na waain baa i tur marawaai naa ra daanim, ma a kum gagagaana i kakaa bolo u ra liplip. ");
INSERT INTO rai_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","A kum tena papanaak diat a weium dekdek ungaai mai, diat a weium ma diat a nem na baanaakakai. ");
INSERT INTO rai_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Iaku anuna panpanaak kaai pa in ngo paa. A ru dekdek na limaana pa diaar a bilua, kabina u ra wewaraaut anun God karomi, a Dekdek na God anun Iaakob, a Tena Baboura, ia a Waat Ki anun Israael. ");
INSERT INTO rai_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Maa God anun tamaam in waraaut ui, God baa i Dekdek Aakit in pir wadaan ui. In taar a baata welaar ma ra wetabaar ko ra baakut, ma in wadaan ui ma ra palaa ko ra pia. In tabuan diat a daan, ma diat a babuta. ");
INSERT INTO rai_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","A pir wadaan anun tamaam karom ui i ngaala aakit, i ngaala taa ra pir wadaan baa i waan paat ko ra kum taangaai taanga namuga, ma i ngaala taa ra utnaa u ra kum taangaai baa diat tur takum. A kum pir wadaan raap mi in ki un Iosep, ma anuna kini na ngaala i ngaala taa ra kum tatena liklik. ");
INSERT INTO rai_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Beniaamin i welaar ma ra karangaap na paap baa i karangaap dekdek. U ra malaana i um anuna kum ebaar welaar ma ra karangaap na paap baa i aan a utnaa baa ia lebe paai. U ra maluraap i weraana a utnaa baa ia raa paai kon diat.” ");
INSERT INTO rai_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bi ia 12 wunwuna taara raap anun Israael ma mi ia kum pirpir baa tamaandiat i piri taan diat baa i pir wadaan diat. I pir wadaan a kum natnatuna ma ra pir wadaan baa i topaa diat raaraa. ");
INSERT INTO rai_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ma Iaakob i pirpir karom diat lenbi, “Iaau waninaar ma baa ang maat, ma ang ngo welaar ma ra nung taara baa diat maat muga taang. Muaat a punang iaau ungaai ma ra kum tamtamaang u ra maata na waat u ra pia anun Epron, a te Ket. ");
INSERT INTO rai_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","A maata na waat maa kurong u ra pia Maakpelaa, marawaai Maamre irong Kaanaan. Aabaraam i kul paai ungaai ma ra pakaana pia kon Epron a te Ket, kupi din punpunang minaat iaai. ");
INSERT INTO rai_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Matira di punang Aabaraam ma Saaraa anuna taulaa, di punang kaai Aaisaak ma Rebekaa anuna taulaa, ma iaau kaai iaau punang Leaa iaai. ");
INSERT INTO rai_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","A pia ma ra maata na waat maa, di kul paai ko ra taara Ket.” ");
INSERT INTO rai_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Baa Iaakob ia pirpir raap karom a kum natnatuna, i ung tato a ru kakina unate u ra baana. Ma i lo paa a tintinip na dadaip ma i ngo welaar ma ra nuna taara baa diat maat muga taana. ");
INSERT INTO rai_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iosep i inep taau nate un tamaana ma i luani ma i dum a papaara waana. ");
INSERT INTO rai_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ma Iosep i naagagon taa a kum doktaa baa diat laana papaam karomi, naa diat a wamong a minaatin Israael ma ta kum marasin kupi koku i mareng. Io, diat paami lenmaa. ");
INSERT INTO rai_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I welaar ut ma 40 bungbung baa a kum doktaa diat wamongi ma ra marasin, maa a pinapaam mi i laana lo ut 40 bungbung uni. Ma a taara Aaigipto diat ki na tapunuk kup Iaakob welaar ma 70 bungbung. ");
INSERT INTO rai_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Baa a kum bungbung na tapunuk ia raap, Iosep i piri karom a kum mukmuga anun Paraao naa, “Baa muaat a maari iaau, muaat a pirpir taau anung karom Paraao lenbi, ");
INSERT INTO rai_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tamaang ia weweliman ta iaau ma i piri lenbi naa, baa in maat, miaat a punangi u ra maata na waat baa ia ut ia kil muga taai, irong u ra pia Kaanaan. Io, mi un mulaaot wa iaau baa ang waan ma ang punang wa tamaang ma namur ang waan talili balet.’” ");
INSERT INTO rai_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Paraao i piri naa, “Un waan ma un punang wa tamaam, maa ia weweliman ta ui kupi un punangi.” ");
INSERT INTO rai_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Io, Iosep i waan kupi in punang wa tamaana. A kum tena pinapaam raap anun Paraao diat waan ungaai mai, ungaai ma a kum ngaalangaala ko ra nuna mataanitu, ma ra kum ngaalangaala raap kaai taangirong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Diat ungaai ma ra taara raap anun Iosep, kum tatena liklik, ma a taara raap anun tamaana Iaakob. A kum naat liklik maku, ma ra kum sip ma a kum bulumakaau maa diat ki talili irong Gosaan. ");
INSERT INTO rai_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","A kum kiki na winawaan, ma ra kum muaana baa diat waanwaan ma ra kum os diat kaai diat waan ut, a ngaala na taara maa diat waan ungaai mai. ");
INSERT INTO rai_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Baa diat waan paat u ra wanua baa di walwali wit iaai irong Aataad, marawaai u ra daanim Ioridaan, diat luan dekdek ma diat kulkulaai unaanga nate, ma matira Iosep i taar taa balet 7 na bung na tapunuk kup tamaana. ");
INSERT INTO rai_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","A taara Kaanaan baa diat lalaaun matira, diat babo a pinapaam na tapunuk baa di paami u ra wanua baa di walwali a wit iaai irong Aataad. Ma diat piri naa, “A taara Aaigipto diat paam waiaa a pinapaam na tapunuk.” Maa ia a kabina baa di waatung a wanua maa marawaai u ra daanim Ioridaan ma Aabel-Misraaim. ");
INSERT INTO rai_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Io, a kum natnatun Iaakob diat paami lenutmaa ia wapua ta diat uni. ");
INSERT INTO rai_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Diat loi kup a pia Kaanaan, ma diat punang taai u ra maata na waat u ra pia Maakpelaa, marawaai Maamre, a maata na waat ungaai ma ra pakaana pia baa Aabaraam i kul paai kon Epron a te Ket, kupi din punpunang minaat iaai. ");
INSERT INTO rai_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Iosep ungaai ma ra kum tateina raap, ma diat kaai baa diat waan ungaai mai kup a pupunang, diat waan talili raap balet urong Aaigipto namur taa ra pupunang. ");
INSERT INTO rai_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Baa a kum tatein Iosep diat baboi baa tamaandiat ia maat, diat piri lenbi, “Baa Iosep in nuknuk na binabaalu karom daat, u ra mangamangaan baa daat aa paam taai uni, daat a lawaai ma?” ");
INSERT INTO rai_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Io, diat taar wa a pirpir karom Iosep lenbi, “Tamaam ia ung taa a naagagon bi namur baa i maat maku. ");
INSERT INTO rai_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","I piri naa, ‘Bi ia a pirpir baa muaat a piri karom Iosep: Iaau aaring ui baa un dumaana wa aakaina baa a kum tatem liklik diat aa paam taai un ui. Maari diat ma un dumaana wa anundiat aakaina, maa diat kaai a kum tultul anun God anun tamaam.’” Baa anundiat wewapua i tuk paa Iosep, Iosep i luan. ");
INSERT INTO rai_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","A kum tateina diat waan paat karomi, diat ki but keke namuga naana, ma diat piri lenbi, “Miaat a papaam na karabus karom ui.” ");
INSERT INTO rai_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Iaku Iosep i piri taan diat naa, “Koku muaat burut. Iaau wakir God. ");
INSERT INTO rai_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Muaat nem na baanaakaka iaau, iaku God i pukui kup a koina, kupi in paam ot paa a nuknukina mari daat baboi, baa i walaaun paa mongmongoro na taara. ");
INSERT INTO rai_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Io, koku muaat burut. Iaau ang tabaara muaat ma a kum natnatumuaat kaai.” Ma Iosep i pirpir na maarmaari karom diat, ma i wango a nuknukindiat. ");
INSERT INTO rai_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iosep i ki irong Aaigipto ungaai ut ma ra wuna taara anun tamaana. I lalaaun paa 110 kilaala. ");
INSERT INTO rai_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ma i babo taa ut a wetula taaun taara, a kum taptabun Eparaaim. Ma i babo taa utkaai a kum natnatun Maakir a natun Maanaase. A kum natnatun Maakir baa di buta diat, di ung ta diat naa ra kakin Iosep kupi diat a kum natnatun Iosep ma. ");
INSERT INTO rai_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Iosep i piri karom a kum tateina naa, “Iaau ang maat ma. Iaku God in waraaut muaat, ma in ben pari pa muaat ko ra pia mi, ma in ben ta muaat kup a pia baa ia weweliman taai karom Aabaraam, Aaisaak ma Iaakob.” ");
INSERT INTO rai_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ma Iosep i wapua a taara anun Israael naa, “Muaat a weweliman karom iaau naa, u ra bung baa God in waraaut muaat ma in ben apari pa muaat, muaat a lo paa utkaai a ururing ma muaat a waan pari ungaai mai ko ra taamaan mi.” ");
INSERT INTO rai_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ma Iosep i maat baa i 110 kilaala anuna. Ma namur diat wamong taa a minaatina ma ra kum marasin kupi koku i mareng. Ma diat waruk taai u ra bok na minaat irong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Bi ia a iaa ra wuna taara taanga namuga baa Iesu Kaarisito, a natun Dewid, a natun Aabaraam i waan paat kon diat. ");
INSERT INTO rai_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabaraam a tamaan Aaisaak, Aaisaak a tamaan Iaakob, ma Iaakob a tamaan Iuda ma ra kum tatena liklik. ");
INSERT INTO rai_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda a tamaan Peres ma Seraa, ma a naandiaar Taamaar. Peres a tamaan Esrom, Esrom a tamaan Aaraam, ");
INSERT INTO rai_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ma Aaraam a tamaan Aaminadaab, Aaminadaab a tamaan Naason, ma Naason a tamaan Saalmon, ");
INSERT INTO rai_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saalmon a tamaan Boaas, ma naana a iaana Raab. Boaas a tamaan Obed, ma naana a iaana Rut. Obed a tamaan Iese, ");
INSERT INTO rai_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ma Iese a tamaan Dewid, baa a king. Dewid a tamaan Solomon, ma naana a tabuan baa i taulaa paa ma Uraia. ");
INSERT INTO rai_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon a tamaan Roboaam, Roboaam a tamaan Aabia, Aabia a tamaan Aasa, ");
INSERT INTO rai_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa a tamaan Iosapaat, Iosapaat a tamaan Ioraam, ma Ioraam a tamaan Usia, ");
INSERT INTO rai_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia a tamaan Iotaam, Iotaam a tamaan Aakaas, ma Aakaas a tamaan Esekia, ");
INSERT INTO rai_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia a tamaan Maanaase, Maanaase a tamaan Aamon, ma Aamon a tamaan Iosia, ");
INSERT INTO rai_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia i wangaala Iekonia ma ra kum tatena liklik. Namur taana a taara Israael diat waan na karabus irong Baabilon. ");
INSERT INTO rai_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Namur taa ra winawaan urong Baabilon: Iekonia i wangaala Salaatiel, Salaatiel a tamaan Serubaabel, ");
INSERT INTO rai_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubaabel a tamaan Aabiuda, Aabiuda a tamaan Eliaakim, ma Eliaakim a tamaan Aasor, ");
INSERT INTO rai_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aasor a tamaan Saadok, Saadok a tamaan Aakim, ma Aakim a tamaan Eliud, ");
INSERT INTO rai_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud a tamaan Eleaser, Eleaser a tamaan Maataan, ma Maataan a tamaan Iaakob, ");
INSERT INTO rai_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iaakob a tamaan Iosep, ia baa i taulaa ma Maaria. Maaria i buta Iesu, baa di waatungi naa Kaarisito, ia baa God i tula wai. ");
INSERT INTO rai_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A kum taaun taara turpaai kon Aabaraam tuk un Dewid welaar ma 14 diat, ma kon Dewid tuk u ra winawaan na karabus urong Baabilon 14 kaai diat, ma ko ra winawaan na karabus urong Baabilon tuk un Kaarisito 14 a taautaaun taara diat kaai. ");
INSERT INTO rai_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Di buta paa Iesu Kaarisito lenbi: Naana Maaria, di aa pet baat taai karom Iosep, iaku namuga taa ra nundiaar tinaulaa Maaria ia nunurai naa i kipbaala u ra Takado na Nion. ");
INSERT INTO rai_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosep baa di aa pet baat taa Maaria karomi, ia a tena takado, ma pa i nemi naa in baana wawirwir Maaria naa ra taara. Io, i nuki naa in kutu ino wa anundiaar weweliman kup a tinaulaa. ");
INSERT INTO rai_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Baa i nuknuk utbaai u ra utnaa mi, a aangelo anu ra Tadaaru i waan paat karomi u ra beberon ma i piri naa, “Iosep, natun Dewid, koku u aalawur nuknuk un Maaria, un ben paai kupi anum tabuan. Maa a naat baa i kipbaala paai i waan paat ko ra Takado na Nion. ");
INSERT INTO rai_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","In buta paa a naat muaana ma un taar taa iaana baa Iesu, kabina maa in walaaun paa anuna taara ko ra nundiat kum aakaina mangamangaan.” ");
INSERT INTO rai_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A kum utnaa raap mi i waan paat kupi din paam ot paa a kum pirpir anu ra Tadaaru baa anuna propet ia wapuaana taai naa, ");
INSERT INTO rai_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Baboi, a tauraara na tabuan in kipbaala ma in buta paa a naat muaana ma din waatungi naa Emaanuel,” Aais 7:14 a kukuraaina naa, “God i ki ungaai ma daat.” ");
INSERT INTO rai_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Io, baa Iosep i tawaangun i paami lenutmaa a aangelo anu ra Tadaaru ia wapua taai uni, ma i ben paa Maaria kupi anuna tabuan. ");
INSERT INTO rai_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iaku pa diaar inep ungaai paa tuk baa Maaria i buta paa a naat muaana. Ma Iosep i taar taa a iaana baa Iesu. ");
INSERT INTO rai_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Di buta Iesu u ra taamaan Betilem u ra papaar Iudaia u ra kilaala baa Erodes i king. Namur raa kum tena manaana u ra kum naangnaang diat waan taanga welwelik u ra mataana taubaar ma diat waan paat inaanga Ierusalem. ");
INSERT INTO rai_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma diat wetiri naa, “Waiaa a naat baa di butai kupi in king anu ra taara Iudaia? Maa miaat babo paa anuna ina naangnaang irong u ra mataana taubaar, ma mi miaat waan urin kupi miaat a lotu karomi.” ");
INSERT INTO rai_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Baa king Erodes i walangoroi i purpuruan a nuknukina ma ra nuknuki ra taara Ierusalem raap kaai. ");
INSERT INTO rai_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Io, Erodes i ben ungaai raap paa a kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon. Ma i tiri diat naa, “Kaarisito baa God in tula wai din butai awaai?” ");
INSERT INTO rai_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Diat baalui naa, “U ra taamaan Betilem u ra papaar Iudaia, maa a propet ia timu taai naa, ");
INSERT INTO rai_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ma ui Betilem u ra papaar Iudaia, Ui pa u kinalik aakit taa ra kum mukmuga min Iudaia, Maa kabina a mukmuga in waan paat kon ui, baa in muga anung taara Israael welaar ma ra tena baboura sip.’” Mika 5:2 ");
INSERT INTO rai_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Namur Erodes i wetulaa ino paa a kum tena manaana kupi in manaana paa taan diat naa naangaian talaa maa ina naangnaang i waan paat. ");
INSERT INTO rai_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I tula wa diat urong Betilem ma ra pirpir lenbi, “Muaat a waan ma muaat a baat wakaak kup a naatlik. Ma baa muaat aa baat paai muaat a wapua iaau, baa iaau bulung ang waan ma ang lotu karomi.” ");
INSERT INTO rai_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baa diat aa walangoro taa a king diat waan. Diat babo paa balet ina naangnaang baa diat aa babo taai u ra mataana taubaar, i muga pa diat tuk i tur u ra wanua baa a naatlik kuraa iaai. ");
INSERT INTO rai_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Baa diat babo ina naangnaang maa, diat kariaana a ngaala na gaaia. ");
INSERT INTO rai_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Diat ruk u ra ruma ma diat babo paa a naatlik maa ma naana Maaria, diat ki but keke ma diat lotu karom a naat. Namur diat paapa paa anundiat kum wuwuwung ma diat tabaarai ma ra kum wetabaar lenbi, a goled ma ra bulit di tuni baa a tubalina i aangawian wakwakaak ma ra bulit na mangingi kaai di waatungi naa a mira. ");
INSERT INTO rai_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma God ia wakatom ta diat u ra beberon baa koku diat waan talili kup Erodes. Io, diat waan talili kup anundiat taamaan un raa aakapi ingen. ");
INSERT INTO rai_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baa diat aa waan, a aangelo anu ra Tadaaru i waan paat karom Iosep u ra beberon ma i piri naa, “Un tur, un ben paa naadinaana, mutul a kalaa ino urong Aaigipto. Ma mutul a ki iaai tuk u ra bung baa ang wapua ui balet, maa kabina Erodes in baat kup a naat kupi in aak dokoi.” ");
INSERT INTO rai_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Io, i tur, i ben paa naadinaana u ra marum, ma ditul waan urong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma ditul ki matira tuk baa Erodes i maat. Baa ditul paami lenmaa di paam ot paa a pirpir anu ra Tadaaru, baa a propet ia pirpir muga taau uni lenbi, “Iaau wataa paa natunglik taangirong Aaigipto.” Os 11:1 ");
INSERT INTO rai_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Baa Erodes i baboi baa a kum tena manaana diat aa waruga taai, i kaankaan aakit ma i wetulaa baa din aak doko araap wa a kum naat muaana taangirong Betilem ma ko ra kum taamaan kaai baa diat ki marawaai. I naagagoni naa din aak doko diat baa a ru kilaala indiat, ma diat kaai baa pa i ru kilaala utbaai un diat, kabina maa a kum tena manaana diat aa wapua taai u ra kilaala anu ra naat. ");
INSERT INTO rai_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Io, di paam ot paa maraagaam a pirpir baa Ieramia a propet i wewapua muga taau uni naa, ");
INSERT INTO rai_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Irong Raama di walangoro in ingaan raa, a niluan ma ra ngaala na kulkulaai, Raakel i luan a kum natnatuna liklik, maa diat aa maat raap, ma pa di wamaarip laar paai.” Ier 31:15 ");
INSERT INTO rai_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baa Erodes ia maat, a aangelo anu ra Tadaaru i waan paat karom Iosep u ra beberon irong Aaigipto. ");
INSERT INTO rai_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ma i piri taana naa, “Un tur, un ben paa naadinaana, ma mutul a waan urong Israael, maa diat baa diat nem na aak doko a naat diat aa maat.” ");
INSERT INTO rai_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Io, i tur, i ben paa naadinaana, ma ditul waan urong Israael. ");
INSERT INTO rai_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iaku baa i walangoroi naa, Aarkilaau i kiaana tamaana Erodes kupi ia bulung in king irong u ra papaar Iudaia, Iosep i burut baa in waan urong Iudaia. Ma God kaai i turbaat taai u ra beberon, io, ditul waan urong u ra papaar Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ma ditul waan ma ditul ki u ra taamaan a iaana Naasaret. Baa ditul paami lenmaa di paam ot paa a pirpir anu ra kum propet naa, “Din waatungi baa ia a te Naasaret.” ");
INSERT INTO rai_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Raa kum kilaala namur, Ioaanes a Tena Baapitaaiso i waan paat, ma i warawaai u ra bil na wanua u ra papaar Iudaia, ");
INSERT INTO rai_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma i piri naa, “Muaat a nukpuku, maa a mataanitu taanginaanga u ra maawa ia marawaai.” ");
INSERT INTO rai_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ioaanes ut maa a propet Aaisaia ia wewapua muga taau uni naa, “In ingaan raa i wewataai u ra bil na wanua lenbi, ‘Muaat a paam aara aakapi anu ra Tadaaru, muaat a paam kado anuna kum aakapi.’” Aais 40:3 ");
INSERT INTO rai_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioaanes i mong ma ra ina maalu na weu na kaamel, ma i wi baati ma ra panina bulumakaau, ma i aanaan a kum ko ma ra bulit baa a kum bi diat paami. ");
INSERT INTO rai_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A taara taanginaanga Ierusalem, ma ko ra kum taamtaamaan raap u ra papaar Iudaia, ma ko ra kum taamaan baa diat ki marawaai a daanim Ioridaan, diat waan karomi. ");
INSERT INTO rai_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Diat pir apuaana anundiat kum aakaina mangamangaan, ma i baapitaaiso diat u ra daanim Ioridaan. ");
INSERT INTO rai_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Baa Ioaanes i babo mongoro na Parisaaio ma ra kum Saadukaaio diat waan kupi in baapitaaiso diat, i piri taan diat naa, “Aai, muaat a kum natu ra kum wui! Woi maa i piri naa muaat a kalaa ino ko ra naagagon na binabaalu anun God baa in waan paat? ");
INSERT INTO rai_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Muaat a paam a kum utnaa baa in wapuaanai naa muaat aa nukpuku. ");
INSERT INTO rai_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma koku muaat nuki naa God pa in naagagon muaat maa kabina muaat a wuna taara anun Aabaraam. Iaau piri taa muaat naa, God i pet laar paai kupi in paam apaat paa a wuna taara anun Aabaraam ko ra kum waat bi. ");
INSERT INTO rai_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Di aa ung taa a naawa naa ra kum kapkabina diwaai, ma a kum diwaai raap baa pa diat wa ta koina waindiat, din bur wa diat, ma din ong ta diat u ra nguan. ");
INSERT INTO rai_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iaau baapitaaiso muaat ma ra palaa kupi in wapuaanai naa muaat aa nukpuku. Iaku ia baa in murmur taang i ngaala taang, ma in baapitaaiso muaat ma ra Takado na Nion ma ra nguan. Ma iaau, iaau kinalik aakit taana. ");
INSERT INTO rai_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I paam paa anuna saaol u ra limaana kupi in ong weraana a panina wit ko ra wit mulu. Baa ia wali raap taai in ung ungaai anuna wit u ra nuna ruma na wit, ma in tun wa a kum panpanina u ra nguan baa pa in maat.” ");
INSERT INTO rai_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iesu i waan taangirong u ra papaar Gaalilaia urong u ra daanim Ioridaan, karom Ioaanes kupi in baapitaaisoi. ");
INSERT INTO rai_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma Ioaanes i nem na turbaati, ma i piri taana naa, “I koina baa ui un baapitaaiso iaau. Aawa kabina baa u waan karom iaau kupi iaau ang baapitaaiso ui?” ");
INSERT INTO rai_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Iesu i baalui naa, “Un baapitaaiso iaau ku. I koina baa daar a paami kupi daar a paam ot paa a kum utnaa i takado, welaar ma ra nemnem anun God.” Io, Ioaanes i taraam taana. ");
INSERT INTO rai_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baa ia baapitaaiso taai, Iesu i or pari ko ra daanim, ma u ra pakaana bung maa a maawa i tapaapa, ma i babo a Nion God i waan pari welaar ma ra ina buna ma i ki taau nate uni. ");
INSERT INTO rai_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma in ingaan raa taanginaanga u ra maawa i piri lenbi, “Bi ia Natunglik, a naat na wakwakaak, iaau gaaia aakit uni.” ");
INSERT INTO rai_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Namur a Takado na Nion i muga paa Iesu unaanga u ra bil na wanua kupi Saataan in walaami. ");
INSERT INTO rai_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Baa ia wawel paa 40 bungbung na marum ma ra keke, io, i molo. ");
INSERT INTO rai_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma a Tena Walwalaam i waan paat karomi, ma i piri taana naa, “Baa ui a Natun God, un piri karom a kum waat bi kupi diat a tapuku kup diat a bred.” ");
INSERT INTO rai_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesu i baalui naa, “Di aa timu taai u ra Buk Taabu naa, ‘A taara pa diat lalaaun ko ra utnaa na winangaan ku, diat lalaaun u ra kum pirpir raap i pari ko ra waan God.’” Naag 8:3 ");
INSERT INTO rai_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Namur Saataan i ben paai unaanga Ierusalem, a taamaan anun God, ma i waki taai un raa pakaan inaanga nate aakit u ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma i piri taana naa, “Baa ui a Natun God, un irok pari, maa di aa timu taai u ra Buk Taabu lenbi, ‘In tula wa anuna kum aangelo kupi diat a baboura ui. Diat a lo pa ui ku ma ra kum limaandiat, kupi koku u tukaa paa a kakim un ta waat.’” Kele 91:11-12 ");
INSERT INTO rai_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu i baalui naa, “Di aa timu taai kaai u ra Buk Taabu lenbi, ‘Koku u walaar a Tadaaru anum God.’” Naag 6:16 ");
INSERT INTO rai_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Saataan i ben paai balet unaanga nate u ra ngaala na taangaai pi, ma i waiaa taa a kum mataanitu raap u ra rakrakaan buaal ma ra kum minamaar indiat raap kaai taana. ");
INSERT INTO rai_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma i piri taana naa, “A kum utnaa raap bi ang taar taai taam, baa un ki but keke ma un lotu karom iaau.” ");
INSERT INTO rai_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu i piri taana naa, “Saataan, un waan ingen, maa di aa timu taai u ra Buk Taabu lenbi, ‘Un lotu karom a Tadaaru anum God, ma un taraam ku karomi.’” Naag 6:13 ");
INSERT INTO rai_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ma Saataan i waan paa koni. Ma a kum aangelo diat waan karom Iesu, ma diat waraauti. ");
INSERT INTO rai_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Baa Iesu i walangoroi naa di aa waruk taa Ioaanes u ra ruma na karabus, i waan talili balet urong u ra papaar Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma baa i waan taangirong Naasaret, i ki Kaapernaaum, a taamaan baa i ki nakono naa ra taai kikil Gaalilaia, u ra pia anu ra wuna taara Sebulon ma ra wuna taara Naaptaali, ");
INSERT INTO rai_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","kupi in paam ot paa a pirpir anun God baa Aaisaia a propet ia pirpir muga taau uni lenbi, ");
INSERT INTO rai_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A pia anu ra wuna taara Sebulon ma ra pia anu ra wuna taara Naaptaali, marawaai a aakapi baa i waan unakono, u ra papaara daanim Ioridaan urong iaai, diaar ki u ra papaar Gaalilaia, baa a taara baa wakir a taara Iudaia diat ki iaai. ");
INSERT INTO rai_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A taara baa diat ki u ra baboto diat aa babo a ngaala na kaapa, ma diat baa a baboto na minaat i burung baat diat, a kaapa ia waan paat karom diat.” Aais 9:1-2 ");
INSERT INTO rai_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Turpaai u ra kilaala maa, Iesu i warawaai lenbi, “Muaat a nukpuku, maa a mataanitu taanginaanga u ra maawa ia marawaai.” ");
INSERT INTO rai_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Raa bung baa Iesu i wawaal nakono naa ra taai kikil Gaalilaia, i babo Simon, di waatungi kaai ma Petero, dina ma Aanderiaas, baa diaar ong bene nataai, maa diaar a ru tena ong bene. ");
INSERT INTO rai_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I piri taan diaar naa, “Mur a murmur iaau, ma ang wer mur kupi mur a ru tena aalaal taara.” ");
INSERT INTO rai_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Io, diaar tur paa maut ko ra nundiaar kum bene, ma diaar murmuri. ");
INSERT INTO rai_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Baa i waan taanga matira i babo paa bulung raa naadina Iaakobo ma Ioaanes, a ru natun Sebedaaio. Ditul tamaana ki u ra mon ma ditul ingit anunditul kum bene. Ma Iesu i wataa pa diaar. ");
INSERT INTO rai_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Diaar tur paa maut ma diaar waan ko ra mon ma ra tamaandiaar, ma diaar murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu i waan taltalili u ra papaar Gaalilaia raap, ma i wer a taara u ra nundiat kum ruma na lotu. I warawaai u ra Koina Wewapua u ra mataanitu taanginaanga u ra maawa. Ma i walaangalaanga paa a taara ko ra aalawur mangaana malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma a wewapua un Iesu i waan werweraan u ra papaar Siria raap, ma diat ben raap paa a taara baa a aalawur mangaana malaapaang i baanaakaka diat, a taara baa a dekdek na ngunungut i baanaakaka diat, ma diat baa a kum tabaraan diat ruk taau un diat, diat kaai baa diat maatmaat laau ma diat baa panpanindiat i maat, ma Iesu i walaangalaanga pa diat raap. ");
INSERT INTO rai_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma a ngaala na kor na taara taangirong u ra ru papaar Gaalilaia ma Dekaapolis, ma taanginaanga Ierusalem, ma ko ra papaar Iudaia ma taangirong un raa papaara daanim Ioridaan diat murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Baa Iesu i babo paa a kor na taara, i waan tato u ra taangaai. Ma baa i ki anuna taara na wawer diat waan karomi. ");
INSERT INTO rai_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma i wer diat lenbi, ");
INSERT INTO rai_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Diat baa diat nunurai naa diat iba u ra niondiat, diat daan, maa anundiat a mataanitu taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Diat baa diat luan ma ra tapunuk, diat daan, maa God in wamaraam diat. ");
INSERT INTO rai_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Diat baa diat wakinalik pa diat, diat daan, maa diat a kale paa a rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Diat baa diat molo ma diat maruk kup a mangamangaan na takado, diat daan, maa namur diat a maaur. ");
INSERT INTO rai_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Diat baa a kum tena maarmaari, diat daan, maa God in maari diat kaai. ");
INSERT INTO rai_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Diat baa a nuknukindiat i gomgom, diat daan, maa diat a babo God. ");
INSERT INTO rai_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Diat baa diat laana wamaalmaal a taara, diat daan, maa God in waatung diat naa a kum natnatuna. ");
INSERT INTO rai_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Diat baa di pet na bilbil un diat kabina u ra takado na mangamangaan, diat daan, maa anundiat a mataanitu taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Muaat daan baa di pir aakaka muaat, ma di pet na bilbil un muaat, ma di nuk paa ta kum warwaruga na pirpir ma di pir ururian muaat mai, kabina un iaau. ");
INSERT INTO rai_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muaat a gaaia, maa i ngaala aakit anumuaat wedok inaanga u ra maawa. Maa di aa pet na bilbil muga taau lenmaa u ra kum propet baa diat lalaaun muga taa muaat. ");
INSERT INTO rai_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Muaat a sol u ra rakrakaan buaal raap. Iaku baa ia raap a mapaakina, din wamapaak paai balet ma lelawaai? Pa ta utnaa ma i gaa uni. Din ong apari wai unataamaan, ma a taara diat a papaa maku nate uni. ");
INSERT INTO rai_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Muaat a kaapa u ra rakrakaan buaal raap. Ta taamaan baa i ki nate u ra taangaai, pa in wawalipa laar paai. ");
INSERT INTO rai_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pain te in wakup taa ta laam ma in kuop baat taai ma ra baaket, pate. Din ung taai ut nate u ra nuna turtur, ma in baarabaara karom diat raap baa diat ki naruma. ");
INSERT INTO rai_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lenkaai maa anumuaat kaapa in baarabaara namataa ra taara, kupi diat a babo anumuaat kum kokoina pinapaam, ma diat a pir walaawa paa Tamaamuaat baa i ki inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Koku muaat nuki naa iaau waan paat kupi ang rakaan wa a kum pirpir na Naagagon anun Moses ma ra kum wawer anu ra kum propet, pate. Pa iaau waan paat kupi ang rakaan wa diat, iaau waan paat kupi ang paam ot pa diat. ");
INSERT INTO rai_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iaau pir a lingtatuna taa muaat, tuk baa a baakut ma ra rakrakaan buaal diaar a panaai, pa ta mataana buk lik baa ta wakilang lik maku ko ra kum Naagagon mi in panaai. Din paam ot pa diat ut. ");
INSERT INTO rai_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Baa te pa i murmur ta kinalik na naagagon ko ra kum Naagagon mi, ma i wer araara a taara kupi diat kaai pa diat a murmuri, din waatungi baa i kinalik aakit u ra mataanitu inaanga u ra maawa. Iaku ia baa i taraam u ra kum Naagagon mi, ma i wer a taara uni din waatungi baa i ngaala u ra mataanitu inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lenmaa iaau piri taa muaat, baa anumuaat mangamangaan na takado pa in koina taa ra mangamangaan na takado anu ra kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a gaana ruk u ra mataanitu inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muaat aa walangoro taai naa, di aa pir taai taa ra taara taanga namuga lenbi, ‘Koku u aak doko te. Ma ia baa i aak doko wa te din naagagoni.’ ");
INSERT INTO rai_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iaku iaau, iaau piri taa muaat naa, baa te in kaankaan karom ta tenalik, din naagagoni kaai, ma baa te in pirpir aakaka un ta tenalik, din naagagoni namataa ra taara na kiwung. Ma baa te in piri un ta muaana naa, ‘A longlong ui,’ kaduk a naagagon karomi baa din ongi u ra ngaala na nguan. ");
INSERT INTO rai_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Baa u waan kupi un taar anum wetabaar u ra luwu na tuntun wetabaar, ma u nuk paa ta utnaa baa temlik i takuna ui uni, ");
INSERT INTO rai_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","un paki taa anum wetabaar matira naa ra luwu na tuntun wetabaar. Un waan kumun, mur a wemaraam muga paa ma temlik, ma namur un waan talili balet, io un taar maraagaam anum wetabaar. ");
INSERT INTO rai_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Baa te in ung ta ui u ra naagagon, mur a wemaraam muga baa mur waanwaan utbaai u ra aakapi, kaduk in taar ta ui karom a tena naagagon. Ma a tena naagagon in taraama wa ui karom a tena baboura ma in waruk ta ui u ra ruma na karabus. ");
INSERT INTO rai_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iaau pir a lingtatuna taam, pa un pari laar paai tuk ut baa un taar araap wa a tintinip na toiaa i ra num winekul. ");
INSERT INTO rai_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muaat aa walangoro taai naa di aa pir taai lenbi, ‘Koku u paam aakaina un ta tabuan anun te.’ ");
INSERT INTO rai_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Iaku iaau, iaau piri taa muaat naa, baa ta muaana in babo taa ta tabuan ma a nuknukina i aaka karomi, ia paam aakaina u ra nuknukina, ma namataan God ia paam taa aakaina u ra tabuan maa. ");
INSERT INTO rai_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Baa ina ot na mataam i ben araara ui kup a aakaina, un lior wai, ma un ong ingen wai. In koina baa raa pakaan ku ko ra panim din ong wai, ma koku di ong a panim raap u ra ngaala na nguan. ");
INSERT INTO rai_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Baa a ot na limaam i ben araara ui kup a aakaina, un kutu wai ma un ong ingen wai. In koina baa raa pakaan ku ko ra panim din ong wai, ma koku di ong a panim raap u ra ngaala na nguan. ");
INSERT INTO rai_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Di aa pir taai kaai naa, ‘Ia baa i lu wa anuna tabuan, in taar taa kaai a dona buk na kutu tinaulaa taana.’ ");
INSERT INTO rai_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iaku iaau, iaau piri taa muaat naa, baa a tabuan pa i paam aakaina ma ta muaana, ma anuna muaana i lu biaa wai ku, a muaana maa i kabina u ra aakaina baa a tabuan i paami baa i taulaa balet. Ma ia baa i taulaa ma ta tabuan baa anuna muaana i lu wai, ia kaai ia paam aakaina kabina maa a tabuan maa i taulaa ut. ");
INSERT INTO rai_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Muaat aa walangoro taai kaai naa, di aa pir taai taa ra taara taanga namuga naa, ‘Koku u weweliman warwaruga. A utnaa baa u aa weweliman taau uni karom a Tadaaru, un paami ut.’ ");
INSERT INTO rai_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iaku iaau, iaau piri taa muaat naa, koku muaat wadekdek a weweliman ma ta mangaana pirpir kaai. Koku muaat weweliman ma ra maawa, maa a maawa a kiki anun God. ");
INSERT INTO rai_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Koku muaat weweliman ma ra rakrakaan buaal, maa a rakrakaan buaal a wanua baa i ung a ru kakina uni. Koku muaat weweliman ma Ierusalem, maa Ierusalem a taamaan anu ra ngaala na King. ");
INSERT INTO rai_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Koku u weweliman ma ra in lorim, maa pa un paam puku laar paa tina weu na lorim kupi in kabaang, baa in marut. ");
INSERT INTO rai_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Muaat a piri ku naa maia, baa pate. Maa baa muaat a pir ta mangaana pirpir balet, i kabina maku ko ra Tena Aakaina. ");
INSERT INTO rai_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muaat aa walangoro taai baa di aa pir taai naa, ‘Baa te in lior wa tin mataan te, din baalui kaai karomi, din lior wa kaai tin mataana. Ma baa te in tibul bor wa tin lakon te, din baalui kaai karomi, din tibul bor wa kaai tin lakono.’ ");
INSERT INTO rai_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iaku iaau, iaau piri taa muaat naa, koku muaat baalu aakaina anun te baa i paami karom muaat. Baa te i paar taa a papaara ot na waam, un puku taa raa papaar bulung karomi. ");
INSERT INTO rai_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Baa te i nemi naa in aal ta ui u ra naagagon ma din naagagon ui kupi un taar taa anum siot taana, io un taar taa kaai anum ina maalu baa u laana burung baat anum minong mai. ");
INSERT INTO rai_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Baa te i maang pa ui kupi mur a weur kup ta taamaan baa i marawaai ku, io un weur mai kup a taamaan baa i ki welwelik kinalik. ");
INSERT INTO rai_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Un tabaara te baa i aaring ui. Ma baa te i nemi naa in lo paa kumun ta utnaa kon ui, io un taari ku taana. ");
INSERT INTO rai_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Muaat aa walangoro taai baa di aa pir taai naa, ‘Un maari tepaam, ma un nget anum ebaar.’ ");
INSERT INTO rai_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iaku iaau, iaau piri taa muaat naa, muaat a maari anumuaat kum ebaar, ma muaat a aaraaring un diat baa diat pet na bilbil un muaat, ");
INSERT INTO rai_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kupi muaat a kum natu ra Tamaamuaat, baa i ki inaanga u ra maawa. Maa i taar taa a mage kupi in kaapa karom a kum aakaina taara ma ra kum koina taara kaai, ma i taar taa a baata karom a kum tena takado ma karom diat kaai baa pa diat takado. ");
INSERT INTO rai_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Baa muaat maari diat ku baa diat maari muaat, aawa ma maa anumuaat wedok? A kum tena lolo tatakom, baa pa diat laa u ra maarmaari diat paampaami kaai lenmaa, naka? ");
INSERT INTO rai_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Baa muaat gaaigaaia paa ku a kum teptepaamuaat, muaat a koina lelawaai? A taara baa pa diat nurnur diat kaai diat gaaigaaia paa a kum teptepaandiat, naka? ");
INSERT INTO rai_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Muaat a takado aakit, welaar ma Tamaamuaat baa i ki inaanga u ra maawa, i takado aakit. ");
INSERT INTO rai_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Muaat a baboura muaat kupi koku muaat paam anumuaat koina pinapaam namataa ra taara ku, baa diat a babo muaat uni ma diat a pir walaawa pa muaat. Baa muaat paami lenmaa, pa numuaat ta wedok ko ra Tamaamuaat baa i ki inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Baa u tabaara a kum iba na taara, koku u wewapua muga taau kupi a taara diat a babo ui, welaar ma diat baa pa diat wetabaar ma ra lingtatuna u ra nundiat lalaaun diat laana paami u ra kum ruma na lotu ma u ra kum aakapi kaai, kupi a taara diat a pir walaawa pa diat uni. Iaau pir a lingtatuna taa muaat, a pir walaawa ko ra taara, ia ut maa anundiat kudulaana wedok. ");
INSERT INTO rai_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Baa u tabaara a kum iba na taara, koku te i nunura a utnaa baa u paami, un paam inoi. ");
INSERT INTO rai_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Baa u paami lenmaa, Tamaam baa i babo a utnaa baa u paam inoi, in taar a wedok taam. ");
INSERT INTO rai_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Baa muaat aaraaring, koku muaat welaar ma ra kum tena warwaruga. Diat nem aakiti naa diat a tur ma diat a aaraaring u ra kum ruma na lotu, ma u ra kum wanua baa a taara diat waanwaan ungaai iaai, kupi a taara diat a babo diat. Iaau pir a lingtatuna taa muaat, maa ut ia anundiat kudulaana wedok. ");
INSERT INTO rai_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Iaku ui, baa u aaraaring, un ruk u ra num ruma ma un balbalaat paa, ma un aaraaring karom Tamaam baa pa te i baboi. Ma Tamaam baa i babo a utnaa baa u paam inoi, in taar a wedok taam. ");
INSERT INTO rai_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Baa muaat aaraaring koku muaat pirpir biaa ku, welaar ma ra kum niaaring anu ra taara baa diat lotu karom a kum taabataaba. Maa diat nuki naa din walangoro diat baa diat pir mongoro na pirpir. ");
INSERT INTO rai_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Koku muaat welaar ma diat, maa Tamaamuaat ia nunura a kum utnaa raap baa muaat iba kupi baa pa muaat aaraaring utbaai. ");
INSERT INTO rai_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Muaat a aaraaring lenbi, ‘Tamaamiaat inaanga nate u ra maawa, i koina baa din ru a iaam. ");
INSERT INTO rai_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I koina baa anum mataanitu in waan paat. I koina baa din taraam taam u ra rakrakaan buaal, welaar ma di tartaraam taam inaanga nate u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","A bung mi un tabaara miaat ma ra maamiaat utnaa. ");
INSERT INTO rai_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Un dumaana wa anumiaat kum aakaina mangamangaan, welaar ma miaat dumaana wa anundiat kum aakaina mangamangaan karom miaat. ");
INSERT INTO rai_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Koku u ben miaat u ra walwalaam. Un walaaun miaat ko ra Tena Aakaina. Aamen.’ ");
INSERT INTO rai_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Baa muaat dumaana wa a kum aakaina mangamangaan baa a taara diat paami karom muaat, Tamaamuaat baa i ki inaanga u ra maawa in dumaana wa anumuaat kum aakaina mangamangaan kaai. ");
INSERT INTO rai_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Iaku, baa pa muaat dumaana wa a kum aakaina mangamangaan baa a taara diat paami karom muaat, Tamaamuaat kaai pa in dumaana wa anumuaat kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Baa muaat wawel, koku muaat babo tumtumul welaar ma ra kum tena warwaruga, maa diat babo tumtumul kupi in kaapa karom a taara naa diat wawel. Iaau pir a lingtatuna taa muaat, maa ut ia anundiat kudulaana wedok. ");
INSERT INTO rai_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Baa u wawel, un kom in lorim, ma un gi a mataam, ");
INSERT INTO rai_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kupi koku a taara diat nunurai naa u wawel. Tamaam ku in nunurai, ia baa pa te i baboi. Ma Tamaam baa i babo a utnaa baa u paam inoi, in taar a wedok taam. ");
INSERT INTO rai_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Koku muaat ung ungaai a kum ngaatngaat na utnaa min napia, maa a paropo ma ra tarok diaar a baanaakaka wa diat ku, ma a kum tena walong diat a reng paa anumuaat kum ruma ma diat a walongi. ");
INSERT INTO rai_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Muaat a murmur a kum kokoina mangamangaan kupi in welaar ma ra ngaatngaat na utnaa baa muaat ung ungaai inaanga u ra maawa, maa a paropo ma ra tarok pain diaar a baanaakakai, ma a kum tena walong kaai pain diat a walong laar paai. ");
INSERT INTO rai_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maa anum lalaaun in ki u ra taamaan baa anum ngaatngaat na utnaa i taana iaai. ");
INSERT INTO rai_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“A ruin kiok na mataandaat diaar welaar ma ra laam u ra panindaat. Baa a ruin kiok na mataam diaar koina, a panim raap in teng ma ra kaapa. ");
INSERT INTO rai_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Iaku, baa a ruin kiok na mataam diaar aaka, a panim raap in teng ma ra baboto. Baa anum kaapa i baboto ku, a baboto maa in ngaala aakit! ");
INSERT INTO rai_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Pa in tale ta tultul in papaam karom ta ru mukmuga. In nget raa paan diaar, ma in gaaia kup raa paan diaar, in taraam karom raa ma raa in wabulbul karomi. Pa muaat a papaam laar paai karom God ma karom a maani kaai. ");
INSERT INTO rai_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Bi ia kabina maa iaau piri taa muaat naa, koku muaat ngaraa u ra numuaat lalaaun baa aawa muaat a aani, ma aawa muaat a inimi, ma u ra panimuaat kaai baa aawa muaat a mong mai. Lelawaai, a lalaaun pa i ngaatngaat duk taa ra utnaa na winangaan? Baa lelawaai, a panindi pa i ngaatngaat duk taa ra maalu? ");
INSERT INTO rai_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muaat a babo a kum pika. Pa diat maarut ta utnaa, ma pa diat tangaa ungaai ta utnaa, ma pa diat wawalaaing un ta ruma na wuwuwung, iaku Tamaamuaat baa i ki inaanga u ra maawa, i taptabaara diat. Lelawaai, wakir duk muaat ngaatngaat aakit kon diat? ");
INSERT INTO rai_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Woi kon muaat baa i ngaraa in pet laar paai kupi in kanaawa paa balet ta pakaana bung lik u ra nuna lalaaun? Pate! ");
INSERT INTO rai_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma aawa kabina baa muaat ngaraa kup a maalu? Muaat a babo a kum purpur taanga nabuaal, baa diat tawa lelawaai. Pa diat papaam ma pa diat laana paam maalu. ");
INSERT INTO rai_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Iaku iaau piri taa muaat, King Solomon ut maa nuna minong raap i babo wakaak, iaku pa i babo wakwakaak welaar ma ra kum purpur maa. ");
INSERT INTO rai_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God i wamong a kum wali nabuaal ma ra kum koina pupuindiat, baa i pupu umari, ma unaburu din tun wai u ra nguan. Baa i paami lenmaa u ra kum wali, lelawaai, pa in wamong ta muaat kaai? I kinalik aakit anumuaat nurnur. ");
INSERT INTO rai_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Koku muaat ngaraa ma muaat piri naa, ‘Aawa maa daat a aani?’, baa ‘Aawa maa daat a inimi?’, baa ‘Aawa maa daat a mong mai?’ ");
INSERT INTO rai_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maa a taara baa pa diat nurnur diat ngaraa aakit kup a kum utnaa raap mi, ma Tamaamuaat baa i ki inaanga u ra maawa i nunurai naa muaat iba kup a kum utnaa raap mi. ");
INSERT INTO rai_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Muaat a ngaraa muga kup anuna mataanitu ma ra nuna takado na mangamangaan, ma in tabaara muaat ma ra kum utnaa raap mi. ");
INSERT INTO rai_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Io, koku muaat ngaraa kup unaburu, maa naburu in ngaraa paa ut uni. A nginaraa un raaraa bung i topaa ut a bung maa. ");
INSERT INTO rai_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Koku muaat naagagon te, kupi koku kaai din naagagon muaat. ");
INSERT INTO rai_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Maa a naagagon baa muaat naagagon te mai, ia ut maa din naagagon muaat balet mai, ma ra walawalar baa muaat walawalar mai, ia ut maa din walaar muaat balet mai. ");
INSERT INTO rai_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","I lawaai maa u babo paa ku a kurkur kuraa u ra in mataan temlik, ma pa u nuk paa a pakaan diwaai pi kuraa u ra in mataam ut? ");
INSERT INTO rai_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Baa a pakaan diwaai pi kuraa ku u ra in mataam, un piri lelawaai karom temlik naa, ‘Ang rakaan wa a kurkur ko ra in mataam’? ");
INSERT INTO rai_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ui a tena warwaruga, un lo muga wa a pakaan diwaai pi ko ra in mataam, io, un babo wakaak, kupi un rakaan wa a kurkur ko ra in mataan temlik. ");
INSERT INTO rai_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Koku muaat tabaara a kum paap ma ra gomgom na utnaa anun God, kaduk diat a tapuku ma diat a karaat muaat. Ma koku muaat ong anumuaat diwaara taa ra kum boro, kaduk diat a paa ginaginai ku ma ra kakindiat. ");
INSERT INTO rai_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Muaat a aaraaring ma din tabaara muaat, muaat a baatbaat ma muaat a baat paai, muaat a pipidik ma din paapa aara muaat. ");
INSERT INTO rai_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maa diat raap baa diat aaraaring din tabaara diat, ma ia baa i baatbaat in baat paai, ma ia baa i pipidik, din paapa aarai. ");
INSERT INTO rai_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Woi na paa muaat, baa natunalik in aaringi kup ta bred, in tabaarai ku ma ra waat? ");
INSERT INTO rai_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma baa in aaringi kup tina ian, in tabaarai ku ma ra ina wui? ");
INSERT INTO rai_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Baa muaat aakaina taara, muaat nunura ut a koina wetabaar karom a kum natnatumuaat, io, i lingtatuna aakit baa Tamaamuaat baa i ki inaanga u ra maawa, in tabaara diat baa diat aaringi ma ra kum kokoina utnaa. ");
INSERT INTO rai_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","A kabi ra pirpir na Naagagon anun Moses ma ra kum wawer anu ra kum propet i lenbi: A kum utnaa raap baa muaat nemi naa a taara diat a paami karom muaat, muaat kaai muaat a laana paami karom diat. ");
INSERT INTO rai_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Muaat a ruk u ra naat na bonanaaka lik. Maa a bonanaaka ma ra aakapi baa i parere ma i laangalaanga i waan kup a winirua takum, ma mongoro na taara aakit diat ruk uni. ");
INSERT INTO rai_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Iaku i kinalik a bonanaaka ma ra aakapi kaai, baa i waan kup a lalaaun, ma a kinalik na taara ku diat baat paai. ");
INSERT INTO rai_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Muaat a baboura muaat ko ra kum propet warwaruga. Diat waan karom muaat ma ra koina mangamangaan welaar ma ra kum sip, iaku maa u ra nuknukindiat diat nem na baanaakaka muaat welaar ma ra kum karangaap na paap. ");
INSERT INTO rai_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Muaat a babo lele a kum warwaruga na propet ko ra waindiat ut. Lelawaai, din git paa a waina waain ko ra in kadaa, ma ina waina fig ko ra in barudu? Painte! ");
INSERT INTO rai_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","A kum kokoina diwaai raap diat wa a koina waindiat, iaku in aakaina diwaai i wa a kum aakaina waina. ");
INSERT INTO rai_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","En koina diwaai pa in wa ta aakaina waina, ma in aakaina diwaai kaai pa in wa ta koina waina. ");
INSERT INTO rai_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A kum diwaai raap baa pa diat wa a koina waindiat, din bur wa diat ma din ong ta diat u ra nguan. ");
INSERT INTO rai_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lenmaa, muaat a babo lele a kum warwaruga na propet ko ra waindiat ut. ");
INSERT INTO rai_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Diat baa diat waatung iaau naa, ‘Tadaaru, Tadaaru,’ pain diat a ruk raap u ra mataanitu inaanga u ra maawa. Iaku diat baa diat murmur a nemnem anun Tamaang baa i ki inaanga u ra maawa, diat ot ku maa diat a ruk u ra nuna mataanitu. ");
INSERT INTO rai_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","U ra bung na naagagon mongoro diat a piri taang naa, ‘Tadaaru, Tadaaru, lelawaai, pa miaat pirpir na propet ma ra iaam, ma pa miaat lu irok wa kaai a kum tabaraan ma ra iaam, ma pa miaat paam mongoro na utnaa na kakaian ma ra iaam?’ ");
INSERT INTO rai_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ang baalu diat naa, ‘Pa iaau nunura kinkinalik ta muaat. Muaat a kum tena aakaina, muaat a waan ingen kon iaau.’ ");
INSERT INTO rai_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Lenmaa, diat raap baa diat walangoro anung kum pirpir mi, ma diat taraam uni, diat welaar ma ra tena manaana, baa i paam taa anuna ruma nate u ra waat. ");
INSERT INTO rai_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ma a baata i puka, a lomon i waan paat, ma ra dadaip i tapalaa ma i um a ruma maa, iaku pa i taripu laar paai, maa kabina di watur taai nate u ra waat. ");
INSERT INTO rai_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Diat raap baa diat walangoro anung kum pirpir mi, iaku pa diat taraam uni, diat welaar ma ra longlong, baa i paam taa ku anuna ruma nate u ra woio ma pa i punang dekdek a kum toro. ");
INSERT INTO rai_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma a baata i puka, a lomon i waan paat, ma ra dadaip i tapalaa ma i um a ruma maa, i taripu, ma i tareng aakaka maut.” ");
INSERT INTO rai_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Baa Iesu ia pir araap taa a kum pirpir mi, a kor na taara diat kakaian u ra nuna wawer, ");
INSERT INTO rai_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","maa i wer diat lenbaa ia ut i paam akoto a naagagon, ma pa i wer diat welaar ma ra nundiat kum tena wawer u ra kum Naagagon. ");
INSERT INTO rai_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Baa Iesu i waan pari taanginaanga u ra taangaai, mongoro na taara diat murmuri. ");
INSERT INTO rai_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma raa muaana, a wukawuka, i waan karomi, i ki but keke naana, ma i piri naa, “Tadaaru, pa i dekdek karom ui, baa u nemi, io, un walaangalaanga iaau.” ");
INSERT INTO rai_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ma Iesu i kado wa a limaana, i paam a panina, ma i piri taana naa, “Iaau nemi ut. Un laangalaanga.” Ma anuna malaapaang i raap maut. ");
INSERT INTO rai_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma Iesu i piri taana naa, “Koku wapua taa te uni. Un waan ma un waiaa muga ta ui karom a tena wetabaar karom God, ma un taar a wetabaar karom God welaar ma Moses ia pir taai. Baa un paami lenbi in kaapa karom a taara baa u aa laangalaanga.” ");
INSERT INTO rai_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Baa Iesu i waan paat irong Kaapernaaum, raa mukmuga anu ra kum tena wineium taangirong Rom i waan karomi ma i aaringi baa in waraauti. ");
INSERT INTO rai_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I piri naa, “Tadaaru, raa ko ra nung kum tultul kurong ut naruma i inep, a panina raap i maat, ma i kariaana a dekdek na ngunungut aakit.” ");
INSERT INTO rai_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu i piri taana naa, “Ang waan ma ang walaangalaanga paai.” ");
INSERT INTO rai_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A mukmuga maa i baalui naa, “Tadaaru, pa iaau takado kupi un ruk u ra nung ruma. Un pir ku ta pirpir, ma anung tultul in laangalaanga. ");
INSERT INTO rai_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maa iaau a muaana baa iaau tartaraam u ra naagagon anundiat baa diat ngaala taang, ma di taar taa a naagagon kaai taang kup a taara na wineium. Baa iaau piri taan te naa, ‘Un waan,’ in waan ku. Ma karom te kaai lenbi, ‘Un waan urin,’ in waan ku urin. Ma karom anung tultul naa, ‘Un paam a utnaa bari ia,’ in paami ku.” ");
INSERT INTO rai_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Baa Iesu i walangoro taa anuna pirpir, i kakaian aakit uni, ma i piri karom a taara baa diat murmuri naa, “Iaau pir a lingtatuna taa muaat, pa iaau babo taa ta te Israael baa anuna nurnur i ngaala welaar ma ra muaana mi. ");
INSERT INTO rai_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iaau piri taa muaat naa baa kuraa mun mongoro na taara diat a waan taanga u ra mataana taubaar ma ra mataana labur, ma diat a ki ungaai ma Aabaraam, Aaisaak ma Iaakob u ra lukaara u ra mataanitu inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iaku, a taara Israael baa namuga God i pilak pa diat kupi diat a ki u ra nuna mataanitu, in lu pari wa mongoro kon diat kup a baboto. Diat a taangtaangi ma diat a karkaraat lakondiat iaai.” ");
INSERT INTO rai_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma Iesu i piri taa ra mukmuga anu ra kum tena wineium naa, “Un waan ku. Din paam a utnaa baa u nurnur kupi.” U ra pakaana bung ut maa anuna tultul i laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Baa Iesu i ruk u ra ruma anun Petero, i babo paa a tabuan, a nimun Petero, i malaapaang ma i inep ma ra ina wuwan. ");
INSERT INTO rai_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu i paam paa a limaana, ma ina wuwan i raap maut koni. Ma a tabuan maa i tur, ma namur i tabaara Iesu ma ra utnaa na winangaan. ");
INSERT INTO rai_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Baa ia maluraap, di ben paa mongoro na taara karom Iesu, baa a kum tabaraan diat ruk taau un diat. Ma i lu irok wa a kum tabaraan ma ra pirpir ku, ma i walaangalaanga pa diat raap baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A utnaa mi i waan paat kupi din paam ot paa a kum pirpir baa a propet Aaisaia ia pirpir taau uni naa, “Ia ut i lo paa anundaat kum malaapaang, ma i rakaan wa anundaat kum ngunungut.” Aais 53:4 ");
INSERT INTO rai_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Baa Iesu i babo a kor na taara diat tur lili paai, i piri taa ra nuna kum naat na wawer naa diat a waan urong un raa papaara taai kikil. ");
INSERT INTO rai_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma raa tena wawer u ra kum Naagagon i waan karomi, ma i piri taana naa, “Tena Wawer, ang murmur ui u ra kum taamtaamaan raap baa un waan iaai.” ");
INSERT INTO rai_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Iesu i piri taana naa, “A kum kuaabaar na paap anundiat kum tung ut, ma ra kum pika kaai anundiat kum pio ut, iaku Natu ra Muaana pa nuna ta ruma kupi in inep uni.” ");
INSERT INTO rai_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma raa muaana kaai, raa ko ra nuna taara na wawer i piri taana naa, “Tadaaru, un mulaaot wa iaau kumun baa ang waan, kupi ang punang wa tamaang.” ");
INSERT INTO rai_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iesu i piri taana, “Un murmur iaau, ma un maadek wa a kum minaat diat a punang andiat kum minaat.” ");
INSERT INTO rai_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Baa Iesu i kaa u ra mon, anuna kum naat na wawer diat kaa murmuri. ");
INSERT INTO rai_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma a dekdek na dadaip i waan paat kakaian ma i tapalaa taau un diat u ra taai kikil. A mon i wawangaan, ma i pot na murung. Iesu i inep duman, ");
INSERT INTO rai_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ma diat waan karomi, diat waanguni, ma diat piri naa, “Tadaaru, un walaaun daat. Daat wirua ma.” ");
INSERT INTO rai_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma i piri taan diat naa, “Anumuaat nurnur i kinalik aakit. Aawa kabina maa muaat burut?” Io, i kaamtur ma i turbaat a dadaip ma ra top, ma i malila maut. ");
INSERT INTO rai_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma a kum naat na wawer diat kakaian uni, ma diat piri naa, “Woi na mangaana muaana ma mi, baa a dadaip ma ra pakaana taai diaar taraam karomi?” ");
INSERT INTO rai_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Baa Iesu i pukaai un raa papaara taai, u ra papaar anu ra taara Gaadaraa, raa ru muaana baa a kum tabaraan diat ruk taau un diaar, diaar waan baraatai. Diaar waan ko ra kum babaang na minaat. Diaar karangaap aakit, ma pa te i laana waan aakit matira u ra aakapi maa. ");
INSERT INTO rai_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Diaar kulkulaai lenbi, “Natun God, aawa maa un paami un mir? Lelawaai, u waan urin kupi un wakadik miaat? Pa i ot utbaai a bung na naagagon.” ");
INSERT INTO rai_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A ngaala na liur na boro diat wangwangaan marawaai matira. ");
INSERT INTO rai_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma ra kum tabaraan diat aaring Iesu naa, “Baa un lu irok wa miaat, un tula ruk ta miaat u ra kum boro.” ");
INSERT INTO rai_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu i piri taan diat naa, “Muaat a waan!” Io, a kum tabaraan diat pari ko ra ru muaana maa ma diat ruk taau u ra kum boro, ma a kum boro diat welulu pari u ra papaara taangaai kup a taai kikil, ma diat kongo raap. ");
INSERT INTO rai_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma diat baa diat baboura a kum boro, diat welulu talili ma diat waan paat u ra nundiat taamaan, ma diat wewapua u ra kum utnaa raap baa i waan paat, ma un diaar kaai baa a kum tabaraan diat ruk taau un diaar. ");
INSERT INTO rai_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A taara raap taanga u ra taamaan maa diat waan kupi diat a babo Iesu. Ma baa diat babo paai, diat aaringi kupi in waan ingen ko ra nundiat papaar. ");
INSERT INTO rai_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu i kaa u ra mon, ma i waan bolo un raa papaara taai kikil kup anuna taamaan. ");
INSERT INTO rai_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma raa kum muaana diat lo taa raa muaana karomi, baa a panpanina i maat ma i inep ut u ra nuna baat. Baa Iesu i babo anundiat nurnur, i piri taa ra muaana baa a panpanina i maat naa, “Natunglik, koku burut, di aa una wa anum kum aakaina mangamangaan.” ");
INSERT INTO rai_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma raa kum tena wawer u ra kum Naagagon diat pirpir karom diat ut naa, “A muaana bi i pir aakaka God baa i welaara ia mai.” ");
INSERT INTO rai_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Iesu i nunura a nuknukindiat, ma i tiri diat naa, “Aawa kabina maa muaat nuknuk aakaka? ");
INSERT INTO rai_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma woi na mangaana pirpir ang piri kupi ang waiaa a dekdeking mai karom muaat? Ang piri naa, ‘Di aa una wa anum kum aakaina mangamangaan,’ baa, ‘Un tur, ma un waan’? ");
INSERT INTO rai_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ang piri lenbi kupi muaat a nunurai naa Natu ra Muaana i paam akoto a naagagon kupi in una wa a kum aakaina mangamangaan min napia.” Io, i piri karom a muaana baa a panpanina i maat, “Un tur, un lo paa anum baat, ma un waan kup anum ruma.” ");
INSERT INTO rai_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma i tur maut, ma i waan kup anuna ruma. ");
INSERT INTO rai_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma baa a kor na taara diat baboi, diat kakaian, ma diat pir walaawa paa God, baa i taar a dekdek lenmi karom a taara. ");
INSERT INTO rai_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Baa Iesu i waan taanga matira, i babo paa raa muaana, a iaana Maataio, baa i ki u ra ruma na tatakom, ma Iesu i piri taana naa, “Un murmur iaau.” Io, i tur ma i murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Namur baa Iesu i ki u ra winangaan u ra ruma anun Maataio, mongoro na tena lolo tatakom ma ra kum tena aakaina diat waan karomi, ma diat wangaan ungaai ma Iesu ma ra nuna kum naat na wawer. ");
INSERT INTO rai_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Baa a kum Parisaaio diat baboi, diat tiri anuna kum naat na wawer naa, “Aawa kabina baa anumuaat tena wawer i wangaan ungaai ma ra kum tena lolo tatakom ma ra kum tena aakaina?” ");
INSERT INTO rai_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Baa Iesu i walangoroi i piri naa, “A doktaa pa i waan paat kup diat baa diat lalaaun wakaak. Pate! I waan paat kup diat ku baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Muaat a waan, ma muaat a wawer u ra kukuraai ra pirpir mi ko ra Buk Taabu, ‘Iaau nem ku a maarmaari, ma wakir a wetabaar baa di laana tuni.’ Os 6:6 Maa pa iaau waan paat kup a kum tena takado. Pate! Iaau waan paat kupi ang wataa paa a kum tena aakaina.” ");
INSERT INTO rai_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A kum naat na wawer anun Ioaanes diat waan karom Iesu, ma diat tiri naa, “Aawa kabina baa miaat ma ra kum Parisaaio miaat wawel, ma anum kum naat na wawer pate?” ");
INSERT INTO rai_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Iesu i baalu diat naa, “A kum teptepaa ra matakina tinaulaa diat a tapunuk ma diat a taangi lelawaai baa a matakina tinaulaa i ki ungaai utbaai ma diat? Ta bung in waan paat, baa din ben ingen wa a matakina tinaulaa kon diat, io, diat a wawel maraagaam. ");
INSERT INTO rai_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Pa te in ingit ungaai taa ta pakaana matakina maalu ma ra pakaana turaaina, kaduk a matakina baa din ingit banot a tarabaat mai, in pet rabaana wa balet a turaaina maalu, ma in ngaala ma a tarabaat uni. ");
INSERT INTO rai_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma pa te in labo taa a matakina waain u ra in turaaina palaa na waain baa di paami ko ra pani ra wewagua, kaduk in palaa maa in tarabaat ma in aaka, ma a waain in talabo. Din labo ut a matakina waain u ra in matakina palaa na waain, kupi diaar raap diaar a taana wakaak.” ");
INSERT INTO rai_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Baa Iesu i pirpir utbaai karom diat, raa mukmuga i waan karomi ma i ki but keke namuga taana, ma i piri naa, “Natunglik a tabuan, mi ut ku i maat. Aiaap, daar a waan ma un ung a limaam nate uni ma in lalaaun.” ");
INSERT INTO rai_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Io, Iesu i tur ma diaar waan, diat ungaai ma ra nuna kum naat na wawer. ");
INSERT INTO rai_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ma raa tabuan baa i malaapaang 12 kilaala ma ra malaapaang na gaap, i nuki naa, “Baa ang paam taa ku anuna ina maalu, ang laangalaanga balet.” Io, i waan namur taan Iesu, ma i paam taa a titi ra nuna ina maalu. ");
INSERT INTO rai_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu i tur tapuku ma i babo a tabuan maa, ma i piri taana naa, “Natunglik, koku burut, anum nurnur ia walaangalaanga pa ui.” Ma u ra pakaana bung ut maa a tabuan maa i laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesu i waan paat u ra ruma anu ra mukmuga ma i babo a taara baa diat waiaa anundiat tapunuk u ra minaat. Diat ip a kum tulaal, ma mongoro na taara kaai diat luan. ");
INSERT INTO rai_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I piri taan diat naa, “Muaat a pari aarai. A naat na tabuan mi wakir i maat, i inep duman ku.” Ma diat nangonoi ku. ");
INSERT INTO rai_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Baa Iesu ia tula pari wa a kum taara, i ruk ma i paam paa a limaa ra naat na tabuan, ma i tur maut. ");
INSERT INTO rai_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A wewapua u ra utnaa mi i waan werweraan u ra papaar raap maa. ");
INSERT INTO rai_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Baa Iesu i waan taanga matira, raa ru muaana, a ru pula, diaar murmuri, ma diaar wewataai dekdek lenbi, “Natun Dewid, un maari mir.” ");
INSERT INTO rai_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma baa i ruk u ra ruma, a ru pula diaar waan karomi, ma i tiri diaar naa, “Lelawaai, mur nurnur ut un iaau baa ang paam laar paa a utnaa mi?” Diaar baalui naa, “Maia, Tadaaru.” ");
INSERT INTO rai_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma i paam a mataandiaar ma i piri naa, “Din paami karom mur welaar ma mur nurnur kupi.” ");
INSERT INTO rai_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Io, diaar babo maut. Ma Iesu i turbaat dekdek ta diaar naa, “Koku mur wapua taa te uni.” ");
INSERT INTO rai_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iaku, diaar waan ma diaar wewapua waanwaan uni u ra papaar raap maa. ");
INSERT INTO rai_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Baa a ru pula diaar waan paa kon Iesu, di ben taa bulung raa muaana karomi, a munga, ma a tabaraan i ruk taau uni. ");
INSERT INTO rai_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma baa Iesu i lu irok wa a tabaraan koni, a muaana maa i pirpir maraagaam. Ma a kor na taara diat kakaian, ma diat piri naa, “Talek mi di babo a utnaa lenmi main Israael.” ");
INSERT INTO rai_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iaku a kum Parisaaio diat piri naa, “I lu irok wa a kum tabaraan ma ra dekdek i ra tadaaru anu ra kum tabaraan.” ");
INSERT INTO rai_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma Iesu i waan taltalili u ra kum ngaala ma ra kum kinkinalik na taamaan raap. I wer a taara u ra nundiat kum ruma na lotu, ma i warawaai ma ra Koina Wewapua u ra mataanitu anun God, ma i walaangalaanga paa a taara ko ra aalawur mangaana malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma baa i babo a kor na taara, i maari aakit diat, maa i talaara a nuknukindiat ma diat pot na maarmaari, welaar maku ma ra kum sip baa pa nundiat ta tena baboura. ");
INSERT INTO rai_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma i piri taa ra nuna kum naat na wawer naa, “A pinapaam ia mugaan, ma ia ngaala aakit, iaku pa i mongoro a kum tena tinangaa. ");
INSERT INTO rai_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Muaat a aaring a Tadaaru maa ia a tamaa ra pinapaam, kupi in tula wa a kum tena tinangaa kup ana pinapaam.” ");
INSERT INTO rai_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu i wataa paa anuna 12 naat na wawer ma i taar taa a naagagon taan diat kupi diat a lu irok wa a kum tabaraan, ma kupi diat a walaangalaanga paa a taara ko ra aalawur mangaana malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bari ia a iaandiat a 12 aapostolo: A mugaana, Simon raa iaana kaai baa Petero, dina ma Aanderiaas, Iaakobo ma Ioaanes dina, a ru natun Sebedaaio, ");
INSERT INTO rai_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo, Baatolomaaio, Tomaas, Maataio a tena lolo tatakom, Iaakobo a natun Aalipaaio, ma Tadaaio, ");
INSERT INTO rai_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma Simon raa ko ra kikil Silot, ma Iudaas Iskaariot, ia baa i wagu taa Iesu. ");
INSERT INTO rai_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu i tula wa a 12 naat na wawer, ma i piri taan diat naa, “Koku muaat waan karom a taara baa wakir a taara Israael, ma koku muaat waan u ra kum taamtaamaan anu ra kum te Samaaria. ");
INSERT INTO rai_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Muaat a waan ku karom a taara Israael, baa diat raara welaar ma ra kum sip. ");
INSERT INTO rai_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma baa muaat waan, muaat a warawaai waanwaan lenbi, ‘A mataanitu taanginaanga u ra maawa ia marawaai.’ ");
INSERT INTO rai_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muaat a walaangalaanga paa a kum malaapaang, ma muaat a walaaun paa a kum minaat, muaat a walaangalaanga paa a kum wukawuka, ma muaat a lu irok wa a kum tabaraan. Di tabaara biaa muaat ku, lenmaa muaat kaai muaat a wetabaar biaa ku. ");
INSERT INTO rai_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Koku muaat lo ta maani u ra numuaat maalu na winiwi. ");
INSERT INTO rai_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Koku muaat lo ta bek u ra numuaat winawaan, koku ta maalu na wekiaa, koku ta su, ma koku tina buka. Maa i takado baa din tabaara a tena pinapaam ma ra ana utnaa. ");
INSERT INTO rai_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Baa muaat a waan u ra kum ngaalangaala na taamaan ma ra kum kinkinalik na taamaan, muaat a baat kup te baa i koina, ma muaat a ki naana tuk u ra bung baa muaat a waan koni. ");
INSERT INTO rai_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Baa muaat ruk un ta ruma, muaat a pirpir na wagaaia karom diat. ");
INSERT INTO rai_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Baa a taara ko ra ruma maa diat a gaaia pa muaat, muaat a ruk ma muaat a piri naa, ‘A maalmaal karom muaat.’ Iaku baa pa diat a gaaia pa muaat, anumuaat maalmaal in waan talili balet karom muaat. ");
INSERT INTO rai_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Baa te pa i gaaia pa muaat, ma pa i walangoro anumuaat pirpir, baa muaat waan ko ra nuna ruma, baa a taamaan maa, muaat a tataanga wa a kabu ko ra kakimuaat. ");
INSERT INTO rai_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iaau pir a lingtatuna taa muaat, u ra bung na naagagon, a naagagon karom Sodom ma Gomoraa in dekdek, iaku karom a taamaan maa in aaka aakit. ");
INSERT INTO rai_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Baboi, mi iaau tula wa muaat welaar ma ra kum sip naliwan naa ra kum karangaap na paap. Io, muaat a manaana wakaak welaar ma ra kum wui kupi koku te i ben araara muaat, ma muaat a gomgom welaar ma ra kum buna. ");
INSERT INTO rai_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muaat a baboura muaat, maa a taara diat a aal pa muaat karom a kum tena naagagon, ma diat a raapu muaat u ra nundiat kum ruma na lotu. ");
INSERT INTO rai_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ma din aal muaat kup a naagagon namuga naa ra kum ngaala na mukmuga ma ra kum king, kabina un iaau. Io, muaat a wewapua kaapa un iaau karom diat ma karom a kum taara baa wakir a taara Iudaia. ");
INSERT INTO rai_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Baa di aal pa muaat, koku muaat ngaraa baa aawa muaat a piri, ma muaat a pirpir lelawaai, maa u ra pakaana bung ut maa God in wanuk ta muaat u ra pirpir baa muaat a piri. ");
INSERT INTO rai_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wakir muaat maa muaat a pirpir, a Nion Tamaamuaat ut in wanuk muaat u ra aawa baa muaat a piri. ");
INSERT INTO rai_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Te in mulaaot wa ta tenalik kupi din aak dokoi, ma ta muaana in mulaaot wa ta natunalik kupi din aak dokoi, ma a kum naat diat a tur na dekdek karom tamaandiat ma naandiat ma diat a mulaaot wa tamaandiat ma naandiat kupi din aak doko diaar. ");
INSERT INTO rai_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ma a taara raap diat a milikuaana muaat kabina u ra iaang, iaku te baa i tur dekdek tuk u ra tintinipina, God in walaaun paai. ");
INSERT INTO rai_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Baa diat a pet na bilbil un muaat un ta taamaan, io, muaat a kalaa kup ta taamaan ingen. Maa iaau pir a lingtatuna taa muaat, baa pa muaat a waan raap utbaai u ra kum taamtaamaan min Israael, Natu ra Muaana in waan paat. ");
INSERT INTO rai_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A naat na wawer pa i ngaala taa ra nuna tena wawer, ma a tultul kaai pa i ngaala taa ra nuna tadaaru. ");
INSERT INTO rai_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I topaai baa a naat na wawer in welaar ku ma ra nuna tena wawer ma ra tultul in welaar ma ra nuna tadaaru. Baa di aa waatung iaau ma Belsebul, din waatung muaat kaai baa muaat ki ungaai ma iaau ma ra kum aakaina iang. ");
INSERT INTO rai_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Koku muaat burut kup a taara. A utnaa raap baa di burung baat taai, namur in taana baarabaara, ma ra utnaa raap baa i taana ino, namur in waan paat kaapakaapa. ");
INSERT INTO rai_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A utnaa baa iaau wapua muaat uni u ra baboto, muaat a wewapua uni u ra kaapa, ma ra utnaa baa di wewaik ku mai karom muaat, muaat a tur nate u ra ruma, ma muaat a wapuaanai karom a taara. ");
INSERT INTO rai_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Koku muaat burut kup diat baa diat aak doko ku a panimuaat, iaku pain diat a aak doko laar paa a niomuaat. Muaat a burut kup ia baa in pet laar paai kupi in baanaakaka a panindi ma ra niondi kaai u ra ngaala na nguan. ");
INSERT INTO rai_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Di laana kul ruina pika liklik ma kabaana toiaa ku, naka? Iaku pa tin lik kon diat in puka pari napia, baa wakir a Tamaamuaat i mulaaot uni. ");
INSERT INTO rai_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I lingtatuna aakit God i nunura raap a kum weu na lorimuaat. ");
INSERT INTO rai_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Io, koku muaat burut, maa muaat ngaatngaat aakit namataan God taa ra mongoro na pika. ");
INSERT INTO rai_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Baa te in pir apuaana iaau namataa ra taara, iaau kaai ang pir apuaanai namataan Tamaang baa i ki inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Baa te in weoro kon iaau namataa ra taara, iaau kaai ang weoro koni namataan Tamaang baa i ki inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Koku muaat nuki naa iaau waan paat kupi ang taar taa a maalmaal u ra rakrakaan buaal. Pate, pa iaau waan paat kupi ang taar taa a maalmaal, iaau waan paat kupi a taara diat a ki na purpuruan. ");
INSERT INTO rai_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iaau waan paat kupi ang waki weraana wa ‘a naat muaana kon tamaana, ma ra naat na tabuan kon naana, ma ra tinaulaa na tabuan kon tabuna. ");
INSERT INTO rai_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Diat baa diat ki u ra ruma anun raa muaana, diat ut maa anuna kum ebaar.’ Mika 7:6 ");
INSERT INTO rai_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Baa te i maari aakit tamaana ma naana, iaku anuna maarmaari karom iaau pa i ngaala, pa i topaai kupi ia anung naat na wawer. In koina baa anuna maarmaari karom iaau in ngaala taa ra nuna maarmaari karom tamaana ma naana. Ma baa te i maari aakit natunalik, a naat muaana baa a tabuan, iaku anuna maarmaari karom iaau pa i ngaala, pa i topaai kupi ia anung naat na wawer. In koina baa anuna maarmaari karom iaau in ngaala taa ra nuna maarmaari karom natunalik. ");
INSERT INTO rai_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Baa te kaai pa i puak paa anuna bolo kupi in murmur iaau, pa i topaai kupi ia anung naat na wawer. ");
INSERT INTO rai_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Baa te i maari baat paa ku anuna lalaaun in wirua, ma ia baa pa i maari baat anuna lalaaun kup iaau, in lalaaun. ");
INSERT INTO rai_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Baa te i gaaia pa muaat, i gaaia pa iaau ut, ma te baa i gaaia pa iaau, i gaaia paa ia utkaai baa i tula wa iaau urin. ");
INSERT INTO rai_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Baa te i gaaia paa a propet maa kabina i nunurai naa ia a propet, in lo utkaai a mangaana wedok welaar ma ra propet in loi. Ma baa te kaai i gaaia paa a tena takado, maa i nunurai naa ia a tena takado, in lo utkaai a mangaana wedok welaar ma ra tena takado in loi. ");
INSERT INTO rai_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Baa te i tabaara taa anung ta naat na wawer baa i kinalik namataa ra taara ma ta kaap na madiring na palaa, kabina i nunurai naa ia anung naat na wawer, iaau pir a lingtatuna taa muaat, ia kaai in lo ut anuna wedok.” ");
INSERT INTO rai_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Baa Iesu ia pirpir raap taau karom anuna 12 naat na wawer, i waan taanga matira kupi in wer a taara ma in warawaai u ra kum taamtaamaan irong u ra papaar Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baa Ioaanes i ki u ra ruma na karabus ma i walangoro a kum pinapaam anun Kaarisito, i tula wa anuna kum naat na wawer kupi diat a tiri naa, ");
INSERT INTO rai_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ui ma maa di pirpir muga un ui naa un waan paat, baa miaat a ki walaang utbaai kup te?” ");
INSERT INTO rai_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma Iesu i baalu diat naa, “Muaat a waan talili, ma muaat a wapua Ioaanes u ra kum utnaa mi muaat walangoroi ma muaat baboi: ");
INSERT INTO rai_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","A kum pula diat aa babo, diat baa a kakindiat i maat diat aa waan kado, a kum wukawuka diat aa laangalaanga, a kum lengbaa diat aa walangor, a kum minaat diat aa lalaaun, ma di warawaai u ra Koina Wewapua karom a kum iba na taara. ");
INSERT INTO rai_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Baa te i babo a kum utnaa mi iaau paami ma anuna nurnur pa i puka, ia daan.” ");
INSERT INTO rai_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Baa a kum naat na wawer anun Ioaanes diat aa waan, Iesu i piri karom a kor na taara un Ioaanes naa, “U raa bung baa muaat waan u ra bil na wanua karom Ioaanes, aawa maa muaat babo kupi? Ina kura duk baa i taltalaaur u ra dadaip? Pate. ");
INSERT INTO rai_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aawa maa muaat waan kupi muaat a baboi? A muaana baa i mong ma ra in koina maalu? Pate. Baboi, diat baa diat mong ma ra kum kokoina maalu diat ki u ra kum ruma na king. ");
INSERT INTO rai_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aawa maa muaat waan kupi muaat a baboi? A propet? Maia, iaau piri taa muaat, Ioaanes i ngaala aakit ut taa ra kum propet. ");
INSERT INTO rai_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Di aa timtimu taau uni u ra Buk Taabu lenbi, ‘Baboi, ang tula wa anung tena lo pirpir kupi in muga taam. In muga taam ma in paam aara anum aakapi.’ Maal 3:1 ");
INSERT INTO rai_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iaau pir a lingtatuna taa muaat, Ioaanes a Tena Baapitaaiso i ngaala aakit taan diat raap baa di buta diat, iaku ia baa i kinalik aakit u ra mataanitu taanginaanga u ra maawa, i ngaala taana. ");
INSERT INTO rai_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“U ra kilaala baa Ioaanes a Tena Baapitaaiso i turpaa warawaai uni ma tuk mi a dekdek na taara diat weium dekdek ma ra mataanitu taanginaanga u ra maawa, ma diat ongor aakit ma ra wineium kupi diat a turbaati. ");
INSERT INTO rai_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A kum propet ma ra kum Naagagon anun Moses diat wapuaana a pirpir anun God tuk u ra kilaala baa Ioaanes i turpaa anuna pinapaam uni. ");
INSERT INTO rai_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma baa muaat nem na walangoroi, muaat a walangoroi. A Buk Taabu i pirpir u ra propet Eliaas baa in waan paat, ma mi a winawaan paat anun Ioaanes ia paam ot paa a pirpir mi. ");
INSERT INTO rai_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ia baa in talingaana, i koina baa in walangor mai. ");
INSERT INTO rai_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Aawa duk maa ang welaara a taaun taara mai mi? Diat welaar ma ra kum naat liklik baa diat ki u ra balaa ra taamaan ma diat wewataai karom a kum teptepaandiat lenbi, ");
INSERT INTO rai_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Baa miaat paar kudu, pa muaat laagaar uni, ma baa miaat kele a kelekele na tapunuk, pa muaat taangi uni.’ ");
INSERT INTO rai_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioaanes i waan paat, pa i aan ta koina utnaa ma pa i inim a waain, ma diat piri uni naa, ‘A tabaraan i ruk taau uni.’ ");
INSERT INTO rai_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Natu ra Muaana i waan paat, i wangaan ma i inim, ma diat piri uni naa, ‘Baboi, a muaana mi a tena winangaan ma ra tena ininim, a tepaa ra kum tena lolo tatakom ma ra kum tena aakaina.’ Iaku a kum pinapaam anun God i wapuaanai naa anuna manaana ia a manaana lingtatuna.” ");
INSERT INTO rai_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma Iesu i pirpir na kaankaan karom a taara u ra kum taamaan baa ia paam taa anuna mongoro na utnaa na kakaian aakit iaai, kabina maa pa diat nukpuku. ");
INSERT INTO rai_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I piri naa, “In aaka karom muaat a taara Koraasin, in aaka kaai karom muaat a taara Betsaaida. Baa gun di aa paam taa a kum utnaa na kakaian bi karom a taara Tiro ma Sidon, welaar ma di aa paam taai karom muaat, kaduk a taara Tiro ma Sidon diat a nukpuku gagaa ma diat a tobo, diat a mong ma ra maalu na tapunuk ma diat a aalu a panpanindiat ma ra kabu na nguan. Iaku muaat, pa muaat nukpuku. ");
INSERT INTO rai_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iaau piri taa muaat naa, u ra bung na naagagon, a naagagon karom muaat a taara Koraasin ma Betsaaida in aaka aakit ko ra naagagon karom diat a taara Tiro ma Sidon. ");
INSERT INTO rai_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma muaat kaai a taara Kaapernaaum, lelawaai, muaat nuki naa din wangaala pa muaat unaanga nate? Pate, din ong apari wa muaat ku u ra ngaala na nguan. Baa gun di aa paam taa a kum utnaa na kakaian karom a taara Sodom, welaar ma di aa paam taai karom muaat, kaduk Sodom kuri utbaai in tur. ");
INSERT INTO rai_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iaau piri taa muaat naa, u ra bung na naagagon, a naagagon karom muaat a taara Kaapernaaum in aaka aakit ko ra naagagon karom a taara Sodom.” ");
INSERT INTO rai_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","U ra pakaana bung maa, Iesu i piri naa, “Tamaang, ui a Tadaaru i ra maawa ma ra rakrakaan buaal raap, iaau pir walaawa pa ui, maa u walipa a kum utnaa mi ko ra kum tena manaana ma kon diat baa diat malem, ma u pir waiaai ku karom diat baa diat welaar ma ra kum naat liklik. ");
INSERT INTO rai_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Maia, Tamaang, maa u nemi ut lenmaa. ");
INSERT INTO rai_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tamaang ia taar taa a kum utnaa raap taang. Pa te i nunura Natuna, Tamaana ku, ma pa te kaai i nunura Tamaana, Natuna ku, ma diat kaai baa Natuna i nemi naa in pir waiaa Tamaana karom diat. ");
INSERT INTO rai_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Muaat raap baa muaat bilua taa ra dekdek na pinapaam ma a kum mawaat i manong muaat, muaat a waan karom iaau, ma ang wango muaat. ");
INSERT INTO rai_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Muaat a lo anung ina kip, ma muaat a wawer kon iaau, maa anung mangamangaan i wowowon ma iaau laana wakinalik pa iaau. Muaat a lo ina kip bi kupi a niomuaat in ngo. ");
INSERT INTO rai_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maa ina kip baa iaau taari taa muaat i malut, ma a nilalo uni i baanabaana ku.” ");
INSERT INTO rai_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Namur, un raa Bung Saabaat, Iesu i waan bolo u ra kum wanua na wit. Ma nuna kum naat na wawer diat molo, ma diat gamut kutu paa a kum wit ma diat aani. ");
INSERT INTO rai_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Baa a kum Parisaaio diat baboi, diat piri taana naa, “Baboi, baa anum kum naat na wawer diat paam a utnaa mi, pa diat murmur a Naagagon ko ra Bung Saabaat.” ");
INSERT INTO rai_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu i piri taan diat naa, “Lelawaai, pa muaat luk utbaai a utnaa baa Dewid i paami baa diat ma ra taara baa diat weur mai diat molo? ");
INSERT INTO rai_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I ruk u ra ruma anun God, ma i aan a bred baa di aa tabaara taa God mai. Ma diat kaai baa diat weur mai diat wangaan koni. A bred maa di wataabui ko ra taara biaa ku. A kum tena wetabaar ku karom God i tale diat a wangaan koni. ");
INSERT INTO rai_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lelawaai, pa muaat luki kaai u ra Buk na Naagagon naa, a kum tena wetabaar karom God diat papaam u ra ruma na wetabaar u ra Bung Saabaat? Iaku maa pa diat raara uni. ");
INSERT INTO rai_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iaau piri taa muaat naa, raa kuri min i ngaala aakit taa ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Baa muaat aa nunura a kukuraai ra pirpir mi, ‘Iaau nem ku a maarmaari ma wakir a wetabaar baa di laana tuni,’ Os 6:6 io, pa muaat a takuna diat baa pa diat raara. ");
INSERT INTO rai_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maa Natu ra Muaana ia a Tadaaru i ra Bung Saabaat.” ");
INSERT INTO rai_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma Iesu i waan taanga matira ma i ruk u ra nundiat ruma na lotu. ");
INSERT INTO rai_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Raa muaana kuraa matira, a limaana i baau. Ma diat nem na takuna Iesu ma diat tiri naa, “Lelawaai, i takado ut welaar ma ra nundaat kum Naagagon kupi din walaangalaanga paa te u ra Bung Saabaat baa pate?” ");
INSERT INTO rai_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma i piri taan diat naa, “Woi kon muaat baa anuna ta sip in puka taau un ta tung u ra Bung Saabaat, pa in paam kotoi kupi in aal tato paai balet? ");
INSERT INTO rai_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A muaana i ngaatngaat taa ra sip. Lenmaa i takado kupi din paam a koina u ra Bung Saabaat.” ");
INSERT INTO rai_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma i piri taa ra muaana naa, “Un kado a limaam.” Ma i kadoi, ma a limaana i tubu, welaar ma ra limaana baa i koina. ");
INSERT INTO rai_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A kum Parisaaio diat pari, ma diat wepaak un Iesu, baa diat a aak dokoi lelawaai. ");
INSERT INTO rai_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Baa Iesu ia nunurai naa diat wepaak kupi diat a aak dokoi, i waan ingen taanga matira. Ma mongoro na taara diat murmuri, ma i walaangalaanga pa diat raap baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma i turbaat diat kupi koku diat pir waiaai naa ia woi. ");
INSERT INTO rai_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I piri lenmaa kupi in paam ot paa a pirpir anun God baa Aaisaia a propet ia pirpir muga taau uni lenbi, ");
INSERT INTO rai_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bari ia anung tultul baa iaau aa pilak paai, ia anung naat na wakwakaak, iaau gaaia aakit uni. Ang waruk taa a Niong uni, ma in wapuaana a naagagon baa i takado karom a kum taara baa wakir a taara Iudaia. ");
INSERT INTO rai_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pa in wengangaar, ma pa in gege, ma pain te in walangoro in ingaana u ra kum aakapi. ");
INSERT INTO rai_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pa in bor a kura baa i talukun, ma pa in ip doko a paaupaau na laam baa pa i kup wakaak. In paami lenmaa tuk baa in pet taa a takado na naagagon kupi in uwia. ");
INSERT INTO rai_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A taara baa wakir a taara Iudaia diat a nurnur u ra iaana ma diat a ki walaang kup a warwalaaun.” Aais 42:1-4 ");
INSERT INTO rai_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ma di ben paa raa muaana karom Iesu, i munga ma i pula, ma a tabaraan i ruk taau uni. Iesu i walaangalaanga paai, io, a muaana maa i pirpir ma i babo kaai. ");
INSERT INTO rai_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ma a taara raap diat kakaian, ma diat wetiri naa, “Kanaapi a Natun Dewid duk mi?” ");
INSERT INTO rai_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Iaku baa a kum Parisaaio diat walangoroi diat piri naa, “A muaana mi i lu irok wa a kum tabaraan ma ra dekdekin Belsebul, a tadaaru anu ra kum tabaraan.” ");
INSERT INTO rai_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu ia nunura a nuknukindiat, ma i piri taan diat naa, “Baa ta mataanitu diat balet ut diat a weium wetwetalaai, a mataanitu maa in raap ku. Baa ta taamaan baa ta naadiwaatamaana diat a weium wetwetalaai balet ku ma diat, pain diat a ki ungaai ma. ");
INSERT INTO rai_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Baa Saataan i lu irok wa anuna kum tultul, i weium balet ku ma diat. Baa lenmaa, anuna mataanitu in tur dekdek lelawaai? ");
INSERT INTO rai_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Baa iaau lu irok wa a kum tabaraan ma ra dekdekin Belsebul, anumuaat taara diat lu irok wa diat ma ra dekdekin woi? Io, anundiat pinapaam ut in wapuaanai naa anumuaat wetakun i raara. ");
INSERT INTO rai_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Iaku, baa iaau lu irok wa a kum tabaraan ma ra dekdek i ra Nion God, muaat a nunurai naa a mataanitu anun God ia waan paat karom muaat. ");
INSERT INTO rai_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Te in ruk lelawaai u ra ruma anu ra dekdek na muaana ma in lo a kum utnaa taanga naruma, baa pa i wi amuga taa a dekdek na muaana maa? Baa ut in wi akoto muga taai, namur in lo paa maraagaam a kum utnaa anu ra muaana maa. ");
INSERT INTO rai_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ia baa pa i waraaut iaau, i turbaat iaau ku. Ma ia baa pa i waraaut iaau u ra weben, i lulu weraana wa diat ku. ");
INSERT INTO rai_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Io, iaau piri taa muaat naa, din una wa a kum aakaina mangamangaan raap anu ra taara ma ra nundiat kum aakaina pirpir kaai un God, iaku a pirpir aakaka u ra Takado na Nion pa din una laar paai. ");
INSERT INTO rai_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Baa te kaai in pir taa ta aakaina pirpir un Natu ra Muaana, din una wai ku, iaku baa te in pirpir aakaka u ra Takado na Nion, pain te in una laar paai, u ra lalaaun mi ma u ra lalaaun namur kaai. ");
INSERT INTO rai_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Baa en diwaai i koina, i wa a koina waina, ma baa en diwaai i aaka, pa in wa ta koina waina kaai, maa din nunura lele ku en diwaai ko ra waina. ");
INSERT INTO rai_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Muaat a kum natu ra kum wui! Muaat baa aakaina taara, muaat a pir lelawaai a koina pirpir? Maa a waa ra taara i pir apuaana a mangamangaan baa i teng u ra nundiat lalaaun. ");
INSERT INTO rai_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A koina muaana i waiaa anuna koina mangamangaan ko ra koina baa i ki u ra nuna lalaaun, ma ra aakaina muaana kaai, i waiaa anuna aakaina mangamangaan ko ra aakaina baa i ki u ra nuna lalaaun. ");
INSERT INTO rai_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iaau piri taa muaat naa, a kum pirpir aakaka raap baa a kum taara diat aa pir tataai, kuraa mun din tiri diat uni u ra bung na naagagon. ");
INSERT INTO rai_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Baa un tur u ra naagagon anum pirpir ut maa in walaangalaanga ui, baa in baanaakaka ui.” ");
INSERT INTO rai_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Namur raa taara ko ra kum tena wawer u ra kum Naagagon ma ra kum Parisaaio diat piri taana naa, “Tena Wawer, un paam ta utnaa na kakaian kupi miaat a baboi.” ");
INSERT INTO rai_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","I baalu diat naa, “A taaun taara mi, a aakaina taaun taara, a taaun taara baa anundiat lalaaun i welwelik kon God. Diat nem ta wakilang, iaku maa pa din paam te karom diat. Din paam ku a wakilang welaar ma Ionaa a propet. ");
INSERT INTO rai_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Welaar ma Ionaa i lalaaun tula bung u ra in balaa ra ina ngaala na ian, lenkaai maa Natu ra Muaana in inep paa tula bung nabalaa ra pia. ");
INSERT INTO rai_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","U ra bung na naagagon, a taara Niniwe diat a tur ma diat a takuna dekdek a taaun taara mi, kabina maa diat nukpuku u ra warawaai anun Ionaa, ma raa maa i ngaala taan Ionaa kuri ut min. ");
INSERT INTO rai_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","U ra bung na naagagon, a kwin taangirong u ra mataana taubaar in tur ma in takuna dekdek a taaun taara mi, kabina maa i waan ut taanga welwelik kupi in walangoro a manaana anun King Solomon, ma raa maa i ngaala taan Solomon kuri ut min. ");
INSERT INTO rai_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Baa a tabaraan i pari paa kon ta muaana, i waan u ra kum wanua baa pa ta palaa iaai, kupi in ngo, iaku pa i baat paa ta wanua baa in ngo iaai. ");
INSERT INTO rai_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Io, i piri naa, ‘Ang waan talili balet kup anung ruma, baa iaau pari paa koni.’ Ma baa i waan paat, i baboi baa i kapkapaana ku, di aa aarupa taai, ma di aa maar taai. ");
INSERT INTO rai_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Namur i waan ma i ben paa balet 7 na tabaraan, baa diat aaka aakit koni, ma diat ruk raap taau u ra ruma maa, ma diat ki uni. Io, a lalaaun anu ra muaana maa i aaka aakit ma ko ra lalaaun baa i watur akotoi namuga. In lenkaai maa karom a aakaina taaun taara mi.” ");
INSERT INTO rai_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Baa Iesu i pirpir utbaai karom a kor na taara, naana ma ra kum tatena liklik diat waan paat, ma diat tur nataamaan, maa diat nem na pirpir mai.  ");
INSERT INTO rai_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma raa muaana i wapua Iesu naa, “Naam ma ra kum tatem liklik bari diat nataamaan. Diat nem na pirpir ma ui.” ");
INSERT INTO rai_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma i baalui naa, “Woi maa naang, ma woi diat maa a kum tateng liklik?” ");
INSERT INTO rai_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ma i kado a limaana karom anuna taara na wawer ma i piri naa, “Baboi, diat baa naang ma ra kum tateng liklik, bari diat! ");
INSERT INTO rai_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maa ia baa i murmur a nemnem anun Tamaang baa i ki inaanga u ra maawa, ia ut maa tenglik a muaana, ma tenglik a tabuan, ma naang.” ");
INSERT INTO rai_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","U ra bung maa Iesu i pari ko ra ruma ma i waan ma i ki nakono naa ra taai kikil. ");
INSERT INTO rai_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma a ngaala na kor na taara diat waan paat karomi. Io, i kaa u ra mon ma i ki taau uni. Ma a kor na taara raap diat tur nakono. ");
INSERT INTO rai_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma i warawaai karom diat un ta mongoro na utnaa ma ra kum pirpir welwelaar. I piri lenbi, “Raa tena minamaarut i waan kupi in lamira a kum waina wit. ");
INSERT INTO rai_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Baa i lalamira waanwaan, raa kum waina diat puka taau u ra aakapi, ma ra kum pika diat rowo paat ma diat aan wa diat. ");
INSERT INTO rai_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Raa kum waina kaai diat puka taau u ra pia na waatwaat, baa a pia pa i ngaala, ma diat ilak paat gagaa, maa a pia pa i but. ");
INSERT INTO rai_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iaku baa a mage i waan paat diat malulur ma diat maraang raap, kabina maa pa ta aakaarindiat. ");
INSERT INTO rai_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Raa kum waina kaai diat puka taau naliwan u ra kum katkadaa, ma ra kum kadaa diat tawa ma diat tawa baat pa diat. ");
INSERT INTO rai_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma raa kum waina kaai diat puka taau u ra koina pia ma diat wa, raa mangaan 100 na waindiat, raa mangaan kaai 60, ma raa mangaan 30. ");
INSERT INTO rai_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ia baa in talingaana, i koina baa in walangor mai.” ");
INSERT INTO rai_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anuna kum naat na wawer diat waan karomi ma diat tiri naa, “Aawa kabina baa u wer a taara ma ra kum pirpir welwelaar?” ");
INSERT INTO rai_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma i baalu diat lenbi, “God ia taar taa a manaana taa muaat kupi muaat a nunura a kum utnaa na pidik u ra mataanitu taanginaanga u ra maawa. Iaku pa i taari karom a taara raap. ");
INSERT INTO rai_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maa te baa i paam akoto a manaana uni din tabaarai balet ma ra ngaala, ma in manaana aakit. Ma te baa pa i paam akoto ta manaana uni, din rakaan wa utkaai a kinalik na manaana baa i paam akotoi. ");
INSERT INTO rai_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iaau wer diat ma ra kum pirpir welwelaar, i kabina maa diat bababo ma pa diat babo lelei, diat walwalangor ma pa diat walangoro lelei, ma pa diat manaana uni. ");
INSERT INTO rai_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","A pirpir na propet anun Aaisaia ia ot un diat, baa i piri lenbi, ‘Muaat a walwalangor ma pa muaat a walangoro lelei, muaat a bababo ma pa muaat a babo lelei. ");
INSERT INTO rai_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maa kabina a taara mi a balaandiat i dekdek, a talingaandiat i tabanot, ma a mataandiat i pula. Baa gun diat a babo lele ma ra mataandiat, ma diat a walangoro lele ma ra talingaandiat, ma diat a manaana u ra nuknukindiat, ma diat a tapuku, io, iaau ut ang walaaun pa diat.’ Aais 6:9-10 ");
INSERT INTO rai_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iaku muaat, muaat daan, maa muaat babo ut ma ra mataamuaat, ma muaat walangor ut ma ra talingaamuaat kaai. ");
INSERT INTO rai_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iaau pir a lingtatuna taa muaat, namuga mongoro na propet ma mongoro na tena takado diat nem aakiti naa diat a babo a kum utnaa mi iaau paami namataamuaat, iaku pa diat baboi. Ma diat nem aakiti kaai naa diat a walangoro a kum utnaa mi muaat walwalangoroi, iaku pa diat walangoroi. ");
INSERT INTO rai_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Muaat a walangoro a kukuraai ra pirpir welwelaar u ra tena minamaarut. ");
INSERT INTO rai_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Baa te i walangoro paa a pirpir u ra mataanitu taanginaanga u ra maawa, ma pa i manaana uni, i welaar ma ra kum waina wit baa diat puka taau ku u ra aakapi. Ma a Tena Aakaina i waan paat ma i rakaan wa balet a pirpir baa di aa maarut taai u ra in balaana. ");
INSERT INTO rai_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma a kum waina baa diat puka taau u ra pia na waatwaat, i welaar ma raa muaana baa i walangoro paa a pirpir ma i paam akotoi maut ma ra gaaia. ");
INSERT INTO rai_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Iaku a pirpir pa i ki okot u ra in balaana, ma a muaana maa pa in tur dekdek, welaar ma ina wit baa pa ta aakaarina. Baa a kum mawaat ma ra kum ngunungut i baraatai kabina u ra pirpir baa i nurnur uni, in puka gagaa maut. ");
INSERT INTO rai_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A kum waina baa diat puka taau naliwan u ra kum katkadaa, i welaar ma raa muaana baa i walangoro a pirpir, iaku a kum nginaraa taanga min napia, ma ra nemnem kup a ngaala na wuwuwung diat burung baat paa a pirpir anun God, ma pa i wa. ");
INSERT INTO rai_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma a kum waina baa diat puka taau u ra koina pia, i welaar ma raa muaana baa i walangoro a pirpir, ma i manaana uni. In wa 100 baa in wa 60 baa in wa 30.” ");
INSERT INTO rai_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu i pir raa pirpir welwelaar bulung taan diat naa, “A mataanitu taanginaanga u ra maawa i welaar ma ra muaana baa i lamira a kum waina wit u ra ana pinapaam. ");
INSERT INTO rai_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Baa a taara diat inep, anuna ebaar i waan paat ma i lamira taa a kum waina karapaa naliwan taa ra kum wit, ma i waan paa. ");
INSERT INTO rai_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baa a waina wit i ilak paat ma i pot na wa, di babo lele paa kaai a karapaa i tawa naliwan. ");
INSERT INTO rai_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A kum tultul anu ra tamaa ra pinapaam maa diat waan karomi, ma diat piri taana naa, ‘Tadaaru, lelawaai a kum waina wit raap ku maa u lamira taai u ra maam pinapaam? Taangawaai raa kum karapaa maa?’ ");
INSERT INTO rai_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I baalu diat naa, ‘A ebaar i paam a mangamangaan maa.’ A kum tultul diat tiri naa, ‘U nemi baa miaat a waan, ma miaat a gaat araap wa diat?’ ");
INSERT INTO rai_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I turbaat diat naa, ‘Koku mun, kaduk muaat a gaat ungaai wai ma ra kum wit. ");
INSERT INTO rai_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Maadek wai, diaar a tawa ungaai tuk u ra kalaang na tinangaa. Ma u ra bung maa, ang piri taa ra kum tena tinangaa naa: Muaat a rakaan muga wa a kum karapaa, muaat a do ungaai taa a kum pakpakutina kupi din tun wa diat u ra nguan. Ma namur muaat a lo ungaai bulung a kum wit u ra nung ruma na wuwuwung.’” ");
INSERT INTO rai_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu i pir raa pirpir welwelaar bulung taan diat naa, “A mataanitu taanginaanga u ra maawa i welaar ma ra in waina maastad, baa raa muaana i lo paai, ma i maarut taai u ra ana pinapaam. ");
INSERT INTO rai_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I kinalik aakit ko ra kum waina diwaai raap, iaku baa i tawa waanwaan ma i ngaala, i ngaala aakit ko ra kum diwaai na winangaan raap. Ma a kum pika diat laana paam pio u ra kum gagagaana.” ");
INSERT INTO rai_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu i pir raa pirpir welwelaar bulung taan diat naa, “A mataanitu taanginaanga u ra maawa i welaar ma ra is baa raa tabuan i rakaan paai ma i paam ungaai taai ma ra ngaala na palawaa, ma a palawaa raap i tubu uni.” ");
INSERT INTO rai_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu i wer a kor na taara ma ra kum pirpir welwelaar, ma pa i pir balet ta utnaa karom diat ma ta pirpir ingen, a pirpir welwelaar raap ku. ");
INSERT INTO rai_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I piri lenmaa kupi din paam ot paa a pirpir anu ra propet naa, “Ang pirpir ma ra kum pirpir welwelaar, ang pir a kum utnaa baa i ki ino, turpaai namuga utbaai baa di waki a rakrakaan buaal.” Kele 78:2 ");
INSERT INTO rai_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Namur Iesu i waan ko ra kor na taara, i ruk u ra ruma, ma anuna kum naat na wawer diat ruk karomi ma diat aaringi naa, “Un palaa a kukuraai ra pirpir welwelaar bi taa miaat u ra kum karapaa baa i tawa naliwan u ra pinapaam.” ");
INSERT INTO rai_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I piri taan diat naa, “A muaana baa i lamira a kum waina wit ia Natu ra Muaana. ");
INSERT INTO rai_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A pinapaam, ia a rakrakaan buaal, ma a kum wit, diat a taara ko ra mataanitu taanginaanga u ra maawa. A kum karapaa, diat a kum natu ra Tena Aakaina, ");
INSERT INTO rai_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ma a ebaar baa i lamira diat, ia Saataan. A kalaang na tinangaa, ia a tintinip i ra rakrakaan buaal, ma a kum tena tinangaa, a kum aangelo. ");
INSERT INTO rai_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Welaar ma di lo ungaai a kum karapaa ma di tun wa diat u ra nguan, lenkaai maa din paami u ra tintinip i ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Natu ra Muaana in tula wa anuna kum aangelo, ma diat a rakaan raap wa a kum utnaa baa i ben araara a taara, ma diat kaai baa diat laana paam aakaina, ");
INSERT INTO rai_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ma diat a ong diat u ra ngaala na nguan. Diat a taangtaangi ma diat a karkaraat lakondiat iaai. ");
INSERT INTO rai_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma a kum tena takado diat a baarabaara welaar ma ra in mage u ra mataanitu anu ra Tamaandiat. Ia baa in talingaana, i koina baa in walangor mai. ");
INSERT INTO rai_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A mataanitu taanginaanga u ra maawa i welaar ma ra utnaa baa i ngaatngaat a mataana ma di walipa taai u ra pinapaam. Ma raa muaana i baat paai ma i walipa taai balet. Io, i waan ma ra gaaia, ma i wiura wa anuna kum utnaa raap, ma i kul paa a pinapaam mai maa. ");
INSERT INTO rai_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A mataanitu taanginaanga u ra maawa i welaar kaai ma raa tena wiura, i baatbaat kup a kum ngaatngaat na waat baa i laana ki nabalaa ra naawa. ");
INSERT INTO rai_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Baa i baat ki taa raain baa i ngaatngaat aakit a mataana, io i wiura wa anuna kum utnaa raap, ma i kul paa ina ngaatngaat na waat mai maa. ");
INSERT INTO rai_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“A mataanitu taanginaanga u ra maawa i welaar kaai ma ra bene, baa di ong taai nataai, ma aalawur mangaana ian diat wirua taau uni. ");
INSERT INTO rai_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Baa i teng a bene, a kum tena ong bene diat aal apari taai nakono ma diat ki baat paai. Diat wali wa a kum kokoina unaanga u ra kum kaa, ma ra kum aakaakaina diat ong wa diat. ");
INSERT INTO rai_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","U ra tintinip na bung din paami ut lenmi: A kum aangelo diat a waan paat ma diat a weraana wa a kum tena aakaina ko ra kum tena takodo. ");
INSERT INTO rai_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma diat a ong wa a kum tena aakaina u ra ngaala na nguan. Diat a taangtaangi ma diat a karkaraat lakondiat iaai. ");
INSERT INTO rai_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Lelawaai, muaat aa manaana u ra kum kukuraai ra kum utnaa raap mi, baa pate?” Anuna kum naat na wawer diat baalui naa, “Miaat aa nunurai.” ");
INSERT INTO rai_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma Iesu i piri taan diat naa, “A kum tena wawer raap u ra kum Naagagon, baa diat aa wawer paa u ra mataanitu taanginaanga u ra maawa, diat welaar ma raa muaana baa i walaaing a kum kokoina utnaa u ra nuna ruma. Ma baa i wapari a kum kokoina utnaa maa ko ra nuna ruma, raa mangaan a kum matakina utnaa ma raa mangaan kaai a kum turaaina utnaa.” ");
INSERT INTO rai_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Baa Iesu ia pir araap taa a kum pirpir welwelaar mi, i waan paa taanga matira, ");
INSERT INTO rai_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma i waan paat u ra nuna taamaan. I wer a taara u ra nundiat ruma na lotu, ma diat kakaian aakit ma diat piri naa, “A muaana mi i lo a manaana taangawaai? Ma i paam lelawaai a kum ngaala na utnaa na kakaian mi? ");
INSERT INTO rai_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tamaana a tena paam ruma ku, ma naana Maaria. A kum tatena liklik kaai, Iaakobo, Iosep, Simon ma Iudaas ");
INSERT INTO rai_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ma ra kum tatena liklik in tabuan kuri ut daat lalaaun ungaai main. Taangawaai a dekdek mi a muaana mi i paam a kum utnaa mai?” ");
INSERT INTO rai_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Io, pa diat gaaia ma uni. Ma Iesu i piri taan diat naa, “Di urur karom a propet u ra kum taamtaamaan ingen, iaku diat ut u ra nuna taamaan ma ra nuna ruma pa diat rui.” ");
INSERT INTO rai_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma pa i paam ta mongoro na utnaa na kakaian matira, kabina maa pa diat nurnur uni. ");
INSERT INTO rai_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","U ra kilaala maa, Erodes a mukmuga i walangoro a wewapua un Iesu, ");
INSERT INTO rai_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","io, i piri taa ra nuna kum tultul naa, “A muaana mi ia Ioaanes a Tena Baapitaaiso, ia lalaaun balet ko ra minaat. Maa ia kabina baa i paam a kum utnaa na kakaian mi.” ");
INSERT INTO rai_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Namuga Erodes i tula wa anuna kum tena wineium ma diat aal paa Ioaanes, diat do paai ma diat waruk taai u ra ruma na karabus, kabina maa Ioaanes i pir taai taan Erodes naa, “Pa i takado baa u taulaa ma Erodiaa, a tabuan anun temlik Pilipo.” ");
INSERT INTO rai_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ma Erodes i nemi kupi din aak doko Ioaanes, iaku i burut kup a taara, maa diat nunurai naa Ioaanes a propet. ");
INSERT INTO rai_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Baa i ot a bung na binabuta anun Erodes, natun Erodiaa a tabuan, i laagaar naan diat. Erodes i gaaia aakit uni, ");
INSERT INTO rai_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ma i weweliman dekdek taa a natun Erodiaa naa, “Aawa maku baa un aaringi kon iaau ang taari ku taam.” ");
INSERT INTO rai_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Io, i piri naa “Un taar taa ku in lorin Ioaanes a Tena Baapitaaiso taang un ta pelet.” I piri lenbi kabina maa naana ia wapua taai uni. ");
INSERT INTO rai_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A king i tapunuk aakit. Iaku kabina baa ia weweliman taau naa aawa raap baa i aaringi koni in tabaarai ut mai, ma a taara baa diat ki ungaai mai u ra winangaan diat aa walangoro taa anuna pirpir, io, i naagagon taa anuna kum tena wineium kupi diat a taraam u ra niaaring anu ra tauraara maa. ");
INSERT INTO rai_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","I wetulaa urong u ra ruma na karabus kupi din pakaat kutu in lorin Ioaanes. ");
INSERT INTO rai_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Diat ung paa in lorina u ra pelet ma diat loi karom a tauraara maa, ma i taari karom naana. ");
INSERT INTO rai_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Io, namur a kum naat na wawer anun Ioaanes diat waan ma diat lo paa a minaatina ma diat punang wai. Namur diat waan karom Iesu ma diat wapuai uni. ");
INSERT INTO rai_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Baa Iesu i walangoroi naa Ioaanes i maat, i kaa taau u ra mon ma i waan bolo taanga matira kup a bil na wanua kupi ia ot ku in ki. Ma baa a taara ko ra kum taamtaamaan diat nunurai, diat kalaa murmuri u ra aakapi kup a pakaana maa. ");
INSERT INTO rai_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Baa i pukaai matira i babo a ngaala na kor na taara. I maari aakit diat, ma i walaangalaanga pa diat raap baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Baa ia maluraap anuna kum naat na wawer diat waan karomi, ma diat piri naa, “A bil na wanua ku mi, a pakaana bung ia waan. Un tula wa a kor na taara baa diat a waan kup a kum taamtaamaan, kupi diat a kul paa andiat ta utnaa na winangaan.” ");
INSERT INTO rai_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu i baalu diat naa, “Diat a waan kup aawa? Muaat ut maa muaat a tabaara diat.” ");
INSERT INTO rai_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Diat piri taana naa, “Limnain bred ku ma ra ruina ian kuri miaat loi.” ");
INSERT INTO rai_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","I piri taan diat naa, “Muaat a loi urin karom iaau.” ");
INSERT INTO rai_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma i wetulaa kupi a kor na taara diat a ki u ra wali. I rakaan paa limnain bred ma ruina ian, i tataada unaanga u ra maawa, i waatung wakaak paa karom God uni, i bik paa limnain bred maa ma i taar taai taa ra nuna kum naat na wawer. Io, diat palau a kor na taara mai. ");
INSERT INTO rai_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Diat raap diat wangaan ma diat maaur. Ma diat wangaana ateng paa 12 kaa ma ra utnaa baa diat aan kapo taai. ");
INSERT INTO rai_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A in tabuan ma ra kum naat liklik ma in muaana diat raap maa diat wangaan. Iaku a niluluk i ra in muaana ku i welaar ma 5,000. ");
INSERT INTO rai_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Io, Iesu i tula wa anuna kum naat na wawer kupi diat a kaa u ra mon ma diat a muga kup raa papaara taai kikil, ma ia i ki utbaai kupi in tula wa a taara. ");
INSERT INTO rai_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Baa ia tula raap wa diat, ia ot maku i waan tato unaanga u ra taangaai kupi in aaraaring. Baa ia tawiwibung ia ot ku i ki. ");
INSERT INTO rai_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A mon ia waan naliwan ma i irok waanwaan u ra top, kabina a dadaip i weium taanga namuga. ");
INSERT INTO rai_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Naliwan taan tuluina pakaana bung ma 6 pakaana bung u ra malaana kinalik, Iesu i waan ku nate u ra taai kikil karom diat. ");
INSERT INTO rai_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Baa anuna kum naat na wawer diat babo paai baa i waan nate u ra taai kikil, diat burut aakit ma diat piri naa, “A nion ku duk manaanga!” Ma diat kulkulaai ma ra bunurut. ");
INSERT INTO rai_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma Iesu i pirpir gagaa maut karom diat naa, “Koku muaat ngaraa, iaau ku mi, koku muaat burut.” ");
INSERT INTO rai_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petero i piri taan Iesu naa, “Tadaaru, baa ui ut maa, un wataa iaau kupi iaau kaai ang waan ku nate u ra taai karom ui.” ");
INSERT INTO rai_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma i wataai naa, “Un waan urin.” Io, Petero i irok pari ko ra mon, ma i waan nate u ra taai kikil karom Iesu. ");
INSERT INTO rai_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Iaku, baa i babo a kum ngaalangaala na top, i burut. Ma baa i murung waanwaan, i wewataai naa, “Tadaaru, un walaaun iaau.” ");
INSERT INTO rai_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma Iesu i kado gagaa a limaana kupi, i aal tato paai ma i piri taana, “I kinalik aakit anum nurnur. I lawaai maa u aalawur nuknuk?” ");
INSERT INTO rai_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Baa diaar kaa u ra mon, a dadaip i ngo maut. ");
INSERT INTO rai_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Baa diat aa ki ungaai u ra mon, a kum naat na wawer diat lotu karom Iesu, ma diat piri naa, “I lingtatuna aakit baa ui a Natun God.” ");
INSERT INTO rai_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Baa diat aa waan bolo, diat pukaai taau nakono u ra papaar Genesaaret. ");
INSERT INTO rai_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma baa a taara taanga matira diat babo lele paa Iesu, diat taar waanawaana a wewapua karom a kum taamtaamaan. Io, diat ben araap paa a kum malaapaang karomi. ");
INSERT INTO rai_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma diat aaringi kupi a kum malaapaang diat a paam taa ku a titi ra nuna ina maalu. Io, diat raap baa diat paam taai, diat laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Raa kum Parisaaio ma ra kum tena wawer u ra kum Naagagon diat waan taanginaanga Ierusalem karom Iesu, ma diat tiri naa, ");
INSERT INTO rai_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aawa kabina maa anum kum naat na wawer pa diat murmur a kum wawer anu ra nundaat taara taanga namuga? Baa diat wangaan, pa diat gi muga paa a limaandiat.” ");
INSERT INTO rai_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma i baalu diat naa, “Aawa kabina maa pa muaat murmur a Naagagon anun God? Muaat murmur ku a kum wawer anu ra numuaat taara taanga namuga. ");
INSERT INTO rai_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Maa God i piri naa, ‘Un ru tamaam ma naam,’ Pin 20:12 ma i piri kaai lenbi, ‘Baa te in pirpir aakaka un tamaana ma naana, din aak dokoi.’ Pin 21:17 ");
INSERT INTO rai_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iaku muaat, muaat wer a taara naa i koina ku baa te in piri taan tamaana ma naana naa, ‘A utnaa baa ang waraaut mur mai, iaau aa tabaara taa God mai.’ ");
INSERT INTO rai_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Iaku baa pa i waraaut kaai tamaana, pa i rui. Baa muaat paami lenmaa, muaat wakinalik paa a pirpir anun God ma muaat murmur ku a kum wawer anu ra numuaat taara taanga namuga. ");
INSERT INTO rai_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Muaat a kum tena warwaruga. A lingtatuna ut maa Aaisaia ia pirpir na propet muga taau un muaat naa, ");
INSERT INTO rai_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A taara mi diat ru iaau ku ma ra waandiat, iaku maa a balaandiat i welwelik aakit kon iaau. ");
INSERT INTO rai_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Diat lotu biaa ku karom iaau, maa diat wer ku a taara ma ra kum naagagon anu ra taara ut.’” Aais 29:13 ");
INSERT INTO rai_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu i wataa paa a taara karomi, ma i piri taan diat naa, “Muaat a walangoro iaau ma muaat a nunura lele anung pirpir. ");
INSERT INTO rai_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A utnaa baa i ruk u ra waa ra muaana, pa in aaka uni namataan God. Iaku, a utnaa baa i piri ma ra waana in aaka uni.” ");
INSERT INTO rai_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Namur anuna kum naat na wawer diat waan karomi ma diat tiri naa, “Lelawaai u aa nunurai naa a kum Parisaaio diat kaankaan u ra num pirpir?” ");
INSERT INTO rai_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","I piri taan diat naa, “A kum diwaai baa Tamaang, baa i ki inaanga u ra maawa, pa i maarut diat, din gaat araap wa diat. ");
INSERT INTO rai_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Muaat a maadek wa a kum Parisaaio. Diat a kum pula na mukmuga. Baa ta pula in ben ta pula, diaar raap diaar a puka darong u ra tung.” ");
INSERT INTO rai_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma Petero i aaringi naa, “Un palaa a pirpir welwelaar mi karom miaat.” ");
INSERT INTO rai_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma Iesu i piri naa, “Muaat kaai pa muaat manaana utbaai? ");
INSERT INTO rai_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pa muaat nunurai naa, a kum utnaa raap baa i ruk u ra waa ra muaana, i waan u ra in balaana ma i babaa wai balet? ");
INSERT INTO rai_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Iaku a kum pirpir raap baa i piri ma ra waana, i waan paat ko ra nuknukina, ia maa i baanaakakai. ");
INSERT INTO rai_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bi ia a kum utnaa baa i waan paat ko ra nuknukina: a kum aakaina nuknuk, aak doko taara, di aal paa a tabuan anun te, a kum paamuk na mangamangaan, a winalong, a wetakun warwaruga, ma ra pirura. ");
INSERT INTO rai_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A kum utnaa mi diat baanaakaka a taara. Iaku baa diat wangaan ma pa diat gi muga paa a limaandiat, wakir i baanaakaka diat namataan God.” ");
INSERT INTO rai_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu i waan taanga matira, ma i waan paat marawaai Tiro ma Sidon. ");
INSERT INTO rai_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma raa tabuan a te Kaanaan taanga matira u ra papaar maa, i waan paat ma i wataa Iesu lenbi, “Tadaaru, Natun Dewid un maari iaau. Natunglik a tabuan, a tabaraan i ruk taau uni ma i baanaakaka aakiti.” ");
INSERT INTO rai_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iaku Iesu pa i baalui. Ma anuna kum naat na wawer diat waan karomi, ma diat aaringi naa, “Un tula wai maku, maa i kulkulaai murmur daat.” ");
INSERT INTO rai_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu i piri naa, “God i tula wa iaau urin kup a taara Israael ku, baa diat raara welaar ma ra kum sip.” ");
INSERT INTO rai_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iaku a tabuan maa i waan karom Iesu, i ki but keke namuga naana ma i piri taana naa, “Tadaaru, un waraaut iaau.” ");
INSERT INTO rai_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Iesu i baalui naa, “Pa i takado kupi din lo paa a utnaa ara kum naat, ma din tabaara a kum paap mai.” ");
INSERT INTO rai_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A tabuan maa i baalui naa, “A lingtatuna ut maa Tadaaru, iaku a kum paap kaai diat laana aan a kum mutamuta na utnaa baa i laana puka ko ra luwu na winangaan anu ra kum tamtamaandiat.” ");
INSERT INTO rai_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma Iesu i baalui naa, “Le, i ngaala aakit anum nurnur! A utnaa baa u nemi, ang paami ut karom ui.” Ma u ra pakaana bung ut maa natunalik i laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ma Iesu i waan ko ra taamaan maa, ma i wawaal waanwaan nakono u ra taai kikil Gaalilaia. Namur i waan tato u ra taangaai ma i ki iaai. ");
INSERT INTO rai_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma a ngaala na kor na taara diat waan karomi. Diat lo diat baa a kakindiat i maat, ma diat ben kaai a kum pula, a kum papeu, a kum munga, ma mongoro na malaapaang utkaai karomi. Ma diat waki ta diat marawaai naana, ma i walaangalaanga pa diat. ");
INSERT INTO rai_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A kor na taara maa diat kakaian baa diat babo a kum munga diat pirpir, ma ra kum papeu diat laangalaanga, ma diat baa a kakindiat i maat diat waan kado, ma ra kum pula kaai diat babo. Ma diat pir walaawa paa a God anu ra taara Israael. ");
INSERT INTO rai_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu i wataa paa anuna kum naat na wawer karomi ma i piri taan diat naa, “Iaau maari aakit a taara mi, maa diat aa ki ungaai ma daat min tula bung, ma pa ta utnaa na winangaan baa diat a aani. Pa iaau nemi baa ang tula wa diat ku ma ra minolo, kaduk diat a bengbeng waanwaan u ra aakapi.” ");
INSERT INTO rai_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A kum naat na wawer diat piri taana naa, “A bil na wanua ku mi, daat a lo paa ta ngaala na utnaa na winangaan awaai kupi daat a tabaara a kor na taara mai mi?” ");
INSERT INTO rai_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu i tiri diat naa, “Taiaain bred maa kuraa muaat loi?” Diat baalui naa, “7 na bred ma ra kabaana ina naatnaat na ian.” ");
INSERT INTO rai_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma i tula a taara raap kupi diat a ki unapia. ");
INSERT INTO rai_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","I lo paa 7 na bred ma kabaana ina ian maa, ma i waatung wakaak paa uni karom God, i biki ma i taari karom a kum naat na wawer kupi diat a tabaara a taara mai. ");
INSERT INTO rai_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A taara raap diat wangaan ma diat maaur. Diat wangaana teng paa 7 na kaa ma ra kum utnaa baa diat aan kapo taai. ");
INSERT INTO rai_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A in tabuan ma ra kum naat liklik ma in muaana diat raap diat wangaan. Iaku a niluluk i ra in muaana ku i welaar ma 4,000. ");
INSERT INTO rai_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ma Iesu i tula wa a kor na taara. Namur i kaa taau u ra mon, ma i waan kup a papaar Maagadaan. ");
INSERT INTO rai_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A kum Parisaaio ma ra kum Saadukaaio diat waan karom Iesu, ma diat aaringi naa in paam ta utnaa na kakaian namataandiat kupi in wakilangi naa ia taanginaanga u ra maawa.  ");
INSERT INTO rai_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma i piri taan diat naa, “Baa i maluraap muaat laana piri lenbi, ‘A baakut ia taar raap, unaburu pa in baata.’ ");
INSERT INTO rai_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma u ra malaana muaat laana piri kaai lenbi, ‘Umari in baata, maa a baakut ia taar raap, ma a waal na baakut ia bopbop raap.’ Muaat manaana kupi muaat a palaa a binabo u ra baakut, iaku pa muaat manaana kupi muaat a palaa a kum kukuraai ra kum wakilang i ra kum bungbung mi. ");
INSERT INTO rai_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A taaun taara mi, a aakaina taaun taara, a taaun taara baa anundiat lalaaun i welwelik kon God. Diat nem ta wakilang, iaku maa pa din paam te karom diat. Din paam ku a wakilang welaar ma Ionaa.” Ma Iesu i waan kon diat. ");
INSERT INTO rai_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesu ma ra nuna kum naat na wawer diat waan bolo u ra taai kikil, ma ra kum naat na wawer pa diat lo ta bred, diat dumaana wai ku. ");
INSERT INTO rai_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu i piri taan diat naa, “Muaat a baboura muaat ko ra is anu ra kum Parisaaio ma ra kum Saadukaaio.” ");
INSERT INTO rai_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma diat pirpir ungaai u ra kukuraai ra pirpir anun Iesu, ma diat piri naa, “I pirpir lenmaa kabina duk maa pa daat lo ta bred.” ");
INSERT INTO rai_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu i nunura anundiat pirpir ma i piri taan diat naa, “I kinalik aakit anumuaat nurnur. I lawaai maa muaat piri naa pa muaat lo ta bred? ");
INSERT INTO rai_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Lelawaai, pa muaat manaana utbaai? Pa muaat nuk paa limnaina bred baa iaau biki karom 5,000 na muaana? Ma taiaa kaa kaai maa muaat wateng paai balet ma ra utnaa na winangaan baa i ki kapo? ");
INSERT INTO rai_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pa muaat nuk paa kaai 7 na bred baa iaau biki karom 4,000 na muaana? Ma taiaa kaa maa muaat wateng paai ma ra utnaa na winangaan baa i ki kapo? ");
INSERT INTO rai_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","I lawaai maa pa muaat manaana? Pa iaau pirpir u ra bred. Muaat a baboura muaat ko ra is anu ra kum Parisaaio ma ra kum Saadukaaio.” ");
INSERT INTO rai_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Io, diat nunurai maraagaam naa pa i turbaat diat ko ra is baa i taana u ra bred, iaku i piri naa diat a baboura diat ko ra wawer anu ra kum Parisaaio ma ra kum Saadukaaio. ");
INSERT INTO rai_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu i waan paat marawaai a taamaan Kaaisaaria Pilipoi. Ma i tiri anuna kum naat na wawer naa, “A taara diat piri naa Natu ra Muaana maa woi?” ");
INSERT INTO rai_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Diat baalui naa, “Raa taara diat piri naa ui Ioaanes a Tena Baapitaaiso. Raa taara kaai diat piri naa ui Eliaas, raa taara kaai diat piri naa ui Ieramia, ma raa taara kaai diat piri naa ui raa kon diat a kum propet.” ");
INSERT INTO rai_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I tiri diat naa, “Io muaat, muaat piri naa iaau woi?” ");
INSERT INTO rai_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma Simon Petero i baalui naa, “Ui Kaarisito, a Natun God a lalaaunina.” ");
INSERT INTO rai_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Iesu i piri taana, “Simon, natun Ionaa, u daan, maa pa te i wapua ui u ra pirpir mi. Tamaang ut baa i ki inaanga u ra maawa i wanuk ta ui uni. ");
INSERT INTO rai_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma iaau piri taam naa, ui Petero, a waat ki. Ang pagaa anung taara na nurnur u ra waat mi. A dekdek i ra minaat pa in uwia paa anung taara na nurnur. ");
INSERT INTO rai_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ang taar a kum ki i ra mataanitu taanginaanga u ra maawa taam, ma ra kum utnaa raap baa u doi main napia, din doi kaai inaanga nate u ra maawa, ma ra kum utnaa raap baa u palaai main napia, din palaai kaai inaanga nate u ra maawa.” ");
INSERT INTO rai_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma Iesu i turbaat anuna kum naat na wawer naa koku diat wapua te baa ia Kaarisito. ");
INSERT INTO rai_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","U ra kum bungbung maa, Iesu i turpaai kupi in wer anuna kum naat na wawer naa in waan ut unaanga Ierusalem. A kum mukmuga, a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon diat a wakadiki ma din aak dokoi. Ma baa tula bung in raap in lalaaun paat balet. ");
INSERT INTO rai_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma Petero i ben ingen paa Iesu ma i turbaat dekdeki naa, “Koku Tadaaru! Koku mulu ut di paam a utnaa mi un ui.” ");
INSERT INTO rai_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu i tapuku karom Petero ma i piri taana naa, “Saataan, waan unamur kon iaau! U pet abaatbaat iaau, maa u murmur ku a nuknuki ra taara, ma pa u murmur a nuknukin God.” ");
INSERT INTO rai_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ma Iesu i piri taa ra nuna kum naat na wawer naa, “Baa te i nemi kupi in murmur iaau, koku i murmur a nuknukina. In puak paa anuna bolo ma in murmur iaau. ");
INSERT INTO rai_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Baa te i maari baat paa ku anuna lalaaun in wirua, iaku ia baa pa i maari baat anuna lalaaun kup iaau, in lalaaun. ");
INSERT INTO rai_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","In koina lelawaai baa te i kale raap paa a rakrakaan buaal, ma in baanaakaka wa a niono uni? In kul kiaana a niono ma ra aawa? ");
INSERT INTO rai_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maa Natu ra Muaana in waan paat ma ra minamaar anun Tamaana, diat ma ra nuna kum aangelo, ma in taar a wedok karom a taara raap raaraa welaar ma ra nundiat pinapaam. ");
INSERT INTO rai_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iaau pir a lingtatuna taa muaat, ta taara kon muaat mi, muaat tur min, baa pa muaat a maat utbaai, muaat a babo Natu ra Muaana in waan paat ungaai ma ra nuna mataanitu.” ");
INSERT INTO rai_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Baa ia raap 6 na bung, Iesu i ben paa Petero, Iaakobo ma Ioaanes, ia baa a tein Iaakobo, ma i ben ingen pa ditul unaanga u ra taangaai baa i tur tato aakit. ");
INSERT INTO rai_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma ditul babo a panin Iesu i raaungaana. A mataana i baara welaar ma in mataana mage, ma anuna kum maalu kaai i kabaang dekdek welaar ma ra kaapa. ");
INSERT INTO rai_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma a tula naat na wawer ditul babo paa Moses ma Eliaas diaar waan paat ma ditul pirpir ma Iesu. ");
INSERT INTO rai_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petero i piri taan Iesu naa, “Tadaaru, i koina baa daat a ki maku min. Baa u nemi, ang paam ta tula palpalip, num raa, raa anun Moses, ma raa anun Eliaas.” ");
INSERT INTO rai_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Baa i pirpir utbaai, a pakaana baakut baa i baara aakit i pulu baat pa diat. Ma in ingaan raa taanga u ra baakut maa i piri naa, “Bi ia Natunglik, a naat na wakwakaak, iaau gaaia aakit uni. Muaat a walangoroi.” ");
INSERT INTO rai_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Baa a tula naat na wawer ditul walangoroi, ditul burut aakit, ma ditul puka pari ma ra mataanditul unapia. ");
INSERT INTO rai_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iesu i waan karom ditul, i paam ditul ma i piri naa, “Mutul tur, koku mutul burut.” ");
INSERT INTO rai_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Baa ditul babo tato, pa ditul babo balet ma te, Iesu ot maku kuraa i tur. ");
INSERT INTO rai_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Baa diat waan pari waanwaan taanginaanga u ra taangaai, Iesu i turbaat ta ditul naa, “Koku mutul wapua taa te u ra utnaa mi mutul aa babo taai, tuk u ra bung baa Natu ra Muaana in tur balet ko ra minaat.” ");
INSERT INTO rai_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma anuna tula naat na wawer ditul tiri naa, “Aawa kabina maa a kum tena wawer u ra kum Naagagon diat piri naa Eliaas in waan paat muga?” ");
INSERT INTO rai_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I baalu ditul naa, “A lingtatuna ut, Eliaas in waan paat muga ma in wakado balet a kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma mi iaau piri taa mutul naa Eliaas ia waan paat, ma pa diat nunura lelei, diat paam a kum aakaina mangamangaan karomi, welaar ut ma ra nundiat nemnem. Lenkaai maa karom Natu ra Muaana, in kariaana a ngunungut ko ra limaa ra taara.” ");
INSERT INTO rai_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Io, a tula naat na wawer ditul nunurai maraagaam naa i pirpir karom ditul un Ioaanes a Tena Baapitaaiso. ");
INSERT INTO rai_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Baa Iesu ma ra tula naat na wawer diat waan pari karom a kor na taara, raa muaana i waan karom Iesu, i ki but keke taau naana ma i piri naa, ");
INSERT INTO rai_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tadaaru, un maari natunglik a naat muaana, i laana maatmaat laau, ma i kariaana aakit a ngaala na ngunungut. Mongoro na bung i laana puka taau u ra nguan ma mongoro na bung kaai u ra daanim. ");
INSERT INTO rai_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iaau aa ben taai mun karom anum kum naat na wawer, iaku maa pa diat pet laar paai kupi diat a walaangalaanga paai.” ");
INSERT INTO rai_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu i piri naa, “Muaat a taaun taara mi, pa muaat nurnur ma muaat a kum tena aakaina. Iaau aa ki iwan karom muaat. Unaangaian ma muaat a nurnur? Muaat a ben a naat maa urin karom iaau.” ");
INSERT INTO rai_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu i pirpir dekdek karom a tabaraan ma a tabaraan i pari paa ko ra naatlik, ma u ra pakaana bung ut maa i laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Namur a kum naat na wawer diat waan karom Iesu, ma diat tiri inoi naa, “I lawaai maa pa miaat lu irok laar paa a tabaraan koni?” ");
INSERT INTO rai_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma i baalu diat naa, “Kabina anumuaat nurnur i kinalik aakit. Iaau pir a lingtatuna taa muaat, baa anumuaat nurnur i kinalik welaar ma ina waina maastad, muaat a piri taa ra taangaai bi, ‘Un kakaraai paa taanga min urong,’ ma in kakaraai ku. Ma pain ta utnaa in dekdek karom muaat.” ");
INSERT INTO rai_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Baa Iesu ma ra nuna kum naat na wawer diat waan ungaai irong u ra papaar Gaalilaia, i piri taan diat naa, “Din taar taa Natu ra Muaana u ra limaa ra taara ");
INSERT INTO rai_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ma diat a aak dokoi. Ma baa tula bung in raap God in walaaun paai balet.” Ma a kum naat na wawer diat tapunuk aakit uni. ");
INSERT INTO rai_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Baa Iesu ma ra nuna kum naat na wawer diat waan paat irong Kaapernaaum, diat baa diat lolo tatakom kupi din baboura a ruma na wetabaar mai, diat waan karom Petero ma diat tiri naa, “Lelawaai, anumuaat tena wawer i laana taar a tatakom kup a ruma na wetabaar baa pate?” ");
INSERT INTO rai_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma i mulaaot naa, “Maia.” Baa Petero i ruk u ra ruma, Iesu i pirpir muga, ma i tiri naa, “Simon, aawa u nuki, a kum king main napia diat lo a tatakom ma ra wedok kon woi? Ko ra kum natnatundiat baa ko ra taara ingen duk?” ");
INSERT INTO rai_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma i baalui naa, “Ko ra taara ingen.” Iesu i piri taana naa, “Io lenmaa, a kum natnatundiat diat laangalaanga ko ra tatakom. ");
INSERT INTO rai_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Un waan urong u ra taai kikil ma un boko. Ma in mugaana ian baa un aal paai, un aal pangaanga waana, ma un lo paa a maani koni. Io, un lo taai karom diat ma un tatakom mai anundaar raap, kupi koku daar pet akaankaan diat.” ");
INSERT INTO rai_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","U ra pakaana bung maa, anuna kum naat na wawer diat waan karom Iesu, ma diat tiri naa, “Woi maa i ngaala aakit u ra mataanitu taanginaanga u ra maawa?” ");
INSERT INTO rai_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","I wataa paa raa naatlik karomi, i watur taai naliwan taan diat, ");
INSERT INTO rai_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ma i piri naa, “Iaau pir a lingtatuna taa muaat, baa pa muaat a nukpuku kupi muaat a welaar ma ra kum naat liklik, pa muaat a ruk laar paai u ra mataanitu taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ia baa i wakinalik paai welaar ma ra naatlik bi, ia ut maa i ngaala aakit u ra mataanitu taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Baa te i gaaia paa ta naatlik lenbi u ra iaang, i gaaia pa iaau utkaai. ");
INSERT INTO rai_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma baa te i ben araara raa ko ra kum naat liklik bi baa i nurnur un iaau, in aaka aakit a naagagon karomi taan te baa din kubu taa ina ngaala na waat u ra in kabarono, ma din wamurung wai u ra lamaana nataai. ");
INSERT INTO rai_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“In aaka karom a taara u ra rakrakaan buaal, kabina u ra kum utnaa baa i pet taa a taara kupi diat a puka u ra aakaina. A kum utnaa maa in waan paat ut, iaku in aaka aakit karom ia baa i paam apaat paa a kum utnaa maa. ");
INSERT INTO rai_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Baa limaam baa kakim i ben araara ui, un kutu wai ma un ong ingen wai. In koina baa un ruk u ra lalaaun takum a tum ku ui, kupi koku di ong ui ungaai ma ra ru limaam baa ru kakim raap u ra ngaala na nguan baa pa in maat. ");
INSERT INTO rai_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Baa in mataam i ben araara ui, un lior wai ma un ong ingen wai. In koina baa un ruk u ra lalaaun takum ma tin mataam ku, kupi koku di ong ui ungaai ma ruin mataam raap u ra ngaala na nguan baa pa in maat. ");
INSERT INTO rai_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Koku muaat nuk akinalik paa te ko ra kum naat liklik bi. Iaau piri taa muaat, anundiat kum aangelo u ra maawa diat laana babo a mataan Tamaang baa i ki inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Muaat nuki lelawaai? Baa ta muaana anuna ta maar na sip, ma raa kon diat i raara, lelawaai, pa in waan paa kon 99 matira u ra kum taangaai, ma in baat kup raa baa i raara? ");
INSERT INTO rai_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iaau pir a lingtatuna taa muaat, baa in baat paai anuna gaaia uni in ngaala taun anuna gaaia un 99 baa pa diat raara. ");
INSERT INTO rai_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lenkaai maa, Tamaamuaat baa i ki inaanga u ra maawa, pa i nemi baa te kon diat a kum kinalik bi in wirua. ");
INSERT INTO rai_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Baa temlik i paam aakaina karom ui, un waan karomi, ma mur ku mur a ki. Io, un pir waiaa anuna niraara karomi. Baa in walangoro ui, io u aa wamaraam paai balet. ");
INSERT INTO rai_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Baa pa in walangoro ui, un ben paa balet te baa ta rudi baa diaar kaai diaar a waraaut ui. Maa a Buk Taabu i piri lenbi, ‘Baa ta rudi baa ta tuldi anunditul pirpir i raa ku un ta utnaa, anunditul pirpir i lingtatuna.’ ");
INSERT INTO rai_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Baa pa in walangoro diaar, un wapuaanai karom a taara na nurnur. Ma baa pa in walangoro bulung a taara na nurnur, koina baa un baboi welaar ma ia baa wakir a tena nurnur, welaar ku ma ra kum tena lolo tatakom. ");
INSERT INTO rai_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iaau pir a lingtatuna taa muaat, a kum utnaa raap baa muaat doi main napia, din doi kaai inaanga nate u ra maawa, ma ra kum utnaa raap baa muaat palaai main napia, din palaai kaai inaanga nate u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Iaau piri kaai taa muaat, baa ta rudi kon muaat main napia diaar mulaaot un ta utnaa baa diaar aaring kupi, Tamaang baa i ki inaanga u ra maawa in paam ot paai ut karom diaar. ");
INSERT INTO rai_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Baa ta rudi baa ta tuldi ditul ki ungaai u ra iaang, iaau ang ki ungaai ma ditul.” ");
INSERT INTO rai_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petero i waan karom Iesu, ma i tiri naa, “Tadaaru, taiaa pakaan ang dumaana wa aakaina baa tenglik i paami karom iaau? Ta 7 na pakaan duk?” ");
INSERT INTO rai_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu i baalui naa, “Wakir iaau piri taam naa 7 na pakaan ku. Iaau piri naa 77 na pakaan. ");
INSERT INTO rai_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Baboi, a mataanitu taanginaanga u ra maawa i welaar ma ra king baa i nem na wakado anuna maani baa anuna kum tultul diat dinaau papaai koni. ");
INSERT INTO rai_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Baa i turpaa wetiri, di ben paa raa tultul karomi baa i dinaau paa 10,000 na kina. ");
INSERT INTO rai_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Iaku maa pa ta maani baa in baalui mai, io, anuna tadaaru i naagagoni baa din wiura paa a muaana maa, anuna tabuan, ma ra kum natnatuna, ungaai ma ra nuna kum utnaa raap, kupi din baalu a maani mai maa. ");
INSERT INTO rai_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Io, a tultul maa i ki but keke namataa ra nuna tadaaru, ma i aaringi naa, ‘Un maadek wa iaau kumun, ma namur ang baalu raap taa anum maani.’ ");
INSERT INTO rai_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma a tadaaru anu ra tultul maa i maari, ma i piri naa, ‘Un waan. Koku maku u baalui.’ ");
INSERT INTO rai_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“A tultul maa i pari unataamaan, ma i baraata paa raa tultul baa namuga i dinaau paa ku 10 kina koni. I paam akoto paai, i bing in kabarono, ma i piri taana naa, ‘Un baalu taa anung maani baa u dinaau paai.’ ");
INSERT INTO rai_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ma tepaana i ki but keke namataana ma i aaringi naa, ‘Un maadek wa iaau kumun, maa kuraa ku ang baalu taa balet anum maani.’ ");
INSERT INTO rai_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Iaku i patut ku. I ben paai ma i waruk taai u ra ruma na karabus tuk u ra bung baa in baalu taa ut a maani baa i dinaau paai. ");
INSERT INTO rai_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Baa a kum teptepaana diat babo a kum utnaa mi i paami, diat kaankaan aakit, diat waan karom anundiat tadaaru, ma diat wapuai u ra kum utnaa baa a muaana mi ia paam taai. ");
INSERT INTO rai_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Anuna tadaaru i wataa paai, ma i piri taana naa, ‘Ui, a aakaina tultul ui, iaau maadek wa ui kupi koku ma u baalu a maani baa u dinaau paai taang, kabina maa u aaring iaau. ");
INSERT INTO rai_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aawa kabina maa pa u maari a tepaam welaar ma iaau maari ui?’ ");
INSERT INTO rai_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Anuna tadaaru i kaankaan karomi, ma i taar taai taa ra kum tena baboura u ra ruma na karabus kupi diat a pet na bilbil uni tuk in baalu taa ut a maani baa i dinaau paai. ");
INSERT INTO rai_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tamaang baa i ki inaanga u ra maawa in paami kaai lenmaa karom muaat raaraa, baa pa muaat dumaana mulu wa aakaina baa a kum tateimuaat diat paam taai karom muaat.” ");
INSERT INTO rai_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Baa Iesu ia pir araap taa a kum pirpir mi, i waan paa taangirong Gaalilaia, urong u ra papaar Iudaia, ma i waan bolo u ra daanim Ioridaan. ");
INSERT INTO rai_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma a ngaala na kor na taara diat murmuri, ma i walaangalaanga pa diat baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Raa kum Parisaaio diat waan karomi kupi diat a walaari. Diat tiri naa, “I takado ut welaar ma ra nundaat kum Naagagon baa a muaana in lu wa nuna tabuan un ta utnaa biaa ku, baa pate?” ");
INSERT INTO rai_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I baalu diat naa, “Lelawaai, pa muaat luk utbaai a pirpir u ra Buk Taabu? I piri lenbi: U ra turpaai ra wawaki, a Tena Wawaki ‘i waki a taara, kupi diat in muaana ma in tabuan,’ Tur 1:27 ");
INSERT INTO rai_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma i piri naa, ‘Mari ia a kabina baa a muaana in waan paa kon tamaana ma naana, ma in ki ungaai ma ra nuna tabuan, kupi diaar a raa maku.’ Tur 2:24 ");
INSERT INTO rai_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma wakir diaar rudi ma, diaar raa maku. A utnaa baa God ia kubu ungaai taai, koku balet ma te i kutui.” ");
INSERT INTO rai_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Diat tiri balet naa, “Aawa kabina maa Moses i naagagon taai naa a muaana in timu taa a dona buk na kutu tinaulaa kupi din palaa wa a kini na tinaulaa mai?” ");
INSERT INTO rai_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I baalu diat naa, “Moses i mulaaot wa muaat baa muaat a lu wa numuaat kum tabuan, kabina maa a balaamuaat i dekdek aakit. Iaku u ra turpaai ra wawaki pa di paami lenmaa. ");
INSERT INTO rai_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iaau piri taa muaat, baa te in lu wa anuna tabuan baa pa i paam ta aakaina ungaai ma ta muaana ingen, ma a muaana maa i taulaa balet ma ta tabuan, a muaana maa i paam aakaina.” ");
INSERT INTO rai_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Anuna kum naat na wawer diat piri taana, “Baa a naagagon lenmaa kup a muaana ma ra tabuan diaar a ki ungaai takum, io, koina baa koku di taulaa.” ");
INSERT INTO rai_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I piri taan diat, “A taara raap pa diat murmur laar paa a pirpir mi, diat ku baa di aa taar taa a dekdek taan diat kupi diat a murmuri. ");
INSERT INTO rai_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","A kum kabina i ki baa ta taara pain diat a taulaa. Raa taara di buta diat lenutmaa. Raa taara, a taara ut diat baanaakaka diat, ma raa taara kaai, pa diat taulaa kabina diat a balaan u ra pinapaam anu ra mataanitu taanginaanga u ra maawa. Ia baa i pet laar paai, in murmur a pirpir mi.” ");
INSERT INTO rai_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Di ben a kum naat liklik karom Iesu kupi in ung a ru limaana nate un diat ma in aaraaring un diat. Iaku maa anuna kum naat na wawer diat turbaat diat. ");
INSERT INTO rai_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu i piri naa, “Muaat a maadek wa a kum naat liklik baa diat a waan karom iaau. Koku muaat turbaat diat, maa a mataanitu taanginaanga u ra maawa anundiat baa diat lenbi.” ");
INSERT INTO rai_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Io, i ung taa a ru limaana nate un diat, ma namur i waan taanga matira. ");
INSERT INTO rai_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Raa baarmaan i waan karom Iesu, ma i tiri naa, “Tena Wawer, aawa koina utnaa baa ang paami kupi ang kale a lalaaun takum?” ");
INSERT INTO rai_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu i baalui naa, “Aawa kabina maa u tiri iaau kup aawa baa i koina? Raa ot ku i koina. Baa u nemi naa un ruk u ra lalaaun takum, un taraam u ra kum Naagagon.” ");
INSERT INTO rai_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma i tiri naa, “Woi na kum Naagagon?” Iesu i baalui naa, “‘Koku u aak doko te, koku u paam aakaina un ta tabuan anun te, koku u walong, koku u wetakun warwaruga, ");
INSERT INTO rai_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","un urur karom tamaam ma naam,’ Pin 20:12-16 ma ‘un maari tepaam welaar ma u maari ui ut.’” Lewi 19:18 ");
INSERT INTO rai_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A baarmaan maa i piri taana naa, “A kum Naagagon raap mi iaau aa murmur araap paai. Woi na utnaa maku maa iaau iba utbaai kupi?” ");
INSERT INTO rai_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu i baalui naa, “Baa u nemi naa un koina aakit, un waan ma un wiura wa anum kum wuwuwung raap, ma ra maani koni un tabaara a kum iba na taara mai. Baa un paami lenmaa anum a koina wuwuwung inaanga u ra maawa. Namur un waan urin ma un murmur iaau.” ");
INSERT INTO rai_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Baa a baarmaan maa i walangoro paa a pirpir mi i waan ma ra tapunuk, kabina maa i ngaala aakit anuna wuwuwung. ");
INSERT INTO rai_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma Iesu i piri taa ra nuna kum naat na wawer naa, “Iaau pir a lingtatuna taa muaat, in dekdek aakit karom a tadaaru na muaana kupi in ruk u ra mataanitu inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iaau piri kaai taa muaat naa, i dekdek karom a kaamel kupi in ruk u ra maata na nil na ingingit, iaku i dekdek aakit karom a tadaaru na muaana kupi in ruk u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Baa anuna kum naat na wawer diat walangoroi diat kakaian aakit, ma diat piri naa, “Baa lenmaa, woi ma maa din walaauni?” ");
INSERT INTO rai_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu i babo karom diat ma i piri naa, “A taara pain diat a pet laar paai, iaku God in pet laar paa a kum utnaa raap.” ");
INSERT INTO rai_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petero i baalui maut naa, “Baboi, miaat aa waan ko ra numiaat kum utnaa raap, ma miaat murmur ui. Aawa maa miaat a kalei namur?” ");
INSERT INTO rai_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu i piri taan diat naa, “Iaau pir a lingtatuna taa muaat, baa Natu ra Muaana in ki na king u ra nuna kiki na minamaar ma din wamatakina a kum utnaa raap, muaat baa muaat aa murmur iaau, muaat a ki u ra 12 a kum kiki na king, ma muaat a naagagon a 12 wuna taara Israael. ");
INSERT INTO rai_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma diat raap raaraa baa diat aa waan ko ra nundiat kum ruma, baa ko ra kum tateindiat in muaana baa in tabuan, baa ko ra kum tamtamaandiat, baa a kum nanaandiat, baa a kum natnatundiat, baa ko ra nundiat kum pia, kabina un iaau, din taar taa a maarmaar na utnaa lenmi taan diat, ma diat a kale paa kaai a lalaaun takum. ");
INSERT INTO rai_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma mongoro baa diat muga mi, namur diat a murmur, ma diat baa diat murmur mi, namur diat a muga.” ");
INSERT INTO rai_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“A mataanitu taanginaanga u ra maawa i welaar ma ra tamaa ra wanua na waain, i pari u ra malaana kinalik kupi in ben paa ta kum tena pinapaam ma i wapua diat naa diat a papaam u ra nuna wanua na waain. ");
INSERT INTO rai_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma diat kukubu ungaai ma ra kum tena pinapaam kupi diat a lo a wedok kon raa bung na pinapaam, ma i tula wa diat kup anuna wanua na waain. ");
INSERT INTO rai_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Baa ia 9 na pakaana bung, i waan balet ma i babo paa raa taara diat turtur biaa ku u ra taamaan na winawaan ungaai. ");
INSERT INTO rai_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma i piri taan diat naa, ‘Muaat kaai, muaat a waan, muaat a papaam u ra nung wanua na waain, ma ang dok muaat welaar ma ra numuaat pinapaam.’ ");
INSERT INTO rai_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma diat waan. “Io, u ra ngaala na mage i waan ma i ben paa balet raa kum tena pinapaam, ma u ra tuluin na pakaana bung u ra maluraap i waan balet kup ta taara. ");
INSERT INTO rai_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","U ra lima na pakaana bung u ra maluraap i waan balet, ma i babo paa raa taara bulung diat turtur biaa ku, ma i piri taan diat naa, ‘I lawaai maa muaat tur biaa ku main u ra kudulaana bung raap mi?’ ");
INSERT INTO rai_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Diat baalui naa, ‘Pa te i ben miaat un ta pinapaam.’ I piri taan diat naa, ‘Muaat kaai muaat a waan ma muaat a papaam u ra nung wanua na waain.’ ");
INSERT INTO rai_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Baa i tawiwibung, ia baa anuna wanua na waain, i piri taa ra mukmuga anu ra nuna kum tena pinapaam naa, ‘Wataa paa a taara na pinapaam urin, ma un dok diat, un dok amuga diat baa diat waan paat namur, ma un dok amurmur diat baa diat waan paat muga.’ ");
INSERT INTO rai_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A kum tena pinapaam baa di ben pa diat u ra limnaina pakaana bung diat waan paat, ma di dok diat raaraa ma ra wedok kon raa bung na pinapaam. ");
INSERT INTO rai_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Diat baa di ben muga pa diat diat waan paat, diat nuki naa diat a lo ta ngaala na wedok. Iaku, pate, diat kaai di dok diat ku raaraa ma ra wedok kon raa bung na pinapaam. ");
INSERT INTO rai_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baa diat aa lalo paa, diat pirura a tamaa ra wanua na waain, diat piri naa, ");
INSERT INTO rai_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Diat bi pa diat papaam iwan, ma miaat miaat paam a dekdek na pinapaam ma ra mage i raang miaat, iaku u dok diat utkaai welaar ma miaat.’ ");
INSERT INTO rai_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ma i piri karom raa kon diat naa, ‘Tepaang, wakir iaau baanaakaka ui. Lelawaai, pa daar kukubu paa kup a wedok kon raa bung na pinapaam? ");
INSERT INTO rai_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lo paa anum maani, ma un waan. Iaau ut iaau nemi naa ang dok diat baa diat waan paat namur welaar ma ui baa u muga. ");
INSERT INTO rai_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lelawaai pa i ot baa ang naagagon anung maani welaar ma ra nung nemnem? Lelawaai, u nuknuk aakaka baa iaau maari a taara bi?’ ");
INSERT INTO rai_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Lenmaa diat baa diat murmur mi, namur diat a muga, ma diat baa diat muga mi, namur diat a murmur.” ");
INSERT INTO rai_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Baa Iesu i waan waanwaan utbaai kup Ierusalem, i ben ingen paa anuna 12 naat na wawer, ma i piri taan diat naa, ");
INSERT INTO rai_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Baboi, mi daat waan unaanga Ierusalem. Din taar taa Natu ra Muaana karom a kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon. Diat a naagagoni kupi in wirua, ");
INSERT INTO rai_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ma diat a taar taai karom diat baa wakir a taara Iudaia kupi diat a tataur uni, diat a raapui, ma diat a aak waati u ra bolo. Ma u ra wetula bung in lalaaun paat balet.” ");
INSERT INTO rai_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Namur a naa ra ru natun Sebedaaio i waan karom Iesu ma ra ru natnatuna, i ki but keke namataana ma i aaringi baa in taraam u ra nuna nemnem. ");
INSERT INTO rai_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma Iesu i tiri naa, “Aawa maa u nemi?” Ma i baalui naa, “Un naagagoni naa a ru natnatung mi, diaar a ki ungaai ma ui u ra num mataanitu, raa u ra ot na limaam, ma raa paan diaar u ra maira, ma mutul a naagagon ungaai.” ");
INSERT INTO rai_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu i baalui naa, “Pa mutul nunura a utnaa maa mutul aaring kupi. Lelawaai, in tale mur kupi mur kaai mur a kariaana a ngunungut baa ang kariaanai?” Diaar baalui naa, “Mir a pet laar paai ku.” ");
INSERT INTO rai_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I piri taan diaar naa, “A lingtatuna ut, a ngunungut baa ang kariaanai, mur kaai mur a kariaanai. Iaku u ra kinkini u ra ot ma ra maira na limaang, wakir iaau, iaau naagagoni kupi ang taari. Tamaang in taari karom diat baa ia waninaar taai kup diat.” ");
INSERT INTO rai_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Baa 10 naat na wawer diat walangoroi, diat kaankaan karom naadina maa. ");
INSERT INTO rai_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu i wataa ungaai pa diat ma i piri naa, “Muaat nunurai naa a kum tena naagagon anu ra taara baa wakir a taara Iudaia, diat naagagon aakaka a taara. Ma anundiat kum mukmuga kaai diat taar a kum dekdek na naagagon karom diat. ");
INSERT INTO rai_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Iaku karom muaat pa in lenmaa. Baa te i nemi naa in ngaala taa muaat, in wakinalik paai kupi in tultul anumuaat. ");
INSERT INTO rai_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma ia baa i nemi kupi in mukmuga anumuaat, in wilawilaau ku anumuaat. ");
INSERT INTO rai_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lenkaai maa Natu ra Muaana pa i waan paat kupi din papaam karomi. I waan paat ku kupi ia ut in papaam karom a taara ma in taar taa anuna lalaaun, kup ia a winekul anu ra mongoro na taara.” ");
INSERT INTO rai_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Baa Iesu ma ra nuna kum naat na wawer diat waan taangirong Ieriko, a ngaala na kor na taara diat murmur diat. ");
INSERT INTO rai_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Raa ru muaana a ru pula diaar kiki u ra papaara aakapi. Baa diaar walangoroi naa Iesu i waan waanwaan marawaai, diaar wewataai dekdek naa, “Tadaaru, Natun Dewid, un maari mir.” ");
INSERT INTO rai_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma a kor na taara diat turbaat diaar naa koku diaar ge. Iaku diaar wewataai dekdek bakaai ma naa, “Tadaaru, Natun Dewid, un maari mir.” ");
INSERT INTO rai_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu i tur, ma i wataa pa diaar, ma i tiri diaar naa, “Aawa maa mur nemi naa ang paami un mur?” ");
INSERT INTO rai_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Diaar baalui naa, “Tadaaru, mir nemi naa un wababo pa mir.” ");
INSERT INTO rai_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu i maari aakit diaar, i paam a mataandiaar, ma diaar babo gagaa maut, ma diaar murmuri. ");
INSERT INTO rai_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Baa diat waan marawaai Ierusalem, ma diat waan paat Betpaage u ra Taangaai na Oliwa, Iesu i tula wa a ru naat na wawer. ");
INSERT INTO rai_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","I piri taan diaar naa, “Mur a waan kup a taamaan kuraa namuga taa mur. Mur a waan taau un raa dongki kuraa di do koto taai, ungaai ma natunalik. Mur a palaa pa diaar, ma mur a ben diaar urin karom iaau. ");
INSERT INTO rai_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Baa te in tiri mur un diaar, mur a piri naa, ‘A Tadaaru i nem diaar,’ io, in maadek gagaa wa diaar ku karom mur.” ");
INSERT INTO rai_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Di paam a utnaa mi kupi din paam ot paa a pirpir anun God baa a propet ia pir taai namuga naa, ");
INSERT INTO rai_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Muaat a wapua a taara Sion naa, ‘Baboi, anumuaat king mi i waan paat karom muaat, ia baa i wakinalik paai, ma i ki nate u ra dongki, a naat na dongki.’” Saak 9:9 ");
INSERT INTO rai_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A ru naat na wawer diaar waan, ma diaar paami welaar ma ra pirpir Iesu ia pir taai taan diaar. ");
INSERT INTO rai_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Diaar ben paa a dongki ungaai ma natuna, diaar rakaan wa ruina maalu baa diaar burung baat anundiaar minong mai, diaar ung taai nate u ra ru dongki, ma Iesu i ki taau nate uni. ");
INSERT INTO rai_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mongoro ko ra kor na taara kaai diat rakaan wa nundiat kum maalu baa diat burburung baat anundiat kum minong mai, ma diat laangun taai u ra aakapi. Ma raa taara kaai diat bur paa a kum turun na diwaai ma diat ung taai u ra aakapi. ");
INSERT INTO rai_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma ra kor na taara baa diat muga taana, ma diat kaai baa diat murmur, diat kulkulaai lenbi, “Osaana karom Natun Dewid! Daat a pir walaawa paa ia baa i waan paat u ra iaa ra Tadaaru!” Kele 118:25-26 “Osaana unaanga nate aakit!” ");
INSERT INTO rai_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Baa Iesu i waan paat inaanga Ierusalem, a taara Ierusalem raap diat kakaian ma diat wetiri naa, “Woi mi?” ");
INSERT INTO rai_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma ra taara baa diat weur ungaai mai diat piri naa, “A muaana mi ia Iesu, a propet taangirong Naasaret u ra papaar Gaalilaia.” ");
INSERT INTO rai_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu i ruk un raa pakaana ko ra ruma na wetabaar, ma i lu pari wa diat raap baa diat wiura, ma diat baa diat kukul matira. I ong puku wa a kum luwu anu ra kum tena kiaana maani ma ra kum kiki anundiat baa diat wiura a kum buna. ");
INSERT INTO rai_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma i piri taan diat naa, “Di aa timu taai u ra Buk Taabu lenbi, ‘Din waatung anung ruma baa a ruma na niaaring.’ Aais 56:7 Iaku muaat aa paam puku paai kupi in welaar maku ma ra ‘ruma anu ra kum tena walong.’” Ier 7:11 ");
INSERT INTO rai_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A kum pula ma diat baa a kakindiat i maat diat waan karomi u ra ruma na wetabaar ma i walaangalaanga pa diat. ");
INSERT INTO rai_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma baa a kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon diat babo a koina utnaa aakit mi i paami, ma diat walangoro kaai a kum naat liklik diat kulkulaai naruma u ra ruma na wetabaar naa, “Osaana karom Natun Dewid,” diat kaankaan aakit. ");
INSERT INTO rai_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma diat tiri Iesu naa, “U aa walangoro taa kum pirpir mi anu ra kum naat liklik?” Iesu i baalu diat naa, “Maia! Lelawaai, pa muaat luk utbaai a pirpir ko ra Buk Taabu? I piri lenbi, ‘U aa wer taa a kum naat liklik kupi diat a pir walaawa pa ui.’” Kele 8:2 ");
INSERT INTO rai_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma i waan kon diat matira u ra taamaan maa, ma i waan urong Betaania ma i inep paa raa bung na marum marong. ");
INSERT INTO rai_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","U ra malaana kinalik baa Iesu i waan talili balet unaanga Ierusalem, i molo. ");
INSERT INTO rai_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I babo paa in diwaai na fig i tur taau u ra papaara aakapi, ma i waan marawaai karomi. Iaku pa i babo ta waina uni, a dondono biaa ku. Ma i piri karom in diwaai na fig naa, “Turpaai mi ma namur, pa un wa balet ma.” Io, in diwaai na fig maa i maraang maut. ");
INSERT INTO rai_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Baa a kum naat na wawer diat baboi, diat kakaian, ma diat tiri naa, “In diwaai na fig mi i maraang gagaa lelawaai?” ");
INSERT INTO rai_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu i baalu diat naa, “Iaau pir a lingtatuna taa muaat, baa muaat nurnur, ma pain muaat a aalawur nuknuk, muaat a paam ku a pinapaam mi iaau paami u ra in diwaai na fig. Wakir mi ku ia maa muaat a paami, pate. Baa muaat a piri karom a taangaai bi naa, ‘Un tarigaat ma un irok lop unataai,’ in paami ku. ");
INSERT INTO rai_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Baa muaat nurnur, a kum utnaa raap baa muaat aaraaring kupi, din taari ut taa muaat.” ");
INSERT INTO rai_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu i ruk u ra ruma na wetabaar, ma i wer a taara. A kum ngaala na tena wetabaar karom God ma ra kum mukmuga anu ra taara diat waan karomi, ma diat tiri naa, “Woi na mangaana naagagon maa u paam a kum utnaa mai mi? Woi maa i taar taa a naagagon mi taam?” ");
INSERT INTO rai_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Iesu i baalu diat naa, “Iaau kaai ang tiri muaat ma raa wetiri. Ma baa muaat a baalu iaau, io, ang wapua muaat u ra naagagon iaau laana paam a kum utnaa mai mi. ");
INSERT INTO rai_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Taangawaai a baapitaaiso anun Ioaanes? Taanginaanga u ra maawa, baa ko ra taara ku?” Ma diat pirpir ino paa lenbi, “Baa daat a piri naa, ‘Taanginaanga u ra maawa,’ in baalu daat ku naa, ‘Io, i lawaai maa pa muaat nurnur uni?’ ");
INSERT INTO rai_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iaku baa daat a piri naa, ‘Ko ra taara,’ io, daat a burut kup a taara kaduk diat a kaankaan karom daat, maa diat raap diat nurnur un Ioaanes naa ia a propet.” ");
INSERT INTO rai_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Io, diat baalu ku Iesu naa, “Pa miaat nunurai.” Ma Iesu i piri taan diat naa, “Iaau kaai pang wapua muaat u ra naagagon iaau laana paam a kum utnaa mai mi.” ");
INSERT INTO rai_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu i wapua diat balet naa, “Aawa muaat nuki? Raa muaana ru natuna, a ru naat muaana. I waan karom raa paan diaar, ma i piri taana naa, ‘Natunglik, mi ut un waan kup a wanua na waain ma un papaam.’ ");
INSERT INTO rai_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma natunalik i piri naa, ‘Iaau pang waan,’ iaku namur i puku balet a nuknukina, ma i waan. ");
INSERT INTO rai_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma tamaana i waan bulung karom raa paan diaar, ma i piri kaai lenmaa taana, ma natunalik i piri naa, ‘Koina ku tataa, ang waan ut,’ iaku pa i waan. ");
INSERT INTO rai_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Woi na paa ra ru naat maa i taraam karom tamaandiaar?” Diat baalui naa, “A mugaana.” Iesu i piri taan diat naa, “Iaau pir a lingtatuna taa muaat, a kum tena lolo tatakom ma ra kum paamuk na tabuan kuri ma diat ruk muga waanwaan kon muaat u ra mataanitu anun God. ");
INSERT INTO rai_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maa Ioaanes i waan paat ma i wer muaat u ra mangamangaan baa i takado, ma pa muaat nurnur uni, iaku a kum tena lolo tatakom ma ra kum paamuk na tabuan diat maa diat nurnur uni. Muaat babo ta diat ut, iaku pa muaat nukpuku kaai kupi muaat a nurnur uni.” ");
INSERT INTO rai_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Muaat a walangoro taa bulung raa pirpir welwelaar lenbi: Raa muaana i maarut taa a wanua na waain, ma i liplip baat taai. Naruma u ra wanua na waain maa i kil taa in tung kupi din paa ginagina taa a polo na waain uni, ma i paam taa a naat na ruma baa i tur unaanga nate kup a tena binaboura. Namur i taar taa kumun a wanua na waain taan raa taara na pinapaam kupi diat a babourai, ma i waan kup raa taamaan ingen. ");
INSERT INTO rai_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Baa i marawaai a kalaang baa din git ungaai a waina waain, i tula wa anuna kum tultul karom a taara na pinapaam, kupi diat a lo taa anuna ta kum waina. ");
INSERT INTO rai_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma ra taara na pinapaam diat paam akoto paa anuna kum tultul maa, diat um raa, diat aak doko raa ma raa kaai diat duka doko paai ma ra kum waat. ");
INSERT INTO rai_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","I tula wa balet anuna raa kum tultul, diat mongoro taan diat baa diat muga, iaku a taara na pinapaam diat paami balet ku lenmaa karom diat. ");
INSERT INTO rai_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Namur i tula wa ut natunalik karom diat maa i nuki naa diat a urur un natunalik. ");
INSERT INTO rai_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Iaku baa a taara na pinapaam diat babo paa natunalik diat pirpir ungaai paa naa, ‘Ia ma baa in kiaana tamaana, bari ma ia i waan urin. Muaat iaap, daat a aak dokoi, kupi anundaat ma a wanua na waain.’ ");
INSERT INTO rai_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Io, diat paam akoto paai, diat ong apari wai ko ra wanua na waain, ma diat aak doko wai.” ");
INSERT INTO rai_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Io, Iesu i tiri a taara naa, “Baa tamaa ra wanua na waain maa in waan paat, aawa maa in paami karom a taara na pinapaam maa?” ");
INSERT INTO rai_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Diat baalui naa, “In aak doko raap wa a aakaina taara maa, ma in taar taa anuna wanua na waain karom ta taara na pinapaam ingen, diat baa diat a taar taa anuna ta kum waina karomi u ra kalaang baa din git ungaai a waina waain.” ");
INSERT INTO rai_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu i piri taan diat naa, “Lelawaai, pa muaat luk utbaai duk a pirpir u ra Buk Taabu baa i piri naa, ‘Ina waat maa a kum tena paam ruma diat pilak wai, ia ut maa ina ngaatngaat na waat baa di paam a ruma mai. A utnaa mi a Tadaaru ut ia paam taai, ma i koina aakit u ra numiaat binabo.’ Kele 118:22-23 ");
INSERT INTO rai_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ia kabina maa iaau piri taa muaat naa, din rakaan wa a mataanitu anun God kon muaat, ma din taar taai taa ra taara baa diat a wa a koina waindiat.”  ");
INSERT INTO rai_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Baa te i puka taau u ra ina waat mi, in taginagina, ma te baa ina waat mi in puka dadaaun paai, in taginagina welaar ma ra kabu. ");
INSERT INTO rai_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Baa a kum ngaala na tena wetabaar karom God ma ra kum Parisaaio diat walangoro a kum pirpir welwelaar anun Iesu, diat nunurai ut naa i pirpir ku un diat. ");
INSERT INTO rai_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ma diat baat kup ta aakapi baa diat a paam akotoi uni, iaku diat burutaana a kor na taara, maa a taara diat nurnur uni naa ia a propet. ");
INSERT INTO rai_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu i pirpir balet karom diat ma ra pirpir welwelaar lenbi, ");
INSERT INTO rai_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A mataanitu taanginaanga u ra maawa i welaar ma ra king baa ia waninaar taa a lukaara na paakamaau kup natunalik, a muaana. ");
INSERT INTO rai_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Io, i tula wa nuna kum tultul karom diat baa di aa aaring muga ta diat, kupi diat a ben pa diat kup a lukaara, iaku diat patut raap ku karom a kum tultul. ");
INSERT INTO rai_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","I tula wa bulung anuna raa kum tultul ingen ma ra pirpir lenbi, ‘Muaat a wapua diat baa di aa aaring muga ta diat naa, “Iaau aa waninaar raap taa a utnaa na winangaan. Iaau aa aak doko paa a kum bulumakaau ma a kum naatnaat na tubutubu na bulumakaau, a kum utnaa ia waninaar raap. Muaat a waan urin u ra lukaara na paakamaau.” ’ ");
INSERT INTO rai_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Iaku pa diat taraam, diat waan ingingen ku. Raa i waan kup ana pinapaam, raa kaai kup anuna ruma na wiura. ");
INSERT INTO rai_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma raa taara baa di waan kup diat, diat paam akoto paa ku a kum tultul maa, ma diat baanaakaka diat ma diat aak doko diat. ");
INSERT INTO rai_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A king maa i kaankaan aakit, i tula wa anuna kum taara na wineium, ma diat aak doko wa a kum tena aakaak doko taara maa, ma diat tun wa anundiat taamaan. ");
INSERT INTO rai_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“I piri balet taa ra nuna kum tultul naa, ‘Di aa waninaar taa a lukaara na paakamaau, iaku maa diat baa di aa aaring muga ta diat pa diat takado kupi diat a ki u ra lukaara. ");
INSERT INTO rai_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Muaat a waan u ra kum aakapi ma diat raap baa muaat baraata diat, muaat a aaring diat baa diat a waan urin kup a lukaara.’ ");
INSERT INTO rai_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma ra kum tultul maa diat waan u ra kum aakapi, ma diat ben ungaai diat raap baa diat baraata diat, a kum aakaakaina taara ma ra kum kokoina taara kaai, ma a lukaara na paakamaau i teng ma diat. ");
INSERT INTO rai_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Baa a king i ruk kupi in babo a taara, i babo baraata paa raa muaana baa pa i mong ma tina maalu na lukaara na paakamaau. ");
INSERT INTO rai_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma i tiri naa, ‘Tepaang, u ruk urin lelawaai, maa pa num tina maalu na lukaara na paakamaau?’ Ma pa i babaalu. ");
INSERT INTO rai_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ma a king maa i piri taa ra nuna kum tultul naa, ‘Muaat a do paa a ru kakina ma ra ru limaana ma muaat a ong pari wai unataamaan u ra baboto, matira di taangtaangi ma di karkaraat lakondi iaai.’ ");
INSERT INTO rai_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Maa di aa wataa paa mongoro, iaku di pilak paa maku a kabaanadi.” ");
INSERT INTO rai_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Namur a kum Parisaaio diat waan ungaai taau, ma diat wepaak paa naa diat a walaam paa Iesu kup anuna ta pirpir baa diat a takunai uni. ");
INSERT INTO rai_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Diat tula wa anundiat kum naat na wawer ma ra kum teptepaan Erodes karom Iesu, ma diat piri lenbi, “Tena Wawer, miaat nunurai naa ui a takado na muaana, ma u wer mulu a taara u ra aakapi anun God ma ra lingtatuna. Pa u ngaraa u ra utnaa baa a taara diat piri un ui. Anum wawer i welaar raap ku karom a taara raap. ");
INSERT INTO rai_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Un wapua miaat, aawa maa u nuki? Lelawaai, i takado kupi din taar a tatakom karom a Kaaisaar baa pate?” ");
INSERT INTO rai_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesu i nunurai naa a nuknukindiat i aaka ma i piri taan diat, “A kum tena warwaruga muaat, i lawaai maa muaat nemi naa muaat a walaar iaau? ");
INSERT INTO rai_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Muaat a waiaa iaau un ta maani na tatakom.” Ma diat taar taa raa maani taana. ");
INSERT INTO rai_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Io, i tiri diat naa, “A malalar ma ra timtimu mi uni anun woi?” ");
INSERT INTO rai_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Diat baalui naa, “Anu ra Kaaisaar.” Ma i piri taan diat, “A utnaa baa anu ra Kaaisaar muaat a taari karom a Kaaisaar, ma ra utnaa baa anun God muaat a taari kaai karom God.” ");
INSERT INTO rai_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Baa diat walangoroi diat kakaian, ma diat waan maut koni. ");
INSERT INTO rai_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","U ra bung ut maa a kum Saadukaaio, baa diat weoro ku naa pa ta lalaaun balet ko ra minaat, diat waan karom Iesu, ma diat tiri naa, ");
INSERT INTO rai_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tena Wawer, Moses i piri naa, baa ta muaana in maat paa ko ra nuna tabuan, ma pa ta natundiaar, io, tenalik in ben paai ma in taulaa mai, kupi in wangaala taa ta kum naat liklik u ra iaan tenalik baa ia maat. ");
INSERT INTO rai_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Io, raa naadiwaaina 7 na muaana raap ku diat lalaaun ungaai ma miaat. A mugaana i taulaa, ma i maat ko ra nuna tabuan, ma pa ta natundiaar. ");
INSERT INTO rai_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Io, a weru tenalik bulung i taulaa ma ra tabuan maa, ma ia bulung i maat ku ko ra tabuan maa. Namur a wetuldi bulung. Lenmaa karom 7 diat raap. ");
INSERT INTO rai_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma a tabuan i maat namur taan diat raap. ");
INSERT INTO rai_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Io, u ra lalaaun balet ko ra minaat, anun woi na paan diat mulu a tabuan maa? Maa diat raap diat aa taulaa paa mai.” ");
INSERT INTO rai_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu i piri taan diat naa, “Muaat raara aakit, kabina maa pa muaat nunura a Buk Taabu ma ra dekdekin God kaai. ");
INSERT INTO rai_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","U ra lalaaun balet ko ra minaat, pa diat a taulaa balet, diat a welaar maku ma ra kum aangelo inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Baa muaat weoro naa a kum minaat pa diat a lalaaun balet ko ra minaat, lelawaai, pa muaat luk utbaai a pirpir baa God ia pir taai taa muaat? I piri naa, ");
INSERT INTO rai_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iaau a God anun Aabaraam, a God anun Aaisaak ma a God anun Iaakob.’ Pin 3:6 God wakir a God anu ra kum minaat, a God anu ra kum lalaaunina ut.” ");
INSERT INTO rai_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Baa a kor na taara diat walangoroi, diat kakaian aakit u ra nuna mangaana wawer. ");
INSERT INTO rai_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Baa a kum Parisaaio diat walangoroi naa Iesu ia duka ot paa a kum Saadukaaio, diat waan ungaai karomi. ");
INSERT INTO rai_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma raa paan diat, a tena manaana u ra kum Naagagon, i walaari ma ra wetiri lenbi, ");
INSERT INTO rai_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tena Wawer, woi na naagagon i ngaala taa ra kum Naagagon raap?” ");
INSERT INTO rai_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma i baalui naa, “‘Un maari a Tadaaru anum God ma ra in balaam raap, a niom raap, ma ra nuknukim raap.’ Naag 6:5 ");
INSERT INTO rai_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A naagagon bi i ngaala aakit, ma ia a mugaana naagagon. ");
INSERT INTO rai_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma bari ia a weru naagagon, baa i pot na welaar mai, ‘Un maari tepaam welaar ma u maari ui ut.’ Lewi 19:18 ");
INSERT INTO rai_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A ru naagagon mi diaar a kabi ra kum pirpir na Naagagon raap anun Moses ma ra kum wawer anu ra kum propet.” ");
INSERT INTO rai_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Baa a kum Parisaaio diat ki ungaai, Iesu i tiri diat lenbi, ");
INSERT INTO rai_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Aawa maa muaat nuki un Kaarisito? Ia a natun woi?” Diat baalui naa, “Natun Dewid.” ");
INSERT INTO rai_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iesu i piri taan diat naa, “Baa lenmaa, i lawaai maa a Takado na Nion i mugain Dewid kupi in waatung Kaarisito naa ‘anung Tadaaru’? Maa i piri naa, ");
INSERT INTO rai_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘A Tadaaru i piri karom anung Tadaaru, “Un ki u ra papaara ot na limaang, tuk baa ang uwia paa anum kum ebaar kupi diat a ki natudaangi ra num naagagon.” ’ Kele 110:1 ");
INSERT INTO rai_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Baa Dewid i waatung Kaarisito naa anuna Tadaaru, diaar tamaana lelawaai?” ");
INSERT INTO rai_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma pa te i nuk paa ta pirpir baa in baalui mai. Ma turpaai u ra bung maa, pa te balet ma i waan karomi ma ta wetiri, kabina diat burut. ");
INSERT INTO rai_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Namur Iesu i piri taa ra kor na taara ma ra nuna kum naat na wawer lenbi, ");
INSERT INTO rai_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“A kum tena wawer u ra kum Naagagon ma ra kum Parisaaio diat wer a taara u ra kum Naagagon welaar ma Moses i paami. ");
INSERT INTO rai_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A kum utnaa raap baa diat wer muaat uni muaat a taraam uni, ma muaat a paami. Iaku, koku muaat murmur anundiat mangamangaan, maa diat pir taai ku ma diat ut pa diat paami. ");
INSERT INTO rai_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Diat taar taa a kum dekdek na naagagon kupi a taara diat a murmuri, iaku diat ut, pa diat waraaut diat uni. ");
INSERT INTO rai_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Anundiat kum pinapaam raap diat paami ku kupi a taara diat a babo diat. Muaat laana timu paa a kum pakpakaana Buk Taabu ma muaat waruk taai u ra kum bok liklik ma muaat do paai u ra kum maarimuaat. Iaku baa a kum Parisaaio diat paami, anundiat kum bok liklik i parere. Ma baa diat do a kum kula u ra titi ra nundiat kum maalu, a kula maa i iok aakit taa ra kum taara ingen. ");
INSERT INTO rai_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Diat nem a kinkini na tadaaru namuga u ra kum balaan, ma ra kinkini kaai namuga u ra kum ruma na lotu. ");
INSERT INTO rai_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma diat nemi naa a taara diat a taar a ngaala na urur karom diat u ra kum taamaan na winawaan ungaai, ma diat a waatung diat kaai naa a kum tena wawer. ");
INSERT INTO rai_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Koku di waatung muaat naa a kum tena wawer, maa raa Tena Wawer ku anumuaat, ma muaat a tentena liklik. ");
INSERT INTO rai_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma koku muaat taar tamaamuaat un te taanga main napia, maa raa Tamaamuaat ot ku, baa i ki inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma koku di waatung muaat naa a kum mukmuga, maa raa ku anumuaat mukmuga, Kaarisito ku. ");
INSERT INTO rai_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma ia baa i ngaala taa muaat, in wakinalik paai ma in taraam lu muaat. ");
INSERT INTO rai_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Maa baa te i wangaala paai, din wakinalik paai. Ma ia baa i wakinalik paai, din wangaala paai.” ");
INSERT INTO rai_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Iesu i piri naa, “In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a kum tena warwaruga. Muaat balbalaat baat wa a taara kupi koku diat ruk u ra mataanitu taanginaanga u ra maawa. Muaat ut pa muaat ruk uni, ma pa muaat maadek wa diat baa diat nem na ruk kupi diat a ruk uni. ");
INSERT INTO rai_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a kum tena warwaruga. Muaat waan taltalili nataai ma nabuaal kupi muaat a aal puku te, kupi in murmur anumuaat lalaaun. Ma baa ia taraam, muaat pet taai kupi in kariaana kinadik u ra ngaala na nguan, ma anuna aakaina mangamangaan in ngaala aakit taa ra numuaat aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“In aaka aakit karom muaat a kum pula na mukmuga, maa muaat piri naa, ‘Baa te i weweliman ma ra ruma na wetabaar, ma raa ia pa i dekdek, iaku baa te i weweliman ma ra goled u ra ruma na wetabaar, ma raa ia maa i dekdek aakit.’ ");
INSERT INTO rai_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Muaat a kum longlong na pula muaat. Woi na paan diaar i ngaala? A goled, baa a ruma na wetabaar baa i wagomgom a goled kupi in gomgom namataan God? ");
INSERT INTO rai_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Muaat piri kaai naa, ‘Baa te i weweliman ma ra luwu na tuntun wetabaar, ma raa ia pa i dekdek maa, iaku baa te i weweliman ma ra wetabaar di tuni, ma raa ia maa i dekdek aakit.’ ");
INSERT INTO rai_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Muaat a kum pula muaat! Woi na paan diaar i ngaala? A wetabaar, baa a luwu na tuntun wetabaar baa i wagomgom a wetabaar kupi in gomgom namataan God? ");
INSERT INTO rai_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Baa te i weweliman ma ra luwu na tuntun wetabaar, i weweliman utkaai ma ra kum utnaa raap kuraa uni. ");
INSERT INTO rai_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma baa te i weweliman ma ra ruma na wetabaar i weweliman utkaai ma God baa i ki uni. ");
INSERT INTO rai_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Baa te i weweliman ma ra maawa, i weweliman ut ma ra kiki na king anun God, ma i weweliman utkaai ma ia baa i ki uni. ");
INSERT INTO rai_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a kum tena warwaruga. Muaat nuknuk aakit u ra kum kinkinalik na naagagon lenbi, muaat taar raaraain diwaai ko ra noina naatnaat na diwaai baa i aangawian wakwakaak, iaku pa muaat paam a kum utnaa i ngaala u ra pirpir na naagagon. Bi ia a kum ngaala na utnaa maa: a takado na naagagon ma ra maarmaari karom a taara, ma ra lingtatuna na mangamangaan. I koina baa muaat a paam a kum utnaa maa, ma koku kaai muaat dumaana wa raaraain ko ra noina, kupi muaat a taari karom God. ");
INSERT INTO rai_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Muaat a kum pula na mukmuga! Baa muaat inim, muaat rakaan wa ina laang ko ra kaap, iaku, a kaamel baa i ngaala, muaat inim paai ku! ");
INSERT INTO rai_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a kum tena warwaruga. Muaat gigi paa ku a tamaru ra kaap ma ra pelet, iaku a balaandiaar i teng ma ra walong ma ra mangamangaan baa te i nuk paa ia ut. ");
INSERT INTO rai_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ui a pula na Parisaaio. Un dur amuga paa a balaa ra kaap ma ra pelet, kupi in gomgom kaai a tamarundiaar. ");
INSERT INTO rai_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a kum tena warwaruga. Muaat welaar ma ra kum babaang na minaat baa di pen ta diat. Baa di babo diat taanga nataamaan diat koina, iaku nabalaandiat i teng ma ra kum ur na minaat ma ra kum utnaa raap baa i dur. ");
INSERT INTO rai_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lenkaai maa muaat, a taara diat babo a panimuaat naa muaat a kum tena takado, iaku a balaamuaat i teng ma ra warwaruga ma ra kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, muaat a kum tena warwaruga. Muaat watur a kum aaim naa ra kum babaang na minaat anu ra kum propet, ma muaat wamong a kum tung na minaat anu ra kum tena takado. ");
INSERT INTO rai_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma muaat piri naa, ‘Baa gun miaat aa lalaaun ungaai namuga ma ra kum taptabumiaat, pa miaat a waraaut diat baa diat aak doko a kum propet.’ ");
INSERT INTO rai_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iaku mi muaat wapuaana muaat ut naa, muaat a kum taptabundiat baa diat aak doko a kum propet. ");
INSERT INTO rai_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kuri utbaai muaat paam a kum aakaina mangamangaan baa a kum taptabumuaat diat aa watur taai namuga. ");
INSERT INTO rai_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Muaat a kum wui, muaat a kum natu ra kum wui, muaat a kalaa ino lelawaai ko ra naagagon na binabaalu u ra ngaala na nguan? ");
INSERT INTO rai_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Io, mi ang tula wa a kum propet, a kum tena manaana ma ra kum tena wawer karom muaat. Ta taara kon diat muaat a aak doko diat, ma ta taara muaat a aak waat diat u ra kum bolo, ma ta taara kaai muaat a raapu diat u ra numuaat kum ruma na lotu, ma muaat a lu wa diat ko ra numuaat kum taamtaamaan ma diat a welulu kup a kum taamtaamaan ingen. ");
INSERT INTO rai_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Io, din taar a naagagon na binabaalu karom muaat, u ra gaapi ra kum tena takado raap baa di aa aak doko wa diat. Turpaai baa di aak doko Aabel a tena takado, ma i waan tuk baa di aak doko Saakaria natun Baarakia, ia baa muaat aak dokoi naliwan naa ra luwu na tuntun wetabaar ma ra pakaana baa i Taabu naruma u ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iaau pir a lingtatuna taa muaat, din taar a naagagon na binabaalu karom a taaun taara mi u ra kum utnaa raap mi. ");
INSERT INTO rai_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalem, Ierusalem, ui baa u aakaak doko a kum propet, ma diat baa di tultula wa diat karom ui u duka doko wa diat ku ma ra kum waat. Mongoro na pakaan iaau nem na burung baat ungaai a kum natnatum welaar ma ra kareke baa i burung baat ungaai a kum natnatuna natudaangi ra ru bibiaana, iaku pa muaat nemi. ");
INSERT INTO rai_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Baboi! God ia waan ko ra numuaat taamaan. ");
INSERT INTO rai_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Maa iaau piri taa muaat, pa muaat a babo iaau balet ma tuk u ra bung baa muaat a piri naa, ‘Daat a pir walaawa paa ia baa i waan paat u ra iaa ra Tadaaru.’” Kele 118:26 ");
INSERT INTO rai_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu i pari ko ra ruma na wetabaar, ma baa i waan waanwaan anuna kum naat na wawer diat waan karomi ma diat waiaai u ra kum ruma naa ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma i piri taan diat, “Muaat babo a kum ruma raap mi naka? Iaau pir a lingtatuna taa muaat, kuraa mun pa ta ruina waat ma diaar a inep ungaai, din reng ginagina raap wa diat.” ");
INSERT INTO rai_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Baa Iesu i ki inaanga nate u ra Taangaai na Oliwa, a kum naat na wawer diat waan paat ino karomi, ma diat piri taana naa, “Un wapua miaat, unaangaian a kum utnaa mi in waan paat? Ma aawa a wakilang i ra num winawaan talili balet ma ra wakilang i ra tintinip i ra rakrakaan buaal?” ");
INSERT INTO rai_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu i baalu diat naa, “Muaat a baboura muaat, kaduk te in waruga pa muaat. ");
INSERT INTO rai_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Maa ta mongoro diat a waan paat ma ra iaang, diat a piri naa, ‘Iaau maa Kaarisito,’ ma diat a waruga paa ta mongoro. ");
INSERT INTO rai_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma muaat a walangoro a kum wineium ma ra wewapua un diat, iaku koku muaat ngaraa, maa a kum utnaa mi diat a waan paat muga, iaku a tintinip na bung pa in waan paat utbaai. ");
INSERT INTO rai_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Raa wuna taara in tur na wineium kup raa wuna taara, ma raa mataanitu in tur na wineium kup raa mataanitu. Ma a kum minolo ma ra kum guria in waan paat u ra kum taamtaamaan. ");
INSERT INTO rai_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A kum utnaa raap mi i welaar ma ra ngunungut na binabuta baa a tabuan i turpaai kupi in kariaanai. ");
INSERT INTO rai_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kuraa mun din taar ta muaat kupi din baanaakaka muaat ma din aak doko muaat, ma a kum wuna taara raap diat a milikuaana muaat kabina u ra iaang. ");
INSERT INTO rai_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma mongoro diat a waan ingen ko ra nurnur, diat a wagu wetwetalaai diat ma diat a nget wetwetalaai diat. ");
INSERT INTO rai_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mongoro na warwaruga na propet kaai diat a waan paat, ma diat a waruga paa ta mongoro. ");
INSERT INTO rai_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A maarmaari anun ta mongoro in raap, kabina maa a kum aakaina mangamangaan in ngaala aakit ma. ");
INSERT INTO rai_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iaku te baa in tur dekdek tuk u ra tintinipina, God in walaaun paai. ");
INSERT INTO rai_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Din warawaai ma ra Koina Wewapua u ra rakrakaan buaal raap kupi a pirpir kaapa in waan karom a kum wuna taara raap, ma a tintinip na bung in waan paat maraagaam. ");
INSERT INTO rai_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Muaat a babo raa aakaina utnaa aakit in waan paat, in tur u ra gomgom na ruma anun God ma in baana dur a ruma maa. A utnaa maa Daaniel a propet ia pirpir muga taau uni namuga utbaai. Ia baa in luk a kum pirpir mi, i koina baa in manaana uni. ");
INSERT INTO rai_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Io, u ra bung maa, diat baa diat ki u ra papaar Iudaia, diat a kalaa ino unaanga u ra kum taangaai. ");
INSERT INTO rai_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma baa te i ki nate u ra nuna ruma, baa in kaa pari, koku i ruk kupi in lo paa ta utnaa taanga naruma. ");
INSERT INTO rai_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma baa te i ki nabuaal, koku balet ma i waan talili unataamaan kup anuna maalu na minong. ");
INSERT INTO rai_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","U ra pakaana bung maa in aaka aakit karom a kum kipbaala, ma karom diat kaai baa diat wangaau a kum naat. ");
INSERT INTO rai_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Muaat a aaraaring kupi koku muaat welulu ong u ra kum kalaang na madiring, baa u ra Bung Saabaat. ");
INSERT INTO rai_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maa u ra kum bungbung maa, in ngaala aakit a kinadik. In ngaala aakit taa ra kum kinadik baa i laana waan paat u ra rakrakaan buaal. Turpaai u ra turpaai ra rakrakaan buaal, tuk mi ma namur kaai pa ta kinadik in welaar mai. ");
INSERT INTO rai_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Baa gun God pa in kutu pari a kum bungbung maa, pa te maut in lalaaun. Iaku in kutu pari wai kupi diat baa ia pilak pa diat, diat a lalaaun. ");
INSERT INTO rai_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“U ra pakaana bung maa, baa te in piri karom muaat naa, ‘Kaarisito bari ia,’ baa ‘Barong ia,’ koku muaat nurnur uni. ");
INSERT INTO rai_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maa ta kum warwaruga na Kaarisito, ma ta kum warwaruga na propet diat a waan paat, ma diat a paam ta kum ngaala na wakilang ma ta kum utnaa na kakaian kupi diat a waruga a taara. Diat a waruga utkaai a taara na pipilak, baa gun diat a pet laar pa diat. ");
INSERT INTO rai_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Baboi, mi iaau aa wapua muga ta muaat uni. ");
INSERT INTO rai_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Baa diat a piri taa muaat naa, ‘Kuraa i ki u ra bil na wanua,’ koku muaat waan kupi, ma baa diat a piri kaai naa, ‘Kuri naruma,’ koku muaat nurnur uni. ");
INSERT INTO rai_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Maa u ra bung na winawaan paat anu ra Natu ra Muaana, a taara raap diat a baboi. In welaar ma in mamame, baa i papalaa taanga u ra mataana taubaar, tuk u ra mataana labur. ");
INSERT INTO rai_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A wanua baa a minaat i inep iaai, a kum kotkot diat a waan ungaai iaai. ");
INSERT INTO rai_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Baa ia raap a kum kinadik u ra kum bungbung maa, ‘in mataana mage in baboto, a kalaang pa in baara, a kum naangnaang diat a puka pari taanginaanga u ra baakut, ma ra kum utnaa inaanga nate u ra baakut diat a dadader.’ Aais 13:10; 34:4 ");
INSERT INTO rai_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ma u ra bung maa a wakilang i ra Natu ra Muaana in waan paat u ra baakut, ma a wunwuna taara raap u ra rakrakaan buaal diat a kulkulaai ma ra tapunuk. Ma diat a babo Natu ra Muaana in waan paat nate u ra kum baakut, ma ra dekdek ma ra ngaala na minamaar. ");
INSERT INTO rai_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","In tawuru in taangi ma Natu ra Muaana in tula pari wa anuna kum aangelo, ma diat a ben ungaai anuna taara na pipilak ko ra waat na mataana dadaip, kon raa papaara rakrakaan buaal tuk urong kaai un raa papaara rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Muaat a wawer ko ra in diwaai na fig. Baa a kum gagagaana in kiok balet ma a dondono in tapalaa, muaat nunurai naa a kum kalaang na wuwan ia marawaai. ");
INSERT INTO rai_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lenkaai maa, baa muaat babo a kum utnaa baa iaau pirpir taau uni in waan paat, muaat a nunurai naa a pakaana bung ia marawaai. ");
INSERT INTO rai_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iaau pir a lingtatuna taa muaat, a kum utnaa raap mi in waan paat baa a taaun taara mi diat lalaaun utbaai. ");
INSERT INTO rai_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A maawa ma ra rakrakaan buaal diaar a panaai, iaku maa anung kum pirpir pa in panaai. ");
INSERT INTO rai_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pa te i nunura a bung ma ra pakaana bung. A kum aangelo inaanga u ra maawa pa diat nunurai, ma Natuna kaai pa i nunurai, Tamaana ku i nunurai. ");
INSERT INTO rai_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A winawaan paat balet anu ra Natu ra Muaana in welaar ma ra kum bungbung anun Noaa. ");
INSERT INTO rai_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","U ra kum bungbung baa ina ngaala na baata pa i waan paat utbaai, diat wangwangaan, diat ininim, ma diat wataulaa diat, tuk u ra bung baa Noaa i kaa u ra paraau. ");
INSERT INTO rai_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma pa diat nunurai naa ta utnaa in waan paat, tuk u ra bung baa a ngaala na baata i waan paat, ma i lo araap wa diat. In lenkaai maa u ra winawaan paat balet anu ra Natu ra Muaana. ");
INSERT INTO rai_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","U ra bung maa baa ta ru muaana diaar papaam nabuaal, din lo paa ku ta paan diaar, ma raa paan diaar painte. ");
INSERT INTO rai_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Baa ta ru tabuan kaai diaar gina wit ungaai, din lo paa ku ta paan diaar, ma raa paan diaar painte. ");
INSERT INTO rai_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Io, muaat a baboura muaat, maa pa muaat nunura a bung baa anumuaat Tadaaru in waan paat uni. ");
INSERT INTO rai_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Muaat a manaana kup a utnaa bi: Baa a tamaa ra ruma i nunura a pakaana bung u ra marum baa a tena walong in waan paat uni, io, in ki na baboura. Pa in maadek wa nuna ruma kupi din walongi. ");
INSERT INTO rai_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Io, muaat kaai, muaat a ki na waninaar, maa Natu ra Muaana in waan paat u ra pakaana bung baa pa muaat nuki naa in waan paat uni. ");
INSERT INTO rai_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Woi na tultul i dowot u ra nuna pinapaam ma i manaana kaai? A tultul maa, anuna tadaaru i waki taai kupi in tena naagagon u ra nuna ruma, ma in taptabaara a kum tultul kaai ma andiat utnaa na winangaan u ra kum pakaana bung na winangaan. ");
INSERT INTO rai_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A tultul maa in daan baa anuna tadaaru in waan paat ma in baboi baa i paam ot paa a kum utnaa. ");
INSERT INTO rai_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iaau pir a lingtatuna taa muaat, anuna tadaaru in taar taa a naagagon taana kupi in tena naagagon u ra nuna kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iaku baa a tultul maa, a aakaina tultul, ma i nuki naa anuna tadaaru pa in waan paat gagaa, ");
INSERT INTO rai_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","io, i turpaai kupi in um a kum tultul baa diat papaam ungaai mai. Ma i wangaan ma i inim ungaai ma ra kum tena ininim. ");
INSERT INTO rai_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Anuna tadaaru in waan paat un ta bung baa ta pakaana bung baa a tultul maa pa i nunurai ma pa i nuki naa in waan paat uni. ");
INSERT INTO rai_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Io, a tadaaru maa in bur kutkutui, ma in taar taa a naagagon na binabaalu karomi kupi in ki ungaai ma ra kum tena warwaruga, u ra wanua baa di taangtaangi, ma di karkaraat lakondi iaai. ");
INSERT INTO rai_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“U ra pakaana bung maa a mataanitu taanginaanga u ra maawa in welaar ma 10 tauraara, baa diat lo paa anundiat kum laam, ma diat waan kupi diat a baraata a matakina tinaulaa. ");
INSERT INTO rai_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Limadi kon diat diat manaana, ma limadi pa diat manaana. ");
INSERT INTO rai_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Diat baa pa diat manaana diat lo anundiat kum laam, iaku pa diat lo kalongo diat ma ta kum palaa na wel kaai. ");
INSERT INTO rai_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Diat baa diat manaana diat lo anundiat kum laam ma diat lo kalongo diat utkaai ma ra kum palaa na wel. ");
INSERT INTO rai_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Baa a matakina tinaulaa pa i waan paat gagaa, a mataandiat i uwaaia, ma diat inep duman raap. ");
INSERT INTO rai_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Io, u ra ngaala na marum di wewataai naa, ‘Ua, a matakina tinaulaa ma! Muaat iaap, muaat a baraatai.’ ");
INSERT INTO rai_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A kum tauraara raap diat tur ma diat waninaar anundiat kum laam. ");
INSERT INTO rai_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Diat baa pa diat manaana diat aaring a kum manaana na tauraara naa, ‘Muaat a tabaara miaat ma ta lik wel, maa anumiaat kum laam diat pot na maat ma.’ ");
INSERT INTO rai_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Diat baa diat manaana diat baalu diat naa, ‘Pate, kaduk pa in welaar ma daat raap. Muaat a waan karom diat baa diat wiura wel ma muaat a kukul paa.’ ");
INSERT INTO rai_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Baa diat waan kupi diat a kukul, a matakina tinaulaa i waan paat. Ma limadi diat baa diat aa waninaar, diat weur mai kup a lukaara na tinaulaa, ma di balbalaat baat a bonanaaka. ");
INSERT INTO rai_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Namur limadi baa pa diat manaana diat waan paat, ma diat wewataai naa, ‘Tadaaru, tadaaru, un paapa aara miaat.’ ");
INSERT INTO rai_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma i baalu diat naa, ‘Iaau pir a lingtatuna taa muaat naa pa iaau nunura muaat.’ ");
INSERT INTO rai_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Lenmaa, muaat a baboura muaat, maa pa muaat nunura a bung baa a pakaana bung a Tadaaru in waan paat uni. ");
INSERT INTO rai_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A mataanitu taanginaanga u ra maawa i welaar utkaai ma raa muaana baa i waninaar kupi in waan kup raa taamaan ingen. I wataa paa anuna tula tultul, ma i weraana taa anuna kum wuwuwung taan ditul kupi ditul a papaam mai. ");
INSERT INTO rai_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I taar taa 5,000 na kina taan raa, ma 2,000 na kina taan raa, ma 1,000 na kina kaai taan raa. I taar taai karom ditul raaraa welaar ut ma anunditul manaana. Io, namur i waan u ra nuna winawaan. ");
INSERT INTO rai_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ia baa di taar taa 5,000 na kina taana, i waan gagaa ma i papaam mai, ma i wapipia paa balet 5,000 na kina koni. ");
INSERT INTO rai_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lenkaai maa karom ia baa di taar taa 2,000 na kina taana, i wapipia paa balet 2,000 na kina koni. ");
INSERT INTO rai_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iaku, ia baa di taar taa 1,000 na kina taana i waan, i kil paa a tung, ma i punang ino taa a maani anu ra nuna tadaaru. ");
INSERT INTO rai_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Baa a tadaaru anu ra tula tultul maa ia ki ingen iwan paa, i waan paat ma i watakado anuna maani ungaai ma ra nuna tula tultul. ");
INSERT INTO rai_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ia baa di taar taa 5,000 na kina taana i waan karomi ma 5,000 balet, ma i piri taana naa, ‘Tadaaru, u taar taa 5,000 na kina taang. Baboi, iaau aa paam apaat paa 5,000 balet koni.’ ");
INSERT INTO rai_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Anuna tadaaru i piri taana naa, ‘Wakaak aakit, ui a koina tultul, u dowot u ra num pinapaam. Ang ung ta ui kupi un naagagon ta mongoro na utnaa, kabina maa u dowot u ra kinalik na utnaa mi. Ma mi daar a waan ma daar a gaaia ungaai.’ ");
INSERT INTO rai_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ia baa di taar taa 2,000 na kina taana i waan karomi, ma i piri naa, ‘Tadaaru u taar taa 2,000 na kina taang. Baboi, iaau aa paam apaat paa 2,000 balet koni.’ ");
INSERT INTO rai_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Anuna tadaaru i piri taana naa, ‘Wakaak aakit, ui a koina tultul, u dowot u ra num pinapaam. Ang ung ta ui kupi un naagagon ta mongoro na utnaa, kabina maa u dowot u ra kinalik na utnaa mi. Ma mi daar a waan ma daar a gaaia ungaai.’ ");
INSERT INTO rai_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Namur, ia baa di taar taa 1,000 na kina taana i waan karomi, ma i piri taana naa, ‘Tadaaru, iaau nunurai naa ui a dekdek na tena naagagon. U tangaa paa a utnaa baa pa u maarut taai, ma u git paa a wai ra utnaa baa pa u maarut taai. ");
INSERT INTO rai_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iaau burutaana ui, io, iaau waan ma iaau punang ino taa anum maani. Bari balet ma ia anum maani.’ ");
INSERT INTO rai_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Anuna tadaaru i piri taana naa, ‘Ui a aakaina tultul, a malawo na muaana pi ui. U aa nunurai naa iaau tangaa a utnaa baa pa iaau maarut taai, ma iaau git a wai ra utnaa baa pa iaau maarut taai. ");
INSERT INTO rai_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","I lawaai maa pa u ung taa anung maani u ra beng kupi baa ang waan paat, ang lo paa anung maani ma ta wawaturina kaai? ");
INSERT INTO rai_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Muaat a lo wa a maani koni, ma muaat a taar taai karom ia baa anuna 10,000 na kina. ");
INSERT INTO rai_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Maa ia baa i paam akoto a ngaala, din tabaarai balet kupi anuna utnaa in ngaala, ma ia baa pa i paam akoto ta utnaa, din rakaan wa anuna kinalik na utnaa koni. ");
INSERT INTO rai_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma muaat a ong pari wa a malawo na tultul bi u ra baboto, a wanua baa di taangtaangi ma di karkaraat lakondi iaai.’ ");
INSERT INTO rai_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Baa Natu ra Muaana in waan paat ma ra nuna minamaar, ungaai ma ra nuna kum aangelo, in ki u ra nuna kiki na king. A kiki baa a ngaala na minamaarina. ");
INSERT INTO rai_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A kum wunwuna taara raap u ra rakrakaan buaal diat a waan ungaai namataana, ma in weraana diat, welaar ma ra tena baboura sip i weraana a kum sip ko ra kum me. ");
INSERT INTO rai_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In tula a kum sip kup a papaara ot na limaana, ma ra kum me kup a papaara maira. ");
INSERT INTO rai_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A king in piri taan diat u ra papaara ot na limaana naa, ‘Muaat waan urin, muaat baa Tamaang ia pir wadaan ta muaat. Muaat a kale paa a mataanitu di aa waninaar taai kupi anumuaat, taanga namnamuga utbaai u ra turpaai ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maa baa iaau molo muaat tabaara iaau, baa iaau maruk muaat wainim iaau, baa iaau waira muaat ben aruk iaau u ra numuaat ruma. ");
INSERT INTO rai_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Baa pa nung tina maalu muaat wagop iaau, baa iaau malaapaang muaat baboura iaau, ma baa iaau ki u ra ruma na karabus muaat lauma iaau.’ ");
INSERT INTO rai_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“A kum tena takodo diat a wetiri naa, ‘Tadaaru, naangaian miaat babo ui baa u molo ma miaat tabaara ui, baa u maruk ma miaat wainim ui? ");
INSERT INTO rai_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naangaian miaat babo ui baa u waira ma miaat ben aruk ui u ra ruma, baa pa num tina maalu ma miaat wagop ui? ");
INSERT INTO rai_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naangaian miaat babo ui baa u malaapaang, baa u ki u ra ruma na karabus, ma miaat lauma ui?’ ");
INSERT INTO rai_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“A king in baalu diat naa, ‘Iaau pir a lingtatuna taa muaat, baa muaat aa paam taai karom ta muaana biaa ku ko ra kum tateng liklik bi, muaat aa paam taai ut un iaau maa.’ ");
INSERT INTO rai_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“In piri bulung karom diat u ra papaara maira na limaana naa, ‘Muaat a waan ingen kon iaau. A dekdek i ra naagagon na binabaalu ia ki un muaat. Muaat a waan u ra ngaala na nguan baa pa in maat, baa di aa waninaar taai kup Saataan ma anuna kum aangelo. ");
INSERT INTO rai_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maa kabina baa iaau molo pa muaat tabaara iaau, baa iaau maruk pa muaat wainim iaau. ");
INSERT INTO rai_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Baa iaau waira pa muaat ben aruk iaau u ra numuaat ruma, baa pa nung tina maalu pa muaat wagop iaau, baa iaau malaapaang ma baa iaau ki u ra ruma na karabus pa muaat waraaut iaau.’ ");
INSERT INTO rai_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Diat bulung diat a tiri naa, ‘Tadaaru, naangaian miaat babo ui baa u molo, baa u maruk, baa u waira, baa pa num tina maalu, baa u malaapaang, baa u ki u ra ruma na karabus, ma pa miaat waraaut ui?’ ");
INSERT INTO rai_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“In baalu diat naa, ‘Iaau pir a lingtatuna taa muaat, baa pa muaat paam taai karom ta muaana biaa ku, pa muaat paami kaai karom iaau.’ ");
INSERT INTO rai_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Io, diat a waan kup a naagagon na kinadik takum baa pa in raap. Iaku a kum tena takado diat a waan kup a lalaaun takum baa pa in raap.” ");
INSERT INTO rai_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Baa Iesu ia pir araap taa a kum pirpir mi, i wapua anuna kum naat na wawer lenbi, ");
INSERT INTO rai_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Muaat nunurai ut baa ru bung in raap din turpaa a lukaara na waan likaai, ma din taar taa Natu ra Muaana kupi din aak waati u ra bolo.” ");
INSERT INTO rai_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","U ra pakaana bung ut maa a kum ngaala na tena wetabaar karom God ma ra kum mukmuga anu ra taara, diat ki ungaai u ra ngaala na ruma anun Kaaiapaas, a mukmuga na tena wetabaar. ");
INSERT INTO rai_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Diat pirpir ungaai kupi diat a paam akoto ino paa Iesu, ma diat a aak dokoi. ");
INSERT INTO rai_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Diat piri naa, “Koku daat paami u ra lukaara, kaduk a taara diat a paam ta purpuruan.” ");
INSERT INTO rai_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Baa Iesu i ki utbaai irong Betaania, u ra ruma anun Simon, ia baa namuga i malaapaang ma ra wukawuka, ");
INSERT INTO rai_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","raa tabuan i waan karomi ma ra polo na mangingi. I ngaatngaat aakit, ma i taana u ra in palaa baa di paami ko ra waat. I laboi u ra in lorin Iesu, baa i ki u ra winangaan. ");
INSERT INTO rai_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Baa a kum naat na wawer diat baboi, diat kaankaan aakit uni ma diat piri naa, “Kup aawa maa di labo biaa wa ku a polo na mangingi mi? ");
INSERT INTO rai_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","I lawaai maa pa di wiura paai kup ta ngaala na maani baa din tabaara kum iba na taara mai?” ");
INSERT INTO rai_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu ia nunura aawa maa diat pirpir uni, io i piri taan diat naa, “I lawaai maa muaat watapunuk a tabuan mi? Ia paam taa a koina pinapaam aakit un iaau. ");
INSERT INTO rai_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A kum iba na taara diat lalaaun ungaai ut ma muaat. Iaku iaau, pang ki takum naa muaat. ");
INSERT INTO rai_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ia labo taa a polo na mangingi bi u ra paning kupi in waninaar iaau kup anung bung na minaat. ");
INSERT INTO rai_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iaau pir a lingtatuna taa muaat, u ra kum taamtaamaan u ra rakrakaan buaal, baa din warawaai ma ra Koina Wewapua iaai, din wewapua utkaai u ra utnaa bi a tabuan mi ia paam taai, kupi a iaana in tur na aaim.” ");
INSERT INTO rai_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iudaas Iskaariot, raa ko ra 12 naat na wawer, i waan karom a kum ngaala na tena wetabaar karom God. ");
INSERT INTO rai_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma i piri taan diat naa, “Baa ang wagu taa Iesu karom muaat, aawa muaat a dok iaau mai?” Ma diat taar taa 30 pakaana silwa taana. ");
INSERT INTO rai_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Turpaai u ra bung maa i nuknuk kup ta koina pakaana bung baa in wagu taa Iesu karom diat. ");
INSERT INTO rai_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","U ra mugaana bung u ra lukaara na bred baa pa ta is uni, a kum naat na wawer diat waan karom Iesu, ma diat tiri naa, “U nemi naa miaat a waan uwaai, kupi miaat a waninaar andaat utnaa kup a lukaara na waan likaai?” ");
INSERT INTO rai_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma i piri taan diat naa, “Muaat a ruk unaanga Ierusalem, muaat a baraata raa muaana, ma muaat a piri taana naa, ‘A Tena Wawer i piri naa: Anung bung ia marawaai. Miaat ma ra nung kum naat na wawer miaat a wakilang a lukaara na waan likaai kumun u ra num ruma.’” ");
INSERT INTO rai_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A kum naat na wawer diat paami ut lenmaa Iesu ia pir taai taan diat, ma diat waninaar a utnaa na waan likaai. ");
INSERT INTO rai_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Baa ia maluraap, Iesu ma anuna 12 naat na wawer diat ki u ra winangaan. ");
INSERT INTO rai_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Baa diat wangaan, i piri taan diat naa, “Iaau pir a lingtatuna taa muaat, raa kon muaat in wagu ta iaau.” ");
INSERT INTO rai_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ma diat tapunuk aakit, diat raap raaraa diat tiri naa, “Tadaaru, wakir iaau duk?” ");
INSERT INTO rai_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu i piri taan diat naa, “Ia baa mir puk ungaai amaamir ru bred u ra dis, ia ut maa in wagu ta iaau. ");
INSERT INTO rai_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Natu ra Muaana in wirua welaar ma di aa timu taai u ra Buk Taabu. Iaku in aaka aakit karom a muaana baa in wagu taai karom a kum ebaar. In koina aakit baa gun pa din butai, kupi koku i kariaana a naagagon maa karomi.” ");
INSERT INTO rai_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iudaas, ia baa in wagu taai, i tiri naa, “Tena wawer, wakir iaau duk?” I baalui naa, “Io, ui ut u aa pir paai un ui.” ");
INSERT INTO rai_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Baa diat wangaan utbaai, Iesu i lo paa a bred, i waatung wakaak paa uni, i bik paai, ma i tabaara anuna kum naat na wawer mai. I piri naa, “Muaat a rakaan paai ma muaat a aani. Bi ia a paning.” ");
INSERT INTO rai_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Namur i lo paa a kaap, i waatung wakaak paa uni ma i taari taan diat. I piri naa, “Muaat raap muaat a inim koni. ");
INSERT INTO rai_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bi ia a gaaping, a kunubu baa i aal ungaai taa God ma ra taara. A gaaping mi i talabo, kupi in una wa a kum aakaina mangamangaan anu ra mongoro. ");
INSERT INTO rai_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iaau piri taa muaat naa, pang inim balet ma ta waain, tuk baa daat a inim a matakina waain u ra mataanitu anun Tamaang.” ");
INSERT INTO rai_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Io, baa diat aa kelekele paa, diat waan tato unaanga u ra Taangaai na Oliwa. ");
INSERT INTO rai_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iesu i piri taan diat naa, “U ra bung na marum ut mi muaat raap muaat a waan paa ku kon iaau, kabina u ra kum utnaa baa in waan paat un iaau. Maa di aa timu taai u ra Buk Taabu naa, God i piri naa, ‘Ang um a tena baboura sip, ma a liur na sip diat a welulu werweraan.’ Saak 13:7 ");
INSERT INTO rai_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Iaku baa iaau aa tur balet ko ra minaat, ang muga urong Gaalilaia.” ");
INSERT INTO rai_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero i piri taana naa, “Baa diat raap diat a waan paa kon ui, iaau painte.” ");
INSERT INTO rai_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu i piri taana naa, “Iaau pir a lingtatuna taam, umari u ra marum, baa a kareke pa in kurkurekatuk utbaai, un weoro tula pakaan naa pa u nunura iaau.” ");
INSERT INTO rai_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petero i piri taana naa, “Pang weoro kon ui. In koina ku baa daar raap daar a ora wirua.” A kum naat na wawer raap kaai diat piri ut lenmaa. ");
INSERT INTO rai_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu ma ra nuna kum naat na wawer diat waan paat u ra wanua a iaana Getsemaane, ma i piri taan diat naa, “Muaat a ki ku min, ma iaau ang waan kinalik taau urong, ma ang aaraaring paa.” ");
INSERT INTO rai_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Io, i ben paa Petero ma ra ru natun Sebedaaio. U ra pakaana bung maa i tapunuk ma i mawaat aakit a nuknukina. ");
INSERT INTO rai_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","I piri taan ditul naa, “Anung lalaaun i mawaat aakit ma ra tapunuk, marawaai ma ang maat mai. Mutul a ki ut min, mutul a baboura ungaai ma iaau.” ");
INSERT INTO rai_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I waan kinalik taau unamuga, i puka papaabum taau unapia, ma i aaraaring naa, “Tamaang, un lo wa a ngunungut na minaat kon iaau, baa gun in koina lenmaa. Iaku koku di murmur anung nemnem, din murmur ut anum nemnem.” ");
INSERT INTO rai_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Baa i waan talili karom a tula naat na wawer, i babo ditul ditul aa inep duman. I tiri Petero naa, “Lelawaai, pa mutul a pet laar paai kupi mutul a baboura ungaai ma iaau ta kinalik na pakaana bung ku? ");
INSERT INTO rai_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mutul a baboura, ma mutul a aaraaring, kupi koku mutul puka u ra walwalaam. A niomutul i nem na taraam, iaku a panimutul i bilua.” ");
INSERT INTO rai_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ma a weru pakaan balet i waan kon ditul, ma i aaraaring naa, “Tamaang, baa pa i koina kupi un lo wa a ngunungut na minaat mi kon iaau, i koina ku baa ang kariaanai, maa din murmur ut anum nemnem.” ");
INSERT INTO rai_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Baa i waan talili balet, i babo ditul baa ditul aa inep duman balet, kabina a mataanditul i uwaaia aakit. ");
INSERT INTO rai_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Io, i waan balet kon ditul, i wetula pakaan ma ra niaaring, ma i pir balet a niaaring baa ia waatung taai mun. ");
INSERT INTO rai_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baa i waan talili balet karom a tula naat na wawer, i piri taan ditul naa, “Mutul a inep liklik maku? Baboi, a pakaana bung i marawaai aakit, baa din wagu taa Natu ra Muaana ma din taar taai u ra limaa ra kum tena aakaina. ");
INSERT INTO rai_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mutul tur, daat a waan! Baboi, a muaana baa in wagu ta iaau bari ma ia.” ");
INSERT INTO rai_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Baa Iesu i pirpir utbaai, Iudaas, raa ko ra 12 naat na wawer, i waan paat, diat ma ra kor na taara. Diat lo a kum liwan na wineium ma ra kum pakaana naalnaal. A kum ngaala na tena wetabaar karom God ma ra kum mukmuga anu ra taara diat tula wa diat. ");
INSERT INTO rai_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ia baa in wagu taa Iesu ia wapua muga taa a kor na taara u ra wakilang baa in paami un Iesu naa, “Ia baa ang dum a papaara waana, ia ut maa. Muaat a paam akoto paai.” ");
INSERT INTO rai_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Io, Iudaas i waan maut karom Iesu ma i piri naa, “Koina marum, Tena Wawer!” Ma i dum a papaara waana. ");
INSERT INTO rai_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu i piri taana naa, “Tepaang, un paam ku a utnaa maa u waan kupi urin.” Ma a taara maa diat waan karom Iesu, diat paam akoto paai ma diat aal paai. ");
INSERT INTO rai_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Raa kon diat baa diat weur ma Iesu, i aalum paa anuna in liwan na wineium, ma i pakaat a tultul anu ra mukmuga na tena wetabaar karom God, ma i kutu wa in talingaana. ");
INSERT INTO rai_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu i piri taana naa, “Waruk balet anum in liwan u ra baana, maa diat raap baa diat papakaat ma ra kum liwan na wineium, diat a wirua ma ra kum liwan na wineium. ");
INSERT INTO rai_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lelawaai, u nuki naa i dekdek karom iaau baa ang aaring Tamaang, ma mi ut ku in tula wa ta 12 ngaalangaala na kikil na aangelo ma ta kum aangelo balet karom iaau? ");
INSERT INTO rai_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Iaku, baa ang paami lenmaa, pa din paam ot paa a kum pirpir na Buk Taabu u ra kum utnaa mi baa i ot kupi din paami un iaau.” ");
INSERT INTO rai_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","U ra pakaana bung maa, Iesu i piri taa ra kor na taara naa, “Lelawaai, iaau duk a ngaala na tena pet apurpuruan, maa mi muaat waan paat ma ra kum liwan na wineium ma ra kum pakpakaana naalnaal kupi muaat a paam akoto iaau? U ra kum bungbung raap iaau kiki u ra ruma na wetabaar, iaau laana wer a taara, ma pa muaat aal iaau. ");
INSERT INTO rai_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","A kum utnaa raap i waan paat lenmi kupi din paam ot paa a kum timtimu anu ra kum propet.” Namur anuna kum naat na wawer raap diat welulu weraan paa koni. ");
INSERT INTO rai_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Io, diat baa diat aa paam akoto paa Iesu, diat beni kup a ruma anun Kaaiapaas a mukmuga na tena wetabaar karom God. Ma a kum tena wawer u ra kum Naagagon ma ra kum mukmuga kuraa diat aa ki ungaai. ");
INSERT INTO rai_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petero i murmur waanawaana Iesu, iaku maa i welwelik ut, tuk u ra pakaana anu ra mukmuga na tena wetabaar karom God. I ruk u ra wanua maa, ma i ki ungaai ma ra kum tena baboura kupi in babo aawa maa din paami un Iesu. ");
INSERT INTO rai_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A kum ngaala na tena wetabaar karom God ma ra taara na kiwung raap, diat baat kup ta warwaruga na pirpir un Iesu, kupi diat a takunai mai, ma diat a aak dokoi uni. ");
INSERT INTO rai_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mongoro na tena warwaruga diat waan paat, iaku maa pa diat baat laar paa ta utnaa baa diat a takunai mai. Raa rudi baa diaar waan paat namur, ");
INSERT INTO rai_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","diaar piri naa, “A muaana mi i piri naa, ‘Ang reng wa a ruma na wetabaar mi anun God, ma ang paam paai balet ku un ta tula bung.’” ");
INSERT INTO rai_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A mukmuga na tena wetabaar karom God i tur ma i tiri Iesu naa, “Lelawaai, pa un baalu a kum pirpir na wetakun mi karom ui?” ");
INSERT INTO rai_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iaku Iesu pa i pirpir. A tena wetabaar maa i piri taana naa, “U ra iaan God, a lalaaunina, un wapua miaat baa ui Kaarisito a Natun God, baa pate.” ");
INSERT INTO rai_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu i piri taana naa, “Ma raa ut ia u aa piri. Ma mi iaau piri taa muaat naa, turpaai mi, Natu ra Muaana in ki u ra papaara ot na limaan God, ia baa i dekdek aakit, ma namur muaat a baboi baa in waan paat nate u ra kum baakut taanginaanga u ra maawa.” ");
INSERT INTO rai_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A mukmuga na tena wetabaar i kaankaan ma i aal rabaana anuna ina maalu ut, ma i piri naa, “Ia pir aakaka God mi. Daat nem balet ma ta pirpir na wetakun kup aawa? Muaat aa walangoro taa anuna pirpir aakaka un God. ");
INSERT INTO rai_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aawa muaat nuki?” Ma diat baalui naa, “I koina baa in wirua.” ");
INSERT INTO rai_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ma diat kamia a mataana, ma diat tibuli, ma raa taara diat paari, ");
INSERT INTO rai_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma diat piri naa, “Kaarisito, ui a propet, un wapua miaat, woi maa i tibul ui.” ");
INSERT INTO rai_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Baa Petero i ki utbaai nataamaan u ra ruma maa, raa tauraara, a tultul i waan karomi ma i piri naa, “Ui kaai raa kon diat baa muaat weweur ma Iesu a te Gaalilaia.” ");
INSERT INTO rai_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Iaku i weoro namataandiat raap, i piri naa, “Pa iaau nunura a utnaa maa u pirpir uni.” ");
INSERT INTO rai_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Baa i waan urong naa ra bonanaaka i ra liplip, raa tauraara bulung i babo paai, ma i piri taan diat baa diat tur matira naa, “A muaana mi diaar ut ma Iesu a te Naasaret.” ");
INSERT INTO rai_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma i weoro balet, i weweliman naa, “A lingtatuna ut, pa iaau nunura muaana maa.” ");
INSERT INTO rai_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Namur kinalik, diat baa diat tur matira diat waan karom Petero, diat piri taana naa, “A lingtatuna ut baa ui kaai raa kon diat. Miaat walangoro lele ui ku u ra num liu na pirpir.” ");
INSERT INTO rai_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma i weweliman karom diat, i piri naa, “God in naagagon aakaka iaau baa ang warwaruga. Pa iaau nunura muaana maa.” Ma a kareke i kurkurekatuk maut. ");
INSERT INTO rai_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma Petero i nuk paa a pirpir anun Iesu baa ia pir taai taana naa, “Baa a kareke pa in kurkurekatuk utbaai, un weoro kon iaau tula pakaan.” Ma i pari ko ra wanua maa, ma i taangi dekdek aakit. ");
INSERT INTO rai_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Baa i malaana kinalik, a kum ngaala na tena wetabaar karom God raap ma ra kum mukmuga anu ra taara diat pirpir ungaai un Iesu kupi din aak dokoi. ");
INSERT INTO rai_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Diat wi paa a ru limaana, diat ben paai ma diat taar taai karom Pilaato a ngaala na mukmuga ko ra mataanitu. ");
INSERT INTO rai_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Baa Iudaas, ia baa i wagu taa Iesu, i nunurai naa di aa naagagon taa Iesu kupi in maat, a ngaala na tapunuk i loi, ma i waan talili balet ma 30 pakaana silwa karom a kum ngaala na tena wetabaar karom God ma ra kum mukmuga. ");
INSERT INTO rai_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma i piri naa, “Iaau aa paam wa aakaina, maa iaau aa wagu taa ia baa pa i paam ta aakaina.” Ma diat piri taana naa, “Miaat, miaat lawaai? Ui ut!” ");
INSERT INTO rai_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","I ong wa a 30 pakaana silwa u ra ruma na wetabaar, ma i waan paa ma i pita doko paai. ");
INSERT INTO rai_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A kum ngaala na tena wetabaar karom God diat lo paa a kum pakaana silwa maa, ma diat piri naa, “Pa i takado u ra kum Naagagon baa daat a paki a maani mi u ra wuwuwung na maani, maa a maani mi a winekul u ra muaana baa di aak dokoi.” ");
INSERT INTO rai_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Io, diat pirpir ungaai paa uni, ma diat kul paa a pakaana pia ko ra tena paampaam kuro ma ra piapaap, kupi din punpunang a kum minaat i ra kum waira na taara iaai. ");
INSERT INTO rai_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Maa ia a kabina baa diat taar taa a iaa ra pakaana maa baa “A pia na gaap,” ma a taara diat waatungi ut lenmaa tuk mari. ");
INSERT INTO rai_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lenmaa di paam ot paa a pirpir baa Ieramia a propet ia pir taai namuga naa, “Diat lo paa a 30 pakaana silwa, a mataana baa a taara Israael diat luk taai u ra muaana maa. ");
INSERT INTO rai_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ma ra 30 pakaana silwa maa di kul paa a pakaana pia anu ra tena paampaam kuro ma ra piapaap, welaar ma Tadaaru i pir taai taang.” ");
INSERT INTO rai_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu i tur namataan Pilaato, a mukmuga ko ra mataanitu, ma a mukmuga i tiri naa, “Ui maa a King anu ra taara Iudaia?” Ma Iesu i baalui naa, “Ma raa ut ia u aa piri.” ");
INSERT INTO rai_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Baa a kum ngaala na tena wetabaar karom God ma a kum mukmuga diat takunai, pa i pirpir. ");
INSERT INTO rai_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma Pilaato i tiri naa, “Pa u walangoro a kum pirpir na wetakun mi di takuna ui mai?” ");
INSERT INTO rai_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pa i baalu diat un ta wetakun baa diat takunai mai, pate mulu. Ma a mukmuga ko ra mataanitu i kakaian aakit uni. ");
INSERT INTO rai_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","U ra kum kilakilaala raap u ra kum lukaara na waan likaai, a mukmuga ko ra mataanitu i laana palaa wa raa karabus baa a taara diat aaring kupi. ");
INSERT INTO rai_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","U ra kilaala maa, raa muaana a iaana Baaraabaas i ki u ra karabus u ra nuna kum ngaala na aakaina mangamangaan, ma a taara raap diat kaapa uni. ");
INSERT INTO rai_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Baa a kor na taara diat waan paat ungaai karom Pilaato, i tiri diat naa, “Woi maa muaat nemi naa ang palaa wai karom muaat? Baaraabaas baa Iesu, ia baa di waatungi naa Kaarisito?” ");
INSERT INTO rai_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I piri lenbi kabina ia nunurai naa diat taar taa Iesu ku karomi u ra aakaina nuknukindiat. ");
INSERT INTO rai_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Baa Pilaato kuraa utbaai i paam a naagagon, anuna tabuan i taar wa a pirpir karomi naa, “Koku u paam ta utnaa u ra tena takado maa, pa nuna ta niraara. Maa nabari u ra marum, iaau beberon, ma a kum utnaa iaau baboi u ra muaana maa i wapurpuruan anung lalaaun.” ");
INSERT INTO rai_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A kum ngaala na tena wetabaar karom God ma a kum mukmuga diat wowo taa a kor na taara kupi diat a aaring kup Baaraabaas, ma kupi din aak doko wa Iesu. ");
INSERT INTO rai_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A mukmuga ko ra mataanitu i tiri diat naa, “Woi na paan diaar maa muaat nemi naa ang palaa wai karom muaat?” Diat baalui naa, “Baaraabaas.” ");
INSERT INTO rai_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaato i tiri diat naa, “Io, aawa maa ang paami un Iesu, ia baa di waatungi naa Kaarisito?” Diat raap diat baalui naa, “Aak waati u ra bolo.” ");
INSERT INTO rai_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma i tiri diat naa, “Aawa kabina? Woi na aakaina utnaa maa ia paam taai?” Iaku diat ge dekdek ku ma ra pirpir naa, “Aak waati u ra bolo!” ");
INSERT INTO rai_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Baa Pilaato i baboi naa pa i pet laar paa ma ta utnaa, ma a ngaala na purpuruan marawaai in turpaai, i lo paa a palaa ma i gi paa a ru limaana mai namataa ra kor na taara, ma i piri naa, “Iaau laangalaanga ko ra gaapi ra tena takado mi. Muaat ut din naagagon muaat uni.” ");
INSERT INTO rai_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A taara raap diat baalui naa, “Koina ku, a naagagon na binabaalu u ra gaapina in ki un miaat ma u ra kum natnatumiaat kaai.” ");
INSERT INTO rai_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ma Pilaato i palaa wa Baaraabaas karom diat. Io, baa di aa raapu tataa Iesu, Pilaato i taar taai taa ra kum tena wineium kupi diat a aak waati u ra bolo. ");
INSERT INTO rai_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A kum taara na wineium anu ra mukmuga ko ra mataanitu diat ben paa Iesu unaruma u ra ngaala na ruma anu ra nundiat mukmuga ma diat ben ungaai paa a kikil na taara na wineium raap karomi. ");
INSERT INTO rai_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Diat palaa wa anuna kum maalu, ma diat wamong taai ma ra in taar na maalu. ");
INSERT INTO rai_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma diat limaai paa in aaru i taar laklakono ma diat ung taai u ra in lorina welaar ma ra in kaaeng. Diat wapaampaam taai ma ra in diwaai lik u ra ot na limaana ma diat ki but keke namataana, ma diat tataur uni lenbi, “Ui maa a king anu ra taara Iudaia!” ");
INSERT INTO rai_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma diat kamiai, diat rakaan paa in diwaai lik maa koni, ma diat raapraapu in lorina mai. ");
INSERT INTO rai_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Baa diat aa tataur paa uni, diat palaa wa in taar na maalu koni. Diat wamong taai balet ma ra nuna kum maalu, ma diat ben apari paai kupi din aak waati u ra bolo. ");
INSERT INTO rai_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Baa diat pari diat baraata paa raa te Kirene, a iaana Simon, ma diat wowo taai kupi in lo a bolo anun Iesu. ");
INSERT INTO rai_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Diat waan paat u ra wanua di waatungi ma Golgotaa, a kukuraaina “Pia na Lor.” ");
INSERT INTO rai_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Diat taar taa a waain taan Iesu, a waain baa di ung ungaai ma raa utnaa baa i mapaak. Baa i namene paai, pa i nemi naa in inimi. ");
INSERT INTO rai_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Io, baa diat aa aak waat taai u ra bolo, diat pilaai laaki kup woi kon diat in lo paa raaraaina maalu ko ra nuna kum maalu. ");
INSERT INTO rai_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Namur diat ki ma diat bababo Iesu. ");
INSERT INTO rai_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nate u ra bolo diat ung taa a pirpir na wetakun uni, di timu taai lenbi: ");
INSERT INTO rai_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ma di aak waat kaai ru tena walong ungaai mai un raa ru bolo, raa u ra papaara ot na limaana, ma raa u ra papaara maira. ");
INSERT INTO rai_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma diat baa diat waanwaan aakit Iesu, diat pir aakakai ma diat liliaa lorindiat karomi. ");
INSERT INTO rai_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ma diat piri naa, “Ui ma maa baa u piri naa un reng wa a ruma na wetabaar ma un paam paai balet ku un ta tula bung, mi un walaaun pa ui ma. Baa ui a Natun God, un pari ko ra bolo.” ");
INSERT INTO rai_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","A kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon ma a kum mukmuga, diat kaai diat tataur un Iesu, diat piri naa, ");
INSERT INTO rai_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I walaaun paa a taara ingen, iaku ia ut pa in walaaun laar paai. Baa ia a King anu ra taara Israael, mi ut in pari ko ra bolo ma daat a nurnur uni. ");
INSERT INTO rai_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I nurnur ut un God. Io, baa God i nemi, mi ut in walaaun paai balet, maa ia ut ia pir taai naa, ‘Iaau a Natun God.’” ");
INSERT INTO rai_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A ru tena walong baa diaar kete ungaai mai, diaar kaai diaar pir aakakai. ");
INSERT INTO rai_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Turpaai u ra 12 pakaana bung u ra mage tuk un tuluina pakaana bung u ra maluraap a buaal raap i baboto. ");
INSERT INTO rai_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Baa i tuluina pakaana bung, Iesu i kulkulaai dekdek lenbi, “Eloi, Eloi, lemaa saabaakaataani?” A kukuraai ra pirpir mi i lenbi, “Anung God, anung God, i lawaai maa u waan paa kon iaau?” Kele 22:1 ");
INSERT INTO rai_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Raa taara kon diat baa diat tur marawaai, baa diat walangoroi diat piri naa, “A muaana mi i wewataai kup Eliaas.” ");
INSERT INTO rai_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aiaapiaap ku, raa kon diat i welulu, ma i lo paa raa utnaa baa i laana lo koto a polo. I puk paai u ra waain baa i matitir, i ung paai u ra in diwaai ma i tulaa tatoi unaanga nate kupi Iesu in inimi. ");
INSERT INTO rai_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Raa taara kaai kon diat diat piri naa, “Iot, daat a baboi kumun. Lelawaai, Eliaas in waan pari kupi in walaaun paai baa pate?” ");
INSERT INTO rai_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma Iesu i kulkulaai dekdek paa balet, ma i ung wa anuna lalaaun. ");
INSERT INTO rai_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","U ra pakaana bung ut maa ina maalu na babaat kutu naruma u ra ruma na wetabaar i tarabaat weraan, turpaai taanginaanga nate tuk napia. A guria i waan paat, ma ra kum waat diat tapuar. ");
INSERT INTO rai_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A kum babaang na minaat diat tapaapa, ma mongoro na tena takado, baa diat aa maat, diat tur balet. ");
INSERT INTO rai_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Diat waan paat ko ra kum babaang na minaat, ma baa Iesu ia lalaaun balet, diat waan paat unaanga Ierusalem, a taamaan anun God, ma diat tur paat karom mongoro na taara. ");
INSERT INTO rai_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A mukmuga anu ra kum tena wineium, ma diat kaai baa diat tur ungaai mai kupi diat a baboura Iesu, diat kariaana paa a guria, ma baa diat babo a kum utnaa baa i waan paat, diat burut aakit, ma diat piri naa, “I lingtatuna aakit, a muaana mi a Natun God.” ");
INSERT INTO rai_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mongoro na tabuan kaai baa diat murmur Iesu taangirong Gaalilaia ma diat waraauti, diat tur welwelik taau ut ma diat babo a kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kuraa naliwan taa ra kum tabuan maa, raa tula tabuan kaai, Maaria Maagdalene, ma Maaria naan Iaakobo ma Iosep, ma a naan ru natun Sebedaaio. ");
INSERT INTO rai_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Baa ia maluraap, raa tadaaru na muaana, a te Aarimaatia, a iaana Iosep, ia kaai raa naat na wawer anun Iesu, ");
INSERT INTO rai_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","i waan karom Pilaato ma i aaring paa a minaatin Iesu koni. Pilaato i wetulaa kupi din taar taai taana. ");
INSERT INTO rai_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosep i lo paa a minaatina, ma i pulu paai ma ra ina koina maalu baa i gomgom, ");
INSERT INTO rai_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma i wainep taai u ra nuna matakina babaang na minaat, baa ia kil taai u ra papaara waat. Ma i tul baat taa a mataa ra babaang na minaat ma ra ina ngaala na waat, ma i waan paa koni. ");
INSERT INTO rai_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maaria Maagdalene ma Maaria kaai, naan Iaakobo ma Iosep, diaar ki taau namuga naa ra babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","U ra bung namur, a Bung Saabaat, a kum ngaala na tena wetabaar karom God ma a kum Parisaaio diat waan ungaai karom Pilaato. ");
INSERT INTO rai_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Diat piri taana naa, “Tadaaru, miaat nuk paa raa pirpir anu ra tena warwaruga mi baa i lalaaun utbaai. I piri naa, baa tula bung in raap, in lalaaun paat balet. ");
INSERT INTO rai_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Un tula wa ta taara kupi diat a baboura baat wakaak a babaang na minaat, welaar ma tula bung, kaduk anuna taara na wawer diat a waan paat ma diat a walong paa a minaatina, ma diat a wapua a taara naa ia lalaaun balet ko ra minaat. Ma a warwaruga mi anundiat, in ngaala taa ra warwaruga baa namuga Iesu ia pir taai.” ");
INSERT INTO rai_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaato i piri taan diat naa, “Mi ut muaat a ben paa a kum tena baboura ma muaat a waan. Muaat a baboura baat wakaak a babaang na minaat welaar ut ma ra numuaat manaana.” ");
INSERT INTO rai_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Io, diat waan, ma diat wadekdek baat taa a babaang na minaat. Diat ung a mangaana wakilang kupi baa te in paapai diat a nunura paai ku. Ma diat watur taa a kum tena baboura kupi diat a baboura baati. ");
INSERT INTO rai_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Baa ia raap a Bung Saabaat ma i laar u ra mugaana bung u ra wik, Maaria Maagdalene, ma raa Maaria kaai diaar waan kupi diaar a babo a babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma a ngaala na guria i waan paat, maa raa aangelo anu ra Tadaaru i waan pari taanginaanga u ra maawa kup a babaang na minaat, ma i tul ingen wa ina waat ma i ki taau nate uni. ");
INSERT INTO rai_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A mataana i baarabaara welaar ma in mamame, ma anuna ina maalu i kabaang welaar ma ra buabua na top. ");
INSERT INTO rai_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A kum tena baboura diat burutaana aakiti, diat dadader, ma diat welaar maku ma ra kum minaat. ");
INSERT INTO rai_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A aangelo i piri taa ra ru tabuan maa lenbi, “Koku mur burut, iaau nunurai naa mur baat kup Iesu, ia baa di aak waat taai u ra bolo. ");
INSERT INTO rai_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pa i ki ma min. Ia lalaaun balet welaar ma ra nuna pirpir. Mur a waan urin, mur a babo a wanua baa di wainep taai iaai. ");
INSERT INTO rai_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Namur mur a waan gagaa, ma mur a wapua anuna kum naat na wawer naa, ‘Ia lalaaun balet ko ra minaat. Mi in muga urong Gaalilaia. Muaat a baboi marong.’ Mi iaau wapua mur uni.” ");
INSERT INTO rai_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Diaar waan gagaa ko ra babaang na minaat. Diaar burut, iaku a ngaala na gaaia kaai i lo diaar. Diaar welulu kup anuna kum naat na wawer kupi diaar a wapua diat u ra pirpir mi. ");
INSERT INTO rai_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Baa diaar waan waanwaan, Iesu i waan paat kakaian karom diaar. Ma i piri taan diaar naa, “Koina malaana karom mur.” Diaar waan karomi, diaar paam a ru kakina ma diaar lotu karomi. ");
INSERT INTO rai_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Iesu i piri taan diaar naa, “Koku mur burut. Mur a waan ma mur a wapua a kum tateng liklik, baa diat a waan urong Gaalilaia, ma diat a babo iaau marong.” ");
INSERT INTO rai_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Baa ru tabuan diaar aa waan, raa kum tena baboura baa diat baboura babaang na minaat, diat waan unaanga Ierusalem. Ma diat wapua a kum ngaala na tena wetabaar karom God u ra kum utnaa raap baa i waan paat irong u ra babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Namur baa a kum ngaala na tena wetabaar ma ra kum mukmuga diat ki ungaai, diat pirpir ungaai kup ta aakapi baa diat a murmuri. Namur diat taar taa a ngaala na maani karom a kum tena wineium, ");
INSERT INTO rai_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma diat piri naa, “Muaat a piri ku lenbi, ‘U ra marum baa miaat inep duman anuna kum naat na wawer diat waan paat ma diat walong paa minaatina.’ ");
INSERT INTO rai_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Baa a mukmuga ko ra mataanitu in walangoro a utnaa mi, ma in wetiri uni, miaat a waraaut muaat, ma miaat a palaa pa muaat ko ra naagagon.” ");
INSERT INTO rai_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Io, a kum tena wineium diat lo paa a maani, ma diat paami welaar ma di aa wapua ta diat uni. Ma a pirpir mi i waan werweraan karom a taara Iudaia tuk mi. ");
INSERT INTO rai_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A 11 naat na wawer anun Iesu diat waan urong Gaalilaia u ra taangaai baa Iesu ia wapua ta diat uni. ");
INSERT INTO rai_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Baa diat baboi, diat lotu karomi, iaku raa taara kon diat pa diat nurnur. ");
INSERT INTO rai_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu i waan karom diat, ma i piri taan diat naa, “God ia taar araap taa a naagagon taang, kupi ang naagagon a kum utnaa raap inaanga u ra maawa ma main kaai napia. ");
INSERT INTO rai_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Io, muaat a waan, muaat a wer a kum wunwuna taara raap, kupi diat kaai anung kum naat na wawer. Muaat a baapitaaiso diat u ra iaan Tamaang, ma Natuna, ma ra Takado na Nion. ");
INSERT INTO rai_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma muaat a wer diat kupi diat a taraam u ra kum pirpir raap baa iaau aa pir taai taa muaat. Ma a lingtatuna baa iaau ang ki ungaai ma muaat tuk u ra tintinipina.” ");
INSERT INTO rai_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mari ia a turpaai ra Koina Wewapua un Iesu Kaarisito, Natun God. ");
INSERT INTO rai_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A pirpir anun God baa di aa timu taai u ra buk anu ra propet Aaisaia i piri lenbi, “Baboi, ang tula wa anung tena lo pirpir kupi in muga taam, ma in paam aara anum aakapi. ");
INSERT INTO rai_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","In ingaan raa i wewataai u ra bil na wanua lenbi, ‘Muaat a paam aara aakapi anu ra Tadaaru, muaat a paam kado anuna kum aakapi.’” Aais 40:3 ");
INSERT INTO rai_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Io, Ioaanes a Tena Baapitaaiso i ki u ra bil na wanua ma i laana baapitaaiso ma i warawaai naa a taara diat a nukpuku ma din baapitaaiso diat, ma God in una wa anundiat kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A taara raap taanginaanga Ierusalem ma taanga u ra papaar Iudaia raap, diat waan karomi. Diat pir apuaana anundiat kum aakaina mangamangaan, ma i baapitaaiso diat u ra daanim Ioridaan. ");
INSERT INTO rai_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioaanes i mong ma ra ina maalu na weu na kaamel, ma i wi baati ma ra panina bulumakaau, ma i aanaan a kum ko ma ra bulit baa a kum bi diat paami. ");
INSERT INTO rai_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","I warawaai lenbi, “Ia baa in murmur taang i ngaala taang. Ma iaau, iaau kinalik aakit taana. ");
INSERT INTO rai_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iaau baapitaaiso muaat ma ra palaa, ma in baapitaaiso muaat ma ra Takado na Nion.” ");
INSERT INTO rai_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","U ra kum bungbung baa Ioaanes i baapitaaiso a taara, Iesu i waan paat taangirong u ra taamaan Naasaret u ra papaar Gaalilaia. Ma Ioaanes i baapitaaisoi u ra daanim Ioridaan. ");
INSERT INTO rai_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Baa Iesu i or pari ko ra daanim, i babo a maawa i tapaapa, ma a Takado na Nion i waan pari taau uni welaar ma ra ina buna. ");
INSERT INTO rai_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma in ingaan raa taanginaanga u ra maawa i piri lenbi, “Ui Natunglik, a naat na wakwakaak, iaau gaaia aakit un ui.” ");
INSERT INTO rai_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma namur a Takado na Nion i tula wa Iesu unaanga u ra bil na wanua. ");
INSERT INTO rai_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma i ki matira 40 bungbung ma Saataan i walaami. I ki ungaai ma ra kum kuaabaar na wewagua ma a kum aangelo diat waraauti. ");
INSERT INTO rai_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Baa di aa waruk taa Ioaanes u ra ruma na karabus, Iesu i waan paat irong u ra papaar Gaalilaia, i warawaai ma ra Koina Wewapua anun God, ");
INSERT INTO rai_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","i piri lenbi, “Ia ot a pakaana bung, ma a mataanitu anun God ia marawaai, muaat a nukpuku, ma muaat a nurnur u ra Koina Wewapua”. ");
INSERT INTO rai_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Baa i wawaal nakono naa ra taai kikil Gaalilaia, i babo paa naadina Simon ma Aanderiaas baa diaar ong bene nataai, maa diaar a ru tena ong bene. ");
INSERT INTO rai_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I piri taan diaar naa, “Mur a murmur iaau, ma ang wer mur kupi mur a ru tena aalaal taara.” ");
INSERT INTO rai_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Io, diaar tur paa maut ko ra nundiaar kum bene, ma diaar murmuri. ");
INSERT INTO rai_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma baa i wawaal kinalik balet, i babo paa bulung raa naadina Iaakobo ma Ioaanes, a ru natun Sebedaaio, diaar ki u ra mon ma diaar ingit anundiaar kum bene. ");
INSERT INTO rai_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu i wataa pa diaar gagaa maut, ma diaar waan kon tamaandiaar ma ra kum tultul u ra mon, ma diaar murmuri. ");
INSERT INTO rai_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Diat waan urong Kaapernaaum, ma u ra Bung Saabaat Iesu i ruk u ra ruma na lotu, ma i wer diat. ");
INSERT INTO rai_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma diat kakaian u ra nuna wawer, maa i wer diat lenbaa ia ut i paam akoto a naagagon, ma pa i wer diat welaar ma ra kum tena wawer u ra kum Naagagon. ");
INSERT INTO rai_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Raa muaana, a tabaraan kuraa uni, i ki u ra nundiat ruma na lotu, i kulkulaai lenbi, ");
INSERT INTO rai_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ui Iesu a te Naasaret. Un paam aawa un miaat? U waan paat duk kupi un baanaakaka wa miaat? Iaau nunura ui, ui a Tena Gomgom anun God.” ");
INSERT INTO rai_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu i turbaati ma ra pirpir lenbi, “Koku pirpir! Pari ko ra muaana maa!” ");
INSERT INTO rai_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A tabaraan i wadader taai, ma i kulkulaai paa, ma i pari koni. ");
INSERT INTO rai_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A taara raap diat kakaian aakit, ma diat tiri wetwetalaai diat naa, “Aawa mi? A matakina wawer duk. A muaana mi i paam akoto a naagagon ma i naaknaagagon wa utkaai a kum tabaraan, ma diat tartaraam karomi.” ");
INSERT INTO rai_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma a pirpir un Iesu i waan werweraan u ra kum taamtaamaan raap u ra papaar Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Baa Iesu ma ra nuna kum naat na wawer diat pari ko ra ruma na lotu, diat weur ma Iaakobo ma Ioaanes ma diat waan maut kup a ruma anun Simon diaar ma Aanderiaas. ");
INSERT INTO rai_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nimun Simon, a tabuan i malaapaang, ma i inep ma ra ina wuwan, ma diat wapua gagaa Iesu uni. ");
INSERT INTO rai_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Io, Iesu i waan karomi, i paam paa a limaana, ma i aal atur paai, ma ina wuwan i raap maut koni. Ma a tabuan maa i tabaara diat ma ra utnaa na winangaan. ");
INSERT INTO rai_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma baa i tawiwibung, a taara diat ben paa a kum malaapaang raap karom Iesu, ma diat kaai baa a kum tabaraan diat ruk taau un diat. ");
INSERT INTO rai_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A taara raap taanga u ra taamaan maa diat teng na bonanaaka. ");
INSERT INTO rai_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma i walaangalaanga paa mongoro baa diat malaapaang ma ra kum aalawur mangaana malaapaang, ma i lu irok wa mongoro na tabaraan kon diat. Ma i turbaat a kum tabaraan kupi koku diat pirpir, kabina diat nunura ut Iesu. ");
INSERT INTO rai_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","U ra laar, Iesu i tawaangun ma i pari. I waan kup a bil na wanua, ma i aaraaring matira. ");
INSERT INTO rai_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ma diat baa diat weur mai, diat baat kupi. ");
INSERT INTO rai_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Baa diat aa baat paai, diat piri taana lenbi, “A taara raap diat baat kup ui.” ");
INSERT INTO rai_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Iesu i piri taan diat naa, “Daat a waan un ta kum taamaan marawaai, kupi ang warawaai kaai karom diat. Maa mi ia kabina baa iaau waan paat kupi.” ");
INSERT INTO rai_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Io, i waan taltalili u ra papaar Gaalilaia raap. I warawaai u ra nundiat kum ruma na lotu, ma i lu irok wa a kum tabaraan ko ra taara. ");
INSERT INTO rai_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Raa muaana, a wukawuka, i waan karom Iesu, i ki but keke, ma i aaring dekdeki naa, “Pa i dekdek karom ui, baa u nemi, io, un walaangalaanga iaau.” ");
INSERT INTO rai_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma Iesu i maari, i kado wa a limaana, i paam a panina, ma i piri taana naa, “Iaau nemi ut. Un laangalaanga.” ");
INSERT INTO rai_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma a wukawuka i raap maut koni, ma i laangalaanga balet. ");
INSERT INTO rai_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ma Iesu i pirpir dekdek taau karomi naa, “Koku wapua taa te uni. Un waan ma un waiaa muga ta ui karom a tena wetabaar karom God, ma un taar a wetabaar karom God welaar ma Moses ia pir taai. Baa un paami lenbi in kaapa karom a taara baa u aa laangalaanga.” ");
INSERT INTO rai_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iaku a muaana mi i pari ma i wewapua taltalili uni karom a taara. Ma i pet taa Iesu baa pa i waan baara balet ma un ta taamaan, i waan taltalili maku u ra kum bil na wanua, ma a kum taara taanga u ra kum taamaan diat waan karomi. ");
INSERT INTO rai_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Baa kabaana bung ia raap, Iesu i waan balet urong Kaapernaaum. Baa a taara diat walangoroi naa i ki naruma un raa ruma, ");
INSERT INTO rai_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","io, mongoro kon diat, diat waan paat karomi, ma pa ta kolo balet ma naruma, ma u ra bonanaaka kaai. Ma Iesu i warawaai ma ra pirpir anun God karom diat. ");
INSERT INTO rai_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma waat na muaana diat waan paat ma raa muaana baa a panpanina i maat. Diat nem na loi karom Iesu. ");
INSERT INTO rai_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Iaku a ngaala na kor na taara diat aa turbaat paai ma pa diat pet laar paai baa diat a ruk mai. Io, diat kaa mai unaanga nate u ra ruma, ma diat reng aara paa raa wanua inaanga nate takado ma ra pakaana baa Iesu i ki iaai. Ma diat warira pari taa a muaana a panpanina i maat ma ra baana. ");
INSERT INTO rai_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Baa Iesu i babo anundiat nurnur, i piri taa ra muaana baa a panpanina i maat naa, “Natunglik, di aa una wa anum kum aakaina mangamangaan.” ");
INSERT INTO rai_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Raa kum tena wawer u ra kum Naagagon diat ki matira. Diat nuknuk u ra nuknukindiat naa, “Aawa a kabina maa a muaana mi i piri lenmi? I pir aakaka God baa i welaara ia mai. Woi in una wa a kum aakaina mangamangaan? God ku i pet laar paai.” ");
INSERT INTO rai_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu i nunurai maut u ra niono baa diat nuknuk lenmi, ma i tiri diat naa, “Aawa kabina muaat nuknuk lenmi? ");
INSERT INTO rai_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Woi na mangaana pirpir ang piri karom a muaana mi kupi ang waiaa a dekdeking mai karom muaat? Ang piri naa, ‘Di aa una wa anum kum aakaina mangamangaan,’ baa, ‘Un tur, un lo paa anum baat ma un waan’? ");
INSERT INTO rai_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ang piri lenbi kupi muaat a nunurai naa Natu ra Muaana i paam akoto a naagagon kupi in una wa a kum aakaina mangamangaan min napia.” Io, i piri karom a muaana baa a panpanina i maat, ");
INSERT INTO rai_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iaau piri taam, un tur, un lo paa anum baat, ma un waan kup anum ruma.” ");
INSERT INTO rai_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma i tur maut, i lo paa anuna baat, ma i pari namataandiat raap. Diat raap diat kakaian ma diat pir walaawa paa God, ma diat piri naa, “Talek mi miaat babo a utnaa lenbi.” ");
INSERT INTO rai_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Baa Iesu i waan pari balet unakono u ra taai Gaalilaia, a ngaala na kor na taara diat waan paat karomi, ma i wer diat ma ra pirpir anun God. ");
INSERT INTO rai_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Baa i waan waanwaan, i babo paa Lewi, natun Aalipaaio, i ki u ra ruma na tatakom, ma Iesu i piri taana naa, “Un murmur iaau.” Io, Lewi i tur ma i murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Namur baa Iesu i ki u ra winangaan u ra ruma anun Lewi, mongoro na tena lolo tatakom ma ra kum tena aakaina diat wangaan ungaai ma Iesu ma ra nuna kum naat na wawer. Maa mongoro na taara diat murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Raa kum tena wawer u ra kum Naagagon, ko ra kikil anu ra kum Parisaaio, diat babo Iesu baa i wangaan ungaai ma ra kum tena aakaina ma ra kum tena lolo tatakom. Diat tiri anuna kum naat na wawer naa, “Aawa kabina baa i wangaan ungaai ma ra kum tena lolo tatakom ma ra kum tena aakaina?” ");
INSERT INTO rai_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Baa Iesu i walangoroi, i piri taan diat, “A doktaa pa i waan paat kup diat baa diat lalaaun wakaak. Pate! I waan paat kup diat ku baa diat malaapaang. Pa iaau waan paat kup a kum tena takado. Pate! Iaau waan paat kupi ang wataa paa a kum tena aakaina.” ");
INSERT INTO rai_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A kum naat na wawer anun Ioaanes ma ra kum Parisaaio diat wawel. Raa taara diat waan karom Iesu ma diat tiri naa, “Aawa kabina baa a kum naat na wawer anun Ioaanes ma ra kum naat na wawer anu ra kum Parisaaio diat wawel, ma anum kum naat na wawer pate?” ");
INSERT INTO rai_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu i baalu diat naa, “A kum teptepaa ra matakina tinaulaa diat a wawel lelawaai baa a matakina tinaulaa i ki ungaai utbaai ma diat? Baa i ki ungaai utbaai ma diat, pa diat a wawel. ");
INSERT INTO rai_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ta bung in waan paat baa din ben ingen wa a matakina tinaulaa kon diat, io, u ra bung maa diat a wawel maraagaam. ");
INSERT INTO rai_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Pa te in ingit ungaai taa ta pakaana matakina maalu ma ra pakaana turaaina. Baa te i paami lenmaa, a matakina baa din ingit banot ungaai mai, in pet rabaana wa balet a turaaina maalu, ma in ngaala ma a tarabaat uni. ");
INSERT INTO rai_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma pa te in labo taa a matakina waain u ra in turaaina palaa na waain baa di paami ko ra pani ra wewagua, kaduk a waain in rabaana wa in turaaina palaa, ma a waain in talabo, ma in palaa na waain kaai in aaka. Din labo ut a matakina waain u ra in matakina palaa na waain.” ");
INSERT INTO rai_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Un raa Bung Saabaat, Iesu i waan bolo u ra kum wanua na wit. Baa diat waan waanwaan, anuna kum naat na wawer diat gamut kutu paa a kum wit. ");
INSERT INTO rai_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A kum Parisaaio diat tiri Iesu naa, “Aawa kabina baa diat paam a utnaa mi ma pa diat murmur a Naagagon ko ra Bung Saabaat?” ");
INSERT INTO rai_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu i piri taan diat, “Lelawaai, pa muaat luk utbaai a utnaa baa Dewid i paami baa diat ma ra taara baa diat weur mai diat molo, ma pa andiat ta utnaa? ");
INSERT INTO rai_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Baa Aabiaataa i mukmuga na tena wetabaar karom God, Dewid i ruk u ra ruma anun God ma i aan a bred baa di aa tabaara taa God mai. Ma i tabaara diat kaai baa diat weur mai. A bred maa di wataabui ko ra taara biaa ku. A kum tena wetabaar ku karom God i tale diat a wangaan koni.” ");
INSERT INTO rai_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma Iesu i piri taan diat, “Di paam taa a Bung Saabaat kupi in waraaut a taara, wakir kupi a taara diat a waraaut a Bung Saabaat. ");
INSERT INTO rai_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lenmaa Natu ra Muaana ia a Tadaaru i ra Bung Saabaat kaai.” ");
INSERT INTO rai_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ma Iesu i ruk balet u ra ruma na lotu, ma raa muaana kuraa matira a limaana i baau. ");
INSERT INTO rai_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma raa taara diat baat kup ta utnaa baa diat a takuna Iesu uni, io, diat babo ururai baa lelawaai in walaangalaanga a malaapaang u ra Bung Saabaat, baa pate. ");
INSERT INTO rai_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma i piri karom a muaana baa limaana i baau naa, “Un tur ubin namuga taan diat raap.” ");
INSERT INTO rai_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma i tiri diat lenbi, “Aawa maa a kum Naagagon i piri naa din paami u ra Bung Saabaat? Din paam a koina baa din paam aakaina, din walaaun te baa din aak doko te?” Iaku pa diat babaalu. ");
INSERT INTO rai_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu i babo na kaankaan karom diat raap. I tapunuk kabina maa a balaandiat i dekdek. Ma i piri taa ra muaana naa, “Un kado a limaam.” Ma i kadoi, ma a limaana i tubu balet. ");
INSERT INTO rai_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Baa a kum Parisaaio diat pari, diat waan karom a taara anun Erodes, ma diat wepaak paa maut un Iesu, baa diat a aak dokoi lelawaai. ");
INSERT INTO rai_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ma ra nuna kum naat na wawer diat waan pari unakono, ma a ngaala na kor na taara taangirong u ra papaar Gaalilaia diat murmuri. ");
INSERT INTO rai_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ma mongoro na taara kaai diat murmuri taangirong u ra papaar Iudaia, ma taanginaanga Ierusalem, ma taangirong u ra papaar Idumaaia, ma taangirong un raa papaara daanim Ioridaan, ma taangirong Tiro ma Sidon kaai. A ngaala na kor diat, diat waan paat, maa diat aa walangoro taa a kum ngaalangaala na utnaa baa Iesu ia paam taai. ");
INSERT INTO rai_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Io, i wapua anuna taara na wawer kupi diat a tul alop a mon, ma baa a ngaala na kor na taara diat a liur baat paai, io in kaa uni. ");
INSERT INTO rai_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","I piri lenmaa kabina ia walaangalaanga paa mongoro na malaapaang, ma diat baa diat malaapaang diat tul aara pa diat kupi diat a kakaraai marawaai karom Iesu ma diat a paami. ");
INSERT INTO rai_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma diat baa a kum tabaraan diat ruk taau un diat, baa diat babo Iesu diat puka pari namataana. Ma a kum tabaraan diat kulkulaai lenbi, “Ui a Natun God.” ");
INSERT INTO rai_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iaku i turbaat diat kupi koku diat pir waiaai naa ia woi. ");
INSERT INTO rai_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Namur i waan tato unaanga nate u ra taangaai lik, ma i wataa pa diat baa i nem diat, ma diat waan karomi. ");
INSERT INTO rai_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma i pilak paa ku 12, ma i waatung diat a kum aapostolo. I pilak pa diat kupi diat a weur mai, ma kupi in tula wa diat ma diat a warawaai ma ra pirpir anun God. ");
INSERT INTO rai_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","I taar taa a naagagon taan diat kupi diat a lu irok wa a kum tabaraan ko ra taara. ");
INSERT INTO rai_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bari diat 12 baa i pilak pa diat: Simon ia baa Iesu i taar taa kaai raa iaana baa Petero. ");
INSERT INTO rai_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iaakobo dina ma Ioaanes a ru natun Sebedaaio, baa Iesu i taar balet a iaandiaar baa Boaanerges, a kukuraaina baa a ru natu ra pakpagur, ");
INSERT INTO rai_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aanderiaas, Pilipo, Baatolomaaio, Maataio, Tomaas, Iaakobo a natun Aalipaaio, ma Tadaaio, ma Simon raa ko ra kikil Silot, ");
INSERT INTO rai_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Iudaas Iskaariot, ia baa i wagu taa Iesu. ");
INSERT INTO rai_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Namur baa Iesu i waan paat u ra nuna taamaan, a ngaala na kor na taara balet diat waan karomi, ma pa ta pakaana bung kupi Iesu ma anuna kum naat na wawer diat a wangaan uni. ");
INSERT INTO rai_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Baa anuna wuna taara diat walangoro a utnaa mi, diat waan kupi diat a ben paai, maa a taara diat piri un Iesu naa ia longlong. ");
INSERT INTO rai_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A kum tena wawer u ra kum Naagagon taanginaanga Ierusalem, diat piri lenbi, “Belsebul, a tadaaru anu ra kum tabaraan, i ruk taau un Iesu, ma i lu irok wa a kum tabaraan ma ra dekdekin Belsebul.” ");
INSERT INTO rai_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Io, Iesu i wataa pa diat karomi, ma i pir a kum pirpir welwelaar lenbi, “Saataan in lu irok lelawaai wa Saataan? ");
INSERT INTO rai_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Baa ta mataanitu diat balet ut diat a weium wetalaai, a mataanitu maa in tur dekdek lelawaai? ");
INSERT INTO rai_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma baa ta naadiwaatamaana diat a weium wetwetalaai balet ku ma diat, pain diat a ki ungaai ma. ");
INSERT INTO rai_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Baa Saataan i weium balet ku ma ra nuna kum tultul, anuna mataanitu pa in tur dekdek ma, in raap ku. ");
INSERT INTO rai_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Pa te in ruk laar paai u ra ruma anu ra dekdek na muaana, ma in lo a kum utnaa taanga naruma, baa pa i wi amuga taa a dekdek na muaana maa. Baa ut in wi akoto muga taai, namur in lo paa maraagaam a kum utnaa anu ra muaana maa. ");
INSERT INTO rai_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iaau pir a lingtatuna taa muaat: Din una wa a kum aakaina mangamangaan raap anu ra taara, ma ra nundiat kum aakaina pirpir kaai un God. ");
INSERT INTO rai_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Iaku baa te in pirpir aakaka u ra Takado na Nion, pain te in una laar paai. Anuna aakaina mangamangaan maa in tur takum.” ");
INSERT INTO rai_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu i piri lenmi kabina diat piri uni naa, “A tabaraan i ruk taau uni.” ");
INSERT INTO rai_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naan Iesu ma ra kum tatena liklik diat waan paat, diat tur nataamaan ma diat wetulaa kupi. ");
INSERT INTO rai_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ma a kor na taara diat ki lili paai ma diat piri taana naa, “Naam ma ra kum tatem liklik bari diat nataamaan. Diat nem na babo ui.” ");
INSERT INTO rai_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma i tiri diat, “Woi maa naang, ma woi diat maa a kum tateng liklik?” ");
INSERT INTO rai_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma i babo karom diat raap baa diat ki lili paai. Ma i piri lenbi naa, “Baboi, diat baa naang ma ra kum tateng liklik, bari diat! ");
INSERT INTO rai_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maa ia baa i murmur a nemnem anun God, ia ut maa tenglik a muaana, ma tenglik a tabuan ma naang.” ");
INSERT INTO rai_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu i turpaa balet a wawer nakono naa ra taai kikil. Ma a ngaala na kor na taara diat waan paat karomi. Io, i kaa u ra mon ma i ki taau uni nataai. Ma a kor na taara raap diat tur nakono. ");
INSERT INTO rai_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma i wer diat un ta mongoro na utnaa ma ra kum pirpir welwelaar. I wer diat lenbi, ");
INSERT INTO rai_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Muaat a walangoroi! Raa tena minamaarut i waan kupi in lamira a kum waina wit. ");
INSERT INTO rai_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Baa i lalamira waanwaan, raa kum waina diat puka taau u ra aakapi, ma ra kum pika diat rowo paat ma diat aan wa diat. ");
INSERT INTO rai_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Raa kum waina kaai diat puka taau u ra pia na waatwaat, baa a pia pa i ngaala, ma diat ilak paat gagaa, maa a pia pa i but. ");
INSERT INTO rai_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma baa a mage i waan paat diat malulur ma diat maraang raap, kabina maa pa ta aakaarindiat. ");
INSERT INTO rai_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Raa kum waina kaai diat puka taau naliwan u ra kum katkadaa, ma ra kum kadaa diat tawa ma diat tawa baat pa diat, ma pa diat wa. ");
INSERT INTO rai_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma raa kum waina kaai diat puka taau u ra koina pia. Diat tawa, ma diat ngaala waanwaan ma diat wa, raa mangaan 30 waindiat, raa mangaan kaai 60, ma raa mangaan 100.” ");
INSERT INTO rai_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Namur Iesu i piri naa, “Ia baa in talingaana, i koina baa in walangor mai.” ");
INSERT INTO rai_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Baa Iesu maku ungaai ma ra nuna 12 naat na wawer ma raa taara kaai diat ki, diat tiri u ra kum pirpir welwelaar. ");
INSERT INTO rai_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma i piri taan diat: “God ia taar taa a manaana taa muaat kupi muaat a nunura a kum utnaa na pidik u ra nuna mataanitu. Iaku karom a taara ingen, din wer diat u ra kum utnaa raap ma ra kum pirpir welwelaar, ");
INSERT INTO rai_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kupi ‘diat a bababo ma pa diat a babo lelei, diat a walwalangor, ma pa diat a walangoro lelei, ma pa diat a manaana uni. Baa gun diat a babo lele ma diat a manaana, io, diat a tapuku karom God, ma in una wa anundiat kum aakaina mangamangaan.’” Aais 6:9-10 ");
INSERT INTO rai_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma i tiri diat naa, “Pa muaat nunura a kukuraai ra pirpir welwelaar mi? Muaat a nunura lelawaai a kukuraain ta pirpir welwelaar? ");
INSERT INTO rai_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A tena minamaarut i welaar ma ra tena warawaai baa i wawer ma ra pirpir anun God. ");
INSERT INTO rai_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A kum waina wit baa diat puka taau u ra aakapi, diat welaar ma ra taara baa diat walangoro taa a pirpir, ma Saataan i waan paat, ma i lo wa a pirpir ko ra balaandiat. ");
INSERT INTO rai_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma raa taara kaai diat welaar ma ra kum waina baa diat puka taau u ra pia na waatwaat. Baa diat walangoro a pirpir, diat paam akotoi maut ma ra gaaia. ");
INSERT INTO rai_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Iaku maa a pirpir pa i ki okot u ra balaandiat, pa diat a tur dekdek, welaar ma ina wit baa pa ta aakaarina. Baa a kum mawaat ma ra kum ngunungut i baraata diat kabina u ra pirpir baa diat nurnur uni, diat puka gagaa maut. ");
INSERT INTO rai_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Raa taara kaai diat welaar ma ra kum waina baa diat puka taau naliwan u ra kum katkadaa. Diat walangoro a pirpir, ");
INSERT INTO rai_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","iaku a kum nginaraa taanga min napia, ma ra nginaraa kaai u ra nundiat kum wuwuwung ma ra nemnem kaai kup a kum utnaa ingen, diat burung baat paa a pirpir anun God ma pa i wa. ");
INSERT INTO rai_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma raa taara kaai diat welaar ma ra waina baa diat puka taau u ra koina pia. Diat walangoro a pirpir ma diat taraam uni, ma diat wa a waindiat, raa taara 30, raa taara 60, ma raa taara kaai 100.” ");
INSERT INTO rai_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma Iesu i piri taan diat, “Pain te in lo paa ta laam ma in kuop baat taai ma ra baaket, ma pa in ung taai kaai natudaangi ra waawaa. Pate! In ung taai ut u ra nuna turtur. ");
INSERT INTO rai_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A utnaa raap baa i taana ino, namur in waan paat kaapakaapa. Ma a utnaa raap baa di walipai, namur din nunurai. ");
INSERT INTO rai_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ia baa in talingaana, i koina baa in walangor mai.” ");
INSERT INTO rai_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma Iesu i piri taan diat, “Muaat a nuknuk wakaak u ra utnaa baa muaat a walangoroi. Woi na mangaana wetabaar baa muaat taari, a ngaala baa a kinalik, ia ut maa a mangaana wetabaar baa God in taari taa muaat. Ma in taar a ngaala aakit taam, taa ra utnaa baa u taar taai. ");
INSERT INTO rai_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Te baa i paam akoto a ngaala, din tabaarai balet ma ra ngaala, ma te baa pa i paam akoto ta utnaa, din rakaan wa utkaai anuna kinalik na utnaa koni.” ");
INSERT INTO rai_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma Iesu i piri balet lenbi, “A mataanitu anun God i welaar ma ra muaana baa i maarut taa a kum waina wit u ra pia. ");
INSERT INTO rai_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma baa i laana inep u ra kum bungbung na marum ma i laana tawaangun u ra kum bungbung na keke, a kum waina wit diat ilak paat ma diat tawa, ma a muaana pa i nunurai baa diat ilak lelawaai. ");
INSERT INTO rai_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A pia ut i watawa in diwaai na wit lenbi: a dondono i ilak paat muga ma namur in diwaaina i tawa tato, ma a waina i murmur aakit. ");
INSERT INTO rai_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Baa a kum waina diat aa mugaan ma a kalaang na tinangaa ia waan paat, a muaana in kutu pa diat.” ");
INSERT INTO rai_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu i piri taan diat naa, “Aawa ang welaara a mataanitu anun God mai? Ma woi na pirpir welwelaar ang welaarai mai? ");
INSERT INTO rai_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I welaar ma ra in waina maastad. I kinalik aakit ko ra kum waina diwaai raap, baa di maarut taai u ra pia. ");
INSERT INTO rai_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Baa di aa maarut taai, ma ia tawa, i ngaala aakit ko ra kum diwaai na winangaan raap ma i ung werweraana a kum ngaalangaala na gagagaana, ma ra kum pika diat laana paam pio u ra kum gagagaana baa i malur.” ");
INSERT INTO rai_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu i pirpir karom diat ma mongoro na pirpir welwelaar baa i welaar ma ra nundiat manaana, ");
INSERT INTO rai_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ma pa i pirpir karom diat ma ta pirpir ingen, a pirpir welwelaar raap ku. Ma baa diat maku ma ra nuna kum naat na wawer diat ki, i palaa maraagaam a kukuraai ra kum pirpir welwelaar. ");
INSERT INTO rai_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Io, baa ia maluraap u ra bung maa, Iesu i piri taa ra nuna kum naat na wawer naa, “Daat a waan bolo urong un raa papaara taai kikil.” ");
INSERT INTO rai_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma diat kaa karom Iesu u ra mon, ma diat waan ko ra kor na taara. Ma raa kum mon kaai diat weur ma diat. ");
INSERT INTO rai_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma a dekdek na dadaip i waan paat, ma a top i wawakaa unaanga u ra mon, ma marawaai in murung. ");
INSERT INTO rai_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Iesu i inep taau namur u ra mon ma i ululaang paa a pilo. A kum naat na wawer diat waanguni, ma diat piri taana, “Tena Wawer, daat wirua ma! Lelawaai, pa u ngaraa un daat?” ");
INSERT INTO rai_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Io, i kaamtur, i turbaat a dadaip, ma i piri taa ra pakaana taai, “Un ngo! Un malila.” Ma a dadaip i ngo, ma ra pakaana taai i malila maut. ");
INSERT INTO rai_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu i piri taan diat naa, “Aawa kabina maa muaat burut? Lelawaai, pa muaat nurnur utbaai?” ");
INSERT INTO rai_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma diat burut dekdek, ma diat tiri wetwetalaai diat naa, “Woi na mangaana muaana ma mi, baa a dadaip ma ra pakaana taai diaar taraam karomi?” ");
INSERT INTO rai_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ma ra nuna kum naat na wawer diat pukaai un raa papaara taai Gaalilaia, u ra papaar anu ra taara Geraasaa. ");
INSERT INTO rai_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baa i pari ko ra mon, raa muaana taanga u ra kum babaang na minaat, baa a tabaraan i ruk taau uni, i waan baraatai. ");
INSERT INTO rai_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A muaana maa, i lalaaun ku u ra kum babaang na minaat. Pa te i wi koto laar paai, a sen kaai pa i welaar mai. ");
INSERT INTO rai_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Di laana wi taa a ru limaana ma ra ru kakina ma ra kum sen, iaku i laana aal kutu wa ku a sen ko ra ru limaana, ma i laana kutu ginagina ku a sen ko ra ru kakina. Ma pa ta muaana i dekdek kupi in wamaraam paai. ");
INSERT INTO rai_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma i laana kulkulaai liklik ku u ra kum bungbung na mage ma ra marum naa ra kum babaang na minaat, ma u ra kum taangaai kaai, ma i pokpoko a panpanina ma ra kum waat. ");
INSERT INTO rai_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Baa i babo paa Iesu welwelik utbaai, i welulu ma i ki but keke ma ra urur namuga taana. ");
INSERT INTO rai_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma a muaana maa i kulkulaai ma ina ngaala na ingaana lenbi, “Aawa maa un paami un iaau Iesu, Natun God a Ngaala Aakit? Iaau aaring ui u ra iaan God baa koku u wakadik iaau.” ");
INSERT INTO rai_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I piri lenmi, kabina maa Iesu ia pir taai taana lenbi, “Ui a tabaraan. Pari ko ra muaana mi!” ");
INSERT INTO rai_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma Iesu i tiri naa, “Woi na iaam?” Ma i baalui naa, “A iaang a Liur na tabaraan, maa miaat mongoro aakit.” ");
INSERT INTO rai_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma diat aaring adekdek Iesu kupi koku i tula wa diat ko ra wanua maa. ");
INSERT INTO rai_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A ngaala na liur na boro diat wangwangaan matira u ra papaara taangaai. ");
INSERT INTO rai_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A kum tabaraan diat aaring Iesu naa, “Un tula wa miaat kup a kum boro kupi miaat a ruk taau un diat.” ");
INSERT INTO rai_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma Iesu i taraam wa diat. Ma diat pari ko ra muaana maa, ma diat ruk taau u ra kum boro. Ma a kum boro diat welulu pari u ra papaara taangaai kup a taai kikil, ma diat kongo raap. A kum boro raap maa i welaar duk ma 2,000. ");
INSERT INTO rai_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Diat baa diat baboura a kum boro, diat welulu talili, ma diat wewapua u ra utnaa mi u ra nundiat taamaan, ma un raa kum taamtaamaan liklik kaai. Ma a taara diat waan kupi diat a babo a utnaa mi i waan paat. ");
INSERT INTO rai_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baa diat waan paat karom Iesu, diat babo a muaana baa a liur na tabaraan diat pari paa koni. Kuraa maku i ki, ia gop balet ma ia manaana. Ma a taara diat burut. ");
INSERT INTO rai_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma diat baa diat babo taa a utnaa baa Iesu i paami, diat wapua a taara u ra utnaa baa i waan paat karom a muaana baa a kum tabaraan diat ruk taau uni, ma u ra kum boro kaai. ");
INSERT INTO rai_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Namur diat aaring Iesu kupi in waan ingen ko ra nundiat papaar. ");
INSERT INTO rai_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Baa Iesu i kaa u ra mon, a muaana baa namuga a kum tabaraan diat ruk taau uni, i aaring Iesu kupi diaar a weur. ");
INSERT INTO rai_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iaku Iesu pa i taraam, i piri ku taana lenbi, “Un waan karom a kum kakum, ma un wapua diat u ra ngaala na utnaa mi a Tadaaru ia paam taai un ui, ma baa i maari aakit ui.” ");
INSERT INTO rai_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Io, i waan, ma i wewapua waanwaan irong u ra papaar Dekaapolis u ra ngaala na utnaa baa Iesu ia paam taai uni. Ma a taara raap diat kakaian. ");
INSERT INTO rai_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu i kaa u ra mon ma i waan talili balet urong un raa papaara taai kikil. Baa i ki nakono a ngaala na kor na taara diat liur baat paai. ");
INSERT INTO rai_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Raa mukmuga u ra ruma na lotu a iaana Iaairo, i waan paat. Baa i babo Iesu, i puka ruru taau namuga naana, ");
INSERT INTO rai_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma i aaring dekdeki lenbi, “Natunglik a tabuan, marawaai ma in maat. Aiaap, daar a waan ma un ung a ru limaam nate uni, kupi in laangalaanga balet ma in lalaaun.” ");
INSERT INTO rai_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Baa diaar weur waanwaan a ngaala na kor na taara diat murmur Iesu, ma diat liur baat paai ma pa ta kolo ma. ");
INSERT INTO rai_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma raa tabuan i malaapaang ma ra malaapaang na gaap. Ia malaapaang paa 12 kilaala. ");
INSERT INTO rai_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ia waan paa karom a mongoro na doktaa kupi diat a waraauti, iaku diat taar a ngaala na ngunungut karomi ma diat waraap paa anuna maani. Ma i aaka aakit bakaai ma a malaapaang maa uni. ");
INSERT INTO rai_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Baa i walangoro a pirpir un Iesu, i nuki lenbi, “Baa ang paam taa ku anuna ina maalu, ang laangalaanga balet.” Io, i waan namur naana naliwan taa ra kor na taara, ma i paam taa anuna ina maalu. ");
INSERT INTO rai_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma a gaap i ngo maut, ma a tabuan maa i kariaanai u ra panina baa a malaapaang ia raap. ");
INSERT INTO rai_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Baa Iesu i kariaanai naa a dekdek i waan koni, i tur tapuku naliwan taa ra kor na taara, ma i wetiri naa, “Woi maa i paam taa anung ina maalu?” ");
INSERT INTO rai_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anuna kum naat na wawer diat piri taana naa, “U babo ut a kor na taara mi diat liur baat pa ui, lelawaai maa u wetiri naa, ‘Woi maa i paam ta iaau?’” ");
INSERT INTO rai_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Iesu i babo taltalili kup ia baa i paam taai. ");
INSERT INTO rai_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A tabuan maa i burut, ma i dadader, maa i nuk paa a utnaa baa i waan paat uni. I waan karom Iesu, i puka ruru taau namuga naana, ma i pir apuaana a utnaa baa ia paam taai. ");
INSERT INTO rai_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Iesu i piri taana naa, “Natunglik, anum nurnur ia walaangalaanga pa ui. Un waan ma ra maalmaal, anum malaapaang ia raap.” ");
INSERT INTO rai_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Baa Iesu i pirpir utbaai, raa taara diat waan paat taangirong u ra ruma anun Iaairo, ma diat piri naa, “Aawa kabina baa u wabalaana a Tena Wawer? Natumlik ia maat.” ");
INSERT INTO rai_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu pa i ngaraa u ra pirpir maa, i piri ku taan Iaairo naa, “Koku u burut, un nurnur ku.” ");
INSERT INTO rai_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pa i mulaaot paa te kupi in murmuri, iaku i ben paa ku Petero, Iaakobo dina ma Ioaanes. ");
INSERT INTO rai_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Baa diat waan paat u ra ruma anun Iaairo, Iesu i walangoro a lagutur, a kulkulaai ma ra niluan. ");
INSERT INTO rai_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Baa i ruk, i piri taan diat, “Aawa kabina baa muaat lagutur ma muaat luan? A naatlik mi wakir i maat, i inep duman ku.” ");
INSERT INTO rai_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma diat nangonoi ku. I tula pari wa diat raap, ma i ben paa ku tamaa ra naat ma naana, ma ditul kaai baa ditul weur mai, ma diat ruk karom a naat. ");
INSERT INTO rai_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma Iesu i paam paa a limaa ra naat na tabuan maa, ma i piri taana naa, “Taalita koum!” A kukuraai ra pirpir maa, “Tabuan lik, iaau piri taam, un tur.” ");
INSERT INTO rai_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Io, i tur maut ma i waan, maa ia 12 anuna kilaala. Ma diat kakaian aakit uni. ");
INSERT INTO rai_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma Iesu i turbaat adekdek ta diat naa koku diat wewapua u ra utnaa mi. Ma i wetulaa kup ta utnaa kupi a tabuan lik maa in aani. ");
INSERT INTO rai_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu ma ra nuna kum naat na wawer diat waan paa taanga matira, ma diat waan paat u ra taamaan anun Iesu. ");
INSERT INTO rai_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","U ra Bung Saabaat i wer a taara u ra ruma na lotu, ma mongoro na taara baa diat walangoroi, diat kakaian aakit, ma diat piri naa, “A muaana mi i nunura lelawaai paa a kum utnaa mi? A mangaana manaana aawa mi di taar taai taana? Maa i paam a kum ngaala na utnaa na kakaian. ");
INSERT INTO rai_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia a tena paam ruma ku, a natun Maaria. A kum tatena liklik kaai, Iaakobo, Ioses, Iudaas ma Simon, ma ra kum tatena liklik in tabuan kuri ut daat lalaaun ungaai main.” Io, pa diat gaaia ma uni. ");
INSERT INTO rai_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu i piri taan diat naa, “Di urur karom a propet u ra kum taamtaamaan ingen, iaku diat ut u ra nuna taamaan, a kum kakuna ma diat kaai u ra nuna ruma pa diat rui.” ");
INSERT INTO rai_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iesu pa i paam laar paa ta mongoro na utnaa na kakaian matira, i ung ku a ru limaana un ta kum malaapaang, ma i walaangalaanga pa diat. ");
INSERT INTO rai_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma Iesu i kakaian baa pa diat nurnur uni. Namur Iesu i waan taltalili u ra kum taamtaamaan ma i wer a taara. ");
INSERT INTO rai_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ma i wataa paa a 12 naat na wawer, ma i tula wa diat rurudi, ma i taar taa a naagagon taan diat kupi diat a lu irok wa a kum tabaraan. ");
INSERT INTO rai_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I piri taan diat naa, “Koku muaat lo ta utnaa u ra numuaat winawaan, muaat a lo ku ina buka. Koku muaat lo ta utnaa na winangaan, koku ta bek ma koku muaat lo ta maani u ra numuaat kum maalu na winiwi. ");
INSERT INTO rai_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Muaat a waan ku ma ra su u ra kakimuaat, ma koku muaat lo ta maalu na wekiaa.” ");
INSERT INTO rai_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iesu i piri kaai taan diat naa, “Baa muaat a ki un ta ruma, muaat a ki ut matira tuk u ra bung baa muaat a waan ko ra taamaan maa. ");
INSERT INTO rai_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Baa a taara kon ta taamaan pa diat gaaia pa muaat ma pa diat walangoro anumuaat pirpir, baa muaat waan ko ra taamaan maa, muaat a tataanga wa a kabu ko ra kakimuaat, kupi a wakilang na watumaarang karom diat.” ");
INSERT INTO rai_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Io, diat waan ma diat warawaai karom a taara kupi diat a nukpuku. ");
INSERT INTO rai_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Diat lu irok wa mongoro na tabaraan, diat aalu mongoro na malaapaang ma ra wel, ma diat walaangalaanga pa diat. ");
INSERT INTO rai_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Erodes i walangoro a wewapua un Iesu, kabina a taara raap diat aa nunura Iesu. Raa taara diat piri uni naa, “A muaana mi ia Ioaanes a Tena Baapitaaiso, ia lalaaun balet ko ra minaat. Maa ia kabina baa i paam a kum utnaa na kakaian mi.” ");
INSERT INTO rai_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Raa taara kaai diat piri un Iesu naa, “Ia Eliaas.” Raa taara kaai diat piri uni lenbi, “Iesu ia raa propet welaar ma ra kum propet taanga namuga.” ");
INSERT INTO rai_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Baa Erodes i walangoro a kum utnaa mi un Iesu, i piri naa, “Iaau aa pakaat kutu wa in lorin Ioaanes, ma mi ia lalaaun paat balet ko ra minaat!” ");
INSERT INTO rai_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Namuga Erodes i tula wa anuna kum tena wineium ma diat aal paa Ioaanes, diat do paai ma diat waruk taai u ra ruma na karabus, kabina maa Ioaanes i pir taai taan Erodes naa, “Pa i takado baa u taulaa ma Erodiaa, tamaiaam.” Ioaanes i piri lenbi kabina Erodes ia aal paa Erodiaa a tabuan anun tenalik Pilipo, ma i taulaa mai. ");
INSERT INTO rai_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiaa i milikuaana Ioaanes ma i nemi kupi din aak dokoi kabina maa i takuna diaar u ra nundiaar tinaulaa. Pa i pet laar paai kupi in aak dokoi, ");
INSERT INTO rai_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","maa Erodes i burutaana Ioaanes, kabina i nunurai naa ia a koina muaana ma a tena takado. Lenmaa Erodes i baboura baat Ioaanes. I gaaia kupi in walangoro anuna pirpir, iaku i laklagon a nuknukina uni. ");
INSERT INTO rai_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Io, u ra bung na binabuta anun Erodes, Erodiaa i nuk paa aakapi kupi din aak doko Ioaanes. Erodes i paam a ngaala na lukaara kup a kum mukmuga ko ra nuna mataanitu, ma a kum mukmuga anu ra kum tena wineium, ma a kum mukmuga taangirong Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Baa diat ki u ra lukaara, natun Erodiaa a tabuan, i ruk ma i laagaar naan diat. Erodes ma ra taara baa diat wangaan ungaai mai diat gaaia aakit uni. Namur i piri taa ra tauraara maa lenbi, “Ang tabaara ui ma ta utnaa baa u nemi taang.” ");
INSERT INTO rai_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma i weweliman dekdek taana lenbi, “Aawa maku baa un aaringi kon iaau ang taari ku taam. Baa un aaring iaau kup ta kukur ko ra nung mataanitu ang taari ku.” ");
INSERT INTO rai_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Io, i waan karom naana ma i tiri naa, “Aawa maa ang aaringi koni?” Naana i baalui naa, “Un aaringi kup in lorin Ioaanes a Tena Baapitaaiso.” ");
INSERT INTO rai_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aiaap gagaa ku a tauraara maa i ruk karom king Erodes, ma i piri taana naa, “Mi ut un tabaara iaau ma in lorin Ioaanes a Tena Baapitaaiso un ta pelet.” ");
INSERT INTO rai_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","A king i tapunuk aakit. Iaku kabina baa ia weweliman taau naa aawa maku baa i aaringi koni in tabaarai ut mai, ma a taara baa diat ki ungaai mai u ra winangaan, diat aa walangoro taa anuna pirpir, io, pa i pet laar paai ma kupi in patut. ");
INSERT INTO rai_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","I tula gagaa wa a tena wineium kupi in lo taa in lorin Ioaanes karomi. A tena wineium i ruk u ra ruma na karabus, ma i pakaat kutu paa in lorin Ioaanes. ");
INSERT INTO rai_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I ung paai u ra pelet, ma i loi karom a tauraara maa, ma i taari karom naana. ");
INSERT INTO rai_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Baa a kum naat na wawer anun Ioaanes diat walangoroi, diat waan ma diat lo paa a minaatina ma diat waruk taai u ra babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A kum aapostolo diat waan talili karom Iesu, ma diat wapuai u ra kum utnaa raap baa diat aa paam taai, ma diat aa wer taa a taara uni. ");
INSERT INTO rai_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma Iesu i piri taan diat, “Muaat waan urin, daat a waan kup a bil na wanua, kupi muaat a ngo paa.” I piri lenbi kabina maa mongoro na taara diat waanwaan paat, ma pa ta pakaana bung kupi Iesu ma anuna kum aapostolo diat a wangaan uni. ");
INSERT INTO rai_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Io, diat kaa u ra mon ma diat waan kup a bil na wanua. ");
INSERT INTO rai_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mongoro na taara baa diat babo paa a mon, diat babo lele paa Iesu ma ra nuna kum naat na wawer. Diat welulu paa ko ra kum taamtaamaan ma diat muga paat taau u ra wanua baa diat a pukaai iaai. ");
INSERT INTO rai_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Baa Iesu i pukaai matira, i babo a ngaala na kor na taara. I maari aakit diat, maa diat welaar maku ma ra kum sip baa pa nundiat ta tena baboura. Ma i turpaai kupi in wer diat un mongoro na utnaa. ");
INSERT INTO rai_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Baa ia maluraap, anuna kum naat na wawer diat waan karomi, ma diat piri taana naa, “A bil na wanua ku mi, ma ia maluraap kaai. ");
INSERT INTO rai_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Un tula wa a taara mi kupi diat a waan kup a kum taamtaamaan liklik marawaai, ma un ta kum ngaala na taamaan kaai kupi diat a kul paa ta utnaa baa diat a aani.” ");
INSERT INTO rai_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iesu i baalu diat lenbi, “Muaat ut maa muaat a tabaara diat.” Diat piri taana naa, “Taangawaai ta 200 na denaaria maa daat a kul tabaara diat mai?” ");
INSERT INTO rai_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma Iesu i tiri diat, “Taiaain bred kuraa muaat loi? Muaat a waan ma muaat a babo.” Baa diat aa manaana paa diat wapua Iesu naa, “Limnain bred ku kuri ma ruina ian kaai.” ");
INSERT INTO rai_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma Iesu i tula nuna kum naat na wawer naa diat a wapua a taara kupi diat a ki u ra kum kikil u ra in wali. ");
INSERT INTO rai_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Io, diat ki u ra kum kikil, raa kum kikil raaraa maar, ma raa mangaan limlima na noina. ");
INSERT INTO rai_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Iesu i rakaan paa limnain bred ma ruina ian, i tataada unaanga u ra maawa, i waatung wakaak paa karom God uni, i bik paa limnain bred maa ma i taar taai taa ra nuna kum naat na wawer kupi diat a palau a taara mai. I palau diat raap kaai ma ra ruina ian. ");
INSERT INTO rai_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Diat raap diat wangaan ma diat maaur. ");
INSERT INTO rai_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma diat wangaana ateng paa 12 kaa ma ra bred ma ra ian baa diat aan kapo taai. ");
INSERT INTO rai_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A kor na taara maa, a niluluk i ra in muaana ku i welaar ma 5,000. ");
INSERT INTO rai_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Namur Iesu i tula gagaa wa anuna kum naat na wawer kupi diat a kaa u ra mon ma diat a muga urong Betsaaida un raa papaara taai kikil. Ma ia i ki utbaai kupi in tula wa a taara. ");
INSERT INTO rai_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Baa a taara diat aa waan weraan, Iesu i waan tato unaanga u ra taangaai kupi in aaraaring. ");
INSERT INTO rai_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Baa i tawiwibung, a mon ia waan naliwan u ra taai kikil, ma Iesu maku i ki nakono. ");
INSERT INTO rai_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iesu i babo diat baa ia taket diat a winalua, kabina a dadaip i weium taanga namuga. Naliwan taan tuluina pakaana bung ma 6 na pakaana bung u ra malaana kinalik, Iesu i waan ku nate u ra taai kikil karom diat, ma i ling na waan aakit diat. ");
INSERT INTO rai_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Baa diat babo paai baa i waan nate u ra taai kikil, diat nuki naa a nion ku, ma diat kulkulaai. ");
INSERT INTO rai_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Diat raap diat baboi, ma diat burut aakit. Ma Iesu i pirpir gagaa maut karom diat naa, “Koku muaat ngaraa, iaau ku mi, koku muaat burut.” ");
INSERT INTO rai_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Baa Iesu ia kaa karom diat u ra mon, a dadaip i ngo maut. Diat kakaian aakit, ");
INSERT INTO rai_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","maa kabina pa diat manaana wakaak u ra utnaa na kakaian baa Iesu ia paam taai u ra bred ma ra ian. A balaandiat i dekdek. ");
INSERT INTO rai_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Baa diat aa waan bolo, diat pukaai taau nakono u ra papaar Genesaaret ma diat aagaa taa a mon. ");
INSERT INTO rai_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Baa diat waan pari ko ra mon, a taara diat babo lele gagaa paa maut Iesu. ");
INSERT INTO rai_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Diat welulu kup a kum malaapaang u ra kum taamtaamaan raap u ra papaar maa. Ma baa diat walangoroi naa Iesu kuraa i ki un raa taamaan, io, diat lo a kum malaapaang u ra kum luwu kup a taamaan maa. ");
INSERT INTO rai_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma u ra kum kinalik ma ra kum ngaalangaala na taamaan baa Iesu i waan iaai, diat wainep a kum malaapaang u ra balaa ra taamaan, ma a kum malaapaang diat aaring Iesu kupi diat a paam taa ku titi ra nuna ina maalu. Io, diat raap baa diat paam taai, diat laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A kum Parisaaio ma ra kum tena wawer u ra kum Naagagon taanginaanga Ierusalem, diat waan ungaai karom Iesu, ");
INSERT INTO rai_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ma diat babo raa kum naat na wawer anun Iesu baa diat wangaan ku ma ra dur na limaandiat baa pa diat gigi muga paa. ");
INSERT INTO rai_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Maa a kum Parisaaio ma ra kum taara Iudaia raap diat murmur a pirpir anu ra taara taanga namuga, ma pa diat wangaan, baa pa diat gi muga paa a limaandiat. ");
INSERT INTO rai_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Baa diat waan paat taangirong u ra wanua na wiura, diat gigi muga paa ut, namur diat wangaan. Mongoro na utnaa utkaai diat laana paami, diat dur a kum kaap, a kum kuro, ma ra kum tiker. ");
INSERT INTO rai_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A kum Parisaaio ma ra kum tena wawer u ra kum Naagagon diat tiri Iesu naa, “Aawa kabina maa anum kum naat na wawer pa diat murmur a kum wawer anu ra nundaat taara taanga namuga? Diat wangaan ku ma ra kum dur na limaandiat.” ");
INSERT INTO rai_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Iesu i baalu diat naa, “A lingtatuna ut maa Aaisaia ia pirpir na propet muga taau un muaat a kum tena warwaruga naa, ‘A taara mi diat ru iaau ku ma ra waandiat, iaku maa a balaandiat i welwelik aakit kon iaau. ");
INSERT INTO rai_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Diat lotu biaa ku karom iaau, maa diat wer ku a taara ma ra kum naagagon anu ra taara ut.’ Aais 29:13 ");
INSERT INTO rai_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Muaat aa waan paa ko ra kum Naagagon anun God, ma muaat murmur maku a kum wawer anu ra taara.” ");
INSERT INTO rai_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma Iesu i piri balet taan diat naa, “A lingtatuna aakit, muaat wabulbul wa a Naagagon anun God kupi muaat a murmur ku a kum wawer anu ra numuaat taara taanga namuga. ");
INSERT INTO rai_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses i piri lenbi, ‘Un ru tamaam ma naam,’ Pin 20:12 ma i piri kaai lenbi, ‘Baa te in pirpir aakaka un tamaana ma naana, din aak dokoi.’ Pin 21:17 ");
INSERT INTO rai_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Iaku muaat, muaat wer a taara naa i koina ku baa te in piri taan tamaana ma naana naa, ‘A utnaa baa ang waraaut mur mai, iaau aa tabaara taa God mai.’ ");
INSERT INTO rai_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Io, muaat turbaati ku kupi koku i waraaut tamaana ma naana. ");
INSERT INTO rai_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Baa muaat paami lenmi, muaat wakinalik paa a pirpir anun God ma muaat murmur ku a kum wawer baa muaat loi ko ra numuaat taara taanga namuga. Ma mongoro na utnaa kaai lenmi muaat laana paami.” ");
INSERT INTO rai_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu i wataa paa balet a taara karomi, ma i piri taan diat naa, “Muaat raap muaat a walangoro iaau, ma muaat a nunura lele anung pirpir. ");
INSERT INTO rai_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ta utnaa baa te in aan paai ma i ruk u ra in balaana, wakir in aaka uni namataan God. Iaku a kum utnaa baa i pari paa ko ra nuknukina, ia maa in aaka uni.” ");
INSERT INTO rai_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Baa ia waan paa ko ra kor na taara, ma i ruk unaruma, anuna kum naat na wawer diat tiri u ra pirpir welwelaar mi. ");
INSERT INTO rai_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma i piri taan diat lenbi, “Muaat kaai pa muaat manaana utbaai? Pa muaat nunurai naa a kum utnaa raap baa i ruk u ra in balaan te, pa in baanaakakai namataan God? ");
INSERT INTO rai_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kabina maa pa i ruk u ra nuknukina, i ruk ku u ra in balaana ma i babaa wai balet.” Baa i pir a pirpir mi i pir akoina paa a kum utnaa na winangaan raap. ");
INSERT INTO rai_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I piri kaai lenbi, “A utnaa baa i pari paa ko ra nuknukin te, ia maa in baanaakakai.” ");
INSERT INTO rai_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bi ia a kum utnaa baa i waan paat ko ra nuknuki ra taara: a kum aakaina nuknuk, a kum paamuk na mangamangaan, a winalong, aak doko taara, di aal paa a tabuan anun te, ");
INSERT INTO rai_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a nemnem kup a ngaala na utnaa, a kum aakaakaina pinapaam, a kum warwaruga, a kum aakaina nemnem, a nuknuk aakaka, a pirura, te baa i wangaala pa ia ut, ma ra kum longlong na mangamangaan. ");
INSERT INTO rai_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A kum aakaakaina utnaa mi diat waan paat ko ra nuknuki ra taara, ma i baanaakaka diat. ");
INSERT INTO rai_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu i waan ko ra taamaan maa, ma i waan paat marawaai a taamaan Tiro. I ruk un raa ruma. Pa i nemi kupi te in nunurai, iaku pa i ki ino laar paai. ");
INSERT INTO rai_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Raa tabuan, natunalik a tabuan a tabaraan i ruk taau uni. Baa i walangoro a pirpir un Iesu, i welulu gagaa, ma i puka ruru namuga naan Iesu. ");
INSERT INTO rai_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A tabuan maa a tabuan Ponikaa taanga u ra papaar Siria, wakir ia a tabuan Iudaia. I aaring Iesu kupi in lu irok wa a tabaraan kon natunalik. ");
INSERT INTO rai_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Iesu i piri taana naa, “Din tabaara maaur muga taa a kum naat. Pa i takado kupi din lo paa a utnaa ara kum naat, ma din tabaara a kum paap mai.” ");
INSERT INTO rai_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma a tabuan maa i baalui naa, “A lingtatuna ut maa Tadaaru, iaku a kum paap kaai diat laana aan a kum mutamuta na utnaa natudaangi ra luwu na winangaan anu ra kum naat.” ");
INSERT INTO rai_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma Iesu i piri taa ra tabuan maa lenbi, “Kabina u ra num koina binabaalu, un waan ku, a tabaraan ia pari paa kon natumlik.” ");
INSERT INTO rai_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Baa a tabuan i waan talili balet, i babo paa natunalik, kuraa i inep taau u ra baana. A tabaraan ia pari paa koni. ");
INSERT INTO rai_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu i waan paa ko ra taamaan Tiro ma i waan likaai Sidon kup a taai kikil Gaalilaia, ma i waan paat u ra papaar Dekaapolis. ");
INSERT INTO rai_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A taara diat ben paa raa muaana i lengbaa ma i munga karom Iesu, ma diat aaringi kupi in ung a ru limaana uni. ");
INSERT INTO rai_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu i ben ingen paai ku ko ra kor na taara, ma i ung taa ruin kaalkaali na limaana u ra ruin talingaa ra muaana maa, i gaar paa ma i paam in kaarme ra muaana. ");
INSERT INTO rai_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I tataada unaanga u ra maawa, i lo dadaip paa, ma i piri taana naa, “Epaataa!” a kukuraaina naa: “Un tapaapa!” ");
INSERT INTO rai_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Io, in talingaana i kaapa, in kaarmene i tapalaa ma i pirpir paat maut. ");
INSERT INTO rai_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Iesu i turbaat dekdek taa a taara naa koku diat wapua te uni. Iaku baa i turbaat diat, pa diat walangoroi, a wewapua uni i waan werweraan ku. ");
INSERT INTO rai_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Diat baa diat walangoro a utnaa mi, diat kakaian aakit uni, ma diat piri lenbi, “Iesu i paam wakaak paa a kum utnaa raap, i wakoina paa a kum lengbaa kupi diat a walangor, ma a kum munga kupi diat a pirpir!” ");
INSERT INTO rai_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Raa bung balet a ngaala na kor na taara diat waan ungaai, ma pa ta utnaa na winangaan kupi diat a aani. Iesu i wataa paa anuna kum naat na wawer karomi, ma i piri taan diat naa, ");
INSERT INTO rai_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Iaau maari aakit a taara mi, maa diat aa ki ungaai ma daat min tula bung, ma pa ta utnaa na winangaan baa diat a aani. ");
INSERT INTO rai_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Baa ang tula wa diat kup anundiat kum taamtaamaan ma ra minolo, diat a bengbeng waanwaan u ra aakapi, maa raa taara kon diat, diat waan ut taanga welwelik.” ");
INSERT INTO rai_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Anuna kum naat na wawer diat tiri naa, “Taangawaai ma ta utnaa na winangaan baa daat a tabaara diat mai, maa a bil na wanua ku mi?” ");
INSERT INTO rai_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu i tiri diat naa, “Taiaain bred maa kuraa muaat loi?” Diat baalui naa, “7 maku.” ");
INSERT INTO rai_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu i tula a taara raap kupi diat a ki unapia. I lo paa 7 na bred, i waatung wakaak paa uni karom God, i biki ma i taari karom anuna kum naat na wawer kupi diat a tabaara a taara mai. Io, a kum naat na wawer diat paami lenmaa. ");
INSERT INTO rai_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Diat lo paa a kabaana ina ian kaai, ma i waatung wakaak paa uni, ma i taar taai kupi diat a palau a taara mai. ");
INSERT INTO rai_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A taara diat wangaan ma diat maaur. Diat wangaana teng paa 7 na kaa ma ra kum utnaa baa diat aan kapo taai. ");
INSERT INTO rai_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A in tabuan ma ra kum naat liklik ma in muaana diat raap diat wangaan. A niluluk i ra in muaana ku i welaar ma 4,000. Ma namur Iesu i tula wa diat. ");
INSERT INTO rai_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma i kaa u ra mon ungaai ma ra nuna kum naat na wawer, ma diat waan kup a papaar Daalmaanutaa. ");
INSERT INTO rai_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A kum Parisaaio diat waan paat karom Iesu ma diat weol na pirpir mai. Diat aaringi naa in paam ta utnaa na kakaian kupi in wakilangi naa ia taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu i riritan paa, ma i piri naa, “Aawa a kabina maa a taaun taara mi diat aaring kup ta wakilang? Mi iaau pir a lingtatuna taa muaat, pa din paam ta wakilang karom muaat.” ");
INSERT INTO rai_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Io, i kaa balet u ra mon, ma i waan paa kon diat urong un raa papaara taai kikil. ");
INSERT INTO rai_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A kum naat na wawer diat dumaana wai naa diat a lo ta kum bred, raain ot ku maa diat loi u ra mon. ");
INSERT INTO rai_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Iesu i watumaarang diat naa, “Muaat a baboura muaat ko ra is anu ra kum Parisaaio, ma anun Erodes.” ");
INSERT INTO rai_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma diat pirpir ungaai u ra kukuraai ra pirpir anun Iesu, ma diat piri naa, “I piri lenmaa kabina duk maa pandaat ta bred.” ");
INSERT INTO rai_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu i nunura nundiat pirpir ma i piri taan diat naa, “I lawaai maa muaat piri naa pa ta bred? Pa muaat manaana ma pa muaat kaapa utbaai? Lelawaai, a balaamuaat i dekdek? ");
INSERT INTO rai_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A kiok na mataamuaat i ki, iaku pa muaat babo mai. A talingaamuaat i ki, iaku pa muaat walangor mai. Muaat a nuk paai: ");
INSERT INTO rai_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Baa iaau bik limnain bred karom 5,000 na muaana, taiaa kaa muaat wateng paai balet ma ra utnaa na winangaan baa i ki kapo?” Diat baalui naa, “12.” ");
INSERT INTO rai_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma baa iaau bik 7 na bred karom 4,000 na muaana, taiaa kaa muaat wateng paai ma ra utnaa i ki kapo?” Ma diat baalui naa, “7 na kaa.” ");
INSERT INTO rai_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma i tiri diat naa, “Pa muaat manaana utbaai?” ");
INSERT INTO rai_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu ma ra nuna kum naat na wawer diat waan paat irong Betsaaida, ma a taara diat ben paa raa pula karomi, ma diat aaringi naa in ung a limaana uni kupi in babo. ");
INSERT INTO rai_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I paam paa a limaa ra pula, ma i ben ingen paai ko ra taamaan, i kamia taa a mataa ra pula, i ung taa a ru limaana uni, ma i tiri naa, “U aa babo ta utnaa?” ");
INSERT INTO rai_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma a muaana maa i babo kado, ma i piri naa, “Iaau babo ku a taara diat welaar ma ra kum diwaai baa diat waanwaan.” ");
INSERT INTO rai_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma Iesu i ung balet a ru limaana u ra mataa ra pula, ma a mataana i kaapa wakaak maraagaam, ma i babo a kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu i tula wa a muaana maa, ma i piri taana naa, “Un waan takado kup anum ruma. Koku u ruk nabalaa ra taamaan.” ");
INSERT INTO rai_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu ma ra nuna kum naat na wawer diat waan kup a kum taamtaamaan marawaai Kaaisaaria Pilipoi. Baa diat waan waanwaan, i tiri diat naa, “A taara diat piri naa iaau woi?” ");
INSERT INTO rai_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Diat baalui naa, “Raa taara diat piri naa ui Ioaanes a Tena Baapitaaiso. Raa taara kaai diat piri naa ui Eliaas, ma raa taara kaai diat piri naa ui raa kon diat a kum propet.” ");
INSERT INTO rai_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma i tiri diat naa, “Io muaat, muaat piri naa iaau woi?” Ma Petero i baalui naa, “Ui Kaarisito baa God i tula wa ui urin.” ");
INSERT INTO rai_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma i turbaat diat naa koku diat wapua te uni. ");
INSERT INTO rai_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu i turpaai kupi in wer anuna kum naat na wawer lenbi, “A Natu ra Muaana in kariaana mongoro na mawaat, ma a kum mukmuga, a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon diat a weoro wai ma din aak dokoi. Ma baa tula bung in raap in lalaaun paat balet.” ");
INSERT INTO rai_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A pirpir mi anun Iesu i kaapa ku. Ma Petero i ben ingen paai ma i turbaat dekdeki. ");
INSERT INTO rai_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iesu i tapuku, ma i babo karom anuna kum naat na wawer, ma i pirpir dekdek karom Petero naa, “Saataan, un waan unamur kon iaau! Maa u murmur ku a nuknuki ra taara, ma pa u murmur a nuknukin God.” ");
INSERT INTO rai_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesu i wataa paa a kor na taara ungaai ma ra nuna kum naat na wawer karomi, ma i piri taan diat naa, “Baa te i nemi kupi in murmur iaau, koku i murmur a nuknukina. In puak paa anuna bolo ma in murmur iaau. ");
INSERT INTO rai_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Baa te i maari baat paa ku anuna lalaaun in wirua, iaku ia baa pa i maari baat anuna lalaaun kup iaau, ma u ra Koina Wewapua kaai, in lalaaun. ");
INSERT INTO rai_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","In koina lelawaai baa te i kale raap paa a rakrakaan buaal, ma in baanaakaka wa a niono uni? ");
INSERT INTO rai_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","In kul kiaana a niono ma ra aawa? ");
INSERT INTO rai_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Baa te in wawirwir kon iaau ma u ra nung kum pirpir karom a taaun taara mi baa anundiat lalaaun i welwelik kon God, ma diat a kum tena paam aakaina, Natu ra Muaana kaai in wawirwir koni baa in waan paat ma ra nuna kum aangelo ma ra minamaar anun Tamaana.” ");
INSERT INTO rai_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma i piri taan diat naa, “Iaau pir a lingtatuna taa muaat, ta taara kon muaat mi, muaat tur min, baa pa muaat a maat utbaai, muaat a babo a mataanitu anun God in waan paat ma ra dekdek.” ");
INSERT INTO rai_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Baa ia raap 6 na bung, Iesu i ben paa Petero, Iaakobo ma Ioaanes, ma i ben ingen pa ditul unaanga u ra taangaai baa i tur tato aakit. Ma ditul babo a panin Iesu i raaungaana. ");
INSERT INTO rai_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma anuna kum maalu i papakaat ma i kabaang dekdek aakit, ma pa te taanga min napia in gi agomgom paa tina maalu lenmaa. ");
INSERT INTO rai_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma a tula naat na wawer ditul babo paa Eliaas ma Moses diaar waan paat ma ditul pirpir ma Iesu. ");
INSERT INTO rai_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ma a tula naat na wawer ditul burut aakit ma Petero pa i nunurai baa aawa in piri, io i piri maku taan Iesu naa, “Tena Wawer i koina baa daat a ki maku min. Mitul a paam ta tula palpalip, num raa, raa anun Moses, ma raa anun Eliaas.” ");
INSERT INTO rai_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Namur a pakaana baakut i pulu baat pa diat. Ma in ingaan raa taanga u ra baakut i piri naa, “Bi ia Natunglik, a naat na wakwakaak. Muaat a walangoroi.” ");
INSERT INTO rai_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Baa ditul babo taltalili, pa ditul babo balet ma te, Iesu ot maku kuraa i tur ungaai ma ditul. ");
INSERT INTO rai_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Baa diat waan pari waanwaan taanginaanga u ra taangaai, Iesu i turbaat ditul kupi koku ditul wapua taa te u ra kum utnaa mi ditul aa babo taai, tuk u ra bung baa Natu ra Muaana in tur balet ko ra minaat. ");
INSERT INTO rai_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma ditul murmur a pirpir maa, ma ditul tiri wetwetalaai ditul naa, “Aawa a kukuraai ra lalaaun balet ko ra minaat?” ");
INSERT INTO rai_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma ditul tiri Iesu naa, “Aawa kabina maa a kum tena wawer u ra kum Naagagon diat piri naa Eliaas in waan paat muga?” ");
INSERT INTO rai_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I baalu ditul naa, “A lingtatuna ut, Eliaas in waan paat muga ma in wakado balet a kum utnaa raap. Ma aawa kabina baa di aa timu taai u ra Buk Taabu naa Natu ra Muaana in kariaana mongoro na ngunungut ma din weoro wai? ");
INSERT INTO rai_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma mi iaau piri taa mutul naa Eliaas ia waan paat, ma diat paam a kum aakaina mangamangaan karomi welaar ma ra nundiat nemnem, welaar ma di aa timu taai uni u ra Buk Taabu.” ");
INSERT INTO rai_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Baa Iesu ma ra tula naat na wawer diat waan pari karom a kum naat na wawer, diat babo paa a ngaala na kor na taara diat tur lili pa diat, ma a kum tena wawer u ra kum Naagagon kuraa diat weol na pirpir ma ra kum naat na wawer. ");
INSERT INTO rai_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Baa a taara diat babo paa Iesu, diat kakaian aakit, ma diat welulu ma diat gaaia baraata paai. ");
INSERT INTO rai_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma Iesu i tiri anuna kum naat na wawer naa, “Aawa maa muaat weol na pirpir uni?” ");
INSERT INTO rai_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Raa muaana ko ra taara i baalui naa, “Tena Wawer, iaau ben paa natunglik a naat muaana karom ui, maa a tabaraan i ruk taau uni ma pa i pet laar paa a pirpir. ");
INSERT INTO rai_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Baa a tabaraan mi i laana umi, i laana ong kuraa taai napia, ma a naat i buabua a waana ma a lakono i paarngingit ma i dodo a panpanina. Iaau aaring anum kum naat na wawer kupi diat a lu irok wa a tabaraan koni, iaku pa diat pet laar paai.” ");
INSERT INTO rai_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu i baalu diat lenbi, “Muaat a taaun taara mi, pa muaat nurnur! Iaau aa ki iwan karom muaat. Unaangaian ma muaat a nurnur? Muaat a ben a naat maa urin karom iaau.” ");
INSERT INTO rai_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma diat ben paai karom Iesu. Baa a tabaraan i babo paa Iesu, i ong kuraa taa a naat maa napia, ma i gula taptapuku, ma i buabua a waana. ");
INSERT INTO rai_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma Iesu i tiri tamaa ra naat naa, “Naangaian maa i turpaai?” Ma i baalui naa, “I turpaai uni baa i naat kinalik utbaai. ");
INSERT INTO rai_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mongoro na bung a tabaraan i laana ong taai u ra nguan ma mongoro na bung kaai u ra daanim kupi in aak dokoi. Baa un pet laar paai kupi un lu irok wa a tabaraan koni, un maari mir, ma un waraaut mir.” ");
INSERT INTO rai_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu i piri taana, “Ui ut! Ia baa i nurnur i pet laar paa a kum utnaa raap.” ");
INSERT INTO rai_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma tamaa ra naat i kulkulaai gagaa ma ra pirpir lenbi, “Iaau nurnur! Waraaut iaau u ra nung kinalik na nurnur.” ");
INSERT INTO rai_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Baa Iesu i babo a kor na taara baa diat welulu ungaai, i pirpir dekdek karom a tabaraan naa, “Ui a munga ma a lengbaa na tabaraan, iaau piri taam un pari ko ra naat, ma koku balet ma u ruk uni.” ");
INSERT INTO rai_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A tabaraan i kulkulaai paa, i wadader adekdek taa a naat maa, ma i pari paa koni. A naat maa i welaar maku ma ra minaat, ma mongoro diat piri naa ia maat. ");
INSERT INTO rai_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iaku Iesu i paam paa a limaa ra naat, ma i aal atur paai. ");
INSERT INTO rai_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Io, baa diat ruk un raa ruma, anuna kum naat na wawer diat tiri inoi naa, “I lawaai maa pa miaat lu irok laar paa a tabaraan koni?” ");
INSERT INTO rai_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu i baalu diat naa, “A mangaana tabaraan lenmi in pari ku u ra niaaring, wakir un ta utnaa kaai.” ");
INSERT INTO rai_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Diat waan taanga matira, ma diat waan bolo irong u ra papaar Gaalilaia. Iesu i nem na wer anuna kum naat na wawer, ma pa i nemi naa te in nunura a wanua baa diat a ki iaai. Ma i piri naa, “Din taar taa Natu ra Muaana u ra limaa ra taara ma diat a aak dokoi. Ma baa tula bung in raap in lalaaun balet.” ");
INSERT INTO rai_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pa diat kaapa u ra kukuraai ra pirpir mi, ma diat burut kupi diat a tiri. ");
INSERT INTO rai_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Diat waan paat irong Kaapernaaum. Ma baa diat ruk unaruma, i tiri diat naa, “Aawa maa muaat weol na pirpir uni u ra aakapi?” ");
INSERT INTO rai_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma pa diat baalui, kabina maa diat weol na pirpir baa woi kon diat i ngaala aakit. ");
INSERT INTO rai_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Io, Iesu i ki ma i wataa paa anuna 12 naat na wawer, ma i piri taan diat lenbi, “Baa te i nemi kupi in ngaala aakit, i koina baa in wakinalik paai ku, in tultul ku karom a taara raap.” ");
INSERT INTO rai_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma i lo paa raa naatlik, ma i watur taai naliwan taan diat. Namur i romo paai, ma i piri taan diat naa, ");
INSERT INTO rai_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Baa te i gaaia paa ta naatlik lenbi u ra iaang, i gaaia pa iaau utkaai. Ma baa te i gaaia pa iaau, wakir i gaaia pa iaau ku, i gaaia paa ia ut baa i tula wa iaau urin.” ");
INSERT INTO rai_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioaanes i piri taan Iesu naa, “Tena Wawer, miaat babo raa muaana i lu irok wa a kum tabaraan u ra iaam, ma miaat turbaati, maa wakir ia kon daat.” ");
INSERT INTO rai_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu i baalui naa, “Koku muaat turbaati. Baa te in paam ta utnaa na kakaian u ra iaang, pa in waatung gagaa ta aakaina pirpir un iaau. ");
INSERT INTO rai_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maa ia baa pa i turbaat daat, i waraaut daat ku. ");
INSERT INTO rai_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iaau pir a lingtatuna taa muaat, baa te i tabaara muaat ma ta lik palaa, maa kabina muaat anun Kaarisito, in lo ut anuna wedok. ");
INSERT INTO rai_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Baa te i ben araara raa ko ra kum naat liklik bi baa i nurnur un iaau, in aaka aakit a naagagon karomi taan te baa din kubu taa ina ngaala na waat u ra in kabarono, ma din ong amurung wai nataai. ");
INSERT INTO rai_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Baa limaam i ben araara ui, un kutu wai. In koina baa un ruk u ra lalaaun takum a tum ku ui, kupi koku di ong ui ungaai ma ra ru limaam raap u ra ngaala na nguan baa pa in maat. ");
INSERT INTO rai_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Baa kakim i ben araara ui, un kutu wai. In koina baa un ruk u ra lalaaun takum a tum ku ui, kupi koku di ong ui ungaai ma ra ru kakim raap u ra ngaala na nguan. ");
INSERT INTO rai_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Baa in mataam i ben araara ui, un lior wai. In koina baa un ruk u ra mataanitu anun God ma raain mataam ku, kupi koku di ong ui ungaai ma ruin mataam raap u ra ngaala na nguan. ");
INSERT INTO rai_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Matira ‘a kum wuiwui liklik pa diat a maat, ma a nguan kaai pa in maat.’ Aais 66:24 ");
INSERT INTO rai_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Din wagomgom a taara raap ma ra nguan welaar ma ra wetabaar baa di wagomgomi ma ra sol. ");
INSERT INTO rai_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A sol i koina, iaku baa ia raap a mapaakina, muaat a wamapaak paai balet ma lelawaai? Painte! I koina kupi a sol in ki un muaat, ma muaat a ki na wemaraam ungaai.” ");
INSERT INTO rai_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu i waan taanga matira urong u ra papaar Iudaia, ma i waan bolo u ra daanim Ioridaan. A kor na taara diat waan karomi ma i wer diat balet welaar ma i laana paami. ");
INSERT INTO rai_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Raa kum Parisaaio diat waan karomi kupi diat a walaari. Diat tiri naa, “I takado ut welaar ma ra nundaat kum Naagagon baa a muaana in lu wa nuna tabuan, baa pate?” ");
INSERT INTO rai_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Iesu i tiri baalu diat naa, “Woi na naagagon maa Moses i taar taai taa muaat?” ");
INSERT INTO rai_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma diat baalui, “Moses i mulaaot taai ku kupi a muaana in timu taa a dona buk na kutu tinaulaa, kupi din palaa wa a kini na tinaulaa mai.” ");
INSERT INTO rai_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu i piri taan diat naa, “Moses i timu a naagagon maa kup muaat, kabina maa a balaamuaat i dekdek aakit. ");
INSERT INTO rai_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Iaku u ra turpaai ra wawaki, ‘God i waki a taara, kupi diat in muaana ma in tabuan’. Tur 1:27 ");
INSERT INTO rai_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mari ia a kabina baa a muaana in waan paa kon tamaana ma naana, ma in ki ungaai ma ra nuna tabuan, ");
INSERT INTO rai_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kupi diaar a raa maku.’ Tur 2:24 Ma wakir diaar rudi ma, diaar raa maku. ");
INSERT INTO rai_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A utnaa baa God ia kubu ungaai taai, koku balet ma te i kutui.” ");
INSERT INTO rai_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Io, baa diat ki naruma a kum naat na wawer diat tiri Iesu balet u ra utnaa mi. ");
INSERT INTO rai_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma i piri taan diat, “Baa te i lu wa anuna tabuan, ma i taulaa balet ma ta tabuan, a muaana maa i paam aakaina karom anuna mugaana tabuan. ");
INSERT INTO rai_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma baa ta tabuan i waan ko ra nuna muaana, ma i taulaa balet ma te, a tabuan maa ia kaai i paam aakaina.” ");
INSERT INTO rai_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A taara diat ben a kum naat liklik karom Iesu kupi in ung a ru limaana nate un diat. Iaku maa a kum naat na wawer diat turbaat diat. ");
INSERT INTO rai_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Baa Iesu i baboi, i kaankaan ma i piri taan diat naa, “Muaat a maadek wa a kum naat liklik baa diat a waan karom iaau. Koku muaat turbaat diat, maa a mataanitu anun God anundiat baa diat lenbi. ");
INSERT INTO rai_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iaau pir a lingtatuna taa muaat, baa te pa in ruk u ra mataanitu anun God welaar ma ra naatlik, pa in ruk laar paai.” ");
INSERT INTO rai_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma i lo paa a kum naat liklik, ma i ung taa a ru limaana nate un diat, ma i pir wadaan diat. ");
INSERT INTO rai_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Baa Iesu i waan waanwaan balet, raa muaana i welulu karomi, i ki but keke namataana, ma i tiri naa, “Koina Tena Wawer, aawa maa ang paami kupi ang kale a lalaaun takum?” ");
INSERT INTO rai_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu i baalui naa, “Aawa kabina maa u waatung iaau naa iaau koina? Pa te i koina, God ku. ");
INSERT INTO rai_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U nunura a kum Naagagon: ‘Koku u aak doko te, koku u paam aakaina un ta tabuan anun te, koku u walong, koku u wetakun warwaruga, koku u waruga paa ta utnaa anun te ma u lo paai, un urur karom tamaam ma naam.’” Pin 20:12-16 ");
INSERT INTO rai_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A muaana maa i baalui naa, “Tena Wawer, turpaai baa iaau naat utbaai tuk mi, iaau tartaraam u ra kum Naagagon raap mi.” ");
INSERT INTO rai_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu i babo karomi, i maari ma i piri taana naa, “U iba utbaai kup raa utnaa. Un waan ma un wiura wa anum kum utnaa raap, ma ra maani koni un tabaara a kum iba na taara mai. Baa un paami lenmaa anum a koina wuwuwung inaanga u ra maawa. Namur un waan urin ma un murmur iaau.” ");
INSERT INTO rai_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Baa i walangoro a pirpir mi, i babo tumtumul, ma i waan ma ra tapunuk, kabina maa i ngaala aakit anuna wuwuwung. ");
INSERT INTO rai_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu i babo taltalili karom anuna kum naat na wawer ma i piri taan diat lenbi, “I dekdek aakit karom a kum tadaaru na taara kupi diat a ruk u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A kum naat na wawer diat kakaian aakit u ra pirpir mi. Iesu i piri balet taan diat naa, “A kum natnatung liklik, i dekdek aakit karom a taara kupi diat a ruk u ra mataanitu anun God. ");
INSERT INTO rai_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I dekdek karom a kaamel kupi in ruk u ra maata na nil na ingingit, iaku i dekdek aakit karom a tadaaru na muaana kupi in ruk u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A kum naat na wawer diat kakaian aakit, ma diat tiri wetwetalaai diat naa, “Baa lenmaa, woi ma maa din walaauni?” ");
INSERT INTO rai_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu i babo karom diat ma i piri, “A taara pain diat a pet laar paai, iaku God in pet laar paa a kum utnaa raap.” ");
INSERT INTO rai_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero i piri taan Iesu naa, “Baboi, miaat aa waan ko ra numiaat kum utnaa raap, ma miaat murmur ui.” ");
INSERT INTO rai_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu i piri naa, “Iaau pir a lingtatuna taa muaat: Baa te i waan ko ra nuna ruma, baa ko ra kum tatena liklik in muaana ma in tabuan, baa kon naana, baa tamaana, baa a kum natnatuna, baa ko ra nuna pia, kabina un iaau ma u ra Koina Wewapua, ");
INSERT INTO rai_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","u ra lalaaun mi, din taar taa 100 na ruma taana, 100 na tatena liklik in muaana, 100 na tatena liklik in tabuan, 100 na naana, 100 na natnatuna, ma 100 na pia, ma ra kum ngunungut utkaai. Ma u ra lalaaun namur din tabaarai ma ra lalaaun takum. ");
INSERT INTO rai_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma mongoro baa diat muga mi, namur diat a murmur, ma diat baa diat murmur mi, namur diat a muga.” ");
INSERT INTO rai_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu ma ra nuna kum naat na wawer diat waan unaanga Ierusalem. Ma Iesu i mukmuga taan diat, ma anuna kum naat na wawer diat nuknuk aakit, ma a taara kaai baa diat murmuri diat burut. Ma Iesu i ben ingen paa anuna 12 naat na wawer, ma i wapua diat u ra kum utnaa baa in waan paat karomi lenbi, ");
INSERT INTO rai_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Baboi, mi daat waan unaanga Ierusalem. Din taar taa Natu ra Muaana karom a kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon. Diat a naagagoni kupi in wirua, ma diat a taar taai karom diat baa wakir a taara Iudaia. ");
INSERT INTO rai_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Diat a tataur uni, diat a kamiai, diat a raapui ma diat a aak dokoi. Ma baa tula bung in raap in lalaaun paat balet.” ");
INSERT INTO rai_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A ru natun Sebedaaio, Iaakobo ma Ioaanes, diaar waan karom Iesu ma diaar piri taana lenbi, “Tena Wawer, mir aaring ui kupi un paam a utnaa bi mir nemi taam.” ");
INSERT INTO rai_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma i tiri diaar naa, “Aawa maa mur nemi taang?” ");
INSERT INTO rai_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Diaar piri taana, “Un waki ta mir u ra num minamaar, ma datul a naagagon ungaai, raa paa mir u ra ot na limaam ma raa u ra maira.” ");
INSERT INTO rai_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesu i piri taan diaar naa, “Pa mur nunura a utnaa maa mur aaring kupi. Lelawaai, in tale mur kupi mur kaai mur a kariaana a ngunungut baa ang kariaanai? In tale mur kaai kupi din baapitaaiso mur ma ra baapitaaiso na minaat baa din baapitaaiso iaau mai?” ");
INSERT INTO rai_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma diaar baalui naa, “Mir a pet laar paai ku.” Iesu i piri taan diaar, “A ngunungut baa ang kariaanai, mur kaai mur a kariaanai, ma a baapitaaiso baa din baapitaaiso iaau mai, din baapitaaiso mur kaai mai. ");
INSERT INTO rai_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Iaku u ra kinkini u ra ot ma ra maira na limaang, wakir iaau, iaau naagagoni kupi ang taari. God in taari karom diat baa ia waninaar taai kup diat.” ");
INSERT INTO rai_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baa 10 naat na wawer diat walangoroi, diat kaankaan karom Iaakobo ma Ioaanes. ");
INSERT INTO rai_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu i wataa ungaai pa diat, ma i piri naa, “Muaat nunurai naa diat baa di waatung diat a kum tena naagagon anu ra taara baa wakir a taara Iudaia, diat naagagon aakaka a taara. Ma anundiat kum mukmuga kaai diat taar a kum dekdek na naagagon karom diat. ");
INSERT INTO rai_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Iaku karom muaat pa in lenmaa. Baa te i nemi naa in ngaala taa muaat, in wakinalik paai kupi in tultul anumuaat. ");
INSERT INTO rai_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma ia baa i nemi kupi in mukmuga un muaat, in wilawilaau ku anu ra taara raap. ");
INSERT INTO rai_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maa Natu ra Muaana kaai pa i waan paat kupi din papaam karomi. I waan paat kupi ia ut in papaam karom a taara ma in taar taa anuna lalaaun, kup ia a winekul anu ra mongoro na taara.” ");
INSERT INTO rai_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Diat waan paat irong Ieriko. Baa Iesu ma ra nuna kum naat na wawer ma ra kor na taara kaai diat waan taanga matira, raa muaana, a pula, a iaana Baatimaaio (a kukuraaina natun Timaaio), i kiki u ra papaara aakapi, ma i aaraaring utnaa. ");
INSERT INTO rai_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","I walangoroi baa Iesu a te Naasaret i waan aakit, i wewataai dekdek naa, “Iesu, Natun Dewid, un maari iaau.” ");
INSERT INTO rai_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma mongoro na taara diat turbaati naa koku i ge. Iaku i wewataai dekdek bakaai ma naa, “Natun Dewid, un maari iaau.” ");
INSERT INTO rai_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu i tur ma i piri naa, “Muaat wataa paai.” Diat wataa paa a pula, ma diat piri taana naa, “Un gaaia! Tur! Iesu i wataa ui.” ");
INSERT INTO rai_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Baatimaaio i rakaan wa anuna ina maalu baa i burung baat anuna minong mai, i kaamtur, ma i waan karom Iesu. ");
INSERT INTO rai_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Iesu i tiri naa, “Aawa maa u nemi naa ang paami un ui?” A pula i baalui naa, “Tena Wawer, iaau nemi naa ang babo.” ");
INSERT INTO rai_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu i piri taana naa, “Un waan, anum nurnur ia walaangalaanga pa ui.” Ma i babo gagaa maut, ma i murmur Iesu u ra aakapi. ");
INSERT INTO rai_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Baa diat waan marawaai Ierusalem, ma diat waan paat Betpaage ma Betaania u ra Taangaai na Oliwa, Iesu i tula wa rudi ko ra nuna kum naat na wawer. ");
INSERT INTO rai_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma i piri taan diaar naa, “Mur a waan kup a taamaan kuraa namuga taa mur. Baa mur a waan ruk, mur a waan taau un raa naat na dongki kuraa di do koto taai, ma pa te utbaai i ki paa uni. Mur a palaa paai ma mur a beni urin. ");
INSERT INTO rai_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Baa te in tiri mur naa, ‘Aawa kabina maa mur paami lenmaa?’ mur a piri naa, ‘A Tadaaru i nemi kumun, ma in tula talili gagaa taai balet.’” ");
INSERT INTO rai_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Baa diaar waan, diaar babo paa a naat na dongki baa di aa do taai nataamaan naa ra bonanaaka i ra ruma, marawaai a aakapi, ma diaar palaai. ");
INSERT INTO rai_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Raa taara baa diat tur matira diat tiri diaar naa, “Aai, mur palaa a naat na dongki maa kup aawa?” ");
INSERT INTO rai_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Diaar baalu diat ma ra pirpir baa Iesu ia pir taai, ma diat maadek wai ku taan diaar. ");
INSERT INTO rai_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Diaar ben taa a naat na dongki karom Iesu, ma diaar rakaan wa ruina maalu baa diaar burung baat anundiaar minong mai, ma diaar ung taai nate uni, ma Iesu i ki uni. ");
INSERT INTO rai_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma mongoro na taara kaai diat rakaan wa anundiat kum maalu baa diat burburung baat anundiat kum minong mai, ma diat laangun taai u ra aakapi. Ma raa taara kaai diat bur paa a kum turun na diwaai taanga nabuaal, ma diat ung taai u ra aakapi. ");
INSERT INTO rai_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma diat baa diat muga ma diat baa diat murmur, diat kulkulaai lenbi, “Osaana! Daat a pir walaawa paa ia baa i waan paat u ra iaa ra Tadaaru!” Kele 118:25-26 ");
INSERT INTO rai_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Daat a pir walaawa paa a mataanitu anun tamaandaat Dewid baa in waan paat! Osaana unaanga nate aakit!” ");
INSERT INTO rai_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Baa Iesu i waan paat inaanga Ierusalem, i ruk u ra ruma na wetabaar. Baa ia babo taa a kum utnaa raap, i waan talili balet urong Betaania ungaai ma ra nuna 12 naat na wawer, maa ia tawiwibung. ");
INSERT INTO rai_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","U ra bung namur, baa diat waan taangirong Betaania, Iesu i molo. ");
INSERT INTO rai_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I babo in diwaai na fig taanga welwelik, i tawa wakwakaak. Ma i waan kupi in baboi, kup ta waina. Baa i waan paat karomi, pa i babo ta waina uni, a dondono biaa ku, maa pa i taaun fig utbaai. ");
INSERT INTO rai_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma i piri karom in diwaai na fig naa, “Turpaai mi ma namur, pain te balet ma in aan paa ta waim.” Ma anuna kum naat na wawer diat walangoro koto paa a pirpir maa. ");
INSERT INTO rai_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Baa diat waan paat inaanga Ierusalem, Iesu i ruk un raa pakaana ko ra ruma na wetabaar, ma i lu pari wa diat baa diat wiura, ma diat kaai baa diat kukul matira. I ong puku wa a kum luwu anu ra kum tena kiaana maani ma ra kum kiki anundiat baa diat wiura a kum buna. ");
INSERT INTO rai_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma pa i maadek taa a taara baa diat a lo anundiat kum utnaa na wiura naliwan u ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Baa i wer diat i piri naa, “Di aa timu taai u ra Buk Taabu lenbi, ‘Din waatung anung ruma baa a ruma na niaaring kup a kum wunwuna taara raap.’ Aais 56:7 Iaku muaat aa paam puku paai kupi in welaar maku ma ra ‘ruma anu ra kum tena walong.’” Ier 7:11 ");
INSERT INTO rai_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon kaai diat walangoroi, ma diat nuknuk kup ta aakapi kupi diat a aak doko Iesu uni, kabina maa diat burutaanai, maa a taara raap diat kakaian u ra nuna wawer. ");
INSERT INTO rai_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Baa ia maluraap Iesu ma ra nuna kum naat na wawer diat waan paa ko ra taamaan Ierusalem. ");
INSERT INTO rai_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","U ra malaana kinalik, baa diat waan talili unaanga Ierusalem, diat baboi baa in diwaai na fig ia maraang paa taanga nate tuk u ra aakaakaarina. ");
INSERT INTO rai_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Petero i nuk paa a pirpir anun Iesu, ma i piri taana naa, “Tena Wawer, un babo in diwaai na fig baa u pirpir na kaankaan paa karomi, ia maraang raap.” ");
INSERT INTO rai_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma Iesu i baalui naa, “Muaat a nurnur un God. ");
INSERT INTO rai_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iaau pir a lingtatuna taa muaat, baa te in piri taa ra taangaai bi naa, ‘Un tarigaat, ma un irok lop unataai,’ ma pa i aalawur nuknuk, i nurnur ku baa din paam a utnaa baa ia pir taai, io din paami ut. ");
INSERT INTO rai_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lenmaa iaau piri taa muaat, a kum utnaa raap baa muaat aaraaring kupi, muaat a nurnur ku baa di aa taar taai taa muaat, ma din taar taai ut. ");
INSERT INTO rai_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","“Baa muaat aaraaring, ma muaat nuk paa ta utnaa baa te i paam aaka taai un muaat, muaat a dumaana wai, kupi Tamaamuaat inaanga u ra maawa in dumaana wa anumuaat kum aakaina mangamangaan kaai.” ");
INSERT INTO rai_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Diat waan paat balet inaanga Ierusalem, ma baa Iesu i weliaa u ra ruma na wetabaar, a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon ma ra kum mukmuga diat waan karomi. ");
INSERT INTO rai_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma diat tiri naa, “Woi na mangaana naagagon maa u paam a kum utnaa mai mi? Woi maa i taar taa a naagagon mi taam kupi un paam a kum utnaa mi?” ");
INSERT INTO rai_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu i baalu diat naa, “Iaau kaai ang tiri muaat ma raa wetiri. Ma baa muaat a baalu iaau, io, ang wapua muaat u ra naagagon iaau laana paam a kum utnaa mai mi. ");
INSERT INTO rai_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Taangawaai a baapitaaiso anun Ioaanes? Taanginaanga u ra maawa, baa ko ra taara ku? Muaat a wapua iaau.” ");
INSERT INTO rai_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma diat pirpir ino paa lenbi, “Baa daat a piri naa, ‘Taanginaanga u ra maawa,’ in baalu daat ku naa, ‘Io, i lawaai maa pa muaat nurnur uni?’ ");
INSERT INTO rai_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Iaku baa daat a piri naa, ‘Ko ra taara,’ a taara diat a kaankaan karom daat.” Diat burutaana a taara, maa diat raap diat nurnur un Ioaanes naa ia a propet. ");
INSERT INTO rai_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Io, diat baalu ku Iesu naa, “Pa miaat nunurai.” Ma Iesu i piri taan diat naa, “Iaau kaai pang wapua muaat u ra naagagon iaau laana paam a kum utnaa mai mi.” ");
INSERT INTO rai_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu i wer diat ma raa pirpir welwelaar, lenbi, “Raa muaana i maarut taa a wanua na waain, ma i liplip baat taai. Naruma u ra wanua na waain maa i kil taa in tung kupi din paa ginagina taa a polo na waain uni, ma i paam taa a naat na ruma baa i tur unaanga nate kup a tena binaboura. Namur i taar taa kumun a wanua na waain taan raa taara na pinapaam kupi diat a babourai, ma i waan kup raa taamaan ingen. ");
INSERT INTO rai_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Baa a kalaang ia ot kupi din git ungaai a waina waain, i tula wa raa tultul karom a taara na pinapaam, kup ta wai ra nuna pinapaam kupi anuna kaai. ");
INSERT INTO rai_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma a taara na pinapaam diat paam akoto paai, diat umi, ma diat tula talili biaa wai ku. ");
INSERT INTO rai_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ma i tula wa balet raa tultul karom diat, diat um akinkin taa in lorina, ma diat baana wawirwir taai. ");
INSERT INTO rai_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma tamaa ra pinapaam i tula wa bulung raa tultul, diat aak doko wai ku. Baa i tula wa balet mongoro, diat um raa taara ma diat aak doko raa taara kon diat. ");
INSERT INTO rai_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Raa maku i ki karomi, a natunalik ut, a naat na wakwakaak. I tula wai bulung karom diat, maa i nuki naa diat a urur un natunalik. ");
INSERT INTO rai_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Iaku a taara na pinapaam maa diat pirpir ungaai paa naa, ‘Ia ma baa in kiaana tamaana, bari ma ia i waan urin. Muaat iaap, daat a aak dokoi, kupi anundaat ma a wanua na waain.’ ");
INSERT INTO rai_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Io, diat paam akoto paai, diat aak dokoi, ma diat ong apari wai ko ra wanua na waain. ");
INSERT INTO rai_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Aawa maa a tamaa ra wanua na waain maa in paami? In waan paat ma in aak doko wa a taara na pinapaam, ma in taar taa a wanua na waain karom ta taara ingen. ");
INSERT INTO rai_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Lelawaai, pa muaat luk a pirpir mi u ra Buk Taabu? I piri naa, ‘Ina waat maa a kum tena paam ruma diat pilak wai, ia ut maa ina ngaatngaat na waat baa di paam a ruma mai. ");
INSERT INTO rai_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A utnaa mi a Tadaaru ut ia paam taai, ma i koina aakit u ra numiaat binabo.’” Kele 118:22-23 ");
INSERT INTO rai_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A kum mukmuga anu ra taara Iudaia diat baat kup ta aakapi baa diat a paam akoto paa Iesu uni, kabina maa diat nunurai naa i pir ku a pirpir welwelaar mi un diat. Iaku maa diat burutaana a kor na taara. Io, diat tur paa koni, ma diat waan maut. ");
INSERT INTO rai_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Diat tula wa a kum Parisaaio, ma ra kum teptepaan Erodes karom Iesu kupi diat a walaam paai kup anuna ta pirpir baa diat a takunai uni. ");
INSERT INTO rai_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baa diat waan paat karomi, diat piri naa, “Tena Wawer, miaat nunurai naa ui a takado na muaana, pa u ngaraa u ra utnaa baa a taara diat piri un ui. Anum wawer i welaar raap ku karom a taara raap, ma u wer mulu diat u ra aakapi anun God ma ra lingtatuna. Lelawaai, i takado kupi din taar a tatakom karom a Kaaisaar baa pate? ");
INSERT INTO rai_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Daat a taari, baa koku?” I nunura lele anundiat warwaruga ma i tiri diat, “I lawaai maa muaat nemi naa muaat a walaar iaau? Ta maani urin ang baboi.” ");
INSERT INTO rai_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma diat taar taa raa maani taana. Ma i tiri diat naa, “A malalar ma ra timtimu mi uni anun woi?” Ma diat baalui naa, “Anu ra Kaaisaar.” ");
INSERT INTO rai_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu i piri taan diat, “A utnaa baa anu ra Kaaisaar muaat a taari karom a Kaaisaar, ma ra utnaa baa anun God muaat a taari kaai karom God.” Baa diat walangoroi diat kakaian aakit uni. ");
INSERT INTO rai_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A kum Saadukaaio, baa diat weoro ku naa pa ta lalaaun balet ko ra minaat, diat waan karom Iesu, ma diat tiri naa, ");
INSERT INTO rai_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tena Wawer, Moses i timu taai taan daat lenbi, baa ta muaana in maat paa ko ra nuna tabuan, ma pa ta natundiaar, io, tenalik in ben paai ma in taulaa mai, kupi in wangaala taa ta kum naat liklik u ra iaan tenalik baa ia maat. ");
INSERT INTO rai_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Io, raa naadiwaaina, 7 na muaana raap ku. A mugaana i taulaa, ma i maat ko ra nuna tabuan, ma pa ta natundiaar. ");
INSERT INTO rai_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ma a weru tenalik bulung i taulaa ma ra tabuan maa, ia bulung i maat ku ko ra tabuan maa, ma pa ta natundiaar. Lenkaai maa karom a wetuldi. ");
INSERT INTO rai_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Diat raap 7 diat, diat taulaa mai, iaku a tabuan maa pa i buta taa ta naat un diat. Ma a tabuan i maat murmur taan diat raap. ");
INSERT INTO rai_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","U ra lalaaun balet ko ra minaat, anun woi na paan diat mulu a tabuan maa? Maa 7 diat raap diat aa taulaa paa mai.” ");
INSERT INTO rai_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu i piri taan diat naa, “Muaat raara aakit, kabina maa pa muaat nunura a Buk Taabu ma ra dekdekin God kaai. ");
INSERT INTO rai_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Baa a taara diat a lalaaun balet ko ra minaat, pa diat a taulaa balet, diat a welaar maku ma ra kum aangelo inaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Baa muaat weoro naa a kum minaat pa diat a lalaaun balet ko ra minaat, lelawaai pa muaat luk utbaai a Buk anun Moses baa i pirpir u ra in diwaai baa i kupkup? God i piri karom Moses lenbi, ‘Iaau a God anun Aabaraam, a God anun Aaisaak ma a God anun Iaakob.’ Pin 3:6 ");
INSERT INTO rai_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Muaat raara aakit. God wakir a God anu ra kum minaat, a God anu ra kum lalaaunina ut.” ");
INSERT INTO rai_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Raa kon diat a kum tena wawer u ra kum Naagagon i waan paat karom Iesu ma i walangoroi baa diat pirpir ungaai ma ra kum Saadukaaio. I walangoroi baa Iesu i baalu wakaak diat, ma i tiri naa, “Woi na naagagon i ngaala taan diat raap?” ");
INSERT INTO rai_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu i baalui naa, “Bari ia a ngaala na naagagon, ‘Muaat a taara Israael muaat a walangoroi, anundaat God a Tadaaru ia raa ot ku. ");
INSERT INTO rai_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Muaat a maari a Tadaaru anumuaat God ma ra balaamuaat raap, a niomuaat raap, a nuknukimuaat raap, ma ra dekdekimuaat raap.’ Naag 6:4-5 ");
INSERT INTO rai_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma bari ia a werudi, ‘Un maari tepaam welaar ma u maari ui ut.’ Lewi 19:18 Pa ta naagagon i ngaala taa ra ru naagagon mi.” ");
INSERT INTO rai_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A tena wawer u ra kum Naagagon i piri taan Iesu naa, “A lingtatuna ut, Tena Wawer, i takado anum pirpir, baa God ia raa ot ku, ma pa te balet ma. ");
INSERT INTO rai_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Daat a maari God ma ra balaandaat raap, a nuknukindaat raap, ma ra dekdekindaat raap, ma daat a maari a kum teptepaandaat welaar ma daat maari daat ut. Baa daat murmur a ru naagagon mi, i ngaala taa ra kum wetabaar ma ra kum wetabaar kaai baa di tuntun diat karom God.” ");
INSERT INTO rai_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Baa Iesu i baboi naa i pirpir na manaana, i piri taana naa, “Ui, pa u welwelik ko ra mataanitu anun God.” Ma namur pa te balet i waan karomi ma ta wetiri, kabina diat burut. ");
INSERT INTO rai_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Baa Iesu i wer diat u ra ruma na wetabaar, i piri naa, “I lawaai maa a kum tena wawer u ra kum Naagagon diat piri naa Kaarisito in waan paat ko ra wuna taara anun Dewid? ");
INSERT INTO rai_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A Takado na Nion i mugain Dewid ma i piri lenbi, ‘A Tadaaru i piri karom anung Tadaaru, “Un ki u ra papaara ot na limaang, tuk baa ang uwia paa anum kum ebaar kupi diat a ki natudaangi ra num naagagon.” ’ Kele 110:1 ");
INSERT INTO rai_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewid ut i waatung Kaarisito naa anuna Tadaaru. Baa lenmaa, io, diaar tamaana lelawaai?” A kor na taara diat gaaia aakit baa diat walangoro a pirpir anun Iesu. ");
INSERT INTO rai_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Io baa i wer diat i piri lenbi, “Muaat a baboura muaat ko ra kum tena wawer u ra kum Naagagon. Diat nemi kupi diat a waanwaan ma ra kum kokoina maalu aakit, ma diat nemi naa a taara diat a taar a ngaala na urur karom diat u ra kum taamaan na winawaan ungaai. ");
INSERT INTO rai_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma diat nem a kinkini namuga u ra kum ruma na lotu, ma ra kinkini na tadaaru namuga u ra kum balaan. ");
INSERT INTO rai_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Diat waraap a wuwuwung anu ra kum walaa na tabuan, ma diat paam a kum iokaana aaraaring kupi a taara diat a babo diat. In ngaala aakit a naagagon na binabaalu anun God karom diat.” ");
INSERT INTO rai_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu i ki marawaai taau naa ra wuwuwung na maani u ra ruma na wetabaar, ma i babo a taara baa diat ongong taa anundiat maani uni. Mongoro na tadaaru kaai diat ong taa a ngaala na maani u ra wuwuwung maa. ");
INSERT INTO rai_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iaku raa walaa na tabuan, baa i iba, i ong taa ku ru toiaa u ra wuwuwung na maani maa. ");
INSERT INTO rai_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Iesu i wataa paa anuna kum naat na wawer karomi, ma i piri taan diat naa, “Iaau pir a lingtatuna taa muaat, a walaa na tabuan mi, ia taar taa a ngaala na maani taan diat raap baa diat ong taa anundiat maani u ra wuwuwung na maani. ");
INSERT INTO rai_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Diat taar taa ku a ibaana ko ra nundiat kum maani, ma a walaa na tabuan mi, i iba, iaku ia taar araap wa aawa baa in topaa anuna kini.” ");
INSERT INTO rai_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Baa Iesu i pari ko ra ruma na wetabaar, raa ko ra nuna kum naat na wawer i piri taana naa, “Tena Wawer, babo a kum wakwakaak na ruma bi baa di paami ma ra kum ngaalangaala na waat!” ");
INSERT INTO rai_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Iesu i piri taana, “U babo a kum ngaalangaala na ruma mi? Kuraa mun pa ta ruina waat ma diaar a inep ungaai, din reng ginagina raap wa diat.” ");
INSERT INTO rai_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Baa Iesu i ki inaanga nate u ra Taangaai na Oliwa baa di babo bolo kup a ruma na wetabaar, Petero, Iaakobo, Ioaanes ma Aanderiaas diat tiri inoi naa, ");
INSERT INTO rai_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Un wapua miaat, unaangaian a kum utnaa mi in waan paat? Ma aawa a wakilang i ra kum utnaa mi baa i marawaai kupi diat a waan paat?” ");
INSERT INTO rai_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu i piri taan diat, “Muaat a baboura muaat, kaduk te in waruga pa muaat. ");
INSERT INTO rai_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mongoro diat a waan paat ma ra iaang, diat a piri naa, ‘Iaau maa Kaarisito,’ ma diat a waruga paa ta mongoro. ");
INSERT INTO rai_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Baa muaat a walangoro a kum wineium ma ra wewapua un diat, koku muaat ngaraa, maa a kum utnaa mi diat a waan paat muga, iaku a tintinip na bung pa in waan paat utbaai. ");
INSERT INTO rai_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Raa wuna taara in tur na wineium kup raa wuna taara, ma raa mataanitu in tur na wineium kup raa mataanitu. Ma a kum guria ma ra kum minolo in waan paat u ra kum taamtaamaan. A kum utnaa mi i welaar ma ra ngunungut na binabuta baa a tabuan i turpaai kupi in kariaanai. ");
INSERT INTO rai_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Muaat a baboura muaat. A taara diat a aal pa muaat karom a kum tena naagagon, ma diat a raapu muaat u ra kum ruma na lotu. Muaat a tur u ra naagagon namuga naa ra kum ngaala na mukmuga ma ra kum king, kabina un iaau. Io, muaat a wewapua kaapa un iaau karom diat. ");
INSERT INTO rai_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Din warawaai muga ma ra Koina Wewapua karom a kum wunwuna taara raap. ");
INSERT INTO rai_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Baa diat aal pa muaat kup a naagagon, koku muaat nuknuk muga kup ta utnaa muaat a piri. U ra pakaana bung maa muaat a pir ku a pirpir baa din wanuk taai taa muaat, maa wakir muaat maa muaat a pirpir, a Takado na Nion ut. ");
INSERT INTO rai_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Te in mulaaot wa ta tenalik kupi din aak dokoi, ma ta muaana in mulaaot wa ta natunalik kupi din aak dokoi, ma a kum naat diat a tur na dekdek karom tamaandiat ma naandiat, ma diat a mulaaot wa tamaandiat ma naandiat kupi din aak doko diaar. ");
INSERT INTO rai_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma a taara raap diat a milikuaana muaat kabina u ra iaang, iaku te baa i tur dekdek tuk u ra tintinipina, God in walaaun paai. ");
INSERT INTO rai_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Muaat a babo raa aakaina utnaa aakit in waan paat, in ki u ra pakaana baa pa i tale kupi in ki iaai, ma in baana dur a pakaana maa. Ia baa in luk a kum pirpir mi, i koina baa in manaana uni. Io, u ra bung maa, diat baa diat ki u ra papaar Iudaia, diat a kalaa ino unaanga u ra kum taangaai. ");
INSERT INTO rai_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma baa te i ki nate u ra nuna ruma, baa in kaa pari, koku i ruk kupi in lo paa ta utnaa taanga naruma. ");
INSERT INTO rai_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma baa te i ki nabuaal, koku balet ma i waan talili unataamaan kup anuna maalu na minong. ");
INSERT INTO rai_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","U ra pakaana bung maa in aaka aakit karom a kum kipbaala, ma karom diat kaai baa diat wangaau a kum naat. ");
INSERT INTO rai_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Muaat a aaraaring kupi koku a utnaa mi in waan paat u ra kum kalaang na madiring. ");
INSERT INTO rai_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maa u ra kum bungbung maa, in ngaala aakit a kinadik. In ngaala aakit taa ra kum kinadik baa i laana waan paat u ra rakrakaan buaal. Turpaai baa God i waki a rakrakaan buaal tuk mi, ma namur kaai pa ta kinadik in welaar mai. ");
INSERT INTO rai_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Baa gun a Tadaaru pa in kutu pari a kum bungbung maa, pa te maut in lalaaun. Iaku ia kutu pari wai kupi diat baa ia pilak pa diat, diat a lalaaun. ");
INSERT INTO rai_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“U ra pakaana bung maa, baa te i piri karom muaat naa, ‘Kaarisito bari ia,’ baa ‘Barong ia,’ koku muaat nurnur uni. ");
INSERT INTO rai_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta kum warwaruga na Kaarisito, ma ta kum warwaruga na propet diat a waan paat, ma diat a paam ta kum wakilang ma ta kum utnaa na kakaian kupi diat a waruga a taara na pipilak mai, baa gun diat a pet laar pa diat. ");
INSERT INTO rai_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Io, muaat a baboura muaat, mi iaau aa wapua muga ta muaat u ra kum utnaa raap baa in waan paat. ");
INSERT INTO rai_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Baa ia raap a kum kinadik u ra kum bungbung maa, ‘in mataana mage in baboto, a kalaang pa in baara, ");
INSERT INTO rai_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","a kum naangnaang diat a puka pari taanginaanga u ra baakut, ma ra kum utnaa inaanga nate u ra baakut diat a dadader.’ Aais 13:10; 34:4 ");
INSERT INTO rai_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“U ra bung maa a taara diat a babo Natu ra Muaana in waan paat u ra kum baakut ma ra ngaala na dekdek ma ra minamaar. ");
INSERT INTO rai_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma in tula pari wa a kum aangelo ma diat a ben ungaai anuna taara na pipilak ko ra waat na mataana dadaip, kon raa papaara rakrakaan buaal tuk urong kaai un raa papaara rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Muaat a wawer ko ra in diwaai na fig. Baa a kum gagagaana in kiok balet ma a dondono in tapalaa, muaat nunurai naa a kum kalaang na wuwan ia marawaai. ");
INSERT INTO rai_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lenkaai maa, baa muaat babo a kum utnaa baa iaau pirpir taau uni in waan paat, muaat a nunurai naa a pakaana bung ia marawaai. ");
INSERT INTO rai_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iaau pir a lingtatuna taa muaat, a kum utnaa raap mi in waan paat baa a taaun taara mi diat lalaaun utbaai. ");
INSERT INTO rai_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A maawa ma ra rakrakaan buaal diaar a panaai, iaku maa anung kum pirpir pa in panaai. ");
INSERT INTO rai_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pa te i nunura a bung baa a pakaana bung. A kum aangelo inaanga u ra maawa pa diat nunurai, ma Natuna kaai pa i nunurai, Tamaana ku i nunurai. ");
INSERT INTO rai_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muaat a nuknuk wakaak, ma muaat a baboura muaat, maa pa muaat nunurai naa unaangaian baa a kum utnaa mi in waan paat. ");
INSERT INTO rai_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I welaar ma raa muaana baa i waninaar kupi in waan kup raa taamaan ingen. I taar taa anuna ruma taa ra nuna kum tultul, kupi diat a babourai. I tibe weraana a kum pinapaam taan diat raap raaraa, ma i wapua taa raa muaana kupi in baboura a balbalaat. ");
INSERT INTO rai_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Muaat a baboura muaat, maa pa muaat nunurai baa unaangaian a tamaa ra ruma in waan paat, u ra maluraap, baa u ra ngaala na marum, baa u ra laar baa a kum kareke diat kurkurekatuk, baa u ra malaana, ");
INSERT INTO rai_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","kaduk in waan paat kakaian, ma in waan taau un muaat baa muaat inep duman ku. ");
INSERT INTO rai_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mi iaau piri taa muaat ma karom a taara raap naa, muaat a baboura muaat.” ");
INSERT INTO rai_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ru bung namuga taa ra lukaara na waan likaai, ma ra lukaara na bred baa pa ta is uni, a kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon diat nuknuk kup ta mangaana aakapi kupi diat a paam akoto ino paa Iesu ma diat a aak dokoi. ");
INSERT INTO rai_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Diat piri naa, “Koku daat paami u ra lukaara, kaduk a taara diat a paam ta purpuruan.” ");
INSERT INTO rai_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu i ki utbaai irong Betaania, u ra ruma anun Simon, ia baa namuga i malaapaang ma ra wukawuka. Baa i ki u ra winangaan, raa tabuan i waan karomi ma ra polo na mangingi baa di waatungi naa naad. I ngaatngaat aakit, ma i taana u ra in palaa baa di paami ko ra waat. I aak puar wa in mataana palaa, ma i laboi u ra in lorin Iesu. ");
INSERT INTO rai_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Raa taara baa diat ki matira diat kaankaan ma diat pirpir wetalaai naa, “Kup aawa maa di labo biaa wa ku a polo na mangingi mi? ");
INSERT INTO rai_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I lawaai maa pa di wiura paai kup ta 300 na denaaria kupi din tabaara kum iba na taara mai?” Ma diat pirpir na kaankaan karom a tabuan maa. ");
INSERT INTO rai_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Iesu i piri taan diat lenbi, “Muaat a maadek wa a tabuan mi. Aawa maa muaat watapunuki kupi? Ia paam taa a koina pinapaam aakit un iaau. ");
INSERT INTO rai_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A kum iba na taara diat lalaaun ungaai ut ma muaat. Baa muaat nemi kupi muaat a paam a koina karom diat, muaat a paami ku. Iaku iaau, pang ki takum naa muaat. ");
INSERT INTO rai_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ia paam ot paa a utnaa baa i tale kupi in paami. Ia labo taa a polo na mangingi u ra paning kupi in waninaar amuga iaau kup anung bung na minaat. ");
INSERT INTO rai_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iaau pir a lingtatuna taa muaat, u ra kum taamtaamaan u ra rakrakaan buaal, baa din warawaai ma ra Koina Wewapua iaai, din wewapua utkaai u ra utnaa bi a tabuan mi ia paam taai, kupi a iaana in tur na aaim.” ");
INSERT INTO rai_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iudaas Iskaariot, raa ko ra 12 naat na wawer, i waan karom a kum ngaala na tena wetabaar karom God, kupi in wagu taa Iesu karom diat. ");
INSERT INTO rai_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Baa diat walangoroi, diat gaaia, ma diat weweliman taai kupi diat a doki ma ra maani. Ma Iudaas i nuknuk kup ta koina pakaana bung baa in wagu taa Iesu karom diat. ");
INSERT INTO rai_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","U ra mugaana bung u ra lukaara na bred baa pa ta is uni, baa di laana aak doko a kum naat na sip uni kup a lukaara na waan likaai, a kum naat na wawer anun Iesu diat tiri naa, “U nemi naa miaat a waan uwaai, kupi miaat a waninaar paa andaat utnaa kup a lukaara na waan likaai?” ");
INSERT INTO rai_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I tula wa rudi ko ra nuna kum naat na wawer, ma i piri taan diaar naa, “Mur a ruk unaanga Ierusalem. Baa mur aa waan paat, mur a wetarom ma raa muaana i lo ina ngaala na palaa, ma mur a murmuri. ");
INSERT INTO rai_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma baa in ruk un ta ruma, mur a piri taa ra tamaa ra ruma naa, ‘A Tena Wawer i piri naa: Waiaa a kukur ra ruma baa miaat ma ra nung kum naat na wawer, miaat a aan a utnaa na waan likaai iaai?’ ");
INSERT INTO rai_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma in waiaa ta mur u ra ngaala na kukur ra ruma inaanga nate, baa di aa waninaar taai, ma mur a waninaar a utnaa iaai.” ");
INSERT INTO rai_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A ru naat na wawer diaar waan paat inaanga Ierusalem, ma diaar baraata raap paa ut a kum utnaa baa Iesu i pir taai taan diaar. Ma diaar waninaar a utnaa na waan likaai. ");
INSERT INTO rai_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Baa ia maluraap, Iesu ma anuna 12 naat na wawer diat waan paat. ");
INSERT INTO rai_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Baa diat wangaan, i piri naa, “Iaau pir a lingtatuna taa muaat, raa kon muaat in wagu ta iaau, raa ut kon muaat mi daat wangaan ungaai.” ");
INSERT INTO rai_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma diat tapunuk, ma diat raap raaraa diat tiri naa, “Wakir iaau duk?” ");
INSERT INTO rai_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma Iesu i piri taan diat naa, “Raa kon muaat ut a 12, ia baa mir puk ungaai amaamir ru bred u ra dis. ");
INSERT INTO rai_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Natu ra Muaana in wirua welaar ma di aa timu taai u ra Buk Taabu. Iaku in aaka aakit karom a muaana baa in wagu taai karom a kum ebaar. In koina aakit baa gun pa din butai, kupi koku i kariaana a naagagon maa karomi.” ");
INSERT INTO rai_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baa diat wangaan utbaai, Iesu i lo paa a bred, i waatung wakaak paa uni, i bik paai, ma i tabaara anuna kum naat na wawer mai. I piri naa, “Muaat a rakaan paai, bi ia a paning.” ");
INSERT INTO rai_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Namur i lo paa a kaap, i waatung wakaak paa uni, i taari taan diat, ma diat raap diat inim koni. ");
INSERT INTO rai_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma i piri taan diat, “Bi ia a gaaping, a kunubu baa i aal ungaai taa God ma ra taara. A gaaping mi i talabo u ra mongoro. ");
INSERT INTO rai_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iaau pir a lingtatuna taa muaat naa, pang inim balet ma ta waain, tuk baa ang inim a matakina waain u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Io, baa diat aa kelekele paa, diat waan tato unaanga u ra Taangaai na Oliwa. ");
INSERT INTO rai_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu i piri taan diat naa, “Muaat raap muaat a waan paa ku kon iaau, maa di aa timu taai u ra Buk Taabu naa, God i piri naa, ‘Ang um a tena baboura sip, ma a kum sip diat a welulu werweraan.’ Saak 13:7 ");
INSERT INTO rai_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Iaku baa iaau aa tur balet ko ra minaat, ang muga urong Gaalilaia.” ");
INSERT INTO rai_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petero i piri taana naa, “Baa diat raap diat a waan paa kon ui, iaau painte.” ");
INSERT INTO rai_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu i piri taana naa, “Iaau pir a lingtatuna taam, umari u ra marum, baa a kareke pa in weru kurkurekatuk utbaai, un weoro tula pakaan naa pa u nunura iaau.” ");
INSERT INTO rai_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Petero i pirpir dekdek karomi naa, “Pang weoro kon ui. In koina ku baa daar raap daar a ora wirua.” A kum naat na wawer raap kaai diat piri ut lenmaa. ");
INSERT INTO rai_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesu ma ra nuna kum naat na wawer diat waan paat u ra wanua a iaana Getsemaane, ma i piri taan diat naa, “Muaat a ki ku min, ma iaau ang aaraaring paa.” ");
INSERT INTO rai_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Io, i ben paa Petero, Iaakobo ma Ioaanes. U ra pakaana bung maa i kariaana a ngaala na tapunuk ma i mawaat aakit a nuknukina. ");
INSERT INTO rai_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I piri taan ditul naa, “Anung lalaaun i mawaat aakit ma ra tapunuk, marawaai ma ang maat mai. Mutul a ki ut min, ma mutul a baboura.” ");
INSERT INTO rai_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I waan kinalik taau unamuga, i puka ruru unapia, ma i aaraaring kupi a pakaana bung na minaat in waan likaa wai, baa gun in koina lenmaa. ");
INSERT INTO rai_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I aaraaring naa, “Tataa, Tataa, a kum utnaa raap i tale ui un paami, un lo wa a ngunungut na minaat kon iaau. Iaku koku di murmur anung nemnem, din murmur ut anum nemnem.” ");
INSERT INTO rai_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Baa i waan talili, i babo ditul, ditul aa inep duman. I tiri Petero naa, “Simon, lelawaai, u inep duman ku? Pa un pet laar paai kupi un baboura ta kinalik na pakaana bung ku? ");
INSERT INTO rai_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mutul a baboura, ma mutul a aaraaring, kupi koku mutul puka u ra walwalaam. A niomutul i nem na taraam, iaku a panimutul i bilua.” ");
INSERT INTO rai_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Io, i waan, ma i aaraaring balet ma ra niaaring baa ia waatung taai mun. ");
INSERT INTO rai_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Baa i waan talili balet, i babo ditul baa ditul aa inep duman balet, kabina a mataanditul i uwaaia aakit. Pa ditul nunurai baa aawa maa ditul a baalui mai. ");
INSERT INTO rai_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Baa i wetula pakaana winawaan talili anuna karom ditul, i piri naa, “Mutul a inep liklik maku? I ot ku! A pakaana bung ia waan paat. Baboi, di aa wagu taa Natu ra Muaana ma din taar taai u ra limaa ra kum tena aakaina. ");
INSERT INTO rai_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mutul tur, daat a waan! Baboi, a muaana baa in wagu ta iaau bari ma ia.” ");
INSERT INTO rai_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Baa Iesu i pirpir utbaai, Iudaas, raa ko ra 12 naat na wawer, i waan paat, diat ma ra kor na taara. Diat lo a kum liwan na wineium ma ra kum pakaana naalnaal. A kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon ma ra kum mukmuga diat tula wa diat. ");
INSERT INTO rai_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ia baa in wagu taa Iesu ia wapua muga taa a kor na taara u ra wakilang baa in paami un Iesu naa, “Ia baa ang dum a papaara waana, ia ut maa. Muaat a paam akoto paai, muaat a ben ingen paai ma muaat a baboura baat wakaaki.” ");
INSERT INTO rai_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Io, Iudaas i waan maut karom Iesu ma i piri naa, “Tena Wawer!” Ma i dum a papaara waana. ");
INSERT INTO rai_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma a taara maa diat paam akoto paa Iesu ma diat aal paai. ");
INSERT INTO rai_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Raa kon diat baa diat turtur marawaai, i aalum paa anuna in liwan na wineium, ma i pakaat a tultul anu ra mukmuga na tena wetabaar karom God, ma i kutu wa in talingaana. ");
INSERT INTO rai_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Iesu i piri taan diat naa, “Lelawaai, iaau duk a ngaala na tena pet apurpuruan, maa mi muaat waan paat ma ra kum liwan na wineium ma ra kum pakpakaana naalnaal kupi muaat a paam akoto iaau? ");
INSERT INTO rai_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","U ra kum bungbung raap daat kiki u ra ruma na wetabaar, iaau laana wer a taara, ma pa muaat aal iaau. Iaku di paami lenmi kupi din paam ot paa a pirpir u ra Buk Taabu.” ");
INSERT INTO rai_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma a taara na wawer raap anun Iesu diat welulu weraan paa koni. ");
INSERT INTO rai_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Raa baarmaan baa i laana murmur Iesu, i mong paa ku ma ina maalu. Baa diat paam akoto paai, ");
INSERT INTO rai_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","i ong wa ku anuna ina maalu, ma i welulu, i towaturia maku. ");
INSERT INTO rai_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Diat ben paa Iesu karom a mukmuga na tena wetabaar karom God. Ma a kum ngaala na tena wetabaar karom God, a kum mukmuga, ma ra kum tena wawer u ra kum Naagagon diat waan paat ungaai matira. ");
INSERT INTO rai_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petero i murmur waanawaana Iesu, iaku maa i welwelik ut, ma i ruk u ra pakaana anu ra mukmuga na tena wetabaar karom God, ma i manir naa ra nguan ungaai ma ra kum tena baboura. ");
INSERT INTO rai_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A kum ngaala na tena wetabaar karom God, ma ra taara na kiwung raap diat baat kup ta aakaina utnaa baa Iesu ia paam taai, kupi diat a takunai mai, ma diat a aak dokoi uni, iaku maa pa diat baat laar paa ta utnaa. ");
INSERT INTO rai_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mongoro diat pir a kum warwaruga na pirpir un Iesu, iaku anundiat kum pirpir pa i waan ungaai. ");
INSERT INTO rai_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Raa taara diat tur ma diat pir a kum warwaruga na pirpir un Iesu naa, ");
INSERT INTO rai_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Miaat walangoroi i piri lenbi, ‘Ang reng wa a ruma na wetabaar mi baa a taara diat paami, ma un ta tula bung ku ang paam paa te baa wakir a taara diat paami.’” ");
INSERT INTO rai_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Iaku anundiat kum pirpir kaai pa i waan ungaai. ");
INSERT INTO rai_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A mukmuga na tena wetabaar karom God i tur taau namuga taan diat ma i tiri Iesu naa, “Lelawaai, pa un baalu a kum pirpir na wetakun mi karom ui?” ");
INSERT INTO rai_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iaku Iesu pa i pirpir. A tena wetabaar maa i tiri balet naa, “Ui Kaarisito, a Natun God, ia baa i daan takum, baa pate?” ");
INSERT INTO rai_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu i piri, “Iaau ut maa, ma namur muaat a babo Natu ra Muaana in ki u ra papaara ot na limaan God, ia baa i dekdek aakit, ma in waan paat u ra kum baakut taanginaanga u ra maawa.” ");
INSERT INTO rai_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A mukmuga na tena wetabaar i kaankaan ma i aal rabaana anuna ina maalu ut ma i piri naa, “Daat nem balet ma ta pirpir na wetakun kup aawa? ");
INSERT INTO rai_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muaat aa walangoro taa anuna pirpir aakaka un God. Aawa muaat nuki?” Io, diat raap diat mulaaot baa Iesu in wirua. ");
INSERT INTO rai_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Raa taara kon diat, diat kamia Iesu, diat pulu baat taa a mataana, diat tibuli ma diat piri taana naa, “Ui a propet, un wapua miaat, woi maa i tibul ui!” A kum tena baboura diat ben paai ma diat raapui. ");
INSERT INTO rai_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Baa Petero i ki utbaai nataamaan u ra ruma maa, raa tauraara, a tultul anu ra mukmuga na tena wetabaar karom God i waan paat. ");
INSERT INTO rai_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Baa i babo Petero kuraa i manir, i babo dekdeki ma i piri naa, “Ui kaai raa kon diat baa muaat weweur ma Iesu a te Naasaret.” ");
INSERT INTO rai_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Iaku i weoro lenbi, “Pa iaau nunura a utnaa maa u pirpir uni, ma pa iaau kaapa uni.” Ma i waan urong naa ra bonanaaka i ra liplip. Ma a kareke i kurkurekatuk maut. ");
INSERT INTO rai_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A tabuan i babo paai balet, ma i wapua diat baa diat tur matira naa, “A muaana mi ia kaai raa ut kon diat mi.” ");
INSERT INTO rai_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petero i weoro balet. Namur kinalik, diat baa diat tur marawaai karom Petero, diat piri taana naa, “A lingtatuna ut baa ui kaai raa kon diat, maa ui a te Gaalilaia.” ");
INSERT INTO rai_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma i weweliman karom diat, i piri naa, “God in naagagon aakaka iaau baa ang warwaruga. Pa iaau nunura a muaana maa muaat pirpir uni.” ");
INSERT INTO rai_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma a kareke i weru pakaana kurkurekatuk maut. Ma Petero i nuk paa a pirpir baa Iesu ia pir taai taana naa, “Baa a kareke pa in weru pakaana kurkurekatuk utbaai, un weoro kon iaau tula pakaan.” Io, i taangi aakit maut. ");
INSERT INTO rai_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Baa i malaana kinalik, a kum ngaala na tena wetabaar karom God, a kum mukmuga, ma a kum tena wawer u ra kum Naagagon ma ra taara na kiwung raap, diat pirpir ungaai. Diat wi paa a ru limaan Iesu, diat ben paai ma diat taar taai karom Pilaato. ");
INSERT INTO rai_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaato i tiri naa, “Ui maa a King anu ra taara Iudaia?” Ma Iesu i baalui naa, “Ma raa ut ia u aa piri.” ");
INSERT INTO rai_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A kum ngaala na tena wetabaar karom God diat takuna Iesu un ta mongoro na utnaa. ");
INSERT INTO rai_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaato i tiri Iesu balet naa, “Pa anum ta pirpir na binabaalu? Baboi, mongoro na utnaa aakit mi diat takuna ui mai.” ");
INSERT INTO rai_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Iesu pa i baalui ma ta pirpir, ma Pilaato i kakaian aakit uni. ");
INSERT INTO rai_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","U ra kum kilakilaala raap u ra kum lukaara na waan likaai, Pilaato i laana palaa wa raa karabus baa a taara diat aaring kupi. ");
INSERT INTO rai_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","U ra kilaala maa, raa muaana a iaana Baaraabaas i ki u ra karabus. Ia raa kon diat baa diat weium ma ra mataanitu, ma diat aak doko a taara u ra wineium. ");
INSERT INTO rai_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Baa a kor na taara diat waan paat karom Pilaato, diat aaringi naa in palaa wa balet ta karabus. ");
INSERT INTO rai_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Pilaato i tiri diat naa, “Muaat nemi naa ang palaa wa a ‘king anu ra taara Iudaia’ karom muaat?” ");
INSERT INTO rai_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I piri lenbi kabina ia nunurai naa a kum ngaala na tena wetabaar karom God diat taar taa Iesu ku karomi u ra aakaina nuknukindiat. ");
INSERT INTO rai_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iaku a kum ngaala na tena wetabaar karom God diat wowo taa a kor na taara kupi diat a aaring Pilaato baa in palaa taa Baaraabaas karom diat. ");
INSERT INTO rai_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaato i tiri diat balet, “Aawa maa ang paami un ia baa muaat waatungi naa a king anu ra taara Iudaia?” ");
INSERT INTO rai_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma diat ge dekdek ku ma ra pirpir naa, “Aak waati u ra bolo!” ");
INSERT INTO rai_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaato i tiri diat balet naa, “Aawa kabina? Woi na aakaina utnaa maa ia paam taai?” Iaku diat ge dekdek ku ma ra pirpir naa, “Aak waati u ra bolo!” ");
INSERT INTO rai_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilaato i nemi kupi in wagaaia a taara, io, i palaa wa Baaraabaas karom diat. Baa di aa raapu tataa Iesu, Pilaato i taar taai taa ra kum tena wineium kupi diat a aak waati u ra bolo. ");
INSERT INTO rai_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A kum taara na wineium diat aal paa Iesu unaruma u ra liplip i ra ngaala na ruma anu ra nundiat mukmuga, ma diat wataa ungaai paa a kikil na taara na wineium raap. ");
INSERT INTO rai_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Diat wamong taai ma ra in taar na maalu, diat limaai paa in aaru i taar laklakono ma diat ung taai u ra in lorina welaar ma ra in kaaeng. ");
INSERT INTO rai_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Diat wataai naa, “Ui maa a king anu ra taara Iudaia!” ");
INSERT INTO rai_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Diat raapraapu in lorina ma ra in diwaai, diat kamiai, diat ki but keke naana, ma diat urur karomi. ");
INSERT INTO rai_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Baa diat aa tataur paa uni, diat palaa wa in taar na maalu koni. Diat wamong taai balet ma ra anuna kum maalu, ma diat ben apari paai kupi din aak waati u ra bolo. ");
INSERT INTO rai_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","U ra aakapi a kum tena wineium diat baraata paa raa te Kirene, a iaana Simon, a tamaan Aaleksaander ma Rupus, i waan kon raa taamaan kupi in waan unaanga Ierusalem. Diat wowo taai kupi in lo a bolo anun Iesu. ");
INSERT INTO rai_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Diat ben Iesu kup a wanua di waatungi ma Golgotaa, a kukuraaina “Pia na Lor.” ");
INSERT INTO rai_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Diat taar taa a waain taana, a waain baa di ung ungaai ma ra mira, iaku pa i nem na inimi. ");
INSERT INTO rai_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Diat aak waat taai u ra bolo, ma diat pilaai laaki kup anuna kum maalu kup woi kon diat in lo ta maalu. ");
INSERT INTO rai_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Baa i 9 na pakaana bung u ra malaana diat aak waati u ra bolo. ");
INSERT INTO rai_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Diat timu taa a pirpir na wetakun uni nate u ra bolo lenbi: ");
INSERT INTO rai_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Diat aak waat taa kaai ru tena walong ungaai mai un raa ru bolo, raa u ra papaara ot na limaana, ma raa u ra papaara maira. ");
INSERT INTO rai_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma diat baa diat waanwaan aakit Iesu, diat pir aakakai ma diat liliaa lorindiat karomi. Ma diat piri naa, “Ui ma maa baa u piri naa un reng wa a ruma na wetabaar, ma un paam paai balet ku un ta tula bung, ");
INSERT INTO rai_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mi un walaaun pa ui ma, ma un pari ko ra bolo.” ");
INSERT INTO rai_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","A kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon diat kaai diat tataur un Iesu, diat pir wetwetalaai karom diat naa, “I walaaun paa a taara ingen, iaku ia ut pa in walaaun laar paai. ");
INSERT INTO rai_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Baa ia a Kaarisito, a King anu ra taara Israael, mi ut in pari ko ra bolo, kupi daat a baboi, ma daat a nurnur uni.” Ma diaar kaai, baa di aak waat ta diaar u ra ru bolo ungaai mai, diaar pir aakakai. ");
INSERT INTO rai_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Baa i 12 pakaana bung u ra mage, a buaal raap i baboto tuk un tuluina pakaana bung u ra maluraap. ");
INSERT INTO rai_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Baa i tuluina pakaana bung, Iesu i kulkulaai dekdek lenbi, “Eloi, Eloi, lemaa saabaakaataani?” A kukuraai ra pirpir mi i lenbi, “Anung God, anung God, i lawaai maa u waan paa kon iaau?” Kele 22:1 ");
INSERT INTO rai_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Raa taara kon diat baa diat tur marawaai, baa diat walangoroi diat piri naa, “Baboi, i wewataai kup Eliaas.” ");
INSERT INTO rai_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Raa kon diat i welulu ma i lo paa raa utnaa baa i laana lo koto a polo. I puk paai u ra waain baa i matitir, i ung paai u ra in diwaai ma i tulaa tatoi unaanga nate kupi Iesu in inimi. Ma i piri taan diat naa, “Iot, daat a baboi kumun. Lelawaai, Eliaas in waan pari kupi in lo pari paai baa pate?” ");
INSERT INTO rai_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Iesu i kulkulaai dekdek paa, ma i ung wa anuna lalaaun. ");
INSERT INTO rai_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma ina maalu na babaat kutu naruma u ra ruma na wetabaar i tarabaat weraan, turpaai taanginaanga nate tuk napia. ");
INSERT INTO rai_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","A mukmuga anu ra kum tena wineium i tur taau naa ra bolo, baa i walangoro Iesu i kulkulaai ma i babo a mangaana minaat baa i paami, i piri naa, “I lingtatuna aakit, a muaana mi a Natun God.” ");
INSERT INTO rai_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Raa kum tabuan kaai diat tur welwelik taau ut ma diat babo a kum utnaa mi. Kuraa naliwan taa ra kum tabuan maa, raa tula tabuan kaai, Maaria Maagdalene, ma Saalome ma Maaria kaai a naan Ioses ma Iaakobo a baarmaan. ");
INSERT INTO rai_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ditul mi ditul murmur Iesu baa i ki Gaalilaia, ma ditul laana waraauti. Ma mongoro na tabuan kaai, baa diat weur ungaai mai unaanga Ierusalem, diat ki matira. ");
INSERT INTO rai_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Raa muaana a iaana Iosep, a te Aarimaatia, ia raa ko ra taara na kiwung, a ngaala na muaana baa a taara diat laana rui, i kiki walaang kup a mataanitu anun God. Baa ia maluraap u ra bung na waninaar, a bung namuga taa ra Bung Saabaat, i waan karom Pilaato, pa i burut, ma i aaring paa a minaatin Iesu koni. ");
INSERT INTO rai_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaato i kakaian baa i walangoroi naa Iesu ia maat. I wataa paa a mukmuga anu ra kum tena wineium, i tiri naa, “Naangaian maa Iesu i maat?” ");
INSERT INTO rai_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Baa ia manaana paa taa ra mukmuga mi, i mulaaot taa a minaatin Iesu karom Iosep. ");
INSERT INTO rai_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma Iosep i kul paa in koina maalu, i lo pari paa Iesu, ma i pulu paai ma ra ina maalu maa. Namur i wainep taai u ra babaang na minaat, baa di aa kil taai u ra papaara waat, ma i tul baat taa a mataa ra babaang na minaat ma ra ina ngaala na waat. ");
INSERT INTO rai_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maaria Maagdalene ma Maaria, a naan Ioses, diaar babo taa a wanua mi di wainep Iesu uni. ");
INSERT INTO rai_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Baa a Bung Saabaat ia raap, Maaria Maagdalene, ma Maaria naan Iaakobo, ma Saalome ditul kul paa a kum utnaa baa i aangawian kupi ditul a wamong a minaatin Iesu mai. ");
INSERT INTO rai_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Baa in mage ia waan paat u ra malaana kinalik u ra mugaana bung u ra wik, a tula tabuan ditul waan kup a babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Baa ditul waan waanwaan ditul tiri wetwetalaai ditul, “Woi ma in waraaut datul kupi in tul ingen wa ina waat marong ko ra mataa ra babaang na minaat?” ");
INSERT INTO rai_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Baa ditul babo takado urong, ditul baboi baa di aa tul ingen wa ina ngaala na waat maa. ");
INSERT INTO rai_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Baa ditul ruk u ra babaang na minaat, ditul babo raa baarmaan, i ki taau u ra papaara ot na limaanditul, i mong paa ma in kabaang na maalu. Baa ditul babo paai ditul burut. ");
INSERT INTO rai_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A muaana maa i piri taan ditul naa, “Koku mutul burut. Iaau nunurai naa mutul baat kup Iesu a te Naasaret, ia baa di aak waat taai u ra bolo. Ia lalaaun balet, pa i ki ma min. Mutul a babo a wanua baa di wainep taai iaai. ");
INSERT INTO rai_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mutul a waan, mutul a wapua anuna kum naat na wawer ma Petero kaai naa, ‘Iesu in muga urong Gaalilaia. Muaat a baboi marong, welaar ma ia wapua muga ta muaat.’” ");
INSERT INTO rai_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Io, ditul welulu ko ra babaang na minaat ma ra ngaala na bunurut ma ditul dadader, ma pa ditul wapua te un ta pirpir kabina ditul burut aakit.  ");
INSERT INTO rai_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Baa Iesu ia lalaaun paat balet u ra malaana kinalik u ra mugaana bung u ra wik, i waan paat karom Maaria Maagdalene, ia baa i lu irok wa 7 na tabaraan koni. ");
INSERT INTO rai_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maaria Maagdalene i waan ma i wapua diat baa diat laana murmur Iesu, baa diat tapunuk ma diat taangtaangi kupi. ");
INSERT INTO rai_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Baa diat walangoroi naa Iesu ia lalaaun balet ko ra minaat ma Maaria ia babo taai, pa diat nurnur uni. ");
INSERT INTO rai_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Namur Iesu i waan paat karom ru naat na wawer baa diaar waanwaan u ra aakapi. Ma a panin Iesu i babo raaungaana. ");
INSERT INTO rai_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Baa diaar waan talili balet, diaar wapua a kum naat na wawer raap, iaku pa diat nurnur kaai un diaar. ");
INSERT INTO rai_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Namur i waan paat paa karom 11 naat na wawer baa diat ki na winangaan. Ma i kaankaan karom diat, kabina pa diat nurnur, ma i dekdek a balaandiat, ma kabina baa pa diat nurnur un diat baa diat aa babo taai naa ia lalaaun balet. ");
INSERT INTO rai_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma i piri taan diat naa, “Muaat a waan u ra rakrakaan buaal raap, ma muaat a warawaai ma ra Koina Wewapua karom a taara raap. ");
INSERT INTO rai_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ia baa i nurnur ma di baapitaaisoi din walaauni. Iaku ia baa pa i nurnur din taar a dekdek na naagagon na binabaalu karomi. ");
INSERT INTO rai_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A kum tena nurnur diat a paam a kum utnaa na kakaian bi: Diat a lu irok wa a kum tabaraan ma ra iaang, diat a pirpir ma ra kum aalawur matakina pirpir, ");
INSERT INTO rai_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","diat a paam a kum wui baa i laana karaat doko a taara, iaku pa in baanaakaka diat, ma baa diat a inim a minminaat, ia kaai pa in baanaakaka diat maut, ma diat a ung a limaandiat u ra kum malaapaang, ma diat a laangalaanga.” ");
INSERT INTO rai_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Baa a Tadaaru Iesu ia pirpir taau taan diat, God i lo tato paai unaanga u ra maawa, ma i ki u ra papaara ot na limaana. ");
INSERT INTO rai_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anuna kum naat na wawer diat waan, ma diat warawaai taltalili. Ma a Tadaaru i papaam waraaut diat, ma i walingtatuna anuna pirpir ma ra kum utnaa na kakaian baa i waan ungaai mai. ");
INSERT INTO rai_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Karom Tiopilo, Mongoro diat walaari ma diat aa pet ot paa a timtimu u ra kum utnaa i waan paat karom miaat. ");
INSERT INTO rai_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Diat baa diat aa babo taa a kum utnaa mi ko ra turpaaina, ma diat wer a taara u ra Koina Wewapua, diat wapua miaat u ra kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Io, iaau kaai iaau aa tikan apaat paa kum utnaa mi ko ra turpaaina, lenmaa iaau nuki naa i koina baa ang timu taai taam, Tiopilo a tadaaru. Ang timu a kum utnaa mi welaar ma ra wemur na winawaan paat anundiat, ");
INSERT INTO rai_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kupi un nunurai naa a kum utnaa di aa wer ta ui uni, i lingtatuna ut. ");
INSERT INTO rai_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","U ra kilaala baa Erodes i king u ra papaar Iudaia, raa tena wetabaar karom God a iaana Saakaria, ko ra kikil anun Aabia. Saakaria, anuna taulaa a iaana Elisabet, ia kaai ko ra wuna taara anun Aaron. ");
INSERT INTO rai_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Diaar a ru tena takado namataan God, diaar murmur wakaak a kum wetulaa ma ra kum Naagagon raap anu ra Tadaaru. ");
INSERT INTO rai_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Iaku pa ta natundiaar, maa Elisabet i bi, ma diaar aa takaana kaai. ");
INSERT INTO rai_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Raa bung u ra kum bungbung na wetabaar anu ra kikil anun Saakaria, Saakaria ut i paam anuna pinapaam na wetabaar namataan God. ");
INSERT INTO rai_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Welaar ma ra mangamangaan na pipilak baa a kum tena wetabaar karom God diat laana muri, diat pilak paa Saakaria kupi ia ut in ruk u ra ruma na wetabaar anu ra Tadaaru, ma in tun a utnaa baa i aangawian wakwakaak. ");
INSERT INTO rai_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","U ra pakaana bung baa i tun a utnaa baa i aangawian wakwakaak, a taara na lotu raap baa diat tur nataamaan diat aaraaring. ");
INSERT INTO rai_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A aangelo anu ra Tadaaru i waan paat karom Saakaria, ma i tur taau u ra papaara ot naa ra luwu na tuntun wetabaar, baa di tun a utnaa baa i aangawian wakwakaak uni. ");
INSERT INTO rai_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Baa Saakaria i babo paai, a panina i urugian, ma i burut aakit uni. ");
INSERT INTO rai_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma a aangelo i piri taana naa, “Saakaria, koku burut, God ia walangoro anum niaaring, ma anum tabuan Elisabet in buta paa ta natumlik a muaana, ma un taar a iaana baa Ioaanes. ");
INSERT INTO rai_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Un gaaia aakit uni, ma mongoro kaai diat a gaaia u ra nuna binabuta, ");
INSERT INTO rai_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","maa in ngaala namataa ra Tadaaru. Pa in inim a waain, baa a palaa na longlong, ma baa pa din butai utbaai ia teng ma ra Takado na Nion. ");
INSERT INTO rai_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma in ben talili ta mongoro na taara Israael karom a Tadaaru anundiat God. ");
INSERT INTO rai_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","In dekdek aakit welaar ma ra propet Eliaas, in muga taa ra Tadaaru, kupi in ben ungaai balet a kum tamtamaa ra kum naat karom a kum natnatundiat kupi diat a wemaraam balet, ma in ben paa a taara na wabulbul balet kup a koina ninunuk anu ra kum takado na taara, kupi in waninaar a taara anu ra Tadaaru kup anuna winawaan paat.” ");
INSERT INTO rai_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Saakaria i tiri aangelo naa, “Ang nunura lelawaai naa a utnaa mi in waan paat? Maa mir, mir aa takaana raap.” ");
INSERT INTO rai_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma aangelo i baalui naa, “Iaau Gaabriel, iaau laana tur namataan God. Ia ut i tula wa iaau kupi ang wapua ui, ma ang lo a koina wewapua mi karom ui. ");
INSERT INTO rai_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Iaku ui, pa u nurnur u ra nung pirpir. In waan paat takado ut u ra kilaalaina. Baboi, mi pa un pirpir, maa kabina pa u nurnur. Un munga ku tuk u ra pakaana bung baa a utnaa mi in waan paat uni.” ");
INSERT INTO rai_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","U ra pakaana bung maa a taara diat kiki walaang kup Saakaria, diat ngaraa baa ia ki iwan aakit u ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Baa i waan pari, pa i pirpir laar paai ma karom diat, i tututuk maku karom diat ma ra ru limaana. Io, diat nunurai naa Saakaria ia babo taa ta binabo u ra ruma na wetabaar. ");
INSERT INTO rai_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Baa ia raap anuna pakaana bung na pinapaam, i waan talili kup anuna taamaan. ");
INSERT INTO rai_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma namur, Elisabet anuna tabuan i kipbaala, ma lima na kalaang pa i waan ingen paa ko ra ruma. ");
INSERT INTO rai_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma i piri naa, “Mi maraagaam a Tadaaru i waraaut iaau ma i lo wa a utnaa baa iaau wawirwir uni naa ra taara.” ");
INSERT INTO rai_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Baa ia 6 na kalaang anun Elisabet, God i tula wa aangelo Gaabriel urong Gaalilaia un raa taamaan a iaana Naasaret. ");
INSERT INTO rai_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","I waan karom a inip na tabuan a iaana Maaria, a pet webaat anun Iosep, ia baa ko ra wuna taara anun king Dewid. ");
INSERT INTO rai_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A aangelo i ruk karom Maaria ma i piri taana naa, “Un gaaia, u daan aakit! A Tadaaru i ki karom ui.” ");
INSERT INTO rai_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ma Maaria i nuknuk laklagon aakit u ra pirpir mi, baa aawa a kukuraaina. ");
INSERT INTO rai_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma a aangelo i piri taana naa, “Maaria, koku burut, God i gaaia aakit un ui. ");
INSERT INTO rai_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Walangoroi! Un kipbaala, un buta paa a naat muaana, ma un taar taa a iaana baa Iesu. ");
INSERT INTO rai_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma a iaana in rarang, ma din waatungi naa a Natun God a Ngaala Aakit. Ma a Tadaaru God, in waki taai u ra kiki na king anun tabuna Dewid, ");
INSERT INTO rai_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ma in naagagon takum a wuna taara anun Iaakob, ma anuna mataanitu pa in raap.” ");
INSERT INTO rai_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maaria i tiri aangelo naa, “In papet lelawaai mi, maa pa mir laa ungaai ma ta muaana?” ");
INSERT INTO rai_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A aangelo i baalui naa, “A Takado na Nion in ki un ui, ma a dekdekin God a Ngaala Aakit in pulu baat ui. Lenmaa a Tena Gomgom baa un buta paai, din waatungi naa a Natun God. ");
INSERT INTO rai_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Baboi, a kakum Elisabet ia takaana, ma di waatungi naa a bi, iaku mari ia kipbaala, ma ia 6 na kalaang anuna. ");
INSERT INTO rai_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maa pa ta utnaa i dekdek karom God.” ");
INSERT INTO rai_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Maaria i piri naa, “Iaau, iaau a tultul anu ra Tadaaru, din paami un iaau welaar ma ra num pirpir.” Ma a aangelo i waan paa koni. ");
INSERT INTO rai_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Namur Maaria i waninaar paa, ma i waan tato gagaa kup a taamaan baa i ki nate u ra kum taangaai u ra papaar Iudaia. ");
INSERT INTO rai_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","I ruk u ra ruma anun Saakaria, ma i wataa na gaaia paa Elisabet. ");
INSERT INTO rai_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Baa Elisabet i walangoro paa a wewataai na gaaia anun Maaria karomi, a naat i gula u ra in balaana, ma Elisabet i teng ma ra Takado na Nion. ");
INSERT INTO rai_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma i pirpir ma ra ngaala na ingaana naa, “Ui u daan taa ra in tabuan raap, ma a naat kaai baa un butai i daan. ");
INSERT INTO rai_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iaau woi na mangaana tabuan mi maa naa ra nung Tadaaru in waan karom iaau? ");
INSERT INTO rai_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Baa iaau walangoro anum wewataai na gaaia karom iaau, a naat i gaaia, ma i gula u ra in balaang. ");
INSERT INTO rai_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","U daan baa u nurnur naa a pirpir anu ra Tadaaru karom ui in waan paat lingtatuna.” ");
INSERT INTO rai_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maaria i piri naa, “A niong i pir walaawa paa a Tadaaru, ");
INSERT INTO rai_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma in balaang i gaaia un God, anung Tena Walaaun, ");
INSERT INTO rai_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","maa i maari iaau anuna tultul na tabuan, baa iaau a tabuan biaa ku iaau. Turpaai mari a kum taaun taara raap diat a piri un iaau naa iaau daan, ");
INSERT INTO rai_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","maa Ia baa i Dekdek, ia paam taa a kum ngaala na utnaa un iaau, a iaana i gomgom. ");
INSERT INTO rai_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anuna maarmaari i ki karom a kum taaun taara raap baa diat rui. ");
INSERT INTO rai_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I paam a kum dekdek na pinapaam ma ra limaana, ma u ra dekdekina i kamaar weraana wa diat baa diat aamaamaan ngaala u ra nuknukindiat. ");
INSERT INTO rai_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I ong pari wa a kum king ko ra nundiat kum kiki na ngaala, ma i wangaala pa diat baa di nuki naa diat a taara biaa ku. ");
INSERT INTO rai_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I tabaara a kum iba na taara ma ra kum kokoina utnaa ma i tula wa a kum tadaaru ma ra pabon na limaandiat. ");
INSERT INTO rai_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I waraaut anuna kum tultul, a taara Israael, maa i nuk paa anuna maarmaari ");
INSERT INTO rai_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","karom Aabaraam ma ra nuna wuna taara takum, welaar ma ia pir taai karom anundaat wuna taara taanga namuga.” ");
INSERT INTO rai_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma Maaria i ki karom Elisabet welaar ma tula kalaang, ma namur i waan talili balet kup anuna taamaan. ");
INSERT INTO rai_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Io, baa a bung anun Elisabet i ot kupi in babuta uni, i buta paa a naat muaana. ");
INSERT INTO rai_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A kum teptepaana ma a kum kakuna diat walangoroi baa a Tadaaru i maari aakit Elisabet, ma diat gaaia ungaai mai. ");
INSERT INTO rai_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Baa ia 8 na bung anu ra naat, diat waninaar kupi din poko kikili, ma diat nemi kupi diat a taar taa a iaan tamaana Saakaria uni. ");
INSERT INTO rai_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Iaku naana i piri naa, “Koku, a iaana ut Ioaanes.” ");
INSERT INTO rai_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Diat piri taana naa, “Pa ta kakum i lo a iang maa.” ");
INSERT INTO rai_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Namur diat paam a kum wakilang ma ra limaandiat karom tamaana, ma diat tiri naa woi na iang i nemi naa din ungi u ra naat. ");
INSERT INTO rai_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma i tutuk kup ta utnaa baa in timtimu uni, ma i timui naa, “A iaana Ioaanes.” Diat raap diat kakaian. ");
INSERT INTO rai_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma a waan Saakaria i paapa, ma in kaarmene i tapalaa, ma i pirpir maut, i pir walaawa paa God. ");
INSERT INTO rai_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma a kum teptepaandiaar raap, diat burut aakit. A kum pirpir u ra utnaa mi, i waan werweraan u ra kum taamtaamaan baa diat ki nate u ra kum taangaai u ra papaar Iudaia. ");
INSERT INTO rai_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Diat raap baa diat walangoroi, diat nuknuk aakit uni, ma diat piri naa, “A mangaana naat aawa mi?” Maa diat baboi naa a dekdek i ra Tadaaru i ki uni. ");
INSERT INTO rai_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Saakaria tamaan Ioaanes, i teng ma ra Takado na Nion, ma i pirpir na propet lenbi, ");
INSERT INTO rai_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Daat a pir walaawa paa a Tadaaru, a God anu ra taara Israael, maa ia waan paat karom anuna taara, ma ia kul walaangalaanga pa diat. ");
INSERT INTO rai_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ia taar taa a dekdek na Tena Walaaun karom daat, ko ra wuna taara anu ra nuna tultul Dewid, ");
INSERT INTO rai_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","welaar ma ia pir taai namuga utbaai ko ra waa ra nuna kum gomgom na propet. ");
INSERT INTO rai_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ia taar taai kupi in walaaun pa daat ko ra nundaat kum ebaar, ma ko ra limaandiat raap baa diat milikuaana daat, ");
INSERT INTO rai_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ma kupi in maari anundaat wuna taara taanga namuga ma in paam ot paa anuna gomgom na kunubu. ");
INSERT INTO rai_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I weweliman taau karom tabundaat Aabaraam, ");
INSERT INTO rai_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","naa in walaaun pa daat ko ra limaa ra nundaat kum ebaar, kupi daat a papaam karomi ma pa daat a burut. ");
INSERT INTO rai_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Daat a papaam karomi ma ra mangamangaan baa i gomgom ma i takado namataana, u ra nundaat kum bungbung na lalaaun raap. ");
INSERT INTO rai_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma ui natunglik, din waatung ui, a propet anun God a Ngaala Aakit, maa un waanwaan muga taa ra Tadaaru, ma un paam aara muga anuna aakapi, ");
INSERT INTO rai_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kupi din wakaapa anuna taara naa din walaaun pa diat, baa di aa una wa nundiat kum aakaina mangamangaan, ");
INSERT INTO rai_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kabina u ra ngaala na maarmaari anu ra nundaat God. Ma u ra nuna maarmaari a kaapa na warwalaaun taanginaanga nate in puaa paat karom daat. ");
INSERT INTO rai_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","In puaa un diat baa diat ki u ra baboto, ma u ra baboto na minaat, kupi in muga daat u ra aakapi na maalmaal.” ");
INSERT INTO rai_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma a naat i ngaala waanwaan ma i dekdek waanwaan u ra niono. Ma i ki u ra bil na wanua tuk i tur paat karom a taara Israael. ");
INSERT INTO rai_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","U ra kilaala maa, Kaaisaar Aaugusto i naagagoni kupi din timu a iaa ra taara u ra kum taamaan raap baa Rom i naagagon diat. ");
INSERT INTO rai_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bi ia a mugaana pakaan baa di timu iaandi baa Kirinio i naagagon Siria. ");
INSERT INTO rai_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma a taara raap diat waan kup anundiat kum taamtaamaan mulu kupi din timu iaandiat. ");
INSERT INTO rai_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosep kaai i waan ko ra taamaan Naasaret u ra papaar Gaalilaia kup a taamaan Betilem u ra papaar Iudaia. Betilem, a taamaan baa di buta Dewid iaai, maa Iosep ia ko ra wuna taara anun Dewid. ");
INSERT INTO rai_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I waan kupi din timu a iaana, ungaai ma ra iaan Maaria anuna pet webaat. Baa diaar waan Maaria ia kipbaala. ");
INSERT INTO rai_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma baa diaar ki irong Betilem, i ot a bung kupi Maaria in babuta uni, ");
INSERT INTO rai_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ma i buta paa a mugaana natuna, a naat muaana. Ma i pului ma ra kum maalu na naat, ma i wainep taai u ra wuwuwung na winangaan ara kum wewagua, kabina maa a ruma na ininep aagil ia teng paa kon ditul. ");
INSERT INTO rai_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Raa kum tena baboura sip diat baboura anundiat kum liur na sip u ra marum inaanga nabuaal marawaai u ra taamaan maa. ");
INSERT INTO rai_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma a aangelo anu ra Tadaaru i waan paat paa karom diat, ma ra minamaar anu ra Tadaaru i baarabaara lili diat, ma diat burut aakit. ");
INSERT INTO rai_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A aangelo i piri taan diat naa, “Koku muaat burut. Muaat baboi, iaau waan paat karom muaat ma ra koina wewapua baa in wagaaia a taara raap. ");
INSERT INTO rai_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mari, u ra taamaan anun Dewid, di aa buta paa anumuaat Tena Walaaun, ia baa Kaarisito, a Tadaaru. ");
INSERT INTO rai_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma muaat a babo kup a wakilang lenbi: A naat di pulu taai ma ra kum maalu na naat, ma di wainep taai ku u ra wuwuwung na winangaan ara kum wewagua.” ");
INSERT INTO rai_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pa i iwan ku ma a ngaala na kor na aangelo taanginaanga u ra maawa diat waan paat karom a aangelo maa, ma diat pir walaawa paa God lenbi, ");
INSERT INTO rai_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“A pir walaawa karom God inaanga nate aakit, ma a maalmaal u ra rakrakaan buaal raap karom diat baa i gaaia un diat.” ");
INSERT INTO rai_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Baa a kum aangelo diat aa waan kon diat unaanga nate u ra maawa, a kum tena baboura sip diat piri naa, “Mi ut daat a waan urong Betilem, daat a babo a utnaa mi ia waan paat, baa a Tadaaru ia wapua ta daat uni.” ");
INSERT INTO rai_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Io diat waan gagaa, ma diat baat paa Maaria ma Iosep ma ra naat mangalon baa di wainep taai ku u ra wuwuwung na winangaan ara kum wewagua. ");
INSERT INTO rai_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Baa diat babo a naat, diat pir waiaa a pirpir baa aangelo ia wapua ta diat uni u ra naat maa. ");
INSERT INTO rai_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma diat raap baa diat walangoro a pirpir anu ra kum tena baboura sip, diat kakaian aakit uni. ");
INSERT INTO rai_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Baa Maaria i walangoro a kum pirpir mi, i paam akotoi u ra in balaana ma i nuknuk aakit uni. ");
INSERT INTO rai_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A kum tena baboura sip diat waan talili, diat wangaala paa God ma diat pir walaawa paai u ra kum utnaa diat walangoroi ma diat aa babo taai, welaar ma ra pirpir anu ra kum aangelo. ");
INSERT INTO rai_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Baa i 8 na bung anu ra naat, ma i ot kupi din poko kikili, di taar taa a iaana baa Iesu, welaar ma ra pirpir a aangelo ia pir taai baa Maaria pa i kipbaala utbaai. ");
INSERT INTO rai_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Baa ia raap a kum bungbung na wagomgom anun Iosep ma Maaria, welaar ma ra Naagagon anun Moses, diaar waan unaanga Ierusalem kupi diaar a wetabaar ma “ruina buna baa ru baarmaan na kuwur,” Lewi 12:8 welaar ma ra pirpir na Naagagon anu ra Tadaaru. Io, diaar lo Iesu kaai unaanga Ierusalem, kupi diaar a taar taai taa ra Tadaaru, welaar ma di aa timu taai u ra Naagagon anu ra Tadaaru naa, “A kum mugaana naat muaana raap ma ra kum mugaana muaana na wewagua, din taar ta diat karom a Tadaaru.” Pin 13:2,12 ");
INSERT INTO rai_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Raa muaana i ki inaanga Ierusalem a iaana Simion, a tena takado ma a tena urur kaai karom God. I kiki walaang kup a warwalaaun anu ra taara Israael, ma a Takado na Nion i ki uni. ");
INSERT INTO rai_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Takado na Nion ia wapuaana taai karomi naa pa in maat gagaa, in babo muga taa ut a Kaarisito anu ra Tadaaru. ");
INSERT INTO rai_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Takado na Nion i muga ruki u ra ruma na wetabaar. Baa i babo paa naadiaarwaana diaar waan paat ma ra naat Iesu kupi diaar a paam a wetabaar welaar ma di aa timu taai u ra kum Naagagon, ");
INSERT INTO rai_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion i lo paa Iesu ma ra ru limaana. Ma i pir walaawa karom God lenbi, ");
INSERT INTO rai_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tadaaru, mi un walaangalaanga wa iaau, anum tultul, kupi ang waan ma ra maalmaal, welaar ut ma ra num pirpir. ");
INSERT INTO rai_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iaau aa babo taa anum warwalaaun ma ra mataang, ");
INSERT INTO rai_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a warwalaaun, baa u aa waninaar paai namataa ra kum wuna taara raap. ");
INSERT INTO rai_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A kaapa kup in wakaapakaapa anum aakapi karom diat baa wakir a taara Israael, ma kupi a minamaar karom anum taara Israael.” ");
INSERT INTO rai_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tamaana ma naana diaar kakaian aakit u ra kum pirpir mi Simion i piri un Iesu. ");
INSERT INTO rai_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion i pir wadaan diaar, ma i piri taan Maaria, naan Iesu, naa, “A naat mi God i pilak paai kupi mongoro na te Israael diat a wirua uni ma ra mongoro kaai diat a lalaaun uni, ma kupi a wakilang baa mongoro na taara diat a milikuaanai. ");
INSERT INTO rai_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Baa diat a milikuaanai din wapuaana a kum ninunuk ko ra balaan mongoro na taara. Ma ui, a tapunuk baa un kariaanai in welaar ma in liwan na wineium baa in go anum lalaaun.” ");
INSERT INTO rai_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Io, raa tabuan bulung, a propet, a iaana Aanaa, i waan paat karom ditul u ra pakaana bung maa. A tabuan mi a natun Paanuel, ko ra wuna taara Aaser. Ia takaana aakaka, ia 84 na kilaala anuna ma i walaa maku. Diaar taulaa paa ku 7 na kilaala ma namur anuna muaana i maat. A tabuan mi pa i waan paa ko ra ruma na wetabaar, i lotlotu u ra bungbung na mage ma u ra bungbung na marum, i laana wawel ma i laana aaraaring. Baa i waan paat karom ditul i waatung wakaak paa karom God, ma i wewapua u ra naat karom diat raap baa diat kiki walaanga paa a warwalaaun anun Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Baa Iosep ma Maaria diaar aa paam ot paa a kum utnaa raap welaar ma ra Naagagon anu ra Tadaaru, ditul waan talili balet urong Gaalilaia kup anundiat taamaan Naasaret. ");
INSERT INTO rai_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma a naat i tawa ma i dekdek waanwaan, ma i teng ma ra manaana, ma ra maarmaari anun God i ki uni. ");
INSERT INTO rai_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","U ra kum kilakilaala raap tamaan Iesu ma naana diaar laana waan unaanga Ierusalem u ra lukaara na waan likaai. ");
INSERT INTO rai_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Baa ia 12 kilaala anun Iesu, ditul waan unaanga Ierusalem kup a lukaara na waan likaai, welaar ut maa diat laana paami. ");
INSERT INTO rai_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baa a lukaara ia raap, diat waan talili balet, ma Iesu i ki okot ku inaanga Ierusalem, iaku tamaana ma naana pa diaar nunurai. ");
INSERT INTO rai_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Diaar nuki naa diat weur ma ra taara. Baa ia raa bung u ra nundiat winawaan talili diaar turpaai kupi diaar a baat kup Iesu naa ra kum kakunditul, ma ra kum teptepaanditul. ");
INSERT INTO rai_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Baa diaar gaana baatbaat taau kupi, diaar waan talili balet unaanga Ierusalem, ma diaar baat kupi manaanga. ");
INSERT INTO rai_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Baa diaar aa baat paa tula bung, diaar babo baraata paa Iesu u ra ruma na wetabaar. I ki ungaai ma ra kum tena wawer u ra kum Naagagon, i walwalangoro diat, ma i tirtiri diat. ");
INSERT INTO rai_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma diat raap baa diat walangoroi, diat kakaian u ra nuna manaana, ma u ra nuna kum binabaalu karom diat. ");
INSERT INTO rai_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Baa diaar babo paai, diaar kakaian, ma naana i piri taana naa, “Natunglik, aawa kabina maa u paami lenmi un mir? Mir ma tamaam mir aa baat raap paa kup ui, ma mir ngaraa aakit un ui.” ");
INSERT INTO rai_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma i piri taan diaar naa, “Aawa maa mur baatbaat kup iaau uni? Pa mur nunurai naa i takado kupi ang ki u ra ruma anun Tamaang?” ");
INSERT INTO rai_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iaku pa diaar kaapa u ra nuna pirpir. ");
INSERT INTO rai_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Namur ditul waan talili urong Naasaret, ma i tartaraam karom diaar, ma naana i nuk akoto a kum utnaa raap mi. ");
INSERT INTO rai_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu i tawa waanwaan u ra panina ma u ra nuna manaana, ma i ngaala a gaaia anun God ma ra taara uni. ");
INSERT INTO rai_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Baa i wenoina ma lima na kilaala na naagagon anun Kaaisaar Tiberio, Pontio Pilaato a ngaala na mukmuga i naagagon u ra papaar Iudaia, ma Erodes i mukmuga u ra papaar Gaalilaia, ma tenalik Pilipo i mukmuga u ra ru papaar Ituraaia ma Traakoniti, ma Lisaanio i mukmuga u ra papaar Aabilene ");
INSERT INTO rai_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ma Aanaas ma Kaaiapaas diaar lo a pinapaam na mukmuga na tena wetabaar karom God. U ra kilaala maa a pirpir anun God i waan paat karom Ioaanes, natun Saakaria baa i ki inaanga u ra bil na wanua. ");
INSERT INTO rai_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma i waan u ra kum wanua raap marawaai u ra daanim Ioridaan, i warawaai naa a taara diat a nukpuku ma din baapitaaiso diat, ma God in una wa anundiat kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Welaar ma di aa timu taai u ra buk anu ra propet Aaisaia naa, “In ingaan raa i wewataai u ra bil na wanua lenbi, ‘Muaat a paam aara aakapi anu ra Tadaaru, muaat a paam kado anuna kum aakapi. ");
INSERT INTO rai_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A kum maale raap din punang diat ma a kum tiltil raap ma ra kum taangaai din kil kado diat. A kum aakapi baa i pagol din wakadoi, ma a kum wanua i tungtung, din punang kadoi. ");
INSERT INTO rai_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma a taara raap diat a babo a warwalaaun anun God.’” Aais 40:3-5 ");
INSERT INTO rai_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A kor na taara diat waan paat karom Ioaanes kupi in baapitaaiso diat. Ma i piri taan diat naa, “Aai, muaat a kum natu ra kum wui! Woi maa i piri naa muaat a kalaa ino ko ra naagagon na binabaalu anun God baa in waan paat? ");
INSERT INTO rai_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Muaat a paam a kum utnaa baa in wapuaanai naa muaat aa nukpuku. Ma koku muaat nuki naa God pa in naagagon muaat maa kabina muaat a wuna taara anun Aabaraam. Iaau piri taa muaat naa, God i pet laar paai kupi in paam apaat paa a wuna taara anun Aabaraam ko ra kum waat bi. ");
INSERT INTO rai_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Di aa ung taa a naawa naa ra kum kapkabina diwaai, ma a kum diwaai raap baa pa diat wa ta koina waindiat, din bur wa diat, ma din ong ta diat u ra nguan.” ");
INSERT INTO rai_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A kor na taara diat tiri naa, “Aawa maa miaat a paami?” ");
INSERT INTO rai_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I baalu diat naa, “Ia baa anuna ta ruina maalu na minong, in taar taa tin taan te baa pa nuna tina maalu na minong, lenkaai maa u ra utnaa na winangaan.” ");
INSERT INTO rai_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma raa kum tena lolo tatakom diat waan paat kupi in baapitaaiso diat. Ma diat tiri naa, “Tena wawer, aawa maa miaat a paami?” ");
INSERT INTO rai_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma i baalu diat naa, “Koku muaat lo a tatakom i ngaala taa ra toto di aa naagagon taai.” ");
INSERT INTO rai_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma raa kum tena wineium diat tiri naa, “Ma miaat, aawa maa miaat a paami?” Ma i baalu diat naa, “Koku muaat pet na kaankaan biaa paa ku a maani ko ra taara, ma koku muaat wetakun warwaruga, muaat a gaaia paa ku anumuaat wedok.” ");
INSERT INTO rai_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A taara diat kiki walaang kup Kaarisito. Baa diat walangoro Ioaanes, diat nuki naa kanaapi Kaarisito ma mi ia waan paat. ");
INSERT INTO rai_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma Ioaanes i piri taan diat raap naa, “Iaau baapitaaiso muaat ma ra palaa, iaku ia baa i ngaala taang in waan paat, in baapitaaiso muaat ma ra Takado na Nion ma ra nguan. Ma iaau, iaau kinalik aakit taana. ");
INSERT INTO rai_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I paam paa anuna saaol u ra limaana kupi in ong weraana a panina wit ko ra wit mulu. Baa ia wali raap taai in ung ungaai anuna wit u ra nuna ruma na wit, ma in tun wa a kum panpanina u ra nguan baa pa in maat.” ");
INSERT INTO rai_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Baa Ioaanes i warawaai karom diat ma ra Koina Wewapua i wadekdek diat ma ra mongoro na pirpir kupi diat a puku anundiat mangamangaan. ");
INSERT INTO rai_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma Ioaanes i pirpir dekdek karom Erodes a mukmuga, kabina maa i taulaa balet ma Erodiaa, a tabuan anun tenalik. Ma i pirpir dekdek u ra kum aakaina utnaa raap kaai baa Erodes ia paam taai. ");
INSERT INTO rai_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma Erodes i paam balet ku aakaina mangamangaan baa i waruk taa Ioaanes u ra ruma na karabus. ");
INSERT INTO rai_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Baa Ioaanes i baapitaaiso a taara raap, i baapitaaiso kaai Iesu. Ma baa i aaraaring, a maawa i tapaapa, ");
INSERT INTO rai_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma a Takado na Nion i waan pari, i ung a panina welaar ma ra ina buna, ma i ki taau nate un Iesu. Ma in ingaan raa taanginaanga u ra maawa i piri lenbi, “Ui Natunglik, a naat na wakwakaak, iaau gaaia aakit un ui.” ");
INSERT INTO rai_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu i turpaa anuna pinapaam baa i 30 duk anuna kilaala na lalaaun. Ia a natun Iosep, a nuknuki ra taara ku lenmaa. Iosep a natun Eli, ");
INSERT INTO rai_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli a natun Maataat, Maataat a natun Lewi, Lewi a natun Melki, Melki a natun Iaanaa, Iaanaa a natun Iosep, ");
INSERT INTO rai_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosep a natun Maatatio, Maatatio a natun Aamos, Aamos a natun Naaum, Naaum a natun Esli, Esli a natun Naagaai, ");
INSERT INTO rai_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naagaai a natun Maat, Maat a natun Maatatio, Maatatio a natun Semein, Semein a natun Iosek, Iosek a natun Iodaa, ");
INSERT INTO rai_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iodaa a natun Ioaanaan, Ioaanaan a natun Resaa, Resaa a natun Serubaabel, Serubaabel a natun Salaatiel, Salaatiel a natun Neri, ");
INSERT INTO rai_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri a natun Melki, Melki a natun Aadi, Aadi a natun Kosaam, Kosaam a natun Elmaadaam, Elmaadaam a natun Er, ");
INSERT INTO rai_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er a natun Iosua, Iosua a natun Elieser, Elieser a natun Iorim, Iorim a natun Maataat, Maataat a natun Lewi, ");
INSERT INTO rai_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi a natun Simion, Simion a natun Iuda, Iuda a natun Iosep, Iosep a natun Ionaam, Ionaam a natun Eliaakim, ");
INSERT INTO rai_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaakim a natun Melea, Melea a natun Menaa, Menaa a natun Maataataa, Maataataa a natun Naataan, Naataan a natun Dewid, ");
INSERT INTO rai_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewid a natun Iese, Iese a natun Obed, Obed a natun Boaas, Boaas a natun Saalmon, Saalmon a natun Naason, ");
INSERT INTO rai_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason a natun Aaminadaab, Aaminadaab a natun Aadmin, Aadmin a natun Aarni, Aarni a natun Esrom, Esrom a natun Peres, Peres a natun Iuda, ");
INSERT INTO rai_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iuda a natun Iaakob, Iaakob a natun Aaisaak, Aaisaak a natun Aabaraam, Aabaraam a natun Teraa, Teraa a natun Naakor, ");
INSERT INTO rai_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naakor a natun Seruk, Seruk a natun Raagaa, Raagaa a natun Pelek, Pelek a natun Eber, Eber a natun Saalaa, ");
INSERT INTO rai_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saalaa a natun Kaainaan, Kaainaan a natun Aapakaad, Aapakaad a natun Sem, Sem a natun Noaa, Noaa a natun Laamek, ");
INSERT INTO rai_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laamek a natun Maatuselaa, Maatuselaa a natun Enok, Enok a natun Iaared, Iaared a natun Maalelel, Maalelel a natun Kaainaan, ");
INSERT INTO rai_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaainaan a natun Enos, Enos a natun Set, Set a natun Aadaam, Aadaam a natun God. ");
INSERT INTO rai_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu i teng ma ra Takado na Nion. Baa i waan taangirong u ra daanim Ioridaan, a Nion i mugai unaanga u ra bil na wanua. ");
INSERT INTO rai_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","I ki matira 40 bungbung ma Saataan i walaami. Pa i wangaan, ma baa ia raap a kum bungbung maa, i molo. ");
INSERT INTO rai_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Saataan i piri taana naa, “Baa ui a Natun God, un piri karom ina waat bi kupi in tapuku kup in bred.” ");
INSERT INTO rai_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu i baalui naa, “Di aa timu taai u ra Buk Taabu naa, ‘A taara pa diat lalaaun ko ra utnaa na winangaan ku.’” Naag 8:3 ");
INSERT INTO rai_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Saataan i ben paai un raa wanua inaanga nate, ma i waiaa taa a kum mataanitu raap u ra rakrakaan buaal taana u ra naat na pakaana bung ku. ");
INSERT INTO rai_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma i piri taana lenbi, “Ang tabaara ui ma ra dekdek ma ra kum minamaar indiat raap, maa di aa taar taai taang, ma ang taari karom te baa iaau nemi. ");
INSERT INTO rai_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Baa un lotu karom iaau, anum raap ku a kum utnaa mi.” ");
INSERT INTO rai_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu i piri taana naa, “Di aa timu taai u ra Buk Taabu lenbi, ‘Un lotu karom a Tadaaru anum God, ma un taraam ku karomi.’” Naag 6:13 ");
INSERT INTO rai_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ma Saataan i ben paai unaanga Ierusalem, ma i waki taai un raa pakaan inaanga nate aakit u ra ruma na wetabaar. Ma i piri taana naa, “Baa ui a Natun God, un irok pari taanga min, ");
INSERT INTO rai_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","maa di aa timu taai u ra Buk Taabu lenbi, ‘In tula wa anuna kum aangelo kupi diat a baboura wakaak ui. ");
INSERT INTO rai_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Diat a lo pa ui ma ra kum limaandiat, kupi koku u tukaa paa a kakim un ta waat.’” Kele 91:11-12 ");
INSERT INTO rai_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu i baalui naa, “Di aa pir taai u ra Buk Taabu lenbi, ‘Koku u walaar a Tadaaru anum God.’” Naag 6:16 ");
INSERT INTO rai_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Baa Saataan ia walaar taai ma ra kum walwalaam raap mi, i waan paa kumun koni. ");
INSERT INTO rai_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu i waan talili urong u ra papaar Gaalilaia ma ra dekdek i ra Takado na Nion, ma a pirpir uni i waan werweraan u ra papaar raap maa. ");
INSERT INTO rai_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma Iesu i wer a taara u ra nundiat kum ruma na lotu, ma diat raap diat pir walaawa paai. ");
INSERT INTO rai_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Baa Iesu i waan paat irong Naasaret, a taamaan baa i ngaala iaai, i ruk u ra ruma na lotu u ra Bung Saabaat, welaar ma ra nuna mangamangaan ut, ma i tur kupi in luluk. ");
INSERT INTO rai_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma di taar taa a buk anu ra propet Aaisaia karomi. I palaa paa a buk baa di aa pipin taai, ma i babo a pakaana baa di aa timu taai uni lenbi, ");
INSERT INTO rai_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A Nio ra Tadaaru i ki un iaau, maa ia pilak pa iaau kupi ang warawaai ma ra Koina Wewapua karom a kum iba na taara. Ia tula wa iaau kupi ang warawaai lenbi, din palaa wa diat baa di aa wi baat ta diat, din wababo balet a kum pula, din walaangalaanga wa diat baa diat kariaana a mawaat baa di aa paam taai un diat, ");
INSERT INTO rai_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma ang wewapua u ra kilaala na maarmaari anu ra Tadaaru mi ia waan paat.” Aais 61:1-2 ");
INSERT INTO rai_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I pipin taa balet a buk maa, i taar taai karom a tultul, ma i ki balet. A taara raap u ra ruma na lotu diat babo dekdeki, ");
INSERT INTO rai_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ma i piri taan diat naa, “A pirpir mi muaat walangoroi, mari di aa paam ot paai.” ");
INSERT INTO rai_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma diat gaaia paai, ma diat kakaian u ra nuna koina pirpir. Ma diat piri uni naa, “Aai, a muaana mi a natun Iosep ku.” ");
INSERT INTO rai_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma i piri taan diat naa, “Kaduk muaat a pir a pirpir welwelaar bi un iaau: ‘Doktaa, un walaangalaanga pa ui ut! A kum utnaa raap baa miaat walangoroi naa u aa paam taai irong Kaapernaaum, koina baa un paami utkaai min u ra num taamaan.’” ");
INSERT INTO rai_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma Iesu i piri kaai taan diat naa, “Iaau pir a lingtatuna taa muaat, pa ta propet di urur karomi u ra nuna taamaan ut. ");
INSERT INTO rai_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A lingtatuna ut baa mongoro na walaa na tabuan diat ki Israael u ra kilaala anun Eliaas, baa tula kilaala ma 6 na kalaang pa i baata, ma a ngaala na minolo i manong a kum taamtaamaan raap. ");
INSERT INTO rai_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iaku pa di tula wa Eliaas karom ta te Israael, karom a walaa na tabuan ku u ra taamaan Saareptaa ko ra papaar Sidon. Ia baa wakir a tabuan Israael. ");
INSERT INTO rai_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma mongoro na wukawuka diat ki Israael u ra kilaala anu ra propet Elisa, iaku pa di walaangalaanga te kon diat, Naamaan ku a muaana taanga Siria, baa wakir a te Israael.” ");
INSERT INTO rai_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A taara raap baa diat ki u ra ruma na lotu, diat kaankaan aakit baa diat walangoro a kum pirpir mi. ");
INSERT INTO rai_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Io, diat tur, ma diat lu wa Iesu ko ra nundiat taamaan. Diat aal paai unaanga u ra taangaai baa diat paam taa anundiat taamaan uni, kupi diat a ong pari Iesu u ra papaara waat. ");
INSERT INTO rai_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Iaku i waan ku naliwan naa ra kor na taara, ma i waan paa kon diat. ");
INSERT INTO rai_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Namur Iesu i waan urong Kaapernaaum, u ra papaar Gaalilaia, ma i wer diat u ra Bung Saabaat. ");
INSERT INTO rai_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma diat kakaian u ra nuna wawer, maa i wer diat lenbaa ia ut i paam akoto a naagagon. ");
INSERT INTO rai_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","U ra ruma na lotu raa muaana i ki, a tabaraan kuraa uni, i kulkulaai dekdek lenbi, ");
INSERT INTO rai_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aai! Ui Iesu a te Naasaret. Un paam aawa un miaat? U waan paat duk kupi un baanaakaka wa miaat. Iaau nunura ui, ui a Tena Gomgom anun God.” ");
INSERT INTO rai_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu i turbaati ma ra pirpir lenbi, “Koku pirpir! Pari ko ra muaana maa!” A tabaraan i ong pari taai namataandiat raap, i pari paa koni, ma pa ta utnaa i aaka u ra panina. ");
INSERT INTO rai_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A taara raap diat kakaian aakit, ma diat tiri wetwetalaai diat naa, “A mangaana pirpir aawa mi? I paam akoto a naagagon ma ra dekdek ma i naaknaagagon wa a kum tabaraan, ma diat pari maut.” ");
INSERT INTO rai_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma a pirpir un Iesu i waan werweraan u ra kum taamtaamaan raap u ra papaar maa. ");
INSERT INTO rai_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu i pari ko ra ruma na lotu, ma i waan kup a ruma anun Simon. Ma nimun Simon, a tabuan, i malaapaang ma ra ina wuwan, ma diat aaring Iesu kupi in waraauti. ");
INSERT INTO rai_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ma Iesu i tur taau naa ra baana, ma i lu wa ina wuwan koni, ma a tabuan maa i laangalaanga. Ma i tur maut, ma i tabaara diat ma ra utnaa na winangaan. ");
INSERT INTO rai_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Baa i tawiwibung, a taara diat ben pa diat raap baa diat malaapaang ma ra kum aalawur mangaana malaapaang karom Iesu. Ma i ung a ru limaana un diat raaraa, ma diat laangalaanga raap. ");
INSERT INTO rai_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma a kum tabaraan kaai diat pari kon ta mongoro, ma diat kulkulaai naa, “Ui a Natun God.” Ma Iesu i turbaat diat, kupi koku diat pirpir, kabina diat nunurai ut naa ia Kaarisito, baa God i tula wai. ");
INSERT INTO rai_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baa ia keke, Iesu i waan ko ra taamaan maa, kup a bil na wanua. A kor na taara diat baat kupi. Baa diat baat paai diat turbaati kupi koku ma i waan kon diat. ");
INSERT INTO rai_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Iaku i baalu diat naa, “Ang warawaai ma ra Koina Wewapua u ra mataanitu anun God un raa kum taamaan ingen kaai. Maa mi ia kabina baa i tula wa iaau urin.” ");
INSERT INTO rai_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma i warawaai u ra kum ruma na lotu u ra papaar Iudaia. ");
INSERT INTO rai_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Raa bung baa Iesu i tur nakono u ra taai kikil Genesaaret a taara diat liur baat paai, kupi diat a walangoro a pirpir anun God. ");
INSERT INTO rai_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma i babo paa a ru mon matira nakono, baa a kum tena ong bene diat aa waan paa kon diaar, kuraa diat gi anundiat kum bene. ");
INSERT INTO rai_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma Iesu i kaa tato taau un raa kon diaar, a mon baa anun Simon, ma i piri taana naa in tul kinalik taa a mon uaa nataai. Ma Iesu i ki taau uni, ma i wer a kor na taara. ");
INSERT INTO rai_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Baa ia raap anuna pirpir, i piri taan Simon naa, “Muaat a waan uaa u ra lamaana, ma muaat a ong anumuaat kum bene kup ta ian.” ");
INSERT INTO rai_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon i piri taana naa, “Tena Wawer, miaat aa pet doko pa miaat u ra marum raap, ma pa miaat aal paa ta ian, iaku kabina ui u wetulaa, ang ong taa balet a kum bene.” ");
INSERT INTO rai_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baa diat ong taa a kum bene, diat aal paa mongoro na ian aakit, ma ra nundiat kum bene marawaai diat a tarabaat. ");
INSERT INTO rai_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Diat kalua paa a kum teptepaandiat ko ra weru mon kupi diat a waraaut diat. Io, diat waan karom diat, ma diat wateng a ru mon raap, ma diaar pot na murung ma. ");
INSERT INTO rai_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon ma diat baa diat weur mai diat kakaian u ra kum ian baa diat aal paai, lenkaai maa karom a ru teptepaana, Iaakobo ma Ioaanes, a ru natun Sebedaaio. Baa Simon Petero i babo a utnaa mi, i puka pari ma ra urur naan Iesu ma i piri taana naa, “Tadaaru, waan kon iaau, iaau a tena aakaina.” Iesu i baalui naa, “Koku burut. Turpaai mari, un aalaal paa a taara.” ");
INSERT INTO rai_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Baa diat aa aalula taa a ru mon, diat waan paa ko ra nundiat kum utnaa raap, ma diat murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesu i ki un raa taamaan, ma raa muaana baa a panina raap i aaka ma ra wukawuka i ki matira. Baa i babo paa Iesu, i puka papaabum taau unapia ma ra urur ma i aaring dekdeki naa, “Tadaaru, pa i dekdek karom ui, baa u nemi, io, un walaangalaanga iaau.” ");
INSERT INTO rai_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma Iesu i kado wa a limaana, i paam a panina ma i piri taana naa, “Iaau nemi ut. Un laangalaanga.” Ma a wukawuka i raap maut koni. ");
INSERT INTO rai_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ma Iesu i pirpir dekdek taau karomi naa, “Koku wapua taa te uni. Un waan ma un waiaa muga ta ui karom a tena wetabaar karom God, ma un taar a wetabaar karom God welaar ma Moses ia pir taai. Baa un paami lenbi in kaapa karom a taara baa u aa laangalaanga.” ");
INSERT INTO rai_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iaku a pirpir un Iesu i waan werweraan bakaai ma, ma mongoro na taara diat waan ungaai kupi diat a walangoroi, ma kupi in walaangalaanga pa diat ko ra nundiat kum malaapaang. ");
INSERT INTO rai_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iaku mongoro na pakaan Iesu i laana waan ingen u ra bil na wanua kup a niaaring. ");
INSERT INTO rai_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Raa bung baa Iesu i wer a taara, raa kum Parisaaio ma raa kum tena wawer u ra kum Naagagon, diat ki karomi. Diat waan paat ko ra kum taamaan raap u ra papaar Gaalilaia ma u ra papaar Iudaia ma ko ra taamaan Ierusalem kaai. Ma a dekdek i ra Tadaaru i ki un Iesu kupi in walaangalaanga a kum malaapaang. ");
INSERT INTO rai_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Raa kum muaana diat lo paa a muaana baa a panpanina i maat, diat loi u ra baat. Diat walaari naa diat a ruk mai, kupi diat a wainep taai namuga naan Iesu. ");
INSERT INTO rai_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Iaku pa diat ruk laar paai mai, maa kabina a ngaala na kor na taara. Io, diat kaa mai unaanga nate u ra ruma, diat rakaan aara paa raa pakaan inaanga nate, ma diat warira pari taai ma ra baat naliwan naa ra kor na taara namuga naan Iesu. ");
INSERT INTO rai_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Baa Iesu i babo anundiat nurnur, i piri taa ra muaana maa, “Tepaang, di aa una wa anum kum aakaina mangamangaan.” ");
INSERT INTO rai_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A kum tena wawer u ra kum Naagagon ma ra kum Parisaaio, diat nuknuk u ra nuknukindiat naa, “Woi na mangaana muaana mi? I pir aakaka God baa i welaara ia mai. Woi in una wa a kum aakaina mangamangaan? God ku i pet laar paai.” ");
INSERT INTO rai_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu i nunura a nuknukindiat, ma i tiri diat naa, “Aawa kabina muaat nuknuk lenmi? ");
INSERT INTO rai_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Woi na mangaana pirpir ang piri kupi ang waiaa a dekdeking mai karom muaat? Ang piri naa, ‘Di aa una wa anum kum aakaina mangamangaan,’ baa, ‘Un tur, ma un waan’? ");
INSERT INTO rai_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Io, ang piri lenbi kupi muaat a nunurai naa Natu ra Muaana i paam akoto a naagagon kupi in una wa a kum aakaina mangamangaan min napia.” Io, i piri karom a muaana baa a panpanina i maat, “Iaau piri taam, un tur, un lo paa anum baat, ma un waan kup anum ruma.” ");
INSERT INTO rai_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma i tur maut namuga taan diat raap, i lo paa anuna baat, ma i waan kup anuna ruma. Baa i waan i pir walaawa paa God. ");
INSERT INTO rai_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma diat raap diat kakaian aakit, diat pir walaawa paa God, a panindiat i ururian aakit, ma diat piri naa, “Mari, daat babo a kum raaungaana utnaa i matakin u ra nundaat binabo.” ");
INSERT INTO rai_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baa ia raap a kum utnaa mi, Iesu i waan ma i babo paa a tena lolo tatakom, a iaana Lewi, baa i ki u ra ruma na tatakom, ma Iesu i piri taana naa, “Un murmur iaau.” ");
INSERT INTO rai_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Io, Lewi i tur ma i waan paa ko ra nuna kum utnaa raap, ma i murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Namur Lewi i paam a ngaala na winangaan un Iesu u ra nuna ruma. Mongoro na tena lolo tatakom ma raa taara kaai diat ki ungaai ma Iesu u ra winangaan mi. ");
INSERT INTO rai_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Raa kum Parisaaio ungaai ma nundiat kum tena wawer u ra kum Naagagon, diat puku anuna kum naat na wawer ma diat piri taan diat naa, “Aawa kabina baa muaat wangaan ma muaat inim ungaai ma ra kum tena lolo tatakom ma ra kum tena aakaina?” ");
INSERT INTO rai_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu i piri taan diat naa, “A doktaa pa i waan paat kup diat baa diat lalaaun wakaak. Pate! I waan paat kup diat ku baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pa iaau waan paat kup a kum tena takado. Pate! Iaau waan paat kupi ang wataa paa a kum tena aakaina kupi diat a nukpuku.” ");
INSERT INTO rai_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Raa taara diat piri taan Iesu naa, “A kum naat na wawer anun Ioaanes diat laana wawel ma diat aaraaring, ma ra kum naat na wawer kaai anu ra kum Parisaaio. Iaku anum kum naat na wawer diat wangwangaan ma diat ininim ku.” ");
INSERT INTO rai_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu i baalu diat naa, “A kum teptepaa ra matakina tinaulaa diat a wawel lelawaai baa a matakina tinaulaa i ki ungaai utbaai ma diat? ");
INSERT INTO rai_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ta bung in waan paat, baa din ben ingen wa a matakina tinaulaa kon diat, io, u ra kum bungbung maa diat a wawel maraagaam.” ");
INSERT INTO rai_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu i pir kaai raa pirpir welwelaar taan diat lenbi, “Pa te in rabaana paa ta pakaana maalu ko ra in matakina maalu, kupi in ingit ungaai taai ma ra in turaaina maalu. Baa te i paami lenmaa, in rabaana aaka wa a matakina maalu, ma a pakaana matakina pa diaar a babo welaar ma ra pakaana turaaina. ");
INSERT INTO rai_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma pa te in labo taa a matakina waain u ra in turaaina palaa na waain baa di paami ko ra pani ra wewagua, kaduk a matakina waain in rabaana wa in turaaina palaa, ma a waain in talabo, ma in palaa na waain kaai in aaka. ");
INSERT INTO rai_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Din labo ut a matakina waain u ra in matakina palaa na waain. ");
INSERT INTO rai_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pa ta muaana baa ia inim paa a turaaina waain, in nem balet a matakina waain, in piri ku naa, ‘A turaaina ut i koina.’” ");
INSERT INTO rai_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Un raa Bung Saabaat, baa Iesu i waan bolo u ra kum wanua na wit, anuna kum naat na wawer diat gamut kutu paa a kum wit, diat rumi ma ra limaandiat ma diat aani. ");
INSERT INTO rai_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Raa kum Parisaaio diat tiri Iesu naa, “Aawa kabina baa muaat paam a utnaa mi ma pa muaat murmur a Naagagon ko ra Bung Saabaat?” ");
INSERT INTO rai_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma Iesu i piri taan diat, “Lelawaai, pa muaat luk utbaai a utnaa baa Dewid i paami baa diat ma ra taara baa diat weur mai diat molo? ");
INSERT INTO rai_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I ruk u ra ruma anun God, i lo paa a bred baa di aa tabaara taa God mai, i aani, ma i tabaara diat kaai baa diat weur mai. A bred maa di wataabui ko ra taara biaa ku. A kum tena wetabaar ku karom God i tale diat a wangaan koni.” ");
INSERT INTO rai_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma Iesu i piri taan diat, “Natu ra Muaana ia a Tadaaru i ra Bung Saabaat.” ");
INSERT INTO rai_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Un raa Bung Saabaat bulung, Iesu i ruk u ra ruma na lotu, ma i wer a taara. Ma raa muaana kuraa matira, a ot na limaana i baau. ");
INSERT INTO rai_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A kum Parisaaio ma ra kum tena wawer u ra kum Naagagon diat baat kup ta utnaa baa diat a takuna Iesu mai, io, diat babo ururai baa lelawaai in walaangalaanga a malaapaang u ra Bung Saabaat, baa pate. ");
INSERT INTO rai_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Iesu i nunura a nuknukindiat ma i piri taa ra muaana baa limaana i baau naa, “Tur! Un tur unamuga taan diat raap.” I tur, ma i tur taau namuga taan diat. ");
INSERT INTO rai_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Io, Iesu i piri taan diat naa, “Ang tiri muaat: Aawa maa a kum Naagagon i piri naa din paami u ra Bung Saabaat? Din paam a koina baa din paam aakaina, din walaaun te baa din baanaakaka te?” ");
INSERT INTO rai_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma i babo taltalili paa karom diat raap, ma i piri taa ra muaana naa, “Un kado a limaam.” Ma i kadoi, ma a limaana i tubu balet. ");
INSERT INTO rai_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ma a balaandiat i teng ma ra kaankaan, ma diat pirpir ungaai kup ta mangaana utnaa diat a paami un Iesu. ");
INSERT INTO rai_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Raa bung, Iesu i waan unaanga u ra taangaai lik kupi in aaraaring. A bung na marum raap maa, i aaraaring karom God. ");
INSERT INTO rai_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Baa i keke, i wataa paa anuna taara na wawer karomi, ma i pilak paa ku 12 kon diat, ma i waatung ta diat baa a kum aapostolo. ");
INSERT INTO rai_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bari diat: Simon ia baa Iesu i taar taa kaai raa iaana baa Petero, dina ma Aanderiaas, Iaakobo, Ioaanes, Pilipo, Baatolomaaio, ");
INSERT INTO rai_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maataio, Tomaas, Iaakobo a natun Aalipaaio, Simon raa ko ra kikil Silot, ");
INSERT INTO rai_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iudaas a natun Iaakobo, ma Iudaas Iskaariot ia baa i wagu taa Iesu. ");
INSERT INTO rai_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Baa Iesu ma ra nuna taara na wawer diat waan pari taanginaanga u ra tangaai lik, i tur u ra welaar na wanua, ungaai ma ra nuna kor na taara na wawer. Ma mongoro na taara taangirong u ra papaar Iudaia ma taanginaanga Ierusalem ma ko ra kum taamtaamaan nakono marawaai Tiro ma Sidon kaai, ");
INSERT INTO rai_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","diat waan paat kupi diat a walangoroi, ma kupi in walaangalaanga pa diat ko ra nundiat kum malaapaang. Ma i lu irok wa a kum tabaraan kon diat raap baa a kum tabaraan diat baanaakaka diat. ");
INSERT INTO rai_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma a taara raap, diat nemi kupi diat a paam a panin Iesu, kabina maa a dekdek i waan pari koni, ma i walaangalaanga pa diat raap. ");
INSERT INTO rai_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu i babo anuna taara na wawer ma i piri naa, “Muaat baa muaat iba, muaat daan, maa anumuaat a mataanitu anun God! ");
INSERT INTO rai_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Muaat baa muaat molo mi, muaat daan, maa namur muaat a maaur. Muaat baa muaat luan mi, muaat daan, maa namur muaat a nangon. ");
INSERT INTO rai_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Muaat daan baa a taara diat nget muaat, ma baa diat milikuaana muaat ma diat pir aakaka muaat, ma baa diat uli aakaka a iaamuaat, kabina u ra Natu ra Muaana. ");
INSERT INTO rai_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“U ra bung baa din paam a kum utnaa mi karom muaat, muaat a gaaia, muaat a irirok ma ra gaaia, maa i ngaala aakit anumuaat wedok inaanga u ra maawa. Maa a kum utnaa mi, anundiat wuna taara taanga namuga diat aa paam taai karom a kum propet. ");
INSERT INTO rai_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Iaku in aaka karom muaat baa muaat tadaaru, maa muaat aa kale paa anumuaat koina. ");
INSERT INTO rai_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","In aaka karom muaat baa muaat maaur mi, maa namur muaat a molo. In aaka karom muaat baa muaat nangnangon mi, maa namur muaat a tapunuk ma muaat a taangi. ");
INSERT INTO rai_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","In aaka karom muaat baa a taara raap diat pir walaawa pa muaat, maa a utnaa mi anundiat wuna taara taanga namuga diat paami karom a kum propet warwaruga. ");
INSERT INTO rai_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Iaau piri taa muaat baa muaat walangoro iaau, muaat a maari anumuaat kum ebaar, ma muaat a paam a koina karom diat baa diat milikuaana muaat. ");
INSERT INTO rai_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Muaat a pir wadaan diat baa diat weninaan muaat, ma muaat a aaraaring un diat baa diat baanaakaka muaat. ");
INSERT INTO rai_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Baa te i paar taa a papaara waam, un taar taa kaai raa papaar taana. Baa te i raa paa anum maalu baa u laana burung baat anum minong mai, un maadek taa kaai anum siot taana. ");
INSERT INTO rai_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Un tabaara diat raap baa diat aaring ui. Ma baa te i lo paa ta utnaa kon ui, koku u aaring balet kupi. ");
INSERT INTO rai_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta mangaana utnaa baa muaat nemi naa a taara diat a paami karom muaat, muaat kaai muaat a laana paami karom diat. ");
INSERT INTO rai_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Baa muaat maari diat ku baa diat maari muaat, din pir walaawa pa muaat lelawaai? Maa a kum tena aakaina kaai diat maari wetwetalaai diat ut. ");
INSERT INTO rai_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Baa muaat paam a koina karom diat baa diat paam a koina karom muaat, din pir walaawa pa muaat lelawaai? Maa a kum tena aakaina kaai diat paampaami lenmaa. ");
INSERT INTO rai_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Baa a taara diat aaring muaat kup ta utnaa, ma muaat taari ku karom diat baa muaat nunurai naa diat a baalui ut karom muaat, din pir walaawa pa muaat lelawaai? Maa a kum tena aakaina kaai diat taartaar taa a utnaa taa ra kum tena aakaina, ma diat nemi naa diat a baalui. ");
INSERT INTO rai_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iaku muaat a maari anumuaat kum ebaar, ma muaat a paam a koina karom diat. Ma baa a taara diat nemi naa diat a lo kumun ta utnaa kon muaat, io, muaat a taari ku taan diat, ma koku muaat nemi naa diat a baalui. Baa muaat a paami lenmaa, anumuaat wedok in ngaala aakit, ma muaat a kum natun God a Ngaala Aakit, maa i maari diat baa pa diat laana waatung wakaak karomi, ma diat kaai baa a kum tena aakaina. ");
INSERT INTO rai_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muaat a laa u ra maarmaari, welaar ma Tamaamuaat a tena maarmaari. ");
INSERT INTO rai_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Koku muaat naagagon te, kupi koku kaai din naagagon muaat. Koku muaat takuna te, kupi koku din takuna muaat. Muaat a dumaana wa a kum aakaina mangamangaan a taara diat paami karom muaat, kupi din dumaana wa kaai anumuaat kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muaat a wetabaar, ma God in tabaara muaat. Iaku maa a wetabaar anun God karom muaat in teng, ma din tataanga pari, ma in teng balet, ma in taltalanger. Maa woi na mangaana wetabaar baa muaat taari, a ngaala baa a kinalik, ia ut maa din welaara a utnaa mai, baa din taari taa muaat.” ");
INSERT INTO rai_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu i pir kaai a pirpir welwelaar karom diat lenbi, “A pula in ben lelawaai kaai te baa i pula? Lelawaai, diaar raap pain diaar a puka darong un ta tung? ");
INSERT INTO rai_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A naat na wawer pa i ngaala taa ra nuna tena wawer. Iaku ia baa ia waraap paa anuna wawer, in welaar ma ra nuna tena wawer. ");
INSERT INTO rai_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“I lawaai maa u babo paa ku a kurkur kuraa u ra in mataan temlik, ma pa u nuk paa a pakaan diwaai pi kuraa u ra in mataam ut? ");
INSERT INTO rai_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Baa pa u babo paa a pakaan diwaai pi kuraa u ra in mataam, un piri lelawaai karom temlik naa, ‘Tenglik, ang rakaan wa a kurkur ko ra in mataam’? Ui a tena warwaruga, un lo muga wa a pakaan diwaai pi ko ra in mataam, io, un babo wakaak kupi un rakaan wa a kurkur ko ra in mataan temlik. ");
INSERT INTO rai_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“En koina diwaai pa in wa ta aakaina waina, ma in aakaina diwaai kaai pa in wa ta koina waina. ");
INSERT INTO rai_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Din nunura lele a kum diwaai ko ra waindiat. Pa un git paa ina waina fig ko ra in kadaa, ma ina waina waain ko ra in barudu. ");
INSERT INTO rai_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A koina muaana i waiaa anuna koina mangamangaan ko ra koina baa i ki u ra nuna lalaaun, ma ra aakaina muaana kaai i waiaa anuna aakaina mangamangaan ko ra aakaina baa i ki u ra nuna lalaaun. Maa a waa ra taara i pir apuaana a mangamangaan baa i teng u ra nundiat lalaaun. ");
INSERT INTO rai_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“I lawaai maa muaat waatung iaau ma ‘Tadaaru, Tadaaru,’ ma pa muaat paam a kum utnaa baa iaau piri taa muaat? ");
INSERT INTO rai_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ia baa i waan karom iaau ma i walangoro anung kum pirpir, ma i taraam uni, i welaar ma ra muaana baa ang wapua muaat uni. ");
INSERT INTO rai_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I welaar ma ra muaana baa i paam a ruma nate u ra waat. I kil adongdong paa a kum tung, ma i pagaa taa a kum toro i ra ruma nate uni. Baa a lomon i waan paat, ma i aalir taau u ra ruma, pa i laaur laar paai, maa kabina di aa paam wakaak taai. ");
INSERT INTO rai_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iaku te baa i walangoro anung kum pirpir ma pa i taraam uni, i welaar ma ra muaana baa i watur ku anuna ruma nate u ra pia ma pa i paam amuga taa a kabi ra ruma. Baa a lomon i aalir taau uni, i puka, ma i tareng aakaka maut!” ");
INSERT INTO rai_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Baa Iesu ia pir araap taa a kum pirpir mi karom a taara, i waan urong Kaapernaaum. ");
INSERT INTO rai_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Raa mukmuga anu ra kum tena wineium taangirong Rom i ki matira. Raa ko ra nuna kum tultul i malaapaang, marawaai in maat. A tultul mi, anuna mukmuga i nemnem aakiti. ");
INSERT INTO rai_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Baa a mukmuga anu ra kum tena wineium mi i walangoro a pirpir un Iesu, i tula wa raa kum mukmuga anu ra taara Iudaia baa diat a aaringi kupi in waan karomi, ma in walaangalaanga paa anuna tultul. ");
INSERT INTO rai_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Baa diat waan paat karom Iesu, diat aaring adekdeki lenbi, “Iesu, a muaana maa a koina muaana, i koina baa un taraam karomi, ");
INSERT INTO rai_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","maa i maari anundaat wuna taara, ma i kul taa anumiaat ruma na lotu mi.” ");
INSERT INTO rai_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Io, Iesu i murmur diat. Baa diat aa marawaai u ra ruma, a mukmuga anu ra kum tena wineium i tula wa raa kum teptepaana karom Iesu ma ra pirpir lenbi, “Tadaaru, koku iaau watakida ui, maa pa iaau takado kupi un ruk u ra nung ruma. ");
INSERT INTO rai_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pa iaau nuki kaai naa iaau takado kupi ang waan karom ui. Un pir ku ta pirpir, ma anung tultul in laangalaanga. ");
INSERT INTO rai_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Maa iaau a muaana baa iaau tartaraam u ra naagagon anundiat baa diat ngaala taang, ma di taar taa a naagagon kaai taang kup a taara na wineium. Baa iaau piri taan te naa, ‘Un waan,’ in waan ku. Ma karom te kaai lenbi, ‘Un waan urin,’ in waan ku urin. Ma karom anung tultul naa, ‘Un paam a utnaa bari ia,’ in paami ku.” ");
INSERT INTO rai_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Baa Iesu i walangoro taa a pirpir mi, i kakaian aakit uni, ma i tur tapuku karom a taara baa diat murmuri, ma i piri naa, “Iaau piri taa muaat naa, pa iaau babo taa ta te Israael baa anuna nurnur i ngaala welaar ma ra muaana mi.” ");
INSERT INTO rai_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma diat baa di tula wa diat, diat waan talili balet kup a ruma, diat baboi naa a tultul maa ia laangalaanga. ");
INSERT INTO rai_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pa i iwan ku, ma Iesu i waan u ra taamaan di waatungi ma Naain, ma anuna kum naat na wawer ma ra ngaala na kor na taara kaai diat waan ungaai mai. ");
INSERT INTO rai_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Baa ia waan paat marawaai u ra rukruk i ra taamaan, i babo a taara diat lo pari raa minaat. A minaat mi, a baarmaan, ia raa ot ku a natun raa walaa na tabuan. Mongoro na taara taangirong u ra taamaan diat weur ungaai mai. ");
INSERT INTO rai_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Baa a Tadaaru i babo a tabuan maa, i maari ma i piri taana naa, “Koku ma u taangi.” ");
INSERT INTO rai_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","I waan marawaai, ma i paam a luwu baa di lo a minaat mai, ma a taara baa diat lo a minaat diat tur akot. Iesu i piri naa, “A baarmaan, iaau piri taam naa un kaamtur.” ");
INSERT INTO rai_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Io a minaat i ki ma i pirpir. Ma Iesu i taar taai balet karom naana. ");
INSERT INTO rai_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A taara raap maa diat kakaian, ma diat pir walaawa paa God ma diat piri naa, “A ngaala na propet ia waan paat karom daat. God ia waan paat kupi in waraaut daat, anuna taara.” ");
INSERT INTO rai_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma a pirpir mi un Iesu i waan werweraan irong u ra papaar Iudaia raap, ma ra kum taamtaamaan marawaai kaai. ");
INSERT INTO rai_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A kum naat na wawer anun Ioaanes a Tena Baapitaaiso diat wapuai u ra kum utnaa raap mi un Iesu. Ioaanes i wataa paa rudi kon diat, ");
INSERT INTO rai_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma i tula wa diaar karom a Tadaaru kupi diaar a tiri naa, “Ui ma maa di pirpir muga un ui naa un waan paat, baa miaat a ki walaang utbaai kup te?” ");
INSERT INTO rai_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baa diaar waan paat karom Iesu, diaar piri naa, “Ioaanes, a Tena Baapitaaiso i tula wa mir karom ui, kupi mir a tiri ui naa, ‘Ui ma maa di pirpir muga un ui naa un waan paat, baa miaat a ki walaang utbaai kup te?’” ");
INSERT INTO rai_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","U ra pakaana bung ut maa, i walaangalaanga paa mongoro ko ra nundiat kum ngunungut ma ra kum malaapaang, ma i lu irok wa a kum tabaraan kon diat, ma i wababo paa mongoro na pula. ");
INSERT INTO rai_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ma i baalu diaar naa, “Mur a waan talili, ma mur a wapua Ioaanes u ra kum utnaa mi mur baboi, ma mur aa walangoro taai: A kum pula diat aa babo, diat baa a kakindiat i maat diat aa waan kado, a kum wukawuka diat aa laangalaanga, a kum lengbaa diat aa walangor, a kum minaat diat aa lalaaun, ma di warawaai u ra Koina Wewapua karom a kum iba na taara. ");
INSERT INTO rai_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baa te i babo a kum utnaa mi iaau paami ma anuna nurnur pa i puka, ia daan.” ");
INSERT INTO rai_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Baa a ru naat na wawer anun Ioaanes diaar aa waan, Iesu i piri karom a kor na taara un Ioaanes naa, “U raa bung baa muaat waan u ra bil na wanua karom Ioaanes, aawa maa muaat babo kupi? Ina kura duk baa i taltalaaur u ra dadaip? Pate. ");
INSERT INTO rai_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aawa maa muaat waan kupi muaat a baboi? A muaana baa i mong ma ra in koina maalu? Pate. Baboi, diat baa diat mong ma ra ngaatngaat na maalu, ma diat daan ma ra kum kokoina utnaa, diat ki u ra kum ruma na king. ");
INSERT INTO rai_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aawa maa muaat waan kupi muaat a baboi? A propet? Maia, iaau piri taa muaat, Ioaanes i ngaala aakit ut taa ra kum propet. ");
INSERT INTO rai_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Di aa timtimu taau uni u ra Buk Taabu lenbi, ‘Baboi, ang tula wa anung tena lo pirpir kupi in muga taam. In muga taam ma in paam aara anum aakapi.’ Maal 3:1 ");
INSERT INTO rai_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iaau piri taa muaat, Ioaanes i ngaala aakit taan diat raap baa di buta diat, iaku ia baa i kinalik aakit u ra mataanitu anun God, i ngaala taana.” ");
INSERT INTO rai_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A taara raap baa diat walangoroi, ma ra kum tena lolo tatakom kaai, diat taraam u ra takado na aakapi anun God, baa diat lo a baapitaaiso anun Ioaanes. ");
INSERT INTO rai_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Iaku maa a kum Parisaaio ma ra kum tena wawer u ra kum Naagagon pa diat nem a aakapi baa God i taari kup diat, maa pa diat mulaaot u ra baapitaaiso anun Ioaanes. ");
INSERT INTO rai_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma Iesu i piri balet naa, “Aawa duk maa ang welaara a taaun taara mai mi? Diat welaar ma ra aawa? ");
INSERT INTO rai_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Diat welaar ma ra kum naat liklik baa diat ki u ra balaa ra taamaan ma diat wewataai karom raa taara kon diat lenbi, ‘Baa miaat paar kudu, pa muaat laagaar uni, ma baa miaat kele a kelekele na tapunuk, pa muaat taangi uni.’ ");
INSERT INTO rai_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ioaanes a Tena Baapitaaiso i waan paat, pa i aan ta koina utnaa ma pa i inim a waain, ma muaat piri uni naa, ‘A tabaraan i ruk taau uni.’ ");
INSERT INTO rai_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Natu ra Muaana i waan paat, i wangaan ma i inim, ma muaat piri uni naa, ‘Baboi, a muaana mi a tena winangaan ma ra tena ininim, a tepaa ra kum tena lolo tatakom, ma ra kum tena aakaina.’ ");
INSERT INTO rai_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iaku a taara raap baa diat murmur a manaana anun God diat wapuaanai naa anuna manaana ia a manaana lingtatuna.” ");
INSERT INTO rai_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Raa Parisaaio i ben paa Iesu kupi diaar a wangaan ungaai. Iesu i ruk u ra ruma anu ra Parisaaio maa, ma i ki u ra winangaan. ");
INSERT INTO rai_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma raa tabuan taanga u ra taamaan maa, a tena aakaina, baa i nunura paai naa Iesu kuraa i wangaan u ra ruma anu ra Parisaaio, i ruk ma ra polo na mangingi baa i taana u ra in palaa baa di paami ko ra waat. ");
INSERT INTO rai_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma i tur taau namur taan Iesu, naa ra ru kakina. I taangtaangi, ma a lur na mataana i pukpuka taau u ra ru kakin Iesu, ma i upa diaar ma ra weu na lorina, i dum diaar, ma i labo a polo na mangingi un diaar. ");
INSERT INTO rai_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Baa a Parisaaio maa i babo a utnaa mi, i nuki naa, “Baa a muaana mi a propet lingtatuna, in nunura a tabuan mi baa i paam a ru kakina, ma in nunura kaai a magiraana, maa ia a aakaina tabuan.” ");
INSERT INTO rai_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu i piri taana naa, “Simon iaau nemi naa ang pir taa raa utnaa taam.” Ma i baalui naa, “Tena Wawer, un piri ku.” ");
INSERT INTO rai_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu i piri taana naa, “Raa ru muaana diaar dinaau maani paa kon raa muaana, raa kon diaar i dinaau paa 500 na kina ma raa paan diaar kaai 50 kina. ");
INSERT INTO rai_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A ru muaana maa pa diaar pet laar paai kupi diaar a baalu a dinaau, maa pa nundiaar ta maani. Io, a muaana maa i piri taan diaar naa, ‘Koku maku mur baalu anumur dinaau.’ Woi kon diaar anuna maarmaari karom a muaana baa i taar taa maani taan diaar in ngaala aakit?” ");
INSERT INTO rai_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon i baalui naa, “Kanaapi ia baa i dinaau paa a ngaala na maani aakit koni.” Iesu i piri taan Simon naa, “I takado aakit anum binabaalu.” ");
INSERT INTO rai_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iesu i kakawet unamur karom a tabuan, ma i piri taan Simon naa, “Babo a tabuan mi. Baa iaau ruk u ra num ruma pa u taar ta palaa kupi din gi a ru kaking mai. Iaku, a tabuan mi, i gi a ru kaking ma ra lur na mataana, ma i upa diaar ma ra weu na lorina. ");
INSERT INTO rai_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pa u wakilang anum gaaia ma ra wedum karom iaau, iaku maa a tabuan mi i dumdum a ru kaking turpaai utbaai baa iaau waan paat min. ");
INSERT INTO rai_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pa u aalu in loring ma ta wel, iaku maa a tabuan mi i labo taa a polo na mangingi u ra ru kaking. ");
INSERT INTO rai_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iaau piri taam naa anuna ngaala na maarmaari karom iaau i waiaai naa di aa una wa anuna mongoro na aakaina mangamangaan. Te baa di una wa ku anuna kinalik na aakaina mangamangaan, anuna maarmaari kaai in kinalik.” ");
INSERT INTO rai_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma Iesu i piri taa ra tabuan maa naa, “Di aa una wa anum kum aakaina mangamangaan.” ");
INSERT INTO rai_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A taara baa diat ki u ra winangaan, diat pirpir ungaai, diat piri naa, “Woi na mangaana muaana mi i pet laar paai kupi in una wa a kum aakaina mangamangaan?” ");
INSERT INTO rai_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu i piri taa ra tabuan maa naa, “U ra num nurnur ut, di aa walaaun pa ui. Un waan ma ra maalmaal.” ");
INSERT INTO rai_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Namur Iesu i waan taltalili u ra kum ngaala na taamaan ma ra kum kinkinalik na taamaan kaai, i warawaai ma ra Koina Wewapua u ra mataanitu anun God karom diat. Diat weur ma ra nuna 12 naat na wawer, ");
INSERT INTO rai_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma a kum tabuan kaai, baa ia lu irok wa a kum tabaraan kon diat, ma ia walaangalaanga pa diat ko ra kum malaapaang. Bi diat a kum tabuan maa: Maaria, a iaana kaai Maagdalene, ia baa 7 na tabaraan diat pari paa koni, ");
INSERT INTO rai_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma Ioaana a tabuan anun Kusaa, a mukmuga anu ra kum tultul anun Erodes, ma Susaana, ma mongoro kaai. A kum tabuan mi diat waraaut Iesu ma nuna kum naat na wawer ko ra nundiat wuwuwung ut. ");
INSERT INTO rai_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Baa a ngaala na kor na taara ko ra kum taamtaamaan diat waan paat ungaai karom Iesu, i pir raa pirpir welwelaar karom diat lenbi, ");
INSERT INTO rai_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Raa tena minamaarut i waan kupi in lamira a kum waina wit. Baa i lalamira waanwaan, raa kum waina diat puka taau u ra aakapi, ma a taara diat papaa nate un diat, ma ra kum pika diat aan wa diat. ");
INSERT INTO rai_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Raa kum waina kaai diat puka taau u ra pia na waatwaat, ma baa diat ilak paat, diat malulur balet ku, maa a pia i magege aakit. ");
INSERT INTO rai_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Raa kum waina kaai diat puka taau naliwan u ra kum katkadaa, ma a kum kadaa diat tawa ungaai ma diat, ma diat tawa baat pa diat. ");
INSERT INTO rai_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Raa kum waina kaai diat puka taau u ra koina pia, diat tawa ma diat wa. Raaraain diwaai i wa raa maar na waina.” Baa ia pir taa a kum pirpir mi taan diat, i piri naa, “Ia baa in talingaana, i koina baa in walangor mai.” ");
INSERT INTO rai_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anuna kum naat na wawer diat tiri kup a kukuraai ra pirpir welwelaar baa ia pir taai. ");
INSERT INTO rai_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ma i piri taan diat lenbi, “God ia taar taa a manaana taa muaat kupi muaat a nunura a kum utnaa na pidik u ra nuna mataanitu. Iaku karom a taara ingen iaau wer diat ma ra kum pirpir welwelaar, kupi ‘diat a bababo ma pa diat a babo lelei, diat a walwalangor ma pa diat a walangoro lelei, ma pa diat a manaana uni.’ Aais 6:9 ");
INSERT INTO rai_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“A kukuraai ra pirpir welwelaar mi i lenbi, a waina wit i welaar ma ra pirpir anun God. ");
INSERT INTO rai_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A kum waina wit baa diat puka taau u ra aakapi, diat welaar ma ra taara baa diat walangoro taa a pirpir, ma Saataan i waan paat, ma i lo wa a pirpir ko ra balaandiat, kupi koku diat nurnur, ma koku di walaaun diat. ");
INSERT INTO rai_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma a kum waina u ra pia na waatwaat, diat welaar ma ra taara baa diat walangoro a pirpir, ma diat paam akotoi ma ra gaaia. Iaku maa, pa ta aakaarindiat, anundiat nurnur pa i tur iwan, ma baa a kum walwalaam i waan paat karom diat, diat puka maut. ");
INSERT INTO rai_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma a kum waina baa diat puka taau naliwan u ra kum katkadaa, diat welaar ma ra taara baa diat walangoro a pirpir, iaku u ra nundiat lalaaun a kum nginaraa, a kum wuwuwung, ma ra gaaia ko ra lalaaun min napia, diat burung baat paa a pirpir, ma pa diat wa ta waindiat. ");
INSERT INTO rai_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma a kum waina baa diat puka taau u ra koina pia, diat welaar ma ra taara baa diat walangoro a pirpir, ma i ki u ra balaandiat, diat taraam uni, ma diat paam akoto dekdeki, tuk diat wa a waindiat. ");
INSERT INTO rai_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Pain te in wakup taa ta laam ma in kuop baat taai ma ra baaket, ma pa in ung taai kaai natudaangi ra waawaa. Pate! In ung taai ut nate u ra nuna turtur, kupi diat baa diat ruk diat a babo a kaapakaapaina. ");
INSERT INTO rai_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ma a kum utnaa raap baa i taana ino, in waan paat kaapakaapa. Ma a kum utnaa raap baa i wawalipa, namur din nunurai ma in waan paat baarabaara. ");
INSERT INTO rai_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Io, muaat a nuknuk wakaak u ra pirpir baa muaat walangoroi. Baa te i paam akoto a manaana u ra pirpir anun God, din tabaarai balet ma ra ngaala. Ma baa te pa i paam akoto ta manaana, din rakaan wa utkaai a kinalik na manaana baa i nuki naa i paam akotoi.” ");
INSERT INTO rai_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naan Iesu ma ra kum tatena liklik diat waan paat kupi diat a baboi, iaku maa pa diat pet laar paai, maa a kor na taara diat liur baat paai. ");
INSERT INTO rai_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma di wapua Iesu naa, “Naam ma ra kum tatem liklik bari diat nataamaan. Diat nem na babo ui.” ");
INSERT INTO rai_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma i piri taan diat naa, “Diat baa diat walangoro a pirpir anun God ma diat taraam uni, diat maa naang ma ra kum tateng liklik.” ");
INSERT INTO rai_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Raa bung Iesu ma ra nuna kum naat na wawer, diat kaa u ra mon, ma i piri taan diat naa, “Daat a waan bolo urong un raa papaara taai kikil.” Ma diat waan. ");
INSERT INTO rai_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Baa diat welulu waanwaan ma ra sel, Iesu i inep duman. A dekdek na dadaip i tapalaa taau un diat u ra taai kikil, ma a mon i wawangaan, ma marawaai diat a wirua. ");
INSERT INTO rai_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A kum naat na wawer diat waan karomi, diat waanguni, ma diat piri taana naa, “Tena Wawer, Tena Wawer, daat wirua ma!” Io, i kaamtur, i turbaat a dadaip ma ra dekdek na top, ma diaar ngo, ma i malila maut. ");
INSERT INTO rai_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma i piri taa ra kum naat na wawer naa, “Kuraa awaai anumuaat nurnur?” Diat burut, ma diat kakaian, diat tiri wetwetalaai diat naa, “Woi na mangaana muaana ma mi, baa i naagagon a dadaip ma ra top ma diaar taraam karomi?” ");
INSERT INTO rai_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu ma ra kum naat na wawer diat pukaai u ra papaar anu ra taara Geraasaa, baa i ki irong un raa papaara taai kikil ko ra papaar Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Baa Iesu i kaa pari ko ra mon, raa muaana taanga u ra taamaan maa, baa a kum tabaraan diat ruk taau uni, i waan baraatai. Ia welwelik uni, baa pa i gop ta maalu, ma pa i ki kaai un ta ruma, i kiki ku u ra kum babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Baa i babo paa Iesu, i kulkulaai, ma i puka pari taau naa ra ru kakina, ma i kulkulaai ma ina ngaala na ingaana lenbi, “Aawa maa un paami un iaau Iesu, Natun God a Ngaala Aakit? Iaau aaring ui baa koku u wakadik iaau.” ");
INSERT INTO rai_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I piri lenmi, kabina maa Iesu ia pirpir dekdek paa karom a tabaraan kupi in pari ko ra muaana mi. Mongoro na pakaan a tabaraan i umi. A taara diat laana bababoura baat a muaana mi, diat laana wi taa a ru limaana ma ra ru kakina ma ra kum sen, iaku i laana aal kutu wa diat ku, ma a tabaraan i laana wowo paai unaanga u ra kum bil na wanua. ");
INSERT INTO rai_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu i tiri naa, “Woi na iaam?” Ma i baalui naa, “A iaang a Liur na tabaraan,” maa a mongoro na tabaraan diat ruk taau uni. ");
INSERT INTO rai_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma diat aaring Iesu kupi koku i tula ruk ta diat u ra ngaala na tung baa pa di babo a tuktukina. ");
INSERT INTO rai_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A ngaala na liur na boro diat wangwangaan matira u ra papaara taangaai, ma a kum tabaraan diat aaring Iesu kupi diat a ruk taau u ra kum boro. Ma i taraam wa diat. ");
INSERT INTO rai_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma a kum tabaraan diat pari ko ra muaana maa, ma diat ruk taau u ra kum boro. Ma a kum boro diat welulu pari u ra papaara taangaai kup a taai kikil, ma diat kongo raap. ");
INSERT INTO rai_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Diat baa diat baboura a kum boro, diat babo a utnaa mi, diat welulu talili. Diat wewapua u ra utnaa mi u ra nundiat taamaan, ma un raa kum taamtaamaan liklik kaai. ");
INSERT INTO rai_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma a taara diat waan kupi diat a babo a utnaa mi i waan paat. Baa diat waan paat karom Iesu, diat babo a muaana baa a kum tabaraan diat pari paa koni, i ki taau marawaai naa ra ru kakin Iesu, ia gop balet ma ia manaana. Ma a taara diat burut. ");
INSERT INTO rai_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Diat baa diat babo taa a utnaa baa Iesu i paami, diat wapua a taara naa Iesu ia lu irok wa a kum tabaraan ko ra muaana maa. ");
INSERT INTO rai_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma a taara raap taanga u ra papaar anu ra kum Geraasaa diat aaring Iesu kupi in waan ingen kon diat, maa diat burut aakit. Io, Iesu i kaa balet u ra mon ma i waan. ");
INSERT INTO rai_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma a muaana baa a kum tabaraan diat pari paa koni, i aaring Iesu kupi diaar a weur. Iaku Iesu i tula wai ku naa, ");
INSERT INTO rai_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Un waan talili kup anum ruma, un wewapua u ra ngaala na utnaa mi God ia paam taai un ui.” Io, i waan talili, i wewapua u ra taamaan maa u ra ngaala na utnaa baa Iesu ia paam taai uni. ");
INSERT INTO rai_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Baa Iesu i waan talili, a kor na taara diat gaaia baraata paai, kabina maa diat raap diat kiki walaang ut kupi. ");
INSERT INTO rai_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Raa muaana, a iaana Iaairo, a mukmuga ko ra ruma na lotu, i waan paat ma i puka ruru taau namuga naan Iesu. I aaringi kupi in waan uaa u ra nuna ruma, ");
INSERT INTO rai_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","maa raa natunalik ku, a tabuan, baa nuna kilaala i 12, i inep na minaat ma. Io, baa Iesu i waan, a ngaala na kor na taara diat liur baat paai. ");
INSERT INTO rai_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Raa tabuan matira i malaapaang ma ra malaapaang na gaap. Ia malaapaang paa 12 kilaala, iaku pa te i walaangalaanga laar paai. ");
INSERT INTO rai_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I waan namur taan Iesu, ma i paam taa ku a titi ra nuna ina maalu, ma a gaap i ngo maut. ");
INSERT INTO rai_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma Iesu i wetiri naa, “Woi maa i paam iaau?” Baa diat raap diat weoro, Petero i piri naa, “Tena Wawer, pa u babo a ngaala na kor na taara mi diat liur baat pa ui?” ");
INSERT INTO rai_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iesu i piri naa, “Raa paan diat ia paam ta iaau, iaau kariaanai naa a dekdek i waan kon iaau.” ");
INSERT INTO rai_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A tabuan i nunurai naa di aa baat paai, io, i dadader paat, ma i puka ruru taau namuga naan Iesu. Namataa ra kor na taara raap, i wapua Iesu u ra kabina baa i paam taai, ma i wapuai kaai baa i laangalaanga gagaa maut. ");
INSERT INTO rai_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Iesu i piri taana naa, “Natunglik, anum nurnur ia walaangalaanga pa ui. Un waan ma ra maalmaal.” ");
INSERT INTO rai_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Baa Iesu i pirpir utbaai, raa i waan paat taangirong u ra ruma anun Iaairo, a mukmuga ko ra ruma na lotu, ma i piri taana naa, “Koku ma u wabalaana a Tena Wawer. Natumlik ia maat.” ");
INSERT INTO rai_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Baa Iesu i walangoro a pirpir maa, i piri taan Iaairo naa, “Koku u burut, un nurnur ku, ma din walaaun paai balet.” ");
INSERT INTO rai_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Baa i waan paat u ra ruma, pa i mulaaot paa te kupi in ruk ungaai mai. I mulaaot paa ku Petero, Ioaanes ma Iaakobo, ma tamaa ra naatlik ma naana kaai. ");
INSERT INTO rai_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A taara raap diat kulkulaai ma ra niluan, ma Iesu i piri taan diat naa, “Koku muaat luan. A naatlik mi wakir i maat, i inep duman ku.” ");
INSERT INTO rai_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma diat nangonoi ku, maa diat nunurai naa ia maat. ");
INSERT INTO rai_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma Iesu i ruk unaruma, i paam paa a limaa ra naat na tabuan, ma i piri taana naa, “Tabuan lik, un tur.” ");
INSERT INTO rai_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma a niono i waan talili balet karomi, ma i tur maut. Ma Iesu i wetulaa kup ta utnaa a tabuan lik maa in aani. ");
INSERT INTO rai_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamaana ma naana diaar kakaian aakit, ma Iesu i turbaat diaar kupi koku diaar wapua te u ra utnaa mi i waan paat. ");
INSERT INTO rai_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Baa Iesu i wataa ungaai paa a 12 naat na wawer, i taar taa a dekdek ma ra naagagon taan diat kupi diat a lu irok wa a kum tabaraan raap, ma kupi diat a walaangalaanga paa kaai a taara ko ra kum malaapaang. ");
INSERT INTO rai_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma i tula wa diat kupi diat a warawaai u ra mataanitu anun God, ma diat a walaangalaanga paa a kum malaapaang. ");
INSERT INTO rai_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma i piri taan diat naa, “Koku muaat lo ta utnaa u ra numuaat winawaan, koku tina buka, koku ta bek, koku ta utnaa na winangaan, koku ta maani ma koku ta maalu na wekiaa. ");
INSERT INTO rai_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Baa muaat a ki un ta ruma, muaat a ki ut matira tuk u ra bung baa muaat a waan ko ra taamaan maa. ");
INSERT INTO rai_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Baa ta taara pa diat gaaia pa muaat, baa muaat waan ko ra nundiat taamaan, muaat a tataanga wa a kabu ko ra kakimuaat, kupi a wakilang na watumaarang karom diat.” ");
INSERT INTO rai_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A kum naat na wawer diat waan taltalili u ra kum taamtaamaan, diat warawaai ma ra Koina Wewapua, ma diat walaangalaanga a taara u ra kum taamtaamaan raap. ");
INSERT INTO rai_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Baa Erodes a mukmuga ko ra mataanitu i walangoro a kum utnaa mi i waan paat, i laklagon a nuknukina uni, kabina maa raa taara diat piri naa Ioaanes ia lalaaun balet ko ra minaat. ");
INSERT INTO rai_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ma raa taara kaai diat piri naa Eliaas ia waan paat. Raa taara kaai diat piri naa raa ko ra kum propet taanga namuga ia lalaaun balet. ");
INSERT INTO rai_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erodes i piri naa, “Iaau aa pakaat kutu wa in lorin Ioaanes, ma woi na muaana balet mi, iaau walangoro a kum utnaa mi uni?” Ma i nem aakiti kupi in babo Iesu. ");
INSERT INTO rai_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Baa a kum aapostolo diat waan talili balet, diat wapua Iesu u ra kum utnaa baa diat aa paam taai. I ben pa diat, ma diat waan ingen kup a taamaan a iaana Betsaaida. ");
INSERT INTO rai_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A kor na taara diat walangoroi, ma diat murmuri. I gaaia pa diat, ma i pirpir karom diat u ra mataanitu anun God, ma i walaangalaanga pa diat baa diat malaapaang. ");
INSERT INTO rai_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Baa ia maluraap, a 12 naat na wawer diat waan karom Iesu, ma diat piri taana naa, “A bil na wanua ku mi, un tula wa a kor na taara baa diat a waan kup a kum taamaan, ma u ra kum taamtaamaan liklik marawaai, kupi diat a wangaan ma diat inep iaai.” ");
INSERT INTO rai_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iesu i piri taan diat naa, “Muaat ut maa muaat a tabaara diat.” Ma diat baalui naa, “Limnain bred ku ma ra ruina ian kuri miaat loi. U nemi duk naa miaat a kul paa ta utnaa kupi in welaar ma ra kor na taara raap mi?” ");
INSERT INTO rai_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A kor na taara maa, a niluluk i ra in muaana ku i welaar ma 5,000. I piri taa ra nuna kum naat na wawer naa, “Muaat a tula diat kupi diat a ki u ra kum kikil limlima na noina diat.” ");
INSERT INTO rai_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ma a kum naat na wawer diat paami lenmaa, ma a taara diat ki raap napia. ");
INSERT INTO rai_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu i rakaan paa limnain bred ma ruina ian, i tataada unaanga u ra maawa, i waatung wakaak paa karom God uni, i biki ma i taar taai karom a kum naat na wawer, kupi diat a palau a taara mai. ");
INSERT INTO rai_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Diat raap diat wangaan ma diat maaur. Ma diat wangaana ateng paa 12 kaa ma ra utnaa baa diat aan kapo taai. ");
INSERT INTO rai_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Raa bung baa Iesu ku i ki ma i aaraaring, a kum naat na wawer diat waan karomi, ma i tiri diat naa, “A taara diat piri naa iaau woi?” ");
INSERT INTO rai_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma diat baalui naa, “Raa taara diat piri naa ui Ioaanes a Tena Baapitaaiso. Raa taara kaai diat piri naa ui Eliaas, ma raa taara kaai diat piri naa ui raa kon diat a kum propet taanga namuga, baa ia lalaaun balet.” ");
INSERT INTO rai_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma Iesu i tiri diat naa, “Io muaat, muaat piri naa iaau woi?” Ma Petero i baalui naa, “Ui Kaarisito baa God i tula wa ui urin.” ");
INSERT INTO rai_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ma i turbaat diat naa koku diat wapua te uni. ");
INSERT INTO rai_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iesu i piri naa, “A Natu ra Muaana in kariaana mongoro na mawaat, ma a kum mukmuga, a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon diat a weoro wai ma din aak dokoi. Ma baa tula bung in raap in lalaaun paat balet.” ");
INSERT INTO rai_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma i piri taan diat raap naa, “Baa te i nemi kupi in murmur iaau, koku i murmur a nuknukina. In puak paa anuna bolo u ra bungbung raap ma in murmur iaau. ");
INSERT INTO rai_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Baa te i maari baat paa ku anuna lalaaun in wirua, iaku ia baa pa i maari baat anuna lalaaun kup iaau, in lalaaun. ");
INSERT INTO rai_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","In koina lelawaai baa te i kale raap paa a rakrakaan buaal, iaku in baanaakaka wa anuna lalaaun uni ma in wirua takum? ");
INSERT INTO rai_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Baa te in wawirwir kon iaau ma u ra nung kum pirpir, Natu ra Muaana kaai in wawirwir koni, baa in waan paat ma ra nuna minamaar, ma ra minamaar kaai anun Tamaana ma anu ra nuna kum aangelo. ");
INSERT INTO rai_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iaau pir a lingtatuna taa muaat, ta taara kon muaat mi, muaat tur min, baa pa muaat a maat utbaai muaat a babo a mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Baa ia 8 na bung baat taa a pirpir mi, Iesu i ben paa Petero, Ioaanes ma Iaakobo, ma diat waan tato unaanga u ra taangaai kupi diat a aaraaring. ");
INSERT INTO rai_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Baa i aaraaring, a mataana i babo raaungaana, ma anuna kum maalu i kabaang ma i papakaat. ");
INSERT INTO rai_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma i pirpir ma ra ru muaana, Moses ma Eliaas. ");
INSERT INTO rai_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Diaar waan paat ma ra minamaar, ma ditul pirpir u ra minaat anun Iesu, baa in baraatai inaanga Ierusalem, kupi in paam ot paa a nemnem anun God. ");
INSERT INTO rai_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero ditul, ditul inep duman. Baa ditul tawaangun paat, ditul babo a minamaar anun Iesu, ma ra ru muaana kaai baa ditul tur ungaai mai. ");
INSERT INTO rai_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Baa a ru muaana diaar nem na waan ma kon Iesu, Petero i piri taana naa, “Tena Wawer, i koina baa daat a ki maku min. Mitul a paam ta tula palpalip, num raa, raa anun Moses, ma raa anun Eliaas”. Iaku Petero pa i nunura a utnaa baa i piri. ");
INSERT INTO rai_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Baa i pirpir utbaai, a pakaana baakut i waan paat ma i pulu baat pa diat, ma ditul burut baa i pulu baat pa ditul. ");
INSERT INTO rai_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma in ingaan raa taanga u ra baakut i piri naa, “Bi ia Natunglik, baa iaau aa pilak paai. Muaat a walangoroi.” ");
INSERT INTO rai_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baa ia pirpir raap paa, Iesu ot maku kuraa i tur. Ma pa ditul pirpir uni. Ma u ra kum bung maa, pa ditul wapua te u ra kum utnaa baa ditul aa babo taai. ");
INSERT INTO rai_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","U ra bung namur baa Iesu ma ra tula naat na wawer diat aa waan pari taanginaanga u ra taangaai, a ngaala na kor na taara diat waan karom Iesu. ");
INSERT INTO rai_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma raa muaana ko ra kum taara maa i wewataai lenbi, “Tena Wawer, iaau aaring ui baa un babo natunglik a naat muaana, raa kapuaana naat ku. ");
INSERT INTO rai_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A tabaraan i laana umi, ma a naat i kulkulaai kakaian. A tabaraan i laana wadader adekdeki, ma a waa ra naat maa i buabua. A tabaraan pa i waan koni, ma i wangungut aakaka a panina. ");
INSERT INTO rai_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iaau aaring paa mun anum kum naat na wawer kupi diat a lu irok wa a tabaraan koni, iaku pa diat pet laar paai.” ");
INSERT INTO rai_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu i piri naa, “Muaat a taaun taara mi, pa muaat nurnur ma muaat a kum tena aakaina. Iaau aa ki iwan karom muaat. Unaangaian ma muaat a nurnur? Un ben natumlik urin.” ");
INSERT INTO rai_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Baa a naat maa i waan karom Iesu, a tabaraan i ong kuraa taai napia ma i wadader adekdeki. Iesu i pirpir dekdek karom a tabaraan ma i lu irok wai, ma a naat i laangalaanga balet. I taar taai balet karom tamaana. ");
INSERT INTO rai_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma diat raap diat kakaian u ra ngaala na dekdekin God. Baa diat raap diat kakaian utbaai u ra kum utnaa Iesu ia paam taai, i piri taa ra nuna kum naat na wawer lenbi, ");
INSERT INTO rai_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Muaat a walangoro wakaak a pirpir mi: Din taar taa Natu ra Muaana u ra limaa ra taara.” ");
INSERT INTO rai_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iaku a kum naat na wawer pa diat kaapa u ra kukuraai ra pirpir mi. Di walipai ku kon diat, kupi koku diat nunura lelei. Ma diat burut kupi diat a tiri Iesu uni. ");
INSERT INTO rai_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A kum naat na wawer diat weol na pirpir naliwan taan diat baa woi kon diat i ngaala aakit. ");
INSERT INTO rai_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu ia nunura a nuknukindiat, i lo paa raa naatlik ma i watur paai naana. ");
INSERT INTO rai_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma i piri taan diat naa, “Baa te i gaaia paa a naatlik mi u ra iaang, i gaaia pa iaau utkaai. Ma baa te i gaaia pa iaau, i gaaia paa ia ut baa i tula wa iaau urin. Maa ia baa i kinalik taa muaat raap, ia ut maa i ngaala aakit.” ");
INSERT INTO rai_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioaanes i piri taan Iesu naa, “Tena Wawer, miaat babo raa muaana i lu irok wa a kum tabaraan u ra iaam, ma miaat turbaati, maa wakir ia kon daat.” ");
INSERT INTO rai_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu i baalui naa, “Koku muaat turbaati, maa ia baa pa i turbaat muaat, i waraaut muaat ku.” ");
INSERT INTO rai_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Baa ia marawaai a pakaana bung kupi din lo paa Iesu unaanga u ra maawa, i nuki naa in waan unaanga Ierusalem, ma i turpaa winawaan. ");
INSERT INTO rai_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I tula wa raa kum tultul, kupi diat a muga taana. Diat waan paat un raa taamaan u ra papaar Samaaria, kupi diat a waninaar kup Iesu. ");
INSERT INTO rai_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iaku a kum te Samaaria pa diat nemi naa in ruk u ra nundiat taamaan, maa kabina in waan ut unaanga Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Baa anuna ru naat na wawer, Iaakobo ma Ioaanes diaar babo a mangamangaan mi, diaar tiri naa, “Tadaaru, u nemi ku naa mir a aaring God baa in taar wa a nguan kupi in aan araap wa diat?” ");
INSERT INTO rai_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iesu i tur tapuku, ma i turbaat diaar. ");
INSERT INTO rai_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Io, Iesu ma ra nuna kum naat na wawer diat waan kup raa taamaan ingen. ");
INSERT INTO rai_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Baa Iesu ma ra nuna kum naat na wawer diat waan waanwaan u ra aakapi, raa muaana i piri taana naa, “Ang murmur ui u ra kum taamtaamaan raap baa un waan iaai.” ");
INSERT INTO rai_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu i piri taana naa, “A kum kuaabaar na paap anundiat kum tung ut, ma ra kum pika kaai anundiat kum pio ut, iaku Natu ra Muaana pa nuna ta ruma kupi in inep uni.” ");
INSERT INTO rai_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","I piri taan raa muaana bulung naa, “Un murmur iaau.” Iaku i baalui lenbi, “Tadaaru, un mulaaot wa iaau kumun baa ang waan, kupi ang punang wa tamaang.” ");
INSERT INTO rai_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu i piri taana, “Un maadek wa a kum minaat diat a punang andiat kum minaat. Un waan ma un warawaai u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Raa balet i piri taan Iesu naa, “Tadaaru, ang murmur ui, iaku un mulaaot wa iaau kumun kupi ang waan, ma miaat a webabo paa ma diat u ra nung ruma.” ");
INSERT INTO rai_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu i piri taana naa, “Baa te i turpaa pinapaam ma ra ipipuk, ma i kakawet unamur, pa i topaa a pinapaam u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Namur a Tadaaru i pilak paa bulung 72 taara kaai, ma i tula wa diat rurudi kupi diat a muga taana u ra kum ngaalangaala na taamaan, ma u ra kum taamtaamaan liklik, baa ia kaai in waan iaai. ");
INSERT INTO rai_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma i piri taan diat naa, “A pinapaam ia mugaan, ma ia ngaala aakit, iaku pa i mongoro a kum tena tinangaa. Muaat a aaring a Tadaaru maa ia a tamaa ra pinapaam, kupi in tula wa a kum tena tinangaa kup ana pinapaam. ");
INSERT INTO rai_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Muaat a waan! Mi iaau tula wa muaat welaar ma ra kum naat na sip naliwan naa ra kum karangaap na paap. ");
INSERT INTO rai_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Koku muaat lo ta paaus na ungung maani, koku ta kaa, ma koku ta su. Koku kaai muaat pirpir ma te baa muaat baraatai u ra aakapi. ");
INSERT INTO rai_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Baa muaat ruk un ta ruma, muaat a pir mugai naa, ‘A maalmaal karom muaat.’ ");
INSERT INTO rai_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Baa ta tena maalmaal i ki matira, anumuaat maalmaal in ki uni. Baa pate, a maalmaal in waan talili balet karom muaat. ");
INSERT INTO rai_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma muaat a ki ut matira u ra ruma maa, muaat a wangaan ma muaat a inim a utnaa baa di tabaara muaat mai, maa i takado baa din tabaara a tena pinapaam. Koku muaat inep un ta kum ruma ingen. ");
INSERT INTO rai_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Baa muaat waan paat un ta taamaan, ma di ben ruk muaat, muaat a aan a utnaa baa di tabaara muaat mai. ");
INSERT INTO rai_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Muaat a walaangalaanga a kum malaapaang matira, ma muaat a piri taa ra taara naa, ‘A mataanitu anun God ia marawaai karom muaat!’ ");
INSERT INTO rai_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Baa muaat waan paat un ta taamaan, ma pa di ben ruk muaat, muaat a tur ku u ra aakapi ma muaat a piri naa, ");
INSERT INTO rai_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A kabu ko ra numuaat taamaan baa kuri u ra kum kakimiaat, miaat upa wai balet kupi a watumaarang karom muaat. Iaku muaat a nunurai naa a mataanitu anun God ia marawaai.’ ");
INSERT INTO rai_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iaau piri taa muaat, u ra bung na naagagon, a naagagon karom Sodom in dekdek, iaku karom a taamaan maa in aaka aakit.” ");
INSERT INTO rai_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“In aaka karom muaat a taara Koraasin, in aaka kaai karom muaat a taara Betsaaida. Baa gun di aa paam taa a kum utnaa na kakaian bi karom a taara Tiro ma Sidon, welaar ma di aa paam taai karom muaat, kaduk a taara Tiro ma Sidon diat a nukpuku gagaa ma diat a tobo, diat a mong ma ra maalu na tapunuk ma diat a aalu a panpanindiat ma ra kabu na nguan. Iaku muaat, pa muaat nukpuku. ");
INSERT INTO rai_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A naagagon karom muaat a taara Koraasin ma Betsaaida in aaka aakit ko ra naagagon karom diat a taara Tiro ma Sidon. ");
INSERT INTO rai_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma muaat kaai a taara Kaapernaaum, lelawaai, muaat nuki naa din wangaala pa muaat unaanga nate? Pate, din ong apari wa muaat ku u ra ngaala na nguan.” ");
INSERT INTO rai_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu i piri karom anuna kum naat na wawer naa, “Baa te i walangoro muaat, i walangoro iaau ut. Ma te baa i milikuaana muaat, i milikuaana iaau utkaai. Ma te baa i milikuaana iaau, i milikuaana utkaai ia baa i tula wa iaau urin.” ");
INSERT INTO rai_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma 72 diat, diat waan talili balet ma ra gaaia ma diat piri naa, “Tadaaru, baa miaat lu irok wa a kum tabaraan u ra iaam, diat taraam ku.” ");
INSERT INTO rai_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma Iesu i piri taan diat naa, “Iaau babo Saataan i puka taanginaanga u ra maawa welaar ma in mamame. ");
INSERT INTO rai_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iaau aa taar taa a naagagon taa muaat kupi muaat a paa waatwaat a kum wui ma ra kum pokpokolamaa kaai, ma kupi muaat a uwia paa a dekdek i ra ebaar, ma pa ta utnaa in baanaakaka muaat. ");
INSERT INTO rai_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Iaku maa, koku muaat gaaia maa a kum tabaraan diat taraam taa muaat. Muaat a gaaia, maa di aa timu a iaamuaat inaanga u ra maawa.” ");
INSERT INTO rai_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","U ra pakaana bung maa Iesu i teng ma ra gaaia ko ra Takado na Nion ma i piri naa, “Tamaang, ui a Tadaaru i ra maawa ma ra rakrakaan buaal raap, iaau pir walaawa pa ui, maa u walipa a kum utnaa mi ko ra kum tena manaana ma kon diat baa diat malem, ma u pir waiaai ku karom diat baa diat welaar ma ra kum naat liklik. Maia, Tamaang, maa u nemi ut lenmaa. ");
INSERT INTO rai_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamaang ia taar taa a kum utnaa raap taang. Pa te i nunura Natuna, Tamaana ku, ma pa te kaai i nunura Tamaana, Natuna ku, ma diat kaai baa Natuna i nemi naa in pir waiaa Tamaana karom diat.” ");
INSERT INTO rai_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Baa Iesu ma ra nuna kum naat na wawer maku diat ki, i tapuku karom diat ma i piri naa, “Muaat daan baa muaat babo a kum utnaa mi! ");
INSERT INTO rai_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iaau piri taa muaat, namuga mongoro na propet ma mongoro na king diat nemi naa diat a babo a kum utnaa mi iaau paami namataamuaat, iaku pa diat baboi. Ma diat nemi kaai naa diat a walangoro a kum utnaa mi muaat walwalangoroi, iaku maa pa diat walangoroi.” ");
INSERT INTO rai_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Raa tena manaana u ra kum Naagagon i tur ma i walaar Iesu, ma i piri naa, “Tena Wawer, aawa maa ang paami kupi ang kale a lalaaun takum?” ");
INSERT INTO rai_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma Iesu i piri taana naa, “Aawa maa di aa timu taai u ra kum Naagagon? Ma aawa maa u nuki uni?” ");
INSERT INTO rai_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A muaana maa i baalui naa, “‘Un maari a Tadaaru anum God ma ra in balaam raap, a niom raap, a dekdekim raap, ma ra nuknukim raap.’ Naag 6:5 Ma ‘Un maari tepaam welaar ma u maari ui ut.’” Lewi 19:18 ");
INSERT INTO rai_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu i piri taana naa, “I takado ut anum pirpir, un paami lenmaa, ma un lalaaun.” ");
INSERT INTO rai_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iaku a tena wawer u ra kum Naagagon i nemi naa in wakado paai namataan Iesu, ma i tiri naa, “Woi maa tepaang?” ");
INSERT INTO rai_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu i baalui ma ra pirpir welwelaar lenbi, “Raa muaana i waan taanginaanga Ierusalem urong Ieriko. Baa i waan waanwaan, a kum tena walong diat welulu baat paai. Diat palaa wa anuna kum maalu, diat um aakaka taai, ma diat waan paa koni ma marawaai in maat. ");
INSERT INTO rai_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma raa tena wetabaar karom God i waan u ra aakapi maa, ma baa i babo paa a muaana maa, i waan liliaai ku koni un raa papaar. ");
INSERT INTO rai_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Raa muaana bulung ko ra wuna taara anun Lewi, baa i waan taau u ra muaana maa, i waan liliaai ku koni un raa papaara aakapi. ");
INSERT INTO rai_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Iaku raa te Samaaria baa i waan waanwaan, i waan taau u ra muaana maa, ma baa i baboi, i maari aakiti. ");
INSERT INTO rai_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I waan karomi, i labo taa a wel ma a waain u ra nuna kum baaba ma i pulu baat ta diat. I wakaa paai u ra nuna dongki, ma i wairok taai u ra ruma na ininep aagil paa, ma i babourai. ");
INSERT INTO rai_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","U ra bung namur taana, i lo paa a ru denaaria, ma i taar taai karom a tamaa ra ruma, ma i piri taana naa, ‘Un babourai. Ma baa ta utnaa kaai un tabaara taai mai, baa ang waan talili balet, ang baalu taai balet taam.’ ");
INSERT INTO rai_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Woi ko ra tula muaana mi diaar tepaana ma ra muaana baa a kum tena walong diat umi?” ");
INSERT INTO rai_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma a tena wawer u ra kum Naagagon i baalui naa, “Ia baa i maari.” Ma Iesu i piri taana naa, “Un waan ma un paami lenutmaa.” ");
INSERT INTO rai_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Baa Iesu ma ra nuna kum naat na wawer diat waan balet, diat waan paat un raa taamaan, ma raa tabuan, a iaana Maataa, i ben aruk paa Iesu u ra nuna ruma. ");
INSERT INTO rai_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma tenawawina a iaana Maaria, i ki marawaai naa ra ru kaki ra Tadaaru, ma i walwalangoro anuna pirpir. ");
INSERT INTO rai_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Maataa i kariaanai baa i dekdek karomi a kum pinapaam i paami, i waan karom Iesu ma i piri taana naa, “Tadaaru, pa u nuk pa iaau? Baboi, tenawawing pa i waraaut iaau. Iaau maku iaau paam a kum pinapaam. Tula wai urin kupi in waraaut iaau.” ");
INSERT INTO rai_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Tadaaru i baalui naa, “Maataa, Maataa, u ngaraa aakit, ma u nuknuk aakit u ra mongoro na utnaa! ");
INSERT INTO rai_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Raa utnaa ku i koina. Maaria ia pilak paa a koina utnaa, ma pa te maut in lo wai koni.” ");
INSERT INTO rai_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Raa bung Iesu i aaraaring un raa wanua. Baa ia aaraaring raap, raa ko ra nuna kum naat na wawer i piri taana naa, “Tadaaru, un wer miaat u ra niaaring, welaar ma Ioaanes i wer anuna kum naat na wawer.” ");
INSERT INTO rai_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Iesu i piri taan diat naa, “Baa muaat aaraaring, muaat a aaraaring lenbi, ‘Tamaamiaat, i koina baa din ru a iaam. I koina baa anum mataanitu in waan paat. ");
INSERT INTO rai_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","A bungbung raap un tabaara miaat ma ra maamiaat utnaa. ");
INSERT INTO rai_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Un dumaana wa anumiaat kum aakaina mangamangaan, maa miaat kaai miaat dumaana wa anundiat kum aakaina mangamangaan karom miaat. Koku u ben miaat u ra walwalaam.’” ");
INSERT INTO rai_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iesu i piri taa ra nuna kum naat na wawer naa, “Baa te kon muaat in waan karom tepaana u ra ngaala na marum, ma in aaringi naa, ‘Tepaang, iaau nem ta tuluin bred. ");
INSERT INTO rai_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Raa tepaang i waan paat karom iaau u ra nuna winawaan, ma pa ta utnaa baa ang tabaarai mai.’ ");
INSERT INTO rai_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma tepaana kuraa naruma in piri naa, ‘Koku u pet abalaana iaau! Miaat aa balbalaat, ma miaat ma ra kum natnatung liklik miaat aa inep. Pang pari balet ma kup ang lo taa ta utnaa taam.’ ");
INSERT INTO rai_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wakir kabina diaar tepaana baa in pari kupi in taar taa a bred taana, iaku in pari ma in taar taa a utnaa baa i nemi, kabina i aaring liklikinai. ");
INSERT INTO rai_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Io, mi iaau piri taa muaat, muaat a aaraaring ma din tabaara muaat. Muaat a baatbaat ma muaat a baat paai. Muaat a pipidik ma din paapa aara muaat. ");
INSERT INTO rai_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maa diat raap baa diat aaraaring din tabaara diat, ma ia baa i baatbaat in baat paai, ma ia baa i pipidik, din paapa aarai. ");
INSERT INTO rai_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Woi kon muaat a kum tamtamaa ra kum naat liklik, baa natunalik i aaringi kup tina ian, in tabaarai ku ma ra ina wui? ");
INSERT INTO rai_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma baa i aaringi kup tina kiaau, in tabaarai ku ma ta pokpokolamaa? ");
INSERT INTO rai_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Baa muaat aakaina taara, muaat nunura ut a koina wetabaar karom a kum natnatumuaat, io, i lingtatuna aakit baa Tamaamuaat baa i ki inaanga u ra maawa, in taar taa a Takado na Nion taan diat baa diat aaringi.” ");
INSERT INTO rai_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu i lu irok wa a tabaraan baa i munga kon raa muaana. Baa a tabaraan maa i pari paa koni, a muaana maa i pirpir maraagaam. Ma a kor na taara diat kakaian. ");
INSERT INTO rai_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Iaku raa taara kon diat, diat piri ku naa, “I lu irok wa a kum tabaraan ma ra dekdekin Belsebul, a tadaaru anu ra kum tabaraan.” ");
INSERT INTO rai_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Raa taara kaai diat aaringi naa in paam ta utnaa na kakaian kupi in wakilangi naa ia taanginaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iaku Iesu ia nunura a nuknukindiat, ma i piri taan diat naa, “Baa ta mataanitu diat balet ut diat a weium wetwetalaai, a mataanitu maa in raap ku. Ma baa ta naadiwaatamaana diat a weium wetwetalaai balet ku ma diat, pain diat a ki ungaai ma. ");
INSERT INTO rai_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Baa Saataan i weium balet ku ma ra nuna kum tultul, anuna mataanitu in tur dekdek lelawaai? Iaau piri lenmaa kabina maa muaat piri un iaau naa iaau lu irok wa ku a kum tabaraan ma ra dekdekin Belsebul. ");
INSERT INTO rai_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Baa iaau lu irok wa a kum tabaraan ma ra dekdekin Belsebul, anumuaat taara diat lu irok wa diat ma ra dekdekin woi? Io, anundiat pinapaam ut in wapuaanai naa anumuaat wetakun i raara. ");
INSERT INTO rai_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Iaku baa iaau lu irok wa a kum tabaraan ma ra dekdekin God, muaat a nunurai naa anuna mataanitu ia waan paat karom muaat. ");
INSERT INTO rai_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Baa raa dekdek na muaana ia mong paa ma nuna utnaa na wineium, ma i baboura anuna ruma, anuna kum utnaa in taana wakaak. ");
INSERT INTO rai_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Iaku, baa te i dekdek taana i waan paat karomi ma i uwia paai, in raa wa anuna kum utnaa na wineium baa i nurnur uni, ma in lo paa a kum utnaa raap anu ra muaana maa ma in tabaara a taara mai. ");
INSERT INTO rai_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ia baa pa i waraaut iaau, i turbaat iaau ku. Ma ia baa pa i waraaut iaau u ra weben, i lulu weraana wa diat ku. ");
INSERT INTO rai_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Baa a tabaraan i pari paa kon ta muaana, i waan u ra kum wanua baa pa ta palaa iaai, kupi in ngo, iaku pa i baat paa ta wanua baa in ngo iaai. Io, i piri lenbi, ‘Ang waan talili balet kup anung ruma, baa iaau pari paa koni.’ ");
INSERT INTO rai_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma baa i waan paat, i baboi baa di aa aarupa taai, ma di aa maar taai. ");
INSERT INTO rai_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Namur i waan ma i ben paa balet 7 na tabaraan, baa diat aaka aakit koni, ma diat ruk raap taau u ra ruma maa, ma diat ki uni. Io, a lalaaun anu ra muaana maa i aaka aakit ma ko ra lalaaun baa i watur akotoi namuga.” ");
INSERT INTO rai_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Baa Iesu i pirpir utbaai, raa tabuan ko ra kor na taara maa, i piri lenbi, “A tabuan baa i buta pa ui ma i wangaau ui, i daan.” ");
INSERT INTO rai_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iaku Iesu i baalui naa, “Diat baa diat walangoro a pirpir anun God ma diat taraam uni, diat daan aakit.” ");
INSERT INTO rai_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Baa a kor na taara diat liur baat paa Iesu, i piri taan diat naa, “A taaun taara mi, a aakaina taaun taara. Diat nem ta wakilang, iaku maa pa din paam te karom diat. Din paam ku a wakilang welaar ma Ionaa. ");
INSERT INTO rai_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maa Ionaa ia a wakilang karom a taara Niniwe, lenkaai maa Natu ra Muaana ia a wakilang karom a taaun taara mi. ");
INSERT INTO rai_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","U ra bung na naagagon, a kwin taangirong u ra mataana taubaar in tur ma in takuna dekdek a taaun taara mi, kabina maa i waan ut taanga welwelik kupi in walangoro a manaana anun King Solomon, ma raa maa i ngaala taan Solomon kuri ut min. ");
INSERT INTO rai_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","U ra bung na naagagon, a taara Niniwe diat a tur ma diat a takuna dekdek a taaun taara mi, kabina maa diat nukpuku u ra warawaai anun Ionaa, ma raa maa i ngaala taan Ionaa kuri ut min. ");
INSERT INTO rai_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Pain te in wakup taa ta laam ma in walipa taai, baa in kuop baat taai ma ra baaket. Pate! In ung taai ut nate u ra nuna turtur, kupi diat baa diat ruk diat a babo a kaapakaapaina. ");
INSERT INTO rai_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A ruin kiok na mataam diaar welaar ma ra laam u ra panim. Baa a ruin kiok na mataam diaar koina, a panim raap in teng ma ra kaapa. Iaku baa diaar aaka, a panim raap in teng ma ra baboto. ");
INSERT INTO rai_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","In koina baa a panim in teng ma ra kaapa, ma un babourai kupi koku i teng ma ra baboto. ");
INSERT INTO rai_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Baa a panim raap i teng ma ra kaapa, ma pa ta baboto uni, in baarabaara aakit, welaar ma ra laam baa a kaapakaapaina i kup aara ui.” ");
INSERT INTO rai_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Baa Iesu ia pirpir raap, raa Parisaaio i ben paai kupi diaar a wangaan ungaai. Iesu i ruk ma i ki na winangaan. ");
INSERT INTO rai_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Baa a Parisaaio i baboi naa Iesu pa i gigi muga paa, i kakaian uni. ");
INSERT INTO rai_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A Tadaaru i piri taana naa, “Muaat a kum Parisaaio muaat gigi paa ku a tamaru ra kaap ma ra pelet, iaku a balaamuaat i teng ma ra walong ma ra kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Muaat a kum longlong muaat, pa muaat nunurai naa ia baa i paam a tamaru ra kum utnaa i paam kaai a balaandiat? ");
INSERT INTO rai_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Muaat a tabaara a iba na taara ma ra utnaa ko ra numuaat kum kaap ma ra kum pelet, kupi a kum utnaa raap in gomgom karom muaat. ");
INSERT INTO rai_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“In aaka aakit karom muaat a kum Parisaaio. Muaat nuknuk aakit u ra kum kinkinalik na naagagon lenbi, muaat taar raaraain diwaai ko ra noina naatnaat na diwaai baa i aangawian wakwakaak, iaku pa muaat paam a takado na naagagon karom a taara ma ra maarmaari karom God. I koina baa muaat a paam a takado na naagagon karom a taara ma ra maarmaari karom God, ma koku kaai muaat dumaana wa raaraain ko ra noina, kupi muaat a taari karom God. ");
INSERT INTO rai_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","In aaka aakit karom muaat a kum Parisaaio, maa muaat nem a kinkini namuga u ra kum ruma na lotu. Ma muaat nemi kaai naa a taara diat a taar a ngaala na urur karom muaat u ra kum taamaan na winawaan ungaai. ");
INSERT INTO rai_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","In aaka aakit karom muaat, maa muaat welaar ma ra kum tungtung na minaat baa pa ta wakilang un diat, ma a taara diat waan nate un diat ma pa diat nunurai.” ");
INSERT INTO rai_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Io, raa ko ra kum tena wawer u ra kum Naagagon i piri taan Iesu naa, “Tena Wawer, baa u piri lenmi, u pir aakaka miaat kaai.” ");
INSERT INTO rai_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Iesu i baalui lenbi, “In aaka aakit kaai karom muaat a kum tena wawer u ra kum Naagagon, maa muaat taar taa a kum dekdek na naagagon kupi a taara diat a murmuri, ma muaat ut pa muaat waraaut diat uni. ");
INSERT INTO rai_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","In aaka aakit karom muaat, maa muaat watur a kum aaim naa ra kum babaang na minaat anu ra kum propet, baa anumuaat wuna taara ut taanga namuga diat aak doko wa diat. ");
INSERT INTO rai_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mi muaat wapuaanai naa muaat mulaaot ungaai ma ra numuaat wuna taara taanga namuga u ra nundiat pinapaam baa diat aak doko a kum propet, ma muaat, muaat watur a kum aaim naa ra kum babaang na minaat anundiat. ");
INSERT INTO rai_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bi ia kabina God baa i manaana aakit i piri naa, ‘Ang tula wa a kum propet ma a kum aapostolo karom a taara, ma a taara diat a aak doko ta taara kon diat ma ta taara kaai diat a wakadik diat.’ ");
INSERT INTO rai_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Io, muaat a taaun taara mi din taar a naagagon na binabaalu karom muaat, u ra gaap i ra kum propet raap baa di aa aak doko wa diat, turpaai u ra turpaai ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Turpaai baa di aak doko Aabel ma i waan tuk baa di aak doko Saakaria, ia baa i wirua naliwan naa ra luwu na tuntun wetabaar ma ra pakaana baa i Taabu naruma u ra ruma na wetabaar. Io, iaau piri taa muaat, din taar a naagagon na binabaalu karom a taaun taara mi u ra kum utnaa raap mi. ");
INSERT INTO rai_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","In aaka aakit karom muaat a kum tena wawer u ra kum Naagagon, maa muaat balbalaat wa a bonanaaka kup a manaana. Muaat ut pa muaat ruk uni, ma muaat turbaat diat baa diat nem na ruk uni.” ");
INSERT INTO rai_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Baa Iesu i pari ko ra ruma maa, a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio diat kaankaan ma diat puku anuna pirpir, ma diat tiri pukpukui un ta mongoro na utnaa. ");
INSERT INTO rai_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma diat ki walaanga Iesu kup ta mangaana pirpir baa diat a takunai mai. ");
INSERT INTO rai_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Baa a kum maarmaar na taara diat aa waan paat ungaai, ma diat tumaak wetwetalaai diat maku, Iesu i pir mugai karom anuna kum naat na wawer lenbi, “Muaat a baboura muaat ko ra is anu ra kum Parisaaio. Iaau pirpir u ra nundiat mangamangaan na warwaruga. ");
INSERT INTO rai_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A utnaa raap baa di burung baat taai, namur in taana baarabaara, ma ra utnaa raap baa i taana ino, namur in waan paat kaapakaapa. ");
INSERT INTO rai_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A kum utnaa raap baa muaat aa pir taai u ra baboto, namur din walangoroi u ra kaapa, ma ra utnaa baa muaat wewaik ino ku mai naruma karom te, namur din tur nate u ra ruma, ma din wapuaanai karom a taara. ");
INSERT INTO rai_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Iaau piri taa muaat a kum teptepaang: Koku muaat burut kup diat baa diat aak doko ku a panimuaat. Baa diat aa paam taai lenmaa un muaat, pain diat a pet laar paai kupi diat a paam balet ta utnaa. ");
INSERT INTO rai_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi ang wapua kaapa muaat un ia baa muaat a burut kupi: Muaat a burut kup ia baa a dekdekina i ngaala kupi in aak doko muaat ma in ong aruk a niomuaat u ra ngaala na nguan kaai. Maia, iaau piri taa muaat, God ku maa muaat a burut kupi. ");
INSERT INTO rai_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Di laana kul limnaina pika liklik ma kabaana toiaa ku, naka? Iaku God pa i dumaana wa tin lik kon diat. ");
INSERT INTO rai_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","I lingtatuna aakit God i nunura raap a kum weu na lorimuaat. Koku muaat burut, maa muaat ngaatngaat aakit namataan God taa ra mongoro na pika. ");
INSERT INTO rai_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iaau piri taa muaat naa, baa te in pir apuaana iaau namataa ra taara, Natu ra Muaana kaai in pir apuaanai namataa ra kum aangelo anun God. ");
INSERT INTO rai_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Baa te in weoro kon iaau namataa ra taara, Natu ra Muaana kaai in weoro koni namataa ra kum aangelo anun God. ");
INSERT INTO rai_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma baa te in pir taa ta aakaina pirpir un Natu ra Muaana, din una wai ku, iaku baa te in pirpir aakaka u ra Takado na Nion, pain te in una laar paai. ");
INSERT INTO rai_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Baa diat aal pa muaat kup a naagagon u ra kum ruma na lotu, ma namataa ra kum tena naagagon ma ra kum mukmuga, koku muaat ngaraa baa aawa muaat a pir baat muaat mai ma aawa muaat a piri. ");
INSERT INTO rai_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maa u ra pakaana bung maa a Takado na Nion ut in wer muaat u ra utnaa baa muaat a piri.” ");
INSERT INTO rai_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Raa ko ra kor na taara i piri taan Iesu naa, “Tena Wawer, un wapua tenglik kupi in weraana a wuwuwung karom mir, baa tamaamir i maat paa koni.” ");
INSERT INTO rai_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma Iesu i baalui naa, “Le, woi maa i ung ta iaau kupi ang tena naagagon baa kupi ang weraana anumur wuwuwung karom mur?” ");
INSERT INTO rai_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma i piri taan diat, “Muaat a nuk paai, ma muaat a baboura muaat ko ra nemnem kup a ngaala na wuwuwung, maa a lalaaun anun te pa i kabina paa ko ra nuna mongoro na wuwuwung.” ");
INSERT INTO rai_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma i wapua diat un raa pirpir welwelaar lenbi, “A pinapaam anun raa tadaaru na muaana i ngaala aakit a waina. ");
INSERT INTO rai_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma i nuki naa, ‘Aawa ang paami, maa pa ta ruma baa ang ung a wai ra nung pinapaam uni?’ ");
INSERT INTO rai_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma i piri naa, ‘Io, ang paami lenbi, ang reng wa anung kum ruma na wawalaaing, ma ang paam balet ta kum ngaalangaala aakit, ma ang ung a wai ra nung pinapaam ma anung wuwuwung raap uni. ");
INSERT INTO rai_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma ang piri taa ra niong lenbi, “A niong, anum kum wuwuwung i mongoro aakit kup ta mongoro na kilaala. Un ngo, un wangaan, un inim ma un gaaia.” ’ ");
INSERT INTO rai_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iaku God i piri taana lenbi, ‘Ui a longlong, mi ut u ra marum, un maat! Woi maa in lo a kum wuwuwung maa u ungung ungaai taai kup ui?’ ");
INSERT INTO rai_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","In lenmaa karom diat baa diat wuwuwung karom diat ut, ma pa diat tadaaru namataan God.” ");
INSERT INTO rai_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iesu i piri karom anuna kum naat na wawer naa, “Bi ia kabina maa iaau piri taa muaat naa, koku muaat ngaraa u ra numuaat lalaaun baa aawa muaat a aani ma u ra panimuaat kaai baa aawa muaat a mong mai. ");
INSERT INTO rai_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Maa a lalaaun i ngaala ko ra utnaa na winangaan, ma ra panimuaat i ngaatngaat ko ra maalu. ");
INSERT INTO rai_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Muaat a babo a kum kotkot. Pa diat maarut ta utnaa, ma pa diat tangaa ungaai ta utnaa, pa nundiat ta ruma na wuwuwung, iaku God i taptabaara diat. Ma muaat ngaatngaat aakit taa ra kum pika. ");
INSERT INTO rai_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Woi kon muaat baa i ngaraa in pet laar paai kupi in kanaawa paa balet ta pakaana bung lik u ra nuna lalaaun? Pate! ");
INSERT INTO rai_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Baa pa muaat paam laar paa a utnaa lik bi, kup aawa maa muaat ngaraa kup ta kum utnaa kaai? ");
INSERT INTO rai_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Muaat a babo a kum purpur taanga nabuaal, baa diat tawa lelawaai. Pa diat papaam ma pa diat laana paam maalu. Iaku iaau piri taa muaat, King Solomon ut maa nuna minong raap i babo wakaak, iaku pa i babo wakwakaak welaar ma ra kum purpur maa. ");
INSERT INTO rai_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God i wamong a kum wali nabuaal ma ra kum koina pupuindiat, baa i pupu umari, ma unaburu din tun wai u ra nguan. Baa i paami lenmaa u ra kum wali, io, i lingtatuna aakit baa in wamong muaat utkaai. I kinalik aakit anumuaat nurnur. ");
INSERT INTO rai_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Koku muaat nuknuk dekdek kup aawa maa muaat a aani, ma aawa maa muaat a inimi, ma koku muaat ngaraa uni. ");
INSERT INTO rai_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Maa a kum taara u ra rakrakaan buaal baa pa diat nurnur, diat ngaraa aakit kup a kum utnaa raap mi, ma Tamaamuaat i nunurai naa muaat iba kup a kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Muaat a ngaraa kup anuna mataanitu, ma in tabaara muaat ma ra kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“A kikil na siplik, koku muaat burut, maa Tamaamuaat i gaaia kupi in taar taa a mataanitu karom muaat. ");
INSERT INTO rai_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muaat a wiura anumuaat kum ututnaa kup a maani ma muaat a tabaara a kum iba na taara mai. Muaat a waninaar paa anumuaat ta kum paaus baa pa in maul, a ngaatngaat na utnaa inaanga u ra maawa baa pa in panaai, ma pa ta tena walong in waan marawaai karomi, ma a paropo pa in baanaakakai. ");
INSERT INTO rai_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maa anumuaat lalaaun in ki u ra taamaan baa anumuaat ngaatngaat na utnaa i taana iaai. ");
INSERT INTO rai_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Koku muaat duman, maa muaat aa mong paa ma muaat aa wakup paa anumuaat kum laam, ma muaat a ki na waninaar maku. ");
INSERT INTO rai_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ma muaat a welaar ma ra kum tultul baa diat ki walaang kup anundiat tadaaru baa in waan talili balet ko ra lukaara na paakamaau. Baa in waan paat ma in pipidik, din paapa aara gagaai. ");
INSERT INTO rai_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Baa a tadaaru in waan paat, ma nuna kum tultul diat ki na waninaar, diat daan. A lingtatuna ut mi iaau piri taa muaat, in paa wa nuna kot ma in waki ta diat u ra luwu na winangaan ma ia ut in tabaara diat. ");
INSERT INTO rai_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Baa in waan paat taau un diat u ra ngaala na marum, baa u ra laar, ma diat ki walaang ut kupi, io, a kum tultul maa diat daan. ");
INSERT INTO rai_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Muaat a manaana kup a utnaa bi: Baa a tamaa ra ruma i nunura a pakaana bung baa a tena walong in waan paat uni, pa in maadek wa nuna ruma kupi din walongi. ");
INSERT INTO rai_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Io, muaat kaai, muaat a ki na waninaar, maa Natu ra Muaana in waan paat u ra pakaana bung baa pa muaat nuki naa in waan paat uni.” ");
INSERT INTO rai_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petero i tiri Iesu naa, “Tadaaru, u pir a pirpir welwelaar mi un miaat ku baa u ra taara raap?” ");
INSERT INTO rai_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Tadaaru i baalui lenbi, “Woi na tultul i dowot u ra nuna pinapaam ma i manaana kaai? A tultul maa, anuna tadaaru in waki taai kupi in tena naagagon u ra nuna ruma, ma in taptabaara a kum tultul kaai ma andiat utnaa na winangaan u ra kum pakaana bung na winangaan. ");
INSERT INTO rai_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A tultul maa in daan baa anuna tadaaru in waan paat ma in baboi baa i paam ot paa a kum utnaa. ");
INSERT INTO rai_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iaau pir a lingtatuna taa muaat, anuna tadaaru in taar taa a naagagon taana kupi in tena naagagon u ra nuna kum utnaa raap. ");
INSERT INTO rai_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Iaku baa a tultul maa i nuki naa anuna tadaaru pa in waan paat gagaa, io, i turpaai kupi in um a kum tultul na muaana ma ra kum tultul na tabuan. Ma i wangaan, ma i inim alonglongi. ");
INSERT INTO rai_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Anuna tadaaru in waan paat un ta bung baa ta pakaana bung baa a tultul maa pa i nunurai ma pa i nuki naa in waan paat uni. Io, a tadaaru maa in bur kutkutui, ma in taar taa a naagagon na binabaalu karomi kupi in ki ungaai ma diat baa pa diat nurnur. ");
INSERT INTO rai_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“A tultul baa ia nunura taa a nemnem anu ra nuna tadaaru, iaku pa i waninaar, ma pa i papaam welaar ma ra nemnem anu ra nuna tadaaru, din raapu dekdeki. ");
INSERT INTO rai_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Iaku a tultul baa pa i nunura a utnaa baa anuna tadaaru i nemi, ma i paam a utnaa baa pa i takado, din raapu kinaliki ku. Ma karom ia baa di taar taa a ngaala taana, din nem kaai ta ngaala ut koni, ma ia baa di taar taa a mongoro taana, din tiri ut kup ta mongoro. ");
INSERT INTO rai_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Iaau waan paat kupi ang wakaa taa a nguan u ra rakrakaan buaal, ma iaau nem aakiti baa ia kup. ");
INSERT INTO rai_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anung baapitaaiso na minaat kuri utbaai baa din baapitaaiso iaau mai, ma mi iaau lo a ngaala na mawaat tuk baa din paam ot paai. ");
INSERT INTO rai_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lelawaai, muaat nuki naa iaau waan paat kupi ang taar a maalmaal u ra rakrakaan buaal? Pate, iaau waan paat kupi a taara diat a takunu weraan. ");
INSERT INTO rai_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Turpaai mari, limadi diat un raa ruma diat a tur weraan, tuldi ditul a kaankaan karom rudi, ma rudi diaar a kaankaan baalu ditul. ");
INSERT INTO rai_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Diat a takunu weraan, a muaana kon natunalik a muaana, ma a naat muaana kon tamaana. A tabuan kon natunalik a tabuan, ma a naat na tabuan kon naana, ma raa naadiaar tabuna diaar a kaankaan wetwetalaai karom diaar.” ");
INSERT INTO rai_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu i piri balet taa ra kor na taara naa, “Baa muaat babo a baakut u ra mataana labur, muaat pir gagaai maut naa, ‘I marawaai ma kupi in baata’, ma i lingtatuna ut. ");
INSERT INTO rai_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Baa muaat kariaana a taubaar, muaat piri naa, ‘In mage in dekdek’, ma i lingtatuna ut. ");
INSERT INTO rai_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Muaat a kum tena warwaruga! Muaat manaana kupi muaat a palaa a binabo u ra rakrakaan buaal ma u ra baakut, ma lelawaai maa pa muaat manaana kupi muaat a palaa a kukuraai ra kum utnaa baa i waan paat u ra kum bungbung mi? ");
INSERT INTO rai_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Lelawaai maa muaat ut pa muaat nuknuk wakaak kup a aakapi baa i takado? ");
INSERT INTO rai_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Baa num ebaar in ben pa ui kup a naagagon, un ongor kupi mur a wemaraam muga, kaduk in aal pa ui karom a tena naagagon, ma a tena naagagon in taar ta ui karom a polis, ma a polis in waruk ta ui u ra ruma na karabus. ");
INSERT INTO rai_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iaau piri taam, pa un pari laar paai tuk ut baa un taar araap wa a tintinip na toiaa i ra num winekul.” ");
INSERT INTO rai_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","U ra pakaana bung maa raa taara diat wapua Iesu un raa taara Gaalilaia baa Pilaato i aak doko diat, baa kuraa ut diat tun wetabaar karom God. ");
INSERT INTO rai_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu i baalu diat naa, “Lelawaai, muaat nuki naa diat a kum tena aakaina aakit taa ra taara Gaalilaia raap, kabina maa diat wirua lenmaa? ");
INSERT INTO rai_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pate mulu! Iaku iaau piri taa muaat, baa pa muaat nukpuku ko ra numuaat kum aakaina mangamangaan, muaat kaai muaat a wirua raap. ");
INSERT INTO rai_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Ma aawa maa muaat nuki un 18 na taara inaanga Ierusalem baa a turtur na ruma u ra pakaana Siloaam i taripu ma i aak doko raap wa diat? Lelawaai, diat maa a kum tena aakaina aakit taan diat baa diat ki Ierusalem raap? ");
INSERT INTO rai_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pate mulu! Iaku iaau piri taa muaat, baa pa muaat nukpuku ko ra numuaat kum aakaina mangamangaan, muaat kaai muaat a wirua raap.” ");
INSERT INTO rai_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Namur Iesu i pir a pirpir welwelaar mi karom diat, “Raa muaana anuna in diwaai na fig i tur naliwan u ra ana wanua na waain. I waan ma i babo kup ta waina, iaku pa i wa. ");
INSERT INTO rai_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Namur i wapua a tena baboura u ra wanua maa, ‘U ra tula kilaala mi iaau gaana baat kup ta wai ra in diwaai na fig mi. Un bur wai ma! Maa i tur abaatbaat.’ ");
INSERT INTO rai_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Iaku a tena baboura i baalui naa, ‘Tadaaru, un maadek wai raa kilaala balet mi, kupi ang paam aara taai, ma ang urpia taau uni. ");
INSERT INTO rai_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Baa in wa u ra kilaala namur, io in koina. Baa pate, io, un bur wai ma.’” ");
INSERT INTO rai_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Un raa Bung Saabaat Iesu i wer a taara un raa ruma na lotu. ");
INSERT INTO rai_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Raa tabuan i ki matira, a tabaraan i ki uni. I talukun ma in tamaruna 18 na kilaala, ma pa i tur kado laar paai. ");
INSERT INTO rai_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Baa Iesu i baboi, i piri naa, “Neling, u aa laangalaanga ko ra num malaapaang.” ");
INSERT INTO rai_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma Iesu i ung taa a ru limaana nate uni, ma a tabuan maa i tur takado maut, ma i pir walaawa paa God. ");
INSERT INTO rai_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A mukmuga ko ra ruma na lotu i kaankaan, kabina maa Iesu i walaangalaanga paa a tabuan u ra Bung Saabaat. Ma i piri taa ra taara naa, “6 na bung kuraa kupi din papaam. Muaat a waan urin uni, kupi din walaangalaanga pa muaat, ma koku u ra Bung Saabaat.” ");
INSERT INTO rai_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Tadaaru i baalui naa, “Muaat a kum tena warwaruga! Muaat raap raaraa, muaat laana palaa wa anumuaat kum bulumakaau ma ra kum dongki ko ra nundiat kum ruma, ma muaat ben diat u ra Bung Saabaat kupi diat a inim. ");
INSERT INTO rai_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A tabuan mi ko ra wuna taara anun Aabaraam, Saataan i wi taai 18 na kilaala. Aawa kabina baa pa din palaa a winiwi mi koni u ra Bung Saabaat?” ");
INSERT INTO rai_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Baa ia pir taai lenmi taan diat, diat raap baa diat puku a pinapaam anun Iesu, diat wawirwir, ma a kor na taara diat gaaia u ra kum koina utnaa baa Iesu i paami. ");
INSERT INTO rai_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu i piri naa, “A mataanitu anun God i welaar ma ra aawa? Aawa ang welaarai mai? ");
INSERT INTO rai_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I welaar ma ra in waina maastad, baa raa muaana i lo paai, ma i maarut taai u ra ana pinapaam. I tawa, ma in diwaaina i ngaala, ma ra kum pika diat laana paam pio u ra kum gagagaana.” ");
INSERT INTO rai_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu i piri balet naa, “Aawa kaai ang welaara a mataanitu anun God mai? ");
INSERT INTO rai_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I welaar ma ra is baa raa tabuan i rakaan paai ma i paam ungaai taai ma ra ngaala na palawaa, ma a palawaa raap i tubu uni.” ");
INSERT INTO rai_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Baa Iesu i waan waanwaan unaanga Ierusalem, i wer a taara u ra kum ngaalangaala na taamaan ma u ra kum kinkinalik na taamaan. ");
INSERT INTO rai_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma raa i tiri Iesu naa, “Tadaaru, lelawaai, a kinalik na taara ku duk din walaaun pa diat?” Ma i piri taan diat naa, ");
INSERT INTO rai_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Muaat a ongor dekdek kupi muaat a ruk u ra naat na bonanaaka lik, maa a mongoro na taara diat a walaari kupi diat a ruk uni ma pa diat a pet laar paai. ");
INSERT INTO rai_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A tamaa ra ruma in tur ma in balbalaat baat a bonanaaka, ma muaat a turtur nataamaan, muaat a pipidik u ra balbalaat ma muaat a piri naa, ‘Tadaaru, un paapa aara miaat.’ In piri ku taa muaat naa, ‘Pa iaau nunura muaat baa muaat taangawaai muaat.’ ");
INSERT INTO rai_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Namur muaat a piri taana naa, ‘Miaat baa miaat wangwangaan ma miaat ininim ungaai ma ui, ma u laana warawaai u ra numiaat kum taamaan.’ ");
INSERT INTO rai_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Iaku in piri taa muaat naa, ‘Pa iaau nunura muaat, baa muaat taangawaai muaat. Muaat a kum tena aakaina, muaat a waan ingen kon iaau.’ ");
INSERT INTO rai_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Din lu pari wa muaat ku, ma baa muaat a babo Aabaraam, Aaisaak ma Iaakob ma a kum propet raap u ra mataanitu anun God, muaat a taangtaangi, ma muaat a karaat lakomuaat. ");
INSERT INTO rai_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma a taara ko ra waat na mataana dadaip, diat a ki u ra lukaara u ra mataanitu anun God. ");
INSERT INTO rai_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Baboi, raa taara baa diat murmur mi, namur diat a muga, ma raa taara baa diat muga mi, namur diat a murmur.” ");
INSERT INTO rai_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","U ra pakaana bung maa a kum Parisaaio diat waan paat, ma diat piri taan Iesu naa, “Un waan taanga min naa miaat un ta taamaan ingen, maa Erodes i nem na aak doko ui.” ");
INSERT INTO rai_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu i baalu diat naa, “Muaat a waan ma muaat a wapua a tena warwaruga maa lenbi, mari ma unaburu ang lu irok wa a kum tabaraan ma ang walaangalaanga a taara, ma u ra wetula bung ang waraap anung pinapaam. ");
INSERT INTO rai_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ang waan umari ma unaburu ma umeraa utkaai, maa pa ta propet in wirua un ta taamaan ingen, inaanga ut Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ierusalem, Ierusalem, ui baa u aakaak doko a kum propet, ma diat baa di tultula wa diat karom ui u duka doko wa diat ku ma ra kum waat. Mongoro na pakaan iaau nem na burung baat ungaai a kum natnatum welaar ma ra kareke baa i burung baat ungaai a kum natnatuna natudaangi ra ru bibiaana, iaku pa muaat nemi. ");
INSERT INTO rai_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Baboi! God ia waan ko ra numuaat taamaan. Iaau piri taa muaat, pa muaat a babo iaau balet ma tuk u ra bung baa muaat a piri naa, ‘Daat a pir walaawa paa ia baa i waan paat u ra iaa ra Tadaaru.’” Kele 118:26 ");
INSERT INTO rai_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Un raa Bung Saabaat, Iesu i ruk kupi in wangaan u ra ruma anun raa mukmuga anu ra kum Parisaaio, ma a taara diat babo ururai ku kup ta utnaa baa in paami. ");
INSERT INTO rai_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma raa muaana baa i malaapaang, i ururung a panpanina i ki taau namuga naan Iesu. ");
INSERT INTO rai_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu i tiri a kum tena wawer u ra kum Naagagon ma ra kum Parisaaio lenbi, “Lelawaai, i takado u ra Naagagon kupi din walaangalaanga a taara u ra Bung Saabaat baa pate?” ");
INSERT INTO rai_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iaku pa diat baalui. Iesu i paam paa a muaana maa, i walaangalaanga paai, ma i tula wai. ");
INSERT INTO rai_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma Iesu i piri taan diat naa, “Woi kon muaat baa natunalik baa anuna ta bulumakaau in puka taau un ta tung na daanim u ra Bung Saabaat pa in aal tato gagaa paai?” ");
INSERT INTO rai_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma pa diat baalu laar paa anuna pirpir mi. ");
INSERT INTO rai_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Baa Iesu i ki u ra winangaan mi, i babo a taara baa diat waan paat, diat pilak paa ut a kum kiki namuga. Ma i pir raa pirpir welwelaar taan diat lenbi, ");
INSERT INTO rai_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Baa te i ben pa ui u ra lukaara na paakamaau, koku u ki u ra kiki namuga, kaduk in ben paa te baa i ngaala taam. ");
INSERT INTO rai_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma ia baa i weben u ra lukaara in waan paat ma in piri taam naa, ‘Un ki aara a muaana bi.’ Ma un waan ma ra wawirwir kup a kiki kuraa namur aakit. ");
INSERT INTO rai_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Baa di ben pa ui, un waan ma un ki u ra kiki namur aakit, ma ia baa i weben in waan paat, in piri taam naa, ‘Tepaang, un tur ma un waan urin namuga.’ Ma din wangaala pa ui namataandiat baa muaat ki ungaai u ra winangaan. ");
INSERT INTO rai_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maa ia baa i wangaala paa ia ut, din wakinalik paai, ma ia baa i wakinalik paa ia ut, din wangaala paai.” ");
INSERT INTO rai_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Namur Iesu i piri taa ra Parisaaio baa i ben paai kup a winangaan lenbi, “Baa u waninaar paa a winangaan, koku u ben paa a kum teptepaam, ma a kum tatem liklik, ma ra kum kakum, ma a kum tadaaru baa diat ki marawaai naam. Maa diat mi diat a ben pa ui ma diat a baalui karom ui. ");
INSERT INTO rai_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Baa u waninaar paa a winangaan, un ben paa ku a kum iba na taara, diat baa diat kakakaa ku, a kum papeu, ma a kum pula. ");
INSERT INTO rai_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Baa un paami lenmi un daan. Maa pa nundiat ta utnaa kupi diat a baalui mai taam, din baalui taam u ra bung baa a kum tena takado diat a lalaaun balet.” ");
INSERT INTO rai_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Raa kon diat baa diat wangaan ungaai ma Iesu i walangoro a kum pirpir mi, i piri taana naa, “Diat baa diat a wangaan u ra lukaara u ra mataanitu anun God, diat daan.” ");
INSERT INTO rai_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Iesu i piri taana naa, “Raa muaana i waninaar paa a ngaala na lukaara, ma i wapua taa mongoro na taara kupi diat a waan paat. ");
INSERT INTO rai_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma u ra pakaana bung na lukaara maa, i tula wa anuna tultul karom diat baa di aa aaring muga ta diat, kupi in ben pa diat ma ra pirpir lenbi, ‘Muaat a waan urin, maa a kum utnaa ia waninaar raap.’ ");
INSERT INTO rai_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Iaku diat raap diat pir baatbaat diat ku. A mugaana i piri ku taana naa, ‘Iaau aa kul paa a pakaana pia. Ang waan ma ang baboi. Iaau aaring ui baa din maadek wa iaau maku.’ ");
INSERT INTO rai_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma raa kaai i piri naa, ‘Iaau aa kul paa 10 karabaau, ang waan ma kupi ang walaar ta diat. Iaau aaring ui baa din maadek wa iaau maku.’ ");
INSERT INTO rai_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma raa kaai i piri lenbi, ‘Mi ku iaau taulaa, ma pang pet laar paai kupi ang waan.’ ");
INSERT INTO rai_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Io, a tultul i waan talili ma i wapua anuna tadaaru u ra kum pirpir maa. A tadaaru maa i kaankaan, ma i piri taa ra nuna tultul, ‘Un waan gagaa kup a kum ngaalangaala na aakapi ma a kum kinkinalik na aakapi u ra taamaan, ma un ben paa a kum iba na taara, diat baa diat kakakaa ku, a kum pula, ma ra kum papeu.’ ");
INSERT INTO rai_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Namur taana a tultul i piri naa, ‘Tadaaru, iaau aa paam taa a kum utnaa raap baa u wetulaa kupi, iaku raa kum kolo liklik kuraa utbaai naruma.’ ");
INSERT INTO rai_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A tadaaru i piri taa ra tultul naa, ‘Un waan kup a kum ngaalangaala na aakapi ma a kum kinkinalik na aakapi nabuaal, ma un worwor paa a taara kupi diat a ruk, kupi anung ruma in teng wakaak. ");
INSERT INTO rai_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iaau piri taa muaat, pain te kon diat, baa di aa wapua muga ta diat, in wangaan ko ra nung lukaara.’” ");
INSERT INTO rai_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A ngaala na kor na taara diat weur ma Iesu. I tur tapuku karom diat ma i piri naa, ");
INSERT INTO rai_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Baa te i nem na murmur iaau, ma i maari aakit tamaana, naana, anuna tabuan, a kum natnatuna liklik, a kum tatena liklik ma ra nuna lalaaun kaai, iaku pa i ngaala anuna maarmaari karom iaau, ia maa wakir anung naat na wawer. ");
INSERT INTO rai_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Baa te kaai pa i puak paa anuna bolo kupi in murmur iaau, ia maa wakir anung naat na wawer. ");
INSERT INTO rai_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Baa te kon muaat i nemi naa in paam ta ngaala na ruma, in ki wowowon kumun ma in paam amuga paa a mataa ra ruma raap, kupi in manaana uni baa in paam laar paai baa pate. ");
INSERT INTO rai_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kaduk baa pa in paami lenmaa, in paam taa ku in kabi ra ruma, ma pa in waraap laar paai. Io, a taara raap baa diat baboi, diat a tataur uni ");
INSERT INTO rai_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ma diat a piri naa, ‘A muaana mi i paam taa ku in kabi ra ruma iaku pa i waraap laar paai.’ ");
INSERT INTO rai_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Baa ta king ungaai ma 10 aarip na taara na wineium in waan na wineium kup raa king ingen kaai baa anuna 20 aarip na taara na wineium, i koina baa in ki wowowon ma in nuknuk muga baa lelawaai diat topaa 20 aarip na taara baa pate. ");
INSERT INTO rai_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Baa pate, io, in tula wa nuna kum tultul kupi diat a wakado a pirpir ma ra king kup a maalmaal baa a king i welwelik utbaai. ");
INSERT INTO rai_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Lenkaai maa karom muaat, baa te kon muaat pa i maadek wa nuna kum ututnaa raap, ia maa wakir anung naat na wawer. ");
INSERT INTO rai_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A sol i koina, iaku baa ia raap a mapaakina, din wamapaak paai balet ma lelawaai? ");
INSERT INTO rai_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pa i topaa ta pinapaam ma pa in wakoina kaai a pia, din ong wai maku. Ia baa in talingaana, i koina baa in walangor mai.” ");
INSERT INTO rai_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Raa bung a kum tena lolo tatakom ma a kum tena aakaina diat waan karom Iesu kupi diat a walangoroi. ");
INSERT INTO rai_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Iaku a kum Parisaaio ma ra kum tena wawer u ra kum Naagagon diat pirura Iesu naa, “A muaana mi i maraam ku ma ra kum tena aakaina, ma i wangaan ungaai ma diat.” ");
INSERT INTO rai_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma Iesu i pir a pirpir welwelaar taan diat lenbi: ");
INSERT INTO rai_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Baa te kon muaat anuna ta maar na sip, ma raa kon diat i raara, lelawaai, pa in waan paa kon 99 matira u ra wanua baa diat wangaan iaai, ma in baat kup raa baa i raara, tuk in baat paai balet? ");
INSERT INTO rai_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Baa ia baat paai, in puak paai u ra pupuakina, ma in gaaia. ");
INSERT INTO rai_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Baa ia waan talili balet mai, in wataa ungaai paa a kum teptepaana ma diat baa diat ki marawaai, ma in piri taan diat naa, ‘Daat a gaaia, maa iaau aa baat paa balet anung sip baa i raara.’ ");
INSERT INTO rai_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iaau piri taa muaat, lenkaai maa inaanga u ra maawa a gaaia baa u ra tena aakaina baa ia nukpuku in ngaala taun a gaaia baa un 99 baa diat a kum tena takado baa pa diat a nukpuku balet. ");
INSERT INTO rai_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Baa ta tabuan anuna ta 10 maani, ma ia pet raara wa raa, lelawaai, pa in wakup paa a laam, ma in aarupa a ruma, ma in baat wakwakaak ut kupi, tuk in baat paai balet? ");
INSERT INTO rai_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Baa ia baat paai, in wataa ungaai paa a kum teptepaana ma diat baa diat ki marawaai, ma in piri taan diat naa, ‘Daat a gaaia, maa iaau aa baat paa balet raa maani baa iaau pet raara wai.’ ");
INSERT INTO rai_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iaau piri taa muaat, lenkaai maa a gaaia naliwan naa ra kum aangelo anun God un raa tena aakaina baa i nukpuku.” ");
INSERT INTO rai_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu i piri balet lenbi, “Raa muaana a ru natnatuna a ru naat muaana. ");
INSERT INTO rai_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma a murmur i piri taan tamaana naa, ‘Tamaang, un rakaan taa anung ta tiniba ko ra num wuwuwung.’ Io, tamaandiaar i weraana taa anuna wuwuwung taan diaar. ");
INSERT INTO rai_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kabaana bung baat taai a murmur i ung ungaai paa anuna wuwuwung raap, ma i waan kup a taamaan welwelik, ma i waraap wa anuna wuwuwung raap u ra mangaana lalaaun baa pa i koina. ");
INSERT INTO rai_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Baa ia ong araap wai lenmaa, a ngaala na minolo i waan paat u ra taamaan maa, ma i molo ma. ");
INSERT INTO rai_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma i waan, ma i papaam karom raa muaana ko ra taamaan maa. Ma a muaana maa i tula taai u ra nuna long na boro kupi in taptabaara diat. ");
INSERT INTO rai_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I nemi naa in maaur ma ra kum panina utnaa baa a kum boro diat aanaani, iaku pa te i tabaarai. ");
INSERT INTO rai_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Baa a koina ninunuk i waan paat balet karomi, i piri, ‘A kum tultul raap anun tamaang diat wangwangaan ma diat maaumaaur paa ku ko ra kum utnaa, iaku iaau, kuri iaau maat ma ra minolo! ");
INSERT INTO rai_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi ang tur paa ma ang waan ma kup tamaang. Ang piri taana lenbi, “Tamaang, iaau aa paam taa aakaina mangamangaan karom God ma karom ui kaai. ");
INSERT INTO rai_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iaau pa iaau koina kupi din waatung iaau naa natumlik. Un ung ta iaau maku kupi ang welaar ma raa ko ra num kum tultul.” ’ ");
INSERT INTO rai_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Io, i tur paa ma i waan kup tamaana. Baa i welwelik utbaai, tamaana i babo paai, ma i maari aakiti. I welulu karomi, i raat paai ma i dumi. ");
INSERT INTO rai_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma natunalik i piri taana naa, ‘Tamaang, iaau aa paam taa aakaina mangamangaan karom God ma karom ui kaai. Pa iaau koina ma kupi din waatung iaau naa natumlik.’ ");
INSERT INTO rai_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iaku tamaana i piri taa ra nuna kum tultul, ‘Muaat a lo gagaa paa tina maalu baa i koina aakit urin, ma muaat a wagop taai mai. Muaat a ung taa a ring u ra limaana, ma muaat a waruk taa kaai a ru su u ra ru kakina. ");
INSERT INTO rai_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Muaat a waan, muaat a aal paa ta naatnaat na tubutubu na bulumakaau urin, muaat a aak doko paai, ma daat a wangaan ma daat a gaaia ungaai. ");
INSERT INTO rai_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Maa natunglik bi i maat, ma mi ia lalaaun balet, i raara paa ma mi ia waan paat balet.’ Io, a lukaara i turpaai. ");
INSERT INTO rai_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Iaku natunalik, baa a mugaana, i ki ut iaa u ra pinapaam. Baa i waan paat unataamaan marawaai naa ra ruma, i walangoro a tinaangi na kaaur ma ra kelekele na nilaagaar, ");
INSERT INTO rai_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ma i wataa paa raa tultul, ma i tiri u ra kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma a tultul i piri taana naa, ‘Temlik ia waan paat, ma tamaam i aak doko paa a naatnaat na tubutubu na bulumakaau uni, maa diaar webabo balet, u ra koina lalaaun.’ ");
INSERT INTO rai_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma tenalik a mugaana i kaankaan, i patut ku, pa i nemi naa in ruk. Io, tamaana i pari karomi, ma i benbeni. ");
INSERT INTO rai_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma i piri taan tamaana naa, ‘Baboi! Mongoro na kilaala iaau aa papaam karom ui welaar ma ra tultul, pa iaau wabulbul u ra num kum wetulaa, ma pa u tabaara ta iaau maku ma ta naatnaat na me lik, kupi miaat a gaaia ungaai mai ma ra kum teptepaang. ");
INSERT INTO rai_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iaku baa natumlik mi ia waan paat, ia baa i baanaakaka wa anum kum utnaa u ra kum aakaina tabuan, u aak doko paa ut a naatnaat na tubutubu na bulumakaau uni.’ ");
INSERT INTO rai_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tamaana i baalui lenbi, ‘Natunglik, ui kuri ut u ki naang, ma anung kum wuwuwung raap, anum ku. ");
INSERT INTO rai_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I koina kupi daat a gaaia ma daat a wangaan, maa temlik bi i maat ma mi ia lalaaun balet, i raara paa, ma mi ia waan paat balet.’” ");
INSERT INTO rai_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu i piri balet taa ra nuna taara na wawer naa, “Raa tadaaru na muaana anuna raa tultul i baboura anuna kum utnaa, ma di takunai baa i pet biaa ku ma ra kum utnaa anu ra nuna tadaaru. ");
INSERT INTO rai_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","I wataa paai, ma i tiri naa, ‘Aawa mi iaau walangoroi un ui? Un timu a wewapua kaapa u ra num pinapaam na binaboura ma un taari taang, maa pa un tena binaboura balet ma anung.’ ");
INSERT INTO rai_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ma a tena binaboura maa i nuki naa, ‘Aawa ma maa ang paami, baa anung tadaaru in rakaan wa iaau ko ra pinapaam mi? Ma pa i tale iaau ma a kinikil, ma iaau wawirwir ku kaai baa ang aaring utnaa. ");
INSERT INTO rai_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Baraa ma ia, iaau aa nuk paa raa utnaa baa ang paami, kupi a taara diat a gaaia pa iaau ut u ra nundiat kum ruma baa di aa lu wa iaau ko ra pinapaam mi.’ ");
INSERT INTO rai_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Io, i wetulaa kup diat raap raaraa baa diat aa dinaau paa ko ra nuna tadaaru. Ma i tiri a mugaana muaana naa, ‘Taiaadi maa u dinaau paai ko ra nung tadaaru?’ ");
INSERT INTO rai_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma i baalui lenbi, ‘100 na ngaalangaala na palaa na wel na oliwa.’ Ma a tultul i piri naa, ‘Anum buk na dinaau bari ia, un paami. Mi ang kutu wa raa kukur ko ra num dinaau. Un ki ma un timu gagaa taa maku 50 uni.’ ");
INSERT INTO rai_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma i tiri bulung raa, ‘Taiaadi maa u dinaau paai?’ Ma i baalui lenbi, ‘100 na bek na wit.’ Ma i piri taana, ‘Anum buk na dinaau bari ia, un paami. Mi ang kutu wa raa kukur ko ra num dinaau. Un timu taa maku 80 uni.’ ");
INSERT INTO rai_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Anuna tadaaru i nunurai naa a aakaina tultul mi pa i lingtatuna u ra nuna pinapaam, iaku i pir walaawa paai kabina u ra nuna manaana baa i paam a warwaruga mi mai. Maa a taara nu ra rakrakaan buaal, diat manaana aakit u ra nundiat pinapaam taa ra taara nu ra kaapa. ");
INSERT INTO rai_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iaau piri taa muaat, muaat a wamaraam paa ta kum teptepaamuaat ma ra wuwuwung taanga u ra rakrakaan buaal, baa muaat paam akotoi, kupi baa ia raap, God in gaaia pa muaat u ra kum ruma baa diat a tur takum ma pa in raap. ");
INSERT INTO rai_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ia baa i dowot u ra kinalik na utnaa ku, in dowot kaai u ra kum ngaala na utnaa, ma ia baa pa i dowot u ra kinalik na utnaa, pa in dowot kaai u ra kum ngaala na utnaa. ");
INSERT INTO rai_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Baa pa muaat dowot kupi muaat a baboura wakaak a kum utnaa taanga napia, woi in nurnur un muaat kupi muaat a baboura a kum utnaa taanginaanga nate? ");
INSERT INTO rai_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Baa pa muaat dowot un ta utnaa anun te, woi balet maa in taar taa anumuaat utnaa ut taa muaat? ");
INSERT INTO rai_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pa in tale ta tultul in papaam karom ta ru mukmuga. In nget raa paan diaar, ma in gaaia kup raa paan diaar, in taraam karom raa ma raa in wabulbul karomi. Pa muaat a papaam laar paai karom God ma karom a maani kaai.” ");
INSERT INTO rai_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A kum Parisaaio diat walangoro a kum pirpir mi, io, diat tataur ku un Iesu, maa kabina diat a kum tena maari baat a maani. ");
INSERT INTO rai_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma Iesu i piri taan diat, “Muaat, muaat watakado pa muaat ku namataa ra taara. Iaku God i nunura a balaamuaat. Maa a utnaa baa i ngaatngaat aakit namataa ra taara i milmiluan ku namataan God. ");
INSERT INTO rai_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“A kum Naagagon ma ra kum wawer anu ra kum propet i tuk taau ut un Ioaanes. Turpaai u ra pakaana bung maa, di warawaai u ra Koina Wewapua u ra mataanitu anun God ma a taara raap diat gotgot kupi diat a ruk uni. ");
INSERT INTO rai_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A baakut ma a rakrakaan buaal pa i dekdek baa diaar a panaai, iaku pa ta mataana buk lik in panaai ko ra kum Naagagon. ");
INSERT INTO rai_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Baa te i lu wa anuna tabuan ma i taulaa balet ma ta tabuan, a muaana maa i paam aakaina. Ma ia baa i taulaa ma ta tabuan baa anuna muaana i lu wai, ia kaai ia paam aakaina kabina maa a tabuan maa i taulaa ut. ");
INSERT INTO rai_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Raa tadaaru na muaana, i mongmong ma ra kum kokoina maalu, ma i paampaam balaan a bungbung raap. ");
INSERT INTO rai_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Di wainep taa raa muaana a tena aaring utnaa nabonanaaka naana, a iaana Laasaro, i manmanua a panpanina. ");
INSERT INTO rai_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I nemi kupi in aanaan a kum mutamuta na utnaa baa diat pukpuka paa ko ra luwu na winangaan anu ra tadaaru maa. Ma a kum paap diat daamdaam kaai a kum manmanua u ra panpanina. ");
INSERT INTO rai_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Namur a tena aaring utnaa maa i maat, ma a kum aangelo diat lo paai ma diat waki taai naan Aabaraam. Ma a tadaaru na muaana bulung maa i maat, ma di punang wai. ");
INSERT INTO rai_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma ia ki u ra ngaala na nguan. I ngungut aakit a panina ma i tataada unaanga nate, i babo Aabaraam i welwelik aakit, ma Laasaro kaai u ra papaarina. ");
INSERT INTO rai_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma i wewataai lenbi, ‘Tamaang Aabaraam, un maari iaau, un tula wa Laasaro kupi in tuk paa ta lik palaa lik ma in kaalkaali na limaana kupi in wamadiring taa in kaarmeng mai, maa iaau kariaana a ngaala na ngunungut aakit main u ra nguan.’ ");
INSERT INTO rai_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aabaraam i piri taana naa, ‘Natunglik, un nuk paai, baa u lalaaun utbaai, u paam akoto anum kum kokoina utnaa, ma lenkaai maa karom Laasaro, i paam akoto a kum aakaina utnaa. Io, mi i paam akoto a gaaia main, ma ui, u kariaana a ngaala na ngunungut aakit. ");
INSERT INTO rai_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bari kaai ia, raa ngaala na tung kuri naliwan taan daat. Pa te taanga main in pet laar paai kupi in waan utira karom muaat, ma pa te kaai in waan taanga matira kon muaat urin karom miaat.’ ");
INSERT INTO rai_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma a tadaaru maa i piri lenbi, ‘Tamaang, iaau aaring ui kupi un tula wa Laasaro kup a ruma anun tamaang. ");
INSERT INTO rai_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Lima na tateng liklik a kum muaana kuraa diat matira, ma in watumaarang ta diat, kaduk diat bulung diat a waan urin u ra taamaan na ngunungut bi.’ ");
INSERT INTO rai_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma Aabaraam i baalui lenbi, ‘A pirpir anun Moses ma ra kum propet kuraa i ki karom diat. I koina baa diat a walangoroi.’ ");
INSERT INTO rai_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A tadaaru maa i piri naa, ‘Pate, Tamaang Aabaraam, baa te ut ko ra minaat in waan paat karom diat, io, diat a nukpuku.’ ");
INSERT INTO rai_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma Aabaraam i baalui balet naa, ‘Baa pa diat walangoro Moses ma ra kum propet, pain te kaai baa i tur balet ko ra minaat in aal atur laar paa anundiat nurnur.’” ");
INSERT INTO rai_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu i piri taa ra nuna taara na wawer lenbi, “A kum utnaa in waan paat ut, baa in pet taa a taara kup diat a puka u ra aakaina, iaku in aaka aakit karom ia baa i paam apaat paa a kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A naagagon karom te baa i ben araara raa kon diat a kum kinalik in aaka aakit taan te baa din kubu taa ina ngaala na waat u ra in kabarono, ma din ong amurung wai nataai. ");
INSERT INTO rai_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Muaat a baboura muaat! Baa temlik i paam aakaina, un pirpir dekdek karomi, ma baa ia nukpuku, un dumaana wa anuna niraara. ");
INSERT INTO rai_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Baa i paam aakaina karom ui 7 na pakaan un raa bung, ma i waan karom ui 7 na pakaan ma i piri taam naa, ‘Iaau aa paam aakaina karom ui. Mi iaau nukpuku.’ Io, un dumaana wa nuna niraara.” ");
INSERT INTO rai_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A kum aapostolo diat piri taa ra Tadaaru, “Un wangaala paa anumiaat nurnur.” ");
INSERT INTO rai_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma a Tadaaru i piri naa, “Baa anumuaat nurnur i kinalik welaar ma ina waina maastad, i tale muaat a piri taa ra in diwaai bi naa, ‘Un tarigaat, ma un tur uaa nataai!’ in taraam ku taa muaat. ");
INSERT INTO rai_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Baa te kon muaat anuna tultul i umtung paa, baa i baboura taa duk a kum sip, baa i waan paat taanga nabuaal, lelawaai, un piri maut taa ra num tultul naa, ‘Un waan urin, un ki ma un wangaan’? Pate. ");
INSERT INTO rai_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Un piri lenbi taana naa, ‘Un waninaar angaang utnaa na winangaan, ma un waninaar kupi un taraamlu iaau, baa ang wangaan ma ang inim. Ma namur ui bulung un wangaan ma un inim.’ ");
INSERT INTO rai_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Lelawaai a tadaaru in pir walaawa paa duk a tultul baa i taraam karomi? Pate, pa in pir walaawa paai, kabina i paam ot paa ku anuna pinapaam. ");
INSERT INTO rai_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lenkaai maa karom muaat, baa muaat aa paam ot paa a kum utnaa di taar taai taa muaat, muaat a piri naa, ‘Miaat a kum tultul biaa ku, miaat paam ot paa ku anumiaat pinapaam.’” ");
INSERT INTO rai_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Baa Iesu i waan waanwaan unaanga Ierusalem, i waan naliwan taa ra ru papaar Samaaria ma Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","I ruk un raa taamaan, diat wetarom taau ma 10 muaana baa diat wukawuka. Diat tur welwelik taau ut, ");
INSERT INTO rai_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma diat kulkulaai dekdek lenbi, “Iesu, ui a Ngaala, un maari miaat.” ");
INSERT INTO rai_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Baa Iesu i babo diat, i piri taan diat naa, “Muaat a waan, muaat a waiaa ta muaat karom a kum tena wetabaar karom God.” Baa diat waan waanwaan, diat laangalaanga maut. ");
INSERT INTO rai_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Raa kon diat baa i baboi naa ia laangalaanga, i waan talili balet, ma i pir walaawa paa God ma ina ngaala na ingaana. ");
INSERT INTO rai_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma i puka pari ma ra urur naa ra ru kakin Iesu ma i waatung wakaak karomi. A muaana maa a te Samaaria. ");
INSERT INTO rai_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu i tiri naa, “Pa di walaangalaanga pa muaat a 10 raap? 9 kaai kuraa ma diat awaai? ");
INSERT INTO rai_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","I lawaai maa pa te i waan talili kupi in pir walaawa paa God, iaku a waira lik ku bi?” ");
INSERT INTO rai_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma i piri taana, “Un tur, ma un waan. Anum nurnur ia walaangalaanga pa ui.” ");
INSERT INTO rai_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Raa kum Parisaaio diat tiri Iesu naa unaangaian a mataanitu anun God in waan paat, ma i baalu diat naa, “A mataanitu anun God pa din baboi baa in waan paat. ");
INSERT INTO rai_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma pa din piri naa, ‘Bari ma ia!’ baa, ‘Baraa ia!’ Maa a mataanitu anun God kuraa ut un muaat.” ");
INSERT INTO rai_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iesu i piri taa ra nuna kum naat na wawer, “A pakaana bung in waan paat baa muaat a nemi kupi muaat a babo ta bung ko ra kum bungbung anu ra Natu ra Muaana, iaku pa muaat a baboi. ");
INSERT INTO rai_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta taara diat a piri taa muaat lenbi, ‘Baboi baraa ma ia!’ baa, ‘Kuri bin!’ Koku muaat murmur diat. ");
INSERT INTO rai_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maa u ra bung na winawaan paat anu ra Natu ra Muaana, a taara raap diat a baboi. In welaar ma in mamame, baa i papalaa taangirong un raa papaara maup, tuk un raa papaar kaai. ");
INSERT INTO rai_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Iaku a Natu ra Muaana in kariaana muga mongoro na ngunungut, ma a taaun taara mi pa diat a nemi. ");
INSERT INTO rai_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“A kum bungbung anu ra Natu ra Muaana in welaar ma ra kum bungbung anun Noaa. ");
INSERT INTO rai_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Diat wangwangaan, diat ininim, ma diat wataulaa diat, tuk u ra bung baa Noaa i kaa u ra paraau, ma ina baata i waan paat ma diat wirua raap. ");
INSERT INTO rai_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lenkaai maa u ra kum bungbung anun Lot. Diat wangwangaan, ma diat ininim, diat kukul, ma diat wiura, diat maarut utnaa, ma diat paampaam ruma. ");
INSERT INTO rai_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iaku u ra bung baa Lot i waan pari ko ra taamaan Sodom, a nguan ma ra saalfa i puka taanginaanga u ra baakut welaar ma ra ina baata, ma diat wirua raap uni. ");
INSERT INTO rai_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“In lenkaai maa u ra bung baa Natu ra Muaana in waan paat uni. ");
INSERT INTO rai_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","U ra bung maa, baa te i ki nate u ra nuna ruma, koku i waan pari kupi in lo paa anuna kum utnaa taanga naruma. Baa te i ki nabuaal, koku i waan talili balet unataamaan kup ta utnaa. ");
INSERT INTO rai_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muaat a nuk paa a tabuan anun Lot. ");
INSERT INTO rai_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Baa te i nem aakiti naa in maari baat paa anuna lalaaun, in wirua. Ma baa te pa i maari baat anuna lalaaun, io, in lalaaun. ");
INSERT INTO rai_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iaau piri taa muaat, u ra bung na marum maa, baa ta rudi diaar inep un raa baat, din lo paa ku ta paan diaar, ma raa paan diaar painte. ");
INSERT INTO rai_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Baa ta ru tabuan kaai diaar gina wit ungaai, din lo paa ku ta paan diaar, ma raa paan diaar painte.” ");
INSERT INTO rai_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma a kum naat na wawer diat tiri naa, “Tadaaru, a kum utnaa mi in waan paat awaai?” Ma i piri taan diat, “A wanua baa a minaat i inep iaai, a kum kotkot diat waan ungaai iaai.” ");
INSERT INTO rai_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu i pir a pirpir welwelaar karom anuna kum naat na wawer kupi in wer diat mai, naa diat a aaraaring liklik ma koku diat talanguan. ");
INSERT INTO rai_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I piri naa, “Raa tena naagagon i ki un raa taamaan, pa i burut kup God, ma pa i nuk paa a taara. ");
INSERT INTO rai_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Raa walaa na tabuan taanga u ra taamaan maa, i waan liklik ku karomi, ma i laana aaringi naa, ‘Un wakado ta iaau ko ra nung ebaar.’ ");
INSERT INTO rai_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ia iwan ma pa i taraam karomi, ma namur i nuki naa, ‘Pa iaau burut kup God, ma pa iaau laana nuk paa a taara, ");
INSERT INTO rai_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","iaku, kabina baa a walaa na tabuan mi i watakida liklik iaau, koina ang baboi kup anuna takado, kaduk in watalanguan iaau ma ra nuna winawaan paat liklik urin.’” ");
INSERT INTO rai_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A Tadaaru i piri taan diat, “Muaat a walangoro a pirpir bi anu ra aakaina tena naagagon baa pa i dowot u ra nuna pinapaam. ");
INSERT INTO rai_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lelawaai, God pa in wakado anuna taara na pipilak, baa diat taangi karomi u ra mage ma ra marum kaai? Lelawaai in bilbiling ma ra warwakado karom diat? ");
INSERT INTO rai_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iaau piri taa muaat, in wakado gagaa diat. Iaku baa Natu ra Muaana in waan paat, lelawaai in baraata paa ut ta taara baa diat nurnur uni main napia?” ");
INSERT INTO rai_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesu i pir a pirpir welwelaar mi karom diat baa diat nurnur paa ut un diat, naa diat a kum tena takado, ma diat nuk akinalik paa a taara raap. ");
INSERT INTO rai_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Raa ru muaana diaar waan unaanga u ra ruma na wetabaar kupi diaar a aaraaring. Raa paan diaar a Parisaaio, ma raa paan diaar kaai a tena lolo tatakom. ");
INSERT INTO rai_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Parisaaio i tur ma i aaraaring ut uni lenbi, ‘God, iaau waatung wakaak karom ui maa pa iaau welaar ma ra taara raap, a kum tena walong, a kum tena pet biaa, ma a kum muaana baa diat paam aakaina u ra in tabuan, ma pa iaau welaar kaai ma ra tena lolo tatakom bari ia. ");
INSERT INTO rai_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iaau laana wawel ru bung kon raa wik, ma iaau laana taar raaraa kon raa noina ko ra kum utnaa iaau paam apaat paai.’ ");
INSERT INTO rai_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ma a tena lolo tatakom i tur ingen taau, pa i tataada unaanga nate u ra maawa, maa i wawirwir. I raapu ku a raprabono ma ra tapunuk, ma i piri naa, ‘God, un maari iaau, iaau a tena aakaina.’ ");
INSERT INTO rai_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iaau piri taa muaat, a muaana mi baa i waan talili balet kup anuna ruma, ia takado namataan God, ma raa paan diaar pate. Maa ia baa i wangaala paai din wakinalik paai, ma ia baa i wakinalik paai, din wangaala paai.” ");
INSERT INTO rai_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A taara diat lo a kum naat liklik karom Iesu kupi in ung a ru limaana nate un diat. Baa anuna kum naat na wawer diat baboi lenmaa, diat turbaat diat. ");
INSERT INTO rai_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iaku Iesu i wataa paa a kum naat liklik karomi, ma i piri lenbi, “Muaat a maadek wa a kum naat liklik baa diat a waan karom iaau. Koku muaat turbaat diat, maa a mataanitu anun God anundiat baa diat lenbi. ");
INSERT INTO rai_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iaau pir a lingtatuna taa muaat, baa te pa in ruk u ra mataanitu anun God welaar ma ra naatlik, pa in ruk laar paai.” ");
INSERT INTO rai_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Raa mukmuga i tiri Iesu naa, “Koina Tena Wawer, aawa maa ang paami kupi ang kale a lalaaun takum?” ");
INSERT INTO rai_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu i baalui naa, “Aawa kabina maa u waatung iaau naa iaau koina? Pa te i koina, God ku. ");
INSERT INTO rai_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U nunura a kum Naagagon: ‘Koku u paam aakaina un ta tabuan anun te, koku u aak doko te, koku u walong, koku u wetakun warwaruga, un urur karom tamaam ma naam.’” Pin 20:12-16 ");
INSERT INTO rai_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A muaana maa i baalui naa, “Turpaai baa iaau naat utbaai tuk mi, iaau tartaraam u ra kum Naagagon raap mi.” ");
INSERT INTO rai_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Baa Iesu i walangoroi, i piri taana, “Raa utnaa utbaai u iba kupi. Un wiura wa anum kum utnaa raap, ma ra maani koni un tabaara a kum iba na taara mai. Baa un paami lenmaa anum a koina wuwuwung inaanga u ra maawa. Namur un waan urin ma un murmur iaau.” ");
INSERT INTO rai_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Baa i walangoro a pirpir mi i tapunuk aakit, maa i tadaaru aakit. ");
INSERT INTO rai_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu i baboi ma i piri lenbi, “I dekdek aakit karom a kum tadaaru na taara kupi diat a ruk u ra mataanitu anun God! ");
INSERT INTO rai_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","I dekdek karom a kaamel kupi in ruk u ra maata na nil na ingingit, iaku i dekdek aakit karom a tadaaru na muaana kupi in ruk u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Baa diat walangoro a pirpir mi, diat wetiri lenbi, “Baa lenmaa, woi ma maa din walaauni?” ");
INSERT INTO rai_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu i baalu diat, “A utnaa baa a taara pain diat a pet laar paai, God in pet laar paai.” ");
INSERT INTO rai_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petero i piri taana naa, “Baboi, miaat aa waan ko ra numiaat kum utnaa raap, ma miaat murmur ui.” ");
INSERT INTO rai_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu i piri taan diat naa, “Iaau pir a lingtatuna taa muaat, baa te i waan ko ra nuna ruma, baa ko ra nuna tabuan, baa a kum tatena liklik, baa kon naana, baa tamaana, baa a kum natnatuna, kabina u ra mataanitu anun God, ");
INSERT INTO rai_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","u ra lalaaun main in paam akoto mongoro aakit ko ra taara ma ra utnaa ia waan paa koni. Ma u ra lalaaun namur din tabaarai ma ra lalaaun takum.” ");
INSERT INTO rai_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu i ben ingen paa anuna 12 naat na wawer, ma i piri taan diat lenbi, “Baboi, mi daat waan unaanga Ierusalem, ma din paam ot paa a kum utnaa raap baa a kum propet diat aa timu taai u ra Natu ra Muaana. ");
INSERT INTO rai_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Maa din taar taai karom diat baa wakir a taara Iudaia. Diat a tataur uni, diat a pir aakakai, diat a kamiai, diat a raapui, ma diat a aak dokoi. ");
INSERT INTO rai_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma u ra wetula bung in lalaaun paat balet.” ");
INSERT INTO rai_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A kum naat na wawer pa diat kaapa u ra kum utnaa raap mi. A kukuraaina i wawalipa kon diat, ma pa diat nunura aawa maa Iesu i pirpir uni. ");
INSERT INTO rai_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Baa Iesu i waan marawaai Ieriko, raa muaana a pula i kiki u ra papaara aakapi, i aaraaring utnaa. ");
INSERT INTO rai_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Baa i walangoro a kor na taara diat waan waanwaan marawaai, i wetiri naa, “Aawa baa?” ");
INSERT INTO rai_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma diat wapuai naa, “Iesu a te Naasaret mi i waan aakit daat.” ");
INSERT INTO rai_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma i kulkulaai naa, “Iesu, Natun Dewid, un maari iaau.” ");
INSERT INTO rai_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma diat baa diat muga diat turbaati naa koku i ge. Iaku i wewataai dekdek bakaai ma naa, “Natun Dewid, un maari iaau.” ");
INSERT INTO rai_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu i tur, ma i wetulaa baa din ben paai karomi. Ma baa ia waan marawaai karomi, i tiri naa, ");
INSERT INTO rai_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aawa maa u nemi naa ang paami un ui?” I baalui naa, “Tadaaru, iaau nemi naa ang babo.” ");
INSERT INTO rai_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma Iesu i piri taana, “Un babo! Anum nurnur ia walaangalaanga pa ui.” ");
INSERT INTO rai_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","I babo gagaa maut, i murmur Iesu, ma i pir walaawa paa God. Ma a taara raap kaai baa diat baboi, diat pir walaawa paa God. ");
INSERT INTO rai_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu i ruk irong Ieriko, kupi in waan unaanga Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma raa muaana i ki matira, a iaana Saakaio, a mukmuga anu ra kum tena lolo tatakom, ma i tadaaru aakit. ");
INSERT INTO rai_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I nemi naa in babo Iesu, iaku maa Saakaio a kukur ra muaana ku, ma pa i pet laar paai kupi in baboi, kabina u ra kor na taara. ");
INSERT INTO rai_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Io, i welulu urong namuga, ma i kaa tato u ra in diwaai, kupi in babo Iesu baa in waan aakit u ra aakapi maa. ");
INSERT INTO rai_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Baa Iesu i waan paat matira, i tataada unaanga nate u ra in diwaai, ma i piri taana naa, “Saakaio, un pari gagaa urin. Umari ang ki ungaai ma ui u ra num ruma.” ");
INSERT INTO rai_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Io, i pari gagaa, ma i ben paa Iesu u ra nuna ruma ma ra gaaia. ");
INSERT INTO rai_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Baa a taara raap diat baboi, diat pirurai naa, “A muaana mi i waan kupi in ki ungaai ma ra tena aakaina u ra nuna ruma.” ");
INSERT INTO rai_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saakaio i tur ma i piri taa ra Tadaaru lenbi, “Baboi, Tadaaru, raa kukur u ra nung utnaa na wuwuwung ang tabaara a kum iba na taara mai, ma baa iaau aa waruga paa ta utnaa kon te, ang baalui balet ta waat na pakaan.” ");
INSERT INTO rai_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Iesu i piri taan Saakaio lenbi, “Mari ut, a warwalaaun ia ki karom diat baa diat ki u ra ruma mi, maa Saakaio kaai ko ra wuna taara anun Aabaraam. ");
INSERT INTO rai_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Maa Natu ra Muaana i waan paat kupi in baat kup diat baa diat raara ma in walaaun pa diat.” ");
INSERT INTO rai_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A taara diat walangoro a kum pirpir mi, ma diat nuki naa a mataanitu anun God in waan paat gagaa, kabina maa Iesu ia marawaai Ierusalem. Io, i pir kaai raa pirpir welwelaar ");
INSERT INTO rai_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","lenbi, “Raa mukmuga i waninaar kupi in waan kup raa taamaan i ki welwelik, kupi din mulaaot taai baa in king, ma namur in waan talili balet. ");
INSERT INTO rai_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Namuga taa ra nuna winawaan, i wataa paa anuna noina tultul karomi, ma i taar taa raaraa kukur ra maani taan diat, ma i piri naa, ‘Muaat a papaam na wawatur mai tuk u ra bung baa ang waan talili balet uni.’ ");
INSERT INTO rai_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma a taara ko ra nuna taamaan diat milikuaanai, ma diat tula wa raa taara kupi diat a murmuri, ma diat piri naa, ‘Pa miaat nem a muaana mi kupi in king anumiaat.’ ");
INSERT INTO rai_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Baa di aa waki taai kupi in king, i waan talili balet. I wetulaa kup anuna kum tultul baa i taar taa a maani taan diat, kupi in manaana baa aawa ia waan paat u ra nundiat pinapaam na wawatur. ");
INSERT INTO rai_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ma a mugaana i waan karomi ma i piri naa, ‘Tadaaru, anum maani ia noina a wawatur uni.’ ");
INSERT INTO rai_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A tadaaru i piri taana lenbi, ‘Wakaak aakit, ui a koina tultul! Ang ung ta ui kupi un naagagon ta noina ngaalangaala na taamaan, kabina maa u dowot u ra kinalik na utnaa.’ ");
INSERT INTO rai_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ma a werudi i waan karomi ma i piri naa, ‘Tadaaru, anum maani ia limadi a wawatur uni.’ ");
INSERT INTO rai_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma a tadaaru i piri taana naa, ‘Ui kaai un naagagon ta lima na ngaalangaala na taamaan.’ ");
INSERT INTO rai_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ma raa bulung i waan karomi ma i piri taana naa, ‘Tadaaru, anum maani bari balet ma ia, iaau pulu taai ma ra ina maalu ma iaau ung ino wakaak taai, ");
INSERT INTO rai_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kabina iaau burutaana ui, maa ui a dekdek na muaana. U lo a utnaa baa wakir anum, ma u tangaa paa a utnaa baa pa u maarut taai.’ ");
INSERT INTO rai_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A tadaaru i piri taana lenbi, ‘Ui a aakaina tultul, ang naagagon ui welaar ma ra num pirpir ut. U aa nunurai naa iaau a dekdek na muaana. Iaau lo paa a utnaa baa wakir anung, ma iaau tangaa a utnaa baa pa iaau maarut taai. ");
INSERT INTO rai_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","I lawaai maa pa u ung taa anung maani u ra beng kupi baa ang waan paat, ang lo paa anung maani ma ta wawaturina kaai?’ ");
INSERT INTO rai_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ma i piri taan diat baa diat tur matira naa, ‘Muaat a lo wa a maani koni, ma muaat a taar taai karom ia baa anuna raa noina.’ ");
INSERT INTO rai_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ma diat piri taana naa, ‘Tadaaru, i lawaai maa din taari balet ku karom ia baa anuna raa noina maani?’ ");
INSERT INTO rai_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","I baalu diat naa, ‘Iaau piri taa muaat, ia baa i paam akoto a ngaala, din tabaarai balet ma ra ngaala. Ma ia baa pa i paam akoto ta utnaa, din rakaan wa utkaai anuna kinalik na utnaa koni. ");
INSERT INTO rai_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma muaat a ben paa anung kum ebaar baa pa diat nemi kupi ang king anundiat, ma muaat a aak doko diat bain ut namataang.’” ");
INSERT INTO rai_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Baa Iesu ia pir wa a pirpir welwelaar mi, i muga pa diat balet unaanga Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Baa i waan paat Betpaage ma Betaania u ra taangaai di waatungi ma a Taangaai na Oliwa, i tula wa rudi ko ra kum naat na wawer, ma ra pirpir lenbi, ");
INSERT INTO rai_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mur a waan kup a taamaan kuraa namuga taa mur. Baa mur a waan ruk, mur a waan taau un raa naat na dongki kuraa di do koto taai, ma pa te utbaai i ki paa uni. Mur a palaa paai ma mur a beni urin. ");
INSERT INTO rai_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Baa te in tiri mur naa, ‘Aawa maa mur palaai kupi?’ mur a piri naa, ‘A Tadaaru i nemi.’” ");
INSERT INTO rai_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Diaar waan ma diaar baraata paa a kum utnaa raap baa Iesu ia pir taai taan diaar. ");
INSERT INTO rai_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Io, baa diaar palpalaa a naat na dongki diat baa anundiat, diat tiri diaar naa, “Aawa maa mur palaa a naat na dongki maa kupi?” ");
INSERT INTO rai_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Diaar baalu diat naa, “A Tadaaru i nemi.” ");
INSERT INTO rai_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma diaar ben taa a naat na dongki karom Iesu, ma diaar rakaan wa ruina maalu baa diaar burung baat anundiaar minong mai, diaar ungi nate u ra naat na dongki ma diaar waki taa Iesu uni. ");
INSERT INTO rai_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Baa i waan waanwaan, raa taara diat rakaan wa anundiat kum maalu baa diat burburung baat anundiat kum minong mai, ma diat laangun taai u ra aakapi. ");
INSERT INTO rai_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Baa ia marawaai u ra waanwaan pari u ra Taangaai na Oliwa, a ngaala na gaaia i lo a taara na wawer raap ma diat pir walaawa paa God ma ra ngaala na ingaandiat u ra kum utnaa na kakaian baa diat aa baboi, ma diat kulkulaai lenbi, ");
INSERT INTO rai_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Daat a pir walaawa paa a King baa i waan paat u ra iaa ra Tadaaru! Kele 118:26 A maalmaal inaanga u ra maawa, ma a pir walaawa unaanga karom God!” ");
INSERT INTO rai_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Raa kum Parisaaio naliwan u ra kor na taara diat piri naa, “Tena Wawer, un turbaat anum taara na wawer.” ");
INSERT INTO rai_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Iesu i baalu diat lenbi, “Iaau piri taa muaat, baa a taara mi pa diat a gege ma ra pir walaawa, a kum waat ut diat a kulkulaai.” ");
INSERT INTO rai_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Baa Iesu i marawaai Ierusalem ma i baboi, i taangi uni, ma i piri, ");
INSERT INTO rai_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Iaau nemi naa mari muaat aa nunura a aakapi baa in topaa a maalmaal! Iaku maa pa muaat babo laar paai! ");
INSERT INTO rai_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta bung in waan paat, baa anumuaat kum ebaar diat a tur lili anumuaat taamaan, diat a watur a liplip lilili baat muaat, diat a turbaat anumuaat kum aakapi na niruk ma pinari, ma diat a um muaat ko ra kum papaarina. ");
INSERT INTO rai_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma diat a reng ginagina wa a taamaan, ma diat a aak doko muaat kaai baa muaat ki uni. Ma pa diat a maadek wa ta ruina waat kupi diaar a inep ungaai, maa pa muaat nunura lele a pakaana bung baa God i waan paat uni karom muaat.” ");
INSERT INTO rai_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu i ruk un raa pakaana ko ra ruma na wetabaar, ma i lu pari wa diat baa diat wiura. ");
INSERT INTO rai_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma i piri taan diat naa, “Di aa timu taai u ra Buk Taabu lenbi, ‘Din waatung anung ruma baa a ruma na niaaring.’ Aais 56:7 Iaku muaat aa paam puku paai kupi in welaar maku ma ra ‘ruma anu ra kum tena walong.’” Ier 7:11 ");
INSERT INTO rai_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iesu i wer a taara u ra ruma na wetabaar a bungbung raap. Ma a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon ma ra kum mukmuga anu ra taara, diat nuknuk kup ta aakapi baa diat a aak dokoi uni. ");
INSERT INTO rai_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Iaku diat gaana nuknuk taau kup ta utnaa baa diat a paami, kabina maa a ngaala na kor na taara diat walangoro a pirpir anun Iesu, ma diat nem aakiti. ");
INSERT INTO rai_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Raa bung baa Iesu i wer a taara u ra ruma na wetabaar, ma i warawaai ma ra Koina Wewapua, a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon, ma a kum mukmuga diat waan karomi. ");
INSERT INTO rai_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma diat piri taana naa, “Un wapua miaat, woi na mangaana naagagon maa u paam a kum utnaa mai mi? Woi maa i taar taa a naagagon mi taam?” ");
INSERT INTO rai_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu i baalu diat naa, “Iaau kaai ang tiri muaat ma raa wetiri. Muaat a wapua iaau. ");
INSERT INTO rai_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Taangawaai a baapitaaiso anun Ioaanes? Taanginaanga u ra maawa, baa ko ra taara ku?” ");
INSERT INTO rai_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma diat pirpir ino paa lenbi, “Baa daat a piri naa, ‘Taanginaanga u ra maawa,’ in baalu daat ku naa, ‘Io, i lawaai maa pa muaat nurnur uni?’ ");
INSERT INTO rai_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iaku baa daat a piri naa, ‘Ko ra taara,’ a taara raap diat a duka doko daat, maa diat nurnur un Ioaanes naa ia a propet.” ");
INSERT INTO rai_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Io, diat baalui ku naa, “Pa miaat nunurai baa taangawaai.” ");
INSERT INTO rai_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Iesu i piri taan diat naa, “Iaau kaai pang wapua muaat u ra naagagon iaau laana paam a kum utnaa mai mi.” ");
INSERT INTO rai_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu i pir a pirpir welwelaar mi taa ra taara, “Raa muaana i maarut taa a wanua na waain, ma namur i taar taai kumun taan raa taara na pinapaam kupi diat a babourai, ma i waan kup raa taamaan ingen, ma i ki iwan paa matira. ");
INSERT INTO rai_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Baa a kalaang ia ot kupi din git ungaai a waina waain, i tula wa raa tultul karom a taara na pinapaam, kup ta wai ra nuna pinapaam kupi anuna kaai. Ma a taara na pinapaam diat umi, ma diat tula talili biaa wai ku. ");
INSERT INTO rai_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I tula wa balet raa tultul karom diat, ma diat umi balet ku, diat baana wawirwir taai, ma diat tula talili biaa wai ku. ");
INSERT INTO rai_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Namur i tula wa balet a wetula tultul, ma diat um aakaka taai, ma diat lu ingen wai. ");
INSERT INTO rai_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ma a tamaa ra wanua na waain i piri naa, ‘Aawa ma duk maa ang paami? Ang tula wa natunglik, a naat na wakwakaak, naapi diat a urur duk uni.’ ");
INSERT INTO rai_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Iaku baa a taara na pinapaam diat babo paai, diat pirpir ungaai paa naa, ‘Ia ma baa in kiaana tamaana, bari ma ia i waan urin. Muaat iaap, daat a aak dokoi, kupi anundaat ma a wanua na waain.’ ");
INSERT INTO rai_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Io, diat ong apari wai ko ra wanua na waain, ma diat aak doko wai. “Aawa maa a tamaa ra wanua na waain maa in paami un diat? ");
INSERT INTO rai_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In waan paat ma in aak doko wa a taara na pinapaam, ma in taar taa a wanua na waain karom ta taara ingen.” Baa diat walangoro a pirpir mi, diat piri naa, “Painte maut!” ");
INSERT INTO rai_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ma Iesu i babo diat, ma i piri naa, “Aawa maa a kukuraai ra pirpir mi di aa timu taai u ra Buk Taabu? ‘Ina waat baa a kum tena paam ruma diat pilak wai, ia ut maa ina ngaatngaat na waat baa di paam a ruma mai.’ Kele 118:22 ");
INSERT INTO rai_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Diat raap baa diat puka taau u ra ina waat mi, diat a taginagina, ma te baa ina waat mi in puka dadaaun paai, in taginagina welaar ma ra kabu.” ");
INSERT INTO rai_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A kum tena wawer u ra kum Naagagon ma a kum ngaala na tena wetabaar karom God diat baat kup ta aakapi kup diat a paam akoto paa Iesu u ra pakaana bung maa, kabina maa diat nunurai naa i pir ku a pirpir welwelaar mi un diat. Iaku maa diat burutaana a taara. ");
INSERT INTO rai_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A kum tena wawer u ra kum Naagagon ma a kum ngaala na tena wetabaar karom God diat babo ururai, ma diat tula wa a kum tena wawagu ma diat warwaruga naa diat a kum dowot na taara. Ma diat ki na wawagu kup ta pirpir baa in pir taai baa diat a takunai mai, kupi diat a taar taai u ra naagagon ma u ra dekdek i ra mukmuga ko ra mataanitu Rom. ");
INSERT INTO rai_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma diat piri naa, “Tena Wawer, miaat nunurai naa i takado anum pirpir ma anum wawer. I welaar raap ku karom a taara raap, ma u wer mulu diat u ra aakapi anun God ma ra lingtatuna. ");
INSERT INTO rai_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Lelawaai, i takado kupi din taar a tatakom karom a Kaaisaar baa pate?” ");
INSERT INTO rai_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu ia nunura wa nundiat warwaruga, ma i piri taan diat naa, ");
INSERT INTO rai_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Muaat a waiaa iaau un ta maani. A malalar ma ra timtimu mi uni anun woi?” Ma diat baalui naa, “Anu ra Kaaisaar.” ");
INSERT INTO rai_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma i piri taan diat, “A utnaa baa anu ra Kaaisaar muaat a taari karom a Kaaisaar, ma ra utnaa baa anun God muaat a taari kaai karom God.” ");
INSERT INTO rai_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma pa diat wagu laar paai namataa ra taara ma ra pirpir maa. Diat kakaian u ra nuna pirpir na binabaalu, ma diat ki wowowon taau maku. ");
INSERT INTO rai_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Raa kum Saadukaaio, baa diat weoro ku naa pa ta lalaaun balet ko ra minaat, diat waan karom Iesu, ma diat tiri naa, ");
INSERT INTO rai_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tena Wawer, Moses i timu taai taan daat lenbi, baa ta muaana in maat paa ko ra nuna tabuan, ma pa ta natundiaar, io, tenalik in ben paai ma in taulaa mai, kupi in wangaala taa ta kum naat liklik u ra iaan tenalik baa ia maat. ");
INSERT INTO rai_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Io, raa naadiwaaina, 7 na muaana raap ku. A mugaana i taulaa, ma i maat ko ra nuna tabuan, ma pa ta natundiaar. ");
INSERT INTO rai_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma a weru tenalik bulung i taulaa ma ra tabuan maa, ma ia bulung i maat ku ko ra tabuan maa. ");
INSERT INTO rai_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Namur a wetuldi bulung. Lenmaa karom 7 diat raap. Diat taulaa paa mai, ma diat maat raap ku, iaku a tabuan maa pa i buta taa ta naat un diat. ");
INSERT INTO rai_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma a tabuan i maat namur taan diat raap. ");
INSERT INTO rai_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Io, u ra lalaaun balet ko ra minaat, anun woi na paan diat mulu a tabuan maa? Maa 7 diat raap diat aa taulaa paa mai.” ");
INSERT INTO rai_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu i piri taan diat naa, “A taara ko ra kum kilaala mi diat tautaulaa, ");
INSERT INTO rai_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","iaku a taara baa diat takado kupi diat a tur balet ko ra minaat, ma diat a lalaaun u ra lalaaun namur, pa diat a taulaa balet. ");
INSERT INTO rai_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma pa diat a maat balet, maa diat welaar maku ma ra kum aangelo. Diat a kum natun God, maa diat aa lalaaun paat ko ra minaat. ");
INSERT INTO rai_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Baa a Buk Taabu i pirpir u ra in diwaai baa i kupkup, Moses i waiaai naa a kum minaat diat lalaaun balet, maa i waatung a Tadaaru naa, ‘A God anun Aabaraam, a God anun Aaisaak ma a God anun Iaakob.’ Pin 3:6 ");
INSERT INTO rai_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God wakir a God anu ra kum minaat, a God anu ra kum lalaaunina ut, maa diat raap diat lalaaun karomi.” ");
INSERT INTO rai_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma raa kum tena wawer u ra kum Naagagon diat piri naa, “Tena Wawer, anum pirpir i koina aakit.” ");
INSERT INTO rai_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma pa diat waan balet ma karomi ma ta wetiri, kabina diat burut. ");
INSERT INTO rai_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu i piri taan diat, “I lawaai maa di piri naa Kaarisito in waan paat ko ra wuna taara anun Dewid? ");
INSERT INTO rai_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maa Dewid ut i piri u ra Kum Kelekele u ra Buk Taabu lenbi, ‘A Tadaaru i piri karom anung Tadaaru, “Un ki u ra papaara ot na limaang ");
INSERT INTO rai_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tuk baa ang uwia paa anum kum ebaar kupi diat a ki natudaangi ra num naagagon.” ’ Kele 110:1 ");
INSERT INTO rai_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewid i waatung Kaarisito naa anuna Tadaaru. Baa lenmaa, io, diaar tamaana lelawaai?” ");
INSERT INTO rai_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Baa a taara raap diat walangoro Iesu, i piri taa ra nuna kum naat na wawer lenbi, ");
INSERT INTO rai_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Muaat a baboura muaat ko ra kum tena wawer u ra kum Naagagon. Diat nemi kupi diat a waanwaan ma ra kum kokoina maalu aakit, ma diat nemi naa a taara diat a taar a ngaala na urur karom diat u ra kum taamaan na winawaan ungaai. Ma diat nem a kinkini namuga u ra kum ruma na lotu, ma ra kinkini na tadaaru namuga u ra kum balaan. ");
INSERT INTO rai_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Diat waraap a wuwuwung anu ra kum walaa na tabuan, ma diat paam a kum iokaana aaraaring kupi a taara diat a babo diat. In ngaala aakit a naagagon na binabaalu anun God karom diat.” ");
INSERT INTO rai_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Baa Iesu i ki u ra ruma na wetabaar, i babo takado, ma i babo a kum tadaaru diat ongong taa anundiat wetabaar u ra wuwuwung na maani. ");
INSERT INTO rai_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma i babo paa kaai raa walaa na tabuan, baa i iba, i ong taa ku ru toiaa. ");
INSERT INTO rai_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Iesu i piri naa, “Iaau pir a lingtatuna taa muaat, a walaa na tabuan mi ia taar taa a ngaala na maani taan diat raap baa diat ong taa anundiat maani u ra wuwuwung na maani. ");
INSERT INTO rai_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Diat taar taa ku a ibaana ko ra nundiat kum maani, ma a walaa na tabuan mi, i iba, iaku ia taar araap wa aawa baa in topaa anuna kini.” ");
INSERT INTO rai_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Raa kum naat na wawer diat piri u ra ruma na wetabaar naa di aa wamong taai ma ra kum koina waat ma ra kum wetabaar baa di taar taai karom God. Ma Iesu i piri naa, ");
INSERT INTO rai_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“A kum utnaa mi baa muaat bababo diat, a bung in waan paat namur baa pa ta ruina waat ma diaar a inep ungaai, din reng ginagina raap wa diat.” ");
INSERT INTO rai_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Diat tiri Iesu naa, “Tena Wawer, unaangaian ma a kum utnaa mi in waan paat? Ma aawa a wakilang i ra kum utnaa mi baa i marawaai kupi diat a waan paat?” ");
INSERT INTO rai_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I baalu diat naa, “Muaat a baboura muaat, kaduk din waruga pa muaat. Maa mongoro diat a waan paat ma ra iaang, diat a piri naa, ‘Iaau maa Kaarisito,’ baa lenbi, ‘A pakaana bung ia marawaai.’ Koku muaat murmur diat. ");
INSERT INTO rai_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Baa muaat a walangoro a kum wineium ma ra kum purpuruan, koku muaat burut, maa a kum utnaa mi diat a waan paat muga, iaku a tintinip na bung pa in waan paat utbaai.” ");
INSERT INTO rai_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iesu i piri taan diat naa, “Raa wuna taara in tur na wineium kup raa wuna taara, ma raa mataanitu in tur na wineium kup raa mataanitu. ");
INSERT INTO rai_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A kum ngaala na guria, ma ra kum minolo ma ra kum mangaana dekdek na malaapaang u ra kum taamtaamaan, ma a kum mangaana utnaa baa in waburut a taara, ma ra kum ngaala na wakilang taanginaanga u ra baakut, diat a waan paat. ");
INSERT INTO rai_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Namuga baa a kum utnaa mi pa diat waan paat utbaai, din aal pa muaat, din wakadik muaat, ma din aal muaat u ra kum ruma na lotu kup a naagagon ma din waruk muaat u ra kum ruma na karabus. Ma din aal pa muaat kup a naagagon namuga naa ra kum king, ma ra kum ngaala na mukmuga, kabina u ra iaang. ");
INSERT INTO rai_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A koina pakaana bung maa kupi muaat a wewapua kaapa un iaau karom diat. ");
INSERT INTO rai_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Namuga taana, koku muaat ngaraa baa aawa maa muaat a baalu ta kum wetakun mai. ");
INSERT INTO rai_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maa iaau ut, ang wanuk taa a pirpir ma ra manaana kaai u ra nuknukimuaat, baa anumuaat kum ebaar raap pa diat a baalu laar paai, ma pa diat a weoro wai. ");
INSERT INTO rai_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A kum tamtamaamuaat ma ra kum nanaamuaat, a kum tateimuaat, a kum kakumuaat, ma ra kum teptepaamuaat, diat a mulaaot wa muaat kupi din aak doko ta taara kon muaat. ");
INSERT INTO rai_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A taara raap diat a milikuaana muaat kabina u ra iaang. ");
INSERT INTO rai_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iaku pain tina weu na lorimuaat in raara. ");
INSERT INTO rai_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Anumuaat tinur dekdek in walaaun muaat. ");
INSERT INTO rai_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Baa muaat babo a kor na taara na wineium diat tur lili paa Ierusalem, muaat a nunurai naa ia marawaai baa din kamaar wai. ");
INSERT INTO rai_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Io, diat baa diat ki u ra papaar Iudaia, diat a kalaa ino unaanga u ra kum taangaai, ma diat baa diat ki u ra taamaan Ierusalem diat a pari, ma diat baa diat ki nabuaal koku balet ma diat ruk. ");
INSERT INTO rai_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Maa a pakaana bung maa, ia a pakaana bung na babaalu kupi din paam ot paa a kum utnaa raap baa di aa timu taai u ra Buk Taabu. ");
INSERT INTO rai_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","U ra pakaana bung maa in aaka aakit karom a kum kipbaala, ma karom diat kaai baa diat wangaau a kum naat. A ngaala na kinadik in waan paat u ra taamaan Israael, ma a kaankaan anun God in manong a taara mi. ");
INSERT INTO rai_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ta taara din aak doko diat ma ra liwan na wineium, ma ta taara din ben pa diat kupi diat a ki na karabus u ra kum taamtaamaan raap. Ma diat baa wakir a taara Iudaia diat a paa dadaaun Ierusalem ma in tuk taau ut u ra bung baa God ia naagagon taai baa anundiat niuwia in raap uni. ");
INSERT INTO rai_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“A kum wakilang inaanga u ra in mataana mage, ma u ra kalaang, ma u ra kum naangnaang in waan paat. Ma min napia a wunwuna taara diat a aaka ma ra bunurut ma ra kum purpuruan na ninunuk u ra karangaap i ra top ma ra ungaina. ");
INSERT INTO rai_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A taara diat a maatmaat taau ma ra bunurut kabina u ra kum utnaa baa in um a rakrakaan buaal, maa a kum utnaa inaanga nate u ra baakut diat a dadader. ");
INSERT INTO rai_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","U ra bung maa diat a babo Natu ra Muaana in waan paat u ra pakaana baakut, ma ra dekdek ma ra ngaala na minamaar. ");
INSERT INTO rai_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Baa a kum utnaa mi in turpaai kupi in waan paat, muaat a tur, ma muaat a tataada, maa a bung baa God in walaaun pa muaat uni ia marawaai.” ");
INSERT INTO rai_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu i pir a pirpir welwelaar mi taan diat lenbi, “Muaat nunura ut in diwaai na fig ma ra kum diwaai raap. ");
INSERT INTO rai_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Baa muaat babo a dondono indiat i kiok paat, muaat nunurai naa a kum kalaang na wuwan ia marawaai. ");
INSERT INTO rai_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lenkaai maa, baa muaat babo a kum utnaa baa iaau pirpir taau uni in waan paat, muaat a nunurai naa a mataanitu anun God ia marawaai. ");
INSERT INTO rai_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iaau pir a lingtatuna taa muaat, a kum utnaa raap mi in waan paat baa a taaun taara mi diat lalaaun utbaai. ");
INSERT INTO rai_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A maawa ma ra rakrakaan buaal diaar a panaai, iaku maa anung kum pirpir pa in panaai. ");
INSERT INTO rai_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Muaat a baboura muaat, kaduk muaat a balbalaan ma ra paam lukaara ma ra ininim, ma ra nginaraa u ra kum utnaa u ra lalaaun main napia, ma a bung maa in waan paat kakaian karom muaat welaar ma ra ina kun. ");
INSERT INTO rai_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maa in waan paat karom a taara raap u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Muaat a baboura muaat u ra kum bungbung raap, muaat a aaraaring kupi muaat a dekdek kupi muaat a aalaap ko ra kum utnaa mi baa marawaai diat a waan paat, ma muaat a aaraaring kaai kupi muaat a pet laar paai baa muaat a tur namataa ra Natu ra Muaana.” ");
INSERT INTO rai_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ma Iesu i wer a taara u ra ruma na wetabaar a bungbung raap, ma u ra kum bung na marum i pari, ma i ki u ra taangaai, a iaana Oliwa. ");
INSERT INTO rai_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma u ra kum bungbung na malaana kinalik, a taara raap diat waan karomi u ra ruma na wetabaar kupi diat a walangoroi. ");
INSERT INTO rai_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Io, ia marawaai a lukaara na bred baa pa ta is uni, di waatungi ma a lukaara na waan likaai. ");
INSERT INTO rai_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma a kum ngaala na tena wetabaar karom God, ma ra kum tena wawer u ra kum Naagagon, diat nuknuk kup ta mangaana aakapi kupi diat a aak doko Iesu uni, maa diat burutaana a taara. ");
INSERT INTO rai_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma Saataan i ruk taau un Iudaas, raa iaana kaai Iskaariot, ia raa ko ra 12 naat na wawer. ");
INSERT INTO rai_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","I waan karom a kum ngaala na tena wetabaar karom God, ma ra kum mukmuga anu ra kum tena baboura u ra ruma na wetabaar, ma diat pirpir ungaai mai baa in wagu lelawaai taa Iesu karom diat. ");
INSERT INTO rai_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Diat gaaia, ma diat piri naa diat a doki ma ra maani. ");
INSERT INTO rai_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Io, Iudaas i mulaaot, ma i nuknuk kup ta koina pakaana bung baa pa ta ngaala na taara, io, in wagu taa Iesu karom diat. ");
INSERT INTO rai_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A bung na lukaara na bred baa pa ta is uni i waan paat, baa di laana aak doko a kum naat na sip uni kup a lukaara na waan likaai. ");
INSERT INTO rai_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma Iesu i tula wa Petero ma Ioaanes ma i piri taan diaar, “Mur a waan ma mur a waninaar andaat utnaa kup a lukaara na waan likaai.” ");
INSERT INTO rai_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma diaar tiri naa, “U nemi naa mir a waninaari awaai?” ");
INSERT INTO rai_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","I baalu diaar naa, “Baa mur a waan paat inaanga Ierusalem, mutul a wetarom ma raa muaana i lo ina ngaala na palaa, ma mur a murmuri u ra ruma baa in ruk uni. ");
INSERT INTO rai_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ma mur a piri taa ra tamaa ra ruma naa, ‘A Tena Wawer i piri naa: Waiaa a kukur ra ruma baa miaat ma ra nung kum naat na wawer, miaat a aan a utnaa na waan likaai iaai?’ ");
INSERT INTO rai_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma in waiaa ta mur u ra ngaala na kukur ra ruma inaanga nate, baa di aa waninaar taai, ma mur a waninaar a utnaa iaai.” ");
INSERT INTO rai_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Io, diaar waan, ma diaar baraata raap paa ut a kum utnaa baa Iesu i pir taai taan diaar. Ma diaar waninaar a utnaa na waan likaai. ");
INSERT INTO rai_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Baa a pakaana bung ia ot, Iesu ma ra kum aapostolo diat ki u ra winangaan. ");
INSERT INTO rai_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma Iesu i piri taan diat naa, “Iaau nem aakiti naa daat a aan a utnaa na waan likaai baa pa iaau kariaana utbaai a kinadik, ");
INSERT INTO rai_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","maa iaau piri taa muaat naa, pang aan balet ta utnaa na waan likaai tuk u ra bung baa din paam ot paai u ra mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iesu i lo paa a kaap ma i waatung wakaak paa uni, ma i piri taan diat, “Muaat a lo paa a kaap bi, ma muaat a inim weraana paai. ");
INSERT INTO rai_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Maa iaau piri taa muaat naa, pang inim balet ma ta waain, tuk ut u ra bung baa a mataanitu anun God in waan paat uni.” ");
INSERT INTO rai_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma i lo paa a bred, i waatung wakaak paa uni, i bik paai, ma i tabaara diat mai. I piri naa, “Bi ia a paning, iaau taar taai un muaat. Muaat a paampaami lenmi, kupi muaat a nuknuk pa iaau balet.” ");
INSERT INTO rai_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lenkaai maa, baa ia raap a winangaan, i lo paa a kaap ma i piri naa, “A kaap mi, a matakina kunubu u ra gaaping baa i talabo un muaat. ");
INSERT INTO rai_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Baboi! A limaan ia baa in wagu ta iaau, kuri mir rarakaan ungaai u ra luwu na winangaan. ");
INSERT INTO rai_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A lingtatuna ut baa Natu ra Muaana in maat welaar ma God ia naagagon taai, iaku in aaka aakit karom a muaana baa i wagu taai.” ");
INSERT INTO rai_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma diat tiri wetwetalaai diat naa, “Woi ma duk kon daat in paam a utnaa mi?” ");
INSERT INTO rai_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Diat weol na pirpir baa woi kon diat di waatungi naa i ngaala aakit. ");
INSERT INTO rai_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Iesu i piri taan diat lenbi, “A kum king anundiat baa wakir a taara Iudaia diat naagagon dekdek diat, ma anundiat kum mukmuga diat nemi naa din waatung diat naa a kum koina tena wewaraaut. ");
INSERT INTO rai_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iaku muaat koku muaat lenmaa. Ia baa i ngaala taa muaat in welaar ku ma ia baa i kinalik, ma ia baa i mukmuga in welaar ku ma raa baa i tartaraam welu. ");
INSERT INTO rai_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Woi maa i ngaala, ia baa i ki u ra winangaan, baa ia i tartaraamlui? Ia ut baa i ki u ra winangaan, naka? Iaku iaau, iaau ki naliwan taa muaat welaar ma ia baa i tartaraam welu. ");
INSERT INTO rai_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Muaat, muaat tur ungaai ma iaau u ra kum mawaat baa i waan paat karom iaau. ");
INSERT INTO rai_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma ang taar taa a kini na naagagon taa muaat welaar ma Tamaang ia taar taai taang, ");
INSERT INTO rai_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kupi daat a wangaan ma daat a inim u ra nung luwu u ra nung mataanitu. Ma muaat a ki u ra kum kiki na king, ma muaat a naagagon a 12 wuna taara Israael.” ");
INSERT INTO rai_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesu i piri naa, “Simon, Simon, baboi, Saataan ia aaring paa kupi in walaar muaat, welaar ma ra tena minamaarut baa i tataanga weraana a wit mulu ko ra panina. ");
INSERT INTO rai_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iaku iaau aa aaraaring un ui, Simon, kupi koku anum nurnur in puka aakit. Baa u aa nukpuku balet, io, un wadekdek a kum tatem liklik.” ");
INSERT INTO rai_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petero i piri taana naa, “Tadaaru, pa iaau burut baa ang murmur ui u ra ruma na karabus ma u ra minaat.” ");
INSERT INTO rai_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Iesu i baalui naa, “Petero, iaau piri taam, umari baa a kareke pa in kurkurekatuk utbaai, un weoro tula pakaan naa pa u nunura iaau.” ");
INSERT INTO rai_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Namur Iesu i tiri anuna kum naat na wawer lenbi, “Baa iaau tula wa muaat, ma pa numuaat ta paaus na ungung maani baa ta kaa baa ta su, lelawaai, muaat iba ut kup ta utnaa?” Ma diat baalui naa, “Pate.” ");
INSERT INTO rai_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma Iesu i piri taan diat, “Iaku mi, ia baa anuna ta paaus na ungung maani, i koina baa in loi ut, ma a kaa kaai. Ma ia baa pa tin liwan na wineium, i koina baa in wiura wa anuna tina maalu ma in kul paa tin. ");
INSERT INTO rai_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iaau piri taa muaat, din paam ot paa a timtimu mi un iaau, ‘Di waatung ungaai diat ma ra kum tena aakaina.’ Aais 53:12 Maa a kum utnaa mi di aa timu taai un iaau, marawaai din paam ot paai.” ");
INSERT INTO rai_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma a kum naat na wawer diat piri naa, “Baboi, Tadaaru, ruin liwan na wineium kuri ut.” Ma Iesu i baalu diat naa, “I ot ku.” ");
INSERT INTO rai_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu i pari ko ra taamaan, ma i waan unaanga u ra Taangaai na Oliwa, welaar ut maa i laana paami. Ma a kum naat na wawer diat murmuri. ");
INSERT INTO rai_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Baa diat waan paat u ra wanua maa, i piri taan diat naa, “Muaat a aaraaring, kupi koku muaat puka u ra walwalaam.” ");
INSERT INTO rai_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I waan ingen kinalik taau kon diat, i ki but keke, ma i aaraaring lenbi, ");
INSERT INTO rai_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamaang, baa u nemi, un lo wa a ngunungut na minaat kon iaau. Iaku koku di murmur anung nemnem, din murmur ut anum nemnem.”  ");
INSERT INTO rai_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma raa aangelo taanginaanga u ra maawa i waan paat karomi, ma i wadekdek taai. ");
INSERT INTO rai_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","I kariaana a dekdek na tapunuk aakit, ma raa ia a kabina baa i ongor aakit ma ra niaaring. Ma a maakmaagon na panina i welaar ma ra tatua na gaap i puka pari unapia. ");
INSERT INTO rai_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","I tur ko ra niaaring, i waan talili karom a kum naat na wawer, ma i babo diat baa diat aa inep duman, maa a panindiat i bengbeng ma ra tapunuk. ");
INSERT INTO rai_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma i piri taan diat naa, “I lawaai maa muaat inep duman ku? Muaat a tur, ma muaat a aaraaring kupi koku muaat puka u ra walwalaam.” ");
INSERT INTO rai_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Baa Iesu i pirpir utbaai, a ngaala na kor na taara diat waan paat. Ma Iudaas, raa ko ra 12 naat na wawer, i muga pa diat. I waan karom Iesu kupi in dum a papaara waana. ");
INSERT INTO rai_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma Iesu i tiri naa, “Iudaas, lelawaai, un wagu taa ma Natu ra Muaana ma ra wedum na maarmaari?” ");
INSERT INTO rai_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma diat baa diat weur ma Iesu diat babo a kum utnaa mi ma diat nunurai naa din aal paa ma Iesu. Diat tiri naa, “Tadaaru, u nemi naa miaat a weium ma ra liwan na wineium?” ");
INSERT INTO rai_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma raa kon diat i pakaat a tultul anu ra mukmuga na tena wetabaar karom God, ma i kutu wa ina ot na talingaana. ");
INSERT INTO rai_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma Iesu i turbaati naa, “Koku!” Ma i paam in talingaa ra tultul, ma i wakoina paai balet. ");
INSERT INTO rai_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iesu i pirpir karom a kum ngaala na tena wetabaar karom God, ma a kum mukmuga anu ra kum tena baboura ko ra ruma na wetabaar, ma a kum mukmuga anu ra taara baa diat waan paat kupi. I piri naa, “Lelawaai, iaau duk a ngaala na tena pet apurpuruan, maa mi muaat waan paat ma ra kum liwan na wineium ma ra kum pakpakaana naalnaal kup iaau? ");
INSERT INTO rai_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","U ra kum bungbung raap daat kiki u ra ruma na wetabaar ma pa muaat paam akoto iaau. Iaku mi anumuaat pakaana bung, baa a dekdek i ra baboto i muga muaat.” ");
INSERT INTO rai_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Diat paam akoto paa Iesu, ma diat ben ingen wai. Diat beni kup a ruma anu ra mukmuga na tena wetabaar karom God. Ma Petero i murmur waanawaana Iesu, iaku maa i welwelik ut. ");
INSERT INTO rai_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baa diat aa wakaa taa a nguan nataamaan, ma diat ki ungaai, Petero kaai diat ut. ");
INSERT INTO rai_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Raa tauraara, a tultul, i babo paai baa i ki taau u ra baarabaara i ra nguan, ma i babo dekdeki, ma i piri naa, “A muaana mi diaar weweur utkaai ma Iesu.” ");
INSERT INTO rai_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Iaku Petero i weoro lenbi, “Neling, pa iaau nunura Iesu.” ");
INSERT INTO rai_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Namur kinalik, raa muaana bulung i babo paa Petero ma i piri naa, “Ui kaai muaat.” Ma Petero i piri, “Toling, iaau pate.” ");
INSERT INTO rai_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Namur kinalik, raa balet i worwor dekdek, i piri lenbi, “A lingtatuna ut, a muaana mi diaar weweur ut ma Iesu, maa ia a te Gaalilaia.” ");
INSERT INTO rai_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petero i baalui naa, “Toling, pa iaau nunura a utnaa maa u pirpir uni.” Baa i pirpir utbaai, a kareke i kurkurekatuk maut. ");
INSERT INTO rai_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Tadaaru i tapuku, i babo takado karom Petero, ma Petero i nuk paa a pirpir anu ra Tadaaru baa ia pir taai taana naa, “Mari, baa a kareke pa in kurkurekatuk utbaai, un weoro kon iaau tula pakaan.” ");
INSERT INTO rai_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma i pari ko ra pakaana maa, ma i taangi dekdek aakit. ");
INSERT INTO rai_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Diat baa diat baboura baat Iesu, diat tataur uni, ma diat raapui. ");
INSERT INTO rai_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Diat pulu baat taa a mataana, ma diat piri taana lenbi, “Ui a propet, un wapua miaat, woi maa i raapu ui!” ");
INSERT INTO rai_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma diat pir aakakai ma mongoro na pirpir utkaai. ");
INSERT INTO rai_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Baa ia keke, a kum mukmuga anu ra taara, a kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon diat waan ungaai. Ma diat ben paa Iesu karom a taara na kiwung maa, ma diat piri taana naa, ");
INSERT INTO rai_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Baa ui Kaarisito, un wapua miaat.” Ma Iesu i baalu diat, “Baa ang wapua muaat, pa muaat a nurnur u ra nung pirpir. ");
INSERT INTO rai_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma baa ang tiri muaat ma ta wetiri, pa muaat a baalui. ");
INSERT INTO rai_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iaku turpaai mari, Natu ra Muaana in ki u ra papaara ot na limaan God, ia baa i dekdek aakit.” ");
INSERT INTO rai_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma diat raap diat tiri Iesu naa, “Ui Natun God naka?” Ma i baalu diat naa, “Muaat aa pir ot paai, iaau ut mi.” ");
INSERT INTO rai_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma diat piri naa, “Daat nem balet ma ta pirpir na wetakun kup aawa? Maa daat aa walangoro taa anuna pirpir mi, baa daat a takunai mai.” ");
INSERT INTO rai_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A taara na kiwung raap diat tur, ma diat ben paa Iesu karom Pilaato. ");
INSERT INTO rai_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma diat turpaai kupi diat a takunai lenbi, “Miaat babo baraata a muaana mi i ben araara anumiaat taara, i turbaat miaat baa koku miaat taar a tatakom karom a Kaaisaar, ma i piri kaai naa ia a Kaarisito baa God i tula wai urin, baa in king.” ");
INSERT INTO rai_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaato i tiri naa, “Ui maa a King anu ra taara Iudaia?” Ma Iesu i baalui naa, “Ma raa ut ia u aa piri.” ");
INSERT INTO rai_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaato i piri taa ra kum ngaala na tena wetabaar karom God ma a kor na taara naa, “Pa iaau tiri baraata ta mangamangaan a muaana mi i raara uni, u ra kum utnaa baa muaat takunai mai.” ");
INSERT INTO rai_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma diat worwor ku, diat piri naa, “I wapurpuruan a taara ma ra nuna wawer u ra papaar Iudaia raap. I turpaai inaanga Gaalilaia ma i tuk min.” ");
INSERT INTO rai_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Baa Pilaato i walangoroi, i tiri diat un Iesu naa, “Ia a te Gaalilaia?” ");
INSERT INTO rai_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Baa ia nunurai naa Iesu taanginaanga u ra papaar Gaalilaia baa Erodes i naagagoni, i tula wai karomi. U ra bung maa Erodes kaai i ki Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Baa Erodes i babo paa Iesu, i gaaia aakit, maa taanga namuga utbaai i nemi kupi in baboi, kabina maa ia walangoro taa a pirpir uni ma i nemi kupi in babo ta utnaa na kakaian baa in paami. ");
INSERT INTO rai_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ma Erodes i tiri Iesu ma ra mongoro na wetiri, iaku Iesu pa i baalui. ");
INSERT INTO rai_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A kum ngaala na tena wetabaar karom God ma ra kum tena wawer u ra kum Naagagon kuraa diat tur matira, diat takuna adekdek Iesu. ");
INSERT INTO rai_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodes ma ra nuna taara na wineium diat papaam na tinataur uni, diat nangonoi, diat wamong taai ma ra in koina maalu aakit, ma diat tula wai balet karom Pilaato. ");
INSERT INTO rai_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Namuga Erodes ma Pilaato diaar ebaar, iaku u ra bung maa diaar wemaraam maraagaam. ");
INSERT INTO rai_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaato i wataa ungaai paa a kum ngaala na tena wetabaar karom God, ma a kum mukmuga, ma ra taara, ");
INSERT INTO rai_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma i piri taan diat, “Muaat aa ben taa a muaana mi karom iaau, welaar ma raa baa i ben araara a taara. Ma mi iaau aa tiri taai namataamuaat, ma pa iaau tiri baraata paa ta mangamangaan a muaana mi i raara uni u ra kum utnaa baa muaat takunai mai. ");
INSERT INTO rai_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Erodes kaai pa i baat paa ta mangamangaan koni, io, i tula wai balet ku karom daat. Baboi, pa i paam taa ta utnaa baa kupi in wirua uni. ");
INSERT INTO rai_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Io, ang raapu tataai ku, ma ang palaa wai.” ");
INSERT INTO rai_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma a taara raap diat baalui ma ra ngaala na ingaandiat lenbi, “A muaana mi in wirua, ma un palaa taa Baaraabaas karom miaat.” ");
INSERT INTO rai_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baaraabaas ia raa muaana baa di waruk taai u ra ruma na karabus kabina maa i weium ma ra mataanitu u ra taamaan Ierusalem, ma i laana aak doko taara kaai. ");
INSERT INTO rai_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaato i nemi ut naa in palaa wa Iesu, io i tiri diat balet. ");
INSERT INTO rai_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Iaku diat ge dekdek ku ma ra pirpir naa, “Aak waati u ra bolo! Aak waati u ra bolo!” ");
INSERT INTO rai_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma i wetula pakaan i tiri diat lenbi, “Aawa kabina? Woi na aakaina utnaa maa ia paam taai? Pa iaau tiri baraata paa ta aakaina mangamangaan baa kupi in wirua uni. Io, ang raapu tataai ku, ma ang palaa wai.” ");
INSERT INTO rai_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Iaku diat worwor ma ra ngaala na ingaandiat kupi din aak waati maku u ra bolo. Ma diat wowo paai ut. ");
INSERT INTO rai_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Io, Pilaato i naagagoni maku kupi din paami welaar ma ra nundiat nemnem. ");
INSERT INTO rai_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma i palaa wa Baaraabaas baa i ki u ra ruma na karabus u ra wineium ma ra aak doko taara, ia baa diat aaring kupi. Io, i taar taa Iesu taa ra kum tena wineium welaar ma ra nemnem anu ra taara. ");
INSERT INTO rai_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Baa diat ben paa Iesu kupi diat a aak waati u ra bolo, diat aal paa raa te Kirene, a iaana Simon, baa i waan kon raa taamaan kupi in waan unaanga Ierusalem. Ma diat lo taa a bolo nate uni, kupi in lo murmur Iesu mai. ");
INSERT INTO rai_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A ngaala na kor na taara ma in tabuan kaai, baa diat tapunuk ma diat luani diat murmuri. ");
INSERT INTO rai_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu i tur tapuku karom diat, ma i piri, “A kum tabuan Ierusalem, koku muaat luan iaau, muaat a luan muaat ut ma ra kum natnatumuaat. ");
INSERT INTO rai_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maa a bung na kinadik in waan paat baa a taara diat a piri lenbi, ‘A kum bi na tabuan, baa pa diat babuta ma pa diat wangaau naat, diat daan.’ ");
INSERT INTO rai_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma ‘diat a piri karom a kum taangaai, “Muaat a puka taau un miaat!” ma karom a kum tiltil, “Muaat a burung baat miaat!” ’ Os 10:8 ");
INSERT INTO rai_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Baa diat a paam a kum utnaa mi baa in diwaai i lalaaun utbaai, aawa diat a paami baa in diwaai ia maraang?” ");
INSERT INTO rai_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma raa rudi kaai, a ru aakaina muaana, di ben ungaai diaar ma Iesu kupi ditul a wirua ungaai. ");
INSERT INTO rai_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Baa diat waan paat u ra wanua di waatungi ma “A Lor,” diat aak waat Iesu u ra bolo matira, ma raa ru aakaina muaana kaai, raa u ra papaara ot, ma raa u ra papaara maira. ");
INSERT INTO rai_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma Iesu i piri lenbi, “Tamaang, una wa anundiat aakaina mangamangaan, maa pa diat nunura aawa mi diat paami.” Ma diat pilaai laaki kup woi kon diat in lo paa raaraaina maalu ko ra nuna kum maalu. ");
INSERT INTO rai_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A taara diat turtur ma diat bababoi, ma a kum mukmuga diat tataur un Iesu, diat piri naa, “I walaaun paa a taara ingen. Baa ia a Kaarisito anun God, anuna naat na pipilak, i koina baa in walaaun paa ia ut.” ");
INSERT INTO rai_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma a kum tena wineium kaai diat tataur uni. Diat waan karomi, diat taar taa a waain baa i matitir taana, ma diat piri, ");
INSERT INTO rai_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Baa ui a king anu ra taara Iudaia, mi un walaaun pa ui ma.” ");
INSERT INTO rai_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di timu taa utkaai a timtimu nate u ra bolo lenbi: ");
INSERT INTO rai_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Raa ko ra ru aakaina muaana baa di wakete ungaai ta ditul ma Iesu, i pir abulbul Iesu naa, “Baa ui Kaarisito, un walaaun pa datul!” ");
INSERT INTO rai_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma raa paan diaar i kaankaan karomi, ma i piri naa, “Lelawaai, ui pa u burut karom God? Maa ui kaai datul raap datul kariaana raa mangaana kinadik ku. ");
INSERT INTO rai_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","I takado ut un daar, maa di baalu anundaar mangamangaan. Iaku a muaana mi pa i paam ta aakaina mangamangaan.” ");
INSERT INTO rai_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma i piri taan Iesu, “Iesu, nuk pa iaau, baa un ruk u ra num mataanitu.” ");
INSERT INTO rai_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma i baalui naa, “Iaau pir a lingtatuna taam, mi ut un ki karom iaau u ra Paradaaiso.” ");
INSERT INTO rai_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Baa i 12 pakaana bung u ra mage, a buaal raap i baboto tuk un tuluina pakaana bung u ra maluraap, ");
INSERT INTO rai_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","maa in mataana mage pa i babo. Ma ina maalu na babaat kutu naruma u ra ruma na wetabaar i tarabaat naliwan kup ru pakaan. ");
INSERT INTO rai_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma Iesu i kulkulaai dekdek lenbi, “Tamaang iaau taar taa a niong u ra ru limaam.” Baa ia pir taai lenmi, i ung wa anuna lalaaun. ");
INSERT INTO rai_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Baa a mukmuga anu ra kum tena wineium i babo a utnaa mi, i pir walaawa paa God lenbi, “I lingtatuna aakit, a muaana mi a tena takado.” ");
INSERT INTO rai_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A kor na taara baa kuraa diat tur ungaai kupi diat a babo a utnaa mi, baa diat baboi, diat raapraapu a kum raprabondiat ma ra tapunuk ma diat waan talili. ");
INSERT INTO rai_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iaku a kum teptepaan Iesu, ma ra in tabuan baa diat murmuri taangirong Gaalilaia, diat tur welwelik taau ut, ma diat babo a kum utnaa mi. ");
INSERT INTO rai_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Raa muaana, a iaana Iosep, a te Aarimaatia. Aarimaatia a taamaan u ra papaar Iudaia. Iosep ia raa koina muaana, ma a tena takado, ma i kiki walaang kup a mataanitu anun God. Ia raa ko ra taara na kiwung, iaku pa i mulaaot ungaai ma diat u ra nundiat naagagon ma u ra utnaa baa diat paami. ");
INSERT INTO rai_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I waan karom Pilaato ma i aaring paa a minaatin Iesu koni. ");
INSERT INTO rai_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","I lo pari paai, i pulu paai ma ra ina koina maalu, ma i wainep taai u ra babaang na minaat baa di aa kil taai u ra papaara waat, ma pa di wainep taa utbaai ta minaat uni. ");
INSERT INTO rai_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A bung maa a bung na waninaar, ma marawaai ma a Bung Saabaat in turpaai. ");
INSERT INTO rai_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ma in tabuan baa diat weur ma Iesu taangirong Gaalilaia, diat murmur Iosep, ma diat babo taa a babaang na minaat ma ra mangaana wawainep baa di paami u ra minaatin Iesu. ");
INSERT INTO rai_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ma diat waan talili balet, ma diat waninaar paa a kum utnaa baa i aangawian wakwakaak ma ra wel na mangingi kaai. Ma u ra Bung Saabaat, diat ngo welaar ut ma ra naagagon. ");
INSERT INTO rai_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Baa i malaana kinalik u ra mugaana bung u ra wik, in tabuan diat waan kup a babaang na minaat, ma diat lo a kum utnaa baa i aangawian baa diat aa waninaar paai. ");
INSERT INTO rai_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma diat baboi baa di aa tul ingen wa ina waat ko ra mataa ra babaang na minaat. ");
INSERT INTO rai_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Diat ruk, iaku pa diat babo ma a minaat i ra Tadaaru Iesu. ");
INSERT INTO rai_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Baa i laklagon a nuknukindiat uni, raa ru muaana, anundiaar maalu i baarabaara aakit, diaar waan paat kakaian karom diat. ");
INSERT INTO rai_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Diat burut ma diat walipa a mataandiat unapia. Diaar piri taan diat, “I lawaai maa muaat baat kup a lalaaunina min naa ra kum minaat? ");
INSERT INTO rai_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pa i ki ma min, ia lalaaun balet. Muaat a nuk paa a pirpir baa ia pir taai taa muaat baa i ki utbaai irong Gaalilaia. ");
INSERT INTO rai_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","I pir taai naa, ‘Din taar taa Natu ra Muaana u ra limaa ra aakaina taara, ma din aak waati u ra bolo, ma u ra wetula bung in lalaaun balet.’” ");
INSERT INTO rai_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma in tabuan maa diat nuk paa a pirpir anun Iesu. ");
INSERT INTO rai_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Baa diat waan talili ko ra babaang na minaat, diat wewapua u ra kum utnaa raap mi karom a 11 naat na wawer ma karom diat raap kaai baa diat laana murmur Iesu. ");
INSERT INTO rai_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","In tabuan baa diat wapua a kum aapostolo u ra kum utnaa mi, bari diat: Maaria Maagdalene, Ioaana, ma Maaria naan Iaakobo, ma raa kum tabuan kaai baa diat weur ma ditul. ");
INSERT INTO rai_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iaku a kum aapostolo diat walangoro a pirpir anu ra in tabuan welaar ma ra pirpir biaa ku, ma pa diat nurnur un diat.  ");
INSERT INTO rai_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iaku Petero i tur, i welulu kup a babaang na minaat. I pun pari, ma i waawet ma i babo a kum maalu maku, diat inep ingen taau. Ma i waan talili balet, ma i nuknuk aakit u ra utnaa mi i waan paat. ");
INSERT INTO rai_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Io, u ra bung ut maa, rudi kon diat baa diat laana murmur Iesu, diaar waan kup a taamaan a iaana Emaaus. I welwelik, welaar ma 11 kilomita taanginaanga Ierusalem. ");
INSERT INTO rai_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baa diaar waan waanwaan diaar pirpir u ra kum utnaa mi ia waan paat. ");
INSERT INTO rai_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Baa diaar pipipir, ma diaar tiri wetwetalaai diaar, Iesu ut i waan paat karom diaar, ma ditul weur. ");
INSERT INTO rai_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iaku maa raa utnaa i pulu baat paa mataandiaar ma pa diaar babo lele paai. ");
INSERT INTO rai_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu i tiri diaar, “Aawa mi mur pirpir waanwaan uni u ra numur winawaan?” Diaar tur taau ku ma diaar babo na tapunuk. ");
INSERT INTO rai_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma raa kon diaar a iaana Kileopaas, i tiri naa, “Ui maku duk raa maa u ki inaanga Ierusalem, ma pa u nunura a kum utnaa di paami inaanga u ra kum bungbung mi?” ");
INSERT INTO rai_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma i tiri diaar, “A kum utnaa na aawa?” Ma diaar baalui naa, “A kum utnaa un Iesu a te Naasaret, a dekdek na propet aakit u ra nuna kum pinapaam, ma u ra nuna pirpir kaai, u ra mataan God ma ra taara raap. ");
INSERT INTO rai_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","A kum ngaala na tena wetabaar karom God ma anundaat kum mukmuga diat taar taai u ra naagagon kupi in maat, ma di aak waati u ra bolo. ");
INSERT INTO rai_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Miaat nurnur uni naa ia maa in walaangalaanga Israael. Ma mi, i wetula bung baat a kum utnaa baa diat paami. ");
INSERT INTO rai_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bari kaai ia, raa kum tabuan kon miaat, diat wakaian miaat. Baa diat kalaa kabot kup a babaang na minaat, ");
INSERT INTO rai_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","diat gaana bababo taau kup a minaatina. Ma baa diat waan talili, diat piri naa diat babo taa raa ru aangelo u ra binabo, ma diaar wapua diat naa ia lalaaun balet. ");
INSERT INTO rai_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Namur raa taara kaai kon miaat, diat waan paa u ra babaang na minaat, ma diat babo taa a utnaa baa in tabuan diat wewapua uni, iaku maa pa diat babo Iesu.” ");
INSERT INTO rai_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma Iesu i piri taan diaar, “Muaat longlong utbaai, pa muaat nurnur gagaa u ra kum utnaa a kum propet diat aa pir taai. ");
INSERT INTO rai_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Diat piri naa Kaarisito in kariaana a kum ngunungut mi, ma namur in ruk u ra nuna minamaar.” ");
INSERT INTO rai_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Turpaai u ra kum buk anun Moses ma ra kum propet, Iesu i papalaa karom diaar u ra kum utnaa raap di aa timu taai un ia ut u ra Buk Taabu. ");
INSERT INTO rai_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Baa ditul waan marawaai kup a taamaan baa diaar waan kupi, Iesu i walaari kupi in waan aakit ku. ");
INSERT INTO rai_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma diaar turbaati, diaar piri naa, “Un ki karom mir, maa ia maluraap, in mage i pot na lop ma.” Io, ditul ruk ma i ki karom diaar. ");
INSERT INTO rai_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Baa ditul ki na winangaan, Iesu i lo paa a bred, i waatung wakaak paa uni, i bik paai, ma i tabaara diaar mai. ");
INSERT INTO rai_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Io, i tapalaa a mataandiaar, ma diaar babo lele paai maraagaam, ma i panaai paa maut kon diaar. ");
INSERT INTO rai_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma diaar pirpir wetwetalaai karom diaar lenbi, “I lingtatuna ut, a balaandaar i wuwan ma ra gaaia baa i pirpir karom daar baa datul waan u ra aakapi, ma baa i palaa taa a pirpir na Buk Taabu taan daar.” ");
INSERT INTO rai_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","U ra pakaana bung ut maa, diaar tur ma diaar waan talili gagaa balet unaanga Ierusalem, ma diaar waan karom a 11 naat na wawer ma raa taara kaai baa diat ki ungaai. ");
INSERT INTO rai_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Diat piri naa, “A lingtatuna ut! A Tadaaru ia lalaaun balet, ma ia tur paat paa karom Simon.” ");
INSERT INTO rai_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma diaar wewapua u ra kum utnaa i waan paat karom diaar u ra aakapi, ma u ra nundiaar binabo lele uni baa i bik a bred. ");
INSERT INTO rai_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Baa diaar pirpir utbaai u ra kum utnaa mi, Iesu ut i tur naliwan taan diat, ma i piri naa, “A maalmaal karom muaat!” ");
INSERT INTO rai_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Diat burut aakit ma diat ururian uni, diat nuki naa a nion ku maa diat baboi. ");
INSERT INTO rai_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma i piri taan diat, “I lawaai maa muaat burut? Ma i lawaai maa muaat aalawur nuknuk? ");
INSERT INTO rai_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Muaat babo a ru limaang ma a ru kaking. Iaau mulu ut mi. Muaat a paam iaau, ma muaat a babo iaau. A nion pa ta panina, ma pa ta urina kaai. Iaku muaat baboi naa iaau a paning ut ma ra uring utkaai.”  ");
INSERT INTO rai_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Baa ia pir taai lenmi, i waiaa taa a ru limaana ma ra ru kakina taan diat. ");
INSERT INTO rai_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Diat gaaia ma diat kakaian, iaku maa pa diat nurnur utbaai. Ma i tiri diat naa, “Pa ta utnaa kuri baa kupi ang aani?” ");
INSERT INTO rai_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma diat tabaarai ma ra lik ian baa di aa tun taai. ");
INSERT INTO rai_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma i rakaan paai, ma i aani namataandiat. ");
INSERT INTO rai_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma i piri taan diat, “Baa iaau ki utbaai karom muaat, iaau aa pir taa a kum pirpir mi karom muaat naa: A kum utnaa raap baa di aa timu taai un iaau, u ra kum Naagagon anun Moses, u ra pirpir anu ra kum propet ma u ra Kum Kelekele anun Dewid din paam ot raap paai.” ");
INSERT INTO rai_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Io, Iesu i wakaapa a nuknukindiat kupi diat a manaana u ra Buk Taabu. ");
INSERT INTO rai_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I piri taan diat naa, “Di aa timu taai lenbi, Kaarisito in wirua, ma u ra wetula bung in lalaaun balet ko ra minaat, ");
INSERT INTO rai_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ma din warawaai u ra iaana karom a kum wunwuna taara raap turpaai inaanga Ierusalem. Din warawaai karom diat naa diat a nukpuku ma God in una wa anundiat kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Muaat a kum tena wewapua u ra kum utnaa mi muaat aa babo taai. ");
INSERT INTO rai_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Baboi, ang tula wa a utnaa baa Tamaang ia weweliman taau uni karom muaat. Muaat a ki ut min u ra taamaan mi, tuk baa din wamong ta muaat ma ra dekdek taanginaanga nate.” ");
INSERT INTO rai_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Namur i ben apari pa diat ko ra taamaan Ierusalem ma baa diat waan paat un raa wanua marawaai Betaania, i tulaa kado a ru limaana, ma i pir wadaan diat. ");
INSERT INTO rai_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Baa i pir wadaan diat utbaai, i waan kon diat, ma God i lo tato paai unaanga u ra maawa. ");
INSERT INTO rai_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Diat lotu karomi, ma diat waan talili balet unaanga Ierusalem ma ra ngaala na gaaia. ");
INSERT INTO rai_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma diat kiki u ra ruma na wetabaar, diat pir walaawa paa God. ");
INSERT INTO rai_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Narnaraap utbaai baa pa di waki utbaai a rakrakaan buaal, a Pirpir ia ki muga. A Pirpir i ki ungaai ma God, ma a Pirpir ia ut maa God. ");
INSERT INTO rai_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Narnaraap utbaai i ki ungaai ma God. ");
INSERT INTO rai_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","U ra Pirpir ut, God i waki a kum utnaa raap, pa ta utnaa God i waki baa pa i waki ma ra Pirpir. ");
INSERT INTO rai_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A lalaaun i ki uni, ma a lalaaun maa ia a kaapa anu ra taara raap. ");
INSERT INTO rai_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A kaapa i baarabaara u ra baboto, ma a baboto pa i uwia laar paai. ");
INSERT INTO rai_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God i tula wa raa muaana, a iaana Ioaanes. ");
INSERT INTO rai_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I waan paat kupi in wewapua u ra kaapa, kupi a taara raap diat a nurnur uni. ");
INSERT INTO rai_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ia ut wakir a kaapa, i waan paat ku kupi in wewapua u ra kaapa. ");
INSERT INTO rai_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Maa a kaapa lingtatuna baa i wakaapa a taara raap, in waan paat ma urin u ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A Pirpir i ki u ra rakrakaan buaal. Ma u ra Pirpir di waki a rakrakaan buaal, iaku a taara u ra rakrakaan buaal pa diat babo lele paai. ");
INSERT INTO rai_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I waan paat kup anuna taara, iaku maa anuna taara ut pa diat nemi. ");
INSERT INTO rai_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iaku, karom diat baa diat nemi, ma diat nurnur u ra iaana, i mulaaot pa diat kupi diat a kum natnatun God. ");
INSERT INTO rai_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wakir di waatung diat naa a kum natnatun God kabina u ra binabuta na wuna taara, baa u ra nemnem anun ta muaana taanga min napia. Pate, di buta diat ut u ra nion, u ra nemnem anun God. ");
INSERT INTO rai_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A Pirpir i waan paat i muaana mulu, ma i ki naliwan taa miaat. Miaat aa babo taa anuna minamaar, a minamaar anun Natuna raa ot ku, baa i waan kon Tamaana, i teng ma ra maarmaari ma ra lingtatuna. ");
INSERT INTO rai_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioaanes i wewapua kaapa uni ma i piri ma ra ngaala na ingaana lenbi, “Ia ut mi maa iaau wewapua muga uni naa, ‘Ia baa in murmur taang, i ngaala taang, maa ia ut i lalaaun muga taang.’” ");
INSERT INTO rai_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","I teng ma ra maarmaari, ma ko ra nuna ngaala na maarmaari, i wadaan daat ma ra mongoro na koina utnaa baa i waanwaan paat karom daat. ");
INSERT INTO rai_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Un Moses, God i taar taa a kum Naagagon taan daat, iaku un Iesu Kaarisito i taar taa a maarmaari ma ra lingtatuna karom daat. ");
INSERT INTO rai_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Pa te utbaai i babo taa God. Iaku raa Natuna ku, i ki ungaai ma Tamaana, i waiaa God karom daat. ");
INSERT INTO rai_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A kum mukmuga anu ra taara Iudaia taanga Ierusalem, diat tula wa a kum tena wetabaar, ma raa taara ko ra wuna taara Lewi, karom Ioaanes kupi diat a tiri naa, “Woi ui?” ");
INSERT INTO rai_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma Ioaanes wakir i pirpir baatbaati, i pirpir kaapa ut uni naa, “Wakir iaau Kaarisito.” ");
INSERT INTO rai_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Diat tiri balet naa, “Woi ui? Ui Eliaas?” Ma i baalu diat naa, “Pate, wakir iaau Eliaas.” Diat tiri balet naa, “Ui a propet baa di piri naa in waan paat?” I baalu diat naa, “Pate.” ");
INSERT INTO rai_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Namur diat piri taana naa, “Woi ui? Un wapua miaat kupi miaat a wapua diat baa diat tula wa miaat urin. Aawa maa un piri un ui ut?” ");
INSERT INTO rai_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ioaanes i baalu diat, “Iaau a muaana baa a propet Aaisaia i pirpir muga uni naa, ‘In ingaan raa i wewataai u ra bil na wanua lenbi: Muaat a paam kado a aakapi anu ra Tadaaru.’” Aais 40:3 ");
INSERT INTO rai_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A kum Parisaaio baa di tula wa diat karom Ioaanes, ");
INSERT INTO rai_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","diat tiri naa, “U piri naa, wakir ui Kaarisito, ma wakir kaai ui Eliaas, baa a propet, baa di piri naa in waan paat. Io, baa lenmaa, aawa kabina baa u baapitaaiso a taara?” ");
INSERT INTO rai_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioaanes i baalu diat naa, “Iaau baapitaaiso muaat ma ra palaa, iaku raa kuri i tur naliwan taa muaat baa pa muaat nunura lelei. ");
INSERT INTO rai_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia baa in murmur taang, i ngaala, ma iaau, iaau kinalik aakit taana.” ");
INSERT INTO rai_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A kum utnaa mi i waan paat irong Betaania un raa papaara daanim Ioridaan, baa Ioaanes i baapitaaiso a taara iaai. ");
INSERT INTO rai_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Raa bung namur, Ioaanes i babo paa Iesu baa i waan waanwaan karomi, ma i piri naa, “Muaat baboi, a Naat na Sip anun God, ia baa in lo wa aakaina mangamangaan anu ra rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mi ut ia a muaana baa iaau wewapua muga uni naa, ‘A muaana baa in murmur taang, ia i ngaala aakit taang, maa ia lalaaun muga taang.’ ");
INSERT INTO rai_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iaau kaai namuga pa iaau nunurai. Iaku iaau baapitaaiso ma ra palaa kupi ang waiaa a muaana mi karom a taara Israael.” ");
INSERT INTO rai_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ma Ioaanes i piri naa, “Pa iaau nunurai naa woi maa a Kaarisito. Iaku God, baa i tula wa iaau kupi ang baapitaaiso ma ra palaa, i wapua iaau naa, ‘Un babo a Takado na Nion in waan pari ma in ki un raa muaana. Ma raa ia a muaana baa in baapitaaiso ma ra Takado na Nion.’ Ma iaau babo a Takado na Nion i waan pari taanginaanga u ra maawa, i welaar ma ra ina buna ma i ki taau nate un Iesu. ");
INSERT INTO rai_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iaau aa babo taa a utnaa mi i waan paat, ma iaau wewapua uni baa ia a Natun God.” ");
INSERT INTO rai_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Raa bung talili, Ioaanes ma rudi ko ra nuna kum naat na wawer ditul tur balet matira. ");
INSERT INTO rai_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Baa i babo paa Iesu i waan aakit ditul, i piri uni naa, “Baboi, a Naat na Sip anun God.” ");
INSERT INTO rai_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Baa a ru naat na wawer diaar walangoro a pirpir maa, diaar murmur maut Iesu. ");
INSERT INTO rai_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Baa Iesu i tur tapuku, i babo pa diaar baa diaar murmuri, ma i tiri diaar naa, “Aawa maa mur nemi?” Diaar baalu Iesu naa, “Raabi” (a kukuraaina naa Tena Wawer), “kuraa u ki awaai?” ");
INSERT INTO rai_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu i baalu diaar naa, “Mur waan urin kupi mur a baboi.” Io, diaar murmuri, ma diaar babo a pakaana baa Iesu i ki iaai. Ma baa ditul waan paat, ia waat na pakaana bung paa, ma ditul ki maku matira a kudulaana bung na maluraap maa. ");
INSERT INTO rai_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Raa ko ra ru muaana baa diaar walangoro a pirpir anun Ioaanes ma diaar murmur Iesu, a iaana Aanderiaas, a tein Simon Petero. ");
INSERT INTO rai_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A mugaana utnaa Aanderiaas i paami, i baat paa tenalik Simon, ma i wapuai naa, “Miaat aa baat paa a Mesaia!” (a kukuraaina baa Kaarisito). ");
INSERT INTO rai_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aanderiaas i ben paa Simon karom Iesu. Baa Iesu i baboi, i piri taana naa, “Ui Simon, a natun Ioaanes, din waatung a iaam baa Kepaas.” (U ra pirpir Grik di waatungi naa Petero, a kukuraaina ina waat.) ");
INSERT INTO rai_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Raa bung talili balet, Iesu i nem na winawaan urong Gaalilaia. I baraata paa Pilipo, ma i piri taana naa, “Un murmur iaau.” ");
INSERT INTO rai_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo ia taangirong Betsaaida, a taamaan anun Aanderiaas ma Petero. ");
INSERT INTO rai_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo i baat paa Natanaael, ma i wapuai naa, “Miaat aa baat paa a muaana baa Moses i pirpir muga taau uni u ra Buk na Naagagon, ma ia baa a kum propet kaai diat aa wewapua muga taau uni u ra nundiat kum timtimu, ia Iesu a te Naasaret, natun Iosep.” ");
INSERT INTO rai_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Iaku Natanaael i baalui ku naa, “Naasaret! Lelawaai, ta koina utnaa ut in waan paat taangirong Naasaret?” Pilipo i baalui naa, “Un waan ku urin baa un baboi.” ");
INSERT INTO rai_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Baa Iesu i babo paa Natanaael i waan paat karomi, i piri naa, “A te Israael mulu ut mi, pa i nunura warwaruga.” ");
INSERT INTO rai_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaael i tiri Iesu naa, “U nunura lelawaai iaau?” I baalui naa, “Baa Pilipo i ben pa ui urin, iaau aa babo muga wa ui baa kuraa u ki taau natudaangi ra in diwaai na fig.” ");
INSERT INTO rai_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaael i piri taana naa, “Tena wawer, ui a Natun God, ui a King anu ra taara Israael.” ");
INSERT INTO rai_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu i piri taana naa, “Lelawaai, u nurnur maraagaam baa iaau wapua ui naa u ki taau natudaangi ra in diwaai na fig? Namur un babo a kum ngaalangaala na utnaa aakit in waan paat, in ngaala ko ra utnaa mi u baboi.” ");
INSERT INTO rai_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iesu i piri balet naa, “Iaau pir a lingtatuna taa muaat, muaat a babo a maawa in tapaapa, ma a kum aangelo anun God diat a waanwaan tato ma diat a waanwaan pari karom a Natu ra Muaana.” ");
INSERT INTO rai_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Namur baa ru bung i raap, di paam a lukaara na paakamaau irong Kaana, u ra papaar Gaalilaia. Naan Iesu i waan ut. ");
INSERT INTO rai_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma di aaring kaai Iesu ma ra nuna kum naat na wawer kupi diat a waan u ra paakamaau. ");
INSERT INTO rai_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Baa pa ta waain ma, naan Iesu i wapua Iesu naa, “A waain ia raap.” ");
INSERT INTO rai_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu i baalui naa, “Naang, i lawaai maa u wapua iaau uni? Anung pakaana bung pa i ot utbaai.” ");
INSERT INTO rai_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naan Iesu i wapua a kum tultul naa, “Muaat a paam ku a kum utnaa baa i piri taa muaat kupi muaat a paami.” ");
INSERT INTO rai_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","6 na ngaalangaala na palaa na waat diat tur matira kup a ginigi, welaar ut ma ra naagagon ko ra lotu anu ra taara Iudaia. Un raaraain palaa na waat mi, di laana watengi ma ra ru noina baa tula noina gaalon na palaa. ");
INSERT INTO rai_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu i piri taa ra kum tultul naa, “Muaat a itup ateng taa a kum palaa na waat ma ra palaa.” Ma diat itup ateng raap ta diat. ");
INSERT INTO rai_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Io, Iesu i tula diat naa, “Muaat a itup paa ta palaa ko ra kum palaa na waat, ma muaat a loi karom ia baa i naagagon a lukaara.” Ma diat paami lenmaa. ");
INSERT INTO rai_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Baa a muaana baa i naagagon a lukaara i inim tamaai, a palaa maa ia waain raap. Pa i nunurai naa a waain mi i waan taangawaai, a kum tultul ku baa diat itupi diat nunurai. I wataa ingen paa a muaana baa i paakamaau u ra bung maa, ");
INSERT INTO rai_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma i piri taana naa, “A taara raap diat laana wainim muga a taara ma ra koina waain. Baa diat aa inim iwan, io, diat wainim maku a taara ma ra waain baa pa i koina wakaak. Iaku ui, u wetabaar maraagaam ma ra koina waain aakit mi.” ");
INSERT INTO rai_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mi ia a mugaana wakilang baa Iesu i paami. I paami irong Kaana u ra papaar Gaalilaia. I waiaa paat anuna minamaar mai, ma anuna kum naat na wawer diat nurnur uni. ");
INSERT INTO rai_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Namur, baa a paakamaau mi ia raap, i waan urong Kaapernaaum, diat weur ma naana, a kum tatena liklik ma anuna kum naat na wawer. Diat ki matira a kabaana bung ut. ");
INSERT INTO rai_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Baa a lukaara na waan likaai anu ra taara Iudaia i marawaai, Iesu i waan unaanga Ierusalem. ");
INSERT INTO rai_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Baa i ruk un raa pakaana ko ra ruma na wetabaar, i babo a taara diat wiura a kum bulumakaau, ma ra kum sip, ma ra kum buna, ma i babo kaai a kum tena kiaana maani, diat kiki naa ra nundiat kum luwu. ");
INSERT INTO rai_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I wiri paa a kum aaru kup in aaru na wineium, ma i lu pari wa diat raap mai. I lu pari wa a kum bulumakaau ma ra kum sip, ma i ong lamira wa a kum maani anu ra kum tena kiaana maani, ma i ong puku wa anundiat kum luwu. ");
INSERT INTO rai_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma i piri taan diat baa diat wiura a kum buna, “Muaat a lo pari wa diat taanga min! Ma koku muaat puku paa a ruma anun Tamaang kup a ruma na wiura!” ");
INSERT INTO rai_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Anuna kum naat na wawer diat nuk paa a pirpir u ra Buk Taabu lenbi, “Ang wirua kabina u ra nung ngaala na maarmaari kup anum ruma.” Kele 69:9 ");
INSERT INTO rai_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A taara Iudaia diat waan paat balet karom Iesu ma diat tiri naa, “Woi na wakilang un waiaa miaat uni, kupi miaat a nunurai naa u paam akoto a naagagon kupi un paam a kum utnaa mai mi?” ");
INSERT INTO rai_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu i baalu diat naa, “Muaat a reng wa a ruma bi anun God ma ang watur paai balet ku un ta tula bung.” ");
INSERT INTO rai_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Diat tiri Iesu naa, “Di paam paa a ruma mi un 46 na kilaala, ma ui un paam paai balet ku un ta tula bung?” ");
INSERT INTO rai_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Baa Iesu i pirpir u ra ruma anun God, i pirpir welwelaar ut u ra panina. ");
INSERT INTO rai_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Namur baa Iesu ia lalaaun paat balet ko ra minaat, anuna kum naat na wawer diat nuk paa a pirpir mi. Io, diat nurnur maraagaam u ra Buk Taabu, ma ra pirpir baa Iesu i pir taai. ");
INSERT INTO rai_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Baa Iesu i ki inaanga Ierusalem u ra lukaara na waan likaai, mongoro na taara diat babo a kum wakilang i paami, ma diat nurnur u ra iaana. ");
INSERT INTO rai_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma Iesu pa i nurnur un te, kabina maa i nunura a taara raap. ");
INSERT INTO rai_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pa i iba kup te kupi in wapuai u ra mangamangaan anu ra taara, kabina maa ia ut i nunura wakaak a balaandiat. ");
INSERT INTO rai_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Raa muaana kon diat a kum Parisaaio, a iaana Nikadimo, ia raa mukmuga anu ra taara Iudaia. ");
INSERT INTO rai_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I waan karom Iesu un raa bung na marum ma i piri taana naa, “Tena wawer, miaat nunura ui baa ui a tena wawer, baa God i tula wa ui. Pa ta muaana in paam laar paa a kum wakilang u paami, baa God pa in waraauti.” ");
INSERT INTO rai_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu i baalui naa, “Iaau pir a lingtatuna taam, baa te pa di buta matakinai, pa in babo a mataanitu anun God.” ");
INSERT INTO rai_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikadimo i piri taana naa, “Din buta matakina lelawaai paa te baa ia takaana? Lelawaai, in ruk balet u ra in balaan naana kupi in butai balet?” ");
INSERT INTO rai_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu i baalui naa, “Iaau pir a lingtatuna taam, baa te pa di buta matakinai u ra palaa ma u ra Nion, pa in ruk laar paai u ra mataanitu anun God. ");
INSERT INTO rai_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ia baa di butai u ra panina, in lalaaun na panina ku, ma ia baa di butai u ra Nion, in lalaaun na nion. ");
INSERT INTO rai_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Koku u kakaian baa iaau piri taam naa din buta matakina muaat. ");
INSERT INTO rai_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A dadaip i waan taltalili welaar ma ra nuna nemnem, u walangoro a rurungaina, iaku pa u nunurai naa i waan taangawaai, ma in waan uwaai. Lenkaai maa karom diat baa a Nion i buta matakina diat.” ");
INSERT INTO rai_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikadimo i tiri naa, “In papet lelawaai a utnaa mi?” ");
INSERT INTO rai_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu i baalui naa, “Ui a ngaala na tena wawer anu ra taara Israael, i lawaai maa pa u nunura a kum utnaa mi? ");
INSERT INTO rai_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iaau pir a lingtatuna taam, miaat pir a utnaa miaat nunurai, ma miaat wewapua u ra utnaa baa miaat aa babo taai, iaku pa muaat nurnur u ra kum utnaa miaat wewapua uni. ");
INSERT INTO rai_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iaau wapua muaat u ra kum utnaa taanga main napia ma pa muaat nurnur uni. Io, muaat a nurnur lelawaai baa ang wapua muaat u ra kum utnaa taanginaanga u ra maawa? ");
INSERT INTO rai_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pa te i waan paa unaanga nate u ra maawa, Natu ra Muaana ot ku baa i waan pari taanginaanga nate u ra maawa. ");
INSERT INTO rai_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses i wakete ina wui u ra in diwaai u ra bil na wanua. Lenkaai maa din wakete Natu ra Muaana unate, ");
INSERT INTO rai_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kupi diat raap baa diat nurnur uni diat a lalaaun takum. ");
INSERT INTO rai_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“God i maari a rakrakaan buaal, ma i taar wa Natuna raa ot ku, kupi diat raap baa diat nurnur uni, diat a lalaaun takum, ma pain diat a wirua. ");
INSERT INTO rai_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God pa i tula wa Natuna urin u ra rakrakaan buaal kupi in taar a naagagon na binabaalu karom a rakrakaan buaal. I tula wai ku kupi in walaaun a rakrakaan buaal. ");
INSERT INTO rai_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pa din taar a naagagon na binabaalu karom ia baa i nurnur uni. Iaku, ia baa pa i nurnur, ia tur u ra dekdek na naagagon na binabaalu kabina pa i nurnur un Natun God raa ku. ");
INSERT INTO rai_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bi ia a naagagon anun God: A kaapa ia waan paat u ra rakrakaan buaal, iaku a taara diat nem ku a baboto ma a kaapa pate, maa anundiat mangamangaan i aaka aakit. ");
INSERT INTO rai_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Diat raap baa diat laana paam a kum aakaina mangamangaan, diat milikuaana ku a kaapa, ma pa diat waan karom a kaapa, kaduk din babo puaana paa anundiat kum aakaina mangamangaan. ");
INSERT INTO rai_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iaku, diat baa diat murmur a lingtatuna, diat waan paat u ra kaapa, kupi din babo puaanai naa anundiat kum pinapaam i kabina paa ut kon God.” ");
INSERT INTO rai_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Namur, Iesu ma anuna kum naat na wawer diat waan taanga Ierusalem kup raa taamaan lik kuraa ut u ra papaar Iudaia, ma diat ki paa 