﻿USE sofia;
DROP TABLE IF EXISTS sofia.qxoNT_vpl;
CREATE TABLE qxoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qxoNT_vpl WRITE;
INSERT INTO qxoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristoga yurishga rey Davidpa ayllun aywaragpitam. Davidnam cashga Abrahampa ayllunpita aywarag. Cay runacunam cayashga Abrahampa y Davidpa aylluncuna. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa tsurinmi cargan Isaac. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judapa tsurincunam cayargan Fareswan Zara. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa tsurinmi Aminadab. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa tsurinmi cargan Booz. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesepa tsurinnam cargan rey David. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa tsurinmi cargan Roboam. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa tsurinmi Josafat. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa tsurinmi Jotam. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa tsurinmi Manases. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa tsurinmi cargan Jeconias ");
INSERT INTO qxoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tsaychönam Jeconiaspa tsurin Salatiel yurirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa tsurinmi Abiud. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa tsurinmi Sadoc. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa tsurinmi Eleazar. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa tsurinnam cargan Mariapa runan Jose. Y Mariapa wawanmi cashga Jesus, Tayta Dios cachamungan salvamagllantsic. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tsaynömi ari Abraham cawangan witsanpita hasta David yuringanyag chunca chuscu (14) runacunarä cayashga Abrahampa ayllun aywaragcuna. Tsaynöllam David cawangan witsanpitapis Israel runacunata Babiloniaman apayangan witsanyag chunca chuscu runacunarä cayashga Davidpa ayllun aywaragcuna. Tsaynöllam Babiloniaman apayangan witsanpitapis Jesucristo yuringanyag chunca chuscu runacunarä cayashga tsay aywaraglla. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Salvamagnintsic Jesucristo caynömi yurirgan. Mariawan Jose täyänanpäna willanacushga caycarpis manam juntacäyarganrätsoga. Tsaynö caycaptinpis Espiritu Santupa munayninwanmi Mariaga geshyag ricacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Geshyagna ricacuptin Josega llänu runa carmi Mariapä imatapis parlargantsu. Payga mana quejacuyllapam jagiriyta munargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tsaynö jagiriyta munaycaptinmi Tayta Diospa angelnin Joseta suëñuyninchö nirgan: “Unay rey Davidpa castan Jose, Mariaga manam ima runawanpis tincucashgarätsu geshyag ricacunanpä, sinöga Espiritu Santupa munayninwanmi geshyag ricacushga. Tsaynö caycaptinga mana ajayllapa Mariata goricuy. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ollgu wamratam Maria geshyacunga. Paypa jutinmi canga Jesus, runacunata jutsa ruraynincunapita perdonar salvananpä captinmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tsaycuna päsanan captinmi Tayta Diospa willacognin profëta caynö gellgargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Jipashmi, virgenllarä caycar, geshyacunga ollgu wamrata. Tsay wamrapämi niyanga ‘Emanuel’ canganta. Emanuel ninanga ‘Diosnintsic nogantsicwan caycan’ ninanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tsaypita Jose punuycanganta riccharcamurnam angel ningannö Mariata ädisirpis goricurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mariaga Josewan taycarpis manam punuyargantsu. Wawan yuriycuptinnam Josega nirgan: “Jesusmi jutinga canga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Israel nacionchö Herodes rey caycangan witsanmi Judea provinciapa Belen marcanchö Jesus yurirgan. Yurisquiptinnam Jerusalenman chäyargan juclä nacionpita musyag estrëlla estudiag runacuna caynö tapupacurnin: ");
INSERT INTO qxoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Israel runacunapa mandagnin rey cananpä llullu yureg ¿maychötä caycan? Rupay yargamunan cag lädupita estrëlla yargamogta ricashga carmi shayämurgö payman adoragnin” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tsayta wiyaycurga rey Herodes chiquicurninmi yarpachacurgan paylla rey cacuyta munar. Tsaynöllam Jerusalenchö tag runacunapis pasaypa mantsariyargan caynö nir: “Cananga ¿imanörä cashun Herodeswan?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tsaynam Herodesga mandag sacerdöticunata y Moises gellgangan ley yachatsicogcunata gayaycatsimur tapurgan: “¿Maychötä salvacogniquicuna Cristo yurinan cargan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Paycunanam niyargan: “Judea provinciapa Belen marcanchö yurinanpämi Tayta Diospa willacognin profëta gellgargan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belenchömi Israel runacunapa mandacognin rey yuringa Judea provinciachö jatusag marcacunapita tsay marca tacshalla caycaptinpis’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsayta wiyaycurnam Herodesga pacayllapa gayatsirgan tsay estrëlla estudiagcunata. Paycuna chaycuyaptinmi tapurgan yargamog estrëllata imaypitana ricayangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Imaypita ricayangantapis willayaptinnam Herodes nirgan: “Belenman aywar tsay wamrata ashiyämuy. Tarirninga willayämanqui nogapis adoragnin aywanäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tsaynö rey Herodeswan parlar usharirnam estrëlla estudiag runacuna aywayargan. Aywaycäyaptinnam tsay ricayangan estrëllapis ñöpancunallata Belenman aywargan wamra caycangan wayiman chäyanganyag. Chaycuyaptinnam tsay pushag estrëlla pärasquirgan wayi janan derëchachö. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tsay wayi jananchöna pärasquegta ricärirnam itsanga estrëlla estudiagcuna feyupa cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tsaymi tsay wayiman yaycurirnin tariyargan llullu Jesus maman Mariawan caycagta. Tsaychö ricaycurnam ñöpanman gonguricuycur llulluta adorayargan. Nircurnam apayangancunata churapäyargan öruta, inciensiuta, y “mirra” ningan perjümita. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsaynam paycunata Tayta Dios suëñuynincunachö parlapargan Herodes cagman manana cutiyänanpä. Tsaynö willashgana carmi juclä nänipana marcancunaman cuticuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Estrëlla estudiag runacuna marcancunaman cuticuyaptinnam Joseta suëñuyninchö Tayta Diospa angelnin nirgan: “Rey Herodesmi llulluta wanutsinanpä ashitsinga. Canantä ras sharcur Jesusta mamantinta Egiptuman geshpitsiy cutimunayquipä willangäyag” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tsaynö niptinmi Josega pagas ricchacarcamur Jesusta mamantinta pusharcur Egiptuman aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tsaychömi paycuna täcuyargan Herodes wanunganyag. Tsaynö päsanan captinmi Tayta Dios unay tantiyatsirgan willacognin profëtata. Tsay profëtam gellgargan caynö: “Egiptupitam gayamurgä wamräta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Estrëlla estudiag runacuna Jesus maychö cangantapis willag mana cutiyaptinnam rey Herodesga pasaypa ajargan. Tsaynö ajarnam Jesusta wanutsiyta munar soldäduncunata cachargan Belen marcachö y ñöpan quinran marcacunapitapis ollgu wamracunata wanutsiyänanpä. Estrëlla estudiag runacuna imaypitana estrëllata ricayanganta willapäyashga captinmi Herodes tantiyacurgan Jesus juc o ishcay watayogna canganta. Tsaymi wamracunata wanutsiyargan yurishgapita ishcay watayogyag. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tsaycuna päsaptinmi Tayta Diospa unay willacognin profëta Jeremias gellgangan cumplicargan. Paymi caynö gellgargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“‘Ramah’ ningan marcachömi llapancunapis pasaypa llaquicurnin wagaycäyan. Wawancuna ushacäyaptinmi shogayaptinpis manana päraypa Raquel wagaycan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tsaypitaga Egiptuchö Jose caycällaptinrämi rey Herodes wanusquirgan. Tsaynam suëñuyninchö Tayta Diospa angelnin Joseta nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Jose, cananga mamantinta Jesusta pushacurcur Israelman cuticuy. Jesusta wanutsiyta munagcuna wanuyashganam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Angel tsaynö niptinmi jinan öra Josega Israelman cuticurgan mamantinta wamrata pushacurcur. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tsaynö cutirnam Jose mayasquirgan Judea provinciachö Herodespa tsurin Arquelauna troquinchö rey caycanganta. Tsaynam Jose mantsarirgan Judeaman cutiyta. Tsaynö mantsariptinmi Tayta Dios suëñuyninchö nirgan Judeaman aywananpa rantin Galilea provinciamanna aywacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea provinciaman chaycurnam Nazaret marcaman aywargan tsaychöna täcuyänanpä. Tsaycuna päsanan captinmi Tayta Diospa unay willacognin profëta caynö gellgargan: “Salvacogga Nazaret marcapita cangantam niyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Señor Jesus yachatsicur manarä gallaptinmi Juan Bautista Tayta Diospa willacuyninta willacur gallaycurgan. Judea provincia quinran tsunyagcunapa puriptinmi runacuna tsayman aywayargan willacunganta wiyayänanpä. Tsaychö willacurmi caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Tayta Dios cachamungan salvacog rey chämunganam. Tsaynö caycaptinga jutsa rurayniquicunata jagirir Diosnintsic munangannöna cawayay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tsaynö Juan Bautista willacunanpä captinmi Tayta Dios nirgan unay willacognin profëta Isaiasta caynö gellgananpä: “Tsunyagchömi gayaraypa gayarar willacunga: ‘¡Jutsa rurayniquicunata jagirir alistacuyay Señornintsicta chasquicuyänayquipä! Mandacog runa shamuptin chasquicuyänayquipä nänicunata limpiapacur puestucog cuenta salvacogta chasquicuyänayquipä alistacuyay’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan Bautistapa röpanga cargan camëllupa cerdanpita rurashgam. Wachäcanpis cargan camëllupa garanpita rurashgam. Juanpaga micuyninpis cargan chucllushnö curucunam y chumpac mishquicunam. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Willacur puringanta wiyarnam Jerusalenpita y Judea provinciapa maytsay marcancunapita atsca runacuna Juan caycanganman aywayargan willacunganta wiyayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tsaynö willacunganta wiyarmi runacuna tantiyacuyargan jutsa rurag cayanganta. Jutsa rurag cayanganta tantiyacur Tayta Diosta perdonta mañacuyaptinnam Juan bautizargan Jordan mayuchö. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tsaymannam fariseo y saduceo cagcuna bautizacuyänanpä shayämurgan. Jinatanam tsay runacunata Juan nirgan: “¡Culebra casta runacuna! ¿Imanirtä gamcuna yarpäyanqui jutsata rurayangayquipita Tayta Dios infiernuman mana gaycuyäshunayquipä cagta? ");
INSERT INTO qxoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tayta Dios infiernuman mana gaycuyäshunayquipä jutsa rurayniquicunata jagirir pay munanganta rurarna cawayay. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama yarpäyaytsu unay Abraham casta cayangayquipita Tayta Dios salvayäshunayquipä cagta. Tayta Dios munarga Abraham casta runacunaman cay rumicunatapis ticrascäratsinmanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mana alli wayog jachacunata cuchupita muturir ninaman gaycognömi Tayta Dios jutsa ruragcunata infiernuman gaycunanpäna caycan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nogaga yacullawanmi bautizaycä jutsa rurayniquicunata jagirir Tayta Dios munangannö cawayänayquipä. Peru salvacog shamogta chasquicogcunamanmi itsanga Espiritu Santuta Tayta Dios cachamunga y mana chasquicogcunataga infiernumanmi gaycunga. Tsaynö captin salvacogmanga ni ichicllapis manam nogaga iwalätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Payga trïguta wayrananpä jurquitan aptashganam caycan. Nircur trïguta wayrarirnam päjantaga ninaman gaycunga y trïguntanam wayinman apacunga. Tsaynömi jutsa ruragcunataga imaypis mana upeg ninaman gaycunga y Tayta Dios munanganman cawagcunatanam gloriaman apacunga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Galilea provinciapitam Jesuspis aywargan Jordan mayuman Juan bautizananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsayman chasquiptinga bautizayta Juan manam munargantsu caynö nirnin: “Tayta Dios cachamungan salvacog caycaptiquega ¿imanöpatä canan gamta bautizäman? Antis nogatachir gam bautizaycamanquimanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsaynö niptinnam Jesus nirgan: “Imanö captinpis bautizamaylla. Gam bautizamänayquitam Tayta Diosga munan”. Tsaynö niptinmi Juan bautizargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautizacusquir yacupita yarguraycarnam Jesus ricasquirgan ciëlu quichacasquiptin Espiritu Santo palumanö payman uraycämogta. ");
INSERT INTO qxoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y nircurmi ciëlupita Tayta Dios caynö nimungan wiyacämurgan: “Paymi cuyay tsurï. Noga munangänö cumpliptinmi cushishga caycä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsaypitanam Jesusta Espiritu Santo tsunyag jircaman pushargan tsaychö Satanas tentayta munaptin Jesus poderninwan gargunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tsay jircachöga chuscu chunca (40) junag y chuscu chunca pagas imatapis mana micuypam Tayta Diosman mañacur Jesus cargan. Tsaypitaga pasaypam mallagacuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsaynö caycaptinnam Satanas yurisquir nirgan: “Diospa tsurin caycarga mä, cay rumicunata tantaman ticratsiy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tsaynö niptinnam Jesus nirgan: “Diospa palabran gellgaranganchö caynömi nican: ‘Manam tantata micurllatsu runacuna cawayan, sinöga Dios ningancunata cäsucuyanganwanpis allimi cawayan’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsaypitanam wap Jerusalen templu jananchöna Jesusta Satanas ricacascatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nircurmi nirgan: “Diospa tsurin caycarga caypita patsaman mä jegarpuy. Diospa palabran gellgaranganchöga caynöchä nin: ‘Gamta cuïdashunayquipä angelnincunatam Dios cachamunga. Paycunam tsariyäshunqui patsaman jegaptiquipis rumicunachö mana tacacunayquipä’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Niptinmi Jesus nirgan: “Manam gam nimangayquita rurashätsu. Diospa palabran gellgaranganchöga caynömi nican: ‘Ama Tayta Dios ningancunata manacagman churayta yarpaytsu munangayquita ruranayquipä’ ” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tsaypitaga jirca puntan altuchönam Satanas Jesusta wap ricacascatsimurgan. Tsaypitanam maytsay nacioncunata y tsaychö imayca riquëzacunata ricascäratsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nircurmi nirgan: “Gonguriycur nogata adoramaptiquega cay ricangayqui nacioncunata y llapan riquëzancunatam goycushayqui munayniquichöna tsaräcunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tsaynö niptinmi Jesus nirgan: “¡Witicuy, Satanas! Diospa palabran gellgaranganchöga caynö nirmi nican: ‘Tayta Diosllatam adoranayqui y payllatam sirvinayqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tsaynö niycuptinmi Satanas illacasquirgan. Tsaypitanam angelcuna yuripasquir Jesusta yanapayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista carcelchö wichgaraycaptinnam Jesus Galilea provinciachö marcan Nazaretman cuticurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tsaypitanam Capernaum marcaman aywacurgan tsaychöna täcunanpä. Tsay marcaga cargan Galilea gocha cuchunchö, Zabulon y Neftali castacuna täcuyangan marcacunachömi. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tsaychö Señornintsic tänanpä captinmi Tayta Diospa willacognin profëta Isaias caynö gellgargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Galilea gochapa ñöpancunachö tag mana Israel runacuna, Jordan mayupa wac-tsimpanchö tag runacuna, Zabulon y Neftali casta runacunapis llapayqui wiyayämay. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tsacäpacushganö llutan ruraychö cawag runacunam Tayta Diospa alli willacuyninta wiyayashga. Tayta Dios ninganta mana cäsucogcunamanmi rupay atsicyagnörä Tayta Diospa alli willacuynin chashga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Isaias gellgangannö Capernaumchö taycarninmi Jesus willacur gallaycurgan: “Tayta Dios cachamungan salvacog rey chämunganam. Tsaynö caycaptinga jutsa rurayniquicunata jagirir Tayta Dios munangannöna cawayay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Juc junagnam Galilea gocha cuchunpa aywaycanganchö Jesus ricasquirgan ishcay pescag runacuna mällancunata yacuman mashtaycäyagta. Paycunaga cayargan Simon y waugin Andres. Simonpa jucag jutinmi cargan Pedro. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Paycunatam Jesus nirgan: “Discïpulücuna cayänayquipä nogawan aywacushun. Gamcunata yachatsiyäshayqui pescäduta tsariyänayquipa rantin Diospa alli willacuyninta runacunata willapäyänayquipä cagtana”. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsaynö niptinmi mällancunata jagisquir jinan öra Jesuswan aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsaypita yargur mas washaläninta aywaycäyanganchönam ricasquirgan Santiagutawan Juantana. Paycunaga papänincuna Zebedeuwanmi büquiman jamaycur mällancunata allitsaycäyargan. Paycunatapis Jesus gayargan discïpuluncuna cayänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tsaynö gayariptin paycunapis jucllam Jesuswan aywayargan papänincunata büquichö jagisquir. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tsaypitanam Jesus purirgan Galilea provincia quinran marcacunapa. Tsay marcacunachömi runacuna goricäcuyänan wayicunachö Tayta Diospa alli willacuyninta willacur yachatsicurgan. Tsaynömi tucuyläya geshyawan geshyagyashgacunatapis allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria nacion marcacunachöpis mayayarganmi geshyagcunata Jesus allïtsinganta. Tsaymi Jesus caycanganman apayämurgan imaycaläya geshyacunawan geshyagyashgacunata, supaycuna löcuyätsingan runacunata, wanuy geshyawan ñacagcunata, y paralïticucunata. Tsay llapan geshyagyashga runacunatam Jesus allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Feyupam runacuna Jesusta gatiräyargan Galilea marcacunapita, Decapolis marcacunapita, Jerusalenpita, Judea marcacunapita, y Jordan mayu wac-tsimpan quinranpitapis. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Tsaypita juc junagnam atsca runacunata ricarnin juc jircanman Jesus discïpuluncunawan witsargan tsaychö yachatsinanpä. Tsaychö Jesus jamaycurmi yachatsicurgan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushishgam cawayanga Tayta Diosllaman imaypis mañacur cawag runacunaga. Paycunataga Tayta Diosmi ñöpanman pushanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Cushishgam cawayanga cay vïdachö llaquicogcuna. Paycunataga Tayta Diosmi consulanga llaquicuychö mana cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Cushishgam cawayanga llänu shonguyog car runa mayincunawan alli cawagcuna. Paycunaga gloriachömi herenciata chasquiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Cushishgam cawayanga mallagaypanörä yacunaypanörä Tayta Dios ninganman cawayta munagcunaga. Paycunataga Tayta Dios mana dejaypam yanapanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Cushishgam cawayanga runa mayinta cuyapagcuna. Paycunata Tayta Dios cuyapangam. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Cushishgam cawayanga jutsata mana ruraypa Tayta Dios munangannö cawagcuna. Paycunam Tayta Diospa ñöpanman chäyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Cushishgam cawayanga runa mayinta amishtatsegcuna. Paycunataga Tayta Dios ‘Gamga wamrämi canqui’ ningam. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Cushishgam cawayanga Tayta Dios munangannö cawayanganpita chiquishga cagcuna. Paycunaga gloriachö pipis mana chiquishgam cawayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nogaman criyicayämungayquipita runacuna ashlliyäshuptiqui, chiquiyäshuptiqui, y llullacurcur imaycatapis manacagcunata tumpayäshuptiqui cushicuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Noga raycur ñacagcunataga Tayta Diosmi ciëluchö premiuta goyäshunqui. Gamcunatanömi unay profëtacunatapis ñacatsiyargan. Tayta Dios tsay profëtacunata premiuta gongannöllam gamcunatapis goyäshunqui. Tsaynö cananpä caycaptinga ñacarpis cushicuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamcunaga cay patsachö cachinömi cayanqui. Micuyta cachi gustuta manana gor imapäpis mana välegnömi gamcunapis Tayta Dios munangannö mana cawarga imapäpis väliyanquitsu. Gamlagyashga cachita pipis maypis jichariyangannömi gamcunatapis infiernuman gaycuyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tsaynöpis gamcunaga Tayta Dios munangannö cawarnin runacunapä actsi cuentam caycäyanqui. Juc marca jircan niragchö carga maytsaymanpis ricacanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tsaynöllam actsita tsaritsirpis alëriman churantsic wayichö atsicyänanpä. Manam imaypis tsaritsintsictsu catri jawancunaman churanantsicpäga. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Runacuna ricayänanpä actsi atsicyagnömi gamcunapis runacuna ricayäshunayquipä Dios munangannö cawayänayqui. Tsaynö cawagta ricayäshurmi paycunapis tantiyacuyanga Tayta Dios munangannöna cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama yarpäyaytsu Moises gellgangan leycunata y profëtacuna gellgayangancunata imapäpis mana cuentaycangäta. Nogaga shamurgö tsay leycuna imapä cangantapis tantiyatsinäpämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ciëlupis cay patsapis manarä ushacaptinmi Moises gellgangan y profëtacuna gellgayanganga llapanpis cumplinga Tayta Dios munangannölla. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tsaynö caycaptinga pipis tsay gellgashgacunachö ningancunata mana cäsur y juccunatapis mana cäsunanpä yachatsirga Tayta Diospa ñöpanchö manam imapäpis cuentashgatsu canga. Pipis tsay gellgashgacunachö ningancunata cäsur y juccunatapis cäsunanpä yachatsirmi itsanga Tayta Diospa ñöpanchö alli ricashga canga. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tsaynö caycaptinga gamcuna Tayta Dios ningancunata cumpliyay. Fariseucunanö y ley yachatsicogcunanö cumpleg tucurga Tayta Diospa ñöpanman manam imaypis chäyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gamcuna musyayanquim Moises gellganganchö caynö ninganta: ‘Ama runa mayiquita wanutsinquitsu. Runa mayinta wanutsegcunaga juzgashgam canga’. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tsaynö niptinpis nogaga caynömi nï: Manam runa mayinta wanutseg cagllatatsu Tayta Dios juzganga, sinöga runa mayinta ajanapag cagtapis, ashlleg cagtapis, y ‘Gamga imapäpis manam välinquitsu’ neg cagtapis Tayta Diosmi juzgarnin infiernuman gaycunga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Tsaynö caycaptinga runa mayiquiwan resentitsinacushga carga Tayta Diospä ofrendata apaycangayquitapis ofrendayquita dejaycur puntataga resentitsinacungayquiwanrä amishtag ayway. Tsaypita itsanga tsay apaycangayqui ofrendata Tayta Diospä goycunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tsaynölla imapitapis chiquinacungayqui quejashuyta yarpaptinga autoridäman manarä char arreglanqui. Tsaynö mana arreglaptiquega juezman apatsishuptiqui juezga wardiyacunawanmi carcelman wichgatsiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tsaypitaga manam rasllaga yargunquitsu jaga cayniquita llapanta mana pägacurga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gamcuna musyayanquim Moises gellganganchö caynö ninganta: ‘Nagana majayog carga ama adulteriu jutsata rurayaytsu’. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tsaynö niptinpis nogaga caynömi nï: Yarpayniquicunallachöpis juc warmita munaparga adulteriu jutsataga maynam rurayarguyquina”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Tsaynö carnin juc warmita ricärirninllapis munaparga ñawiquita jipirir jitariycuy. Infiernuman gaycushga canayquipa rantinga mas allim canman tsulla ñawillapis gloriaman chaptiqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tsaynölla juc warmita munaparnin maquiqui yatapaptinga tsay maquiquita rogurir jitariycuy. Infiernuman gaycushga canayquipa rantinga allim canman tsullan maquillapis gloriaman chaptiqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gamcuna musyayanquim Moises gellganganchö caynö ninganta: ‘Pipis warminpita raquicayta munarga divorciu papelta ruratsun raquicangan musyashga cananpä’. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tsaynö niptinpis nogaga caynömi nï: Pipis warminpita ama raquicätsuntsu. Warmin juc runawan mana puriycaptin raquicarga quiquin ollgu cagmi jutsayog caycan warmin juc runaman aywananpäpis. Tsaynöllam ollgu cagpis raquicashga warmiwan tarninga adulteriu jutsata ruraycan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tsaynömi gamcuna musyayanqui Moises gellganganchö caynö ninganta: ‘Imatapis ruranayquipä Diospa jutinchö aunicurga mana gongayllapa cumplinqui’. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Tsaynö niptinpis nogaga caynömi nï: Ama nunca juranquitsu Diospa jutinta jayarir ‘Por Dios’ nirnin. Tsaynölla ama juranquitsu ‘Por mi ciëlu’ nirnin o ‘Por Jerusalen’ nirninpis. Ciëloga Tayta Dios jamaräcunan trönunmi. Jerusalenga Tayta Dios acrangan marcam. Tsaymi ‘Por mi ciëlu’ o ‘Por Jerusalen’ nir jurarninga Tayta Diospa jutinta llutalla jayareg cuenta caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Waquinnam ‘Por mi vïda’ nirnin jurayan. Ni imata nirninpis ama jurayanquitsu. Tayta Diosllam munayyog caycan hasta agtsayquita yanaman ni yuragman ticratsinanpäpis. Tsaymi ‘Por mi vïda’ nir jurarnin Tayta Diospa jutinta llutalla jayareg cuenta caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jurayänayquipa rantin imatapis aunicurga aunicuyanqui cumpliyänayquipä. Y mana aunicur itsanga ama aunicuyanquitsu. Imatapis jurayparä aunicurga llutantam nicäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Musyayanquim Moises gellganganchö caynö ningantapis: ‘Pipis ñawiquita jipiptinga quiquinpa ñawintapis jipisquinqui. Tsaynölla quiruyquita jipishuptiquipis quiquinpa quiruntapis jipisquinqui’. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tsaynö niptinpis nogaga caynömi nï: Runa mayiqui imachöpis mana allita rurashuptiqui ama nanaparanquitsu. Lagyaycushuptiquipis jucag lädu cag cärayquitana camapaycunqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pipis demandashur camisayquita gechushuptiqui punchuyquitapis apacunanpä cachaparinqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Juc runa gepinta juc lëwa aywayyag apapänayquipä obligashuptiqui juc lëwa masyagpis päsatsipasquinquirä. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Imatapis mañacushuptiquega garaycunqui. Tsaynöpis imatapis ‘Mañaycallämay’ nishuptiquega mañaycunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tsaynöllam musyayanqui runacuna caynö niyanganta: ‘Cuyanacungayquiwanga cuyanacunqui. Chiquishogniquitaga chiquinqui’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tsaynö niyaptinpis nogaga caynömi nï: Chiquiyäshogniquicunataga cuyayanqui. Chiquishur contrashogniquicunapäpis Tayta Diosman mañacuyay cawayninchö yanapananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chiquishogniquicunata tsaynö cuyarga Tayta Diospa wamrancunam cayanqui. Tayta Diosga alli runacunapä y mana alli runacunapäpis rupayta ñawitsimunmi. Tsaynöllam alli rurag runacunapä y mana alli rurag runacunapäpis tamyatapis tamyatsimun. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cuyanacuyangallayquiwan cuyanacuyaptiquega manam ima premiutapis Tayta Dios goyäshunquitsu. Runacunapita chiquishga impuestu cobracogcunapis cuyanacuyangallanwanga cuyanacuyanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Cuyanacuyangallayquiwan saludanacurga ¿ima allitatä ruraycäyanqui? Tayta Diosman mana criyicogcunapis cuyanacuyangallanwanga saludanacuyanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tayta Dios cuyacog cangannö gamcunapis cuyacog cayay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Runacunata yanapar ama rurayaytsu tsayta ricayäshur alabayäshunayquillapäga. Tsaynö cayaptiquega Tayta Dios manam ima premiutapis goyäshunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Faltapacogcunata yanapayangayquita alabacurnin ama jucta juctarä willacuyanquitsu waquin runacunanöga. Paycunaga pillatapis yanapayangantaga willacurnin puriyan cornëtata tucar gayarätsegnöran goricäcuyänan wayicunachöpis y cällicunachöpis. Tsaynö cayaptinmi paycunapäga runacuna alabayangan premiulla canga. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gamcuna faltapacogcunata yanaparninga pitapis manam willapäyänayquirätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pitapis mana willapaypa faltapacogcunata yanapayangayquipitam Tayta Dios premiuta goyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Runacuna ricayänallanpämi waquin yachag tucogcunaga Tayta Diosman mañacuyan goricäcuyänan wayicunachöpis y cällicunachöpis. Gamcunaga paycunanö ama yachag tucuyanquitsu. Tsaynö yachag tucuyanganpitam paycunaga runacuna alabayangan premiullawanna cayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gamcunaga Tayta Diosman mañacurnin pipis mana ricayäshunayquipä wayiquicunaman wichgacurcur mañacuyanqui. Tsay mañacuyangayquita Tayta Dios wiyarmi imaycachöpis yanapayäshunqui. Y gloriachönam premiuta goyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Waquin runacuna Tayta Diosman mañacur yaparir yaparir juc niyanganllatam mañacuyan tsaynö mañacuyaptin Tayta Dios mas wiyananta yarpar. Gamcuna ama tsaynöga mañacuyanquitsu. Tsaypa rantinga mañacuyay mana llaquicuypa. Tayta Diosga manarä mañacuyaptiquim imata miñishtiyangayquitapis musyaycanna. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gamcunaga Tayta Diosman mañacuyay caynö: ‘Ciëluchö caycag Tayta Dioslläcuna, llapan runacuna gamta adorayälläshuy. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Munangayquinö llapan runacunapis gamllaman yäracamur cawaycuyätsun. Ciëluchö munangayquinölla cay patsachöpis camacaycullätsun. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cada junagpä micuylläcuna ama faltaycatsillaytsu ari. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Runa mayï mana alli ricamaptinpis noga perdonangänölla jutsäcunapita perdonaycayämay. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jutsaman Satanas ishquitsiyämayta munaptinpis tsapaycayällämay, y yanapaycayällämay llutancunata imaypis mana rurayänäpä. Tsaynö caycullätsun’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Gamcuna runa mayiquicunata perdonayaptiquega Tayta Dios gamcunatapis perdonayäshunquim. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Si gamcuna runa mayiquicunata mana perdonayaptiquega jutsata rurayangayquicunata Tayta Dios manam perdonayäshunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tayta Diosman mañacuyänayquipä ayunarga ama waquin runacunanö cayanquitsu. Paycunaga ayunar caycäyanganta runacuna tantiyayänanllapämi wamayashga puriycäyan. Tsayta ricar Tayta Diosman mañacog cayanganta runacuna alabayaptinnam paycunaga tsay premiullawanna cayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gamcuna ayunarninga imaypis cacuyangayquinö cärayquicunata shüpacur y agtsayquicunata nagtsacur cacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tsaynö rurayaptiquega runacuna manam musyayangatsu ayünuchö caycäyangayquita. Tsayta Tayta Dioslla musyarmi ayunar mañacuyangayquipita premiuta goyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Cay patsachö imaycayogpis cayllapä cagta ama yarpachacuyaytsu. Cay patsachöga imayca riquëzatam puyupis ushan, ismurpis ushacan, y runapis suwan. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cay patsachö rïcuyayllapä yarpachacuyänayquipa rantinga yarpachacuyay faltapacogcunata yanaparcuyänayquipä cagta. Tsaynö yanapanacur cawarga jana patsamanna imayca riquëzatapis churacog cuentanam caycäyanqui. Jana patsachöga mananam puyupis ushangatsu, ni ismurpis ushacangatsu, ni runapis suwangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Imaycayogpis cayllapä cagta yarpachacurmi manana Tayta Diosmanga yarpäyanquinatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mas alli canman cay ningäcunata cäsucuyaptiquim. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nogata mana cäsumarninmi Tayta Dios munangantaga ruraycäyanquitsu. Tsaymi tantiyacuyanquitsu tsacaychönö jutsa rurag cayangayquita”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Manam pipis ishcay patrontaga sirvinmantsu. Ishcay patronyog carga jucninta cäsucur jucagtaga manam cäsunnatsu. Jucninta cuyarnin jucagtaga mananam cuyannatsu. Tsaynöllam rïcuyayllapä yarpachacogcunapis ‘Tayta Diospa sirvegninmi cä’ nicarpis pay munangannöga mana cawayantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tsaynö parlapasquirpis caynömi nirgan: “Ama yarpachacuyanquitsu: ‘Canan ¿imatarä micushä? ¿Imatarä upushä? ¿Imatarä jaticushä?’ nirnin. Micuynintsic mana captinpis röpantsic mana captinpis cushicushun Tayta Dios cawayta gomangantsicpita. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Shumag tantiyacuyay pishgucuna imanö cawayangantapis. Paycunaga manam murucuyantsu, manam cosichayantsu, ni tröjacuyantsu. Tsaynö caycaptinpis Tayta Diosmi micuynincuna faltätsintsu. Gamcunaga tsay pishgucunapitapis mas välegmi cayanqui Tayta Diospäga. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tsaynö imaycapä mayläya yarpachacurpis ¿pirächi tamäñunpita masllataga jatunyarcunman?” ");
INSERT INTO qxoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Tsaynö caycaptinga ¿imanirtä gamcuna yarpachacuyanqui alli röpashga cayänayquipä cagllatarä? Tantiyacuyay waytacuna imanö cuyaypä tuctuyangantapis. Tsaycunaga manam aruyantsu ni putscacuyantsu. Peru nicarpis imanö cuyayllapämi ricacuyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Waytacuna cuyayllapä tuctuyangannöga manam unay rey Salomon jaticungan röpancunapis iwalargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tsay waytacuna tsaquirinanlla caycaptinpis Tayta Diosga ima shumagtam tuctutsin. Tsaynö cuyayllapäta tuctuycätsirga ¿manatsurä gamcunatanäga yanapayäshunquiman röpashga cayänayquipä, yäracuyniynag runacuna?” ");
INSERT INTO qxoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Tsaynö caycaptinga ama yarpachacur puriyaytsu: ‘¿Imatarä micushä? ¿Imatarä upushä? ¿Imatarä jaticushä?’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tsaycunata yarpachacurga puriyan Tayta Diosman mana yäracog runacunallam. Gamcunaga tsay mana yäracog runacunanö ama yarpachacuyaytsu. Tayta Diosga musyaycanmi imata miñishtiyangayquitapis. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ima miñishtiyangayquipäpis yarpachacuyänayquipa rantinga Tayta Dios munanganta rurar cawayänayquipä cagta yarpachacuyayga. Pay munangannö cawayaptiquega imata miñishtiyangayquitapis Tayta Dios manam faltätsingatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Tsaynö caycaptinga ama yarpachacuyaytsu waray junagpä cagtaga. Tayta Dios canan junag yanapayäshungayquinölla cada junagpis manam dejayäshunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ama runa mayiquipa vïdanta ashiyanquitsu, gamcunapis Tayta Diospita mana juzgashga cayänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Runa mayiquicunapa wasan rimayaptiqui tsay wasarima cayangayquillamanmi Tayta Dios gamcunatapis niyäshunqui mana alli rurag cayangayquita. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gamcunaga ¿imanirtä runa mayiquicunapa ñawinchö shucata jipicuriyänanta munar ricapäyanqui, quiquiquicunapa ñawiquicunachö geru cuentatarä jipicuriyänayqui caycaptin? ");
INSERT INTO qxoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ñawiquicunachö geru cuenta caycaptinga ¿imanöparä runa mayiquitarä niyanquiman: ‘Ñawiquichö shucata jipipasquishayqui’ nirnin? ");
INSERT INTO qxoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Yachag tucogcuna! Puntataga ñawiquicunachö cagtarä jipicuyay. Tsayrämi ricayta puëdiyanqui runa mayiquipa ñawinchö caycagta jipipänayquipäga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tayta Diospa alli willacuyninta willapäcuyaptiqui mana chasquicuyaptinga mejor ama willapäyanquinatsu. Willapar sïgiyaptiquega ajacurcuyangallanam. Tsaynö mana chasquicuycagta willaparninga alläpa chaniyog aläjata cuchi llutscananpä jitapaycog cuentam caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Imaypis Tayta Diosman mañacuyay. Imata miñishtirpis rugacuyay. Puncupita gayacognörä mañacuyay. Tayta Diosman mañacogcunaga chasquiyanmi. Imata miñishtirpis rugacogcunaga tariyanmi. Gayacogcunataga Tayta Dios wiyanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Gamcunata maygayquitapis wamrayquicuna tantata mañacuyäshuptiqui ¿rumitatsurä aptaparcuyanquiman? ");
INSERT INTO qxoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Y tsaynölla pescäduta mañacuyäshuptiquipis ¿culebratatsurä aptaparcuyanquiman? ");
INSERT INTO qxoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Gamcunaga mayläya yaga carpis wamrayquicunataga alli cagllatam garayanqui. Tsaynö gamcunapis caycäyaptiquega ciëluchö caycag Tayta Diosga masrämi imaycatapis allicunallata faltätsiyäshunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Runa mayiqui alli ricashunayquita munarga gamcunapis paycunata alli ricayay. Runa mayintsicwan tsaynö alli ricanacur shumag cawanantsicpämi Moises gellganganchöpis y profëtacuna gellgayanganchöpis nin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Ciëluman aywag nänega llanullam. Tsay näniman yaycuyänayquipäga puncupis quichquim. Peru infiernuman aywag nänim itsanga anchu. Tsay nänipaga puncunpis jatunmi. Tsaynö captinmi infiernumanga atsca runacuna aywaycäyan. Ciëlumanmi itsanga wallcaglla. Gamcunaga imaycanöpapis ciëluman chätsicog cag nänipa aywayay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“‘Diospa willacogninmi cä’ nir shamog llutan yachatsicogcunata ama chasquipäyanquitsu. Paycunaga Tayta Diosman criyicog tucullarmi runacunata yaycapäyan üshacunaman atog yachayllapa yaycognölla. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imanö cawayangantapis ricarmi musyayanqui mana alli willacog cayanganta. ¿Acäsu casha jachapitacu üvata pallantsic? Ni hïgustapis manam cardun jachapitatsu pallantsic. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Chirimöyaga manam goyrumshatatsu wayun. Tsaynöllam goyrumshapis mana wayuntsu chirimöyataga. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Ima jachapis mana allita wayungannömi mana alli willacogcunapis mana allicunata rurar cawayan. Tsaynö cawayaptinmi musyayanqui llutan yachatsicogcuna cayanganta. Chacracunachö goyrumsha captin siquipita muturir rupatseg cuentam paycunapis infiernuman gaycucäyanga rupayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manam jutïta jayarir ‘Señorllä’ niyanganllawantsu pipis gloriaman yaycuyanga. Gloriamanga yaycuyanga Tayta Dios munanganta rurar cawagcunallam. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Fisyu final junagchöga atscagmi niyämanga: ‘Señorllä, gampa willacuyniquitam willacur purirgä. Y gamman criyicurmi supaycunatapis runacunapita gargurgä. Tsaynöllam gamman yäracuynïwan milagrucunatapis rurargä’. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tsaynö niyämaptinpis nogaga caynömi nishä: ‘Gamcunaga manam cäsuyämarguyquitsu. ¡Ñöpäpita witicuyay, mana alli rurag runacuna!’ nirninmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Noga ningänö pipis cawag cagga alli cimientushga wayi shäritsishganömi caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pasaypa tamyaptin gashgay yacu shamurpis y vientuptinpis cimientushga wayega manam imananpistsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Noga yachatsingäcunata mana cäsucog runacunam itsanga allpa janallanchö shäritsishga wayinölla cayan. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsay cimientuynag wayitaga yacu goricar shamurninpis y feyupa vienturninpis juchuratsinmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus tsaynö yachatsicuptinmi tsaychö runacuna espantacur cushicuyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“¡Moises gellgangan leycunata yachatsicogcunapitapis Jesusga mas yachagmi!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jircanchö yachatsicunganpita Jesus urämuptin atscag runacunam gatiräyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tsay uraycämogmanmi juc leprösu Jesuspa ñöpanman gonguricuycur rugacurgan: “Taytay, cay geshyäpita alliycatsillämay” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsaynö rugacur niptinmi Jesus yataycurgan: “Cananpitaga allisquishganam canqui” nir. Tsaynö nisquiptinmi jinan öra tsay lepra geshyan allisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nircurmi Jesus nirgan: “Ama pitapis willanquitsu noga allïtsingäta. Tsay willacunayquipa rantinga Moises gellganganchö ningannölla templuman ayway Diospä ofrendata apacurcur sacerdöti ricashunayquipä. Sänuna cangayquita sacerdöti nishuptiquim itsanga llapanpis musyayanga rasunpa allishgana cangayquita”. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tsaypita Capernaum marcaman Jesus chäriptinnam Roma soldäducunapa juc capitannin Jesusman aywaycur rugar caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Taytay, wätaynïchä pasaypa antsa wayïchö ujuraycan. Mananachä cuyupacunnapistsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tsaynö niptinmi Jesus nirgan: “Canantämi aywä allïtsinäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsaynö niptinmi capitan nirgan: “Taytay, Israel runacunawan mana chänacuycäyaptëga ¿imanöparächi wayïman aywanquiman? Tsaypa rantinga cayllapita niycullay wätaynï allisquinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nogapis mandamagnïpa munayninchömi callä. Tsaynöllam nogapa munaynïchö caycäyan mandangä soldädücunapis. Maygantapis imamanpis mandaptëga aywanmi. Maygantapis ‘Gam shamuy’ niptëga shayämunmi. Imatapis rurananpä mandaptëga wätaynïpis rurayanmi. Gamga nogapitaga imaycawanpis mas munayyogmi canqui. Noga musyämi imapis ningayquega ruracasquinanpä cagta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitan tsaynö niycuptin Señor Jesusga feyupam cushicurgan. Tsaynam gatiragnin runacunata nirgan: “Cay runanö rasunpa yäracuyyog runawannöga manam Israel runacunachöpis tincurgötsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gloriamanga atscagmi chäyanga rupay ñawimunan cag lädupita y rupay jeganan cag lädupitapis. May tucuypitapis chaycur gloriachömi Abrahamwan, Isaacwan y Jacobwan jamacuyanga micuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Peru waquin runacunam itsanga Diospa willacuyninta yacharpis nogaman mana yäracayämunganpita gloriamanga chäyangatsu. Gloriaman mana chagcunaga pasaypa tsacayman gaycushgam cayanga. Tsaychömi pasaypa wagarnin imanö caytapis manana puëdir quiruncunatapis uchuyangarä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsaynö nisquirnam capitanta Jesus nirgan: “Cananga wayiquipa cuticuy. Yäracamungayquinöllam wätayniqui allishgana caycan” nir. Tsay ningan öram capitanpa wätaynin allisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsaypita Pedrupa wayinman Jesus aywarnam tarirgan Pedrupa suegran pasaypa antsa achacharnin cämachö ujuraycagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsaynam geshyagpa maquinta Jesus yataycuptin jinan öra allisquirgan. Allisquirnam juclla cusnacurgan paycunata garananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Patsa tsacaycaptinnam apayämurgan Jesusman supay geshyatsingan runacunata. Tsay supaycunatam Jesusga juc shimillachö runacunapita gargurgan. Tsaynöllam imaycaläya geshyawan geshyagcunatapis allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tsaycuna ruracänan captinnam Diospa unay willacognin profëta Isaias caynö gellgargan: “Salvacog shamogmi geshyaycag runacunata allïtsinga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Atsca runacuna gorirapäyaptinnam discïpuluncunata Jesus nirgan: “Listacuyay büquiwan gochapa wac-tsimpanman päsanapä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Büquiman yarcuyänanpä caycaptinnam Moises gellgangan leycunata yachatsicog juc runa Jesusta nirgan: “Maypa aywaptiquipis gamtaga gatiräshayquim, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tsaynö niptinmi Jesus nirgan: “Atogcunapaga machaynincuna canmi. Pishgucunapapis geshuncuna canmi. Peru noga Tayta Diospita shamogpaga manam ni juc wayïllapis cantsu maychö punuycunällapäpis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsaypitanam juc discïpulun nirgan: “Tayta Jesus, papänï wanuptin pampaycurga gamta gatishayquim”. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tsaynö niptinnam Jesus nirgan: “Pampaytarä shuyacunayquipa rantinga juclla nogawan aywacushun. Wanogcunataga quëdagcunanachir pampacuyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsaynö nisquirnam discïpuluncunawan büquiman Jesus yarcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gochata aywaraycäyaptinnam Jesusga gepamanpachö punucasquirgan. Tsayyagnam feyupa vientuwan yacu lagchicachar gallaycurgan büquitapis jundicätsiytana munarnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsaynam discïpuluncuna Jesusta ricchatsir niyargan: “¡Ricchay, salvaycayämay, taytay! ¡Jundicaycantsicnachä!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tsaynö niyaptinnam Jesus nirgan: “¿Imanirtä tsayläya mantsacäyanqui? ¿Manacu nogaman yäracayämunqui?” Tsaynö nisquirnam ichircur vientutapis yacutapis päracunanpä nirgan. Y jinan öram tsaynö niycuptin vientupis yacupis pärasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tsayta ricarnam discïpuluncunaga espantashga quiquin pura ninacuyargan: “Yacupis vientupis cäsuycunanpäga ¡ima runanatä cay runaga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gochata päsarirnam discïpuluncunawan Jesus chäyargan Gadara marcapa washaläninman. Tsaychönam supay löcuyätsingan ishcay runacuna panteonpita yargayämurgan. Tsaychö tsay demöñuyog runacuna pasaypa mantsaripä cayaptinmi tsay panteon puncupaga pipis päsayagtsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesusta ricasquirnam tsay ishcay runacuna mantsarir gayararnin niyargan: “¡Diospa tsurin Jesus! Manarä öräcunachömi cayman shamurguyqui infiernuman gaycayämänayquipäna” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paycuna cayanganpita mas washalänin quinrannam atsca cuchicuna micuycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsaymi tsay supaycuna rugacuyargan Jesusta: “Cay runacunapita gargayämarga tagay cuchicunallaman yaycucuycuyänäpä cachaycayällämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tsaynö niyaptinnam Jesus nirgan cuchicunaman aywacuyänanpä. Tsaynam supaycuna ishcan runacunapita yargusquir jegacuycuyargan tsay cuchicunaman. Cuchicunanam acataycachaycar tunapita gochaman jegarpäriyargan. Tsaychömi augacaypa llapan cuchicuna wanuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tsayta ricaycurnam cuchi mitsegcunaga cörrilla aywayargan marcaman. Chaycurnam runacunata willacuyargan löcuyashga runacunapita supaycunata Jesus gargunganta y cuchicuna gochaman jegar wanuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsaycunata willacuyaptinnam runacuna aywayargan Jesus caycanganman ima päsangantapis ricagnin. Tsayman chaycarnam mantsarirnin Jesusta niyargan tsay marcancunapita jucläpa aywacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsaypitanam büquiman yarcurcur Jesusga cuticurgan taycangan Capernaum marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsaychöna Jesus caycanganta musyasquirnam pullan cuerpun wanushga geshyagyashga runata andamiawan wantushga chätsiyargan. Señor Jesusga payman yäracuyanganta musyarnam tsay geshyagta nirgan: “Hïju, ama llaquicuytsu. Jutsa rurayniquicunata perdonargönam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsaynö niptinmi Moises gellgangan leycunata waquin yachatsicogcuna yarpachacuyargan: “¡Dios tucurnin tsaynö nirga Tayta Diospa contranmi llutanta parlaycan!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tsaynö yarpaycäyanganta musyarnam Jesus nirgan: “¿Imanirtä gamcuna llutanta yarpäyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¡Shumag tantiyacuy! ¿Runapa jutsancunata perdonaycu o geshyancunata allïtsiycu, maygantä mas aja? ");
INSERT INTO qxoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nogaga Tayta Dios cachamashga captinmi munayyog cä runacunapa jutsancunata perdonanäpä. Tsayta musyayänayquipämi cay runata allïtsimushä”. Tsaynö nisquirnam tsay geshyagyashga runata nirgan: “¡Sharcuy! Andamiayquita apacurcur wayiquipa aywacuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsaynö niycuptinmi tsay runa jinan öra allisquir wayinpa aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tsayta ricaycurmi runacuna pasaypa espantashga cushicurnin Tayta Diosta alabayargan caynö nir: “¡Tayta Dios yanapaptinmi tsaycunata Jesus ruraycan! ¡Manam imaypis mayarguntsictsu pipis caynö ruragtaga!” ");
INSERT INTO qxoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsaypita aywacurnam Jesus ricargan Mateo jutiyog juc runata. Mateoga Roma nacionpä impuestu cobracogmi cargan. Tsaynam cobrar jamaraycagta ricaycur Jesus nirgan: “Discïpulü canayquipä acu, aywacushun” nir. Tsaynö niptinmi Mateo sharcur Jesuswan aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsaypitam Mateupa wayinchö Jesus discïpuluncunawan micuycäyaptinna chäyargan waquin invitäduncuna. Paycunaga cayargan Romapä impuestu cobracog mayincunam y waquin mana alli ricashga cag runacunam. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tsayta ricarnam fariseucunaga jamurarnin Jesuspa discïpuluncunata niyargan: “¿Imanirtä mayistruyquicunaga juntacan impuestu cobracogcunawan y tsay waquin jutsachö cacog runacunawanpis?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Tsaynö niyanganta wiyarnam Jesus nirgan: “Nogaga shamurgö manam alli rurag runacunallamantsu Diospa willacuyninta willapagnin, sinöga shamurgö jutsachö cawacogcunatapis willapänäpämi. Tayta Diospa palabran gellgaranganchöpis caynömi nican: ‘Manam ashmacunata altarchö rupatsiyänallayquitatsu munä, sinöga cuyapäcog cayänayquitam munä’ nirmi. Tsaynö nicaptinpis gamcunaga ¿imanirtä mana alli ruragcunatapis cuyapäyanquitsu? Llapanpis Diospa willacuynintaga tantiyatsiyänanta miñishtiycäyanmi, geshyagcuna jampicogta miñishtiyangannölla. Tsaymi paycunawanpis nogaga juntacü Diospa alli willacuyninta tantiyatsinäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juc cutichönam Juan Bautistapa gatiragnincuna Jesusman witiycur tapuyargan: “Nogacuna y fariseucunaga imaypis ayunayämi. Peru gampa discïpuluyquicunaga ¿imanirtä ayunayantsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tsaynam Jesus nirgan: “Jucta niyäshayqui. Juc casacuy fiestachö ¿compañagnincuna ayunayantsurä? Tsaynöllam discïpulücunapis nogawan caycarga ayunayänantsu. Noga wanusquiptïmi itsanga ayunayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tsaynö manam pipis macwa röpata remendantsu mushog ratashwanga. Tsaynö remendayaptinga mushog ratashga genticätsirmi macwa cagtaga rachicäratsinman. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tsaynömi tsayrä puwatsishga aswataga mana pipis jirpuntsu tsillinaycag urpumanga. Tsay tsillinaycag urpuman jirpushgaga aswa pogurmi tsay urputa masrä tsillicäratsinman. Tsaynam aswapis ushacanman y urpupis paquicar ushacanman. Tsaynö captinmi sänu urpuman tsayrä puwashga aswataga jirpuntsic. Tsaynömi nogapa willacuynïpis mushog car gamcunapa üsuyquicunamanga iwalantsu. Tsaymi discïpulücunata niyänayquitsu nogawan caycäyanganyagga ayunayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsaynö parlaycaptinmi Israel runacunapa autoridänin juc runa chaycur Jesuspa ñöpanman gonguricuycur nirgan: “Taytay, warmi tsurillächä wanusquishga. Acuri jinallachö aywayculläshun cawarircatsillämunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsaynö rugacuptinmi discïpuluncunawan Jesus aywayargan tsay runapa wayinman. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Nänita aywaycäyaptinnam chunca ishcay (12) watana yawar apaywan geshyacog juc warmipis gepancunata aywargan caynö yarpar: “Jesuspa röpallantapis yataycurga allisquishämi” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tsaynö nir yataycuptinnam Jesusga gepapa ticraycur warmita nirgan: “Ama llaquicuytsu, hïja. Nogaman yäracamuyniquipam allisquirguyqui” nir. Tsaynö niycuptin tsay warmega allisquirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tsaypita tsay Israel runacunapa autoridäninpa wayinman chaycurnam tariyargan ayachö müsicucuna tucaycäyagta y runacunapis pasaypa wagaycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tsayta ricaycurmi Jesus nirgan: “Wagtapa yargucuriyay. Cay wamraga cawarimunga punucashga caycanganpita riccharcamognöllam” nir. Tsaynö Jesus niptinnam runacuna asicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Peru imanö captinpis Jesus ningannöllam wagtaman yargacarayämurgan. Runacuna yargacarayämuptinnam wanushga caycag wamra sutaraycanganman Jesus yaycurgan. Nircurnam maquinpita tsarircur wamrata cawatsir sharcatsimurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tsaynö cawaritsir milagruta rurangantaga maytsay marcacunamanpis willacur chätsiyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsaypita Jesus aywacuptinnam ishcay gapracuna gatipäyargan: “¡Unay rey Davidpa castan Jesus, ñawilläcunata alliscatsiyällämay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tsaynö nir gatiraycäyaptinmi patsacungan wayiman Jesus yaycurirgan. Tsaychönam tsay gapracunata Jesus tapurgan: “¿Gamcuna criyiyanquicu ñawiquicunata allïtsinäpä cagta?” nir. Tsaynö niptin paycunanam niyargan: “Aumi, taytay. Criyiyällämi alliycatsiyämänayquipä cagta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsaynam ñawincunata Jesus yataycur nirgan: “Nogaman yäracayämungayquipita ñawiquicuna allisquitsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsaynö nisquiptinmi juclla ñawincuna allisquirgan. Tsaypitam paycunata Jesus nirgan: “Ama pitapis willapäyanquitsu allïtsingäta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tsaynö nicaptinpis paycunaga yargurillarnam pitapis maytapis willacuyargan Jesus allïtsinganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tsay gapracuna jegariyaptinnam Jesus caycanganman runacuna apayämurgan shimin mana parlag juc runata. Tsay runataga supaymi upayätsishga canä. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tsay runapita supayta Jesus garguriptinmi upayashga caycanganpita juclla parlar gallaycurgan. Tsayta ricarmi runacuna cushicur niyargan: “¡Manam imaypis ricarguntsictsu pipis caynö allïtsicogtaga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tsaynö niyaptin fariseucunam itsanga niyargan: “Manam Tayta Diospa poderninwantsu supayta tsay runapita gargushga, sinöga supaycunapa mandagnin Satanaspa poderninwanmi gargushga” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Maytsay marcacunachöpis estanciacunachöpis Jesusga Tayta Diospa alli willacuynintam yachatsicurgan goricäcuyänan wayicunachö. Nircurmi imaycaläya geshyawan geshyagcunatapis allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tsaynö maytsay marcacunapa purirmi Jesusga ricargan runacuna imayca mitsegniynag üshacunanö cayagta. Tsaynö lluta cawacuyanganta ricarmi Jesus cuyapargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsaymi discïpuluncunata nirgan: “Cosëcha poguraycagnöpis maytsicag runacunam caycäyan Tayta Diospa alli willacuyninta juclla chasquicuyta munagcunaga. Tsaynö captinpis wallcagllam tsay alli willacuyta willacogcunaga cayan. ");
INSERT INTO qxoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsaynö captin gamcuna Tayta Diosman mañacuyay willacogcuna mas atsca cayänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tsaypitanam chunca ishcay (12) discïpuluncunata Jesus nirgan supaycunata runacunapita garguyänanpä y tucuyläya geshyawan geshyagcunata allïtsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tsay apostolcunaga cayargan: Simon (Simonpa jucag jutinmi cargan Pedro), Simonpa waugin Andres, Zebedeupa tsurincuna Santiaguwan Juan, ");
INSERT INTO qxoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolome, Tomas, Mateo (Mateoga Roma nacionpä impuestuta cobragmi cargan), Alfeupa tsurin Santiago, Tadeo, ");
INSERT INTO qxoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Celote” ningan Simon, y Jesusta ranticog Judas Iscariote. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tsay chunca ishcay apostolnincunata Jesus willacog cacharnin caynömi nirgan: “Ama aywayanquitsu mana Israel runacunapa marcancunamanga, ni ama yaycuyanquitsu Samaria provincia marcacunamanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tsaypa rantinga Israel runacunallaman aywayanqui. Paycunam ogracashga üshacunanöga caycäyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Paycunata willapäyanqui: ‘Tayta Dios cachamunanpä cag salvamagnintsic rey chämushganam’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Geshyagcunata allïtsiyanqui. Wanushgacunatapis cawaritsiyanqui. Lepra geshya ushaycagcunatapis allïtsiyanqui. Y supaycunatapis runacunapita garguyanqui. Allïtsirga ama pitapis cobrayanquitsu. Nogapis gamcunata manam cobrätsu allïtsiyänayquipä podernïta gornin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Ama apayanquitsu gellëta ni millcapata ni trocanayquicunata. Jatiräyangayqui llangiquicunallawan aywayanqui. Arupacogcunata pachancuna mana faltaypa garayangannömi mayman chäyangayquichöpis mana faltätsiyäshunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“May marcaman o may jallgacunaman charpis tapucuyanqui mayganpis alli runa canganta. Alli runaman charninga wayillanchö patsaräcuyanqui juc marcaman päsayangayquiyag. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tsay patsatsiyäshog runapa wayinman char shumag saludacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tsay wayiyog chasquiyäshuptiquega payllachö patsaräcuyanqui. Mana chasquiyäshuptiquega jucmanna päsacuyanqui posädata ashirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Runacuna willacuyangayquita mana chasquicuyaptinga tsay marcapitapis yargur aywacuyanqui chaquiquicunapita polvuta tapsirir. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Willacungayquita mana chasquicog runacunaga fisyu final junagmi castïguta chasquiyanga. Sodoma y Gomorra marcacunachö tagcuna castigashga cayanganpitaga masmi castigashga cayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Shumag tantiyacuyay. Gamcunataga cachaycä üshacunata atogman gaycapag cuentam mana alli runacuna cayanganman. Tsaynö caycaptinga culebranöpis maya-mayalla puricuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chiquiyäshogniqui runacunaga autoridäcunamanpis apatsiyäshunquim. Waquincunaga goricäcuyänan wayicunachöpis magayäshunquim. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nogaman criyicamog cayangayquipitam autoridäcunamanpis y nacion mandag reycunamanpis apayäshunqui castigayäshunayquipä. Tsaychömi paycunatapis y waquin mana Israel runacunatapis musyatsiyanqui noga runacunata salvanäpä shamungäta. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Tsaynö autoridäcunaman entregayäshuptiquipis ama llaquicuyanquitsu: ‘Cananga ¿imatarä niycushä?’ nirnin. Paycunapa ñöpanchö manam quiquiquicunapa yarpayllayquicunapitatsu parlayanqui. Espiritu Santum tantiyatsiyäshunqui imata parlayänayquipäpis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nogaman criyicamunganpitam chiquirnin wauginta autoridäcunaman entregayanga wanutsishga cananpä. Waquinnam tsurincunata entregayanga wanutsiyänanpä y waquinnam taytantapis entregayanga wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nogata chasquicamar criyicayämungayquipitam pipita maypitapis chiquishga cayanqui. Tsaynö chiquishga carpis hasta wanuyanganyagpis nogaman yäracamog cagmi Tayta Diospa ñöpanman chäyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcachö chiquiyäshuptiquega juc marcaman empëñu päsacuyanqui. Llapan Israel nacion marcacunaman manarä chäyaptiquim nogaga cutimushä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Ama yarpäyaytsu noga raycur imaypis mana chiquishga cayänayquipä cagtaga. Nogata runacuna chiquiycäyämarga gamcunatanäga masrämi chiquiyäshunqui. Nogatapis ‘¡Satanasmi payga!’ nicäyämarga gamcunatapis Satanaspita cayangayquitam niyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Cay patsachö runacuna chiquiyäshuptiquipis mana mantsariypa willacuynïtaga willacuyay. Tsaynö allita rurar willacuyaptiqui runacuna mana chasquicuyanganpis musyacangam Tayta Dios fisyu final junagchö juzgaptin. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tsaynö caycaptinga willacungäta mana wiyag cagcunataga gamcunana pita maytapis willacuyanqui. Tsaynö willacuyänayquipämi gamcunata willapaycä. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nogapa willacuynïta willacuyaptiqui runacuna wanutsiyäshurpis almayquicunataga manam imanayangatsu. Tsaynö caycaptinga manam pitapis mantsacuyänayquitsu. Paycunapita mantsacuyänayquipa rantinga Tayta Diosllata mantsacuyay. Paymi munayyog caycan almantinta infiernuman gaycunanpäpis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Pishgucuna runacunapä mana alläpa cuestaptinpis Tayta Diospäga välinmi. Wanunanta mana munaptinga ni jucllayllapis manam wanuyantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tsaynömi agtsayquicunatapis yupashgata payga caycätsin. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pishgucunapitapis mas väleg cayaptiqui Tayta Dios cuïdaycäyäshuptiquega pipitapis manam mantsariyänayquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pipis nogaman criyicog canganta mana pengacuypa willacuptinga nogapis Tayta Diospa ñöpanchö paycunapa favorninmi parlashä. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pipis nogapita pengacur willacuynïta mana willacuptinga nogapis Tayta Diospa ñöpanchö paycunata ‘Manam regïtsu’ nishämi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ama yarpäyaytsu nogaman criyicayämungayquipita mana chiquishga cayänayquipä cagta. Criyicamogcunataga imaypis chiquiycäyangam. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nogaman criyicamunganpitam tsurinpis taytanpa contran canga. Tsaynöllam mamanpa contran wawanpis canga. Y llumtsuyninpis suegranpa contranmi canga. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tsaynömi ari chiquiyäshogniquicunaga cayanga quiquiquicunapa castayquicunapita gallaycur”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nogaman criyicamunganpita maman chiquiptinpis, taytan chiquiptinpis, o tsurin chiquiptinpis noga ningäta rurar imaypis cawatsun. Peru noga ningäcunata mana cäsumar mamanpa, taytanpa, o tsurinpa munayninchö cacog cagga manam rasunpatsu criyicamun. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Imaycachö ñacarpis nogaman criyicamur cawayätsun. Wanunganyag noga ningäcunata mana cäsumag cagcunaga manam rasunpatsu nogaman criyicayämun. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noga munangänö mana cawar quiquin munangannö cawagcunaga infiernumanmi gaycucäyanga. Imayca ñacaychö carpis noga munangänö cawagcunam itsanga gloriaman chäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Gamcunata pipis chasquiyäshurga nogatapis chasquiycäyämanmi. Y nogata chasquimarga cachamagnï Tayta Diostapis chasquiycäyanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tayta Diospa willacogninta chasquicogcunaga gloriaman char willacogcuna premiuta chasquiyangannöllam chasquiyanga. Tsaynöllam Tayta Dios ninganta cumplir alli rurag runata chasquicog cagpis gloriaman char tsay alli rurag runa premiuta chasquingannölla chasquiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nogata chasquicamag cagta pitapis yacullanpis garaycog cagga Tayta Diospitam premiuta chasquinga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tsaynö chunca ishcay (12) apostolnincunata willapayta ushasquirmi Jesusga Galilea provinciapa marcancunapa purirgan Diospa alli willacuyninta willacurnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Carcelchö caycarmi Juan Bautista mayargan Señor Jesus milagrucunata ruraycanganta y Diospa alli willacuyninta willacur puriycanganta. Tsaynam discïpuluncunata Jesusman cachargan caynö tapuyämunanpä: ");
INSERT INTO qxoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“¿Gamcush canqui Tayta Dios cachamungan salvacog, o juctaräcush shuyacuyäshä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tsaynö tapuyaptinnam Jesus nirgan: “Canan aywar Juanta niyay cay ricaycäyangayquicunata y wiyaycäyangayquicunata. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gapracuna ricayannam. Mana puriyta puëdegcuna puriyannam. Leprawan geshyagcunapis allïyashgam. Upacunapis wiyayannam. Wanushgacunapis cawariyämushgam. Muchuychö cawagcunamanpis Diospa alli willacuyninga chaycannam. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tsaycunata willayaptiquim cushicunga nogapita. Nogaman imaypis yäracamungannölla yäracamutsun”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tsaypita Juan Bautistapa cachancuna cuticusquiyaptinnam runacunata Jesus Juanpita parlapar nirgan: “Tsunyag jircaman Juanta ricapäyänayquipä aywar manam jachata vientu cuyutsegman ricapagtsu aywayargayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Y manam alläpa chaniyog röpan jatishga canganta ricapäyänayquipätsu aywayargayqui. Tsaynö chaniyog röpashgacunaga reypa wayincunallachömi taycäyan, manam tsunyagcunachötsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Manam tsaycunata ricagtsu aywayargayqui, sinöga Tayta Diospa willacognin profëta canganta ricayänayquipämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanpämi Tayta Diospa palabran gellgaranganchö nican: ‘Salvacog manarä willacuptinmi juctarä cachashä willacuynïta willacunanpä. Pay willacunganta chasquicurmi runacuna jutsa ruraynincunata jagirir salvacogta shuyacur alistacuyanga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tsay ningannölla Tayta Dios Juanta willacognin cananpä acrashga captinmi puntataga Juanrä tantiyashga noga salvacog rey cangäta. Tsaynö captinpis discïpulücunam nogawan purishga carnin Juanpitaga maslla willacuynïta tantiyacuycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Moises gellgangancunachöpis, Tayta Diospa profëtancuna gellgayangancunachöpis, y Juan Bautista willacungancunapis nican noga salvacogniquicuna cay patsaman shamunäpä cagtam. Tsaymi Juan willacur gallanganpitapis runacuna Tayta Diospa willacuynintaga chasquicuycäyan. Tsaynö captinpis waquin runacunaga manam munayantsu willacuyninta willacunanta, sinöga imaycanöpapis tsapatam churapaycäyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tsaynöllam Tayta Diospa palabranga gellgaraycan Elias shamur willacunanpä cagpis. Tantiyayaptiqui mana tantiyayaptiquipis Juan Bautista willacuptinmi cumplishga Elias shamur willacunanpä gellgarangan. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tsay ningäcunata wiyacog cagga shumag tantiyacuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Tsaynö nisquir Jesus mastapis nirganmi: “Canan tiempu runacunaga yupay tucog wamracunanömi caycäyan. Manam chasquicuyantsu noga ningäcunata ni Juan Bautista ningancunata. Wamracuna pucllar pinculluta tucapaptin yanasancuna tushuyta mana munagnömi noga ningäcunatapis mana chasquicuyta munayantsu. Tsaynö ‘Aya pampayta pucllar nogacuna cantayämushä, gamcuna wagayämunqui’ niyaptin yanasancuna wagayta mana munayangannömi Juan Bautista ningancunatapis mana chasquicuyta munayantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan Bautistaga imaypis ayunarmi mana vïnuta upogtsu. Tsaynö captinmi niyag ‘¡Payga Satanaspa munayninchö carmi tsaynö cacun!’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Noga runacunawan juntacar imaycatapis micuptï y vïnuta upuptïnam niyäman ‘Micullar upullar puricun’ nirnin. Tsaynömi niyäman ‘Payga jutsasapa runacunawanpis y impuestu cobrag sacyapacogcunawanpis juntacanmi’ nirnin. Tsaynö niyämaptinpis Juantawan nogataga Tayta Diosmi cachayämashga willacuyninta willacuyänäpä. Tsaynö cachayämanganta runacuna tantiyacuyanga Tayta Dios munanganta ruraycäyangäta ricarmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Imayca milagrucunata ruraycaptinpis waquin marcacunachöga runacuna manam ichicllapis Jesuspa willacuyninta cäsuyargantsu. Tsaymi paycunapä Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Corazin marca runacuna y Betsaida marca runacuna, ¡gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui! Gamcunachö milagrucunata rurangänö Tiro y Sidon marcacunachö milagrucunata ruraptëga maynam Tayta Diosta perdonta mañacur jutsa ruraynincunata dejariyanman cargan. Tsaynö jutsancunapita llaquicurnin maynam arripenticur cotenciapita röpata jaticurcur uchpaman jamaycur wagayanman cargan. Gamcunaga milagrucunata rurangäta ricaycarpis manam jutsa rurayniquicunata dejayta munayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tsaynö jutsa rurayniquicunata mana dejayangayquipitam fisyu final junagchö Tiro y Sidon runacunapitapis masrä castigacäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum marca runacuna, ¿gamcunaga ‘Tayta Diospa ñöpanmanmi chäshä’ niyanquipischi? Tayta Diospa ñöpanman chäyänayquipa rantin gamcunaga infiernullamannam gaycucäyanqui. Gamcunachö milagrucunata rurangänö Sodoma marcachö ruräman cargan, cananyagmi tsay marca caycanmanrä cargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tsaymi gamcunaga Sodoma runacuna castigacäyanganpitapis masrä castigacäyanqui fisyu finalchö”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tsaypitanam Tayta Diosman Jesus mañacur nirgan: “Papällä, ciëluchö y cay patsachöpis imaycawan munayyogmi gamga caycanqui. Gamta alaballämi, Tayta Dios. Yachag tucogcunata tantiyatsinayquipa rantinga llänu runacunachömi tantiyatsicurguyqui nogata cachamangayquita. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tsaynö cananpä yarpangayquinöllam ruracashga, papällä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nircurnam discïpuluncunata nirgan: “Papällämi llapantapis munaynïman churamushga, tsurin captï. Noga imanö cangätapis payllam musyaman. Tsaynöllam papällä imanö cangantapis nogalla musyä. Tsaymi tantiyatsingä cagcunalla musyayanqui Tayta Dios imanö cangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tayta Dios munangannö cawayta mana camäpacogcuna, nogata chasquicayämay. Chasquicayämaptiquega llapayquitam yanapayäshayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yachatsingänölla cawayay. Tsaynö cawarmi tantiyacuyanqui cuyapäcog cangäta y mana runa tucog cangäta. Tsaynöpam alli cawayta tariyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noga yanapaptï munangänö cawayga manam ajatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tsaypita juc säbadu jamapay junagchömi discïpuluncunawan Jesus päsaraycäyargan poguraycag trïgu cuchunpa. Tsaynam discïpuluncunaga mallagarnin trïguta pallascärir cuparir uchuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tsaycunata ricarnam fariseucuna Jesusta niyargan: “Säbadu jamapay junag mana arucuy caycaptin ¿imanirtä discïpuluyquicuna trïguta pallaycäyan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsaynam Jesus nirgan: “Atsca cuti liyiycarpis ¿manacu gamcuna tantiyayanqui unay David gatiragnincunawan mallagar imata rurayangantapis? ");
INSERT INTO qxoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Paymi Tayta Diosman mañacucuyänan wayiman yaycurir tsaychö consagrädu churarag tantata gatiragnincunantin micuyargan. Tsay tantata sacerdöticunalla micuyänanpä caycaptinpis tsayta micur Davidga manam ima jutsatapis rurargantsu. Mana micunanpä cagta David micuptinpis allita ruranganta yarparga ¿imanirtä niyanqui discïpulücuna säbadu jamapay junagchö trïguta pallarir uchuyangan jutsa canganta? ");
INSERT INTO qxoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Gamcunaga Moises gellganganta atsca cuti liyiycarpis ¿manacu tantiyayanqui säbadu jamapay junag templuchö sacerdöticunapapis imayca ruraynincuna jutsa mana canganta? ");
INSERT INTO qxoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tsaynöllam nogapa discïpulücunapis conviënegllata ruraycäyan. Tsaynö carmi mana jutsatatsu ruraycäyan säbadu jamapay junagchö mana jamaparpis. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gamcunaga manam tantiyacuyanquitsu Tayta Diospa palabran gellgaranganchö caynö ninganta: ‘Nogapa jutïchö ashmacunata altarchö rupatsiyangayquipitapis masga munä runa mayiquicunata cuyapäyänayquitam’ nir. Tsaycunata tantiyacurga manam discïpulücunapä imatapis parlacachäyanquimantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tsaynö captinmi noga Tayta Diospita shamushga car munayyog caycä säbadu jamapay junagchöpis runacuna imata rurayänanpä cagtapis ninäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsaypita aywarnam Jesus yaycurgan Tayta Diosman mañacur goricäcuyänan wayiman. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tsaychö goricag runacunawanmi caycargan maquin wanucashga runapis. Tsay wayichö caycag waquin fariseucunanam Jesusta tapuyargan: “Säbadu jamapay junag caycaptin maquin wanucashga runata ¿allïtsinquimancu o manacu?” nir. Tsaynö tapuyargan allïtsiptinga tsay achäquilla Jesuspa contran sharcuyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tsaymi Jesus nirgan: “Maygayquipapis üshayquicuna pözuman jegacurpuptin ¿manatsurä jinan öra jipeg aywayanquiman, säbadu jamapay junagchöpis? ");
INSERT INTO qxoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Runacunaga üshapitapis alläpa mas cuyaymi. Tsaynö captinmi säbadu jamapay junagchöpis allita rurarnin cay geshyagta allïtsimushä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nircurnam tsay maquin wanucashga runata Jesus nirgan: “Maquiquita mashtamuy” nir. Tsaynö niptin maquinta jayarircuptinnam sänuna ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Säbadu jamapay junagchö tsaynö allïtsinganta ricarnam fariseucuna tsay goricäcuyänan wayipita yargurir willanacuyargan Jesusta imanöpa wanutsiyänanpäpis. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsaynö fariseucuna willanacuyanganta musyarnam Jesusga tsaypita aywacurgan. Y atsca runacunam gepanta aywayargan. Gepanta aywagcunataga imayca geshyancunapitapis Jesus allïtsirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tsaynö allïtsirmi nirgan: “Ama pitapis willacuyanquitsu noga allïtsingäta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesus tsaynö cuyapäcog cananpämi unay profëta Isaias gellgargan Tayta Dios caynö ningancunata: ");
INSERT INTO qxoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Willacuynïta willacunanpä cachamungä salvacog runa munangäcunata ruraptinmi cushicü. Payman Espiritu Santuta cachaptïmi mana dejaypa yanapanga. Tsaynöpam pitapis maytapis willapanga willacuynïta chasquicogcunata salvanäpä cagta y mana chasquicogcunata infiernuman gaycunäpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Runacuna gayapäyaptinpis manam imatapis ningatsu. Maypa tsaypa purirpis manam parlangatsu: ‘Nogaga mas yachagmi cä’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Llaquicuyyogcunata manam lïsu tupangatsu, sinöga cuyapangam. Jutsa rurag runacunata manam jucllatsu castiganga, sinöga yätsingam munangäta rurarna cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tsaynöpam maychö tsaychö runacunapis payman yäracur salvacäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsaypitanam supay wiscuyätsingan upayashga runata Jesus cagman chätsipäyargan allïtsinanpä. Tsay runapita supayta Jesus garguriptinmi parlarganna y ricarganna. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tsaynö allïtsegta ricarmi runacuna cushicur ninacuyargan: “¿Salvamänantsicpä Tayta Dios cachamungan David castatsurä payga canman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsaynö niyanganta wiyarnam fariseucuna niyargan: “Cay runaga manam Tayta Diospa poderninwantsu supayta tsay runapita gargun, sinöga supaycunapa mandagnin Satanaspa poderninwanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tsaynö parlaycäyanganta musyarnam Jesus nirgan: “Manam yarpaycäyangayquinötsu. Cay ningäta wiyarcayämay. Juc nacionchö runacuna quiquincuna pura chiquinacurga wanutsinacurmi ushacätsinacuyanman. Tsaynömi juc marcachö o juc wayichö tagcunapis quiquincuna pura chiquinacur wacpa caypa gargunacuycar ushacäyanman. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tsaynö caycaptinga gamcuna ama yarpäyaytsu Satanaspa poderninwan supaycunata gargungäta. Supaycunata mandagnin Satanas garguptinga poderniynagna ticrarmi ushacätsinacuyanman”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Gamcunachö waquin runacuna supaycunata runacunapita garguyaptin yarpäyanqui Tayta Diospa poderninwan garguyangantam. Tsaynö yarpaycarga ¿imanirtä nogapäga yarpäyanqui Satanaspa poderninwan supaycunata gargungäta? Tsay llutan yarpayniquicunawanmi manacagcunata parlayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nogata Espiritu Santo yanapamaptin supaycunata gargungäta ricarmi gamcuna musyayanqui Tayta Diospita salvacog rey shamungäta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Satanaspita mas puëdeg canganta tantiyatsirmi Jesus caynö nirgan: “Juc lïsu runa wayinta täpaycaptinga manam pipis imantapis suwapanmantsu. Tsaynö täpaycaptinpis paypita mas puëdeg runa chaycurmi itsanga pancaycur imaycancunatapis apacunman. Tsay cuentanömi nogapis puëdeg caynïwan runacunata Satanaspa maquinpita jipiycä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Pipis ningäcunata mana cäsumag cagcunanam Satanaspa munayninchö cayan. Y nogata cäsumag cagga noga munangätam ruraycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Runacuna llutanta rurar jutsa ruraynincunata y manacagcunata parlayangancunata perdonta mañacuyaptinga Tayta Dios perdonangam. Tsaynömi Tayta Diospita shamungäta mana tantiyar nogapä llutanta parlayaptinpis Tayta Diosga perdonanga. Peru salvacog cangäta Espiritu Santo tantiyaycätsiptin contran captinmi itsanga Tayta Dios imaypis perdonanganatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ima plantatapis prütanpita regingantsicnömi runatapis regintsic parlacuyninpita alli runa cangantapis y mana alli cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Culebra casta runacuna! Quiquiquicuna tsaynö mana alli caycarga ¿imayrächi allitaga parlayanquiman? Shonguyquicunachö llutancunata yarpäyangayquillatam imaypis parlaycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pipis shongunchö allita yarparga allitam parlan. Peru mana alli yarpayyog cagmi itsanga llutancunallata imaypis parlan. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Manacagcunata parlagcunataga parlanganmanmi fisyu final junagchö Tayta Dios pitapis juzganga. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tsaymi gamcunatapis shimiquicuna parlanganman Tayta Diosga niyäshunqui jutsayog cayangayquitapis o jutsaynag cayangayquitapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tsaypitanam waquin fariseucuna y Moises gellgangan leycunata yachatsicogcuna Jesusta niyargan: “Señor Jesus, Tayta Dios rasunpa cachamushungayquita musyayänäpä ima milagrullayquitapis ricaytam munayä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tsaynam Jesus nirgan: “Gamcunaga Tayta Diosman mana yäracog mana alli runacuna carmi milagrutarä ricayta munaycäyanqui. Gamcuna munayangayquinöräga manam ima milagrutapis rurashätsu. Tsaypa rantinga Tayta Dios juc milagrutam ruranga profëta Jonas cawaycaptin rurangannö”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Musyayangayquinöpis unay Jonastam quimsa junag quimsa pagas jatuncaray pescädupa pachanchö caycanganpita yargatsimurgan. Tsaynömi nogatapis quimsa junag quimsa pagas pamparangäpita cawatsimanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonas Diospa willacuyninta willacuptin wiyarmi Ninive marca runacuna jutsa ruraynincunata jagiriyargan. Jonaspitapis mas imaycawan munayyog caycaptï willacungätaga canan witsan runacuna manam cäsucuyantsu. Tsaymi fisyu final junagchö Ninive runacuna sharcayämunga: ‘Jonas willacunganta chasquicuyangänö ¿imanirtä Tayta Diospa tsurin willacunganta chasquicuyargayquitsu?’ niyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Musyayangayquinöpis Salomonpa yachatsicuyninta wiyananpämi ‘Sabah’ ningan nacionpita juc reinapis caruta shamurgan Jerusalenman. Paypis fisyu final junagchö sharcamungam canan witsan runacunata ‘Salomonpa yachatsicuyninta noga chasquicungänö ¿imanirtä gamcunapis Tayta Diospa tsurin yachatsicunganta mana chasquicuyargayquitsu?’ ninanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Juc runapita supay yargucur jäcogcunapam aywan tänanpä ashirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Maychöpis mana tarirnam yarpasquin tärangan runaman yapay cutiycuyta. Tsaynö cutirnam taririn tsay runapa shongunta shumag churapacushga pitsapacushga wayitanörä. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsaynöta tariycurnam tsay runaman cutin paypita mas mana allin cag ganchis (7) supaycunata pushacurcurna tsay runachö cangan täcuyänanpä. Tsaymi puntata canganpitapis mas peyormanna ticracurin. Tsaynömi päsanga canan witsan mana alli runacunawanpis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tsaynö Jesus yachatsicuycaptinmi mamanwan waugincuna tsayman chäyargan. Paycunaga puncullachömi shuyaycäyargan Jesuswan parlayta munarnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Paycunata ricarnam juc runa Jesusta willargan: “Mamayquiwan waugiquicunam puncuchö shuyaraycäyäshunqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Tsaynö willaptinmi discïpuluncunaman ricärir Jesus nirgan: “Paycunam mamänö y waugïcunanö cayan. ");
INSERT INTO qxoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pipis Tayta Dios munanganta rurag cagcunam mamänö, waugïcunanö, y panïcunanö cayan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsaypitanam wayipita yargurir Jesus aywargan Galilea gocha cuchunman. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsaymannam atsca runacuna goricäyargan Jesuspa willacuyninta wiyayta munar. Tsaynam Jesus büquimanna yarcurgan tsaypita yachatsimunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsaypitam imayca iwalatsicuycunawan yachatsicur gallaycamurgan caynö nirnin: “Juc runam aywanä trïguta murucog. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tsaymi muruta matsiptin waquin murucuna tiuyanä näniman. Y nänichö mashtaraycagtanam pishgucuna chaycur upshascärinä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","“Waquin cag murucunanam tiuyanä shaga shagallaman. Tsaychöga jegarcamurpis allpa mana captinmi achaywan tsaquiscärinä. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin murucunanam tiuyanä cashacuna rurinman. Tsaychöpis jegarcamur garwashtaycällarmi tsaquiscärinä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Waquin cag murucunanam alli allpaman chänä. Tsaycunaga alli jegamurmi alli espïgayog canä. Waquin espïgam wayunä pachac (100) trïguta, waquin espïgacunam wayunä jogta chunca (60) trïguta, y waquincunanam wayunä quimsa chunca (30) trïguta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Cay ningäcunata wiyag cagga tantiyacuyay” nirmi Jesus parlapargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsaynö Jesus muruwan iwalatsicuypa yachatsicuptinmi discïpuluncuna tapuyargan: “Tayta, tsay yachatsiyämangayquita ¿imacunamantä iwalatsinqui? Manam tantiyayällätsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tsaymi Jesus nirgan: “Gamcunataga tsay ningäcunata tantiyatsiyäshayquim. Mana cäsumag cagcunatam itsanga mana tantiyatsishätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tsaynö captinmi pipis yachacuyta munagcunaga yachatsingäcunata shumag tantiyacuyanga. Peru yachacuyta mana munagcunaga wiyarpis manam tantiyayangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsaymi noga yachatsicü imamanpis iwalatsiypa. Tsay yachatsingäcunata cäsucuyta mana munag cagga manam imaypis tantiyayangatsu, ricaycarpis ni wiyaycarpis. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tsaynö cananpämi Tayta Dios ninganta unay profëta Isaias gellgargan: ‘Milagru rurangäcunata ricaycarpis willacuynïta wiyaycarpis manam paycuna tantiyayangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cay runacunapaga shonguncunapis chucruyäcurcusham. Tsaymi rinrincunapis tsapacashganö, ñawincunapis gemtsicashganö caycäyan. Tsaynö carmi paycunaga imata yachatsingäcunatapis tantiyacuyantsu. Tsaymi nogataga cäsuyämantsu alli cawaytana tariyänan caycaptin’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gamcunam sïga imata yachatsingäcunatapis tantiyacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Unay profëtacuna y Tayta Dios munangannö cawag runacunapis cay rurangäcunataga ricayta munayargannam. Ricamayta munarpis manam ricayämashgatsu. Tsaynömi noga willacungäcunata wiyayta munarpis mana wiyacuyashgatsu. Gamcunam sïga ricaycäyämanqui y wiyaycäyämanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Cananmi tantiyatsiyäshayqui murucog runaman iwalatsir yachatsingäcunata. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Trïgu muroga Diospa alli willacuyninmi. Muru tiuyangan nänega chucru shongu runacunamanmi iwalan. Tsaynö shonguyog carmi Diospa willacuyninta wiyarpis chasquicuyantsu. Tsaynam wiyayangallantapis Satanas gongaratsin. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Muru tiuyangan shaga allpanam waquin runacunaman iwalan. Paycunaga Diospa alli willacuyninta wiyar cushishgam chasquicuriyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsaynö cushishga chasquicurpis shagachö allpa mana captin trïgu jegarcamur tsaquireg cuentam, criyicuyanganpita imayca ñacaycunaman charninga Diospa willacuyninta dejariyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Muru tiuyangan casha rurinchö allpaga waquin runacunamanmi iwalan. Paycunaga Diospa alli willacuyninta wiyarpis masga yarpachacuyan imaycayogpis cayllapä y quiquincuna munayangannö cawayänanpä cagllatam. Tsaycunapä yarpachacuywanmi Tayta Diostaga gongariyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Muru changan alli allpaga waquin runacunamanmi iwalan. Paycunaga Tayta Diospa willacuyninta cushishga chasquicurmi Diosnintsic munangannö cawayan. Alli allpachö juc murullapita quimsa chunca (30) trïgu o jogta chunca (60) trïgu o pachac (100) trïgu wayungannömi Tayta Dios munangannö cawagcunaga cayan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tsaypitapis juccuna infiernuman aywayänanpä cagta y waquincuna gloriaman chäyänanpä cagta tantiyatsirmi Jesus caynö nirgan: “Juc runam chacranman aywanä trïguta murucog. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tsay murucunganmannam juc chiquipagnin runa tsacaypa aywaycur murungan trïgu jananman cebadillata jichaycamunä. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tsaynam trïgun jegamuptin cebadillapis jegamunä. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsaypita trïguman tirapagcuna aywarna duëñunta willayänä: ‘Taytay, ¿trïgutaga acrashgallatamer mururgayqui? Tsaynö muruycaptiquega ¡maypitatä trïguyquichö cebadillaga pasaypa jegaycamushga!’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tsaynö willayaptinnam trïguyog ninä: ‘Pipis chiquipämag cagmi tsaytaga jichapaycamashga canman’ nir. Tsaynö niptinnam arognincuna tapuyänä: ‘Tsayöraga ¿munanquicu tsay cebadillacunata jipiyänäta?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tsaynö niyaptinnam duëñun ninä: ‘Ama jipiyanquitsu. Cebadillata jipirga trïgutam lluquipacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trïguwan iwal cosëchayag shacshacunanpä dejaycuyay. Cosëchachönam sigagcuna acrapaypa sigayämunga. Cebadillantam cayayanga. Y trïgutanam wayïman churayanga’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tsaypita mastapis Jesus yachatsirganmi caynö nir: “Diospa alli willacuyninga ñäbuspa murunnömi. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tsay muroga pasaypa ichishagllam. Peru nicarpis jegarcamurga waquin gewacunapitapis mas jatunmi ricacun. Tsay ñäbus wiñaptin rämancuna mashtacangannömi Diospa alli willacuynin maytsaymanpis mashtacanga. Tsay rämancunachö pishgucuna geshuncuna rurarir cushicungannömi runacunapis Diospa alli willacuyninta chasquicur cushishga cawayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nircur mastapis yachatsicur Jesus caynömi nirgan: “Tayta Diospa alli willacuyninga levadüranöllam caycan. Juc runa tantata rurar quimsa arröba machcaman levadürata wiñaptinmi mäsaga shumag jacan. Tsay levadüra wallcalla caycar mäsata atscayätsir jacatsingannömi Diospa alli willacuynin maytsayman chaptin chasquicogcunapis masrä atscagyäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesusga runacunata yachatsirnin imaycamanpis iwalatsiypam imaypis yachatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tsaycunawanmi cumplirgan Tayta Diospa willacognin profëta caynö nir gellgangan: “Imaycamanpis iwalatsiypam runacunata yachatsishä. Patsa camacangan junagpita pipis mana tantiyangancunatam tantiyatsishä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsaypitanam runacunata aywacuyänanpä nisquir discïpuluncunawan Jesus yaycurgan juc wayiman. Tsaychömi discïpuluncuna niyargan: “Taytay, trïguchö cebadilla gewaman iwalatsiypa yachatsicungayquita tantiyaycatsiyämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tsaynam Jesus nirgan: “Tsay trïguta murucog runaga nogam cä. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tsay chacraga cay patsam. Tsay trïgunam Diospa alli willacuyninta chasquicog cag runacuna. Y tsay trïguchö cebadillanam Satanaspa mandunchö cawacog cag runacuna. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Murucogta chiquipagnin cebadillata murucuynin jananman jichapag cag runanam Satanas. Y cosëchanam fisyu final ninan. Cosëchata goregcunanam angelcuna cayan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Trïgupita cebadillata acragnömi fisyu final junagchö Satanas munanganta rurar cawag runacunata angelcuna acrasquir infiernuman gaycuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noga Tayta Diospita shamogmi angelnïcunata cachamushä jutsaman ishquitsicogcunata y jutsa ruragcunata gorircur infiernuman gaycuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tsaychömi quiruncunatapis uchurrä wagayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Peru Tayta Dios munanganta cumplegcunam itsanga glorianchöna car cushicuyanga. Cay ningäcunata wiyag cagcunaga shumag tantiyacuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mastapis discïpuluncunata yachatsirganmi caynö nirnin: “Juc runa chacrapa puriycar tarisquinä atsca gellë pamparaycagta. Tsay gellëta tariycurna pasaypa cushicunä. Nircurna yarpachacunä: ‘¿Imatatä ruräman cay gellë quiquïpana ticrasquinanpä?’ nir. Nicangantaga cangallanman pampaycur cushishga imaycancunatapis ranticuscärinä. Nircurna tsay gellë pamparaycangan chacrata rantisquinä. Tsaynöpana tsay runa pamparaycag gellëta jipir rïcuyänä. Tsaynöpis Tayta Diospa ñöpanman chayga ima cushicuypämi cay patsachö imaycayog cangantsicpitapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nircur Jesus caynöpis nirganmi: “Diospa alli willacuyninta chasquicogcunaga alläpa valoryog perlas rumipita aläjata ranteg cuentam caycäyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Perlas aläja ranteg runam örupita mas valoryogta tariycur mayläya chanin captinpis wayintapis chacrantapis ranticuscärinä tsay aläjata rantinanpä. Tsaynöpis Tayta Diospa ñöpanman chayga ima cushicuypämi cay patsachö imaycayog cangantsicpitapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yapaypis Jesus caynömi yachatsicurgan: “Musyayangayquinöpis mällata lamarman mashtaycur imaycaläya pescädutam runacuna tsariyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nircurnam lamar cuchunman jipirayämun tsaychöna acrayänanpä. Tsaychö acrarnam micunapä cagta canastaman wiñayan y mana micunapä cagtana jitariyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tsaynöllam fisyu final junagchöpis llapan runacunata acrananpä Tayta Dios angelnincunata cachamunga. Alli runacunatam raquinga jutsa rurag runacunapita. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jutsachö cacogcunatam infiernuman gaycunga. Tsaychöga jutsa rurayta mana dejayanganpitam wagar quiruncunatapis uchuyangarä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsaynö yachatsicurirnam Jesus tapurgan discïpuluncunata: “¿Cay ningäcunata gamcuna tantiyayanquicu?” Tsaynö niptinnam niyargan: “Aumi, taytay. Tantiyayämi” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsaynam Jesus nirgan: “Tayta Dios munangannö cawayänayquipä yachatsingäcunata tantiyarga waquin runacunatapis shumag yachatsiyanqui. Tsaynö yachatsirga tröjapita maran cagcunata y tsayrä churacuyangayquita jipiramur garacognömi gamcunapis unay cag yachatsicuycunata y mushog yachatsicuycunata yachatsiyanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tsaynö imaycacunaman iwalatsiypa yachatsicurirmi Jesus aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Marcan Nazaretman chaycurnam Diospa willacuyninta yachatsicurgan goricäcuyänan wayichö. Tsaychö yachatsicuptinnam runacuna espantar niyargan: “Tsaynö yachatsicog cananpäga ¿maychötäshi tsayläya yachacuycushga? ¿Ima munayninwantäshi tsayläya milagrucunatapis ruran? ");
INSERT INTO qxoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manacu tagayga carpintëru Josepa tsurinlla? ¿Y manacu maman Maria? ¿Manacu waugincunapis cayan Santiago, Jose, Simon, y Judas? ");
INSERT INTO qxoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y panincunatapis regintsicmi. Tsayöraga ¿maychönatä yachacushga canman yachatsimagnintsic tucunanpäga?” ");
INSERT INTO qxoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsaynö nirmi Jesus yachatsicungancunataga mana cäsupäyargantsu. Tsaymi Jesus nirgan: “Juclä marcacunachöga Tayta Diospa willacognin profëtata chasquiyanmi. Peru quiquinpa marcanchöga manam cäsupäyantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tsaynö mana criyicuyaptinmi juc ishcay milagrucunallata marcanchöga rurargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tsay witsanmi Galilea provinciapa mandagnin rey Herodesta runacuna willayargan Jesus Diospa willacuyninta willacur y milagrucunata rurar puriycanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsaynam yanapagnincunata Herodes nirgan: “Payga Juan Bautistam cawarimushga canman. Tsaymi munayyog caycan milagrucunata rurananpäpis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Peru Juan Bautista cawaycaptinllarämi Herodes waugin Felipipa warmin Herodiasta gechurgan. Tsaynam Juan Bautista Herodesta nirgan: “Waugiquipa warminta tsararar mana allitam ruraycanqui” nir. Tsaynö ninganpitam Juan Bautistata Herodias chiquirnin wanutsiyta munargan. Tsaynö chiquirnam waynan Herodesta willapargan Juanta carcelman wichgatsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodesga Juanta wanuratsiyta mantsarirgan, llapan runacunapis “Juanga Tayta Diospa willacognin profëtam” niyaptinmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsaypita Herodespa santunchönam Herodiaspa jipash wawan selläma gälacurrä shumag tushuycurgan llapan invitäducunapa ñöpanchö. Tsaynö tushungan Herodestaga feyupam gustaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tsaymi tsay jipashta nirgan: “Cananga imatapis nimaylla. Mañamangayquitaga garashayquillam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsaynö niptin tsay jipashga maman yätsingannöllam Herodesta nirgan: “Jatun matichö Juan Bautistapa umanta goycamänayquitam munä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tsayta mañaycuptinmi itsanga rey Herodesga pasaypa llaquicurnin yarpachacurgan. Juanta wanutsiyta mana munaycarpis invitäduncunapa ñöpanchö aunishga carmi juc soldäduta cachargan Juanta wanuratsir umanta jipashman apapämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tsaynam carcelman soldädu aywar Juanta wanuratsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nircurnam umanta roguriycur matichö apar jipashta goycurgan. Tsayta chasquisquir jipashga mamanmanmi apapaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsaynö rurayanganta musyasquirnam Juanpa discïpuluncuna ayanta apacuyargan pampayänanpä. Nircurnam Jesusta willayargan Juanta tsaynö wanutsiyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsaypitanam Jesus milagrucunata rurar puriycanganta Herodes musyargan. Tsay Herodes musyanganta mayaycurnam Jesus büquiman yarcurcur tsunyagpa quiquillanna aywacurgan. Tsaynö aywacuptinpis runacunaga musyayarganmi mayman aywangantapis. Tsaymi chaquillapa aywayargan Jesusta taripäyanganyag. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Büquipita yarpurirnam Jesus tarirgan atsca runacuna tsaychö shuyarar caycäyagta. Tsaynam runacunata ricaycur Jesus cuyapargan y apayangan geshyagcunata allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsaypitanam tardiyaptinna Jesusta discïpuluncuna niyargan: “Caychöga manam imapis cantsu runacunata garanantsicpä. Tardiyaycaptinnaga llapancunapis aywacuyätsunna tsay quinran marcacunapa micuynincuna rantiyämunanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tsaynö niyaptinmi Jesus nirgan: “Manam paycuna micuy ashegräga aywaycäyanmantsu. Gamcuna micuynincunaga garayay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tsaynö niptinnam discïpuluncuna niyargan: “¡Imäcunatarächi cayläya manana atipaypä runacunataga garayäman! Caychö pitsga tantawan ishcay pescädullachä millcapäcuna caycan, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tsaymi Jesus nirgan: “Tsay millcapayquicunata apayämuy” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nircurnam discïpuluncunata nirgan runacunata gewacunallaman jamatsiyänanpä. Tsaypitanam pitsga tantata y ishcay pescäduta aptarcur Jesus ciëluman ñuquircur Tayta Diosman mañacurir agradesicurgan. Nircurnam tantata paquiscärir pescäduntinta discïpuluncunata macyargan llapan runacunata aypuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tsaymi llapancuna micuyargan pachajunta. Sobrapacuyangantanam discïpuluncuna goriyargan chunca ishcay (12) canastacunaman juntata. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tsaychö micogcunaga cayargan pitsga waranganömi (5,000) ollgu caglla, warmicuna ni wamracuna mana yupashga. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsaypitanam discïpuluncunata Jesus nirgan: “Büquiman yarcurcur wac-tsimpaman puntaraycäyay. Y nogana caychö runacunata wayincunaman cuticuyänanpä yätsimushä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tsaynö nisquirnam jircan niragman witsargan Tayta Diosman mañacunanpä. Tsaychö mañacuycaptinmi patsapis tsacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Büquiwan puntagcunaga carutanam aywaycäyargan. Tsaynö aywaraycäyaptinnam gochata vientu pasaypa lagchicachätsirnin gallaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tsaypitanam gällu cantay öranöna caycaptin yacu jananpa Jesus aywargan discïpuluncuna cagman. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tsaynö yacu jananpa aywaycagta ricaycurmi discïpuluncuna pasaypa mantsacar gayaräyargan: “¡Almachä ëllu shamuycan!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tsaynö mantsacäyaptinnam Jesus nirgan: “¿Imatatä mantsacuyanqui? Nogachä cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsaymi Pedro valoracuycur nirgan: “Taytay, rasunpa gam carninga nogapis yacu jananpa gam cagman aywamunäpä niycuy”. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tsaynö niptin Jesusga caynömi nirgan: “Shamuy ari” nir. Tsaynam büquipita yargurir yacu jananpa Jesus cagman Pedro aywargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aywaycanganchönam pasaypa vientu yacuta jananman lagchicachätsiptin feyupa mantsacargan. Tsaychö jundicarnam gayarargan: “¡Salvaycallämay, taytay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tsaynö niptinmi Jesus maquinpita tsarircur nirgan: “¡Ä, mana yäracuyniynag runa! ¿Imanirtä nogaman mana yäracamunquitsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tsaypita büquiman yarcurcuyaptinnam vientoga tsunyarpurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tsayta ricaycurnam büquichö discïpuluncuna Jesuspa ñöpanman gonguricuycur niyargan: “¡Taytay, rasunpam gamga Tayta Diospa tsurin canqui!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Galilea gochapa wac-tsimpanman päsarirnam chäyargan Genesaret marcapa wac-lädunman. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tsayman Jesus changanta musyaycurnam maypita tsaypitapis imaycaläya geshyagcunata apapäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tsay apapäyangan geshyagcunaga Señor Jesusta rugacuyargan: “Taytay, röpayquipa cuchullantapis yataycuyäshä allisquiyänäpä” nirmi. Tsaynö nir röpanta yataycog cagga llapanmi geshyancunapita allisquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tsaypitanam fariseucuna y Moises gellganganta yachatsicogcuna Jerusalenpita aywayargan Jesusta tapuyänanpä. Chaycurnam niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imanirtä discïpuluyquicunaga üsuntsicta mana cäsuypa maquincunata mana awicullar micuycäyan? Tsaynö carga manam cäsuyantsu unay cag runacuna yachatsimangantsictaga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tsaynö niyaptinnam paycunatapis Jesus nirgan: “Gamcunapis, ¿imanirtä Diospa palabran gellgaranganta cumpliyänayquipa rantin tsay üsucunallata masga cumpliyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diospa palabran gellgaranganchöga caynömi nin: ‘Taytayquita mamayquita respitar alli ricanqui. Mamanta taytanta mana alli ricag cagtaga wanuratsiyätsun’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Tsaynö nicaptinpis gamcunaga runacunata yachaycätsiyanqui mamancunata ni taytancunata manana yanapayänanpämi. Tsaynö yachatsirmi nipäyanqui mamancunata y taytancunata caynö niyänanpä: ‘Tayta Diosllapänam imaycäcuna cacun. Mananam gamcunataga yanapayämannatsu’ nirnin. Tsaynö yachatsirmi gamcunaga Diospa palabran gellgaranganta manana cäsur imapäpis cuentayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tayta Diosman mana criyicog janan shongu runacuna! Gamcuna tsaynö cayänayquipä cagta musyarnam Tayta Dios profëta Isaiasta tantiyatsirgan caynö nir gellgananpä: ");
INSERT INTO qxoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay runacunaga janan shongullam “Tayta Dioslläcuna” nir jutïta jayag tucuyan. Manam llapan shonguncunawantsu nogaman criyicayämun. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Willacuynïta yachatsicuyänanpa rantinmi unay cag üsuncunallaman sïgiycäyan. Tsaynö cayaptinmi paycuna adorayämanganpis ni imapä mana välintsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nircurnam runacunata gayaycur Jesus nirgan: “Canan llapayqui cay ningäcunata shumag tantiyayämay. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Imatapis micunganwantsu manam runaga jutsayog ricacun, sinöga shiminpita yargamunganwanmi jutsayogga ricacun”. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Niptinnam discïpuluncuna Jesusman witiycur niyargan: “Tsaynö niptiqui, taytay, fariseucunaga feyupa rabyashgam caycäyan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Tsaynö willayaptinnam Jesus nirgan: “Gamcunaga paycuna ima niyangantapis ama cäsupäyaytsu. Chacrapita mana alli cag gewacunata lluquirir jitariyangannömi paycunatapis Tayta Dios infiernuman jitaringa. Paycunaga yachag tucurpis wiscunömi cayan. Mä, ¿wiscuyashga runa wiscu mayinta pushanmantsurä? Tsaynö carnin ishcancunam pözumanpis jegarpuyanman. Tsaynömi paycunapis yachatsicuynincunata cäsupagnintin infiernuman gaycucäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsaynö niptinnam Pedro nirgan: “Runa micunganpä y shiminpita yargamog cagpä ningayquitarä tantiyarcatsiyämay, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tsaymi Jesus nirgan: “¿Gamcunapis manaräcu tantiyaycuyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ima micuyta micurpis runaga manam micunganwanga jutsayogtsu ricacun, sinöga ima micuytapis micunganga päsacunllam. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Llutancunata parlarmi jutsayogga ricacun. Tsaynö llutancunataga parlan y ruran shongunchö mana allicunata yarparmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runacunaga shongunchö llutancunata yarparmi runa mayinta wanutsin, adulteriu jutsata rurayan, majaynagrä caycar piwanpis lluta puricuyan, suwacuyan, llullacuyan, y runa mayinpä rimar puriyan. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tsaycunata rurarmi jutsayog ticran. Manam micuycunata micurtsu ni manam micuy örapä maquinta mana awicullar canganwantsu jutsayogga ticran”. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tsaypitanam Jesus aywargan Tiro y Sidon provinciacunapana. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tsay quinran marcacunachöga täyargan mana Israel runacunam. Tsaynam mana Israel casta juc warmi Jesusman witiycur rugacurgan: “¡Unay rey Davidpa castan Jesus, cuyapaycallämay! ¡Warmi wawallätam supay imaypis löcuyätsin! ¡Tsay geshyapita allïtsipaycallämay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tsaynö niptin Jesusga manam imatapis parlacurgantsu. Tsaynam discïpuluncuna Jesusta niyargan: “Taytay, tagay warmita niycuy aywacunanpä. Umantsictapis nanatsirchä gayarar gatirämantsic” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsaymi Jesus nirgan: “Tayta Dios cachamashga Israel runacunallaman yanapagmi. Paycunaga ogracashga üshacunanömi caycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tsaynö niptinnam tsay warmi Jesuspa ñöpanman gonguricuycur rugar nirgan: “Taytay, ¡amari yaga caycuytsu! ¡Yanapaycallämay ari!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tsaynam Jesus nirgan: “Manam allitsu canman Israel mayïcunatarä yanapanä caycaptin, gamcunatarä punta puntata yanapasquiptëga. Tsayga canman wamracunapä cagta tantata allgucunata jitapaycog cuentam”. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tsaynö niptinnam warmi nirgan: “Aumi, taytay. Tsaynö captinpis ämun shicwapacungantaga allguncunapis micuyanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsaynam Jesus nirgan tsay warmita: “¡Imanömi nogaman yäracuyniqui! Gam rugacamangayquega ruracätsun” nir. Tsay öram tsay warmipa wawan allisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsaypita aywacurnam Jesus chargan Galilea gocha cuchunman. Nircurnam juc jircaman witsarcur tsaychö jamacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsaymanga atsca runacunam goricäyargan. Tsaynö goricarmi chätsipäyargan puriyta mana puëdeg ratacunatapis, gapracunatapis, macllucunatapis, parlayta mana puëdegcunatapis, imayca geshyawan geshyagcunatapis. Paycunata llapantam Jesus allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tsaycunata ricar runacunaga espantarmi cushicur niyargan: “Cananga upacunapis parlayannam, macllucunapis allisquiyashganam, puriyta mana puëdeg ratacunapis puriyannam, y gapracunapis ricayannam” nir. Tsaynö nirmi Israel runacuna adorayangan Tayta Diostana paycunapis alabayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tsaypitanam discïpuluncunata gayaycur Jesus nirgan: “Cay runacuna cuyapaypämi caychö caycäyan. Paycuna caychö cayan quimsa junagnam. Manam imancunapis cantsu micuyänanpä. Mallagllata wayincunapa cuticuyänanpä niptëga aywaycäyanganchö wanurpis wanuycuyangachir” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tsaynö niptinnam discïpuluncuna niyargan: “Taytay, ¿cay tsunyagchöga maychörächi tariycushwan micuyta caytsica runacuna micuyänanpäga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsaynam paycunata Jesus tapurgan: “Gamcunapa millcapayquicuna ¿ayca tantatä capuyäshunqui?” nir. Paycunanam niyargan: “Ganchis (7) tantallam y juc ishcay pescädullam caycan, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsaynö niriyaptinmi llapan runacunata nirgan jamacuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jamaycuyaptinnam pescädutawan ganchis tantata aptarcur Tayta Diosman Jesus mañacurgan. Nircurnam paquiscärir discïpuluncunata macyargan runacunata aypuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tsaynam llapancuna micuyargan pachajunta. Sobragtanam goriyargan ganchis canastacunaman juntata. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tsaychö micogcunaga cayargan ollgu caglla chuscu waranganömi (4,000), warmicuna ni wamracuna mana yupashga. ");
INSERT INTO qxoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tsaypitanam büquiman yarcurcur discïpuluncunawan Jesus aywacurgan Magdala marca wacläninman. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Magdalaman chaycuyaptinmi fariseucuna y saduceucuna aywar Jesusta niyargan: “Tayta Dios rasunpa cachamushungayquita musyayänäpä, mä ima milagrutapis ruramuy nogacuna ricayänächö” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tsaynö niyaptinnam Jesus nirgan: “Rupay jegangan öra pucutay garwashyaptin gamcuna niyanqui: ‘Warayga usyanganam’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tsaynömi pucutarar patsa warämuptinpis gamcunaga niyanqui ‘Canan junagga tamyangam’ nirnin. Tsaycunatapis cösa tantiyaycarga ¿imanirtä tantiyayanquitsu Tayta Dios cachamashga captin noga ruraycangäcunataga? ");
INSERT INTO qxoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gamcunaga manam rasunpaypatsu Tayta Diosman criyiyanqui. Tsaymi pay cachamanganta musyayänanpäga milagrutarä ricayta munayanqui. Munayangayquinöga manam milagruta rurashätsu. Tayta Diospa profëtan Jonasta jatuncaray pescädupa pachanpita cawaycagta yargatsimungannömi itsanga milagruta ruranga”. Tsaynö nisquirmi Jesus tsaypita aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Galilea gochata päsarirnam Jesuspa discïpuluncuna yarpasquiyargan gongaycur tantata mana millcapacuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tsayta parlaycäyaptinnam Jesus nirgan: “Fariseucunapa y saduceucunapa levadüranta pagtä chasquiycäyanquiman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsaynam discïpuluncuna quiquincuna pura ninacuyargan: “Tantata mana millcapacamungantsicpitam tsaynö nicämantsic” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tsaynö nicäyanganta wiyarnam Jesus nirgan: “¡Yäracuyniynag runacuna! ¿Imanirtä parlaycäyanqui tantata mana apayämungayquita? Nogaga manam tantapitatsu parlaycä. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gamcunaga ¿manacu yarpäyanqui pitsga tantallapita pitsga waranga (5,000) runacuna micuyänanpä milagruta rurangäta? ¿Mananacu yarpäyanqui tsay junag sobrag tantacunata atsca canastacunaman goriyangayquitapis? ");
INSERT INTO qxoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tsaynöpis gamcunaga ¿manacu yarpäyanqui ganchis (7) tantallapita chuscu waranga (4,000) runacuna micuyänanpä milagruta rurangäta? ¿Y manacu yarpäyanqui sobragcunatapis canastacunaman goriyangayquita? ");
INSERT INTO qxoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tsaynö caycaptinga ¿imanirtä gamcunaga yarpäyanqui tantallapä parlaycangäta? Tantata munarga yapaypis milagrutaga ruraramümanmi. Nogaga parlaycä fariseucunapa y saduceucunapa levadürancunapita cuïdacuyänayquipä cagtam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tsaynö niptinran discïpuluncuna tantiyarcuyargan fariseucunapa y saduceucunapa yachatsicuyninta mana chasquipäyänanpä levadüraman jitaycullar nicanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tsaypita Cesarea de Filipos marcacunaman chaycurnam discïpuluncunata Jesus tapurgan: “¿Pï cangätatä nogapä runacuna yarpäyan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsaynö tapuptinnam discïpuluncuna niyargan: “Waquin runacunaga niyan: ‘Juan Bautistam ëllu’ nirmi. Waquinnam niyan unay profëta Elias cangayquita. Tsaynömi waquincunapis niyan unay profëta Jeremias cangayquita o maygan profëtapis cawamushga cangayquita”. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsaynö niyaptinnam paycunatana Jesus tapurgan: “Gamcunaga ¿pï cangätatä yarpäyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsaynam Simon Pedro nirgan: “Gamga Tayta Diospa tsurin salvacogmi canqui, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsaymi Pedruta Jesus nirgan: “Allitam nirguyqui, Jonaspa tsurin Simon. Tsayta ninayquipäga Tayta Diosmi tantiyatsishurguyqui, manam pipitapistsu yachacurguyqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pedro, tsaynö nishga carmi gamga cimientu rumi cuenta canqui. Tsay cimientu rumi jananchömi noga sharcatsishä iglesiäta. Tsaynö captin nogaman criyicamogcunata ni Satanaspis manam imanangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gamtam gloria vïdapa llävinta goycushayqui. Cay patsachö gam wichgangayquim ciëluchöpis wichgashga canga. Y cay patsachö gam quichangayquim ciëluchöpis quichashga canga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tsaynö nisquirmi discïpuluncunata Jesus nirgan: “Gamcuna amarä pitapis willacuyanquitsu Tayta Dios cachamangan salvacog cangäta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tsaypitanam discïpuluncunata Jesus willargan Jerusalenman aywaptin autoridäcuna, sacerdöticuna, y ley yachatsicogcuna chiquir ñacatsiyänanpä cagta. Nircurmi nirgan wanutsiyaptinpis quimsa junagtaga cawamunanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsaynö niptinnam Jesus llutanta parlaycanganta yarpar jucläman gayasquir Pedro nirgan: “Tsaynö cananpä captinga ¿imapätä Jerusalenmanpis aywanqui? ¡Tsaytaga Tayta Diospis ama munaycutsuntsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tsaynö Pedro michaptinnam Jesus nirgan: “¡Cay runapita yarguy, Satanas!” Nisquirnam Pedruta nirgan: “Gamga tsaynö michämar Tayta Dios munanganta ruranätam munanquitsu, sinöga runacuna yarpangannöllam ruranäta munaycanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nisquirmi discïpuluncunata nirgan: “Pipis discïpulü cayta munarga imayca ñacacuyman charpis noga munangänölla imaypis cawatsun. Quiquinpa munayllanchöga amana cawatsuntsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pipis quiquinpa munayllanchö cawag cagga manam salvacionta taringatsu. Peru noga ningänö cawag cagmi itsanga mana ushacag alli cawayta taringa. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Alman infiernuman gaycucänan captinga ¿imapänarä välinga mayläya rïcu canganpis? Pasaypa rïcu carpis manam salvaciontaga rantiyangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Noga angelnïcunawanmi y Tayta Diospa poderninwanmi cutimushä. Tsaynö cutimur alli ruragcunatam premiuta goshä y mana allita ruragcunatam infiernuman gaycushä. ");
INSERT INTO qxoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Caychö caycagpita waquinniquicunaga manarä wanurmi ricayämanqui Tayta Diospa munayninchö caycagta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tsaypita jogta junagtanam Pedruta, Santiaguta, y Santiagupa waugin Juanta pusharcur Jesus witsargan juc jircaman. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tsaychömi discïpuluncuna ricaycäyaptin Señor Jesuspa cäran rupaynörä pasaypa chipipirgan. Röpanpis pasaypa yullag pürum atsicyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tsaychönam ricayargan Moiseswan Elias yuripasquir Jesuswan parlaycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsaynam Pedro Jesusta nirgan: “Taytay, allipärä cayman nogacuna shacayämurgä. Canan itsan caychö quimsa tsucllata ruraycayämushä, jucta gampä, jucta Moisespä, y jucta Eliaspä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsaynö Pedro parlapaycaptinmi pasaypa yullag püru pucutay paycunata tsapasquirgan. Tsaynam pucutay rurinpita Tayta Dios caynö nimurgan: “Paymi cuyay tsurï. Noga munangänö llapantapis ruraptinmi cushicü. ¡Pay niyäshungayquicunata cäsucuyay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsaynö nimogta wiyaycurmi apostolnincunaga pasaypa mantsariywan patsaman lätacacuycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsaynö caycäyaptinmi paycunata yataycur Jesus nirgan: “Ama mantsacäyaytsu. Sharcuyay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tsaynö niptin ñuquircuyänanpäga Jesus japallannam caycänä. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jircapita uraraycämurnam paycunata Jesus nirgan: “Cay ricayangayquicunata pitapis ama willapäyanquirätsu noga wanungäpita cawamungäyag” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsaynam quimsan discïpuluncuna Jesusta niyargan: “Ley yachatsicogcunaga niyan salvacog shamunanpäga Eliasrä puntata shamunanpä cagtam. Tsayöraga gampa puntayquita ¿imanirtä Eliasräga shamushgatsu?” ");
INSERT INTO qxoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Tsaynö niyaptinmi Jesus nirgan: “Elias shamunanpä cagta niyangannöllam payga shamushgana. Tsay shamog nogapä willacuptinpis manam runacuna chasquicuyashgatsu willacunganta. Chasquicuyänanpa rantinmi payta chiquir wanutsiyargan. Tsaynömi noga Tayta Diospita shamogtapis runacuna wanutsiyämanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesus tsaynö niptin discïpulucunaga tantiyayargan Juan Bautistapä parlaycangantam. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jircapita urämurnam runacuna caycäyanganman Jesus chargan. Tsaychönam juc runa Jesuspa ñöpanman gonguricuycur rugacur nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Taytay, cay wamralläta cuyapaycullay. Payta wanuy geshya tsariptinmi ninamanpis yacumanpis jegar ushan. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Discïpuluyquicunamanpis apamuptïpis manam allïtsiyashgatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tsaynö niptinnam Jesus nirgan: “¡Yäracuyniynag runacuna! ¿Imayyagrä gamcunawan caycäshä? Apayämuy tsay jövinta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tsaynam ñöpanman chaycatsiyaptin jövinta ñacatseg supayta Jesus ollgutupargan. Tsaynö ollgutupaycuptinmi supayga jinan öra jövinpita yargusquir aywacurgan. Tsay örapita jövinga allishganam quëdasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsaypitanam quiquillancuna caycarna discïpuluncuna Jesusta tapuyargan: “¿Imanirtä nogacunaga supayta garguyta puëdiycuyargötsu?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tsaynam paycunata Jesus nirgan: “Janan shongulla Tayta Diosman yäracurmi gamcunaga garguyta puëdiyarguyquitsu. Nostäza murunöllapis yäracuyniquicuna ichic captinga cay jircata ‘Caypita jucläman witisquiy’ niyaptiquipis witisquinmanmi. Tayta Diosman rasunpaypa yäracuyaptiquega manam imapis ajatsu gamcunapä canga. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tsaynömi puëdeg supaycunataga runapita garguntsic Diosman mañacuywanrä y ayünuwanrä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea provincia quinranpa discïpuluncunawan purirmi Jesus nirgan: “Noga Tayta Diospita shamogta entregayämanga chiquimagnïcunapa maquincunamanmi wanutsiyämänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tsaynö wanuratsiyämaptinpis quimsa junagtaga cawamushämi” nir. Tsaynö niptin discïpuluncunaga feyupam llaquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tsaypitanam Capernaum marcaman discïpuluncunawan Jesus chäyargan. Tsaychömi templupä impuestu cobracogcuna Pedruta tapuyargan: “¿Jesusga pägancu templupä impuestuta?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tsaynö niyaptinnam Pedro nirgan: “Aumi, päganmi” nir. Tsaynö nisquirmi Jesus caycangan wayiman Pedro aywargan Jesusta tapunanpä. Tsaychö manarä tapuptinmi Jesus nirgan: “Pedro, ¿imaninquitä gamga? Mandacog reycuna ¿pitatä impuestuta cobrayan? ¿Tsurincunatacu o juclä runacunatacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tsaymi Pedro nirgan: “Mandunchö cag juclä runacunatam impuestutaga cobrayan”. Tsaynö niptinnam Jesus nirgan: “Tsayöraga mandacog reypa tsurincuna impuestuta mana pägaycäyaptinga nogapis Diospa tsurin car papänïpa templunpä impuestuta pägämanräcu. ");
INSERT INTO qxoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Imanö captinpis cobracogcuna mana ajäyänanpä gochaman aywar anzuëluyquiwan pescäduta tsarimuy. Punta tsaringayqui pescädupa shiminchömi gellë canga. Tsay gellëta nogapitapis y gampitapis impuestuta pägaycamunqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tsaychömi discïpuluncuna Jesusta tapuyargan: “Imaycapis munayniquichö caycaptinga ¿maygäcunatatä mas mandag cayänäpä churayämanqui, taytay?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsaynö niyaptinnam wamrata ñöpancunaman Jesus gayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nircurmi discïpuluncunata nirgan: “Wamracuna llullu yarpaynincunawan manam yarpachacuyantsu waquin cagpita mas puëdeg caytaga. Tsaynö gamcunapis ama yarpachacuyaytsu waquin cagpita mas puëdeg cayänayquipä cagtaga. Tsay manacag yarpayniquicunawan gamcuna manam gloriaman chäyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Juccunapita mas puëdeg caypä mana yarpagcunataga gloriachömi puëdeg cayman churayäshayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tsaynö captin cay wamranö cagcunata pipis yanaparga nogata yanapaycämagnömi caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nogaman criyicamogcunata pagtä pitapis jutsata ruraycätsiyanquiman. Tsaynö runacunataga mejormi jatuncaray mulinu rumita cuncanman wataparcur lamarman jitarpuyanman. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Peru imanö captinpis jutsaman ishquitsicogcunaga imaypis cangam. Tsaynö cayanganpita tsay jutsaman ishquitsicogcuna, ¡allau, imanö cuyapaypärä castigashga cayanga!” ");
INSERT INTO qxoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Tsaynö captin maquiqui o chaquiqui jutsaman ishquitsishuptiquega rogurir jitariycuy. Chaquiyog maquiyog mana nunca upeg ninaman gaycucänayquipa rantinga mas allim canga tsulla chaquillapis tsulla maquillapis gloriaman yaycuptiqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tsaynölla ñawiquipis jutsata ruratsishuptiquega ogtirir jitariycuy. Ishcan ñawiyog infiernuman gaycucänayquipa rantinga mas allim canga tsulla ñawillapis gloriaman chaptiqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tayta Diospa ñöpanchö caycag angelcunam llapan criyicogcunata imaycay örapis ricaycämun. Tsaynö caycaptinga criyicogcunata ama lluta runaman cuentayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Paycunata jutsancunapita salvanäpämi Tayta Dios cachamashga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pipis pachac (100) üshanpita jucta ograycur ¿manatsurä waquin cagcunata juc puchaman goriycur juclla aywanman ashegnin? ");
INSERT INTO qxoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nircur tsay ogracag üshanta tariycurga imanörä cushiycunman, waquin cag üshancunapä cushicurpis. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tsaynöllam ciëluchö caycag Tayta Dios munantsu payman criyicogcuna ni jucllayllapis infiernuman aywayänanta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tayta Diosman criyicog mayiqui imachöpis mana allita rurashuptiquega puntataga quiquillanta parlapanqui tantiyatsirnin mana allita ruraycäshungayquita. Tantiyatsiptiqui chasquicuptinga perdonanacur alli cawaymanmi yapay chäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tantiyatsiptiqui mana chasquicuptinga ishcay o quimsa criyicog mayiquicunatana pushanqui jutsata ruraycanganta tantiyatsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Paycunatapis mana cäsuptinga llapan criyicog mayiquicunapa ñöpanchöna ninqui jutsa rurayninta paycunapis tantiyatsiyänanpä. Tsaychöpis mana cäsucuptinga llapayqui criyicogcuna paywan amana juntacäyanquinatsu. Tsay runata ricayanqui Tayta Diosta mana cäsucog runatanö y impuestuta cobracog runatanö”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tsay mana cäsucogcunata alliyätsiyänayquipä gamcuna munayyogmi cayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yapaypis gamcunata nï: Juc ishcagllapis Tayta Diosman mañacuyaptiqui yanapayäshunqui willanacur tsay mana cäsucogcunata shumag yätsipar tantiyatsiyänayquipämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Juc ishcagllapis Tayta Diosman mañacuyänayquipä goricäyaptiqui gamcunawanmi imaypis noga caycäshä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsaynö yachatsicuptinnam Pedro tapurgan: “Criyicog mayï imachöpis mana allita ruramaptinga tsayöraga, ¿ayca cutitä perdonäman, taytay? ¿Ganchis (7) cutitsurä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tsaynö tapuptinmi Jesus nirgan: “Manam ganchis cutillaga perdonanquimantsu, sinöga ayca cutipis perdonanquimanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tsaynö nisquirnam Jesus willapargan caynö nir: “Juc nacion mandacog reypam cargan atsca yanapagnin runacuna. Tsay yanapagnincunatam rey nirgan llapancuna cuentata goyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Tsaynö cuentata mañaptinnam chätsipäyargan jagan cag runata. Tsay runaga yupaytapis manana atipaypämi mandacogpa jagan cargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jagata pägacunanpä imanpis mana capuptinnam rey wätaynincunata mandargan: ‘Cay runata, warminta, tsurincunata, imaycancunatapis apayay ranticuyänayquipä. Ranticusquirna tsay gellëta apayämunqui jagäpita tsarinäpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tsaynö niptinmi tsay jaga runaga gonguricuycur maquinta tsogpacurcur rugacurgan: ‘Taytay, amari ranticaycayämaytsu. Imaycanöpapis jagayquitaga pägaycushayquichir’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tsaynö rugacuptinnam rey cuyaparnin llapan jaganta perdonaycur dejaycurgan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tsaynö perdonacärir aywacuycanganchönam tincucurcunä arog mayin juc runawan. Payga wallcamanpallam jagan canä rey perdonangan runapa. Tsaymi tsay perdonashga runaga cuncapita tsarisquir llapiränä: ‘¡Jagäta ras pägamay!’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tsaynö niptinnam arog mayinga gonguriycur ruganä: ‘Ichicllata shuyaycamay, taytay. Llapan jagayquita pägalläshayquim’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tsaynö rugacuptinpis tsay perdonashga cag runaga manam arog mayinta ichicllatapis shuyasquiyta munanätsu. Tsay shuyärinanpa rantinmi carcelman wichgatsinä jaganta päganganyag”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Tsaynö ruranganta ricaycurnam waquin arog mayincunaga feyupa ajanäyänä. Tsaynam mandag reyman aywar willayänä tsay perdonangan runa arog mayinta carcelman wichgatsinganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tsaynam perdonangan runata jinan öra gayascatsir rey ninä: ‘¡Mana cuyapäcog malafë runa! Gamtaga rugacamaptiqui llapan jagätachä perdonargö. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tsaynö cuyapar perdonaycaptëga gamga ¿imanirtä arog mayiquitaga cuyapayta yacharguyquitsu?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsaynö pasaypa rabyashgam mandacog rey quiquintapis carcelman wichgatsinä tsaychö wardiya castigananpä llapan jaganta päganganyag”. ");
INSERT INTO qxoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tsaynö willapäcurirmi Jesus nirgan: “Runa mayiquicunata llapan shonguyquicunawan mana perdonayaptiquega gamcunatapis Tayta Dios manam perdonayäshunquitsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tsaynö yachatsicur ushasquirnam Jesus Galilea provinciapita aywar Jordan mayupa wac-tsimpanpa tumargan Judea provinciaman. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsay quinranpa puriptin Jesuspa gepanta atsca runacunam aywayargan. Tsaychöpis geshyagcunata allïtsirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tsayman fariseucuna charnam llutanta parlatsiyta munar yachayllapa Jesusta tapuyargan: “¿Imaycallapis casquiptin warminpita runa raquicanmancu o manacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tsaynö tapuyaptinnam Jesus nirgan: “¿Manacu gamcuna liyiyarguyqui Tayta Diospa palabran gellgaranganta? Tsaychö nican Tayta Dios ollgutapis warmitapis camashga captin juntacar täyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tsaynöpanam warmipis ollgupis mamanpita y taytanpita yargucurna mushog castana ruracan. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsaynö ishcanpis manana dejanacunanpä Tayta Dios juntangantaga manam pipis raquinmantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsaynö niptinmi fariseucuna tapuyargan: “Tsayöraga ¿imanirtä Moises gellganganchö nican divorciu papelta firmapasquir warminta gargurinanpä cagta?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tsaynö niyaptinnam Jesus nirgan: “Tayta Diosga ollguta warmita camargan majatsacarnin mana raquicaypa cayänanpämi. Tsaynö captinpis runacuna munaynincunachö cawacuyaptinmi Tayta Dios Moises tantiyatsirgan tsaynö gellgananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Maygan runapis warmin adulteriu jutsata mana ruraycaptin juc warmiwan targa punta cag warmintam racchataycan. Tsaynömi runanpita raquicashga warmiwan tarpis jutsata ruraycan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tsaynam discïpuluncuna niyargan: “Tsaynö captinga manachä allitsu majayog caypis” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tsaynö niyaptinnam Jesus nirgan: “Majayog cayga allim. Tsaynö caycaptinpis Tayta Diosmi permitin waquincunaga majaynagllapis täcuyänanta. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquin runacunaga yuriyashga majaynaglla täcuyänanpämi. Waquinnam eunucu car majaynaglla täcuyan. Waquincunam itsanga Tayta Diospa alli willacuyninta willacur puricuyänan captin manana majatsacaytaga yarpäyannatsu. Pipis majaynaglla täcuyta munarga majaynaglla täcun allim”. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsaypitanam wamracunata Jesus caycanganman apayämurgan umanta yataycur Tayta Diosman mañacunanpä. Tsay apapagcunatanam discïpuluncuna michäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tsaynam discïpuluncunata Jesus nirgan: “Tsay wamracuna noga cagman shacayämunanta ama michäyaytsu. Cay wamracunanö cagcunam Tayta Diospa ñöpanman chäyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tsaynö nisquirmi wamracunapa umanman maquinta churarcur Tayta Diosman mañacurgan. Nircurnam tsaypita aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juc cutichönam juc jövin Jesusman aywaycur nirgan: “Tapuculläshayqui, taytay. ¿Imatatä ruräman Tayta Diospa ñöpanman chänäpä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tsaynö niptinnam Jesus nirgan: “Tayta Diospa ñöpanman chayta munarga munangannö mandamientuncunata cumplir caway. Ñöpanman runacuna imanöpa chäyänanpä cagtapis Tayta Dios nishgana caycaptinga ¿imanirtä nogataräga tapucamanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tsaynö niptinnam tsay jövin tapurgan: “¿Maygan mandamientucunatatä cumplïman, taytay?” nir. Tsaynam Jesus nirgan: “Runa mayiquita ama wanutsinquitsu, adulteriu jutsata ama rurayanquitsu, pipa imancunatapis ama suwacunquitsu, runa mayiquita ama llullapanquitsu, ");
INSERT INTO qxoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","taytayquitawan mamayquita shumag respitanqui, tsaynöpis runa mayiquita cuyapanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tsaynö Jesus niptinnam jövin nirgan: “Tsaycunataga wamra cangäpitam cumplirgö, taytay. ¿Imatä mas faltämanman cumplinäpä?” ");
INSERT INTO qxoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Niptin Jesusnam nirgan: “Tsay llapancunata cumplishga carpis Tayta Diospa ñöpanman chänayquipäga llapan imaycayquicunatapis ranticusquir tsay gellëtana faltapacogcunata aypuy. Tsaynö rurarninga gloriachömi mana ushacag riquëzata chasquinqui. Tsaycunata rurapacurir nogawan aywashun yachatsingäta yachacunayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsaynö niycuptinga pasaypa wamayashgam tsay jövin aywacurgan. Payga alläpa rïcu carninmi pasaypa wamayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsaynam discïpuluncunata Jesus nirgan: “¡Imanö ajam rïcu runacuna gloriaman yaycuyänanpäga! ");
INSERT INTO qxoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tsaypa rantinga mas fäcilchi aujapa uchcunpa juc camëllu ashmapis päsarinman rïcu runacuna gloriaman yaycuyänanpä cagpitaga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsayta wiyarnam discïpuluncuna pasaypa yarpachacur niyargan: “Tsaynö captinga ¿pinarä salvacur gloriaman yaycunga?” ");
INSERT INTO qxoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tsaynö niyaptinnam Jesus nirgan: “Quiquillanpitaga runacuna manam gloriaman yaycuyangatsu. Tayta Diosllam jutsancunapita perdonar gloriaman yaycatsinga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsaymi Pedro nirgan: “Nogalläcunaga imaycäcunatapis jagiriycayämurgö gamta gatiräyäna raycurmi, taytay. Tsaypitaga ¿imatä canga nogacunapäga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tsaynö niptinnam Jesus nirgan: “Fisyu final junagchö llapan runacunata juzgaptïmi chunca ishcay (12) trönucunachö jamacuyanqui. Tsaychömi gamcunapis chunca ishcay castapita mirag Israel runacunata juzgayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nogaman criyicamungan raycur pipis wayinta, waugincunata, panincunata, mamanta, taytanta, tsurincunata, chacrancunatapis jagireg cagga pachac (100) cuti mastam chasquiyanga. Y wanucurnam Tayta Diospa ñöpanman chäyanga imayyagpis cushishgana cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tsaynömi riquëzancunapä yarparagcunaga gloriaman mana yaycuyangatsu. Waquincunam itsanga Diosnintsic raycur imaycancunatapis jagireg cagcuna gloriaman chäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tsaypitam Jesus nirgan: “Tayta Diospa munayninchö cawagcunaga cay cuentuchö willacungänömi caycäyan. Juc runam tsaca tsacallana peyun asheg yargunä üva chacranchö arutsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tsayna payga peyuncunata tarir aycata pägananpäpis nisquir üva chacranman arog cachanä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tsaypitana peyun yaycuy öranöna yapay pläzapa cutir runacunata tarinä aruyta ashir caycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tsayna paycunata ninä: ‘Gamcunapis üva chacräman arog aywacuyällay. Aruyangayquipitaga complëtutam pägayälläshayqui’ nir. Tsaynö niptin paycunapis cushishga aywayänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Tsaypita yapaypis tsay runaga yargunä peyuncuna asheg, pullan junagnö y tardi mallwaynö rupay caycaptinpis. Tsayna taringan runacunatapis mincacur chacranman arog cachanä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Tsaypita rupay ullunaycaptinpis yapay pläzapa yargur runacunataga tarinä puriycäyagta. Tsayna paycunatapis ninä: ‘¿Gamcunapaga manacu aruyniquicuna can? Caychö goyatchä puricuycäyanqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Tsaynö niptinna paycuna niyänä: ‘Manam pipis mincacayämashgatsu arupäyänäpä, taytay’ nir”. “Tsayna ninä: ‘Tsayöraga gamcunapis chacräman aywayay üvata pallayämunayquipä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Tsaypita patsa tsacanaycaptinna tsay üva pallatseg runa mayoralninta ninä: ‘Llapan arogcunata gayascärir pägaycuy gepatarä arog chagcunapita gallaycur goyat arogcunayag’. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tsayna gayatsimuptin shayämunä tardirä arog yaycogcuna. Y paycunata päguta chasquiyänä juc jornal tincuta. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tsaynö chasquiyanganta ricarna goyat arog cagcunaga pägananpä witir yarpäyänä masllata chasquiyänanpä cagta. Tsaynö yarparpis juc jornal tincullata chasquiyänäga. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tsayna waquin cagcunawan iwallla chasquirna goyat arogcunaga chacrayogtaga ajar niyänä: ");
INSERT INTO qxoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Tsayrä yaycamogcuna juc öralla aruriyanganpita ¿imanirtä nogacunatawan iwal pägasquinqui, tsayläya achaychöpis aruycäyaptï?’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tsaynö niyaptinna chacrayog runa ninä: ‘Parlangantsicnöllam pägaycällä. Manam gamcunata engañaycä imätsu, taytay. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Parlangantsicnö päguta chasquiycarga ¿imatanatä munayanqui? Noga munarnachir gepa yaycamogcunatapis gamcunatawan iwalpis pägacü. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Quiquïpa gellënïta imata ruracuptïpis manam gamcunaga cuentayogtsu cayanqui. ¿Alli runa carnin tsaynö pägaycuptïcu chiquicuyanqui?’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tsaynö willacurmi Jesus nirgan: “Tsay arupacuyman punta yaycogwan gepa yaycogpis iwal päguta chasquiyangannömi puntata criyicogcunawan tsayrä criyicogcunapis llapancuna gloriaman chäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalenman aywaycäyanganchönam discïpuluncunata jucläman gayarir Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Gamcunaga musyayanquim Jerusalenman aywaycangantsicta. Tsaychömi noga Tayta Diospita shamogta sacerdöticunapa mandagnincuna y ley yachatsicogcuna prësu tsariyämanga. Nircurmi wanutsiyämänanpä juclä mana Israel runacunapa maquincunaman entregayämanga. Tsay runacunaman entregaycayämaptinmi asipäyämanga, astayämanga, y nircur crucificayämanga. Tsaynö captinpis quimsa junagtaga cawamushämi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsaypitanam Santiaguta y Juanta pusharcur maman aywargan Jesus cagman. Tsaynam Jesuspa ñöpanman gonguricuycur nirgan: “Rugaculläshayqui, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsaynö niptinnam Jesus tapurgan: “¿Imachö yanapanätatä munanqui?” nir. Tsaynam tsay warmi nirgan: “Taytay, mandacur cangayquichö cay ishcan wawäcunata churaycullanqui gamta mandäshiyäshunayquipä, jucta derëcha cag läduyquiman y jucagtana itsogniqui cagman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tsaynö niptinnam Jesus nirgan: “Gamcunaga manam musyayanquitsu imata mañacuyänayquipä cagtapis. Noga ñacar awantanäpä cagta ¿gamcuna awantayanquimantsurä?” nir. Tsaynam paycuna niyargan: “Aumi, awantayämanmi, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesusnam nirgan: “Rasunpa gamcunapis noga ñacangänöga ñacayanquim. Tsaynö captinpis itsognïman o derëchämanpis jamatsishä Tayta Dios nimangan cagllatam”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tsaynö mañacunganta wiyaycurnam waquin cag discïpulucunaga ajanapäyargan Santiagutawan Juanta. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tsaynam discïpuluncunata gayaycur Jesus nirgan: “Gamcuna musyayangayquinöpis nacion mandagcunaga mandacog cayayninman yäracuycurmi runacunata munayanganman mandayan. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Gamcunaga manam tsaynö cayta yarpäyanquimantsu. Tsaypa rantinga waquin runacunapita mas alli ricashga cayta munarga runa mayiquicunatarämi imaycachöpis yanapayänayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsaynömi nogapis Tayta Diospita shamurgö runacunata imaycachö yanapanäpä, manam munangäta ruratsinäpätsu. Tsaynömi ari shamurgö runacuna raycur wanur salvanäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jerico marcapita Jesus aywacuptin atsca runacunam gatipäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aywaraycäyaptin näni cuchunchönam ishcay wiscuyashga runacuna jamaraycäyargan. Paycunam Jesus päsaycagta wiyar gayacuyargan: “¡Unay rey Davidpa castan Jesus, nogacunata cuyapaycayällämay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tsaynö gayacuyaptin runacunaga ajäpäyargan upälläcuyänanpämi. Tsaynö ajäpäyaptinpis masrämi paycunaga gayacuyargan: “¡Rey Davidpa castan Jesus, nogacunata cuyapaycayällämay ari!” nir ");
INSERT INTO qxoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tsaynö gayaräyaptinnam Jesusga aywaycanganta ichisquir tapurgan: “¿Imachö yanapanätatä gamcuna munayanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Niptinnam paycuna niyargan: “Ñawïcunata allïcatsinayquitam munayällä, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tsaynö gayacur mañacuyaptin cuyapasquirnam ñawincunata yataycurgan. Tsaynö yataycuptillanmi jinan öra allisquirgan. Tsaynam paycunapis Jesusta gaticurcurna aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tsaypitanam discïpuluncunawan Jesus aywayargan Jerusalenman. “Olivos” ningan jircan washa lädunpa Betfage marcaman yaycuraycarnam puntatsir ishcay discïpuluncunata cachargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Aywayay tagay marcapa. Tsay marcaman yaycuna ricogllachömi tariyanqui maltalla wawayog ashnu wataraycagta. Tsayta pascarir apayämunqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pipis ‘¿Imapätä ashnüta pascayanqui?’ niyäshuptiquega niyanqui: ‘Señor Jesusmi cachayämashga. Rätupallatam cutiratsiyämushä’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tsaycuna ruracänanpä cagtam Tayta Diospa unay willacognin profëta caynö gellgargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Israel runacuna, ricayay malta ashnun muntashga mandacogniquicuna shamuycagta. Mulan muntashga Jerusalenman shamunanpa rantinmi lluta runanölla ashnun muntashga yaycaycämun”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesus ningannöllam discïpuluncunaga aywar malta ashnuta wawantinta apayämurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nircurmi punchuncunata tsay malta ashnuman carunapäyargan Jesus muntacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tsaynö muntacushga Jesus aywaptinnam waquin runacuna jacuncunata punchuncunata jipirir Jesus aywangan näniman gopipäyargan. Waquincunanam palmëra jachapa rämancunata paquirir paquirir näniman mashtapäyargan payta cushishga chasquicurnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tsaynam ñöpanta y gepanta aywagcunapis cushicuywan caynö gayaräyargan: “¡Tayta Dios cachamungan mandamagllantsic caychönam caycan! Payga unay rey Davidpa castanmi. ¡Tayta Dios imayyagpis alabashga caycullätsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tsaynö Jerusalenman Jesus yaycuptinnam runacuna wayincunapita yargascärayämurgan jucninpis jucninpis tapunacurnin: “¿Pirä tagay runaga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tsaynam runacuna niyargan: “Payga Galileachö Nazaret marcapita Jesusmi. Payga Tayta Diospa willacognin profëtam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tsaypita templuman yaycurirnam templupa patiunpita Jesus gargurgan ranticur caycagcunatapis y rantipacogcunatapis. Tsaynömi gellë trocatsegcunapa mësancunatapis y paluma ranticogcunapa jamacuyänancunatapis jitar cumar ushargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tsaynö rurarmi paycunata nirgan: “Tayta Diospa palabran gellgaranganchöpis caynömi nican: ‘Temploga canga noga Diosllayquicunaman mañacayämunayquillapämi’. Tsaynö gellgaraycaptinga ¿imanirtä gamcuna ticraycätsiyanqui ladroncunapa machaynintanöna?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsaychönam gapracunapis y ratacunapis Jesuspa ñöpanman witipäyargan. Paycunataga llapantam allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsaynö allïtsinganta ricaycurnam mandacog sacerdöticuna y ley yachatsicogcuna feyupa ajäyargan. Tsaynöllam ajäyargan wamracuna caynö negta wiyarpis: “¡Mandamänantsicpä rey Davidpa castanta cachamunganpita Tayta Dios alabashga catsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tsaynö ajarninmi Jesusta niyargan: “¿Wiyanquicu tsay wamracuna nicäyanganta?” Tsaynö niyaptinnam Jesus nirgan: “Aumi, wiyämi. ¿Manacu gamcuna liyiyarguyqui Diospa palabran caynö gellgaraycanganta: ‘Tayta Dios, gamta alabayäshunayquipä, wasgishga wamracunatapis y chuchuycag wamracunatapis tantiyatsirguyquim’ nir?” ");
INSERT INTO qxoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tsaycunata nisquirnam patsarangan Betania marcaman aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Warayninnam Jerusalenman Jesus cutiycanganchö mallagacuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsaynam hïguspa yuranta ricasquir aywargan prütanta micurcuyta munar. Prütanta ashir mana tariycurnam raprallan verdiraycagta ricaycur nirgan: “¡Cananpitaga manam imaypis wayunquinatsu!” nirnin. Tsaynö niycuptin jinan öram hïguspa yuran tsaquicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tsayta ricaycurmi discïpuluncuna Jesusta tapuyargan: “¿Imanöpatä tsay hïguspa yuran tsaquisquishga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tsaynam Jesus nirgan: “Llapan shonguyquicunawan Tayta Diosman yäracurga cay hïgus yurata tsaquiratsingänöllam, gamcunapis imayca milagruta rurayta puëdiyanqui. Tagay jircata ‘¡Lamarman witicuriy!’ niyaptiquipis witicurinmanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Llapan shonguyquicunawan yäracur imatapis Tayta Diosman mañacurga chasquiyanquim”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tsaypita Jerusalenman chärirnam Jesus templuman yaycurgan. Tsaychö yachatsicuycaptinmi mandacog sacerdöticuna y Israel runacunapa autoridänincuna Jesusta tapuyargan: “Gamga ¿ima puëdeg cayniquiwantä templuchö ranticogcunata gargurguyqui? ¿Pitä mandashurguyqui tsaynö gargunayquipä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Tsaynö niyaptinmi paycunatapis Jesus tapurgan: “Gamcunatapis canan mä, tapuyäshayqui. ¿Pitä Juanta cachamurgan bautizacunanpä? ¿Tayta Dioscu o runacunacu? Tapungäta niyämaptiquega nogapis willayäshayquim tsaycunata ruranäpä pï cachamangantapis”. Tsaynö Jesus niptinnam quiquincuna pura niyargan: “Ama nishuntsu Tayta Dios cachamunganta. ‘Tayta Diosmi cachamushga’ nishgaga ‘¿Imanirtä criyiyargayquitsu?’ nimäshunmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y tsaynölla ama nishuntsu runacuna cachamungantapis. Tsaynö niycushgaga sagmarchir ushaycamäshun. Llapanmi yarpäyan Diospa willacognin Juan canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsaynö willanacurirmi paycuna niyargan: “Manam musyayätsu pï cachamungantapis” nir. Tsaynö niyaptinmi Jesus nirgan: “Gamcunapis mana willaycayämaptiquega nogapis manam willätsu pipa munayninta rurar templupita ranticogcunata gargungätapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tsaypitanam Jesus nirgan: “Juc runapam ishcay tsurincuna capunä. Tsaynam mayor cag tsurinta ninä: ‘Au hïju, canan junag arupaycallämay ari’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tsaynö rugaptin tsurin ninä: ‘¡Manam tiempü cantsu yanapanäpä!’ nir. Tsaynö nisquirpis yarpachacurirga papänin yanapag aywanämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tsaypitana jicpa cag tsurintapis mincacunä. Payga ninä: ‘Achyä ari shamushächir, papä’ nirnin. Arog aywananpä tsaynö aunircurpis manam arusheg aywanätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tsaycunata willapäcurirmi mandacog sacerdöticunata y autoridäcunata Jesus tapurgan: “Tsay ishcan waugicunapita ¿maygan cagtä papänin mandanganta cumplirgan?” nir. Tsaynö niptinnam: “Mayor cag tsurinmi” niyargan. Tsaynam Jesus nirgan: “Gamcunapis mana wiyacog jicpa cag tsurinnömi caycäyanqui. Tsay mayor cag tsurin ñëgarcur yanapangannömi Romapä impuestu cobragcuna y jutsa rurag warmicunapis caycäyan. Jutsancunata jagirirga Tayta Diospa munayninchöna cawar yarpachacurnam Tayta Diospa ñöpanman chäyanga. Peru gamcunam itsanga Tayta Diospa ñöpanman chäyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautistaga yachatsirgan jutsa ruraycunata jagirir Tayta Dios munangannöna cawayänayquipämi. Tsaynö willacuycaptinpis gamcunaga manam cäsucuyarguyquitsu. Tsay impuestu cobragcuna y jutsa rurag warmicunam itsanga Juan willacungancunata cäsucuyashga. Tsaynö paycuna cäsucuyangantana ricaycarpis gamcunaga manam imaypis cäsucuyarguyquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tsaypita mastapis Jesus caynö willacurganmi: “Juc runam chacranman üvata plantatsinä. Nircurmi maytsayninpa genchatsinä. Tsaypitam pogushga üvapa yacunta jipinanpä pözutapis jinan chacrallachö ruratsinä. Tsaynömi üvata täpatsinanpä tsucllatapis ruratsinä. Tsaynö llapantapis ruraycatsirmi chacran arog runacunata arrendacuycur juclä marcapa aywacunä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Cosëcha gallaycuptinnam wätaynincunata cachanä chacra arrendunpita cobracayämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cobracog chäyaptinna chacra arrendaragcuna waquinta magayämunä, waquintana wanutsiyänä, y waquintanam sagmaraycar cutitsiyämunä. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsaynö ruraycäyaptinpis chacrayogga yapay mastana wätaynincunata cachanä. Paycunatapis tsaynölla rurayämunä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Tsayna chacrayogga yarpachacunä: ‘Cananga cachashä jucllaylla cuyay tsurïtam. Paytaga capazmi respitayämunga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tsaynö yarpasquirna cachanä. Tsayna tsurin aywaraycagta ricasquir willanacuyänä: ‘Tagä shamuycan cay chacrawan quëdagpä cag heredëru. Nogantsicpäna cay chacra cacunanpä tagayta wanuratsishun’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsaynö willanacuyangannölla duëñupa tsurin chaycuptin chacrapita jucläman jipisquir wanuscatsiyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Tsaynö rurayanganpita tsay üva chacrayogga ¿imatarä ruranga chacranta gechuyta munag runacunata?” ");
INSERT INTO qxoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Niptinnam paycuna niyargan: “Tsay mana alli runacunataga mana cuyapaypachir wanutsir ushanga. Nircurchir tiempunllachö arrendunta pägag cagta chacrantaga arrendacunga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Tsaynam Jesus nirgan: “Tsay chacra arrendarag mana alli runacunata ushacätsingannömi gamcunatapis Tayta Dios infiernuman gaycuyäshunqui. Pay munanganman cawag runacunatam itsanga salvacionta taritsinga. Gamcuna infiernuman mana gaycucayta munarga Tayta Diospa palabran gellgarangan caynö ninganta tantiyacuyay: ‘Wayi sharcatsegcuna “Cay rumi manam allitsu” nir jitariyangantam juc alli albañilga mayistra rumimanrä ticraratsin. Tsaynömi nogata runacuna mana välegpä cuentayämaptinpis Tayta Diosga alläpa väleg canäpä churamashga. Tsayga ima cushicuypämi criyicogcunapä’. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pipis tsay mayistra rumiman ishquirga tacacunmi. Y pipa jananmanpis tsay rumi cuchpacarga pasaypam ushacäratsin. Tsaynömi pipis nogaman mana criyicamog cagga infiernuchö ñacayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsaycunaman iwalatsiypa yachatsicuptinmi sacerdöticunapa mandagnincuna y fariseucuna tantiyacuscäriyargan paycuna castigacäyänanpä Jesus parlaycanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tsaynam rabyanar prësu tsariyta munarpis camäpacuyargantsu runacunata mantsaparnin. Llapan runacunam parlar niyargan Jesus Tayta Diospa willacognin profëta canganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tsaypitanam gloriaman yaycuypä cagtana Jesus yachatsirgan casacuy fiestaman iwalatsiypa caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Juc reymi ollgu tsurin casacuptin fiestata ruranä. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tsaynam wätaynincunata cachanä invitangan runacunata casacuy fiestaman pushayämunanpä. Tsay invitäduncunaga manam ni mayganpis aywayta munayänätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tsaypita yapaymi waquin wätaynincunatana cachanä caynö nir gayayämunanpä: ‘Törucunata y weran weran cag ashmacunata pishtascäratsir micuyta cusnacatsishganam caycan. Llapanpis gayatsingäcuna päsacayällämutsun tsurï casacuycaptinga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tsaynö gayatsiptinpis manam ni mayganpis aywayänätsu. Tsay aywayänanpa rantinmi waquincuna aywacuyänä chacran arog. Waquinnam aywayänä negociuncunaman ranticog. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquinnam tsay cachancunata magayänä y wanutsiyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Tsaynam fiesta rurag reyga feyupa ajarna soldäduncunata cachanä wätaynin wanutsegcunata wanutsiyänanpä y marcancunatapis rupatsir ushacätsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nircurnam wätaynincunata ninä: ‘Tsurïpa casamientunta celebranäpä llapanpis listunam cashga. Tsaynö caycaptinpis tsay gayatsingä runacuna imapäpis mana cuentayämarmi mana shayämushgatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cananga cällicunapa aywar runacunata pitapis maytapis willayämuy cay listapacushga fiestaman shayämunanpä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Tsaynö niycuptinnam wätaynincunaga tincuyanganpita alli runatapis mana alli runatapis willayaptin aywayänä wayipis juntagpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tsaynam reyga runacunaman ricag yaycurna ricasquinä tsaychö juc runa casacogta mana respitar lluta röpashgalla caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsaynam tsay runata tapunä: ‘Amïgu, ¿imanirtä cayman yaycamurguyqui alli röpayquita mana trocacullar?’ nir. Tsaynö tapuptinnam tsay runaga imaninäpistsu mana trocacullar aywashga car. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsaynam wätaynincunata rey ninä: ‘Cay runa tsurïta imapäpis mana cuentar tsaynö shamunganpita chaquinta maquinta pancarcur tsacayman jitarpayämuy. Tsaychömi wagar quiruntapis uchur yarpayta taringa’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsaynö cuentacurirmi Jesus nirgan: “Tsaynö Tayta Dios llapan runacunata gloriaman chäyänanpä gayatsiptinpis tsurinta respitar cäsucogcunallam ñöpanmanga chäyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsaypitanam fariseucuna templupita yargurir willanacuyargan achäquita ashirninna alli shimillancunapa Jesusta parlapäyänanpä, tsaychö llutanta niptinga prësur apatsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tsaynam imata niyänanpäpis shumag yacharcatsir fariseucuna cachayargan runancunata y Herodespa janan sharcog runacunata. Tsay aywagcunam Jesusta niyargan: “Taytay, nogacuna musyayämi Tayta Dios munangannö runacuna cawayänanpä imaypis yachatsicuycangayquita. Gamga imata yachatsicurpis maychöpis mana mantsapacuypam yachatsicunqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Cananga jucta tapucuyälläshayqui, taytay. ¿Roma nacionman impuestuta pägashwancu o manacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Llutanta parlatsiyta munar yachayllapa tapuyanganta musyarnam Jesus nirgan: “¡Alli tucur parlagcuna! ¿Imanirtä gamcuna tsaynö tapupäyämänayquipä willanacuyarguyqui? ");
INSERT INTO qxoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä, ricatsimay tsay impuestuta pägacuyänayqui gellëta”. Tsaynö niptinmi tsaraycäyangan gellëta Jesusta aptaparcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tsayta ricaycurnam Jesus tapurgan: “Cay gellëchö ¿pï runapa reträtuntä caycan? ¿Pipa jutintä gellgaraycan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tsaynö tapuptinnam niyargan: “Romachö mandamagnintsic emperadorpam”. Tsaynam Jesus nirgan: “Tsayöraga, emperadorpa cagta emperadorta goycuyay. Tayta Diospa cagtaga Tayta Diosta goycuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsaynö niptinnam tsay runacuna imaniytapis mana puëdirna aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tsay junagllam waquin saduceo cag runacunapis Jesusman chäyargan. Nircurmi wanushgacuna cawariyämunanpä cagta mana criyir caynö niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Taytay, Moises gellganganchöga caynömi nican: ‘Juc runa tsuriynaglla wanucuptin gepa cag wauginna llumtsuynin viüdawan tätsun. Tsaynöpam viüdachö wamran yuriptin tsay wanog cag wauginpa tsurin cuentana canga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tsaymi canan cuentariyäshayqui, taytay. Ganchis (7) waugicunash cayänä. Mayor cagshi juc warmiwan tänä. Payga tsurin manarä captinshi wanucunä. Tsayna gepan cag wauginnash tänä tsay viüdawan. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tsaypita paypis tsurin manarä captinshi wanusquinä. Tsaypita mas ñuñushga cagna tänä tsay viüdawan. Paypis wanusquinä tsurin manarä captinllarä. Tsaynölla llapan waugiwanpis tsay viüdaga wanuyayllanta tänä. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsaypitana tsay viüdapis wanucunä. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Canan mä, niyämay. Wanushgacunata Tayta Dios cawaritsimunan junagga ¿mayganpa warmintä canga, ganchis waugiwan tashga caycaptinga?” ");
INSERT INTO qxoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tsaynö niyaptinnam Jesus nirgan: “Tsaynö nirnin Diospa palabran gellgaranganta liyiycarpis imata ningantapis manam tantiyayanquitsu. Runacunata Tayta Diosmi poderninwan cawaritsimunga. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wanuyanganpita cawarircamurga mananam warmiyog ni gowayogpis cayanganatsu, sinöga ciëluchö caycag angelcunanöllanam cayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wanushgacuna cawariyämunanpä cagta ¿manacu liyiyarguyqui Diospa palabran gellgaranganta? Abraham, Isaac, y Jacob wanunganpitaga alli unaytarämi Tayta Dios Moisesta parlapargan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nogaga Abraham, Isaac, y Jacob adoraycäyangan Diosmi cä’ nir. Wanushgacuna mana cawariyämunan captinga ¿imanöpatä Abraham, Isaac, y Jacob Tayta Diosta adoraycäyanman? Tsaynö caycaptinga ¿imanirtä gamcuna mana criyiyanquitsu wanushgacuna cawariyämunanpä cagta ni runacuna almayog cayanganta?” ");
INSERT INTO qxoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tsay ningancunata wiyaycurnam runacuna cushicuyargan Jesuspa yachatsicuyninpita. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tsaypita saduceucunata Jesus upällaratsinganta musyarnam fariseucuna goricaycur yapay willanacuyargan Jesusta achäquita ashiparnin llutancunata parlatsiyta munar. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tsaynö willanacurirmi ley yachatsicog juc musyag runa Jesusta tapurgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Taytay, ¿maygan mandamientutatä mas cäsucushwan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tsaynö tapuptinmi Jesus nirgan: “‘Llapan shonguyquiwan y llapan yarpayniquiwan imaypis Tayta Diosta cäsurnin cawayay’. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tsay mandamientum llapan mandamientupitapis mas cumplinantsicpäga caycan. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tsaynöllam jucag mandamientupis nican: ‘Runa mayiquita llapan shonguyquiwan cuyay’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tsay ishcay mandamientuta cumplirga Moises gellgangan llapan mandamientucunata y profëtacuna gellgayangan mandamientucunatapis cumpliycag cuentam caycäyanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsaypitanam fariseucuna tsaychö goriraycäyaptin paycunatana Jesus tapurgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gamcunapäga ¿maygan castapitatä salvacog yuringa?” nir. Tsaynö tapuptinmi niyargan: “David castapitam yuringa, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsaynam Jesus nirgan: “Unay rey Davidpa castanpita captinmi gamcunaga yarpäyanqui salvacog shamog runalla canganta. Payga manam runallatsu, sinöga Diosmi. Runalla captinga ¿imanirtä rey caycar quiquin Davidpis Espiritu Santo tantiyatsiptin salvacog rey canganta ninman cargan? Tsay ningantam David gellgargan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Salvacogga mandacog reynïmi. Tsaymi payta Tayta Dios ninga: “Jamacamuy derëcha cag lädüman nogawan iwal mandacog canayquipä. Tsaypitam llapan chiquishogniquicunata castigar sitiunman churashun” nir’. ");
INSERT INTO qxoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tsaynö caycaptinga ¿imanöpatä salvacogga Davidnö runalla canman quiquin Davidpis salvacog rey canganta nicaptinga?” ");
INSERT INTO qxoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tsaynö niptin manam pipis contestayta puëdiyargantsu. Tsaymi tsay junagpita tsariyta munagcuna mastaga tapupayta almitiyargannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nircurnam runacunata y discïpuluncunata Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","“Ley yachatsicogcunapis y fariseucunapis Diospa palabranta yachatsiyäshuptiqui cäsucuyay. Peru itsanga paycuna munayanganman cawayangannöga ama cawayaytsu. Diospa palabranta yachatsicurpis quiquincunaga manam cumpliyantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paycunaga runacuna imanö caytapis mana camäpacuyanganyagmi Moises gellgangan leycunaman yapa-yaparcur cumplitsiyta munayan. Tsaynö captinpis shumag alli tupayllapa yachatsiyänanpa rantinmi ollgü tupayparä yachatsiyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Paycunaga waquin runacunapitapis filacteriancunata mas jatunta ruraycur puritsiyan ricagcuna ‘Payga Tayta Diosta cäsucog alli runam’ niyänallanpämi. Tsaynöpis waquin runacunapita mas ata plëcucunatam röpancunapa chuscun cuchunman churapäyan ricagcuna ‘Payga Tayta Diosta cäsucog alli runam’ niyänallanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Paycunaga micupacuycunaman gayatsiyaptinpis mësamanrämi jamacuyta munayan. Tsaynöllam goricäcuyänan wayicunachöpis allin cag jamacunamanrä jamacuyta munayan. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Paycunaga pläzacunachöpis yachatsicog cayayninpita runacuna alabayänallantam munayan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Gamcuna ama paycunanöga cayanquitsu. Gamcunata noga yachatsirgö manam yachag tucuyänayquipätsu, sinöga discïpulücuna car tsay waugilla cayangayquita tantiyacuyänayquipämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pï yachatsicogtapis Diosnintsictanöräga ama ricayanquitsu. Tayta Diosmanga manam pipis iwalantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Gamcuna willacuynïta yachatsicur ama alabashga cayta munallar puriyanquitsu. Manam tsaynö cayänayquipätsu noga gamcunata yachatsirgö. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maygayquicunapis alli ricashga cayta munarga mana yachag tucuypa runa mayiquicunatam imaycachöpis yanapayänayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Maygayquipis yachag tucog cayaptiquega Tayta Dios manam imapäpis cuentayäshunquitsu. Mana yachag tucur pitapis maytapis yanapag cagcunatam Tayta Diosga altuchö tsaranga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Allau ley yachatsicogcuna y fariseucuna! Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui. Gamcunaga yachag tucurmi Diospa alli willacuyninman mas masta cabalarcur llutancunata yachatsiyanqui. Runacunata tsaynö pantatsiyangayquipitam quiquiquicunapis Tayta Diospa ñöpanman chäyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Ley yachatsicogcuna y fariseucuna! ¡Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui! Gamcunaga Tayta Diosman mañacur imanömi gälacuyanqui runacunapa ricanallanchöga. Nicarrämi viüdacunapataga cuyapag tucullar imaycantapis ushapäyanqui. Tsaynö rurayangayquipitam gamcunata Tayta Dios infiernuman gaycuyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Ley yachatsicogcuna y fariseucuna! ¡Gamcunataga yachag tucog cayangayquipitam mana cuyapaypa Tayta Dios castigayäshunqui! Gamcunaga maypa tsaypapis aywayanqui fariseo cayman runacuna yaycuyänanpä yachatsillarmi. Tsaynö yachatsiyaptiqui yachacuscärirnam gamcunapita masna yachag tucuyan. Tsaynö cayangayquipitam gamcunapis y paycunapis infiernuchö ñacayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Tayta Dios mana cuyapaypam castigayäshunqui! Gamcunaga niyanqui: ‘Nogantsicga Diospa palabran gellgaranganta yachatsirnin gaprata jancharag cuentam mana musyagcunata yachaycätsintsic’ nirmi. Tsaynö nirpis quiquiquicunam tantiyacuyanquitsu llutancunata yachatsir pantaycätsiyangayquita. Mana tantiyacurmi nicäyanqui: ‘Pipis templupa jutinchö imatapis aunicur jurarnin mana cumpliyaptinpis manam imananpistsu. Templu rurinchö örupa jutinchö jurarmi itsanga tsaytaga cumpliyänayqui’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana tantiyacog musyag tucogcuna! Nagana templupa jutinchö aunicur jurarga, peru templu rurinchö caycag örupa jutinchöpis juraycäyanquinachä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Gamcunaga caynö nirpis runacunata yachatsiyanquim: ‘Imatapis rurayänanpä aunicur altarpa jutinchö pipis jurarnin mana cumpliyaptinpis manam imananpistsu. Peru altar jananchö churarag ofrendapa jutinchö jurarmi itsan tsaytaga cumpliyänayqui’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mana tantiyacog runacuna! Nagana altarpa jutinchö aunicur jurarga, peru altar jananchö ofrendapa jutinchöpis juraycäyanquinachä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Altarpa jutinta jayarirga manam altarpa jutillantatsu jayariycäyanqui, sinöga altar jananchö churarag cagcunapa jutintapis jayariycäyanquinam. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Templupa jutinta jayarirpis manam templupa jutillantatsu jayariycäyanqui, sinöga templuchö caycag Tayta Diospa jutintapis jayariycäyanquim. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tsaynömi ciëlupa jutinta jayarirnin ciëluchö Tayta Dios jamaraptin quiquin Tayta Diospa jutintapis jayariycäyanqui. ¿Tsaycunatacu mana tantiyacuycuyanquitsu?” ");
INSERT INTO qxoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Allau ley yachatsicogcuna y fariseucuna! Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui. Gamcunaga templuman Tayta Diospä garaynin apayänayquipä mentatapis, anistapis, ni comïnutapis chunca (10) aptay capuyäshuptiqui juc aptaytaga imaypis raquiycäyanquim: ‘Tayta Diospa palabran gellgaranganmanmi llapantapis cumpliycäyä’ nirnin. Tsaycunata rurarpis manam runa mayiquicunawan allega cawayanquitsu ni manam cuyapäyanquitsu. Nircur imata aunircurpis manam cumpliyanquitsu. Diospä ichic garayta apar cumplingayquinölla runa mayiquicunata alli ricayay, cuyapäyay, y imata aunirpis cumpliyay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“¡Mana tantiyacog yachag tucogcuna! Tayta Dios ninganta juc ishcaycunata cumplirninpis mas cumpliypä cagcunataga manam cumpliyanquitsu. Tsaynö carmi yacuchö chuspita shuyshuycurrä upurpis mana mayaylla jatuncaray camëllu ashmata ultacurcognörä caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Ley yachatsicogcuna y fariseucuna! ¡Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui! Tutumayquicunata y matiquicunata janallanta awirir rurin ganrata dejaycognömi caycäyanqui. Tutumapa y matipa rurinchö ganra caycagnömi llutan yarpayniquicunawan y imaycapä mallag cayangayquicunawanga ganra shongu caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Mana tantiyacog fariseucuna! Puntataga cuentata gocuyay jutsa rurayniquicunata jagiyänayquipä cagta. Tsaynöpam Tayta Diosta chasquicur pay munangannö cawayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Ley yachatsicogcuna y fariseucuna! ¡Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui! Gamcunaga aya pamparangan cuyayllapä rurashga nïchunömi caycäyanqui. Nïchupa janan cuyayllapä captinpis rurinchöga ¡imanömi tullucunapis ismur asyaycan! ");
INSERT INTO qxoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tsaynöllam gamcunapis runacuna ricayäshunayquillapäga, ä alli tucuycuyanqui. Peru mana alli yarpayniquicunawanga ¡ima ricog melanaypämi caycäyanqui!” ");
INSERT INTO qxoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Allau ley yachatsicogcuna y fariseucuna! Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui. Tayta Diospa willacognin profëtacuna gellgayangancunata cumpleg tucurpis manam imapäpis cuentayanquitsu. Tsaynö carnin alli cayangayquita runacuna niyänallanpämi tsay profëtacuna pamparäyangan jananchö capillancuna ruraparnin adornarpis cayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y niyanquiran tsaypis: ‘Tsay witsancuna cawarga nogacuna manam profëtacunata wanutsïshiyämantsu cargan’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tsaynö nirpis profëtacuna gellgayangancunata mana cäsucur gamcunaga paycunata wanutseg unay runacunanöllam caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Tayta Diospa unay willacognin profëtacunata wanutsiyangannölla nogatapis wanutsiyämayna ari! Fisyu final junagchö unay wanutsicogcunapitapis masmi gamcuna castigacäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Culebranö mana alli runacuna! Tayta Dios infiernumanna gaycuyäshunayqui caycaptinga ¿imanöparä salvacuyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Noga cachamungä willacogcunata y yachatsicogcunata gamcuna chasquicuyänayquipa rantinmi waquinta crucificaypa wanutsiyanqui, waquintanam goricäcuyänan wayicunachö munaylla astayanqui y marcan marcanmi carcelcunaman wichgatsiyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tsaynö cayangayquipitam gamcunata Tayta Dios juzgayäshunqui, Abelta wanutsegtanö, Berequiaspa tsurin Zacariasta altarpa ñöpanchö wanutsegtanö, y mas waquin profëtacunata wanutsegcunatanö. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Allau, tsaynö cayangayquipitam gamcunataga Tayta Dios mana cuyapaypa castigayäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tsaypitam Jesus nirgan: “¡Jerusalen runacuna! ¿Imanirtä Tayta Dios cachamungan profëtacunataga y alli willacuyninta willacogcunataga unaypitapis wanutsiyanquilla? Nogaga imanömi gamcunata goriyta munargö, imayca wallpa chipsancunata goriycur ogllagnöpis. Tsaynö goriyta munaycaptïpis gamcunaga munayangayquichömi cacuyarguyqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Tsaynö cayangayquipita gamcunata Tayta Dios dejariyäshunquim y chiquiyäshogniquicunam munanganta rurar marcayquicunatapis ushacätsiyanga. Tayta Dios goricamaptin manam ricayämanquinatsu ‘¡Tayta Dios cachamungan salvayämaglläcuna shacallämuy!’ niyangayqui junagyag”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Templupita yargurir Jesus aywacuycaptinnam discïpuluncuna niyargan: “¡Cuyayllapä jatusag rumicunawan sharcatsishga templuntsic imanö shumagmi, au taytay!” ");
INSERT INTO qxoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tsaynö niyaptinnam Jesus nirgan: “Cay ricaycäyangayqui templu imanö cuyayllapä sharcatsishga carpis juc junag chipyaypa ushacätsishgam canga. Manam ni juc rumipis pergaranganchö quëdangatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tsaypita discïpuluncunawan Jesus aywacurnam Olivos jircanchö jamapäyargan. Tsaychönam discïpuluncuna tapuyargan: “Ningayquinö ¿imaytä templuta ushacätsiyanga, taytay? Tsaynöpis cutimunayquipäga y cay patsa ushacänanpäga ¿imacunarätä päsanga, taytay?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tsaynö tapuyaptinmi Jesus nirgan: “Pipis llutanta yachatsicur mana pantatsiyäshunayquipä shumag tantiyacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Atscagmi criyitsicogcuna shayämunga nogaman ituycullar: ‘Nogam salvacogga cä’ nirnin. Tsaynö nirmi atsca runacunata criyitsiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maytsay nacioncunachöpis gyërra captin y wanutsinacuy captin ama mantsacäyanquitsu. Tsaycunarämi puntataga päsanga. Tsaycuna captinpis cay patsaga manarämi ushacangarätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Juc nacionwan jucag nacionmi gyërraman yaycuyanga. Tsaynöllam muchuy captin mallagay canga. Terremötupis maytsaychömi canga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tsaynö captinpis ñacaycunapa gallaycunallanrämi tsaycunaga canga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tsay witsancunam nogaman criyicamogcunata runacuna chiquirnin prësu tsariyanga, ñacatsiyanga, y wanutsiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tsaynö ñacaycuna captinmi nogaman criyicayämunganpita waquincuna witicuriyanga. Nircurnam mana witicogcunatana chiquir autoridäcunaman apatsiyanga castigayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tsay tiempucunam Tayta Diospa willacuyninta willacog tucogcuna masrä yuriyanga llutancunata criyitsicur. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Maytsaychöpis chiquinacuyllana captinmi runacuna cuyanacurga cawayanganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tsaynö captinpis wanunganyagpis nogaman criyicamog cagcunam Tayta Diospa ñöpanman chäyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Cay alli willacuynïta maytsay runacunaman willacuriyaptinrämi noga cutimushä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tayta Diospa willacognin profëta Danielmi gellgargan templuman yaycuycur mana alli runa imayca llutancunata rurananpä cagtapis. Tsay gellgangannöllam llapanpis ruracanga. (Jesucristo tsaynö ninganta liyegcunaga shumag tantiyacuyätsun.) ");
INSERT INTO qxoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tsay mana alli runa templuman yaycuptin Jerusalen quinran marcacunapita geshpir aywacuyätsun. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wayincunapitapis juclla geshpicuyätsun imancunamanpis manana jipeg cutiypa. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chacranchö caycagcunapis geshpir aywacuyätsun. Wayincunaman ama cutiyätsunnatsu trocanancunaman jipegrä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tsay mantsariypä ñacay junagcuna allau geshyag warmicuna y llullu wawayog warmicuna, paycuna ¡ima cuyapaypärä cayanga! ");
INSERT INTO qxoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tayta Diosman mañacuyay tsay junagcuna tamya witsanman ni säbadu jamapay junagman mana camacänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsay junagcunaga alläpa cuyapaypämi runacuna ñacayanga. Cay patsata Tayta Dios camanganpitapis manam tsaynö ñacayga cashgatsu. Y mananam yapayga tsaynö ñacaycuna canganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Acrangancunata cuyaparmi Tayta Dios tsay ñacaycunata päratsinga. Tsay ñacaycunata mana päratsiptinga llapanpis ushacäyanmanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Tsay junagcunam runacuna niyanga: ‘Tayta Dios cachamungan salvacog caychömi’ o ‘Wacchömi caycan’ nirnin. Tsaynö niyaptin ama ichicllapis criyiyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tsaynöpis waquinga ‘Tayta Dios cachamangan salvacogmi cä’: ‘Diospa willacognin profëtam cä’ nirmi llullacuyanga. Runacunata criyitsiyänan cashgam imayca milagrucunatapis rurayanga. Imaycanöpa engañarpis Tayta Diosman criyicogcunataga manam engañayta puëdiyangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tsaycuna manarä päsaptinmi gamcunata willaycä criyitsicur llutan yachatsicogcunata mana cäsupäyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Pipis ‘Tayta Dios cachamungan salvacog tsunyag jircachömi caycan’ niyäshuptiqui ama ricag aywayanquitsu. ‘Washachömi pacaraycan’ niyäshuptiquipis ama criyiyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ciëluchö tillagucuy jucagläpita jucagläyag atsicyaptin runacuna ricayangannömi noga ciëlupita cutimogtapis llapan runacuna ricayämanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tsunyagcunachö wiscurcuna tumaycachar musyatsicuyan maychöpis wanushga ashma jitaraycangantam. Tsaynömi noga ningäcuna ruracagta ricar musyayanqui noga cay patsaman cutimunäpäna cagta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tsaynö feyupa ñacaycuna päsariptin rupaypis ni quillapis mananam atsicyanganatsu. Y nircur llapan estrëllacuna shushuyämungam. Ciëlupis sicsicyangam. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tsaypitaran nogata ricayämanga pucutay jananta chipipirrä shamuycagta. Tsaynö shamuycagta ricaycayämarmi itsanga maytsay runacunapis pasaypa mantsarir wagayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsay junag Tayta Dios cornëtata jinchi tucaratsimuptinmi angelnïcunata cachamushä. Paycunam maytsaypitapis nogaman criyicamogcunata goriyämunga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","33","“Cay hïgusman iwalatsir ningäcunata yarparäyanqui. Musyayanquim tamya tiempu gallaycuptin hïgus jachapa yuran wegllimunanpäna canganta. Tsaynömi cay ningä ñacaycuna gallaptin gamcunapis tantiyayänayquina cutimunäpä cercana canganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cay ningäcuna gallaptin tsay tiempu runacuna manarä wanuyaptinmi llapanpis cumplinga. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ciëlu y cay patsa ushacäcuptinpis noga ningäcunaga llapanmi ruracanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tsaycuna imay junag imay öra päsananpä cagtaga angelcunapis ni nogapis manam musyayätsu. Tsaytaga quiquin Tayta Diosllam musyaycan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Unay Noe cawanan witsan mana yarpashgata Tayta Dios diluviuta cachamungannömi nogapis mana yarpashgata cutimushä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tsay witsanga diluviu manarä captin runacuna micur, upyar, casaracurmi cacuyargan. Tsaynö cawacuyargan Noe büquitanö arcata ruraycur tsayman yaycungan junagyagmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tsaynö caycagman Tayta Dios illagpita pasaypa tamyata gallatsipaycamuptinmi cay patsaman yacu juntargan. Tsaynöpam arcaman llapan mana yaycog cag runacuna ushacäyargan. Nogapis tsaynöllam runacuna mana musyayangan öra illagpita cutimushä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Cutimungä junag ishcag runacuna chacrachö aruycagpita nogaman criyicamog cagtam gloriaman pushacushä y mana criyicamog cagtanam jagirishä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maraynincunachö ishcag agacuycag warmicunapita nogaman criyicamog cagtam pushacushä y mana criyicamog cagtaga jagirishämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Manam musyayanquitsu imay öra cutimunäpä cagtapis. Tsaynö caycaptinga imaypis Tayta Dios munangannö cawarmi shuyacaycäyämänayqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Juc runa wayinta ladron suwapänanpä cagta musyarga mana punuypa maya-mayallanam waranman. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tsaynömi gamcunapis Tayta Diosman mañacur caycäyänayqui. Mana yarpashgata cutimur jutsallachö caycagtatä tariycüman”. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Juc patron maypapis illarga mas yäracuypä cag empliyäduntam haciendanchö dejan imaycancunatapis shumag ricaycänanpä y waquin empliyäduncunatapis öranchö garar caycänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tsay patron illanganpita cutir yätsingannö llapantapis ruraycagta tariycur imanörä cushicur alabanman tsay empliyädunta. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Empliyädun tsaynö alli portacuptinnam paypa maquinmanna churanman llapan imaycantapis ricananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Peru mana yäracuypä cag empliyädum itsanga yarpan: ‘Patronnï manarämi rasllaga cutiramungarätsu’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tsaynö yarparnam empliyädu mayincunatapis magar ushan y fiestacunachö puricur, micur upyar cacun. ");
INSERT INTO qxoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tsaynö caycagman patronnin mana yarpashgata illanganpita chaycurga, ");
INSERT INTO qxoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","empliyädun mana allicunata ruraycagta tariycur patronnin magacacharcurmi gargunga. Tsaynömi janan shongulla criyicogcunatapis Tayta Dios infiernuman gargunga. Tsaychömi wagar quirutapis uchuyangarä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ciëlupita cutimur imanö cananpä cagta tantiyatsirmi Jesus caynöpis nirgan: “Chunca jipashcunam chiuchincuna listacurir aywayänä casacushga jövinman chasquicog. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Tsaynö aywagcunaga pitsga cag jipashcuna acëtincuna apayänä ushacäpacur wiñayänanpä. Pitsga cag jipashcunaga acëtincuna manam apayänätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsay casacog jövin mana chaptinnam shuyaraycäyanganta llapancunapis punucäriyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tsaynö punucashga caycäyaptinnam pullan pagasnöna juc runa gayacunä: ‘¡Casacog jövin yaycaycämunnam!’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tsaynö gayacunganta wiyarna llapan jipashcuna listacuyänä payta chasquicuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tsaychönam chiuchincunaman acëtita yapay wiñayänanpä mana apag cagcuna waquin cag jipashcunata mañacur niyänä: ‘Chiuchïcunam upiycanna. Acëtiquicunata raquiparcayämay chiuchïcunaman wiñayänäpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tsaynö niyaptinmi acëtiyog cag jipashcuna niyänä: ‘Gamcunata raquiparga manam aypäpacuyäshätsu quiquïcunaga. Antis aywar rantiscayämuy quiquiquicuna atsquicuyänayquipäga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tsaypitanam acëti ranteg aywayanganyag casacog jövinga chärinä. Tsaynam tsay listu shuyacuycag jipashcunata fiestanman yaycatsinä. Y nircurnam puncuta wichgacascamunä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsaypita acëti ranteg aywag jipashcuna cutiycurnam tariyänä puncu wichgaraycagtana. Tsaynam paycuna gayacuyänä: ‘¡Puncuta quichapaycayällämay, taytay!’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tsaynö gayacuyaptinnam casacog jövinga ruripita contestamunä: ‘Gamcunata manam regïtsu. ¿Pirä cacuyanquipis?’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tsaycunata parlapasquirnam Jesus nirgan: “¡Gamcunapis tsay pitsga jipashcunanö listacushga caycäyanqui! Nogaga mana yarpashgatam cutimushä. Manam musyayanquitsu imay junag ni imay öra cutimunäpä cagtaga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tsaypita caynöpis Jesus nirganmi: “Juc rïcu runam juclä nacionpa aywacur empliyäduncunata gellënincuna jagipänä cutimunganyag tsay gellëwan aruycäyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jucnintam jagipänä pitsga waranga (5,000) gellëta. Jucagtana jagipänä ishcay waranga (2,000) gellëta. Jucnin cagtana jagipänä juc waranga (1,000) gellëta, paycuna imanöpis cayanganta tantiyapaycur. Nircurnam caru marcapa aywacunä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tsay pitsga waranga gellëta chasqueg cag empliyädunga shumag negociuta rurar pitsga waranga masta miratsinä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ishcay warangata chasqueg cagpis tsaynöllam negociuwan shumag arur ishcay waranga masta miratsinä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Juc waranga gellëta chasqueg cagmi itsanga ratashwan gepiycur pampaycunä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tsaypita unay ricogta patronnincuna cutirnam empliyäduncunata cuentata mañanä jagipangan gellëwan imanö aruycäyanganta musyananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsaynö cuentata mañaptinnam pitsga waranga gellëta chasqueg cag empliyädun pitsga waranga masta entregar ninä: ‘Taytay, pitsga warangata gollämangayquita pitsga waranga mastam gellëniquita miratsillargö’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tsaynö niptinnam patronnin ninä: ‘Gamga alli empliyädum canqui. Wallcallawanpis shumag arur miratsingayquipitam cananga mas imaycäwanpis munayyogna canayquipä churashayqui. Tsaynö cangayquipita canan fiestata rurashun’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tsaypitanam chänä ishcay waranga gellëta chasqueg cag empliyädunpis caynö nir: ‘Taytay, ishcay warangata gollämangayquita ishcay waranga mastam gellëniquita miratsillargö’. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsaynö niptinnam patronnin ninä: ‘Gampis alli arog empliyädum canqui. Wallcallata jagipaycungäwan shumag arungayquipitam cananga imaycäwanpis munayyog canayquipä churashayqui. Tsaynö cangayquipita canan fiestata rurashun’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tsaypitanam juc waranga gellëta chasqueg empliyädunpis chaycur ninä: ‘Taytay, noga musyämi gam imaycapäpis mallagashga cangayquita. Mana murucungayquipitam gorinquipis. Tsaynömi mana murungayquiman cosichagpis aywanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsaynö feyu cangayquita musyarmi mantsapacur gellëniquita patsaman pampaycurgä. Tsaymi gayatsimaptiqui gellëniquita mana faltagta apallämurgö’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Tsaynö niptinnam patronnin ninä: ‘¡Gamga mana yäracuy gela empliyädum canqui! Malafë cangäta yarpaycarga ¿imanirtä gellënïta bancullamanpis churargayquitsu cutimur wachayyogtana goricunäpä?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsaynö nisquirnam tsaychö caycag runacunata ninä: ‘Tagay gela empliyädupita gellënïta gechusquir goycuyay chunca waranga (10,000) gellë tsararag cagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Noga ningäta cumpleg cagcunataga imaycäwanpis munayyog cananpämi churashä. Peru mana cumplegcunatam itsanga imaycantapis gechusquir gargurishä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cay imapäpis mana väleg empliyäduta tsacayman jitayay. Tsaychö wagar quiruntapis uchurrämi yarpayta taringa’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Noga Tayta Diospita shamog, cutimushä llapan angelcunawan chipipirrämi. Nircurmi jamacushä llapan runacunata juzganäpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tsay junagga maytsay nacioncunapitam llapan runacunata angelnïcunawan goritsimushä. Tsaychömi raquishä mitsicog runa üshancunata cabracunapita raquegnö. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nogaman criyicamog cagtam derëchä cag läduman raquishä. Y mana criyicamog cagtaga itsognï cag lädumanmi raquishä. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsaynö raquiscärirnam noga derëchächö caycagcunata caynö nishä: ‘Gamcunataga Tayta Dios pasaypam cuyayäshunqui. Cay patsata manarä camarmi imaycacunatapis gamcunapä Tayta Dios patsätsipacurganna. Patsätsipacungan gloriamanmi noga pushayäshayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gamcunam mallagar puriptï pachä garaycayämargayqui. Tsaynömi yacunar puriptïpis yacü garaycayämargayqui. Tsaynöllam wayiquicunaman chämur gorpaytucuptï patsaycatsiyämargayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Röpaynag puriptï gamcunam jatircatsiyämargayqui. Geshyaptïpis gamcunam gawaycayämargayqui. Carcelchö captï gamcunam watucaycayämargayqui’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tsaynö niptïnam allita rurar cawashga cag runacuna tapuyämanga: ‘Taytay, ¿imaytä mallagar puriycagta garayargä? ¿Imaytä yacunar puriycagta upurinayquipä yacuta garayargä? ");
INSERT INTO qxoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Imaytä wayïcunaman chämurgayqui patsaycatsiyänäpä? Y röpaynag puriptiqui ¿imaytä jatircatsiyargä?’ ");
INSERT INTO qxoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tsaynömi niyämanga: ‘Geshyaptiqui o carcelchö captiqui ¿imaytä watucagniqui shayämurgä?’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tsaynö niyaptinnam noga caynö nishä: ‘Imayca ñacacuyninchö runa mayiquicunata yanapag cagcunam nogata yanapaycämag cuenta cayarguyqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nircurnam itsognï cag läduchö caycag runacunata nishä: ‘¡Gamcunaga nogalläpa ñöpäpita witicuyay! ¡Satanas y supaycuna gaycucäyänanpä caycag infiernumanmi gamcunaga gaycucäyanqui! ");
INSERT INTO qxoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mallagar puriptïpis gamcunaga manam garaycayämargayquitsu. Y yacunar puriptïpis manam upurcunäpä yacü garaycayämargayquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tsaynömi wayiquicunaman gorpaytucur chämuptï gamcuna mana patsaycatsiyämargayquitsu. Röpaynag captïpis manam jatircatsiyämargayquitsu. Geshyaptïpis carcelchö wichgaraptïpis manam watucaycayämargayquitsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tsaynö niptïnam itsognïchö caycag runacuna niyämanga: ‘Peru taytay, ¿imaytä gamta ricayargö mallagagta, yacunagta, wayïcunaman chämogta, röpaynag puregta, geshyaycagta, carcelchö wichgaraycagta nogacuna yanapayänäpä?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tsaynö niyämaptinmi paycunata nishä: ‘Ñacaychö cagcunata mana cuyapashga car nogatapis manam cuyapäyämargayquitsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tsaynö willapäcurirnam Jesus nirgan: “Tsay mana cuyapäcog cagcunaga infiernuman gaycucarmi tsaychö imayyagpis ñacayanga. Tayta Dios munangannö runa mayinta yanapag cagcunam itsanga imayyagpis gloriachö cawayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tsaynö yachatsicurirnam discïpuluncunata Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Musyayangayquinöpis Pascua fiesta gallaycunanpä ishcay junagllanam faltaycan. Tsaychömi noga Tayta Diospita shamogta chiquimagnïcunapa maquincunaman entregayämanga crucificayämänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tsaypitanam mandag sacerdöticuna y Israel runacunapa autoridänincuna goricäyargan mas mandacog cag sacerdöti Caifaspa wayinman. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tsaychömi willanacuyargan runacunata mana mayatsiyllapa Jesusta tsarisquir wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tsay willanacurmi niyargan: “Amarä cay fiestachöga imatapis rurashuntsu. Fiestachö tsarishgaga runacunam contrantsic sharcuyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tsaypita Betania marcamanmi Jesus aywargan “Leprösu” niyangan Simonta wayinman watucagnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tsaychö jamapaycaptinnam juc warmi chargan rumipita rurashga lindu frascuchö perjümin aptashga. Tsay perjümega feyupa chaniyogmi cargan. Tsaynam mësachö Jesus caycagman warmi witiycur Jesuspa umanman tsay perjümita wiñapargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tsaynö wiñapagta ricarnam discïpuluncuna ajarnin niyargan: “¿Imapätä tsaynö lluta jichar perditsin tsay perjümita? ");
INSERT INTO qxoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tsaynö perditsinanpa rantinga nogantsicta goycamashwan cargan tsayläya chaniyogtaga ranticusquir tsay gellëwan muchogcunata yanapanantsicpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tsaynö niyangancunata wiyarnam Jesus nirgan: “¿Imanirtä gamcuna parlacachäyanqui? Nogapäga allitachä ruraycan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Muchogcunata yanaparninga imaypis caycäyanquirämi. Peru nogawanga mananam gamcuna juntaräyanquinatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cay warmega perjümita wiñapaycäman pampacänäpä alistamarninnam. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cay rurangantaga maytsaychöpis alli willacuynïta willacuyanganchöga willacuyangam”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tsaypitanam Jesuspa discïpulun Judas Iscariote aywargan mandacog sacerdöticunaman parlag. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tsaynö parlarmi nirgan: “Runacuna tsunyäriyangan öra Jesusta prësu tsariyänayquipä willaptï ¿aycatatä pägayämanqui?” nir. Tsaynö niptinnam paycuna niyargan: “Nogacuna pägayäshayqui quimsa chunca (30) yurag gellëtam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsaynö conträtuta rurasquirnam Judas yarpachacurgan sacerdöticunaman imay öra willacog cutinanpäpis. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tsaypita levadüraynag tantata micuyänan Pascua fiesta semäna gallaycunan junagnam discïpuluncuna Jesusta tapuyargan: “Taytay, ¿maychötä listacayämushä Pascua merendata micunantsicpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tsaynö niyaptinmi Jesus nirgan: “Marcapa aywar juc runata niyanqui: ‘Señor Jesusmi cachayäman. Wanutsiyänanpä öran captinnash discïpuluncunawan Pascua merendata wayiquichö micuyta munaycan’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tsaynö Jesus niptin discïpuluncunaga yätsingannöllam Pascua merendata tsay wayichö listapacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tsaypita patsa tsacanaycaptinnam chunca ishcay (12) discïpuluncunawan Jesus mësaman jamacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tsaynam micuycäyangantana Jesus nirgan: “Gamcunapita jucniquim chiquimagnïcunapa maquinman entregayämanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tsaynö niptinnam wamayarnin jucninpis jucninpis Jesusta tapuyargan: “¿Nogatsurä tsayta ruraycüman, taytay?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsaynam Jesus nirgan: “Nogawan juc matillachö tantata tullpurcur micuycagmi chiquimagnïcunapa maquinman entregamanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Noga Tayta Diospita shamogtaga Diospa palabran gellgaranganchö ningannöllam ñacatsir wanutsiyämanga. Peru allau tsay ranticamag runa imanö cuyapaypärä canga. Payga mejor ama yurinmanpistsu cargan”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsaynö niptinnam ranticog Judas Jesusta tapurgan: “¿Taytay, nogacu callä?” nir. Jesusnam nirgan: “Quiquiquim tsayta nirguyqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsaynö micuycäyaptinnam Jesus tantata aptarcur Tayta Diosman mañacur agradesicurgan. Nircurnam paquirir discïpuluncunata macyargan: “Cay tantata llapayqui micuyay. Cayga cuerpümi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsaynömi vïnuyog väsuta aptarcurpis Tayta Diosman mañacur agradesicurgan. Nircurnam discïpuluncunata macyargan: “Cay vïnuta llapayqui uputsinacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay vïnoga yawarnïmi. Noga yawarnïta jichar wanuptïmi Tayta Dios runacunawan mushog conträtuta ruranga nogaman criyicamog cagcunata jutsancunapita perdonananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yapayga manam vïnuta upushänatsu Tayta Diospa ñöpanchö gamcunawan mushog vïnuta upungäyag”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tsaynö nisquir alabanzacunata cantasquirnam discïpuluncunawan Jesus aywacuyargan Olivos jircanman. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olivos jircanman chaycurnam Jesus nirgan: “Tayta Diospa palabranchö caynömi nican: ‘Üsha mitsicogta wanuscatsiptï üshancuna wacpa caypa mashtacarmi aywacuyanga’ nir. Tsay ningannöllam canan pagas llapayqui jagiriycamar aywacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tsaynö captinpis wanuscatsiyämaptin cawarcamurga gamcunapita mas puntatam Galileaman aywashä tsaychö tincunantsicpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tsaynö niptinnam Pedro nirgan: “Waquin cagcuna jagiriyäshuptiquipis nogaga manam dejashayquitsu, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tsaynam Jesus nirgan: “Pedro, canan pagas gällu manarä cantaptinmi gam quimsa cuti ñëgamanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tsaynö niptinnam Pedro nirgan: “¡Ishcantsicta wanutsimänantsic captinpis manam ñëgashayquitsu, taytay!” nir. Pedro ningannöllam waquin cag discïpuluncunapis niyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsaypitanam Jesus aywargan discïpuluncunawan Getsemani huertaman. Tsaychönam discïpuluncunata nirgan: “Tayta Diosman mañacamungäyag gamcuna cayllachö jamaraycäyay”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nisquirnam Pedruta y Zebedeupa tsurincuna Santiagutawan Juanta mas washaläman pushargan. Tsaychö feyupa llaquicurnam paycunata nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Wanunayparä llaquicuymi entëru tullüta almäta päsashga. Cayllachö shuyaycäyämay Tayta Diosman mañacurnin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsaynö nisquirmi mas washaläman aywargan Tayta Diosman mañacog. Tsaychönam pasaypa llaquicurnin gonguricuycur patsaman umpucurcur mañacurgan: “Papällay, cay ñacanäpäna cagpita munarninga jipiycallämay. Peru itsanga ama noga munangänöga catsuntsu, sinöga gam munangayquinö callätsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsaynö mañacunganpita cutirnam tarirgan quimsan discïpuluncuna punucashga caycäyagta. Tsaynam Pedruta nirgan: “Pedro, ¿gamcunaga manacu juc örallapis Tayta Diosman mañacuyta puëdiycuyarguyqui? ");
INSERT INTO qxoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ricchacur Tayta Diosman mañacuyay. Mana dejamayta munaycarpis Tayta Diosman mana mañacurga jagiriycayämanquim”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tsaynö nisquir cutirirnam yapay Tayta Diosman mañacurgan: “Papällay, runacuna ñacatsimar wanutsiyämänan captinpis gam munangayquinö callätsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsaynö Tayta Diosman mañacunganpita cutirpis tarirgan quimsan discïpuluncuna cangan wanuypa punucashga caycäyagtam. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsaynö caycagta ricaycurpis yapay cutiycur Tayta Diosman mañacurgan puntata mañacungannöllam. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsaypita cutiycamurnam paycunata nirgan: “¿Cananpis gamcunaga jinallacu punucuycäyanqui? ¡Ricchayay! Cananga noga Tayta Diospita shamogta jutsasapa runacunapa maquincunaman entregayämänanpä öra chämushganam. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Sharcuyayna! Chiquimagnïcunapa maquinman entregamag runaga yaycaycämunnam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tsaynö discïpuluncunawan Jesus parlaycaptinllarämi Judas Iscariote chargan atsca runacunata pushashga. Tsay runacunaga chäyargan espädancunawan y garrötincunawanmi. Paycunataga cachayargan mandacog sacerdöticuna y respitädu mayor runacunam Jesusta prësu tsariyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasga caynö nirmi runacunata yätsirgan: “Mayganpis mutsangä cagmi Jesusga canga prësuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsay ningannömi Jesusman witiycur Judasga mutsaycurgan: “¿Allillacu, tayta?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tsaynö niptinnam Jesus nirgan: “Au Judas, ¿cayyagräcu shamuycurguyqui?” Tsaynö niptin runacunaga Jesusta jinan öram prësu tsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tsaynö prësu tsariyaptinnam juc discïpulun mas mandacog cag sacerdötipa wätayninpa rinrinta espädanwan roguscapurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsayta ricaycurnam Jesus nirgan: “Espädayquita churay. Pipis espädawan runa mayinta wanutseg cagtaga espädawanmi quiquintapis wanutsiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Gam manacu musyanqui Tayta Diosman mañacuriptï chunca ishcay (12) tröpa angelcunata cayman cachaycamuptin janä sharcuyänanpä cagta? ");
INSERT INTO qxoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tsaynö angelcunata nogapa janä cachaycamuptinga ¿imanöparä cumplinga runacuna wanutsimänanpä Diospa palabranchö gellgaraycanganpis?” ");
INSERT INTO qxoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tsaynö nisquirnam tsay runacunata Jesus nirgan: “¿Imanirtä ladron captïnö gamcuna shayämurguyqui espädayquicunawan y garrötiquiwan nogaman prësuyämag? Nogaga goyay goyaypis templuchömi yachatsicurgö. Tsaychö caycaptëga ¿imanirtä prësu tsariyämargayquitsu? ");
INSERT INTO qxoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tayta Diospa willacognin profëtacuna gellgayangannöllam cay ruraycäyangayqui llapanpis camacaycan”. Tsaynö nicaptinnam Jesusta japallanta jagisquir discïpuluncuna geshpir aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tsaynö Jesusta prësu apacuyargan mas mandacognin cag sacerdöti Caifaspa wayinmanmi. Tsaychömi ley yachatsicogcuna y mas waquin puëdeg autoridäcuna goricashga caycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesusta apacuyaptin Pedroga caru gepallantam aywargan Caifaspa wayinman yaycatsiyanganyag. Tsayman yaycaratsiyaptin Pedrupis gepantam yaycurirgan. Wayipa patiunchömi templu cuïdag runacunawan juntu jamaraycargan ima päsangancunatapis ricararnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mandacog sacerdöticunawan puëdeg autoridäcunaga Jesusta imaycanöpapis wanutsiyänantam munayargan. Tsaymi runacunata ashiyargan Jesuspita manacagcunata niyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Paycuna manacagcunata niyaptinpis Jesuspa contran sharcogcunaga manam ima jutsantapis tariyargantsu wanutsiyänanpänöga. Tsaypitanam ishcay runacuna niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Cay runaga caynöchä nirgan: ‘Templuta juchuratsirmi noga quimsa junagllata sharcatsishä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsaynam sacerdöticunapa mandagnin cag Jesusta tapurgan: “¿Manacu imatapis parlacunqui tsaynö niyäshuptiqui? ¿Imanirtä tsaynö contrayqui nicäyäshunqui?” ");
INSERT INTO qxoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tsaynö niptinpis manam ni imata Jesus parlacurgantsu. Tsaynam sacerdöticunapa mandacognin yapay nirgan: “Poderösu Tayta Dios ricananchömi gamta tapü. Rasun cagllata nimay. ¿Rasunpacu Tayta Diospa tsurin salvacog canqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tsaynam Jesus nirgan: “Aumi, ningayquinö rasunpaypam cä. Nogata juc junag ricayämanqui imaycawan munayyog Tayta Diospa derëcha cag lädunchö jamaraycagtam. Y tsaypitanam pucutay jananchö shamuycagta ricayämanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsaynö niptinnam mandacog sacerdöti rabyanaywan röpantapis rachirrä nirgan: “Cay runa tsaynö nicaptinga ¿imapänatä mas testïgucunatapis munantsic? Gamcuna wiyayarguyquim quiquin Dios tucurna parlaycanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Tsaynö captinga gamcuna ¿imaniyanquitä?” nir. Tsaynam tsaychö caycag runacuna niyargan: “¡Tayta Diospa contranmi parlashga! ¡Tsaynö canganpita cay runaga wanutsun!” ");
INSERT INTO qxoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsaynö nirmi cäranman togapäyargan y magayargan. Waquinnam lagyar ushayargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Tayta Dios cachamungan salvacog carga mä, niyämay ‘¿Pitä lagyashurguyqui?’ ” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsayyag Pedroga jamaraycargan wayi puncu cagllachömi. Tsaychö jamaraycagta ricarnam juc empliyäda jipash witiycur nirgan: “Gamtapis Jesuswan puriycagtam ricargä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsaynam runacuna wiyaycaptin Pedro nirgan: “Manam musyätsu imata parlapaycämangayquitapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsaynö nisquirmi Pedroga puncu cagman witicuycurgan. Tsaychönam juc jipashpis payta ricaycur nirgan: “Nogapis cay runataga Jesuswan puriycagtam ricargä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tsaynö niptinnam Pedro jurar nirgan: “¡Nogaga manam regïtsu tagay runataga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tsaypita mas rätun ricogtanam tsaychö caycag runacuna Pedruman witipar niyargan: “¡Gamga rasunpaypa tagay runawan puregmi canqui! Paypanömi parlacuyniquipis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsaynam Pedro jurar nirgan: “¡Tagay runaga pirä cacunpis! ¡Manam regicullätsu!” Tsaynö nicaptinmi gällu cantasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gällu cantasquiptinmi itsanga Pedro yarpasquirgan Jesus caynö ninganta: “Manarä gällu cantaptinmi quimsa cuti ñëgamanqui”. Tsayta ninganta yarpasquir Pedro wagtaman yargusquirmi pasaypa llaquicur wagargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsaypita patsa waräriptinnam mandacog sacerdöticuna y Israel runacunapa puëdeg autoridänincuna willanacuyargan Jesusta wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsaynö cösa willanacurirnam maquipita watarcur Jesusta apatsiyargan Roma nacionpita mandacog Pilatuman. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusta wanutsiyänanpä autoridäcuna willanacuyanganta musyasquirnam Judas Iscariote pasaypa llaquicurgan. Ranticunganta pësacurmi quimsa chunca (30) yurag gellëta chasquinganta cutitsipaycurgan sacerdöticunaman. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tsaynö cutitsirnam paycunata nirgan: “Jutsamanmi jegarpurgö jutsaynag runata gamcunata entregarnin”. Tsaynö niptinnam niyargan: “¡Imanöpis cacuy! ¡Nogacunataga manam imapis gocayämantsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tsaynö niyaptinmi Judasga tsay gellëta templuman jichariycur aywacurgan. Nircurnam jinan öra jurcacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsaynam mandacog sacerdöticuna tsay gellëta gorircur niyargan: “Cay gellëga runapa yawarninpa chaninmi. Tsaynö captin manam ofrenda gellëmanga tallushwantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsaynam willanacur tsay gellëwan rantiyargan manca rurag runapa chacranta. Tsay chacrata rantiyargan juclä nacion runacuna wanur tsaychö pampacuyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jesuspa yawarninpa chanin captinmi tsay chacrapa jutinta runacuna niyan “Yawar Pampa” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mandacog sacerdöticuna chacrata tsaynö rantiyanganwanmi cumplirgan Tayta Diospa unay willacognin profëta Jeremias gellgangan. Tsay gellganganga caynömi nican: “Paypa preciun ayca cananpäpis Israel runacuna niyangannöllam quimsa chunca (30) gellëta chasquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tsay gellëwanmi Tayta Dios ningannölla manca rurag runapa chacranta rantiyargan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tsaypita mandacog Pilatuman Jesusta prësu chaycatsiyaptinnam tapurgan: “¿Rasunpacu gamga canqui Israel runacunapa mandacog reynin?” Tsaynö niptinnam Jesus nirgan: “Gam ningayquinöllam cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tsaychö mandacog sacerdöticuna y puëdeg autoridäcuna imaycata llullacurcur niyaptinpis Jesusga manam imatapis parlacurgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tsaynam Pilato nirgan: “¿Manacu imatapis ninqui gampa contrayqui imaycata niyäshuptiquipis?” ");
INSERT INTO qxoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tsaynö niptinpis Jesusga manam imatapis parlacurgantsu. Tsaymi Pilatoga ima niytapis puëdirgannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wata watam Pascua fiestachöga Pilato cachaycog juc prësuta runacuna mañayangan cagta. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsaychömi prësu wichgaraycargan juc runa Barrabas jutiyog. Paypa mana alli rurag cayninga pipita maypitapis regishgam cargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Jesusta chiquipar payman prësu apayanganta musyarnam tsaychö goricashga caycag runacunata Pilato tapurgan: “¿Maygan prësutatä cachaycunäta munayanqui? ¿Barrabastacu o reyniquicuna Jesustacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tsaypita Jesusta juzgar Pilato jamaraycaptinmi warmin willacascatsirgan caynö nir: “Jesus niyangan runaga jutsaynagmi. Ama paypa contran mëticuytsu. Canan pagas pasaypa mana allicunatam suëñupäcuycurgö tsay runata prësurätsiyaptin”. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tsaynö warmin willacatsishga captin Pilato Jesusta cachariyta munaptinpis tsaychö caycag mandacog sacerdöticuna y llapan autoridäcunam runacunata aquishapäyargan: “Barrabasta cachariy. Jesusga wanutsun” niyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsaynö niyaptinmi yapay Pilato tapurgan: “¿Maygantatä cacharishä?” nir. Niptinnam runacuna gayararrä niyargan: “¡Barrabasta cachariycuyga!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsaynö niyaptin Pilatunam nirgan: “Tsaynö captinga cay apayämungayqui reyniquicuna nisha Jesustaga ¿imatatä rurashä?” nir. Tsaynam llapan runacuna niyargan: “¡Payga cruzchö wanutsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tsaynam Pilato nirgan: “Cruzchö wanunanpäga ¿ima mana allitatä rurashga?” Tsaynö niptin runacuna masrämi gayarar niyargan: “¡Ari, cruzchö wanutsun!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Runacuna tsaynö masrä gayaraypa niyaptinnam ima ruraytapis manana puëdirgantsu. Tsaynö caycangantanam yacuta apascatsimur llapancunapa ñöpanchö maquinta awicur nirgan: “Nogaga manam cuentayognatsu callä. ¡Cay runata gamcunana wanutsirpis mana wanutsirpis cacuyay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsaynö niptinnam runacuna niyargan: “Nogacunam y wamräcunam cay runa wanunganpita cuentayog cayäshä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Runacuna tsaynö niyaptinnam Pilato Barrabasta cachaycurgan. Nircurnam Jesusta astarcatsir Roma soldäducunaman entregaycurgan crucificayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsaypitanam soldäducuna Jesusta apayargan cuartelnincunaman. Tsayman llapan soldäducuna goricaycurmi maytsayninpa jiruruparäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nircurmi asipäyänan raycur röpanta llogtiscatsir reypa puca mantuntanö agshutsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tsaynömi cashapita corönatapis umanman churapäyargan. Derëcha cag maquinmanpis väratam aptapäyargan. Nircurmi ñöpanman gonguricog tucur asipar niyargan: “¡Alabashga catsun Israel runacunapa reynin!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tsaynömi togaparpis ushayargan. Aptaraycangan värata gechurirmi jucrä jucrä uman umallan wiruyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsaynö imaycata rurar ajayasquirnam agshutsiyangan puca mantuta llogtiratsir cangan quiquinpa röpantana jatitsiyargan. Nircurmi crucificayänanpä apayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tsaynö Jesusta cruzchö clavag apaycarnam tincuyargan Cirene marcapita Simon jutiyog juc runawan. Paytam Jesus apaycangan cruzta umrutsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nircurnam Jesusta chätsiyargan Golgotaman. Golgota ninanga cargan “calavëra sitiu” ninanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tsaychönam vïnutawan juc usuncätsicog jampita Jesus upunanta munayargan nanayta mana mayananpä. Tsaynam yawarcurga mana upuyta munargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tsaypita Jesusta crucificasquirnam soldäducuna Jesuspa röpanta sortiyayargan mayganpis gänag cag apacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nircurnam soldäducuna tsaychö täpar quëdayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tsaypita juc letrërutanam tablachö gellgarcur cruzpa puntanman clavayargan. Tsay letrëruchöga caynömi gellgayargan: “CAY JESUSGA ISRAEL RUNACUNAPA REYNINMI” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesusta crucificayangan lädunmannam ishcay ladroncunata crucificayargan, jucagta derëcha cag lädunman y jucagtana itsog cag lädunman. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cruzchö Jesus caycagta ricarnin tsaypa päsag runacunapis asiparmi umancunata awirninrä niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“‘Templuta juchuscatsirmi quimsa junagllata sharcaratsishä’ nicarga mä salvacuy ari. Tayta Dios cachamungan salvacog rasunpa carga ¿imanirtä cruzpita yarparamunquitsu?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tsaynömi mandacog sacerdöticuna, ley yachatsicogcuna, y puëdeg autoridäcunapis Jesusta asiparnin niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Juccunataga salvarganchä. Canan ¿imanirtä quiquinga salvacuyta puëdintsu? Israel runacunapa reynin caycarga, mä cruzpita yarparamutsun nogantsicpis paymanna criyicunantsicpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‘Tayta Diospa tsurinmi cä’ y ‘Paymanmi yäracü’ nimargantsicchä. Rasunpa tsurin captinga, mä Tayta Dios cuyapar salvatsun ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tsaynöllam ñöpanchö crucificaraycag ladroncunapis burlacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tsay junagga pullan junagpitam patsapis tsacasquirgan tardi mallwayyag. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tardi mallwaychö rupay caycaptinmi Jesus llapan callpanwan nirgan: “Eli, Eli, ¿lema sabactani?” nir. (Tsay ninanga “Tayta Diosllä, Tayta Diosllä, ¿imanirtä dejariycamarguyqui?” ninanmi.) ");
INSERT INTO qxoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tsaynö niptin tsaychö caycag waquin runacunaga caynömi niyargan: “Diospa willacognin profëta Eliasmanmi gayacuycan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tsaynam juc runa hisöputa gerupa puntanman watarcur upucuyänan ayag vïnuman tullpurgan Jesusta shogutsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tsaynö ruraptinnam waquin runacuna niyargan: “Ama tsayta ruraytsu. Mä, ricashun Elias shamungacush cruzpita jipeg” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tsaypitaga Jesus yapay fuertipa gayarasquirmi wanusquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesus wanusquingan öram templuchö alli awashga jatun cortïnapis janapita urayninpa rachisquirgan. Tsaymi pasaypa patsa tsuctsucyaptin gagacunapis paquicar ushargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Tsaypita Jesus cawascamuptinnam Tayta Dios munangannö alli rurag runacunapis pamparanganpita atscag cawariyämurgan. Nircur Jerusalen marcaman yaycuyaptinmi atsca runacuna paycunata ricayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesusta täpaycag capitanpis soldäduncunapis patsa pasaypa cuyuptin y imaycapis päsangancunata ricarnin pasaypam mantsacäyargan. Tsaymi niyargan: “¡Cay runaga rasunpam Tayta Diospa tsurin cashga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tsaychömi atsca warmicunapis carulällapita ricaräyargan. Tsay warmicunaga yanaparnin Galileapita gatiragcunam cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paycunawanmi caycargan Maria Magdalena, Santiagupa y Josepa maman Maria, y Zebedeupa warmin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tsaypita patsa tsacanaycaptinnam Pilatuman chargan Arimatea marcapita Jose. Payga rïcu runam cargan. Y Jesucristuman criyicog runam carganpis. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tsaynam Pilatuta mañargan Jesuspa ayanta cruzpita jipirir pampaycunanpä. Tsaynö mañaptinnam Pilato soldäduncunata nirgan Jesuspa ayanta cachapaycuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tsaynö cachapariyaptinnam lïnupita fïnu säbanaswan piturgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nircurnam gagachö tsayrä uchcutsishga sepultüraman Jesusta pampargan. Tsay sepultürataga quiquin pampacunanpämi Jose uchcutsinä. Tsaypitanam jatuncaray rumiwan sepultürapa puncunta tsapaycur aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pay aywacuptinpis Maria Magdalena mas jucag Mariaga Jesuspa sepultüran ñöpanchömi jina jamaraycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Jesus wanunganpita warayninga cargan säbadu jamapay junagmi. Tsaynam sacerdöticunapa mandagnincuna y fariseucuna Pilatuman aywar niyargan: “Taytay, tsay llullacog runa ningantam yarpasquiyargö. Paymi nirgan: ‘Wanungäpita quimsa junagllatam cawarimushä’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsaymi gamta niyällä soldäduyquicunawan sepultürata quimsa junag päsanganyag täpaycatsillänayquipä. Mana täpatsiptiquega tsacaypa discïpuluncuna aywaycurmi Jesuspa ayanta suwasquiyanga. Nircurmi runacunata criyitsiyanga: ‘Wanunganpitam Jesus cawariscamushga’ nirnin. Tsaynö nir llullacuyaptinga puntacunapitapis masrämi runawan mana allichö cashun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsaynö niyaptinnam Pilato nirgan: “Soldäducunata aywar churayämuy täpayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tsaynö niptinmi aywar sepultüra tsaparag rumipa juc cuchunta cërawan lagayargan pipis quichaptin imaptinga musyacänanpä. Nircurnam soldäducunata täpayänanpä dejaycur cutiriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Säbadu jamapay junag jamapärirnam dominguman warämogga tsaca tsacallana Maria Magdalenawan jucag Maria aywayargan Jesuspa ayanman perjümita wiñapäyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsaynö aywaycäyaptinnam Tayta Dios cachamungan angel ciëlupita urämuptin feyupa patsa cuyur gallaycurgan. Angel sepultüraman chaycur tsaparag rumita witiscatsirmi jananman jamaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tsay angelga tillagucuynörämi atsicyargan. Röpanpis rashtanö yullagrämi cargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tsayta ricaycur Jesuspa ayan täpag soldäducunaga pasaypa mantsariywan wanushganömi jitacascäriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Warmicuna chaycuyaptinnam angel nirgan: “Ama mantsacäyaytsu. Musyämi crucificaypa wanutsiyangan Jesusta ricag shayämungayquita. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mananam caychönatsu caycan. Manarä wanur niyäshungayquinöllam cawamushgana. Mayman churayangantapis masqui ricaycuyay. Mananam cannatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tsaynö nisquirnam tsay warmicunata nirgan: “Canantä aywar discïpuluncunata willayay Jesus cawarimunganta. Y nircur niyanqui Galileaman aywar tsaychö Jesuswan tincuyänanpä cagta”. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Angel tsaynö nisquiptin warmicunaga mantsacashga caycäyanganta feyupa cushicurnam Jesuspa discïpulucunaman willag empëñu cuticuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsaynö aywacuycäyaptinmi paycunata Jesus yuripasquir saludargan. Tsaynam gonguricuycur chancanta macallacurcur adorayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tsaynam Jesus nirgan: “Ama mantsapäyämaytsu. Cananga discïpulücunata aywar willayay Galileaman juclla aywayänanpä y tsaychö paycunawan tincuyänäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmicuna cuticuriyaptinnam sepultürata täpag soldäducunapis Jerusalenman aywar mandacog sacerdöticunata willayargan llapan ima päsangancunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsaynö willayaptinnam mandacog sacerdöticunaga waquin autoridäcunawan willanacusquir soldäducunata gellëta pägayargan caynö nirnin: ");
INSERT INTO qxoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","14","“Jesuspa ayan illacanganta Pilato musyaptinga nogacunam paywan parlayäshä gamcunata imatapis mana niyäshunayquipä. Gamcunanam runacunata niyanqui: ‘Jesuspa discïpuluncuna tsacaypa shamuycurmi punucasquiyangäyag ayanta suwaypa apacuyashga’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tsaynö gellëta chasquipacurir sacerdöticuna niyangannöllam soldäducunaga runacunata willacurnin gallaycuyargan. Tsay manacagta willacuyanganpitam cananyagpis Israel runacunaga mana criyiyantsu Jesus cawamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tsaypitaga Jesuspa chunca juc (11) discïpuluncuna Galilea provinciaman aywarnam chäyargan Jesus mayninchö tincuyänanpä ningan jircaman. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tsaychö Jesuswan tincurnam adorayargan. Peru waquinga ricaycarpis manam criyiyarganrätsu cawarimunganta. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tsaynam Jesus discïpuluncunata nirgan: “Cay patsachöpis y gloriachöpis imaycawan munayyog canäpämi Tayta Dios churamashga. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsaymi gamcunata cachä maytsay nacionpapis aywar discïpulücuna cayänanpä pitapis maytapis yachatsiyämunayquipä. Nogaman criyicamogcunataga bautizayanqui Tayta Diospa jutinchö, nogapa jutïchö, y Espiritu Santupa jutinchö. ");
INSERT INTO qxoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsaynö ari paycunata yachatsiyanqui llapan ningäcunata cäsucuyänanpä. Manam ni imay gongayäshayquitsu ni jagiriyäshayquitsu cay patsa ushacäriptinpis”. Tsaynö catsun.");
INSERT INTO qxoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Canan musyatsiyäshayqui Tayta Diospa tsurin salvamagnintsic Jesucristo ima cushicuypä alli willacuyta willacunganta y ruranganta. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jesus Tayta Diospa willacuyninta willacur manarä gallaptinmi Juan Bautistaga salvamagnintsic shamunanpä cagta willacuycarganna. Juan willacunanpä cagtaga unay profëta Isaiasmi gellganä Tayta Dios caynö ninganta: “Willacuynïta willacur gallanayquipäga juctarämi musyatsicogta cachashä gamta runacuna shumag chasquicuyäshunayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Payga tsunyagcunachö purirmi caynö gayarar willacunga: ‘Tayta Dios aunicungan salvacog runa chämuptin chasquicuyänayquipä jutsayquicunata dejariyay. Mana alli rurayniquicunapita yarpachacuyay’ ” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Isaias gellgangannölla unay Juan Bautistaga tsunyagcunachö purir runacunata willacurgan caynö nirmi: “Tayta Dios jutsayquicunapita perdonayäshunayquipä mana alli rurayniquicunata dejayay bautizanäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsaynö willacuptinnam Jerusalenpita y tsay entëru Judea provinciapita Juan cagman chäyargan. Tsaynam runacuna jutsa ruraynincunata jagiriyänanpä niyaptin Juan bautizargan Jordan mayuchö. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan jatirangan röpanga cargan camëllupa cerdanpita rurashgam, Tayta Diospa willacognin unay profëtacunapanölla. Wachäcanpis garapitam cargan. Chucllushnö curucunatam y chumpac mishquicunatam micogpis. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pay caynö nirmi willacurgan: “Chämunganam imaycawan munayyog Tayta Dios cachamungan salvamagnintsic. Nogaga manam puëdïmantsu umpuycur paypa maquinta ni chaquinta mutsaycuyllatapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nogaga gamcunata bautizaycä yacullawanmi. Payga bautizayäshunqui Espiritu Santuwanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tsay junagcunam Galilea provinciachö Nazaret marcapita Jesus aywargan Jordan mayuchö Juan runacunata bautizaycagman. Tsaychömi paytapis Juan bautizargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yacupita yarguraycarnam Jesus ricargan ciëlu quichacasquiptin palumanö Espiritu Santo payman uraycämogta. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jesuspa jananman paluma rataycuptinnam Tayta Dios ciëlupita caynö nimungan wiyacämurgan: “Gammi cuyay tsurillä canqui. Noga munangänö llapantapis ruraptiquim alläpa cushicü” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsaypitanam tsunyagpana Jesusta Espiritu Santo pushasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tsaychöga cargan chuscu chunca (40) junagmi, jäcogchö täcog ashmacunawan juntu. Tsayman chaycurmi Satanas Jesusta jutsaman ishquitsiyta munar imaycata parlapargan. Satanas Jesusta tentayta mana puëdircur aywacusquiptinnam angelcuna chaycur Jesusta wallquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan Bautistata rey Herodes carcelman wichgascatsiptinnam Jesusga Galilea provincia quinranna Tayta Diospa alli willacuyninta willacur gallaycurgan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Tayta Diospa willacuyninta musyatsicuy tiempu chämushganam. Salvacog rey gamcunachöna caycaptinga jutsa rurayniquicunata jagirir Tayta Dios munangannöna cawayay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tsaypita juc junagnam Galilea gocha cuchunpa aywaraycarna Jesus ricasquirgan pescädu tsareg ishcay waugicuna mällancunata gochaman jitaycäyagta. Paycunaga cayargan Simonwan Andresmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tsaynam paycunata Jesus caynö nirgan: “Discïpulücuna cayänayquipä nogawan aywacushun. Nogam yachatsiyäshayqui runacunata Tayta Diospa alli willacuyninta willapäcayämunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsaynö niptin paycunaga mällancunatapis jagisquirmi Jesuswan aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsaynö aywaraycarnam mas washaläninchöna Jesus tarisquirgan ishcay runacuna büquincunachö mällancunata allitsaycäyagta. Paycunaga cayargan Zebedeupa ishcan tsurincunam, Santiaguwan Juan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Paycunatapis Jesus discïpuluncuna cayänanpä gayaptin jinan öram sharcur aywacuyargan papänincuna Zebedeuta arupagnincunatawan büquichö jagiriycur. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tsaypitaga paycunawannam Jesus chärirgan Capernaum marcaman. Säbadu jamapay junagchönam Israel runacuna Tayta Diosman mañacur goricäcuyänan wayiman aywargan yachatsicunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tsaychö Jesusga yachatsicurgan manam Moises gellgangan leycunata yachatsicogcuna wiyayangallanta yachatsicogcunanötsu. Payga yachatsicurgan quiquin Tayta Dios parlaycagnömi. Tsaymi runacunaga feyupa cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsay goricäcuyänan wayichömi caycargan supay löcuyätsingan runapis. Tsaychö Jesus caycagta wiyaycurmi supayyog runa caynö gayarargan: ");
INSERT INTO qxoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus Nazaret runa ¿imatatä munanqui nogacunawan? ¿Nogacunaman shamurguyqui ushacätsiyämänayquipäcu? ¡Noga regïmi Diospa tsurin salvacog cangayquita!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsaynö niptinnam Jesus nirgan: “¡Upälla supay, yargucuy cay runapita!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsaynam supay pasaypa runata tsuctsucyätsir gayarar yargucurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tsayta ricaycur llapan runacuna espantashgam ninacuyargan: “Manam imaypis wiyarguntsictsu cay runa yachatsicungantanöga. ¡Payga ima puëdegnarä! ¡Supaycunapis cäsuyänächä!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tsay witsancunallanam Galilea marcacunachö musyasquiyargan Jesuspa yachatsicuyninta y supayta runacunapita gargunganta. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsaypitanam goricäcuyänan wayipita yargusquirna Jesus aywargan Santiaguta y Juanta pusharcur Simonpa, Andrespa wayinman. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tsayman chäyänanpämi Simonpa suegran ujuraycargan pasaypa antsa achacharnin. Tsaytanam runacuna Jesusta willayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tsaynam Jesus geshyag ujuraycanganman yaycurirgan. Nircur maquipita tsarircur sharcarcatsiptinmi jinan öra allisquirgan. Chacwanga tsay cushicuypitam micuynincuna garargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tsaypita patsa tsacanaycaptinnam Jesusman apayämurgan imaycaläya geshyawan geshyagcunata y supayyog runacunata. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tsay marcachö runacunaga pasaypam juntäyargan wayi ñöpan quinranmanpis. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tsaychö Jesusga allïtsirgan imaycaläya geshyapitam payman chagcunataga. Tsaynöllam gargurgan supaycunata runacunapita. Jesusga manam munargantsu supaycuna paypita imata parlarcuyänantapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Warayninnam tsacagllana Jesus shäricusquir aywacurgan juc tsunyagman Tayta Diosman mañacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tsaynam Simon Jesusta watucasquir waquin discïpuluncunawan asheg aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesusta tarisquirnam nirgan: “Runacunam ashiyäshunqui, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsaynö niptin Jesusnam nirgan: “Paycuna ashiyämaptinpis gamcunawanga waquin marcacunapanam aywashun Tayta Diospa willacuyninta yachatsimunäpä. Tsaypämi noga cay patsaman shamurgö” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsaynömi ari Jesusga maytsay Galilea marcacunapa purirgan, goricäcuyänan wayicunachö yachatsicur y runacunapita supaycunata gargurnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Juc cutinam lepra geshyawan geshyacog runa Jesuspa ñöpanman gonguricuycur nirgan: “Cuyapämarnï cay geshyäta alliycatsillämay, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsaynam Jesusga cuyaparnin yataycur caynö nirgan: “Munämi allisquinayquita” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsaynö niptin jinan öram tsay runa limpiu ticrar allisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tsaynam alli yätsiycur nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ama pitapis willacunquitsu noga allïtsingäta. Cananga templuman aywacuy unay Moises gellgangan leychö ningannö ofrendata apacurcur. Tsaychö sacerdöti ricaycushurniquim purificashgana cangayquita musyatsicamunga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsaynö nicaptinpis tsay runaga mana wiyacuypam pitapis maytapis willacur purirgan Jesus allïtsinganta. Tsayta musyaycurnam runacunaga maypitapis tsaypitapis chäyargan Jesus caycangan cagman allïtsinanpä. Tsaynö captin Jesusga may marcaman chaytapis mana puëdirnam aywacurgan tsunyagpana. Maypa aywaptinpis Jesustaga runacuna gatiraycäyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Tsaypita juc ishcay junagcuna päsariptin Jesus yapaymi cutirgan Capernaum marcaman. Tsaychöna caycanganta musyasquirnam tsaymanpis atsca runacuna goricäyargan wayi puncuncunachöpis quichquiypa. Tsaychömi Jesus yachatsicurgan Tayta Diospa alli willacuyninta. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsaynö yachatsicuycaptinmi pullan cuerpun wanucashga runata chuscog runacuna andamiawan wantushga chätsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Runacuna pasaypa quichquicashga cayaptinmi paycunaga Jesus cagman yaycatsiyta mana puëdiyargantsu. Tsaynam wayi jananman yarcurcur, uchcusquir cachäyargan andamiantinta Jesuspa ñöpanman. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesusga musyarganmi tsay runacuna payman yäracuyanganta. Tsaynam tsay geshyaycag runata nirgan: “Hïju, jutsayquicunapita perdonashgam canqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tsaynam tsaychö waquin ley yachatsicogcuna Jesus ninganta wiyar shonguncunachö yarpäyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Cay runaga ¿imanirtä tsaynö parlan Diostapis piñatsir? Tayta Diosllam jutsa ruragcunataga perdonan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsaynö yarpäyanganta musyarnam Jesus paycunata nirgan: “¿Imanirtä gamcuna llutanta yarpäyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Tayta Diosmi nogata cachamashga cay patsachö runacunata jutsancunapita perdonanäpä. Cananmi Tayta Dios rasunpa cachamanganta musyayänayquipä ‘Andamiayquita aparcur aywacuy’ nir allïtsishä ricayänayquicunachö”. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tsaynö nisquirmi Jesus runata nirgan: “Cananga allishganam canqui. Sharcur andamiayquita aparcur wayiquipa aywacuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsaynö niycuptin jinan öram sharcur llapancuna ricaraycäyaptin andamianta apacurcur aywacurgan. Tsayta ricarninnam runacuna espantacur Tayta Diosta alabar niyargan: “¡Tayta Dios yanapaptinmi tsaycunata Jesus ruraycan! ¡Manam ni imaypis pay rurashantanöga ricarguntsictsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsaycuna päsanganpitanam Jesus gocha cuchunman cutiycur caycargan. Tsayman pasaypa runacuna goricäyaptin paycunatapis yachatsirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tsaychö yachatsicurir marcamanna Jesus cutirnam ricasquirgan Alfeupa tsurin Mateo Roma nacionpä impuestuta cobracur jamaraycagta. Tsaynam payta nirgan: “Discïpulü canayquipä nogawan aywacushun”. Niptin Mateoga wap sharcurmi Jesuspa gepanta aywargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsay tardi Mateoga Jesusta discïpuluncunatawanmi wayinman pushargan micuyänanpä. Tsaychö Jesusga micuycargan impuestu cobracogcunawan y jutsa ruragcunawanmi. (Jesustaga imaycanö cawacog runacunam gatiräyag.) ");
INSERT INTO qxoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsaynam tsaychö Jesus micuycagta ricaycur ley yachatsicogcuna y fariseucuna discïpuluncunata tapuyargan: “¿Imanirtä mayistruyquicunaga juntacan impuestu cobracogcunawanpis y jutsasapacunawanpis?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsaynö niyanganta wiyarnam Jesus paycunata nirgan: “Geshyagcunallam jampicogta miñishtiyan. Manam sänu cagcunaga imata munayantsu. Nogaga manam shamurgö alli rurag runacunallata Tayta Diospa willacuyninta tantiyatsinäpätsu, sinöga jutsa ruragcunatapis tantiyatsinäpä shamushga carmi paycunawanpis juntacü” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutinam Juan Bautistapa discïpuluncuna y fariseucuna Tayta Diosman mas mañacur ayünuchö caycäyargan. Tsaynam runacuna Jesusman aywaycur tapuyargan caynö: “Juanpa discïpuluncunaga y fariseucunaga ayunaycäyanmi. Y gampa discïpuluyquicunaga ¿imanirtä mana ayunaycäyantsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tsaynam Jesus nirgan: “¡Casacuy fiestaman invitashgacuna ayunayanmantsurä! Tsay invitashgacunaga casarag noviuwan juntu caycarnin cushishgam micuyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tsaynöllam nogapa discïpulücunapis nogawan juntu cayarga ayunayanmantsu. Peru wanuscatsiyämaptinmi itsanga ayunayanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsaynö nisquirpis caynömi nirgan: “Manam pipis macwa röpanta mushog ratashwanga remendantsu. Mushog ratashwan remendashgaga genticäratsirmi rachiratsinman. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsaynöpis manam pipis wiñantsu tsayrä puwatsishga aswata tsillinaycag uylluman. Tsaynö carga masran tsilliratsinman. Tsaynöpam aswapis ni uyllupis ushacärinman. Tsaymi tsayrä puwatsishga aswataga wiñantsic alli uylluman. Tsaynömi nogapa yachatsicuynïpis mushog carnin mana iwalantsu gamcunapa üsuyquicunamanga. Tsaymi discïpulücunata niyänayquitsu noga cawaycaptïräga ayunayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juc säbadu jamapay junagchönam discïpuluncunawan Jesus aywaraycäyargan trïgu poguraycag cuchunpa. Tsaynö aywaraycäyangantanam discïpuluncunaga trïguta quiptuscärir cuparir micuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsayta ricarnam fariseucuna Jesusta tapuyargan: “¡Canan junagga manachä arucuy junagtsu! Tsaynö caycaptinga ¿imanirtä discïpuluyquicuna trïguta quiptupacur puriycäyan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Tsaynam Jesus nirgan: “¿Gamcunaga manacu liyiycarpis yarpäyanqui rey David mallagar imata ruranganta? Unay sacerdöti Abiatar mandag caycänan witsanmi David soldäduncunawan puriycar millcapancuna manana captin mallagäyänä. Tsaynam Tayta Diosman mañacucuyänan ruriman David yaycusquir sacerdöticunalla micuyänanpä cag churarag tantata micurinä. Nircurmi garanä gatiragnincunatapis. David mana micunanpä cagta micuringanpis ¿jutsacu cashga gamcunapä? ");
INSERT INTO qxoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tsaynömi discïpulücunapis mana jutsatatsu ruraycäyan: ‘Jamapay junagchö trïguta ama quiptupacuyätsuntsu’ niyaptiquipis. Tayta Diosga runacunata cuyarninmi: ‘Säbadu junagchö jamapäyay’ nishga alli cayänanpä, manam runacunapa ima ruraynincunata ricapäyänayquipätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Y nogapis Tayta Dios cachamashga captinmi munayyog caycä säbadu junagchöpis runacuna imata rurananpä o mana rurananpä cagtapis ninäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Juc cutichönam Jesus yapay yaycurgan Tayta Diosman mañacur goricäcuyänan wayiman. Tsaychömi maquin wanucashga juc runata tarirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tsaychö fariseucuna Jesusta ricapaycäyargan shonguncunallachö yarpachacurmi: “Mä ¿canan jamapay junag mana arucuy caycaptin cay runata allïtsingacush o manacush? Tsay runata allïtsiptinga tsaymi achäqui canga autoridäcunaman apatsinapä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsaynö yarpaycäyanganta musyarnam tsay maquin wanucashga runata Jesus nirgan: “Jau, sharcur tsay chöpiman ichïmuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nircurnam tsay fariseucunata tapurgan: “Tayta Dios ¿imata ruranantsictatä munan jamapay junagchö? ¿Cay geshyaycag runata cuyapashwancu o dejarishwancu ñacacunanpä?” nir. Tsaynö niptin paycuna manam imatapis parlacuyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tsaynam Jesus ajanarnin ricascärirgan mana cuyapäcog cayanganta musyar. Y nircurmi tsay runata nirgan: “Maquiquita mashtamuy” nir. Niptin tsay runa maquinta mashtasquir sänunam ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsaynam fariseucuna upällalla yargusquir willanacuyargan rey Herodespa cumpinchincunawan Jesusta wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Goricäcuyänan wayipita yargusquirnam Jesus discïpuluncunawan aywacuyargan gocha cuchunmanna. Tsaypa aywayaptinpis Galilea runacunaga gatipäyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesus milagruta rurangancunata musyarmi pasaypa runacuna juntapäyargan Judeapitapis, Jerusalenpitapis, Idumeapitapis, Jordan mayu wac-tsimpan quinranpitapis, Tirupitapis, y Sidonpitapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsaynö pasaypa runacuna goricäyaptinnam Jesus discïpuluncunata nirgan: “Canan juc büquita listu catsiyay runacuna juntämuptin gochaman yaycunapä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Runacunaga maypita tsaypitapis goricäyargan geshyagcunata allïtsishga captin “Yatayllapis yataycushä” nirninmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tsaynömi supaycunapis Jesusta ricayangancunachöga pasaypa mantsariyargan. Tsaymi tsaychö supay löcuyätsingan runapis Jesuspa ñöpanman gonguricuycur gayaycachar nirgan: “¡Gamga imaycawan munayyog Diospa tsurinmi canqui!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tsaynam Jesus supaycunata ajäpargan Tayta Diospita shamushga canganta ni ichicllapis mana parlayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsaypitanam Jesus jircanman witsarcur gayargan gatiragnincunata. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tsaychö goricasquiyaptinmi chunca ishcay runacunata (12) acrargan caynö nir: “Cananpitaga nogawanmi gamcuna puriyanqui. Nircurmi maypa tsaypapis aywayanqui Tayta Diospa willacuyninta willacuyänayquipä, ");
INSERT INTO qxoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","supaycunata runacunapita garguyänayquipä, y geshyagyashgacunata allïtsiyänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tsay chunca ishcay acrashga runacunaga caycunam cayargan: Simon (Paypa jutintaga quiquin Jesusmi ticratsirgan Pedruman), ");
INSERT INTO qxoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeupa tsurincuna Santiago y Juan (Paycunatapis cuyay jutincuna churargan “Boanerges” nirmi. Boanerges ninanga “magacuypa tsurincuna” ninanmi), ");
INSERT INTO qxoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andres, Felipe, Bartolome, Mateo, Tomas, Alfeupa tsurin Santiago, Tadeo, “Celote” ningan Simon, y ");
INSERT INTO qxoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jesusta ticrapur ranticog Judas Iscariote. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsaypita discïpuluncunawan Jesus Capernaumman cutir patsaräyangan wayimanmi yaycuyargan. Tsaymanpis atsca runacuna quichquiypa goricäyaptin manam micuytapis puëdiyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Shumag yachatsicur parlaptin tsaytsica runacuna goricäyanganta musyarnam Jesuspa castancuna goreg aywayargan yarpachacur: “Jesusga löcuyasquishgam ëllu” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalenpita charnin ley yachatsicogcunam itsanga Jesuspä niyargan: “Cay runaga manam Tayta Diospa poderninwantsu runacunapita supayta gargun, sinöga supaycunapa mandagnin Satanaspa poderninwanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsaynö llutancunata niyaptinnam tsay ley yachatsicogcunata gayarir Jesus tantiyatsir caynö nirgan: “¡Imanöparä Satanas quiquin pura gargunacunman! ");
INSERT INTO qxoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Musyangantsicnöpis juc nacion ishcayman raquicashga carnin, quiquincuna pura chiquinacur tsay runacuna wanutsinacurmi ushacätsinacuyanman. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tsaynölla juc wayichö tagcunapis quiquincuna pura chiquinacurga tsay castacuna raquicar gargunacurmi ushacätsinacuyanman. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsay cuentanöpis Satanas runacunapita supaycunata gargurga quiquin puram ushacätsinacuyanman”. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Tsaynö manam pipis juc lïsu runa wayinta täpaycaptinga imantapis suwapanmantsu. Tsaynö täpaycaptinpis paypita mas puëdeg runa chaycurmi itsanga pancaycur imantapis apacapunman. Tsay cuentanömi nogapis puëdeg caynïwan Satanaspa maquinpita runacunata jipiycä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nircurmi caynöpis nirgan: “Runacuna jutsa ruraynincunapita y manacagcunata parlayangancunapita perdonta mañacur Tayta Diospa perdonninta alcanzayangam. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Peru salvacog cangäta Espiritu Santo tantiyaycätsiptin conträ parlayaptinmi itsanga Tayta Dios imaypis perdonanganatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tsaynö Jesus nirgan ley yachatsicogcuna “Satanaspa poderninwanmi runacunapita supaycunata gargun” niyashga captinmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsaypitanam Jesuspa maman waugincunawan chäyargan yachatsicuycangan wayi cagman. Yaycuyänanpä mana alliptinmi wagtallapita gayatsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsaynam lädunchö jamarag runacuna Jesusta caynö niyargan: “Mamayquim waugiquicunawan wagtachö caycäyan ashiyäshurniqui” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tsaynö niyaptinnam Jesus paycunata nirgan: “Canan musyatsiyäshayqui picuna nogapa castäcunanö cayangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nisquirnam lädun quinran jamaraycäyag runacunata ricapascärir nirgan: “¡Cay ñöpächö caycagcunam nogapa mamänö waugïcunanö cayanqui! ");
INSERT INTO qxoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pipis Tayta Dios munangannö cawag cagcunam cayan nogapa waugïnö, panïnö, y mamänö” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tsaypita yapaynam Galilea gocha cuchunchö Jesus Tayta Diospa willacuyninta yachatsicur gallaycurgan. Tsaychö runacuna pasaypa quichquiypa goricäyaptinnam gochachö büqui caycagman Jesus yarcurcur jamacurgan tsaypita yachatsicamunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsaynam imayca iwalatsicuycunawan Jesus yachatsicamurgan caynö nirnin: ");
INSERT INTO qxoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Cay parlapangäcunata shumag tantiyacuyay. Juc runam trïgu murucog yargunä chacraman. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tsaymi matsiptinna waquin cag tiuyanä näniman. Näniman tiuyashga caycagtanam pishgucuna chaycur upshascärinä. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquin murucunanam tiuyanä shaga shagallaman. Tsaychö shumagllaga allpa mana captin tsay murucuna raslla jegascäramunä. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Allillaga trïgupa matsun mana captinna achaywan tsaquiscärinä. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin murucunanam tiuyanä cashacuna rurinman. Cashacuna shacshar tsapariptinnam mana ni jucpis wayunätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Y waquin cag murucunanam chänä alli allpaman. Tsaychöga shumag jegascäramur wiñar pogunä cada espïgachö quimsa chunca (30), jogta chunca (60) y juc pachac (100) gränuyag”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tsaynö parlasquirmi Jesus nirgan: “Cay ningäcunata wiyag cagga tantiyacuyay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tsaypita waquin runacuna aywacusquiyaptinga Jesus quëdarirgan chunca ishcay acrangan runacunawan y waquin gatiragnincunallawannam. Tsaynam tsaychö runacuna tapuyargan caynö: “Taytay, tsay yachatsicungayqui ¿imaninantä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tsaynö tapuyaptinnam Jesus nirgan: “Gamcunataga cäsucog cayaptiqui tantiyatsiyäshayquim parlapaycangäcunata. Mana cäsumag cagcunam itsanga ni imanöpa parlapaptïpis mana tantiyayangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tsaynö runacunapäga Diospa palabranchöpis nicanmi: ‘Noga rurangäcunata ricaycarpis manam criyiyantsu. Y willacungäcunata wiyaycarpis manam cäsucuyantsu. ¿Tsaynö caycartsurä Tayta Diospa perdonninta alcanzaycuyanman?’ ” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsaynö parlapärirnam Jesus nirgan: “Tsaynö iwalatsicuycunawanmi noga yachatsicü. Tsaymi murucog runaman iwalatsir parlapangäta mana tantiyayaptiqui canan tantiyatsiyäshayqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Trïgu muroga Diospa alli willacuyninmanmi iwalan. Murucog runaga tsay willacuyta willacogcunamanmi iwalan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Muru tiuyangan nänega chucru shongu runacunamanmi iwalan. Tsaynö shongu carmi waquin runacunaga Tayta Diospa willacuyninta wiyarpis chasquicuyantsu. Juc ishcay wiyayangallantapis Satanasmi gongaratsin. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Muru tiuyangan shaga allpanam waquin runacunaman iwalan. Paycunaga Diospa alli willacuyninta wiyar cushishgam chasquicuriyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tsaynö cushishga chasquicurpis shagachö allpa mana captin trïgu jegarcamur tsaquireg cuentam, criyicunganpita imayca ñacaycunaman char Diospa willacuyninta dejariyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Muru tiuyangan casha rurinpis waquin runacunamanmi iwalan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Paycunaga Diospa alli willacuyninta wiyarpis masga yarpachacuyan imaycayogpis cayllapä y quiquincuna munayangannö cawayänanpä cagllatam. Casha rurinchö trïgu jegarcamurpis illacäregnömi yarpaynincunapita Tayta Diospa willacuyninpis gongacärin”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Muru changan alli allpaga waquin runacunamanmi iwalan. Paycunaga Tayta Diospa willacuyninta cushishga chasquicurmi alli ruraychöna cawayan. Alli allpachö juc murullapita quimsa chunca (30) trïgu o jogta chunca (60) trïgu o pachac (100) trïgu wayungannömi Tayta Dios munangannö cawagcunaga cayan”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tsaypita discïpuluncunata tantiyatsir mastapis Jesus nirganmi: “Actsita manam churantsictsu cajon rurincunaman ni catri jawancunaman. Musyayangayquinöpis actsitaga churantsic alëricunamanmi shumag atsicyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tsay actsi alërichö car shumag atsicyagnö, gamcuna Tayta Diospa willacuyninta runacunata shumag willapäcuyaptiquim, tantiyacuyanga alli cawaychö cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Cay ningäcunata wiyag cagga tantiyacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Willapangäcunata wiyar chasquicurninga yachatsingäcunata masmi tantiyacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsaynö wiyacur cäsucogcunataga Tayta Dios masmi yanapanga shumag tantiyacuyänanpä. Peru mana cäsucog cagcunaga wiyarpis manam tantiyayangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","Tsaypita mastapis Jesus nirganmi: “Juc runa chacranchö trïguta murucuriptin jegamun gewallaran. Tsaypita wiñar wiñarnam shicshimun. Nircur poguriptinnaga cosichagllanam chärin. Tsay trïgu murucog runa manam tantiyantsu Tayta Dios murucuyninta jegatsir shacshatsir ruraycanganta. Tsaynömi runacuna mana tantiyayantsu jutsa ruraychö cawayninpita alli cawayman Tayta Dios ticraycätsinganta”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tsaynö mastapis Jesus yachatsirganmi caynö nirnin: ");
INSERT INTO qxoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Tayta Diospa willacuyninga imayca ñäbuspa murunnöllam. Tsay muru ichiclla caycarpis jegarcamurmi itsanga jatunyar llapan gewacunatapis jagisquir atsca rämayogman ticrarin. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tsaynö captinmi rämancunaman pishgucunapis rataycur geshuncuna rurayan. Tsay ichic murullapita ñäbuspa räman mashtacangannömi Tayta Diospa alli willacuyninga maytsaymanpis chaycan”. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tsaynö imaycamanpis iwalatsiypam Jesus runacunata Tayta Diospa willacuyninta yachatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Manam imaypis tsaynö mana iwalatsicuypaga runacunata yachatsirgantsu. Discïpuluncunataga imamanpis iwalatsiypa parlapangancunata shumagmi tantiyatseg. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsaypita patsa tsacanaycaptinnam discïpuluncunata Jesus nirgan: “Acu päsashun gocha wac-tsimpanman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Niptinnam discïpuluncuna Jesus caycangan büquiman yarcurcur runacunata gocha cuchunchö jagiriycur aywacuyargan. Waquin runacunaga juc büquicunawan gepantam aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsaynam pullan gochata aywaraycäyaptinna pasaypa vientu gochata lagchicachätsir gallacuycurgan wamayaypä. Büquiman yacu wiñacaptinnam jundicar gallaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusga gepa cuchuchömi jaunachö punucashga caycargan. Tsaynam discïpuluncuna pasaypa mantsacashga riyatsir niyargan: “¡Tayta Jesus, ricchay! ¡Jundicaycantsicnachä!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsaynam Jesus wap shärircur caynö nirgan: “Amana vientu vientuynatsu ni yacu lagchicachaynatsu” nir. Nisquiptin jinan öram yacupis vientupis pärasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nircurnam discïpuluncunata Jesus nirgan: “¿Imanirtä tsayläya mantsacashga caycäyanqui? ¿Manaräcu nogaman yäracayämunqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsayga discïpuluncuna quiquincuna puram pasaypa mantsacashga parlapänacuyargan: “Cay runaga ¿ima runanarä cacunpis tsayläya vientupis yacupis pay ninganta cäsuycunanpä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tsaynö aywaraycarnam Galilea gochapa wac-tsimpan “Gerasa” ningan marcaman päsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tsaychö Jesus büquipita yarpuriptinnam supay löcuyätsingan juc runa caru panteonpita yargascamur cörrillapa shamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tsay runaga panteoncunachö täcogmi cargan. Supaycunapa munayninchö captin mana ni pipis tsarayta puëdiyänätsu ni cadinacunawan pancarninpis. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Atsca cuti chaquipita maquipita runacuna pancayaptinpis supayyog car tsay runaga cadinatapis ichic ichicllaman rachir ushacätseg. Manam ni pipis puëdiyänätsu ni imanaytapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tsay runaga pagasnin junagnin purinä gayarar gagacunapapis panteoncunapapis rumicunawan tacacurnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tsaynam Jesusta ricasquir tsay runa cörrillapa aywargan Jesuspa ñöpanman gonguricog. Tsaynö payman aywaptinnam Jesus nirgan: “¡Gam supay, cay runapita yarguy!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Niptinnam ñöpanman gonguricuycur mantsarir supayyog runa gayarargan: “Poderösu Tayta Diospa tsurin Jesus, ¿imatatä munanqui nogacunawan? ¡Gamta rugacümi Tayta Dios raycur! ¡Ama cay runapita gargamarnï condenaycamaytsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsaynam supayta Jesus tapurgan: “¿Imatä jutiqui?” nir. Niptinnam supay nirgan: “Nogapa jutëga Legionmi. Legion niyäman pasaypa atscag cayaptïmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tsaynö nisquirmi Jesusta rugacurgan: “Ama nogacunata caru marcacunamanga gargaycayämaytsu” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tsay caycäyangan washa lädun jircan niragchömi atsca cuchicuna micuycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tsaynam supaycuna Jesusta yapay rugar niyargan: “Tagaychö caycag cuchicunallaman cachaycayämay yaycucuycuyänäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tsaychö cuchicunaman aywayänanpä Jesus niptinnam runapita yargurir ishcay waranganö (2,000) cuchicunaman yaycucuycuyargan. Tsaynam cuchicunaga acataycachaycar gochaman jegarpäriyargan. Tsaychömi chipyaypa shengacar wanuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tsayta ricaycur cuchi mitsegcunaga geshpir aywacuyargan marcapam ricayangancunata willacuyänanpä. Tsay willacuyaptinnam runacunaga marcapita shayämurgan: “Mä imash päsaycushga” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus caycanganman chaycurnam ricayargan supay löcuyätsingan runa trocapäcushga shumag fisyunchöna jamaraycagta. Tsayta ricaycur runacunaga pasaypam mantsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Marcapita chag runacunata willayargan supayyog runata Jesus allïtsingantam y gochaman cuchicuna jegayangantam. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsaynam runacuna Jesusta rugar niyargan tsay marcapita jucläpa aywacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tsaynam Jesus büquiman yarcuraycaptinna alliyag runa rugar nirgan: “Taytay, gamwan aywacuytam noga munä. Pushacallämay” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tsaynö niptinnam Jesus nirgan: “Nogawan aywacunayquipa rantinga wayiquipa cutir marca mayiquicunata willay gamta cuyapäshurniqui Tayta Dios allïtsishungayquita” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsaynam runa marcanman cutiycur Decapolis provinciapa maytsay marcancunapa purirgan Jesus cuyapar paypä ruranganta willacurnin. Tsay willacunganta wiyarnin runacunaga imanömi espantacur parlayargan supay löcuyätsinganpita Jesus allïtsinganta. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsaypita Jesus büquiwan gocha wac-tsimpanman chärinanpäga pasaypa atscam runacuna quichquishga goriraycäyargan Jesusta shuyacur. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsaymannam Israel runacunapa autoridänin Jairo jutiyog runa chärirgan. Payga cargan Tayta Diosman mañacur goricäyangancunachö mandacogmi. Tsay runam Jesuspa ñöpanman gonguricuycur rugacur nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Taytay, warmi tsurïchä wanuycanna. Acu jinallachö wayïman aywayculläshun maquillayquiwan yataycunayquipä. Tsayga allircur cawangam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tsaynam Jairuwan Jesus aywaraycäyargan wayinman. Y atsca runacunam gepanta aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tsay runacunachömi juc warmi aywargan chunca ishcay (12) watana yawar apaywan geshyagyashga. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tsay warmega atscag jampicogcunachö jampicurninpis manam allirgantsu. Tsaynöpam imaycancunatapis pasaypa ranticurna ushargan. Payga jampicur allïnanpa rantin masmi antsargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tsay warmega geshyagyashga runacunata Jesus allïtsinganta musyarmi runacunapa rurinllapa yaycuycur Jesuspa röpanta yataycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tsay warmega yarpänä shongunllachö: “Jesuspa röpallantapis yataycurga allisquishämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tsay yarpangannö Jesuspa röpanta gepallanpa yataycuptinmi yawar aywaynin pärasquirgan. Y jinallanchömi quiquin warmipis allisquingantaga mayasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsay warmi allinganta tantiyasquirnam gepanchö runacunaman ticraycur Jesus tapurgan: “¿Pitä yataycamushga röpäta?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tsaynam discïpuluncuna niyargan: “Tayta Jesus, ¡cay atsca runachöga imanöparächi musyashwan röpayquita pï yatamungantapis! ¿Imanirtä gamga tapucunqui: ‘¿Pitä röpäta yatamushga?’ nirnin?” ");
INSERT INTO qxoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsaynö niyaptinnam Jesus llapanta ricapargan: “Mä ¿pishi yatamashga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsaynam warmi allisquinganta tantiyar mantsariywan tsuctsucyarrä Jesuspa ñöpanman gonguricuycurgan caynö nir: “Señor Jesus, nogallämi röpayquita yataycallämurgö”. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tsaynö niptinnam Jesus nirgan: “Hïja, nogaman yäracamurmi tsay geshyayquipita allirguyqui. Cananga cushishgana cuticuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus tsaynö parlapaycaptinmi Jairupa willacognincuna chaycur caynö niyargan: “Tayta Jairo, tsuriquega wanushganam. ¿Imapänatä Jesustapis wayiquiman pushanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tsaynö negta wiyaycurnam Jesus Jairuta ricarcur nirgan: “Ama llaquicuytsu. Nogallaman yäracamuyga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsaynam Jairupa wayinman Jesus aywargan discïpuluncuna Pedruta, Santiaguta, y Juanta pusharcur. Waquincuna aywayänantaga manam munargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairupa wayinman chaycur rasunpapis tarisquiyargan wamra wanushgana caycagtam y tsaychö atsca runacuna pasaypa wagaycäyagtam. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tsaynam Jesus caynö nirgan: “¿Imatatä tsayläya wagayanqui? Cay wamra wanushga caycarpis punuycagnöllam riccharcamunga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tsaynö niptin Jesustaga runacuna asipäyarganmi. Tsaynam llapan runacunata wagtaman gargascamur Jesus quimsan discïpuluncunawan y wamrapa papäninwan mamanwan yaycuyargan aya sutaraycanganman. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsaychönam Jesus wamrata maquinpita tsarircur caynö nirgan: “Wamra, sharcamuy” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tsaynö niptin wamraga jinan öram sharcarcamur purir gallaycurgan. Tsay wamraga cargan chunca ishcay (12) watayogmi. Jesus cawarircatsimuptin wamrapaga papänincuna pasaypa espantacurmi cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tsaypitanam paycunata Jesus nirgan: “Cay wamrata cawatsimungäta pitapis willacuycäyanquimantä” nir. Nisquirnam nirgan wamrata micunan garayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tsaypitanam Jesus discïpuluncunawan cuticurgan Nazaret marcanman. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tsaychönam säbadu jamapay junagchö Israel runacuna Tayta Diosman mañacur goricäcuyänan wayichö Jesus yachaycätsirgan. Tsaynam runacuna yachatsicunganta wiyar niyargan: “Cayga ¿maychönatäshi tsayläya yachacaycamushga? ¿Y ima poderninwanrä imayca milagrucunatapis ruran? ");
INSERT INTO qxoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Payga manacu Mariapa wawan carpintërulla, Santiagupa, Josepa, Judaspa, Simonpa waugin? Y panincunapis cay marcallachöchä nogantsicwan täräyan” nir. Tsaynö nirninmi mana cäsuyargantsu Jesus yachatsicungancunata. Tsaymi Jesus caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","“Jucläcunachöga Tayta Diospa willacognin profëta willacungancunata runacuna chasquicuyanmi. Peru quiquinpa marca mayincunaga, castancunaga, wayinchö cagcunaga manam cäsupäyantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsaynö payman mana criyicuyanganpitam quiquinpa marcanchöga juc ishcay geshyagcunallata maquinta churar allïtsirgan. Manam mastaga milagrucunata rurargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tsaynö cayanganpita marca mayincunapä Jesus feyupam llaquicurgan. Tsaypita yargucurnam Jesus marcan marcanna purir runacunata yachatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsaypita juc cutinam Jesus chunca ishcay discïpuluncunata gayaycur ishcay ishcay cachargan Tayta Diospa willacuyninta willacuyänanpä y runacunapita supaycunata garguyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tsaynö paycunata cacharninmi nirgan: “Canan aywar tucrullata apayanqui. Ama alporjata, millcapata, ni gellëta apayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jatiräyangayqui llangiquicunallawan y janayquicunachö röpayquicunallawan aywacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maychöpis pipis wayinman patsatsiyäshuptiqui tsayllachö cacuyanqui tsay marcapita aywacuyangayquiyag. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","May marcamanpis chäyaptiqui sïcush runacuna mana chasquiyäshunquitsu o yachatsiyangayquita wiyayta mana munayangatsu, tsaypita aywacuyanqui chaquiquicunachö polvuta tapsicusquir. Tsaynöga rurayanqui mana chasquiyäshungayquipita Tayta Dios paycunata castigananpä cagta musyatsirmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsaynö cachaptin discïpuluncuna aywar yachatsicuyargan Jesus ningannöllam: “Jutsa rurayniquicunata jagirir Tayta Diospa perdonninta mañacur allina cawayay” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nircur atsca cutim runacunapita supaycunata garguyargan y geshyagcunapa urcunman acëtita wiñar allïtsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Jesuspa imayca milagru ruraynincunata maytsaychömi runacuna musyayargan. Tsaynam waquincuna niyargan: “Juan Bautistash wanunganpita cawaramushga canman. Tsaymi Diospa willacognin car imayca milagrucunatapis ruraycan” nirnin. Waquinnam niyargan: “Payga Tayta Diospa willacognin profëta Eliasmi” nirnin. Y waquincunanam niyargan Tayta Diospa unay willacognin maygan profëtapis canganta. Tsaynö niyanganta musyarnam rey Herodes nirgan: “Tsay runaga Juan Bautistam canga. Paymi umanta roguycätsiptïpis cawarimushga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Caynömi päsargan Juan Bautistapa umanta rey Herodes rogutsingan. Unaymi Herodes waugin Felipipa warmin Herodiasta gechusquir targan. Tsaynam Herodesta Juan nirgan wauginpa warmin tsararay mana alli canganta. Tsay ninganpitam Juantaga Herodiasna chiquir wanutsiyta munargan. Tsaynö chiquiparmi tsay warmi waynan Herodesta nirgan Juanta prësutsir carcelman wichgatsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Carcelman wichgatsirpis jutsaynag alli runa Juan canganta musyarninmi Herodesga respitargan. Tsaymi Herodias Juanta wanutsiyta munaptinpis Herodesga tsaparganrä. Juan imayca parlapangancunata Herodes cushishga wiyarpis manam tsay jutsa ruraynintaga jagiycurgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsaypita Herodias Juanta wanutsiyänanpä pasaypa shuyacuycaptinnam Herodespa santun junag chärirgan. Tsaynam Herodes santun junagchö gayatsirgan autoridäcunata, militarcunata, y Galilea provinciachö väleg runacunata wayinchö micuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Tsaychö Herodiaspa jipash wawan imaläya pasaypa shumagmi tushuycurgan. Tsaynö cösa tushungan imanömi llapantapis tsaychö cagcunataga gustaycurgan. Tsaynam jipashta Herodes nirgan: “Canan itsanga imaycata munangayquitapis mañamaylla. Gamtaga garaycümi cay mandacuycangä nacionpa pullanninta mañamaptiquipis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsaynö niptinnam jipashga aywar mamanta tapurgan: “Tiyü Herodesmi imaycatapis garamayta munan. ¿Imatatä mañashä, mamay?” nirnin. Niptin mamannam nirgan: “Mañay Juan Bautistapa umanta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsaynam jipashga Herodesman cutiycur nirgan: “Noga munä Juan Bautistapa umanta plätuchö goycamänayquitam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tsayta mañaptinmi itsanga Herodes pasaypa llaquicuyman churacasquirgan. Invitäduncunapa ñöpanchö jurar aunicushga carmi imata mañaptinpis jipashtaga ñëgayta puëdirgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tsaynam jinan öra juc soldäduta cachargan Juanpa umanta apapämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldädunam carcelman aywar Juanpa umanta rogusquir plätuchö jipashta goycurgan. Y jipashnam mamanta apapaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsayta rurayanganta musyasquir Juanpa discïpuluncunam aywar ayanta pampacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tsaypita Jesuspa apostolnincuna willacuyninta willacur puriyanganpita cutir llapancunam cangan goricäyargan. Tsaynö goricarnam paycuna Jesusta willapäyargan yachatsicur puriyanganchö imanö cayanganta. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus may puringanmanpis runacunaga quichquiypam goricäyargan. Tsaynam tsaychö runacuna quichquiparäyaptin ni micuytapis mana puëdiyargantsu. Tsaynam Jesus nirgan: “Cay runacunapita yargur acu aywacushun quiquintsiclla jäcogninchö jamacurinantsicpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsaynö nirnam büquiman yarcurcur discïpuluncunawan Jesus jäcogmanpaman aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tsaypa aywayaptinpis runacuna ricar maytsaypita goricarmi gocha cuchunmanga puntantana chäriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tsayman Jesus chärirnam büquipita yarpurir tarirgan pasaypa atsca runacuna tsaychöpis shuyarar caycäyagta. Tsay runacunaga imayca mitsegniynag üshacunanömi mana cäsushga cacuyargan. Tsaymi paycunata cuyapar Tayta Diospa willacuyninta Jesus yachatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tsaychö yachatsicuycaptin patsa tardiyaptinnam discïpuluncuna niyargan: “Taytay, tardiyasquinnam. Cay tsunyagchöga manam imapis cantsu cay runacuna micuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cay runacunata niycuy aywacur imallatapis rantir micuyänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tsaynö niyaptinnam Jesus nirgan: “Gamcuna micuyänanpä garayay” nir. Tsaynam paycuna niyargan: “Caytsicag runapäga ¿ayca gellëwanrä micuytapis rantiycayämüman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tsaynö niyaptin Jesusnam tapurirgan: “¿Imayquicunallatä capuyäshunqui? Mä ricärayämuy” nir. Ricäramurnam niyargan: “Pitsga tantawan ishcay pescädullam caycan, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsaynam Jesus nirgan: “Cay pampa ogu janancunallachö llapancuna juc pucha juc puchaman jamacuriyätsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ningannömi runacuna pitsga chuncapa (50) y juc pachacpa (100) goricar jamacuriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tsaynam Jesus tsay pitsga tantata y ishcay pescäduta tsarircur ciëluman ñuquircurnin Tayta Diosman mañacur agradesicurgan. Nircurnam tsay tantata paquirir discïpuluncunata macyargan runacunata aypuyänanpä. Tsaynöllam tsay ishcay pescädutapis paquirir paycunata macyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsaychö runacuna pachajuntam micuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Manana munar sobrapacuyangantanam tantatawan pescäduta discïpuluncuna goriyargan chunca ishcay (12) canastacunaman. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tsaychö micogcunaga cayargan pitsga warangam (5,000) ollgucuna, warmipis wamrapis mana yupashga. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsaypitanam discïpuluncunata Jesus nirgan: “Gamcuna büquiman yarcurcur gochapa wac-tsimpan Betsaida marcaman puntaraycäyay” nir. Ningannö discïpuluncuna aywaraycäyaptinnam tsay gocha cuchunchö caycag runacunata nirgan paycunapis aywacuyänanpäna. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nircurnam Jesusga juc jircanman japallan witsargan Tayta Diosman mañacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsaypita gocha pullanta büquiwan discïpuluncuna aywaraycäyaptinnam patsa tsacasquirgan. Jesusga jircanchömi jinalla mañacur caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gochachö büquita vientu wacman cayman apaptin discïpuluncunaga pasaypa ñacarmi aywaycäyargan. Tsaynam gällu cantay öranöna Jesus paycuna cagman japar aywargan yacu jananpa. Tsaynö aywaraycäyaptin Jesusga washa läduncunapam päsag tucurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tsaynam discïpuluncuna gocha jananpa almatanö aywaycagta ricar mantsacarnin gayaräyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tsaynö mantsacäyaptinnam Jesus parlapar caynö nirgan: “¡Ama mantsacäyaytsu! Noga Jesusmi cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsaynö nir büquiman yarcurcuptin jinan öram vientupis pärasquirgan. Tsaycunata ricar discïpuluncunaga pasaypa espantashgam cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Discïpuluncunaga tsaytsica runacuna micuyänanpä milagruta ruranganta ricashga caycarpis Jesus poderösu cangantaga manam tantiyacuyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tsaypita Galilea gochapa wac-tsimpan Genesaret pampaman chärirnam büquita watayargan gocha cuyur chöpinman mana yaycatsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tsaychö büquipita Jesus yarpuriptin jucllam runacunaga regiriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Paycunanam waquin runacunataga aywar willacuyargan Jesus maychö caycangantapis. Tsayta musyarnam geshyagcunata andamiawan wantushga Jesus caycanganman apayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maytsay ciudäcunapa, marcacunapa, estanciacunapa Jesus puriptin maypapis aywanganpam geshyagcunata chätsipäyargan röpallantapis yataycuyänanpä. Tsay geshyacogcuna röpanpa cuchullantapis yataycurga llapanpis allïyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Juc cutinam Jerusalenpita aywar fariseucunawan ley yachatsicogcuna Jesus cagman chäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsaychömi Jesuspa discïpuluncuna maquincunata mana awicullar micuycäyagta ricar quiquincuna pura parlacachäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseucunaga y llapan Israel mayincunaga unay runacunapa üsuncunata cumplirmi manarä micur maquincunatarä awicur purificacuyagrä limpiu caycaptinpis. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tsaynömi rantipacuyanganpita cutirpis manarä maquita awicurga mana jamacuyagtsu. Tsaynö imaycaläya üsuncunawan Tayta Diosta respëtuchö tsararmi täzancunatapis, matincunatapis, mancancunatapis, jamacuyänancunatapis micuyänanpäga awiyagrä shumag limpiu caycaptinpis. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsaynam fariseucunawan ley yachatsicogcuna Jesusta tapuyargan: “¿Imanirtä discïpuluyquicunaga unay runacunapa üsuncunata mana cäsur micuyänanpä maquincunata awicuyantsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tsaynö niyaptin Jesusnam nirgan: “Gamcunaga janan shongulla Tayta Diosman criyicurmi yachag tucuyanqui. Tsaynö runacunapämi unay profëta Isaias gellgargan Tayta Dios caynö ninganta: ‘Cay runacunaga shimincunallawanmi nogata adorayämag tucuyan. Manam llapan shonguncunawantsu nogaman yäracayämun. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tsaynö carninmi adorayämanganpis mana cangan cuentalla caycan. Noga ningäta yachatsicuyänanpa rantinmi quiquincunapa üsuncunallata runacunata yachaycätsiyan’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Tsaynö nisquirnam Jesus nirgan: “Isaias gellgar ningannöllam gamcunapis Tayta Diosta mana cäsucur musyag tucurnin unay üsuyquicunallata sïgiycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tayta Diospa mandamientunta unay Moises gellganganchöpis caynömi nican: ‘Papäniquita mamayquita respitar alli ricanqui. Papäninta mamanta mana respitag cagtaga supayta apatsiyätsun’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tayta Diospa mandamientun tsaynö niptinpis gamcunaga yachatsicuyanqui caynö niyänanpämi: ‘Papä, mamay, imaycäcunapis Tayta Diosllapämi caycan. Tsaynö captin manam yanapayniquita puëdïnatsu’. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tsaynö nir yachatsiyaptiquinam manana papänincunata ni mamancunata yanapayannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tsaynöcunata yachatsicurmi unay üsuyquicunata sïgillar cacuyanqui, Tayta Dios mandacungantaga imapäpis mana cuentaypa. Tsaynö carmi gamcunaga yarpäyangayquita imaycatapis rurallar caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tsaycunata nisquirmi Jesus runacunata gayaycur caynö nirgan: “Tsay nimungäcunata llapayquicuna shumag tantiyacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Runacunaga jutsayog ticrayan shonguncunachö mana allicunata yarpar llutancunata parlayanganpitam y rurayanganpitam, manam ima micuytapis micuyanganpitatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tsay ningäta wiyacog cagga tantiyacuyätsun”. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsaynö parlapasquirnam Jesus discïpuluncunawan wayiman yaycurirgan. Tsaychönam paycuna tapuyargan: “Tsay yachatsicungayquita tantiyaycatsiyämay” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tsaynam Jesus caynö nirgan: “¿Gamcunapis manacu tsayta tantiyaycuyanqui? Runacuna manam micunganpitatsu jutsayog ricacun. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ima micuypis micungantsicga päsacunllam. Tsaymi micuyta micuyanganwanga runa mana ima jutsamanpis chaycantsu” nir. (Tsaynö nirmi Jesus tantiyatsicurgan ima micuypis micunapä allilla canganta.) ");
INSERT INTO qxoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nircur yapaypis nirganmi: “Runacunaga shonguncunachö llutancunata yarparmi mana allicunata parlayan y rurayan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tsaynö llutan yarpayyog carmi majancunawannö piwanpis lluta puricuyan, suwacuyan, wanutsicuyan, ");
INSERT INTO qxoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","adulteriu jutsata rurayan, runacunapa imantapis munapäyan, runa mayinta mana allita ruratsiyan, llullacuyan, imayca viciucunachö puriyan, runacunapa imanpis capuyaptin chiquicuyan, wasarima cayan, mana imapäpis väliycar runa tucur nicachäyan, y imayca jutsa ruraycunallachö cawayan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tsay llapan mana alli ruragcuna shonguncunachö yarpäyanganpitam jutsayog cayman chäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsaypitanam Jesus aywacurgan Tiro provinciapana. Tsayman changanta runacuna mana musyayänanpämi juc wayiman patsacurgan. Payga manam mayman pacacuytapis puëdirgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tsaychö cayanganta musyasquir jinan öram juc warmi Jesus cagman shamurgan. Paypa warmi wawantam supay munayninchö caycätsirgan. Jesus cagman chasquirnam ñöpanman gonguricuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nircurnam Jesusta rugacur nirgan: “Wawäpita supayta garguycullay, taytay” nir. Tsay warmega cargan Jesus puriycangan Sirofenicia nacionpitam. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsaynam warmita Jesus nirgan: “Manam allitsu canman Israel mayïcunatarä yanapanä caycaptin, gamcunatarä punta puntata yanapasquiptëga. Tsayga canman wamracunapä cagta tantata allgucunata jitapaycog cuentachir” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tsaynam warmi nirgan: “Taytay, tsaynö caycaptinpis ämun shicwapacungantachä allgucunaga micuyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tsaynö niptinnam Jesus nirgan: “Gam tsaynö nirguyqui nogaman rasunpa yäracamurmi. Canan wayiquipa cuticuy. Wawayquipita supay yargushgatanam tarinqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsaynö nisquiptin warmi wayinman chärirnam tarirgan wawanpita supay yargushgatana. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesusga Tirupita päsacurgan Sidon provinciamannam. Tsaypita cutirnam Decapolis marcacunapa päsar Galilea gocha cuchunman chärirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tsaymannam runacuna chätsipäyargan mana wiyag mana parlag runata caynö rugacur: “Señor Jesus, maquillayquita churar cay runata alliycatsillay ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsaynam Jesus runacunapita witirir runapa rinrinman dëdunta jatirgan. Y dëdunman togaycurnam runapa gallunta yataycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nircurnam ciëluman ñuquircur Tayta Diosman mañacurirgan. Tsaynam runata nirgan: “¡Canan wiyayna y parlayna!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tsaynö nisquiptin jinan öram runapa upayashga rinrincuna quichacasquirgan y parlar gallaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tsaynö tsay runata alliscatsirnam tsaychö runacunata Jesus nirgan: “Ama pitapis willacuyanquitsu cay runata allïtsingäta” nir. Tsaynö nicaptinpis mana wiyacuypam llapancunapis willacur puriyargan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","“¡Imaycatapis Jesusga ruraycun pasaypa espantacuypätam! Llapan rurangancunapis allillam. Cananga mana wiyagcunapis wiyayannam. Mana parlagcunapis parlayannam” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tsaypita juc ishcay junagtanam yapayna Jesus caycanganman atsca runacuna goricäyargan. Tsaychö micuyänanpä mana imapis captinmi discïpuluncunata Jesus gayarir nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cay runacunata noga cuyapänam. Quimsa junagnam nogantsicwan cayan. Y manam capuyannatsu micuyänanpä imancunapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tsaynö mallagllata wayincunaman cachaycushgaga nänichöpis mallagaywan wanucuycuyangachi. Waquincunaga carupitam cayanpis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tsaynö niptinnam discïpuluncuna niyargan: “Caytsica runapäga ¡maychörächi tarishwan imatapis! Cay tsunyagchöga imapis cantäcu, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tsaynam Jesus tapurgan: “¿Aycatä tantayquicuna capuyäshunqui?” Niptin paycunanam niyargan: “Ganchisllam (7) caycan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsaynö niyaptinnam llapan runacunata Jesus nirgan juc puchaman jamacuyänanpä. Nircur tantata tsarircurnam Tayta Diosman mañacur agradesicurgan. Tsaypitanam tantata paquirir paquirir discïpuluncunata macyargan runacunata aypuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tsaynömi acapalla pescäducunata apapäyaptinpis Tayta Diosman mañacurgan. Nircurmi discïpuluncunata macyargan runacunata aypuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsaypita llapancuna pachajunta micuriyaptinnam putsog tantata pescäduntinta goriyargan ganchis (7) canastacunaman junta juntatarä. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsaychö micogcunaga cayargan chuscu waranganömi (4,000). Tsaynö micuriyaptinnam runacunata wayincunapa aywacuyänanpäna Jesus nirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nisquir discïpuluncunawanmi büquiman yarcurcur Dalmanuta marcacunapana aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tsaypita tsay Dalmanuta quinran Jesus caycanganta musyarirnam fariseucuna Jesusman aywayargan caynö nir: “Tayta Dios rasunpa cachamushungayquita musyayänäpä, mä canan ricayänächö ima milagrutapis ruramuy”. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tsaynö niyaptinnam Jesus llaquicur jamayta cachar nirgan: “¿Imanirtä milagrutarä ruranäta munayanqui? Tayta Diospita shamungäta mana criyiyangayquipitam gamcunapä ima milagrutapis rurashätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tsaynö nisquirmi büquiman yarcurcur gocha wac-tsimpanmanna aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tsaypita büquiwan gochata aywaraycarnam discïpuluncuna parlayargan jucllaylla tantancuna capuyanganta. Paycunaga gongaycurmi masllataga micuynincuna apayänätsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tsaynö micuy janan rimanacuyanganta wiyarnam Jesus nirgan: “Pagtä fariseucunapa y rey Herodespa levadürancunata chasquipaycäyanquiman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tsaynam discïpuluncuna mana tantiyar quiquincuna pura ninacuyargan: “Tantantsic mana captinchir tsaynö nimantsic” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsaynö niyanganta mayarnam Jesus yapay nirgan: “Gamcuna ¿imanirtä yarparaycäyanqui pachapä cagllata, Tayta Diosman mana yarpaypa? ");
INSERT INTO qxoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yachatsingäcunata wiyaycarpis ¿manacu tantiyaycuyanqui? Milagrucunata rurangäta ricaycarpis ¿manacu criyiycäyämanqui maypita shamungätapis? ");
INSERT INTO qxoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pitsga tantallapita pitsga waranga (5,000) runacuna micuyänanpä milagruta rurangäpita ¿ayca canasta tanta putsogtatä goriyargayqui?” Niptin paycunam niyargan: “Chunca ishcay canastatam, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tsaynam Jesus yapay nirgan: “Ganchis (7) tantapita chuscu waranga (4,000) runacuna micuyänanpä milagruta rurangäpita ¿ayca canasta tanta putsogtatä goriyargayqui?” Niptin paycunanam niyargan: “Ganchis canastacunamanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsaynam Jesus nirgan: “Ciëlupita shamur Tayta Diospa poderninwan imaycata rurangäta musyaycarnaga, ¿imanirtä nogaman mana yäracayämunquirätsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsaypitanam Jesus discïpuluncunawan Betsaida marcaman chäyargan. Tsaymannam juc gaprayashga runata chätsiyargan. Nircurnam rugayargan tsay runata yataycur alliycatsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tsaynam Jesus tsay gaprata jancharcur marcapita wagtaman jipirgan. Nircurnam ñawinta togapinwan llushisquir umanman maquinta churarcur tapurgan: “¿Ricanquicu?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tsaynam gapraga ñöpan quinranpa ricachacur gallaycurgan caynö nirnin: “Aumi yangallaga ricallänam, taytay, runacuna imayca jachanö puriycagcunata” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsaynö niptin runapa ñawinta Jesus yapay yataycuptinmi ñawincuna allisquirgan y imaycatapis shumag atsicyagtanam ricargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tsaynö alliscatsirnam Jesus tsay runata wayinpa cuticunanpä caynö nirgan: “Cananga marcaman mana chayllapa castayquicunaman cuticuy allïshayquita willacunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsaypitanam Cesarea de Filipos marcacunapa discïpuluncunawan Jesus aywargan. Tsaynö aywaraycarnam paycunata tapurgan: “¿Noga pï cangätatä runacuna niyan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Niptinnam discïpuluncuna niyargan: “Waquin runacunam niyan Juan Bautista cangayquita. Waquincunam niyan unay Tayta Diospa willacognin profëta Elias cangayquita. Y waquincunanam niyan Tayta Diospa willacognin juc profëta cangayquita”. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tsaynö niyaptinnam paycunatana Jesus tapurgan: “Y gamcunaga ¿noga pï cangätatä yarpäyanqui?” nir. Tsaynam Pedro nirgan: “Gamga Tayta Dios cachamungan salvacogmi canqui, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsaynö niycuptin Jesusnam nirgan: “Gamcuna amarä pitapis willacuyanquitsu Tayta Dios cachamungan salvacog cangäta” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nircurnam discïpuluncunata parlapargan caynö nir: “Noga ciëlupita shamogta runacuna alläpa ñacatsirmi maltratayämanga. Autoridäcuna, sacerdöticunapa mandagnincuna, y ley yachatsicogcuna conträ sharcurmi wanutsiyämanga. Peru wanutsiyämanganpita quimsa junagtaga cawarimushämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tsaynö niptinnam Jesus llutanta parlaycanganta yarpar Pedro jucläman gayasquir nirgan: “Tayta Dios ama munaycutsuntsu tsaycuna päsashunayquita, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tsaynö niptinnam Satanas Pedruta parlaycätsinganta musyar discïpuluncunaman ricarcur Jesus nirgan: “¡Cay runapita yarguy, Satanas!” Nisquirnam nirgan: “Pedro, gamga runacuna yarpangannöllam nicämanqui. Gamga Tayta Dios ninganta cumplinäpä cagta manam mayanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tsay nisquirnam runacunata y discïpuluncunata gayarir nirgan: “Pipis discïpulü cayta munarga quiquinpa munayninllachöga ama cawatsuntsu. Ima ñacayta päsarpis Tayta Dios munangannö cawatsun. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pipis quiquinpa munayllanman cawacog cagga manam gloria vïdaman changatsu. Pipis willacuynïta chasquicur Tayta Dios munangannö cawag cagmi gloria vïdachöga cushishga cawanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Juc runata imapärä välinman jinanpä mundupa duëñun canganpis gloriaman mana chänan captinga. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Infiernuman gaycucaptinnaga mananam gellëninpis ni imanpis salvanganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pipis nogapita y willacuynïpita runacunapa ñöpanchö pengacuptinga tsay pengacamagcunata manam nogapis cäsushätsu, Tayta Diospa angelnincunawan chipipir ciëlupita cutimungä junag”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tsaynö nisquirnam Jesus nirgan: “Waquinniquicunaga cawaycällarran ricayämanqui Tayta Dios cachamangan salvacog rey chipipirrä caycagta”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tsaypita jogta junagtanam Jesus jircanman witsargan Pedruta, Santiaguta, y Juanta pushacurcur. Tsaychömi paycuna ricaraycäyaptin Jesus pasaypa chipipir jucnöman ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Röpanpis pasaypa yullag pürumanmi chipipir ticrargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nircurnam discïpuluncuna ricaycäyaptin Moiseswan Elias yuripasquir Jesuswan parlayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsaynam Jesusta Pedro caynö nirgan: “Taytay, ima allipämi cayman shacayämurgä. Cananga rurayämushä quimsa tsucllacunata, jucta gampä, jucta Moisespä, y juctana Eliaspä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Tsaychö quimsan discïpuluncunapis pasaypa mantsacashga carmi imanö niytapis mana puëdir Pedro tsaynöllana parlapargan.) ");
INSERT INTO qxoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsaynö nicaptinnam pucutay tsapacurcuptin pucutay rurinpita Tayta Dios nimurgan: “Paymi cuyay tsurï. Pay niyäshungayquicunata cäsucuyay” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsaypita discïpuluncuna ricachacusquiyänanpäga Jesus japallannam läduncunachö shaycänä. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsaypitanam jircapita uraraycämurna Jesus nirgan: “Jircachö ricayangayquicunata amarä pitapis willacuyanquitsu, nogata wanuscatsiyämaptin cawamungäyag” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tsay ningannöllam discïpuluncuna mana pitapis willacuyargantsu. Peru quiquincuna puram itsanga tapunacuyargan: “¿Imaninanrä ‘Wanusquirmi cawamushä’ ninganga cashga?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsaynam quimsan discïpuluncuna Jesusta niyargan: “Ley yachatsicogcunaga niyan: ‘Salvacog chämunanpäga Eliasrämi puntataga shamunga’ nirmi. Tsaynö cananpä caycaptinga gampa puntayquita ¿imanirtä Eliasräga shamushgatsu?” ");
INSERT INTO qxoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Tsaynö niyaptinnam Jesus nirgan: “Elias shamunanpä cagta niyangannöllam payga shamushgana. ‘Tayta Dios cachamungan salvacogta chasquicuyänayquipä jutsayquicunata jagiyay’ nir willacuptinpis manam runacuna chasquicuyashgatsu. Tayta Diospa palabran ningannöllam chasquicuyänanpa rantin wanutsiyargan. Tsaynöllam noga Tayta Diospita shamogtapis runacuna mana alli ricar wanutsiyämanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jircapita discïpuluncunawan cutimurnam tariyargan atscag runacuna goriraycäyagta y tsaychö waquin cag discïpuluncuna ley yachatsicogcunawan rimanacuycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsayman Jesus yaycuraycagta ricasquirnam runacuna pasaypa cushishga cörrilla taripäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tsay runacunaman chaycurnam Jesus discïpuluncunata tapurgan: “¿Imatatä paycunawan rimanacuycäyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsaynö nicaptinnam juc runa nirgan: “Tayta, ollgu tsurïtam apamurgö alliycatsipallämänayquipä. Paytaga supaymi upayätsishga. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tsaynöpis maytsaychömi wanuy geshya tsariptin ishquir pushgayta agtun quiruntapis uchur. Tsaynö captinmi gamta mana tarir discïpuluyquicunatapis rugargö tsurïpita supayta garguycuyänanpä. Peru paycunaga manam puëdiyashgatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tsaynö niptinmi Jesus nirgan: “¡Yäracuyniynag runacuna! ¿Nogallarätsurä tsaycunata ruraycäshä? ¡Imayyagrä gamcunawan caycäshä! Canan apayämuy tsay wamrata” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsaynam Jesuspa ñöpanman wamrata apaycuyaptin supay tsuctsucyätsir patsaman ishquiriycatsirgan. Y wamranam pushgayta agtur goshpargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tsayta ricaycurnam Jesus wamrapa papäninta tapurgan: “¿Imaypitanatä supay tsuriquita ñacatsin?” nir. Niptinnam papänin nirgan: “Pishi canganpitanam tsaynö ñacatsin, taytay. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Supayga wanutsiyta munar atsca cutinam ninamanpis yacumanpis ishquitsishga. Taytay, imallatapis rurayta puëdirninga canan cuyapäcog cayniquiwan yanapaycallämay ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tsaynö rugacuptinnam Jesus nirgan: “Nogaman rasunpa yäracamuptiquega tsuriqui allingam. Tsaynö yäracamogcunataga imaycachöpis yanapashämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsaynam wamrapa papänin wap nirgan: “Gammanga yäracamümi, taytay. Yanapaycallämay llapan shongüwan gamllaman imaypis yäracunäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsaynam runacuna mas atscagna goricaraycaptin supayta Jesus nirgan: “Upayätsicog supay, cay wamrapita yarguy. Imaypis cutiycämunquimantä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsaynö Jesus niycuptin supayga jinan öram gayarar wamrata tapsiriycur aywacurgan. Supay yargusquiptin wamraga wanushganömi jitaraycar quëdasquirgan. Tsaychö runacunanam niyargan: “Wamraga wanusquisham ëllu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tsaynam Jesus wamrata maquinpita tsarircur jayarcuptin allishgana ichircamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsaypitanam discïpuluncunawan juc wayiman Jesus yaycurgan. Tsaychönam japallantana Jesusta tapuyargan: “Taytay, ¿imanirtä nogacunaga tsay supayta garguyta mana puëdiycuyargötsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Niyaptinnam Jesus nirgan: “Tsayläya puëdeg supayta garguyänayquipäga Tayta Diosmanmi mañacuyänayqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsaypitanam Jesus Galilea provinciapana discïpuluncunawan cuticuyargan. Payga manam munargantsu runacuna musyasquir juntapäyänanta. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Munarganga discïpuluncunallawan parlacuriytam. Tsaynam nirgan: “Tayta Dios cay patsaman cachaycämaptinpis nogataga chiquimagnïcunapa maquinmanmi entregayämanga wanutsiyämänanpä. Wanutsiyämaptinpis quimsa junagtaga cawamushämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tsaynö parlapaptinpis discïpuluncunaga manam tantiyayargantsu imapä nicangantapis. Tsaynö mana tantiyarmi imapita wanutsiyänanpä cagta tapurcuytaga mantsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsaypita Capernaum marcaman chaycurnam patsarangan wayiman yaycuyargan. Tsaychönam discïpuluncunata Jesus tapurgan: “¿Imata rimanacurtä nänita shayämurguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tsay tapuptin discïpuluncunaga upällallam cacuyargan. Paycunaga imata rimanacuyangantapis willacuyta pengacuyargan, mayganpis llapancunapita mas mandacog cayta munar rimanacushga carmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsaynam Jesus jamaycur discïpuluncunata nirgan: “Maygayquipis mas puëdeg cayta munarga llapancunapa sirvegninmi cayänayqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsaynö nisquirnam juc wamrata gayasquir margarcurnin discïpuluncunata nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Pipis cay wamratanö runa mayinta alli ricag cagmi nogata chasquiycämag cuenta caycäyan. Nagana nogata chasquimarninga cachamagnï Tayta Diostapis chasquiycäyanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tsaynam discïpulun Juan nirgan: “Taytay, nogacuna ricayargö supayyog runacunapita jutiquichö juc runa supaycunata gargogtam. Pay nogantsicwan mana puriptinmi michäyargö” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsaynam Jesus nirgan: “Ama michäyanquitsu. Nogantsicwan mana purishga carpis nogaman yäracamur imayca milagrutapis rurarga allillatam ruraycan. Tsaynö carninga manam nogapa conträtsu caycäyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pipis nogata cäsumag cagcunaga munangätam ruraycäyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nogaman criyicamogcunata pipis juc täza yacullatapis garaycog cagtam Tayta Dios yanapanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus tsaynö yachatsicurir mastapis nirganmi: “Pipis nogaman criyicamog cagta jutsa rurayman ishquitsegcunaga mana cuyapaypam castigacäyanga. Tsaypa rantinga mas allim canman jatuncaray mulinu rumita cuncanman wataparcur lamarman jitarpuyaptinpis”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Tsaynölla maquiqui jutsata ruratsishuptiqui mejormi tsay maquiquita roguriycunquiman. Ishcan maquiquiwan manana upeg ninaman gaycucänayquipa rantinga tsulla maquillapis gloriaman yaycuptiquim mas allega canga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Jutsa rurayman chaquiqui apashuptiqui mejor tsay chaquiquita roguriycunquimanmi. Ishcan chaquiquiwan infiernuman gaycucänayquipa rantinga mas allim canman tsulla chaquillapis gloriaman chaptiqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Tsaynöpis jutsa rurayman ñawiqui ishquitsishuptiqui mejormi tsay ñawiquita ogtiriycunquiman. Ishcan ñawiquiwan infiernuman gaycucänayquipa rantinga mas allim canga jucag ñawillayquiwanpis Tayta Diospa ñöpanman yaycuptiqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Infiernuchöga curucunapis runata micucuycanmi y ninapis manam ni imay upintsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tsayman yaycogcunaga llapancunam nina rauraycagchö imayyagpis rupacuycangalla”. ");
INSERT INTO qxoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Musyangantsicnöpis cachega allim micuyta gustuta gonanpä. Tsay cachi micuyta gustuta gongannö gamcunapis criyicog mayiquicunawan alli cawayay. Mana tsaynö cawarga gamlagyashga cachinöpis manam imapä väliyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaum marcapita Jesus aywacurnam chargan Judea marcacunaman y Jordan mayu wac-tsimpanman. Tsaymanpis pasaypa runacuna goricäyaptin imaypis yachatsicungannömi Jesus yachatsicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsay yachatsicuycagman fariseucuna chaycurmi Jesusta llutancunata parlatsiyta munar tapuyargan caynö: “Jau señor, ¿allicu warminpita juc runa raquicanman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tsaynam Jesus nirgan: “Moises gellgangan leycunachö ¿imatä nin tsay raquicay janan?” ");
INSERT INTO qxoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tsaynö niptin paycunanam niyargan: “Moisesga caynömi yachatsicurgan: ‘Pipis warminpita raquicayta munarga divorciu actata firmapänacuycur raquicäcuyätsun’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsaynö niyaptinnam Jesus nirgan: “Moisesga tsaynö gellgargan gamcuna llutalla warmiquicunata jagirir cawacuyaptiquim. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tsaynö captinpis Tayta Diosga manam runacuna majanpita raquicänanpätsu camargan. Tayta Diospa palabran gellgaranganchömi nin: ‘Ollguta warmita Tayta Dios camargan juntacar täyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tsaynöpam ollgupis warmipis papäninpita mamanpita yargucur majanwanna tacucäcuyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tsaynam ishcancunapis mushog castaman ruracäyan’ nir. Tsaynö Tayta Dios ningannöllam nagana juntacarga mana jäpanönatsu, sinöga juc castallamannam ticrariyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tsaynö cananpä Tayta Dios camacaycätsiptinga manam pipis majanpita raquicanmantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsaypitanam wayichö caycarna discïpuluncuna Jesusta tapuyargan: “Tantiyaycatsiyämay majayogcuna raquicäyangan janan, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tsaynam Jesus nirgan: “Pï runapis warminpita raquicasquir jucwan targa tsay runa adulteriu jutsatam ruraycan, punta cag warminpa contran. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsaynöllam warmipis gowanpita raquicasquir jucwan targa adulteriu jutsata ruraycan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsaypita juc cutichönam runacuna Jesusman wamrancunata apapäyargan maquinta umancunaman churar Tayta Diosman mañacapänanpä. Jinatanam discïpuluncuna michar cutitsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tsayta ricarnam Jesus ajäpar nirgan: “¡Ama michäyaytsu nogaman wamracuna shayämunanta! Pipis cay wamracunanö llullu shongu cagcunatam Tayta Dios glorianman päsatsinga. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wamra papänincunaman yäracungannö pipis Tayta Diosman mana yäracogcunaga manam gloriaman yaycuyangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsaynö nisquirnam wamracunata margacurcur, umancunaman maquinta churar Tayta Diosman mañacurgan imaypis yanapaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tsaypita Jesus aywacuycaptinnam juc runa cörrilla aywar ñöpanman gonguricuycur nirgan: “Taytay, gamga alli rurag runam canqui. Mä niycamay, ¿imatatä ruräman gloria vïdaman chänäpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tsaynam Jesus nirgan: “¿Imanirtä alli rurag cangäta nimanqui? Manam pï runapis alli ruragga cantsu. Tayta Diosllam alli ruragga. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gam mandamientuncuna caynö ninganta musyanquinam. ‘Ama runa mayiquita wanutsinquitsu. Ama adulteriu jutsata ruranquitsu. Ama suwacunquitsu. Ama runa mayiquita manacagta tumpanquitsu. Ama runa mayiquita imatapis criyitsinquitsu. Papäniquita mamayquita respitar alli ricanqui’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tsaynö niptinnam tsay runa nirgan: “Taytay, tsaycunataga wamra cangäpitachä cumpliycä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tsaynam Jesus alli cayninwan runata ricaparcur nirgan: “Tsaynö llapanta cumpliycarpis Tayta Diosman criyicungayqui musyacänanpä jucta ruranayquiran faltäshunqui. Canan wayiquiman cutiycur llapan imaycayquicunatapis ranticuscärir pobricunata aypuy. Tsayta rurarga jana patsachö mana ushacag riquëzatam chasquinqui. Nircur nogaman yäracamur aywacamuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tsaynö Jesus niycuptinmi itsanga runa yarpachacur wamayashga jegasquirgan alläpa rïcu carnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsaynam Jesus maytsaypa ricapascärir discïpuluncunata nirgan: “¡Ajallarämi rïcu runacuna Tayta Diospa glorianman yaycuyänanpäga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesus tsaynö ningancuna discïpuluncuna yarpäyangannö mana captin pasaypam yarpachacuyargan. Tsaymi Jesus nirgan: “¡Gloriaman yaycuyga imanö ajam riquëzancunaman yäracogcunapäga! ");
INSERT INTO qxoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tsaypa rantinga mas fäcilchi jatuncaray camëllu ashmapis aujapa uchcunpa ullusquinman, juc rïcu runa gloriaman yaycunanpä cagpitaga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsaynö Jesus niptinnam discïpuluncuna pasaypa yarpachacur tapuyargan: “Tsaynö captinga ¡pirä salvacunga, taytay!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tsaynam Jesus discïpuluncunata yapay ricapascärir nirgan: “Runacuna quiquincunallapitaga manam salvacionta tariyantsu. Tayta Diosmi pitapis jutsancunapita perdonar salvan. Paypäga manam imapis ajatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Niptinnam Pedro nirgan: “Taytay, nogacunaga llapan imaycäcunatapis jagisquirmi gamta gatiraycäyä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Tsaynö niptin Jesusnam nirgan: “Alli willacuynïta willacur pipis wayinta, wauginta, paninta, mamanta, papäninta, tsurincunata, chacrancunata jagireg cagga jaginganpita pachac (100) cuti mastam cay patsachö taringa. Capungam wayinpis, waugincunapis, panincunapis, mamanpis, tsurincunapis, chacrancunapis. Ñacatsiptinpis willacuynïta willacogcunaga gloria vïdachömi imayyagpis mana ushacaypa cawanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tsaynömi imaycayogpis cayllapä yarpachacogcunapaga imaycanpis faltanga y gloriamanpis mana yaycuyangatsu. Noga raycur imaycancunatapis jagireg cagcunam itsanga gloriaman chäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tsaypitanam discïpuluncunawan Jerusalenman Jesus aywaraycäyargan. Discïpuluncunaga yarpachacurninmi wamayashga aywaycäyargan. Waquin gatiragnincunapis mantsacashgam aywaycäyargan. Tsaynam chunca ishcay discïpuluncunallata jucläman gayasquirnin Jesus parlapargan: ");
INSERT INTO qxoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Gamcuna musyayanquim Jerusalenman aywaycangantsicta. Tsaychömi noga Tayta Diospita shamogta runacuna prësur apayämanga sacerdöticunapa mandagnincunaman y ley yachatsicogcunaman. Paycunanam wanutsiyämänanpä Roma autoridäcunapa maquinman apatsiyämanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tsaychömi nogapita burlacuyanga, togapäyämanga, astayämanga, y wanutsiyämanga. Peru wanutsiyämanganpita quimsa junagtam cawamushä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsaypitanam Zebedeupa tsurincuna Santiaguwan Juan Jesusman witiycur niyargan: “Taytay, jucta rugacuyälläshayqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Niyaptinnam Jesus nirgan: “¿Imatatä yarpaycäyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsaynam paycuna niyargan: “Gam poderösu cayniquiwan mandacur cangayquichö gamta mandäshiyänäpä churaycayämay, jucnïta derëcha cag läduyquiman y jucnïtana itsog cag läduyquiman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsaynö niyaptinnam Jesus nirgan: “Gamcunaga manam musyayanquitsu imata mañacuyänayquipä cagtapis. Ayagta ultarpog cuentam noga ñacashä. ¿Nogata ñacatsiyämangannö gamcunatapis runacuna ñacatsiyäshuptiqui awantayanquimantsurä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsaynam paycuna niyargan: “Aumi, taytay. Awantayämanmi”. Niyaptin Jesusnam nirgan: “Rasunpam noga ñacangänö gamcunapis ñacayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Peru tsaynö captinpis derëchä o itsognï cagchöga cayanga Tayta Dios ningan cagcunallam”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tsaynö mañayanganta musyasquirnam waquin discïpuluncuna Santiagupäwan Juanpä ajäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsaynam Jesus llapancunata gayasquir nirgan: “Gamcuna musyayangayquinöpis may nacioncunachöpis mandacog autoridäcunaga puëdeg caynincunawanmi llapan runacunata manduncunachö catsiyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gamcunachöga manam tsaynö canmantsu. Gamcuna alli ricashga cayta munarninga waquincunatarä yanapayay. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maygayquipis nogapa discïpulü cayta yarpag cagga waquincunapa sirvegninrämi cayänayqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tsaynömi nogapis Tayta Diospita shamurgö runacunata imaycachöpis yanapanäpä, manam munangäta ruratsinäpätsu. Tsaynö carmi runacuna raycur wanushä jutsancunapita perdonashga cayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsaypitanam chäyargan Jerico marcaman. Tsaychö Jesus discïpuluncunawan carir aywacuyaptinpis atscag runacunam gepanta gatipäyargan. Tsay aywaycäyangan näni cuchunchömi juc gapra Bartimeo jutiyog runa jamaraycargan limushnata mañacurnin. Tsay gaprayashga runaga Timeo ninganpa tsurinmi cargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tsaynam Jesus Nazaret runa päsaycagta musyasquir gapra gayarar nirgan: “Unay rey Davidpa castan Jesus, cuyapaycallämay ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tsaynö gayacuptin runacunaga gaprata ajäpäyargan: “¡Upälla cay!” nirmi. Tsaynö niyaptinpis payga mas fuertipam gayacurgan: “¡Rey Davidpa castan, cuyapaycallämay!” ");
INSERT INTO qxoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Niptinnam Jesus ichisquir nirgan: “Tsay runata gayayämuy” nir. Tsaynam paycuna aywar niyargan: “Cushicuy. Jesusmi gayashunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Niyaptinnam gapra punchuntapis jitasquir wap sharcur aywargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesuspa ñöpanman chasquiptinnam tapurgan: “¿Imachö yanapanätatä munanqui?” nir. Tsaynam runa nirgan: “Taytay, gaprayashga car ricaytam munallä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Niptinnam Jesus nirgan: “Cananga ricayna. Nogaman yäracamungayquipitam allirguyqui” nir. Tsaynam gapraga wap ricachacusquirgan. Tsaypitanam Jesuspa gepanta cushishga aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tsaypita Jerusalenman yaycuraycarnam chäyargan “Olivos” ningan jircanman. Tsay jircan wac-wagtanchömi Betfage y Betania marcacuna cargan. Tsaypitam Jesus cachargan ishcay discïpuluncunata caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Aywayay tagay wac-tsimpapa. Tsaychömi tariyanqui manarä pipis muntacushga juc pollïnu ashnu wataraycagta. Tsayta pascasquir apayämunqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pipis ‘¿Imapätä tsay ashnuta apayanqui?’ niyäshuptiquega niyanqui: ‘Señor Jesusmi miñishtin muntacunanpä. Rätupayllatam cutiratsiyämushä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsaynam ishcan discïpuluncuna aywar tariyargan Jesus ningannölla wayi puncu näni cagchö ashnu wataraycagta. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tsayta pascaycäyagta ricaycurnam runacuna tapuyargan: “¿Imapätä cay ashnuta pascayanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Niyaptin discïpuluncunanam niyargan Jesus yätsingannölla. Tsaynam runacuna dejaycuyargan discïpuluncuna apayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesus caycangan cagman chäratsiyaptinnam punchuncunata carunaparcuyaptin Jesus muntacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tsaynö muntashga aywaraycaptinnam runacuna punchuncunata jacuncunata näniman mashtayargan. Waquincunanam jachapa rämancunata paquiscärir mashtayargan Jesus aywangan näniman. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nircurnam llapan runacuna Jesuspa ñöpanta gepanta aywar cushicuypita gayaraypa gayarar niyargan: “¡Tayta Dios cachamungan mandamagllantsic rey alabashga caycullätsun! ¡Ima cushicuypämi nogantsicman cachaycamungan! ");
INSERT INTO qxoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Unay David rey cangan watacunachönömi cananga gamna mandayämag reylläcuna canqui! ¡Gracias ciëluchö caycag Tayta Dioslläcuna!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tsaypita Jerusalenman Jesus chaycurnam templuman aywargan. Tsaychö ricapacusquirnam tardiyaptinna Betaniaman cuticurgan discïpuluncunawan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tsaypita warayninnam Betaniapita aywaraycarna Jesus mallagacuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tsaynam ricasquirgan hïguspa yuran verdirä caycämogta. Tsaynöta ricarnam prütanta pallag aywargan. Peru yuranllatam tarirgan manarä hïguspa tiempun captin. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsaynam discïpuluncunapa wiyananchö hïguspa yuranta Jesus nirgan: “Cananpita manam pipis prütayquita micunganatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesus Jerusalenman chaycurnam templuman yaycurgan. Tsaychö ranticogcunata y rantipacogcunata tariycurnam gargur ushargan. Gellë trocatsegcunapa mësancunatapis, paluma ranticogcunapa jamacuyänancunatapis wicaparmi ushargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nircur micharganmi templupa puncun quinran rantipacuynincunata puritsiyänantapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsaycunata rurasquirnam runacunata ajäpar nirgan: “Tayta Diospa palabranchö caynömi gellgaraycan: ‘Temploga noga Diosllayquita maytsaypitapis shamur adorayämänayquipämi’ nir. Tsaynö nicaptinga ¿imanirtä gamcunaga ladroncunapa machaynintanö catsiyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tsaynö Jesus rurangancunata musyarnam sacerdöticunapa mandagnincuna y ley yachatsicogcuna willanacuyargan wanutsiyänanpä. Peru Jesuspa yachatsicuynincuna runacunapä alläpa alli captinmi paycunata mantsar dejaycuyarganrä. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tsaypita patsa tsacanaptinnam Jerusalenpita Jesusga discïpuluncunawan aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Waraynin Jerusalenman cutiraycarnam Jesus manana wayunanpä ningan hïguspa yuran matsunpita tsaquishga caycagta discïpuluncuna ricayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsayta ricaycurnam Pedro yarpasquir Jesusta nirgan: “¡Taytay, ricaycuy! Ganyan tagay hïgusta ‘Mananam wayunquinatsu’ ningayqui tsaquishgana caycan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Niptinnam Jesus nirgan: “Tayta Diosman yäracuyay. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pipis payman yäracur tagay jircata ‘Tsaypita lamarman witicuriy’ niyaptiquipis witicurinmanmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gamcuna Tayta Diosman yäracuycur mañacurnin imatapis mañacuyangayquitaga alcanzayanquim. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tayta Diosman mañacuyangayqui öra pipis mana alli ricäyäshogcunapä yarpar perdonayanqui. Tsaynöpam gamcunatapis Tayta Dios perdonayäshunqui llapan jutsayquicunapita. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gamcuna perdonacuyta mana yachayaptiquega Tayta Dios manam gamcunatapis perdonayäshunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsaynam Jesus discïpuluncunawan yapayna Jerusalenman chäriyargan. Templuchö Jesus puriraycaptinnam sacerdöticunapa mandagnincuna, ley yachatsicogcuna, y mas waquin autoridäcuna aywar tapuyargan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Gam ¿ima puëdeg cayniquiwantä cay templupita ranticogcunata gargurguyqui? Tsaycunata ruranayquipä ¿pitä cachamushurguyqui?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Tsaynö niyaptinnam Jesus nirgan: “Gamcunatapis mä jucta tapuyäshayqui. ¿Pitä Juanta cachamurgan bautizananpä? ¿Tayta Dioscu o runacunacu? Tapungäta niyämaptiquega nogapis willayäshayquim tsaynö ruranäpä pï cachamangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsaynö niptinnam quiquincuna pura willanacur niyargan: “‘Tayta Diosmi cachamushga’ nishgaga nimäshun ‘¿Imanirtä payta chasquicuyargayquitsu?’ nirmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Runacunallam cachamushga’ nishganam llapan runacuna janantsicman shayämunga. Paycunaga Tayta Dios Juan Bautistata cachamungantam yarpäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsaynö willanacurirnam Jesusta niyargan: “Nogacuna manam musyayätsu Juanta pï cachamungantapis”. Tsaynö niyaptinnam Jesus nirgan: “Gamcunapis mana willaycäyämaptiquega nogapis manam willätsu caycunata ruranäpä pï cachamangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsaypitanam Jesus yachatsicurnin nirgan: “Juc runam chacranman üvata plantatsinä. Nircur maytsayninpa genchatsinä. Tsaynö gencharatsirna üvapa yacunta gapinanpäpis juc puchachö pözuta ruratsinä. Nircurnam täpatsinanpäpis jinan chacrachö juc tsucllata ruratsinä. Tsaynö llapantapis rurascatsirnam tsaychö arupagnin runacunata arrendädu jagipaycur juclä caru marcapa aywacunä. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsaypita üva cosëcha gallariptinna juc empliyädunta cachanä payta töcangan cagta gorimunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tsayna empliyädun chäriptinga chacran tsararag runacuna magacacharcur mana imatapis raquipällar garguriyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Tsayna chacrayog runaga juctana empliyädunta cachanä. Paytapis tsaynölla chacran tsararag runacunaga samgar umantapis paquir usharcur imaycata gayaparcurrä garguriyänä. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsaypita mas juctana chacrayog cachanä. Paytaga wanuratsiyänä. Tsayna chacrayogga mas atscagtana cachanä. Paycunatapis waquinta magayänä, waquintana wanutsiyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tsä, chacrayogpaga cuyay tsurinllana quëdasquinä. Tsayna payta cachanä caynö yarpar: ‘Cay tsurïtaga respitarnin manam imanayämunganatsu’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Tsayna chacrayogpa tsurin yaycuraycagta ricasquirga chacra arrendarag runacunaga willanacuyänä: ‘Tagaymi cay chacrawanga heredëru quëdanga. Payta wanuriycatsishun chacran nogantsicpäna cacunanpä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Tsaynö willanacusquirna chacrayogpa tsurintapis tsarisquir wanuratsiyänä. Nircur ayantapis chacranpita jucläman jitariyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsaycunata parlapärirnam Jesus nirgan: “Quiquin chacrayog chaycur tsay runacunata ¿imatarä ruranga? Chacran arrendaragcunata wanuscäratsirmi juccunatana chacranta arrendacunga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tsaynö nisquirnam Jesus nirgan: “Gamcuna infiernuman mana gaycucayta munarga tantiyacuyänayquim caynö nir Tayta Diospa palabran gellgarangantapis: ‘Wayi cimientog runa “Cay rumega manam allitsu” nir jitariyangan cagrämi alli albañilpäga mayistra rumimanrä ticrarin. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tsaynömi nogata runacuna mana välegpä cuentayämaptinpis Tayta Diosga alläpa väleg canäpä churamashga. Tsayga ima cushicuypämi criyicogcunapä’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsaynö Jesus parlapäriptin tsaychö autoridäcuna contrancuna parlaycanganta musyarnam prësuytana munayargan. Peru atscag runacunata mantsacurninmi imatapis mana rurayllapa aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsaypitanam fariseucuna y rey Herodespa cumpinchincuna willanacur Jesusman aywayargan alli shimincunallapa tapucog tucur, Roma mandacogpa contran parlaptinga tsaynöpa prësuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaycurnam caynö niyargan: “Taytay, nogacuna musyayämi rasun cagllata imaypis gam yachatsicungayquita. Gamga Tayta Dios munangannö runacuna cawayänanpämi yachatsicunqui. Imata parlarpis pitapis mana mantsapacuypam ninqui. Tsaynö captin tapucuriyälläshayqui. Munayninchö catsimagnintsic Roma nacionpä impuestuta ¿pägashwancu o manacu pagashwan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tsaynam paycuna yachay shimincunawan parlapaycäyanganta musyarnin Jesus nirgan: “¡Imanirtä imaycanöpa llutancunata parlatsiyämaypä wanuycuyanqui! Mä, juc gellëta apamur ricatsiyämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tsaypita gellëta apapaycuyaptinnam Jesus nirgan: “Cay gellëchöga ¿pipa reträtuntä caycan? ¿Pipa jutintä gellgaraycan?” Niptinnam paycuna niyargan: “Romachö mandamagnintsic emperadorpam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsaynam Jesus nirgan: “Emperadorpa cagtaga emperadorman apaycapuyay. Tayta Diospa cagtaga Tayta Diosta goycuyay” nir. Tsaynö niptinnam imatapis mana niyta puëdirna upällacurpuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsaypitanam saduceucunana Jesus caycanganman chäriyargan. Paycunaga yarpäyargan wanushgacuna manana cawayämunanpä cagtam. Tsaymi tapucurnin caynö niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Taytay, Moises gellganganchöga caynömi nican: ‘Juc runa tsuriynaglla wanucuptin gepa cag wauginna llumtsuynin viüdawan tätsun. Tsaynöpam viüdachö wamran yuriptin tsay wanog cag wauginpa tsurin cuentana canga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tsaymi canan cuentariyäshayqui. Ganchis (7) waugicunash cayänä. Mayor cagshi juc warmiwan tänä. Payga tsurin manarä captinshi wanusquinä. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tsayna viüdawan gepan cag wauginna tänä. Paypis manarä tsurin captinshi wanusquinä. Y tsaynöpis mas gepan cag wauginna viüdawan tänä. Paypis wanusquinälla. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tsaynöllash llapan waugicunapis tsay warmillawan täyänä. Peru tsurincuna manarä captin wanucuyänä. Tsä, tsaypitaga warmipis wanucunä. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y wanushgacunata Tayta Dios cawaritsimungan junagga ¿maygan cag waugipa warmintä canga, llapancunawan tashga caycaptinga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tsaynam Jesus nirgan: “Gamcuna tsaynö nir Tayta Diospa palabran gellgaranganta manam tantiyayanquitsu. Tsaymi poderösu cayninwan runacunata cawaritsimunanpä cagta mana musyayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanushgacuna cawarircamurga mananam warmiwan ollgu täyanganatsu, sinöga ciëluchö caycag angelcunanöllam cayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wanushgacuna cawariyämunanpä Moises gellganganta liyiycarpis ¿manacu tantiyacuyanqui? Abraham, Isaac, y Jacob wanuyanganpitaga alli unaytam shiraca rauraycag munti rurinpita Moisesta Tayta Dios nimurgan: ‘Nogaga Abraham, Isaac y Jacob adoraycäyämangan Diosmi cä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tsaynö nishga captinmi musyantsic wanushgallanchö paycunata Tayta Dios mana dejaringanta. Tsayta mana tantiyarmi gamcunaga pantacashgallarä caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Saduceucunata tsaynö Jesus ningan ley yachatsicog runata alläpam gustaycurgan. Tsaynam Jesusman witiycur tapurgan: “Taytay, Diospa llapan mandamientunpita ¿maygan cagtatä mas cäsushwan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tsaynam Jesus nirgan: “Mas cäsuypä cag mandamientunga caynömi nican: ‘Israel runacuna, wiyacuyay. Diosniquicunaga jucllayllam. Payga Señorniquicunam. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Diosta cäsurnin cawayay llapan shonguyquiwan, llapan yarpayniquiwan, llapan callpayquiwan’. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gepan cag mandamientunpis tsaynömanpallam: ‘Runa mayiquita quiquiquitanö cuyanqui’ nin. Tsay ishcan mandamientucunam mas cäsuypäga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsaynö Jesus niptinnam tsay ley yachatsicog runa nirgan: “Allim tsay llapan ningayqui, taytay. Gam ningayquinöllam Diosnintsicga jucllaylla. Manam juc Diosga cannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Llapan shonguntsicwan, yarpaynintsicwan, callpantsicwan Tayta Diosta cäsurnin y runa mayintsictapis quiquintsictanö cuyarninga allitam ruraycantsic. Rasunpapis tsaynö cawangantsicmi masga välin leynintsic ningannö ashmacunata templuman apar altarchö Tayta Diosta adorar rupatsingantsicpitapis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tsaynö alli yarpayninwan ley yachatsicog runa niptinnam Jesus nirgan: “Gamga Tayta Diospa ñöpanman chänayquipä cagta tantiyaycanquinam” nir. Tsaynö Jesus niptin mananam pipis ni imata tapupayta puëdiyargannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tsaypita templuchö yachatsicuycarnam Jesus nirgan: “Unay rey David castapita carpis salvacogga manam runallatsu. Payga Diosmi. Tsaynö caycaptinga ¿imanirtä ley yachatsicogcuna niyan runalla canganta? ");
INSERT INTO qxoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espiritu Santo tantiyatsiptinmi quiquin Davidpis caynö nir gellganä: ‘Salvacogga Diosnïmi. Paytam Tayta Dios ninga: “Jamacamuy cay derëcha cag lädüman llapan chiquishogniquicunata munayniquichö catsinayquipä” nir’. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","‘Salvacogga Diosnïmi’ nir David nicaptinga, salvacog shamogga ¿imanöpatä runalla canman?” Tsaynö Jesus yachatsicuptin atscag runacunam wiyayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nircur tsaynö yachatsicurninmi Jesus nirgan: “Pagtatä ley yachatsicogcuna munaynincunata rurar cawacuyangannö paycunata cäsur cawaycäyanquiman. Paycunaga chaqui puntanyag röpancuna jatipäcushga cällicunachöpis puriyan, runacuna ‘Tayta Dios munangannömi paycunaga cawayan’ niyänanta munallarmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Paycunaga goricäcuyänan wayicunachöpis mas allin cag jamacuyänancunachöran jamasquiyan. Micupacuypä invitashga carpis mas allin cag jamacunacunataran ashiyan. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tsaynö alli tucuycarmi viüdacunapataga imaycancunatapis sacyapar ushayan. Nircur tsaycunata rurarirga runacuna mana tantiyayänanpämi mana ima rurashganö unayrä Tayta Diosmanpis mañacur mayaräyan. Tsaynö cayanganpitam paycunataga Tayta Dios mana cuyapaypa castiganga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tsaypita templuchö Jesus jamaycarnam ricargan ofrendata wiñacuyänan cäjaman runacuna gellëta wiñaycäyagta. Tsaychömi capogyog runacuna lasag gellëta wiñaycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsaymanmi juc wactsa viüdapis chaycur ishcay ichishag pöcu valoryog gellëllata wiñargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tsayta ricaycurnam discïpuluncunata gayasquir Jesus nirgan: “Allau, cay pobri viüdapa ofrendanga mas valoryogmi cashga Tayta Diospäga. ");
INSERT INTO qxoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Waquin cagcunaga capuyanganpita putsogllantam garaycuyashga. Cay wactsa warmega tsayllana cawacunanpä caycaptinpis capungan cagtam wiñaparcushga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tsaynam templupita Jesus yarguycaptinna juc discïpulun nirgan: “¡Caytsican templu imaläya shumag rumicunawan pergashgam, au taytay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tsaynö niptinnam Jesus nirgan: “Ricaycangantsic caytsican templu juchungam. Manam ni juc rumipis pergaraycar quëdangatsu. Chipyaypa juchurmi ushacanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tsaycunata nisquirnam Jesus aywargan discïpuluncunawan templupa wac-tsimpan Olivos jircanman. Tsaychö Jesus jamacuriptinnam discïpuluncuna Pedro, Santiago, Juan, y Andres tapuyargan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Taytay, ¿imaytä ningayquinö templuta juchutsiyanga? ¿Imanöpatä musyayäshä tsaycuna ruracar gallaycunanpä cagta?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tsaynö niyaptinnam Jesus nirgan: “Pagtatä pipis llullapar llutancunata criyiycätsiyäshunquiman. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Atscagmi nogapa jutïchö llullacogcuna chäyämunga: ‘Nogaga salvacog Cristum cä’ nir. Tsaynö nirninmi atsca runacunata criyitsiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maytsaychöpis ‘Gyërram caycan’ nirnin runacuna parlayaptinpis ama mantsacäyanquitsu. Rasunpapis puntataga tsaycunarämi päsanga. Tsaycuna päsaptinpis cay patsa ushacar manam gallangarätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Juc nacion runacunam pelyanga jucag nacionwan, juc marcam jucag marcawan. Maytsaychöpis terremötu captin patsam alläpa cuyunga. Mallagay watacunam canga. Tsaynö captinpis tsayga wagacuypa gallaycunanllarämi canga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gamcuna alcäbu cacuyanqui. Runacunam autoridäcunaman apatsiyäshunqui. Goricäcuyänan wayicunachömi astayäshunqui. Puëdeg autoridäcunapa, mandacog reycunapa ñöpancunamanmi chätsiyäshunqui nogapa willacuynïta willacuyangayquipita. Tsaychömi paycunatapis gamcuna yachatsingäcunata willacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cay patsa manarä ushacaptinmi maytsay nacioncunaman Tayta Diospa alli willacuyninga willacushga canga. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gamcunaga ama yarpachacuyanquitsu prësu autoridäcunaman apayäshuptiqui imata parlayänayquipäpis. Parlayangayqui öram Espiritu Santo tantiyatsiyäshunqui imanö niyänayquipä cagtapis”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Tsay witsancunaga mana criyicog wauginmi criyicog wauginta autoridäcunaman entregaycunga wanutsiyänanpä. Tsaynömi taytancuna tsurincunata entregayanga wanutsiyänanpä. Tsurincunapis papänincunata chiquiparninmi wanutsiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nogaman criyicayämungayquipitam pipis maypis chiquiyäshunqui. Tsaynö imayca ñacaycunata päsarpis mana ajayaypa criyicamog cagmi Tayta Diospa ñöpanman chäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tayta Diosta adoracuyänan templuman Satanaspa cachan runa yaycuycur Diosnintsicta ajätsir imaycatapis ruragta ricarnin llapayqui criyicogcuna Judea jircacunapa geshpir aywacuyanqui. (Señornintsic cay ninganta liyeg cagga yarpasquir tantiyacuyanqui.) ");
INSERT INTO qxoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tsay junagga wayichö caycagcuna, ama imayquicunamanpis jipeg yaycuyanquinatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chacracunachö caycagcuna, ama trocanayquicunaman jipegllapis wayiquicunaman cutiyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tsayläya ñacay junagcunachö, ¡allau geshyag warmicuna y llulluncuna chuchuycag warmicuna! ");
INSERT INTO qxoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tsay ñacay junagcuna tamya tiempuchö mana cananpä Tayta Diosman llapayqui mañacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tsay junagcunaga imay nuncapis mana ñacayanganmanmi runacuna pasaypa mantsaripä ñacayanga. Cay patsata Tayta Dios camangan junagpitapis runacuna manam tsaynöga ñacayashgatsu. Y mananam ni imay ñacayanganapistsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tsay ñacaycunata Tayta Dios mana päratsiptinga llapan runacunam chipyaypa ushacäyanman. Tsayläya ñacaychö gloriaman aywagpä cagcunata Tayta Dios cuyaparninnam tsay ñacayta päraratsingarä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tsaynö captin pipis ‘Cay runam salvadorga’ o ‘Washachömi caycan salvamagnintsic runaga’ niyäshuptiqui ama ichicllapis criyiyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Atscagmi criyitsicogcuna niyanga: ‘Tayta Dios cachamangan salvacogmi cä’ o ‘Diospa willacognin profëtam cä’ nirnin. Tsaynö nirmi imayca milagrucunatapis rurayanga runacuna paycunaman criyicurcuyänanpä. Tsaynö imaycanö criyitsirmi Tayta Diosman criyicogcunata waquintaga engañayangarä. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tsaycuna päsananpä cagta musyaycarnaga gamcuna alcäbu cacuyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tsayläya ñacacuycuna päsasquiptinga mananam rupaypis ni quillapis atsicyanganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Estrëllacunapis ciëlupita shushuyämungam y ciëlupis sicsicyangam. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tsaypitanam noga ciëlupita pucutay jananchö pasaypa chipipirrä shamuycagta runacuna ricayämanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nircurmi puëdeg angelnïcunata cachashä maytsay cay mundu entërupita acrashga cag runacunata cuchu cuchupita goriyämunanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Cay hïgusman iwalatsir ningäcunata yarparäyanqui. Musyayanquim tamya tiempu gallaycuptin hïgus jachapa yuran tsegllimunanpäna cagta. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tsaynömi cay ñacaycuna gallaptin gamcunapis tantiyayänayquina cutimunäpä cercana canganta. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cay ningäcuna gallaptin tsay tiempu runacuna manarä wanuyaptinmi llapanpis cumplinga. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ciëlu y cay patsa ushacäcuptinpis noga ningäcunaga llapanmi ruracanga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Fisyu final imay junag imay öra cananpä cagtaga manam musyayantsu ciëluchö caycag puëdeg angelcunapis ni nogapis. Tsaytaga musyaycan papänï Tayta Diosllam. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tsaynö caycaptinga gamcuna imaypis Tayta Diosman mañacullar caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Nogapa cutimuynëga canga juc wayiyog runa caru marcata aywacur cutingannömi. Tsay runa sirvegnincunata juc juc aruynincuna goycur y täpacogtapis patsätsipacuycur aywacurnin ¡imayrä wayinman cutinman! ");
INSERT INTO qxoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","¿Patsa tsacaytsurä o pullan pagastsurä o gällu cantay öratsurä o patsa warayrätsurä? Sirvegnincuna imay öra chänanpä cagta mana musyaycarninga imaypis wiyag wiyagchir caycäyanman. Tsaynö nogapa cutimuynï imay cananpä cagtapis mana musyaycarga gamcunapis wiya-wiyalla caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mana yarpashgata cutimur ¡pagtatä tariycäman Tayta Diosman mana yarpagta! ");
INSERT INTO qxoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gamcunata ningänöllam llapantapis willä: Imaypis Tayta Diosman mañacur listulla caycäyanqui cutimunäta shuyacur”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua fiesta semänachö levadüraynag tantata micuyänanpä ishcay junagllanam faltaycargan. Tsay fiestachö Jesusta yachay shimincunawan tsarisquir wanutsiyänanpämi willanacuyargan sacerdöticunapa mandagnincuna y ley yachatsicogcuna. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tsaynö willanacurpis waquincunaga niyargan: “Fiesta witsanga amarä imatapis rurashuntsu. Tsaychö tsaripacushgaga runacuna janantsicmanmi shayämunga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsay junag Jesusga Betania marcachömi “Leprösu” niyangan Simonpa wayinchö caycargan. Tsaychö merendaycäyaptinnam juc warmi chargan pasca rumipita frascuchö alläpa chaniyog mucuchag perjümin aptashga. Tsay perjümega cargan “nardu” ningan jachapitam. Tsaynam warmi frascupa shiminta paquisquir Jesuspa umanman tsay perjümita wiñapargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tsaynam tsaychö juc ishcay runacuna tsayta ricarnin ajar niyargan: “¡Imapärä tsayläya chaniyog perjümita cay warmi lluta jichan! ");
INSERT INTO qxoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tsay perjümipa chaninga runapa juc wata jornalninnöchäpis. Tsaytaga ¿manatsurä ranticushwan cargan faltapacogcunata yanapanapä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tsaynö niyaptinnam Jesus nirgan: “Ama payta ajäpäyaytsu. Nogapäga alläpa allitam rurashga. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Faltapacogcunataga munayangayqui öracuna yanapayanquiran. Peru nogataga mananam ricayämanquinatsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmega maypita shamungätapis musyarmi tsayläya chaniyog perjümita wiñapämashga. Pay tsaynö ruramanganwanmi pampayämänanpä listuna caycä. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Maychö tsaychöpis alli willacuynïta willacogcuna parlayangam cay warmi nogapä allita rurar umäman perjümita wiñapämangantaga”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tsaypitanam Jesuspa discïpulun Judas Iscariote sacerdöticunapa mandagnincunaman parlag aywargan caynö nir: “Jesus quiquillan caycangan öram regitsiyäshayqui prësu apacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tsaynö nisquiptinnam sacerdöticuna cushishga auniyargan gellëta pägayänanpä. Tsaypitaga Judas shuyacurnam gallaycurgan Jesus quiquillan caycangan öra regitsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Levadüraynag tantata micuyänan Pascua fiesta semäna gallaycunan junagnam cargan. Tsay junagga wata watam Israel runacuna carnishcunata pishtar micuyag. Tsaymi Jesustapis discïpuluncuna tapuyargan: “Taytay, ¿maychötä canan nogacuna Pascua merendata micunantsicpä puestucayämushä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsaynam ishcay discïpuluncunata Jesus nirgan: “Jerusalenpa aywayay. Tsayman charmi ricayanqui juc runata uylluwan yacuta apaycagta. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tsay runapa gepanta aywayanqui may wayiman changanyagpis. Tsay runa yaycuringan wayipa duëñunta niyanqui: ‘Señor Jesusmi tapucun: ¿Maygan cuartuyquichötäshi discïpuluncunawan canan Pascua merendata micuyanga?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tsaynö niyaptiqui wayiyognam ricatsiyäshunqui altuschö jatun cuartu nogantsicpä alistashgatana. Tsaychö listacäyämunqui micunantsicpä” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tsaynö niyaptinnam ishcan discïpuluncuna aywacuyargan Jerusalenman. Tsayman chärirnam Jesus ningannölla tariyargan llapantapis alistapacushgata. Tsaychönam discïpuluncuna Pascua merendata micuyänanpä listapacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tsaypita patsa tsacanaycaptinnam Jesus tsayman chargan chunca ishcay discïpuluncunawan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tsaynam mësachö micuycäyanganta Jesus nirgan: “Gamcuna caychö nogawan micuycagpita jucniquim chiquimagnïcunapa maquinman entregayämanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tsaynö niptin llapanpis wamayacurcuyarganmi. Tsaynam jucnin jucninpis niyargan: “Tsaynö captin ¿nogatsurä tsayta ruraycüman, taytay?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tsaynam Jesus nirgan: “Caychö jucniqui nogawan tsay matillachö tantata tullpur micuycag cagmi chiquimagnïcunapa maquinman entregamanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Noga Tayta Diospita shamogtaga Diospa palabran gellgaranganchö ningannöllam runacuna wanutsiyämanga. Peru allau ranticamagnï runa, ¡ima cuyapaypärä canga! Pay ama mejor yurinmantsu cargan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tsaynö nisquirnam micuycäyaptinna tantata aptarcur Jesus Tayta Diosman mañacur agradesicurgan. Nircurnam tantata paquirir discïpuluncunata macyargan caynö nir: “Cay tantata llapayqui micuyay. Cayga nogapa cuerpümi” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsaynömi väsuchö vïnuta aptarcurpis Tayta Diosman mañacur agradesicurgan. Nircur discïpuluncunata macyariptin llapancunam upuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tsaynam Jesus nirgan: “Cayga nogapa yawarnïmi. Noga yawarnïta jichar wanuptïmi Tayta Dios runacunawan mushog conträtuta ruranga nogaman criyicamog cagcunata jutsancunapita perdonananpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yapayga mananam vïnuta upushänatsu Tayta Diospa ñöpanchö gamcunawan mushog vïnuta upungäyag”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tsaynö nisquirnam juc alabanzata discïpuluncunawan cantacurir aywayargan Olivos jircanman. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tsaypita Olivos jircanman chärirnam Jesus nirgan: “Canan pagasmi llapayquicuna jagiriycamar geshpir aywacuyanqui. Tayta Diospa palabran gellgaranganchömi nin: ‘Üsha mitsicogta wanuscatsiyaptinmi üshancuna wacpa caypa mashtacar aywacuyanga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tsay cuentanömi nogata wanuscatsiyämaptin gamcuna wacpa caypa aywacuyanqui. Peru Tayta Dios cawaratsimaptinga Galileaman puntayquicunatam aywashä tsaychö tincunantsicpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tsaynö Jesus niptinnam Pedro nirgan: “Waquincuna jagiriycuyäshur aywacuyaptinpis nogaga manam dejashayquitsu, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tsaynam Jesus nirgan: “Pedro, canan pagasmi nogapä tapuyäshuptiqui quimsa cuti ‘Manam regïtsu’ nir ñëgamanqui gällu manarä ishcay cuti cantaptin”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tsaynö niptinnam Pedro nirgan: “Ishcantsicta wanutsimänantsic captinpis ¡manam ñëgashayquitsu, taytay!” nir. Pedro ningannöllam waquin cag discïpuluncunapis niyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsaypitanam Getsemani huertaman aywayargan. Tsaychönam discïpuluncunata Jesus nirgan: “Gamcunaga cayllachö jamaräcuycäyay. Nogana mas washaläman aywasquir Tayta Diosman mañacaramushä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tsaynö nisquirnam discïpuluncunata Pedruta, Santiaguta, y Juanta mas washaläman ricog pushargan. Tsaychönam pasaypa llaquinar paycunata nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Pasaypa tullücuna gotucarmi wanunayparä llaquicuy chaycamun. Gamcunapis Tayta Diosman mañacur cayllachö shuyaycäyämay”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tsaynö nisquirnam mas washaläman aywargan. Tsaychönam gonguricuycur umpuycur Tayta Diosman mañacurgan tsay alläpa ñacayta mana sufrinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tsaychö mañacurmi nirgan: “Papällay, gampäga manam imapis ajatsu. Cay ñacanäpä cagpita munarninga jipiycamay. Peru itsanga ama noga munangänöga catsuntsu. Gam munangayquinölla caycutsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsaynö mañacunganpita cutirnam quimsan discïpuluncuna punucashga caycagta tarir Pedruta nirgan: “¡Simon, punuycanquicu! Gamcunaga ¿manacu ni juc örallapis Tayta Diosman mañacuyta puëdiycuyarguyqui? ");
INSERT INTO qxoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ricchar Tayta Diosman mañacuyay Satanas jutsaman mana ishquitsiyäshunayquipä. Tayta Diosman mana mañacurga ningäcunata mana cäsumarmi jagiriycayämanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tsaypita yapay Jesus cutirpis puntata mañacungannöllam mañacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y discïpuluncunaman cutiycurnin yapaypis tarirgan pasaypa punuycäyagllatam. Discïpuluncunaga Jesusta ricaycur manam ima niytapis puëdiyargantsu pengacurnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tsaynam Jesus yapay Tayta Diosman mañacog aywargan. Tsaypita discïpuluncunaman cutiycurnam nirgan: “¿Jinallacu punucuyanqui? Cananga örä chämushganam noga Tayta Diospita shamogta jutsasapacunapa maquinman entregayämänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Sharcuyayna! Nogata ranticamag runaga yaycaycämunnam runancuna pushashga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tsaynö Jesus nicaptinnam discïpulun Judas Iscariote chargan, espädancunawan tucruncunawan atsca runancuna pushashga. Tsay runacunataga cachayargan sacerdöticunapa mandagnincuna, ley yachatsicogcuna, y waquin autoridäcunam. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tsayman chaycur Jesusta regiyänanpämi Judas caynö nir yachatsirgan: “Nogam saludagnin puntashä. Tsay mutsar saludangä cagmi canga prësuyänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tsay ningannömi Jesuspa ñöpanman Judas witiycur “Señorllä” nir cäranchö mutsaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsaynam Jesusta tsarir prësuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsaynö tsaripacuyaptin juc discïpulunnam ichic espädanta jipisquir sacerdöticunapa mandacogninpa sirvegninman aywar rinrinta jipicagpä walluscapurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tsaypita prësu apacuyaptinnam Jesus nirgan: “Gamcunaga ¿imanirtä espädayquicunawan tucruyquicunawan shayämunqui imayca ladrontanöpis prësuyämänayquipä? ");
INSERT INTO qxoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Runacunata yachatsirnin goyay goyaypis templuchö cargächä. Tsaychöga ¿imanirtä prësu tsariyämargayquitsu? Cananga Tayta Diospa palabran gellgaranganchö ningannöllam prësu apayämanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tsaynö nicaptinllanam Jesusta jagiriycur llapan discïpuluncuna aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Peru juc jövinga Jesusta gatirganmi tsacaypa wancurangan röpanllawan. Jinata runacuna tsariyaptinnam tsay jövinga wancuranganpita ullusquir jinaylla geshpir aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsaypitanam Jesusta chätsiyargan sacerdöticunapa mandacognin cagpa wayinman. Tsaymannam goricäyargan sacerdöticunapa mandagnincuna, ley yachatsicogcuna, y waquin autoridäcuna. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedroga Jesuspa caru gepallantam aywargan tsay wayi puncunyag. Tsaychö wardiyacunawanmi payga jamaycur ninachö mashacuycargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tsaychö Jesusta wanutsiyta munarninmi sacerdöticuna y waquin autoridäcuna ashiyargan runacunata Jesusta contrar parlayänanpä. Peru manam tariyargantsu ima mana alli ruraynintapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jesuspä manacagta runacuna parlarninpis jucläya jucläyata parlarmi quiquincuna pura ticrapunacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Waquincunaga llullacurmi Jesusta contrar niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nogacunam cay runa Dios tucur parlagta wiyayargö: ‘Cay runa rurangan templuta noga juchuscatsirmi quimsa junagllata sharcatsishä. Y noga rurangä temploga manam runa rurangannötsu canga’ negta”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tsaynö manacagcunata nirpis manam waquincuna parlayangannötsu niyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsaynam sacerdöticunapa mandacognin cag llapancunapa chöpincunapita sharcurcur Jesusta tapurgan: “¿Manacu imatapis ninqui tsaynö contrayqui parlayaptin? ¿Imaninquitä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tsaynö niptinpis Jesus mana imatapis contestayllapam upällalla cacurgan. Tsaynam tsay sacerdöti yapay tapurgan: “¿Gamcu Tayta Dios cachamungan salvacog canqui? ¿Gamchi Diospa tsurin canqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tsaynam itsanga Jesus nirgan: “Aumi, tsaynömi cä. Nogata gamcuna ricayämanqui Tayta Diospa derëcha cag lädunchö caycagtam y pucutay jananta ciëlupita shamuycagtam”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tsaynö niptinnam sacerdöticunapa mandacognin pasaypa ajarnin röpantapis rachisquirrä nirgan: “Cay runa tsaynö nicaptinga ¿imapänatä testïgucunatapis miñishtintsic? ");
INSERT INTO qxoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamcuna wiyayarguyquim cay runa Dios tucurnin tsaynö negta. Cananga ¿imaniyanquitä? ¿Wanutsishuncu o amacu?” nir. Tsaynam llapan runacuna juc shimilla niyargan: “¡Cay runaga Dios tucunganpita wanutsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tsaypitanam runacuna togapäyargan. Nircurmi ñawinta tsaparcur magar niyargan: “Dios caycarga mä, pï magashungayquitapis niyämay” nir. Y tsaynömi wardiyacunapis Jesusta cäranchö lagyar ushayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedroga ruri wayi puncunchömi caycargan. Tsaymanmi chargan mandacog sacerdötipa sirvegnin warmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Paymi Pedruta ninachö mashacuycagta ricaycur nirgan: “Gampis tagay Nazaret runa Jesuswan puregmi canqui, ¿au?” ");
INSERT INTO qxoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tsaynö niptinnam Pedro nirgan: “Tagay runataga manam noga regïtsu. ¿Imatarä nicamanquipis?” Tsaynö nisquirnam wagta puncuman yargusquirgan. Tsaychö caycaptinnam gällu cantasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tsaypita puncuchö Pedro shaycagta tsay warmi ricaycurnam waquincunata nirgan: “Tagay runaga Jesuswan puregmi”. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tsaynö niptin Pedroga yapaymi Jesuspä “Noga manam regïtsu” nirgan. Tsaypita rätun niragtanam tsaychö shaycag runacuna Pedruta niyargan: “Gamga rasunpaypa Jesuswan pureg Galilea runam canqui. ¡Tsay runacunanömi canquipis!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tsaynam Pedro jurar nirgan: “Tagay runata nogallä manam regicütsu. Payga ¿may runarä cacunpis?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tsaynö nisquillaptinnam yapay gällu cantasquirgan. Tsaynam Pedro yarpasquirgan Jesus caynö ninganta: “Gällu manarä ishcay cuti cantaptinmi quimsa cuti gam nogapä ‘Manam regïtsu’ nimanqui” nir. Tsay ninganta yarpasquirmi itsanga Pedro pasaypa llaquicur wagargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsaypita patsa waraycaptinnam sacerdöticunapa mandagnincuna, ley yachatsicogcuna, y waquin autoridäcuna, llapan puëdegcuna goricasquir willanacuyargan Jesusta wanutsiyänanpä. Tsaynö willanacurirnam Jesusta maquinpita watarcur mandacog Pilatuman apayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tsaychö Pilatunam Jesusta tapurgan: “¿Gamcu Israel runacunapa mandagnin rey canqui?” nir. Jesusnam nirgan: “Aumi, gam ningayquinömi cä”. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tsaynö niycuptin sacerdöticunapa mandagnincunaga leynincunapa contran cangantam niyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoga yapaymi tapurgan: “¿Manacu imatapis ninqui imaycata contrayqui niyaptin?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tsaychö Jesus imatapis mana parlacuptinnam Pilatoga pasaypa yarpachacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatoga yachacashganam wata wata Pascua fiesta semänachö runacuna mañayangantaga juc prësuta cachag. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jesusta prësuyänan witsanmi Barrabas jutiyog runa cumpinchincunawan carcelaraycäyargan. Paycunaga Roma nacionpa contran carmi wanutsipacushga cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pilato cagman atscag runacuna goricascärirmi mañayargan üsuncunaman juc prësuta cachaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tsaynam Pilato tapurgan: “Israelcuna, ¿reyniquicuna Jesustacu cachaycunäta munayanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato tsaynöga nirgan sacerdöticunapa mandagnincuna Jesusta chiquipar apayanganta musyarmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tsay sacerdöticunapa mandagnincuna runacunata yachatsiyashgana cayaptinnam llapancuna juc shimilla gayarar niyargan: “Ama Jesustaga cachaytsu. Barrabasta cachaycunayquitam munayäga” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tsaynö niyaptinnam Pilato nirgan: “Cay reyniquicunataga ¿imatatä rurashä?” ");
INSERT INTO qxoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Niptin runacunanam gayarar niyargan: “¡Payga cruzchö wanutsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tsaynam Pilato nirgan: “Wanunanpäga ¿ima mana allitatä rurashga?” Tsaynö niptin llapan runacunam masrä gayarar niyargan: “¡Cruzchö wanutsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsaynam Israel runacunawan Pilato allichö cayta munarnin Barrabasta cachasquirgan. Jesustanam alli cösa astascatsirnin, Roma soldäducunata cachapaycurgan cruzman clavar wanutsicuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tsaypitanam Jesusta Roma soldäducuna apayargan cuartel puncuman. Nircurnam tsayman llapan soldäducunata gayatsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tsaychönam Jesusta burlacur reypa puca mantuntanö agshutsiyargan y cashapita corönata umanman churapäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nircurnam Jesusta niyargan: “¡Vïva Israel runacunapa reynin!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tsaynö nirmi tucruwan umanchö wiruyargan y togapäyargan. Ñöpanman gonguricuycurmi adorag tucurnin burlacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tsaynö pasaypa munayanganta rurasquirmi tsay mantuta llogtiscatsir quiquinpa röpantana jatipäyargan. Nircurmi apayargan cruzchö wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tsaynö Jesusta cruzchö clavag apaycarnam tincuyargan juc runa Simon jutiyog chacranpita aywacuycagwan. Tsaynam payta obligar niyargan Jesus apaycangan cruzta apananpä. Tsay runaga caru Cirene marcapitam cargan, Alejandrupa y Rufupa papänin. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tsaypitanam “Golgota” ninganmanna Jesusta chäratsiyargan. (Golgota ninanga “calavëra sitiu” ninanmi.) ");
INSERT INTO qxoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tsaychönam vïnuman usuncätsicog jampi “mirra” ninganta wiñarcur Jesusta goyargan upunanpä. Peru payga manam upuyta munargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tsaypita cruzman Jesusta clavapacusquirnam röpanta soldäducuna sortiyayargan mayganpis gänag cag apacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesusta cruzman clavayanganga macyarcuy öranömi cargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Imapita wanutsiyanganta runacuna musyayänanpämi juc letrëruta cruzpa puntanman clavayargan caynö gellgarcur: “CAYGA ISRAEL RUNACUNAPA REYNINMI” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y Jesuspa lädunmannam ishcag ladroncunata cruzman clavayargan, jucta derëcha cag lädunman y juctana itsognin cag läduman. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tsaynö ruracanganwanmi cumplirgan Diospa palabran caynö gellgarangan: “Jutsasapacunawan iwalatsishgam canga salvacogga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tsay Golgotapa runacuna päsarmi cruzchö Jesus clavaraycagta ricarnin asipar niyargan: “¡Gamga ‘Templuta juchuscatsir, quimsa junagllatam sharcatsishä’ nirgayquichä! ");
INSERT INTO qxoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tsaynö puëdeg caycarninga, mä mana wanunayquipä cruzpita yarparamuy ari” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tsaynö burlacurninmi sacerdöticunapa mandagnincunapis ley yachatsicogcunapis quiquincuna pura ninacuyargan: “Juccunata salvananpä cagtaga nirganchä. Canan quiquinga ¿imanirtä salvacuyta puëdintsu? ");
INSERT INTO qxoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mandamagnintsic ciëlupita runa carninga, mä tsay cruzpita yarparamutsun. ¡Tsayta ricarninga criyishwanmi rasunpa Dios cachamunganta!” nir. Tsaynöllam läduncunachö clavaraycag ladroncunapis Jesusta burlacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tsaypitaga pullan junagpitam quimsa öra patsa tsacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tsay öram Jesus fuertipa gayarar nirgan: “Tayta Diosllä, Tayta Diosllä, ¿imanirtä nogata dejariycamarguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tsaynö niptinnam tsaychö runacuna niyargan: “¡Wiyayay! Tayta Diosta gayaycan unay willacognin profëta Eliasta cachamunanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tsaypita juc runanam cörrilla aywar gerupa puntanman esöputa watarcur upucuyänan ayag vïnuman tullpurgan. Nircurnam Jesusta shiminman churapargan shogunanpä. Tsaynö ruraptinnam waquin runacuna niyargan: “Mä, shuyäyay. Ricashun Elias shamungacush cruzpita jipinanpä” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsaypitanam Jesus fuertipa gayarasquir wanusquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tsay örallam templu rurinchöpis alli awashga jatun cortïna urayninpa ishcayman rachisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesus imanö wanunganta ricashga carnin soldäducunapa capitanninmi nirgan: “Rasunpam cay runaga Diospa tsurin cashga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tsaychö caycag juc ishcay warmicunapis carulällapitam ricaraycäyargan. Tsay warmicunaga cayargan Maria Magdalena, Salome, y Santiagupa Josepa mamancuna Maria. Santiagoga cargan Josepa gepa cag wauginmi. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tsay warmicunam Galilea marcacunachö Jesusta gatirar imaycancunallawanpis yanapayargan. Tsay warmicunawanmi atsca warmicunapis Jerusalenman shayämushga cayargan Jesusta gatirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesus wanurgan viernis tardim. Cada viernismi tardipaypaga Israel runacuna säbadu jamapay junagpä listacuyag. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tsay junag rupay jeganaycaptinnam juc runa Arimatea marcapita Jose jutiyog valoracuycur Pilatuman aywargan Jesuspa ayanta pampananpä negnin. Payga autoridä mayincunapita alli respitashga runam cargan. Tayta Diosman criyicog carmi shuyacurganna Tayta Dios aunicungannölla salvacogta cachamunanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tsaynö Jesuspa ayanta mañaptin Pilatoga quiquillanchömi yarpachacurgan: “¿Wanushganatsurä canman?” nirnin. Tsaynam soldäducunapa capitanninta gayascatsir tapurgan: “¿Jesusga wanushganacu?” ");
INSERT INTO qxoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Niptinnam capitanga “Wanushganam” nirgan. Tsaynam Pilato Jesuspa ayanta Jose pampacunanpä cachaparirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tsaypitanam Jose aywarnin jatun shumag lïnu säbanasta rantisquir Jesuspa ayanta cruzpita jipisquirnin wancurgan. Tsaynam gagachö uchcushga sepultüraman pampargan. Nircur sepultürapa puncuntanam jatun parara rumiwan tsapargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tsaychö Maria Magdalena y Josepa maman Maria ricayargan mayman Jesuspa ayanta pampayangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tsaypita säbadu jamapay junag päsasquiptinnam üsuncunaman Maria Magdalena, Salome, y Santiagupa maman Maria mucuchag perjümicunata rantiyargan Jesuspa ayanta shupayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tsaynö listapacusquir domingoga patsa warasquillaptinnam tsay warmicuna aywayargan Jesus pamparanganman. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tsayman paycuna yaycuraycarnam parlayargan: “Cananga ¿pirä sepultüra puncu tsaparag rumita wititsipaycamäshun?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tsaynam yaycuraycar ricaycuyänanpäga sepultüra tsaparag rumega wititsishgana caycänä. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sepultüra rurinman yaycusquirnam chaquinyag pasaypa yullag röpashga jövin derëcha cag läduchö jamaraycagta tariyargan. Tsayta ricaycurnam tsay warmicuna pasaypa mantsacäcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tsaynam tsay jövin nirgan: “Ama mantsacäyaytsu. Noga musyämi cruzchö wanutsiyangan Nazaret runa Jesusta ashiycäyangayquita. ¡Payga cawamushganam! Manam caychönatsu. Masqui ricaycuyay churarangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Canantä gamcuna aywar llapan discïpuluncunata Pedrutapis willayay. Paycunata ningannöllam Galileaman puntata Jesus aywanga tsaychö tincuyänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tsaynö jövin niptin warmicunaga mantsacaywan sicsicyarrämi sepultürapita yargur aywacuyargan. Tsaynö pasaypa mantsacaywanmi näni quinran tincuyangan runacunataga mana imatapis parlapäyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesusga cawarimurgan dominguman warämogmi. Tsay junagga patsa wärayllanam Maria Magdalenata yuripargan. Paypitam Jesus ganchis (7) supaycunata gargurgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tsaynam Maria discïpuluncunaman Jesus cawamunganta willacurnin chänanpäga pasaypa llaquicurnin wagaycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesus cawamunganta Maria willacuptinpis manam ichicllapis criyiyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsaypita tardipaypanam ishcag discïpuluncuna Jerusalenpita aywaycäyargan. Tsaynam paycunawan juntu Jesus aywargan tsay nänipa. Tsay discïpuluncunaga manam regiyargantsu Jesus canganta. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsaypita regircurmi itsanga waquin discïpuluncunaman aywar willacuyargan. Paycuna willacuyaptinpis discïpulu mayincunaga manam criyiyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsaypitanam chunca juc (11) discïpuluncuna juc wayichö micuycäyargan. Tsayman Jesus yuripasquirnam nirgan: “Yäracuyniynag runacuna, cawarimungäta ricamagcuna willayäshuptiquipis ¿manacu noga rasunpa cawamungäta criyicuyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tsaynö nisquirnam discïpuluncunata yätsir nirgan: “Maytsay marcacunapa aywarnin pita maytapis willacuyanqui: ‘Jutsa rurayniquicunata jagiriyaptiquega Tayta Dios perdonarmi salvayäshunqui’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipis criyicur bautizacurga salvacionta taringam. Mana criyicog cagmi itsanga infiernuman aywanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Llapan shonguncunawan criyicamogcunaga milagrucunatapis rurayangam. Tayta Diospa poderninwan supayyog runacunapitam supaycunata garguyanga. Mana parlayangan idiömacunatam parlayanga. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wanutsicog culebra caniptinpis manam wanuyangatsu. Venënuwanpis manam imanacäyangatsu. Geshyagcunaman maquincunata churarmi allïtsiyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Discïpuluncunata tsaynö yätsipasquiptinnam Señor Jesustaga Tayta Dios ciëlupa apacurgan. Nircurmi Tayta Dios derëcha cag lädunman jamatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tsaypita discïpuluncunaga maytsaypam aywayargan Jesus ningannö willacurnin. Tsaynö puriyaptin Tayta Dios yanaparganmi milagrucunata rurayänanpäpis. Tsaynö cayaptinmi runacuna Jesucristupa alli willacuynin rasunpa canganta musyayargan. Tsaynö catsun.");
INSERT INTO qxoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Noga Lucas cay libruta gellgä Jesucristo cawangantam. Jesucristo willacuyta gallaycunganpita patsam llapan rurangancunata apostolnincuna ricayargan. Tsay ricayangancunata willacuyänanpämi Jesus yätsirgan apostolnincunata. Paycuna willacuyaptinmi wiyagcuna Jesucristupäga juccuna juccunapis gellgayashga. Tsaymi nogapis cösa tapupacuycur mas alli cananta munar shumag yarpachacuycur cay libruta gellgä gallaycunganpita patsa imanö cangantapis. Tsaynöpam gampis, respitashga Teofilo, musyanqui willayäshungayquicuna rasun cag canganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Israel nacionchö Herodes mandacog rey caycänan witsanmi Zacarias jutiyog runa caycargan sacerdöti. Payga cargan Abias jutiyog sacerdötipa castanmi. Zacariaspa warminnam cargan Isabel. Paypa taytanpis sacerdötim cargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paycuna Tayta Dios mandangancunata cumplirmi imaypis allilla cawacuyag. Tsaymi pipis paycunapäga mana allitaga parlayagtsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isabel gollog captin wawan manam cargantsu. Ishcanpis rucu chacwannam cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tsaypitanam Zacariaspa y sacerdöti mayincunapa turnun chämuptinna Jerusalenman aywayargan templuchö Tayta Diosta sirviyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tsaychömi üsuncunaman sortiyayargan maygan sacerdötipis templuman inciensiu goshnitseg yaycunanpä. Tsaymi Zacariasta töcargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Templu rurinchö Zacarias inciensiuta goshnitsinganyagnam llapan runacuna Diosman mañacuycäyargan templupa patiunchö. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsaychö inciensiuta goshniycätsiptinmi altarpa derëcha cag lädunchö Tayta Dios cachamungan juc angel Zacariasta yuripasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tsaymi tsay angelta ricaycur Zacarias feyupa mantsacargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tsaynam angel caynö nirgan: “Zacarias, ama mantsacaytsu. Tayta Diosmi wiyashurguyqui rugacungayquita. Warmiqui Isabelmi geshyacunga ollgu wamrata. Paypa jutinmi canga Juan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tsuriqui yuriycuptinmi pasaypa cushicunqui. Gam cushicungayquinöllam llapan runacunapis cushicuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tayta Dios munangantam tsuriqui ruranga. Manam vïnuta ni ima shincatsicogcunatapis upungatsu”. “Manarä yuricurmi Espiritu Santuta chasquinga Diospa willacuyninta willacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tsaynö willacuptin Israel runacuna atscagmi jutsancunata jagirir Tayta Dios munangannöna cawayanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tayta Diospa munayninwan unay profëta Elias willacungannömi paypis willacunga. Y runacunatam yätsinga wayincunachöpis cuyanacur cawayänanpä. Mana cäsucogcunatapis willangam alli cawaymanna ticrayänanpä Tayta Dios munangannö. Tsaynöpam runacunata musyatsinga salvacog shamogta chasquicuyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angel tsaynö niptinnam Zacarias tapurgan: “¿Imanöpatä musyäman cay nimangayquicuna rasunpa canganta? Nogaga rucunam cä. Warmïpis chacwannam. Tsaynö caycaptinga ¿imanöpanatä tsurï canman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Niptinnam angel nirgan: “Tayta Diospa willacognin angel Gabrielmi cä. Paymi cachamashga cay alli willacuyta gamta willanäpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cay willaycangäcunaga llapanmi cumplinga. Ningäcunata mana criyimangayquipitam cananga mana parlanquirätsu tsuriqui yuringanyag” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Templupa patiunchö shuyaraycag runacunanam jucnin jucninpis niyargan: “¿Imanirtä cay örayag Zacarias yargamuntsu?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tsaypitanam templupita yargaraycämur shimin watpashga captin sëñasllapana tantiyatsirgan shuyaragnin runacunata. Tsaynam itsanga tantiyasquiyargan templu rurinchö imapis yuripanganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsaypita juc semäna templuchö ruraynincunata ushapacusquirnam wayinpana Zacariasga cuticurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Warmin Isabelnam geshyag ricacurna pitsga quillantin wayillanchö cacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tsaymi cushicurnin nirgan: “Tayta Diosmi nogata cuyapämashga. Cananpitaga runacuna mananam parlayämanganatsu ‘Mana wachacog gollog warmim payga’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Isabel geshyag ricacunganpita jogta quillatanam Tayta Dios cachamurgan angel Gabrielta virgen Mariaman. Tsay jipashga Galilea provincia Nazaret marcachömi tärargan. Mariaga aunishganam caycargan unay rey Davidpa castan Josewan casarayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tsayman chaycurmi angel nirgan: “¡Cushicuy, Maria! ¡Tayta Diospa cuyayninmi canqui!” ");
INSERT INTO qxoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsaynö niptinmi Maria mantsacashga yarpachacurgan: “¿Imanirtä tsaynö niman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tsaynam angel nirgan: “Maria, ama mantsariytsu. Tayta Diosmi gamta cuyashunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cananpitaga geshyagmi ricacunqui. Wawayquim yuringa ollgu. Paypa jutinmi canga Jesus. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Poderösu captinmi runacuna ‘Diospa tsurinmi’ niyanga. Paytam Tayta Dios churanga imaycawan munayyog cananpä, unay castan rey Davidtanö. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paypa munayninchömi gamcuna imayyagpis cayanqui. Pay munayyog canganga imayyagpis manam ushacangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsaynö angel niptinnam Maria tapurgan: “Runawan manarä juntacarga ¿imanöpatä geshyag ricacüman?” ");
INSERT INTO qxoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niptinmi angel nirgan: “Espiritu Santo gamman shamuptinmi Tayta Diospa poderninwan geshyag ricacunqui. Tsaymi wawayqui ‘Diospa tsurin’ gayashga canga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tsaynömi castayqui Isabelpis chacwanna caycar geshyacunga. Paytaga runacuna ‘Gollog warmim’ niyashgam. Cay quillawanga jogta quillanam geshyag ricacungan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tayta Diospäga manam imapis ajatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsaynam Maria nirgan: “Nogalläga Dioslläpa munayninchömi callä. Pay munangannö callätsun”. Tsaynö nisquiptinnam angel illacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Angel yuripanganpita waraynincunanam Maria alistacur aywargan Isabelman watucagnin. Zacariaswan Isabelga täräyargan Judea provinciapa jircan ricoglla marcachömi. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tsaynam wayincunaman chaycur Maria saludargan Isabelta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Saludariptinmi Isabelpa pachanchö wamra cuyurirgan. Tsaynam Espiritu Santo munangannölla Isabel cushicurnin nirgan: “¡Bendïtam canqui! Llapan warmicunapitam Tayta Dios gamta acrashurguyqui. Geshyag caycangayqui wawayquipä Tayta Dios imanömi cushicun. ¡Paypis bendïtum! ");
INSERT INTO qxoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Imaläyam cushicuycü Dioslläpa maman watucaycamangayquita. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludamangayquita mayasquir pachächö caycag wawäpis cushicur cuyushgam. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Cushicuy! Tayta Diospa angelnin nishungayquicunaga llapanmi cumplinga. Payta criyicungayquipitam cushishga cawanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsaynam Maria nirgan: “Llapan shongulläwanmi Tayta Diosta alabaycullä. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cuyapäcog Tayta Dios juc salvacogta cachamunanpä cagtam cushicü. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Llänu shonguyog cangätam Tayta Dios ricamashga. Cananpitaga llapan runacunapis mana gongaypam yarparaycäyangalla nogapä allita ruranganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Poderösu Tayta Diosmi nogapä rurashga alläpa allicunata. Paynöga manam pipis cantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tayta Dios imaypis cuyapanmi munanganta ruragcunataga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pipis mana rurangancunatam poderninwan ruranga. Puëdeg tucogcuna yarpäyangancunataga manacagmanmi churanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandacogcunatam mandacuyninpita gargunga. Llänu shonguyogcunatanam yanapanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Muchuychö cagcunatam imaycanpis faltätsingatsu. Mana cuyapäcog rïcucunatanam itsanga gechurnin imaycantapis ushacätsinga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israel runacunata cuyaparmi yarparaycangalla yanapananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tsaynö imayyagpis cuyapänanpämi aunirgan unay Abrahamta y paypita miragcunatapis”. Tsaynö nirmi Tayta Diosta Maria alabargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Isabel cagchö quimsa quillanö tärarcurnam wayinpana Maria cuticurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsaypitanam Isabelpa quillan tincusquiptin geshyacurgan ollgu wamrata. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tsayta musyaycur castancunapis y reginacungancunapis alläpam cushicuyargan Tayta Dios paypä allita ruranganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tsaypita semänayogna wamra caycaptinnam Zacariaspa wayinman castancuna aywayargan tsay wamranta üsuncunaman señalayänanpä. Tsaychömi taytanpa jutinllata churayta munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tsaynam maman nirgan: “¡Manam tsaynö jutin canmantsu! Juan catsun jutinga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Isabel tsaynö niptinmi waquin runacuna niyargan: “Manam pipis cantsu castayquicunachö tsay jutiyogga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsaypitanam ima jutinta churayänanpäpis sëñasllapa Zacariasta tapuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tsaynö tapuyaptinnam pay mañargan juc tacshalla tablata tsaychö gellgananpä. Nircurnam gellgargan: “Juanmi jutinga canga” nir. Zacariaspis tsurinpa jutin Juan cananta munaptinmi tsaychö caycag runacunaga espantacuywan ricaraycar quëdasquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tsaypita jinan öra Zacariaspa shimin pashtasquiptinmi Tayta Diosta alabargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsaycunata ricarnam tsaychö llapancunapis cushicuyargan. Tsaycuna päsangantanam pipis maypis parlayargan tsay entëru marcacunachö. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tsayta wiyagcunaga yarpachacuyargan: “¡Cay wamra wiñarcur ima allirä caycunga!” nirninmi. Y runacuna parlayangannöllam tsay wamrata Tayta Dios shumag yanapargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tsaynam Espiritu Santo parlatsiptin Zacarias nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tayta Dios alabashga catsun. Payga salvamänantsicpänam caycan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mandu ruragnin rey Davidpa castancunapita munayyog salvacogmi yuringa. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tsaynö cananpämi unay profëtancunawan musyatsimargantsic. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tsaynöllam musyatsimargantsic chiquimagnintsiccunapita jipimänantsicpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Abrahamta y paypita miragnincunatapis auningancunata manam gongashgatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Paytam Tayta Dios aunirgan ");
INSERT INTO qxoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chiquimagnintsiccunapa mandunpita jipimänantsicpä, Tayta Dios munangantana mana mantsariypa ruranantsicpä, ");
INSERT INTO qxoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y cada junagpis munanganta rurarna cawanantsicpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tsaypita wamranta margacurcurnam Zacarias nirgan: “Gam llullu wamra, salvacogta chasquicuyänanpä willacuptiquim runacuna musyayanga Diospa willacognin profëta cangayquita. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gammi tantiyatsinqui jutsancunapita Tayta Dios perdonar runacunata salvananpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Runacunata cuyaparmi Tayta Dios salvacogta cachamunga. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsaymi salvacog shamur tsacaychönö cawagcunata tantiyatsinga jutsancunata jagirir allina cawayänanpä”. Tsaynömi Zacarias nirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tsaypita wamraga wiñayllantam yachacurgan Tayta Dios munangannö cawayta. Tsunyag jircacunallachömi täcurgan Israel runacunata Diospa willacuyninta willapayta gallaycunganyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Juan Bautista yuricunan witsanmi Cesar Augusto emperador car mandangan cag nacioncunachö llapan runacuna censucuyänanpä nirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tsay censucuy witsanga Cirenio jutiyog runam Siria provinciachö mandacog caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tsaynam llapan runacuna marcancunaman aywayargan yuricuyanganchö censucuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Tsaymi Mariawan Josepis Galilea provincia Nazaret marcapita Judea provincia Belen marcaman aywayargan censucuyänanpä. Tsayman aywayargan Josepa unay castan rey David tsay marcachö yuricushga captinmi. Tsay junagcuna Mariapaga quillan tincushganam caycargan geshyacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belenchö caycäyaptinnam Mariapa öranna captin pachanna tsarisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Belenman censucog aywagcuna pasaypa quichquishga cayaptinmi posädacuyänanpä wayita mana tarir geshyacuycurgan llullu wawanta ashmacuna punucuyänan ramädallachö. Tsaychö inchanawan piturcurnam tsayllaman punuycatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belen marcapa ñöpan ricogchömi üsha mitsicogcuna täpaycäyargan üshancunata. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsaymanmi Tayta Diospa angelnin chipipirrä yuripasquirgan. Üsha täpagcunaga pasaypam mantsacaycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tsaynam angel nirgan: “Ama mantsacäyaytsu. Gamcunapä alli willacuytam apamurgö. Tsayta wiyarmi llapan runacuna cushicuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tayta Dios cachamungan salvacogmi unay rey Davidpa marcanchö yuricushga. Paymi runacunata salvanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Paytam tariyanqui ashmacuna punucuyänan ramädallachö inchashga caycagta. Tsaytanö tarirmi cay nicangä rasun canganta musyayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tsaynö parlapaycaptinmi tsay angelpa ñöpanchö atsca angelcunana yurisquiyargan Tayta Diosta caynö alabarnin: ");
INSERT INTO qxoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Ciëluchö caycag Tayta Dios adorashga catsun! ¡Cay patsachöpis Tayta Diosta adoragcunapä alli caway catsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tsaypita angelcuna ciëluman cutisquiyaptinnam üsha täpagcuna jucnin jucninpis caynö ninacuyargan: “Tayta Dios willacaycätsimuptinga acu, acu aywashun Belenman ima päsangantapis ricanantsicpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tsaynö nirmi llapancuna empëñu aywayargan. Belenman chaycurnam tariyargan Joseta, Mariata, y llulluntapis ashmacuna punucuyänan ramädallachö. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chaycur mitsicogcunaga willacuyargan angel yuripasquir llullupä willangancunatam. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tsaynö willacuyaptinmi tsaychö caycagcuna cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaga tsaycuna päsangancunata shongunllachömi yarparargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsay mitsicogcuna angel willangannölla llulluta ricaycurnam Tayta Diosta agradesicurnin alabar cuticuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tsaypita wamra semänayog caycaptinnam üsuncunaman llulluta señalayargan. Jutinmi churayargan Jesusta, Mariata angel yuripar ningannölla. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria geshyacunganpita chuscu chunca (40) junagtanam Josewan aywayargan Jerusalenman. Chaycurnam templuman llulluta apayargan Tayta Diospa munayninman entregayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tsaycunata cumpliyargan Moises gellganganchö ningannöllam. Tsaychömi nican: “Tayta Diospa munayninman churayay mayor cag ollgu wamrayquicunata” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Warmicuna geshyacuyanganpita ofrendata apayänanpä caynömi Moises gellgargan: “Ishcay cullcushta o ishcay pushapa palumacunata apayanqui” nir. Tsayta cumplirmi Mariapis apargan templuman. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Tsay witsancunam Jerusalenchö täcurgan Simeon jutiyog juc runa. Payga alli rurag carmi Tayta Diosta alabar cawargan. Paytam Espiritu Santo musyatsirgan salvacogta ricaycurrä wanucunanpä cagta. Tsay runam shuyacurgan Israel runacuna ñacayanganpita salvacog shamur jipinanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Tsaymi Simeonta Espiritu Santo templuman pushaptin tsaychö ricargan Mariawan Jose llulluta apaycäyagta. Paycunaga aywayargan Moises gellgangan leyta cumplirninmi. Tsaynam llulluta margarcur Tayta Diosta alabar nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tayta Diosllä, cananga cumplirguyquinam nimangayquita. Cananga ricargönam cachamungayqui salvacogta. Ricangächönaga cushishgana wanuculläshä. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Maytsaychöpis runacuna musyayangam cay salvacogta gam cachamungayquita. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tsaymi mana Israel runacunapis tantiyacuyanga salvanayquipä cagta. Tsaynö captinmi gamta alabayäshunqui ‘¡Ima allirä Israel runacunata Tayta Dios acrargan tsay castachö salvacognintsic yurinanpä!’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon tsaynö ningancunata wiyarmi Josewan Maria yarpachacuyman churacäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tsaynam Simeon Tayta Diosman mañacurgan paycunata yanapaycunanpä. Nircur Mariatanam nirgan: “Cay wawayquiman criyicuyanganpitam waquin Israel marca mayintsiccunapis salvacionta tariyanga. Payman mana criyicog cagcunaga infiernumanmi aywayanga. Cay llullu jövinyarnam Tayta Diospa willacuyninta parlaptin atsca runacuna chiquiyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tsaynöpam wawayquiman criyicuyanganpis o mana criyicuyanganpis musyacanga. Tsaycuna päsaptinmi gampa shonguyqui tucsiycushganörä nananga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tsay junagcunaga templuchömi caycargan Diospa willacognin profëta Ana jutiyog chacwanpis. Paypa taytanga cargan Fanuel jutiyog runam, y Aser castapitam cargan. Payga jipashllam runawan casaracurgan. Casacunganpita ganchis (7) watallatam runan wanurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tsaymi viüdalla cacurgan puwag chunca chuscu (84) wata. Payga templupita imaypis mana yarguypam pagasta junagta Tayta Diosta sirvir täcurgan. Tsaynöpis ayunarmi Tayta Diosman mañacog. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tsaychö Simeonwan Maria y Jose parlaycäyaptinnam Anapis llulluman witiycur Tayta Diosta agradesicurgan. Nircurnam runacunata willapargan ñïñu Jesus salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tsaypitanam Tayta Dios mandacungancunata templuchö cumplisquirnin Josewan Maria cuticuyargan Galilea provincia Nazaret marcanman. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tayta Dios yanapaptinmi wiñayllanta ñïñu Jesusga mas yachagna y callpayogna ticrargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa papäninwan mamanga cada watam Jerusalenman aywayag Pascua fiestaman päsag. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus chunca ishcay (12) watayogna caycaptinmi paywanpis aywayargan tsay fiestaman. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tsaypita fiesta ushaynam Josewan Maria cuticuyargan marcancunapana. Jerusalenchö Jesus quëdangantaga manam cuentata gocuyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Paycunaga waquin runacunawan Jesus aywaycanganta yarparmi juc junagta aywaycäyangantarä watucasquir ashiyargan. Castancunata reginacungancunata tapupacurpis manam tariyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Manana tarirmi cutiyargan Jerusalenman ashirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chäyanganpita warayninrämi Jesusta tariyargan templuchö yachag runacunapa chöpincunachö jamaraycagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tsaychömi wiyagcunapis cushicuyargan tsay runacunawan pasaypa yachag cayninwan parlapänacunganpita. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tsaynam tsaychö tariycur mamancuna pasaypa cushicuyargan. Tsaynam maman nirgan: “Waway, ¿imanirtä caychö quëdacurgayqui? Nogacuna pasaypa llaquirniquim ashiycuyargö” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tsaynam Jesus nirgan: “Mamay, ¿imanirtä ashiyämar tantiyayarguyquitsu cay templuchö caycangäta? ¿Manacu musyayanqui papänï Tayta Diospa ruraynincunatarä cumplinäpä cagta?” ");
INSERT INTO qxoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tsaynö niptin paycunaga manam imapä nicangantapis tantiyayargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsaypitanam cuticuyargan Nazaretman. Tsaychömi taytanwan maman mandangancunata Jesus rurargan. Mamannam shongullanchö yarparargan llapan ima päsangancunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Wiñayllanta Jesus imaycapä yarpayyog ticraptinmi Tayta Diospis y runacunapis cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zacariaspa tsurin Juan tsunyag jircachö caycaptinmi Tayta Dios nirgan willacuyninta willacunanpä. Tsay witsanmi Tiberio Cesar chunca pitsga (15) watana Roma nacionchö maytsay nacioncunapa mandagnin caycargan. Paymi Poncio Pilatutapis churargan Judea provinciachö mandacog cananpä. Herodestanam mandacog churargan Galilea provinciaman. Herodespa waugin Felipitanam mandag churargan “Iturea” y “Traconite” ningan provinciacunaman. Tsaynömi Lisaniastapis mandacog churargan Abilinia provinciaman. Jerusalenchönam Anaswan Caifas llapan sacerdöticunapa mandagnin caycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsaymi Jordan mayu cuchun quinran marcacunapa Juan purirgan caynö willacurnin: “Jutsayquicunata jagirirnin bautizacuyay. Tsaynöpam Tayta Dios perdonayäshunqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan tsaynö willacunanpämi Diospa willacognin profëta Isaias caynö gellgargan: “Tsunyagcunachö purirmi juc runa caynö gayarar willacunga: ‘Tayta Dios cachamungan salvacog runa chämuptin chasquicuyänayquipä jutsayquicunata dejariyay. Mana alli rurayniquicunapita yarpachacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tsaynö rurayay ragra nänicunata pampatsagnö, jirca nänicunata, wicsu nänicunata, y shalla nänicunata allitsagnöpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tsaynö listacushmanna Tayta Dios salvacogta cachamuptin llapan runacunam musyayanga’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tsaynö Juan willacuptin runacuna bautizacuyänanpä aywagcunata caynömi nirgan: “¡Culebra casta runacuna! ¿Gamcunaga ‘Bautizacuyangällawanmi salvacuyäshä Diospa castïgunpita’ niyanquipischi? ");
INSERT INTO qxoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tayta Dios infiernuman mana gaycuyäshunayquipä jutsa rurayniquicunata jagirir pay munanganta rurarna cawayay. Ama yarpäyaytsu: ‘Unay Abraham casta cayangäpitam Tayta Dios salvamanga’ nir. Tayta Dios munarga Abraham casta runacunaman cay rumicunatapis ticrascäratsinmanmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mana alli wayog jachacunata cuchupita muturir ninaman gaycognö jutsa rurag runacunata infiernuman Tayta Dios gaycunanpä listunam caycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juan tsaynö niptinnam runacuna tapuyargan: “Tsayöraga ¿imatatä rurayäman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tsaynö niyaptinmi nirgan: “Ishcay trocanayquicuna capuyäshuptiquega goycuyanqui mana capog cagcunata. Tsaynölla lasag micuyniquicuna capuyäshuptiquega raquipaycuyanqui faltapacog cagta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Niptin tsaynöllam impuestuta cobragcunapis, bautizacuyänanpä aywar tapuyargan: “Taytay, nogacunaga ¿imatatä rurayäman?” ");
INSERT INTO qxoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tsaynam Juan nirgan: “Cobrayänayquipä cagllata cobrayanqui. Ama sacyacog cayanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tsaynöllam tapuyargan soldäducunapis: “Nogacunaga ¿imatatä rurayäman?” Niyaptinnam Juan nirgan: “Ama pipa gellënintapis o imantapis puëdeg tucur gechuyanquitsu. Tsaynölla runa mayiquicunata ama manacagtaga tumpayanquitsu. Pägayäshungayquillawan conformacuyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tsaychö runacunaga salvacog cay patsaman shamunanpä cagta musyarnam yarpachacuyargan: “¿Juantsurä Tayta Dios cachamungan salvacog canman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tsaymi ñöpancunachö caycag runacunata Juan nirgan: “Nogaga yacullawanmi gamcunata bautizaycä. Tayta Dios cachamungan salvacog shamogmi itsanga Espiritu Santuwan chasquicogcunata bautizanga. Mana chasquicogcunataga infiernumanmi gaycunga. Tsaynö captin salvacogmanga ni ichicllapis manam nogaga iwalätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Payga trïguta wayrananpä juc runa jurquitan aptashganönam caycan. Trïguta wayrarnin päjantaga ninamanmi gaycun y trïguntanam wayinman apacun. Tsaynömi Tayta Dios cachamungan runa jutsa ruragcunata imaypis mana upeg ninaman gaycunga y Tayta Dios munanganman cawagcunatam gloriaman apacunga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tsaynö parlaparmi Juan runacunata tucuynöpa tantiyatsirgan Diospa willacuyninta. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nircurnam llapan runacunachö Juan nirgan: “Herodesga waugin Felipipa warminta gechurnin y llapan jutsata rurarnin manam allitatsu ruraycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tsaynö ninganta musyaycurmi ajarnin Juanta Herodes prësutsir carcelman wichgayänanpä mandargan. Tsaynö wichgatsir mas jutsayognam ricacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Carcelman Juanta manarä wichgayaptinmi runacunata bautizaycaptin Jesuspis chargan bautizacunanpä. Tsaychö bautizacusquir Jesus Tayta Diosman mañacuycaptinmi ciëlu quichacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tsaypitam Jesusman Espiritu Santo urämurgan imayca palumanö. Y Tayta Diosmi ciëlupita caynö nimurgan: “Gammi cuyay tsurillä canqui. Noga munangänö llapantapis ruraptiqui alläpam cushicü” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesusga bautizacurgan quimsa chunca (30) watayognam. Tsaypitanam Diospa willacuyninta willacur gallaycurgan. Jesuspäga runacuna yarpäyargan Josepa tsurin cangantam. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elinash canä Matatpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josenash canä Matatiaspa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagainash canä Maatpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judanash canä Joananpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerinash canä Melquipa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ernash canä Josuepa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatnash canä Levipa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimnash canä Meleapa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natannash canä Davidpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasonnash canä Aminadabpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judanash canä Jacobpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacornash canä Serugpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salanash canä Cainanpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecnash canä Matusalenpa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainannash canä Enospa tsurin. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus Jordan mayuchö bautizacusquirga Espiritu Santupa munayninchönam ricacusquirgan. Tsaypita Espiritu Santo pushaptinnam tsunyag jircaman aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tsaychö chuscu chunca (40) junag imatapis mana micuypam cacurgan. Tsaynö caycangantanam pasaypa mallagacuycurgan. Tsaychömi Satanas engañayta munar Jesusta nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","“Diospa tsurin caycarga mä, cay rumita tantaman ticraratsiy”. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tsaynö niptinnam Jesus nirgan: “Diospa palabran gellgaranganchö caynömi nican: ‘Manam micungallanwantsu runacuna cawayan, sinöga Dios ningancunata cäsucuyanganwanpis allimi cawayan’ ” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsaypitanam Satanas juc altuman wap jayarircur ricascäratsirgan maytsay marcacuna pasaypa chipipegtarä. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nircurmi nirgan: “Cay ricaycangayqui imaläya shumag marcacunam. Cay llapan ricaycangayquicunata entregayämargan munangä cagta pitapis goycunäpämi. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gam ñöpäman gonguricuycur nogata adoramaptiquega gamllatana llapantapis goycushayqui munayniquichöna tsaräcunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tsaynam Jesus nirgan: “Diospa palabran gellgaranganchöga caynömi nican: ‘Tayta Diosllatam adoranayqui y payllantam sirvinayqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tsaypitanam wap Jerusalenman apasquir templu jananchöna Jesusta Satanas ricascatsirgan. Nircurmi nirgan: “Diospa tsurin rasunpaypa carga mä, caypita patsaman jegarpuy. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diospa palabran gellgaranganchöga caynöchä nin: ‘Gamta cuïdashunayquipä angelnincunatam Dios cachamunga. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Paycunam tsariyäshunqui patsaman jegaptiquipis rumicunachö mana tacacunayquipä’ ” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Niptin Jesusnam nirgan: “Diospa palabran gellgaranganchöga caynöpis ninmi: ‘Ama Tayta Dios ningancunata manacagman churayta yarpaytsu munangayquita ruranayquipä’ ” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tsaynam engañayta mana puëdircur juc tiempupä yarparaycar witicurirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tsaypitam Espiritu Santupa munayninwanna Jesus cuticurgan Galilea provinciaman. Tsay marcacunachö runacuna pasaypanam parlayargan alli yachatsicog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tsay marcacunapa Tayta Diosman mañacur goricäcuyänan wayicunachömi Jesus yachatsicurgan. Tsaynam runacuna alabarnin niyargan: “Payga alläpa allim yachatsicuycun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsaypitanam Jesus aywargan quiquinpa marcan Nazaretmanna. Payga imaypis yaycungannömi säbadu jamapay junagchö yaycurgan Tayta Diosman mañacur goricäcuyänan wayiman. Tsaychönam llapancunapa puntanman aywargan Diospa palabranta liyimunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsaychö liyimunanpämi unay profëta Isaias gellganganta macyayargan. Tsaytanam quichasquir liyirgan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Espiritu Santupa munayninchömi caycä. Tayta Diosmi acramashga pobri runacunata alli willacuyninta willapänäpä. Tsaynömi cachamashga runacunata jutsancunapita jipinäpä, gapracunapa ñawinta allïtsinäpä, y mana alli cawaypita alli cawayman jipinäpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tsaynö Tayta Dios cachamashga willacungäpita runacuna salvacionta tariyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsaynö liyisquirnam Jesus cutiycatsirgan goricäcuyänan wayichö cuïdacog runata. Cutiycatsir jamacuriptinnam tsaychö caycag llapan runacuna payta pasaypa ricaräyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsaymi Jesus nirgan: “Tsay liyimungächö noga ruranäpä cagcunanam gellgaraycan. Tsaychö gellgarangannöllam cumpliycangäta gamcuna ricaycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tsaynö niptinmi llapan runacuna Jesuspä espantar parlayargan: “¿Imatatä pay musyan tsaynö parlananpä? ¿Cayga manacu Josepa tsurinlla?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsaynam Jesus nirgan: “Gamcuna yarpaycäyanquim: ‘Caynö niyämaytapis mä, Capernaum marcachöpis milagrucunata rurashga caycarga marcantsicchöpis milagrucunata ruramutsun’ nir. Y tsaynöllam yarpaycäyanqui runacuna parlayangannölla caynö niyämaytapis: ‘Jampicog carga quiquinrä jampicutsun’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nircurmi nirgan: “Juclä marcacunachöga Tayta Diospa willacognin profëtata chasquicuyanmi. Peru quiquinpa marcanchöga manam cäsupäyantsu. Tsaynö mana chasquicayämaptiquim milagrucunatapis rurashätsu cay marcäcunachöga. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Yarpäyay Diospa willacognin Elias cawanan witsan imanö päsangantapis. Quimsa wata jogta quilla mana tamyaptin llapan marcacunachö pasaypa muchuyta päsayänä. Tsay witsan Israel nacionchö atsca viüdacuna ñacar cayaptinpis Tayta Dios manam cachanätsu Elias yanapananpä maygan viüdatapis. Tsaypa rantinga cachanä juclä Sidon nacionchö ‘Sarepta’ ningan marcallamanmi, tsaychö juc viüdata yanapananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tsaynömi Diospa willacognin Eliseo cawanan witsanpis Israel nacionchö atscag lepra geshyawan geshyagcuna cayänä. Tsay geshyawan atscag geshyaycäyaptinpis Eliseo manash allïtsinätsu maygantapis. Juclä Siria nacionpita juc runa Naaman jutiyogllatam allïtsinä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tsaynam Jesus tsaynö ninganta wiyaycur tsaychö caycag runacuna cuentata gocusquiyargan juclä chiquishga runacunarä Tayta Diosman mas yäracog cayanganta. Tsaymi pasaypa rabyanäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsaynö rabyanarnam marcapita jipisquir Jesusta apayargan gagapa quillunninman tsaypita cumariycuyänanpä. Paycunapa marcanga cargan tsay gaga jananchömi. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tsaychö cumariycuyta munayaptinpis runacunapa chöpinpita yargurirmi Jesus aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsaypitanam Galilea provinciachö Capernaum marcaman Jesus aywargan. Tsaychömi cada säbadu jamapay junagchö runacunata yachatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pipis pay yachatsicungannö shumag mana yachatsiptinmi runacuna cushicur niyargan: “Parlamungantaga cumplishunmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tsay goricäcuyänan wayichömi caycargan supay löcuyätsingan runa. Paymi gayarar nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¡Jesus Nazaret runa! ¿Imatatä munanqui nogacunawan? ¿Nogacunaman shamurguyqui ushacätsiyämänayquipäcu? ¡Noga regïmi Diospa tsurin salvacog cangayquita!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsaynö niptinmi Jesus supayta nirgan: “¡Upälla supay, yargucuy cay runapita!” nir. Tsaynö niycuptin llapan runacunapa ñöpanchö tsay runata tapsiriycurmi supay aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tsaynam runacuna jucnin jucninpis ninacuyargan: “Manam imaypis wiyarguntsictsu cay runa yachatsicungantanöga. ¡Payga ima puëdegnarä! ¡Supaycunapis cäsuyänächä!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Supayta gargunganta mayarnam tsay quinran marcacunachö runacuna parlayargan Jesus alläpa poderyog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsaypitanam goricäcuyänan wayipita Jesus aywargan Pedrupa wayinman. Tsay wayiman chaycunanpäga Pedrupa suegranmi ujuraycargan pasaypa antsa achacharnin. Tsaymi tsaychö caycag runacuna Jesusta rugacuyargan payta allïtsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tsaynam Jesus tsay geshyaycag warmiman witiycur nirgan geshya yargucunanpä. Niycuptin jinan öram allisquirgan. Tsay warminam sharcurcur tsaychö caycag runacunata juclla micuynincuna garargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsaypita rupay ullunaycaptinnam Jesusman apayämurgan imaycaläya geshyawan geshyaycagcunata. Tsay geshyagcunata yataycuptinmi llapanpis alliscäriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tsaynömi atscag geshyagcunapitapis supaycuna yarguyargan caynö gayararnin: “¡Gamga Diospa tsurinmi canqui!” nir. Tsaynö supaycuna niyaptin Jesusga manam munargantsu paypita imata parlarcuyänantapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsaypita patsa warasquiptinnam tsay marcapita Jesus aywargan tsunyag jircaman. Tsaymanpis runacunaga ashirnin chäyarganmi. Tsaychö tariycurnam rugacuyargan paycunapita mana aywacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tsaymi Jesus nirgan: “Waquin marcacunachöpis Diospa willacuyninta willacunärämi caycan. Tsaypämi nogata Tayta Dios cachamashga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsaynömi ari Jesusga maytsay Israel marcacunapa purir goricäcuyänan wayicunachö willacurgan Diospa alli willacuyninta. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Genesaret gocha cuchunchö Jesus caycaptinnam quichquiypa runacuna goricäyargan Diospa willacuyninta wiyayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tsay gocha cuchunchömi Jesus ricasquirgan ishcay büquicuna caycagta. Pescag runacunanaga büquincunapita yargurirmi mällancunata awiycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsaychö pasaypa atsca runacuna quichquiparäyaptinnam Pedrupa cag büquinman Jesus yarcurcur rugacurgan cuchunchö büqui caycagta mas chöpin niragman witircatsiyänanpä. Tsaynam tsay büquiman jamaycur tsaypitana runacunata yachatsicamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachatsiyta ushasquirnam Pedruta nirgan: “Cananga büquiquita apayay mas chöpin niragman. Nircur tsaychö jitayay mällayquicunata pescäducunata tsariyämunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tsaynö niptinnam Pedro nirgan: “Taytay, canan pagas warat pescaycarpis manachä ni jucllayllatapis tsariycuyargötsu. Gam niyämaptiquega mälläcunata mä, yapay jitayäshä ari”. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tsaynö nirmi mällancunata shumag mashtaycur pasaypa atscata pescäducunata tsariyämurgan, mällancunapis rachinäyanganyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsaynam jucag büquichö pescag mayincunata gemllar gayacuyargan jipïshir yanapayänanpä. Paycuna aywarnam ishcan büquincunaman pescäducunata raquiyargan büquincunapis jundinanganyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Tsaychömi caycargan Zebedeupa tsurincuna Santiaguwan Juanpis. Paycunaga cayargan Pedrupa pescag mayincunam. Pasaypa atsca pescäducunata tsariycurmi llapancunapis espantacur mantsacäcuyargan. Tsaymi Simon Pedro Jesuspa ñöpanman gonguricuycur nirgan: “Nogaga jutsasapa runam callä, taytay. Manam gampa ñöpayquichö cayta merëcillätsu” nir. Niptinnam Jesus nirgan: “Tsayta ama mantsariytsu. Cananpita pescäduta tsariyänayquipa rantinga Diospa alli willacuyninta runacunatanam willapäcayämunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tsaynö niptinmi gocha cuchunchö büquincunata y imaycancunatapis jagiriycurnin Jesuswan aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Juc cuti Jesus juc marcachö caycaptinnam chargan leprawan geshyacog juc runa. Tsay runam Jesuspa ñöpanman gonguricuycur nirgan: “Taytay, cay geshyäpita alliycatsillämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsaynö niptinnam Jesus yataycurgan “Cananpita gam allirguyquinam” nirnin. Tsaynö nir yataycuptinmi tsay runapita jinan öra tsay lepra geshyan illacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nircurnam Jesus nirgan: “Ama pitapis willapanquitsu noga allïtsingäta. Cananga templuman aywacuy unay Moises gellgangan leychö ningannö ofrendata apacurcur. Tsaychö sacerdöti ricaycushurniquim awicashgana cangayquita musyatsicamunga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tsaynö Jesus imayca milagru ruraynincuna musyacänanta mana munaycaptinpis maytsaychömi masna musyacargan. Tsaynam mas atscana goricäyargan yachatsingancunata wiyayänanpä y geshyancunapita alliyätsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesusga tsunyagcunaman aywaycurmi Tayta Diosmanga imaypis mañacog. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc wayichömi Jesus runacunata yachaycätsirgan. Tsaychömi jamaraycäyargan fariseucuna y Moises gellgangan ley yachatsicogcuna. Paycunaga shayämushga cayänä Galilea provinciapa maytsay marcancunapita, Judea provinciapita y Jerusalenpita. Tayta Diospa poderninwanmi Jesusga caycargan geshyagyashgacunata allïtsirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsaymanmi runacuna quirmawan wantushga chätsiyämurgan paralïticuyashga runata. Paycunaga imaycanöpapis Jesuspa ñöpanman yaycatsiytam munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tsaychö pasaypa runacuna quichquicashga cayaptinmi imanö caytapis mana puëdiyargantsu. Tsaynam wayi jananman yarcarcatsir wayi jananta uchcusquir wascawan watarcur cachäyargan quirmantinta Jesuspa ñöpanman. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesusga musyarganmi tsay runacuna payman yäracunganta. Tsaynam tsay geshyaycag runata nirgan: “Jutsayquicunapita perdonashgam canqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsaynam tsaychö waquin ley yachatsicogcunawan fariseucuna yarpachacuyargan: “¿Pitä cay runaga llutancunata parlar Diosta ajätsin? Tayta Diosllam jutsa ruragcunataga perdonan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tsaynö yarpaycäyanganta musyarnam Jesus paycunata nirgan: “¿Imanirtä gamcuna llutanta yarpäyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Tayta Diosmi nogata cachamashga cay patsachö runacunata jutsancunapita perdonanäpä. Cananmi Tayta Dios rasunpa cachamanganta musyayänayquipä ‘Quirmayquita aparcur aywacuy’ nir allïtsishä ricanayquicunachö” nir. Tsaynö nisquirnam Jesus runata nirgan: “Cananga allishganam canqui. Sharcur quirmayquita apacurcur wayiquipa aywacuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tsaynö niycuptin tsay runanam llapancuna goriraycäyaptin ñöpancunapita jinan öra jitarangan quirmanta icshacurcur wayinpa aywacurgan Tayta Diosta alabarnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsayta ricarmi llapan runacuna cushishga alabayargan Tayta Diosta: “¡Pay rurangantanöga imaypis manam ricarguntsictsu!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsay wayipita yargurir Jesus aywaycarnam ricärirgan Mateo jutiyog juc runa impuestuta cobrar jamaraycagta. Tsaymi Jesus nirgan: “Discïpulü canayquipä nogawan aywacushun”. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Niptinnam sharcurcur tsaychö imaycantapis jagiriycur Jesuswan Mateo aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tsaynö discïpulun cananpä Jesus acranganpitam agradesicurnin fiestata Mateo rurargan wayinchö. Tsaychömi impuestuta cobrag mayincunawan mas waquin runacunapis Jesuswan micuycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tsaynö imaycaläya runacunawan Jesus caycagta ricaycurnam fariseucuna y ley yachatsicogcuna parlacacharrä Jesuspa discïpuluncunata niyargan: “¿Imanirtä gamcuna impuestu cobracogcunawanpis y jutsasapacunawanpis juntacar micuyanqui upuyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tsaynö niyaptinnam Jesus caynö nirgan: “Geshyagcunallam jampicogta miñishtiyan. Manam sänu cagcunaga imata munayantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nogaga manam shamurgö alli rurag runacunallata Tayta Diospa willacuyninta tantiyatsinäpätsu, sinöga jutsa ruragcunatapis tantiyatsinäpä shamushga carmi paycunawanpis juntacü”. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tsaypitanam Jesusta tapuyargan: “Juan Bautistapa discïpuluncuna y fariseucunapa discïpuluncuna imaypis ayunayanmi Tayta Diosman mañacur. Gampa discïpuluyquicunaga ¿imanirtä ayunayantsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Tsaynö niyaptinnam Jesus nirgan: “¿Imanirtä discïpulücuna ayunayänanta munayanqui? ¿Casacuy fiestaman invitashgacuna ayunaycunmantsurä? Tsay invitashgacunaga casarag noviuwan juntu caycarnin micur upur cushishga cayangannöllam discïpulücunapis nogawan juntu cayanganyagga ayunayanrätsu. Peru wanuscatsiyämaptinmi itsanga ayunayanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tsaynö nisquir caynöpis Jesus nirganmi: “Manam pipis macwa röpanta mushog ratashwanga remendantsu. Mushog ratashwan remendashgaga genticäratsirmi rachiratsinman. Y manam shumagga ricacunpisnatsu macwa röpachöga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Tsaynöpis manam pipis wiñantsu tsayrä puwatsishga aswata tsillicaycag uylluman. Tsaynö carga masran tsilliratsinman. Tsaynöpam aswapis jichacasquinman y uyllupis ushacärinman. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tsaymi tsayrä puwatsishga aswataga wiñantsic alli uylluman. Tsaynö ruraptinga aswapis jichacantsu ni uyllupis manam paquicantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Y manam pipis unayna churarashga vïnuta yawarcur tsayrä rurashga cagtaga upuyta munannatsu: ‘Unayna churarashga cag vïnu mas alli caycan’ nirnin. Tsaynöllam unay cag yachatsicuycunawan yachacashga car canan noga yachatsingäcunataga runacuna chasquicuyta munayantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juc säbadu jamapay junagchönam discïpuluncunawan Jesus aywaraycäyargan trïgu poguraycag cuchunpa. Tsaynö aywaraycäyangantanam discïpuluncunaga trïguta quiptuscärir cuparir micuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tsayta ricarnam fariseucuna niyargan: “¡Canan junagga manachä arucuy junagtsu! Tsaynö caycaptinga ¿imanirtä trïguta quiptupacur puriycäyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tsaynam Jesus nirgan: “¿Gamcunaga manacu Diospa palabranta liyiycarpis yarpäyanqui unay rey David mallagar imata ruranganta? ");
INSERT INTO qxoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David soldäduncunawan puriycar millcapancuna manana captin mallagäyänä. Tsaynam Tayta Diosman mañacucuyänan ruriman David yaycusquir sacerdöticunalla micuyänanpä cag churarag tantata micurinä. Nircurmi garanä gatiragnincunatapis. David mana micunanpä cagta micuringanpis ¿jutsacu cashga gamcunapä? Tsaynömi discïpulücunapis mana jutsatatsu ruraycäyan: ‘Jamapay junagchö trïguta ama quiptupacuyätsuntsu’ niyaptiquipis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tsaynö nisquirpis Jesus nirgan: “Noga Tayta Dios cachamashga captinmi munayyog caycä säbadu junagchöpis runacuna imata rurananpä o mana rurananpä cagtapis ninäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tsaypita juc säbadu jamapay junagchönam Tayta Diosman mañacur goricäcuyänan wayiman Jesus yaycurgan yachatsicamunanpä. Tsaychömi maquin wanucashga juc runata tarirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ley yachatsicogcunawan fariseucunanaga Jesusta ricapaycäyargan shonguncunallachö yarpachacurmi: “Mä, ¿canan jamapay junag mana arucuy caycaptin cay runata allïtsingacush o manacush? Allïtsiptinga tsaymi achäqui canga autoridäcunaman apatsinapä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tsaynö yarpaycäyanganta musyarnam tsay maquin wanucashga runata Jesus nirgan: “¡Sharcur tsay chöpiman ichïmuy!” nir. Niptin tsay runaga chöpincunamanmi ichircurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nircurnam tsay fariseucunata Jesus nirgan: “Canan mä niyämay. Tayta Dios ¿imata ruranantsictatä munan jamapay junagchö? ¿Cay geshyaycag runata cuyapashwancu o dejarishwancu ñacacunanpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tsaynö nisquirnam tsay quinran caycag runacunata ricaycachasquir runata nirgan: “Maquiquita mashtamuy” nir. Niptin tsay runa maquinta mashtasquir sänunam ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Säbadu jamapay junagchö tsaynö allïtsinganta ricarnam fariseucuna pasaypa rabyanar willanacuyargan Jesusta imanöpa wanutsiyänanpäpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tsay junagcunam juc tsacay Jesus juc jircanman aywaycur Tayta Diosman mañacuycar warargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsaypita patsa warasquiptinnam llapan discïpuluncunata gayargan. Nircurmi paycunapita acrargan chunca ishcay (12) runacunata apostolnincuna cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paycunaga cayargan: Simon (Paytam jutinta Jesus churapargan “Pedro” nir), Simonpa waugin Andres, Santiago, Juan, Felipe, Bartolome, ");
INSERT INTO qxoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Alfeupa tsurin Santiago, “Celote” ningan Simon, ");
INSERT INTO qxoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa waugin Judas, y Jesusta ranticog cag Judas Iscariote. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jircapita Jesus uraycarnam juc patacchö atscag discïpuluncuna y waquin runacunapis goriraycagta tarirgan. Tsay runacunaga shayämushga cayargan Judea provinciapita, Jerusalenpita, lamar cuchun Tiro y Sidon marcacunapita. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Paycunaga goricäyargan Jesus yachatsicunganta wiyayta munarmi y geshyancunapita alliyta munarmi. Tsaychö supay löcuyätsingan runacunapis allïyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesus poderninwan runacunata allïtsiptinmi jucpis jucpis yatayta munayargan, geshyancunapita allisquiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsaynam Jesus discïpuluncunata ricaycur nirgan: “Cay vïdachö ñacacog cagcunata gloria vïdachöga Tayta Dios alli cawaychömi catsiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Cushishgam cawayanqui cay vïdachöga mallagaychö cagcunaga. Gloria vïdachö mananam mallagäyanquinatsu. Cushishgam cawayanqui cay vïdachö wagacuychö cagcunaga. Gloria vïdachö cushicuyllachömi Tayta Dios catsiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nogata gatiräyämangayquipita runacuna chiquiyäshuptiqui, garguyäshuptiqui, y ashlliyäshuptiqui ama llaquicuyaytsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Noga raycur ñacagcunataga Tayta Diosmi gloria vïdachö premiuta goyäshunqui. Gamcunatanömi unay profëtacunatapis ñacatsiyargan. Tayta Dios tsay profëtacunata premiuta gongannöllam gamcunatapis goyäshunqui. Tsaynö cananpä caycaptinga ñacarpis cushicuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tsaynö nisquirnam waquincunatapis Jesus nirgan: “¡Allau, cushishgalla cawacog rïcu runacuna! Pobricunata imayquicunallatapis mana garaycungayquipitam washa vïdachöga wagacur ñacayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Imaycayquicunapis mana faltäpuyäshuptiqui cushishgalla cagcuna! Juc vïdachöga manam Diospita imatapis chasquiyanquitsu. ¡Quiquillayquicuna imatapis llutanta rurasquir asicogcuna! Gamcunaga pasaypa llaquicurmi wagayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Allau, gamcunachö llapan runacunapita alabashga cayta munagcuna! Llutan yachatsicogcunata unay runacuna alabayangannöllam gamcunatapis alabaycäyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Shumag cawacuyänayquipä cay ningäta tantiyacuyay. Nogata gatirayämangayqui raycur chiquiyäshogniquicunataga cuyayanqui. Alli shonguyquicunawan ricayanqui mana alli ricashogniquicunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rimayäshogniquicunapä allillata parlayanqui. Chiquiyäshur contrashogniquicunapäpis Tayta Diosman mañacuyay cawayninchö yanapananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lagyaycuyäshuptiquipis jucag lädu cag cärayquicunatana camapaycuyanqui. Punchuyquicunata gechuyäshuptiquega chompayquicunatapis llogtipaycuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Imallatapis mañacuyäshuptiquega garaycuyanqui. Tsaynö imayquicunatapis gechuriyäshurniqui apacuyaptinga ama ‘Cutiycatsimay’ niyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Runa mayiquicuna alli ricayäshunayquita munarga gamcunapis paycunatarä alli ricayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cuyanacuyangallayquiwan cuyanacuyarga ¿ima allitatä ruraycäyanqui? Jutsasapa runacunapis cuyanacuyangallanwanga cuyanacuyanmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Alli cagcunallawan alli cawarga ¿ima allitatä ruraycäyanqui? Jutsasapa runacunapis tsaynöllaga cawayanmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yanapanacog puralla imachöpis yanapanacurga ¿ima allitatä ruraycäyanqui? Yaga runacunapis yanapagnincunallataga yanapanmi imatapis garanacuyänan raycurllaga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Gamcunaga chiquiyäshogniquicunata cuyayay. Paycunapä allicunallata rurayay. Imatapis mañaycur ama yarpäyaytsu pägayäshunayquitaräga. Tsaynö alli cawarga poderösu Tayta Diospa wamrannam cayanqui. Paypa wamran carnam ciëluchö listangancunata chasquiyanqui. Tayta Diosga cuyapanmi jutsa ruraychö cawacogcunata. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tsaynö captin Tayta Dios cuyapäcog cangannö gamcunapis cuyapäcog cayay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tayta Dios mana juzgayäshunayquipä jamuräcur runa mayiquicunapa vïdanta ama ashiyanquitsu. Llutanta rurayaptinpis ama contran sharcuyanquitsu. Contran sharcuyänayquipa rantinga perdonayanqui, Tayta Dios gamcunatapis perdonayäshunayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Runa mayiquicunata cuyapar imallatapis garaycuyaptiquim Tayta Dios gamcunatapis mas masta cutitsiyäshunqui tupuyquipitapis jichag jichag. Cuyapäcog cayangayquinöllam gamcunapis Tayta Diospa cuyapäcuyninta chasquiyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“Juc gapra runa gapra mayinta manam pushanmantsu. Pushanacurga ¿manatsurä pözumanpis ishcan jegacurpuyanman? Nogapita imatapis manarä yachacurga gamcunapis gapranöllam caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maygan yachacogpis manam yachatsegninpita mastaga yachantsu. Tsaynömi yachatsingäcunata shumag cäsumag cagga gamcunapis noga cawangänö cawayanquiman”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Gamcunaga ¿imanirtä runa mayiquicunapa ñawinchö shucata jipicuriyänanta munar ricapäyanqui, quiquiquicunapa ñawiquicunachö geru cuentatarä caycaptin? ");
INSERT INTO qxoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ñawiquicunachö geru cuenta caycaptinga ¿imanöparä runa mayiquitarä niyanquiman: ‘Ñawiquichö shucata jipipasquishayqui’ nirnin? ¡Yachag tucogcuna! Puntataga ñawiquicunachö cagtarä jipicuyay. Tsayrämi ricayta puëdiyanqui runa mayiquipa ñawinchö caycagta jipipänayquipäga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","45","Nircur imanö runacuna cayangantapis caynöpam tantiyatsirgan: “Alli wayog jachaga allillatam wayun y mana alli wayog jachaga mana allillatam wayun. Tsaynöllam wayuyninpita regintsic ima jacha cangantapis. Hïgusga manam cashacunapa prütantsu ni üva manam shiracapa mullacantsu. Ima jachatapis wayuyninpa regingantsicnöllam runacunatapis cawayninpita musyantsic alli runa canganta o mana alli runa cangantapis. Tsaynömi ari alli runacunaga allillata parlayan shonguncunachö allita yarpar. Y mana alli runacunaga mana allicunatam parlayan shonguncunachö yarpäyanganllata”. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtä gamcuna ‘Señor, gampa munduyquichömi caycä’ niyämanqui, noga ningäta mana cäsuycämarga? ");
INSERT INTO qxoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Canan tantiyatsiyäshayqui wiyacamag runa imanö cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wiyacamag runaga alli cimientushga wayi sharcatsishganömi caycan. Tsay alli rurashga wayega atsca gashgay yacu miramur jaytaptinpis manam juchuntsu. Tsay wayi mana juchognöllam nogata cäsumag cagcunaga infiernuchö ushacaypita salvacunga fisyu final junagchöpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ningäcunata wiyaycar mana cäsumag cagmi itsanga allpa janallanchö sharcatsishga wayinölla. Tsay cimientuynag wayitaga gashgay yacu goricar shamurninpis juchuratsinmi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Runacunata tsaynö parlapayta ushasquirnam Jesus aywargan Capernaum marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tsaychömi juc capitanpa cuyay wätaynin wanuyta ricarna pasaypa antsa geshyaycargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tsaynam Jesus runacunata allïtsinganta mayarna tsay capitan Jesusman cachacurgan Israel mayor runacunata: “Rugacaycayämuy wätaynïta allïcatsinanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tsaymi paycuna Jesus caycanganman chaycur rugacuyargan: “Taytay, capitanpa wätaynintash allïtsipaycullanqui. Capitanga alli runam. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Marca mayintsiccunawanpis payga allim cawan. Tsaynö alli carnin paymi goricäcunantsic wayitapis sharcatsishga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsaynö rugacuyaptinmi Jesus aywargan paycunawan. Capitanpa wayin cagman Jesus yaycuraycaptinnam amïguncunata capitan taripätsirgan Jesusta caynö niyänanpä: “Amanash afanacullanquinatsu, taytay. Capitanga musyannash wayinman mana chayllapanapis allita ruraycunayquipä cagta. Musyaynash, taytay, Israel runacunapa üsuyquicunachö juclä runacunawan chänacuy mana alli cangan. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Tsaynöpis payga musyanshi Israel runacuna juclä runacunawanga mana parlapänacuyanganta. Tsayshi quiquinga shamushgatsu rugacuycushunayquipä”. “Pay musyanshi gam munayyog cangayquita. Tsayshi cayllapitana niycullanqui wätaynin allisquinanpä. Paypis mandagninpa munayninchöshi. Tsaynöshi paypa munayninchöna cayan mandangan soldäduncunapis. Tsayshi maygantapis ‘Ayway’ niptin aywayan: ‘Shamuy’ niptin shayämun, y wätayninta ‘Cayta ruray’ niptinpis ruran. Gam imaycawan munayyog captiqui musyanshi imapis ningayquega ruracasquinanpä cagta”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tsaynö ninganta wiyaycurmi Jesus cushicur paywan aywaycag runacunata nirgan: “Paynö llapan shongunwan yäracamag runaga manam Israel runacunachöpis cantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tsaynö nisquiptin capitanpa cachancuna cutiycurmi tariyargan tsay wätay allisquishgana caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsaypitanam Jesus discïpuluncunawan Capernaum marcapita “Nain” ningan marcaman aywaycäyargan. Tsaychömi atscam runacunapis paycunawan aywaraycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tsaypita marcaman yaycuraycarnam tincusquiyargan ayata pampayänanpä apaycäyagwan. Tsay apaycäyangan ayaga cargan juc viüdapa japayllallan wawanmi. Atscag runacunam llaquiparnin aywaycäyargan pampäshiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tsay viüda pasaypa wagagta ricaycurnam Jesus cuyapar nirgan: “Ama wagaytsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tsay ayata apaycagcunaman witiycuptinnam paycuna ichisquiyargan. Tsaynam tsay aya cäjata Jesus yataycurgan. Nircurnam nirgan: “¡Jövin, sharcuy!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tsaynö nisquiptin jövin jinan öram jamarcamur ñöpan quinranchö caycag runacunata parlapar gallaycurgan. Tsaypita viüdatanam Jesus nirgan: “¡Ama wagaynatsu! ¡Wawayqui cawarimushganam!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tsayta ricaycurmi llapan runacuna cushicurnin Tayta Diosta alabayargan caynö: “Diospa willacognin profëtam nogantsicman chaycamushga. ¡Cananmi sïga Tayta Dios cachaycamushga imaycachöpis cuyapäcog cayninwan yanapaycamänantsicpä!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tsaynömi ari Jesuspa ruraynincuna musyacargan Judea provinciachö y ñöpan quinran marcacunachöpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesus rurangancunatam Juan Bautista carcelchö caycagman aywar Juanpa discïpuluncuna willayargan. Tsaynö willaycäyaptinpis carcelchö caycarnin Juanga yarpachacurganmi salvador shamogpäga. Tsaymi Jesusman cachargan ishcay cag discïpuluncunata pï cangantapis tapog: ");
INSERT INTO qxoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“‘¿Gamcush canqui Tayta Dios cachamungan salvacog, o juctaräcush shuyacuyäshä?’ niyämuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Juanpa ishcan cachancuna Jesus cagman chäyänanpäga Jesus alliycätsirgan atscag tucuyläya geshyagcunatam, supay geshyatsingancunatam, y gapracunatam. Tsaymi Jesusta tapuyargan: “Tayta, gampita Juanmi musyayta munaycan. ¿Gamcush canqui Tayta Dios cachamungan salvacog, o juctaräcush shuyäyäshä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsaynö tapuyaptinnam Jesus nirgan: “Canan aywar Juanta niyay cay ricayangayquicunata y wiyayangayquicunata. Gapracuna ricayannam. Mana puriyta puëdegcuna puriyannam. Leprawan geshyagcunapis allïyashgam. Upacunapis wiyayannam. Wanushgacunapis cawariyämushgam. Muchuychö cawagcunamanpis Diospa alli willacuyninga chaycannam. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tsaycunata willayaptiquim cushicunga nogapita. Nogaman imaypis yäracamungannölla yäracamutsun”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tsaypita Juanpa cachancuna cutisquiyaptinnam runacunata Jesus Juanpita parlapar nirgan: “Tsunyag jircaman Juanta ricag aywar manam jachata vientu cuyutsegman ricapagtsu aywayargayqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Y manam alläpa chaniyog röpan jatishga canganta ricapäyänayquipätsu aywayargayqui. Tsaynö chaniyog röpashgacunaga reypa wayincunallachömi taycäyan, manam tsunyagcunachötsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Manam tsaycunata ricagtsu aywayargayqui, sinöga Tayta Diospa willacognin profëta canganta ricayänayquipämi. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpä cagtaga Tayta Diospa palabran gellgaranganchöpis nicanmi: ‘Salvacog manarä willacuptinmi juctarä cachashä willacuynïta willacunanpä. Pay willacunganta chasquicurmi runacuna jutsa ruraynincunata jagirir salvacogta shuyacur alistacuyanga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tsay ningannölla Tayta Dios Juanta willacognin cananpä churashga captinmi puntataga Juanrä tantiyashga noga salvacog rey cangäta. Tsaynö captinpis discïpulücunam nogawan purishga carnin Juanpitaga maslla willacuynïta tantiyacuycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Juan ninganta chasquicurmi hasta mas jutsasapa cagcunapis tantiyayargan Diospa willacuynin rasun caglla canganta. Tsaynöpam jinan öra Juan paycunata bautizargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peru fariseucunawan ley yachatsicogcunaga bautizacuyargantsu, jutsa ruraynincunapita perdonananpä Tayta Diosta mana mañacurmi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Tsaynö nisquir Jesus mastapis nirganmi: “Canan tiempu runacunaga yupay tucog wamracunanömi caycäyan. Manam chasquicuyantsu noga ningäcunata ni Juan Bautista ningancunata. Wamracuna pucllar pinculluta tucapaptin yanasancuna tushuyta mana munagnömi noga ningäcunatapis mana chasquicuyta munayantsu. Tsaynö ‘Aya pampayta pucllar nogacuna cantayämushä, gamcuna wagayämunqui’ niyaptin yanasancuna wagayta mana munayangannömi Juan Bautista ningancunatapis mana chasquicuyta munayantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautistaga imaypis ayunarmi mana vïnuta upogtsu. Tsaynö captinmi gamcuna niyarguyqui: ‘¡Payga Satanaspa munayninchö carmi tsaynö cacun!’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Noga runacunawan goricar imaycatapis micuptï y vïnuta upuptïnam niyämanqui: ‘Micullar upullar puricun’ nirnin. Tsaynöllam ‘Payga jutsasapa runacunawanpis y impuestu cobrag sacyapacogcunawanpis juntacanmi’ niyämanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tsaynö nir mana chasquiyämaptiquipis Juantawan nogataga Tayta Diosmi cachayämashga willacuyninta willacuyänäpä. Tsaynö cachayämanganta runacuna tantiyacuyanga Tayta Dios munanganta ruraycäyangäta ricarmi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsaypitanam Simeon jutiyog juc fariseo runa Jesusta pushargan wayinchö micuyänanpä. Wayinman chascatsirnam jamaratsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tsayman Jesus aywanganta musyaycurmi juc puricog mañösa warmi chargan shumag frascuchö perjümin apacurcur. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuspa ñöpanman gonguriycur jutsanta wagacuriptinmi Jesuspa chaquinman wegin juturgan. Tsay wegin jutungantanam agtsanwan pitsapargan. Nircurnam Jesuspa chaquinta mutsaycur wiñapargan apangan perjümita. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tsayta ricaycurmi tsay invitag fariseo runa caynö yarpargan: “Rasunpa Diospa willacognin profëta carga cay runa musyanmanmi cay warmi imanö cangantapis. Mañösa warmi caycaptinga manam consientinmantsu yataycunantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsaynö yarpanganta tantiyapasquirnam Jesus nirgan runata: “Simon, jucta willashayqui”. Niptinnam tsay fariseo nirgan: “Mä willaycamay, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Niptinnam Jesus nirgan: “Ishcay runacunam juc rïcu runapa jagan cayänä. Jucnin jagan canä ishcay wata arupacur gänangannö. Jucagna canä ishcay quilla arur gänangannö. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tsayna runacuna jagan cayanganta pägayta mana puëdiyaptin ishcancunatapis cuyapar manana cobranänatsu. Canan mä nimay: ¿Maygan cagtä tsay gellëyog runata mas agradesicurgan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tsaynam Simon nirgan: “Mas lasag jaga cagchir, taytay”. Niptinnam Jesus nirgan: “Allim yarpayniqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nircurnam tsay warmita ricärirna Simonta nirgan: “Cay warmi imanir tsaynö ruraycämangantapis manam gam tantiyanquirätsu. Üsuntsic caycaptinpis wayiquiman yaycaramuptï gamga manam yacuta garamarguyquitsu chaquïta awirinäpä. Cay warmim itsanga chaquïman wegin jutungantapis agtsanwan pitsapämashga. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yaycamuptï manam mutsacuyniquiwan saludamarguyquitsu. Paymi itsanga yaycascamuptï jinan öra chaquïta mutsacushga. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Umämanpis manam acëtita wiñapämarguyquitsu. Paymi itsanga chaquïman perjümita wiñapämashga. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cay warmega jutsasapa carmi perdonta taringanta pasaypa cushicurnin agradesicur tsaycunata rurashga. Waquincunam itsanga ‘Noga manam alläpaga jutsayogtsu cä perdonta ashinäpäga’ nirnin ni ichicllapis Tayta Dios agradesicuyantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nircurnam tsay warmita nirgan: “Cananga llapan jutsayquicunapita perdonashganam canqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tsaynam mësachö jamaycag runacuna quiquin pura caynö ninacuyargan: “¿Pinatä payga jutsancunapita runacunata perdonananpäga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tsaynö niyaptinnam Jesus nirgan tsay warmita: “Nogaman yäracamungayquipitam Tayta Diospa castïgunpita salvacurguyqui. Cananga cushishgana aywacuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsaypitaga Jesus purirgan marcan marcan Tayta Diospa alli willacuyninta willacurmi chunca ishcay (12) apostolnincunawan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Paywanmi aywayargan Satanaspa munayninpita jipingan warmicuna y geshyancunapita allïtsingan warmicuna. Paycunawanmi aywargan Maria Magdalenapis. Tsay warmipitam Jesus gargurgan ganchis (7) supaycunata. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tsaynöpis aywarganmi Herodespa yanapagnin Cuzapa warmin Juana, Susana, y waquin warmicuna. Paycunam Jesusta y discïpuluncunata yanapayargan capuyanganpita imaycancunallawanpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Maytsay marcacunapitapis atscanam runacuna goricäyargan Jesuswan puriyänanpä. Tsaychömi caynö nir parlapargan: ");
INSERT INTO qxoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc runam trïgu murucog yargunä chacraman. Tsaynam matsiptinna waquin cag tiuyanä näniman. Runacuna nänipa purirnam tiuyashgataga jaruscäriyänä y pishgucunapis chaycur upshascärinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquin murucunanam tiuyanä shagan ricogllaman. Tsaychöna ras jegarcamur shumagllaga allpa mana captin tsaquiscäriyänä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquin murucunanam tiuyanä cashacuna rurinman. Tsaychöpis jegarcamur garwashtaycällarmi tsaquiscärinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y waquin cag murucunanam chänä alli allpaman. Tsaychöga shumag jegascäramur wiñar pogunä cada espïgachö juc pachac (100) gränuyag”. Tsaynö parlapärirnam Jesus runacunata caynö nirgan: “¡Cay ningäcunata wiyag cagga tantiyacuyay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tsaynam discïpuluncuna Jesusta tapuyargan: “Taytay, tsay yachatsicungayqui ¿imaninantä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tsaynö tapuyaptinnam Jesus nirgan: “Gamcunataga cäsucog cayaptiqui tantiyatsiyäshayquim parlapaycangäcunata. Mana cäsumag cagcunam itsanga ni imanöpa parlapaptïpis mana tantiyayangatsu. Tsaynö runacunapäga Diospa palabranchöpis nicanmi: ‘Noga rurangäcunata ricaycarpis manam criyiyantsu. Y willacungäcunata wiyaycarpis manam cäsuyantsu’ ” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Cananmi tantiyatsiyäshayqui murucog runaman iwalatsir yachatsingäcunata. Trïgu muroga Diospa alli willacuyninmanmi iwalan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Muru tiuyangan nänega chucru shongu runacunamanmi iwalan. Tsaynö shongu carmi waquin runacunaga Diospa willacuyninta wiyarpis chasquicuyantsu. Juc ishcay wiyayangallantapis Satanas gongaratsiptinmi salvacionta tariyanganatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Muru tiuyangan shaga allpanam waquin runacunaman iwalan. Paycunaga Diospa alli willacuyninta wiyar cushishgam chasquicuriyan. Tsaynö cushishga chasquicurpis shagachö allpa mana captin trïgu jegarcamur tsaquireg cuentam, criyicunganpita imayca ñacaycunaman char Diospa willacuyninta jagiriyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Muru tiuyangan casha rurinpis waquin runacunaman iwalan. Paycunaga Diospa willacuyninta wiyarpis masga yarpachacuyan imaycayogpis cayllapä y quiquincuna munayangannö cawayänanpä cagllatam. Casha rurinchö trïgu jegarcamurpis illacäregnömi yarpaynincunapita Diospa willacuyninpis gongacärin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Muru changan alli allpaga waquin runacunamanmi iwalan. Paycunaga Diospa willacuyninta llapan shonguncunawan chasquicurnin mana dejaypam alli ruraychöna cawayan. Alli allpachö murucuy pasaypa wayungannömi Tayta Dios munangannö cawayan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tsaypita discïpuluncunata tantiyatsir mastapis Jesus nirganmi: “Manam pipis actsita tsaritsir churantsu cajon rurincunaman ni catri jawancunaman. Musyayangayquinöpis actsitaga churayan alëricunamanmi shumag atsicyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tsay actsi alërichö car shumag atsicyagnö, gamcuna Tayta Diospa willacuyninta runacunata shumag willapäcuyaptiquim, tantiyacuyanga alli cawaychö cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Willapangäcunata wiyar chasquicurninga yachatsingäcunata masmi tantiyacuyanqui. Tsaynö wiyacur cäsucogcunataga Tayta Dios masmi yanapanga shumag tantiyacuyänanpä. Yachag tucur mana cäsucog cagcunam itsanga wiyarpis manam tantiyayangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsay wayichö Jesus yachatsicuycaptinmi mamanwan waugincuna chäyargan parlayta munarnin. Atsca runacuna goricashga cayaptinmi Jesus caycangan cagmanga yaycuyta puëdiyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tsaychö paycunata ricarnam juc runa Jesusta willargan: “Mamayquiwan waugiquicunam puncuchö shuyaraycäyäshunqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tsaynö willaptinnam Jesus nirgan: “Diospa willacuyninta wiyacur cäsumag cagcunam cayan nogapa mamänö y waugïcunanöga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Juc cutinam discïpuluncunata Jesus nirgan: “Acu päsashun gochapa wac-tsimpaman” nir. Nisquirnam büquiman yarcurcur aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Gochata aywaraycäyaptinnam Jesusga gepamanpachö punucasquirgan. Tsayyagnam pasaypa vientuwan yacu lagchicachar gallaycurgan büquitapis jundicätsiytana munarnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tsaynam discïpuluncuna Jesusta ricchatsir niyargan: “¡Tayta Jesus, jundicaycantsicnachä!” nir. Tsaynam Jesus sharcurcur vientutapis yacutapis päracunanpä nirgan. Y jinan öram tsaynö niycuptin vientupis yacupis pärasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nircurnam discïpuluncunata nirgan: “¿Imanirtä nogaman mana yäracaycayämanquirätsu?” nir. Tsayga discïpuluncuna quiquincuna puram pasaypa mantsacashga parlapänacuyargan: “Cay runaga ¿ima runanarä cacunpis tsayläya vientupis yacupis pay ninganta cäsuycunanpä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tsaynö aywaraycarnam chäyargan Gerasa marcapa washaläninman. Tsayga cargan Galilea provinciapa wac-tsimpanchömi. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tsaychö Jesus büquipita yarpuriptinnam supay löcuyätsingan juc runa shamurgan. Tsay runaga löcuyangan junagpitapis gallapächullam puricog. Panteonllachömi täcogpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tsay runata imayca munangantam supay ruratsirgan. Maquinta chaquinta cadinawan pancayaptinpis cadinatapis rachisquirmi tsunyag jircacunapa aywacog. Tsaynam tsay runata ricaycur Jesus nirgan: “¡Gam supay, cay runapita yarguy!” nir. Niptinnam ñöpanman gonguricuycur gayarargan: “Poderösu Tayta Diospa tsurin Jesus, ¿imatatä munanqui nogacunawan? Cay runapita gargamarnï ¡ama condenaycamaytsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tsaynam Jesus tapurgan: “¿Imatä jutiqui?” nir. Niptinnam supay nirgan: “Nogapa jutëga Legionmi”. Tsaynö nirgan pasaypa atsca supaycuna payman yaycushga captinmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tsaynö nisquirmi Jesusta rugacurgan: “Ama nogacunata infiernumanga garpaycayämaytsu” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tsaynam janaganchö atsca cuchicuna caycagta ricärir rugacuyargan cuchicunaman yaycucuycuyänanpä. Jesusnam nirgan aywar yaycucuycuyänanpä tsay rugacuyanganman. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tsaymi supaycuna runapita yargurir yaycucuycuyargan tsay cuchicunaman. Tsaynam cuchicuna junish tunapita acataycachaycar jegarpäriyargan gochaman. Tsaychömi cuchicuna shengacar wanuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuchi mitsegcunanam tsayta ricaycur geshpir aywacuyargan marcapa ricayangancunata willacuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsay willacuyaptinnam runacunaga marcapita shayämurgan: “Mä imash päsaycushga” nirnin. Jesus caycanganman chaycurnam ricayargan supay löcuyätsingan runa trocapäcushga shumag fisyunchöna Jesuspa ñöpanchö jamaraycagta. Tsayta ricaycur runacunaga pasaypam mantsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Marcapita chag runacunata willayargan supayyog runata Jesus allïtsingantam. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsaynam pasaypa mantsariywan tsay Gerasa runacuna Jesusta rugar niyargan marcanpita jucläpa aywacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tsaynam Jesus büquiman yarcuraycaptinna alliyag runa rugar nirgan: “Taytay, gamwan aywacuytam noga munä. Pushacallämay” nirnin. Tsaynö niptinnam Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nogawan aywacunayquipa rantinga wayiquipa cutir marca mayiquicunata willay gamta Tayta Dios allïtsishungayquita” nir. Tsaynam runa marcanman cutiycur willacurgan Jesus cuyapar milagruta ruranganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gerasapita Jesus Capernaum marcaman cutiptinnam pasaypa atsca runacuna quichquishga goriraycäyargan Jesusta shuyacur. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Tsaymanmi Israel runacunapa autoridänin Jairo jutiyog runa chärirgan. Payga cargan Tayta Diosman mañacur goricäyangancunachö mandacogmi. Paypa chunca ishcay (12) watayog jucllaylla warmi tsurinmi wanuycarganna. Tsaymi Jesuspa ñöpanman gonguricuycur rugacurgan wamranman allïtseg aywaycunanpä. Jesus Jairupa wayinman aywaptinnam atsca runacuna gepanta aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tsay runacunachömi juc warmi aywargan chunca ishcay (12) watana yawar apaywan geshyagyashga. Tsay warmega atscag jampicogcunachö jampicurninpis manam allirgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tsay warmega runacunapa rurinllapa yaycuycurmi Jesuspa röpanpa cuchunta yataycurgan. Tsaynö yataycuptin jinan öram yawar apaynin pärasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tsay warmi allinganta tantiyasquirnam Jesus runacunata tapurgan: “¿Pitä yataycamashga?” nir. Tsaynam tsaychö llapanpis “Manam nogallätsu, manam nogallätsu” niyargan. Tsaynö niyaptinnam Pedro nirgan: “Tayta Jesus, cayläya quichqui aywaycashgaga jucnin jucninpis yatayäshungayquita ¿imanöparä musyashwan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tsaynö niptinpis Jesus yapaymi nirgan: “Musyämi mayganpis yataycamar podernïwan allisquinganta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsaynam warmi imanö caytapis mana puëdirna tsuctsucyarrä Jesuspa ñöpanman gonguricuycurgan. Nircurnam willargan imanir yataycunganta y jinan öra allisquinganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tsaynam Jesus nirgan: “Hïja, nogaman yäracamurmi tsay geshyayquipita allirguyqui. Cananga cushishgana cuticuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus tsaynö parlapaycaptinmi Jairupa wayinpita juc willacognin runa chaycur Jairuta nirgan: “Tayta Jairo, tsuriquega wanushganam. ¿Imapänatä Jesustapis wayiquiman pushanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tsayta wiyaycurnam Jesus Jairuta nirgan: “Ama llaquicuytsu. Nogallaman yäracamuptiquega tsuriqui cawarimungam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Tsaynam Jairupa wayinman chaycur wanushga wamrapä wagaycäyagta ricaycur Jesus nirgan: “Ama wagayaytsu. Cay wamra wanushga caycarpis, punuycagnöllam riccharcamunga” nir. Tsaynö niptin Jesustaga runacuna asipäyarganmi. Tsaynam wamra wanushga caycanganman Jesus yaycatsirgan Pedruta, Juanta, Santiaguta, y Jairutapis warmintinninta. Waquincuna aywayänantaga manam munargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nircurnam Jesus wamrata maquinpita tsarircur caynö nirgan: “Wamra, sharcamuy” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tsaynö niptin wamra jinan öram cawarircamur sharcurgan. Tsaynam Jesus nirgan tsay wamrata pachan garayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wamran cawarimunganta ricaycur papänincuna pasaypa espantacurmi cushicuyargan. Tsaypitanam Jesus nirgan: “Cay wamrata cawatsimungäta pitapis willacuycäyanquimantä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tsaypitanam chunca ishcay apostolnincunata gayaycur poderninta Jesus gorgan runacunapita supaycunata garguyänanpä y tucuyläya geshyawan geshyacogcunata allïtsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nircurnam paycunata cachargan Diospa alli willacuyninta willacuyänanpä y geshyacogcunata allïtsiyänanpä caynö nirnin: ");
INSERT INTO qxoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Maypa aywarpis ama apayanquitsu tucruyquicunata, alporjayquicunata, millcapayquicunata, ni gellëniquicunata. Janayquicunachö röpayquicunallawan aywacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maychöpis pipis wayinman patsatsiyäshuptiqui tsayllachö cacuyanqui tsay marcapita aywacuyangayquiyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","May marcamanpis chäyaptiqui sïcush runacuna mana chasquiyäshunquitsu, tsaypita aywacuyanqui chaquiquicunachö polvuta tapsicusquir. Tsaynöga rurayanqui mana chasquiyäshungayquipita Tayta Dios paycunata castigananpä cagta musyatsirmi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsaynö cachaptin discïpuluncuna marcan marcanmi puriyargan Diospa willacuyninta willacurnin. Tsaynömi atscag geshyagcunatapis allïtsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jesus tsaynö discïpuluncunawan milagrucuna rurayanganta Galilea provinciapa mandagnin Herodes pasaypam yarpachacurgan. Tsaynam runacuna parlar niyargan: “Juan Bautistam cawarimushga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Waquincunam niyargan profëta Elias canganta. Y waquincunanam niyargan unay willacognin maygan profëtapis cawamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Juan cawarimunganta runacuna niyaptinmi Herodes yarpachacur nirgan: “Paypataga quiquïchä umantapis rogutsirga, ¿pirä canman tsay runa? Tsay runata imanöparä nogapis regiycüman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tsaypita apostolcuna willacuyninta willacur puriyanganpita cutir Jesusta willapäyargan yachatsir puriyanganchö imanö cayanganta. Tsaynö willapäriyaptinnam paycunata pusharcurna Jesus aywargan Betsaida marcapa tsunyagnin quinranman. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tsaypa aywayanganta musyaycur atscag runacuna gepanta aywayaptin tsaychöpis Jesusga Diospa willacuyninta willacurganmi y geshyagcunatapis allïtsirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Patsa tardiyaptinnam discïpuluncuna Jesusta niyargan: “Taytay, cay tsunyagchöga manam imapis cantsu cay runacuna micuyänanpä ni patsacuyänanpä. Paycunata niycuy aywacur imallatapis rantir micuyänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tsaynö niyaptinnam Jesus nirgan: “Gamcuna micuyänanpä garayay” nir. Tsaynam paycuna niyargan: “¡Imäcunatarächi tincuycätsiyäman! Caychö capayäman pitsga tantawan ishcay pescädullachä. Micuy ranteg mana aywar imarga ¿imatarä caytsica runacunata garaycuyämanpis?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsaychö runacunaga cayargan pitsga waranganömi (5,000) ollgucuna, warmipis wamrapis mana yupashga. Tsaynam discïpuluncunata Jesus nirgan: “Jamatsiyay llapan runacunata pitsga chuncacama (50)”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ningannömi discïpuluncuna llapanta jamatsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tsaynam Jesus tsay pitsga tantata y ishcay pescäduta tsarircur ciëluman ñuquircur Tayta Diosman mañacur agradesicurgan. Nircurnam tsay tantata y pescäduta paquirir discïpuluncunata macyargan runacunata aypuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tsaychö runacuna pachajuntam micuyargan. Manana munar sobrapacuyangantanam tantatawan pescäduta discïpuluncuna goriyargan chunca ishcay (12) canastacunaman. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tsaypita juc junagnam Jesus discïpuluncunawan caycar Tayta Diosman quiquillan mañacurgan. Mañacuyta ushasquirnam paycunata tapurgan: “¿Noga pï cangätatä runacuna yarpäyan?” ");
INSERT INTO qxoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tsaynam discïpuluncuna niyargan: “Waquin runacunam niyan Juan Bautista cangayquita. Waquincunam niyan unay profëta Elias cangayquita. Y waquincunanam niyan unay juc profëta wanunganpita cawamushga cangayquita” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tsaynö niyaptinnam paycunata Jesus tapurgan: “Y gamcunaga ¿noga pï cangätatä yarpäyanqui?” nir. Tsaynam Pedro nirgan: “Gamga Tayta Dios cachamungan salvacogmi canqui, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tsaynö Pedro niptinnam discïpuluncunata Jesus nirgan: “Ama pitapis willayayrätsu Tayta noga salvacog cangäta. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tayta Dios cachamangan runa caycaptïpis pasaypa ñacatsirmi maltratayämanga. Autoridäcuna, sacerdöticunapa mandagnincuna, y ley yachatsicogcuna conträ sharcurmi wanutsiyämanga. Peru wanutsiyämanganpita quimsa junagtaga cawamushämi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nircur llapan gatiragnincunatapis caynömi nirgan: “Pipis discïpulü cayta munarga quiquinpa munayllanta rurar ama cawatsuntsu. Imayca ñacaychö carpis nogaman yäracamur cawayätsun. Wanunganyagpis noga ningäcunata cäsumag cagcunaga rasunpam nogaman criyicayämun. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Noga munangänö mana cawar pipis quiquinpa munayninta rurar cawacogcunaga infiernumanmi gaycucäyanga. Imayca ñacayta päsarpis noga munangänö cawagcunam itsanga gloriaman chäyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cay patsachö imaycayog cayanganpis ¿imapärä pitapis välin Tayta Diosta mana cäsunganpita infiernuman garpucänan captinga? ");
INSERT INTO qxoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pipis nogapita y willacuynïpita pengacuptinga tsay pengacamagcunata manam nogapis cäsushätsu, Tayta Diospa angelnincunawan chipipir ciëlupita cutimungä junag. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Waquinniquicuna cawaycällarran ricayämanqui Tayta Dios cachamangan salvacog rey chipipirrä caycagta”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tsaypita semänatanam Jesus juc jircanman witsargan Tayta Diosman mañacunanpä. Tsaypa witsarnam pushargan Pedruta, Juanta, y Santiaguta. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tsaychö Jesus Tayta Diosman mañacuycaptinmi gagllan jucnöman ticrasquirgan y röpanpis pasaypa yullag pürumanmi ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tsaynö caycaptinnam unay profëtacuna Moiseswan Elias yuripasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tsay pasaypa chipipiycagchömi parlayargan Jerusalenchö Tayta Dios munangannö Jesus wanunanpä cagtapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tsaychö Pedroga ishcay discïpulu mayincunawanmi punuy atipaptin ricchaycäyargan. Tsaymi ricayargan tsay profëtacunawan Jesus chipipirrä parlaycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tsaynam tsay runacuna illacasquiyänanpäna caycaptin Jesusta Pedro nirgan: “Taytay, ima allipämi cayman shacayämurgä. Cananga rurayämushä quimsa tsucllacunata, jucta gampä, jucta Moisespä, y juctana Eliaspä” nir. (Imanö niytapis mana puëdirmi Pedro tsaynöllana parlapargan.) ");
INSERT INTO qxoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsaynö Pedro parlapaycaptinmi pucutay paycunata tsapasquirgan. Discïpulucunam pasaypa mantsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tsaynam pucutay rurinpita Tayta Dios caynö nimurgan: “Paymi cuyay tsurï. Pay niyäshungayquicunata cäsucuyay” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tayta Dios tsaynö niscamuptinga Jesus japallannam caycänä. Tsay ricayangancunata discïpuluncuna manam pitapis willacuyarganrätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Waraynin jircapita uräyämuptinnam atscag runacuna Jesusta taripäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tsaynam tsay runacunapita juc runa Jesusta rugar caynö nirgan: “Tayta, cay jucllaylla tsurilläta mana ajayllapa ricaycullay. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Supaymi illagpita gayarätsin. Pampaman ishquitsin. Poshgaytapis agtutsin. Mana dejaypam pasaypa tsuctsucyätsin. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tsaynö captinmi gamta mana tarir discïpuluyquicunatapis rugacurgö tsurïpita supayta garguycuyänanpä. Peru paycunaga manam puëdiyashgatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tsaynö niptinnam Jesus nirgan: “¡Yäracuyniynag jutsasapa runacuna! ¿Nogallarätsurä tsaycunata ruraycäshä? ¡Imayyagrä gamcunawan caycäshä! Canan apayämuy tsay wamrata” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tsaynam Jesuspa ñöpanman wamrata apaycuyaptin supay tsuctsucyätsir patsaman ishquiriycatsirgan. Tsayta ricaycurmi supayta Jesus ollgutupargan wamrapita yargunanpä. Jinan öram wamra sänuna ticrasquiptin Jesus papäninta entregargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tsaynö Tayta Diospa poderninwan supayta gargunganta ricarmi runacuna espantacur cushicuyargan. Tsaycunata rurangancunapita runacuna cushishga caycäyaptinpis discïpuluncunata Jesus nirgan caynömi: ");
INSERT INTO qxoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Wiyayämay shumag y yarparäyay. Noga Tayta Diospita shamogta runacuna entregayämanga chiquimagnïcunapa maquinmanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tsaynö Jesus parlapaptinpis discïpuluncunaga manam tantiyayargantsu runacuna wanutsiyänanpä cagta. Tsaynö mana tantiyarmi imapita tapurcuytaga mantsariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsaypitanam Jesuspa discïpuluncuna quiquin pura rimanacuyargan: “Maygantsicshi mä llapantsicpa mandagnin cashun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tsaynö yarpaycäyanganta musyarirmi Jesus ñöpanman juc wamrata ichïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nircurnam nirgan: “Pipis cay wamratanö runa mayinta alli ricag cagmi nogata chasquiycämag cuenta caycäyan. Nagana nogata chasquimarninga cachamagnï Tayta Diostapis chasquiycäyanmi. Juccunapita mas puëdeg caypä mana yarpagcunaga mas alli discïpulümi cayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tsaynam discïpulun Juan nirgan: “Taytay, nogacuna ricayargö supayyog runacunapita jutiquichö juc runa supaycunata gargogtam. Pay nogantsicwan mana puriptinmi michäyargö”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tsaynö niptinnam Jesus nirgan: “Ama michäyanquitsu. Nogantsicwan mana purishga carpis Tayta Diospa willacuyninta cäsucurga allillatam ruraycan. Tsaynö carninga manam nogantsicpa contrantsictsu caycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus ciëluman cutinanpä ricognam tiempu chaycämurgan. Tsaynö caycaptinpis mana mantsacuypam Jesus aywargan Jerusalenman. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tsay aywaycarnam cachacurgan Samaria provinciachö juc marcaman, tsaychö patsacuyänanpä wayi asheg. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tsay marcachö runacuna manam chasquiyta munayargantsu, Jerusalenpa aywaycanganta musyar. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tsaynö mana chasquiyaptinnam Santiaguwan Juan niyargan: “¿Elias ñöpata rugacungannö Tayta Diosta rugacuriyämancu ciëlupita nina runtuta cachaycamuptin cay runacuna ushacasquiyänanpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tsaynam paycunata Jesus ajäpargan: “Tayta Dios gamcunatapis cuyapaycäyäshuptiquega ¿imanirtä juccunapäga tsaynö yarpäyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsaynö nisquirmi juclä marcapa aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tsaynö aywaycäyaptinmi juc runa Jesusta nirgan: “Tayta, maypa aywaptiquipis gamtaga gatiräshayquim”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tsaynö niptinmi Jesus nirgan: “Atogcunapaga machaynincuna canmi. Pishgucunapapis geshuncuna canmi. Peru noga Tayta Diospita shamogpaga manam ni juc wayïllapis cantsu maychö punuycunalläpäpis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tsaynö nisquirmi juc runata Jesus nirgan: “Discïpulü canayquipä nogawan aywacushun” nir. Niptinnam tsay runa nirgan: “Tayta Jesus, papänï wanuptin pampaycurga gamta gatishayquim” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tsaynam Jesus nirgan: “Papäniquita pampaytarä shuyacunayquipa rantinga juclla nogawan aywacushun Diospa alli willacuyninta willacunayquipä. Wanogcunataga quëdagcunanachir pampacuyanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tsaypita juc runapis caynömi nirgan: “Tayta Jesus, nogapis gamwan aywacuytam munä. Itsanga castäcunatarä willaycamushä aywacunantsicpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Niptinnam paytapis Jesus nirgan: “Pipis gepapa ticracushgaga manam yapyantsu. Tsaynö castayquipä y imaycayquicunapäpis yarparaycarga nogapa discïpulü cayta manam puëdinquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsaypitanam Jesus acrargan ganchis chunca ishcay (72) gatiragnincunata. Nircurnam ishcay ishcay cachargan pay aywananpä cag marcacunaman. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tsaynö cacharninmi Jesus caynö nirgan: “Maytsicag runacunam listuna caycäyan Diospa alli willacuyninta wiyacur chasquicuyänanpä. Imayca jatun chacrachö wallcag runacunalla cosichaycagnömi willacogcunaga wallcagllarä cayan. Tsaymi Tayta Diosta rugacuyänayqui willacogcuna mas atsca cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cananga aywar willacuyay. Gamcunata cachaycä atsca atogcunaman üshacunata gaycapaycog cuentam, Diospa willacuyninta mana alli yaga runacunatapis willacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Ama apayanquitsu gellëniquicunata, gepiquicunata, ni llangiquicunata. Piwanpis nänichö tincurga ama parlacur cacuyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Pipa wayinman charpis wayiyogta niyanqui: ‘Alli caway caycutsun cay wayichö’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tsay wayiyog chasquiyäshuptiquega niyangayquinömi alli caway canga tsay wayinchö. Mana chasquiyäshuptiquega manam paypäga alli caway cangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pipis chasquiyäshogniquicunapa wayillanchö posadaräcuyanqui. Ama wayin wayinräga puriyanquitsu mas allitarä munar. Arupacog runa arunganpita pägunta chasquinmi. Tsaynömi gamcunapis Tayta Diospa willacuyninta willacuyangayquipita ima miñishtiyangayquitapis chasquiyanqui. Pipis imallatapis garayäshuptiqui micucurcuyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“May marcamanpis chäyaptiqui runacuna chasquicuyäshurniqui tsaychö imallatapis garayäshungallayquita micuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tsay puriyangayqui marcacunachö geshyagcunata allïtsiyanqui. Y runacunata niyanqui: ‘Tayta Diospa alli willacuyninta musyatsicuy tiempu chämushganam’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","May marcaman chäyaptiquipis runacuna mana chasquiyäshuptiquega cälliman yargusquir niyanqui: ");
INSERT INTO qxoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Cay chaquïcunachö polvuta tapsiyä mana alli yaga cayangayqui musyacänanpämi. Ima captinpis musyayay salvacog rey gamcunaman chämunganta’. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tsaynö mana chasquiyäshungayquipitam tsay runacunata Tayta Dios castiganga unay tiempu Sodoma marcachö castiganganpitapis mas cuyapaypä cay patsa ushacangan junag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Corazin marca runacuna y Betsaida marca runacuna, ¡gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui! Gamcunachö milagrucunata rurangänö Tiro y Sidon marcacunachö milagrucunata ruraptëga maynam Tayta Diosta perdonta mañacur jutsa ruraynincunata dejariyanman cargan. Tsaynö jutsancunapita llaquicurnin maynam arripenticur cotenciapita röpata jaticurcur uchpaman jamaycur wagayanman cargan. Gamcunaga milagrucunata rurangäta ricaycarpis manam jutsa rurayniquicunata dejayta munayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tsaynö jutsa rurayniquicunata mana dejayangayquipitam fisyu final junagchö Tiro y Sidon runacunapitapis masrä castigacäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum marca runacuna, ¿gamcunaga ‘Tayta Diospa ñöpanmanmi chäshä’ niyanquipischi? Tayta Diospa ñöpanman chäyänayquipa rantin gamcunaga infiernullamannam gaycucäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tsaynö nisquirnam discïpuluncunata nirgan: “Gamcuna willacuynïta willacuyaptiqui wiyayäshurga nogatapis wiyaycäyämanmi. Y gamcunata mana chasquiyäshogcunaga nogatapis manam chasquiyämantsu. Nogata mana chasquimag cagga cachamagnï Tayta Diostapis manam chasquiycäyantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsaypita juc ishcay semänacuna päsariptinnam ganchis chunca ishcay (72) discïpuluncuna willacuyanganpita cushishga cutiyargan Jesusman: “¡Runacunapita supaycunata poderniquiwan garguyaptï yargushgam, taytay!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tsaynam Jesus nirgan: “Au, musyämi supaycuna runacunapita yargungantaga. Ciëlupita tillagucur räyu ratamungannömi Satanaspa puëdeg caynin illagaycan. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nogam podernïta gamcunaman churargö, llapan mana allicunata jarurir päsayänayquipä. Tsaynö Satanaspa puëdeg caynintapis mana cäsuypa cayaptiquega imatapis mananam rurayäshunquinatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Runacunapita supaycunata gargur cushicuyangayquipitaga masrä cushicuyay jutiquicuna Tayta Diospa librunchö gellgaraycanganta”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tsaypitanam Jesus Espiritu Santupa munayninwan cushicur Tayta Diosta alabar caynö nirgan: “Papällä, ciëluchöpis cay patsachöpis imaycawan munayyogmi gamga caycanqui. Gamta alaballämi, Tayta Dios. Yachag tucogcunata tantiyatsinayquipa rantinga llänu runacunachömi tantiyatsicurguyqui nogata cachamangayquita. Tsaynö cananpä yarpangayquinöllam ruracashga, papällä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nircurnam discïpuluncunata nirgan: “Papällämi llapantapis munaynïman churamushga, tsurin captï. Noga imanö cangätapis payllam musyaman. Tsaynöllam papällä imanö cangantapis nogalla musyä. Tsaymi tantiyatsingä cagcunalla musyayanqui Tayta Dios imanö cangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsaypita discïpuluncunallawan caycarnam paycunata nirgan: “Gamcunam imata rurangäcunata ricar y imata yachatsingäcunata wiyar tantiyacuyanqui noga imanö cangätapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Unay profëtacunapis y mandacog reycunapis cay rurangäcunataga ricayta munayargannam. Ricamayta munarpis manam ricayämashgatsu. Tsaynömi noga willacungäcunata wiyayta munarpis mana wiyacuyashgatsu. Gamcunam sïga ricaycäyämanqui y wiyaycäyämanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsaypita juc cutichönam juc ley yachatsicog runa Jesus yachag canganta o mana yachag cangantapis musyananpä caynö tapurgan: “Taytay, ¿imatatä ruräman imaypis mana ushacag alli cawayman yaycunäpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tsaynö niptin Jesusnam nirgan: “Mä, puntata gamtarä tapurishayqui. ¿Imatatä tantiyanqui Moises gellgangan leycunata liyir?” ");
INSERT INTO qxoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Niptinnam tsay runa nirgan: “Mana ushacäcog alli cawayman runa yaycunanpäga tsay leycunachöga caynömi nican: ‘Llapan shonguyquiwan Tayta Diosman yäracur cawanqui. Tsaynö llapan voluntäniquiwan, llapan callpayquiwan, y llapan yarpayniquiwan munanganta ruranqui. Y runa mayiquicunatapis llapan shonguyquiwan cuyanqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tsaynö niptinnam Jesus nirgan: “Tsaytaga allitam nirguyqui. Tsay ningayquicunata cumplirga gampis mana ushacag alli cawayman yaycunquim”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tsaynö niptinnam tsay ley yachatsicog runa Jesusta yapay tapurgan: “Tsayöraga gampä ¿picunatä runa mayëga, taytay?” ");
INSERT INTO qxoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tsaynam Jesus “Puntataga wiyamayrä” nir caynö nirgan: “Juc runam aywaycänä Jerusalen marcapita Jerico marcaman. Tsaynö aywaycaptin ladroncuna pasaypa magacacharcur jatirangan röpanta y imaycantapis gechusquir wanushgatanö jagirir jegariyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Tsay nänipam aywaycänä juc sacerdöti. Tsayna wanushgatanöna runa jitaraycagta ricaycarpis tsay sacerdötega manapis ricag tucur päsacunä. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tsaypita sacerdötipa juc yanapagninpis tsaynöta ricaycar mana ricag tucullar yagacurir päsacunä. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Juc Samaria runana tsay nänipa aywaycar tsayman chänä. Israel runacuna Samaria runacunawan chiquinacuycarpis tsay Samaria runaga tsaynö yawarllana jitaraycagta ricaycur pasaypa cuyapasquinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tsayna acëtiwan y vïnuwan jampipaycur ratashcunawan wataparcur ashnunman muntarcatsir apanä patsacungan wayiyag. Nircur tsaychö payga jampir ichic jucläyanganyag täparänä. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tsaypita warayninna tsay cuyapäcog runa bulsicunpita gellëta jipisquir päganä tsay wayiyogta ishcay junag arupacur gänangantanö: ‘Cay geshyagta ricapaycällanqui cutimungäyag, taytay. Imachöpis masta gastacuptiquega cutimurmi pägalläshayqui’ ” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesus tsaynö willapayta ushasquirnam tsay ley yachatsicog runata tapurgan caynö nir: “Tsay quimsan runacunapita ¿maygan cagtä wanuycagna runa mayinta cuyapargan?” ");
INSERT INTO qxoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tsaynö niptinnam tsay runa nirgan: “Samaria runam, taytay” nir. Tsaynam Jesus nirgan: “Canan gampis tsay cuyapäcog runanölla runa mayiquita cuyapanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tsaypita aywacurnam Jesus discïpuluncunawan chäyargan juc tacshalla marcaman. Tsaychö Martapa wayinman Jesus chaycuptinnam pay patsatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa ñañan Marianam Jesuspa ñöpanman jamacuycurgan, Tayta Diospä parlapangancunata wiyayta munar. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martam itsanga tsay wayinchö imayca ruraynincunata ruracuycargan. Tsaymi imayca ruraynincuna captin Jesusta nirgan: “Señor Jesus, ¿imanirtä ñañä tsaychö jamaräcun noga caychö imayca ruraycunawan ñacaycaptï? Niycullay yanapamänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tsaynam Jesus nirgan: “Marta, ¿imanirtä tsaynö nimanqui? Gamga alläpa yarpachacunqui imapis rurayniquicunallapämi. ");
INSERT INTO qxoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tsay quiquiquipa rurayniquillapä yarpachacunayquipa rantinga Tayta Dios ningancunata yachacunayquipä cagtam yarpachacunayqui. Mariaga yachatsingäcunatam wiyaycäman. Tsaynö yachacungantaga manam pipis gechunganatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tsaypita juc cutichönam Jesus mañacuycargan Tayta Diosman. Mañacuyta ushasquiptinnam juc discïpulun Jesusta nirgan: “Discïpuluncunata Juan Bautista yachatsingannö nogacunatapis yachaycatsiyämay Tayta Diosman mañacuyänäpä, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsaynam Jesus nirgan: “Caynömi Tayta Diosman mañacuyänayqui: ‘Ciëluchö caycag Tayta Dioslläcuna, llapan runacuna gamta adorayälläshuy. Munangayquinö llapan runacunapis gamllaman yäracamur cawaycuyätsun. Ciëluchö munangayquinölla cay patsachöpis camacaycullätsun. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cada junagpä micuylläcuna ama faltaycatsillaytsu ari. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Runa mayï mana alli ricamaptinpis noga perdonangänölla jutsäcunapita perdonaycayämay. Jutsaman Satanas ishquitsiyämayta munaptinpis tsapaycayällämay, y yanapaycayällämay llutancunata imaypis mana rurayänäpä. Tsaynö caycullätsun’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nircur Tayta Diosman imaypis mañacuypä Jesus caynömi willapargan: “Juc runash pullan pagas aywanä amïgunpa wayinman: ‘Vicïnu, quimsa tantayquita mañacushayqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc amïgümi wayïman posadacamushga. Imalläpis manam caycapamantsu garaycunäpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tsaynö mañacuptinshi vicïnunga ninä: ‘¿Imanirtä cay örarä shamunqui tsayta mañacamag? Puncüpis trancashganam y wamräcunapis punucuycäyannam. Cay öraga manam gamta atiendiyta puëdïnatsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tsaynö nisquirnam Jesus caynö nirgan: “Sharcamuyta mana munaycarpis yaparir yaparir gayacuptinga vicïnun garangam miñishtinganta. Manam amïgun canganpitatsu garanga, sinöga pasaypa gayacuptin manana atiparmi. Yaga runacunapis tsaynö yanapacog caycaptinga Tayta Diosga masrämi yanapayäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Tsaymi Tayta Diosmanga imaypis mañacuyänayqui. Imata miñishtirpis rugacuyay. Puncupita gayacognörä mañacuyay. Tayta Diosman mañacogcunaga chasquiyanmi. Imata miñishtirpis rugacogcunaga tariyanmi. Gayacogcunataga Tayta Dios wiyanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Gamcunata maygayquitapis wamrayquicuna tantata mañacuyäshuptiqui ¿rumitatsurä aptaparcuyanquiman? Pescäduta mañacuyäshuptiquipis ¿culebratatsurä aptaparcuyanquiman? ");
INSERT INTO qxoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tsaynöpis runtuta mañacuyäshuptiqui ¿atapoguy curutatsurä aptaparcuyanquiman? ");
INSERT INTO qxoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gamcunaga mayläya yaga carpis wamrayquicunataga alli cagllatam garayanqui. Tsaynö gamcuna caycäyaptiquega ciëluchö caycag Tayta Diosga masrämi alli cagllata garayäshunqui. Tsay alli cagga Espiritu Santum”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cutinam upayashga runapita supayta Jesus gargurgan. Supay yargusquiptinnam tsay runa parlayta gallaycurgan. Tsaynö allïtsegta ricaycur runacuna espantacur cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tsaynö caycaptinpis waquin runacunaga niyargan: “Manam Tayta Diospa poderninwantsu supayta gargushga, sinöga supaycunapa mandagnin Satanaspa poderninwanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquinnam Jesusta tapog tucur niyargan: “Tayta Diospa poderninwan supayta gargungayquita musyayänäpä mastapis milagrutaga ruraramuy ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tsaynö parlaycäyanganta musyarnam Jesus nirgan: “Manam yarpaycäyangayquinötsu. Cay ningäta wiyarcayämay. Juc nacionchö runacuna quiquincuna pura chiquinacurga wanutsinacurmi ushacätsinacuyanman. Tsaynömi juc marcachö o juc wayichö tagcunapis quiquincuna pura chiquinacur wacpa caypa gargunacuycar ushacäyanman. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tsaynö caycaptinga gamcuna ama yarpäyaytsu Satanaspa poderninwan supaycunata gargungäta. Supaycunata mandagnin Satanas garguptinga poderniynagna ticrarmi ushacätsinacuyanman”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Gamcunachö waquin runacuna supaycunata runacunapita garguyaptin yarpäyanqui Tayta Diospa poderninwan garguyangantam. Tsaynö yarpaycarga ¿imanirtä nogapäga yarpäyanqui Satanaspa poderninwan supaycunata gargungäta? Tsay llutan yarpayniquicunawanmi manacagcunata parlayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nogata Espiritu Santo yanapamaptin supaycunata gargungäta ricarmi gamcuna musyayanqui Tayta Diospita salvacog rey shamungäta”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Satanaspita mas puëdeg canganta tantiyatsirmi Jesus mastapis nirgan: “Juc lïsu runa wayinta täpaycaptinga manam pipis imantapis suwapanmantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tsaynö täpaycaptinpis paypita mas puëdeg runa chaycurmi itsanga tucrunta gechurir imantapis apacunman. Tsay cuentanömi nogapis puëdeg caynïwan Satanaspa maquinpita runacunata jipiycä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nircurmi caynöpis Jesus nirgan: “Pipis ningäcunata mana cäsumag cagcunanam Satanaspa munayninchö cayan. Y nogata cäsumag cagga noga munangätam ruraycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Juc runapita supay yargucur jäcogcunapam aywan tänanpä ashirnin. Maychöpis mana tarirnam yarpasquin tärangan runaman yapay cutiycuyta. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tsaynö cutirnam taririn tsay runapa shongunta shumag churapacushga pitsapacushga wayitanörä. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsaynöta tariycurnam tsay runaman cutin paypita mas mana allin cag ganchis (7) supaycunata pushacurcurna tsay runachö cangan täcuyänanpä. Tsaymi puntata canganpitapis mas peyormanna ticracurin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus tsaynö parlaycaptinnam runacunapa chöpinpita juc warmi nimurgan: “¡Diospa willacognin cangayquipita ima cushishgarä wachaycushog y shacshatsishog mamayqui caycan!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tsaynö niptin Jesusnam nirgan: “Mamä cushicungannöllam Tayta Dios ninganta chasquicur wiyacogcunapis masrä cushishga caycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsaypitanam runacuna Jesus caycangan cagman goricäyaptin caynö nirgan: “Gamcunaga Tayta Diosman mana yäracog mana alli runacuna carmi milagrutarä ricayta munaycäyanqui. Gamcuna munayangayquinöräga manam ima milagrutapis rurashätsu. Tsaypa rantinga Tayta Dios juc milagrutam ruranga profëta Jonas cawaycaptin rurangannö. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Musyayangayquinöpis unay Jonastam jatuncaray pescädupa pachanchö caycanganpita yargatsimurgan. Tsaynömi nogatapis pamparangäpita cawatsimanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Salomonpa yachatsicuyninta wiyananpämi ‘Sabah’ ningan nacionpita juc reinapis caruta shamurgan Jerusalenman. Paypis fisyu final junagchö sharcamungam canan witsan runacunata ‘Salomonpa yachatsicuyninta noga chasquicungänö ¿imanirtä gamcunapis Tayta Diospa tsurin yachatsicunganta mana chasquicuyargayquitsu?’ ninanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Tsaynöpis Jonas Diospa willacuyninta willacuptin wiyar Ninive marca runacuna jutsa ruraynincunata jagiriyargan. Jonaspitapis mas imaycawan munayyog caycaptï willacungätaga canan witsan runacuna manam cäsucuyantsu. Tsaymi fisyu final junagchö Ninive runacuna sharcayämunga: ‘Jonas willacunganta chasquicuyangänö ¿imanirtä Tayta Diospa tsurin willacunganta chasquicuyargayquitsu?’ niyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tsaypitanam Jesus nirgan: “Actsita tsaritsir alërimanmi churantsic wayiman yaycogcuna shumag ricayänanpä. Manam imaypis tsaritsintsictsu catri jawancunaman churanantsicpäga. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Runacuna ricayänanpä actsi atsicyagnömi gamcunapis runacuna ricayäshunayquipä noga ningäcunata cäsuyänayqui. Nogata mana cäsumarninmi Tayta Dios munangantaga ruraycäyanquitsu. Tsaymi tantiyacuyanquitsu tsacaychönö jutsa rurag cayangayquita. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Waquin runacuna ‘Tayta Dios munangannömi cawaycä’ nicarpis manam rasunpaypatsu Tayta Dios munangannö cawaycäyan. Pagtatä tsay runacunanö cayanquiman. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Willacungäcunata rasunpis chasquicurga Tayta Dios cachamanganta shumagmi tantiyayanqui, tsacaychö actsiwan imaycacunatapis ricaycagnöna”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus parlayta ushasquiptinnam juc fariseo runa invitargan micuyänanpä. Tsaynam wayiman chaycur Jesus jamacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Israel runacunaga unay runacunapa üsuncunata cumplirmi manarä micur maquincunatarä awicuyag limpiu caycaptinpis. Tsaymi Jesus maquincunata mana awicullar micuycäyagta ricar yarpachacurnin invitag fariseo runa Jesusta ricapargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tsaynam Jesus nirgan: “Gamcunaga maquiquicunata awirpis pucilluyquicunata y matiquicunata janallanta awirir rurin ganrata dejaycognömi caycäyanqui. Pucillupa y matipa rurinchö ganra caycagnömi llutan yarpayniquicunawan y imaycapä mallag cayangayquicunawanga raccha shongu caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana tantiyacog runacuna! ¿Manacu musyayanqui Tayta Dioslla cuerpuyquicunata camar shonguyquicunatapis ruranganta? ");
INSERT INTO qxoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tsaymi shonguyquicunapis awishga cuenta cananpäga pobricunata cuyapar yanapayay. Tsaynö rurayaptiquimi Tayta Diospäga shonguyquicuna limpiu canga, manam maquiquicunallaga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Allau, fariseucuna! Gamcunataga Tayta Dios mana cuyapaypam castigayäshunqui. Gamcunaga templuman Tayta Diospä garaynin apayänayquipä huertayquicunapita mentatapis, anistapis ni imatapis chunca (10) aptay capuyäshuptiqui juc aptaytaga imaypis raquiycäyanquim: ‘Tayta Diospa palabran gellgaranganmanmi llapantapis cumpliycäyä’ nirnin. Tsaycunata rurarpis manam runa mayiquicunawan allega cawayanquitsu ni manam cuyapäyanquitsu. Nircur imata aunircurpis manam cumpliyanquitsu. Diospä ichic garayta apar cumplingayquinölla runa mayiquicunata alli ricayay, cuyapäyay, y imata aunirpis cumpliyay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Allau, fariseucuna! Gamcunata Tayta Dios mana cuyapaypam castigayäshunqui. Gamcunaga goricäcuyänan wayicunachö allin cag jamacunamanrä jamacuyta munaycäyanqui. Tsaynöpis gamcuna munaycäyanqui pläzacunachö yachatsicog cayangayquipita runacuna alabayäshunallayquitam”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Allau, Tayta Dios mana cuyapaypam castigayäshunqui! Gamcuna runacuna ricayäshunayquillapäga, ä alli tucuycuyanqui. Peru pamparanganchö ismushga ayanömi melanaypä caycäyanqui Tayta Diospäga. Tsaynö mana alli shonguyog cayangayquitaga runacuna manam musyayantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tsayta wiyarnam Moises gellgangan ley yachatsicog juc runa nirgan: “Tsaynö nirga nogacunatapis wiyaycätsiyämanquim, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Niptin Jesusnam nirgan: “¡Allau, gamcunapis ley yachatsicogcuna! Tayta Dios mana cuyapaypam castigayäshunqui. Gamcunaga runacuna imanö caytapis mana camäpacuyanganyagmi Moises gellgangan leycunaman yapa-yaparcur cumplitsiyta munayanqui. Tsaynö captinpis shumag alli tupayllapa yachatsiyänayquipa rantinmi ollgü tupayparä yachatsiyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Allau gamcuna! Tayta Dios mana cuyapaypam castigayäshunqui. Gamcunaga alli cayangayquita runacuna niyänallanpämi unay runacuna wanutsiyangan profëtacuna pamparäyangan jananchö capillancunarä rurapäyanquipis. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tsaynö ruraparpis profëtacuna gellgayangancunata mana cäsur paycunata wanutseg unay runacunanöllam gamcunapis caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Tsaynö captinmi imanö cananpä cagtapis musyar Tayta Dios unay nirgan: ‘Cachamushä willacog profëtäcunata y apostolnïcunata. Waquintam wanutsiyanga y waquin cagtanam chiquir ñacatsiyanga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Tsaynö cayangayquipitam gamcunata Tayta Dios juzgayäshunqui, Abelta wanutsegtanö, Berequiaspa tsurin Zacariasta altarpa ñöpanchö wanutsegtanö, y mas waquin profëtacunata wanutsegcunatanö”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Allau ley yachatsicogcuna! Tayta Dios mana cuyapaypam castigayäshunqui. Runacuna Diospa willacuyninta yachacuyta munayaptinpis yachag tucurmi llutancunata yachatsicuyanqui. Rasunpaga quiquiquicunapis Diospa willacuynintaga manam cäsuyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Tsaynö Jesus niptinnam ley yachatsicogcunawan fariseucuna ajanacurcuyargan. Tsaypitanam Jesusta rabyanapar tapupäyargan imaycaläya tapucuycunata Roma mandacogpa contran parlaptinga tsaynöpa prësuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesus tsaynö parlaycaptinrämi pasaypa atsca runacuna wayi ñöpanman goricäyargan. Tsaychö parlanganta wiyayta munarninmi cumanacur jarunacurrä caycäyargan. Tsaynam discïpuluncunata Jesus nirgan: “Fariseucunaga ‘Tayta Dios ningancunata llapantam ruraycä’ nicarpis manam cumpliyantsu. Pagtä paycunanö gamcunapis caycäyanquiman. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pacayllapa jutsa rurayniquicuna imay musyacarpis musyacangam. Manam ima rurayniquicunapis mana musyacagga cangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tsaynömi puncuta wichgarcur pacayllapa parlayangayquicunapis mayacanga. Ushacäcuy junagga imayca llutan rurayniquicunatapis Tayta Dios juzgangam”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Cuyay amïgücuna, nogapa willacuynïta willacuyaptiqui runacuna wanutsiyäshurpis almayquicunataga manam imanayangatsu. Tsaynö caycaptinga manam pitapis mantsacuyänayquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Paycunapita mantsacuyänayquipa rantinga Tayta Diosllata mantsacuyay. Paymi munayyog caycan almantinta infiernuman gaycunanpäpis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Pishgucuna runacunapä mana alläpa cuestaptinpis Tayta Diospäga välinmi. Payga manam gongantsu ni jucllayllatapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pishgucunatapis tsaynö ricaycarga gamcunatanäga masrämi Tayta Dios imanö cayangayquitapis ricaycäyäshunqui. Hasta agtsayquicunatapis yupashgatam payga caycätsin. Tayta Dios tsaynö ricaycäyäshuptiquega pipitapis ama mantsariyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Pipis nogaman criyicog canganta mana pengacuypa willacuptinga nogapis Tayta Diospa y angelnincunapa ñöpanchö paycunapa favorninmi parlashä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pipis nogapita pengacur willacuynïta mana willacuptinga nogapis Tayta Diospa y angelnincunapa ñöpanchö paycunata ‘Manam regïtsu’ nishämi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tayta Diospita shamungäta mana tantiyar nogapä llutanta parlayaptinpis Tayta Diosga perdonangam. Salvacog cangäta Espiritu Santo tantiyaycätsiptin conträ captinmi itsanga Tayta Dios imaypis perdonanganatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nogaman criyicamog cayangayquipitam goricäcuyänan wayicunaman, juezcunaman, y waquin autoridäcunaman apayäshunqui castigayäshunayquipä. Tsaychö ama llaquicuyanquitsu: ‘¿Imanöparä cananga salvacuycushä?’ o ‘¿Imatarä niycushä?’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Espiritu Santum tantiyatsiyäshunqui imata parlayänayquipäpis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Runacunapa chöpinpitam juc runa caynö nimurgan Jesusta: “Taytay, waugïta niycuy töcamangan cag herenciäta raquipämänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tsaynam Jesus nirgan: “Amïgu, manam juezniquitsu noga cä tsaynö nimänayquipäga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nircurnam runacunata nirgan: “Ama imapäpis mallagashga cayanquitsu. Alli cawayga manam imaycayogpis cayaptiquirätsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nircurpis Jesus caynö nirmi willapargan: “Juc rïcu runam murucunganpita pasaypa cosëchata gorinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tsayna tsay rïcu runa yarpachacunä: ‘Cananga ¿maymantä caytsica micuynïta churashä? Wayï manam aypannatsu churanäpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tsaynö yarpachacurna ninä: ‘Canan tröja wayïta pascasquirchir jucta sharcatsishä mas jatuncarayta. Tsaymanmi llapan goringä micuynïcunata y imaycäcunatapis churashä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tsaynö churacuycuptëga atsca watapämi micuynïcuna canga. Tsaynö churacuycurmi itsanga micur upyar cushishgallana cawacushä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tsaynö yarpachacurir caycaptinna Tayta Dios ninä: ‘¡Llutan yarpag malafë togshu! ¡Canan pagasmi gam wanunqui! Llapan churangayquicuna ¿pipärä quëdanga?’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tsaynö parlayta ushasquirmi Jesus nirgan: “Tsay rïcu runa, runa mayincunata mana yanapar wanungannömi llapan malafë runacunapis runa mayinta mana yanaparga Tayta Diospita imatapis chasquiyangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nircur discïpuluncunatapis Jesus nirgan caynömi: “Ama yarpachacuyanquitsu: ‘Canan ¿imatarä micushä? ¿Imatarä jaticushä?’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Micuynintsic mana captinpis röpantsic mana captinpis cushicushun Tayta Dios cawayta gomangantsicpita. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Shumag tantiyacuyay pishgucuna imanö cawayangantapis. Paycunaga manam murucuyantsu, manam cosichayantsu, ni tröjacuyantsu. Tsaynö caycaptinpis Tayta Diosmi micuynincuna faltätsintsu. Gamcunaga tsay pishgucunapitapis mas välegmi cayanqui Tayta Diospäga. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tsaynö imaycapä mayläya yarpachacurpis ¿pirächi tamäñunpita masllataga jatunyarcunman? ");
INSERT INTO qxoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Imaycapis ushacagcunallapa yarparäyänayquipa rantinga, imayca mana faltätseg Tayta Diosman yäracullar cawacuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tantiyacuyay waytacuna imanö cuyaypä tuctuyangantapis. Waytacunaga manam aruyantsu ni putscacuyantsu. Peru nicarpis imanö cuyayllapämi ricacuyan. Waytacuna cuyayllapä tuctungannöga manam unay rey Salomon jaticungan röpancunapis iwalargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tsay waytacuna tsaquirinanlla caycaptinpis Tayta Diosga ima shumagtam tuctutsin. Tsaynö cuyayllapäta tuctuycätsirga ¿manatsurä gamcunatanäga yanapayäshunquiman röpashga cayänayquipä, yäracuyniynag runacuna?” ");
INSERT INTO qxoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Tsaynö caycaptinga manam yarpachacuyänayquitsu imata micuyänayquipä ni imata upuyänayquipäpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsaycunata yarpachacurga puriyan Tayta Diosman mana yäracog runacunallam. Gamcunaga tsay mana yäracog runacunanö ama yarpachacuyaytsu. Tayta Diosga musyaycanmi imata miñishtiyangayquitapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tsay imapäpis yarpachacuyänayquipa rantinga Tayta Dios munanganta rurar cawayänayquipä cagta yarpachacuyayga. Pay munangannö cawayaptiquega imata miñishtiyangayquitapis Tayta Dios manam faltätsingatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Cuyay gatirämagnïcuna, ama llaquicuyaytsu. Gamcunatam Tayta Dios acrayäshurgayqui imayyagpis paywan cawayänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Capuyäshungayquita imayquicunatapis ranticusquir mana capogcunata yanapayay. Tsaynö runa mayiquicunawan cuyanacur cawarga ciëluchömi Tayta Dioswan imayyagpis alli cawayta chasquiyanqui. Tsaytaga mananam runapis suwangatsu ni puyupis ushangatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Imaycayogpis cayllapä cagta yarpachacurmi manana Tayta Diosmanga yarpäyanquinatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Gamcuna listacushga maya-mayallana caycäyay noga ciëlupita cutimuptï chasquicayämänayquipä. Casaracuy fiestapita patronnin cutimunanta empliyäduncuna shuyacogcunanölla nogatapis shuyacaycäyämanqui. Actsicurcur puncuta quichapänanpä shuyaragnölla gamcunapis listacushga caycäyay. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tsay patron illanganpita cutir yätsingannö shuyaycagta tariycur imanörä cushicur alabanman tsay empliyädunta. Mësaman jamaycatsir quiquin patronmi sirvinga. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tsay patron illanganpita imay öra chänanpä cagta mana musyar empliyäduncuna shuyacuyangannöllam, nogatapis maya-mayalla listacushga shuyacayämänayqui ciëlupita cutimunäta musyaycarga. Tsaynö shuyacaycäyämagta tariptëga imanö cushicuyrä gamcunapä caycunga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","“Manam pipis punucunmantsu ladron suwapänanpä cagta musyarga. Maya-mayallam waranman imancunatapis täpaycar. Tsay ladronta shuyacognölla gamcunapis maya-mayalla imaypis caycäyay, noga cutimunäpä cagta musyaycarga. Noga ciëlupita cutimushä mana yarpäyämangayqui öram”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsaynam Pedro tapurgan: “Tsaynö cay iwalatsicuycunawan yachatsicungayquega ¿nogacunallapäcu o llapan runacunapäwancu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Niptinnam Jesus nirgan: “Musyayangayquinöpis juc patron maypapis illarga mas yäracuypä cag empliyäduntam haciendanchö dejan imaycancunatapis shumag ricaycänanpä y waquin empliyäduncunatapis öranchö garar caycänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tsay patron illanganpita cutir yätsingannö llapantapis ruraycagta tariycur imanörä cushicur alabanman tsay empliyädunta. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Empliyädun tsaynö alli portacuptinnam paypa maquinmanna churanman llapan imaycantapis ricananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Peru mana yäracuypä cag empliyädum itsanga yarpan: ‘Patronnï manarämi rasllaga cutiramungarätsu’ nirnin. Tsaynö yarparnam empliyädu mayincunatapis magar ushan y fiestacunachö puricur, micur upyar cacun. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tsaynö caycagman patronnin mana yarpashgata illanganpita chaycurga empliyädun mana allicunata ruraycagta tariycur patronnin magacacharcurmi gargunga. Tsaynömi janan shongulla criyicogcunatapis Tayta Dios infiernuman gaycunga. Tsaychömi wagar quirutapis uchuyangaräga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","“Juc empliyädu mana musyayninpa imatapis llutanta ruraptinga patronnin manam alläpatsu castiganga. Peru patronnin ninganta musyaycar mana wiyacuypa llutancunata ruraptinmi itsanga patronnin pasaypa castiganga. Tsaynöllam pipis Tayta Dios munanganta musyaycar mana cumplirga castïguman gaycucäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Cay patsaman noga shamurgö chasquimag cagcuna salvashga cayänanpä y mana chasquimag cagcuna mana salvashga cayänanpämi. ¡Cay nicangäcuna maynapis ruracaraycanmanna! ");
INSERT INTO qxoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Peru tsaycuna ruracänan captinpis puntataga nogataran pasaypa ñacarcatsiyämarrä wanutsiyämanga. Tsaytam pasaypa llaquicur shuyarä hasta cumplinganyag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ama yarpäyaytsu nogaman criyicayämungayquipita mana chiquishga cayänayquipä cagtaga. Criyicamogcunataga imaypis chiquiycäyäshunquim. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpitaga nogaman criyicamunganpitam juc wayichö tagcuna quiquincuna pura chiquinacuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taytanmi tsurinpa contran canga y tsurinpis taytanpa contranmi canga. Mamannam wawanpa contran canga y wawannam mamanpa contran canga. Llumtsuyninmi suegranpa contran canga y suegrannam llumtsuyninpa contran canga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tsaypitanam runacunata Jesus nirgan: “Rupay ullunan cagpa pucutay yurimuptinga: ‘Tamyanganam’ niyanqui, y niyangayquinöllam tamyan. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tsaynömi imaypis Negeb regionpita vientumuptin: ‘Cananga rupacuypam achaycunga’ niyanqui, y niyangayquinöllam achan. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Mana tantiyacogcuna! Tsaycunatapis cösa tantiyaycarga ¿imanirtä tantiyayanquitsu Tayta Diospita shamushga car noga ruraycangäcunata?” ");
INSERT INTO qxoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Y nircur Tayta Dios cachamaptinga ¿imanirtä chasquiyämanquitsu? ");
INSERT INTO qxoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pagtä nogata mana chasquiyämangayquipita Tayta Dios infiernuman gaycuyäshunquiman. Imapitapis chiquinacungayqui quejayäshuyta yarpaptinga autoridäman manarä char arreglanqui. Tsaynö mana arreglaptiquega juezman apatsishuptiqui juezga wardiyacunawanmi carcelman wichgatsiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tsaypitaga manam rasllaga yarguyanquitsu jaga cayniquicunata llapanta mana pägacurga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tsaynam runacuna Jesusta willayargan caynö: “¡Galilea runacuna templuchö Tayta Diosta adorarnin ashmacunata altarchö rupaycätsiyaptinmi Pilato soldäduncunata cachanä tsay runacunata wanutsiyänanpä!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tsaynö willayaptinnam Jesus nirgan: “Ama yarpäyaytsu waquin Galilea runacunapita tsay wanog runacuna mas jutsayog car wanuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Manam Tayta Diospa castïgunwantsu paycuna tsaynö wanuyashga. Gamcunam itsanga Tayta Diospa castïgunwan infiernuchö ñacayanqui jutsayquicunata mana jagiyangayquipita. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tsaynömi Jerusalenchö Siloe törri juchur chunca puwag (18) runacunata wanutsirgan. Tsaynö captinpis ama yarpäyaytsu tsaychö quëdag runacunapita tsay wanog runacuna mas jutsayog cayanganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Manam Tayta Diospa castïgunwantsu paycunapis tsaynö wanuyargan. Gamcunam itsanga Tayta Diospa castïgunwan infiernuchö ñacayanqui jutsayquicunata mana jagirninga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsaynöpis mana cäsucog runacunata mana wayog hïgusman iwalatsirninmi Jesus caynö nirgan: “Juc runapa chacranchömi canä hïgus. Tsaynam duëñun aywanä hïgusninman ricapacog: ‘¿Mä wayuncush o manacush?’ nir. Tsay runaga tarinätsu ni jucllayllatapis prütanta. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsayna ninä chacran cuïdag runata: ‘Quimsa watanam shamü cay hïgusman pallag y manam ni jucllayllatapis tarirgötsu. Canan mutusquir jitariy cay chacrapita. Mana wayugtaga ¿imapätä ardëllaga cay chacrachöpis catsishun?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tsaynö niptinna chacran cuïdag runa ninä: ‘Taytay, mä juc wata shuyärishunrä ari. Cananga entërunpa ogtipärirmi wanun wiñapäshä. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsaynö ruraptïchir wayurga wayungarä. Tsaychö manana wayuptinga muturiycunquichir’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juc säbadu jamapay junagchönam runacuna goricäcuyänan wayichö Jesus yachatsicuycargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tsaychömi caycargan supay curcayätsingan juc warmi. Payga mana derichacaypam chunca puwag (18) watantin tsaynölla cacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tsay warmita ricaycurnam runacunapa ñöpanman päsaratsir Jesus nirgan: “Cananga allishganam canqui curcayashga cangayquipita” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tsaynö nirnin yataycuptinmi jinan öra allisquirgan. Allisquir derichacarcurnam tsay warmi Tayta Diosta alabargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tsaynam säbadu jamapay junagchö Jesus tsay warmita allïtsishga captin tsay goricäcuyänan wayichö mandacog runa ajacurcurgan. Tsaynö ajarninnam runacunata nirgan: “Jogta junagllam runacuna aruyänanpäga. Tsay junagcunachö shayämunquiman alliyta munarga. ¡Canan säbadu jamapay junagchörä gampis puricuycanqui!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsaynam Jesus nirgan: “¡Janan shongu yachag tucog runacuna! Gamcuna säbadu jamapay junagchö ¿manacu töruyquicuna ashnuyquicuna wataraptin pascasquir yacurcatsiyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cay Israel warmita allau chunca puwag (18) watantin Satanas geshyatsiptinmi curcayashga cacushga. Säbadu jamapay junagchö quiquiquicunapis ashmayquicunata cuyapäyangayquinölla, ¿imanirtä cay warmita cuyapayta yachayanquitsu?” ");
INSERT INTO qxoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tsaynö niycuptinnam chiquegnincunaga pasaypa pengacuyargan. Waquin runacunam itsanga cushicuyargan allita rurangancunata ricar. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Tsaynö mastapis Jesus yachatsirganmi caynö nirnin: “Tayta Diospa alli willacuyninga imayca ñäbuspa murunnöllam. Tsay ichiclla muru jegarcamurga jatunyarmi rämancunapis mashtacanganrä. Tsaynö captinmi rämancunaman pishgucunapis rataycur geshuncuna rurayan. Tsay ichic murullapita ñäbuspa räman mashtacangannömi Tayta Diospa alli willacuyninga maytsaymanpis chaycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Nircur mastapis yachatsicur Jesus caynömi nirgan: “Tayta Diospa alli willacuyninga levadüranöllam caycan. Juc runa tantata rurar quimsa arröba machcaman levadürata wiñaptinmi mäsaga shumag jacan. Tsay levadüra wallcalla caycar mäsata atscayätsir jacatsingannömi Diospa alli willacuynin maytsayman chaptin chasquicogcunapis masrä atscagyäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsaypita Jesus Jerusalenman aywarnam marcacunapa päsargan yachatsicuraycar. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tsaychömi juc runa tapurgan: “Taytay, ¿wallcagllacu cayan salvacogpä cagcuna?” nir. Tsaymi Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Atscag o wallcaglla captinpis gamcunaga imaycanöpa salvacionta ashiyay. Salvacur gloriaman yaycuyänayquipäga quichqui puncupanörämi päsayänayqui. Atscag yaycuyta munarpis wallcagllam yaycuyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Gamcuna ‘Diospa palabranta wiyangäpitam gloriaman yaycushä’ nirpis rasunpaga cawayniquicunachö manam cäsucuycäyanquitsu. Wanucuyangayqui öra tsaynö mana cäsucuyangayquipitam gloria wayiyog puncunta wichgacascamuptin gamcuna tacacuyanqui: ‘Puncuyquita quichapaycallämay, taytay’ nir. Tsay wayiyognam niyämushunqui: ‘Gamcunataga manam regïtsu. ¿Pirä cacuyanquipis?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsaymi gamcuna niyanqui: ‘¿Imanirtä regiyämanquitsu? Micurchä upurchä purirgantsic. Y marcäcunachöpis yachatsirguyquichä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Paynam niyämushunqui: ‘Gamcunaga manam cäsuyämarguyquitsu. ¿Pirä cacuyanquipis? ¡Ñöpäpita witicuyay, jutsasapa runacuna!’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Tsaynam ciëluman manana yaycur Abrahamta, Isaacta, Jacobta, y profëtacunata rurichö caycagta ricarnin pasaypa wagayanqui. Quiruyquicunatapis uchuyanquirämi yaycuyta manana puëdirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Maytsaypitapis shamog runacuna ciëluman yaycog cagmi itsanga Tayta Dios alistangan micuyta cushicurrä micuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tayta Dios munangannö cawagcuna cay patsachö mana alli ricashga carpis ciëlumanga yaycuyangam. Tayta Diosta mana yarpar lluta cawaychö cawag cagcunam itsanga infiernumanna gaycucäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tsaypitanam waquin fariseucuna chäyargan Jesus caycanganman caynö nir: “¡Caypita aywacuy cawayta munarga! Rey Herodesmi wanutsishuyta munan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tsaynam Jesus nirgan: “Pay wanutsimayta munaptinpis manam imapis gocamantsu. Canan warayllanam supaycunata runacunapita gargushä y geshyagcunatapis allïtsishä. Tsaycunallawannam cumplinga llapan ruranäpä cagcuna. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tsaypitarämi Jerusalenman aywashä tsaychö wanutsishga canäpä. Tayta Diospa willacognin profëtacuna Jerusalenchö wanuyangannömi nogapis Jerusalenchörä wanushä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerusalen runacuna! ¿Imanirtä Tayta Dios cachamungan profëtacunataga y alli willacuyninta willacogcunataga unaypitapis wanutsiyanquilla? Nogaga imanömi gamcunata goriyta munargö, imayca wallpa chipsancunata goriycur ogllagnöpis. Tsaynö goriyta munaycaptïpis gamcunaga munayniquicunata rurarmi cacuyarguyqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tsaynö cayangayquipita gamcunata Tayta Dios dejariyäshunquim y chiquiyäshogniquicunam munanganta rurar marcayquicunatapis ushacätsiyanga. Tayta Dios goricamaptin manam ricayämanquinatsu ‘¡Tayta Dios cachamungan salvayämaglläcuna shacallämuy!’ niyangayqui junagyag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tsaypita säbadu jamapay junagchönam Jesus aywargan juc mandacog fariseupa wayinman micog. Tsaychömi waquin fariseucunapis Jesus imata rurangancunatapis musyapacur caycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Y tsaychömi entëru cuerpun jacapäcuycag runapis caycargan. Jesus tsayta ricaycurmi ley yachatsicogcunatawan fariseucunata tapurgan: “Gamcunapä säbadu jamapay junag caycaptinpis cay runata ¿allïtsishwancu o manacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tsaynö niptin imatapis mana parlacuyaptinnam geshyaycag runata Jesus yataycurgan allisquinanpä. Alliscatsirnam nirgan: “Cananga aywacuyna wayiquipa” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nircurnam fariseucunata nirgan: “Maygayquipapis wamrayquicuna o ashmayquicuna pözuman ishquishga captin ¿manatsurä juclla jipeg aywayanquiman, säbadu jamapay junag caycaptinpis? Tsaynöllam nogapis geshyagcunata allïtsï säbadu jamapay junagchöpis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tsaynö niptin manam imaniytapis puëdiyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tsay fariseupa wayinchö waquin invitashgacuna, llapancunapitapis mas alli tucurmi, wap aywar mësamanrä jamascäriyargan. Tsayta ricaycurmi Jesus yätsirnin caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Pipis invitayäshuptiqui mësamanräga ama ras jamacuyanquitsu. Gamcunapita mas respitädu runa chämuptin: ‘Mësapita witicuy pay jamacunanpä’ niyäshuptiqui pengacushgam jamaraycäyangayquipita witicuyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Mësaman juclla jamacunayquipa rantinga shuyäriyanquirä, invitayäshogniqui ‘Amïgu, mësallaman päsacamuy’ niyäshungayquiyag. Tsaynö jamarayätsishuptiquim itsanga mësachö waquin jamagcunapis respitayäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tayta Diosga manam pitapis yanapantsu alli tucogcunataga. Payga imaypis yanapan llänu shonguyog mana runa tucogcunatam”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nircurnam wayinman invitag runatapis Jesus nirgan: “Invitanacur micungayqui öra ama gayatsinquitsu cuyanacungayqui cagllata, ni waugillayquita, ni castallayquita, ni rïcu cag vicïnullayquitaga. Tsaynö rurayaptiquega paycunapis cutitsiyäshunquillam. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tsaypa rantinga päsaratsinqui pobricunata, ratacunata, y gapracunata. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paycunaga manam ni imanöpapis cutitsiyäshunquitsu. Tsaytaga Tayta Diosnam cutitsiyäshunqui jutsaynag runacunata cawatsimungan junag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tsaynam jamaraycanganpita juc invitashga runa nirgan Jesusta: “¡Taytay, ima cushishgarä cayanga ciëluchö Tayta Dios alistangan micuyta micogcuna!” ");
INSERT INTO qxoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tsaynö niptinmi picuna micuyänanpä cagtapis Jesus caynö nir tantiyatsirgan: “Juc runam atsca runacunata invitanä juc junag wayinchö micupacur goyäyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tsaynam invitangan junagna empliyädunta cachanä tsay invitangan runacunata päsatsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tsayna empliyädun willag chaptin jucnin ninä: ‘Rantingä chacra ricagrämi aywanä caycan. Nogapita ama resentiycullätsuntsu’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jucagna ninä: ‘Pitsga par törücunam rantiycurgö. Tsaymi alli o mana alli jarungantapis musyanäpä yapyag aywaycä. “Yapaychönash shallämunga” niycullay’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y mas jucnin cagna ninä: ‘Tsayrämi casaracurgö y manam puëdimushätsu’ nir. Tsaynö nir llapanpis invitangan runacunaga mana aywayänätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tsayna tsay gayamog aywag empliyädun cutiycur patronninta willanä runacuna imanö niyangantapis. Tsaynö willaptinna patronnin pasaypa rabyacunä. Tsaypitana empliyädunta ninä: ‘Cällicunapa aywar pushamuy pobricunatapis, gapracunatapis, y ratacunatapis’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tsayna patronnin ninganta cumplir empliyädun ninä: ‘Cumplillargönam llapan nimangayquicunata, taytay. Mandamangayquinö llapanta päsaycätsimuptïpis wayiquiman manarämi runacuna juntäyantsu’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tsayna patronnin ninä: ‘Nänicunapapis y chacracunapapis aywar taringayqui cag runacunata imaycanöpapis pushamuy wayïman juntäyanganyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tsay yupay tucog invitangäcuna mayganpis micuyänanta mananam munänatsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tsaypita atscag runacuna gatiräyaptin aywaraycarnam Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nogaman criyicamunganpita taytan chiquiptinpis, maman chiquiptinpis, majan chiquiptinpis, o tsurin chiquiptinpis noga ningäta rurar imaypis cawatsun. Peru noga ningäcunata mana cäsumar mamanpa, taytanpa, majanpa, o tsurinpa munayninchö cacog cagga manam rasunpatsu discïpulü”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Imaycachö ñacarpis nogaman criyicamur cawayätsun. Wanunganyag noga ningäcunata mana cäsumag cagcunaga manam rasunpatsu discïpulü. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nogaman manana criyicamogcunaga juc runa wayi rurayta gallaycatsir dejaregnömi cayanqui. Pipis wayita rurananpäga shumagrämi yarpachacun tsay wayita ushananpä gastun aypanganta o mana aypangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pipis wayita gallar cimientuycullar dejasquiptinga llapan ricagcunam jamuräyan: ");
INSERT INTO qxoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Tagay runaga mana puëdiycar wayita rurar gallaycatsishga manapis ushananpä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Y tsaynömi juc nacion maygan nacionwanpis pelyananpäga cösarä yarpachacuyanman. Alli cösa yarpachacurirmi itsanga ninman: ‘Mä, ¿ishcay chunca waranga (20,000) soldäducunata juc chunca waranga (10,000) soldädulläwan vincïmancush o manacush?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pelyayta mana puëdinan captinga jucag cag mandag carullachörä caycaptinmi willacogninta cachanman: ‘Mananash pelyashunnatsu. Munangayqui cagtash imäcunatapis apacunqui’ nir willananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tsaynölla discïpulü cayman manarä yaycur llapan imayquicunatapis noga raycur dejariyänayquipä cagtarä shumag yarpachacuyay. Imayquicunatapis jagiriyta mana munarga manam discïpulü cayanquimantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Gamcunaga cay patsachö cachinömi cayanqui. Micuyta cachi gustuta manana gor imapäpis mana välegnömi gamcunapis Tayta Dios munangannö mana cawarga imapäpis väliyanquitsu. Gamlagyashga cachita pipis jichariyangannömi gamcunatapis infiernuman Tayta Dios gaycuyäshunqui. Cay ningäcunata wiyag cagga tantiyacuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tsaypitanam impuestu cobracogcunawan Diosta mana cäsucog runacunapis aywayargan Jesus parlanganta wiyayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tsayta ricaycurnam fariseucunawan ley yachatsicogcuna Jesusta jamurar niyargan: “¿Imanirtä cay runaga Diosta mana cäsucogcunawanpis goricaycur micuycan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsaynö niyaptinmi Jesus iwalatsicuywan parlapargan: ");
INSERT INTO qxoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pipis pachac (100) üshanpita jucta ograycurga ¿manatsurä waquin cagcunata juc puchaman goriycur juclla aywar ashinman hasta taringanyag? ");
INSERT INTO qxoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tariycurga cushishgagachi matancarcur apacunman. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wayinman chaycurga vicïnuncunatapis amïguncunatapis cushicurchi willapanman: ‘¡Ograngä üshätam tariycamurgö!’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tsaynö willaparnam Jesus nirgan: “Tsay runa üshanta tarisquir cushicungannöllam Tayta Dioswan angelnincunapis cushicuyan juc runa jutsancunata jagirir Tayta Diosta chasquicuptin. Isgun chunca isgun (99) alli cawag runacunapä cushicuyanganpita masrämi cushicuyan jucllayllapis jutsallachö cawacog runa jutsanta dejarir Tayta Diosta chasquicuptin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tsaynö pï warmipis chunca gellëninpita jucta ograycur ¿manatsurä actsita tsarircatsir juclla ashinman wayintapis pitsapacur ograngan gellëninta taringanyag? ");
INSERT INTO qxoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ashiycanganta tariycurga wayinchö cushicurninchi willacunman: ‘¡Ograngä gellënïtam tarisquirgö!’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tsaynömi Tayta Dioswan angelnincunapis cushicuyan juc runallapis jutsa rurayninta jagirir Tayta Diosta chasquicuptin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mastapis Jesus caynö nirganmi: “Juc runapash ishcay ollgu tsurincuna canä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tsayshi gepa cag tsurin papäninta ninä: ‘Papä, nogata töcamangan cag herenciä goycamänayquitam munä’ nir. Tsaynö niptinshi papänin raquipaycunä paypä cagcunata”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Tsaypita juc ishcay junagllatanash llapan chasquingancunata ranticuscärinä. Nircur tsay gellëninta apacurcur aywacunä juclä caru marcapa. Tsaychönash munanganta rurar llapan gellëninta manacagcunallachö usharinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","15","Tsaypita ushacäpacusquirga imanö caytapis mana puëdir mallagänäna. Y tsay marcachö muchuy gallaptinna tsay jövinga pasaypa mallagar aruyta ashinä. Tsayna juc hacendädu runa chasquinä cuchinta mitsitsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cuchita mitsirnash pasaypa mallagar cuchipa micuynintapis micuytana munanä. Tsaynö mallagaptinpis micuy mana captinshi pipis garanätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Tsayshi yarpachacunä: ‘Papänïpa arognincunaga pachajunta micurchir caycäyan, noga caychö mallagay wanunaycaptï. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Caynö canäpa rantinga papänï cagpa cuticushä. Chaycurga caynömi nishä: “Papä, perdonaycallämay. Gomangayquicunata manacagcunachö usharmi jutsata rurargö. Manam gam munangayquinötsu ni Diosnintsic munangannötsu cawargö. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cananpitaga ama cuentamaytsu tsuriquitanöga. Juc mincayniquitanöllana chasquiycallämay” nir’. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tsaynö yarpachacusquir cuticunä papänin cagpa”. “Tsayshi wayinman carulällatarä aywaycagta ricaycur papänin cuyapaywan cörrilla taripagnin aywar pasaypa cushicuywan macallacurcunä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tsayshi tsuringa yarpangannö ninä: ‘¡Perdonaycallämay, papä! Gomangayquicunata manacagcunachö jutsata rurarmi ushargö. Manam gam munangayquinötsu ni Diosnintsic munangannötsu cawargö’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tsaynö parlapar manarä ushaptinshi papäninga empliyäduncunata ninä: ‘Mas alli röpacunata ras jipiyämuy trocacunanpä. Tsaynö sortïjata y zapatuta jipiyämuy jaticunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nircur weran cag torïtuta pishtayay. ¡Canan itsanga fiestata rurashun! ");
INSERT INTO qxoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Cay tsurëga wanunganpita cawarimognömi! ¡Ogracanganpitam cutimushga!’ Tsaynö nir cushicurnin fiestata rurayänä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tsaynö fiestachö cayanganyag mayor cag tsuringa chacrachö arucuycänä. Tsaypita wayinpa aywaycanganchöga wiyanä wayinchö cushicurnin fiestachö caycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsayna juc wätayninta gayaycur tapunä imanir fiestata ruraycäyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tsaynö tapuptinna willanä caynö: ‘Waugiquim cutimushga. Tsay cushicuywanmi papäniqui pishtatsishga weran cag torïtuta’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tsaynö willaptinshi pasaypa payga rabyarnin wayinman yaycuyta munanätsu. Tsaynash papänin aywar ruganä wayiman yaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tsayshi papäninta ninä: ‘Papä, gam musyangayquinöpis maypapis mana yarguypam yanapaycä llapan nimangayquicunata rurar. Tsaynö yanapaycaptïpis imaypis manam goycamargayquitsu ni juc cabrallatapis amïgücunawan fiestata rurar micurcuyänalläpäpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","¡Cay gela tsuriqui jutsa rurayllachö cawacog warmicunawan gellëniquita ushasquir cutiycamuptinmi itsanga pishtatsirguyqui weran cag torïtutarä!’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tsaynö niptinnash taytan ninä: ‘¡Aumi, hïju! Gamga mana yargucuypam nogawan caycällanqui. Tsaymi llapan imaycäcunapis gamllapäna. ");
INSERT INTO qxoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Peru waugiqui jutsa rurayninta jagirir cutimushga caycaptinga, ¿imanirtä cushicuypita fiestata mana rurashwantsu?’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tsaypita discïpuluncunata yachatsirmi Jesus nirgan: “Patronninmi juc mayoralninta churanä imaycanwanpis munayyog cananpä. Tsaypita patronta runacuna willapäyänä imaycancunatapis lluta tsay mayoralnin ushaycanganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsayta musyaycurna patronnin gayaycatsimurnin ninä: ‘Runacuna gampä parlayan imäcunatapis llutalla ushaycangayquitam. Cananga cuentata gomay llapan imata rurangayquitapis. Cananpitaga mananam imaycäcunawanpis munayyognatsu canqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Tsaynö niptinna tsay mayoralga quiquillanchö yarpachacur ninä: ‘¿Imatarä canan rurashä patronnï gargamaptinga? Manam callpäpis cantsu chacrachö arunäpä. Limushna mañacuytapis pengacümi. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Alfin patronnï gargamaptinpis amïgücuna canmi chasquiyämänanpä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tsaynö yarpachacurcur patronninpa jagan cag runacunata juc jucllaylla gayaycatsimur punta cagta tapunä: ‘¿Aycatä patronnïpa jagan canqui?’ ");
INSERT INTO qxoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tsaynö tapuptin jucnin cag ninä: ‘Paypa jagan cä ishcay pachac (200) lata acëtim’. Tsayna tsay mayoral ninä: ‘Canan cay recïbuchö firmamuy, pachac (100) latallatana päganayquipä’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Tsaypita jucnin cagtana tapunä: ‘Gamga ¿aycatä jagan canqui?’ Tsayna tsay runa ninä: ‘Paypa jagan cä ishcay waranga (2,000) arröba trïgunmi’. Tsaynö niptinna ninä: ‘Canan cay recïbuchö firmamuy, juc waranga pitsga pachac (1,500) arröballatana päganayquipä’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","9","“Tsay mayoral rurangan mana alli caycaptinpis patronninga payta caynö alabanämi: ‘¡Tsay runaga amishtä rurayta yachanmi, arucuyninpita yargusquir imanö cawananpäpis!’ nir”. Tsaynö willapärirnam Jesus nirgan: “Manam munätsu gamcuna tsay runanö manacagcunata rurayänayquita. Gamcunapis amishtäta rurayay capuyäshungayqui cagcunallawanpis, peru sïga noga yachatsicungäta willacuyaptiqui chasquicur ciëluman aywayänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","12","Alli amïgun cangayquita regishunayquipä imanta paytacuycushuptiquipis ama ricapacunquitsu. Tsaypa rantinga cuïdapanqui. Tsaynö honrädu captiquega Diospa willacuyninta willacuyaptiquipis chasquishunquim. Y mana yäracuypä cayaptiquega manam cäsuyäshunquitsu ni imapäpis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tsaypita caynöpis Jesus nirganmi: “Manam pi runapis ishcay patrontaga sirvinmantsu. Ishcanta sirvirga jucag ningantam ruran y jucagtaga manam cäsunnatsu. Tsaynömi gellëllapä yarparag runacuna Tayta Dios ningantaga rurayanquinatsu. Tsaymi rïcu cayllapä yarpachacuywan Tayta Dios munangannöga cawayanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tsaynö yachatsingancunata wiyarnam gellëllapä ayrayashga fariseucuna Jesuspita asicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tsaynam Jesus nirgan: “Gamcuna runacunapa ñöpanchö alli tucuyaptiquipis Tayta Dios musyaycanmi gamcunapa shonguyquicuna imanö cangantapis. Tsaymi imanöpis cayangayquita mana musyar runacuna respitayäshuptiquipis Tayta Diospäga tsay alli tucungayquicuna melanaypä caycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moises gellgangancunachöpis, Tayta Diospa profëtancuna gellgayangancunachöpis y Juan Bautista willacungancunapis nican noga salvacogniquicuna cay patsaman shamunäpä cagtam. Tsaymi Juan willacur gallanganpitapis runacuna Tayta Diospa willacuynintaga chasquicuycäyan. Tsaynö captinpis waquin runacunaga manam munayantsu willacuyninta willacuyänanta, sinöga imaycanöpapis tsapatam churapaycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Tsaynö nogapa willacuynïtana chasquiyaptinpis ama yarpäyaytsu profëtacuna gellgayangan mana cumplinanpä cagta. Cay patsa y ciëlu juc junag ushacaptinpis profëtacuna gellgarangancunaga llapanmi cumplinga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pï runapis majanpita raquicasquir jucwan targa tsay runa adulteriu jutsatam ruraycan. Tsaynöllam majanpita raquicashgawan pipis targa jutsata ruraycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tsaypitanam Jesus willapargan caynö nir: “Juc rïcu runam canä selläma alli röpacunallata jatirag. Cada junag amïguncunawan fiesta rurayllachö car alli micuycunallata micuyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tsay rïcu runapa wayi puncunchö limushna mañapacog Lazaro jutiyog runa jamaränä entëru garanpa geri ushashga. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Payga ‘Rïcu runapa mësanpita micuy shicwagllatapis, imanöparä micurcamüman’ ninä. Y tsaychö allgucunapis Lazarupa gerinta lagwapäyänä. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tsaypita Lazaro wanusquiptinga angelcuna apacuyänä ciëlupa Abraham caycangan cagman. Y rïcu runa wanuptinna castancuna pampayänä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Tsay rïcu runapa alman infiernuchö rupanä. Tsaychö rupaycarna carupita ricasquinä ciëluchö Lazaro Abrahampa ñöpanchö caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsayna rïcoga gayacunä: ‘Tayta Abraham, cuyapaycallämay. Lazaruta cachaycallämuy dëdunta yacuwan ushmarcatsir shimïta ogurcatsipamänanpä. Cay ninachö rupar manam awantänatsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Tsaynö niptinna Abraham ninä: ‘Hïju, yarpay gam imaycayqui jananchö cangayqui öra alli vïdallachö cawangayquita. Lazaroga pobri carnin pasaypam ñacargan. Tsaymi payta cananga caychö cushishga cay töcan y gamtanam tsaychö ñacacuy. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y jinachöpis pasaypa mantsaripä wanyaycag ragram jarcämantsic. Tsaymi gam cangayqui cagman pipis tsimpamuyta puëdintsu ni gampis puëdimunquitsu tsimpamuyta cay nogacuna cagman’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tsaynö niptinna rïcu runa ninä: ‘Tayta Abraham, rugacungä raycur papänïpa wayinman Lazaruta cachaycullay. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tsaychö pitsgarämi waugïcuna caycäyan. Paycunata willaycamutsun cay ñacayman mana shayämunanpä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahamna ninä: ‘Paycuna tsaräyanmi Moises y waquin profëtacuna gellgayangan Bibliata. Tsaychö ningancunata cäsucuyätsun’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Tsayna rïcu runa ninä: ‘Tayta Abraham, tsay Bibliata tsarararpis tsaytaga manam cäsucuyangatsu. Juc runa wanunganpita cawarircur willacuptinmi itsanga jutsa ruraynincunata jagiriyanman’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Tsaynö niptin Abraham ninä: ‘Bibliatapis mana cäsuycarga wanunganpita cawarircur willacog cutiptinpis manam cäsuyangatsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tsaypita juc cutinam discïpuluncunata Jesus nirgan: “Jutsata rurayänayquita Tayta Dios mana munaptinpis jutsaman ishquitsicogcunaga imaypis cangam. Paycunataga mana cuyapaypam Tayta Dios castiganga. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nogaman criyicamogcunata pagtä pitapis jutsata ruraycätsiyanquiman. Tsaynö runacunataga mejormi jatuncaray mulinu rumita cuncanman wataparcur lamarman jitarpuyanman. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Musyayanquinam gamcunapis. Pagtatä jutsaman ishquitsicogcunanö cayanquiman”. “Runa mayiqui imachöpis mana allita rurayäshuptiqui llutanta ruraycanganta shumag tantiyatsinqui. Tsay llutan rurayninta yarpachacusquir ‘Perdonaycallämay’ niyäshuptiquega perdonayanqui mana ajanaypa. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pipis juc junagchö ganchis (7) cuti mana allita ruraycushur ‘Perdonaycallämay, cananpitaga mananachir gampä mana allita ruraycushätsu’ niyäshuptiquega perdonaycunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tsaynö niptinnam apostolnincuna Jesusta niyargan: “Taytay, gamman yäracayämuptïpis ajam ningayquicunata cumpliyga. Yanapaycallämay imaypis gamta cäsucuyänäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tsaynö niyaptinnam Jesus nirgan: “Nostäza murunöllapis yäracuyniquicuna ichic captinga cay jachata ‘Matsupita lluquicasquir lamarman jawicäramuy’ niyaptiquipis jawicäramunmanmi. Tayta Diosman rasunpaypa yäracuyaptiquega manam imapis ajatsu gamcunapä canga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Manam ima patronpis, empliyäduncuna yapyanganpita o mitsicunganpita chasquiptin: ‘Jamacullay micunayquipä’ niyantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tsaypa rantinga llapanpis niyan: ‘Cusnacamuyrä garamänayquipä. Noga micaramuptïran gamga micunqui’ nirmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tsaynö mandanganta ruraycaptinpis manam pipis agradesicuntsu tsay empliyädun rurananpä cagllata rurashga captin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Tsay empliyädunöllam gamcunapis Tayta Diospäga cayanqui. Tsaymi Tayta Dios munanganta rurarpis mana yarpäyänayquitsu ‘Payga alli ruragmi’ niyäshunayquipä cagtaga. Tsaypa rantinga niyay: ‘Nogacunaga Tayta Diospa empliyädunmi cayällä. Tsaymi pay munangallanta rurayällä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalen marcaman aywaraycarnam Jesus discïpuluncunawan päsayargan Samaria y Galilea provinciacunapa lindërunpa. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tsaypita juc tacshalla marcaman chäyänanpä caycaptinmi leprawan geshyaycag chunca (10) runacuna Jesusta ricasquiyargan. Tsaymi carulällapita gayacuyargan: ");
INSERT INTO qxoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Tayta Jesus, ¡nogacunata cuyapaycayällämay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","15","Paycunata ricaycurnam Jesus nirgan: “Aywayay sacerdöticunaman allishgana cayangayquita musyatsicayämunanpä”. Tsaynö aywaycäyangantam geshyancunapita llapancunam allisquiyargan. Alliyanganta cushicurninmi jucnin cag runa cutiycurgan: “Cay geshyäta alliycatsimangayquipita Tayta Diosta alaballämi” niraycar. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspa ñöpanman chaycurnam gonguricuycurgan “¡Agradesicullämi alliycatsimangayquipita, Taytallä Jesus!” nir. Tsay runaga cargan Samaria marcapitam. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tsaynam Jesus nirgan: “Allegcunaga cayarguyqui chuncagchä. ¿Maytä waquin cagga? ");
INSERT INTO qxoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cay juclä marca runallam cutiycamushga Tayta Diosta ‘Gracias’ nicur alabarnin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tsaynö nisquirnam tsay runata Jesus nirgan: “Sharcur aywacuy. Tayta Diosman yäracuyniquipam salvacashgana canqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Juc cutinam Jesusta fariseucuna tapuyargan, “¿Imaytä salvacogta Tayta Dios cachamunga allina cawanantsicpä? Salvacog chämunanpäna canganta musyayänäpä ¿ima señalcunatä canga?” nir. Tsaynam Jesus nirgan: “Manam ima señaltaräga ricayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manam pipis niyäshunquirätsu ‘Caychömi o washachömi señalta ricargö’ nir. Tayta Diosga salvacogta cachamushganam gamcuna mana cuentata gocuyaptiquipis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsaynö nisquirnam discïpuluncunata nirgan: “Ciëluman aywasquiptï gamcuna llaquicuywanmi cutimunäta munayanqui. Tsaynö munayaptiquipis manam jucllaga cutimushärätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Runacuna niyanga ‘Tayta Dios cachamungan salvacog caychömi’ o ‘Wacchömi caycan’ nirnin. Tsaynö niyaptin ama llutallaga criyiyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ciëluchö tillagucuy jucagläpita jucagläyag atsicyaptin runacuna ricayangannömi noga ciëlupita cutimogtapis llapan runacuna ricayämanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tsaycuna manarä päsaptinmi puntataga runacuna chiquiyämar pasaypa ñacatsiyämanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Unay Noe cawanan witsan mana yarpashgata Tayta Dios diluviuta cachamungannömi nogapis mana yarpashgata cutimushä. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tsay witsanga diluviu manarä captin runacuna micur, upyar, casaracurmi cacuyargan. Tsaynö cawacuyargan Noe büquitanö arcata ruraycur tsayman yaycungan junagyagmi. Tsaynö caycagman Tayta Dios pasaypa tamyata gallatsipaycamuptinmi cay patsaman yacu juntargan. Tsaynöpam arcaman mana yaycog cag runacuna llapan ushacäyargan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Tsaynömi Lot cawanan witsanpis Tayta Diospa castïgun mana yarpashgata shamunanpä canganta mana musyarnin runacuna micur, upyar, rantir, ranticur, murupacur, y wayitapis sharcatsir caycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma marcapita Lot yargusquiptinnam itsanga ciëlupita nina tamya unyamurgan. Tsaychömi llapan runacuna rupaycar ushacäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nogapis tsaynöllam runacuna mana musyayangan öra illagpita cutimushä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Tsay junagga wayichö caycagcuna ama imayquicunamanpis jipeg yaycuyanquinatsu. Tsaynölla chacrachö caycagcunapis wayinman amana cutiyätsunnatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yarpäyay Lotpa warmin marcanman cuticuycuyta munanganpita wanunganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pipis noga munangänö mana cawar quiquinpa munayllanman cawacog cagga manam gloria vïdaman changatsu. Pipis willacuynïta chasquicur Tayta Dios munangannö cawag cagmi gloria vïdachöga cushishga cawanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Cutimungä junag juc cämallachö ishcag punuycagcunapita nogaman criyicamog cagtam apacushä y mana criyicamog cagtanam jagirishä. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Maraynincunachö ishcag agacuycag warmicunapita nogaman criyicamog cagtam pushacushä y mana criyicamog cagtaga jagirishämi. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tsaynömi ishcag runacuna chacrachö aruycagpita nogaman criyicamog cagta pushacushä y mana criyicamog cagtanam jagirishä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsaynam tsayta wiyaycur discïpuluncuna tapuyargan: “Tsaynö captinga ¿maymantä apayämanquega, taytay?” nir. Tsaynö tapuyaptinnam Jesus nirgan: “Tsunyagcunachö wiscurcuna tumaycachar musyatsicuyan maychöpis wanushga ashma jitaraycangantam. Tsaynömi noga ningäcuna ruracagta ricar musyayanqui noga cay patsaman cutimunäpäna cagta”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mana ajayaypa Tayta Diosman mañacuyänanpämi cay iwalatsicuywan discïpuluncunata Jesus yachatsirgan caynö nirnin: ");
INSERT INTO qxoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Juc marcachömi juc juez canä Tayta Diosta mana mantsacog ni runacunatapis mana cuyapag. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tsay marcachö täcog canä juc viüdapis. Payga tsay juezman aywanä atsca cutina ‘Quejacungäta ¿imaytä arreglaycamanqui, taytay?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Tsaynö cutillana cutiptinpis juezga mana cäsunätsu. Nicanganta itsanga tsay juez yarpachacur ninä: ‘Diosta mana mantsapacurpis ni runacunata mana cuyaparninpis cay warmipa demandunta juclla arreglaycushä. Mana arreglaptëga imaycay örapis cutiycämungallam fastidiamar umätapis nanatsirnin’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Tsaynö willapärirnam Jesus nirgan: “Tsay juez mana alli caycarpis viüda quejacunganta arreglaycaptinga ¿Tayta Dios manatsurä cäsuycuyäshunquiman payman yäracogcuna pagasta junagta mañacuyaptiqui? Tayta Diosga ima mañacuyangayquitapis manam shuyarätsiyäshunquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tsaynö rugacur mañacog cagtaga Tayta Dios mana shuyarätsiypam yanapanga. Peru itsanga noga cay patsaman cutimur ¿gamcunata tariyäshayquirätsurä Tayta Diosllaman yäracur pay munangannö caycagta?” ");
INSERT INTO qxoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Juc cutichönam Jesus willapargan waquin runacuna alli tucur juccunata jamuräyanganta caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcay runacunam aywayänä templuman Tayta Diosman mañacuyänanpä. Jucnin cag canä fariseo y jucagna canä mana alli ricashga impuestu cobracog runa. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tsay fariseo cag runaga ichircur caynö mañacunä: ‘Gracias, Dios Taytay. Gamta agradesicümi waquin cag runacunanö mana cangäpita. Paycunaga cayan suwacogmi, mana alli ruragmi, majancunata engañar adulteriu jutsata ruragmi. Manam nogaga tagay impuestu cobracog runanöga cätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nogaga ayunäpis ishcay cutim cada semänachö. Tsaynöllam arur gänangäpita diezmutapis gollämü templuman’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Impuestu cobracog cag itsanga carulällaman ichicuycunä. Payga jutsasapa car ciëlumanpis mana ichicllapis ñuquinätsu, sinöga feyupa llaquicur ninä: ‘Cuyapämar perdonaycallämay, Tayta Dios. Nogalläga jutsasapa runam callä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tsay impuestuta cobracog cagga wayinman cutinä jutsanpita perdonashgana. Fariseo cagtam itsanga Tayta Dios perdonanätsu. Tsaynömi pipis alli canganta parlacachag cagtaga Tayta Dios pengacatsinga. Jutsa rurayninta tantiyacur perdonta mañacog cagtaga allim ricanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsaypita juc cutichönam runacuna Jesusman pishi wamrancunata apapäyargan maquinta umancunaman churar Tayta Diosman mañacapänanpä. Jinatanam discïpuluncuna michar cutitsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsayta ricarnam Jesus nirgan: “¡Ama michäyaytsu nogaman wamracuna shayämunanta! Pipis cay wamracunanö llullu shongu cagcunatam Tayta Dios glorianman päsatsinga. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wamra papänincunaman yäracungannö pipis Tayta Diosman mana yäracogcunaga manam gloriaman yaycuyangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juc cutichönam juc mandacog rïcu runa Jesusta nirgan: “Taytay, gamga alli rurag runam canqui. Mä niycamay, ¿imatatä ruräman gloria vïdaman chänäpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tsaynam Jesus nirgan: “¿Imanirtä alli rurag cangäta nimanqui? Manam pï runapis alli ruragga cantsu. Tayta Diosllam alli ruragga. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gam mandamientuncuna caynö ninganta musyanquinam. ‘Ama adulteriu jutsata ruranquitsu. Ama runa mayiquita wanutsinquitsu. Ama suwacunquitsu. Ama runa mayiquita manacagta tumpanquitsu. Papäniquita mamayquita respitar alli ricanqui’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tsaynö niptinnam tsay runa nirgan: “Taytay, tsaycunataga wamra cangäpitachä cumpliycä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tsaynam Jesus nirgan: “Tsaynö llapanta cumpliycarpis Tayta Diosman criyicungayqui musyacänanpä jucta ruranayquiran faltäshunqui. Canan llapan imaycayquicunatapis ranticuscärir pobricunata aypuy. Tsayta rurarga jana patsachö mana ushacag riquëzatam chasquinqui. Nircur nogaman yäracamur aywacamuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tsaynö Jesus niycuptinmi itsanga runa yarpachacur wamayashga jegasquirgan alläpa rïcu carnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tsaynö wamayacurcogta ricarnam Jesus nirgan: “¡Ajallarämi rïcu runacuna Tayta Diospa glorianman yaycuyänanpäga! ");
INSERT INTO qxoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tsaypa rantinga mas fäcilchi jatuncaray camëllu ashmapis aujapa uchcunpa ullusquinman, juc rïcu runa gloriaman yaycunanpä cagpitaga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tsaynö niptin wiyagcunanam Jesusta tapuyargan: “Tsaynö captinga ¡pirä salvacunga, taytay!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tsaynam Jesus nirgan: “Runacuna quiquincunallapitaga manam salvacionta tariyantsu. Tayta Diosmi pitapis jutsancunapita perdonar salvan. Paypäga manam imapis ajatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niptinnam Pedro nirgan: “Taytay, nogacunaga llapan imaycäcunatapis jagisquirmi gamta gatiraycäyä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Tsaynö niptin Jesusnam nirgan: “Alli willacuynïta willacur pipis wayinta, warminta, wauginta, paninta, mamanta, papäninta, tsurincunata jagireg cagga jaginganpita atsca cuti mastam cay patsachö taringa. Ñacatsiptinpis willacuynïta willacogcunaga gloria vïdachömi imayyagpis mana ushacaypa cawanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tsaypitam chunca ishcay (12) apostolnincunata gayaycur Jesus nirgan: “Musyayanquim Jerusalenpa aywaycangantsicta. Tsaychömi noga Tayta Diospita shamogta wanutsiyämanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Israel autoridäcunam Roma autoridäcunapa maquinman apatsiyämanga. Tsaychömi nogapita burlacuyanga, ashlliyämanga, togapäyämanga, astayämanga, y wanutsiyämanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Peru wanutsiyämanganpita quimsa junagtaga cawarimushämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tsaynö niptin discïpuluncunaga manam tantiyayargantsu imapä parlaycangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tsaypitanam Jerico marcamanna Jesus discïpuluncunawan yaycuraycäyargan. Tsaychömi näni cuchunchö jamaraycargan juc gaprayashga runa limushnata mañacur. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tsaynam atsca runacuna aywaycäyagta mayarnin tsay gapra tapucurgan: “¿Imatä callan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tsaynam runacuna willayargan: “Jesus Nazaret runam päsaycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tsaynö willaycuptinnam gayacurgan: “Unay rey Davidpa castan Jesus, cuyapaycallämay ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tsaynö gayacuptin puntata aywaycagcunaga gaprata ajäpäyargan: “¡Upälla cay!” nirmi. Tsaynö niyaptinpis payga mas fuertipam gayacurgan: “¡Rey Davidpa castan, cuyapaycallämay!” ");
INSERT INTO qxoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Niptinnam Jesus ichisquir nirgan tsay gaprata apapäyänanpä. Ñöpanman chaycatsiyaptinnam tapurgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Imachö yanapanätatä munanqui?” nir. Tsaynam runa nirgan: “Taytay, gaprayashga car ricaytam munallä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Niptinnam Jesus nirgan: “Cananga ricayna. Nogaman yäracamungayquipitam allirguyqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tsaynam gapraga wap ricachacusquirgan. Tsaypitanam Jesuspa gepanta cushishga aywacurgan Tayta Diosta alabaraycar. Tsayta ricaycurnam llapanna runacuna Tayta Diosta alabayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Jerico marcachömi tärargan Zaqueo jutiyog juc rïcu runa. Payga cargan impuestu cobragcunapa mandagninmi. Tsaynam Jerico marcapa atsca runacunawan Jesus päsaycaptin Zaqueoga tacshalla carnin Jesusta ricayta puëdirgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsaymi payga puntancunapa cörrilla aywar juc geruman yarcusquirgan, Jesus päsaycagta ricananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tsaynam Jesus tsaypa päsaraycarna Zaqueo achparaycagta ricasquirnin nirgan: “Zaqueo, ras yarpamuy. Cananga wayiquichömi patsatsimanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Niptinmi Zaqueoga yarpascamur Jesusta cushicur pushargan wayinman. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tsayta ricaycurnam runacuna Jesuspä rimar gallaycuyargan: “¿Imanirtä jutsasapa runapa wayinman aywaycan patsacunanpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tsaypita wayinchö caycarnam Zaqueo Jesusta nirgan: “Señor Jesus, llapan riquëzäpa pullanninta cay pobricunata raquipaycushä. Y pipa imantapis gechushga carga cananmi chuscu cuti masta cutiycatsishä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tsaynö niptin Jesusnam nirgan: “Cananmi salvacionta alcanzayarguyqui cay wayichö llapayqui täragcunantin. Unay Abraham Tayta Diosman yäracungannömi gampis yäracurguyqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tsaynö nisquirnam runacunata Jesus nirgan: “Nogataga Tayta Dios cay patsaman cachamashga jutsasapa runacunata salvanäpämi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesus salvacionpä parlanganta wiyarnam runacuna yarpäyargan: “Jerusalenman chaycushgaga reynintsic caymannachir juclla Jesusga churacanga” nir. Cay patsaman cutimurrä rey cananpä cagta mana musyarmi tsaynö parlayargan. Tsaymi Jesus juc munayyog runawan iwalatsir parlapargan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Juc munayyog rïcu runatam caru marcachö mandacog emperador gayatsinä: ‘Tärangayqui marcayquichö mandacog rey canayquipä chasquicog shamuy’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tsaymi tsay rïcu runa manarä wayinpita yargur chunca empliyäduncunata gayascäratsir jucninta jucnintapis atsca gellëta jagipänä: ‘Cutimungäyag gellënïwan aruycäyanqui’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tsaynö nir aywacusquiptinnam marca mayincuna gepantana cachayänä willacogcunata caynö niyänanpä: ‘Manam tsay runata mandagnïcuna cananpä munayätsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tsaynö marca mayincuna mana munaycaptinpis marcanchö mandacog cananpäga chasquicunä. Tsaypita marcanman cutiycurna tsay rïcoga gayatsinä gellënin tsararag empliyäduncunata gellënin aycatana wachangantapis musyananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tsay puntata chag cag ninä: ‘Taytay, gollämangayquita chunca cuti mastam gellëniquita miratsillargö’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Tsaynö niptinna patronnin ninä: ‘Gamga alli empliyädum canqui. Wallcallawanpis shumag arur miratsingayquipitam cananga chunca marcapa mandagnin canayquipä churashayqui’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tsaypitana chänä jucag empliyädunpis caynö nir: ‘Taytay, gollämangayquita pitsga cuti mastam gellëniquita miratsillargö’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tsaynö niptinna patronnin ninä: ‘Pitsga marcapa mandagnin canayquipämi gamta churashayqui’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Jucnin cag empliyädunna ardë tsapacullarna ninä: ‘Caychömi caycan gellëllayqui, taytay. Päñuwan gepircurmi churaycurgö. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gamga tsaripacunqui mana quiquiquipatash y cosichanquipis mana arurcurshi. Tsaynö yaga runa captiquim mantsapacur churaycurgä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Tsaynö niptinna patronnin ajäpar caynö ninä: ‘¡Gamga mana yäracuy empliyädum canqui! Quiquiquipa shimiyquipitam gamga juzgacanqui. Malafë cangäta yarpaycarga ¿imanirtä gellënïta bancullamanpis churarguyquitsu cutimur wachayyogtana goricunäpä?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tsaynö nisquirna tsaychö caycag runacunata ninä: ‘Tagay mana yäracuy empliyädupita gellënïta gechusquir goycuyay chunca cuti masyag wachatsir aruy yachag cagta’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Tsaynö niptinna niyänä: ‘Taytay, peru paypaga chunca cuti masta wachatsinganpis capunnachä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Niyaptinna patronnin ninä: ‘Noga ningäta cumpleg cagcunataga imaycäwanpis munayyog cananpämi churashä. Peru mana cumplegcunatam itsanga imaycantapis gechusquir gargurishä. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Y nircur mandacog rey canäta mana munar chiquimagnïcunataga cayman apaycamur wanutsiyay’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tsaynö runacunata willapasquirnam Jerusalenpa Jesus aywacurgan discïpuluncunawan. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","“Olivos” ningan jircan wac-wagtanchömi Betfage y Betania marcacuna cargan. Tsaycunaman yaycuraycarnam Jesus cachargan ishcay discïpuluncunata caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Aywayay tagay wac-tsimpapa. Tsaychömi tariyanqui manarä pipis muntacushga juc pollïnu ashnu wataraycagta. Tsayta pascasquir apayämunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pipis ‘¿Imapätä tsay ashnuta apayanqui?’ niyäshuptiquega niyanqui: ‘Señor Jesusmi miñishtin muntacunanpä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesus ningannö discïpuluncuna aywarnam tariyargan ashnu wataraycagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tsayta pascaycäyagta ricaycurnam ämun tapurgan: “¿Imapätä ashnüta pascaycäyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tsaynö niptinmi paycuna niyargan: “Tayta Jesusmi miñishtin” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesus caycangan cagman chäratsiyaptinnam punchuncunata carunaparcuyaptin Jesus muntacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tsaynö muntashga aywaraycaptinnam runacuna punchuncunata jacuncunata näniman mashtayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tsaynam Olivos jircantana uraycäyaptin gatiragnincuna cushicur Tayta Diosta alabayargan llapan milagrucunata ruragta ricayanganpita caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“¡Tayta Dios cachamungan mandamagllantsic rey imayyagpis alabashga caycullätsun! ¡Gracias ciëluchö caycag Tayta Dioslläcuna!” ");
INSERT INTO qxoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsaynam tsay runacunachö aywag fariseucuna chöpincunapita niyargan: “Mayistru, gatiräshogniquicuna upälläcuyänanpä ajäpay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tsaynö niyaptinnam Jesus nirgan: “Paycunata upälläcuyänanpä niycuptëga rumicunapis gayararmi Tayta Diosta alabayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tsaypitam Jerusalen marcata ricärir Jesus wagar caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Jerusalenchö täragcuna, canan junagllapis tantiyacuriyanquimanran cargan nogata chasquimar salvacionta tariyänayquipä cagta. Peru gamcuna manam chasquiycäyämanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tsaynö cayangayquipitam gamcunapä chämunga ñacacuy junagcuna. Chiquiyäshogniquicuna maytsayniquicunapa jirurupasquiyäshuptiqui manam maypapis geshpiyta puëdiyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wamrayquicunapis ni imapis manam geshpingatsu. Chipyaypam ushacätsiyäshunqui. Wayiquicunatapis juchutsirmi ushacätsiyanga. Manam ni juc rumillapis pergaraycar quëdangatsu. Tsaynömi ruracanga Tayta Dios cachamungan salvacogta mana chasquiyangayquipita”. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus Jerusalenman chaycurnam templuman yaycurgan. Tsaychö ranticogcunata tariycurnam gargur ushargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tsay runacunata ajäpar nirgan: “Tayta Diospa palabran gellgaranganchö caynömi nican: ‘Temploga noga Diosllayquita maytsaypitapis shamur adorayämänayquipämi’ nir. Tsaynö nicaptin ¿imanirtä gamcunaga ladroncunapa machaynintanö catsiyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tsaypitanam templuchö cada junag Jesus yachatsicurgan. Tsaymi sacerdöticunapa mandagnincuna, ley yachatsicogcuna, y waquin autoridäcuna yarpachacuyargan Jesusta imaycanöpapis wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tsaychö llapan runacuna Jesus yachatsingancunata shumag wiyayaptinmi ima ruraytapis puëdiyarganrätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jesus Jerusalenman yapay chaycurnam Tayta Diospa alli willacuyninta templuchö yachatsicuycargan. Tsaymannam chäyargan sacerdöticunapa mandagnincuna, ley yachatsicogcuna, y mas waquin autoridäcuna. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tsaychönam tapuyargan caynö: “Gam ¿ima puëdeg cayniquiwantä cay templupita ranticogcunata gargurguyqui? Tsaycunata ruranayquipä ¿pitä cachamushurguyqui?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tsaynö niyaptinnam Jesus nirgan: “Gamcunatapis mä jucta tapuyäshayqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitä Juanta cachamurgan bautizananpä? ¿Tayta Dioscu o runacunacu?”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tsaynö niptinnam quiquincuna pura willanacur niyargan: “‘Tayta Diosmi cachamushga’ nishgaga nimäshun ‘¿Imanirtä payta chasquicuyargayquitsu?’ nirmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Runacunallam cachamushga’ nishganam llapan runacuna janantsicman shayämur samgaypa wanutsimäshun. Paycunaga Tayta Dios Juan Bautistata cachamungantam yarpäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsaynö willanacurirnam Jesusta niyargan: “Nogacuna manam musyayätsu Juanta pï cachamungantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tsaynö niyaptinnam Jesus nirgan: “Gamcunapis mana willaycäyämaptiquega nogapis manam willätsu caycunata ruranäpä pï cachamangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsaypitanam Jesus yachatsicurnin nirgan: “Juc runam chacranman üvata plantatsinä. Nircurmi tsaychö arupagnin runacunata arrendädu jagipaycur juclä caru marcaman tärag aywacunä. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tsaypita üva cosëcha gallariptinnam juc empliyädunta cachanä payta töcangan cagta gorimunanpä. Tsayna empliyädun chäriptinga chacran tsararag runacuna magacacharcur mana imatapis raquipällar garguriyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Tsayna chacrayog runaga juctana empliyädunta cachanä. Paytapis tsaynölla chacran tsararag runacunaga samgar umantapis paquir usharcur imaycata gayaparcurrä garguriyänä. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tsaypita mas juctana chacrayog cachanä. Paytapis tsaynölla magar ushasquir yawarllatana jinayllata garguriyänä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tsaynam chacrayog yarpachacurna ninä: ‘¿Cananga imatatä rurashä? Cachashä cuyay tsurïtachir. Paytaga respitarnin manam imanayämunganatsu’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Tsayna chacrayogpa tsurin yaycuraycagta ricasquirga chacra arrendarag runacunaga willanacuyänä: ‘Tagaymi cay chacrawanga heredëru quëdanga. Paytaga wanuriycatsishun chacran nogantsicpäna cacunanpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsaynö willanacusquirna chacrayogpa tsurintapis tsarisquir wanuratsiyänä. Nircur ayantapis chacranpita jucläman jitariyänä”. Tsaycunata parlapärirnam Jesus nirgan: “Quiquin chacrayog chaycur tsay runacunata ¿imatarä ruranga? ");
INSERT INTO qxoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chacran arrendaragcunata wanuscäratsirmi juccunatana chacrantapis arrendacunga”. Tsaynö niptinmi runacuna niyargan: “¡Tayta Diosnintsic cuyapaycallämäshun tsaynö ajanaywan nogantsictapis mana castigaycamänantsicpä!” ");
INSERT INTO qxoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tsaynö niyaptinnam paycunata ricapärir Jesus nirgan: “Gamcuna infiernuman mana gaycucayta munarga tantiyacuyay caynö nir Tayta Diospa palabran gellgaranganta: ‘Wayi cimientog runa “Cay rumega manam allitsu” nir jitariyangan cagrämi alli albañilpäga mayistra rumimanrä ticrarin’. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipis tsay mayistra rumiman ishquirga tacacunmi. Y pipa jananmanpis tsay rumi cuchpacarga pasaypam ushacäratsin. Tsaynömi pipis nogaman mana criyicamog cagga infiernuchö ñacayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tsaynö Jesus parlapäriptin sacerdöticunapa mandagnincuna y ley yachatsicogcuna contrancuna parlaycanganta musyarnam prësuytana munayargan. Peru atscag runacunata mantsacurninmi tsay örallaga prësuyarganrätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tsaypitanam autoridäcuna Jesus caycanganman musyapacogcunata cachayargan alli tucuycullar parlapäyänanpä. Autoridäcunaga munayargan Roma mandacogpa contran parlaptinga tsaynöpa prësuytam. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tsaynam Jesus cagman chaycur caynö niyargan: “Taytay, nogacuna musyayämi rasun cagllata imaypis gam yachatsicungayquita. Gamga Tayta Dios munangannö runacuna cawayänanpämi yachatsicunqui. Imata parlarpis pitapis mana mantsapacuypam ninqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tsaynö captin tapucuriyälläshayqui. Munayninchö catsimagnintsic Roma nacionpä impuestuta ¿pägashwancu o manacu pagashwan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Llutanta parlatsiyta munar alli shimicunallapa tapuyanganta musyarnam Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mä, juc gellëta apamur ricatsiyämay” nir. Tsaynam ricaycatsiyaptinna nirgan: “Cay gellëchöga ¿pipa reträtuntä caycan? ¿Pipa jutintä caychö gellgaraycan?” Niptinnam paycuna niyargan: “Romachö mandamagnintsic emperadorpam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tsaynam Jesus nirgan: “Emperadorpa cagtaga emperadorman apaycapuyay. Tayta Diospa cagtaga Tayta Diosta goycuyay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tsaynö atsca runacunapa chöpinchö niycuptin manam imaniytapis puëdirna upällacurpuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsaypitanam saduceucunana Jesus caycanganman chäriyargan. Paycunaga yarpäyargan wanushgacuna manana cawayämunanpä cagtam. Tsaymi Jesusta tapurnin caynö niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Taytay, Moises gellganganchöga caynömi nican: ‘Juc runa tsuriynaglla wanucuptin gepa cag wauginna llumtsuynin viüdawan tätsun. Tsaynöpam viüdachö wamran yuriptin tsay wanog cag wauginpa tsurin cuentana canga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tsaymi canan cuentariyäshayqui. Ganchis (7) waugicunash cayänä. Mayor cagshi juc warmiwan tänä. Payga tsurin manarä captinshi wanusquinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tsayna viüdawan gepan cag wauginna tänä. Paypis manarä tsurin captinshi wanusquinä. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Y tsaynöpis mas gepan cag wauginna viüdawan tänä. Paypis wanusquinälla manarä tsurin captin. Tsaynöllash llapan waugincuna tsay warmillawan täyänä. Y tsuriynaglla llapanpis wanuyänä. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsä, tsaypitanash warmipis wanucunä. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y wanushgacunata Tayta Dios cawaritsimungan junagga ¿maygan cag waugipa warmintä canga, llapancunawan tashga caycaptinga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Tsaynam Jesus nirgan: “Tsay warmi manam mayganpa warminpis canganatsu. Cay vïdallachömi warmiyog y runayogpis cayan. Tayta Dios cawascatsimuptin ciëluman aywagcunaga mananam majayog cayanganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tsaychöga angelcunanöllanam mana wanucuypa cawayanga. Tayta Diospa wamrancunanam cayanga cawatsimushga captin. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wanushgacuna cawayämunanpä Moises gellganganta liyiycarpis ¿manacu tantiyacuyanqui? Abraham, Isaac, y Jacob wanuyanganpitaga alli unaytam shiraca rauraycag munti rurinpita Moisesta Tayta Dios nimurgan: ‘Nogaga Abraham, Isaac y Jacob adoraycäyämangan Diosmi cä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tsaynö nishga captinmi musyantsic wanungallanchö paycunata Tayta Dios mana dejaringanta. Tsaynöllam pitapis maytapis cawatsimunga criyicamog cagtaga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tsaynö Jesus niycuptinnam ley yachatsicogcuna niyargan: “¡Allitam tsaytaga niycurguyqui, taytay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tsaypitaga mananam pipis mastaga tapuyargannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tsaypitanam Jesus paycunatana nirgan: “Unay rey David castapita carpis salvacogga manam runallatsu. Payga Diosmi. Tsaynö caycaptinga ¿imanirtä ley yachatsicogcuna niyan runalla canganta? ");
INSERT INTO qxoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Unay rey Davidpis ‘Salmo’ ningan libruchö caynö nirmi gellganäna: ‘Salvacogga Diosnïmi. Paytam Tayta Dios ninga: “Jamacamuy cay derëcha cag lädüman, ");
INSERT INTO qxoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","llapan chiquishogniquicunata munayniquichö catsinayquipä” nir’. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","‘Salvacogga Diosnïmi’ nir David nicaptinga, salvacog shamogga ¿imanöpatä runalla canman?” ");
INSERT INTO qxoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Llapan runacuna wiyaycäyaptinmi discïpuluncunata Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pagtatä ley yachatsicogcuna munaynincunata rurar cawacuyangannö paycunata cäsur cawaycäyanquiman. Paycunaga chaqui puntanyag röpancuna jatipäcushga cällicunachöpis puriyan, runacuna ‘Tayta Dios munangannömi paycunaga cawayan’ niyänanta munallarmi. Paycunaga goricäcuyänan wayicunachöpis mas allin cag jamacuyänancunachöran jamasquiyan. Micupacuypä invitashga carpis mas allin cag jamacunacunataran ashiyan. ");
INSERT INTO qxoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tsaynö alli tucuycarmi viüdacunapataga imaycancunatapis sacyapar ushayan. Nircur tsaycunata rurarirga runacuna mana tantiyayänanpämi mana ima rurashganö unayrä Tayta Diosmanpis mañacur mayaräyan. Tsaynö cayanganpitam paycunataga Tayta Dios mana cuyapaypa castiganga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsaypitam templuchö Jesus ricasquirgan rïcu runacuna gellëta ofrenda wiñacuyänan cäjaman wiñaycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsaychömi ricargan juc wactsa viüdapis ishcay ichishag pöcu valoryog gellëllata wiñaycagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tsayta ricaycurmi discïpuluncunata Jesus nirgan: “Allau, cay pobri viüdapa ofrendanga mas valoryogmi cashga Tayta Diospäga. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Waquin cagcunaga capuyanganpita putsogllantam garaycuyashga. Cay wactsa warmega tsayllana cawacunanpä caycaptinpis capungan cagtam wiñaparcushga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tsaychö caycäyaptin discïpuluncunaga parlaycäyargan templu pergarangan rumicuna cuyayllapä cangantam y shumag adornashga cangantam. Tsaynö niptinnam Jesus nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ricaycangantsic caytsican templu juchungam. Manam ni juc rumipis pergaraycar quëdangatsu. Chipyaypa juchurmi ushacanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsaynam discïpuluncuna Jesusta tapuyargan: “Taytay, ¿imaytä ningayquinö templuta juchutsiyanga? ¿Imanöpatä musyayäshä tsaycuna ruracar gallaycunanpä cagta?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tsaynö niyaptinnam Jesus nirgan: “Pagtatä pipis llullapar llutancunata criyiycätsiyäshunquiman. Atscagmi nogapa jutïchö llullacogcuna chäyämunga: ‘Nogaga salvacog Cristum cä’ o ‘Ushacäcuy tiempu chämushganam’ nir. Tsaynö niyäshuptiquipis gamcuna ama cäsuyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maytsaychöpis ‘Gyërram caycan’ nirnin runacuna parlayaptinpis ama mantsacäyanquitsu. Rasunpapis puntataga tsaycunarämi päsanga. Tsaycuna päsaptinpis cay patsaga ushacar manam gallangarätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mastapis nirgan: “Juc nacion runacunam pelyanga jucag nacionwan, juc marcam jucag marcawan. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maytsaychöpis terremötu captin patsam alläpa cuyunga. Mallagay watacunam canga. Imaycaläya geshyacunam canga. Tsaynömi ciëluchöpis ricacämunga mantsacäcuypä imayca señalcuna”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tsaycuna manarä päsaptinmi runacuna autoridäcunaman apatsiyäshunqui. Goricäcuyänan wayicunachömi astayäshunqui. Carcelcunamanmi wichgatsiyäshunqui. Puëdeg autoridäcunapa, mandacog reycunapa ñöpancunamanmi chätsiyäshunqui nogapa willacuynïta willacuyangayquipita. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tsaychömi gamcuna yachatsingäcunata paycunatapis willacuyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gamcunaga ama yarpachacuyanquitsu prësu autoridäcunaman apayäshuptiqui imata parlayänayquipäpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nogam tantiyatsiyäshayqui imata niyänayquipä cagtapis. Tsaymi maygan chiquiyäshogniquicunapis imaniytapis camäpacuyangatsu ni contrayäshunquinatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tsay witsancunaga gamcunata mana criyicog taytayquicunam autoridäcunaman entregaycushunqui prësu tsariyäshunayquipä. Tsaynömi waugiquicuna, castayquicuna, y amïguyquicuna entregayäshunqui prësu tsariyäshunayquipä. Tsaynöpam waquinniquicunataga wanutsiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nogaman criyicayämungayquipitam pipis maypis chiquiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tsaynö rurayäshuptiquipis ama llaquicuyanquitsu. Ima päsayäshuptiquipis Tayta Dios manam dejaycuyäshunquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tsaynö caycaptinga imayca ñacaycunata päsarpis mana ajayaypa criyicamog cagmi Tayta Diospa ñöpanman chäyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalen marca ushacänanpäna caycanganta musyayanqui soldäducuna maytsayninpa jirurupasquishgatana ricarmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Llapayqui criyicogcuna Judea jircacunapa geshpir aywacuyanqui. Jerusalenchö caycagcunapis geshpir aywacuyanqui. Chacracunachö caycagcunapis ama cutiyanquinatsu wayiquicunaman. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsay junagcunam runacuna castigashga cayanga. Tsaynöpam Diospa palabran gellgarangancuna llapanpis cumplinga. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tsayläya ñacay junagcunachö, ¡allau geshyag warmicuna y llulluncuna chuchuycag warmicuna! Tsay junagcunaga alläpa cuyapaypämi runacuna ñacayanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquintam wanutsiyanga y waquintam prësu apayanga juclä caru nacioncunaman. Tayta Diosta mana cäsucog runacunam Jerusalen marcata munaynincunachö tsaräyanga munayyog caynin ushacäcunganyag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Tsayläya ñacacuycuna päsasquiptinga mananam rupaypis ni quillapis atsicyanganatsu. Estrëllacunapis ciëlupita shushuyämungam. Lamarpis mantsacäcuypä bunyaypa bunyarmi gayaranga. Tsaycuna päsaptinmi llapan runacuna mantsacaywan turwäyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ciëlu sicsicyagta ricarmi runacuna pasaypa mantsacaywan: ‘¿Imanörä cay patsa canga?’ nir wanur pitiyangarä. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tsaypitanam noga ciëlupita pucutay jananchö pasaypa chipipirrä shamuycagta runacuna ricayämanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tsaycuna llapanpis ruracar gallaycuptin nogaman yäracamogcuna cushicuyanqui. Musyayanquinam tsay ñacaycunapita jipiptï gloriaman aywayänayquipäna cagta”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nircur caynöpis Jesus tantiyatsirganmi: “Cay hïgusman iwalatsir ningäcunata yarparäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Musyayanquim tamya tiempu gallaycuptin hïgus jachapa yuran tsegllimunanpäna cagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tsaynömi cay ñacaycuna gallaptin gamcunapis tantiyayänayquina ciëlupita cutimunäpä cercana canganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cay ningäcuna gallaptin tsay witsan runacuna manarä ushacäyaptinmi llapanpis cumplinga. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ciëlu y cay patsa ushacäcuptinpis noga ningäcunaga llapanmi ruracanga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mana yarpashgata cutimur pagtatä gamcunata tariycäman imayca jutsallachö cawaycagta, machashga ima caycäyagta, o imaycayogpäpis yarpachacuywan gongamashga caycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tsaynö llutan cawacogcunaga manam ni jucpis geshpingatsu Tayta Diospa castïgunpita. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tsaymi imaycay örapis Tayta Diosllaman mañacur listullana caycäyänayqui. Tsaynöpaga mananam infiernuman aywayanquinatsu, sinöga nogapa ñöpämanmi cushishgalla chäyämunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tsaynömi ari Jesus junagpa templuchö yachatsicurir tsacaypana Olivos jircanman aywag tsaychö punur quëdananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Cada goya cada wäray templuman Jesus yachatsicog aywaptin imanömi runacuna goricäyag yachatsicunganta wiyayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pascua fiesta semänachö levadüraynag tantata micur gallaycunanpänam caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tsay fiestachö Jesusta yachay shimincunawan tsarisquir wanutsiyänanpämi willanacuyargan sacerdöticunapa mandagnincuna y ley yachatsicogcuna. Peru tsaychö gorirag runacuna ajacurcuyänanta mantsacurmi tsariyarganrätsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsaynö yarpaycäyaptinmi Satanas yaycurgan Judas Iscariotipa shongunman. Judaspis Jesuspaga apostolninmi cargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paymi sacerdöticunapa mandagnincunaman y templu täpag wardiyacunapa mandagnincunaman parlag aywaycur caynö nirgan: “Jesus quiquillan caycangan öram regitsiyäshayqui prësu apacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tsaynö nisquiptinnam sacerdöticuna cushishga auniyargan gellëta pägayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsaypitaga Judas shuyacurnam gallaycurgan Jesus quiquillan caycangan öra regitsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Levadüraynag tantata micuyänan Pascua fiesta semäna gallaycunan junagnam cargan. Tsay junagga wata watam Israel runacuna carnishcunata pishtar micuyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tsaymi Jesus cachargan Pedrutawan Juanta “Pascua fiestachö merendata micunantsicpä puestucayämuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tsaynam paycuna tapuyargan: “Taytay, ¿maychötä puestuyämushä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tsaynö niyaptinnam Jesus nirgan: “Jerusalenpa aywayay. Tsayman charmi ricayanqui juc runata uylluwan yacuta apaycagta. Tsay runapa gepallanpa aywayanqui may wayinman changanyagpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tsaychömi wayiyogta niyanqui: ‘Señor Jesusmi tapucun: ¿Maygan cuartuyquichötäshi discïpuluncunawan canan Pascua merendata micuyanga?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tsaynö niyaptiqui wayiyognam ricatsiyäshunqui altuschö jatun cuartu nogantsicpä alistashgatana. Tsaychö listacäyämunqui micunantsicpä” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tsaynö niyaptinnam ishcan discïpuluncuna aywacuyargan Jerusalenman. Tsayman chärirnam Jesus ningannölla tariyargan llapantapis alistapacushgata. Tsaychönam discïpuluncuna Pascua merendata micuyänanpä listapacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tsaynam merenday örana captin discïpuluncunawan Jesus jamacuyargan micuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tsaychömi Jesus nirgan: “Imanömi munaycurgö cay Pascua merendata gamcunawan micuyta manarä wanungäyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Caynö cay Pascua merendata mananam micushänatsu Tayta Diospa ñöpanchö gamcunawan micungäyag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tsaynö nisquirnam micuycäyaptinna väsuchö vïnuta aptarcur Jesus Tayta Diosman mañacur agradesicurgan. Nircurnam discïpuluncunata macyargan caynö nir: “Cay vïnuta llapayqui upuyay. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yapayga mananam vïnuta upushänatsu Tayta Diospa ñöpanchö gamcunawan mushog vïnuta upungäyag”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsaynömi tantata aptarcurpis Tayta Diosman mañacur agradesicurgan. Nircurnam paycunata paquipargan: “Cayga nogapa cuerpümi. Cay tantata micur gamcuna raycur wanungäta yarpäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tsaynöllam merendata ushasquir väsuchö vïnuta aptarcurpis nirgan: “Cayga nogapa yawarnïmi. Noga yawarnïta jichar wanuptïmi Tayta Dios runacunawan mushog conträtuta ruranga criyicamog cagcunata jutsancunapita perdonananpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Tsaynö caycaptinpis gamcuna caychö nogawan micuycagpita jucniquim chiquimagnïcunapa maquinman entregayämanqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Noga Tayta Diospita shamogtaga Diospa palabran gellgaranganchö ningannöllam runacuna wanutsiyämanga. Peru allau ranticamagnï runa, ¡ima cuyapaypärä canga!” ");
INSERT INTO qxoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tsaynö niptinmi jucnin jucninpis discïpuluncuna ricänacur tapunacuyargan: “¿Maygantsicrä ticrapuycantsic?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsaypita mayganpis mandacog cayta munar gechunacurmi discïpuluncuna rimanacuycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tsaynö rimanacuyaptinmi Jesus nirgan: “Cay mundu entëruchö nacion mandagcuna munayanganmanmi mandacuyan. Tsaynö lluta mandacog cayaptinpis ‘Alli runam payga’ niyanran. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gamcunaga ama tsaynö mandacog cayta yarpäyaytsu. Tsaypa rantinga llänu shonguyquicunawanmi cawayänayqui pitapis maytapis cuyaparnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Musyayanquim patroncuna mësachö micuptin empliyäduncuna sirviyanganta. Nogaga tsay empliyäducunanöllam cawangäyagga caycä, manam patronnötsu. Tsaymi gamcunapis noganölla cawayänayqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Imayca ñacaychö captïpis gamcuna nogawanmi imaypis cayarguyqui. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tsaymi gamcunata churayäshayqui mandacog cayänayquipä, Tayta Dios nogata mandacog canäpä churamangannö. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gamcunaga nogawanmi micuyanqui y upuyanqui. Tsaynömi cutimuptï jamacuyanqui mandacogcuna jamacuyänan trönuman, Tayta Dios quiquinpä acrangan runacunata mandacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tsaypitanam Pedruta Jesus nirgan: “Pedro, Satanasmi Tayta Diosta rugacushga: ‘Jesuspa discïpulun Pedruta llutancunata ruratsishä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tsaymi gampä Tayta Diosman mañacurgö Satanas munanganta ruratsishuptiquipis Tayta Diosllaman yapay shumag yäracunayquipä. Tsaynö cangan yäracurmi criyicog mayiquicunata valoratsinqui paycunapis nogaman shumag yäracayämunanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tsaynö niptinnam Pedro nirgan: “Ishcantsicta carcelman apar wanutsimänantsic captinpis ¡manam ñëgashayquitsu, taytay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tsaynam Jesus nirgan: “Pedro, canan pagasmi nogapä tapuyäshuptiqui quimsa cuti ‘Manam regïtsu’ nir ñëgamanqui gällu manarä cantaptin”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsaypitanam discïpuluncunata Jesus tapurgan: “Gellëniynagta, punchuynagta, y llangiynagta willacuyänayquipä cachaptï ¿imallapis faltäyäshurgayquicu?” nir. Tsaynam paycuna niyargan: “Manam imapis faltäyämargantsu, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","36,37 Jesusnam nirgan: “Diospa palabran gellgaranganchö caynö nirmi gellgaraycan: ‘Jutsasapacunawan iwalatsishgam canga’ nir. Tsaynö gellgaraycan nogapämi. Cananpitaga willacog aywar imallayquicunapis apayanqui. Espädaynag cagga punchuyquicunata ranticusquirpis rantiyay”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tsaynam discïpuluncuna niyargan: “Caychö caycan ishcay espädäcuna, taytay”. Niptin Jesusnam nirgan: “¡Gamcuna manam tantiyayanquitsu imata nicayämangayquitapis!” ");
INSERT INTO qxoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsaypitam Jesus aywargan imaypis aywangannö Olivos jircanman discïpuluncunawan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tsayman chaycurnam discïpuluncunata nirgan: “Tayta Diosman mañacuyay Satanas jutsaman mana ishquitsiyäshunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsaynö nisquirmi mas washaläman aywasquirnin gonguricuycur Tayta Diosman mañacurgan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tayta Diosllä, cay ñacanäpä cagpita munarninga jipiycamay. Peru itsanga ama noga munangänöga catsuntsu. Gam munangayquinölla caycutsun”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsaynö Jesus pasaypa llaquicur rugacuycaptinmi juc angel yuripasquir valoratsirgan mana alläpa llaquicunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsaynö captinpis llapan shongunwan Tayta Diosman mañacuptinmi jumpinpis yawarnörä patsaman juturgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tayta Diosman tsaynö mañacunganpita cutiycurnin discïpuluncunata tarirgan llaquicuypita chip wanuypa punucashga caycäyagtam. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsaynam Jesus nirgan: “¿Punuycäyanquicu? Ricchar Tayta Diosman mañacuyay Satanas jutsaman mana ishquitsiyäshunayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tsaynö Jesus nicaptinnam discïpulun Judas Iscariote chasquirgan atsca runancuna pushashga. Nircurnam Jesuspa ñöpanman witiycur saludar cäranchö mutsaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tsaynam Jesus nirgan: “Judas, ¿chiquimagnïcunaman entregamänayquipäcu mutsaycamanquirä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tsaynam prësurna apacuyänanpä cagta tantiyasquir discïpuluncuna Jesusta niyargan: “Taytay, espädäcunawan gocachascayämushä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsaynö nirmi mas mandagnin cag sacerdötipa wätayninpa derëcha cag rinrinta juc discïpulun espädanwan walluriycurgan jipicagpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tsaymi Jesus nirgan: “¡Amana imanayaynatsu!” Nisquirmi runapa rinrin wallucashgata yataycullar alliscatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesusta prësu apayänanpä shamogcunaga cayargan mandag sacerdöticuna, templu täpag wardiyacunapa mandagnincuna, y Israel runacunapa autoridänincunam. Paycunatam Jesus nirgan: “Gamcunaga ¿imanirtä espädayquicunawan tucruyquicunawan shayämunqui imayca ladrontanöpis prësuyämänayquipä? ");
INSERT INTO qxoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Runacunata yachatsirnin goyay goyaypis templuchö cargächä. Tsaychöga ¿imanirtä prësu tsariyämargayquitsu? Cananga Satanaspa munayninta rurayänayquipä öra chämushganam”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsaypitanam Jesusta prësu tsarircur apayargan sacerdöticunapa mandacogninpa wayinman. Payta prësu apacuyaptin Pedro caru gepallantam aywargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Runacunaga sawan rurinchö ninata tsarircatsirmi mashacuycäyargan. Tsayman yaycurirmi Pedrupis paycunawan mashacuycargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tsaychömi Pedro mashacuycagta ricaycur juc wätay warmi nirgan: “Cay runapis Jesuswanmi purirgan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tsayta wiyaycurmi mantsariycanganta Pedro nirgan: “Warmi, nogalläga manam payta regicütsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tsaypita rätunnintanam juc runapis Pedruta ricaycur nirgan: “Gampis paywan puregmi canqui”. Niptinmi Pedro nirgan: “Nogaga manam paywan imaypis purillashga cätsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsaypita juc öratanöna jucnam nirgan: “Rasunpaypam cay runaga Jesuswan pureg Galilea runa. ¡Tsay runacunanömi caycanpis!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tsaynö niptinnam Pedro nirgan: “¡Manam musyätsu imata parlapaycämangayquitapis!” Pedro tsaynö nicaptinmi gällu cantasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tsaynam sï Jesus ticraycur ricaycuptinrä Pedro yarpasquirgan caynö ninganta: “Gällu manarä cantaptinmi quimsa cuti ñëgamanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsay ninganta yarpasquirmi itsanga Pedro wagtaman yargusquir pasaypa llaquicur wagargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tsaypitanam prësognin runacuna burlacur Jesusta magayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nircurmi ñawinta tsaparcur niyargan: “¡Dios caycarga mä, pï magashungayquitapis niyämay!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tsaynö nirmi tucuyta rurarnin burlacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Patsa warasquiptinnam Israel runacunapa puëdeg autoridänincuna, mandag sacerdöticuna, y ley yachatsicogcuna despächuncunaman goricäyargan. Tsaychönam Jesusta tapuyargan: ");
INSERT INTO qxoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","“Canan mä, willayämay. ¿Rasunpacu gam Tayta Dios cachamungan salvacog canqui?” nir. Tsaynam Jesus nirgan: “‘Aumi, paymi cä’ niyäshayquipis gamcuna criyiyämänayqui captinchi. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cananpitaga noga ciëluchö caycäshä poderösu Tayta Diospa derëcha cag lädunchömi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsaynö niycuptinmi llapancuna niyargan: “Tsayöraga, gam Diospa tsurinchä canqui ¿au?” nir. Tsaynam Jesus nirgan: “Aumi, gamcuna niyangayquinöllam cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Paycunanam niyargan: “Quiquinpis Diospa tsurin canganta nicämashgaga ¿imapänatä testïgutapis ashishun? Tsaynö Dios tucuycarga ¡wanutsishga catsun!” ");
INSERT INTO qxoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsaypitanam llapancuna contrarna Jesusta maquinpita watarcur mandacog Pilatuman apayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tsaychönam Pilatuta niyargan: “¡Cay runaga llutancunatam yachatsicuycan! Manam munantsu Romapä impuestuta runacuna pägayänantapis. Jinachöpis quiquinmi nogacunapa mandayämag rey canganta nicäyäman. Tsaynö mandag tucog cagga wanutsishga catsun”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsay niptinnam Jesusta Pilato tapurgan: “¿Rasunpacu canqui Israel runacunapa mandacognin rey?” nir. Jesusnam nirgan: “Gam ningayquinöllachä cä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsaynam Pilato nirgan mandacog sacerdöticunata y tsaychö goricashga caycag runacunata: “Cay runa llutanta yarpaptinpis, nogataga ¿imatä gocaman? Ima jutsantapis manam tarïtsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tsaynö niptinnam Israel autoridäcunaga masrä niyargan: “¡Manam tsaypis tsaynötsu! Romapa contran sharcuyänanpämi runacunata pasaypa aquishapaycan. Galilea provinciapita hasta cay Judea provincia quinranyagpis tsaynöllam yachatsicuycan”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tsayta wiyarnam paycunata Pilato tapurgan: “¿Rasunpacu Galileapita cay runaga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Aumi, payga Galileapitam” niyaptinnam Galilea provinciapa mandagnin Herodesman Jesusta apatsirgan. Tsay junagcuna Jerusalenchömi unas Herodespis caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesuspä parlayangancunata wiyashga carmi Herodesga puntapitana ñöpanchörä ima milagrullatapis rurananta munargan. Tsaymi Jesusta ricaycur cushicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tsaychö Herodes yaparir yaparir tapupaptinpis Jesus manam imatapis parlacurgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mandag sacerdöticunawan ley yachatsicogcunapis Jesuspa contranmi imaycatapis niyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nircurnam soldäduncunawan rey Herodes asipäyänan raycur Jesusta reytanörä catsiyargan quiquin Tsaypitanam cangan cutitsirgan Pilato cagman. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tsay junagmi Herodeswan Pilato amishtayargan puntata chiquinacurcur. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesusta Pilatuman cutiycatsiptinnam Pilatuna gayatsirgan mandacog sacerdöticunata, autoridäcunata, y waquin runacunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tsaychö llapancuna goricasquiyaptinnam nirgan: “Gamcuna cay runata apayämurguyqui: ‘Cay runaga runacunatam yachaycätsin mandagnintsicpa contran sharcuyänanpä’ nirnin. Ñöpayquicunachö tapurga manam ima jutsantapis tarirgötsu contran niyämangayquinöga. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tsaynömi Herodespis may tarishgatsu ima jutsantapis. Tsaymi cayman cutitsimushga. Tantiyacuyay. Manam ima jutsanpis cantsu wanutsishga cananpäga. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tsaymi payta astarcatsillar cachaycushä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatoga yachacashganam wata wata Pascua fiesta semänachö runacuna mañayangantaga juc prësuta cachag. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tsaymi Pilato Jesusta cacharinanta munaptin runacuna juc shimilla gayaraypa niyargan: “Ama Jesustaga cachaytsu. Barrabasta cachaycunayquitam munayäga” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabasga carcelchö wichgaraycargan Roma nacionpa contran sharcunganpita y runacunata wanutsinganpitam.) ");
INSERT INTO qxoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tsaymi Pilato yapay runacunata parlapargan Jesusta cachaycuyta munarnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tsaynö parlapaptinpis runacunaga masrämi gayaräyargan: “¡Cruzchö wanutsun! ¡Cruzchö wanutsun!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tsaynam Pilato yapay nirgan: “Wanunanpäga ¿ima mana allitatä rurashga? Manam tarïtsu ima jutsantapis. Tsaymi astarcatsillar cachaycushä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tsaynö niptin llapan runacunam masrä gayarar niyargan cruzchö wanutsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Tsaynö masrä gayaräyaptinnam Jesusta runacunaman Pilato entregaycurgan munayanganta ruracuyänanpä. Runacuna mañacuyangannöllam Barrabasta cachaycurgan Romapa contran sharcushga caycaptinpis y runacunata wanutsishga caycaptinpis. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tsaynö Jesusta cruzchö clavag apaycarnam tincuyargan Cirene marcapita juc runa Simon jutiyog chacranpita aywacuycagwan. Paytam niyargan Jesus apaycangan cruzta umrurcur Jesuspa gepanpa apananpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tsaytsica runacunam Jesuspa gepanta aywaycäyargan. Tsaychömi atscag warmicunapis llaquicurnin wagaraycar aywaycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tsaymi wagaycag warmicunata Jesus nirgan: “Jerusalen warmicuna, ama nogapäga wagayaytsu. Wagayayga quiquiquicunapis y wawayquicunapis imanö ñacayänayquipä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Feyupa ñacaycuna captinmi pasaypa llaquicuywan runacuna niyanga: ‘¡Cushicuyätsun wawaynag warmicuna!’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tsaychömi runacuna ñacaycunata mantsariywan gagacunatapis: ‘¡Janäcunaman juchuriycamuy juclla wanucuyänäpä!’ niyanga. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nogatapis caynö ñacaycätsiyämarga ¡imanönarä gamcunataga ñacatsiyäshunqui!” ");
INSERT INTO qxoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tsaynö Jesusta apaycar ishcag ladroncunatapis apayarganmi Jesustawan juntu crucificayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tsaypita “Calavëra” ninganman chaycatsirnam Jesusta cruzman clavayargan. Apayangan ladroncunatapis crucificayargan jucnin cagtam Jesuspa derëcha cag lädunman y jucagtanam itsogninman. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tsay öram Jesus nirgan: “Papällay, cay crucificayämag runacunata cuyaparnin perdonaycuy. Manam musyayantsu imata ruraycäyangantapis”. Soldäducunanam sortiyayargan Jesuspa röpanta. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tsaychö runacuna ricaraycäyaptinmi autoridäcuna Jesusta asiparnin niyargan: “Juccunataga salvaycacharganchä. Canan quiquinga ¿imanirtä salvacuyta puëdintsu? Tayta Dios cachamungan salvacog carninga, mä tsay cruzpita yarparamutsun”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tsaynöllam soldäducunapis asiparnin Jesusta uputsiyargan upucuyänan ayag vïnuta: ");
INSERT INTO qxoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Israel runacunapa mandagnin rey caycarga mä, quiquiqui salvacuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Imapita wanutsiyanganta runacuna musyayänanpämi juc letrëruta cruzpa puntanman clavayargan caynö gellgarcur: “CAYGA ISRAEL RUNACUNAPA REYNINMI” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tsaypitanam jucag crucificaraycag runapis Jesusta asiparnin nirgan: “Salvacog carga mä, tsaypita salvacuriy ari, nircur nogacunatapis salvayämänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tsaynö niptinmi jucnin cag ajäpargan: “Gampis paynö ñacaycarga ¿manacu Tayta Diosta mantsacunqui? ");
INSERT INTO qxoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nogantsicga jutsantsiccunapitam ñacaycantsic. Payga manam ima jutsatapis rurashgatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nircurmi Jesusta nirgan: “Señor Jesus, nogalläta yarparcallämanqui ari, cay patsaman mandacog cutimungayqui junag” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tsaynam Jesus nirgan: “Cananpitaga nogawanmi canqui Tayta Dioslläpa ñöpanchö”. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tsaypitaga pullan junagpitam quimsa öra rupay mana atsicyaptin patsa tsacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tsay örallam templu rurinchöpis alli awashga jatun cortïna urayninpa ishcayman rachisquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tsaypitam Jesus fuertipa gayarasquirmi nirgan: “¡Tayta Diosllä, maquiquimannam cawaynilläta churaycamü!” nir. Tsaynö nisquirmi wanusquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tsaynö imayca päsangancunata ricaycurnin soldäducunapa capitanninmi Tayta Diosta alabagnö ticrar nirgan: “¡Rasunpam cay runaga jutsaynag cashga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tsaychö caycag runacunapis aywacuyargan pasaypa llaquicurninmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuswan reginacogcunanam itsanga carulällapita ricaräyargan. Tsaynöllam yanaparnin Galileapita gatirag warmicunapis tsaychö cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juc runam cargan Jose jutiyog, Tayta Dios munangannö cawacog. Payga cargan Judea provinciachö Arimatea marcapitam. Paypis Israel runacunapa autoridäninmi cargan. Waquin autoridäcuna Jesusta wanutsiyänanpä willanacuyaptinpis payga manam munargantsu. Josega criyirgan Tayta Dios aunicungannö salvacogta cachamunanpä cagtam. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Paymi Pilatuman aywargan Jesuspa ayanta pampananpä negnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato “Pampay ari” nisquiptinnam Jesuspa ayanta cruzpita jipisquir lïnu säbanaswan wancurgan. Nircurnam pampag apargan manarä pipis pampacungan gagachö uchcushga sepultüraman. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jesus wanurgan viernis tardim. Cada viernismi tardipaypaga Israel runacuna säbadu jamapay junagpä listacuyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Jesuswan shamog warmicunanam Joseta gatipar aywayargan sepultüraman. Tsayman chaycurmi ricayargan Jesuspa ayanta imanö churangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsaypita wayiman cutiycurninnam alistacuyargan mucuchag perjümicunata üsuncunaman Jesuspa ayanman wiñapäyänanpä. Llapanta alistapacusquirnam Tayta Diospa mandamientunta cumplir jamapäyarganrä säbadu jamapay junag captinna. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tsaypita dominguman warämognam tsaca tsacallana warmicuna aywayargan Jesus pamparangan cagman, alistayangan perjümicunata apacurcur. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chaycuyänanpäga pamparangan uchcuta tsaparag rumipis jucläman wititsishgam caycänä. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsayman yaycur manam tariyargannatsu Señor Jesuspa ayanta. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tsaynö mantsacashga caycäyaptinmi ishcay angelcuna chipipiycag röpashga paycunapa ñöpancunachö ricacusquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Warmicuna paycunata ricaycurnam pasaypa mantsariywan gonguriycuyargan. Tsaynam tsay yuripag angelcuna niyargan: “¿Imanirtä ashiycäyanqui wanushgacuna pamparanganchö cawaycagna runata? ");
INSERT INTO qxoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mananam caychönatsu caycan. ¡Payga cawamushganam! Yarpäyay Galilea provinciachö caycarnin caynö niyäshungayquita: ");
INSERT INTO qxoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Noga ciëlupita shamog runatam jutsasapa runacunapa maquincunaman entregayämanga. Cruzchö wanutsiyämaptinpis quimsa junagtam cawamushä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsaynö angel niyaptinrämi paycunapis yarpasquiyargan Jesus tsaynö rasunpaypa ningancunata. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsaymi Jesus pamparaycangan cagpita cutiycurnin willayargan chunca juc (11) apostolcunata y tsaychö runacunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tsay willacogcunaga cayargan Maria Magdalena, Juana, Santiagupa maman Maria, y paycunawan aywag mas warmicuna. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jesus cawamunganta warmicuna willacuyaptinpis apostolcunaga manam ichicllapis criyiyargantsu, manacagcunata parlaycäyanganta yarpar. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Waquin cag mana criyiyaptinpis Pedrum itsanga cörrillapa aywacurgan Jesus pamparangan cagman. Ruriman gawaycunanpämi säbanaswan wancuyangannölla caycänä. Ayanta mana tariycurmi pasaypa mantsacashga cuticurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tsay junagmi Jesuspa ishcay gatiragnincuna aywaycäyargan Emaus marcapa. Emaus cargan Jerusalenpita ishcay öra aywaynöllam. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Paycunaga aywaycäyargan Jesusta wanutsiyanganta parlaraycarmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tsaynö parlaraycar aywaycäyaptinmi Jesus yurisquir paycunawan juntu aywargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tsaynö juntu aywaycarpis tsay discïpuluncuna manam tantiyayargantsu Jesus canganta. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsaynam Jesus tapurgan: “Jau amïgucuna, ¿imata parlartä aywaycäyanqui?” nir. Paycunaga pasaypa llaquinashga carmi ichicuycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsaynam Cleofas jutiyog cag nirgan: “Pascua fiestaman shamog runacunaga llapanmi musyayan ganyancuna Jerusalenchö ima päsacungantapis. ¿Manacu gamga musyanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niptinnam Jesus nirgan: “Mä willayämay. ¿Imatä cashga?” nir. Paycunanam niyargan: “Nazaret marcapitam Jesus jutiyog cargan Diospa willacognin profëta. Payga Tayta Diospa willacuynintam willacushga y Tayta Diospa poderninwanmi imayca milagrucunatapis rurashga. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Nogacunaga yarpäyargä Roma nacionpa mandunpita pay jipimänantsicpä cagtam. Tsaynö captinpis paytam sacerdöticunapa mandagnincunawan autoridänintsiccuna Romano autoridäcunaman entregayashga wanutsiyänanpä. Nicaptinmi Romanucuna cruzchö wanutsiyashga. Canan junagwanga quimsa junagnam Jesus wanungan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Manam tsaypis tsayllatsu. Y mas mana criyiypäga nogacunawan pureg waquin warmicuna mantsacäcuypätam willacuyan. Paycuna Jesusta pampayanganman tsaca tsacallana aywar ayantashi tariyashganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tsaypita wayiman cutiycamur willayämashga Jesus cawamunganta. Angelcunash yuripasquir paycunata Jesus cawamunganta willayashga. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tsaynöllam waquin cag discïpuluncunapis pamparangan cagman aywar warmicuna willacuyangannölla Jesuspa ayanta tariyashganatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tsaynam Jesus paycunata nirgan: “¿Imanirtä gamcunaga pasaypa llaquicushga caycäyanqui? Diospa profëtancuna niyangancuna, gamcunapä ¿imanirtä aja criyiyrä? ");
INSERT INTO qxoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manacu yarpäyanqui salvacogga ñacarcurrä wanunganpita cawasquir Tayta Diospa ñöpanman cutinanpä cagta?” ");
INSERT INTO qxoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsaypitaga paycunata tantiyatsirgan quiquinpä imanö gellgaraycanganta, Moises gellgangancunapita gallaycur waquin profëtacuna gellgayanganyag. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tsaypita Emaus marcaman chaycurnam paycunapita Jesus päsacog tucurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tsaynö päsacuyta munaptinnam: “Patsa tsacaycannam, cayllachöna quëdacushun” niyargan. Tsaynö niyaptinnam Jesus paycunawan quëdacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tsaypita wayichönam jamacurirna Jesus tantata aptarcur Tayta Diosta agradesicusquir paquirir paycunata macyargan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tsay öram itsanga tsay discïpuluncuna Jesus canganta tantiyasquiyargan. Tsaypita Jesus jinallanchömi illacasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Illacasquiptinnam quiquin pura caynö parlayargan: “Jesus captinchir shonguntsicpis atsicyasquirgan nänita sharaycämur Diospa palabranta parlapämashga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nircurnam paycuna jinan öra Jerusalenman cutiyargan. Chaycurnam tariyargan chunca juc (11) apostolcuna y waquin gatiragnincuna goriraycagta. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tsaychönam tsay ishcay Jesuswan tincog discïpulucunata apostolcuna willapar niyargan: “¡Rasunpaypam Señornintsic salvacog cawamushga! Pedrutapis yuripashgam”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niyaptinnam paycunapis willayargan nänichö imanö päsangantapis y tantata paquingan öra Jesusta regiyangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsaynö unas parlaycäyaptinmi Jesus paycunapa chöpinchö ricacusquirgan: “Gamcunachö alli cawacuy caycullätsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Paycunanam pasaypa mantsacaycuyargan alma canganta yarparnin. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tsaynö mantsacäyaptinnam Jesus nirgan: “¿Imanirtä mantsacashga caycäyanqui? Noga cangäta ¿imanirtä criyiyanquitsu? ");
INSERT INTO qxoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ricayay maquïta y chaquïtapis. ¡Nogam cä! Yatayämay. Ricayämangayquinöpis manam almatsu cä. Almaga aytsaynag y tulluynagmi”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tsaynö nirninmi ricatsirgan maquinta y chaquintapis. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tsaynam discïpuluncuna pay canganta ricaycur criyiyänanpä ajallarä captinpis cushicuyargan. Tsaynö captinmi rasunpa pay canganta criyiyänanpä Jesus mañacurirgan: “¿Imallayquicunapis cancu micurinäpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tsaynö niptinmi garayargan cancashga pescäduta. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tsaycunatam micurgan paycunapa ñöpancunachö. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Micusquirnam nirgan: “Bibliata gellgag llapan profëtacunapis gellgayarganmi nogata caycuna päsamänanpä cagtaga. Gamcunawan caycar willargä llapan tsay gellgaraycangancuna cumplinanpä cagtam. Tsay willangänöllam päsamashga”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsaynö nirmi Tayta Diospa palabran gellgarangancunata tantiyatsirgan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Tayta Dios cachamungan salvacogga wanunganpita quimsa junagta cawamunanpä cagpis gellgaraycanmi. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Musyayangayquinöpis tsay gellgarangannöllam llapanpis päsashga. Tsaymi nogapa jutïchö runacunata willapäyänayqui jutsa ruraynincunata jagirir nogaman yäracuyänanpä. Tsaynöpam Tayta Dios perdonanga jutsa ruraynincunata. Jerusalenpita gallaycur maytsaypapis aywar llapan runacunata tsaynö willapäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Gamcunamanmi noga cachamushä papänï Tayta Diosllä aunicungan Espiritu Santuta. Itsanga Jerusalenllachö shuyaraycäyanqui Espiritu Santuta chasquiyangayquiyag. Chasquicusquirnam Tayta Diospa poderninwanna cayanqui pay munangannö cawayänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsaypitanam discïpuluncunata Jesus pushargan Jerusalenpita Betania quinranman. Tsaychö caycarnam ricranta quichasquir Tayta Diosman mañacurgan paycuna mana gongaypa yäracuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tsaynö Jesus paycunapä bendicionta mañacusquiptinmi Tayta Dios ciëlupa apacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tsaychö discïpuluncuna Jesusta gonguripärasquirmi cushishga cuticuyargan Jerusalenman. ");
INSERT INTO qxoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tsay junagpitaga Tayta Diosta alabayänanpä cada junagmi templuman goricäyag. Tsaynö catsun.");
INSERT INTO qxoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Manarä imapis camashga caycaptinnam Tayta Diospa willacuyninta apamog Jesucristoga caycarganna. Imaypitapis jucllayllam Tayta Dioswan cayargan. Y pay Diosnintsicmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paywanmi Tayta Dios camargan llapan imaycacunatapis. Manam cantsu ni imapis Jesucristuwan mana camanganga. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Llapan cawagcunapis paypitarämi cawayta chasquiyan. Tayta Diospa alli willacuyninta musyatsicurninmi runacunapä actsinö caycan. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tsaynö musyatsicuycaptinpis tsacaychönö jutsallachö cawarninmi runacuna Diosnintsicta chasquiyashgatsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Tayta Diosmi acrargan Juan Bautistata Jesucristo shamunanpä cagtana willacunanpä. Pay willacurgan Jesucristuta runacuna chasquicuyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Waquin runacuna Juan Bautistapä “Tayta Dios cachamungan salvacogmi” nir yarpäyaptinpis manam paytsu cargan salvacogga, sinöga willacogllanmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesucristoga cay patsaman shamurgan llapan runacunata Tayta Diospa willacuyninta musyatsicunanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","11","Jesucristuwan Tayta Dios imaycata camashga caycaptinpis, cay patsaman shamuptin runacuna manam tantiyacuyargantsu ciëlupita shamunganta. Tsaymi mana chasquiyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Waquinmi itsanga Jesucristuta chasquicur criyiyan salvacognintsic canganta. Payta chasquicogcunatam Tayta Dios “Wamräcunanam gamcunaga cayanqui” nin. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Manam mamanpita yuringanpitatsu Diospa wamrancunaga cayan, sinöga Jesucristuta chasquicuyanganpitam. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristoga runaman ticrarmi nogantsicpa rurintsiccunachö cawargan. Paywan purirmi nogacuna musyayargä imaycawan munayyog canganta y cuyamangantsicta. Tayta Diospa japallan tsurinta ricarmi musyayargä Tayta Dios imanö cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jesucristupämi Juan Bautista willacurgan: “Shamogpä cag salvacogga nogapita mas puëdegmi. Payga manarä noga yuriptïmi imaypitapis caycarganna” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","17","Unay tiempu Tayta Dios tantiyatsiptin sirvegnin Moisesga gellgargan leycunatam. Tsaytanam quiquin Moises runacunata tantiyatsirgan. Señor Jesucristum itsanga cuyamarnintsic tantiyatsimantsic Tayta Dios perdonar salvamänantsicpä cag mushog willacuyninta. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manam pipis Tayta Diostaga ricashgatsu. Paytaga ricashga japallan tsurin Jesucristullam. Paypita shamushga carninmi musyatsimantsic Tayta Dios imanö cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jordan mayuchömi Juan Bautista runacunata bautizaycargan. Tsaymanmi Jerusalen marcachö autoridäcuna cachayargan sacerdöticunata y templuchö yanapagnincunata “¿Mä Tayta Dios cachamungan salvacogcush pay?” nir tapuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Paycuna tapuyaptinnam Juan rasun cagllata willacur nirgan: “Manam nogaga shuyacungantsic salvacogtsu cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsaynam yapay tapuyargan: “Tsayöraga ¿pitä canqui? ¿Tayta Diospa unay willacognin profëta Eliascu?” nir. Juannam nirgan: “Manam Eliastsu cä”. Paycunanam yapay tapuyargan: “Tsayöraga ¿unay Moises gellgangannö Tayta Dios cachamunanpä cag profëtacu canqui?” nir. Juannam nirgan: “Manam tsaypistsu cä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsaynam paycuna niyargan: “Tsayöraga ¿maygantä canqui? Cachayämagnïcunaman cutir willayänäpä niyämay quiquiqui pï cangayquitapis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Niptinnam Juan nirgan: “Nogaga unay Isaias gellgangannö willacogllam cä. Tsaymi cay tsunyagcunachöpis shamog runacunata willacuycä jutsancunata jagiriyänanpä. Tsaynö willacuptïmi listuna caycäyanga salvacog shamogta chasquicuyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tsaynö niptinnam Juanta fariseo cagcuna tapur niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Tayta Dios cachamungan salvacog mana caycarga, ni Elias, ni shamogpä cag profëtapis mana caycarga, tsayöraga ¿ima munayyog cayniquiwantä cay runacunata gamga bautizaycanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tsaynam Juan nirgan: “Nogaga bautizaycä yacuwanmi salvacogta chasquicuyänanpä. Payga cay patsaman chämushganam. Peru gamcuna manam tantiyayanquirätsu tsay salvacog pï canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Poderösu captin nogaga umpuycur maquinta ni chaquinta mutsaycuyllatapis manam puëdïtsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juanta tsaynöga tapuyargan Jordan mayupa wac-tsimpan Betaniachö runacunata bautizaycaptinmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsaypita warayninnam Jesus shamuycagta ricaycur Juan Bautista caynö nirgan: “¡Ricayay! Paymi Tayta Dios cachamungan salvamagnintsic. Paymi Pascua fiestachö carnishta wanutsiyangannö wanunga runacuna jutsancunapita perdonashga cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paypämi parlargä nogapita mas puëdeg canganta. Manarä noga yuricuptïmi payga imaypitapis caycarganna”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Salvamagnintsicta Tayta Dios cachamunanpä canganta musyaycarpis manarä bautizarga manam nogapis musyargötsu pï cangantapis. Tsaynö captinpis nogaga runacunata yacuwan bautizaycargö salvacog chämuptin chasquicuyänayquipämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Salvamagnintsic pï cangantapis musyanäpäga Tayta Diosmi nimargan: ‘Bautizaycaptiqui maygan runapa jananmanpis Espiritu Santo palumanö ratamuptinmi musyanqui cachamungä salvacog canganta. Payga runacunata bautizanga Espiritu Santuwanmi’. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tsay nimangannöllam Jesusman Espiritu Santo ratagta ricargö. Tsaymi gamcunata willä Tayta Diospa tsurin canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Warayninnam Jordan mayuchö Juan Bautista ishcag discïpulunwan caycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tsaynam tsaypa Jesus päsaycagta ricasquir Juan nirgan: “¡Ricayay! Paymi Tayta Dios cachamungan salvamagnintsic” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tsaynö ninganta wiyarnam Juanta dejasquirna, ishcan discïpuluncuna Jesusta gatircur aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tsaynam gepan aywagcunaman ticraycur Jesus tapurgan: “¿Maypatä aywaycäyanqui?” Niptinnam niyargan: “Taytay, ¿maychötä gam tanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesusnam nirgan: “Acu, aywashun. Regitsiyäshayqui”. Tsaynam juntuna aywayargan patsaranganyag. Y patsa tardiyaptinnam tsayllachö quëdacuyargan parlacur. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan Bautista ninganta wiyarir Jesusta gatir jucag aywagga cargan Simon Pedrupa waugin Andresmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tsaypitanam Andres jinan öra aywacurgan waugin Simonta ashegnin. Tincusquirnam nirgan: “¡Nogacunam Tayta Dios cachamungan salvacogwan tincuyargö!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tsaynam Andres wauginta Jesusman pushargan. Chäriyaptinnam Simonta ricaycur Jesus nirgan: “Gamga Jonaspa tsurin Simonmi canqui. Cananpitaga jutiqui canga Pedrum” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Warayninnam Galilea provinciaman aywayta Jesus yarpargan. Tsaynö yarpachacur caycanganchö Felipiwan tincusquirnam nirgan: “Acu, nogawan aywacushun discïpulü canayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida marcapitam Felipega cargan. Tsaychö yuricogmi cayargan Andreswan Pedrupis. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesus tsaynö niptinnam Felipe aywacurgan Natanaelta ashegnin. Tincusquirnam nirgan: “¡Tincusquiyargö Tayta Dios cachamungan salvacogwanmi! Payga Nazaret marcapita Josepa tsurin Jesusmi canä. Paypämi unay Moises y waquin cag profëtacuna gellgayargan cay patsaman shamunanpä cagta. ¡Y chämushganam!” ");
INSERT INTO qxoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tsaynam Natanael nirgan: “Nazaret marcapitaga ¡imayllatä pipis alli runa cashga!” nir. Niptinnam Felipe nirgan: “Masqui ¡acu, aywashun reginayquipä!” ");
INSERT INTO qxoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Washa lädunta yaycuycagta ricasquirnam runacunata Jesus nirgan: “Cay runaga mana mantsacuypa parlagmi. Paymi sï, selläma Israel runaga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tsay ninganta wiyarnam Natanael tapurgan: “Taytay, ¿imanöpatä nogata gam regimanqui?” nir. Tsaynam Jesus nirgan: “Nogaga musyämi imanö shonguyqui canganta y maychö cangayquitapis. Felipe manarä gayashuptiquim nogaga ricargö hïgus jachapa rurinchö jamaraycangayquitapis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsaynö niptinnam Natanael nirgan: “Taytay, Diospa tsurinmi gamga canqui, Israel runacunapa mandacognin nogacuna shuyacuyangä rey” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tsaynam Jesus nirgan: “¿‘Hïgus jachapa rurinchömi ricargö’ niycullaptïcu, gam tantiyanqui Tayta Diospa tsurin cangäta? Cananpitaga imaypis mana nunca ricayangayquitam gamcunata ricatsiyäshayqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","¿Yarpäyanquicu unay Jacob suëñuyninchö angelcuna ciëlupita uraycämogta y witsaycagta ricanganta? Tsayta suëñuyninchö ricarmi Jacob tantiyargan Tayta Dios paywan caycanganta. Tsaynömi gamcunapis milagru rurangäcunata ricar tantiyayanqui Dios gamcunawan caycanganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tsaypita quimsa junagtanam casacuy fiesta cargan Galilea provinciachö Cana jutiyog marcachö. Jesuspa mamanpis tsaychömi caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y Jesuspis discïpuluncunawan invitädum cayargan tsay casacuy fiestaman. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tsaynam casacogpa pullan fiestachö vïnuncuna ushacasquiptin Jesusta maman caynö nirgan: “Vïnuncunam ushacasquishga. ¿Maypitarä canan jipiycäyämunga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusnam nirgan: “Mamïta, ¿imanirmi tsayta nicämanqui? Manaran örä chämunrätsu milagruta ruranäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tsaynö niptinpis maman payman yäracurnam tsay fiestachö yanapacogcunata nirgan: “Wawä mandayäshungayquillata rurayay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tsaychömi jogta jatusag magma aswanacuna cargan. Tsay aswanacunaga Israel runacunapa üsuncunaman consagrädu yacu wiñaragmi cargan maquincunata awir purificacuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tsaynam Jesus tsay yanapacogcunata nirgan: “Cay aswanacunaman yacuta wiñayay” nir. Paycunanam yacuta juntag juntag wiñariyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesusnam nirgan: “Canan ichic chagarcur apapäyay sirvienti yawananpä”. Tsaynam Jesus ningannö yanapacogcuna chagarcur apapäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tsay sirvientinam yawarirgan alläpa shumag vïnuta. Manam musyargantsu yacullapita canganta. Yanapacogcunallam musyayargan aswanaman yacuta wiñashga car. Tsay sirvientinam noviuta gayarirnin caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“¡Achallag jau, cay vïnoga imaläya shumagtä! Caynö fiestacunachöga allin cag vïnutarämi puntataga garacuntsic. Tsaypitarämi lluta cagtaga garacur gallantsic. Gamga cay allin cag vïnutachä cay örayag churarätsirguyqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tsay “Cana” ningan marcachö yacupita vïnuman ticratsirmi Jesus rurargan punta cag milagruta. Tsayta ricarmi discïpuluncuna tantiyacuriyargan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsaypitanam Capernaum marcaman Jesus aywargan mamanwan, waugincunawan, y discïpuluncunawanpis. Tsaychöga patsaräyargan juc ishcay junagcunallam. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel runacunapa Pascua fiestancuna yaycapaycaptinnam Jerusalen marcaman Jesus aywargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tsayman chärirnam taririrgan templupa puncuncunachö runacuna ranticuycäyagta torïtucunata, üshacunata, y palumacunata. Nircurnam tarirgan gellë trocatsegcunata. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsayta ricaycurnam chicötiwan astarnin gargurgan üshantinta torïtuntinta templupita tsay sacyacog runacunata. Y gellë trocatsegcunapa mësancunatapis cumar ushargan gellënincunapis chipyaypa mashtacagpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tsaychö paluma ranticogcunatanam ajäpar nirgan: “¡Wagtaman caycunata jipiyay ras! Cay temploga papänïman mañacuna wayim. Ama mercädutanöga llutaga catsiyaytsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesus tsaynö ruranganta ricärirninmi discïpuluncuna yarpasquiyargan Diospa palabranchö caynö gellgaraycanganta: “Wanutsiyämaptinpis Tayta Diosta adorayänan wayitam michäcur respitatsishä” ninganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tsaynam Israel autoridäcuna niyargan: “¿Ima puëdeg cayniquiwantä cay ranticogcunata garguruyqui? Mä, ima milagrutapis ruramuy Tayta Dios rasunpa cachamushungayquita musyayänäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Niyaptin Jesusnam nirgan: “Cay templuta juchutsiyay milagruta ricayta munarga. Tsaytanam noga quimsa junagllata sharcaratsimushä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsaynam paycuna caynö niyargan: “¡Imanötä cayga! Cay templutaga chuscu chunca jogta (46) watachöran sharcatsir ushayargan. ¿Tsaytsurä gamga quimsa junagllata sharcatsinquiman?” ");
INSERT INTO qxoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tsaynö nirga Jesus manam templuta yapay sharcatsinanpä cagtatsu parlargan, sinöga wanunganpita quimsa junagllata cawamunanpä cagtam. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","“Sharcaratsimushä” ningantaga discïpuluncuna yarpasquiyargan Jesus wanurir cawamuptinran. Tsayrämi tantiyasquiyargan Diospa palabranchö gellgaranganpis y Jesus parlanganpis rasunpa camacanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tsay Jerusalen marcapa Pascua fiestancunachö Jesus caycarninnam tucuyläya milagrucunata rurargan. Tsaycunata ricarninnam atscag runacuna tantiyayargan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Peru Jesusga musyaycarganmi runacuna janan shongulla payman criyiyanganta y shonguncunachö imata yarpäyangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juc fariseo runam cargan Nicodemo jutiyog. Payga Israel runacunapa autoridäninmi cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi juc tsacay Jesusman aywaycur caynö nirgan: “Taytay, nogacuna musyayämi Tayta Dios yachatsiyämänayquipä cachamushungayquita. Tayta Dios mana yanapaptinga manam pipis milagrucunata ruranmantsu gamnöga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tsaynö niptinnam Jesus nirgan: “Jau, cananmi tantiyatsishayqui. Gampis yapay mana yuricurga imaypis manam ciëluman chanquitsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tsaynam Nicodemo espantashga nirgan: “Rucu runana caycarga ¿imanöpatä yapay yurïman? ¿Pipis mamanpa pachanman yapay cutinmantsurä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tsaynam Jesus nirgan: “Manam mamayquipa pachanman cutinayquipätsu nicä, sinöga yacuwan y Espiritu Santupa munayninwan yacupita yapay yurinayquipämi. Tsaynö mana yuricurninga jutsayquicunapita limpiashgana mana carga imaypis manam ciëluman chanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Manam pipis mamanpita yuringanpitatsu Diospa wamrancuna cayan. Espiritu Santupa munayninwan yuricunganllapitam Diospa wamrancunaga cayan. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","¿Cay niycungätacu yarpachacunqui? Ni imanö captinpis llapan runacunapis yapayran yuriyänan salvacuyänanpäga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Vientoga maypitapis tsaypapis vientumun munanganpam. Wallwallyagta mayarninpis runacuna manam tantiyayantsu maypita shamunganta ni maypa aywanganta. Tsay cuentanöllam runacuna tantiyayantsu Espiritu Santo munayninwan yuricatsir mushog cawayman ticratsiptinpis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsaynam Nicodemo nirgan: “¿Imanörä canman ari? Manam tantiyallätsu, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tsaynö niptinnam Jesus nirgan: “Israel runacunapa yachatsegnin caycarpis ¿cay ningäta manachi tantiyaycunquitsu? ");
INSERT INTO qxoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nogam musyangäcunata y ciëluchö ricangäcunata willapaycä. Tsay ningäcunata tantiyaytaga tantiyanquim, peru itsanga manam criyimanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Espiritu Santupa munayninwan yuricuypä cagta mana criyicamarga ¿imanöparä criyimanquiman ciëluchö cagcunapita willapaptïnäga?” ");
INSERT INTO qxoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Manam pipis ciëluman aywar cutimushgatsu tsaychö imanö cangantapis willamänantsicpä. Nogallam ciëluchö caycangäpita Tayta Dios cachamaptin cay patsaman shamurgö willacunäpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tsaypitanam Tayta Dios munanganta cumplir wanushä. Musyangayquinöpis tsunyagta aywarmi unay Moises broncipita culebratanö ruraycur tucrupa puntanman warcurcur sharcatsirgan. Tsaynöllam nogatapis cruzman clavarcurnin sharcatsiyämanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tsaynö wanuptï nogaman yäracamog cagcunaga ciëluman chäyangam imayyagpis cawayänanpä”. Tsaynömi Nicodemuwan Jesus parlayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Cuyacog Tayta Diosllantsic runacunata alläpa cuyaparninmi cay patsaman cachamurgan cuyay japallan tsurinta. Pipis payman yäracog cagcuna infiernuman manam aywayanganatsu, sinöga gloriamanmi aywayanga imayyagpis tsaychö cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tsurinta Tayta Dios cachamurgan runacunata jutsancunapita perdonar salvananpämi, manam infiernuman gaycunanpätsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tsaymi pipis tsurin Jesucristuman yäracurninga mana infiernuman aywanganatsu. Peru waquincunaga mana yäracuyanganpitam infiernuman aywayanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Jesucristo cay patsaman shamur runacunata tantiyatsirgan jutsasapa cayangantam y rasunpa Tayta Diospa perdonninta miñishtiyangantam. Tsaynö tantiyaycätsiptinpis tsacaychönö cawar jutsancuna musyacänanta mana munarmi Jesucristuta mana chasquicuyantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jesucristuta chasquicog cagcunam itsanga jutsancunata jagiriyan. Tsaynö jagiriyaptinmi allina cawayänanpä Tayta Dios yanapaycangan musyacan. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nicodemuwan parlasquirnam Jesus aywargan discïpuluncunawan Judea provincia marcacunapa. Tsaychönam discïpuluncuna juc ishcay junagcuna runacunata bautizayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Juan Bautistapis jinallam runacunata bautizaycargan autoridäcuna carcelman manarä wichgatsiyaptin. Juanga “Enon” ninganchö, Salim marcapa lädun ricogllachömi runacunata bautizargan. Tsaychö lasag yacu captinmi atsca runacuna aywayargan tsayman bautizacog. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tsay junagcunam Juan Bautistapa discïpuluncunata juc runa nirgan: “Juan bautizanganpita mas allega Jesus bautizangan cagmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tsaynö niptinnam Juanta discïpuluncuna niyargan: “Taytay, Jordan mayupa wac-tsimpanchö runacunata bautizaycaptiqui chämurgan juc runa bautizag. Tsay runapämi niyämargayqui: ‘Cay runaga Tayta Dios cachamungan salvacogmi’ nir. Cananga paypa discïpuluncunapis atsca runacunata bautizaycäyanchä. Tsaynachir llapan runacuna payllamanna bautizacog aywacuyan. Nogantsicmanga shayämunnatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tsaynam Juan caynö nirgan: “Tsaynö alläpa atsca aywayan paymanga, Tayta Dios tsaynö cananpä permitishga captinmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamcuna wiyayangayquinöllam noga nirgä: ‘Manam quiquïtsu salvacogga cä’ nir. Nogataga Tayta Dios cachamashga salvacog chämunanpäna willacunäpämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jipashwan juc noviu casacuptin amïgun cushicungannöllam, nogapis alläpa cushicü runacuna salvamagnintsicmanna aywayaptin. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Manam yarpachacuyänayquitsu runacuna nogaman manana shamuptin. Tsaynö cananpämi Tayta Dios camacätsishga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ciëlupita shamushga carmi Jesusga imaycawanpis alläpa munayyog caycan. Nogaga cay patsallapita carmi paymanga mana ichicllapis iwalätsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tayta Dios cachamungan salvacogga willamantsic ciëluchö wiyangantam y ricangancunatam. Tsaynö willacuptinpis waquin runacuna manam criyiyantsu pay ningancunataga. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jesusman criyicogcunam itsanga tantiyayan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tsaycunataga paymi willacuycan Espiritu Santupa munayninwan. Paynöga ni pipis manam willamantsictsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Tayta Dios poderösu carninmi imaycatapis churashga cuyay tsurinpa maquinman quiquinnö munayyog cananpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pipis Tayta Diospa tsurinta chasquicog cagga cay patsachö y gloriachöpis cushishgallam cawanga. Mana chasquicog cagcunam itsanga tsay alli cawacuyta tariyangatsu. Paycunaga infiernuchömi ñacayanga imayyagpis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseucunaga musyariyargan Juan Bautistapita mas atscagtana runata Jesus bautizaycangantam. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Peru rasunpa cagga manam quiquin Jesustsu cargan, sinöga discïpuluncunallam bautizaycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseucuna parlayanganta Jesus musyarirnam Judea provinciapita Galilea provinciaman discïpuluncunawan cuticurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judeapita Galileaman nänega päsargan Samaria provinciaparämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tsay nänipa aywaraycarnam Samariachö “Sicar” ningan marcaman chäriyargan. Tsay marcachömi unay Jacob tsurin Joseta chacran jagipänä. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tsay chacrachömi Jacob pözuta uchcutsinä yacupä. Tsaynam pullan junagna captinmi Jesus aywaycanganta pishipasquir tsay pözu cagman jamasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Discïpuluncunaga micuyänanpä rantipacogmi marcapa aywashga cayargan. Aywayanganyag tsay pözu cagchö jamapaycaptinnam juc Samaria warmi yacucog chärirgan. Tsay warmitam Jesus yacuta mañacurgan: “Yacuyquita gararamay upurcunäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Israel runacunawan Samaria runacuna mana alli ricanacuyaptinmi tsay warmega espantacur caynö nirgan: “Noga Samaria warmitaga ¿imanöpatä gam Israel runa caycar yacuta mañacamanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tsaynö niptinnam Jesus caynö parlapargan: “Tayta Diospa palabran gellgaranganta tantiyarga y pï cangäta musyarga gammi nogata yacutaga mañacamanquiman. Mañacamaptiquega tsuya yacutam garaycüman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tsaynam warmi nirgan: “Taytay, manachä chaganayquipä imayquipis capushunquitsu. ¿Imanöparä tsayläya ruripita yacuta jipimunquiman garamänayquipä? ");
INSERT INTO qxoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Unay Jacobmi cay pözuta uchcutsinä yacuta upuyänanpä. Cay pözullapitam castancuna, ashmancuna, y quiquinpis yacuta upuyänä. Paypis cay yacullata upushga caycaptinga gamga, ¿maypitatä jipimunquiman tsay nimangayqui yacuta garamänayquipäga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tsaynam Jesus nirgan: “Pipis cay yacullata upog cagga yapaypis yacunaycangallam. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noga garangä yacuta pipis upog cagga manam imaypis yacunanganatsu. Tsay yacum sïga cawatsicog mana imaypis pullcaypa aywag yacoga. Tsayta upurga mana ushacag cawaytam tarinqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tsaynö niptin warmega mana tantiyarmi nirgan: “Taytay, mä tsay tsuya yacuyquita garaycallämay manana yacunänäpä ni imaypis manana yacu jipeg cayman shamunäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesusnam nirgan: “Canan aywar runayquita gayamuy y shayämuy cayman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tsaynam warmi nirgan: “Runäga manam cantsu, taytay”. Niycuptinnam Jesus nirgan: “Rasuntam nicämanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Peru pitsgam runayqui capushurguyqui. Canan tsarangayqui cagpis manam runayquitsu. Tsaytaga rasun cagtam nimarguyqui runayqui mana canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsayta wiyarnam warmi nirgan: “Taytay, gamga Tayta Dios ninganta parlag profëtam ëllu canqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tsayöraga mä tapurishayqui. Unay awilücunaga tagay jircaman aywaycurmi Tayta Diosta adoracuyag. Peru Israel runacunaga niyanqui: ‘Jerusalen marcallachömi Tayta Diostaga adoracunantsic’ nir. Mä ¿maychötä adorashwan?” ");
INSERT INTO qxoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tsaynö niptinnam Jesus caynö nirgan: “Mä wiyamay, warmi. Cananpitaga manam aywayanquinatsu Tayta Diosta adoracog tagay jircaman ni Jerusalenman. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tayta Diosta adorarpis gamcunaga manam shumag musyayanquitsu pay imanö cangantapis. Quiquin Tayta Dios Israel runacunata tantiyatsishga captinmi nogacuna musyayä Tayta Dios imanö canganta y imanöpa salvamänantsicpä canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Israel runacuna y mana Israel runacunapis Espiritu Santo tantiyatsiptin llapan shonguncunawan Tayta Diosta adoracuy tiempu chämushganam. Tsaynö adoranantsictam payga munan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tayta Diosga Espiritu carmi maychö tsaychöpis caycan. Tsaymi maytsaychöpis Espiritu Santo munangannö llapan shonguntsicwan paytaga adoranantsic”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Warminam nirgan: “Noga musyämi cay patsaman juc salvacog shamunanpä cagta. Pay chämurnam tsaycunata tantiyatsimäshun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesusnam nirgan: “Tsay salvacogpä nicangayquega nogam cä, canan öra gamwan parlaycag” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tsaynö parlaycäyaptinnam discïpuluncuna rantipacuynincunawan chäriyargan. Tsay Samaria warmiwan parlaycagta tariycurnam espantashga quiquincuna pura ricaränacuyargan. Itsanga manam mayganpis tapuyargantsu imanir parlayangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tsaypitanam tsay warmi yacucuna uyllunta jagiriycur marcapa cörrillapa aywacurgan runacunaman willacog: ");
INSERT INTO qxoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“¡Shayämuy! Llapayqui shayämuy caychö caycag runata regiyänayquipä. Paymi nogata niycamashga imaycata rurangäcunatapis. ¿Paytsurä ciëlupita salvacog canman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tsaynö warmi willacuptinnam Jesusman atscag marca mayincuna aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tsayyagnam Jesusta discïpuluncuna niyargan: “Taytay, micurillay ari cay apayämungäta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tsaynö niyaptin paynam nirgan: “Nogapa micuynëga jucrämi. Tsayta manaran musyayanquitsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tsaynö niptinnam quiquincuna pura ninacuyargan: “Pï carpis imallatapis may apapäyämushgam micunanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tsaypitanam Jesus nirgan: “Nogapa micuynëga cachamagnï Tayta Dios mandamanganta cumplingämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mä wiyarcayämay. Runacuna parlayanmi: ‘Usya tiempupä chuscu quillarämi faltan, tsayrämi cosëcha gallanga’ nir. Nogaga nï: Murucuynincunata cosichayänanpä listu caycaptin o manarä listuna caycaptinpis, cay shamuycag Samaria runacuna Diospa willacuyninta wiyayänanpä listunam caycäyan. Tsaynö wiyacur nogaman criyicogcunaga mana ushacag cawaytam tariyanga. Ima cushicuypärä caycunga tsay runacuna ciëluchö cosëcha cuentanö goricar”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Willacungantsicta chasquicogcuna cay patsachö y gloriachöpis cushishgallam cawayanga. Tsaynö chasquicuyaptinmi alli cosëcha captin cushicungantsicnö pasaypa cushicushun”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","“Puntata murucog cuentam unay profëtacuna willacuyargan noga shamunäpä cagta. Canan chämushgana carmi gamcunata cachaycä willacuynïta willacuyaptiqui nogaman criyicayämunanpä. Tsaymi willayangayquita runacuna chasquicuyaptin cosëchata goreg cuenta caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tsaynö Jesus discïpuluncunawan parlaycäyaptin tsay Samaria warmega marcanchö acataycachayparan willacurgan: “Jesusmi shimpiycamashga imayca ruraynïcunata” nir. Tsaynö willacunganta wiyarninnam atscag marca mayincuna criyiyargan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tsaynam Jesusman chaycur Samaria runacuna rugayargan paycunawan quëdarinanpärä. Tsaynö rugayaptinnam ishcay junag paycunawan quëdacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesus tsaychö yachatsicuptinmi mas atscag runacuna criyicuyargan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tsaynö criyicurninnam tsay warmita runacuna niyargan: “Manam gam niyämaptiquillarätsu Jesusman criyicuyä. Cananga pay yachatsicunganta quiquïcuna wiyarmi musyayä runacunata salvananpä Tayta Dios cachamunganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ishcay junag Samariachö goyärirnam marcan Galilea provinciaman päsacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Galilea runacunaga Pascua fiesta päsag Jerusalenman aywashga carmi ricayargan tsaychö Jesus milagru rurangancunata. Y Galileaman Jesus chäriptinnam yapay milagruta ruranganta ricayta yarpar marca mayincuna cushicuyargan. Itsanga manam ichicllapis criyiyargantsu yachatsicuyninmanga. Marca mayincuna tsaynö mana criyiptinmi Jesus nirgan: “Diospa willacuyninta willacogcunata marca mayincunaga manam cäsupäyantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Tsaypita päsarirnam Galileachö Cana marcaman Jesus cutirgan. Tsaychömi punta cag milagruta rurar yacuta vïnuman ticratsirgan. Tsaychö Jesus caycanganta musyasquirmi Capernaum marcapita juc autoridä aywargan tsurin geshyaptin. Tsaynam Jesuswan tincusquir rugacurnin nirgan: “Taytay, wamrallä wanuycannachä. Wayilläpa shamuycullay ari alliycatsillänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tsaynam Jesus nirgan: “Gamcuna Diospita shamungäta criyiyämanquimanräcu imayca milagrucunata ruragta mana ricamarga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Niptinnam tsay autoridä nirgan: “Taytay ñïñu, manarä wamrallä wanuptin jinallachö aywayculläshun ari” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tsaynam Jesus nirgan: “Wayiquipa cuticuyna. Tsuriquega alliyashganam” nir. Jesus ninganman yäracurnam runa cuticurgan marcanpa. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Warayninnam marcanman yaycuraycar tincusquiyargan sirvegnincuna taripagnin aywagwan. Tsaynam niyargan: “¡Antis tsurillayquega allisquishganam, taytay!” ");
INSERT INTO qxoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Niyaptinnam tapurgan: “¿Imay örapitatä wamrallä jucläyargan?” nir. Paycunanam niyargan: “Ganyan pullan junag tumaypitam jucläyärirgan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsaynö niyaptinnam runa yarpärirgan tsay örachö Jesus “Tsuriquega alliyashganam” ninganta. Tsaynam wayinchö cagcunawan llapancuna criyicuyargan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tsay wamrata allïtsir ishcay cutinam milagruta Jesus rurargan marcan Galilea provinciachö. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsaypitanam Jesus aywargan Jerusalen marcachö Israel runacunapa fiestancunaman. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenchö “Üsha yaycunan puncu” ningan cagchömi can juc jatun armacuna quita. Hebreu parlaychöga tsay quitata niyan “Betesda” nirmi. Tsay quitaga pitsga puncuyogmi cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tsay puncucunachömi atscag geshyagyashga runacuna, gapracuna, ratacuna, inväliducuna patsachö jitaräyagllana. Paycunam tsay quita cagchöga shuyarar caycäyag yacu cuyuycachagtam. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tsay yacutam cuyurcatsegyan ciëlupita unay unayllata urämur juc angel. Tsaymi yacu cuyusquiptin tsay quitaman punta yaycog cagga imayca geshyapitapis allisquiyag. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tsaychömi caycargan juc runa quimsa chunca puwag (38) watana geshyacog. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tsaynam tsay runa jitaraycagta Jesus ricaycurnin atsca watana geshyanganta tantiyapasquir tapurgan: “¿Alliyta munanquicu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tsaynam runa nirgan: “Aumi, taytay, alliytaga munallämi. Peru quitachö yacu cuyuycachascamuptin manam ni pïnïpis cantsu tsay öra jitarpamänanpä. Sharcur ñacangäyagmi jucna llalliscamar ullurpun”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Niptin Jesusnam nirgan: “Canan sharcur gopiquita aparcur aywacuy”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","10","Niycuptin jinallachömi runa allisquir gopinta goricurcur cushishga aywacurgan. Säbadu jamapay junag captinmi Israel autoridäcuna tsay alliyashga runata caynö niyargan: “Jau runa, ¿imanirtä canan jamapäcuy junagchö gopiqui aparicushga puriycanqui leynintsicpa contran caycaptin?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tsaynam runa nirgan: “Allïtsimagnï runam nimashga: ‘Gopiquita aparcur aywacuy’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsaynö niptinnam autoridäcuna tapuyargan: “Gopiquita aparcur aywacunayquipä ¿pitä nishurguyqui?” ");
INSERT INTO qxoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Peru tsay runa manam musyargantsu ni maygan allïtsingantapis, atscag runacuna tsaychö goricashga cayaptin. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsaypitanam templuchöna tsay runawan tincusquir Jesus nirgan: “Cananga allishganam canqui. Amana jutsa rurayman cutiynatsu. Yapay jutsa rurayman cutirga geshyangayquipitapis mas peyormi geshyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tsaynö niycuptinnam tsay runa autoridäcunaman aywargan willag Jesus allïtsinganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Säbadu jamapay junagchö runata allïtsinganpitam Israel autoridäcuna Jesusta chiquipäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Chiquipäyanganta tantiyasquirnam Jesus nirgan: “Papänï Tayta Dios imaycay örapis allillata ruraptinmi nogapis paynölla allita rurar tsay runata allïtsirgö”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tsaynö niptinmi tsay autoridäcuna yarpäyargan Dios tucunganta. Jamapay säbaduta mana cäsunganpita masga ajäyargan “Papänïmi Tayta Dios” ningantam. Tsaycunapitam masrä chiquirnin wanutsiyta munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tsaypita Jesusnam nirgan: “Manam quiquï munangällatatsu rurä. Tayta Diospa tsurin car papänï rurangannöllam nogapis ruraycä. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","21","Munanganta ruranäpämi tsurin captï poderninta nogaman churamushga. Tsaymi fisyu finalchö wanushgacunata papänï Tayta Dios cawatsimunanpä munayyog cangannö nogapis wanushgacunata cawatsimunäpä munayyog cä. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nircurmi llapan runacunata juzgashä imanöpis cawayanganman. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tsaymi noga tsurintaga respitayämänan. Maygan runapis nogata mana respitamarninga cachamagnï papänïtapis manam respitayantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Shumag tantiyayämay. Pipis willacungäta wiyacur y cachamagnï papänïman yäracurga manam infiernuman aywangatsu, sinöga gloriamanmi aywanga tsaychö imayyagpis cawacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Paycuna cay patsachö ñacarpis nogaman yäracamurga cushishgallam cawayanga. Wanuyaptinnam wanunganpita cawatsimushä. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wanushgacunata cawatsimunäta y cäsumag cagcunata yanapanätam papänï Tayta Dios munan. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tsaynöllam Tayta Diospita shamushga car llapan runacunata juzgashä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ama tsay ningäcunata espantacuyaytsu. Chämungam juc junag llapan pamparagcunatapis noga cawatsimunäpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Alli rurag cagcunam gloria vïdachö imayyagpis cawayanga. Mana alli rurag cagcunaga infiernullachönam imayyagpis ñacacuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Papänï munanganta cumplirmi juzgashäga pï allita ruranganta, pï mana allita rurangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Gamcuna cay nicangäcunata manam criyiyämanquitsu ‘Jesusga quiquillanpitam willacun’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tsaynö llutancunata yarparmi pantayanqui. Papänï Tayta Dios atscaläyapam tantiyatsiyäshunqui noga willacungä rasun caglla canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Tayta Dios cachamurgan Juan Bautistata puntamur nogapä willapäcuraycänanpä. Payman gamcuna musyapacogcunata cachayaptiquim niyäshurgayqui: ‘Jutsayquicunata jagisquir listuna cayay salvacog shamogta chasquicuyänayquipä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","35","Tsayta wiyasquirmi gamcuna tsay öralla ardë cushishga wiyag tucusquiyargayqui. Cananmi Juan niyäshungayquita tantiyatsiyäshayqui. Noga pï cangäta musyar salvacuyänayquipämi payga willacurgan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nogapä Juan willacunganta criyir mana criyirpis tantiyacuyanquimanmi Tayta Dios cachamaptin shamungäta, noga rurangä milagrucunata ricaycarninga. Tsay rurangäcunaga Tayta Dios munangannöllam. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tsaynöllam Tayta Diospis musyatsiyäshunqui nogata cachamanganta, quiquin mana parlapäyäshurniquipis y mana yuripäyäshurniquipis. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tsaynö musyaycätsiyäshuptiquipis nogata mana chasquicamarga Tayta Diosta manam cäsucuycäyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Gamcunaga Tayta Diospa palabran gellgaranganta liyir yarpäyanqui: ‘Tsayta cäsucullarmi Tayta Dioswan mana ushacag cawayta tarishun’ nir. Tsay yarpäyangayquicunaga noga shamunäpä cagnam gellgaraycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tsaynö caycaptinpis gamcuna manam nogata chasquimayta munayanquitsu. Mana chasquicamarga mayjina yachacurpis alli cawayta manam imaypis tariyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","“Noga musyämi Tayta Diostaga ardëlla cäsog tucuyangayquita. Tsaynö captinpis nogaga willacuycäshällam gamcuna chasquiyämaptiqui o mana chasquiyämaptiquipis. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cachamag papänï Tayta Diosta rasunpaypa cäsurninga nogatapis cäsumar chasquiyämanquimanmi. Mana alli rurayniquicunata parlapaptïmi gamcuna chiquipäyämanqui. Sïcush pipis quiquinpa munayllanpita shamunman gamcunata alabapäyäshur, tsaytaga cushishgaran chasquiriyanquiman. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tsaynö quiquiquicuna puralla allichö cayta munar alabanacuycarga ¿imanöparä Tayta Dios munangannö cawayanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","“Gamcuna yarpäyanqui nogata mana chasquiycämarpis unay Moises gellgangan leycunata cumplillar salvacuyänayquipä cagtam. Manam tsaynötsu. Moises gellgangancunachöga nogapämi gellgaraycan. Tsay gellgangancunata rasunpa cäsurga noga ningäcunatam chasquiyanquiman. Nogapä gellgangancunata mana cäsuyangayquipita quiquin Moisesmi shimpiyäshunqui Tayta Diospa ñöpanchö. ");
INSERT INTO qxoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moises nogapä gellgangancunata mana cäsucuycarga ¿criyiyanquimanräcu noga parlangäcunatapis?” ");
INSERT INTO qxoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsaypitanam Galilea gochapa wac-tsimpanman Jesus päsargan. (Tsay gochapa jucag jutinmi Tiberias gocha.) ");
INSERT INTO qxoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tsaypa päsaptinmi gepanta atscag runacuna aywayargan geshyag runacunata allïtsinganta ricashga carnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tsaynam Jesus juc jircanman witsarcur discïpuluncunawan tsaychö jamaraycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tsaypa gepancunata aywagcunachömi cayargan Jerusalenman Pascua fiestacog aywagcunapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tsaynam paycuna cagman atscag runacuna witsaraycäyagta ricar discïpulun Felipita Jesus tapurgan: “Caytsicag runacuna micuyänanpä ¿canan maypitarä micuyta rantimushun?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesus tsaynöga tapurgan Felipe imaningantapis musyananpämi. Payga musyargannam micuyta imanöpa garananpä cagtapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tsay Felipimi nirgan: “Puwag (8) quillachö arupacur gänapacungantsicwan rantishgapis ¡maypitarächi tincutsishwan llapancuna ichic ichiclla micuriyänanpäpis!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsaynam Simon Pedrupa waugin Andres Jesusta caynö nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Taytay, caychö juc ollgu wamrapam caycäpun pitsga cebäda tantanwan ishcay pescädun. Peru tsayllaga ¿tincunmanräcu caytsica runacunapäga?” ");
INSERT INTO qxoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Niptin Jesusnam discïpuluncunata nirgan: “Runacunata niyay tsay shumag gewacuna jananllachö jamacuriyänanpä” nir. Tsaychö runacunaga pitsga waranganömi (5,000) cayargan ollgu cagcunalla, warmicuna ni wamracunapis mana yupashga. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nircurnam tsay pitsga tantata Jesus tsarircur Tayta Diosta agradesicurgan. Tsaypitanam discïpuluncunata macyargan runacunata aypuyänanpä. Tsaynöllam ishcay pescäducunatapis rurargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Runacuna pachajunta micusquiyaptinnam discïpuluncunata Jesus nirgan: “Llapan putsogcunata goriyay imatapis mana jagiypa”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Niptin discïpuluncunanam putsogta goririyargan chunca ishcay (12) canastacunaman juntag juntag. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tsay milagruta Jesus ruranganta ricaycurninnam runacuna cushicur espantashga caynö ninacuyargan: “Cay runaga rasunpachä unay Moises gellgangan shamunanpä cag profëta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tsaycunata ricarmi runacuna yarpäyargan imaycanöpapis reynincuna churayänanpä. Señor Jesusga rey churayänanta mana munarmi japallanna jircaman aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tsaypitanam tsacanaycaptinna discïpuluncuna Galilea gocha cuchunman aywayargan Jesusta shuyäyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesus jircapita mana charcuptinnam tsacanaptinna discïpuluncuna büquiman yarcurcur quiquillancunana wac-tsimpa Capernaum marcaman aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tsay jatun gocha jananta aywaycäyaptinnam pasaypa vientuptin gochaga alläpa lagchicachar gallacuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Carutana aywaycarninnam Jesusta ricasquiyargan yacu jananpa japar paycunaman aywaycagta. Tsaynö aywaycagta ricasquir pasaypam mantsacäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tsaynam Jesus gayacur nirgan: “¡Ama mantsacäyaytsu! Jesusmi noga cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsaynö niptinnam cushicur büquiman Jesusta janchayargan. Y rasllanam aywaycäyangan marcamanpis chäriyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsay quëdag runacunaga musyayarganmi jucllaylla büqui caycagwan Jesuspa discïpuluncuna aywacuyanganta. Tsaynam warayninga yapay goricäyargan tsaychö Jesuswan tincuyta munar. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tsaynö goriraycäyagman Tiberias marcapitapis juc runacuna büquincunawan chäyarganmi Jesus tantata miratsinganta musyashga car. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tsaychö Jesustapis ni discïpuluncunatapis mana tarirnam llapancunana jinan öra aywacuyargan tsay büquicunawan Capernaum marcaman Jesusta ashir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tsaynam Galilea gochapa wac-tsimpanman chärir Jesus yachatsicuycagta tarisquiyargan. Tsaynam tapuyargan: “Taytay, ¿imanöpatä cayman shamurguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Niyaptin Jesusnam nirgan: “Gamcuna ashiycäyämanqui manam Tayta Dios cachamanganta tantiyartsu, sinöga pachajunta micutsingällapitam. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama yarpachacuyaytsu pacha micuyllapäga. Tsayga ushacärinllam. Tsaypa rantinga yarpachacuyay Tayta Dios munangannö mana ushacag cawayta tariyänayquipä cagta. Tsay alli cawayman chätsinäpämi papänï Tayta Dios cay patsaman cachamashga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tsaynö niptinnam runacuna tapuyargan: “Tsaynö imayyagpis cawayänäpä tsayöraga ¿imata rurayänätatä Tayta Diosga munan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tsaynam Jesus nirgan: “Tayta Diosga munan noga tsurinman criyicayämunayquitam. Tsaypämi cay patsaman cachamashga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Niptin runacunanam niyargan: “Diospa tsurin carga mä, ¿ima milagrucunatapis mas shumagcunatarä ruraramunquiman? ");
INSERT INTO qxoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay tiempu tsunyagcunata aywarmi Moises waran waran milagruta rurar ‘manah’ ningan micuyta runacunata micutsirgan. Tsaynömi Diospa palabran gellgaranganchö willamantsic. Paynölla gampis mä ruraramunquiman ari”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Niyaptinnam Jesus nirgan: “Shumag tantiyayämay. Manam Moisestsu tsay micuyta garargan unay runacunata, sinöga papänï Tayta Diosmi. Payllam garayäshunqui ciëlupita cachämungan micuytapis cay patsachö runacunata imayyagpis cawatsinanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tsaynam runacuna tsay micuytana mañar niyargan: “Taytay, cananpitaga tsay micuyta ari garaycayällämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tsaynö niyaptinnam Jesus nirgan: “Imayyagpis cawatsicog micuyga nogam cä. Nogaman criyicamogcunaga pachajuntagpä micushganömi y yacuta jimagpä upushganömi imaypis cushishga cawayanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Puntata ningänöpis noga milagru rurangäcunata ricaycarpis manam criyicayämunquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“Papänï Tayta Dios acrangan cagcunaga nogaman criyicayämungam. Tsaynö criyimogcunataga llapancunatam chasquishä. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nogaga cachamagnï Tayta Diospa mandunta ruranäpämi ciëlupita cay patsaman shamurgö. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","40","Payga manam munantsu acrangan cagcuna ni jucllayllapis infiernuman aywananta. Payga munan ciëluchö imayyagpis cawayänantam. Tsaymi fisyu final junagpis noga tsurinman criyicamog cagcunataga cawatsimushä Tayta Dioswan imayyagpis cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Ciëlupita shamog tantaga nogam cä” ninganpitam Capernaum marca autoridäcuna ajanasquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tsaynö ajanarnam quiquincuna pura parlayargan caynö nir: “Cay runaga Josepa tsurin Jesuschä. Musyantsicmi papänin maman pï cangantapis. ¿Imanirtä ‘Ciëlupitam shamurgö’ nimantsic?” ");
INSERT INTO qxoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tsaynö niyaptinnam Jesus nirgan: “Ajanapäyämänayquipa rantin shumag tantiyacuyay. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cachamagnï Tayta Dios mana tantiyatsiptinga manam ni pipis nogata chasquimanmantsu. Chasquimag cagcunataga cay patsa ushacangan junag cawatsimushä gloriachö imayyagpis cawayänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tayta Diospa willacognin profëtacuna gellgayanganchömi nican: ‘Llapan runacunatapis Tayta Dios tantiyatsingam’. Tsay ningannömi Tayta Diosta cäsucog cagcunaga nogatapis chasquiycäyäman”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ciëlupita shamushga car nogallam Tayta Diosta regï. Manam pipis mas paytaga regintsu. Tsaymi Tayta Diospita yachacuyta munag cagcunaga noga ningäcunata chasquiyämänan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nogaman criyicamog cagcunallam Tayta Diospa ñöpanchö imayyagpis cawayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Nogaga imayyagpis cawatsicog micuymi cä. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Rasunpaypam unay runacuna tsunyagta aywar Tayta Dios ciëlupita cachämungan micuycunata micuyargan. Tsaycunata micuycarpis paycunaga wanuyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Peru cananga ciëlupita Tayta Dios cachamunganpämi noga willacuycä. Tsay cag micuymi sï cawatsiyäshunqui imayyagpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nogam tsay ciëlupita shamog cawatsicog micuyga cä. Runacuna mana ushacag cawayta tariyänanpämi wanuratsiyämaptinpis cawarimushä. Tsaymi noga cawag micuyta micog cagtaga wanuptinpis cawatsimushä imayyagpis ciëluchö cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesus tsaynö niptinnam tsay runacuna mana tantiyacur jucnin jucnin ninacuyargan: “¿Imanöpatä cay runa quiquinpa cuerpuntaga micatsimäshun?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tsaynam Jesus yapay nirgan: “Mä shumag tantiyayämay. Tayta Dios ciëlupita cachamungan captïmi gamcuna ciëluman aywayänayquipä nogaman criyicamur cawayänayqui. Criyicamur cawarmi cuerpüta micuyanqui y yawarnïta upuyanqui. Mana tsayga manam ciëluman aywayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tsaynö nogapa cuerpüta micur yawarnïta upur cagcunatam fisyu finalchö cawatsiyämushayqui ciëluchö imayyagpis cawacuyänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nogaga cä rasunpa cag cawatsicog micuymi. Y yawarnëga rasunpa cag cawatsicog yacum. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gamcuna nogaman criyicayämur nogatam micuycäyämanqui y yawarnïtapis upuycäyanqui. Tsaynö criyicayämangayquipitam juc shongunölla nogawan cawayanqui. Nogapis gamcunawan juc shongunöllam cawaycä imaypis yanaparniquicuna”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Cachamagnï Tayta Dios cawatsicog carmi nogata cawatsiman. Tsaynöllam nogapis criyicamog cagta imayyagpis cawatsishä. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nogaga musyaycätsï ciëlupita shamog cag micuy cangätam. Unay runacunata Tayta Dios micuynincuna garanganpitapis mas allin cag micuymi nogaga cä. Paycunaga ciëlupita micuyta micuycarpis wanuyarganmi. Nogaman criyicamur micumag cagmi itsanga gloriachö imayyagpis cushishgalla cawayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tsaynömi Jesus yachatsirgan Capernaum marcachö Tayta Diosman mañacur goricäcuyänan wayichö. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesus tsaynö yachatsicungancunata wiyarirnam tsay atscag gatiragnincuna ajanar ninacuyargan: “Cay yachatsicunganga alläpa aja tantiyaychä. ¿Pirä tsayta entiendinman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tsaynö ajanäyanganta tantiyarnam Jesus nirgan: “Noga ningäcunata tantiyayänanpäga rasunpapis ajallaran. Tsaynö captinmi waquinniquicunaga ningäcunata chasquicuyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Peru ¿imaniyanquirä noga Tayta Diospa cachan juc junag ciëluman cutiycagtana ricascayämarnï? Tsaypitam itsanga yarpachacur niyanqui: ‘Jesus yachatsimangantsiccunata chasquicushwan cargan’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nogata jagirayämar quiquillayquicunaga manam ciëluman chäyanquitsu. Yachatsingäcunata chasquicuyaptiquim itsanga Espiritu Santo imaypis yanapayäshunqui alli cawaychö cayänayquipä y ciëluman chäyänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Espiritu Santo tsaynö yanapayäshunayqui caycaptinpis waquinniquicunaga yachatsingäcunata manam chasquicuyanquitsu. Tsaynö mana chasquiyämänayquipä cagta musyarnam noga nirgä: ‘Tayta Dios mana tantiyatsiptinga manam ni pipis nogata chasquimanmantsu’ nir”. Jesusga imaypitapis musyargannam mana chasquiyänanpä cagta y maygan runa ticrapunanpä cagtapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesus tsaynö yachatsicuptinmi atscag gatiragnincuna jagisquir aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Runacuna tsaynö aywacuyaptinnam tsay chunca ishcay (12) discïpuluncunata Jesus nirgan: “¿Gamcunapis paycunanö aywacuytacu munayanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Niptinnam Simon Pedro nirgan: “Taytay, ¿pimanrä mä aywayäman? Gamllachä parlanqui mana ushacag gloria vïdapä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogacunaga criyiyämi Tayta Dios cachamungan salvacog cangayquita” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tsaynam Jesus nirgan: “Nogam gamcunata acrargö chunca ishcay (12) discïpulücuna cayänayquipä. Tsaynö acracuynï caycarpis jucniquim Satanaspa munayninchö caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesusga tsaynö parlargan Simon Iscariotipa tsurin Judaspämi. Discïpulun caycarpis Judas Jesustaga ranticunannam cargan chiquipagnin runacuna wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tsaypitaga Galilea provinciachö marcan marcannam Jesus yachatsicur purirgan. Israel runacunapa autoridänincuna wanutsiyta munayaptinmi Judea provinciamanga aywargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Peru Israel runacunapa “Tashma” ningan fiestancuna gallananpä juc ishcay junagllana faltaycaptinnam Jesusta waugincuna niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","“Cayllachöga ama cacuytsu. Mä, Judea provinciamanpis ayway gatiräshogniquicuna tsaychöpis milagru rurangayquita ricäyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pipis alli regishga cayta munarga manam pacayllapaga imatapis rurantsu. Imayca milagrucunata puntacunatapis ruraycarga llapan runacuna musyayänanpä Jerusalen marcachöpis ruramuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tsaynö waugincunapis Jesusta niyargan Tayta Dios cachamungan salvacog canganta mana criyirmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsaynam waugincunata Jesus nirgan: “Manaran tsayman aywanäpä örärätsu. Peru gamcuna aywayänayquipäga imaycay örapis allillam. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gamcunataga tsay lluta cawacogcuna manam chiquiyäshunquitsu. Nogatam itsanga chiquiyäman jutsa rurag cayanganta nillaptï. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tsay fiestaman gamcunalla aywayay. Noga aywanäpäga manaran örä chämunrätsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tsaynö nirninmi Galileachö Jesus quëdacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Waugincuna Tashma fiestaman jegariyaptinrämi Jesuspis aywargan pitapis mana willayllapa. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jerusalen fiestachö Jesusta mana ricarmi autoridäcuna tapupacuyargan: “¿Maychörä tsay runa caycan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Atscag goricashga runacunanam quiquincuna pura Jesuspä parlayargan. Juccunam niyargan: “Payga alli runam” nir. Waquincunanam niyargan: “Manam allinötsu. Runacunata criyitsirmi llullapan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Paycuna autoridäcunata mantsarninmi tsaynö shapshapyayllapa parlapänacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tsay pullan fiestancunachönam templuman Jesus yaycusquir runacunata yachatsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yachatsicunganta wiyarninnam autoridäcuna caynö niyargan: “Nogantsicwanpis mana liyishga caycar ¿imanöparä cayläya yachaycun?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tsayta wiyarirnam Jesus nirgan: “Nogaga yachä cachamagnï Tayta Dios yachatsimashga captinmi. Manam quiquilläpitatsu tsaynö yachatsicü. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yachatsingäcuna Diospita canganta musyayta munarga Dios munangannö cawayay. Tsaynöparämi tantiyayanqui quiquïpa yarpaylläpita mana yachatsingäta. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Waquin runacunaga alli ricashga cayta munar quiquinpa yarpayllanpitam yachatsicur puriyan. Nogaga manam tsaynötsu yachatsicü, sinöga Tayta Dios munangannöllam, chasquiyämaptinpis o mana chasquiyämaptinpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gamcunaga unay Moises gellgangancunata tsararaycäyanquim Tayta Dios munangannö cawayänayquipä. Tsaynö captinpis manam maygayquicunapis pay ningannö cawaycäyanquitsu. Manam tsayllapistsu. Tayta Dios munangannö cawaptïpis nogataga chiquimarnï wanutsiyämaytanam munaycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jesus tsaynö niptinnam tsay runacuna caynö niyargan: “¿Pitä wanutsishuyta munan? Demöñuyogmi gamga canqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusnam nirgan: “Jamapay säbadu junagchö unayna geshyacog runata allïcatsingäpitam gamcunaga wanutsiyämayta munayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mä tantiyayämay. Unay Moisesmi yachatsicurgan ollgu wamrapa cuerpunta señalacuypä. (Moises yachatsiptinpis tsay üsoga cargan mas unaypitam.) Tsay Moises gellgangancunata cumplir säbadu jamapay junagman camacaptinpis señalayanquim. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wamrayquicunata säbadu jamapay junagchöpis señalaycarga ¿imanirtä ajäcurcuyanqui säbadu junagchö geshyacog runata noga allïtsingäpita? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Manarä allipa musyaycur ama niyämaytsu llutan rurag cangäta. Imata parlayänayquipä cagtapis shumagrä yarpachacuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tsaynam Jerusalenchö tärag waquin runacuna ninacuyargan: “¿Manacu cay runaga wanutsiyänanpä ashiycäyangan runa? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Llapan runacuna wiyananpä parlaptinpis imatapis niyantäcu. ¿Autoridäcunapis Tayta Dios cachamungan salvacog cangantatsurä yarpaycäyan? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Peru nogantsicga Jesus may marcapita cangantapis musyantsicmi. Salvacog rasunpa shamuptinga manam pipis musyangatsu maypita shamungantapis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Tsayta wiyaycurnam templuchö yachatsicuycarnin Jesus caynö nirgan: “May marcapita cangäta musyaycarpis gamcunaga manam rasunpaypatsu tantiyayanqui maypita cangätapis. Nogaga Tayta Diospitam shamurgö. Manam quiquïpa munaynïpitatsu cay patsaman shamurgö, sinöga cachamagnï Tayta Diospa munayninllapitam. Paypita shamushga car noga musyämi Tayta Dios imanö cangantapis. Gamcunaga manam musyayanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesus tsaynö niptinnam autoridäcuna ajanaparna prësu tsariyta munayargan wanutsiyänanpä. Peru wanunanpä öran manarä captinmi tsariyarganrätsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tsaynö captinpis atscag runacuna Jesusman yäracurninnam niyargan: “Rasunpa Tayta Dios cachamungan salvacog shamurga ¿cay runapita masnatsurä milagrucunata ruraycunga? Atsca milagrucunata ruraptinmi criyiyä salvacog Cristo canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Runacuna tsaynö parlayanganta wiyasquirnam sacerdöticunapa mandagnincunawan fariseucuna cachayargan templu täpag wardiyacunata Jesusta prësu tsariyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tsay prësu tsaregcuna chäyänanpäga Jesus caynömi yachatsicuycargan: “Juc ishcay quillallanam faltan cachamagnï Tayta Diosman cuticunäpä. Tsayyagllanam gamcunawan caycäshä. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ashiyämarpis mananam tariyämanquitsu. Noga aywangämanga manam gamcuna aywayta puëdiyanquitsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tsaynö niptinnam runacuna jucnin jucninrä ninacuyargan: “¿Mayparä pay aywanga nogantsic mana tarinantsicpäga? ¿Juclä nacionchö täcog marca mayintsiccunamantsurä aywanga yachatsicunanpä? o ¿Diosman mana criyegcunamantsurä? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ima ninantä ‘Ashiyämarpis manam tariyämanquitsu’ ninganga? ¿Imanirtä pay aywanganman chayta mana puëdinantsicpä nicämantsic?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tashma fiesta ushanan diya junagchömi llapancuna upällalla altarman ricacushga jamaraycäyargan. Tsaynam Jesus ichircur llapancuna wiyayänanpä nirgan: “Pipis yacunaypanörä Tayta Dioswan cawayta munag cagga nogaman yäracamutsun. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pucyu pashtagpita tsuya yacu mana ushacaypa yargamungannömi nogaman yäracamog cagcunapa shongunchö Espiritu Santo imaypis caycanga. Tsaynö cananpä cagtaga Diospa palabran gellganganchöpis willacuycanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tsaynö nirninmi Jesus yachatsicurgan runacuna Espiritu Santuta chasquicuyänanpä. Tsaynö captinpis wanunganpita Jesus cawamuptinrämi payman criyicog cagcuna Espiritu Santuta chasquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus ninganta wiyasquirnam tsaychö caycag waquin runacuna niyargan: “Moises gellgangannö shamunanpä cag willacog profëtachä payga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquincunanam niyargan: “Manam payga profëtallatsu, sinöga quiquinmi Tayta Dios cachamungan salvacog Cristo” Peru waquincunaga niyargan: “Mä, Galilea runa caycarga ¿imanöpatä payga salvacog canman? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diospa palabran gellgaranganchömi nican: ‘Unay rey David castapitam salvacogga canga’ nir. Tsaymi salvacogga yuringa Belen marcachö Davidpa marcan captin”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tsaynö nir waquincuna allita yarpäyaptinpis waquincunaga Jesuspä mana allitam yarpäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Waquin cagcunaga prësurnam apayta munayargan. Tsaynö yarparpis manam ni mayganpis tsariyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsaypitaran Jesusman prësog cachacuyangan wardiyacuna cuticuyargan sacerdöticunapa mandagnincuna y fariseucuna cayanganman. Chäriyaptinnam tapuyargan: “¿Imanirtä tsay Jesusta prësu apayämurguyquitsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Paycunanam niyargan: “¡Payga alläpa shumagmi parlaycun! Manam pï runapis pay parlanganmanga iwalantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tsaynö niyaptinnam fariseucuna niyargan: “¿Hasta gamcunatapis criyiratsiyäshurguyquinacu? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Acäsu maygan autoridäcunapis ni nogacunapis payman criyiyäcu? ");
INSERT INTO qxoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Maldiciäduyashga mana imapäpis väleg runacunallam leynintsiccunata mana mayarnin paymanga criyiyan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Tsaynö niyaptinnam Nicodemo fariseo mayincunata nirgan: “Leynintsiccuna mandamangantsicnöpis cay runa ima cangantapis mana musyaycurga manam castiganantsicllanatsu. Ima cangantapis musyasquirmi itsanga castigashunpis”. (Nicodemoga puntatam Jesusman aywargan parlacurinanpä.) ");
INSERT INTO qxoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tsaynam paycuna Nicodemuta niyargan: “Gampis Galilea provinciapitachi canqui paypa favornin sharcunayquipä. Masqui Diospa palabran gellgaranganta cösa liyir tantiyacuy. Mayninchöpis manam nimantsictsu Galileapita ni juc profëta shamunanpä cagta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tsaynö nisquirnam juc jucllaylla wayincunapa aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tsaypitanam Jesusga Olivos jircanpana aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nircur warayninnam cutirgan templuman. Pay caycanganman atsca runacuna goricasquiyaptinnam Jesusga yapayna yachatsicur gallaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tsaymannam chätsiyargan juc warmita fariseucuna ley yachatsicogcuna. Tsay warmitash tarishga cayänä gowanta engañar juc runawan punuycagta. Tsaynam tsay runacunapa chöpinman ichiycatsir Jesusta niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Mayistru, cay warmitam tariyargö gowanta engañar juc runawan punuycagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Unay Moises gellgangan leynintsicchömi nimantsic caynö warmicunataga rumiwan samgayllapa wanutsinapä. Y gamga ¿tsayta imaninquitä?” ");
INSERT INTO qxoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tsaynöga tapuyargan Jesusta achäquita ashiparnin imatapis autoridäcunapa contran parlaycuptinga tsayllapitana prësu apayänanpä. Tsaynö tapuyaptin Jesusga umpuycurmi patsachö dëdunwan gellgar caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tsay runacuna yaparir yaparir tapuyaptinnam ichircur nirgan: “Maygayquipis jutsata mana rurag cag, mä cay warmita puntata samgayay ari”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsaynö nisquirnam yapay umpuycur patsachö jinalla gellgaycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesus ninganta tantiyacusquirnam runacuna mas rucu cagcunapita gallaycur juc jucllaylla jegascäriyargan. Llapancuna aywacusquiyaptinnam warmillawanna Jesus quëdasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tsaynam Jesus ichircur warmita cuyapar nirgan: “Jau warmi, ¿tsay apayämushogniquicuna maytä? ¿Manacu ni jucllayllapis samgayäshurguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Niptinnam warmi nirgan: “Manam ni jucpis samgayämashgatsu, taytay”. Niptin Jesusnam nirgan: “Nogapis manam munätsu samgacashga canayquita. Cananga wayiquipana aywacuy. Peru cananpitaga amana gowayquita engañar jutsa rurayman cutinquinatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tsaypitanam atsca runacuna goricäyaptin Jesus yapay yachatsicur nirgan: “Cay patsachö runacunapäga actsinömi cä. Tsaymi nogaman criyicamogcunaga tsacaychönöga mana cawayanganatsu. Tayta Dioswanmi imaypis cushishga cawayanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tsaynam fariseucuna parlacachar niyargan: “Tsaycunata quiquillayqui nicaptiquega ¿imanöpatä nogacuna criyiyäman?” ");
INSERT INTO qxoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tsaynö niyaptinmi Jesus nirgan: “Testïgu captinpis o mana captinpis noga ningäcunaga rasun cagmi. Ciëlupita shamungäta y tsayman cuticunäpä cagta musyämi. Gamcunam itsanga mana musyayanquitsu maypita shamungäta ni mayman cuticunäpä cagtapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tsaymi quiquiquicunapa yarpaynillayquicunapita nogapä llutanta yarpaycäyanqui. Nogaga manam gamcunanötsu pipäpis llutanta yarpä. Tsaynöpis nogata juzgayämangayquinöga pitapis manacagtaga manam juzgätsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Cachamagnï Tayta Dios nogawan imaypis captinmi pitapis juzgarga rasun cagllata juzgä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Yarpäyay masqui Moises gellganganta. Tsay gellganganchöpis caynömi nican: ‘Ishcag testïgucuna juc parlayangallanta niyaptinran criyiyanman rasun cag canganta’. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tsay ningannöllam ishcay testïgucuna nogapä nican. Cachamagnï papänïmi juc testïgu. Jucag testïgunam quiquï. Tsaynö papänïpis nogapis tsaynölla nicäyaptëga gamcuna criyiyämanquimanmi ningäcuna rasun cag canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tsaynö niptinnam fariseucuna tapuyargan: “Ningayquinö canganta tapuyänäpä ¿maychötä papäniqui caycan?” nir. Jesusnam nirgan: “Gamcunaga manam musyayanquitsu papänï pï cangantapis ni noga pï cangätapis. Noga ningäcunata criyiyämanquimanmi papänï pï cangantapis musyayänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tsaynömi templuchö Jesus parlargan limushna cäjacuna churaräcunan lädunchö. Tsaynö runacunapa ñöpanchö parlaptinpis manam ni mayganpis prësuyargantsu wanunanpä öran manarä chaptin. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tsaypitanam Jesus nirgan: “Noga yachatsingäcunata mana chasquicogcunaga aywangäman imaypis manam chäyanquitsu. Aywacuptï ashimarpis manam tariyämanquinatsu. Nogata mana chasquicamagcuna jutsallachönam quëdayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tsaynö niptinmi runacuna ninacuyargan: “¿Imanirtä aywacunanpä cagta nicämantsic? ¿Payga wanutsicuytatsurä yarpaycan o imatarä? Tsaychir pay canganman mana chänantsicpä cagtaga nicämantsic” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","24","Tsaynam Jesus nirgan: “Nogaga ciëlupitam shamurgö. Gamcunaga cay patsallapitam cayanqui. Tsaymi pï cangäta willapaptïpis criyiyämanquitsu. Tsaynö mana criyiyämangayquipitam jutsallachö car gamcuna imaypis ciëluman chäyanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsaynö niptinnam niyargan: “Tsayöraga ¿pitä gam canqui? Willayämay ari” nir. Jesusnam nirgan: “Pi cangätapis parlapar gallangäpitam gamcunata willaycä. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gamcuna jutsayog cayangayquicunata ninäpä atscarämi caycan. Imanö cayangayquitapis nicä manam quiquilläpa yarpaylläpitatsu, sinöga cachamagnï papänï nimangancunallatam nicä. Pay nimangancunaga llapanpis rasun cagllam”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesus tsaynö parlapaycaptinpis paycunaga manam tantiyayargantsu Tayta Dios cachamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tsaynö mana tantiyayaptinmi Jesus nirgan: “Noga ciëlupita shamogta wanutsiyämangan öram gamcuna tantiyayanqui pï cangäta y cachamagnï Tayta Dios nimangannölla parlangäta. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Papänï imaypis nogawanmi caycan. Pay munangannölla ruraptïmi imaypis jagimantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesus tsaynö niptinnam atscag runacuna criyiyargan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tsaynö janan shongulla criyiyanganta musyarnam Jesus nirgan: “Gamcuna yachatsicungänölla cawarga rasunpaypa discïpulücunam cayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tsaynö cawarmi tantiyayanqui yachatsingäcuna rasun caglla canganta. Tsaynöpaga mananam Satanaspa munayninchönatsu cawayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tsaynö niptinmi niyargan: “Unay Abraham casta caycäyaptëga ¿imanirtä tsaynö niyämanqui? Nogacunaga manam imaypis Satanaspa munayninchötsu cawayargö, sinöga Tayta Diospa munayllanchömi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Niyaptin Jesusnam nirgan: “Shumag tantiyayämay. Jutsallachö cawarga manam Diospa munayninchötsu cawaycäyanqui. Jutsasapa cagcunaga llapanpis Satanaspa munayninchömi cawayan. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tsaynö cawagcunaga manam Diospa wamrantsu cayan. Nogaga Tayta Diospa tsurin carmi imaypis paypa munayllanchö caycä. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tsaymi jutsayquicunapita gamcunata salvaptï carcelchö wichgaraycangayquipita yargusqueg cuenta ticrariyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Musyämi Abraham casta cayangayquita. Tsaynö caycarga ¿imanirtä ningäcunata chasquicuyanquitsu? Y nircur ¿imanirtä wanutsiyämayta munayanqui? ");
INSERT INTO qxoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nogaga papänï Tayta Diospa ñöpanchö musyangäcunatam gamcunata parlapä. Tsaynö captinpis Satanas munangannö cawarmi gamcunaga mana cäsuyämanquitsu. Satanasmi gamcunapaga taytayquicuna”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jesus tsaynö niptinnam paycuna niyargan: “Llutancunatam tsaytaga parlaycanqui. Abraham casta cayaptï nogacunapaga paymi taytäcuna” nir. Tsaynam Jesus nirgan: “Abraham casta carpis manam gamcuna cawayanquitsu pay alli cawangannöga. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Abrahamga imaypis manam yarpargantsu Diospa willacogninta wanutsiyta. Gamcunaga wanutsiyämaytam munaycäyanqui Tayta Dios musyatsimangancunata willacullaptï. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tsaynö mana alli cayaptiquim gamcunapa taytayquicunaga Satanas. Tsaymi paypa mandunllata imaypis ruraycäyanqui”. Tsaynö niptinmi paycuna ajaypa niyargan: “¡Manam Satanaspa tsurintsu cayä! ¡Nogacunapa taytäcunaga Tayta Diosmi!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tsaynö niyaptinnam Jesus nirgan: “Tayta Dios rasunpaypa papäniquicuna captinga nogatam chasquiyämanquiman. Manam quiquïpa munaylläpitatsu nogaga cay patsaman shamurgö, sinöga paymi ciëlupita cachamashga. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imanirtä tsayläya allillata parlapaycaptïpis gamcuna tantiyaycayämanquitsu? Chasquiyämayta mana munarmi mana tantiyayämanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Gamcunapa taytayquicunaga Satanasmi, tsay llapan supaycunapa mandagnin. Paypa carmi munangallanta imatapis ruraycäyanqui. Imay tiempupitapis Satanasga runa ushagmi cashga. Y tsaynömi gamcuna nogatapis wanutsiyämayta munaycäyanqui. Satanasga selläma llullacurmi imaypis criyitsicun. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nogaga mana llullacuypam gamcunata parlapaycä. Tsaynö parlapaptïpis manam ni ichicllapis criyiyämanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“¡Mä, maygayquicunapis shimpiyämay si nogapa ima jutsällapis captinga! Rasun cagta parlaycaptëga ¿imanirtä chasquiyämanquitsu? ");
INSERT INTO qxoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diospa wamranna cagcunaga willacuyninta cäsucuyanmi. Gamcunam itsanga Diospa wamrancuna mana car payta ni nogata mana cäsur ni imapä cuentayämanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tsaynö Jesus niptinnam runacuna ajar niyargan: “¡Gamga maldiciäduyashga Samaria runam canqui! ¡Gamtaga Satanasmi löcuyaycätsishunqui!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusnam nirgan: “Manam supayyogtsu cä, sinöga papänïpa munaynintam ruraycä. Tsaynö captinpis gamcunaga manacagcunatam niycäyämanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Chasquiyämaptiquipis o mana chasquiyämaptiquipis nogaga papänï munangannöllam willacuycä. Pitapis mana chasquimag cagtaga papänïmi juzganga. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yachatsicungäcunata cäsucur chasquimag cagmi itsanga imaypis wanungatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Niptin paycunanam niyargan: “Cananmi sï rasunpa musyasquiyä gamchö Satanas caycanganta. Abrahampis y Tayta Diospa willacognin profëtacunapis llapanmi wanuyargan. ¿Imanöpatä gamga ninqui: ‘Yachatsicungäcunata cäsucog cagga manam wanungatsu’ nir? ");
INSERT INTO qxoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gamga manam Abrahampita mas munayyogtsu canqui. Paypis wanushgam. Llapancunapis Tayta Diospa willacognincuna wanuyashgam. Y gamga ¿imanatä canqui manana wanunayquipäga?” ");
INSERT INTO qxoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tsaynö niyaptin Jesusnam nirgan: “Tsaycunata niptï ama yarpäyaytsu alabacuycangäta. Papänï Tayta Diosga llapan runacuna nogata chasquiyämänantam munan paywan imayyagpis cawayänanpä. Gamcunaga llutallam Tayta Diospa jutintapis jayariyanqui ‘Tayta Diosllantsicmi’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tsaynö parlarpis papänï imanö canganta ni imata ruranganta manam musyayanquitsu. Nogam itsanga llapanta musyä imanö cangantapis. Paypita shamushga carmi nimangancunallata parlaycä. Gamcunanö yachatsicurga manam rasun cagtaga parlämantsu, sinöga llullacogmi cäman. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","‘Abraham castam nogacunaga cayä’ niyämaptiquipis Abrahamga manam gamcunanötsu cargan. Payga Tayta Diosman yäracurmi cushishga cawargan cay patsaman noga shamunäpä cagta musyar”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tsaynö niptinnam tsay runacuna Jesusta niyargan: “¡Gamga manam Abraham yarpangancunataga musyanquitsu! Manarä ni pitsga chunca (50) watayog caycar ¿imanöpatä Abrahamta reginquiman cargan?” ");
INSERT INTO qxoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Niyaptin Jesusnam nirgan: “Tantiyayämay. Abraham manarä yuriptinmi nogaga caycargäna”. ");
INSERT INTO qxoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesus tsaynö niycuptinmi itsanga Dios tucuycanganta yarpasquir runacuna rumitana aptapacuyargan samgaypa wanutsiyänanpä. Tsaynö samgayta munayaptinnam runacunapa chöpincunapa aywar templupita Jesus aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jerusalen marcachö discïpuluncunawan puriycarnam ricasquiyargan yuringanpita gapra runata. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tsaynam Jesusta discïpuluncuna tapuyargan: “Taytay, ¿imanirtä cay runa gapra yuricushga? ¿Papäninpa y mamanpa jutsancunapitacu o quiquinpa jutsanpitacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tsaynam Jesus nirgan: “Tsaytaga manam allitatsu tapuyämanqui. Manam quiquinpa ni papäninpa ni mamanpa jutsanpitatsu gapra yurishga, sinöga tsaynö yurishga noga allïtsiptï Tayta Dios poderyog canganta runacuna musyayänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsaymi cay patsachö cangäyag cachamagnï Tayta Dios munanganta ruraycä. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tsaynö munanganta rurarmi runacunapä actsinö caycä, Tayta Dios imanö canganta musyatsicur”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tsaynö nisquirnam Jesus togayninwan mituta rurasquir gaprapa ñawinman llushiparcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nircurnam nirgan: “Canan Siloe pözuman ayway ñawiquita awiscamunayquipä” nir. (Hebreu parlaychöga tsay Siloe ninanga “cachamushga” ninanmi.) Tsay gapranam aywar awicascamur wayinman cuticurgan ricachacuycarna. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tsaymi marca mayincuna y payta regegnincuna sänuna caycagta ricarnin caynö parlayargan: “¿Limushnata mañacur täcog gapra runacu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquincunanam niyargan: “Au, paymi”. Juccunanam niyargan: “Manam paytsu. Itsanga pay ricogllam”. Tsaynö niyaptin tsay quiquin alliyashga runanam nirgan: “Aumi, nogam callä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsaynam tapuyargan: “¿Imanöpatä cananga ricanquina?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Paynam nirgan: “Jesus jutiyog runam mituta rurasquir ñawïman llushiparcamargan. Nircurnam cachamargan Siloe pözuman aywar ñawïta awicamunäpä. Ningannö awicusquiptïnam ñawillä ricachacurirgan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsaynö niptinnam runacuna yapay tapuyargan: “¿Maychötä caycan tsay allïtsishogniqui runaga?” nir. Tsaynö tapuyaptinnam nirgan: “Manam musyätsu maychö caycangantapis” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tsaypitanam fariseo runacunaman tsay alliyashga gaprata apayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Jamapay säbadu junagchö alliyanganpitam fariseucuna payta tapupäyargan: “¿Imanöpatä alliyarguyqui?” nir. Tsaynam runa nirgan: “Juc runam ñawïman mituta llushiycamurgan. Tsaypita awicusquiptïnam ñawillä ricachacusquirgan, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Niptinnam waquin fariseucuna niyargan: “Tsay allïtsicog runaga manam Tayta Dios cachamungantsu canman. Tayta Diospita carninga jamapäcuy säbadu junagchöga manam pitapis allïtsinmantsu” nir. Niyaptin waquincunanam niyargan: “Tayta Dios cachamungan runa mana carninga ¿imanöpam tsaynö espantacuypä milagrucunata ruranman?” nir. Tsaynö ninacurmi tsay fariseucuna quiquincuna purapis juc yarpayllaga cayargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tsaypita yapaypis tsay alliyashga runata tapupäyarganmi: “Gamga ¿imaninquitä ñawiquita allïtsishogniquipä?” Niyaptin paynam nirgan: “Nogaga yarpä tsay runa Tayta Diospa willacognin profëta cangantam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tsaynö niptin manam criyiyargantsu gaprapita alliyashga canganta. Tsaynam runapa papäninta mamanta gayatsiyämurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chäriyaptinnam paycunata tapuyargan: “¿Cay runa wamrayquicunacu? ¿Rasunpacu gapra yuricurgan? Y cananga ¿imanöpatä alliyashga?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tsaynam papänincuna niyargan: “Aumi, nogacunapa wamräcunam. Yuringanpitam gapra cashga. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Peru cananga ¿imanöparä ricallanna ari? Nogacunapis manam musyayätsu pirä allïtsicushgapis. Payga yarpayyog runanam. Quiquinta tapuyällay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Autoridäcunata mantsacurmi tsaynöga papänincuna niyargan. Puntatam autoridäcuna willanacushgana cayargan mayganpis “Jesusga Tayta Dios cachamungan salvacogmi” neg cagcunata Tayta Diosman mañacur goricäcuyänan wayipita garguyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tsayta mantsacurmi tsay alliyashga runapa papänincuna niyargan: “Payga yarpayyog runanam. Quiquinta tapuyay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tsaynam tsay alliyashga runata autoridäcuna yapay gayatsir niyargan: “Poderösu Dios ricaraycäshunquim. Rasun cagta willacuy. Manam rasunpaypatsu tsay runa allïtsishurguyqui. Nogacuna musyayämi tsay runata Tayta Dios mana cachamunganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Niyaptin tsay alliyashga runanam nirgan: “Nogaga manam musyallätsu Tayta Dios cachamunganta o mana cachamungantapis. Peru imallatam musyäga gapra cangäpita alliycatsimangallantam”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tsaynö niptinnam yapay tapuyargan: “¿Imatatä Jesus rurashurguyqui ñawiqui ricananpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Paynam caynö nirgan: “¡Peru willargönachä! Willaptïpis gamcunaga manachä criyiyämanquitsu. ¿Imanirtä yaparir yaparir tapupäyämanqui? ¿Gamcunapis paypa gatiragnin caytacu munayanqui?” ");
INSERT INTO qxoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsaynö niptinnam autoridäcuna niyargan: “Gamchi paypa yachatsicuynintaga cäsucuycanqui. Nogacunaga unay Moises yachatsicungancunatam cäsucuyä. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Diospa palabran gellgaranganta liyir musyayämi Moisesta Tayta Dios parlapanganta. Tsay allïtsishogniqui runa jutsasapa captin manam paytaga Tayta Dios imatapis parlapashgatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tsaynam runa nirgan: “¿Imanötä tsayga? Espantacullämi gamcuna jutsasapa canganta yarpäyaptiqui. Nogallätaga paymi ñawïta allïcatsimashga. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Milagrucunata rurananpäga Tayta Dios imaypis manam jutsasapacunataga yanapantsu. Payta adorar munangancunata ruragcunallatam yanapan. Tsaytaga musyayanquim. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manam imaypis musyarguntsictsu yuricuyninpita gapra runata pipis allïtsinganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Payta Tayta Dios mana cachamushga captinga manam caycunata rurayta puëdinmantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tsaypita tsay alliyashga runa ninganta wiyaycurnam autoridäcuna ajacurcur niyargan: “¡Gamga jutsasapam canqui! Tsaynö caycarga ¿imanöparä nogacunataga yachatsiyämag tucunquiman?” nirnin. Tsaynö nirnam goricäcuyänan wayipita tsay runata gargusquiyargan Tayta Diosta tsaychö imaypis manana adorananpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tsay allïtsingan runata garguyanganta Jesus musyarirnam paywan tincusquir tapurgan: “¿Tayta Dios cachamungan salvacogman yäracunquicu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Niptin tsay runanam nirgan: “Musyämi salvacog shamunanpä cagtaga, taytay. Shamushgana captinga pï cangantapis willaycamay noga payman yäracunäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Niptin Jesusnam nirgan: “Paywanga tincurguyquinam. Y nogam cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tsaynam Jesuspa ñöpanman gonguricuycur nirgan: “Taytay, gamman yäracullämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tsaypitanam llapancunatana Jesus nirgan: “Runacuna jutsallachö captinmi nogaga cay patsaman shamurgö paycunata salvanäpä. Waquincuna ‘Jutsäcunapita perdonaycallämay’ nirmi chasquiyämanga salvacuyänanpä. Tsay chasquimag cagcunaga gapra runa ricangannönam ticrariyanga. Mana chasquimagcunam itsanga quiquincunalla alli cayanganta yarpar infiernuman aywayanga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesus ninganta wiyasquirnam tsaychö caycag fariseucuna niyargan: “Tsayöraga nogacunam sï salvashgana car infiernumanga aywayäshätsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tsaynö niyaptin Jesusnam nirgan: “Gamcuna rasunpaypa salvashga cayta munar nogata chasquiyämaptiquim Tayta Dios perdonayäshunqui. ‘Salvashganam cä’ nicarpis nogata mana chasquiyämaptiquega Tayta Dios manam perdonayäshunquitsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tsaypitanam Jesus yachatsicur nirgan: “Üshacunapa cunchanman mitsicogninnö puncunpa mana yaycog cagga ladronmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Cunchan puncunpa yaycog cagmi itsanga mitsicognin. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mitsicognin yaycunanpämi puncuta täpag quichaparin. Tsaymi mitsicognin jutinpa jutinpa gayaptin üshancunapis shiminta mayarir cunchanpita yargacayämun. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Llapan üshancuna yargascayämuptinnam payga üshancunapa puntallantana aywacun mitsicog. Mitsicognin canganta regirninmi washqui üshacunanöpis gepallantana aywayan. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mana regirninga runacunata manam gatipäyantsu. Mitsicognin mana captin mantsaparninmi geshpir aywacuyan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tsaynö nir iwalatsicuypa Jesus yachatsicuptinmi tsaychö cag runacuna mana tantiyayargantsu imapä parlaycangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yapaypis yachatsicurnin Jesus caynömi nirgan: “Nogaga cä üshacunapa cunchanman yaycuna puncunömi. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","9","Tsaymi puncupa üshacuna cunchaman yaycungannö nogaman yäracamur runacuna ciëluman yaycuyanga. Üshancunata mitsicognin alli gewachö mitsingannömi nogaman yäracamogcunatapis alli cawayta garashä. Manarä noga cay patsaman shamuptï waquin runacuna puriyargan: ‘Nogatam Tayta Dios cachamashga runacunata salvanäpä’ nir llullacur. Paycunaga cunchapita üshata suwacognömi Diosman yäracogcunatapis engañayar criyitsiyargan yäracuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ladronga shamun suwacunanpä, wanutsinanpä, y ushacätsinanpämi. Nogam itsanga shamurgö runacuna cay patsachö y ciëluchöpis cushishgalla cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Tsaynöpis üshacunapa alli mitsegninnömi cä. Nogaga alli mitsicognin carmi üshäcuna raycur wanushäpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pägallapä mitsipacog cagga leon shamogta ricaycur üshancunata jagisquirmi geshpir aywacun. Leon üshacunaman chaycurga gaticachar chipyaypam mashtacascatsin. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tsaynö runaga pägallapä mitsipacurmi üshacunataga mana cäsupar geshpir jegasquin”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Rasunpaypam nogaga üshapa alli mitsicogninnö cä. Papänëga musyanmi imanö cangäta y nogapis musyämi pay imanö cangantapis. Tsaynöllam noga musyä criyicamog cagcuna imanö cayangantapis. Y paycunapis musyayanmi noga imanö cangätapis. Tsaynö carmi paycuna raycur noga wanushä. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Manam cayllachötsu üshänö cagcuna cayan. Maytsaychöpis cayanmi. Paycunapis ningäcunata cäsucuyangam. Tsaymi paycunatapis gorir üshapa alli mitsicogninnö noga shumag ricayäshayqui llapayquitana”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nogaman yäracamogcuna raycurmi wanushä y cawamushä. Tsaynö cäsucungäpitam papänï cushicun. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Papänïpa munayninta rurar quiquïmi munayyog caycä wanunäpä y cawamunäpäpis. Tsaymi quiquï mana munaptëga chiquiyämagnïcuna wanutsiyämangatsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesus tsaynö niptinnam waquin runacuna yarpäyargan allita ninganta y waquincunanam yarpäyargan mana allita nicanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Atscagmi niyargan: “Satanasmi paytaga löcuyätsishga. Tsaynö caycaptinga ¿imanöpatä parlangantapis cäsushun?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waquincunanam niyargan: “Satanas löcuyätsingan runa manam tsaynö shumagga parlanmantsu. ¿Acäsu tsaynö löcuyashga runa gaprapa ñawinta allïtsinmancu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Tamya witsanmi Jerusalen marcachö templupa aniversariunta celebraycäyargan. Tsay templupa fiestanchömi Jesus puriycargan “Salomon” ningan alarchö. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tsaychö runacunanam Jesusta jirurupasquir niyargan: “¿Imayyagtä yarpachacur shuyaräyäshayqui willayämänayquipä? Gam Tayta Dios cachamungan salvacog carninga canan juclla willayämay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tsaynö niyaptinnam Jesus nirgan: “Willaytaga willargönam. Peru gamcuna manam criyiyämanquitsu. Tsaynölla papänïpa poderninwan milagrucunata ruraycaptïpis manam tantiyacuyanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gamcunaga criyiyämanquitsu quiquïpa üshäcunanö mana carninmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Üshäcunanö cagcunam itsanga cäsuyämarnï nogata gatiräyäman. Tsaynömi nogapis paycuna imanö cangantapis musyä. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Mana ushacag cawaytam cäsumag cagcunata garashä mana ogracaypa imayyagpis cushishgalla cawayänanpä. Tsay cawayta garanäpäga papänï Tayta Dios nogamanmi poderninta churamushga. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Papänïwan noga jucllayllam cayä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tsaynö niptinnam runacuna rumitana aptapacuyargan Jesusta samgayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tsaynam Jesus nirgan: “Papänïpa poderninwanmi runacunata yanapar atsca milagrucunata ñöpayquicunachö rurargö. ¿Maygan milagruta rurangäpitatä canan samgayämayta munayanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Paycunanam niyargan: “Manam ni maygan milagruta rurangayquipitatsu samgayta munayä, sinöga gam runalla caycar Dios tucuycangayquipitam”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Tsaynö niyaptinnam Jesus nirgan: “Mandamientucunata unay chasquicogcunapäga Tayta Diospa palabran gellgaranganchö caynömi nican: ‘Gamcuna wamräcuna carmi noganö caycäyanqui’ nir. Diospa palabran llapanpis rasun cagllata nicaptinga ");
INSERT INTO qxoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿imanirtä yarpäyanqui ‘Tayta Diospa tsurinmi cä’ niptï llutanta nicangäta? Tsurin captïmi Tayta Dios cay patsaman cachamashga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Rurangäcuna papänï Tayta Dios munangannö mana captinga manachi criyiyanquimantsu ‘Diospa tsurinmi cä’ niptïpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Rurangäcuna papänï munangannö caycaptinga criyiyämay. Tsaynö rurangäcunata ricarninnam tantiyacuyanqui papänïwan noga caycangäta y pay nogawan caycanganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tsaynö Jesus niptinnam yapay prësuytana munayargan. Tsaynö captinpis maquincunapitanam geshpir aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tsaypitanam Jordan mayupa wac-tsimpanmanna discïpuluncunawan aywacuyargan. (Tsaychö mas puntatam runacunata Juan Bautista bautizargan.) ");
INSERT INTO qxoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tsaymannam atscag runacuna chaycur niyargan: “Juan Bautista ima milagruta mana rurarpis Jesuspäga willacurgan rasun cagllatam llapantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tsaynö nirmi atscagna criyicuyargan Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania marcachömi Jesuspa amïgun Lazaro ishcay panincunawan täcuyargan. Paycunapa jutincunaga cargan Maria y Marta. Tsaychömi Lazaro pasaypa antsa geshyaycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Panin Mariam perjümiwan Jesuspa chaquinta llushir agtsanwan pitsapänan cargan.) ");
INSERT INTO qxoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaro antsaptinnam panincuna juc runata Jesusman cachayargan willacog: “‘Señor, cuyanacungayqui Lazarum pasaypa antsa geshyaycan’ niycamuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tsaynö willayaptinnam Jesus nirgan: “Lazaruta tsay geshya tsarishga manam wanushgallanchö usharänanpätsu, sinöga Tayta Dios poderösu canganta runacuna musyayänanpämi. Tsaynöpam musyayanga Tayta Dios poderninta nogaman churamunganta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lazaruwan panincunawan Jesus cuyanacuycarpis ");
INSERT INTO qxoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","manam jinan örallaga aywargantsu, sinöga ishcay junagran tsay caycangallanchö quëdacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsaypitanam discïpuluncunata nirgan: “Acu, cutishun Lazarupa marcan Judea provinciaman”. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tsaynam discïpuluncuna niyargan: “Taytay, ganyancunarächä tsaychöga runacuna samgaypa wanutsiyäshuyta munayargan. ¿Tsaynö caycaptincu gam yapay cutiyta munaycanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Niyaptin Jesusnam nirgan: “Ama mantsacuyaytsu. Wanutsiyämänanpäga manarämi örä chämunrätsu. Musyangantsicnöpis tsacaypa puregcunaga mantsacuyanmi. Junagpa puregcunaga manam mantsacuyantsu. Tsaynö mana mantsacuypa gamcunaga ningäcunata ruraycäyanqui wanucuptïpis nogaman yäracamur” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nircurnam Jesus nirgan: “Betaniachö tärag amïguntsic Lazaroga punucashgam caycan. Acu aywar riyatsimushun”. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tsaynö niptinnam discïpuluncuna niyargan: “Punucashgalla carninga riyamungachir, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tsaynö nir discïpuluncuna manam tantiyayargantsu Jesus imapä parlaycangantapis. Lazaro punucashgalla canganta yarparmi tantiyayargantsu wanushga canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tsaynö yarpäyaptinmi Jesus nirgan: “Lazaroga wanushgam. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Itsanga ama llaquicuyaytsu mana allïtsingäpita. Canan milagruta ruramuptïmi gamcuna tantiyayanqui Tayta Dios cachamanganta. Y acu, aywashun pay cagman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tsaynam discïpulu mayincunata “Millïshu” niyangan Tomas nirgan: “Jesus aywaycaptinga wanutsimäna captinpis aywashun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lazarupa marcan Betaniaman chärirnam Jesus discïpuluncunawan musyariyargan chuscu junagna Lazaro pamparanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Jerusalenpita Betania marcaman juc öra aywaynölla captinmi atscag runacuna aywayargan Mariata y Martata shogar wallquiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tsaypita Betaniaman Jesus yaycuraycagta musyasquirnam Marta aywargan taripagnin. Mariaga wayinllachömi quëdacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesuswan tincusquirnam nirgan: “Taytay, gam caychö captiquega turillä manam wanuycunmantsu cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Imayca mañacungayquitapis Tayta Diosga ruranmi. Tsaynöpis turilläta alliycatsinquimanchir cargan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusnam nirgan: “Turiquega cawamungam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tsaynö niycuptinnam Marta nirgan: “Aumi. Musyämi fisyu final junag wanushgacuna cawamuptin turilläpis cawamunanpä cagtaga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Tsaynam Jesus nirgan: “Nogam cawatsimü wanushgacunata. Nogata chasquimag cagtaga wanuptinpis cawaritsimushämi Tayta Dioswan imayyagpis cawayänanpä. Marta, ¿criyinquicu tsay ningäta?” ");
INSERT INTO qxoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tsaynö niptinmi nirgan: “Aumi, taytay. Noga criyïmi. Gammi Tayta Diospa tsurin salvacog canqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tsaynö nisquirninnam Jesusta jagirir Marta cuticurgan ñañan Mariata gayag. Chaycurnam Mariata gayaycur quiquillanta willargan: “Jesusmi chascamushga y gayashunquim” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tsaynö niptinnam Mariaga wap sharcur aywargan tincog. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesusga manarä marcaman yaycurmi Martawan tincunganllachörä caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria ras sharcur aywagta ricarninnam tsay wallquegnin runacuna gepanta aywayargan “Lazaro pamparanganmanchir aywaycan wagapag” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesus caycanganman Maria chasquirnam ñöpanman gonguricuycur nirgan: “Taytay, gam caychö captiquega turillä manam wanuycunmantsu cargan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tsaynam Maria y wallquegnincuna wagayagta ricaycurnin Jesus sientipar alläpa llaquipargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tsaynam tapurgan: “¿Mayninchötä pamparaycan?” nir. Paycunanam niyargan: “Acu ricatsiyäshayqui, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tsaynam pamparangan cagman aywaycar Jesuspis Lazarupä wagargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tsaynö wagagta ricarninnam runacuna niyargan: “¡Imaläyarä Lazaruwan cuyanacuycurgan!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waquincunanam itsanga niyargan: “Gapra runatapis alliycätsirga ¿manatsurä Lazarutapis allïtsinman cargan mana wanunanpä?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus tsaynö llaquicurnam chargan Lazaro pamparangan cagman. Pamparangan sepultüranga gagachö uchcushgam cargan. Tsay sepultüraga tsaparargan jatun rumiwanmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chaycurnam Jesus nirgan: “Tsay tsaparag rumita wititsiyay” nir. Tsaynö niptinnam Lazarupa panin Marta nirgan: “Taytay, chuscu junagnam wanungan. Cananyagga asyannachir” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesusnam nirgan: “¿Manacu nirgö nogaman yäracayämuptiquega Tayta Diospa poderninta ricayänayquipä cagta?” ");
INSERT INTO qxoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tsaypita rumita witiscatsiyaptinnam Jesus ciëluman ñuquircur nirgan: “Papällay, mañacungäta wiyamangayquita gamta agradesicamümi. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Imaypis wiyamangayquita musyarmi gamman mañacamü yanapaycamänayquipä. Yanapamangayquita ricarmi caychö caycag runacuna musyayanga gam cachamangayquita” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tsaynö mañacusquirnam Jesus fuertipa nirgan: “¡Lazaro, yargamuy!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsaynam pamparaycanganpita Lazaroga cawarcamur yargascamurgan maquin, chaquin, y uman wancupacushga. Tsaynam Jesus nirgan: “Lazaruta pascayay wayinpana aywacunanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tsaypita Lazaruta cawatsinganta ricaycurnin Mariata wallqueg runacuna atscagmi criyiyargan Jesusta Tayta Dios cachamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin cagcunanam fariseucunaman aywaycur willapäyargan wanunganpita Lazaruta cawascatsimuptin atsca runacuna Jesusman criyicuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sacerdöticunapa mandagnincuna y fariseucuna tsayta wiyasquirnam Israel runacunapa autoridänincunata gayatsiyargan sesionta rurayänanpä. Llapancuna goricasquirnam niyargan: “¿Imanaycuntsicnatä tsay runata? Atsca milagrucunatanachä ruraycunpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Payta mana tsaritsishganäga llapanpis munayanga nacionnintsicman mandacog churaytanachir. Tsayta musyasquirga Romachö mandamagnintsic pasaypa ajarchir soldäduncunata cachamunga templuntsicta ushacätsiyänanpä y nircur llapantsicta wanutsimänapä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tsaynö niyaptinmi llapan sacerdöticunapa mandagnin cag Caifas nirgan: “Gamcunaga manam imatapis tantiyayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Llapantsic wanunantsicpa rantinga tsay runalla wanutsun salvacunantsicpä. ¿Manacu tsayta tantiyayanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","“Tsay runalla wanutsun llapantsic salvacunantsicpä” nir Caifas nirgan Roma runacuna ushacätsiyänanta mana munarmi. Payga manam tantiyargantsu runacunapa jutsancunapita wanur salvananpä cagta. Mana tantiyaptinpis llapan sacerdöticunapa tsay watachö mandagnin captinmi tsaynö Tayta Dios parlatsirgan. Pay ningannöllam Jesus wanurgan Israel runacunata y mana Israel runacunatapis salvarnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tsay junagpitanam autoridäcuna willanacuyargan Jesusta wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tsayta musyarnam Judea provinciapita Jesus aywacurgan tsunyag jircapana “Efrain” ningan marcaman. Tsaychömi discïpuluncunawan quëdacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tsay junagcuna Pascua fiestancuna chämuptinnam maytsaypita Jerusalenman llapan Israel runacuna aywayargan. Tsaychönam Pascua fiestata shuyarnin üsuncunamannö alistacuyargan Tayta Diospa perdonninta mañacur. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tsay fiestachömi Jesusta ashiyargan. Mana tincurninnam templupa patiunchöna runacuna tapunacuyargan: “Gamcuna ¿imatatä yarpäyanqui? ¿Jesusga fiestaman shamungatsurä o manatsurä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sacerdöticunapa mandagnincunawan fariseucunaga runacunata yachatsipacushganam cayargan: “Jesus maychöpis canganta musyarninga juclla willacayämunqui prësuyämunäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiestapä jogta junagllana faltaycaptinnam Betania marcaman Jesus aywargan. Tsaychömi wanushgapita cawatsimungan Lazaro täcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tsayman Jesus watucagnin chaycuptinmi cushicuypita Lazarupa panincuna cusnacuyargan paywan micuyänanpä. Tsaychönam invitangancunawan Jesus jamacuriptin Lazarupis jamacurgan paycunawan micunanpä. Tsaymannam panin Marta llapancunata sirvirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Micuycäyaptinnam Maria chärirgan juc frascu alläpa chaniyog perjüminwan. Tsay perjümega cargan “nardu” ningan jachapita. Nircurnam Jesuspa chaquinman wiñaparcur agtsanwan pitsapargan. Y wayi juntam tsay perjümega pasaypa mushcuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tsayta ricaycurnam Jesusta ticrapog cag discïpulun Judas Iscariote ajashga nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imanirtä cay perjümita jichar perdiycätsin cay warmi? Tsay jichanganpa rantinga ranticusquir tsay gellëwanna wactsacunata yanapashwan cargan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tsaynö nir Judasga manam wactsacunapä rasunpa yarpartsu nirgan, sinöga discïpulu mayincunapa goricuyangan gellënincuna tsararag carmi quiquin böyanan raycur nirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tsaynam Jesus Judasta nirgan: “Cay perjümita wiñapäcamangantaga ama ajanaytsu. Manarä wanuptï caynö cuerpüta ruramarmi alistashgatana caycätsin pampayämänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wactsacunaga cay patsachö gamcunawan imaypis caycäyangam. Nogam itsanga manana gamcunawan cashänatsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tsaypitanam Betania marcachö Jesus caycanganta musyasquirna atscag runacuna tsayman aywayargan musyapacog. Y Lazarutapis ricaytam munayargan wanunganpita Jesus cawatsimunganta musyashgana carnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lazaruta cawatsimunganpita Jesusman atsca runacuna yäracushga cayaptinmi sacerdöticunapa mandagnincuna Lazarutapis wanutsiyta munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Warayninnam runacuna musyasquiyargan Jerusalenman Jesus aywaycanganta. Tsaynam Pascua fiestaman aywagcuna Jesusman chasquicog aywayargan palmëra jachapa rämancuna aptashga. Jesus yaycuraycaptinnam llapancuna gayaraypa niyargan: “¡Tayta Dios cachamungan mandamagllantsic rey alabashga caycullätsun! ¡Ima cushicuypämi nogantsicman cachaycamungan! ¡Gammi mandacog reylläcuna caycanqui! ¡Alabashga caycullay, taytay!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesusga mallwa ashnun muntashgam Jerusalenman yaycurgan. Tsaynö cananpäga Diospa palabran gellgaranganchömi willacun caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalen marca runacuna, ama llaquicuyaytsu. Ricayay mallwa ashnun muntashga reyniquicuna shamuycagta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tsaynö Jerusalenman ashnun muntashga Jesus chäriptin discïpuluncunaga manam tsay öra tantiyayargantsu imanir tsaycuna päsaycanganta. Wanunganpita cawascamuptinrämi tantiyasquiyargan payta tsaynö päsananpä cag Diospa palabran gellgaranganchö ninganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazaruta Jesus cawatsinganta ricag runacunaga maychö tsaychöpis willacuyarganmi ricayanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tsaynö milagru ruranganta musyayashga carninmi atscag runacuna cushishga Jesusman chasquicog aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jesusta pasaypa atsca runacuna gatiräyaptinmi fariseucuna quiquincuna pura ninacuyargan: “¿Imanötä cashun? ¡Llapancunanachä payta gatiräyan!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua fiesta captinmi maytsay nacioncunapitapis Jerusalenman aywayargan mana Israel runacunapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paycunam Felipiman aywaycur rugacuyargan caynö nir: “Jesuswanmi nogacunapis tincuyta munayällä, taytay” nirnin. (Felipega cargan Galilea provincia Betsaida marcapitam.) ");
INSERT INTO qxoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tsaynö rugacuyaptinmi Felipe aywaycur Andresta willargan. Tsaynam ishcancunana aywar Jesusta willayargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tsaynö willayaptinnam Jesus nirgan: “Noga ciëlupita shamog llapan runacuna raycur wanunäpä örä chaycämunnam. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Shumag tantiyayämay. Musyangantsicnöpis trïguta murur mana pampashgaga manam jegamuntsu. Tsaynöllam noga mana wanuptëga pipis salvacungatsu. Wanuptïmi itsanga runacuna salvacuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quiquin munangallanman cawag cagga manam pipis salvacungatsu. Tayta Dios munangannö cawag cagmi itsanga salvacur paywan cushishgalla imayyagpis cawayanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mayganpis discïpulü cayta munag cagga noga cawangänö cawatsun. Imanö ñacarpis mana ajayaypa gatirämätsun. Tsaynö gatirämagcunataga papänï Tayta Dios imanö shumagrä ricaycunga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Feyupa llaquinaymi tsaricaycamashga. ¿Papälläta ‘Cay ñacanäpä cagpita jipiycamay’ nir rugacushätsurä? ¡Manam! Tsaynö wanunäpämi cay patsaman shamurgö”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tsaynö nisquirmi Tayta Diosta nirgan: “Papällay, gam munangayquinö runacuna adorayälläshuy” nir. Tsaynö rugacuptinmi ciëlupita Tayta Dios nimurgan: “Runacuna adorayämänanpä mañacamangayqui imaypis ningayquinöllam canga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tsayta wiyaycurnam tsaychö caycag waquin runacuna caynö niyargan: “Räyum cashga” nir. Waquinnam “Juc puëdeg angelmi Jesusta parlapämushga” niyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tsaynam Jesus nirgan: “Manam gamcuna yarpäyangayquinötsu. Tayta Diosmi tsaynö nimushga munangannö nicangäta tantiyayänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Runacuna nogata wanutsimänanpä cag öra chaycämunnam. Tsaynöpis Satanas cay patsachö munayyog caycanganpita gargucashga cananpänam caycan. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y cruzman clavasquir ichiscatsiyämaptinmi Israel runacunata y mana Israel runacunatapis tantiyatsishä yäracayämänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tsaynö nirmi Jesus musyatsicurgan imanö wanunanpä cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tsaymi runacuna niyargan: “Diospa palabran gellgaranganchöga nican salvamagnintsic imayyagpis cawananpä cangantam. Tsayöraga ¿imanirtä nicanqui wanunayquipä cagtaga? Tsaynö nirga ¿rasunpacu salvacog Cristo canqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tsaynam Jesus nirgan: “Aumi, Tayta Dios cachamangan salvacogmi cä. Tsaynö captinpis juc ishcay junagllanam Tayta Dios nimangancunata yachatsiyäshayqui. Tsaymi gamcunawan caycangäyag yachatsingäcunata chasquicuyay. Junagpa pureg runa aywananpä cagta musyanmi. Tsaynömi yachatsingäcunata chasquicogcunaga musyayan Tayta Dios perdonar salvananpä cagta. Tsacaypa pureg runaga ishquinanpä cagta manam musyantsu. Tsaynömi yachatsingäta mana chasquicogcunaga musyayantsu infiernuman aywayänanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gamcunawan caycangäyag yachatsingäcunata chasquicuyay. Tsaynöpam tantiyayanqui Tayta Dios munangannö cawayänayquipä cagta”. Tsaynö nisquirnam Jesus aywacurgan y runacunaga manam musyayargantsu maypa aywangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tsaytsica milagrucunata Jesus ruranganta ricaycarpis runacuna manam criyiyargantsu Tayta Dios cachamungan salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tsaynö mana criyiyaptinmi Diospa unay willacognin profëta Isaias gellgangannö cumplirgan. Tsay gellganganga caynömi nican: “Tayta Dios, willacuyniquita runacuna manam chasquiyantsu. Milagrucunata ricarpis manam criyiyantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tsaynö mana criyicogcunapäga Isaias mastapis caynömi gellgargan: ");
INSERT INTO qxoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ñawincuna ricaycaptin y rinrincuna wiyaycaptinpis wiscunö upanö ticrar willacuyninta mana tantiyananpämi Tayta Dios permitirgan. Y tsaynömi shonguncunatapis chucruyätsirgan payman mana yäracuyänanpä. Tsaymi Tayta Dios cacharirgan jutsancunapita manana perdonashga cananpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaias tsaynö gellgargan runacuna Jesusta mana chasquicuyänanpä cagta musyarnam. Paytam Tayta Dios ricatsirgan Jesus glorianchö munayyog caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Waquincuna mana chasquicuycäyaptinpis atscag autoridäcunaga criyicuyarganmi Tayta Dios cachamungan salvacog canganta. Tsaynö criyicurpis Jesusman yäracog cayangantaga manam parlayargantsu goricäcuyänan wayipita waquin fariseo autoridäcuna garguyänanta mantsapacurnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tayta Diospita alli ricashga cayänanpa rantinmi masnin cagga munayargan runacunallapita alabashga cayta. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tsaynam fuertipa Jesus nirgan: “Nogata chasquicamag cagga cachamagnï Tayta Diostapis chasquiycanmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nogata regimag cagga cachamagnï Tayta Dios imanö cangantapis tantiyanmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tsaynö runacunata noga tantiyatsï tsacaychönö jutsallachö cawaycäyanganpita Tayta Dios munangannöna cawayänanpämi. Tayta Dios munanganta musyatsicurmi cay patsachö runacunapä actsinö caycä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","“Ningäcunata wiyaycarpis mana cäsumarga castigashgam cayanqui. Manam nogatsu castigayäshayqui, sinöga Tayta Diosmi castigashunqui ‘Cachamungä Jesus nishungayquicunata ¿imanirtä cäsuyargayquitsu?’ nirnin. Nogaga cay patsaman shamurgö runacunata manam castiganäpätsu, sinöga jutsancunapita perdonar salvanäpämi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Manam quiquilläpa yarpaylläpitatsu willacuycä, sinöga cachamagnï Tayta Dios nimangancunallatam. ");
INSERT INTO qxoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tsaynö willacuptïmi runacuna salvacur mana ushacag alli cawayta tariyanga. Tsaymi papänï Tayta Dios nimangannölla imaypis willacuycä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Israel runacunapa Pascua fiestancuna gallaycunanpänam caycargan. Jesusga musyarganmi tsay witsancuna wanunanpä öranna chaycanganta. Payman llapan criyicogcunata cuyarninmi Jesusga munargan imaycachöpis yanapayta wanuyta tarirpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Discïpuluncunawan Jesusga merendayänanpänam caycargan. Tsaychö Simon Iscariotipa tsurin Judastaga Satanas yarpätsishganam cargan Jesusta ranticunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tsaynö päsanan captinpis Jesusga musyarganmi imaycatapis munayninman Tayta Dios churanganta y pay cagman cuticunanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tsaychö micuycäyaptinnam Jesus sharcur mantunta llogtirir secacuna ratashta tsegllanman watacurcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nircurnam tïnaman yacuta wiñasquir discïpuluncunapa chaquinta awipayta gallaycurgan. Awipasquirnam tsaquitsipargan tsararangan ratashwan. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaquinta awipänanpä caycaptinnam Simon Pedroga nirgan: “Taytay, gamga chaquïta manam awipämanquimantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tsaynö niptinnam Jesus nirgan: “Gam manam tantiyanquitsu imanir awipaycangätapis. Nircurrämi tantiyamanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tsaynam Pedro nirgan: “Imanö captinpis chaquïtaga manam awipämanquimantsu, taytay”. Niptinmi Jesus nirgan: “Chaquiquita mana awipaptëga manam discïpulü canquimantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tsaynam Simon Pedro nirgan: “Tsayöraga taytay, ama chaquillätaga maquïtapis y umätapis awipaycallämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesusnam nirgan: “Armacushgana caycaptiquega chaquillayquitanam awipänä. Tsaynöna carmi gamcunaga awicushga cuentanö jutsayquicunapita limpiuna cayanqui. Jucniquicunam itsanga jutsata mana jagir mana limpiutsu caycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tsaynöga nirgan juc discïpulun ranticunanpä cagta musyarninmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Llapancunapa chaquincunata awisquirnam mantunta jaticurcur yapay jamacurgan. Nircurnam caynö nirgan: “¿Tantiyayanquicu imanir chaquiquicunata awipangäta? ");
INSERT INTO qxoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gamcuna niyangayquinöllam munayyog y yachatsicog cä. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nogaga yachatsiyäshogniquicuna caycarpis sirvipacognöllam chaquiquicunata awipargö. Tsaynöllam gamcunapis jucniqui jucniquipis awipänacuyänayqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tsaynö rurargö gamcunapis noga cuyangänölla perdonanacur cuyanacuyänayquipämi. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Musyangantsicnöpis sirvegninga manam patronninpita mas munayyogtsu. Tsaynöllam mandacog runapis cachacognin mandangancunallata ruran. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tsaymi gamcunapis noga ningäcunata rurayänayqui. Tsay ningäcunata cumplirga cushishgam cawayanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Gamcunata nogam acrargä discïpulücuna cayänayquipä. Tsaynö caycaptinpis ningänö jucniquim conträ sharcuyanqui. Tsaypämi Diospa palabran gellgaranganchö nican: ‘Nogawan micur caycagmi conträ sharcunga’ nir. Tsay ninganga cumplingam. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tsaycuna manarä päsaptinmi gamcunata willapaycä tsaynö cananpä cagta. Ningänölla päsaptinran musyayanqui Tayta Dios cachamangan salvacog cangäta. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Willacuynïta willacogcunata chasqueg cagcunaga nogatapis chasquiycäyämanmi. Y nogata chasquicamarnaga cachamagnï Tayta Diostapis chasquiycäyanmi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tsaynö nisquirnam shongunchö Jesus pasaypa llaquicurnin nirgan: “Gamcunapita jucniquim ranticamanga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tsaynam discïpuluncuna jucnin jucninpis ricapänacuyargan maygancunapä nicangantapis mana musyarnin. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tsay nicangan öra paypa mas cuyay cag discïpulunpis Jesuspa lädunchömi micur caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tsaymi tsay cuyay discïpulunta Simon Pedro sëñasllapa tapurgan mayganpä parlaycangantapis Jesusta ninanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tsaynam payga tapurgan: “Taytay, ¿maygäcunatä tsayga caycäyä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tsaynö tapuptinnam Jesus nirgan: “Tsayga tantata matichö tullpurcur garangä cagmi canga” nir. Tsaynö nisquirnam tantata tullpurcurnin gararirgan Simon Iscariotipa tsurin Judasta. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Satanas Judaspa shongunman yaycushgana captinmi Jesus caynö nirgan: “Ruranayquipä cagta jinallachöna ruray” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tsaychö discïpuluncuna manam ni mayganpis tantiyayargantsu imanir tsaynö nicangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Discïpulu mayincunapa gellënincuna tsarag captinmi Judaspäga yarpäyargan fiestapä imallatapis rantipacamog Jesus cachaycanganta. Waquincunanam yarpäyargan wactsacunata yanapag cachaycanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tsaynam Jesus garangan tantata chasquisquirnin Judasga jucllana yargurirgan Satanas munanganta rurananpä. Patsaga tsacashganam cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Judas yargusquiptin waquin cagcunallawan Jesus quëdasquirnam nirgan: “Örä chaycämunnam noga ciëlupita shamog wanunäpä. Wanusquiptïmi quiquin Tayta Dios cawaritsimanga. Cawascatsimaptinran runacuna tantiyayanga noga Diospa tsurin cangäta y Tayta Dios munayyog canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Cuyay wamrallänö cagcuna, ichicllanam faltaycan gamcunata jagirinäpä. Waquincunata ningänöllam gamcunatapis canan nicä: Nogata ashiyämarpis mananam tariyämanquitsu. Aywanäpä cagman gamcuna manarämi chäyanquirätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Cananmi juc mushog mandamientuta yachatsiyäshayqui. Jucniqui jucniquicunapis shumag cuyanacuyanqui gamcunata noga cuyangänölla. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ningänölla cuyanacuyaptiquim llapan runacuna tantiyacuyanga nogapa discïpulücuna cayangayquita”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tsaynam Simon Pedro tapurgan: “Taytay, ¿maypatä aywacunqui?” Niptin Jesusnam nirgan: “Noga aywangä cagmanga manaran aywanquirätsu. Peru gampis wanur shamunquinam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tsaynam Pedro nirgan: “Taytay, ¿imanirtä cananga gampa gepayquita shamümantsu? Gam raycur noga wanunäpäpis listum caycä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tsaynö niptinnam Jesus nirgan: “¿Rasunpatsurä noga raycur wanunayquipä listu caycanqui? Tsaynö nirpis gällu manarä cantaptinmi quimsa cuti ‘Manam regïtsu’ nimanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tsaypitanam discïpuluncunata Jesus nirgan: “Ama gamcuna llaquicuyaytsu. Tayta Diosman yäracuyay. Tsaynölla nogamanpis yäracayämuy. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Papänï caycanganchöga atsca wayicunam caycan täräyänayquipä. Tsaymanmi puntashä gamcuna shayämunayquipä alistag. Tsaychö mana captinga manam alistag aywanäpä willacümantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Alistapacascamurnam cutimushä gamcunata pushanäpä. Tsaynöpam noga tärangä cagchö gamcunawan täräshun. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Noga aywangä cagman chäyänayquipäga gamcuna musyayanquinam maygan nänipa aywayänayquipä cangantapis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tsaynö niptinnam Tomas nirgan: “Taytay, mayman aywanayquipä cangantapis mana musyaycarga ¿imanöpatä musyayäman maygan nänipa aywayänäpä cagtapis?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tsaynam Jesus nirgan: “Nogallaman yäracayämuy. Papänï Tayta Dios caycanganman chäyänayquipäga nogam pushayäshayqui. Chäyänayquipä willacuynëga rasun cagllam y nogallam runacunatapis cawatsï. Tsaymi nogata chasquicamag cagcunalla papänïman chäyanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Puntata manam nogata regiyämarguyquirätsu. Canan regiyämarnin chasquicayämarnam itsanga papänïtapis chasquiycäyanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tsaynam Felipe nirgan: “Taytay, nogaga gamta regirpis manarämi Tayta Diosta ricargörätsu. Tayta Diosta regiycatsillämay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Niptin Jesusnam nirgan: “Felipe, ñöpapitana gamcunawan caycaptïpis ¿manacu cananyag pï cangäta musyaycunqui? Nogata regimag cagga Tayta Diostapis reginmi. Nogata regiycämarga ¿imanirtä rugacamanqui Tayta Diosta regitsinäpä? ");
INSERT INTO qxoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manacu criyinqui Tayta Dios nogawan caycanganta y nogapis paywan caycangäta? Imaypis nogawan Tayta Dios captinmi ningäcuna y rurangäcunapis quiquïpa yarpaylläpitatsu, sinöga pay munangannöllam. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tsaymi Tayta Dioswan noga caycangäta y paypis nogawan caycanganta nicaptëga criyiyämanquiman. Tsay ningäcunata mana criyimarpis milagru rurangäcunata ricaycarga criyiyämay ari”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Papänï Tayta Diosman cuticuptïmi nogaman yäracamogcunaga noga ruranäpä cagcunata rurayanga. Tsaynö rurayaptinmi masna runacuna tantiyacur nogaman criyicayämunga. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tsaynö imaycatapis rurayänayquipäga nogaman yäracamur papänïman mañacuyay. Mañacuyaptiquega noga yanapayäshayquim. Tsaynöpam runacuna maytsaychöpis Tayta Diosta cäsucur alabayanga. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nogaman yäracamur mañacayämaptiquega imaycatapis gamcunapä rurashämi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Gamcuna nogaman yäracamurga llapan ningäcunata cäsucuyay. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tsaynö cawanayquipämi Tayta Diosman mañacushä Espiritu Santuta gamcunaman cachamunanpä. Espiritu Santunam imaypis gamcunawan caycanga yanapayäshurniqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nogaman mana yäracamogcunaga Espiritu Santuta manam chasquiyangatsu. Paycunaga manam tantiyayantsu Espiritu Santo pï cangantapis. Gamcunam itsanga ningäcunata criyir tantiyayanqui Espiritu Santo munayyog cayninwan yanapacog canganta. Espiritu Santo shamurnam gamcunawan imaypis caycanga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","19","“Ama yarpäyaytsu manana tincunantsicpä cagta. Wanungäpita cawarcamurga gamcunawan tincushunrämi. Tayta Diosta mana cäsucogcunawanga mananam tincushänatsu. Noga wanurpis cawamungänöllam gamcunapis cawayämunqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tsay öram tantiyayanqui Tayta Dioswan caycangäta y gamcunawanpis noga caycangäta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yachatsingäcunata wiyacog cagga rasunpaypam nogaman yäracayämun. Tsay yäracamogcunataga papänïpis y nogapis cuyar yanapayäshämi. Tsaynöpam musyatsicushä imaypis cuyacog cangäta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tsaynö niptinmi Santiagupa tsurin Judas (mana Iscariote cag) tapurgan: “Taytay, nogacunata yanapayämänayqui caycaptinga ¿imanirtä waquin runacunatapis mana yanapaycunquimantsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tsaynam Jesus nirgan: “Nogaman yäracamur cäsucamagcunallatam cuyaparnin papänïwan yanapayäshä. Tsaymi cawascamur paycunawan imayyagpis cashä. Tsaynöllam papänïpis paycunawan canga. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nogaman yäracamur cäsumagcunallam ningäcunata rurayan. Noga willapaycangäcunataga manam quiquïpa yarpaylläpitatsu, sinöga cachamagnï papänïllapitam”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Cay ningäcunata willapaycä gamcunawan caycangäyagllam. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gamcunapita aywacuptïnam Espiritu Santuta Tayta Dios gamcunaman cachamunga. Paynam Tayta Diospa willacuyninta y llapan ningäcunatapis yarpätsiyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Gamcunapita aywacuptïpis ama llaquicuyaytsu ni mantsacäyaytsu. Aywacurpis gamcunata yanapaycäyäshayquim alli ruraychö shumag cawayänayquipä. Noga yanapangänöga manam pipis yanapayäshunquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Papänï caycangan cagman cushishga aywacuptïpis cutimunäpä cagtaga musyayanquim. Paypa munayninchö caycangäta musyaycarga gamcunapis cushicuyanquimanmi, papänï cagman cuticuptïpis. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Gamcunata tsaynö willapaycä manarä aywacurmi. Aywacusquiptïnam musyayanqui ningäcuna rasunpaypa canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","“Satanaspa munayninta rurar prësu tsariyämänanpä runacuna shayämunganam. Tsaymi gamcunawan parlanäpä tiempu canganatsu. Satanasga imata ruramänanpäpis manam munayyogtsu. Tsaynö caycaptinpis paypa mandunta rurar runacuna shayämuptin manam imatapis parlacushätsu. Tsaynöpam musyayanga Tayta Dios nimangannölla llapantapis cumpliycangäta”. “Acu, caypita aywacushunna”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tsaypitapis jinallam Jesus parlapargan: “Nogaga üva plantapa yurannömi cä. Papänïnam tsay üva plantapa duëñunnö. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nogaman yäracamogcunaga üvapa rämancunanömi cayan. Tsaymi maygan rämapis mana wayuptinga papänï mutucachasquin. Peru cösa wayog cagtaga papänï shumag cuïdarmi llaumapan mas wayunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamcuna shumag llaumapashga üva plantanömi yachatsingäcunata chasquicur jutsayquicunapita perdonashgana caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Üvapa räman troncunchö mana carga manam wayunmantsu. Tsay cuentanöllam gamcunapis nogaman mana yäracayämurga Tayta Dios munangannö cawayanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nogaga cä üvapa yurannömi. Gamcunanam rämäcunanö caycäyanqui. Tsaymi nogaman yäracayämuptiquega yanapayäshayqui Tayta Dios munangannö cawayänayquipä. Tsaynöpam gamcunapis üva planta pasaypa wayognö allita rurar cawayanqui. Nogaman mana yäracamurga manam Tayta Dios munangannö cawayanquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pipis nogaman mana yäracamog cagcunaga mutucachasquir tsaquicunanpä jitasquiyangannömi canga. Tsay tsaquishga rämacunataga gorisquirmi cayascäriyan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Tsaymi nogaman imaypis yäracamur yachatsingäcunata cäsucur cawayay. Tsaynö cawarga llapan mañacayämangayquitam chasquiyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Noga munangänö cawarmi rasunpaypa discïpulücuna cayanqui. Gamcuna alli cawayangayquipitam runacuna nogata chasquiyämanga. Tsaynö chasquiyämaptinmi papänï alläpa cushicunga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","“Papänï cuyamangannömi nogapis gamcunata cuyä. Tsaynö cuyaycaptëga gamcunapis cäsuyämar cawayay. Tsaynöllam nogapis, papänï cuyamaptin, nimangancunata cäsucü. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Gamcunata tsaynö parlapaycä noga cushishga cawangänö gamcunapis cushishga imaypis cawayänayquipämi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Mandangäta cäsucur jucniqui jucniquipis cuyanacuyay gamcunata noga cuyangänölla. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Rasunpaypa cuyacog carga pipis cuyanacunganpäga vïdantapis ogranmi. Tsay cuyacuynöga manam cuyacuy cannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Llapan ningäcunata cäsumarga gamcunapis cuyay amïgücunam cayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Juc sirvipacog runataga manam patronnin willapantsu imata yarpaycangantapis. Gamcunataga cuyarninmi papänï nimangancunata llapanta willapargö”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Cuyaynïcuna caycäyanqui manam gamcuna nogata acrayämangayquipitatsu, sinöga gamcunata noga acrangäpitam. Tsaymi gamcunata cachaycä willacuynïta willacuyänayquipä. Tsaynöpa musyatsicuyaptiquim runacuna salvacur Tayta Dios munangannö imayyagpis allina cawayanga. Nogaman yäracayämur imaycatapis papänïta mañacuyaptiquega garayäshunquim. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tsaymi gamcunata nicä jucniqui jucniquipis shumag cuyanacur cawayänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Runacuna chiquiyäshuptiquega ama llaquicuyaytsu. Nogata chiquiyämangannöllam gamcunatapis chiquiyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tayta Diosta mana cäsucogcuna jutsa rurayllachö cawayangannö cacuyaptiquega gamcunatapis cuyacurcuyäshunquim. Tayta Dios munangannö cawayaptiquim chiquiyäshunqui. Tsaynö chiquiyäshuptiquipis pay munangannö cawayänayquipämi gamcunata noga acrargö”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Ningäta yarpäyay. ‘Juc sirvipacog runa manam patronninpita mas munayyogtsu’ ningänöllam cananpis gamcunata nicä: Patronninta chiquipagcunaga sirvegnincunatapis chiquiyanmi. Tsaynöllam nogata chiquimag cagga gamcunatapis chiquiyäshunqui. Y nogata chasquimag cagcunaga gamcunatapis chasquiyäshunquim. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Runacuna tsaynö chiquiyäshunqui discïpulücuna cayangayquipitam y cachamag papänïta mana cäsucog cayanganpitam”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","24","“Tayta Diospa willacuyninta willacurmi runacunata tantiyatsirgö pay cachamashga captin. Tsaynöga tantiyatsirgö pipis mana ricangan milagrucunata rurarmi. Tsaynö tantiyaycätsiptïpis nogata chiquimag cagga jutsayogmi caycäyan. Mayganpis nogata chiquimag cagga papänïtapis chiquiycanmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Diospa palabran gellgaranganchöpis caynömi nican: ‘Ima jutsaynag caycaptïmi chiquiycäyäman’ nir. Tsay gellgarangannöllam llapanpis cumpliycan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Noga papänï cagman aywacur Espiritu Santuta cachamuptïmi cay patsaman shamunga runacunata pï cangäta tantiyatsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tsaynölla gamcunapis runacunataga willapar tantiyatsiyay nogawan purishga caycarga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Chiquiyäshunayquipä cagta y Espiritu Santo shamunanpä cagtapis gamcunawan caycangäyagmi nicä. Tsaynö chiquiyäshuptiqui llaquicurpis nogallaman imaypis yäracayämunqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Goricäcuyänan wayipitapis garguyäshunquim. Tsaynömi waquinniquicunata wanutsiyäshunqui, Tayta Dios munangannö allita ruraycäyanganta yarpar. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tsaynö rurayäshunqui papänïtapis ni nogatapis mana chasquiyämarmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tsaynö rurayäshuptiquim yarpäyanqui tsaycuna päsananpä ningäcunata. Gamcunawan caycaptëga runacuna nogallatam chiquiyämargan. Aywacuptïnam itsanga gamcunatapis chiquiyäshunquina. Tsaymi manarä aywacungäyag gamcunata willapaycä tsaynö chiquiyäshuptiqui mana llaquicuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","“Cananga cachamagnï papänï cagman aywacunäpänam caycä. Tsaynö captinpis waraycuna imanöpis cawayänayquipä cagta mana yarpachacurmi gamcunaga pasaypa wamayashga ticrasquiyarguyqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","¿Imanirtä llaquicuyanqui? Aywacurpis Espiritu Santutam gamcunaman cachamushä mana dejaypa yanapayäshunayquipä. Mana aywaptëga manam Espiritu Santo shamungatsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Espiritu Santo shamurnam runacunata tantiyatsinga jutsayog cayanganta, alli tucog cayanganta, y tsaynö cayanganpita infiernuman aywayänanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tsaynömi runacunata tantiyatsinga nogata chasquicamar jutsancunapita perdonashga cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tsaynöga ‘Noga allita rurarmi cawaycä’ nir yarpagcunatam ciëluman cuticusquiptï Espiritu Santo tantiyatsinga Tayta Dios munangannö mana cawaycäyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tsaynöllam tantiyatsinga Satanaspa munayllanchö cayanganpita infiernuman aywayänanpä cagta. Tsaynömi Satanaspis infiernuman gaycucanga tsaychö imayyagpis castigashga cananpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","13","“Atscarä gamcunata willanäpä captinpis Espiritu Santo shamurnam llapanta tantiyatsiyäshunqui. Payga manam quiquinpa yarpayllanpitatsu tantiyatsiyäshunqui, sinöga Tayta Dios yarpangancunallapitam. Tsaynöllam tantiyatsiyäshunqui imapä wanungäta y imapä cawamungätapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","15","Tayta Dios munangannöllam noga rurangäcunapis caycan. Tsaymi Tayta Dios munangancunata Espiritu Santo tantiyatsiyäshurniqui noga rurangäcunatapis y ningäcunatapis tantiyaycätsiyäshunqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Gamcuna caypita mananam ricayämanquinatsu. Peru tsaypita waraycunaga tincurishunrämi”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tsaynö niptinnam discïpuluncuna tapunacuyargan jucnin jucninpis: “Caynö nirnin ¿imatarä nicämantsic? ¿Imanirrä nimantsic ‘Mananam ricayämanquinatsu’ nir? Y nircurga ¿imanirrä nin: ‘Tsaypita waraycunaga tincushunrämi’? Y ¿imanirrä ‘Papänï cagpanam aywacushä’ nin? ");
INSERT INTO qxoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imaypitarä payta ricashuntsu? Manam tantiyantsictsu imata parlapaycämangantsictapis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tsaynö yarpachacuycäyanganta musyarmi Jesus nirgan: “¿‘Ricayämanquinatsu’ y ‘Tincushunrämi’ ningäpäcu gamcuna tapunacuycäyanqui? ");
INSERT INTO qxoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aywacuptï waquin cushicuptinpis gamcunaga feyupa llaquicurmi wagayanqui. Tsaynö llaquicusquirpis tsaypitaga cushicuyanquim. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Musyantsicmi juc geshyag warmi wachacunan öra pachan tsariptin warmi mayincuna llaquicuyanganta. Wamran yurisquiptinmi itsanga cushicuywan manana yarpäyannatsu nanatsicur wachacuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tsaynöllam gamcuna canan llaquicurpis yapay tincurishgaga alläpa cushicuyanqui. Tsay cushicungayquitaga imayca päsayäshuptiquipis manam gongayanquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Yapay tincushgaga mananam tapuyämanquinatsu imanir tsaynö parlangätapis. Tsaymi nogaman yäracayämuptiqui llapan mañacuyangayquita papänï garayäshunqui puntacunata ningänölla. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Canan junagyagpis Tayta Diosman mañacuyarguyqui pay cachamanganta mana musyarmi. Cananpitaga nogaman yäracamur papänïta imatapis mañacuyay. Tsaynö mañacurga chasquiyanquim gamcuna cushishgana cawacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gamcunata imayca iwalatsicuycunawanmi yachatsirgö. Cananga mananam tsaynöpanatsu parlapäyäshayqui. Tayta Diospita ningäcunata llapantapis tantiyatsiyäshayquim. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Yachatsingäcunata tantiyarirnam nogaman yäracamur Tayta Diosman mañacuyanqui. Tsaynö mañacuyaptiquega wiyayäshunquim llapan mañacuyangayquicunata. Payga cuyayäshurniqui nogarä gamcunapä mañacunäta manam shuyarangatsu, sinöga jucllam mañacungayquicunata chasquiyanqui. Tsaynö cuyayäshunqui paypita shamungäta criyiyämar chasquiyämangayquipitam. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Papänïpa ñöpanpitam cay patsaman noga shamurgö. Tsaynöllam papänïpa ñöpanman cuticushä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tsaynö niptinnam discïpuluncuna niyargan: “¡Cananmi itsanga llapan parlapäyämangayquita shumagna tantiyaycäyä! Mananam iwalatsicuycunawan niyämangayquitanönatsu parlaycanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tsaynöpam musyayä llapanta imaycatapis gam musyangayquita. Nogacuna mana tapupaycäyaptïpis willaycäyämanquim mana tantiyayangäcunataga. Tsaymi Tayta Diospita shamungayquita criyiyä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tsaynam Jesus nirgan: “¿Tsayrächi rasunpa criyiycäyämanqui? ");
INSERT INTO qxoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cananga öra chämushganam japalläta jagiriycamar llapayquicuna wacpa caypa aywacuyänayquipä. Tsaynö jagirayämaptiquipis manam japalläga cashätsu papänï Tayta Dios nogawan caycaptinga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Cay llapancunatapis gamcunata nicä runacuna chiquiyäshuptiquipis nogaman imaypis yäracayämunayquipämi. Nogaman yäracamogcuna cay patsachö cayangayquiyagga ñacayanquiran. Tsaynö captinpis ama gongayanquitsu noga gamcuna raycur wanuptï salvacionta alcanzayänayquipä cagta. Tsaynö caycaptinga imayca llaquicuy päsayäshuptiquipis nogaman yäracullar cawayay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tsaynö yachatsicur ushasquirnam Jesus ciëluman ñuquircur Tayta Diosman mañacur nirgan: “Papällay, cananga wanucunä öra chämushganam. Wanuptïpis cawariycatsillämanqui. Cawarircamur runacunata salvaptïmi imayyagpis alabayäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Llapan runacunatanam munaynïman churamurguyqui, tsaynöpa entregamangayqui cagcunata salvaptï gampa ñöpayquichö imayyagpis cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Gamwan imayyagpis gloriachö cawayänanpä salvaptïmi tantiyayanga gamlla imaycawan munayyog cangayquita y cachamangayqui salvacog noga cangäta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Llapan nimangayquicunata cay patsachö cumplir munayyog cangayquita musyatsicurgönam. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cananga pushacallämayna, papällay, gampa ñöpayquichö cay patsa manarä camashga captin munayyog cangänö cananpis ñöpayquichö munayyog canäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Papä Tayta Diosllä, tsaynömi discïpulücunapä mañacaycallämü. Paycunataga acrargayqui munaynïchö cawayänanpämi. Tsaymi paycuna willacuyniquita yachatsiptï chasquicuyashga. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cananga musyayannam llapan yachatsingäcuna gam munangayquinölla canganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gam cachamangayquita tantiyarmi llapan yachatsingäcunata chasquicuyashga. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","Cay discïpulücunata munaynïman churamurguyqui gampa munayniquichö y nogapa munaynïchö cawayänanpämi. Paycunaga tantiyacuyashganam gampita shamungäta. Tsaymi paycunapä mañacaramü, papällay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Poderösu cayniquiwan paycunata ricaycuy y yanapaycullay imaypis yachatsingänö cawayänanpä. Tsaynöpam tsay yarpaylla cangantsicnö paycunapis cuyanacur tsay yarpayyoglla car juc shongulla cayanga. Tsaynö mañacaycallämü gampa ñöpayquimanna cuticamunä captinmi, papällay. Paycunam itsanga cay patsachö cayangarä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Paycunatam poderniquiwan shumag ricargö nogaman yäracayämunganpita mana witicuyänanpä. Tsaynö ricaptïmi mayganpis witicushgatsu. Jucmi itsanga infiernuman aywananpäna ogracashga, gampa palabrayqui gellgaranganchö cumplinan captin”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Tsaymi discïpulücunapä gamman mañacaycamü shumag ricaycunayquipä, papällay. Gampa ñöpayquiman shacamur noga cushishga cangänö paycunapis cushishgalla cawaycuyätsun”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Gampa willacuyniquita paycunata willapangäta cäsucur manam waquin runacunanönatsu cawaycäyan, sinöga noga cawangänönam cawayan. Tsaynö cawayaptinmi runacuna chiquiyan. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Chiquiyaptinpis manam cay patsapita juclla goricunayquipätsu gamman mañacamü, sinöga cay patsachö cayanganyag paycunata shumag ricaycunayquipämi. Paycunata ricaycullay Satanas llutanta mana ruratsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Cay patsachö canan cawaycarpis manam cay patsallachö cawayänanpätsu caycäyan, sinöga ciëluchö noga canäpä cangannöllam paycunapis caycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Papällay, ama jutsa ruraychö cayänanta munaycuytsu. Gam munangayquinö shumag cawayänanpä willacuyniquita tantiyaycatsillay. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Alli willacuyniquita willacunäpä cachamangayquinöllam paycunatapis noga cachaycä willacuyniquita willacuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gam munangayquita rurar noga cawargö paycunapis munangayquita rurar cawayänanpämi. Tsaynömi ari discïpulücunapä mañacaycallämü”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Discïpulücuna willacuyniquita musyatsicuyaptinmi waquin runacunapis nogaman criyicayämunga. Tsaymi paycunapäpis gamman mañacamü, papällay. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gamman mañacü juc shongulla cawangantsicnö paycunapis tsay yarpaylla car juc shongulla cawayänanpämi. Yarpäyangancuna y rurayangancuna munangantsicnölla caycullätsun, cachamangayquita tantiyar waquin runacunapis criyicayämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gamwan noga juc shongulla cawangantsicnö paycunapis cuyanacur juc shongulla cawayänanpämi willacuyniquita yachatsirgö. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Noga gamwan juc shongulla cawangantsicnömi paycunawanpis cawayargö. Tsaynö cawayanganta ricarmi cachamangayquita tantiyarnin waquin runacunapis criyicayämunga. Tsaynöpam tantiyacuyanga nogata cuyamangayquinölla paycunatapis cuyangayquita”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nircur, papällay, llapan criyicamog cagcunapis ciëluchö nogawan cayänantam munä. Ciëluchö carnam ricayämanga pasaypa chipipirrä munayyog rasunpa cangäta. Tsaynöga cargänam cay patsata manarä camashgapis. Tsaynö munayyog caycagta ricayämänantam munä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","26","“Papällay Tayta Dios, gam imata munangayquitapis runacuna manam tantiyayantsu. Nogam itsanga musyä gampita shamushga car. Criyicamogcuna tantiyayänanpämi paycunata yachatsirgö. Wanungäpita cawarcamur mastapis yachatsishämi. Tsaynöpam nogata cuyamangayquinö paycunapis cuyanacuyanga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tsaynö Tayta Diosman mañacusquirnam discïpuluncunawan Jesus yargur aywacuyargan “Cedron” ningan ragrapa wac-tsimpanman. Tsaychömi olïvu jachacuna cayangan huertaman yaycuyargan discïpuluncunawan. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tsaychö imaypis goricäcuyänan captin Jesusta ranticog Judas Iscariotipis musyarganmi tsaychöna caycäyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tsaymannam Judas chärirgan sacerdöticuna y fariseucuna mandangan wardiyacunata y juc tröpa Roma soldäducunata pushashga. Paycunaga chäcuriyargan actsincunawan, tucruncunawan, y espädancunawanmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesusga musyargannam ima päsananpä cagtapis. Tsaynö musyaycarmi puntataga tapurirganrä: “¿Pitatä gamcuna ashiycäyanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Paycunanam niyargan: “Nazaret marcapita Jesustam ashiyä”. Niyaptin Jesusnam nirgan: “Payga nogam cä”. Jesus tsaynö niycuptinnam llapancuna mantsariywan gepapa ishquiscäriyargan. (Läduncunachömi caycargan ranticognin Judas Iscariotipis.) ");
INSERT INTO qxoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tsaynam yapay Jesus tapurgan: “¿Pitatä ashiycäyanqui?” nir. Niptinnam yapay niyargan: “Jesus Nazaret runatam ari”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Niyaptinnam Jesus nirgan: “Willargönam noga cangäta. Nogata ashiyämarga nogallata apayämay. Discïpulücunata itsanga aywacuyänanpä dejaycuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tsaynö “Dejaycuyay” niycuptinmi camacargan puntata Tayta Diosman mañacur caynö ningan: “Discïpulücunataga shumagmi ricargö nogawan puriyanganpita mayganpis mana witicuyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tsaynam Simon Pedro espädanta jipisquir juc runapa derëcha cag rinrinta rogusquirgan jipicagpä. (Tsay rinrin rogucag runaga cargan mandacog sacerdötipa sirvegnin Malcu jutiyogmi.) ");
INSERT INTO qxoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tsaynö ruraptinmi Pedruta Jesus nirgan: “¡Espädayquita cutitsiy canganman! Wanunäpä papänï munaptinga listum caycä wanunäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tsaypitanam soldäducuna mandagnincunawan, y Israel autoridäcuna Jesusta maquipita matawarcur prësu apacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nircurnam chätsiyargan Anaspa wayinman. Anasga cargan sacerdöticunapa mandagnin cag Caifaspa suegrunmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Caifasga puntatanam autoridäcunawan willanacushga cargan: “Tsay runalla wanutsun llapantsic wanunantsicpa rantin” nir.) ");
INSERT INTO qxoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesusta apacuyaptinnam Simon Pedro y juc mas discïpulu gatiräyargan. Tsay jucag discïpuloga mandag sacerdötiwan reginacushga carmi ruri patiuman Jesusta yaycatsiyangan örallana yaycurirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroga wagta puncullachömi quëdacurgan. Tsay jucag discïpuloga mandag sacerdötipita regishga carmi puncuchö cuïdacog warmita rugacurgan Pedrutapis ruriman päsatsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedro yaycuraycaptinnam tsay puncu quichapäcog warmi nirgan: “¿Gampis tagay runapa discïpulunmer canqui?” Niptinnam Pedro nirgan: “Nogaga manam discïpuluntsu cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tsaychö pasaypa alaptinmi ninachö empliyäducuna y wardiyacuna mashacuycäyargan. Y Pedrupis paycunawanmi mashacuycargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tsaynam Jesusta Anas tapupargan: “¿Picunatä discïpuluyquicuna cayan? ¿Imatatä yachatsicunqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","Jesusnam nirgan: “¿Imanirtä tsaynö nogata tapumanqui? Nogaga manam pacayllapaga imatapis yachatsicurgötsu. Goricäcuyänan wayicunachö y templuchömi imaypis yachatsicurgö. Yachatsicungäta wiyagcunam musyayan imata yachatsicungätapis. Paycunata tapupayga”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tsaynö niptinmi juc wardiya Jesusta cäranchö lagyaycurgan caynö nirnin: “¿Imanirtä tsaynö contestanqui mandacog sacerdötita?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tsaynam Jesus nirgan: “¿Imaningätä mana alli caycushga? Si mana allita parlashga captëga nimay. Y llutanta mana parlaycaptëga ¿imanirtä lagyamanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tsaypitanam jina maquipita matawashgallata Jesusta Anas apatsirgan mashan Caifasman. Payga cargan sacerdöticunapa mas mandagnin cagnam. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tsayyagpis Simon Pedroga jinallam nina lädunchö mashacuycargan. Tsaynam waquin runacuna niyargan: “¿Gampis manacu tagay runapa discïpulun canqui?” nir. Tsaynö niyaptin Pedrunam nirgan: “Nogaga ari manam discïpuluntsu cä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tsaypitapis yapaymi Pedruta nirgan mandag sacerdötipa juc sirvegnin runa: “Gamtaga paywan caycagtam ricargä olïvu jachacuna cagchö” nir. (Tsay tapog runaga cargan rinrin rogucashga Malcupa castanmi.) ");
INSERT INTO qxoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro yapay “Manam regïtsu” nicaptinnam gällu cantasquirgan Jesus ningannölla. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tsaypita patsa waraycaptinnam Caifaspa wayinpita Jesusta Israel autoridäcuna apapäyargan Pilatupa despächunman. Payga Roma nacionpita mandacogmi cargan. Tsayman chascatsirninnam Pilatupa despächunmanga yaycuyargantsu. Mana Israel runacunapa wayinman yaycurga leynincuna ningannö manam Pascua fiesta micuyta micuyanmantsu cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsaynam despächunpita Pilato yargascamur tapurgan: “¿Ima mana alli ruranganpitatä cay runata apayämurguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Niptin paycunanam imaniytapis mana puëdir niyargan: “Jutsata mana rurashga captinga manam gamman apayämümantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tsaynam Pilato nirgan: “Noga juzganäta munarga willayämay ima jutsan cangantapis. Managa, mä payta apacuyay gamcuna leyniquicunamannö imanöpis juzgacuyänayquipä”. Tsaynö niptinmi paycuna niyargan: “Musyangayquinöpis nogacunataga manam leynïcuna conviëniyämantsu pitapis wanutsiyänäpä. Gammi Romapita autoridä car munayyog canqui juzgarcur payta wanutsinayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Roma autoridäcunaga jutsayogcunata imaypis cruzchörämi wanutsiyag. Tsaynöpam cumplirgan Jesus “Nogata cruzchömi wanutsiyämanga” ningan.) ");
INSERT INTO qxoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tsaynam despächunman Pilato yaycusquir Jesusta gayarirnin tapurgan: “¿Rasunpacu Israel runacunapa reynin gam canqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusnam nirgan: “¿Quiquillayquipitacu tsaynö tapumanqui, o Israel autoridäcuna nogapä niyäshuptiquicu?” ");
INSERT INTO qxoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Niptin Pilatunam nirgan: “¡Acäsu noga Israel runacu cä tsaycunata musyanäpäga! Gampa marca mayiquicunam y sacerdöticunapa mandagnincunam nogaman apayämushurguyqui. ¿Ima mana allitatä rurarguyqui cayman apayämushunayquipä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tsaynam Jesus nirgan: “Manam imatapis mana allita rurargötsu. Cayman autoridäcunam apayämashga mandacog tucungäta yarparnin. Nogaga manam cay patsachö runacunapa mandacognintsu cä. Cay patsachö mandacog captëga gatirämagcunam pelyayanman cargan nogata prësu mana apayämänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tsaynö niptinmi Pilato nirgan: “Tsayöraga mandacogchi canqui”. Niptin Jesusnam nirgan: “Aumi, gam ningayquinöllam mandacog cä. Tsaymi cay patsaman shamurgö Tayta Diospa willacuyninta yachatsicunäpä. Diospa willacuyninta yachacuyta munag cagcunaga ningäcunata chasquicuyanmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tsaynam Pilato nirgan: “¿Pitä musyanman Diospa willacuynintaga?” Jesusta tapurirnam Israel autoridäcuna caycäyanganman yargusquir Pilato nirgan: “Noga manam tarïtsu cay runapa ima jutsantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gamcunaga musyayanquinam cay Pascua fiestachö cada wata juc prësuta cachanäpä cagta. ¿Israel runacuna reyniquicunata cacharinätacu munayanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsaynö niptinnam llapancuna gayaraypa niyargan: “¡Apayämungä Jesustaga ama cachaytsu! ¡Barrabasta cachasquiyga!” nir. (Tsay Barrabasga cargan Roma nacionpa contran runa wanutsegmi.) ");
INSERT INTO qxoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tsaynö niyaptinnam soldäducunata Pilato mandargan Jesusta astayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldäducunanam cashapita corönata rurasquir Jesuspa umanman jatipäyargan. Nircurnam reypa granäti mantuntanö agshutsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ñöpanman witi-witiycurmi cäranchö lagyar burlacurnin niyargan: “¡Ricayay Israel runacunapa reyninta!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tsaypitanam despächunpita yapay yargurir Pilato nirgan: “Nogaga manam tarïtsu cay runachö ima jutsatapis. Tsaymi payta cayman jipimushä imanö cangantapis ricayänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tsaynö nirmi wagtaman Jesusta jipiramurgan cashapita coronashgata y granäti mantun agshucushgata. Tsaynam Pilato nirgan: “Ricayay cay apayämungayqui runata” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tsaynö Jesusta ricaratsiptinnam sacerdöticunapa mandagnincunawan wardiyacuna gayaraypa niyargan: “¡Cruzchö wanutsun! ¡Cruzchö wanutsun!” Tsaynö nir gayaräyaptinmi Pilato nirgan: “¡Peru cay runa ima jutsatatä rurashga wanunanpäga! Mä tsayöraga gamcunana aparnin cruzchöpis wanutsicuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tsaynö niptinnam Israel autoridäcuna niyargan: “Musyangayquinöpis nogacunallaga manam munayyogtsu cayä pitapis wanutsiyänäpäga. Nogacunapa leynïcunachöga nican ‘Diospa tsurinmi cä’ neg cag runaga wanunanpämi. Tsaymi gamman payta apayämurgö, munayyog carnin wanunanpä niptiqui soldäduyquicuna wanutsiyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Diospa tsurin tucunganta niyaptinga Pilato feyupam mantsarirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tsaynam despächunman cutiycatsir Jesusta yapay tapurgan: “¿Gam maypitatä canqui?” nir. Tsaynö niptin Jesusga manam imatapis contestargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tsaynam Pilato nirgan: “Tapuycaptëga ¿imanirtä mana contestamanquitsu? ¿Gam manacu musyanqui noga munayyog cangäta? Noga munaptïmi cruzchöpis wanutsiyäshunqui o cachariyäshunquipis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tsaynö niptinnam Jesus nirgan: “Autoridä caytaga Tayta Diosmi goshurguyqui. Mana tsayga manam puëdinquimantsu wanutsimayta ni cacharamayta. Tsaymi maquiquiman apamag cagcuna gampita mas jutsayog caycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tsaynö niycuptinnam Pilatoga cachariyta munargan Jesusta. Peru Israel autoridäcuna cacharinanta mana munarmi masrä runacunawan gayaräyargan caynö nir: “¡Mandacog rey tucurmi tsay runaga Romapita mandacamog emperadorpa contran caycan! ¡Tsaymi payta cacharga gampis tsay munayyog emperadorpa contran canqui!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tsaynö nisquiyaptinnam itsanga Pilato wagtaman jipitsimurgan Jesusta. Cruzchö wanutsiyänanpä o cachariyänanpä cagta nimunanpämi “Gabata” ninganman aywaycur jamaycurgan. (Hebreu parlaychöga tsay Gabata ninanga “empiedrashga patsa” ninanmi.) ");
INSERT INTO qxoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tsayman jamaycurnam Israel runacunata Pilato nirgan: “Gamcunapa mandacogniquicunata ricayay”. (Tsayga cargan Pascua fiesta säbadu jamapay junagpä pullan junagllana faltaycaptinmi.) ");
INSERT INTO qxoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tsaynam runacuna pasaypa gayaräyargan: “¡Wanutsun! ¡Wanutsun! ¡Cruzchö wanutsun!” nir. Tsaymi Pilato nirgan: “¿Imanirtä mandacogniquicunata cruzchö wanutsishä?” nir. Tsaynam sacerdöticunapa mandagnincuna niyargan: “Nogacunapa mandacognïcunaga Romapita emperadorllam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tsaynö niyaptinnam Pilato Jesusta paycunapa maquincunaman entregaycurgan cruzchö wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tsaypitanam Jesusta apacuyargan cruzta umrurcatsir “Calavëra” ningan jircaman. (Tsay Calavëra ningan sitiupaga jutin “Golgota” hebreu parlaychöga.) ");
INSERT INTO qxoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tsayman chaycatsirnam cruzman Jesusta soldäducuna clavayargan. Paytawanmi ishcay runacunatapis crucificayargan, jucagta jucag lädunman, jucagtana jucag lädunman. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tsaypitanam Pilato juc letrëruta rurarcatsir apatsirgan cruzpa puntanman clavayänanpä. Tsay letrëruchömi caynö gellgarargan: “JESUS NAZARET MARCAPITA, ISRAEL RUNACUNAPA REYNIN” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hebreu, latin, y griegu parlaycunachömi tsaynö gellgarargan. Jesus clavaraycangan sitiu Jerusalen marcapita cercalla captin Israel runacunaga atscagmi liyiyargan tsay letrëruta. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tsaymi sacerdöticunapa mandagnincuna Pilatuta niyargan: “‘Israel runacunapa reynincunam’ nirga ama gellgarätsuntsu, sinöga ‘Israel runacunapa reynin tucogmi’ nir gellgarätsunga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tsaynö niyaptinnam Pilato nirgan: “Gellgarangannöllana catsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesusta cruzman clavapacusquirnam röpanta gorisquir chuscun soldäducuna aypunacuyargan. Rurinchö cag jatirangan tünicantam itsanga, costüraynag shumag captin, caynö ninacur sortiyayargan: ");
INSERT INTO qxoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Ama caytaga rachishuntsu. Sortiyasquishun. Mä maygantsictashi töcamäshun” nir. Tsaynöpam cumplirgan Diospa palabran gellgaranganchö Jesuspä: “Quiquincuna puram aypunacuyanga röpäta y sortiyayangam tünicätapis” ningan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus clavaraycangan cruz chaquinchömi caycäyargan Jesuspa maman, mamanpa ñañan, Cleofaspa warmin Maria, y Maria Magdalena. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tsaynam tsay mas cuyangan cag discïpulun mamanwan shaycäyagta ricaycamur Jesus nirgan: “Mamïta, nogapa rantëga Juannam wawayqui canga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nircurnam tsay discïpuluntapis nirgan: “Juan, cananpitaga gamnam mamalläta ricaycunqui mamayquitanö”. Tsaynö ninganpitam tsay junagpitaga Jesuspa mamanta Juan apacurgan wayinman quiquinpa mamantanö ricänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wanusquinanpä ricognam Diospa palabran gellgaraycangan cumplisquinanpä Jesus nirgan: “Yacunämi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tsaychömi soldäducunapa upucuyänan ayag vïnuncuna caycargan. Tsaymi juc soldädu tsay vïnuta esöpuman ushmascatsir gerupa puntanman watarcur Jesuspa shiminman churaparcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tsay vïnuta yawarcurnam Jesus nirgan: “Cananga llapantanam cumplirgö”. Nisquillarnam wanusquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua fiesta säbadu jamapay junag gallaycunanpäna captinmi Israel runacunapa autoridänincuna munayargantsu wanushgacuna cruzchö jinalla clavaränanta. Tsaymi Pilatuman aywaycurnin rugacuyargan cruzchö clavaraycag runacunapa chancancunata paquiscärir cruzpita ayancunata jipitsinanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsaymi soldäducuna aywaycurnin ishcay clavaraycag ladroncunapa chancancunata paquiscäriyargan ras wanuriyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusta wanushgatana tarirmi chancanta manana paquiyargannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wanushgana caycaptinpis Jesuspa llapsha pachantam itsanga lanzawan juc soldädu tucsiycurganrä. Tsaynö tucsiptin yawarwan yacum yargascamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Noga Jesuspa apostolnin Juanmi tsaycunata ricargä. Tsaymi imanö cangantapis gellgaycä Tayta Dios cachamungan salvacog pay canganta gamcunapis criyiyänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Llapan tsaycuna päsargan Diospa palabran gellgaraycangan cumplinanpämi: “Manam ni juc tullullantapis paquiyangatsu” ");
INSERT INTO qxoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","y “Runacuna ricayangam llapsha pachanta tucsiyangantapis” ningan. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tsaypitanam Arimatea marcapita Jose jutiyog runa Pilatuman aywar rugargan Jesuspa ayanta pampananpä. Autoridäcunata mantsacurninmi payga Jesuspa discïpulun canganta willacurgantsu. Pilato “Apaylla” niptinnam Jose cutiycur Jesuspa ayanta apacurgan pampaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tsaynömi Nicodemupis aywargan quimsa arröbanö perjümita apacurcur. Tsay perjümi rurashga cargan “mirra” y “aloe” ningan jachacunapitam. (Mas puntatapis Nicodemoga tsacayllapa aywarganmi Jesuswan parlananpä.) ");
INSERT INTO qxoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Israel runacunapa üsuncunamanmi Josewan Nicodemo tsay perjümita säbanasman jichayargan. Jichaycurnam Jesuspa ayanta wancuyargan pampayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta wanutsiyangan lädunchömi cargan juc prüta huerta. Tsay huertachömi cargan manarä pipis pamparangan mushog sepultüra. ");
INSERT INTO qxoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pascua fiesta säbadu jamapay junag gallaycunanpäna captinmi cercalla sepultüra captin tsayllamanna Jesuspa ayanta pampaycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dominguman warämogga Maria Magdalena tsaca tsacallanam aywargan Jesus pamparaycanganman. Chärirnam tarisquirgan sepultüra tsaparag rumi wititsishga caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsaynöta ricaycurnam cörrillapa cutir Pedrutawan tsay cuyay cag discïpulunta willargan: “¡Sepultürapitaga Jesuspa ayanta apacuyashgam! Manam musyaytsu maypa apacuyanganpis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tsaynö niptinnam Pedro y jucag discïpulu cörrillapa aywacuyargan Jesus pamparangan cagman. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jucnin cagga Pedrupita mas cörrirmi puntata chasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tsaynam puncullapita gawaycurnin ricargan säbanasta Jesus wancurangantanölla. Manam rurimanga yaycurgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Pedrunam gepanta chasquir ruri sepultürayag yaycusquirgan. Paypis taririrgan säbanasllatam tsaychö caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesuspa uman watarag ratashtapis juc läduchömi doblashga churaraycagta tarirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsaypitarämi puntata chag cag cuyay discïpulunpis ruriman yaycusquir criyirirgan Jesus cawamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tsaynö caycaptinpis manam tantiyayarganrätsu Diospa palabranchö cawamunanpä cag gellgarangantaga. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsaypitanam ishcan discïpuluncuna cuticuyargan patsacur goriräyangan wayiman. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Maria Magdalenaga sepultüraman cutiycurmi wagar quëdacurgan. Tsaynö wagaycanganta mas ruriman gawaycurmi ricasquirgan ishcay angelcuna yurag röpashga caycagta. Jucag angelmi jamaraycargan Jesuspa uman cangan cagchö y jucagnam chaquin cangan cagchö. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tsay angelcunanam Mariata tapuyargan: “¿Imanirtä waganqui?” nir. Tsaynö niyaptinnam Maria nirgan: “Jesuspa ayantam apacuyashga, taytay. Manam musyätsu maypa apacuyangantapis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tsaynö nisquirnam gepapa ticranganchö ricasquirgan Jesus tsaychö shaycagta. Itsanga manam tantiyargantsu pay cangantaga. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tsaymi Jesus tapurgan: “Warmi, ¿imanirtä waganqui? ¿Pitatä ashiycanqui?” nir. Tsaychö huerta täpag runa canganta yarparmi Maria nirgan: “Señor, ayalläcunata mayman apashga carpis willaycamay noga goricamunäpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tsaynam Jesus “¡Maria!” niycurgan. Niycuptinnam Jesus canganta tantiyacusquir “¡Taytallä Jesus!” nirgan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aywacunanpä canganta yarparmi maquipita Jesusta tsarirgan. Tsaynam Jesus nirgan: “Ama tsarimaytsu. Manarämi papänï cagman aywacürätsu. Antis jinallachö aywar discïpulücunata willay: ‘Caynömi nimashga nir: “Papänï cagman aywacushänam. Payga gamcunapapis papäniquicunam y Diosniquicunam” ’ nirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tsaynö niptinnam Maria Magdalena juclla discïpuluncunaman aywar nirgan: “¡Nogaga Jesuswanmi tincusquirgö!” Tsaynö nisquirnam willargan Jesus ningancunata. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jesus cawarimungan domingu tsacaynam discïpuluncuna wayi rurinchö goricashga caycäyargan. Israel autoridänincunata mantsacurninmi puncuta cösa trancapacuyargan. Tsaymannam wap Jesus chöpincunaman resultasquir nirgan: “¡Gamcunachö alli cawacuy caycullätsun!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tsaynö nisquirninnam ricatsicurgan maquinta y llapsha pachanchö tucsiyanganta. Señor Jesus rasunpa cawarimungantam ricaycurnin discïpuluncuna pasaypa cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tsaypitanam Jesus yapay nirgan: “¡Gamcunachö alli cawacuy caycullätsun! Papänï nogata cachamangannöllam gamcunatapis canan noga cachä pay munanganta rurar willacuyninta willacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tsaynö nisquirninnam discïpuluncunata pücapascärir nirgan: “Espiritu Santuta chasquiyay. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Espiritu Santupa munayninwan carnam niyanqui nogaman criyicamog cagcuna jutsancunapita perdonashga cayanganta y mana criyicamogcuna mana perdonashga cayanganta”. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Discïpuluncunata Jesus yuripangan öraga “Millïshu” niyangan Tomas manam tsaychötsu cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tsaypita Tomaswan discïpuluncuna tincusquirnam willayargan: “Señornintsic Jesustam ricayargö” nir. Tsaynam Tomas nirgan: “Maquinta clävu uchcunganta mana ricarga, tsayman dëdüta mana jatirga, y llapsha pachan tucsishgata mana yatarga, manam criyïtsu rasunpa cawarimunganta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tsaypita juc semänatanam discïpuluncuna yapay tsay wayichö goricashga caycäyargan. Y Tomaspis tsaychönam caycargan. Puncuta trancacurcur caycäyaptinmi wap chöpincunaman Jesus yapay yurisquir nirgan: “¡Gamcunachö alli cawacuy caycullätsun!” ");
INSERT INTO qxoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nircurnam Tomasta nirgan: “Tomas, maquïta ricay y clävu uchcunganman dëduyquita jatiy. Cay llapsha pachäta tucsiyämangantapis yatay. ¿Imanirtä cawamungäta criyinquitsu? Cananpita nogaman criyicamuy”. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tsaynö niptinnam cushicurnin Tomas nirgan: “¡Gamga Diosllämi canqui, taytallay!” ");
INSERT INTO qxoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusnam nirgan: “Tomas, canan ricaycamarräcu criyinqui cawamungäta. Mana ricaycämar nogaman criyicamogcuna cushicuyätsun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Atsca milagrucunatam Jesus rurargan discïpuluncunapa ñöpanchö. Tsaycunaga manam llapantsu cay libruchö gellgaraycan. ");
INSERT INTO qxoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Caycunatam itsanga noga gellgargö Jesus salvamagnintsic canganta y Tayta Diospa tsurin canganta criyiyänayquipä. Payman yäracurninga imayyagpis Tayta Dioswanmi cawayanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsaypitanam Jesus yapay discïpuluncunata yuripargan Galilea gocha cuchunchö. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tsaychö caycäyargan Simon Pedro, “Millïshu” niyangan Tomas, y Natanaelpis. Natanaelga cargan Galilea provinciachö “Cana” ningan marcapitam. Zebedeupa ishcay tsurincuna y mas ishcay discïpulu mayincunapis tsaychömi caycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tsaynam Pedro nirgan: “Nogaga canan pescagmi aywä”. Tsaynö niptinnam waquincuna niyargan: “Acu, nogacunawanpis yanapayänäpä aywashun” nir. Nircurnam büquiman yarcurcur gochaman jegaycuyargan. Tsaynö captinpis manam tsay pagasga ni juc pescädullatapis tsariyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Patsa waranaycaptinnam Jesus gocha cuchunman yuripasquirgan. Tsaychö ricarpis Jesus canganta discïpuluncuna manam tantiyayargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tsaymi Jesus gayaycur nirgan: “¡Amïgucuna! ¿Naganacu pescäduta tsariyanqui?” nir. Paycunanam niyargan: “Manam ni jucllayllatapis tsariyärätsu”. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tsaynam Jesus nirgan: “Büquipa derëcha cag lädunman masqui mällata mashtayay. Tsaychömi pescäduta tsaricuycuyanquega” nir. Ningannölla mällata mashtaycurga manam yacupita jipiytapis puëdiycuyargantsu pasaypa pescäduyog captin. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tsaynam Pedruta tsay cuyay cag discïpulun nirgan: “¡Tagayga Señornintsic Jesuschä!” nir. Tsayta wiyaycurnam Pedro pescananpä llogticungan röpanta jaticurcur nädar gallaycurgan Jesus cagman yargamur. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquincunanam büquillachö aywayargan mällata pescäduntinta garachashga. Gochapita manam alläpa carunatsu cargan cuchunman chäyänanpä. Juc pachac (100) metrunöllanam cargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tsaypita gocha cuchunman chasquirnam mällata jagiycur büquipita yarguyargan. Tsaychömi tarisquiyargan tantata y nina shanshachö cancashga pescädu churaraycagta. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tsaynam Jesus nirgan: “Tsariyämungayqui pescäducunapita juc ishcayta apayämuy cancapacurinapä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pedrunam büquiman yarcurcur mällata wagtaman garachargan pescäducunata jipinanpä. Tsay mällachöga cargan juc pachac pitsga chunca quimsa (153) pescäducunam. Tsaytsica pescädu caycaptinpis mällaga manam rachirgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tsaynam Jesus nirgan: “Shayämuy micunantsicpä” nir. Paycunaga Jesus canganta musyarmi ni mayganpis tapuyargantsu pï cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus witiycurninnam tantata pescäduntinta paycunata garargan. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Galilea gocha cuchunchö tincuyanganwanga quimsa cutinam cawarimunganpita Jesus yuripargan discïpuluncunata. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tsaypita micur ushasquiyaptinnam Pedruta Jesus tapurgan: “Jonaspa tsurin Simon, ¿waquin cag discïpulücunapita mascu gam cuyamanqui?” nir. Tsaynö niptinnam Pedro nirgan: “Aumi, taytay. Musyanquim noga cuyangäta”. Jesusnam nirgan: “Tsayöraga nogaman criyicamogcunata shumag ricanqui”. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nircurnam yapay Pedruta Jesus tapurgan: “Jonaspa tsurin Simon, ¿gam cuyamanquicu?” nir. Tsaynam Pedro nirgan: “Aumi, taytay. Gam musyanquim cuyangäta”. Niptinmi nirgan: “Tsayöraga nogaman yäracamogcunata shumag ricanqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tsaypitapis yapaymi Jesus tapurgan: “Jonaspa tsurin Simon, ¿gam cuyamanquicu?” nir. Tsaynö quimsa cutina “Cuyamanquicu” nirnin Jesus tapuptinnam Pedro wamayacurcur nirgan: “Taytay, gamga llapantachä musyanqui, y gamta cuyangätapis musyanquichä” nir. Niptinnam Jesus nirgan: “Tsayöraga nogaman yäracamogcunata shumag ricanqui. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jövinllarä carga röpayquicunata gustuyquimanmi jaticurgayqui munangayquipa maypapis aywanayquipä. Rucuyayniquichönam itsanga ricrayquita quichaycuyäshur juccunarä jatipäyäshunqui. Nircurnam mana munangayquicunapapis apayäshunqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","“Gampatapis ricrayquita quichariyangam” nirmi Jesus tantiyatsirgan payman yäracunganpita Pedrupis cruzchö wanunanpä cagta. Nircurnam Jesus Pedruta nirgan: “Willacuynïta willacur sïginqui noganö wanuyman charpis”. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tsaypita Pedro ticraycurnam ricasquirgan tsay cuyay cag discïpulu Jesuspa gepanta aywaycagta. (Tsay cuyay discïpuloga manarä Jesus wanuptinmi lädunchö micuycangan öra tapurgan maygan ranticunanpä cangantapis.) ");
INSERT INTO qxoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tsaynam discïpulu mayinta Pedro ricasquir Jesusta tapurgan: “Taytay, Juantaga ¿imatä päsanga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tsaynö tapuptinnam Jesus nirgan: “¿Imanirtä paypä tapumanqui? Cay patsaman cutimungäyag pay cawananta munaptïpis gamga llapantapis ningäcunallata ruray”. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tsaynö niptin waquin runacunaga yarpäyargan imaypis manana wanunanpä cagtam. Tsaynö yarpäyaptinpis “Juanga cutimungäyagmi cawanga” nirgantsu manam, sinöga “Pay cawananta munaptïpis gamga ningäcunallata ruray” nirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Noga Juan, Jesuspa discïpulun carmi llapanta ricashga carnin cay libruta gellgargö. Llapan gellgangäcunaga rasun cagllam. ");
INSERT INTO qxoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Cay gellgangäcunapitaga mascunatam Jesus rurargan. Llapan rurangancunata gellgarga manam imaypis ushämantsu cargan. Tsaynö catsun.");
INSERT INTO qxoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Jesucristo cay patsachö llapan rurangancunatam y yachatsingancunatam punta cag librüchö gellgamurgä. Tsayta gellgamurgä gampis musyanayquipämi, don Teofilo. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Jesucristum wanunganpita cawarircamur ciëluman manarä cuticur apostolnincunata chuscu chunca (40) junagyag atsca cuti yuripargan. Rasunpaypa cawamunganta musyayänanpämi imaycanöpa paycunata tantiyatsirgan. Tayta Diospa munayninchöna cawayänanpä cagta yätsirirmi Espiritu Santo munangannö nirgan willacuyninta willacur puriyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Señor Jesus apostolnincunawan caycarninmi paycunata yätsir nirgan: “Puntata willangänömi Tayta Dios auniyäshurgayqui gamcunaman Espiritu Santuta cachamunanpä. Tsaymi Jerusalenpita amarä aywacuyanquirätsu Espiritu Santuta chasquicuyangayquiyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ñöpata Juan Bautistaga yacullawanmi runacunata bautizargan. Cananmi itsanga ningänölla Tayta Dios gamcunata Espiritu Santuwan bautizayäshunqui caypita juc ishcay junagcunallatana”. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tsaypita juc cutichönam goriraycäyanganta apostolnincuna Jesucristuta tapuyargan: “Taytay, ¿canantsurä cay Israel nacionpita tsay mandacog Roma runacunata gargunqui, paycunapa munayninchö cayangäpita gampa munayniquichöna cayänäpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tsaynö tapuyaptinmi Jesus nirgan: “¿Imapätä musyayta munayanqui tsaytarä? Imay junag imay öra tsay päsananpä cagtaga Tayta Diosllam musyaycan. Payllam munayyog tsaycunata rurananpäga. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Imanö captinpis gamcunata conviëniyäshunqui, Espiritu Santuta chasquirir poderyogna ticrayänayquipä cagmi. Nircurmi noga yachatsingäcunata y ricayangayquicunata willacuyänayqui Jerusalenchö, Judea provinciachö, Samaria provinciachö, y maytsay marcacunamanpis chätsirnin”. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tsaynö parlayta ushasquirmi Tayta Diospa poderninwan ciëluman Jesus aywacurgan. Apostolnincuna ricaraycäyaptinmi pucutay rurinman yaycur illacasquirgan. Tsaypitaga mananam ricayargannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Imanö aywangantapis ricaraycäyaptinmi ishcay yullag püru röpashga runacuna ñöpancunaman yuripasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tsay runacunam niyargan: “Galilea runacuna, ¿imanirtä ciëluman ricaraycäyanqui? Ñöpayquicunapita Jesucristo ciëluman aywacunganta ricayangayquinöllam cay patsaman cutimunga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tsaypitanam Olivos jircanchö caycäyanganpita Jesucristupa apostolnincuna cuticuyargan Jerusalenman. Tsay jircanpita Jerusalenman cargan pullan öra aywaynöllam. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chaycurnam patsaräyangan wayipa altusninman yarcuyargan. Paycunam cayargan Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Alfeupa tsurin Santiago, Simon “Celote” ningan, y Santiagupa waugin Judas. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tsay wayichö goricaycurmi paycuna Tayta Diosta juc shongulla mañacuyag imaypis. Paycunawanmi goricäyag Jesucristupa maman Maria, Jesucristupa waugincuna, y waquin warmicunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tsay junagcunam Jesucristuman criyicogcuna pachac ishcay chuncanö (120) goricäyargan apostolcunawan. Tsaychönam Pedro nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","19","“Waugicuna panicuna, musyangantsicnöpis Judas Iscariote nogacunawanmi purirgan. Paytapis nogacunanölla apostol cananpämi Señornintsic Jesucristo acrargan. Tsaynö caycarpis Judasga Señornintsicta ranticurirmi runacunata apapargan prësu tsariyänanpä. Nircurnam tsay ranticungan gellëwanna chacrata rantirgan. Tsay chacrachömi uray sengaypa jegargan pachan pashtagpä. Tsaynö pachan pashtariptinnam agishnincunapis yargamurgan. Tsaypitam Jerusalen runacuna tsay chacrapa jutinta churayargan ‘Yawar Pampa’ nir. Jesucristuta ranticur Judas wanunanpä cagta musyarmi unay rey Davidta Espiritu Santo tantiyatsirgan Bibliachö juc Salmuta Judaspä cagtana gellgananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tsay Salmuchömi caynö gellgaraycan: ‘Tärangan wayinpis jagirishga catsun. Ama pipis tsaychö tärätsunnatsu’ nir. Tsaynöllam juc Salmuchöpis Judaspä caynö gellgaraycan: ‘Pay rurananpä cagta jucna ruratsun’ nir”. Nircurnam Pedro nirgan: “Tsay Salmuchö gellgarangannöllam Judasta päsashga. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Tsaynö captinmi juctana acrashwan Judaspa troquin apostol cananpä. Peru itsanga acrarga acrashun Jesus bautizacunganpita patsa ciëluman cuticunganyag pureg cagta. Jesucristuwan tsaynö puregcunaga caychö caycäyanmi. Tsaymi paycunapita maygantapis jucta churanantsic Judaspa troquin apostol cananpä. Paypis nogacunanö apostolna carmi Jesus cawamunganta willacur puringa”. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro tsaynö niptinmi ishcay runacunapä yarpäyargan. Jucmi cargan Jose. Jucagnam cargan Matias. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ishcancunapita mayganpis apostol cananpä cagta musyayänanpämi Tayta Diosta rugacur mañacuyargan caynö: “Taytay, gammi musyanqui llapan runacunapa shonguncuna imanö cangantapis. Tsaymi canan musyatsiyämänayquita munayä cay ishcay runacunapita mayganta acrangayquitapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mayganpis acrangayqui cagmi canga Judaspa troquin apostolniqui. Judasga jutsa rurayman ishquishga carmi apostolniqui caycanganta jagirishga. Tsaypitam wanur infiernuman gaycucashga” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tayta Diosta tsaynö mañacusquirnam suertita ricayargan. Tsaymi suerti yargamurgan Matiaspä. Tsay junagpitanam Matiaspis Jesucristupa apostolninna cargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tsaypita “Pentecostes” ningan fiesta junagnam Jesucristuman llapan criyicog cagcuna juc wayillaman goricäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tsaychö goriraycäyangantam mayasquiyargan shucucuy vientunörä pasaypa gayarar ciëlupita shamogta. Tsay vientoga chargan goricäcuyänan wayimanmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsaynam tsay wayichö goriraycagcuna ricayargan rachicar rachicar ninacunanö janancunaman unyagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tsay örapitanam itsanga Espiritu Santuyogna llapancuna ticrasquiyargan. Nircurnam paycuna parlar gallaycuyargan mana parlacuyangan imaycaläya parlaycunata. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tsay witsanmi maytsay nacioncunapitapis Israel runacuna Jerusalenman chäyargan Pentecostes fiesta päsag. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tsaymi tsay wayichö shucucuy vientunö gayaranganta wiyarnin runacuna aywayargan ricayänanpä. Tsaychömi tsay goriraycag runacuna wiyayargan Espiritu Santuyogcuna juc nacioncunapa imaycaläya parlacuynincunata parlaycäyagta. Tsaynö parlayanganta wiyarmi espantacur cushicuyargan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","“Cay llapan parlaycagcunaga ¿manacu Galilea runacuna cayan? ¡Galilea runacuna caycar nogantsicpa parlacuynintsiccunatapis parlaycäyanchä! ");
INSERT INTO qxoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Imanöpatäshi paycuna yachacuycuyashga nogantsic parlangantsicnö parlayänanpäga? ");
INSERT INTO qxoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Shamurguntsic maytsay marcacunapitachä. Partiapita, Mediapita, Elampita, Mesopotamiapita, Judeapita, Capadociapita, Pontupita, Asiapita, ");
INSERT INTO qxoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptupita, Libiachö cag Cirene quinran marcacunapita, y Romapitapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Waquinnintsicga yuringantsicpita patsam Israel runacuna cantsic. Y waquinnintsicnam mana Israel runacuna caycarpis Diosta chasquirgantsic Israel runanö canantsicpä. Cretapitapis, Arabiapitapis caychö goricashgam caycantsic. Maytsaypita cashgapis quiquintsicpa parlacuynintsicchömi parlapaycämantsic Diosnintsic nogantsicpä imaycatapis rurangancunata”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tsaymi pasaypa espantacur quiquin pura tapunacuyargan: “¿Imaninantä cayga?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Peru waquincunam itsanga burlarcurnin niyargan: “Cay runacunaga shincashgachä ëllu caycäyan. Tsaychä imata parlayangantapis musyayantsu” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tsaynö niyaptinnam apostol mayincunawan sharcurcur Pedro parlapar caynö nirgan: “Jerusalenchö y maytsaychöpis tärag Israel mayicuna, cay nimungäta shumag wiyayämay. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Manam gamcuna yarpäyangayquinötsu nogacuna shincashga caycäyä, ");
INSERT INTO qxoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","sinöga Tayta Dios ninganta willacognin unay profëta Joel Bibliachö gellgangannöllam canan rasunpaypa cumpliycan. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Paymi Tayta Dios ningancunata caynö gellgargan: ‘Espiritu Santuta cachamushä salvacogta chasquicog cagcunaman. Nogata chasquicamarga salvacuyänanpä cagtam willacuyanga ollgu tsuriquicuna y warmi tsuriquicunapis. Jövincunapis jipashcunapis noga ricatsingäcunatam ricayanga. Rucucunata chacwancunatapis suëñuncunachömi musyatsishä. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tsay witsan munangäta ruragcunamanmi Espiritu Santuta cachamushä. Tsaynöpam warmipis ollgupis ningäcunata willacunga. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ciëluchömi ricacätsimushä espantaypä mana ricayangayquicunata. Rupaymi atsicyanganatsu. Quillam yawarnö ticranga. Cay patsachö pasaypa wanutsinacuytam ricayanqui. Maytsaychöpis nina rupaptinmi cay patsa goshniwan chipyaypa tsapashga caycagta ricayanqui. Tsaycuna päsasquiptinran noga llapan runacunata juzganäpä chämushä. Tsay chämungä junagnöga imaypis mananam yapayga canganatsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pipis salvacogta rugacurnin payllaman yäracur mañacog cagga salvashgam canga’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Joel tsaynö gellganganta yarpäratsirnam Pedro mastapis nirgan: “Israel marca mayicuna, cay parlamungäcunata shumag wiyayämay. Musyayangayquinöpis Nazaret marcapitam Jesus cargan Tayta Dios acrangan runa. Tsaynö acrangan canganta musyanantsicpämi Tayta Dios poderninwan yanapargan imaycaläya milagrucunata rurananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tsaynö caycaptinpis gamcunam Jesusta prësu tsarisquir mana alli runacunapa maquinman entregayargayqui crucificaypa wanutsiyänanpä. Diospa palabranchö imaypis ningannöllam entregayargayqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lluta runalla carmi wanungallanchöga ushacäcunman cargan. Runacuna wanuycätsiyaptinpis Tayta Diosmi cawaritsimushga tsurin captin. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tsaynömi Jesucristupäga unay rey Davidpis caynöna gellgargan: ‘Imaypis nogawanmi caycanqui, taytay. Tsaymi imatapis noga mantsarïtsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Shongüpis cushicurmi atsicyan. Cushishgallam alabarniqui cantacurilläpis. Tsaymi gamman yäracullar cawaycällä. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Munangayquita ruraptïmi pamparangällachöga jagiramanquitsu. Tsaynölla manam munanquitsu ayä ismunantapis, sirvegniqui captï. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gammi musyatsillämanqui alli cawacuypä cagta. Tsaynöpam imayyagpis gampa ñöpayquichö cushishgalla cawacushä’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tsaynö David gellganganta willapayta ushasquirmi Pedro nirgan: “Israel mayicuna, tsaynö gellgar unay rey David manam quiquinpätsu gellgargan, sinöga Jesucristupämi. Musyantsicmi David wanur mayninchö pamparangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tayta Dios ninganta willacog profëtam rey Davidga cargan. Paytam Tayta Dios nirgan: ‘Gampa miragniquicunapitam juc runa yuringa imayyagpis rey cananpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tsaymi Davidga imayca ricaycagnöna tsay yurinanpä cagtana gellgargan. Y payga salvamagnintsic Jesucristum. Tsaynömi gellgargan paypa ayanpis pamparangallanchö mana quëdananpä cagta y mana ismunanpä canganta”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“David gellgangannöllam Jesucristuta Tayta Dios cawatsimushga. Tsaynö cawamungantaga llapämi ricayargä. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nircurnam Jesusta derëcha cag lädunman Tayta Dios jamatsishga llapan runacunapis paypa munayninchö cananpä. Tsaypitanam Tayta Dios auningan Espiritu Santuta nogacunaman cachamushga. Tsaynö cachamushga captinmi poderninwan imaycaläya parlaycunapa parlatsiyämanganta canan wiyaycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Shumag tantiyacuyay. Davidga manam Jesusnöga cuerpuntintsu wanunganpita cawarcamur ciëluman witsashga. Peru gellgarganmi itsanga Señornintsic Jesucristupä: ‘Tayta Diosmi salvacognïta nirgan: “Jamacuy derëcha cag lädüman noga poderösuwan iwal carnin chiquishogniquicunata munayniquiman churamungäyag” nir’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tsaypita yapaymi Pedro nirgan: “Israel marca mayicuna shumag tantiyacuyay llapayquicuna. Gamcuna Jesusta cruzchö wanutsishga caycäyaptiquipis Tayta Diosmi payta churashga paypa munayninchö canantsicpä y salvamänantsicpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tsaynö niptinmi runacuna feyupa llaquicurnin tapuyargan Pedruta y waquin apostolcunata: “Tsaynö captinga ¿imatatä rurayäman?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tsaynam Pedro nirgan: “Llapayquicuna jutsa rurayniquicunata jagirir Jesucristuman criyicur bautizacuyay. Tsaynö rurayaptiquim Tayta Dios jutsayquicunapita perdonayäshunqui. Y tsaynöpanam gamcunamanpis Espiritu Santuta cachamunga. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Espiritu Santutaga manam nogacunallapätsu Tayta Dios cachamushga, sinöga cachamushga gamcunapä, tsuriquicunapä, y maytsaychöpis llapan acrangan cagcunapämi”. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tsaypita mastapis Pedro tantiyatsirganmi: “¡Waquin runacuna jutsa rurayllachö cawayaptinpis gamcunaga ama tsaynö jutsallachöga cayaynatsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tsaynö Pedro ninganta chasquicogcunaga atscagmi tsay junag bautizacuyargan. Tsay bautizacogcunaga cayargan quimsa waranganömi (3,000). ");
INSERT INTO qxoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tsaypitanam apostolcuna yachatsiyanganta chasquicur Jesucristuman criyicogcuna cuyanacur cawacuyag. Imaypis goricäyag imaycallatapis micuyänanpämi y Tayta Diosman mañacuyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Llapancunapis espantashgam cayag Diospa poderninwan apostolcuna milagrucunata rurayaptin. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tsaychö llapan criyicogcuna juc yarpayllam cawayag capuyanganpita imaycallatapis raquipänacurnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tsaynömi chacrancunatapis y imaycancunatapis ranticuyag. Tsay gellëtanam aypuyag faltapacogcunata. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cada junagmi templuman goricäyag Tayta Diosman mañacuyänanpä. Wayincunachöpis tsaynöllam goricaycur cushishgalla micuyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tayta Diosta alabayaptin llapan runacunam paycunata respitayag. Tsaynöpam warayninman waraynincunaman Jesucristuta chasquicogcuna masrä atscagyäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc junagnam tardipaypa Pedruwan Juan imaypis aywayangannö templuman aywayargan Tayta Diosman mañacuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yaycuraycarnam ricayargan juc runata yuricuyninpitana ishcan chaquin wanushga caycagta. Tsay runatam cada junag castancuna apayag templuchö “Shumag Puncu” ningan yaycucunaman, tsaypa päsagcunata caridäta mañacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tsaynam tsay runa Pedrutawan Juanta ricaycur paycunatapis caridäta mañacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsaynö mañacuptinnam Pedro nirgan: “Amïgu, shuyäramay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tsaymi tsay caridäta mañapacog runa yarpachacurgan: “¿Imatarä goycamanga?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tsaynam tsay runata Pedro nirgan: “Manam gellënëga cantsu gamta garaycunäpä. Peru noga yäracungä Jesucristupa poderninwanmi itsanga yanapashayqui. ¡Cananga paypa poderninwan juclla sharcur puriy!” ");
INSERT INTO qxoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tsaynö nisquir Pedro tsay runata derëcha cag maquinpita jancharcuptinga jinan öram chaqui moguncunapis sänuna ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsaynam itsanga juclla sharcurcur tsay runa purir gallaycurgan. Nircur paycunawan templuman yaycurgan cushicur saltacacharrä allinganta Tayta Diosta alabarnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Tsay alleg runa Diosta alabarnin saltaycachar puriycagta ricarmi llapan runacuna espantacur cushicuyargan. Tsaymi niyargan: “¡Ricayay! ¡Tagay inväliduyashga runa puriycanna! Payga imaypis Shumag Puncu niyanganchö taycullar caridäta mañapacogchä cargan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tsaypitanam tsay alliyashga runa Pedrutawan Juanta macallacurcur mana dejaycurgantsu. Paycuna Salomon nishga alarchö caycagta ricaycurnam runacuna cushicurnin cörrilla aywayargan ricayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tsaymi tsay runacunata ricaycur Pedro nirgan: “Israel marca mayicuna, ¿imanirtä nogacunata ricapäyämanqui? Manam quiquïcunapa munaynïcunawantsu ni jutsaynag cayangäpitatsu cay runata allïtsiyargö, sinöga Señor Jesucristum poderninwan allïtsishga cay runata. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Unay Abraham, Isaac, y Jacob, tsay llapan Israel runacuna adorar yäracungantsic Tayta Diosmi Jesucristuta churashga llapanpita poderyog cananpä. Tsaynö caycaptinpis gamcunaga autoridäcunamanmi entregayargayqui wanutsiyänanpä. Pilato cachaycuyta munaptinpis gamcunaga manam munayargayquitsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tsaypa rantinga Pilatuta niyargayqui jutsayog cagta cachaycur jutsaynag alli rurag cagta wanutsiyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tsaynöpam wanutsiyargayqui alli cawayman apamagnintsic Señornintsicta. Tsaynö wanutsishga caycaptinpis Tayta Dios cawatsimushgam. Cawamungantaga nogacunam ricayargä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Cay chaquin wanushga regiyangayqui runataga Señor Jesucristum poderninwan allïtsishga. Jesucristuman yäracuyangä raycurmi ricaycäyangayquinöpis cananga allishgana caycan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Israel marca mayicuna, gamcuna, y autoridäniquicunapis manam musyayarguyquitsu salvamänantsicpä Tayta Dios Jesucristuta cachamunganta. Tsaynö mana musyarmi wanutsiyargayqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tayta Dios unay willacognin profëtacunatawanmi willacatsimur nirgan: ‘Runacunaman cachamungä salvacogtaga wanutsiyangam’ nir. Tsaymi gamcuna payta wanutsiyangayquiwan cumplishga tsay willacognincuna niyangannölla”. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","“Cananga Jesucristuta wanutsiyangayquipita Tayta Diosta rugacuyay perdonayäshunayquipä. Imayca jutsa rurayniquicunata dejariycur pay munangannöna cawayay. Tsaynöpam Tayta Dios llapan jutsata rurayangayquicunata perdonayäshunqui. Y Jesucristuta Tayta Dios gamcunaman yapaymi cachamunga paypa ñöpanchö alli cawayänayquipä. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesucristoga ciëluchö canga Tayta Dios imaycacunatapis camacätsipacur ushangan junagyagmi. Tsaypitarämi cutimunga. Cutiscamuptinmi itsanga imaycapis Tayta Dios munangannöna canga. Tsaynö cananpä cagtaga Tayta Diospa willacognin profëtacuna unaypitam willacuyargan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Tsaynömi unay Moisespis Israel runacunata Jesucristupä willapargan: ‘Tayta Diosmi gamcunapita acranga nogatanö willacogninta. Paytam cäsucuyanqui llapan ningancunata. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pipis tsay willacogta mana cäsucog cagtaga Tayta Dios manam chasquingatsu’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tsaynöllam Tayta Diospa willacognin unay profëtacuna Samuelpita gallaycur willacuyargan salvacog shamuptin salvacunantsicpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tsay profëtacuna willacuyangannöllam Jesucristo chämushgana. Tsaymi Jesucristuta chasquicuyaptiqui Tayta Dios salvayäshunqui. Tsaynöpam Tayta Dios cumpliycan Abrahamta auningantapis. Abrahamta aunirmi Tayta Dios caynö nirgan: ‘Gampita miragcunapitam maytsay marcachö runacunapis bendicionta chasquiyanga’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abrahamta auningannöllam Jesucristuta chasquicur tsay bendicionta chasquiycantsic. Tsay bendicionga jutsa rurangantsiccunata jagirir Tayta Dios munangannö cawanantsicpä Jesucristo salvamangantsicmi. Paytam Tayta Dios nogantsicman cachamurgan waquin runacunapita puntata chasquicunantsicpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Juanwan Pedro runacunata willapaycäyaptinmi chäyargan sacerdöticuna y saduceucuna, templuchö wardiyacunapa capitanninta pusharcur. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsaychömi tsay apostolcuna runacunata tantiyaycätsiyargan caynö: “Señor Jesus wanunganpita cawamushga captinmi llapantsicpis wanungantsicpita cawarimushun” nir. Tsayta wiyaycurmi tsay autoridäcuna pasaypa ajacurcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tsaynö ajarmi Pedruta Juanta prësur apacuyargan. Tardina captinnam carcelman wichgayargan warayninyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tsaynö captinpis Pedro y Juan willacuyanganta wiyagcunaga atscagmi Jesucristuman criyicuyargan. Tsay criyicogcunaga cayargan pitsga waranganömi (5,000), warmicuna, wamracuna mana yupashga. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tsaypita warayninnam Jerusalenchö goricäyargan Israel runacunapa mandagnincuna, respitädu mayor cag runacuna, y ley yachatsicogcuna. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Paycunawanmi goricäyargan sacerdöticunapa mandagnin cag Anaspis. Tsaychömi cayargan Anaspa castan Caifas, Juan, Alejandro, y mas llapan puëdeg cag castancuna. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsaychö llapan goricaycur Pedruta y Juanta carcelpita jipiscatsimurmi tapuyargan: “¿Ima munayyog cayniquicunawantä gamcuna cay inväliduyashga runata allïtsiyarguyqui? Gamcunata ¿pitä cachayämushurguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tsaynam Espiritu Santo valoratsir yanapaptin Pedro nirgan: “Señor autoridäcuna, wiyayämay. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Tsay runata imanöpa allïtsiyangätapis musyayta munayaptiquega canan musyatsiyäshayqui imanöpa allingantapis. Payga sänuyashga caycan Jesucristo allïtsishga captinmi. Jesustam gamcuna crucificaypa wanutsiyargayqui. Tsaynö wanuycätsiyaptiquipis paytaga Tayta Diosmi cawatsimushga. Tsayta musyayätsun Israelchö llapan runacunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Señor Jesucristuta mana imapäpis cuentayanganpäga Diospa palabran gellgaranganchöpis caynömi nican: ‘Wayi cimientog runacuna “Cay rumega manam imapäpis välintsu” nir jitariycuyangan cagran alli albañilpäga tsay rumega mayistra rumimanrä ticrarin’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tsay jitariyangan mana väleg rumitanölla Jesucristutapis runacuna mana välegpä cuentayaptinpis, Tayta Diosmi musyatsimarguntsic Jesucristo salvamagnintsic canganta. Manam paypita mas jucga cannatsu salvamänantsicpäga”. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tsaynö ishcan apostolcuna mana mantsariypa parlayaptinmi autoridäcuna ninacuyargan: “Paycunaga escuëlachö mana liyishga caycar imatapis allillaga mana musyaycar ¿imanöpanatä tsayläya parlaycuyan?” nir. Nicäyangantaran tantiyacuyargan Jesuspa discïpuluncuna cayanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tsaymi ima niytapis camäpacuyargantsu, tsay allïtsiyangan runa ñöpancunachö captin. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Tsaynam Pedrutawan Juanta wagtaman yargascatsir quiquin pura willanacuyargan: “¿Imatatä ruraycushun caycunata? Jerusalenchö llapan runacunam musyayan tsay inväliduta allïtsiyanganta. Tsaytaga manam ñëgashwantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Waquin marcacunamanpis tsay allïtsiyangan mana musyacänanpä nishun cananpita witsaymanga Jesuspä pitapis imatapis manana willapäyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsaynö cösa yätsinacurcurmi apostolcunata wagtapita gayascatsimur niyargan: “Cananpita waraymantä pitapis imatapis Jesuspä willapaycäyanquiman ni yachatsicuycäyanquiman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Niyaptinmi Juanwan Pedro niyargan: “Shumag tantiyacuyay, taytacuna. Manam allitsu canman Tayta Dios ningancunata jagiriycur gamcuna niyämangayqui cagtarä rurayaptëga. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ricayangäta wiyayangätaga nogacuna pitapis maytapis willapaycäyäshämi”. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Chaquin wanushga runata allïtsiyanganpita llapan runacuna Tayta Diosta alabayaptinmi autoridäcuna paycunata manana imanayargantsu. Alli cösa anyarcurmi itsanga niyargan: “Tsaynölla cananpita willacur puriyaptiquega castigayäshayquim” nir. Tsaynö jurapärirmi cachaycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jesucristupa poderninwan alleg runaga chuscu chunca (40) watapitaga masyogllanam cargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Juanwan Pedro carcelpita yargusquirnam aywacuyargan criyicog mayincuna cagman. Tsaychömi paycunata willapäyargan sacerdöticunapa mandagnincuna y respitädu mayor cag runacuna jurapäyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tsaynö willacuriyaptinnam llapancuna Tayta Diosman mañacur rugacuyargan caynö nir: “Tayta Dioslläcuna, gammi camargayqui ciëlutapis, cay patsatapis, lamartapis, y llapan imaycacunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Espiritu Santuyquim unay rey Davidta tantiyatsirgan caynö nir gellgananpä: ‘¿Imanirtä runacuna pasaypa ajar büllata ruraycäyan? ¿Imanirtä manacagcunata willanacuyan? ");
INSERT INTO qxoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mandacog autoridäcuna goricaycur willanacuyan Diospa contran y cachamungayqui salvacogpa contran sharcuyänanpä’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“David gellgangannöllam Herodespis, Poncio Pilatupis, marca mayïcunapis, y maytsaypita shamog juc nacion runacunapis cay Jerusalen marcachö goricäyargan cachamungayqui Jesucristupa contran sharcuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tsaynöga rurayashga unaypitana permitingayquita cumplirmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cananpis autoridäcuna jurapäyämanganta ricaycanquim, Tayta Dioslläcuna. Tsaymi gamllaman nogacuna yäracayämü. Valorta goycayämay mana mantsariypa willacuyniquita willacuyänäpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yanapaycayämay, taytallay, geshyagcunata poderniquiwan alliycatsiyänäpä. Tsaynöpa cachamungayqui Jesucristuman runacuna criyicuyänanpä yanapaycayämay mastapis imayca milagrucunata ruraycuyänäpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tsaynö Tayta Diosman mañacur ushasquiyaptinmi tsay goricäcuyänan wayi cuyusquirgan. Tsaychö llapanmi Espiritu Santupa poderninwan quëdariyargan. Tsaypitanam Tayta Diospa alli willacuyninta mana mantsariypa willacur gallaycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tsaychö Jesucristuman llapan criyicogcuna, atscag carpis, juc yarpayllam cayargan. Mayganpa imancuna capuyaptinpis manam “Quiquïllapämi” niyargantsu, sinöga llapancunam iwalanacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mana mantsacuypam apostolcunaga Señornintsic Jesucristo cawamunganta willacuyargan. Y Jesucristuta chasquicogcunata Tayta Dios pasaypam yanapargan alli cawacuychö cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Paycunaga manam mayganpis faltäpacuyagtsu. Tsaynö cayänanpämi chacrancunata wayincunata ranticuycur gellënincunata apostolcunaman churayargan. Paycunanam llapancunata aypuyag faltapacuyanganman. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tsaynömi rurargan Levipa castan Chipre islapita Josepis. Paypa jutintam apostolcuna churayargan “Bernabe” nir. Tsay jutega “valoratsicog runa” ninanmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Paypis chacranta ranticusquirmi tsay gellëta apostolcunata goycurgan faltapacogcunata yanapayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tsaynömi Ananias jutiyog juc runapis warmin Safirawan cösa willanacurir chacrancunata ranticuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tsaymi ishcan yachatsinacurcur tsay gellëta waquin cagta raquicuycur waquillantana apostolcunaman Ananias apapargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Waquillanta chaycatsiptinmi Pedro nirgan: “Ananias, ¿imanirtä Espiritu Santuta llullaparnin Satanas munanganta rurarguyqui? ¿Imanirtä ‘Cayllam ranticuyangä llapan gellë’ nirnin waquin cagtaga quëdatsicuycuyarguyqui? ");
INSERT INTO qxoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ranticuyangayqui chacraga ¿manacu quiquiquicunapa cashga? Ranticuyangayqui gellëpis ¿manacu quiquiquicunapa cashga? Tsaynö caycaptinga rasun cagta parlanayqui raycur ¿imanirtä llullacunqui? Manam nogacunallatatsu llullapäyämarguyqui, sinöga Diosnintsictam”. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pedro tsaynö niycuptinmi Ananias jinan öra wanusquirgan. Tsaynö Ananias wanusquinganta musyarmi runacuna pasaypa mantsacäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsayman jövincuna chaycurnam Ananiaspa ayanta wancurcur apacuyargan pampayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsaypita quimsa öratanönam chargan Ananiaspa warmin Safirapis. Pay manam musyargantsu gowan wanunganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tsaymi Pedro tapurgan caynö: “Safira, mä, willamay. ¿Runayqui apamungan gellëllachöcu chacrayquicunata ranticuyargayqui?” nir. Tsaymi Safira nirgan: “Au, tsayllachömi ranticuyargä, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Niptinmi Pedro nirgan: “¿Imanirtä gamcuna yachatsinacuyarguyqui Diospa Espiritunta llullapäyänayquipä? ¡Ricay! Tagay jövincuna gowayquipa ayanta pamparamurna puncuchöna caycäyan. Llullacungayquipita gamtapis apayäshunquinam pampag”. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tsaynö niycuptin jinan öram Pedrupa ñöpanchö Safirapis wanusquirgan. Tsaynam jövincuna yaycur tariyargan wanushgana jitaraycagta. Tsaynöta ricaycur paytapis apayargan jinan öram gowanpa lädunman pampayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ananiaswan Safira llullacuyanganpita wanuyanganta musyaycurmi Jesucristuman llapan criyicogcuna y waquin runacunapis pasaypa mantsacäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Runacuna ricaycäyaptinmi apostolcuna Diosnintsicpa poderninwan atsca milagrucunata rurayag. Llapanmi Jesucristuman criyicogcuna imaypis templuchö Salomon nishga alarman goricäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tsaynö goricarnin respëtuwanmi ricayag. Peru Ananias wanunganta mantsarirmi waquin runacunaga paycunaman manana witipäyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ni imanö captinpis cada junagmi warmipis ollgupis Jesucristuta chasquicurnin mas atscagyarna cabalacaycäyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cällipa Pedro cada päsaptinmi geshyagcunata jipipäyämog andamiantinta cämantinta caynö yarparnin: “Pedro päsaptin llantuyllanpis janancunaman chaptin maygallanpis allisquiyangam” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tsaynöllam maytsay marcacunapitapis Jerusalenman shayämurgan imaycaläyawan geshyagcunata y supayyogcunatapis apacurcur. Tsay geshyagcunaga llapanpis allïyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tsaycunata rurayanganta musyarnam mandacog sacerdöti y paywan pureg saduceo cag runacunapis apostolcunata masrä chiquicurcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tsaynö chiquiparnam prësu tsariscatsir carcelman wichgatsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Peru Tayta Diospa angelnin pagaspa chaycurmi carcel puncucunata quichasquir paycunata jipiscamurgan. Nircurmi nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aywayay templuman. Tsaychö runacunata willapäyanqui Jesucristuta chasquicur salvacuyänanpä cagta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tsaynam tsay angel ningannölla tsaca tsacallana templuman aywar apostolcuna runacunata willapäyargan Jesucristuta chasquicuyänanpä. Tsayyagnam mandacog cag sacerdöti, sacerdöti mayincunawan gayatsinacuyargan llapan autoridäcuna sesionta rurayänanpä. Llapancuna willanacurirnam wardiyacunata cachayargan carcelpita apostolcunata jipiyämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tsay wardiyacuna carcelman chaycurnam tariyargannatsu apostolcuna wichgaraycagta. Tsaynam cutiyargan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Carcel puncuta shumag wichgaraycagtam tariyargö. Y prësu cuïdagcunapis puncucunachö ichiraycäyashgam. Ruriman yaycurmi itsanga ¡maygan prësutapis tariyargönatsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tsayta wiyaycurmi templuchö wardiyacunapa capitannin y puëdeg sacerdöticunapis tapunacuyargan: “¿Imanöparä geshpisquiyashga canman? Cananga ¿imanötä cashun?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tsaynö pasaypa yarpachacuychö caycäyaptinnam juc runa chaycur nirgan: “¡Carcelman wichgayangayqui runacunaga templuchönam runacunata yapayna yachaycätsiyan!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsaynö niptinnam jinan öra wardiyacunata pushacurcur capitan aywargan apostolcunata cangan apayämunanpä. Peru tsaychö runacuna apostolcunapa favornin sharcur samgayänanta mantsacurmi mana magayllapana apayämurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tsaynam apostolcunata chätsiyargan autoridäcuna goricäcuyänanman. Tsaychö mandacog cag sacerdötim nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“¿Manacu gamcunata willayargä imaypis Jesuspita manana willapäcuyänayquipä? Tsaynö nicaptïpis ¿imanirtä sïgiyanqui runacunata willaparnin? Nircurrä tsaypis nogacunata tumpaycäyämanqui ‘Paycunam Jesusta wanutsiyashga’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tsaynam Pedro y waquin cag apostolcunapis niyargan: “Gamcuna niyämangayquicunata rurayänäpa rantinga Tayta Dios niyämangancunatam cumpliyänä. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gamcuna Jesusta crucificaypa wanutsishga caycäyaptiquipis imaypitapis Israel runacuna adorar yäracungantsic Tayta Diosmi wanunganpita cawatsimushga. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nircurmi mandamagnintsic y salvamagnintsic cananpä Señor Jesucristuta derëcha cag lädunman jamatsishga. Paymi jutsantsicpita perdonta mañacushgaga salvamäshun. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tsaycunata willacuyänäpämi Espiritu Santuta Tayta Dios nogacunaman churamushga. Pita maytapis Espiritu Santum yanapaycan imaycay örapis Tayta Diosta cäsucog cagtaga”. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tsaynö niyanganta wiyaycurmi autoridäcuna masrä ajacurcur wanutsiytana munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Peru tsaychömi antis paycunawan caycargan ley yachatsicog juc fariseo runa. Paypa jutinmi cargan Gamaliel. Llapan runacunam paytaga respitayag. Tsay respitashga runam wardiyacunata mandargan apostolcunata wagtaman rätulla jipisquiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tsaynö jipiscatsirmi tsaychö caycag autoridä mayincunata nirgan: “Israel runacuna, cay runacunata contrarnin, pagtä imamanpis jegaycäyanquiman mana shumag tantiyaycur. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Yarpäyanquicu juc tiempuchö Teudas jutiyog runa ‘Yachag runam cä’ nir alabacur puringanta? Paytam gatiräyargan chuscu pachac (400) runacuna. Tsaynö criyitsicur puriycagta wanuscatsiyaptinmi gatiragnincunapis mashtacar aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nircur tsaynömi Romapa mandunman censucuy cangan witsan Galilea provinciapita shamog Judaspis purirgan. Paytapis wanuscatsiyaptin llapan gatiragnincuna, atsca carpis, mashtacarmi aywacuyargan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Tsaymi gamcunata noga shumag yätsiycä cay runacunawan mana mëticuyänayquipä. Mejor dejaycuyay. Quiquincunapa yarpayllanpita willacuyaptinga willacuyangallanchömi ushacanga. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Peru Tayta Dios ninganta rurayaptinga contran sharcur imar, pagtatä Tayta Diosta ajaycätsiyanquiman”. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tsaymi Gamaliel ninganta cäsurnin apostolcunata wanutsiyargannatsu, sinöga alli cösa astarcatsirmi gayascatsirnin niyargan Jesuspita masta manana imatapis parlayänanpä. Nircurmi cachasquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tsaypitanam Señor Jesucristo raycur tsaynö astacäyanganta apostolcuna cushishga yargucuyargan autoridäcunapa ñöpancunapita. ");
INSERT INTO qxoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tsaynö autoridäcuna michaycäyaptinpis paycunaga cada junagmi willacuyargan: “Jesusga Tayta Dios cachamungan salvacogmi” nirnin. Tsaynöllam templuchöpis y wayicunachöpis willacuyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tsaynö willacuyaptinmi mas atscagyäyargan Jesucristuta chasquicogcuna. Paycunaga cayargan griegu parlacuyta parlagcunam y hebreu parlayta parlagcunam. Cada junag viüdacunatam micuynincuna aypuyag. Hebreu parlag viüdacunata mas yanapaycäyanganta yarparmi griegu parlag runacuna jamurar niyargan: “Hebreu parlagcunaga quiquin purallam micuyta garanacuyan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tsaynö niyaptinmi Jesucristuman llapan criyicogcunata gorisquir apostolcuna caynö niyargan: “Waugicuna, Diospa willacuyninta willacur puriyaptïmi tiempücuna cagnönatsu viüdacunata atiendiyänäpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tsaymi cananga gamcunapita acrayämunqui ganchis (7) runacunata micuy aypucog cayänanpä. Itsanga paycuna cayätsun Espiritu Santo munangannö cawag y alli yarpayyog runacuna. Paycunatam churashun tsaycunata rurayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tsaynöpam nogacunaga Diospa willacuyninta willacur y payman mañacur puriyäshä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tsaynö llapancuna willanacusquirmi ganchis runacunata acrayargan. Paycunaga Espiritu Santo yanapaptin Diosnintsicman yäracur cawag runacunam cayargan. Tsay ganchis runacunapita jucga cargan Estebanmi. Waquin cagnam cargan Felipe, Procoro, Nicanor, Timon, Parmenas, y Antioquia marcapita Nicolas. Nicolasga juclä runa caycarpis mas puntatanam Israel runacuna adoracuyangan Tayta Diosman criyicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nircurnam apostolcuna tsay acrayangan ganchis runacunapa umancunaman maquincunata churarcur Tayta Diosman mañacuyargan paycunata yanapaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tsaynöpam Tayta Diospa willacuyninta Jerusalenchö willacuyaptin Jesucristuman criyicogcunaga cada junag masrä atscagyäyargan. Y hasta Israel sacerdöticunapis atscagmi chasquicuyargan tsay willacuyta. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tayta Dios yanapaptinmi Estebanga atsca milagrucunata rurargan runacunachö. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tsaynö milagrucunata rurar Jesucristupa willacuyninta willacuptinmi waquin Israel runacuna rimanacuyargan. Tsay rimanacog runacunaga cayargan Cirene marcapita, Alejandria marcapita, Cilicia provinciapita, y Asia provinciapita. Paycunawanmi cayargan esclävu cayanganpita yargushga runacunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Estebanwan rimanacurpis tsay runacuna manam imanö niytapis puëdiyargantsu Espiritu Santo tsaynö parlananpä yachatsiptin. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsaynam imanö caytapis mana puëdirna tsay contragnin runacuna pacayllapa waquin runacunata pägayargan Estebanpa contran caynö niyänanpä: “Moisespa y Tayta Diospa contranmi Estebanga parlaycan” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tsaynö niyanganta wiyaycurmi autoridäcuna, ley yachatsicogcuna, y waquin runacunapis pasaypa ajacurcuyargan. Nircurnam Estebanta prësu tsarircur apayargan mas puëdeg cag autoridäcuna goricäyangan cagman. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tsaymanmi tsay pägapacuyangan cag runacunata pushayargan Estebanpa contran caynö niyänanpä: “Cay runaga templuntsicpa y Tayta Diospa mandamientuncunapa contranmi imaypis parlashga. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Y wiyayargö caynö nicagtam: ‘Tayta Diospa templunta Nazaret marcapita Jesusmi juchutsinga’ nir. Tsaynöllam nican Moises gellgangan leycunatapis manana cäsucunantsicpä cagta. Tsaynö nicagtam quiquïcuna wiyayargö”. ");
INSERT INTO qxoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tsaynam tsaychö caycagcuna Estebanta ricarcuyanganchö ricasquiyargan angelpa gagllantanö Estebanpa gagllan chipipegtarä. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tsaypitanam Estebanta sacerdöticunapa mandagnin tapurgan: “¿Rasunpacu cay runacuna niyangannö gam parlarguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tsaynam Esteban parlar gallaycurgan caynö: “Shumag wiyayämay, taytacuna. Unay tiempuchöpis llapan imaycacuna päsanganta musyantsicmi, Diospa palabranchö gellgashga captin. Unay Abrahamtam poderösu Tayta Dios yuripargan Mesopotamia marcallachörä taycaptin. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tsaychö yuriparmi nirgan: ‘Castayquicunata y marcayquitapis jagiriycur noga entreganäpä cag marcaman aywacuy’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Tsaynö niptinmi Mesopotamiapita Abraham aywacurgan ‘Haran’ ningan marcachö täcunanpä. Tsaychömi täcurgan taytan wanucunganyag. Tsaypitanam Tayta Dios pushamurgan cay taycangantsicman. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cayman täränanpä chaycatsimurpis manam maynintapis ricatsirgantsu quiquinpana cananpäga. Mana ricatsirpis tsurin manarä captinmi Tayta Dios aunir caynö nirgan: ‘Cay taycangayquita gampita miragcuna juc nacionta rurayänanpämi entregashä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nircur Tayta Dios yapay nirganmi: ‘Manarä maychöpis täyänanpä ricatsiptïmi willcayquipa tsurincuna y paycunapita miragcunapis caru marcachö jäpayashgallarä cayanga. Tsaychömi juc nacion runacuna pasaypa maltratarnin munayanganchö ñacatsir tsaräyanga chuscu pachac (400) wata entëru. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Peru nogam juzgashä castiganäpä tsay munayninchö maltratarnin tsararag runacunata. Tsaynö esclävu caycäyanganpita yargaramurnam caychö cushishgallana täcuyanga nogapa mandamientücunata cäsur’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Tsaynömi Tayta Dios Abrahamta aunirnin nirgan: ‘Gampita miragcunata yanapanäpäga cuerpuncunatarä señalacuyätsun. Y tsaynölla ollgu tsuriquicunatapis señalatsiyanqui’ nir. Tsay ningannöllam quiquin Abrahamrä señalacurgan. Y nircurmi tsurin Isaac yurisquiptinpis señalatsirgan yuringanpita puwag (8) junagyogllata. Tsaynöllam Isaacpis tsurin Jacobta señalatsirgan y Jacobpis chunca ishcay (12) tsurincunata señalatsirgan. Tsay Jacobpa tsurincunapitam llapan Israel nacion runacuna mirayashga”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Jacobpa tsurincunam, gepa cag waugincuna Joseta chiquiparnin Egipto nacionpa aywag negocianticunata ranticusquiyargan. Tsay negocianticunanam Egiptuman chaycatsir juctana ranticuriyänä. Tsay Egiptuchöpis Tayta Dios Josetaga imaypis mana dejaypam yanapargan. Tsaynöpa yachag captinnam rey faraon payta churargan palaciunchö arogcunata mandananpä y Egipto naciontapis mandäshinanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tsay witsanmi Egipto nacionchö y ‘Canaan’ ningan marcacunachöpis feyupa usya captin unay Israel runacuna micuyänanpä micuynincuna cargannatsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egiptuchömi itsanga usya manarä gallaptin atsca trïguta Jose tröjaman churacunä. Tsaypita muchuyna captin tsay churatsingan trïguta Egiptuchö ranticuycanganta musyaycurnam tsurincunata Jacob cachargan trïgu ranteg aywayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tsaypita trïgu ranteg yapay cutirpis manarämi tantiyayänärätsu Jose paycunapa waugin canganta. Tsaynö mana tantiyayaptinmi quiquin Josena willargan ranticuyangan waugincuna canganta. Waugincunawan tincunganta willaptinrämi rey faraon musyargan maygan casta Jose cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsaypitanam Jose gayatsirgan papänin Jacobta y llapan castancunata Egipto nacionman aywacuyänanpä. Egiptuman aywagcunaga llapan cayargan ganchis chunca pitsga (75) runacunam. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tsaynöpam Egiptuman llapan tsurincunawan Jacob aywacurgan. Tsaychö taycarmi paypis y tsurincunapis wanuyargan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","“Tsaypita Jacob wanusquiptinnam ayanta apayämurgan ‘Canaan’ ninganchö Siquem marcaman pampayänanpä. Tsaychömi awilun Abrahampis pamparargan. Nircur tsayllamanmi Josepa ayantapis apayämurgan pampayänanpä. Tsay pampacuyänanpä chacrataga Abrahammi rantirgan Hamor jutiyog runapa tsurincunapita”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tayta Diosga Abrahamta caynö nir auningancunata manam gongargantsu: ‘Gampita yuregpitam ishyaypa mirayanga’ y ‘Paycunatam juclä nacionchö ñacacuypita jipimushä’. Ningannölla tsay jipimunanpä cag tiempucuna chämuptinnam Israel runacuna Egipto nacionchö pasaypa ajayaypäna mirashga cayargan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","“Tsay witsanga Egiptuchö jucnam yaycurgan rey cananpä. Payga mananam mayargannatsu Jose pï cangantapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tsay reymi Josepä manana imatapis mayar Israel runacunata pasaypa maltratar gallaycurgan. Tsaynö manana atipaypä mirayaptinnam ajayarna rey mandargan llapan llullu yureg ollgu wamracunataga wanutsiyänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Tsay witsanmi Moisespis yurirgan. Paytaga Tayta Diosmi pasaypa cuyargan. Tsay llullutaga taytanwan maman wayillanchömi pacayllapa shacshatsicuyargan quimsa quillayog canganyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tsaypitanam rey mandanganta mantsacurnin tsay llulluta mayu cuchunman pacaycuyargan. Tsaypita reypa warmi tsurinnam taricuycur apacurgan quiquinpa wawantanö ricananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsaypita Egiptuchö jövinyarnam yachatsiyangancunatapis pasaypa yachar regishga runana ticrargan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chuscu chunca (40) watayog caycarnam juc junagna Moises yarpänä marca mayincunaman watucag aywayta. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yarpangannölla watucag aywarmi tarirgan juc Israel runata Egipto runa magaycagta. Tsaynöta tariycurmi Israel runapa janan sharcur Moises wanuscatsirgan tsay Egipto runata. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tsaynö rurarmi Moises yarpargan Egiptupa mandunpita tsay Israel runacunata jipinanpä Tayta Dios cachanganta cuentata gocuyänanta. Tsaynö Moises yarpaptinpis paycunaga manam ichicllapis tantiyargantsu”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Tsaypita warayninnam yapay watucagnin aywar Moises tarirgan ishcag Israel mayincunana pelyaycäyagta. Tsaymi washayta munar nirgan: ‘Gamcuna tsay castalla caycarga ¿imanirtä pelyaycäyanqui?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tsaynam magag cag runa Moisesta tangarirninrä nirgan: ‘¡Manam Israel runacunapa mandagnintsu ni jueznintsu canqui tsaynö niyämänayquipäga! ");
INSERT INTO qxoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿O Egipto runata ganyan wanutsingayquinöcu nogacunatapis wanutsimaytana munaycanqui?’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tsaynö niycuptinmi Egipto runata wanutsinganpä reyta musyascatsiyänanta yarparnin geshpir aywacurgan ‘Madian’ ningan jircaman. Tsaychö taycaptinnam ishcay ollgu tsurincuna yurirgan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Tsaypita chuscu chunca (40) wata Madianchö taycarnam Moises aywargan ‘Sinai’ ningan tsunyag jircapa washaläninman. Tsaychömi shiraca rupaycagchö Tayta Diospa angelnin yuripargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tsaynö pasaypa rauraycagta ricaycurnam Moises ima ruraytapis camäpacurgantsu. Tsaymi mas shumag ricaycuyta munar maslla witipaycanganchö wiyargan Tayta Dios caynö nimogta: ");
INSERT INTO qxoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Unay Abraham, Isaac, y Jacob, tsay Israel runacuna yäracayämangayqui Diosmi noga cä’ nir. Tsayta wiyaycurmi sï Moises tsuctsucyarnin ricaycuytapis mantsarirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tsaynö Moises mantsarir caycaptinmi Tayta Dios yapaypis caynö nirgan: ‘Cay patsaga feyupa sagrädum caycan. Respitamarnï llangiquita jipicuriy’. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nircurnam nirgan: ‘Noga ricaycämi Israel runacuna Egipto nacionchö imanö ñacar wagaycäyanganta. Tsaymi Egiptuman gamta cachashayqui paycunata jipimunayquipä’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Tsay Israel runacuna Moisesta mana cäsurninmi niyargan: ‘¡Manam gam mandagnïcunatsu ni jueznïcunatsu canqui!’ nir. Tsaynö Moisesta nicäyaptinpis Tayta Dios rupaycag shiracachö parlapashga carmi angelninwan payta cachargan Egiptupita paycunata jipimunanpä. Tsaynöpam Tayta Dios Moisesta churargan paycunapa salvagnin y mandagnin cananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tsaynömi ari Moises jipimurgan unay Israel runacunata Egipto nacionpita. Imayca milagrucunatapis rurarganmi Egiptuchöpis y ‘Puca Lamar’ ninganchöpis. Tsaynölla chuscu chunca (40) watantin tsunyagcunata aywaycarpis milagrucunataga rurarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tsaynö jipirmi Moises Israel runacunata nirgan: ‘Tayta Diosmi gamcunapita juc runata churanga noganö willacog cananpä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Y Moisesmi Tayta Dios cachamungan angelpita chasquirgan Sinai jircachö mandamientucunata. Tsay mandamientucunatam runacunata yachatsirgan Tayta Dios munangannöna alli cawayänanpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Moises tsaynö yachatsicuptinpis manam cäsuyargantsu Israel runacuna tsunyag jircacunata aywaraycarninpis. Tsaynö mana cäsurninmi Egiptuman cuticuyta munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tsaymi Sinai jircaman witsanganpita Moises ras mana cutimuptin waugin Aarontana niyargan: ‘Manam musyantsictsu Egiptupita jipimagnintsic Moisesta ima päsangantapis. Gam cananga juc diosta rurapaycayällämay mañacuyaptï yanapayämänanpä’. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsaynö mañacuyaptinmi rurapargan becërrupa imäjinnintanö ‘Caymi Diosnintsic’ nir adorayänanpä. Nircurmi tsay ïduluncunatana mañacuyangancunata wiyananpä altarninchö ashmacunata pishtapäyargan. Tsay aytsacunatanam micuyargan ïdulupa jutinchö fiestata rurar”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Tsaynö rurayaptinmi Tayta Dios pasaypa rabyacurnin paycunata manana yanapargannatsu. Tsaymi quiquincuna munayangannö cawarna estrëllacunatapis, rupaytapis, y quillatapis adorarninna gallaycuyargan. Tsaymi willacognin unay profëta gellgananpä Tayta Dios nirgan: ‘Israel runacuna, chuscu chunca (40) watantin tsunyag jircacunata aywaycar manam nogata yarpämartsu ashmayquicunata pishtasquir altarchö rupatsiyargayqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nogapä yarpäyänayquipa rantinga maypa aywarpis “Moloc” ningan rurayangayqui ïdulutam puritsiyarguyqui payman mañacuyänayquipä. Tsaynömi “Refan” ningan ïdulupa estrëllan niragta ruraycurpis puritsiyarguyqui. Tsaynö rurayangayquipitam gamcunata garguyäshayqui caru Babilonia marcayag’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Mana imapis cag tsunyag jircachömi unay Israel runacunaga ‘tabernäculu’ ningan tolduta puritsiyargan tsaychö Tayta Diosman mañacur adorayänanpä. Tsay tabernäculutaga rurayargan Moisesta Tayta Dios tantiyatsingannöllam. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tsaypita unaytanam tabernäculuta apacurcur Josuewan Israel runacuna yaycayämurgan auningan marcacunaman. Yaycayämuptinmi Tayta Dios cay marcacunachö täcog cag runacunata gargurgan. Tsaynö gargurirnam tsay marcacunata Israel runacunata auningannölla entregargan. Tsaynö cagmi tabernäculoga cay marcantsiccunachö quëdargan rey David cawangan witsanyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tayta Dios yanapaptinmi Davidga Jerusalenchö templutana sharcatsiyta munargan Tayta Dios tsaychö täcunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tsaynö yarpaptinpis Davidpa tsurin rey Salomonrämi sharcatsirgan templuta”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Tsaynö sharcatsishga captinpis imaycawan poderösu Tayta Diosga manam runacuna rurayangan templuchöga tärantsu. Tsaynö captinmi willacognin unay profëta gellgananpä Tayta Dios nirgan: ");
INSERT INTO qxoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ciëloga jamaräcunämi. Tsaypitam llapantapis munaynïchö tsararä. Runa cawangan patsaga chaquï jaruräcunanmi. Tsaynö caycaptëga manam ima wayipis nogapä aypangatsu. Nogaga manam runa rurangan wayichö tärämantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nogam camargä ciëlutapis y runa cawangan patsatapis’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tsaynö nircurmi Esteban nirgan: “Gamcunapis unay mana alli cag Israel runacunanöllam Espiritu Santupa contran imaypis caycäyanqui. Chucru shongu carmi munayangayquinölla cawaycäyanqui. Tsaynölla imayyagrä Tayta Diosta mana cäsur payman mana yäracog runacunanö caycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Manacu unay Israel runacunapis Tayta Dios cachamungan salvacogpä willacog profëtacunatapis chiquirnin wanutsiyargan? Gamcunapis tsay castallapita carmi Tayta Dios cachamungan salvamagnintsic Jesucristutapis autoridäcunaman entregayargayqui wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","¡Angelnincunawan mandamientuncunata Tayta Dios apaycätsimuptinpis manam ni imallapäpis cäsucuyanquitsu!” ");
INSERT INTO qxoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tsaypitanam tsaynö Esteban ningancunata wiyaycur autoridäcuna pasaypa ajacurcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Peru Estebantaga Espiritu Santo ricatsiptinmi ciëluchö ricasquirgan chipipiycag Tayta Diospa derëcha cag lädunchö Señor Jesucristo caycagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tsaynam tsayta ricaycur nirgan: “¡Ciëlu quicharaycämogtam ricaycä! Tayta Diospa derëcha cag lädunchömi Señor Jesucristo caycämun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tsaynö niptin paycunaga rinrincunatapis tsapacurcuyarganmi mastaga wiyayta mana munar. Tsaypita pasaypa rabyarnam gayararnin Estebanman tsaregna cörricuycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nircur marcapita jipisquirmi samgayargan. Tsay samgayänanpä contrag runacunam röpancunata jipiscärir paytacuyargan Saulo jutiyog jövinman. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paycuna samgaycäyaptinmi Esteban Jesucristuman mañacurgan caynö: “Señor Jesus, ñöpayquiman apacallämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsaypita gonguricuycurnam llapan callpanwan nirgan: “¡Cay samgaycäyämag runacunata perdonaycullay, taytay!” Nisquillarnam wanusquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Estebanta wanutsiyanganta ricaycurmi Sauloga cushicurgan. Tsaynö wanuscatsiyaptinmi Tayta Dios munangannö cawagcuna Estebanpa ayanta pampayargan feyupa llaquicuywan wagarnin. Estebanta wanutsiyangan junagpitaga Jesusman criyicogcunata pasaypa gaticacharnam gallaycuyargan gargur ushacätsiyta munar. Tsaynö captinmi tsay criyicogcunaga wacpa caypa geshpir aywacuyargan Judea y Samaria provinciacunapa. Apostolcunallanam Jerusalenchö quëdacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulunam Jesusman criyicogcunata wayin wayinrä ashir gallaycurgan taringan cagtaga warmitapis ollgutapis carcelman wichgatsirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalenpita geshpegcunaga maychö tsaychöpis willacuyarganmi Jesucristo salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tsaynömi paycunawan juntarag Felipipis geshpir Samaria provinciapa juc marcaman aywacurgan. Tsaychömi runacunata willacurgan Tayta Dios salvacogta cachamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tsaynömi Jesucristupa poderninwan milagrucunatapis Felipe rurargan. Tsayta ricarmi willacungancunatapis atsca runacuna chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tsaynömi Jesucristupa poderninwan supay geshyatsingan runacunatapis allïtsirgan. Tsaynö allïtsiptinmi supaycuna gayararrä runacunapita yarguyargan. Tsaynömi atsca ratacunatapis y chancancuna, ricrancuna wanucashga geshyagyashga runacunatapis allïtsirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tsaynö ruraptinmi tsay marcachö tagcuna pasaypa cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Tsay marcachömi cargan juc runa Simon jutiyog. Payga unaypita brüju cayta yachacushga carmi Samaria runacunata engañag väleg tucur. Ollgupis, warmipis, y wamracunapis llapanmi Simon ningancunata cäsurnin niyargan: “¡Cay runataga Tayta Diosmi yanapaycan paypa poderninwan imaycatapis rurananpä!” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tsaypita Jesucristo salvacog canganta Felipe willacuptinnam ollgupis warmipis pay willacungantana chasquicurnin bautizacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tsaychömi tsay brüju Simonpis Jesucristuta chasquicurnin bautizacurgan. Nircurmi milagrucunata Felipe ruranganta ricar pasaypa espantarnin Felipiwanna cushishga purirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tsaypitaga Jerusalenchö caycag apostolcunapis musyariyarganmi Diospa alli willacuyninta Samaria provinciachöpis runacuna cösa chasquicuyanganta. Tsaynam Samariaman cachayargan Pedrutawan Juanta. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Paycuna chaycurnam musyariyargan Jesuspa jutinchö bautizacushgana caycarpis Espiritu Santutaga manarä chasquicuyanganta. Tsaymi Pedruwan Juan Tayta Diosta rugacuyargan paycunapis Espiritu Santuta chasquiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nircur maquincunata tsay llapan criyicogcunapa umancunaman churaycuyaptin jinan öram Espiritu Santuta chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Tsaynö Espiritu Santuta chasquiyanganta ricaycurmi tsay brüju Simonga apostolcunata nirgan: “Tsay poderniquita ranticaycayällämay nogapis runacunapa umanman maquïta churaptï tsaynölla Espiritu Santuta chasquicuyänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tsaynö niptinmi Pedro nirgan: “¿Imanirtä Diosnintsicpa poderninta rantina canganta yarpaycanqui? ¡Tsaynö yarpangayquipitam gellëniqui infiernuman apashunqui! ");
INSERT INTO qxoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","¡Gamga shonguyquichö mana alli yarpag cangayquipitam Diosnintsicpa poderninta chasquinquitsu! ");
INSERT INTO qxoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Llutancunata yarpangayquipa rantinga Tayta Diosman mañacuy perdonashunayquipä. Tsaynö mañacur rugacuptiquega capaz perdonashunquimanrä. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gamga envidiösu criyitsicog carmi llutan rurayniquicunata mana jagirinquitsu”. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tsaynö niptinnam tsay brüju Simon caynö nirgan: “Tsaynö captëga Tayta Diosta rugacuycuyay mana castigaycamänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tsaychö runacunata cösa willapäcur yachatsicurirnam Juanwan Pedro aywayargan Samaria provinciachö waquin marcacunapana Diospa alli willacuyninta willacuyänanpä. Tsaypitanam Jerusalenman cuticuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tsaypitanam Tayta Dios cachamungan angel nirgan Felipita: “Jerusalenpita Gaza marcaman aywag nänipa ayway” nir. (Tsay nänega tsunyag jircapam aywaraycan.) ");
INSERT INTO qxoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Tsaynam angel ningannö Felipe tsay nänipa aywaycar tincusquirgan Etiopia nacionpita juc runawan. Payga Etiopia nacionchö reina Candacipa gellë tsaragnin väleg runam cargan. Tayta Diosta adorag Jerusalenman aywanganpitam tsay runaga cuticuycargan beschacuna sutayangan carrëtanchö, Bibliachö unay profëta Isaias gellgangancunata liyiraycar. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tsaymi Felipita Espiritu Santo nirgan: “Ayway, witipay carrëtachö aywaycag runaman” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tsay ningannö aywarmi Felipe wiyargan tsay Etiopia runa Isaias gellgangancunata liyiraycar aywaycagta. Tsaymi Felipe tapurgan: “Jau amïgu, ¿tantiyanquicu tsay liyiycangayquita?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tsaynö niptinmi tsay runa nirgan: “Pipis mana tantiyatsimaptinga ¿imanöparä tantiyashä? ¿Gam manacu yarcarcamunquiman cayman tantiyaycatsimänayquipä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tsay runa liyiycanganga caynömi gellgaraycargan: ‘Wanutsiyänanpä üshata apayangannömi payga apashga canga. Millwanta rutuyaptin üsha mana gayaragnömi payga upällalla canga. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Burlacur manacagta niyaptinpis pipis manam favornin sharcungatsu. Salvacogta wanutsirnin alläpa cag jutsatam rurayanga’. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tsaynam tsay Etiopia runa Felipita tapurgan: “Tantiyaycatsillämay, taytay. Profëta Isaias cayta gellgar ¿pipätä gellgargan? ¿Quiquinpäcu o jucpäcu?” ");
INSERT INTO qxoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tsaymi Felipe tantiyatsirgan tsay liyiycangan Señor Jesucristupä gellgaraycanganta, y paylla runacunata salvananpä Tayta Dios cachamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tsaypitanam aywaycäyanganchö yacuta tariycurnin tsay Etiopia runa nirgan: “Caychö yacu caycaptinga ¿manatsurä juclla bautizaycallämanquiman, taytay?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tsaymi Felipe nirgan: “Llapan shonguyquiwan rasunpa criyicuptiquega bautizashayqui, ari”. Tsaynö niptinnam Etiopia runa nirgan: “Criyillämi Jesucristo Tayta Diospa tsurin canganta” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsaynam aywaycangan carrëtanta ichiscatsir yacuman yarpuyargan. Nircur tsaychömi tsay runata Felipe bautizargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","40","Yacupita yargusquiyaptinnam Espiritu Santo Felipita jinallanchö illacascatsirgan. Tsaypita Etiopia runaga Felipita mananam ricargannatsu. Payta manana ricarpis cushishgam aywacurgan. Felipinam Azoto marcachöna ricacusquir marcan marcan purirgan Diospa willacuyninta willacurnin Cesarea marcaman changanyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Tsayyagnam Sauloga Jesusman criyicogcunata wanutsiyta munarnin aywargan mandacog cag sacerdötiman ordenninta mañag. Ordenta goycuyaptinnam goricäcuyänan wayicunaman chaycur warmitapis ollgutapis prësur apayargan Jerusalenman. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tsay ordenwan Damasco marcaman yaycuraycaptinnam illagpita payman ciëlupita chipicyaycamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsaynö chipicyaycamuptinmi patsaman Saulo ishquisquirgan. Tsaychönam wiyargan ciëlupita caynö nimogta: “Saulo, Saulo, ¿imanirtä nogaman criyicamogcunata chiquir gaticachaycanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tsayta wiyaycurnam Saulo tapurgan: “¿Pitä canqui, taytay?” Niptinnam nimurgan: “Nogaga Jesusmi cä. Nogaman criyicamogcunata gaticacharnin nogatam chiquiycämanqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Canan sharcur aywaycangayqui Damasco marcaman sïgiy. Tsayman chaycuptiquim niyäshunqui imata ruranayquipä cagtapis” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauluwan aywag runacunaga tsaynö parlamunganta wiyarpis manam pitapis ricayargantsu. Itsanga feyupam mantsacäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tsaypitaga Saulo gaprayashganam sharcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tsaymi paywan aywag runacunallana jancharcur chätsiyargan Damasco marcaman. Tsaychö quimsa junagmi gaprayashgalla cacurgan. Manam pachatapis micurgantsu ni yacutapis upurgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascuchömi cargan Jesucristuman criyicog Ananias jutiyog runapis. Paytam Jesucristo yuripaycur nirgan: “¡Ananias!” Niptinmi pay nirgan: “Caychö wiyaycällämi, taytay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tsaynö niptinmi Jesus nirgan: “Canan ayway ‘Derëcha’ ningan cällipa. Judas jutiyog runapa wayinman chaycurga tapucunqui Tarso marcapita Saulo jutiyog runapä. Tsay wayichömi Tayta Diosman pay mañacuycan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mañacuycanganchömi ricashurguyqui payman yaycurir gapra caycanganpita yapay ricananpä maquiquita payman churaycagta”. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Niptinmi Ananias nirgan: “Payman aywaytaga mantsarïmi, taytay. Pï may runapis willayämashgam tsay runa pasaypa wanutsiyämayta munar chiquiyämanganta. Tsaynömi willayämashga Jerusalenchöpis gamman criyicogcunata gaticachar pasaypa maltratanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cananpis mandacog sacerdötipa ordenninwanmi cay marcaman shamushga gamman criyicogcunata prësur apananpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tsaymi Jesus nirgan: “Imanö captinpis ama mantsacuytsu aywaylla. Tsay runataga acrargö nogapä willacunanpämi. Paymi willapanga juclä nacion runacunata, puëdeg autoridänincunata, y Israel runacunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Payga noga raycurmi mandangäcunata rurar imayca ñacacuytapis päsanga”. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsaynam Ananias aywargan Saulo caycangan wayiman. Tsayman chaycurnam Saulupa umanta yataycur nirgan: “Waugi Saulo, shamuycaptiqui nänichö yuripäshogniqui Señor Jesusmi cachamashga gapra caycangayquipita allïtsinäpä y Espiritu Santupa poderninwanna canayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tsay Ananias parlayta ushasquiptinmi jinan öra Saulupa ñawin tsaparag shicwasquiptin ricachacusquirgan. Nircur tsay örallam bautizacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tsaypita pachan micurcuptinnam callpan yuririrgan. Nircur tsay Damasco marcachö atsca junagrämi Jesusman criyicogcunawan goyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsaypitanam Saulo willacurna gallaycurgan Israel runacuna goricäcuyänan wayincunachö: “Jesusga rasunpa Tayta Diospa tsurinmi” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tsaymi llapan wiyagcunaga espantashga “¿Imanö?” nir ricarar niyargan: “¿Manacu cay runaga Jesusman criyicogcunata Jerusalenchöpis prësur imarrä cashga? ¿Manacu caymanpis shamushga paycunata prësu tsarircur mandacog sacerdöticunaman apananpä?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Peru Saulutaga imanö captinpis Tayta Diosmi cada junag yanapargan Jesucristo salvacog canganta mana mantsacuypa willacunanpä. Tsaymi Damascuchö Israel runacuna pasaypa yarpachacuyargan: “¿Cay runaga allitatsurä o mana allitatsurä nicämantsicpis?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tsaycuna päsariptinnam Israel runacuna willanacuyargan Sauluta wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wanutsiyta munarmi pagasta junagta paycuna shuyacuyargan marcaman yaycuna portädachö. Tsaynö wanutsiyta munayangantaga Saulo musyasquirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tsaymi juc pagas Jesusman criyicogcuna Sauluta shicraman wiñarcur jatun murälla jananpa wascawan cacharpayämurgan geshpicunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tsaypita Jerusalenman Saulo chaycurnam Jesusman criyicogcunawan imaycanöpa goricayta munargan. Peru paycunaga llapanmi goricaytaga mantsariyargan criyicog tucuycanganta yarpar. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tsaynö mantsariyaptinmi apostolcunaman Sauluta amïgun Bernabe pushargan. Chaycatsirnam paycunata willapargan Señor Jesus nänichö Sauluta yuripar parlapanganta. Nircurmi willapargan Damascuchö mana mantsacuypa Jesuspä Saulo parlanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bernabe tsaynö willacuriptinrämi apostolcuna Sauluta chasquiyargan. Tsaypitanam Jerusalenchö paycunawan Saulo purirgan. Runacunatapis mana mantsacuypam willapargan salvayänanpä Jesucristuta Tayta Dios cachamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tsaychö griegu idiöma parlag Israel runacunawanpis rimanacurmi parlargan Jesucristupä. Tsay runacunam itsanga wanutsiyta munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tsaynö wanutsiyta munayanganta musyasquirmi tsaychö criyicogcuna Sauluta apayargan Cesarea marcaman. Tsaypitanam quiquinpa marcan Tarsuman aywacunanpä despachariycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsay witsanga Jesusman criyicogcunata mananam autoridäcuna prësu tsaritsiyargannatsu. Tsaynöpanam Judea, Galilea, y Samaria provinciacunachöpis criyicogcuna allina cawacuyargan. Cada junagmi yachacuyargan Señor Jesucristupa willacuyninta pay munangannöna cawayänanpä. Tsaynömi Espiritu Santo tantiyatsiptin Jesucristuta mas atscagna chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Maytsaypapis Jesucristuman criyicogcunata watucar purirmi Pedroga Lida marcamanpis chargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tsaychömi tarirgan juc runa Eneas jutiyogta. Tsay runam pullan cuerpun wanushga captin puwag (8) wata cämallanchö jitaräcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tsaynöta tariycurmi Pedro nirgan: “Eneas, Señor Jesucristum allïtsishunqui. ¡Sharcur gopiquita goriy!” nir. Tsaynam Eneas jinan öra sänuyashgana sharcurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tsaymi Lida marcachö tärag runacuna y Saron marcachö tärag runacuna tsay Eneas runa sänuna caycagta ricaycurnin Jesucristuta chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tsay Pedro puringan witsanmi Jope marcachö Dorcas jutiyog warmipis Jesucristuman criyicog cargan. Tsay warmega imaypis allicunata rurarmi pobricunata yanaparnin cawag. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tsay junagcunanam Dorcas geshyarnin cämaman ujurpog cagga wanucurgan. Tsaynam ayanta armatsipacusquirna sutayargan altusman. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope marcapita Lida marca cercallana captinmi Lidachö Pedro caycanganta musyar ishcay runacunata cachayargan payta rugar pushayämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tsaymi Pedro paycunawan aywargan. Chaycuptinnam päsatsiyargan Dorcaspa ayan sutaraycangan cagman. Tsaychömi atsca viüdacunapis goriraycäyargan wagarnin. Tsay wagaycagcunanam Pedruta ricatsiyargan tsay viüdacunata Dorcas cuyaparnin rurapangan röpancunata. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tsaynam Pedro tsaychö caycagcunata wagtaman gargurir gonguricuycur Tayta Diosman mañacurgan. Mañacurirnam wanushga caycag warmita nirgan: “¡Dorcas, sharcuy!” nir. Tsaynö nisquiptinmi wanushga caycanganpita juclla cawarircamur Pedruta ricärir jamarcamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro maquinpita tsarircurnam sharcatsirgan. Tsaypitanam wagtachö caycagcunata Pedro gayargan Dorcas cawamunganta ricayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tsay cawarimungantaga runacuna musyayargan entëru Jope marcachömi. Tsaynöpam Señor Jesucristuta atscag chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tsay marcachö atsca junagrämi Pedro quëdacurgan, suëla rurag Simonpa wayinchö. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea marcachömi tärargan juc runa Cornelio jutiyog. Payga cargan “Italiano” ningan tröpapa capitanninmi. Tsay tröpachömi juc pachac (100) soldäducuna cargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tsay capitanga wayinchö castancunawan wätaynincunawanpis Tayta Diosman mañacurmi cawacog. Tsaynö alli cawacog cayninwanmi faltapacogcunata imaycanwanpis yanapag. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Juc junagnam tardi mallway öranö caycaptin, Cornelio ricasquirgan Tayta Diospa angelninta. Tsay angelmi nirgan: “¡Cornelio!” ");
INSERT INTO qxoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tsaynö niycuptin pasaypa mantsacashga ricaraycanganchömi angelta tapurgan: “¿Imatatä munallanqui, taytay?” nirnin. Tsaynö niptinmi angel nirgan: “Tayta Diosmi wiyashurguyqui mañacungayquita y pobricunata yanapangayquitam ricashurguyqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cananga Diospa willacuyninta tantiyatsishunayquipä cachacuy runacunata Jope marcaman Pedruta pushayämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payga patsaraycan suëla rurag Simonpa wayinchömi. Tsay suëla rurag runapa wayinga lamar cuchunllachömi”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tsaynö nisquir angel aywasquiptinnam Cornelio gayargan ishcay empliyäduncunata y Tayta Diosman mañacog juc yäracuy soldädunta. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Paycunatam angel ningancunata shumag willaparcur cachargan Jope marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tsaynam waraynin pullan junagnöna caycaptin Corneliupa cachancuna marcaman yaycuraycäyarganna. Pedroga wayi jananmanmi yarcushga caycargan Tayta Diosman mañacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Almorzay öra captinnam Pedroga mallagacuycurgan. Tsaynö micuyta munar shuyacuycangantam Tayta Diosman mañacuycargan. Nicangantanam ricasquirgan ciëlu quicharaycämogta. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tsaynam ciëlupita jatuncaray jacu nirag chuscun puntanpita watashga uraycämogta ricasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ñöpanman rataycuptin ricaycunanpänam canä Israel runacuna mana micuyänanpä cag imaycaläya animalcuna, pishgucuna, y hasta lätaypa puregcunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tsaychömi Pedro wiyanä ciëlupita Tayta Dios caynö nimogta: “Pedro, tsaycunata pishtascärir micuy” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tsaynam Pedro ninä: “Taytay, manam cay animalcunataga noga micümantsu. Manachä imaypis micurgötsu mana micuyänäpä niyämangayqui cagcunataga”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tsaynö niptinnam yapay nimunä: “Micunayquipä nicaptëga ¿imanirtä mana micogga canquimantsu?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pedruta tsaynö quimsa cutim ricatsir nimunä. Nircurnam Tayta Dios tsay jacuta llapan animalcunatawan ciëlupa cutitsicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tsaynam Pedro yarpachacurgan: “¿Imapärä cayta ricatsimashga?” nir. Tsaynö yarpachacuycaptinmi Cornelio cachacungan runacuna chäriyargan posadaraycangan wayiman. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chaycurnam tapucuyargan: “Tapucuyälläshayqui, taytay. ¿Pedro caychöcu patsarällan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tsayyagga ricangancunatam Pedro pasaypa yarpachacuycargan. Tsaynö yarpachacur caycaptinmi Espiritu Santo payta nirgan: “Quimsag juclä mana Israel runacunam ashiycäyäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ras sharcur yarpuy paycunawan aywanayquipä. Ama mantsariytsu. Nogam paycunata cachamurgö” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tsaynam wayi jananpita yarpascamur tsay runacunata Pedro nirgan: “Tsay ashiycäyangayqui runaga nogallächä callä. ¿Imallapätä miñishtiyämanqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tsaymi paycuna niyargan: “Capitan Cornelium cachayämashga gamman shayämunäpä, taytay. Payga alli runam. Tayta Diosta cäsurninmi runacunawanpis allilla cawan. Tsaynö captinmi payta cuyayan Israel runacunapis. Gamta capitanpa wayinman pushayänäpäshi Tayta Diospa angelnin yuripasquir nishga. Tsayshi aywayculläshun Diospa willacuyninta yachaycatsinayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsaynam tsay runacunata Pedro patsatsirgan posadarangan wayiman. Tsaypita warayninnam Pedro aywargan Cornelio cachacungan runacunawan. Paycunawanmi aywayargan tsay Jope marcapita waquin criyicogcunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aywayanganpita warayninrämi chäyargan Cesarea marcaman. Paycuna chäyänanpäga castancunawan y cuyanacungancunawanpis wayinchömi Cornelio shuyaraycäyargan Pedruta chasquiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chaycuptinnam Cornelio yargamurgan saludananpä. Nircurnam maquinta tsogpacurcur Pedrupa ñöpanman gonguricuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tsaymi Corneliuta Pedro nirgan: “Cornelio, ¡sharcuy! Nogapis gamnö runallam cä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tsaypitanam Corneliuwan parlar wayinman yaycuycarna tarirgan atsca runacuna goricashga caycäyagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tsaynam Pedro nirgan: “Gamcuna musyayanquim üsücunachö Israel runacunawan juclä runacuna mana juntacäyänäpä cagta ni wayincunamanpis mana yaycuyänäpä cagta. Tsaynö caycaptinpis Tayta Diosmi revelamar tantiyatsimashga mana Israel runacunamanpis chänäpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tsaymi gayatsimaptiqui juclla shamurgö. Canan mä nimay ari, imapä gayatsimangayquitapis, taytay”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tsaymi Cornelio nirgan: “Chuscu junagnam canannö tardipaypa mañacuycaptï röpanpis chipipiptinrä juc runa yuripämangan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tsay runam nimargan: ‘¡Cornelio! Tayta Dios wiyashgam mañacungayquicunata. Ricashgam pobricunata yanapangayquitapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Canan cachacuy runacunata Jope marcachö caycag Pedruta pushayämunanpä. Paymi tantiyatsishunqui Diospa willacuyninta. Y posadaraycan suëla rurag Simonpa wayinchömi. Simonpa wayinga lamar cuchunchömi caycan’. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tsaynö nimaptinmi juclla cachacamurgä pushaycayämushunayquipä. Shamungayquita pasaypam cushicuyällä, taytay. Caychö llapäcunam goricashga shuyaraycäyargö Tayta Dios nishungayquicunata willapaycayämänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsaynam Pedro parlar gallaycurgan caynö nir: “Tayta Diosga musyatsimashgam maytsaychö imaycaläya runacunatapis cuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Payga cuyapanmi imayca ricog runatapis munangannö cawag cagtaga. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Musyangayquinöpis Israel runacunamanmi Jesucristuta Tayta Dios cachamurgan alli willacuyninta willacuptin chasquicogcuna Tayta Dioswan allina cawayänanpä. Y Jesucristullam pitapis maytapis juzganga. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jesucristo manarä willacur gallaptinmi Juan Bautista Galilea provinciachö runacuna bautizacuyänanpä willacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tsay witsanmi Nazaret marcapita Jesuspis Tayta Diospa willacuyninta willacur gallaycurgan. Payman Espiritu Santuta Tayta Dios cachamurgan, tsay poderwan imaycatapis allita rurananpä. Tsaynam marcan marcan purirgan geshyagcunata allïtsir, runacunapita supaycunata gargur, y imayca allicunata rurar”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","40","“Nogacunam ricayargä Jerusalenchö, Judea provinciachö, y waquin marcacunachöpis Jesus llapan rurangancunata. Y paytaga cruzchömi wanutsiyargan. Tsaypita quimsa junagtaga Tayta Dios cawatsimurganmi. Tsaypitanam nogacuna cawaycagtana ricayargä. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Manam llapan runacunatsu cawamunganta ricayashga, sinöga willacuyänäpä Tayta Dios acrayämangan cagcunallam. Tsaymi wanunganpita cawamuptin paywan micuyargö y upuyargö. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nircurnam maytsaychöpis runacunaman Señor Jesus cachayämashga willacur musyatsiyänäpä wanushgacunata y cawaycagcunatapis paylla juzgananpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tsayta willacuycäyangänöllam Tayta Diospa willacognin unay profëtacunapis Jesucristupäga willacuyargan: ‘Tayta Dios cachamungan salvacogta pipis chasquicuptinga jutsancunapita perdonashgam canga’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Corneliupa wayinchö Jesucristupä Pedro willapaycaptinmi llapan goricashga caycag runacunaman Espiritu Santo chargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Tsaychö juc idiömacunapa parlatsiptinmi Tayta Dios cuyacog canganta cushishgalla alabayargan. Tsaynö parlayanganta wiyarnam Pedruwan aywag Israel runacuna espantacur niyargan: “¡Mana Israel runa caycäyaptinpis Tayta Dios paycunaman Espiritu Santuta cachaycamushgam!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tsaynam tsay Israel runacunata Pedro nirgan: “Nogantsicnö paycunapis Espiritu Santuta chasquicuycäyaptinga juclla bautizashun” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nircurnam Jesucristupa jutinchö bautizacuyänanpä nirgan. Tsaypitanam Corneliuwan goricäyag runacuna Pedruta rugayargan ishcay quimsa junagllapis paycunawan goyäriyänanpärä. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mana Israel runacunapis Tayta Diospa alli willacuyninta chasquicuyangantaga Judea provinciachö musyariyargannam apostolcuna y waquin criyicogcunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Tsaymi Jerusalenman Pedro cutiriptinna waquin Israel mayin criyicog cagcuna parlacachar niyargan: “¿Imanirtä mana Israel runacunapa wayinman yaycuyarguyqui y paycunawan juntacarcurrä micuyarguyqui?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tsaynö niyaptinmi imanir aywangantapis Pedro willapar gallaycurgan: ");
INSERT INTO qxoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jope marcachö Tayta Diosman mañacuycangächömi ricasquirgä jatuncaray jacunö chuscun puntanpa watashga ciëlupita uraycämogta. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tsay jacuchömi canä mana micunapä cag imaycaläya animalcuna, pishgucuna, y hasta lätaypa puregcuna. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tsaypitanam wiyargä ciëlupita caynö nimogta: ‘Tsaycunata pishtascärir micuy’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Tsaynö nimaptinmi nirgä: ‘Manam cay animalcunataga noga micümantsu, taytay. Imaypis manam micurgötsu mana micunäpä permitingayqui cagcunataga’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Tsaynö niptïnam ciëlupita yapay nimargan: ‘Micunayquipä nicaptëga ¿imanirtä mana micogga canquimantsu?’ ");
INSERT INTO qxoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tsaynö quimsa cuti niscamarmi tsay jacuta ciëlupa cutitsicurgan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Tsay öram patsaraycangä wayiman nogata ashiyämarnï chäyämurgan quimsa runacuna Cesarea marcapita. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tsaynam Espiritu Santo nimargan mana mantsacuypa paycunawan aywanäpä. Y caychö caycag jogta (6) waugicunawanmi aywayargä. Llapämi tsay gayatsimagnï mana Israel runapa wayinman yaycuyargä. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tsaychömi Cornelio willayämargan wayinchö Diospa angelnin yuripasquir caynö ninganta: ‘Cornelio, cachacuy Jope marcaman Pedruta pushayämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paymi nishunqui wayiquichö llapayquicuna imanöpa salvacuyänayquipä cagtapis’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Tsaynö Cornelio parlar ushariptinnam nogapis Jesucristupä willapar gallaycurgä. Tsaychönam nogantsicman Espiritu Santo shamungannölla paycunamanpis chascamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsay öram noga yarpacurcurgä Jesucristo caynö nimangantsicta: ‘Juan Bautistaga yacullawanmi bautizargan runacunata. Tayta Diosmi itsanga Espiritu Santuwan bautizayäshunqui’ ninganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tsay ningannöllam Jesucristuman criyicur yäracuynintsicpa Espiritu Santuta Tayta Dios nogantsicmanpis cachamushga. Paycunamanpis tsaynölla cachaycämuptinga nogaga ¿pinatä cä Tayta Dios ruranganta michäcunäpäga?” ");
INSERT INTO qxoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tsaynö Pedro willapäriptinnam tsay parlacachagcuna shumag tantiyacurir cushicurnin niyargan: “Tsayöraga mana Israel runacunapis jutsancunata jagirirnin perdonta chasquirnam, ¡Diosnintsicpa ñöpanchöna mana ushacag cawaychö cawayanga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wanutsiyanganpitaga Israel runacunapa autoridänincuna Jesusman criyicogcunata prësutsir maltratarmi gallaycuyargan. Tsaymi Jesusman criyicogcuna Jerusalenpita wacpa caypa geshpir aywacuyargan Fenicia marcacunaman, Chipriman, y Antioquia marcamanpis. Tsay marcacunaman chaycurmi Israel mayincunallata willapäyargan salvayänanpä Jesucristuta Tayta Dios cachamunganta. Mana Israel runacunataga manam pitapis willapäyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Imanö captinpis Chipripita y Cirenipita Antioquiaman aywag criyicogcunam itsanga mana Israel runacunatapis willacuyargan Jesucristuta chasquicur salvacuyänanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Paycunatam Tayta Dios shumag yanapargan tsaynö willacuyänanpä. Tsaynöpam imayca llutan ruraynincunata jagirir Jesucristuta atscag chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","24","Tsayta wiyarninmi apostolcuna Jerusalenpita Bernabeta cachayargan Antioquiaman. Bernabega Diosnintsicman shumag yäracog runam cargan. Payga Espiritu Santo munangannömi imaypis cawacog. Antioquiaman Bernabe chaycurmi ricargan runacuna Jesucristuta imanö chasquicuyangantapis. Tsaymi cushicurnin paycunata masrä valoratsirgan Jesucristo munangannö imaypis cawayänanpä. Tsaychö Bernabe shumag yachatsiptinmi mas atsca runacuna Jesucristuta chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsaypitanam Tarso marcamanna Bernabe aywargan Sauluta Antioquiaman pushamunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Antioquiaman paywan cutiycurnam juc wata entëru tsaychö ishcan täräyargan runacunata yachatsirnin. Antioquia marcachö runacunarämi Jesusman criyicogcunata “Cristiänucuna” niyta gallaycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tsay junagcunam Tayta Diospa willacognin profëtacuna Jerusalenpita chäyargan Antioquiaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Tsaychömi juc profëta Agabo jutiyogta Espiritu Santo musyatsirgan ima päsananpä cagtapis willacunanpä. Paymi willacur nirgan: “Feyupa muchuymi canga maytsaychöpis” nir. Tsaynö niptinmi Jesusman criyicogcuna willanacuyargan imaycatapis canganpita gorircur Judea provinciachö criyicogcunaman apatsiyänanpä. Tsay goriyangancunatam Bernabewan Saulo apayargan Judea provinciaman. Tsaychönam Señor Jesuspa willacuyninta yachatsicogcunaman entregayargan paycunana muchuy tiempu chämuptin aypuyänanpä. Agabo ningannöllam rasunpaypapis muchuy cargan rey Claudio Romachö maytsay nacioncunata mandangan witsan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tsay witsanmi Jerusalenchö Jesusman criyicogcunata rey Herodes prësutsir caycargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tsaychömi apostol Juanpa waugin Santiagutapis espädawan wanutsiyänanpä mandargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Santiaguta wanutsiyanganta musyasquirnam Israel runacuna cushicuyargan. Tsaymi levadüraynag tantata micuyänan Pascua fiesta semäna Pedrutapis tsaritsirgan wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedruta prësu tsariscatsirnam Herodes wichgatsirgan carcelman. Tsaychönam chunca jogta (16) soldäducunata churargan chuscu chuscuyan trocanacur cuïdayänanpä. Herodespa yarpayninga cargan Pascua fiesta ushayrä Pedruta carcelpita jipisquir chiquegnin Israel autoridäcunaman entregaycuymi. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Antis Jesusman criyicogcunaga Pedro wichgaraycaptin Tayta Diosmanmi pasaypa rugacur mañacuycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Israel autoridäcunaga listunam caycäyargan waraynin Pedruta wanutsiyänanpä. Payga cadinawan watashgam punuycargan ishcay soldäducunapa chöpinchö. Waquin cag soldäducunanam täpaycäyargan carcel puncuchöna. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tsaynö caycaptinnam Tayta Dios cachamungan angel atsicyarrä Pedruta yuripasquir wap ricchascatsir nirgan: “¡Apurä sharcuy, Pedro!” Niycuptin jinan öram Pedrupa maquinpita cadinacuna gotucasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tsaypitanam angel yapay nirgan: “¡Ras wachacacuy! ¡Llangiquitapis jaticuy!” nir. Jaticuriptinnam angel nirgan: “¡Punchuyquita jaticurcur gepalläta yargamuy!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tsaynam angelpa gepallanta Pedro aywargan. Peru manam allillaga cuentata gocurgantsu, suëñuycanganllata yarpar rasunpaypa yarguycangantaga. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Päsarirgannam soldäducuna täpaycäyaptin ruri cag puncucunatapis. Nircur wagta cag jërru puncuman chäriyaptin tsay puncupis quiquillanmi quichacasquirgan. Tsaynam wagtamanna yargusquiyargan. Tsaypitanam juc esquïnata aywaycäyaptinna angel illacasquiptin japallanna ticrasquirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tsaynam sïga Pedro rasunpa yarguycanganta tantiyasquir nirgan: “Cananmi itsanga rasunpaypa musyä Tayta Dios angelninta jipimänanpä cachaycamunganta. Tsaynö cachamurmi salvaycamashga Herodespa maquinpita y tsaynölla Israel autoridäcuna wanutsiyämänanpä cagpitapis”. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tsaycuna päsanganta tantiyacurirnam Pedro aywargan Marcospa maman Mariapa wayinman. Tsaychöga atscag goricaycurmi Pedrupä Tayta Diosman mañacuycäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tsay wayiman chaycur sawan puncuta Pedro tacacusquiptinnam yargamurgan Mariapa empliyädan Rode jutiyog jipash, pï cangantapis ricananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedrupa vozninta wiyaycurnam pasaypa cushicurnin puncutapis manarä quichapar cörrilla cutirgan puncuchö Pedro caycagta willacunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tsaynö willacuptinnam rurichö caycagcuna niyargan: “¿Imanöpatä payga canga? ¿Löcacu canqui o imam?” nir. Niyaptinpis “Manam ari. ¡Rasunpaypa Pedrum caycan!” nirganmi. Tsaynam paycuna niyargan: “¡Manam payga canmantsu! Angel parlamog imatachir wiyapacaycamurguyqui” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tsaynö ninacuyanganyagga masrämi Pedro puncuta tacacur gayacurgan. Tsaypita quichasquir Pedruta ricaycurnam itsanga espantacur mantsacäcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tsaynam maquillanwan upällacuyänanpä sëñasta rurapärirnin willapargan carcelpita imanöpa yargamungantapis. Tsaypitanam nirgan: “Carcelpita Tayta Dios jipimangantaga willapäyay Santiagutawan waquin cag criyicogcunatapis” nir. Tsaypita yargurirnam aywacurgan jucläcunapana. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Patsa wararcuptinnam Pedruta cuïdag soldäducuna ima päsangantapis mana tantiyar quiquin pura tapunacuyargan: “¿Maytä Pedroga?” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Carcelchö mana tariycuyaptinnam Herodes soldäduncunatawan maytsaypapis ashitsirnin cachargan yapay prësu tsariyänanpä. Mana tsariycayämuptinnam quiquincunata wanutsiyänanpäna nirgan. Tsaypitanam Judea provinciachö caycanganpita Herodes aywacurgan Cesarea marcaman juc tiempupä tärag. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Cesareapa lädun quinran Tiro y Sidon marcacunachömi muchuy cargan. Tsay runacunawan Herodes rabyacushga carmi tsay marcacunaman micuyta apayänanta munargantsu. Tsaynam runacuna willanacuyargan Cesareaman Herodeswan parlag aywayänanpä. Tsayman chaycurnam rey Herodespa yanapagnin Blasto jutiyog runawan amishtäta rurayargan. Paynam Herodesman pushargan parlacäshir caynö ninanpä: “Tiro y Sidon runacuna rugacuyanmi alli cawacuychöna cawacuyänayquipä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tsaynam Herodes tsay Tiro y Sidon marcapita aywag runacunawan juc junag goricäyänanpä jitapargan. Tsay jitapangan junag fiestamanrä camacashga captinmi llapan goricashga runacunata parlapänanpä jaticurgan mas allin cag röpanta. Nircurnam mandacur jamacuna trönunman jamaycurnin runacunata pasaypa shumag parlapaycamurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tsaynö parlamunganta wiyaycurmi llapan runacuna gayararrä niyargan: “¡Cay parlamogga diosmi, manam runallaga canmantsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tsaymi Herodes cushicurgan tsaychö runacuna “Gamga Diosmi canqui” niyaptin “Tayta Diosllata alabayay” ninanpa rantin. Tsaynö cushicunganpita jinan öram Tayta Diospa angelnin manana allïtsiypa geshyatsirgan. Tsay geshyawanmi pachanta curu ushaycaptin wanurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tsayyagnam Diospa alli willacuyninta willacuyaptin maytsaychöpis runacuna Señor Jesucristuta chasquicurnin atscagyäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabewan Saulunam apayangan caridäta Jerusalenchö criyicog pobricunata entregaycur Antioquiaman cuticuyargan Marcosta pushacurcur. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquia marcachömi Jesucristuman criyicogcunachö cayargan Tayta Diospa willacuyninta yachatsicogcuna. Paycunam cayargan Bernabe: “Yana Runa” ningan Simon, Cirenipita cag Lucio, Manaen, y Saulo. Manaenwan rey Herodesga tsay wayillachö shacshacogmi cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Juc junag Jesucristuman criyicogcuna goricaycur mañacur ayunaycäyaptinmi Espiritu Santo nirgan: “Bernabetawan Saulutaga Tayta Diosmi acrashga alli willacuyninta willacur puriyänanpä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tsaynö niptinmi bendisarnin umancunaman maquincunata churaycur paycunata yanapananpä Tayta Diosman mañacuyargan. Nircurnam cachayargan Jesucristupä willacur puriyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Tsaypitanam Espiritu Santo ningannö willacuyänanpä aywar Bernabewan Saulo chäyargan “Seleucia” ningan marcaman. Marcostapis pushayarganmi yanapagnincunapä. Tsaypitanam büquiwan aywayargan Chipre islaman. Tsaypita Salamina marcaman chaycurnam Israel runacuna goricäcuyänan wayicunachö Diospa willacuyninta willacur gallaycuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tsaynö willacur entëru Chipre marcacunapam puriyargan Pafos marcaman chäyanganyag. Tsaychömi tariyargan Israel runa Barjesus jutiyog brüjutapis. Payga “Diospa willacognin profëtam cä” nirmi runacunata pasaypa criyitsir ushag. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","8","Tsay brüjoga amishtäta rurargan Chipre isla marcacunapa mandagnin Sergio Pauluwanmi. Sergio Pauloga alli yarpayyog runa carmi Bernabetawan Sauluta gayatsirgan Diospa willacuyninta willapäyänanpä. Paycuna willapäyanganta shumag tantiyacurmi Jesucristuta chasquicuytana munargan. Peru tsaynö chasquicuyta munaycaptinpis tsay brüjoga michäcurmi Sergio Paulo chasquicunanta mana munargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tsaynö michäcuptinmi Saulo ajanargan. (Saulupaga jucag jutin cargan Pablum.) Tsaynö ajanarnam Espiritu Santo yanapaptin tsay brüjuta niycurgan: ");
INSERT INTO qxoNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“¡Gamga ruraycanqui Satanas munangantam! ¡Tsaymi Diosnintsicpa contran caycanqui! ¿Imanirtä Diospa willacuyninta runacuna chasquicuyänanta michäcunqui? ");
INSERT INTO qxoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","¡Tsaynö cangayquipitam Tayta Diospa castïgunwan gaprayanqui! Manaran atsicyag patsata ricanquirätsu” nir. Tsaynö nisquiptinmi jinan öra tsay brüju gapra ticrasquirgan. Tsaynam tsay brüju rugacurgan pillapis mayllapis jancharcur wayinman pushaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tsaynö gaprayanganta ricaycurmi Sergio Paulo espantacurgan Diosnintsic rasunpaypa poderyog canganta y jinan öram Jesucristuta chasquicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tsaypitanam büquiman yarcurcur Pablo aywargan yanapagnincunawan Pafos marcapita Panfilia provinciachö Perge marcaman. Tsaychö paycunata jagiriycurmi Marcos cuticurgan Jerusalenman. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pabluwan Bernabega aywacuyargan Pisidia provinciachö cag Antioquia marcamannam. Tsaychönam säbadu jamapay junag captin paycunapis Israel runacuna goricäcuyänan wayiman aywayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tsaychönam Diospa palabranta liyir ushasquir Bernabetawan Pabluta tsaychö yachatsicogcuna niyargan: “Waugicuna, imallapis yachatsiyämänayquipä captinga puntäcunaman shamusquir yachaycatsiyällämay” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsaynam ñöpancunaman aywaycur maquinta Pablo jayarirgan upällacuyänanpä. Nircurmi nirgan: “Israel runacuna y mana Israel runacunapis, cay yachatsicuyangäta shumag wiyayämay. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tayta Diosmi unay Abrahamta, Isaacta, y Jacobta nirgan paycunapita miragcunata imaypis yanapananpä. Tsay ningannöllam Jacobpa willcancuna Egiptuchöna mirayargan imaycayog ricacuyanganyag. Nircurnam Tayta Dios milagrucunata rurarnin Egiptuchö ñacacuypita jipimurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tsaypitam chuscu chunca (40) watantin tsunyag jircacunachö puriyargan. Tsaynö purir Tayta Dios ningancunata mana cäsucuyaptin pay castigarpis manam ushacätsirgantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tsaypitanam ‘Canaan’ ningan marcacunaman chätsirgan. Tsayman chaycatsirnam ganchis (7) puëdeg marcacunata ushacätsiyänanpä Tayta Dios yanapargan. Tsaypitanam paycunata tsay marcacunata raquinacuyänanpä entregargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","21","Tsay llapancuna päsargan chuscu pachac pitsga chunca (450) watacunachöran”. “Tsaypitanam tsay runacuna quejanacuyaptin arreglananpä Tayta Dios churargan juezcunata. Tsaynam willacognin profëta Samuel witsanna juezcuna cananpa rantinga Tayta Diosta rugacuyargan reynincuna churapänanpäna. Tsaymi rey cananpä Tayta Dios churapargan unay Benjaminpa miragnincunapita Cis jutiyog runapa tsurin Saulta. Paymi chuscu chunca (40) wata rey cargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsaypitanam Saulta rey cayninpita jipisquir Tayta Dios troquin churargan Davidtana rey cananpä. Davidpäga Tayta Dios caynömi nirgan: ‘Jesepa tsurin Davidmi itsanga llapan ningäcunata ruranga’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Rey Davidpa miragnincunapitam Tayta Dios cachamurgan Israel nacionman auningan salvacogta. Tsay salvacogga Jesucristum. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesucristo manarä willacur gallaptinmi Juan Bautista Israel runacunata willar nirgan: ‘Jutsayquicunata jagirir bautizacuyay’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tsaypita yapaypis Juan Bautistaga caynömi nirgan: ‘Salvacog cangäta yarpaycäyaptiquipis manam nogaga salvacogtsu cä. Runacunata salvananpäga jucrämi shamunga. Paymanga noga manam iwalätsu ni imallanmanpis’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Cananga Israel marca mayicuna y mana Israel runacunapis, shumag wiyayämay. Willacungäta chasquicurga llapayquipis salvacuyanquim. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalenchö runacuna ni autoridänincunapis manam tantiyayargantsu salvamänantsicpä Jesucristuta Tayta Dios cachamunganta. Tayta Diospa willacognin profëtacuna Jesucristupä gellgayangancunata cada säbadu jamapay junagchö liyiycarpis manam shumagga tantiyayargantsu, sinöga yarpäyargan Jesucristo runalla cangantam. Tsaynö mana tantiyarmi Jesucristuta wanutsiyargan. Tsay wanutsiyanganwanmi Tayta Diospa profëtancuna gellgayangan cumplirgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wanutsishga cananpä manam ni ima jutsantapis tariyargantsu. Tsaynö jutsanta mana tariycarpis Pilatumanmi entregaycuyargan imayca jutsayogtanöpis wanutsishga cananpä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Tsaycuna ruracanganwanmi llapanpis cumplirgan Tayta Diospa willacognin unay profëtacuna niyangan. Y cruzpita jipisquirmi Jesucristuta cuyag runacuna pampayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tsaypitaga Tayta Dios cawatsimurganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Cawascamurnam atsca cuti Señor Jesus yuripargan Galileapita Jerusalenman paywan pureg runacunata. Tsay runacunam Jesus cawarimunganta willacuraycäyan llapan runacunata”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Tsaymi nogacuna caychö caycäyä Diospa alli willacuyninta gamcunata musyatsiyänäpä. Salvacogta cachamunanpä Tayta Dios Israel runacunata unay auningannöllam cananga Jesucristuta cawaritsimurnin cumplishga. Jesucristo salvacog rey cananpä cagtanam ishcay cag Salmuchöpis gellgayargan Tayta Dios caynö ninganta: ‘Gamga cuyay tsurïmi canqui. Cananmi rey canayquipä ningä cumplishga’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Diospa palabran gellgaranganchö mastapis caynömi nimantsic: ‘Davidta auningäcunataga llapantam cumplishä’ nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tsay auninganpämi Bibliachö juc Salmutapis unay rey David caynö gellgargan: ‘Cuyangayqui cagtaga manam pamparanganllachöga jagirinquitsu, ni ayantapis ismunanta manam munanquitsu’. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davidga manam tsaynö gellgargan quiquinpätsu. Payta pampaycuyaptin ayanga ismurganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Peru Jesuspa ayanmi itsanga ismushgatsu. Tayta Dios payta cawatsimushga captin tsaynöpam cumplishga rey David unay gellgangan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Llapayqui waugicuna panicuna, canan ningäta shumag tantiyacuyay. Tayta Dios cawatsimungan Jesucristuta chasquicuyaptiquim jutsayquicunata perdonayäshunqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tsaynö perdonayäshunquillam Moises gellgangan leycunata cumpliyta mana puëdiyaptiquipis. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Jesucristuta mana chasquicog cagmi itsanga castigashga canga. Tsay mana chasquicogcunapämi Tayta Diospa willacognin unay profëtacunapis caynö gellgayargan: ‘Tayta Dios ninganta mana cäsucogcuna, pasaypa castigashga cayänayquipä cagta musyayay. Mana ichicllapis yarpäyangayquicunatam rurashä castigashga cayänayquipä’ ”. Tsaynam Bernabewan Pablo tsaynö willapäcur niyargan: “Cuïdacuyay gamcunapis. Pagtatä Jesucristuta mana chasquicuyangayquipita castigashga caycäyanquiman”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tsaynö nisquirmi goricäcuyänan wayipita yargucuyargan. Peru alli yachatsicuyashga cayaptinmi paycunata rugayargan jucag cag säbadupis yapay yachatsicuycuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Goricäcuyänan wayipita yargucuyaptinnam tsay Pisidia provinciachö tärag Israel runacuna y waquin jinan runacunapis Pablupa y Bernabepa gepanta atscag aywayargan. Paycunatam Pablo valoratsirgan cuyapäcog Tayta Diosman imaypis criyicur cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tsaypita yapay cag säbadu jamapay junagchönam tsay marcachö atsca runacuna goricäyargan Diospa willacuyninta wiyayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tsaynö goricäyanganta ricaycurmi mandacog Israel runacunaga Pablupa yachatsicuyninpä “Llullacogmi” nir contran sharcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsaynö niyaptinmi Bernabewan Pablo mana mantsacuypa niyargan: “Israel runacuna cayaptiquim gamcunatarä puntata Diospa willacuyninta willapäyä. Tayta Dioswanna cawayänayquipä cagta willapäyaptïpis gamcuna manam chasquicuyanquitsu. Tsaynö cayaptiqui cananga juccunatana willapäyäshä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Llapan runacunata willapäyänätam Tayta Diosga munan. Palabran gellgaranganchöpis caynömi nican: ‘Israel runacunaman willacuynïta churargö llapan nacioncunaman chätsiyänayquipämi. Willapäyangayquita chasquicurmi maytsaychöpis runacuna salvacuyanga’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tsaynö Pabluwan Bernabe parlayanganta wiyarmi mana Israel cag runacuna pasaypa cushicuyargan, paycunapäpis salvacion canganta tantiyarnin. Tsaymi Señor Jesusman criyicurnin Tayta Dios acrangan cagcuna willacuyninta chasquicuyargan gloriachöna cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tsaynömi Diosnintsicpa willacuyninga tsay Pisidia quinran marcacunapa musyatsicush cargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tsaymi mandacog Israel runacunaga Diosman mañacog warmicunata y marca autoridäcunatapis aquishaparnin sharcatsipäyargan Bernabetawan Pabluta chiquiyänanpä. Tsaynö chiquiparninmi Israel runacuna Bernabetawan Pabluta garguyargan tsay marcacunapita. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsaynö garguyaptinmi chaquincunachö polvuta tapsicusquir aywacuyargan caynö nir: “Willapäyangäta mana chasquicuyangayquichöga alfin quiquiquicunanam jutsayog cayanqui Tayta Dios castigayäshunayquipä”. Nisquirnam Iconio marcapana aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesusman criyicogcunaga Espiritu Santo imaycachöpis yanapaptin cushishgam cawacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio marcachöna caycarnam Bernabewan Pablo aywayargan Israel runacuna goricäcuyänan wayiman. Tsaychö shonguncunaman yaycog yaycog parlapaycuyaptinmi Israel runacuna y mana Israel runacunapis Jesucristuta chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tsaynö chasquicuyaptinmi waquin cag Israel runacuna ajanarnin mana Israel runacunata sharcatsipäyargan Jesusta chasquicogcunata chiquiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tsaychömi Bernabewan Pablo juc ishcay semäna cayargan. Paycunaga Diosnintsicman yäracurninmi pitapis mana mantsacuypa willacuyargan caynö: “Tayta Dios cuyapäcog carmi tsurin Jesucristuta cachamurgan salvamänantsicpä” nir. Tsay willacuyangan rasunpaypa canganta runacuna musyayänanpämi Bernabetawan Pabluta Tayta Dios yanapargan milagrucunata rurayänanpäpis. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tsaychö Jesucristupä willacuyaptin runacunaga manam juc yarpayyogllatsu cayargan. Waquin runacuna cushicuywan apostolcuna parlayanganta wiyayaptinpis waquincunaga contrancunam sharcuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tsaymi tsay contrag cagcunaga, Israel runacuna y mana Israel runacunapis, autoridäcunawan willanacuyargan Bernabetawan Pabluta samgaypa wanutsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tsayta musyaycur geshpicuyanganchömi Licaonia provinciaman chäyargan. Tsaypitanam aywacuyargan Listra marcaman, Derbe marcaman, y tsay provinciachö mas waquin marcacunamanpis. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tsay marcacunachöpis Diospa alli willacuyninta willacuyarganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra marcachönam juc ratayashga runa cargan, yuringanpita pasaypapis mana pureg. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tsay runaga jamaraycargan Pablo parlangancunata wiyarmi. Tsayta ricärir Pabloga tantiyasquirgan tsay runa Tayta Diosman yäracur allïrinanpä cagtam. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tsaymi llapan callpanwan nirgan: “¡Sharcurcur shumag ichiy!” Tsaynö niycuptinmi wap ichircurnin purir gallaycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tsayta ricaycurmi quiquincunapa parlacuynincunachö runacuna cushicurnin niyargan: “¡Dioscunam runa tucuycullar nogantsicman shayämushga!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabepämi yarpäyargan “Zeus” ningan diosnincuna canganta. Y Pablupänam, willacog captin, yarpäyargan “Hermes” ningan diosnincuna canganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tsay Listra marcaman yaycunachömi “Zeus” ningan diosnincunata adoracuyänan wayi cargan. Tsay wayichö sirveg sacerdötim puncuman apamurgan waytan wallgashga törucunata. Tsaychömi llapan runacuna apostolcunata adorarnin tsay törucunata rupatsipayta munayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tsaynö adorayta munayanganta tantiyasquirnam Bernabewan Pablo pasaypa llaquinar jatiräyangan röpancunatapis rachiscäriyargan. Nircurmi runacunaman aywaycur niyargan: ");
INSERT INTO qxoNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“¡Imapätä tsaycunata rurayanqui! Nogacunapis gamcunanö runallam cayä. Gamcunaman willagniquicuna shayämurgö tsay dioscunata adorar llutanta ruraycäyangayquicunata jagirir rasunpa cag cawag Diostana adorayänayquipämi. Paymi cay imaycacunata camargan, ciëlutapis, cay patsatapis, lamartapis, llapan imaycacunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tayta Dios munanganman cawayänayquipä cagta mana tantiyarmi quiquiquicuna munayangayquita rurar cawaycäyanqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tsaynö cayaptiquipis Tayta Dios poderösu canganta musyatsicurmi mana jagiriyäshurgayquitsu, sinöga imaypis yanapayäshurguyquim. Pay tamyatsimuptinmi cosëchata alli goriyanqui cushishga cawayänayquipä. Tsaynöpam tantiyaycätsiyäshunqui cuyapäcog Dios canganta. Tsayta shumag tantiyacur cananga paytana chasquicuyay”. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tsaynö Pabluwan Bernabe niyaptinpis tsay runacuna paycunata diostanö adorayta munayaptin michaycuyänanpäga ajam cargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsaypita waraynincunanam apostolcunata chiqueg Israel runacuna Antioquia marcapita y Iconio marcapita chäyargan. Paycunam apostolcunapa contran parlayargan runacunata aquishaparnin. Paycuna niyanganta cäsurnam runacuna Pabluta samgayargan wanushnö jitacagpä. Nircur wanushgana canganta yarparmi garachashga apaycur marca cuchunman jitasquiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tsaynam Jesusman criyicogcuna jitaraycangan cagman goricäyargan Pabluta apayänanpä. Tsaynö juntaparaycäyaptinmi sharcurcur tsay marcaman cangan cutiycurgan. Tsaypita warayninnam Bernabewan aywacuyargan Derbe marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tsay Derbe marcaman chaycurnam Diospa alli willacuyninta willacuyargan. Tsaynö willacuyaptinmi atsca runacuna Señor Jesusman criyicuyargan. Nircurnam cutiyargan Antioquia, Listra, y Iconio marcacunaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tsay marcacunaman chaycurmi Jesusman criyicogcunata valoratsiyargan Tayta Diosman mana ajayaypa yäracuyänanpä. Tsaynöpis shumagmi tantiyatsipäyargan Jesusman criyicuyanganpita imaypis runacuna chiquiyänanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tsaynöllam cada marcachö yachatsicogcunata churayargan criyicogcunata ricayänanpä y shumag yachatsiyänanpä. Nircurnam ayunarnin Tayta Diosman mañacuyargan paycunata imaypis yanapaycunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tsaypita Pisidia provinciapa päsarnam chäyargan Panfilia provinciamanna. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tsaypita päsagnönam Perge marcachöpis Diospa willacuyninta willacuyargan. Nircurnam aywayargan Atalia marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tsaypitanam büquiwanna Siria provinciachö Antioquia marcaman cuticuyargan. Tsay marcapitam Jesucristuman criyicogcuna paycunata puntata cachayargan maytsaypapis willacur puriyänanpä. Tsaynö willacuyänanpämi Tayta Diosman mañacuyargan yanapananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tsay Antioquia marcaman cutisquirnam Jesusman criyicogcunata gayatsirnin cushicur willapäyargan caynö: “¡Willacuyninta willacuyänäpä Diosnintsic shumagmi yanapaycayämashga! ¡Tsaymi mana Israel runacunapis chasquicuyashga! ¡Paycunapis cananga Jesucristumannam criyicuycäyan!” nir. Tsaynö willacuyaptinmi llapancuna pasaypa cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pabluwan Bernabega atsca quillacunam tsaychö criyicogcunata yachatsir cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pabluwan Bernabe Antioquiachö caycäyaptinmi Judea provinciapita criyicogcuna chäyargan. Paycunam tsaychö criyicogcunata caynö yachatsir gallaycuyargan: “Moises gellgangan ley ningannö cuerpuyquicunata señalacurrämi salvacuyanqui” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tsaynö llutanta yachatsicuyaptinmi paycunawan Bernabe y Pablo pasaypa rimanacuyargan tsay Judea provinciapita yachatsicogcunawan. Tsaynö rimanacuyaptinmi Antioquiachö criyicogcuna Bernabetawan Pabluta niyargan: “Mejor aywacuyay Jerusalenman. Tsaychönam apostolcunawan y mas yachatsicog waugicunawanpis shumag arreglayämunqui señalacunantsicpä o mana señalacunantsicpä cangantapis”. Tsaynö nirninmi mas criyicog waugicunatapis acrayargan paycunawan Jerusalenman aywayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tsay aywarmi Fenicia y Samaria provinciacunamanpis chäyargan. Tsay marcacunachöpis musyatsicuyarganmi mana Israel runacunapis paycuna willacuyaptin chasquicuyanganta. Tsaynö willapäyaptinmi Jesucristuman criyicogcuna cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalenman chäriyaptinnam Pablutawan Bernabeta chasquicuyargan apostolcuna, yachatsicogcuna, y Jesucristuman llapan criyicogcuna. Tsaychönam Bernabewan Pablo paycunata willapäyargan maypa tsaypa puriyaptinpis Tayta Dios yanapanganta y mana Israel runacunapis salvacuyänanpä Jesucristuta chasquicuyanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tsaynam Jesucristuman criyicog cag fariseo runacuna ichircur niyargan: “Manam paycuna salvacuyangatsu Moisespa leynincunata mana cumplirga ni cuerpuncunata mana señalacurga” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tsaynö niyaptinnam apostolcuna y yachatsicogcuna goricäyargan tsay señalacuy asuntuta parlayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tsaychö rimanacur pasaypa parlaycäyaptinmi Pedro nirgan: “Waugicuna, musyayanquim juc cuti mana Israel runacunaman willacuyninta musyatsicunäpä Tayta Dios mandamanganta. Tsaynö mandamargan paycunapis Señor Jesucristuta chasquicur salvacuyänanpämi. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mandamangannöllam tsay runacunapis Diospa willacuyninta willapaptï chasquicuyashga. Tsayta musyarmi Diosnintsic Espiritu Santuta paycunamanpis cachamushga. Nogantsic chasquicungantsicnöllam paycunapis Espiritu Santuta chasquicuyashga. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tsaynöpam musyantsic Jesucristuman criyicur yäracog cagta, Israel runa o mana Israel runa captinpis, Tayta Dios perdonar salvanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tsaynö caycaptinga ¿imanöpatä mana Israel cagtaga: ‘Salvacuyänayquipäga Moises gellgangan leynincunatarä cumpliyanquiman’ nishun? Tsaycunataga unay Israel runacunapis ni quiquintsiccunapis manam cumpliyta puëdintsictsu. ¿Imanirtä Tayta Dios ruranganta manacagman churayta munayanqui? ");
INSERT INTO qxoNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","¡Manam tsay leycunata cumplingantsicpitatsu salvacuntsic, sinöga Señornintsic Jesucristum cuyapämarnintsic salvamantsic nogantsictapis y paycunatapis!” ");
INSERT INTO qxoNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tsaynö Pedro niptinmi tsaychö caycag runacuna llapan upällacurcuyargan. Tsaynam Bernabewan Pablo willapäyargan Tayta Diospa poderninwan mana Israel runacunachöpis milagrucunata rurayanganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tsaynö willapayta ushasquiyaptinmi Santiago nirgan: “Waugicuna, wiyayämay. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pedro willamarguntsic Tayta Dios cuyaparnin tsay mana Israel runacunatapis Jesucristuta chasquicog cagcunataga salvangantam. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pedro willapämangantsicnöllam Tayta Dios willacognin unay profëtacunawanpis willacatsirgan caynö: ");
INSERT INTO qxoNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Israel nacionchö Davidpa castanpita rey manana captinpis churashä paypita miragcunallapitam rey cananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tsaynö rurashä Israel runacunapis y mana Israel runacunapis nogaman yäracayämunanpämi. Tsaynö ruraptïmi llapan acrangä cag runacuna salvacuyanga. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tsaynö päsananpä cagtam Tayta Dios unaypitapis musyatsimargantsic’ ”. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tsaycunata yarparcatsirmi Santiago mastapis nirgan: “Tayta Dios tsaynö nicaptinga Jesucristuman criyicog mana Israel runacunatapis ama pantatsishuntsu. Ni ama obligashuntsu: ‘Moises gellgangan leycunatarä cumpliyay salvacuyänayquipäga’ nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tsaypa rantinga antis llapan criyicogcuna alli ricanacuyänanpä cartata apatsishun. Tsay cartachö mana Israel runacunata willashun ïdulucunapa altarninchö pishtayangan aytsata mana micuyänanpä, majaynagrä cagcuna piwanpis mana cacuyänanpä, majayog cagcunapis juccunawan mana puriyänanpä, yawarnin mana yargushga cag ashmacunapa aytsanta mana micuyänanpä, ni ima ashmapa yawarnintapis mana micuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tsaynö cawayänanpäga Moises gellgangan leycunatam goricäcuyänan wayicunachöpis cada säbadu jamapay junagchö yachatsicuycäyan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tsaynö Santiago nisquiptinnam apostolcuna, yachatsicogcuna, y Señor Jesucristuman llapan criyicogcuna ishcay runacunata acrayargan Bernabewan Pablo Antioquiaman cutiyaptin wallquiyänanpä. Tsay acrashga runacunam cayargan Judaswan Silas. Judaspa jucag jutinmi cargan Barsabas. Paycunaga llapan criyicogcunapita mas respëtuwan ricashgam cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawanmi cartata apatsiyargan Antioquiachö criyicogcunaman. Tsay cartachömi caynö nirgan: Antioquia marcachö cuyay waugicuna panicuna, Siria y Cilicia provinciacunachöpis cuyay waugicuna panicuna: Jerusalenchö apostolcuna y yachatsicog waugiquicuna carmi gamcunata saludayarniqui cartacarayämü. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nogacuna musyayargömi waquin runacuna gamcuna cagman shamur llutancunata yachatsiyäshungayquicunata. Manam paycunataga nogacunatsu cachayämurgö. Mana cachaycäyämuptïpis paycunaga gamcunata pantatsirmi llutancunata yachatsiyäshurguyqui: “Salvacuyänayquipäga cuerpuyquicunatarä señalacuyay y Moises gellgangan llapan leycunatarä cumpliyay” niyäshurniqui. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","Tsayta musyaycurmi llapäcuna willanacuyargö gamcuna cagman Judasta y Silasta cachayämunäpä. Paycunam tantiyatsiyäshunqui cay cartachö niyämungänölla. Bernabewan y Pabluwanmi paycuna shayämunga. Musyayangayquinöpis Bernabewan Pabloga wanuytapis mana mantsariypam Señornintsic Jesucristuta salvamänantsicpä Tayta Dios cachamunganta willacuycäyan. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Espiritu Santum tantiyatsiyämashga cuerpuyquicunata mana señalacurpis salvacuyänayquipä cagta. Tsaymi willanacuyargö ïdulucunapa altarninchö pishtayangan aytsata mana micuyänayquipä, ima ashmapa yawarnincunatapis mana micuyänayquipä, yawarnin mana yargushga cag ashmacunapa aytsanta mana micuyänayquipä, majaynagrä cagcuna piwanpis mana cacuyänayquipä, y majayog cagcunapis juccunawan mana puriyänayquipä. Cay cartachö niyämungäcunata cumplirninga allim cawayanqui. Tsayllatam niyämü cuyay waugicuna panicuna. Diosnintsic yanapaycuyäshuy. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tsaynam tsay willanacuyangannölla chuscun willacog waugicuna aywacuyargan Antioquiaman. Tsayman chaycurmi Jesucristuman llapan criyicogcunata musyatsir goriyargan apayangan cartata liyipäyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tsay cartata liyipäriyaptinmi llapancuna cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tsaychö Judaswan Silas Diospa willacognincuna carnam criyicogcunata shumag tantiyatsir valoratsiyargan Tayta Diosllaman yäracurnin imaypis cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tsaychö paycunawan juc ishcay junag goyäpäriyaptinnam Tayta Diosta agradesicurnin Señor Jesusman criyicog waugicuna Judastawan Silasta despidicuyargan Jerusalenman cuticuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bernabewan Pablum itsanga Antioquiachö quëdacuyargan waquin criyicogcunawan Diospa alli willacuyninta yachatsir cayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Antioquiachö unaymanpa carirnam Bernabeta Pablo nirgan: “Acu watucaramushunrä Diospa willacuyninta willapangantsic marcacunachö waugicunata y panicunata. Mä, ¿imanöshi caycäyan?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Tsaynö willanacurirmi Bernabega pushayta munargan Marcosta. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablum itsanga Marcosta pushayta munargantsu, punta cag aywaynincunachö Panfilia provinciapita jagiriycur aywacushga captin. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tsaynö Pablo apayta mana munaptinnam tsay janan rimanacuyargan Bernabewan. Tsaynö rimanacurirnam Marcosta pushacurcur Bernabe büquiwan aywacurgan Chipre islaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Tsaynam Pabluna Jerusalenpita Silasta gayatsimurgan wallquicunanpä. Tsaychö Jesucristuman criyicogcunanam Tayta Diosman mañacuyargan tsay willacungan marcacunaman cutiyaptin paycunata yanapananpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria y Cilicia provinciacunachö marcacunaman chaycurnam Pabluwan Silas tsaychö criyicogcunata yachatsir valoratsiyargan Tayta Dios munangannö shumag cawayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tsaypitanam Derbe marcaman Pabluwan Silas chäyargan. Nircurnam Listra marcaman chäyargan. Tsaychönam Timoteuwan reginacuyargan. Timoteupa taytan mana Israel runa captinpis mamanga Israel castam cargan. Jesucristuman criyicogcunam cayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra y Iconio quinran marcacunachö criyicogcunapis parlayargan Timoteupäga alli jövin cangantam. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Timoteupa taytan mana Israel runa captin Israel runacuna musyayarganmi Timoteuta mana señalatsishga canganta. Tsaymi Pablo señalatsirgan wallquicuyta munar Israel marca mayincuna mana jamuräyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tsaypita quimsancunanam marcan marcan puriyargan Tayta Diospa willacuyninta willacuraycar. Chäyangan marcacunachömi apostolcuna apatsiyangan cartata liyipäyargan Israel runacunapa leynincunata llapanta mana cumplirpis salvacuyänanpä cagta. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tsaynö shumag tantiyatsiyaptinmi tsaychö criyicogcuna pasaypa cushicuyargan. Y cada junagmi runacuna Señor Jesucristuta chasquicur masrä atscagyäyag. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsaypitam Pablo wallquegnincunawan Asia provinciaman aywayta munayargan Diospa willacuyninta willacuyänanpä. Tsaynö yarpaptinpis Espiritu Santo manam tsaypa aywayänanta munargantsu. Tsaynam Frigia y Galacia provinciacunachö marcacunaman chaycuyarnin willacuyargan Tayta Diospa alli willacuyninta. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","“Misia” ningan provinciaman chaycurnam aywayta munayargan Bitinia provinciamanna. Tsaypis Espiritu Santo manam munargantsu tsaypa aywayänanta. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tsaynam Misia provinciapa päsarnin chäyargan Troas marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tsaychönam suëñuyninchö Pablo ricargan Macedonia provinciapita juc runa caynö rugaycagta: “Cayman tsimpaycallämuy nogacunatawan yanapaycayämänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo tsaynö ricanganta nogacunata willayämaptinmi tantiyasquiyargä tsay marcacunamanpis willacuyninta chätsiyänäpä Tayta Dios munanganta. Tsaymi juclla alistacuyargä Macedoniaman aywayänäpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tsaynam Troas marcapita büquiwan aywar chäyargä “Samotracia” ningan islaman. Tsaypita waraynin junagrämi chäyargä Neapolis marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tsaypita Macedonia provinciaman päsarnam chäyargä Filipos marcaman. Tsay marcaga cargan Roma runacuna täcuyänan marcam. Tsay marcachöga juc ishcay junagcunam goyäriyargärä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tsaychö goyarmi musyayargä Tayta Diosman mañacuyänanpä Israel runacuna mayu cuchullanman imaypis goricäyanganta. Tsaymi säbadu jamapay junag captin nogacunapis tsayman aywayargä. Tsaychömi tsay goricashga caycag warmicunata Tayta Diospa willacuyninta willapäyargä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tsay warmicunawanmi caycänä Tayta Diosta cäsucog Lidia jutiyog warmipis. Payga Tiatira marcapitam cargan. Y morädu fïnu tëlacunatam ranticog. Tsaychö Señor Jesucristo salvacog canganta Pablo parlapaptinmi tsay warmi shumag tantiyacur Jesucristuta chasquicurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Tsaypitanam Lidia y castancunapis bautizacuyargan. Nircurnam nogacunata rugacayämargan caynö nir: “Nogacuna Jesucristuta chasquicushgana caycäyaptëga wayïman aywayculläshun tsaychö posadatsiyänäpä, taytay”. Tsaynö niyämaptinmi posadacuyargä paypa wayinchö. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Juc cutinam Diosman mañacucuyänan mayu cuchunman aywaycäyangächö tincucurcuyargä juc empliyäda jipashwan. Payga supaypa poderninwanmi suertita gatipacog. Tsay jipashga cösa suertita ricapacurmi patronnincunatapis pasaypa rïcuyaycatseg. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tsay jipashmi nogacunata gayaraypa gayararrä parlar gatiräyämargan: “¡Cay runacunaga Tayta Diospa sirvegnincunam cayan! ¡Paycunam gamcunata willapäyäshunqui imanöpa salvacuyänayquipä cagtapis!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tsaynö cada junag büllata rurar gatiräyämaptinmi Pablo ajarnin tsay jipashchö supayta nirgan: “¡Señor Jesucristupa poderninwanmi gam supayta gargü cay jipashpita yargunayquipä!” nir. Tsaynö niycuptinmi jinan öra tsay jipashpita supay yargurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tsaynam tsay jipashpa patronnincuna gellëta manana chätsipaptin prësuna tsariyargan Silastawan Pabluta. Nircurnam autoridäcunaman apayargan pläzachö llapan runacunapa ñöpanchö juzgayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","22","Autoridäcunaman apayaptinmi atsca runacunapis paycunata gatiräyargan. Chaycatsirmi Pabluta tumparnin niyargan: “Cay Israel runacunam marcantsicchö runacunata llutanta yachaycätsin. Y nircurmi yachatsicuycäyan Israel runacunapa üsuncunata ruranantsicpä. Nogantsicga Romano runa carnin manam tsay üsucunataga chasquipashwantsu. Tsaynö yachatsicuyaptinmi runacuna pasaypa rabyashga caycäyan” nir. Tsaynö niyaptinmi tsay gatirag runacunapis Pablucunapa contranna sharcuyargan. Tsaymi autoridäcunapis Pablupa y Silaspa röpancunata llogticaratsir wirutsir ushayargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tsaynö wirurcatsirnam paycunata carcelman wichgatsiyargan. Nircurnam prësucuna cuïdag runata cösa yätsiyargan següru catsiyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tsaynö niyaptinmi tsay carcelchö cuïdag runa wichgargan mas rurichö cag calapözuman. Nircurmi chaquincunatapis uchcushga racta tablaman amutsiyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tsaypita pullan pagaschönöna caycarnam Silaswan Pablo Tayta Diosman mañacur cantayargan. Waquin prësucunanam tsaynö cantayaptin wiyaparäyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tsay öram pasaypa patsa cuyur gallaycurgan. Carcelpa cimientuncunapis shoglliptin carcel puncucunapis jucllam quichacascärirgan. Prësucuna wataräyangan cadinacunapis pascacascärirganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tsaynam prësucunata cuïdag runapis patsa cuyuptin ricchacarcamur ricargan llapan puncucuna quicharar caycagta. Tsaymi prësucuna geshpiyanganta yarpar espädanta jipirir quiquin wanutsicuriyta munargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tsaynö wanutsicuyta munaptinmi Pablo gayacurgan: “¡Ama tsaytaga ruracuytsu! ¡Llapäcunam caychö caycäyä!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tsaymi prësucunata cuïdag runaga actsicurcur rurichö cag calapözuman cörrilla aywargan. Pabluwan Silas caycanganman yaycurirnam mantsariywan tsuctsucyarnin ñöpancunaman gonguricuycurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nircurnam carcelpita paycunata jipirir tapurgan: “¿Imatarä ruräman salvacunäpäga, taytay?” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tsaymi Pabluwan Silas niyargan: “Señor Jesusman criyirnin yäracuy. Tsaynö carninga gampis y wayiquichö castayquicunapis criyicur salvacuyanquim” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nircur wayinman pushaycuptinnam tsay runata y castancunatawan willapar tantiyatsirgan Jesucristulla salvacog canganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tsaymi prësucuna cuïdag runaga Silastawan Pabluta jinan öra jampipargan runacuna magayangancunata. Nircurnam pagas öra Jesucristuta chasquicurnin paypis y castancunapis juclla bautizacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tsaypitam micuyta cusnascatsir wayinchö garargan. Jesucristuman criyicurninna Tayta Diosman yäracurninmi tsaychö llapan castancunawan pasaypa cushicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Warayninnam autoridäcuna wardiyacunata cachayargan prësucuna cuïdag runaman, Silastawan Pabluta cachaycuyänanpä negnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tsaymi tsay cuïdag runa Pabluta willargan: “Autoridäcunam willacatsiyämushga gamcunata cachaycuyänäpä. Cananga aywacuyanquinash” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tsaymi wardiyacunata Pablo nirgan: “Romano runa caycäyaptïpis llapan runacunapa ñöpancunachömi nogacunata wirutsiyämashga, maypita cayangätapis ni imata rurayangätapis manarä juzgayämar. Tsaynö mana tapuyämayllapam cay carcelmanpis wichgatsiyämashga. Cananga ¿runacunata mana musyatsiyllapacu carcelpita gargarayämayta munayan? Manam tsaypis tsaynötsu. ¡Quiquincunarä shayämutsun wichgatsiyämangannölla jipiyämänanpä!” ");
INSERT INTO qxoNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","39","Tsaynö niptinmi wardiyacuna autoridäcunaman cutiycurnin willayargan Silaswan Pablo Romano mayincuna cayanganta. Tsayta musyaycurmi autoridäcuna mantsarirnin aywayargan Pabluwan Silas wichgaraycangan cagman caynö nirnin: “Roma mayïcuna cangayquita mana musyarmi tsaynö castigaycatsiyargö, taytay. Perdonaycayällämay” nir. Nircurnam carcelpita jipirir rugayargan tsay marcapita aywacuyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carcelpita yargurirninnam Silaswan Pablo cuticuyargan Lidiapa wayinman. Tsaychömi Jesucristuman llapan criyicogcunata valoratsiyargan Tayta Diosman imaypis yäracuyänanpä. Nircurnam juclä marcapana aywacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tsaypita Anfipolis y Apolonia marcacunapa aywarmi Pabluwan Silas chäyargan Tesalonica marcamanpis. Tsay marcachöga Israel runacuna goricäcuyänan wayi carganmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Maychöpis aywangannömi Pabloga aywargan tsay goricäcuyänan wayimanpis. Tsaychömi quimsa jamapay säbadu yachatsicurgan caynö nir: ");
INSERT INTO qxoNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Diospa palabran gellgaranganchömi nimantsic salvamagnintsic wanunanpä canganta y cawamunanpä canganta. Tsay gellgarangannöllam Jesusga wanunganpita cawamushga. Tsaynöpam musyantsic Tayta Dios cachamungan salvamagnintsic canganta. Tsaymi noga paypä willacur puriycä”. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tsaynö shumag yachatsiyaptinmi waquin Israel runacunapis, mana Israel runacunapis, y regishga rïca warmicunapis Jesucristuta chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Waquin cag Israel runacunam itsanga Silaspa y Pablupa contran sharcuyargan. Tsaymi mana alli cawacog runacunata goriycur Silastawan Pabluta contrayänanpä aquishapar niyargan. Tsaynam tsay mana alli runacunana mas atsca mana alli mayincunata gorircur Jasonpa wayinman yaycuyargan Silastawan Pabluta prësu tsariyänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tsaychö mana tariycurnam Jasontawan waquin cag criyicogcunata autoridäcunaman garachashga apayargan gayararrä: “¡Pabluwan y Silaswan pureg runacunam maytsaychöpis llutancunata yachatsicuyan! ¡Cananga cä nogantsicmanna chärayämushga runacunata llutancunata yachatsiyänanpä! ");
INSERT INTO qxoNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Jasonmi tsay runacunata chasquipar wayinman posadatsishga! ¡Paycunaga niyan Romachö mandamagnintsicpitapis mas juc mandacog rey cangantam! Tsay mandacogga Jesus jutiyog runash. ¡Tsaynö nirninmi leynintsiccunataga cäsuyannatsu!” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tsaynö niyaptinmi tsaychö caycag runacuna y autoridäcuna imanö caytapis mana camäpacuyargantsu. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tsaynam imanö caytapis mana puëdiyaptinna Jasonwan waquin cag criyicogcuna gellëta garantiya churaycur yarguyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tsaynam tsay Tesalonicachö Jesusman criyicogcuna Silastawan Pabluta tsay tsacay despachariycuyargan Berea marcaman geshpicuyänanpä. Tsay marcaman chaycurmi säbadu jamapay junag aywayargan Israel runacuna mañacur goricäcuyänan wayiman. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tsay Berea marcachö runacunaga manam Tesalonica marca runacunanötsu cayargan. Paycunaga cushishgam chasquicuyargan Pablo willacungancunata. Tsaychö cada junagmi Pablo yachatsicungancunata Diospa palabran gellgaranganman iwalatsiyag yachatsicuyangan rasunpa canganta musyayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tsaynö yachatsiyanganta tantiyarninmi Jesucristuman atscag runacuna criyicuyargan, Israel runacuna y mana Israel runacunapis. Tsaynömi criyicuyargan regishga rïca warmicunapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tsaypita Berea marcachöna Pablo yachatsicuycanganta musyarirnam Tesalonica marcachö contran sharcog runacuna Bereamanna aywayargan tsaychöpis Pablupa contran sharcuyänanpä aquishapagnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tsaychönam Jesucristuman criyicog waugicuna Pabluta jinan öra lamar cuchunman geshpicunanpä despachariycuyargan. Silaswan Timoteunam Bereachö quëdacuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lamar cuchunman chaycurnam wallquegnincuna Pabluta päsatsiyargan Atenas marcaman. Tsaypitana Bereaman cuticuyaptinnam Pablo yätsirgan Silastawan Timoteuta pay caycangan cagman juclla cachayämunanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenas marcachö Silastawan Timoteuta shuyacuycarmi Pablo feyupa yarpachacur llaquicurgan maytsaychö ïdulucunata runacuna adoraycäyanganta ricar. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tsaychö goricäcuyänan wayicunaman aywaycurmi Israel runacunata y mana Israel runacunatapis tantiyatsirgan Jesucristulla salvacog canganta. Cada junagmi pläzachö llapan runacuna wiyayänanpä yachatsicurgan ïdulucunata adorayänanpa rantin Jesucristuta chasquicur Tayta Diosllatana adorayänanpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tsaynömi “Epicureo” y “Estoico” ningan creyenciacunata yachacog runacunapis pläzachöga goricäyag. Tsaymi paycunawanpis Pablo tantiyatsinacur parlayargan Jesuspa alli willacuyninta. Tsaynöpis willapargan wanushgacuna cawayämunanpä cangantam. Tsaycunata tantiyatsir parlapaptinmi waquin runacuna niyargan: “Cayga yachag tucurnin ¿imatarä parlacunpis?” nir. Y waquinnam niyargan: “Cayga mana regingantsic dioscuna imapächir parlapaycämantsic” nirnin. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Tsaynö nirmi Pabluta apayargan “Areopagu” ningan wayiman. Tsaychömi willanacuyänanpä yachag runacuna imaypis goricäyag. Tsay runacunam Pabluta niyargan: “Gam yachatsicuycarguyqui imaypis mana wiyayangäcunatam. Tsay yachatsicuycangayquitam nogacuna shumag musyayta munayä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atenas runacuna y tsaychö tärag jäpa runacuna mushog yachacuycunata parlacurmi tiemputa päsar goyäcuyag.) ");
INSERT INTO qxoNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tsaynam parlanganta wiyayta munayaptin goricashga runacunata Pablo nirgan: “¡Atenas runacuna! Atsca dioscunata adorayänayquipä altarnincunata rurayangayquitam ricargö. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tsay altarcunata ricapacur puriycangächömi ricargö juc puchachö caynö gellgaraycagta: ‘CAY ALTARGA MANA REGINGANTSIC DIOSPÄMI’ nir. Cananga nogapis tsay mana regiyangayqui Diospämi tantiyatsiyäshayqui”. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Tsay Diosmi camashga cay patsata y llapan imaycacunatapis. Tsaymi munayninchö tsararaycan ciëlutapis y cay patsatapis. Ama yarpäyaytsu runa rurangan templucunachö pay täranganta. Tsay camacog Diosga maytsaychöpis caycanmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Manam payga miñishtintsu runacuna imatapis rurapäyänanta ni garayänanta. Nogantsictaga paymi camamagnintsic. Y payllam imayca chasquingantsictapis camaripämantsic”. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Juc runallata camanganpitam maytsay nacioncunachö cawayänanpäpis miratsimarguntsic. Paymi destinamarguntsic maychö täcunantsicpäpis y nircur imay wanunantsicpäpis. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","28","Cananpis pay mana yanapamashgaga manam cawashwantsu. Tsaynö captinga Diosnintsic canganta tantiyacunantsicpäga manam ajatsu. Unay juc marca mayiquicunapis alli yarpayyog cayninwan caynö nirmi gellgargan: ‘Llapantsictapis jucllayllam camamarguntsic’ nir”. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Tsaynö paylla camaycämashgaga ama yarpäshuntsu örupita, gellëpita, o imapitapis rurayangan imäjincunapis Dios canganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tsaynö ïdulucunapä Dios canganta runacuna yarpäyaptinpis Tayta Diosga cuyapäcog carmi castigarganrätsu. Cananmi itsanga llapan runacunata mandaycan tsay ïdulucunata mana adoraypa payllata cäsur cawanantsicpä. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tayta Dios munangannö mana cawagcunata juc junag juzgananpämi acrangan runata cachamunga. Tsay runa pï cangantapis musyanantsicpämi wanunganpita cawatsimurgan”. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wanunganpita cawamungan runapä Pablo parlanganta wiyaycurmi itsanga waquin runacuna burlacur asicuyargan. Waquin cag runacunanam niyargan: “Yapaypis cutiycallämunqui, taytay, mastapis tantiyaycatsiyämänayquipä” nir. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tsaypitanam tsay yachag runacuna goricäyanganpita yargusquir Pablo aywacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tsaynö captinpis waquinga Pablo willapangancunata wiyacurmi criyicuyargan. Paycunachömi Dionisio jutiyog runapis cargan. Payga Areopagu wayiman goricag autoridämi cargan. Nircur Damaris jutiyog warmi y mas waquincunapis Pablo willacungantam chasquicuyargan. ");
INSERT INTO qxoNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tsaypitanam Atenas marcapita Pablo aywacurgan Corinto marcaman. ");
INSERT INTO qxoNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tsaychömi Aquila jutiyog Israel mayin runawan reginacuyargan. Aquilaga cargan “Ponto” ningan provinciapitam. Warmin Priscilawan Aquilaga tsayrämi Italiapita Corinto marcaman chäyashga caycäyargan. Tsayman aywacuyargan llapan Israel runacunata Romapita tsay mandacog Claudio yargucuyänanpä ordenashga captinmi. ");
INSERT INTO qxoNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Priscilawan Aquilaga carpa ruray oficiutam yachayargan. Pablupis tsaynö carpa rurayta yacharmi paycunawan arur quëdacurgan. ");
INSERT INTO qxoNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cada säbadu jamapay junagmi Israel runacuna goricäcuyänan wayiman Pablo aywag. Tsaychömi Jesucristupä yachatsicurgan Israel runacunatapis y mana Israel runacunatapis. ");
INSERT INTO qxoNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tsayman Macedonia provinciapita Silaswan Timoteo chäriyaptinnam Pabloga aruynintapis jagirirnin cada junagpis Diospa willacuyninta willacur masrä gallaycurgan. Tsaynö willacurmi Israel marca mayincunata tantiyatsirgan Señor Jesucristo runacunata salvananpä shamunganta. ");
INSERT INTO qxoNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tsaychönam Israel r