﻿USE sofia;
DROP TABLE IF EXISTS sofia.qxnNT_vpl;
CREATE TABLE qxnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qxnNT_vpl WRITE;
INSERT INTO qxnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tayta Abrahamwan rey Davidmi Señor Jesucristopa unaycag awiluncuna cayargan. Tsaymi llapan unay awiluncunaga caynö cayargan: ");
INSERT INTO qxnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa tsurinmi Isaac. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judápa warmin Tamarchömi tsurincuna Fareswan Zara cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa tsurinmi Aminadab. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa warmin Rahabchömi tsurin Booz. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaípa tsurinmi rey David. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónpa tsurinmi Roboam. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa tsurinmi Josafat. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa tsurinmi Jotam. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa tsurinmi Manasés. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa tsurincunam Jeconías waugencunawan cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Prësurnin apasquiyaptinmi tsay Babilonia marcachö Jeconíaspa tsurin Salatiel yurirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa tsurinmi Abiud. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa tsurinmi Sadoc. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa tsurinmi Eleazar. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa tsurinmi José. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tayta Abrahampita gallaycur, asta rey Davidyag chunca chuscum unay awiluncuna cayargan. Tsaynöllam tayta Davidpita asta Babiloniaman israelcunata apayanganyag chunca chuscu unay awiluncuna cayargan. Babiloniaman israelcunata prësu apayanganpita Señor Jesucristo yuringanyagmi chunca chuscu unay awiluncuna cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Señor Jesucristo yuringan caynömi cargan: Jesúspa maman Maríam, Joséwan casarayänanpag parlashgallarag caycar, Joséwan manarag täcurnin Espïritu Santopa poderninwan Maríaga geshyagna caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joséga alli runa carmi, Maríata mana pengacatsinanraycu willacuyta mana munarnin pacayllapa raquicayta yarpargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tsaynö yarpachacurnin José puñuycanganmanmi, Diospa angelnin yuripusquir nirgan: “Davidpa ayllun José, ama mantsacurnin pengacuytsu Maríawan casarayta. Espïritu Santopa poderninwanmi payga geshyag caycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ollgo wamran yurisquiptinmi, shutin churanqui ‘Jesústa.’ Jutsancunapita runacunata salvananpag captinmi, tsaynö shutin canga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dios Yayapa tsurin tsaynö yurinanpagmi, unay profëtanwan willacatsir nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Juc jipashmi virgen caycar, juc ollgo wamrata geshyacunga. Tsaymi shutinpis churayanga ‘Emanuel.’ ” (Emanuelga “Nogantsicwan Dios caycan” ninanmi.) ");
INSERT INTO qxnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Puñuycanganpita José riccharcamurmi, angel ninganta cäsurnin Maríawan casarananpag wajinpa apargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Manarag wamran yuriptinga, Maríawan José manaragmi pagta puñuyarganragtsu. Wamra yurisquiptinmi, shutin churayargan “Jesús.” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes rey caycaptinmi, Judea provincia Belen marcachö Jesús yurirgan. Rupay yargamunan lädu marcancunapitam goyllorcuna estudiay yachag runacuna, juc jatun goyllorta ricasquir alläpa caruta Jerusalénman shayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalénman chaycurnam, rey Herodesta tapuyargan: “¿Maychötan judiucunapa reynin cananpag wamra yurishga? Rey yurinanpag goyllor yurimugtam ricäyashcä. Tsaymi adoragnin carupita shayämurü.” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tsayta wiyaycurmi, rey Herodesga alläpa mantsacargan. Tsaynöllam Jerusalénchö täcugcunapis mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mayorcag sacerdöticunatawan ley yachatsicugcunata gayascatsirmi, rey Herodes tapurgan: “¿Maychö Cristo yurinanpagtan unay profëtacuna willacuyargan?” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tsaynö tapuptinmi niyargan: “Judea provincia Belen marcachömi. Tsaypagmi Dios Yayapa unay profëtan gellgargan: ");
INSERT INTO qxnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belen marcaga alläpa ichicllam Judeachö jatusag marcacunapitaga. Tsaychömi juc rey yuringa, imayca üshata mitsicug cuidangannö Israel runacunapa reynin cananpag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsayta wiyaycurmi, rey Herodes goyllor estudiagcunata pacayllapa gayatsirgan. Chaycuyaptinnam tapurgan: “¿Imaypitanatan tsay goyllorta ricäyashcanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Goyllor ricäyanganta willaycuyaptinam, Belen marcaman cachargan: “Aywayay shumag tsay wamrata ashiyämunqui. Tarisquirga cutiyämunqui willayämänayquipag, nogapis adoragnin aywanäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tsaynö Herodes niptinmi, goyllor estudiagcuna aywayargan. Nänita aywaycäyaptinmi puntallancunata tsay ricäyangan jatun goyllor aywargan. Tsay goyllorga wamra caycangan jananman chaycurmi, ichisquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","¡Tsayta ricarcurmi, goyllor estudiagcuna alläpa cushicuyargan! ");
INSERT INTO qxnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Waji rurinman yaycusquirnam maman Maríawan wamra caycagta tariyargan. Puntanman chaycurnam gongorpacuycur adorarnin, gorita, incienciuta, alläpa chaniyog mirra apayämunganta garayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sueñuynincunachömi Dios Yaya alvertirnincuna revelargan Herodescagpa manana cutiyänanpag. Tsaymi juclä nänillapana marcancunamanpis cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Goyllor estudiagcuna cutisquiyaptinmi, Dios Yayapa angelnin Joséta sueñuyninchö yuripusquir nirgan: “¡Jina öra sharcur, Egipto marcaman aywacuy wamrata mamantawan pusharcur! Tsayllachö täcunqui yapay noga willangagyag. Rey Herodesmi niño Jesústa ashinga wañutsinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tsaymi Joséga jina öra shäricusquir, niño Jesústa mamantawan pusharcur Egiptoman pagaspa geshpirnin aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josémi tsaychö täcurgan Herodes wañunganyag. Tsaynömi Dios Yaya unay profëtancunawan willacatsingan cumplirgan: “Egipto marcapitam Tsurïta gayamushcä” ningan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Goyllorta estudiagcuna jucläpa cutir engañayanganta Herodes musyasquirmi, alläpa rabiargan. Goyllor estudiagcuna tsay goyllorta ishcay wata mas puntatam ricashga cayargan. Tsay tiempupita quillata gatisquirmi, llapan ollgo wamracunata Belenchöwan estanciacunachöpis wañutsiyänanpag mandargan. Tsaymi llullupita gallaycur, asta ishcay watayogcunayag jancat wañutsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tsaynö rurayaptinmi, unay Dios Yayapa profëtan Jeremias ningan cumplirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramä marcachömi gayaraycachar wagagta wiyayargan. Wamrancunata wañuscatsiyaptinmi, alläpa llaquicuywan Raguel wagargan. Waquincagcuna shugayaptinpis, llaquicuynintaga manam gongayta munargantsu, ‘Wañushganam’ nir.” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tsaypita Herodes wañusquiptinnam, Egiptochö José caycanganman. Sueñuyninchö Dios Yayapa angelnin yurisquir nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“José, cananga Israel marcayquiman cuticuy, wamrantawan mamanta pusharcur. Wamracunata wañutsiyta munag runacunapis wañuyashganam.” ");
INSERT INTO qxnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tsaymi José jina öra Israelman mamantawan wamrata pusharcur cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Judeachö Herodespa tsurin Arquelaomi, rey Herodespa rantin cargan. Tsayta musyasquirmi, José mantsacurnin Judeaman chayta munargantsu. Tsaymi Galilea provinciapa aywananpag sueñuyninchö Dios Yaya alvertir willargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tsaypa aywarmi Nasaret marcachö täcurgan. Tsay marcachö caycaptinmi, unay Dios Yayapa profëtancuna willacur niyangan cumplirgan: “Jesúsga ‘Nazaret’ runa niyanganmi canga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tsay watacunachömi Juan Bautista tsunyacunapa aywar, Judea provinciachö willacuyta gallarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Dios Yayapa Mandacuy Reynon tiempu chaycämunnam. Jutsayquicunata dëjasquir, Dios Yaya munangannö cawayay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tsaynö Juan Bautista willacunanpagmi, unay Dios Yayapa profëtan Isaías gellgarnin nirgan: “Tsunyacunachömi juc runa willacurnin ninga: ‘Juc autoridä marcayquiman shamunanpag, nänicunata allitsayangayquinölla Señornintsic shamunanpag alistacuyay. Mana alli rurayangayquicunata dëjasquir, allicunallatana rurayay.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpa llatapanga “camëllopa” millwanpita awashga y wachucunmi garanpita rurashga cargan. Micuyninam chucloscunawan tsunyacunachö taringan orongoypa mishquincunalla cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juan Bautista caycanganmanmi atscag runacuna Jerusalénpitawan llapan Judeapita y Jordan mayu cuchuncunapitapis shayamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Runacuna jutsancunata willayaptinmi, Juan Bautista Jordan mayuchö bautizargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Atscag fariseocunawan saduceocuna bautizacug shayämugta ricarmi, Juan Bautista nirgan: “¡Gamcunaga venenösa vïborapa castanmi cayanqui! ¿Pitan willayäshushcanqui Dios Yayapa castïgunpita geshpiyänayquipag? ");
INSERT INTO qxnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rasumpa jutsa rurayniquicunata dëjashga carga, allicunallata rurayay Dios Yayaman cutiyangayquita musyayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama aläbacuyaytsu unay Abrahampa ayllun carmi, ‘Alli rurag cantsic’ nirga. Tsaymi niyag: Dios Yaya munarga cay rumicunatapis Abrahampa ayllunman ticratsinmanmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jächagam listuna caycan gerucunata chapapita wallunanpag. Mana alli wayugcag jachataga wallusquirmi, ninaman jitaringa. Tsaynömi mana alli ruragcag runacunataga Dios Yaya infiernuman garpunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Jutsayquicunata llaquicur dëjasquir, Dios Yaya munangannö cawayaptiquiga, yacuwanmi noga bautizayäshayqui. Pero nogapa gepäta shamugga ninawannö, Espïritu Santota garayäshurniquim bautizayäshunqui. Payga alläpa poderyogmi. Nogaga manam servïtsu llangenta apanällapagpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jorquïtata aptarcurmi, trïguta shogmanga. Wayrasquirnam, limpiucagta gorisquir gollgaman churanga. Päjantanam jitarir, waycanga mana imaypis wañug ninachö.” Tsay cuentanömi allicagcunapita mana allicag runacunata raquisquir infiernuman garpunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juan Bautista Jordan mayuchö runacunata bautizaycanganmanmi, Galileapita Señor Jesucristo Juan bautizananpag shamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanga manam munargantsu bautizayta: “¿Imanötagshi nogaga gamta bautizagman? Nogata ashwan bautizamanquiman. Tsaynö caycaptinga ¿imanirtan nogaman shamunqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tsaynö niptinnam, Señor Jesucristo nirgan: “Imanö carpis, cananmi bautizamänayqui. Tsaynö rurarmi, Dios Yaya munanganta cumplishun.” Tsaynö niptinmi, Señor Jesucristota Juan bautizargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tsaynö bautizasquiptin Señor Jesucristo yacupita yargaycämuptinmi, cielu quichacasquiptin imayca juc palomanö Espïritu Santo urämur Payman rataycagta ricasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cielupitanam Dios Yaya nimurgan. “Caymi cuyay Tsurï. Paytam quiquï acrashcä cushitsimänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsaypitam Espïritu Santo tsunyaman Señor Jesucristota pushargan. Tsay tsunyachömi Satanas llutanta ruratsir engañayta munargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tsaychömi chuscu chunca junag y chuscu chunca pagas mana ni imata micurnin, Señor Jesucristo mallagargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsaymi Satanas nirgan: “Rasumpa Diospa Tsurin carga, mä cay rumicuna manday tantaman ticrayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Señor Jesucristonam nirgan: “Diospa Palabran gellgashgachömi nin: ‘Runaga manam tantata micurllatsu cawanga, sinöga Dios Yayapa Palabran mandacunganta rasumpa cäsurmi mas allish cawacunga’ nir.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsaypitam Señor Jesucristota Satanas Jerusalénchö juc jatun iglesia niyangan templuman pushargan. Tsay templupa janan mas altucag puntanman lätarcatsirmi, ");
INSERT INTO qxnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nirgan: “Rasumpa Diospa Tsurin carga, mä caypita jegarpuy. Diospa Palabran gellgashgachömi nirgan: ‘Gammanmi Dios angelnincunata cachamunga, alcäbu cuidar maquincunawan achcuyäshuptiqui, mana rumicunawan chaquiquitapis tacacunayquipag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tsaynö niptinam, Señor Jesucristo nirgan: “Diospa Palabran gellgashgachömi nirgan: ‘Diosniquitaga ama ni ima pruebamanpis churanquitsu.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tsaypitanam jirca puntanman Señor Jesucristota Satanas pushaycur, entëru munduchö llapan jatusag shumag marcacunatawan imayca riquësancunata ricätsir, ");
INSERT INTO qxnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nirgan: “Gongorpacuycur adoramaptiquiga, cay llapan imayca ricaycangayquitam garaycugman.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Señor Jesucristonam nirgan: “Caypita witiy Satanas. Diospa Palabran gellgashgachömi nin: ‘Juc japallan Diosllayquitam adorarnin servinayqui.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Señor Jesucristo tsaynö niptin Satanas aywacusquiptinmi, angelcuna shamur Señor Jesucristota serviyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista carcelchö gaycuraycanganta musyasquirmi, Señor Jesucristo Galilea marcaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaretpita aywacurmi, Capernöm marcachö täcurgan. Tsayga Galilea gocha cuchunchö, Zabulón, Neftali runacunapa marcancunachömi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tsaynömi Dios Yayapa unay profëtan Isaías gellgangan cumplirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Wiyayay Zabulon y Neftali marcacuna lamar cuchunpita Jordan mayu wac tsimpanyag. Wiyayämay Galilea marcacunachö täcug runacuna. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tutapaychö cawagcunam alläpa atsicyayta ricäyargan. Wañushganö tutapaychö cawagcunapagmi imayca rupay yargamugnörag actsi yurirgan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tsaypitanam Señor Jesucristo willacurnin yachatsicur gallaycurgan: “Jutsa rurayniquicunata dëjasquir, Dios Yaya munangannö shumag cawacuyay. Dios Yayapa Mandacuy Reynon tiempu chaycämunnam.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tsaypita Galilea gocha cuchunpa Señor Jesucristo aywaycarmi, ishcag waugentin runacunata ataräyancunata yacuman jitaycäyagta tarirgan. Paycunam cayargan pescädo achcug Simón Pedrowan waugen Andrés. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tsaymi Señor Jesucristo nirgan: “Nogata gatiyämay. Pescädo achcuyta yachatsiyäshungayquinö, noga yachatsiyäshayqui runacunata gorisquir yachatsiyänayquipag, paycunapis gatiräyämagnï cayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsaynö niptinnam, jina öra ataräyancunatapis dëjasquir Señor Jesucristota gatircur aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsaypita päsasquirnam, Señor Jesucristo Zebedeopa tsurincuna Santiagotawan waugen Juanta tarirgan. Büquichö ataräyancunata taytan Zebedeowan allitsaycäyagta. Tsaymi ishcanta Señor Jesucristo gayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jina öram büquichö taytancunata dëjasquir, Señor Jesucristota gatircur aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tsaypitanam Señor Jesucristo maytsaypa purirnin Galilea marcacunapawan judiucuna goricäyänan wajicunachö yachatsicurgan. Dios Yayapa Mandacuy Reynonpa Alli Willacuyninta willacurmi, tucuyläyawan geshyagyashacunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Maytsay Siria marcacunachömi Señor Jesucristo llapan geshyagyashacunata cuticätsinganta parlayargan. Paymanmi supayyogcunatawan cuerpuncuna mana cuyuptin geshyagyashacunata y carcariar wañunagcunatapis apayämurgan. Tsaynömi tsay llapan geshyagyasha runacunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Atscag runacunam Señor Jesucristota gatiyargan maytsay marcacunapita Galilea, Decapolis, Jerusalén, Judea, Jordan mayu wac tsimpancunapitapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Señor Jesucristom atscag runacunata ricaycur, juc jircaman witsargan. Tsay jircachö jamaycuptinmi, discïpuluncuna puntanman witiycur jamaycuyaptin, ");
INSERT INTO qxnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yachatsirnincuna nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushicuyay wactsa umilde gollmi shongoyogcuna, gamcunatam Dios Yaya Mandacuy Reynonta garayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Cushicuyay cay patsachö llaquicurnin wagagcuna. Tsaynö cayangayquipitam Diosnintsic shugayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Cushicuyay umilde gollmi shongoyogcuna, gamcunatam Dios Yaya llapan cay patsachö imayca camanganta garayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Cushicuyay mallagarnin yacunagnö Diosnintsicta ashir, Pay munangannö cawagcuna. Tsaynö ashigcagtam Dios Yaya llapan ashinganta tarinanpag yanapanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Cushicuyay runamajiquicunata llaquipag runacuna, gamcunatam Dios Yaya imaypis llaquipäyäshunqui y cay patsa ushacangan junagchöpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Cushicuyay umilde limpiu shongoyogcuna, gamcunagam Dios Yayata janag patsachöpis ricäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Cushicuyay runamajiquicunawan alli päsacuychö cawayta ashigcuna, gamcunatam Dios Yaya ‘Wamrämi canqui’ niyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Cushicuyay Dios Yaya munanganta rurayangayquipita chiquiyäshuptiqui, gamcunatam Dios Yaya Mandacuy Reynonta garayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Cushicuyay nogaraycu asharnin gaticachäyäshuptiqui, chiquiyäshuptiqui y manacagchö tumpayäshuptiquipis. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tsaynö rurayäshungayquipita alläpa cushicuyanqui. Tsaynömi Diosnintsicpa unay profëtancunatapis rurayargan. Tsaypitam cieluchö alläpa cushicuy mas alli premiuta chasquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamcunaga cay patsachö cachinömi cayanqui. Si tsay cachi micuyta mana mishquiytsirga, manam ni imapagpis välentsu. Tsaymi tsay mana puchgog cachita näniman jitasquiyaptin, runacuna päsarnin jarutäcuyan. (Tsaynöllam rasumpa mana criyicuynintsic captinga, runamajintsictapis yanapayta puedintsictsu.) ");
INSERT INTO qxnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Cay patsachö actsinömi cayanqui. Jircachö marca carga, mas alayrim ricacan. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Linternata prendircurga, manam canastapa gopinmantsu pacantsic. Sinöga altumanmi churantsic llapanman atsicyämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gamcunaga actsinö cayay, allicunallata rurayangayquita ricarnin, cieluchö caycag Dios Yayatapis alabayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama nogapag yarpäyaytsu ‘Payga Moisés gellgangan leyta illacätsinanpagmi shamushga.’ Dios Yayapa profëtancuna willacuyangantapis illacätsinanpagmi nirga. Manam tsaypagtsu nogaga shamushcä, sinöga leycuna ninganta cumplinäpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cananmi niyag: Cieluwan patsapis manarag ushacaptinga, manam puntuwan ni juc letrallatapis tsay gellgashgacunapita illacätsiyangatsu, asta tsay llapan gellgashgacuna cumplinganyag. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pero pipis tsay ley mandacunganta mana jucllayllatapis cumplirga, Dios Yayapa Mandacuy Reynonchöpis ‘Mana imapag välegmi’ canga. Tsaynöllam pipis ‘Ley llapan mandacunganta ama cumplishuntsu’ nigcagga, ‘Mana ni imapag välegmi’ canga. Ley mandacungancunata cumpligcagga, Dios Yayapa Mandacuy Reynonchöpis mas alli runam cangan. Tsaynöllam ‘Llapanta cumplishun’ nirnin, yachatsicugcunapis cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rasuncagtam niyag: Si gamcuna ley yachatsicugcunapitawan fariseocunapita llapan shongoyquicunawan mas allicunallata rurarnin mana cuyanacurga, Dios Yayapa Mandacuy Reynonmanpis manam yaycuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gamcunaga wiyayashcanquim, unaycag runacunata Dios Yaya ninganta: ‘Ama wañutsicuytsu. Wañutsicugcagga condënädum canga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero nogam niyag: Pipis runamajinta rabiapagcagpis, condenashgam canga. Runamajinta ashagcagtaga puedig autoridäcunam castigayanga. Tsaynöllam runamajinta alläpa rabiapar, ‘Mana ima musyag upa mana välegmi canqui’ nigcagga, lunyaycag infiernuman aywanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tsaymi Dios Yayata adorag aywaycangayquichö, runamajiqui piñatsishungayquipita piñashga caycanganta yarparga, ");
INSERT INTO qxnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","puntata cutiycur, runamajiquitarag perdonta mañanqui paywan alli cawacunayquipag. Tsaypitanam Dios Yayata adorag aywanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Demandashurniqui juezman apatsishuptiquiga, manarag charnin nänillachö contrayquiwan amistanqui. Pero mana tsaynö amistaptiquiga, juezmanmi entregashunqui. Tsaymi juezga wardiacunaman apatsishunqui, carcelchö gaycarätsishunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rasuntam niyag: Manarag llapan jagayquita pägacurga, manam tsay carcelpita yargamunquitsu. Tsaynölla mana alli jutsata rurashga carpis, tsay öralla Dioswan amistayta ashiyanqui manarag castigashungayquiyag. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Wiyayashcanquim: ‘Casarashga caycarga, amana jucwanga täcunquinatsu’ nigta. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero nogam niyag: Pipis ‘Tagay warmiwan täcüman’ nir yarparnin ricaparga, tsay warmiwan täcugnönam mana alli jutsata ruraycan, mana allita yarpanganpita. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Tsaymi niyag: Derëchucag ñawiqui jutsata ruratsishuptiquiga, jorgosquir jitasquiy. Mas allim canga juccag ñawiquita ograngayqui, entëru cuerpuyquita infiernuman garpungayquipitaga. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Derëchucag maquiqui jutsata ruratsishuptiquiga, rogosquir jitasquiy. Mas allim canman juccag maquiquita ograngayqui, entëru cuerpuyquita infiernuman garpungayquipitaga. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gamcunaga wiyayashcanquim unay Moisés willacunganta: ‘Runa warminpita raquicayta munarga, warminta papelnin ruraputsun raquicanganta musyayänanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero nogam niyag: Maygan runapis warmin jucwan mana täcuycaptin raquicarga, tsay warmin jucwan täcunanpagpis quiquinmi culpayog. Tsaynöllam pipis raquicashga warmiwan täcurga, jutsata ruraycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tsaynöllam wiyayashcanqui Israel runacunata unay Moisés willacur ninganta: ‘Dios Yayata jurarnin llapan äningayquita rasumpa cumplinqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero nogam niyag: Ama nunca juranquitsu. Ama juraytsu ni cielupagpis. Cieluga Dios Yayapa jamacunan trönom. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tsaynölla ama juraytsu ni cay patsapagpis. Cay patsaga Dios Yayapa chaquin järucunanmi. Paymi cay patsachö caycar, wiyaycäshunqui. Ama juraytsu ni Jerusalénpagpis. Jerusalénchöga Dios Yayapita Shamushga mas mandacuyyog reymi täcun. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ama juraytsu ni umayquipagpis. Manam ni juc agtsayquillatapis yuragman ni yanaman ticratsiyta puedinquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Si aumi nirga, ‘Aumi’ ninqui. Manam nirga, ‘Manam’ ninqui. Imatapis masta jurarga, Supaypa mana alli munaynintam ruraycanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Wiyayashcanquim unay Moisés leycunapag willacunganta: ‘Si pipis jucpa ñawinta jorgoptinga, quiquinpa ñawintapis jorgoyay.’ Tsaynölla pipis jucpa quirunta jorgoptinga, quiquinpa quiruntapis jorgoy. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero nogam niyag: Mana allicunata rurashuptiquiga, ama mana alliwanga cutitsiytsu. Gagllayquichö lagyashuptiquipis, juccaglä gagllayquita camapuycuy. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Demandashurniqui camisayquita gechuyäshuptiquiga, punchuyquitapis llushtipuycuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gepinta pullan lëguayag apanayquipag rugashuptiquiga, juc lëgua masyag apaycapunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","‘Garaycamay’ nir, rugashuptiquipis garaycunqui. Imata prestacushuptiquipis ama nëganquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Wiyayashcanquim unay Moisés leycunapag willacunganta: ‘Cuyashugniqui amïgoyquicunata cuyarnin, chiquiyäshugniquicunata chiquiyanqui’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero nogam niyag: Chiquiyäshugniquicunata cuyarnin, Dios Yayaman mañacuyay gaticacharnin magayäshugniquicunata yanapananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsaycunata rurarmi, cieluchö Dios Yayapa wamrancuna cayanqui. Dios Yayam rupayta yargatsimun llapan runacunapag alli, mana alli runacunapagpis. Tsaynöllam tamyatsimunpis llapan alli ruragcunapawan mana alli ruragcunapa chacranman. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cuyayäshugniquicunallata cuyarga, manam ni ima allitatsu ruraycäyanqui. Tsaynö cangayquipitaga, ¿ima premiutarag Dios Yayapita chasquinqui? Tsaynömi impuestu cobracugcunawan jutsasapacunapis cuyagnincunallata cuyarnin mana allita rurayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Si criyicug waugeyquicunallata saludar llaquiparnin, yanapayäshugniquicunallata yanaparga, manam ni ima allitatsu ruraycäyanqui. Jutsasapacunapis regeshgancunallataga rimaycuyanmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tsaypa rantinga mana juc jutsannag cieluchö Taytaquicunanölla cawacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ama runacuna ricäyäshunayquillapagga imatapis allicunata rurayaytsu. Tsaynö runacuna ricäyänallanpag rurayaptiquiga, cieluchö caycag Dios Yayaga manam allicag premiutaga entregayäshunquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wactsacunata yanapar garaycurga, ama pitapis willanquitsu. Fariseocunawan mandacug runacunagam janan shongolla wactsacunata imatapis garaycur, goricäyänan wajicunachöwan cällicunachöpis, trompëtacunawanrag willacuyan runacuna aläbayänallanpag. Tsay runacunaga tsaynö rurayanganpita runacuna aläbar, ‘Payga alläpa allim’ niyangan premiullatam chasquiyashga. Pero nogam rasumpa niyag: Si tsaynö rurarga Dios Yayapita manam ni imatapis chasquiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wactsacunata garaycurga ama pitapis willanquitsu ni cuyay amïgoyquillatapis musyatsinquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ama garacungayquita ni pipis musyangatsu. Tsaynö mana pitapis musyatsir garangayquitam, Dios Yayalla ricarnin gamtapis mas allicagta garashunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Dios Yayata mañacurga, ama allitucurnin janan shongolla imatapis mañacunquitsu. Fariseocunawan mandacug runacunagam mañacuyan, goricäyänan wajicunachöwan cällicunachö y esquïnacunachöpis ichiycur ichiycur, llapan runacuna ricarnin aläbayänallanpag. Rasuntam niyag: Tsaynöta ricarnin runacuna aläbayangan premiullatam paycunaga chasquiyashga. Si tsaynö janan shongolla mañacurga, Dios Yayapita manam ni ima mañacuyangayquitapis chasquiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dios Yayallaman mañacuyta munarga wajiquiman yaycusquir, puncuyquita wichgasquirnin quiquillayqui mañacunqui. Tsaynö pacayllapa mañacungayquita wiyarmi, mana ricangayqui Dios Yaya alli premiuta garashunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Dios Yayata mañacurga ama mana criyicugcunanöga yapaycur yapaycur, juc parlangayquillataga parlayanquitsu. Tsaynö parlagcunaga yarpäyan: ‘Atsca cuti resacuptin Dios Yayä wiyangantam.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ama tsay runacunanöga cayaytsu. Dios Yayaga manarag mañacuptiquim, ima wanangayquitapis musyaycanna. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dios Yayaman mañacur niyanqui: Cieluchö caycag, Dios Yayalläcuna, Respetashga shutiqui cuyay catsun. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mandacuy Reynoyqui nogacunaman shamutsun. Munangayqui ruracätsun cay patsachö janag patsachönö. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Micuylläcuna llapan junagpag garaycayämay. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jutsalläcunata gongaycuy, nogacunapis runamajïcunapa jutsanta gongayangänö. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tentacioncunaman mana ishquiycuyänäpag tsapaycäyämay. Llapan imayca mana allicunapitapis geshpiycatsiyämay. Tsaynö catsun. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Si pipis mana allicunata rurashuptiqui perdonaptiquiga, cieluchö caycag Tayta Diospis perdonashunquim. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero si gam mana perdonaptiquiga, Tayta Diospis manam perdonashunquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mallaglla ayunarga ama allita ruragtucugcunanöga cayanquitsu. Paycunaga llaquishganö ayunayan runacuna ricäyänanllapagmi. Rasuntam niyag: Tsaynöta ricarnin runacuna aläbayangan premiullatam paycunaga chasquiyashga. Pero Dios Yayapitaga manam ni ima premiutapis chasquiyangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tsaynö cayangayquipa rantinga shumag umayquicunatawan gagllayquicunata mayllacusquir mallaglla ayunayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tsaynö ruraptiquiga runacuna manam musyayangatsu ayunar caycangayquita. Pero mana ricangayqui Dios Yayallam tsaynö pacayllapa ayunangayquita musyanga. Tsaymi Dios Yayaga allicag premiuta garashunqui, ‘Allitam rurashcanqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ama cay patsallachöga imatapis gorinquitsu, rïcu canayquipag. Cay patsachö goringayquitaga puyum ushanga, ismunga, mupallinga y suwacunam apayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tsaypa rantinga cay patsachö allita ruray cieluchö imaycayquipis cananpag. Manam tsaychöga ismuntsu, mupallintsu, puyuntsu ni suwapis apangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maychö imayqui capushungayquimanmi, shongoyquipis tsayman yarparaycanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ñawiquicunaga cuerpuyquicunatam linternanö actsipan. Tsaynö ñawiquicuna alli captinga, actsiyogmi llapan cuerpuyquicunapis canga. Tsaynölla gamcunapis allicunata yarparnin alli shongoyog cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero mana alli ñawiqui captinga, llapan cuerpuyquipis tutapaychömi canga. ¡Gamchö caycag actsi wañushga captinga, allau alläpa mantsacuypag tutapaychömi cawanqui! Tsaynö mana allicunata yarpar mana alli shongoyog carmi, jutsata rurarnin runamajiquicunata chiquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Pipis manam ishcay patronta servinmantsu. Juccagta chiquirmi, juccagta mas cuyanga. Juccagta cäsurmi, juccagtaga cäsungatsu. Tsaynöllam gellayta alläpa cuyarga, Dios Yayatapis servirnin cäsungatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tsaypitanam Señor Jesucristo discïpuluncunata nirgan: Ama yarpachacuyaytsu. ‘¿Imanörag cawashag? ¿Imatarag micushag? ¿Imatarag upyashag? ¿Imatarag shucucushag?’ nirga. Tsay micuypitaga caway vïdayquicunam mas välen y llatapayquicunapitapis gamcunam mas väleyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Masqui tantiyacuyay mana imannag pishgocuna ni imapag yarpachacur cawacuyanganta. Paycunga manam murucuyantsu ni cosechayantsu ni micuynincunapis goriyantsu churacuyänanpag. Cieluchö caycag Dios Yayam paycunataga mas pacha junta garan. ¿Acäsu gamcunaga manacu tsay pishgocunapitapis mas väleyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mayjina yarpachacurpis, ¿maygayquitan tsay yarpachacuycunawan juc öra masllapis cawayanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tsaynö caycaptinga, ¿imanirtan llatapayquicunallapag alläpa yarpachacuyanqui? Masqui jircacunachö waytacuna wiñagta ricäyay. Paycunaga manam arucuyantsu ni putscacuyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tsaymi niyag: Waytacuna cuyacuypag cangannöga, manam unay rïcu rey Salomónpa chipacyag llatapanllapis waytacuna alläpa cuyacuypag canganwanga iwalargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tsaynömi canan shumag jircacunachö gewacuna wiñayan. Pero warayga ninawan ruparmi jancat ushacasquiyanga. Dios Yayaga tsaynö ichishag goracunata llatapatsinganpitapis, mas shumagmi gamcunataga llatapatsiyäshunqui, ¡Diosman mana criyig runacuna! ");
INSERT INTO qxnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tsaymi ama yarpachacuyaytsu: ‘¿Imatarag micushun? ¿Imatarag upyashun? o ¿Imawantan shucucushun?’ nirga. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tsaynö yarpachacurmi Dios Yayaman mana criyicugcunaga cawayan. Pero gamcunataga cieluchö caycag Taytayquicunam imayquicuna faltangantapis musyarnin yanapayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tsaymi gamcunaga Dios Yayapa Mandacuy Reynonta ashiyay, Pay munanganllata rurarnin. Tsaynö cawayaptiquim, Dios Yaya garayäshunqui llapan wanayangayquicunatapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ama yarpachacuyaytsu: ‘¿Imanörag waray cashag?’ Waray junagpag yarpachacuyänayquipagga, cada junagmi siempri ima pruebacunallapis canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dios Yaya mana juzgayäshunayquipag, ama runamajiquicunata juzgayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Runamajiquicunata juzgarnin culpatsayangayquinöllam Dios Yayapis juzgarnin culpatsayäshunqui. Quiquiquicuna atscata o wallcallatapis garacuyangayquinöllam quiquin Dios Yayapitapis chasquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Runamajiquipa ñawinchö ichic shumpa caycagnö jutsanta ricänayquipagga, quiquiquipa ñawiquichö jatun gerunö jutsayquitarag musyanquiman. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Si quiquiquipa jutsayqui ñawiquichö jatun gerunö caycaptinga ¿imanirtan runamajiquipa ‘ñawinpita shumpata jipiscamushag’ ninqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ä, allitucug janan shongo! Quiquiquirag puntata ñawiquichö caycag geruta jorgonquiman. Tsaymi sïga mas shumag ricanquiman jucpa ñawinpita shumpata jipinayquipagpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Dios Yayapagcagtaga ama allgota garayanquitsu ni väleg perlascunatapis cuchicunaman jitariyanquitsu. Si tsaynö rurayaptiquiga quiquiquicunapa contrayquicuna shärirtag, jarutacurnin jancat ñututsir ushasquiyäshunquiman. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“¡Mañacuy! Dios Yayaga mañacungayquita garashunquim. ¡Ashiy! Ashingayquitapis taritsishunquim. ¡Tacacuy! Dios Yayaga puncutapis quichapushunquim. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tsaymi mañacugcagga chasquinga. Ashigcagga taringa. Puncuta tacacugtaga quichapungam. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Acäsu wamrayquicuna ‘Tantata garamay’ niyäshuptiqui, rumitatagcu aptarcatsiyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tsaynöllam ‘Taytay, pescädota garamay’ niyäshuptiquipis ¿Acäsu culebratatagcu aptarcatsiyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tsaynö mana alli rurag caycarpis, wamrayquicunataga allicunatam garayanqui. ¡Gamcunapita mas alli cayninwanmi, cieluchö caycag Tayta Diosga llapan mañacugcunatapis mas allicagcunata garanga! ");
INSERT INTO qxnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gamwan allita rurananta munangayquinölla, gampis runamajiquiwan imatapis allillata ruranqui. Caypagmi Moiséswan unay profëtacunapis willacuyargan, Diospa Palabran llapan yachatsicuyanganchö. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Quichqui puncupa yaycuy. Jatun puncupa fäcil yaycugcunaga jatun nänipam mana allicunata rurayanganpita infiernuman aywayanga. Tsaypa aywagcunaga atscagmi cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero quichquim puncupis llanum nänipis gloriachö alli cawayman aywanapagga. Wallcagllam tsay puncuta gloriaman aywayänanpag tariyanga, alläpa aja captin. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cuidacuyay llullacur, ‘Dios Yayapa willacugninmi cä’ nir, mana alli yachatsicugcunapita. Paycunaga imayca manshu üshanömi yachatsicuyan mantsaypag pumanö caycar. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cawaynincuna imanö canganta ricarmi, mana alli willacug cayanganta musyayanqui. Wayuyninpitam imanö früta canganta regentsic. Manam casha montipitatsu ïgosta pallantsic. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tsaynöllam allicag frütaga allita wayun. Pero mana allicag frütaga mana allitam wayunpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Alli plantaga manam wayunmantsu mana alli frütataga. Mana alli plantaga manam wayunmantsu alli frütataga. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tsay mana alli wayug plantataga wallusquirmi, ninachö cayantsic. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tsaymi juc jachatapis wayuyninpita regentsic. Tsaynö ruranganta ricarmi, llullacunganta o mana llullacungantapis musyayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manam llapan Señor, Señor nimagcunatsu, Dios Yayapa Mandacuy Reynonman yaycuyanga, sinöga cieluchö caycag Dios Yaya munangannö cawagcunallam Mandacuy Reynonman yaycuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cay patsa ushacangan junag juiciu finalchömi, atscag runacuna niyämanga: ‘Señor, Señor nogacunam shutiquichö yachatsicur, runacunapita supaycunatapis gargornin, atsca milagrucunatapis rurayashcä.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tsaynö niyämaptinmi nishag: ‘¡Nogapita nogapita witiyay, manam gamcunata regeyagtsu!’ ");
INSERT INTO qxnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Yachatsicungäta cäsucurnin cumpligcunaga, alli yachayyog runa gaga jananchö rumiwan cimientuta rurasquir wajita shäritsignömi cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wajita rurar ushasquiptin alläpa tamyawan mayu jegaptinpis manam ushmurnin ni wayra pücaptinpis, tsay wajiga shicwangatsu rumi jananchö rurashga car. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero yachatsicungäta wiyaycar, mana cäsucugcunaga mana musyag upa runa agoshga jananchö wajita shäratsignömi cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsay runa wajinta rurarnin ushasquiptin, alläpa mangäda tamyawan mayucunapis jegargan. Tsaymi alläpa wayra pücamuptin, tsay waji mantsacaypag juchurnin jancat ushacasquirgan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Señor Jesucristo parlarnin ushasquiptinmi, runacuna alläpa mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Payga manam ley yachatsicugnincunanötsu yachatsicurgan, sinöga alläpa yachayyog poderninwanmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jircapita Señor Jesucristo urämuptinmi, atscag runacuna gatiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tsaymi wicuwan melanaypag geshyagyasha runa Señor Jesucristopa puntanman gongorpacuycur nirgan: “Taytay, voluntäniqui captinga cuticaycatsillämay, melanaypag mana canäpag” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsaynam Señor Jesucristo maquinwan yataycur runata nirgan: “¡Munämi cuticashgana limpiu canayquita!” Tsaynö niycuptillanmi, geshyagyasha canganpita jina öra cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sänutana ricaycurmi Señor Jesucristo nirgan: “Ama ni pitapis cuticätsingagta willanquitsu. Sinöga canan ayway sacerdöti ricäshunayquipag. Tsaychö ‘Dios Yayapag’ unay Moisés mandacungannö ofrendata garanqui. Tsaynö ruraptiquim, runacuna musyayanga wicu geshyaypita cuticasquir manana melanaypag cangayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Señor Jesucristom Capernaum marcaman yaycurgan. Tsaymanmi romäno capitan chaycur, Señor Jesucristota rugarnin ");
INSERT INTO qxnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nirgan: “Taytay, wajïchömi juc wätaynï alläpa antsa geshyaycan, chaquintawan maquintapis mana cuyutsiyta puedir.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tsaynam Señor Jesucristo nirgan: “Aywashag cuticätsinäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsaymi romäno capitan nirgan: “Taytay, nogaga manam ni imapis callätsu wajïman yaycunayquipagga. Caylläpita poderniquiwan mandaycuy wätaynï cuticasquinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nogapis mandagnïpa mandädunchömi cä. Nogapa mandädüchömi soldäducunapis cayan. Soldäduta ‘Ayway’ niptïga aywanmi. Jucninta ‘Shamuy’ niptïpis shamunmi. Wätaynïta ‘cayta ruray’ niptïpis ruranmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tsayta wiyaycurnam Señor Jesucristo mantsacagnörag alläpa cushicur discïpuluncunaman tumaycur nirgan: “Niyagmi, cay runa criyicungantanöga, manam ni imaypis Israel naciunchö tarishgatsu cä. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tsaymi niyag: Maytsay naciuncunapita shamurmi, atscag runacuna Dios Yayapa Mandacuy Reynonman yaycuyanga. Tsaychömi israelcunapa taytancuna Abraham, Isaac, Jacob, goricar pagta jamaycur micuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tsay Mandacuy Reynonman yaycugpagcagcunam wagta tutapayman gargoshga cayanga. Tsaymi alläpa wagarnin, quiruncunatapis regochyätsirrag sufriyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsaymi capitanta Señor Jesucristo nirgan: “Wajiquiman cuticuy. Criyicamungayquinömi canga.” Tsaymi jina öralla capitanpa wätaynin cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsaypitanam Señor Jesucristo Pedropa wajinman aywargan. Wajiman yaycusquirnam, Pedropa suegran fiebrewan geshyar cämachö ujuraycagta tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsaymi Señor Jesucristo warmipa maquinta aptarcuptin, achachaynin pärasquirgan. Achachaynin pärasquiptinmi Pedropa suegran jina öra sharcamur Señor Jesucristota micuynin servirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Patsa tsacaycaptinam, Señor Jesucristoman astcag supayyog runacunata chätsiyämurgan. Tsaymi Señor Jesucristo “Yargoyay” nir, supaycunata runacunapita gargorgan. Tsaynömi llapan geshyagyashacunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Señor Jesucristo tsaynö ruraptinmi cumplirgan, unay Dios Yayapa profëtan Isaías gellgarnin ningan: “Paymi alläpa llaquishga llapan sufrimientuntsiccunatawan imayca nanay geshyaynintsiccunatapis apargan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tsayman atscag runacuna juntapuyaptinmi, discïpuluncunata Señor Jesucristo nirgan: “Gocha wac tsimpanman päsashun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Señor Jesucristo büquiman yaycunanpag caycaptinnam, juc ley yachatsicug witiycur nirgan: “Maestru, maypa aywaptiquipis gatishayquim.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tsaymi Señor Jesucristo nirgan: “Atogcunapapis machaynincuna canmi; pishgocunapapis geshuncuna canmi. Pero Dios Yayapita Shamushga Runapaga, manam iman cantsu ni maychö jamaycur shütaycunällapagpis.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsaypitam juccag gatiragnin Señor Jesucristota nirgan: “Taytay, gamta gatiränagpag taytätarag puntata pampascamushag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero Señor Jesucristonam nirgan: “Gamga nogata gatimay. Wañushgatanaga mana rasumpa firmi criyicur imayca wañushganö caycagcuna pampacuyätsun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tsay büquimanmi, Señor Jesucristowan discïpuluncuna yaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lamar pullanta aywaycäyaptinmi, illagpita alläpa wayrar gallaycamurgan lamar yacuta lagchicätsirrag büquitapis tsapaypa. Tsay öraga Señor Jesucristo puñucashgam caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsaymi discïpuluncuna riccharcatsir niyargan: “¡Señor, Señor, salvaycayällämay! ¡Yacuman tallpucaycantsicnam!” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Señor Jesucristo riccharcurmi nirgan: “¿Imanirtan mantsacäyanqui? ¡Dios Yayaman mana firmi criyicugcuna!” Tsaynö nir ichircurmi, wayratawan yacuta manana lagchicänanpag piñapar mandargan. Tsaymi jina öra wayrarnin yacu lagchicaycarpis patsallanchö jancat pärasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tsaynö mandanganta ricaycurmi, discïpuluncuna alläpa mantsacarnin ninacuyargan: “¡Cayga imanö runatan wayrawan lamar lagchicaycarpis mandanganta cäsunanpagga!” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tsay wac tsimpa Gadara niyangan marcaman Señor Jesucristo chaycuptinmi, panteonpita ishcag supayyog runacuna shayämurgan. Tsay runacuna mantsaypag löcuyashga magacur cayaptinmi, alläpa mantsarnin tsaycunapaga ni pipis päsargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tsay supayyog runacunam gayaraypa niyargan: “¿Diospa Tsurin Jesús, imatatan nogacunawan munanqui? ¿Caymancu shamushcanqui manarag castïgu öra chämuptin castigayämänayquipag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paycunapita mas washalächömi atsca cuchicunata mitsiycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsaymi Señor Jesucristota supaycuna niyargan: “Cay runacunapita gargayämarga, tagay cuchicunaman yaycucuycuyänäpag cachaycayällämay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tsaynö niyaptinnam Señor Jesucristo nirgan: “Aywayay.” Tsaymi tsay ishcan runacunapita yargosquir, supaycuna cuchicunaman yaycuyargan. Tsaynö yaycusquiyaptinnam, llapan cuchicuna löcuyar jircapita gochaman jegar ushacäyargan. Tsay yacuchömi shingarnin wañuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cuchi mitsicugcunapis alläpa mantsacarmi, marcancunapa cörrilla cuticuyargan. Marcancunaman chaycurnam, Señor Jesucristo löcucunapita supaycunata gargongantawan llapan päsangancunata willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsaymi tsay marcapita llapan runacuna Señor Jesucristo caycanganman shayämurgan. Señor Jesucristota ricaycurnam, marcancunapita aywacunanpag alläpa rugayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Señor Jesucristo büquiman lätarcurmi wac tsimpapa päsarnin, Capernaum marcanman chargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsaymi Señor Jesucristoman cuerpun usuncaywan mana cuyucuypa geshyagyasha runata tsacrancawan apayämurgan. Señor Jesucristo rasumpa firmi criyicuyanganta musyarmi nirgan: “¡Cushicuy ïju! Cananga llapan jutsayquipitam perdonashgana canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsaynö niptinmi, waquincag ley yachatsicugcuna pacayllapa ninacuyargan: “Cay runaga Diostucurmi ‘Perdonagmi’ nirnin Diospa contran parlaycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tsaynö pacayllapa parlarnin yarpäyanganta musyarmi, Señor Jesucristo nirgan: “¿Imanirtan shongollayquicunachö mana allicunata yarpäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Imatan mas fäcil ninan ‘Jutsayquipitam perdonashgana canqui’ o ‘¡Sharcur puriy!’ ningäcu? ¿Acäsu ‘Perdonashganam canqui’ ninanga mas ajatagcu? ");
INSERT INTO qxnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero cananmi musyatsiyäshayqui cay patsachö runacunapa jutsancunata perdonanäpag poderyog cangätawan, Diospita Shamushga Runa cangäta. Tsayta musyayänayquipagmi canan ricäyanqui.” Tsaypitanam geshyagyasha runata nirgan: “¡Ichiy! ¡Cananga tsacrancayquita apacurcur wajiquiman cuticuy!” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsaynö niptinnam, jina öra sharcurnin cuticasquir wajinpa aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tsayta ricaycurmi runacuna alläpa mantsacashga Dios Yayata alabayargan, tsaynö runacunata cuticätsinanpag podernin garanganpita. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tsaypita Señor Jesucristo aywarmi, impuestucunata cobracuyänan wajichö Mateota jamaycagta ricargan. Tsaymi nirgan: “¡Shamuy nogata gatirämay!” Tsaynö niptinmi, Mateo sharcur Señor Jesucristowan aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsaymi Mateopa wajinman aywayargan. Tsaymanmi atscag impuestu cobragcunawan waquincag mana alli ruragcunapis shayämurgan, Señor Jesucristowan y discïpuluncunawanpis pagta micuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tsayta ricaycurmi ley yachatsicugcuna Señor Jesucristopa discïpuluncunata niyargan: “¿Imanirtan maestruyquicunaga impuestu cobragcunawan y mana alli rurag jutsasapacunawan pagta micun?” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tsayta wiyaycurmi Señor Jesucristo nirgan: “Geshyagyashacunam mëdicotaga wanayan, manam sänucunatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pero ¡Aywar yachacuyay! ¿Diospa Palabranchö imapag gellgashga canganta? ‘Nogaga runamajiquita cuyarnin llaquipänayquitam munä. Manam munätsu Dios Yayapag nir, üshacunata wañutsirnin cushicatsimänayquita.’ Nogaga manam jutsannagcunata ashigtsu shamushcä, sinöga jutsasapacunata ashirnin perdonanäpagmi shamushcä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Bautistapa gatiragnincuna shayämurmi, Señor Jesucristota tapurnin niyargan: “Nogacunawan fariseocunaga imaypis ayunayämi, ¿imanirtan discïpuluyquicunaga ayunayantsu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Señor Jesucristonam contestargan: “¿Acäsu llaquishgacu cayanman juc casamientuman invitashgacuna, noviowan pagta caycarga? Pero juc junag chämungam noviota apayänanpag. Payta apasquiyaptinmi sïga llaquishga car mana micurnin ayunayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Manam ni pipis macwa rachishga llatapata mushog remenduwan remendantsu. Si mushog tëlawan remendaptinga gentirmi mas peor rachiscatsinga. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tsaynöllam ni tsayrag rurashga aswatapis jirpuntsictsu macwa tsillishga puyñumanga. Tsay macwa puyñu mushog aswawan paquisquiptinmi, puñuntin aswapis jancat ushacasquiyanga. Tsaymi tsayrag mushog rurashga ashwataga, juc mushog puyñuman wiñantsic ishcanpis mana ushacayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsaychö Señor Jesucristo parlaycaptinmi, judiucunapa juc mandagnincuna chaycamur puntanman gongorpacuycur nirgan: “Warmi wamrallämi wañuycanna, si gam shamurnin maquiquita jananman churaycuptiquiga cawangaragmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsaypita sharcurnam Señor Jesucristo discïpuluncunata pusharcur tsay runawan aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tsaypa aywaycaptinnam chunca ishcay watana yawar apaywan geshyagyasha warmi, Señor Jesucristopa gepallanpa witiycur llatapanpa puntanta yataycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tsay warmiga yarpayllanchö nirgan: “Llatapanpa puntanta yataycurllam cuticasquishag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tsaynö yataycuptinmi Señor Jesucristo tumaycurnin, warmita ricaycur nirgan: “Ama mantsacaytsu, ïja. Rasumpa firmi criyicamungayquipitam cuticashcanqui.” Tsay warmiga jina öram sänu ticrasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tsaymi mandacug runapa wajinman Señor Jesucristo chaycurnin, runacuna lautata töcarnin vigiliaycäyagtawan timpull timpull wagaycäyagta tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tsayta ricaycurmi Señor Jesucristo nirgan: “Caypita witiyay. Wamraga puñuycanllam, manam wañushgatsu.” Tsaynö niptinnam asipäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tsaynö runacunata gargosquirmi wamra caycanganman yaycusquir, maquipita achcurcurgan. Tsaymi jina öra cawascamur sharcamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Señor Jesucristo tsaynö cawatsimungantam, maytsay estansiacunachöpis musyayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsaypitam Señor Jesucristo yargosquir aywacuptin, ishcay gapracuna gepanta aywarnin gayaraypanö niyargan: “¡Rey Davidpa ayllun Jesús, llaquipaycäyällämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Juc wajiman yaycusquiptinnam, tsay gapracunapis gepanta yaycuyargan. Tsaymi Señor Jesucristo tapurnincuna nirgan: “¿Gamcunaga rasumpacu criyiyanqui cuticätsiyänagpag poderyog cangäta?” Tsaynö niptinnam “Aumi, Taytay criyicuyällämi” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tsaymi Señor Jesucristo ñawincunata yataycur nirgan: “Gamcuna criyiyangayquinö catsun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Maquinwan yataycuptillanmi ñawincuna sänu ticrasquiyargan. Tsaynö sänu ticrasquiyaptinmi, Señor Jesucristo nirgan: “Ama pitapis willacuyanquitsu caynö cuticätsiyangagtaga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","“Ama willacuyanquitsu” nicaptinpis, ishcan aywarmi llapan runacunata marcan marcan Señor Jesucristo cuticätsinganta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gapracuna aywacusquiyaptinmi, Señor Jesucristoman runacuna apayämurgan supay yaycusquir upayätsishga runatapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tsaymi Señor Jesucristo supayta gargosquiptinrag tsay upa parlarnin gallaycurgan. Tsaychö runacunanam mantsacashga ricapänacur ninacuyargan: “¡Cay runa rurangantanöga manam ni imaypis cay Israel naciunchöga ricashgatsu cantsic!” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tsaynö niyaptinmi fariseocuna niyargan: “Cay runaga supaycunata gargon, mas poderyog Supaypa poderninwanmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Señor Jesucristom marcan marcan purir, israelcuna goricäyänan wajicunachö yachatsicurgan Mandacuy Reynonpa Alli Willacuyninta. Tsaynöllam tucuyläya geshyaywan geshyagyashacunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Runacunata ricaycurmi Señor Jesucristo llaquiparnin cuyapar yarpargan: “Cay runacunaga alläpa maltratashga, mana salvacuyta puedirmi, mantsacar witsicashga mitsigninnag üshacunanö yarpachacuywan llaquishga caycäyan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsaymi discïpuluncunata Señor Jesucristo nirgan: “Rasumpam atscag runacuna imayca atsca cosëchatanö gorinapag cayan. Pero cosechagnö gorigcunanam wallcaglla cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tsaymi Dios Yayata mañacuyay arugnincunata cachamunanpag, imayca cosëchata gorignö Mandacuy Reynonman llapan runacunata goriyämunanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tsaypitam Señor Jesucristo chunca ishcay discïpuluncunata gayasquir, poderninta garargan runacunapita supaycunata gargoyänanpag, tucuyläya geshyaywan geshyagyashacunatapis cuticätsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cay chunca ishcay discïpuluncunapam shutincuna cargan: Simón (juccag shutinmi Pedro cargan), Simónpa waugen Andrés, Zebedeopa tsurincuna Santiago Juanwan. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolome, Tomas, impuestu cobrag Mateo, Alfeopa tsurincag Santiago, Tadeo, ");
INSERT INTO qxnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Celote niyangancag” Simón y Señor Jesucristota ranticug Judás Iscariote niyangan. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Señor Jesucristom chunca ishcay discïpuluncunata caynö yachatsirnin cachargan: “Ama juclä runacunapa marcancunaman ni Samaria marcacunapapis aywayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mas bien Israel runacunallaman aywayanqui, paycunam imayca ogracashga üshanö caycäyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aywarnin yachatsicur niyanqui: ‘Öra chaycämunnam rasumpa firmi criyicugcunata Dios Yaya Mandacuy Reynonman gorinanpag. Tsay cielu Reynonchömi imayyagpis gamcuna cawayanqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Geshyagyäshacunata cuticätsir wañushgacunatapis cawatsiyanqui. Garan ismuypa wicuwan geshyagyashacunatapis limpiu cayänanpag cuticätsiyanqui. Supaycuna runacunaman yaycushgatapis gargoyanqui. Gamcuna Dios Yayapa poderninta denbaldilla chasquiyangayquinö, tsaynö denbaldilla yachatsicurnin llapan geshyagyashacunatapis cuticätsiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ama gellayta, cobrita ni goritapis alporjayquichö apayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ama millcapatawan mödacuyänayquipag llatapayquicunata ni cutamatapis apayanquitsu. Shucuräyangayqui llangeyquicunallawan aywar, ama ni tucrutapis apayanquitsu. Arupucugcunataga imaypis patsätsirmi micuynincuna garayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“May marcaman charpis, alli rurag runallata ashiyanqui. Wajinman posadacurga tsayllachö cacuyanqui juclä marcaman aywayangayquiyag. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tsay wajiman charga, ‘Shumag alli päsacuychö cawacuyay’ nir, wajiyogta saludayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tsay wajiyog alli runa captinga, Dios Yayapa bendiciunnin chasquinganmi, wajinchö caycagcunawan quëdanga. Pero mana alli runa captinga, tsay bendiciunpis paycunawan mana quëdarmi gamcunaman cutimunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chäyangayqui marcachö o wajichö yachatsicuyänayquipag mana chasquiyäshuptiquiga, tsay marcapita o wajipita chaquiquicunachö allpatapis tapsicusquir aywacuyanqui. Tsaynö chaquïcunapita allpata tapsicusquir aywacuyangayquim, imayca ‘Mana chasquiyämangayquipitam Dios Yayapa castïgun gamcunaman chämunga’ nignö canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rasuntam niyag: Dios Yayam tsay marcachö täcugcunataga cay patsa ushacangan junagchö alläpa mantsacaypag castiganga, Sodoma y Gomorra marcacunata ninawan rupatsir ushacätsinganpitapis masrag. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Gamcunataga cachayag imayca atogcunapa rurinman üshacunata cachaycugnömi. Tsaymi gamcunaga imayca culebra imatapis alläpa musyag cangannö shumag yarpachacur, imayca palomanö jutsannag cayay. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Prësur autoridäcunaman aparmi, Israel runacunalla goricäyänan wajicunachö magar astayäshunqui. Tsaymi cuidädu cayay. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nogaraycum reycunaman mas puedigcag mandacug runacunaman apayäshunqui. Tsay reycunatawan mandacug runacunata y mana judiucagcunatam noga pï cangäta willacurnin musyatsicunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero autoridäcunaman apayäshuptiqui ama yarpachacuyanquitsu, ‘¿Imanishagrag? ¿Imanörag parlashag?’ nirga. Parlayänayqui öram Dios Yaya yachatsiyäshunqui imata parlayänayquipagpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tsaynö parlayaptiquim, cieluchö Taytayqui Dios Yayapa Espïritun parlanga yarpayniquicuna mana captinpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Waquincagnam waugencunata ranticurnin autoridäcuna wañutsiyänanpag apatsiyanga. Taytancunanam wamrancunata wañutsiyänanpag apatsinga. Waquincagpanam wamrancunalla taytancunapawan mamancunapa contran shärirnin, autoridäcunaman apatsiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nogata gatiräyämaptiquim, llapan runacuna chiquiyäshunqui. Pero mayganpis rasumpa firmi criyicurnin wañunganyag gatirämagcagga, salvacashgam canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcachö wañutsiyta munayäshuptiquiga, jucläpa geshpir aywacuyanqui. Rasuntam niyag: Gamcuna llapan Israel naciunta marcan marcan manarag purir ushayaptiquim, Diospita Shamushga Runa cay patsaman cutimushag. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Maestrunpita masga manam estudiagcunaga mandacuy yachayyogga cayangatsu. Servicug wätayninpis manam mas poderyogtsu patronninpitaga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Discïpuluncuna cushicuyanman maestrunnö carga. Wätayninpis cushicungam patronninnö carga. Tsay wajiyog patronta ‘Satanas’ nicarga, ¿Masragchi tsay waquincag aylluncunatawan servignincunataga despreciayanga? ");
INSERT INTO qxnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Tsaymi ama runacunapita mantsacäyaytsu. Imayca pacaragpis ricacangam. Pacayllapa imata rurayanganpis musyacangam. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tutapaypa niyangagta, junagpa willacuyay. Yangalla willayangagta, wajiqui jananpita gayaycächaypa llapan wiyayänanpag willacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wañutsicugcunapita ama mantsacuyaytsu. Wañutsishurniquipis, almayquitaga manam wañutsingatsu. Tsaypa rantinga mantsacuyay Dios Yayapa castïgunwan almay cuerpu infiernuman jancat ushacag aywayta. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Rasumpacu ishcay pishgota ranticuyan juc cobrillawan? Tsaynö caycaptinpis Dios Yaya cay patsachö tsay cada pishgocunapagmi yarpachacun. Tsaymi Pay mana munaptinga ni jucllayllapis cay patsaman shicwamunmantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dios Yayagam agtsayquicuna ayca cangantapis juc juc yupashga catsin. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ama ni imapitapis mantsacuyaytsu. Atsca pishgocunapitapis masmi gamcunaga väleyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pipis runacunapa puntanchö ‘Nogam Señor Jesucristopag cä’ niptinga, nogapis cieluchö Dios Yayäpa puntanchö ‘Payga nogapam’ nishag. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero mayganpis runacunapa puntanchö nogapag ‘Manam Señor Jesucristota regëtsu’ niptinga, nogapis tsay runapagga Dios Yayäpa puntanchö ‘Manam regëtsu’ nishagmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ama nogapag yarpäyanquitsu ‘Señor Jesucristo shamur alli päsacuy cawaytam garamäshun’ nirga. Nogaga manam shamushcä alli päsacuy cawayta garayänagpagtsu, sinöga nogaraycu piñanacurnin raquicar cayänayquipagmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tsaymi noga shamungäraycu taytanwan tsurin, mamanwan warmi wawan, suegranwan llumtsuynin contra cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Runacunapa chiquignincunaga quiquincunapa wajincunachö aylluncunallam cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Maygan runapis taytantawan mamanta nogapita mas cuyarga, manam nogapa cananpag merëcintsu. Pï runapis wamrancunata nogapita mas cuyarga, manam nogapa cananpag merëcintsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pipis imayca cruzta apagnö wañuyninyag servimar mana gatirämarga, manam nogapatsu canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pipis quiquinpa vïdanta salvayta munarpis, vïdanta ograngam. Pero pipis nogaraycu wañugcagga, rasumpam cieluchö mana ushacag cawayta taringa. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Gamcunata chasquiyäshurniquiga nogatapis chasquiyämanmi. Nogata chasquiyämarga, cachamagnï Dios Yayatapis chasquiyanmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pipis Dios Yayapa willacugnin shamugta chasquirga, tsay willacugnöllam Dios Yayapita juc premiuta chasquinga. Tsaynöllam juc runata alli rurag canganpita chasquirga, tsay runapis Dios Yayapita alli premiuta chasquinga. ");
INSERT INTO qxnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pipis nogapa gatiramagnï canganraycu, juc järu chuya yacullatapis wactsa umilde runacunata garaycuptinga, rasumpam Dios Yayapis alli premiuta garanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Señor Jesucristo chunca ishcay discïpuluncunata yachatsirnin ushasquirmi, Galilea provincia marcacunachö täcugcunata yachatsirnin willacunanpag aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tsay witsanmi Juan Bautista carcelchö gaycuraycargan. Tsaychö gaycuraycarmi Señor Jesucristo willacurnin milagrucuna ruraycanganta wiyargan. Tsayta wiyasquirmi Juanga gatiragnincunata cachargan, ");
INSERT INTO qxnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Señor Jesucristota tapuyänanpag: “¿Gamcu canqui Dios Yayapita shamugpagcag Cristo? o ¿Juctaragcu shuyäyäshag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tsaynö tapuyaptinnam nirgan: “Juanman cutirnin willayay caychö wiyayangayquitawan ricäyangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cananga gapracunam ricäyan, mana purigcunapis puriyanmi. Garan ismuypa wicuwan geshyagyashacunam cuticarnin limpium quëdayan. Upacunam wiyayan. Wañushgacunam cawayämun. Umilde wactsacunatam salvaciunpag Dios Yayapa Alli Willacuyninta willan. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tsaynö nogaman imaypis rasumpa firmi criyimugcagga, alläpa cushishgam canga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tsaypita Juan Bautistapa gatiragnincuna cutisquiyaptinnam, goricashga runacunata Juan Bautistapag Señor Jesucristo parlapar nirgan: “¿Imata ricagtan tsunyachö Juan caycanganman aywayargayqui? ¿Wayrawan shogosh cuyugta ricagcu? ");
INSERT INTO qxnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Sinöga ¿Imagtan aywayargayqui? ¿Allish llatapashga runata ricagcu? Allish llatapashga runatagam ricantsic, reypa palacionchö caycäyagta. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tsaypunga ¿Imata ricagtan aywayargayqui? ¿Dios Yayapa profëtan ricagcu aywargayqui? Juan Bautistam nogapa puntäta shamurnin willacurgan. Tsaymi payga llapan unay profëtacunapitapis mas allicag profëta. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Paypagmi Diospa Palabran gellgashgachöpis nirgan: ‘Gam chänayquipagmi puntayquita juc willacugnïta cachashag, imayca nänita allitsagnö runacunata, jutsayquicunata dëjasquir Dios Yayaman firmi criyicuyay ninanpag. Tsaynömi willacatsishag imayca alli nänipa aywagnö chänayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rasuntam niyag: Manam ni pipis Juan Bautista alli importanti cangannöga ni pipis cananyag cashgatsu. Pero Dios Yayapa Mandacuy Reynonchö mas umildecagmi, Juan Bautistapitapis mas alli importanti runa canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan Bautista shamunganpita cananyagmi Dios Yayapa Mandacuy Reynon chaycamun llapan poderninwan. Tsaymi runacuna gechunacurrag Dios Yayapa Reynonman yaycuyta munayan, Alli Willacuyninta wiyarnin cäsucur. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Llapan profëtacunawan Moiséspa leyninpis, Dios Yayapa Mandacuy Reynonpagmi willacuyargan. ‘Caynömi canga’ nir, asta Juan Bautista shamunganyag. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si gamcuna rasumpa chasquiyta munayaptiquiga: Profëta shamunanpag cangan Elíasmi, Juan Bautistaga. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wiyagcagga shumag tantiyacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Canan tiempu runacunataga imawanrag iwalatsïman? Imayca pläzachö pucllarnin jamaraycag wamracunanömi, waquincagta gayaparnin caycäyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Lautata töcashgapis manam tushuyargayquitsu. Llaquinaypagta cantashgapis manam wagayargayquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tsay Juan Bautistaga ichicllata micurmi ni vïnotapis upyargantsu. Segïdum ayunar mallaglla cargan. Tsaynö cawaptinmi gamcunaga ‘Juan Bautistaman supaymi yaycushga’ niyargayqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tsaymi Diospita Shamushga Runa car, micurnin upyar captï niyäman: ‘¡Tagay runaga alläpa micug upyagmi, amïgoncunapis impuestu cobragcunwan mana allita ruracag jutsasapacunam!’ ¡Pero Dios Yayapa yachayninga musyatsicun, llapan imaycatapis allillata rurar cawacuymi!” ");
INSERT INTO qxnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Señor Jesucristom tsay marcacunachö mas atsca milagrucunata rurarnin piñapargan. Tsaynö atsca milagrucuna ruranganta ricaycarpis, jutsancunata manam arepenticur dëjayargantsu. Tsaymi Señor Jesucristo tsay marcacunapa contran nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Alläpa llaquipaypagmi Corazin marca canqui! ¡Llaquipaypagmi Betsaida marca canqui! Tiro marcachöwan Sidon marcachö ricäyangayquitanö ricarga, unaynam llapan jutsancunata dëjayanman cargan. Jutsancunata rasumpa dëjayanganta musyacänanpagga, unaynam yana llatapata llatapacurcur, gagllancunata uchpawan pintacuyanman cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gamcunatam niyag: Cay patsa ushacangan junagchömi, Dios Yaya juzgayäshurniqui castigayäshunqui, Tirowan Sidon marca runacunata castiganganpitapis masrag. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pero gamga Capernaum marcayqui ¿cieluyag apashga canantacu yarpanqui? Tsaynö apashga canganpa rantinmi, infiernuman jitarpushga canga. Sodoma marcachö milagrucunata marcayquichö rurangätanö rurashga captïga, cananyagmi llapan imaycanpis caycäyanman cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nogam niyag: Cay patsa ushacangan junagchömi, Dios Yaya juzgayäshurniqui castigayäshunqui, Sodoma marca runacunata castiganganpitapis masrag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tsay öram Señor Jesucristo nirgan: “Tayta Dios, cieluchö patsachöpis Gammi alläpa mandacug canqui. Imanö cangayquitapis pacashcanquim musyagtucugcunapitawan alläpa estudiagcunapitapis. Tsaypa rantinmi, imayca pishi wamranö umildecagcunata tantiyatsishcanqui. Tsaypitam alläpa cushishga alabag. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Au, Dios Yaya, tsaynö munarnin rurangayquim alläpa cushitsishunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tayta Diosmi llapan imaycacunatapis nogapa mandacuynïman churashcanqui. Tsaymi Dios Yaya gamlla pï noga cangätapis rasumpa regemanqui, manam waquincagcunaga regeyämantsu. Tsaymi noga Tsurinlla Dios Yayatapis regë. Manam ni pipis Dios Yayataga regengatsu, mana regetsiptïga. Noga Tsurin regetsingä runacunallam, Dios Yayataga rasumpa regeyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Llapayqui llaquicur sufriywan pishipashgacuna, nogaman shayämuy shütatsiyänagpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yanapayäshayquim imayca yüguta matancagnö, nogapita shumag yachacuyänayquipag. Nogaga alli shongoyog umildem cä. Tsaymi nogachö tariyanqui llapan yarpachacur llaquicuyniquicunawan imayca ajayaycunapitapis shütarnin jamaycuyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Manam ajatsu imayca yuntashganö nogapa yügö apaywan gepï aparïga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juc jamay junagchömi Señor Jesucristo discïpuluncunawan trïgucuna rurinpa aywaycäyargan. Tsaymi discïpulucuna mallagasquir, trïguta quiptusquir uchuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tsaynö rurayanganta ricaycurmi, fariseocuna Señor Jesucristota niyargan: “Ricay, canan jamay junagchö leynintsic mandacungannö proibido caycaptin, discïpuluyquicunaga tsayta ruraycäyan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tsaymi Señor Jesucristo nirgan: “¿Manacu Diospa Palabran gellgashga libruchö liyiyashcanqui, unay rey David yanagencunawan mallagasquir ruranganta? ");
INSERT INTO qxnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Rey Davidga Dios Yayata adorayänan wajiman yaycusquirmi, ‘Cay tantaga Dios Yayallapagmi’ niyangan tantata jipiscamur, yanagencunawan micusquiyargan. Musyayangaquinöpis leynintsic mandacunganchöga tsay tantaga mandacug sacerdöticunallapagmi cargan. Davidpagwan yanagencunapagpis tsay tantata micuyänanpagga proibidom cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Manacu Moisés gellgangan leyta liyiyashcanqui? Jamay junagchöpis manam ni ima mana allitatsu rurayan, sacerdöticuna Dios Yayata adorayänan jatun wajichö arurnin mana jamarpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tsaymi niyag: Nogagam mas mandacuy poderyog cä, Dios Yayata adorayänan wajipitawan tsay llapan mandacug runacunapitapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","¡Mä yarpachacuy! ¿Imapagtan Dios Yaya nirgan? Runamajiquita llaquipaptiquim, alläpa cushicü. Pero ‘Dios Yayapag’ nir, wätacunawan sacrificiuta rurarnin wañutsipacurga, manam cushitsimanquitsu. Tsay llapanta shumag tantiyarga, jutsannagcunata manam niyanquimantsu, ‘Gamga jutsata ruragmi canqui’ nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Noga Diospita Shamushga Runa carmi, jamay junagchöpis mandacug poderyog cä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsaypita Señor Jesucristo aywarmi, Israel runacunalla goricayänan wajiman yaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tsay wajichömi juc runa tsaquishga maquiyog caycargan. Tsaymi tsaychö waquincagcuna Señor Jesucristota acusayänanpag pantatsiyta munayargan. Tsaynö pantatsiyta yarparmi, Señor Jesucristota tapuyargan: “¿Allicu o manacu jamay junagchö geshyagyashacunata cuticätsishwan? Leynintsic mandacunganchöga, imayca aruytapis proibinmi. Pero ¿gamga, imaninquitan?” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Señor Jesucristonam nirgan: “¿Manacu maygayquipis jamay junagchö üshayquicuna uchcuman jegasquiptin jorgoyanquiman? ¿Acäsu cananga jamay junagmi jina ‘Wañucutsunpis’ nircu, dëjasquiyanquiman? ");
INSERT INTO qxnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tsay üshapitapis masmi juc runaga välen. Tsaymi llapan leynintsicpis mandacun jamay junagchö imatapis allicunallata ruranapag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tsaypitam runata Señor Jesucristo nirgan: “Maquiquita largamuy.” Tsaymi runaga maquinta largasquiptin, juccag maquin cangannölla jancat cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pero fariseocunanam goricayänan wajipita piñashga yargosquir willanacuyargan, “¿Imanöllarag cay Jesústa wañuscatsishwan?” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsaynö yachatsinacur wañutsiyänanpag caycäyanganta musyasquirmi, Señor Jesucristo aywacurgan. Tsaynö aywacuptin atscag runacuna gatiyaptinmi, llapan geshyagyashacunata cuticätsirnin nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“Ama ni pï cangätapis willacuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tsaynömi Diospa profëtan Isaías unay gellgangan cumplirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Caychömi acrangä servimagnï caycan. Paytam alläpa cuyä. Tsaymi alläpa cushitsiman. Paypa jananmanmi Espïritu Santota churashag poderöso cananpag. Tsaymi payga llapan naciuncunata juzgarnin willacunga, jutsayogcagta castigar jutsannagcagtaga mana castiganäpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Manam imatapis reclamarnin gayaycachangatsu. Manam vozllantapis cällicunachö ni maychöpis wiyayangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tsillishga shogoshpis manam paquingatsu ni wañunar goshniycag mëchapis manam wañungatsu, asta llapan alli ruraycuna vencenganyag. Tsaynöllam wañunagnö llaquishga caycagcunatapis, mushog änimuta garanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Llapan naciun runacunam Payta cushishga yätsicur confiacuyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsaypitanam Señor Jesucristoman juc gapra, mana parlag upapa shongonman supay yaycushga runata pushayämurgan. Tsay runata Señor Jesucristo cuticascatsiptinmi, ñawinpis ricargan y shiminpis parlargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tsaychö goricashga runacunam mantsacashga Señor Jesucristopag tapunacur niyargan: “¿Cayga manatsurag Dios Yayapita shamunanpag unay rey Davidpa ayllunpita runa?” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsayta wiyaycurmi fariseocuna niyargan: “Cay runataga supaycunata mandag quiquin Satanasmi podernin entregashga supaycunata gargonanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tsaymi Señor Jesucristo imanö yarpaycäyanganta musyarnin nirgan: “Juc naciunchö quiquincunapura chiquinacur maganacuyaptinga, tsay naciunga jancatmi ushacanga. Tsaynöllam juc marcachö täcug runacunawan juc wajichö täcugcunapis, quiquincuna pura chiquinacurnin raquicar ushacäyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Si tsaynö quiquin Satanas supaynincunata chiquirnin gargorga, quiquillanmi jancat gargocurnin raquicaycan. Tsaynö carga ¿imanötagshi mandacuyninchöpis poderyog canman? ");
INSERT INTO qxnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gamcunaga yarpäyanqui quiquin Satanaspa poderninwan supaycunata gargongätam. Si tsaynö caycaptinga ¿pitan gatiragniquicuna supaycunata gargocuyänanpag podernincuna garashga? Tsaymi gatiragniquicunalla imata niyangayquitapis contrayqui juzgayäshunqui. Tsaynöpam rasumpa musyä mana tantiyarnin mana allicunallata yarpäyangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero Dios Yayapa Espïritu Santonpa poderninwan supaycunata gargoptïga, musyayay Dios Yayapa Mandacuy Reynon cay patsaman gamcunapag chämushgana canganta. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“¿Imanötagshi callpayog runapa wajinman yaycusquir, imantapis gechuyta puedinquiman manarag watarga? Tsay callpayog runata watasquirmi sïga, imaycantapis suwarnin gechunquiman. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Pipis nogapa favornï mana carga, chiquignï conträmi caycan. Tsaynöllam imayca cosechagnö Mandacuy Reynöman runacunata mana gorïsimar yanapamagga, goringantapis jancat witsisquingalla. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Tsaymi rasumpa niyag: Runacuna imayca jutsancunata rurayanganpitawan imayca mana alli parlayanganpitam Dios Yayaga perdonanga. Pero Espïritu Santopa contran mana allita parlayanganpitam sïga, ni imaypis perdonangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Diospita Shamushga Runa cangäpita, conträ mana alli parlag runacunataga Dios Yaya perdonangam. Pero Espïritu Santopa contran mana alli parlag runacunatam sïga, cay vïdachö ni wac vïdachöpis Dios Yaya perdonangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Si gam shumag juc plantata cuidaptiquiga, tsaynö allishllatam wayungapis. Pero si mana alli cuidaptiquiga, tsaynö mana allillatam wayungapis. Plantatagam wayuyninpita alli o mana alli cangantapis regentsic. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Culebra castacuna! Gamcunaga mana alli yarpayniquicuna captinmi, allitaga ni imaypis parlayanquitsu. Tsaymi runaga shongonchö yarpangannölla imatapis parlayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Shongoncuna alli captinga, allitam parlayan. Mana alli shongoyog carga, tsaynö mana allillatam parlayanpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero rasuntam niyag: Cay patsa ushacangan junag juiciu finalchömi, Dios Yaya runacunata juzganga cada palabrancunapita imayca mana väleg parlaycunata parlayanganpita. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tsaymi quiquiquicunapa palabrayquicunallawan juzgayäshuptiqui, salvacashgapis o condenarnin catigashgapis canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tsaypitanam waquincag fariseocunawan ley yachatsicugcuna Señor Jesucristota niyargan: “Maestru, nogacuna rasumpa ricarnin musyayänäpag mä juc milagruta ruramuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tsaymi Señor Jesucristo nirgan: “Gamcunaga llutan mana alli jutsacunata rurag cayniquicunawanmi milagrutarag ricayta munayanqui. Pero manam ni ima milagrullapis cangatsu, unay profëta Jonáswan ruracanganpitaga. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tsay Jonásmi quimsa junag y quimsa pagas, jatun pescädopa pachanchö cargan. Tsaynöllam quimsa junag y quimsa pagas Diospita Shamushga Runapis pamparanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tsaymi cay patsa ushacangan juiciu finalchö Jonáspa tiempunchö cawag runacuna, mana alli rurag cayangayquipita juzgarnin shimpiyäshurniqui condenar garpuyäshunqui. Tsay Ninive marca runacunam profëta Jonás willacunganta wiyarnin cäsucur, jutsancunata dëjasquir Dios Yayaman cutirnin rasumpa mas firmi criyicuyargan. Tsaymi canan caychö caycag Diospita Shamushga Runaga, unay profëta Jonáspitapis mas poderöso. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tsaynöllam cay patsa ushacangan juiciu finalchö, canan cawaycag runacunata Sabá naciunpita reyna juzgarnin shimpiyäshurniqui condenayäshunqui. Tsay reynaga alläpa carupitam shamurgan, Dios Yaya musyatsinganta unay rey Salomón parlagta wiyananpag. Tsaymi canan caychö caycag Diospita Shamushga Runaga, unay rey Salomónpitapis mas poderöso. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Runapita supay yargosquirmi, tsunya tsaqui patsacunapa aywarnin jamaycunapag sitiuta ashirnin purin. Tsaychö sitiuta mana tarirmi yarpan: ");
INSERT INTO qxnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Mejorga yargamungä wajïnö runaman cuticushag.’ Tsaymi tsaynö cutirninga yargamungan runataga tarin, imayca jäcug alli pitsapacurnin churapacushga limpiu wajitanö. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsayman cutirga, ganchis mas quiquinpitapis mas poderyog supaycunatam pushanga. Tsaymi llapan yaycusquir tsay runallachö täcuyaptin, punta canganpitapis mas peor mana alli runa canga. Tsaynöllam canan cawaycag runacunapis mas peor mana alli ticraycäyan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Señor Jesucristo tsaynö yachatsicuycaptinmi, mamanwan waugencuna Paywan parlayta munarnin wagtachö shuyaraycäyargan. Tsaynö wagtallachö cayaptinmi, ");
INSERT INTO qxnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","mayganchi Señor Jesucristota willarnin nirgan: “Mamayquiwan waugeyquicunam wagtachö gamwan parlayta munar shuyaycäyäshunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tsaynö willagnintanam, Señor Jesucristo nirgan: “¿Pitan nogapa mamäwan waugëcuna?” ");
INSERT INTO qxnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tsaypitam discïpuluncunata dëdunwan señalar nirgan: “Caycunam mamäwan waugëcunaga cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pipis cieluchö caycag Dios Taytä munangannö allillata rurar cawagcunam mamäwan waugëcuna y panïcunapis.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsay wajipita yargosquirmi, Señor Jesucristo gocha cuchunman chaycur jamargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsayman maytsicag goricäyaptinmi, Señor Jesucristo büquiman lätarcur jamargan, atscag runacuna gocha cuchun pläyachö ichiraycäyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tsaymi Señor Jesucristo tucuyläya iwalatsicuycunawan yachatsicur nirgan: “Juc runam murucug aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tsay runa muruta magtsiptinmi, waquincagga näniman shicwasquiyaptin pishgocuna shamurnin upshasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tsaynöllam waquincag murupis ranra allpaman shicwasquir, mana atsca allpa captin saslla jegascayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tsaymi chapanchö wallcalla allpa captin, rupay yargamur alläpa achachaptin tsaquisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquincag murunam cashacuna rurinman shicwasquir, jegarcamugllata cashacuna gopirnin jancat ushacascatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero waquincag murunam alli allpaman shicwayargan. Tsay alli allpaman shicwacag murucunaga mas alli jegamur pogormi, cada espïgachö juc pachacta, waquinnam sogta chuncata y waquincagnam quimsa chuncayag wayuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tsaynö willacungäta shumag wiyacur tantiyacuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsaypitanam Señor Jesucristoman discïpuluncuna witiycur tapuyargan: “¿Imanirtan imawanpis iwalatsicur runacunata yachatsicunqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tsaymi Señor Jesucristo nirgan: “Gamcunallatam imayca pacaraycagnö Dios Yayapa Mandacuy Reynon imanö canganta entenditsiyäshushcanqui. Pero waquincag runacunataga manam entenditsinragtsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Rasumpa firmi criyigcunatam Dios Yaya musyatsinga, alli criyicuyninwan Payta mas regeyänanpag. Pero mana rasumpa firmi criyigcunataga ichiclla criyicuyninwan musyangantapis jancatmi gongascatsinga. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsaymi imaycawanpis iwalatsicuypa yachatsicü. Ricaycarpis mana ricagnö wiyaycarpis mana wiyagnömi cayan. Manam ni juc tantiyacuyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tsaymi canan cumpliycan Dios Yayapa unay profëtan Isaíaswan gellgatsir ningan: ‘Wiyaycarpis manam ni imay entendir musyayanquitsu. Ricaycarpis manam ni ima gocuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tsaymi cay runacunaga chucru shongoyog caynincunwan, Diospa Palabrantaga ni ichicllatapis yarpaynincunaman entendir chasquiyantsu. Mana wiyarmi ni juc entendirnin tantiyacuyantsu. Ñawincunapis imayca gepillashganö ricäyantsu. Tsaynöllam rinrincunapis mana wiyananpag y yarpaynincunawan mana tantiyayänanpag tsaynö cayan. Si tsaynö mana carga nogamanmi cutiyämunman cargan. Tsaymi nogaman cutiyämuptinga jutsancunapita perdonar cuticätsirnin salväman cargan.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Pero cushicuyay ricarnin cuentata gocur wiyarpis tantiyacugcuna. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tsaymi rasunta niyag: Dios Yayapa unay profëtancunawan waquincag alli ruragcunam y atscagmi alläpa ricayta munayargan canan ricaycäyangayquita. Tsaynöllam wiyaycäyangayquitapis wiyayta munayargan. Pero alläpa munarpis manam ricäyargantsu ni wiyayargantsu gamcunanöga. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Canan wiyarnin musyay murucugman iwalatsicuypa willacungäta. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dios Yayapa Mandacuy Reynonpa Alli Willacuyninta wiyaycar, mana tantiyagcunaga muru näniman shicwagnömi cayan. Tsaymi shongonchö mana criyicunganpita Supay shamur, Alli Willacuy wiyangantapis gongatsinga, imayca pishgocuna muruta upshayangannö. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pero pipis Dios Yayapa Alli Willacuyninta wiyaycur, saslla cushishga criyicurga, imayca ranra allpaman muru shicwagnömi cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsaymi chapanchö allpa mana captin, achaywan tsaquirnin saslla shicwagnö, Dios Yayapa Alli Willacuyninraycu runacuna chiquirnin gaticachar sufritsiyaptin, imayca mana allicunamanpis saslla shicwanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Waquinnam imayca casha rurinman muru shicwashganö cayan. Dios Yayapa Alli Willacuyninta wiyaycarpis, quiquincunapa ruraynincunallapag mas yarpachacur, engañacug riquësacunallapag alläpa yarparäyan. Tsaynö imaycacunallapag yarpachacurmi, Dios Yayapa Alli Willacuyninta wiyaycarpis cäsuyantsu, imayca juc planta mana wayugnö. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero Dios Yayapa Alli Willacuyninta wiyarnin, shumag tantiyagcagga alli allpaman muru shicwagnömi cayan. Tsaycag runacunaga imayca juc pachacyag, sogta chuncayag y quimsa chuncayag wayugnömi cayan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Señor Jesucristo yapay iwalatsicuypa yachatsicurgan: “Dios Yayapa Mandacuy Reynonga caynömi: Juc runam chacranman alli trïguta mururgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tsaypita puñucasquinganyagmi chiquignincuna aywaycur, trïgu murushgaman mana alli gorata murusquir aywasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tsaymi trïgu espigar gallaycuptin, mana alli gorapis espigar gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Arugnincunanam yarpachacurnin patronninman aywar tapuyargan: ‘Taytay, gamga alli murutatsag murutsirgayqui, ¿Maypitatan mana alli goracunaga espïgaycämun?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tsaynö tapuyaptinnam ‘Chiquimagnïmi tsayta rurashga’ nirgan. Tsaypitanam tapuyargan: ‘¿Taytay munanquicu tsay gorata tirarnin jipiyänäta?’ nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tsaynö niyaptinnam nirgan: ‘Ama, tsay gorata tirayaytsu; trïguntinmi tiracanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jina trïguwan iwal pogocutsun asta sëgayag. Sëgachönam mincaycunata mandashag puntata mana alli goracunata goriyänanpag. Tsaytanam wancutsishag waycatsinäpag. Tsaypitam trïguta goriscatsir gollgäman churatsishag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Señor Jesucristom shumag tantiyacuyänanpag ejempluwan willacur, imanö cangantapis nirgan: “Dios Yayapa Mandacuy Reynonga juc runa chacranchö mostäzapa chushu murunta murungannömi. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Llapan murupitapis mas chushum tsay muruga. Chushu caycarpis, waquincag gorapitaga mas wiñarmi imayca jachanö jatuncaray. Tsaymi pishgocunapis rämancunachö geshuncuna rurayan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Señor Jesucristom yapay ejemplucunawan willacur nirgan: “Dios Yayapa Mandacuy Reynonga caynömi: Juc warmi quimsa almun jarinaman levadürata pogonanpag tallungannö.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cay llapantam Señor Jesucristo maytsicag runacunata imaycawan iwalatsicuypa yachatsicurgan. Imaycawanpis mana iwalatsicuypaga manam yachatsicurgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tsaynö Señor Jesucristo yachatsicuptinmi, Dios Yayapa unay profëtan willacur ningan cumplirgan: “Imaycawanpis iwalatsicuypam yachatsicushag. Cay patsata Dios Yaya camanganpitam asta cananyag pacaräcushga manam ni pipis musyashgatsu. Tsaymi cananga tsay llapanta willacü.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsaychö goricashga runacunapita despedicusquirmi, Señor Jesucristo wajiman yaycurgan. Wajiman yaycusquiptinnam discïpuluncuna witiycur niyargan: “Imaycawan iwalatsicur yachatsicungayquita tantiyaycatsiyämay mana alli gorata chacraman murunganta.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tsaymi Señor Jesucristo nirgan: “Alli muruta murugcagga noga Diospita Shamushga Runam cä. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chacraga cay mundum. Alli trïgu yurigcagga Dios Yayaman rasumpa firmi criyicugcunam. Mana alli goraga Supaypa servignincunam cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chacrayogta chiquir mana alli gorata murugcagga Supaymi. Tsaymi cosëchaga cay patsa ushacangan juiciu final junag canga. Tsay cosëcha gorigcunagam angelcuna cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Gorata gorisquir ninawan rupatsingantsicnömi, cay patsa ushacangan junagchö canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dios Yayapa Tsurinmi angelcunata cachamuptin, llutata ruratsicugcunatawan mana alli ruragcunatapis llapanta goriyämunga, Dios Yayapa Mandacuy Reynonpita raquiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mana allicagcunataga gorisquirmi infiernuman gaycuyanga. Tsaychömi alläpa wagar ñacayanga, quiruncunatapis regochyätsirrag. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tsaymi alli rurag runacunaga imayca rupaynörag atsicyäyanga cieluchö Taytancuna Dios Yayapa Mandacuy Reynonchöpis. Wiyagcagga shumag entendir tantiyacuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Dios Yayapa Mandacuy Reynonga imayca chacrachö alläpa väleg riquësa gori gellay pamparagnömi. Juc runam riquësa pamparaycagta tarisquir, yapay patsallanman pampaycur cushishga aywan, llapan imaycantapis ranticusquir tsay chacrata llapan fortünantawan rantinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Dios Yayapa Mandacuy Reynonga alläpa chaniyog fïno perlascunata juc negocianti runa ashignömi. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tsay runaga alläpa chaniyog perlasta tarisquirmi, aywasquir imaycancunatapis ranticun tsay perlasta llapan gellayninwan rantinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Dios Yayapa Mandacuy Reynonga gochaman mällata jitarpur, tucuyläya pescädocunata achcugnömi. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pescädota mälla juntata gocha cuchunman jorgascamurmi, jamaycur allicagta acrarnin canastaman wiñar mana allicagtaga jitarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tsaynöllam cay patsa ushacangan junag juiciu finalchö, angelcuna shamurnin alli ruragcunata raquiyanga mana alli ruragcunapita. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mana alli ruragcunatam nina rupaycag infiernuman garpuyanga, wagarnin quiruncunapis regochyaptinrag sufrir cayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tsaynö willasquirmi Señor Jesucristo tapurgan: “¿Llapan yachatsicungätacu tantiyayashcanqui?” Discïpuluncunanam “Aumi” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tsaymi Señor Jesucristo nirgan: “Moiséspa leynin yachatsicug Dios Yayapa Mandacuy Reynonpag yachacurga, juc wajiyog runanömi canga. Tsay runaga imayca riquësan churacungancunatapis regermi, wajinpita alläpa chaniyog unay churaragcagtawan mushogcag munangancagta jorgamun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tsaynö iwalatsiycuypa yachatsicusquirmi, Señor Jesucristo tsaypita aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tsaypitanam Nazaret marcanman chaycur, Israel runacunalla goricäyänan wajichö marcamajincunata yachatsirgan. Tsaymi runacuna mantsacashga ricaränacur niyargan: “¿Imanönarag cay runaga cayläya yachaycunata yachacushga? ¿Ima poderninwanrag cay milagrucunatapis ruran? ");
INSERT INTO qxnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Cay runaga manacu carpintero Josépa tsurin? ¿Acäsu juctagcu? Mamanpis Maríam ¿Au? Manacu waugencunapis Santiago, José, Simón, Judás. ");
INSERT INTO qxnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Panincunapis manacu cay marcantsicchö llapan täcuyan. ¿Maypitanatan cayläya yachaytaga tarishga?” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsaynö rimarmi Señor Jesucristota rabiaparnin cäsuyargantsu. Tsaymi Señor Jesucristo nirgan: “Dios Yayapa willacugnin juclä marcapita captinga, runacunam respetarnin cuyayan. Pero marcamajincunawan wajinchö caycagcunaga mana respetarmi ni cäsuyanpistsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tsaynö mana rasumpa criyicuyaptinmi, Señor Jesucristo marcanchöga juc ishcay milagrucunallata rurargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tsay tiempuchömi Galilea provinciapa reynin Herodes, “Señor Jesucristo alläpa allicunatam ruraycan” nir, parlayagta wiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsaymi wätaynincunata Herodes nirgan: “Tsay runaga Juan Bautistam, wañunganpita cawamushga canga. Tsaymi poderyog canga imayca milagrucunatapis rurananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mas puntatanam rey Herodesga Juan Bautistata prësurnin achcuscatsir, cadenawan alli wataycur carcelchö gaycarätsirgan. Tsaynöga gaycatsirgan rey Herodespa warmin Herodias piñasquir “¡Tsay runataga gaycatsiy!” niptinmi. Tsay warmigam puntataga Felipepa warmin cargan. Felipenam rey Herodespa waugen cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan Bautistam mas puntata rey Herodesta nirgan: “Leynintsicga proibishunquim, waugeyquipa warminwan täcunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tsaynö ninganpitam rey Herodes Juanta wañutsiyta munargan. Tsaynö wañuytsiyta munarpis manam balurargantsu, “Atscag runacunam Dios Yayapa profëtan canganta criyiyan.” Tsaynöpam mantsaparnin wañutsiyta puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsaypitanam rey Herodespa santun cargan. Tsaymi Herodespa santunchö llapan gorpancunapa puntanchö Herodiaspa warmi wamran tushurgan. Tsay jipash tushunganmi rey Herodesta alläpa gustargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tsaymi jipashta nirgan: “Imata mañamaptiquipis mañamangayquitam garashayqui. Tsayta rasumpa cumplinäpag juracümi.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsaymi tsay jipash maman yachatsingannö Herodesta mañarnin nirgan: “Juan Bautistapa umanta juc plätuchö apatsimur entregaycamay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tsayta wiyaycurmi rey Herodes alläpa llaquishga cargan. Gorpancunapa puntanchö jurashga carmi, pengacuychö mana quëdananpag wätaynincunata mandargan jipash mañanganta apayämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tsaypitanam rey Herodes runancunata carcelman cachargan, Juan Bautistapa umanta rogosquir apayämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Juanpa umanta plätuchö chäratsimur jipashta entregaycuyaptinmi, mamanman apargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsaynö rurasquiyaptinmi, Juanpa gatiragnincuna chaycur ayanta aparnin pampacuyargan. Tsaypita aywarnam Señor Jesucristota willayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsaynö Juanta rurayanganta wiyasquir, Señor Jesucristo quiquillan aywacurgan gochapa büquiwan mana pipis cangan tsunyaman japallan cananpag. Pero maypa aywangantapis musyasquirmi, runacuna gatirnin aywayargan. Chaquillapa gocha cuchunpa marcancunapita runacuna Señor Jesucristo chänanpagcagman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Señor Jesucristo chaycur, maytsicag runacuna goricashgata ricargan. Paycunata ricarmi llaquiparnincuna cuticätsirgan geshyaycagnincunatapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Rupay jegaycaptinnam discïpuluncuna Señor Jesucristota niyargan: “Tsunyachömi caycantsic tutapaycannam. Runacuna aywacuyätsunna marcancunapa tsaychö micuyta rantiyänanllapagpis.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tsaymi Señor Jesucristo nirgan: “Manam convienintsu aywacuyänan, gamcuna micuynincuna garayay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tsaynö niptinnam niyargan: “Cayäpaman pitsga tantawan ishcay pescädollam.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Señor Jesucristonam nirgan: “Tsayta apayämuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tsaypitanam runacunata pampaman “Jamacuyay” nirgan. Tsaymi pitsga tantatawan ishcay pescädota achcurcur, cieluman ricarcur bendisarnin Dios Yayata mañacurgan. Tsaynö mañacusquirmi tsay tantata paquin paquin discïpuluncunata entregargan jamaycag runacunata aypurnin raquipuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tsaymi llapanpis pachancuna juntanganyag micuyargan. Micur ushasquiyaptinnam discïpuluncuna sobragta chunca ishcay canastacunaparag goriyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tsay micugcunata yupayaptinmi pitsga waranganö yashga runacunalla cayargan, warmicunatawan wamracunata mana yupaycäyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsaypita Señor Jesucristo discïpuluncunata büquiman yaycatsir nirgan: “Washa tsimpaman puntaycäyay.” Tsaypitanam goricashga caycag runacunata “Cuticuyayna” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Runacuna aywasquiyaptinnam, Señor Jesucristo juc jircaman aywargan tsaychö japallan Dios Yayaman mañacunanpag. Tsay jircachö japallan caycaptinmi patsa tutapasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pero tsay öraga büqui gocha pullanchöna caycargan. Alläpa wayrawan yacu lagchicar büquita tallpucätsir aywananta munargantsu. Tsaymi alläpa sufriyargan büquiwan mana aywayta puedirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Patsa waraycämuptinnam Señor Jesucristo yacu janallanta discïpuluncuna caycäyanganman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tsaynö yacu janallanta shamuycagta ricasquirmi, discïpuluncuna alläpa mantsacar gayaycachäyargan, “¡Wau, tagayga almatsag!” nir, mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Señor Jesucristonam nirgan: “Ama mantsacäyaytsu; valorta achcuyay. Nogam cä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tsaymi Pedro nirgan: “Señor, rasumpa gam carga, mandamay nogapis yacu janallanpa shamunäpag gamcagyag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tsaynö niptinnam Señor Jesucristo “Shamuy” nirgan. Büquipita yargosquir Pedro yacu janallanpa purir, Señor Jesucristoman tincugnin aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero alläpa wayrämuptinnam, Pedro mantsacar yacuman tallpucar gayarar nirgan: “¡Wau, Señor salvaycallämay!” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jina öra Pedrota maquinpita achcurcur, Señor Jesucristo nirgan: “Gam manam rasumpa criyishcanquitsu. ¿Imanirtan faltäshunqui rasumpa criyicuyniqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ishcan büquiman yaycusquiyaptinnam wayra pärasquir, wayrämurgannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Büquichö caycag discïpuluncunanam Señor Jesucristopa puntanman gongorpacuycur niyargan: “¡Rasumpam gamga Dios Yayapa Tsurin canqui!” nir, adorayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tsaypitanam Señor Jesucristo gochapa wac tsimpan “Genesaret” niyangan marcaman chargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tsaychö täcugcunanam Señor Jesucristo pï cangantapis regesquir maytsaypa willacatsiyargan. Tsaymi llapan geshyagyashancunatapis payman apayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Runacunanam Señor Jesucristota rugar niyargan: “Taytay llatapayquipa cuchullantapis geshyagyashäcuna yataycuyällänanpag dëjaycullay.” Tsaymi tsay llapan geshyagyashacunapis yataycurlla jancat cuticasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseocunawan ley yachatsicugcuna Jerusalénpita shayämurnin, Señor Jesucristoman chaycur tapuyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Unay awiluntsiccunapa costumbrincunaga manarag micur maquintsicta mayllacunapagmi yachatsicurgan. Pero gampa discïpuluyquicunaga ¿Imanirtan awiluntsiccunapa costumbrincuna yachatsicuyangannö cumpliyantsu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tsaynö niyaptinnam Señor Jesucristopis tapurgan: “Tsaypunga ¿Imanirtan gamcunapis Dios Yayapa mandacuyninta cumpliyanquitsu? ¿Dios Yaya mandayäshungayquita dëjasquirmi, quiquiquicuna munayangayqui unay costumbriquicunallata cumpliycäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tsaymi Dios Yaya nirgan: ‘Taytayquitawan mamayquita respetayanqui. Si pipis taytanwan mamanta mana respetarnin mana allicunata parlagcagga wañunanpag condenädum canga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero gamcunaga juc runa mamantawan taytanta ninanpagmi yachatsicuyanqui, ‘Mananam yanapayniquita puedïtsu llapan capamagnïtam Dios Yayata garaycushcä.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tsaynömi gamcunaga taytantawan mamanta mana respetarnin yanapayänanta mana munar yachatsiyanqui. Tsay costumbriquicunallawan yachatsicurmi, Dios Yaya rasumpa mandacungantaga imayca manacagmannö churayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Allitucug runam cayanqui! Rasuntam Dios Yayapa unay profëtan Isaías gamcunapag gellgar nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay runacunaga shimincunallanwanmi respetar “Dios Yaya, Dios Yaya” niyäman. Pero shongoncunachöga jucläyacunatam yarpaycäyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tsaynö alabar serviyämanganpis manam ni imapag välentsu, runacuna “Caynömi ruranantsic” niyangallanta yachatsicuyaptinga.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsaypitanam Señor Jesucristo runacunata “Witiyämuy” nirgan. Witiycuyaptinnam yachatsir nirgan: “¡Wiyacur shumag tantiyacuyay! ");
INSERT INTO qxnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","¿Imatan runata jutsaman apan, jutsasapa cananpag? Runataga manam micuy micungantsu jutsaman apan. Sinöga tucuyläya mana allicunata yarparnin parlarmi, jutsasapa cayman ticran.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Discïpuluncunanam Señor Jesucristopa puntanman witiycur niyargan: “¿Musyanquicu tsaynö ningayquita wiyarnin piñacur, tsay fariseocuna rabiapaycäyashungayquita?” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Señor Jesucristom nirgan: “Cieluchö caycag Dios Taytämi, llapan plantacunata chapapita tirar ushanga, quiquin mana plantangantaga. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","¡Ama cäsuyaytsu ley yachatsicugcunata! Paycunaga imayca gapranömi Dios Yayapa mandamientuncunata rurayan. Juc gapraga manam juccag gapramajinta pushanmantsu, ishcanmi pösuman jegarpuyanman.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsaymi Pedro nirgan: “¿Ima ninantan tsay yachatsiyämangayquiga? Entendiycatsiyämay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Señor Jesucristonam nirgan: “¿Gamcunapis manaragcu tantiyar entendiyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manacu entendinqui, ima micuypis pachantsicllaman yaycunganta? Tsaypitanam pachantsicpita päsacunlla. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero parlangantsiccunam sïga shongontsicpita yargamun. Mana allita yarpanganmi runata jutsaman apan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mana allicunata yarparga caycunatam runacuna ruracäyan: Runamajinta wañutsin. Casarashga o quiquillan carpis, jucnin jucninwan lluta puricur. Suwacurnin llullacur, jucpagpis rimarnincuna mana allicunata parlan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tsaynö yarparnin cawarmi, runacunaga jutsasapa cayan. Maquinta mana mayllacur micuptinpis, manam jutsasapayätsintsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tsaypita aywarmi Señor Jesucristo juclä caru marcacunapa Sidon, Tiro niyangan particunaman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tsaychömi juclä Canan naciunchö yuricug juc warmi täcurgan. Tsay warmiga manam israelitatsu cargan. Señor Jesucristota ricasquirmi, gayaycachar nirgan: “¡Señor, rey Davidpa ayllun, llaquipaycällämay! Warmi wamräman supay yaycurmi alläpa sufritsillan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Señor Jesucristoga manam ni imanirgantsu. Tsaymi discïpuluncuna rugayargan: “Tagay warmim yapay yapay gayaycachar gepantsicta shamun. ‘Aywacuy’ niy, manana mas fastidiamänapag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tsaymi Señor Jesucristo warmita nirgan: “Dios Yayaga cachamashga Israel runacunallamanmi, imayca ogracashga üshacunamannö.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tsaynö ninganta wiyaycarpis, tsay warmiga Señor Jesucristopa puntanman witiycurmi, gongorpacuycur nirgan: “¡Taytay, mañacullangagta yanapaycallämay!” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tsaymi Señor Jesucristo nirgan: “Manam allitsu wamracunapa tantanta gechusquir allgocunata garashwan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Warminam nirgan: “Aumi, Taytay, allitam ninqui. Pero allgocunapis ämuncunapa mësancunapita catupin shicwagcunataragmi micuyan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsaymi Señor Jesucristo nirgan: “Aumi ari, gamga rasumpam criyinqui. Mañacamangayquinö catsun.” Tsaymi jina öra warmipa wamran cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsaypita aywarmi Señor Jesucristo Galilea gocha cuchunpa päsarnin, jircaman witsarcur jamaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsaymanmi maytsicag runacuna goricar shamugcuna apayämurgan ratacunata, gapracunata, ricrantawan chancancunata mana cuyutsigcunata, mana parlagcunata, mas waquincag tucuyläya geshyagyashacunatapis. Tsaymi Señor Jesucristopa puntanman churaycuyaptinlla, llapanpis cuticäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tsaychö atsca runacuna caycag, alläpa cushicuywan chiyashga ricaräyargan, upacuna parlagta ricar, cuerpuncuna mana cuyogcuna sänuna caycagta ricar, ratacuna alli purigta ricar y gapracuna alli ricagta ricarnin. Tsaymi runacuna cushishga Israelpa Dios Yayanta alabayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Señor Jesucristo discïpuluncunata nirgan: “Caychö goricashga caycag runacunata llaquipämi. Quimsa junagnam nogantsicwan pagta caycäyan. Manam mallag cuticuyänanta munätsu. Si mallagllata ‘Wajiquicunaman cuticuyay’ niptïga, nänita aywaycarllach pishiparnin mallagaywan shongoncunapis ushacasquinman.” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Discïpuluncunam niyargan: “Atsca runacuna micuyänanpagga, ¿Cay tsunyachöga maychörag micuytapis tarishun?” ");
INSERT INTO qxnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tsaymi Señor Jesucristo tapurgan: “¿Ayca tantatan cayäpushunqui?” “Ganchis tantawan juc ishcay pescädollam” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Señor Jesucristom runacuna pampaman jamacuyänanpag mandargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Runacuna pampaman jamasquiyaptinnam, Señor Jesucristo ganchis tantatawan pescädota aptarcur, Dios Yayata “Pächi” nir, mañacurgan. Tsaypitam paquisquir discïpuluncunata macyargan, runacunata aypuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Llapan runacunam pachancuna juntanganyag micuyargan. Micur ushasquiyaptinnam discïpuluncuna sobragcunata ganchis canastapa pagtagtanörag goriyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Micugcunata yupayaptinmi chuscu waranga ollgo runacunalla cayargan, warmitawan wamracunata manam yupaycäyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Micur ushasquiyaptinnam runacunata “Cananga aywacuyna” nirgan. Tsaypitam Señor Jesucristo büquiman yaycusquir, Magadan marcapa aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Juc cutim fariseocunawan saduceocuna Señor Jesucristoman shayämurgan. Llutanta ruratsiyta munarmi tucuyläyata mañar niyargan: “Mä, cieluchö ima señal milagrullatapis ricäyänäpag ruramuy, Dios Yayapita shamushga cangayquita rasumpa musyayänäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tsaymi Señor Jesucristo nirgan: “Rupay jegangan öra pucutay garwayllugta ricar ‘Usyangam’ niyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tsaynöllam allegpa rupay jegamunan öra yana pucutayta ricar, ‘Cananga tamyamungam’ niyanqui. Tsaynö junagta ricarmi, musyayanqui tamyananpagwan usyänanpagpis. Pero Dios Yaya cieluchö ruranganta ricaycarpis, ¿imanirtan cay patsachö señalcunata imapag rurangantapis tantiyayanquitsu? ");
INSERT INTO qxnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cay llutan mana alli jutsata ruragcunaga milagrutaragmi mañayäman. Pero mananam mastaga rurashagtsu gamcuna ricäyänayquipag. Juc sëñalllam canga: Dios Yayapa unay profëtan Jonásta päsangannö. Tsaynöga canga rasumpa musyayänayquipagmi.” Señor Jesucristo tsaynö nisquirmi aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tsaypitanam Señor Jesucristopa discïpuluncuna gocha wac tsimpanman aywar, tantata gongasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tsaynö aywaycäyaptinnam Señor Jesucristo nirgan: “Fariseocunapawan saduceocunapa levadürancunapita alcäbu cuidacuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsaynö parlanganta mana tantiyarmi, discïpuluncuna quiquincunapura ninacuyargan: “Tantata gongascamushgam tsaynö nimantsic.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tsaynö ninacuyanganta Señor Jesucristo musyasquirmi nirgan: “Gamcunaga alläpa ichicllata criyiyämarmi jucmanpana entendiycäyanqui. ¿Imanirtan parlayanqui ‘Tantantsic mana capamashgam nimantsic?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manacu cananyag tantiyar yarpäyanqui pitsga tantallapita pitsga waranga runacunata micutsingäta? ¿Sobragcunatapis ayca canastatatan goriyargayqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tsaynölla ¿Manacu yarpäyanqui ganchis tantallapita chuscu waranga runacunata micutsingäta? ¿Sobragcunatapis ayca canastatatan goriyargayqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imanirtan gamcunaga pasaypa mana tantiyayanquitsu? Manam tantapagtsu nogaga parlaycä. Pero nogagam yapay niyag: ¡Fariseocunapawan saduceocunapa levadürancunapita cuidacuyänayquipag!” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tsaynö niptinragmi discïpuluncuna tantiyayargan, Señor Jesucristo “Tantata pogotsig levadürapita cuidacuyay” mana ninganta. Pero Señor Jesucristogam, “Fariseocunapawan saduceocunapa yachatsicuynincunapita cuidacuyay” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tsaypita Señor Jesucristo chargan “Cesarea de Filipo” shutiyog distritoman. Tsaychö discïpuluncunata tapurgan: “¿Pi niyämantan runacuna nogapag Diospita Shamushga Runa captï?” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsaynö niptinmi niyargan: “Waquincagga ‘Juan Bautistam’ niyäshunqui. Waquinga ‘Dios Yayapa unaycag profëtan Elíasmi’ niyan. Waquinnam ‘Dios Yayapa unaycag profëtan Jeremiasmi’ niyan. Tsaynöllam waquinga ‘Maygan carpis, Dios Yayapa unay juccag profëtanmi’ niyan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tsaymi Señor Jesucristo nirgan: “Pero ¿gamcunaga nogapag imaniyanquitan?” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tsaymi Simón Pedro nirgan: “Gamga Cristom canqui, Cawag Tayta Diospa Tsurin.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tsaynö niptinmi Señor Jesucristo nirgan: “Jonáspa tsurin Simón, gamga Dios Yayapa bendiciunninwan alläpa cushishga canqui. Manam runatsu gamtaga entenditsishushcanqui, sinöga cieluchö caycag Tayta Diosmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tsaymi rasumpa nig: Gamga Pedrom canqui. (‘Pedro’ ninanga rumi ninanmi cargan.) Cay rumi jananchömi iglesiäta shäratsishag, infiernupita illacätsicunanpag wañutsicug yargamurpis, manam cay iglesiätaga ni imaypis illacätsingatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dios Yayapa Mandacuy Reynonman yaycuna puncu llävitam entregashayqui mandacuyyog canayquipag. Cay patsachö wichgaptiquiga, cielupis wichgashgam canga. Cay patsachö quichaptiquiga, cieluchöpis quichashgam canga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tsaypitanam discïpuluncunata nirgan: “Amarag Cristo cangäta ni pitapis willacuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tsay junagpitam Señor Jesucristo discïpuluncunata willar nirgan: “Jerusalénmanmi aywashag. Tsaychömi iglesiachö autoridäcunawan mandacug sacerdöticuna y ley yachatsicugcuna alläpa sufritsiyämar wañutsiyämanga. Pero tsay wañutsiyämanganpita quimsa junagllatam cawamushag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tsaynö niptinmi Señor Jesucristota jucläman gayaycur, Pedro piñapar nirgan: “¡Señor, ama Dios munatsuntsu tsaynö canayquipag! ¡Ama tsaynöga päsaycushunquimantsu!” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tsaynö niptinnam Señor Jesucristo Pedroman tumaycur nirgan: “¡Nogapita witiy, Satanas! Gamga llutanta ruratsimaytam munaycanqui. Gamga runa munangannölla canätam munanqui, pero manam Dios Yaya munangantanöga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tsaypitanam llapan discïpuluncunata nirgan: “Gatimayta munagcagga quiquinpa yarpaynintawan munayninta dëjasquir, imayca cruzninta matancarcur gatimagnö sïgimätsun. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pipis quiquinpa poderllanwan vïdanta salvayta munagcagga wañungam. Pero mayganpis nogaraycu wañugcagga rasumpam salvacanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Imapagrag servinga juc runa llapan munduchö imaycayog caycarpis infiernuman aywaptinga? ¿Imawanrag cambianman vïdanta gloriaman yaycunanpag? ¿Acäsu pagtangatagcu vïdanta salvananpag llapan cay patsachö imaycacunapis? ");
INSERT INTO qxnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tsaymi noga Diospita Shamushga Runa car, angelnïcunawan Dios Yayanö llapan poderyog chipacyarrag shamushag. Chämurmi llapan runacunata segun imatapis rurangancunapita juc premiuta pägashag. ");
INSERT INTO qxnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rasuntam niyag: Waquin caychö caycagcuna manarag wañurga, ricäyämangam Diospa Tsurin car, mandacug reynö cay patsaman shamuycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tsaypita sogta junagtam Señor Jesucristo tsunya jircaman quimsa discïpuluncunallata pusharcur quiquillancuna cayänanpag aywayargan. Discïpuluncunam cayargan Pedrotawan Santiagota y Santiagopa waugen Juan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tsaymi puntancunachö Señor Jesucristo jucläya ticrargan. Gagllanpis imayca rupaynörag chipacyargan. Llatapanpis imayca yurag actsi atsicyagnörag cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tsaymanmi Dios Yayapa unaycag profëtancuna Moiséswan Elías yuriscayämurgan. Tsaychömi paycunata quimsan discïpuluncuna ricäyargan Señor Jesucristowan parlaycäyagta. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsaymi Señor Jesucristota Pedro nirgan: “¡Señor, caychö alläpa allishmi caycantsic! ¡Munaptiquiga, quimsa tsucllata rurascamushag, jucta gampag, juccagta Moiséspag y juctana Elíaspag!” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsaynö Pedro nicaptinnam illagllapita yurag pucutay imaläya atsicyarrag tsapasquirgan. Tsaymi pucutay rurinpita Dios Yaya parlamur nirgan: “Cayga cuyay Tsurïmi. Paymi alläpa cushitsiman. Yachatsiyäshungayquicunata wiyarnin gamcuna rurayay.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsayta wiyasquirmi quimsan discïpuluncuna alläpa mantsacar gagllancunapis patsaman changanyag shicwasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsaymi Señor Jesucristo puntancunaman witiycur maquinta janancunaman churarcur nirgan: “Shäriyay. Ama mantsacäyaytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Discïpuluncuna Señor Jesucristota ricaycuyänanpagga manam ni pipis canagnatsu, sinöga japallanllana caycagtam ricaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tsay jircapita uraycämurmi Señor Jesucristo quimsan discïpuluncunata yachatsir nirgan: “Cay jircachö ricäyangayquita ama ni pitapis willacuyanquitsu Noga Diospita Shamushga Runa wañungäpita manarag cawamuptïga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsaymi Señor Jesucristota discïpuluncuna tapuyargan: “Señor, ley yachatsicug maestrucunaga niyan: ‘Diospa Tsurin Cristo cay patsaman shamunanpagga Dios Yayapa unay profëtan Elíasmi mas puntanta shamunga.’ Tsaypunga ¿imanirtan tsaynöga niyan?” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Señor Jesucristonam nirgan: “Tsayga rasumpam. Elíasmi puntäta shamunga, llapantapis shumag allitsagnö rurananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tsaymi niyag: Elíasga shamushganam. Pero runacunaga manam regeyargantsu ni pï cangantapis. Paytaga mana allipa regermi, imayca llapan mana alli munayangancunata rurayargan. Tsaynöllam Diospita Shamushga Runa captï nogatapis sufritsiyämanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tsaymi discïpuluncuna Juan Bautistapag parlaycanganta tantiyasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tsaychö runacuna goricashga caycäyanganman Señor Jesucristo chaycuptinmi, juc runa puntanman gongorpacuycur, ");
INSERT INTO qxnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nirgan: “Señor, wamralläta llaquipar cuticaycatsillay. Supay paychö captinmi atäquiwan ñacatsir sufritsin y ishquirpis ushacätsin. Tsaynö achcungan öraga yacumanpis ninamanpis atsca cutim shicwan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cay discïpuluyquicunaman pushamuptïpis manam cuticätsiyta puediyantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tsaynö niptinmi Señor Jesucristo nirgan: “¡Lluta rurag mana criyicugcuna! ¿Imayyagrag gamcunawan caycäshag? ¿Imayyagrag gamcunata awantayäshayqui? Nogaman apamuy tsay wamrata.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tsaymi Señor Jesucristo, atäquita tsaritsig supayta ollgotuparnin wamrapita gargosquiptin, tsay ollgo wamra jina öra cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsaypitanam discïpuluncuna Señor Jesucristo japallan caycaptin tapuyargan: “¿Imanirtan nogacunaga wamrapita supayta gargoyta puediyashcätsu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Señor Jesucristonam nirgan: “Rasuntam niyag: Gamcunaga yangallam criyicuyanqui. Pero imayca mostäzapa muruntanö ichicllatapis criyicurga, tagay jircata tsaypita jucläman ‘¡Ayway!’ niyaptiquipis cäsuyäshunquimanmi. Dios Yayaman rasumpa firmi criyicuyaptiquiga, manam ni imapis ajatsu gamcunapag canman.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tsaypita llapan discïpuluncunawan Galilea provinciachö puriycäyarmi, Señor Jesucristo nirgan: “Diospita Shamushga Runa caynïwanmi traicionayämaptin chiquignïcunapa maquinman entregashga cashag. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tsaymi chiquimagnïcuna wañuscatsiyämaptin quimsa junagllata Dios Yaya cawatsimanga.” Tsayta wiyaycurmi discïpuluncuna alläpa llaquicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tsaypitanam Señor Jesucristo discïpuluncunawan Capernaum marcaman chäyargan. Tsaymanmi templupag ishcay jornalta impuestu cobragcuna Pedroman aywaycur niyargan: “¿Au, manacu maestruyquiga impuestuta templupag pägan?” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tsaynö niyaptinmi Pedro nirgan: “Aumi, päganmi.” Tsaypitanam Pedro wajiman yaycurgan. Pedro manarag imatapis niptinmi Señor Jesucristo tapurgan: “Simón, ¿Imaninquitan gamga? Cay patsachö mandacuyyog autoridäcunaga ¿pitatan impuestuta pägatsiyan? ¿Marcamajincunatacu o juclä runacunatacu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tsaynam Pedro nirgan: “Juclä runacunatam.” ");
INSERT INTO qxnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tsaymi Señor Jesucristo nirgan: “Tsaynö caycaptinga, marcamajincunaga manam pägayänan convienintsu, ¿Au? Tsaynö caycaptinpis cobracugcunata mana piñatsirlla cayta ruray: Gochaman aywaycur ansuelayquita jitanqui. Puntacag pescädota achcungayquipa shiminta quichanqui chuscu jornal väleg gellayta tarinayquipag. Tsay gellaywanmi ishcantsicpag impuestuta pägacunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tsaypitanam Señor Jesucristoman discïpuluncuna aywaycur tapurnin niyargan: “¿Maygätan Dios Yayapa Mandacuy Reynonchö mas mandacuyyog cayäshag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tsaynö niyaptinmi Señor Jesucristo juc wamrata gayasquir, puntancunaman ichiycatsir, ");
INSERT INTO qxnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nirgan: “Rasuntam niyag: Cay pishi wamranö gamcuna mana ticrarga, manam ni imaypis Dios Yayapa Mandacuy Reynonmanga yaycuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tsaymi pipis cay wamranö umilde gollmi shongoyog carga, cieluchö Dios Yayapa Mandacuy Reynonchöpis mas mandacuyyog canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tsaynöllam pipis cay wamratanö nogapa shutïchö chasquirga, nogatam chasquiyämanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Pipis cay ichic wamranö nogaman criyicaycäyämuptin, mana allita yachatsig runataga mas allim canman jatun molinu rumita cuncanman watarcur, lamar pullanman jitarpuyaptin tsaychö shingaypa wañunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Cay munduchöga alläpa mana allim imaycacunata convidacuypis, jutsaman shicwatsimänapagga! Tentarnin jutsata ruratsimänapagga siemprim imallapis canga. Pero allau, alläpa llaquiypagmi tsay jutsata ruratsicug runaga ñacarnin sufringa. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Maquiquiwan chaquiqui jutsata ruratsishuptiquiga, tsaycagläta rogosquir jucläman jitasquiy. Mas allim canga maquinnag chaquinnagllapis, Dios Yayapa gloriaman yaycuptiquiga. Mana sïga, ishcan maquiyogta ishcan chaquiyogtam Dios Yaya mana ni imay ushacag infiernuman garpushunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tsaynölla ñawiquipis jutsata ruratsishuptiquiga jipisquir jucläman jitasquiy. Mas allim canga ñawinnag gaprallapis Dios Yayapa glorianman yaycuptiqui. Mana sïga, sänu ishcan ñawiyogtam Dios Yaya infiernuman garpushunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Caynö pishi wamracunapag ama ‘Cayga manam imapagpis välentsu’ niyanquitsu ni jucllayllapagpis. Paycunata cuidag angelcunam cieluchö Dios Yayäpa puntanchö imaypis caycäyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nogam Dios Yayapita cay patsaman shamushcä, imayca ogracashga üshanö caycag runacunata salvanäpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Gamcuna imatatan caypag yarpäyanqui? Juc runapam pachac üshancuna cargan. Tsaypitanam juccag üshan ogracarnin raquicasquir jucläpa aywargan. Tsayga waquincag üshancunata jircachö dëjaycur, ¿manacu ogracashgacagtarag ashignin aywanman? ");
INSERT INTO qxnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tsaymi tarisquirga alläpa cushicurgan ogracashgacag üshanpag waquincag mana raquicag üshancunapitapis mas. ¿Manacu tsayga tsaynö? ");
INSERT INTO qxnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tsaynöllam cieluchö caycag Dios Yayayquicunapis ni juc ichic wamracunallapis ogracäyänanta munantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Criyicugmajiqui mana allita rurashuptiqui, quiquillayqui aywaycur jutsanta shumag tantiyatsiy. Tsaychö wiyashuptiqui paywan amistasquirmi, juc shongonölla ishcayquipis shumag cawacuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero si mana wiyashuptiquiga juc ishcay criyicugmajiquicunata pusharcur cutinqui, parlangayquita wiyayänanpag. Tsaynöpam ‘waquincagcunapis testïguyquicuna llapan ningayquicunata musyayanga, rasumpacagta ningayquita o llullatsingayquitapis.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Testïgucunapa puntanchö ningayquita mana wiyacuptinga, iglesiachö goricäyaptin llapan criyicugmajiquicunata willanqui. Si paycunatapis mana wiyaptinga, gamcunapagga pasaypa mana criyicug runanö impuestuta cobracug catsun. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Rasuntam niyag: Si gamcuna cay patsachö jutsancunata perdonayaptiquiga cieluchöpis perdonashgam cayanga. Tsaynöllam cay patsachö ‘jutsayogmi cay runa’ niyaptiquiga, cieluchöpis jutsayog canga. Gamcuna proibiyanganquinö o permitiyangayquinöllam cieluchöpis canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Yapaymi niyag: Cay patsachöga ishcayqui imatapis Dios Yayata mañacuyänayquipagpis shumag willanacuyaptiquiga, cieluchö caycag Dios Yayä mañacuyangayquitam gamcunapag ruranga. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsaymi maychöpis ishcag o quimsagllapis nogapa shutïchö goricäyaptinga, paycunapa pagtanmi nogapis caycä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsaynam Pedro Señor Jesucristoman witiycur tapurgan: “Señor, ¿Ayca cutitan runamajïta perdonashag imatapis mana allita ruramaptin? ¿Ganchis cutillatsurag perdonäman?” ");
INSERT INTO qxnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tsaynö niptinnam Señor Jesucristo nirgan: “Manam ganchis cutilla perdonay nigtsu, sinöga ganchis chunca ganchis cuti mana allita rurashuptiquipis perdonaylla. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Cananga Dios Yayapa Mandacuy Reynon imanö canganta cay ejempluwan yachacuyänayquitam munä. Juc reymi servignincunata gellay prestanganta cutitsiyänanta arreglayta munargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Cutitsiyänan junagchömi juc servigninta tsay reyman pushayämurgan. Tsaycag servigninga maytsica waranga alläpa atsca gellaytam dëbergan. Tsaymi tsay maytsica gellayta cutitsicuyta puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mana cutitsicuyta puediptinnam rey mandargan: ‘dëbemanganta pägamänanpag cay servignïta warminwan wamrancunapis esclävu cayänanpag ranticuyay llapan imaycantawanpis.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tsaymi servigninga reypa puntanman gongorpacuycur llaquishga rugarnin nirgan: ‘¡Taytay shuyaycallämayri, llapan dëbellangagtam pägalläshayqui!’ ");
INSERT INTO qxnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Reynam llaquipasquir llapan dëbenganta perdonar nirgan: ‘Cananga mananam dëbemanquinatsu’ nirmi servigninta aywacunanpag dëjargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tsaypitam servignin dëjasquiptin aywacur juc servicugmajinwan tincusquirgan. Tsay servicugmajinga ichicllatam dëbergan. Tsaytaga cuncapita achcusquir jurcayta munarnin gayapar nirgan: ‘¡Canan öra dëbemangayquita pägamay!’ ");
INSERT INTO qxnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Servicugmajinnam gongorpacuycur rugacurnin nirgan: ‘¡Shuyaycallämayri, llapantam pägallashayqui!’ ");
INSERT INTO qxnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero shuyayta mana munarmi, jina öra carcelman aywarnin gaycatsirgan. Tsaychömi dëbenganta päganganyag gaycurargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waquincag servicugmajincunapis tsayta ricarmi, alläpa llaquicuyargan. Tsaymi reyman aywaycur, llapan ruranganta willayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Reyga perdonangan servigninta gayaycatsir nirgan: ‘¡Gamga mana alli runam canqui! Nogaga rugacamaptiquim llapan dëbemangayquitapis perdonargag. ");
INSERT INTO qxnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gampis servicugmajiquita llaquipaycunquiman cargan, nogapis llaquipangagnölla.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tsaynö nirmi rey alläpa rabiar, servigninta carcelman gaycatsirgan. Tsaychömi llapan dëbenganta paganganyag sufrir gaycurargan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tsay ejempluta ushasquirmi Señor Jesucristo nirgan: “Runamajiquita llapan shongoyquiwan mana perdonayaptiquiga, tsaynöllam cieluchö caycag Taytä Dios Yayapis rurashunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tsaynö yachatsicuyta ushasquirmi, Galileapita Judea provincia Jordan mayu wac tsimpanman aywar chargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsaymanpis maytsicag runacunam gatirnin, Señor Jesucristo caycanganman goricäyaptin, geshyagyashacunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseocunanam tsayman shamuycur, Señor Jesucristota llutanta parlatsiyta munar tapuyargan: “¿Leynintsicchöga imallapitapis juc runa warminwan raquicänanpag convienincu o manacu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tsaymi Señor Jesucristo nirgan: “¿Manacu Diospa Palabran gellgashgachö ninganta liyiyashcanqui? ‘Gallarinanchömi Camacug Dios Yaya runata rurar, ollgotawan warmita camargan.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tsaynö camasquirmi Dios Yaya nirgan: ‘Ollgo runaga taytantawan mamanta dëjanga warminwan ishcan täcuyänanpag. Tsaynö juntawacasquirga ishcanpis jucllayllanam cayanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsaynö churacar juntawacasquirga mananam ishcagnatsu cayan, sinöga juc cuerpullanam ishcanpis cayanga. Tsaymi Dios Yaya juntangantaga ni pipis raquinmantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ley yachatsicugcunanam tapuyargan: “Tsaypunga tsay ningayquinö captinga ¿Imanirtan leynintsicchöga unay Moisés mandarnin gellgargan: ‘Mayganpis warminpita raquicarga, papelta ruraputsun “Warmïta dëjashcänam” nir, aywacunanpag’?” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tsaynam Señor Jesucristo nirgan: “Gamcuna chucru rumi shongo cayaptiquim, Moiséspis tsaynö leyninchö mandacur gellgargan. Pero Dios Yaya runata rurangan öraga, manam tsaynö cananpagtsu camargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tsaymi noga niyag: Pipis warminpita raquicag runaga alläpa jutsatam ruraycan. Pero tsay runapa warmin jucwan puriycuptinga raquicanmanmi. Maygan runapis warminpita raquicasquir jucwan casararga, alläpa mana alli jutsatam ruraycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tsaynö niptinmi discïpuluncuna niyargan: “Tsaynö caycaptinga mas allicu canman ollgowan warmi mana casarayaptin.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tsaymi Señor Jesucristo nirgan: “Llapan runacunapis manam tsaynö caytaga puediyantsu. Sinöga quiquin Dios Yaya yanapangan runacunallam tsaynö cawayta puediyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquincag runacunagam yuriyanganpitana japallancuna cawacuyänanpag cayan. Pero waquincagnam capashga car ni imaypis casaracuyantsu. Waquinnam ‘Dios Yayata mas allish servinäpag’ nir, casaracuyantsu. Tsaynö japallan cawayta puedigcagga tsaynö japallan cacutsun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsaypitanam Señor Jesucristoman wamracunata pushayämuptin, umancunaman maquinta churar bendisargan. Discïpuluncunaga wamracunata pushamugcunatam piñaparnin amatsayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tsaynö amatsayaptinmi Señor Jesucristo nirgan: “¡Ama amatsarnin michäyaytsu, wamracuna nogaman jina shayämutsun! Dios Yayapa Mandacuy Reynonga cay wamracunanö confiacurnin yätsicur shuyaragcunapagmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tsaynö nirmi Señor Jesucristo wamracunapa jananman maquinta churarcur, Dios Yayaman mañacusquir tsaypita aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juc runam Señor Jesucristoman chaycur tapurgan: “Alli Maestru, ¿Ima allitatan ruräman Dios Yayawan cieluchö imayyagpis cawanäpag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tsaynö niptinnam Señor Jesucristo nirgan: “¿Imanirtan ‘Alli’ nimanqui? Allicagga jucllayllam. Tsayga Dios Yayallam. Dios Yayawan cieluchö imayyagpis cawanayquipagga, Pay mandacungancunata cäsurnin llapanta cumpliy.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tsaynam runa tapurgan: “¿Maygancagcunatatan rurashag?” Señor Jesucristonam contestar nirgan: “Runamajiquita ama wañutsinquitsu. Warmiyog caycar ama jucnin jucninwan lluta puricunquitsu. Ama suwacunquitsu. Ama runamajiquita llullatsinquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Taytayquitawan mamayquita respetanqui. Runamajiquitapis quiquiquitanölla cuyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tsaynö niptinmi, tsay jöven runa nirgan: “Nogaga cay llapan mandacungancunatam cumplishcä. ¿Imallanatan faltäman ruranäpag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tsaymi Señor Jesucristo nirgan: “Dioswan rasumpa allish cawayta munarga, aywarnin cayta ruray: Llapan imaycayquicunatapis ranticusquir, tsaycunapa chanin gellayta wactsacunata aypunqui. Tsaynöpam sïga cieluchö imaycayquipis mas capushunqui. Tsaynö rurasquir, cutimunqui nogata gatirämänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Señor Jesucristo ninganta wiyaycurmi, tsay runa imaycayog rïcu runa car, alläpa llaquishga aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tsaypitanam discïpuluncunata Señor Jesucristo nirgan: “Rasuntam niyag: Dios Yayapa cieluchö Mandacuy Reynonman rïcucuna yaycunanpagga alläpa ajam. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tsaymi yapay niyag: Dios Yayapa Mandacuy Reynonman juc rïcu runa yaycunganpitaga, mas fäcilmi ‘camëllo’ niyangan jatun wäta juc aujapa uchcunpa päsanman.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsaynö niptinmi discïpuluncuna alläpa mantsacashga niyargan: “Tsaynö captinga, ¿Pirag salvacanga?” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Discïpuluncuna mantsacashga caycagta ricaycurnam, Señor Jesucristo nirgan: “Manam runacuna quiquillancunaga salvacuyta puediyantsu. Pero Dios Yayam sïga llapantapis salvayta puedin.” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tsaynam Pedro nirgan: “Señor, nogacunaga llapan imaycäcunatapis dëjasquirmi gatiräyag. ¿Tsayga nogacunapagga imarag canga?” ");
INSERT INTO qxnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Señor Jesucristonam nirgan: “Rasuntam niyag: Cay munduta Dios Yaya mushogman ticratsiptinmi, cieluchö cuyacuypag mandacugpa jamacunanchö Diospa Tsurin caynïwan jamaycäshag. Gamcunapis gatirämagnï cayangayquipitam chunca ishcay mandacugcunapa, jamayänancunachö jamayanqui. Tsay shumag atsicyag gloriachö jamaycarmi, juzgarnin chunca ishcay Israel naciun castacunapa mandagnincuna cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pipis wajinta, waugenta, paninta, taytanta, mamanta, wamrancunata y chacrancunatapis nogata servimänanraycu dëjarga, Dios Yayawanmi imayyagpis cieluchö cawanga. Tsaynö dëjanganpitapis, rasumpa gatirämanganpitam cay patsachö pachac cuti masta chasquinga. ");
INSERT INTO qxnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tsaymi canan gepachö caycagcuna puntachö cayanga y puntachö caycagcunanam gepachö cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Dios Yayapa Mandacuy Reynonga cay rïcu acendädu rurangannömi canga. Juc acendädum atsic atsicllana pläzapa aywargan, üvata murutsingan chacranchö aruyänanpag peoncuna ashig. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tsaymi peoncunawan parlargan juc jornalllata pägananpag. Tsaynö parlasquirnam, üvata murungan chacränchö aruyänanpag cachargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsaypitanam acendäduga yapay las nuevena pläzapa yargosquir, mana imatapis ruraycäyag runacunata ricargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tsaynam runacunata nirgan: ‘Gamcunapis chacräman aywar aruyay. Gänayänayquipagcagtam pägayashayqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsaymi tsay runacunapis chacranman arug aywayargan. Tsaypitanam pullan junagna yapay pläzapa yargosquir, mas peoncunata chacranman cachargan. Tsaynöllam las trespis mas peoncunata cachargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yapaymi rupay jegaycaptinna pläzapa yargosquir, mana imatapis rurar ichiraycäyagta tarirgan. Tsaynam tapurgan: ‘¿Imanirtan mana imallatapis rurar ichiraycäyanqui? ¿Goyatnacu caychö ichiräyanqui?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tsaymi niyargan: ‘Manam ni pipis aruypag ashiyämantsu.’ Acendädunam nirgan: ‘Tsaypunga gamcunapis chacräman arug aywayay.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Tsacaycaptinnam acendädu capatasninta mandargan, gepa chämugcunapita gallaycur llapan peonnincunata pägananpag. Tsaymi allegpita arugcunataga llapanpa gepantarag pägargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Acendädu ordenangannöllam, tsay capatasnin gepata yaycugcag peoncunata puntata gayasquir, juc jornal complëtota pägargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Allegllana yaycug peoncunam, ultimucag peoncuna juc jornalta pägayagta ricar cushicur niyargan: ‘Añañau nogantsicga paycunapita mastam chasquishun.’ Pero allegpita arugcunapis ultimucagcunawan iwalllatam chasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tsaynö iwalllata chasquisquirmi, rabiarnin acendädupa contran parlar, ");
INSERT INTO qxnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","niyargan: ‘Cay ultimu yaycamugcunaga juc örallanam aruyashga. Pero paycunataga ¿imanirtan nogacunatawan iwalllata pägatsinqui? Nogacunaga achaychö pishipashga goyatmi, rupay yargamunganpita asta jeganganyag alli aruyashcä.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tsaymi acendädu nirgan: ‘Amïgo, gampa contrayqui manam ni imatapis rurashcätsu. ¿Manacu gamcunawanga juc jornalllata pägayänagpag shumag arreglar parlashcantsic? Tsaymi nogaga parlangantsicnöllata pägatsiyashcag. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gamcunaga pägayangagta aparcur aywacuyay. Gepata yaycamugcunatapis gamcunatawan iwalllatam pägayta munä. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Gamcunataga imatan gocuyäshunqui, quiquïpa gellaynïtaga imanö gastaptïpis. ¿Noga alli generöso cangäpitacu chiquicur rabiapäyämanqui?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tsaynömi rasumpa canga puntachöcagcunam gepachö cayanga y gepachöcagcunam puntachö cayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tsaypita Señor Jesucristo Jerusalénman aywaycanganchömi, chunca ishcay discïpuluncunata jucläman gayaycur, paycunallata willar nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Musyayangayquinömi Jerusalénman aywashun. Tsaychömi Diospita Shamushga Runa captï, chiquimagnïcuna traicionar mas puedig sacerdöticunamanwan ley yachatsicugcunaman entregayämanga, condenar wañutsiyämänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Paycunam mana judiucag autoridäcunaman entregayämanga, burlacur, asiparnin, astar cruzchö wañutsiyämänanpag. Pero wañutsiyämanganpita quimsa junagllatam cawamushag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsaypitanam Zebedeopa warmin wawan Santiagotawan Juanta pusharcur Señor Jesucristoman shamurgan. Tsaymi Señor Jesucristopa puntanman gongorpacuycur nirgan: “Jucta rugacushayqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tsaynam Señor Jesucristo tapurgan: “¿Imatatan munanqui?” Tsaymi warmi nirgan: “Gam mandaycuy, Mandacuy Reynoyquichö ishcan wamräcuna juccag derëchucag läduyquichö juccagna itsogcag läduyquichö autoridänö mandacur jamayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tsaymi Señor Jesucristo paycunata nirgan: “Manam ni imata mañayämangayquitapis musyayanquitsu. ¿Gamcunaga awantayanquimantsurag nogata alläpa sufritsiyämar ayag trägutanö upyatsiyämänanpagcagta?” “Aumi, awantayäshagmi” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tsaymi Señor Jesucristo nirgan: “Rasumpam gamcunapis noganö upyayanquiman. Pero tsaynö cayaptiquipis, manam nogapitatsu tsaycunaga canga, ‘Derëchucag lädüchö ni itsogcag lädüchö jamamunqui’ ninäpagpis. Tsaytaga quiquin Taytä Dios Yayallam pï lädüchö jamananpagpis despöninga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tsaynö mañayanganta wiyaycurmi, tsay chunca discïpuluncuna ishcaycag waugecunapag piñacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tsaymi llapanta gayasquir Señor Jesucristo nirgan: “Gamcunaga musyayanquim juclä naciuncunachö reycuna imanö mandacuyangantapis. Maygan autoridäcarpis mantsacätsiypam mandacun, mandangancuna mantsacuyänanpag. Tsaynöllam mas mandagcagcunapis mas mantsacätsiyan mandädunchöcagcunata. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero gamcunachöga ama tsaynöga catsuntsu. Mas mandacuyyog cayta munagcagga, waquincagcunapa mas servigninmi canman. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mayganpis mandacug autoridä cayta munarga, waquincagcunapa servignin esclävunmi canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tsaynöllam noga Diospita Shamushga Runa caycarpis, runacunata servinäpag shamushcä. Manam waquincag runacuna servimänanpagtsu shamushcä, sinöga waquincagta servinäpagmi. Tsaymi wañutsiyämaptin vïdäta entregacurpis, maytsicag runacunata salvanäpag shamushcä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jerico niyangan marcapitam Señor Jesucristo discïpuluncunawan aywacuptin, maytsicag runacuna gatiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tsay aywaycangan näni cuchunchömi ishcay gapracuna jamaycäyargan. Señor Jesucristo päsaycanganta wiyar tantiyasquirmi, gayaraypanö rugacurnin niyargan: “¡Señor, rey Davidpa ayllun llaquipaycäyällämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tsaynö niyaptinmi gatirnin aywagcuna ollgotupar niyargan: “¡Upälla cayay!” Niyaptinpis yapay yapay mas gayaycacharragmi rugacur: “¡Señor, rey Davidpa ayllun llaquipaycäyällämayri, nirgan!” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tsayta wiyaycurmi Señor Jesucristo ichisquir, gapracunata gayasquir tapurgan: “Gamcunapag ¿Imata ruranätatan munayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Gapracunam niyargan: “Señor, ñawïcuna ricänanpag cuticaycatsillämunayquitam munayällä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tsaymi Señor Jesucristo llaquiparnincuna ñawincunata yataycurgan. Tsaynö yataycuptinmi, jina öra ishcanpa ñawincuna cuticasquirgan. Ñawincuna quichacasquiptinmi Señor Jesucristota gatircur aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tsaypitanam Señor Jesucristo discïpuluncunawan Jerusalénman aywarnin sïgiyargan. Jerusalén cercantana aywaycarmi Olïvos niyangan jircapa aywar Betfage marcaman chaycarna, ishcay discïpuluncunata mandar, ");
INSERT INTO qxnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nirgan: “Aywayay tagay wac tsimpa Betfage marcaman. Tsayman chaycurmi, wawanwan juc ashnu wataraycagta tariyanqui. Tsayta pascasquir ishcanta apayämunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si pipis imatapis niyäshuptiquiga niyanqui: ‘Señornintsicmi wanan; sasllam ishcanta cutiscatsimunga’ nir.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tsaynö ruraptinmi Dios Yayapa unay profëtan gellgangan cumplirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión marcachö täcugcunata willayay: ‘Ricäyay, llaquipäcug umilde reyniquicunam chagnacuna ashnupa wawan mallwa ashnun montashga shamuycan.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tsaymi discïpuluncuna aywar Señor Jesucristo ningannölla rurayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ashnuta mamantinta apascamur punchuncunata carunarcuyaptinmi Señor Jesucristo montargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tsaymi Señor Jesucristo päsangan näniman maytsicag runacuna punchuncunata llushtisquir mashtayaptin, waquincagcunapis jachacunapa rapranta wallusquirnin mashtayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tsaypa Señor Jesucristo aywaycaptinmi atscag runacuna puntantawan gepanta gayaycacharrag aywarnin alabar niyargan: “¡Vïva! ¡Dios Yayapa shutinchö unay rey Davidpa ayllun Shamug reynintsic! ¡Canan salvaycayämay! ¡Alli cushicuywan cieluchöcagcunapis niyätsun: ‘Gloria’ Dios reyta cachamungayquipita salvaycayämay!” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalénman chaycuptinnam tsaychö llapan täcug runacuna timpullyarrag jucnin jucninwan tapunacur niyargan: “¿Pitan cay runa?” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tsaymi atscag runacuna niyargan: “Cayga profëta Jesúsmi, Galileapita shamug Nazaret runa.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tsaypitanam Señor Jesucristo mas respetashgacag templu niyangan jatun iglesiaman yaycurgan. Tsay templuman yaycusquirnam negociu ranticugcunatawan rantipacugcunatapis gargornin, gellay cambiapacugcunapa mësancunatapis wicapatacurgan. Palomacunata ranticugcunapa jamacuyänancunatapis wicapatacusquirmi, ");
INSERT INTO qxnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","nirgan: “Diospa Palabran gellgashga libruchömi nirgan: ‘Wajïga mañacur adorayämänan wajillam.’ ¡Pero gamcunaga ‘suwacunapa machaynincunamanmi’ ticratsiyashcanqui!” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsay templuchö Señor Jesucristo caycanganman, gapracunatawan ratacunata apayämuptinmi llapanta cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Templuchö wamracunapis gayaycacharmi niyargan: “¡Alli cushicuy catsun, rey Davidpa ayllun! ¡Reynintsic cachamug Dios Yaya cananga salvaycayämay!” Wamracuna tsaynö gayaycachäyanganta wiyarnin milagrucunata ruragta ricarmi, mas mandagcag sacerdöticunawan ley yachatsicugcuna alläpa piñacur rabiayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tsaynö rabiarmi piñacur Señor Jesucristota niyargan: “¿Manacu wiyanqui cay wamracuna nicäyanganta?” Tsaymi Señor Jesucristo nirgan: “Aumi, wiyaycämi. ¿Gamcunaga manacu liyiyashcanqui Diospa Palabran gellgashga libruchö caynö ninganta: ‘Pishi wamracunapawan llullu chuchuycag wamracunapa shimicunamanmi, “Dios Yayaga alläpa allim” nir, alabayäshunaquipag churashcanqui’?” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tsaynö nisquirmi mandacugcunata templuchö dëjasquir, Señor Jesucristo Betania marcaman cuticur tsaychö posadacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Waränin alleg Jerusalénman Señor Jesucristo cutiycarmi mallagargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tsay nänipa päsaycarmi, näni cuchunchö ïgospa yuranta ricargan. Tsaymi wayuyninta pallag aywargan. Pero manam ni jucllayllapis wayuyninga canagtsu atsca rapran captinpis. Tsaynöta ricaycurmi Señor Jesucristo ïgosta nirgan: “¡Cananpitaga mananam ni imaypis wayunquinatsu!” Tsaymi jina öra tsay ïgos jancat tsaquisquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tsayta ricaycurmi discïpuluncuna mantsacar Señor Jesucristota tapuyargan: “¿Imanötan cay ïgospa yuran patsa tsaquisquin?” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Señor Jesucristonam nirgan: “Rasuntam niyag: ‘Dios Yayaga mañacungätam ruranga.’ Si gamcuna Dios Yayaman llapan shongoyquicunawan criyicurga, ama yarpachacuyanquitsu ‘¿Mañacungäta rurangatsurag?’ nirga. Mas bien, rasumpa firmi criyicurga cay ïgosta tsaquitsingäpitapis mastam rurayanqui. Tsaynöllam tagay jircata ‘Caypita lamarman juchusquiy’ niyaptiquipis, rasumpa firmi criyicuyaptiquiga tsaynö canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tsaymi rasumpa firmi criyicuptiquiga, imata mañacungayquitapis Dios Yaya garashunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tsaypitanam Señor Jesucristo templuchö yachatsicurgan. Tsaychö yachatsicuycaptinmi mas mandacugcag sacerdöticunawan israelcunapa autoridänincuna, witiycur niyargan: “¿Ima mandacug cayniquiwantan tsaycunata ruraycanqui? ¿Tsaynö ruranayquipag pitan cachamushushcanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Señor Jesucristonam nirgan: “Gamcunatapis jucta tapuyäshayqui. Nogatapis contestayämaptiquiga, nogapis pï cachamanganta willayäshayquim. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juan Bautistata ¿Pitan runacunata bautizananpag cachamurgan? ¿Dioscu o runacunacu?” Tsaynö niptinnam quiquincunapura yachatsinacur niyargan: “ ‘Diosmi cachamushga’ nishagam nimäshun: ‘¿Tsaypunga imanirtan mana payman criyiyargayquitsu?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y ‘runacunam cachamushga’ nishagam, caychö atscag goricashga caycag runacuna contrantsic piñacuyanga. Paycunagam Juan Bautista Diospa profëtan canganta firmi criyiyan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tsaymi Señor Jesucristota niyargan: “Manam musyayätsu.” Tsaynö niyaptinnam Señor Jesucristo nirgan: “Nogapis manam willayagtsu ni pipa mandacuyninwan caycunata rurangäta ni pï cachamangantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tsaypitanam Señor Jesucristo tapurgan: “¿Imaniyanquitan gamcuna caypag? Juc runam ishcay tsuriyog cargan. Juccag tsurintam nirgan: ‘Ïju, canan chacrantsicman aywanqui tsaychö arunayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tsaynö niptinmi tsuringa ‘¡Manam aywätsu!’ nirgan. Pero mas rätunta arepenticurnin yarpachacusquirmi arug aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tsaynöllam juccag tsurinman aywaycur nirgan: ‘Ïju, gam canan chacrantsicpa arug aywanqui.’ Tsaynö niptinnam tsuringa nirgan: ‘Aumi, Taytay. Jina örallanam aywashag.’ Tsaynö nisquirpis geläcurmi aywargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gamcunata canan tapuyäshayqui: ¿Maygantan taytan mandanganta rurar cäsushga?” Mandacug runacunanam niyargan: “Puntacagmi.” Tsaynam Señor Jesucristo nirgan: “Rasuntam niyag: Gamcunapita mas puntayquicunatam impuestuta cobrag mana alli runacunawan lluta ollgocunawan puricug warmicunapis Dios Yayapa Mandacuy Reynonman yaycuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautista puntata shamurmi, imanö allicunallata rurarnin cawayänayquipag yachatsiyäshurgayqui. Impuestu cobragcunawan lluta puricug warmicunapis yachatsicunganta cäsurmi criyicuyargan. Pero gamcunaga tsayta ricaycarpis, mana cäsurmi willacungantapis criyiyargayquitsu ni jutsayquicunapita arepenticuyargayquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Wiyayay cay juc ejemplu willayangagta. Juc acendädum chacranchö üvata murutsirgan. Tsaynö muruscatsir chacranta tumat cercotsirmi, rumita uchcutsirgan vïnopag üvapa yacunta gapiyänanpag. Tsaypitanam tsacrancamannö altuman tsucllata churarcur chacranta täpatsirgan. Tsaypitam caru marcapa aywacur, juc arugcunata arendacurgan pullanpura raquipunacur cosëchayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Tsaypita cosëcha tiempu chäramuptinmi, chacra arendacug servignincunata cachargan töcangancag cosëchata tsay chacra tsarag runacunapita goriyämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chacra tsaragcunaman mandangan servignincuna chaycuyaptinmi, achcusquir alli magarnin gargoyargan y waquincagtanam sagmarnin juccagtaga wañuscatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tsaypitanam acendäduga waquincag servignincunata yapay cachargan puntata mandanganpitapis mas atscagta. Tsay servicugcunatapis chacra tsaragcunaga puntacagcunata rurayangannöllam llapantapis rurayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Tsaynölla rurayaptillanmi quiquinpa tsurintana cacharnin nirgan: ‘Tsurïtaga respetayangam’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Acendädupa tsurin shamuycagta ricasquirmi chacra tsaragcuna willanacur niyargan: ‘Taytan wañuptinga cay tsurinmi imaycanwanpis quëdanga. Caytaga chacranwan quëdananpag wañuscatsishun.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsaynö nirmi acendädupa tsurinta achcusquir, üvata murutsingan chacranpita jucläman gargosquir wañuscatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Tsaymi canan gamcuna mä niyämay: Acendädu shamuycur, ¿Imatatan ruranga tsay chacra tsaragcunata?” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Judiucunapa mandacug autoridäcunanam niyargan: “Alläpa mantsacaypa mana llaquipaypam tsay pengacuypag mana alli runacunata wañutsirnin ushacätsinga. Tsaypitanam chacranta arendacunga alli runacunata, paycunawan töcangan cosëchachö wayuyninta shumag raquipunacuyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tsaypitanam Señor Jesucristo nirgan: “¿Manacu ni imayllapis Diospa Palabran gellgashgata liyishcanqui? Tsaychömi nin: ‘Wajipag cemientu churag albañilcuna despreciayangan rumim, mas allicag maestru rumiman ticrashga. Tsaytanö Dios Yaya ruranganpitam, alläpa cushishga caycantsic.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tsaymi rasunta niyag: Gamcuna mana chasquiyämangayquipitam Dios Yayapa Mandacuy Reynonman ni imaypis yaycuyanquitsu. Mas bienmi, waquincag allillata rurag runacuna nogaman firmi criyicurnin cäsucur chasquiyämanganpita, Dios Yayapa Mandacuy Reynonman rasumpa yaycuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Cay rumi jananman pipis shicwarga, jancatmi ichic ichic paquir ushacasquinga. Tsaynöllam pipa janamanpis tsay rumi shicwarga, jancat polvutanö rurasquinga. Tsay rumiga nogam cä. Tsaymi pipis mana chasquimaptinga, Dios Yaya infiernuchö castigarnin ushacätsinga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsaynö Señor Jesucristo yachatsicunganta wiyarmi, mas mandagcag sacerdöticunawan ley yachatsicugcuna contrancuna parlaycanganta tantiyayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pero tsaychö goricashga atscag runacunam mantsacashga niyargan: “Señor Jesucristoga Dios Yayapa rasumpa profëtanmi.” Tsaymi tsay runacunapita mantsacurnin, Señor Jesucristota prësu gaycatsiyänanpag apayta munaycarpis achcuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Señor Jesucristom mas ejempluwan yapay yachatsicur nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Dios Yayapa Mandacuy Reynonga, juc rey ollgo tsurin casaracunanpag prevenicungannömi canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Juc reymi convidangan runacunata fiestaman pushayämunanpag servignincunata cachargan. Pero tsay convidangan runacunaga fiestanman manam shamuyta munayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tsaypitanam yapay waquincag servignincunata cachargan niyänanpag: ‘Micuytapis alistayashcänam. Weracag mallwa törrucunatawan ternëracunatapis pishtarnin, llapantanam cocinar listotsayashcä. Sasllana aywacayällämuy fiestata rurangäman.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero convidangan runacunaga manam ni ichicllatapis cäsuyargantsu. Juccagmi chacranpa arucug aywargan. Juccagnam negociun ruranganman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquincagnam reypa servignincunata achcusquir, wañutsiyänganyag magayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tsaymi rey alläpa rabiarnin atscag soldäduncunata mandargan, tsay wañutsicug runacunata wañutsirnin marcancunatapis cayayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsaypitanam reyga servignincunata nirgan: ‘Tsurï casarananpag llapanpis listuna caycaptin, convidangä runacunaga shamuyta mana munarmi, fiestäman shamuytapis merëciantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tsaynö caycaptinga cällicunachöwan pläzacunachö llapan runacuna ricäyangayquita lluta convidarnin cay fiestäman pushayämuy.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tsaymi servignincuna cällicunapawan pläzacunapa aywar, llapan ricäyangan alli o mana alli runacunatapis convidar pushayämurgan. Tsaynö llapan tariyangan convidashga runacunata goriscayämuptinmi, palacionchö juc jatun cuarton junta cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tsay jatun cuartoman juntasquiyaptinmi, rey convidangan runacunata ricag yaycuycar, juc runata ricaycurgan mana tsay fiestapagnö jucläya llatapashgata. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsaymi rey tapurgan: ‘Amïgo, ¿imanötan cayman yaycamuruyqui, fiestachö shucucuna llatapayquita mana shucucamurga?’ Pero tsay runaga upallallam cacurgan imatapis mana contestayta puedir. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsaynam rey micuy servicug wätaynincunata mandargan: ‘Cay runapa chaquintawan maquinta watarcur, wagta tutapayman jitasquiyay, tsaychö wagarnin quirunpis regochyaptinrag sufrinanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsaynöllam llapan runacunapis convidashga cayanga, pero wallcagllam acrashga yaycuyänanpagga cayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsaypitanam fariseocuna goricasquir willanacur niyargan: “¿Señor Jesucristota pantatsinapag imanötan tapushun? Imallatapis parlasquiptinga tsayllawanmi acusashun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tsaymi fariseocuna gatiragnincunatawam rey Herodespa runancunata cachayargan, Señor Jesucristota niyänanpag: “Maestru, musyayämi rasumpacagllata imaypis parlangayquita. Gamga Dios Yaya munangannö rasumpa yachatsicurmi, mas mandacuyog cayaptinpis manam runacunapita mantsacunquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Canan niyämay: ¿Roma naciunpa reynin Cesarpag impuestuta pägashwancu o manacu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Señor Jesucristoga tsaynö yachayllapa tapuyanganta musyarmi nirgan: “Gamcunaga allitucurmi yachayllapa tapuycäyämanqui. ¿Imanirtan mana alliman garpayämayta munayanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä tsay impuestupag pägana gellayta ricänäpag apayämuy.” Tsaymi “denario” niyangan juc gellayta apayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tsay gellayta ricaycurmi Señor Jesucristo tapurgan: “Cay gellaychö ¿Pipa shutintanwan reträtuntan caycan?” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Romapa reynin Cesarpam” niyargan. Señor Jesucristonam nirgan: “Tsaypunga Cesarpacagtaga Cesarta entregayay. Pero Diospacagtaga Diosta entregayay.” Nogantsicga Dios Yaya camamangantsicpitam paypa reträtun cantsic. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Señor Jesucristo tsaynö ninganta wiyaycurmi, tsay runacuna mantsacashga cayanganpita tsaychö dëjasquir aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tsay junagllam “saduceo” niyangan runacuna Señor Jesucristota tapugnin shayämurgan. Tsay saduceocunaga manam criyiyargantsu wañushgacuna cawayämunanta. Tsaymi Señor Jesucristoman chaycur niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maestru, Moisés gellgangan leyga caynömi yachatsicun: ‘Pipapis waugen manarag tsurin captin wañuptinga viudanwan gepancag waugen casarananpag. Tsaynö viudanwan casaraptin wañugcag waugenpa tsurin cuenta wamrancuna cananpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Unaymi caychö ganchis waugecuna cayargan. Mayorcag casaracusquirmi manarag tsurin captin wañurgan. Tsay viudanwannam gepancag waugenpis casarasquirlla wañurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tsaynömi tsay ganchis llapan waugentinpis mayorpita gallaycur asta ultimucagyag manarag tsurincuna captin wañuyargan, tsay warmillawan casarasquir. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsaynö llapan wañusquiyaptinmi warmipis wañusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mä canan niyämay. Tsay warmiwan ganchis waugecuna casarashga caycäyaptinga, llapan cawayämungan junagchöga ¿maygancagpatan warmin canga?” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tsaymi Señor Jesucristo nirgan: “Gamcunaga Diospa Palabran gellgashgatawan poderninta mana musyarmi llutanta parlar pantayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wañuyanganpita cawascamurga warmipis ollgopis manana casararmi, cieluchö angelcunanöllana cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Manacu gamcuna liyiyashcanqui, wañushgacuna cawayämunanpag Dios Yaya Palabranchö gellgatsir niyäshungayquita? ");
INSERT INTO qxnNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nogaga unaycag Abrahampawan Isaacpa y Jacobpa respetayänan Diosnincunam cä.” Tsaynö ninganpitam Abrahamwan Isaac y Jacob cawaycäyanganta musyantsic. Tsaymi Dios Yayaga manam wañushgacunapa Diosnintsu sinöga cawagcagcunapa Diosninmi. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tsaycunata wiyarmi tsay templuchö atscag goricashga runacunapis mantsacashga cayargan, Señor Jesucristo llapan imayca allicunata yachatsicuptin. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Señor Jesucristo saduceocunata tsaynö upallatsinganta musyasquirmi, fariseocuna goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tsaychömi Señor Jesucristota tapucuyta munarnin, juc ley yachag doctor nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maestru, ¿Dios Yayapa llapan mandacuyninpita maygancagtan llapanpitapis mas allicag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Señor Jesucristonam nirgan: “Dios Yayata cuyanqui llapan shongoyquiwan voluntäniquiwan, llapan yarpayniquiwanpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tsay puntacag mandacuymi llapanpitapis mas allicagga. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Juccagpis tsaynö cäsi iwalllam: ‘Runamajiquitapis quiquiquitanölla rasumpa cuyanqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tsaymi cay ishcan mandamientucunallapita unay profëtacunapa yachatsicuyninwan llapan mandacuy leycunapis.” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsaypitanam fariseocuna goricashgallarag caycäyaptin, Señor Jesucristo paycunata tapurgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“¿Dios Yaya cachamungan Cristopag imatatan yarpäyanqui? ¿Pipa ayllunrag Payga?” Tsaymi “Unay rey Davidpa ayllunmi” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Señor Jesucristonam nirgan: “Unay rey Davidpa ayllun Cristo caycaptinga, ¿Tsaypunga imanirtan Davidga Espïritu Santopa poderninwan Cristopag parlargan ‘Señornïmi’ nir? Tsaynöpam Davidga nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Señormi Señornïta nirgan: “Cay derëchucag lädüchö jamacamuy llapan chiquishugniquicunata chaquiquipa gopinman churamungäyag.” ’ ");
INSERT INTO qxnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tsaynö David ‘Señornïmi’ nicaycaptinga, ¿Imanöpatan Davidpa miragnin ayllunpa tsurin Cristo canga?” ");
INSERT INTO qxnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tsaynö Señor Jesucristo tapuptinmi ni pipis contestayta puedirgantsu. Tsay junagpitaga llapanpis mantsaparmi Señor Jesucristota manana ni imatapis tapupäyargannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tsaychö goricashga runacunatawan discïpuluncunata yachatsirmi Señor Jesucristo nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ley yachatsicugcunawan fariseocunaga unay Moiséspa rantinnö leyta yachatsicuyänanpagmi cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tsaymi llapan mandayäshungayquita rurarnin cäsurpis, paycunapa ejempluncunatanöga ama rurayanquitsu. Paycunagam jucläya allicunallata yachatsicusquirpis, quiquincunaga jucläya mana allicunata ruraycäyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Imayca lasag gepita aparitsignömi mana pallariytapis puedinganyag alläpa atsca costumbrincunata yachatsicuyan. Pero quiquincunaga manam pallarirllapis yanapayantsu ni juc dëdullancunawanpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tsaynömi paycunaga llapan imayca allicunatapis rurayan runacuna ricäyänanllapag. Urcuncunamanwan ricrancunamanpis tacsha cajïtacunata watarcurmi, Dios Yaya gellgatsingan leycunata puritsiyan. Tsaynöllam alläpa gustayan Dios Yayaman mañacuyänanpag anchu tëlawan umancunata tsaparcur puriyta. Tsaynömi chaquicuna puntanyag shumag shallshayog anchu revëtishga llatapancunawan puriyan, ricagnincuna ‘Payga, Dios Yayata respetag rasumpa alli runam’ niyänanllapag. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Micupacuy fiestacunachöpis mas mandacugcuna jamacuyänan allincag sillïtacunallachömi jamayta munayan. Israel runacunalla goricäyänan wajichöpis weragotsacunapa jamacuyänancunallachömi jamayan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mercädochöwan cällicunachö rantipacur purirpis runacuna aläbar saludayänantam munayan. Tsaymi ‘yachatsicug tayta doctor’ niyaptinga alläpa cushicuyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pero gamcunaga ama munayanquitsu runacuna ‘Maestru’, niyäshunayquita. Gamcunaga llapayquipis juc waugellam cayanqui y jucllayllam maestruyquicunapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gamcunaga ama ni pitapis cay patsachö ‘Taytantsic’ niyanquitsu. Gamcunapaga jucllayllam cieluchö Tayta Diosniquicuna caycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ama ni pipis ‘Maestru’, niyäshunquitsu. Llapayquipa maestruyquicunaga Noga, japallä yachatsicug Cristom cä. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gamcunachö mas mandacugcagga, waquiquicunatam serviyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tsaymi maygayquipis mas mandacuyyog cayta munayaptiquiga, Dios Yaya wätayninman churayäshunqui. Pero maygayquipis umilde gollmi shongo, waquincagcunapa servignin carga, mas alli mandacugmi cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Allau janan shongo ley yachatsicugcunawan fariseocuna! Tsaynö janan shongo carmi Dios Yayapa cieluchö Mandacuy Reynonman waquincagcuna yaycuyta munayaptinpis, imayca puncuta wichgagnö mana allicunata yachatsicur amatsacuyanqui. Yaycuyta munagcunata amatsarnin mana quichapugnö cayangayquipitam, quiquiquicunapis ni imaypis yaycuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Allau ley yachatsicugcunawan fariseocuna, allitucurnin goyat goyat resacurmi viudacunapa wajincuna gechuyangayquita. Tsaynö rurayangayquipitam Dios Yaya condenar mantsacaypa castigayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Allau janan shongo ley yachatsicugcunawan fariseocuna! Lamarpa päsarnin maytsay carupapis gamcuna criyicuyangayquillata yachatsiyänayquipagmi jucllayllatapis ashirnin puriyanqui. Tsay yachatsiyangayqui runagam, gamcunapitapis mas peor jutsasapa ticran. Tsay llapanta yachatsiyangayquipitam paycunaga Supaypa wamranna car, gamcunapitapis mas infiernuchö sufrir ñacayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Allau gamcuna runacunata llutanpa pusharnin imayca gapranö yachatsicugcuna! Gamcunam yachatsicur niyanqui: Pipis ‘juracümi templupa shutinchö’ niptinga mana cumplinanpag jurangannöllam canga. Pero pipis ‘juracü templuchö caycag goripa shutinchö’ nirmi sïga rasumpa änicunganta cumplinanpag juraycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana musyag gapracuna! Imatan mas importanti: ¿Templu rurinchö goricu o Dios Yayapa templuncu? Tsay goriga mas välen Dios Yayapa templunchö canganpitam. Tsaymi tsay templuga mas välen rurinchö goripitapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gamcunaga caynöpis yachatsicuyanquim: ‘Juracümi altarpa shutinchö’ niptinga, tsay juranganpis mana cumplinanpag jurangannöllam canga. Pero pipis ‘juracümi cumplinäpag altarchö churaraycagpa shutinchö’ nirmi sïga, rasumpa cumplinanpag änicun. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Gapracuna! Imatan gamcunapag mas importanti: ¿Altarcu o tsaychö churarag ofrendacu? Tsay altarchö churaranganpitam, tsay ofrendapis välen. Tsaymi Dios Yayapa tsay altarnin mas välen jananchö ofrenda churaranganpitapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Altarpa shutinchö juracurga manam altarllapagtsu jurayanqui. Sinöga tsay jananchö llapan churaragcunapagwanmi juraycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tsaynöllam templupa shutinchö jurarpis, templuchö llapan churaragcunapagwan quiquin Dios Yayapag juraycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Si pipis cielupa shutinchö jurarga, Dios Yayapa cieluchö jamacunan trönonpagwan quiquin Dios Yayapagmi juraycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Allau janan shongo ley yachatsicugcunawan fariseocuna! Gamcunaga ‘Dios Yayapag’ nirmi yerbabuenapawan mentapa y comïnospa cada chunca rapranpita juc chunca partillata raquiyanqui. Pero manam cäsuyanquitsu Dios Yayapa mas allicag mandacungancunataga. Gamcunaga runamajiquicunata mana llaquiparmi Dios Yaya mandacungancunata mana cäsurnin cuyayanquitsu. Mas bienmi paycunapa contran mana allicunallata rurar ni parlayangayquitapis cumpliyanquitsu. ‘Diospag’ nir, ofrenda garayniquita entregar, mas allicag mandamientuncunata cumpliyay imaypis mana dëjar. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Gapranö mana alli pushacugcuna! Gamcunaga yacutapis shuyshurragmi chuspita jepiyanqui. Pero imayca jatun ‘camëllo’ wäta tamañutaga millpusquiyanquim, Dios Yayapa mas allicag mandamientuncunata mana cumplirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Allau janan shongo ley yachatsicugcunawan fariseocuna! Gamcunaga üsayangayqui järucunatawan plätucunatapis janallantam mayllayanqui. Pero rurinpaga ayrajarnin munapar gechucuyangayquiwan suwacuyangayquim junta caycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Imayca gapranömi fariseocunawan ley yachatsicugcuna cayanqui! Puntataga järucunapa rurinta mayllayangayquinö shongoyquicunachö jutsatarag dëjayay, jananpa rurinpapis limpiu quëdayänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Allau janan shongo ley yachatsicugcunawan fariseocuna! Gamcunaga janallan pintashga ayacunapa mëchunnöllam cayanqui. Jananpaga alläpa shumag cuyacuypag ricacar, rurinchöga wañushgacunapa ismushga tagra tulluncunallam junta. Tsaynöllam gamcunapa shongoyquicunapis jutsacunawan junta caycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gamcunaga runacuna ricäyäshunayquillapag alli rurag carmi, yarpayniquicunachöga alläpa mana alli rurag cayanqui. Allicunata ruragtucurpis pasaypa mana allicunallatam ruraycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Allau janan shongo ley yachatsicugwan fariseocuna! Gamcunaga jatuncaray mëchucunata shäritsirmi shumag adornayanqui, Dios Yayapa unay profëtancunapagwan allicag wañushgacunata respetarnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tsaycunata rurarmi niyanqui: ‘Unay awiluntsic witsay cawarga, Dios Yayapa profëtancunata awiluntsiccuna wañutsiyaptin washarmi, tsaynö yawarnincunata jichashwantsu cargan.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tsaymi caynö cayangayquiwan, unay awiluyquicunanölla Dios Yayapa profëtancunata wañutsig cayanqui. Tsay awiluyquicunanölla rurarmi, rasumpa jutsayog cayangayquita musyayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Unaycag aylluyquicuna Dios Yayapa profëtancunata wañutsir gallariyangantam, canan gamcuna ushaycäyanqui nogata wañutsiyämayta munarnin! ");
INSERT INTO qxnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Culebrapa castan vïboracuna! ¿Imanörag infiernupita gamcuna geshpiyanquiman? ");
INSERT INTO qxnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tsaymi noga gamcunaman cachamushag profëtacunatawan alli musyagcunata y maestrucunata. Waquinta wañutsirmi waquintaga crucificäyanqui. Tsaynöllam waquincagtapis Israel runacuna goricäyänan wajicunachö alli astayanqui. Waquincagtanam marcan marcan gaticachar sufritsiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tsaynö unay awiluyquicuna llapan alli rurag runacunatawan Dios Yaya cachamungancunata wañutsirnin yawarninta jichayanganpitam, gamcunanam Dios Yayapa llapan castïgun chämunga. Unay Adánpa tsurin alli runa Abelta wañutsir gallayanganpita, asta Berequiaspa tsurin Zacariasta templupa altarnin puntanchö wañutsiyanganyag. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tsaymi rasunta niyag: Unay awiluyquicuna tsaynö cayanganpitam, canan cay tiempu cawag runacunaman mantsacaypag castïgu shamunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Ay, Jerusalén, Jerusalén! ¡Dios Yaya cachamungancunatawan profëtancunata chiquirnin wañutsir sagmag! Atsca cutim runayquicunata goriyta munargä, wallpa ripran gopinman chiptsancunata gorignö. ¡Pero manam munayargayquitsu! ");
INSERT INTO qxnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gamcuna shumag tantiyacuyay, cananpitam tsay jatun templuyqui tsunya quëdanga, Dios Yaya aywacuptin. ");
INSERT INTO qxnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tsaymi canan niyag: Cananpitaga mananam masga ni imay ricäyämanquitsu, asta alabarnin ‘¡Alläpa alli cushicuy catsun Dios Yayapa shutinchö Shamuycag!’ niyämangayquiyag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tsaypitanam Señor Jesucristo templupita yargosquir aywaycaptin, discïpuluncuna taripaycur niyargan. “¡Ricay! ¡Alläpa shumag cuyacuyllapag cay jatun templu wajicunawan!” ");
INSERT INTO qxnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Señor Jesucristonam nirgan: “Canan cay shumag ricaycäyangayquipag rasuntam niyag: Cay llapan jatusag templupa wajincunam jancat juchur ushacanga. Manam canan janap janap rumicuna pergaraycanganchö ni jucllayllapis quëdangatsu, llapanmi jancat juchurnin ushanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tsaypitanam Olïvos niyangan jircaman aywayargan. Tsaychö Señor Jesucristo jamaycuptinmi, discïpuluncuna witiycur quiquillanta niyargan: “Tsay templu imay junag ushacänanpagcagta willaycayämänayquitam munayä. ¿Ima señaltatan ricäyäshag imay cutimunayquipagwan cay mundu ushacänanpag canganta?” ");
INSERT INTO qxnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tsaymi Señor Jesucristo nirgan: “¡Cuidädu cayay pipis llullatsiyäshurniquitag engañayäshunquiman! ");
INSERT INTO qxnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Atscagmi nogatucurnin shamur llullatsiyäshunqui: ‘Nogam Diospa Tsurin Cristo cä.’ Tsaynö llullacurnin engañacurmi runacunata yachatsir mana allicunata criyitsicuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","‘Naciuncunam peleayanga’ o ‘Guerracunam canga’ nigtam maytsay juclä marcacunachö wiyayanqui. Pero tsaycunata wiyarpis ama mantsacäyanquitsu. Tsaynö guerracunaga imay carpis rasumpam shamunga. Pero tsaycuna päsaptinpis cay patsaga manaragmi ushacangaragtsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Entëru munduchömi naciuncuna jucnin jucninwan guerrachö cayanga. Tsaynöllam marcacunapis jucnin jucninwan maganacuyanga. Maytsaychöpis alläpa muchuywanmi, patsapis mantsacaypag cuyunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero tsaynö llaquicuy wagacuyga gallarinanllaragmi canga, tucuyläya mantsacaypag sufrimientuna shamunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tsaypitanam gaticachar autoridäcunaman apaycur alli castigatsir wañutsiyäshunqui. Nogata serviyämangayquiraycum maytsay marcacunachöpis runacuna chiquiyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tsay tiempuchö sufrirmi atscag runacuna criyicayämunganta dëjasquir witicuyanga. Tsaynö dëjasquirmi criyicugmajincunatapis autoridäcunaman apaycatsir traicionarnin contran parlayanga. Criyicugmajincunawanmi llapanpis jucnin jucninwan chiquinacuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dios Yayapa willacugnintucurmi atscag runacuna shamur llullatsicurnin mana allicunata engañacur criyitsicuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Imayca mana allicunata rurarmi mas peor runamajincunawanpis maytsaychö alläpa melanaypag cawayanga. Tsaynö mana alli cawarmi runamajincunawan manana cuyanacurnin, mana llaquicug chucru shongo cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero mayganpis wañunganyag nogallaman firmi criyicamugmi sïga, imayyagpis nogawan cawananpag salvacashga canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tsaymi maytsay munduchö Dios Yayapa Mandacuy Reynonpa Alli Willacuyninta willacungä canga, llapan naciuncunachöpis musyayänanpag. Tsay Alli Willacuynïta entëru munduchö willacur ushasquiyaptinmi, cay patsapa ushacaynin chämunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tsay tiempuchömi Dios Yayapa unay profëtan Daniel gellganganchö ningannö ‘melanaypag mana alli ushacätsicug ïdolota’ ricäyanqui. ¡Cayta liyigcagga shumag tantiyacuyätsun! ");
INSERT INTO qxnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tsayta ricarga Judeachö täcugcuna geshpirnin jircacunapa aywacuyätsun. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wajipita wagtachö caycagcunapis ama wajincuna rurinman imancunata jipigllapis cutiyätsuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chacrancunachö caycagcunapis ama ni punchuncunata jipigllapis cutiyätsuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Allau tsay tiempuchö geshyag warmicunawan llullu wawayog chuchuycag warmicuna alläpa llaquipaypagmi sufriyanga! ");
INSERT INTO qxnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dios Yayata mañacuyay tsaynö tiempu tamya tiempuchö ni jamay sabado junagchö mana cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsay tiempuchömi llapan runacuna alläpa mantsacaypag sufriyanga. Tsay ñacar sufriytanöga manam mundu ruracanganpitapis asta cananyag ñacar sufriyashgatsu. Tsay llapan ñacacuy sufrimientucuna päsasquiptinga mananam ni imaypis tsay junagcunanöga yapay canganatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Acrangan runacunata llaquiparmi quiquin Dios Yaya ‘Tsayllachöna’ ninga, ñacar sufriyänanpag tiempu manarag cumpliptin. Si tsaynö rasumpa firmi criyicugcunata mana llaquipaptinga, llapanmi wañuyanman mana ni juc geshpiypa. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Si gamcunata pipis tagaymi ‘Diospa Tsurin Cristo o tsaychömi caycan’ niyäshuptiqui, ama criyiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","‘Diospa Tsurin Cristom cä’ nirmi, llullacurnin engañacur milagrucunawan señalcunata rurarnin mana allicunata criyitsicuyanga. Tsaynö rurarmi mana alli yachatsicugcuna Dios Yaya acrangan runacunatapis imaycanö mana allicunata criyitsirnin engañayta munayanga. Pero tsay rasumpa firmi criyicugcunataga mana engañar criyitsiyta puediyangatsu, quiquin Dios Yaya paycunata tsapaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","¡Alcabo cayay! Tsaynö caycuna manarag captinmi gamcunata willayargagna. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Si pipis ‘Dios Yayapa Tsurinmi tsunyachö caycan’ niyäshuptiqui, ama ricagnin aywayanquitsu. O ‘Cay waji rurinchömi caycan’ niyäshuptiquipis, ama criyiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tsaymi cieluchö jucläpita jucagläman illago alläpa atsicyagnörag, Diospita Shamushga Runa caynïwan cay patsaman cutimushag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maytsaychö wañushga cuerpucuna jitaragcunamanmi wisculcunapis goricäyänga. Tsaynöllam noga cutimuptïpis llapan rasumpa firmi criyicug runacuna, noga caycangäman goricäyämunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tsay alläpa llaquicuy junag päsanganpitaga rupaywan quillapis mananam atsicyämunganatsu. Goyllorcuna shicwayämurmi cieluchö llapan jatusag atsicyagcunapis alläpa cuyupacuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Tsaynö cieluchö señalta ricarmi Diospita Shamushga Runa cutimunäna canganta musyayanqui. Tsaymi maytsay naciuncunachö runacunapis llaquicuywan wagayanga. Tsaynam nogata ricäyämanga alläpa poderöso Mandacuynïwan atsicyarrag pucutay jananchö shamuycagta. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsaymi juc trompëta alläpa jinchi waganga. Tsaynömi angelcunata mandanga entëru munduchö maytsay caru marcacunapa aywar, firmi criyicug acrangan runacunata goriyämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Cananga ïgospa yuranpag willayangagpita yachacuyay. Raprancuna tsaquisquir tsegllimuptinmi musyayanqui tamya tiempuna canganta. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tsaynö willayangagcunata ricarmi musyayanqui llapan willacungäcuna cumplinanpag ichicllana faltaycanganta. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tsaymi niyag: Manarag canan tiempu runacuna wañuyaptinmi, llapan willacungäcuna rasumpa cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cielupis patsapis ushacangam. Pero noga parlangä palabräcunaga manam tsaynöllachötsu ushacasquinga; llapanmi imaypis cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Cieluchö caycag Tayta Diosllam musyan imay junag imay öra cananpag cangantapis. Tsaypitacagga manam ni pipis musyantsu cieluchö angelcunapis ni quiquin Dios Yayapa Tsurinpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Diospita Shamushga Runa caynïwanmi yapay cutimunä öraga unay Noé cawangan tiempunö canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tsay tiempu apäcuy yacuwan entëru munduchö llapanta ushacätsinanpag ichicllana faltaycaptinmi caynö cayargan: Micupacurnin upyapacur warmipis ollgopis casarapacurmi caycäyargan. Tsaynö ni imapag mana yarpachacurmi Noé jatun büquinman yaycungan junagyag cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tamya patsaman juntar manarag apaptinga, manam tsaynö päsananpag canganta tantiyayargantsu. Tsaynö caycarmi shingarnin llapanpis ushacäyargan. Tsaynömi Diospita Shamushga Runa caynïwan illagpita cutimushag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tsay öraga ishcag runacuna chacrachö pagta aruycäyanganpitam juccagllata pusharnin juccagtaga dëjashag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tsaynöllam ishcag warmicuna juc marayllachö pagta agacuycäyanganpita, juccagllata pushar juccagtaga dëjasquishag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“¡Tsaymi wiyag wiyag alcäbu caycäyanqui! Manam musyayanquitsu imay junag ni imay öra cutimunä cangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero caywan tantiyacuyay: Juc runa wajinman imay öra suwa yaycunanta musyarga, wajinta täpar ricchaycarmi suwa yaycunanta shuyaranman. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","¡Tsaynö gamcunapis alcäbu cayay Diospita Shamushga Runa caynïwan imay örapis mana yarpashgatam yapay cutimushag! ");
INSERT INTO qxnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Tsaynöllam juc wajichö maygan servigninpis patronnin ninganta tantiyar mandangancunata cumpliptin, tsay servigninta capatasnin cananpag churan waquincagcunata alli örachö micuynincuna garananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Patronnin cutimur mandanganta ruraycagta tarirga, alläpam cushishga canga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rasumpam llapan imaycantapis churanga tsay cumpligcag servigninpa maquinman. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero servignin mana alli carga, ‘Patronnï manaragmi cutimungaragtsu’ nirmi yarpanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tsaynö yarparmi servicugmajincunatapis magayta gallarir, upyar, micur, machashgacunawan goricashga puricunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tsaynö mana shuyararnin caycaptinmi, mana yarpashgallata mana musyangan öra ni junag patronnin cutimunga. ");
INSERT INTO qxnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tsaynö ruraycagta tarisquirmi alläpa mantsacaypag castigarnin waquincag janan shongolla allitucugcunatawan iwal gargonga. Tsaychömi wagar quiruntapis regochyätsirnin ñacar sufringa. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Canan willayäshayqui Dios Yayapa Mandacuy Reynonta shuyagcuna imanö cayangata, noga cay patsaman cutimunäpag. Juc chunca jipashcunam linternancunata aptacurcur, casarananpag novio shamugta shuyag aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pitsgacagmi alli yarpayyog cayargan. Pero pitsgacagcunaga mana juc yarpayyogmi cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mana shumag yarpachacugcagcunaga manam keroceneta apayargantsu linternancunaman yapayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero alli yarpachacugcagcunam sïga linternancunapag keroceneta yapayänanpag juc botellachö apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Casarag novioga manam sasllaga chämurgantsu. Tsaymi shuyaraycäyanganchö jipashcuna puñucasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pullan pagasnam carupita gayacamugta wiyasquiyargan, ‘¡Casarag novio caychönam; yargayämuy tincug!’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tsaymi llapan jipashcuna wap sharcurnin linternancunata preveniyargan shumag atsicyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Keroceneta mana apamugcagcunam waquincagcunata mañacur niyargan: ‘¡Keroceneta raquipaycayämay; linternacunam wañuycanna!’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Alli yarpayyogcag jipashcunam niyargan: ‘Raquipuyaptigga manam nogacunapagpis pagtangatsu. Quiquiquicuna ranticugcunaman aywar rantiyämuy.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jipashcuna keroceneta rantig aywayanganyagmi, casarag novio chämurgan. Listo shuyaycagcunata pusharcurmi fiestaman yaycurgan. Tsaynö yaycusquirmi wajipa puncuntam wichgascamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Keroceneta waquincag jipashcuna rantiyanganpita cutiscamurmi, ‘¡Señor, Señor! ¡Puncuta quichaycallämuy!’ niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero casarag novioga ruripitam nimurgan: ‘Gamcunataga manam regëyagtsu.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tsaypitanam Señor Jesucristo yapay nirgan: “¡Tsaymi gamcuna alcäbu wiyag wiyag caycäyanqui, nogaga mana musyangayqui öram illagpita cutimushag! ¡Manam musyayanquitsu ni imay öra ni imay junag cutimunanpag cangantapis! ");
INSERT INTO qxnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Dios Yayapa Mandacuy Reynon shamuptinmi, cay rïcu runa rurangannö canga. Juc rïcu runam caru marcapa illänanpag servignincunata gayascatsir, chacrancunachö aruyänanpag dëjapurgan. Tsaynöllam servignincunata atsca gellayninta prestargan, cutimunganyag aruycätsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tsaymi juccagta pitsga warangata juccagtaga ishcay warangata y juccagtanam juc warangallata prestargan. Cada ünutam segun puediyanganmannölla prestargan. Tsaynö prestasquirmi caru marcapa aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pitsga warangata chasquigcagga jucläpa aywarmi negociuta rurargan. Tsaynöpam pitsga waranga masta gänargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ishcay warangata chasquigcagpis negociuta rurarmi, ishcay waranga masta gänargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero juc warangallata chasquigcag servicugga, patsata uchcusquirmi pampasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tsaypita unaytana patronnincuna cutiscamurmi, servignincunata prestangan gellayta cutitsiyänanta munargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsaymi tsay pitsga warangata chasquigcagga chunca warangatana apamurnin cushishga cutitsir nirgan: ‘Patron, cayllä confiacamar prestallämangayqui gellayniquiwan negociuta rurarmi, pitsga waranga masta gänallashcä.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tsaynam patronnin nirgan: ‘¡Gamga alli arug cumplïdu runam canqui! Wallcallawanpis cumplïdu cangayquipitam imätapis mas confiacur garashayqui manejanayquipag. Cananmi cushicuypita fiestata rurashun.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsaypitanam ishcay warangallata chasquigcag servigninpis entregar nirgan: ‘Patron, cayllä. Ishcay waranga gellayniquita confiacamar prestallämangayquiwanmi ishcay waranga masta gänallashcä.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tsaymi patronnin nirgan: ‘¡Gampis alli arug runam canqui! Wallcallawanpis cumplïdu cangayquipitam imätapis confiacur mas garashayqui manejanayquipag. Cananmi cushicuypita fiestata rurashun.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ultimutanam juc warangalla gellayta chasquigcag servignin chaycamur nirgan: ‘Patron, musyämi gamga mana llaquipäcug car, imatapis mana murungayquipita goringayquita. Tsaynöllam magtsirnin mana arutsishga caycarpis goritsinqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsaynö captiqui mantsacurmi gellayniquita mana yataparlla pamparätsishcä cay gellayniqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tsaymi patronnin nirgan: ‘¡Gamga alläpa mana aruy yachag, gela mana alli runam canqui! Mana murushga ni magtsishga caycarpis goringäta musyanquim ¿Au? ");
INSERT INTO qxnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tsayta musyaycarga gellaynïta bancuman churaycunquiman cargan. Tsaynö churaycuptiquiga canan cutimurmi wachaynintawan chasquïman cargan.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tsaypitanam waquincag servignincunata nirgan: ‘Tsay waranga gellaynïta gechusquir chunca waranga gellayyogcagta garaycuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsaymi alli manejagcagga mas yapashga canga asta sobrapucunganyag. Tsaynömi mas yachayog alli runaga canga. Pero gelacag runataga ichiclla capunganpis jancatmi gechuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Canan cay gela mana väleg servignïta wagta tutapay mana actsicagman gargoyay, tsaychö quirunpis regochyaptinrag wagarnin ñacar sufrinanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Diospita Shamushga Runa caynïwanmi llapan angelcunawan cutimushag. Gamcuna ricaraycäyämaptiquim alläpa poderöso caynïwan chämur, reypa glorianchö atsicyagrag jamacunanman jamashag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tsaymi puntäman entëru munduchö maytsay naciuncunapita runacuna goricäyämunga. Tsaypitanam imayca mitsicug cabracunapita üshacunata raquignö llapan runacunata raquishag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Üshanöcag runacunatam derëchucag lädüman churar, cabranöcag runacunataga itsogcag lädüman churashag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tsaymi noga rey derëchucag lädüchöcagcunata nishag: ‘Shäriyämuy Taytä Dios Yayapa bendiciunninta cushishga chasquigcuna. Gamcunapagmi cay munduta rurangan örapitana gloriachö imayyagpis cawayänayquipag, Dios Yayapa Mandacuy Reynonchö erenciayquicuna alistashgana caycan. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gamcunam mallagaycaptï micuyta garayämargayqui. Yacunaycaptïpis yacutam upyatsiyämargayqui. Mana regeshga juclä marcapita caycaptïpis wajiquicunaman convidarmi posadatsiyämargayqui. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Llatapä mana captinmi llatapata shucutsiyämargayqui. Geshyaptïpis cuidamagnïmi shayämurgayqui. Carcelchö gaycuraptïpis watucamar ricämagnïmi shayämurgayqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tsaymi tsay allita rurag runacuna niyanga: ‘Taytay, ¿Imaytan mallagaycaptiqui garayargag? ¿Imaytan yacunaycaptiqui upyatsiyargag? ");
INSERT INTO qxnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Imaytan mana regeshga juclä marcacunanö puriycagta wajïcunaman convidar posadatsiyargag? ¿Imaytan llatapayqui mana captin shucutsiyargag? ");
INSERT INTO qxnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Imaytan geshyaycaptïqui cuidayargag? ¿Imatan carcelchö gaycuraptiqui watucar ricagniqui shayämurgä?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tsaymi noga rey nishag: ‘Rasumpa pitapis alläpa sufrir ñacarpis nogapa criyicug waugëcunatawan mas umilde wactsacunata yanaparmi nogata yanapamagnö rurayargayqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pero tsay itsogcag lädüchö caycagcunatam sïga nishag: ‘Maldiciunäducuna puntäpita witicur infiernuman aywayay Satanaspa supaynincunawan pagta unaypita prevenishga mana ni imay ushacar lunyaycag ninachö ruparnin sufriyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mallagaycaptïpis manam garaycayämargayquitsu. Yacunaycaptïpis manam yacullatapis garaycayämargayquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Juclä mana regeshganö puriycaptïpis manam wajiquicunallaman posadatsiyämargayquitsu. Mana llatapä captinpis manam shucurcatsiyämargayquitsu. Geshyaycaptïpis manam cuidayämargayquitsu. Carcelchö gaycuraptïpis manam watucamagnï shamurgayquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tsaymi tsay mana allita rurag runacunapis niyämanga: ‘Señor, ¿Imaytan mallagaycagta, yacunaycagta, juclä mana regeshgacunanö llatapannag puriycagta, geshyaycagta y carcelchö gaycuraycagta ricaycar, mana llaquipäyargagtsu?’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tsaymi nishag: ‘Cay wactsa umilde sufrigcunata mana llaquiparmi, nogata llaquipäyämargayquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tsaynö mana alli rurag cayanganpitam infiernuman imayyagpis ñacar sufriyänanpag aywayanga. Pero rasumpa firmi criyicur alli ruragcagcunam sïga gloriachö Dios Yayawan imayyagpis cawag aywayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tsaypitanam Señor Jesucristo yachatsicuyta ushasquir discïpuluncunata nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Musyayangayquinöpis Pascua fiestapag ishcay junagllanam faltaycan. Tsaychömi prësurnin cruzchö wañutsiyämanga Diospita Shamushga Runa captï.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tsaypitanam mandacug sacerdöticunawan israelcunapa autoridänincuna, mas mandacug sacerdöti Caifaspa jatun palacionman goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tsaychömi willanacuyargan Señor Jesucristota pacayllapa achcusquir wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tsaymi caynö willanacur niyargan: “Ama Pascua fiestachöga achcushuntsu. Tsaychö achcusquishgaga maytsicag goricashga caycag runacunam piñacur, imayca mana allicunatapis rurascamashwan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tsaypitanam Señor Jesucristo Betania marcachö “wicupita cuticashga” niyangan Simónpa wajinchö caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Señor Jesucristo mësachö jamaycaptinmi juc warmi “alabastro” niyangan frascuchö, alläpa chaniyog mushcug perfümita apamur shamurgan. Chaycamurmi Señor Jesucristopa umanman tsay warmi perfümita wiñargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Discïpuluncunam tsayta ricaycur piñacurnin niyargan: “¡Imapagrag tsaynö jicharnin perdetsin! ");
INSERT INTO qxnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tsay perfümita alläpa chaninchö ranticusquir wactsacunata aypurllapis mas yanapashwan cargan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tsaynö parlaycäyanganta Señor Jesucristo musyarmi nirgan: “¿Imanirtan cay warmita piñapäyanqui? Payga shumag allitam nogapag rurashga. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wactsacunaga gamcunawanmi imayyagpis caycäyanga. Pero nogaga mananam gamcunawan pagta caycäshagnatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Caynö perfümita cuerpüman wiñämurmi pampayämänanpag alistaycämanna. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rasuntam niyag: Maytsay marcacunachöpis Alli Willacuyta willacuyanganchömi, cay warmi umäman perfümita wiñämunganta llapan musyayänanpag willacur payta yarpäyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tsaypitanam Señor Jesucristopa chunca ishcay discïpuluncunapita Judás Iscariote mandacug sacerdöticunaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tsaymi nirgan: “Señor Jesucristota prësu achcuyänayquipag entregayaptigga, ¿Aycatatan pägayämanquiman?” Tsaynö niptinmi quimsa chunca yurag gellaycunata pägayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsay örapitam Judásga juc tiemputa ashirnin yarpachacur nirgan: “¿Imanöllaparag o imay örarag entregaycüman?” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascua semäna fiestachöga levadürannag tantata micuyänan puntacag junagmi cargan. Señor Jesucristoman discïpuluncuna witiycurmi tapur niyargan: “¿Maychötan Pascua meriendata micunapag alistayäshag?” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Señor Jesucristonam nirgan: “Jerusalénman aywar, tsaychö juc runapa wajinman chaycur niyanqui: ‘Maestrum nin: Öra chaycämunnam. Tsaymi wajiquichö Pascua meriendata discïpulücunawan celebrarnin micushag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mandangannöllam discïpuluncuna tsay wajichö alistayargan Pascua meriendata micuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Rupay jegay öram alistayangan mësachö Señor Jesucristo chunca ishcay discïpuluncunawan caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tsaychö micuycäyaptinmi Señor Jesucristo nirgan: “Rasuntam niyag: Gamcunapita jucniquim maygayqui carpis traicionamarnï chiquignïcunapa maquinman entregayämanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Señor Jesucristo tsaynö niptinmi llaquishga jucnin jucnin tapuyargan: “Señor, ¿Manam nogallätsu cä?” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tsaymi Señor Jesucristo nirgan: “Nogawan pagta juc matillachö tantanta tullpuycagmi, traicionamarnï chiquignïcunapa maquinman ranticamar entregamanga. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tsaynöpam nogawan cumplinga ‘Dios Yayapa Tsurinta caynömi wañutsiyanga’ nir, Diospa Palabran gellgatsinganchö ningannö. ¡Pero allau tsay ranticamagnï runa, llaquiypagmi ñacarnin sufringa! Tsay runapag mas allim canman cargan mana yuriptin.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tsaymi traicionar ranticugnnin Judás: “Maestru, manam nogatsu cä ¿Au?” nirgan. Tsaynö niptinmi Señor Jesucristo nirgan: “Aumi. Quiquiquim tsayta nicanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsaychö micuycäyaptin sharcurmi Señor Jesucristo tantata aptarcur, Dios Yayata agradëcicurnin bendisarnin mañacurgan. Tsaypitanam discïpuluncunata paquin paquin aypurgan: “Cayta tanta micuyay. Cayga nogapa cuerpümi” nirnincuna. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsaynöllam cöpaman vïnota wiñarcur yapay maquinwan aptarcur Dios Yayata agradëcicur mañacusquir discïpuluncunata gararnin nirgan: “Cayta llapayqui upyayay. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cayga nogapa yawarnïmi. Yawarnïta jichangäpitam Dios Yaya äningan imayagpis canga, llapanta perdonaptin salvacashga cayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Rasuntam niyag: Cay vïnota yapayga mananam upyashagnatsu, Taytä Dios Yayapa Mandacuy Reynonchö gamcunawan pagta mushogcag jucläya vïnota upyangantsicyag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tsaypitanam Dios Yayaman mañacuna cantuta cantasquir, Olïvos niyangan jircaman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tsaypitanam Señor Jesucristo nirgan: “Canan pagasmi nogapita pengacur llapayqui dëjascayämar aywacuyanqui. Tsaynö cananpagmi Diospa Palabran gellgashgachö nirgan: ‘Mitsicugta wañuscatsiyaptinmi, üshancuna witsicar aywacuyanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero wañuscatsiyämaptin cawascamurmi gamcunapita mas puntata Galileaman aywashag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tsaynö niptinmi Pedro nirgan: “Waquincagcuna gampita pengacurnin geshpir aywacuyaptinpis, nogaga manam ni imay dëjashayquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Señor Jesucristonam Pedrota nirgan: “Pedro, rasuntam nig: Canan pagasmi manarag gallu cantaptin, quimsa cuti mana regegtucamar nëgamanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedronam yapay nirgan: “¡Gamtawan wañutsiyämaptinpis, nogaga manam ni imay nëgashayquitsu!” Waquincag discïpuluncunapis Pedro ningannöllam niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tsaypitanam Señor Jesucristo discïpuluncunawan Getsemani niyangan wertaman aywargan. Tsaychömi nirgan: “Gamcuna cayllachö jamaycäyay. Mas washaläpa aywashag Dios Yayäman mañacunäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tsaypitam Pedrota, Zebedeopa ishcan tsurincuna Santiagotawan Juanta washaläman pushargan. Tsaychömi alläpa llaquicur, yarpachacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tsaymi nirgan: “Wañunaypanömi alläpa yarpachacur llaquicü. Cayllachö nogawan pagta ricchar caycäyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsaypita mas washaläman witisquirmi patsaman umpuycur mañacurnin nirgan: “Taytallä, imayca juc cöpachö alläpa ayag träguta upyanä canganpita salvaycamay. Si jucnöpa puedicaptinga, mana alläpa ñacarnin sufrinäpag tsapaycallämay. Pero ama noga munangänöga catsuntsu. Sinöga gam munangayquinö catsun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsaypita cutimurmi discïpulucuna puñucashgata tarirgan. Tsaymi Pedrota nirgan: “¿Manacu ni juc örallapis nogawan pagta awantar ricchayta puediyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Canan riccharnin Dios Yayata mañacuyay, Supay jutsata ruratsiyta munayäshuptiquipis mana shicwayänayquipag. Dios Yaya munanganta rurayänayquipag voluntäniquicuna captinpis, mana callpannagnö dëbilmi cayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tsaynö nisquirmi yapay witisquir mañacurnin nirgan: “Taytallä, jucnöpa mana puedicar, cay cöpachö alläpa ayag träguta upyar ñacarnin sufrinäta munaptiquiga, munangayquinö callätsun” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yapay cutiscamurmi discïpuluncuna puñucashgata tarirgan. Puñuy alläpa venceptinmi puñucäyashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsaymi yapay quimsa cutina Dios Yayata mañacug aywargan puntata mañacur ningannölla. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsaypita yapay cutiscamurmi discïpuluncunata nirgan: “¿Jinallacu puñuycäyanqui pishipashganö shütarnin? ¡Ricäyay! Öra chämushganam Diospita Shamushga Runa captï, traicionamarnï chiquignïcunapa maquinman entregayämaptin, prësu achcuyämänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Shäriyämuy. Acuna. Traicionamar entregamagnï tsiytanam shamuycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tsaynö Señor Jesucristo parlaycaptinmi, espädancunawan geruncunawan atscag runancuna pushashga discïpulun Judás chämurgan. Tsaymi mandagcag sacerdöticunawan israelcunapa autoridänincuna runacunata cachayämurgan Señor Jesucristota achcusquir prësur apayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tsay traicionagnin Judásmi mas puntatana autoridäcunata yachatsirnin nirgan: “Maygantapis alabarnin mutsangämi, Señor Jesucristo canga. Tsay runata achcusquir prësu apayämunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsaymi Judásga shumaglla Señor Jesucristoman witiycur: “Tsayragmi nogalläga chaycällämü, maestru” nir, mutsaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Señor Jesucristonam nirgan: “Amïgo, ¿Imag shamungayquitapis rurarnin cumpliy?” Tsay Judás pushamungan runacunam Señor Jesucristota achcusquir prësu apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tsaypitanam juccag discïpulun espädanta jipisquir, mas mandacug sacerdötipa servigninpa rinrinta rogosquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsaymi Señor Jesucristo discïpulunta nirgan: “Espädayquita sitiunman churay. Pipis espädawan pelearga, tsaynö espädallawanmi wañungapis. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manacu tantiyacuyanqui? Salvamänanpag Dios Yayata mañacuptïga, Pay cachamunmanmi maytsicag (72,000) ganchis ishcay waranga batallun angelnincunata. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tsaynö mañacuptï salvamaptinga, manam Dios Yaya Palabranchö gellgatsingannö wañümantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tsaymi autoridäcuna cachayämungan atscag runacunata Señor Jesucristo nirgan: “¿Nogaga suwacu cä? ¿Imanirtan espädayquicunawan y geruyquicunawan pacayllapa tutapaychö shayämurgoyqui? Waran waran templuchö yachatsicurnin jamaycaptïga, manam achcuyämagnï shayämurgayquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero cananmi sïga Dios Yaya unay profëtancunawan gellgatsingan cumplinanpag achcuyämanqui.” Tsaynö niptinmi llapan discïpuluncuna Señor Jesucristota dëjasquir, geshpirnin witsicar aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tsaynö Señor Jesucristota prësu achcusquirmi mas mandacug sacerdöti Caifaspa palacionman apayargan. Tsay palaciomanmi ley yachatsicugcunawan templuchö mandacug llapan autoridäcuna goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pero Pedronam Señor Jesucristopa caru gepallanta gatirnin, mas mandacug sacerdöte Caifaspa ruri patiuyag yaycurgan. Tsaychömi wardiacunawan pagta jamargan Señor Jesucristota ima päsanganta ricänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tsaychömi llapan goricashga mas mandacug sacerdöticunawan israelcunapa autoridänincuna, Señor Jesucristopa contran maygallanpis parlananpag ashiyargan, tsaywan acusarnin wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero atscag llullacurnin acusar wañutsiyänanpag parlayaptinpis, manam ni maygan acuerdutsu cayargan. Tsaypita unay rätu päsasquiptinnam ishcay llullacug testïgucuna witiycur, ");
INSERT INTO qxnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","declararnin niyargan: “Cay runaga caynömi nirgan: ‘Nogaga Dios Yayapa jatun templunta juchuscatsir, quimsa junagllachömi sharcatsiyta puedï’ ” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsaynö niptinmi mas mandacug sacerdöti ichircur, Señor Jesucristota tapur nirgan: “¿Imatan cay contrayqui parlayangan? ¿Manacu ni imapis ninqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tsaynö niptinpis Señor Jesucristoga manam ni ima nirgantsu. Tsaynam mas mandacug sacerdöti nirgan: “Cawaycag Dios Yayapa puntanchö llapantsic caycangantsicta musyaycarga, rasumpacagta jurarnin nimay: ¿Gamga rasumpacu Dios Yayapa Tsurin Cristo canqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tsaymi Señor Jesucristo nirgan: “Aumi. Gam ningayquinöllam noga cä. Tsaynö captinmi llapayquita niyag: ‘Diospita Shamushga Runa captïmi’, Dios Yayapa derëchucag lädunchö jamaycagtawan pucutay jananchö cielupita shamuycagta ricäyämanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsaynö niptinmi mas mandacug sacerdöti alläpa piñacurnin, sotänantapis rachisquir nirgan: “¡Cay runaga Diospa Tsurintucurmi, Diosnintsicta pengacuyman churaycan! ¿Imapagnatan mas testïgucunatapis wanantsic? Wiyayargoyquinam Dios Yayapa contran mana allita parlanganta. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Cananga ¿Imatatan gamcuna paypag niyanqui?” Tsaymi llapan gayaycachar niyargan: “¡Rasumpa culpayogmi! ¡Payga wañutsun!” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsaynö nirmi, Señor Jesucristopa gagllanman togapurnin cutar magayargan. Waquincagcunanam lagyarnin niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Rasumpa Cristo carga mä ¡Adevinay pï lagyashungayquitapis!” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsay öranam discïpulun Pedro patiuchö jamaycargan. Tsaymanmi juc servicug jipash witiycur nirgan: “Gamga Jesúswan puriga Galilea marca runam canqui, ¿Au?” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsaymi Pedro llapanpa puntanchö nëgarnin nirgan: “Manam musyatsu imatarag parlacunquipis.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tsaypitanam puncuman yargosquiptin, juccag servicug warmi ricaycurnin nirgan: “Cay runaga Nazaret marcapita Jesúswanmi purishga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tsaynö niyaptinnam Pedro yapay jurarnin nëgar nirgan: “Tsay runata manam regëtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tsaypita mas unay rätunllatanam tsaychö ichiraycag runacuna Pedroman witiycur niyargan: “Rasumpam gampis tagay runapa gatiragnin canqui; asta parlayniquipis Galilea runacunapanömi.” ");
INSERT INTO qxnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsaymi Pedro juracurnin quiquinpa contran maldiciunäcur nirgan: “Dios Yayapa puntanchömi juracurnin nï: Tsay runataga manam rasumpa regëtsu.” Tsaynö parlar ushaycaptinmi, gällu cantasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsaypitam Pedro yarpasquirgan Señor Jesucristo “Canan pagasmi quimsa cuti nëgamanqui manarag gallu cantaptin ninganta.” Tsayta yarpasquirmi wagtaman yargosquir, alläpa llaquicur wagargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsaypitanam patsa warasquiptin mandacug sacerdöticunawan israelcunapa autoridänincuna Señor Jesucristota wañutsiyänanpag willanacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsaynö yachatsinacusquirmi alli chachac watashgata gobernador Pilatoman apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Señor Jesucristota wañutsiyänanpag canganta musyasquirmi, traicionarnin entregacug Judás Iscariote alläpa llaquicurnin yarpachacur quillanchö nirgan: “Alläpa mana alli jutsatam rurashcä.” Tsaynö alläpa arepenticurmi mandacug sacerdöticunawan llapan autoridäcunaman aywaycur quimsa chunca yurag gellay pägayanganta cutitsir nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Mana juc jutsayogta wañutsiyänayquipag entregayarniquim, alläpa mana alli jutsata rurashcä.” Tsaymi sacerdöticunawan autoridäcuna niyargan: “Manam nogacunataga ni imapis gocayämantsu. ¡Gamna imanöpis cacuy!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tsaynö niyaptinmi yurag gellay pägayanganta jatun templupa rurinman jitasquir aywacurgan. Tsaypita aywasquirmi quiquillan jurcacurnin wañurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsaynö gellayta jitasquir Judás aywasquiptinmi, mandacug sacerdöticuna gellayta gorisquir niyargan: “Ama cay gellayta wiñäshuntsu, Dios Yayapag garangantsic gellay churaranganmanga. Tsaytaga leynintsic proibimantsicmi, runata wañutsinapag pägangantsic captin.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsaypita yarpasquirmi tsay gellaywan manca rurag runapita chacrata rantir niyargan: “Juclä naciunpita mana regeshga runacuna wañuyaptinmi tsayman pampatsishun.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tsaypitam cananyagpis tsay chacrapa shutin “Yawarpampa.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tsaynö sacerdöticuna rurayanganwanmi cumplirgan Dios Yayapa unay profëtan Jeremias Señor Jesucristopag gellgar ningan: “Llapan Israel runacunapis parlayanga, ‘Tagayga juc esclävupa chanin quimsa chunca gellayllam välergan.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tsay gellaywanmi manca rurag runapita chacrata rantiyargan, Dios Yaya mandamangannölla.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gobernador Pilatopa puntanchö Señor Jesucristo ichiraycaptinmi, Pilato tapur nirgan: “¿Rasumpacu Israel runacunapa reynin canqui?” nir. Señor Jesucristonam nirgan: “Aumi. Gam ningayquinöllam cä.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Llapan mandacug sacerdöticunawan israelcunapa autoridänincunapis shimpirnin contran parlayaptin, Señor Jesucristoga manam ni ima nirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tsaymi Pilato tapurgan: “¿Manacu wiyanqui tucuyläya imaycata shimpirnin contrayqui parlayaptin?” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tsaynö llapan llullacur shimpir acusayaptin, Señor Jesucristoga manam ni imallatapis nirgantsu. Tsaynöta ricarmi, Pilato alläpa mantsacashga ricarargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tsaypitanam gobernador Pilatopa costumbrin caynö cargan: Cada wata Pascua fiestachömi llapan runacuna acrayangan juc prësuta gargog. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsaychömi alläpa regeshga wañutsicug Barrabas shutiyog runa gaycuraycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsayman maytsicag runacuna goricashga cayaptinmi, Pilato tapurnincuna nirgan: “¿Maygancag prësutatan gargonäta munayanqui? ¿Barrabastacu? o ‘¿Diospita Shamushga Cristo’ niyangan Jesústacu?” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatoga musyashganam cargan, mandacug sacerdöticuna chiquicurnin Señor Jesucristota chiquir apayämunganta. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Juiciucunata arreglacunan balconchö Pilato jamaycaptinmi, warmin juc willacuyta willananpag juc servigninta cachar nirgan: “Tsay runaga jutsannagmi. Paypa jananmi canan junag mana allita sueñurnin alläpa sufrishcä. Tsaymi ama ni imatapis paypag contran ruraycuytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero israelcunapa autoridänincunawan templuchö mandacug sacerdöticunam maytsicag runacunata mañacatsir niyargan: “Mañayay Barrabas prësu canganpita gargosquir, Señor Jesucristota wañutsinapag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tsaypitanam yapay gobernador Pilato llapan runacunata tapur nirgan: “Cay ishcan prësupita ¿Maygantatan gargoshag?” Tsaynö niptinnam llapan runacuna gayaycachäyargan: “¡Barrabasta gargoycuyga!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tsaymi Pilato yapay tapurnincuna nirgan: “Tsaypunga ‘Cristo’ niyangan Jesústaga, ¿Imatatan rurashag?” Llapan runacunam gayaycachar niyargan: “¡Crucificar wañutsiy!” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tsaynö niyaptinmi Pilato yapay tapurgan: “¿Imanirtan? ¿Imapitatan wañutsishag? ¿Acäsu ima jutsatapis rurashgatagcu?” Pero llapan runacunanam yapay mas jinchi gayaycachar niyargan: “¡Crucificashga catsun!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tsaynö llapan timpullyarrag mas gayaycachäyaptinmi, gobernador Pilato ni imaniyta puedirgantsu. Tsaynö mana imanö cayta puedirmi, yacuta mañasquir llapan runacunapa puntanchö maquinta mayllacur nirgan: “Cay runa yawarninta jicharnin wañuptin, nogaga manam jutsayogtsu cashag. ¡Mä, gamcunana imanöpis cacuyay!” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsaynö niptinmi runacuna niyargan: “Aumi, tsay runa yawarnin jichanganta nogacunatawan wamräcunata jitapäyämay. Nogacunata jitapayämaptiquiga jutsayogmi cayäshag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tsaypitanam Barrabasta gargorgasquir, Señor Jesucristota alli astaycatsirnin soldäduncuna crucificäyänanpag entregargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsaypitanam gobernador Pilatopa soldäduncuna palaciopa patiunman Señor Jesucristota apaycur, llapan soldädumajincunata gayascatsir entërumpa tumat juntapusquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tsaychömi Señor Jesucristota llushtiscatsir, puca sotänata imayca juc reytanö shucutsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tsaynöllam cashapita awashga corönatapis umanman churayargan. Derëchucag maquinman tucruta aptarcatsir burlacurmi, puntanman gongorpacuycur asipar niyargan: “¡Vïva israelcunapa reynin!” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tsaynö togapurnin usharmi, aptatsiyangan tucrullawan umachö yapay yapay garutiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsaynö asiparnin burlacur ushasquirmi, sotänata llushtiscatsir quiquinpa llatapanta shucutsiyargan. Tsaypitanam crucificar wañutsiyänanpag apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jerusalénpita apaycäyanganchö Simón shutiyog Cirene marcapita runawan tincuyargan. Tsaymi cruzta apananpag obligarnin matancätsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tsaypitam Golgota niyangan jircaman chätsiyargan. (“Golgota” ninanga Umatullu Jirca ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tsaychömi ayagwan tacushga vïnota upyatsiyargan “Cayta upyay.” Tsaymi Señor Jesucristo ichicta yawarcurlla, mastaga upyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Señor Jesucristota crucificasquirmi sortiyayargan llatapanta raquipunacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tsaypitanam jamaycur wañunganyag täparäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Señor Jesucristo cruzchö clävaraycaptinmi, uman jananman juc letrërota churayargan imapita acusayanganta musyayänanpag. Tsay letrërochömi nirgan: “CAY JESÚSMI, ISRAEL RUNACUNAPA REYNIN.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tsaynöllam ishcay suwacunatapis, Señor Jesucristopa ishcanläninman crucificashga cayargan. Juccagtam derëchucag lädunman ichïtsiyargan, juccagtanam itsogcag lädunman. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nänipa päsag runacunam Señor Jesucristota cruzchö clavaraycagta ricar asiparnin burlacuyargan. Umancunatapis cuyutsirragmi cushiparnin, ");
INSERT INTO qxnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","insultar niyargan: “¡Gamga templuta juchuscatsir quimsa junagllata sharcatsiyta puedinqui! ¡Tsaynö puedig caycarga, quiquiqui mä, salvacuy! ¡Dios Yayapa Tsurin carga, cruzpita mä yarpamuy!” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tsaynöllam mandacug sacerdöticunawan ley yachatsicugcuna, israelcunapa llapan autoridänincunapis Señor Jesucristota asiparnin burlacur niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Juccunataga salvashgam. Pero ¡quiquinga manam salvacuyta puedintsu! ¡Israelcunapa reynin carga, mä, cruzpita canan yarpamutsun! Cruzpita yarpascamuptinmi sïga, llapantsicpis rasumpa Payman criyishwan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Payga Diosmanshi rasumpa confiacur criyicun. Tsaypunga, mä, Dios Yaya rasumpa cuyarnin munarga canan salvatsun. Payga ‘Tsurinmi cä’ nirantsag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tsaynöllam lädunchö crucificashga caycag suwacunapis alläpa insultarnin burlacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tsaypitanam pullan junagpita asta las tresyag, patsa jancat tutapasquir rupaypis atsicyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Cäsi las tresnam Señor Jesucristo llapan callpanwan gayarar nirgan. “Eloi, Eloi, ¿Lama sabactani?” (Tsay ninanga cargan “Diosnï, Diosnï, ¿Imanirtan dëjamashcanqui?” ninanmi.) ");
INSERT INTO qxnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tsaynö niptinmi tsaychö waquincag wiyagcuna niyargan: “Dios Yayapa unay profëtan Elíastam gayaycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tsaymi jucnin sas aywaycur, esponjata puchgog vïnoman tullpurcur, tucrupa puntanman watarcurnin Señor Jesucristopa shiminman shogonanpag churargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero waquincag runacunanam niyargan: “Ama imatapis rurayaytsu. Shuyäshun. Mä, Elías salvagnin shamungacush.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tsaymi Señor Jesucristo yapay llapan callpanwan gayarasquir wañusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tsaypitanam jina öra mas respetayangan templuchö jatun shumag awashga cortina tsaparag janagpita uraypa ishcayman rachisquirgan. Patsapis alläpam cuyurgan. Gagacunapis tsillirmi ushacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Unayna wañushga allita rurag runacuna pamparäyangan mëchucunapis quichacäyarganmi. Tsaymi tsay atscag unayna alli rurag runacuna wañushgacunapis cawayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mëchuncunapitam yargapacayämurgan. Señor Jesucristo cawascamuptinmi, tsay cawamugcunapis Jerusalén santa marcaman yaycuyargan. Tsaychömi atscag runacunata yuripuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Señor Jesucristo wañungan öra täpaycag capitanpis soldäduncunawan patsa cuyugtawan llapan imayca päsagta ricarmi, alläpa mantsacar nirgan: “¡Cay runaga rasumpa Diospa Tsurinmi cashga!” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tsaynöllam mas carullapita atscag warmicunapis ricaraycäyargan. Tsay warmicunaga Galileapita Señor Jesucristota gatimur, imatapis wananganta servignin shamugcunam cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tsaychömi caycäyargan María Magdalenawan Jacobpawan Josépa maman Maríapis, Santiagopawan Juanpa maman Zebedeopa warminpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Patsa goyaycaptinnam juc rïcu Arimatea marcachö yurig José shutiyog runa shamurgan. Tsay runapis Señor Jesucristoman criyicurmi, paypa gatiragnin ticrashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tsaynöpam Pilatoman aywaycur Señor Jesucristopa cuerpunta pampananpag mañargan. Pilatonam soldäduncunata entregayänanpag mandargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Señor Jesucristopa cuerpunta chasquisquirnam juc limpiu “lïno” niyangan tëlapita säbanaswan piturcur apacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tsaynö apacurmi quiquin pampacänanpag gagata tsayrag uchcutsinganman pampargan. Pampangan uchcutanam juc jatuncaray parara rumiwan tsapargan. Tsaynö pampasquirnam aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalenawan Josépa maman Maríam pampayangan lädunchö llapanta ricar, ishcan jamaycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Señor Jesucristo wañunganpa waränin jamay sabado junagmi, mandacug sacerdöticunawan fariseocuna juntawacasquir Pilatota ricag aywayarnin, ");
INSERT INTO qxnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","niyargan: “Señor gobernador Pilato, tsay reytucug runa parlanganta nogacuna yarpäyämi: ‘Wañungäpita quimsa junagllatam cawamushag’ ninganta. ");
INSERT INTO qxnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsay pamparanganta täpaycuyätsun quimsa junag cumplinganyag. Mana sïga, discïpuluncuna pagaspa shamuycur suwarnin ayanta apasquirmi, runacunata llullatsir ‘wañunganpitam cawamushga’ niyangan. Tsaynö llullacuyga, puntacagpitapis mas peor mana allim canman.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tsaynö niyaptinmi Pilato nirgan: “Cay soldädu aywatsun. Tsayman pushayay. Shumag täpatsir yarpäyangayquinö rurayay, tsaynö mana päsananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tsaynö niyaptinmi pamparangan sepultüraman aywaycur, rumiwan tsaparnin juc sëlluta churayargan mana ni pï yaycuyänanpag. Tsaynöllam puntata juc soldädutapis tsayman churayargan cuidarnin täpananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tsaypita jamay sabado junag päsasquiptinnam, semäna gallaringan domingo alleg patsa waraycämuptin María Magdalena juccag Maríawan Señor Jesucristo pamparangan sepultürata ricag aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsaychömi illagpita patsa alläpa cuyuptin Dios Yaya cachamungan juc angel cielupita urämur, tsay tsaparag parara rumita tumatsirnin wititsirgan. Tsaynö witiscatsirmi rumi jananman jamaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angelga imayca illagonöragmi chipacyargan. Llatapanpis yurag jancanöragmi atsicyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tsay angelta ricaycurmi soldäducunapis, alläpa mantsacarnin carcariarrag wañushganö ticrasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tsaymi tsay angel warmicunata nirgan: “Ama mantsacäyaytsu. Musyämi crucificäyangan Señor Jesucristota ashirnin shayämungayquita. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mananam caychönatsu caycan. Cawamushganam quiquin ningannölla. Masqui shayämuy, maychö pamparangantapis ricäyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Canan saslla aywar discïpuluncunata willar caynö niyanqui: ‘Wañunganpita cawascamurmi, gamcunapa mas puntayquicunata Galileaman aywaycan. Tsaychöshi paywan tincuyanqui.’ Tsayllatam canan gamcunata willayänag cargan.” ");
INSERT INTO qxnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tsaypitanam warmicunaga mantsacaynintinwan alläpa cushishga saslla cuticurnin cörrilla discïpuluncunata willag aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsaynö warmicuna aywaycäyaptinmi Señor Jesucristo puntancunaman illagpita yuripusquir saludargan. Tsaymi warmicuna witiycur chaquipita abrasarnin adorayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tsaynam Señor Jesucristo nirgan: “Ama mantsacäyaytsu. Canan aywar criyicur gatirämagnï waugëcunata willayay Galilea marcaman aywayänanpag. Tsaychömi paycuna tincurnin ricäyämanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tsaypita warmicuna aywayanganyagnam, täpagnin waquincag soldäducuna Jerusalénchö mandacug sacerdöticunaman aywayargan. Tsayman chaycurnam llapan imanö canganta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsaynö willasquiyaptinmi, templuchö mandacug sacerdöticuna israelcunapa autoridänincunaman parlag aywayargan. Tsaychö goricasquirnin imanö rurayänanpagpis yachatsinacur shumag willanacuyänanpag. Tsaynö willanacusquirmi soldäducunata atsca gellayta pägarnin, ");
INSERT INTO qxnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","alvertir niyargan: “Gamcuna niyanqui: ‘Puñucasquiyangäyagmi Señor Jesucristopa discïpuluncuna pagaspa shamuycur, pamparanganpita cuerpunta suwayashga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Si caynö päsanganta gobernador Pilato musyasquiptinga, nogacunam shumag entenditsir parlapäyäshag mana imatapis rurayäshunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tsay gellayta chasquisquirmi soldäducuna aywar, mandacug sacerdöticuna niyangannölla runacunata llullatsir willayargan. Tsaymi asta cananyagpis cayta parlayangannölla judiucunaga, “Señor Jesucristopa cuerpuntaga discïpuluncunam suwayashga” niyan. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tsaypitanam chunca juc discïpuluncuna Galileaman aywayargan Señor Jesucristo “Ayway” ningan jircaman. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tsaychö Señor Jesucristota ricasquirmi adorayargan, waquincagcuna mana criyignö caycäyaptinpis. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Señor Jesucristonam paycuna caycäyanganman witiycur nirgan: “Quiquin Dios Yayam llapan mandacuy poderninta entregamashga, cieluchöwan cay patsachöpis mandacunäpag. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tsaymi gamcunata mandayag maytsay naciuncunapa aywar, nogapa discïpulucuna cayänanpag yachatsicurnin puriyänayquipag. Tsaynö rasumpa nogaman firmi criyicugcunata bautizayanqui Dios Yayapa, Dios Tsuripa, Espïritu Santopa shutinchö. ");
INSERT INTO qxnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tsaynö yachatsicuyanqui llapan mandayangagcunata casurnin cumpliyänanpag. Tsaymi nogapitaga imayyagpis gamcunawan caycäshag, asta cay mundu ushacanganyag.”");
INSERT INTO qxnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cananmi willayäshayqui Dios Yayapa Tsurin Jesucristo gallarinanpita alläpa cushicuypag imaycacuna rurangancunatawan Alli Willacuynincunata. Tsayga caynömi cargan: ");
INSERT INTO qxnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dios Yaya ninganta parlag Isaías gellganganchömi Tsurinpag Dios Yaya nirgan: “Juc runataragmi gampa puntayquita cachashag. Paymi llapan runacunata willacunga chänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tsunyacunachö purirmi willacur ninga: ‘Dios Yayapa Tsurin chämunanpag imayca nänita limpiar derecharnin allitsagnö mana alli rurayniquicunata dëjasquir alistacuyay.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tsaynömi Juan Bautista niyangan runa tsunyacunachö purir, runacunata yachatsirgan bautizacuyänanpag. Tsaymi willacur nirgan: “Jutsayquicunata dëjasquir, Dios Yayaman cutir bautizacuyay perdonayäshunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsaynam Jerusalénpitawan maytsay Judea provinciapita Juan Bautistaman atscag runacuna aywayargan. Llapan runacuna jutsancunata willayaptinmi, Jordan mayuchö bautizargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanpa llatapanga “camëllopa” millwanpita awashga y wachucunmi garanpita rurashga cargan. Micuyninam chucloscunawan tsunyacunachö taringan orongoypa mishquincunalla cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tsaynömi runacunata yachatsir nirgan: “Ichicllanam faltaycan Dios Yayapa Tsurin chämunanpag, Payga alläpa poderösom nogapitaga. Manam nogaga Paypa llangenpa watunta umpuycur pascanällapagpis servïtsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nogaga yacullawanmi bautizayargog. Pero Payga Espïritu Santota garayäshurniquim bautizayäshunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tsay watam Nazaret de Galilea marcapita, Señor Jesucristo shamuptin Jordan mayuchö Juan bautizargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tsaynö bautizasquiptin Señor Jesucristo yacupita yargaycämuptinmi, cielu quichacasquiptin imayca juc palomanö Espïritu Santo urämur Payman rataycagta ricasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Cielupitanam Dios Yaya nimurgan: “Gammi cuyay Tsurï canqui. Gamtam quiquï acrashcä cushitsimänayquipag” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsaypitanam Señor Jesucristota Espïritu Santo tsunyaman pushargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tsay tsunyachömi chuscu chunca junag chucaru wätacunawan täcurgan. Tsaymi Satanas tentarnin engañar tucuyläyapa Señor Jesucristota pantatsiyta munargan. Pero cielupita angelcuna shamurmi, Señor Jesucristotaga serviyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tsaypitanam Juan bautistata carcelman rey Herodes gaycascatsiptin, Señor Jesucristo Galilea marcaman aywargan. Dios Yayapa Mandacuy Reynonpa Alli Willacuyninta canganta yachatsicurmi, ");
INSERT INTO qxnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nirgan: “Chämushganam Dios Yaya ningan tiempu gallananpag. Tsaynöllam chaycämunna Dios Yayapa mushogcag Mandacuy Reynon. Tsayraycu jutsayquicunata dëjasquir, Dios Yayapa Alli Willacuyninman mas firmi criyicuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Señor Jesucristo Galilea niyangan gocha cuchunpa aywaycarmi tarirgan, pescädo achcug runacunata Simón Pedrotawan waugen Andrésta ataräyata yacuman jitaycäyagta. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paycunatam nirgan: “Shamur gatiyämay. Cananyagmi pescädo achcug cayargoyqui. Pero cananpitaga imayca pescädota achcuyangayquinömi, nogaman runacunata goriyämunqui criyicayämunanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsaynö niptinnam, jina öra ataräyancunatapis dëjasquir Señor Jesucristota gatircur aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsaypita aywarnin mas washapa päsarnam Señor Jesucristo Zebedeopa tsurincuna Santiagotawan Juan büquichö atarayancunata allitsaycäyagta tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsaynam ishcan waugeta Señor Jesucristo gayargan. Paycunanam taytan Zebedeotawan arupucug runancunata büquichö dëjasquir, jina öra Señor Jesucristota gatircur aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tsaypitanam Capernaum marcaman aywayargan. Sabado jamay junag judiucunapa goricäyänan wajiman Señor Jesucristo aywarmi, tsaychö yachatsicur gallarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pero Señor Jesucristoga manam tsay ley yachatsicugcunanötsu yachatsicurgan. Sinöga alläpa poderöso yachag cayninwan yachatsicuptinmi, runacunapis niyargan: “¡Imaläya shumagmi parlan!” nir, mantsacashga ricaräyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsay wajichönam juc runa supayyog caycargan. Tsay runatam supay gayarätsir nitsirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Au, Jesús Nazaret runa ¿Imananquitan nogacunawan? ¿Ushacätsiyämagnïcu shamurgoyqui? Nogaga musyämi gam Dios Yayapa Santo Tsurin cangayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsaynö niptinnam supayta nirgan: “¡Cay runapita upälla yargoy!” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Supaynam mantsacaypag runata tapsitsirnin, gayararrag yargorgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Llapan runacunanam mantsacashga ninacuyargan: “¿Imanötan cayga? Manam ni imaypis cay runa yachatsicungantanöga wiyashgatsu cantsic. ¡Payga poderösom! Supaycunapis mandangantam rurayan” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tsaynöllam Galilea llapan marcacunachö Señor Jesucristo imanö canganta llapan runacuna musyayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsaypitanam Señor Jesucristo Dios Yayaman mañacuna wajipita yargosquir, Santiagowan y Juanwan aywar, Simónpawan Andréspa wajinman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tsaychönam Simónpa suegran fiebrewan geshyar, cämachö ujuraycagta tarirgan. Tsayman Señor Jesucristo chaycuptinnam, Pedropa suegran geshyaycanganta willayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Señor Jesucristonam witiycur, maquinpita achcurcur sharcatsirgan. Tsaymi jina öra fiebrenpita tsay warmi cuticasquir, paycunata servimuyta gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tsaypitanam rupay jegaycaptinna Señor Jesucristoman atscag geshyagyashacunatawan supayyogcunatapis apayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tsay wajipa puncunmanmi maytsay marcapita runacuna goricäyashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tucuyläya geshyagyashacunata Señor Jesucristo cuticätsirmi, supayyog runacunapitapis supaycunata gargorgan. Pero Dios Yayapa Tsurin canganta musyayaptinmi, supaycunata Señor Jesucristo nirgan: “Ama imatapis parlayaytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Manarag patsa warämuptin tutapayllaragmi Señor Jesucristo shäricusquir, tsunyaman aywarnin Dios Yayaman mañacurgan. Tsaypita patsa warasquiptinnam, ");
INSERT INTO qxnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón Pedro yanagencunawan Señor Jesucristota ashig aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tarisquirnam niyargan: “Llapan runacunam ashiycäyäshunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsaynam Señor Jesucristo nirgan: “Cananga juclä marcacunapanam aywashun. Tsay marcacunachöpis yachatsicunäpagmi cay patsaman shamushcä.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsaynam maytsay Galilea marcacunapa aywar, Dios Yayaman mañacuyänan wajicunachö yachatsicur, supayyog runacunapitapis supaycunata gargorgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tsaychönam wicuwan melanaypag geshyagyasha runa chaycur, gongorpacuycur Señor Jesucristota nirgan: “Taytay, voluntäniqui captinga melanaypag mana canäpag limpiar cuticaycatsillämay” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tsaynam Señor Jesucristo alläpa llaquiparnin, runata maquinwan yataycur nirgan: “Noga munämi. ¡Cananga limpiu cuticashga canayquita!” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsaymi jina öra wicu geshyaypita cuticasquir, sänu püru ticrasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Runatanam Señor Jesucristo alli alvertirnin nirgan: “Canan aywacurnin, ");
INSERT INTO qxnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ama ni pitapis willacunquitsu noga cuticätsingagta. Mas bien sacerdötiman ayway cuticashgana sänu cangayquita ricäshunayquipag. Tsaynölla Moisés mandacungan garayta Dios Yayapag apanqui, sänu püru cangayquita musyayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero tsay runa aywacurnam, Señor Jesucristo ninganta mana cäsurnin, llapan runacunata willargan pï cuticatsinganta. Tsaynö maytsaychö llapan runacuna musyasquiyaptinmi, tsay marcacunaman Señor Jesucristo yaycuyta puedirgannatsu. Tsaymi tsunyacunallachöna puriptinpis, maytsaypita runacuna Payman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsaypitanam payga ishcay quimsa junagta Capernaum marcaman Señor Jesucristo cutiycuptin, runacuna musyasquiyargan wajiman chämunganta. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Caycangan wajimannam maytsicag runacuna goricar waji junta puncuchöpis tsayläya quichqui cayargan. Señor Jesucristonam yachatsicuycargan Dios Yayapa Alli Willacuyninta. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsaynö caycaptinnam chuscug runacuna chäyargan mana purig invälidu runata wintushga. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Runacuna alläpa quichqui cayaptinmi, Señor Jesucristopa puntanman yaycatsiyta mana puedir, waji jananpa lätarcur waji gatashgata pascasquirnin tsayllapa inväliduta tsacrancantinta Señor Jesucristopa puntanman cacharpuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tsaynö rurayaptinnam payman rasumpa criyicuyanganta musyasquir, inväliduta nirgan: “Ïju, jutsayquipitam perdonag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tsaynö Señor Jesucristo niptinnam, ley yachatsicugna wiyar, shongoncunallachö niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Cay runaga ¡Imanirrag tsaynö parlan! Tsaynö parlarga Diostucuycanmi. Dios Yayallam runacunataga jutsancunapita perdonan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsaynö yarpäyanganta Señor Jesucristo musyasquirnam nirgan: “Gamcuna ¿Imanirtan shongoyquicunachö mana allicunata yarpäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Imatan mas fäcil cay geshyagyasha runata ninäpag: ‘Jutsayquitam perdonag’ ningäcu? o ‘¿Cuticashganam canqui; gopiquita aparcur aywacuy’ ningäcu? ");
INSERT INTO qxnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero musyayänayquipag Dios Yayapa Tsurin caynïwan poderösom cä, runacunata jutsa rurayanganta perdonanäpag, canan gamcunata ricätsiyäshayquim cay runata cuticätsir.” Tsaymi runata Señor Jesucristo nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Gamtam nig. Sänunam canqui. Sharcur, tsacrancayquita apacurcur wajiquipa aywacuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsaynö niptinmi jina öra runa sharcur, llapan ricäraycayaptin tsacrancanta gorisquir aparicurcur wajinpa aywacurgan. Tsayta ricaycurnam runacuna cushicur niyargan: “Dios Yayaga alläpa poderösom. Manam ni imaypis cay rurangantanöga ricashgatsu cantsic.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsaypitanam Señor Jesucristo gocha cuchunman yapay aywargan. Tsaychömi atscag runacuna goricäyaptin yapay yachatsicur gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Contribucion pägacuyänan waji lädunpa Señor Jesucristo päsaycarnam, Alfeopa tsurin Leví niyangan rurichö jamaycagta ricargan. Tsaymi Señor Jesucristo nirgan: “Shamur gatimay discïpulü canayquipag.” Levínam sharcur Señor Jesucristota gatircur aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsaypitanam Levípa wajinman Señor Jesucristo discïpuluncunawan aywayargan. Tsaychönam tucuyläya jutsasapacunawan Levípa contribucion cobragmajincunawanpis llapan atscag gatimugnin runacunawanpis micupacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsaynam tsay runacunawan micuycagta ley yachatsicug fariseocuna ricaycurnin, Señor Jesucristopa discïpuluncunata niyargan: “Manam allinötsu maestruyquicunaga cay contribucion cobragcunawan y tucuyläya jutsasapacunawan micungan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Señor Jesucristonam tsaynö niyanganta wiyarnin nirgan: “Geshyagyashacunatam mëdicowan jampitsiyan, manam sänucagcunatatsu. Tsaynömi nogaga jutsasapacunata ashignin cay patsaman shamushcä, manam allicagcunata ashignintsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutinam Juan Bautistapa discïpuluncunawan fariseocuna ayunaycäyargan. Tsaymi runacunana Señor Jesucristoman aywaycur tapur niyargan: “Juanpa discïpuluncunawan fariseocunam ayunaycäyan, pero gampa discïpuluyquicunaga ¿Imanirtan ayunayantsu?” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Señor Jesucristonam nirgan: “¿Acäsu casamientuman convidashgacunaga ayunayancu, noviowan pagta cushishga micupacur caycar? Manam ayunayantsu noviowan cushishga pagta caycarga. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero tsaypita casaracug illasquiptinmi sïga, paycunapis rasumpa ayunayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsaypitanam nirgan: “Manam macwa llatapata mushog tëlawan remendantsictsu. Tsaynö rurashgaga mushog tëla gentirmi macwacag llatapata mas peor rachisquinman. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsayrag rurashga aswataga manam macwa mana servig puyñumanga jirpuntsictsu. Tsaynö rurashgaga aswa pogornin, macwa mana servig puyñutaga paquiscatsinmanmi. Tsaymi puyñuntin aswapis jancat ushacasquiyanman. Tsaymi tsayrag rurashga aswataga mushog alli puyñuman jirpuntsic.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juc jamay junagchönam Señor Jesucristo discïpuluncunawan trïgu murushgacuna rurinpa aywaycäyargan. Tsaychönam discïpuluncuna trïguta quiptun quiptun uchuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tsaymi fariseocuna Señor Jesucristota niyargan: “Leynintsicga manam permïtintsu jamay junagchö tsaynö discïpuluyquicuna rurayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tsaynam Señor Jesucristo nirgan: “¿Diospa Palabranta manacu liyiyashcanqui? Unay rey Davidmi yanagencunawan puriycar, mana millcapancuna captin mallagäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tsayga Abiatar niyangan runa mayor sacerdöti caycangan watachömi cargan. Davidnam Dios Yayata adorayänan wajiman yaycusquir. Dios Yayapa puntanman churashga sagrado tantata aptarcur micurgan y yanagencunatapis garargan. Leynintsiccuna mandangannöga sacerdöticunallam tsay tantataga micuyan. Manam permïtintsu ni Davidta ni yanagencunapis micuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Tsay cuentanöllam jamay junagchö trïguta quiptur uchurnin, discïpulucunapis ni ima mana allitatsu ruraycäyan. Dios Yayam yachatsicurgan semänachö juc junag jamaycur runacuna mas cushishga cawacuyänanpag. Manam runacuna sufriyänanpagtsu tsaynö Dios Yaya dispönirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tsaymi noga, Dios Yayapa Tsurin caynïwan mandacü, jamay junagchöpis runacuna imata rurayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tsaypitanam yapay judiucuna goricäyänan wajiman Señor Jesucristo aywargan. Tsaychömi juc runa tsaquishga ricrayog cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tsaynam fariseocuna Señor Jesucristo rurananta gawararnin acusayänanpag quiquincunallachö niyargan: “Mä ¿canan jamay junagchö cay runata cuticätsingacush? Cuticätsiptinga autoridänintsiccunaman quëjacurmi acusashun.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tsay ricran tsaquishga runatanam Señor Jesucristo nirgan: “Sharcur, cay puntaman ichiy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tsaypitanam fariseocunata Señor Jesucristo tapurgan: “Leynintsicga ¿imanötan mandacun? Jamay junagchö ¿allita rurashwancu o manacu? Caynö geshyaycag runata ¿cuticatsishwancu o wañunaycaptinpis ricäraycashwanllacu?” Pero paycunaga upällallam cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tsaynö mana llaquicug chucru shongo cayaptinmi, Señor Jesucristo piñacurnin alläpa llaquipar runata nirgan: “Maquiquita lamcamuy.” Tsaynam runa maquinta lamcasquiptinnam jancat cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsaynam fariseocuna goricäyangan wajipita yargosquir rey Herodespa gatiragnincuna yachatsinacuyargan Señor Jesucristota imaycanöllapis wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tsaypita yargosquirnam Señor Jesucristo discïpuluncunawan gocha cuchunman aywayargan. Tsaymannam alläpa atscag runacuna Galileapita shayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tsaynöllam geshyagyashacunata cuticätsir, atsca milagrucuna ruranganta musyasquir Judeapita, Jerusalénpita, Idumeapita, Jordan mayu wac tsimpancunapita, Tiropita, Sidonpitapis shayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsaymi Señor Jesucristo discïpuluncunata nirgan: “Caytsicag runacuna quichquinacur mana llapiyämänanpag büquita apayämuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Alläpa atscag geshyagyashacunata cuticätsishga captinmi, Señor Jesucristota yatayta munarnin, waquincag geshyagyashacunapis quichquinacurrag goricayashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tsaychö Señor Jesucristota supayyog runacuna ricarmi, puntanman gongoricuypa ishquiyaptin shimincunapa supaycunapis gayaraypanö niyargan: “Gamga Diospa rasumpa Tsurinmi canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Señor Jesucristonam supaycunata piñaparnin mandargan: “Pï cangätapis ama willacuyaytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsaypitanam jircaman Señor Jesucristo witsarcur, munangancag runacunata acrananpag gayargan. Tsay runacunanam payman shayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tsay jircachö chunca ishcagta acrasquirmi, apostolnincuna churar nirgan: “Cananpitaga nogawan purirmi, maytsaypa aywarnin noga willacungäta yachatsicuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Podernïwanmi supayyog löcucunapitapis supaycunata gargoyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tsay chunca ishcay acrangan runacunam cayargan: Simón. Pero Señor Jesucristom shutin churargan “Pedrota.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeopa tsurincuna Santiagowan Juan. Paycunapa shutincunam Señor Jesucristo churargan “Boanerges.” “Boanerges” ninanga cunrurunö alläpa gayarag runacuna ninanmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés Felipe Bartolome Mateo Tomas Alfeopa tsurin Santiago Tadeo Cananista niyangan Simón ");
INSERT INTO qxnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Judás Iscariote. Paymi Señor Jesucristota traicionarnin chiquignincunaman ranticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsaypitanam discïpuluncunawan Señor Jesucristo yapay juc wajiman yaycuyargan. Tsaychönam atsca runacuna goricäyaptin manam ni micuyllatapis puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tsaynö maytsicag runacuna goricäyanganta aylluncuna musyasquirmi, Señor Jesucristoman aywaycur niyargan: “Señor Jesucristoga löcum ticrashga, wajintsicpa apacushun.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tsaynöllam Jerusalénpita ley yachatsicugcunapis shayämurnin niyargan: “¡Cay runaga Beelzebúyogmi! Tsay ‘Beelzebúga’ llapan supaycunapa poderöso mandagninmi. Tsaymi supaycunatapis runacunapita gargon.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsaynö niyaptinmi Señor Jesucristo ley yachatsicugcunata gayasquir, ejempluwan entenditsirnin nirgan: “¡Imanörag supay pura gargonacuyanman! ");
INSERT INTO qxnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si juc jatun marcachö runacuna quiquincuna pura chiquinacurga, tsay runacunaga wañutsinacurmi ushacätsinacuyanman. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tsaynöllam juc wajichö täcugcunapis quiquincuna pura chiquinacurga, tsay familia raquicarnin ushacasquiyanman. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tsay cuentanöllam supaycunata Satanas gargorga, quiquinpa mandacuy poderninta ushacascatsinman. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Masqui juc alli callpayog runa catsun. Tsaymi pipis wajinta suwayta munarga, puntatam tsay runatarag alli chachac watanman. Tsaynö watasquiragmi wajinman yaycusquir imaycancunatapis suwanman. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Rasuntam niyag: Dios Yayam runacunata perdonanga paypa contran parlar imayca mana allicunata rurayaptinpis. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero pipis Espïritu Santopa contran parlarga mananam ni imaypis cieluchö Dios Yayäpa perdonninta tariyanganatsu. Tsay runaga imaypis jutsancunallachö caycarmi, condenacar infiernuman aywanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tsay ley yachatsicugcuna: “Payga supayyogmi” niyashga captinmi, Señor Jesucristo tsaynö nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsaychö caycanganmannam Señor Jesucristopa mamanwan waugencuna chäyargan. Quichqui cayaptinmi wagtallapita gayatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lädunchö atscag jamaycag runacunanam Señor Jesucristota niyargan: “Au Maestru, wagtachömi mamayquiwan waugeyquicuna ashiyäshunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Señor Jesucristonam nirgan: “¿Pitan mamäwan waugëcuna cayan?” ");
INSERT INTO qxnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsaypitanam Señor Jesucristo lädunchö jamaycagcunata apuntarnin nirgan: “Cay puntächö caycagcunam mamäwan waugëcunaga cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tsaynöllam Dios Yaya mandacungancunata rasumpa cäsucur cumpligcuna nogapa waugëwan panï y mamäga cayan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Juc cutinam Galilea gocha cuchunchö Señor Jesucristo yachatsicuycanganman alläpa atscag runacuna goricäyargan. Tsaychö alläpa quichqui cayaptinnam büquiman lätarcur jamargan. Tsay maytsicag runacunanam gocha cuchunllachö caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsaymi Señor Jesucristo tucuyläya iwalatsicuy ejemplucunawan yachatsicurnin entenditsicur nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“¡Shumag wiyayay cay niyangagta! Juc runam murucug aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tsaymi chacraman trïguta magtsiptin, waquincag murucuna näniman shicwayargan. Tsay näniman shicwag murucunatanam pishgocuna shamur upshasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tsaynöllam waquincag murucunapis ranracuna janaman shicwayargan. Tsaychö ichiclla allpa captinmi, saslla jegascayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero mana alli jawan captinmi, rupay alläpa achaptin saslla tsaquisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquincag murucunanam cashacuna rurinman shicwayargan. Cashacuna wiñarnin pasaypa tsapasquiyaptinnam, mana ni juc wayuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquincag murucunanam alli allpaman shicwayargan. Tsaymi tsay alli allpachöga allish jegascamur wiñar pogornin, cada espïgachö quimsa chunca (30), sogta chunca (60) o juc pachac (100) gränuyag wayurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Canan willayangagta wiyarnin shumag entendicuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tsaypita llapan runacuna aywacuyaptinnam, Señor Jesucristota discïpuluncunawan waquincag gatiragnincuna tapuyargan: “Taytay, tsay yachatsicungayquiga ¿Ima ninantan?” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Señor Jesucristonam nirgan: “Gamcunataga Dios Yayam entenditsiyäshunqui Mandacuy Reynon imanö canganta. Pero tsaynö iwalatsicur ejempluncunawan yachatsicuptïmi, nogaman mana criyicug runacunaga entendiyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Tsay mana rasumpa criyicug runacunaga rurangäcunata ricaycarpis manam criyiyangatsu. Ni willacungäcunata wiyaycarpis manam entendiyangatsu. ¡Tsaytsurag jutsancunata dëjasquir, Dios Yayaman rasumpa firmi criyicuyanga Pay perdonananpag!’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Señor Jesucristonam nirgan: “¿Gamcunapis manacu iwalatsicuy ejempluwan willacungäta entendiyanqui? Tsaynö mana enterdirga ¿imanörag waquincag iwalatsicuypa yachatsiyangagtapis entendiyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Canan willayäshayqui. Imayca trïguta magtsignömi Diospa Palabranta willacuyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pero waquinga näniman muru shicwag cuentanö carmi, Diospa Palabrantaga wiyayanlla. Pero Satanas shamurnam Diospa Palabran wiyangantapis pasaypa gongascatsinga, shongoncunachö manana quëdananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waquincag runacunanam imayca ranraman muru shicwashganö car, Diospa Palabranta wiyarnin saslla alläpa cushishga criyiyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero imayca achaywan mana alli jawayog planta tsaquignömi pruebacuna shamuptin runamajincuna chiquiyaptin aburir, Diospa Palabranman manana criyir dëjasquiyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tsaynöllam waquincag runacunapis imayca casha rurinman muru shicwashganö car, Diospa Palabranta wiyacuyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero tsaynö wiyacuycarmi micuyänanpagwan shucucuyänanpag y imaycacunapag yarpachacurnin rïcuyar imaycatapis munapar mas ayrajäyan. Tsaymi tsay runaga imayca cashacuna rurinchö tsapacashga espïganö Diospa Palabranta mana wiyacurnin, Diosman manana criyir paypagga ni imatapis rurayannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero waquincag runacunanam imayca alli allpaman muru shicwashganö Diospa Palabranta wiyarnin, payman rasumpa mas firmi criyicurnin imaycatapis mas allicunallata rurayan. Tsaymi imayca espïgachö quimsa chuncayag (30), sogta chuncayag (60) y pachacyag (100) wayug gränunö cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","“¿Actsita sendircurga Acäsu mancapa rurinmancu o cawitupa gopinmancu churantsic? Manam. Mas bienmi altuman churantsic alli atsicyämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tsaynöllam canan mana musyayanganta waraycuna musyayanga y noga yachatsicungäta canan mana entendirga waraynam entendiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wiyagcagga shumag entendicuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Willacungäta wiyagcagga shumag cäsucuyay. Quiquiquicuna atscata o wallcallatapis garacuyangayquinöllam quiquin Dios Yayapitapis chasquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsaymi mas wiyacuy munagcagcunataga mas yanapanga. Pero mana wiyacuy munagcagtam sïga, ichic wiyangantapis jancat gongascatsinga. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","“Imayca chacrachö juc runa murucungannömi Dios Yayapa Mandacuy Reynonga. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tsaynöllam chacranchö murusquir wajinman runa cutiycur pagaspa puñun y junagpanam arun. Tsaymi chacranchö murunga jegamur allish wiñan. Pero manam musyantsu ni imanö wiñangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Murusquishgaga jegamurmi quiquillan wiñarnin espigar pogon. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tsaynö trïgu pogosquiptinnam, cosëcha quillachöga chacraman runa aywarnin sëgar gorin. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Dios Yayapa Mandacuy Reynon imanö canganta musyayänayquipagmi cay ejempluwan iwalatsicur yachatsiyäshayqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dios Yayapa Mandacuy Reynonga imayca mostäza jachapa murunnömi. Tsay muruga llapanpitapis mas ichicllam. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tsaynö ichiclla caycarpis murusquishgaga jegamur, llapan gorapitapis mas jatunmi wiñan. Tsaymi rämancunamanpis pishgocuna llantucuyänanpag ratag aywayan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tsaynö ejemplucunawan runacunata yachatsicurmi, Diospa Palabranta shumag entendiyänanpagcagllata willacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Señor Jesucristo discïpuluncunallawan caycarnam, paycunallata llapan yachatsicungancunata esplicarnin entenditsirgan. Pero waquincag runacunataga ejempluwan yachatsinganpita mastaga mananam ni imatapis esplicargannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsayman atscag runacuna juntapuyaptinmi, discïpuluncunata Señor Jesucristo nirgan: “Gocha wac tsimpanman päsashun.” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Señor Jesucristo caycangan büquiman discïpuluncuna lätarcuyaptinnam runacunata gocha cuchunchö jagesquir aywacuyargan. Juccag büquicunanam waquincag runacunawan pagtan aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsaymi gocha pullanta aywaycäyaptin, llutaypa wayrämur lamar yacuta alläpa mantsacaypag lagchicätsirgan. Tsay büquiman yacu wiñacaptinnam, tallpucayta gallaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Büquipa gepa cuchunchönam Señor Jesucristo jaunachö puñucashga caycargan. Discïpuluncunanam ricchatsirnin niyargan: “¡Maestru! ¿Manacu imapis gocushunqui tallpucaycantsicnam?” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsaypitanam Señor Jesucristo sharcurnin piñapar nirgan: “Amana wayraynatsu ni yacupis lagchicaynatsu.” Tsaymi jina öra wayra parasquirgan ni gochapis lagchicargannatsu shumag tsunyacasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tsaypitanam discïpuluncunata nirgan: “¿Imanirtan mantsacashga caycäyanqui? ¿Manacu nogaman rasumpa firmi criyicuyanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero discïpuluncunanam quiquincuna pura alläpa mantsacashga ninacuyargan: “¿Cayga imanö runatan, tsayläya wayrawan gochachö yacupis Pay mandanganta cäsuyänanpagga?” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tsaypitanam gochapa wac tsimpanman päsasarnin Señor Jesucristo discïpuluncunawan Gerasa niyangan marcaman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Señor Jesucristo büquipita yargosquiptinnam panteonchö pärag supayyog runa tincupämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tsay runaga panteonllachö päracur captinmi ni pipis tsarayta ni cadenawan watarpis puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Atsca cutim cadenacunawan paypa chaquintawan maquintapis runacuna watäyargan. Pero tsay supayyog runaga cadenacunatapis ichic ichic jancat rachicachaptinmi ni pï imanaytapis puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tsay runaga pagaspa junagpapis alläpa gayararnin purirmi, rumicunawan quiquillan rogocurnin jircacunachöwan panteoncunallachö pärargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tsay supayyog runam Señor Jesucristota carupita ricasquirnin, cörrilla shamurnin puntanman gongoricurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tsaymi runapa shiminpa supay gayaraypanörag nirgan: “Poderöso Diospa Tsurin Jesús ¿Imatatan nogawan munanqui? ¡Gamtam Diospagraycu rugag, cay runapita gargamarnï sufritsimar mana condenamänayquipag!” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Señor Jesucristonam nirgan: “Cay runapita yargoy” nishgana captinmi supay tsaynö rugargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsaynam supayta Señor Jesucristo tapurgan: “¿Imatan shutiqui?” Supaynam nirgan: “Maytsicag cayaptïmi nogapa shutï ‘Sogta warangacuna (6,000).’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Supaynam yapay yapay Señor Jesucristota rugarnin nirgan: “Ama nogacunata caru marcacunamanga gargaycayällämaytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tsaypita mas washanin jircachömi atsca cuchicunata mitsiycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Supaycunanam Señor Jesucristota rugarnin niyargan: “Cachaycayällämay tagay jircachö cuchicunaman yaycucuycuyänäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Señor Jesucristo “Allim” niptinnam, runapita yargosquir cuchicunaman aywarnin yaycuyargan. Tsaychö cuchicunaga ishcay waranganömi cayargan. Tsaynö maytsicag yaycusquiyaptinnam, cuchicuna löcuyarnin acataycachar gochaman jegarpur, tsaychö shingarnin llapan wañusquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tsay cuchi mitsicug runacunanam maytsay estanciacunapa y marcancunapa aywarnin llapan ricäyanganta willacuyargan. Tsaynö willacuyaptinnam runacuna shayämurgan: “Mä, ricäshun. Imash cashga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Señor Jesucristo caycanganman chaycurnam, tsay supayyog runa jancat cuticasquir yamayna llatapashga shumag juiciunchöna caycagta ricäyargan. Tsaynöta ricarmi runacunapis alläpa mantsacashga caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tsaymi Señor Jesucristo supayyog runata cuticätsingantawan cuchicuna gochaman jegagta ricäyangantapis willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsaynö mantsacashga carmi, runacuna Señor Jesucristota rugarnin niyargan: “Taytay, cay marcalläcunapita aywacuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tsaypita Señor Jesucristo büquiman lätarcuptinnam, tsay cuticashga runa rugarnin nirgan: “Gamwan aywacuytam munallä. Pushacällamay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tsaynö niptinnam Señor Jesucristo mana änirnin nirgan: “Mas bien canan wajiquiman ayway cutiycur aylluyquicunata willay Dios Yaya cuyashurniqui cuticätsishungayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsay cuticashga runa cuticurninnam llapan Decapolis niyangan marcacunapa purirgan Señor Jesucristo cuyaparnin cuticätsinganta willacur. Tsaynö willacuptinmi, llapan runacuna alläpa mantsacashganö cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsaypitannam wac tsimpaman büquiwan Señor Jesucristo chaycur gocha cuchunllachörag caycaptin, maytsicag llutaypa runacuna goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsaymannam israelcuna goricäyänan wajichö mandacug Jairo shutiyog runa chargan. Tsaychö Señor Jesucristota ricaycurnam puntanman gongoricuycur, ");
INSERT INTO qxnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","rugarnin nirgan: “Warmi wamrallämi wañuycanna, acu jina öra wajïpa aywayculläshun. Payman maquillayquita churaycuptiquiga geshyayninpita cuticasquirmi cawangarag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tsaynö niptinmi, Señor Jesucristo runawan aywayaptin maytsicag runacuna quichquinacurrag gepanta gatirnincuna aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tsay maytsicag runacunapa rurinchömi chunca ishcay watantinna yawar apaywan juc geshyagyasha warmi aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atscag mëdicocunawan jampitsicurnin llapan imaycantapis ranticur mana ni ima servigllam gastargan. Tsaynö gastacurnin jampitsicurpis cada vez masmi mas antsana cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tsaymi geshyagyashacunata Señor Jesucristo cuticatsinganta wiyarnin, atscag runacunapa rurinllapa Señor Jesucristopa gepa llatapanta yataycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tsay warmi shongollanchö yarparmi nirgan: “Llatapanllatapis yataycurga jancatmi cuticasquishag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tsaynö yarparnin yataycurnam, yawar apaywan sufrir geshyagyasha canganpita patsa pärasquir libri cuticashgana canganta tantiyasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Poderninllawan geshyagyasha warmita cuticatsinganta Señor Jesucristo tantiyasquirnam, gepanchöcag runacunaman tumaycur tapurgan: “¿Pitan llatapäta yatamushga?” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pero discïpuluncunanam niyargan: “¡Maestru, caytsicag runachöga jucnin jucninpis tangayäshunquitsag! Gamga tapucunqui: ‘¿Pitan llatapäta yatamushga?’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsaynö niyaptinpis Señor Jesucristoga maytsaypa ricchacurgan, llatapanta pï yatanganta. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsay warminam cuticashga canganta tantiyasquir, mantsacaywan carcariarrag Señor Jesucristopa puntanman gongoricuycur llapanta willargan: “Taytay, nogallämi llatapayquipa puntanta yataycullargö.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Señor Jesucristonam nirgan: “Ïja, nogaman rasumpa firmi criyicungayquipitam cuticargoyqui. Cananga cushishga tranquïlona aywacuy, sufrirnin geshyangayquipita cuticashga librinam canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Señor Jesucristo tsaynö parlaycaptinmi, Jairopa servignincuna wajinpita shamurnin chaycur niyargan: “Tayta Jairo, wamrayquiga wañushganam. ¡Imapagnatan Señor Jesucristotapis wajiquiman afanacurnin pushanqui!” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tsayta wiyaycurnam Jairota Señor Jesucristo nirgan: “Ama mantsacaytsu. Nogallaman criyicamuyga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsaypitanam Jairopa wajinman Señor Jesucristo Pedrota, Santiagota y Santiagopa waugen Juanta pusharcur aywargan. Waquincagcuna gatiyänantaga manam munargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairopa wajinman chaycurnam wamra wañushgacaptin, atscag runacuna gayaraycachar wagapacuycäyagta tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Waji rurinman yaycusquirnam Señor Jesucristo nirgan: “¿Imanirtan cayläya timpullyarrag wagayanqui? Wamraga manam wañushgatsu. Puñucashgallam caycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tsaynö niptinnam runacuna asipäyargan. Tsaypitanam Señor Jesucristo llapan runacunata wagtaman gargosquir, quimsa discïpuluncunatawan wamrapa taytan y mamanta pusharcur wamra sutaraycanganman yaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsaychönam wamrapa maquinta achcurcur Señor Jesucristo parlaparnin “Talitá, cum” nirgan. (Tsayga: “Wamra, gamtam shärimuy nig” ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tsaynö niycuptinmi wamra jina öra cawascamur shärisquir puriyta gallaycurgan. Tsay wamraga chunca ishcay watayogmi cargan. Runacunanam niyargan: “¡Cayga alläpa mantsacaypagmi!” ");
INSERT INTO qxnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Señor Jesucristonam runacunata nirgan: “Pagtatag pitapis willacuyanquiman wamrata cawatsimungäta.” “Cananga pachan garayay” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tsaypita Señor Jesucristo discïpuluncunawan aywacurmi marcanman cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabado jamay junagchönam judiucuna goricäyänan wajichö yachatsicurgan. Yachatsicungata wiyarmi runacuna mantsacashga niyargan: “¡Cay runaga imanö shumagtam yachatsicun! ¡Caynö allish yachananpagga maychörag yachacushga! ¡Ima poderninwanrag geshyagyashacunata cuticätsirnin tucuyläya imayca milagrucunatapis ruran! ");
INSERT INTO qxnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manacu Payga carpinteropa tsurin y Maríapa wawan? Payga Santiagopa, Josépa, Judáspa y Simónpa waugenmi. Panincunapis cay marcachömi nogantsicnö täcuyan” nirnin. Tsaynö parlaycacharmi yachatsicungantapis cäsuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsaymi Señor Jesucristo runacuna niyangannölla nirgan: “Maychöpis Dios Yayapa Palabranta willacug profëta willacungantam runacuna cäsuyan. Pero quiquinpa marcamajincunawan aylluncuna y wajinchöcagcunaga mana cäsurmi wiyayangatsu ni chasquiyangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsay marcanchö mana criyicuyanganpitam, juc ishcay geshyagyashacunallaman maquinta churarnin cuticätsirgan. Pero manam mas milagrucunataga rurargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Marcamajincunapagmi Señor Jesucristo nirgan: “¡Imanö alläpa llaquicuypagmi nogaman mana criyicuyangan!” Tsaypitanam Señor Jesucristo marcan marcan purir runacunata yachatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsaynö yachatsicurmi chunca ishcay discïpuluncunata gayasquir, ishcag ishcag aywayänanpag mandarnincuna nirgan: “Gamcuna canan aywar, supayyog runacunapita supaycunata podernïwan shutïchö gargoyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Gamcuna aywarga tucruyquicunalla apayanqui. Ama tantatawan alporjata ni gellaytapis apayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Shucurayangayqui llangeyquicunallawan y janayquicunachö llatapayquicunallawan aywayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pipis wajincunam pushar posadatsiyäshuptiquiga, tsay wajillachö cacuyanqui tsay marcapita aywacuyangayquiyag. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pero may marcaman chäyaptiquipis runacuna mana chasquiyäshuptiqui o yachatsicuyangayquita mana wiyayta munayaptinga; tsay marcapita aywacur chaquiquicunachö allpa lashtacashgatapis tapsicusquiyanqui. Tsaynö rurayangayqui señalgam canga Dios Yaya tsay runacunata castigananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsaypitanam discïpuluncuna maytsaypa aywarnin yachatsicur willacuyargan: “Jutsa rurayniquicunata dëjasquir llaquicurnin amana mastaga rurayaynatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tsaynöllam atsca cuti supayyog runacunapita supaycunata gargornin, geshyagyashacunatapis aceitiwan churar cuticätsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tsaypitanam alläpa alli ruraynincunapita Señor Jesucristo regeshga canganta rey Herodes musyasquir nirgan: “Payga Juan Bautistam wañunganpita cawamushga. Tsaymi poderöso cayninwan tucuyläya imayca milagrucunatapis ruraycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Runacunanam niyargan: “Payga Diospa unaycag profëtan Elíasmi” Waquincagcunanam niyargan: “Payga juc profëtam, unaycag profëtacunanöllam Dios Yayapa willacuyninta willacun.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tsayta rey Herodes musyasquirnam nirgan: “¡Payga umanta rogotsir wañutsitsingä Juan Bautistam wañunganpita cawamushga!” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodias warmi Juan Bautista chiquirnin Herodesta “Prësuy” niptinmi, rey Herodes cadenawan watarcatsir carcelman gaycatsishga cargan. Tsay gaycatsinganpita mas puntatanam rey Herodesga waugen Felipepa warmin Herodiaswan casarashga cargan. Tsaynöpam Juan Bautistaga paycunapa contran parlargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tsaynö waugenpa warmillanwan casaranganta musyasquirmi, Juan Baustista piñaparnin rey Herodesta nirgan: “Mana allitam ruraycanqui waugeyquipa warminta gechusquir quiquipawannö täcurnin.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tsay Herodias warminam Juan Bautistata chiquirnin wañutsiyta munarpis ni imanöpa puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Dios Yayapa profëtan alli rurag runa Juan canganta musyarmi, Herodes mantsar wañutsiyänanpita cuidarnin permïtirgantsu. Juan Bautista willacungancunata mana allipa entendiycarpis, rey Herodesga cushishgam imaypis wiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsaynö chiquir caycarmi juc junag tsay Herodias warmi munanganta tarirgan. Rey Herodesmi santun junagpag mandacuyninchö militarnincunatawan Galileachö mas mandacug runacunata wajinchö micuyänanpag gayatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Tsay santunchö Herodiaspa warmi wawan tushurmi, rey Herodestawan tsaychö llapan caycagcunata alläpa gustargan. Tsaymi alläpa cushishga tsay jipashta rey Herodes yapay yapay jurar nirgan: “Juracümi imayca mañamangayquitapis gamta garanagpag, asta cay mandacungä marcapa pullanta mañamaptiquipis.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsaynö niptinnam tsay jipashga saslla mamanman aywaycur tapurgan: “Mamay ¿Imatatan mañashag?” Tsaymi maman nirgan: “Juan Bautistapa umanta mañay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsaypitanam jipash rey Herodesman cörrilla cutiycur nirgan: “Canan jina öra Juanpa umanta apascatsimur plätuchö entregaycamay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tsaynö mañaptinmi rey Herodes alläpa llaquicurgan. Pero jurarnin äninganta tsaychö caycagcuna wiyayashga cayaptinmi, tsay jipash mañanganta nëgayta munargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tsaymi Herodes jina öra juc soldädunta mandargan, Juanpa umanta apamunanpag. Soldädunam carcelman aywaycur, Juanpa umanta rogosquir, ");
INSERT INTO qxnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","plätuchö apaycur jipashta entregargan. Tsay jipashnam mamanman apaycur entregargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsaypitanam Juanpa discïpuluncuna wañutsiyanganta musyasquir, aywarnin gorisquir ayanta pampacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tsaypitanam Señor Jesucristopa discïpuluncuna willacur puriyanganpita cutisquir, yachatsicuyangancunatawan rurayangancunata willayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tsayman maytsicag runacuna aywarnin cutimur goricäyaptinmi ni pachata micuytapis puediyargantsu. Tsaymi discïpuluncunata nirgan: “Acu tsunyaman aywashun, tsaychö jamaycuyänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsaynö nirmi büquiman lätarcur discïpuluncunawan aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero Señor Jesucristo aywaycagta ricasquirnam maytsay marcacunapita shamurnin llutaypa runacuna gocha cuchunpa llallipar puntanman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Señor Jesucristo büquipita yarpusquirnam, runacuna shuyaraycayagta ricaycur llaquipargan. Tsay runacunaga imayca mana mitsigninnag üshacunanömi llutaypa witsicashga caycäyargan. Tsaymi Señor Jesucristo tucuyläyacunata yachatsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tsaychö tardiyaycaptinnam discïpuluncuna Señor Jesucristoman witiycur niyargan: “Taytay, goyaycannam. Cay tsunyachöga manam ni pipis täcuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cay runacunata ‘Aywacuyay’ niyna, maytsay estanciacunapa aywayanganchö imallatapis tarirnin rantisquir micuyänanpag. Caychöga manam ni imapis cantsu micuyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Señor Jesucristonam nirgan: “Gamcuna micuynincuna garayay.” Discïpuluncunanam niyargan: “¡Caytsicag runacunapagga! ¿Ayca gellaywanrag tantatapis pagtatsiyäman? ¡Llapan micuyänanpagga pusag quilla arurnin gänangantsicragchi pagtanman! ¿Tsay llapan gellayta tantata rantirnin gastayänäta munanquicu? ¡Manam puediyätsu!” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Señor Jesucristonam tapurgan: “¿Ayca tantatan cayäpushunqui? Mä, averwayämuy.” Averwasquirnam niyargan: “Pitsga tantawan ishcay pescädollam can.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tsaypitanam Señor Jesucristo nirgan: “Pampaman grüpupa goricarnin llapan jamacuyätsun.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tsay ningannömi runacunaga pitsga chuncapa y pachacpa grüpuman juntacar jamacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tsaypitanam Señor Jesucristo tsay pitsga tantatawan ishcay pescädota achcurcur, cieluman ricarcurnin Dios Yayaman mañacurgan. Tsaynö mañacusquirnam tantata paquisquir discïpuluncunata macyargan runacunata aypuyänanpag. Tsaynöllam ishcay pescädotapis quipchusquir discïpuluncunata macyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsaymi tsaychö maytsicag runacuna llapan pachancuna junta micuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Llapan pachancuna junta micusquiyaptinnam sobrag tantatawan pescädota discïpuluncuna chunca ishcay (12) canastacunaparag goriyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tsay micug runacunam ollgocaglla cayargan pitsga waranga (5,000), warmicunatawan wamracunata mana yupaycäyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsaypitanam discïpuluncunata Señor Jesucristo nirgan: “Gamcuna büquiman lätarcur puntaycäyay wac tsimpa Betsaida marcaman.” Discïpuluncuna aywasquiyaptinnam Señor Jesucristo runacunata “Cuticuyayna” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tsaypitanam Señor Jesucristo Dios Yayaman mañacug jircaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Discïpuluncuna büquiwan gocha pullanta aywaycäyaptinnam, patsa tutapasquirgan. Señor Jesucristonam jircallachörag japallan caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gocha rurinchö büquita wayra puntapita tsaparaptinmi, discïpuluncuna avansayta mana puedir sufriyargan. Tsaynö sufriycayangantam Señor Jesucristoga musyargan. Madrugädu gällu cantangan öranam Señor Jesucristo discïpuluncunaman aywarnin, yacu janallanpa purirnin läduncunapa päsaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero discïpuluncunanam tsaynö yacu jananpa runa purigta ricasquir, alma canganta yarpar mantsacaywan gayarar: “¡Wau! ¿Imatan tagayga cacullan?” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tsaynö yacu jananpa aywaycagta ricasquirmi, discïpuluncuna alläpa mantsacashga cayargan. Señor Jesucristonam parlapargan: “Valorta achcuyay. Nogam cä. Ama mantsacäyaynatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsaynö büquiman lätarcuptinmi, jina öra tsayläya wayrapis parasquirgan. Discïpuluncunanam alläpa mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tsaynö atscag micuyänanpag milagru ruranganta ricashga caycarpis, Señor Jesucristo alläpa poderöso canganta discïpuluncuna manam ni imanöpa entendiyta puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tsaypitanam wac tsimpa Genesaret marcaman chaycur, büqui mana aywananpag gocha cuchunman wascawan watäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tsay büquipita yargosquiyaptinmi, Señor Jesucristota runacuna regesquir, ");
INSERT INTO qxnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","maytsaypa aywar waquincunatapis willayargan. Tsaynam Señor Jesucristo maychö canganta musyasquir, geshyagyashacunatapis tsacrancancunachö wintushga runacuna apayämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maytsay marcacunapawan estanciacunapa y mercädocunapawan jallga chacracunapa Señor Jesucristo aywaptinpis, paymanmi tucuyläya geshyagyashacunata chätsirnin rugar niyargan: “Cay geshyagyasha runalläcuna llatapayquillatapis yataycuyällätsun.” Pï geshyagyashapis Señor Jesucristopa llatapanta yataycurllam cuticargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tsaypitanam Jerusalénpita fariseocunawan ley yachatsicugcuna shamurnin, Señor Jesucristopa lädunchö shaycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsaychönam Señor Jesucristopa discïpuluncuna maquincunata mana mayllacur micuycagta ricarnin piñacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseocunaga llapan judiumajincunawanmi manarag micurnin maquincunata alli mayllacuyag. Tsaynö rurayänanpagmi yachatsicug awiluncuna yachatsishga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cällipita cutirpis maquincunata manarag mayllacurga manam micuyagtsu. Tsaynö atsca costumbrincuna captinmi, täsacunatawan järacunata y mancacunatapis limpiu caycaptinpis mayllayag. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tsaypitanam Señor Jesucristota fariseocunawan ley yachatsicugcuna tapurnin niyargan: “¿Imanirtan discïpuluyquicuna yachatsicug awilüntsiccunapa costumbrincunata mana cäsur, tsaynö tagra maquincunawan micuyan?” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Señor Jesucristonam nirgan: “Gamcunaga mana alli caycarmi, allitucuyanqui. Rasuntam gamcunapag Dios Yaya ninganta unay Isaías gellgargan: ‘Shimincunallawanmi nogata alabayäman. Pero shongoncunachöga manam yarpäyämanpistsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tsaynö nogata alabayämanganga manam ni imapagpis servintsu. Runacuna mandacuyangancunallatam paycunaga yachatsicuyan. Tsay yachatsicuycunaga runacunapa munayllanmi.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Dios Yaya mandacungancunata dëjasquir mana cäsurmi, runacunapa costumbrincunallata mas cumpliyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tsaynöllam nirgan: “¡Gamcunaga alläpa allishmi costumbriquicunallata rurar, Dios Yayapa mandacuynintaga dëjasquiyanqui! ");
INSERT INTO qxnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Quiquin Dios Yayam unay Moisésta cay mandacuyninta entregar nirgan: ‘Taytayquitawan mamayquita cuyayarnin respetar cäsunqui. Pipis taytanpagwan mamanpag mana allicunata contran parlaptinga, tsay runataga mejormi canman wañuscatsiyaptin.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero gamcunaga manam tsaynöga niyanquitsu. Mas bienmi yachatsicuyanqui juc runa mamantawan taytanta ninanpag: ‘Llapan imayca capamangantam Dios Yayata garaycushcä, tsaymi yanapayniquita puedïtsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tsaynö nirmi, tsay runa taytantawan mamanta manana yanapananpag michäcuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gamcunaga tsay unay costumbriquicunallata rurarmi Dios Yayapa Palabranta manacagman churaycäyanqui. Tsaymi Dios Yaya mandacunganta mana cäsurnin, tsaynö tucuyläya mana allicunata ruraycäyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tsaypitanam Señor Jesucristo runacunata yapay gayasquir yachatsirnincuna nirgan: “Parlamungäcunata llapayqui shumag wiyarnin entendir tantiyacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Runacunaga manam micuy micuyanganwantsu jutsasapa cayan. Sinöga shongoncunallachö mana allicunata yarparmi, jutsa ruragga cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Canan niyangagta wiyarnin shumag cäsucuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsaynö parlarnin ushasquir maytsicag runacunata dëjasquir waji rurinman yaycusquiptinnam discïpuluncuna tapuyargan: “Tsay yachatsicungayquiga ¿ima ninatan cargon?” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Señor Jesucristonam nirgan: “¿Gamcunapis manacu entendiyanqui? Runaga manam micungawantsu jutsasapa ticran. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Micuy micunganga runapa pachanman yaycurpis päsanllam, manam shongonmantsu yaycun.” (Tsaynö nirmi Señor Jesucristo llapan micuycunata micuyanganpis allilla canganta yachatsicurgan.) ");
INSERT INTO qxnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tsaypitanam Señor Jesucristo nirgan: “Runaga shongonchö mana allicunata yarparmi jutsasapaga cayan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Shongoncunachö mana allicunata yarparmi, casädo caycarpis jucnin jucninwanrag täcuyan, suwacuyan, wañutsinacuyan, warmicunapis lluta ollgocunawan puricuyan, ");
INSERT INTO qxnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","runacunapa imantapis munaparnin codiciar llutan imaycatapis rurayan, llullacuyan, viciuncunawanpis pengacuyantsu, juc runacunapa imanpis capuptin chiquicuyan, llullacurnin manacagta tumpacuyan, pengacuypag mana tantiyacurnin allishtucur licachaycachayan mana imapagpis serviycar y imayca jutsatapis rurayan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tsaynö tucuyläya mana allicunata shongoncunachö yarparmi, rasumpa jutsasapaga cayan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsaypitanam Señor Jesucristo tsay marcapita yargosquir, Tiro caru marcaman aywacurgan. Tsaychö caycanganta runacuna mana musyayänanta munarmi, juc wajiman yaycurgan. Tsaynö mana munaycaptinpis runacunaga imaycanöpis musyasquiyarganmi. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tsaychö juc warmi musyasquirmi, Señor Jesucristoman jina öra shamurgan, warmi wawan supayyog captin. Chaycurnam Señor Jesucristopa puntanman gongorpacuycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tsay warmiga griegocuna casta Sirofenicia marcachö yurigmi cargan. Tsaynö puntanman gongoricuycurmi Señor Jesucristota mañacurgan: “Taytay. Wawalläpita supayta gargoycullay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsaynö niptinnam Señor Jesucristo nirgan: “Marcamajïcunapis atscagmi llaquiparnin yanapaypag cayan. Canan gamta llaquiparniqui yanaparga, tantata wamracuna micuycäyaptin gechur, allgocunata garagnömi canga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tsay warminam nirgan: “Aumi, Taytay. Tsaynö captinpis wamracuna micuyaptin shicwagtam allgocunapis micuyan. Rasumpam wananqui marcamajiquicunata mas yanapayta. Pero ichicllatapis cuyacuyniquita nogamanpis shicwaycatsillamuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Señor Jesucristonam nirgan: “Allitam gamga niruyqui. Canan cuticuyna. Wawayquipita supay yargoshganam.” ");
INSERT INTO qxnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsay warminam wajinman chaycur, supay yargosquiptin wawan cuticashgatana tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tsaypitanam Tiropita Señor Jesucristo cuticurnin, Sidon marcapawan Decapolis marcacunapa päsar, Galilea gochaman chargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tsaychönam mana wiyag ni parlag upata Señor Jesucristoman apayämur rugayargan: “Maquillayquita churaycurnin cay runata cuticaycatsillay” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Señor Jesucristonam runacunapita witisquir, dëdunwan runapa rinrinta yatargan. Tsaynöllam dëdunta togatsaycurnin runapa galluntapis yataycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsaynam llaquicurnin altu cielupa ricarcur “¡Efata!” nirgan. (Efataga “Quichacay” ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tsaynö niycuptillam rinrinwan gallun cuticasquiptinmi, tsay runa allish parlarnin shumag wiyar gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Runacunatanam Señor Jesucristo alvertirnin nirgan: “Ama ni pitapis willayanquitsu cay runata cuticätsingäta.” Pero tsaynö nicaptinpis tsay runacunaga maytsaypa aywarmi masrag willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tsaynö willacuyaptin waquincag runacuna musyasquirmi alläpa mantsacashga niyargan: “¡Imaycatam Señor Jesucristoga ruran! Llapan rurangancunapis alläpa allim. Tsaynöllam mana wiyag ni parlag upa runacunatapis cuticätsin.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tsaypitanam juc cuti Señor Jesucristoman atscag runacuna goricashga cayargan. Micuyänanpag mana ni imapis captinmi, discïpuluncunata Señor Jesucristo gayasquir nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cay runacunata llaquipämi. Quimsa junagnam caychö nogawan pagta caycäyan. Manam ni imallapis micuyänanpag cantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waquinnäga alläpa caru marcacunapitam shayämushga. Si mallagllata ‘wajiquicunaman cuticuyay’ niptïga, nänita aywaycarllach pishiparnin mallagaywan shongoncunapis ushacasquinman.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Discïpuluncunanam niyargan: “¡Pero caytsicag runa micuyänanpagga maychörag cay tsunyachöga tantallatapis tarishwan!” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Señor Jesucristonam tapurgan: “¿Ayca tantatan cayäpushunqui?” Paycunanam “Ganchisllam cayäpaman niyargan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsaynö niyaptinnam runacunata Señor Jesucristo patsaman jamayänanpag mandargan. Patsaman llapan jamasquiyaptinnam Señor Jesucristo tantata achcurcur, Dios Yayaman mañacusquirnin paquisquir discïpuluncunata macyargan. Discïpuluncunanam tsaychö llapan runacunata aypuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tsaynöllam pescädoncunapis ichiclla cayäpurgan. Tsayta achcurcurnam Dios Yayaman mañacusquir, discïpuluncunata macyargan runacunata aypuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsaynömi llapanpis pacha junta micuyargan. Micur ushasquiyaptinnam, ganchis canasta juntata Señor Jesucristopa discïpuluncuna sobragcagta goriyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsaychö micug runacunaga ollgocagllam chuscu warangan cayargan, warmicunatawan wamracunata mana yupaycäyaptin. Tsaynö llapan micur ushasquiyaptinnam runacunata “Aywacuyayna” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Señor Jesucristonam discïpuluncunawan büquiman lätarcur, Dalmanuta niyangan marcaman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tsay marcaman chäriyaptinnam, fariseocuna shamuycur Señor Jesucristota imaycata tapupäyargan: “Dios Yayapita rasumpa shamushga carga, mä canan ima milagrullatapis ruramuy nogacunapis musyayänäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tsaynö niyaptinnam, Señor Jesucristo yarpachacurnin nirgan: “¿Imanirtan milagruta ruramunätarag mañayämanqui? Rasuntam niyag: Gamcunapagga manam ni ima milagrullatapis rurashagtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tsaynö nisquirmi jagesquirnincuna, büquiman lätarcur gocha wac tsimpanman aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tsaynö büquichö aywaycäyaptinnam, jucllaylla tantancuna cargan gongasquir mana apayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Señor Jesucristonam nirgan: “Cuidacur alcäbo cayay fariseocunapawan rey Herodespa levadürancunapita.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero discïpuluncunanam mana entendirnin, quiquincuna pura ninacuyargan: “¿Tantantsic mana captinchari tsaynöga maypis nimantsic?” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsaynö parlayanganta musyasquirmi tapurgan: “¿Imanirtan ‘Tantantsic cantsu’ nir, parlayanqui? ¿Manaragcu gamcunapis entendirnin cuentata gocuyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ñawiquicunawan rinriquicuna caycaptinpis ¿manacu ricäyanqui ni wiyayanqui? ¿Manacu yarpäyanquipis? ");
INSERT INTO qxnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pitsga tantallapitam pitsga waranga runacunata garargä. ¿Ayca canasta juntatatan sobragcunata goriyargayqui?” Paycunanam niyargan: “Chunca ishcay canastatam.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Señor Jesucristonam nirgan: “Y ganchis tantapita chuscu waranga runacunata garasquiptï ¿Ayca canasta juntatatan goriyargayqui?” Paycunanam niyargan: “Ganchis canastatam.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tsaynam Señor Jesucristo nirgan: “¿Tsaycunata ricaycarpis manaragcu entendiyanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsaypitanam Betsaida marcaman chäriyaptin, gapra runata runacuna apamur rugayar niyargan: “Cay runapa ñawincunata maquillayquiwan yataycullay cuticasquinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Señor Jesucristonam gaprata jancharcur marcapa washaninman apargan. Tsaynam gaprapa ñawinta togayninwan llushisquir, umanman maquinta churaycurnin tapurgan: “¿Ricanquicu imallatapis?” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tsay gapranam ricchacusquir nirgan: “Aumi, Taytay. Ricämi runacunata jachacunatanö purigta.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsaynö niptinnam runapa ñawinta yapay Señor Jesucristo yataycurgan. Runapa ñawincuna cuticasquiptinnam llapanta shumag allishna ricasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Señor Jesucristonam runata wajinman cuticunanpag mandarnin nirgan: “Amana marcaman yaycunquinatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsaypitanam Cesarea de Filipo niyangan marcaman discïpuluncunawan Señor Jesucristo aywar maytsaypa puriyargan. Tsaynö nänita aywaycarnam paycunata tapur nirgan: “¿Nogapag pï cangätan runacuna yarpäyan?” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Discïpuluncunanam niyargan: “Waquinmi niyan: ‘Payga Juan Bautistam.’ Waquincunam niyan: ‘Unay Elíasmi.’ Waquinnam niyan: ‘Payga Dios Yayapa juc profëtanmi.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Señor Jesucristonam nirgan: “Pero gamcunaga ¿Imatatan nogapag yarpäyanqui? ¿Pitan noga cä?” Pedronam nirgan: “Gamga Diospa Tsurin Cristom canqui, cay patsaman shamugpagcag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsaymi Señor Jesucristonam alvertirnincuna nirgan: “Cristo cangäta ama ni pitapis willacuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tsaynam discïpuluncunata yachatsir nirgan: “Diospa Tsurin alläpam sufrirnin ñacanga maltratayaptin. Autoridäcunam mas mandacugcag sacerdöticunawan ley yachatsicugcuna chiquirnin wañutsiyanga. Pero wañunganpita quimsa junagllatam cawamunga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tsaypitam washaläpa apasquirnin, Señor Jesucristota Pedro piñapayta gallaycurgan: “¿Imanirtan tsayta parlanqui Dios Yayaga manam wañutsiyäshunayquita munangatsu?” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Señor Jesucristonam tumaycur discïpuluncunata ricaycurnin, Pedrota piñapar nirgan: “¡Satanas, caypita witiy! Runacunanö yarparmi tsayta parlanqui, manam Dios Yaya munangannötsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tsaynam runacunatawan discïpuluncunata gayasquir nirgan: “Nogata gatimayta munagcagga quiquinpa munayninta dëjasquir, imayca cruzta apagnö alläpa sufrir wañunan captinpis gatimätsun. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Quiquillanpita cawayta munagcagga, imaypis cawaynintam ogranga. Pero nogaraycur o Dios Yayapa Alli Willacuyninraycu cawayninta ogragcagga, imayyagpis Dioswan cawanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Juc runa cay patsachö llapan imaycata gänarpis, almanta ograrnin condenacuptinga imapagrag llapan gänanganpis servinga. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tsaymi runa almanta salvananpagga, manam ni ima gellaypis servirnin välengatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sïcush Dios Yayata chiquirnin mana alli rurag runacunapa puntanchö pipis nogapita o yachatsicungäpita pengacunga, nogapis tsay runapitaga pengacushagmi Dios Yayapa poderninwan chipacyarrag cay patsaman cutimurnin santo angelnincunawan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tsaynöllam Señor Jesucristo nirgan: “Rasuntam niyag: Caychö caycäyagcunapita waquincagcunallam cawayanga, Dios Yayapa poderöso Mandacuy Reynon chämunganyag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tsaypita sogta junagtanam, Señor Jesucristo juc jatun jircaman aywayargan, Pedrowan Santiagowan y Juanwan. Tsaychö quiquillancuna caycarmi, quimsan discïpuluncuna ricaraycayaptin, Señor Jesucristo alläpa shumag ticrasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Llatapanpis alläpa shumag yurag pürum chipacyargan. Tsaynö yuragtaga manam ni pï tagsharpis yuragyätsiyta puedinmantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Quimsan discïpuluncunanam ricasquiyargan, Moiséswan Elías yuriscamur Señor Jesucristowan parlaycäyagta. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsayta ricaycurnam Señor Jesucristota Pedro nirgan: “Maestru, alläpa allim caychö caycantsic. Quimsa tsucllata rurashun jucta gampag juccagta Moiséspag y juctana Elíaspag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tsaychö quimsan discïpuluncuna jancat mantsacashga carmi, mana cuentata gocurnin Pedro tsaynö parlargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsaynö mantsacashga caycäyaptinmi pucutay urämur, llapancunata tsapasquirgan. Pucutay rurinpitanam Dios Yaya parlamugta wiyayargan: “Cayga alläpa cuyay Tsurïmi. Payta wiyarnin cäsuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsaypitanam discïpuluncuna Señor Jesucristota japallantana läduncunachö shaycagta ricaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tsay jircapita uraycämurninnam Señor Jesucristo nirgan: “Caychö ricäyangayquicunata ama ni pitapis willacuyanquitsu Diospa Tsurin wañusquir cawamungan junagyag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Señor Jesucristo ningannöllam discïpuluncuna mana pitapis willacuyargantsu. Quiquincuna puram tapunacuyargan: “¿Imanirtan Señor Jesucristoga wañusquirmi cawamushag” nimantsic? ");
INSERT INTO qxnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsaymi Señor Jesucristota tapurnin niyargan: “Taytay, ley yachatsicugcunagam niyan: ‘Diospa Tsurin Cristo cay patsaman shamunanpagga, puntantam cutimunga unay Elíasrag’ ¿Imanirtan tsaynö yachatsicuyan?” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tsaynam Señor Jesucristo nirgan: “Rasumpam Elíasga puntäta shamunga. Paymi noga cutimunäpag llapanta alistanga. Tsaypunga tsaynö caycaptinga ¿Imanirtan Diospa Palabranchöga yachatsicun: ‘Diospa Tsurintam runacuna alläpa chiquirnin sufritsir wañutsiyanga?’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero tsaymi noga niyag: “Elíasga shamushganam. Tsaymi payta runacuna maltratarnin munayanganta rurayargan. Tsaynö rurayänanpagmi Diospa Palabranchö unayna willacatsirgan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tsaypitanam waquincag discïpuluncunaman chaycur, atsca runacuna goricashgatawan discïpuluncunawan ley yachatsicugcuna piñanacuycäyagta tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsaychö runacunanam Señor Jesucristota ricasquir, alläpa mantsacashga cörrilla puntanyag saludag aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tsaymi Señor Jesucristo discïpuluncunata tapurgan: “¿Imanirtan paycunawan discutir piñanacuycäyanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsaynam juc runa nirgan: “Taytay, gammanmi cay ollgo tsurïta apamurgö. Payga supayyog carmi parlantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ataqui tsariptinmi pushugayta cachurnin quiruntapis regochyätsirrag ishquitsirnin, chucrushgatanö ticran. Wamräpita supaycunata gargoyänanpagmi discïpuluyquicunatapis mañacurgä. Pero paycunaga manam gargoyta puediyashgatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tsaynam Señor Jesucristo nirgan: “¡Allau, nogaman mana criyicugcuna! ¡Imayyagrag gamcunawan pagtalla caycäshag! ¡Imayyagrag mana criyicug cayangayquita awantayäshayqui! Wamrata cayman apayämuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamrata apaycayämuptinnam, Señor Jesucristota supay ricaycurnin, tsay wamrata ataquiwan achcuscatsir patsaman ishquitsir pushugayta cachutsirnin garintätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Señor Jesucristonam wamrapa taytanta tapur nirgan: “¿Imaypitanatan wamrayquita caynö päsan?” Taytannam nirgan: “Llullu canganpitam caynö päsan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Atsca cutinam ninamanpis yacumanpis supay ishquitsishga wañutsiyta munarnin. Pero imallatapis rurayta puedirga canan llaquipaycallämar yanapaycayällämay. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Señor Jesucristonam nirgan: “¿Imanirtan ‘imallatapis rurayta puedirga’ nimanqui? Nogaman rasumpa firmi criyicuptiquiga wamrayquita cuticätsishagmi. Tsaymi pipis Dios Yayaman rasumpa firmi criyicurga llapan imaycatapis chasquiyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsaypitanam wamrapa taytan jina öra nirgan: “Aumi, gammanga rasumpam criyicamü. ¡Pero mas firmi criyicunäpag yanapaycallämay!” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsayman ricagnin cörrilla atscag runacuna alläpa goricäyaptinmi, Señor Jesucristo supayta piñaparnin nirgan: “Gam supay, cay wamrachö captiquim upa mana parlag cacun. Tsaymi canan noga mandag: Paypita yargoy, manana mas cutinayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsaynö Señor Jesucristo niptinmi, supay gayararrag wamrata atäquiwan pagchisquirnin yargosquir aywacurgan. Supay aywacusquiptinnam wamra wañushganö ticrasquirgan. Runacunanam niyargan: “Wamraga wañusquinmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Señor Jesucristo wamrata maquinpita achcurcur sutarcuptinnam, sänuna sharcamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsaypita Señor Jesucristo wajiman yaycusquiptinmi, discïpuluncuna japallanta tapurnin niyargan: “¿Imanirtan nogacunaga supayta gargoyta puediyargötsu?” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Señor Jesucristonam nirgan: “Tsayläya puedig supayta gargoyänayquipagga Dios Yayamanmi alli mañacuyänayqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsaypitanam discïpuluncunawan Galilea provinciapa aywayargan. Pero Señor Jesucristoga manam munargantsu, tsayman chäyanganta runacuna musyayänanta, ");
INSERT INTO qxnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","discïpuluncunallata yachatsinanraycu. Paycunata yachatsirmi nirgan: “Dios Yayapa Tsurintam traicionarnin runacuna prësur achcusquir wañutsiyanga. Tsaynö wañutsiyanganpita quimsa junagllatam cawamunga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero discïpuluncunaga tsaynö ninganta mana entendirmi, mantsaparnin ni imatapis tapuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsaypitanam Capernaum marcaman chaycurnin juc wajiman yaycusquir, discïpuluncunata tapur nirgan: “¿Nänita shamuycashga imatatan piñanacur parlayargoyqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero discïpuluncunanam upällalla cacuyargan. Paycunaga nänichö piñanacuyargan llapanpa mandagnin cayta munarmi. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsaychönam Señor Jesucristo jamaycur discïpuluncunata gayasquir nirgan: “Maygayquipis mandacug cayta munarga, llapanta servirnin mas gollmi shongo llapanpitapis mas umilde cayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsaynö nirmi juc wamrata gayasquirnin, discïpuluncuna ricäyänanpag puntancunaman ichiycatsirgan. Tsaypitanam wamrata margarcurnin discïpuluncunata nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Pipis cay wamracunata nogaman criyicunganraycu chasquirga, nogatapis chasquimanmi. Nogata chasquimagnïga cachamagnï Dios Yayatapis chasquinmi, manam nogallatatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tsaypitanam discïpulun Juan nirgan: “Maestru, nogacunam tariyargö supayyogcunapita juc runa shutiquichö supaycunata gargoycagta. Mana nogantsicwan pagta purishga captinmi amatsayargö.” ");
INSERT INTO qxnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Señor Jesucristonam nirgan: “¡Ama amatsayanquimantsu cargan, podernïwan pipis imayca milagruta shutïchö rurarga imanörag maytsaypa aywarpis nogapa conträ saslla parlanman! ");
INSERT INTO qxnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tsaymi pipis contrantsic mana carga, nogantsicwan caycan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rasuncagtam niyag: Nogapa discïpulucuna cayangayquiraycu pipis shutïchö yacullatapis garayäshuptiquiga, tsay runataga imayca premiagnömi Dios Yaya yanapanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Si caynö wamracuna nogaman criyicuycagta, pipis mana allita rurananpag yachatsiptinga, mejormi canman tsay runapa cuncanman jatun molinu rumita watarcur lamarman jitarpuyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sïcush jutsata ruranayquipag maquiqui ishquitsishunqui, mas allim canman tsay maquiquita rogosquir jitasquiptiqui. Tsaynö mancu cayniquiwanmi, Dios Yayawan imayyagpis cawanqui. Pero mana sïga ishcan maquiyogmi mana imaypis wañug nina infiernuman aywanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Y sïcush jutsata ruranayquipag chaquiqui ishquitsishunqui, mas allim canman tsay chaquiquita rogosquir jitasquiptiqui. Tsaynö rata cayniquiwanmi, Dios Yayawan imayyagpis cawanqui. Pero mana sïga ishcay chaquiyogtam Dios Yaya infiernuman garpushunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Tsaynöllam si jutsata ruranayquipag ñawiqui ishquitsishuptiquiga, mas allim canman ñawiquita jorgosquir jitasquiptiqui. Tsaynö gapra cayniquiwanmi Dios Yayapa Mandacuy Reynonchö imayyagpis cawanqui. Pero mana sïga ishcan ñawiyogtam infiernuman Dios Yaya garpushunqui. Diospa Palabran gellgashgachö ningannömi: ");
INSERT INTO qxnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tsaychöga curucunam ni imaypis wañuyantsu. Ninapis manam wañuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tsaychöga llapanmi juzgashga cayangan. ");
INSERT INTO qxnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Cachiga alläpa allim. Pero tsay cachi micuyta mana mishquitsirga ¡imapagrag välenman! Gamcuna alli ruragcagga imayca cachi mishquignömi cayanqui, jucnin jucninwanpis shumag allish päsacur.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaum marcapita Señor Jesucristo aywacurmi, Judea provincia Jordan niyangan mayu wac tsimpanman chargan. Tsayman chaycuptinpis yapaymi alläpa atscag runacuna goricäyargan. Tsaychömi imaypis yachatsicungannö Señor Jesucristo paycunata yachatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsaymanmi fariseocuna shamuycur, Señor Jesucristota pantatsiyta munarnin tapur niyargan: “¿Leynintsicga permïtincu juc runa warminpita raquicänanpag?” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Señor Jesucristonam nirgan: “Moisés gellgangan leychö ¿imanötan Dios Yaya mandacun?” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseocunanam niyargan: “Moisésmi leyninchö mandacur permïtirgan: ‘Maygan runapis warminpita raquicayta munarga, divorcio cartata ruraputsun raquicäcur aywacunanpag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsaynö niyaptinnam Señor Jesucristo nirgan: “Gamcuna chucru shongo car, alli rurayta mana munayaptiquim, Moisés tsayta permïtirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero runata camangan tiempuchömi, Dios Yaya ‘ollgotawan warmita rurarnin’ ");
INSERT INTO qxnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","dispönirgan: ‘Ollgocag runaga taytantawan mamanta dëjasquir, warminwan pagta täcuyätsun. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tsaynöpam warmi ollgopis jucllayllanölla ishcanpis cayanga’. Tsaypitaga mananam ishcagnatsu cayanga, sinöga juc cuerpunöllanam ishcanpis cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tsaymi quiquin Dios Yaya tsaynö juntangantaga, manam ni pipis raquinmantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsaypitanam wajiman yaycusquiyaptin, Señor Jesucristota discïpuluncuna niyargan: “Tantiyaycatsiyämay tsay raquicay imanö canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Señor Jesucristonam nirgan: “Maygan runapis warminpita raquicasquir, jucwan casararga, tsay runaga adulterio niyangan llutan mana alli jutsatam ruraycan warminpa contran. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tsaynöllam maygan warmipis gojanpita raquicasquir, juc runawan casararga, tsay warmipis adulterio niyangan llutan mana alli jutsata ruraycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsaypitanam runacuna wamracunata Señor Jesucristoman apayämurgan maquinta umancunaman churananpag. Pero discïpuluncunanam apamug runacunata piñapäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tsayta ricaycurmi Señor Jesucristo piñacur nirgan: “¡Nogaman wamracuna jina shayämutsun! Ama michäyaytsu. Cay wamracunanö umildecag runacunapagmi Dios Yayapa Mandacuy Reynonga. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rasuntam niyag: Sïcush Dios Yayapa Mandacuy Reynonta pipis wamranö mana chasquinga, manam ni imaypis yaycuyangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsaynö nisquirnam wamracunata margarcur, umancunaman maquinta churar nirgan: “Dios Yaya yanapaycuyäshuy.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tsaypita Señor Jesucristo aywacuycaptinnam, juc runa cörrilla chärir gongorpacuycur tapurnin nirgan: “Maestru, gamga alli ruragmi canqui. Mana ushacag wac vïdachö Dios Yayawan wiñaypa cawanäpag ¿Imacunatatan rurashag?” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tsaymi Señor Jesucristo nirgan: “¿Imanirtan: ‘alli rurag’ nimanqui? Jucllayllam alli ruragga. Dios Yayalla. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Musyanquim Dios Yaya mandacungancunata. Ama runamajiquita wañutsinquitsu. Warmiquiwan casarashga caycar, ama jucnin jucninwan tacunquitsu. Ama suwacunquitsu. Ama calumniar manacagchö llullacurnin parlanquitsu. Ama runamajiquita engañanquitsu. Taytayquitawan mamayquita cuyarnin respetar llaquipanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tsaymi runa nirgan: “Maestru, wamra caynïpitanam tsay llapan mandacuycunataga rurarnin cumplishcä.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tsaynam runata llaquirnin cuyapar Señor Jesucristo nirgan: “Tsaynö captinga, cayta ruranayquillanam faltäshunqui. Canan aywar imaycayquicunatapis chipyat ranticusquir, wactsacunata gellayniquita garaycunqui. Tsaymi sïga cieluchöpis alläpa capugyog canqui. Tsaynö rurasquir cutimur nogata gatimay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tsayta wiyaycurnam runaga alläpa llaquishga aywacurgan. Payga alläpa rïcu carmi, Señor Jesucristo ninganta rurayta munargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsaypita runa aywasquiptinnam, Señor Jesucristo tumaycur discïpuluncunata nirgan: “¡Alläpa ajam Dios Yayapa Mandacuy Reynonman capugyog rïcu runacuna yaycuyänanpag!” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tsaynö Señor Jesucristo niptinnam, discïpuluncuna mantsacashga cayargan. Pero Señor Jesucristonam nirgan: “Ïjucuna, ¡imanö alläpa ajam Dios Yayapa Mandacuy Reynonman yaycuyga! ");
INSERT INTO qxnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas fäcilmi juc jatun ‘camëllo’ wäta aujapa uchcunpa ucllunman, juc rïcu runa Dios Yayapa Mandacuy Reynonman yaycunganpitaga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Señor Jesucristo ninganta discïpuluncuna wiyarmi, alläpa mantsacashga ninacuyargan: “Tsaynö captinga ¡pirag salvacanga!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Señor Jesucristonam discïpuluncunata ricaycur nirgan: “Runacuna manam quiquillancunapitaga salvacuyta puediyantsu. Pero Dios Yayam sïga salvayta puedin. Paypagga manam ni imapis ajatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsaymi Pedro nirgan: “¡Taytay, nogacunaga llapan imaycäcunatapis jagesquirmi gamta gatiraycäyag!” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Señor Jesucristonam nirgan: “Rasuntam niyag: Nogapa Alli Willacuynïta wiyarnin cäsurnin nogata servimänanraycu pipis wajinta, waugenta, paninta, mamanta, taytanta, tsurincunata, chacrancunata dëjarga; ");
INSERT INTO qxnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cay patsachö dëjanganpita pachac cuti masmi tsay runapa imanpis canga wajincuna, waugencuna, panincuna, mamancuna, tsurincunawan chacrancunapis. Cay patsachö nogata servimanganraycu gaticachäyaptin alläpa sufrirpis, wac vïdachöga Dios Yayawanmi wiñaypa cawanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero canan puntachöcagcunam wac vïdachöga gepachö cayanga y gepachöcagcunanam puntachö cayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tsaypitanam discïpuluncunapa puntanta Jerusalénman Señor Jesucristo aywaycargan. Discïpuluncunanam mantsacashga gepanta gatiyargan. Tsaychönam chunca ishcay discïpuluncunallata yapay washaläduman gayasquirnin willar “Caynömi nogata päsamanga” nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jerusalénmanmi aywaycantsic. Tsaychömi Diospa Tsurinta traicionarnin runacuna prësur mayor sacerdöticunamanwan ley yachatsicugcunaman entregayanga. Paycunanam yachatsinacurnin condenar Roma autoridäcunaman wañutsiyänanpag apatsiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tsay autoridäcunanam payta burlacurnin togapur, alläpa astarnin sufritsir wañutsiyanga. Pero wañutsiyanganpita quimsa junagllatam cawamunga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsaypitanam Zebedeopa tsurincuna Santiagowan Juan shamur, Señor Jesucristota niyargan: “Maestru, canan imaycata mañacuyangagtapis ruraycullay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Señor Jesucristonam nirgan: “¿Imata ruranätatan munayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paycunanam niyargan: “Gam poderöso Mandacuy Reynoyquichö dispöniycuy jucnï derëchucag läduyquichö y jucnï itsogcag läduyquichö jamacayämunäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsaynö niyaptinnam Señor Jesucristo nirgan: “Gamcunaga manam musyayanquitsu ni imata mañayämangayquitapis. Cananmi alläpa ayagta upugnömi sufrishag. ¿Tsaynöga gamcuna sufriyta puediyanquimantsurag?” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Paycunanam niyargan: “Aumi, Taytay puediyämanmi.” Tsaymi Señor Jesucristo nirgan: “Rasumpam noga alläpa ayagta upyangänö gamcunapis sufriyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero derëchüwan itsognïcag läduchö pipis jamananpagga manam nogatsu dispönï. Tsaytaga quiquin Dios Yayallam dispöninga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tsaychö chunca discïpuluncuna musyasquirnam, Juanpagwan Santiagopag piñacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsaynam Señor Jesucristo yapay llapan discïpuluncunata gayasquir nirgan: “Musyayangayquinömi may marcacunachöpis mayorcagcunaga mas puedig patronnö runacunata mandayan y autoridäcunapis mandacug caynincunawanmi llapanta dispöniyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero gamcunaga manam tsaynötsu cayänayqui. Si gamcuna mas mandacug cayta munarga, waquincagcunapa servigninmi cayänayqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y si maygayquipis mas mandacuyyog cayta munarga, waquincagcunapa servignin esclävunnömi cayänayqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tsaymi Diospa Tsuringa cay patsaman shamushga runacunata servinanpag, manam payta serviyänanpagtsu. Sinöga cay patsaman shamushga llapan runacuna libri cayänanpag quiquinpa cawayninwan llapanta rantinanpagmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsaypitanam Jerico marcaman chäyargan. Tsay marcapita Señor Jesucristo yargosquirnam, discïpuluncunawan atscag runacuna aywayargan. Tsaynö aywaycäyaptinnam nänipa cuchunchö gapra Bartimeo shutiyog runa jamaycargan limushnata mañacurnin. Tsay gapragam Timeopa tsurin cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tsay gapranam Señor Jesucristo Nazaret runa chaycagta tantiyasquir, gayaycachar nirgan: “¡Rey Davidpa ayllun Jesús, llaquipaycallämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tsaychö atscag runacunanam gaprata piñaparnin niyargan: “¡Upälla cay!” nirnin. Pero tsaynö piñapäyaptinpis gapraga mas jinchi gayaraypam yapay nirgan: “¡Davidpa ayllun, cuyapaycällämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsaynam Señor Jesucristo ichiycur nirgan: “Tsay runata gayayämuy.” Gapratanam niyargan: “Cushicur shärimuy, Señor Jesucristom gayashunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gapranam punchuntapis jitasquir, wap sharcurnin Señor Jesucristoman cörrilla aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Señor Jesucristonam tapurgan: “¿Gampag imata ruranätatan munanqui?” Gapranam nirgan: “Maestru, ricaytam munallä.” ");
INSERT INTO qxnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tsaynam Señor Jesucristo nirgan: “Cananga aywacuyna. Nogaman criyicamungayquipitam, cuticashgana canqui.” Tsaymi gapra runaga jina öra cuticasquir alayri ricarna, Señor Jesucristopa gepanta nänipa aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tsaypita Jerusalénman aywarmi, Olïvos niyangan jircamanwan Betfage Betania marcacunaman chäyargan. Tsaypitanam Señor Jesucristo ishcag discïpuluncunata mandarnin, ");
INSERT INTO qxnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nirgan: “Tagay marcaman aywayay. Chärirmi tariyanqui manarag pipis montashga mallwa ashnu wataraycagta. Tsay ashnuta pascasquir apayämunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si pipis ‘¿Imapagtan tsay ashnuta apayanqui?’ niyäshuptiquiga, ‘Señor Jesúsmi wanan, sasllam cutitsimunga’ niyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsaypita ishcan discïpuluncuna aywarmi, waji puncu nänichö ashnu wataraycagta tariyargan. Tsayta pascaycäyagta, ");
INSERT INTO qxnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","runacuna ricasquirnam niyargan: “¿Imapagtan cay ashnuta pascayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsaynam Señor Jesucristo ningannölla discïpuluncuna niyargan. Runacunanam: “Tsaypunga apayay ari” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Señor Jesucristoman ashnuta apamurnin chäratsiyaptinnam, punchuncunata carunarcur montargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tsaynö montashga aywayptinnam, atscag runacuna punchuncunatawan jacuncunata näniman mashtayargan. Waquincagcunanam jachapa rämancunata paquisquir, mashtayargan Señor Jesucristo aywangan näniman. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tsaynö atscag runacuna Señor Jesucristopa puntantawan gepanta aywarmi, gayaycachar niyargan: ¡Salvaycayämay, Dios Yaya Alabayällagmi cielupita Tsuriquita cachamungayquita! ");
INSERT INTO qxnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Unay aylluntsic rey David cangan watacunachönömi, Señor Jesucristo Dios Yayapa Mandacuy Reynonchö canan reynintsic canga. ¡Cieluchö caycag Dios Yayalläcuna, salvaycayällämay! ");
INSERT INTO qxnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Señor Jesucristo Jerusalénman chaycurnam, templuman yaycurgan. Tsaychö imaycacunata ricapaycaptin tardiyasquiptinmi, discïpuluncunawan Betaniaman cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Waränin allegnam Betania marcapita yargaycäyämur, Señor Jesucristo mallagargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Carupita ïgospa yuran raprayog caycagta ricasquirmi, wayuyninta ricag aywargan. Chärirnam ïgospa tiempun manaragcaptin yuranllanta tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsaynöta tarisquirmi ïgospa yuranta Señor Jesucristo nirgan: “Cananpitaga mananam pipis wayuyniquita micunganatsu.” Tsaynö ningantam discïpuluncuna wiyayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tsaypitanam Señor Jesucristo Jerusalénman chaycurnin templuman yaycusquir, gatucugcunatawan rantipacugcunata gargorgan. Gellayta trucapacugcunapa mësancunatawan paloma ranticugcunapa jamacuyanancunatapis wicapatacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Templuman imatapis aparnin yaycatsiyanantam amatsarnin michargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsayta rurasquirmi runacunata yachatsir nirgan: “Diospa Palabran gellgashgachömi nirgan: ‘Wajïga noga Diosllaman llapan marcacunapita shamug runacuna mañacayänanllapagmi canga.’ Pero gamcunaga suwacunapa machayninmanmi ticratsiyashcanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tsaynö Señor Jesucristo parlanganta mayor sacerdöticunawan ley yachatsicugcuna wiyarmi, wañutsiyänanpag yachatsinacuyargan. Señor Jesucristo yachatsicungan llapan runacunata alläpa gustaptinmi, paycunaga mantsapäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tsaychö goyasquiptinnam Señor Jesucristo discïpulucunawan Jerusalénpita aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tsaypita waränin alleg cutiycarnam, ïgospa yuran chapapita jancat tsaquishgata tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsaynam Señor Jesucristo ninganta yarpasquir, Pedro nirgan: “¡Maestru, ricay! Ganyan ‘Wayuynatsu’ ningayqui ïgospa yuran päsaypa jancat tsaquishga caycan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Señor Jesucristonam nirgan: “Dios Yayaman criyicuyay. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rasuntam niyag: Pipis payman rasumpa firmi shongonchö criyicurga, tagay jircata: ‘Caypita aywar lamarman jegarpuy’ niptinpis, tsay jirca rasumpam cäsunman. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tsaymi niyag: Poderöso canganta rasumpa firmi criyicurnin, Dios Yayaman mañacurga imayca mañacuyangayquitapis rasumpam chasquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Si Dios Yayaman mañacur pipis mana allita rurayäshungayquita yarparga, jina öralla tsay runata perdonaycunqui. Tsaynö contrayqui mana alli ruragcunata perdonaptiquim, cieluchö caycag Dios Yayapis jutsayquicunapita perdonashunqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Si gamcuna mana perdonayaptiquiga, Dios Yayapis manam perdonayäshunquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsaypitanam Jerusalénman yapay chäyargan. Tsay Jerusalén templuchö puriycäyaptinmi, mayor sacerdöticunawan ley yachatsicugcuna y waquincag autoridäcuna shamuycur, ");
INSERT INTO qxnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Señor Jesucristota tapur niyargan: “¿Ima puedig cayniquiwantan cay templupita runacunata gargorgoyqui? Caynö yachatsicunayquipag ¿pitan cachamushushcanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tsaymi Señor Jesucristo nirgan: “Gamcunatapis jucta tapuyäshayqui. Willayämaptiquiga, nogapis pï cachamanganta willayäshayquim. ");
INSERT INTO qxnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Dios Yayacu? o ¿Runacunacu Juan Bautistata cachamurgan runacunata bautizananpag? Mä, canan niyämay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsaynam autoridäcuna quiquincuna pura yachatsinacurnin niyargan: “ ‘Dios Yayam cachamushga’ nishagam, nimäshun: ‘Tsaypunga ¿imanirtan gamcunapis payta mana criyiyargayquitsu?’ ");
INSERT INTO qxnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero si ‘runacunam cachamushga’ nishaga, manam allitsu canga” (Dios Yaya cachamungan profëta Juan Bautista canganta llapan runacuna criyiyaptinmi, autoridäcuna mantsacuyargan.) ");
INSERT INTO qxnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tsaynö yachatsinacusquirmi, Señor Jesucristota niyargan: “Nogacunaga manam musyayätsu.” Tsaynam Señor Jesucristopis nirgan: “Tsaynömi nogapis willayagtsu caycunata ruranäpag ni pï cachamangantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsaypitanam Señor Jesucristo yapay ejemplucunawan iwalatsicur yachatsicurnin gallaycurgan: “Juc runam chacrayog cargan. Tsay runam chacranchö üvata plantasquir llapan cuchuncunapa pergatsirgan. Tsaypitanam üvapa yacunta gapinanpag patsata uchcutsirgan. Chacranta täpananpagmi juc altu törreta shäratsirgan. Tsaynö rurasquirmi chacran tsarag runacunata pullan pura aruyänanpag contratasquir, caru marcapa aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsaypitanam cosëcha quilla chäriptin servigninta cachargan, pullancag töcangan üvapa wayuyninta gorimunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero tsay servignin chäriptinnam, chacran tsarag runacuna achcusquir magacachasquirnin, mana ni imatapis entregar gargosquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tsaynam chacrayog runaga yapay juc servigninta cachargan. Tsaynöllam tsaycag servignintapis chacran tsarag runacuna garutirnin umantapis paquir allgotsäcuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsaypita yapay juccag servigninta chacrayog mandangantam wañuscatsiyargan. Tsaypitanam chacrayogga yapay atscag runacunata cachargan. Paycunatapis magacacharninmi waquincagcunataga wañuscatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tsaymi chacrayog mandananpagga quiquinpa juc cuyay tsurinllana cargan. Paytanam cachargan: ‘Tsurïtaga respetarnin, manach imanäyangatsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Pero tsurin shamuycagta ricasquirnam, chacrata tsarag runacuna ninacuyargan: ‘Cayga chacrayogpa tsurin eredërom, wañuscatsishun chacranwan quëdanapag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsaynö nirmi, tsay tsurintapis achcusquirnin wañuscatsir, ayantapis chacranpita mas jucläman jitasquiyargan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsaynö yachatsicur ushasquirnam, Señor Jesucristo tapurgan: “Tsay runacunata chacrayog ¿imatatan ruranga? Shamuycurmi chacran tsaragcunata wañuscatsir, chacranta juccunatana entregaycunga. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Manacu liyiyashcanqui Diospa Palabranchö gellgashga caycagta? ‘Pergagcuna rumita jitariyanganmi, alläpa shumag maestru rumi ticranga. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios Yayam tsaynö cananpag dispönirgan. Tsayga alläpa allicagmi nogantsicpagga’ nir.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsaynö Señor Jesucristo yachatsicur ushasquiptinnam, contrancuna parlanganta autoridäcuna tantiyasquir, prësu achcuyta munayargan. Pero atscag goricashga runacunata mantsarmi, mana wajuparlla aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsaypitanam fariseocunawan rey Herodes gatiragnincunata cachayargan, Señor Jesucristota tapucuynincunawan pantatsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chärirnam niyargan: “Maestru, musyayämi rasuncagllata imaypis ningayquita. Manam runacunata mantsanquitsu imayca puedig cayaptinpis, Dios Yaya ningannöllam gam yachatsicunqui allicunata rurarlla cawacuyänäpag. Tsaynö caycarga canan willayämay. ¿Leynintsicga permïtincu Roma gobierno mandacugman contribucionta päganapag? ");
INSERT INTO qxnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Pagashwancu o manacu?” Pero janan shongo cayanganta Señor Jesucristo musyarmi nirgan: “¡Imanörag pantatsiyämayta munayanqui! Juc gellayta apamur ricatsiyämay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gellayta apascayämuptinnam, Señor Jesucristo nirgan: “Cay gellaychöga ¿pipa reträtuntan caycan? ¿Pipa shutintan gellgaraycan?” Paycunanam niyargan: “Roma gobierno mandacug Cesarpam” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsaymi Señor Jesucristo nirgan: “Roma Cesarpacagtaga Cesarta entregaycuyay. Pero Dios Yayapacagtaga Dios Yayata. (Nogantsicpis Dios Yayapam cantsic.)” Tsaynö Señor Jesucristo niptinnam, paycuna upälla mantsacashga quëdasquir ni imanö cayta puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsaypitanam saduceocuna Señor Jesucristota tapuyänanpag shamurgan. Paycunam imaypis yachatsicuyag: Wañushgacuna manana cawayämunanpag. Tsaymi tapurnin niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maestru, Moisés gellgangan leymi mandacun: ‘Juc casädo runa manarag tsurin captin wañuptinga, viudanwan waugen casaraptin, tsay wañushgacag waugenpa tsurin cuenta cananpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tsayshi, unay ganchis waugecuna cayänag. Mayorcagshi casarasquir manarag tsurin captin wañusquinag. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tsayshi paypa viudanwan gepancag waugenna casaranag. Paypis manarag tsurin captinshi wañusquinag. Juccag waugennash tsay viudanllawan casaranag, pero paypis tsaynö wañusquinagllash. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tsaynöllash ganchisnintin tsay warmillawan casarasquir, manarag tsurincuna captin wañusquiyänag. Tsaypitanash warmipis wañusquinag. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tsaynö llapanwan casarashga caycaptinga, ¿cawamuy junagchöga maygancag waugeparag warmin canga?” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tsaymi Señor Jesucristo nirgan: “Gamcunaga Diospa Palabranta mana yacharmi, Pay alläpa poderöso canganta mana regernin pantashga caycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wañushgacuna cawayämungan junagchöga mananam warmipis ni ollgopis casarayanganatsu. Cieluchö caycag angelcunanö mana casararllanam cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tsaymi wañushgacuna cawayämunanpag yachatsiyäshayqui. ¿Manacu Moisés gellgangan leyta liyiyashcanqui? Rauraycag shiraca montichö yuripurmi, Dios Yaya nirgan: ‘Nogaga unay Abrahampawan Isaacpa y Jacobpa adorayänan Diosmi cä.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios Yayaga manam wañushgacunapatsu, sinöga cawaycagcunapam. Gamcunaga mana allipa musyarmi, pantashga caycäyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tsaypitanam Señor Jesucristo saduceocunata allish contestanganta wiyashga car, juc ley yachatsicug runa shamuycur tapurnin nirgan: “Dios Yayapa mandamientunchöga ¿Maygancagtan mas välen?” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Señor Jesucristonam nirgan: “Mas välegcag mandacuyninga caymi: Wiyacuyay israelcuna. Dios Yayantsicga jucllayllam, Payga Señornintsicmi. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dios Yayata cuyay llapan shongoyquiwan, llapan almayquiwan, llapan yarpayniquiwan, llapan callpayquiwan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gepancag mandamientuga tsaynöllam. Quiquiquitanölla runamajiquita cuyanqui. Tsay ishcan mandamientucunapitaga manam mas välegcag cantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsaynö Señor Jesucristo niptinnam, ley yachatsicug nirgan: “Allim ningayqui, Maestru. Gam ningayquinöllam Dios Yayaga jucllaylla. Diosnintsicnöga manam jucga mas cantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Llapan shongontsicwan yarpaynintsicwan, callpantsicwan Dios Yayata cuyarnin, runamajintsictapis quiquintsictanö cuyarga, allitam ruraycantsic. Dios Yayapag aparnin wätantsiccunatawan imaycata garanapag apangantsicpitapis, masmi välen runamajintsicta llaquiparnin cuyangantsic.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tsaynö alli yachayninwan runa niptinnam, Señor Jesucristo nirgan: “Dios Yayapa Mandacuy Reynonman chaycanquinam” Tsaypitanam Señor Jesucristota mantsarnin, manana ni imatapis ni pï tapupargannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tsaypitanam templupa patiunchö Señor Jesucristo yachatsicuycar nirgan: “Ley yachatsicugcunam yachatsicuyan: Cristoga unay rey Davidpa ayllunpita shamunanpag. ¡Tsaypunga imanörag! ");
INSERT INTO qxnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espïritu Santo yachatsiptin, rey David declararnin nirgan: ‘Dios Yayämi Señornïta nirgan: “Cay derëchucag läduchö jamacamuy, llapan chiquishugniquicunata ushacätsirnin, chaquiquipa gopinman churamungäyag” nir.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tsaynö Cristota unay rey David ‘Señornïmi’ nicaptinga ¿imanöpatan paypa ayllunpita Cristoga shamunga?” Tsaynö Señor Jesucristo yachatsicuptinmi, tsaychö atscag runacuna alläpa gustargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tsaypitanam Señor Jesucristo yachatsicur nirgan: “Cuidädutag ley yachatsicugcuna engañayäshunquiman. Paycunagam shumag llatapancunata shucucurcur, allitucushga cällicunachö puriyan runacuna respëtuwan saludayänanta munarnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Goricäyänan wajicunachöpis autoridäcunapa jamacuyänancunallachömi jamacuyan. Imayca banquëticunaman convidayaptinpis, mas importanticagcunapa allicag jamacuyänancunatam ashiyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tsaynöllam viudacunapa wajincunatapis engañarnin gechuyan. Tsaynö rurasquirmi, runacuna mana musyayänanpag alläpa unay allitucurnin resacuyan. Tsaycunataga alläpa mantsacaypagmi, quiquin Dios Yaya castiganga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tsaypitanam templuchö Señor Jesucristo limushna cäjapa washaläninchö jamaycar runacuna gellayta wiñäyagta ricargan. Tsaymi atsca capugyogcag runacunaga atsca gellayta wiñäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero wactsa viudanam chärir, ishcay ichishag cobripita wallcalla väleg gellayninta cäjaman wiñargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tsayta Señor Jesucristo ricaycurmi, discïpuluncunata gayasquir nirgan: “Rasuntam niyag: Llapan runacuna wiñäyanganpitapis mas atscatam tagay wactsa viuda Dios Yayata garashga. ");
INSERT INTO qxnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pero waquincagcunaga alläpa cayäpunganpita sobragllatam garayargon. Cay viudaga alläpa wactsa caycarpis, cawananpag llapan capungantam Dios Yayata garargon.” ");
INSERT INTO qxnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Templupita Señor Jesucristo yargoycaptinnam, juc discïpulun nirgan: “Maestru ¡cay templu pergashgachöga caytsicasag rumicuna! ¡Cay templuga alläpa shumagmi jatusag wajicunawan!” ");
INSERT INTO qxnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Señor Jesucristonam nirgan: “Cay ricaycangantsic jatusag wajicunawan jatuncaray templu jancat juchuptinmi ni juc rumillapis canan pergaraycanganchöga quëdangatsu. Llapanmi juchurnin jancat ushacäyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Señor Jesucristo templupag tsaynö nirmi, wac tsimpa Olïvos niyangan jircaman aywarnin chaycur jamargan. Tsaychönam discïpuluncuna Pedro, Santiago, Juan y Andrés quiquillancuna tapurnin niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Maestru, willaycayämay. ¿Imaytan templu tsaynö jancat juchurnin ushacanga? ¿Ima señalcunawantan musyayäshag yachatsicungayquicuna cumplinan wata chämunganta?” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Señor Jesucristonam nirgan: “¡Cuidädutag pipis engañayäshunquiman! ");
INSERT INTO qxnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tsay watacunachömi atscag runacuna llullacur puriyanga: ‘Nogam Diospa Tsurin Cristo cä’ nir. Tsaynö nirmi, atscag runacunata engañayanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Runacunam willayäshunqui: ‘Guerrachöshi caycäyan’ o ‘Guerram canga’ nirnin. Tsaynö willayäshuptiqui ama mantsacäyanquitsu. Tsaynömi rasumpa canga. Pero tsaycuna llapan päsaptinpis, cay patsaga manaragmi ushacangaragtsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tsaynöllam llapan nacincunachö jucclä naciuncunawan pelearnin, wañutsinacuyanga. Guerrachömi juclä caru marca runacunawan cayanga. Maytsaychöpis alläpa mantsacaypagmi patsa cuyurnin mallagäcuy watacuna canga. Tsaynö captinmi, imayca geshyag warmi geshpicunan öra ñacarnin sufringannö, tsay runacuna ñacarnin sufrir gallariyanga. Pero tsaycunaga gallananllaragmi canga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Tsaymi gamcunaga wiyag wiyag alcäbu caycäyanqui. Runacunam autoridäcunaman apatsiyäshurniqui, goricäyänan wajicunachö alli astayäshunqui. Reycunapawan mas mandacug autoridäcunapa puntancunamanmi, nogata serviyämangayquiraycu apayäshunqui. Tsaychömi llapan yachatsiyangagcunata imayca testïgünö willacuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Maytsay naciuncunapa aywarmi, Dios Yayapa Alli Willacuyninta yachatsicuyanga cay patsa manarag ushacaptin. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tsaynö prësu achcuyäshurniqui, autoridäcunaman apayäshuptiqui, imanö parlayänayquipagpis ama yarpachacuyanquitsu. Parlayangayqui öra quiquin Dios Yaya munanganllata imatapis parlayanqui. Tsaynöga parlayanqui Espïritu Santo yachatsiyäshungayquillata. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Nogata gatiyämanganraycum runacuna quiquincunapa waugencunata autoridäcunaman wañutsiyänanpag apayanga. Waquinnam quiquinpa tsurincunata wañutsiyänanpag apayangan. Tsurincunam chiquirnin, taytancunatawan mamancunata wañutsiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tsaynöllam llapan runacuna chiquiyäshunqui. Pero pipis alli tsaracurnin firmi criyicur wañunganyag nogata servimagnïga, wañurpis salvacarmi infiernumanga aywanganatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Gamcuna, Judeachö täcugcuna, Dios Yayata adorayänan sagrädu sitiuchö imaypis mana churarangannö mantsaypag ïdolota ricarga, tsincacug jircacunapa geshpicur aywacuyanqui. (Tsayta liyigcagga shumag entendicuyay.) ");
INSERT INTO qxnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tsaynöta ricäyangayqui junag waji jananchö caycarga, ama imayquicunata jurgogpis waji rurinman yaycuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chacrayquicunachö caycarga, ama ni llatapayquicunata jurgog wajiquicunaman cutiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Allau, tsay junagchö geshyag warmicunawan llulluta chuchuycag warmicuna! ");
INSERT INTO qxnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tsaynö geshpir aywacuyänayqui mana alalay tamya tiempuchö cananpag, Dios Yayaman mañacuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tsaychömi runacuna alläpa mantsacaypag ñacarnin sufriyanga. Dios Yaya patsata camangan örapita runacuna mana imaypis sufriyanganpita masmi ñacarnin sufriyanga. Tsaynö ñacay sufrimientuga mananam ni imaypis mas canganatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tsay ñacar sufriy junagcuna pöculla cananpag, Dios Yaya mana dispöniptinga, llapan runacunam jancat ushacasquiyanman. Pero acrangancag criyicug runacunata Dios Yaya cuyarnin llaquiparmi, mana llapan ushacäyänanpag tsay ñacayta päratsinga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tsaypunga sïcush pipis niyäshunqui: ‘Diospa Tsuringa caychömi caycan o tagaychömi caycan’ nir. Tsaytaga ama criyiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tsay tiempum runacuna llullacur niyanga: ‘Diospa Tsurin Cristom cä, o Diospa Palabrantam yachatsicü’ nirnin. Imayca milagrucunatawan señalcunatam llullacuynincunawan rurayanga, Dios Yaya acrangan criyicug runacunatapis engañayänanpag. Pero tsay firmi criyicugcunataga manam engañaynincunata puediyangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tsaymi wiyag wiyag alcäbu caycäyanqui. Gamcuna musyayänayquipagmi canan llapan päsananpagcagta willayag. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pero tsay alläpa sufrir ñacay tiempu päsasquiptinmi, ‘rupaywan quillapis manana atsicyäyanganatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Goyllorcunapis cielupitam shicwayämunga. Cieluchö caycagcunapis llapanmi cuyupacuyanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Tsaychönam poderöso cayninwan imayca rupay chipacyagnörag cielupita pucutay rurinchö Diospa Tsurin shamuycagta ricäyanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Patsaman shamurmi, angelnincunata mandanga maytsaypa aywar llapan entëru munduchö naciuncunapitapis, Dios Yaya acrangancag runacunata goriyämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Cay ejemplupita gamcuna yachacuyay. Ïgospa yuran tsegllir gallaycuptinmi, musyayanqui achay usya tiempu chämunganta. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tsaynöllam canan willayangagcunata wiyarnin, musyayanqui Diospa Tsurin shamunanpag ichicllana faltanganta. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rasuncagtam niyag: Canan cawaycag runacuna manarag wañuyaptinmi, llapan willacungäcuna cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cielupis patsapis ushacangam. Pero noga parlangäga llapanmi mana juc faltar cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Imay junagwan imay öra tsay willacungä cumplinantaga ni cieluchö caycag angelcunapis ni Diospa Tsurinpis ni pipis manam musyayantsu. Tsaytaga quiquin Dios Yayallam musyan. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","¡Wiyag wiyag alcäbu cayay! Tsaynö cay patsaman cutimunä junagta mana musyaycarga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Diospa Tsurin cutimunanga imayca wajiyog runa caru marcata aywacugnömi canga. Wajiyog servignincunata gayasquir, cada ünuta aruynincuna entregaycur, täpacugtapis yätsiycurnin aywacungannömi canga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Tsaynöllam patsa goyaycaptintsurag o pullan pagastsurag o alleg gällu cantay öratsurag o patsa warämungan öratsurag tsay wajiyog imay örarag cutimunga mana musyaycaptiqui. Tsaynöllam gamcunapis wiyag wiyag alcäbu caycäyanqui. Mana musyayangayqui öram tsay wajiyog runa cutimunga. ");
INSERT INTO qxnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","¡Cuidädutag cutimurnin, puñucashga mana shuyaraycäyagta tariyämushunquiman! ");
INSERT INTO qxnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gamcunata niyangagnöllam, llapantapis caynö nï. ¡Imaypis ricchagnö alcäbu caycäyanqui!” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tsaypitanam levadürannag tanta micuyänan Pascua semäna gallananpag ishcay junagllana faltaycaptin, Señor Jesucristota yachayllapa prësu achcusquir wañutsiyänanpag mayor sacerdöticunawan ley yachatsicugcuna yachatsinacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tsaynö yachatsinacurmi ninacuyargan: “Pascua semänachöga ama wañutsishuntsu. Maytsicag runacuna piñasquirga, alborotarnin imaycatapis rurascamashwan” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsaypitanam Betania marcaman, Señor Jesucristo aywarnin lepröso niyangan Simónpa wajinchö micuycargan. Tsaymannam juc warmi alabastro niyangan rumipita frascuchö shumag mushcug alläpa chaniyog perfümita apamurgan. Tsay alläpa mushcug perfümiga nardo niyanganmi cargan. Tsaypitan warmiga alabastropita frascuta paquirnin quichasquir, Señor Jesucristopa umanman perfümita wiñargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tsayta ricaycurnam runacuna piñacurnin niyargan: “¡Imapagtan cay alläpa chaniyog aceitita perdetsin! ");
INSERT INTO qxnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Caypa mushcug aceitipa chaninga juc watachö runapa jornalninnömi. ¡Tsaytaga mas bien wactsacunata yanapanapag ranticushwan cargan!” nirmi, tsay warmita piñapäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tsaynö piñacuyaptinmi Señor Jesucristo nirgan: “Ama cay warmita piñapäyaytsu. Alläpa shumag allitam nogapag ruraycan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wactsacunawanga pagtam imaypis cayanqui munayangayqui öra yanapayänayquipag. Pero nogaga mananam gamcunapa puntayquicunachö caycäshagnatsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmiga llapan puedinganwanmi nogapag rurashga. Cay perfümita jichamunganwanmi pampayämänanpag listotsaycäman. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rasuncagtam niyag: Dios Yayapa Alli Willacuyninta entëru munduchö yachatsicur willacugcunam maytsaypa aywarnin, cay warmi perfümita umäman wiñämunganta willacuyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tsaypitanam Señor Jesucristopa discïpulun Judás Iscariote traicionananpag mayor sacerdöticunaman aywar nirgan: “Señor Jesucristota regetsiyäshayqui prësu achcuyänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tsayta wiyaycurnam sacerdöticuna alläpa cushishga gellayta pägayargan. Tsaynö pägasquiyaptinnam Judás Iscariotega Señor Jesucristo japallan canganyag örata shuyarargan regetsinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tsaypitanam levadürannag tantata micuyänan semäna gallanan Pascua puntacag junagna cargan: Tsay Pascua junagchömi wata wata judiucuna üshacunata pishtar micuyag. Tsaymi Señor Jesucristota discïpuluncuna tapuyargan: “¿Maychötan canan pascua micuyta micunapag preveniyäshag?” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tsaypita ishcay discïpuluncunata mandarmi, Señor Jesucristo nirgan: “Jerusalénman aywarmi juc runa puyñuwan yacuta apaycagta tariyanqui. Tsay runata gatirnin aywayanqui, ");
INSERT INTO qxnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","wajiman yaycunganyag. Wajiman yaycusquirnin wajiyogta niyanqui: ‘Maeströcunam nirun: “¿Maygancag cuartoyquichötan canan Pascua micuyta discïpulücunawan micushag?” ’ ");
INSERT INTO qxnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wajiyognam altuschö juc jatun cuarto nogantsicpag alistashga caycagta ricatsiyäshunqui. Tsaychö preveniyanqui llapantsic micunapag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tsaypitanam ishcan discïpuluncuna aywayargan. Jerusalénman chärirnam, Señor Jesucristo ningannölla tarisquir, Pascua micuyta micuyänanpag alistayargan. Tsaynö llapanta shumag alistar ushasquirmi, Señor Jesucristoman cutiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Patsa tutapaycaptinnam, Señor Jesucristowan chunca ishcay discïpuluncuna tsayman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mësachö micuycäyaptinnam Señor Jesucristo nirgan: “Rasuncagtam niyag: Caychö nogawan pagta micuycangantsicpitam maygayquicarpis jucniqui traicionayämar chiquimagnïcunaman ranticayämanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tsaynö niptinnam, discïpuluncuna llaquishga llapan juc jucpa tapurnin niyargan: “Tsaypunga ¿nogatsurag cä Señor?” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tsaymi Señor Jesucristo nirgan: “Caychö chunca ishcay caycäyangayquipita jucniquim nogawan pagta juc matillachö tantata tullpur micuycag traicionamarnï chiquimagnïcunaman ranticamar entregamanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Diospa Palabranchö gellgashga caycag cumplinanpagmi, Diospa Tsurinta runacuna wañutsiyanga. Pero ¡Allau traicionarnin tsay ranticug runa, mejorga ama yurinmantsu cargan!” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tsaynö micuycäyaptinnam, Señor Jesucristo tantata achcurcur Dios Yayaman mañacusquirnin, paquisquir discïpuluncunata macyar nirgan: “Cayta micuyay. Cayga nogapa cuerpömi.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsaypitanam cöpachö caycag vïnota achcurcur, Dios Yayaman mañacusquirnin discïpuluncunata macyargan. Discïpuluncunanam llapan upyatsinacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tsaypitanam Señor Jesucristo nirgan: “Cayga nogapa yawarnïmi. Dios Yaya mushog promësawan änicungannömi, yawarnïta jicharnin wañushag, atscag runacunata salvanäraycu. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rasuncagtam niyag: Üvapita vïnota mananam upyashagnatsu cieluchö Dios Yayapa Mandacuy Reynonchö caycar mushog vïnota upyangäyag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tsaypitanam Dios Yayaman mañacurnin cantasquir, Señor Jesucristo discïpuluncunawan Olïvos niyangan jircaman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tsayman chärirnam Señor Jesucristo nirgan: “Canan pagasmi manana confiacayämar jagescayämar llapayqui aywacuyanqui. Diospa Palabranchömi nirgan: ‘Üsha mitsicugta wañuscatsiptïmi, llapan üshancuna wacpa caypa witsicar jancat aywacuyanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero wañutsiyämanganpita Dios Yaya cawascatsimaptinnam, Galileaman puntayquicunata aywashag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Señor Jesucristo tsaynö niptinnam, Pedro nirgan: “Waquincagcuna jagesquirniqui aywacuyaptinpis, nogaga manam dëjashayquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Señor Jesucristonam nirgan: “Pedro, rasuntam nig: Canan pagasmi gällu manarag ishcay cuti cantaptin, quiquiqui quimsa cuti ‘Manam regëtsu’ nimar nëgamanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero Pedronam jinchi nirgan: “Aunqui gamtawan pagta wañutsiyämänan captinpis, manam ni imaypis dëjashayquitsu.” Tsaynöllam llapan discïpuluncunapis niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsaypitanam Getsemani niyangan wertaman aywayargan. Tsaychönam discïpuluncunata Señor Jesucristo nirgan: “Gamcunaga cayllachö jamaycayay. Noganam mas washaläman aywar, Dios Yayaman mañacushag.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tsaypa aywarmi discïpuluncuna Pedrotawan Santiagota y Juanta pushargan. Tsaychömi alläpa mantsacurnin llaquicur, ");
INSERT INTO qxnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","quimsan discïpuluncunata nirgan: “Shongömi imayca wañunagnörag alläpa llaquicun. Gamcunapis riccharnin cayllachö caycäyay.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tsaynö nisquirnam washaläman aywarnin gongoricuycur, Dios Yayaman mañacurgan tsay alläpa ñacay payman mana chämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tsaychö mañacurmi nirgan: “Taytallä, gampagga manam ni imapis ajatsu. Tsay alläpa ñacaytaga ama ñacashagtsu. Pero gam munangayquinö catsun, ama noga munangänöga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsaynö mañacunganpita cutirnam, quimsan discïpuluncuna puñucashgata tarisquir nirgan: “¿Simón Pedro, puñucashgacu caycanqui? ¿Manacu juc örallapis ricchayta puedirgoyqui? ");
INSERT INTO qxnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Riccharnin Dios Yayaman mañacuyay, Satanas jutsaman mana ishquitsiyäshunayquipag. Allita rurayänayquipag voluntäniquicuna captinpis, pero imayca mana callpannagnömi ruraytaga puediyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tsaypita Señor Jesucristo cutisquirnam, puntata mañacungannölla yapay Dios Yayaman mañacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Discïpuluncunaman yapay cutiycurnam, puñucashga caycagta tarirgan. Alläpa puñuy venceptinmi, puñucashga caycäyargan. Señor Jesucristota ricaycurnam, pengacurnin ni ima niytapis puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tsaypita Señor Jesucristo yapay mañacug aywanganpita cutisquirnam, discïpuluncunata nirgan: “¿Cananyagcu puñurnin shütaycäyanqui? ¡Tsayllapagnam! Öra chämushganam jutsasapa runacuna Diospa Tsurinta traicionarnin prësur achcusquir apayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Shäriyämuy! ¡Acuna! ¡Nogata traicionamar ranticamagnï runaga tsiytanam shamuycan!” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tsaynö parla manarag ushaptinmi, discïpulun Judás alli espädancunawan tucruncunawan atscag runancuna pushashga chargan. Tsay atscag runacunataga mas mandacug sacerdöticunawan ley yachatsicugcuna y waquincag mandacugcunam cachayargan, Señor Jesucristota prësu achcuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Señor Jesucristota regeyänanpagmi, traicionagnin Judás yachatsishga cargan: “Puntarnin saludar mutsangämi canga. Payta achcusquir prësu apayämunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Señor Jesucristopa puntanman Judás chaycurnam saslla: “Maestrullä” nir, gagllanchö mutsaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsaynö regescatsiptinmi Señor Jesucristota achcusquir, prësu apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsaychö juccag discïpulunnam espädanta jipisquir, mayor sacerdötipa servigninpa rinrinta jipicat wallusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Prësu achcusquiyaptinnam, Señor Jesucristo nirgan: “¿Gamcunaga espädayquicunawan tucruyquicunawan shayämunqui, imayca suwatanö prësu apayämänayquipagcu? ");
INSERT INTO qxnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gamcunawanga waran waranmi yachatsicur templuchö caycargä. ¿Tsaychö caycaptïga imanirtan prësu achcuyämargayquitsu? Pero Diospa Palabranchö gellgashga caycag cumplinanpagmi, canan achcusquir prësur apayämanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tsay örallanam llapan discïpuluncuna Señor Jesucristota jagesquirnin geshpir aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tsaychömi juc jöven Señor Jesucristota säbanaswan pitucushgalla gatirgan. Tsay jöventam runacuna achcuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tsay jövenpis pitucushganpita ullusquirmi, garashtulla geshpirnin aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsaypitanam Señor Jesucristota mayorcag mas mandacug sacerdötipa wajinman apayargan. Tsay wajimanmi mayorcag sacerdöticunawan waquincag autoridäcuna y ley yachatsicugcunapis goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedronam Señor Jesucristota carullapa gatirnin, mayorcag sacerdötipa wajinpa patiunyag yaycurgan. Tsayman yaycusquirnin wardiacunawan jamarmi, nina rupaycagchö mashacuycargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tsaypitanam Señor Jesucristota wañutsiyta munarnin, mayorcag sacerdöticunawan waquincag autoridäcuna runacunata paypa contran parlayänanpag ashiyargan. Pero tsaynö ashirpis contran parlayänanpag testïgucunata manam tariyargantsu. Tsaynöllam Señor Jesucristopa ni ima jutsantapis tariyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Señor Jesucristopa contran atscag runacuna parlarpis, jucta juctam niyargan; pero mana rasumpacagta levantarnin parlarpis manam acuerdutsu cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Waquincagcunanam llullacurnin Señor Jesucristopa contran parlar niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nogacunam cay runa parlanganta wiyayargä: ‘Runa rurangan templuta juchuscatsirmi, quimsa junagllata sharcatsishag. Tsaymi tsay rurangä templuga runacuna rurangannötsu canga’ nigta.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tsaynö acusarpis manam acuerdutsu cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsaymi mas mandacugcag sacerdöti goricashgacunapa rurinpita sharcur, Señor Jesucristota tapurgan: “¿Manacu ni imapis ninqui caynö contrayqui parlayaptin?” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tsay mas mandacug sacerdöti tsaynö niptinpis, Señor Jesucristoga upällalla carmi ni imatapis contestargantsu. Mayorcag sacerdötinam yapay tapurgan: “¿Gamga poderöso Dios Yayapa Tsurin Cristocu canqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Señor Jesucristonam nirgan: “Aumi, tsaynömi noga cä. Diospa Tsurintam ricäyanqui, poderöso Dios Yayapa derëchucag lädunchö jamaycagtawan pucutay rurinchö cielupita shamuycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tsaynam mayorcag sacerdöti alläpa piñacurnin, llatapantapis rachisquir nirgan: “¡Mananam ni ima testïgucunatapis wanantsicnatsu! ");
INSERT INTO qxnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wiyayangayquinöpis, cay runaga Diosnintsicpa contran parlarmi burlacurgon. ¿Caytaga imanaycuntsictan?” Tsaymi llapan runacuna juc shimilla gayaycachar niyargan: “¡Cay runaga Diosnintsicpa contran parlarnin burlacunganpita wañutsun!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tsaynam waquincag runacuna togapurnin ñawinta tsaparcur cutar niyargan: “Mä, pi cutar magashungayquitapis willayämay.” Tsaynöllam wardiacunapis Señor Jesucristota gagllanchö lagyarnin geruwanpis magayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tsaynö Señor Jesucristota magayangan öram Pedropis ruri patiuchö caycargan. Tsaymi mas mandacugcag sacerdötipa servignin warmi witiycur, ");
INSERT INTO qxnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro ninachö mashacuycagta ricapaycurnin nirgan: “Gampis tagay Jesús Nazaret runawan purigmi canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tsaynö niptinnam Pedro nirgan: “Tagay runataga manam regëtsu. Imatachari parlacunquipis” nisquirmi, wagta puncuman yargosquirgan. Tsaychö caycaptinnam gällu cantasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Puncuchö Pedro shaycagta tsay servicug warmi ricaycurnam, waquincunata nirgan: “Tagay runaga Jesúspa gatiragninmi.” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedronam yapay juc cuti Señor Jesucristota mana regegtucurnin nëgargan. Ichic rätunllatanam tsaychö shaycag runacuna Pedrota niyargan: “Gamga Jesúspa gatiragnin, ¡Galileapita runam canqui! ¡Galileapitanömi parlanquipis!” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedronam juracurnin nirgan: “¡Tsay runataga manam regëtsu! ¡Llullacuptïga, quiquin Dios Yaya castigamarnï condenamätsun!” ");
INSERT INTO qxnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tsaychö juraycaptinllarag yapay gällu cantasquiptinmi, Pedro yarpasquirgan Señor Jesucristo ninganta: “Gällu manarag ishcay cuti cantaptinmi, quimsa cuti mana regemagtucunquitsu.” Tsayta yarpasquirmi, alläpa llaquicurnin Pedro wagargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsaypitanam patsa atsicyaycämuptin, mayorcag sacerdöticunawan autoridäcuna y ley yachatsicugcuna waquincag mas mandacugcuna goricasquir, acuerduta rurayargan. Tsaynam Señor Jesucristota watarcur, Pilatoman apatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatonam Señor Jesucristota tapurnin nirgan: “¿Gamga judiucunapa mandacug reynincu canqui?” Señor Jesucristonam nirgan: “Aumi, gam ningayquinöllam cä.” ");
INSERT INTO qxnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tsaynam mayorcag sacerdöticuna tucuyläyapa acusarnin levantar shimpiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tsaymi Pilato yapay tapurgan: “Wiyay tsayläya levantar acusayäshungayquita ¿manacu imapis ninqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Señor Jesucristo mana contestaptinnam, Pilato mantsacashga yarpachacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wata watam cada Pascua semänachö, Pilato yachacashgana runacuna mañayangan prësuta gargog. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tsaychömi Barrabas niyangan runa yanagencunawan carcelchö yaycuraycäyargan. Paycunaga Roma gobiernopa contran alborotita rurarmi, wañutsicushga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tsaymi atscag runacuna goricasquir, Pilatota mañayargan costumbrincunamannö juc prësuta gargonanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatonam tapurgan: “¿Judiucunapa mandacug reynin, Jesústacu gargonäta munayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatoga tsaynö nirgan, mayorcag sacerdöticuna chiquirnin, Señor Jesucristota apayämunganta musyarmi. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero mayorcag sacerdöticuna yachatsishga cayaptinmi, llapan runacuna juc shimilla gayaycachar: “Ama paytaga gargoytsu, mas bien Barrabasta gargonayquitam munayä” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tsaynö niyaptinnam Pilato nirgan: “¿Judiucunapa reynin niyangayquita imatatan rurashag?” ");
INSERT INTO qxnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Runacunanam gayaycachar: “¡Paytaga crucificar wañutsiy!” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatonam yapay tapurgan: “Wañunanpagga ¿ima mana allitatan rurashga?” Pero llapan runacunanam mas jinchi gayaycachar niyargan: “¡Cruzchö wañutsiy!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsaypitanam judiucunawan Pilato alli cayta munarnin, Barrabasta gargosquir Señor Jesucristota alli astaycatsirnin Roma soldäducunata entregargan cruzman clävar wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tsaypitanam soldäducuna Señor Jesucristota apayargan Pilatopa palacion patiu rurinman burlacur maltratayänanpag. Tsayman llapan soldäducunata gayascatsirmi, ");
INSERT INTO qxnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Señor Jesucristota puca cäpata shucurcatsir, cashapita coröna awashgata umanman churayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsaymi alläpa burlacurnin: “¡Vïva judiucunapa reynin!” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tucruwan umachö atsca cuti wirurmi, togapurnin ushayargan. Puntanman gongoricurmi, burlacurnin adoragtucuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tsaynö burlacurnin alli maltratasquirmi, puca cäpata llushtiscatsir, quiquinpa llatapanta shucurcatsirnin crucificag apayaragan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tsaynö apaycarnam, juc runa chacrapita shamuycagta ricäyargan. Tsay runatam soldäducuna mandayargan: “Cay cruzta apay.” Tsay runaga Cirene marcapita Alejandropawan Rufopa taytan Simón shutiyogmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tsaynam Golgota niyangan jircaman, Señor Jesucristota chäratsiyargan. (Golgotaga uma tullu Calavera sitiu ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tsaychönam mirra niyanganta vïnoman wiñarcur, Señor Jesucristo upyananpag goyargan, pero Payga manam upyayta munargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tsaypitanam Señor Jesucristota cruzman clävasquiyargan. Llatapanta raquipunacuyänanpagmi soldäducuna sortiyayargan: “Mä, maygan llatapanshi nogapag canga” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Señor Jesucristota cruzman clävayangan öraga, las nuevenönam cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Imapita wañutsiyanganta runacuna musyayänanpagmi, juc letrërota gellgarcur cruzpa puntanman churayargan: “CAYMI JUDIUCUNAPA REYNIN” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Señor Jesucristopa ishcanläninmannam, ishcag suwacunata cruzcunaman clävayargan. Juccagta derëchuncagman y juccagtana itsogcagläninman churayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tsaynömi cumplirgan, Diospa Palabranchö gellgashga caycag: “Jutsasapacunawanmi, Diospa Tsurin yupashga cangan.” ");
INSERT INTO qxnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tsaypa päsagcunanam Señor Jesucristo cruzchö clävaraycagta ricar, cushiparnin asipar niyargan: “¡Gamga: ‘Diospa templunta juchuscatsir, quimsa junagllatam sharcatsishag’ nirgayqui! ");
INSERT INTO qxnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tsaynö puedig caycarga, mä mana wañunayquipag salvacurnin cruzpita yarpamuy” nir. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tsaynö burlacurmi, mayorcag sacerdöticunawan ley yachatsicugcuna quiquincuna pura ninacuyargan: “Juccunataga salvargan. Pero quiquinga manam salvacuyta puedintsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si israelcunapa mandacug reynin Diospa Tsurin Cristo rasumpa carga, mä cruzpita yarpamutsun. Tsayta ricarmi sïga rasumpa criyishun.” Tsaynöllam lädunchö clävaraycagcunapis, yapay yapay Señor Jesucristota burlacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tsaypitanam pullan junagpita asta las tres de la tardiyag patsa jancat tutapasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Las tres de la tardinam parlayninchö Señor Jesucristo jinchi gayaraypa nirgan: “Eloi, Eloi ¿lema sabactani?” Tsayga “Dios Yayä, Dios Yayä ¿imanirtan dëjascamargoyqui?” ninanmi. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tsaynö ninganta, tsaychö caycagcuna wiyarmi: “¡Wiyayay! Unay Elíastam gayaycan” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Juc runanam cörrilla aywar, puchgog vïnochö esponjata tullpurcur, tucrupa puntanman watarcurnin, Señor Jesucristopa shiminman shogonanpag churargan: “Dëjayay. ¿Mä, shuyay ricäshun, Elías shamungacush cruzpita yarpatsimunanpag?” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsaymi Señor Jesucristo jinchi gayarasquir wañusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tsay öram templu rurinchö shumag awashga cortïna altupita uraypa ishcayman rachisquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldäducunapa capitanninmi cruzpa frentinchö caycar, Señor Jesucristo gayarar wañugta ricarnin: “¡Cay runaga Diospa rasumpa Tsurinmi canag!” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tsaynöllam warmicunapis carullapita Señor Jesucristo wañunganta ricaraycäyargan. Tsay warmicunaga María Magdalenawan, Santiago menor niyanganpa y Josépa maman Maríawan Salome y mas juc warmicunam cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tsay warmicunaga Galilea marcachömi, Señor Jesucristota gatirarnin serviyargan. Paycunawan mas atscag warmicunam, Señor Jesucristota gatirnin Jerusalénman shayämushga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsaypitanam tardiyasquirgan. Tsayga Pascua junagpag alistacuyänan despiranam cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tsaychömi Arimatea marcapita José shutiyog cargan, autoridämajincunachöpis juc respetashga runa. Payga Señor Jesucristoman criyicurmi, Dios Yayapa Mandacuy Reynonta shuyarargan. Tsay runam valoracurcur, Pilatoman yaycusquir Señor Jesucristopa ayanta pampananpag mañargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatonam quiquillanchö yarpargan: “Manaragchi wañusharagtsu canman.” Soldäducunapa capitanninta gayasquirmi tapurgan: “¿Jesúsga wañushganacu?” ");
INSERT INTO qxnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tsay capitan “Wañushganam” niptinmi, Joséta ordennin Pilato entregargan Señor Jesucristopa ayanta pampananpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tsaymi juc jatun shumag säbanasta rantisquir aywarnin, Señor Jesucristopa ayanta cruzpita yarpuscatsir piturgan. Tsaypita aparmi gagachö sepultüra uchcushgaman pamparnin, puncunta juc jatun parara rumiwan tsapargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalenawan Josépa maman Maríam, mayman pampayangantapis ricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jamay sabado junag päsasquiptinnam, costumbrincunanö María Magdalenawan Santiagopa maman María, Salomewan mushcug perfümicunata rantiyargan, Señor Jesucristopa ayanta shupayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo allegllana rupay yargaycämuptinmi, tsay warmicuna Señor Jesucristo pamparangan sepultüraman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tsayman chaycarnam: “¿Cananga pirag puncuta tsaparag jatun parara rumita wititsinga?” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero tsayman chaycurnam, sepultürapa puncun tsaparag tsay jatuncaray rumi juclächö caycagtana tarisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sepultüra rurinman yaycusquirnam, chaquinyag yurag püru llatapashga jöven derëchucag läduchö jamaycagta ricäyargan. Tsay warmicunanam alläpa mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tsay jövennam nirgan: “Ama mantsacäyaytsu. Cruzchö wañutsiyangan Jesús Nazaret runatacu ashiyanqui. ¡Cawamushganam! Payga mananam caychönatsu caycan. Masqui cayman churayangantapis ricäyay. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Canan gamcuna aywarnin, Pedrotawan llapan discïpuluncunata willar niyanqui: ‘Señor Jesucristosh puntayquicunata Galileaman aywaycan. Puntata willacungannöllam, paytaga Galileachöna tariyanga.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jöven tsaynö niptinnam, warmicuna tsuctsucyarrag mantsacashga geshpignörag sepultürapita aywacuyargan. Tsaynö alläpa mantsacashga carmi, lluta runacunataga ni imatapis willayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tsay domingo alleg Señor Jesucristo cawamushga carmi, María Magdalenatarag puntata yuripurgan. Paypitam mas puntata ganchis supaycunata Señor Jesucristo gargoshga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María Magdalenanam aywar discïpuluncunata willargan, Señor Jesucristo cawamushga canganta. Discïpuluncunaga llaquirnin wagaychömi caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Señor Jesucristo cawaycagta ricanganta María Magdalena willacuptinpis, manam criyiyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsaypitanam ishcag discïpuluncuna tsunya nänipa aywaycäyaptin, Señor Jesucristo yuripusquirgan. Paycunaga Señor Jesucristota jucläya mana regëpagnö captinmi regeyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsaynö Señor Jesucristo canganta regesquirmi, waquincagcunaman aywarnin willayargan. Pero tsay ishcantapis manam criyiyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsaypitanam chunca juc discïpuluncuna micuycäyaptin, Señor Jesucristo yurisquir piñapar nirgan: “¿Imanirtan chucru shongo cayniquicunawan gamcuna nogaman criyiyanquitsu? Ricämagniycuna willayäshuptiquipis, manam cananyagpis cawamushga cangäta criyiyanquiragtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tsaypitanam discïpuluncunata yätsirnin nirgan: “Aywayay entëru munduchö maytsay naciuncunapa Dios Yayapa llapan Alli Willacuyninta willacuyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipis rasumpa firmi criyicurnin bautizacurga salvacangam. Pero mana criyicugcagtaga Dios Yayam condenanga. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tsaynö firmi criyicug runacunam milagrucunata rurayanga, Dios Yaya cachamunganta rasumpa musyayänanpag. Podernïwanmi supayyog runacunapita supaycunata gargoyanga. Mana yachayangan parlaycunachömi parlayangapis. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Vïboracunata achcuyaptin o venënota upyayaptinpis, manam imanäyäshunquitsu. Geshyaycagcunaman maquincunata churayaptinmi cuticäyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tsaynö discïpuluncunata yätsisquiptinmi, Señor Jesucristota Dios Yaya cieluman apacurgan. Tsaychönam Dios Yayapa derëchucag lädunman jam argan. ");
INSERT INTO qxnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tsaypitanam discïpuluncunanam maytsay naciuncunapa aywarnin, Señor Jesucristo yachatsicunganta willacuyargan. Dios Yayapis milagrucunata rurarmi yanapargan, Señor Jesucristo willacungancunawan cawamungan rasumpa canganta llapan runacuna criyirnin musyayänanpag. Tsaynö catsun.");
INSERT INTO qxnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cay patsachö Diospa Tsurin Señor Jesucristo cawangantam atscag runacuna gellgayayta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tsay gellgayanganga discïpuluncuna yachatsimangantsicnöllam. Paycunam Señor Jesucristowan pagta purirnin, gallanganpita wiyashga y ricashga car, Diospa Palabranta willacur rasumpa servignin cayan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tsaymi nogapis discïpuluncuna yachatsicuyanganta wiyarnin gellgayangancunata leyishga car, gallananpita llapanta allipa musyarnin, alläpa cuyay respetashga Teofilo gamman llapan shumag musyangäta gellgamü. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tsaynöpam gampis cayta leyirnin següru musyanqui, yachatsiyäshungayqui rasumpa alli canganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea provinciachö Herodes rey caycaptinmi, juc sacerdöti Zacarias shutiyog cargan y warminpanam Isabel shutin cargan. Ishcanpis Dios Yayata servig unay sacerdöticunapa ayllun: Zacarias Abiaspa, Isabelna Aaronpa. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ishcanpis Dios Yaya mandacungancunata firmi cäsucurmi, alli rurag cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero manam wamrancuna cargantsu, Isabel gollog captinmi ishcanpis yashgayäcushgana cayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tsaypitanam juc cuti Zacariasta, sacerdötimajincunatawan templuchö Dios Yayata serviyänan töcargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Costumbrincunamannö sacerdöticuna sortiyayaptinmi, Zacariasta töcargan altarchö incienciuta goshnïtsinanpag. Tsaymi templuchö ruri sagrädu cuartoman yaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tsay cuartochö incienciuta goshnïtsinganyagnam, wagtachö atscag runacuna Dios Yayata adorarnin mañacur caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsaynö caycaptinnam, incienciuta goshnïtsiyänan altarpa derëchucag lädunchö Dios Yaya cachamungan angel yuripurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angelta ricaycurnam, Zacarias alläpa mantsacar ni imanö caytapis puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero angelnam nirgan: “Zacarias, ama mantsacaytsu. Dios Yayam wiyashga mañacungayquicunata. Warmiqui Isabelchömi juc ollgo tsuriqui yuringa. Paypa shutinmi ‘Juanta’ churanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tsuriqui yurisquiptinmi, alläpa cushicunqui y waquincunapis alläpam cushicuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Dios Yayapa puntanchöpis mas alli rurag runam canga. Manam imaypis vïnotawan washcuta ni juc machätsicug trägucunata upyangatsu, manarag yuringanpita Espïritu Santowan cashgana car. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pay yachatsicuptinmi, Dios Yayata atscag Israel runacuna yapay cäsuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Diospa Tsurin shamunanpagmi, Espïritu Santopa poderninwan unay profëta Elíasnö willacunga. Tsaynö yachatsicuptinmi, taytancunawan tsurincuna alli päsacuychö cawayanga. Puntata mana cäsugcunam, Dios Yayapa yachayninwan imaycatapis allillata rurarnin cäsucuyanga. Tsaynöpam runacuna listuna cayanga, Dios Yayapa Tsurinta alli chasquiyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacariasnam angelta tapurgan: “¿Imanötan tsay nimangayqui canga? Nogaga alläpa auquinnam cä y warmïpis chacwannam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angelnam nirgan: “Nogaga Angel Gabrielmi cä, Dios Yayapa puntanchö servignin. Paymi cachamashga gamta cay alli noticiata willanagpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dios Yaya dispöningan tiempuchömi tsuriqui rasumpa yuringa. Pero mana criyimangayquipitam, asta tsuriqui yuringanyag parlayta puedinquitsu” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tsaynö angel parlapanganyagnam, wagtachö runacuna Zacariasta shuyarar niyargan: “¿Imanöparag sas yargamuntsu?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarias yargosquirnam, shimin mana pashtaptin parlayta puedirgantsu. Runacunanam ninacuyargan: “¡Ruri templuchöchi Dios Yaya imatapis ricätsishga!” Zacariasnam parlayta mana puedirnin, sëñasllapa willacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Templuchö serviyta ushasquirnam, wajinman cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tsaypitanam warmin Isabel geshyag cargan. Pitsga quillam wajillanchö cacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tsaymi nirgan: “Dios Yaya munaptinmi caynö geshyag caycä. Cananga rasumpa cuyacuynintam musyatsimashga, mananam runacuna, ‘Mana wachacug warmi’ nir, musyapäyämanganatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel sogta quillayog geshyag caycaptinnam, angel Gabrielta Dios Yaya cachamurgan Galileachö Nazaret marcaman, ");
INSERT INTO qxnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María niyangan virgenman. Tsay jipashga casarananpag parlashganam cargan, unay rey Davidpa ayllun José shutiyogwan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelnam María caycanganman yurisquir nirgan: “¡Cushicuy, María! ¡Dios Yayapa alläpa cuyay acrashganmi canqui! Quiquin Diosmi gamwan caycan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsaynö angel niptinnam, María mantsacar shongollanchö nirgan: “¡Imanirtan tsaynö angel niman!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angelnam nirgan: “María, ama mantsacaytsu. Dios Yayam cuyarniqui gamta acrashushcanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tsaymi geshyag canqui. Wawayqui yurisquiptinnam, shutin churanqui Jesústa. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Paymi alläpa poderöso canga, cieluchö japallan poderöso Dios Yayapa rasumpa Tsurin car. Paypa unay awilun Davidta mandacug rey churayangannöllam, Señor Jesucristotapis quiquin Dios Yaya mandacug rey cananpag churanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel runacunapa mandacug reyninmi imayyagpis canga. Tsaymi Paypa Mandacuy Reynonga ni imaypis ushacangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tsaypitanam angelta María tapurgan: “¿Imanötan tsay nimangayqui canga, nogaga manarag piwanpis täcuptïga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelnam nirgan: “Espïritu Santom gamman shamurnin, juc wamrata camanga Dios Yayapa poderninwan geshyag canayquipag. Tsay Santo wawayquim cieluchö alläpa poderöso Dios Yayapa Tsurin canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Musyay, prïmayqui Isabelpis chacwan cayninchörag sogta quillana geshyag caycanganta, ‘mana wachacug warmi’ nicäyaptinpis. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tsaymi Dios Yayapagga ni imapis ajatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maríanam nirgan: “Nogaga Dios Yayapa servigninmi callä. Gam nimangayquinö callätsun.” Tsaypitam angel aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tsaypitanam María saslla alistacusquir, Judea marcapa jallganchö prïman Isabelcagta aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacariaspa wajinman yaycusquirnam prïman Isabelta tarisquir saludargan: “¿Yamayllacu caycanqui prïma?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María tsaynö rimaycusquiptinmi, Isabelpa pachanchö wamra cushicurnin cuyurgan. Isabelnam Espïritu Santopa poderninwan ");
INSERT INTO qxnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","jinchipa nirgan: “¡Llapan warmicunapitam Dios Yaya gamta cuyashurniqui bendisar acrashurgoyqui y wawayquipis bendïtom! ");
INSERT INTO qxnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitan nogalla cä, Señorlläpa maman watucaycallämänanpag? ");
INSERT INTO qxnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rimaycamangayquita wiyasquiptïmi, pachächö wamra cushicurnin cuyurgon. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios Yaya nishungayquim rasumpa cumplinga. Tsayta criyirmi, ¡alläpa cushishga cawacunqui!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maríanam nirgan: “Dios Yayatam llapan shongöwan alläpa alabä. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Salvamagnï Dios Yayapagmi yarpaynïchöpis alläpa cushicü. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Umilde alli shongoyog servignin cangätam ricämashga. Cananpitaga llapan runacunam cushishga willanacuyanga, Dios Yaya alläpa cuyamarnï acramanganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios Yayam poderöso cayninwan nogapag llapan allicunata rurashga. Payga Santo carmi, alläpa alli. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mandacuynincunata respetarnin cäsucugcunatam llaquipanga. Tsaynöllam llapan mirag aylluncunatapis llaquipanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Poderöso cayninwanmi imayca ajacunatapis ruran. Orgullöso allitucugcunatam mana välegpag churan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandacugcunatam mandacuyanganpita gargosquir, jormal alli shongoyogcunata mandacuyänanpag churargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wactsacunatanam llapan alli imaycancuna juntanganyag garaycurgan. Pero rïcucunataga mana imannagtan aywacuyänanpag dëjashga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Servignin Israel runacunatam llaquiparnin yanapargan. Tsaynöllam llaquipäcuyninwan cuyacuynintapis gongargantsu, ");
INSERT INTO qxnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","unay awiluntsic Abrahamta äninganta yarpasquirmi, paypita mirag ayllun awiluntsiccunata imayyagpis yanapanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tsaychö María priman Isabelwan quimsa quilla pärasquirnam, wajinman cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsaypitanam Isabelpa quillan pagtasquiptin, juc ollgo wamrata geshyacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tsayta vecïnuncunawan aylluncuna musyasquirmi, Isabelman aywar alläpa cushicuyargan, “Dios Yayam llaquiparnin wawan garaycushga” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tsay wamra semänayog caycaptinnam, pengayninchö señalatsiyargan. Tsaychönam taytan Zacariaspa shutinta churayta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamannam, “¡Manam! Shutinga Juanmi canga” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pero runacunanam niyargan: “¿Imanir? ¡Alluyquicunachöga manatsag ni pipis Juan shutiyogga cantsu!” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsaynö nirmi, Zacariasta sëñasllapa tapuyargan: “¿Tsuriquipa shutin imatatan churanqui?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacariasnam ichic tablata macyayänanpag mañasquir, “Shutinga Juanmi canga” nir, gellgargan. Tsayta liyisquirnam tsaychö runacuna mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tsaypitanam Zacarias jina öra parlarnin gallaycurgan, Dios Yayata alabarnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsaychö llapan vecïnuncunam alläpa mantsacashga cayargan. Tsaymi maytsay Judea jallga estanciacunachö runacuna mantsacashga parlapacuyargan, tsay llapan päsangancunata. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tsayta runacuna wiyasquirnam yarpachacur tapunacuyargan: “Tsay wamraga ¿imanöpagrag canga?” Dios Yayapa alläpa cuyacuy poderninwan caycarga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tsaypitanam taytan Zacarias, Espïritu Santopa poderninwan nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Israel marcamajïcunapa Diosninta agradëcicur llapantsic alabashun! Paymi shamurnin yanapamarnintsic rasumpa salvamashcantsic. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Shamurnin salvamänapagmi Dios Yayapa servignin unay rey Davidpa ayllunchö, juc poderöso Salvador yurinanpag caycan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tsay Salvador yurinanpagmi Diosnintsic änicurnin, unay willacug profëtancunatawan willacatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Conträmarnintsic chiquimagnintsiccunapa maquinpitam jorgor salvamashcantsic. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Unay aylluntsiccunata llaquiparmi, tsay sagrädu änicunganta Dios Yaya canan yarpar cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Unay awiluntsic Abrahamtam Dios Yaya jurarnin nirgan: ‘Diosmi cä. Äningagtam imaypis cumplishag’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tsaymi chiquimagnintsiccunapa maquinpita salvamäshun, Payllatana mana mantsacur servinapag. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pay munangannö allicunallata rurarnin, llapan cawaynintsicchö jutsannag shumag servishun. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Gam llullu wamrallä, cieluchö poderöso Dios Yayapa willacug profëtanmi canqui. Diospa Tsurin shamunanpagmi, puntata aywarnin runacunata alistarnin prevenir willacur, ");
INSERT INTO qxnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ninqui: ‘Israel runacuna jutsa rurayangayquicunapitam, Dios Yaya perdonar salvayäshunqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Poderöso Dios Yayaga alläpa cuyacuyninwanmi llaquipämantsic. Tsaymi yurinanpagna caycan Dios Yayapa Tsurin, imayca rupay yargamugnörag llapanman actsicyar cielupita yachatsimänapag. ");
INSERT INTO qxnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Llapan runacuna tutapaychönö imaypis wañuyta mantsacurnin cawaycagcunatam, imayca actsicyagnörag yachatsinga. ¡Tsaymi quiquin Dios Yaya cushicuy nänipa pushamäshun, shumag alli päsacuychö cawacunapag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tsaypitanam Juan wiñarnin, criyicuyninchö mas firmi tsaracur imaycacunatapis allicunallata rurargan. Tsaynöllam tsunyacunachö täcurgan, Israel runacunata manarag llapanpa puntanchö willacurnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tsaypitanam María geshyacunanpag quillan chaycämuptinna, Cesar Augusto niyangan rey Romachö, maytsay mundupa mandacugnin caycargan. Paymi mandacurgan llapan runacuna censochö apuntacur yupashga cayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cay censotam rurayargan, shutincunata apuntatsir Siria marcachö Cireneo mandacug niyangan gobernador caycaptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Llapan runacunam unay aylluncunapa marcancunaman shutincunata apuntatsig aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tsaynöllam Galileachö Nazaret marcapita, Joséwan Maríapis alläpa caruta aywayargan. Tsay Judeachö Belen marcamanga aywayargan, Josépa unay awilun rey David yurishga captinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joséwan Maríam Belenman apuntacug aywayargan, yupashga cayänanpag. Casarayänanllapagrag parlashga caycarmi, Maríaga geshyacunanpagna caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tsaychö caycäyaptinmi, Maríapa quillan pagtasquiptin geshyacunanpag tsaripucurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Posadacuyänanpag wajita mana tarirmi, wätacuna wataräyänan ramädallachö, llullu ollgo wawanta geshpicurgan. Tsaymi inchanawan piturcurnin, wätacunapa micucuyänanllaman ujuycatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tsay pagasmi Belenpa washaläninchö üshancunata mitsicug runacunapis täpaycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsaymanmi illagpita angel yurisquir, Dios Yayapa poderninwan imayca illagonö atsicyaptin, üshata täpacugcuna mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero angelnam nirgan: “Ama mantsacäyaytsu. Llapan runacunawan cushishga cayänayquipagmi canan willayäshayqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Unay rey Davidpa marcan Belenchömi Salayäshugniqui canan yurishga caycan. ¡Payga Señornintsic Cristom! ");
INSERT INTO qxnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dios Yayapa Tsurin canganta musyayänayquipag, canan aywarmi llullu wamrata tariyanqui, wätacunapa micucuyänanchö inchanawan pitushga ujuraycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angel tsaynö mitsicugcunata niycaptinnam, cielupita maytsicag angelcuna yurisquir, Dios Yayata alabarnin niyargan: ");
INSERT INTO qxnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Cieluchö caycag poderöso Dios Yayalläcuna, alläpa cushishgam alabaycuyag! ¡Cananpitaga alli päsacuychö cawacuyay, Dios Yayapa cuyacuyninwan cay patsachö cushitsirnin cawacugcuna!” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tsaynö nisquirnam, cieluman angelcuna cuticuyargan. Mitsicugcunanam ninacuyargan: “¡Dios Yaya willatsimangantsicnö, acu jina öra, Belenman aywar ricämushun!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Impëñulla aywarnam Josétawan Maríata y llullu wamratanam wätacunapa micucuyänanchö ujuraycagta tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tsaynö ricaycurnam mitsicugcuna llullupag angel llapan ninganta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mitsicugcuna willacuyanganta wiyarnam, runacuna cushicurnin mantsacashganö cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tsaynö niyaptinnam, Maríaga shongollanchö catsirnin yarpachacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mitsicugcunanam angel willacungannölla llulluta ricaycur, cushishga alabarnin cuticuyargan: “¡Dios Yayaga alläpa poderösom, agradëcicunantsicmi!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wamra semänayog caycaptinnam, taytanwan maman pengayninchö señalatsiyargan. Shutinnam churayargan Jesústa, angel Maríata yuripur ningannölla. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés mandacungan ley ningannömi María limpiu cananpag, chuscu chunca junagtarag shuyargan. Tsaymi tsay junag chäriptinrag, Maríawan Josépis Jerusalénchö templuman aywayargan, Jesústa Dios Yayata entregayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tsaynö rurayänanpagmi Diospa Palabran gellgashgachö nirgan: “Llullu ollgo tsuriquitaga Dios Yayata entregaycunqui servignin cananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dios Yaya mandacungan leymi gellgaraycan: “Nogata ishcay cullcushta o ishcay llullu palomacunata garaycayämanqui.” Cay leytapis cumpligmi Joséwan María aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tsay Jerusalén marcachömi Simeón shutiyog runa täcurgan, Dios Yayata alläpa cuyag alli runa. Paymi imaycatapis allicunallata rurarnin, israelcuna Cristo shamuptin libracashga cayänanta shuyarargan. Payga Dios Yayapa Espïritu Santonwanmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tsaymi Espïritu Santo jucpun musyatsir nirgan: “Dios Yaya cachamungan Cristota ricarragmi wañunqui” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tsaynam Espïritu Santo pushaptin, tsay junag templuman aywargan. Tsaymannam Niño Jesústa Joséwan María chätsiyargan, ley mandacungancunata cumpliyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeónnam llullu wamranta ricaycurnin margarcur, Dios Yayata alabar nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Dios Yayallä, noga servigniquita änillämangayquitam canan cumplirgoyqui. Cananmi sïga, tranquïlona cushishga wañuculläshag. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","¡Salvayämagnï Tsuriqui Cristo ricaycur! ");
INSERT INTO qxnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Quiquiqui ningayquinömi maytsaychö llapan runacunapa ricänanchö Payga salvanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mana Israelcag runacunatapis actsi cuentanömi actsirnin, gam Diosta regetsishunayquipag pushamunga. Pay poderöso canganraycum servigniqui israelcunapis imayca actsinörag alläpa cushishga cayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tsaynö Niño Jesúspag Simeón ninganta, taytanwan maman wiyarmi mantsacashga niyargan: “¿Tsaynötsurag canga?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeónnam paycunata nirgan: “Dios Yaya gamcunam bendiciunninta churaycamutsun.” Tsaypitanam Jesúspa maman Maríata nirgan: “Cay wawayqui jatunyarcuptinmi, llapan Israel runacuna Payman mana criyicurnin condenacäyanga. Pero payman rasumpa firmi criyicurmi sïga, salvacashga cayanga. Quiquin Dios Yayapita shamushga captinmi, runacuna chasquiyangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tsaynöpam llapan runacunapa shongoncunachö yarpaynincunata imanö cangantapis musyatsicunga. Yarparanqui, María. Imayca cuchillowan shongoyquita tucsiyämuptin nanatsicugnöragmi, tsay wawayquiraycu llaquicurnin sufrinqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tsaychömi juc chacwanpis cargan, Diospa Palabranta parlag Ana shutiyog. Unay awilunmi Aser shutiyog runapa ayllun y taytannam Fanuel cargan. Jipashlla casaracunganpita ganchis watallam gojanwan täcuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Gojan wañucusquiptinmi, pusag chunca chuscu watana japallanlla täcurgan. Tsaymi templupita mana yargor pagasta junagpa ayunarnin, Dios Yayata adorar mañacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tsayman Ana chärirnam wamrata ricaycur nirgan: “Dios Yaya, gamtam alläpa agradëcicug cay Tsuriquita nogacunaman cachamungayquita.” Tsaychö criyicug runacunatanam nirgan: “Cay wamram nogantsic Israel runacuna, unaypitana Cristota shuyangantsicnö salvamäshun.” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tsaypitanam Dios Yayapa leyninchö llapan mandacungancunata Joséwan María cumplisquir Galileachö Nazaret marcancunaman cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Niño Jesús wiñarnam Dios Yaya cuyarnin yanapaptin, alläpa yachayyog cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wata watam Jerusalénman Joséwan María Pascua semäna fiestata päsag aywayag. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tsaymi Jesús chunca ishcay watayog caycaptin, Israel runacunapa costumbrincunamannö Pascua semäna päsag Jerusalénman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tsay Pascua semäna ushacasquiptinnam, marcancunaman cuticuyargan. Joséwan María mana musyayanganyag Jesúsga Jerusalénchö quëdasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Paycunaga yarpäyargan “Cay atscag runacunawanchi shamuycan” nirmi. Nänita goyatna aywaycarmi, pullan nänichö tardiyaycaptinna Jesústa watucasquir aylluncunatawan regeshancunata tapupacurnin ashiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tsaychö mana tarirnam, tsayllapita Jerusalénman ashignin cutiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cutiycurnin quimsa junag ashiyanganchöragmi, templuchö ley yachatsicugcunapa rurinchö paycunata wiyarnin tapupar, Jesús jamaycagta tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesús alläpa alli yachayyog carmi, tapuyangancunata imanö shumag contestaptin, wiyagnin runacunapis mantsacäcur ni ima niyta puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesústa ricasquirnam, taytanwan maman mantsacäyargan. Mamannam nirgan: “Ä wawa, ¿imanirtan caynö rurayämar, mana willayämarnï quëdargoyqui? Alläpa llaquishgam taytayquiwan ashirniqui puriyargö.” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesúsnam nirgan: “¿Imanirtan ashiyämargoyqui? ¿Manacu gamcuna musyayanqui Dios Taytäpa wajinchö canäta?” ");
INSERT INTO qxnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero tsaynö ningantaga paycunaga manam ni ichicllatapis entendiyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsaypitanam paycunawan Nazaret marcancunaman cuticur, llapan mandayangancunata rurarnin cargan. Mamannam shongonllachö llapan päsangancunata yarparar catsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesúsnam wiñarnin jatunyar, alläpa allish yachayyog cargan. Dios Yayapagwan runacunapagpis cuyashga alläpa allim cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio Cesar shutiyog runa, chunca pitsga watana Roma runacunapa mas mandacug reynin caycaptinmi, Judea marcachö Poncio Pilato mandacug cargan. Galilea provinciachönam Herodes, Iturea y Traconite provinciacunachönam Herodespa waugen Felipe y Abilinia provinciachönam Lisanias. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jerusalénchönam llapanta mandagnin sacerdöticuna Anaswan Caifas caycäyargan. Tsay witsaymi tsunyacunachö Zacariaspa tsurin Juan Bautista päraptin, quiquin Dios Yaya Palabranta willacunanpag mandargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsaymi Jordan mayu cuchun marcacunapa purirnin, runacunata yachatsir nirgan: “Jutsayquicunapita dëjasquir arepenticurnin bautizacuyay, Dios Yaya perdonayäshunayquipag” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tsaynö Juan Bautista willacunanpagmi, Diospa Palabranta parlag Isaías gellgarnin nirgan: “Tsunyacunachö purirmi juc runa willacurnin ninga: ‘Dios Yayapa Tsurin shamunanpag ichicllanam faltan. Alli nänipa purignö alistacurnin shumag prevenicuyay. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mana alli nänicunata parijarnin jircacunata pampatsagnö, wicsu nänicunata derëchar rumi ruminta limpiagnö alistacuyay, shongoyquicunachö mana alli rurayniquicunata dëjasquir. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Entëru munduchö maytsay marcacunachömi llapan runacuna musyayanga, Dios Yayapita Salvador shamunganta.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tsaynö bautizacuyänanpag maytsicag runacuna Juanman maytsaypita shayämuptinmi nirgan: “Gamcunaga, venenösa vïborapa castan caycar, ¿imagtan nogaman shayämunqui? ¿Tsaynö caycarga, imanörag Dios Yayapa rabiayninwan condenacionpita geshpir salvacäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Llapan jutsayquicunata dëjasquir arepenticurnin, allicagcunallatana rurayay. Ama gamcunaga niyaytsu, ‘Unay Abrahampa ayllun carmi, Diospana cantsic’ nirga. Tsaymi niyag: Dios Yaya munarga cay rumicunapitapis Abrahampa ayllunman ticratsinmanmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Imayca mana alli wayug jachacunata wallusquir ninachö waycangantsicnömi, Dios Yaya listo caycan mana criyicuyangayquipitawan mana alli rurayniquicunapita castigayäshunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tsaynö niptinmi runacuna tapuyargan: “Tsaynö captinga, ¿imatatan rurayäshag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juannam nirgan: “Ishcay camisayquicuna captinga, juccag camisayquicunata camisannagcagta garaycuyay. Tsaynölla micuyniquicuna captinpis, mallagaycagcunata garaycuyay” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Contribucion cobragcunanam Juanman witirnin bautizacur, tapurnin niyargan: “Maestru, ¿imatatan nogacunaga rurayäshag?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juannam nirgan: “Contribucionpita mastaga ama cobracuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tsaynöllam soldäducunapis witiycur tapuyargan: “Nogacunaga, ¿imatatan rurayäshag?” Paycunatanam nirgan: “Ama runacunapa imancunatapis amälasga gechuyanquitsu ni amenasarnin calumniäyanquitsu gellaynincunaraycu. Pägayäshungayquillawan conformacuyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juan yachatsicunganta runacuna wiyarmi, alläpa cushishga quiquillancunachö niyargan: “Diospa Tsurin shuyangantsic Cristoch cayga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tsaynö niyanganta musyasquirnam, Juan Bautista nirgan: “Nogaga yacullawanmi bautizayag. Pero jucmi shamunga nogapita mas poderöso. Manam nogaga Paypa llangenpa watunta umpuycur pascanällapagpis servïtsu. Payga Espïritu Santota garayäshurniquim bautizayäshunqui lunyaycag ninawannö. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ichicllanam faltan, ërata limpiarnin rurasquir trïguta wayragnö runacunata acrananpag. Trïguta gorisquir churagnömi criyicug runacunata apacunga. Pero mana criyig runacunatam sïga, imayca päjata waycagnö mana wañug ninachö rupatsinga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tsaynö nisquirnam, Dios Yayapa Alli Willacuyninta tucuyläyapa alverticur willacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tsaypitanam mandacug Herodesta Juan Bautista piñapar nirgan: “Ama waugeyquipa warminwan täcuytsu. Tsayga alläpa mana allim. Tsaynölla amana tucuyläya mana allicunata ruraynatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tsaynö ninganpitam, mana allita rurangancunapita mas peor mana allita rurarnin, Herodes Juanta carcelman gaycascatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Rey Herodes manarag prësu achcutsiptinmi, llapan runacuna bautizacuyanganchö Señor Jesucristopis bautizacurgan. Tsaychö Señor Jesucristo Dios Yayaman mañacuycaptin cielu quichacasquiptinmi, ");
INSERT INTO qxnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","imayca palomanö Espïritu Santo ricaraycäyaptin urämur, Señor Jesucristoman chämurgan. Tsaynam cielupitanam Dios Yaya nimurgan: “Gamga cuyay Tsurïmi canqui. Gamtam quiquï acrashcag cushitsimänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Señor Jesucristo quimsa chunca watayog caycarnam, Dios Yayapa Alli Willacuyninta willacur gallaycurgan. Tsaymi runacuna yarparnin criyiyangannö Señor Jesucristoga Josépa tsurin cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elíga Matatpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joséga Matatíaspa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiga Mahatpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judága Joanánpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriga Melquípa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erga Josuépa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatga Levípa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimga Meleapa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánga Davidpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasónga Aminadabpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judága Jacobpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorga Serugpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaga Cainánpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecga Matusalénpa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánga Enóspa tsurinmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Señor Jesucristo bautizacusquirnam, Espïritu Santopa poderninwan Jordan mayupita cuticurgan. Tsaynam Espïritu Santo tsunyaman pushargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tsay tsunya mana imacagchömi chuscu chunca junag cargan. Tsaymi Señor Jesucristota Supay pruebarnin tentayta munargan. Tsay llapan junagcuna mana ni imatapis micurmi, Señor Jesucristo mallagargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tsaymi Supay nirgan: “Diospa Tsurin carga, mä cay rumita manday tantaman ticrayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Señor Jesucristonam nirgan: “Diospa Palabran gellgashgachömi nin: ‘Runaga manam tantata micurllatsu cawanga, sinöga Dios Yayapa Palabran mandacunganta rasumpa cäsurmi mas alliga cawacunga’ nir.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsaypitanam jirca puntanman Señor Jesucristota Satanas pushaycur, entëru munduchö maytsay naciuncunata ricätsir, ");
INSERT INTO qxnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nirgan: “Cay llapan jatusag shumag marcacunatawan llapan mandacuyniquipis garaycugmanmi. Cay llapan imayca riquësancunata chasquishga carmi, munarga pitapis garaycüman. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Si gongorpacuycurnin adoramaptiquiga, cay imayca ricaycangayquim llapan gampa canman.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Señor Jesucristonam nirgan: “¡Caypita witiy, Satanas! Diospa Palabran gellgashgachömi nin: ‘Juc japallan Diosllayquitam adorarnin servinayquiga.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tsaypitanam Supay Jerusalénman Señor Jesucristota pusharcur, templupa jananman lätarcatsir nirgan: “Diospa Tsurin carga, mä caypita jegarpuy. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diospa Palabran gellgashgachömi nirgan: ‘Gammanmi Dios angelnincunata cachamunga alcäbu cuidarnin, ");
INSERT INTO qxnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","maquincunawan achcuyäshuptiqui, rumicunachö chaquiquita mana tacacunayquipag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Señor Jesucristonam nirgan: “Diospa Palabran gellgashgachömi nirgan: ‘Diosniquitaga ama ni ima pruebamanpis churanquitsu.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tsaynö tentarnin Señor Jesucristota mana allita ruratsiyta mana puedirmi, Supayga “Yapaychönam cutimushag” nir, aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tsaypitanam Espïritu Santopa poderninwan Señor Jesucristo Galilea provinciaman cuticurgan. Maytsay enstanciacunachö runacunam Señor Jesucristopa ruraynincunata musyayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Llapan marca changanchömi, Dios Yayaman mañacuyänanpag goricäyänan wajicunachö Señor Jesucristo yachatsicurgan. Tsaynö yachatsicuptinmi, runacunapis alabarnin niyargan: “¡Payga alläpa allim!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsaypitanam wiñangan marcan Nazaretman Señor Jesucristo cutiycur, costumbrinmannö sabado jamay junag goricäyänan wajiman aywargan. Tsaychömi Diospa Palabranta liyinanpag sharcurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsaynam Diospa Palabranta willacug Isaías gellgangan libruta macyayargan. Señor Jesucristonam libruta quicharcur, gellgaraycagta tarisquir liyirnin nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Dios Yayapa Espïritunmi nogachö caycan. Paymi acramashga wactsacunata Alli Willacuyta willanäpagwan llaquishgacunata cushitsinäpag. Tsaynöllam Supayta servig runacunapa jutsancunapita libranäpag, gapracunatapis cuticätsinäpag, llaquipaypag servicug esclävucunatapis libranäpag manana sufriyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tsaynöpam ‘Canan cushicuy tiempuchö Dios Yaya alläpa cuyayarniqui salvayäshungayquita’ willayänagpag mandamashga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsaynö liyisquirnam, libruta wichgarcur goricäyänan wajichö yanapacug runata cutiycatsirnin jamaycurgan. Tsaychö caycagcunanam Señor Jesucristota ricaräyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsaynam nirgan: “Wiyaycäyangayqui libruchö nogapag gellgaraycagmi, canan öra cumplirgon.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tsaymi Señor Jesucristo alläpa shumagta parlar yachatsicuptin, llapan runacunapis cushicurnin mantsacashga ninacuyargan: “Señor Jesucristoga alläpa allim. ¿Pero, imanörag Josépa tsurinlla caycarga, tsayläya shumagta parlan?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Señor Jesucristonam runacunata nirgan: “Gamcunaga masran niyämanqui: ‘Jampicug carga, quiquiquirag jampicunquiman. Capernaumchöga geshyagyashacunatash cuticätsirgoyqui, mä canan cay marcayquichöpis tsaynö ruraymuy.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Rasuncagtam niyag: Manam ni maygan profëtatapis marcanchöga chasquirnin respetar cäsuyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Yarpäyay Elíaspa tiempunchö imanö canganta. Manacu quimsa wata y sogta quilla pasaypa usyarnin tamyargantsu. Tsaymi maytsay Israel marcachö runacuna mallagaywan sufriyargan. Israelchö atscag viudacuna sufriycäyaptinpis, Elíastam Dios Yaya cachargan caru Sidonpa lädun Sarep marcachö täcug viudallaman. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yarpäyay imanömi Eliseo cawaycangan tiempu cargan. Israel marcanchö atscag runacunam melanaypag wicuwan geshyagyashga cayargan. Tsaymi caru Siria marcachö Naaman shutiyog runallata Eliseo cuticätsirgan, manam Israel marca majincunatatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Señor Jesucristo tsaynö niptinnam, Dios Yayaman mañacuyänan wajichö goricashgacuna alläpa piñacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsaynö piñacurmi llapan sharcurnin, Señor Jesucristota Nazaretpita cunjar garachar, tsay marcapa jircanninpita cunjarpuyänanpag apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Payga atscag runacunapa rurinpita ullusquirmi aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsaypitanam Galileachö Capernaum marcaman uraypa aywargan. Jamay sabado junagchömi, Dios Yayaman mañacuyänan wajichö runacunata yachatsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Poderöso willacuyninta yachatsicuptinmi, runacunapis mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tsaychömi supayyog runa jinchi gayaraypa nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¡Au Jesús, Nazaret runa! ¿Imananquitan nogacunawan? ¿Ushacätsiyämagnïcu shamurgoyqui? ¡Noga regegmi, Diospa Santo Tsurin cangayquita!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsaymi Señor Jesucristo supayyog runata piñaparnin nirgan: “¡Upälla cay! ¡Canan cay runapita yargoy!” nir. Niycuptinnam, llapanpa puntanchö runata patsaman ishquiscatsirnin, mana imanarlla supay yargorgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Llapan runacunanam mantsacashga ninacuyargan: “¿Imanötan cay yachatsicuyninga? ¡Poderninwan mandaptillan, supayyog runacunapita supaycunapis yargoyan!” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tsaynö Señor Jesucristo rurangantam, maytsay Galilea marcacunachö runacuna musyasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsaypitanam Dios Yayaman mañacuyänan wajipita yargosquir, Simón Pedropa wajinman Señor Jesucristo aywargan. Tsaychömi Simónpa suegran fiebrewan geshyaycargan. Señor Jesucristo chaycuptinan “Cuticaycätsillämuy” nir, rugayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Señor Jesucristonam geshyaycagman witiycurnin umpuycur nirgan: “Amana fiebreynatsu.” Tsaymi jina öra fiebrenpita tsay warmi cuticasquirnin sharcur, paycunata servirnin gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsaypitanam rupay jegaycaptinna, tucuyläya geshyagyashacunata Señor Jesucristoman apayämurgan. Señor Jesucristonam juc juclla paycunaman maquinta churar, llapanta cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tsaynöllam atscag supayyog runacunapita supaycunapis yargornin, gayaraypa niyargan: “¡Gamga Diospa Tsurinmi canqui!” nir. Pero Señor Jesucristonam nirgan: “Upälla cayay.” Tsaynö piñaparmi Payga parlayänanta änirgantsu, Dios Yayapa Acrashgan canganta musyayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsaypitanam patsa atsicyaycaptinna, Señor Jesucristo tsunyaman japallan aywacurgan. Tsaynö aywasquiptinmi runacuna Señor Jesucristo caycanganman ashirnin aywar tarisquir niyargan: “Täcushunrag ama aywacuyragtsu” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Señor Jesucristonam nirgan: “Maytsay marcacunachömi Dios Yayapa Alli Willacuyninta willacur yachatsicunä. Cay patsamanmi cachamashga, Mandacuy Reynon imanö canganta runacuna musyayänanpag willacunäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsaypitanam Judea marcachö maytsaypa purirnin, Dios Yayaman mañacuyänanpag goricäyänan wajicunaman aywar yachatsicur willacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Juc cutinam Genesaret niyangan Galilea lamar cuchunchö Diospa Palabranta Señor Jesucristo yachatsicuycargan. Wiyayta munarmi, maytsicag runacuna goricar quichquinacurrag tangayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tsaynam yacuchö ishcay büqui caycagta Señor Jesucristo ricargan. Pescädo achcugcunanam büquincunapita yargosquir, pläyachö ataräyancunata mayllaycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsaynam Simónpa büquinman lätarcur nirgan: “Simón, cay yacu cuchunpita mas ruriman yaycushun.” Yaycusquiyaptinnam, büquiman jamaycur runacunata yachatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachatsicur ushasquirnam Simónta nirgan: “Cananga mas ruriman aywarnin ataräyayquicunata jitayay, pescädota achcuyänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónnam nirgan: “Maestru, waratnam pescayargö. Pero manam ni jucllayllatapis achcuyargötsu. Mä gam nimaptiqui ataräyäta jitashag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ataräyanta yacuman jitaycurnam, alläpa atsca pescädota achcuyargan, ataräyancunapis rachinganyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsaypitanam jucnin büquichö compañëruncunata yanapayänanpag sëñasllapa gayayargan. Paycuna chäriyaptinnam, pescädota ishcan büquiman wiñäyargan. Tsayläya atsca pescädocaptinmi, ishcan büquicunapis cäsi jundicäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tsayta Simón Pedro ricaycurnam, Señor Jesucristopa puntanman gongoricuycur nirgan: “¡Taytay, nogalläga jutsasapa runam callä! ¡Nogalläpita witicurcullay!” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Compañëruncunawan tsayläya atsca pescädota achcuyanganpita mantsacashga carmi, Pedro tsaynö nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeopa tsurincuna Santiagowan Juanmi, Simónpa companëroncuna cayargan. Paycunapis mantsacashgam cayargan. Señor Jesucristonam Simónta nirgan: “Ama mantsacaytsu. Cananpitam pescädota achcungayquinö runacunata yachatsirnin gorimunqui, nogaman rasumpa firmi criyicayämunanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tsaynö niptinnam, jina öra büquincunata gochapita jorgosquir, tsaychö llapanta dëjasquir Señor Jesucristota gatircur aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jucpunnam juc marcachö Señor Jesucristo caycaptin, melanaypag wicuwan entëru cuerpun geshyagyasha runa chargan. Señor Jesucristota ricaycurnam, patsayag umpuycur gongoricuycurnin rugargan: “Taytay, voluntäniqui captinga melanaypag mana canäpag limpiar cuticaycatsillämay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsaypitanam Señor Jesucristo tsay runapa jananman maquinta churaycur nirgan: “Noga munämi. ¡Cananga limpiu cuticashga canayquita!” Tsaynö niptinnam, tsay runaga jina öra geshyayninpita cuticasquir, sänu püru ticrasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tsaypitanam runata Señor Jesucristo nirgan: “Ama ni pitapis willacunquitsu cuticätsingagta. Mas bien sacerdötiman aywar, unay Moisés mandacungannö cuticangayquipita Dios Yayapag garaynin apay. Tsaynöpam sacerdöticuna musyayanga rasumpa limpiu cuticashgana cangayquita” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tsaynö “Ama willacunquitsu” nicaptinpis, runacunaga masmi musyasquiyargan Señor Jesucristo cuticätsinganta. Tsaypitanam maytsicag runacuna goricäyargan yachatsicuyninta wiyayänanpagwan geshyagyashacunatapis cuticätsinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Señor Jesucristoga imaypis paycunapita raquicarmi, tsunyacunapa aywar Dios Yayaman mañacug. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc junag Señor Jesucristo yachatsicuycaptinnam, fariseocunawan ley yachatsicugcuna maytsay Galilea marcapitawan Judeapita y Jerusalénpita shamurnin, goricasquir jamaycurnin wiyayargan. Quiquin Dios Yayapa poderninmi, Señor Jesucristochöga cargan. Tsaymi tucuyläya geshyagyashacunatapis cuticätsig. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsaymannam runacuna mana purig invälidu runata tsacrancawan wintushga apayämurgan. Chäratsirnam, waji rurinchö Señor Jesucristo caycanganpa puntanman yaycatsiyta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero maytsicag runacuna quichqui cayaptinnam, yaycatsiyta puediyargantsu. Tsaynö mana yaycatsiyta puedirmi, waji jananman lätarcur tëjacunata jurgosquir, geshyaycag runata tsacrancantawan shumagllalla Señor Jesucristopa puntanman bäjatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tsaynö rurarnin payman rasumpa criyicuyanganta musyarmi, geshyaycag runata Señor Jesucristo nirgan: “Amïgo, llapan jutsayquipitam perdonag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tsaynam fariseocunawan ley yachatsicugcuna quiquincunalla yarpachacuyargan: “Cay runaga Diospa contran, ¡imanirtan tsaynö Diostucur parlan! Quiquin Dios Yayallam jutsantsictaga perdonan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tsaynö yarpäyanganta Señor Jesucristo musyasquirnam nirgan: “¿Imanirtan shongoyquicunallachö tsaynö yarpäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Maygantan mas fäcil ninäpag canman: ‘Jutsayquicunapitam perdonag’ ningäcu o ‘Cuticashganam canqui; canan aywacuy’ ningäcu? ");
INSERT INTO qxnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero cananmi ricätsiyäshayqui Diospita Shamushga Runa car, poderöso caynïwan runacunapa jutsanta perdonangäta.” Tsaymi geshyagyasha runatana Señor Jesucristo nirgan: “Gamtam nig: Cuticashganam canqui. Sharcur tsacrancayquita apacurcur wajiquiman cuticuy.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tsaypitanam jina öra sharcurnin llapan ricäraycayaptin, tsacrancanta aparcur wajinpa cuticurgan Dios Yayaga cushishga alabarnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsaychö runacunapis mantsacäcurmi alabayargan: “¡Dios Yayaga alläpa alli poderösom! ¡Manam ni imaypis canannö imayca alli ruragtaga ricashgatsu cantsic!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsaypitanam Señor Jesucristo aywacuycar, Leví shutiyog contribucion cobrag runata ricargan, cobracunan wajichö jamaycagta. Paytam nirgan: “Canan nogata gatimay” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tsaynam Leví runaga sharcurnin, llapan imaycanta dëjasquir Señor Jesucristopa discïpulun cananpag gepanta aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tsaypitanam Señor Jesucristopag Leví wajinchö juc jatun banquëtita ruratsirgan. Tsaychönam atscag contribucion cobragcunawan waquincag runacunapis Señor Jesucristowan pagta micupacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero tsaynö micuycagta ricarmi, fariseocunawan ley yachatsicugcuna Señor Jesucristopa discïpuluncunata musyapar niyargan: “Contribucion cobragcunawan y jutsasapacunawan ¿imanirtan gamcuna micuycäyanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Señor Jesucristonam nirgan: “Geshyagyashacunallam mëdicotaga wanayan, sänucagcunaga manam wanayannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tsaynöllam nogapis cay patsaman shamushcä, manam jutsannag alli ruragcunata ashigtsu, sinöga jutsasapacunata ashigninmi shamushcä, jutsancunapita arepenticurnin Dios Yayaman cutiyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tsaypitanam runacuna Señor Jesucristota tapuyargan: “Juan Bautistapawan fariseocunapa discïpuluncunaga imaypis ayunarmi, Dios Yayaman mañacuyan. Pero gampa discïpuluyquicunaga mana ayunarmi, imaypis upyaycäyan y micuycäyan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Señor Jesucristonam nirgan: “¿Acäsu casamientuman convidashgacunaga noviowan pagta caycar ayunarcu mallag cayanman? ");
INSERT INTO qxnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tsaynöllam nogawan pagta caycarga, discïpulücunapis ayunayänantsu. Pero imayca noviotanö nogata apascayämaptinmi sïga, paycunapis mallaglla ayunarnin cayanga” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tsaynö nisquirnam, yachatsicur nirgan: “Mushog tëlapita rutusquir, manam macwa llatapata remendashwantsu. Tsaynö rurarga ishcantam perdescatsintsic. Si tsaynö ruraptinga, mushogcag tëla gentirmi macwacag llatapata mas peor rachiscatsinga. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tsaynöllam tsayrag rurashga aswatapis, macwa mana servig puyñumangajirpurnin wiñantsictsu. Si tsaynö wiñashgaga aswa pogornin macwa puyñuta paquiscatsiptinmi, aswapis jicharnin jancat perdesquinga. Tsaymi puyñuwan aswapis jancat ushacasquiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Manam tsaytaga tsaynöga rurashwantsu. Tsaymi tsayrag rurashga aswataga mushog puyñuman jirpurnin wiñantsic. ");
INSERT INTO qxnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pipis pogoshganacag mishqui aswata yawarcurga, tsayrag rurashgacag aswataga mananam upyayta munantsu, ‘pogoshgacag aswam mas mishquiga.’ Tsaynömi cay runacunapis, yachatsicunga mushogcaptin entendiyta munayantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juc sabado jamay junagnam Señor Jesucristo trïgu murushga rurinpa discïpuluncunawan aywaycargan. Discïpuluncunanam trïguta quiptusquirnin cupasquir uchuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseocuna tsayta ricaycurnam piñacur niyargan: “¡Leynintsicga manam permïtintsu cay jamay sabado junagchö gamcuna tsaynö rurayänayquipag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Señor Jesucristonam nirgan: “¿Manacu Diospa Palabranta liyiyashcanqui, unay rey David yanagencunawan puriycar mallagarnin rurayanganta? ");
INSERT INTO qxnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davidmi Dios Yayata adorayänan wajiman yaycusquir, Diospa puntanman churashga sagrädu tantata jorgosquirnin, yanagencunawan micusquiyargan. Leynintsic mandacungannöga sacerdöticunallam tsay sagrädu tantataga micuyänan cargan. Tsaynö caycaptinpis, David yanagencunawan mana sacerdöti caycar micurnin, manam ni ima mana allitatsu rurargan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tsaynö nisquirnam nirgan: “Diospita Shamushga Runa carmi, sabado jamay junagchöpis mandacuyta puedï.” ");
INSERT INTO qxnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tsaypitanam yapay juc sabadochö goricäyänan wajiman Señor Jesucristo aywarnin yachatsicurgan. Tsaychömi juc runa derëchucag maquin pasaypa genticashga caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseocunanam ley yachatsicugcunawan Señor Jesucristota ricaraycäyargan “¿Mä canan sabado junagchö leynintsicta mana cäsur, cay runata cuticätsingacush? Cuticätsiptinga quëjacushunmi” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero tsaynö yarpäyanganta tantiyasquirmi, gentishga maquiyog runata nirgan: “Sharcur, cay llapanpa puntaman ichiy” nir. Runanam sharcurnin llapanpa puntanman ichirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tsaynam fariseocunata Señor Jesucristo nirgan: “Jucta tapuyäshayqui, ¿Imanötan leynintsic mandacun jamay sabado junagchö: Allita rurashwancu o manacu? ¿Geshyaycag runata cuticätsishwancu o wañunaycaptinpis ricaraycashwancu?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tsaynam llapancunata ricasquir, tsay runata nirgan: “Maquiquita macyamuy.” Maquinta pallarcuptinnam, jancat cuticascatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero fariseocunanam piñacurnin, quiquincuna pura ninacuyargan: “Jesúspa contran imatatan ruraycuntsic.” ");
INSERT INTO qxnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tsaypitanam Señor Jesucristo juc jircaman aywasquir, Dios Yayaman warat mañacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Patsa waräsquiptinnam, discïpuluncunata gayasquir chunca ishcagta acrarnin churargan apostolnin cayänanpag. Paycunam cayargan: ");
INSERT INTO qxnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón (paytam shutitsirgan “Pedro” nir) ");
INSERT INTO qxnNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, ");
INSERT INTO qxnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagopa tsurin Judás y Judás Iscariote. Judás Iscariotem Señor Jesucristota traicionarnin ranticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Discïpuluncunawan Señor Jesucristo jircapita urämurmi, pampachö atscag gatiragnincuna caycagta tariyämurgan. Tsaymanmi maytsay Judea marcacunapitawan Jerusalénpita, lamar cuchunchö Tiro y Sidon marcacunapitapis, maytsicag runacuna shayämushga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tsaymi maytsaypita Señor Jesucristo yachatsicunganta wiyayta munarnin y geshyagyashacunata cuticätsinanta munar shayämurgan. Supaycunawan sufrigcunatapis Señor Jesucristo cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Llapan runacunam Señor Jesucristota yatayta munayargan, poderöso cayninwan llapan geshyagyashacunata cuticätsiptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsaypitanam discïpuluncunata Señor Jesucristo ricaycur, yarpachacuyänanpag nirgan: “Cushicuyay, nogaman criyicug wactsacuna. Gamcunapagmi Dios Yayapa Mandacuy Reynonga. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Cushicuyay, imayca mallagagnö Diosta ashigcuna. Gamcunatam Dios Yayaga pacha juntata wätayäshunqui. Cushicuyay, canan llaquicur wagacugcuna. Cananpitaga cushishga asicurnam cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Cushicuyay, chiquirnin gargor allgotsacuyäshuptiqui, mana alli ruragtanö insultar calumniarnin levantayäshuptiqui. Tsaynö rechazarga rurayäshunqui Diospita Shamushga Runaman rasumpa criyicuyangayquiraycum. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Tsaynö rurayäshuptiquiga cushicuyanqui. Wac vïdachömi Dios Yaya imayca juc premiutanö llapan bendiciunninta garayäshunqui. Tsaynöllam paycunapa unay awiluncunapis Dios Yayapag willacugcunata maltratayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pero, ¡Allau rïcu runacuna! Cay vïdallachömi gamcunaga shogashga cushicuychö cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Allau, cay patsachö imaycayquicuna cayäpushungayquicunallaman criyicugcuna, gamcuna imaycarpis mallagarmi llaquishga cayanqui! “¡Allau, mana allicunata ruraycar, cushicur asicachagcuna, tsaynö rurayangancunapitam llaquicur wagacuychö cayanqui! ");
INSERT INTO qxnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Allau, gamcunata runacunalla aläbayäshuptiqui, tsaynöllam paycunapa awiluncunapis unay tiempuchö, Dios Yayapa profëtantucugcunata aläbayargan! ");
INSERT INTO qxnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pero cananmi llapayqui wiyayämänayquipag niyag: Chiquiyäshugniquicunata cuyar, despreciayäshugniquicunata llaquiparnin yanapayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Contrayqui imatapis rurar mana allicunata mañacuyaptinpis, gamcunaga paycunaman Dios Yaya bendiciunninta churaycunanpag mañacuyanqui. Tsaynölla ashar allgotsacuyäshugniqui runacunapagpis Dios Yayaman mañacuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Si pipis juccaglä gagllayquicunachö lagyaycuyäshuptiquiga, juccaglätapis camapuycuyanqui. Mas bien umillacuycurnin ama imanayanquitsu. Punchuyquicunata gechuyäshuptiquiga, camisayquicunatawan llushtipuycuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Imatapis mañayäshungayquita garaycuyanqui. Si imayquita gechuyäshuptiquipis ama ‘Cutitsimay’ nir, gechuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imanömi runamajiquicuna gamcunapag allita rurayänanta munayanqui, tsaynölla gamcunapis paycunapag allicunallata rurayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cuyayäshugniquicunallata cuyarga, manam ni ima allitatsu ruraycäyanqui. Jutsasapacunapis cuyagnincunallataga cuyayanmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Llaquir yanapayäshugniquicunallata yanaparga, manam ni ima allitatsu ruraycäyanqui. Jutsasapacunapis llaquignincunallataga yanapayanmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si gamcuna següru cutitsiyäshunayquipag runacunallata prestarga, ¿ima allitatan ruraycäyanqui? Tsaynö llapanta cutitsiyänanllapagga jutsasapacunapis prestacuyanmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tsaypa rantinga chiquiyäshugniquicunapag allicunallata rurarnin cuyayanqui. Mana cutitsiyäshunayquita shuyararlla, imatapis prestaycuyanqui. Tsaynö rurayaptiquiga, quiquin Dios Yayam prestayangayquipitapis masta cutitsiyäshunqui. Dios Yayaga mana agradëcicugcunatawan jutsasapacunatapis llaquiparmi yanapan. Gamcunapis Paynölla rurarga, cieluchö poderöso Dios Yayapa rasumpa wamranmi cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tsaymi alläpa cuyacur llaquipäcug cieluchö Taytaquicunanölla, gamcunapis llaquipäcug cayay. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Runamajicunata ama juzgayaytsu, gamcunatapis Dios Yaya mana juzgayäshunayquipag. Calumniarnin ama ni pitapis levantayaytsu, tsaynölla gamcunatapis Dios Yaya mana condenayäshunayquipag. Mas bien perdonanacuyay, gamcunatapis Dios Yaya perdonayäshunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Runamajiquita garaycuptiquiga, Dios Yayam gamcunatapis mas atscata garaycushunqui, tupuman juntat tupurcur jichatrag garacugnö. Atscata o ichicllata garacuyangayquinöllam, gamcunapis chasquiyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tsaynö nisquirnam, Señor Jesucristo iwalatsicuypa yachatsicurnin nirgan: “¿Acäsu juc gaprataga gapramajincu pushan? Gapramajin pusharga, ¡ishcanmi sanjaman jegarpuyanman! ");
INSERT INTO qxnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Manam ni maygan yachacugpis maestrunpita mas yachagga cantsu. Pero tsay yachacug shumag alli yachacur ushasquirga, maestrunnöllam canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Imanirtan runamajiquipa ñawinchö ichic shumpatagnö mana alli rurayninta musyapanqui? ¿Pero quiquiquicunapa jutsayquicunaga imayca ñawiquicunachö jatun gerunö caycagta, manacu tantiyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jutsayquita imayca ñawiquichö jatun gerutanö mana ricaycarga, ¿imanörag ‘Wauge, ñawiquipita shumpata jipiscamushag’ ninquiman? ¡Ä, allitucug janan shongo! Quiquiquirag puntata ñawiquichö caycag geruta jorgonquiman. Tsaymi sïga mas shumag ricanquiman jucpa ñawinpita shumpata jipinayquipagpis. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Allicag früta allitam wayun. Pero mana allicag frütaga mana allitam wayunpis. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wayuyninpitam imanö früta canganta regentsic. Manam casha montipitatsu ïgostawan üvata pallantsic. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tsaynöllam allicag runaga shongon allicaptin, imaycatapis allicunallata ruran. Pero mana allicag runanam sïga shongon mana allicaptin, mana allicunallata imaypis ruraycan. Shongonchö mana allicunata yarparmi, tsaynö mana allicunallata parlanpis. Tsaymi runaga shongontsicchö allita o mana allitapis yarpangantsicta parlantsic. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtan gamcunaga Señor, Señor niyämanqui, mandamientücunatapis mana cäsucuycar? ");
INSERT INTO qxnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cananmi iwalatsicuywan entenditsiyäshayqui: Nogaman shamur yachatsicungäta wiyarnin cäsucugcunaga, ");
INSERT INTO qxnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","imayca alli junduyag ogtiycurnin, gaga jananchö cimientuta patsätsir wajita shäratsignömi cayan. Tsaynö rurasquiptinmi mangädawan atsca lloglla yacu tsay wajiman charpis cuyutsintsu, gaga jananchö allish rurashga captin. ");
INSERT INTO qxnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero yachatsicungäcunata wiyaycar, mana cäsucug runaga allpa janallanchö cimientunnag wajita shäratsignömi cayan. Tsaymi mangädawan atsca lloglla yacu tsay wajiman char, pasaypa jancat juchuscatsin.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tsaychö wiyagnin runacunata yachatsir ushasquirnam, Capernaum marcaman aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tsaychömi Roma capitanpa cuyay wätaynin runa antsa geshyaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tsay capitannam Señor Jesucristo rurangancunata musyarnin, judiucunapa mandacugnincunata cachargan: “Señor Jesucristoman canan aywaycuyällay. Shamuycullätsun wätaynïta cuticaycatsillämunanpag” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Paycuna aywarnam Señor Jesucristota niyargan: “Tsay capitan alläpa alli canganraycu, geshyaycag wätayninta cuticaycatsillay. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Payga alläpa marcantsicta cuyarmi, Dios Yayaman mañacunapag goricänantsic wajitapis ruratsishga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsaynö rugayaptinnam, Señor Jesucristo paycunawan aywargan. Pero wajiman chaycäyaptinnam, capitan amïgoncunata cachargan Señor Jesucristota niyänanpag: “Señor, amana afanacallämuytsu, mana Israel runa carmi, wajïman yaycunayquita pengacullä. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tsaynö pengacurmi quiquïga shallämurgötsu. Tsaymi cayllapita niycullay wätaynï cuticasquinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nogapis mandagnïpa mandädunchömi cä. Tsaynöllam soldädücunapis mandädüchö cayan. Soldädüta ‘Ayway’ niptïga aywanmi. Jucninta ‘Shamuy’ niptïpis shamunmi. Wätaynïta ‘Cayta ruray’ niptïpis ruranmi.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tsayta wiyaycurnam Señor Jesucristo mantsacagnörag alläpa cushicur discïpuluncunaman tumaycur nirgan: “Niyagmi, cay runa criyicungantanöga, manam ni imaypis Israel naciunchö tarishgatsu cä.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Capitanpa wajinman tsay cachacungan amïgoncuna cutirmi, wätaynin jancat cuticashgatana tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsaypitanam Señor Jesucristo Nain niyangan marcaman aywacuptin, discïpuluncuna maytsicag runacunawan gatirnin aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tsay marcaman yaycuycarnam, Señor Jesucristo tincurgan wañushgata pampag apaycäyagwan. Tsay wañushga runata atscag pampagnin apaycäyanganga, juc viudapa japallallan ollgo wawanmi canag. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tsaypitanam Señor Jesucristo warmita ricaycurnin, alläpa llaquiparnin nirgan: “Ama wagaytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tsaynö nirmi, aywarnin cäjata yataycuptin wintuycagcuna ichisquiyargan. Tsay wañushgatanam Señor Jesucristo nirgan: “Jöven, gamtam nig: ¡Sharcuy!” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Señor Jesucristo tsaynö niycuptinmi, cawascamur jamaycurnin runacunawan parlargan. Tsay viudatanam Señor Jesucristo ollgo wawan cawashgata entregaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tsayta ricaycurmi llapan runacuna cushicuynintinwan mantsacar Dios Yayata alabarnin niyargan: “Dios Yayapa juc poderöso profëtanmi nogantsicman yurimushga; alläpa llaquiparmi quiquin Dios Yaya cananga yanapamäshun” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Runacunanam entëru Judea provinciapawan maytsay marcacunapa aywarnin, Señor Jesucristo rurangancunata willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautistapa discïpuluncunanam Señor Jesucristo rurangancunata musyasquir Juanta willayargan. Tsaynam ishcag discïpuluncunata gayasquir, ");
INSERT INTO qxnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","tapucug cachar nirgan: “Diospa Tsurin Cristom jutsantsicpita salvamänapag shamunan cargan. ¿Gamcush canqui o juctaragcush shuyäyäshag?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Señor Jesucristoman chaycurnam niyargan: “Juan Bautistam mandayämargon. ¿Gamcush Diospita Shamushga Runa canqui o juctaragcush shuyäyälläshag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tsay öram Juan Bautistapa discïpuluncunapa puntancunachö Señor Jesucristo tucuyläyawan geshyaycagcunata y supayyog runacunapita supaycunata gargornin atscag gapracunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsaymi Juan cachamungancunata Señor Jesucristo nirgan: “Canan cutirnin, Juan Bautistata willayanqui, caychö wiyayangayquitawan llapan ricäyangayquita: ‘Gapracunam ricäyan; ratacunam puriyan; melanaypag wicuwan geshyagyashacunapis limpiu cuticäyan; mana wiyagcunam wiyayan; wañushgacunam cawayämun; y wactsacunatam mushog Alli Willacuyninta willan’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pipis nogapita mana raquicarnin confiacamur firmi criyicurga, alläpa cushishgam cayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan Bautistapa discïpuluncuna cuticusquiyaptinmi, tsaychö goricashga runacunata Señor Jesucristo Juanpag willargan: “Tsunyachö caycaptin, ¿imagtan Juanman caruta aywayargayqui? ¿Juc runa mantsacurnin juclä jucläpa imayca shogoshnö wayrawan cuyugta ricagcu? ");
INSERT INTO qxnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sinöga, ¿imagtan aywayargayqui? ¿Alli shumag llatapan shucushga runata ricagcu? Alli shumag llatapashga runacunaga micur, upyar, tushur rïcucunapa palacioncunachömi cayan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tsaypunga, ¿imagtan aywayargayqui, Diospa willacug profëtanmi nircu? ¡Aumi! Payga, tsay willacug profëtacunapitapis mas willacug profëtam. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpagmi Diospa Palabran gellgashgachö nirgan: ‘Willacugnïtam gampa puntayquita cachashag, runacunata willacuptin jutsancunapita arepenticurnin alistacushgana shumag chasquiyäshunayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rasuncagtam niyag: Juannö poderyog alli runaga manam ni imaypis cashgaragtsu. Tsaynö captinpis, Dios Yayapa Mandacuy Reynonchö caycag gollmi shongo runacunam Juanpita mas poderyogga cayan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juan yachatsicunganta wiyarmi, llapan runacunawan contribucion cobracugcunapis “¡Dios Yayaga alläpa allim!” nir, tsay öra bautizacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero fariseocunawan ley yachatsicugcunaga, paycunapag Dios Yaya munanganta mana cäsurmi bautizacuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tsaypitanam Señor Jesucristo nirgan: “¿Canan tiempu runacunataga imawanrag iwalatsishag? ¿Imanötan cayan? ");
INSERT INTO qxnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Paycunaga imayca pläzacunachö pucllar, wamracuna gayaycachagnöllam yanagencunata niyan: ‘Lautata shumag tocayaptïpis manam tushuyanquitsu ni llaquinaypagta cantayaptïpis manam wagayanquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tsaynömi Juan Bautista shamurnin, vïnota mana upyaptin y tantata mana micuptin gamcuna niyanqui: ‘Payga supayyogmi.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Diospita Shamushga Runa micug upyag captïmi, gamcunaga niyämanqui: ‘Cayga alläpa micugmi y upyagmi. Contribucion cobragcunapawan jutsasapacunapa amïgonmi.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero Dios Yayapa acrashgancag runacunaga, alli rurag caynincunawan Dios Yayapa alläpa alli yachayninta ricätsicuyan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsaypitanam juc fariseo wajinchö micuyänanpag Señor Jesucristota convidargan. Señor Jesucristonam wajiman yaycusquir, mësaman jamargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tsay marcachönam juc lluta puricug warmi pärargan. Tsay warminam fariseopa wajinchö Señor Jesucristo micuycanganta musyasquir, aywarnin yaycusquirgan alabastro niyangan pömuchö mushcug perfümin aptashga. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chärirnam Señor Jesucristopa gepallanpa chaquinyag witiycurnin wagargan. Wegenwan chaquincunata mayllarnin agtsanwan tsaquiscatsirmi, chaquinta mutsaycur juc mushcug perfümita wiñargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tsayta ricaycurnam, Señor Jesucristota convidag fariseo shongollanchö nirgan: “Cay runa Dios Yayapa rasumpa profëtan carga, musyanmanmi cay yatagnin warmi imanö mana alli rurag canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsaypitanam Señor Jesucristo nirgan: “Simón, jucta nishayqui.” Paynam nirgan: “Maestru, niycallämay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Señor Jesucristonam nirgan: “Ishcag runacunam juc prestacug runata gellaynin dëbeyargan. Juccagmi pitsga pachac junag arunapag dëbecurgan y juccagnam pitsga chunca junagllapag. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tsaynö ishcanpis dëbecuyanganta mana pägayta puediyaptinmi, tsay gellayninta prestagnincuna runa ishcanta perdonargan. Mä, canan nimay, Simón, ¿maygancag dëbecugtan tsay runata mas cuyanga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónnam nirgan: “Tsay pitsga pachac junag arunanpag mas dëbegcag perdonanganchi.” Tsaynam Señor Jesucristo nirgan: “Rasuntam ninqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tsaynö nisquirnam, Señor Jesucristo warmita ricaycurnin Simónta nirgan: “¿Cay warmi ruranganta ricargoyquicu? Wajiquiman chäramuptï, gamga manam yacuta garamargoyquitsu chaquïta mayllanäpag. Pero cay warmiga quiquinpa wegenwan chaquïcunata mayllasquirmi, agtsanwan tsaquitsimurgon. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gamga costumbrintsicnö manam mutsamargoyquitsu, pero cay warmim sïga wajiquiman yaycamunganpita chaquïta mutsamurnin dëjargontsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gamga manam costumbrintsicmannö umäman aceitita wiñämurgoyquitsu. Pero cay warmin sïga, alläpa chaniyog mushcug perfümita chaquïman wiñämurgon. ");
INSERT INTO qxnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tsaymi gamta nig: Cay warmita tsaytsicag jutsanpita perdonaptïmi, alläpa cuyamarnï tsaynö ruramargon. Pero waquinga ‘Ichiclla jutsätam perdonamashga alli rurag captï’ nirmi, ichicllata cuyayämanpis.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Warmitanam Señor Jesucristo nirgan: “Llapan jutsayquim perdonashgana.” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tsaychö caycag convidashgacunanam, quiquincuna pura ninacuyargan: “¿Pitan cay runaga, jutsacunapitapis perdonacunanpag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Señor Jesucristonam warmita nirgan: “Nogaman rasumpa firmi criyicurmi, condenacionpita salvacargoyqui. Cananga aywacuy shumag alli päsacuychö cawacunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsaypitanam Señor Jesucristo maytsay marcacunapawan estanciacunapapis aywar, Dios Yayapa Mandacuy Reynonpa Alli Willacuyninta willacurnin yachatsicurgan. Chunca ishcay discïpuluncunam gatiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Geshyayanganpitawan supayyog cayanganpita cuticätsingan warmicunapis gatiyarganmi. Jucninmi María Magdalena cargan. Paypitam ganchis supaycunata Señor Jesucristo gargoshga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Waquincagnam cayargan: Herodespa mayoralnin Cuza shutiyog runapa warmin Juanawan Susana y mas warmicunawan. Paycunam imancunapis cayäpungancunawan, Señor Jesucristotawan discïpuluncunata yanapayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tsaynö maytsay marcacunapita atscag runacuna payman goricäyaptinmi, murucug runaman iwalatsicuypa yachatsicur nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc runam chacranman murucug aywargan. Muruta magtsiptinnam, waquincag murucuna näniman shicwayargan. Tsaytanam runacuna jaruyaptin pishgocuna upshasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquincagnam ranracuna jananman shicwayargan. Tsaychö allpa mana captinmi, saslla jegascamur tsaquisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquincagnam cashacuna rurinman shicwayargan. Cashacuna wiñarnam, pasaypa jancat tsapar ushasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waquincag murucuna alli allpaman shicwagcagnam, jegarcamur wiñarnin cada espïgachö pachac gränuyag wayuyargan.” Señor Jesucristo tsaynö yachatsicur ushasquirnam, jinchi nirgan: “¡Canan willayangagta wiyarnin shumag entendicuyay!” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Discïpuluncunanam tapuyargan: “¿Ima ninantan tsay iwalatsicuypa yachatsicungayqui?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Señor Jesucristonam nirgan: “Quiquin Dios Yayam Mandacuy Reynon imanö canganta nogawan musyatsiyäshunqui. Pero waquincag runacunaga manam musyayantsu. Tsaymi paycunata llapan iwalatsicuypa yachatsicugta ‘ricaycar wiyaycäyämarpis entendiyantsu’ ” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tsayga iwalatsicuywan yachatsicuyga caynö ninanmi: Muruga Diospa Palabran Alli Willacuymi. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Näniman muru shicwashganömi waquincag wiyacugcunaga cayan. Dios Yayapa Palabrantam cushishga wiyayan, pero Supaynam shongonpita jancat gongascatsin. Supayga manam munantsu criyicurnin salvacäyänanta. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Waquincag runacunanam imayca ranra chacranö cayan. Diospa Palabranta wiyar alläpa cushishga criyicuyan. Pero mana alli jawayog plantanö carmi, desgraciacuna päsaptinga dëjasquir manana criyicuyannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Waquinnam imayca casha chacranö cayan. Diospa Palabranta wiyarmi allish criyicuyan. Pero tsaypita capugyog caypag yarpachacuywan cushicuyllachö cawayta munarmi, Dios Yayamanga manana firmi criyir ni imatapis rurayannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero waquinmi sïga imayca alli allpanö cayan. Paycunaga alläpa alli shongoncunawan Diospa Palabranta chasquirnin criyicuyan. Tsaynö rasumpa firmi criyicurmi, imayca sufrimientuta päsarpis awantarnin Dios Yayapag imaycatapis allicunallata rurayan, imayca juc alli cosëchanö. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Actsita sendircurga manam manca rurinmantsu ni catripa gopinmantsu churantsic. Sinöga altumanmi churantsic yaycugcuna llapanta ricäyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Diospa Palabran pacaragnö mana musyacaycaptinpis, imaypis musyayangam. Tsaynöllam pacayllapa canan imata rurayangantapis, Dios Yaya llapan runacunapa puntanchö llapanta musyatsicunga. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Tsaymi canan shumag allipa wiyayämay: Diospa Palabranta wiyagcag runacunaga mas allim entendiyanga. Pero yachagtucug runacunaga, ichiclla yachayangantapis jancatmi gongasquiyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsaymannam Señor Jesucristopa mamanwan waugencuna ashirnin chäyargan. Pero atscag runacuna goricashga cayaptinmi, Señor Jesucristo caycanganman yaycuyta puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tsaynam Señor Jesucristota juc runa willargan: “Wagtachömi mamayquiwan waugeyquicuna ichiraycäyan. Wanayäshunquish.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Señor Jesucristonam nirgan: “Diospa Palabranta wiyarcur cäsucugcunam, mamäwan waugëcunaga cayan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tsayman atscag runacuna juntapuyaptinmi, discïpuluncunata Señor Jesucristo nirgan: “Gocha wac tsimpanman päsashun.” Tsaynö niptinmi aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lamarpa aywaycäyaptinnam Señor Jesucristo puñucasquirgan. Tsaynö puñucashga caycaptinnam, mantsacaypag llutaypa shucucuy wayra yurirgan yacutapis lagchicätsirrag. Büquincunaman yacu wiñacaptinnam, jundicayta gallaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Discïpuluncunanam alläpa mantsacashga, ricchatsiyargan: “¡Maestru, Maestru ricchay! ¡Jundicaycantsicnam!” nir. Tsaynam Señor Jesucristo sharcur nirgan: “Amana wayraynatsu ni yacupis lagchicaynatsu” nir. Tsaynö niptinnam, jina öra wayrawan yacu lagchicaypis patsallanchö pärasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Discïpuluncunatanam nirgan: “¿Imanirtan nogaman mana criyicuyanquitsu?” Discïpuluncunanam alläpa mantsacashga quiquincuna pura ninacuyargan: “¡Cayga imanö runatan, tsayläya wayrawan yacu lagchicagpis mandanganta cäsunanpag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galileapita aywacurnam, lamarpa wac tsimpan Gerasa niyangan provinciaman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Büquipita yarpusquiyaptinnam, tsay marcapita juc supayyog runa yargosquir shamur tincupämurgan. Tsay runaga unaypitanam garapätulla purir, wajinchöpis manana täcur panteoncunallachöna päracurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Señor Jesucristota ricaycurnam, cörrilla aywarnin puntanman gongorpacurgan. Tsaynam runapa shiminpa supay jinchi gayaraypa nirgan: “Dios Yayapa Tsurin Jesús, ¿imatatan nogawan munanqui? ¡Gamtam rugag cay runapita gargomar mana sufritsimänayquipag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tsaynöga nirgan, Señor Jesucristo supayta “¡Cay runapita yargoy!” nir, mandashgana captinmi. Tsay runapa shongonchö supay unaypitana carmi, imayca achcuragnö catsirgan. Guardiacuna cuidarnin cadenacunawan tsarayta munanin chaquintawan maquinta panquiyaptinpis, atsca cutim cadenata rachicachasquir supaypa munayninwan tsunyacunapa aywacur purirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Supaytanam Señor Jesucristo tapurnin nirgan: “¿Imatan shutiqui?” Supaynam runapa shiminpa nirgan: “Nogapa shutïga ‘Sogta Warangam’ (6,000).” Tsaynöga nirgan, maytsicag supaycuna tsay runachö carmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Señor Jesucristotanam supaycuna yapay yapay rugayargan: “Ama infiernumanga garpuycayällämaytsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tsay jircachömi atsca cuchicunata mitsiycäyargan. Tsaynam supaycuna Señor Jesucristota rugarnin niyargan: “Cachaycayällämay tagay cuchicunallaman yaycucuycuyällänäpag.” Señor Jesucristo “Aywayay” niptinnam, ");
INSERT INTO qxnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","supaycuna runapita yargosquir, cuchicunaman yaycuyargan. Cuchicunaman yaycusquiyaptinnam löcuyar wacpa caypa acataycacharnin jircapita gochaman jegamur, cuchicuna shingarnin wañusquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mitsigcunanam tsaynö päsanganta ricaycur, marcacunapawan estanciancunapa cörrilla aywarnin llapanta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsaynam runacuna ima päsanganta ricag shayämurgan: “¿Mä, imash päsashga?” Señor Jesucristo caycanganman chärirnam, supayyog runa pasaypa jancat sänuna llatapashga juiciunchö Señor Jesucristopa lädunchö jamaycagta tariyargan. Tsayta ricaycurnam alläpa mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tsayta ricashgacagcunam willacuyargan, tsay supayyog runata Señor Jesucristo imanö cuticätsinganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tsaynam tsay Gerasa provinciachö llapan runacuna alläpa mantsacurnin, Señor Jesucristota rugarnin niyargan: “Cay marcälläcunapita aywacullay.” Tsaypitanam Señor Jesucristo discïpulucunawan büquiman lätarcur aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Supaycuna yargosquiyaptin cuticashga runanam Señor Jesucristota rugargan paywan pagta aywacunanpag. Pero Señor Jesucristoga runata despedirnin nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wajiquiman cuticuy. Tsaychö aylluyquicunata willanqui Dios Yaya gampag llapan ruranganta.” Tsaypita cuticurnam maytsaypa aywarnin willacurgan, Señor Jesucristo paypag llapan imayca rurangancunata. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tsaypitanam Galileaman cutiyaptin, atscag runacuna shuyaraycayargan cushishga chasquiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tsaynam Dios Yayaman mañacuyänanpag goricäyänan wajichö mandacug Jairo shutiyog runapis chaycurnin, Señor Jesucristopa puntanman gongoricuycur wajinman aywananpag rugargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tsay runapam chunca ishcay watayog japallan warmi tsurin, pasaypa antsa geshyar wañuycarganna. Tsaypita Señor Jesucristo aywaptinnam, maytsicag runacuna gatirnin quichquinacurrag, cäsi llapiyarganpis. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tsay runacunapa rurinchömi chunca ishcay watana yawar apaywan geshyagyasha warmipis aywargan. Jampitsicunanpagmi imaycantapis jancat ranticurnin ushashga cargan. Pero manam ni maygan jampicugpis cuticätsirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Paymi Señor Jesucristopa gepanllapa aywar, llatapanpa cuchunta yataycurgan. Tsaynö llatapanpa cuchunta yataycurllam, jina öra yawar apayninpita cuticasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Señor Jesucristonam tapucurgan: “¿Pitan llatapäta yatamurun?” nir. Runacunawan waquincag yanagencuna “Manam nogatsu” niyaptinnam, Pedro nirgan: “¡Maestru, cayläya atscag runachöga jucnin jucninpis tangayäshunquim! Tsaycu gamga ‘¿Pitan llatapäta yatamurun?’ ninqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Señor Jesucristoga yapaymi nirgan: “¡Piycarpis yatamashgam! Podernï yargogtam sentirgö.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsaynö yatanganta tantiyasquiptinnam, mana imanö pacayta puedirnin tsay warmi alläpa mantsacashga Señor Jesucristopa puntanman gongorpacuycur willargan, llapan runacuna wiyaycayaptin imanir yatangantawan cuticanganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Señor Jesucristonam warmita nirgan: “Ïja, nogaman rasumpa criyicurmi cuticargoyqui. Cananga alli päsacuychö tranquïlo cushishga aywacuy.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Señor Jesucristo tsaynö parlaycaptinmi, Jairopa wajinpita juc runa shamur nirgan: “Tayta Jairo, tsuriquiga wañushganam. ¡Amana Maestrupa umantapis nanatsiynatsu!” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tsayta wiyasquirmi Señor Jesucristo Jairota nirgan: “Ama mantsacaytsu, nogallaman firmi criyicamuyga, wamrayqui rasumpam cuticanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairopa wajiman chärirnam, discïpulun Pedrota, Juanta, Santiagota y wamrapa taytantawan mamanta ruriman yaycatsirgan. Waquincag runacuna yaycuyänantaga manam munargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wamra wañushgacaptinmi wagtachö runacuna gayaraycachar wagaycäyargan. Tsayta ricaycurmi Señor Jesucristo nirgan: “Ama wagayaytsu. Wamraga manam wañushgatsu puñucashgallam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wamra wañushgana canganta musyarmi, Señor Jesucristota llapan runacuna asipäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero Señor Jesucristonam maquinpita achcurcur wamrata nirgan: “Wamra, sharcamuy” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wamranam jaynin cutiycuptin, jina öra cawasquir sharcamurgan. Señor Jesucristonam nirgan: “Wamrata micuynin garayay” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wamrapa taytanwan mamannam alläpa mantsacäcur cushishga cayargan. Señor Jesucristonam mandargan: “Ama cay ricäyangayquita ni pitapis willacuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tsaypitanam chunca ishcay discïpuluncunata gayasquir, Señor Jesucristo podernintawan mandacuyninta entregargan, supayyogcunapita supaycunata gargornin geshyagyäshacunata cuticätsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Paycunatam mandargan Dios Yayapa Mandacuy Reynon imanö canganta willacurnin llapan geshyagyashacunatapis cuticätsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tsaymi nirgan: “Aywarga ama tucruta, alporjata, millcapata, gellayta ni llatapayquicuna mödacuyänayquillapagpis apayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","May wajichö patsacurpis, tsayllachö cacuyanqui tsay marcapita aywacuyangayquiyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Si juc marcaman chäyaptiqui runacuna mana chasquiyäshuptiquiga tsay marcapita aywacuyanqui. Tsaypita yargosquir aywacurga chaquiquicunachö polvutapis tapsicusquiyanqui. Tsaynö rurayangayquim, tsay runacunapag juc señalnö canga Dios Yaya castigananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsaypitanam discïpuluncuna marcan marcan maytsay estanciacunapa aywar, Dios Yayapa mushog Alli Willacuyninta maytsaychö willacur geshyagyashacunatapis cuticätsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tsay llapan rurayangancunata rey Herodes musyasquirmi ni imanö cayta puedirgantsu. Tsaymi waquincag runacuna Señor Jesucristopag niyargan: “Juan Bautistam cawamushga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pero waquincagcunanam niyargan: “Dios Yayapa unay willacug profëtan Elíasmi yuricämushga puriycan.” Mas waquinnam niyargan: “Dios Yayapa unay tiempu profëtanchi maygancarpis wañunganpita cawamushga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodesnam nirgan: “Juan Bautistataga quiquïmi umanta rogotsirnin wañutsitsirgä. ¿Pipagtan cayläya imaycacunata ruranganta wiyä?” nirmi, Señor Jesucristota alläpa regeyta munargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tsaypitanam discïpuluncuna puriyanganpita cutisquir, llapan rurayangancunata willayargan. Tsaynam Señor Jesucristoga paycunallata pusharcur, Betsaida marcapa tsunyanchö quiquillancuna jamayänanpag aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero tsay maytsicag runacuna musyasquirmi, gatirnin aywayargan. Runacuna chäriyaptinnam Señor Jesucristo cushishga chasquirnincuna, Dios Yayapa Mandacuy Reynonpag yachatsicurnin geshyagyashacunatapis cuticätsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tardiyaycaptinnam, chunca ishcay discïpuluncuna Señor Jesucristoman witiycur niyargan: “Caychöga tsunya mana ni imacagchömi caycantsic. Runacunata ‘Cuticuyay’ niyna, tsay uray marcacunapawan estanciacunapa aywar, micuynincunawan posädancuna ashicuyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Señor Jesucristonam nirgan: “¡Gamcuna micuynincuna garayay!” Discïpuluncunanam niyargan: “¡Pitsga tantawan ishcay pescädollam capamantsic! Caytsicag runacunapagga rantimurpis, ¿imanörag pagtatsishwan?” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsaychömi pitsga waranganö runacuna cayargan. Tsaynam Señor Jesucristo discïpuluncunata nirgan: “Runacunata pitsga chuncapa patsaman jamacuyänanpag niyay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Señor Jesucristo ningannöllam discïpuluncuna llapan runacunata patsaman jamatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tsaypitam pitsga tantatawan ishcay pescädota aptarcur bendisarnin, Señor Jesucristo cieluman ricarcur Dios Yayata agradëcicusquir, tantata paquin paquin discïpuluncunata entregargan llapan runacunata aypuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Llapan runacuna pacha junta teglla micusquiyaptinnam, sobrag tantacunata discïpuluncuna goriyargan chunca ishcay canastacuna juntatarag. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc cutinam Señor Jesucristo discïpuluncunawan caycar, Dios Yayaman japallan mañacusquir discïpuluncunata tapurnin nirgan: “¿Llapan runacuna nogapag imaniyantan?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Discïpuluncunanam niyargan: “Waquinmi niyan Juan Bautista cangayquita. Waquinnam Dios Yayapa unay profëtan Elías cangayquita yarpäyan. Waquincagcunanam Dios Yayapa unay tiempu profëtan cawamushga cangayquita niyan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tsaynö niyaptinnam, Señor Jesucristo nirgan: “Gamcunaga, ¿Pï cangätan yarpäyanqui? ¿Pitan cä?” Pedronam nirgan: “Gamga Diospa Tsurin Cristom canqui” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Señor Jesucristoga alli yätsirmi alvertirgan, pitapis tsayta mana willacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tsaypitanam nirgan: “Diospita Shamushga Runa captïmi, tucuyläya imaycawan sufritsiyämar maltratayämanga. Autoridäcunawan mayor sacerdöticuna y ley yachatsicugcunam chiquimarnï wañutsiyämanga. Pero wañungäpita quimsa junagllatam cawamushag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tsaynö nirmi runacunata yachatsirgan: “Pipis yachacugnï cayta munarga, quiquinpa munayninta dëjasquir, imayca cruzta wañunganyag apagnö cada junag nogaraycu sufrirpis gatimätsun” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pipis quiquinpa cawayllanpag yarpachacugga, cawaynintam ogranga. Pero pipis nogaraycu wañurga, wac vïdachömi wiñaypa imayyagpis cawanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dios Yaya pitapis infiernuman condenaptinga, cay patsachö llapan goringancunapis, ¿imapagrag tsay runata servinga? ");
INSERT INTO qxnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sïcush pipis nogapitawan yachatsicungäpita pengacunga, tsaynöllam nogapis Dios Yayapita Shamushga Runa caynïwan paypita pengacushag, Dios Yayapa y santo angelnincunapa chipacyag poderninwan cutimurnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pero rasuncagtam niyag: Canan caychö caycagcunapitaga waquinllam manarag wañurnin, Dios Yayapa Mandacuy Reynonta ricäyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tsaynö willacusquirnam, pusag junagtana Pedrota, Juanta y Santiagota pushacur, Dios Yayaman mañacug juc jircaman Señor Jesucristo aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dios Yayaman mañacuycaptinnam, Señor Jesucristopa gagllan jucläya shumag ticrasquirgan. Tsaynöllam llatapanpis imayca illagonörag yurag chipacyagman ticrasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tsay öram ishcag runacuna yurisquir, paywan parlayargan. Paycunam cayargan Moiséswan Elías. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tsayläya chipacyagchömi Señor Jesucristota parlaparnin niyargan: “Dios Yaya unay dispöningannömi, Jerusalénchö wañunqui” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedronam ishcan yanagencunawan pasaypa puñunaywan caycar, puñuysä ricaycurgan Señor Jesucristo Diospa poderninwan ishcag runacunawan chipacyarrag ichiraycäyagta. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tsay ishcag runacuna aywacugnö cayaptinmi, Señor Jesucristota Pedro nirgan: “Maestru, alläpa allim caychö caycantsic. Quimsa tsucllata rurashun, jucta gampag, jucta Moiséspag y juccagtana Elíaspag.” Mana imanö cayta puedirmi, Pedro tsaynö nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsaynö nicaptinnam pucutay yurisquir, llapanta tsapasquirgan. Pucutay rurinchö caycarmi discïpuluncuna mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pucutay rurinpitanam parlamugta wiyayargan: “Cayga nogapa acrashga cuyay Tsurïmi. Payta wiyarnin cäsuyay” nigta. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tsaynö parlar ushasquiyaptinnam, discïpuluncuna Señor Jesucristollatana ricaycuyargan. Pero tsay jircachö ricäyangantaga manam ni pitapis willacuyargantsu, Señor Jesucristo cay patsallachörag caycaptinga. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tsaypitanam waränin jircapita cutiycäyämuptin, maytsicag runacuna shuyaraycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tsay runacunapa rurinpitam juc runa gayaraypa nirgan: “Maestru, rugacullagmi, japallan tsurilläta ricaycullay. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cay tsurillämi supay achcungan öra gayaraycachar ishquirnin ushacan. Tapsitsirnin garentätsirmi shiminchöpis pushugayta cachutsir, imaypis mana dëjaypa alläpa maltratan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Discïpuluyquicunatapis rugacurgömi supayta gargoyänanpag. Pero paycunaga manam puediyantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Señor Jesucristonam nirgan: “¡Allau cay jutsasapacuna, manaran nogaman firmi criyicuyanragtsu! ¡Imayyagrag gamcunawan pagta awantayarniqui caycäshag!” Tsaynö nisquirnam, runata nirgan: “Wamrayquita cayman apamuy” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wamranta taytan chaycatsiptinnam, supay atäquiwan tsariscatsir patsaman ishquistsirnin garentätsir tapsitsirgan. Pero Señor Jesucristonam tsay supayta nirgan: “Cay wamrapita yargoy” nir. Tsaynö nirmi wamrata cuticashgatana, taytanta entregaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tsayta ricaycurnam, runacuna mantsacashganö niyargan: “Dios Yayaga alläpa poderösom” nir. Señor Jesucristo rurangancunapita llapan runacuna mantsacashganö caycäyaptinmi, discïpuluncunata nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Canan willayangagta wiyarnin, yarparäyanqui. Diospita Shamushga Runa captïmi, traicionayämar chiquimagnïcunapa maquinman entreyämanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero discïpuluncunaga manam ni juc entendiyargantsu Señor Jesucristo tsaynö ninganta. Tsaynö ninganta mana juc entendiyänanpagmi quiquin Dios Yaya permïtirgan. Tsaynöllam Señor Jesucristo esplicarnin yachatsinanpag tapucuytapis mantsapäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsaypitanam discïpuluncuna quiquincuna pura piñanacuyargan, llapanpa mandacugnin mas importanti cayta munarnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tsaynö yarpäyanganta Señor Jesucristo musyasquirnam, juc wamrata puntanman ichiycatsir, ");
INSERT INTO qxnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nirgan: “Pipis cay wamranö umilde runacunata cuyarnin, nogapa shutïchö chasquirga, nogatapis chasquiyämanmi. Nogata chasquimarga cachamagnï Dios Yayatapis chasquiyanmi. Tsaymi gamcunapita umilde gollmi shongocag, llapayquipitapis mas mandacugga canga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juannam nirgan: “Maestru, nogacunam ricäyargö juc runata shutiquichö supayyog runacunapita supaycunata gargogta. Pero mana nogantsicwan puriptinmi micharnin amatsayargö.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Señor Jesucristonam nirgan: “Ama michäcuyanquitsu. Pipis mana contrantsic carga, nogantsicwanmi caycan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cieluman Señor Jesucristo cuticunanpag ichicllana faltaycaptinmi, Jerusalén marcaman alli valoracuycur aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tsaynö aywananpagmi puntata willacugninta mandargan. Paycunanam Samaria marcaman chaycur Señor Jesucristopag posädata ashiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero Samaria marca runacunaga manam chasquiyargantsu, Jerusalénman aywanganta musyaycur. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tsayta ricarmi discïpuluncuna Santiagowan Juan niyargan: “Señor Jesús, ¿munanquicu Dios Yayaman mañacuyänäta cielupita nina shamurnin cay runacunata jancat rupar ushacascatsinanpag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero Señor Jesucristonam, paycunaman tumaycur piñapargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsaypitanam juc marcapa aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nänipa aywaycäyaptinnam, Señor Jesucristota juc runa nirgan: “Maestru, maypa aywaptiquipis nogaga gatishayquillam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Señor Jesucristonam nirgan: “Atogcunapapis machaynincuna canmi; pishgocunapapis geshuncuna canmi. Pero Dios Yayapita Shamushga Runapaga, manam iman cantsu ni maychö jamaycur shütaycunällapagpis.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Juc runatanam Señor Jesucristo nirgan: “Gatimay.” Pero tsay runanam nirgan: “Tayta Jesús, gamwan aywanäpagga, puntataga taytätarag pampascamushag” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tsaynam Señor Jesucristo nirgan: “Imayca wañushganö mana criyimagcuna wañushgacunataga pampacuyätsun. Pero gamga aywarnin Dios Yayapa Mandacuy Reynon imanö canganta willacunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Juccag runanam nirgan: “Tayta Jesús, noga gatiränagpag, aywä wajïchö familiacunatarag despedicascamushag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Señor Jesucristonam nirgan: “Pipis imayca gepaman ricaraycar yapyacugnö carga, manam servintsu Dios Yayapa Mandacuy Reynonpag, llapan jutsa rurangancunapag yarpararga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsaypitanam Señor Jesucristo ganchis chunca runacunata acrasquir, ishcay ishcaylla mandargan, Pay chänancag maytsay estanciacunapawan marcacunaman. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tsaynö punta aywayänanpagmi nirgan: “Imayca chacrachö maytsica micuy pogoshganömi, Dios Yayapa Mandacuy Reynonman runacuna goriypag caycäyan. Pero gorigpag peoncunaga alläpa wallcagllam cayan. Tsaymi duëñon Dios Yayata mañacuyay cosëchanman arugcunata cachamunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Aywayay! Cananmi cachayag, imayca juc ashcash atogcunapa rurinman aywagtanö. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aywar ama alporjatawan millcapata, gellayta ni llangeyquita apayanquitsu. Nänipa aywarpis ama ni pitapis ichiycur parlapäyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“May marcaman chäyaptiqui wajincunaman chasquiyäshuptiquiga, rimaycucurnin niyanqui: ‘Caychö täcugcuna shumag alli päsacuychö cawacuyay.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si tsay marcachö patsatsiyäshogniqui runa alli päsacug captinga, saludacuyangayqui alli päsacuymi rasumpa cumplinga. Mana tsaynö shumag päsacuptinga, alli cawacuyninpis manam cumplingatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Posadacurpis tsay wajichö garayäshungayquillata micuyanqui y upyayanqui. Tsaymi yachatsicug runaga imayca alli arupucugnö mallagga canmantsu. Pero ama wajin wajinga puriyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“May marcaman chäyaptiquipis, wajiyog runa cushishga chasquiyäshuptiqui garayäshungayquillata micucuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tsay marcachö geshyagyashacunata cuticätsirnin runacunata willacur niyanqui: ‘Dios Yayapa Mandacuy Reynonpa Alli Willacuynin gamcunaman chaycämunnam’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Si juc marcaman chäyaptiqui mana chasquiyäshuptiquiga, cällicunapa aywarnin niyanqui: ");
INSERT INTO qxnNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Quiquiquicuna culpayog cayangayquita musyayänayquipagmi, marcayquicunapa polvun llangëcunachö lashtacashgatapis tapsicusquiyä. Pero musyayay: Dios Yayapa Mandacuy Reynonpa Alli Willacuyninmi gamcunaman chämurgon.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gamcunatam niyag: Cay mundu ushacangan junagmi unay tiempu Sodoma marca runacuna castigashga cayanganpitapis, mas peor mantsacaypag tsay marcachö mana chasquiyäshugniqui runacuna castigashga cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Allau, Corazinwan Betsaida marca runacuna! Sïcush gamcunapa marcayquicunachönö Tirowan Sidon marcacunachö milagrucunata ruranman cargan, tsay marca runacuna unaynam llaquicurnin jutsancunata dëjasquir alli ruragna cayanman cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tsaymi cay patsa ushacangan juiciu final junagchöpis Tirowan Sidon marca runacuna castigashga cayanganpitapis, mas peor mantsaypag castigashga cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum marcachö pärag runacuna, gamcunagach yarpäyanqui cieluman aywayänayquipag. Pero gamcunaga infiernumanmi aywayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tsaypitanam Señor Jesucristo nirgan: “Pipis gamcunata wiyarnin cäsur chasquiyäshurniquiga, nogatapis cäsur chasquiyämanmi. Gamcunata mana cäsur chasquiyäshurniquiga, nogatapis manam chasquiyämantsu. Nogata mana cäsumar mana chasquimagcunaga, cachamagnï Dios Yayatapis manam chasquiyantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsaypitanam ganchis chunca aywagcuna alläpa cushishga cutisquirnin, Señor Jesucristota niyargan: “Señor Jesús, asta supaycunapis cäsuyämashgam shutiquichö mandayaptï.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Señor Jesucristonam nirgan: “Aumi, imayca illagonöragmi altu cielupita Satanas jegamugta ricargö. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nogam podernïta entregayargog culebracunatawan atog curucunatapis jarucachayänayquipag. Tsaynöllam entregashcag chiquiyäshugniquicunatawan Supaypa podernintapis venceyänayquipag. Nogapa podernïwan cayaptiquiga manam ni imapis päsayäshunquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero tsaynö supaycuna cäsuyäshungayquitaga, ama cushicuyaytsu. Mas bien cieluchö shutiquicuna apuntashga canganta masga cushicuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tsay öra Espïritu Santopa poderninwan shongon alläpa cushicuptinmi, Señor Jesucristo nirgan: “Cieluchöpis patsachöpis Mandacug Dios Yaya, gamtam alläpa alabaycug. Gam rurangayquicunatam mana musyag wamranöcagcunata entenditsinqui. Pero yachagtucugcunatawan musyagtucugcunataga manam ni ima entenditsinquitsu, imayca pacashgatanö catsirnin. Aumi, Taytallä, tsaynö canantam gamga munargoyqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Taytämi llapan imaycata entregamashga. Quiquin Dios Yayallam noga Tsurinta regeman, waquinga manam regeyämantsu. Tsaynö Tsuri captinmi, nogalla Taytätapis regë. Tsaymi noga regetsiptïlla waquincagcunapis regeyan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsaypitanam discïpuluncunaman witiycur paycunallata nirgan: “Nogapa ruraynïcunata ricarmi alläpa cushishga cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tsaymi niyag: Dios Yayapa unay profëtancunawan reycuna cay ricäyangayquicunata ricayta munaycarpis manam ricäyargantsu. Canan wiyayangayquicunata wiyayta munaycarpis manam wiyayargantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsaypitanam juc ley yachatsicug doctor, yachaycarnin yapta upatucur tapurgan: “Maestru, ¿imatatan rurashag wac vïdachö wiñaypa cawanäpag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Señor Jesucristonam nirgan: “¿Imanötan Moisés gellgangan ley yachatsicun? ¿Imatatan tsaychö tantiyanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ley yachatsicugnam nirgan: “Tsaychöga caynömi yachatsicun: ‘Señorniqui Dios Yayata alläpa cuyanqui llapan shongoyquiwan almayquiwan, callpayquiwan y yachayniquiwanpis. Quiquiquitanölla runamajiquicunatapis cuyanqui’ nir.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tsaynam Señor Jesucristo nirgan: “Ningayquiga alläpa allim. Tsaycunata rasumpa cumplirnin rurarga wac vïdachömi wiñaypa cawanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ley yachatsicug doctornam quiquinchö allitucur tapurgan: “¿Pitan tsay runamajïga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tsaymi Señor Jesucristo nirgan: “Juc runam Jerusalénpita Jerico marcaman uraycaptin, tsunya nänichö suwacuna llapan apangancunatawan asta llatapancunatapis jancat gechusquir, alli magacachasquir wañuycagtana dëjasquir aywasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tsay nänipanam juc sacerdöti päsarnin runa wañuycagtana ricaycarpis, mana ricagtucurlla carullapa päsacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tsaynöllam sacerdötipa yanapagnin levita niyangan runapis runa jitaraycagta ricaycur, carullapa päsacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero Israel runacunapa chiquiyangan Samaria runa tsaypa aywaycarnam, runa jitaraycagta tarisquir alläpa llaquipargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Puntanman witiycurmi erïdancunata aceitiwan y vïnowan jampisquir, shumag watarcapurgan. Tsaypitanam ashnunta montarcatsir juc posädaman apaycur, tsaychö cuidargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Waränin allegnam ishcay junag arupucur, gänangan gellayta posadatsicug runata pägar nirgan: ‘Cay runata shumag jampiycullanqui, masta gastaptiquipis cutimurmi, pägallashayqui.’ Tsaynö nisquirmi aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Canan tapushayqui: ¿Cay quimsanpita maygancag runatan runamajinta llaquipargan?” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ley yachatsicugnam nirgan: “Tsay cuyarnin llaquipagcagmi.” Tsaynam Señor Jesucristo nirgan: “Cananga gampis aywarnin tsaynölla llaquipäcug canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tsaypitanam Señor Jesucristo discïpuluncunawan aywaycarnin, juc marcaman chäyargan. Tsaychönam Marta shutiyog warmi wajinman convidargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa ñañan Maríanam Señor Jesucristo yachatsicungancunata wiyarnin, chaquin puntanchö jamaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Martanam imayca ruraycunawan afanädu car, Señor Jesucristoman witiycur nirgan: “Señor Jesús ¿manacu llaquipämanqui caychö ñañä jamacunganyag japallä llapan imaycata ruraycagta? ¡Niycuy yanapamänanpag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Señor Jesucristonam nirgan: “Ä Marta, Marta. Tucuyläya ruraycunapag yarpachacurmi, gam tranquïlotsu canqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero jucllayllam wanacan ruranayquipag. Tsay allicagtam ñañayqui Maríaga acrashga y manam ni pipis tsayta gechungatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Juc cutinam Señor Jesucristo Dios Yayaman mañacurgan. Mañacur ushasquiptinnam, juccag discïpulun nirgan: “Señor, nogacunatapis yachaycätsiyämay Juan Bautista discïpuluncunata yachatsingannö Dios Yayaman mañacuyänäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsaymi Señor Jesucristo nirgan: “Dios Yayaman mañacur niyanqui: Cieluchö caycag, Dios Yayalläcuna, Respetashga shutiqui cuyay catsun. Mandacuy Reynoyqui nogacunaman shamutsun. Munangayqui ruracätsun cay patsachö janag patsachönö. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Micuylläcuna llapan junagpag garaycayämay. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jutsalläcunata gongaycuy, nogacunapis runamajïcunapa jutsanta gongayangänö. Tentacionman mana ishquiyänäpag tsaypaycayämay. Llapan imayca mana allicunapitapis geshpiycatsiyämay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tsaypitanam Señor Jesucristo nirgan: “Masqui maygayquipis amïgoyquicunapa wajinman pullan pagas aywar niyanqui: ‘Amïgo, quimsa tantallata prestaycamay. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc amïgömi carupita chämushga y manam ni imalläpis cantsu garaycunäpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pero wajin rurinpitanam contestayäshunqui: ‘Cay öra ¿imagtan shamunqui puñuynïtapis chawätsimar? Puncütapis trancashcänam. Wamräcunawan quiquïpis puñuyashcänam. Imata prestanagpagpis manam shärimuyta puedïtsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nogam niyag: Manam amïgoyqui carpis, juc töcayllachöga prestashunayquipag shärimungatsu. Pero sïcush yapay yapay tacacunqui, tsaymi sïga prestashunayquipag shärimunga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Tsaymi niyag: Dios Yayaman mañacuyaptiquiga garayäshunquim. Ashirga tariyanquim. Puncuta tacacuyaptiquipis quichayäshunquim. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tsaynöllam Dios Yayaman yapay yapay mañacugcagga chasquinga. Ashigcagga taringam. Puncuta tacacugtaga quichayäshunquim. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Acäsu maygayquipis wamrayquicuna, ‘Pescädota garamay’ niyäshuptiqui, ¿culebratatagcu garaycuyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tsaynöllam ‘Runtuta garamay’ niyäshuptiquipis, ¿atog curutatagcu garaycuyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gamcuna mana alli rurag caycarpis, wamrayquicunata mas allicagtam garayanqui. Tsaynömi cieluchö caycag Taytayqui Dios Yayaga gamcunapitapis mas alli, mañacugcunataga Espïritu Santonta garananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cutim, Señor Jesucristo mana parlag runapita supayta gargorgan. Tsaynö supay yargosquiptinnam, tsay runa parlar gallaycuptin runacuna alläpa mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero waquincagnam niyargan: “Cay runaga supaycunapa mandagnin Beelzebú niyanganpa poderninwanmi runacunapita supaycunata gargon.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquincagnam Señor Jesucristota pantatsiyta munar, cieluchöcag milagrucunata rurananta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tsaynö yarpäyanganta musyasquirnam nirgan: “Si juc naciunchö runacuna quiquincunapura chiquinacurnin raquicar cayaptinga, tsay naciunchö runacunam raquicar ushacäyanga. Tsaynöllam juc wajichö täcugcunapis quiquincunapuralla chiquinacur cawarga, imayca tsay waji juchugnö jancat raquicar ushacasquiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tsaynöllam supaycunata runacunapita Satanas gargorga, quiquinpa contran car mandacuy reynontapis jancat ushacascatsinman. ‘Beelzebúpa poderninwanmi supaycunata gargon’ niyämaptiqui, caynö niyag: ");
INSERT INTO qxnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Satanaspa poderninwan supaycunata gargoptïga, ¿pipa poderninwantan gatiräshugniquicuna supaycunata gargoyan? Paycuna rurayanganmi musyatsicur entenditsiyäshunqui mana allicunata parlayangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero quiquin Dios Yayapa poderninwan supaycunata noga gargoptïmi, rasumpa musyayanqui Dios Yayapa Mandacuy Reynon gamcunaman chämushgana canganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Masqui juc alli callpayog runa gerunwan wajinta täpaptinga, manam ni pï imantapis suwangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero paypita mas alli callpayog suwa chärirmi, tsay täpacug runa gerunta yätsicuycaptin gechusquirnin magacachasquir imantapis gechunga. Tsaynö vencesquirmi llapan imaycantapis suwarnin munanganta ruranga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tsaymi pipis nogapa fabornï mana carga, conträ caycan. Nogawan pagta runacunata Diospa Mandacuy Reynonman mana gorigcagga, jancatmi witsisquingalla. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Supayyog runapita supay yargosquirnam tsunyacunapa aywar, mayllachöpis jamaycunanpag ashirnin purin. Tsaychö mana tarirnam yarpan: ‘Yargamungä runamanmi cuticushag päragnin.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Runaman cutirnam tarin, imayca shumag pitsapacushga jinallan jäcu wajitanö tsay runapa shongon caycagta. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsaynöta tarisquirnam, supayga aywarnin ganchis mas peor mana alli rurag supaycunata ashisquirnin pusharcur cutin. Tsaynö llapan aywarmi runapa shongonman yaycusquir, tsaychö pärayan. Tsaynö atsca supaycuna shongonchö pärayaptinmi, tsay runaga punta canganpitapis mas peor mana alli rurag ticran.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Señor Jesucristo tsaynö yachatsicuycaptinmi, runacunapa rurinpita juc warmi gayaraypa nirgan: “¡Alläpa cushishga catsun, wachagniqui y chuchushugniqui warmi!” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Señor Jesucristonam nirgan: “Tsaypitapis mas cushishgaga cayan, Dios Yayapa Palabranta wiyarnin rasumpa cäsucugcunam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsaypitanam maytsicag runacuna goricar sïgiyaptin Señor Jesucristo nirgan: “Canan tiempu runacunaga alläpa mana alli ruragmi cayan. Milagruta ruranätam munayan, pero manam ni juc milagrullatapis rurashagtsu, unay Jonás niyangan runachö Dios Yaya rurangantanö. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tsay unay Jonás runachö Dios Yaya imayca señaltanö juc milagruta rurar, Ninive marca runacunata ricätsingannömi, Dios Yayapita Shamushga Runapis, canan cay tiempu runacunata juc milagru señalta ricätsinga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cay patsa ushacangan juiciu junagchömi, cay mundupa uraninpita shamug Sheba marcapa reynan warmi, Dios Yayapa puntanchö shimpiyäshunqui. Tsay warmiga Salomón allish yachayninwan Diospag parlagta wiyagmi, alläpa caru marcapita shamurgan. Pero tsay unay Salomónpitapis mas yachayyog poderösom canan caychö caycag runaga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tsaynöllam cay patsa ushacangan juiciu junagchö, Ninive marca runacuna canan cay tiempu runacunata shimpir condenayäshunqui. Tsay Ninive marca runacunaga Jonás willacunganta wiyar cäsucurmi, llapan jutsancunapita arepenticur dëjayargan. Tsaynöllam tsay unay Jonáspitaga canan caychö caycag runa mas poderöso caycaptinpis, jutsayquicunata arepenticurnin dëjayta munayanquitsu ni criyiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Manam ni pipis linternata sendircur, cajonpa gopinmantsu ni maymanpis pacapanmantsu churan. Mas bienmi mas altuman churan, wajiman yaycugcunata shumag actsipänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñawiquicunaga imayca juc actsinömi cuerpuyquicunapag. Tsaymi ñawiquicuna shumag alli ricaptinga, llapan cuerpuyquicunapis imayca actsichönö canga. Pero si ñawiquicuna mana alli ricaptinga, llapan cuerpuyquicunapis imayca tutapaychönömi canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","¡Cuidädu cayay, gamcunachö rasumpa firmi criyicuyniquicuna imayca actsi wañugnö tutaparnin mana ushacänanpag! ");
INSERT INTO qxnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tsaymi si gamcuna rasumpa imayca actsinö wiyayangayquita cäsucuyaptiquiga, manam tutapaychöga ni imaypis cayanquitsu. Sinöga alli actsichönömi cayanqui, imayca actsi llapanman atsicyangannö.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Señor Jesucristo yachatsicur ushasquiptinnam, juc fariseo runa wajinpa pushargan micuyänanpag. Yaycusquirnam Señor Jesucristo mësaman jamaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pero costumbrincunamannö maquinta mana mayllacur micuptinnam, tsay fariseo mantsacashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tsaynam Señor Jesucristo nirgan: “Gam fariseocunaga costumbriquicunata cumplirllam, täsacunatawan plätucunata mayllagnö janayquicunallata limpiapäcuyanqui. Pero shongoyquicunachöga alläpa codiciösu tucuyläya mana alli rurag suwam cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ä upa runacuna, ¿manacu musyayanqui ricacag cuerpuyquicuna rurag Dios Yayalla shongoyquicunatapis ruranganta? ");
INSERT INTO qxnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wactsacunata llaquipar llapan shongoyquicunawan imallancunapis garaycuyay. Tsaynöpam llapan yarpäyangayquiwan rurayangayquipis alli limpiu canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Allau, fariseocuna! Gamcunam mentapitawan rudapita y waquincag gorapita chuncaman raquisquir juc chuncacagllata Diostaga garayanqui. Tsaynö carmi Dios Yayapa cuyapäcuynintawan llaquipäcuynintapis gongayashcanqui. Pero caycunapitapis masga mana gongarlla Dios Yayapag limushnata garayay. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Allau, gam fariseocuna! Dios Yayaman mañacuyänanpag goricäyänan wajichöpis punta punta allicag jamacunacunachömi jamacuyta munayanqui. Cällicunachö purirpis runacuna ‘Señor, doctor’ nir, respetar saludar rimaycuyäshunayquitam munayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Allau! Mana ricacag sepultürachö ismuycag ayacunanömi gamcunaga cayanqui. Tsay sepultüra jananpa runacuna purirpis manam musyayantsu, rurinchöga ni ima cangantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Señor Jesucristo tsaynö niptinnam, ley yachatsicug runa nirgan: “Maestru, tsaynö parlarga, nogacunatapis ofendiycäyämanquim.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tsaynam Señor Jesucristo nirgan: “¡Allau, gam ley yachatsicugcunapis! Alläpa aja mana ruraypagtanömi, runacuna rurayänanpag mandacuyanqui. Pero tsay aja mandacuyangayquita, quiquiquicunaga manam ni juc dëdullayquicunallawanpis yanapar yatarcuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Allau, gamcuna! Unay aylluyquicunam Diospa willacug unay profëtancunata wañutsiyargan. Pero gamcunaga tsay pamparayangan sepultürancunatam alläpa shumag ruratsirnin adornayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tsay rurayangayquiwan testïgu carmi, unay aylluyquicuna rurayangantapis ‘Allim cargan’ niyanqui. Tsaynömi paycuna unay profëtacunata wañutsiyargan y gamcunanam sepultürancunata shumag ruratsir adornaycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Quiquin Dios Yayam alläpa poderöso cayninwan nirgan: ‘Gamcunamanmi profëtäcunatawan apostolnïcunata mandamushag. Tsay mandamungäpitam waquincagta wañutsiyanga y waquincagcunatanam mana alli ruragtanö gaticachäyanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tsaymi cay patsa gallanganpita Dios Yayapa profëtancunata, aylluncuna wañutsiyanganpita asta canan tiempu runacunam pägacuyanga, ");
INSERT INTO qxnNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel wañunganpita asta Zacarias wañunganyag. Unay Zacariastam santïsimu niyangan altarpa puntanchö wañutsiyargan. Rasuntam niyag: Paycunapa yawarninta jichayanganpitam asta canan tiempu runacunapis pägacuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Allau! Ley yachatsicugcuna, runacuna yachacuyta munayaptinpis gamcunaga manam yachatsicuyanquitsu. Gamcunaga rasumpacagta musyaycarpis manam rurayanquitsu. Pero waquincagcuna Dios Yaya manangannö rasumpacagta yachacurnin rurayta munayaptinpis, gamcunaga amatsacurmi michäcuyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Señor Jesucristo tsaynö ningancunata wiyarmi, fariseocunawan ley yachatsicugcuna alläpa piñacuyargan. Prësu achcuyta munarmi, imaycallatapis tapucur ashiyargan, tucuyläyapa shimpiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tsaynöllam pantatsiyta munar, imaycallatapis mana allita parlananta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tsaypitanam alläpa maytsicag runacuna waranga warangapayag goricar, quiquincuna pura cunjanacur jarunacuyargan. Tsaychönam discïpuluncunallata puntata yachatsirnin, Señor Jesucristo nirgan: “Tsay allishtucug fariseocunapita cuidacuyay. Paycunaga rasumpacagta musyaycarpis manam cumpliyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tsaymi canan pacayllapanö imapis rurayangan jancat ricacashga canga. Tsaynöllam canan mana regeshga caycagcunapis, jancat musyacanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tutapaychö pacayllapa parlayangayquitam, junagpa llapan wiyayanga. Tsaynö pacayllapa waji rurinchö parlayangayquitapis, wagtachömi gayacur mas jinchi willacuyanga llapan runacuna musyayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amïgocuna, gamcunatam niyag: Ama wañutsicugcunata mantsayanquitsu. Tsaynö wañushgatanaga mananam ni imanaytapis puediyäshunquinatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero nogam rasumpa yachatsiyashayqui pipita mantsacuyänayquipag canganta. Rasumpaga mantsacuyanqui, wañuscatsiyäshurniqui poderöso cayninwan infiernuman garpur ushacätsiyäshugniqui Dios Yayapita. Tsaymi canan willayag paypita rasumpa mantsacuyänayquipagga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tsay ichishag pitsga pishgopa chaninga, ¿manacu ishcay gellaylla? Tsaynö alläpa ichiclla chanin caycaptinpis, Dios Yayaga paycunapag siemprim imaypis yarparaycan. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pero gamcunaga tsay atsca ichishag pishgocunapitapis masmi väleyanqui. Ama ni imapitapis mantsacuyaytsu, Dios Yayaga asta umayquicunachö ayca agtsayquicuna cangantapis musyanmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Tsaymi niyag: Pipis runacunapa puntanchö fabornï parlaptinga, Diospita Shamushga Runa cayninwanmi angelcunapa puntanchöpis tsay runapa fabornin parlashag. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero pipis runacunapa puntanchö mana regemagtucur nëgamaptinga, nogapis Dios Yayapawan angelnincunapa puntanchö mana regegtucurmi nëgashag. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Si pipis Diospita Shamushga Runapa contran parlaptinga, Dios Yaya perdonangam. Pero pipis Espïritu Santopa contran parlaptinmi sïga, Dios Yaya manana ni imaypis perdonangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Si Dios Yayaman mañacuyänanpag goricayänan wajimanwan juezcunaman o maygan autoridäcunamanpis demandayäshuptiqui, ama llaquicuyanquitsu: ‘¿Imanörag parlashag? O ¿Imanörag defendicushag?’ nirga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tsaycunachö parlayänayqui öram, Espïritu Santo imatapis allillata parlayänayquipag yachatsiyäshunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tsaypitanam atscag runacunapa rurinpita, Señor Jesucristota juc runa nirgan: “Maestru, waugëta niycuy töcamangan erenciäta raquipamänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Señor Jesucristonam nirgan: “Amïgo, nogaga manam jueztsu cä, tsay erenciayquicunata raquipuyänagpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsaypitanam llapan runacunata nirgan: “Cuidädu cayay, alläpa ambriento mallagashga codiciösutag cayanquiman. Juc runa shumag alli cawananpagga, manam imayca riquësayog rïcu caytaragtsu wanan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tsaynö parlarmi, juc capugyog rïcu runawan iwalatsicuypa yachatsicur nirgan: “Unaymi juc capugyog rïcu runapam chacranchö alläpa atsca cosëchan cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tsaymi yarpachacur nirgan: ‘¿Caytsica cosëchäwanga imatarag rurashag? ¿Maymanrag churashagpis? Mananam wajïpis cay llapanpagga pagtantsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Tsaynö yarpachacusquirmi, ‘Caynömi rurashag’ nirgan: ‘Gollgäcunata pascasquirninmi mas jatusagta ruratsishag, tsayman llapan cosëchäcunatawan llapan capamagnïcunata churanäpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tsaypitanam shongöllachö nishag: ‘Atsca watapagmi imaycäpis capaman. Cananga mananam arur afanacushagnatsu. Micucur, upyacur, cushishgallanam imaypis cawacushag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Pero Dios Yayanam nirgan: ‘¡Gamga alläpa upa runam canqui! ¡Canan pagasmi wañunqui! ¿Tsay afanacur llapan churangayquicunapis pipagrag quëdanga?’ ");
INSERT INTO qxnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Tsaynömi päsan cay patsallachö imayca riquesacunata gorig runataga. Tsaymi Dios Yayapa puntanchö mana ni imayog wactsapitapis mas peor llaquipaypag canga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","“Tsaypitanam Señor Jesucristo discïpuluncunata nirgan: Ama yarpachacuyaytsu. ‘¿Imanörag cawashag? o ¿Imatarag micushag? ¿Imatarag upyashag? ¿Imatarag cuerpüman shucucushag?’ nirga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tsay micuypitaga caway vïdayquicunam mas välen y llatapayquicunapitapis gamcunam mas väleyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Canan shumag entendir tantiyacuyay. Pishgocunaga manam murucuyantsu ni micuynincuna goriyantsu ni churacuyänanpis cayäpuntsu. Pero tsaynö cayaptinpis, quiquin Dios Yayam pachancuna junta wätan. ¿Acäsu gamcunaga manacu tsay pishgocunapitapis mas väleyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mayjina yarpachacurpis, ¿maygayquitan tsay yarpachacuycunawan juc öra masllapis cawayanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tsaynö mana ni ima ichicllatapis rurayta puediycarga, ¿imapagtan cay vïdachöcagcunallapag yarpachacuyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Masqui jircacunachö waytacuna wiñagta ricäyay. Paycunaga manam arucuyantsu ni putscacuyantsu. Tsaymi niyag: Waytacunapa alläpa shumag tuctuyninwanga, manam unay rïcu rey Salomónpa chipacyag llatapanllapis waytacuna alläpa cuyacuypag canganwanga iwalargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tsaynömi canan shumag jircacunachö gewacuna wiñayan. Pero warayga ninawan ruparmi jancat ushacasquiyanga. Dios Yayaga tsaynö ichishag goracunata llatapatsinganpitapis, mas shumagmi gamcunataga llatapatsiyäshunqui, ¡Diosman mana criyig runacuna! ");
INSERT INTO qxnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tsaynö caycaptinga ama yarpachacur, llaquishga puriyanquitsu: ‘¡Imatarag upyashun o micushun!’ nirga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsaynö yarpachacurmi Dios Yayaman mana criyicugcunaga cawayan. Pero gamcunataga cieluchö caycag Taytayquicunam imayquicuna faltangantapis musyarnin yanapayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tsaymi gamcunaga Dios Yayapa Mandacuy Reynonta ashiyay, Pay munanganllata rurarnin. Tsaynö cawayaptiquim, Dios Yaya garayäshunqui llapan wanayangayquicunatapis. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Gatirämagnïcuna wallcaglla carpis, ama mantsacuyanquitsu. Quiquin Taytayqui Dios Yayam Mandacuy Reynonman gamcunataga cushishga churayäshunqui paywan pagta mandacuyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Imayquicunatapis ranticusquir, wactsacunata gellaynincuna raquipuyay. Tsaynö wactsacunata imaypis mana ajayaypa generöso cayniquiwan yanapar, cieluchö mana ushacag fortünayquicuna ashiyay. Tsaymanga manam suwapis chantsu ni puyupis manam ushangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tsaymi maychö fortünayqui canganchö shongoyquipa yarpayninpis caycanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Gamcunaga imayca shumag llatapayquicunawan listo wiyag wiyag, actsiquicunapis sendicushganö caycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imayca servicug runacuna patronnin casaray fiestapita cutinanta shuyarar cayanganö caycäyanqui. Tsay runacunagam patronnin chärir tacacusquiptin, jina öra puncuta quichayanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tsaynö listo prevenicushga shuyaycag wätaycuna alläpa cushishga cayätsun, patronnin chärir shuyaycagta taringanpita. Rasuncagtam niyag: Tsaynöta tarirga quiquin patronmi alläpa cushishga mandilnin churacurcur, tsay servignincunata jamaycätsir micuynincuna garanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pullan pagastsurag o madrugädutsur patronninga chärir wiyag wiyag caycagta taringa. Tsaynö shuyaycag servicugcuna alläpa cushishga cayätsun. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Masqui cayta shumag entendiyay: Si juc wajiyog runa imay öra suwa shamunanta musyarga, manam imantapis suwananta dëjanmantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tsaynölla gamcunapis wiyag wiyag shuyäyämanqui, mana musyayangayqui öram cay patsaman Diospita Shamushga Runa caynïwan cutimushag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsaynö Señor Jesucristo niptinnam, Pedro tapurgan: “Señor, ¿tsay iwalatsicuywan yachatsicungayquiga nogacunallapagcu o llapan runacunapagpiscu?” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Señor Jesucristonam nirgan: “¿Pim tsay alcäbu alli confiacuypag servicug? Tsaycagtam patronnin confiacur wajinman churanga, tsaychö servignincunata alli örachö micuynincuna garananpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tsay confiädu servicugga alläpa cushicutsun, patronnin char imaycatapis allillata ruraycagta tariptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Rasuncagtam niyag: Tsay confiädu servignintam, llapan imaycanmanpis patronnin confiacur mandacunanpag churanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero si tsay servignin quiquinllanchö yarpar ‘Patronnï cutimunanpag unayragmi demoramunga’ nir, servicugmajincunata warmitapis ollgotapis magarnin allgotsacur micucur y upyacur machashga cacunga, ");
INSERT INTO qxnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tsaynö mana allicunata rurar shuyänanpag manarag alistacugta tarisquirmi, patronnin mana musyangan öra illagpita chaycur, tsay mana alli rurag servigninta mana criyicug runacunatawan iwal alläpa mantsacaypag castiganga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Si maygan servicugpis patronnin munanganta musyaycar, mana cäsucurnin mana wiyag wiyag captinga, tsay wätaynintaga alläpa magarmi mantsacaypag castiganga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero mandacungancunata mana musyar, mana allicunata ruraptinmi sïga llaquipaycarlla castigarnin magangapis. Tsaymi pitapis atscata entregarga, tsaynö atscata cutitsinanta munanga. Tsaynöllam pitapis mas confiacurga, tsay confiacungan runapita mas confiansan cananta mañanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nogagam cay munduman shamushcä, imayca nina rupaycagnö llapan mana allicagcunata ushacätsinäpag. ¡Tsaymi nogaga imanö munaycü, mayna lunyar ruparnin ushacaycäyänanta! ");
INSERT INTO qxnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero nogaga obligädum alläpa sufrïrnin wañunä. ¡Tsaytam alläpa llaquicur, asta cumplinganyag shuyaraycä! ");
INSERT INTO qxnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Gamcunaga cay patsaman alli päsacuyta apamur shamungätacu yarpäyanqui? Manam tsayga tsaynötsu. Nogaraycum runacuna quiquincunapura raquicäyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpitagam juc wajichö pitsgag caycar raquicäyanga. Quimsagcagmi, ishcagpa contran y ishcagcannam quimsanpa contran cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tsurinpa contranmi taytan, taytanpa contranmi tsurin, wawanpa contranmi maman, mamanpa contranmi wawan, llumtsuyninpa contranmi suegran y suegranpa contranmi llumtsuynin nogaraycu piñanacur raquicäyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Caytapis Señor Jesucristo maytsicag runacunata nirganmi: “Rupay jeganan lädunchö pucutay shärigta ricarmi ‘Tamyamunganam’ niyanqui. Tsay niyangayquinöllam rasumpa tamyan. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Uraypa wayrämuptinnam ‘Usyar achämunganam’ niyanqui. Tsay niyangayquinöllam rasumpa usyar achämun. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tsaytaga rasumpa allishmi musyayanqui ¡alläpa yachagtucugcuna! Pero manam tantiyar musyayanquitsu canan tiempu caychö ima päsaycangantaga. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Imanirtan mana tantiyacuyanquitsu allita o mana allita ruraycäyangayquitapis? ");
INSERT INTO qxnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Si pipis demandar juezman apatsiyäshuptiquiga, nänita aywaycarlla manarag juezpa puncunman char, demandashugniquiwan amistayta ashiyanqui. Tsaynö mana amistayta ashiptiquiga, juezman chaycatsishuptiquim wardiacunaman päsatsishunqui. Wardiacunanam carcelman apar gaycuyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nogam niyag: Tsay carcelpitaga llapan dëbecungayquita manarag pägacurga, manam ni imanöpa yargamunquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tsaypitanam Señor Jesucristota ricagnin shamug runacuna, Galilea runacunata Pilato wañuscatsir Dios Yayata ofreceyangan wätacunapa yawarninwan, tsay wañug runacunapa yawarninta tallunganta willayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tsayta willayaptinnam, Señor Jesucristo nirgan: “¿Gamcunaga yarpäyanqui tsay wañug runacunata tsaynö päsanganga, llapan marcamajincunapitapis mas alläpa jutsasapa cayangantacu? ");
INSERT INTO qxnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero nogam niyag: Manam tsayga tsaynötsu. Si llapayqui jutsayquicunata dëjasquir arepenticurnin Dios Yayaman mana cutirga, tsay runacunanöllam sufrir llapayqui wañuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O ¿Gamcunaga yarpäyanqui Jerusalénchö Siloé niyangan törre juchur, chunca pusag runacuna (18) marcamajincunapitapis mas alläpa jutsayog cayanganpita wañuyangantacu? ");
INSERT INTO qxnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Manam tsayga tsaynötsu cargan! Pero si gamcuna jutsayquicunata dëjasquir arepenticurnin Dios Yayaman mana cutirga, paycuna wañur ushacäyangannöllam llapayqui wañur ushacäyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsaynö nisquirnam, iwalatsicuypa yachatsicurnin Señor Jesucristo nirgan: “Juc runapam ïgos jachan chacranchö capurgan. Juc cutinam tsay runa ‘Ïgosnï mä wayuncush’ nir, ricag aywargan. Pero manam ni jucllayllatapis wayuynintaga tarirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsaynam chacranchö cuidag runanta chacrayog nirgan: ‘Quimsa watanam cay ïgosman shamü wayuyninta pallag, pero manam ni jucta tarïtsu. ¡Wallusquiy! ¡Imapagnatan mana wayuycar chacrächö canga!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Pero chacran cuidag runanam nirgan: ‘Mä, cay watallana caycutsun. Allpata cuyutsipasquir, chapanman wanun wiñarcushag. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsaynö abonarcuptï cay wata wayuptinga allishmi canga. Pero tsaychö mana wayuptinmi sïga, wallusquir jitasquishag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tsaypitanam sabado jamay junag goricäyänan wajichö caycäyaptin, Señor Jesucristo yachatsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tsaynö yachatsicuycaptinmi, chunca pusag watana curmuyashga warmi tsaychö caycargan. Tsay warmiga manam derechacayta puedirgantsu, paychö supay päraptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Señor Jesucristo tsay warmita ricaycurmi, gayasquir nirgan: “Warmi, curmu cangayquipita cuticashganam canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tsaynö nir, warmipa jananman maquinta churarcuptinmi, derechacasquir jina öra Dios Yayata agradëcicur alabargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tsay sabado jamay junagchö Señor Jesucristo cuticascatsiptinmi, tsay goricäyänan wajichö mandacug piñacurnin runacunata nirgan: “Sogta junagllam aruntsicga. ¿Imanirtan jamay sabado junagchörag cuticätsiyäshunayquipag shayämunqui? ¿Manacu tsay arungantsic junagchö shayämunquiman?” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tsaynam Señor Jesucristo nirgan: “¡Janan shongo washarimacuna! ¿Manacu maygayquipis jamay sabado junagchö bueyisniquicunatawan ashnuyquicunata pascasquir, yacutsigllapis apayanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cay warmiga unay Abrahampa ayllun shamugpitam. ¡Allau! Chunca pusag watanam Satanas caynö geshyatsir imayca watarätsignö sufritsishga. Tsaynö caycaptinga ¿Manacu jamay sabado junagchöga imayca pascagnö geshyanganpita cuticätsïman?” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Señor Jesucristota tsaynö niptinnam, chiquignincuna pengacuyargan. Pero waquincag runacunanam mantsacashganö alläpa cushishga cayargan, Señor Jesucristo llapan rurangancunata ricar. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tsaynöllam Señor Jesucristo nirgan: “¿Dios Yayapa Mandacuy Reynonga imawanrag iwalanman? ¿Imallatawanrag iwalatsïmanpis? ");
INSERT INTO qxnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dios Yayapa Mandacuy Reynonga, imayca mostäza muruta juc runa chacranman murungannömi. Mostäzapa ichic murun jegarcamurnam wiñarnin imayca jachanö ticran. Tsay imayca jachanö captinmi pishgocunapis shamurnin, rämancunachö geshuncuna rurayan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tsaynöllam yapay nirgan: “¿Dios Yayapa Mandacuy Reynonta imawanrag iwalatsïman? ");
INSERT INTO qxnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tsay Mandacuy Reynonga imayca juc warmi levadürata quimsa almun jarinaman wiñarcur, tsay llapan mäsata pogotsinanpag pichungannömi.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsaypitanam Jerusalénman Señor Jesucristo aywarnin marcacunapawan estanciacunapa päsar llapanta yachatsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tsaychönam juc runa tapurgan: “¿Señor, wallcagllacu runacuna salvacuyanga?” Señor Jesucristonam contestargan: ");
INSERT INTO qxnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gamcunaga imaycanöpis quichqui puncupa yaycugnörag cieluman salvacar yaycuyänayquipag ashiyay. Nogam niyag: Atscagmi yaycuyta munar ashiyanga, pero manam puediyangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wajiyog runa sharcur wajinpa puncunta wichgasquiptinmi, wagtachö quëdasquir tacacuyanqui: ‘Señor, quichaycayällämay’ nir. Pero wajiyognam ruripita ‘¡Manam regeyagtsu, maypitarag cayanquipis!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tsaynam niyanqui: ‘Gamwanmi micurgä y upyargä. Marcäcunapa cällincunachömi yachatsicurgayquipis.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero wajiyognam niyäshunqui: ‘¡Nogapita nogapita witiyay, manam gamcunata regeyagtsu!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tsaynö infiernuman gargoyäshuptiquim quiruncunatapis regochyätsirrag wagarnin sufriyanga, cieluchö Dios Yayapa Mandacuy Reynonchö Tayta Abrahamwan Isaac, Jacob y Dios Yayapa unay profëtancuna caycäyagta ricarnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pero cay mundupa uranincagläpitawan janagnincagläpita y rupay yargamunancagläpitawan rupay jeganancagläpita juclä runacunam shayämunga, Dios Yayapa Mandacuy Reynonchö pagta juc mësallachö micupacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tsaymi canan waquincag gepachöcagcuna puntachö cayanga. Tsaynöllam canan puntachöcagcunapis gepachöna cayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tsaypitanam fariseocuna Señor Jesucristoman chaycur niyargan: “Rey Herodesshi wañutsishuyniquita munan, caypita jucläman aywacuy.” ");
INSERT INTO qxnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Señor Jesucristonam nirgan: “Gamcuna canan aywar, tsay atognö sabïduta willayay: ‘Canan warayga runacunapita supaycunata gargormi, geshyagyashacunatapis cuticätsishagrag. Warantinran llapan ruranäpagcagcunata cumplishag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Imanö captinpis Jerusalénman aywayta sïgishagmi, canan, waray y warantinpis. Rasuncagtaga Dios Yayapa profëtancunaga manam Jerusalénpita juclächöga ni jucpis wañuyanmantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Ay Jerusalén, Jerusalén marca runacuna! Gamcunam Dios Yayapa profëtancunata wañutsir, Alli Willacuyninta willacuyänanpag cachamungancunatapis sagmayargayqui. Nogam yapay yapay munargä, imayca wallpa chipshancunata ripran gopinman gorisquir ogllagnö catsiyayniquita. ¡Pero manam gamcunaga munayargayquitsu! ");
INSERT INTO qxnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ricar tantiyacuyay, Dios Yaya gamcunapita raquicasquiptinmi, imayca mana imannag jäcu wajinö abandonädo quëdayanqui. Tsaymi canan niyag: Gamcunaga mananam ricäyämanquinatsu asta llapayqui, ‘¡Alläpa cushicuypagmi Dios Yaya cachamungan Cristo’ niyangayquiyag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tsaypitanam jamay sabado junagchö Señor Jesucristo mandacug fariseopa wajinman micug aywargan. Tsaychö caycagcunanam Señor Jesucristota gawaräyargan, “Mä, canan ¿imatash ruranga?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Señor Jesucristopa puntanchönam jancat sacsapäcuywan geshyagyasha runa caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Señor Jesucristonam fariseocunatawan mas allish ley yachatsicugcunata tapurgan: “Canan jamay sabado junagchö ¿geshyaycag runata alli cuticätsïman o manacu? Leynintsicga ¿imanötan mandacun?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero fariseocunaga upällallam cayargan. Tsaymi sacsapäcuywan geshyaycag runata Señor Jesucristo achcurcurnin cuticascatsir, “Aywacuyna” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tsaypitanam fariseocunatawan ley yachatsicugcunata Señor Jesucristo nirgan: “Jamay sabado junagchö wamrayquicunawan bueyisniquicuna sanjaman jegasquiptin, ¿manacu maygayquipis jina öra jorgoyanquiman?” ");
INSERT INTO qxnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero fariseocunaga manam contestayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tsaypitanam convidädocuna mas allicag sillïtacunata jamayänanpag acragta ricaycur, Señor Jesucristo iwalatsicuypa yachatsicurgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Casamientu fiestaman convidayäshuptiqui, ama importanticag runacunapa jamacuyänanman jamacuyanquitsu. Talbesga gampita mas importanticag runacunatapis convidashga canman. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tsay jamacunacunaman jamacuptiquiga, wajiyog runam shamuycur niyäshunqui: ‘Shäriy, cay mas importanticag runa tsayman jamacananpag.’ Tsaynö gargoyäshuptiquim pengacurnin, gepaman aywar jamacunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tsaymi imamanpis convidayäshuptiqui aywarga, gepamanpalla jamacunqui. Tsaynöta ricaycuyäshurniquim, wajiyog runa shamuycur niyäshunqui: ‘Amïgo, cay puntaman aywacamuy jamacallämunayquipag’ nir. Tsaynöpam llapan convidashgamajiquicunapa puntanchö mas respetashga alli runa cangayquita musyayanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tsaynö licachaycachar allishtucug runaga pengacushgam canga. Pero umilde gollmi shongo runaga mas importantim canga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tsaypitanam convidagnin fariseota Señor Jesucristo nirgan: “Gampis, wajiquichö ima banquëtita rurarpis, ama mas importanticag amïgoyquicunallatawan, waugeyquicunallataga y aylluyquicunallatawan capugyog marcamajiquicunallataga convidanquitsu. Paycunallata convidaptiquiga, rantintanam gamtapis, paycunaga convidayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tsaypa rantinga mas bien wajiquichö ima banquëtita rurarpis, convidarnin gayatsinqui wactsacunatawan inväliducunata y wishtucunatawan gapracunata. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tsaynö llapanta convidasquirmi shongoyquichö cushishga canqui, tsay wactsacuna mana cutitsiyta puediyäshuptiqui. Pero tsaynö mana imannagcunata garaycungayquipitam quiquin Dios Yaya cutitsishunqui, alli rurag runacuna cawayämungan junagchö.” ");
INSERT INTO qxnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tsaynö Señor Jesucristo yachatsicunganta wiyaycurnam mësa lädunchö jamaycag runa: “¡Alläpa cushishgach cayanga Dios Yayapa Mandacuy Reynonchö banquëtita micugcuna!” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Señor Jesucristonam nirgan: “Juc runam, atscag runacunata wajinman convidargan banquëtita rurar alli micuycunata micupacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Meriendayänan öranam, juc servigninta mandargan convidangan runacunata ninanpag: ‘Llapanpis listunam jina örash aywacayällämunqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Pero tsay llapan convidangan runacunam disculpata mañacurnin gallaycuyargan. Tsaymi juccag nirgan: ‘Disculpaycayämay manam shamuyta puedillätsu. Chacratam tsayrag rantïcurgö, tsaymanmi canan ricag aywä.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Juccag convidashganam nirgan: ‘Disculpaycayämay pitsga yuntatam tsayrag rantïcurgö. Canan ricagnin aywarmi shamuyta puedillämütsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Juccagnam nirgan: ‘Tsayragmi casaracurgö, tsaynöpam shamuyta puedillätsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Servignin cutisquirnam, patronninta willargan convidädoncuna tsaynö niyanganta. Patronninnam alläpa piñacur servigninta nirgan: ‘Jina öra cällicunapawan pläzacunapa aywar, wactsacunatawan gapracunata y ratacunatawan inväliducunata sas cayman pushamuy.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Servigninnam patronnin mandangannö rurasquir nirgan: ‘Mandamangayquinöllam rurargö, pero wajiga jäcunragmi.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Tsaynam servigninta patronnin yapay nirgan: ‘Nänicunapawan washacagcunapa aywar, maypitapis runacunata pushamuy wajï junta cayänanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rasuncagtam niyag: Puntata invitashgacunaga mananam wajïchö ni ichicllatapis micuyta yawayanganatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tsaypitanam Señor Jesucristo nänipa aywaycaptin, maytsicag runacuna gatirnin aywayaptin tumaycur nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Pipis gatirämayta munarga, taytanta, mamanta, warminta, tsurincunata, waugencunata, panincunata y quiquinpa cawayninta cuyanganpitapis mas cuyamätsun. Si tsaynö rasumpa mana cuyamarga manam discïpulütsu canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tsaymi pipis nogaraycu imayca cruzta apagnö wañunanpag sufrirpis, gatirämätsun. Mana tsaynö sufrigcagga manam discïpulütsu canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Si gamcuna juc jatun torreta shäratsiyta munarga, ¿manacu jamaycur manarag gallatsirnin ayca gellayniquicuna canganta calculayanquiman, ‘Mä pantangacush ushatsinäpag?’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tsaynö puntata mana yarpar calcularga, cimientuta quichasquirllam ushatsiyta puediyanquitsu. Tsaynö mana ushatsiyaptiquim, runacuna musyapar asipäyäshunqui: ");
INSERT INTO qxnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘¡Cay runaga torreta gallaycurlla, ushatsiyta puedintsu!’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tsaynölla masqui juc rey jucpa contran guerrata rurananpag aywatsun. Manarag guerraman aywarmi, jamaycurnin yarpachacunga: ‘Soldädücunaga chunca warangallam, pero chiquignïpaga ishcay chunca warangam. ¿Tsay wallcaglla soldädücunawan conträta venceshagtsurag?’ ");
INSERT INTO qxnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tsaynö mana vencegnö carga contran rey carullachörag caycaptinmi, willacugcunata mandanga manana peleayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tsaynöllam maygayquipis imaycayquicunata mana välegpagnö churar, munayniquicunata mana dëjarga, manam discïpulütsu cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Cachiga micuyta mishquitsinanpagmi. Pero tsay cachi gamyasquirga, ¿imanörag micuyta mishquitsinanpag alli canman? ");
INSERT INTO qxnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tsay cachiga mananam ni imapag servinnatsu, allpapagwan wanupagpis. Tsaynö mana servigtaga jitasquintsicllanam. Rinriyogcagcunaga shumag rasumpa entendicuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tsaypitanam Señor Jesucristo caycanganman, contribucion cobragcunawan jutsasapacuna, wiyayta munarnin goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tsayta ricaycurnam, fariseocunawan ley yachatsicugcuna musyapäyargan: “¡Cay runaga jutsasapacunata chasquirmi paycunawan micunpis!” ");
INSERT INTO qxnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsaypitanam cay ejempluwan iwalatsiycuypa Señor Jesucristo willacurgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Masqui, maygayquipapis juc pachac üshayquicuna cayäpushuy. Tsaypita juccag ogracasquiptinga, ¿manacu isgon chunca isgoncagta (99) mitsiyangayquichö dëjaycur, tsay ogracashgacagta ashignin tariyangayquiyag aywayanquiman? ");
INSERT INTO qxnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tarisquirnam alläpa cushishga matancarcur apayämunquiman. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wajiquiman chäratsirnam, amïgoyquicunatawan vecïnuyquicunata gayasquir niyanqui: ‘Llapantsic cushicushun, ogracashga üshätam tarimurgö.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tsaymi niyag: Tsay cuentanöllam juc runalla jutsancunata dëjasquir arepenticurnin, Dios Yayaman cutiptinga, cieluchöpis masmi cushicuyanga tsay isgon chunca isgon (99) alli rurag runacunapag cushicuyanganpitapis. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Masqui, juc warmipa chunca väleg gellaynincuna catsun y juccagta ograsquitsun. ¿Manacu actsita tsarircatsir, wajintapis shumaglla pitsapacurnin ashinman taringanyag? ");
INSERT INTO qxnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tarisquirnam, yanasancunatawan vecïnuncunata gayasquir ninga: ‘Nogawan shamur cushicuyay: Cay ograngä gellaynïtam tarirgö.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tsay cuentanöllam juc runa arepenticur jutsanta dëjasquiptinga, cieluchö Dios Yayapa angelnincunapis alläpa cushicuyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tsaypitanam caynöpis nirgan: “Juc runapam ishcay tsurincuna cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gepacagmi taytanta nirgan: ‘Taytay, llapan töcamangancag erenciäta entregaycamay.’ Tsaynam taytan ishcan tsurincunata chacrantawan erenciancuna raquipurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Tsaynö ishcanta raquipunganpita ishcay quimsa junagllatanam, gepacag tsurin llapan erencianta gorisquir, caru marcapa aywacurgan. Tsay marcaman chaycurnam, imayca mana allicunallachö llapan apanganta pasaypa ushasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tsaynö ushacäpucusquiptinnam, tsay marcacunachö alläpa mallagäcuy wata cargan. Tsaynam tsay jövenga mallagaywan alläpa sufrirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aruyta ashirmi chargan, tsay marcachö täcug runaman. Tsay runanam chasquirgan cuchincunata mitsinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tsaychö cuchicunata mitsir alläpa mallagarnin, cuchicunata garayangan äbaspa garanllatapis micuyta munapaptinpis, manam ni pïllapis pachan garaycurgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Tsaynö alläpa mallagarnin yarpachacur juiciunman churacasquirmi nirgan: ‘Taytäpa wajinchö atscag servignincunaga canan örach pachancuna junta micur caycäyan. ¡Noga caychö mallagaywan wañuycaptïna! ");
INSERT INTO qxnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cananmi sïga, taytäman cutiycur nishag: Taytay, alläpa mana alli jutsatam Diospawan gampa contrayqui rurargö. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Amana tsuriquitanöga ricämaytsu, sinöga juc servicug wätayniquitanöllana chasquiycallämay.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tsaynö yarpasquirmi arepenticurnin, tsay jöven wajinchö taytan caycanganman cuticurgan. “Pero wajipita carullachörag caycaptinmi, taytan ricasquir alläpa llaquipargan. Tsaynam cörrilla aywar abrasacurcur mutsaycur chasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Tsurinnam nirgan: ‘Taytay, alläpa jutsatam rurargö, Diospa contran y gampa contrayqui. Ama tsuriquitanöga ricämaynatsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Pero taytannam servignincunata nirgan: ‘Jina öra ¡sas! Mushog mas allicag llatapan apamur, cay tsurïta shucutsiyay. Tsaynölla shumag sortïjata shucutsir mushogcag alli llangeta llangetsiyay. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Alli weracag mallwa törruta apamur pishtayay, llapantsic cushishga fiestata rurar micupacunapag. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cay tsurïga wañushga cuentam cargon, pero cananmi sïga cutimur cawamushga cuentanö caycan. Ogracashgam cargon, pero cananga yurimurunmi.’ Tsaynö nirmi fiestata rurar gallaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tsaynö fiestachö llapan cushishga caycäyaptinmi, mayorcag tsurin chacrachö caycargan. Wajiman cutir chaycarnam, cantapacurnin tushupacuycagta wiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsaynam taytanpa juc servigninta gayasquir, wajichö ima päsanganta tapurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tsay servicug wätayninnam nirgan: ‘Waugeyquim cutimushga. Tsayta taytayqui cushicurmi, mas weracag törruta pishtatsishga, yamaylla chämunganpita.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Tsayta wiyaycurnam, mayorcag waugen alläpa rabiarnin wajiman yaycuytapis munargantsu. Tsaynam taytan yargosquir, wajiman yaycunanpag rugargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero taytantanam nirgan: ‘¡Masqui ricay, gamga musyanquim atsca watana alläpa arurnin servirniqui, imayca esclävunö llapan mandamangayquicunata cumplir rurangäta! ¡Tsaynö servirniqui caycaptïpis, manam ni juc cabritullayquitapis nogataga garaycamashcanquitsu amïgöcunawan micusquiyänäpag! ");
INSERT INTO qxnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero cay tsuriquiga llapan entregangayquitam chipyat ushashga, lluta puricug warmicunawan y tucuyläya mana allicunachö gastarnin. ¡Tsaynö imaycachö gastanin ushasquir cutiscamuptincu, gamga mas allicag wera törrutarag pishtatsirgoyqui!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Taytannam contestargan: ‘Ïju, gamga nogawan pagtämi imaypis caychö caycanqui. Tsaymi llapan imayca capamanganpis gampag. ");
INSERT INTO qxnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero cay waugeyqui cutimungantaga alläpa cushicurmi fiestata ruranantsic; wañushga cuentam cargon y canan cutimurga cawamushganömi caycan. Ogracashgam cargon y cananga ashwanmi tarirgontsic.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Señor Jesucristom discïpuluncunata caytapis cuentargan: “Juc rïcu runapam mayoralnin cargan. Tsay mayoralpagmi patronninta willayargan lluta imaycantapis ushanganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tsaynam mayoralninta gayasquir: ‘Gampagmi runacuna willayämashga imaycätapis mana allicunata rurangayquita. Cananpitaga mananam mayoralnïnatsu canqui. Llapan cuentata entregamänayquipag prevenicuy.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mayoralnam shongollanchö ‘Cananga ¡imatarag rurashag! Patronnïmi trabäjüpita gargaman. Manam callpä cantsu chacrachö arunäpag y limushnata mañacuytaga pengacümi. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ajä! ¡Patronnï gargamaptin runacuna wajincunaman alli chasquiyämänanpagmi caynö rurashag!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tsaypitanam patronninta dëbegnincunata juc jucllapa gayasquir puntacagta nirgan: ‘Patronnïta ¿aycatatan dëbenqui?’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Tsay runanam ‘Pusag pachac (800) galon aceitinmi.’ “Mayoralnam nirgan: ‘Cayman jamaycur, cay recïbochö churay chuscu pachac (400) galonllata päganayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Juccag dëbecugtanam tapurgan: ‘Gamga, ¿aycatatan dëbenqui?’ “Tsay runanam ‘Ishcay pachac ganchis chunca (270) säcu trïgunmi’ nirgan. “Mayoralnam nirgan: ‘Cay recïbochö ishcay pachac säcullapag (200) churay.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Tsaynö sabïdu suwa mayoral cangantam patronnin aläbargan. Pero Dios Yayaman criyicug runacunapitaga, mana criyicug runacunam alläpa sabïdu cayan quiquincuna pura imayca negociucunata rurayta musyarnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nogam niyag: Cay patsa cawayangayquichö mana alli ruratsicug gellayniquicunawan imatapis allicunallata rurar, amïgoyquicuna mas cananpag ashiyay. Tsaynö allicunallata rurarnin gellayniquicuna ushayangayquipitam, Dios Yayawan y yanapayangayqui runacunapitapis wac vïda cieluchö mas allish chasquishga cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Si pipis ichicllachö onrädo carga, tsaynölla onrädollam mas atscachöpis canga. Pero pipis ichicllachö suwacurga, tsaynöllam mas atscachöpis suwacunga. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si cay patsachö llapan mana alli ruratsicug riquësacunachö mana onrädo caycäyaptiquiga ¿imanörag Dios Yayapis rasumpacag imayca riquësatanö atscag runacuna salvacäyänanpag confiacushunquiman? ");
INSERT INTO qxnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jucpa imaycanchöpis mana onrädo caycäyaptiquiga, ¿pirag imaycantapis confiacuyäshunquiman? ");
INSERT INTO qxnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Pipis manam ishcay patronta servinmantsu. Juccagta chiquirmi, juccagta mas cuyanga. Juccagta cäsurmi, juccagtaga cäsungatsu. Tsaynöllam gellayta alläpa cuyarga, Dios Yayatapis servirnin cäsungatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tsaynö Señor Jesucristo parlanganta wiyarmi, gellayta alläpa cuyarnin ayrajag fariseocuna burlacur asipäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Señor Jesucristonam nirgan: “Gamcunaga runacunapa puntallanchömi allitucuyanqui, pero Dios Yayam shongoyquicunata regen. Runacuna cay patsachö imatapis alläpa välegpag churayangantam, Dios Yayaga melanan. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Dios Yayapa unay profëtancuna gellgayanganwan Moiséspa leyninga asta Juan Bautista willacur gallanganyagmi cargan. Tsaymi cananga nogana Dios Yayapa Alli Willacuynintawan shumag Mandacuy Reynonpag willayag. Dios Yayapa Mandacuy Reynonmanga atscag runacunam imaycanöpis yaycuyta munayan. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mas fäcilmi cieluwan cay patsapis jancat ushacanman, Diospa Palabran leycuna ni juc letrallapis mana faltar llapan cumplinganpitapis. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Si juc runa warminpita raquicasquir jucwan casararga, adulterio niyangan jutsatam ruran. Tsaynöllam tsay gojanpita raquicashga warmiwan pipis casararga, paypis adulterio niyangan llutan mana alli jutsata ruraycan. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Unaymi juc alläpa rïcu runa, llatapanpis alläpa chaniyogcagllata shucushga waran waran fiestata rurarnin, wajinchöpis banquëtillachö cargan imayca munanganpa jananchö car. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tsaynöllam juc wactsa Lazaro niyangan runapis, entëru cuerpun jancat gerishga tsay rïcupa puncunman churayanganchö imaypis jamaräcug. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Paymi alläpa mallagarnin, tsay rïcu runapa mësanpita micuy shicwagllatapis micuyta munapag. Tsaynö jancat gerishga jamacuptinmi, asta allgocunapis gerinta lagwayag. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tsaynö caycarnam tsay wactsa Lazaro wañusquiptin, almanta angelcuna cieluman apayargan, unay Abrahampa puntan paraisoman. Tsaynöllam tsay rïcu runatapis wañusquiptin pampayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Tsaynam llapan mana alli ruragcuna aywayangan infiernuchö alläpa sufrirnin caycar witsaypa ricasquirgan, unay Abrahamwan Lazaro lädunchö caycagta. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsaynam jinchi gayaraypa gayacurgan: ‘Tayta Abraham, llaquipaycallämayri. Cayman Lazarota cachaycallämuy, dëdunta yacuman tullpurcur gallulläta gajarcatsimunanpag, cay lunyaycag ninachömi alläpa sufriycällä.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Pero Abrahamnam contestargan: ‘Ïju, yarpay cawayniquichöga alläpa allishmi aywashurgayqui, llapan imaycayog cushicuyllachö cawanayquipag. Pero cay Lazaroga cawayninchö wactsa cayninwanmi alläpa sufrirgan. Tsaynö wactsa cayninwan cawayninchö sufringanpitan cananga caychö alläpa cushishga caycan. Cawayniquichö alläpa imaycayog cushishga cangayquipitam cananga gamtana caychö sufriy töcashunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Caycuna llapanpitapis nogacunapita gam caycangayquiman alläpa jatun feo sanjam. Tsaymi caypita tsimpayämuyta puediyätsu ni gampis cayman tsimpamuyta puedinquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tsaynam capugyog rïcu nirgan: ‘Tayta Abraham, tsaynö captinga, alläpam rugag Lazarota taytäpa wajinman cachaycunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tsaychö pitsgan waugëcunata willaycamutsun cay sufriycangäman paycunapis mana shayämunanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahamnam contestargan: ‘Moiséswan Dios Yayapa unay profëtancuna gellgayangancunata paycuna musyayanmi, tsayta wiyarnin cäsucuyätsun.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Capugyog rïcunam contestargan: ‘Tayta Abraham, manam cäsucuyangatsu. Pero wañushgapita cawascamur juc runa paycunaman cutiycur willaptinga, maypis jutsancunata dëjasquir arepenticuyanman.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abrahamnam nirgan: ‘Moisés gellgangancunatawan Diospa unay profëtancuna gellgayangancunata wiyarnin mana cäsucurga, wañunganpita cawasquir runa willacuptinpis, manam cäsucuyangatsu.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tsaypitanam Señor Jesucristo discïpuluncunata nirgan: “Runamajinta jutsaman ishquitsinanpag invitagcunaga imaypis cayangam. Pero ¡allau, tsaynö pitapis jutsaman ishquitsig runa! ");
INSERT INTO qxnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas allim canman tsay runapa cuncanman jatun molinu rumita watarcur, lamarman jitarpuyaptin, gollmi shongo imayca wamranö tsayrag criyicuycag runacunata jutsaman manarag shicwatsinganyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Tsaymi cuidädu cayay! Si runamajiqui jutsata ruraptinga piñaparnin plëtunqui. Tsaynöllam mana alli ruraynincunata dëjasquir arepenticuptinga perdonaycunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Si juc junagchö ganchis cuti contrayqui mana allita rurasquir, ganchis cuti ‘Perdonaycällämay mananam yapaywanga ruralläshagtsu’ nir, shamuptinga perdonaycunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tsaypitanam apostolnincuna Señor Jesucristota mañacuyargan: “¡Yanapaycayällämay mas firmi criyicayämunäpag!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Señor Jesucristonam contestargan: “Si gamcunapacush criyicuyniquicuna canman cay ichic mostäzapa murunnöllapis, tsayga cay sicomoro niyangan jachata: ‘Caypita tiracasquir aywarnin lamarman jawicay’ niyaptiquipis, tsay jacha rasumpam cäsuyäshunquiman. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Si maygayquipapis servigniquicuna chacrayquicunachö yapyacur o wätayquicunata mitsisquir wajiman chaycamuptin, ¿Acäsu ‘Päsacamuy jamaycur micusquinayquipag’ niyanquicu? ");
INSERT INTO qxnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mas bienmi gamcunaga niyanqui: ‘Meriendä prevenimur garamay, micur upyar ushangäyag servimay. Tsaypitanam gamga micunqui’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tsaynöllam llapan mandangayquita rurar ushasquiptinpis, tsay servigniquitaga ni agradëcicunquillapistsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tsaynöllam gamcunapis Dios Yaya mandayäshungayquicunata rurar, cumplisquir niyanquiman: ‘Nogantsicga mana musyag servicugcunanö carmi, apënas mandamangantsicllata cumplintsic.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Señor Jesucristo Jerusalénman aywaycarnam, Galileapawan Samaria provinciacunapa mujunnin nänipa päsargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tsaypitanam juc marcaman chäriptin, wicuwan geshyagyasha chunca runacuna Señor Jesucristota tincug aywayargan. Pero manarag Payman charmi, carullachö ichisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Paycunanam gayaraypa jinchi niyargan: “¡Maestru Jesús, llaquipaycäyällämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Paycunata ricaycurnam Señor Jesucristo nirgan: “Sacerdöticunaman aywayay cuticashga cayangayquita ricäyäshunayquipag.” Tsaynö aywaycarnam, jancat limpiu tsay melanaypag geshyaynincunapita cuticasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tsaynö jancat limpiu cuticashgana canganta tantiyasquirmi, juccag runaga Señor Jesucristoman jinchi gayaycachar, Dios Yayata alabarnin cutirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Señor Jesucristopa puntanman chaycurnam gagllanpis patsaman changanyag gongorpacuycur agradëcicurgan. Tsay cutimug runaga Samaria marcapitam cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Señor Jesucristonam nirgan: “¿Manacu chuncag runacuna geshyaynincunapita jancat limpiu cuticäyargon? ¿Maytan waquincag isgon cuticashgacunaga? ");
INSERT INTO qxnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Cay juclä marcapita mana regeshga runallam, Dios Yayata agradëcicurnin alabar cutimushga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tsay runatanam nirgan: “Sharcur, aywacuy. Rasumpa firmi criyicuyniquiwanmi cuticargoyqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tsaypitanam fariseocuna tapuyargan imay Dios Yayapa Mandacuy Reynon chämunanpag canganta. Señor Jesucristonam contestargan: “Dios Yayapa Mandacuy Reynonga manam ricaraycäyaptiquitsu chämunga. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manam niyangatsu: ‘Caychönam’ o ‘Washachönam’ caycan nir. Dios Yayapa Mandacuy Reynonga shongoyquicunachö pagtayquicunam caycan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsaypitanam discïpuluncunata nirgan: “Chämungam junagcuna, Diospita Shamushga Runata juc junagcunallapis ricayta munayänayquipag, pero manam ricäyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Waquinnam niyäshunqui: ‘Washachömi o caychömi caycan’ nir. Pero ama ricagnin cörrilla aywayanquitsu ni paycunata gatiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imayca illago cieluchö juc lädupita wac läduman chilapyar atsicyagnömi canga, Diospita Shamushga Runaga cay patsaman cutimungan öraga. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero tsaynö cutimunanpag canganpita mas puntataga cay tiempu runacunam chiquirnin alläpa sufritsiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Imanömi unay Noé niyangan runapa tiempunchö päsargan, tsaynöllam Diospita Shamushga Runa cutimunan öra päsanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Büquiman Noé yaycungan junagyagmi, runacuna micupacur, upyapacur, casaracur caycäyargan. Tsaymannam apäcuypa tamya chaycur, llapan runacunata wañutsir jancat ushacascatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Tsaynöllam unay Lot runa niyanganpa tiempunchöpis päsargan. Runacunam micupacur, upyapacur, imatapis rantipacurnin ranticur, murupacur y wajicunata rurar caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero Sodoma marcapita Lot yargosquiptinnam, tsay junag cielupita asufrintin nina runtu tamyamur, llapan runacunata wañutsir jancat ushacascatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tsaynöllam canga Diospita Shamushga Runa cay patsaman cutimungan junagpis. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tsay junagchö pipis wagtachö caycarga, ama waji rurinman yaycutsuntsu imantapis jurgog. Ni pipis chacranchö caycar, ama wajinman imantapis jipig cutitsuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Yarpäyay Lotpa warminta ima päsanganta! ");
INSERT INTO qxnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cay patsachö cawayllanta cuidar tsapayta munagcagga, jancatmi ogranga. Pero cay patsachö cawayninta mana cuidar tsaypayta munagcagga, janag patsa cieluchömi wiñaypa cawanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nogam niyag: Tsay pagasmi juc puñunallachö ishcag puñuycagpita, juccagllata apanga y juccagtaga dëjangam. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishcag warmicuna agacuycäyanganpitam juccagta apar juccagtaga dëjanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishcag runacuna chacrachö aruycäyanganpitam juccagllata apar juccagtaga dëjanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsaynam tapuyargan: “Señor ¿maychötan tsaynöga päsanga?” Señor Jesucristonam contestargan: “Maychöpis wañushga cuerpucuna jitaragcunamanmi wisculcuna goricäyanga. Tsaynöllam nogaman criyicugcuna goricäyämunga maychöpis caycangäman.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tsaypitanam Señor Jesucristo yachatsicurgan, imaycawan iwalatsiycuypa paycuna imaypis, mana gelanar Dios Yayaman mañacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tsaynam nirgan: “Juc marcachömi Dios Yayatawan runamajincunatapis mana cäsug ni respetag juc juez cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tsay marcachönam juc viuda warmi juiciuchö cargan. Tsay viuda warmim waran waran tsay juezman aywargan: ‘Demandamagnïmi alläpa allgotsäcaman justiciata ruraycallämay’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Tsaynö yapay yapay aywaptinpis, unaynam tsay viudata juezga cäsurgantsu. Tsaypitanam yarpargan: ‘Nogaga manam Diostawan runacunatapis caychöga respetar mantsätsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero cay viudataga justiciata rurar atendiycushag, ¡manana yapay yapay shamurnin rabiatsimar umäta nanpag!’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tsaypitanam Señor Jesucristo yapay nirgan: “¿Entendiargoyquicu caynö tsay mana alli juez ninganta? ");
INSERT INTO qxnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tsaynö caycaptinga, ¿Manatsurag Dios Yaya cäsunga llapan acrangancag runacunata, pagasta junagta mañacuyaptin? ¿Dios Yayaga manam shuyarätsingatsurag mañacuyanganta atendinanpag? ");
INSERT INTO qxnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tsaymi niyag: Dios Yayaga mana juc shuyarätsicurmi, justiciata ruranga. Pero Dios Yayapita Shamushga Runa cay patsaman cutimurga, ¿Cay patsachö runacunapa criyicuynincunata taringaragtsurag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tsaymi quiquincunallachö orgullöso allitucur, runamajincunata despreciar chiquigcunapag Señor Jesucristo cay iwalatsicuywan yachatsicur nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcag runacunam templuman Dios Yayata mañacug aywayargan: Juc fariseowan Romapag contribucion cobrag runa. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tsay fariseonam ichiycurnin quiquillanpag mañacurgan: ‘Dios Yaya, alläpam agradëcicug nogaga mana waquincag runacunanö cangäta. Waquincagga suwa jutsasapam, jucnin jucninwan llutan mana alli jutsata rurar täcuyan. Nogaga manam ni tagay contribucion cobragnötsu cä. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nogaga cäda semänachö ishcay cuti ayunarmi micütsu. Llapan gänangäpitam juc chuncaman raquisquir, juccag partita garaycug.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Pero Romapag contribucion cobrag runanam carullachö ichiycur, umantapis cieluman manana pallarir alläpa llaquicurnin pëchuntapis cutarrag nirgan: ‘Dios Yayallä, llaquipaycallämay. Nogalläga alläpa jutsasapa runam callä’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Tsaymi niyag: Contribucion cobrag runam jutsanpita perdonashga wajinman cuticurgan. Pero tsay fariseotaga Dios Yaya manam jutsanpita perdonargantsu. Tsaynö pipis allitucugga, pengacushgam canga. Pero umilde gollmi shongoyogcagga, mas väleg runam canga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsaypitanam Señor Jesucristomannam asta pishi wamracunatapis apayargan, yatarnin bendisananpag. Pero tsayta ricaycurnam discïpuluncuna piñacur, Señor Jesucristoman witiyänanta mana munar amatsayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsaynam wamracunata gayasquir, Señor Jesucristo nirgan: “¡Nogaman wamracuna shayämunanta ama michäyaytsu! Cay wamracunanö umildecagcunapagmi Dios Yayapa Mandacuy Reynonga. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rasuntam niyag: Si cay umilde gollmi shongo wamracunanö Dios Yayapa Mandacuy Reynonta mana chasquirga, manam Dios Yayapa Mandacuy Reynonman yaycuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tsaypitanam tsaychö mandacug runa Señor Jesucristota tapurgan: “Alläpa alli Maestru, wac vïdachö wiñaypa cawanäpag, ¿imatatan rurashag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Señor Jesucristonam contestargan: “¿Imanirtan ‘Alli Maestru’ nimanqui? Jucllayllam alliga, tsayga quiquin Dios Yayallam. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Musyanquinam cay mandamientuncunata: ‘Ama jucnin jucninwan mana alli jutsata rurar täcunquitsu. Runamajiquita ama wañutsinquitsu. Ama suwacunquitsu. Ama llullacunquitsu. Taytayquitawan mamayquita respetar cäsunqui.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tsay runanam nirgan: “Wamra caynïpitam tsaycunataga llapanta cumplishcä.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tsaynö niptinnam, Señor Jesucristo nirgan: “Pero juc cösaragmi faltäshunqui: Llapan imaycayquitapis ranticusquir, wactsacunata garaycuy. Tsaynö rurangayquipitam cieluchöpis mana ushacag fortünayqui canga. Tsaynö rurasquirnin, shamur gatimay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tsayta wiyaycurnam yarpachacur llaquicurgan, alläpa capugyog rïcu car. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tsay runa llaquishga caycagta ricaycurmi, Señor Jesucristo nirgan: “¡Alläpa ajam canga, capugyog rïcucuna Dios Yayapa Mandacuy Reynonman yaycuyänanpag! ");
INSERT INTO qxnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas fäcilmi juc jatun ‘camëllo’ niyangan wäta aujapa uchcunpa päsanman, juc capugyog rïcu runa Dios Yayapa Mandacuy Reynonman yaycunganpitaga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tsayta wiyagnincagcunanam, Señor Jesucristo tapuyargan: “Tsaynö captinga, ¿pitan salvacuyta puedinga?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Señor Jesucristonam contestargan: “Runacunapag imayca aja carpis, Dios Yayapagga manam ajatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsaynam Pedro nirgan: “Señor, nogacunaga llapan imaycäcunata dëjasquirmi, gamta gatiyämushcag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Señor Jesucristonam contestargan: “Rasuntam niyag: Pipis wajinta, warminta, waugencunata, taytanta, mamanta, tsurincunata, Dios Yayapa Mandacuy Reynonraycu dëjanganpitam, ");
INSERT INTO qxnNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cay patsachöpis mas imaycan Dios Yaya garaycunga. Tsaynöllam wac vïdachöpis Dios Yayawan imayagpis wiñaypa cawanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tsaypitanam chunca ishcay discïpuluncunallata juc läduman gayasquir, Señor Jesucristo nirgan: “Cananmi Jerusalénman aywashun. Tsaychömi llapan cumplinga, Dios Yayapa unay profëtancuna Diospita Shamushga Runapag gellgayangannö. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Juclä mana regeshga runacunapa maquinmanmi, marca majincuna entregayanga. Tsaymi insultarnin burlacur togapurnin ushayanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tsaynö alläpa astarnin magarmi wañutsiyanga. Pero wañutsiyanganpita quimsa junagllatam cawamun.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tsaynö niptinpis, discïpuluncunaga manam ni imata entendiyargantsu ni musyayargantsu imapag parlangantapis. Paycunapagga mana juc tantiyaypagmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Señor Jesucristo Jerico marcaman chaycaptinnam, näni cuchunchö juc gapra limushnata mañacur jamaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tsaypa maytsicag runacuna päsagta tantiyasquirmi, tsay gapra “Imatan päsaycällan” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Runacuna “Nazaretpita Jesúsmi caypa päsaycan” niyaptinnam, ");
INSERT INTO qxnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","jinchicuycur garaypa nirgan: “¡Davidpa ayllun Jesús, llaquipaycallämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tsaynö niptinnam, puntata aywagcuna, “¡Upalla cay gapra!” nir, piñapäyargan. Pero tsaynö piñapäyaptinpis mana cäsucurmi, mas jinchi gayarayparag nirgan: “¡Davidpa ayllun Jesús, llaquipaycallämayri!” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tsayta wiyasquirnam Señor Jesucristo ichisquir, apayämunanpag mandargan. Puntanman chaycatsiyaptinnam, Señor Jesucristo tapurgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Gampag imata ruranätatan munanqui?” Gapranam contestargan: “Señor, ñawillä ricänantam munallä.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Señor Jesucristonam nirgan: “Ricayna. Rasumpa firmi criyicuyniquiwanmi cuticargoyqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tsaynö jina öra cuticasquirnam, Señor Jesucristopa gepanta gatir aywargan, Dios Yayata alabarnin. Tsayta llapan ricagnin runacunapis Dios Yayatam alabayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tsaypitanam Señor Jesucristo Jerico marcaman chaycur, tsay marca pullanpa päsaycayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tsay marcachömi Romapag impuestu cobragcunapa mandagnin juc rïcu Zaqueo shutiyog runa täcurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tsay runam Señor Jesucristota alläpa regeyta munargan. Pero ichiclla carmi, maytsicag runacuna tsapäyaptin ricayta puedirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsaynö ricayta mana puedirmi, cörrilla puntasquir Señor Jesucristo päsanancag juc ïgosnö sicomoro niyanga jachaman lätargan ricänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tsay jachacagpa Señor Jesucristo päsaycar ricarcurnam nirgan: “Zaqueo, jina öra yarpamuy, cananmi wajiquichö quëdanä.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueonam sas jachapita yarpascamur, alläpa cushishga Señor Jesucristota wajiman pushargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tsayta ricaycurnam, runacuna Señor Jesucristota musyapäyargan: “¡Jutsasapa runapa wajinman posadacug aywan!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pero Zaqueonam ichircur, Señor Jesucristota nirgan: “¡Señor, ricay! Llapan capamanganpa pullancagtam wactsacunata caychö canan garashag. Si pitapis suwapushga carga, chuscu cuti mastam entregar cutiycatsishag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Señor Jesucristonam nirgan: “Cananmi cay wajiman salvaciun chämushga nogaman criyicur, paypis unay awiluntsic Abrahampa ayllun shamugpita captin. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tsaymi Diospita Shamushga Runaga, cay patsaman shamushga ogracashganö jutsasapacunata ashirnin salvananpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Señor Jesucristo tsaynö parlanganta wiyarmi, runacuna shongoncunachö yarpäyargan: “Cananchi Dios Yayapa Mandacuy Reynon nogantsicpag gallanga.” Jerusalénman yaycuycarnam, tsayta musyasquir Señor Jesucristo iwalatsicuypa yachatsicur, ");
INSERT INTO qxnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nirgan: “Juc runam alläpa importanti runapa tsurin cargan. Tsay runam caru marcata aywacurgan, rey churasquiyaptinrag cutimunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tsaynö carupa aywacunanpagnam chunca servignincunata gayascatsir, atsca gellaynincunata paytargan: ‘Cay gellaynïwan negociuta ruraycäyay cutimungäyag’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pero tsay runata marcamajincuna alläpa chiquirmi, gepanta willacugcunata mandayargan niyänanpag: ‘Cay runa mandayämagnï rey cananta manam munayätsu’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pero tsaynö caycaptinpis, paytaga mandacug rey cananpagmi churayashgana cargan. Tsaypita marcanman cutiycurnam, atsca gellaynin paytangan servignincunata gayatsirgan, cada ünu aycata gänayanganta musyananpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Tsaynam puntata chagcag nirgan: ‘Señor, gellayniquiwan chunca cuti mastam gänallashcä’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Tsaynam rey contestargan: ‘Allishmi. Gamga alli servignïmi canqui. Wallcallachöpis onrädo cangayquipitam, canan churag juc chunca marcachö runacunapa mandagnin canayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tsaypitanam juccag servignin chärir nirgan: ‘Señor, gellayniquiga pitsga cuti mastam gänashga.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Tsaycagtapis rey contestargan: ‘Gamtam churag pitsga marcachö runacunata mandacunayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Pero juccagnam caynö nir yurisquirgan: ‘Señor, caychömi caycan gellayniqui. Juc päñuwan alli pituycurmi churarätsishcä, ");
INSERT INTO qxnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","alläpa yaga mana llaquipäcug captiqui mantsacurnin. Gamga mana churangayquipitawan mana murungayquipitam imaycatapis gorinqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Tsaypitanam rey nirgan: ‘¡Gamga mana ima väleg servicugmi canqui! Quiquiquipa palabrayquillam juzgar condenashunqui. Ningayquinömi noga yaga mana llaquipäcug cä, mana churangäpitawan mana murungäpitam imatapis gorï. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tsaypunga ¿Imanirtan mana bancuman gellaynïta apar churaycurgayquitsu, wajïman cutimurnin wachaynintawan chasquinäpag?’ ");
INSERT INTO qxnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Tsaynö nisquirnam, tsaychö caycagcunata nirgan: ‘Tsay gellayta gechusquir, tsay chunca cuti mas miratsigcagta entregaycuyay’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Paycunanam niyargan: ‘Señor. ¡Pero paypaga chunca masnam gellaynin can!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Reynam contestargan: ‘Atsca capugyogcagmi masta chasquinga. Pero mana capugyogcagtaga, ichiclla capungantapis jancatmi gechuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero tsay marcamajïcuna chiquimar rey canäta mana munagcunataga, canan cayman apaycamur puntächö wañutsiyay.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tsaynö yachatsicusquirnam, Señor Jesucristo Jerusalénman aywar sïgirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagewan Betania marcacunaman chaycarnam, Olïvos niyangan jircaman chäyargan. Tsaypitanam ishcag discïpuluncunata mandargan: ");
INSERT INTO qxnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Tagay tsimpa marcaman aywarnin yaycurmi, manarag ni pï montashga mallwa ashnu wataraycagta tariyanqui. Tsay ashnuta pascasquir apayämunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si pipis ‘¿Imapagtan ashnuta pascayanqui?’ niyäshuptiquiga, ‘Señor Jesúsmi wanan’ niyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tsaypita discïpuluncuna aywarnam, Señor Jesucristo ningantanölla llapanta tarisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ashnuta pascaycäyaptinnam, ämuncuna tapuyaran: “¿Imapagtan pascayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Paycunanam contestayargan: “Señor Jesúsmi wanan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Punchuncunawan ashnuta carunarcur aparmi, Señor Jesucristota montatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Señor Jesucristo tsaynö aywangallanmanmi, punchuncunatawan jacuncunata llushtisquir, puntanman päsananpag mashtayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olïvos niyangan jircapita urämur chaycarnam, llapan gatignincuna alläpa cushishga gayaycachar Dios Yayata alabayargan, Señor Jesucristopa llapan milagruncunata ricashga car. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tsaymi niyargan: “¡Alläpa cushicuypag catsun, Dios Yayapa shutinchö poderöso Mandacug Reynintsic shamug! ¡Cieluchöwan maytsaychöpis alli päsacuywan alläpa shumag cushicuy catsun!” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tsaynam maytsicag runacunapa rurinchö aywag fariseocuna niyargan: “¡Maestru, gatishugniquicunata piñapay upälla cayänanpag!” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Señor Jesucristonam contestargan: “Niyagmi, si paycuna upällayaptinga, rumicunapis gayaycachäyangam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalénman yaycuycarnam, tsay marcata ricasquir llaquirnin wagar, ");
INSERT INTO qxnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nirgan: “¡Jerusalénchö täcugcuna, imanömi munä gamcuna canan junagllapis Dios Yayawan alli päsacuychö cayänayquipag canganta musyayänayquita! Pero tsay alli päsacuyta mana ricarmi imayca pacaragnö captin tantiyayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mana alli tiempucuna gamman chämuptinmi, chiquishugniquicuna shamuycur, altu pergayquicuna wactanman allpata parijasquir entërupa tumat cunchawar, llapan lädupa atacagniqui yaycapuyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tsaynö atacarmi llapan wamrayquicunatawan patsachö rumicunaman sagmar pasaypa jancat ushacätsiyäshunqui. Tsaynöllam pergayquicuna rurinchö täcugcunatapis jancat wañutsir ushacätsiyaptin manam ni juc rumillapis pergaranganchö quëdangatsu ni juccag rumipa jananllachöpis. Tsaynö jancat ushacätsiyäshunqui, Dios Yaya salvayäshunayquipag tiempu chaycämuptin despreciarnin mana chasquiyangayquipitam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tsaypitanam Señor Jesucristo Jerusalénchö templuman yaycusquir, tsaychö ranticuycag runacunata gargor, ");
INSERT INTO qxnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nirgan: “Diospa Palabranchömi gellgashga cayan: ‘Wajïga Dios Yayaman mañacunallapagmi.’ ¡Pero gamcunaga ‘suwacunapa machayninmanmi’ ticratsiyashcanqui!” ");
INSERT INTO qxnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Señor Jesucristonam waran waran templuchö yachatsicurgan. Pero sacerdöticunapa mandagnincunawan ley yachatsicugcuna y tsay marcachö mas mandacug autoridäcunam imaycanöllapis Señor Jesucristota wañutsiyta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero manam ni imanöpa wañutsiyänanpag tariyargantsu, Señor Jesucristo yachatsicunganta llapan runacuna alläpa cushishga wiyayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tsaypitanam juc junag templuchö Señor Jesucristo yachatsicurnin, shumag Alli Willacuyta willacuycargan. Tsaymannam sacerdöticunapa mandagnincunawan ley yachatsicugcuna y mas mandacug auquincunawan chaycur, ");
INSERT INTO qxnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","niyargan: “¿Ima mandacuyniquiwantan caycunata rurargoyqui? ¿Pitan mandacuyninta entregashushcanqui caycunata ruranayquipag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Señor Jesucristonam contestargan: “Nogapis jucta tapuyäshayqui. Mä, niyämay: ");
INSERT INTO qxnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitan mandamurgan Juan Bautista runacunata bautizananpag, Dios Yayacu o runacunallacu?” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Paycunanam quiquincuna pura discutir ninacuyargan: “¿Si Dios Yayam cachamushga nishgaga, ‘Imanirtan mana criyiyargayquitsu?’ nimäshunmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero manam puedintsictsu ‘Runacunam cachamushga’ niytaga. Si tsaynö nishaga llapan runacunam sagmar wañuscatsimashwan. Paycunaga rasumpam musyayan Juan Bautista Dios Yayapa willacug profëtan canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsaynö yachatsinacusquirnam niyargan: “Manam musyayätsu ni pï cachamungantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tsaynam Señor Jesucristo contestargan: “Tsaynömi nogapis willayagtsu ni pipa mandacuyninwan caycunata rurangätapis.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsaypitanam runacunata cay iwalatsicuyta cuentarnin gallaycurgan: “Juc runam chacranchö üvata plantascatsir, tsay chacranta pullan pura cuidayäpunanpag arugnincunata entregaycur caru marcapa aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cosëcha tiempu chäriptinnam, chacran tsaragcunaman juc servigninta mandargan töcangancagta entregayänanpag. Pero chacran tsaragcunanam alläpa magasquirnin, jinallanta gargosquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsaynam chacrayog runaga juccag servigninta mandarga. Pero paytapis allgotsacurnin pengacuypag magarnin alläpa maltratasquirmi jinallanta gargosquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tsaypitanam chacrayog runaga juccag servignintana mandargan. Tsaycag servignintanäga alli magacachasquirmi yawar püruta gargosquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Tsaynam chacrayog nirgan: ‘Cananga ¿imatatan rurashag? Alläpa cuyay tsurïtam cachashag. Paytaga maypis respetayanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Pero chacrayogpa tsurinta ricasquirnam, pullan pura tsarag runacuna yachatsinacur niyargan: ‘Caymi llapan chacracunawan eredëru quëdanga, wañuscatsishun chacranwan nogantsic quëdanapag’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsaynö yarparmi chacranpita jucläman jorgosquir wañutsiyargan. “Tsaynö wañuscatsiyaptin, üva murutsig chacrayogga ¿imata rurangantatan gamcuna yarpäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aywarnin chacran tsarag runacunata wañuscatsirmi, juccunatana chacranta entregaycunga.” Tsayta wiyaycurnam niyargan: “¡Ama tsaynöga ni imaypis caycullanmantsu!” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Señor Jesucristonam ricapaycurnincuna nirgan: “¿Tsaypunga ima ninantan Diospa Palabran caynö gellgashgachöga caycan? ‘Waji ruragcuna despreciar jitariyangan mana alli rumim, cananga mas allicag maestru rumi ticrashga.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tsaymi cay rumi jananman pipis shicwarga, jancat ñutusquinga. Pero tsay rumi pipa jananmanpis jegarga, jancat polvutam rurasquinga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tsaynam sacerdöticunapa mandagnincunawan ley yachatsicugcuna, jina öra prësu achcuyta munayargan, paycunapa contran cay iwalatsicuywan Señor Jesucristo parlanganta tantiyasquir. Pero runacunapita mantsacurmi mana achcuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tsaypitanam yachayllapa musyapacugcuna mandayangan ricaraycäyargan Señor Jesucristoman alli onrädotucurnin aywaycur tapuyänanpag. Tsaynö tapupar llutanta parlascatsir acusarnin, Roma gobernadorman entregayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tsaynam yachayllapa musyapacugcuna tapuyargan: “Señor, rasumpam musyayä yachatsicungayquiwan parlangayquipis rasumpacaglla canganta y runacuna alläpa allish cayaptinpis paycunawan mana juntacangayquita. Gamga yachatsicunqui Dios Yaya munangannölla rasumpa alli cawacuyänäpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Allicu Romachö mandacug gobierno Cesarman impuestuta pägashwan o manacu?” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Señor Jesucristonam yapta tapuyanganta musyar nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mä, juc gellayta ricätsiyämay. ¿Pipa reträtunwan shutintan caychö gellgashga caycan?” Tsaynam contestayargan: “Emperador Cesarpam.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Señor Jesucristonam nirgan: “Cesarpacagtaga, Cesarta entregaycuyay. Pero Diospacagtaga, Diosta entregaycuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Atsca runacunapa jananchö Señor Jesucristo tsaynö niycuptinnam, tsay yachayllapa musyapacugcuna ni imanö pantatsiyta puedir, mantsacashga upällalla quëdayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsaypitannam waquincag saduceocuna Señor Jesucristota ricagnin shayämurgan. Tsay saduceocuna runacuna wañusquir cawayämunanta manam criyirmi, Señor Jesucristota caynö tapuyargan: ");
INSERT INTO qxnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maestru, unay Moisésmi gellgashga leyninchö dëjapamashcantsic, si juc casädo runa tsurin manarag captin wañuptinga, viudanwan gepancag waugen casarananpag. Tsaynö casarasquir tsurin captinga, tsay wañushgacag waugenpa tsurin cuenta cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Unayshi ganchis waugecuna cayargan. Tsayshi mayorcag casarasquirnin manarag tsurin captin wañusquinag. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Tsayshi gepancag waugenwan mas gepancagpis tsay viudanllawan casarashga cayänag. Paycunapis manarag tsurincuna captinshi wañusquinag. Tsaynöllash ganchis waugentin tsay warmillawan casarasquir, manarag tsurincuna captin llapanpis wañusquiyänag. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsaypitanash warmipis wañusquinag. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tsaypunga cawamuy junagchöga ¿maygancag waugeparag warmin canga, ganchisnintinwan casarashga caycaptinga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Señor Jesucristonam contestargan: “Ollgopis warmipis cay patsallachömi casarayan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero wac vïdaman chäyänanpag acrashgacuna cawascamurga mananam warmipis ollgopis casarayanganatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tsaychöga mananam wañuyanganatsu. Llapanpis angelcunanölla carmi, Dios Yayapa wamrancuna cayanga, Pay cawatsimushga captin. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero unay Moiséspis quiquinmi musyatsimantsic wañushgacuna rasumpa cawayämunganta. Paytam shiraca casha lunyagchö yuripur, Dios Yaya nirgan: ‘Nogaga Abrahampa, Isaacpa y Jacobpa Diosninmi cä.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tsaymi Dios Yayaga manam wañushgacunapa Diosnintsu, sinöga llapan cawagcunapa Diosninmi. Tsaymi Diospagga llapanpis cawaycäyan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tsaynö niptinnam, waquincag ley yachatsicugcuna niyargan: “Maestru, ¡alläpa allitam niyämargoyqui!” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tsaypitaga mananam yapay ni imatapis tapuyninta valorayargannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tsaypitanam Señor Jesucristo runacunata tapurgan: “¿Imanirtan niyanqui Cristoga unay rey Davidpa ayllun shamugpita cangata? ");
INSERT INTO qxnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Quiquin Davidpis Salmo librunchö gellgargan: ‘Señormi Señornïta nirgan: Cay derëchucag lädüchö jamacamuy ");
INSERT INTO qxnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","llapan chiquishugniquicunata chaquiquipa gopinman churamungäyag.’ ");
INSERT INTO qxnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tsaynö David ‘Señornïmi’ nicaycaptinga, ¿Imanöpatan Davidpa miragnin ayllunpa tsurin Cristo canga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Llapan runacuna wiyaycäyaptinmi, Señor Jesucristo discïpuluncunata nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ley yachatsicugcunapita cuidacuyay, paycunaga chaquincuna puntanyag alli llatapashgam, pläzacunachöwan mercädocunachöpis runacuna shumag alläpa respetar saludayänanta munar puriyan. Dios Yayaman mañacuyänanpag goricäyänan wajicunachöpis allicag jamacunamanmi jamacuyta munayan. Banquëti fiestacunachöpis punta punta jamacunacunachömi jamayta gustayan. ");
INSERT INTO qxnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Viudacunapa wajincunatapis gechusquirmi, disimularnin alli tucur unayyag resacur cayan. Tsaynö rurayanganpitam, paycunataga Dios Yaya mas mantsacaypag castiganga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsay templuchönam Señor Jesucristo ricaraycargan, capugyog rïcu runacuna gellay wiñäyänan cäjaman Dios Yayapag wiñäyagta. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsaynöllam ricargan juc wactsa viudapis ishcay ichishag wallcalla väleg gellayninta wiñagta. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tsaynam Señor Jesucristo nirgan: “Rasuncagtam niyag, cay wactsa viudam llapancunapitapis mas atscata Diospag wiñashga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Waquincunaga atsca cayäpuptinpis ichic sobragllatam churayashga. Pero cay wactsa viudaga pachanpagwan jananpagpis faltapucuycarmi llapanta capunganta Dios Yayapag churashga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waquincagcunanam parlaycäyargan tsay templu shumag rumicunawan adornashga y Diospa garaynincunawan allish alajashga canganta. Pero Señor Jesucristo nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Chämungam junagcuna cay ricaycäyangayqui shumag adornashgacunawan llapan rumincunapis juccag rumipa jananchö manana quëdananpag. Tsaynömi jancat juchur ushacanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsaynam tapuyargan: “Maestru, ¿imaytan tsaynöga canga? ¿Ima señaltatan ricäyäshag cay llapan ningayqui cumplinanpagga caycanganta?” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Señor Jesucristonam contestargan: “¡Cuidädu cayanqui pipis mana engañayäshunayquipag! Atscagmi nogatucur shamurnin niyanga: ‘Nogam cä.’ ‘Dios dispöningam tiempu chämunganam’ nir. Pero gamcunaga ama criyirnin paycunata gatiräyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Si guerracunapagwan juc marca runacuna maganacugta wiyarpis ama mantsacäyanquitsu. Tsaynömi rasumpa tsaycunaga päsanga. Pero tsaycuna päsaptinpis cay patsaga manaragmi ushacangaragtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tsaynöllam nirgan: “Juc naciunmi juccag naciunwan peleayanga y juclä marcacunawanmi guerracunata rurayanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maytsaychöpis matsacaypagmi patsa cuyunga, alläpa mallagacuywan y pesti geshyaycunawanmi wañur ushacäyanga. Cieluchöpis alläpa mantsacaypag jatusag señalcunatam ricäyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pero caycuna manarag päsaptinmi, gaticachäyäshurniqui achcuyäshunqui. Goricäyänan wajicunaman apaycur juzgayäshurniquim, carcelman gaycatsiyäshunqui. Tsaynöllam mas mandacug autoridäcunapawan reycunapa puntancunaman nogaraycu apayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tsaycuna päsayäshungayquiwanmi nogapag rasumpa willacur musyatsicuyanqui imayca testïgünö. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero gamcuna ama yarpachacuyanquitsu imanö defendicuyänayquipag cangata, ");
INSERT INTO qxnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nogam alli yachayniquicuna garayäshayqui parlayänayqui öra. Tsaynö alli yachayta parlayaptiquim chiquiyäshugniquicunapis ni imapita acusayäshunquitsu y manam ni imanö contradecïtapis puediyäshunquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero gamcunataga traicionayarniquim autoridäcunaman quiquiquicunapa taytayquicunawan mamayquicuna, waugeyquicuna, aylluyquicunawan amïgoyquicunalla apayäshunqui y waquiquitaga wañutsiyäshunquim. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tsaynömi nogaraycu llapan runacuna chiquiyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero tsaynö chiquiyäshuptiquipis yamayllam caycäyanqui, manam ni juc agtsayquicunallapis ogracangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tsaymi firmi criyicuyniquicunawan alli tsaracuyänayqui almayquicuna salvacänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalén marcata soldäducuna tumat täparagta ricarmi, Jerusalénpa ushacaynin junag chämunganta musyayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tsayta ricarga Judeachö täcugcuna jircacunapa geshpicur aywacuyätsun. Patsan Jerusalénchö päragcunapis tsaynö geshpicuyätsun y yargoshgacagcunaga ama cutiyätsuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsaynömi alläpa mantsacaypag castïgu canga, Diospa Palabran gellgashgachö willacungannö llapan cumplinganyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Allau, tsay junagchö geshyag warmicunawan chuchuycag llullu wamracuna! Tsaynö alläpa sufriymi tsay naciunchö canga y alläpa mantsacaypag castïgum canga tsay Israel runacunapag. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquintam espädawan wañutsiyanga; waquincagtanam maytsay naciuncunapa prësu apayanga. Dios Yayaman mana criyig caru marca runacunam Jerusalénta jarutäcuyanga asta Dios Yaya dispöningan tiempuyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Señalcunam canga rupaychöwan quillachö, goyllorcunachöpis. Lamar alläpa mantsacaypag gayarar lagchicaptinmi, maytsay naciuncunachö runacuna mantsacaywan llaquicur ni imanö cayta puediyangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tsaynam runacuna mantsacaywan desmayäyanga cay patsa ushacasquinganta yarpar. Tsaynöllam cieluchö caycagcunapis llapan cuyupacuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tsay öram ricäyämanga Diospita Shamushga Runa pucutay rurinchö poderöso cayninwan alläpa chipacyarrag shamuycagta. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Caycuna llapan niyangagcuna päsagta ricar, alli valoracurnin cushishga cayay. Tsaymi librar salvayänagpag ichicllana faltaycanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Señor Jesucristo cay iwalatsicuywan yachatsicur nirgan: “Ïgos jachapitawan waquincag jachacunapita yachacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Jachacunapa rapran tsegllimugta ricarmi, achay tiempu chämunanna canganta musyayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tsaynöllam llapan willayangagcuna päsagta ricar, Dios Yayapa Mandacuy Reynon chämunanpag ichiclla faltanganta musyayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Rasuntam niyag: Canan tiempu runacuna manarag wañuyaptinmi, caycuna llapan cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cieluwan cay patsapis ushacangam, pero nogapa palabräga mana juc faltarmi llapan cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Cuidacuyay, shongoyquicuna munangan mana alli viciucunapitawan machaycunapita y cay vïdachö imaycapagpis yarpachacuycunapita. Tsaynö mana cuidacur caycäyaptiquitag tsay junagcuna, ");
INSERT INTO qxnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","imayca trampa achcugnö achcuyäshunquiman. Tsaynöllam entëru munduchö llapan runacunamanpis chämunga. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pero gamcunaga Dios Yayaman mañacur imaypis shuyaycäyay, mana alli tiempucunachöpis firmi criyicuyniquicunawan alli tsaracurnin salvacäyänayquipag. Tsaynö alli tsaracurmi Diospita Shamushga Runapa puntanchöpis mana mantsacurnin ichiraycäyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Señor Jesucristoga junagpam templuchö yachatsicug y pagaspanam Olïvos niyangan jircachö cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsaca tsacallanam llapan runacuna templuman aywayag, Señor Jesucristopa yachatsicuyninta wiyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Levadürannag tantata micuyänan semäna Pascua fiestapag ichicllanam faltaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mas mandacugcag sacerdöticunawan ley yachatsicugcunam, runacunapita mantsacurnin imaycanöllapis ashiyargan Señor Jesucristota wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsaypitanam Señor Jesucristopa chunca ishcay discïpuluncunapita Judás Iscariotepa shongonman Satanas yaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tsaymi sacerdöticunapa mandagnincunamanwan templuchö wardiacunapa mayornincunaman aywaycur parlargan, Señor Jesucristota traicionarnin imanöllapis entregananpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Paycunanam alläpa cushicushga gellayta pägayänanpag äniyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judásga änisquirnam runacuna mana cayangan örata ashirgan, Señor Jesucristota entregananpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Levadürannag tantata micuyänan junagchömi, costumbrincunamannö imaypis juc mallwa üshata pishtayag Pascua fiestapag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tsaynam Pedrotawan Juanta Señor Jesucristo mandargan: “Aywayay Pascua micuyta llapantsic micunapag alistag” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Paycunanam tapuyargan: “¿Maychö alistayänätatan munanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Señor Jesucristonam contestargan: “Jerusalénman chaycurmi juc runa puyñuwan yacuta apaycagta tariyanqui. Tsay runata asta wajinman yaycungayag gatirnin, ");
INSERT INTO qxnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tsay wajiyogta niyanqui: ‘Maeströcunam nin: ¿Maygancag cuartoyquichötan discïpulücunawan Pascua micuyta micushag?’ ");
INSERT INTO qxnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wajiyognam ricätsiyäshunqui altuschö juc jatun cuarto alistashgata. Tsaychö micunapag alistayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Paycuna aywarnam, Señor Jesucristo ningannölla tarisquir, Pascua micuyta micuyänanpag alistayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Merienday öranam discïpuluncunawan Señor Jesucristo micuyänanpag mësaman jamaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tsaynam Señor Jesucristo nirgan: “¡Imanömi munargä, celebrarnin Pascua fiesta meriendata gamcunawan pagta manarag wañucurnin micuyta! ");
INSERT INTO qxnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tsaymi niyag: Mananam cay micuytaga micushagnatsu asta cieluchö gamcunawan Dios Yayapa Mandacuy Reynonchö yapay micungantsicyag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tsaypitanam cöpachö caycag vïnota achcurcur, Dios Yayata agradëcicusquir discïpuluncunata nirgan: “Cayta llapayqui yawatsinacur upyatsinacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Rasuntam niyag: Mananam üvapita vïnota yapayga upyashagnatsu asta Dios Yayapa Mandacuy Reynon chämuptin goricangantsicyag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsaynöllam tantata achcurcur Dios Yayata agradëcicusquirnin ishcayman paquisquir discïpuluncunata macyar nirgan: “Cayga nogapa cuerpümi. Gamcunaraycum chiquimagnïcunaman entregashga canga. Tsaymi nogata yarpäyämar imaypis caynö rurayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tsaynöllam micur ushasquiyaptin, cöpachö caycag vïnota achcurcur nirgan: “Cay cöpachö caycagmi imayca juc señalnö Dios Yaya gamcunawan juc mushog conträtuta änicurnin yawarnïwan rurangan. Tsaymi gamcunaraycu yawarnï jichashga canga. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero tsay traicionar ranticamag runapa maquinga cay mësachömi nogapawan pagta caycan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Diospita Shamushga Runaga quiquin Dios Yaya dispöningannömi wañutsag. Pero ¡allau tsay traicionarnin ranticug runa!” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Discïpuluncunanam quiquincuna pura tapunacuyargan: “¿Maygantsictan tsay traicionëro cantsic?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsaypitanam discïpuluncuna mas mandacuyog cayta munarnin piñanacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tsaynam Señor Jesucristo nirgan: “Dios Yayaman mana criyicugcunawan cay patsachö mandacug reycunaga, podernincunachö runacunatam alläpa allgotsacur mandayan ‘Alläpa alli mandacugmi cayan’ niyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero gamcunaga manam tsaynötsu cayänayqui. Mas bien maygayquipis mayor mandacug cayta munarga, pishi wamranö umilde gollmi shongom cayänayqui. Tsaynöllam mas importanti mandacug cayta munarga, waquincagcunapa servignin cayänayqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tsaypunga ¿maygantan mas importanti mandacug canman, mësachö jamaycagcu o micuynin servigcagcu? ¿Acaso manacu mas importanti mandacuyyog mësachö jamaycag, tsay servigninpitapis? Tsaynö caycaptinpis, nogaga imayca servicugnömi gamcunachö caycä. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Gamcunaga nogawan pagtam imayca sufrimientücunachöpis cayashcanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tsaymi Dios Yaya nogata mandacunäpag churamangannölla, gamcunatapis mandacuyänayquipag churayag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gamcunaga nogapa Mandacuy Reynö mësachömi micuyanqui y upyayanqui. Tsaynö mandacuyniquicunawanmi nogapa puntächö alli jamacunacunaman jamaycur, chunca ishcay Israel casta runacunata juzgayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tsaynöllam Señor Jesucristo nirgan: “Simón, Simón, Satanasmi mañacushga, imayca trïguta wayragnö jutsaman ishquitsishunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero nogam Dios Yayaman gampag mañacurgö mana gelanar, nogaman firmi criyicamunayquipag. Tsaynam nogaman yapay firmi criyicamurnin, criyicugmajiqui llapan waugeyquicunata yanapaycunqui nogaman firmi criyicur alli tsaracuyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pero Simón Pedronam nirgan: “Señor, nogaga gamwan pagtayquim carcelmanpis aywashag. Tsaynöllam mana dëjarniqui pagtayqui wañushagpis.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Señor Jesucristonam nirgan: “Pedro, rasuntam nig: Canan pagasmi gällu manarag ishcay cuti cantaptin, quiquiqui quimsa cuti ‘Manam regëtsu’ nimar nëgamanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tsaypitanam Señor Jesucristo tapurgan: “Puntata gellayninnagtawan millcapannagta y llangennagta mandayangagchö, ¿imayquicunallaga faltargancu?” Paycunanam contestayargan: “Manam ni imäcunapis faltargantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tsaypitanam Señor Jesucristo nirgan: “Cananmi sïga gellayniquicunatawan alporjayquicunatapis apayay. Si espädayquicuna mana captinga, punchuyquicunata ranticusquir jucta rantiyay. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Niyangagnömi nogapag Diospa Palabran gellgashgachö ningan cumplinga: ‘Mana alli ruragcunapa rurinchömi jutsasapacunawan yupashga cargan.’ Tsaynö rasumpam Diospa Palabranchö nogapag llapan gellgayangancunaga cumplinga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tsaynam discïpuluncuna niyargan: “Señor, caychö ishcay espädallam cayäpaman.” Señor Jesucristonam contestargan: “¡Tsayllapagnam!” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsaypita yargosquir costumbrinmannö Olïvos niyangan jircaman aywaptinmi, discïpuluncunanam gatiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tsayman chaycurnam nirgan: “Dios Yayaman mañacuyay Supay tentayäshurniqui jutsaman mana ishquitsiyäshunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsaynö nisquirnam ichic mas washalänincunaman witisquir, gongorpacuycur Dios Yayaman quiquillan mañacur, ");
INSERT INTO qxnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","nirgan: “Taytallä, gam munarga cay sufrir ñacanäpagcagpita salvaycamay. Pero noga munangänöga ama catsuntsu, sinöga gam munangayquinölla callätsun.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsaymannam cielupita juc angel yurisquir, Señor Jesucristota mas callpata gorgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsaynö shongonchö alläpa llaquicurmi, Dios Yayaman mas jinchi mañacurgan jumpinpis yawarnörag patsaman shutunganyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mañacunganpita sharcurnam discïpuluncuna caycäyanganman aywar, puñucäyashgata tarirgan. Llaquicuywan pishipashga cayaptinmi, puñuy alläpa vencergan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsaymi Señor Jesucristo nirgan: “¿Imanirtan puñucäyanqui? Sharcur riccharnin Dios Yayaman mañacuyay, Supay jutsaman mana ishquitsiyäshunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Señor Jesucristo parlar manarag ushaptinmi, atscag runacuna chäyargan. Tsay atscag runancunapa puntantam aywargan chunca ishcaypita juccag discïpulun Judás niyangan. Tsaynö atscag runancuna pushashga chaycurmi, Señor Jesucristoman witiycur gagllanchö mutsaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero Señor Jesucristonam nirgan: “Judás, ¿mutsayquiwancu Diospita Shamushga Runata traicionarnin ranticunqui?” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Señor Jesucristowan caycag discïpuluncunanam, tsaycuna päsagta ricar tapuyargan: “Señor, ¿cay espädäcunawan wallucachascayämushag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsaynam juccag discïpulun mas mandacugcag sacerdötipa servigninpa derëchucag rinrinta jipicat wallusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Señor Jesucristonam nirgan: “¡Dëjaycuyay! ¡Tsaynöllana!” Tsaypitanam servicugpa rinrinta yataycurlla cuticascatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tsaypitannam sacerdöticunapa mandacugnincunatawan templuchö wardiacunapa mayornincunata y mandacug auquincuna Señor Jesucristota prësur apagnin shamushgacunata Señor Jesucristo nirgan: “¿Imanirtan gamcunaga espädayquicunawan y tucruyquicunawan shayämurgoyqui, runacunata timpullyätsir imayca mana alli ruragmannö? ");
INSERT INTO qxnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Waran waran gamcunawan pagta templuchö caycaptïga, ¿manam ni yatayämargayquillapistsu? Pero cananmi sïga, öra chämushga Supaypa munayninta rurar achcuyämänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsaypitanam Señor Jesucristota prësu achcusquir mas mandacugcag sacerdötipa wajinman apayaptin, Pedro caru gepallanta gatirnin aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tsay wajipa patiunchönam runacuna ninata sendircur mashacurnin caycäyargan. Tsaynam Pedropis paycunaman witiycur mashacuycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nina atsicyagwanmi mandacug sacerdötipa servignin warmi, Pedro jamaycagta alli ricapaycur nirgan: “Cay runapis tagay runawanmi purishga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero Pedronam nëgarnin nirgan: “Warmi, paytaga manam regetsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tsaypita unay rätutanam juccag ricaycur nirgan: “Gampis tagay runawanmi purishcanqui.” Pedronam contestargan: “Manam. Runa, paywanga manam purishcätsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsaypita yapay juc öratanönam juc runa nirgan: “Rasumpam cay runaga paywan purishga. ¡Paypis Galilea runam!” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedronam nirgan: “Runa, ¡manam musyätsu ni imata parlangayquitapis!” Pedro tsaynö parlar manarag ushaptinmi, gällu cantasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tsaynam Señor Jesucristo Pedroman tumaycur ricasquiptin yarpasquirgan: “Canan pagasmi manarag gällu cantaptin quimsa cuti, regemangayquita nëgamanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsaypita wagtaman yargosquirmi, pësacurnin alläpa llaquicur wagargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tsaypitanam Señor Jesucristota prësusquir cuidag runacuna allgotsäcur burlacurnin alli magayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawinta tsaparcurmi tapuyargan: “Mä ¿pï magashungayquitapis? ¡Adevinay!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tsaynöllam tucuyläya imaycawan insultarnin allgotsäcur burlacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Patsa warasquiptinnam judiucunapa mandagnin respetashga auquincunawan sacerdöticunapa mas mandacugnincuna y ley yachatsicugcuna goricäyargan. Tsaynö llapan goricashgapa puntancunaman Señor Jesucristota apaycurmi tapuyargan: ");
INSERT INTO qxnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Niyämay: ¿Gamcu Diospita Shamushga Runa canqui?” Señor Jesucristonam contestargan: “Rasumpa nogam cä niyaptigpis, manam criyiyämanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y gamcunata tapuyaptigpis, manam contestayämanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero cananpitam Diospita Shamushga Runaga, Poderöso Dios Yayapa derëchucag lädunchö jamanga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsaynam llapan tapuyargan: “¿Tsaypunga Diospa rasumpa Tsurinchi canqui?” Señor Jesucristonam contestargan: “¡Quiquiquicunam, rasumpa noga cangäta niyargoyqui!” ");
INSERT INTO qxnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tsaypitanam paycuna niyargan: “¿Imapagnatan mas testïgucunatapis wanantsic? ¡Llapantsicmi wiyargontsic quiquinpa shiminwan nimangantsicta!” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsaypitanam llapan autoridäcuna sharcur, gobernador Pilatoman Señor Jesucristota apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pilatopa puntanchönam Señor Jesucristopa contran parlar acusarnin niyargan: “Cay runatam tariyargö marcantsicchö runacunata contrantsic willapar caycagta. Tsaynöllam Romachö mandacug Cesarman impuestuta päganatapis amatsacur, ‘Diospita Shamushga Reymi cä’ nin.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tsaynam Pilato tapurgan: “¿Gamcu Israel runacunapa mandacug reynin canqui?” Señor Jesucristonam contestargan: “Aumi, gam ningayquinöllam cä” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsaynam mandacug sacerdöticunatawan llapan runacunata Pilato nirgan: “Manam ni ima jutsantapis cay runachöga tarïtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tsaynö niptinnam, paycunaga obligarnin mas jinchi niyargan: “Yachatsicuyninwanmi runacuna piñacatsir, autoridäcunapa contran shäritsin. Galileapitam yachatsicur gallarimushga, cananga cay Judiachönam yachatsicur sïgiycan.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tsayta wiyarmi, Pilato tapucurgan: “¿Cayga runaga Galileapitacu?” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Aumi” niyaptinnam, Pilatoga Galileachö mandacug Herodesman apatsirgan. Tsay junagcunam Jerusalénchö rey Herodespis caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Señor Jesucristota chäratsiyaptinnam, rey Herodes alläpa cushicurgan. Payga unaypitanam Señor Jesucristota ricayta munargan, imayca milagru rurangancunapag runacuna parlagta wiyashga car. Tsaymi ricayta munargan ima milagrullatapis puntanchö rurananta. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tsaymi imaycacunata tapurgan. Pero Señor Jesucristoga manam ni imata contestargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tsaychö caycag mas mandacugcag sacerdöticunawan ley yachatsicugcunanam, alläpa chiquirnin tucuyläyapa acusar Señor Jesucristopa contran parlayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tsaynam Herodes soldäduncunawan allgotsacurnin burlacur, chipapag mantuta ashgotsirgan imayca juc reytanö. Tsaynö ashgorcatsirnam gobernador Pilatoman yapay cutitsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tsay junagmi Herodeswan Pilato amïgota rurar amistayargan, unayga chiquinacur piñashgam cayanganpita. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tsaypitanam sacerdöticunapa mas mandacugnincunatawan autoridäcunata y tsay marcachö llapan runacunata gayascatsir, ");
INSERT INTO qxnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilato nirgan: “Gamcunam cay runatam nogaman apayämurgoyqui: ‘Runacunatam llutanta yarpätsirnin piñanacatsin’ nir. Pero llapayquipa puntayquicuna tapurnin, manam ni ima jutsanta acusayangayquinöga tarïtsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tsaynöllam Herodespis jutsanta mana tarir, nogaman cutitsimushga. ¡Cay runaga manam ni ima mana allitapis rurashgatsu wañunanpagnöga! ");
INSERT INTO qxnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tsaymi canan alli astaycatsirlla dëjaycushag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatom cada wata Pascua fiestachö costumbrincunamannö juc prësuta gargog. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero llapan runacunam juc shimilla gayaycachäyargan: “¡Cay runaga wañutsun! ¡Barrabasta gargoycuyga!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tsay Barrabastaga Roma gobiernopa contran runacunata Jerusalénchö peleatsir wañutsicushga captinmi, gaycatsishga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tsaynam Señor Jesucristota dëjaycuyta munar, Pilato yapay runacunata tapurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero runacunanam mas jinchi gayaycachäyargan: “¡Cruzchö wañutsun! ¡Cruzchö wañutsun!” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tsaypitanam yapay quimsa cutina Pilato nirgan: “¿Ima mana allitatan rurashga? Wañunanpagga manam ni ima jutsantapis tarïtsu. Tsaymi alli astaycatsirlla dëjaycushag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero runacunam Señor Jesucristota cruzman crucificätsinanpag mas jinchi yapay yapay gayaycachar alläpa büllata rurarnin obligayaptin, ");
INSERT INTO qxnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato mañayangannö cruzchö wañutsiyänanpag änirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tsaymi peleatsicur wañutsicunganpita gaycuraycag Barrabasta munayangannö gargosquir, Señor Jesucristotaga wañutsiyänanpag entregargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tsaypitanam Señor Jesucristota crucificag apaycar, chacrapita shamuycag Simón shutiyog runata achcuyargan. Payga Cirene marcapitam cargan. Tsay runatam mandayargan Señor Jesucristo apaycangan cruzta matancarcur, Señor Jesucristopa gepanta aywananpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maytsicag runacunawanmi warmicunapis Señor Jesucristopa gepanta wagarnin alläpa llaquicur gatiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Señor Jesucristonam ricaycurnincuna nirgan: “Jerusalén marcapita shamushga warmicuna, ama nogapagga wagayaytsu, quiquiquicunapagwan wamrayquicunapag wagayayga. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chämungam junagcuna niyänanpag: ‘¡Cushicuychö cayätsun mana wawa tarig gollog warmicunawan mana llullu chuchugcuna!’ ");
INSERT INTO qxnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tsay junagcunam runacuna mantsacaywan jircacunatawan jancacunata niyanga: ‘¡Juclla janäcunaman jegamur gopiscayämay cay alläpa sufriycunawan mana alli ñacay tiempu chämugta mana ricäyänäpag!’ nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Si caynö cawaycag jachatanö rurarga; ¿Allau, gamcunata imatarag rurayäshunqui, Israel runacuna imayca tsaquishga jachanö fäcil rupaypag caycagta?” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tsaynöllam Señor Jesucristotapa pagtan ishcag llutan mana alli rurag runacunatapis cruzchö wañutsiyänanpag apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tsay Calavera niyangan jircaman chaycatsirnam, Señor Jesucristota Roma soldäducuna cruzman clävayargan, ishcay mana alli ruragcunapa pagtan juccata derëchucag lädunman y juccagtana itsogcag lädunman. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Señor Jesucristonam nirgan: “Taytallä, cay runacunata perdonaycuy, manam ni imata rurayangantapis musyayantsu.” Tsaypitanam soldäducuna Señor Jesucristopa llatapanta sortiyayargan raquipunacur apayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Atscag runacunam tsaychö ricaray shaycäyargan. Autoridäcunanam Señor Jesucristota burlacurnin niyargan: “Juccunataga salvashgam. Mä canan salvacutsun, Diospa acrashgan rasumpa Cristo carga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tsaynöllam soldäducunapis witiycurnin, Señor Jesucristota alläpa burlacuyargan. Puchgog vïnota upyatsirmi, ");
INSERT INTO qxnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","niyargan: “¡Si rasumpa israelcunapa mandacug reynin carga, mä quiquiqui salvacuy!” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cruzpa puntanchömi juc letrëro gellgashgachö nirgan: “CAYMI ISRAELCUNAPA REYNIN” nir. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tsaynöllam lädunchö juc mana alli rurag clävashga warcaraycagpis yapay yapay insultayargan: “Si Diospa Tsurin rasumpa Cristo carga, mä quiquiquipis salvacuy. Tsaynö salvacusquir ¡nogacunatapis salvayämay!” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero juccagnam mana alli ruragmajinta piñapargan: “¿Manacu Diospita mantsacunqui, gampis cayläya castïguwan sufrir caycar? ");
INSERT INTO qxnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nogantsicga rasumpa mana allita rurangantsicpitam caychö castïguta sufriycantsic. Pero cay runaga manam ni ima mana allitapis rurashgatsu caynö sufrinanpagga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tsaypitanam nirgan: “Señor Jesús, Mandacuy Reynoyquichö mandacuyta gallaycur yarpaycallämanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Señor Jesucristonam contestargan: “Rasuntam nig: Cananmi nogawan paraiso niyangan shumag cawaychö canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pullan junagpitam asta las tresyag patsa jancat tutapashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Rupaypis manam atsicyargantsu. Templu rurinchö shumag awashga cortïnapis, janagpita uraypam ishcayman rachisquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Señor Jesucristonam gayaraypa nirgan: “Taytallä, gamtam almalläta entregaycug.” Tsaynö nisquirnam wañusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Roma soldäducunapa capitanninnam, tsaycuna päsagta ricaycur Dios Yayata alabar nirgan: “Cay runaga rasumpa jutsannagmi cashga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tsayman llapan goricashga runacunanam, tsaycuna päsagta ricar, alläpa llaquicuywan pëchuncunatapis cutarrag cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero Señor Jesucristota regegnin runacunanawan Galileapita gatirnin shamushga warmicunanam, carullapita tsaynö llapan päsanganta ricaraycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tsaychömi José shutiyog runa Judeachö caycag Arimatea marcapita, llapan judiucuna goricäyangan wajichö mas mandacug autoridä cargan. Cay runaga alläpa alli cawacurmi, Dios munangannö imaycatapis allicunallata rurag. Tsaymi autoridämajincuna Señor Jesucristota wañutsiyänanpag parlayaptinpis, payga acuerdutsu cargan. Tsay runaga Dios Yayapa Mandacuy Reynontam shuyarargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatoman aywaycurnam Señor Jesucristopa ayanta pampananpag mañargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tsaynam Señor Jesucristopa ayanta cruzpita bäjascatsir, juc fïno säbanaswan piturcur gagachö uchcushga sepultüraman pampag apargan. Tsay sepultürachöga manaragmi ni pitapis pampayashgaragtsu cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tsay viernes tardiga, jamay sabado junagpag gallaycargannam. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Señor Jesucristota gatirnin shamushga warmicunanam, Josépa gepanta aywar ricäyargan, sepultüraman cuerpunta imanö churanganta. ");
INSERT INTO qxnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsaypita wajincunaman cutisquirnam, shumag alläpa mushcug perfümita preveniyargan Señor Jesucristopa ayanta shupayänanpag. Tsay warmicunanan ley mandacungannö, sabado jamay junag captinnam jamayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pero domingo allegnam warmicuna tsaca tsacallana preveniyangan mushcug perfümita aparcur, Señor Jesucristota pampayanganman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tsayman chärirnam sepultüra tsaparag jatun parara rumi wititsishgatana tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ruriman cörrilla yaycusquirmi, pero Señor Jesucristopa ayantaga manam tariyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tsaynö mana ni imanö cayta puedir caycarmi, ishcag runacuna atsicyarrag imayca illagonö llatapashga puntancunachö shaycäyagta ricaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tsaymi alläpa mantsacaywan tsay warmicuna asta patsayag umpucuycuyargan. Tsay chipacyag runacunanam niyargan: “¿Imanirtan cawaycag runata wañushgacuna pamparäyanganchö ashiyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Manam caychönatsu. ¡Cawamushganam! ¿Yarpäyay Galileachö gamcunawan caycar niyäshungayquita? ");
INSERT INTO qxnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Diospita Shamushga Runatam jutsasapacunapa maquinman entregayanga cruzchö wañutsiyänanpag. Pero wañutsiyanganpita quimsa junagllatam cawamunga.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsaynö niyaptinnam Señor Jesucristo tsaynö willacunganta warmicuna yarpasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsaypita cutisquirnam, chunca juc discïpuluncunata tsay sepultürachö ricäyangantawan wiyayanganta willayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tsay apostolcunata willagnin warmicunaga María Magdalena, Juana, Santiagopa maman María, mas juc warmicunawan cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero apostolnincunaga tsaynö willacuyanganta wiyar, “¡Imatachari parlayanpis!” nir, manam criyiyta munayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedroga imanö captinpis sas sharcurmi cörrilla aywargan, Señor Jesucristota pampayanganman. Sepultüraman chärirnam gawaycurgan piturangan säbanasllana caycagta. Tsayta ricaycurnam, yarpachacur alläpa mantsacashganö cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Señor Jesucristo cawamungan junagmi, ishcag gatiragnincuna Emaus niyangan marcaman aywaycäyargan. Tsay marcaga Jerusalénpita chunca ishcay kilometrom cargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ishcan gatiragnincunam Jerusalénchö llapan päsangancunata parlar aywaycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tsaynö parlarnin entenditsinacur aywaycäyaptinmi, Señor Jesucristo yurisquir paycunawan pagta aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero ricaycarpis imayca imapis tsaparagnömi Señor Jesucristo canganta regeyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsaynam Señor Jesucristo tapurgan: “¿Imata parlartan nänita aywaycäyanqui?” Paycunanam llaquishga ichisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsaynam Cleofas shutiyogcag contestargan: “¿Gamllach Jerusalénchö patsacushga caycarpis, cay junagcuna ima päsanganta mana musyanquitsu?” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Señor Jesucristonam tapurgan: “¿Imatan päsashga?” Paycunanam niyargan: “Juc runam Nazaret marcapita Jesús shutiyog cargan. Paymi Diosnintsicpa profëtan car, rurayninwan y parlayninwanpis alläpa poderöso cargan, Dios Yayapawan runacunapa puntanchöpis. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytam sacerdöticunapa mas mandagnincunawan autoridänïcuna condenarnin cruzman clävar wañutsiyänanpag entregayashga. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pero nogacunaga imanömi Payman criyicuyargä, ‘Paychi Israel naciunta libramäshun’ nir. Tsaynö rasumpa criyicuycäyaptïpis, quimsa junagnam Payta wañutsiyangan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero waquincag warmicunam canan tsaca tsacallana Señor Jesucristo pamparanganman aywar, mantsacaypagta willacayämushga. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Señor Jesucristopa cuerpunta mana tarirnin wajiman cutiscamurmi, niyämargon angelcunash yuripusquir, ‘Señor Jesucristoga cawanmi’ niyargon. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tsaynö niyämaptinmi waquincag yanagëcuna sepultüraman aywayargon y warmicuna willacuyangannöllash Señor Jesucristotaga tariyargontsu ni ricäyargontsu.” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tsaynam Señor Jesucristo nirgan: “¡Gamcunaga imayca upanö mana musyag chucru shongom cayanqui, Dios Yayapa unay profëtancuna willacuyanganman mana criyiyänayquipag! ");
INSERT INTO qxnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manacu Cristoga tsaynö sufrir wañunan cargan, manarag glorianman cuticur?” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsaynö nirmi, paycunata esplicargan Diospa Palabranchö paypag willacunganta. Moisés gellganganpita gallaycur, asta Diospa profëtancuna gellgayanganyag, quiquinpag parlar aywaycäyanganta entenditsir. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaus marcaman yaycuycäyaptinnam, Señor Jesucristoga nänipa päsaräcugnölla aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero paycunanam quëdananpag obligar niyargan: “Nogacunawan quëdacushun alläpa tardinam. Patsapis goyaycannam.” Tsaynam Señor Jesucristo yaycurgan paycunawan quëdacunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Micuyänanpag mësaman jamaycuyaptinnam, Señor Jesucristo tantata achcurcur bendisarnin Dios Yayaman mañacusquir, ishcayman paquisquir discïpuluncunata macyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tsay öram imayca ñawincuna quichasquignö Señor Jesucristo canganta regesquiyargan. Pero tsaypitam illacasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsaymi ishcan quiquincunapuralla ninacuyargan: “Tsaynö Jesús captinchi ¿nänita shamushga shongontsic manacu alläpa cushicurgon, Diospa Palabranta willacur entenditsimashga?” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tsaypita sharcurnam pagas jina öra Jerusalénman cutiyargan. Chärirnam chunca juc apostolcunatawan waquincag compañëruncuna goricashga caycagta tarisquir, ");
INSERT INTO qxnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","willarnincuna niyargan: “Rasumpam Señor Jesucristoga cawamushga. Simóntam yuripushga.” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tsaynam Emauspita ishcan cutigcunapis nänichö ima päsayangantawan tantata paquingan öra regeyanganta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsaynö parlaycäyaptinmi, puntancunaman yurisquir Señor Jesucristo saludacur nirgan: “Alli päsacuychö cayay.” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tsaynam llapan alläpa mantsacar yarpäyargan: “¡Cayga, almacu o imatan!” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Señor Jesucristonam nirgan: “¿Imanirtan mantsacashga caycäyanqui? ¿Imanirtan shongoyquicunachö firmi mana criyicuyanquitsu? ");
INSERT INTO qxnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ricäyay maquïtawan chaquïtapis. ¡Quiquïmi cä! ¡Masqui yatayämay! Ricäyämay, almapaga manam aytsan ni tullun cantsu. Pero nogapaga ricäyämangayquinömi aytsäwan tullü can.” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tsaynö nirmi maquincunatawan chaquincunata ricätsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cushicuynintinwan mantsacashganö carmi, criyiyarganragtsu Pay rasumpa canganta. Tsaynam Señor Jesucristo nirgan: “¿Caychö imallayquicunaga cancu micunäpag?” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Paycunanam juc pescädo cancashgatam garaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chasquicusquirnam llapan puntancunachö micurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tsaypitanam nirgan: “Caynö päsamänanpagga gamcunawan caycarmi willayargag: Moisés gellgangan leycunawan Dios Yayapa profëtancuna y Salmo libruchöpis nogapag gellgashga caycag cumplinanpag canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsaynö Diospa Palabran gellgashgata entenditsirmi, ");
INSERT INTO qxnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","nirgan: “Gellgashgam caycan Diospita Shamushga Runata sufritsir wañuscatsiyaptin, quimsa junagllata cawamunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Paypa shutinchö Jerusalénpita gallaycur, maytsay naciuncunapa aywar willacuyätsun, jutsa rurayangancunata dëjasquir arepenticurnin Dios Yayaman cutiyay perdonashga cayänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gamcunam llapanta ricashga car, rasumpa testïgüga cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gamcunamanmi cachamushag Taytä änicungan Espïritu Santota. Pero cay Jerusalénllachörag caycäyanqui, Paypa podernin cielupita chämugta chasquiyangayquiyag. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsaypitanam Señor Jesucristo discïpuluncunata, Betania marcachö juc jircaman pushargan. Tsaychönam maquinta altupa pallarcur paycunata bendisargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tsaynö bendisaycarnincunanam, paycunapita raquicarnin pallaricar altu cieluman aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Discïpuluncunanam gongoricuycur Señor Jesucristo aywacuptin adorarnin, Jerusalénman alläpa cushishga cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tsaypitanam paycunaga imaypis tsay templuchö Dios Yayata alabarnin adorayargan. Tsaynö catsun.");
INSERT INTO qxnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Manarag ni imapis camashga captinmi, Señor Jesucristoga caycarganna. Tsaynöpam imaypitapis Dios Yayawanga jucllayllam cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tsaymi Payga rasumpa Diosnintsic car gallananpitanan quiquin Dios Yayawan cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paywanmi Dios Yaya llapan imayca ricangantsictapis camargan. Manam cantsu ni imapis, Señor Jesucristowan mana camashgaga. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Llapan imayca cawagcunapis paypitaragmi cawayta chasquiyan. Tsaynöllam Dios Yaya imanö canganta musyatsicur, llapan runacunapag imayca juc actsinö caycan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tsaynö musyatsicuycaptinpis runacuna jutsata rurar cawarmi, Señor Jesucristota chasquiyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios Yayam Juan Bautistata acrargan Señor Jesucristopag willacunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tsaymi payga imayca juc testïgunö willacurgan Señor Jesucristoman rasumpa criyicurnin, runacuna chasquir Payllamanna criyicuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan Bautistaga manam Dios Yaya cachamungan actsinö Salvacug Jesucristotsu, sinöga Señor Jesucristo imayca juc actsinö shamunanpag willacug testïgunllam cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Señor Jesucristom cay patsaman imayca juc actsinö shamurgan, imaypis llapan runacunata Dios Yaya imanö canganta musyatsinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Señor Jesucristo llapan imaycacunata camashga caycaptinpis, runacunaga manam pï cangantapis tantiyayantsu cay patsachö caycaptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tsaymi cay patsachö runamajincunaman shamuptinpis chasquiyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero waquincagmi sïga Señor Jesucristo salvacugnintsic canganta criyir chasquiyargan. Tsaynö criyicur chasquigcunataga, quiquin Dios Yayam “wamräcunanam cayanqui” nin. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Manam mamancunapita yuriyanganpitatsu ni taytancunapa munaynincunapitatsu, Dios Yayapa wamrancuna cayan, sinöga Señor Jesucristota cäsurnin chasquiyanganpitam. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Señor Jesucristoga runaman ticrasquirmi, nogantsicwan rasumpacag allicunallata rurar cay patsachö cawargan. Paywan purirmi nogacuna ricäyargä poderöso cayninwan alläpa cuyamangantsicta. Dios Yayapa japallan Tsurin canganta ricarmi musyayargä, rasumpa Dios Yaya imanö cangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Señor Jesucristopagmi Juan Bautista testïgunö gayaycachar willacurgan: “Cay shamug Salvadorpagmi noga parlargä, ‘Nogapita mas poderösom. Payga manarag yuriptïmi, unaypitana cargan.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tsaynö alläpa cuyamarnintsicmi, Señor Jesucristoga llapan imaycachöpis yanapamashcantsic. Tsaymi llapan bendiciunninta yapay yapay chasquishcantsic. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ñaupatam quiquin Dios Yaya mandamientun leyta unay Moisésta entregargan, llapan runacunata willacuptin cäsucuyänanpag. Pero Señor Jesucristoga alläpa cuyamarnintsicmi tantiyatsimantsic, Dios Yayapa mushog salvacug rasumpacag willacuyninta. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manam ni pipis Dios Yayataga ricashgatsu. Paytaga ricashga japallan Tsurin Dios carmi, Dios Yayapa lädunchö car. Paypita shamurmi, Dios Yaya imanö cangantapis rasumpa musyatsimantsic. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén templuchö autoridäcunam sacerdöticunatawan levita casta runacunata mandayargan, Juan pï canganta tapuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tsaynam Juanga rasuncagllata willargan: “Manam nogaga Diospita Shamushga Salvador Cristotsu cä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsaypitanam yapay tapuyargan: “Tsaypunga ¿pitan canqui? ¿Dios Yayapa unay profëtan Elíascu?” Juannam nirgan: “Manam tsaypistsu cä.” Paycunanam yapay niyargan: “Tsaypunga ¿Shamunanpagcag profëtacu canqui?” Juannam contestargan: “Manam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Paycunanam niyargan: “Tsaypunga ¿pitan canqui? Cachayämagnïcunaman cutirnin willayänäpag, quiquiqui willayämay pï cangayquitapis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan Bautistanam unay profëta Isaías gellgangannö contestargan: “Nogaga willacug profëtallam cä. Tsaymi tsunyagcunachö runacunata willacuycä, imayca mana alli nänita allitsagnö jutsancunata dëjayänanpag. Tsaynö willacuptïmi listuna cayanga, Salvadornintsic shamugta rasumpa chasquiyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseocuna Juan Bautistata tapuyänanpag mandayangan runacunam, ");
INSERT INTO qxnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","niyargan: “Si Dios Yaya cachamungan Salvador ni Elías ni unay Moisés gellgangannö shamunanpagcag profëta mana caycarga, ¿ima poderniquiwantan runacunata bautizanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juannam contestargan: “Nogaga yacullawanmi bautizä, pero gamcunawanmi caycan juc mana regeyangayqui Runa. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tsaymi Pay alläpa poderöso captin, nogaga llangenpa watunta umpuycur pascanällapagpis servïtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tsay llapantam Juan Bautistata tapuyargan, Jordan mayupa wac tsimpan Betania marcachö runacunata bautizaycaptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsay waräninnam Juan Bautista Señor Jesucristo shamuycagta ricasquir nirgan: “¡Ricäyay! Dios Yayapa mallwa Cordërunnömi Salvamagnintsic shamuycan. Paymi wañunga llapan runacuna jutsancunapita perdonashga cayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paypagmi willacurgä, ‘Payga manarag yuriptï unaypitana cargan. Tsaymi nogapitaga mas poderöso.’ ");
INSERT INTO qxnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nogaga manam musyargätsu Pay Dios Yaya cachamungan canganta. Tsaynö caycaptinpis nogaga yacullawanmi runacunata bautizargö, Salvadornintsic chämunganta musyar Israel runacunapis chasquiyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tsaypitanam Juan nirgan: “Cielupita urämur Espïritu Santo imayca palomanö Payman ratagtam ricashcä. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tsayta ricarllaga manam musyämantsu cargan, Dios Yaya cachamunanpag Acrashga Runa canganta. Sinöga unaynam musyargä, yacuwan bautizanäpag cachamagnï Dios Yaya nimanganta: ‘Juc runapa jananman Espïritu Santo ratagta ricarmi musyanqui, Espïritu Santowan bautizacug runa canganta’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tsay nimangannöllam payman Espïritu Santo ratagta ricargö. Tsaymi gamcunata willayag Dios Yayapa rasumpa Tsurin canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tsay waräninnam yapay Jordan mayu cuchunchö Juan Bautista ishcag discïpulunwan caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tsaypa Señor Jesucristo päsaycagta Juan Bautista ricasquirnam nirgan: “¡Ricäyay! Paymi Dios Yaya cachamungan mallwa Cordërunnö Salvamagnintsic.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tsaynö niptinnam, Juan Bautistatapa ishcan discïpuluncuna jagesquir Señor Jesucristopa gepanta gatirnin aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Señor Jesucristonam gepanman tumaycur tsay runacunata tapurgan: “¿Imatatan ashiyanqui?” Tsaynö niptinnam niyargan: “Maestru, ¿maychötan patsacushcanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Señor Jesucristonam nirgan: “Shayämuy ricätsiyänagpag.” Tsaynö nirmi, maychö patsacunganta ricätsiptin, las cuatro de la tardipita Señor Jesucristowan quëdayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan Bautistata cäsurnin gatiragnincuna aywagcunapam juccagpa shutin cargan Andrés. Payga Simón Pedropa waugenmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tsaymi Andrésga jina öra waugen Simónta ashignin aywargan. Tincusquirnam nirgan: “¡Nogacunam Dios Yaya cachamungan Salvamagnintsic Cristowan tincuyargö!” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tsaypitanam Andrés waugenta pushargan Señor Jesucristocagpa. Chäriyaptinnam Simónta ricaycur Señor Jesucristo nirgan: “Gamga Jonáspa tsurin Simónmi canqui. Cananpitam shutiqui ‘Cefas’ canga.” (“Cefas” ninanga Pedro ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tsay waräninnam Galilea provinciaman Señor Jesucristo aywananpag caycar, Felipewan tincusquirgan. Felipetanam “Acu, aywashun discïpulü canayquipag” nirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipega Betsaida marcapitam cargan. Tsay marcallapitam Andréswan Pedropis cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Señor Jesucristo tsaynö niptinnam Felipe Natanaelta ashignin aywargan. Tincusquirnam nirgan: “¡Dios Yaya cachamungan Salvadornintsicwanmi tincuyargö! Payga Nazaret marcapita Josépa tsurin Jesúsmi. Paypagmi Dios Yayapa unay Moiséspis leyninchö gellgargan y waquincag profëtacunapis, cay patsaman shamunanpag canganta gellgayargan. ¡Tsaymi cananga chämushgana caycan!” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tsaynö niptinnam Natanael nirgan: “Nazaret marcapitaga ¡Acäsu pillapis alli runaga yargonmancu!” Felipenam nirgan: “Masqui ¡acu aywashun regenayquipag!” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tsaymi Natanael chaycagta ricaycur Señor Jesucristo nirgan: “Cay runam sïga rasumpa Israel runacunanö mana mantsacur imatapis parlan. Payga manam ni imaypis llullacuntsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tsaynö niptinnam Natanael tapurgan: “Señor, ¿imanöpatan nogata regemanqui?” Señor Jesucristonam nirgan: “Nogaga musyämi imanö shongoyqui canganta. Tsaymi Felipe manarag gayashuptiqui ricargog, ïgos jachapa chaquinchö jamaycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsaynö niptinnam Natanael declarargan: “Maestru, gamga Diospa Tsurinmi rasumpa canqui, Israel runacuna shuyäyangä reynïcuna.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Señor Jesucristonam nirgan: “Ïgos jacha chaquinchömi ricargog niptillagcu, ¿gamga criyinqui Diospa Tsurin cangäta? Cananpitaga mana ni imay ricangayqui atsca milagrucunataran ricätsiyäshayqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Señor Jesucristonam yapay nirgan: “Rasuncagtam niyag: ¿Yarpäyanquicu Jacob sueñuyninchö cielupita angelcuna urämugta y witsaypa cutigta ricarnin musyanganta, Dios Yaya paywan caycanganta? Tsaynöllam gamcunapis cielu quicharaycagchö ricäyanqui, Dios Yayapa Tsurin maytsicag angelnincunawan caycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tsaypita quimsa junagtanam Galilea provinciachö Cana niyangan marcachö juc runa casarargan. Tsaychömi Señor Jesucristopa mamanpis caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tsay casamientumanmi Señor Jesucristotapis discïpuluncunatawan invitashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Manarag fiesta ushacaptinmi vïnoncuna ushacasquirgan. Tsaymi Señor Jesucristoman maman witiycur nirgan: “Vïnoncunam ushacashga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Señor Jesucristonam nirgan: “Mamay, ¿imanirtan tsayta nimanqui? Manaragmi örä chämunragtsu milagrucunata ruranäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Señor Jesucristopa mamannam tsay fiestachö yanapacugcunata nirgan: “Mandayäshungayquita rurayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tsaychömi yacu wiñäcuyänan sogta jatusag aswanacuna cayargan. Tsay aswanacunamanmi yaycug, cada ünuman chuscu lätapita asta sogta lätayag. Tsay yacuwanmi Israel runacuna maquincunata mayllacusquir, costumbrincunamannö Dios Yayata adorayag. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tsaypitanam Señor Jesucristo tsaychö yanapacugcunata nirgan: “Cay aswanacunaman yacuta juntat wiñäyay.” Yanapacugcunanam aswana juntata wiñäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tsaynö wiñasquiyaptinnam, yanapacugcunata Señor Jesucristo nirgan: “Cananga ichicta chagarcur quiquin mayordömu yawananpag apapäyay.” Señor Jesucristo ningannömi yanapacugcuna chagarcur apapäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tsay mayordömunam alläpa shumag mishquig vïnota yawarcurgan. Pero manam musyargantsu ni maypita apayämungantapis. Yacuta gorir yanapacugcunallam musyayargan Señor Jesucristo yacuta vïnoman ticratsishga canganta. Tsay mayordömunam noviota gayasquir nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Imayca fiestachöpis puntataga allicag vïnotaragmi servicuyan. Tsaywan machasquiyaptinragmi gamyacag vïnotaga garacuntsic. Pero gamga, fiesta ushacänanpagrag mas allicag vïnotaga pacarätsishcanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tsay Galilea provincia Cana niyangan marcachö yacuta vïnoman ticratsirmi, puntacag milagruta rurarnin Señor Jesucristo poderöso cayninta musyatsicurgan. Tsaynö musyatsicuptinmi, discïpuluncuna Dios Yaya cachamungan Cristo canganta criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsaypitanam Señor Jesucristo mamanwan waugencuna y discïpuluncuna Capernaum marcaman aywacuyargan. Tsay marcachöga juc ishcay junagllam pärayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel runacunapa Pascua fiestancuna chaycämuptinnam, Jerusalén marcaman Señor Jesucristo aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tsayman chaycurmi templupa patiunchö atscag runacuna mallwa törrucunatawan üshacunata y palomacunata ranticuycäyagta tarirgan. Tsaynöllam gellayta cambiacugcunapis tsaychö caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsay templupa patiunchö llapan imaycata ranticugcunata tarisquirmi, chicötiwan astaraycar llapan wätacunatawan runacunatapis gargamurgan. Tsaynöllam gellayta cambiacugcunapa mësancunatapis wicapacur gellaynincunatapis jancat witsir ushasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Paloma ranticugcunatanam piñapar nirgan: “¡Caycunata wagtaman sas jipiyay! Cay templuga Taytäman mañacuna wajim. Pero gamcunaga juc mercädomanmi ticratsiyashcanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tsaynö Señor Jesucristo ruranganta ricaycurmi, discïpuluncuna yarpasquiyargan, Diospa Palabranchö gellgayanganta: “Wañutsiyämaptinpis adorayäshunayqui wajiquitam chiquicurnin respetatsishag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Israel runacunapa templuchö autoridäcunanam niyargan: “¿Ima puedig cayniquiwantan cay ranticugcunata gargonqui? Mä, ima milagrullatapis ruramuy rasumpa Dios Yaya cachamushungayquita musyayänäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Señor Jesucristonam contestargan: “Cay templuta juchutsir ushasquiyaptiquim, quimsa junagllata sharcatsimushag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tsaymi Israel runacunapa templuchö autoridänincuna niyargan: “¡Imanötan cayga! Cay templutagam chuscu chunca sogta (46) watachörag shäritsiyashga. ¿Tsaytsurag gamga quimsa junagllachö sharcatsimunquiman?” ");
INSERT INTO qxnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tsaynö Señor Jesucristo parlarga manam templuta yapay shäratsinanpagtsu parlargan, sinöga wañunganpita quimsa junagllata cuerpun cawamunanpagmi. Tsaynö parlangantaga manam ni ichicllatapis entendiyargantsu autoridäcunawan discïpuluncunapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Wañunganpita cawascamuptinragmi, discïpuluncunapis Señor Jesucristo quiquinpag parlanganta yarpasquiyargan. Tsaynö musyasquirragmi Dios Yayapa Palabran gellgayanganwan Señor Jesucristo parlangan rasumpacag cangantapis criyiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalénchö Señor Jesucristo tucuyläya milagrucunata ruragta ricarmi, atscag runacuna Dios Yaya rasumpa cachamungan Cristo canganta criyiyargan. Tsay milagrucunataga rurargan, Pascua fiesta caycaptinmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Señor Jesucristoga runacuna janan shongolla cayanganta musyarmi, paycunata confiacurgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Manarag ni pï willaptinmi, Señor Jesucristoga runacuna shongoncunachö mana allicunata yarpäyanganta musyarganna. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juc fariseo Nicodemo shutiyog runam, Israel runacunapa autoridänincunawan mandacug cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi Señor Jesucristoman pagasllapa aywaycur nirgan: “Maestru, musyayämi yachatsiyämänayquipag Dios Yaya cachamushungayquita. Dios Yaya mana yanapaptinga manam ni pipis gamnöga milagrucunata ruranmantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Señor Jesucristonam nirgan: “Rasuncagtam nig: Pipis mamanpita yuringannö mana yapay yurirga, manam Dios Yayapa Mandacuy Reynonmanga yaycuyangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemonam nirgan: “Pero yashganaga ¿imanötagshi yapayga yurinman? ¡Acäsu pipis mamanpa pachanman cutiyta puedinmancu yapay yurinanpag!” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Señor Jesucristonam contestargan: “Rasuncagtam nig: Manam mamayquipa pachanman cutinayquipagtsu nicag, sinöga Espïritu Santopa poderninwan imayca yapay yurignö yacuwan bautizacunanpagmi. Tsaynö mana yapay yurirga manam ni imaypis Dios Yayapa Mandacuy Reynonmanga yaycuyangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pipis cay patsachö mamanpita yurishga runaga, cay patsachöcagcunallatam ruran Dios Yayapa mana wamran car. Pero Espïritu Santopa poderniwan yurigcagmi sïga, Dios Yayapa rasumpa wamranna car, Espïritu Santo mandangallanta ruran. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","¿Caynö niycuptigcu mantsacanqui? Imanö captinpis yapayragmi yuriyänan salvacuyta munagcagga. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Wayra gayarar wayrämugta wiyarpis manam ricäyanquitsu maypita shamunganta ni maypa aywangantapis. Tsaynöllam ricäyantsu, Espïritu Santo poderöso cayninwan juc mushog cawayman pitapis ticratsiptin.” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tsaynö Señor Jesucristo niptinmi Nicodemo yapay tapurgan: “Señor, manam musyallätsu. ¿Imanörag tsaynöga yapay yuriyanga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Señor Jesucristonam nirgan: “Israel runacunapa yachatsicugnin caycarpis ¿manacu cay ningagcunata tantiyar entendinqui? ");
INSERT INTO qxnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rasumpa musyangätawan cieluchö ricangätam, imayca juc testïgunö willacur parlä. Pero tsaynö willayangagta wiyaycarpis, gamcunaga manam criyiyämanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Si cay patsachö caycagcunapag willayangagta mana criyiycarga, ¿imanörag cieluchö caycagcunapag willayaptigpis criyiyämanquiman? ");
INSERT INTO qxnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Manam ni pipis cieluman aywasquir cutimushgatsu imanö cangantapis willayäshunayquipag. Mas bienmi Dios Yaya cachamuptin cay patsaman willacunanpag Shamushga Runalla, cielutaga rasumpa regen. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Unay Moisés tsunya jircachö broncipita rurashga culebrata tucrupa puntanman watarcur jawingannöllam, Dios Yaya cachamungan runatapis cruzman clävaycur jawiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tsaynö wañutsiyangan runaman criyicugcunaga llapanpis mana ushacag cawaytam tariyanga. Tsaynöllam Espïritu Santopa poderninwan yurishga carga cieluchö imayyagpis shumag cawacuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Dios Yaya llapan runacunata alläpa cuyarmi, cay patsaman japallan cuyay Tsurinta cachamurgan. Tsaymi Payman llapan criyicugcunaga, infiernuman manana aywayanganatsu, sinöga mana ushacag cawaytam tariyanga, cieluchö imayyagpis shumag cawacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Manam Dios Yayaga runacunata infiernuman garpunanpagtsu japallan cuyay Tsurinta cachamurgan. Sinöga llapan jutsasapa runacunapa jutsancunata perdonar salvananpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Tsaymi pipis Dios Yayapa japallan Tsurinman rasumpa criyicurga, condenacar infiernuman aywangatsu. Pero Dios Yayapa japallan Tsurinman mana criyicugcunam sïga, condenacarnin infiernuchö imayyagpis sufrinanpa aywanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Rasumpa cangantam niyag: Imayca mana alli ruraycunallachö cawayta munarmi, Dios Yayapa Tsurin cay patsaman imayca actsinö salvamänapag shamuptinpis chasquiyargantsu. Tsaynö mana allicunata rurar tutapaychönö cawayanganpitam condenashga cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tsaymi llutan mana alli rurag runacunaga Señor Jesucristo imayca actsinö car, llapan jutsancunata musyacätsinanta mantsacurnin chiquiyan. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero Dios Yayapa Tsurinta chasquigcagmi sïga, alli ruraynincuna musyacänanpag Dios Yaya yanapaptin allish cawacuyan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsaypitanam Judea provinciaman Señor Jesucristoga discïpuluncunawan aywargan. Tsaychömi discïpuluncunawan runacunata bautizarnin unayrag cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan Bautistanam Enon marcachö runacunata bautizaycargan. Enonga Salim marcapa amänonllam cargan. Tsaychö atsca yacu captinmi, maytsicag runacuna segïdu shayämurgan Juan Bautista bautizananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Autoridäcuna Juan Bautistata carcelman manarag gaycatsiyaptinmi, tsaychö runacunata bautizaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tsaychömi Juan Bautistapa discïpuluncuna juc Israel runawan discutinacuyargan, “Imanötan mas alli canman yacuwan bautizacunapag” nir. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tsaymi Juan Bautistata discïpuluncuna tapuyargan: “Maestru, Jordan mayu wac tsimpanchö runacunata bautizaycaptiquim chämurgan juc runa. Paypagmi niyämargayqui, ‘Cay runaga Dios Yayapa Tsurin Salvacugmi’ nir. Cananga Pay runacunata bautizaptinmi, llapan runacuna Payman aywar bautizacuycäyan. Tsaymi nogantsicmanga manana shayämunnatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tsaynö willayaptinnam Juan Bautista nirgan: “Dios Yaya cielupita llapan poderninta entregashga captinmi, paymanga tsaynö runacuna aywayan. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamcunaga musyayanquim, rasumpacagta niyangagta: ‘Nogaga manam quiquïpagtsu Salvacugmi cä’ nirgä, sinöga Dios Yaya cachamaptinmi puntanta shamurnin, Salvador shamunanpag willacurgä. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Musyayangayquinöpis juc noviowan novia casaraptin padrïnun alläpa cushicungannömi, nogapis cananga llapan shongöwan alläpa cushicü Señor Jesucristo yachatsicuptin atscag runacuna aywayanganta wiyar. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ama llaquicuyaytsu nogaman runacuna manana shayämuptin. Payga Dios Yaya munangannö poderösom. Tsaymi nogaga ni imapagpis välennatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Cielupita Shamushga salvacug Runaga rasumpam llapan cay patsachöcagcunapitapis mas poderöso. Nogam sïga cay patsallachö yurishga car, waquincag runacunanölla parlar paymanga ni imanöpa iwalätsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dios Yaya cachamungan Salvadormi willamantsic cieluchö ricangantawan wiyanganta. Pero tsaynö willacuptinpis waquincag runacunaga mana cäsurmi criyiyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Waquinmi sïga rasumpa criyicurnin tantiyayan, Señor Jesucristo Dios Yayapag rasumpacagllata willacunganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tsaycunataga Diospita shamushga carmi, Dios Yayapa Palabranta willacuycan Espïritu Santopa poderninwan. Paynöga manam ni pipis Espïritu Santopa poderninta catsintsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Quiquin Dios Yayam japallan Tsurinta alläpa cuyarnin, llapan imaycatawan poderninta entregashga paynölla poderöso cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pipis Dios Yayapa Tsurinta chasquir Payman criyicurga cay patsachöwan janag patsachöpis alläpa cushishgam cawacunga. Pero mana chasquirnin mana criyicugcagmi sïga, tsay alli cawaytaga ni imaypis taringatsu. Payman mana criyicuyanganpitam Dios Yaya rabiayninwan castigarnin infiernum condenanga imayyagpis sufrirnin ñacayänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tsaypitanam fariseocuna musyasquiyargan Juan Bautistaman aywayanganpitapis, mas atscag runacuna Señor Jesucristopa gatiragninman ticrar bautizacug aywaycäyanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero rasumpacagtaga manam quiquin Señor Jesucristotsu bautizargan, sinöga discïpuluncunallam runacunata bautizayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseocuna tsaynö parlayanganta Señor Jesucristo musyasquirnam, Judeapita yargosquir Galilea provinciaman discïpuluncunawan cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judeapita Galileaman aywayänanpagga Samaria provinciaparagmi päsayänan cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aywaycarnam Samariachö Sicar niyangan marcaman chäyargan. Tsay marcaga unay Jacob tsurin Joséta garangan chacrapa amänonchömi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tsay chacrachömi unayna Jacob juc pösuta yacupag uchcutsishga cargan. Tsaymi Señor Jesucristo pullan junag jancat pishipashga chaycurnin, tsay pösu cuchunman jamaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tsaychö Señor Jesucristo jamaycaptinmi, samaritäna warmi yacu apag chargan. Tsay warmitanam Señor Jesucristo mañacurgan: “Yacuyquita garaycamay upyanäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tsay öragam discïpuluncunaga micuyänanpag rantipacug marcapa aywashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tsay warminam nirgan: “Judiu runa caycarga ¿imanirtan yacuta mañacamanqui samaritäna cangäta musyaycar? Musyantsicmi judiucunawan Samaritänocunaga ni imaypis mana parlapänacungantsicta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tsaynö niptinnam Señor Jesucristo nirgan: “Dios Yayapita chasquinayquipagcagtawan piwan parlaycangayquitapis musyarga, gammi yacutaga mañacamanquiman. Nogaga garaycugmanmi cawatsicug chuya mana ushacag yacuta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Samaritänanam nirgan: “Señor, chuya yacuga alläpa rurichömi. ¿Tsay chuya cawatsicug yacuta garamänayquipagga, imawantan jorgamunquiman ni imallapis chaganayquipag mana caycaptinga? ");
INSERT INTO qxnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Unay awiluntsic Jacobmi cay pösuta uchcutsirgan. Cay pösullapitam tsurincunawan aylluncuna, wätancuna y quiquinpis upyayargan. Paypis cay yacullata upushga caycaptinga, ¿Acäsu gamga paypita mas importanti poderösocu canqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Señor Jesucristonam nirgan: “Pipis cay yacullata upyagcagga yapaypis yacunasquingallam. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero pipis noga garangä yacuta upyagcagmi sïga, ni imaypis mana yacunanganatsu. Tsay cawatsicug yacuga shongonllachömi imaypis canga mana tsaquig pucyunö Dios Yayawan imayyagpis alli päsacuychö cawacuyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tsay warminam nirgan: “Señor, manana ni imaypis yacunänäpag ni cay pösumanpis manana yacu apag cutinyämunäpag tsay chuya yacuyquita garaycallämay.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Señor Jesucristonam nirgan: “Canan aywar gojayquita gayasquir cayman ishcayqui shayämuy.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tsaynö niptinmi warmiga nirgan: “Señor, manam gojä cantsu.” Niycuptinnam Señor Jesucristo nirgan: “Rasumpacagllatam nicämanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tsaypunga imanirtan pitsga gojayog cashcanqui. Y tsay canan täcungayqui runaga rasumpa manam gojayquitsu. Tsay nimangayquiga rasumpacagmi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsaynö niptinnam warmiga nirgan: “Señor, gamga Dios Yayapita shamushga profëtam ïllu callanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Unaycag awilücunaga tagay jircaman aywarmi Dios Yayata adorayag. Pero gamcunam sïga, ‘Jerusalénllachömi Dios Yayataga adoranantsic’ niyanqui. ¿Maychötan allipaga Dios Yayata adorashwan?” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Señor Jesucristonam nirgan: “Criyimay warmi, cananga tiempu chämushganam maychöpis Dios Yayata adoranapag, manam tagay jircaman ni Jerusalénman aywarllatsu adorashun. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gamcunaga manam musyayanquitsu pita adorayänayquipagcagtapis. Pero nogacunam sïga rasumpa regeyangä Dios Yayata adorayä. Tsaytaga musyayä israelcunapita Salvadorta Dios Yaya acrashga captinmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Israel runacunawan mana israelcagcunapis Espïritu Santo yanapaptin llapan shongonwan Dios Yayata adorayänan tiempu chämushganam. Tsaynö llapan voluntänintsicwan adoranatam Dios Yayaga munan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Yaya Espïritu captinmi, runacuna mana ricaycarpis Espïritu Santo yanapaptinmi, llapan voluntänincunawan adorayänan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Warminam nirgan: “Nogaga musyämi Dios Yaya cachamungan Cristo cay patsaman shamunanpagcagta. Tsaymi Pay chaycamurrag llapanta willamarnintsic musyatsimäshun.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Señor Jesucristonam contestargan: “Tsay shamugpagcag Cristoga nogam cä, canan öra gamwan parlaycag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tsaynö parlaycäyaptinnam discïpuluncuna rantipacug aywayanganpita chäriyargan. Tsay Samaria warmiwan Señor Jesucristo parlaycagta tarisquirmi yarpachacuyargan: “¿Imata munartan o imanirrag tagay warmiwan parlaycan?” Pero manam ni mayganpis tapuyargantsu ni imata parlayangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tsay warminam puyñunta jagesquir, runacunata willag cörrilla marcaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“¡Shayämuy! Llapayqui ricäyänayquipag juc runam cawaynïchö llapan imayca rurangätapis nimashga. ¿Payga manatsurag shamugpagcag Cristo?” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Warmi tsaynö willacuptinnam atscag runacuna Señor Jesucristoman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tsayyagnam Señor Jesucristota discïpuluncuna niyargan: “Señor, micurcuyrag ari cay apayämungäta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Señor Jesucristonam nirgan: “Nogapa micuynïga jucmi. Tsaytaga manam gamcunaga regeyanquiragtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tsaynö niptinnam, discïpuluncuna quiquincuna pura ninacuyargan: “¿Pirag micunan apamushga? Tsaychari micuyta munannatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Señor Jesucristonam nirgan: “Nogapa micuynïga cachamagnï Dios Yaya mandamanganta cumplingämi. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Runacunanam niyan: ‘Usya tiempu ciega gallananpag chuscu quillaragmi faltan’ nir. Pero nogam niyag: ¡Ricäyay tagay runacuna muruyanganta cosëchayangannömi listuna caycäyan Dios Yayapa Palabranta chasquiyänanpag! Tsaynö chasquirnin wiyacur nogaman mas firmi criyicugcunaga mana ushacag cawaytam tariyanga. ¡Imayca allish cosëchata gorignömi goricayämunga! ");
INSERT INTO qxnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Willacungäcunata chasquirga cay patsachöwan gloriachöpis cushishgam imayyagpis cawacuyanga. Tsaynö Dios Yayapag willacurmi, imayca murucug runawan ciegäsegnin alli cosëcha yargoptin cushicuyangannö alläpa cushishga cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tsaymi cayga rasumpacag: Juc chacrayog runa mincaycunawan murungantam, juc mincaycunawanna cosechan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tsaynömi mana murushga caycäyaptiqui, cananga gamcunatapis cachayag willacuyaptiqui nogaman mas firmi criyicayämunanpag. Gamcunaga mana arurnin murushga caycarmi, juccuna alläpa sufrirnin murucuyanganta cushishga cosechayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tsay marcachömi atscag runacuna criyiyargan, Señor Jesucristoga Dios Yaya cachamungan Cristo canganta tsay samaritäna warmi. “Cawaynïchö llapan imayca rurangätam shimpimashga” nir, willacuptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tsaynam Samaria runacuna Señor Jesucristo caycanganman chaycur rugayargan paycunawan quëdacunanpag. Tsaynö rugayaptinmi, ishcay junag paycunawan quëdargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tsaychö Señor Jesucristo yachatsicuptinmi mas atscag runacuna Dios Yayapa Tsurin Cristo canganta criyiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tsaynö criyicurnam tsay warmita runacuna niyargan: “Manam gam niyämaptiquillatsu Señor Jesucristoman criyicuyä. Cananga yachatsicunganta quiquïcuna wiyarmi musyayä llapan runacunata salvananpag Dios Yaya cachamunganta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Señor Jesucristo Samariachö ishcay junag goyasquirnam, Galilea provinciaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quiquin Señor Jesucristo ningannöllam, Dios Yayapa profëtantapis marcanchöga respetar cäsuyantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galileaman chaycuptinmi atscag runacuna alläpa cushishga chasquiyargan, Jerusalénchö Pascua fiestaman aywanganchö imayca milagrucuna ruranganta ricashga car. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tsaypitanam Señor Jesucristo Galileachö Cana niyangan marcaman cutirgan. Tsay puntacag milagruta rurarnin, yacuta vïnoman ticratsingan Cana marcachömi, juc reypa mandacug autoridaninta regergan. Tsay mandacug autoridäpa wamrannam Capernaum marcachö antsa geshyaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Señor Jesucristo Judeapita Galileaman chämungata musyasquirmi, tsay autoridäga cörrilla aywargan tsurin alläpa antsa geshyaptin. Señor Jesucristoman chaycurnam rugargan: “Señor, wamrallä wañuycannam. Aywayculläshun cuticaycatsilläpamänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Señor Jesucristonam nirgan: “Gamcunaga Dios Yayapita shamungäta manam criyiyämanquimantsu, llapan imayca milagrucunatawan cushicuypag señalcuna rurangäta mana ricätsiyaptigga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tsay autoridänam rugayargan: “Señor, wamrallä manarag wañunganyag sas aywayculläshun.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tsaynö niptinmi, Señor Jesucristo nirgan: “Wajiquipa cuticuy; wamrayquiga cuticashganam.” Señor Jesucristo tsaynö ninganta criyirmi, tsay autoridä wajinpa cuticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tsaypita cuticur wajinman chaycaptinnam, servignincuna tincupasquir niyargan: “¡Taytay, wamrayquiga cuticashganam!” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tsaynö niyaptinmi, servignincunata tapurgan: “¿Imay öratan wamralläga cuticargon?” Paycunanam niyargan: “Ganyan pullan junag päsaypitam achachaynin jancat pärasquirgan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsaynö niyaptinnam wamrapa taytan yarpasquirgan, Señor Jesucristo tsay öra “Wamrayquiga cuticashganam” ninganta. Tsayta ricaycurmi wajinchö llapan caycagcunawan rasumpa criyicuyargan Señor Jesucristoga Dios Yaya cachamungan Cristo canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tsay wamrata cuticätsinganwanga Galilea provinciachö ishcay cutinam Señor Jesucristo milagruta rurargan, Judeapita cutimurnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsaypitanam Señor Jesucristo Jerusalén marcachö Israel runacunapa fiestancunaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalénchö “Üshacunapa puncun” niyangancagchömi juc pisïna pitsga corredoryog cargan. Tsay pisïnapam hebreocunapa parlayninchöga shutin cargan “Betzata.” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tsay lädun patsachömi atscag geshyagyashacuna, gapracuna, ratacuna, inväliducuna jitaraycäyargan. Paycunam tsay pisïnachö yacu cuyugta shuyarar cäycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tsay pisïnamanmi cielupita juc angel unaychö unaychö urämug yacuta cuyutsinanpag. Tsay yacu cuyugman maygan geshyagyashapis puntata yaycur ogocugcagmi cuticäyag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tsaychömi juc runa quimsa chunca pusag (38) watana geshyagyasha cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tsaynö runa unaypitana geshyagyasha ujuraycagta ricaycurmi, unayna geshyanganta musyasquir Señor Jesucristo tapurgan: “¿Cuticayta munanquicu?” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tsay geshyagyashanam contestargan: “Señor, manam pïnïpis cantsu pisïnachu yacu cuyugman yaycatsimänanpag. ‘Yarpushag’ nir ñacangäyagmi imaypis juc llalliscaman.” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Señor Jesucristonam nirgan: “¡Cananga sharcurnin gopiquita aparcur aywacuy!” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tsaynö niptinmi, tsay geshyagyasha runa jina öra cuticasquirgan. Tsay gopinta aparcurcurmi aywacurgan. Sabado jamay junag captinmi, ");
INSERT INTO qxnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Israel runacunapa autoridänincuna tsay cuticashga runata niyargan: “Canan sabado jamay junag caycaptinga ¿imanirtan gopiqui aparishga puriycanqui? Tsaynö puringayquiga leynintsicpa contranmi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero tsay runanam nirgan: “Cuticätsimagnï runam ‘Gopiquita aparcur aywacuy’ nimargon.” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsaynam autoridäcuna tapuyargan: “¿Pitan ‘Gopiquita aparcur aywacuy’ nishuruyqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero tsay runaga manam musyargantsu ni pï cuticätsingantapis, tsay maytsicag runacuna goricashgachö Señor Jesucristoga tallucarnin illacasquiptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsaypitanam Señor Jesucristo cuticätsingan runawan tincusquir nirgan: “Canan cuticashgana caycarga, amana yapayga jutsata ruranquitsu. Si yapay jutsata rurarga, maypis geshyangayquipita mas peor canqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tsaynö niptinmi, tsay runaga israelcunapa autoridänincunaman Señor Jesucristo cuticätsinganta willacug aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tsay sabado jamay junagchö runata cuticätsinganpitam, Israel autoridäcuna Señor Jesucristota chiquirnin gaticachäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Señor Jesucristonam nirgan: “Taytäga imaypis allicunata rurarmi caycan. Tsaymi nogapis paynölla allita rurar caycä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tsaynö Señor Jesucristo niptinmi, autoridäcuna mas chiquiyargan. Manam sabado jamay junagchö runata cuticätsingallanpitatsu, sinöga “Dios Yayata Taytä” nir, Paywan iwalatsicunganpitam mas chiquirnin wañutsiyta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Señor Jesucristonam nirgan: “Rasuncagtam niyag: Dios Yayapa Tsurin carpis manam quiquinpa munayllanpitaga imatapis ruranmantsu. Taytan ruranganta ricashga carmi, Tsurinpis Taytannölla imatapis ruraycan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taytan Tsurinta alläpa cuyarmi, llapan imayca rurangancunata ricätsishga. Tsaymi gamcunatapis mana ni imay ricäyangayqui milagrucunata ricätsiyäshuptiqui, alläpa mantsacashganö caycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wañushgacunata cawatsimug poderöso Taytannöllam, Tsurinpis alläpa poderöso cayninwan wañushgacunata cawatsimunga. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taytanga manam pitapis juzgangatsu. Sinöga llapan mandacuynintam Tsurinta entregashga runacunapa jutsancunapita juzgananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tsaymi Taytanta respetayangannölla, Tsurintapis respetayänan. Tsurinta mana respetarga cay patsaman cachamug Taytantapis manam respetayantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Rasuncagtam niyag: Pipis willacungäta cäsucur cachamagnï Dios Yayaman criyicurga, manam infiernuman aywangatsu. Mas bienmi gloriaman aywayanga tsaychö cushishga imayyagpis cawananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rasumpam öra chaycämunna, jutsa rurayllachö imayca wañushganö cawagcunaga Diospa Tsurin willacunganta entendiyänanpag. Tsay willacuycunata cäsurga mana ushacag cawaytam chasquiyanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taytan mushog cawayyog carmi, Tsurintapis mushog cawayyog cananpag entregashga. Tsaymi Tsurinpis runancunata cawatsimur mushog cawayta garanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Quiquin Dios Yayam podernintawan llapan mandacuyninta entregashga Diospita Shamushga Runa captinmi, llapan runacunata juzgananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Pero tsaynö niyangagta wiyar ama mantsacashganö cayaytsu. Juc junagmi chämunga Señor Jesucristopa Willacuyninta llapan pamparagcunapis wiyayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pamparäyanganpita yargascamurmi, allillata rurar cawashgacagcunaga Dios Yayawan imayyagpis glorianchö cawayanga. Pero mana alli ruragcagcunam sïga, infiernuchö imayyagpis sufrirnin ñacayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nogaga manam quiquïpa munaylläpitatsu pitapis juzgayta munä, sinöga cachamagnï Taytä munar mandamangannöllam. Tsaymi Taytä mandamanganta cumplir, segun imatapis rurayanganpita rasumpacagllata juzgashag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Si quiquilläpita imaycatapis rurangäta willayaptigga manam criyiyämanquimantsu, rasumpa cangata. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero nogapag willacug runaga jucmi. Musyämi nogapag llapan imayca willacungan rasumpa canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Dios Yayam Juan Bautistata cachamurgan, puntata shamur nogapag willacunanpag. Tsaymi payman musyapacugcunata cachayaptiqui rasuncagllata willayäshurgayqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nogaga manam wanätsu juc runa nogapag imayca testïgunö willacunantarag. Mas bienmi gamcunata willayag tsay runa willacunganwan llapayquipis salvacäyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Gamcunaga Juan Bautista willacunganta imayca juc linterna caruman juc rätulla atsicyagnömi, juc rätulla cushishga wiyar chasquiyargayqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nogapag Juan Bautista willacunganta criyir mana criyirpis, musyayanquimanmi Dios Yaya cachamaptin shamungätawan tucuyläya milagrucuna rurangäta ricaycarga. Tsaynö tucuyläya milagrucunata rurar cumplinäpagmi quiquin Dios Yaya mandamashga. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tsaynöllam quiquin Taytä cay patsaman cachamanganta musyatsiyäshunqui. Paytaga manam imaypis parlagta wiyayashcanquitsu ni ricäyashcanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dios Yaya cachamungan Runaman mana criyirmi, Paypa Palabranmanpis mana criyiyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Gamcunaga yarpäyanqui: ‘Diospa Palabranta yachacurmi, mana ushacag cawayta tarishun’ nir. Pero tsay Palabran yachacuyangayquiga, imayca juc testïgunömi nogapag willacur gellgashga caycan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tsaynö caycaptinpis gamcunaga manam chasquiyämayta munayanquitsu. Nogata mana cäsuyämarga, manam tsay mana ushacag cawayta tariyanquitsu mayjina yachacurpis. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nogaga manam runacunalla aläbayämänanta munätsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero gamcunataga rasumpam regeyag imanö cayangayquita. Rasuncagtaga manam Dios Yayata cuyayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cachamagnï Taytäpa shutinchö shamuptïmi nogata chasquiyämanquitsu. Pero juc runa quiquinpa yarpayllanpita shamuptinmi sïga, alläpa cushishga chasquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gamcunaga quiquiquipurallam imaycachöpis aläbanacur cayanqui. Pero japallan Dios Yaya gamcunapag munangantaga manam cäsuyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ama gamcuna yarpäyaytsu Taytäpa puntanchö shimpiyänagpagcagta. Gamcuna unay Moisés gellgangancunaman criyirnin shuyaräyangayquiwanmi, quiquin Moisés Dios Yayapa puntanchö shimpiyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Si unay Moisés gellgangancunata rasumpa criyirga, nogamanpis criyiyanquimanmi. Tsay llapanta Moisés gellganganchöga nogapagmi gellgashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Si tsaynö Moisés gellgangancunata mana cäsuycarga, ¿imanörag noga willayangagtapis criyiyanquiman?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsaypitanam Señor Jesucristo Galilea gochapa wac tsimpanman päsargan. Tsay gochapa juccag shutinmi Tiberias cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Geshyagyashacunata cuticätsinganta ricashga carmi, maytsicag runacuna Señor Jesucristopa gepanta gatirnin aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Señor Jesucristonam discïpuluncunawan juc jircaman witsarcur, tsaychö jamaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israel runacunapa Pascua fiestancuna cananpagmi ichicllana faltaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Señor Jesucristonam maytsicag runacuna paycagman aywaycäyagta ricasquir, discïpulun Felipeta nirgan: “Caytsicag runacuna micuyänanpag, ¿maypitarag tantata rantishun?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Señor Jesucristoga tsaynö nirgan: “Mä Felipe imaningash” nirmi. Pero Señor Jesucristoga musyargannam micuynincuna imanö garananpagcagtapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipenam nirgan: “Pusag quilla arupucur gänangantsicwan rantimushgapis ¡numpatagcu caytsicag runacuna ichic ichicllapis micuyänanpag pagtangaga!” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsaynam juccag discïpulun Pedropa waugen Andrés nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Caychö juc ollgo wamrapam pitsga cebäda tantawan ishcay pescädollan caycäpun. Pero tsayllaga ¡imapagpis pagtanmanragcu caytsicag runapagga!” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tsaynam discïpuluncunata Señor Jesucristo nirgan: “Runacunata niyay tsaychö jamacuyänanpag.” Tsaychöga juc jatun pampa wayllam cargan jamacuyänanpag. Tsaychömi ollgocagcunalla (5,000) pitsga waranga cayargan, warmicunatawan wamracunata mana yupaycäyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tsaypitanam Señor Jesucristo pitsga tantata achcurcur, Dios Yayata agradëcicurgan. Tsaypitanam discïpuluncunata macyargan, llapan jamaycag runacunata aypuyänanpag. Tsaynöllam ishcay pescädotapis rurargan runacuna micuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Llapan runacuna pacha junta micusquiyaptinnam, discïpuluncunata Señor Jesucristo nirgan: “Llapan sobragcunata goriyay mana juc catur.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Discïpuluncunanam chunca ishcay (12) canasta juntatarag, tsay pitsga cebäda tantallapita atsca sobragcunata goriyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tsay milagru ruranganta ricaycurnam runacuna ninacuyargan: “Cay runaga rasumpa unay Moisés gellganganchö cay patsaman shamugpagcag Profëtam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tsaynö nirmi runacuna amälas reynincuna cananpag churayta munayargan. Tsaynö churayänanta mana munarmi, Señor Jesucristoga juc jircapa japallan aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Patsa tutapaycaptinnam Señor Jesucristopa discïpuluncuna, juc jatun gocha cuchunman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tsaypitam discïpuluncuna büquiman lätarcur wac tsimpa Capernaumman aywayargan. Pero patsa tutapashgana caycaptinpis Señor Jesucristoga manaragmi cutimurganragtsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tsaynö jatun lamarnö gochapa büquiwan aywaycäyaptinnam, alläpa wayrar lamarta lagchicätsir gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Caru pitsga o sogta kilometrotana aywaycarmi, Señor Jesucristo yacu jananpa shamuycagta ricasquiyargan. Tsaynö shamuycagta ricasquirmi, alläpa mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero Señor Jesucristonam nirgan: “¡Ama mantsacäyaytsu! ¡Nogam cä!” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tsaynö niptinnam alläpa cushicur büquiman lätatsiyargan. ¡Tsaypitaga sasllanam chäyargan aywayangan Capernaum marcaman! ");
INSERT INTO qxnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsay waräninam lamar wac tsimpanchö maytsicag quëdashga runacuna tantiyasquiyargan, tsaychö jucllaylla caycag büquiwan discïpuluncunalla aywayangata ricar, Señor Jesucristo quëdanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tsaynö caycäyaptinmi, Tiberias marcapita runacuna büquincunawan chäyargan, Señor Jesucristo Dios Yayata agradëcicusquir tantata miratsingancagman. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tsaychö Señor Jesucristotawan discïpuluncunata mana ricarmi, jina öra llapan tsay büquincunawan Capernaum marcaman Señor Jesucristota ashig aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tsay lamarnö jatun gocha wac tsimpan Capernaumman chaycurnam Señor Jesucristota tarisquir tapuyargan: “Maestru, ¿imaytan shämuruyqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Señor Jesucristonam nirgan: “Rasuncagtam niyag: Gamcunaga manam milagrucuna rurangäpitatsu ni Dios Yaya cachamanganta entendiyänayquipagtsu ashiyämanqui, sinöga pacha junta micutsiyangagpitam. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama tsay ushacag micuyllapagga yarpachacur aruyaytsu. Tsaypa rantinga imayyagpis cawatsicug mana ushacag micuypag yarpachacurnin aruyayga. Tsay mana ushacag micuytaga nogam garayäshayqui, quiquin Dios Yaya llapan poderninta garamashga captin.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tsaynam tapuyargan: “¿Imatatan rurayäshag Dios Yaya munangannö imayyagpis cawayänäpag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Señor Jesucristonam nirgan: “Dios Yayaga munan cachamungan japallan Tsurinman firmi criyicur cäsucuyänayquitam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Runacunanam niyargan: “Diospa Tsurin carga ¿mä, ima milagrullatapis ruramuy, tsayta ricarnin rasumpa criyiyänagpag? ¿Mä imacunatatan rurayta puedinqui? ");
INSERT INTO qxnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay tiempum Moisés tsunyachö caycar, waran waran milagruta rurarnin, ‘manä’ niyangan micuyta awiluntsiccunata micutsirgan. Diospa Palabran gellgashgachömi nirgan: ‘Cielupita shamug tantatam micutsirgan.’ Mä tsaypunga gampis tsay Moisésnölla ruramuy.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Señor Jesucristonam contestargan: “Rasuncagtam niyag: Manam Moiséstsu tsay micuyta unay awiluntsiccunata garargan. Sinöga Taytämi cielupita rasumpacag tantataga garargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Payllam garayäshunqui cielupita cachämungan tantatapis cay patsachö llapan runacunata imayyagpis cawatsinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Runacunanam niyargan: “Señor, tsaypunga tsay tantata cananpita imayyagpis garaycayällämay.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Señor Jesucristonam nirgan: “Tsay cawatsicug tantaga nogam cä. Nogaman rasumpa firmi criyicugcunaga pacha junta micushganömi cayanga y yacuta tegllanganyag upyashganömi imaypis cushishga cawayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero puntata niyangagnöpis gamcunaga manam criyiyämanquitsu milagru rurangäta ricaycarpis. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Taytä entregamangan runacunaga llapanpis criyimarmi chasquiyäman. Tsaynö criyicur chasquimagcunataga puntäman shamuptinpis manam ni imay gargoshagtsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nogaga manam quiquïpa munaylläpita mandacunäpagtsu janag patsa cielupita shamushcä, sinöga cachamagnï Taytä munangannö mandamanganllata ruranäpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cachamagnïga manam munantsu entregamangan runacuna ni jucllayllapis ogracagnö infiernuman aywayänantaga. Taytäga munan cay patsa ushacangan junagchö cawatsimur cushishga cawayänanpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tsaynöllam munan Tsurinman criyicugcunaga alli cawaychö Dios Yayawan imayyagpis cawayänanta. Tsaynö criyicamugcunataga nogam cawatsimushag cay patsa ushacangan junagchöpis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tsaynö “Nogam cielupita shamushga tantaga cä” niptinmi, judiucuna piñacuyargan: ");
INSERT INTO qxnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“¿Cay runaga manacu Josëpa tsurin Jesús? Taytantawan mamantapis regentsicmi. Tsaynö regeycashaga ¿Imanirtan ‘cielupitam shamushcä’ nimantsic?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tsaynö niyaptinnam, Señor Jesucristo nirgan: “Tsaynö niyangagta ama quiquillayquicunachöga rimayämar parlaycachäyaytsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cachamagnï Taytä pitapis acrar nogaman mana apamuptinga, manam nogaman shamur criyiyämanmantsu. Tsaymi nogata chasquimagcagtaga cay patsa ushacangan junagchöpis cawatsimushag. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dios Yayapa unay profëtancuna gellgayangan libruchömi nirgan: ‘Llapan runacuna musyayänanpagmi, quiquin Dios Yaya yachatsirgan.’ Tsaynö pipis Dios Yaya yachatsinganta cäsurnin cumplirmi, nogaman shamur rasumpa chasquiyäman. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Dios Yayataga manam ni pipis ricashgatsu. Paytaga ricashga Dios Yayapita Shamushga Runallam. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rasuncagtam niyag: Pipis nogaman rasumpa criyicurga, Dios Yayawanmi imayyagpis cawacunga. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nogaga cawatsicug tantam cä. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Rasumpam tsay tsunya mana imacagchö caycar, unay awiluntsiccunapis Dios Yaya cachämungan ‘manä’ niyangan micuyta micuyargan. Tsay micuyta micuycarpis, tsay tsunyachömi wañur ushacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero cananmi sïga, cay rasumpacag tantataga, quiquin Dios Yaya cielupita cachamushga. Tsaymi cay tantata micugcagga mana ushacag cawaychö imayyagpis cawayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nogam tsay cielupita shamushga cawatsicug tantaga cä. Pipis tsay tantata micugcagga mana ushacag cawaytam taringa. Tsay tantaga nogapa cawag cuerpümi. Tsaymi noga wañushag cay patsachö llapan runacunaraycu, cieluchö mana ushacag cawayta tariyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tsaynö Señor Jesucristo niptinnam, tsay judiucuna mana tantiyar jucnin jucnin ninacuyargan: “¿Imanötan cay runaga quiquinpa cuerpunta micutsimäshun?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Señor Jesucristonam nirgan: “Rasuntam niyag: Pipis nogapa cuerpüta mana micurga y yawarnïta mana upyarga, manam ni imaypis mana ushacag cawayta taringatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pero pipis nogaman rasumpa firmi criyicamur cawagtam sïga, cay patsa ushacangan junag cawatsimushag cieluchö imayyagpis cawanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nogaga rasumpacag cawatsicug micuymi cä. Y yawarnïpis rasumpacag yacum. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nogaman rasumpa firmi criyicayämurnin cuerpüta micur y yawarnïta upyar cawagcagga, imayca jucllayllanömi nogawan cawan y nogapis tsaynöllam paywan cawä. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Cachamagnï cawatsicug Taytä carmi, nogatapis cawatsiman. Tsaynöllam nogaman criyicamugcagtaga imayyagpis cawatsishag. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Gamcunatam musyatsiyag cielupita shamugcag rasumpa tantapag. Tsay tantaga manam unay awiluntsiccuna ‘manä’ niyangan micuyta micuyangannötsu. Paycunaga tsay manäta micuycarpis wañuyarganllam. Pero cielupita shamushgacag tantata micurmi sïga, imayyagpis cushishga cawayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tsaynömi Señor Jesucristo yachatsicurgan, Capernaum marcachö Dios Yayaman mañacuyänanpag goricäyänan wajichö. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tsaypitanam Señor Jesucristo tsaynö yachatsicunganta wiyar, tsay atscag gatiragnincuna niyargan: “¡Cay yachatsicunganga alläpa aja tantiyaypagmi! ¿Pirag tsaytaga entendir chasquinman?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gatiragnin discïpuluncuna tsaynö niyanganta tantiyasquirmi, Señor Jesucristo nirgan: “¿Tsaynö nïcuyaptigcu piñasquiyargoyqui? ");
INSERT INTO qxnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pero gamcuna ¿ima niyanquimanrag Diospita Shamushga Runa, unay cacungan cieluman cutiycagta ricarnin? ");
INSERT INTO qxnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Quiquillayquicunapa munayllayquicunawanga imayyagpis mana ushacag cawaytaga manam ni imay tariyanquitsu. Sinöga yachatsicurnin willacungäta chasquirmi sïga, Espïritu Santopita mushog cawayta tariyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tsaynö caycaptinpis llapan willayangagcunata manaragmi waquiquiga criyiyämanquiragtsu.” Señor Jesucristoga tsaynö nirgan maygan runapis payta mana chasquinganta musyarmi. Tsaynöllam unaypitana musyargan maygan runa traicionarnin chiquignincunaman ranticunanpagcagtapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tsaymi nirgan: “Tsaynö mana criyiyaptiquim unayna niyargag: Si Taytä poderninta pimanpis mana churamuptinga, manam ni pipis nogaman shamur rasumpa criyimanmantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Señor Jesucristo tsaynö yachatsicuptinmi atscag gatiragnincunapis dëjasquir aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Waquincag gatiragnincuna tsaynö aywacuyaptinnam, tsay chunca ishcay (12) discïpuluncunata Señor Jesucristo tapurgan: “¿Gamcunapis paycunanö aywacuytacu munayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedronam contestargan: “Señor, ¿pimantagshi aywayäshag Dios Yayawan imayyagpis cawayänäpag yachaycätsiyämaptiquiga? ");
INSERT INTO qxnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogacunaga Dios Yaya cachamungan rasumpa Cristo cangayquitam criyirnin musyayä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Señor Jesucristonam nirgan: “¿Manacu gamcunata chunca ishcay (12) discïpulücuna cayänayquipag acrayashcag? ¡Tsaynö acrayangag caycarpis, jucniquiga Supaypa munayninchömi caycäyanqui!” ");
INSERT INTO qxnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Señor Jesucristoga tsaynö parlargan, Simón Iscariotepa tsurin Judáspagmi. Judásga Señor Jesucristopa discïpulun caycarpis, mana alli rurag runacuna wañutsiyänanpagmi traicionarnin ranticurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tsaypitanam Galilea provinciachö marcan marcan Señor Jesucristo yachatsicur purirgan. Israel runacunapa autoridänincuna wañutsiyta munayaptinmi, Judea provinciamanga aywayta munargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero Israel runacunapa Ramäda niyangan fiestancuna gallananpagmi, juc ishcay junagcunalla faltaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tsaymi Señor Jesucristopa waugencuna niyargan: “Ama cayllachöga caytsu. Ayway mä Judea marcaman tsaychöpis gatiräshugniquicuna milagru rurangayquita ricar, gamman criyiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pipis alli regeshga cayta munarga manam pacayllapaga imatapis rurantsu. Caynö milagrucunata ruraycarga, llapan runacuna musyayänanpag puntancunachö ruranquiman.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tsaynömi Señor Jesucristopa waugencunapis parlayargan, Dios Yaya cachamungan Cristo canganta mana criyir. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tsaynam Señor Jesucristo nirgan: “Manaragmi örä chämunragtsu Dios Yaya munangannö Jerusalénman aywar, llapanta rurar cumplinäpag. Pero gamcunam sïga imay örapis aywayta puediyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gamcunataga cay patsachö llapan runacuna manam chiquiyäshunquitsu. Pero nogatam sïga chiquiyäman imayca juc testïgunö jutsa rurag cayanganta musyatsiptï. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tsay fiestamanga gamcunalla aywayay. Noga aywanäpagga manaran öra chämunragtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tsaynö nisquirmi, Señor Jesucristoga Galileachö quëdacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tsaypita waugencuna fiestaman aywasquiyaptinnam, Señor Jesucristopis pacayllapa mana pitapis willarlla aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jerusalén fiestachö Señor Jesucristota alläpa ricchacurnin ashirmi, judiu autoridäcuna tapunacuyargan: “¿Tsay runaga maychörag caycan?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tsaychö maytsicag goricashga runacunanam, Señor Jesucristopag parlayargan: “Payga alläpa alli runam.” Pero waquincagcunanam niyargan: “Tsayga manam alli runatsu. Llapan runacunatam engañar llutanta yachatsirnin puriycan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero autoridäcunapita mantsacurmi, tsaynö pacayllapa parlayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tsay pullan fiesta päsaycaptinnam templuman Señor Jesucristo yaycusquir, runacunata yachatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tsaynö yachatsicunganta wiyarmi, autoridäcuna niyargan: “Maychöpis mana estudiashga caycarga ¿imanöpatan cay runaga alläpa allish yachan?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tsaynö niyaptinmi, Señor Jesucristo nirgan: “Nogaga caynö yachä cachamagnï Dios Yaya yachatsimashga captinmi, manam quiquilläpitatsu yachagpis cä. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pipis Dios Yaya munangannö cawarga, rasumpam musyanga cay yachatsicungäcuna Dios Yayapita o quiquïpa yarpaylläpita canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Waquincagcunaga runacunalla aläbayänanta munarmi, quiquincunapa yarpayllancunapita yachatsicur puriyan. Pero nogagam yachatsicü cachamagnï aläbamänanpag. Tsaymi Pay munangannö rasumpacagllata yachatsicü, chasquiyämaptin o mana chasquiyämaptinpis. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Gamcunam unay Moisés gellgangan leycunata chasquiyargayqui Dios Yaya munangannö cawayänayquipag. Pero tsay leycunataga manam ni maygayquillapis cäsuyargayquitsu. Tsaynö mana cäsuycarga ¿imanirtan nogata wañutsiyämayta munayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Goricashga runacunanam niyargan: “Gampa shongoyquichöga supaymi caycan. ¿Pitan wañutsishuyniquita munan?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Señor Jesucristonam nirgan: “Sabado jamay junagchö juc geshyagyasha runata cuticätsingäpitam mantsacashga caycäyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mä entendiyämay. Unay Moisés yachatsicungan leycunata cumplirmi, sabado jamay junagcaptinpis, ollgo wamrayquicunapa cuerpunchö señalatsiyanqui. Moisés tsaynö yachatsicuptinpis, tsayga shamurgan unay awiluntsic Abrahampa tiempunpitanam. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tsaynö Moiséspa leyninta cumplir jamay sabado junagchöpis, wamrayquicunapa cuerpunchö señalaycätsirga, ¿imanirtan piñacur rabiapäyämanqui sabado jamay junagchö geshyagyasha runapa entëru cuerpunta cuticätsingäpita? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Manarag allipa musyaycarga ama ricäyangayquillapitaga pitapis juzgayaytsu. Rasumpa pitapis juzgarga, imatapis alli musyar rasumpacagllata parlayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tsaynam Jerusalénchö täcug runacuna ninacuyargan: “¿Manacu cay runaga wañutsiyänanpag ashicäyangan? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Llapan runacunapa puntanchö parlaptinpis manatsag ima niyantsu. ¿Autoridäcunapis rasumpa Dios Yaya cachamungan Cristo cangantatsurag yarpäyan? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero nogantsicga Jesús may marcapita cangantapis musyantsicmi. Rasumpa Dios Yaya cachamungan Cristo shamuptinga, manam ni pipis musyanmantsu maypita shamungantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tsaynö niyanganta wiyasquirmi, templuchö yachatsicuycanganpita Señor Jesucristo jinchi nirgan: “Aumi, gamcunaga regeyämanquim y musyayanquim maypita shamungäta. Pero nogaga manam quiquïpa munaylläpitatsu cay patsaman shamushcä, sinöga cachamagnï Dios Yayapa mandädunta cumplirmi shamushcä. Dios Yaya rasumpacag captinmi, gamcunaga regeyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nogaga Dios Yayapita shamushga carmi regë, Pay cay patsaman cachamashga captin.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tsaynö niptinmi, autoridäcuna Señor Jesucristota prësu achcuyta munayargan. Pero manarag wañunan öra captinmi ni pipis achcurgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tsaynö nicäyaptinpis, atscagmi Señor Jesucristoman criyiyargan. Tsaymi llapan criyicug runacuna niyargan: “Rasumpa Dios Yaya cachamungan Cristo shamurga ¿cay runapita masragtsurag milagrucunata ruranga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tsaypitanam runacuna tsaynö parlapacuyanganta wiyasquir, sacerdöticunapa mandagnincunawan fariseocuna templu cuidag wardiacunata cachayargan Señor Jesucristota prësu achcuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Señor Jesucristonam nirgan: “Gamcunawanga juc ishcay junagllanam pagta cashun. Pero tsaypitaga cachamagnï Dios Yayamanmi cuticushag. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ashiyämarpis mananam tariyämanquitsu. Noga aywangämanga manam quiquillayquicunaga aywayta puediyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tsaynö niptinmi Israel runacuna ninacuyargan: “¿Nogantsic mana tarinapagga mayparag aywanga? ¿Juclä griegocunapa naciunninchö witsicashga marcamajintsiccunamantsurag o griegocunamantsurag yachatsicug aywanga? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ima ninantan ‘Ashiyämarpis manam tariyämanquitsu’ ninganga? ¿Imanirag Pay aywanganmanga aywayta puedishuntsu?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta ushacänan junagragmi alläpa jatun dia cargan. Tsay junagchömi Señor Jesucristo ichircur jinchi nirgan: “Mayganpis yacunarga nogaman criyicurnin, cawatsicug yacuta upyag shayämutsun. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pashtag pucyupita mana ushacaypa chuya yacu yargamungannömi, nogaman criyicugcunapa shongonchö Espïritu Santo imaypis caycanga. Tsaynö cananpagmi Diospa Palabran gellgashgachö cargan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tsaynö nirmi yachatsicurgan Payman criyicugcuna Espïritu Santota chasquiyänanpag canganta. Tsaymi paycunaga Espïritu Santota manarag chasquiyargantsu. Pero wañunganpita cawascamuptinmi sïga Señor Jesucristoman criyicugcagcuna Espïritu Santota chasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Señor Jesucristo tsaynö parlanganta wiyarmi, tsaychö waquincag runacuna niyargan: “Cayga unay Moisés gellgangannö willacug shamugpagcag Profëtam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquincagcunanam niyargan: “¡Payga Salvacug Cristom!” Pero waquincagnam niyargan: “Manam, Galilea runam cayga ¿imanöpatan Galileapitaga Cristo shamunman cargan? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diospa Palabran gellgashgachö ningannöga, unay rey Davidpa ayllunpitam Belen marcachö Cristoga yurinan cargan, Davidpis tsay marcapita captin.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tsaynö waquinga allita yarpar y waquincagnam mana allicunata yarpar, Señor Jesucristo janan raquicar ushacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Waquincagcunanam prësu achcuyta munayargan. Pero manam ni mayganpis achcuyta balurayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tsaypitanam templuchö wardiacuna mandayangan sacerdöticunapa mandagnincunawan fariseocuna caycäyanganman cutiyargan. Chäriyaptinnam tapuyargan: “¿Imanirtan tsay Jesústa prësu mana apayämurgoyquitsu?” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wardiacunanam contestayargan: “¡Manam ni pipis cay runa parlangannö ni imaypis yachatsicushgatsu!” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tsaynö niyaptinnam, fariseocuna niyargan: “¿Asta gamcunatapiscu engañar criyiscatsiyämushurgoyqui? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Acäsu tsay runamanga waquincag autoridänintsiccuna y fariseocunapis criyiyashgacu? ");
INSERT INTO qxnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Manam! ¡Pero tsay mana ima musyag runacunallam, leynintsiccunata mana musyar Paymanga criyiyan! ¡Tsay runacunaga alli castigashgam cayanga!” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Juccutim judiucunapa autoridänincunawan mandacug Nicodemo pagasllapa Señor Jesucristota ricagnin aywar nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Moisés yachatsicungan leynintsic ningannöpis, manam juc runata condenashwantsu jutsayog canganta o imatapis ruranganta manarag allipa wiyarnin musyarga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Paycunanam contestayargan: “¿Gampis Galileapitacu canqui? Masqui Diospa Palabran liyir yachacuy, manam ni maygan profëtapis Galileapitaga shamunanpag cangantaga willamantsictsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tsaynö nisquirnam cada ünu wajincunapa cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tsaypitanam Señor Jesucristoga olïvos niyangan jircaman aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Waränin alleg patsa warasquiptinnam templuman cutiycur, maytsicag runacunna goricasquiyaptin jamaycur yachtsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tsaymannam ley yachatsicugcunawan fariseocuna juc warmi ollgowan mana alli jutsata ruraycagta tarisquir apayämurnin, llapan runapa puntanman ichiycatsir, ");
INSERT INTO qxnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","niyargan: “Maestru, cay warmitam tariyargö juc ollgowan mana alli jutsata ruraycagta. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leynintsicchömi unay Moisés gellgar mandacurgan, lluta puricug warmitaga sagmarnin wañutsinapag. Pero gamga ¿imaninquitan tsaynö warmipag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Paycunaga tsaynö Señor Jesucristota tapuyargan llutan mana allita parlascatsir, “Mana alli yachatsicugmi” nir acusayänanpag. Pero tsaynö tapuyaptinmi Señor Jesucristo patsaman umpuycur allpachö dëdunwan gellgargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tsaypitanam yapay yapay tapuyaptin ichircur nirgan: “Mä maygayquipis mana juc jutsayogcag, cay warmita puntata sagmatsun.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsaynö nisquirnam, yapay umpuycurnin patsachö gellgar sïgirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Señor Jesucristo tsaynö ninganta tantiyasquirnam auquincunapita gallaycur asta jövencunapis jucpa jucpa yargornin aywacuyargan. Llapan aywacusquiyaptinnam, tsay warmillana Señor Jesucristopa puntanchö quëdasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tsaynam Señor Jesucristo ichircur warmita nirgan: “Warmi, ¿maytan shimpiyäshugniqui runacuna? ¿Manacu ni jucllagllapis condenashurgoyqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Warminam contestargan: “Señor, manam ni maygan.” Tsaynam Señor Jesucristo nirgan: “Tsaynöllam nogapis condenagtsu. Pero cananga wajiquiman aywacur, amana yapaywanga jutsata rurar purinquinatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tsaypitanam atscag runacuna goricäyaptin Señor Jesucristo yapay nirgan: “Nogaga cay patsachö actsinömi cä. Tsaymi nogaman criyicamur gatimag runacunaga mananam tutapaychönötsu puriyanga, sinöga imayca allish actsichönömi cawayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tsaynam fariseocuna niyargan: “Gamga quiquillayqui alli canayquipagmi tsaycunata parlanqui. Tsay ningayquiga manam rasumpatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Señor Jesucristonam contestargan: “Quiquilläpag imapata parlaptïpis noga willacungäga rasumpacagmi. Tsaymi nogaga musyä maypita shamungätawan maypa cutinäpagpis. Pero gamcunam sïga, ni maypita shamungätawan ni mayman cutinäpag cangantapis musyayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gamcunaga quiquiquicunapa yarpayllayquicunawanmi pitapis juzgayanqui. Pero nogaga manam ni pitapis jusgätsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero si noga pitapis juzgarga, rasumpacagllatam juzgashag. Nogaga manam quiquillätsu pitapis jusgä, sinöga cachamagnï Taytäwan ishcämi juzgayä. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Leyniquicunachömi gellgashga caycan, si ishcag testïgucuna iwallla parlayaptinga, tsay parlayangan rasumpa canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tsaynö captinmi, nogapis quiquïpag juc testïgu cä. Tsay juccag testïgunam cachamagnï Taytä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Fariseocunanam tapuyargan: “¿Maychötan Taytayqui caycan?” Señor Jesucristonam contestargan: “Gamcunaga manam nogata ni Taytätapis regeyanquitsu. Si nogata regeyämarga Taytätapis regeyämanquimanmi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Señor Jesucristoga templuchö yachatsicuycarmi caycunata parlargan, limushna goricuyänancagchö. Pero manam ni pipis prësu achcuyargantsu, manarag öran chämuptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tsaypitanam Señor Jesucristo yapay nirgan: “Aywacusquiptïmi ashirpis mana tariyämar jutsayquicunallachö wañuyanqui. Noga aywangämanga manam gamcunaga aywayta puediyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judiucunanam ninacuyargan: “¿Quiquillantsurag wañutsicuyta munaycan? ¿Imanirrag ‘noga aywangämanga manam aywayta puediyanquitsu’ nimantsic?” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Señor Jesucristonam nirgan: “Gamcunam cay patsapita cayanqui, pero nogaga janag patsa cielupitam shamushcä. Tsaynöllam gamcuna cay mundupita cayanqui, pero nogam sïga cay mundupitatsu cä. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsaymi gamcunataga jutsayquicunallachömi wañuyanqui niyashcag. Si gamcuna noga cangätawan Diospita shamungäta rasumpa mana criyirga, jutsayquicunallachömi wañuyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tsaynam tapuyargan: “¿Pitan gam canqui?” Señor Jesucristonam contestargan: “Gallananpita niyangagnöllam cä. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Gamcunata niyänagpagwan jutsayquicunata juzgayänagpagga atscallaragmi can. Pero tsay cachamagnïga imaypis rasumpacagllatam willacun. Tsaymi nogapis llapan runacunata willacü, cachamagnï parlanganta wiyangänölla.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero paycunaga manam ni juc entendiyargantsu Taytanpag parlaycanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tsaymi Señor Jesucristo nirgan: “Gamcuna altuman pallarcayämarmi rasumpa musyayanqui Diospita Shamushga Runata pï canganta. Nogaga manam quiquilläpitatsu imatapis parlar rurä, sinöga quiquin cachamagnï Taytä yachatsimanganllatam willacü. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tsay cachamagnïga nogawanmi pagtä imaypis caycan, manam japallätaga dëjamantsu. Nogaga Pay munangannöllam imaypis allicunallata ruraycä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tsaynö Señor Jesucristo yachatsicuptinmi, atscag runacuna payman criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tsaypitanam Payman criyicug judiucunata Señor Jesucristo nirgan: “Si gamcuna yachatsiyangagnölla rasumpa cäsucur cawarga, discïpulücunam cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tsaymi rasumpacagta regernin, jutsayquicunapita librina cushishga shumag cawacuyanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Paycunanam contestayargan: “Nogacunaga unay Abrahampa ayllun carmi, ni imaypis jucpa servigninga esclävuga cayashcätsu. ¿Imanirtan gamga ‘librinam cayanqui’ niyämanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Señor Jesucristonam nirgan: “Rasuncagtam niyag: Pipis jutsa rurayllachö cawarga, jutsapa servignin esclävunmi caycan. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juc servicug esclävuga manam ni imaypis, patronninpa ayllunga cangatsu. Pero wamranmi sïga imaypis paypa rasumpa ayllun canga. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tsaynöllam Dios Yayapa Tsurin perdonar librayäshuptiquiga, llapayquipis rasumpa libri Supaypa mana servigna cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Musyämi gamcuna unay Abrahampa ayllun cayangayquita. Pero paypa ayllun caycarpis, yachatsicungäta mana criyiyämarmi wañutsiyämayta munayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nogaga Taytäpa puntanchö ricangällatam parlar gamcunata willayag. Tsaynömi gamcunapis taytayquicuna mandayäshungayquillata imatapis rurayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Paycunanam niyargan: “Nogacunapa taytäcunaga unay Abrahammi.” Pero Señor Jesucristonam contestargan: “Si rasumpa gamcuna unay Abrahampa aylluncuna carga, pay allicunallata rurangannömi gamcunapis rurayanquiman. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero tsaynö caycaptinpis gamcunam sïga, Dios Yaya rasumpacagllata musyatsimanganta willacuptïpis wañutsiyämayta munayanqui. ¡Unay Abrahamga manam ni imay tsaynöga rurargantsu! ");
INSERT INTO qxnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gamcunaga imatapis rurayanqui taytayquicuna ruranganllatam.” Judiucunanam piñacur niyargan: “¡Nogacunaga manam wachapucushgatsu cayä, nogacunapa jucllayllam taytäcunaga quiquin Dios Yaya!” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Señor Jesucristonam contestargan: “Si rasumpa Dios Yaya taytayquicuna captinga, nogatapis cuyayämanquimanmi, Dios Yayapita shamushga caychö caycaptï. Nogaga manam quiquïpa munaylläpitatsu cay patsaman shamushcä, sinöga quiquin Dios Yayam cachamashga. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imanirtan yachatsicuynïta gamcuna mana entendiyanquitsu? Gamcuna palabrä yachatsicungäta manam wiyayta munayanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gamcunaga Supaypa cayaptiquim, pay taytayquicuna. Tsaymi pay munangallanta imatapis rurayta munayanqui. Supayga unaypitam runacunata wañutsirnin jutsata ruratsirgan. Tsaymi payga ni imaypis rasumpacagtaga parlantsu imaycatapis llullacurllam puriycan. Payga alläpa llullam rasumpa llullacuypa taytan car. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","¡Pero nogaga rasumpacagllata willayaptigmi, gamcunaga mana criyiyämanquitsu! ");
INSERT INTO qxnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Mä maygallayquipis shimpiyämay noga jutsayog cangäta? Rasuncagllata yachatsicur parlaycaptïga ¿imanirtan criyiyämanquitsu? ");
INSERT INTO qxnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios Yayapa runancunaga Diospa Alli Willacuynintam wiyarnin cäsuyan. Pero gamcunaga Dios Yayapa mana carmi, Palabranta yachatsicur willacungätapis chasquiyämanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tsaynam judiucuna niyargan: “Rasuncagllatam niyag: ¡Gamga Samaritäno runam canqui! ¡Gamga supayyog carmi, alläpana löcuyaycanqui!” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Señor Jesucristonam contestargan: “Manam nogachöga ni ima supaypis cantsu. Nogaga imatapis rurä Taytäta respetarnin cäsurmi. Pero gamcunaga mana respetarmi chiquiyämanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nogaga manam runacuna respetayämänanta munartsu willacur puriycä. Aunqui Taytäga runacuna respetayämänanta munaptinpis, mana respetayämanganpitam Taytäga juzganga. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rasuncagtam niyag: Llapan yachatsicungäcunata cäsurnin criyimagcunaga Dios Yayawanmi cieluchö imayyagpis cawayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judiucunanam contestayargan: “¡Cananmi sïga rasumpa musyayargö, supayyog cangayquita! Abrahamwan Dios Yayapa unay willacug profëtacunapis llapanmi wañuyargan. Pero gamga ‘yachatsicungäta criyicur cäsucugcunaga manam ni imaypis wañuyangatsu’ niyämanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Acaso gamga unay awilücuna Abrahampita mascu canqui? Paypis wañushgam y Dios Yayapa unay willacug profëtancunapis llapanmi wañuyashgalla. ¿Gamga pï cangayquitanatan yarpanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Señor Jesucristonam contestargan: “Si quiquilläpita aläbacuptïga, aläbacungäpis manam ni imapag välenmantsu. Pero nogata aläbamagnïga quiquin Taytämi, gamcuna tsay ‘Diosnï’ niyangayqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gamcunaga manam Taytä imanö canganta ni imata rurangantapis regeyanquitsu. Pero nogam sïga rasumpa regë. Si ‘manam regëtsu’ nirga, gamcunanöllam llullacur mana allicunata parlaycäman. Rasumpa Taytäta regermi Pay nimanganllata cumplirnin imatapis ruraycä. ");
INSERT INTO qxnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Unay aylluyquicuna Abrahampis alläpam cushicurgan cay patsaman shamunäpag cangan junagta musyasquir. Tsay musyangantanö ricaycurmi alläpa cushicurgan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judiucunanam Señor Jesucristota niyargan: “¡Gamga manaragmi pitsga chunca (50) watayogragtsu canqui! Pero ¿imanötan Abrahamta regë niyämanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Señor Jesucristonam contestargan: “Rasuncagtam niyag: ¡Manarag unay Abraham yuriptinmi, mas puntatana noga cä!” ");
INSERT INTO qxnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tsaynam rumita achcurcur sagmayta munayaptin, Señor Jesucristoga runacunapa rurinpa päsasquir, templupita aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tsaypa päsaycarnam Señor Jesucristo ricaycurgan, yuringanpitana juc gapra runata. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tsaynam discïpuluncuna tapuyargan: “Maestru, ¿imanirtan cay runaga gapra yurishga? ¿Taytancunapa jutsancunapitacu o quiquinpa jutsanpitacu?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Señor Jesucristonam nirgan: “Manam quiquinpa ni taytancunapa jutsanpitatsu gapra yurishga. Sinöga noga cuticätsiptï Dios Yaya poderöso canganta runacuna musyayänanpagmi tsaynö yurishga. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsaymi cay patsachö cangäyag cachamagnï Dios Yaya munanganta rurashwan, imayca juc runa junagpa trabajangannö. Pero tutapasquiptinmi sïga ni pipis trabajayannatsu mana ricayta puedir. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tsaymi nogaga cay patsachö cangäyagga, imayca actsinö llapan runacunapag caycä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tsaynö nisquirnam patsaman togaycurnin getäta rurasquir gaprapa ñawinta llushircurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tsaypitanam nirgan: “Canan ayway Siloé niyangan pösuman ñawiquita mayllacamunayquipag.” (Siloé ninanga “Cachamushga” ninanmi cargan.) Gapra runanam aywarnin mayllacascamur, ñawin allish ricarna cutiscamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tsaynö ñawin sänutana ricarmi, vecïnuncunawan limushnata mañacur canganta regegnincuna tapunacuyargan: “¿Cay runaga manacu imaypis jamaycur limushnata mañacug gapra?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquinnam niyargan: “Aumi, paymi cayga.” Waquinnam niyargan: “Manam paytsu, aunqui payricugcarpis.” Pero quiquinnam nirgan: “Aumi. Nogam cä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tsaynam tapuyargan: “¿Imanötan cananga ñawiqui allishna rican?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Paynam contestargan: “Tsay ‘Jesús’ niyangan runam patsaman togaycur getäta rurasquir ñawïman llushircamurgan. Tsaypitanam ‘Siloé’ niyangan pösuman ñawïta mayllanäpag mandamargan. Tsaychö ñawïta mayllascamurmi cananga allishna ricällä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsaypitanam tapuyargan: “¿Maychötan tsay runa caycan?” Paynam nirgan: “Manam musyätsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tsaypitanam tsay gapra canganpita cuticashga runata pushayargan fariseocunaman. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Señor Jesucristo tsay gapra runapa ñawinta cuticätsinanpag getäta rurangan junagga sabado jamay junagmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tsayman chaycatsiyaptinmi, imanöpa ñawin allishna ricanganta tapuyargan. Paynam contestargan: “Ñawïman getäta llushircamuptin mayllacusquirmi, cananga allishna ricä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Waquincag fariseocunanam niyargan: “Tsay cuticätsignin runaga manam Dios Yaya cachamungantsu. Tsaymi sabado jamay junagtapis respetantsu.” Pero waquincagnam niyargan: “¿Imanötan cayläya señal milagrutaga ruranman jutsasapa caycarga?” Tsaynö mana entendinacur llapan mana acuerdu carmi, quiquincuna pura raquicar, ");
INSERT INTO qxnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","unay gapra canganpita cuticashga runata yapay tapuyargan: “Gamga ¿pï cangantan yarpanqui tsay cuticätsishugniqui runapag?” Paynam contestargan: “Nogalläpagga Dios Yayapa profëtanami.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero judiucunaga manam criyiyta munayargantsu, gapra canganpita allishna ricanta. Tsaymi gapra canganpita cuticashga runapa taytantawan mamanta gayatsiyämur, ");
INSERT INTO qxnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tapuyargan: “¿Caycu gamcunapa wamrayquicuna? ¿Rasumpacu gapra yurirgan? ¿Imanöpatan canga allishna rican?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tsaynam mamanwan taytan contestayargan: “Aumi. Payga nogacunapa wamräcunam. Rasumpam yuringanpita gapra cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero manam musyayätsu imanöpa cuticanganta ni pï cuticätsingantapis. Payga yashga runanam. Quiquinta tapuyay rasuncagta willayäshunayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Taytanwan maman tsaynö niyargan judiucunapa autoridänicunapita mantsacurmi. Puntatam autoridäcuna willanacushga cayargan maygan runapis “Jesús Dios Yaya cachamungan Cristom” nigcagtaga Dios Yayaman mañacuyänanpag goricäyänan wajipita gargosquir manana ni imaypis consentiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tsayta mantsacurmi taytanwan mamanpis niyargan: “Payga yashga runanam. Quiquinta tapuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tsaynam gapra canganpita cuticashga runata judiucuna yapay gayascatsimur niyargan: “Rasumpacagta willayämay Dios Yaya ricaycäshunquim. Cuticätsishugniqui Dios Yayata alabayga. Nogacuna musyayämi tsay runaga jutsasapa canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Paynam contestargan: “Nogaga manam musyatsu jutsasapa o mana jutsannag cangantapis. Pero imatam sïga musyä gapra cangäpita, cananga cuticashga allina ricangäta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yapaynam tapuyargan: “¿Imatatan rurashurgoyqui? ¿Imanötan ñawiqui ricänanpag cuticätsishurgoyqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tsaynam contestargan: “¡Nogaga willayashcagnam, pero gamcunaga manam wiyayämanquitsu ni criyiyämanquitsu! ¿Imanirtan alläpa tapupäyämanqui yapay yapay wiyaytacu munayanqui? ¿Gamcunapis Paypa gatirag discïpulun caytacu munayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsaypitanam insultarnin niyargan: “¡Gammi tsay runapa gatiragninga canqui! ¡Pero nogacunaga unay Moiséspa gatiragninmi cayä! ");
INSERT INTO qxnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nogacunag musyayämi unay Moisésta quiquin Dios Yaya parlapanganta. Pero tsay runapagga manam ni pï canganta ni maypita shamungantapis musyayätsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tsay gapra canganpita cuticashga runanam contestargan: “¡Imanötan tsayga! Gamcunaga musyayanquitsu maypita shamungantapis, pero nogatam sïga ñawï allish ricänanpag cuticätsimashga. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Musyantsicmi jutsasapa runacunataga Dios Yaya mana wiyanganta. Pero Pay munanganllata rurar mañacurnin adorayaptinmi sïga, rasumpa wiyan. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manam ni pipagpis ni imaypis wiyashgatsu cantsic, yuringanpitana gapra runata cuticätsinganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si tsay runa Dios Yayapita mana shamushga carga, manam ni imata ruraytapis puedinmantsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tsaymi autoridäcuna niyargan: “¡Gamga yuringayquipitanam alläpa lluta jutsasapa canqui! ¿Jinapis nogacunatam yachatsiyämayta munanqui?” Tsaynö nirmi, Dios Yayaman mañacuyänanpag goricäyänan wajipita gargoyargan manana ni imaypis cutinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tsay cuticashga runata Dios Yayaman mañacuyänanpag goricäyänan wajipita gargoyangantam Señor Jesucristo musyasquirgan. Tsaynam runata ashirnin tarisquir tapurgan: “¿Gamga criyinquicu Diospita Shamushga Runaman?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Paynam nirgan: “Señor, ¿pitan tsay runa? Willaycamay payman firmi criyicunäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Señor Jesucristonam nirgan: “Gamga ricashcanquinam. Nogam rasumpa cä, gamwan parlaycag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tsaynam runaga Señor Jesucristopa puntanman gongorpacuycur adorarnin nirgan: “Señor, criyillämi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Señor Jesucristonam nirgan: “Nogam cay patsaman shamushcä llapan runacunapa jutsancunata juzganäpag. Tsaynöllam shamushcä gapracunata ricätsirnin, allish ricagtucugcunataga imay gapramannö ticrananpag, chucru shongo cayanganpita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Señor Jesucristo tsaynö ninganta wiyasquirnam, tsaychö waquincag fariseocuna niyargan: “¡Imanö! ¿Acäsu nogacunapis gapracu cayä?” ");
INSERT INTO qxnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Señor Jesucristonam contestargan: “Aumi, rasumpa gapranö carga manam jutsayquicunapita culpayogtsu cayanquiman. Pero ‘allish ricä’ nirmi, gamcunaga jutsayquicunapita rasumpa culpayog cayanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tsaypitanam Señor Jesucristo nirgan: “Rasuncagtagam pipis gencha puncupa mana yaycurnin, jucläpa lätar genchaman yaycugcagga alläpa mana alli rurag suwam. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero gencha puncupa yaycugcagmi sïga, üshacunata rasumpa mitsicug. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Genchata täpag runa puncuta quichasquiptin, mitsicug runa genchaman yaycusquir llapan üshacunata shutinllapa gayan. Tsaynö gayaptinmi rasumpa vozninta wiyar genchapita llapan yargayämun. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tsay genchapita wagtaman gargosquiptinnam, llapan üshancuna mitsigninpa gepanta gatirnin aywayan, ämunpa vozninta rasumpa regernin. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero mana rasumpa mitsignin canganta tantiyasquirmi sïga, vozninta mana reger geshpirnin jucläpa aywacuyan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tsaynömi Señor Jesucristo yachatsicurgan üshaman iwalatsicurnin. Pero tsaychö caycag runacunaga manam tantiyayargantsu ni imapag parlar yachatsicungantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tsaymi Señor Jesucristo yapay nirgan: “Caytaga rasumpacagtam niyag: Nogam üshacuna gaycuräyangan puncuga cä. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tsay nogapita mas puntata shamugcag runacunaga, llapanpis mana alli rurag suwam cayashga. Pero üshacunaga manam cäsuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nogam puncuga cä: Tsaymi pipis nogaman criyicurga genchaman üsha yaycungannö salvacashga cayanga. Tsay üsha alli gewata taringannömi, yaycur yargorpis mushog cawayta tariyanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwagam shamun suwarnin wañutsir ushacätsinanpag. Pero nogam sïga shamushcä llapan runacuna cay patsachö y janag patsachöpis allicag mushog cawayta tariyaptin cushishga atsca cayäpunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nogam rasumpa alli mitsicugga cä. Rasumpa alli mitsicugga, quiquinpa cawaynintapis perdenmanmi üshancuna jananga. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pägallapag mitsipucugcagmi sïga, atog shamuycagta ricasquirpis, üshacunata dëjasquir geshpirnin aywacun, mana rasumpa ämun car. Tsaynö jagesquiptinmi atog üshacunaman chaycur, wacpa caypa gaticachaptin geshpirnin witsicar aywacuyan. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tsaynö runaga geshpin pägayänanllapag yarpacurmi, manam üshacunapagga ni imapis gocuntsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nogam rasumpa alli mitsicugga cä. Tsaymi üshäcunata rasumpa regë y üshäcunanam nogatapis regeyäman. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tsaynöllam Taytä nogata regemangannö nogapis rasumpa regë. Tsaynöpam nogaga üshäcunaraycu jina wañushagpis. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tsaynöllam capaman cay genchapita juclächöpis üshäcuna, tsay üshäcunatapis cay genchamanmi llapanta gorimushag. Tsaynö maytsaypita goricascamuptï voznïta wiyar cäsuyämaptinmi, juc genchalla y juc mitsicuglla canga. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taytämi alläpa cuyaman llapan üshanö runacunaraycu wañuptïpis, cawaynï yapay garamänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Manam ni pipis cawaynïtaga gechumanmantsu, sinöga llapan runacunata cuyar quiquï munaptïmi chiquimagnïcunapis wañutsiyämanga. Puedïmi cawaynïta llapan runacunapag entregacuyta y wañusquir cawamuytapis. Rasumpa caynö cananpagmi Taytä mandamargan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judiucuna Señor Jesucristo tsaynö parlanganta wiyaycurnam yapay raquicäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tsaychö atscag caycagcunam niyargan: “¿Imanirtan cäsuyanqui supayyog car, löcuyäshga caycaptin?” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero waquincagnam niyargan: “Manam ni pipis shongonchö rasumpa supay captinga caynö parlanmantsu. ¿Acäsu juc supayga gapracunata cuticätsir allishcu ricätsinman?” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalén marcachönam tamya witsan, templuchö mana allicunata rurayanganpita limpiayangan fiestata ruraycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Templuchö caycarnam, Señor Jesucristo puriycargan Salomón ningan corredorchö. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tsaynam judiucuna Señor Jesucristota cunchawasquir tapuyargan: “¿Imayyagtan shuyarätsiyämanqui rasumpacagta willayämänayquipag? Dios Yaya cachamungan Cristo carga sas juclla willayämay.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Señor Jesucristonam contestargan: “Unaynam gamcunataga willayashcag. Pero gamcunaga manam criyiyämanquitsu. Tsaynöllam Taytäpa poderninwan llapan imayca milagrucuna rurangäta ricaycarpis criyiyämanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero gamcunaga manam criyiyämanquitsu, mana üshäcuna car. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Üshäcuna voznïta regeyämaptinmi, nogapis regë. Tsaymi paycunaga nogata gatiräyäman. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nogaga mana ushacag cawaytam llapan üshacunata garashag. Tsaymi ni imaypis asïpägga ogracarnin wañuyangatsu ni pipis gechumayta puedingatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taytä imayca üshacunatanö llapan criyicug runäcuna garamagga llapanpitapis mas poderösom. Tsaymi ni pipis Taytä cuidangantaga gechuyninta puedintsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taytäwan nogaga ishcäcunam juc persönalla cayä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tsaynö niptinnam judiucuna yapay rumita aptarcäriyargan Señor Jesucristota sagmayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero Señor Jesucristonam nirgan: “Taytäpa poderninwan allicunallata rurarmi, atsca cuti milagrucunata puntayquicunachö rurargö. ¿Maygan milagru rurangäpitatan sagmayta munayämanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judiucunanam contestayargan: “Manam milagrucunata rurangayquipitatsu sagmayta munayag. Sinöga quiquiquim Dios Yayapa contran mana allicunata parlaycanqui. Gamga juc runalla caycarmi, rasumpa ‘Diosmi cä’ nicanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Señor Jesucristonam nirgan: “Gamcunapa leyniquicunachömi gellgashga caycan: ‘Gamcunatam niyag, dioscunam cayanqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Musyantsicmi Diospa Palabran gellgashgachötaga. Manam nëgayta puedintsictsu, tsay runacunaman quiquinpa Palabranta willacur, quiquin Dios Yaya gamcunaga ‘dioscunam cayanqui’ ninganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Si quiquin Dios Yaya raquimarnï cay munduman cachamashga caycaptinga, ¿imanirtan yarpäyanqui ‘Diospa Tsurinmi cä’ niyangagwan Paypa contran parlangäta? ");
INSERT INTO qxnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si noga Taytä munangannö imaycatapis mana ruraptïga, manam criyiyämanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero Taytä munangannölla rurar willacuptï mana criyiyämarpis, milagrucuna rurangäta ricarllapis criyiyay. Tsaynö rurangäta ricarmi yachacurnin musyayanqui, Taytä nogachö rasumpa canganta y nogapis paywan juc persönalla caycangäta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tsaychömi yapay prësu achcuyta munayargan. Pero Señor Jesucristoga geshpipusquirnincunam aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tsaypitanam Señor Jesucristo Jordan mayupa wac tsimpanman cutisquir, tsay sitiuchö Juan Bautista mas puntatana runacunata bautizarganchö pärargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tsaymannam maytsicag runacuna ricagnin aywar niyargan: “Rasumpam Juan Bautistaga mana milagrucunata ruraycarpis, cay runapag llapan willacunganga rasuncaglla canag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tsaychö atscag runacunam Señor Jesucristo, Dios Yaya cachamungan salvacug canganta criyiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Juc runam Lazaro shutiyog alläpa antsa geshyaycargan Betania marcachö, Maríapawan Martapa turincuna. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tsay antsa geshyaycag Lazaropa panin Maríam Señor Jesucristopa chaquinman mushcug perfümita wiñarcur agtsanwan pitsar tsaquitsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaropa panincunam juc runata cachacuyargan Señor Jesucristota: “Señor, cuyay amïgoyquim antsa geshyaycan” ninanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tsayta wiyarmi Señor Jesucristo nirgan: “Tsay geshyaywanga manam wañungatsu. Tsay geshyayga tsarishga Dios Yaya poderöso cangantawan Tsurinpis rasumpa poderöso canganta musyayänanpagmi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aunqui Señor Jesucristo Lazarota y ishcan panincuna Maríatatawan Martata alläpa cuyaycarpis, ");
INSERT INTO qxnNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazaro alläpa antsa geshyaycangata willaycuyaptin, ishcay junag masran tsay caycanganllachö quëdargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsaypitaragmi discïpuluncunata nirgan: “Acu, yapay Judea provinciaman cutishun” nir. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Discïpuluncunanam niyargan: “Pero Maestru, tsay sitiucunachöga ganyancunallaragtsag judiucuna sagmar wañutsiyniquita munayargan ¿Tsaynö caycaptincu, gamga yapay tsaypa cutiyta munaycanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Señor Jesucristonam nirgan: “¿Juc junagga manacu chunca ishcay örayog? Tsaymi pipis junagpa purirga trompesar ishquintsictsu, cay mundu allish atsicyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero tutapaypa purirmi sïga, trompesarnin tacacur ishquin mana actsi captin.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yapaynam Señor Jesucristo nirgan: “Amïgontsic Lazarom puñucashga caycan, pero aywä riccharcatsimushag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Discïpuluncunanam niyargan: “Señor, si puñucashgalla caycarga, rasumpam cuticämunga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Señor Jesucristoga Lazaro wañushgana canganta musyarmi, discïpuluncunata tsaynö “puñucashgallam caycan” nirgan. Pero discïpuluncunaga mana tantiyayarmi, rasumpa puñucashgalla canganta yarpäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tsaynam Señor Jesucristo rasuncagta nirgan: “Lazaroga wañushgam. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Cushicümi tsaychö mana cangäta. Tsaynömi mas alli caycan gamcuna, rasumpa criyiyänayquipag. Pero acu aywashun ricänapag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tsaynam “Millïshu” niyangan Tomas discïpulumajincunata nirgan: “Acu nogantsicpis Señor Jesucristowan pagta wañuna captinpis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tsayman chaycunam Señor Jesucristo tarirgan, Lazarota pampayan chuscu junagna päsashga canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniaga cargan quimsa (3) kilometroschömi Jerusalénpita. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tsaynö amänolla captinmi, atscag judiucuna Maríapawan Martapa turin wañushga captin shogarnin compañag aywashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martanam Señor Jesucristo chaycanganta musyasquirnin tincug yargosquir aywargan. Pero ñañan Maríaga wajichömi quëdargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martanam tincusquir Señor Jesucristota nirgan: “Señor, caychö captiquiga turillä manam wañunmantsu cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero nogaga musyämi, cananpis llapan imayca mañangayquita Dios Yayaga rurananpagcagta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Señor Jesucristonam contestargan: “Turiquiga cawamungam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martanam nirgan: “Aumi, rasumpam musyä cay patsa ushacangan junag llapan wañushgacuna cawayämuptin, turilläpis cawamunanpag canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tsaynam Señor Jesucristo nirgan: “Nogam wañushgacunata cawatsimurnin cawayga cä. Tsaymi pipis nogaman rasumpa firmi criyicurga, wañurpis cawamungalla. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tsaynöllam llapan cawaycagcunapis, nogaman rasumpa firmi criyicamurga manam ni imaypis wañuyangatsu. ¿Cayta criyinqui Marta?” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Paynam nirgan: “Aumi, Señor. Nogaga rasumpam criyï gam Cristo Diospa Tsurin, cay munduman shamugpagcag cangayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tsaynö nisquirnam, Marta aywargan ñañan Maríata gayag. Gayasquirnam pacayllpa nirgan: “Maestrum cayman chamushga gayashunqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tsaynö niptinnam Maríaga saslla sharcurnin Señor Jesucristo caycanganman ricag aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Señor Jesucristoga manaragmi tsay marcamanga yaycushgaragtsu cargan, sinöga Martawan tincuyanganllachöragmi caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tsaynö María sas sharcurnin aywagta ricarmi, tsay judiucuna wajichö pagtan compañar caycagcuna gepanta gatir aywayargan, “Turin pamparanganmanchari wagag aywan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maríanam Señor Jesucristo caycanganman chaycurnin chaquin puntanman gongoricuycur nirgan: “Señor, si gam caychö captiquiga turillä manam wañunmantsu cargan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tsaynam Maríatawan compañagnin judiucuna llaquishga wagagta ricaycur, Señor Jesucristopis shongonchö yarpachacurnin alläpa llaquishga, ");
INSERT INTO qxnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","tapurgan: “¿Maymantan pampayashcanqui?” Tsaynam niyargan: “Señor, shamuy ricätsiyäshayqui” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tsaynam Señor Jesucristopis wagargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judiucunanam tsaynöta ricar niyargan: “¡Ricäyay alläpam cuyanag!” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero waquincagnam niyargan: “Manacu cay runaga gapratapis cuticatsirgan. Tsayga ¿manatsurag imallatapis ruranman cargan Lazaro mana wañunanpag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Señor Jesucristonam yapay alläpa llaquishga Lazaro pamparanganman witiycurgan. Tsay sepultüra gagachö uchcushga machay captinmi, puncunpis juc jatun parara rumiwan tsapashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Señor Jesucristonam nirgan: “Rumita jipiyay.” Tsay wañushga Lazaropa panin Martanam nirgan: “Pero Señor, cananyagga asyashganach chuscu junagnam wañungan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Señor Jesucristonam contestargan: “¿Manacu nirgog, si rasumpa firmi criyicurga Dios Yayapa poderninwan juc jatun milagruta ricäyänayquipag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Rumita jipisquiyaptinnam, Señor Jesucristo cieluman ricarcur nirgan: “Taytallay, alläpam agradëcicug, rasumpa wiyamangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Musyämi imaypis wiyamangayquita, pero caynöga mañacug caychö caycag runacuna, gam cachamangayquita rasumpa criyiyänanpagmi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tsayta nisquirnam, jinchi gayacurgan: “¡Lazaro, tsaypita yargamuy!” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsaynam wañushga yargascamurgan, maquinwan chaquin pitushga y gagllanpis alli wancupäcushga. Señor Jesucristonam nirgan: “Pascasquir, dëjayay aywacunanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tsaynö Lazarota cawatsinganta ricarmi, Maríata compañagnin aywashga judiucunapis atscag criyicuyargan, Dios Yaya Señor Jesucristota cay patsaman cachamunganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero waquincagnam fariseocunaman aywaycur willapäyargan wañunganpita Lazarota Señor Jesucristo cawatsimunganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tsayta musyasquirnam sacerdöticunapa mandagnincunawan fariseocuna y judiucunapa autoridänincunata gayascatsirnin secionta rurar niyargan: “¿Imatatan rurashun? ¡Tsay runaga tucuyläya milagrucunata rurarmi caycan! ");
INSERT INTO qxnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si dëjaycushgaga llapan runacunam payman criyiyanga. Tsaynam Romachö mandacug autoridäcuna shamuycur, templuntsictawan naciunnintsictapis jancat ushacätsiyanga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero jucnin sacerdöti llapan sacerdöticunata mandagnin Caifas shutiyog tsay watachö mas mandacuyyog carmi nirgan: “¡Gamcunaga manam ni imata musyayanquitsu, ");
INSERT INTO qxnNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni siquiera tantiyayanquillapistsu! Mas mejormi canman juc runalla wañuptin, cay llapan naciunnintsic jancat ushacanganpita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero Caifasga manam cayta quiquinpa yarpayllanpitatsu nirgan. Sinöga tsay wata mas mandacug sacerdöti carmi, Dios Yaya tantiyatsiptin parlargan llapan Judea naciunchö runacunaraycu Señor Jesucristo wañunanpag canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y manam tsay Judea naciunllapagtsu, sinöga Dios Yayaman llapan criyicug runacunata maytsay munduchö witsicashga caycagcunata jucllayllaman gorinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tsaynömi tsay junagpita judiucunapa autoridäcuna acueduta rurayargan, Señor Jesucristota wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tsaymi tsay junagpita Señor Jesucristo manana purirgantsu judiucuna ricänanchöga. Tsaynöpam Judea provinciapita yargosquir aywacurgan mana runacuna täcuyangan tsunya cercanchö Efrain niyangan marcaman. Tsaychömi discïpuluncunawan cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ichicllanam faltaycargan judiucunapa Pascua fiestancuna chämuptin, maytsay estanciacunapita maytsicag runacuna Jerusalénman aywar, Pascua fiestata celebrar jutsancunapita perdonta mañacur mayllacurnin cayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tsaynam Señor Jesucristota ashirnin purir, templuchö quiquincunapura tapunacuyargan: “Gamcunaga ¿imatatan yarpäyanqui? ¿Cay fiestaman shamungatsurag o manatsurag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pero fariseocunawan sacerdöticunapa mandagnincunam runacunata mandar niyargan: “Si pipis Jesústa maychöpis ricarga, saslla willayämanqui prësu achcusquir apayämunäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiestapag sogta junagllana faltaycaptinmi, Señor Jesucristo Betania marcaman aywargan. Tsay marcachömi wañunganpita cawatsimungan Lazaro täcurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tsayman Señor Jesucristo chaycuptin cushicuypitam, alli micuycunata cocinapacuyargan llapan invitäduncunawan micupacuyänanpag. Tsayman Marta servicuptin turin Lazaropis mësachö jamagcunawan pagta micuycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tsaynö llapan micupacuycäyaptinnam, Maríaga alläpa chaniyog juc frascu perfüminwan witiycurgan. Tsay perfümiga nardo ninganpita pürum cargan. Tsaypitanam Señor Jesucristopa chaquinman wiñarcur agtsanwan pitsar tsaquitsirgan. Tsay perfümiga, waji juntam alläpa shumag mushcurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pero tsayta ricaycurmi Señor Jesucristota traicionarnin chiquignincunaman entregananpagcag discïpulun Judás Iscariote piñacur nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imanirtan cay perfümita mana ranticurgontsictsu, juc wata mas aruypa chanin gellaywan wactsacunata yanapanapag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero Judásga manam wactsacunata rasumpa yanapananpag yarpartsu nirgan. Sinöga discïpulumajincunawan churarnin goricuyangan gellayta tsarag car, quiquin suwacur buyllücunanraycum. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Señor Jesucristonam nirgan: “Dëjaycuy, cay perfümitaga churarätsishga pampayämänam junagpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wactsacunaga imayyagpis pagtayquicunam caycäyanga. Pero nogam sïga gamcunawan pagtaga cashagnatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tsaynam Betaniachö Señor Jesucristo caycanganta judiucuna musyasquir, ricagnin aywayargan. Manam Señor Jesucristota ricagllatsu aywayargan, sinöga wañushgapita cawatsimungan Lazarotapis ricagmi aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tsaychönam sacerdöticunapa mandagnincuna, Lazarotapis wañutsiyänanpag acuerduta rurayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lazarota cawatsimunganpitam atscag judiucuna Señor Jesucristoman rasumpa criyicurnin, autoridäcunapita raquicäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Maytsicag runacunam Jerusalénchö Pascua fiestaman aywashga cargan. Tsay waränin allegnam musyasquiyargan, Señor Jesucristopis tsay fiestaman shamuycanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tsaynam palmerapa rämanta wallusquir aptarcurnin, Señor Jesucristota tincugnin gayaycachar aywarnin niyargan: “¡Canan salvaycayällämay! ¡Alläpa cushicuypagmi Dios Yayapa shutinchö Shamug Runa, lsraelcunapa mandacug reynin!” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Señor Jesucristoga juc mallwa ashnuta tarisquirmi montarcur, Jerusalénman yaycurgan Diospa Palabran gellgashgachö ningannömi cargan: ");
INSERT INTO qxnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ama mantsacaytsu Sión Marca. Ricay mallwa ashnun montashga, Reyniquicuna shamuycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Señor Jesucristo Jerusalénman ashnun montashga yacuptinmi, discïpuluncunaga tantiyayargantsu ni imapag tsaynö ruraycangantapis. Wañunganpita cawascamur cieluman aywacuptinragmi, rasumpa musyayargan Señor Jesucristo rurangancuna Diospa Palabran gellgashgachö Paypag rasumpa canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pero maytsicag runacuna Señor Jesucristopa pagtan aywarmi, Lazarota gayarnin cawatsimunganta ricashga car, llapan ricäyanganta parlapacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tsaymi maytsicag alläpa cushishga Señor Jesucristota tincugnin shayämurgan, milagru ruranganta musyashga car. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero fariseocunanam quiquincuna pura jucnin jucnin ninacuyargan: “Gamcuna ricäyangayquinöpis, tsaynöga manam ni imanayta puedishuntsu. Ricäyay ¡llapan runacunanam gatirnin paywan pagta aywayan!” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalénchö Pascua fiestaman Dios Yayata adorag maytsay naciuncunapita shayämugcunawanmi, Grecia naciunpita runacunapis caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paycunam Galilea provinciachö Betsaida marcapita Felipeman aywaycur rugarnin niyargan: “Señor, tsay Jesústam regeyta munayä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipenam Andrésta willargan. Tsaynam ishcan Señor Jesucristota willagnin aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tsaynam Señor Jesucristo nirgan: “Öra chämushganam maytsay naciunchö runacuna Diospa Tsurin poderöso cangäta musyayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rasuncagtam niyag: Si juc trïgu allpaman shicwar mana wañurga, imaypis juc gränullam canga. Pero allpaman pampasquishga wañusquirnin jegamurmi sïga, alläpa atsca cosëchata wayun. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Si pipis cay patsachö cawayllanta alläpa cuyarga, imaypis ograngam. Pero cawayninta mana alläpa llaquirnin Dios Yaya munangannö cawagcagmi sïga, mana ushacag caway gloriapag catsinga. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Si mayganpis servimayta munarga, rasumpa gatirämantsun; noga maychöpis cangächömi tsay servimar gatirämagnïpis canga. Si maygallanpis servimaptinga quiquin Taytämi cushishga aläbanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“¡Cananmi alläpa mantsacaypag llaquicuy tsariman! ¿Imanishagrag? ¿Nishagchi: Taytay, cay alläpa mantsacaypa llaquicuypita libraycamay? ¡Pero nogaga caynö päsamänanpagmi cay patsaman shamushcä! ");
INSERT INTO qxnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","¡Taytay, poderöso cuyay respetashga shutiquita musyatsicuy!” Tsaynam cielupita juc voz caynö nimugta wiyayargan: “Llapan runacunatanam musyatsicushcä, pero cananmi yapay musyatsicushag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tsaychö caycag runacuna wiyarmi: “Magacamushgam nipacuyargan.” Pero waquincagnam: “Juc poderöso angelmi parlapämushga” niryargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tsaynam Señor Jesucristo nirgan: “Manam nogapagtsu tsay voz wiyayangayqui, mas bien gamcunapagmi tsaytaga wiyayargoyqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Canan öram cay munduchö llapan runacuna juzgashga cayanga. Tsaynöllam cay munduchö imayca mana allita mandacur ruratsicug Supaypis gargoshga canga. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero cruzman clävarnin wañuscatsir pampayämangapita sharcamurmi, entëru munduchö llapan runacuna nogaman criyicuyänanpag gorimushag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Caycunawanmi entenditsicurgan Señor Jesucristo imanö wañunanpaga canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tsaynam runacuna contestayargan: “Leynintsicmi musyatsimantsic, Diospita Shamushga Cristoga imayyagpis cawananpag canganta. Pero tsayga ¿imanötan gamga altupa pallarirmi cruzchö wañutsiyämanga ninqui? Tsaypungan ¿Maytan Diospita Shamushga Runaga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Señor Jesucristonam nirgan: “Gamcunachöllaragmi tsay actsiga caycanga; pero pöcu tiempullanam canga. Ayway gamcunachö tsay actsi canganyag, tutapay mana achcuyäshunayquipag. Tutapaychö purigcagga manam musyantsu ni maypa aywangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Rasumpa criyicuyay tsay actsi gamcunachö canganyag. Tsaynöpa imayca actsichönö cushishga shumag cawacuyänayquipag.” Tsaycuna llapanta parlasquirnam, Señor Jesucristoga paycunapita tsincarnin aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Señor Jesucristo llapanpa puntancunachö tucuyläya milagrucuna ruranganta ricaycarpis, criyiyta manam munayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tsaynömi cumplinan cargan Dios Yayapa unay profëtan Isaías gellganganchö: “Señor, ¿pitan criyishga willacuynintsicta? ¿Pitatan Dios Yaya poderninta regetsishga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tsaynö criyiyta mana puediyänanpagmi, unay profëta Isaíasga masta gellgargan: ");
INSERT INTO qxnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dios Yayam ñawincunata wichgashga, mas chucru shongoman ticratsir, yarpaynincunatapis mana musyag upaman ticratsishga. Mana ricayta puedirnin, ni imatapis mana entendiyänanpag. Nogaman manana cutiyämunanpag, ni nogapis paycunata manana cuticätsinäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaíasmi tsaynö nirgan, Señor Jesucristo alläpa shumag poderöso canganta ricashga car, Paypag parlarnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tsaynö caycaptinpis maytsicag judiucunam Señor Jesucristoman criyicuyargan. Tsaynöllam waquincag mas importanti mandacug runacunapis chasquirnin criyiyargan. Pero manam llapan runacunapa puntanchöga criyicuyangata parlayargantsu, fariseocunapa autoridänincuna Dios Yayaman mañacuyänanpag goricäyänan wajipita, mana mas cutinanpag gargoyänanta mantsacur. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Judiucunaga runacuna aläbayänantam mas munayargan, Dios Yaya aläbanantaga manam valorayargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tsaynam Señor Jesucristo jinchicuycur nirgan: “Si nogaman rasumpa criyicurga manam nogallamantsu criyicuyan, sinöga cachamagnï Taytämanpismi. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nogata ricarnin regemar chasquimagcagga cachamagï, Taytätapismi regernin chasquin. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cay mundupag imayca actsinö carmi, nogaga cay patsaman shamushcä llapan runacuna mana tutapaychönö cayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero pipis nogapa yachatsicuynïta wiyaycar mana cäsucuptinga, manam nogatsu tsay runata juzgarnin condenashag. Nogaga manam cay patsaman shamushcä runacunata juzgarnin condenagtsu, sinöga llapan runacunata salvanäpagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Si pipis nogata despreciamar willacuynïta mana casucug runapaga, juc condenagninmi can. Tsay llapan yachatsicuynïcunallam tsay runataga condenanga cay patsa ushacan junagchö. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nogaga manam quiquïpa munaylläpitatsu yachatsicü, sinöga cachamagnï Taytämi mandamashga imatapis Pay munangannölla willacurnin imanö yachatsicunäpagpis. ");
INSERT INTO qxnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nogam rasumpa musyä, Taytäpa mandacuyninga mana ushacag cawayta tariyänanpag canganta. Tsaymi nogaga imatapis parlarnin willacü, Taytä mandamanganllata.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua fiestapag juc junagllana faltaycaptinmi, Señor Jesucristoga musyarganna cay patsata dëjasquir Taytanwan pagta cananpag cuticunan canganta. Payga payman llapan criyicugcunatam alläpa cuyarnin, asta ushacanganyagpis tsaynölla cuyanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Meriendata micuyänanpagmi traicionarnin ranticunanpag Supayga Simón Iscariotepa tsurin Judástapa shongonman yaycushgana cargan, tsay pagas Señor Jesucristota chiquignincunaman entregananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Señor Jesucristoga musyarganmi Taytan llapan poderninta entregashga captin, Paypita shamungantawan Payllaman cutinanpag cangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tsaynam mësachö meriendar jamaycanganpita sharcur, mantunta llushtisquir tsegllanman towällata watargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tsaypitanam juc tïnaman yacuta wiñarcur, discïpuluncunapa chaquinta mayllasquir, tsegllanman watangan towällawan tsaquitsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaquinta mayllananpag caycaptinnam, Simón Pedro nirgan: “Señor, ¿gamcu nogapa chaquïta mayllamunqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Señor Jesucristonam nirgan: “Cananga manam entendinquitsu caynö ruraycangäta, pero tsaypitam sïga entendinqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Simón Pedronam nirgan: “Manam ni imaypis chaquïta mayllamunayquitaga dëjashayquitsu.” Señor Jesucristonam nirgan: “Si chaquiquita mana mayllamuptïga, manam nogapa cayta puedinquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedronam nirgan: “¡Señor, tsaypunga ama chaquillätaga mayllamuytsu, sinöga maquïtawan umätapis mayllascallämuy!” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Señor Jesucristonam contestargan: “Tsayrag armacushga caycagcunaga, chaquinllatanam mayllayta wanan, llapan cerpun limpiu captin. Tsaymi gamcunaga limpiu caycäyanqui, jucniqui mana limpiu carpis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesúsga tsaynö nirgan: “Manam llapayquitsu limpiu caycäyanqui” nir, juccag discïpulun traicionarnin ranticunanpag canganta musyar. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Llapanpa chaquincunata mayllar ushasquirnam, llushtingan mantunta shucucurcur yapay jamaycur nirgan: “¿Gamcunaga entendiyanquicu imata rurangäta? ");
INSERT INTO qxnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gamcunaga ‘Maestru’ y ‘Señor’ rasuncagtam niyämangayqui, rasumpa niyangayquinöllam cä. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tsaymi si noga Maestru y Señor caycarpis cuyayarniqui chaquiquicunata mayllamurgö; tsaynölla gamcunapis jucniqui jucniquipa chaquiquicunata mayllapunacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Juc ejempluwanmi yachatsiyargog, gamcunapis noga rurangänölla rurayänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rasuncagtan niyag: Manam ni mayga servicugpis patronninpita masga canmantsu. Tsaynöllam maygan mandashgapis mandagninpita masga canmantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Si caycunata entendir rasumpa cumplirgan, alläpa cushishgam cawacuyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Manam llapayquicunapagtsu nogaga parlaycä; musyämi picunata noga rasumpa acrangäta. Pero rasumpam cumplinga Diospa Palabran gellgashgachö ningan: ‘Nogawan pagta micuycag runam, conträ ticrashga.’ ");
INSERT INTO qxnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Caytam canan gamcuna rasumpa tantiyayänayquipay niyag, llapan caycuna päsasquiptin noga rasumpacag quiquï cangäta musyayänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rasuncagtam niyag: Si pipis noga mandangäta chasquirga, nogatapis rasumpam chasquiyäman. Noga chasquimarga mandamagnïtapis rasumpam chasquiyan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tsaycunata parlar ushasquirnam, Señor Jesucristo shongonchö alläpa llaquicurnin yarpachacur yapay nirgan: “Rasuncagtam niyag: Gamcunachö caycagpita jucniquim traicionayämanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tsaynam discïpuluncuna quiquincuna pura ricaränacuyargan ni mayganpag parlaycanganta mana musyarnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tsaychönam Señor Jesucristo cuyangancag discïpulunpis, lädunchö meriendarnin jamaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedronam señasllapa nirgan, pipag parlaycanganta tapunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Paynam Señor Jesucristoman mas witiycur tapurgan: “Señor, ¿Maygantan tsay traicionashugniquiga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Señor Jesucristonam contestargan: “Tantata tullpurcur garangäcagmi, tsay traicionamagnï runaga.” Tsaynö nisquirnam tantata tullpurcur Simón Iscariotepa tsurin Judásta garargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tsay tantata chasquingan öram, Judáspa shongonman Supay yaycurgan. Tsaymi Señor Jesucristo Judásta nirgan: “Ruranayquipag yarpangayquita sas ruray.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero manam ni mayganpis mësachö meriendar jamaycagcunaga ni jucta entendiyargantsu ni imapag tsaynö ningantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Discïpulumajincunawan goriyangan gellayta tsarag captinmi, waquincagga yarpäyargan fiestapag imallatapis rantipacamug Judásta mandanganta. Y waquincagcunanam yarpäyargan wactsacunata yanapananpag mandanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tsaynö tantata chasquisquirnin micur ushasquirmi, jina öra aywacurgan. Tsay öraga patsapis tutapashganam cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tsaypita Judás aywasquiptinnam Señor Jesucristo nirgan: “Cananmi Diospa Tsurin poderöso cangantawan Dios Yayapis rasumpa poderöso caynïta Paychö musyatsicunga. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tsaynö Diospa Tsurin rasumpa poderöso Dios Yaya canganta musyatsicuptinmi, Dios Yayapis Paychö sasllana ricätsicur musyatsicunga. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ïjulläcuna, mananam gamcunawanga unaynatsu caycäshag. Gamcunam ashiyämanqui, pero judiucunata ningänöllam canan gamcunatapis niyag: ‘Noga aywangämanga manam aywayta puediyanquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Cay mushogcag mandamientutam entregayag: Jucnin jucninwan shumag cuyanacuyänayquipag. Gamcunata cuyayangagnölla jucnin jucninwanpis shumag cuyanacuyay. ");
INSERT INTO qxnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si tsay niyangagnölla jucnin jucninwanpis shumag cuyanacuyaptiquim, llapan runacunapis musyayanga rasumpa discïpulü cayangayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedronam Señor Jesucristota tapurgan: “Señor, ¿maypatan aywanqui?” Señor Jesucristonam contestargan: “Noga aywangämanga manam gatimayta puedinquitsu. Pero tsaypitam sïga noga gatimanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedronam nirgan: “Señor, ¿imanirtan cananga mana gatïniquita puedïtsu? ¡Gamraycuga jinam wañunäpagpis listo caycä!” ");
INSERT INTO qxnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Señor Jesucristonam nirgan: “¿Rasumpacu nogaraycu wañunayquipagpis listo caycanqui? Rasuncagtam nig: Manarag gällu cantaptinmi, quimsa cuti nëgamanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ama gamcunaga mantsacashga yarpachacuyaytsu. Tsaypa rantin Dios Yayallaman mas firmi criyicurnin confiacuyay. Tsaynölla nogamanpis rasumpa criyicur confiacayämuy. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taytä täcungan wajichöga atsca sitiucunam can allish täcunapag. Si tsaynö mana captinga, imanörag alistag aywashag gamcuna shayämunayquipag niyagman cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tsaynö aywasquir alistascamurnam gamcunata pushayänagpag cutimushag. Tsaymi noga täcungächö gamcunawanpis pagta shumag cushishga täcushun. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gamcunaga musyayanquim ima näni, noga aywangäman chätsiyäshunayquipag canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasnam Señor Jesucristota nirgan: “Señor, manam musyayätsu ni maypa aywangayquitapis. Tsayga ¿imanötan musyayäshag maygan näni cangantapis?” ");
INSERT INTO qxnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Señor Jesucristonam contestargan: “Nogam tsay näniga, rasumpacagga y cawayga cä. Tsaymi nogallawan quiquin Tayta Diosmanga chayta puediyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si gamcunata nogata regeyämarga, Taytätapis rasumpam regeyanqui. Tsaymi cananpitaga gamcuna rasumpa regeyanquina quiquiquicunapa ñawiquicunawan ricashga car.” ");
INSERT INTO qxnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tsaynam Felipe nirgan: “Señor, quiquin Tayta Diosta regeycatsillämay, regeycurmi sïga rasumpa nogapis regeyäshag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Señor Jesucristonam contestargan: “Felipe, unaynam gamcunawan pagta caycä, ¿manaragcu cananyag regemanqui? Nogata ricämagcagga Tayta Diostapis ricanmi. ¿Imanirtan mañamanqui quiquin Tayta Diosta ricätsinagpag? ");
INSERT INTO qxnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manacu criyinqui noga Tayta Dioschö caycangäta y Tayta Diospis nogachö caycanganta? Tsay imatapis parlangäcunataga manam quiquïpa munaylläpitsu parlä, sinöga nogachö Tayta Dios caycagmi llapan imaycatapis rurarnin trabajan. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Criyimay Tayta Dioschö caycanganta y Tayta Diospis nogachö caycanganta. Sinöga criyiyay llapan imayca milagrucuna rurangäcunata ricarllapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Rasuncagtam niyag: Si nogaman rasumpa criyicurga, llapan imayca rurangäcunatam rurayanga. Tsay llapan rurangäcunapitapis mas imaycatam rurayanga, Tayta Diosman noga aywasquir yanapamuptï. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Gamcuna llapan imaycatapis shutïchö mañacuyangayquitam rurashag, Diospa Tsurin car, Taytä poderöso canganta musyatsicunäpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nogaman criyicamur shutïchö mañacayämaptiquiga, llapan imaycatam yanapayarniqui rurashag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Si gamcuna rasumpa criyirnin cuyayämarga, llapan mandacungäcunata cäsurnin cumpliyay. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tsaynö cawayänayquipagmi Tayta Diosman mañacushag, rasumpacag Espïritu Santota gamcunaman cachamuptin, defendir imaycachöpis yachayninwan yanapayäshurniqui gamcunawan pagta imayyagpis cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Cay mundupa mana alli ruraynincunallachö cawag runacunaga, mana ricarnin mana regermi Espïritu Santota chasquiyta puediyantsu. Pero gamcunam sïga rasumpa regeyanqui, Pay gamcunawan pagta cawaptin. Tsaymi Espïritu Santoga gamcunachö imayyagpis pagtayquicuna canga. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Manam imayca taytannagtanö y mamannagtanö japallayquicunataga dëjayäshayquitsu. Yapaymi cutimushagmi gamcunawan pagta cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ichicllanam faltan cay mundupa munayllanchö cawagcunaga manana ricäyämänanpag. Pero gamcunam sïga nogata ricäyämar, rasumpa cawangäpita gamcunapis cawayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tsay junagmi musyayanqui, Tayta Dios nogachö jucllayllanö caycanganta y gamcuna nogachö y noga gamcunachöpis jucllayllanö caycangäta. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yachatsicungäcunata cäsurnin llapan mandamientüta cumplirga, rasumpa criyicurmi cuyayäman. Tsay cuyamagcunataga Taytämi cuyarnin imaycachöpis yanapanga. Tsaynöllam nogapis tsay cuyamagcunataga, cuyarnin imanö cangäta musyatsishag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mana Iscariotecag Judásmi Señor Jesucristota tapurgan: “Señor, ¿imanirtan nogacunallata poderöso cangayquita musyatsiyämanqui, cay mundupa munayllanta rurag runacunatapis mana musyatsirga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Señor Jesucristonam contestargan: “Nogata criyimar rasumpa cuyamagcagga, llapan palabräta cäsucurmi cumplin. Tsaymi Taytä alläpa yanapar cuyamaptin, ishcä shayämushag tsay runawan pagta cawayänäpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Si nogata mana cuyayämarga manam llapan willacungätapis cäsuyantsu. Cay llapan willacungäcuna wiyaycäyangayquiga manam quiquïpa yarpaylläpitatsu, sinöga cachamagnï Taytä nimangallanmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Caycuna llapantam willayag gamcunawan caycarllarag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero yachayninwan yanapayagniqui Espïritu Santota shutïchö Dios Yaya mandamungannam, llapan imaycatapis yachatsiyäshunqui. Tsaynöllam llapan noga willar yachatsiyangagta yarpätsiyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Gamcunapita aywacurmi dëjapuyag, alläpa cushishga alli päsacuychö cawayänayquipag. Gamcunatam yanapayäshayqui alli päsacuychö cawayänayquipag. Pero manam yanapayäshayquiga cay mundupa munayllanchö cawagcunanötsu. Ama gamcunaga llaquishga cayaytsu ni mantsacäyaytsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Wiyayämargoyquinam aywacungäpita cutiscamur gamcunawan pagta cawanapag canganta. Si rasumpa cuyayämarga alläpam cushicuyanquiman cargan, Taytä caycanganman cutimunäpagcagta musyasquir, Payga nogapita mas Poderöso captin. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Caycunatam willayag manarag päsaptin, caynö llapan päsaptin gamcuna nogaman rasumpa criyiyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Caypita mastaga mananam parlapäyäshayquinatsu, cay munduta munayninwan mandag Satanasmi shamuycanna. Paypaga manam ni ima podernïpis cantsu nogapagga. ");
INSERT INTO qxnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero tsaynö caycaptinpis llapan runacunam musyayanga Dios Yayata alläpa cuyarnin, Pay mandamangannölla llapan imaycatapis cumplingäta. Shäriyay, canan caypita aywacushun.” ");
INSERT INTO qxnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tsaypitanam Señor Jesucristo yapay nirgan: “Nogam rasumpacag üvaga cä y Taytänam cuidagninga. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Si juccag rämä mana wayuptinga wallusquirmi jitasquin, pero si juccag rämä alli wayuptinmi sïga, shumag limpiarnin llaumipar cuidan mas atscata wayunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamcunaga limpiunam cayanqui, Dios Yayapa Palabran yachatsiyangagta chasquirnin, jutsayquicunapita perdonashgana car. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Imaypis nogawan jucllayllanö mana raquicarnin quëdayay, nogapis gamcunapita ni imay mana raquicar quëdangänö. Juc räma yuranpita camantsacasquirga manam quiquillan üvata wayuyta puedintsu. Tsaynöllam gamcunapis nogawan mana pagta imaypis quëdarga, imayca üva wayugnö ni ima rurayangayquipis masga mirangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nogam rasumpacag üvaga cä y gamcunanam rämäcuna cayanqui. Pipis nogawan pagta imaypis cawarnin quëdarga y noga paywan pagta quëdarga, imayca allish wayug üvanömi mas miratsiyäshag. Tsaynö nogawan pagta mana quëdarninga, manam ni imatapis quiquillayquicunaga rurayta puediyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Si pipis nogawan pagta imaypis mana quëdarga, yuranpita wallusquir tsaquinanpag jitaringanta gorisquir ninawan waycaypagmi cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Si gamcuna nogachö jucllayllanö quëdarnir cawarga, llapan Palabräcuna yachatsiyangagta cumpliyaptiquim, llapan imayca mañayämangayquitapis chasquiyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Taytä poderöso cangantam llapan runacuna aläbayan, gamcuna imayca alli wayugnö Paypa Alli Willacuyninta mas miratsiyaptiqui. Tsaynöpam gamcunaga nogapa rasumpacag discïpulücuna cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Gamcunatam alläpa cuyayag, Taytä cuyamangannölla. Tsaynöpam imaypis gamcunaga nogapa cuyacuynïchö quëdayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si nogapa llapan mandamientuta cäsurnin cumplirga, imaypis nogapa cuyaycuynïchömi quëdarnin caycäyanqui. Tsaynöllam nogapis Taytäpa mandamientunta cäsurnin cumplir, imaypis Paypa cuyacuyninchö quëdarnin cawaycä. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Tsaynömi willayag nogawan cushishga cayänayquipag y rasumpa cushishga imayyagpis cawacuyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nogapa mandamientüga caymi: Jucnin jucninwanpis shumag cuyanacurnin cawacuyänayquipag, noga gamcunata alläpa cuyayangagnölla. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Caypita masga manam cantsu, rasumpa cuyacuyga: Alläpa cuyarnin amïgonpa janan wañunanpagpis listo cayga. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Llapan mandacungäcunata cäsucurnin cumplirmi, gamcunapis rasumpa cuyay amïgöcuna cayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gamcunaga mananam servignïllatsu cayanqui, juc servicugga manam musyantsu patronnin ni imata rurangantapis. Pero nogaga alläpa cuyay amïgöcunam cayanqui niyag, Taytäpita llapan yachacungäta musyatsishga cayarniquim. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Manam gamcunatsu nogata acrayämargayqui, sinöga nogam gamcunata acrayarniqui encargayashcag, maytsaypa aywar Alli Willacuynïta imay allish wayugnö mas miratsiyaptiqui, imayyagpis mana ushacag cananpag. Tsaynöllam nogapa shutïchö llapan imayca mañayangayquitapis, Tayta Dios garayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Caycunatam gamcunata mandayag: Jucnin jucninwanpis shumag cuyanacur alli päsacuyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Si cay mundupa munayllanchö cawagcuna chiyäshuptiqui, yarpäyay mas puntata nogata chiquiyämanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si gamcunacush cay mundupa munayllanta rurayanquiman, tsay mana alli rurag runacunapis cuyayäshunquimanmi quiquincunapuralla cuyanacuyangannö. Pero nogam gamcunata acrayashcag cay mundupa munayllanchö caycagcunapita. Tsaymi cay mundupa munayllanta rurag runacuna gamcunatapis chiquiyäshunqui, gamcunaga manana cay mundupa munayllanta rurag cayaptiqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yarpäyay puntatana caynö niyangagta: Manam ni maygan servicugpis, patronninpita masga canamantsu. Si nogata gaticachaycäyämarga, gamcunatapis gaticachäyäshunquim. Si nogapa Alli Willacuynïta cäsucurga, gamcuna yachatsicur willacuyangayquitapis cäsucur cumpliyangam. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tsaynö tucuyläya imaycatam rurayäshunqui nogaraycu, tsay runacunaga manam regeyantsu ni pï mandamangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Paycunaga manam ni juc culpayogtsu cayanman cargan, si noga willagnincuna mana shamuptïga. Pero cananga llapan willacungäta wiyashga carmi, jutsa rurayanganpita mana disculpashga car castigashga cayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pipis nogata chiquimarga, Taytätapis chiquinmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Manam culpayogtsu cayanman cargan, si noga paycunapa ricänanchö ni pï rurangan milagrucunata rurashga captïga. Pero paycunaga llapan milagru rurangäcunata ricashga caycarpis, nogata chiquiyämarmi Taytätapis chiquiyan. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero caycuna llapanmi päsanarnin cumplinan, Diospa Palabran quiquincunapa leynincunachö ningan: ‘Chiquiyämargan mana ni imacagpitam.’ ");
INSERT INTO qxnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pero defendir yanapayagniqui shamug rasumpacag Espïritu Santota quiquin Taytäpita cachamungämi, imayca testïgunö nogapag musyatsicunga. ");
INSERT INTO qxnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pero tsaynöllam gamcunapis nogapa testïgü cayanqui, gallananpita nogawan pagta purishga car. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Cay llapantam willayag chiquiyäshurniqui sufritsiyäshuptiqui, nogaman criyicuyniquicuna mana dëjayänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dios Yayaman mañacuyänanpag goricäyänan wajicunapitam chiquir gargoyäshunqui. Tsaynö chiquirmi waquiquitaga wañutsiyäshunqui, Dios Yaya munangannö ruraycäyanganta yarpar. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tsaynö imaycataga rurayäshunqui, Tayta Diostawan nogatapis mana regeyämarmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Caycunatam canan willayag, tsaynö päsayäshungayqui öra yarpäyänayquipag, nogaga gamcunata mas unayna willayangagta. Nogaga manam cayta gallananpitatsu willayargag, gamcunawan cay patsachö pagta caycarllaragga. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Pero cananga aywacü cachamagnï Taytäwan pagta canäpagmi. Tsaynö niyaptigpis manam ni maygayquillapis tapuyämanquitsu ni maypa aywangätapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tsaynö tapuyämangayquipa rantinmi, gamcunaga alläpa llaquishga caycäyanqui, caycuna llapanta willayaptig. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero rasumpacagtam niyag: Mas mejormi gamcunapag noga aywacungä. Si noga mana aywacuptïga defendir Yanapayagniqui Espïritu Santo manam shamungachö gamcunawan pagta cananpag. Pero si aywacurga, nogam gamcunaman cachamushag. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Espïritu Santo shamurnam entëru munduchö runacunata entenditsir musyatsicunga Dios Yaya munangancunata mana cäsuyämar mana alli jutsacunata rurarnin cawayanganpita, mana juc jananpar Dios Yaya alläpa mantsacaypag castigananpag canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Quiquincunapa jutsancunam musyatsicunga nogaman mana criyicayämunganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Espïritu Santom Dios Yayapa munayninta musyatsicunga, Tayta Diosman aywacuptï, pero gamcunaga mananam ricäyämanquinatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tsaynöllam musyatsicunga Dios Yaya juzgarnin cay munduchö mandacug Supayta condenangantapis. Tsay Supayga infiernuchö alläpa castigashga cananpagmi condenashgana caycan. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mas atscaragmi can gamcunata willayänagpag. Pero canan öra llapanta willayaptigpis, manam gamcunaga entendiyta puediyanquitsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero Espïritu Santo shamurmi sïga, llapan rasumpacagcunallata entenditsiyäshunqui. Payga manam quiquinpa yarpayllanpitatsu entenditsiyäshunqui, sinöga Dios Yaya mandacunganllatam. Tsaynöllam entenditsiyäshunqui ima päsananpag cangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Espïritu Santom podernïwan parlangäcunata musyatsir willayäshunqui, regemangantawan poderöso mandacuyyog cangäta. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tayta Diospa mandacuyninchö llapan imaycan capunganpis nogapam. Tsaymi niyag Espïritu Santo nogapita llapan chasquinganta gamcunatapis willarnin musyatsiyäshunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ichicllanam faltan gamcuna manana ricäyämänayquipag. Pero tsaypitanam yapay ricäyämänayquipag tincushun.” ");
INSERT INTO qxnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tsaypitanam waquincag discïpuluncuna jucnin jucnin tapunacuyargan: “¿Caynöga imaninantatan nicämantsic: ‘Ichicllanam faltan manana ricäyämänayquipag, pero tsaypitam yapay ricäyämanqui, Taytäcagpa aywasquirnin cutiscamuptï’? ");
INSERT INTO qxnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ima ninantan ‘Ichicllanam faltan gamcuna manana ricäyämänayquipag’ ninanga? Manam ni ichicllatapis entendintsictsu ni imapag parlangantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Señor Jesucristonam discïpuluncuna tapuyninta munayanganta tantiyasquir nirgan: “Nogam niyargog: Ichicllanam faltan manana ricäyämänayquipag y tsaypitanam yapay ricäyämanquir. ¿Tsaypagcu gamcuna yarpachacur tapunacuycäyanqui? ");
INSERT INTO qxnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rasuncagtam niyag: Gamcunaga rasumpam alläpa llaquicurnin wagayanqui, cay mundupa munayllanta rurag runacuna cushishga caycäyaptin. Pero tsaynö alläpa llaquishga wagarnin caycäyangayquipitam, gamcunapis alläpa cushishga cayman ticrayanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Juc geshyag warmi geshyacunanpag öran chämuptinga alläpa llaquicurmi yarpachacun. Pero wamran yurisquiptinmi sïga, nanacuynintawan llaquicur yarpachacuynintapis jancat gongasquin, cay munduman juc wamrata apamungata alläpa cushicurnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tsaynöllam gamcunapis canan aywacuptï, alläpa llaquishga caycäyanqui. Pero tsaypita yapay tincusquishgam sïga, llapan shongoyquicunawan alläpa cushishga cayanqui. Tsay rasumpacag alläpa cushicuyniquicunataga, manam ni pipis gechuyäshunquinatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tsay junagga manam ni imatapis tapuyämanquinatsu. Rasuncagtam niyag: Taytäga llapan imayca mañayangayquitam garayäshunqui, nogapa shutïchö mañacuyaptiquiga. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cananyagga manam ni imatapis nogapa shutïchö Taytäta mañacuyashcanquiragtsu. Mañacuyay chasquiyänayquipag llapan rasumpa cushicuyniquicuna gamcunachö cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Caycunatam willayashcag iwalatsicuy ejemplucunawan. Pero juc tiempu chamunganam cay ejemplucunawan manana yachatsiyänagpag, sinöga defrentena Taytä imanö cangata willayänagpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tsay junagcunagam defrente shutïllächöna mañacuyanqui; manam noganatsu Tayta Diosta gamcunapag rugacamushag. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tsaymi quiquin Tayta Dios alläpa cuyayäshunqui. Tsaynöga alläpa cuyayäshunqui nogata gamcuna cuyarnin, Diospita shamungäta rasumpa criyiyangayquipitam. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nogaga Tayta Diospa puntanpita yargascamurmi cay munduman shamushcä. Tsaynöllam cananga cay munduta dëjasquir Tayta Diospa puntanman cuticushag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tsaynam discïpuluncuna niyargan: “Cananmi sïga, manana ejemplucunawan yachatsicur defrente parlapaycäyämanqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cananmi sïga musyayä llapan imayca musyangayquita. Mananam wanacannatsu ni pipis tapushunayquipag. Tsaynöpam cananga rasumpa criyicurnin musyayä Diospita shamushga cangayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Señor Jesucristonam contestargan: “¡Tsaypunga rasumpach cananga criyiyanqui! ");
INSERT INTO qxnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tsaynö captinpis öra chaycämunnam, canan öra wacpa caypa witsicarnin munayangayquipa aywacur japalläta dëjascayämänayquipag. Pero manam quiquillätsu quëdashag, sinöga Taytämi nogapa pagtä imaypis caycanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Caycuna llapantam willayag, nogaman rasumpa firmi criyicamurnin mana llaquinar cushishga alli päsacuychö cawacuyänayquipag. Cay munduchö cayangayquiyagllaragga alläpam sufriyanqui. Pero tsaynö sufrirpis mas valoracurnin ama desanimacuyanquitsu, nogan cay mundupa mana alli ruraynintaga venceshcäna.” ");
INSERT INTO qxnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tsaycunata yachatsicur ushasquirnam, Señor Jesucristo cieluman ricarcur nirgan: “Taytallay, öra chämushganam. Tsuriqui alläpa poderöso canganta ricätsicuy, tsaynölla Tsuriquipis alläpa poderöso cangayquita ricätsicur musyatsicunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gammi Tsuriqui llapan runacunata mandananpag churashcanqui. Tsaynöpam llapan entregangayqui runacunata salvarnin, imayyagpis cawatsinga. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tsay mana ushacag cawayga, gam rasumcag japallan Diostawan cachamungayqui Tsuriqui Jesucristota rasumpa regeyanganmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nogam cay munduchö alläpa poderöso cangayquita ricätsicur, llapan mandamangayquicunata rurarnin cumplishcä. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cananga Taytay, cay patsa manarag camashgacaptin, gampa pagtayqui poderöso cangänölla, puntayquichö poderöso cangäta musyatsicuy llapan runacunata. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Cay mundupita acrasquir entregamangayqui runacunatam, pï cangayquitapis rasumpa regetsishcä. Gampa caycaptin entregamangayquicunatam Palabrayquicunata willacuptï rasumpa cäsurnin cumpliyashga. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cananga musyayanmi llapan imayca entregamangayquipis, gamllapita shamunganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gam entregamangayqui Palabrayquicunata, yachatsicuptïmi rasumpa änir chasquiyashga. Gampita shamungäta rasumpa musyarmi, gam cachamangayquita criyiyashga. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nogam rugacug paycunapag, manam mañacugtsu cay mundupa munayllanta rurag runacunapagga. Sinöga gammi tsay llapan criyicugcunata entregamashcanqui, quiquiquipa cayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Llapan entregamangayquicunaga gampam y gampa llapan capushungayquim nogapa. Tsaymi nogapa cushicuypa poderöso caynï paycunachö rasumpa musyatsicur ricacan. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nogaga mananam cay munduchöga cashagnatsu, pero paycunanam sïga cay mundullachörag cayanga, noga gamwan pagta canäpag shamungäyag. Jutsannag Taytay, shutiquichö poderniquiwan defendir cuidaycuy, imaypis yachatsingänölla cawacuyänanpag. Tsaynö cawarmi nogantsic juc yarpayyoglla cangantsicnö, paycunapis cuyanacurnin alli yarpayyog juc shongolla gam garamangayqui shutïchö imaypis cawayanga. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Paycunawan cay munduchö pagta carmi, gampa shutiquiraycu y nogata podernï garamangayquiwan imaycapita tsaparnincuna cuidargö. Manam ni mayganpis ogracarnin jutsaman shicwargantsu. Pero jucninmi sïga, imayca ogracagnö infiernuman aywanga Palabrayquichö gellgashga caycag cumplinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Cananga gam caycangayquimanmi shamushag. Pero caycunataga cay munduchö caycarllaragmi willacü, paycunapis alläpa cushishga cayänanpag, noga jancat rasumpa cushishga cangänö. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nogam gampa Palabrayquita willacurgä. Pero cay mundupa munayllanta rurar cawag runacunam chiquiyan, paycuna gam munangayquinnölla cawacuyaptin. Paycunaga manam cay munduchö runacunanönatsu cayan, nogapis cay mundupita mana cangänölla. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Manam cay mundupita jipinayquipagtsu mañacug, sinöga llapan imayca mana allicunapita tsaparnin cuidanayquipagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Noga cay mundupita mana cangänöllam, paycunapis cay mundupa munayninchöga manana ni imay cawayannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Rasumpacag Palabrayquiwan mana jutsannag limpiuta shongota catsiy, jutsaman mana ishquiyänanpag. Gampa Palabrayquiga rasumpacagmi. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gam cay mundupa munayllanta ruragcunaman cachamangayquinöllam, nogapis paycunata cay mundupa munayllanta rurag runacunaman mandaycä. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Paycuna jananmi quiquïpis jutsannag cashcä, paycunapis jutsannag car llapan rasumpacagcunallata gam munangayquinö willacurnin puriyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manam paycunallapagtsu mañacug, sinöga paycuna willacuyanganta wiyarnin nogaman rasumpa criyicugcunapagpismi. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Gamtam mañacug llapanpis juc shongolla imaycachöpis entendinacur nogantsicwan pagta jucllayllanö shumag cawacuyänanpag. Taytallay, gam nogachö y noga gamchö cangantsicnölla llapanpis juc shongolla cayätsun. Rasumpa shumag llapan juc shongonölla cäyätsun, gam rasumpa cachamangayquita cay mundupa munayllanta rurag runacunapis musyayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gam alläpa alli cushicuynï garamangayquinöllam, nogapis llapan imayca juc shongonölla cäyänanpag cushicuynincuna garashcä. Gamwan ishcantsic juc persönalla cangantsicnö. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nogam paycunachö y gammi nogachö, tsaynöpa juc japallan rasumpa juc shongolla canapag. Tsaynö cawayanganta ricarmi cachamangayquita musyar waquincag runacunapis chasquiyämanga. Tsaynöpam cay mundupa munayllanta ruragcunapis musyayanga cuyamangayquinölla paycunatapis alläpa cuyangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taytallay, gammi paycunata entregamashcanqui. Tsaymi munä noga caycangächö paycunapis pagtä car, alläpa cushcuy podernï garamangayquitawan gampa cushicuy poderniquita ricäyänanpag. Gamga alläpam cuyamargayqui cay mundutapis manarag camarnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ay jutsannag Taytallay, cay mundupa manayllanchö cawag runacunaga manam regeyäshunquitsu. Pero nogam sïga rasumpa regeptig, caycunapis musyayan gam rasumpa cachamangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Paycunatam entenditsishcä pï cangayquitapis. Tsaynöllam imaypis entenditsir sïgishag imanö cangayquita yachatsicurnin. Tsay alläpa cuyamangayquim paycunachö caycan, nogapis paycunata cuyarnin pagtancuna captï.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tsaynö Dios Yayaman mañacusquirnam Señor Jesucristo discïpuluncunawan yargosquir, Cedrón niyangan ragrapa wac tsimpanman aywayargan. Tsaychö juc werta olïvos jachacunamanmi, Señor Jesucristo discïpuluncunawan yaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tsaychömi Señor Jesucristo imaypis discïpuluncunawan goricäyag. Tsaymi traicionarnin ranticug Judás Iscariotepis tsay wertata reger, musyargan Señor Jesucristo tsaychö caycanganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tsaymannam Judás mandacug sacerdöticunawan fariseocuna cachayangan wardiacunatawan juc tröpa Romapita soldäducunata pushashga chargan. Paycunam alli armashga linternacunawan y antorchancunawan chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero Señor Jesucristoga llapan päsananpagcagta musyarnam, yargosquir paycunata tapurgan: “¿Pitatan ashiyanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paycunanam contestayargan: “Nazaret marcapita Jesústam.” Señor Jesucristonam nirgan: “Nogam cä.” Señor Jesucristota traicionar ranticugnin Judáspis tsay runacunawanmi caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Señor Jesucristo “Nogam cä” niycuptinnam, llapan runacuna mantsacar gepapa sicparnin patsaman shicwasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Señor Jesucristonam yapay tapurgan: “¿Pitatan ashiycäyanqui?” Paycunanam yapay niyargan: “Nazaret marcapita Jesústam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Señor Jesucristonam yapay nirgan: “Willayargognam noga rasumpa cangäta. Si ashiyämarga caychö waquincagcuna nogawan caycagcunata aywacuyänanpag dëjaycuyay.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tsaynöga päsargan quiquin Señor Jesucristo willacungan cumplinanpagmi: “Taytay, llapan entregamangayquipita manam ni jucllayllapis ogracangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tsaynam Simón Pedro espädanta jipisquir, mas mandacug sacerdötipa wätaynin Malco shutiyog runapa derëchucag rinrinta jipicat wallusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Señor Jesucristonam, Pedrota nirgan: “¡Tsay espädayquita yapay cutitsiy, maychöpis churaräcunganman! Si Taytä imayca mana awantaypag ayagta upyagnö wañunäta munaptinga, ¿Acäsu manatagcu noga tsaynö cumplïman?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tsaypitanam tröpa soldäducuna mandagnincunawan y judiucunapa templuchö wardiacunawan Señor Jesucristota achcusquir maquinta watasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Puntatam mandacug sacerdöti Anaspa wajinman apayargan, tsay wata llapanpa mandagnin sacerdöti Caifaspa suegrun captin. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tsay mas mandacug Caifasmi, judiucunapa autoridänincunata unayna nirgan: “Mejormi canman juc runalla wañunanpag, Israel marcachö llapan runacuna wañunganpa rantin.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro discïpulunnam Señor Jesucristota gatirnin aywargan. Pero juccag discïpulumajinnam mandacug sacerdötiwan regenacur, Señor Jesucristowan wajipa ruri patiunman yaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero Pedronam wagta puncullachö quëdasquirgan. Tsaynam juccag discïpulumajin mas mandacugcag sacerdötiwan regenacur, puncuta quichapucug warmita rugaycur, Pedrotapis ruri patiuman yaycatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tsay puncuta quichapucug warminam Pedrota tapurgan: “¿Manacu gampis tagay runapa juccag discïpulun canqui?” Pedronam contestargan: “Manam. Manam nogatsu cä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tsaychö alläpa alalaptinmi servigcunawan wardiacunapis ninata tsarircatsir mashacuycäyargan. Tsayman witiycurnam Pedropis paycunawan pagta ninapa lädunchö mashacuycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tsaychönam mas mandacug sacerdöti Anas Señor Jesucristota discïpuluncunapagwan imata yachatsicunganta tapurnin gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Señor Jesucristonam nirgan: “Nogaga llapan runacunapa puntanchömi imaycatapis yachatsicurnin parlashcä. Imaypis Dios Yayaman mañacuyänanpag goricäyänan wajicunachöwan templucunachö y judiucuna goricäyanganchömi yachatsicur willacushcä. Manam ni imatapis nogaga parlashcätsu, mana pï wiyaptin pacayllapaga. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imanirtan nogata tapumanqui? Tapuy wiyamashgacunata; paycuna niyäshuy imata noga yachatsicungätapis. Paycunam rasumpa imayca testïgunö musyayan imata yachatsicur willacungätapis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Señor Jesucristo tsaynö niptinnam, juc wardia gagllachö lagyarnin nirgan: “¿Tsaynöcu contestanqui mas mandacug sacerdötita?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Señor Jesucristonam nirgan: “Si noga mana allita parlaptïga, nimay imanir mana alli canganta. Pero tsay noga ninga allilla caycaptinga ¿imanirtan magamanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tsaypitanam sacerdöti Anas Señor Jesucristopa maquinta watarcatsir, mas mandacugcag sacerdöti Caifasman apatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tsaychö runacunawanmi, Pedro ninapa lädunchö mashacur sïgirgan. Tsaynam tapuyargan: “¿Manacu gamga tagay runapa juccag discïpulun canqui?” Pedronam nëgarnin yapay nirgan: “Manam. Manam nogatsu cä.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tsaypitanam mandacug sacerdötipa servignin runa, Pedro rinrinta jipicat wallusquinganpa ayllun tapurgan: “¿Manacu gamta ricargag tagay runawan olïvos niyangan wertachö?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedronam yapay nëgargan. Tsaynö nëgangan öram gällu cantasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caifaspa wajinpitanam Señor Jesucristota apayargan, gobernador Pilatopa palacionman. Patsa warämugnöna captinmi, judiucunaga Pilatopa palacionman yaycuyargantsu. Si tsay palacioman yaycurga leynincuna limpiu cayänanpag mandacunganta mana cäsurmi, Pascua fiesta micuyta micuyanmantsu cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsaymi Pilato palacionpita yargosquir parlaparnincuna nirgan: “¿Imapitatan cay runata acusayanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Paycunanam niyargan: “Si jutsannag captinga, manam gamman apayämümantsu cargan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatonam nirgan: “Gamcuna aparnin, leyniquicuna mandacungannö juzgayay.” Judiucunanam contestayargan: “Pero judiucunapaga manam ni ima derëchücunapis cantsu, juc runata juzgarnin wañutsiyänäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tsaynömi cumplirgan Señor Jesucristo imanö wañunanpag, mas puntatana willacungan. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tsaynam Pilato palacionman yapay yaycusquirnin, Señor Jesucristota gayasquir tapurgan: “¿Gamcu rasumpa canqui, judiucunapa Reynin?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Señor Jesucristonam nirgan: “¿Tsaytaga quiquipa yarpayniquipitacu tapumanqui o juccuna nogapag willayäshungayquipitacu?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatonam contestargan: “¿Acäsu nogaga judiucu cä? Gampa marcamajiquicunawan sacerdöticunapa mandagnincunam gamta nogaman apatsiyämushushcanqui. ¿Imatatan rurashcanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Señor Jesucristonam contestargan: “Nogapa Mandacuy Reynöga manam cay mundupitatsu. Si cay mundupita captïga, maytsicag runam servimarnï nogata judiu runacunaman entregayämänanta amatsacur llapan peleayanman. Pero nogapa Mandacuynïga manam cay patsapitatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tsaynam Pilato tapurga: “¡Tsaypunga gamchi rey canqui!” Señor Jesucristonam contestargan: “Gammi nirgoyqui, rey cangäta. Nogam rasumpa yurirnin cay patsaman shamurgä, Dios Yayapa rasumpacag Palabranta imayca testïgunö willacur yachatsicunäpag. Tsaynöpam llapan rasumpacagcunallachö cawagcunaga, chasquicur cäsucuyan noga willacungäta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatonam nirgan: “¿Imatan rasumpacagga?” Tsaycuna llapanta tapupasquirnam, Pilato yapay yargosquir judiucunata parlapar nirgan: “Nogaga manam ni ima jutsantapis cay runachöga tarïtsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero gamcunapaga costumbriquicunam can, cada wata Pascua fiestachö juc prësuta gargonäpag: ¿Munayanquicu judiucunapa reyninta libri dëjaycunäpag?” ");
INSERT INTO qxnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsaynam llapan goricashga runacuna yapay gayaycachäyargan: “¡Manam! ¡Tsaytaga ama dëjaytsu! ¡Mas bien Barrabasta libri dëjaycuyga!” nirnin. Tsay Barrabasga Roma naciunpa contran car, peleanganpitam gaycuraycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tsaynö niyaptinnam, Pilato Señor Jesucristota entregargan soldäducuna achcusquir alli astayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldäducunanam cashapita corönata awasquirnin Señor Jesucristopa umanman shucurcatsir, reypa puca mantuntanö ashgotsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tsaynö ashgorcatsirmi, puntanman witiycur yapay yapay niyargan: “¡Vïva judiucunapa reynin!” nirmi, gagllanchö lagyarnin magayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatonam palacionpita yapay yargosquir nirgan: “Ricäyay, jipimurgö gamcuna tantiyacuyänayquipagmi, cay runachö ni ima jutsanta mana taringäta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Señor Jesucristonam palaciopita yargascamurgan umanchö casha corönashga y puca cäpan ashgoshga. Tsaynam Pilato nirgan: “¡Ricäyay cay apayämungayqui runata!” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Señor Jesucristota ricaycurnam sacerdöticunapa mandagnincunawan templuchö wardiacuna gayaycachar gallaycuyargan: “¡Crucificay! ¡Crucificay!” nir. Pero Pilatonam paycunata nirgan: “¡Tsaypunga gamcuna aparnin crucificäyay, nogaga manam ni ima jutsantapis paychö tarishcätsu!” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judiucunanam obligarnin contestayargan: “Nogantsicpaga juc leynintsicmi can, tsay leynintsic mandacungannömi cay runaga wañunan, ‘Diospa Tsurinmi cä’ ninganpita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tsayta wiyaycurnam Pilatoga mas mantsacashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Palacioman yapay yaycusquirnam, Pilato Señor Jesucristota yapay tapurgan: “¿Maypitatan gam canqui?” Pero Señor Jesucristoga manam ni imatapis contestargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatonam nirgan: “¿Gamga manacu contestamanqui? ¿Manacu musyanqui mandacuyyog caynïwan, crucificänagpagwan librina canayquipag dëjaycunagpagpis?” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tsaynam Señor Jesucristo contestargan: “Manam ni mandacuyniquipis nogapagga canmantsu, si quiquin Dios Yaya mandacuyninta mana garashuptiquiga. Tsaymi gampita mas jutsayogga cayan, gamman apamur entregamagcuna.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tsay örapitam Pilatoga ashirgan imaycanöllapis Señor Jesucristota libri dëjaycunanpag. Pero judiucunanam masrag gayaycachäyargan. “¡Si libri dëjarga, manam Romapa mas mandacugnin emperador Cesarpa amïgontsu canqui! ¡Maygan runapis reytucurga, emperador Cesarpa contranmi!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tsayta wiyarnam Pilatoga mandargan Señor Jesucristota wagtaman jipiscatsimur, juzgacuyänan “Gabata” ninyanganman jamätsirgan. Hebreo parlaychöga “Gabataga” empiedrashga patsa ninanmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tsay junagga cargan, Pascua fiestapag pullan junagllana faytaycaptinmi. Tsaynam Pilato judiucunata nirgan: “¡Caychömi reyniquicuna caycan!” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero paycunanam masrag gayaycachäyargan: “¡Wañutsun! ¡Wañutsun! ¡Crucificay!” Pilatonam tapurgan: “¿Acäsu gamcunapa reyniquicunatacu crucificar wañutsishag?” Sacerdöticunapa mandagnincunanam contestayargan: “Nogacunapaga manam reynïcuna canmantsu, Romachö emperador Cesarpita masga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tsaypitanam Pilatoga judiucunata entregaycuptin, Señor Jesucristota crucificag soldäducuna apayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Señor Jesucristotanam cruzta matancarcatsir apayargan, “Calavera” niyanganman. (Tsay Calavera niyangan jircapam shutin cargan, hebreo parlaychöga “Golgota.”) ");
INSERT INTO qxnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tsayman chaycatsirnam Señor Jesucristota Roma soldäducuna cruzman clävayargan, Paywan pagta ishcag runacunatapis ishcanläninman. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato juc letrërota cruzpa puntanman churatsinganchömi nirgan: “NAZARET MARCAPITA JESÚSMI, ISRAEL RUNACUNAPA REYNIN” nir. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Maytsicag judiucunam tsay letrërota liyiyargan, Señor Jesucristo crucificäyangan sitiuga tsay marcapita amänolla captin. Tsay letrëroga gellgashga cargan, hebreochö, latinchö y griegochömi. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tsaymi sacerdöticunapa mandagnincuna Pilatota niyargan: “Ama gellgaytsu: ‘Judiucunapa reyninmi’ nirga. Mas bien gellgay: ‘Judiucunapa reynintucugmi’ ” nir. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilatonam contestargan: “Gellgangäga, tsaynö gellgashgallanam canga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Señor Jesucristota cruzman clävasquirnam, llushtitsiyangan llatapanta chuscun soldäducuna cada ünu raquipunacuyargan. Shucurangan tünicantapis achcusquirmi, janagpita urayag mana costürannag jucllaylla captin, ");
INSERT INTO qxnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","soldäducuna jucnin jucnin ninacuyargan: “Ama caytaga rachishuntsu, mas bien sortiyasquishun mä maygantsictash töcamäshun.” Tsaynömi cumplirgan Diospa Palabran gellgashgachö ningan: “Quiquincuna puram llatapäta raquipunacur, tünicätapis sortiyayanga.” Tsaynömi cargan tsay soldäducuna rurayangan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Señor Jesucristota crucificäyanganpa lädunchömi, mamanpis ñañanwan caycäyargan. Paycunawanmi caycäyargan Cleofaspa warmin María y María Magdalenapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Señor Jesucristo mamanpa lädunchö pagtan tsay cuyangancag discïpulun caycagta ricasquirnam, mamanta nirgan: “Mamay, tsaychömi wawayqui caycan.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tsaypitanam tsay cuyangancag discïpuluntana nirgan: “Tsaychömi mamayqui caycan.” Tsaynö ningan junagpitam, tsay cuyangancag discïpulun Señor Jesucristopa mamanta wajinman pushargan imayca mamantanö cuidananpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tsaypitanam Señor Jesucristoga llapan cumplishgana canganta musyar, Diospa Palabran gellgashga caycag cumplinanpag nirgan: “Yacunämi.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tsaychömi juc järu junta alläpa puchgog vïno caycargan. Tsaymi isöpo niyanga jachapa räman gerupa puntanman träputa watarcur, tsay alläpa puchgog vïnoman tullpurcur, Señor Jesucristopa shiminman wititsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Señor Jesucristonam tsay alläpa puchgog vïnota upyarcur nirgan: “Cananga llapantanam cumplirgö.” Tsaypitanam uraypa umpusquir wañusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Waränin Pascua fiesta captinmi, judiucunaga munayargantsu wañushgacunapa cuerpun jamay sabado junagchö clävaraycar quëdayänanta. Tsay jamay sabado junagga alläpa respetashga junagmi cargan. Tsaymi Pilatoman aywaycur rugayargan cruzchö clävaraycag runacunapa chancancunata paquisquir, cruzpita ayancunata bäjatsir jipitsinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsaynam soldäducuna aywaycur, juccagläninchö runapa chacanta paquisquiyargan. Tsaynöllam Señor Jesucristopa juccagläninchö clävaraycag runapa chancantapis paquisquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero Señor Jesucristopa chancanta paquiyänanpag witiycurnam, wañushgana caycagta tantiyasquiyargan. Tsaynöpam paypa chancantaga paquiyargannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tsaynö wañushgana caycaptinpis, juc soldädum costillanta tucsir quichasquiptin, patsa yawarwan yacu yargamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Caycunata cuentacug runaga ricashga carmi, rasumpacaglla willacun. Payga musyanmi rasumpacagllata imayca testïgunö parlanganta, gamcunapis rasumpa criyiyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Caycuna llapanmi päsargan, Diospa Palabran gellgashga cumplinanpag ningan: “Manam ni maygan tullunllatapis paquiyangatsu.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Juclächönam Diospa Palabran gellgashgachö nirgan: “Ricäyangam, costillanpa päsat tucsishgata.” ");
INSERT INTO qxnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tsaypitanam Arimatea marcapita José shutiyog runa Pilatoman aywarnin rugargan, Señor Jesucristopa ayanta pampananpag. Joséga Señor Jesucristopa gatiragninmi cargan, judiucunapa autoridäcunapita mantsacurnin pacayllapa. Pilato änisquiptinmi, Señor Jesucristopa ayanta pampananpag José apargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tsaynöllam Nicodemopis juc pagas Señor Jesucristopag parlag aywanganpita, quimsa arröba perfüminwan shamurgan. Tsay perfümiga mirrawan aloe niyanganpitam rurashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tsaynömi Joséwan Nicodemo Señor Jesucristopa cuerpunta apaycur, tsay perfümita säbanasman pichurcurnin, judiucunapa costumbrincunamannö cuerpunta piturcur sepultüraman churayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Señor Jesucristota crucificäyangan lädun wertachömi, manarag ni pitapis churayanga juc mushog sepultüra rurashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tsaynö amänolla sepultüra captinmi, Señor Jesucristopa cuerpunta churayargan, waränin judiucunapa Pascua fiestan jamay sabado junag captin. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semäna gallarinan domingo allegnam, María Magdalena tsaca tsacallana Señor Jesucristo pamparangan sepultüraman aywargan. Tsayman chaycurnam, sepultüra tsaparag rumi wititsishgata tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsayta ricaycurmi Pedrotawan Señor Jesucristo cuyangancag discïpulun caycäyanganman cörrilla aywar nirgan: “¡Sepultürapitam Señor Jesucristopa ayanta apayashga y manam musyaytsu ni mayman churayanganpis!” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tsaynam Pedrowan Señor Jesucristo cuyangancag discïpulun yargosquir, pamparangan sepultüraman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishcannam cörrilla aywayargan, pero juccag discïpulunnam Pedropita mas cörrirnin puntata sepultüraman chargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Umpuycur gawarnam ricaycurgan, pituyangan säbanasllana jitaraycagta, pero manam yaycurgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Gepanta Simón Pedro chaycurnam, ruri sepultürayag yaycusquir, piturangan säbanasllatana paypis ricaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tsaynöllam Señor Jesucristopa umanta watäyangan tëlapis, jucläduchö shumag doblarcur churashga caycargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsaynam cörrilla puntata chagcag discïpulunpis, sepultüraman yaycusquir llapan päsanganta ricaycur criyirgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero manaragmi entendiyarganragtsu, puntapitana Diospa Palabranchö wañunganpita cawamunanpag gellgashga cangantaga. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsaypitanam tsay ishcan discïpuluncuna, wajincunapa cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalenanam wacta sepultüra lädunchö wagarnin quëdargan. Tsaynö wagaycanganpitam, sepultüra rurinman umpuycur gawaycurnin, ");
INSERT INTO qxnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yurag llatapashga ishcay angelcuna Señor Jesucristopa cuerpun cangancagchö jamaycäyagta ricaycurgan. Juccag angelmi Señor Jesucristopa uman cangancagchö caycargan y juccagnam chaquin cangancagchö. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angelcunanam tapuyargan: “Warmi, ¿imanirtan waganqui?” Paynam nirgan: “Señornïtam suwar apayashga, manam musyätsu ni mayman churayangantapis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tsaynö nicarnam gepanman tumaycur, Señor Jesucristota ricaycurgan. Pero manam regergantsu ni pï cangantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Señor Jesucristonam tapurgan: “Warmi, ¿imanirtan waganqui? ¿Pitatan ashinqui?” Maríaga tsay wertachö täpacug runa canganta yarparmi nirgan: “Señor, si gam apashga carga, willaycallämay mayman churangayquitapis ashignin aywanäpag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tsaynam Señor Jesucristo nirgan: “María.” Paynam tumaycur hebreo parlaychö nirgan: “¡Rabuni!” (Tsay ninanga “Maestru” ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Señor Jesucristonam nirgan: “Dëjamay. Manaragmi Taytäwan pagta cänäpag aywäragtsu. Mas bien saslla aywar, waugëcunata willay Taytäcagpa cuticunäpag caycanganta. Taytäga gamcunapapis Taytayquicunam y Diosnïga gamcunapapis Diosniquicunam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tsaynam María Magdalenaga saslla aywarnin, discïpuluncunata cuentargan Señor Jesucristota ricanganta. Tsaynöllam cuentargan Señor Jesucristo waugencunapag ningantapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Semäna gallanan domingo puntacag junag patsa goyaycaptinnam, Señor Jesucristopa discïpuluncuna wajipa puncunta wichgapucuycurlla goricäyargan, judiucunapita mantsacurnin. Señor Jesucristonam yaycusquir, puntancunaman ichiycur saludacurgan: “¡Gamcunachö alli päsacuy catsun!” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tsaynö nisquirnam, maquintawan costillan tucsiyangantapis discïpuluncunata ricätsirgan. Paycunanam alläpa cushicuyargan Señor Jesucristota ricaycurnin. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tsaypitanam Señor Jesucristo yapay nirgan: “¡Gamcunachö alli päsacuy catsun! Tayta Dios nogata cachamangannöllam gamcunatapis cachayag, Paypa Alli Willacuyninta willacuyänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tsaynö nisquirnam discïpuluncunaman pücaycur nirgan: “Espïritu Santota chasquiyay. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Si gamcuna pitatapis perdonayaptiquiga, perdonashgam cayanga. Pero mana perdonayaptiquiga, manam perdonashgatsu quëdayanga.” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Señor Jesucristo discïpuluncunata yuripungan öraga, manam tsaychötsu cargan Millïshu niyangan juccag discïpulun Tomasga. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tsaynam waquincag discïpuluncuna niyargan: “Señornintsictam ricäyargö.” Pero Tomasnam contestargan: “Si maquinchö clävos uchcungan erïdata ricarnin dëdöta mana jatirga y costillanchö tucsinganta mana yatarga, manam crïyïtsu rasumpa cawamunganta.” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tsaypita juc semänatana discïpuluncuna yapay juc wajichö goricäyanganchönam, Tomaspis paycunawan caycargan. Puncuta alli wichgapucushga caycäyaptinmi, Señor Jesucristo yapay yaycusquir llapanpa puntancunaman ichisquir saludacurnin nirgan: “¡Gamcunachö alli päsacuy catsun!” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tsaypitanam Tomasta nirgan: “Cayman dëduyquita jatirnin maquïta ricay. Maquiquita apamuy cay costilläta tucsiyämungan erïdäman jatinayquipag. Ama mana criyicugga caytsu. ¡Criyimay cawamungäta!” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tsaynam Tomas cushicuynintinwan mantsacar nirgan: “¡Señornillä y Diosnillä!” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Señor Jesucristonam nirgan: “¿Cawamungäta criyinqui rasumpa ricämangayquipitacu? ¡Alläpa cushishga cayätsun, mana ricaycämar criyicugcuna!” ");
INSERT INTO qxnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Señor Jesucristoga mas atsca juc milagrucunatam rurargan, discïpuluncunapa puntanchö. Tsaycunaga manam llapantsu cay libruchö gellgashga caycan. ");
INSERT INTO qxnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero caycunam sïga gellgashga caycan, gamcuna rasumpa criyiyänayquipag Señor Jesucristoga Dios Yayapa Tsurin cay patsaman shamushga Salvador canganta. Payman rasumpa firmi criyicurnin, gloriachö mana ushacag cawayta tariyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsaypitanam Señor Jesucristo yapay discïpuluncunata yuripurgan, Galileachö Tiberias gocha cuchunchö. Caynömi tsaycuna llapan päsargan: ");
INSERT INTO qxnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedrowan pagtam Millïshu niyangan Tomas y Natanael caycäyargan. Tsay Natanaelga Galilea provinciachö Cana niyangan marcapitam cargan. Zebedeopa ishcan tsurincuna Santiagowan Juan, ishcag mas discïpulumajincunapis. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedronam paycunata nirgan: “Pescädota achcugmi aywaycä.” Waquincagcunanam contestayargan: “Nogacunapis gamwan pagtam aywayä.” Tsaynö nirmi büquiman lätarcur llapan aywayargan. Pero tsay pagasga manam ni juc pescädollatapis achcuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Patsa waraycämuptinnam Señor Jesucristota gocha cuchunchö yuricasquirgan. Pero discïpuluncunaga manam musyayargantsu Señor Jesucristo cangantaga. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Señor Jesucristonam paycunata tapurgan: “¡Amïgocuna! ¿Manacu ni juc pescädollatapis achcuyanqui?” Paycunanam contestayargan: “Manam.” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Señor Jesucristonam nirgan: “Büquipa derëchucag lädunman mällayquicunata jitayay, pescädocunata achcuyänayquipag.” Tsay ningannölla mällancunata jitaycurmi, yacupita mällatapis sutayta puediyargantsu maytsica pescädota captin. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tsaynam Señor Jesucristo cuyangancag discïpulun Pedrota nirgan: “¡Tagayga Señornintsicmi!” Tsayta wiyaycurnam Pedroga llustingan llatapanta sas shucucurcur, büquipita yacuman saltarpurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquincag discïpulucunanam mälla junta maytsica pescädota büquiwan garacharcurnin aywar pläyaman chäyargan. Gocha rurinchö caycäyanganpitaga amänollanam cargan, gocha cuchunman chäyänanpag. Juc pachac (100) metrunöllanam faltargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gocha cuchunman chaycurnam patsaman bäjasquir, nina tsaritsishga shansha jananchö pescädo caycagtawan tanta churaraycagta tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Señor Jesucristonam nirgan: “Apayämuy juc ishcay pescädo tsayrag jipiyämungayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tsaynam Simón Pedro büquiman lätarcur mälla junta jatusag pescädocunata gocha cuchunman garachämurgan. Tsay mällachöga juc pachac pitsga chunca quimsa (153) jatusag pescädocunam cargan. Maytsica jatusag pescädo caycaptinpis mällancunaga manam rachirgantsu. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Señor Jesucristonam nirgan: “Shayämuy micuyänayquipag.” Manam ni maygan discïpulunpis ni pï cangatapis tapuynintaga valorargantsu. Paycunaga musyayargannam Señor Jesucristo rasumpa canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tsaypitanam Señor Jesucristo witiycurnin tantata maquinwan aptarcur, discïpuluncunata aypurgan. Tsaynöllam pescädotapis rurargan. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tsay gocha cuchunchö tincuyanganwanga, cawamunganpita quimsa cutinam discïpuluncunata Señor Jesucristo yuripurgan. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micur ushasquiyaptinnam, Señor Jesucristo Simón Pedrota tapurgan: “Juanpa tsurin Simón, ¿caycunapita mascu cuyamanqui?” Pedronam contestargan: “Aumi. Señor, musyanquim noga cuyangagta.” Señor Jesucristonam nirgan: “Tsaypunga mallwacag ushäcunata mitsignö nogaman criyicamugcunata shumag cuidanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tsaynam yapay tapurgan: “Juanpa tsurin Simón, ¿cuyamanquicu?” Pedronam contestargan: “Aumi. Señor, gam musyanquim cuyangagta.” Señor Jesucristonam nirgan: “Tsaypunga ushäcunata mitsignö nogaman criyicamugcunata shumag cuidanqui.” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Señor Jesucristonam yapay quimsa cutina tapurgan: “Juanpa tsurin Simón, ¿cuyamanquicu?” Pedronam llaquishga quimsa cutina “¿cuyamanquicu?” nir, tupuptin contestargan: “Señor, gamga imaycatam musyanqui. Tsaynöllam musyanqui gamta alläpa cuyangagta.” Señor Jesucristonam nirgan: “Tsaypunga üsha mitsicug üshancunata shumag cuidangannö nogaman criyicamugcunata shumag cuidar catsinqui. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rasuncagtam nig: Jövenllarag carga, quiquillayquim munangayquinö llatapayquita shucucurgayqui maypapis munangayquipa aywanayquipag. Pero auquinyasquiptiquim sïga, ricrayquita quichasquiptiqui juccunarag shucutsiyäshunqui. Tsaynöllam mana aywayta munangayquicunapam apayäshunquipis.” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tsaynömi Señor Jesucristo entenditsirgan Pedro imanö wañunanpag canganta, Dios Yayapa poderninta wañuyninwan ricätsicur. Tsaypitanam nirgan: “¡Gatimay!” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro gepaman tumaycurnam, Señor Jesucristota cuyangancag discïpulun shamuycagta ricargan. Tsaycag discïpulunmi Señor Jesucristo manarag wañur meriendayangan öra, jinchi witiycur tapurgan: “Señor, ¿maygantan traicionarniqui ranticushunqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro discïpulumajinta ricasquirnam Señor Jesucristota tapurgan: “Señor, paytaga ¿imatan päsanga?” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Señor Jesucristonam contestargan: “Si noga cutimungäyag cawananta munaptïpis, gamtaga ¿imatan gocushunqui? Gamga gatimaylla.” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tsaynö niptinmi, waquincag discïpulumajincuna yarpäyargan tsay cuyangancag discïpulunga imaypis manana wañunanpag canganta. Pero Señor Jesucristoga manam ni imaypis manam wañungatsu nirgantsu. Payga caynöllam nirgan: “Si noga cutimungäyag cawananta munaptïpis, gamtaga ¿imatan gocushunqui?” ");
INSERT INTO qxnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tsay Señor Jesucristo cuyangancag discïpulunmi, caycuna llapan imaycata ricashga car, rasumpa gellgashga. Tsaynöpam musyantsic llapan gellgangancuna rasumpacag canganta. ");
INSERT INTO qxnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Señor Jesucristoga maytsica mas milagrucunatam rurashga. Si juc jucpa gellgayaptinga, manam entëru mundupis pagtanmantsu cargan, gellgayangan llapan librucunapagga. Tsaynö caycullätsun. Amen.");
INSERT INTO qxnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Cuyay Teofilo, puntacag libruchömi gellgamurgä Señor Jesucristo chämunganpita llapan rurangantawan yachatsicunganta, ");
INSERT INTO qxnNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta cieluman cuticunganyag. Señor Jesucristo cieluman manarag cuticurmi, runacunata acrargan apostolnin cayänanpag. Paycunatam Espïritu Santopa poderninwan yachatsirnincuna mandargan, imata willacuyänanpagpis. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wañunganpita cawascamurnam quiquinpa persönanwan apostolnincunata yuripurgan, paycuna rasumpa cawamunganta criyiyänanpag. Payga chuscu chunca junagyagmi yuripurnincuna cargan. Tsaynöpam Dios Yayapa Mandacuy Reynonpag willacur yachatsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Señor Jesucristo apostolnincunallawanrag caycarmi, Jerusalénpita manarag aywayänanpag alvertirnincuna nirgan: “Shuyäyay Taytä äniyäshungayqui cumplinganyag, mas puntatana willayangagnö Espïritu Santonta gamcunaman cachamunganyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Rasumpam Juan Bautistaga runacunata yacuwan bautizargan. Pero cananga ichicllanam faltan, gamcuna Espïritu Santopa poderninwan bautizashga cayänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Señor Jesucristowan goricashga apostolnincunam tapuyargan: “Señor, ¿canan öracu Roma autoridäcunapa poderninpita Israel naciunnintsicta libramunqui, allina cawacunapag?” ");
INSERT INTO qxnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Señor Jesucristonam contestargan: “Manam gamcunaga musyayänayquitsu ni imay junag ni imaypis Tayta Dios quiquinpa mandacuyninwan imatapis rurananpagcagtaga. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero gamcunaman Espïritu Santo shamuptin poderninta chasquisquirnam, nogapag imayca testïgünö willacuyanqui Jerusalénchö y entëru Judeachö y Samaria marcacunachöwan entëru mundupa aywarnin” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tsaynö Señor Jesucristo parlar ushasquirnam, paycuna ricaraycäyaptin altupa pallaricarnin cieluman aywacurgan. Pucutaychö illacasquiptinga, mananam yapay ricäyargannatsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cielupa Señor Jesucristo aywacugta ricäraycäyaptinnam, ishcay angelcuna yurag llatapashga läduncunachö yuricasquir, ");
INSERT INTO qxnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","paycuna niyargan: “Galileapita runacuna, ¿imanirtan altu cielupa ricararnin caycäyanqui? Canan caycäyangayquipita imanö pallaricarnin cieluman aywacunganta ricäyangayquinöllam, Señor Jesucristoga yapay cay patsaman cutimunga” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tsay Olïvos niyangan jircachö caycäyanganpitam, Jerusalénman apostolnincuna cuticuyargan. Tsay jircapitaga manam alläpa carutatsu aywayargan, leynincuna jamay junagchö puriyänanpag permintingannölla. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalénman chärirnam, patsacuyangan juc altusman lätayargan. Tsaychömi caycäyargan, ");
INSERT INTO qxnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Paycunam siempri Dios Yayaman llapan mañacuyänanpag goricäyag Señor Jesucristopa mamanwan waugencuna y waquincag mas warmicunawanpis. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tsay junagcunam juc pachac ishcay chunca criyicugcuna goricashga caycäyaptin, Pedro ichircur, ");
INSERT INTO qxnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","nirgan: “Waugecuna, Judás Iscariotem Señor Jesucristota traicionarnin prësu achcuyänanpag mana alli runacunata entregargan. Tsaynö cananpagmi unay rey David gellgargan, Espïritu Santo yachatsiptin. Tsaymi pay gellgangan canan cumplinga. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judásga nogantsicpam cargan. Tsaynöpam llapan imayca rurangantsictapis rurargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero paymi mana allita ruranganpita gellay pägayanganwan chacrata rantirgan. Tsaynam umapa pashtat agashnincunapis jancat witsicat shicwasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Judás tsaynö wañunganta Jerusalénchö täcugcuna musyasquirmi, tsay chacrata shutitsiyargan: ‘Hacéldama’ nir. (Hacéldama ninanga ‘Yawar pampa chacra’ ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tsaypagmi Salmo libruchö nirgan: ‘Täcungan wajim, tsunyaman ticranga. Manam ni pipis tsaychöga täcunganatsu.’ Tsaynöllam nirganpis: ‘Jucna paypa rantin apostol catsun.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Tsaymi caychö waquincag runacuna capamantsic, imaypis pagtantsic purig Señor Jesucristowan cay patsachö nogantsicwan pagta canganpita. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Señor Jesucristotaga Juan Bautista bautizanganpita asta cieluman cuticunganyag rurangancunata ricashga captinmi, juc runata acranantsic llapan apostolcunawan Señor Jesucristo wañunganpita cawamunganta imayca juc testïgunö willacurnin purinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tsaynam ishcagta elegiyargan: “Barsabas” y “Justo” niyangan Josétawan Matiasta. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tsaypitanam Dios Yayaman caynö mañacuyargan: “Señor, gam llapan runacunapa shongoncunata regernin, musyaycatsiyämay cay ishcanpita maygantapis acrangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tsay acrangayquicag runa apostol cananpag, quiquinpa jutsanwan apostol cayninta ograg Judáspa rantin. Payga Señor Jesucristota traicionanganpitam infiernuman aywashga.” ");
INSERT INTO qxnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tsaynö mañacur ushasquir sortiyayaptinnam Matiasman shicwargan. Tsaynöpam Matiasga tsay örapita chunca juc apostolcunaman yapashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostes niyangan fiesta chaycamuptinnam, Señor Jesucristoman criyicugcuna juc sitiullaman llapan goricashga caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tsaychö jamaycäyaptinnam illagpita gayarämurgan imayca alläpa wayra cielupita shamugnörag, entëru wajimanpis juntasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tsaynam imayca nina lunyagnörag, cada runapa umancuna jananchö yuricasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tsay öra Espïritu Santo llapan goricashga runacunaman juntasquiptinmi, tucuyläya parlayta parlarnin gallaycuyargan, Espïritu Santo poderninwan parlatsiyta munangannö. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tsay junagcunam Jerusalénchö caycäyargan, Dios Yayaman criyicuynincunata rasumpa cumplig entëru mundupita goricashga judiucuna. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tsay imayca wayranö alläpa gayaragta wiyarnam, maytsicag runacuna goricäyargan. Tsaynam ni imata yarpayta puediyargantsu, maytsaypita shamugcunapa cada ünu parlaynincunachö llapan apostolcunawan Señor Jesucristopa discïpuluncuna parlagta wiyar. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tsaynöta wiyarnin jancat mantsacashga carmi, jucnin jucnin ninacuyargan: “¿Acäsu cay llapan caychö parlaycagcunaga, manacu Galileallapita cayan? ");
INSERT INTO qxnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Imanötan cananga cada ünu quiquintsicpa parlaynintsicchö parlayagta wiyantsic? ");
INSERT INTO qxnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Caychöga maytsaypita shamushga runacunam, ");
INSERT INTO qxnNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptopita, Cirenecaglä llapan Libia marcapita. Waquinga Romapitapis shamushgam cayan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Y waquinnam judiuchö yurigcuna y waquincagga mana judiu caycarpis, judiu caymanmi ticrayashga. Tsaynöllam shayämushga Cretapitawan Arabiapitapis. ¡Llapantsicmi wiyashcantsic cada ünu parlaynintsicchö willacuyanganta! ¡Paycunam willacuyan Dios Yaya poderninwan llapan imayca alläpa cushicuypag rurangancunata!” ");
INSERT INTO qxnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Llapan runacunam jancat mantsacashga ni imata yarparnin, tapunacur cayargan: “¿Ima ninantan cay llapan wiyangantsicga?” ");
INSERT INTO qxnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero waquincagnam burlacurnincuna niyargan: “Caycunaga machashgam caycäyan” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tsaypitanam Pedro ichircur, chunca juc apostolcunawan pagta caycanganpita jinchi gayaycachaypa nirgan: “Judiumajïcunawan Jerusalénchö llapan täcugcuna, cayta entendiyänayquipag canan willayangagta shumag wiyayämay. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","¡Caycunaga manam machashgatsu caycäyan, gamcuna yarpäyangayquinö alleg las nuevellaragga! ");
INSERT INTO qxnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tsaypa rantinmi caychö canan päsaycan, unay profëta Joel willacurnin ningan: ");
INSERT INTO qxnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Caynömi päsanga ultimu junagcuna ninmi Dios Yaya, Llapan runacunamanmi Espïritu Santota churamushag. Warmi wamrayquicunawan ollgo tsuriquicunam, nogapag willacur parlayanga. Jövencunatam sueñuychönö ricätsishag, y auquincunatanam sueñuynincunachö revelashag. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tsaynöllam servimagnï warmimanpis y ollgomanpis, Espïritu Santota tsay junagcuna churaptï, nogapag willacur parlayanga. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cieluchömi alläpa mantsacaypagta ricätsishag. Tsaynöllam yawartawan ninata, y cay patsachö pucutay goshnita ricätsishag. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rupaypis tutapayman ticraptinmi, quillapis yawarnö puca püru ticranga, Señor Jesucristo poderöso cayninwan manarag cutimuptin. Tsay junagmi alläpa cushicuypag jatun dia canga. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pero Señor Jesucristoman criyicurnin Paypa shutinchö llapan mañacugcunam sïga, infiernuman aywananpita salvacashga canga’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Wiyayay Israel runacuna canan niyangagta: Gamcuna allish musyayangayquinömi, Nazaretpita Jesústa Dios Yaya podernin entreganganta musyatsicurgan, llapayquipa puntayquicunachö tucuyläya milagrucunatawan señalcunata Señor Jesucristowan ruratsirnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tsaynö caycaptinpis, traicionarnin maquiquicunaman entregaycuyäshuptiquim, unaypitana quiquin Dios Yaya yarparnin dispöninganö prësurnin apayargayqui. Tsaynö dispönishgana captinmi, Señor Jesucristota mana alli rurag runacunawan clävarnin wañutsiyargayqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Dios Yayam wañuy nanacuypita librarnin cawatsimushga. Tsay nanatsicug wañuyga manam Paytaga vencenmantsu cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Rey Davidmi, Señor Jesucristopag yarparnin nirgan: ‘Nogam imaypis Señortaga puntächö ricashcä, Pay derëchucag läduchöcaptinga, manam ni imaypis mantsacätsimar shicwatsimangatsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tsaymi shongö alläpa cushicun, gallüpis alläpa cushishgam cantacun. Llapan alma y cuerpümi, rasumpa confiacurnin cawacunga, ");
INSERT INTO qxnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mantsacaypag sepultürachö mana dëjamangayquipita. Tsaynöllam permïtirgayquitsu, Santo servishugniquipa cuerpun ismur ushacänantapis. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Rasumpam ricätsimashcanqui, allicag caway nänita. Gampa puntayquichömi, alläpa cushishga cawacushag’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Waugecuna, canan franco niycuyangagta wiyaycayämay, unay awiluntsic rey David wañusquiptin pampayangan sepultüranpis cananyag nogantsicchö caycanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero Davidga profëta cayninwanmi musyargan, ayllun shamugpita juc reyta Dios Yaya jurarnin äningannö churananpag canganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tsaynöpam imayca ricashganöna rey Davidga Diospita Shamushga Runa cawamunanpag canganta willacurgan, ‘sepultürachö mana dëjamangayquinöllam, Santo servishugniquipa cuerpun ismur ushacänantapis permïtirgayquitsu’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tsaynöpam quiquin Dios Yaya Señor Jesucristota cawatsimunganta, llapäpis ricashga car imayca testïgunö paypag willacuyä. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Paytam Dios Yaya sepultürapita cieluman aywananpag pallarimurgan, derëchucag lädunchö jamaycur llapanta mandananpag. Tsaynam Dios Yaya äningan Espïritu Santonta entregaycuptin, Señor Jesucristo criyicug runancunata raquipurnin cachamushga. Tsay Espïritu Santom ricäyangayquinö y wiyayangayquinö poderninwan cada ünu parlayniyquicunachö parlaycätsin. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pero rey Davidga manam quiquintsu cieluman aywargan, sinöga quiquinmi gellgarnin nirgan: ‘Señornïmi, Señornïta nirgan: “Derëchucag lädüman jamacamuy, ");
INSERT INTO qxnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","llapan chiquishugniquicunata chaquiquipa gopinman churamungäyag.” ’ ");
INSERT INTO qxnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Tsaymi llapayqui Israel marca runacuna musyayay, quiquin Señor Jesucristota chiquirnin cruzchö wañutsiyangayquita, Dios Yaya Señornintsic Diospita Shamushga Cristoman churashga.” ");
INSERT INTO qxnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tsaychö llapan goricashgacuna tsayta wiyaycurmi, alläpa llaquinashga Pedrotawan waquincag apostolcunata tapuyargan: “Waugecuna, ¿imatatan rurayäshag?” ");
INSERT INTO qxnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedronam contestargan: “Arepenticurnin Dios Yayaman cutiyay, Señor Jesucristopa shutinchö bautizacur. Tsaynö bautizacuyaptiquim Dios Yaya jutsayquicunata perdonayäshurniqui, Espïritu Santonta gamcunaman churamunga. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tsay Espïritu Santo änicunganga gamcunapagwan wamrayquicunapag y maytsay caru marcachö runacunapagwan quiquin poderöso Señornintsic Dios Yaya, gayayta munangancunapagmi canga.” ");
INSERT INTO qxnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Caycunatawan mas juccunata willacurmi, Pedrona consejarnincuna nirgan: “Tsay mana alli rurag runacunawan mana juntawacar geshpicuyay” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro tsaynö parlanganta wiyag runacunam bautizacuyargan. Tsay junagmi quimsa waranga mas runacuna rasumpa firmi criyicugcuna yapacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Llapanmi allish firmi criyicuynincunachö cayargan, apostolcuna yachatsicur imayca cayäpungantapis raquipuyaptin. Tsaynöllam goricasquir Dios Yayaman mañacurnin, tantatapis llapan pagta micuyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Llapan runacunam mantsacashga cayargan, apostolcunawan tucuyläya milagrucunata y señalcunata Dios Yaya ricätsicuptin. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Rasumpa criyicugcunam imayca juc familianölla, llapan imancunatapis quiquincuna pura raquipunacurnin shumag cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Capugyogcunam chacrancunatawan imaycancunatapis ranticusquirnin, tsaypa chaninta faltapucug criyicugcunata raquipur yanapayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cada junag templuchö goricarmi, wajincunachöpis cushishga ni ima mana allita yarparnin goricaycur, tantatapis raquipunacur pagta micuyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dios Yayata alabayaptinmi, llapan runacuna cuyayargan. Tsaymi cada junag Señornintsic Dios Yaya criyicugcunaman mas yapacätsirgan, salvacashga cayänanpag llapan aywagcunata. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc junagmi Pedrowan Juan las tres Dios Yayaman mañacuyänan öra captin templuman aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tsay templuchömi juc runa yuringanpitana rata caycargan. Tsay rata runatam aylluncuna cada junag apayag, templupa puncun “Shumag” niyanganman limushnata mañacunanpag templuman yacugcunata. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tsay rata runa Pedrotawan Juanta templuman yacuycagtana ricaycurmi, limushnata mañacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Paycuna ricaraycurnam, Pedro nirgan: “Ricäyämay.” ");
INSERT INTO qxnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tsay rata runanam imallatapis garayänanta yarpar, paycunaman mas atendirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Pedronam nirgan: “Manam gellaynïwan ni gorïpis cantsu, pero capamanganta canan garashayqui: Nazaretpita Señor Jesucristopa shutinchö, sharcurnin aywacuy.” ");
INSERT INTO qxnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tsaynö nisquirnam Pedro runapa derëchucag maquinpita achcurcur sutarcurgan. Tsaynö sutaycaptinnam runapa chanca tullun callpayognö ticrasquir jancat juegasquiptin sänu ticrasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsay ratanam saslla saltarrag sharcurnin purir gallaycurgan. Tsaypitanam paycunapa pagtan quiquinpa chaquillanwan templuman yaycurgan, cushishga Dios Yayata alabarnin saltaycacharrag. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tsay llapan runacuna rata purigtawan Dios Yayata alabagta ricagcunanam, ");
INSERT INTO qxnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","cushicuynintinwan alläpa mantsacashga cayargan tsaynö päsanganta. Paycunaga regeyarganmi templupa puncun “Shumag” niyanga sitiuchö, templuman yaycugcunapita limushnata mañacug rata runa canganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tsay rata canganpita cuticashga runaga manam dëjargantsu, Pedrotawan Juanta. Tsayta llapan runacuna mantsacashga ricarmi, llapan cörrir aywayargan templuchö “Salomónpa corredornin” niyanganchö apostolcuna caycäyanganman. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro tsaynö goricäyanganta ricaycurmi, paycunata nirgan: “¿Imanirtan gam Israel runacuna mantsacäyanqui? ¿Imanirtan yarpäyanqui quiquïcunapa podernïcunawan o Dios Yayaman rasumpa criyicurnin mana jutsannag caynïcunawan cay runa purinanpag cuticätsiyangäta? ");
INSERT INTO qxnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Unay awiluntsiccuna Abrahampa, Isaacpa, Jacobpa, gepan shamugcuna adorayangan Dios Yayam dispönirgan quiquinnö poderöso Tsurin Señor Jesucristo cananpag. Pero gamcunam Señor Jesucristota Pilato niyangan autoridäman apaycur dëjarnin entreyargayqui wañutsinanpag. Tsaymi Pilato libri dëjaycuyta munaptinpis gamcunaga wañutsinanpag obligayargayqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gamcunaga imaycatapis allilla rurag mana juc jutsannag libri cananpag mañayangayquipa rantinmi, juc wañutsicug runata gamcunaman dëjananpag mañayargayqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tsaynömi gamcunaga wañutsiyargayqui, rasumpa mana ushacag cawayman apacug Señor Jesucristota. Pero quiquin Dios Yaya cawatsimungantam, nogacunapis imayca juc testïgunö ricäyashcä. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Gamcuna regeyangayqui rata runata imayca callpan garagnö cuticatsigninga, Señor Jesucristopa shutinchö payman rasumpa firmi criyicuymi. Tsaynö firmi Señor Jesucristoman criyicuymi, tsay rata runataga canan jancat sänuyätsir cuticätsishga gamcuna llapayqui ricäyangayquinöpis. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Cananga waugecuna musyämi, gamcunawan mandacug autoridänïcuna Señor Jesucristota wañutsiyanganta. Gamcunaga tsaynö wañutsiyargayqui rasumpacagta mana tantiyarmi, ni imata ruraycäyangayquitapis mana musyarnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero Dios Yayam tsaynö cumplirgan, unay profëtancunawan willacatsinganta: ‘Paypita cay patsaman shamushga Cristo wañunanpag canganta.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tsaymi cananga gamcuna Dios Yayaman cutirnin alli ruragmanna ticrayay, llapan jutsayquicunapita arepenticuyaptiqui limpiarnin perdonayäshunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tsaynöpa maypis Señorwan gamcuna shumag alli päsacuychö cawacuyänayquipag. Señor Jesucristotam unay gallananpitana cay patsaman cachamunanpag acrashga cargan, Diospita shamushga Cristo gamcunata salvayäshunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tsaynöpam cananga Señor Jesucristo cielullachörag canga, asta Dios Yaya llapan imaycacunatapis shumag patsätsingan junagyag. Tsaypagmi Dios Yaya unay tiempuchö acrangan santo profëtancunawan änicur willacatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tsaymi unay Moiséswan unay awiluntsiccunata willacur nirgan: ‘Señorniquicuna Dios Yayam gamcunapa aylluyquicuna shamugpita nogatanö juc profëtata churamunga. Tsay profëta yachatsicungancunata wiyarnin shumag cäsucur llapanta cumpliyanqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pipis tsay profëtata mana wiyarnin cäsucagcunataga, tsay marcapita raquirnin asïpag gargoyay.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tsaynöllam unay llapan profëtacunawan unay Samuelpita gallaycur, canan junagcunapag willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gamcunaga unay profëtacuna willacuyangannömi, Dios Yaya änicunganwan eredëru cayanqui. Tsaynöllam eredëru cayanqui, quiquin Dios Yaya unay Abrahamwan conträtuta rurayanganpitapis. Quiquin Dios Yayam unay Abrahamta nirgan: ‘Entëru munduchö runacunam gampita shamug aylluyquiwan bendiciunnïta chasquiyanga’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios Yayam Servignin Jesucristota cawascatsimur, gamcunaman bendiciunninta churamunanpag puntata cachamurgan. Tsaynöpam llapayquipa jutsayquicunata dëjascatsiyäshurniqui, alli ruragmanna ticratsiyäshunqui shumag cawacuyänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tsaychö atscag goricashga runacunata Pedrowan Juan yachatsicurnin willacuycäyaptinllaragmi, sacerdöticunawan templuchö wardiacunapa capitan y saduceocuna chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paycunaga alläpam piñacuyargan, Pedrowan Juan “Señor Jesucristo wañunganpita cawamur rasumpa musyatsimangantsicnölla, Payman criyicurnin llapantsicpis wañungantsicpita cawamushun” nir yachatsicuyaptin. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pedrotawan Juanta prësu achcusquirmi, carcelman gaycuyargan tardina captin waräninyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero Pedrowan Juan willacuyanganta wiyag runacunaga maytsicagmi Señor Jesucristoman criyicuyargan. Tsay criyicugcunata yupayaptinmi, ollgocagcunalla pitsga waranga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Waränin junagnam judiucunapa mandagnincunawan respetashga auquincuna y ley yachatsicug runacuna Jerusalénchö goricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tsaychömi caycäyargan mas mandacug sacerdöti Anas, Caifas, Juan, Alejandro y mas mandacug sacerdöticunapa llapan aylluncunapis. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsaynö goricasquirnam Pedrowan Juan gaycuraycäyanganpita apayämunanpag mandayargan. Apascayämuptinnam puntancunaman ichiycatsirnin, declaratsir tapuyargan: “¿Ima mandacug cayniquicunawanta o pipa shutinchötan caycunata ruraycäyanqui?” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedronam Espïritu Santopa poderninwan junta car contestargan: “Cay marcapa mandacugnin respetashga auquincuna, ");
INSERT INTO qxnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","gamcunam tapuyämanqui allita rurarnin cay rata runata cuticätsiyangätawan imanöpa cuticashga canganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Si musyayta munayaptiquiga, cananmi puntayquicunachö declararnin willayäshayqui gamcunatawan llapan Israel marca runacunata: Cay runaga ricäyangayquinö sänu jancat cuticashga caycan, gamcuna crucificasquir wañuscatsiyaptiqui, Dios Yaya cawatsimungan Nazaretpita Señor Jesucristopa shutin poderninwanmi. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Cay Señor Jesucristo imayca ‘maestru ruminö caycaptinmi, gamcuna imayca albañilnö despreciarnin jitariyargayqui. Pero Paymi cananga tsay maestru rumipitapis mas allicag maestru rumiman ticrashga.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Manam masga ni pichöpis salvacuy cantsu, Señor Jesucristo salvamangatsicpitaga. Quiquin Dios Yayapis cay entëru munduchö manam ni pita regetsimashcantsictsu, Payman criyicurnin rasumpa salvacunapag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tsay autoridäcuna Pedrowan Juan mana juc mantsacur willacuyagta ricarmi mantsacashga tantiyasquiyargan, mana estudiashga ni yachacushga caycar alläpa imaycata yachayangata. Tsaynöpam musyayargan Señor Jesucristowan caycäyanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tsay cuticashga runapis läduncunachö shaycagta ricarmi, autoridäcuna contrancuna parlar ni imapita culpatsayta puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tsaynam ishcan apostolcunata wagtaman gargascatsir, quiquincuna puralla discutinacur ");
INSERT INTO qxnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ninacuyargan: “¿Cay runacunataga imatatan rurashun? Tsay rata runata paycuna cuticätsiyangantam cay entëru Jerusalénchö jancat musyayashga. Tsay jatun milagruwan señal rurayangantaga manam nogantsicpis nëgayta puedintsictsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero tsaynö cuticätsiyangantaga amana runacuna willanacurnin puriyätsunnatsu. Paycunata amenasarnin mantsacätsishun, cananpitaga manana ni pitapis Señor Jesucristopa shutinta parlapar willacuyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsaynam apostolcunata gayascatsimur alvertir mandayargan, cananpitaga Señor Jesucristopa shutinchö manana yachatsicur willacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedrowan Juannam contestayargan: “Quiquiquicuna shumag yarpachacuyay, mä allicush canman Dios Yayapagga gamcuna mandayämangayquillata cäsuyangä, quiquin Dios Yayata cäsuyangäpa rantin. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nogacunaga Señor Jesucristota ricäyangätawan wiyayangäta willacuytaga manam ni imay dëjayta puediyäshagtsu.” ");
INSERT INTO qxnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Llapan autoridäcuna alläpa amenasaycarpis, libritam dëjayarga. Manam ni imanöpa castigayta puediyargantsu, tsay rata runa cuticanganta ricashga atscag runacuna Dios Yayata alabar cayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tsay rata canganpita juc milagruwan cuticag runaga, chuscu chunca wata masyogmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedrowan Juan libri yargosquirnam, criyicugmajincuna caycäyanganman aywayargan. Tsaynam willacuyargan sacerdöticunapa mandagnincunawan respetashga auquincuna llapan imayca niyanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tsaynö llapanta willacuyaptinnam, juc shongolla Dios Yayaman mañacurnin niyargan: “Señor, gammi cieluta, patsata, lamarta y tsaychö llapan imayca cawagtapis camarnin, ");
INSERT INTO qxnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Espïritu Santowan entenditsicur unay servishugniqui awilücuna rey Davidpa shiminpa willacatsir nirgayqui: ‘¿Imanirtan maytsay naciuncunachö runacuna rabiarnin gayaycachäyan? ¿Imanirtan mana ni ima servigpag, imaycatapis yachatsinacur caycäyan? ");
INSERT INTO qxnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cay patsachö mas mandacug reycunawan mayor autoridäcunam, llapan juntawacasquir Señorpa contran car, Dios Yaya acrangan Paypita Shamushga Cristota chiquiyanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tsaynömi Herodeswan Poncio Pilato cay marcachö juntawacasquir, mana regeshga caru marcapita shamushgacunawan Israel runacuna contran cayargan. Tsay llapan runacunam chiquiyargan, Gampita Shamushga Cristo acrangayqui Jesús Santo servishugniquita. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Manarag cay patsaman shamuptinmi, Tsuriquita runacuna wañutsiyänanpag quiquiquipa poderniquiwan dispönishgana cargayqui, Dios Yaya. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Señor, canan ricay autoridäcuna mantsacätsiypa amenasäyämanganta. Mas valornïcunawan änimuta garaycayämay mana ni imapita mantsacur Palabrayquita willacuyänäpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tsaynölla poderniquiwan geshyagyashacunatapis cuticätsirnin, tucuyläya milagrucunatawan señalcunata ricätsicuy, santo servishugniqui Señor Jesucristopa shutinchö.” ");
INSERT INTO qxnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tsaynö Dios Yayaman mañacur ushasquiyaptinnam, tsay goricäyangan waji cuyuptin Espïritu Santopa poderninwan junta ticrasquir, mana juc mantsacurnin Diospa Palabranta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Llapan criyicugcunam maytsicag caycarpis, yarpaynïcunachö juc shongolla llapan cawacuyargan. Mayganpa imancuna captinpis, tsay criyicugcunapam llapan imaycancunapis llapanpag cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostolcuna Señor Jesucristo wañunganpita cawamunganta Espïritu Santopa poderninwan willacuyaptinmi, atscag runacuna Dios Yaya bendiciunninwan yanapaptin, mas firmi criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Paycunachöga mananam ni mayganpis wactsa ni imannagga cayargannatsu. Chacrayogcag runacunanam chacrancunata y wajincunata ranticusquir chanin gellayta, ");
INSERT INTO qxnNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apostolcuna wactsacuna segun wanayangannö yanapar aypuyänanpag entregayag. ");
INSERT INTO qxnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Juc runam levita casta Chipre ishlachö yurig José shutiyog cargan. Apostolcunam paypa shutin churayargan “Bernabeta.” (Tsay shutiga: “Cuyarnin llaquipäcug runa” ninanmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabemi chacranta ranticusquir, chacranpa chaninta apostolcunaman apar entregargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero juc runam Ananias shutiyog warmin Safirawan willanacusquir, chacrancunata ranticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Quiquincunapuram warmi ollgo parlayargan, waquincag gellayta quëdacurnin waquinllata entregayänanpag. Tsay parlayangannömi Ananias chacranpa chanin gellayta waquincagllata apargan apostolcunata entregananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedronam payta nirgan: “Ananias, ¿imanirtan shongoyquiman Supay yaycur engañashuptiqui, chacrayquipa waquincag chanin gellayta quëdatsicur, Espïritu Santota llullatsirgoyqui? ");
INSERT INTO qxnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Acäsu manacu quiquipa chacrayqui cargan? Tsay chacrata ranticungayqui llapan gellaypis, ¿manacu gampa cargan? ¿Imanirtan gam llullatsir caynö ruracargoyqui? Manam runacunatatsu llullatsiyämashcanqui, sinöga quiquin Diostam llullatsirgoyqui.” ");
INSERT INTO qxnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tsayta wiyaycurmi Ananias patsaman wañut shicwasquirgan. Tsaynö llullacunganpita Ananias wañunganta musyasquirnam, llapan runacuna alläpa mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsaynam jövencuna shamuycur Ananiaspa ayanta piturcur aparnin pampayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsaypita casi quimsa öratanönam Ananiaspa warmin Safira chärgan, gojan wañunganta mana musyar. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedronam tapurgan: “Nimay ¿rasumpacu gamcuna tsay apamungan gellayllachö chacrayquicunata ranticuyargayqui?” Paynam contestargan: “Aumi, tsay apamungan gellayllachömi ranticuyargä” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedronam nirgan: “¿Imanirtan gojayquiwan ishcayqui yachatsinacuyargayqui, Señorpa Espïritu Santonta pruebagnöga? Tagay jövencunapa chaquincunapis waji puncumannam yaycaycämunnam gojayquita pampayämunganpita, cananga gamtanam apayäshunqui” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tsaynam jina öra Safira Pedropa puntanman ishquisquir wañusquirgan. Jövencunanam yaycusquir Safira wañushgata tarisquir, ayanta aparnin gojanpa lädunman pampayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tsaynö Ananiaswan Safira wañuyanganta musyasquirmi, llapan criyicugcunawan waquincag llapan runacunapis alläpa mantsacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostolcunam llapan runacunapa puntanchö señalcunatawan milagrucunata rurayargan. Tsaynö rurayaptinmi llapan criyicugcuna goricäyargan “Salomón” niyangan corredorman. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Waquincag runacunaga mantsacurmi, criyicugcunaman juntawacar goricäyargantsu. Imaycatapis allicunallata rurayaptinmi, criyicugcunata llapan runacuna alläpa respetar cuyayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tsaynö waquincag runacuna mantsacur caycäyaptinpis, cada junagmi mas atscag runacuna warmipis ollgopis Señor Jesucristoman criyicur yapacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tsaymi cällicunaman puñunancunawan y tsacrancancunawan jipiscamur geshyagyashacunata churayargan, Pedro päsangan llantun mayganpa janallanmanpis shicwaptin cuticänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tsaynöllam cercan marcacunapitapis llutaypa maytsicag runacuna Jerusalénman shayämurgan, geshyagyashacunatawan supayyog runacunata apayämur. Tsay tucuyläyawan geshyagyashacunata apayämungan runacunam llapan cuticäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mas mandacug sacerdötiwan saduceo grüpupita tsaychö caycag runacunam, alläpa rabiapar chiquirnin, ");
INSERT INTO qxnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","achcuscatsir tsay marcachö llapanpa carcelninman gaycatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero Señorpa juc angelninmi gaycuräyangan carcelta puncunta pagaspa quichasquirnin, caynö nir jipirgan: ");
INSERT INTO qxnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aywayay, templuman ichiycur llapan marca runacunata willayay, cay llapan Alli Willacuywan mushog caway imanö canganta” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tsay angel ninganta wiyayangannöllam, waränin allegllana templuman yaycusquir yachatsicur gallaycuyargan. Tsayyagnam mas mandacug sacerdötïwan tsaychö pagtan caycag runacuna, israelcunapa respetashga auquincunata juc jatun sesionman gayascatsir, mandayargan carcelchö caycag apostolcunata apayämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero wardiacuna carcelman chaycurnam, apostolcunataga tariyargantsu. Tsaynam mantsacashga cutirnin willacur, ");
INSERT INTO qxnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","niyargan: “Tariyargömi carcelga alli següru wichgaraycagta y wardiacunapis puncuncunachö täpar ichiraycagta. Pero quichasquirnam, tsay rurichöga ni pitapis tariyargötsu” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tsayta wiyaycurnam mas mandacugcag sacerdöticunawan templuchö wardiacunapa capitanninpis y regeshgacag sacerdöticunapis mantsacashga tapunacuyargan, ima päsangantapis mana musyarnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tsaynö caycäyaptinnam juc runa chaycur nirgan: “¡Ricäyay! Gamcuna carcelman gaycatsiyangayqui runacunam templuchö yachatsicuycäyan” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsaynö willacusquiyaptinnam, wardiacunapa capitannin wardiacunata pusharcur achcugnincuna templuman aywargan. Pero mana imanayta puedirmi rugarnincunalla pushayämurgan runacuna sagmayänanta mantsacur. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tsaypitanam judiucunapa mas mandacug autoridänincuna goricashga caycagman tapuyänanpag apayämurgan. Tsaychönam mas mandacugcag sacerdöti tapurnincuna nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nogacunam alvertiyarniqui proibiyargag tsay runapag manana ni imatapis willacur yachatsicuyänayquipag. Pero ¿imatatan gamcuna rurayargoyqui? Gamcunaga entëru Jerusalénmanmi chatsiyargoyqui, yachatsicuyniquicunatawan tsay runa wañunganta tumpayämarnï culpatsayämar.” ");
INSERT INTO qxnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedrowan waquincag apostolcunanam contestayargan: “¡Nogacunapaga obligacionnïcunam can, puntataga Dios Yaya cäsuyänäpag runacunata cäsuyangäpitaga! ");
INSERT INTO qxnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Unaycag aylluntsicpa Diosninmi, Señor Jesucristota cawatsimurgan, gamcuna cruzman warcarcur wañutsiyangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Quiquin Dios Yayam sharcatsimur derëchucag lädunman Salvador Pushacug Rey cananpag churashga. Tsaynö churanganpitam jutsayquicunapita arepenticurnin Dios Yayaman cutiyaptiqui, llapayqui Israel naciunta perdonayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tsaytaga quiquïcuna ricashga carmi, rasumpa testïgun cayä. Tsaynöllam Dios Yaya cäsugnincagcunata Espïritu Santotapis testïgun cananpag garanga.” ");
INSERT INTO qxnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tsayta wiyarcurnam alläpa rabiarnin piñacur, Pedrotawan apostolcunata wañutsiyta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero tsay autoridäcunachömi juc fariseo Gamaliel niyangan marcanchöpis mas respetashga ley yachatsicug runam cargan. Tsay Gamalielnam ichircurnin mandargan, tsaypita juc rätu apostolcunata wagtaman jipiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Apostolcunata wactaman jipisquiyaptinnam tsaychö caycag autoridämajincunata nirgan: “Israel marca runacuna, cuidädu cayay tsay runacunata imatapis rurayangayquita. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yarpäyay juc tiempuchö Teudas niyangan runa, aläbacurnin mas importanti mandacug ticraptin chuscu pachac runacuna gatiräyanganta. Pero tsay runata wañuscatsiyaptinmi, gatiragnincunapis witsicarnin aywacur jancat llapan ushacasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsaypita mas gepata censacuyangan tiempuchönam, Galileapita Judás niyangan runa Roma gobiernopa contran shärir runacunata timpullyätsiptinmi, waquicag runacuna gatiräyargan. Pero paytapis wañuscatsiyaptinmi, llapan gatiragnincunapis witsicar aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tsaymi noga consejayag: ¡Tsay runacunata dejayay ama mëticuyaytsu! ¡Dëjaycuyay aywacuyänanpag! Si paycuna rurayangan runacunallapita captinga, tsay rurayangapis päsarnin ushacangallam. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero si Diospa poderninwan tsay runacuna rurayaptinga, manam ni imanöpa venceyta puediyanquitsu. Cuidädutag Dioswan pelear contran imatapis mana allita ruraycäyanquiman.” ");
INSERT INTO qxnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tsaynam runacuna cäsucuyargan. Tsaypitanam apostolcunata gayascatsimur alli astaycatsirnin proibiyargan, Señor Jesucristopa shutinchö manana willacur parlayänanpag. Tsaynö alli alvertïcurmi dëjayargan aywacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostolcunanam autoridäcunapa puntanpita alläpa cushishga yargosquir aywacuyargan, Señor Jesucristopa shutinchö willacuyanganraycu Dios Yaya tsaynö despreciarnin piñapar castigashga cayänanpag permïtinganpita. ");
INSERT INTO qxnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tsaynam apostolcunaga cada junag templuchöwan wajicunachöpis Diospita Shamushga Señor Jesucristopa Alli Willacuyninta yachatsicur willacuyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tsay witsancunam Señor Jesucristoman criyicugcuna mas atscag yapacäyaptin, griego parlag criyinticuna quëjacur gallaycuyargan hebreo parlagcunapag. Griego runacunam quëjacuyargan cada junag imayca raquipunacuychö griego parlag viudacunata mana atendiyanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tsaymi chunca ishcay apostolcuna llapan criyicugcunata goricascatsir niyargan: “Manam allitsu canman nogacuna Dios Yayapa Palabran yachatsicuyta dëjasquir, gamcunata mësaman shumag serviyarniqui raquipunacur cayänayquillapag mas yarpachacuyaptïga. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tsaynö caycaptinga waugecuna, gamcunapitam ashiyämunayqui mas confiacuyangayquicag ganchis runacunata Espïritu Santopa poderninwan junta cayaptiqui Pay yachatsiyäshungayquinö. Tsay ashiyämungayqui runacunata encarganapag, faltapucug wactsacunata shumag iwal raquipurnin atendiyäshunayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nogacunaga Dios Yayaman mañacurnin Palabranta yachatsicur willacuytaga imaypis sïgiyäshagmi.” ");
INSERT INTO qxnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tsaynam llapan criyinticuna cushishga acuerdu car Estebanta firmi criyicuyninchö y Espïritu Santopa poderninwan junta captin acrayargan. Tsaynöllam acrayargan Felipeta, Procorota, Nicanorta, Timonta, Parmenasta y Nicolas Antioquia marca runata. Tsay Nicolasmi mas puntatana judiuman ticrashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tsaypita apostolcunaman apaycurnam, Dios Yayaman mañacur tsay ganchis runacunapa umancunaman maquincunata churayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Dios Yayapa Palabran maytsaypa miraptinmi, Jerusalénchöpis mas maytsicag criyicugcuna yapacäyargan. Tsaynöllam judiucunapa waquincag sacerdötincunapis, cäsucurnin rasumpa criyicuyta änir chasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanmi Espïritu Santopa poderninwan junta car, Dios Yayapa bendiciunninwan atsca milagrucunatawan tucuyläya mantsacaypag señalcunata rurargan, tsay marca llapan runacunachö. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jerusalénchö waquincag runacuna Dios Yayaman mañacuyänanpag goricäyänan wajipam shutin cargan: “Libräducunapa wajin.” Tsay wajimanmi Cirene marcapita, Alejandria marcapita y Cilicia provinciapita, Asia provinciapita libracashga runacuna shamushga cayargan. Tsay libracashga runacunam Estebanpa contran shärir discutirnin piñanacur gallaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero manam ni imanöpa discutirnin venceyargantsu, Espïritu Santopa poderöso yachayninwan llapan imaycatapis Esteban shumag parlaptin. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsaynam pacayllapa runacunata niyargan, Estebanta contran llullacur: “Cay runatam wiyashcä Moiséspawan Diospa contran mana allita parlaycagta” ninanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tsaynö llullacur niyaptinnam, llapan runacunawan respetashga auquincuna y ley yachatsicug maestrucuna piñacurnin timpullyäyargan. Tsaynö llapan timpullyarnin piñacurmi Estebanta achcusquirnin garachashga prësu apayargan, mas mandacug mayor autoridäcuna goricäyänanman. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tsaychönam llullacurnin manacagta parlag testïgucunata ashiyargan niyänanpag: “Tsay runaga manam ni imay pärantsu, cay respetashga santo templuntsicpagwan Moisés gellgangan leynintsiccunapa contran parlayta” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tsaynöllam “Nogacuna Esteban ninganta wiyayashcä: ‘Tsay Nazaretpita Jesússhi cay templuntsicta jancat juchutsinga y Moisés dëjapamangantsic costumbricunatapis jancatshi cambianga.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Maytsicag goricashga autoridäcunawan tsaychö llapan jamaycagcunam, Estebanpa gagllan imayca angelpanörag caycagta ricaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mas mandacug sacerdötinam Estebanta tapurnin nirgan: “Tsay llapan imayca niyäshungayqui ¿rasumpacu o manacu?” ");
INSERT INTO qxnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tsaynam Esteban contestargan: “Waugecuna y respetashga taytacuna wiyaycayämay: Alläpa cushicuypag poderöso Dios Yayam unay awiluntsic Abraham manarag Haranman täcug aywaptin, Mesopotamiachö yuripusquir, ");
INSERT INTO qxnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","nirgan: ‘Täcungayqui marcayquita aylluyquicunata dëjapusquir, noga ricätsinagpagcag marcaman aywacuy.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Tsaypitanam Abrahamga Caldea marcapita yargosquir, Haran marcaman täcug aywacurgan. Tsay marcachö taytan wañusquiptinnam Dios Yaya Abrahamta apamurgan, cay gamcuna canan caycäyangayqui Israel marcaman. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero tsay Israel marcachöga Dios Yaya manam ni juc erenciallatapis entregargantsu, ni juc pedäsuman chaquinta churaycunanllapagpis. Pero quiquin Dios Yayam änirgan Abraham wañusquiptin paypita shamug aylluncunapa tsay marcan cananpag. Tsay tiempuchöga manaragmi Abrahampaga ni juc tsurinpis carganragtsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tsaynöllam Dios Yayaga nirgan: ‘Aylluyquicuna imayca jucläpita mana regeshga runacunanö mana regeyangan marcachö täcuyaptinmi, chuscu pachac wata cumplimunganyag esclävu cayaptin ultrajarnin dembalde arutsir catsiyanga.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero tsaynöllam Dios Yaya nirgan: ‘Nogam esclävunpag churayäshugniqui naciunta castigarnin, libri cayänayquipag jipiyämushayqui. Tsaynö jipiscayämuptigmi cay naciunchö nogata servirnin adorayämanqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tsaypitanam Abrahamwan conträtuta rurayanganchö Dios Yaya mandacurgan, ollgocunapa pengaynincunachö señalashga cayänanpag. Tsaymi Abrahamga tsurin Isaac yuringanpita pusag junagta pengayninchö señalargan. Abrahamnöllam tsurin Isaacpis tsurin Jacobta rurargan. Tsaynöllam Jacobpis tsurincunata señalargan. Tsay tsurincunam Israel naciunchö chunca ishcay marcapa mandagnincuna cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tsay Jacobpa tsurincunam nogantsicpapis unaycag aylluntsiccuna cayargan. Paycunam waugencuna Joséta chiquirnin, Egiptoman juc esclävutanö apayänanpag ranticuyargan. Pero Dios Yaya Joséwan caycarnam, ");
INSERT INTO qxnNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","imayca desgraciacunapita librargan. Tsaynöllam Dios Yaya alläpa allish yachaynin garaptin, Egiptopa reynin faraonpis cuyar quiquinnö Egiptochö llapan runacunapa mandagnin y palacionchö mayordömun cananpag churargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tsay tiempum Egipto naciunchöwan Canaán marcachö alläpa mallagäcuy muchuywan sufrimientu wata captin, unaycag aylluntsiccunapa ni imancuna micuyänanpag cargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero Jacob Egiptochö trïgu canganta musyasquirnam, unay aylluntsic tsurincunata Egiptoman mandargan. Tsay aywayanganmi punta gallarinancag viäjincuna cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tsay viäjipita yapay ishcay cuti aywayaptinnam, Joséga waugencunata pay pï canganta willargan. Tsaynöpam rey faraon José pï familia canganta musyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsaypitanam Joséga taytan Jacobtawan ganchis chunca pitsga aylluncunata, Egiptoman apayämunanpag mandargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tsaynöpam Jacobga Egiptochö täcunanpag llapan aylluncunawan aywacurgan. Tsaychömi unay aylluntsic Jacob wañucusquiptin, unaycag aylluntsiccunapis wañucuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jacobpa aylluncunam Egiptopita paypa ayanta Siquem niyangan marcaman aparnin pampayargan. Tsay Siquemchömi Hamor runapa tsurincunapita unay aylluntsic Abraham chacrata rantirgan, tsayman aylluncunata pampayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abrahamta Dios Yaya äningan tiempu chämunanpag ichicllana faltaycaptinmi, Israel runacuna Egiptocachö maytsicagna mirayashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tsay witsanmi Joséta mana regeg juc rey Egiptochö mandacur gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tsay reymi marcantsicta llullatsirnin engañar, unaycag aylluntsiccunata alläpa maltratar, tsayrag yurig ollgo wamrancuna wañuyänanpag obligarnin mandacur nirgan: ‘Llullu wamrayquicunata jitariyay wañuyänanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tsay tiempuchömi Moisés yurisquir Dios Yayata cushitsirgan. Taytancunanam quimsa quilla wajincunachö pacayllapa catsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Taytanwan maman wajipita jucläman pacarnin dëjasquiyaptinam, faraonpa warmi tsurin taricusquirnin gorisquir quiquinpa wawantanö geshpitsicurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsaynöpam Moisésga Egiptocunapa yachaynincunawan yachatsishga car, parlayninchöwan imayca rurayninchöpis cumplïdu poderöso cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chuscu chunca watayogna caycarmi, Moisésga quiquinpa marcanchö israelmajincunata watucagnin aywayta yarparnin aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tsaynö watucagnin aywashga caycaptinmi, Egipto runa juccag marcamajinta maltratagta ricaycur, Moisésga janan shärir vengarnin Egipto runata wañuscatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tsaynöpam Moisésga yarpargan, Israel waugencuna tantiyayänanta paywan Dios Yaya llapan marcamajincunata libratsinanpag canganta. Pero marcamajincunaga manam ni jucta tantiyacuyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Waränin allegnam Moisésga ishcag Israel runacuna maganacuycäyagta tarisquir, washarnincuna amistatsiyta munar nirgan: ‘Gamcunaga juc casta waugenölla caycar, ¿imanirtan quiquiquicunapura maganacur caycäyanqui?’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero tsay marcamajinta magaycag runam, Moisésta läduman cunjasquirnin nirgan: ‘¿Pitan gamta churashushcanqui, nogacunachö imayca mandayämagnï jueznö canayquipag? ");
INSERT INTO qxnNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Gamga wañutsimaytacu munanqui, ganyan Egipto runata wañutsingayquinö?’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tsayta wiyaycurnam Moisésga Madian niyangan marcaman mantsacashga geshpirnin aywacurgan. Tsay marcachö imayca jucläpita mana regeshga forastërunö täcuycaptinmi, ishcay tsurincuna yuriyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Tsaypita chunca chuscu watana Madian marcachö caycarmi, juc junag mana ni imacag tsunyag Sinaí jircaman Moisés aywargan. Tsaychönam shiraca cashachö nina lunyaycagnö juc angel yuripurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tsaynö nina lunyaycagta ricaycurnam, Moisés alläpa mantsacargan. Tsaypita mas shumag ricänapag witiycarnam, Dios parlamugta wiyargan: ");
INSERT INTO qxnNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nogam unaycag aylluyquicunapa Diosnin cä. Tsaynöllam Diosnin cä, unay aylluyquicuna Abrahampa, Isaacpa y Jacobpa.’ Tsaynö niptinnam, Moisésga mantsacaywan carcariarrag, ricaytapis valorargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tsaymi Dios Yaya nirgan: ‘Llangequita llushtiy. Tsay jaruycangayqui patsaga alläpa sagrädu. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Rasumpam noga Dios Yaya ricaycä servimagnï Israel runacunata alläpa ultrajar, Egipto runacuna maltratayanganta. Tsaynöpam paycuna nogaman llaquishga mañacayämunganta wiyashcä. Tsaymi paycunata libranäpag cielupita shamushcä. Tsaymi cananga shamuy Egiptoman aywanayquipag. Tsaypita Israel aylluyquicunata librarnin jorgamunayquipag.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Israel runacunam puntatana Moisésta niyargan: ‘¿Pitan gamta churashushcanqui, nogacunachö imayca mandayämagnï jueznö canayquipag?’ nir. Tsaynö despreciaycayaptinpis, quiquin Dios Yayam shiraca casha lunyaycagchö yuripugnin, angelwan mandargan, Egiptopita jorgamur israelcunapa libertadornin y mandacugnin cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tsaynö Egiptoman aywar unay aylluntsic israelcunata jorgamunanraycum, Dios Yayapa poderninwan mantsacaypag tucuyläya milagrucunata Moisés rurargan. Egiptopita Israel runacuna päsayänanpagmi, lamar Rojo niyanganpa nänita quichargan. Tsaypitanam israelcuna chuscu chunca wata mana ni imacag tsunyachö caycäyaptin, milagrucunata rurargan llapan micuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tsay quiquin Moisésmi Israel runacunata nirgan: ‘Quiquin Dios Yayam gamcunapita juc Profëtata churanga noganö cananpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Quiquin Moisésmi tsay mana ni imacag tsunyagchö llapan Israel runacunawan goricashga, Sinaí jircachö parlapagnin angelwanpis caycargan. Unay awiluntsic Moisésmi Dios Yayapa cawatsicug Palabranta Sinaí jircachö chasquisquir, nogantsicta dëjapamashcantsic. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero unaycag aylluntsiccunaga mana cäsurnin despreciarmi, llapan shongoncunawan Egipto marcaman cuticuyta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tsaynam Aaronta niyargan: ‘¡Juc diosnintsic ruramuy pushamänanpag, manam musyantsictsu tsay Egiptopita jipimagnintsic Moisésta ni ima päsangantapis!’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsaypitanam goripita juc ïdolota imayca becerroricugllata quiquincuna rurasquir, wätacunata wañutsirnin sacrificiuta rurar tsay ïdolopag fiesta rurayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tsaynö cayanganpitam Dios Yaya paycunapita raquicasquir dëjasquirgan, altu cieluchö rupaytawan quillata y lucërocunata adorarnin cayänanpag. Tsaynö cananpagmi Dios Yayapa willacugnin unay profëtancuna gellgayangan libruchö nirgan: ‘Israel runacuna, ¿Acäsu gamcunaga tsunya mana ni imacagchö chuscu chunca wata caycar, sacrificiucunatawan garaycunata ofreceämashcanquicu? ");
INSERT INTO qxnNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","¡Manam! Tsaynö ofreceyämangayquipa rantinmi, dios Moloctawan Refan niyangan lucërota matancashga puritsiyargayqui. Tsay dioscunapa imäjinnincunata quiquiquicunam paycunapa wajin rurayargayqui adorayänayquipag. Tsaynö cayangayquipitam gamcunataga, Babilonia marcapita mas caruman gargornin jitariyäshayqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Mana ni imacag tsunyachömi unay aylluntsiccunapa tabernäculo niyangan iglesian cargan. Tsay iglesiatam Moisés ruratsirgan, Dios Yaya ricätsingan plänowan iwalllata. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Unaycag aylluntsiccunam chasquiyargan cay tabernäculo niyan iglesiata, imayca juc erenciatanö. Josuéwan shamugcunam pagtan apayämurgan, juclä marca runacunata guerrachö vencesquirnin. Tsay juclä marca runacunatam quiquin Dios Yaya cay marcancunachö täcugcunata gargorgan, unay aylluntsiccuna duëño cayänanpag. Cay Israelchömi rey Davidpa tiempunyag tsay tabernäculo iglesiatapis catsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Rey Davidmi Dios Yayapa ricänanchö alli rurag cayninwan, Jacobpa Diosnin täcunanpag juc templuta ruratsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero Salomónmi Dios Yayapa templuntaga ruratsirgan, ");
INSERT INTO qxnNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","aunqui alläpa poderöso Dios Yaya runacuna maquincunawan rurayangan templuchö mana täcuycaptinpis, Dios Yayapa unay willacug profëtan ningannö: ");
INSERT INTO qxnNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Cielu jamacunä captinmi, cay patsaga chaquï jarucunan. ¿Imanö wajitarag rurayämunga? ninmi Señorga. ¿May sitiurag shütanäpag canga, ");
INSERT INTO qxnNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","si nogalla cay llapan imaycacunata rurashga caycaptïga?’ ” ");
INSERT INTO qxnNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pero Estebannam parla sïgirgan: “¡Gamcunaga mana ni ima entendig mana ricag alläpa chucru shongo mana wiyacugmi cayanqui! ¡Tsaynö carmi gamcunaga imaypis Espïritu Santopa contranlla caycäyanqui, unay aylluyquicunawan iwallla! ");
INSERT INTO qxnNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Maygancag profëtatatan unaycag aylluyquicuna maltratarnin mana gaticachäyargantsu? Tsay unaycag aylluyquicunam Diospa jutsannag Tsurin shamunanpag willacug profëtacunata wañutsiyargan. Tsaymi canan gamcunaga cay patsaman shamushga caycaptin, traicionarnin wañutsiyashcanqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gamcunaga Dios Yayapa angelnincunapita leycunata chasquishga caycarpis, manam ni juc cäsucuyanquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tsay llapan ningancunata wiyaycurnam, autoridäcuna rabiarnin quiruncunatapis regochyätsirrag Estebanta alläpa chiquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Estabannam Espïritu Santowan junta car, altu cieluman ricarcurnin chipacyarrag poderöso Dios Yayatawan derëchucag lädunchö Señor Jesucristo ichiraycagta ricasquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tsaynam nirgan: “¡Ricäyay! Cielu quicharaycagchömi ricaycä Dios Yayapa derëchucag lädunchö Señor Jesucristo ichiraycagta.” ");
INSERT INTO qxnNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero tsay runacunaga rinrincunata tsapasquirmi, alläpa jinchi gayaycachar Estebanta magayänanpag llapan achcusquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tsay marcapita jucläman garacharnin jipisquirmi, tsaychö alli sagmayargan. Tsaynö acusagnin runacunam, Estebanpa llatapancunatapis juc jöven Saulo niyanganpa chaquin puntanman cuidananpag dëjapuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tsaychö sagmaycäyaptinmi, Esteban mañacur nirgan: “Señor Jesucristo, almalläta chasquiycullay.” ");
INSERT INTO qxnNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsaynö mañacusquirnam gongoricuycur jinchi gayarargan: “¡Señor, jutsata rurar cay wañutsiyämag runacunata ama culpatsaytsu!” Tsaynö nisquirmi wañusquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tsaychömi jöven Saulopis Estebanta wañutsiyaptin, “Allichömi wañutsiyanqui” nir cushishga caycargan. Tsay junagllam Señor Jesucristoman Jerusalénchö criyicugcunata alläpa chiquirnin gaticachar gallaycuyargan. Tsaynö alläpa chiquirnincuna gaticachäyaptinmi, llapan criyicugcuna maytsaypa witsicarnin entëru Judeapawan Samariapa aywacuyaptin, apostolcunallana Jerusalénchö quëdayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Waquincag llaquipäcug alli runacunam Estebanpa ayanta gorisquir, alläpa llaquishga wagarnin pampacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero Saulonam llapan criyicugcunaman wajin wajin aywarnin, warmitapis y ollgotapis garachashga carcelman gaycatsig apatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero Jerusalénpita geshpirnin aywacug criyicugcunanam, maytsaypa aywarpis rasumpacag salvaciunpag Alli Willacuyta yachatsicurnin willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Paycunapita jucnin Felipenam Samaria jatun marcaman aywaycur, Señor Jesucristopag willacur gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Maytsicag runacuna goricasquirmi llapan shumag wiyayargan Felipe parlangata. Tsaynöllam Felipe tucuyläya señal milagrucuna rurangantapis llapan ricäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Atscag runacunapitam supaycunapis jinchi gayaycacharnin yargoyargan. Tsaynöllam maytsicag cuerpun mana cuyog runacunawan ratacuna y mancucunapis llapan cuticäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tsaynö llapan imaycata Felipe ruraptinmi, tsay marcachö llapan runacuna alläpa cushishga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tsay Samaria marcachömi juc runa Simón shutiyog cargan. Paymi unayga brüju cayninwan runacunata mantsacätsirnin mas importanti alli yachayyogtucur Samaria marcachö llapan runacunata engañashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tsay brüju parlangantam llapan runacuna umilde wactsacunapita gallaycur, asta mas mandacuyyog poderyog runacunapis criyirnin niyag: “Cay runam sïga Diospa rasumpa poderninwan ‘Alläpa Poderöso Yachayyog.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tsay Simóntam llapan cäsurnin gatiräyag, unaypitana brüju cayninwan mantsacaypag señalcunata rurarnin llapan runacunata engañashga captin. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero Señor Jesucristopa Alli Willacuynintawan Dios Yayapa Mandacuy Reynonpag Felipe willacuptin criyisquirnam, warmipis ollgopis llapan bautizacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tsay quiquin brüju Simónpis Señor Jesucristoman criyirnin bautizacusquirmi, Felipepa pagtan purir gallaycurgan. Payga criyirgan alläpa cushicuypag señalcunatawan mantsacaypag milagrucuna ruranganta ricashga carmi. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalénchö caycag apostolcuna Diospa Palabranta Samaria marcachö runacuna chasquiyanganta musyasquirmi, Pedrotawan Juanta cachayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tsayman chaycurnam Dios Yayaman mañacuyargan, Samaria marcachö criyicugcuna Espïritu Santota chasquiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tsay criyicugcunamanga manaran Espïritu Santo shamushgaragtsu cargan, Señor Jesucristopa shutinllachörag bautizacushga cayaptin. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tsaynam Pedrowan Juan maquincunata paycunapa umancunaman churayaptin, Espïritu Santota chasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tsay brüju Simónnam apostolcuna runacunapa umancuna jananman maquincunata churayaptin Espïritu Santo shamugta ricarnin, gellayta ofrecernincuna nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Tsay poderniquicunata ranticaycayämay nogapis pï runacunapa umanmanpis maquïta churaptï, Espïritu Santota canan chasquiyangannölla chasquiyänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tsaynam Pedro contestargan: “¡Gellayniquiwan ishcayqui condenashga cayay, Dios Yaya voluntäninwan garamangantsicta, gellayniquiwan rantiyta puedinayquipag yarpangayquipita! ");
INSERT INTO qxnNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gampaga manam ni ima derëchuyqui cantsu tsay poderta chasquinayquipag, Dios Yayapa puntanchö alläpa mana alli yarpag shongoyog cangayquipita. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tsay mana alli rurayniquita dëjasquir Dios Yayaman mañacurnin rasumpa arepenticuy. Payga maypischi shongoyquichö tsaynö yarpangayquicunata perdonashunquiman. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gamtag ricag alläpa rabiarnin piñashga caycagta, tsay mana alli yarpayniquiwan rurayniquicuna imayca prësutanö catsishuptiqui.” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tsay brüju Simónnam contestargan: “Gamcuna nogapag Señorman mañacuyay, cay llapan niyämangayquicuna mana päsaycallämänanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tsaynö Diospa Palabranta yachatsicurmi, apostolcunaga Señor Jesucristopa Alli Willacuyninta Samaria marcapa atsca estanciancunachö willacur, Jerusalénman cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tsaypitanam Señorpa juc angelnin Felipeta nirgan: “Sharcurnin caypita uraypa ayway, Jerusalénpita Gaza marcaman aywag nänipa. Tsay näniga mana ni imacag tsunyapam päsan.” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tsaynam Felipega jina öra sharcurnin aywaycar, Etiope runawan tincuyargan. Tsay “eunuco” niyangan runaga Etiopia marcachö reyna Candace niyangan warmipa llapan imaycanchö mas mandacug encargädo caycarmi, Jerusalénman Dios Yayata adorag aywashga cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tsay Jerusalénpita marcanman cuticurnam, cawallucuna garachangan cärronchö jamaycur unay profëta Isaías gellgangan libruta liyiraycar aywaycargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espïritu Santonam Felipeta nirgan: “Ayway. Tagay cärroyog runaman witiycuy.” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe lädunman chaycurnam tsay Etiope runa unay profëta Isaías gellgangan libruta liyiycagta wiyargan. Tsaynam tapurgan: “¿Gam entendinquicu tsay liyiycangayquita?” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tsay Etiope runanam contestargan: “¿Imanörag entendishag pipis mana entenditsimagnï captinga?” Tsaynam Felipeta rugargan cärronman lätarcur pagtan lädunman jamananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tsay liyiycangan Diospa Palabran gellgashgaga, caynömi nirgan: “Imayca juc üshata pishtayänanpagwan rutuyänanpag apayaptin upallalla car, imayca juc mallwa cordërunö manam ni juc ichicllatapis wagagnömi, Payga shiminta quichargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Llapan runacuna burlacuyaptinpis, mana ni ima justicia captinmi, Paypa jananga ni pipis cargantsu. ¿Pirag parlanman, Payman maytsicag criyicug miraynincunapag? Paypa cawayninga cay patsapita imayca jipishganömi cargan.” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tsay Etiopiapita eunuco niyangan runanam Felipeta tapurgan: “Willaycallämay, profëta Isaías gellganchö ¿pipagtan nican? ¿Quiquinpagcu o juc runapagcu?” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tsaynam Felipega liyinganpita gallaycur, tsay Etiope runata shumag entenditsirgan, Señor Jesucristo Alli Willacuynin imanö canganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Tsaynö parlar nänipa aywaycarnam mas ratïtunllatana yacuta tariyargan. Tsay yacuta tarisquirmi Etiope runa nirgan: “Caychömi yacu caycan. ¿Manacu nogata canan öra bautizascamanquiman?” ");
INSERT INTO qxnNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsaynam cärronta ichiytsinanpag mandarnin ichiscatsir, cärropita ishcan yarpusquir yacucagman urarpur Felipe bautizargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yacupita yargoycaptinnam Espïritu Santo Felipeta apasquiptin, tsay Etiope runaga ricargannatsu. Pero tsay Etiope runaga alläpa cushishgam, nänipa aywacur sïgirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tsaypitanam Felipega Azoto niyangan marcachö yuricasquir, Señor Jesucristopa Alli Willacuyninta marcan marcan yachatsicur purirgan, asta Cesarea marcaman changanyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tsayyagnam Saulo Señor Jesucristoman llapan criyicugcunata rabiaparnin wañutsinanpag amenasar dëjargantsu. Tsaynöpam mas mandacugcag sacerdötipita, ");
INSERT INTO qxnNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","juc autorisacion cartata mañargan, Dios Yayaman mañacuyänanpag Damascochö goricäyangan wajiman, Señor Jesucristoman llapan criyicur shumag cawacugcunata ashignin aywananpag. Tsaynö criyicug ollgocunatawan warmicunatapis, Jerusalénman prësurnin apananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero Damasco marcaman chaycaptinnam, cielupita alläpa chipacyag actsi illagpita entërunman tumat atsicyaycamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsaynam Saulo patsaman shicwasquir, juc voz nimugta wiyargan: “Saulo, Saulo, ¿imanirtan gaticachämanqui?” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulonam tapurgan: “¿Señor, pitan canqui?” Tsay voznam contestargan: “Nogagam cä, tsay gaticachangayqui Jesús.” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sharcurnin aywar Damasco marcaman yaycuy. Tsaychömi imata ruranayquipagpis willayäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulowan pagtan aywag runacunanam tsay vozta wiyaycur alläpa mantsacayargan. Pero paycunaga manam ni pitapis ricäyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tsaypitanam Sauloga patsapita sharcurnin ñawinta quichasquir ricchacuyta munarpis ni imata ricayta puedirgannatsu. Tsaynö ruracasquiptinmi, pagtan aywag runacuna maquipita janchashgallana Damascoman chätsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tsaychönam quimsa junag gaprayashga mana ricarnin, ni imata micurgantsu ni upyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tsay Damascochönam juc criyicug Ananias shutiyog runa täcurgan. Paytam Señor yuripusquir revelarnin nirgan: “¡Ananias!” Paynam contestargan: “Señor, caychömi caycällä.” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Señornam nirgan: “Sharcur ayway ‘Derëchucag’ niyangan cällichö Judáspa wajinman. Tsayman chaycur tapucunqui Tarsopita Saulo shutiyog runapag. Paymi mañacurnin, ");
INSERT INTO qxnNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","juc revelaciunchö ricashga Ananias shutiyog runa yaycusquir, umanman maquinta churaycuptin yapay ñawin ricayta puedigtana.” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Tsayta wiyaycurnam Ananias nirgan: “Señor, tsay runapagga atscag runacunam willayämashga, Jerusalén marcachö mana allicunata rurarnin llapan santo criyicugniquicunata alläpa maltratanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y cananga caymannam shamushga sacerdöticunapa mas mandagnincag sacerdöticunapita autorisacionta jipisquir, gamman mañacurnin criyicamugcunata prësu apatsinanpag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero Señornam nirgan: “¡Jina öra ayway! Nogam tsay runata acrashcä nogapag juclä caru naciuncunachö runacunata willacunanpag. Tsaynöllam willacunga tsay naciuncunapa reynincunatawan llapan Israel runacunatapis. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nogam ricätsishag nogaraycu alläpa sufrinanpag canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsaypitanam Ananiasga Saulo posadacungan wajiman aywargan. Yaycusquirnam paypa umanman maquinta churarcur nirgan: “Wauge Saulo, cay marcaman shamuycangayqui nänichö yuripushugniqui Señor Jesucristom, canan cachamashga gampa ñawiqui cutiscasquiptin Espïritu Santopa poderninwan junta canayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tsay öram Saulopa ñawinpita imayca tsaparaycagnö shicwasquiptin, ñawin cuticasquirgan. Tsaypita sharcuptinnam Ananias bautizargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tsaypitanam micuyta micusquirnin, yapay callpayogna cargan. Tsay Damascochö täcug criyicugcunawanmi juc ishcay junagcunayag quëdargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsaypitanam Sauloga Dios Yayaman mañacuyänanpag goricäyänan wajicunachö Señor Jesucristo Diospa Tsurin canganta willacur gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tsay llapan wiyagnin runacunam alläpa mantsacashga car niyargan: “¿Manacu cay runaga, Señor Jesucristopa shutinchö mañacur criyicugcunapa contran runacunata timpullyätsir Jerusalénchö gatichagnin? ¿Manacu payga quiquin cay marcantsicman shamurgan llapan criyicugcunata prësu aparnin, Jerusalénchö mas mandacug sacerdöticunaman entregananpag?” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Sauloga cada vez mas valorninwan parlarnin Señor Jesucristoga Diospita rasumpa shamushga canganta willacuptinmi, Damascochö täcug judiucunaga ni imanö caytapis puediyargantsu. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tsaynö unayyagna yachatsicur captinmi, judiucunaga Saulota wañutsiyänanpag willanacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero Saulonam tsay willanacuyanganta musyasquirgan. Judiucunanam tsay marcapita yargoyänam nänicunachö pagasta junagta shuyaräyargan, Saulota wañutsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero criyicugcunanam juc jatun canastaman wiñarcur, pagasllapa tsay marcapa murällanchö ventänapa wagtaman bäjatsiyargan. Tsaynöpam Saulo geshpirnin aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jerusalénman Saulo chaycurnam, Señor Jesucristoman llapan criyicugcunawan goricayta munargan. Pero llapan criyicugcunanam Saulotaga mantsayargan, payga Señor Jesucristoman mana rasumpa criyinganta yarpar. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero tsaynö Saulota mantsaycäyaptinmi Bernabe apostolcunaman regetsignin apargan. Bernabenam apostolcunata willargan, Señor Jesucristota Saulo nänichö ricangantawan Señor Jesucristo parlapanganta. Tsaynöllam willargan Damascochö llapan voluntäninwan Señor Jesucristopag willacurnin Saulo yachatsicungantapis. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tsaynömi Sauloga Jerusalénchö paycunawan quëdasquirmi, pagtancuna librina purirgan. Tsaynö purirmi Señor Jesucristopag mana ni imapita mantsacur willacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tsaynö willacur puringanpitam griego parlag judiucunawan parlarnin discutinacuyargan. Pero tsay judiucunaga imaycanöpam Saulota wañutsiyta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tsaychö judiucuna Saulota wañutsiyänanpag yarpäyanganta musyasquirnam, llapan criyicugcuna Cesarea marcaman Saulota apaycur, Tarso marcanman aywacunanpag despachayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsaypitanam Judeachö, Galileachö y Samaria marcachö llapan criyicugcunapis alli päsacuychö shumag cawacurnin, criyicuynincunachöpis imayca wiñagnö mas firmi cayargan. Dios Yayapa munayllanta rurar cumplirmi, Paypita mantsacurnin shumag alli cawacur Espïritu Santo consolarnin yanapaptin cada junag mas atscag yapacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedronam llapan criyicugcunata visitarnin maytsaypa purir, Lida marcachö criyicugcunata visitanin aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tsaychömi Eneas shutiyog runa, pusag watana puñunanllachö cuerpun mana cuyuptin caycagta tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedronam nirgan: “Eneas, Señor Jesucristom cuticätsishunqui. Sharcurnin puñunayquita shumag allitsay.” Tsaymi Eneasga, jina öra cuticashgana sharcamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tsaynam Lida marcachöwan entëru Saron marcachö täcug runacuna, tsay runa cuticangata ricaycur Señor Jesucristoman rasumpa criyicurnin Dios Yayaman cutiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tsay tiempum Jope marcachö juc criyicug Tabita shutiyog warmi cargan. (Tsay Tabita ninagan griego parlaychöga cargan, Dorcasninanmi.) Tsay warmim alläpa alli cayninwan imaypis llapan faltapucugcunata yanapar allillata rurarnin shumag cawacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tsaynö shumag cawacur caycarmi, Dorcasga geshyagyasquir wañucurgan. Tsaynö wañusquiptinmi cuerpunta armascatsirnin, altuschö cuartoman shütayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tsaynam Jopepita Lidaman amänolla captin, tsaychö Pedro caycanganta musyarnin llapan criyicugcuna ishcag runacunata mandayargan caynö niyänanpag: “¡Jina öra, gam shamuycullay Jope marcaman mana juc demorarlla!” ");
INSERT INTO qxnNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedronam paycunawan aywargan. Tsayman chaycuptinnam Dorcaspa ayan caycangan cuartoman pushayargan. Tsay cuartochömi, atscag viudacuna wagaraycar Pedrota entërumpa juntapusquir, Dorcas cawaycarllarag rurapangan llatapancunatawan tünicancunata ricätsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedronam wagtaman llapanta gargosquir gongorpacuycurnin, Dios Yayaman mañacurgan. Mañacur ushasquirnam, Dorcaspa ayanman tumaycur nirgan: “Tabita, shärimuy.” Tsaynam Dorcaspa ñawin quichacasquiptin, Pedrota ricaycur saslla jamarcamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedronam maquipita achcurcur sharcatsimurnin, llapan criyicugcunatawan viudacunata gayascatsir cawaycagtana entregargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tsay Dorcas wañunganpita cawamunganta entëru Jope marcachö runacuna jancat musyasquirmi, Señor Jesucristoman maytsicag criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedronam Jope marcachö atsca junag quëdargan, suela rurag Simón niyangan runapa wajinchö. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tsay Cesarea marcachömi, juc runa Cornelio shutiyog Italiana tröpapa juc pachac soldäducunapa capitannin cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tsay runam alläpa alli cayninwan wajinchö llapan aylluncunawan pagta, Dios Yayata alläpa respetar adorayag. Tsaynöllam faltäpucug wactsacunata atsca gellayninwan yanapar, Dios Yayaman imaypis mañacurnin cawacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Juc junagmi las tres gaycucuy örana, juc revelaciunchö Dios Yayapa juc angelninta cläru ricargan. Tsay angelmi pay caycanganman yaycusquir nirgan: “¡Cornelio!” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tsaynam Cornelioga angelta ricaycur, alläpa mantsacashga tapurgan: “¿Señor, imallatatan munanqui?” Angelnam nirgan: “Dios Yayam mañacungayquita wiyarnin llapan faltapucugcunata llaquipar yanapangayquita chasquishushcanqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Canan runacunata cachaycuy Jope marcachö Pedro niyangan Simón caycagta, cayman pushayämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Paygam caycan suela rurag juc Simónpa lamar cuchun wajinchö patsacushga.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tsaynö parlapasquir angel aywacusquiptinnam, Cornelioga Dios Yayata adorag confiacungan soldäduntawan ishcag servignin runacunata gayatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tsay quimsan runacunata Cornelio gayascatsirnam, angel llapan ninganta cuentasquir Jope marcaman cachargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Waränin pullan junagnam Jopeman yaycuycäyaptinna, Pedro waji janan altunman lätarcur, Dios Yayaman mañacuycargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tsaychömi mallagarnin micuyta munargan. Pero micuyta preveniyanganyagnam, Pedro juc revelaciunta ricargan: ");
INSERT INTO qxnNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Cielu quicharaycagpita imayca jatun säbanasnö chuscun puntanpita watashga cay patsaman uraycämugta. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tsay säbanaschönam tucuyläya chuscun chaquinpa purig wätacunawan culebracuna y pishgocuna cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tsaynam cielupita juc voz nimugta wiyargan: “Pedro, sharcur cay wätacunata pishtasquir micuy.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedronam contestargan: “Manam Señor; nogaga manam ni imaypis micushcätsu, gam proibimangayqui tagra jutsa ruratsicug mana allicunataga.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tsay voznam yapay parlaparnin nimurgan: “Dios Yaya limpiangantaga, ama ni imaypis ‘tagra mana allim’ ninquitsu.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tsaynö quimsa cuti parlapasquiptinmi, tsay säbanaspis quimsa cuti bäjascamur cieluman cutisquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tsaynam Pedroga alläpa yarpachacur caycargan, tsay revelaciunwan Dios Yaya ricätsimanganga ¿imapagrag? nir. Tsaynö yarpachacur caycaptinnam, Cornelio mandangan runacuna suela rurag Simónpa waji puncunman tapucurnin chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tsayman chaycurnam gayacur tapucuyargan, Pedro shutiyog Simón tsaychö patsacushga canganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedroga revelaciunchö ricanganpag yarpachacurnin caycaptillanragmi, Espïritu Santo nirgan: “Ricay, quimsag runacuna ashiycäyäshunqui. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sharcurnin bäjasquir, paycunawan pagtan ayway mana mantsacurlla, nogam tsay runacunata cachamushcä.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedronam altupita bäjascamur, runacunata nirgan: “Nogam cä, gamcuna ashiyangayqui runa; ¿imallapagtan shayämurgoyqui?” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Runacunanam contestayargan: “Nogacunam shayämushcä Dios Yayata alläpa respetarnin allicunallata rurar cawacug Capitan Cornelio cachayämaptin. Tsay llapan judiucuna cuyarnin respetayangan Corneliotam Dios Yayapa juc santo angelnin nirgan: ‘Gam Cornelio, wajiquiman gayatsimuy Simón Pedrota, shamuycur llapan willashungayquita wiyanayquipag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsaynam Pedro wajiman yaycascatsir posadatsirgan, paywan tsay pagas quëdacuyänanpag. Tsay waränin allegnam, Pedro pagtancuna aywaptin Jope marcachö waquincag criyicugcunapis compañayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tsaypita waränin junagnam Cesarea marcaman chäyargan. Tsay marcachömi Corneliota llapan aylluncunatawan cuyay amïgoncunta invitarnin gorishga shuyaraycagta tariyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro Corneliopa wajiman yaycuycaptinnam, Cornelioga tincusquir Pedropa chaquinman umpuycur adorananpag gongorpacuycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedronam sutarcur nirgan: “Ichiy, nogapis gamnö runallam cä.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tsaynam Pedroga Corneliota parlaparnin mas rurinman yaycusquir, atscag runacuna goricashga caycagta tarirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedronam nirgan: “Gamcunaga musyayanquim noganö juc judiu runata, juclä mana regeshga runacunawan parlarnin wajinmanpis mana yaycunapag Israel runacunapa leynin proibinganta. Pero Dios Yayam nogataga yachatsimashga, cananpitaga manana ni pitapis imayca ‘Mana alli rurag jutsayogmi canqui’ ninäpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tsaymi nogaga gamcuna gayatsiyämaptiqui mana ni imapita mantsacur saslla shamurgö. Cananmi musyayta munä, imapag gayatsiyämangayquita.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelionam contestargan: “Chuscu junag päsashgachönam caynö öra, las tres gaycucuy öra, cay wajïchö tardipa Dios Yayaman mañacuycaptï, alläpa shumag chipacyag llatapashga juc runa yuripascamar, ");
INSERT INTO qxnNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nimargan: ‘Cornelio, Dios Yayam mañacungayquita wiyashushcanqui. Tsaynöllam yarpashga llapan faltapucug wactsa runacunata yanapar allicunallata rurangayquitapis. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Runacunata Jope marcaman cachay, Pedro shutiyog Simónta wajiquiman pushayämunanpag. Payga lamar cuchunchö täcug suela rurag Simónpa wajinchömi, patsacushga caycan.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tsaynöpam gamta ashigniqui saslla cachacamuptï, alli voluntäniquiwan shallämurgoyqui. Tsaymi cananga llapantsic Dios Yayapa puntanchö caycar, llapan willayämänayquipagcagta Señor Jesucristo mandashungayquita wiyayta munayä.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsaynam Pedro parlarnin gallaycur nirgan: “Cananmi sïga entendirgö, juc runawan juccag runapis Dios Yayapagga iwallla cayanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dios Yayagam Payta cäsurnin llapan alli ruragcunata, may naciunpitawan pipa castan cayaptinpis iwallla chasquin. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Quiquin Dios Yayam Israel runacunapa aylluncunata parlaparnin, Alli Willacuyninta llapan imayca camashgapa Señornin, Señor Jesucristowan willacatsirgan, llapan shumag alli päsacuychö cawacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gamcunaga rasumpam musyayanqui Juan Bautista runacunata bautizarnin, Galileapita gallaycur judiucunapa entëru marcancunachö ima päsanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tsaynöllam musyayanqui Dios Yayaga llapan podernintawan Espïritu Santonta, Nazaretpita Señor Jesucristoman juntag churanganta. Tsaynöpam Señor Jesucristoga llapan imayca allicunallata rurarnin, Supay poderninwan sufritsingan runacunatapis cuticätsir purirgan. Tsay llapantaga Señor Jesucristo rurayta puedirgan, quiquin Dios Yaya paywan captinmi. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Nogacunam entëru Judeachö y Jerusalénchö llapan imaycata Señor Jesucristo ruranganpa testïgun cayä. Tsaynö llapanta rurar caycaptinpis, cruzman warcarcurmi wañutsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero Dios Yaya quimsa junagllata cawascatsimuptinmi, nogacunata Señor Jesucristo yuripayämargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Manam llapan runacunatawantsu yuripayämargan, sinöga Dios Yaya testïgun cayänäpag acrayämangan runacunallatam. Tsaymi nogacunaga Pay cawascamuptin, pagta micur y upyar cayargä. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Paymi nogacunata mandayämargan, Dios Yaya Señor Jesucristota maytsaychö cawagcunapawan wañushgacunapa mandagnin cananpag churangan llapan runacunata willacuyänäpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tsaymi unay profëtacunapis Señor Jesucristopag willacuyashgana cayargan, pipis Payman criyicugcagga Payta shutinchö llapan jutsanpita perdonashga cananpag canganta.” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tsaychö Pedro parlaycaptillanragmi, llapan wiyaycagcunaman Espïritu Santo shamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Puntata judiu cayanganpita criyicushgacuna Pedrowan aywagcunam, Espïritu Santota mana judiucagcunapis juntat chasquiyanganta ricar, alläpa mantsacashga cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Paycunam wiyayargan tucuyläya mana regeshga parlaycunachö parlarnin, Dios Yayata alabayagta. Tsaynam Pedro nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“¿Acäsu manacu cay runacuna bautizashga cayanman Espïritu Santota nogantsicnö iwallla chasquishga caycarga?” ");
INSERT INTO qxnNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tsaypitanam Pedro mandacurgan, Señor Jesucristopa shutinchö bautizacuyänanpag. Tsaynö bautizacusquirnam, Pedrota rugayargan paycunawan juc ishcay junagcuna quëdananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolcunawan Judea provinciachö criyicugcunam, mana judiucag runacunapis Diospa Palabranta chasquiyashga cayanganta musyasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Tsaynöpam Pedro Jerusalénman cutisquiptin waquincag criyicug judiucuna rimarnin piñacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tsaynam tapuyargan: “¿Imanirtan mana judiucag runacunaman visitagnin aywar, paycunawan micurgayqui?” ");
INSERT INTO qxnNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedronam gallarinanpita gallaycur llapan ima päsanganta willarnin nirgan: ");
INSERT INTO qxnNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nogam Jope marcachö caycarnin Dios Yayaman mañacuycar, juc revelaciunchö ricargä: Cielupita imayca jatun säbanas chuscun cuchunpita watashganö urämur nogaman chämugta. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tsay säbanasnö bäjamug rurinchö ima canganta shumag ricänäpag gawaycurmi, chuscun chasquishga wätacunata y tucuyläya chucaru wätacunatawan culebracunata y tucuyläya pishgocunata ricargä. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tsaynam cielupita juc vozta wiyargä: ‘Pedro, sharcurnin cay wätacunata pishtasquir micuy’ nimagta. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Noganam contestargä: ‘¡Manam, Señor! ¡Manam ni imaypis micushcätsu cay proibimangayqui tagra mana alli ruratsicug wätacunataga!’ ");
INSERT INTO qxnNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Tsaynam cielupita voz yapay parlapämar nimargan: ‘Dios Yaya limpiangantaga ama gamga ni imaypis “tagra mana allim” ninquitsu.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tsaynömi quimsa cuti parlapämaptin, tsay säbanasnö bäjamugpis quimsa cuti bäjascamurnin, cieluman cutisquirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Tsay öram Cesareapita cachayämungan quimsag runacuna, ashiyämarnï patsacungä wajiman chäyämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tsaymi Espïritu Santo mandamargan mana ni imapita mantsacurnin, paycunawan pagta aywanäpag. Caychö caycag sogtan criyicug waugentsiccunawanpismi Cesareaman aywar, gayatsimag Corneliopa wajinman llapä yaycuyargä. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tsay runam willayämargan juc angel wajinchö yuricasquirnin ichiycur ninganta: ‘Cornelio, runacunata cachay Jope marcachö Pedro shutiyog Simónta cay wajiquiman pushayämunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paymi willashunqui llapan aylluyquicunawan gam imanö salvacänayquipag canganta’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Tsaychö Diospa Palabranta willaycur gallaycaptïmi, Espïritu Santo paycunaman shamurgan nogantsicman puntata shamungannölla. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsaypitanam Señor nimanganta yarpasquirgä: ‘Rasumpam Juan Bautistaga yacullawan runacunata bautizargan. Pero gamcunam sïga Espïritu Santopa poderninwan bautizashga cayanqui.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Si Dios Yaya paycunata Espïritu Santonta garaycarga, nogantsicta garamangantsicnöllam paycunatapis Señor Jesucristoman rasumpa criyicuyaptin garanga. ¡Pitan nogaga cä, Dios Yayata amatsanäpag!” ");
INSERT INTO qxnNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pedro tsaynö llapan ninganta Jerusalénchö criyicug waugentsiccuna wiyaycurmi, upällasquirnin Dios Yayata alabarnin niyargan: “¡Dios Yayagam mana judiucunatapis Espïritu Santonta gararnin perdonashga, mana alli ruraynincunata dëjasquir arepenticurnin imayyagpis Dios Yayawan salvacar cawayänanpag!” ");
INSERT INTO qxnNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wañuscatsirmi, tsay runacuna Señor Jesucristoman criyicugcunata chiquirnin ashiyaptin, waquincag criyicugcuna Feneciapa, Chiprepa y Antioquia marcapa geshpirnin aywacuyargan. Tsaychömi tsay criyicugcuna Dios Yayapa salvacug Alli Willacuyninta judiucunallata willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tsaynö caycaptinpis Chipre marcachöwan Cirene marcachö waquincag criyicugcunam Antioquia marcaman chaycur, mana judiucag griegocunatapis Señor Jesucristopa Alli Willacuyninta yachatsicurnin willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dios Yayapa podernin paycunachö captinmi, unaycag mana alli ruraynincunata dëjasquirnin arepenticur, Señor Jesucristoman cutirnin maytsicag rasumpa firmi criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tsaynam Jerusalénchöcag criyicugcuna mana judiucag runacuna criyicuyanganta musyasquir, Bernabeta Antioquia marcaman cachayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tsayman Bernabe chaycurnam Dios Yaya llapan bendiciunninta mana judiucunaman churanganta ricaycur alläpa cushicurgan. Tsaynö cushicurmi Bernabega llapanta consejargan, Señor Jesucristoman llapan shongoncunawan firmi criyicurnin imaypis mana desanimacurnin cawacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tsay Bernabega alläpa alli runa rasumpa firmi criyicuyninwanmi Espïritu Santopa poderninwan junta cargan. Tsaynöpam maytsicag runacuna Señor Jesucristoman criyicurnin juntawacäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsaypitanam Bernabega, Saulota ashignin Tarso marcaman aywargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tsaychö tarisquirnam Antioqui marcaman pushargan. Tsaychönam Señor Jesucristoman criyicug runacunawan juc wata entëru pagta car, maytsicag runacunata willarnin yachatsiyargan. Tsay Antioquia marcachöragmi, Señor Jesucristopa discïpuluncunata “Cristianum cayan” niyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tsay tiempum Jerusalénpita juc profëtacuna, Antioquia marcaman uräyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tsaychömi juc profëta Agabo shutiyog ichircur, Espïritu Santopa poderninwan yachatsiptin willacur nirgan: “Cay Romapa entëru naciunnincunachömi alläpa llaquicuypag mallagäcuy muchuy canga.” Tsay profëta Agabo ningannöllam, Romachö Claudio niyangan mas mandacug emperador caycaptin tsaynö llapan päsargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tsayta musyasquirnam, Antioquiachö criyicugcuna segun imancunapis canganpita qorisquir, Judea marcachö criyicugcunata yanapar apatsiyänanpag willanacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tsaynö willanacur gorisquirnam, Saulotawan Bernabeta Judea marcachö respetashga auquin apostolcunaman apatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tsay tiempum rey Herodes waquincag criyicugcunata chiquirnin, magayänanpag gaticachätsir achcutsirnin gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tsaynam Juanpa waugen Santiagota wañutsiyänanpag mandaptin, espädawan wañuscatsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tsaynö wañuscatsiyaptin judiucuna alläpa cushicuyanganta rey Herodes ricarmi, Pedrotana gaycatsirgan. Tsaynöga cargan, levadürannag tantata micuyänan Pascua semana fiestachömi. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedrota achcuscatsirnam Herodes carcelman gaycascatsir, chunca sogta soldäducunata chuscug, chuscug cambianacur täpayänanpag churargan. Herodesga yarpargan Pascua fiesta päsasquiptinrag, llapan runacunapa puntanchö Pedrota juzgananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tsay carcelchö alli cuidagyog Pedro gaycuraycaptinmi, waquincag goricashga criyicugcunaga mana juc gelanar Dios Yayaman Pedropag mañacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tsaynam rey Herodes llapan runacunapa puntanman apatsinanpag warämug pagas, Pedroga ishcag soldäducunapa pagtan cadenawan alli watashga puñuycargan. Waquincag soldäducunanam carcel puncuchö cuidarnin täpaycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mana ni imacagpita Dios Yayapa angelnin yurisquiptinmi, carcel junta atsicyargan. Tsay angelnam Pedro puñucashgata costillachö cutaycur ricchascatsirnin nirgan: “¡Sas shäriy!” Tsaynö niycuptinmi, jina öra Pedropa maquinchö watashga cadenacuna shicwasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tsaynam angel nirgan: “Llatapacurcur llangeyquita shucucuy.” Tsay angel ninganta rurar Pedro ushasquiptinmi, angel yapay nirgan: “Cäpayquita shucucurcur gatimay.” ");
INSERT INTO qxnNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedronam angelpa gepanta yargosquir aywargan, rasumpa o mana rasumpa angel jipiycangantapis mana musyarlla. Pedroga mas bienmi sueñuyninchö tsaynö päsaycanganta yarpargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tsaynö yargor puntacag wardiacunapitawan juccag wardiacunapitapis päsasquirmi, cälliman yargonacag jatun fierro portädaman chäriyaptin puncupis quiquillanpita quichacasquirgan. Tsay carcelpita angel jipisquirmi, juc cuadrayag pagtan aywaycar quiquillantana jagesquir aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pedro tsayta tantiyasquirnam nirgan: “Cananmi sïga rasumpa musyarü, Dios Yaya angelninta cachamur, rey Herodespitawan llapan judiucuna imaycata rurayämänanpagcagpita libramanganta.” ");
INSERT INTO qxnNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pedro tsaycuna llapanta tantiyasquirmi, Juan Marcospa maman Maríapa wajinman aywargan. Tsay wajichömi atscag criyicugcuna goricashga Dios Yayaman mañacurnin caycäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tsayman chaycurnin wagta cälli puncupita tacacusquiptinnam, tsaychö yanapacug Rode shutiyog jipash pï canganta ricagnin yargamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedropa vozninta regesquirnam, puncutapis manana quichar alläpa cushishga cörrilla willacug cutirgan: “¡Pedrom puncuchö caycan!” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tsaynam niyargan: “¡Löcuca canqui!” Pero tsay jipashnam “Pedrom rasumpa caycan nirgan.” Paycunanam niyargan: “¿Manatsurag Pedropa alman canman?” ");
INSERT INTO qxnNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero tsaynö parlar cayanganyagnam, Pedroga wagtapita yapay yapay gayacurnin tacacuycargan. Tsay puncuta quichasquir Pedrota ricaycurnam alläpa mantsacaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero Pedronam maquinwan señasta rurarga upällalla cayänanpag. Tsaynam Dios Yayapa angelnin carcelpita imanö jipinganta paycunata willarnincuna yapay nirgan: “Cayta willayanqui Santiagotawan llapan criyicug waugentsiccunata” nisquirnam, tsaypita yargosquir jucläpa aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Patsa warasquiptinnam carcelta cuidag soldäducuna ni imanö caytapis puedir niyargan: “¿Pedrotaga imatan päsashga? ¡Mana ni ima päsangantapis musyantsictsu!” ");
INSERT INTO qxnNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tsaynam rey Herodesga wardiacunata cachargan Pedrota ashiyänanpag. Pero mana tariycuyaptinnam cuidagnin wardiacunata wañutsiyänanpag ordenargan. Tsaynö rurascatsirnam rey Herodesga Judeapita yargosquir Cesarea marcaman täcug aywacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tsaypitam rey Herodes Tiro y Sidon marcachö täcugcunawan alläpa piñashga captin, tsay runacuna willanacuyargan rey Herodesman rugagnin aywayänanpag. Tsaynö Cesareaman chaycurnam rey Herodespa alläpa confiansa servignin Blasto niyangan runawan amïgota armasquir, paywan rey Herodesta Tiro y Sidon marcachö runacunawan manana piñashga cananpag rugacatsiyargan. Tsaynö rugacatsirnin shumag päsacuytaga ashiyargan, rey Herodespa naciunninpita llapan wanayangantawan micuynincuna rantirmi. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tsaynam rey Herodesga tsay runacunata juc junagpag jitapurgan. Tsay jitapungan junag chäriptinnam, rey Herodesga mas allicag llatapanta shucucurcur, imaypis parlapäcamunancag jamacunaman jamaycur llapanta parlapämurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tsaychö maytsicag goricashga runacunanam gayaycachar gallaycur niyargan: “¡Cay parlapämagnintsicga manam juc runatsu, sinöga juc diosmi!” ");
INSERT INTO qxnNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tsaynam jina öra Dios Yayata respetarnin mana alabanganpita Paypa juc angelnin rey Herodesta geshyatsir shicwascatsirnin, curu micuypa wañuscatsirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tsaynö caycaptinpis Diospa Palabranga cada vez masmi maytsaypa mirargan. Tsaynöllam maytsaychö llapan runacunatapis Alli Willacuyta willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabewan Saulo ayüda apayanganta raquipurnincuna aruyta ushasquirnam, Jerusalénpita cuticuyargan jöven Juan Marcosta pusharcurnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquia marcachö goricarnin criyicug runacunachömi profëtacuna y yachatsicug maestrucuna cayargan: Bernabe, “Negro Simón,” Cirene marcachö yurig Lucio, Saulo y Manaen. Tsay Manaenga Galileachö mas mandacug rey Herodeswan, wajinchö pagta wiñagmi cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Juc junagnam llapan criyicugcuna ayunarnin Dios Yayata alabar caycäyaptin, Espïritu Santo nirgan: “Bernabetawan Saulota raquiyay noga acrarnincuna Diospa Palabranta willacurnin aruyänanpag churangäman.” ");
INSERT INTO qxnNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tsaynam criyicugcuna yapay goricaycurnin Dios Yayaman mañacurnin ayunasquir, Bernabepawan Saulopa umancunaman maquincunata churaycur, Espïritu Santo ningannölla despedirnincuna cachayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tsaynö Espïritu Santo mandaptinmi, Bernabewan Saulo Celeucia puertupita, Chipre ishlayag büquiwan aywayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tsay Salamina puertuman chärirnam, Dios Yayaman mañacuyänanpag judiucuna goricäyänan wajicunachö Diospa Palabranta yachatsicurnin gallaycuyargan. Juan Marcosnam paycunawan pagta aywargan, yanapagnincuna cananpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tsaynö Diospa Palabranta willacurnin tsay entëru ishlacunapa päsarmi, Pafos marcaman chaycur juc brüju judiu Barjesus niyangan runata tariyargan. Tsay runam llullacurnin llapan runacunata engañashga cargan: “Nogaga Diospa Palabran willacug profëtam cä” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tsay brüjum allish yachayyog gobernador Sergio Paulota yanapar purirgan. Tsaynam gobernador Sergio Pauloga Bernabetawan Saulota gayatsimurgan, Diospa Palabran willacuyanganta wiyayta munarnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero tsay brüjupam griego parlaychöga “Elimas” shutin cargan. Tsay Elimasmi gobernador Sergio Paulo apostolcuna Diospa Palabran willacuyanganman criyisquinanta amatsacurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tsaynam apostol Saulo shutiyog Pabloga Espïritu Santopa poderninwan junta car, brüju Elimasta alli ricaraycurnin, ");
INSERT INTO qxnNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nirgan: “¡Ä llulla mana alli rurag runa! ¡Gamga Supaypa tsurin carmi llapan alli ruraycunapa contran mana allicunata rurar caycanqui! ¿Imanirtan mana dëjanquitsu, imayca alli nänipa aywagnö Dios Yayata cäsurnin alli rurag runacunata, engañarnin mana alliman ticratsiyta? ");
INSERT INTO qxnNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tsaynö mana allicunata rurangayquipitam, Dios Yaya canan contrayqui car castigashuptiqui gapra ticranqui. Manam rupaypa atsicyayninta ricanquitsu, Dios Yaya munangan junagyag.” Tsaynam jina öra Elimas gapra ticrasquirnin, ñawin mana ricaptin tutapaychö aywayta mana puedir, pillatapis janchananpag rugacurnin tumaycachargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tsayta ricaycurnam gobernador Sergio Pauloga rasumpa criyicurgan, Diospa Palabran willacuyangan imaläya shumag cangan mantsacashga wiyarnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tsaypitanam Pabloga llapan compañagnincunawan Pafospita juc büquiman lätarcur, Panfilia provinciachö Perge puertuman aywayargan. Pero Juan Marcosnam tsay marcachö Pablotawan Bernabeta jagesquirnin, Jerusalénman cutirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tsay Perge puertupitam Pisidia provinciachö Antioquia marcaman päsayargan. Tsayman chaycurnam jamay junagchö Dios Yayaman mañacuyänanpag goricäyänan wajiman yaycusquir jamaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moiséswan unay profëtacuna gellgayangan ley libruta liyirnin ushasquirnam, tsay wajichö mas mandacug autoridäcuna invitarnin niyargan: “Waugecuna, caychö llapan goricashga runacuna mas animacuyänanpag imallatapis niyta munarga, canan niycayämay.” ");
INSERT INTO qxnNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsaynam apostol Pablo sharcurnin, llapan runacuna upällalla wiyayänanpag maquinwan sëñata rurarnin nirgan: “¡Wiyaycayämay Dios Yayata adorar cäsugnin Israel runacunawan juclä caru marcapita shamushga runacuna! ");
INSERT INTO qxnNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Llapan Israel runacunapa Diosninmi, unaycag ayllun israelcunata acrasquir juc poderöso naciunta rurargan. Tsaynöpam imayca caru juclä mana regeshga runacunanö Egipto naciunchö täcuycäyaptinpis, Dios Yaya imaycancuna cananpag yanapar mas atscaman miratsirgan. Tsaychö täcuycäyaptinmi, quiquin Dios Yaya poderöso cayninwan tsay Egipto naciunpita unay aylluntsiccunata jorgamurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios Yayam chuscu chunca wata mana ni imacag tsunyagchö llapan imayca mana alli ruraynincunatapis awantargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tsaynam Canaán niyangan marcachö ganchis naciun runacunata Dios Yaya ushacätsirgan. Tsaynö ushacascatsirmi tsay naciunnincunaman unaycag aylluntsiccunata imayca juc erenciancuna entregagnö churargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tsaycuna llapanmi cäsi chuscu pachac pitsga chunca wata cargan. “Tsaypitanam Dios Yaya mandacug jueznincuna churargan asta profëta Samuel niyanganta paycunaman cachamunganyag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tsaynam paycunaga juc rey mandacugnincuna cananpag Dios Yayata mañayargan. Tsaynö mañayaptinmi Benjamín grüpupita Cis niyanga runapa tsurin Saúlta chuscu chunca watayag mandacug reynincuna cananpag churargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsaypita mas unaytanam quiquin Dios Yaya Saúlta rey churanganpita jipisquir, Davidna rey cananpag churarnin nirgan: ‘Nogam tarishcä Isaípa tsurin David jucläya alli rurag runa car, shongochö llapan munangäcunata cumplinanpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Cay quiquin Davidpa unaycag ayllun shamugpitam, Dios Yaya Israel runacunata änicunganö Salvamagnintsic cachamungan Señor Jesucristo yurirgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Señor Jesucristo manarag shamuptinmi, Juan Bautista llapan Israel runacunata willacurnin purir nirgan: ‘Dios Yayaman cutirnin arepenticur bautizacuyay jutsayquicunapita perdonayäshunayquipag’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tsaynö willacurnin purir ushaycarnam Juan Bautista nirgan: ‘Manam nogatsu cä, gamcuna yarpäyangayquiga runa. Pero nogapa gepätam juc shamun. Manam nogaga serviytsu Paypa llagenpa watunllatapis pascanäpag.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Waugecuna y panicuna, Abrahampa aylluncuna y juclä caru marcapita runacuna Dios Yayata adorarnin cäsucugcuna, gamcunapagmi salvaciunpa cay Alli Willacuycunaga. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tsay Jerusalénchö täcugcunawan mas mandacug autoridänincunam, Señor Jesucristota mana regernin cäsuyargantsu. Tsaynö mana cäsurmi tsay quiquin runacuna Señor Jesucristota condenar, unay profëtacuna Diospa Palabranchö willacuyanganta cumpliyargan. Tsaymi cananga cada sabado jamay junagchö Dios Yayaman mañacuyänanpag goricäyänan wajichö tsay profëtacuna willacuyanganta yachatsicurnin liyiyan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aunqui Señor Jesucristopa ni ima jutsanta mana tariycarpis, Poncio Pilatotam mañayargan, soldäduncunawan wañutsinanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tsaynö unaypitana Paypag Diospa Palabran gellgashgachö ningannöllam, cruzchö wañuscatsirnin bäjascatsimur sepultüraman pampayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero quiquin Dios Yayam cawascatsimurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Cawamunganpitam atsca junagcunam Señor Jesucristo yuripurgan, Galilea provinciapita Jerusalénman compañarnin aywag runacunata. Tsaymi cananga tsay compañagnincuna Señor Jesucristopag imayca juc testïgunö llapan runacunata willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Tsaynöpam nogacuna canan cay cushicuypag Alli Willacuyta willayag: Unaycag aylluntsiccunata Dios Yaya äningantam, ");
INSERT INTO qxnNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","canan nogantsicpag cumplimushga paycunapa aylluncuna cangantsicpita. Caynö cumplirnin rurashga Tsurin Señor Jesucristota cawatsimurmi, ishcaycag Salmo gellgashgachö ningannöllam: ‘Gammi nogapa Tsurï canqui. Tsaymi canan junag musyayanga rasumpa Taytayqui cangäta’ nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios Yayaga Señor Jesucristopa cuerpun mana ismünanpag cawatsimunanpagmi unayna Palabranchö willacurnin nirgan: ‘Cumplishagmi rasumpacag sagrädu santo änicuynïwan Davidta äningäcunata.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tsaynöllam juclä gellgashgachöpis nirgan: ‘Manam permïtinquitsu servishugniqui santo Tsuriquipa cuerpun ismünantaga.’ ");
INSERT INTO qxnNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Tsaynöpam rasuncagtaga Dios Yaya mandarnin munangannölla Davidpis tsay tiempuchö mandacug rey cayninwan servirgan. Tsaypita David wañusquirnam unaycag aylluncunawan goricasquir, pampayanganchö cuerpunpis ismurnin ushacargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero Dios Yaya cawatsimungan Runapaga, cuerpunpis manam pampayanganchötsu ismurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Tsaymi cuyay waugelläcuna, cay willacuyangäta gamcunaga musyayänayqui Señor Jesucristoman rasumpa criyicuyangayquipita jutsayquicunapa perdonnin canganta. Tsaynö rasumpa firmi criyicugcunam cananga Dios Yayapa puntanchöpis jutsannagna cayanga, Moisés gellgangan leycunawan perdonta mana tarigcunapis. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Cuidädu cayay canan mana cäsucuyangayquipita unay profëtacuna gellgayangan gamcunaman mana shicwamunanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ricäyay, burlacur despreciagcuna mantsacashga wañuyay. Nogam gamcunapa tiempuyquicunachö alläpa mantsacäcuypagta rurashag, ni pï willayäshuptiquipis mana criyiyänayquipag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Dios Yayaman mañacuyänanpag judiucuna goricäyänan wajipita Pablowan Bernabe yargosquiyaptinnam, tsay runacuna rugayargan shamugcag jamay sabado junagchö tsay willacungancunata yapay yachatsiyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tsay wajiman llapan goricaycurnin Dios Yayaman mañacur ushasquirnam, atscag judiucunawan mana judiucaycar judiucayman ticrashga imaypis alli cumplïdu runacuna, Pablotawan Bernabeta gatirnin aywayargan. Tsaynam paycunaga tsay llapan runacunata consejayargan, Dios Yayapa alläpa cuyacuy poderninwan llapan bendiciunninchö paycuna imaypis firmi cawacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tsaypita juccag semäna shamug jamay junagchönam, tsay marcachö cäsi llapan runacuna goricäyargan Dios Yayapa Tsurin Señor Jesucristopa Alli Willacuyninta wiyayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero tsayman maytsicag runacuna goricashgata ricaycurmi, judiucunaga alläpa chiquicurnin apostol Pablopa contran shärir tucuyläya mana allicunata burlacurnin insultar gallaycuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsaynö insultayaptinnam Pablowan Bernabega ni imapita mana juc mantsacurnin contestayargan: “Nogacunapagam obligacionnïcuna can, puntata gam judiucunatarag Diospa Palabranta willayänagpag. Pero gamcunaga mana chasquirnin rechazayangayquipitam, quiquiquicuna jutsayog cayniquicunawan condenacurnin ni imaypis mana ushacag cawayta chasquiyänayquipagga merëcianquitsu. Tsaymi cananga mana judiucag runacunaman aywarnin Diospa Palabranta willacuyäshag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tsaynö willacuyänäpagmi quiquin Dios Yaya mandayämar niyämargan: ‘Gamtam mana judiucagcunapag maytsay naciuncunachö actsitanö churashcag, Nogapa salvacug willacuynïta cay mundupa mas carunincunaman apanayquipag.’ ” ");
INSERT INTO qxnNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pablo tsaynö ninganta wiyaycurnam, mana judiucagcuna alläpa cushicurnin gallaycuyargan: “Dios Yaya Alli Willacuyninta alläpa allim” nir. Tsaymi Dios Yaya mana ushacag cawayta tariyänanpag acrangancag runacuna, Señor Jesucristoman rasumpa firmi criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tsaynömi Diospa Palabranta maytsay marcacunapa Pablowan Bernabe aywarnin yachatsicur willacuyaptin, tsay llapan marcacunachö runacuna maytsaypa miratsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero judiucunanam tsay marcachö waquincag respetashga alläpa cuyapäcug warmicunawan y mas importanticag runacunawan parlayargan, Pablotawan Bernabeta chiquirnin gaticachar tsay provinciapita gargoyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsaynam Pablowan Bernabe tsay runacuna mana alli rurag cayanganpa contran imayca señaltanö, chaquincunachö polvu lashtacashgatapis tapsicusquirnin Iconio marcaman aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero tsay llapan criyicugcunanam alläpa cushishga caycäyargan, Espïritu Santopa poderninwan junta car. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tsaypitanam Iconio marcachö judiucuna goricäyänan wajiman Pablowan Bernabe yaycusquir yachatsicuyaptin, maytsicag judiucunawan mana judiucag runacunapis Señor Jesucristoman criyicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero mana criyicug judiucunanam alläpa chiquirnincuna Pablowan Bernabe yachatsicuyanganta mana cäsur despreciarnin, mana judiucag runacunatapis willaparnin timpullyätsiyargan. Tsaynö mana judiucagcunata timpullyätsirnin willaparmi, criyicug waugecunawan apostolcunapis mana alli rurag cayanganta yarpätsiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tsaynöpam apostol Pablowan Bernabega tsay Iconio marcachö mas unayyag quëdar, Señor Jesucristoman rasumpa confiacurnin ni imapita mana mantsacur rasumpacagcunallata yachatsicur willacuyargan. Tsaytam quiquin Señor Jesucristopis rasumpa musyatsicurgan, apostolcuna Dios Yayapa cuyacuy podernin mantsacaypag señalcunatawan milagrucuna rurayanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero tsay marcachö runacunanam judiucunapa janancagcunawan apostolcunapa waquincag janan cayaptin, imayca ishcay grüpuman raquicashganö cayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tsaynam judiucunawan mana judiucag runacunapis autoridänincunawan willanacuyargan, apostolcunata sagmarnin magayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero Pablowan Bernabe tsayta musyasquirnam, Licaonia provinciachö Listrawan Derbe marcacunapa geshpirnin aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tsay marcacunapa geshpirnin aywarmi, tsay marcacunchöpis Señor Jesucristopa Alli Willacuyninta yachatsicur willacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tsay Listra marcachömi yuringanpitana mana puriyta puedig, juc rata runa cargan. Tsay runam jamaycargan, ");
INSERT INTO qxnNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablo llapan willacunganta wiyarnin. Tsayta Pablo alli ricaraycurmi tantiyasquirgan, rasumpa firmi criyicur cuticänanpagcanganta. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tsaynam jinchi vozninwan gayargan: “¡Sharcurnin, derëchu ichiy chaquiquiwan!” nir. Tsaynö niycuptinnam, tsay rataga jina öra saltarnin sharcamur, purir gallaycurgan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tsaynö Pablo cuticätsinganta ricaycurnam, llapan runacuna Licaonia marcapa parlayninchö gayaycachar gallaycurnin niyargan: “¡Ricäyay dioscunam runatucur nogantsicman cielupita bäjayämushga!” nirnin. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tsaynam Bernabeta “Cayga dios Zeusmi” nir shutiscatsir, Pablotapis Diospa Palabranta imaypis mas willacuptin “Payga dios Hermesmi” niyargan. (Hermesga dios Zeuspa willacugninmi cargan.) ");
INSERT INTO qxnNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tsay marcaman yaycuna templunchö dios Zeusta servignin sacerdötim, törrucunatawan adornashga waytacunata tsay marcapita yargona puncuyag apamurgan. Tsaynam tsaychö llapan runacuna apostolcunata adorayta munar, törrucunata wañutsirnin sacrificiuta rurayta munayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero Bernabewan Pablonam tsaynö rurayänanpag yarpaycäyanganta musyasquir, llatapancunatapis rachisquirnin atscag runacunapa puntancunaman gayaycachar yaycusquiyargan: ");
INSERT INTO qxnNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Pero señorcuna, ¿imanirtan caycunata rurayta munayanqui? Nogacunaga gamcunanö runallam cayä. Nogacunam Señor Jesucristopa Alli Willacuyninta willayagniquicuna shayämushcä, caynö mana ni imapag servigcunata rurarnin caycäyangayquita dëjayänayquipag. Tsaypagmi willacug shayämushcä cawaycag Dios Yaya cieluta, patsata, lamarta llapan caychö ricaycangantsicunata rurag Diosman cutiyänayquipag. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aunqui unay tiempucunachöga quiquin Dios Yayam permïtirgan, llapan naciuncunachö runacunapis segun imatapis munayanganta rurar cawacuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tsaynö caycaptinpis imayca juc testïgunömi llapan allicunallata rurangancunawan rasumpa Dios Yaya pï canganta mana ni imaypis dëjarnin musyatsicurgan. Tsaynöpam Payga gamcunaman cachamun, tamyatawan alli cosëchacunata pacha junta micurnin cushishga cawacuyänayquipag.” ");
INSERT INTO qxnNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero tsaynö yarpäyanganta tucuyläya imaycanöpa willayaptinpis, törrucunata wañutsirnin sacrificiuta rurar adorayänanta amatsayänanpagga alläpa ajam cargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsaynö caycäyaptinnam, Antioquiapitawan Iconio marcacunapita judiucuna chaycur, tsay llapan runacunata apostolcunapag mana allicunata willarnin, Pablopa contran shäritsir sagmatsiyargan. Tsaynö alli sagmarnin apostol Pablota wañutsiyashgana canganta yarparmi, tsay marcapita garachashga apar jucläman jitasquiyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero tsay jitaraycanganman llapan criyicugcuna entërunpa tumag juntapusquiyaptinnam, Pabloga sharcamurnin yapay tsay marcaman cutirnin yaycurgan. Tsay waränin junagnam tsay marcapita yargosquir Pablowan Bernabe Derbe marcaman aywacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tsay Derbe marcachö yachatsicurnin Diospa Palabranta willacurmi, maytsicag runacunata Señor Jesucristoman criyicatsiyargan. Tsaynö yachatsicurnin willacusquirmi, Listrapawan Iconiopa y Antioquia marcacunaman cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tsay cada marca chäyanganchömi, Señor Jesucristoman llapan criyicugcunata criyicuynincunachö imaypis mas firmi cawayänanpag, mas animatsirnin consejar niyargan: “Dios Yayapa Mandacuy Reynonman yaycunapagga, tucuyläya sufrimientucunatam päsanantsic.” ");
INSERT INTO qxnNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tsaynöllam llapan criyicugcuna goricäyangan wajicunachö, respetashga auquincunata mandacuyänanpag churayargan. Tsaynö churasquirnam Dios Yayaman mañacur mallaglla ayunasquirnin, rasumpa criyicuyangan Señor Jesucristo yanapananpag rugacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tsaypitanam Pablowan Bernabe Pisidia provinciapa päsarnin, Panfilia provinciaman chäyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tsay provincia Perge marcachö Diospa Palabranta yachatsicurnin willacusquirmi, Atalia niyangan puertuman urayargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tsay puertupitanam büquiman lätarcur Antioquia marcaman aywayargan. Tsay marcachö criyicugcunam Pablotawan Bernabeta Diospa alläpa cuyacuy Palabranta yachatsicuyänanpag cachayangannölla willacur ushasquir cuticuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tsay Antioquia marcaman chaycuyaptinnam, llapan criyicugcuna goricäyänam wajiman goricascatsir, paycunawan Dios Yaya llapan imayca bendiciuncuna ruranganta willayargan. Tsaynöllam willayargan mana judiucag runacunatapis, Dios Yaya imayca puncuta quichapugnö chasquinganta, Señor Jesucristoman criyicuyänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tsaynam Pablowan Bernabe tsay marcachö criyicugcunawan unayyag quëdacuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tsay witsancunam Judea marcapita Antioquia marcaman waquincag urarnin aywashga runacuna criyicugcunata yachatsicur niyargan: “Si gamcuna unay Moisés leyninchö mandacungan costumbrincunata rurarnin cuerpuncunachö mana señalacurga, manam salvacuyta puediyanquitsu” nir. ");
INSERT INTO qxnNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tsay yachatsicugcunawanmi Pablowan Bernabe alli piñanacurnin discutiyargan. Tsaymi llapan criyicugcuna goricasquir willanacurnin Pablotawan Bernabeta nomrasquir waquincag criyicugmajincunatawan Jerusalénman cachayargan, tsaychö apostolcunawan y waquincag respetashga auquincunawan tsay asuntucunata arreglayänanpag. ");
INSERT INTO qxnNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tsaynö nomrasquir llapan criyicugcuna Jerusalénman cachayaptinmi, Feniciapawan Samaria marcacunapa päsarnin tsaychö criyicugcunata willacur niyargan: “Maytsay marca willacuyangächömi mana judiucag runacunapis, mana alli ruraynincunata dëjasquir arepenticurnin Señor Jesucristoman criyicuyashga” nir. Tsayta wiyaycurmi llapan criyicug waugecunapis alläpa cushicuyargan. ");
INSERT INTO qxnNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablowan Bernabe 